
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   67 ( 1144),  selected   67 , name 1nha_A
# Molecule2: number of CA atoms  134 ( 1070),  selected  134 , name T0443_97_230.pdb
# PARAMETERS: 1nha_A.T0443_97_230.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    D   451_A      S      97           -
LGA    V   452_A      D      98           -
LGA    Q   453_A      G      99           -
LGA    V   454_A      I     100           -
LGA    -       -      L     101           -
LGA    -       -      A     102           -
LGA    -       -      L     103           -
LGA    -       -      M     104           -
LGA    -       -      D     105           -
LGA    -       -      F     106           -
LGA    -       -      E     107           -
LGA    -       -      Y     108           -
LGA    -       -      T     109           -
LGA    -       -      Q     110           -
LGA    -       -      L     111           -
LGA    -       -      L     112           -
LGA    -       -      A     113           -
LGA    -       -      E     114           -
LGA    -       -      V     115           -
LGA    -       -      A     116           -
LGA    -       -      Q     117           -
LGA    -       -      I     118           -
LGA    -       -      P     119           -
LGA    -       -      D     120           -
LGA    -       -      I     121           -
LGA    -       -      P     122           -
LGA    -       -      D     123           -
LGA    -       -      I     124           -
LGA    -       -      H     125           -
LGA    -       -      Y     126           -
LGA    -       -      S     127           -
LGA    -       -      N     128           -
LGA    -       -      D     129           -
LGA    -       -      S     130           -
LGA    -       -      K     131           -
LGA    -       -      Y     132           -
LGA    -       -      T     133           -
LGA    -       -      P     134           -
LGA    -       -      S     135           -
LGA    -       -      P     136           -
LGA    -       -      A     137           -
LGA    -       -      A     138           -
LGA    -       -      F     139           -
LGA    -       -      I     140           -
LGA    -       -      R     141           -
LGA    -       -      Q     142           -
LGA    -       -      Y     143           -
LGA    -       -      R     144           -
LGA    -       -      Y     145           -
LGA    -       -      D     146           -
LGA    -       -      V     147           -
LGA    -       -      T     148           -
LGA    -       -      H     149           -
LGA    -       -      D     150           -
LGA    -       -      L     151           -
LGA    -       -      Q     152           -
LGA    -       -      E     153           -
LGA    -       -      A     154           -
LGA    -       -      E     155           -
LGA    -       -      T     156           -
LGA    -       -      A     157           -
LGA    -       -      L     158           -
LGA    -       -      L     159           -
LGA    -       -      I     160           -
LGA    -       -      W     161           -
LGA    -       -      R     162           -
LGA    -       -      N     163           -
LGA    -       -      A     164           -
LGA    -       -      E     165           -
LGA    -       -      D     166           -
LGA    -       -      D     167           -
LGA    -       -      V     168           -
LGA    -       -      M     169           -
LGA    -       -      Y     170           -
LGA    -       -      Q     171           -
LGA    -       -      T     172           -
LGA    -       -      L     173           -
LGA    -       -      D     174           -
LGA    T   455_A      G     175          6.249
LGA    E   456_A      F     176          5.107
LGA    D   457_A      D     177          1.336
LGA    -       -      M     178           -
LGA    A   458_A      M     179          3.372
LGA    V   459_A      L     180          2.338
LGA    R   460_A      L     181          1.716
LGA    R   461_A      E     182          2.553
LGA    Y   462_A      I     183          1.853
LGA    L   463_A      M     184          0.850
LGA    T   464_A      G     185          1.340
LGA    R   465_A      S     186          1.241
LGA    K   466_A      S     187          0.704
LGA    P   467_A      A     188          0.276
LGA    M   468_A      L     189          0.683
LGA    T   469_A      S     190          0.832
LGA    T   470_A      F     191          1.171
LGA    K   471_A      D     192          0.607
LGA    D   472_A      T     193          0.189
LGA    L   473_A      L     194          0.481
LGA    L   474_A      A     195          0.595
LGA    K   475_A      Q     196          0.903
LGA    K   476_A      T     197          1.447
LGA    F   477_A      L     198          0.544
LGA    Q   478_A      V     199          1.620
LGA    T   479_A      E     200          3.044
LGA    K   480_A      F     201          2.576
LGA    K   481_A      M     202          4.239
LGA    T   482_A      -       -           -
LGA    G   483_A      -       -           -
LGA    L   484_A      P     203          3.216
LGA    S   485_A      K     204          3.833
LGA    S   486_A      A     205          4.583
LGA    E   487_A      D     206          1.933
LGA    Q   488_A      N     207          1.654
LGA    T   489_A      W     208          2.323
LGA    V   490_A      K     209          1.437
LGA    N   491_A      N     210          0.957
LGA    V   492_A      I     211          1.464
LGA    L   493_A      L     212          1.313
LGA    A   494_A      L     213          0.724
LGA    Q   495_A      G     214          1.126
LGA    I   496_A      K     215          1.255
LGA    L   497_A      W     216          0.734
LGA    K   498_A      S     217          2.286
LGA    R   499_A      G     218          2.883
LGA    L   500_A      W     219          2.639
LGA    N   501_A      I     220          2.889
LGA    -       -      E     221           -
LGA    -       -      Q     222           -
LGA    -       -      R     223           -
LGA    -       -      I     224           -
LGA    P   502_A      I     225          1.497
LGA    E   503_A      I     226          0.783
LGA    R   504_A      P     227          0.549
LGA    K   505_A      S     228          1.320
LGA    M   506_A      L     229          2.920
LGA    I   507_A      S     230          4.438
LGA    N   508_A      -       -           -
LGA    D   509_A      -       -           -
LGA    K   510_A      -       -           -
LGA    M   511_A      -       -           -
LGA    H   512_A      -       -           -
LGA    F   513_A      -       -           -
LGA    S   514_A      -       -           -
LGA    L   515_A      -       -           -
LGA    K   516_A      -       -           -
LGA    E   517_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   67  134    5.0     51    2.32     7.84     32.197     2.105

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.131092 * X  +  -0.940802 * Y  +   0.312581 * Z  + -24.976328
  Y_new =  -0.152034 * X  +   0.330651 * Y  +   0.931427 * Z  +  -2.033087
  Z_new =  -0.979643 * X  +   0.074580 * Y  +  -0.186379 * Z  +  30.885382 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.760956   -0.380637  [ DEG:   158.1911    -21.8089 ]
  Theta =   1.368676    1.772916  [ DEG:    78.4194    101.5806 ]
  Phi   =  -2.282363    0.859229  [ DEG:  -130.7698     49.2302 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1nha_A                                        
REMARK     2: T0443_97_230.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1nha_A.T0443_97_230.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   67  134   5.0   51   2.32    7.84  32.197
REMARK  ---------------------------------------------------------- 
MOLECULE 1nha_A
HEADER    TRANSCRIPTION                           19-DEC-02   1NHA              
TITLE     SOLUTION STRUCTURE OF THE CARBOXYL-TERMINAL DOMAIN OF RAP74           
TITLE    2 AND NMR CHARACTERIZATION OF THE FCP-BINDING SITES OF RAP74           
TITLE    3 AND CTD OF RAP74, THE SUBUNIT OF HUMAN TFIIF                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRANSCRIPTION INITIATION FACTOR IIF, ALPHA                 
COMPND   3 SUBUNIT;                                                             
COMPND   4 CHAIN: A;                                                            
COMPND   5 FRAGMENT: C-TERMINAL DOMAIN;                                         
COMPND   6 SYNONYM: TFIIF-ALPHA;                                                
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: RAP74;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PGEX;                                 
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: GST-2T                                    
KEYWDS    TRANSCRIPTION FACTOR, HUMAN GENERAL TRANSCRIPTION FACTOR              
KEYWDS   2 TFIIF, RAP74                                                         
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    B.D.NGUYEN,H.T.CHEN,M.S.KOBOR,J.GREENBLATT,P.LEGAULT,                 
AUTHOR   2 J.G.OMICHINSKI                                                       
REVDAT   1   25-FEB-03 1NHA    0                                                
JRNL        AUTH   B.D.NGUYEN,H.T.CHEN,M.S.KOBOR,J.GREENBLATT,                  
JRNL        AUTH 2 P.LEGAULT,J.G.OMICHINSKI                                     
JRNL        TITL   SOLUTION STRUCTURE OF THE CARBOXYL-TERMINAL DOMAIN           
JRNL        TITL 2 OF RAP74 AND NMR CHARACTERIZATION OF THE                     
JRNL        TITL 3 FCP1-BINDING SITES OF RAP74 AND HUMAN TFIIB.                 
JRNL        REF    BIOCHEMISTRY                  V.  42  1460 2003              
JRNL        REFN   ASTM BICHAW  US ISSN 0006-2960                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1NHA A  436   517  UNP    P35269   T2FA_HUMAN     436    517             
SEQRES   1 A   82  SER THR PRO GLN PRO PRO SER GLY LYS THR THR PRO ASN          
SEQRES   2 A   82  SER GLY ASP VAL GLN VAL THR GLU ASP ALA VAL ARG ARG          
SEQRES   3 A   82  TYR LEU THR ARG LYS PRO MET THR THR LYS ASP LEU LEU          
SEQRES   4 A   82  LYS LYS PHE GLN THR LYS LYS THR GLY LEU SER SER GLU          
SEQRES   5 A   82  GLN THR VAL ASN VAL LEU ALA GLN ILE LEU LYS ARG LEU          
SEQRES   6 A   82  ASN PRO GLU ARG LYS MET ILE ASN ASP LYS MET HIS PHE          
SEQRES   7 A   82  SER LEU LYS GLU                                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   ASP A 451     -18.710   1.494  50.208  1.00  0.00           N  
ATOM      2  CA  ASP A 451     -19.919   1.712  49.372  1.00  0.00           C  
ATOM      3  C   ASP A 451     -19.647   1.376  47.909  1.00  0.00           C  
ATOM      4  O   ASP A 451     -18.522   1.514  47.429  1.00  0.00           O  
ATOM      5  CB  ASP A 451     -20.347   3.174  49.507  1.00  0.00           C  
ATOM      6  CG  ASP A 451     -20.805   3.517  50.911  1.00  0.00           C  
ATOM      7  OD1 ASP A 451     -21.092   2.581  51.687  1.00  0.00           O  
ATOM      8  OD2 ASP A 451     -20.875   4.722  51.234  1.00  0.00           O  
ATOM      9  HA  ASP A 451     -20.710   1.075  49.739  1.00  0.00           H  
ATOM     10  HB2 ASP A 451     -19.512   3.812  49.255  1.00  0.00           H  
ATOM     11  HB3 ASP A 451     -21.161   3.369  48.824  1.00  0.00           H  
ATOM     12  N   VAL A 452     -20.684   0.933  47.206  1.00  0.00           N  
ATOM     13  CA  VAL A 452     -20.556   0.577  45.799  1.00  0.00           C  
ATOM     14  C   VAL A 452     -21.433   1.467  44.925  1.00  0.00           C  
ATOM     15  O   VAL A 452     -22.607   1.687  45.224  1.00  0.00           O  
ATOM     16  CB  VAL A 452     -20.939  -0.895  45.555  1.00  0.00           C  
ATOM     17  CG1 VAL A 452     -20.622  -1.302  44.123  1.00  0.00           C  
ATOM     18  CG2 VAL A 452     -20.224  -1.803  46.544  1.00  0.00           C  
ATOM     19  H   VAL A 452     -21.556   0.844  47.645  1.00  0.00           H  
ATOM     20  HA  VAL A 452     -19.524   0.711  45.511  1.00  0.00           H  
ATOM     21  HB  VAL A 452     -22.003  -1.000  45.707  1.00  0.00           H  
ATOM     22 HG11 VAL A 452     -19.557  -1.435  44.014  1.00  0.00           H  
ATOM     23 HG12 VAL A 452     -20.960  -0.529  43.448  1.00  0.00           H  
ATOM     24 HG13 VAL A 452     -21.127  -2.228  43.891  1.00  0.00           H  
ATOM     25 HG21 VAL A 452     -20.466  -1.498  47.551  1.00  0.00           H  
ATOM     26 HG22 VAL A 452     -19.158  -1.732  46.393  1.00  0.00           H  
ATOM     27 HG23 VAL A 452     -20.543  -2.824  46.391  1.00  0.00           H  
ATOM     28  N   GLN A 453     -20.855   1.980  43.842  1.00  0.00           N  
ATOM     29  CA  GLN A 453     -21.583   2.847  42.924  1.00  0.00           C  
ATOM     30  C   GLN A 453     -21.443   2.357  41.486  1.00  0.00           C  
ATOM     31  O   GLN A 453     -20.519   1.611  41.162  1.00  0.00           O  
ATOM     32  CB  GLN A 453     -21.074   4.285  43.038  1.00  0.00           C  
ATOM     33  CG  GLN A 453     -21.292   4.901  44.409  1.00  0.00           C  
ATOM     34  CD  GLN A 453     -20.742   6.312  44.509  1.00  0.00           C  
ATOM     35  OE1 GLN A 453     -19.950   6.742  43.672  1.00  0.00           O  
ATOM     36  NE2 GLN A 453     -21.162   7.038  45.539  1.00  0.00           N  
ATOM     37  H   GLN A 453     -19.916   1.768  43.657  1.00  0.00           H  
ATOM     38  HA  GLN A 453     -22.626   2.822  43.201  1.00  0.00           H  
ATOM     39  HB2 GLN A 453     -20.016   4.299  42.823  1.00  0.00           H  
ATOM     40  HB3 GLN A 453     -21.587   4.896  42.308  1.00  0.00           H  
ATOM     41  HG2 GLN A 453     -22.351   4.929  44.614  1.00  0.00           H  
ATOM     42  HG3 GLN A 453     -20.800   4.286  45.149  1.00  0.00           H  
ATOM     43 HE21 GLN A 453     -21.793   6.628  46.167  1.00  0.00           H  
ATOM     44 HE22 GLN A 453     -20.823   7.953  45.627  1.00  0.00           H  
ATOM     45  N   VAL A 454     -22.365   2.783  40.629  1.00  0.00           N  
ATOM     46  CA  VAL A 454     -22.343   2.386  39.225  1.00  0.00           C  
ATOM     47  C   VAL A 454     -21.954   3.558  38.331  1.00  0.00           C  
ATOM     48  O   VAL A 454     -22.505   4.654  38.449  1.00  0.00           O  
ATOM     49  CB  VAL A 454     -23.712   1.845  38.774  1.00  0.00           C  
ATOM     50  CG1 VAL A 454     -23.623   1.274  37.367  1.00  0.00           C  
ATOM     51  CG2 VAL A 454     -24.220   0.796  39.752  1.00  0.00           C  
ATOM     52  H   VAL A 454     -23.078   3.376  40.948  1.00  0.00           H  
ATOM     53  HA  VAL A 454     -21.612   1.599  39.111  1.00  0.00           H  
ATOM     54  HB  VAL A 454     -24.415   2.664  38.761  1.00  0.00           H  
ATOM     55 HG11 VAL A 454     -23.552   2.081  36.654  1.00  0.00           H  
ATOM     56 HG12 VAL A 454     -24.507   0.687  37.160  1.00  0.00           H  
ATOM     57 HG13 VAL A 454     -22.747   0.645  37.287  1.00  0.00           H  
ATOM     58 HG21 VAL A 454     -23.702  -0.136  39.581  1.00  0.00           H  
ATOM     59 HG22 VAL A 454     -25.280   0.651  39.606  1.00  0.00           H  
ATOM     60 HG23 VAL A 454     -24.039   1.129  40.763  1.00  0.00           H  
ATOM     61  N   THR A 455     -21.000   3.321  37.436  1.00  0.00           N  
ATOM     62  CA  THR A 455     -20.536   4.357  36.521  1.00  0.00           C  
ATOM     63  C   THR A 455     -20.560   3.858  35.079  1.00  0.00           C  
ATOM     64  O   THR A 455     -20.690   2.660  34.827  1.00  0.00           O  
ATOM     65  CB  THR A 455     -19.121   4.803  36.895  1.00  0.00           C  
ATOM     66  OG1 THR A 455     -18.170   3.828  36.506  1.00  0.00           O  
ATOM     67  CG2 THR A 455     -18.947   5.050  38.378  1.00  0.00           C  
ATOM     68  H   THR A 455     -20.599   2.429  37.391  1.00  0.00           H  
ATOM     69  HA  THR A 455     -21.205   5.200  36.607  1.00  0.00           H  
ATOM     70  HB  THR A 455     -18.896   5.723  36.377  1.00  0.00           H  
ATOM     71  HG1 THR A 455     -17.285   4.166  36.660  1.00  0.00           H  
ATOM     72 HG21 THR A 455     -18.200   4.374  38.769  1.00  0.00           H  
ATOM     73 HG22 THR A 455     -19.886   4.883  38.884  1.00  0.00           H  
ATOM     74 HG23 THR A 455     -18.627   6.069  38.537  1.00  0.00           H  
ATOM     75  N   GLU A 456     -20.432   4.786  34.135  1.00  0.00           N  
ATOM     76  CA  GLU A 456     -20.439   4.440  32.718  1.00  0.00           C  
ATOM     77  C   GLU A 456     -19.301   3.480  32.387  1.00  0.00           C  
ATOM     78  O   GLU A 456     -19.448   2.591  31.548  1.00  0.00           O  
ATOM     79  CB  GLU A 456     -20.320   5.703  31.863  1.00  0.00           C  
ATOM     80  CG  GLU A 456     -21.527   6.622  31.961  1.00  0.00           C  
ATOM     81  CD  GLU A 456     -21.398   7.850  31.083  1.00  0.00           C  
ATOM     82  OE1 GLU A 456     -20.671   8.787  31.475  1.00  0.00           O  
ATOM     83  OE2 GLU A 456     -22.022   7.874  30.002  1.00  0.00           O  
ATOM     84  H   GLU A 456     -20.332   5.725  34.397  1.00  0.00           H  
ATOM     85  HA  GLU A 456     -21.378   3.954  32.499  1.00  0.00           H  
ATOM     86  HB2 GLU A 456     -19.447   6.256  32.177  1.00  0.00           H  
ATOM     87  HB3 GLU A 456     -20.200   5.413  30.829  1.00  0.00           H  
ATOM     88  HG2 GLU A 456     -22.407   6.074  31.660  1.00  0.00           H  
ATOM     89  HG3 GLU A 456     -21.636   6.941  32.988  1.00  0.00           H  
ATOM     90  N   ASP A 457     -18.165   3.666  33.052  1.00  0.00           N  
ATOM     91  CA  ASP A 457     -17.000   2.819  32.831  1.00  0.00           C  
ATOM     92  C   ASP A 457     -17.318   1.360  33.146  1.00  0.00           C  
ATOM     93  O   ASP A 457     -16.833   0.449  32.477  1.00  0.00           O  
ATOM     94  CB  ASP A 457     -15.826   3.292  33.688  1.00  0.00           C  
ATOM     95  CG  ASP A 457     -14.534   2.578  33.347  1.00  0.00           C  
ATOM     96  OD1 ASP A 457     -13.845   3.016  32.402  1.00  0.00           O  
ATOM     97  OD2 ASP A 457     -14.210   1.580  34.025  1.00  0.00           O  
ATOM     98  H   ASP A 457     -18.110   4.391  33.709  1.00  0.00           H  
ATOM     99  HA  ASP A 457     -16.728   2.897  31.789  1.00  0.00           H  
ATOM    100  HB2 ASP A 457     -15.680   4.352  33.535  1.00  0.00           H  
ATOM    101  HB3 ASP A 457     -16.052   3.112  34.730  1.00  0.00           H  
ATOM    102  N   ALA A 458     -18.137   1.149  34.171  1.00  0.00           N  
ATOM    103  CA  ALA A 458     -18.519  -0.199  34.577  1.00  0.00           C  
ATOM    104  C   ALA A 458     -19.258  -0.922  33.456  1.00  0.00           C  
ATOM    105  O   ALA A 458     -18.860  -2.009  33.038  1.00  0.00           O  
ATOM    106  CB  ALA A 458     -19.381  -0.147  35.830  1.00  0.00           C  
ATOM    107  H   ALA A 458     -18.493   1.916  34.668  1.00  0.00           H  
ATOM    108  HA  ALA A 458     -17.618  -0.745  34.811  1.00  0.00           H  
ATOM    109  HB1 ALA A 458     -20.249   0.465  35.646  1.00  0.00           H  
ATOM    110  HB2 ALA A 458     -18.808   0.277  36.642  1.00  0.00           H  
ATOM    111  HB3 ALA A 458     -19.694  -1.147  36.094  1.00  0.00           H  
ATOM    112  N   VAL A 459     -20.334  -0.311  32.971  1.00  0.00           N  
ATOM    113  CA  VAL A 459     -21.127  -0.898  31.898  1.00  0.00           C  
ATOM    114  C   VAL A 459     -20.332  -0.951  30.597  1.00  0.00           C  
ATOM    115  O   VAL A 459     -20.391  -1.937  29.863  1.00  0.00           O  
ATOM    116  CB  VAL A 459     -22.427  -0.104  31.661  1.00  0.00           C  
ATOM    117  CG1 VAL A 459     -23.300  -0.802  30.629  1.00  0.00           C  
ATOM    118  CG2 VAL A 459     -23.184   0.085  32.967  1.00  0.00           C  
ATOM    119  H   VAL A 459     -20.602   0.553  33.346  1.00  0.00           H  
ATOM    120  HA  VAL A 459     -21.391  -1.904  32.189  1.00  0.00           H  
ATOM    121  HB  VAL A 459     -22.166   0.870  31.276  1.00  0.00           H  
ATOM    122 HG11 VAL A 459     -23.007  -0.491  29.637  1.00  0.00           H  
ATOM    123 HG12 VAL A 459     -24.336  -0.542  30.797  1.00  0.00           H  
ATOM    124 HG13 VAL A 459     -23.180  -1.872  30.719  1.00  0.00           H  
ATOM    125 HG21 VAL A 459     -23.955  -0.667  33.049  1.00  0.00           H  
ATOM    126 HG22 VAL A 459     -23.635   1.066  32.982  1.00  0.00           H  
ATOM    127 HG23 VAL A 459     -22.499  -0.009  33.797  1.00  0.00           H  
ATOM    128  N   ARG A 460     -19.590   0.115  30.319  1.00  0.00           N  
ATOM    129  CA  ARG A 460     -18.783   0.191  29.108  1.00  0.00           C  
ATOM    130  C   ARG A 460     -17.764  -0.943  29.057  1.00  0.00           C  
ATOM    131  O   ARG A 460     -17.463  -1.475  27.988  1.00  0.00           O  
ATOM    132  CB  ARG A 460     -18.064   1.540  29.032  1.00  0.00           C  
ATOM    133  CG  ARG A 460     -17.273   1.736  27.751  1.00  0.00           C  
ATOM    134  CD  ARG A 460     -16.557   3.077  27.739  1.00  0.00           C  
ATOM    135  NE  ARG A 460     -16.003   3.391  26.424  1.00  0.00           N  
ATOM    136  CZ  ARG A 460     -15.659   4.619  26.038  1.00  0.00           C  
ATOM    137  NH1 ARG A 460     -15.806   5.647  26.863  1.00  0.00           N  
ATOM    138  NH2 ARG A 460     -15.165   4.817  24.823  1.00  0.00           N  
ATOM    139  H   ARG A 460     -19.586   0.869  30.945  1.00  0.00           H  
ATOM    140  HA  ARG A 460     -19.446   0.100  28.261  1.00  0.00           H  
ATOM    141  HB2 ARG A 460     -18.797   2.329  29.103  1.00  0.00           H  
ATOM    142  HB3 ARG A 460     -17.383   1.618  29.867  1.00  0.00           H  
ATOM    143  HG2 ARG A 460     -16.540   0.949  27.666  1.00  0.00           H  
ATOM    144  HG3 ARG A 460     -17.950   1.693  26.910  1.00  0.00           H  
ATOM    145  HD2 ARG A 460     -17.260   3.849  28.015  1.00  0.00           H  
ATOM    146  HD3 ARG A 460     -15.753   3.048  28.460  1.00  0.00           H  
ATOM    147  HE  ARG A 460     -15.883   2.650  25.795  1.00  0.00           H  
ATOM    148 HH11 ARG A 460     -16.176   5.505  27.780  1.00  0.00           H  
ATOM    149 HH12 ARG A 460     -15.544   6.566  26.568  1.00  0.00           H  
ATOM    150 HH21 ARG A 460     -15.051   4.045  24.197  1.00  0.00           H  
ATOM    151 HH22 ARG A 460     -14.906   5.738  24.532  1.00  0.00           H  
ATOM    152  N   ARG A 461     -17.235  -1.309  30.220  1.00  0.00           N  
ATOM    153  CA  ARG A 461     -16.251  -2.381  30.311  1.00  0.00           C  
ATOM    154  C   ARG A 461     -16.803  -3.683  29.738  1.00  0.00           C  
ATOM    155  O   ARG A 461     -16.098  -4.417  29.047  1.00  0.00           O  
ATOM    156  CB  ARG A 461     -15.825  -2.589  31.766  1.00  0.00           C  
ATOM    157  CG  ARG A 461     -14.646  -3.534  31.926  1.00  0.00           C  
ATOM    158  CD  ARG A 461     -15.102  -4.980  32.033  1.00  0.00           C  
ATOM    159  NE  ARG A 461     -14.027  -5.860  32.486  1.00  0.00           N  
ATOM    160  CZ  ARG A 461     -14.072  -7.188  32.406  1.00  0.00           C  
ATOM    161  NH1 ARG A 461     -15.134  -7.792  31.889  1.00  0.00           N  
ATOM    162  NH2 ARG A 461     -13.050  -7.912  32.842  1.00  0.00           N  
ATOM    163  H   ARG A 461     -17.514  -0.847  31.038  1.00  0.00           H  
ATOM    164  HA  ARG A 461     -15.387  -2.086  29.732  1.00  0.00           H  
ATOM    165  HB2 ARG A 461     -15.553  -1.632  32.189  1.00  0.00           H  
ATOM    166  HB3 ARG A 461     -16.659  -2.993  32.318  1.00  0.00           H  
ATOM    167  HG2 ARG A 461     -13.997  -3.434  31.068  1.00  0.00           H  
ATOM    168  HG3 ARG A 461     -14.104  -3.269  32.821  1.00  0.00           H  
ATOM    169  HD2 ARG A 461     -15.919  -5.035  32.737  1.00  0.00           H  
ATOM    170  HD3 ARG A 461     -15.439  -5.310  31.062  1.00  0.00           H  
ATOM    171  HE  ARG A 461     -13.230  -5.439  32.873  1.00  0.00           H  
ATOM    172 HH11 ARG A 461     -15.907  -7.253  31.558  1.00  0.00           H  
ATOM    173 HH12 ARG A 461     -15.161  -8.791  31.830  1.00  0.00           H  
ATOM    174 HH21 ARG A 461     -12.247  -7.463  33.231  1.00  0.00           H  
ATOM    175 HH22 ARG A 461     -13.083  -8.911  32.781  1.00  0.00           H  
ATOM    176  N   TYR A 462     -18.068  -3.962  30.035  1.00  0.00           N  
ATOM    177  CA  TYR A 462     -18.715  -5.178  29.551  1.00  0.00           C  
ATOM    178  C   TYR A 462     -18.961  -5.104  28.047  1.00  0.00           C  
ATOM    179  O   TYR A 462     -18.786  -6.090  27.330  1.00  0.00           O  
ATOM    180  CB  TYR A 462     -20.038  -5.402  30.284  1.00  0.00           C  
ATOM    181  CG  TYR A 462     -19.881  -5.600  31.776  1.00  0.00           C  
ATOM    182  CD1 TYR A 462     -19.571  -6.849  32.300  1.00  0.00           C  
ATOM    183  CD2 TYR A 462     -20.041  -4.539  32.657  1.00  0.00           C  
ATOM    184  CE1 TYR A 462     -19.427  -7.035  33.661  1.00  0.00           C  
ATOM    185  CE2 TYR A 462     -19.898  -4.718  34.020  1.00  0.00           C  
ATOM    186  CZ  TYR A 462     -19.591  -5.966  34.516  1.00  0.00           C  
ATOM    187  OH  TYR A 462     -19.447  -6.147  35.874  1.00  0.00           O  
ATOM    188  H   TYR A 462     -18.578  -3.339  30.592  1.00  0.00           H  
ATOM    189  HA  TYR A 462     -18.056  -6.007  29.755  1.00  0.00           H  
ATOM    190  HB2 TYR A 462     -20.676  -4.544  30.131  1.00  0.00           H  
ATOM    191  HB3 TYR A 462     -20.521  -6.280  29.881  1.00  0.00           H  
ATOM    192  HD1 TYR A 462     -19.442  -7.684  31.627  1.00  0.00           H  
ATOM    193  HD2 TYR A 462     -20.282  -3.563  32.266  1.00  0.00           H  
ATOM    194  HE1 TYR A 462     -19.185  -8.014  34.050  1.00  0.00           H  
ATOM    195  HE2 TYR A 462     -20.025  -3.880  34.690  1.00  0.00           H  
ATOM    196  HH  TYR A 462     -20.251  -6.530  36.232  1.00  0.00           H  
ATOM    197  N   LEU A 463     -19.371  -3.930  27.576  1.00  0.00           N  
ATOM    198  CA  LEU A 463     -19.644  -3.730  26.158  1.00  0.00           C  
ATOM    199  C   LEU A 463     -18.384  -3.934  25.322  1.00  0.00           C  
ATOM    200  O   LEU A 463     -18.432  -4.524  24.243  1.00  0.00           O  
ATOM    201  CB  LEU A 463     -20.207  -2.327  25.919  1.00  0.00           C  
ATOM    202  CG  LEU A 463     -21.568  -2.059  26.563  1.00  0.00           C  
ATOM    203  CD1 LEU A 463     -21.914  -0.581  26.484  1.00  0.00           C  
ATOM    204  CD2 LEU A 463     -22.647  -2.898  25.894  1.00  0.00           C  
ATOM    205  H   LEU A 463     -19.493  -3.183  28.198  1.00  0.00           H  
ATOM    206  HA  LEU A 463     -20.381  -4.459  25.856  1.00  0.00           H  
ATOM    207  HB2 LEU A 463     -19.500  -1.608  26.307  1.00  0.00           H  
ATOM    208  HB3 LEU A 463     -20.302  -2.176  24.855  1.00  0.00           H  
ATOM    209  HG  LEU A 463     -21.526  -2.337  27.607  1.00  0.00           H  
ATOM    210 HD11 LEU A 463     -22.282  -0.348  25.495  1.00  0.00           H  
ATOM    211 HD12 LEU A 463     -21.031   0.007  26.687  1.00  0.00           H  
ATOM    212 HD13 LEU A 463     -22.675  -0.349  27.214  1.00  0.00           H  
ATOM    213 HD21 LEU A 463     -22.862  -2.492  24.915  1.00  0.00           H  
ATOM    214 HD22 LEU A 463     -23.543  -2.879  26.497  1.00  0.00           H  
ATOM    215 HD23 LEU A 463     -22.301  -3.915  25.793  1.00  0.00           H  
ATOM    216  N   THR A 464     -17.258  -3.443  25.829  1.00  0.00           N  
ATOM    217  CA  THR A 464     -15.989  -3.570  25.131  1.00  0.00           C  
ATOM    218  C   THR A 464     -15.568  -5.033  25.027  1.00  0.00           C  
ATOM    219  O   THR A 464     -14.919  -5.436  24.061  1.00  0.00           O  
ATOM    220  CB  THR A 464     -14.914  -2.767  25.858  1.00  0.00           C  
ATOM    221  OG1 THR A 464     -14.786  -3.198  27.202  1.00  0.00           O  
ATOM    222  CG2 THR A 464     -15.190  -1.278  25.878  1.00  0.00           C  
ATOM    223  H   THR A 464     -17.279  -2.982  26.691  1.00  0.00           H  
ATOM    224  HA  THR A 464     -16.113  -3.171  24.136  1.00  0.00           H  
ATOM    225  HB  THR A 464     -13.971  -2.920  25.364  1.00  0.00           H  
ATOM    226  HG1 THR A 464     -15.566  -2.939  27.699  1.00  0.00           H  
ATOM    227 HG21 THR A 464     -14.417  -0.761  25.328  1.00  0.00           H  
ATOM    228 HG22 THR A 464     -15.200  -0.927  26.899  1.00  0.00           H  
ATOM    229 HG23 THR A 464     -16.148  -1.083  25.420  1.00  0.00           H  
ATOM    230  N   ARG A 465     -15.944  -5.824  26.027  1.00  0.00           N  
ATOM    231  CA  ARG A 465     -15.606  -7.242  26.046  1.00  0.00           C  
ATOM    232  C   ARG A 465     -16.545  -8.037  25.147  1.00  0.00           C  
ATOM    233  O   ARG A 465     -16.112  -8.691  24.199  1.00  0.00           O  
ATOM    234  CB  ARG A 465     -15.671  -7.785  27.476  1.00  0.00           C  
ATOM    235  CG  ARG A 465     -14.547  -7.282  28.368  1.00  0.00           C  
ATOM    236  CD  ARG A 465     -13.193  -7.780  27.890  1.00  0.00           C  
ATOM    237  NE  ARG A 465     -12.131  -7.483  28.851  1.00  0.00           N  
ATOM    238  CZ  ARG A 465     -11.910  -8.195  29.953  1.00  0.00           C  
ATOM    239  NH1 ARG A 465     -12.672  -9.241  30.241  1.00  0.00           N  
ATOM    240  NH2 ARG A 465     -10.922  -7.858  30.771  1.00  0.00           N  
ATOM    241  H   ARG A 465     -16.461  -5.445  26.768  1.00  0.00           H  
ATOM    242  HA  ARG A 465     -14.602  -7.348  25.675  1.00  0.00           H  
ATOM    243  HB2 ARG A 465     -16.611  -7.490  27.917  1.00  0.00           H  
ATOM    244  HB3 ARG A 465     -15.619  -8.863  27.442  1.00  0.00           H  
ATOM    245  HG2 ARG A 465     -14.547  -6.201  28.356  1.00  0.00           H  
ATOM    246  HG3 ARG A 465     -14.716  -7.634  29.375  1.00  0.00           H  
ATOM    247  HD2 ARG A 465     -13.247  -8.849  27.748  1.00  0.00           H  
ATOM    248  HD3 ARG A 465     -12.959  -7.302  26.951  1.00  0.00           H  
ATOM    249  HE  ARG A 465     -11.552  -6.715  28.662  1.00  0.00           H  
ATOM    250 HH11 ARG A 465     -13.420  -9.500  29.629  1.00  0.00           H  
ATOM    251 HH12 ARG A 465     -12.501  -9.772  31.071  1.00  0.00           H  
ATOM    252 HH21 ARG A 465     -10.343  -7.070  30.559  1.00  0.00           H  
ATOM    253 HH22 ARG A 465     -10.755  -8.392  31.600  1.00  0.00           H  
ATOM    254  N   LYS A 466     -17.832  -7.970  25.454  1.00  0.00           N  
ATOM    255  CA  LYS A 466     -18.844  -8.679  24.677  1.00  0.00           C  
ATOM    256  C   LYS A 466     -20.146  -7.884  24.624  1.00  0.00           C  
ATOM    257  O   LYS A 466     -20.463  -7.134  25.547  1.00  0.00           O  
ATOM    258  CB  LYS A 466     -19.101 -10.062  25.279  1.00  0.00           C  
ATOM    259  CG  LYS A 466     -19.351 -10.036  26.778  1.00  0.00           C  
ATOM    260  CD  LYS A 466     -19.252 -11.428  27.382  1.00  0.00           C  
ATOM    261  CE  LYS A 466     -20.621 -12.069  27.528  1.00  0.00           C  
ATOM    262  NZ  LYS A 466     -20.727 -12.880  28.772  1.00  0.00           N  
ATOM    263  H   LYS A 466     -18.109  -7.430  26.221  1.00  0.00           H  
ATOM    264  HA  LYS A 466     -18.467  -8.798  23.673  1.00  0.00           H  
ATOM    265  HB2 LYS A 466     -19.967 -10.495  24.798  1.00  0.00           H  
ATOM    266  HB3 LYS A 466     -18.243 -10.690  25.089  1.00  0.00           H  
ATOM    267  HG2 LYS A 466     -18.614  -9.398  27.245  1.00  0.00           H  
ATOM    268  HG3 LYS A 466     -20.340  -9.643  26.962  1.00  0.00           H  
ATOM    269  HD2 LYS A 466     -18.641 -12.045  26.741  1.00  0.00           H  
ATOM    270  HD3 LYS A 466     -18.793 -11.353  28.357  1.00  0.00           H  
ATOM    271  HE2 LYS A 466     -21.370 -11.291  27.551  1.00  0.00           H  
ATOM    272  HE3 LYS A 466     -20.796 -12.710  26.676  1.00  0.00           H  
ATOM    273  HZ1 LYS A 466     -21.325 -13.714  28.606  1.00  0.00           H  
ATOM    274  HZ2 LYS A 466     -21.146 -12.312  29.535  1.00  0.00           H  
ATOM    275  HZ3 LYS A 466     -19.782 -13.198  29.072  1.00  0.00           H  
ATOM    276  N   PRO A 467     -20.921  -8.039  23.537  1.00  0.00           N  
ATOM    277  CA  PRO A 467     -22.195  -7.333  23.370  1.00  0.00           C  
ATOM    278  C   PRO A 467     -23.265  -7.832  24.335  1.00  0.00           C  
ATOM    279  O   PRO A 467     -23.503  -9.033  24.446  1.00  0.00           O  
ATOM    280  CB  PRO A 467     -22.590  -7.646  21.925  1.00  0.00           C  
ATOM    281  CG  PRO A 467     -21.906  -8.933  21.616  1.00  0.00           C  
ATOM    282  CD  PRO A 467     -20.619  -8.915  22.391  1.00  0.00           C  
ATOM    283  HA  PRO A 467     -22.073  -6.265  23.489  1.00  0.00           H  
ATOM    284  HB2 PRO A 467     -23.663  -7.741  21.855  1.00  0.00           H  
ATOM    285  HB3 PRO A 467     -22.250  -6.854  21.275  1.00  0.00           H  
ATOM    286  HG2 PRO A 467     -22.523  -9.761  21.933  1.00  0.00           H  
ATOM    287  HG3 PRO A 467     -21.707  -8.998  20.556  1.00  0.00           H  
ATOM    288  HD2 PRO A 467     -20.364  -9.911  22.722  1.00  0.00           H  
ATOM    289  HD3 PRO A 467     -19.822  -8.501  21.789  1.00  0.00           H  
ATOM    290  N   MET A 468     -23.907  -6.899  25.032  1.00  0.00           N  
ATOM    291  CA  MET A 468     -24.953  -7.246  25.989  1.00  0.00           C  
ATOM    292  C   MET A 468     -26.198  -6.392  25.768  1.00  0.00           C  
ATOM    293  O   MET A 468     -26.115  -5.279  25.248  1.00  0.00           O  
ATOM    294  CB  MET A 468     -24.444  -7.063  27.420  1.00  0.00           C  
ATOM    295  CG  MET A 468     -23.262  -7.956  27.763  1.00  0.00           C  
ATOM    296  SD  MET A 468     -22.795  -7.855  29.501  1.00  0.00           S  
ATOM    297  CE  MET A 468     -24.114  -8.799  30.262  1.00  0.00           C  
ATOM    298  H   MET A 468     -23.674  -5.956  24.900  1.00  0.00           H  
ATOM    299  HA  MET A 468     -25.210  -8.282  25.837  1.00  0.00           H  
ATOM    300  HB2 MET A 468     -24.142  -6.035  27.555  1.00  0.00           H  
ATOM    301  HB3 MET A 468     -25.246  -7.286  28.107  1.00  0.00           H  
ATOM    302  HG2 MET A 468     -23.523  -8.979  27.534  1.00  0.00           H  
ATOM    303  HG3 MET A 468     -22.417  -7.658  27.159  1.00  0.00           H  
ATOM    304  HE1 MET A 468     -23.704  -9.431  31.036  1.00  0.00           H  
ATOM    305  HE2 MET A 468     -24.595  -9.412  29.514  1.00  0.00           H  
ATOM    306  HE3 MET A 468     -24.837  -8.123  30.693  1.00  0.00           H  
ATOM    307  N   THR A 469     -27.350  -6.922  26.168  1.00  0.00           N  
ATOM    308  CA  THR A 469     -28.613  -6.210  26.015  1.00  0.00           C  
ATOM    309  C   THR A 469     -28.934  -5.398  27.266  1.00  0.00           C  
ATOM    310  O   THR A 469     -28.321  -5.589  28.316  1.00  0.00           O  
ATOM    311  CB  THR A 469     -29.747  -7.194  25.727  1.00  0.00           C  
ATOM    312  OG1 THR A 469     -30.078  -7.931  26.892  1.00  0.00           O  
ATOM    313  CG2 THR A 469     -29.416  -8.186  24.635  1.00  0.00           C  
ATOM    314  H   THR A 469     -27.349  -7.813  26.576  1.00  0.00           H  
ATOM    315  HA  THR A 469     -28.514  -5.533  25.179  1.00  0.00           H  
ATOM    316  HB  THR A 469     -30.621  -6.640  25.417  1.00  0.00           H  
ATOM    317  HG1 THR A 469     -30.893  -8.418  26.741  1.00  0.00           H  
ATOM    318 HG21 THR A 469     -30.330  -8.583  24.218  1.00  0.00           H  
ATOM    319 HG22 THR A 469     -28.828  -8.993  25.047  1.00  0.00           H  
ATOM    320 HG23 THR A 469     -28.852  -7.690  23.858  1.00  0.00           H  
ATOM    321  N   THR A 470     -29.901  -4.492  27.147  1.00  0.00           N  
ATOM    322  CA  THR A 470     -30.304  -3.653  28.270  1.00  0.00           C  
ATOM    323  C   THR A 470     -30.729  -4.505  29.461  1.00  0.00           C  
ATOM    324  O   THR A 470     -30.338  -4.240  30.599  1.00  0.00           O  
ATOM    325  CB  THR A 470     -31.450  -2.728  27.857  1.00  0.00           C  
ATOM    326  OG1 THR A 470     -32.516  -3.470  27.291  1.00  0.00           O  
ATOM    327  CG2 THR A 470     -31.037  -1.678  26.849  1.00  0.00           C  
ATOM    328  H   THR A 470     -30.354  -4.387  26.285  1.00  0.00           H  
ATOM    329  HA  THR A 470     -29.454  -3.052  28.557  1.00  0.00           H  
ATOM    330  HB  THR A 470     -31.820  -2.215  28.733  1.00  0.00           H  
ATOM    331  HG1 THR A 470     -32.955  -3.973  27.981  1.00  0.00           H  
ATOM    332 HG21 THR A 470     -31.325  -0.700  27.207  1.00  0.00           H  
ATOM    333 HG22 THR A 470     -31.525  -1.872  25.904  1.00  0.00           H  
ATOM    334 HG23 THR A 470     -29.965  -1.710  26.712  1.00  0.00           H  
ATOM    335  N   LYS A 471     -31.533  -5.529  29.193  1.00  0.00           N  
ATOM    336  CA  LYS A 471     -32.009  -6.420  30.242  1.00  0.00           C  
ATOM    337  C   LYS A 471     -30.843  -7.131  30.922  1.00  0.00           C  
ATOM    338  O   LYS A 471     -30.814  -7.268  32.146  1.00  0.00           O  
ATOM    339  CB  LYS A 471     -32.981  -7.451  29.664  1.00  0.00           C  
ATOM    340  CG  LYS A 471     -33.612  -8.350  30.714  1.00  0.00           C  
ATOM    341  CD  LYS A 471     -34.531  -9.383  30.083  1.00  0.00           C  
ATOM    342  CE  LYS A 471     -35.280 -10.180  31.138  1.00  0.00           C  
ATOM    343  NZ  LYS A 471     -35.436 -11.609  30.748  1.00  0.00           N  
ATOM    344  H   LYS A 471     -31.809  -5.689  28.267  1.00  0.00           H  
ATOM    345  HA  LYS A 471     -32.528  -5.823  30.976  1.00  0.00           H  
ATOM    346  HB2 LYS A 471     -33.772  -6.930  29.143  1.00  0.00           H  
ATOM    347  HB3 LYS A 471     -32.449  -8.074  28.959  1.00  0.00           H  
ATOM    348  HG2 LYS A 471     -32.829  -8.862  31.254  1.00  0.00           H  
ATOM    349  HG3 LYS A 471     -34.184  -7.741  31.398  1.00  0.00           H  
ATOM    350  HD2 LYS A 471     -35.247  -8.877  29.453  1.00  0.00           H  
ATOM    351  HD3 LYS A 471     -33.939 -10.060  29.484  1.00  0.00           H  
ATOM    352  HE2 LYS A 471     -34.731 -10.129  32.067  1.00  0.00           H  
ATOM    353  HE3 LYS A 471     -36.259  -9.744  31.274  1.00  0.00           H  
ATOM    354  HZ1 LYS A 471     -35.556 -11.687  29.716  1.00  0.00           H  
ATOM    355  HZ2 LYS A 471     -36.271 -12.017  31.214  1.00  0.00           H  
ATOM    356  HZ3 LYS A 471     -34.595 -12.150  31.030  1.00  0.00           H  
ATOM    357  N   ASP A 472     -29.881  -7.578  30.121  1.00  0.00           N  
ATOM    358  CA  ASP A 472     -28.712  -8.273  30.645  1.00  0.00           C  
ATOM    359  C   ASP A 472     -27.894  -7.356  31.548  1.00  0.00           C  
ATOM    360  O   ASP A 472     -27.349  -7.791  32.562  1.00  0.00           O  
ATOM    361  CB  ASP A 472     -27.842  -8.786  29.496  1.00  0.00           C  
ATOM    362  CG  ASP A 472     -28.543  -9.842  28.665  1.00  0.00           C  
ATOM    363  OD1 ASP A 472     -29.538 -10.418  29.154  1.00  0.00           O  
ATOM    364  OD2 ASP A 472     -28.097 -10.096  27.526  1.00  0.00           O  
ATOM    365  H   ASP A 472     -29.960  -7.437  29.154  1.00  0.00           H  
ATOM    366  HA  ASP A 472     -29.058  -9.112  31.226  1.00  0.00           H  
ATOM    367  HB2 ASP A 472     -27.584  -7.961  28.850  1.00  0.00           H  
ATOM    368  HB3 ASP A 472     -26.937  -9.216  29.902  1.00  0.00           H  
ATOM    369  N   LEU A 473     -27.811  -6.086  31.170  1.00  0.00           N  
ATOM    370  CA  LEU A 473     -27.059  -5.105  31.945  1.00  0.00           C  
ATOM    371  C   LEU A 473     -27.648  -4.948  33.343  1.00  0.00           C  
ATOM    372  O   LEU A 473     -26.917  -4.860  34.329  1.00  0.00           O  
ATOM    373  CB  LEU A 473     -27.051  -3.754  31.227  1.00  0.00           C  
ATOM    374  CG  LEU A 473     -26.251  -3.717  29.924  1.00  0.00           C  
ATOM    375  CD1 LEU A 473     -26.420  -2.373  29.232  1.00  0.00           C  
ATOM    376  CD2 LEU A 473     -24.781  -4.000  30.194  1.00  0.00           C  
ATOM    377  H   LEU A 473     -28.268  -5.801  30.352  1.00  0.00           H  
ATOM    378  HA  LEU A 473     -26.045  -5.462  32.033  1.00  0.00           H  
ATOM    379  HB2 LEU A 473     -28.073  -3.481  31.007  1.00  0.00           H  
ATOM    380  HB3 LEU A 473     -26.636  -3.016  31.898  1.00  0.00           H  
ATOM    381  HG  LEU A 473     -26.623  -4.483  29.260  1.00  0.00           H  
ATOM    382 HD11 LEU A 473     -26.355  -2.510  28.162  1.00  0.00           H  
ATOM    383 HD12 LEU A 473     -25.641  -1.701  29.558  1.00  0.00           H  
ATOM    384 HD13 LEU A 473     -27.383  -1.958  29.484  1.00  0.00           H  
ATOM    385 HD21 LEU A 473     -24.449  -3.405  31.032  1.00  0.00           H  
ATOM    386 HD22 LEU A 473     -24.200  -3.747  29.319  1.00  0.00           H  
ATOM    387 HD23 LEU A 473     -24.652  -5.046  30.424  1.00  0.00           H  
ATOM    388  N   LEU A 474     -28.975  -4.916  33.422  1.00  0.00           N  
ATOM    389  CA  LEU A 474     -29.660  -4.771  34.700  1.00  0.00           C  
ATOM    390  C   LEU A 474     -29.300  -5.914  35.643  1.00  0.00           C  
ATOM    391  O   LEU A 474     -28.821  -5.689  36.754  1.00  0.00           O  
ATOM    392  CB  LEU A 474     -31.175  -4.725  34.490  1.00  0.00           C  
ATOM    393  CG  LEU A 474     -32.002  -4.544  35.763  1.00  0.00           C  
ATOM    394  CD1 LEU A 474     -31.909  -3.110  36.259  1.00  0.00           C  
ATOM    395  CD2 LEU A 474     -33.450  -4.934  35.519  1.00  0.00           C  
ATOM    396  H   LEU A 474     -29.505  -4.992  32.600  1.00  0.00           H  
ATOM    397  HA  LEU A 474     -29.341  -3.840  35.144  1.00  0.00           H  
ATOM    398  HB2 LEU A 474     -31.400  -3.909  33.818  1.00  0.00           H  
ATOM    399  HB3 LEU A 474     -31.479  -5.649  34.019  1.00  0.00           H  
ATOM    400  HG  LEU A 474     -31.607  -5.189  36.535  1.00  0.00           H  
ATOM    401 HD11 LEU A 474     -32.728  -2.909  36.935  1.00  0.00           H  
ATOM    402 HD12 LEU A 474     -31.962  -2.434  35.418  1.00  0.00           H  
ATOM    403 HD13 LEU A 474     -30.973  -2.967  36.776  1.00  0.00           H  
ATOM    404 HD21 LEU A 474     -33.980  -4.964  36.459  1.00  0.00           H  
ATOM    405 HD22 LEU A 474     -33.489  -5.908  35.052  1.00  0.00           H  
ATOM    406 HD23 LEU A 474     -33.915  -4.206  34.868  1.00  0.00           H  
ATOM    407  N   LYS A 475     -29.532  -7.142  35.189  1.00  0.00           N  
ATOM    408  CA  LYS A 475     -29.230  -8.322  35.991  1.00  0.00           C  
ATOM    409  C   LYS A 475     -27.740  -8.396  36.311  1.00  0.00           C  
ATOM    410  O   LYS A 475     -27.344  -8.924  37.350  1.00  0.00           O  
ATOM    411  CB  LYS A 475     -29.667  -9.590  35.255  1.00  0.00           C  
ATOM    412  CG  LYS A 475     -31.170  -9.697  35.065  1.00  0.00           C  
ATOM    413  CD  LYS A 475     -31.553 -10.998  34.378  1.00  0.00           C  
ATOM    414  CE  LYS A 475     -31.411 -12.186  35.316  1.00  0.00           C  
ATOM    415  NZ  LYS A 475     -32.522 -12.250  36.305  1.00  0.00           N  
ATOM    416  H   LYS A 475     -29.913  -7.257  34.294  1.00  0.00           H  
ATOM    417  HA  LYS A 475     -29.781  -8.245  36.915  1.00  0.00           H  
ATOM    418  HB2 LYS A 475     -29.200  -9.606  34.279  1.00  0.00           H  
ATOM    419  HB3 LYS A 475     -29.334 -10.451  35.816  1.00  0.00           H  
ATOM    420  HG2 LYS A 475     -31.649  -9.657  36.031  1.00  0.00           H  
ATOM    421  HG3 LYS A 475     -31.506  -8.868  34.459  1.00  0.00           H  
ATOM    422  HD2 LYS A 475     -32.580 -10.933  34.051  1.00  0.00           H  
ATOM    423  HD3 LYS A 475     -30.909 -11.145  33.523  1.00  0.00           H  
ATOM    424  HE2 LYS A 475     -31.410 -13.093  34.731  1.00  0.00           H  
ATOM    425  HE3 LYS A 475     -30.472 -12.099  35.845  1.00  0.00           H  
ATOM    426  HZ1 LYS A 475     -32.964 -11.315  36.407  1.00  0.00           H  
ATOM    427  HZ2 LYS A 475     -32.158 -12.552  37.231  1.00  0.00           H  
ATOM    428  HZ3 LYS A 475     -33.242 -12.931  35.990  1.00  0.00           H  
ATOM    429  N   LYS A 476     -26.920  -7.864  35.411  1.00  0.00           N  
ATOM    430  CA  LYS A 476     -25.472  -7.870  35.596  1.00  0.00           C  
ATOM    431  C   LYS A 476     -25.084  -7.192  36.906  1.00  0.00           C  
ATOM    432  O   LYS A 476     -24.123  -7.591  37.561  1.00  0.00           O  
ATOM    433  CB  LYS A 476     -24.786  -7.170  34.422  1.00  0.00           C  
ATOM    434  CG  LYS A 476     -23.269  -7.288  34.446  1.00  0.00           C  
ATOM    435  CD  LYS A 476     -22.808  -8.652  33.953  1.00  0.00           C  
ATOM    436  CE  LYS A 476     -22.221  -9.486  35.081  1.00  0.00           C  
ATOM    437  NZ  LYS A 476     -21.545 -10.710  34.573  1.00  0.00           N  
ATOM    438  H   LYS A 476     -27.294  -7.459  34.602  1.00  0.00           H  
ATOM    439  HA  LYS A 476     -25.147  -8.900  35.628  1.00  0.00           H  
ATOM    440  HB2 LYS A 476     -25.144  -7.601  33.500  1.00  0.00           H  
ATOM    441  HB3 LYS A 476     -25.043  -6.121  34.444  1.00  0.00           H  
ATOM    442  HG2 LYS A 476     -22.849  -6.525  33.809  1.00  0.00           H  
ATOM    443  HG3 LYS A 476     -22.924  -7.145  35.460  1.00  0.00           H  
ATOM    444  HD2 LYS A 476     -23.652  -9.178  33.532  1.00  0.00           H  
ATOM    445  HD3 LYS A 476     -22.055  -8.511  33.191  1.00  0.00           H  
ATOM    446  HE2 LYS A 476     -21.501  -8.884  35.618  1.00  0.00           H  
ATOM    447  HE3 LYS A 476     -23.018  -9.774  35.750  1.00  0.00           H  
ATOM    448  HZ1 LYS A 476     -21.935 -10.974  33.645  1.00  0.00           H  
ATOM    449  HZ2 LYS A 476     -21.692 -11.499  35.235  1.00  0.00           H  
ATOM    450  HZ3 LYS A 476     -20.524 -10.540  34.474  1.00  0.00           H  
ATOM    451  N   PHE A 477     -25.840  -6.165  37.283  1.00  0.00           N  
ATOM    452  CA  PHE A 477     -25.573  -5.433  38.516  1.00  0.00           C  
ATOM    453  C   PHE A 477     -26.449  -5.941  39.659  1.00  0.00           C  
ATOM    454  O   PHE A 477     -26.652  -5.244  40.653  1.00  0.00           O  
ATOM    455  CB  PHE A 477     -25.807  -3.936  38.306  1.00  0.00           C  
ATOM    456  CG  PHE A 477     -24.830  -3.303  37.357  1.00  0.00           C  
ATOM    457  CD1 PHE A 477     -23.546  -2.991  37.771  1.00  0.00           C  
ATOM    458  CD2 PHE A 477     -25.196  -3.020  36.051  1.00  0.00           C  
ATOM    459  CE1 PHE A 477     -22.645  -2.408  36.900  1.00  0.00           C  
ATOM    460  CE2 PHE A 477     -24.300  -2.438  35.176  1.00  0.00           C  
ATOM    461  CZ  PHE A 477     -23.023  -2.132  35.600  1.00  0.00           C  
ATOM    462  H   PHE A 477     -26.594  -5.894  36.719  1.00  0.00           H  
ATOM    463  HA  PHE A 477     -24.538  -5.592  38.777  1.00  0.00           H  
ATOM    464  HB2 PHE A 477     -26.800  -3.786  37.909  1.00  0.00           H  
ATOM    465  HB3 PHE A 477     -25.725  -3.429  39.257  1.00  0.00           H  
ATOM    466  HD1 PHE A 477     -23.249  -3.206  38.786  1.00  0.00           H  
ATOM    467  HD2 PHE A 477     -26.196  -3.259  35.718  1.00  0.00           H  
ATOM    468  HE1 PHE A 477     -21.646  -2.168  37.236  1.00  0.00           H  
ATOM    469  HE2 PHE A 477     -24.598  -2.223  34.160  1.00  0.00           H  
ATOM    470  HZ  PHE A 477     -22.319  -1.676  34.918  1.00  0.00           H  
ATOM    471  N   GLN A 478     -26.963  -7.160  39.516  1.00  0.00           N  
ATOM    472  CA  GLN A 478     -27.815  -7.756  40.540  1.00  0.00           C  
ATOM    473  C   GLN A 478     -27.056  -8.820  41.325  1.00  0.00           C  
ATOM    474  O   GLN A 478     -27.229  -8.955  42.536  1.00  0.00           O  
ATOM    475  CB  GLN A 478     -29.065  -8.366  39.905  1.00  0.00           C  
ATOM    476  CG  GLN A 478     -30.020  -7.336  39.326  1.00  0.00           C  
ATOM    477  CD  GLN A 478     -30.639  -6.452  40.390  1.00  0.00           C  
ATOM    478  OE1 GLN A 478     -31.026  -6.925  41.458  1.00  0.00           O  
ATOM    479  NE2 GLN A 478     -30.734  -5.158  40.102  1.00  0.00           N  
ATOM    480  H   GLN A 478     -26.768  -7.672  38.704  1.00  0.00           H  
ATOM    481  HA  GLN A 478     -28.114  -6.970  41.219  1.00  0.00           H  
ATOM    482  HB2 GLN A 478     -28.761  -9.032  39.110  1.00  0.00           H  
ATOM    483  HB3 GLN A 478     -29.594  -8.935  40.655  1.00  0.00           H  
ATOM    484  HG2 GLN A 478     -29.477  -6.710  38.631  1.00  0.00           H  
ATOM    485  HG3 GLN A 478     -30.811  -7.851  38.801  1.00  0.00           H  
ATOM    486 HE21 GLN A 478     -30.405  -4.852  39.232  1.00  0.00           H  
ATOM    487 HE22 GLN A 478     -31.131  -4.563  40.773  1.00  0.00           H  
ATOM    488  N   THR A 479     -26.214  -9.575  40.626  1.00  0.00           N  
ATOM    489  CA  THR A 479     -25.428 -10.629  41.257  1.00  0.00           C  
ATOM    490  C   THR A 479     -24.536 -10.060  42.356  1.00  0.00           C  
ATOM    491  O   THR A 479     -24.396 -10.656  43.424  1.00  0.00           O  
ATOM    492  CB  THR A 479     -24.572 -11.349  40.213  1.00  0.00           C  
ATOM    493  OG1 THR A 479     -25.376 -11.826  39.147  1.00  0.00           O  
ATOM    494  CG2 THR A 479     -23.809 -12.530  40.775  1.00  0.00           C  
ATOM    495  H   THR A 479     -26.120  -9.419  39.663  1.00  0.00           H  
ATOM    496  HA  THR A 479     -26.114 -11.338  41.695  1.00  0.00           H  
ATOM    497  HB  THR A 479     -23.853 -10.652  39.808  1.00  0.00           H  
ATOM    498  HG1 THR A 479     -25.574 -11.103  38.547  1.00  0.00           H  
ATOM    499 HG21 THR A 479     -23.548 -12.331  41.803  1.00  0.00           H  
ATOM    500 HG22 THR A 479     -22.909 -12.683  40.197  1.00  0.00           H  
ATOM    501 HG23 THR A 479     -24.426 -13.414  40.723  1.00  0.00           H  
ATOM    502  N   LYS A 480     -23.938  -8.904  42.087  1.00  0.00           N  
ATOM    503  CA  LYS A 480     -23.063  -8.255  43.054  1.00  0.00           C  
ATOM    504  C   LYS A 480     -23.844  -7.271  43.918  1.00  0.00           C  
ATOM    505  O   LYS A 480     -24.781  -6.625  43.447  1.00  0.00           O  
ATOM    506  CB  LYS A 480     -21.924  -7.528  42.337  1.00  0.00           C  
ATOM    507  CG  LYS A 480     -20.989  -8.457  41.581  1.00  0.00           C  
ATOM    508  CD  LYS A 480     -19.861  -7.689  40.914  1.00  0.00           C  
ATOM    509  CE  LYS A 480     -18.886  -7.128  41.937  1.00  0.00           C  
ATOM    510  NZ  LYS A 480     -17.623  -6.659  41.304  1.00  0.00           N  
ATOM    511  H   LYS A 480     -24.090  -8.478  41.217  1.00  0.00           H  
ATOM    512  HA  LYS A 480     -22.645  -9.020  43.691  1.00  0.00           H  
ATOM    513  HB2 LYS A 480     -22.347  -6.828  41.632  1.00  0.00           H  
ATOM    514  HB3 LYS A 480     -21.344  -6.984  43.067  1.00  0.00           H  
ATOM    515  HG2 LYS A 480     -20.565  -9.169  42.275  1.00  0.00           H  
ATOM    516  HG3 LYS A 480     -21.553  -8.981  40.823  1.00  0.00           H  
ATOM    517  HD2 LYS A 480     -19.326  -8.354  40.251  1.00  0.00           H  
ATOM    518  HD3 LYS A 480     -20.281  -6.873  40.344  1.00  0.00           H  
ATOM    519  HE2 LYS A 480     -19.355  -6.296  42.442  1.00  0.00           H  
ATOM    520  HE3 LYS A 480     -18.654  -7.901  42.655  1.00  0.00           H  
ATOM    521  HZ1 LYS A 480     -17.689  -5.646  41.080  1.00  0.00           H  
ATOM    522  HZ2 LYS A 480     -17.446  -7.187  40.425  1.00  0.00           H  
ATOM    523  HZ3 LYS A 480     -16.822  -6.809  41.951  1.00  0.00           H  
ATOM    524  N   LYS A 481     -23.456  -7.161  45.184  1.00  0.00           N  
ATOM    525  CA  LYS A 481     -24.124  -6.255  46.111  1.00  0.00           C  
ATOM    526  C   LYS A 481     -23.777  -4.803  45.796  1.00  0.00           C  
ATOM    527  O   LYS A 481     -22.700  -4.321  46.147  1.00  0.00           O  
ATOM    528  CB  LYS A 481     -23.731  -6.584  47.552  1.00  0.00           C  
ATOM    529  CG  LYS A 481     -24.544  -5.829  48.591  1.00  0.00           C  
ATOM    530  CD  LYS A 481     -24.075  -6.144  50.002  1.00  0.00           C  
ATOM    531  CE  LYS A 481     -24.915  -5.420  51.043  1.00  0.00           C  
ATOM    532  NZ  LYS A 481     -24.843  -6.081  52.375  1.00  0.00           N  
ATOM    533  H   LYS A 481     -22.703  -7.703  45.503  1.00  0.00           H  
ATOM    534  HA  LYS A 481     -25.189  -6.391  45.997  1.00  0.00           H  
ATOM    535  HB2 LYS A 481     -23.869  -7.642  47.718  1.00  0.00           H  
ATOM    536  HB3 LYS A 481     -22.689  -6.339  47.694  1.00  0.00           H  
ATOM    537  HG2 LYS A 481     -24.439  -4.769  48.416  1.00  0.00           H  
ATOM    538  HG3 LYS A 481     -25.583  -6.110  48.495  1.00  0.00           H  
ATOM    539  HD2 LYS A 481     -24.153  -7.207  50.169  1.00  0.00           H  
ATOM    540  HD3 LYS A 481     -23.045  -5.835  50.106  1.00  0.00           H  
ATOM    541  HE2 LYS A 481     -24.557  -4.405  51.134  1.00  0.00           H  
ATOM    542  HE3 LYS A 481     -25.943  -5.408  50.711  1.00  0.00           H  
ATOM    543  HZ1 LYS A 481     -25.439  -6.934  52.383  1.00  0.00           H  
ATOM    544  HZ2 LYS A 481     -25.176  -5.432  53.115  1.00  0.00           H  
ATOM    545  HZ3 LYS A 481     -23.862  -6.354  52.585  1.00  0.00           H  
ATOM    546  N   THR A 482     -24.698  -4.112  45.132  1.00  0.00           N  
ATOM    547  CA  THR A 482     -24.490  -2.714  44.770  1.00  0.00           C  
ATOM    548  C   THR A 482     -24.819  -1.793  45.942  1.00  0.00           C  
ATOM    549  O   THR A 482     -24.246  -0.712  46.073  1.00  0.00           O  
ATOM    550  CB  THR A 482     -25.349  -2.347  43.559  1.00  0.00           C  
ATOM    551  OG1 THR A 482     -26.720  -2.579  43.828  1.00  0.00           O  
ATOM    552  CG2 THR A 482     -24.989  -3.124  42.313  1.00  0.00           C  
ATOM    553  H   THR A 482     -25.536  -4.551  44.881  1.00  0.00           H  
ATOM    554  HA  THR A 482     -23.449  -2.590  44.512  1.00  0.00           H  
ATOM    555  HB  THR A 482     -25.218  -1.297  43.344  1.00  0.00           H  
ATOM    556  HG1 THR A 482     -26.941  -2.228  44.695  1.00  0.00           H  
ATOM    557 HG21 THR A 482     -24.076  -2.728  41.892  1.00  0.00           H  
ATOM    558 HG22 THR A 482     -25.786  -3.036  41.589  1.00  0.00           H  
ATOM    559 HG23 THR A 482     -24.846  -4.165  42.565  1.00  0.00           H  
ATOM    560  N   GLY A 483     -25.745  -2.228  46.789  1.00  0.00           N  
ATOM    561  CA  GLY A 483     -26.135  -1.431  47.937  1.00  0.00           C  
ATOM    562  C   GLY A 483     -27.380  -0.608  47.677  1.00  0.00           C  
ATOM    563  O   GLY A 483     -28.137  -0.306  48.600  1.00  0.00           O  
ATOM    564  H   GLY A 483     -26.170  -3.099  46.634  1.00  0.00           H  
ATOM    565  HA2 GLY A 483     -26.318  -2.090  48.773  1.00  0.00           H  
ATOM    566  HA3 GLY A 483     -25.322  -0.764  48.190  1.00  0.00           H  
ATOM    567  N   LEU A 484     -27.596  -0.246  46.416  1.00  0.00           N  
ATOM    568  CA  LEU A 484     -28.760   0.545  46.038  1.00  0.00           C  
ATOM    569  C   LEU A 484     -29.915  -0.357  45.613  1.00  0.00           C  
ATOM    570  O   LEU A 484     -29.703  -1.448  45.086  1.00  0.00           O  
ATOM    571  CB  LEU A 484     -28.401   1.504  44.899  1.00  0.00           C  
ATOM    572  CG  LEU A 484     -27.224   2.439  45.186  1.00  0.00           C  
ATOM    573  CD1 LEU A 484     -27.003   3.391  44.023  1.00  0.00           C  
ATOM    574  CD2 LEU A 484     -27.463   3.214  46.474  1.00  0.00           C  
ATOM    575  H   LEU A 484     -26.957  -0.519  45.725  1.00  0.00           H  
ATOM    576  HA  LEU A 484     -29.064   1.120  46.898  1.00  0.00           H  
ATOM    577  HB2 LEU A 484     -28.164   0.917  44.024  1.00  0.00           H  
ATOM    578  HB3 LEU A 484     -29.267   2.110  44.683  1.00  0.00           H  
ATOM    579  HG  LEU A 484     -26.327   1.849  45.312  1.00  0.00           H  
ATOM    580 HD11 LEU A 484     -26.598   4.322  44.390  1.00  0.00           H  
ATOM    581 HD12 LEU A 484     -27.944   3.578  43.527  1.00  0.00           H  
ATOM    582 HD13 LEU A 484     -26.309   2.949  43.323  1.00  0.00           H  
ATOM    583 HD21 LEU A 484     -27.287   2.567  47.322  1.00  0.00           H  
ATOM    584 HD22 LEU A 484     -28.482   3.571  46.497  1.00  0.00           H  
ATOM    585 HD23 LEU A 484     -26.785   4.055  46.517  1.00  0.00           H  
ATOM    586  N   SER A 485     -31.138   0.109  45.846  1.00  0.00           N  
ATOM    587  CA  SER A 485     -32.327  -0.655  45.488  1.00  0.00           C  
ATOM    588  C   SER A 485     -32.356  -0.948  43.992  1.00  0.00           C  
ATOM    589  O   SER A 485     -31.763  -0.221  43.195  1.00  0.00           O  
ATOM    590  CB  SER A 485     -33.590   0.107  45.894  1.00  0.00           C  
ATOM    591  OG  SER A 485     -33.605   0.364  47.287  1.00  0.00           O  
ATOM    592  H   SER A 485     -31.242   0.987  46.270  1.00  0.00           H  
ATOM    593  HA  SER A 485     -32.294  -1.591  46.026  1.00  0.00           H  
ATOM    594  HB2 SER A 485     -33.624   1.049  45.367  1.00  0.00           H  
ATOM    595  HB3 SER A 485     -34.460  -0.481  45.638  1.00  0.00           H  
ATOM    596  HG  SER A 485     -32.745   0.687  47.563  1.00  0.00           H  
ATOM    597  N   SER A 486     -33.049  -2.018  43.615  1.00  0.00           N  
ATOM    598  CA  SER A 486     -33.156  -2.409  42.214  1.00  0.00           C  
ATOM    599  C   SER A 486     -33.774  -1.289  41.383  1.00  0.00           C  
ATOM    600  O   SER A 486     -33.383  -1.063  40.238  1.00  0.00           O  
ATOM    601  CB  SER A 486     -33.990  -3.682  42.079  1.00  0.00           C  
ATOM    602  OG  SER A 486     -33.964  -4.172  40.749  1.00  0.00           O  
ATOM    603  H   SER A 486     -33.501  -2.560  44.297  1.00  0.00           H  
ATOM    604  HA  SER A 486     -32.158  -2.602  41.848  1.00  0.00           H  
ATOM    605  HB2 SER A 486     -33.595  -4.442  42.736  1.00  0.00           H  
ATOM    606  HB3 SER A 486     -35.014  -3.469  42.351  1.00  0.00           H  
ATOM    607  HG  SER A 486     -34.486  -4.976  40.694  1.00  0.00           H  
ATOM    608  N   GLU A 487     -34.745  -0.592  41.968  1.00  0.00           N  
ATOM    609  CA  GLU A 487     -35.418   0.503  41.281  1.00  0.00           C  
ATOM    610  C   GLU A 487     -34.434   1.617  40.937  1.00  0.00           C  
ATOM    611  O   GLU A 487     -34.498   2.205  39.858  1.00  0.00           O  
ATOM    612  CB  GLU A 487     -36.550   1.057  42.148  1.00  0.00           C  
ATOM    613  CG  GLU A 487     -37.410   2.090  41.439  1.00  0.00           C  
ATOM    614  CD  GLU A 487     -38.243   1.487  40.324  1.00  0.00           C  
ATOM    615  OE1 GLU A 487     -38.515   0.270  40.378  1.00  0.00           O  
ATOM    616  OE2 GLU A 487     -38.622   2.233  39.398  1.00  0.00           O  
ATOM    617  H   GLU A 487     -35.012  -0.821  42.882  1.00  0.00           H  
ATOM    618  HA  GLU A 487     -35.836   0.114  40.364  1.00  0.00           H  
ATOM    619  HB2 GLU A 487     -37.185   0.239  42.456  1.00  0.00           H  
ATOM    620  HB3 GLU A 487     -36.121   1.518  43.027  1.00  0.00           H  
ATOM    621  HG2 GLU A 487     -38.076   2.541  42.161  1.00  0.00           H  
ATOM    622  HG3 GLU A 487     -36.767   2.849  41.020  1.00  0.00           H  
ATOM    623  N   GLN A 488     -33.523   1.900  41.863  1.00  0.00           N  
ATOM    624  CA  GLN A 488     -32.524   2.943  41.658  1.00  0.00           C  
ATOM    625  C   GLN A 488     -31.607   2.596  40.490  1.00  0.00           C  
ATOM    626  O   GLN A 488     -31.213   3.469  39.716  1.00  0.00           O  
ATOM    627  CB  GLN A 488     -31.699   3.145  42.929  1.00  0.00           C  
ATOM    628  CG  GLN A 488     -32.516   3.633  44.115  1.00  0.00           C  
ATOM    629  CD  GLN A 488     -33.152   4.986  43.865  1.00  0.00           C  
ATOM    630  OE1 GLN A 488     -32.538   5.875  43.275  1.00  0.00           O  
ATOM    631  NE2 GLN A 488     -34.390   5.149  44.316  1.00  0.00           N  
ATOM    632  H   GLN A 488     -33.522   1.397  42.703  1.00  0.00           H  
ATOM    633  HA  GLN A 488     -33.046   3.861  41.429  1.00  0.00           H  
ATOM    634  HB2 GLN A 488     -31.238   2.205  43.199  1.00  0.00           H  
ATOM    635  HB3 GLN A 488     -30.924   3.870  42.730  1.00  0.00           H  
ATOM    636  HG2 GLN A 488     -33.298   2.917  44.317  1.00  0.00           H  
ATOM    637  HG3 GLN A 488     -31.867   3.710  44.975  1.00  0.00           H  
ATOM    638 HE21 GLN A 488     -34.817   4.398  44.778  1.00  0.00           H  
ATOM    639 HE22 GLN A 488     -34.826   6.014  44.169  1.00  0.00           H  
ATOM    640  N   THR A 489     -31.268   1.316  40.369  1.00  0.00           N  
ATOM    641  CA  THR A 489     -30.397   0.855  39.295  1.00  0.00           C  
ATOM    642  C   THR A 489     -31.025   1.122  37.932  1.00  0.00           C  
ATOM    643  O   THR A 489     -30.332   1.481  36.979  1.00  0.00           O  
ATOM    644  CB  THR A 489     -30.108  -0.640  39.452  1.00  0.00           C  
ATOM    645  OG1 THR A 489     -29.556  -0.913  40.727  1.00  0.00           O  
ATOM    646  CG2 THR A 489     -29.147  -1.175  38.411  1.00  0.00           C  
ATOM    647  H   THR A 489     -31.614   0.667  41.017  1.00  0.00           H  
ATOM    648  HA  THR A 489     -29.469   1.400  39.366  1.00  0.00           H  
ATOM    649  HB  THR A 489     -31.035  -1.187  39.359  1.00  0.00           H  
ATOM    650  HG1 THR A 489     -28.698  -0.490  40.802  1.00  0.00           H  
ATOM    651 HG21 THR A 489     -29.480  -0.877  37.428  1.00  0.00           H  
ATOM    652 HG22 THR A 489     -29.117  -2.252  38.470  1.00  0.00           H  
ATOM    653 HG23 THR A 489     -28.160  -0.776  38.594  1.00  0.00           H  
ATOM    654  N   VAL A 490     -32.339   0.944  37.845  1.00  0.00           N  
ATOM    655  CA  VAL A 490     -33.059   1.167  36.599  1.00  0.00           C  
ATOM    656  C   VAL A 490     -32.966   2.626  36.163  1.00  0.00           C  
ATOM    657  O   VAL A 490     -32.705   2.921  34.997  1.00  0.00           O  
ATOM    658  CB  VAL A 490     -34.543   0.774  36.729  1.00  0.00           C  
ATOM    659  CG1 VAL A 490     -35.245   0.872  35.383  1.00  0.00           C  
ATOM    660  CG2 VAL A 490     -34.673  -0.628  37.306  1.00  0.00           C  
ATOM    661  H   VAL A 490     -32.835   0.657  38.639  1.00  0.00           H  
ATOM    662  HA  VAL A 490     -32.608   0.545  35.838  1.00  0.00           H  
ATOM    663  HB  VAL A 490     -35.019   1.465  37.409  1.00  0.00           H  
ATOM    664 HG11 VAL A 490     -35.444   1.909  35.156  1.00  0.00           H  
ATOM    665 HG12 VAL A 490     -36.176   0.327  35.422  1.00  0.00           H  
ATOM    666 HG13 VAL A 490     -34.613   0.451  34.615  1.00  0.00           H  
ATOM    667 HG21 VAL A 490     -33.770  -1.186  37.108  1.00  0.00           H  
ATOM    668 HG22 VAL A 490     -35.514  -1.130  36.848  1.00  0.00           H  
ATOM    669 HG23 VAL A 490     -34.830  -0.565  38.373  1.00  0.00           H  
ATOM    670  N   ASN A 491     -33.182   3.534  37.108  1.00  0.00           N  
ATOM    671  CA  ASN A 491     -33.123   4.964  36.821  1.00  0.00           C  
ATOM    672  C   ASN A 491     -31.713   5.380  36.416  1.00  0.00           C  
ATOM    673  O   ASN A 491     -31.528   6.134  35.462  1.00  0.00           O  
ATOM    674  CB  ASN A 491     -33.575   5.769  38.042  1.00  0.00           C  
ATOM    675  CG  ASN A 491     -35.037   5.544  38.374  1.00  0.00           C  
ATOM    676  OD1 ASN A 491     -35.803   5.047  37.548  1.00  0.00           O  
ATOM    677  ND2 ASN A 491     -35.432   5.913  39.586  1.00  0.00           N  
ATOM    678  H   ASN A 491     -33.387   3.238  38.020  1.00  0.00           H  
ATOM    679  HA  ASN A 491     -33.795   5.165  36.001  1.00  0.00           H  
ATOM    680  HB2 ASN A 491     -32.983   5.477  38.897  1.00  0.00           H  
ATOM    681  HB3 ASN A 491     -33.424   6.820  37.848  1.00  0.00           H  
ATOM    682 HD21 ASN A 491     -34.767   6.301  40.192  1.00  0.00           H  
ATOM    683 HD22 ASN A 491     -36.373   5.779  39.827  1.00  0.00           H  
ATOM    684  N   VAL A 492     -30.721   4.883  37.148  1.00  0.00           N  
ATOM    685  CA  VAL A 492     -29.328   5.204  36.863  1.00  0.00           C  
ATOM    686  C   VAL A 492     -28.857   4.512  35.588  1.00  0.00           C  
ATOM    687  O   VAL A 492     -28.175   5.114  34.759  1.00  0.00           O  
ATOM    688  CB  VAL A 492     -28.407   4.792  38.029  1.00  0.00           C  
ATOM    689  CG1 VAL A 492     -26.978   5.252  37.773  1.00  0.00           C  
ATOM    690  CG2 VAL A 492     -28.927   5.353  39.344  1.00  0.00           C  
ATOM    691  H   VAL A 492     -30.931   4.287  37.896  1.00  0.00           H  
ATOM    692  HA  VAL A 492     -29.251   6.273  36.730  1.00  0.00           H  
ATOM    693  HB  VAL A 492     -28.406   3.714  38.096  1.00  0.00           H  
ATOM    694 HG11 VAL A 492     -26.505   4.580  37.073  1.00  0.00           H  
ATOM    695 HG12 VAL A 492     -26.429   5.251  38.702  1.00  0.00           H  
ATOM    696 HG13 VAL A 492     -26.991   6.251  37.362  1.00  0.00           H  
ATOM    697 HG21 VAL A 492     -28.826   4.606  40.118  1.00  0.00           H  
ATOM    698 HG22 VAL A 492     -29.968   5.619  39.235  1.00  0.00           H  
ATOM    699 HG23 VAL A 492     -28.356   6.230  39.613  1.00  0.00           H  
ATOM    700  N   LEU A 493     -29.228   3.244  35.438  1.00  0.00           N  
ATOM    701  CA  LEU A 493     -28.846   2.468  34.264  1.00  0.00           C  
ATOM    702  C   LEU A 493     -29.451   3.064  32.998  1.00  0.00           C  
ATOM    703  O   LEU A 493     -28.837   3.040  31.933  1.00  0.00           O  
ATOM    704  CB  LEU A 493     -29.292   1.013  34.423  1.00  0.00           C  
ATOM    705  CG  LEU A 493     -28.788   0.059  33.339  1.00  0.00           C  
ATOM    706  CD1 LEU A 493     -28.478  -1.308  33.930  1.00  0.00           C  
ATOM    707  CD2 LEU A 493     -29.812  -0.062  32.221  1.00  0.00           C  
ATOM    708  H   LEU A 493     -29.772   2.821  36.135  1.00  0.00           H  
ATOM    709  HA  LEU A 493     -27.769   2.499  34.184  1.00  0.00           H  
ATOM    710  HB2 LEU A 493     -28.942   0.655  35.381  1.00  0.00           H  
ATOM    711  HB3 LEU A 493     -30.370   0.987  34.420  1.00  0.00           H  
ATOM    712  HG  LEU A 493     -27.875   0.453  32.916  1.00  0.00           H  
ATOM    713 HD11 LEU A 493     -29.317  -1.968  33.771  1.00  0.00           H  
ATOM    714 HD12 LEU A 493     -28.295  -1.208  34.991  1.00  0.00           H  
ATOM    715 HD13 LEU A 493     -27.602  -1.718  33.451  1.00  0.00           H  
ATOM    716 HD21 LEU A 493     -29.337  -0.467  31.339  1.00  0.00           H  
ATOM    717 HD22 LEU A 493     -30.218   0.912  31.995  1.00  0.00           H  
ATOM    718 HD23 LEU A 493     -30.609  -0.721  32.533  1.00  0.00           H  
ATOM    719  N   ALA A 494     -30.660   3.600  33.123  1.00  0.00           N  
ATOM    720  CA  ALA A 494     -31.348   4.203  31.989  1.00  0.00           C  
ATOM    721  C   ALA A 494     -30.700   5.525  31.597  1.00  0.00           C  
ATOM    722  O   ALA A 494     -30.629   5.870  30.418  1.00  0.00           O  
ATOM    723  CB  ALA A 494     -32.820   4.409  32.313  1.00  0.00           C  
ATOM    724  H   ALA A 494     -31.101   3.589  34.000  1.00  0.00           H  
ATOM    725  HA  ALA A 494     -31.278   3.520  31.156  1.00  0.00           H  
ATOM    726  HB1 ALA A 494     -32.912   4.973  33.228  1.00  0.00           H  
ATOM    727  HB2 ALA A 494     -33.300   3.449  32.432  1.00  0.00           H  
ATOM    728  HB3 ALA A 494     -33.294   4.949  31.507  1.00  0.00           H  
ATOM    729  N   GLN A 495     -30.230   6.263  32.597  1.00  0.00           N  
ATOM    730  CA  GLN A 495     -29.587   7.553  32.362  1.00  0.00           C  
ATOM    731  C   GLN A 495     -28.124   7.373  31.967  1.00  0.00           C  
ATOM    732  O   GLN A 495     -27.613   8.088  31.105  1.00  0.00           O  
ATOM    733  CB  GLN A 495     -29.685   8.429  33.612  1.00  0.00           C  
ATOM    734  CG  GLN A 495     -31.109   8.827  33.965  1.00  0.00           C  
ATOM    735  CD  GLN A 495     -31.185   9.658  35.231  1.00  0.00           C  
ATOM    736  OE1 GLN A 495     -30.276   9.632  36.060  1.00  0.00           O  
ATOM    737  NE2 GLN A 495     -32.273  10.402  35.386  1.00  0.00           N  
ATOM    738  H   GLN A 495     -30.318   5.935  33.516  1.00  0.00           H  
ATOM    739  HA  GLN A 495     -30.110   8.038  31.551  1.00  0.00           H  
ATOM    740  HB2 GLN A 495     -29.268   7.890  34.449  1.00  0.00           H  
ATOM    741  HB3 GLN A 495     -29.111   9.329  33.451  1.00  0.00           H  
ATOM    742  HG2 GLN A 495     -31.520   9.404  33.150  1.00  0.00           H  
ATOM    743  HG3 GLN A 495     -31.697   7.932  34.103  1.00  0.00           H  
ATOM    744 HE21 GLN A 495     -32.958  10.375  34.685  1.00  0.00           H  
ATOM    745 HE22 GLN A 495     -32.348  10.949  36.196  1.00  0.00           H  
ATOM    746  N   ILE A 496     -27.454   6.420  32.606  1.00  0.00           N  
ATOM    747  CA  ILE A 496     -26.048   6.154  32.322  1.00  0.00           C  
ATOM    748  C   ILE A 496     -25.852   5.715  30.875  1.00  0.00           C  
ATOM    749  O   ILE A 496     -24.954   6.192  30.183  1.00  0.00           O  
ATOM    750  CB  ILE A 496     -25.475   5.083  33.283  1.00  0.00           C  
ATOM    751  CG1 ILE A 496     -23.976   5.299  33.486  1.00  0.00           C  
ATOM    752  CG2 ILE A 496     -25.747   3.670  32.779  1.00  0.00           C  
ATOM    753  CD1 ILE A 496     -23.478   4.841  34.840  1.00  0.00           C  
ATOM    754  H   ILE A 496     -27.913   5.884  33.287  1.00  0.00           H  
ATOM    755  HA  ILE A 496     -25.501   7.073  32.481  1.00  0.00           H  
ATOM    756  HB  ILE A 496     -25.976   5.191  34.229  1.00  0.00           H  
ATOM    757 HG12 ILE A 496     -23.433   4.750  32.731  1.00  0.00           H  
ATOM    758 HG13 ILE A 496     -23.754   6.351  33.389  1.00  0.00           H  
ATOM    759 HG21 ILE A 496     -26.811   3.528  32.662  1.00  0.00           H  
ATOM    760 HG22 ILE A 496     -25.366   2.955  33.492  1.00  0.00           H  
ATOM    761 HG23 ILE A 496     -25.257   3.524  31.827  1.00  0.00           H  
ATOM    762 HD11 ILE A 496     -23.064   3.848  34.754  1.00  0.00           H  
ATOM    763 HD12 ILE A 496     -24.300   4.830  35.541  1.00  0.00           H  
ATOM    764 HD13 ILE A 496     -22.715   5.520  35.192  1.00  0.00           H  
ATOM    765  N   LEU A 497     -26.703   4.800  30.429  1.00  0.00           N  
ATOM    766  CA  LEU A 497     -26.634   4.287  29.064  1.00  0.00           C  
ATOM    767  C   LEU A 497     -26.756   5.416  28.046  1.00  0.00           C  
ATOM    768  O   LEU A 497     -26.019   5.458  27.060  1.00  0.00           O  
ATOM    769  CB  LEU A 497     -27.736   3.251  28.828  1.00  0.00           C  
ATOM    770  CG  LEU A 497     -27.528   1.910  29.533  1.00  0.00           C  
ATOM    771  CD1 LEU A 497     -28.782   1.057  29.436  1.00  0.00           C  
ATOM    772  CD2 LEU A 497     -26.335   1.176  28.937  1.00  0.00           C  
ATOM    773  H   LEU A 497     -27.395   4.460  31.035  1.00  0.00           H  
ATOM    774  HA  LEU A 497     -25.674   3.810  28.940  1.00  0.00           H  
ATOM    775  HB2 LEU A 497     -28.672   3.672  29.166  1.00  0.00           H  
ATOM    776  HB3 LEU A 497     -27.806   3.068  27.766  1.00  0.00           H  
ATOM    777  HG  LEU A 497     -27.324   2.087  30.579  1.00  0.00           H  
ATOM    778 HD11 LEU A 497     -29.485   1.364  30.196  1.00  0.00           H  
ATOM    779 HD12 LEU A 497     -28.523   0.018  29.583  1.00  0.00           H  
ATOM    780 HD13 LEU A 497     -29.229   1.182  28.461  1.00  0.00           H  
ATOM    781 HD21 LEU A 497     -25.688   1.882  28.439  1.00  0.00           H  
ATOM    782 HD22 LEU A 497     -26.682   0.442  28.226  1.00  0.00           H  
ATOM    783 HD23 LEU A 497     -25.788   0.680  29.726  1.00  0.00           H  
ATOM    784  N   LYS A 498     -27.688   6.331  28.291  1.00  0.00           N  
ATOM    785  CA  LYS A 498     -27.903   7.460  27.393  1.00  0.00           C  
ATOM    786  C   LYS A 498     -26.646   8.317  27.287  1.00  0.00           C  
ATOM    787  O   LYS A 498     -26.265   8.744  26.196  1.00  0.00           O  
ATOM    788  CB  LYS A 498     -29.075   8.312  27.883  1.00  0.00           C  
ATOM    789  CG  LYS A 498     -30.424   7.626  27.745  1.00  0.00           C  
ATOM    790  CD  LYS A 498     -31.560   8.541  28.171  1.00  0.00           C  
ATOM    791  CE  LYS A 498     -32.903   7.832  28.103  1.00  0.00           C  
ATOM    792  NZ  LYS A 498     -33.313   7.288  29.427  1.00  0.00           N  
ATOM    793  H   LYS A 498     -28.244   6.245  29.093  1.00  0.00           H  
ATOM    794  HA  LYS A 498     -28.138   7.066  26.416  1.00  0.00           H  
ATOM    795  HB2 LYS A 498     -28.922   8.553  28.923  1.00  0.00           H  
ATOM    796  HB3 LYS A 498     -29.102   9.228  27.309  1.00  0.00           H  
ATOM    797  HG2 LYS A 498     -30.572   7.342  26.715  1.00  0.00           H  
ATOM    798  HG3 LYS A 498     -30.432   6.743  28.368  1.00  0.00           H  
ATOM    799  HD2 LYS A 498     -31.389   8.866  29.186  1.00  0.00           H  
ATOM    800  HD3 LYS A 498     -31.583   9.400  27.515  1.00  0.00           H  
ATOM    801  HE2 LYS A 498     -33.651   8.533  27.766  1.00  0.00           H  
ATOM    802  HE3 LYS A 498     -32.830   7.018  27.397  1.00  0.00           H  
ATOM    803  HZ1 LYS A 498     -33.012   6.297  29.516  1.00  0.00           H  
ATOM    804  HZ2 LYS A 498     -34.346   7.335  29.529  1.00  0.00           H  
ATOM    805  HZ3 LYS A 498     -32.876   7.842  30.192  1.00  0.00           H  
ATOM    806  N   ARG A 499     -26.005   8.563  28.425  1.00  0.00           N  
ATOM    807  CA  ARG A 499     -24.790   9.368  28.458  1.00  0.00           C  
ATOM    808  C   ARG A 499     -23.666   8.688  27.684  1.00  0.00           C  
ATOM    809  O   ARG A 499     -22.940   9.332  26.927  1.00  0.00           O  
ATOM    810  CB  ARG A 499     -24.355   9.612  29.904  1.00  0.00           C  
ATOM    811  CG  ARG A 499     -23.167  10.551  30.032  1.00  0.00           C  
ATOM    812  CD  ARG A 499     -23.559  11.991  29.743  1.00  0.00           C  
ATOM    813  NE  ARG A 499     -22.420  12.899  29.847  1.00  0.00           N  
ATOM    814  CZ  ARG A 499     -21.508  13.059  28.891  1.00  0.00           C  
ATOM    815  NH1 ARG A 499     -21.596  12.372  27.758  1.00  0.00           N  
ATOM    816  NH2 ARG A 499     -20.504  13.907  29.067  1.00  0.00           N  
ATOM    817  H   ARG A 499     -26.358   8.194  29.261  1.00  0.00           H  
ATOM    818  HA  ARG A 499     -25.009  10.317  27.992  1.00  0.00           H  
ATOM    819  HB2 ARG A 499     -25.184  10.041  30.450  1.00  0.00           H  
ATOM    820  HB3 ARG A 499     -24.091   8.667  30.354  1.00  0.00           H  
ATOM    821  HG2 ARG A 499     -22.778  10.490  31.037  1.00  0.00           H  
ATOM    822  HG3 ARG A 499     -22.404  10.247  29.330  1.00  0.00           H  
ATOM    823  HD2 ARG A 499     -23.961  12.046  28.742  1.00  0.00           H  
ATOM    824  HD3 ARG A 499     -24.315  12.293  30.452  1.00  0.00           H  
ATOM    825  HE  ARG A 499     -22.329  13.419  30.673  1.00  0.00           H  
ATOM    826 HH11 ARG A 499     -22.350  11.731  27.618  1.00  0.00           H  
ATOM    827 HH12 ARG A 499     -20.909  12.498  27.043  1.00  0.00           H  
ATOM    828 HH21 ARG A 499     -20.432  14.428  29.918  1.00  0.00           H  
ATOM    829 HH22 ARG A 499     -19.818  14.027  28.349  1.00  0.00           H  
ATOM    830  N   LEU A 500     -23.526   7.380  27.882  1.00  0.00           N  
ATOM    831  CA  LEU A 500     -22.488   6.611  27.204  1.00  0.00           C  
ATOM    832  C   LEU A 500     -22.735   6.574  25.699  1.00  0.00           C  
ATOM    833  O   LEU A 500     -21.794   6.579  24.905  1.00  0.00           O  
ATOM    834  CB  LEU A 500     -22.437   5.186  27.758  1.00  0.00           C  
ATOM    835  CG  LEU A 500     -21.274   4.334  27.249  1.00  0.00           C  
ATOM    836  CD1 LEU A 500     -19.957   4.825  27.831  1.00  0.00           C  
ATOM    837  CD2 LEU A 500     -21.497   2.870  27.594  1.00  0.00           C  
ATOM    838  H   LEU A 500     -24.134   6.922  28.499  1.00  0.00           H  
ATOM    839  HA  LEU A 500     -21.542   7.095  27.390  1.00  0.00           H  
ATOM    840  HB2 LEU A 500     -22.369   5.244  28.836  1.00  0.00           H  
ATOM    841  HB3 LEU A 500     -23.359   4.687  27.501  1.00  0.00           H  
ATOM    842  HG  LEU A 500     -21.217   4.421  26.173  1.00  0.00           H  
ATOM    843 HD11 LEU A 500     -19.240   4.019  27.829  1.00  0.00           H  
ATOM    844 HD12 LEU A 500     -20.116   5.165  28.843  1.00  0.00           H  
ATOM    845 HD13 LEU A 500     -19.582   5.642  27.232  1.00  0.00           H  
ATOM    846 HD21 LEU A 500     -22.081   2.797  28.499  1.00  0.00           H  
ATOM    847 HD22 LEU A 500     -20.543   2.385  27.740  1.00  0.00           H  
ATOM    848 HD23 LEU A 500     -22.025   2.385  26.785  1.00  0.00           H  
ATOM    849  N   ASN A 501     -24.006   6.538  25.315  1.00  0.00           N  
ATOM    850  CA  ASN A 501     -24.379   6.501  23.905  1.00  0.00           C  
ATOM    851  C   ASN A 501     -23.813   5.256  23.224  1.00  0.00           C  
ATOM    852  O   ASN A 501     -23.037   5.355  22.273  1.00  0.00           O  
ATOM    853  CB  ASN A 501     -23.882   7.761  23.192  1.00  0.00           C  
ATOM    854  CG  ASN A 501     -24.921   8.865  23.179  1.00  0.00           C  
ATOM    855  OD1 ASN A 501     -25.062   9.612  24.147  1.00  0.00           O  
ATOM    856  ND2 ASN A 501     -25.655   8.972  22.078  1.00  0.00           N  
ATOM    857  H   ASN A 501     -24.711   6.538  25.996  1.00  0.00           H  
ATOM    858  HA  ASN A 501     -25.457   6.468  23.849  1.00  0.00           H  
ATOM    859  HB2 ASN A 501     -23.000   8.129  23.696  1.00  0.00           H  
ATOM    860  HB3 ASN A 501     -23.633   7.515  22.171  1.00  0.00           H  
ATOM    861 HD21 ASN A 501     -25.488   8.342  21.346  1.00  0.00           H  
ATOM    862 HD22 ASN A 501     -26.336   9.678  22.041  1.00  0.00           H  
ATOM    863  N   PRO A 502     -24.197   4.061  23.706  1.00  0.00           N  
ATOM    864  CA  PRO A 502     -23.725   2.793  23.139  1.00  0.00           C  
ATOM    865  C   PRO A 502     -24.315   2.521  21.761  1.00  0.00           C  
ATOM    866  O   PRO A 502     -25.374   3.043  21.413  1.00  0.00           O  
ATOM    867  CB  PRO A 502     -24.215   1.750  24.146  1.00  0.00           C  
ATOM    868  CG  PRO A 502     -25.402   2.376  24.791  1.00  0.00           C  
ATOM    869  CD  PRO A 502     -25.120   3.852  24.838  1.00  0.00           C  
ATOM    870  HA  PRO A 502     -22.647   2.763  23.080  1.00  0.00           H  
ATOM    871  HB2 PRO A 502     -24.478   0.840  23.626  1.00  0.00           H  
ATOM    872  HB3 PRO A 502     -23.436   1.547  24.867  1.00  0.00           H  
ATOM    873  HG2 PRO A 502     -26.286   2.182  24.199  1.00  0.00           H  
ATOM    874  HG3 PRO A 502     -25.527   1.987  25.790  1.00  0.00           H  
ATOM    875  HD2 PRO A 502     -26.031   4.416  24.701  1.00  0.00           H  
ATOM    876  HD3 PRO A 502     -24.648   4.117  25.772  1.00  0.00           H  
ATOM    877  N   GLU A 503     -23.622   1.699  20.978  1.00  0.00           N  
ATOM    878  CA  GLU A 503     -24.080   1.356  19.636  1.00  0.00           C  
ATOM    879  C   GLU A 503     -25.069   0.197  19.679  1.00  0.00           C  
ATOM    880  O   GLU A 503     -25.153  -0.523  20.673  1.00  0.00           O  
ATOM    881  CB  GLU A 503     -22.889   0.990  18.746  1.00  0.00           C  
ATOM    882  CG  GLU A 503     -23.121   1.274  17.270  1.00  0.00           C  
ATOM    883  CD  GLU A 503     -21.915   0.939  16.412  1.00  0.00           C  
ATOM    884  OE1 GLU A 503     -20.875   0.540  16.978  1.00  0.00           O  
ATOM    885  OE2 GLU A 503     -22.011   1.077  15.175  1.00  0.00           O  
ATOM    886  H   GLU A 503     -22.786   1.314  21.310  1.00  0.00           H  
ATOM    887  HA  GLU A 503     -24.573   2.223  19.222  1.00  0.00           H  
ATOM    888  HB2 GLU A 503     -22.027   1.555  19.068  1.00  0.00           H  
ATOM    889  HB3 GLU A 503     -22.682  -0.063  18.859  1.00  0.00           H  
ATOM    890  HG2 GLU A 503     -23.958   0.683  16.931  1.00  0.00           H  
ATOM    891  HG3 GLU A 503     -23.350   2.322  17.149  1.00  0.00           H  
ATOM    892  N   ARG A 504     -25.819   0.025  18.595  1.00  0.00           N  
ATOM    893  CA  ARG A 504     -26.805  -1.046  18.510  1.00  0.00           C  
ATOM    894  C   ARG A 504     -26.384  -2.094  17.485  1.00  0.00           C  
ATOM    895  O   ARG A 504     -26.017  -1.762  16.358  1.00  0.00           O  
ATOM    896  CB  ARG A 504     -28.176  -0.477  18.141  1.00  0.00           C  
ATOM    897  CG  ARG A 504     -28.755   0.449  19.197  1.00  0.00           C  
ATOM    898  CD  ARG A 504     -30.126   0.966  18.792  1.00  0.00           C  
ATOM    899  NE  ARG A 504     -31.125  -0.099  18.757  1.00  0.00           N  
ATOM    900  CZ  ARG A 504     -31.677  -0.632  19.843  1.00  0.00           C  
ATOM    901  NH1 ARG A 504     -31.333  -0.204  21.052  1.00  0.00           N  
ATOM    902  NH2 ARG A 504     -32.579  -1.598  19.722  1.00  0.00           N  
ATOM    903  H   ARG A 504     -25.706   0.634  17.835  1.00  0.00           H  
ATOM    904  HA  ARG A 504     -26.870  -1.514  19.481  1.00  0.00           H  
ATOM    905  HB2 ARG A 504     -28.086   0.077  17.218  1.00  0.00           H  
ATOM    906  HB3 ARG A 504     -28.864  -1.295  17.992  1.00  0.00           H  
ATOM    907  HG2 ARG A 504     -28.848  -0.094  20.126  1.00  0.00           H  
ATOM    908  HG3 ARG A 504     -28.089   1.288  19.333  1.00  0.00           H  
ATOM    909  HD2 ARG A 504     -30.439   1.716  19.505  1.00  0.00           H  
ATOM    910  HD3 ARG A 504     -30.053   1.412  17.811  1.00  0.00           H  
ATOM    911  HE  ARG A 504     -31.399  -0.433  17.877  1.00  0.00           H  
ATOM    912 HH11 ARG A 504     -30.655   0.524  21.150  1.00  0.00           H  
ATOM    913 HH12 ARG A 504     -31.753  -0.610  21.863  1.00  0.00           H  
ATOM    914 HH21 ARG A 504     -32.843  -1.924  18.814  1.00  0.00           H  
ATOM    915 HH22 ARG A 504     -32.995  -2.000  20.538  1.00  0.00           H  
ATOM    916  N   LYS A 505     -26.440  -3.360  17.885  1.00  0.00           N  
ATOM    917  CA  LYS A 505     -26.066  -4.460  17.001  1.00  0.00           C  
ATOM    918  C   LYS A 505     -27.082  -5.593  17.085  1.00  0.00           C  
ATOM    919  O   LYS A 505     -27.724  -5.789  18.117  1.00  0.00           O  
ATOM    920  CB  LYS A 505     -24.673  -4.978  17.362  1.00  0.00           C  
ATOM    921  CG  LYS A 505     -23.591  -3.914  17.297  1.00  0.00           C  
ATOM    922  CD  LYS A 505     -22.227  -4.483  17.653  1.00  0.00           C  
ATOM    923  CE  LYS A 505     -21.633  -5.270  16.496  1.00  0.00           C  
ATOM    924  NZ  LYS A 505     -20.760  -6.381  16.968  1.00  0.00           N  
ATOM    925  H   LYS A 505     -26.742  -3.561  18.795  1.00  0.00           H  
ATOM    926  HA  LYS A 505     -26.049  -4.080  15.991  1.00  0.00           H  
ATOM    927  HB2 LYS A 505     -24.699  -5.376  18.365  1.00  0.00           H  
ATOM    928  HB3 LYS A 505     -24.410  -5.772  16.677  1.00  0.00           H  
ATOM    929  HG2 LYS A 505     -23.551  -3.513  16.296  1.00  0.00           H  
ATOM    930  HG3 LYS A 505     -23.834  -3.124  17.994  1.00  0.00           H  
ATOM    931  HD2 LYS A 505     -21.562  -3.670  17.902  1.00  0.00           H  
ATOM    932  HD3 LYS A 505     -22.333  -5.139  18.506  1.00  0.00           H  
ATOM    933  HE2 LYS A 505     -22.438  -5.683  15.907  1.00  0.00           H  
ATOM    934  HE3 LYS A 505     -21.048  -4.599  15.885  1.00  0.00           H  
ATOM    935  HZ1 LYS A 505     -21.121  -6.759  17.869  1.00  0.00           H  
ATOM    936  HZ2 LYS A 505     -19.790  -6.037  17.114  1.00  0.00           H  
ATOM    937  HZ3 LYS A 505     -20.745  -7.146  16.265  1.00  0.00           H  
ATOM    938  N   MET A 506     -27.222  -6.338  15.993  1.00  0.00           N  
ATOM    939  CA  MET A 506     -28.161  -7.454  15.945  1.00  0.00           C  
ATOM    940  C   MET A 506     -27.421  -8.786  15.885  1.00  0.00           C  
ATOM    941  O   MET A 506     -26.841  -9.141  14.859  1.00  0.00           O  
ATOM    942  CB  MET A 506     -29.088  -7.319  14.733  1.00  0.00           C  
ATOM    943  CG  MET A 506     -28.372  -6.888  13.464  1.00  0.00           C  
ATOM    944  SD  MET A 506     -29.489  -6.728  12.057  1.00  0.00           S  
ATOM    945  CE  MET A 506     -30.039  -8.422  11.867  1.00  0.00           C  
ATOM    946  H   MET A 506     -26.681  -6.132  15.202  1.00  0.00           H  
ATOM    947  HA  MET A 506     -28.755  -7.426  16.845  1.00  0.00           H  
ATOM    948  HB2 MET A 506     -29.560  -8.272  14.549  1.00  0.00           H  
ATOM    949  HB3 MET A 506     -29.848  -6.587  14.957  1.00  0.00           H  
ATOM    950  HG2 MET A 506     -27.898  -5.934  13.639  1.00  0.00           H  
ATOM    951  HG3 MET A 506     -27.617  -7.624  13.224  1.00  0.00           H  
ATOM    952  HE1 MET A 506     -29.854  -8.749  10.855  1.00  0.00           H  
ATOM    953  HE2 MET A 506     -31.097  -8.483  12.077  1.00  0.00           H  
ATOM    954  HE3 MET A 506     -29.498  -9.055  12.554  1.00  0.00           H  
ATOM    955  N   ILE A 507     -27.442  -9.518  16.995  1.00  0.00           N  
ATOM    956  CA  ILE A 507     -26.774 -10.812  17.070  1.00  0.00           C  
ATOM    957  C   ILE A 507     -27.780 -11.937  17.290  1.00  0.00           C  
ATOM    958  O   ILE A 507     -28.689 -11.815  18.111  1.00  0.00           O  
ATOM    959  CB  ILE A 507     -25.733 -10.840  18.207  1.00  0.00           C  
ATOM    960  CG1 ILE A 507     -24.802  -9.630  18.106  1.00  0.00           C  
ATOM    961  CG2 ILE A 507     -24.935 -12.135  18.165  1.00  0.00           C  
ATOM    962  CD1 ILE A 507     -23.860  -9.493  19.282  1.00  0.00           C  
ATOM    963  H   ILE A 507     -27.920  -9.181  17.781  1.00  0.00           H  
ATOM    964  HA  ILE A 507     -26.259 -10.979  16.135  1.00  0.00           H  
ATOM    965  HB  ILE A 507     -26.260 -10.803  19.148  1.00  0.00           H  
ATOM    966 HG12 ILE A 507     -24.204  -9.718  17.212  1.00  0.00           H  
ATOM    967 HG13 ILE A 507     -25.397  -8.730  18.049  1.00  0.00           H  
ATOM    968 HG21 ILE A 507     -24.940 -12.528  17.159  1.00  0.00           H  
ATOM    969 HG22 ILE A 507     -25.380 -12.855  18.834  1.00  0.00           H  
ATOM    970 HG23 ILE A 507     -23.916 -11.941  18.470  1.00  0.00           H  
ATOM    971 HD11 ILE A 507     -22.897  -9.151  18.935  1.00  0.00           H  
ATOM    972 HD12 ILE A 507     -23.746 -10.452  19.767  1.00  0.00           H  
ATOM    973 HD13 ILE A 507     -24.264  -8.780  19.986  1.00  0.00           H  
ATOM    974  N   ASN A 508     -27.611 -13.030  16.548  1.00  0.00           N  
ATOM    975  CA  ASN A 508     -28.499 -14.187  16.652  1.00  0.00           C  
ATOM    976  C   ASN A 508     -29.965 -13.760  16.718  1.00  0.00           C  
ATOM    977  O   ASN A 508     -30.733 -14.259  17.540  1.00  0.00           O  
ATOM    978  CB  ASN A 508     -28.140 -15.030  17.879  1.00  0.00           C  
ATOM    979  CG  ASN A 508     -28.255 -14.251  19.175  1.00  0.00           C  
ATOM    980  OD1 ASN A 508     -29.329 -13.761  19.527  1.00  0.00           O  
ATOM    981  ND2 ASN A 508     -27.144 -14.132  19.894  1.00  0.00           N  
ATOM    982  H   ASN A 508     -26.865 -13.060  15.911  1.00  0.00           H  
ATOM    983  HA  ASN A 508     -28.358 -14.788  15.765  1.00  0.00           H  
ATOM    984  HB2 ASN A 508     -28.806 -15.878  17.933  1.00  0.00           H  
ATOM    985  HB3 ASN A 508     -27.123 -15.381  17.780  1.00  0.00           H  
ATOM    986 HD21 ASN A 508     -26.324 -14.548  19.553  1.00  0.00           H  
ATOM    987 HD22 ASN A 508     -27.189 -13.634  20.737  1.00  0.00           H  
ATOM    988  N   ASP A 509     -30.343 -12.831  15.845  1.00  0.00           N  
ATOM    989  CA  ASP A 509     -31.714 -12.333  15.804  1.00  0.00           C  
ATOM    990  C   ASP A 509     -32.093 -11.672  17.125  1.00  0.00           C  
ATOM    991  O   ASP A 509     -33.231 -11.779  17.580  1.00  0.00           O  
ATOM    992  CB  ASP A 509     -32.684 -13.474  15.493  1.00  0.00           C  
ATOM    993  CG  ASP A 509     -32.474 -14.053  14.107  1.00  0.00           C  
ATOM    994  OD1 ASP A 509     -31.805 -13.393  13.283  1.00  0.00           O  
ATOM    995  OD2 ASP A 509     -32.978 -15.164  13.845  1.00  0.00           O  
ATOM    996  H   ASP A 509     -29.685 -12.471  15.215  1.00  0.00           H  
ATOM    997  HA  ASP A 509     -31.774 -11.597  15.015  1.00  0.00           H  
ATOM    998  HB2 ASP A 509     -32.545 -14.264  16.215  1.00  0.00           H  
ATOM    999  HB3 ASP A 509     -33.696 -13.104  15.559  1.00  0.00           H  
ATOM   1000  N   LYS A 510     -31.130 -10.987  17.734  1.00  0.00           N  
ATOM   1001  CA  LYS A 510     -31.361 -10.305  19.001  1.00  0.00           C  
ATOM   1002  C   LYS A 510     -30.650  -8.956  19.028  1.00  0.00           C  
ATOM   1003  O   LYS A 510     -29.590  -8.788  18.425  1.00  0.00           O  
ATOM   1004  CB  LYS A 510     -30.881 -11.171  20.166  1.00  0.00           C  
ATOM   1005  CG  LYS A 510     -31.702 -12.435  20.364  1.00  0.00           C  
ATOM   1006  CD  LYS A 510     -32.960 -12.161  21.173  1.00  0.00           C  
ATOM   1007  CE  LYS A 510     -34.186 -12.065  20.280  1.00  0.00           C  
ATOM   1008  NZ  LYS A 510     -35.432 -11.853  21.067  1.00  0.00           N  
ATOM   1009  H   LYS A 510     -30.244 -10.937  17.318  1.00  0.00           H  
ATOM   1010  HA  LYS A 510     -32.424 -10.140  19.099  1.00  0.00           H  
ATOM   1011  HB2 LYS A 510     -29.855 -11.458  19.987  1.00  0.00           H  
ATOM   1012  HB3 LYS A 510     -30.930 -10.589  21.075  1.00  0.00           H  
ATOM   1013  HG2 LYS A 510     -31.983 -12.826  19.399  1.00  0.00           H  
ATOM   1014  HG3 LYS A 510     -31.100 -13.164  20.888  1.00  0.00           H  
ATOM   1015  HD2 LYS A 510     -33.105 -12.964  21.880  1.00  0.00           H  
ATOM   1016  HD3 LYS A 510     -32.839 -11.229  21.704  1.00  0.00           H  
ATOM   1017  HE2 LYS A 510     -34.056 -11.235  19.600  1.00  0.00           H  
ATOM   1018  HE3 LYS A 510     -34.278 -12.980  19.715  1.00  0.00           H  
ATOM   1019  HZ1 LYS A 510     -35.314 -11.045  21.712  1.00  0.00           H  
ATOM   1020  HZ2 LYS A 510     -35.649 -12.702  21.628  1.00  0.00           H  
ATOM   1021  HZ3 LYS A 510     -36.231 -11.660  20.429  1.00  0.00           H  
ATOM   1022  N   MET A 511     -31.239  -7.997  19.735  1.00  0.00           N  
ATOM   1023  CA  MET A 511     -30.660  -6.662  19.841  1.00  0.00           C  
ATOM   1024  C   MET A 511     -29.670  -6.591  21.000  1.00  0.00           C  
ATOM   1025  O   MET A 511     -30.030  -6.838  22.152  1.00  0.00           O  
ATOM   1026  CB  MET A 511     -31.763  -5.619  20.032  1.00  0.00           C  
ATOM   1027  CG  MET A 511     -32.549  -5.792  21.323  1.00  0.00           C  
ATOM   1028  SD  MET A 511     -33.994  -4.717  21.406  1.00  0.00           S  
ATOM   1029  CE  MET A 511     -35.077  -5.516  20.224  1.00  0.00           C  
ATOM   1030  H   MET A 511     -32.082  -8.191  20.194  1.00  0.00           H  
ATOM   1031  HA  MET A 511     -30.135  -6.453  18.922  1.00  0.00           H  
ATOM   1032  HB2 MET A 511     -31.315  -4.637  20.038  1.00  0.00           H  
ATOM   1033  HB3 MET A 511     -32.452  -5.686  19.205  1.00  0.00           H  
ATOM   1034  HG2 MET A 511     -32.877  -6.818  21.392  1.00  0.00           H  
ATOM   1035  HG3 MET A 511     -31.899  -5.566  22.156  1.00  0.00           H  
ATOM   1036  HE1 MET A 511     -35.093  -4.944  19.308  1.00  0.00           H  
ATOM   1037  HE2 MET A 511     -36.075  -5.571  20.630  1.00  0.00           H  
ATOM   1038  HE3 MET A 511     -34.716  -6.513  20.020  1.00  0.00           H  
ATOM   1039  N   HIS A 512     -28.424  -6.254  20.687  1.00  0.00           N  
ATOM   1040  CA  HIS A 512     -27.382  -6.150  21.703  1.00  0.00           C  
ATOM   1041  C   HIS A 512     -26.632  -4.827  21.583  1.00  0.00           C  
ATOM   1042  O   HIS A 512     -26.646  -4.187  20.531  1.00  0.00           O  
ATOM   1043  CB  HIS A 512     -26.400  -7.316  21.577  1.00  0.00           C  
ATOM   1044  CG  HIS A 512     -26.962  -8.628  22.032  1.00  0.00           C  
ATOM   1045  ND1 HIS A 512     -27.612  -9.501  21.186  1.00  0.00           N  
ATOM   1046  CD2 HIS A 512     -26.967  -9.214  23.252  1.00  0.00           C  
ATOM   1047  CE1 HIS A 512     -27.993 -10.568  21.867  1.00  0.00           C  
ATOM   1048  NE2 HIS A 512     -27.613 -10.419  23.122  1.00  0.00           N  
ATOM   1049  H   HIS A 512     -28.199  -6.069  19.751  1.00  0.00           H  
ATOM   1050  HA  HIS A 512     -27.858  -6.195  22.672  1.00  0.00           H  
ATOM   1051  HB2 HIS A 512     -26.106  -7.422  20.543  1.00  0.00           H  
ATOM   1052  HB3 HIS A 512     -25.524  -7.106  22.173  1.00  0.00           H  
ATOM   1053  HD1 HIS A 512     -27.772  -9.361  20.229  1.00  0.00           H  
ATOM   1054  HD2 HIS A 512     -26.541  -8.809  24.160  1.00  0.00           H  
ATOM   1055  HE1 HIS A 512     -28.523 -11.419  21.463  1.00  0.00           H  
ATOM   1056  HE2 HIS A 512     -27.695 -11.099  23.822  1.00  0.00           H  
ATOM   1057  N   PHE A 513     -25.977  -4.424  22.667  1.00  0.00           N  
ATOM   1058  CA  PHE A 513     -25.220  -3.179  22.685  1.00  0.00           C  
ATOM   1059  C   PHE A 513     -23.723  -3.456  22.777  1.00  0.00           C  
ATOM   1060  O   PHE A 513     -23.282  -4.265  23.592  1.00  0.00           O  
ATOM   1061  CB  PHE A 513     -25.661  -2.304  23.859  1.00  0.00           C  
ATOM   1062  CG  PHE A 513     -27.106  -1.896  23.794  1.00  0.00           C  
ATOM   1063  CD1 PHE A 513     -27.485  -0.745  23.122  1.00  0.00           C  
ATOM   1064  CD2 PHE A 513     -28.084  -2.664  24.405  1.00  0.00           C  
ATOM   1065  CE1 PHE A 513     -28.812  -0.367  23.061  1.00  0.00           C  
ATOM   1066  CE2 PHE A 513     -29.414  -2.290  24.347  1.00  0.00           C  
ATOM   1067  CZ  PHE A 513     -29.779  -1.141  23.672  1.00  0.00           C  
ATOM   1068  H   PHE A 513     -26.004  -4.978  23.475  1.00  0.00           H  
ATOM   1069  HA  PHE A 513     -25.421  -2.655  21.762  1.00  0.00           H  
ATOM   1070  HB2 PHE A 513     -25.512  -2.848  24.779  1.00  0.00           H  
ATOM   1071  HB3 PHE A 513     -25.062  -1.406  23.875  1.00  0.00           H  
ATOM   1072  HD1 PHE A 513     -26.730  -0.140  22.642  1.00  0.00           H  
ATOM   1073  HD2 PHE A 513     -27.801  -3.563  24.932  1.00  0.00           H  
ATOM   1074  HE1 PHE A 513     -29.095   0.533  22.533  1.00  0.00           H  
ATOM   1075  HE2 PHE A 513     -30.167  -2.898  24.827  1.00  0.00           H  
ATOM   1076  HZ  PHE A 513     -30.817  -0.848  23.627  1.00  0.00           H  
ATOM   1077  N   SER A 514     -22.947  -2.778  21.938  1.00  0.00           N  
ATOM   1078  CA  SER A 514     -21.500  -2.953  21.927  1.00  0.00           C  
ATOM   1079  C   SER A 514     -20.795  -1.642  21.590  1.00  0.00           C  
ATOM   1080  O   SER A 514     -21.221  -0.907  20.701  1.00  0.00           O  
ATOM   1081  CB  SER A 514     -21.102  -4.032  20.918  1.00  0.00           C  
ATOM   1082  OG  SER A 514     -19.706  -4.270  20.948  1.00  0.00           O  
ATOM   1083  H   SER A 514     -23.357  -2.146  21.311  1.00  0.00           H  
ATOM   1084  HA  SER A 514     -21.196  -3.267  22.914  1.00  0.00           H  
ATOM   1085  HB2 SER A 514     -21.617  -4.952  21.157  1.00  0.00           H  
ATOM   1086  HB3 SER A 514     -21.380  -3.712  19.924  1.00  0.00           H  
ATOM   1087  HG  SER A 514     -19.466  -4.663  21.791  1.00  0.00           H  
ATOM   1088  N   LEU A 515     -19.714  -1.356  22.309  1.00  0.00           N  
ATOM   1089  CA  LEU A 515     -18.949  -0.135  22.087  1.00  0.00           C  
ATOM   1090  C   LEU A 515     -17.597  -0.445  21.456  1.00  0.00           C  
ATOM   1091  O   LEU A 515     -16.987  -1.473  21.746  1.00  0.00           O  
ATOM   1092  CB  LEU A 515     -18.747   0.613  23.406  1.00  0.00           C  
ATOM   1093  CG  LEU A 515     -19.866   1.589  23.776  1.00  0.00           C  
ATOM   1094  CD1 LEU A 515     -19.524   2.328  25.060  1.00  0.00           C  
ATOM   1095  CD2 LEU A 515     -20.110   2.571  22.641  1.00  0.00           C  
ATOM   1096  H   LEU A 515     -19.423  -1.981  23.004  1.00  0.00           H  
ATOM   1097  HA  LEU A 515     -19.513   0.491  21.411  1.00  0.00           H  
ATOM   1098  HB2 LEU A 515     -18.655  -0.115  24.199  1.00  0.00           H  
ATOM   1099  HB3 LEU A 515     -17.823   1.170  23.343  1.00  0.00           H  
ATOM   1100  HG  LEU A 515     -20.778   1.034  23.942  1.00  0.00           H  
ATOM   1101 HD11 LEU A 515     -19.884   1.764  25.908  1.00  0.00           H  
ATOM   1102 HD12 LEU A 515     -19.993   3.301  25.050  1.00  0.00           H  
ATOM   1103 HD13 LEU A 515     -18.453   2.445  25.133  1.00  0.00           H  
ATOM   1104 HD21 LEU A 515     -20.924   2.216  22.026  1.00  0.00           H  
ATOM   1105 HD22 LEU A 515     -19.216   2.659  22.041  1.00  0.00           H  
ATOM   1106 HD23 LEU A 515     -20.363   3.539  23.049  1.00  0.00           H  
ATOM   1107  N   LYS A 516     -17.133   0.452  20.593  1.00  0.00           N  
ATOM   1108  CA  LYS A 516     -15.850   0.276  19.921  1.00  0.00           C  
ATOM   1109  C   LYS A 516     -14.869   1.368  20.332  1.00  0.00           C  
ATOM   1110  O   LYS A 516     -14.860   2.457  19.758  1.00  0.00           O  
ATOM   1111  CB  LYS A 516     -16.038   0.286  18.403  1.00  0.00           C  
ATOM   1112  CG  LYS A 516     -14.770  -0.038  17.632  1.00  0.00           C  
ATOM   1113  CD  LYS A 516     -14.995   0.039  16.131  1.00  0.00           C  
ATOM   1114  CE  LYS A 516     -13.760  -0.400  15.361  1.00  0.00           C  
ATOM   1115  NZ  LYS A 516     -13.282  -1.742  15.794  1.00  0.00           N  
ATOM   1116  H   LYS A 516     -17.665   1.253  20.404  1.00  0.00           H  
ATOM   1117  HA  LYS A 516     -15.450  -0.682  20.219  1.00  0.00           H  
ATOM   1118  HB2 LYS A 516     -16.790  -0.442  18.140  1.00  0.00           H  
ATOM   1119  HB3 LYS A 516     -16.378   1.267  18.101  1.00  0.00           H  
ATOM   1120  HG2 LYS A 516     -14.002   0.670  17.908  1.00  0.00           H  
ATOM   1121  HG3 LYS A 516     -14.450  -1.037  17.890  1.00  0.00           H  
ATOM   1122  HD2 LYS A 516     -15.819  -0.606  15.866  1.00  0.00           H  
ATOM   1123  HD3 LYS A 516     -15.231   1.059  15.863  1.00  0.00           H  
ATOM   1124  HE2 LYS A 516     -14.002  -0.436  14.308  1.00  0.00           H  
ATOM   1125  HE3 LYS A 516     -12.974   0.322  15.523  1.00  0.00           H  
ATOM   1126  HZ1 LYS A 516     -14.094  -2.362  15.992  1.00  0.00           H  
ATOM   1127  HZ2 LYS A 516     -12.708  -1.656  16.656  1.00  0.00           H  
ATOM   1128  HZ3 LYS A 516     -12.704  -2.174  15.047  1.00  0.00           H  
ATOM   1129  N   GLU A 517     -14.042   1.069  21.329  1.00  0.00           N  
ATOM   1130  CA  GLU A 517     -13.055   2.023  21.819  1.00  0.00           C  
ATOM   1131  C   GLU A 517     -12.116   2.458  20.699  1.00  0.00           C  
ATOM   1132  O   GLU A 517     -12.335   3.552  20.136  1.00  0.00           O  
ATOM   1133  CB  GLU A 517     -12.249   1.408  22.964  1.00  0.00           C  
ATOM   1134  CG  GLU A 517     -11.280   2.381  23.618  1.00  0.00           C  
ATOM   1135  CD  GLU A 517     -11.986   3.453  24.425  1.00  0.00           C  
ATOM   1136  OE1 GLU A 517     -13.119   3.198  24.887  1.00  0.00           O  
ATOM   1137  OE2 GLU A 517     -11.406   4.545  24.598  1.00  0.00           O  
ATOM   1138  OXT GLU A 517     -11.167   1.705  20.394  1.00  0.00           O  
ATOM   1139  H   GLU A 517     -14.099   0.184  21.746  1.00  0.00           H  
ATOM   1140  HA  GLU A 517     -13.584   2.888  22.187  1.00  0.00           H  
ATOM   1141  HB2 GLU A 517     -12.934   1.054  23.722  1.00  0.00           H  
ATOM   1142  HB3 GLU A 517     -11.682   0.572  22.585  1.00  0.00           H  
ATOM   1143  HG2 GLU A 517     -10.624   1.831  24.274  1.00  0.00           H  
ATOM   1144  HG3 GLU A 517     -10.697   2.860  22.845  1.00  0.00           H  
TER    1145      GLU A 517                                                      
END
MOLECULE T0443_97_230.pdb
ATOM    557  N   SER    97       9.444  13.904  25.999  1.00 32.65           N  
ATOM    558  CA  SER    97       9.019  13.771  27.400  1.00 32.55           C  
ATOM    559  C   SER    97       7.759  12.923  27.498  1.00 32.70           C  
ATOM    560  O   SER    97       7.026  12.769  26.517  1.00 33.71           O  
ATOM    561  CB  SER    97       8.716  15.139  27.997  1.00 32.59           C  
ATOM    562  OG  SER    97       7.547  15.663  27.400  1.00 31.84           O  
ATOM    563  N   ASP    98       7.467  12.409  28.690  1.00 33.19           N  
ATOM    564  CA  ASP    98       6.275  11.582  28.879  1.00 33.23           C  
ATOM    565  C   ASP    98       4.966  12.366  28.697  1.00 32.35           C  
ATOM    566  O   ASP    98       3.961  11.797  28.233  1.00 31.66           O  
ATOM    567  CB  ASP    98       6.314  10.868  30.227  1.00 34.81           C  
ATOM    568  CG  ASP    98       7.346   9.752  30.271  1.00 35.79           C  
ATOM    569  OD1 ASP    98       7.927   9.397  29.218  1.00 36.03           O  
ATOM    570  OD2 ASP    98       7.566   9.216  31.376  1.00 38.06           O  
ATOM    571  N   GLY    99       4.990  13.651  29.055  1.00 30.82           N  
ATOM    572  CA  GLY    99       3.842  14.548  28.894  1.00 30.89           C  
ATOM    573  C   GLY    99       3.507  14.851  27.439  1.00 31.23           C  
ATOM    574  O   GLY    99       2.338  14.867  27.051  1.00 32.26           O  
ATOM    575  N   ILE   100       4.532  15.128  26.633  1.00 31.16           N  
ATOM    576  CA  ILE   100       4.345  15.348  25.206  1.00 29.39           C  
ATOM    577  C   ILE   100       3.859  14.036  24.541  1.00 29.36           C  
ATOM    578  O   ILE   100       2.931  14.074  23.743  1.00 30.42           O  
ATOM    579  CB  ILE   100       5.637  15.902  24.562  1.00 30.48           C  
ATOM    580  CG1 ILE   100       5.934  17.321  25.075  1.00 31.37           C  
ATOM    581  CG2 ILE   100       5.542  15.941  23.038  1.00 30.03           C  
ATOM    582  CD1 ILE   100       4.947  18.391  24.593  1.00 31.63           C  
ATOM    583  N   LEU   101       4.433  12.889  24.915  1.00 27.54           N  
ATOM    584  CA  LEU   101       4.056  11.584  24.340  1.00 27.41           C  
ATOM    585  C   LEU   101       2.603  11.212  24.618  1.00 27.36           C  
ATOM    586  O   LEU   101       1.952  10.611  23.761  1.00 26.82           O  
ATOM    587  CB  LEU   101       4.997  10.452  24.813  1.00 27.14           C  
ATOM    588  CG  LEU   101       6.374  10.483  24.155  1.00 27.77           C  
ATOM    589  CD1 LEU   101       7.364   9.480  24.749  1.00 28.09           C  
ATOM    590  CD2 LEU   101       6.204  10.283  22.646  1.00 27.85           C  
ATOM    591  N   ALA   102       2.113  11.536  25.809  1.00 26.46           N  
ATOM    592  CA  ALA   102       0.725  11.313  26.148  1.00 27.20           C  
ATOM    593  C   ALA   102      -0.163  12.246  25.304  1.00 27.49           C  
ATOM    594  O   ALA   102      -1.179  11.829  24.744  1.00 28.34           O  
ATOM    595  CB  ALA   102       0.495  11.534  27.664  1.00 26.33           C  
ATOM    596  N   LEU   103       0.242  13.502  25.194  1.00 28.56           N  
ATOM    597  CA  LEU   103      -0.483  14.476  24.398  1.00 28.57           C  
ATOM    598  C   LEU   103      -0.498  14.094  22.928  1.00 30.29           C  
ATOM    599  O   LEU   103      -1.466  14.368  22.211  1.00 31.20           O  
ATOM    600  CB  LEU   103       0.150  15.852  24.550  1.00 27.97           C  
ATOM    601  CG  LEU   103      -0.540  16.927  23.734  1.00 27.93           C  
ATOM    602  CD1 LEU   103      -2.056  16.931  24.028  1.00 28.16           C  
ATOM    603  CD2 LEU   103       0.114  18.260  24.005  1.00 27.38           C  
ATOM    604  N   MET   104       0.578  13.477  22.459  1.00 30.91           N  
ATOM    605  CA  MET   104       0.587  13.021  21.088  1.00 31.03           C  
ATOM    606  C   MET   104      -0.356  11.843  20.907  1.00 31.30           C  
ATOM    607  O   MET   104      -1.078  11.768  19.908  1.00 31.91           O  
ATOM    608  CB  MET   104       2.011  12.700  20.593  1.00 29.78           C  
ATOM    609  CG  MET   104       2.852  13.953  20.409  1.00 29.50           C  
ATOM    610  SD  MET   104       4.547  13.560  19.600  0.75 28.40          SE  
ATOM    611  CE  MET   104       4.041  13.148  17.802  1.00 27.34           C  
ATOM    612  N   ASP   105      -0.376  10.926  21.857  1.00 31.23           N  
ATOM    613  CA  ASP   105      -1.286   9.791  21.726  1.00 32.67           C  
ATOM    614  C   ASP   105      -2.788  10.253  21.729  1.00 32.95           C  
ATOM    615  O   ASP   105      -3.590   9.801  20.916  1.00 32.42           O  
ATOM    616  CB  ASP   105      -0.974   8.721  22.766  1.00 32.38           C  
ATOM    617  CG  ASP   105      -1.939   7.573  22.686  1.00 33.91           C  
ATOM    618  OD1 ASP   105      -3.040   7.652  23.253  1.00 33.56           O  
ATOM    619  OD2 ASP   105      -1.555   6.530  22.122  1.00 35.97           O  
ATOM    620  N   PHE   106      -3.129  11.160  22.630  1.00 33.56           N  
ATOM    621  CA  PHE   106      -4.457  11.802  22.702  1.00 35.01           C  
ATOM    622  C   PHE   106      -4.878  12.370  21.332  1.00 36.24           C  
ATOM    623  O   PHE   106      -5.978  12.083  20.818  1.00 36.06           O  
ATOM    624  CB  PHE   106      -4.385  12.903  23.770  1.00 35.80           C  
ATOM    625  CG  PHE   106      -5.655  13.703  23.965  1.00 36.05           C  
ATOM    626  CD1 PHE   106      -6.880  13.073  24.216  1.00 35.54           C  
ATOM    627  CD2 PHE   106      -5.600  15.108  23.982  1.00 36.94           C  
ATOM    628  CE1 PHE   106      -8.029  13.817  24.425  1.00 36.07           C  
ATOM    629  CE2 PHE   106      -6.743  15.860  24.198  1.00 36.31           C  
ATOM    630  CZ  PHE   106      -7.966  15.215  24.432  1.00 36.38           C  
ATOM    631  N   GLU   107      -3.976  13.149  20.733  1.00 37.10           N  
ATOM    632  CA  GLU   107      -4.199  13.781  19.423  1.00 35.80           C  
ATOM    633  C   GLU   107      -4.382  12.751  18.330  1.00 35.02           C  
ATOM    634  O   GLU   107      -5.280  12.864  17.512  1.00 33.91           O  
ATOM    635  CB  GLU   107      -3.049  14.734  19.088  1.00 36.77           C  
ATOM    636  CG  GLU   107      -3.160  16.067  19.838  1.00 35.57           C  
ATOM    637  CD  GLU   107      -2.247  17.140  19.300  1.00 36.65           C  
ATOM    638  OE1 GLU   107      -1.006  16.977  19.321  1.00 37.42           O  
ATOM    639  OE2 GLU   107      -2.761  18.199  18.885  1.00 37.20           O  
ATOM    640  N   TYR   108      -3.534  11.735  18.321  1.00 34.20           N  
ATOM    641  CA  TYR   108      -3.688  10.676  17.353  1.00 35.65           C  
ATOM    642  C   TYR   108      -5.048   9.963  17.523  1.00 34.35           C  
ATOM    643  O   TYR   108      -5.718   9.617  16.551  1.00 34.92           O  
ATOM    644  CB  TYR   108      -2.523   9.682  17.454  1.00 35.28           C  
ATOM    645  CG  TYR   108      -2.558   8.616  16.409  1.00 35.58           C  
ATOM    646  CD1 TYR   108      -2.544   8.953  15.053  1.00 35.63           C  
ATOM    647  CD2 TYR   108      -2.590   7.270  16.761  1.00 34.32           C  
ATOM    648  CE1 TYR   108      -2.584   7.978  14.075  1.00 35.54           C  
ATOM    649  CE2 TYR   108      -2.619   6.298  15.802  1.00 35.87           C  
ATOM    650  CZ  TYR   108      -2.616   6.649  14.449  1.00 35.77           C  
ATOM    651  OH  TYR   108      -2.658   5.681  13.471  1.00 35.26           O  
ATOM    652  N   THR   109      -5.448   9.746  18.769  1.00 35.03           N  
ATOM    653  CA  THR   109      -6.698   9.064  19.076  1.00 33.68           C  
ATOM    654  C   THR   109      -7.861   9.886  18.507  1.00 31.85           C  
ATOM    655  O   THR   109      -8.816   9.315  18.010  1.00 32.82           O  
ATOM    656  CB  THR   109      -6.808   8.731  20.607  1.00 35.01           C  
ATOM    657  OG1 THR   109      -5.735   7.858  20.969  1.00 34.59           O  
ATOM    658  CG2 THR   109      -8.135   8.031  20.970  1.00 33.15           C  
ATOM    659  N   GLN   110      -7.801  11.217  18.549  1.00 30.28           N  
ATOM    660  CA  GLN   110      -8.859  12.002  17.968  1.00 30.39           C  
ATOM    661  C   GLN   110      -8.990  11.707  16.478  1.00 31.29           C  
ATOM    662  O   GLN   110     -10.103  11.494  15.963  1.00 30.97           O  
ATOM    663  CB  GLN   110      -8.678  13.509  18.239  1.00 31.63           C  
ATOM    664  CG  GLN   110      -8.869  13.893  19.712  1.00 31.90           C  
ATOM    665  CD  GLN   110      -8.517  15.343  19.995  1.00 33.22           C  
ATOM    666  OE1 GLN   110      -7.835  15.657  20.974  1.00 34.63           O  
ATOM    667  NE2 GLN   110      -8.977  16.233  19.134  1.00 35.22           N  
ATOM    668  N   LEU   111      -7.858  11.648  15.775  1.00 30.57           N  
ATOM    669  CA  LEU   111      -7.878  11.335  14.362  1.00 30.61           C  
ATOM    670  C   LEU   111      -8.434   9.911  14.164  1.00 31.02           C  
ATOM    671  O   LEU   111      -9.228   9.651  13.260  1.00 30.94           O  
ATOM    672  CB  LEU   111      -6.471  11.490  13.758  1.00 30.95           C  
ATOM    673  CG  LEU   111      -6.293  11.231  12.256  1.00 31.08           C  
ATOM    674  CD1 LEU   111      -7.111  12.147  11.455  1.00 30.25           C  
ATOM    675  CD2 LEU   111      -4.806  11.369  11.903  1.00 31.37           C  
ATOM    676  N   LEU   112      -8.077   8.985  15.037  1.00 31.17           N  
ATOM    677  CA  LEU   112      -8.657   7.657  14.911  1.00 31.52           C  
ATOM    678  C   LEU   112     -10.191   7.645  15.018  1.00 34.16           C  
ATOM    679  O   LEU   112     -10.858   6.803  14.374  1.00 33.67           O  
ATOM    680  CB  LEU   112      -8.070   6.724  15.939  1.00 30.68           C  
ATOM    681  CG  LEU   112      -6.630   6.333  15.739  1.00 28.89           C  
ATOM    682  CD1 LEU   112      -6.242   5.410  16.888  1.00 28.54           C  
ATOM    683  CD2 LEU   112      -6.406   5.663  14.382  1.00 28.98           C  
ATOM    684  N   ALA   113     -10.747   8.598  15.784  1.00 34.42           N  
ATOM    685  CA  ALA   113     -12.190   8.674  15.988  1.00 34.82           C  
ATOM    686  C   ALA   113     -12.821   9.386  14.806  1.00 36.77           C  
ATOM    687  O   ALA   113     -13.933   9.038  14.385  1.00 34.40           O  
ATOM    688  CB  ALA   113     -12.513   9.386  17.282  1.00 33.82           C  
ATOM    689  N   GLU   114     -12.105  10.396  14.285  1.00 38.02           N  
ATOM    690  CA  GLU   114     -12.525  11.148  13.083  1.00 38.27           C  
ATOM    691  C   GLU   114     -12.688  10.230  11.866  1.00 37.71           C  
ATOM    692  O   GLU   114     -13.631  10.376  11.072  1.00 35.85           O  
ATOM    693  CB  GLU   114     -11.479  12.231  12.748  1.00 38.46           C  
ATOM    694  CG  GLU   114     -11.625  12.955  11.411  1.00 38.44           C  
ATOM    695  CD  GLU   114     -12.912  13.774  11.263  1.00 39.18           C  
ATOM    696  OE1 GLU   114     -13.863  13.564  12.052  1.00 39.13           O  
ATOM    697  OE2 GLU   114     -12.969  14.629  10.339  1.00 38.38           O  
ATOM    698  N   VAL   115     -11.786   9.260  11.783  1.00 36.86           N  
ATOM    699  CA  VAL   115     -11.649   8.407  10.616  1.00 37.42           C  
ATOM    700  C   VAL   115     -12.283   7.031  10.766  1.00 37.20           C  
ATOM    701  O   VAL   115     -12.437   6.316   9.783  1.00 36.94           O  
ATOM    702  CB  VAL   115     -10.088   8.346  10.255  1.00 37.61           C  
ATOM    703  CG1 VAL   115      -9.631   7.000   9.754  1.00 37.26           C  
ATOM    704  CG2 VAL   115      -9.717   9.491   9.349  1.00 35.81           C  
ATOM    705  N   ALA   116     -12.693   6.662  11.972  1.00 37.42           N  
ATOM    706  CA  ALA   116     -13.258   5.331  12.187  1.00 37.49           C  
ATOM    707  C   ALA   116     -14.540   5.101  11.376  1.00 37.88           C  
ATOM    708  O   ALA   116     -15.338   6.015  11.165  1.00 37.84           O  
ATOM    709  CB  ALA   116     -13.500   5.083  13.680  1.00 38.00           C  
ATOM    710  N   GLN   117     -14.690   3.876  10.881  1.00 39.14           N  
ATOM    711  CA  GLN   117     -15.857   3.473  10.117  1.00 39.51           C  
ATOM    712  C   GLN   117     -16.844   2.904  11.096  1.00 39.20           C  
ATOM    713  O   GLN   117     -16.541   1.915  11.775  1.00 39.62           O  
ATOM    714  CB  GLN   117     -15.520   2.391   9.087  1.00 40.02           C  
ATOM    715  CG  GLN   117     -16.761   1.831   8.351  1.00 40.38           C  
ATOM    716  N   ILE   118     -18.023   3.517  11.148  1.00 38.74           N  
ATOM    717  CA  ILE   118     -19.100   3.113  12.047  1.00 37.74           C  
ATOM    718  C   ILE   118     -20.190   2.493  11.173  1.00 37.96           C  
ATOM    719  O   ILE   118     -20.690   3.184  10.284  1.00 37.83           O  
ATOM    720  CB  ILE   118     -19.650   4.354  12.786  1.00 36.97           C  
ATOM    721  CG1 ILE   118     -18.576   4.967  13.676  1.00 36.79           C  
ATOM    722  CG2 ILE   118     -20.836   3.996  13.663  1.00 37.44           C  
ATOM    723  CD1 ILE   118     -18.946   6.361  14.158  1.00 36.94           C  
ATOM    724  N   PRO   119     -20.504   1.180  11.345  1.00 37.96           N  
ATOM    725  CA  PRO   119     -21.559   0.572  10.535  1.00 37.61           C  
ATOM    726  C   PRO   119     -22.869   1.352  10.481  1.00 37.30           C  
ATOM    727  O   PRO   119     -23.244   2.008  11.459  1.00 37.04           O  
ATOM    728  CB  PRO   119     -21.800  -0.801  11.196  1.00 38.22           C  
ATOM    729  CG  PRO   119     -20.857  -0.881  12.383  1.00 38.45           C  
ATOM    730  CD  PRO   119     -19.820   0.169  12.178  1.00 38.93           C  
ATOM    731  N   ASP   120     -23.525   1.290   9.321  1.00 36.76           N  
ATOM    732  CA  ASP   120     -24.832   1.907   9.121  1.00 36.79           C  
ATOM    733  C   ASP   120     -25.816   1.213  10.070  1.00 36.53           C  
ATOM    734  O   ASP   120     -25.821  -0.020  10.190  1.00 36.76           O  
ATOM    735  CB  ASP   120     -25.290   1.781   7.665  1.00 35.70           C  
ATOM    736  N   ILE   121     -26.612   2.007  10.777  1.00 36.81           N  
ATOM    737  CA  ILE   121     -27.601   1.463  11.728  1.00 36.43           C  
ATOM    738  C   ILE   121     -29.007   1.772  11.216  1.00 36.10           C  
ATOM    739  O   ILE   121     -29.369   2.955  11.079  1.00 36.53           O  
ATOM    740  CB  ILE   121     -27.441   2.053  13.157  1.00 36.35           C  
ATOM    741  CG1 ILE   121     -26.346   1.342  13.987  1.00 36.03           C  
ATOM    742  CG2 ILE   121     -28.747   1.798  13.971  1.00 36.54           C  
ATOM    743  CD1 ILE   121     -25.097   1.027  13.356  1.00 35.96           C  
ATOM    744  N   PRO   122     -29.788   0.728  10.870  1.00 35.15           N  
ATOM    745  CA  PRO   122     -31.171   1.018  10.479  1.00 34.84           C  
ATOM    746  C   PRO   122     -31.915   1.759  11.588  1.00 34.29           C  
ATOM    747  O   PRO   122     -31.737   1.480  12.791  1.00 32.53           O  
ATOM    748  CB  PRO   122     -31.781  -0.367  10.236  1.00 35.03           C  
ATOM    749  CG  PRO   122     -30.621  -1.233   9.907  1.00 35.38           C  
ATOM    750  CD  PRO   122     -29.488  -0.711  10.766  1.00 35.15           C  
ATOM    751  N   ASP   123     -32.722   2.719  11.165  1.00 34.56           N  
ATOM    752  CA  ASP   123     -33.461   3.540  12.081  1.00 34.50           C  
ATOM    753  C   ASP   123     -34.829   2.908  12.365  1.00 33.08           C  
ATOM    754  O   ASP   123     -35.856   3.309  11.826  1.00 32.07           O  
ATOM    755  CB  ASP   123     -33.559   4.950  11.511  1.00 35.67           C  
ATOM    756  CG  ASP   123     -33.888   5.972  12.555  1.00 36.62           C  
ATOM    757  OD1 ASP   123     -33.929   5.622  13.755  1.00 37.75           O  
ATOM    758  OD2 ASP   123     -34.108   7.133  12.166  1.00 38.52           O  
ATOM    759  N   ILE   124     -34.798   1.901  13.241  1.00 32.79           N  
ATOM    760  CA  ILE   124     -35.975   1.159  13.684  1.00 31.54           C  
ATOM    761  C   ILE   124     -36.037   1.214  15.210  1.00 31.99           C  
ATOM    762  O   ILE   124     -35.290   1.969  15.851  1.00 31.86           O  
ATOM    763  CB  ILE   124     -35.939  -0.318  13.192  1.00 30.72           C  
ATOM    764  CG1 ILE   124     -34.792  -1.106  13.840  1.00 30.34           C  
ATOM    765  CG2 ILE   124     -35.842  -0.352  11.657  1.00 30.34           C  
ATOM    766  CD1 ILE   124     -34.778  -2.601  13.479  1.00 30.60           C  
ATOM    767  N   HIS   125     -36.940   0.427  15.795  1.00 31.68           N  
ATOM    768  CA  HIS   125     -37.063   0.371  17.238  1.00 30.63           C  
ATOM    769  C   HIS   125     -36.133  -0.690  17.806  1.00 31.38           C  
ATOM    770  O   HIS   125     -36.158  -1.848  17.378  1.00 31.11           O  
ATOM    771  CB  HIS   125     -38.491   0.061  17.652  1.00 30.09           C  
ATOM    772  CG  HIS   125     -38.703   0.103  19.128  1.00 29.67           C  
ATOM    773  ND1 HIS   125     -39.161   1.227  19.774  1.00 29.17           N  
ATOM    774  CD2 HIS   125     -38.504  -0.835  20.088  1.00 29.71           C  
ATOM    775  CE1 HIS   125     -39.249   0.976  21.071  1.00 30.24           C  
ATOM    776  NE2 HIS   125     -38.846  -0.265  21.288  1.00 29.36           N  
ATOM    777  N   TYR   126     -35.284  -0.281  18.752  1.00 32.16           N  
ATOM    778  CA  TYR   126     -34.413  -1.222  19.455  1.00 32.02           C  
ATOM    779  C   TYR   126     -34.825  -1.190  20.918  1.00 30.88           C  
ATOM    780  O   TYR   126     -34.697  -0.178  21.569  1.00 30.80           O  
ATOM    781  CB  TYR   126     -32.932  -0.859  19.288  1.00 31.79           C  
ATOM    782  CG  TYR   126     -32.460  -0.901  17.833  1.00 31.58           C  
ATOM    783  CD1 TYR   126     -32.175  -2.120  17.209  1.00 31.68           C  
ATOM    784  CD2 TYR   126     -32.302   0.271  17.090  1.00 31.54           C  
ATOM    785  CE1 TYR   126     -31.745  -2.176  15.868  1.00 31.67           C  
ATOM    786  CE2 TYR   126     -31.876   0.230  15.763  1.00 31.47           C  
ATOM    787  CZ  TYR   126     -31.592  -1.006  15.157  1.00 31.98           C  
ATOM    788  OH  TYR   126     -31.172  -1.075  13.832  1.00 32.02           O  
ATOM    789  N   SER   127     -35.346  -2.299  21.429  1.00 30.50           N  
ATOM    790  CA  SER   127     -35.776  -2.363  22.835  1.00 28.63           C  
ATOM    791  C   SER   127     -34.573  -2.540  23.798  1.00 28.44           C  
ATOM    792  O   SER   127     -33.393  -2.582  23.369  1.00 27.83           O  
ATOM    793  CB  SER   127     -36.712  -3.532  23.010  1.00 27.86           C  
ATOM    794  OG  SER   127     -35.992  -4.736  22.923  1.00 26.15           O  
ATOM    795  N   ASN   128     -34.881  -2.633  25.088  1.00 27.65           N  
ATOM    796  CA  ASN   128     -33.875  -2.896  26.115  1.00 27.69           C  
ATOM    797  C   ASN   128     -33.578  -4.373  26.171  1.00 27.51           C  
ATOM    798  O   ASN   128     -32.877  -4.812  27.051  1.00 26.32           O  
ATOM    799  CB  ASN   128     -34.288  -2.387  27.484  1.00 27.86           C  
ATOM    800  CG  ASN   128     -34.374  -0.865  27.550  1.00 29.20           C  
ATOM    801  OD1 ASN   128     -33.713  -0.173  26.812  1.00 30.68           O  
ATOM    802  ND2 ASN   128     -35.174  -0.362  28.454  1.00 30.11           N  
ATOM    803  N   ASP   129     -34.124  -5.130  25.235  1.00 29.56           N  
ATOM    804  CA  ASP   129     -33.754  -6.527  25.072  1.00 32.20           C  
ATOM    805  C   ASP   129     -32.702  -6.608  23.947  1.00 32.50           C  
ATOM    806  O   ASP   129     -32.026  -7.621  23.812  1.00 31.46           O  
ATOM    807  CB  ASP   129     -34.944  -7.367  24.692  1.00 32.76           C  
ATOM    808  CG  ASP   129     -34.645  -8.857  24.803  1.00 33.97           C  
ATOM    809  OD1 ASP   129     -34.244  -9.281  25.911  1.00 35.60           O  
ATOM    810  OD2 ASP   129     -34.794  -9.594  23.799  1.00 33.96           O  
ATOM    811  N   SER   130     -32.564  -5.529  23.158  1.00 33.49           N  
ATOM    812  CA  SER   130     -31.562  -5.471  22.058  1.00 34.51           C  
ATOM    813  C   SER   130     -30.140  -5.183  22.523  1.00 33.88           C  
ATOM    814  O   SER   130     -29.894  -4.208  23.252  1.00 34.32           O  
ATOM    815  CB  SER   130     -31.914  -4.418  20.997  1.00 35.21           C  
ATOM    816  OG  SER   130     -32.926  -4.883  20.134  1.00 37.41           O  
ATOM    817  N   LYS   131     -29.203  -5.992  22.028  1.00 32.98           N  
ATOM    818  CA  LYS   131     -27.788  -5.831  22.372  1.00 33.25           C  
ATOM    819  C   LYS   131     -27.079  -4.623  21.752  1.00 34.21           C  
ATOM    820  O   LYS   131     -27.345  -4.219  20.600  1.00 35.24           O  
ATOM    821  CB  LYS   131     -26.998  -7.079  21.997  1.00 32.43           C  
ATOM    822  CG  LYS   131     -27.365  -8.340  22.731  1.00 30.56           C  
ATOM    823  CD  LYS   131     -26.298  -9.360  22.420  1.00 30.14           C  
ATOM    824  CE  LYS   131     -26.583 -10.694  23.034  1.00 29.35           C  
ATOM    825  NZ  LYS   131     -25.600 -11.650  22.472  1.00 28.55           N  
ATOM    826  N   TYR   132     -26.167  -4.059  22.541  1.00 34.56           N  
ATOM    827  CA  TYR   132     -25.337  -2.923  22.138  1.00 34.57           C  
ATOM    828  C   TYR   132     -23.860  -3.303  22.258  1.00 34.03           C  
ATOM    829  O   TYR   132     -23.496  -4.298  22.895  1.00 34.91           O  
ATOM    830  CB  TYR   132     -25.671  -1.656  22.924  1.00 34.95           C  
ATOM    831  CG  TYR   132     -26.909  -0.970  22.392  1.00 35.34           C  
ATOM    832  CD1 TYR   132     -28.161  -1.550  22.548  1.00 34.93           C  
ATOM    833  CD2 TYR   132     -26.833   0.271  21.743  1.00 34.71           C  
ATOM    834  CE1 TYR   132     -29.296  -0.961  22.038  1.00 34.57           C  
ATOM    835  CE2 TYR   132     -27.960   0.871  21.238  1.00 35.07           C  
ATOM    836  CZ  TYR   132     -29.195   0.240  21.397  1.00 35.45           C  
ATOM    837  OH  TYR   132     -30.333   0.810  20.913  1.00 35.94           O  
ATOM    838  N   THR   133     -23.056  -2.574  21.513  1.00 33.01           N  
ATOM    839  CA  THR   133     -21.608  -2.737  21.451  1.00 33.04           C  
ATOM    840  C   THR   133     -21.076  -1.286  21.444  1.00 32.43           C  
ATOM    841  O   THR   133     -21.792  -0.373  21.008  1.00 31.13           O  
ATOM    842  CB  THR   133     -21.239  -3.499  20.159  1.00 33.45           C  
ATOM    843  OG1 THR   133     -19.837  -3.816  20.132  1.00 34.34           O  
ATOM    844  CG2 THR   133     -21.665  -2.709  18.889  1.00 32.15           C  
ATOM    845  N   PRO   134     -19.856  -1.044  21.947  1.00 33.28           N  
ATOM    846  CA  PRO   134     -19.356   0.372  21.853  1.00 32.73           C  
ATOM    847  C   PRO   134     -19.064   0.749  20.393  1.00 31.84           C  
ATOM    848  O   PRO   134     -18.792  -0.114  19.609  1.00 31.68           O  
ATOM    849  CB  PRO   134     -18.052   0.372  22.660  1.00 33.47           C  
ATOM    850  CG  PRO   134     -17.881  -1.021  23.202  1.00 34.04           C  
ATOM    851  CD  PRO   134     -18.877  -1.956  22.542  1.00 33.56           C  
ATOM    852  N   SER   135     -19.118   2.029  20.027  1.00 33.13           N  
ATOM    853  CA  SER   135     -18.845   2.424  18.654  0.50 31.70           C  
ATOM    855  C   SER   135     -17.407   2.086  18.288  1.00 32.82           C  
ATOM    856  O   SER   135     -16.504   2.197  19.131  1.00 34.51           O  
ATOM    857  CB  SER   135     -19.048   3.926  18.440  0.50 30.68           C  
ATOM    859  OG  SER   135     -18.698   4.292  17.117  0.50 27.27           O  
ATOM    861  N   PRO   136     -17.181   1.647  17.036  1.00 30.78           N  
ATOM    862  CA  PRO   136     -15.796   1.420  16.680  1.00 30.75           C  
ATOM    863  C   PRO   136     -15.003   2.724  16.706  1.00 31.52           C  
ATOM    864  O   PRO   136     -13.776   2.688  16.676  1.00 33.29           O  
ATOM    865  CB  PRO   136     -15.860   0.839  15.259  1.00 31.65           C  
ATOM    866  CG  PRO   136     -17.265   0.651  14.924  1.00 30.94           C  
ATOM    867  CD  PRO   136     -18.124   1.292  15.964  1.00 30.49           C  
ATOM    868  N   ALA   137     -15.693   3.870  16.781  1.00 32.33           N  
ATOM    869  CA  ALA   137     -15.056   5.159  16.842  1.00 33.46           C  
ATOM    870  C   ALA   137     -14.846   5.650  18.274  1.00 34.89           C  
ATOM    871  O   ALA   137     -14.559   6.845  18.467  1.00 34.59           O  
ATOM    872  CB  ALA   137     -15.902   6.193  16.070  1.00 32.66           C  
ATOM    873  N   ALA   138     -15.024   4.752  19.248  1.00 34.13           N  
ATOM    874  CA  ALA   138     -14.902   5.049  20.685  1.00 35.16           C  
ATOM    875  C   ALA   138     -13.668   4.388  21.264  1.00 35.13           C  
ATOM    876  O   ALA   138     -13.452   3.192  21.086  1.00 34.97           O  
ATOM    877  CB  ALA   138     -16.161   4.574  21.462  1.00 35.04           C  
ATOM    878  N   PHE   139     -12.870   5.180  21.959  1.00 35.95           N  
ATOM    879  CA  PHE   139     -11.614   4.734  22.528  1.00 36.87           C  
ATOM    880  C   PHE   139     -11.471   5.138  23.993  1.00 36.57           C  
ATOM    881  O   PHE   139     -11.821   6.270  24.388  1.00 36.96           O  
ATOM    882  CB  PHE   139     -10.447   5.322  21.731  1.00 37.58           C  
ATOM    883  CG  PHE   139     -10.437   4.917  20.257  1.00 38.18           C  
ATOM    884  CD1 PHE   139     -11.110   5.675  19.304  1.00 37.01           C  
ATOM    885  CD2 PHE   139      -9.756   3.790  19.838  1.00 37.84           C  
ATOM    886  CE1 PHE   139     -11.115   5.313  17.985  1.00 36.83           C  
ATOM    887  CE2 PHE   139      -9.764   3.431  18.501  1.00 37.78           C  
ATOM    888  CZ  PHE   139     -10.441   4.210  17.578  1.00 37.29           C  
ATOM    889  N   ILE   140     -10.952   4.201  24.778  1.00 35.26           N  
ATOM    890  CA  ILE   140     -10.656   4.414  26.186  1.00 36.28           C  
ATOM    891  C   ILE   140      -9.157   4.673  26.333  1.00 36.01           C  
ATOM    892  O   ILE   140      -8.360   3.790  25.981  1.00 35.21           O  
ATOM    893  CB  ILE   140     -10.980   3.153  27.042  1.00 36.47           C  
ATOM    894  CG1 ILE   140     -12.471   2.827  26.992  1.00 36.86           C  
ATOM    895  CG2 ILE   140     -10.505   3.359  28.507  1.00 36.54           C  
ATOM    896  CD1 ILE   140     -12.823   1.467  27.609  1.00 37.66           C  
ATOM    897  N   ARG   141      -8.788   5.832  26.895  1.00 35.41           N  
ATOM    898  CA  ARG   141      -7.369   6.211  27.124  1.00 34.78           C  
ATOM    899  C   ARG   141      -7.021   6.495  28.588  1.00 34.90           C  
ATOM    900  O   ARG   141      -7.810   7.115  29.289  1.00 34.61           O  
ATOM    901  CB  ARG   141      -7.002   7.454  26.281  1.00 34.37           C  
ATOM    902  CG  ARG   141      -6.906   7.196  24.783  1.00 34.55           C  
ATOM    903  CD  ARG   141      -5.886   6.100  24.513  1.00 34.71           C  
ATOM    904  NE  ARG   141      -5.766   5.735  23.120  1.00 35.21           N  
ATOM    905  CZ  ARG   141      -6.274   4.642  22.544  1.00 35.59           C  
ATOM    906  NH1 ARG   141      -6.948   3.726  23.222  1.00 36.12           N  
ATOM    907  NH2 ARG   141      -6.061   4.446  21.255  1.00 35.22           N  
ATOM    908  N   GLN   142      -5.829   6.055  29.026  1.00 35.09           N  
ATOM    909  CA  GLN   142      -5.313   6.302  30.408  1.00 34.44           C  
ATOM    910  C   GLN   142      -3.952   6.997  30.332  1.00 33.94           C  
ATOM    911  O   GLN   142      -2.990   6.428  29.822  1.00 33.71           O  
ATOM    912  CB  GLN   142      -5.165   4.993  31.211  1.00 34.70           C  
ATOM    913  CG  GLN   142      -6.405   4.095  31.212  1.00 34.93           C  
ATOM    914  CD  GLN   142      -6.277   2.878  32.097  1.00 35.35           C  
ATOM    915  OE1 GLN   142      -5.995   1.783  31.618  1.00 37.10           O  
ATOM    916  NE2 GLN   142      -6.483   3.062  33.407  1.00 35.35           N  
ATOM    917  N   TYR   143      -3.881   8.225  30.827  1.00 34.02           N  
ATOM    918  CA  TYR   143      -2.631   9.020  30.818  1.00 34.50           C  
ATOM    919  C   TYR   143      -2.240   9.431  32.225  1.00 34.11           C  
ATOM    920  O   TYR   143      -3.114   9.610  33.080  1.00 31.71           O  
ATOM    921  CB  TYR   143      -2.790  10.270  29.944  1.00 34.05           C  
ATOM    922  CG  TYR   143      -3.195   9.923  28.526  1.00 34.61           C  
ATOM    923  CD1 TYR   143      -2.358   9.148  27.710  1.00 34.14           C  
ATOM    924  CD2 TYR   143      -4.393  10.372  27.990  1.00 34.69           C  
ATOM    925  CE1 TYR   143      -2.723   8.821  26.415  1.00 34.01           C  
ATOM    926  CE2 TYR   143      -4.752  10.053  26.693  1.00 34.66           C  
ATOM    927  CZ  TYR   143      -3.917   9.279  25.920  1.00 33.99           C  
ATOM    928  OH  TYR   143      -4.288   8.971  24.642  1.00 34.35           O  
ATOM    929  N   ARG   144      -0.930   9.536  32.463  1.00 33.80           N  
ATOM    930  CA  ARG   144      -0.404   9.988  33.742  1.00 35.60           C  
ATOM    931  C   ARG   144      -0.280  11.510  33.721  1.00 34.05           C  
ATOM    932  O   ARG   144       0.192  12.107  34.681  1.00 33.51           O  
ATOM    933  CB  ARG   144       0.960   9.359  34.046  1.00 36.36           C  
ATOM    934  CG  ARG   144       0.991   7.822  33.954  1.00 38.03           C  
ATOM    935  CD  ARG   144       2.367   7.245  34.238  1.00 39.35           C  
ATOM    936  NE  ARG   144       3.382   8.268  34.007  1.00 41.24           N  
ATOM    937  CZ  ARG   144       4.601   8.071  33.506  1.00 42.86           C  
ATOM    938  NH1 ARG   144       5.012   6.867  33.093  1.00 43.50           N  
ATOM    939  NH2 ARG   144       5.405   9.127  33.377  1.00 42.35           N  
ATOM    940  N   TYR   145      -0.745  12.128  32.635  1.00 34.23           N  
ATOM    941  CA  TYR   145      -0.684  13.578  32.457  1.00 32.95           C  
ATOM    942  C   TYR   145      -2.013  14.174  32.013  1.00 33.09           C  
ATOM    943  O   TYR   145      -2.810  13.522  31.365  1.00 32.37           O  
ATOM    944  CB  TYR   145       0.391  13.878  31.438  1.00 33.59           C  
ATOM    945  CG  TYR   145       1.744  13.420  31.917  1.00 33.35           C  
ATOM    946  CD1 TYR   145       2.172  12.122  31.711  1.00 33.26           C  
ATOM    947  CD2 TYR   145       2.574  14.285  32.608  1.00 33.75           C  
ATOM    948  CE1 TYR   145       3.389  11.697  32.170  1.00 33.34           C  
ATOM    949  CE2 TYR   145       3.791  13.876  33.057  1.00 33.71           C  
ATOM    950  CZ  TYR   145       4.194  12.583  32.837  1.00 33.55           C  
ATOM    951  OH  TYR   145       5.411  12.193  33.306  1.00 34.34           O  
ATOM    952  N   ASP   146      -2.262  15.439  32.332  1.00 34.92           N  
ATOM    953  CA  ASP   146      -3.539  16.038  31.934  1.00 35.59           C  
ATOM    954  C   ASP   146      -3.410  16.548  30.509  1.00 36.12           C  
ATOM    955  O   ASP   146      -3.083  17.710  30.275  1.00 36.73           O  
ATOM    956  CB  ASP   146      -4.019  17.144  32.888  1.00 35.23           C  
ATOM    957  CG  ASP   146      -5.482  17.501  32.657  1.00 35.45           C  
ATOM    958  OD1 ASP   146      -6.054  17.045  31.633  1.00 35.51           O  
ATOM    959  OD2 ASP   146      -6.072  18.196  33.509  1.00 34.99           O  
ATOM    960  N   VAL   147      -3.683  15.652  29.569  1.00 36.09           N  
ATOM    961  CA  VAL   147      -3.580  15.934  28.139  1.00 36.00           C  
ATOM    962  C   VAL   147      -4.681  16.859  27.646  1.00 37.54           C  
ATOM    963  O   VAL   147      -4.578  17.393  26.557  1.00 38.09           O  
ATOM    964  CB  VAL   147      -3.653  14.622  27.297  1.00 35.38           C  
ATOM    965  CG1 VAL   147      -2.531  13.675  27.681  1.00 34.28           C  
ATOM    966  CG2 VAL   147      -5.046  13.949  27.459  1.00 35.03           C  
ATOM    967  N   THR   148      -5.742  17.046  28.430  1.00 40.08           N  
ATOM    968  CA  THR   148      -6.843  17.939  28.035  1.00 40.62           C  
ATOM    969  C   THR   148      -6.586  19.399  28.419  1.00 41.55           C  
ATOM    970  O   THR   148      -7.293  20.309  27.964  1.00 40.82           O  
ATOM    971  CB  THR   148      -8.162  17.553  28.734  1.00 41.38           C  
ATOM    972  OG1 THR   148      -8.043  17.840  30.131  1.00 41.87           O  
ATOM    973  CG2 THR   148      -8.513  16.076  28.536  1.00 40.38           C  
ATOM    974  N   HIS   149      -5.595  19.618  29.276  1.00 42.58           N  
ATOM    975  CA  HIS   149      -5.297  20.956  29.770  1.00 43.38           C  
ATOM    976  C   HIS   149      -3.855  21.343  29.493  1.00 44.04           C  
ATOM    977  O   HIS   149      -3.579  21.904  28.430  1.00 43.03           O  
ATOM    978  CB  HIS   149      -5.634  21.082  31.267  1.00 44.14           C  
ATOM    979  CG  HIS   149      -5.333  22.430  31.836  1.00 44.34           C  
ATOM    980  ND1 HIS   149      -4.211  22.681  32.599  1.00 45.27           N  
ATOM    981  CD2 HIS   149      -5.980  23.614  31.721  1.00 44.87           C  
ATOM    982  CE1 HIS   149      -4.182  23.959  32.938  1.00 44.79           C  
ATOM    983  NE2 HIS   149      -5.249  24.547  32.422  1.00 44.80           N  
ATOM    984  N   ASP   150      -2.930  21.021  30.401  1.00 44.79           N  
ATOM    985  CA  ASP   150      -1.545  21.482  30.234  1.00 45.74           C  
ATOM    986  C   ASP   150      -0.462  20.502  30.737  1.00 45.36           C  
ATOM    987  O   ASP   150       0.588  20.917  31.227  1.00 44.69           O  
ATOM    988  CB  ASP   150      -1.397  22.858  30.890  1.00 46.83           C  
ATOM    989  CG  ASP   150      -0.334  23.714  30.233  1.00 48.68           C  
ATOM    990  OD1 ASP   150       0.428  23.212  29.361  1.00 50.39           O  
ATOM    991  OD2 ASP   150      -0.277  24.916  30.573  1.00 49.33           O  
ATOM    992  N   LEU   151      -0.739  19.209  30.572  1.00 44.73           N  
ATOM    993  CA  LEU   151       0.187  18.114  30.895  1.00 44.03           C  
ATOM    994  C   LEU   151       0.579  18.010  32.352  1.00 43.81           C  
ATOM    995  O   LEU   151       1.716  17.673  32.662  1.00 43.47           O  
ATOM    996  CB  LEU   151       1.441  18.183  30.011  1.00 43.12           C  
ATOM    997  CG  LEU   151       1.178  18.324  28.509  1.00 42.79           C  
ATOM    998  CD1 LEU   151       2.482  18.181  27.706  1.00 41.99           C  
ATOM    999  CD2 LEU   151       0.145  17.316  28.042  1.00 42.24           C  
ATOM   1000  N   GLN   152      -0.378  18.295  33.234  1.00 44.58           N  
ATOM   1001  CA  GLN   152      -0.191  18.162  34.682  1.00 44.48           C  
ATOM   1002  C   GLN   152       0.076  16.686  34.995  1.00 43.53           C  
ATOM   1003  O   GLN   152      -0.577  15.837  34.422  1.00 42.55           O  
ATOM   1004  CB  GLN   152      -1.480  18.582  35.445  1.00 44.70           C  
ATOM   1005  CG  GLN   152      -1.749  20.098  35.662  1.00 45.24           C  
ATOM   1006  CD  GLN   152      -2.106  20.916  34.406  1.00 45.34           C  
ATOM   1007  OE1 GLN   152      -2.549  20.376  33.391  1.00 43.86           O  
ATOM   1008  NE2 GLN   152      -1.931  22.247  34.501  1.00 45.02           N  
ATOM   1009  N   GLU   153       1.051  16.373  35.851  1.00 43.57           N  
ATOM   1010  CA  GLU   153       1.211  14.992  36.314  1.00 43.21           C  
ATOM   1011  C   GLU   153      -0.005  14.717  37.178  1.00 42.36           C  
ATOM   1012  O   GLU   153      -0.084  15.217  38.289  1.00 42.69           O  
ATOM   1013  CB  GLU   153       2.466  14.763  37.150  1.00 43.26           C  
ATOM   1014  CG  GLU   153       3.628  14.244  36.395  1.00 44.27           C  
ATOM   1015  CD  GLU   153       4.799  13.889  37.298  1.00 45.15           C  
ATOM   1016  OE1 GLU   153       5.089  14.665  38.243  1.00 46.26           O  
ATOM   1017  OE2 GLU   153       5.453  12.849  37.043  1.00 46.21           O  
ATOM   1018  N   ALA   154      -0.938  13.936  36.642  1.00 41.00           N  
ATOM   1019  CA  ALA   154      -2.180  13.601  37.311  1.00 40.63           C  
ATOM   1020  C   ALA   154      -2.851  12.510  36.492  1.00 39.98           C  
ATOM   1021  O   ALA   154      -3.087  12.710  35.296  1.00 40.14           O  
ATOM   1022  CB  ALA   154      -3.083  14.827  37.394  1.00 40.73           C  
ATOM   1023  N   GLU   155      -3.118  11.358  37.113  1.00 39.02           N  
ATOM   1024  CA  GLU   155      -3.806  10.248  36.442  1.00 38.44           C  
ATOM   1025  C   GLU   155      -5.091  10.729  35.778  1.00 38.05           C  
ATOM   1026  O   GLU   155      -6.012  11.181  36.454  1.00 36.52           O  
ATOM   1027  CB  GLU   155      -4.125   9.092  37.413  1.00 38.51           C  
ATOM   1028  CG  GLU   155      -2.928   8.203  37.826  1.00 39.18           C  
ATOM   1029  CD  GLU   155      -2.304   7.406  36.667  1.00 39.11           C  
ATOM   1030  OE1 GLU   155      -2.806   7.502  35.528  1.00 39.80           O  
ATOM   1031  OE2 GLU   155      -1.309   6.676  36.900  1.00 39.33           O  
ATOM   1032  N   THR   156      -5.150  10.605  34.450  1.00 38.58           N  
ATOM   1033  CA  THR   156      -6.315  11.049  33.668  1.00 39.32           C  
ATOM   1034  C   THR   156      -6.908   9.901  32.842  1.00 38.56           C  
ATOM   1035  O   THR   156      -6.191   9.175  32.177  1.00 38.94           O  
ATOM   1036  CB  THR   156      -5.961  12.238  32.748  1.00 39.69           C  
ATOM   1037  OG1 THR   156      -5.110  13.151  33.460  1.00 39.65           O  
ATOM   1038  CG2 THR   156      -7.238  12.951  32.288  1.00 38.88           C  
ATOM   1039  N   ALA   157      -8.228   9.758  32.907  1.00 38.33           N  
ATOM   1040  CA  ALA   157      -8.964   8.679  32.254  1.00 38.48           C  
ATOM   1041  C   ALA   157     -10.000   9.322  31.326  1.00 38.25           C  
ATOM   1042  O   ALA   157     -10.901  10.005  31.789  1.00 38.07           O  
ATOM   1043  CB  ALA   157      -9.649   7.780  33.328  1.00 37.18           C  
ATOM   1044  N   LEU   158      -9.871   9.098  30.019  1.00 38.80           N  
ATOM   1045  CA  LEU   158     -10.745   9.736  29.012  1.00 38.15           C  
ATOM   1046  C   LEU   158     -11.397   8.749  28.057  1.00 38.07           C  
ATOM   1047  O   LEU   158     -10.844   7.676  27.783  1.00 37.00           O  
ATOM   1048  CB  LEU   158      -9.907  10.718  28.177  1.00 37.77           C  
ATOM   1049  CG  LEU   158      -9.233  11.893  28.915  1.00 38.21           C  
ATOM   1050  CD1 LEU   158      -8.066  12.510  28.104  1.00 36.98           C  
ATOM   1051  CD2 LEU   158     -10.248  12.946  29.326  1.00 36.74           C  
ATOM   1052  N   LEU   159     -12.573   9.125  27.553  1.00 38.32           N  
ATOM   1053  CA  LEU   159     -13.288   8.364  26.494  1.00 37.73           C  
ATOM   1054  C   LEU   159     -13.305   9.288  25.310  1.00 37.07           C  
ATOM   1055  O   LEU   159     -13.845  10.410  25.428  1.00 37.83           O  
ATOM   1056  CB  LEU   159     -14.742   8.037  26.854  1.00 37.83           C  
ATOM   1057  CG  LEU   159     -15.545   7.301  25.775  1.00 38.57           C  
ATOM   1058  CD1 LEU   159     -14.891   5.919  25.489  1.00 38.98           C  
ATOM   1059  CD2 LEU   159     -17.048   7.119  26.134  1.00 37.71           C  
ATOM   1060  N   ILE   160     -12.697   8.869  24.198  1.00 35.82           N  
ATOM   1061  CA  ILE   160     -12.689   9.678  22.962  1.00 35.81           C  
ATOM   1062  C   ILE   160     -13.626   8.993  21.964  1.00 35.30           C  
ATOM   1063  O   ILE   160     -13.571   7.751  21.790  1.00 32.61           O  
ATOM   1064  CB  ILE   160     -11.259   9.822  22.346  1.00 35.67           C  
ATOM   1065  CG1 ILE   160     -10.329  10.615  23.269  1.00 36.38           C  
ATOM   1066  CG2 ILE   160     -11.341  10.519  21.005  1.00 36.24           C  
ATOM   1067  CD1 ILE   160      -9.693   9.814  24.356  1.00 35.92           C  
ATOM   1068  N   TRP   161     -14.533   9.753  21.358  1.00 34.16           N  
ATOM   1069  CA  TRP   161     -15.456   9.155  20.384  1.00 35.62           C  
ATOM   1070  C   TRP   161     -15.980  10.135  19.343  1.00 36.26           C  
ATOM   1071  O   TRP   161     -15.693  11.326  19.429  1.00 35.77           O  
ATOM   1072  CB  TRP   161     -16.644   8.522  21.109  1.00 37.38           C  
ATOM   1073  CG  TRP   161     -17.718   9.455  21.577  1.00 37.18           C  
ATOM   1074  CD1 TRP   161     -18.903   9.685  20.966  1.00 37.71           C  
ATOM   1075  CD2 TRP   161     -17.728  10.237  22.773  1.00 37.19           C  
ATOM   1076  NE1 TRP   161     -19.642  10.576  21.678  1.00 37.89           N  
ATOM   1077  CE2 TRP   161     -18.945  10.934  22.798  1.00 38.42           C  
ATOM   1078  CE3 TRP   161     -16.816  10.435  23.808  1.00 37.18           C  
ATOM   1079  CZ2 TRP   161     -19.276  11.835  23.813  1.00 38.40           C  
ATOM   1080  CZ3 TRP   161     -17.142  11.285  24.818  1.00 37.74           C  
ATOM   1081  CH2 TRP   161     -18.369  11.986  24.824  1.00 38.15           C  
ATOM   1082  N   ARG   162     -16.759   9.632  18.381  1.00 36.30           N  
ATOM   1083  CA  ARG   162     -17.405  10.495  17.383  1.00 36.65           C  
ATOM   1084  C   ARG   162     -18.910  10.371  17.580  1.00 36.51           C  
ATOM   1085  O   ARG   162     -19.440   9.263  17.606  1.00 35.78           O  
ATOM   1086  CB  ARG   162     -17.036  10.123  15.944  1.00 36.17           C  
ATOM   1087  CG  ARG   162     -17.505  11.169  14.969  1.00 36.54           C  
ATOM   1088  CD  ARG   162     -16.821  11.107  13.626  1.00 36.00           C  
ATOM   1089  NE  ARG   162     -17.436  10.134  12.715  1.00 35.70           N  
ATOM   1090  CZ  ARG   162     -17.007   8.899  12.463  1.00 35.72           C  
ATOM   1091  NH1 ARG   162     -15.925   8.408  13.036  1.00 36.11           N  
ATOM   1092  NH2 ARG   162     -17.668   8.156  11.588  1.00 35.62           N  
ATOM   1093  N   ASN   163     -19.597  11.505  17.694  1.00 37.07           N  
ATOM   1094  CA  ASN   163     -21.015  11.459  18.004  1.00 38.11           C  
ATOM   1095  C   ASN   163     -21.908  11.453  16.780  1.00 39.76           C  
ATOM   1096  O   ASN   163     -21.410  11.428  15.668  1.00 40.47           O  
ATOM   1097  CB  ASN   163     -21.359  12.566  18.979  1.00 37.72           C  
ATOM   1098  CG  ASN   163     -21.269  13.932  18.358  1.00 37.22           C  
ATOM   1099  OD1 ASN   163     -21.160  14.070  17.146  1.00 38.13           O  
ATOM   1100  ND2 ASN   163     -21.356  14.949  19.185  1.00 37.50           N  
ATOM   1101  N   ALA   164     -23.226  11.443  16.989  1.00 41.32           N  
ATOM   1102  CA  ALA   164     -24.203  11.411  15.897  1.00 41.49           C  
ATOM   1103  C   ALA   164     -24.046  12.531  14.871  1.00 42.17           C  
ATOM   1104  O   ALA   164     -24.417  12.345  13.715  1.00 41.92           O  
ATOM   1105  CB  ALA   164     -25.641  11.401  16.471  1.00 42.29           C  
ATOM   1106  N   GLU   165     -23.515  13.682  15.289  1.00 42.49           N  
ATOM   1107  CA  GLU   165     -23.253  14.805  14.375  1.00 43.04           C  
ATOM   1108  C   GLU   165     -21.858  14.735  13.715  1.00 42.42           C  
ATOM   1109  O   GLU   165     -21.395  15.723  13.153  1.00 40.99           O  
ATOM   1110  CB  GLU   165     -23.353  16.131  15.123  1.00 43.93           C  
ATOM   1111  CG  GLU   165     -24.748  16.511  15.540  1.00 45.40           C  
ATOM   1112  CD  GLU   165     -24.763  17.805  16.346  1.00 46.25           C  
ATOM   1113  OE1 GLU   165     -24.250  17.781  17.504  1.00 47.45           O  
ATOM   1114  OE2 GLU   165     -25.300  18.828  15.826  1.00 47.05           O  
ATOM   1115  N   ASP   166     -21.201  13.579  13.808  1.00 40.89           N  
ATOM   1116  CA  ASP   166     -19.862  13.355  13.259  1.00 41.15           C  
ATOM   1117  C   ASP   166     -18.775  14.319  13.804  1.00 40.03           C  
ATOM   1118  O   ASP   166     -17.812  14.628  13.100  1.00 38.42           O  
ATOM   1119  CB  ASP   166     -19.876  13.307  11.704  1.00 41.47           C  
ATOM   1120  CG  ASP   166     -20.427  11.982  11.143  1.00 41.09           C  
ATOM   1121  OD1 ASP   166     -20.142  10.911  11.701  1.00 40.80           O  
ATOM   1122  OD2 ASP   166     -21.117  12.003  10.101  1.00 41.82           O  
ATOM   1123  N   ASP   167     -18.934  14.767  15.057  1.00 40.27           N  
ATOM   1124  CA  ASP   167     -17.931  15.619  15.742  1.00 40.57           C  
ATOM   1125  C   ASP   167     -17.164  14.774  16.756  1.00 39.01           C  
ATOM   1126  O   ASP   167     -17.783  13.962  17.449  1.00 39.31           O  
ATOM   1127  CB  ASP   167     -18.599  16.781  16.492  1.00 41.60           C  
ATOM   1128  CG  ASP   167     -19.185  17.828  15.566  1.00 42.34           C  
ATOM   1129  OD1 ASP   167     -18.468  18.360  14.701  1.00 43.82           O  
ATOM   1130  OD2 ASP   167     -20.363  18.165  15.743  1.00 44.30           O  
ATOM   1131  N   VAL   168     -15.838  14.958  16.829  1.00 36.76           N  
ATOM   1132  CA  VAL   168     -15.006  14.240  17.789  1.00 35.36           C  
ATOM   1133  C   VAL   168     -15.226  14.869  19.171  1.00 35.50           C  
ATOM   1134  O   VAL   168     -15.207  16.106  19.342  1.00 32.60           O  
ATOM   1135  CB  VAL   168     -13.510  14.245  17.431  1.00 35.37           C  
ATOM   1136  CG1 VAL   168     -12.719  13.431  18.436  1.00 35.65           C  
ATOM   1137  CG2 VAL   168     -13.292  13.682  16.052  1.00 35.05           C  
ATOM   1138  N   MET   169     -15.476  14.008  20.146  1.00 33.94           N  
ATOM   1139  CA  MET   169     -15.734  14.428  21.512  1.00 33.79           C  
ATOM   1140  C   MET   169     -14.858  13.600  22.453  1.00 34.81           C  
ATOM   1141  O   MET   169     -14.458  12.471  22.130  1.00 30.90           O  
ATOM   1142  CB  MET   169     -17.201  14.148  21.890  1.00 34.13           C  
ATOM   1143  CG  MET   169     -18.291  14.595  20.964  1.00 33.48           C  
ATOM   1144  SD  MET   169     -18.437  16.527  20.858  0.75 37.47          SE  
ATOM   1145  CE  MET   169     -19.112  16.847  22.681  1.00 31.68           C  
ATOM   1146  N   TYR   170     -14.569  14.167  23.618  1.00 35.79           N  
ATOM   1147  CA  TYR   170     -13.835  13.455  24.636  1.00 36.09           C  
ATOM   1148  C   TYR   170     -14.502  13.833  25.959  1.00 37.22           C  
ATOM   1149  O   TYR   170     -15.080  14.917  26.071  1.00 34.89           O  
ATOM   1150  CB  TYR   170     -12.317  13.783  24.601  1.00 36.65           C  
ATOM   1151  CG  TYR   170     -11.885  15.201  24.997  1.00 37.32           C  
ATOM   1152  CD1 TYR   170     -11.850  15.587  26.339  1.00 38.17           C  
ATOM   1153  CD2 TYR   170     -11.444  16.128  24.041  1.00 36.93           C  
ATOM   1154  CE1 TYR   170     -11.448  16.895  26.731  1.00 36.83           C  
ATOM   1155  CE2 TYR   170     -11.027  17.440  24.427  1.00 37.45           C  
ATOM   1156  CZ  TYR   170     -11.037  17.798  25.777  1.00 37.46           C  
ATOM   1157  OH  TYR   170     -10.647  19.065  26.197  1.00 37.82           O  
ATOM   1158  N   GLN   171     -14.427  12.950  26.952  1.00 36.97           N  
ATOM   1159  CA  GLN   171     -14.931  13.264  28.302  1.00 38.53           C  
ATOM   1160  C   GLN   171     -14.247  12.413  29.334  1.00 36.99           C  
ATOM   1161  O   GLN   171     -13.814  11.296  29.038  1.00 37.34           O  
ATOM   1162  CB  GLN   171     -16.450  13.039  28.429  1.00 39.94           C  
ATOM   1163  CG  GLN   171     -16.874  11.573  28.480  1.00 41.08           C  
ATOM   1164  CD  GLN   171     -18.399  11.383  28.609  1.00 42.57           C  
ATOM   1165  OE1 GLN   171     -19.202  12.314  28.348  1.00 45.34           O  
ATOM   1166  NE2 GLN   171     -18.801  10.179  29.008  1.00 44.67           N  
ATOM   1167  N   THR   172     -14.187  12.906  30.567  1.00 35.94           N  
ATOM   1168  CA  THR   172     -13.585  12.134  31.649  0.50 35.77           C  
ATOM   1170  C   THR   172     -14.403  10.853  31.826  1.00 35.48           C  
ATOM   1171  O   THR   172     -15.610  10.851  31.681  1.00 34.08           O  
ATOM   1172  CB  THR   172     -13.508  12.937  32.961  0.50 35.97           C  
ATOM   1174  OG1 THR   172     -14.832  13.263  33.407  0.50 36.62           O  
ATOM   1176  CG2 THR   172     -12.703  14.212  32.757  0.50 35.21           C  
ATOM   1178  N   LEU   173     -13.723   9.749  32.094  1.00 37.16           N  
ATOM   1179  CA  LEU   173     -14.361   8.480  32.248  1.00 38.77           C  
ATOM   1180  C   LEU   173     -14.133   8.031  33.687  1.00 41.89           C  
ATOM   1181  O   LEU   173     -12.973   7.958  34.150  1.00 42.80           O  
ATOM   1182  CB  LEU   173     -13.715   7.490  31.288  1.00 38.76           C  
ATOM   1183  CG  LEU   173     -14.480   6.251  30.833  1.00 38.66           C  
ATOM   1184  CD1 LEU   173     -15.783   6.646  30.191  1.00 36.48           C  
ATOM   1185  CD2 LEU   173     -13.607   5.482  29.866  1.00 37.79           C  
ATOM   1186  N   ASP   174     -15.226   7.774  34.412  1.00 43.53           N  
ATOM   1187  CA  ASP   174     -15.114   7.254  35.771  1.00 44.88           C  
ATOM   1188  C   ASP   174     -14.975   5.716  35.690  1.00 44.13           C  
ATOM   1189  O   ASP   174     -15.195   5.120  34.639  1.00 42.26           O  
ATOM   1190  CB  ASP   174     -16.253   7.760  36.706  1.00 45.97           C  
ATOM   1191  CG  ASP   174     -17.658   7.312  36.286  1.00 46.82           C  
ATOM   1192  OD1 ASP   174     -17.829   6.394  35.462  1.00 48.80           O  
ATOM   1193  OD2 ASP   174     -18.629   7.886  36.815  1.00 47.87           O  
ATOM   1194  N   GLY   175     -14.578   5.100  36.798  1.00 45.15           N  
ATOM   1195  CA  GLY   175     -14.337   3.644  36.858  1.00 46.19           C  
ATOM   1196  C   GLY   175     -15.469   2.691  36.490  1.00 46.07           C  
ATOM   1197  O   GLY   175     -15.213   1.631  35.921  1.00 44.48           O  
ATOM   1198  N   PHE   176     -16.705   3.029  36.858  1.00 47.77           N  
ATOM   1199  CA  PHE   176     -17.872   2.181  36.511  1.00 48.38           C  
ATOM   1200  C   PHE   176     -18.038   2.124  34.998  1.00 46.08           C  
ATOM   1201  O   PHE   176     -18.206   1.055  34.422  1.00 44.30           O  
ATOM   1202  CB  PHE   176     -19.184   2.741  37.104  1.00 50.64           C  
ATOM   1203  CG  PHE   176     -20.358   1.787  36.991  1.00 50.93           C  
ATOM   1204  CD1 PHE   176     -21.063   1.663  35.793  1.00 51.81           C  
ATOM   1205  CD2 PHE   176     -20.744   1.003  38.074  1.00 51.75           C  
ATOM   1206  CE1 PHE   176     -22.127   0.782  35.684  1.00 52.34           C  
ATOM   1207  CE2 PHE   176     -21.813   0.120  37.978  1.00 51.91           C  
ATOM   1208  CZ  PHE   176     -22.501   0.006  36.786  1.00 52.07           C  
ATOM   1209  N   ASP   177     -18.030   3.316  34.402  1.00 43.78           N  
ATOM   1210  CA  ASP   177     -18.138   3.506  32.961  1.00 42.31           C  
ATOM   1211  C   ASP   177     -17.038   2.803  32.187  1.00 40.47           C  
ATOM   1212  O   ASP   177     -17.315   2.124  31.183  1.00 38.92           O  
ATOM   1213  CB  ASP   177     -18.098   5.006  32.652  1.00 42.66           C  
ATOM   1214  CG  ASP   177     -19.338   5.708  33.107  1.00 43.24           C  
ATOM   1215  OD1 ASP   177     -20.192   5.039  33.727  1.00 43.85           O  
ATOM   1216  OD2 ASP   177     -19.479   6.910  32.810  1.00 42.81           O  
ATOM   1217  N   MET   178     -15.798   2.949  32.656  1.00 39.39           N  
ATOM   1218  CA  MET   178     -14.663   2.298  32.000  1.00 40.64           C  
ATOM   1219  C   MET   178     -14.869   0.766  31.995  1.00 40.74           C  
ATOM   1220  O   MET   178     -14.648   0.085  30.975  1.00 41.40           O  
ATOM   1221  CB  MET   178     -13.345   2.681  32.690  1.00 40.52           C  
ATOM   1222  CG  MET   178     -12.078   2.251  31.974  1.00 41.29           C  
ATOM   1223  SD  MET   178     -10.453   2.665  33.068  0.75 42.72          SE  
ATOM   1224  CE  MET   178     -10.429   4.544  32.789  1.00 41.52           C  
ATOM   1225  N   MET   179     -15.315   0.256  33.124  1.00 41.35           N  
ATOM   1226  CA  MET   179     -15.556  -1.178  33.300  1.00 43.56           C  
ATOM   1227  C   MET   179     -16.640  -1.689  32.352  1.00 41.60           C  
ATOM   1228  O   MET   179     -16.456  -2.675  31.679  1.00 41.85           O  
ATOM   1229  CB  MET   179     -15.942  -1.460  34.764  1.00 44.08           C  
ATOM   1230  CG  MET   179     -16.440  -2.879  35.053  1.00 45.36           C  
ATOM   1231  SD  MET   179     -16.813  -3.096  36.947  0.75 47.94          SE  
ATOM   1232  CE  MET   179     -14.922  -3.086  37.444  1.00 47.55           C  
ATOM   1233  N   LEU   180     -17.770  -1.002  32.329  1.00 41.88           N  
ATOM   1234  CA  LEU   180     -18.876  -1.351  31.456  1.00 41.24           C  
ATOM   1235  C   LEU   180     -18.467  -1.298  29.978  1.00 41.06           C  
ATOM   1236  O   LEU   180     -18.760  -2.229  29.222  1.00 41.65           O  
ATOM   1237  CB  LEU   180     -20.062  -0.411  31.683  1.00 42.02           C  
ATOM   1238  CG  LEU   180     -21.271  -0.875  30.862  1.00 42.92           C  
ATOM   1239  CD1 LEU   180     -21.695  -2.288  31.332  1.00 42.64           C  
ATOM   1240  CD2 LEU   180     -22.429   0.094  30.902  1.00 41.63           C  
ATOM   1241  N   LEU   181     -17.805  -0.223  29.543  1.00 39.70           N  
ATOM   1242  CA  LEU   181     -17.411  -0.135  28.130  1.00 38.32           C  
ATOM   1243  C   LEU   181     -16.451  -1.246  27.773  1.00 38.31           C  
ATOM   1244  O   LEU   181     -16.532  -1.782  26.686  1.00 36.05           O  
ATOM   1245  CB  LEU   181     -16.762   1.183  27.782  1.00 38.28           C  
ATOM   1246  CG  LEU   181     -17.665   2.399  27.911  1.00 36.54           C  
ATOM   1247  CD1 LEU   181     -16.873   3.622  27.735  1.00 37.18           C  
ATOM   1248  CD2 LEU   181     -18.810   2.275  26.897  1.00 36.99           C  
ATOM   1249  N   GLU   182     -15.512  -1.535  28.669  1.00 38.51           N  
ATOM   1250  CA  GLU   182     -14.522  -2.609  28.446  1.00 40.12           C  
ATOM   1251  C   GLU   182     -15.173  -3.999  28.354  1.00 38.77           C  
ATOM   1252  O   GLU   182     -14.787  -4.833  27.514  1.00 41.22           O  
ATOM   1253  CB  GLU   182     -13.507  -2.634  29.591  1.00 41.80           C  
ATOM   1254  CG  GLU   182     -12.290  -3.511  29.311  1.00 42.74           C  
ATOM   1255  CD  GLU   182     -11.361  -2.891  28.303  1.00 43.71           C  
ATOM   1256  OE1 GLU   182     -11.405  -1.639  28.138  1.00 44.55           O  
ATOM   1257  OE2 GLU   182     -10.564  -3.644  27.703  1.00 44.05           O  
ATOM   1258  N   ILE   183     -16.106  -4.252  29.273  1.00 37.91           N  
ATOM   1259  CA  ILE   183     -16.902  -5.493  29.336  1.00 37.16           C  
ATOM   1260  C   ILE   183     -17.745  -5.546  28.049  1.00 36.31           C  
ATOM   1261  O   ILE   183     -17.742  -6.521  27.329  1.00 35.36           O  
ATOM   1262  CB  ILE   183     -17.828  -5.442  30.587  1.00 37.12           C  
ATOM   1263  CG1 ILE   183     -17.063  -5.750  31.869  1.00 36.95           C  
ATOM   1264  CG2 ILE   183     -19.031  -6.343  30.458  1.00 38.23           C  
ATOM   1265  CD1 ILE   183     -17.942  -5.655  33.137  1.00 37.12           C  
ATOM   1266  N   MET   184     -18.440  -4.454  27.744  1.00 35.71           N  
ATOM   1267  CA  MET   184     -19.238  -4.380  26.526  1.00 34.96           C  
ATOM   1268  C   MET   184     -18.418  -4.586  25.249  1.00 35.85           C  
ATOM   1269  O   MET   184     -18.939  -5.122  24.265  1.00 36.27           O  
ATOM   1270  CB  MET   184     -20.033  -3.085  26.446  1.00 33.23           C  
ATOM   1271  CG  MET   184     -21.222  -3.019  27.395  1.00 31.28           C  
ATOM   1272  SD  MET   184     -22.000  -1.323  27.109  0.75 33.38          SE  
ATOM   1273  CE  MET   184     -22.939  -1.763  25.378  1.00 31.32           C  
ATOM   1274  N   GLY   185     -17.148  -4.197  25.274  1.00 34.94           N  
ATOM   1275  CA  GLY   185     -16.274  -4.433  24.146  1.00 35.89           C  
ATOM   1276  C   GLY   185     -15.982  -5.923  24.017  1.00 37.67           C  
ATOM   1277  O   GLY   185     -15.725  -6.435  22.910  1.00 38.56           O  
ATOM   1278  N   SER   186     -16.026  -6.632  25.144  1.00 38.48           N  
ATOM   1279  CA  SER   186     -15.778  -8.080  25.147  1.00 39.76           C  
ATOM   1280  C   SER   186     -16.968  -8.860  24.587  1.00 40.37           C  
ATOM   1281  O   SER   186     -16.806  -9.865  23.877  1.00 40.00           O  
ATOM   1282  CB  SER   186     -15.495  -8.592  26.570  1.00 39.79           C  
ATOM   1283  OG  SER   186     -14.333  -8.012  27.134  1.00 39.83           O  
ATOM   1284  N   SER   187     -18.167  -8.445  24.965  1.00 40.53           N  
ATOM   1285  CA  SER   187     -19.350  -9.129  24.488  1.00 41.39           C  
ATOM   1286  C   SER   187     -20.579  -8.234  24.546  1.00 40.22           C  
ATOM   1287  O   SER   187     -20.978  -7.820  25.624  1.00 40.70           O  
ATOM   1288  CB  SER   187     -19.578 -10.406  25.298  1.00 42.49           C  
ATOM   1289  OG  SER   187     -19.582 -10.126  26.684  1.00 44.00           O  
ATOM   1290  N   ALA   188     -21.157  -7.973  23.372  1.00 38.68           N  
ATOM   1291  CA  ALA   188     -22.369  -7.193  23.207  1.00 38.36           C  
ATOM   1292  C   ALA   188     -23.358  -7.535  24.313  1.00 37.68           C  
ATOM   1293  O   ALA   188     -23.562  -8.701  24.646  1.00 39.44           O  
ATOM   1294  CB  ALA   188     -22.978  -7.454  21.840  1.00 36.97           C  
ATOM   1295  N   LEU   189     -23.989  -6.506  24.834  1.00 37.15           N  
ATOM   1296  CA  LEU   189     -24.850  -6.570  26.003  1.00 38.47           C  
ATOM   1297  C   LEU   189     -26.162  -5.759  25.830  1.00 37.16           C  
ATOM   1298  O   LEU   189     -26.156  -4.703  25.248  1.00 37.13           O  
ATOM   1299  CB  LEU   189     -24.006  -5.922  27.127  1.00 38.77           C  
ATOM   1300  CG  LEU   189     -24.536  -5.584  28.514  1.00 40.39           C  
ATOM   1301  CD1 LEU   189     -24.419  -6.807  29.417  1.00 41.44           C  
ATOM   1302  CD2 LEU   189     -23.760  -4.419  29.132  1.00 40.31           C  
ATOM   1303  N   SER   190     -27.282  -6.254  26.331  1.00 37.95           N  
ATOM   1304  CA  SER   190     -28.518  -5.453  26.348  1.00 37.69           C  
ATOM   1305  C   SER   190     -28.605  -4.730  27.687  1.00 36.73           C  
ATOM   1306  O   SER   190     -27.894  -5.081  28.625  1.00 33.55           O  
ATOM   1307  CB  SER   190     -29.771  -6.342  26.171  1.00 37.26           C  
ATOM   1308  OG  SER   190     -30.007  -7.182  27.293  1.00 35.50           O  
ATOM   1309  N   PHE   191     -29.451  -3.695  27.775  1.00 38.21           N  
ATOM   1310  CA  PHE   191     -29.691  -3.038  29.055  1.00 36.68           C  
ATOM   1311  C   PHE   191     -30.306  -4.054  30.014  1.00 36.63           C  
ATOM   1312  O   PHE   191     -29.943  -4.074  31.177  1.00 36.15           O  
ATOM   1313  CB  PHE   191     -30.633  -1.846  28.929  1.00 37.61           C  
ATOM   1314  CG  PHE   191     -30.909  -1.152  30.230  1.00 37.73           C  
ATOM   1315  CD1 PHE   191     -29.970  -0.294  30.788  1.00 38.70           C  
ATOM   1316  CD2 PHE   191     -32.107  -1.347  30.903  1.00 38.74           C  
ATOM   1317  CE1 PHE   191     -30.217   0.351  31.989  1.00 37.92           C  
ATOM   1318  CE2 PHE   191     -32.360  -0.703  32.102  1.00 37.90           C  
ATOM   1319  CZ  PHE   191     -31.407   0.148  32.643  1.00 38.10           C  
ATOM   1320  N   ASP   192     -31.220  -4.911  29.537  1.00 36.19           N  
ATOM   1321  CA  ASP   192     -31.854  -5.864  30.429  1.00 35.73           C  
ATOM   1322  C   ASP   192     -30.837  -6.798  31.035  1.00 34.04           C  
ATOM   1323  O   ASP   192     -30.936  -7.099  32.218  1.00 31.85           O  
ATOM   1324  CB  ASP   192     -32.991  -6.668  29.769  1.00 36.97           C  
ATOM   1325  CG  ASP   192     -34.241  -5.818  29.511  1.00 37.83           C  
ATOM   1326  OD1 ASP   192     -34.239  -4.589  29.827  1.00 36.14           O  
ATOM   1327  OD2 ASP   192     -35.215  -6.396  28.968  1.00 37.83           O  
ATOM   1328  N   THR   193     -29.882  -7.251  30.228  1.00 33.57           N  
ATOM   1329  CA  THR   193     -28.784  -8.108  30.701  1.00 33.05           C  
ATOM   1330  C   THR   193     -27.885  -7.293  31.674  1.00 33.22           C  
ATOM   1331  O   THR   193     -27.553  -7.752  32.763  1.00 32.46           O  
ATOM   1332  CB  THR   193     -27.951  -8.657  29.516  1.00 33.39           C  
ATOM   1333  OG1 THR   193     -28.748  -9.558  28.714  1.00 32.30           O  
ATOM   1334  CG2 THR   193     -26.703  -9.397  29.999  1.00 32.95           C  
ATOM   1335  N   LEU   194     -27.530  -6.061  31.321  1.00 33.14           N  
ATOM   1336  CA  LEU   194     -26.707  -5.264  32.232  1.00 32.74           C  
ATOM   1337  C   LEU   194     -27.412  -5.148  33.579  1.00 34.32           C  
ATOM   1338  O   LEU   194     -26.905  -5.610  34.606  1.00 34.58           O  
ATOM   1339  CB  LEU   194     -26.451  -3.866  31.655  1.00 33.10           C  
ATOM   1340  CG  LEU   194     -25.699  -2.841  32.508  1.00 32.84           C  
ATOM   1341  CD1 LEU   194     -24.341  -3.367  32.928  1.00 32.94           C  
ATOM   1342  CD2 LEU   194     -25.598  -1.508  31.737  1.00 32.98           C  
ATOM   1343  N   ALA   195     -28.597  -4.546  33.576  1.00 35.92           N  
ATOM   1344  CA  ALA   195     -29.320  -4.299  34.825  1.00 37.64           C  
ATOM   1345  C   ALA   195     -29.554  -5.561  35.667  1.00 37.88           C  
ATOM   1346  O   ALA   195     -29.464  -5.514  36.880  1.00 40.48           O  
ATOM   1347  CB  ALA   195     -30.639  -3.534  34.551  1.00 36.84           C  
ATOM   1348  N   GLN   196     -29.800  -6.697  35.042  1.00 39.20           N  
ATOM   1349  CA  GLN   196     -30.019  -7.934  35.786  1.00 39.69           C  
ATOM   1350  C   GLN   196     -28.737  -8.493  36.437  1.00 40.33           C  
ATOM   1351  O   GLN   196     -28.802  -9.184  37.470  1.00 41.04           O  
ATOM   1352  CB  GLN   196     -30.624  -9.008  34.858  1.00 40.42           C  
ATOM   1353  CG  GLN   196     -30.778 -10.420  35.472  1.00 40.58           C  
ATOM   1354  CD  GLN   196     -31.645 -10.452  36.735  1.00 41.73           C  
ATOM   1355  OE1 GLN   196     -32.548  -9.633  36.907  1.00 43.88           O  
ATOM   1356  NE2 GLN   196     -31.391 -11.423  37.606  1.00 41.67           N  
ATOM   1357  N   THR   197     -27.588  -8.255  35.810  1.00 38.92           N  
ATOM   1358  CA  THR   197     -26.328  -8.785  36.321  1.00 37.94           C  
ATOM   1359  C   THR   197     -25.937  -8.023  37.571  1.00 36.70           C  
ATOM   1360  O   THR   197     -25.409  -8.630  38.485  1.00 35.53           O  
ATOM   1361  CB  THR   197     -25.192  -8.642  35.280  1.00 39.04           C  
ATOM   1362  OG1 THR   197     -25.568  -9.302  34.071  1.00 39.48           O  
ATOM   1363  CG2 THR   197     -23.883  -9.235  35.804  1.00 39.19           C  
ATOM   1364  N   LEU   198     -26.194  -6.700  37.581  1.00 33.17           N  
ATOM   1365  CA  LEU   198     -25.887  -5.832  38.711  1.00 33.38           C  
ATOM   1366  C   LEU   198     -26.846  -5.943  39.894  1.00 34.22           C  
ATOM   1367  O   LEU   198     -26.519  -5.510  41.000  1.00 33.03           O  
ATOM   1368  CB  LEU   198     -25.853  -4.354  38.276  1.00 32.60           C  
ATOM   1369  CG  LEU   198     -24.821  -3.832  37.292  1.00 32.72           C  
ATOM   1370  CD1 LEU   198     -25.148  -2.360  36.810  1.00 29.29           C  
ATOM   1371  CD2 LEU   198     -23.429  -3.896  37.907  1.00 33.12           C  
ATOM   1372  N   VAL   199     -28.022  -6.522  39.683  1.00 36.58           N  
ATOM   1373  CA  VAL   199     -29.008  -6.681  40.750  1.00 37.54           C  
ATOM   1374  C   VAL   199     -28.443  -7.249  42.050  1.00 39.42           C  
ATOM   1375  O   VAL   199     -28.828  -6.816  43.151  1.00 39.34           O  
ATOM   1376  CB  VAL   199     -30.224  -7.544  40.276  1.00 36.98           C  
ATOM   1377  CG1 VAL   199     -30.957  -8.122  41.434  1.00 35.71           C  
ATOM   1378  CG2 VAL   199     -31.155  -6.689  39.401  1.00 36.23           C  
ATOM   1379  N   GLU   200     -27.521  -8.200  41.945  1.00 41.22           N  
ATOM   1380  CA  GLU   200     -26.982  -8.823  43.150  1.00 42.00           C  
ATOM   1381  C   GLU   200     -25.916  -7.994  43.879  1.00 41.83           C  
ATOM   1382  O   GLU   200     -25.615  -8.261  45.037  1.00 42.68           O  
ATOM   1383  CB  GLU   200     -26.468 -10.245  42.873  1.00 42.76           C  
ATOM   1384  CG  GLU   200     -25.208 -10.396  42.009  1.00 42.85           C  
ATOM   1385  CD  GLU   200     -24.499 -11.743  42.272  1.00 43.32           C  
ATOM   1386  OE1 GLU   200     -24.374 -12.129  43.462  1.00 44.06           O  
ATOM   1387  OE2 GLU   200     -24.040 -12.401  41.308  1.00 43.24           O  
ATOM   1388  N   PHE   201     -25.351  -6.989  43.227  1.00 41.69           N  
ATOM   1389  CA  PHE   201     -24.333  -6.163  43.858  1.00 41.84           C  
ATOM   1390  C   PHE   201     -24.857  -4.766  44.149  1.00 41.15           C  
ATOM   1391  O   PHE   201     -24.074  -3.818  44.199  1.00 41.58           O  
ATOM   1392  CB  PHE   201     -23.119  -6.041  42.935  1.00 42.85           C  
ATOM   1393  CG  PHE   201     -22.711  -7.325  42.327  1.00 43.28           C  
ATOM   1394  CD1 PHE   201     -22.106  -8.313  43.106  1.00 43.38           C  
ATOM   1395  CD2 PHE   201     -22.944  -7.568  40.980  1.00 43.18           C  
ATOM   1396  CE1 PHE   201     -21.736  -9.526  42.544  1.00 43.77           C  
ATOM   1397  CE2 PHE   201     -22.571  -8.775  40.405  1.00 43.77           C  
ATOM   1398  CZ  PHE   201     -21.972  -9.757  41.185  1.00 43.34           C  
ATOM   1399  N   MET   202     -26.167  -4.644  44.337  1.00 39.31           N  
ATOM   1400  CA  MET   202     -26.809  -3.367  44.555  1.00 38.45           C  
ATOM   1401  C   MET   202     -27.879  -3.471  45.655  1.00 38.54           C  
ATOM   1402  O   MET   202     -28.298  -4.575  46.011  1.00 39.36           O  
ATOM   1403  CB  MET   202     -27.421  -2.925  43.232  1.00 38.67           C  
ATOM   1404  CG  MET   202     -26.387  -2.622  42.128  1.00 37.28           C  
ATOM   1405  SD  MET   202     -25.423  -0.969  42.396  0.75 37.93          SE  
ATOM   1406  CE  MET   202     -26.624   0.243  41.755  1.00 39.90           C  
ATOM   1407  N   PRO   203     -28.287  -2.338  46.245  1.00 37.65           N  
ATOM   1408  CA  PRO   203     -29.354  -2.368  47.264  1.00 38.20           C  
ATOM   1409  C   PRO   203     -30.669  -2.907  46.713  1.00 38.81           C  
ATOM   1410  O   PRO   203     -30.902  -2.803  45.508  1.00 39.63           O  
ATOM   1411  CB  PRO   203     -29.523  -0.895  47.649  1.00 37.58           C  
ATOM   1412  CG  PRO   203     -28.263  -0.263  47.275  1.00 37.55           C  
ATOM   1413  CD  PRO   203     -27.751  -0.990  46.059  1.00 37.28           C  
ATOM   1414  N   LYS   204     -31.508  -3.468  47.587  1.00 39.31           N  
ATOM   1415  CA  LYS   204     -32.810  -4.047  47.207  1.00 39.35           C  
ATOM   1416  C   LYS   204     -33.734  -3.053  46.477  1.00 39.72           C  
ATOM   1417  O   LYS   204     -34.442  -3.452  45.558  1.00 40.18           O  
ATOM   1418  CB  LYS   204     -33.521  -4.681  48.426  1.00 39.78           C  
ATOM   1419  N   ALA   205     -33.708  -1.778  46.879  1.00 38.98           N  
ATOM   1420  CA  ALA   205     -34.517  -0.728  46.255  1.00 38.75           C  
ATOM   1421  C   ALA   205     -33.930  -0.470  44.874  1.00 38.44           C  
ATOM   1422  O   ALA   205     -32.742  -0.128  44.749  1.00 37.86           O  
ATOM   1423  CB  ALA   205     -34.488   0.555  47.087  1.00 38.54           C  
ATOM   1424  N   ASP   206     -34.768  -0.614  43.846  1.00 37.50           N  
ATOM   1425  CA  ASP   206     -34.311  -0.545  42.470  1.00 35.82           C  
ATOM   1426  C   ASP   206     -34.325   0.809  41.811  1.00 32.28           C  
ATOM   1427  O   ASP   206     -34.361   0.864  40.607  1.00 31.31           O  
ATOM   1428  CB  ASP   206     -35.078  -1.551  41.596  1.00 38.60           C  
ATOM   1429  CG  ASP   206     -36.537  -1.153  41.345  1.00 40.47           C  
ATOM   1430  OD1 ASP   206     -36.912   0.028  41.591  1.00 39.42           O  
ATOM   1431  OD2 ASP   206     -37.295  -2.043  40.861  1.00 42.49           O  
ATOM   1432  N   ASN   207     -34.223   1.891  42.572  1.00 31.67           N  
ATOM   1433  CA  ASN   207     -34.119   3.245  41.978  1.00 30.34           C  
ATOM   1434  C   ASN   207     -32.881   3.443  41.059  1.00 32.22           C  
ATOM   1435  O   ASN   207     -32.851   4.328  40.140  1.00 32.13           O  
ATOM   1436  CB  ASN   207     -34.022   4.313  43.076  1.00 29.95           C  
ATOM   1437  CG  ASN   207     -35.200   4.302  44.057  1.00 28.77           C  
ATOM   1438  OD1 ASN   207     -35.559   3.275  44.609  1.00 29.54           O  
ATOM   1439  ND2 ASN   207     -35.755   5.465  44.307  1.00 27.36           N  
ATOM   1440  N   TRP   208     -31.817   2.694  41.364  1.00 32.69           N  
ATOM   1441  CA  TRP   208     -30.556   2.768  40.603  1.00 31.91           C  
ATOM   1442  C   TRP   208     -30.776   2.359  39.170  1.00 32.17           C  
ATOM   1443  O   TRP   208     -30.167   2.961  38.311  1.00 31.13           O  
ATOM   1444  CB  TRP   208     -29.448   1.923  41.247  1.00 32.15           C  
ATOM   1445  CG  TRP   208     -29.846   0.532  41.554  1.00 32.23           C  
ATOM   1446  CD1 TRP   208     -30.470   0.092  42.688  1.00 32.29           C  
ATOM   1447  CD2 TRP   208     -29.671  -0.626  40.718  1.00 32.46           C  
ATOM   1448  NE1 TRP   208     -30.690  -1.258  42.612  1.00 32.16           N  
ATOM   1449  CE2 TRP   208     -30.200  -1.727  41.418  1.00 32.61           C  
ATOM   1450  CE3 TRP   208     -29.107  -0.836  39.450  1.00 32.63           C  
ATOM   1451  CZ2 TRP   208     -30.182  -3.037  40.884  1.00 32.23           C  
ATOM   1452  CZ3 TRP   208     -29.099  -2.105  38.924  1.00 31.68           C  
ATOM   1453  CH2 TRP   208     -29.614  -3.200  39.643  1.00 31.68           C  
ATOM   1454  N   LYS   209     -31.621   1.339  38.918  1.00 33.06           N  
ATOM   1455  CA  LYS   209     -32.004   0.923  37.544  1.00 33.39           C  
ATOM   1456  C   LYS   209     -32.502   2.114  36.713  1.00 34.33           C  
ATOM   1457  O   LYS   209     -32.221   2.198  35.520  1.00 37.07           O  
ATOM   1458  CB  LYS   209     -33.085  -0.168  37.508  1.00 34.04           C  
ATOM   1459  CG  LYS   209     -32.646  -1.527  38.040  1.00 35.43           C  
ATOM   1460  CD  LYS   209     -33.611  -2.691  37.657  1.00 35.19           C  
ATOM   1461  CE  LYS   209     -33.276  -3.967  38.447  1.00 36.00           C  
ATOM   1462  NZ  LYS   209     -33.853  -5.242  37.838  1.00 36.60           N  
ATOM   1463  N   ASN   210     -33.244   3.027  37.304  1.00 34.51           N  
ATOM   1464  CA  ASN   210     -33.677   4.231  36.551  1.00 36.49           C  
ATOM   1465  C   ASN   210     -32.501   5.192  36.240  1.00 35.37           C  
ATOM   1466  O   ASN   210     -32.445   5.812  35.160  1.00 36.42           O  
ATOM   1467  CB  ASN   210     -34.839   4.942  37.274  1.00 37.19           C  
ATOM   1468  CG  ASN   210     -36.022   3.995  37.529  1.00 38.90           C  
ATOM   1469  OD1 ASN   210     -36.385   3.209  36.654  1.00 40.42           O  
ATOM   1470  ND2 ASN   210     -36.583   4.026  38.745  1.00 38.09           N  
ATOM   1471  N   ILE   211     -31.552   5.321  37.164  1.00 34.75           N  
ATOM   1472  CA  ILE   211     -30.402   6.196  36.933  1.00 34.72           C  
ATOM   1473  C   ILE   211     -29.506   5.618  35.844  1.00 33.48           C  
ATOM   1474  O   ILE   211     -28.947   6.352  35.002  1.00 29.16           O  
ATOM   1475  CB  ILE   211     -29.609   6.469  38.249  1.00 36.00           C  
ATOM   1476  CG1 ILE   211     -30.486   7.263  39.223  1.00 35.99           C  
ATOM   1477  CG2 ILE   211     -28.321   7.298  37.985  1.00 34.49           C  
ATOM   1478  CD1 ILE   211     -29.809   7.654  40.520  1.00 35.96           C  
ATOM   1479  N   LEU   212     -29.411   4.290  35.858  1.00 32.77           N  
ATOM   1480  CA  LEU   212     -28.597   3.560  34.949  1.00 33.23           C  
ATOM   1481  C   LEU   212     -29.152   3.659  33.546  1.00 34.91           C  
ATOM   1482  O   LEU   212     -28.404   3.863  32.587  1.00 34.20           O  
ATOM   1483  CB  LEU   212     -28.563   2.076  35.381  1.00 33.12           C  
ATOM   1484  CG  LEU   212     -27.602   1.182  34.612  1.00 33.09           C  
ATOM   1485  CD1 LEU   212     -26.133   1.627  34.822  1.00 31.85           C  
ATOM   1486  CD2 LEU   212     -27.801  -0.229  35.052  1.00 32.08           C  
ATOM   1487  N   LEU   213     -30.463   3.460  33.419  1.00 36.65           N  
ATOM   1488  CA  LEU   213     -31.106   3.532  32.112  1.00 37.15           C  
ATOM   1489  C   LEU   213     -30.851   4.917  31.550  1.00 36.30           C  
ATOM   1490  O   LEU   213     -30.586   5.053  30.373  1.00 36.77           O  
ATOM   1491  CB  LEU   213     -32.620   3.252  32.192  1.00 37.58           C  
ATOM   1492  CG  LEU   213     -33.371   3.435  30.867  1.00 36.80           C  
ATOM   1493  CD1 LEU   213     -32.675   2.648  29.761  1.00 36.19           C  
ATOM   1494  CD2 LEU   213     -34.842   3.031  31.016  1.00 36.87           C  
ATOM   1495  N   GLY   214     -30.914   5.934  32.394  1.00 36.15           N  
ATOM   1496  CA  GLY   214     -30.612   7.314  31.963  1.00 36.31           C  
ATOM   1497  C   GLY   214     -29.201   7.391  31.377  1.00 36.76           C  
ATOM   1498  O   GLY   214     -29.002   7.906  30.282  1.00 34.16           O  
ATOM   1499  N   LYS   215     -28.225   6.833  32.095  1.00 38.08           N  
ATOM   1500  CA  LYS   215     -26.839   6.832  31.623  1.00 39.02           C  
ATOM   1501  C   LYS   215     -26.714   6.102  30.291  1.00 38.67           C  
ATOM   1502  O   LYS   215     -26.045   6.582  29.393  1.00 40.02           O  
ATOM   1503  CB  LYS   215     -25.895   6.169  32.645  1.00 38.95           C  
ATOM   1504  CG  LYS   215     -24.460   6.012  32.121  1.00 40.11           C  
ATOM   1505  CD  LYS   215     -23.490   5.230  33.046  1.00 41.64           C  
ATOM   1506  CE  LYS   215     -23.872   3.752  33.214  1.00 42.33           C  
ATOM   1507  NZ  LYS   215     -24.217   3.083  31.907  1.00 42.80           N  
ATOM   1508  N   TRP   216     -27.320   4.911  30.213  1.00 38.44           N  
ATOM   1509  CA  TRP   216     -27.328   4.055  29.010  1.00 37.73           C  
ATOM   1510  C   TRP   216     -27.931   4.760  27.802  1.00 36.69           C  
ATOM   1511  O   TRP   216     -27.353   4.712  26.709  1.00 37.44           O  
ATOM   1512  CB  TRP   216     -28.109   2.800  29.321  1.00 37.33           C  
ATOM   1513  CG  TRP   216     -28.319   1.837  28.235  1.00 37.88           C  
ATOM   1514  CD1 TRP   216     -29.384   1.799  27.373  1.00 37.86           C  
ATOM   1515  CD2 TRP   216     -27.541   0.663  27.956  1.00 37.86           C  
ATOM   1516  NE1 TRP   216     -29.269   0.727  26.545  1.00 37.80           N  
ATOM   1517  CE2 TRP   216     -28.155   0.008  26.880  1.00 37.05           C  
ATOM   1518  CE3 TRP   216     -26.355   0.134  28.475  1.00 37.81           C  
ATOM   1519  CZ2 TRP   216     -27.627  -1.142  26.312  1.00 37.75           C  
ATOM   1520  CZ3 TRP   216     -25.836  -1.013  27.910  1.00 37.54           C  
ATOM   1521  CH2 TRP   216     -26.476  -1.650  26.857  1.00 37.69           C  
ATOM   1522  N   SER   217     -29.079   5.405  28.011  1.00 34.69           N  
ATOM   1523  CA  SER   217     -29.758   6.195  26.964  1.00 34.80           C  
ATOM   1524  C   SER   217     -28.914   7.353  26.456  1.00 34.06           C  
ATOM   1525  O   SER   217     -28.999   7.724  25.289  1.00 34.05           O  
ATOM   1526  CB  SER   217     -31.099   6.759  27.465  1.00 34.33           C  
ATOM   1527  OG  SER   217     -32.049   5.728  27.666  1.00 34.19           O  
ATOM   1528  N   GLY   218     -28.151   7.959  27.359  1.00 34.17           N  
ATOM   1529  CA  GLY   218     -27.270   9.076  27.018  1.00 33.98           C  
ATOM   1530  C   GLY   218     -26.109   8.619  26.147  1.00 33.23           C  
ATOM   1531  O   GLY   218     -25.666   9.331  25.281  1.00 32.30           O  
ATOM   1532  N   TRP   219     -25.619   7.404  26.391  1.00 33.89           N  
ATOM   1533  CA  TRP   219     -24.562   6.807  25.584  1.00 32.51           C  
ATOM   1534  C   TRP   219     -25.056   6.479  24.156  1.00 31.46           C  
ATOM   1535  O   TRP   219     -24.291   6.485  23.200  1.00 29.93           O  
ATOM   1536  CB  TRP   219     -24.075   5.544  26.315  1.00 34.90           C  
ATOM   1537  CG  TRP   219     -23.044   5.761  27.391  1.00 35.00           C  
ATOM   1538  CD1 TRP   219     -22.690   6.928  27.981  1.00 36.21           C  
ATOM   1539  CD2 TRP   219     -22.297   4.739  28.054  1.00 36.69           C  
ATOM   1540  NE1 TRP   219     -21.727   6.712  28.932  1.00 36.02           N  
ATOM   1541  CE2 TRP   219     -21.464   5.373  29.002  1.00 36.36           C  
ATOM   1542  CE3 TRP   219     -22.238   3.354  27.922  1.00 35.77           C  
ATOM   1543  CZ2 TRP   219     -20.568   4.665  29.819  1.00 36.18           C  
ATOM   1544  CZ3 TRP   219     -21.332   2.630  28.736  1.00 36.36           C  
ATOM   1545  CH2 TRP   219     -20.526   3.286  29.680  1.00 36.68           C  
ATOM   1546  N   ILE   220     -26.332   6.140  24.019  1.00 31.33           N  
ATOM   1547  CA  ILE   220     -26.941   5.905  22.713  1.00 31.05           C  
ATOM   1548  C   ILE   220     -27.082   7.237  21.940  1.00 33.15           C  
ATOM   1549  O   ILE   220     -26.722   7.330  20.755  1.00 32.49           O  
ATOM   1550  CB  ILE   220     -28.304   5.253  22.875  1.00 29.75           C  
ATOM   1551  CG1 ILE   220     -28.157   3.828  23.465  1.00 29.30           C  
ATOM   1552  CG2 ILE   220     -29.014   5.142  21.512  1.00 30.31           C  
ATOM   1553  CD1 ILE   220     -29.494   3.274  23.922  1.00 28.25           C  
ATOM   1554  N   GLU   221     -27.604   8.262  22.608  1.00 35.10           N  
ATOM   1555  CA  GLU   221     -27.741   9.611  21.989  1.00 35.33           C  
ATOM   1556  C   GLU   221     -26.379  10.186  21.502  1.00 36.09           C  
ATOM   1557  O   GLU   221     -26.283  10.752  20.409  1.00 37.21           O  
ATOM   1558  CB  GLU   221     -28.410  10.577  22.987  1.00 36.75           C  
ATOM   1559  CG  GLU   221     -28.923  11.952  22.398  1.00 38.27           C  
ATOM   1560  CD  GLU   221     -27.892  13.097  22.374  1.00 41.37           C  
ATOM   1561  OE1 GLU   221     -26.798  12.930  22.990  1.00 42.19           O  
ATOM   1562  OE2 GLU   221     -28.193  14.192  21.752  1.00 42.76           O  
ATOM   1563  N   GLN   222     -25.344  10.047  22.328  1.00 36.89           N  
ATOM   1564  CA  GLN   222     -23.983  10.545  22.027  1.00 36.28           C  
ATOM   1565  C   GLN   222     -23.212   9.642  21.077  1.00 34.50           C  
ATOM   1566  O   GLN   222     -22.091   9.950  20.718  1.00 31.88           O  
ATOM   1567  CB  GLN   222     -23.159  10.657  23.322  1.00 37.58           C  
ATOM   1568  CG  GLN   222     -23.716  11.611  24.368  1.00 39.28           C  
ATOM   1569  CD  GLN   222     -23.446  13.088  24.074  1.00 41.32           C  
ATOM   1570  OE1 GLN   222     -22.294  13.500  23.894  1.00 43.78           O  
ATOM   1571  NE2 GLN   222     -24.511  13.897  24.041  1.00 40.72           N  
ATOM   1572  N   ARG   223     -23.787   8.494  20.735  1.00 34.13           N  
ATOM   1573  CA  ARG   223     -23.179   7.523  19.831  1.00 33.61           C  
ATOM   1574  C   ARG   223     -21.917   6.873  20.400  1.00 34.35           C  
ATOM   1575  O   ARG   223     -20.949   6.632  19.654  1.00 35.88           O  
ATOM   1576  CB  ARG   223     -22.898   8.168  18.485  1.00 34.96           C  
ATOM   1577  CG  ARG   223     -22.824   7.244  17.284  1.00 35.66           C  
ATOM   1578  CD  ARG   223     -22.314   8.071  16.136  1.00 36.64           C  
ATOM   1579  NE  ARG   223     -22.460   7.421  14.851  1.00 36.77           N  
ATOM   1580  CZ  ARG   223     -22.173   8.005  13.695  1.00 37.14           C  
ATOM   1581  NH1 ARG   223     -21.712   9.244  13.648  1.00 37.54           N  
ATOM   1582  NH2 ARG   223     -22.356   7.338  12.565  1.00 38.08           N  
ATOM   1583  N   ILE   224     -21.926   6.592  21.712  1.00 32.16           N  
ATOM   1584  CA  ILE   224     -20.824   5.884  22.403  1.00 30.24           C  
ATOM   1585  C   ILE   224     -21.037   4.388  22.261  1.00 29.99           C  
ATOM   1586  O   ILE   224     -20.081   3.600  22.134  1.00 26.56           O  
ATOM   1587  CB  ILE   224     -20.757   6.269  23.908  1.00 29.79           C  
ATOM   1588  CG1 ILE   224     -20.396   7.761  24.076  1.00 29.73           C  
ATOM   1589  CG2 ILE   224     -19.763   5.447  24.614  1.00 30.17           C  
ATOM   1590  CD1 ILE   224     -20.563   8.314  25.494  1.00 29.42           C  
ATOM   1591  N   ILE   225     -22.312   3.986  22.300  1.00 30.18           N  
ATOM   1592  CA  ILE   225     -22.678   2.590  22.089  1.00 28.73           C  
ATOM   1593  C   ILE   225     -23.656   2.595  20.934  1.00 30.68           C  
ATOM   1594  O   ILE   225     -24.386   3.580  20.726  1.00 30.26           O  
ATOM   1595  CB  ILE   225     -23.200   1.918  23.379  1.00 28.42           C  
ATOM   1596  CG1 ILE   225     -24.620   2.348  23.737  1.00 26.99           C  
ATOM   1597  CG2 ILE   225     -22.217   2.217  24.514  1.00 29.60           C  
ATOM   1598  CD1 ILE   225     -25.110   1.976  25.113  1.00 26.01           C  
ATOM   1599  N   ILE   226     -23.642   1.506  20.155  1.00 30.62           N  
ATOM   1600  CA  ILE   226     -24.499   1.394  18.976  1.00 30.56           C  
ATOM   1601  C   ILE   226     -25.110   0.009  18.972  1.00 29.99           C  
ATOM   1602  O   ILE   226     -24.574  -0.883  19.606  1.00 28.78           O  
ATOM   1603  CB  ILE   226     -23.740   1.708  17.596  1.00 30.62           C  
ATOM   1604  CG1 ILE   226     -22.567   0.765  17.340  1.00 30.74           C  
ATOM   1605  CG2 ILE   226     -23.274   3.214  17.504  1.00 30.74           C  
ATOM   1606  CD1 ILE   226     -21.914   0.946  15.918  1.00 30.80           C  
ATOM   1607  N   PRO   227     -26.270  -0.161  18.317  1.00 30.20           N  
ATOM   1608  CA  PRO   227     -26.836  -1.526  18.246  1.00 30.62           C  
ATOM   1609  C   PRO   227     -25.852  -2.518  17.629  1.00 33.79           C  
ATOM   1610  O   PRO   227     -25.105  -2.175  16.706  1.00 32.59           O  
ATOM   1611  CB  PRO   227     -28.079  -1.360  17.373  1.00 29.34           C  
ATOM   1612  CG  PRO   227     -28.421   0.098  17.460  1.00 29.26           C  
ATOM   1613  CD  PRO   227     -27.145   0.845  17.691  1.00 29.25           C  
ATOM   1614  N   SER   228     -25.827  -3.722  18.183  1.00 37.62           N  
ATOM   1615  CA  SER   228     -24.979  -4.781  17.679  1.00 40.86           C  
ATOM   1616  C   SER   228     -25.762  -5.611  16.664  1.00 43.11           C  
ATOM   1617  O   SER   228     -26.490  -6.533  17.032  1.00 44.20           O  
ATOM   1618  CB  SER   228     -24.474  -5.666  18.812  1.00 40.76           C  
ATOM   1619  OG  SER   228     -23.551  -6.594  18.271  1.00 41.97           O  
ATOM   1620  N   LEU   229     -25.572  -5.292  15.386  1.00 45.83           N  
ATOM   1621  CA  LEU   229     -26.333  -5.890  14.290  1.00 47.76           C  
ATOM   1622  C   LEU   229     -25.604  -7.011  13.560  1.00 49.40           C  
ATOM   1623  O   LEU   229     -24.593  -6.779  12.910  1.00 49.60           O  
ATOM   1624  CB  LEU   229     -26.711  -4.786  13.289  1.00 47.66           C  
ATOM   1625  CG  LEU   229     -27.607  -3.690  13.883  1.00 47.20           C  
ATOM   1626  CD1 LEU   229     -27.754  -2.509  12.947  1.00 46.75           C  
ATOM   1627  CD2 LEU   229     -28.965  -4.279  14.249  1.00 47.53           C  
ATOM   1628  N   SER   230     -26.155  -8.220  13.659  1.00 51.73           N  
ATOM   1629  CA  SER   230     -25.586  -9.409  13.031  1.00 52.88           C  
ATOM   1630  C   SER   230     -26.236  -9.706  11.680  1.00 53.74           C  
ATOM   1631  O   SER   230     -25.565  -9.657  10.646  1.00 54.94           O  
ATOM   1632  CB  SER   230     -25.730 -10.610  13.970  1.00 52.98           C  
ATOM   1633  OG  SER   230     -25.042 -10.362  15.191  1.00 53.17           O  
END
