
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  219 ( 1630),  selected  219 , name 1k6d_B
# Molecule2: number of CA atoms  165 ( 1302),  selected  165 , name T0438_2_186.pdb
# PARAMETERS: 1k6d_B.T0438_2_186.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_B      Q       2           -
LGA    -       -      W       3           -
LGA    -       -      Q       4           -
LGA    K     2_B      E       5           #
LGA    T     3_B      L       6          3.666
LGA    -       -      Y       7           -
LGA    -       -      R       8           -
LGA    K     4_B      Q       9          4.390
LGA    L     5_B      R      10          2.707
LGA    M     6_B      V      11          1.593
LGA    T     7_B      C      12          2.047
LGA    L     8_B      S      13          1.276
LGA    -       -      A      14           -
LGA    Q     9_B      D      15          3.852
LGA    D    10_B      E      16          2.380
LGA    A    11_B      A      17          1.148
LGA    T    12_B      V      18          3.248
LGA    G    13_B      V      19          2.645
LGA    F    14_B      D      20          2.105
LGA    -       -      S      21           -
LGA    F    15_B      L      22          2.403
LGA    R    16_B      K      23          3.046
LGA    D    17_B      P      24          3.181
LGA    G    18_B      G      25          2.533
LGA    M    19_B      T      26          1.436
LGA    T    20_B      K      27          0.408
LGA    I    21_B      V      28          0.535
LGA    M    22_B      V      29          0.879
LGA    V    23_B      F      30          0.589
LGA    G    24_B      G      31          0.692
LGA    G    25_B      X      32          1.274
LGA    F    26_B      A      33          1.778
LGA    M    27_B      -       -           -
LGA    G    28_B      -       -           -
LGA    I    29_B      A      34          1.229
LGA    G    30_B      A      35          0.676
LGA    T    31_B      A      36          0.887
LGA    P    32_B      P      37          1.652
LGA    S    33_B      V      38          1.875
LGA    R    34_B      R      39          1.100
LGA    L    35_B      F      40          1.597
LGA    V    36_B      S      41          1.734
LGA    E    37_B      Q      42          1.160
LGA    A    38_B      A      43          1.062
LGA    L    39_B      M      44          1.679
LGA    L    40_B      Y      45          1.807
LGA    E    41_B      R      46          1.343
LGA    S    42_B      Q      47          1.049
LGA    G    43_B      R      48          0.368
LGA    -       -      E      49           -
LGA    -       -      K      50           -
LGA    V    44_B      L      51          1.874
LGA    R    45_B      E      52           #
LGA    D    46_B      N      53          2.894
LGA    L    47_B      I      54          1.709
LGA    T    48_B      T      55          1.015
LGA    L    49_B      V      56          0.851
LGA    I    50_B      F      57          1.435
LGA    A    51_B      X      58          1.346
LGA    N    52_B      M      59          2.557
LGA    D    53_B      L      60          4.028
LGA    T    54_B      Y      61          5.843
LGA    A    55_B      F      62          5.704
LGA    F    56_B      -       -           -
LGA    V    57_B      -       -           -
LGA    D    58_B      G      63          5.462
LGA    T    59_B      D      64          2.836
LGA    G    60_B      -       -           -
LGA    I    61_B      -       -           -
LGA    G    62_B      A      65          4.445
LGA    P    63_B      P      66          2.205
LGA    L    64_B      X      67          0.702
LGA    I    65_B      L      68          1.719
LGA    V    66_B      A      69          2.327
LGA    N    67_B      P      70          2.965
LGA    -       -      E      71           -
LGA    -       -      M      72           -
LGA    G    68_B      R      73          2.217
LGA    -       -      S      74           -
LGA    R    69_B      X      75          3.338
LGA    V    70_B      V      76          2.639
LGA    R    71_B      X      77          3.314
LGA    K    72_B      P      78          4.368
LGA    V    73_B      T      79          0.949
LGA    I    74_B      L      80          2.186
LGA    A    75_B      -       -           -
LGA    S    76_B      -       -           -
LGA    H    77_B      -       -           -
LGA    I    78_B      -       -           -
LGA    G    79_B      -       -           -
LGA    T    80_B      -       -           -
LGA    N    81_B      -       -           -
LGA    P    82_B      -       -           -
LGA    E    83_B      -       -           -
LGA    T    84_B      -       -           -
LGA    G    85_B      -       -           -
LGA    R    86_B      -       -           -
LGA    R    87_B      -       -           -
LGA    M    88_B      -       -           -
LGA    I    89_B      -       -           -
LGA    S    90_B      -       -           -
LGA    G    91_B      -       -           -
LGA    E    92_B      -       -           -
LGA    M    93_B      -       -           -
LGA    D    94_B      -       -           -
LGA    V    95_B      -       -           -
LGA    V    96_B      -       -           -
LGA    L    97_B      -       -           -
LGA    V    98_B      -       -           -
LGA    P    99_B      C     101          2.697
LGA    Q   100_B      X     102          5.158
LGA    G   101_B      F     103          2.486
LGA    -       -      X     104           -
LGA    T   102_B      E     105          2.465
LGA    L   103_B      V     106          1.885
LGA    I   104_B      P     107          2.160
LGA    E   105_B      E     108          2.113
LGA    Q   106_B      L     109          1.731
LGA    I   107_B      F     110          2.078
LGA    R   108_B      R     111          3.492
LGA    C   109_B      Q     112          3.790
LGA    G   110_B      -       -           -
LGA    G   111_B      -       -           -
LGA    A   112_B      -       -           -
LGA    G   113_B      -       -           -
LGA    L   114_B      -       -           -
LGA    G   115_B      -       -           -
LGA    G   116_B      -       -           -
LGA    F   117_B      -       -           -
LGA    L   118_B      -       -           -
LGA    T   119_B      -       -           -
LGA    P   120_B      -       -           -
LGA    T   121_B      -       -           -
LGA    G   122_B      -       -           -
LGA    V   123_B      -       -           -
LGA    G   124_B      -       -           -
LGA    T   125_B      -       -           -
LGA    V   126_B      -       -           -
LGA    V   127_B      -       -           -
LGA    E   128_B      -       -           -
LGA    E   129_B      -       -           -
LGA    G   130_B      -       -           -
LGA    K   131_B      -       -           -
LGA    Q   132_B      -       -           -
LGA    T   133_B      -       -           -
LGA    L   134_B      -       -           -
LGA    T   135_B      -       -           -
LGA    L   136_B      -       -           -
LGA    D   137_B      -       -           -
LGA    G   138_B      -       -           -
LGA    K   139_B      -       -           -
LGA    T   140_B      -       -           -
LGA    W   141_B      -       -           -
LGA    L   142_B      -       -           -
LGA    L   143_B      -       -           -
LGA    E   144_B      -       -           -
LGA    R   145_B      G     113          5.070
LGA    P   146_B      F     114          3.906
LGA    L   147_B      F     115          2.939
LGA    R   148_B      P     116          2.961
LGA    A   149_B      L     117          1.419
LGA    D   150_B      D     118          1.713
LGA    L   151_B      V     119          1.087
LGA    A   152_B      A     120          1.202
LGA    L   153_B      V     121          0.811
LGA    I   154_B      V     122          0.919
LGA    R   155_B      Q     123          0.416
LGA    A   156_B      V     124          0.616
LGA    H   157_B      S     125          1.957
LGA    R   158_B      T     126          2.661
LGA    C   159_B      P     127          2.560
LGA    -       -      N     128           -
LGA    -       -      E     129           -
LGA    D   160_B      E     130           #
LGA    T   161_B      G     131          5.146
LGA    L   162_B      -       -           -
LGA    G   163_B      -       -           -
LGA    N   164_B      Y     132          2.713
LGA    L   165_B      C     133          1.861
LGA    T   166_B      S     134          1.048
LGA    Y   167_B      F     135          2.826
LGA    Q   168_B      G     136          2.387
LGA    L   169_B      V     137          3.281
LGA    S   170_B      -       -           -
LGA    A   171_B      S     138          3.733
LGA    R   172_B      C     139          3.747
LGA    N   173_B      D     140          3.481
LGA    F   174_B      Y     141          3.133
LGA    N   175_B      T     142          2.798
LGA    P   176_B      K     143          1.547
LGA    L   177_B      A     144          1.912
LGA    I   178_B      A     145          1.416
LGA    A   179_B      A     146          0.681
LGA    L   180_B      E     147          0.813
LGA    A   181_B      C     148          1.449
LGA    A   182_B      A     149          1.050
LGA    D   183_B      P     150          1.723
LGA    I   184_B      V     151          0.589
LGA    T   185_B      V     152          0.611
LGA    L   186_B      V     153          0.969
LGA    V   187_B      A     154          0.733
LGA    E   188_B      E     155          0.563
LGA    P   189_B      V     156          1.448
LGA    D   190_B      N     157          1.478
LGA    E   191_B      K     158          2.988
LGA    L   192_B      Q     159           -
LGA    V   193_B      M     160           -
LGA    E   194_B      P     161           -
LGA    T   195_B      -       -           -
LGA    G   196_B      -       -           -
LGA    E   197_B      -       -           -
LGA    L   198_B      F     162           #
LGA    Q   199_B      I     163           -
LGA    P   200_B      -       -           -
LGA    D   201_B      G     164           #
LGA    H   202_B      G     165           #
LGA    I   203_B      E     166           #
LGA    V   204_B      N     167          3.163
LGA    T   205_B      L     168          3.501
LGA    -       -      I     169           -
LGA    P   206_B      X     170          3.332
LGA    G   207_B      I     171          3.647
LGA    A   208_B      S     172          4.252
LGA    V   209_B      K     173          2.725
LGA    I   210_B      L     174          2.029
LGA    D   211_B      T     175          1.729
LGA    H   212_B      X     176          2.103
LGA    I   213_B      I     177          1.556
LGA    I   214_B      I     178          1.661
LGA    V   215_B      E     179          2.998
LGA    S   216_B      -       -           -
LGA    Q   217_B      V     180          2.773
LGA    E   218_B      D     181          2.383
LGA    S   219_B      E     182          4.862
LGA    -       -      P     183           -
LGA    -       -      I     184           -
LGA    -       -      A     185           -
LGA    -       -      E     186           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  219  165    5.0    134    2.55    13.43     50.636     5.050

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.782167 * X  +   0.102529 * Y  +  -0.614575 * Z  +  10.606730
  Y_new =   0.213849 * X  +  -0.970627 * Y  +   0.110236 * Z  +  24.405607
  Z_new =  -0.585221 * X  +  -0.217649 * Y  +  -0.781118 * Z  +  36.843395 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.869847    0.271746  [ DEG:  -164.4301     15.5699 ]
  Theta =   0.625152    2.516440  [ DEG:    35.8186    144.1814 ]
  Phi   =   0.266884   -2.874709  [ DEG:    15.2913   -164.7087 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1k6d_B                                        
REMARK     2: T0438_2_186.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1k6d_B.T0438_2_186.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  219  165   5.0  134   2.55   13.43  50.636
REMARK  ---------------------------------------------------------- 
MOLECULE 1k6d_B
HEADER    TRANSFERASE                             15-OCT-01   1K6D              
TITLE     CRYSTAL STRUCTURE OF ACETATE COA-TRANSFERASE ALPHA SUBUNIT            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ACETATE COA-TRANSFERASE ALPHA SUBUNIT;                     
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: ACETYL-COA:ACETOACETATE-COA TRANSFERASE ALPHA               
COMPND   5 SUBUNIT;                                                             
COMPND   6 EC: 2.8.3.8;                                                         
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: MCSG3                                     
KEYWDS    STRUCTURAL GENOMICS, PSI, PROTEIN STRUCTURE INITIATIVE,               
KEYWDS   2 MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.KOROLEV,O.KOROLEVA,K.PETTERSON,F.COLLART,I.DEMENTIEVA,              
AUTHOR   2 A.JOACHIMIAK,MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)           
REVDAT   3   18-JAN-05 1K6D    1       JRNL   AUTHOR KEYWDS REMARK              
REVDAT   2   04-DEC-02 1K6D    1       JRNL                                     
REVDAT   1   26-JUN-02 1K6D    0                                                
JRNL        AUTH   S.KOROLEV,O.KOROLEVA,K.PETTERSON,M.GU,F.COLLART,             
JRNL        AUTH 2 I.DEMENTIEVA,A.JOACHIMIAK                                    
JRNL        TITL   AUTOTRACING OF ESCHERICHIA COLI ACETATE                      
JRNL        TITL 2 COA-TRANSFERASE ALPHA-SUBUNIT STRUCTURE USING 3.4            
JRNL        TITL 3 A MAD AND 1.9 A NATIVE DATA.                                 
JRNL        REF    ACTA CRYSTALLOGR.,SECT.D      V.  58  2116 2002              
JRNL        REFN   ASTM ABCRE6  DK ISSN 0907-4449                               
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  1K6D A    1   220  UNP    P76458   ATOD_ECOLI       1    220             
DBREF  1K6D B    1   220  UNP    P76458   ATOD_ECOLI       1    220             
SEQRES   1 A  220  MET LYS THR LYS LEU MET THR LEU GLN ASP ALA THR GLY          
SEQRES   2 A  220  PHE PHE ARG ASP GLY MET THR ILE MET VAL GLY GLY PHE          
SEQRES   3 A  220  MET GLY ILE GLY THR PRO SER ARG LEU VAL GLU ALA LEU          
SEQRES   4 A  220  LEU GLU SER GLY VAL ARG ASP LEU THR LEU ILE ALA ASN          
SEQRES   5 A  220  ASP THR ALA PHE VAL ASP THR GLY ILE GLY PRO LEU ILE          
SEQRES   6 A  220  VAL ASN GLY ARG VAL ARG LYS VAL ILE ALA SER HIS ILE          
SEQRES   7 A  220  GLY THR ASN PRO GLU THR GLY ARG ARG MET ILE SER GLY          
SEQRES   8 A  220  GLU MET ASP VAL VAL LEU VAL PRO GLN GLY THR LEU ILE          
SEQRES   9 A  220  GLU GLN ILE ARG CYS GLY GLY ALA GLY LEU GLY GLY PHE          
SEQRES  10 A  220  LEU THR PRO THR GLY VAL GLY THR VAL VAL GLU GLU GLY          
SEQRES  11 A  220  LYS GLN THR LEU THR LEU ASP GLY LYS THR TRP LEU LEU          
SEQRES  12 A  220  GLU ARG PRO LEU ARG ALA ASP LEU ALA LEU ILE ARG ALA          
SEQRES  13 A  220  HIS ARG CYS ASP THR LEU GLY ASN LEU THR TYR GLN LEU          
SEQRES  14 A  220  SER ALA ARG ASN PHE ASN PRO LEU ILE ALA LEU ALA ALA          
SEQRES  15 A  220  ASP ILE THR LEU VAL GLU PRO ASP GLU LEU VAL GLU THR          
SEQRES  16 A  220  GLY GLU LEU GLN PRO ASP HIS ILE VAL THR PRO GLY ALA          
SEQRES  17 A  220  VAL ILE ASP HIS ILE ILE VAL SER GLN GLU SER LYS              
SEQRES   1 B  220  MET LYS THR LYS LEU MET THR LEU GLN ASP ALA THR GLY          
SEQRES   2 B  220  PHE PHE ARG ASP GLY MET THR ILE MET VAL GLY GLY PHE          
SEQRES   3 B  220  MET GLY ILE GLY THR PRO SER ARG LEU VAL GLU ALA LEU          
SEQRES   4 B  220  LEU GLU SER GLY VAL ARG ASP LEU THR LEU ILE ALA ASN          
SEQRES   5 B  220  ASP THR ALA PHE VAL ASP THR GLY ILE GLY PRO LEU ILE          
SEQRES   6 B  220  VAL ASN GLY ARG VAL ARG LYS VAL ILE ALA SER HIS ILE          
SEQRES   7 B  220  GLY THR ASN PRO GLU THR GLY ARG ARG MET ILE SER GLY          
SEQRES   8 B  220  GLU MET ASP VAL VAL LEU VAL PRO GLN GLY THR LEU ILE          
SEQRES   9 B  220  GLU GLN ILE ARG CYS GLY GLY ALA GLY LEU GLY GLY PHE          
SEQRES  10 B  220  LEU THR PRO THR GLY VAL GLY THR VAL VAL GLU GLU GLY          
SEQRES  11 B  220  LYS GLN THR LEU THR LEU ASP GLY LYS THR TRP LEU LEU          
SEQRES  12 B  220  GLU ARG PRO LEU ARG ALA ASP LEU ALA LEU ILE ARG ALA          
SEQRES  13 B  220  HIS ARG CYS ASP THR LEU GLY ASN LEU THR TYR GLN LEU          
SEQRES  14 B  220  SER ALA ARG ASN PHE ASN PRO LEU ILE ALA LEU ALA ALA          
SEQRES  15 B  220  ASP ILE THR LEU VAL GLU PRO ASP GLU LEU VAL GLU THR          
SEQRES  16 B  220  GLY GLU LEU GLN PRO ASP HIS ILE VAL THR PRO GLY ALA          
SEQRES  17 B  220  VAL ILE ASP HIS ILE ILE VAL SER GLN GLU SER LYS              
HET     MG    301       1                                                       
HET     MG    302       1                                                       
HET     MG    303       1                                                       
HET     MG    304       1                                                       
HETNAM      MG MAGNESIUM ION                                                    
FORMUL   3   MG    4(MG 2+)                                                     
FORMUL   7  HOH   *228(H2 O)                                                    
CRYST1   88.496   88.496  105.080  90.00  90.00 120.00 P 62         12          
ATOM   1610  N   MET B   1      22.804  40.712   5.066  1.00 74.51           N  
ATOM   1611  CA  MET B   1      23.582  39.623   5.728  1.00 74.36           C  
ATOM   1612  C   MET B   1      23.647  39.866   7.229  1.00 73.43           C  
ATOM   1613  O   MET B   1      24.429  39.233   7.941  1.00 75.29           O  
ATOM   1614  CB  MET B   1      24.994  39.556   5.149  1.00 73.58           C  
ATOM   1615  N   LYS B   2      22.827  40.796   7.704  1.00 70.85           N  
ATOM   1616  CA  LYS B   2      22.784  41.113   9.121  1.00 67.35           C  
ATOM   1617  C   LYS B   2      21.554  40.435   9.714  1.00 64.32           C  
ATOM   1618  O   LYS B   2      21.088  40.807  10.798  1.00 66.14           O  
ATOM   1619  CB  LYS B   2      22.709  42.629   9.317  1.00 67.58           C  
ATOM   1620  N   THR B   3      21.031  39.434   9.005  1.00 56.85           N  
ATOM   1621  CA  THR B   3      19.842  38.741   9.478  1.00 49.21           C  
ATOM   1622  C   THR B   3      19.585  37.349   8.886  1.00 45.11           C  
ATOM   1623  O   THR B   3      19.750  37.109   7.682  1.00 40.63           O  
ATOM   1624  CB  THR B   3      18.584  39.597   9.234  1.00 48.33           C  
ATOM   1625  OG1 THR B   3      17.505  39.082  10.012  1.00 46.67           O  
ATOM   1626  CG2 THR B   3      18.186  39.566   7.764  1.00 47.84           C  
ATOM   1627  N   LYS B   4      19.157  36.442   9.758  1.00 39.11           N  
ATOM   1628  CA  LYS B   4      18.839  35.075   9.370  1.00 35.27           C  
ATOM   1629  C   LYS B   4      17.335  34.970   9.193  1.00 33.28           C  
ATOM   1630  O   LYS B   4      16.826  33.960   8.715  1.00 31.19           O  
ATOM   1631  CB  LYS B   4      19.284  34.097  10.461  1.00 34.52           C  
ATOM   1632  CG  LYS B   4      20.777  34.109  10.734  1.00 34.82           C  
ATOM   1633  CD  LYS B   4      21.158  33.044  11.752  1.00 32.94           C  
ATOM   1634  CE  LYS B   4      22.672  32.946  11.914  1.00 32.66           C  
ATOM   1635  NZ  LYS B   4      23.059  31.878  12.874  1.00 30.26           N  
ATOM   1636  N   LEU B   5      16.619  36.020   9.581  1.00 29.90           N  
ATOM   1637  CA  LEU B   5      15.169  36.013   9.476  1.00 32.08           C  
ATOM   1638  C   LEU B   5      14.673  36.076   8.036  1.00 31.57           C  
ATOM   1639  O   LEU B   5      15.142  36.899   7.255  1.00 32.68           O  
ATOM   1640  CB  LEU B   5      14.571  37.192  10.271  1.00 34.97           C  
ATOM   1641  CG  LEU B   5      14.827  37.335  11.785  1.00 37.46           C  
ATOM   1642  CD1 LEU B   5      14.673  35.990  12.476  1.00 34.95           C  
ATOM   1643  CD2 LEU B   5      16.211  37.866  12.041  1.00 44.11           C  
ATOM   1644  N   MET B   6      13.728  35.211   7.675  1.00 28.53           N  
ATOM   1645  CA  MET B   6      13.175  35.251   6.322  1.00 29.51           C  
ATOM   1646  C   MET B   6      11.786  34.651   6.280  1.00 27.58           C  
ATOM   1647  O   MET B   6      11.318  34.068   7.255  1.00 27.63           O  
ATOM   1648  CB  MET B   6      14.068  34.507   5.326  1.00 32.12           C  
ATOM   1649  CG  MET B   6      13.992  32.988   5.430  1.00 37.96           C  
ATOM   1650  SD  MET B   6      14.800  32.194   4.015  1.00 41.73           S  
ATOM   1651  CE  MET B   6      16.207  33.220   3.852  1.00 41.47           C  
ATOM   1652  N   THR B   7      11.124  34.789   5.141  1.00 25.31           N  
ATOM   1653  CA  THR B   7       9.783  34.256   4.983  1.00 25.83           C  
ATOM   1654  C   THR B   7       9.855  33.028   4.081  1.00 27.52           C  
ATOM   1655  O   THR B   7      10.887  32.770   3.460  1.00 29.26           O  
ATOM   1656  CB  THR B   7       8.843  35.291   4.322  1.00 27.45           C  
ATOM   1657  OG1 THR B   7       9.145  35.373   2.927  1.00 26.50           O  
ATOM   1658  CG2 THR B   7       9.039  36.668   4.948  1.00 28.88           C  
ATOM   1659  N   LEU B   8       8.763  32.273   4.018  1.00 27.92           N  
ATOM   1660  CA  LEU B   8       8.717  31.092   3.176  1.00 29.97           C  
ATOM   1661  C   LEU B   8       8.901  31.494   1.726  1.00 34.81           C  
ATOM   1662  O   LEU B   8       9.470  30.742   0.932  1.00 33.51           O  
ATOM   1663  CB  LEU B   8       7.385  30.378   3.321  1.00 33.04           C  
ATOM   1664  CG  LEU B   8       7.292  29.228   4.310  1.00 37.17           C  
ATOM   1665  CD1 LEU B   8       5.856  28.688   4.281  1.00 38.52           C  
ATOM   1666  CD2 LEU B   8       8.295  28.127   3.930  1.00 33.07           C  
ATOM   1667  N   GLN B   9       8.408  32.680   1.374  1.00 34.56           N  
ATOM   1668  CA  GLN B   9       8.547  33.152   0.007  1.00 36.00           C  
ATOM   1669  C   GLN B   9      10.021  33.316  -0.328  1.00 35.72           C  
ATOM   1670  O   GLN B   9      10.434  33.064  -1.460  1.00 37.76           O  
ATOM   1671  CB  GLN B   9       7.809  34.478  -0.203  1.00 39.06           C  
ATOM   1672  CG  GLN B   9       7.885  34.968  -1.647  1.00 45.90           C  
ATOM   1673  CD  GLN B   9       7.289  33.976  -2.646  1.00 48.21           C  
ATOM   1674  OE1 GLN B   9       7.715  33.911  -3.800  1.00 51.02           O  
ATOM   1675  NE2 GLN B   9       6.297  33.211  -2.209  1.00 49.44           N  
ATOM   1676  N   ASP B  10      10.819  33.727   0.651  1.00 34.08           N  
ATOM   1677  CA  ASP B  10      12.249  33.881   0.429  1.00 34.82           C  
ATOM   1678  C   ASP B  10      12.924  32.526   0.211  1.00 36.91           C  
ATOM   1679  O   ASP B  10      13.950  32.438  -0.463  1.00 33.01           O  
ATOM   1680  CB  ASP B  10      12.923  34.551   1.622  1.00 34.49           C  
ATOM   1681  CG  ASP B  10      12.392  35.945   1.883  1.00 40.17           C  
ATOM   1682  OD1 ASP B  10      12.103  36.647   0.893  1.00 38.00           O  
ATOM   1683  OD2 ASP B  10      12.279  36.337   3.068  1.00 34.21           O  
ATOM   1684  N   ALA B  11      12.356  31.474   0.792  1.00 37.77           N  
ATOM   1685  CA  ALA B  11      12.936  30.139   0.659  1.00 39.65           C  
ATOM   1686  C   ALA B  11      13.065  29.703  -0.800  1.00 41.38           C  
ATOM   1687  O   ALA B  11      14.031  29.040  -1.176  1.00 39.23           O  
ATOM   1688  CB  ALA B  11      12.104  29.129   1.440  1.00 39.56           C  
ATOM   1689  N   THR B  12      12.097  30.090  -1.622  1.00 41.54           N  
ATOM   1690  CA  THR B  12      12.106  29.728  -3.035  1.00 42.36           C  
ATOM   1691  C   THR B  12      13.412  30.070  -3.737  1.00 40.62           C  
ATOM   1692  O   THR B  12      13.843  29.356  -4.636  1.00 43.03           O  
ATOM   1693  CB  THR B  12      10.971  30.428  -3.781  1.00 44.77           C  
ATOM   1694  OG1 THR B  12       9.734  30.164  -3.108  1.00 46.79           O  
ATOM   1695  CG2 THR B  12      10.890  29.921  -5.219  1.00 42.31           C  
ATOM   1696  N   GLY B  13      14.050  31.150  -3.311  1.00 41.54           N  
ATOM   1697  CA  GLY B  13      15.292  31.564  -3.937  1.00 41.41           C  
ATOM   1698  C   GLY B  13      16.498  30.675  -3.699  1.00 43.74           C  
ATOM   1699  O   GLY B  13      17.589  30.959  -4.200  1.00 43.02           O  
ATOM   1700  N   PHE B  14      16.321  29.603  -2.933  1.00 41.75           N  
ATOM   1701  CA  PHE B  14      17.427  28.696  -2.657  1.00 39.89           C  
ATOM   1702  C   PHE B  14      17.261  27.397  -3.445  1.00 37.53           C  
ATOM   1703  O   PHE B  14      18.170  26.573  -3.493  1.00 41.53           O  
ATOM   1704  CB  PHE B  14      17.506  28.356  -1.159  1.00 38.74           C  
ATOM   1705  CG  PHE B  14      17.789  29.534  -0.270  1.00 41.17           C  
ATOM   1706  CD1 PHE B  14      16.758  30.375   0.149  1.00 40.34           C  
ATOM   1707  CD2 PHE B  14      19.086  29.796   0.164  1.00 38.17           C  
ATOM   1708  CE1 PHE B  14      17.016  31.457   0.994  1.00 40.81           C  
ATOM   1709  CE2 PHE B  14      19.357  30.874   1.008  1.00 41.73           C  
ATOM   1710  CZ  PHE B  14      18.320  31.708   1.426  1.00 38.95           C  
ATOM   1711  N   PHE B  15      16.098  27.196  -4.043  1.00 33.18           N  
ATOM   1712  CA  PHE B  15      15.875  25.975  -4.788  1.00 36.42           C  
ATOM   1713  C   PHE B  15      16.325  26.115  -6.244  1.00 41.20           C  
ATOM   1714  O   PHE B  15      15.886  27.025  -6.959  1.00 40.25           O  
ATOM   1715  CB  PHE B  15      14.401  25.568  -4.710  1.00 35.40           C  
ATOM   1716  CG  PHE B  15      13.857  25.516  -3.298  1.00 35.77           C  
ATOM   1717  CD1 PHE B  15      14.647  25.060  -2.242  1.00 35.73           C  
ATOM   1718  CD2 PHE B  15      12.547  25.908  -3.027  1.00 34.81           C  
ATOM   1719  CE1 PHE B  15      14.140  24.991  -0.934  1.00 32.09           C  
ATOM   1720  CE2 PHE B  15      12.029  25.840  -1.721  1.00 34.42           C  
ATOM   1721  CZ  PHE B  15      12.832  25.383  -0.676  1.00 31.20           C  
ATOM   1722  N   ARG B  16      17.225  25.223  -6.659  1.00 41.05           N  
ATOM   1723  CA  ARG B  16      17.758  25.208  -8.020  1.00 40.74           C  
ATOM   1724  C   ARG B  16      17.669  23.788  -8.545  1.00 42.11           C  
ATOM   1725  O   ARG B  16      17.712  22.819  -7.774  1.00 39.45           O  
ATOM   1726  CB  ARG B  16      19.228  25.622  -8.044  1.00 43.34           C  
ATOM   1727  CG  ARG B  16      19.544  26.959  -7.414  1.00 52.02           C  
ATOM   1728  CD  ARG B  16      21.060  27.122  -7.326  1.00 59.00           C  
ATOM   1729  NE  ARG B  16      21.668  26.035  -6.555  1.00 63.29           N  
ATOM   1730  CZ  ARG B  16      22.879  25.535  -6.787  1.00 64.63           C  
ATOM   1731  NH1 ARG B  16      23.620  26.024  -7.775  1.00 64.56           N  
ATOM   1732  NH2 ARG B  16      23.350  24.545  -6.034  1.00 62.72           N  
ATOM   1733  N   ASP B  17      17.560  23.658  -9.861  1.00 37.16           N  
ATOM   1734  CA  ASP B  17      17.484  22.340 -10.464  1.00 40.21           C  
ATOM   1735  C   ASP B  17      18.753  21.555 -10.162  1.00 35.30           C  
ATOM   1736  O   ASP B  17      19.833  22.131 -10.045  1.00 31.57           O  
ATOM   1737  CB  ASP B  17      17.302  22.462 -11.982  1.00 43.81           C  
ATOM   1738  CG  ASP B  17      15.871  22.736 -12.367  1.00 48.39           C  
ATOM   1739  OD1 ASP B  17      15.269  23.668 -11.794  1.00 52.97           O  
ATOM   1740  OD2 ASP B  17      15.338  22.021 -13.239  1.00 52.58           O  
ATOM   1741  N   GLY B  18      18.600  20.240 -10.017  1.00 36.38           N  
ATOM   1742  CA  GLY B  18      19.741  19.371  -9.777  1.00 34.74           C  
ATOM   1743  C   GLY B  18      20.533  19.469  -8.488  1.00 34.96           C  
ATOM   1744  O   GLY B  18      21.611  18.881  -8.392  1.00 32.86           O  
ATOM   1745  N   MET B  19      20.035  20.187  -7.488  1.00 32.51           N  
ATOM   1746  CA  MET B  19      20.799  20.279  -6.252  1.00 30.00           C  
ATOM   1747  C   MET B  19      20.514  19.083  -5.335  1.00 27.54           C  
ATOM   1748  O   MET B  19      19.539  18.355  -5.519  1.00 27.42           O  
ATOM   1749  CB  MET B  19      20.492  21.589  -5.520  1.00 30.21           C  
ATOM   1750  CG  MET B  19      19.140  21.609  -4.861  1.00 33.93           C  
ATOM   1751  SD  MET B  19      18.683  23.271  -4.283  1.00 37.08           S  
ATOM   1752  CE  MET B  19      20.173  23.837  -3.521  1.00 25.99           C  
ATOM   1753  N   THR B  20      21.392  18.893  -4.357  1.00 26.84           N  
ATOM   1754  CA  THR B  20      21.271  17.807  -3.389  1.00 25.18           C  
ATOM   1755  C   THR B  20      20.757  18.417  -2.088  1.00 19.41           C  
ATOM   1756  O   THR B  20      21.366  19.332  -1.537  1.00 21.50           O  
ATOM   1757  CB  THR B  20      22.631  17.139  -3.158  1.00 27.44           C  
ATOM   1758  OG1 THR B  20      23.035  16.486  -4.371  1.00 28.48           O  
ATOM   1759  CG2 THR B  20      22.545  16.088  -2.028  1.00 25.22           C  
ATOM   1760  N   ILE B  21      19.649  17.871  -1.607  1.00 19.33           N  
ATOM   1761  CA  ILE B  21      18.989  18.383  -0.414  1.00 21.52           C  
ATOM   1762  C   ILE B  21      18.739  17.334   0.664  1.00 14.88           C  
ATOM   1763  O   ILE B  21      18.217  16.260   0.394  1.00 19.32           O  
ATOM   1764  CB  ILE B  21      17.608  18.974  -0.769  1.00 21.41           C  
ATOM   1765  CG1 ILE B  21      17.742  19.937  -1.956  1.00 23.49           C  
ATOM   1766  CG2 ILE B  21      17.021  19.714   0.466  1.00 19.38           C  
ATOM   1767  CD1 ILE B  21      16.387  20.410  -2.509  1.00 23.70           C  
ATOM   1768  N   MET B  22      19.114  17.670   1.889  1.00 19.24           N  
ATOM   1769  CA  MET B  22      18.900  16.779   3.023  1.00 18.45           C  
ATOM   1770  C   MET B  22      17.615  17.288   3.658  1.00 20.65           C  
ATOM   1771  O   MET B  22      17.459  18.506   3.825  1.00 19.96           O  
ATOM   1772  CB  MET B  22      20.060  16.901   4.011  1.00 18.64           C  
ATOM   1773  CG  MET B  22      21.173  15.877   3.796  1.00 17.75           C  
ATOM   1774  SD  MET B  22      22.641  16.370   4.645  1.00 20.85           S  
ATOM   1775  CE  MET B  22      23.879  15.217   3.851  1.00 24.40           C  
ATOM   1776  N   VAL B  23      16.709  16.371   4.006  1.00 19.87           N  
ATOM   1777  CA  VAL B  23      15.435  16.749   4.599  1.00 21.53           C  
ATOM   1778  C   VAL B  23      15.153  15.969   5.889  1.00 23.85           C  
ATOM   1779  O   VAL B  23      15.267  14.737   5.928  1.00 19.43           O  
ATOM   1780  CB  VAL B  23      14.288  16.506   3.600  1.00 23.19           C  
ATOM   1781  CG1 VAL B  23      12.954  16.998   4.192  1.00 21.72           C  
ATOM   1782  CG2 VAL B  23      14.593  17.221   2.269  1.00 21.90           C  
ATOM   1783  N   GLY B  24      14.786  16.683   6.952  1.00 21.34           N  
ATOM   1784  CA  GLY B  24      14.494  15.994   8.193  1.00 17.83           C  
ATOM   1785  C   GLY B  24      13.169  15.276   8.137  1.00 20.04           C  
ATOM   1786  O   GLY B  24      12.368  15.504   7.224  1.00 19.26           O  
ATOM   1787  N   GLY B  25      12.929  14.397   9.107  1.00 21.25           N  
ATOM   1788  CA  GLY B  25      11.672  13.682   9.143  1.00 20.05           C  
ATOM   1789  C   GLY B  25      11.797  12.173   9.268  1.00 25.41           C  
ATOM   1790  O   GLY B  25      12.695  11.555   8.706  1.00 21.73           O  
ATOM   1791  N   PHE B  26      10.888  11.583  10.031  1.00 25.21           N  
ATOM   1792  CA  PHE B  26      10.843  10.137  10.224  1.00 27.80           C  
ATOM   1793  C   PHE B  26       9.445   9.746   9.813  1.00 28.58           C  
ATOM   1794  O   PHE B  26       8.476  10.118  10.483  1.00 30.22           O  
ATOM   1795  CB  PHE B  26      11.051   9.762  11.692  1.00 29.86           C  
ATOM   1796  CG  PHE B  26      10.639   8.350  12.009  1.00 31.24           C  
ATOM   1797  CD1 PHE B  26      11.393   7.270  11.548  1.00 31.40           C  
ATOM   1798  CD2 PHE B  26       9.470   8.097  12.724  1.00 28.99           C  
ATOM   1799  CE1 PHE B  26      10.987   5.958  11.795  1.00 33.32           C  
ATOM   1800  CE2 PHE B  26       9.056   6.791  12.976  1.00 30.34           C  
ATOM   1801  CZ  PHE B  26       9.811   5.718  12.511  1.00 30.89           C  
ATOM   1802  N   MET B  27       9.321   9.015   8.711  1.00 25.10           N  
ATOM   1803  CA  MET B  27       8.005   8.605   8.236  1.00 28.98           C  
ATOM   1804  C   MET B  27       7.044   9.802   8.170  1.00 33.15           C  
ATOM   1805  O   MET B  27       5.839   9.651   8.375  1.00 30.95           O  
ATOM   1806  CB  MET B  27       7.415   7.529   9.156  1.00 29.69           C  
ATOM   1807  CG  MET B  27       8.178   6.213   9.146  1.00 34.06           C  
ATOM   1808  SD  MET B  27       8.258   5.516   7.467  1.00 39.54           S  
ATOM   1809  CE  MET B  27       9.990   5.022   7.386  1.00 42.54           C  
ATOM   1810  N   GLY B  28       7.584  10.985   7.884  1.00 36.57           N  
ATOM   1811  CA  GLY B  28       6.746  12.172   7.781  1.00 40.22           C  
ATOM   1812  C   GLY B  28       6.746  13.023   9.041  1.00 41.61           C  
ATOM   1813  O   GLY B  28       6.371  14.200   9.013  1.00 43.59           O  
ATOM   1814  N   ILE B  29       7.194  12.434  10.144  1.00 41.31           N  
ATOM   1815  CA  ILE B  29       7.227  13.120  11.430  1.00 36.20           C  
ATOM   1816  C   ILE B  29       8.505  13.888  11.681  1.00 35.29           C  
ATOM   1817  O   ILE B  29       9.614  13.333  11.674  1.00 35.51           O  
ATOM   1818  CB  ILE B  29       7.012  12.119  12.578  1.00 35.05           C  
ATOM   1819  CG1 ILE B  29       5.711  11.365  12.334  1.00 32.98           C  
ATOM   1820  CG2 ILE B  29       6.967  12.842  13.910  1.00 34.20           C  
ATOM   1821  CD1 ILE B  29       4.533  12.276  12.026  1.00 34.10           C  
ATOM   1822  N   GLY B  30       8.354  15.173  11.957  1.00 29.77           N  
ATOM   1823  CA  GLY B  30       9.533  15.962  12.185  1.00 26.23           C  
ATOM   1824  C   GLY B  30      10.063  16.424  10.848  1.00 29.14           C  
ATOM   1825  O   GLY B  30      11.252  16.673  10.689  1.00 27.41           O  
ATOM   1826  N   THR B  31       9.181  16.516   9.860  1.00 24.12           N  
ATOM   1827  CA  THR B  31       9.600  17.007   8.565  1.00 24.58           C  
ATOM   1828  C   THR B  31       9.201  18.485   8.496  1.00 21.73           C  
ATOM   1829  O   THR B  31       8.144  18.876   9.005  1.00 23.15           O  
ATOM   1830  CB  THR B  31       8.893  16.263   7.418  1.00 27.72           C  
ATOM   1831  OG1 THR B  31       9.317  14.891   7.397  1.00 34.21           O  
ATOM   1832  CG2 THR B  31       9.227  16.925   6.077  1.00 31.53           C  
ATOM   1833  N   PRO B  32      10.057  19.334   7.909  1.00 22.29           N  
ATOM   1834  CA  PRO B  32       9.705  20.754   7.805  1.00 20.97           C  
ATOM   1835  C   PRO B  32       8.689  20.854   6.638  1.00 24.42           C  
ATOM   1836  O   PRO B  32       9.043  21.155   5.493  1.00 23.55           O  
ATOM   1837  CB  PRO B  32      11.050  21.417   7.514  1.00 22.28           C  
ATOM   1838  CG  PRO B  32      11.784  20.353   6.713  1.00 21.01           C  
ATOM   1839  CD  PRO B  32      11.450  19.092   7.480  1.00 24.49           C  
ATOM   1840  N   SER B  33       7.432  20.563   6.965  1.00 24.04           N  
ATOM   1841  CA  SER B  33       6.313  20.531   6.019  1.00 28.96           C  
ATOM   1842  C   SER B  33       6.228  21.691   5.048  1.00 27.30           C  
ATOM   1843  O   SER B  33       6.145  21.501   3.832  1.00 28.95           O  
ATOM   1844  CB  SER B  33       4.980  20.451   6.783  1.00 28.04           C  
ATOM   1845  OG  SER B  33       4.823  19.210   7.444  1.00 37.50           O  
ATOM   1846  N   ARG B  34       6.230  22.900   5.584  1.00 24.85           N  
ATOM   1847  CA  ARG B  34       6.101  24.068   4.733  1.00 27.43           C  
ATOM   1848  C   ARG B  34       7.298  24.302   3.835  1.00 26.29           C  
ATOM   1849  O   ARG B  34       7.135  24.774   2.718  1.00 24.86           O  
ATOM   1850  CB  ARG B  34       5.776  25.310   5.578  1.00 25.14           C  
ATOM   1851  CG  ARG B  34       4.348  25.277   6.113  1.00 27.04           C  
ATOM   1852  CD  ARG B  34       3.964  26.636   6.720  1.00 30.87           C  
ATOM   1853  NE  ARG B  34       4.854  26.984   7.817  1.00 27.96           N  
ATOM   1854  CZ  ARG B  34       5.150  28.223   8.199  1.00 31.65           C  
ATOM   1855  NH1 ARG B  34       4.622  29.269   7.570  1.00 31.05           N  
ATOM   1856  NH2 ARG B  34       5.995  28.414   9.206  1.00 28.86           N  
ATOM   1857  N   LEU B  35       8.496  23.965   4.298  1.00 24.42           N  
ATOM   1858  CA  LEU B  35       9.669  24.137   3.441  1.00 25.99           C  
ATOM   1859  C   LEU B  35       9.580  23.140   2.288  1.00 26.43           C  
ATOM   1860  O   LEU B  35       9.968  23.445   1.162  1.00 29.12           O  
ATOM   1861  CB  LEU B  35      10.965  23.935   4.231  1.00 24.29           C  
ATOM   1862  CG  LEU B  35      11.469  25.144   5.046  1.00 25.02           C  
ATOM   1863  CD1 LEU B  35      12.583  24.721   5.993  1.00 25.42           C  
ATOM   1864  CD2 LEU B  35      11.972  26.252   4.098  1.00 24.23           C  
ATOM   1865  N   VAL B  36       9.048  21.954   2.565  1.00 28.05           N  
ATOM   1866  CA  VAL B  36       8.917  20.935   1.532  1.00 30.97           C  
ATOM   1867  C   VAL B  36       7.843  21.354   0.521  1.00 33.47           C  
ATOM   1868  O   VAL B  36       7.988  21.108  -0.675  1.00 29.62           O  
ATOM   1869  CB  VAL B  36       8.594  19.555   2.146  1.00 29.98           C  
ATOM   1870  CG1 VAL B  36       8.242  18.562   1.060  1.00 31.47           C  
ATOM   1871  CG2 VAL B  36       9.813  19.049   2.923  1.00 30.47           C  
ATOM   1872  N   GLU B  37       6.778  21.992   1.008  1.00 33.13           N  
ATOM   1873  CA  GLU B  37       5.703  22.484   0.135  1.00 35.11           C  
ATOM   1874  C   GLU B  37       6.279  23.547  -0.786  1.00 32.01           C  
ATOM   1875  O   GLU B  37       6.005  23.568  -1.982  1.00 35.25           O  
ATOM   1876  CB  GLU B  37       4.579  23.123   0.956  1.00 39.31           C  
ATOM   1877  CG  GLU B  37       3.625  22.158   1.635  1.00 47.20           C  
ATOM   1878  CD  GLU B  37       2.592  22.885   2.503  1.00 54.79           C  
ATOM   1879  OE1 GLU B  37       1.980  23.865   2.007  1.00 55.74           O  
ATOM   1880  OE2 GLU B  37       2.394  22.476   3.675  1.00 55.37           O  
ATOM   1881  N   ALA B  38       7.080  24.436  -0.223  1.00 29.50           N  
ATOM   1882  CA  ALA B  38       7.679  25.494  -1.016  1.00 33.29           C  
ATOM   1883  C   ALA B  38       8.535  24.862  -2.107  1.00 35.67           C  
ATOM   1884  O   ALA B  38       8.461  25.253  -3.264  1.00 35.02           O  
ATOM   1885  CB  ALA B  38       8.530  26.398  -0.136  1.00 29.54           C  
ATOM   1886  N   LEU B  39       9.343  23.876  -1.725  1.00 33.70           N  
ATOM   1887  CA  LEU B  39      10.207  23.183  -2.668  1.00 32.78           C  
ATOM   1888  C   LEU B  39       9.387  22.635  -3.823  1.00 32.45           C  
ATOM   1889  O   LEU B  39       9.743  22.803  -4.990  1.00 33.31           O  
ATOM   1890  CB  LEU B  39      10.942  22.044  -1.959  1.00 30.61           C  
ATOM   1891  CG  LEU B  39      11.884  21.189  -2.811  1.00 31.74           C  
ATOM   1892  CD1 LEU B  39      12.960  22.059  -3.458  1.00 27.22           C  
ATOM   1893  CD2 LEU B  39      12.522  20.124  -1.909  1.00 26.23           C  
ATOM   1894  N   LEU B  40       8.285  21.979  -3.489  1.00 33.49           N  
ATOM   1895  CA  LEU B  40       7.397  21.397  -4.485  1.00 37.29           C  
ATOM   1896  C   LEU B  40       6.788  22.490  -5.377  1.00 41.13           C  
ATOM   1897  O   LEU B  40       6.732  22.354  -6.607  1.00 37.97           O  
ATOM   1898  CB  LEU B  40       6.303  20.600  -3.771  1.00 38.41           C  
ATOM   1899  CG  LEU B  40       5.277  19.770  -4.545  1.00 45.81           C  
ATOM   1900  CD1 LEU B  40       4.311  20.689  -5.262  1.00 50.43           C  
ATOM   1901  CD2 LEU B  40       5.989  18.833  -5.521  1.00 48.97           C  
ATOM   1902  N   GLU B  41       6.347  23.582  -4.760  1.00 41.85           N  
ATOM   1903  CA  GLU B  41       5.746  24.676  -5.512  1.00 46.05           C  
ATOM   1904  C   GLU B  41       6.765  25.363  -6.414  1.00 42.95           C  
ATOM   1905  O   GLU B  41       6.405  25.919  -7.446  1.00 44.07           O  
ATOM   1906  CB  GLU B  41       5.129  25.709  -4.563  1.00 48.47           C  
ATOM   1907  CG  GLU B  41       4.446  26.859  -5.285  1.00 57.04           C  
ATOM   1908  CD  GLU B  41       4.120  28.026  -4.368  1.00 61.57           C  
ATOM   1909  OE1 GLU B  41       3.589  29.043  -4.871  1.00 64.69           O  
ATOM   1910  OE2 GLU B  41       4.393  27.930  -3.149  1.00 64.36           O  
ATOM   1911  N   SER B  42       8.037  25.323  -6.029  1.00 42.28           N  
ATOM   1912  CA  SER B  42       9.080  25.968  -6.821  1.00 42.74           C  
ATOM   1913  C   SER B  42       9.256  25.303  -8.189  1.00 42.24           C  
ATOM   1914  O   SER B  42       9.875  25.878  -9.080  1.00 41.31           O  
ATOM   1915  CB  SER B  42      10.420  25.938  -6.085  1.00 42.29           C  
ATOM   1916  OG  SER B  42      11.049  24.676  -6.237  1.00 41.48           O  
ATOM   1917  N   GLY B  43       8.722  24.092  -8.338  1.00 42.87           N  
ATOM   1918  CA  GLY B  43       8.834  23.368  -9.595  1.00 42.79           C  
ATOM   1919  C   GLY B  43      10.230  22.906 -10.008  1.00 43.78           C  
ATOM   1920  O   GLY B  43      10.415  22.462 -11.143  1.00 45.31           O  
ATOM   1921  N   VAL B  44      11.219  22.998  -9.122  1.00 41.84           N  
ATOM   1922  CA  VAL B  44      12.572  22.560  -9.483  1.00 39.80           C  
ATOM   1923  C   VAL B  44      12.633  21.040  -9.595  1.00 39.49           C  
ATOM   1924  O   VAL B  44      11.807  20.334  -9.009  1.00 36.93           O  
ATOM   1925  CB  VAL B  44      13.623  23.033  -8.468  1.00 40.35           C  
ATOM   1926  CG1 VAL B  44      13.686  24.545  -8.474  1.00 37.88           C  
ATOM   1927  CG2 VAL B  44      13.290  22.498  -7.068  1.00 39.13           C  
ATOM   1928  N   ARG B  45      13.603  20.533 -10.353  1.00 40.20           N  
ATOM   1929  CA  ARG B  45      13.714  19.089 -10.546  1.00 38.35           C  
ATOM   1930  C   ARG B  45      15.141  18.551 -10.669  1.00 33.50           C  
ATOM   1931  O   ARG B  45      16.108  19.283 -10.501  1.00 30.04           O  
ATOM   1932  CB  ARG B  45      12.898  18.673 -11.769  1.00 42.91           C  
ATOM   1933  CG  ARG B  45      13.054  19.609 -12.963  1.00 48.79           C  
ATOM   1934  CD  ARG B  45      12.450  19.002 -14.216  1.00 54.24           C  
ATOM   1935  NE  ARG B  45      11.127  18.434 -13.970  1.00 59.63           N  
ATOM   1936  CZ  ARG B  45      10.069  19.132 -13.569  1.00 60.79           C  
ATOM   1937  NH1 ARG B  45      10.165  20.440 -13.365  1.00 62.67           N  
ATOM   1938  NH2 ARG B  45       8.910  18.517 -13.363  1.00 61.76           N  
ATOM   1939  N   ASP B  46      15.248  17.260 -10.987  1.00 37.28           N  
ATOM   1940  CA  ASP B  46      16.540  16.571 -11.096  1.00 37.80           C  
ATOM   1941  C   ASP B  46      17.237  16.656  -9.758  1.00 34.39           C  
ATOM   1942  O   ASP B  46      18.463  16.744  -9.680  1.00 31.24           O  
ATOM   1943  CB  ASP B  46      17.439  17.199 -12.159  1.00 42.81           C  
ATOM   1944  CG  ASP B  46      17.024  16.821 -13.549  1.00 48.94           C  
ATOM   1945  OD1 ASP B  46      16.497  15.698 -13.711  1.00 50.76           O  
ATOM   1946  OD2 ASP B  46      17.230  17.637 -14.476  1.00 52.37           O  
ATOM   1947  N   LEU B  47      16.442  16.641  -8.699  1.00 32.65           N  
ATOM   1948  CA  LEU B  47      16.988  16.737  -7.353  1.00 32.29           C  
ATOM   1949  C   LEU B  47      17.462  15.399  -6.827  1.00 26.90           C  
ATOM   1950  O   LEU B  47      16.981  14.355  -7.253  1.00 29.94           O  
ATOM   1951  CB  LEU B  47      15.918  17.236  -6.378  1.00 31.08           C  
ATOM   1952  CG  LEU B  47      15.270  18.596  -6.587  1.00 30.54           C  
ATOM   1953  CD1 LEU B  47      14.108  18.736  -5.611  1.00 32.76           C  
ATOM   1954  CD2 LEU B  47      16.294  19.679  -6.386  1.00 28.65           C  
ATOM   1955  N   THR B  48      18.405  15.452  -5.899  1.00 26.90           N  
ATOM   1956  CA  THR B  48      18.891  14.260  -5.209  1.00 26.58           C  
ATOM   1957  C   THR B  48      18.465  14.530  -3.765  1.00 24.80           C  
ATOM   1958  O   THR B  48      18.885  15.524  -3.171  1.00 25.02           O  
ATOM   1959  CB  THR B  48      20.422  14.135  -5.269  1.00 28.04           C  
ATOM   1960  OG1 THR B  48      20.808  13.800  -6.605  1.00 24.16           O  
ATOM   1961  CG2 THR B  48      20.925  13.036  -4.309  1.00 24.16           C  
ATOM   1962  N   LEU B  49      17.590  13.694  -3.221  1.00 21.60           N  
ATOM   1963  CA  LEU B  49      17.160  13.904  -1.843  1.00 20.93           C  
ATOM   1964  C   LEU B  49      17.782  12.870  -0.906  1.00 20.57           C  
ATOM   1965  O   LEU B  49      17.864  11.686  -1.246  1.00 21.62           O  
ATOM   1966  CB  LEU B  49      15.631  13.826  -1.736  1.00 19.92           C  
ATOM   1967  CG  LEU B  49      14.872  14.889  -2.544  1.00 21.91           C  
ATOM   1968  CD1 LEU B  49      13.379  14.654  -2.388  1.00 23.04           C  
ATOM   1969  CD2 LEU B  49      15.286  16.295  -2.097  1.00 21.40           C  
ATOM   1970  N   ILE B  50      18.209  13.336   0.268  1.00 20.37           N  
ATOM   1971  CA  ILE B  50      18.792  12.481   1.295  1.00 17.33           C  
ATOM   1972  C   ILE B  50      17.906  12.618   2.541  1.00 19.81           C  
ATOM   1973  O   ILE B  50      17.785  13.707   3.110  1.00 17.03           O  
ATOM   1974  CB  ILE B  50      20.207  12.940   1.664  1.00 18.03           C  
ATOM   1975  CG1 ILE B  50      21.096  12.912   0.413  1.00 21.73           C  
ATOM   1976  CG2 ILE B  50      20.769  12.043   2.781  1.00 16.65           C  
ATOM   1977  CD1 ILE B  50      22.508  13.335   0.665  1.00 19.66           C  
ATOM   1978  N   ALA B  51      17.305  11.513   2.959  1.00 19.71           N  
ATOM   1979  CA  ALA B  51      16.433  11.505   4.129  1.00 18.66           C  
ATOM   1980  C   ALA B  51      16.414  10.119   4.750  1.00 18.07           C  
ATOM   1981  O   ALA B  51      16.864   9.150   4.138  1.00 17.49           O  
ATOM   1982  CB  ALA B  51      15.003  11.888   3.714  1.00 19.39           C  
ATOM   1983  N   ASN B  52      15.856  10.011   5.948  1.00 17.70           N  
ATOM   1984  CA  ASN B  52      15.777   8.695   6.584  1.00 20.15           C  
ATOM   1985  C   ASN B  52      14.934   7.728   5.760  1.00 19.60           C  
ATOM   1986  O   ASN B  52      15.206   6.524   5.698  1.00 18.01           O  
ATOM   1987  CB  ASN B  52      15.133   8.774   7.967  1.00 20.66           C  
ATOM   1988  CG  ASN B  52      15.039   7.402   8.613  1.00 23.74           C  
ATOM   1989  OD1 ASN B  52      16.052   6.850   9.038  1.00 21.63           O  
ATOM   1990  ND2 ASN B  52      13.833   6.828   8.655  1.00 19.40           N  
ATOM   1991  N   ASP B  53      13.889   8.261   5.137  1.00 20.13           N  
ATOM   1992  CA  ASP B  53      12.985   7.447   4.350  1.00 19.26           C  
ATOM   1993  C   ASP B  53      12.224   8.324   3.350  1.00 19.86           C  
ATOM   1994  O   ASP B  53      12.387   9.546   3.329  1.00 22.34           O  
ATOM   1995  CB  ASP B  53      11.986   6.770   5.288  1.00 17.61           C  
ATOM   1996  CG  ASP B  53      11.250   7.784   6.169  1.00 24.94           C  
ATOM   1997  OD1 ASP B  53      11.593   7.933   7.363  1.00 22.56           O  
ATOM   1998  OD2 ASP B  53      10.341   8.452   5.648  1.00 22.80           O  
ATOM   1999  N   THR B  54      11.398   7.702   2.521  1.00 20.27           N  
ATOM   2000  CA  THR B  54      10.623   8.465   1.552  1.00 22.90           C  
ATOM   2001  C   THR B  54       9.144   8.598   1.975  1.00 26.10           C  
ATOM   2002  O   THR B  54       8.256   8.831   1.142  1.00 25.21           O  
ATOM   2003  CB  THR B  54      10.758   7.856   0.107  1.00 21.88           C  
ATOM   2004  OG1 THR B  54      10.287   6.502   0.082  1.00 23.68           O  
ATOM   2005  CG2 THR B  54      12.234   7.886  -0.336  1.00 21.95           C  
ATOM   2006  N   ALA B  55       8.904   8.471   3.285  1.00 26.37           N  
ATOM   2007  CA  ALA B  55       7.574   8.602   3.881  1.00 29.76           C  
ATOM   2008  C   ALA B  55       6.473   7.908   3.081  1.00 31.72           C  
ATOM   2009  O   ALA B  55       6.629   6.769   2.662  1.00 29.34           O  
ATOM   2010  CB  ALA B  55       7.239  10.102   4.063  1.00 32.01           C  
ATOM   2011  N   PHE B  56       5.346   8.595   2.899  1.00 34.42           N  
ATOM   2012  CA  PHE B  56       4.227   8.059   2.126  1.00 36.54           C  
ATOM   2013  C   PHE B  56       4.028   8.950   0.904  1.00 39.12           C  
ATOM   2014  O   PHE B  56       4.546  10.068   0.858  1.00 36.29           O  
ATOM   2015  CB  PHE B  56       2.946   8.027   2.967  1.00 37.99           C  
ATOM   2016  CG  PHE B  56       3.037   7.135   4.172  1.00 37.40           C  
ATOM   2017  CD1 PHE B  56       3.780   7.517   5.277  1.00 38.78           C  
ATOM   2018  CD2 PHE B  56       2.413   5.896   4.179  1.00 40.30           C  
ATOM   2019  CE1 PHE B  56       3.901   6.677   6.376  1.00 42.61           C  
ATOM   2020  CE2 PHE B  56       2.529   5.043   5.276  1.00 43.74           C  
ATOM   2021  CZ  PHE B  56       3.275   5.435   6.377  1.00 40.18           C  
ATOM   2022  N   VAL B  57       3.282   8.462  -0.083  1.00 40.74           N  
ATOM   2023  CA  VAL B  57       3.055   9.235  -1.301  1.00 45.54           C  
ATOM   2024  C   VAL B  57       2.564  10.648  -1.019  1.00 47.76           C  
ATOM   2025  O   VAL B  57       2.914  11.589  -1.732  1.00 48.98           O  
ATOM   2026  CB  VAL B  57       2.035   8.541  -2.228  1.00 45.15           C  
ATOM   2027  CG1 VAL B  57       2.630   7.264  -2.798  1.00 45.13           C  
ATOM   2028  CG2 VAL B  57       0.759   8.239  -1.458  1.00 47.62           C  
ATOM   2029  N   ASP B  58       1.771  10.800   0.035  1.00 49.37           N  
ATOM   2030  CA  ASP B  58       1.223  12.104   0.378  1.00 49.22           C  
ATOM   2031  C   ASP B  58       1.825  12.834   1.574  1.00 48.03           C  
ATOM   2032  O   ASP B  58       1.240  13.806   2.050  1.00 48.69           O  
ATOM   2033  CB  ASP B  58      -0.297  11.987   0.544  1.00 51.91           C  
ATOM   2034  CG  ASP B  58      -0.713  10.740   1.310  1.00 56.97           C  
ATOM   2035  OD1 ASP B  58      -1.884  10.326   1.164  1.00 60.11           O  
ATOM   2036  OD2 ASP B  58       0.114  10.174   2.060  1.00 57.28           O  
ATOM   2037  N   THR B  59       2.989  12.394   2.055  1.00 45.19           N  
ATOM   2038  CA  THR B  59       3.640  13.059   3.193  1.00 42.15           C  
ATOM   2039  C   THR B  59       5.154  13.097   3.032  1.00 43.16           C  
ATOM   2040  O   THR B  59       5.700  12.469   2.130  1.00 44.65           O  
ATOM   2041  CB  THR B  59       3.340  12.347   4.524  1.00 41.80           C  
ATOM   2042  OG1 THR B  59       4.059  11.109   4.576  1.00 38.24           O  
ATOM   2043  CG2 THR B  59       1.856  12.065   4.646  1.00 37.76           C  
ATOM   2044  N   GLY B  60       5.828  13.822   3.923  1.00 40.82           N  
ATOM   2045  CA  GLY B  60       7.274  13.927   3.855  1.00 39.26           C  
ATOM   2046  C   GLY B  60       7.696  14.307   2.450  1.00 39.53           C  
ATOM   2047  O   GLY B  60       7.024  15.108   1.803  1.00 42.05           O  
ATOM   2048  N   ILE B  61       8.797  13.742   1.963  1.00 36.64           N  
ATOM   2049  CA  ILE B  61       9.259  14.058   0.613  1.00 33.91           C  
ATOM   2050  C   ILE B  61       8.503  13.277  -0.466  1.00 30.13           C  
ATOM   2051  O   ILE B  61       8.820  13.371  -1.645  1.00 29.11           O  
ATOM   2052  CB  ILE B  61      10.771  13.787   0.460  1.00 32.03           C  
ATOM   2053  CG1 ILE B  61      11.088  12.331   0.823  1.00 30.23           C  
ATOM   2054  CG2 ILE B  61      11.560  14.741   1.336  1.00 33.70           C  
ATOM   2055  CD1 ILE B  61      12.511  11.934   0.484  1.00 27.55           C  
ATOM   2056  N   GLY B  62       7.494  12.519  -0.058  1.00 28.03           N  
ATOM   2057  CA  GLY B  62       6.728  11.723  -1.002  1.00 33.44           C  
ATOM   2058  C   GLY B  62       6.166  12.479  -2.198  1.00 37.27           C  
ATOM   2059  O   GLY B  62       6.290  12.012  -3.334  1.00 35.26           O  
ATOM   2060  N   PRO B  63       5.538  13.651  -1.981  1.00 39.94           N  
ATOM   2061  CA  PRO B  63       4.973  14.431  -3.092  1.00 40.61           C  
ATOM   2062  C   PRO B  63       6.024  14.873  -4.112  1.00 40.24           C  
ATOM   2063  O   PRO B  63       5.751  14.914  -5.309  1.00 41.15           O  
ATOM   2064  CB  PRO B  63       4.300  15.608  -2.386  1.00 39.23           C  
ATOM   2065  CG  PRO B  63       5.143  15.777  -1.142  1.00 44.05           C  
ATOM   2066  CD  PRO B  63       5.323  14.343  -0.695  1.00 38.68           C  
ATOM   2067  N   LEU B  64       7.222  15.204  -3.639  1.00 38.91           N  
ATOM   2068  CA  LEU B  64       8.297  15.607  -4.539  1.00 39.87           C  
ATOM   2069  C   LEU B  64       8.629  14.469  -5.494  1.00 40.24           C  
ATOM   2070  O   LEU B  64       8.966  14.697  -6.662  1.00 41.35           O  
ATOM   2071  CB  LEU B  64       9.546  15.970  -3.747  1.00 40.92           C  
ATOM   2072  CG  LEU B  64       9.443  17.247  -2.925  1.00 42.77           C  
ATOM   2073  CD1 LEU B  64      10.607  17.335  -1.955  1.00 41.06           C  
ATOM   2074  CD2 LEU B  64       9.417  18.436  -3.875  1.00 44.62           C  
ATOM   2075  N   ILE B  65       8.524  13.243  -4.994  1.00 37.53           N  
ATOM   2076  CA  ILE B  65       8.822  12.054  -5.786  1.00 37.88           C  
ATOM   2077  C   ILE B  65       7.728  11.726  -6.807  1.00 38.23           C  
ATOM   2078  O   ILE B  65       8.017  11.526  -7.994  1.00 33.10           O  
ATOM   2079  CB  ILE B  65       9.067  10.828  -4.855  1.00 33.56           C  
ATOM   2080  CG1 ILE B  65      10.333  11.076  -4.011  1.00 34.81           C  
ATOM   2081  CG2 ILE B  65       9.187   9.552  -5.685  1.00 35.47           C  
ATOM   2082  CD1 ILE B  65      10.577  10.076  -2.882  1.00 31.94           C  
ATOM   2083  N   VAL B  66       6.480  11.683  -6.350  1.00 38.06           N  
ATOM   2084  CA  VAL B  66       5.363  11.379  -7.240  1.00 43.73           C  
ATOM   2085  C   VAL B  66       5.261  12.398  -8.378  1.00 42.48           C  
ATOM   2086  O   VAL B  66       4.795  12.065  -9.464  1.00 41.99           O  
ATOM   2087  CB  VAL B  66       4.013  11.357  -6.491  1.00 44.56           C  
ATOM   2088  CG1 VAL B  66       4.022  10.269  -5.420  1.00 47.14           C  
ATOM   2089  CG2 VAL B  66       3.738  12.722  -5.883  1.00 46.04           C  
ATOM   2090  N   ASN B  67       5.712  13.624  -8.121  1.00 41.36           N  
ATOM   2091  CA  ASN B  67       5.677  14.683  -9.119  1.00 41.50           C  
ATOM   2092  C   ASN B  67       6.955  14.814  -9.950  1.00 41.68           C  
ATOM   2093  O   ASN B  67       7.271  15.900 -10.456  1.00 40.80           O  
ATOM   2094  CB  ASN B  67       5.363  16.023  -8.460  1.00 43.13           C  
ATOM   2095  CG  ASN B  67       3.909  16.136  -8.046  1.00 47.29           C  
ATOM   2096  OD1 ASN B  67       3.475  15.529  -7.064  1.00 45.65           O  
ATOM   2097  ND2 ASN B  67       3.142  16.907  -8.807  1.00 46.08           N  
ATOM   2098  N   GLY B  68       7.687  13.708 -10.074  1.00 37.77           N  
ATOM   2099  CA  GLY B  68       8.902  13.690 -10.870  1.00 34.33           C  
ATOM   2100  C   GLY B  68       9.946  14.767 -10.653  1.00 35.58           C  
ATOM   2101  O   GLY B  68      10.678  15.103 -11.588  1.00 37.54           O  
ATOM   2102  N   ARG B  69      10.060  15.297  -9.436  1.00 32.73           N  
ATOM   2103  CA  ARG B  69      11.046  16.345  -9.174  1.00 30.54           C  
ATOM   2104  C   ARG B  69      12.369  15.786  -8.666  1.00 30.39           C  
ATOM   2105  O   ARG B  69      13.338  16.528  -8.482  1.00 30.44           O  
ATOM   2106  CB  ARG B  69      10.509  17.325  -8.136  1.00 35.81           C  
ATOM   2107  CG  ARG B  69       9.070  17.748  -8.376  1.00 35.91           C  
ATOM   2108  CD  ARG B  69       8.903  18.462  -9.722  1.00 37.49           C  
ATOM   2109  NE  ARG B  69       7.509  18.833  -9.899  1.00 38.69           N  
ATOM   2110  CZ  ARG B  69       6.928  19.856  -9.280  1.00 39.67           C  
ATOM   2111  NH1 ARG B  69       7.630  20.620  -8.458  1.00 40.85           N  
ATOM   2112  NH2 ARG B  69       5.637  20.088  -9.456  1.00 40.41           N  
ATOM   2113  N   VAL B  70      12.405  14.475  -8.447  1.00 30.67           N  
ATOM   2114  CA  VAL B  70      13.602  13.826  -7.905  1.00 27.23           C  
ATOM   2115  C   VAL B  70      14.230  12.777  -8.810  1.00 23.62           C  
ATOM   2116  O   VAL B  70      13.578  11.804  -9.171  1.00 26.14           O  
ATOM   2117  CB  VAL B  70      13.261  13.138  -6.577  1.00 23.82           C  
ATOM   2118  CG1 VAL B  70      14.545  12.672  -5.896  1.00 29.26           C  
ATOM   2119  CG2 VAL B  70      12.472  14.092  -5.674  1.00 25.43           C  
ATOM   2120  N   ARG B  71      15.494  12.962  -9.165  1.00 28.39           N  
ATOM   2121  CA  ARG B  71      16.170  11.986 -10.008  1.00 28.81           C  
ATOM   2122  C   ARG B  71      16.823  10.892  -9.166  1.00 31.44           C  
ATOM   2123  O   ARG B  71      16.973   9.751  -9.623  1.00 29.39           O  
ATOM   2124  CB  ARG B  71      17.246  12.649 -10.874  1.00 35.81           C  
ATOM   2125  CG  ARG B  71      18.378  13.326 -10.120  1.00 40.87           C  
ATOM   2126  CD  ARG B  71      19.530  13.678 -11.077  1.00 49.64           C  
ATOM   2127  NE  ARG B  71      20.476  12.572 -11.240  1.00 55.45           N  
ATOM   2128  CZ  ARG B  71      21.493  12.320 -10.414  1.00 59.46           C  
ATOM   2129  NH1 ARG B  71      21.712  13.102  -9.363  1.00 61.39           N  
ATOM   2130  NH2 ARG B  71      22.284  11.271 -10.621  1.00 59.63           N  
ATOM   2131  N   LYS B  72      17.201  11.232  -7.936  1.00 26.57           N  
ATOM   2132  CA  LYS B  72      17.865  10.264  -7.074  1.00 26.12           C  
ATOM   2133  C   LYS B  72      17.502  10.387  -5.597  1.00 24.60           C  
ATOM   2134  O   LYS B  72      17.435  11.489  -5.059  1.00 25.04           O  
ATOM   2135  CB  LYS B  72      19.378  10.434  -7.225  1.00 24.77           C  
ATOM   2136  CG  LYS B  72      20.207   9.552  -6.314  1.00 26.11           C  
ATOM   2137  CD  LYS B  72      21.689   9.757  -6.550  1.00 31.64           C  
ATOM   2138  CE  LYS B  72      22.502   8.719  -5.779  1.00 34.99           C  
ATOM   2139  NZ  LYS B  72      23.955   8.751  -6.130  1.00 33.61           N  
ATOM   2140  N   VAL B  73      17.273   9.252  -4.952  1.00 25.00           N  
ATOM   2141  CA  VAL B  73      16.975   9.234  -3.526  1.00 23.41           C  
ATOM   2142  C   VAL B  73      18.004   8.383  -2.794  1.00 22.98           C  
ATOM   2143  O   VAL B  73      18.343   7.293  -3.249  1.00 22.59           O  
ATOM   2144  CB  VAL B  73      15.605   8.624  -3.223  1.00 22.79           C  
ATOM   2145  CG1 VAL B  73      15.454   8.432  -1.702  1.00 26.06           C  
ATOM   2146  CG2 VAL B  73      14.487   9.545  -3.733  1.00 25.51           C  
ATOM   2147  N   ILE B  74      18.509   8.892  -1.673  1.00 20.49           N  
ATOM   2148  CA  ILE B  74      19.452   8.158  -0.831  1.00 18.15           C  
ATOM   2149  C   ILE B  74      18.690   8.138   0.496  1.00 23.90           C  
ATOM   2150  O   ILE B  74      18.479   9.191   1.118  1.00 20.43           O  
ATOM   2151  CB  ILE B  74      20.789   8.905  -0.656  1.00 21.17           C  
ATOM   2152  CG1 ILE B  74      21.537   8.958  -1.996  1.00 19.05           C  
ATOM   2153  CG2 ILE B  74      21.650   8.204   0.405  1.00 20.07           C  
ATOM   2154  CD1 ILE B  74      22.832   9.763  -1.950  1.00 26.57           C  
ATOM   2155  N   ALA B  75      18.255   6.953   0.908  1.00 20.27           N  
ATOM   2156  CA  ALA B  75      17.460   6.802   2.128  1.00 20.98           C  
ATOM   2157  C   ALA B  75      17.673   5.410   2.739  1.00 20.85           C  
ATOM   2158  O   ALA B  75      18.328   4.558   2.128  1.00 21.53           O  
ATOM   2159  CB  ALA B  75      15.961   7.010   1.776  1.00 17.72           C  
ATOM   2160  N   SER B  76      17.117   5.168   3.929  1.00 16.04           N  
ATOM   2161  CA  SER B  76      17.285   3.864   4.582  1.00 18.64           C  
ATOM   2162  C   SER B  76      16.022   2.997   4.527  1.00 22.29           C  
ATOM   2163  O   SER B  76      16.046   1.828   4.914  1.00 19.82           O  
ATOM   2164  CB  SER B  76      17.729   4.041   6.046  1.00 20.05           C  
ATOM   2165  OG  SER B  76      16.636   4.451   6.856  1.00 20.93           O  
ATOM   2166  N   HIS B  77      14.914   3.567   4.049  1.00 19.31           N  
ATOM   2167  CA  HIS B  77      13.683   2.806   3.931  1.00 20.90           C  
ATOM   2168  C   HIS B  77      12.797   3.478   2.879  1.00 22.73           C  
ATOM   2169  O   HIS B  77      12.726   4.710   2.815  1.00 21.11           O  
ATOM   2170  CB  HIS B  77      12.943   2.723   5.275  1.00 23.61           C  
ATOM   2171  CG  HIS B  77      11.939   1.612   5.329  1.00 32.57           C  
ATOM   2172  ND1 HIS B  77      12.292   0.305   5.599  1.00 38.01           N  
ATOM   2173  CD2 HIS B  77      10.614   1.593   5.055  1.00 32.68           C  
ATOM   2174  CE1 HIS B  77      11.227  -0.469   5.487  1.00 37.70           C  
ATOM   2175  NE2 HIS B  77      10.195   0.288   5.157  1.00 38.62           N  
ATOM   2176  N   ILE B  78      12.143   2.667   2.053  1.00 21.04           N  
ATOM   2177  CA  ILE B  78      11.291   3.190   0.988  1.00 24.64           C  
ATOM   2178  C   ILE B  78      10.011   2.377   0.854  1.00 25.86           C  
ATOM   2179  O   ILE B  78       9.178   2.651  -0.014  1.00 25.25           O  
ATOM   2180  CB  ILE B  78      12.007   3.129  -0.363  1.00 25.37           C  
ATOM   2181  CG1 ILE B  78      12.271   1.669  -0.730  1.00 28.04           C  
ATOM   2182  CG2 ILE B  78      13.303   3.907  -0.308  1.00 19.55           C  
ATOM   2183  CD1 ILE B  78      12.961   1.502  -2.069  1.00 29.24           C  
ATOM   2184  N   GLY B  79       9.865   1.389   1.729  1.00 27.92           N  
ATOM   2185  CA  GLY B  79       8.720   0.505   1.695  1.00 28.23           C  
ATOM   2186  C   GLY B  79       7.328   1.069   1.877  1.00 31.13           C  
ATOM   2187  O   GLY B  79       6.370   0.455   1.405  1.00 29.50           O  
ATOM   2188  N   THR B  80       7.185   2.203   2.561  1.00 29.88           N  
ATOM   2189  CA  THR B  80       5.849   2.771   2.761  1.00 33.20           C  
ATOM   2190  C   THR B  80       5.439   3.703   1.623  1.00 34.06           C  
ATOM   2191  O   THR B  80       4.358   4.283   1.649  1.00 33.95           O  
ATOM   2192  CB  THR B  80       5.754   3.540   4.097  1.00 33.68           C  
ATOM   2193  OG1 THR B  80       6.776   4.541   4.148  1.00 35.24           O  
ATOM   2194  CG2 THR B  80       5.920   2.596   5.267  1.00 32.23           C  
ATOM   2195  N   ASN B  81       6.311   3.854   0.628  1.00 32.96           N  
ATOM   2196  CA  ASN B  81       6.015   4.704  -0.517  1.00 33.81           C  
ATOM   2197  C   ASN B  81       6.194   3.875  -1.791  1.00 34.85           C  
ATOM   2198  O   ASN B  81       7.289   3.778  -2.350  1.00 34.92           O  
ATOM   2199  CB  ASN B  81       6.934   5.928  -0.514  1.00 32.83           C  
ATOM   2200  CG  ASN B  81       6.610   6.912  -1.629  1.00 33.98           C  
ATOM   2201  OD1 ASN B  81       6.936   8.099  -1.532  1.00 34.28           O  
ATOM   2202  ND2 ASN B  81       5.991   6.423  -2.699  1.00 29.17           N  
ATOM   2203  N   PRO B  82       5.101   3.256  -2.263  1.00 36.81           N  
ATOM   2204  CA  PRO B  82       5.102   2.420  -3.468  1.00 35.72           C  
ATOM   2205  C   PRO B  82       5.634   3.117  -4.712  1.00 36.07           C  
ATOM   2206  O   PRO B  82       6.201   2.472  -5.595  1.00 38.29           O  
ATOM   2207  CB  PRO B  82       3.635   1.998  -3.601  1.00 37.33           C  
ATOM   2208  CG  PRO B  82       2.894   3.129  -2.948  1.00 38.56           C  
ATOM   2209  CD  PRO B  82       3.737   3.416  -1.731  1.00 35.36           C  
ATOM   2210  N   GLU B  83       5.471   4.436  -4.770  1.00 35.52           N  
ATOM   2211  CA  GLU B  83       5.938   5.208  -5.918  1.00 37.26           C  
ATOM   2212  C   GLU B  83       7.460   5.211  -5.998  1.00 37.45           C  
ATOM   2213  O   GLU B  83       8.024   5.258  -7.085  1.00 35.65           O  
ATOM   2214  CB  GLU B  83       5.413   6.646  -5.836  1.00 38.49           C  
ATOM   2215  CG  GLU B  83       5.819   7.554  -6.990  1.00 44.54           C  
ATOM   2216  CD  GLU B  83       5.207   7.153  -8.337  1.00 45.74           C  
ATOM   2217  OE1 GLU B  83       4.352   6.238  -8.374  1.00 44.12           O  
ATOM   2218  OE2 GLU B  83       5.587   7.766  -9.360  1.00 43.70           O  
ATOM   2219  N   THR B  84       8.134   5.155  -4.850  1.00 35.54           N  
ATOM   2220  CA  THR B  84       9.600   5.143  -4.854  1.00 33.22           C  
ATOM   2221  C   THR B  84      10.072   3.864  -5.522  1.00 31.88           C  
ATOM   2222  O   THR B  84      10.955   3.886  -6.373  1.00 32.86           O  
ATOM   2223  CB  THR B  84      10.177   5.184  -3.424  1.00 30.79           C  
ATOM   2224  OG1 THR B  84       9.727   6.374  -2.766  1.00 28.47           O  
ATOM   2225  CG2 THR B  84      11.704   5.187  -3.469  1.00 28.09           C  
ATOM   2226  N   GLY B  85       9.465   2.755  -5.121  1.00 33.74           N  
ATOM   2227  CA  GLY B  85       9.821   1.466  -5.675  1.00 36.43           C  
ATOM   2228  C   GLY B  85       9.464   1.380  -7.146  1.00 37.48           C  
ATOM   2229  O   GLY B  85      10.238   0.863  -7.946  1.00 36.60           O  
ATOM   2230  N   ARG B  86       8.296   1.902  -7.507  1.00 38.81           N  
ATOM   2231  CA  ARG B  86       7.854   1.869  -8.899  1.00 37.56           C  
ATOM   2232  C   ARG B  86       8.860   2.574  -9.800  1.00 37.94           C  
ATOM   2233  O   ARG B  86       9.269   2.036 -10.826  1.00 37.86           O  
ATOM   2234  CB  ARG B  86       6.485   2.542  -9.051  1.00 39.47           C  
ATOM   2235  CG  ARG B  86       5.866   2.365 -10.435  1.00 39.15           C  
ATOM   2236  CD  ARG B  86       4.629   3.236 -10.645  1.00 41.63           C  
ATOM   2237  NE  ARG B  86       4.951   4.661 -10.761  1.00 44.34           N  
ATOM   2238  CZ  ARG B  86       5.732   5.175 -11.708  1.00 44.97           C  
ATOM   2239  NH1 ARG B  86       6.272   4.383 -12.627  1.00 48.56           N  
ATOM   2240  NH2 ARG B  86       5.975   6.481 -11.742  1.00 43.99           N  
ATOM   2241  N   ARG B  87       9.265   3.776  -9.403  1.00 36.65           N  
ATOM   2242  CA  ARG B  87      10.201   4.571 -10.179  1.00 36.44           C  
ATOM   2243  C   ARG B  87      11.612   4.005 -10.186  1.00 37.09           C  
ATOM   2244  O   ARG B  87      12.414   4.331 -11.063  1.00 35.55           O  
ATOM   2245  CB  ARG B  87      10.210   6.006  -9.656  1.00 35.28           C  
ATOM   2246  CG  ARG B  87       8.832   6.656  -9.714  1.00 38.92           C  
ATOM   2247  CD  ARG B  87       8.847   8.066  -9.179  1.00 40.75           C  
ATOM   2248  NE  ARG B  87       9.413   9.007 -10.134  1.00 45.92           N  
ATOM   2249  CZ  ARG B  87       8.696   9.704 -11.013  1.00 46.18           C  
ATOM   2250  NH1 ARG B  87       7.377   9.570 -11.058  1.00 46.92           N  
ATOM   2251  NH2 ARG B  87       9.302  10.537 -11.850  1.00 46.99           N  
ATOM   2252  N   MET B  88      11.913   3.172  -9.194  1.00 40.22           N  
ATOM   2253  CA  MET B  88      13.223   2.542  -9.085  1.00 40.07           C  
ATOM   2254  C   MET B  88      13.272   1.427 -10.125  1.00 40.63           C  
ATOM   2255  O   MET B  88      14.246   1.290 -10.864  1.00 36.88           O  
ATOM   2256  CB  MET B  88      13.406   1.962  -7.675  1.00 42.42           C  
ATOM   2257  CG  MET B  88      14.729   1.235  -7.439  1.00 44.81           C  
ATOM   2258  SD  MET B  88      14.904   0.607  -5.726  1.00 45.47           S  
ATOM   2259  CE  MET B  88      13.668  -0.708  -5.726  1.00 47.22           C  
ATOM   2260  N   ILE B  89      12.197   0.645 -10.179  1.00 42.85           N  
ATOM   2261  CA  ILE B  89      12.070  -0.467 -11.116  1.00 45.58           C  
ATOM   2262  C   ILE B  89      12.008   0.014 -12.562  1.00 46.70           C  
ATOM   2263  O   ILE B  89      12.722  -0.495 -13.420  1.00 48.01           O  
ATOM   2264  CB  ILE B  89      10.791  -1.286 -10.835  1.00 46.89           C  
ATOM   2265  CG1 ILE B  89      10.877  -1.940  -9.458  1.00 48.65           C  
ATOM   2266  CG2 ILE B  89      10.596  -2.337 -11.916  1.00 47.47           C  
ATOM   2267  CD1 ILE B  89      12.074  -2.867  -9.292  1.00 51.61           C  
ATOM   2268  N   SER B  90      11.148   0.992 -12.827  1.00 47.28           N  
ATOM   2269  CA  SER B  90      10.981   1.531 -14.174  1.00 45.81           C  
ATOM   2270  C   SER B  90      12.218   2.285 -14.637  1.00 45.72           C  
ATOM   2271  O   SER B  90      12.351   2.608 -15.815  1.00 45.92           O  
ATOM   2272  CB  SER B  90       9.792   2.485 -14.218  1.00 46.22           C  
ATOM   2273  OG  SER B  90      10.108   3.691 -13.547  1.00 47.14           O  
ATOM   2274  N   GLY B  91      13.120   2.580 -13.709  1.00 42.89           N  
ATOM   2275  CA  GLY B  91      14.321   3.303 -14.079  1.00 38.43           C  
ATOM   2276  C   GLY B  91      14.088   4.795 -14.156  1.00 39.45           C  
ATOM   2277  O   GLY B  91      14.947   5.541 -14.622  1.00 39.15           O  
ATOM   2278  N   GLU B  92      12.923   5.242 -13.701  1.00 39.98           N  
ATOM   2279  CA  GLU B  92      12.604   6.665 -13.729  1.00 40.21           C  
ATOM   2280  C   GLU B  92      13.341   7.434 -12.644  1.00 39.55           C  
ATOM   2281  O   GLU B  92      13.520   8.652 -12.751  1.00 35.06           O  
ATOM   2282  CB  GLU B  92      11.109   6.884 -13.538  1.00 44.80           C  
ATOM   2283  CG  GLU B  92      10.232   6.275 -14.604  1.00 49.66           C  
ATOM   2284  CD  GLU B  92       8.771   6.563 -14.351  1.00 51.15           C  
ATOM   2285  OE1 GLU B  92       8.374   7.743 -14.468  1.00 53.07           O  
ATOM   2286  OE2 GLU B  92       8.026   5.613 -14.019  1.00 52.83           O  
ATOM   2287  N   MET B  93      13.752   6.729 -11.590  1.00 36.11           N  
ATOM   2288  CA  MET B  93      14.456   7.371 -10.481  1.00 31.64           C  
ATOM   2289  C   MET B  93      15.509   6.428  -9.903  1.00 30.89           C  
ATOM   2290  O   MET B  93      15.281   5.227  -9.787  1.00 32.53           O  
ATOM   2291  CB  MET B  93      13.451   7.762  -9.386  1.00 29.63           C  
ATOM   2292  CG  MET B  93      13.996   8.715  -8.321  1.00 28.90           C  
ATOM   2293  SD  MET B  93      12.713   9.234  -7.140  1.00 29.10           S  
ATOM   2294  CE  MET B  93      12.402   7.691  -6.278  1.00 31.24           C  
ATOM   2295  N   ASP B  94      16.664   6.975  -9.561  1.00 28.24           N  
ATOM   2296  CA  ASP B  94      17.737   6.178  -8.985  1.00 28.49           C  
ATOM   2297  C   ASP B  94      17.470   6.113  -7.486  1.00 28.35           C  
ATOM   2298  O   ASP B  94      17.123   7.120  -6.880  1.00 28.18           O  
ATOM   2299  CB  ASP B  94      19.083   6.850  -9.245  1.00 30.74           C  
ATOM   2300  CG  ASP B  94      20.256   6.039  -8.722  1.00 35.99           C  
ATOM   2301  OD1 ASP B  94      20.140   4.796  -8.610  1.00 40.78           O  
ATOM   2302  OD2 ASP B  94      21.310   6.646  -8.439  1.00 40.68           O  
ATOM   2303  N   VAL B  95      17.610   4.935  -6.896  1.00 25.27           N  
ATOM   2304  CA  VAL B  95      17.385   4.794  -5.465  1.00 27.00           C  
ATOM   2305  C   VAL B  95      18.538   4.033  -4.827  1.00 28.02           C  
ATOM   2306  O   VAL B  95      18.872   2.927  -5.257  1.00 28.26           O  
ATOM   2307  CB  VAL B  95      16.069   4.049  -5.171  1.00 24.16           C  
ATOM   2308  CG1 VAL B  95      15.908   3.848  -3.658  1.00 25.00           C  
ATOM   2309  CG2 VAL B  95      14.883   4.841  -5.730  1.00 25.23           C  
ATOM   2310  N   VAL B  96      19.157   4.638  -3.815  1.00 24.62           N  
ATOM   2311  CA  VAL B  96      20.256   4.004  -3.096  1.00 24.28           C  
ATOM   2312  C   VAL B  96      19.743   3.744  -1.676  1.00 26.80           C  
ATOM   2313  O   VAL B  96      19.554   4.688  -0.889  1.00 20.58           O  
ATOM   2314  CB  VAL B  96      21.478   4.920  -3.045  1.00 26.18           C  
ATOM   2315  CG1 VAL B  96      22.623   4.208  -2.350  1.00 29.31           C  
ATOM   2316  CG2 VAL B  96      21.882   5.341  -4.473  1.00 24.65           C  
ATOM   2317  N   LEU B  97      19.484   2.472  -1.368  1.00 22.16           N  
ATOM   2318  CA  LEU B  97      18.976   2.086  -0.046  1.00 22.91           C  
ATOM   2319  C   LEU B  97      20.197   1.834   0.828  1.00 24.68           C  
ATOM   2320  O   LEU B  97      20.990   0.933   0.556  1.00 23.57           O  
ATOM   2321  CB  LEU B  97      18.130   0.819  -0.147  1.00 22.07           C  
ATOM   2322  CG  LEU B  97      17.284   0.460   1.075  1.00 26.74           C  
ATOM   2323  CD1 LEU B  97      16.204   1.521   1.250  1.00 24.88           C  
ATOM   2324  CD2 LEU B  97      16.640  -0.903   0.901  1.00 30.84           C  
ATOM   2325  N   VAL B  98      20.347   2.645   1.869  1.00 20.96           N  
ATOM   2326  CA  VAL B  98      21.485   2.566   2.775  1.00 16.79           C  
ATOM   2327  C   VAL B  98      21.038   2.092   4.161  1.00 20.83           C  
ATOM   2328  O   VAL B  98      20.019   2.561   4.667  1.00 21.77           O  
ATOM   2329  CB  VAL B  98      22.122   3.976   2.947  1.00 17.06           C  
ATOM   2330  CG1 VAL B  98      23.336   3.900   3.858  1.00 17.71           C  
ATOM   2331  CG2 VAL B  98      22.471   4.581   1.579  1.00 19.00           C  
ATOM   2332  N   PRO B  99      21.779   1.149   4.788  1.00 17.68           N  
ATOM   2333  CA  PRO B  99      21.371   0.695   6.130  1.00 14.48           C  
ATOM   2334  C   PRO B  99      21.258   1.966   6.982  1.00 14.48           C  
ATOM   2335  O   PRO B  99      22.086   2.866   6.859  1.00 17.29           O  
ATOM   2336  CB  PRO B  99      22.538  -0.198   6.569  1.00 14.85           C  
ATOM   2337  CG  PRO B  99      23.018  -0.810   5.240  1.00 15.47           C  
ATOM   2338  CD  PRO B  99      22.972   0.413   4.303  1.00 18.45           C  
ATOM   2339  N   GLN B 100      20.258   2.051   7.846  1.00 16.43           N  
ATOM   2340  CA  GLN B 100      20.087   3.277   8.628  1.00 15.88           C  
ATOM   2341  C   GLN B 100      21.290   3.717   9.459  1.00 13.58           C  
ATOM   2342  O   GLN B 100      21.648   4.885   9.446  1.00 17.02           O  
ATOM   2343  CB  GLN B 100      18.860   3.167   9.535  1.00 21.48           C  
ATOM   2344  CG  GLN B 100      18.526   4.472  10.247  1.00 20.79           C  
ATOM   2345  CD  GLN B 100      17.418   4.272  11.242  1.00 25.67           C  
ATOM   2346  OE1 GLN B 100      17.577   3.518  12.192  1.00 21.04           O  
ATOM   2347  NE2 GLN B 100      16.279   4.926  11.025  1.00 23.91           N  
ATOM   2348  N   GLY B 101      21.922   2.791  10.178  1.00 16.18           N  
ATOM   2349  CA  GLY B 101      23.067   3.174  10.991  1.00 12.71           C  
ATOM   2350  C   GLY B 101      24.180   3.722  10.128  1.00 14.16           C  
ATOM   2351  O   GLY B 101      24.918   4.621  10.518  1.00 14.54           O  
ATOM   2352  N   THR B 102      24.327   3.139   8.942  1.00 15.62           N  
ATOM   2353  CA  THR B 102      25.354   3.585   8.015  1.00 14.40           C  
ATOM   2354  C   THR B 102      25.035   4.979   7.486  1.00 13.81           C  
ATOM   2355  O   THR B 102      25.900   5.853   7.473  1.00 13.59           O  
ATOM   2356  CB  THR B 102      25.495   2.565   6.849  1.00 14.79           C  
ATOM   2357  OG1 THR B 102      26.016   1.338   7.383  1.00 16.82           O  
ATOM   2358  CG2 THR B 102      26.436   3.092   5.765  1.00 12.67           C  
ATOM   2359  N   LEU B 103      23.783   5.196   7.079  1.00 14.60           N  
ATOM   2360  CA  LEU B 103      23.371   6.508   6.537  1.00 14.08           C  
ATOM   2361  C   LEU B 103      23.612   7.609   7.581  1.00 14.43           C  
ATOM   2362  O   LEU B 103      24.114   8.685   7.274  1.00 16.99           O  
ATOM   2363  CB  LEU B 103      21.890   6.459   6.134  1.00 16.07           C  
ATOM   2364  CG  LEU B 103      21.274   7.746   5.547  1.00 17.23           C  
ATOM   2365  CD1 LEU B 103      22.082   8.244   4.350  1.00 17.43           C  
ATOM   2366  CD2 LEU B 103      19.834   7.450   5.144  1.00 19.59           C  
ATOM   2367  N   ILE B 104      23.284   7.311   8.832  1.00 16.28           N  
ATOM   2368  CA  ILE B 104      23.490   8.267   9.912  1.00 15.33           C  
ATOM   2369  C   ILE B 104      24.968   8.622  10.041  1.00 19.06           C  
ATOM   2370  O   ILE B 104      25.334   9.798  10.100  1.00 16.46           O  
ATOM   2371  CB  ILE B 104      22.957   7.690  11.254  1.00 18.03           C  
ATOM   2372  CG1 ILE B 104      21.429   7.629  11.190  1.00 16.43           C  
ATOM   2373  CG2 ILE B 104      23.491   8.511  12.449  1.00 20.35           C  
ATOM   2374  CD1 ILE B 104      20.770   6.771  12.276  1.00 20.42           C  
ATOM   2375  N   GLU B 105      25.831   7.609  10.064  1.00 16.96           N  
ATOM   2376  CA  GLU B 105      27.257   7.868  10.212  1.00 15.00           C  
ATOM   2377  C   GLU B 105      27.859   8.567   8.987  1.00 14.56           C  
ATOM   2378  O   GLU B 105      28.813   9.334   9.112  1.00 14.33           O  
ATOM   2379  CB  GLU B 105      27.998   6.565  10.513  1.00 19.64           C  
ATOM   2380  CG  GLU B 105      29.501   6.752  10.730  1.00 25.54           C  
ATOM   2381  CD  GLU B 105      29.860   7.542  11.995  1.00 28.95           C  
ATOM   2382  OE1 GLU B 105      28.950   7.917  12.774  1.00 24.90           O  
ATOM   2383  OE2 GLU B 105      31.070   7.780  12.211  1.00 26.06           O  
ATOM   2384  N   GLN B 106      27.327   8.293   7.797  1.00 14.32           N  
ATOM   2385  CA  GLN B 106      27.835   8.964   6.608  1.00 15.28           C  
ATOM   2386  C   GLN B 106      27.566  10.470   6.737  1.00 15.57           C  
ATOM   2387  O   GLN B 106      28.434  11.312   6.475  1.00 16.73           O  
ATOM   2388  CB  GLN B 106      27.127   8.440   5.350  1.00 14.38           C  
ATOM   2389  CG  GLN B 106      27.619   7.071   4.903  1.00 15.95           C  
ATOM   2390  CD  GLN B 106      27.002   6.649   3.598  1.00 14.91           C  
ATOM   2391  OE1 GLN B 106      25.893   6.106   3.562  1.00 19.91           O  
ATOM   2392  NE2 GLN B 106      27.712   6.918   2.500  1.00 16.94           N  
ATOM   2393  N   ILE B 107      26.343  10.795   7.117  1.00 15.57           N  
ATOM   2394  CA  ILE B 107      25.980  12.204   7.274  1.00 16.77           C  
ATOM   2395  C   ILE B 107      26.776  12.821   8.418  1.00 16.84           C  
ATOM   2396  O   ILE B 107      27.232  13.965   8.326  1.00 17.71           O  
ATOM   2397  CB  ILE B 107      24.474  12.361   7.511  1.00 17.72           C  
ATOM   2398  CG1 ILE B 107      23.713  11.771   6.317  1.00 18.98           C  
ATOM   2399  CG2 ILE B 107      24.137  13.866   7.749  1.00 18.19           C  
ATOM   2400  CD1 ILE B 107      22.205  11.796   6.441  1.00 19.45           C  
ATOM   2401  N   ARG B 108      26.996  12.064   9.488  1.00 17.15           N  
ATOM   2402  CA  ARG B 108      27.765  12.622  10.602  1.00 17.46           C  
ATOM   2403  C   ARG B 108      29.188  12.908  10.143  1.00 18.18           C  
ATOM   2404  O   ARG B 108      29.758  13.944  10.496  1.00 19.96           O  
ATOM   2405  CB  ARG B 108      27.778  11.668  11.794  1.00 17.41           C  
ATOM   2406  CG  ARG B 108      28.302  12.328  13.093  1.00 23.24           C  
ATOM   2407  CD  ARG B 108      28.545  11.281  14.169  1.00 25.87           C  
ATOM   2408  NE  ARG B 108      29.717  10.493  13.814  1.00 27.45           N  
ATOM   2409  CZ  ARG B 108      30.964  10.952  13.896  1.00 30.53           C  
ATOM   2410  NH1 ARG B 108      31.191  12.181  14.339  1.00 26.38           N  
ATOM   2411  NH2 ARG B 108      31.981  10.210  13.479  1.00 30.93           N  
ATOM   2412  N   CYS B 109      29.778  12.002   9.357  1.00 18.60           N  
ATOM   2413  CA  CYS B 109      31.132  12.242   8.857  1.00 16.90           C  
ATOM   2414  C   CYS B 109      31.149  13.476   7.956  1.00 17.67           C  
ATOM   2415  O   CYS B 109      32.099  14.265   7.992  1.00 19.79           O  
ATOM   2416  CB  CYS B 109      31.660  11.024   8.074  1.00 21.64           C  
ATOM   2417  SG  CYS B 109      32.244   9.700   9.141  1.00 27.43           S  
ATOM   2418  N   GLY B 110      30.109  13.644   7.149  1.00 17.73           N  
ATOM   2419  CA  GLY B 110      30.058  14.800   6.267  1.00 20.61           C  
ATOM   2420  C   GLY B 110      30.034  16.091   7.071  1.00 20.81           C  
ATOM   2421  O   GLY B 110      30.580  17.127   6.658  1.00 23.77           O  
ATOM   2422  N   GLY B 111      29.419  16.034   8.240  1.00 19.64           N  
ATOM   2423  CA  GLY B 111      29.362  17.223   9.067  1.00 23.34           C  
ATOM   2424  C   GLY B 111      30.589  17.396   9.937  1.00 26.12           C  
ATOM   2425  O   GLY B 111      30.818  18.474  10.468  1.00 31.00           O  
ATOM   2426  N   ALA B 112      31.391  16.345  10.088  1.00 22.53           N  
ATOM   2427  CA  ALA B 112      32.558  16.433  10.944  1.00 23.20           C  
ATOM   2428  C   ALA B 112      33.882  16.572  10.212  1.00 24.43           C  
ATOM   2429  O   ALA B 112      34.913  16.650  10.851  1.00 26.30           O  
ATOM   2430  CB  ALA B 112      32.616  15.230  11.864  1.00 23.81           C  
ATOM   2431  N   GLY B 113      33.855  16.580   8.888  1.00 26.43           N  
ATOM   2432  CA  GLY B 113      35.091  16.715   8.134  1.00 28.00           C  
ATOM   2433  C   GLY B 113      35.957  15.460   8.117  1.00 30.07           C  
ATOM   2434  O   GLY B 113      37.183  15.544   7.979  1.00 29.41           O  
ATOM   2435  N   LEU B 114      35.335  14.294   8.269  1.00 23.61           N  
ATOM   2436  CA  LEU B 114      36.094  13.046   8.242  1.00 23.49           C  
ATOM   2437  C   LEU B 114      36.009  12.504   6.816  1.00 21.69           C  
ATOM   2438  O   LEU B 114      35.111  12.879   6.071  1.00 19.74           O  
ATOM   2439  CB  LEU B 114      35.520  12.051   9.260  1.00 20.60           C  
ATOM   2440  CG  LEU B 114      35.493  12.611  10.689  1.00 26.81           C  
ATOM   2441  CD1 LEU B 114      34.932  11.558  11.640  1.00 26.43           C  
ATOM   2442  CD2 LEU B 114      36.903  13.031  11.116  1.00 25.30           C  
ATOM   2443  N   GLY B 115      36.951  11.640   6.442  1.00 20.90           N  
ATOM   2444  CA  GLY B 115      36.981  11.096   5.095  1.00 19.79           C  
ATOM   2445  C   GLY B 115      36.201   9.826   4.815  1.00 19.88           C  
ATOM   2446  O   GLY B 115      36.079   9.410   3.659  1.00 19.20           O  
ATOM   2447  N   GLY B 116      35.655   9.225   5.865  1.00 17.57           N  
ATOM   2448  CA  GLY B 116      34.886   8.003   5.732  1.00 18.57           C  
ATOM   2449  C   GLY B 116      35.093   7.162   6.978  1.00 19.36           C  
ATOM   2450  O   GLY B 116      35.780   7.588   7.917  1.00 20.57           O  
ATOM   2451  N   PHE B 117      34.529   5.961   6.991  1.00 17.79           N  
ATOM   2452  CA  PHE B 117      34.653   5.103   8.160  1.00 16.36           C  
ATOM   2453  C   PHE B 117      34.517   3.633   7.806  1.00 17.93           C  
ATOM   2454  O   PHE B 117      34.043   3.283   6.718  1.00 19.63           O  
ATOM   2455  CB  PHE B 117      33.596   5.474   9.206  1.00 18.11           C  
ATOM   2456  CG  PHE B 117      32.173   5.330   8.719  1.00 20.16           C  
ATOM   2457  CD1 PHE B 117      31.583   6.313   7.914  1.00 18.93           C  
ATOM   2458  CD2 PHE B 117      31.430   4.203   9.048  1.00 16.39           C  
ATOM   2459  CE1 PHE B 117      30.266   6.159   7.448  1.00 21.05           C  
ATOM   2460  CE2 PHE B 117      30.118   4.039   8.587  1.00 18.65           C  
ATOM   2461  CZ  PHE B 117      29.538   5.018   7.788  1.00 14.86           C  
ATOM   2462  N   LEU B 118      34.957   2.777   8.725  1.00 17.91           N  
ATOM   2463  CA  LEU B 118      34.881   1.335   8.534  1.00 16.00           C  
ATOM   2464  C   LEU B 118      33.730   0.827   9.382  1.00 14.09           C  
ATOM   2465  O   LEU B 118      33.628   1.141  10.571  1.00 18.37           O  
ATOM   2466  CB  LEU B 118      36.187   0.662   8.971  1.00 19.13           C  
ATOM   2467  CG  LEU B 118      37.461   1.079   8.225  1.00 20.54           C  
ATOM   2468  CD1 LEU B 118      38.669   0.345   8.811  1.00 20.13           C  
ATOM   2469  CD2 LEU B 118      37.298   0.769   6.755  1.00 22.25           C  
ATOM   2470  N   THR B 119      32.860   0.035   8.775  1.00 13.79           N  
ATOM   2471  CA  THR B 119      31.710  -0.495   9.493  1.00 12.29           C  
ATOM   2472  C   THR B 119      31.496  -1.978   9.243  1.00 15.75           C  
ATOM   2473  O   THR B 119      31.840  -2.493   8.186  1.00 16.91           O  
ATOM   2474  CB  THR B 119      30.403   0.219   9.079  1.00 15.02           C  
ATOM   2475  OG1 THR B 119      29.305  -0.380   9.773  1.00 15.70           O  
ATOM   2476  CG2 THR B 119      30.159   0.093   7.582  1.00 15.52           C  
ATOM   2477  N   PRO B 120      30.925  -2.688  10.224  1.00 17.90           N  
ATOM   2478  CA  PRO B 120      30.686  -4.114  10.015  1.00 17.61           C  
ATOM   2479  C   PRO B 120      29.346  -4.266   9.295  1.00 19.26           C  
ATOM   2480  O   PRO B 120      29.023  -5.317   8.729  1.00 14.30           O  
ATOM   2481  CB  PRO B 120      30.626  -4.657  11.442  1.00 18.68           C  
ATOM   2482  CG  PRO B 120      29.922  -3.524  12.187  1.00 21.74           C  
ATOM   2483  CD  PRO B 120      30.648  -2.294  11.623  1.00 19.62           C  
ATOM   2484  N   THR B 121      28.572  -3.188   9.293  1.00 15.18           N  
ATOM   2485  CA  THR B 121      27.243  -3.245   8.706  1.00 15.08           C  
ATOM   2486  C   THR B 121      27.202  -3.480   7.208  1.00 14.81           C  
ATOM   2487  O   THR B 121      27.750  -2.704   6.434  1.00 17.58           O  
ATOM   2488  CB  THR B 121      26.444  -1.974   9.090  1.00 16.66           C  
ATOM   2489  OG1 THR B 121      26.432  -1.854  10.522  1.00 13.91           O  
ATOM   2490  CG2 THR B 121      24.994  -2.093   8.602  1.00 17.28           C  
ATOM   2491  N   GLY B 122      26.560  -4.579   6.817  1.00 15.96           N  
ATOM   2492  CA  GLY B 122      26.439  -4.906   5.404  1.00 17.32           C  
ATOM   2493  C   GLY B 122      27.555  -5.789   4.841  1.00 17.63           C  
ATOM   2494  O   GLY B 122      27.444  -6.245   3.709  1.00 17.60           O  
ATOM   2495  N   VAL B 123      28.624  -6.014   5.607  1.00 17.11           N  
ATOM   2496  CA  VAL B 123      29.732  -6.857   5.144  1.00 18.28           C  
ATOM   2497  C   VAL B 123      29.203  -8.272   4.807  1.00 18.12           C  
ATOM   2498  O   VAL B 123      28.401  -8.850   5.551  1.00 19.53           O  
ATOM   2499  CB  VAL B 123      30.835  -6.973   6.231  1.00 18.90           C  
ATOM   2500  CG1 VAL B 123      31.883  -8.000   5.807  1.00 20.82           C  
ATOM   2501  CG2 VAL B 123      31.502  -5.609   6.461  1.00 14.98           C  
ATOM   2502  N   GLY B 124      29.634  -8.815   3.675  1.00 19.26           N  
ATOM   2503  CA  GLY B 124      29.205 -10.152   3.291  1.00 18.28           C  
ATOM   2504  C   GLY B 124      27.821 -10.213   2.671  1.00 20.04           C  
ATOM   2505  O   GLY B 124      27.304 -11.308   2.448  1.00 20.95           O  
ATOM   2506  N   THR B 125      27.227  -9.048   2.391  1.00 20.85           N  
ATOM   2507  CA  THR B 125      25.892  -8.979   1.784  1.00 19.17           C  
ATOM   2508  C   THR B 125      25.896  -8.057   0.575  1.00 20.45           C  
ATOM   2509  O   THR B 125      26.915  -7.444   0.236  1.00 20.20           O  
ATOM   2510  CB  THR B 125      24.832  -8.399   2.752  1.00 19.15           C  
ATOM   2511  OG1 THR B 125      25.002  -6.975   2.835  1.00 18.71           O  
ATOM   2512  CG2 THR B 125      24.982  -9.016   4.156  1.00 16.29           C  
ATOM   2513  N   VAL B 126      24.734  -7.932  -0.054  1.00 21.42           N  
ATOM   2514  CA  VAL B 126      24.585  -7.064  -1.217  1.00 25.56           C  
ATOM   2515  C   VAL B 126      24.943  -5.580  -0.942  1.00 24.50           C  
ATOM   2516  O   VAL B 126      25.232  -4.818  -1.862  1.00 22.70           O  
ATOM   2517  CB  VAL B 126      23.145  -7.180  -1.779  1.00 27.68           C  
ATOM   2518  CG1 VAL B 126      22.134  -6.905  -0.691  1.00 31.68           C  
ATOM   2519  CG2 VAL B 126      22.960  -6.241  -2.955  1.00 33.80           C  
ATOM   2520  N   VAL B 127      24.951  -5.177   0.323  1.00 24.43           N  
ATOM   2521  CA  VAL B 127      25.295  -3.799   0.681  1.00 22.35           C  
ATOM   2522  C   VAL B 127      26.745  -3.479   0.317  1.00 23.57           C  
ATOM   2523  O   VAL B 127      27.128  -2.316   0.192  1.00 23.15           O  
ATOM   2524  CB  VAL B 127      25.076  -3.569   2.198  1.00 22.51           C  
ATOM   2525  CG1 VAL B 127      25.554  -2.153   2.616  1.00 20.96           C  
ATOM   2526  CG2 VAL B 127      23.590  -3.765   2.521  1.00 19.43           C  
ATOM   2527  N   GLU B 128      27.556  -4.521   0.166  1.00 23.58           N  
ATOM   2528  CA  GLU B 128      28.963  -4.358  -0.190  1.00 27.86           C  
ATOM   2529  C   GLU B 128      29.154  -3.949  -1.640  1.00 30.16           C  
ATOM   2530  O   GLU B 128      30.181  -3.375  -1.996  1.00 29.52           O  
ATOM   2531  CB  GLU B 128      29.713  -5.676  -0.008  1.00 27.45           C  
ATOM   2532  CG  GLU B 128      30.416  -5.830   1.286  1.00 28.93           C  
ATOM   2533  CD  GLU B 128      31.338  -7.030   1.294  1.00 27.20           C  
ATOM   2534  OE1 GLU B 128      32.092  -7.223   0.320  1.00 28.95           O  
ATOM   2535  OE2 GLU B 128      31.318  -7.769   2.287  1.00 29.93           O  
ATOM   2536  N   GLU B 129      28.171  -4.266  -2.476  1.00 32.66           N  
ATOM   2537  CA  GLU B 129      28.279  -3.998  -3.908  1.00 36.15           C  
ATOM   2538  C   GLU B 129      28.802  -2.612  -4.251  1.00 35.56           C  
ATOM   2539  O   GLU B 129      28.231  -1.606  -3.835  1.00 35.11           O  
ATOM   2540  CB  GLU B 129      26.928  -4.248  -4.592  1.00 37.13           C  
ATOM   2541  CG  GLU B 129      27.027  -4.472  -6.098  1.00 46.27           C  
ATOM   2542  CD  GLU B 129      27.923  -5.658  -6.453  1.00 50.05           C  
ATOM   2543  OE1 GLU B 129      27.656  -6.784  -5.971  1.00 50.91           O  
ATOM   2544  OE2 GLU B 129      28.895  -5.460  -7.212  1.00 50.71           O  
ATOM   2545  N   GLY B 130      29.909  -2.571  -4.994  1.00 33.43           N  
ATOM   2546  CA  GLY B 130      30.487  -1.301  -5.406  1.00 33.78           C  
ATOM   2547  C   GLY B 130      31.357  -0.592  -4.376  1.00 35.77           C  
ATOM   2548  O   GLY B 130      31.767   0.550  -4.593  1.00 34.68           O  
ATOM   2549  N   LYS B 131      31.653  -1.256  -3.261  1.00 29.75           N  
ATOM   2550  CA  LYS B 131      32.481  -0.649  -2.232  1.00 29.97           C  
ATOM   2551  C   LYS B 131      33.674  -1.535  -1.922  1.00 31.50           C  
ATOM   2552  O   LYS B 131      33.706  -2.709  -2.301  1.00 34.50           O  
ATOM   2553  CB  LYS B 131      31.665  -0.466  -0.952  1.00 30.10           C  
ATOM   2554  CG  LYS B 131      30.355   0.283  -1.157  1.00 31.49           C  
ATOM   2555  CD  LYS B 131      29.485   0.177   0.092  1.00 28.21           C  
ATOM   2556  CE  LYS B 131      28.109   0.769  -0.146  1.00 29.81           C  
ATOM   2557  NZ  LYS B 131      27.207   0.486   0.996  1.00 24.98           N  
ATOM   2558  N   GLN B 132      34.648  -0.977  -1.223  1.00 29.22           N  
ATOM   2559  CA  GLN B 132      35.810  -1.748  -0.824  1.00 32.99           C  
ATOM   2560  C   GLN B 132      35.696  -2.092   0.650  1.00 33.68           C  
ATOM   2561  O   GLN B 132      35.138  -1.324   1.441  1.00 29.13           O  
ATOM   2562  CB  GLN B 132      37.104  -0.958  -1.026  1.00 36.39           C  
ATOM   2563  CG  GLN B 132      37.522  -0.832  -2.469  1.00 40.74           C  
ATOM   2564  CD  GLN B 132      36.540  -0.007  -3.264  1.00 42.72           C  
ATOM   2565  OE1 GLN B 132      36.383   1.195  -3.025  1.00 44.57           O  
ATOM   2566  NE2 GLN B 132      35.861  -0.648  -4.211  1.00 42.04           N  
ATOM   2567  N   THR B 133      36.217  -3.258   1.002  1.00 30.29           N  
ATOM   2568  CA  THR B 133      36.251  -3.705   2.375  1.00 31.17           C  
ATOM   2569  C   THR B 133      37.724  -3.589   2.750  1.00 32.93           C  
ATOM   2570  O   THR B 133      38.574  -3.353   1.889  1.00 34.32           O  
ATOM   2571  CB  THR B 133      35.837  -5.180   2.501  1.00 33.94           C  
ATOM   2572  OG1 THR B 133      36.771  -5.985   1.769  1.00 30.42           O  
ATOM   2573  CG2 THR B 133      34.419  -5.399   1.963  1.00 30.89           C  
ATOM   2574  N   LEU B 134      38.027  -3.764   4.027  1.00 32.79           N  
ATOM   2575  CA  LEU B 134      39.390  -3.685   4.500  1.00 34.68           C  
ATOM   2576  C   LEU B 134      39.437  -4.604   5.708  1.00 37.79           C  
ATOM   2577  O   LEU B 134      38.521  -4.578   6.533  1.00 33.58           O  
ATOM   2578  CB  LEU B 134      39.715  -2.248   4.903  1.00 38.39           C  
ATOM   2579  CG  LEU B 134      41.190  -1.937   5.163  1.00 43.96           C  
ATOM   2580  CD1 LEU B 134      42.003  -2.194   3.891  1.00 43.25           C  
ATOM   2581  CD2 LEU B 134      41.338  -0.490   5.620  1.00 47.07           C  
ATOM   2582  N   THR B 135      40.475  -5.432   5.813  1.00 36.82           N  
ATOM   2583  CA  THR B 135      40.570  -6.347   6.942  1.00 40.81           C  
ATOM   2584  C   THR B 135      41.563  -5.850   7.967  1.00 43.35           C  
ATOM   2585  O   THR B 135      42.722  -5.606   7.645  1.00 46.98           O  
ATOM   2586  CB  THR B 135      41.002  -7.745   6.506  1.00 43.80           C  
ATOM   2587  OG1 THR B 135      42.204  -7.643   5.733  1.00 52.05           O  
ATOM   2588  CG2 THR B 135      39.913  -8.412   5.686  1.00 40.10           C  
ATOM   2589  N   LEU B 136      41.098  -5.699   9.201  1.00 44.17           N  
ATOM   2590  CA  LEU B 136      41.939  -5.232  10.290  1.00 47.11           C  
ATOM   2591  C   LEU B 136      41.693  -6.066  11.528  1.00 49.57           C  
ATOM   2592  O   LEU B 136      40.546  -6.290  11.913  1.00 48.65           O  
ATOM   2593  CB  LEU B 136      41.632  -3.779  10.637  1.00 47.33           C  
ATOM   2594  CG  LEU B 136      41.862  -2.688   9.601  1.00 50.85           C  
ATOM   2595  CD1 LEU B 136      41.766  -1.351  10.307  1.00 49.44           C  
ATOM   2596  CD2 LEU B 136      43.235  -2.849   8.949  1.00 52.22           C  
ATOM   2597  N   ASP B 137      42.773  -6.518  12.156  1.00 52.77           N  
ATOM   2598  CA  ASP B 137      42.661  -7.308  13.371  1.00 54.57           C  
ATOM   2599  C   ASP B 137      41.826  -8.554  13.102  1.00 53.36           C  
ATOM   2600  O   ASP B 137      41.024  -8.968  13.936  1.00 55.03           O  
ATOM   2601  CB  ASP B 137      42.000  -6.466  14.467  1.00 57.28           C  
ATOM   2602  CG  ASP B 137      42.659  -5.103  14.633  1.00 61.97           C  
ATOM   2603  OD1 ASP B 137      42.095  -4.257  15.363  1.00 62.45           O  
ATOM   2604  OD2 ASP B 137      43.741  -4.880  14.039  1.00 63.05           O  
ATOM   2605  N   GLY B 138      42.013  -9.145  11.928  1.00 53.31           N  
ATOM   2606  CA  GLY B 138      41.264 -10.339  11.587  1.00 52.63           C  
ATOM   2607  C   GLY B 138      39.815 -10.089  11.194  1.00 51.92           C  
ATOM   2608  O   GLY B 138      39.138 -11.014  10.731  1.00 53.59           O  
ATOM   2609  N   LYS B 139      39.326  -8.862  11.373  1.00 46.01           N  
ATOM   2610  CA  LYS B 139      37.944  -8.549  11.005  1.00 42.61           C  
ATOM   2611  C   LYS B 139      37.866  -7.783   9.684  1.00 36.61           C  
ATOM   2612  O   LYS B 139      38.719  -6.945   9.403  1.00 34.67           O  
ATOM   2613  CB  LYS B 139      37.279  -7.714  12.092  1.00 45.41           C  
ATOM   2614  CG  LYS B 139      37.335  -8.324  13.476  1.00 52.93           C  
ATOM   2615  CD  LYS B 139      36.652  -7.408  14.480  1.00 56.33           C  
ATOM   2616  CE  LYS B 139      35.156  -7.315  14.206  1.00 57.77           C  
ATOM   2617  NZ  LYS B 139      34.472  -8.611  14.494  1.00 60.36           N  
ATOM   2618  N   THR B 140      36.844  -8.081   8.881  1.00 34.04           N  
ATOM   2619  CA  THR B 140      36.626  -7.411   7.602  1.00 27.68           C  
ATOM   2620  C   THR B 140      35.537  -6.340   7.765  1.00 29.51           C  
ATOM   2621  O   THR B 140      34.421  -6.617   8.248  1.00 21.13           O  
ATOM   2622  CB  THR B 140      36.203  -8.399   6.511  1.00 30.16           C  
ATOM   2623  OG1 THR B 140      37.249  -9.354   6.322  1.00 33.86           O  
ATOM   2624  CG2 THR B 140      35.955  -7.673   5.192  1.00 26.33           C  
ATOM   2625  N   TRP B 141      35.877  -5.125   7.339  1.00 25.90           N  
ATOM   2626  CA  TRP B 141      34.998  -3.969   7.463  1.00 26.02           C  
ATOM   2627  C   TRP B 141      34.731  -3.318   6.122  1.00 22.41           C  
ATOM   2628  O   TRP B 141      35.588  -3.318   5.239  1.00 19.74           O  
ATOM   2629  CB  TRP B 141      35.641  -2.904   8.362  1.00 25.12           C  
ATOM   2630  CG  TRP B 141      36.248  -3.400   9.638  1.00 24.44           C  
ATOM   2631  CD1 TRP B 141      37.497  -3.918   9.802  1.00 27.13           C  
ATOM   2632  CD2 TRP B 141      35.652  -3.366  10.937  1.00 26.58           C  
ATOM   2633  NE1 TRP B 141      37.725  -4.199  11.126  1.00 27.46           N  
ATOM   2634  CE2 TRP B 141      36.608  -3.871  11.847  1.00 27.91           C  
ATOM   2635  CE3 TRP B 141      34.405  -2.952  11.424  1.00 24.50           C  
ATOM   2636  CZ2 TRP B 141      36.356  -3.976  13.219  1.00 29.57           C  
ATOM   2637  CZ3 TRP B 141      34.154  -3.057  12.787  1.00 29.80           C  
ATOM   2638  CH2 TRP B 141      35.129  -3.565  13.669  1.00 27.59           C  
ATOM   2639  N   LEU B 142      33.550  -2.722   5.997  1.00 20.02           N  
ATOM   2640  CA  LEU B 142      33.165  -2.026   4.786  1.00 18.73           C  
ATOM   2641  C   LEU B 142      33.598  -0.556   4.900  1.00 20.93           C  
ATOM   2642  O   LEU B 142      33.443   0.067   5.951  1.00 22.75           O  
ATOM   2643  CB  LEU B 142      31.655  -2.130   4.638  1.00 21.25           C  
ATOM   2644  CG  LEU B 142      30.966  -2.055   3.286  1.00 27.75           C  
ATOM   2645  CD1 LEU B 142      31.767  -2.806   2.229  1.00 22.83           C  
ATOM   2646  CD2 LEU B 142      29.561  -2.627   3.452  1.00 20.58           C  
ATOM   2647  N   LEU B 143      34.155  -0.002   3.834  1.00 19.73           N  
ATOM   2648  CA  LEU B 143      34.578   1.393   3.858  1.00 20.22           C  
ATOM   2649  C   LEU B 143      33.466   2.265   3.280  1.00 21.53           C  
ATOM   2650  O   LEU B 143      33.143   2.146   2.093  1.00 23.84           O  
ATOM   2651  CB  LEU B 143      35.849   1.572   3.035  1.00 22.88           C  
ATOM   2652  CG  LEU B 143      36.300   3.024   2.867  1.00 23.48           C  
ATOM   2653  CD1 LEU B 143      36.515   3.673   4.239  1.00 21.54           C  
ATOM   2654  CD2 LEU B 143      37.572   3.062   2.032  1.00 22.47           C  
ATOM   2655  N   GLU B 144      32.888   3.142   4.111  1.00 17.81           N  
ATOM   2656  CA  GLU B 144      31.789   4.020   3.675  1.00 18.78           C  
ATOM   2657  C   GLU B 144      32.263   5.470   3.641  1.00 19.21           C  
ATOM   2658  O   GLU B 144      33.077   5.884   4.472  1.00 20.07           O  
ATOM   2659  CB  GLU B 144      30.580   3.878   4.612  1.00 16.78           C  
ATOM   2660  CG  GLU B 144      29.941   2.466   4.637  1.00 18.49           C  
ATOM   2661  CD  GLU B 144      28.993   2.203   3.461  1.00 21.40           C  
ATOM   2662  OE1 GLU B 144      28.841   3.100   2.592  1.00 21.43           O  
ATOM   2663  OE2 GLU B 144      28.388   1.105   3.415  1.00 20.47           O  
ATOM   2664  N   ARG B 145      31.753   6.243   2.680  1.00 18.12           N  
ATOM   2665  CA  ARG B 145      32.175   7.624   2.524  1.00 16.66           C  
ATOM   2666  C   ARG B 145      31.203   8.629   3.155  1.00 19.79           C  
ATOM   2667  O   ARG B 145      30.037   8.322   3.366  1.00 17.60           O  
ATOM   2668  CB  ARG B 145      32.332   7.942   1.040  1.00 21.40           C  
ATOM   2669  CG  ARG B 145      33.378   7.099   0.300  1.00 29.68           C  
ATOM   2670  CD  ARG B 145      33.560   7.628  -1.121  1.00 42.01           C  
ATOM   2671  NE  ARG B 145      34.786   7.136  -1.751  1.00 48.35           N  
ATOM   2672  CZ  ARG B 145      34.955   5.898  -2.204  1.00 50.73           C  
ATOM   2673  NH1 ARG B 145      33.976   5.009  -2.109  1.00 50.03           N  
ATOM   2674  NH2 ARG B 145      36.116   5.546  -2.744  1.00 55.83           N  
ATOM   2675  N   PRO B 146      31.683   9.847   3.448  1.00 21.26           N  
ATOM   2676  CA  PRO B 146      30.822  10.872   4.055  1.00 18.14           C  
ATOM   2677  C   PRO B 146      29.792  11.384   3.064  1.00 21.96           C  
ATOM   2678  O   PRO B 146      29.973  11.244   1.849  1.00 19.83           O  
ATOM   2679  CB  PRO B 146      31.811  11.957   4.468  1.00 20.41           C  
ATOM   2680  CG  PRO B 146      32.888  11.856   3.444  1.00 25.16           C  
ATOM   2681  CD  PRO B 146      33.056  10.355   3.251  1.00 21.69           C  
ATOM   2682  N   LEU B 147      28.706  11.960   3.584  1.00 19.38           N  
ATOM   2683  CA  LEU B 147      27.654  12.528   2.750  1.00 20.97           C  
ATOM   2684  C   LEU B 147      27.416  13.970   3.172  1.00 22.36           C  
ATOM   2685  O   LEU B 147      27.341  14.256   4.363  1.00 18.76           O  
ATOM   2686  CB  LEU B 147      26.335  11.789   2.937  1.00 22.17           C  
ATOM   2687  CG  LEU B 147      26.077  10.555   2.103  1.00 26.16           C  
ATOM   2688  CD1 LEU B 147      24.792   9.909   2.561  1.00 29.36           C  
ATOM   2689  CD2 LEU B 147      26.016  10.944   0.629  1.00 28.72           C  
ATOM   2690  N   ARG B 148      27.333  14.871   2.201  1.00 23.56           N  
ATOM   2691  CA  ARG B 148      27.029  16.275   2.469  1.00 21.85           C  
ATOM   2692  C   ARG B 148      25.983  16.675   1.431  1.00 23.11           C  
ATOM   2693  O   ARG B 148      25.693  15.911   0.509  1.00 24.31           O  
ATOM   2694  CB  ARG B 148      28.268  17.170   2.340  1.00 23.12           C  
ATOM   2695  CG  ARG B 148      29.237  17.097   3.509  1.00 22.37           C  
ATOM   2696  CD  ARG B 148      30.316  18.158   3.386  1.00 26.17           C  
ATOM   2697  NE  ARG B 148      29.742  19.509   3.392  1.00 28.61           N  
ATOM   2698  CZ  ARG B 148      29.296  20.143   4.475  1.00 32.12           C  
ATOM   2699  NH1 ARG B 148      29.349  19.557   5.673  1.00 29.01           N  
ATOM   2700  NH2 ARG B 148      28.796  21.372   4.359  1.00 28.90           N  
ATOM   2701  N   ALA B 149      25.391  17.853   1.583  1.00 22.48           N  
ATOM   2702  CA  ALA B 149      24.391  18.303   0.625  1.00 22.31           C  
ATOM   2703  C   ALA B 149      24.557  19.791   0.430  1.00 19.87           C  
ATOM   2704  O   ALA B 149      25.268  20.442   1.189  1.00 20.77           O  
ATOM   2705  CB  ALA B 149      22.980  17.989   1.139  1.00 21.97           C  
ATOM   2706  N   ASP B 150      23.924  20.318  -0.612  1.00 23.81           N  
ATOM   2707  CA  ASP B 150      23.983  21.754  -0.894  1.00 20.77           C  
ATOM   2708  C   ASP B 150      23.092  22.484   0.109  1.00 21.76           C  
ATOM   2709  O   ASP B 150      23.396  23.590   0.551  1.00 22.01           O  
ATOM   2710  CB  ASP B 150      23.429  22.026  -2.287  1.00 21.76           C  
ATOM   2711  CG  ASP B 150      24.286  21.431  -3.375  1.00 20.33           C  
ATOM   2712  OD1 ASP B 150      25.486  21.744  -3.384  1.00 27.67           O  
ATOM   2713  OD2 ASP B 150      23.754  20.662  -4.200  1.00 22.77           O  
ATOM   2714  N   LEU B 151      22.004  21.820   0.478  1.00 20.49           N  
ATOM   2715  CA  LEU B 151      21.004  22.418   1.361  1.00 23.75           C  
ATOM   2716  C   LEU B 151      20.350  21.418   2.327  1.00 22.64           C  
ATOM   2717  O   LEU B 151      20.184  20.243   2.007  1.00 20.84           O  
ATOM   2718  CB  LEU B 151      19.917  23.027   0.464  1.00 23.95           C  
ATOM   2719  CG  LEU B 151      18.697  23.785   0.996  1.00 25.00           C  
ATOM   2720  CD1 LEU B 151      19.111  25.131   1.559  1.00 25.00           C  
ATOM   2721  CD2 LEU B 151      17.726  23.995  -0.163  1.00 29.98           C  
ATOM   2722  N   ALA B 152      19.977  21.900   3.506  1.00 20.47           N  
ATOM   2723  CA  ALA B 152      19.277  21.067   4.466  1.00 18.93           C  
ATOM   2724  C   ALA B 152      18.004  21.809   4.891  1.00 19.03           C  
ATOM   2725  O   ALA B 152      18.058  22.997   5.216  1.00 23.38           O  
ATOM   2726  CB  ALA B 152      20.163  20.779   5.700  1.00 17.56           C  
ATOM   2727  N   LEU B 153      16.876  21.107   4.860  1.00 17.71           N  
ATOM   2728  CA  LEU B 153      15.590  21.640   5.275  1.00 17.11           C  
ATOM   2729  C   LEU B 153      15.348  20.996   6.649  1.00 21.03           C  
ATOM   2730  O   LEU B 153      15.173  19.772   6.755  1.00 17.15           O  
ATOM   2731  CB  LEU B 153      14.508  21.246   4.275  1.00 17.66           C  
ATOM   2732  CG  LEU B 153      14.765  21.660   2.811  1.00 17.73           C  
ATOM   2733  CD1 LEU B 153      13.540  21.334   1.989  1.00 21.73           C  
ATOM   2734  CD2 LEU B 153      15.113  23.130   2.721  1.00 18.84           C  
ATOM   2735  N   ILE B 154      15.332  21.834   7.686  1.00 19.11           N  
ATOM   2736  CA  ILE B 154      15.221  21.374   9.076  1.00 19.24           C  
ATOM   2737  C   ILE B 154      13.975  21.819   9.827  1.00 21.29           C  
ATOM   2738  O   ILE B 154      13.566  22.982   9.716  1.00 17.37           O  
ATOM   2739  CB  ILE B 154      16.430  21.908   9.874  1.00 18.54           C  
ATOM   2740  CG1 ILE B 154      17.726  21.408   9.236  1.00 21.22           C  
ATOM   2741  CG2 ILE B 154      16.323  21.543  11.371  1.00 19.02           C  
ATOM   2742  CD1 ILE B 154      18.857  22.397   9.401  1.00 24.15           C  
ATOM   2743  N   ARG B 155      13.375  20.892  10.578  1.00 19.08           N  
ATOM   2744  CA  ARG B 155      12.237  21.241  11.414  1.00 21.28           C  
ATOM   2745  C   ARG B 155      12.812  21.230  12.818  1.00 22.56           C  
ATOM   2746  O   ARG B 155      13.520  20.287  13.189  1.00 17.90           O  
ATOM   2747  CB  ARG B 155      11.098  20.216  11.365  1.00 20.56           C  
ATOM   2748  CG  ARG B 155       9.962  20.617  12.357  1.00 25.83           C  
ATOM   2749  CD  ARG B 155       8.751  19.698  12.394  1.00 30.61           C  
ATOM   2750  NE  ARG B 155       7.759  20.176  13.364  1.00 30.49           N  
ATOM   2751  CZ  ARG B 155       6.818  19.416  13.926  1.00 33.09           C  
ATOM   2752  NH1 ARG B 155       6.722  18.124  13.625  1.00 34.46           N  
ATOM   2753  NH2 ARG B 155       5.974  19.940  14.805  1.00 32.41           N  
ATOM   2754  N   ALA B 156      12.523  22.277  13.584  1.00 18.71           N  
ATOM   2755  CA  ALA B 156      12.978  22.387  14.960  1.00 20.98           C  
ATOM   2756  C   ALA B 156      11.770  22.728  15.830  1.00 23.26           C  
ATOM   2757  O   ALA B 156      10.758  23.231  15.327  1.00 21.71           O  
ATOM   2758  CB  ALA B 156      14.025  23.489  15.081  1.00 22.33           C  
ATOM   2759  N   HIS B 157      11.876  22.450  17.126  1.00 21.75           N  
ATOM   2760  CA  HIS B 157      10.790  22.753  18.057  1.00 22.07           C  
ATOM   2761  C   HIS B 157      10.922  24.228  18.435  1.00 22.32           C  
ATOM   2762  O   HIS B 157      10.068  25.034  18.093  1.00 25.58           O  
ATOM   2763  CB  HIS B 157      10.904  21.890  19.315  1.00 25.75           C  
ATOM   2764  CG  HIS B 157       9.800  22.122  20.294  1.00 30.08           C  
ATOM   2765  ND1 HIS B 157       9.995  22.093  21.659  1.00 30.78           N  
ATOM   2766  CD2 HIS B 157       8.482  22.376  20.106  1.00 28.76           C  
ATOM   2767  CE1 HIS B 157       8.845  22.320  22.268  1.00 32.83           C  
ATOM   2768  NE2 HIS B 157       7.913  22.496  21.349  1.00 30.58           N  
ATOM   2769  N   ARG B 158      11.996  24.575  19.138  1.00 19.05           N  
ATOM   2770  CA  ARG B 158      12.237  25.964  19.509  1.00 23.53           C  
ATOM   2771  C   ARG B 158      13.525  26.463  18.851  1.00 27.05           C  
ATOM   2772  O   ARG B 158      14.504  25.719  18.695  1.00 24.34           O  
ATOM   2773  CB  ARG B 158      12.300  26.115  21.035  1.00 25.68           C  
ATOM   2774  CG  ARG B 158      10.929  25.936  21.696  1.00 31.80           C  
ATOM   2775  CD  ARG B 158      10.992  25.772  23.226  1.00 37.78           C  
ATOM   2776  NE  ARG B 158      11.422  26.967  23.948  1.00 41.50           N  
ATOM   2777  CZ  ARG B 158      10.682  28.065  24.114  1.00 46.30           C  
ATOM   2778  NH1 ARG B 158       9.456  28.139  23.607  1.00 46.93           N  
ATOM   2779  NH2 ARG B 158      11.168  29.096  24.797  1.00 43.28           N  
ATOM   2780  N   CYS B 159      13.510  27.732  18.455  1.00 21.20           N  
ATOM   2781  CA  CYS B 159      14.637  28.346  17.778  1.00 23.56           C  
ATOM   2782  C   CYS B 159      14.759  29.794  18.235  1.00 24.89           C  
ATOM   2783  O   CYS B 159      13.754  30.495  18.289  1.00 28.87           O  
ATOM   2784  CB  CYS B 159      14.367  28.297  16.266  1.00 22.37           C  
ATOM   2785  SG  CYS B 159      15.573  29.112  15.173  1.00 24.62           S  
ATOM   2786  N   ASP B 160      15.959  30.258  18.575  1.00 25.50           N  
ATOM   2787  CA  ASP B 160      16.055  31.659  18.952  1.00 21.20           C  
ATOM   2788  C   ASP B 160      16.460  32.454  17.714  1.00 23.60           C  
ATOM   2789  O   ASP B 160      16.692  31.885  16.634  1.00 21.77           O  
ATOM   2790  CB  ASP B 160      16.994  31.890  20.148  1.00 24.38           C  
ATOM   2791  CG  ASP B 160      18.442  31.571  19.857  1.00 26.46           C  
ATOM   2792  OD1 ASP B 160      18.823  31.455  18.674  1.00 28.33           O  
ATOM   2793  OD2 ASP B 160      19.205  31.456  20.839  1.00 25.56           O  
ATOM   2794  N   THR B 161      16.538  33.767  17.841  1.00 24.75           N  
ATOM   2795  CA  THR B 161      16.844  34.588  16.677  1.00 27.59           C  
ATOM   2796  C   THR B 161      18.231  34.392  16.072  1.00 28.84           C  
ATOM   2797  O   THR B 161      18.488  34.823  14.945  1.00 31.29           O  
ATOM   2798  CB  THR B 161      16.578  36.072  17.008  1.00 28.98           C  
ATOM   2799  OG1 THR B 161      17.285  36.440  18.199  1.00 31.75           O  
ATOM   2800  CG2 THR B 161      15.083  36.271  17.261  1.00 29.22           C  
ATOM   2801  N   LEU B 162      19.116  33.722  16.801  1.00 28.81           N  
ATOM   2802  CA  LEU B 162      20.460  33.453  16.298  1.00 30.55           C  
ATOM   2803  C   LEU B 162      20.535  32.077  15.639  1.00 28.36           C  
ATOM   2804  O   LEU B 162      21.558  31.710  15.059  1.00 31.24           O  
ATOM   2805  CB  LEU B 162      21.483  33.521  17.434  1.00 34.19           C  
ATOM   2806  CG  LEU B 162      21.819  34.897  18.008  1.00 39.50           C  
ATOM   2807  CD1 LEU B 162      22.743  34.739  19.220  1.00 39.86           C  
ATOM   2808  CD2 LEU B 162      22.484  35.743  16.930  1.00 40.04           C  
ATOM   2809  N   GLY B 163      19.463  31.304  15.736  1.00 24.09           N  
ATOM   2810  CA  GLY B 163      19.483  29.985  15.131  1.00 24.10           C  
ATOM   2811  C   GLY B 163      19.790  28.825  16.066  1.00 22.25           C  
ATOM   2812  O   GLY B 163      19.968  27.701  15.602  1.00 25.42           O  
ATOM   2813  N   ASN B 164      19.884  29.079  17.370  1.00 23.20           N  
ATOM   2814  CA  ASN B 164      20.101  27.996  18.336  1.00 23.13           C  
ATOM   2815  C   ASN B 164      18.807  27.179  18.324  1.00 23.79           C  
ATOM   2816  O   ASN B 164      17.726  27.766  18.374  1.00 22.62           O  
ATOM   2817  CB  ASN B 164      20.334  28.560  19.743  1.00 22.72           C  
ATOM   2818  CG  ASN B 164      21.665  29.248  19.876  1.00 27.08           C  
ATOM   2819  OD1 ASN B 164      22.705  28.661  19.566  1.00 26.35           O  
ATOM   2820  ND2 ASN B 164      21.652  30.500  20.336  1.00 22.83           N  
ATOM   2821  N   LEU B 165      18.901  25.843  18.286  1.00 17.23           N  
ATOM   2822  CA  LEU B 165      17.711  24.988  18.206  1.00 18.40           C  
ATOM   2823  C   LEU B 165      17.546  23.884  19.253  1.00 19.79           C  
ATOM   2824  O   LEU B 165      18.532  23.334  19.746  1.00 23.30           O  
ATOM   2825  CB  LEU B 165      17.657  24.297  16.832  1.00 18.78           C  
ATOM   2826  CG  LEU B 165      18.025  25.051  15.547  1.00 21.34           C  
ATOM   2827  CD1 LEU B 165      18.054  24.044  14.377  1.00 20.22           C  
ATOM   2828  CD2 LEU B 165      17.004  26.178  15.270  1.00 17.21           C  
ATOM   2829  N   THR B 166      16.291  23.558  19.573  1.00 20.76           N  
ATOM   2830  CA  THR B 166      15.957  22.451  20.477  1.00 20.58           C  
ATOM   2831  C   THR B 166      14.945  21.642  19.699  1.00 21.28           C  
ATOM   2832  O   THR B 166      14.355  22.143  18.740  1.00 24.12           O  
ATOM   2833  CB  THR B 166      15.276  22.879  21.815  1.00 25.68           C  
ATOM   2834  OG1 THR B 166      13.966  23.392  21.541  1.00 25.19           O  
ATOM   2835  CG2 THR B 166      16.121  23.910  22.548  1.00 22.15           C  
ATOM   2836  N   TYR B 167      14.717  20.401  20.107  1.00 17.18           N  
ATOM   2837  CA  TYR B 167      13.789  19.545  19.387  1.00 18.02           C  
ATOM   2838  C   TYR B 167      12.915  18.766  20.339  1.00 19.07           C  
ATOM   2839  O   TYR B 167      13.241  18.638  21.522  1.00 23.57           O  
ATOM   2840  CB  TYR B 167      14.582  18.524  18.546  1.00 19.11           C  
ATOM   2841  CG  TYR B 167      15.597  19.136  17.608  1.00 17.97           C  
ATOM   2842  CD1 TYR B 167      15.243  19.474  16.306  1.00 16.56           C  
ATOM   2843  CD2 TYR B 167      16.918  19.357  18.018  1.00 16.31           C  
ATOM   2844  CE1 TYR B 167      16.161  20.009  15.426  1.00 19.81           C  
ATOM   2845  CE2 TYR B 167      17.864  19.894  17.139  1.00 16.25           C  
ATOM   2846  CZ  TYR B 167      17.473  20.220  15.841  1.00 20.16           C  
ATOM   2847  OH  TYR B 167      18.386  20.747  14.943  1.00 20.62           O  
ATOM   2848  N   GLN B 168      11.798  18.264  19.819  1.00 20.74           N  
ATOM   2849  CA  GLN B 168      10.910  17.405  20.588  1.00 19.99           C  
ATOM   2850  C   GLN B 168      11.454  16.043  20.197  1.00 23.82           C  
ATOM   2851  O   GLN B 168      11.770  15.814  19.020  1.00 22.81           O  
ATOM   2852  CB  GLN B 168       9.463  17.513  20.114  1.00 20.80           C  
ATOM   2853  CG  GLN B 168       8.728  18.705  20.699  1.00 28.37           C  
ATOM   2854  CD  GLN B 168       7.293  18.769  20.232  1.00 30.50           C  
ATOM   2855  OE1 GLN B 168       7.015  18.740  19.029  1.00 32.88           O  
ATOM   2856  NE2 GLN B 168       6.367  18.856  21.176  1.00 27.85           N  
ATOM   2857  N   LEU B 169      11.585  15.154  21.172  1.00 21.38           N  
ATOM   2858  CA  LEU B 169      12.101  13.818  20.919  1.00 21.65           C  
ATOM   2859  C   LEU B 169      11.387  13.115  19.775  1.00 22.59           C  
ATOM   2860  O   LEU B 169      12.033  12.552  18.894  1.00 23.73           O  
ATOM   2861  CB  LEU B 169      11.999  12.975  22.198  1.00 22.72           C  
ATOM   2862  CG  LEU B 169      12.418  11.504  22.154  1.00 27.20           C  
ATOM   2863  CD1 LEU B 169      13.822  11.330  21.544  1.00 26.71           C  
ATOM   2864  CD2 LEU B 169      12.362  10.968  23.582  1.00 28.96           C  
ATOM   2865  N   SER B 170      10.061  13.167  19.760  1.00 24.33           N  
ATOM   2866  CA  SER B 170       9.297  12.473  18.718  1.00 26.58           C  
ATOM   2867  C   SER B 170       9.441  12.994  17.292  1.00 27.60           C  
ATOM   2868  O   SER B 170       9.029  12.318  16.356  1.00 29.40           O  
ATOM   2869  CB  SER B 170       7.807  12.443  19.081  1.00 31.28           C  
ATOM   2870  OG  SER B 170       7.267  13.750  19.171  1.00 32.31           O  
ATOM   2871  N   ALA B 171      10.032  14.177  17.131  1.00 24.64           N  
ATOM   2872  CA  ALA B 171      10.206  14.785  15.817  1.00 25.34           C  
ATOM   2873  C   ALA B 171      11.659  15.112  15.499  1.00 23.62           C  
ATOM   2874  O   ALA B 171      11.964  15.684  14.446  1.00 24.80           O  
ATOM   2875  CB  ALA B 171       9.362  16.067  15.731  1.00 22.66           C  
ATOM   2876  N   ARG B 172      12.562  14.720  16.389  1.00 21.94           N  
ATOM   2877  CA  ARG B 172      13.965  15.058  16.221  1.00 20.80           C  
ATOM   2878  C   ARG B 172      14.675  14.370  15.059  1.00 22.27           C  
ATOM   2879  O   ARG B 172      15.175  15.032  14.142  1.00 20.58           O  
ATOM   2880  CB  ARG B 172      14.694  14.772  17.534  1.00 21.61           C  
ATOM   2881  CG  ARG B 172      16.128  15.242  17.575  1.00 26.61           C  
ATOM   2882  CD  ARG B 172      16.692  14.971  18.974  1.00 32.27           C  
ATOM   2883  NE  ARG B 172      18.134  14.829  18.949  1.00 36.92           N  
ATOM   2884  CZ  ARG B 172      18.927  15.081  19.985  1.00 44.26           C  
ATOM   2885  NH1 ARG B 172      18.399  15.489  21.135  1.00 43.69           N  
ATOM   2886  NH2 ARG B 172      20.248  14.944  19.857  1.00 39.94           N  
ATOM   2887  N   ASN B 173      14.700  13.044  15.106  1.00 23.05           N  
ATOM   2888  CA  ASN B 173      15.350  12.208  14.101  1.00 22.54           C  
ATOM   2889  C   ASN B 173      16.585  12.802  13.410  1.00 20.22           C  
ATOM   2890  O   ASN B 173      17.550  13.125  14.087  1.00 18.94           O  
ATOM   2891  CB  ASN B 173      14.320  11.674  13.082  1.00 23.48           C  
ATOM   2892  CG  ASN B 173      13.490  12.766  12.441  1.00 25.78           C  
ATOM   2893  OD1 ASN B 173      13.890  13.346  11.438  1.00 24.83           O  
ATOM   2894  ND2 ASN B 173      12.319  13.051  13.020  1.00 25.97           N  
ATOM   2895  N   PHE B 174      16.559  12.936  12.083  1.00 17.17           N  
ATOM   2896  CA  PHE B 174      17.699  13.436  11.308  1.00 18.42           C  
ATOM   2897  C   PHE B 174      17.956  14.940  11.346  1.00 18.75           C  
ATOM   2898  O   PHE B 174      18.999  15.405  10.904  1.00 17.18           O  
ATOM   2899  CB  PHE B 174      17.539  13.043   9.828  1.00 18.90           C  
ATOM   2900  CG  PHE B 174      18.000  11.639   9.492  1.00 20.99           C  
ATOM   2901  CD1 PHE B 174      17.835  10.590  10.390  1.00 22.95           C  
ATOM   2902  CD2 PHE B 174      18.572  11.366   8.247  1.00 24.46           C  
ATOM   2903  CE1 PHE B 174      18.235   9.289  10.059  1.00 25.90           C  
ATOM   2904  CE2 PHE B 174      18.979  10.063   7.906  1.00 23.52           C  
ATOM   2905  CZ  PHE B 174      18.808   9.031   8.813  1.00 23.70           C  
ATOM   2906  N   ASN B 175      17.012  15.706  11.866  1.00 21.76           N  
ATOM   2907  CA  ASN B 175      17.170  17.152  11.869  1.00 20.76           C  
ATOM   2908  C   ASN B 175      18.497  17.686  12.392  1.00 20.13           C  
ATOM   2909  O   ASN B 175      19.183  18.419  11.682  1.00 18.51           O  
ATOM   2910  CB  ASN B 175      15.958  17.785  12.572  1.00 19.13           C  
ATOM   2911  CG  ASN B 175      14.694  17.664  11.733  1.00 21.18           C  
ATOM   2912  OD1 ASN B 175      14.597  18.280  10.670  1.00 22.30           O  
ATOM   2913  ND2 ASN B 175      13.734  16.858  12.191  1.00 16.46           N  
ATOM   2914  N   PRO B 176      18.898  17.328  13.627  1.00 21.11           N  
ATOM   2915  CA  PRO B 176      20.187  17.870  14.078  1.00 20.76           C  
ATOM   2916  C   PRO B 176      21.397  17.343  13.286  1.00 20.68           C  
ATOM   2917  O   PRO B 176      22.415  18.023  13.150  1.00 20.86           O  
ATOM   2918  CB  PRO B 176      20.243  17.473  15.562  1.00 19.05           C  
ATOM   2919  CG  PRO B 176      19.371  16.246  15.637  1.00 20.17           C  
ATOM   2920  CD  PRO B 176      18.217  16.588  14.706  1.00 18.11           C  
ATOM   2921  N   LEU B 177      21.269  16.124  12.781  1.00 18.13           N  
ATOM   2922  CA  LEU B 177      22.326  15.487  11.994  1.00 19.60           C  
ATOM   2923  C   LEU B 177      22.576  16.243  10.672  1.00 20.50           C  
ATOM   2924  O   LEU B 177      23.701  16.649  10.381  1.00 21.17           O  
ATOM   2925  CB  LEU B 177      21.902  14.055  11.705  1.00 22.39           C  
ATOM   2926  CG  LEU B 177      22.849  13.042  11.067  1.00 29.11           C  
ATOM   2927  CD1 LEU B 177      24.025  12.767  12.005  1.00 28.18           C  
ATOM   2928  CD2 LEU B 177      22.070  11.757  10.796  1.00 28.23           C  
ATOM   2929  N   ILE B 178      21.526  16.455   9.882  1.00 18.38           N  
ATOM   2930  CA  ILE B 178      21.700  17.149   8.599  1.00 18.41           C  
ATOM   2931  C   ILE B 178      22.083  18.626   8.745  1.00 20.82           C  
ATOM   2932  O   ILE B 178      22.709  19.220   7.859  1.00 20.89           O  
ATOM   2933  CB  ILE B 178      20.438  17.025   7.722  1.00 19.09           C  
ATOM   2934  CG1 ILE B 178      19.272  17.816   8.339  1.00 19.31           C  
ATOM   2935  CG2 ILE B 178      20.096  15.548   7.545  1.00 17.71           C  
ATOM   2936  CD1 ILE B 178      17.919  17.681   7.584  1.00 20.86           C  
ATOM   2937  N   ALA B 179      21.735  19.220   9.875  1.00 20.42           N  
ATOM   2938  CA  ALA B 179      22.081  20.620  10.095  1.00 22.85           C  
ATOM   2939  C   ALA B 179      23.585  20.860   9.992  1.00 23.83           C  
ATOM   2940  O   ALA B 179      24.016  21.954   9.641  1.00 24.70           O  
ATOM   2941  CB  ALA B 179      21.579  21.063  11.457  1.00 21.70           C  
ATOM   2942  N   LEU B 180      24.391  19.838  10.279  1.00 21.66           N  
ATOM   2943  CA  LEU B 180      25.852  19.992  10.251  1.00 19.96           C  
ATOM   2944  C   LEU B 180      26.519  19.582   8.930  1.00 22.98           C  
ATOM   2945  O   LEU B 180      27.688  19.887   8.701  1.00 23.45           O  
ATOM   2946  CB  LEU B 180      26.467  19.139  11.368  1.00 24.18           C  
ATOM   2947  CG  LEU B 180      25.947  19.355  12.792  1.00 28.64           C  
ATOM   2948  CD1 LEU B 180      26.418  18.231  13.710  1.00 29.70           C  
ATOM   2949  CD2 LEU B 180      26.435  20.703  13.290  1.00 24.73           C  
ATOM   2950  N   ALA B 181      25.768  18.912   8.068  1.00 19.96           N  
ATOM   2951  CA  ALA B 181      26.308  18.370   6.821  1.00 24.02           C  
ATOM   2952  C   ALA B 181      25.910  19.053   5.518  1.00 23.82           C  
ATOM   2953  O   ALA B 181      26.098  18.478   4.435  1.00 22.40           O  
ATOM   2954  CB  ALA B 181      25.942  16.876   6.739  1.00 21.92           C  
ATOM   2955  N   ALA B 182      25.379  20.271   5.599  1.00 22.48           N  
ATOM   2956  CA  ALA B 182      24.943  20.959   4.385  1.00 21.79           C  
ATOM   2957  C   ALA B 182      25.573  22.340   4.283  1.00 22.37           C  
ATOM   2958  O   ALA B 182      25.894  22.961   5.300  1.00 24.97           O  
ATOM   2959  CB  ALA B 182      23.414  21.057   4.358  1.00 22.13           C  
ATOM   2960  N   ASP B 183      25.768  22.807   3.055  1.00 24.86           N  
ATOM   2961  CA  ASP B 183      26.385  24.108   2.841  1.00 26.52           C  
ATOM   2962  C   ASP B 183      25.481  25.241   3.319  1.00 22.81           C  
ATOM   2963  O   ASP B 183      25.961  26.221   3.889  1.00 26.79           O  
ATOM   2964  CB  ASP B 183      26.748  24.291   1.362  1.00 27.45           C  
ATOM   2965  CG  ASP B 183      27.808  23.294   0.891  1.00 31.70           C  
ATOM   2966  OD1 ASP B 183      28.662  22.890   1.717  1.00 30.58           O  
ATOM   2967  OD2 ASP B 183      27.793  22.932  -0.308  1.00 32.26           O  
ATOM   2968  N   ILE B 184      24.182  25.101   3.093  1.00 25.56           N  
ATOM   2969  CA  ILE B 184      23.215  26.107   3.533  1.00 25.89           C  
ATOM   2970  C   ILE B 184      22.104  25.407   4.307  1.00 24.02           C  
ATOM   2971  O   ILE B 184      21.603  24.361   3.883  1.00 23.61           O  
ATOM   2972  CB  ILE B 184      22.587  26.853   2.342  1.00 28.11           C  
ATOM   2973  CG1 ILE B 184      23.659  27.675   1.625  1.00 31.09           C  
ATOM   2974  CG2 ILE B 184      21.463  27.781   2.826  1.00 27.56           C  
ATOM   2975  CD1 ILE B 184      23.187  28.234   0.289  1.00 38.90           C  
ATOM   2976  N   THR B 185      21.716  25.988   5.438  1.00 23.68           N  
ATOM   2977  CA  THR B 185      20.667  25.395   6.263  1.00 23.72           C  
ATOM   2978  C   THR B 185      19.452  26.303   6.445  1.00 21.78           C  
ATOM   2979  O   THR B 185      19.590  27.477   6.781  1.00 22.71           O  
ATOM   2980  CB  THR B 185      21.209  25.046   7.662  1.00 22.71           C  
ATOM   2981  OG1 THR B 185      21.854  26.196   8.224  1.00 23.25           O  
ATOM   2982  CG2 THR B 185      22.224  23.893   7.578  1.00 25.89           C  
ATOM   2983  N   LEU B 186      18.269  25.748   6.226  1.00 21.11           N  
ATOM   2984  CA  LEU B 186      17.026  26.497   6.402  1.00 23.10           C  
ATOM   2985  C   LEU B 186      16.222  25.822   7.507  1.00 22.46           C  
ATOM   2986  O   LEU B 186      16.037  24.601   7.493  1.00 20.89           O  
ATOM   2987  CB  LEU B 186      16.195  26.494   5.122  1.00 21.36           C  
ATOM   2988  CG  LEU B 186      16.900  26.881   3.821  1.00 20.30           C  
ATOM   2989  CD1 LEU B 186      15.857  26.887   2.734  1.00 23.87           C  
ATOM   2990  CD2 LEU B 186      17.591  28.217   3.920  1.00 21.56           C  
ATOM   2991  N   VAL B 187      15.739  26.609   8.462  1.00 20.33           N  
ATOM   2992  CA  VAL B 187      14.963  26.046   9.564  1.00 19.50           C  
ATOM   2993  C   VAL B 187      13.508  26.541   9.607  1.00 21.43           C  
ATOM   2994  O   VAL B 187      13.238  27.725   9.390  1.00 20.53           O  
ATOM   2995  CB  VAL B 187      15.621  26.383  10.923  1.00 23.00           C  
ATOM   2996  CG1 VAL B 187      14.772  25.811  12.065  1.00 22.17           C  
ATOM   2997  CG2 VAL B 187      17.035  25.798  10.987  1.00 23.51           C  
ATOM   2998  N   GLU B 188      12.599  25.610   9.885  1.00 21.60           N  
ATOM   2999  CA  GLU B 188      11.166  25.856  10.009  1.00 19.97           C  
ATOM   3000  C   GLU B 188      10.896  25.504  11.475  1.00 18.80           C  
ATOM   3001  O   GLU B 188      10.720  24.337  11.815  1.00 23.76           O  
ATOM   3002  CB  GLU B 188      10.411  24.905   9.086  1.00 22.48           C  
ATOM   3003  CG  GLU B 188       8.895  25.049   9.092  1.00 24.99           C  
ATOM   3004  CD  GLU B 188       8.245  24.206   8.002  1.00 26.73           C  
ATOM   3005  OE1 GLU B 188       8.905  23.993   6.959  1.00 27.82           O  
ATOM   3006  OE2 GLU B 188       7.086  23.773   8.170  1.00 26.09           O  
ATOM   3007  N   PRO B 189      10.877  26.510  12.363  1.00 18.75           N  
ATOM   3008  CA  PRO B 189      10.644  26.277  13.793  1.00 20.64           C  
ATOM   3009  C   PRO B 189       9.194  26.306  14.264  1.00 23.60           C  
ATOM   3010  O   PRO B 189       8.388  27.080  13.735  1.00 21.60           O  
ATOM   3011  CB  PRO B 189      11.487  27.368  14.442  1.00 20.91           C  
ATOM   3012  CG  PRO B 189      11.292  28.527  13.496  1.00 23.34           C  
ATOM   3013  CD  PRO B 189      11.321  27.898  12.115  1.00 22.70           C  
ATOM   3014  N   ASP B 190       8.849  25.464  15.244  1.00 21.00           N  
ATOM   3015  CA  ASP B 190       7.472  25.473  15.758  1.00 22.86           C  
ATOM   3016  C   ASP B 190       7.267  26.794  16.505  1.00 25.70           C  
ATOM   3017  O   ASP B 190       6.187  27.389  16.468  1.00 25.38           O  
ATOM   3018  CB  ASP B 190       7.221  24.324  16.737  1.00 22.03           C  
ATOM   3019  CG  ASP B 190       7.292  22.967  16.074  1.00 22.88           C  
ATOM   3020  OD1 ASP B 190       7.287  22.908  14.823  1.00 22.45           O  
ATOM   3021  OD2 ASP B 190       7.343  21.964  16.802  1.00 22.16           O  
ATOM   3022  N   GLU B 191       8.322  27.233  17.188  1.00 22.51           N  
ATOM   3023  CA  GLU B 191       8.280  28.467  17.961  1.00 27.06           C  
ATOM   3024  C   GLU B 191       9.603  29.201  17.842  1.00 24.53           C  
ATOM   3025  O   GLU B 191      10.674  28.649  18.140  1.00 25.79           O  
ATOM   3026  CB  GLU B 191       8.047  28.186  19.447  1.00 28.46           C  
ATOM   3027  CG  GLU B 191       6.922  27.244  19.802  1.00 36.30           C  
ATOM   3028  CD  GLU B 191       6.870  27.002  21.312  1.00 41.79           C  
ATOM   3029  OE1 GLU B 191       6.102  26.125  21.768  1.00 41.77           O  
ATOM   3030  OE2 GLU B 191       7.606  27.700  22.042  1.00 43.50           O  
ATOM   3031  N   LEU B 192       9.527  30.452  17.410  1.00 22.90           N  
ATOM   3032  CA  LEU B 192      10.692  31.300  17.270  1.00 22.02           C  
ATOM   3033  C   LEU B 192      10.696  32.232  18.487  1.00 25.42           C  
ATOM   3034  O   LEU B 192       9.691  32.908  18.748  1.00 24.95           O  
ATOM   3035  CB  LEU B 192      10.579  32.110  15.976  1.00 23.34           C  
ATOM   3036  CG  LEU B 192      11.617  33.207  15.725  1.00 25.20           C  
ATOM   3037  CD1 LEU B 192      13.028  32.619  15.738  1.00 24.51           C  
ATOM   3038  CD2 LEU B 192      11.327  33.855  14.381  1.00 24.31           C  
ATOM   3039  N   VAL B 193      11.798  32.264  19.238  1.00 22.28           N  
ATOM   3040  CA  VAL B 193      11.862  33.121  20.427  1.00 23.27           C  
ATOM   3041  C   VAL B 193      13.081  34.032  20.441  1.00 21.92           C  
ATOM   3042  O   VAL B 193      13.986  33.891  19.619  1.00 25.03           O  
ATOM   3043  CB  VAL B 193      11.864  32.284  21.716  1.00 23.09           C  
ATOM   3044  CG1 VAL B 193      10.637  31.399  21.755  1.00 25.85           C  
ATOM   3045  CG2 VAL B 193      13.140  31.428  21.797  1.00 25.95           C  
ATOM   3046  N   GLU B 194      13.117  34.980  21.372  1.00 23.83           N  
ATOM   3047  CA  GLU B 194      14.273  35.875  21.458  1.00 23.10           C  
ATOM   3048  C   GLU B 194      15.499  35.125  21.977  1.00 23.85           C  
ATOM   3049  O   GLU B 194      15.371  34.169  22.736  1.00 23.03           O  
ATOM   3050  CB  GLU B 194      13.991  37.044  22.406  1.00 24.75           C  
ATOM   3051  CG  GLU B 194      12.923  38.037  21.922  1.00 25.38           C  
ATOM   3052  CD  GLU B 194      13.387  38.894  20.754  1.00 26.52           C  
ATOM   3053  OE1 GLU B 194      14.508  39.451  20.817  1.00 25.31           O  
ATOM   3054  OE2 GLU B 194      12.622  39.026  19.774  1.00 30.96           O  
ATOM   3055  N   THR B 195      16.683  35.562  21.568  1.00 26.17           N  
ATOM   3056  CA  THR B 195      17.916  34.943  22.050  1.00 29.30           C  
ATOM   3057  C   THR B 195      17.920  35.162  23.555  1.00 31.33           C  
ATOM   3058  O   THR B 195      17.511  36.219  24.037  1.00 31.55           O  
ATOM   3059  CB  THR B 195      19.152  35.619  21.458  1.00 34.64           C  
ATOM   3060  OG1 THR B 195      19.135  35.474  20.033  1.00 39.86           O  
ATOM   3061  CG2 THR B 195      20.429  34.987  22.029  1.00 36.72           C  
ATOM   3062  N   GLY B 196      18.361  34.159  24.299  1.00 31.59           N  
ATOM   3063  CA  GLY B 196      18.388  34.279  25.743  1.00 29.56           C  
ATOM   3064  C   GLY B 196      17.242  33.514  26.356  1.00 32.31           C  
ATOM   3065  O   GLY B 196      17.272  33.194  27.543  1.00 32.91           O  
ATOM   3066  N   GLU B 197      16.231  33.201  25.545  1.00 30.51           N  
ATOM   3067  CA  GLU B 197      15.062  32.477  26.032  1.00 30.14           C  
ATOM   3068  C   GLU B 197      15.275  30.976  26.173  1.00 31.24           C  
ATOM   3069  O   GLU B 197      14.598  30.319  26.961  1.00 30.21           O  
ATOM   3070  CB  GLU B 197      13.866  32.727  25.108  1.00 32.65           C  
ATOM   3071  CG  GLU B 197      13.346  34.149  25.148  1.00 36.05           C  
ATOM   3072  CD  GLU B 197      12.905  34.552  26.538  1.00 40.41           C  
ATOM   3073  OE1 GLU B 197      11.990  33.894  27.087  1.00 39.99           O  
ATOM   3074  OE2 GLU B 197      13.477  35.521  27.082  1.00 41.03           O  
ATOM   3075  N   LEU B 198      16.205  30.430  25.400  1.00 29.50           N  
ATOM   3076  CA  LEU B 198      16.486  29.000  25.455  1.00 30.44           C  
ATOM   3077  C   LEU B 198      17.524  28.685  26.523  1.00 32.79           C  
ATOM   3078  O   LEU B 198      18.523  29.388  26.635  1.00 35.47           O  
ATOM   3079  CB  LEU B 198      17.015  28.527  24.109  1.00 29.13           C  
ATOM   3080  CG  LEU B 198      16.147  28.817  22.887  1.00 30.02           C  
ATOM   3081  CD1 LEU B 198      16.873  28.332  21.656  1.00 32.37           C  
ATOM   3082  CD2 LEU B 198      14.811  28.130  23.018  1.00 29.26           C  
ATOM   3083  N   GLN B 199      17.291  27.630  27.299  1.00 35.95           N  
ATOM   3084  CA  GLN B 199      18.245  27.217  28.331  1.00 39.27           C  
ATOM   3085  C   GLN B 199      19.466  26.633  27.617  1.00 37.76           C  
ATOM   3086  O   GLN B 199      19.354  25.652  26.884  1.00 40.37           O  
ATOM   3087  CB  GLN B 199      17.606  26.172  29.245  1.00 44.71           C  
ATOM   3088  CG  GLN B 199      16.530  26.753  30.159  1.00 52.73           C  
ATOM   3089  CD  GLN B 199      15.962  25.735  31.122  1.00 56.54           C  
ATOM   3090  OE1 GLN B 199      14.886  25.175  30.895  1.00 59.47           O  
ATOM   3091  NE2 GLN B 199      16.690  25.479  32.207  1.00 59.19           N  
ATOM   3092  N   PRO B 200      20.644  27.239  27.812  1.00 36.19           N  
ATOM   3093  CA  PRO B 200      21.881  26.777  27.172  1.00 33.58           C  
ATOM   3094  C   PRO B 200      22.169  25.267  27.265  1.00 36.73           C  
ATOM   3095  O   PRO B 200      22.721  24.684  26.326  1.00 35.83           O  
ATOM   3096  CB  PRO B 200      22.951  27.627  27.849  1.00 34.99           C  
ATOM   3097  CG  PRO B 200      22.210  28.901  28.180  1.00 34.44           C  
ATOM   3098  CD  PRO B 200      20.913  28.371  28.719  1.00 36.79           C  
ATOM   3099  N   ASP B 201      21.810  24.648  28.387  1.00 32.77           N  
ATOM   3100  CA  ASP B 201      22.011  23.205  28.580  1.00 36.39           C  
ATOM   3101  C   ASP B 201      21.138  22.379  27.636  1.00 35.85           C  
ATOM   3102  O   ASP B 201      21.399  21.195  27.400  1.00 35.38           O  
ATOM   3103  CB  ASP B 201      21.658  22.802  30.018  1.00 40.06           C  
ATOM   3104  CG  ASP B 201      22.686  23.261  31.024  1.00 44.85           C  
ATOM   3105  OD1 ASP B 201      22.345  23.356  32.219  1.00 48.27           O  
ATOM   3106  OD2 ASP B 201      23.850  23.506  30.633  1.00 50.06           O  
ATOM   3107  N   HIS B 202      20.098  23.011  27.100  1.00 31.90           N  
ATOM   3108  CA  HIS B 202      19.160  22.332  26.219  1.00 33.40           C  
ATOM   3109  C   HIS B 202      19.334  22.570  24.731  1.00 27.89           C  
ATOM   3110  O   HIS B 202      18.639  21.968  23.921  1.00 25.58           O  
ATOM   3111  CB  HIS B 202      17.735  22.689  26.627  1.00 38.18           C  
ATOM   3112  CG  HIS B 202      17.403  22.264  28.022  1.00 46.72           C  
ATOM   3113  ND1 HIS B 202      16.337  22.784  28.727  1.00 48.59           N  
ATOM   3114  CD2 HIS B 202      17.996  21.368  28.846  1.00 47.26           C  
ATOM   3115  CE1 HIS B 202      16.289  22.227  29.923  1.00 49.73           C  
ATOM   3116  NE2 HIS B 202      17.285  21.364  30.022  1.00 51.27           N  
ATOM   3117  N   ILE B 203      20.247  23.454  24.363  1.00 25.28           N  
ATOM   3118  CA  ILE B 203      20.466  23.701  22.940  1.00 24.81           C  
ATOM   3119  C   ILE B 203      21.166  22.496  22.305  1.00 25.35           C  
ATOM   3120  O   ILE B 203      22.214  22.042  22.781  1.00 23.15           O  
ATOM   3121  CB  ILE B 203      21.287  24.971  22.741  1.00 26.57           C  
ATOM   3122  CG1 ILE B 203      20.467  26.182  23.216  1.00 24.22           C  
ATOM   3123  CG2 ILE B 203      21.681  25.111  21.277  1.00 23.52           C  
ATOM   3124  CD1 ILE B 203      21.229  27.488  23.198  1.00 26.93           C  
ATOM   3125  N   VAL B 204      20.577  21.983  21.231  1.00 21.81           N  
ATOM   3126  CA  VAL B 204      21.130  20.821  20.542  1.00 24.87           C  
ATOM   3127  C   VAL B 204      21.907  21.209  19.293  1.00 26.19           C  
ATOM   3128  O   VAL B 204      22.949  20.625  18.992  1.00 24.64           O  
ATOM   3129  CB  VAL B 204      20.013  19.819  20.173  1.00 21.29           C  
ATOM   3130  CG1 VAL B 204      20.593  18.631  19.357  1.00 21.83           C  
ATOM   3131  CG2 VAL B 204      19.357  19.303  21.471  1.00 24.99           C  
ATOM   3132  N   THR B 205      21.399  22.192  18.560  1.00 20.36           N  
ATOM   3133  CA  THR B 205      22.071  22.646  17.349  1.00 20.70           C  
ATOM   3134  C   THR B 205      22.468  24.099  17.559  1.00 23.57           C  
ATOM   3135  O   THR B 205      21.611  24.958  17.823  1.00 23.29           O  
ATOM   3136  CB  THR B 205      21.146  22.529  16.111  1.00 19.23           C  
ATOM   3137  OG1 THR B 205      20.740  21.162  15.931  1.00 20.84           O  
ATOM   3138  CG2 THR B 205      21.865  23.022  14.853  1.00 20.74           C  
ATOM   3139  N   PRO B 206      23.777  24.395  17.470  1.00 23.93           N  
ATOM   3140  CA  PRO B 206      24.296  25.763  17.653  1.00 25.75           C  
ATOM   3141  C   PRO B 206      23.895  26.684  16.505  1.00 26.66           C  
ATOM   3142  O   PRO B 206      23.946  26.288  15.344  1.00 25.51           O  
ATOM   3143  CB  PRO B 206      25.811  25.553  17.725  1.00 26.03           C  
ATOM   3144  CG  PRO B 206      26.016  24.392  16.763  1.00 26.32           C  
ATOM   3145  CD  PRO B 206      24.866  23.456  17.138  1.00 25.44           C  
ATOM   3146  N   GLY B 207      23.501  27.916  16.829  1.00 27.51           N  
ATOM   3147  CA  GLY B 207      23.087  28.846  15.785  1.00 27.78           C  
ATOM   3148  C   GLY B 207      24.115  29.063  14.685  1.00 27.41           C  
ATOM   3149  O   GLY B 207      23.762  29.400  13.561  1.00 27.64           O  
ATOM   3150  N   ALA B 208      25.393  28.855  14.999  1.00 30.49           N  
ATOM   3151  CA  ALA B 208      26.462  29.056  14.019  1.00 29.41           C  
ATOM   3152  C   ALA B 208      26.292  28.261  12.728  1.00 29.24           C  
ATOM   3153  O   ALA B 208      26.729  28.705  11.674  1.00 30.70           O  
ATOM   3154  CB  ALA B 208      27.824  28.734  14.653  1.00 31.65           C  
ATOM   3155  N   VAL B 209      25.660  27.094  12.788  1.00 25.75           N  
ATOM   3156  CA  VAL B 209      25.487  26.303  11.574  1.00 27.04           C  
ATOM   3157  C   VAL B 209      24.156  26.568  10.876  1.00 25.46           C  
ATOM   3158  O   VAL B 209      23.869  25.971   9.835  1.00 26.58           O  
ATOM   3159  CB  VAL B 209      25.601  24.775  11.868  1.00 28.26           C  
ATOM   3160  CG1 VAL B 209      26.935  24.473  12.555  1.00 32.44           C  
ATOM   3161  CG2 VAL B 209      24.448  24.315  12.749  1.00 28.49           C  
ATOM   3162  N   ILE B 210      23.343  27.454  11.455  1.00 24.69           N  
ATOM   3163  CA  ILE B 210      22.026  27.786  10.892  1.00 24.21           C  
ATOM   3164  C   ILE B 210      22.096  29.114  10.111  1.00 26.63           C  
ATOM   3165  O   ILE B 210      22.522  30.133  10.643  1.00 27.98           O  
ATOM   3166  CB  ILE B 210      20.961  27.871  12.028  1.00 24.21           C  
ATOM   3167  CG1 ILE B 210      20.788  26.482  12.676  1.00 24.78           C  
ATOM   3168  CG2 ILE B 210      19.617  28.390  11.481  1.00 20.43           C  
ATOM   3169  CD1 ILE B 210      20.563  25.352  11.673  1.00 19.97           C  
ATOM   3170  N   ASP B 211      21.677  29.087   8.849  1.00 26.08           N  
ATOM   3171  CA  ASP B 211      21.739  30.261   7.986  1.00 27.29           C  
ATOM   3172  C   ASP B 211      20.470  31.096   7.887  1.00 28.38           C  
ATOM   3173  O   ASP B 211      20.534  32.325   7.887  1.00 29.29           O  
ATOM   3174  CB  ASP B 211      22.151  29.839   6.574  1.00 26.33           C  
ATOM   3175  CG  ASP B 211      23.474  29.110   6.562  1.00 33.01           C  
ATOM   3176  OD1 ASP B 211      24.432  29.659   7.143  1.00 32.66           O  
ATOM   3177  OD2 ASP B 211      23.548  27.994   5.991  1.00 30.63           O  
ATOM   3178  N   HIS B 212      19.329  30.429   7.790  1.00 25.40           N  
ATOM   3179  CA  HIS B 212      18.064  31.135   7.653  1.00 26.48           C  
ATOM   3180  C   HIS B 212      16.938  30.498   8.445  1.00 27.49           C  
ATOM   3181  O   HIS B 212      16.830  29.264   8.534  1.00 24.47           O  
ATOM   3182  CB  HIS B 212      17.699  31.226   6.171  1.00 26.79           C  
ATOM   3183  CG  HIS B 212      18.729  31.945   5.365  1.00 29.41           C  
ATOM   3184  ND1 HIS B 212      18.920  33.307   5.458  1.00 31.29           N  
ATOM   3185  CD2 HIS B 212      19.716  31.481   4.565  1.00 32.15           C  
ATOM   3186  CE1 HIS B 212      19.984  33.648   4.756  1.00 31.98           C  
ATOM   3187  NE2 HIS B 212      20.488  32.559   4.207  1.00 30.93           N  
ATOM   3188  N   ILE B 213      16.089  31.358   9.001  1.00 22.87           N  
ATOM   3189  CA  ILE B 213      14.969  30.928   9.836  1.00 24.07           C  
ATOM   3190  C   ILE B 213      13.619  31.436   9.317  1.00 25.01           C  
ATOM   3191  O   ILE B 213      13.459  32.635   9.096  1.00 25.86           O  
ATOM   3192  CB  ILE B 213      15.155  31.469  11.272  1.00 26.10           C  
ATOM   3193  CG1 ILE B 213      16.530  31.058  11.817  1.00 25.80           C  
ATOM   3194  CG2 ILE B 213      14.039  30.973  12.160  1.00 26.62           C  
ATOM   3195  CD1 ILE B 213      16.984  31.867  13.040  1.00 26.00           C  
ATOM   3196  N   ILE B 214      12.657  30.536   9.124  1.00 22.56           N  
ATOM   3197  CA  ILE B 214      11.328  30.946   8.669  1.00 24.36           C  
ATOM   3198  C   ILE B 214      10.645  31.639   9.868  1.00 27.62           C  
ATOM   3199  O   ILE B 214      10.563  31.054  10.948  1.00 21.30           O  
ATOM   3200  CB  ILE B 214      10.479  29.731   8.232  1.00 24.85           C  
ATOM   3201  CG1 ILE B 214      11.122  29.043   7.022  1.00 24.96           C  
ATOM   3202  CG2 ILE B 214       9.047  30.176   7.889  1.00 21.86           C  
ATOM   3203  CD1 ILE B 214      11.363  29.977   5.837  1.00 30.13           C  
ATOM   3204  N   VAL B 215      10.152  32.871   9.674  1.00 23.77           N  
ATOM   3205  CA  VAL B 215       9.520  33.619  10.768  1.00 25.81           C  
ATOM   3206  C   VAL B 215       8.013  33.450  10.924  1.00 25.90           C  
ATOM   3207  O   VAL B 215       7.472  33.666  12.010  1.00 27.93           O  
ATOM   3208  CB  VAL B 215       9.787  35.134  10.646  1.00 24.63           C  
ATOM   3209  CG1 VAL B 215      11.271  35.399  10.634  1.00 23.61           C  
ATOM   3210  CG2 VAL B 215       9.122  35.674   9.389  1.00 21.83           C  
ATOM   3211  N   SER B 216       7.336  33.085   9.846  1.00 24.72           N  
ATOM   3212  CA  SER B 216       5.890  32.903   9.882  1.00 29.12           C  
ATOM   3213  C   SER B 216       5.490  31.635  10.619  1.00 29.47           C  
ATOM   3214  O   SER B 216       6.252  30.666  10.688  1.00 26.48           O  
ATOM   3215  CB  SER B 216       5.321  32.854   8.459  1.00 30.32           C  
ATOM   3216  OG  SER B 216       5.864  31.760   7.738  1.00 28.64           O  
ATOM   3217  N   GLN B 217       4.269  31.645  11.135  1.00 30.08           N  
ATOM   3218  CA  GLN B 217       3.735  30.526  11.888  1.00 36.08           C  
ATOM   3219  C   GLN B 217       2.625  29.815  11.124  1.00 42.61           C  
ATOM   3220  O   GLN B 217       2.083  30.348  10.150  1.00 42.89           O  
ATOM   3221  CB  GLN B 217       3.208  31.044  13.229  1.00 35.54           C  
ATOM   3222  CG  GLN B 217       4.140  32.075  13.842  1.00 38.99           C  
ATOM   3223  CD  GLN B 217       3.495  32.906  14.942  1.00 43.60           C  
ATOM   3224  OE1 GLN B 217       4.018  33.966  15.328  1.00 40.42           O  
ATOM   3225  NE2 GLN B 217       2.362  32.429  15.460  1.00 42.85           N  
ATOM   3226  N   GLU B 218       2.310  28.608  11.597  1.00 49.47           N  
ATOM   3227  CA  GLU B 218       1.269  27.723  11.075  1.00 56.71           C  
ATOM   3228  C   GLU B 218       1.486  27.267   9.649  1.00 60.08           C  
ATOM   3229  O   GLU B 218       2.430  27.696   8.989  1.00 64.47           O  
ATOM   3230  CB  GLU B 218      -0.112  28.374  11.202  1.00 57.56           C  
ATOM   3231  CG  GLU B 218      -0.529  29.220  10.018  1.00 63.64           C  
ATOM   3232  CD  GLU B 218      -1.965  29.684  10.138  1.00 67.89           C  
ATOM   3233  OE1 GLU B 218      -2.278  30.381  11.129  1.00 70.04           O  
ATOM   3234  OE2 GLU B 218      -2.779  29.348   9.250  1.00 68.36           O  
ATOM   3235  N   SER B 219       0.598  26.394   9.177  1.00 62.60           N  
ATOM   3236  CA  SER B 219       0.679  25.859   7.823  1.00 64.26           C  
ATOM   3237  C   SER B 219       0.420  26.932   6.760  1.00 66.32           C  
ATOM   3238  O   SER B 219      -0.025  28.044   7.131  1.00 64.88           O  
ATOM   3239  CB  SER B 219      -0.317  24.712   7.666  1.00 64.72           C  
TER    3240      SER B 219                                                      
END
MOLECULE T0438_2_186.pdb
ATOM      1  N   GLN     2      22.301  40.864  20.451  1.00 45.66          
ATOM      2  CA  GLN     2      20.920  40.443  20.090  1.00 45.49          
ATOM      3  C   GLN     2      21.031  39.501  18.881  1.00 45.02          
ATOM      4  O   GLN     2      21.727  39.738  17.859  1.00 44.52          
ATOM      5  CB  GLN     2      20.001  41.664  19.812  1.00 45.68          
ATOM      6  CG  GLN     2      20.247  42.944  20.771  1.00 48.87          
ATOM      7  CD  GLN     2      21.138  44.133  20.172  1.00 50.18          
ATOM      8  OE1 GLN     2      21.022  44.439  18.977  1.00 51.19          
ATOM      9  NE2 GLN     2      21.973  44.802  21.024  1.00 46.81          
ATOM     10  N   TRP     3      20.369  38.376  19.023  1.00 44.69          
ATOM     11  CA  TRP     3      20.378  37.380  17.946  1.00 44.23          
ATOM     12  C   TRP     3      19.071  37.457  17.150  1.00 44.35          
ATOM     13  O   TRP     3      19.030  37.083  15.975  1.00 44.41          
ATOM     14  CB  TRP     3      20.611  35.966  18.508  1.00 42.96          
ATOM     15  CG  TRP     3      19.780  35.702  19.684  1.00 40.96          
ATOM     16  CD1 TRP     3      20.138  35.839  20.974  1.00 39.33          
ATOM     17  CD2 TRP     3      18.406  35.292  19.676  1.00 43.16          
ATOM     18  NE1 TRP     3      19.085  35.522  21.796  1.00 39.72          
ATOM     19  CE2 TRP     3      18.004  35.166  21.034  1.00 40.34          
ATOM     20  CE3 TRP     3      17.461  34.979  18.646  1.00 44.38          
ATOM     21  CZ2 TRP     3      16.695  34.773  21.418  1.00 38.75          
ATOM     22  CZ3 TRP     3      16.145  34.560  19.037  1.00 42.51          
ATOM     23  CH2 TRP     3      15.785  34.475  20.423  1.00 39.71          
ATOM     24  N   GLN     4      18.007  37.933  17.818  1.00 43.59          
ATOM     25  CA  GLN     4      16.729  38.267  17.159  1.00 42.20          
ATOM     26  C   GLN     4      16.911  39.288  16.033  1.00 40.57          
ATOM     27  O   GLN     4      16.105  39.369  15.127  1.00 40.61          
ATOM     28  CB  GLN     4      15.650  38.703  18.176  1.00 41.88          
ATOM     29  CG  GLN     4      16.136  39.685  19.247  1.00 42.96          
ATOM     30  CD  GLN     4      16.105  39.113  20.670  1.00 41.76          
ATOM     31  OE1 GLN     4      16.802  38.164  20.968  1.00 40.40          
ATOM     32  NE2 GLN     4      15.315  39.734  21.554  1.00 42.64          
ATOM     33  N   GLU     5      17.981  40.051  16.056  1.00 39.51          
ATOM     34  CA  GLU     5      18.176  40.924  14.951  1.00 39.47          
ATOM     35  C   GLU     5      18.675  40.092  13.761  1.00 37.95          
ATOM     36  O   GLU     5      18.368  40.367  12.611  1.00 36.65          
ATOM     37  CB  GLU     5      19.087  42.065  15.341  1.00 40.78          
ATOM     38  CG  GLU     5      19.214  43.177  14.290  1.00 48.67          
ATOM     39  CD  GLU     5      17.900  43.902  13.832  1.00 58.49          
ATOM     40  OE1 GLU     5      16.712  43.385  13.955  1.00 62.56          
ATOM     41  OE2 GLU     5      18.077  45.040  13.290  1.00 61.65          
ATOM     42  N   LEU     6      19.385  39.008  14.055  1.00 37.32          
ATOM     43  CA  LEU     6      19.644  37.958  13.054  1.00 35.46          
ATOM     44  C   LEU     6      18.402  37.140  12.689  1.00 34.95          
ATOM     45  O   LEU     6      18.210  36.788  11.527  1.00 34.26          
ATOM     46  CB  LEU     6      20.673  36.969  13.565  1.00 34.98          
ATOM     47  CG  LEU     6      21.750  36.771  12.565  1.00 31.82          
ATOM     48  CD1 LEU     6      22.286  38.168  12.572  1.00 27.40          
ATOM     49  CD2 LEU     6      22.674  35.746  13.153  1.00 30.24          
ATOM     50  N   TYR     7      17.585  36.824  13.686  1.00 34.57          
ATOM     51  CA  TYR     7      16.383  36.095  13.435  1.00 35.06          
ATOM     52  C   TYR     7      15.707  36.885  12.365  1.00 35.55          
ATOM     53  O   TYR     7      15.350  36.315  11.331  1.00 37.74          
ATOM     54  CB  TYR     7      15.505  36.072  14.657  1.00 36.13          
ATOM     55  CG  TYR     7      14.278  35.179  14.558  1.00 37.33          
ATOM     56  CD1 TYR     7      14.341  33.886  15.033  1.00 38.27          
ATOM     57  CD2 TYR     7      13.063  35.630  14.030  1.00 35.78          
ATOM     58  CE1 TYR     7      13.280  33.080  14.995  1.00 37.74          
ATOM     59  CE2 TYR     7      11.974  34.823  13.995  1.00 35.57          
ATOM     60  CZ  TYR     7      12.095  33.528  14.486  1.00 38.65          
ATOM     61  OH  TYR     7      11.067  32.566  14.469  1.00 42.57          
ATOM     62  N   ARG     8      15.578  38.199  12.570  1.00 34.26          
ATOM     63  CA  ARG     8      14.849  39.002  11.639  1.00 33.10          
ATOM     64  C   ARG     8      15.563  38.954  10.305  1.00 31.22          
ATOM     65  O   ARG     8      14.916  38.742   9.332  1.00 30.95          
ATOM     66  CB  ARG     8      14.490  40.421  12.194  1.00 34.39          
ATOM     67  CG  ARG     8      13.122  40.469  12.931  1.00 38.53          
ATOM     68  CD  ARG     8      11.938  39.837  12.015  1.00 46.29          
ATOM     69  NE  ARG     8      10.943  38.935  12.696  1.00 46.06          
ATOM     70  CZ  ARG     8       9.769  38.435  12.158  1.00 42.31          
ATOM     71  NH1 ARG     8       9.426  38.718  10.884  1.00 38.18          
ATOM     72  NH2 ARG     8       8.952  37.646  12.915  1.00 37.18          
ATOM     73  N   GLN     9      16.876  39.075  10.243  1.00 29.86          
ATOM     74  CA  GLN     9      17.528  39.242   8.935  1.00 29.54          
ATOM     75  C   GLN     9      17.539  37.961   8.008  1.00 29.51          
ATOM     76  O   GLN     9      17.934  38.043   6.805  1.00 29.97          
ATOM     77  CB  GLN     9      18.940  39.867   9.110  1.00 29.11          
ATOM     78  CG  GLN     9      19.927  39.779   7.874  1.00 31.47          
ATOM     79  CD  GLN     9      21.436  39.404   8.260  1.00 34.75          
ATOM     80  OE1 GLN     9      22.120  40.202   8.961  1.00 41.31          
ATOM     81  NE2 GLN     9      21.936  38.195   7.809  1.00 34.17          
ATOM     82  N   ARG    10      17.103  36.791   8.536  1.00 27.99          
ATOM     83  CA  ARG    10      17.257  35.479   7.837  1.00 25.47          
ATOM     84  C   ARG    10      15.915  34.801   7.610  1.00 23.91          
ATOM     85  O   ARG    10      15.835  33.715   7.021  1.00 21.35          
ATOM     86  CB  ARG    10      18.087  34.539   8.711  1.00 25.21          
ATOM     87  CG  ARG    10      19.643  34.464   8.447  1.00 24.12          
ATOM     88  CD  ARG    10      20.453  34.545   9.747  1.00 20.79          
ATOM     89  NE  ARG    10      21.708  33.838   9.752  1.00 20.44          
ATOM     90  CZ  ARG    10      22.836  34.319   9.288  1.00 26.06          
ATOM     91  NH1 ARG    10      22.938  35.531   8.710  1.00 31.79          
ATOM     92  NH2 ARG    10      23.893  33.561   9.367  1.00 26.81          
ATOM     93  N   VAL    11      14.856  35.411   8.147  1.00 23.51          
ATOM     94  CA  VAL    11      13.468  34.939   7.856  1.00 24.18          
ATOM     95  C   VAL    11      12.950  35.245   6.394  1.00 24.54          
ATOM     96  O   VAL    11      13.170  36.348   5.886  1.00 25.11          
ATOM     97  CB  VAL    11      12.442  35.295   8.996  1.00 23.08          
ATOM     98  CG1 VAL    11      12.697  36.579   9.455  1.00 22.94          
ATOM     99  CG2 VAL    11      11.053  35.250   8.541  1.00 21.30          
ATOM    100  N   CYS    12      12.364  34.229   5.725  1.00 23.75          
ATOM    101  CA  CYS    12      11.746  34.327   4.406  1.00 23.05          
ATOM    102  C   CYS    12      10.544  33.390   4.344  1.00 22.52          
ATOM    103  O   CYS    12      10.106  32.858   5.350  1.00 22.55          
ATOM    104  CB  CYS    12      12.742  34.040   3.276  1.00 22.22          
ATOM    105  SG  CYS    12      13.790  32.594   3.587  1.00 26.12          
ATOM    106  N   SER    13       9.984  33.237   3.157  1.00 22.63          
ATOM    107  CA  SER    13       8.885  32.332   2.923  1.00 21.87          
ATOM    108  C   SER    13       9.543  31.066   2.564  1.00 20.56          
ATOM    109  O   SER    13      10.679  31.034   2.134  1.00 19.95          
ATOM    110  CB  SER    13       8.045  32.773   1.689  1.00 22.74          
ATOM    111  OG  SER    13       8.782  32.631   0.471  1.00 22.51          
ATOM    112  N   ALA    14       8.778  30.012   2.647  1.00 19.68          
ATOM    113  CA  ALA    14       9.261  28.772   2.182  1.00 18.20          
ATOM    114  C   ALA    14       9.767  28.969   0.743  1.00 17.81          
ATOM    115  O   ALA    14      10.901  28.543   0.407  1.00 17.26          
ATOM    116  CB  ALA    14       8.174  27.770   2.255  1.00 17.48          
ATOM    117  N   ASP    15       8.965  29.650  -0.075  1.00 17.40          
ATOM    118  CA  ASP    15       9.211  29.686  -1.539  1.00 17.58          
ATOM    119  C   ASP    15      10.487  30.433  -1.836  1.00 17.51          
ATOM    120  O   ASP    15      11.311  30.009  -2.674  1.00 17.85          
ATOM    121  CB  ASP    15       8.085  30.371  -2.306  1.00 17.43          
ATOM    122  CG  ASP    15       6.708  29.566  -2.297  1.00 22.38          
ATOM    123  OD1 ASP    15       6.459  28.807  -3.287  1.00 24.07          
ATOM    124  OD2 ASP    15       5.803  29.661  -1.385  1.00 24.81          
ATOM    125  N   GLU    16      10.707  31.526  -1.100  1.00 17.22          
ATOM    126  CA  GLU    16      11.910  32.289  -1.307  1.00 15.21          
ATOM    127  C   GLU    16      13.102  31.449  -0.897  1.00 13.71          
ATOM    128  O   GLU    16      14.168  31.458  -1.579  1.00 12.05          
ATOM    129  CB  GLU    16      11.879  33.572  -0.545  1.00 16.27          
ATOM    130  CG  GLU    16      10.687  34.467  -0.728  1.00 18.47          
ATOM    131  CD  GLU    16      10.627  35.488   0.412  1.00 26.97          
ATOM    132  OE1 GLU    16      10.572  35.074   1.619  1.00 27.31          
ATOM    133  OE2 GLU    16      10.677  36.723   0.119  1.00 25.64          
ATOM    134  N   ALA    17      12.934  30.701   0.189  1.00 12.99          
ATOM    135  CA  ALA    17      14.004  29.727   0.575  1.00 13.65          
ATOM    136  C   ALA    17      14.275  28.533  -0.412  1.00 13.45          
ATOM    137  O   ALA    17      15.406  28.291  -0.777  1.00 12.07          
ATOM    138  CB  ALA    17      13.840  29.269   1.950  1.00 12.61          
ATOM    139  N   VAL    18      13.248  27.833  -0.865  1.00 14.16          
ATOM    140  CA  VAL    18      13.421  26.938  -2.017  1.00 16.22          
ATOM    141  C   VAL    18      14.161  27.625  -3.160  1.00 16.91          
ATOM    142  O   VAL    18      15.203  27.158  -3.659  1.00 16.37          
ATOM    143  CB  VAL    18      12.060  26.490  -2.624  1.00 15.97          
ATOM    144  CG1 VAL    18      12.246  25.850  -3.927  1.00 15.99          
ATOM    145  CG2 VAL    18      11.378  25.552  -1.751  1.00 17.31          
ATOM    146  N   VAL    19      13.630  28.729  -3.615  1.00 18.11          
ATOM    147  CA  VAL    19      14.321  29.245  -4.759  1.00 21.42          
ATOM    148  C   VAL    19      15.773  29.606  -4.525  1.00 23.57          
ATOM    149  O   VAL    19      16.554  29.291  -5.385  1.00 24.74          
ATOM    150  CB  VAL    19      13.635  30.342  -5.447  1.00 21.17          
ATOM    151  CG1 VAL    19      14.518  30.812  -6.572  1.00 20.43          
ATOM    152  CG2 VAL    19      12.330  29.809  -5.973  1.00 20.70          
ATOM    153  N   ASP    20      16.134  30.245  -3.402  1.00 25.89          
ATOM    154  CA  ASP    20      17.526  30.727  -3.203  1.00 28.38          
ATOM    155  C   ASP    20      18.424  29.612  -2.765  1.00 28.06          
ATOM    156  O   ASP    20      19.595  29.604  -3.031  1.00 28.27          
ATOM    157  CB  ASP    20      17.637  31.923  -2.223  1.00 29.34          
ATOM    158  CG  ASP    20      16.938  33.232  -2.806  1.00 39.37          
ATOM    159  OD1 ASP    20      17.516  33.774  -3.826  1.00 46.87          
ATOM    160  OD2 ASP    20      15.794  33.745  -2.406  1.00 40.49          
ATOM    161  N   SER    21      17.878  28.628  -2.101  1.00 27.91          
ATOM    162  CA  SER    21      18.755  27.626  -1.596  1.00 26.75          
ATOM    163  C   SER    21      18.865  26.472  -2.577  1.00 26.31          
ATOM    164  O   SER    21      19.719  25.654  -2.375  1.00 27.08          
ATOM    165  CB  SER    21      18.218  27.089  -0.292  1.00 27.05          
ATOM    166  OG  SER    21      17.116  26.217  -0.582  1.00 25.99          
ATOM    167  N   LEU    22      18.044  26.376  -3.621  1.00 24.68          
ATOM    168  CA  LEU    22      18.091  25.146  -4.364  1.00 23.84          
ATOM    169  C   LEU    22      18.634  25.283  -5.715  1.00 24.93          
ATOM    170  O   LEU    22      17.903  25.130  -6.731  1.00 26.26          
ATOM    171  CB  LEU    22      16.730  24.506  -4.461  1.00 23.97          
ATOM    172  CG  LEU    22      16.233  23.925  -3.138  1.00 22.50          
ATOM    173  CD1 LEU    22      15.176  22.905  -3.324  1.00 18.72          
ATOM    174  CD2 LEU    22      17.411  23.302  -2.398  1.00 22.66          
ATOM    175  N   LYS    23      19.929  25.542  -5.766  1.00 25.02          
ATOM    176  CA  LYS    23      20.602  25.712  -7.053  1.00 24.74          
ATOM    177  C   LYS    23      20.478  24.399  -7.888  1.00 24.03          
ATOM    178  O   LYS    23      20.452  23.302  -7.324  1.00 21.81          
ATOM    179  CB  LYS    23      22.076  26.201  -6.833  1.00 26.07          
ATOM    180  CG  LYS    23      22.142  27.600  -6.255  1.00 26.45          
ATOM    181  CD  LYS    23      20.911  28.383  -6.874  1.00 35.77          
ATOM    182  CE  LYS    23      20.688  29.922  -6.412  1.00 38.56          
ATOM    183  NZ  LYS    23      22.012  30.720  -6.220  1.00 42.87          
ATOM    184  N   PRO    24      20.377  24.511  -9.222  1.00 24.19          
ATOM    185  CA  PRO    24      20.483  23.338 -10.101  1.00 23.91          
ATOM    186  C   PRO    24      21.574  22.320  -9.658  1.00 24.25          
ATOM    187  O   PRO    24      22.636  22.659  -9.149  1.00 22.93          
ATOM    188  CB  PRO    24      20.836  23.955 -11.450  1.00 22.57          
ATOM    189  CG  PRO    24      20.402  25.315 -11.423  1.00 22.41          
ATOM    190  CD  PRO    24      20.124  25.737 -10.011  1.00 24.33          
ATOM    191  N   GLY    25      21.275  21.047  -9.843  1.00 24.91          
ATOM    192  CA  GLY    25      22.148  20.025  -9.339  1.00 22.99          
ATOM    193  C   GLY    25      22.373  19.939  -7.830  1.00 21.94          
ATOM    194  O   GLY    25      23.206  19.174  -7.452  1.00 22.50          
ATOM    195  N   THR    26      21.700  20.674  -6.943  1.00 20.84          
ATOM    196  CA  THR    26      21.987  20.496  -5.476  1.00 20.59          
ATOM    197  C   THR    26      21.419  19.186  -4.937  1.00 19.89          
ATOM    198  O   THR    26      20.437  18.732  -5.457  1.00 21.69          
ATOM    199  CB  THR    26      21.463  21.673  -4.642  1.00 19.97          
ATOM    200  OG1 THR    26      20.344  22.178  -5.331  1.00 22.62          
ATOM    201  CG2 THR    26      22.423  22.922  -4.718  1.00 23.49          
ATOM    202  N   LYS    27      22.040  18.572  -3.930  1.00 18.30          
ATOM    203  CA  LYS    27      21.432  17.516  -3.152  1.00 16.74          
ATOM    204  C   LYS    27      20.976  17.989  -1.786  1.00 16.46          
ATOM    205  O   LYS    27      21.687  18.729  -1.131  1.00 16.95          
ATOM    206  CB  LYS    27      22.493  16.509  -2.873  1.00 17.33          
ATOM    207  CG  LYS    27      23.179  16.134  -4.116  1.00 17.67          
ATOM    208  CD  LYS    27      24.649  15.882  -3.889  1.00 18.17          
ATOM    209  CE  LYS    27      25.100  14.632  -4.679  1.00 20.52          
ATOM    210  NZ  LYS    27      24.686  14.634  -6.118  1.00 22.18          
ATOM    211  N   VAL    28      19.841  17.508  -1.290  1.00 15.30          
ATOM    212  CA  VAL    28      19.279  18.066  -0.095  1.00 13.17          
ATOM    213  C   VAL    28      18.931  16.923   0.743  1.00 13.67          
ATOM    214  O   VAL    28      18.713  15.848   0.183  1.00 14.25          
ATOM    215  CB  VAL    28      18.033  18.943  -0.454  1.00 13.52          
ATOM    216  CG1 VAL    28      17.997  19.224  -1.929  1.00  9.64          
ATOM    217  CG2 VAL    28      16.757  18.404  -0.006  1.00 12.80          
ATOM    218  N   VAL    29      18.846  17.111   2.062  1.00 13.68          
ATOM    219  CA  VAL    29      18.433  16.035   2.988  1.00 13.42          
ATOM    220  C   VAL    29      17.292  16.589   3.831  1.00 14.82          
ATOM    221  O   VAL    29      17.375  17.720   4.317  1.00 14.92          
ATOM    222  CB  VAL    29      19.678  15.573   3.949  1.00 14.04          
ATOM    223  CG1 VAL    29      19.218  14.745   5.141  1.00 13.89          
ATOM    224  CG2 VAL    29      20.792  14.776   3.215  1.00  9.61          
ATOM    225  N   PHE    30      16.211  15.841   4.048  1.00 16.24          
ATOM    226  CA  PHE    30      15.112  16.383   4.929  1.00 15.93          
ATOM    227  C   PHE    30      15.142  15.725   6.246  1.00 17.61          
ATOM    228  O   PHE    30      15.413  14.539   6.318  1.00 18.72          
ATOM    229  CB  PHE    30      13.751  16.049   4.393  1.00 15.13          
ATOM    230  CG  PHE    30      13.355  16.807   3.122  1.00 16.71          
ATOM    231  CD1 PHE    30      12.130  16.473   2.454  1.00 13.37          
ATOM    232  CD2 PHE    30      14.143  17.855   2.618  1.00 14.25          
ATOM    233  CE1 PHE    30      11.714  17.102   1.339  1.00  7.85          
ATOM    234  CE2 PHE    30      13.709  18.537   1.509  1.00 14.62          
ATOM    235  CZ  PHE    30      12.489  18.150   0.845  1.00 15.33          
ATOM    236  N   GLY    31      14.862  16.447   7.324  1.00 20.63          
ATOM    237  CA  GLY    31      14.907  15.849   8.729  1.00 23.62          
ATOM    238  C   GLY    31      13.764  14.870   8.742  1.00 25.45          
ATOM    239  O   GLY    31      12.886  14.924   7.814  1.00 25.70          
ATOM    240  N   HSD    32      13.717  13.921   9.681  1.00 27.22          
ATOM    241  CA  HSD    32      12.664  12.907   9.339  1.00 27.58          
ATOM    242  C   HSD    32      11.594  12.665  10.317  1.00 24.69          
ATOM    243  O   HSD    32      11.641  13.260  11.315  1.00 23.64          
ATOM    244  CB  HSD    32      13.203  11.593   8.699  1.00 29.84          
ATOM    245  CG  HSD    32      13.512  10.536   9.708  1.00 30.57          
ATOM    246  ND1 HSD    32      14.035  10.857  10.955  1.00 33.64          
ATOM    247  CD2 HSD    32      13.316   9.191   9.688  1.00 23.42          
ATOM    248  CE1 HSD    32      14.171   9.722  11.644  1.00 34.23          
ATOM    249  NE2 HSD    32      13.731   8.711  10.906  1.00 24.90          
ATOM    250  N   ALA    33      10.600  11.851   9.922  1.00 23.60          
ATOM    251  CA  ALA    33       9.577  11.246  10.798  1.00 22.77          
ATOM    252  C   ALA    33       8.559  12.357  10.980  1.00 22.68          
ATOM    253  O   ALA    33       7.988  12.811   9.974  1.00 24.97          
ATOM    254  CB  ALA    33      10.154  10.728  12.138  1.00 22.02          
ATOM    255  N   ALA    34       8.327  12.826  12.213  1.00 21.17          
ATOM    256  CA  ALA    34       7.248  13.789  12.461  1.00 18.34          
ATOM    257  C   ALA    34       7.829  15.166  12.415  1.00 17.88          
ATOM    258  O   ALA    34       7.059  16.105  12.626  1.00 19.36          
ATOM    259  CB  ALA    34       6.557  13.552  13.782  1.00 17.06          
ATOM    260  N   ALA    35       9.123  15.287  12.054  1.00 15.79          
ATOM    261  CA  ALA    35       9.798  16.548  11.976  1.00 15.94          
ATOM    262  C   ALA    35      10.119  16.850  10.567  1.00 17.19          
ATOM    263  O   ALA    35      10.953  17.725  10.322  1.00 18.60          
ATOM    264  CB  ALA    35      11.079  16.542  12.757  1.00 15.24          
ATOM    265  N   ALA    36       9.494  16.108   9.656  1.00 18.19          
ATOM    266  CA  ALA    36       9.643  16.199   8.200  1.00 18.59          
ATOM    267  C   ALA    36       9.093  17.570   7.723  1.00 19.68          
ATOM    268  O   ALA    36       8.035  17.993   8.199  1.00 20.43          
ATOM    269  CB  ALA    36       8.852  15.070   7.575  1.00 18.13          
ATOM    270  N   PRO    37       9.807  18.291   6.856  1.00 19.40          
ATOM    271  CA  PRO    37       9.494  19.653   6.592  1.00 19.11          
ATOM    272  C   PRO    37       8.652  19.746   5.328  1.00 19.82          
ATOM    273  O   PRO    37       9.069  20.090   4.211  1.00 19.21          
ATOM    274  CB  PRO    37      10.877  20.291   6.449  1.00 19.33          
ATOM    275  CG  PRO    37      11.789  19.190   6.242  1.00 19.25          
ATOM    276  CD  PRO    37      11.030  17.897   6.136  1.00 19.94          
ATOM    277  N   VAL    38       7.402  19.462   5.573  1.00 21.02          
ATOM    278  CA  VAL    38       6.420  19.357   4.562  1.00 21.32          
ATOM    279  C   VAL    38       6.151  20.724   3.945  1.00 21.37          
ATOM    280  O   VAL    38       5.880  20.781   2.742  1.00 22.79          
ATOM    281  CB  VAL    38       5.198  18.633   5.149  1.00 20.45          
ATOM    282  CG1 VAL    38       5.005  19.063   6.573  1.00 21.69          
ATOM    283  CG2 VAL    38       3.953  18.894   4.314  1.00 23.80          
ATOM    284  N   ARG    39       6.251  21.828   4.695  1.00 21.58          
ATOM    285  CA  ARG    39       6.057  23.200   4.058  1.00 21.31          
ATOM    286  C   ARG    39       6.993  23.492   2.937  1.00 20.54          
ATOM    287  O   ARG    39       6.626  24.009   1.881  1.00 20.63          
ATOM    288  CB  ARG    39       6.234  24.299   5.063  1.00 20.92          
ATOM    289  CG  ARG    39       4.886  24.753   5.544  1.00 23.30          
ATOM    290  CD  ARG    39       4.194  23.790   6.423  1.00 22.38          
ATOM    291  NE  ARG    39       5.084  23.064   7.343  1.00 21.17          
ATOM    292  CZ  ARG    39       4.580  22.148   8.167  1.00 22.55          
ATOM    293  NH1 ARG    39       5.357  21.445   8.985  1.00 21.29          
ATOM    294  NH2 ARG    39       3.258  21.917   8.140  1.00 18.42          
ATOM    295  N   PHE    40       8.233  23.154   3.218  1.00 20.34          
ATOM    296  CA  PHE    40       9.247  23.150   2.258  1.00 19.91          
ATOM    297  C   PHE    40       8.970  22.162   1.149  1.00 21.28          
ATOM    298  O   PHE    40       9.204  22.510  -0.020  1.00 24.41          
ATOM    299  CB  PHE    40      10.528  22.765   2.901  1.00 18.96          
ATOM    300  CG  PHE    40      11.745  23.205   2.122  1.00 17.88          
ATOM    301  CD1 PHE    40      12.305  22.402   1.152  1.00 16.72          
ATOM    302  CD2 PHE    40      12.311  24.425   2.343  1.00 15.73          
ATOM    303  CE1 PHE    40      13.440  22.782   0.458  1.00 13.55          
ATOM    304  CE2 PHE    40      13.397  24.793   1.635  1.00 18.00          
ATOM    305  CZ  PHE    40      13.987  23.926   0.683  1.00 14.48          
ATOM    306  N   SER    41       8.474  20.950   1.419  1.00 21.03          
ATOM    307  CA  SER    41       8.101  20.048   0.285  1.00 20.01          
ATOM    308  C   SER    41       7.008  20.685  -0.618  1.00 20.61          
ATOM    309  O   SER    41       7.081  20.734  -1.879  1.00 18.08          
ATOM    310  CB  SER    41       7.692  18.671   0.799  1.00 19.44          
ATOM    311  OG  SER    41       7.220  17.809  -0.243  1.00 19.22          
ATOM    312  N   GLN    42       6.026  21.262   0.089  1.00 23.29          
ATOM    313  CA  GLN    42       4.854  22.015  -0.501  1.00 23.53          
ATOM    314  C   GLN    42       5.526  23.094  -1.367  1.00 21.04          
ATOM    315  O   GLN    42       5.265  23.134  -2.564  1.00 21.64          
ATOM    316  CB  GLN    42       3.896  22.569   0.635  1.00 24.61          
ATOM    317  CG  GLN    42       2.364  22.442   0.482  1.00 30.98          
ATOM    318  CD  GLN    42       1.797  21.221   1.339  1.00 42.73          
ATOM    319  OE1 GLN    42       1.886  21.261   2.617  1.00 44.13          
ATOM    320  NE2 GLN    42       1.217  20.140   0.639  1.00 39.64          
ATOM    321  N   ALA    43       6.451  23.901  -0.817  1.00 18.30          
ATOM    322  CA  ALA    43       7.058  24.957  -1.689  1.00 17.00          
ATOM    323  C   ALA    43       7.867  24.463  -2.881  1.00 15.00          
ATOM    324  O   ALA    43       7.953  25.133  -3.863  1.00 11.84          
ATOM    325  CB  ALA    43       7.842  26.061  -0.891  1.00 17.47          
ATOM    326  N   MET    44       8.465  23.290  -2.765  1.00 14.50          
ATOM    327  CA  MET    44       9.171  22.718  -3.905  1.00 15.39          
ATOM    328  C   MET    44       8.180  22.315  -4.982  1.00 12.22          
ATOM    329  O   MET    44       8.453  22.459  -6.155  1.00 10.78          
ATOM    330  CB  MET    44      10.004  21.489  -3.456  1.00 16.06          
ATOM    331  CG  MET    44      11.325  21.827  -2.668  1.00 18.15          
ATOM    332  SD  MET    44      12.072  20.295  -2.106  1.00 20.97          
ATOM    333  CE  MET    44      13.066  19.768  -3.438  1.00 18.66          
ATOM    334  N   TYR    45       7.032  21.785  -4.580  1.00 10.67          
ATOM    335  CA  TYR    45       5.946  21.600  -5.542  1.00 10.06          
ATOM    336  C   TYR    45       5.572  22.889  -6.326  1.00  9.87          
ATOM    337  O   TYR    45       5.709  22.956  -7.562  1.00  8.45          
ATOM    338  CB  TYR    45       4.676  21.096  -4.889  1.00  9.54          
ATOM    339  CG  TYR    45       3.695  20.666  -5.899  1.00 10.38          
ATOM    340  CD1 TYR    45       3.758  19.374  -6.440  1.00 12.83          
ATOM    341  CD2 TYR    45       2.722  21.530  -6.378  1.00 13.04          
ATOM    342  CE1 TYR    45       2.851  18.920  -7.393  1.00  9.77          
ATOM    343  CE2 TYR    45       1.831  21.105  -7.362  1.00 12.73          
ATOM    344  CZ  TYR    45       1.896  19.781  -7.881  1.00 10.42          
ATOM    345  OH  TYR    45       1.007  19.310  -8.869  1.00  9.11          
ATOM    346  N   ARG    46       5.079  23.900  -5.622  1.00  9.05          
ATOM    347  CA  ARG    46       4.776  25.139  -6.317  1.00  9.66          
ATOM    348  C   ARG    46       5.910  25.661  -7.187  1.00 10.23          
ATOM    349  O   ARG    46       5.632  26.166  -8.245  1.00 12.26          
ATOM    350  CB  ARG    46       4.439  26.213  -5.329  1.00  9.96          
ATOM    351  CG  ARG    46       3.314  25.881  -4.450  1.00 13.07          
ATOM    352  CD  ARG    46       2.823  27.089  -3.757  1.00 15.66          
ATOM    353  NE  ARG    46       3.804  27.393  -2.785  1.00 13.78          
ATOM    354  CZ  ARG    46       3.789  26.881  -1.575  1.00 16.09          
ATOM    355  NH1 ARG    46       2.775  26.038  -1.199  1.00 13.23          
ATOM    356  NH2 ARG    46       4.827  27.215  -0.748  1.00 17.30          
ATOM    357  N   GLN    47       7.170  25.585  -6.745  1.00 10.28          
ATOM    358  CA  GLN    47       8.277  26.169  -7.466  1.00 10.77          
ATOM    359  C   GLN    47       8.893  25.199  -8.428  1.00 12.81          
ATOM    360  O   GLN    47       9.983  25.484  -8.888  1.00 13.62          
ATOM    361  CB  GLN    47       9.364  26.734  -6.537  1.00  9.13          
ATOM    362  CG  GLN    47       8.858  27.863  -5.590  1.00  8.69          
ATOM    363  CD  GLN    47       8.302  29.097  -6.313  1.00 12.55          
ATOM    364  OE1 GLN    47       9.001  29.654  -7.183  1.00 12.81          
ATOM    365  NE2 GLN    47       7.028  29.512  -5.999  1.00 10.02          
ATOM    366  N   ARG    48       8.234  24.070  -8.757  1.00 14.75          
ATOM    367  CA  ARG    48       8.882  23.003  -9.600  1.00 16.22          
ATOM    368  C   ARG    48       9.508  23.394 -10.941  1.00 18.74          
ATOM    369  O   ARG    48      10.503  22.813 -11.415  1.00 19.44          
ATOM    370  CB  ARG    48       7.955  21.872  -9.857  1.00 15.11          
ATOM    371  CG  ARG    48       6.812  22.197 -10.649  1.00 12.28          
ATOM    372  CD  ARG    48       5.739  21.130 -10.387  1.00 14.04          
ATOM    373  NE  ARG    48       4.596  21.083 -11.320  1.00 12.26          
ATOM    374  CZ  ARG    48       3.366  21.456 -11.022  1.00  7.88          
ATOM    375  NH1 ARG    48       2.382  21.322 -11.895  1.00 10.20          
ATOM    376  NH2 ARG    48       3.112  21.923  -9.830  1.00  8.03          
ATOM    377  N   GLU    49       8.945  24.443 -11.513  1.00 22.00          
ATOM    378  CA  GLU    49       9.142  24.778 -12.905  1.00 23.10          
ATOM    379  C   GLU    49      10.486  25.462 -12.887  1.00 21.97          
ATOM    380  O   GLU    49      11.117  25.564 -13.918  1.00 21.76          
ATOM    381  CB  GLU    49       7.956  25.675 -13.329  1.00 24.94          
ATOM    382  CG  GLU    49       6.632  25.427 -12.445  1.00 32.27          
ATOM    383  CD  GLU    49       5.382  24.838 -13.254  1.00 39.48          
ATOM    384  OE1 GLU    49       5.398  24.978 -14.542  1.00 42.88          
ATOM    385  OE2 GLU    49       4.371  24.278 -12.655  1.00 33.87          
ATOM    386  N   LYS    50      10.952  25.876 -11.706  1.00 20.75          
ATOM    387  CA  LYS    50      12.289  26.415 -11.602  1.00 21.27          
ATOM    388  C   LYS    50      13.357  25.454 -11.107  1.00 22.29          
ATOM    389  O   LYS    50      14.536  25.730 -11.349  1.00 22.17          
ATOM    390  CB  LYS    50      12.382  27.563 -10.644  1.00 20.60          
ATOM    391  CG  LYS    50      11.353  28.501 -10.782  1.00 23.73          
ATOM    392  CD  LYS    50      11.580  29.674  -9.798  1.00 32.88          
ATOM    393  CE  LYS    50      10.446  30.721  -9.868  1.00 34.86          
ATOM    394  NZ  LYS    50      10.027  30.892 -11.304  1.00 40.84          
ATOM    395  N   LEU    51      13.021  24.400 -10.357  1.00 22.84          
ATOM    396  CA  LEU    51      14.108  23.538  -9.925  1.00 24.35          
ATOM    397  C   LEU    51      14.666  22.590 -11.051  1.00 25.58          
ATOM    398  O   LEU    51      13.897  22.020 -11.885  1.00 24.86          
ATOM    399  CB  LEU    51      13.723  22.722  -8.703  1.00 25.21          
ATOM    400  CG  LEU    51      13.068  23.246  -7.435  1.00 24.94          
ATOM    401  CD1 LEU    51      13.734  24.504  -6.999  1.00 24.38          
ATOM    402  CD2 LEU    51      11.688  23.477  -7.833  1.00 24.87          
ATOM    403  N   GLU    52      15.991  22.427 -11.048  1.00 26.21          
ATOM    404  CA  GLU    52      16.666  21.582 -12.020  1.00 28.11          
ATOM    405  C   GLU    52      17.112  20.258 -11.418  1.00 27.85          
ATOM    406  O   GLU    52      16.266  19.421 -11.280  1.00 29.19          
ATOM    407  CB  GLU    52      17.830  22.289 -12.648  1.00 29.97          
ATOM    408  CG  GLU    52      17.450  23.278 -13.716  1.00 34.15          
ATOM    409  CD  GLU    52      17.371  22.581 -15.043  1.00 40.84          
ATOM    410  OE1 GLU    52      18.468  22.252 -15.589  1.00 41.08          
ATOM    411  OE2 GLU    52      16.210  22.347 -15.526  1.00 45.33          
ATOM    412  N   ASN    53      18.362  19.994 -11.063  1.00 26.32          
ATOM    413  CA  ASN    53      18.627  18.552 -10.795  1.00 26.13          
ATOM    414  C   ASN    53      18.692  18.238  -9.325  1.00 24.38          
ATOM    415  O   ASN    53      19.769  17.937  -8.795  1.00 24.90          
ATOM    416  CB  ASN    53      19.880  17.980 -11.476  1.00 27.32          
ATOM    417  CG  ASN    53      19.804  18.070 -12.970  1.00 33.09          
ATOM    418  OD1 ASN    53      18.812  17.618 -13.532  1.00 44.00          
ATOM    419  ND2 ASN    53      20.818  18.709 -13.638  1.00 35.87          
ATOM    420  N   ILE    54      17.566  18.308  -8.645  1.00 20.73          
ATOM    421  CA  ILE    54      17.685  18.294  -7.249  1.00 18.62          
ATOM    422  C   ILE    54      17.515  16.861  -6.767  1.00 18.10          
ATOM    423  O   ILE    54      16.558  16.202  -7.136  1.00 18.14          
ATOM    424  CB  ILE    54      16.653  19.228  -6.667  1.00 18.97          
ATOM    425  CG1 ILE    54      16.495  20.461  -7.562  1.00 18.42          
ATOM    426  CG2 ILE    54      16.981  19.512  -5.250  1.00 13.40          
ATOM    427  CD  ILE    54      17.589  21.414  -7.367  1.00 24.43          
ATOM    428  N   THR    55      18.431  16.379  -5.946  1.00 16.66          
ATOM    429  CA  THR    55      18.296  15.069  -5.355  1.00 17.48          
ATOM    430  C   THR    55      17.849  15.226  -3.939  1.00 17.26          
ATOM    431  O   THR    55      18.475  15.999  -3.210  1.00 17.34          
ATOM    432  CB  THR    55      19.670  14.425  -5.257  1.00 18.10          
ATOM    433  OG1 THR    55      20.177  14.302  -6.554  1.00 19.09          
ATOM    434  CG2 THR    55      19.567  12.992  -4.872  1.00 18.79          
ATOM    435  N   VAL    56      16.828  14.485  -3.492  1.00 16.58          
ATOM    436  CA  VAL    56      16.601  14.516  -2.035  1.00 17.07          
ATOM    437  C   VAL    56      16.821  13.213  -1.320  1.00 16.61          
ATOM    438  O   VAL    56      16.496  12.147  -1.837  1.00 14.95          
ATOM    439  CB  VAL    56      15.356  15.352  -1.560  1.00 16.13          
ATOM    440  CG1 VAL    56      14.273  15.165  -2.494  1.00 18.18          
ATOM    441  CG2 VAL    56      14.912  14.926  -0.175  1.00 15.60          
ATOM    442  N   PHE    57      17.468  13.294  -0.166  1.00 17.83          
ATOM    443  CA  PHE    57      17.566  12.104   0.653  1.00 20.29          
ATOM    444  C   PHE    57      16.736  12.226   1.919  1.00 20.07          
ATOM    445  O   PHE    57      16.657  13.302   2.565  1.00 21.59          
ATOM    446  CB  PHE    57      19.024  11.623   0.950  1.00 20.84          
ATOM    447  CG  PHE    57      19.062  10.550   2.007  1.00 22.77          
ATOM    448  CD1 PHE    57      19.228  10.887   3.360  1.00 24.36          
ATOM    449  CD2 PHE    57      18.769   9.213   1.664  1.00 27.03          
ATOM    450  CE1 PHE    57      19.180   9.884   4.395  1.00 26.23          
ATOM    451  CE2 PHE    57      18.697   8.214   2.674  1.00 28.83          
ATOM    452  CZ  PHE    57      18.906   8.564   4.072  1.00 23.10          
ATOM    453  N   HSD    58      16.086  11.132   2.231  1.00 20.79          
ATOM    454  CA  HSD    58      15.356  10.977   3.520  1.00 23.07          
ATOM    455  C   HSD    58      14.856   9.522   3.756  1.00 23.95          
ATOM    456  O   HSD    58      15.233   8.589   3.005  1.00 24.70          
ATOM    457  CB  HSD    58      14.229  12.033   3.710  1.00 22.43          
ATOM    458  CG  HSD    58      13.028  11.795   2.855  1.00 20.20          
ATOM    459  ND1 HSD    58      12.702  12.604   1.782  1.00 22.17          
ATOM    460  CD2 HSD    58      12.082  10.828   2.897  1.00 16.24          
ATOM    461  CE1 HSD    58      11.581  12.160   1.212  1.00 19.90          
ATOM    462  NE2 HSD    58      11.188  11.082   1.869  1.00 18.72          
ATOM    463  N   MET    59      14.047   9.349   4.804  1.00 24.79          
ATOM    464  CA  MET    59      13.649   8.032   5.330  1.00 25.10          
ATOM    465  C   MET    59      12.198   8.141   5.652  1.00 25.33          
ATOM    466  O   MET    59      11.461   8.248   4.747  1.00 27.43          
ATOM    467  CB  MET    59      14.502   7.639   6.529  1.00 23.90          
ATOM    468  CG  MET    59      15.867   7.184   6.090  1.00 24.27          
ATOM    469  SD  MET    59      16.994   6.955   7.482  1.00 27.42          
ATOM    470  CE  MET    59      17.542   5.314   6.896  1.00 24.67          
ATOM    471  N   LEU    60      11.756   8.168   6.909  1.00 26.46          
ATOM    472  CA  LEU    60      10.329   8.393   7.228  1.00 26.02          
ATOM    473  C   LEU    60       9.941   9.783   6.977  1.00 26.45          
ATOM    474  O   LEU    60      10.475  10.677   7.572  1.00 26.47          
ATOM    475  CB  LEU    60      10.035   8.147   8.709  1.00 25.84          
ATOM    476  CG  LEU    60      10.033   6.701   9.129  1.00 25.58          
ATOM    477  CD1 LEU    60       8.709   6.212   8.924  1.00 27.61          
ATOM    478  CD2 LEU    60      10.939   5.998   8.198  1.00 21.75          
ATOM    479  N   TYR    61       8.926   9.965   6.177  1.00 28.90          
ATOM    480  CA  TYR    61       8.262  11.269   6.102  1.00 30.96          
ATOM    481  C   TYR    61       6.851  11.029   6.539  1.00 30.13          
ATOM    482  O   TYR    61       6.155  10.179   5.967  1.00 28.73          
ATOM    483  CB  TYR    61       8.169  11.718   4.619  1.00 34.27          
ATOM    484  CG  TYR    61       7.359  10.683   3.650  1.00 41.40          
ATOM    485  CD1 TYR    61       7.983   9.487   3.067  1.00 44.61          
ATOM    486  CD2 TYR    61       5.936  10.900   3.304  1.00 46.34          
ATOM    487  CE1 TYR    61       7.195   8.579   2.125  1.00 40.74          
ATOM    488  CE2 TYR    61       5.166   9.985   2.389  1.00 39.60          
ATOM    489  CZ  TYR    61       5.817   8.870   1.840  1.00 38.96          
ATOM    490  OH  TYR    61       5.082   8.073   1.024  1.00 39.91          
ATOM    491  N   PHE    62       6.378  11.814   7.486  1.00 30.46          
ATOM    492  CA  PHE    62       4.942  11.940   7.685  1.00 30.51          
ATOM    493  C   PHE    62       4.272  13.216   7.040  1.00 30.96          
ATOM    494  O   PHE    62       4.502  14.243   7.611  1.00 30.96          
ATOM    495  CB  PHE    62       4.804  11.972   9.177  1.00 30.79          
ATOM    496  CG  PHE    62       5.309  10.724   9.877  1.00 30.41          
ATOM    497  CD1 PHE    62       5.704  10.780  11.212  1.00 32.62          
ATOM    498  CD2 PHE    62       5.307   9.497   9.257  1.00 30.78          
ATOM    499  CE1 PHE    62       6.144   9.622  11.925  1.00 31.31          
ATOM    500  CE2 PHE    62       5.753   8.336   9.940  1.00 32.05          
ATOM    501  CZ  PHE    62       6.160   8.405  11.287  1.00 31.82          
ATOM    502  N   GLY    63       3.548  13.163   5.852  1.00 32.78          
ATOM    503  CA  GLY    63       2.657  14.280   5.178  1.00 32.09          
ATOM    504  C   GLY    63       3.081  14.990   3.844  1.00 34.69          
ATOM    505  O   GLY    63       2.308  15.607   2.985  1.00 34.41          
ATOM    506  N   ASP    64       4.410  15.044   3.799  1.00 36.39          
ATOM    507  CA  ASP    64       5.309  15.294   2.680  1.00 35.00          
ATOM    508  C   ASP    64       4.753  14.780   1.366  1.00 34.29          
ATOM    509  O   ASP    64       5.276  13.798   0.809  1.00 33.58          
ATOM    510  CB  ASP    64       6.508  14.343   3.001  1.00 34.52          
ATOM    511  CG  ASP    64       7.652  15.050   3.379  1.00 32.44          
ATOM    512  OD1 ASP    64       8.674  14.406   3.786  1.00 30.73          
ATOM    513  OD2 ASP    64       7.541  16.298   3.252  1.00 27.43          
ATOM    514  N   ALA    65       3.708  15.324   0.838  1.00 33.07          
ATOM    515  CA  ALA    65       3.454  14.680  -0.458  1.00 33.64          
ATOM    516  C   ALA    65       4.514  15.087  -1.506  1.00 31.92          
ATOM    517  O   ALA    65       5.497  14.427  -1.735  1.00 29.97          
ATOM    518  CB  ALA    65       1.846  14.790  -1.003  1.00 34.74          
ATOM    519  N   PRO    66       4.329  16.237  -2.074  1.00 32.05          
ATOM    520  CA  PRO    66       5.006  16.623  -3.330  1.00 33.03          
ATOM    521  C   PRO    66       6.521  16.253  -3.524  1.00 34.34          
ATOM    522  O   PRO    66       7.373  17.077  -3.280  1.00 33.74          
ATOM    523  CB  PRO    66       4.874  18.121  -3.234  1.00 33.84          
ATOM    524  CG  PRO    66       4.389  18.356  -1.562  1.00 32.17          
ATOM    525  CD  PRO    66       3.498  17.308  -1.500  1.00 30.81          
ATOM    526  N   HSD    67       6.913  15.040  -3.887  1.00 36.42          
ATOM    527  CA  HSD    67       8.299  14.912  -4.441  1.00 37.64          
ATOM    528  C   HSD    67       8.279  13.755  -5.342  1.00 38.84          
ATOM    529  O   HSD    67       9.163  13.665  -6.315  1.00 39.60          
ATOM    530  CB  HSD    67       9.355  14.334  -3.514  1.00 38.67          
ATOM    531  CG  HSD    67       9.399  14.916  -2.154  1.00 37.94          
ATOM    532  ND1 HSD    67       9.396  16.275  -1.927  1.00 35.73          
ATOM    533  CD2 HSD    67       9.531  14.304  -0.952  1.00 31.96          
ATOM    534  CE1 HSD    67       9.456  16.471  -0.625  1.00 38.35          
ATOM    535  NE2 HSD    67       9.510  15.292  -0.015  1.00 37.11          
ATOM    536  N   LEU    68       7.440  12.772  -4.891  1.00 37.72          
ATOM    537  CA  LEU    68       7.176  11.562  -5.710  1.00 36.10          
ATOM    538  C   LEU    68       5.935  11.880  -6.488  1.00 33.90          
ATOM    539  O   LEU    68       5.398  10.980  -7.148  1.00 35.37          
ATOM    540  CB  LEU    68       7.110  10.187  -4.948  1.00 36.82          
ATOM    541  CG  LEU    68       7.523   8.769  -5.573  1.00 38.55          
ATOM    542  CD1 LEU    68       8.359   8.708  -6.967  1.00 37.96          
ATOM    543  CD2 LEU    68       8.153   7.758  -4.525  1.00 36.10          
ATOM    544  N   ALA    69       5.502  13.148  -6.458  1.00 29.05          
ATOM    545  CA  ALA    69       4.440  13.513  -7.345  1.00 25.67          
ATOM    546  C   ALA    69       5.172  13.310  -8.628  1.00 22.99          
ATOM    547  O   ALA    69       6.304  13.731  -8.726  1.00 22.81          
ATOM    548  CB  ALA    69       4.091  14.939  -7.172  1.00 26.27          
ATOM    549  N   PRO    70       4.599  12.552  -9.552  1.00 20.49          
ATOM    550  CA  PRO    70       5.181  12.342 -10.869  1.00 18.83          
ATOM    551  C   PRO    70       5.671  13.601 -11.568  1.00 17.75          
ATOM    552  O   PRO    70       6.665  13.526 -12.299  1.00 18.08          
ATOM    553  CB  PRO    70       4.035  11.697 -11.681  1.00 18.88          
ATOM    554  CG  PRO    70       3.120  11.140 -10.759  1.00 17.25          
ATOM    555  CD  PRO    70       3.385  11.747  -9.370  1.00 20.05          
ATOM    556  N   GLU    71       5.012  14.750 -11.363  1.00 16.84          
ATOM    557  CA  GLU    71       5.385  16.022 -12.066  1.00 14.77          
ATOM    558  C   GLU    71       6.697  16.599 -11.560  1.00 15.46          
ATOM    559  O   GLU    71       7.327  17.440 -12.197  1.00 16.72          
ATOM    560  CB  GLU    71       4.228  17.005 -12.122  1.00 12.78          
ATOM    561  CG  GLU    71       3.378  17.141 -10.891  1.00 14.57          
ATOM    562  CD  GLU    71       2.325  16.045 -10.606  1.00 20.09          
ATOM    563  OE1 GLU    71       1.184  16.257 -10.876  1.00 26.94          
ATOM    564  OE2 GLU    71       2.537  14.991 -10.001  1.00 21.86          
ATOM    565  N   MET    72       7.163  16.102 -10.418  1.00 15.91          
ATOM    566  CA  MET    72       8.532  16.369  -9.972  1.00 16.11          
ATOM    567  C   MET    72       9.590  15.773 -10.867  1.00 16.82          
ATOM    568  O   MET    72      10.752  16.175 -10.777  1.00 16.32          
ATOM    569  CB  MET    72       8.749  15.812  -8.612  1.00 15.79          
ATOM    570  CG  MET    72       7.785  16.416  -7.627  1.00 16.25          
ATOM    571  SD  MET    72       7.583  18.155  -7.899  1.00 17.49          
ATOM    572  CE  MET    72       8.963  19.024  -7.147  1.00  5.62          
ATOM    573  N   ARG    73       9.191  14.814 -11.710  1.00 17.47          
ATOM    574  CA  ARG    73      10.127  14.188 -12.649  1.00 18.49          
ATOM    575  C   ARG    73      10.949  15.230 -13.405  1.00 18.37          
ATOM    576  O   ARG    73      10.418  16.093 -14.086  1.00 19.34          
ATOM    577  CB  ARG    73       9.455  13.193 -13.617  1.00 18.25          
ATOM    578  CG  ARG    73      10.374  12.748 -14.717  1.00 19.07          
ATOM    579  CD  ARG    73       9.821  11.628 -15.541  1.00 22.48          
ATOM    580  NE  ARG    73      10.362  10.331 -15.125  1.00 23.61          
ATOM    581  CZ  ARG    73       9.732   9.507 -14.315  1.00 23.62          
ATOM    582  NH1 ARG    73       8.553   9.876 -13.826  1.00 25.50          
ATOM    583  NH2 ARG    73      10.271   8.337 -13.967  1.00 21.07          
ATOM    584  N   SER    74      12.260  15.086 -13.270  1.00 17.82          
ATOM    585  CA  SER    74      13.283  15.968 -13.810  1.00 16.37          
ATOM    586  C   SER    74      13.431  17.168 -12.940  1.00 18.12          
ATOM    587  O   SER    74      14.343  17.950 -13.187  1.00 20.81          
ATOM    588  CB  SER    74      13.020  16.452 -15.194  1.00 14.43          
ATOM    589  OG  SER    74      12.489  17.717 -15.159  1.00 10.73          
ATOM    590  N   HSD    75      12.584  17.360 -11.923  1.00 17.54          
ATOM    591  CA  HSD    75      12.885  18.456 -10.991  1.00 16.10          
ATOM    592  C   HSD    75      13.540  18.025  -9.744  1.00 15.04          
ATOM    593  O   HSD    75      14.547  18.556  -9.389  1.00 14.88          
ATOM    594  CB  HSD    75      11.660  19.337 -10.746  1.00 16.21          
ATOM    595  CG  HSD    75      11.008  19.797 -12.023  1.00 13.53          
ATOM    596  ND1 HSD    75      11.544  20.796 -12.805  1.00  9.81          
ATOM    597  CD2 HSD    75       9.887  19.367 -12.653  1.00  8.80          
ATOM    598  CE1 HSD    75      10.760  20.970 -13.852  1.00 13.78          
ATOM    599  NE2 HSD    75       9.741  20.130 -13.771  1.00  9.55          
ATOM    600  N   VAL    76      12.961  17.056  -9.063  1.00 15.89          
ATOM    601  CA  VAL    76      13.644  16.465  -7.915  1.00 16.03          
ATOM    602  C   VAL    76      13.323  15.022  -7.738  1.00 17.34          
ATOM    603  O   VAL    76      12.152  14.646  -7.685  1.00 18.48          
ATOM    604  CB  VAL    76      13.393  17.180  -6.596  1.00 14.83          
ATOM    605  CG1 VAL    76      12.180  17.969  -6.643  1.00 10.14          
ATOM    606  CG2 VAL    76      13.333  16.156  -5.480  1.00 13.99          
ATOM    607  N   HSD    77      14.385  14.233  -7.630  1.00 18.66          
ATOM    608  CA  HSD    77      14.274  12.805  -7.416  1.00 20.88          
ATOM    609  C   HSD    77      14.731  12.416  -6.057  1.00 22.14          
ATOM    610  O   HSD    77      15.667  13.046  -5.558  1.00 23.59          
ATOM    611  CB  HSD    77      15.129  12.065  -8.411  1.00 20.82          
ATOM    612  CG  HSD    77      14.694  12.282  -9.823  1.00 24.04          
ATOM    613  ND1 HSD    77      13.466  12.848 -10.144  1.00 25.21          
ATOM    614  CD2 HSD    77      15.315  12.017 -10.996  1.00 20.39          
ATOM    615  CE1 HSD    77      13.363  12.935 -11.454  1.00 23.22          
ATOM    616  NE2 HSD    77      14.457  12.413 -11.990  1.00 23.36          
ATOM    617  N   PRO    78      14.124  11.376  -5.456  1.00 23.06          
ATOM    618  CA  PRO    78      14.643  10.810  -4.176  1.00 23.97          
ATOM    619  C   PRO    78      15.836   9.841  -4.370  1.00 24.35          
ATOM    620  O   PRO    78      15.902   9.146  -5.395  1.00 23.72          
ATOM    621  CB  PRO    78      13.440  10.059  -3.644  1.00 23.70          
ATOM    622  CG  PRO    78      12.746   9.561  -4.959  1.00 22.21          
ATOM    623  CD  PRO    78      12.941  10.634  -5.946  1.00 22.27          
ATOM    624  N   THR    79      16.758   9.811  -3.411  1.00 25.96          
ATOM    625  CA  THR    79      17.809   8.792  -3.430  1.00 28.67          
ATOM    626  C   THR    79      17.750   8.104  -2.128  1.00 30.83          
ATOM    627  O   THR    79      17.203   8.640  -1.108  1.00 31.90          
ATOM    628  CB  THR    79      19.254   9.311  -3.573  1.00 28.44          
ATOM    629  OG1 THR    79      19.285  10.696  -3.253  1.00 28.13          
ATOM    630  CG2 THR    79      19.861   9.199  -5.025  1.00 28.02          
ATOM    631  N   LEU    80      18.303   6.888  -2.203  1.00 32.55          
ATOM    632  CA  LEU    80      18.741   6.101  -1.031  1.00 33.52          
ATOM    633  C   LEU    80      20.077   5.382  -1.384  1.00 33.06          
ATOM    634  O   LEU    80      20.637   5.591  -2.481  1.00 31.87          
ATOM    635  CB  LEU    80      17.644   5.157  -0.541  1.00 31.95          
ATOM    636  CG  LEU    80      17.328   3.966  -1.467  1.00 34.36          
ATOM    637  CD1 LEU    80      16.992   4.359  -2.983  1.00 32.23          
ATOM    638  CD2 LEU    80      18.317   2.698  -1.325  1.00 32.55          
ATOM    639  N   CYS   101      21.530  -0.841   6.743  1.00 45.50          
ATOM    640  CA  CYS   101      20.526  -1.334   7.693  1.00 45.54          
ATOM    641  C   CYS   101      20.963  -1.287   9.222  1.00 45.98          
ATOM    642  O   CYS   101      20.126  -1.461  10.192  1.00 47.36          
ATOM    643  CB  CYS   101      20.300  -2.738   7.347  1.00 45.34          
ATOM    644  SG  CYS   101      21.876  -3.463   7.806  1.00 47.60          
ATOM    645  N   HSD   102      22.265  -1.101   9.476  1.00 45.20          
ATOM    646  CA  HSD   102      22.644  -0.627  10.825  1.00 43.68          
ATOM    647  C   HSD   102      22.277   0.859  10.841  1.00 42.64          
ATOM    648  O   HSD   102      23.146   1.706  10.540  1.00 44.05          
ATOM    649  CB  HSD   102      24.133  -0.753  11.145  1.00 42.86          
ATOM    650  CG  HSD   102      24.684  -2.138  11.011  1.00 44.86          
ATOM    651  ND1 HSD   102      26.028  -2.378  10.768  1.00 47.33          
ATOM    652  CD2 HSD   102      24.089  -3.353  11.077  1.00 43.51          
ATOM    653  CE1 HSD   102      26.240  -3.681  10.695  1.00 46.54          
ATOM    654  NE2 HSD   102      25.078  -4.292  10.871  1.00 47.46          
ATOM    655  N   PHE   103      21.022   1.195  11.177  1.00 39.64          
ATOM    656  CA  PHE   103      20.691   2.585  11.422  1.00 36.08          
ATOM    657  C   PHE   103      21.808   3.521  11.969  1.00 34.98          
ATOM    658  O   PHE   103      21.927   4.629  11.453  1.00 34.66          
ATOM    659  CB  PHE   103      19.429   2.705  12.250  1.00 35.62          
ATOM    660  CG  PHE   103      18.673   3.983  12.020  1.00 34.35          
ATOM    661  CD1 PHE   103      17.616   4.315  12.819  1.00 34.67          
ATOM    662  CD2 PHE   103      19.014   4.860  10.982  1.00 33.50          
ATOM    663  CE1 PHE   103      16.877   5.498  12.565  1.00 36.44          
ATOM    664  CE2 PHE   103      18.290   6.055  10.746  1.00 33.77          
ATOM    665  CZ  PHE   103      17.243   6.376  11.508  1.00 33.22          
ATOM    666  N   HSD   104      22.598   3.136  12.980  1.00 33.95          
ATOM    667  CA  HSD   104      23.627   4.090  13.515  1.00 34.71          
ATOM    668  C   HSD   104      24.690   4.666  12.501  1.00 34.55          
ATOM    669  O   HSD   104      25.382   5.694  12.833  1.00 35.19          
ATOM    670  CB  HSD   104      24.334   3.600  14.802  1.00 34.12          
ATOM    671  CG  HSD   104      25.381   2.568  14.550  1.00 33.67          
ATOM    672  ND1 HSD   104      26.720   2.775  14.840  1.00 36.93          
ATOM    673  CD2 HSD   104      25.294   1.328  14.012  1.00 31.58          
ATOM    674  CE1 HSD   104      27.410   1.702  14.489  1.00 35.47          
ATOM    675  NE2 HSD   104      26.569   0.811  13.984  1.00 32.99          
ATOM    676  N   GLU   105      24.778   4.073  11.288  1.00 32.40          
ATOM    677  CA  GLU   105      25.748   4.484  10.276  1.00 30.25          
ATOM    678  C   GLU   105      25.276   5.484   9.245  1.00 27.86          
ATOM    679  O   GLU   105      26.103   5.998   8.467  1.00 27.71          
ATOM    680  CB  GLU   105      26.257   3.259   9.589  1.00 31.31          
ATOM    681  CG  GLU   105      26.505   2.202  10.636  1.00 34.56          
ATOM    682  CD  GLU   105      26.814   0.843  10.054  1.00 38.25          
ATOM    683  OE1 GLU   105      25.880   0.161   9.535  1.00 38.04          
ATOM    684  OE2 GLU   105      28.003   0.450  10.166  1.00 41.24          
ATOM    685  N   VAL   106      23.987   5.781   9.245  1.00 24.63          
ATOM    686  CA  VAL   106      23.439   6.831   8.393  1.00 24.31          
ATOM    687  C   VAL   106      24.181   8.165   8.602  1.00 23.93          
ATOM    688  O   VAL   106      24.841   8.717   7.690  1.00 26.52          
ATOM    689  CB  VAL   106      21.876   7.000   8.544  1.00 25.36          
ATOM    690  CG1 VAL   106      21.197   7.664   7.288  1.00 21.28          
ATOM    691  CG2 VAL   106      21.192   5.615   8.881  1.00 25.50          
ATOM    692  N   PRO   107      24.187   8.669   9.797  1.00 21.38          
ATOM    693  CA  PRO   107      24.981   9.825  10.038  1.00 19.87          
ATOM    694  C   PRO   107      26.338   9.827   9.351  1.00 18.46          
ATOM    695  O   PRO   107      26.623  10.763   8.703  1.00 16.39          
ATOM    696  CB  PRO   107      25.101   9.776  11.506  1.00 20.31          
ATOM    697  CG  PRO   107      23.732   9.356  11.883  1.00 20.20          
ATOM    698  CD  PRO   107      23.516   8.190  11.010  1.00 21.38          
ATOM    699  N   GLU   108      27.140   8.782   9.447  1.00 18.93          
ATOM    700  CA  GLU   108      28.395   8.687   8.631  1.00 20.48          
ATOM    701  C   GLU   108      28.280   8.933   7.080  1.00 20.01          
ATOM    702  O   GLU   108      29.235   9.273   6.408  1.00 19.49          
ATOM    703  CB  GLU   108      29.048   7.318   8.837  1.00 20.61          
ATOM    704  CG  GLU   108      30.506   7.376   9.264  1.00 25.10          
ATOM    705  CD  GLU   108      30.726   7.994  10.646  1.00 24.03          
ATOM    706  OE1 GLU   108      29.693   8.094  11.353  1.00 23.17          
ATOM    707  OE2 GLU   108      31.916   8.366  10.990  1.00 19.42          
ATOM    708  N   LEU   109      27.114   8.743   6.495  1.00 19.15          
ATOM    709  CA  LEU   109      27.001   9.063   5.095  1.00 18.15          
ATOM    710  C   LEU   109      27.305  10.541   4.832  1.00 18.39          
ATOM    711  O   LEU   109      27.993  10.910   3.869  1.00 19.79          
ATOM    712  CB  LEU   109      25.575   8.727   4.611  1.00 18.32          
ATOM    713  CG  LEU   109      25.292   7.449   3.761  1.00 13.74          
ATOM    714  CD1 LEU   109      26.274   6.224   3.964  1.00  5.50          
ATOM    715  CD2 LEU   109      23.938   7.173   4.170  1.00  7.55          
ATOM    716  N   PHE   110      26.784  11.400   5.687  1.00 17.00          
ATOM    717  CA  PHE   110      27.187  12.800   5.691  1.00 15.01          
ATOM    718  C   PHE   110      28.634  13.069   6.220  1.00 15.12          
ATOM    719  O   PHE   110      29.400  13.758   5.587  1.00 15.21          
ATOM    720  CB  PHE   110      26.145  13.590   6.434  1.00 14.03          
ATOM    721  CG  PHE   110      24.733  13.051   6.249  1.00 13.77          
ATOM    722  CD1 PHE   110      24.223  12.756   4.947  1.00 14.11          
ATOM    723  CD2 PHE   110      23.899  12.861   7.335  1.00 10.22          
ATOM    724  CE1 PHE   110      22.902  12.262   4.796  1.00 10.69          
ATOM    725  CE2 PHE   110      22.521  12.369   7.165  1.00  9.50          
ATOM    726  CZ  PHE   110      22.066  12.063   5.918  1.00 10.95          
ATOM    727  N   ARG   111      29.003  12.505   7.358  1.00 15.13          
ATOM    728  CA  ARG   111      30.144  12.914   8.062  1.00 15.28          
ATOM    729  C   ARG   111      31.270  12.319   7.334  1.00 16.62          
ATOM    730  O   ARG   111      32.272  12.077   7.904  1.00 19.94          
ATOM    731  CB  ARG   111      30.109  12.307   9.432  1.00 14.02          
ATOM    732  CG  ARG   111      29.653  13.267  10.394  1.00 18.60          
ATOM    733  CD  ARG   111      29.820  12.941  11.940  1.00 26.87          
ATOM    734  NE  ARG   111      28.561  13.406  12.583  1.00 37.30          
ATOM    735  CZ  ARG   111      28.135  13.260  13.881  1.00 40.61          
ATOM    736  NH1 ARG   111      28.971  12.738  14.802  1.00 43.89          
ATOM    737  NH2 ARG   111      26.869  13.661  14.248  1.00 33.22          
ATOM    738  N   GLN   112      31.130  11.989   6.076  1.00 17.88          
ATOM    739  CA  GLN   112      32.186  11.184   5.373  1.00 17.82          
ATOM    740  C   GLN   112      31.983  11.420   3.856  1.00 17.31          
ATOM    741  O   GLN   112      32.747  10.991   3.023  1.00 15.36          
ATOM    742  CB  GLN   112      31.937   9.741   5.757  1.00 17.77          
ATOM    743  CG  GLN   112      32.937   8.770   5.474  1.00 24.26          
ATOM    744  CD  GLN   112      33.366   8.058   6.771  1.00 35.06          
ATOM    745  OE1 GLN   112      33.030   6.873   7.039  1.00 37.92          
ATOM    746  NE2 GLN   112      34.084   8.803   7.608  1.00 39.62          
ATOM    747  N   GLY   113      30.903  12.130   3.528  1.00 16.69          
ATOM    748  CA  GLY   113      30.715  12.469   2.210  1.00 18.47          
ATOM    749  C   GLY   113      30.203  11.358   1.289  1.00 19.78          
ATOM    750  O   GLY   113      30.034  11.600   0.090  1.00 18.83          
ATOM    751  N   PHE   114      29.914  10.156   1.789  1.00 20.80          
ATOM    752  CA  PHE   114      29.070   9.234   0.972  1.00 21.04          
ATOM    753  C   PHE   114      27.861   9.905   0.309  1.00 20.89          
ATOM    754  O   PHE   114      27.619   9.654  -0.876  1.00 21.49          
ATOM    755  CB  PHE   114      28.643   8.031   1.736  1.00 20.73          
ATOM    756  CG  PHE   114      29.793   7.199   2.204  1.00 23.48          
ATOM    757  CD1 PHE   114      30.047   7.030   3.557  1.00 26.99          
ATOM    758  CD2 PHE   114      30.618   6.571   1.309  1.00 22.39          
ATOM    759  CE1 PHE   114      31.102   6.225   3.995  1.00 26.36          
ATOM    760  CE2 PHE   114      31.693   5.791   1.762  1.00 23.48          
ATOM    761  CZ  PHE   114      31.921   5.604   3.094  1.00 24.22          
ATOM    762  N   PHE   115      27.146  10.786   1.030  1.00 20.88          
ATOM    763  CA  PHE   115      26.104  11.678   0.402  1.00 20.11          
ATOM    764  C   PHE   115      26.458  13.165   0.639  1.00 19.79          
ATOM    765  O   PHE   115      26.158  13.701   1.704  1.00 18.54          
ATOM    766  CB  PHE   115      24.694  11.339   0.893  1.00 18.75          
ATOM    767  CG  PHE   115      23.614  12.121   0.220  1.00 17.79          
ATOM    768  CD1 PHE   115      22.906  13.095   0.935  1.00 11.55          
ATOM    769  CD2 PHE   115      23.258  11.855  -1.170  1.00 18.01          
ATOM    770  CE1 PHE   115      21.853  13.769   0.326  1.00 11.48          
ATOM    771  CE2 PHE   115      22.231  12.584  -1.838  1.00  9.11          
ATOM    772  CZ  PHE   115      21.551  13.539  -1.122  1.00 13.81          
ATOM    773  N   PRO   116      27.156  13.783  -0.344  1.00 20.18          
ATOM    774  CA  PRO   116      27.699  15.137  -0.181  1.00 20.41          
ATOM    775  C   PRO   116      26.586  16.146  -0.091  1.00 21.00          
ATOM    776  O   PRO   116      26.413  16.892  -1.001  1.00 22.72          
ATOM    777  CB  PRO   116      28.496  15.363  -1.481  1.00 19.12          
ATOM    778  CG  PRO   116      28.037  14.366  -2.418  1.00 18.64          
ATOM    779  CD  PRO   116      27.529  13.218  -1.669  1.00 19.31          
ATOM    780  N   LEU   117      25.833  16.143   0.993  1.00 21.68          
ATOM    781  CA  LEU   117      24.728  17.062   1.226  1.00 21.87          
ATOM    782  C   LEU   117      25.171  18.521   1.129  1.00 22.02          
ATOM    783  O   LEU   117      26.191  18.949   1.700  1.00 23.52          
ATOM    784  CB  LEU   117      24.089  16.710   2.580  1.00 21.33          
ATOM    785  CG  LEU   117      24.050  17.713   3.700  1.00 24.40          
ATOM    786  CD1 LEU   117      22.634  17.784   4.141  1.00 31.96          
ATOM    787  CD2 LEU   117      24.925  17.377   4.866  1.00 24.53          
ATOM    788  N   ASP   118      24.397  19.278   0.394  1.00 21.56          
ATOM    789  CA  ASP   118      24.654  20.659   0.241  1.00 22.59          
ATOM    790  C   ASP   118      23.768  21.520   1.197  1.00 21.72          
ATOM    791  O   ASP   118      24.257  22.550   1.778  1.00 22.08          
ATOM    792  CB  ASP   118      24.347  21.022  -1.238  1.00 24.09          
ATOM    793  CG  ASP   118      25.443  20.582  -2.208  1.00 29.34          
ATOM    794  OD1 ASP   118      26.680  20.684  -1.828  1.00 34.93          
ATOM    795  OD2 ASP   118      25.141  20.121  -3.366  1.00 31.49          
ATOM    796  N   VAL   119      22.470  21.152   1.275  1.00 19.14          
ATOM    797  CA  VAL   119      21.493  21.824   2.128  1.00 17.20          
ATOM    798  C   VAL   119      20.771  20.805   3.006  1.00 15.41          
ATOM    799  O   VAL   119      20.330  19.796   2.516  1.00 16.54          
ATOM    800  CB  VAL   119      20.432  22.694   1.298  1.00 17.99          
ATOM    801  CG1 VAL   119      20.314  22.252  -0.080  1.00 17.88          
ATOM    802  CG2 VAL   119      19.001  22.730   1.946  1.00 13.59          
ATOM    803  N   ALA   120      20.630  21.096   4.281  1.00 12.24          
ATOM    804  CA  ALA   120      19.855  20.289   5.176  1.00 10.62          
ATOM    805  C   ALA   120      18.527  21.002   5.483  1.00  9.86          
ATOM    806  O   ALA   120      18.526  22.100   5.999  1.00  8.76          
ATOM    807  CB  ALA   120      20.692  20.034   6.491  1.00  9.97          
ATOM    808  N   VAL   121      17.391  20.406   5.169  1.00 10.09          
ATOM    809  CA  VAL   121      16.119  21.058   5.473  1.00 11.02          
ATOM    810  C   VAL   121      15.448  20.408   6.667  1.00 12.46          
ATOM    811  O   VAL   121      15.012  19.311   6.521  1.00 14.42          
ATOM    812  CB  VAL   121      15.150  21.024   4.309  1.00 10.38          
ATOM    813  CG1 VAL   121      13.767  21.571   4.701  1.00  9.85          
ATOM    814  CG2 VAL   121      15.694  21.876   3.311  1.00  9.47          
ATOM    815  N   VAL   122      15.356  21.080   7.820  1.00 12.59          
ATOM    816  CA  VAL   122      14.867  20.526   9.051  1.00 12.88          
ATOM    817  C   VAL   122      13.730  21.322   9.628  1.00 14.40          
ATOM    818  O   VAL   122      13.502  22.504   9.312  1.00 14.88          
ATOM    819  CB  VAL   122      15.952  20.504  10.159  1.00 12.79          
ATOM    820  CG1 VAL   122      17.200  19.769   9.719  1.00 11.51          
ATOM    821  CG2 VAL   122      16.309  21.893  10.610  1.00 15.12          
ATOM    822  N   GLN   123      13.030  20.701  10.568  1.00 15.62          
ATOM    823  CA  GLN   123      11.940  21.434  11.196  1.00 15.39          
ATOM    824  C   GLN   123      12.242  21.681  12.667  1.00 15.45          
ATOM    825  O   GLN   123      11.961  20.837  13.393  1.00 18.31          
ATOM    826  CB  GLN   123      10.635  20.625  11.029  1.00 13.80          
ATOM    827  CG  GLN   123       9.477  21.212  11.740  1.00 13.25          
ATOM    828  CD  GLN   123       8.169  20.546  11.364  1.00 16.16          
ATOM    829  OE1 GLN   123       8.115  19.359  11.065  1.00 17.38          
ATOM    830  NE2 GLN   123       7.102  21.301  11.423  1.00 16.59          
ATOM    831  N   VAL   124      12.771  22.783  13.145  1.00 15.40          
ATOM    832  CA  VAL   124      12.923  22.898  14.619  1.00 15.56          
ATOM    833  C   VAL   124      11.836  23.644  15.304  1.00 16.06          
ATOM    834  O   VAL   124      10.858  24.071  14.659  1.00 16.47          
ATOM    835  CB  VAL   124      14.146  23.663  14.939  1.00 15.79          
ATOM    836  CG1 VAL   124      15.330  22.842  14.450  1.00 17.89          
ATOM    837  CG2 VAL   124      14.108  25.044  14.165  1.00 16.01          
ATOM    838  N   SER   125      12.075  23.893  16.594  1.00 16.31          
ATOM    839  CA  SER   125      11.141  24.591  17.487  1.00 16.64          
ATOM    840  C   SER   125      11.526  26.068  17.720  1.00 18.84          
ATOM    841  O   SER   125      12.624  26.536  17.326  1.00 17.98          
ATOM    842  CB  SER   125      11.262  23.984  18.839  1.00 16.62          
ATOM    843  OG  SER   125      12.189  24.785  19.591  1.00 12.33          
ATOM    844  N   THR   126      10.657  26.814  18.426  1.00 20.67          
ATOM    845  CA  THR   126      11.023  28.199  18.726  1.00 21.55          
ATOM    846  C   THR   126      12.234  28.251  19.672  1.00 23.18          
ATOM    847  O   THR   126      12.262  27.529  20.676  1.00 23.07          
ATOM    848  CB  THR   126       9.869  28.974  19.298  1.00 20.93          
ATOM    849  OG1 THR   126       9.083  28.150  20.168  1.00 20.40          
ATOM    850  CG2 THR   126       8.902  29.330  18.190  1.00 24.14          
ATOM    851  N   PRO   127      13.209  29.117  19.354  1.00 24.24          
ATOM    852  CA  PRO   127      14.437  29.287  20.151  1.00 24.55          
ATOM    853  C   PRO   127      14.124  29.909  21.448  1.00 25.49          
ATOM    854  O   PRO   127      13.047  30.447  21.648  1.00 24.73          
ATOM    855  CB  PRO   127      15.256  30.320  19.388  1.00 24.89          
ATOM    856  CG  PRO   127      14.265  31.103  18.573  1.00 25.24          
ATOM    857  CD  PRO   127      13.128  30.088  18.246  1.00 24.52          
ATOM    858  N   ASN   128      15.091  29.820  22.337  1.00 27.55          
ATOM    859  CA  ASN   128      14.846  30.026  23.750  1.00 28.19          
ATOM    860  C   ASN   128      15.588  31.326  24.003  1.00 28.67          
ATOM    861  O   ASN   128      16.014  31.973  23.060  1.00 27.46          
ATOM    862  CB  ASN   128      15.434  28.869  24.555  1.00 27.90          
ATOM    863  CG  ASN   128      16.940  28.934  24.603  1.00 28.56          
ATOM    864  OD1 ASN   128      17.514  29.994  24.416  1.00 28.71          
ATOM    865  ND2 ASN   128      17.584  27.826  24.869  1.00 26.96          
ATOM    866  N   GLU   129      15.779  31.677  25.273  1.00 30.18          
ATOM    867  CA  GLU   129      16.221  33.036  25.626  1.00 30.26          
ATOM    868  C   GLU   129      17.646  33.356  25.096  1.00 30.65          
ATOM    869  O   GLU   129      18.036  34.542  24.994  1.00 30.34          
ATOM    870  CB  GLU   129      16.147  33.194  27.130  1.00 29.31          
ATOM    871  CG  GLU   129      16.185  34.609  27.604  1.00 30.83          
ATOM    872  CD  GLU   129      16.353  34.669  29.113  1.00 35.69          
ATOM    873  OE1 GLU   129      16.477  35.820  29.667  1.00 36.25          
ATOM    874  OE2 GLU   129      16.378  33.560  29.745  1.00 31.69          
ATOM    875  N   GLU   130      18.414  32.290  24.782  1.00 30.58          
ATOM    876  CA  GLU   130      19.783  32.393  24.235  1.00 29.90          
ATOM    877  C   GLU   130      19.867  32.157  22.734  1.00 28.66          
ATOM    878  O   GLU   130      20.944  31.956  22.226  1.00 29.16          
ATOM    879  CB  GLU   130      20.740  31.439  24.942  1.00 29.97          
ATOM    880  CG  GLU   130      20.840  31.736  26.427  1.00 35.17          
ATOM    881  CD  GLU   130      19.855  30.894  27.249  1.00 45.59          
ATOM    882  OE1 GLU   130      20.365  30.058  28.058  1.00 47.60          
ATOM    883  OE2 GLU   130      18.579  31.022  27.071  1.00 48.61          
ATOM    884  N   GLY   131      18.746  32.131  22.028  1.00 26.74          
ATOM    885  CA  GLY   131      18.798  31.931  20.627  1.00 25.05          
ATOM    886  C   GLY   131      19.022  30.504  20.208  1.00 24.50          
ATOM    887  O   GLY   131      19.489  30.225  19.092  1.00 25.31          
ATOM    888  N   TYR   132      18.675  29.575  21.073  1.00 24.19          
ATOM    889  CA  TYR   132      18.951  28.162  20.788  1.00 23.06          
ATOM    890  C   TYR   132      17.619  27.506  20.439  1.00 21.93          
ATOM    891  O   TYR   132      16.687  27.574  21.196  1.00 21.69          
ATOM    892  CB  TYR   132      19.646  27.495  21.999  1.00 22.21          
ATOM    893  CG  TYR   132      21.180  27.520  21.991  1.00 23.03          
ATOM    894  CD1 TYR   132      21.955  28.208  22.987  1.00 24.43          
ATOM    895  CD2 TYR   132      21.870  26.813  21.035  1.00 23.82          
ATOM    896  CE1 TYR   132      23.378  28.202  22.931  1.00 19.96          
ATOM    897  CE2 TYR   132      23.233  26.807  20.990  1.00 22.16          
ATOM    898  CZ  TYR   132      23.984  27.500  21.894  1.00 22.00          
ATOM    899  OH  TYR   132      25.360  27.397  21.663  1.00 26.15          
ATOM    900  N   CYS   133      17.525  26.921  19.272  1.00 21.73          
ATOM    901  CA  CYS   133      16.395  26.048  18.987  1.00 22.78          
ATOM    902  C   CYS   133      16.719  24.568  19.154  1.00 23.84          
ATOM    903  O   CYS   133      17.919  24.131  19.162  1.00 23.34          
ATOM    904  CB  CYS   133      16.021  26.174  17.531  1.00 23.06          
ATOM    905  SG  CYS   133      15.583  27.815  16.949  1.00 18.90          
ATOM    906  N   SER   134      15.633  23.799  19.168  1.00 23.44          
ATOM    907  CA  SER   134      15.692  22.363  19.467  1.00 24.05          
ATOM    908  C   SER   134      15.224  21.636  18.303  1.00 22.22          
ATOM    909  O   SER   134      14.246  22.082  17.669  1.00 22.62          
ATOM    910  CB  SER   134      14.695  21.931  20.615  1.00 25.98          
ATOM    911  OG  SER   134      14.539  20.487  20.661  1.00 31.24          
ATOM    912  N   PHE   135      15.813  20.461  18.099  1.00 20.16          
ATOM    913  CA  PHE   135      15.357  19.609  17.036  1.00 18.92          
ATOM    914  C   PHE   135      14.006  19.013  17.358  1.00 19.00          
ATOM    915  O   PHE   135      13.405  18.409  16.488  1.00 19.70          
ATOM    916  CB  PHE   135      16.409  18.580  16.672  1.00 17.97          
ATOM    917  CG  PHE   135      17.510  19.170  15.847  1.00 18.79          
ATOM    918  CD1 PHE   135      18.763  19.422  16.393  1.00 19.67          
ATOM    919  CD2 PHE   135      17.278  19.566  14.543  1.00 15.91          
ATOM    920  CE1 PHE   135      19.736  20.064  15.634  1.00 16.32          
ATOM    921  CE2 PHE   135      18.248  20.167  13.801  1.00 13.09          
ATOM    922  CZ  PHE   135      19.466  20.430  14.345  1.00 15.02          
ATOM    923  N   GLY   136      13.531  19.183  18.592  1.00 18.14          
ATOM    924  CA  GLY   136      12.240  18.625  19.026  1.00 18.20          
ATOM    925  C   GLY   136      12.198  17.108  19.020  1.00 18.91          
ATOM    926  O   GLY   136      13.002  16.412  19.708  1.00 19.82          
ATOM    927  N   VAL   137      11.278  16.588  18.211  1.00 18.95          
ATOM    928  CA  VAL   137      10.967  15.128  18.133  1.00 18.28          
ATOM    929  C   VAL   137      11.880  14.255  17.194  1.00 18.95          
ATOM    930  O   VAL   137      11.637  13.068  16.950  1.00 18.11          
ATOM    931  CB  VAL   137       9.449  14.883  17.900  1.00 17.64          
ATOM    932  CG1 VAL   137       8.590  15.861  18.745  1.00 12.71          
ATOM    933  CG2 VAL   137       9.109  15.027  16.446  1.00 18.29          
ATOM    934  N   SER   138      12.956  14.861  16.707  1.00 20.84          
ATOM    935  CA  SER   138      13.888  14.173  15.766  1.00 22.85          
ATOM    936  C   SER   138      15.374  14.575  15.896  1.00 23.16          
ATOM    937  O   SER   138      15.773  15.680  15.516  1.00 23.06          
ATOM    938  CB  SER   138      13.438  14.456  14.351  1.00 21.83          
ATOM    939  OG  SER   138      12.890  13.287  13.869  1.00 26.22          
ATOM    940  N   CYS   139      16.188  13.727  16.481  1.00 23.29          
ATOM    941  CA  CYS   139      17.574  14.098  16.526  1.00 24.70          
ATOM    942  C   CYS   139      18.236  13.271  15.411  1.00 26.43          
ATOM    943  O   CYS   139      18.812  13.816  14.441  1.00 26.23          
ATOM    944  CB  CYS   139      18.085  13.700  17.864  1.00 24.45          
ATOM    945  SG  CYS   139      19.615  14.510  18.126  1.00 25.47          
ATOM    946  N   ASP   140      18.026  11.941  15.555  1.00 26.42          
ATOM    947  CA  ASP   140      18.506  10.870  14.707  1.00 26.20          
ATOM    948  C   ASP   140      19.564  11.222  13.710  1.00 23.76          
ATOM    949  O   ASP   140      20.729  11.330  14.113  1.00 24.78          
ATOM    950  CB  ASP   140      17.336  10.194  14.057  1.00 28.14          
ATOM    951  CG  ASP   140      16.414  11.161  13.488  1.00 32.82          
ATOM    952  OD1 ASP   140      16.765  11.780  12.435  1.00 39.32          
ATOM    953  OD2 ASP   140      15.322  11.394  14.061  1.00 39.64          
ATOM    954  N   TYR   141      19.211  11.388  12.436  1.00 21.00          
ATOM    955  CA  TYR   141      20.283  11.667  11.411  1.00 19.84          
ATOM    956  C   TYR   141      20.189  13.104  11.015  1.00 19.27          
ATOM    957  O   TYR   141      21.051  13.644  10.273  1.00 18.41          
ATOM    958  CB  TYR   141      20.164  10.847  10.148  1.00 16.80          
ATOM    959  CG  TYR   141      18.904  11.130   9.367  1.00 16.14          
ATOM    960  CD1 TYR   141      18.818  12.162   8.478  1.00 16.72          
ATOM    961  CD2 TYR   141      17.824  10.297   9.429  1.00 16.49          
ATOM    962  CE1 TYR   141      17.677  12.362   7.738  1.00 10.84          
ATOM    963  CE2 TYR   141      16.681  10.515   8.653  1.00 10.95          
ATOM    964  CZ  TYR   141      16.636  11.530   7.839  1.00  9.36          
ATOM    965  OH  TYR   141      15.508  11.704   7.102  1.00 11.32          
ATOM    966  N   THR   142      19.080  13.668  11.475  1.00 17.87          
ATOM    967  CA  THR   142      18.778  14.980  11.145  1.00 17.85          
ATOM    968  C   THR   142      19.725  15.996  11.819  1.00 18.00          
ATOM    969  O   THR   142      19.997  17.028  11.253  1.00 19.61          
ATOM    970  CB  THR   142      17.254  15.309  11.291  1.00 17.60          
ATOM    971  OG1 THR   142      17.156  16.571  11.939  1.00 19.55          
ATOM    972  CG2 THR   142      16.472  14.397  12.260  1.00 17.10          
ATOM    973  N   LYS   143      20.283  15.767  12.978  1.00 17.42          
ATOM    974  CA  LYS   143      21.132  16.809  13.465  1.00 17.24          
ATOM    975  C   LYS   143      22.517  16.705  12.840  1.00 19.48          
ATOM    976  O   LYS   143      23.206  17.758  12.593  1.00 20.96          
ATOM    977  CB  LYS   143      21.246  16.696  14.945  1.00 18.19          
ATOM    978  CG  LYS   143      22.396  17.366  15.585  1.00 16.62          
ATOM    979  CD  LYS   143      22.112  17.500  17.025  1.00 17.82          
ATOM    980  CE  LYS   143      22.835  18.679  17.624  1.00 18.92          
ATOM    981  NZ  LYS   143      24.242  18.354  17.910  1.00 22.90          
ATOM    982  N   ALA   144      22.971  15.471  12.592  1.00 19.01          
ATOM    983  CA  ALA   144      24.229  15.316  11.921  1.00 18.19          
ATOM    984  C   ALA   144      24.198  15.976  10.551  1.00 18.75          
ATOM    985  O   ALA   144      25.170  16.556  10.065  1.00 20.71          
ATOM    986  CB  ALA   144      24.488  13.935  11.770  1.00 19.18          
ATOM    987  N   ALA   145      23.092  15.850   9.871  1.00 19.25          
ATOM    988  CA  ALA   145      22.936  16.461   8.549  1.00 18.85          
ATOM    989  C   ALA   145      23.077  17.966   8.699  1.00 18.61          
ATOM    990  O   ALA   145      23.931  18.553   7.996  1.00 17.90          
ATOM    991  CB  ALA   145      21.562  16.099   7.967  1.00 18.76          
ATOM    992  N   ALA   146      22.277  18.571   9.619  1.00 17.80          
ATOM    993  CA  ALA   146      22.363  20.043   9.869  1.00 18.04          
ATOM    994  C   ALA   146      23.815  20.449  10.094  1.00 18.51          
ATOM    995  O   ALA   146      24.307  21.417   9.470  1.00 19.27          
ATOM    996  CB  ALA   146      21.499  20.531  10.945  1.00 15.61          
ATOM    997  N   GLU   147      24.533  19.661  10.874  1.00 19.41          
ATOM    998  CA  GLU   147      25.971  19.938  11.053  1.00 21.68          
ATOM    999  C   GLU   147      26.876  19.824   9.829  1.00 20.89          
ATOM   1000  O   GLU   147      27.945  20.313   9.888  1.00 19.85          
ATOM   1001  CB  GLU   147      26.592  19.040  12.132  1.00 23.11          
ATOM   1002  CG  GLU   147      26.536  19.530  13.535  1.00 24.22          
ATOM   1003  CD  GLU   147      26.466  18.358  14.479  1.00 29.86          
ATOM   1004  OE1 GLU   147      25.673  18.527  15.426  1.00 35.07          
ATOM   1005  OE2 GLU   147      27.161  17.287  14.308  1.00 30.64          
ATOM   1006  N   CYS   148      26.483  19.123   8.785  1.00 22.37          
ATOM   1007  CA  CYS   148      27.398  18.832   7.656  1.00 24.38          
ATOM   1008  C   CYS   148      27.021  19.582   6.350  1.00 24.22          
ATOM   1009  O   CYS   148      27.660  19.406   5.319  1.00 25.63          
ATOM   1010  CB  CYS   148      27.470  17.303   7.426  1.00 23.85          
ATOM   1011  SG  CYS   148      28.622  16.453   8.559  1.00 31.79          
ATOM   1012  N   ALA   149      25.935  20.351   6.404  1.00 23.94          
ATOM   1013  CA  ALA   149      25.414  21.093   5.314  1.00 23.23          
ATOM   1014  C   ALA   149      25.914  22.531   5.509  1.00 24.24          
ATOM   1015  O   ALA   149      25.696  23.099   6.579  1.00 24.08          
ATOM   1016  CB  ALA   149      23.941  21.062   5.384  1.00 22.60          
ATOM   1017  N   PRO   150      26.578  23.128   4.483  1.00 25.66          
ATOM   1018  CA  PRO   150      26.808  24.603   4.437  1.00 24.43          
ATOM   1019  C   PRO   150      25.561  25.480   4.339  1.00 23.53          
ATOM   1020  O   PRO   150      25.708  26.683   4.463  1.00 25.61          
ATOM   1021  CB  PRO   150      27.668  24.818   3.170  1.00 22.89          
ATOM   1022  CG  PRO   150      27.554  23.590   2.334  1.00 23.95          
ATOM   1023  CD  PRO   150      27.174  22.475   3.274  1.00 26.29          
ATOM   1024  N   VAL   151      24.372  24.946   4.071  1.00 21.29          
ATOM   1025  CA  VAL   151      23.180  25.795   4.031  1.00 17.99          
ATOM   1026  C   VAL   151      22.162  24.971   4.742  1.00 18.46          
ATOM   1027  O   VAL   151      21.912  23.781   4.361  1.00 19.48          
ATOM   1028  CB  VAL   151      22.657  25.924   2.605  1.00 17.33          
ATOM   1029  CG1 VAL   151      21.255  26.558   2.549  1.00 14.93          
ATOM   1030  CG2 VAL   151      23.588  26.649   1.769  1.00 13.48          
ATOM   1031  N   VAL   152      21.534  25.569   5.736  1.00 16.17          
ATOM   1032  CA  VAL   152      20.536  24.866   6.539  1.00 13.98          
ATOM   1033  C   VAL   152      19.181  25.606   6.532  1.00 14.89          
ATOM   1034  O   VAL   152      19.049  26.764   6.996  1.00 14.57          
ATOM   1035  CB  VAL   152      21.050  24.798   7.996  1.00 12.99          
ATOM   1036  CG1 VAL   152      20.085  24.048   8.889  1.00 12.19          
ATOM   1037  CG2 VAL   152      22.326  24.184   7.987  1.00  9.30          
ATOM   1038  N   VAL   153      18.147  24.953   6.041  1.00 15.48          
ATOM   1039  CA  VAL   153      16.867  25.635   5.989  1.00 17.02          
ATOM   1040  C   VAL   153      15.963  25.140   7.136  1.00 18.29          
ATOM   1041  O   VAL   153      15.552  24.005   7.120  1.00 19.12          
ATOM   1042  CB  VAL   153      16.236  25.348   4.673  1.00 16.72          
ATOM   1043  CG1 VAL   153      14.927  26.090   4.559  1.00 18.64          
ATOM   1044  CG2 VAL   153      17.185  25.738   3.527  1.00 18.16          
ATOM   1045  N   ALA   154      15.638  25.950   8.129  1.00 18.91          
ATOM   1046  CA  ALA   154      14.904  25.394   9.234  1.00 19.52          
ATOM   1047  C   ALA   154      13.489  25.974   9.257  1.00 20.86          
ATOM   1048  O   ALA   154      13.367  27.202   9.222  1.00 22.16          
ATOM   1049  CB  ALA   154      15.557  25.748  10.464  1.00 19.46          
ATOM   1050  N   GLU   155      12.440  25.149   9.350  1.00 19.73          
ATOM   1051  CA  GLU   155      11.142  25.696   9.470  1.00 21.58          
ATOM   1052  C   GLU   155      11.021  25.869  10.919  1.00 19.47          
ATOM   1053  O   GLU   155      11.120  24.947  11.678  1.00 19.01          
ATOM   1054  CB  GLU   155      10.079  24.694   9.039  1.00 22.03          
ATOM   1055  CG  GLU   155       9.993  24.343   7.556  1.00 26.27          
ATOM   1056  CD  GLU   155       8.939  23.210   7.208  1.00 30.22          
ATOM   1057  OE1 GLU   155       8.976  22.709   6.010  1.00 42.45          
ATOM   1058  OE2 GLU   155       8.034  22.804   8.047  1.00 37.34          
ATOM   1059  N   VAL   156      10.796  27.078  11.352  1.00 21.02          
ATOM   1060  CA  VAL   156      10.622  27.332  12.800  1.00 21.50          
ATOM   1061  C   VAL   156       9.167  27.129  13.312  1.00 21.92          
ATOM   1062  O   VAL   156       8.252  27.892  13.008  1.00 21.03          
ATOM   1063  CB  VAL   156      11.225  28.674  13.196  1.00 21.55          
ATOM   1064  CG1 VAL   156      10.880  28.992  14.677  1.00 22.51          
ATOM   1065  CG2 VAL   156      12.727  28.613  12.926  1.00 16.93          
ATOM   1066  N   ASN   157       8.958  26.063  14.060  1.00 22.59          
ATOM   1067  CA  ASN   157       7.625  25.741  14.313  1.00 24.43          
ATOM   1068  C   ASN   157       7.226  26.050  15.753  1.00 26.39          
ATOM   1069  O   ASN   157       7.828  25.550  16.764  1.00 27.35          
ATOM   1070  CB  ASN   157       7.345  24.337  13.894  1.00 24.46          
ATOM   1071  CG  ASN   157       5.874  24.071  13.767  1.00 26.49          
ATOM   1072  OD1 ASN   157       5.034  24.852  14.287  1.00 28.44          
ATOM   1073  ND2 ASN   157       5.526  22.945  13.133  1.00 21.74          
ATOM   1074  N   LYS   158       6.239  26.960  15.825  1.00 27.58          
ATOM   1075  CA  LYS   158       5.632  27.380  17.105  1.00 28.93          
ATOM   1076  C   LYS   158       4.977  26.190  17.819  1.00 28.37          
ATOM   1077  O   LYS   158       4.887  26.195  19.027  1.00 27.48          
ATOM   1078  CB  LYS   158       4.718  28.631  16.978  1.00 28.34          
ATOM   1079  CG  LYS   158       5.611  29.909  17.015  1.00 30.85          
ATOM   1080  CD  LYS   158       4.948  31.311  17.260  1.00 30.90          
ATOM   1081  CE  LYS   158       5.969  32.508  17.006  1.00 31.70          
ATOM   1082  NZ  LYS   158       7.013  32.147  15.925  1.00 35.55          
ATOM   1083  N   GLN   159       4.606  25.151  17.055  1.00 28.17          
ATOM   1084  CA  GLN   159       4.067  23.923  17.606  1.00 27.02          
ATOM   1085  C   GLN   159       5.144  22.846  17.949  1.00 27.08          
ATOM   1086  O   GLN   159       4.848  21.918  18.739  1.00 27.82          
ATOM   1087  CB  GLN   159       3.078  23.313  16.614  1.00 27.34          
ATOM   1088  CG  GLN   159       1.703  22.996  17.150  1.00 27.80          
ATOM   1089  CD  GLN   159       0.772  24.031  16.653  1.00 33.22          
ATOM   1090  OE1 GLN   159      -0.370  23.755  16.203  1.00 33.35          
ATOM   1091  NE2 GLN   159       1.280  25.280  16.653  1.00 36.16          
ATOM   1092  N   MET   160       6.347  22.903  17.353  1.00 25.88          
ATOM   1093  CA  MET   160       7.386  21.845  17.611  1.00 25.34          
ATOM   1094  C   MET   160       7.778  21.930  19.071  1.00 24.46          
ATOM   1095  O   MET   160       8.170  23.003  19.496  1.00 26.22          
ATOM   1096  CB  MET   160       8.668  22.042  16.755  1.00 24.93          
ATOM   1097  CG  MET   160       9.740  20.980  17.040  1.00 24.68          
ATOM   1098  SD  MET   160       9.176  19.242  16.659  1.00 23.44          
ATOM   1099  CE  MET   160       9.043  19.227  14.917  1.00 19.19          
ATOM   1100  N   PRO   161       7.662  20.855  19.841  1.00 23.35          
ATOM   1101  CA  PRO   161       8.119  20.823  21.233  1.00 22.79          
ATOM   1102  C   PRO   161       9.625  21.005  21.437  1.00 22.30          
ATOM   1103  O   PRO   161      10.420  20.714  20.561  1.00 23.57          
ATOM   1104  CB  PRO   161       7.755  19.392  21.686  1.00 21.47          
ATOM   1105  CG  PRO   161       7.524  18.686  20.542  1.00 19.58          
ATOM   1106  CD  PRO   161       7.060  19.573  19.471  1.00 23.05          
ATOM   1107  N   PHE   162       9.990  21.426  22.622  1.00 21.22          
ATOM   1108  CA  PHE   162      11.339  21.685  22.930  1.00 21.01          
ATOM   1109  C   PHE   162      11.746  20.594  23.835  1.00 20.93          
ATOM   1110  O   PHE   162      11.219  20.503  24.944  1.00 21.80          
ATOM   1111  CB  PHE   162      11.466  23.011  23.703  1.00 20.75          
ATOM   1112  CG  PHE   162      12.899  23.533  23.791  1.00 19.93          
ATOM   1113  CD1 PHE   162      13.768  23.102  24.808  1.00 17.51          
ATOM   1114  CD2 PHE   162      13.381  24.433  22.859  1.00 17.17          
ATOM   1115  CE1 PHE   162      15.075  23.556  24.901  1.00 13.11          
ATOM   1116  CE2 PHE   162      14.696  24.890  22.959  1.00 15.14          
ATOM   1117  CZ  PHE   162      15.530  24.434  23.989  1.00 15.27          
ATOM   1118  N   ILE   163      12.751  19.848  23.393  1.00 20.22          
ATOM   1119  CA  ILE   163      13.323  18.717  24.091  1.00 19.54          
ATOM   1120  C   ILE   163      14.853  18.812  24.048  1.00 19.75          
ATOM   1121  O   ILE   163      15.481  19.251  23.033  1.00 21.15          
ATOM   1122  CB  ILE   163      12.900  17.476  23.333  1.00 20.43          
ATOM   1123  CG1 ILE   163      11.399  17.482  23.110  1.00 19.47          
ATOM   1124  CG2 ILE   163      13.442  16.181  23.976  1.00 20.22          
ATOM   1125  CD  ILE   163      11.029  16.242  22.508  1.00 21.66          
ATOM   1126  N   GLY   164      15.469  18.326  25.113  1.00 18.95          
ATOM   1127  CA  GLY   164      16.845  18.694  25.433  1.00 18.83          
ATOM   1128  C   GLY   164      17.693  17.518  25.152  1.00 19.30          
ATOM   1129  O   GLY   164      17.318  16.726  24.310  1.00 20.68          
ATOM   1130  N   GLY   165      18.788  17.359  25.885  1.00 19.83          
ATOM   1131  CA  GLY   165      19.840  16.463  25.462  1.00 21.72          
ATOM   1132  C   GLY   165      20.661  17.128  24.369  1.00 23.35          
ATOM   1133  O   GLY   165      20.704  18.358  24.256  1.00 24.93          
ATOM   1134  N   GLU   166      21.337  16.363  23.538  1.00 24.18          
ATOM   1135  CA  GLU   166      22.208  16.992  22.527  1.00 24.79          
ATOM   1136  C   GLU   166      21.375  17.280  21.318  1.00 24.31          
ATOM   1137  O   GLU   166      21.695  16.791  20.227  1.00 24.49          
ATOM   1138  CB  GLU   166      23.222  16.006  22.049  1.00 24.54          
ATOM   1139  CG  GLU   166      24.643  16.290  22.306  1.00 29.30          
ATOM   1140  CD  GLU   166      25.439  15.463  21.311  1.00 42.20          
ATOM   1141  OE1 GLU   166      25.175  15.546  20.046  1.00 41.81          
ATOM   1142  OE2 GLU   166      26.300  14.676  21.804  1.00 49.52          
ATOM   1143  N   ASN   167      20.326  18.080  21.509  1.00 23.27          
ATOM   1144  CA  ASN   167      19.279  18.257  20.542  1.00 21.97          
ATOM   1145  C   ASN   167      19.091  19.713  20.174  1.00 22.25          
ATOM   1146  O   ASN   167      17.977  20.139  19.849  1.00 25.00          
ATOM   1147  CB  ASN   167      17.979  17.780  21.169  1.00 21.48          
ATOM   1148  CG  ASN   167      17.001  17.363  20.138  1.00 21.78          
ATOM   1149  OD1 ASN   167      17.359  17.264  18.920  1.00 15.30          
ATOM   1150  ND2 ASN   167      15.754  17.147  20.568  1.00 19.59          
ATOM   1151  N   LEU   168      20.129  20.527  20.241  1.00 21.23          
ATOM   1152  CA  LEU   168      19.919  21.962  20.025  1.00 20.24          
ATOM   1153  C   LEU   168      20.632  22.419  18.782  1.00 19.92          
ATOM   1154  O   LEU   168      21.598  21.779  18.361  1.00 17.81          
ATOM   1155  CB  LEU   168      20.424  22.773  21.203  1.00 19.14          
ATOM   1156  CG  LEU   168      19.503  22.952  22.392  1.00 20.97          
ATOM   1157  CD1 LEU   168      18.606  21.740  22.630  1.00 16.95          
ATOM   1158  CD2 LEU   168      20.358  23.340  23.631  1.00 19.33          
ATOM   1159  N   ILE   169      20.183  23.553  18.242  1.00 20.20          
ATOM   1160  CA  ILE   169      20.900  24.196  17.166  1.00 21.27          
ATOM   1161  C   ILE   169      20.722  25.707  17.250  1.00 22.49          
ATOM   1162  O   ILE   169      19.613  26.255  17.411  1.00 23.19          
ATOM   1163  CB  ILE   169      20.421  23.586  15.830  1.00 21.73          
ATOM   1164  CG1 ILE   169      21.413  23.792  14.690  1.00 19.61          
ATOM   1165  CG2 ILE   169      18.925  24.009  15.476  1.00 23.60          
ATOM   1166  CD  ILE   169      21.421  25.127  14.212  1.00 22.53          
ATOM   1167  N   HSD   170      21.819  26.411  17.198  1.00 24.09          
ATOM   1168  CA  HSD   170      21.703  27.841  17.402  1.00 25.34          
ATOM   1169  C   HSD   170      21.152  28.538  16.170  1.00 25.98          
ATOM   1170  O   HSD   170      21.343  28.069  15.017  1.00 25.67          
ATOM   1171  CB  HSD   170      23.026  28.463  17.804  1.00 25.01          
ATOM   1172  CG  HSD   170      22.896  29.896  18.196  1.00 26.77          
ATOM   1173  ND1 HSD   170      22.530  30.292  19.466  1.00 28.68          
ATOM   1174  CD2 HSD   170      23.069  31.034  17.483  1.00 27.59          
ATOM   1175  CE1 HSD   170      22.492  31.611  19.518  1.00 26.52          
ATOM   1176  NE2 HSD   170      22.819  32.082  18.327  1.00 28.10          
ATOM   1177  N   ILE   171      20.485  29.674  16.440  1.00 25.94          
ATOM   1178  CA  ILE   171      19.861  30.502  15.397  1.00 25.57          
ATOM   1179  C   ILE   171      20.873  30.953  14.363  1.00 24.91          
ATOM   1180  O   ILE   171      20.562  31.022  13.200  1.00 24.88          
ATOM   1181  CB  ILE   171      18.923  31.654  16.007  1.00 25.97          
ATOM   1182  CG1 ILE   171      17.767  31.873  15.093  1.00 26.98          
ATOM   1183  CG2 ILE   171      19.541  33.035  16.219  1.00 27.16          
ATOM   1184  CD  ILE   171      16.891  30.707  15.149  1.00 32.18          
ATOM   1185  N   SER   172      22.105  31.202  14.791  1.00 24.61          
ATOM   1186  CA  SER   172      23.091  31.642  13.864  1.00 25.07          
ATOM   1187  C   SER   172      23.529  30.580  12.843  1.00 24.49          
ATOM   1188  O   SER   172      24.073  30.947  11.846  1.00 25.60          
ATOM   1189  CB  SER   172      24.212  32.523  14.520  1.00 26.28          
ATOM   1190  OG  SER   172      25.013  31.895  15.544  1.00 30.35          
ATOM   1191  N   LYS   173      23.195  29.297  13.012  1.00 23.99          
ATOM   1192  CA  LYS   173      23.615  28.229  12.029  1.00 23.35          
ATOM   1193  C   LYS   173      22.552  27.988  10.940  1.00 22.52          
ATOM   1194  O   LYS   173      22.690  27.140  10.007  1.00 23.10          
ATOM   1195  CB  LYS   173      24.044  26.900  12.756  1.00 22.36          
ATOM   1196  CG  LYS   173      25.030  27.120  13.971  1.00 22.97          
ATOM   1197  CD  LYS   173      26.385  27.955  13.580  1.00 20.95          
ATOM   1198  CE  LYS   173      27.133  28.515  14.803  1.00 25.64          
ATOM   1199  NZ  LYS   173      27.243  27.701  16.215  1.00 24.64          
ATOM   1200  N   LEU   174      21.485  28.752  11.073  1.00 21.22          
ATOM   1201  CA  LEU   174      20.372  28.700  10.153  1.00 20.49          
ATOM   1202  C   LEU   174      20.497  29.769   9.082  1.00 21.14          
ATOM   1203  O   LEU   174      20.691  30.910   9.380  1.00 21.36          
ATOM   1204  CB  LEU   174      19.072  28.899  10.942  1.00 20.44          
ATOM   1205  CG  LEU   174      18.450  27.694  11.686  1.00 16.86          
ATOM   1206  CD1 LEU   174      19.454  26.826  12.254  1.00 12.70          
ATOM   1207  CD2 LEU   174      17.457  28.134  12.773  1.00 17.70          
ATOM   1208  N   THR   175      20.439  29.370   7.828  1.00 22.22          
ATOM   1209  CA  THR   175      20.588  30.291   6.696  1.00 23.00          
ATOM   1210  C   THR   175      19.296  30.977   6.334  1.00 23.14          
ATOM   1211  O   THR   175      19.315  32.146   6.000  1.00 23.72          
ATOM   1212  CB  THR   175      20.965  29.494   5.460  1.00 22.65          
ATOM   1213  OG1 THR   175      22.027  28.627   5.802  1.00 25.26          
ATOM   1214  CG2 THR   175      21.563  30.342   4.418  1.00 21.90          
ATOM   1215  N   HSD   176      18.207  30.206   6.277  1.00 23.01          
ATOM   1216  CA  HSD   176      16.901  30.717   5.951  1.00 23.07          
ATOM   1217  C   HSD   176      15.949  30.152   7.005  1.00 22.90          
ATOM   1218  O   HSD   176      16.045  28.948   7.373  1.00 24.29          
ATOM   1219  CB  HSD   176      16.463  30.309   4.538  1.00 23.81          
ATOM   1220  CG  HSD   176      17.498  30.546   3.468  1.00 27.13          
ATOM   1221  ND1 HSD   176      18.397  29.570   3.062  1.00 29.55          
ATOM   1222  CD2 HSD   176      17.748  31.633   2.696  1.00 30.13          
ATOM   1223  CE1 HSD   176      19.177  30.059   2.116  1.00 30.17          
ATOM   1224  NE2 HSD   176      18.802  31.306   1.865  1.00 30.24          
ATOM   1225  N   ILE   177      15.072  31.011   7.539  1.00 20.90          
ATOM   1226  CA  ILE   177      14.152  30.558   8.564  1.00 18.66          
ATOM   1227  C   ILE   177      12.799  30.796   8.018  1.00 18.39          
ATOM   1228  O   ILE   177      12.513  31.881   7.551  1.00 18.22          
ATOM   1229  CB  ILE   177      14.319  31.412   9.857  1.00 19.00          
ATOM   1230  CG1 ILE   177      15.601  31.074  10.553  1.00 11.91          
ATOM   1231  CG2 ILE   177      13.120  31.248  10.874  1.00 18.55          
ATOM   1232  CD  ILE   177      15.889  32.145  11.418  1.00  9.72          
ATOM   1233  N   ILE   178      11.955  29.802   8.127  1.00 17.81          
ATOM   1234  CA  ILE   178      10.629  29.888   7.596  1.00 18.74          
ATOM   1235  C   ILE   178       9.738  29.767   8.810  1.00 21.69          
ATOM   1236  O   ILE   178       9.369  28.658   9.196  1.00 22.13          
ATOM   1237  CB  ILE   178      10.413  28.731   6.690  1.00 16.83          
ATOM   1238  CG1 ILE   178      11.358  28.877   5.529  1.00 17.27          
ATOM   1239  CG2 ILE   178       9.081  28.753   6.119  1.00 14.64          
ATOM   1240  CD  ILE   178      11.772  27.572   4.860  1.00 14.06          
ATOM   1241  N   GLU   179       9.410  30.894   9.457  1.00 24.72          
ATOM   1242  CA  GLU   179       8.565  30.779  10.664  1.00 26.88          
ATOM   1243  C   GLU   179       7.234  30.195  10.334  1.00 27.60          
ATOM   1244  O   GLU   179       6.545  30.728   9.514  1.00 29.85          
ATOM   1245  CB  GLU   179       8.336  32.048  11.494  1.00 25.33          
ATOM   1246  CG  GLU   179       8.683  33.362  10.939  1.00 28.80          
ATOM   1247  CD  GLU   179       9.133  34.214  12.103  1.00 35.59          
ATOM   1248  OE1 GLU   179       9.453  35.411  11.932  1.00 38.57          
ATOM   1249  OE2 GLU   179       9.144  33.661  13.224  1.00 34.98          
ATOM   1250  N   VAL   180       6.877  29.088  10.968  1.00 27.94          
ATOM   1251  CA  VAL   180       5.534  28.673  10.877  1.00 27.56          
ATOM   1252  C   VAL   180       4.913  28.191  12.117  1.00 27.81          
ATOM   1253  O   VAL   180       5.498  28.167  13.195  1.00 28.02          
ATOM   1254  CB  VAL   180       5.310  27.684   9.732  1.00 28.96          
ATOM   1255  CG1 VAL   180       5.174  28.527   8.383  1.00 30.60          
ATOM   1256  CG2 VAL   180       6.355  26.550   9.669  1.00 23.93          
ATOM   1257  N   ASP   181       3.656  27.896  11.911  1.00 28.30          
ATOM   1258  CA  ASP   181       2.774  27.396  12.894  1.00 29.52          
ATOM   1259  C   ASP   181       1.719  26.369  12.341  1.00 29.88          
ATOM   1260  O   ASP   181       0.933  26.655  11.380  1.00 31.11          
ATOM   1261  CB  ASP   181       2.120  28.540  13.605  1.00 29.39          
ATOM   1262  CG  ASP   181       1.391  28.053  14.781  1.00 32.09          
ATOM   1263  OD1 ASP   181       1.249  26.810  14.853  1.00 34.95          
ATOM   1264  OD2 ASP   181       0.933  28.775  15.675  1.00 35.01          
ATOM   1265  N   GLU   182       1.789  25.156  12.892  1.00 28.51          
ATOM   1266  CA  GLU   182       1.183  23.977  12.278  1.00 29.19          
ATOM   1267  C   GLU   182       1.492  22.736  13.147  1.00 27.43          
ATOM   1268  O   GLU   182       2.642  22.505  13.516  1.00 27.31          
ATOM   1269  CB  GLU   182       1.558  23.810  10.777  1.00 28.20          
ATOM   1270  CG  GLU   182       0.527  24.373   9.773  1.00 33.60          
ATOM   1271  CD  GLU   182       0.011  23.352   8.639  1.00 41.70          
ATOM   1272  OE1 GLU   182       0.791  22.459   8.057  1.00 40.51          
ATOM   1273  OE2 GLU   182      -1.234  23.467   8.265  1.00 47.22          
ATOM   1274  N   PRO   183       0.451  21.953  13.468  1.00 26.93          
ATOM   1275  CA  PRO   183       0.538  20.853  14.453  1.00 26.06          
ATOM   1276  C   PRO   183       1.398  19.678  13.954  1.00 26.46          
ATOM   1277  O   PRO   183       1.364  19.291  12.785  1.00 27.59          
ATOM   1278  CB  PRO   183      -0.904  20.390  14.576  1.00 26.28          
ATOM   1279  CG  PRO   183      -1.541  20.716  13.225  1.00 25.49          
ATOM   1280  CD  PRO   183      -0.893  22.019  12.835  1.00 26.25          
ATOM   1281  N   ILE   184       2.185  19.095  14.837  1.00 25.25          
ATOM   1282  CA  ILE   184       3.166  18.158  14.439  1.00 21.69          
ATOM   1283  C   ILE   184       2.447  16.897  14.044  1.00 21.73          
ATOM   1284  O   ILE   184       1.793  16.339  14.840  1.00 21.82          
ATOM   1285  CB  ILE   184       4.037  18.037  15.644  1.00 20.69          
ATOM   1286  CG1 ILE   184       4.833  19.343  15.748  1.00 17.79          
ATOM   1287  CG2 ILE   184       4.862  16.748  15.620  1.00 21.71          
ATOM   1288  CD  ILE   184       6.123  19.386  14.936  1.00  8.23          
ATOM   1289  N   ALA   185       2.534  16.464  12.797  1.00 22.39          
ATOM   1290  CA  ALA   185       1.879  15.219  12.385  1.00 23.14          
ATOM   1291  C   ALA   185       1.835  14.233  13.486  1.00 23.75          
ATOM   1292  O   ALA   185       2.816  14.061  14.220  1.00 21.62          
ATOM   1293  CB  ALA   185       2.632  14.564  11.264  1.00 23.84          
ATOM   1294  N   GLU   186       0.713  13.544  13.570  1.00 25.90          
ATOM   1295  CA  GLU   186       0.520  12.574  14.673  1.00 29.21          
ATOM   1296  C   GLU   186       0.348  11.172  14.153  1.00 28.23          
ATOM   1297  O   GLU   186      -0.203  11.027  13.115  1.00 28.76          
ATOM   1298  CB  GLU   186      -0.662  12.992  15.595  1.00 29.75          
ATOM   1299  CG  GLU   186      -1.960  13.486  14.933  1.00 31.19          
ATOM   1300  CD  GLU   186      -2.910  14.152  15.940  1.00 32.80          
ATOM   1301  OE1 GLU   186      -3.557  15.151  15.525  1.00 39.05          
ATOM   1302  OE2 GLU   186      -3.015  13.716  17.158  1.00 36.29          
END
