
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   98 (  976),  selected   98 , name 1aps_A
# Molecule2: number of CA atoms   76 ( 1151),  selected   76 , name T0437.pdb
# PARAMETERS: 1aps_A.T0437.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     1_A      -       -           -
LGA    T     2_A      D      24           #
LGA    A     3_A      N      25           -
LGA    R     4_A      -       -           -
LGA    P     5_A      -       -           -
LGA    L     6_A      -       -           -
LGA    K     7_A      C      26          0.753
LGA    S     8_A      T      27          1.698
LGA    V     9_A      S      28          2.405
LGA    D    10_A      K      29          1.948
LGA    Y    11_A      F      30          2.143
LGA    E    12_A      S      31          0.996
LGA    V    13_A      R      32          1.093
LGA    F    14_A      F      33          1.940
LGA    G    15_A      F      34          1.730
LGA    R    16_A      A      35          4.479
LGA    V    17_A      T      36          4.339
LGA    Q    18_A      R      37          3.904
LGA    -       -      E      38           -
LGA    G    19_A      E      39          2.219
LGA    V    20_A      A      40          3.440
LGA    -       -      E      41           -
LGA    C    21_A      S      42          1.675
LGA    F    22_A      F      43          1.226
LGA    R    23_A      M      44          2.588
LGA    M    24_A      T      45          2.263
LGA    Y    25_A      K      46          1.253
LGA    A    26_A      L      47          1.355
LGA    E    27_A      K      48          1.410
LGA    D    28_A      E      49          2.491
LGA    E    29_A      L      50          2.041
LGA    A    30_A      A      51          0.392
LGA    R    31_A      A      52          1.522
LGA    K    32_A      A      53          1.623
LGA    I    33_A      A      54          0.727
LGA    G    34_A      S      55          0.794
LGA    -       -      S      56           -
LGA    -       -      A      57           -
LGA    -       -      D      58           -
LGA    -       -      E      59           -
LGA    V    35_A      G      60          4.987
LGA    V    36_A      A      61          1.223
LGA    G    37_A      S      62          2.455
LGA    W    38_A      V      63          2.099
LGA    -       -      A      64           -
LGA    V    39_A      Y      65          2.486
LGA    K    40_A      K      66          2.111
LGA    N    41_A      I      67          1.995
LGA    T    42_A      K      68          1.935
LGA    S    43_A      D      69          0.689
LGA    K    44_A      L      70          3.393
LGA    -       -      E      71           -
LGA    -       -      G      72           -
LGA    -       -      Q      73           -
LGA    G    45_A      V      74          2.251
LGA    T    46_A      E      75          1.087
LGA    V    47_A      L      76          0.746
LGA    T    48_A      D      77          0.635
LGA    G    49_A      A      78          2.279
LGA    Q    50_A      A      79          0.999
LGA    V    51_A      F      80          1.144
LGA    Q    52_A      T      81          1.246
LGA    G    53_A      F      82          1.223
LGA    P    54_A      S      83          3.492
LGA    -       -      C      84           -
LGA    E    55_A      Q      85          0.954
LGA    E    56_A      A      86          0.842
LGA    K    57_A      E      87          0.592
LGA    V    58_A      M      88          0.412
LGA    N    59_A      I      89          0.740
LGA    S    60_A      I      90          1.031
LGA    M    61_A      F      91          1.020
LGA    K    62_A      E      92          0.857
LGA    S    63_A      L      93          1.045
LGA    W    64_A      S      94          2.564
LGA    L    65_A      L      95          2.674
LGA    S    66_A      R      96          3.129
LGA    K    67_A      S      97          3.125
LGA    V    68_A      L      98          3.706
LGA    G    69_A      A      99          4.721
LGA    S    70_A      -       -           -
LGA    P    71_A      -       -           -
LGA    S    72_A      -       -           -
LGA    S    73_A      -       -           -
LGA    R    74_A      -       -           -
LGA    I    75_A      -       -           -
LGA    D    76_A      -       -           -
LGA    R    77_A      -       -           -
LGA    T    78_A      -       -           -
LGA    N    79_A      -       -           -
LGA    F    80_A      -       -           -
LGA    S    81_A      -       -           -
LGA    N    82_A      -       -           -
LGA    E    83_A      -       -           -
LGA    K    84_A      -       -           -
LGA    T    85_A      -       -           -
LGA    I    86_A      -       -           -
LGA    S    87_A      -       -           -
LGA    K    88_A      -       -           -
LGA    L    89_A      -       -           -
LGA    E    90_A      -       -           -
LGA    Y    91_A      -       -           -
LGA    S    92_A      -       -           -
LGA    N    93_A      -       -           -
LGA    F    94_A      -       -           -
LGA    S    95_A      -       -           -
LGA    V    96_A      -       -           -
LGA    R    97_A      -       -           -
LGA    Y    98_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   98   76    5.0     63    2.21     7.94     66.341     2.723

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.756437 * X  +  -0.566305 * Y  +   0.327264 * Z  +  -5.976730
  Y_new =  -0.610265 * X  +  -0.791104 * Y  +   0.041618 * Z  +  -0.369096
  Z_new =   0.235331 * X  +  -0.231199 * Y  +  -0.944016 * Z  +  -1.477635 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.901410    0.240183  [ DEG:  -166.2385     13.7615 ]
  Theta =  -0.237559   -2.904033  [ DEG:   -13.6112   -166.3888 ]
  Phi   =  -0.678851    2.462742  [ DEG:   -38.8953    141.1047 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1aps_A                                        
REMARK     2: T0437.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1aps_A.T0437.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   98   76   5.0   63   2.21    7.94  66.341
REMARK  ---------------------------------------------------------- 
MOLECULE 1aps_A
HEADER    HYDROLASE(ACTING ON ACID ANHYDRIDES)    20-FEB-91   1APS              
TITLE     THREE-DIMENSIONAL STRUCTURE OF ACYLPHOSPHATASE. REFINEMENT            
TITLE    2 AND STRUCTURE ANALYSIS                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ACYLPHOSPHATASE;                                           
COMPND   3 CHAIN: A;                                                            
COMPND   4 EC: 3.6.1.7;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: EQUUS CABALLUS                                  
KEYWDS    HYDROLASE(ACTING ON ACID ANHYDRIDES)                                  
EXPDTA    NMR, 5 STRUCTURES                                                     
AUTHOR    V.SAUDEK,A.PASTORE,G.RAMPONI,R.J.P.WILLIAMS                           
REVDAT   2   01-APR-03 1APS    1       JRNL                                     
REVDAT   1   15-JUL-92 1APS    0                                                
JRNL        AUTH   A.PASTORE,V.SAUDEK,G.RAMPONI,R.J.WILLIAMS                    
JRNL        TITL   THREE-DIMENSIONAL STRUCTURE OF ACYLPHOSPHATASE.              
JRNL        TITL 2 REFINEMENT AND STRUCTURE ANALYSIS.                           
JRNL        REF    J.MOL.BIOL.                   V. 224   427 1992              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1APS A    1    98  UNP    P00818   ACYP2_HORSE      1     98             
SEQRES   1 A   98  SER THR ALA ARG PRO LEU LYS SER VAL ASP TYR GLU VAL          
SEQRES   2 A   98  PHE GLY ARG VAL GLN GLY VAL CYS PHE ARG MET TYR ALA          
SEQRES   3 A   98  GLU ASP GLU ALA ARG LYS ILE GLY VAL VAL GLY TRP VAL          
SEQRES   4 A   98  LYS ASN THR SER LYS GLY THR VAL THR GLY GLN VAL GLN          
SEQRES   5 A   98  GLY PRO GLU GLU LYS VAL ASN SER MET LYS SER TRP LEU          
SEQRES   6 A   98  SER LYS VAL GLY SER PRO SER SER ARG ILE ASP ARG THR          
SEQRES   7 A   98  ASN PHE SER ASN GLU LYS THR ILE SER LYS LEU GLU TYR          
SEQRES   8 A   98  SER ASN PHE SER VAL ARG TYR                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   SER A   1      -5.073 -16.381  13.077  1.00  0.00           N  
ATOM      2  CA  SER A   1      -5.107 -15.312  14.087  1.00  0.00           C  
ATOM      3  C   SER A   1      -3.895 -14.377  14.061  1.00  0.00           C  
ATOM      4  O   SER A   1      -2.871 -14.675  13.438  1.00  0.00           O  
ATOM      5  CB  SER A   1      -5.301 -15.898  15.487  1.00  0.00           C  
ATOM      6  OG  SER A   1      -4.073 -16.329  16.074  1.00  0.00           O  
ATOM      7  HG  SER A   1      -3.534 -16.800  15.371  1.00  0.00           H  
ATOM      8  H1  SER A   1      -4.987 -15.951  12.172  1.00  0.00           H  
ATOM      9  H2  SER A   1      -4.286 -16.973  13.217  1.00  0.00           H  
ATOM     10  H3  SER A   1      -5.927 -16.903  13.107  1.00  0.00           H  
ATOM     11  N   THR A   2      -3.962 -13.384  14.939  1.00  0.00           N  
ATOM     12  CA  THR A   2      -2.985 -12.302  15.114  1.00  0.00           C  
ATOM     13  C   THR A   2      -1.512 -12.716  15.257  1.00  0.00           C  
ATOM     14  O   THR A   2      -0.630 -11.962  14.843  1.00  0.00           O  
ATOM     15  CB  THR A   2      -3.347 -11.484  16.359  1.00  0.00           C  
ATOM     16  OG1 THR A   2      -3.647 -12.392  17.433  1.00  0.00           O  
ATOM     17  CG2 THR A   2      -4.501 -10.521  16.107  1.00  0.00           C  
ATOM     18  H   THR A   2      -4.677 -13.379  15.634  1.00  0.00           H  
ATOM     19  HG1 THR A   2      -3.665 -11.886  18.297  1.00  0.00           H  
ATOM     20  N   ALA A   3      -1.275 -13.873  15.870  1.00  0.00           N  
ATOM     21  CA  ALA A   3       0.053 -14.485  16.007  1.00  0.00           C  
ATOM     22  C   ALA A   3       0.837 -14.625  14.694  1.00  0.00           C  
ATOM     23  O   ALA A   3       2.059 -14.730  14.700  1.00  0.00           O  
ATOM     24  CB  ALA A   3      -0.090 -15.844  16.681  1.00  0.00           C  
ATOM     25  H   ALA A   3      -2.022 -14.359  16.331  1.00  0.00           H  
ATOM     26  N   ARG A   4       0.107 -14.649  13.582  1.00  0.00           N  
ATOM     27  CA  ARG A   4       0.663 -14.699  12.216  1.00  0.00           C  
ATOM     28  C   ARG A   4       0.743 -13.298  11.595  1.00  0.00           C  
ATOM     29  O   ARG A   4      -0.294 -12.647  11.476  1.00  0.00           O  
ATOM     30  CB  ARG A   4      -0.203 -15.625  11.366  1.00  0.00           C  
ATOM     31  CG  ARG A   4       0.209 -17.096  11.454  1.00  0.00           C  
ATOM     32  CD  ARG A   4      -0.142 -17.796  12.764  1.00  0.00           C  
ATOM     33  NE  ARG A   4      -1.551 -18.223  12.786  1.00  0.00           N  
ATOM     34  CZ  ARG A   4      -2.308 -18.394  13.883  1.00  0.00           C  
ATOM     35  NH1 ARG A   4      -1.824 -18.331  15.123  1.00  0.00           N  
ATOM     36  NH2 ARG A   4      -3.580 -18.816  13.731  1.00  0.00           N  
ATOM     37  H   ARG A   4      -0.884 -14.583  13.623  1.00  0.00           H  
ATOM     38  HE  ARG A   4      -1.926 -18.533  11.912  1.00  0.00           H  
ATOM     39 HH11 ARG A   4      -0.846 -18.170  15.247  1.00  0.00           H  
ATOM     40 HH12 ARG A   4      -2.409 -18.487  15.920  1.00  0.00           H  
ATOM     41 HH21 ARG A   4      -3.915 -19.071  12.830  1.00  0.00           H  
ATOM     42 HH22 ARG A   4      -4.156 -18.956  14.541  1.00  0.00           H  
ATOM     43  N   PRO A   5       1.930 -12.831  11.244  1.00  0.00           N  
ATOM     44  CA  PRO A   5       2.125 -11.537  10.574  1.00  0.00           C  
ATOM     45  C   PRO A   5       1.662 -11.511   9.112  1.00  0.00           C  
ATOM     46  O   PRO A   5       2.420 -11.247   8.168  1.00  0.00           O  
ATOM     47  CB  PRO A   5       3.613 -11.213  10.712  1.00  0.00           C  
ATOM     48  CG  PRO A   5       4.041 -12.029  11.936  1.00  0.00           C  
ATOM     49  CD  PRO A   5       3.212 -13.312  11.783  1.00  0.00           C  
ATOM     50  N   LEU A   6       0.373 -11.779   8.949  1.00  0.00           N  
ATOM     51  CA  LEU A   6      -0.409 -11.703   7.707  1.00  0.00           C  
ATOM     52  C   LEU A   6      -1.596 -10.779   7.972  1.00  0.00           C  
ATOM     53  O   LEU A   6      -2.520 -11.116   8.706  1.00  0.00           O  
ATOM     54  CB  LEU A   6      -0.909 -13.086   7.261  1.00  0.00           C  
ATOM     55  CG  LEU A   6       0.204 -13.942   6.645  1.00  0.00           C  
ATOM     56  CD1 LEU A   6       0.925 -14.769   7.706  1.00  0.00           C  
ATOM     57  CD2 LEU A   6      -0.406 -14.885   5.608  1.00  0.00           C  
ATOM     58  H   LEU A   6      -0.175 -12.037   9.744  1.00  0.00           H  
ATOM     59  N   LYS A   7      -1.504  -9.591   7.399  1.00  0.00           N  
ATOM     60  CA  LYS A   7      -2.401  -8.477   7.773  1.00  0.00           C  
ATOM     61  C   LYS A   7      -3.448  -8.173   6.703  1.00  0.00           C  
ATOM     62  O   LYS A   7      -3.127  -7.818   5.569  1.00  0.00           O  
ATOM     63  CB  LYS A   7      -1.552  -7.233   8.059  1.00  0.00           C  
ATOM     64  CG  LYS A   7      -2.234  -6.324   9.081  1.00  0.00           C  
ATOM     65  CD  LYS A   7      -1.331  -5.130   9.404  1.00  0.00           C  
ATOM     66  CE  LYS A   7      -1.810  -4.442  10.687  1.00  0.00           C  
ATOM     67  NZ  LYS A   7      -1.068  -3.192  10.862  1.00  0.00           N  
ATOM     68  H   LYS A   7      -0.982  -9.444   6.570  1.00  0.00           H  
ATOM     69  HZ1 LYS A   7      -0.088  -3.394  10.886  1.00  0.00           H  
ATOM     70  HZ2 LYS A   7      -1.253  -2.563  10.116  1.00  0.00           H  
ATOM     71  HZ3 LYS A   7      -1.329  -2.782  11.743  1.00  0.00           H  
ATOM     72  N   SER A   8      -4.696  -8.462   7.073  1.00  0.00           N  
ATOM     73  CA  SER A   8      -5.867  -8.009   6.317  1.00  0.00           C  
ATOM     74  C   SER A   8      -6.293  -6.596   6.719  1.00  0.00           C  
ATOM     75  O   SER A   8      -6.624  -6.302   7.867  1.00  0.00           O  
ATOM     76  CB  SER A   8      -7.058  -8.977   6.317  1.00  0.00           C  
ATOM     77  OG  SER A   8      -7.272  -9.545   7.616  1.00  0.00           O  
ATOM     78  H   SER A   8      -4.901  -8.987   7.901  1.00  0.00           H  
ATOM     79  HG  SER A   8      -7.197  -8.840   8.308  1.00  0.00           H  
ATOM     80  N   VAL A   9      -5.930  -5.722   5.781  1.00  0.00           N  
ATOM     81  CA  VAL A   9      -6.114  -4.270   5.803  1.00  0.00           C  
ATOM     82  C   VAL A   9      -7.179  -3.910   4.761  1.00  0.00           C  
ATOM     83  O   VAL A   9      -7.285  -4.520   3.691  1.00  0.00           O  
ATOM     84  CB  VAL A   9      -4.787  -3.591   5.466  1.00  0.00           C  
ATOM     85  CG1 VAL A   9      -4.877  -2.062   5.386  1.00  0.00           C  
ATOM     86  CG2 VAL A   9      -3.685  -3.952   6.468  1.00  0.00           C  
ATOM     87  H   VAL A   9      -5.500  -6.065   4.951  1.00  0.00           H  
ATOM     88  N   ASP A  10      -7.979  -2.912   5.121  1.00  0.00           N  
ATOM     89  CA  ASP A  10      -8.955  -2.291   4.217  1.00  0.00           C  
ATOM     90  C   ASP A  10      -8.518  -0.884   3.826  1.00  0.00           C  
ATOM     91  O   ASP A  10      -7.871  -0.152   4.581  1.00  0.00           O  
ATOM     92  CB  ASP A  10     -10.349  -2.264   4.857  1.00  0.00           C  
ATOM     93  CG  ASP A  10     -10.927  -3.676   5.008  1.00  0.00           C  
ATOM     94  OD1 ASP A  10     -11.593  -4.119   4.047  1.00  0.00           O  
ATOM     95  OD2 ASP A  10     -10.733  -4.260   6.098  1.00  0.00           O  
ATOM     96  H   ASP A  10      -7.915  -2.515   6.029  1.00  0.00           H  
ATOM     97  N   TYR A  11      -8.792  -0.582   2.558  1.00  0.00           N  
ATOM     98  CA  TYR A  11      -8.501   0.726   1.954  1.00  0.00           C  
ATOM     99  C   TYR A  11      -9.771   1.394   1.437  1.00  0.00           C  
ATOM    100  O   TYR A  11     -10.836   0.785   1.370  1.00  0.00           O  
ATOM    101  CB  TYR A  11      -7.454   0.565   0.848  1.00  0.00           C  
ATOM    102  CG  TYR A  11      -7.934  -0.196  -0.390  1.00  0.00           C  
ATOM    103  CD1 TYR A  11      -7.869  -1.593  -0.397  1.00  0.00           C  
ATOM    104  CD2 TYR A  11      -8.416   0.527  -1.468  1.00  0.00           C  
ATOM    105  CE1 TYR A  11      -8.312  -2.277  -1.513  1.00  0.00           C  
ATOM    106  CE2 TYR A  11      -8.861  -0.164  -2.596  1.00  0.00           C  
ATOM    107  CZ  TYR A  11      -8.807  -1.556  -2.596  1.00  0.00           C  
ATOM    108  OH  TYR A  11      -9.216  -2.214  -3.710  1.00  0.00           O  
ATOM    109  H   TYR A  11      -9.211  -1.255   1.949  1.00  0.00           H  
ATOM    110  HH  TYR A  11      -9.318  -3.190  -3.491  1.00  0.00           H  
ATOM    111  N   GLU A  12      -9.661   2.714   1.279  1.00  0.00           N  
ATOM    112  CA  GLU A  12     -10.656   3.533   0.568  1.00  0.00           C  
ATOM    113  C   GLU A  12     -10.004   4.683  -0.204  1.00  0.00           C  
ATOM    114  O   GLU A  12      -9.291   5.516   0.345  1.00  0.00           O  
ATOM    115  CB  GLU A  12     -11.723   4.055   1.524  1.00  0.00           C  
ATOM    116  CG  GLU A  12     -12.931   4.588   0.758  1.00  0.00           C  
ATOM    117  CD  GLU A  12     -14.120   4.893   1.673  1.00  0.00           C  
ATOM    118  OE1 GLU A  12     -14.164   6.024   2.195  1.00  0.00           O  
ATOM    119  OE2 GLU A  12     -14.984   3.999   1.789  1.00  0.00           O  
ATOM    120  H   GLU A  12      -8.921   3.223   1.706  1.00  0.00           H  
ATOM    121  N   VAL A  13     -10.191   4.582  -1.523  1.00  0.00           N  
ATOM    122  CA  VAL A  13      -9.873   5.607  -2.522  1.00  0.00           C  
ATOM    123  C   VAL A  13     -11.120   6.494  -2.672  1.00  0.00           C  
ATOM    124  O   VAL A  13     -12.184   6.041  -3.103  1.00  0.00           O  
ATOM    125  CB  VAL A  13      -9.502   5.018  -3.882  1.00  0.00           C  
ATOM    126  CG1 VAL A  13      -9.032   6.114  -4.846  1.00  0.00           C  
ATOM    127  CG2 VAL A  13      -8.408   3.954  -3.783  1.00  0.00           C  
ATOM    128  H   VAL A  13     -10.541   3.734  -1.915  1.00  0.00           H  
ATOM    129  N   PHE A  14     -10.904   7.780  -2.413  1.00  0.00           N  
ATOM    130  CA  PHE A  14     -11.934   8.824  -2.428  1.00  0.00           C  
ATOM    131  C   PHE A  14     -12.156   9.382  -3.836  1.00  0.00           C  
ATOM    132  O   PHE A  14     -11.799  10.514  -4.171  1.00  0.00           O  
ATOM    133  CB  PHE A  14     -11.524   9.903  -1.412  1.00  0.00           C  
ATOM    134  CG  PHE A  14     -11.610   9.404   0.030  1.00  0.00           C  
ATOM    135  CD1 PHE A  14     -12.814   9.499   0.708  1.00  0.00           C  
ATOM    136  CD2 PHE A  14     -10.489   8.844   0.627  1.00  0.00           C  
ATOM    137  CE1 PHE A  14     -12.911   9.012   2.008  1.00  0.00           C  
ATOM    138  CE2 PHE A  14     -10.584   8.342   1.928  1.00  0.00           C  
ATOM    139  CZ  PHE A  14     -11.789   8.438   2.605  1.00  0.00           C  
ATOM    140  H   PHE A  14      -9.981   8.098  -2.217  1.00  0.00           H  
ATOM    141  N   GLY A  15     -12.773   8.533  -4.649  1.00  0.00           N  
ATOM    142  CA  GLY A  15     -13.212   8.854  -6.016  1.00  0.00           C  
ATOM    143  C   GLY A  15     -14.607   9.493  -5.995  1.00  0.00           C  
ATOM    144  O   GLY A  15     -15.570   8.890  -6.461  1.00  0.00           O  
ATOM    145  H   GLY A  15     -12.885   7.576  -4.391  1.00  0.00           H  
ATOM    146  N   ARG A  16     -14.621  10.748  -5.542  1.00  0.00           N  
ATOM    147  CA  ARG A  16     -15.821  11.564  -5.307  1.00  0.00           C  
ATOM    148  C   ARG A  16     -16.990  11.303  -6.264  1.00  0.00           C  
ATOM    149  O   ARG A  16     -18.085  10.956  -5.812  1.00  0.00           O  
ATOM    150  CB  ARG A  16     -15.493  13.064  -5.275  1.00  0.00           C  
ATOM    151  CG  ARG A  16     -14.862  13.560  -3.976  1.00  0.00           C  
ATOM    152  CD  ARG A  16     -13.359  13.315  -3.878  1.00  0.00           C  
ATOM    153  NE  ARG A  16     -12.817  13.991  -2.676  1.00  0.00           N  
ATOM    154  CZ  ARG A  16     -11.526  14.082  -2.341  1.00  0.00           C  
ATOM    155  NH1 ARG A  16     -10.578  13.324  -2.893  1.00  0.00           N  
ATOM    156  NH2 ARG A  16     -11.179  14.796  -1.267  1.00  0.00           N  
ATOM    157  H   ARG A  16     -13.760  11.173  -5.256  1.00  0.00           H  
ATOM    158  HE  ARG A  16     -13.498  14.393  -2.078  1.00  0.00           H  
ATOM    159 HH11 ARG A  16     -10.842  12.601  -3.535  1.00  0.00           H  
ATOM    160 HH12 ARG A  16      -9.620  13.434  -2.630  1.00  0.00           H  
ATOM    161 HH21 ARG A  16     -11.870  15.268  -0.713  1.00  0.00           H  
ATOM    162 HH22 ARG A  16     -10.204  14.858  -1.011  1.00  0.00           H  
ATOM    163  N   VAL A  17     -16.757  11.487  -7.552  1.00  0.00           N  
ATOM    164  CA  VAL A  17     -17.744  11.143  -8.588  1.00  0.00           C  
ATOM    165  C   VAL A  17     -17.096  10.208  -9.612  1.00  0.00           C  
ATOM    166  O   VAL A  17     -16.623  10.633 -10.668  1.00  0.00           O  
ATOM    167  CB  VAL A  17     -18.343  12.395  -9.238  1.00  0.00           C  
ATOM    168  CG1 VAL A  17     -19.472  12.032 -10.207  1.00  0.00           C  
ATOM    169  CG2 VAL A  17     -18.936  13.366  -8.214  1.00  0.00           C  
ATOM    170  H   VAL A  17     -15.886  11.847  -7.891  1.00  0.00           H  
ATOM    171  N   GLN A  18     -16.891   8.960  -9.172  1.00  0.00           N  
ATOM    172  CA  GLN A  18     -16.352   7.860  -9.976  1.00  0.00           C  
ATOM    173  C   GLN A  18     -15.013   8.168 -10.675  1.00  0.00           C  
ATOM    174  O   GLN A  18     -14.094   8.602  -9.998  1.00  0.00           O  
ATOM    175  CB  GLN A  18     -17.426   7.248 -10.873  1.00  0.00           C  
ATOM    176  CG  GLN A  18     -18.302   6.239 -10.120  1.00  0.00           C  
ATOM    177  CD  GLN A  18     -18.767   5.103 -11.020  1.00  0.00           C  
ATOM    178  OE1 GLN A  18     -18.084   4.658 -11.947  1.00  0.00           O  
ATOM    179  NE2 GLN A  18     -19.905   4.500 -10.710  1.00  0.00           N  
ATOM    180  H   GLN A  18     -16.934   8.778  -8.188  1.00  0.00           H  
ATOM    181 HE21 GLN A  18     -20.398   4.764  -9.884  1.00  0.00           H  
ATOM    182 HE22 GLN A  18     -20.213   3.757 -11.305  1.00  0.00           H  
ATOM    183  N   GLY A  19     -14.855   7.736 -11.921  1.00  0.00           N  
ATOM    184  CA  GLY A  19     -13.674   8.008 -12.760  1.00  0.00           C  
ATOM    185  C   GLY A  19     -12.432   7.164 -12.483  1.00  0.00           C  
ATOM    186  O   GLY A  19     -11.633   6.906 -13.382  1.00  0.00           O  
ATOM    187  H   GLY A  19     -15.587   7.243 -12.376  1.00  0.00           H  
ATOM    188  N   VAL A  20     -12.194   6.886 -11.205  1.00  0.00           N  
ATOM    189  CA  VAL A  20     -11.079   6.097 -10.673  1.00  0.00           C  
ATOM    190  C   VAL A  20     -10.912   4.698 -11.270  1.00  0.00           C  
ATOM    191  O   VAL A  20     -11.426   3.688 -10.794  1.00  0.00           O  
ATOM    192  CB  VAL A  20     -11.070   6.046  -9.136  1.00  0.00           C  
ATOM    193  CG1 VAL A  20     -10.393   7.296  -8.582  1.00  0.00           C  
ATOM    194  CG2 VAL A  20     -12.433   5.799  -8.497  1.00  0.00           C  
ATOM    195  H   VAL A  20     -12.759   7.326 -10.502  1.00  0.00           H  
ATOM    196  N   CYS A  21      -9.957   4.654 -12.202  1.00  0.00           N  
ATOM    197  CA  CYS A  21      -9.565   3.428 -12.904  1.00  0.00           C  
ATOM    198  C   CYS A  21      -8.369   2.814 -12.177  1.00  0.00           C  
ATOM    199  O   CYS A  21      -7.209   3.185 -12.394  1.00  0.00           O  
ATOM    200  CB  CYS A  21      -9.257   3.750 -14.372  1.00  0.00           C  
ATOM    201  SG  CYS A  21     -10.727   4.340 -15.300  1.00  0.00           S  
ATOM    202  H   CYS A  21      -9.401   5.456 -12.418  1.00  0.00           H  
ATOM    203  HG  CYS A  21     -11.014   5.360 -14.496  1.00  0.00           H  
ATOM    204  N   PHE A  22      -8.745   2.224 -11.052  1.00  0.00           N  
ATOM    205  CA  PHE A  22      -7.865   1.490 -10.133  1.00  0.00           C  
ATOM    206  C   PHE A  22      -7.542   0.084 -10.612  1.00  0.00           C  
ATOM    207  O   PHE A  22      -6.471  -0.462 -10.329  1.00  0.00           O  
ATOM    208  CB  PHE A  22      -8.603   1.487  -8.789  1.00  0.00           C  
ATOM    209  CG  PHE A  22      -7.743   1.029  -7.600  1.00  0.00           C  
ATOM    210  CD1 PHE A  22      -6.868   1.934  -7.003  1.00  0.00           C  
ATOM    211  CD2 PHE A  22      -7.972  -0.221  -7.046  1.00  0.00           C  
ATOM    212  CE1 PHE A  22      -6.224   1.583  -5.820  1.00  0.00           C  
ATOM    213  CE2 PHE A  22      -7.333  -0.580  -5.866  1.00  0.00           C  
ATOM    214  CZ  PHE A  22      -6.469   0.331  -5.261  1.00  0.00           C  
ATOM    215  H   PHE A  22      -9.668   2.414 -10.696  1.00  0.00           H  
ATOM    216  N   ARG A  23      -8.489  -0.489 -11.348  1.00  0.00           N  
ATOM    217  CA  ARG A  23      -8.390  -1.812 -11.996  1.00  0.00           C  
ATOM    218  C   ARG A  23      -7.119  -1.999 -12.825  1.00  0.00           C  
ATOM    219  O   ARG A  23      -6.529  -1.036 -13.330  1.00  0.00           O  
ATOM    220  CB  ARG A  23      -9.620  -2.017 -12.866  1.00  0.00           C  
ATOM    221  CG  ARG A  23     -10.915  -2.219 -12.074  1.00  0.00           C  
ATOM    222  CD  ARG A  23     -10.972  -3.566 -11.348  1.00  0.00           C  
ATOM    223  NE  ARG A  23     -10.861  -4.703 -12.271  1.00  0.00           N  
ATOM    224  CZ  ARG A  23     -11.838  -5.237 -13.025  1.00  0.00           C  
ATOM    225  NH1 ARG A  23     -13.111  -4.825 -12.961  1.00  0.00           N  
ATOM    226  NH2 ARG A  23     -11.514  -6.110 -13.989  1.00  0.00           N  
ATOM    227  H   ARG A  23      -9.363  -0.030 -11.514  1.00  0.00           H  
ATOM    228  HE  ARG A  23      -9.962  -5.131 -12.317  1.00  0.00           H  
ATOM    229 HH11 ARG A  23     -13.351  -4.035 -12.395  1.00  0.00           H  
ATOM    230 HH12 ARG A  23     -13.804  -5.263 -13.527  1.00  0.00           H  
ATOM    231 HH21 ARG A  23     -10.556  -6.337 -14.175  1.00  0.00           H  
ATOM    232 HH22 ARG A  23     -12.246  -6.510 -14.547  1.00  0.00           H  
ATOM    233  N   MET A  24      -6.753  -3.263 -12.987  1.00  0.00           N  
ATOM    234  CA  MET A  24      -5.512  -3.753 -13.616  1.00  0.00           C  
ATOM    235  C   MET A  24      -4.226  -3.369 -12.888  1.00  0.00           C  
ATOM    236  O   MET A  24      -3.554  -4.240 -12.334  1.00  0.00           O  
ATOM    237  CB  MET A  24      -5.419  -3.409 -15.105  1.00  0.00           C  
ATOM    238  CG  MET A  24      -6.393  -4.215 -15.976  1.00  0.00           C  
ATOM    239  SD  MET A  24      -8.170  -3.834 -15.738  1.00  0.00           S  
ATOM    240  CE  MET A  24      -8.898  -5.042 -16.827  1.00  0.00           C  
ATOM    241  H   MET A  24      -7.398  -3.985 -12.744  1.00  0.00           H  
ATOM    242  N   TYR A  25      -4.035  -2.066 -12.712  1.00  0.00           N  
ATOM    243  CA  TYR A  25      -2.966  -1.426 -11.942  1.00  0.00           C  
ATOM    244  C   TYR A  25      -2.788  -2.104 -10.576  1.00  0.00           C  
ATOM    245  O   TYR A  25      -1.736  -2.681 -10.311  1.00  0.00           O  
ATOM    246  CB  TYR A  25      -3.353   0.049 -11.800  1.00  0.00           C  
ATOM    247  CG  TYR A  25      -2.371   0.891 -10.988  1.00  0.00           C  
ATOM    248  CD1 TYR A  25      -1.099   1.141 -11.499  1.00  0.00           C  
ATOM    249  CD2 TYR A  25      -2.784   1.410  -9.762  1.00  0.00           C  
ATOM    250  CE1 TYR A  25      -0.217   1.926 -10.767  1.00  0.00           C  
ATOM    251  CE2 TYR A  25      -1.902   2.195  -9.030  1.00  0.00           C  
ATOM    252  CZ  TYR A  25      -0.635   2.437  -9.544  1.00  0.00           C  
ATOM    253  OH  TYR A  25       0.266   3.182  -8.850  1.00  0.00           O  
ATOM    254  H   TYR A  25      -4.709  -1.423 -13.087  1.00  0.00           H  
ATOM    255  HH  TYR A  25      -0.108   3.455  -7.961  1.00  0.00           H  
ATOM    256  N   ALA A  26      -3.891  -2.159  -9.848  1.00  0.00           N  
ATOM    257  CA  ALA A  26      -4.040  -2.889  -8.587  1.00  0.00           C  
ATOM    258  C   ALA A  26      -3.623  -4.353  -8.708  1.00  0.00           C  
ATOM    259  O   ALA A  26      -2.490  -4.683  -8.362  1.00  0.00           O  
ATOM    260  CB  ALA A  26      -5.480  -2.726  -8.083  1.00  0.00           C  
ATOM    261  H   ALA A  26      -4.690  -1.604 -10.090  1.00  0.00           H  
ATOM    262  N   GLU A  27      -4.412  -5.126  -9.450  1.00  0.00           N  
ATOM    263  CA  GLU A  27      -4.223  -6.556  -9.733  1.00  0.00           C  
ATOM    264  C   GLU A  27      -2.773  -6.981  -9.970  1.00  0.00           C  
ATOM    265  O   GLU A  27      -2.132  -7.591  -9.107  1.00  0.00           O  
ATOM    266  CB  GLU A  27      -5.086  -6.970 -10.919  1.00  0.00           C  
ATOM    267  CG  GLU A  27      -6.590  -7.059 -10.650  1.00  0.00           C  
ATOM    268  CD  GLU A  27      -7.363  -5.758 -10.914  1.00  0.00           C  
ATOM    269  OE1 GLU A  27      -7.100  -4.750 -10.206  1.00  0.00           O  
ATOM    270  OE2 GLU A  27      -8.085  -5.717 -11.925  1.00  0.00           O  
ATOM    271  H   GLU A  27      -5.269  -4.743  -9.783  1.00  0.00           H  
ATOM    272  N   ASP A  28      -2.206  -6.429 -11.041  1.00  0.00           N  
ATOM    273  CA  ASP A  28      -0.867  -6.742 -11.565  1.00  0.00           C  
ATOM    274  C   ASP A  28       0.263  -6.393 -10.597  1.00  0.00           C  
ATOM    275  O   ASP A  28       1.013  -7.274 -10.196  1.00  0.00           O  
ATOM    276  CB  ASP A  28      -0.678  -6.042 -12.910  1.00  0.00           C  
ATOM    277  CG  ASP A  28      -1.564  -6.629 -14.005  1.00  0.00           C  
ATOM    278  OD1 ASP A  28      -2.747  -6.219 -14.069  1.00  0.00           O  
ATOM    279  OD2 ASP A  28      -1.066  -7.520 -14.730  1.00  0.00           O  
ATOM    280  H   ASP A  28      -2.694  -5.698 -11.528  1.00  0.00           H  
ATOM    281  N   GLU A  29       0.268  -5.149 -10.106  1.00  0.00           N  
ATOM    282  CA  GLU A  29       1.288  -4.687  -9.170  1.00  0.00           C  
ATOM    283  C   GLU A  29       1.196  -5.330  -7.780  1.00  0.00           C  
ATOM    284  O   GLU A  29       2.215  -5.761  -7.244  1.00  0.00           O  
ATOM    285  CB  GLU A  29       1.317  -3.162  -9.051  1.00  0.00           C  
ATOM    286  CG  GLU A  29       1.935  -2.519 -10.302  1.00  0.00           C  
ATOM    287  CD  GLU A  29       1.966  -0.987 -10.255  1.00  0.00           C  
ATOM    288  OE1 GLU A  29       2.136  -0.419  -9.155  1.00  0.00           O  
ATOM    289  OE2 GLU A  29       1.837  -0.408 -11.355  1.00  0.00           O  
ATOM    290  H   GLU A  29      -0.465  -4.493 -10.299  1.00  0.00           H  
ATOM    291  N   ALA A  30      -0.025  -5.566  -7.313  1.00  0.00           N  
ATOM    292  CA  ALA A  30      -0.299  -6.270  -6.051  1.00  0.00           C  
ATOM    293  C   ALA A  30       0.204  -7.715  -6.057  1.00  0.00           C  
ATOM    294  O   ALA A  30       0.826  -8.163  -5.098  1.00  0.00           O  
ATOM    295  CB  ALA A  30      -1.794  -6.222  -5.752  1.00  0.00           C  
ATOM    296  H   ALA A  30      -0.842  -5.236  -7.783  1.00  0.00           H  
ATOM    297  N   ARG A  31      -0.002  -8.388  -7.186  1.00  0.00           N  
ATOM    298  CA  ARG A  31       0.614  -9.690  -7.485  1.00  0.00           C  
ATOM    299  C   ARG A  31       2.133  -9.626  -7.316  1.00  0.00           C  
ATOM    300  O   ARG A  31       2.676 -10.356  -6.492  1.00  0.00           O  
ATOM    301  CB  ARG A  31       0.201 -10.107  -8.896  1.00  0.00           C  
ATOM    302  CG  ARG A  31       0.900 -11.376  -9.378  1.00  0.00           C  
ATOM    303  CD  ARG A  31       0.604 -11.642 -10.858  1.00  0.00           C  
ATOM    304  NE  ARG A  31       1.697 -12.473 -11.385  1.00  0.00           N  
ATOM    305  CZ  ARG A  31       1.893 -12.807 -12.666  1.00  0.00           C  
ATOM    306  NH1 ARG A  31       1.037 -12.476 -13.648  1.00  0.00           N  
ATOM    307  NH2 ARG A  31       3.076 -13.333 -13.031  1.00  0.00           N  
ATOM    308  H   ARG A  31      -0.663  -8.073  -7.856  1.00  0.00           H  
ATOM    309  HE  ARG A  31       2.336 -12.827 -10.702  1.00  0.00           H  
ATOM    310 HH11 ARG A  31       0.200 -11.983 -13.418  1.00  0.00           H  
ATOM    311 HH12 ARG A  31       1.231 -12.745 -14.588  1.00  0.00           H  
ATOM    312 HH21 ARG A  31       3.817 -13.423 -12.376  1.00  0.00           H  
ATOM    313 HH22 ARG A  31       3.216 -13.595 -13.990  1.00  0.00           H  
ATOM    314  N   LYS A  32       2.768  -8.643  -7.953  1.00  0.00           N  
ATOM    315  CA  LYS A  32       4.217  -8.410  -7.885  1.00  0.00           C  
ATOM    316  C   LYS A  32       4.739  -8.107  -6.483  1.00  0.00           C  
ATOM    317  O   LYS A  32       5.812  -8.567  -6.110  1.00  0.00           O  
ATOM    318  CB  LYS A  32       4.631  -7.301  -8.847  1.00  0.00           C  
ATOM    319  CG  LYS A  32       4.234  -7.537 -10.309  1.00  0.00           C  
ATOM    320  CD  LYS A  32       4.854  -8.803 -10.912  1.00  0.00           C  
ATOM    321  CE  LYS A  32       4.314  -9.095 -12.310  1.00  0.00           C  
ATOM    322  NZ  LYS A  32       2.906  -9.507 -12.254  1.00  0.00           N  
ATOM    323  H   LYS A  32       2.263  -8.035  -8.578  1.00  0.00           H  
ATOM    324  HZ1 LYS A  32       2.356  -8.788 -11.809  1.00  0.00           H  
ATOM    325  HZ2 LYS A  32       2.557  -9.657 -13.176  1.00  0.00           H  
ATOM    326  HZ3 LYS A  32       2.812 -10.360 -11.742  1.00  0.00           H  
ATOM    327  N   ILE A  33       3.979  -7.316  -5.727  1.00  0.00           N  
ATOM    328  CA  ILE A  33       4.223  -7.021  -4.305  1.00  0.00           C  
ATOM    329  C   ILE A  33       4.163  -8.290  -3.449  1.00  0.00           C  
ATOM    330  O   ILE A  33       4.929  -8.433  -2.501  1.00  0.00           O  
ATOM    331  CB  ILE A  33       3.248  -5.946  -3.822  1.00  0.00           C  
ATOM    332  CG1 ILE A  33       3.355  -4.621  -4.595  1.00  0.00           C  
ATOM    333  CG2 ILE A  33       3.298  -5.678  -2.310  1.00  0.00           C  
ATOM    334  CD1 ILE A  33       4.739  -3.991  -4.691  1.00  0.00           C  
ATOM    335  H   ILE A  33       3.251  -6.773  -6.146  1.00  0.00           H  
ATOM    336  N   GLY A  34       3.292  -9.223  -3.835  1.00  0.00           N  
ATOM    337  CA  GLY A  34       3.043 -10.489  -3.129  1.00  0.00           C  
ATOM    338  C   GLY A  34       1.796 -10.449  -2.246  1.00  0.00           C  
ATOM    339  O   GLY A  34       1.765 -11.056  -1.172  1.00  0.00           O  
ATOM    340  H   GLY A  34       2.854  -9.164  -4.736  1.00  0.00           H  
ATOM    341  N   VAL A  35       0.755  -9.756  -2.714  1.00  0.00           N  
ATOM    342  CA  VAL A  35      -0.503  -9.611  -1.990  1.00  0.00           C  
ATOM    343  C   VAL A  35      -1.750 -10.089  -2.750  1.00  0.00           C  
ATOM    344  O   VAL A  35      -1.854 -10.100  -3.973  1.00  0.00           O  
ATOM    345  CB  VAL A  35      -0.724  -8.212  -1.390  1.00  0.00           C  
ATOM    346  CG1 VAL A  35       0.309  -7.890  -0.308  1.00  0.00           C  
ATOM    347  CG2 VAL A  35      -0.753  -7.113  -2.443  1.00  0.00           C  
ATOM    348  H   VAL A  35       0.798  -9.275  -3.600  1.00  0.00           H  
ATOM    349  N   VAL A  36      -2.743 -10.357  -1.909  1.00  0.00           N  
ATOM    350  CA  VAL A  36      -4.039 -10.976  -2.195  1.00  0.00           C  
ATOM    351  C   VAL A  36      -5.162 -10.071  -1.676  1.00  0.00           C  
ATOM    352  O   VAL A  36      -4.951  -9.226  -0.803  1.00  0.00           O  
ATOM    353  CB  VAL A  36      -3.953 -12.340  -1.505  1.00  0.00           C  
ATOM    354  CG1 VAL A  36      -5.271 -13.003  -1.112  1.00  0.00           C  
ATOM    355  CG2 VAL A  36      -3.103 -13.319  -2.313  1.00  0.00           C  
ATOM    356  H   VAL A  36      -2.642 -10.105  -0.942  1.00  0.00           H  
ATOM    357  N   GLY A  37      -6.346 -10.212  -2.273  1.00  0.00           N  
ATOM    358  CA  GLY A  37      -7.561  -9.484  -1.878  1.00  0.00           C  
ATOM    359  C   GLY A  37      -8.416  -9.111  -3.090  1.00  0.00           C  
ATOM    360  O   GLY A  37      -8.426  -9.807  -4.099  1.00  0.00           O  
ATOM    361  H   GLY A  37      -6.458 -10.779  -3.088  1.00  0.00           H  
ATOM    362  N   TRP A  38      -9.043  -7.933  -2.991  1.00  0.00           N  
ATOM    363  CA  TRP A  38     -10.024  -7.448  -3.977  1.00  0.00           C  
ATOM    364  C   TRP A  38     -10.377  -5.961  -3.875  1.00  0.00           C  
ATOM    365  O   TRP A  38     -10.039  -5.256  -2.921  1.00  0.00           O  
ATOM    366  CB  TRP A  38     -11.303  -8.285  -3.949  1.00  0.00           C  
ATOM    367  CG  TRP A  38     -11.980  -8.416  -2.579  1.00  0.00           C  
ATOM    368  CD1 TRP A  38     -11.703  -9.396  -1.721  1.00  0.00           C  
ATOM    369  CD2 TRP A  38     -13.105  -7.746  -2.113  1.00  0.00           C  
ATOM    370  NE1 TRP A  38     -12.609  -9.387  -0.742  1.00  0.00           N  
ATOM    371  CE2 TRP A  38     -13.483  -8.401  -0.938  1.00  0.00           C  
ATOM    372  CE3 TRP A  38     -13.873  -6.710  -2.609  1.00  0.00           C  
ATOM    373  CZ2 TRP A  38     -14.609  -8.016  -0.231  1.00  0.00           C  
ATOM    374  CZ3 TRP A  38     -15.013  -6.327  -1.907  1.00  0.00           C  
ATOM    375  CH2 TRP A  38     -15.379  -6.966  -0.727  1.00  0.00           C  
ATOM    376  H   TRP A  38      -8.805  -7.292  -2.265  1.00  0.00           H  
ATOM    377  HE1 TRP A  38     -12.683 -10.087  -0.025  1.00  0.00           H  
ATOM    378  N   VAL A  39     -11.062  -5.529  -4.930  1.00  0.00           N  
ATOM    379  CA  VAL A  39     -11.603  -4.176  -5.121  1.00  0.00           C  
ATOM    380  C   VAL A  39     -13.125  -4.232  -4.963  1.00  0.00           C  
ATOM    381  O   VAL A  39     -13.788  -5.158  -5.446  1.00  0.00           O  
ATOM    382  CB  VAL A  39     -11.210  -3.684  -6.510  1.00  0.00           C  
ATOM    383  CG1 VAL A  39     -11.823  -2.327  -6.885  1.00  0.00           C  
ATOM    384  CG2 VAL A  39      -9.696  -3.594  -6.723  1.00  0.00           C  
ATOM    385  H   VAL A  39     -11.307  -6.150  -5.667  1.00  0.00           H  
ATOM    386  N   LYS A  40     -13.656  -3.253  -4.246  1.00  0.00           N  
ATOM    387  CA  LYS A  40     -15.094  -3.012  -4.056  1.00  0.00           C  
ATOM    388  C   LYS A  40     -15.474  -1.667  -4.700  1.00  0.00           C  
ATOM    389  O   LYS A  40     -15.023  -0.591  -4.295  1.00  0.00           O  
ATOM    390  CB  LYS A  40     -15.438  -3.012  -2.565  1.00  0.00           C  
ATOM    391  CG  LYS A  40     -16.947  -2.937  -2.280  1.00  0.00           C  
ATOM    392  CD  LYS A  40     -17.186  -2.994  -0.766  1.00  0.00           C  
ATOM    393  CE  LYS A  40     -18.621  -2.652  -0.368  1.00  0.00           C  
ATOM    394  NZ  LYS A  40     -19.564  -3.716  -0.774  1.00  0.00           N  
ATOM    395  H   LYS A  40     -13.062  -2.607  -3.757  1.00  0.00           H  
ATOM    396  HZ1 LYS A  40     -19.508  -3.833  -1.766  1.00  0.00           H  
ATOM    397  HZ2 LYS A  40     -19.303  -4.564  -0.329  1.00  0.00           H  
ATOM    398  HZ3 LYS A  40     -20.495  -3.471  -0.503  1.00  0.00           H  
ATOM    399  N   ASN A  41     -16.291  -1.817  -5.732  1.00  0.00           N  
ATOM    400  CA  ASN A  41     -16.845  -0.710  -6.521  1.00  0.00           C  
ATOM    401  C   ASN A  41     -18.216  -0.309  -5.962  1.00  0.00           C  
ATOM    402  O   ASN A  41     -19.125  -1.117  -5.814  1.00  0.00           O  
ATOM    403  CB  ASN A  41     -16.969  -1.102  -7.990  1.00  0.00           C  
ATOM    404  CG  ASN A  41     -17.863  -2.323  -8.237  1.00  0.00           C  
ATOM    405  OD1 ASN A  41     -17.624  -3.431  -7.758  1.00  0.00           O  
ATOM    406  ND2 ASN A  41     -18.948  -2.137  -8.987  1.00  0.00           N  
ATOM    407  H   ASN A  41     -16.659  -2.709  -5.973  1.00  0.00           H  
ATOM    408 HD21 ASN A  41     -19.187  -1.228  -9.347  1.00  0.00           H  
ATOM    409 HD22 ASN A  41     -19.519  -2.936  -9.135  1.00  0.00           H  
ATOM    410  N   THR A  42     -18.274   0.948  -5.534  1.00  0.00           N  
ATOM    411  CA  THR A  42     -19.513   1.545  -5.016  1.00  0.00           C  
ATOM    412  C   THR A  42     -20.192   2.377  -6.115  1.00  0.00           C  
ATOM    413  O   THR A  42     -19.648   2.604  -7.188  1.00  0.00           O  
ATOM    414  CB  THR A  42     -19.199   2.483  -3.849  1.00  0.00           C  
ATOM    415  OG1 THR A  42     -18.433   3.570  -4.383  1.00  0.00           O  
ATOM    416  CG2 THR A  42     -18.512   1.787  -2.677  1.00  0.00           C  
ATOM    417  H   THR A  42     -17.462   1.536  -5.471  1.00  0.00           H  
ATOM    418  HG1 THR A  42     -17.912   3.964  -3.634  1.00  0.00           H  
ATOM    419  N   SER A  43     -21.328   2.952  -5.732  1.00  0.00           N  
ATOM    420  CA  SER A  43     -22.067   3.941  -6.527  1.00  0.00           C  
ATOM    421  C   SER A  43     -21.238   5.180  -6.873  1.00  0.00           C  
ATOM    422  O   SER A  43     -21.015   5.464  -8.044  1.00  0.00           O  
ATOM    423  CB  SER A  43     -23.324   4.351  -5.758  1.00  0.00           C  
ATOM    424  OG  SER A  43     -22.956   4.669  -4.419  1.00  0.00           O  
ATOM    425  H   SER A  43     -21.730   2.786  -4.829  1.00  0.00           H  
ATOM    426  HG  SER A  43     -23.729   5.100  -3.959  1.00  0.00           H  
ATOM    427  N   LYS A  44     -20.654   5.790  -5.849  1.00  0.00           N  
ATOM    428  CA  LYS A  44     -19.936   7.065  -5.957  1.00  0.00           C  
ATOM    429  C   LYS A  44     -18.410   6.958  -5.783  1.00  0.00           C  
ATOM    430  O   LYS A  44     -17.831   7.496  -4.848  1.00  0.00           O  
ATOM    431  CB  LYS A  44     -20.548   8.083  -5.002  1.00  0.00           C  
ATOM    432  CG  LYS A  44     -21.963   8.482  -5.411  1.00  0.00           C  
ATOM    433  CD  LYS A  44     -22.583   9.457  -4.418  1.00  0.00           C  
ATOM    434  CE  LYS A  44     -24.016   9.818  -4.825  1.00  0.00           C  
ATOM    435  NZ  LYS A  44     -24.589  10.771  -3.869  1.00  0.00           N  
ATOM    436  H   LYS A  44     -20.760   5.429  -4.917  1.00  0.00           H  
ATOM    437  HZ1 LYS A  44     -24.014  11.591  -3.845  1.00  0.00           H  
ATOM    438  HZ2 LYS A  44     -25.510  11.031  -4.145  1.00  0.00           H  
ATOM    439  HZ3 LYS A  44     -24.600  10.358  -2.948  1.00  0.00           H  
ATOM    440  N   GLY A  45     -17.850   6.004  -6.531  1.00  0.00           N  
ATOM    441  CA  GLY A  45     -16.420   5.848  -6.816  1.00  0.00           C  
ATOM    442  C   GLY A  45     -15.437   5.628  -5.658  1.00  0.00           C  
ATOM    443  O   GLY A  45     -14.229   5.691  -5.851  1.00  0.00           O  
ATOM    444  H   GLY A  45     -18.425   5.276  -6.911  1.00  0.00           H  
ATOM    445  N   THR A  46     -15.967   5.524  -4.438  1.00  0.00           N  
ATOM    446  CA  THR A  46     -15.213   5.080  -3.253  1.00  0.00           C  
ATOM    447  C   THR A  46     -14.760   3.621  -3.393  1.00  0.00           C  
ATOM    448  O   THR A  46     -15.441   2.674  -3.025  1.00  0.00           O  
ATOM    449  CB  THR A  46     -16.038   5.272  -1.973  1.00  0.00           C  
ATOM    450  OG1 THR A  46     -17.370   4.841  -2.210  1.00  0.00           O  
ATOM    451  CG2 THR A  46     -16.001   6.720  -1.483  1.00  0.00           C  
ATOM    452  H   THR A  46     -16.842   5.955  -4.245  1.00  0.00           H  
ATOM    453  HG1 THR A  46     -17.860   4.884  -1.330  1.00  0.00           H  
ATOM    454  N   VAL A  47     -13.630   3.509  -4.087  1.00  0.00           N  
ATOM    455  CA  VAL A  47     -12.959   2.243  -4.387  1.00  0.00           C  
ATOM    456  C   VAL A  47     -12.253   1.736  -3.126  1.00  0.00           C  
ATOM    457  O   VAL A  47     -11.262   2.279  -2.653  1.00  0.00           O  
ATOM    458  CB  VAL A  47     -12.058   2.362  -5.616  1.00  0.00           C  
ATOM    459  CG1 VAL A  47     -11.173   1.139  -5.850  1.00  0.00           C  
ATOM    460  CG2 VAL A  47     -12.906   2.578  -6.875  1.00  0.00           C  
ATOM    461  H   VAL A  47     -13.205   4.329  -4.475  1.00  0.00           H  
ATOM    462  N   THR A  48     -13.041   0.896  -2.473  1.00  0.00           N  
ATOM    463  CA  THR A  48     -12.696   0.197  -1.229  1.00  0.00           C  
ATOM    464  C   THR A  48     -12.335  -1.260  -1.539  1.00  0.00           C  
ATOM    465  O   THR A  48     -12.121  -1.606  -2.698  1.00  0.00           O  
ATOM    466  CB  THR A  48     -13.808   0.413  -0.196  1.00  0.00           C  
ATOM    467  OG1 THR A  48     -13.526  -0.273   1.026  1.00  0.00           O  
ATOM    468  CG2 THR A  48     -15.230   0.119  -0.681  1.00  0.00           C  
ATOM    469  H   THR A  48     -13.938   0.652  -2.858  1.00  0.00           H  
ATOM    470  HG1 THR A  48     -12.749   0.184   1.453  1.00  0.00           H  
ATOM    471  N   GLY A  49     -12.206  -2.082  -0.514  1.00  0.00           N  
ATOM    472  CA  GLY A  49     -11.842  -3.503  -0.609  1.00  0.00           C  
ATOM    473  C   GLY A  49     -10.794  -3.936   0.424  1.00  0.00           C  
ATOM    474  O   GLY A  49     -10.362  -3.154   1.275  1.00  0.00           O  
ATOM    475  H   GLY A  49     -12.454  -1.770   0.410  1.00  0.00           H  
ATOM    476  N   GLN A  50     -10.237  -5.103   0.110  1.00  0.00           N  
ATOM    477  CA  GLN A  50      -9.394  -5.885   1.025  1.00  0.00           C  
ATOM    478  C   GLN A  50      -8.013  -6.184   0.441  1.00  0.00           C  
ATOM    479  O   GLN A  50      -7.889  -6.563  -0.729  1.00  0.00           O  
ATOM    480  CB  GLN A  50     -10.096  -7.199   1.359  1.00  0.00           C  
ATOM    481  CG  GLN A  50     -11.253  -6.997   2.333  1.00  0.00           C  
ATOM    482  CD  GLN A  50     -12.180  -8.192   2.510  1.00  0.00           C  
ATOM    483  OE1 GLN A  50     -11.913  -9.349   2.181  1.00  0.00           O  
ATOM    484  NE2 GLN A  50     -13.378  -7.925   3.017  1.00  0.00           N  
ATOM    485  H   GLN A  50     -10.245  -5.413  -0.839  1.00  0.00           H  
ATOM    486 HE21 GLN A  50     -13.606  -6.985   3.298  1.00  0.00           H  
ATOM    487 HE22 GLN A  50     -14.015  -8.682   3.144  1.00  0.00           H  
ATOM    488  N   VAL A  51      -7.005  -5.909   1.269  1.00  0.00           N  
ATOM    489  CA  VAL A  51      -5.590  -6.225   1.046  1.00  0.00           C  
ATOM    490  C   VAL A  51      -5.141  -7.145   2.189  1.00  0.00           C  
ATOM    491  O   VAL A  51      -5.059  -6.731   3.338  1.00  0.00           O  
ATOM    492  CB  VAL A  51      -4.710  -4.978   1.025  1.00  0.00           C  
ATOM    493  CG1 VAL A  51      -3.253  -5.309   0.711  1.00  0.00           C  
ATOM    494  CG2 VAL A  51      -5.181  -3.939   0.007  1.00  0.00           C  
ATOM    495  H   VAL A  51      -7.176  -5.388   2.112  1.00  0.00           H  
ATOM    496  N   GLN A  52      -4.924  -8.409   1.827  1.00  0.00           N  
ATOM    497  CA  GLN A  52      -4.305  -9.428   2.675  1.00  0.00           C  
ATOM    498  C   GLN A  52      -2.946  -9.766   2.061  1.00  0.00           C  
ATOM    499  O   GLN A  52      -2.842 -10.048   0.867  1.00  0.00           O  
ATOM    500  CB  GLN A  52      -5.137 -10.711   2.743  1.00  0.00           C  
ATOM    501  CG  GLN A  52      -5.139 -11.400   4.110  1.00  0.00           C  
ATOM    502  CD  GLN A  52      -3.796 -11.636   4.788  1.00  0.00           C  
ATOM    503  OE1 GLN A  52      -3.105 -10.742   5.268  1.00  0.00           O  
ATOM    504  NE2 GLN A  52      -3.407 -12.889   5.048  1.00  0.00           N  
ATOM    505  H   GLN A  52      -5.065  -8.687   0.876  1.00  0.00           H  
ATOM    506 HE21 GLN A  52      -4.032 -13.659   4.935  1.00  0.00           H  
ATOM    507 HE22 GLN A  52      -2.513 -12.994   5.470  1.00  0.00           H  
ATOM    508  N   GLY A  53      -1.930  -9.769   2.911  1.00  0.00           N  
ATOM    509  CA  GLY A  53      -0.545 -10.096   2.540  1.00  0.00           C  
ATOM    510  C   GLY A  53       0.351 -10.299   3.764  1.00  0.00           C  
ATOM    511  O   GLY A  53      -0.006  -9.844   4.857  1.00  0.00           O  
ATOM    512  H   GLY A  53      -2.086  -9.587   3.882  1.00  0.00           H  
ATOM    513  N   PRO A  54       1.465 -10.997   3.600  1.00  0.00           N  
ATOM    514  CA  PRO A  54       2.514 -11.038   4.629  1.00  0.00           C  
ATOM    515  C   PRO A  54       3.047  -9.630   4.908  1.00  0.00           C  
ATOM    516  O   PRO A  54       3.086  -8.778   4.016  1.00  0.00           O  
ATOM    517  CB  PRO A  54       3.601 -11.955   4.065  1.00  0.00           C  
ATOM    518  CG  PRO A  54       2.797 -12.916   3.182  1.00  0.00           C  
ATOM    519  CD  PRO A  54       1.717 -12.015   2.572  1.00  0.00           C  
ATOM    520  N   GLU A  55       3.338  -9.387   6.174  1.00  0.00           N  
ATOM    521  CA  GLU A  55       3.711  -8.079   6.753  1.00  0.00           C  
ATOM    522  C   GLU A  55       4.499  -7.140   5.849  1.00  0.00           C  
ATOM    523  O   GLU A  55       3.955  -6.144   5.376  1.00  0.00           O  
ATOM    524  CB  GLU A  55       4.410  -8.337   8.085  1.00  0.00           C  
ATOM    525  CG  GLU A  55       4.456  -7.086   8.972  1.00  0.00           C  
ATOM    526  CD  GLU A  55       5.262  -7.366  10.246  1.00  0.00           C  
ATOM    527  OE1 GLU A  55       6.498  -7.205  10.173  1.00  0.00           O  
ATOM    528  OE2 GLU A  55       4.622  -7.756  11.246  1.00  0.00           O  
ATOM    529  H   GLU A  55       3.172 -10.100   6.858  1.00  0.00           H  
ATOM    530  N   GLU A  56       5.725  -7.510   5.495  1.00  0.00           N  
ATOM    531  CA  GLU A  56       6.584  -6.703   4.610  1.00  0.00           C  
ATOM    532  C   GLU A  56       5.943  -6.273   3.284  1.00  0.00           C  
ATOM    533  O   GLU A  56       6.038  -5.105   2.903  1.00  0.00           O  
ATOM    534  CB  GLU A  56       7.950  -7.375   4.387  1.00  0.00           C  
ATOM    535  CG  GLU A  56       7.996  -8.656   3.552  1.00  0.00           C  
ATOM    536  CD  GLU A  56       7.160  -9.795   4.133  1.00  0.00           C  
ATOM    537  OE1 GLU A  56       7.569 -10.322   5.195  1.00  0.00           O  
ATOM    538  OE2 GLU A  56       6.010  -9.959   3.664  1.00  0.00           O  
ATOM    539  H   GLU A  56       6.152  -8.314   5.904  1.00  0.00           H  
ATOM    540  N   LYS A  57       5.133  -7.163   2.731  1.00  0.00           N  
ATOM    541  CA  LYS A  57       4.411  -6.958   1.462  1.00  0.00           C  
ATOM    542  C   LYS A  57       3.251  -5.966   1.602  1.00  0.00           C  
ATOM    543  O   LYS A  57       3.176  -5.015   0.823  1.00  0.00           O  
ATOM    544  CB  LYS A  57       3.936  -8.308   0.931  1.00  0.00           C  
ATOM    545  CG  LYS A  57       5.143  -9.201   0.600  1.00  0.00           C  
ATOM    546  CD  LYS A  57       4.742 -10.648   0.302  1.00  0.00           C  
ATOM    547  CE  LYS A  57       5.951 -11.534  -0.017  1.00  0.00           C  
ATOM    548  NZ  LYS A  57       6.576 -11.118  -1.286  1.00  0.00           N  
ATOM    549  H   LYS A  57       4.913  -8.033   3.178  1.00  0.00           H  
ATOM    550  HZ1 LYS A  57       5.908 -11.168  -2.029  1.00  0.00           H  
ATOM    551  HZ2 LYS A  57       6.910 -10.180  -1.203  1.00  0.00           H  
ATOM    552  HZ3 LYS A  57       7.344 -11.720  -1.492  1.00  0.00           H  
ATOM    553  N   VAL A  58       2.486  -6.052   2.689  1.00  0.00           N  
ATOM    554  CA  VAL A  58       1.456  -5.049   2.990  1.00  0.00           C  
ATOM    555  C   VAL A  58       2.001  -3.654   3.283  1.00  0.00           C  
ATOM    556  O   VAL A  58       1.415  -2.665   2.848  1.00  0.00           O  
ATOM    557  CB  VAL A  58       0.373  -5.464   3.995  1.00  0.00           C  
ATOM    558  CG1 VAL A  58      -0.591  -6.460   3.362  1.00  0.00           C  
ATOM    559  CG2 VAL A  58       0.898  -5.981   5.340  1.00  0.00           C  
ATOM    560  H   VAL A  58       2.569  -6.817   3.330  1.00  0.00           H  
ATOM    561  N   ASN A  59       3.176  -3.564   3.906  1.00  0.00           N  
ATOM    562  CA  ASN A  59       3.936  -2.319   4.055  1.00  0.00           C  
ATOM    563  C   ASN A  59       4.257  -1.651   2.713  1.00  0.00           C  
ATOM    564  O   ASN A  59       4.096  -0.439   2.551  1.00  0.00           O  
ATOM    565  CB  ASN A  59       5.262  -2.558   4.780  1.00  0.00           C  
ATOM    566  CG  ASN A  59       5.160  -2.931   6.264  1.00  0.00           C  
ATOM    567  OD1 ASN A  59       4.326  -3.714   6.703  1.00  0.00           O  
ATOM    568  ND2 ASN A  59       6.113  -2.443   7.061  1.00  0.00           N  
ATOM    569  H   ASN A  59       3.521  -4.336   4.447  1.00  0.00           H  
ATOM    570 HD21 ASN A  59       6.829  -1.854   6.710  1.00  0.00           H  
ATOM    571 HD22 ASN A  59       6.039  -2.686   8.030  1.00  0.00           H  
ATOM    572  N   SER A  60       4.749  -2.451   1.778  1.00  0.00           N  
ATOM    573  CA  SER A  60       5.010  -2.056   0.392  1.00  0.00           C  
ATOM    574  C   SER A  60       3.749  -1.586  -0.331  1.00  0.00           C  
ATOM    575  O   SER A  60       3.737  -0.491  -0.891  1.00  0.00           O  
ATOM    576  CB  SER A  60       5.666  -3.218  -0.353  1.00  0.00           C  
ATOM    577  OG  SER A  60       5.834  -2.906  -1.743  1.00  0.00           O  
ATOM    578  H   SER A  60       4.997  -3.401   2.002  1.00  0.00           H  
ATOM    579  HG  SER A  60       6.405  -2.087  -1.837  1.00  0.00           H  
ATOM    580  N   MET A  61       2.672  -2.346  -0.155  1.00  0.00           N  
ATOM    581  CA  MET A  61       1.328  -2.044  -0.661  1.00  0.00           C  
ATOM    582  C   MET A  61       0.755  -0.708  -0.155  1.00  0.00           C  
ATOM    583  O   MET A  61       0.080  -0.017  -0.909  1.00  0.00           O  
ATOM    584  CB  MET A  61       0.432  -3.214  -0.261  1.00  0.00           C  
ATOM    585  CG  MET A  61      -0.404  -3.759  -1.411  1.00  0.00           C  
ATOM    586  SD  MET A  61      -1.855  -2.715  -1.815  1.00  0.00           S  
ATOM    587  CE  MET A  61      -2.773  -3.813  -2.860  1.00  0.00           C  
ATOM    588  H   MET A  61       2.765  -3.267   0.218  1.00  0.00           H  
ATOM    589  N   LYS A  62       0.976  -0.417   1.121  1.00  0.00           N  
ATOM    590  CA  LYS A  62       0.661   0.876   1.747  1.00  0.00           C  
ATOM    591  C   LYS A  62       1.495   2.058   1.241  1.00  0.00           C  
ATOM    592  O   LYS A  62       1.005   3.184   1.184  1.00  0.00           O  
ATOM    593  CB  LYS A  62       0.761   0.802   3.272  1.00  0.00           C  
ATOM    594  CG  LYS A  62      -0.385   0.020   3.910  1.00  0.00           C  
ATOM    595  CD  LYS A  62      -0.346   0.166   5.434  1.00  0.00           C  
ATOM    596  CE  LYS A  62      -1.519  -0.563   6.087  1.00  0.00           C  
ATOM    597  NZ  LYS A  62      -1.543  -0.298   7.531  1.00  0.00           N  
ATOM    598  H   LYS A  62       1.189  -1.150   1.766  1.00  0.00           H  
ATOM    599  HZ1 LYS A  62      -0.674  -0.592   7.925  1.00  0.00           H  
ATOM    600  HZ2 LYS A  62      -1.653   0.687   7.674  1.00  0.00           H  
ATOM    601  HZ3 LYS A  62      -2.306  -0.785   7.954  1.00  0.00           H  
ATOM    602  N   SER A  63       2.783   1.804   1.030  1.00  0.00           N  
ATOM    603  CA  SER A  63       3.678   2.752   0.355  1.00  0.00           C  
ATOM    604  C   SER A  63       3.174   3.079  -1.045  1.00  0.00           C  
ATOM    605  O   SER A  63       3.261   4.217  -1.516  1.00  0.00           O  
ATOM    606  CB  SER A  63       5.110   2.211   0.255  1.00  0.00           C  
ATOM    607  OG  SER A  63       5.683   1.992   1.546  1.00  0.00           O  
ATOM    608  H   SER A  63       3.202   0.956   1.350  1.00  0.00           H  
ATOM    609  HG  SER A  63       5.227   1.225   2.000  1.00  0.00           H  
ATOM    610  N   TRP A  64       2.718   2.037  -1.726  1.00  0.00           N  
ATOM    611  CA  TRP A  64       1.900   2.108  -2.949  1.00  0.00           C  
ATOM    612  C   TRP A  64       0.452   2.476  -2.609  1.00  0.00           C  
ATOM    613  O   TRP A  64       0.154   2.867  -1.487  1.00  0.00           O  
ATOM    614  CB  TRP A  64       2.095   0.748  -3.619  1.00  0.00           C  
ATOM    615  CG  TRP A  64       1.420   0.581  -4.984  1.00  0.00           C  
ATOM    616  CD1 TRP A  64       1.429   1.429  -6.003  1.00  0.00           C  
ATOM    617  CD2 TRP A  64       0.583  -0.475  -5.331  1.00  0.00           C  
ATOM    618  NE1 TRP A  64       0.607   0.993  -6.953  1.00  0.00           N  
ATOM    619  CE2 TRP A  64       0.040  -0.153  -6.575  1.00  0.00           C  
ATOM    620  CE3 TRP A  64       0.264  -1.680  -4.711  1.00  0.00           C  
ATOM    621  CZ2 TRP A  64      -0.862  -1.005  -7.201  1.00  0.00           C  
ATOM    622  CZ3 TRP A  64      -0.617  -2.543  -5.351  1.00  0.00           C  
ATOM    623  CH2 TRP A  64      -1.179  -2.202  -6.569  1.00  0.00           C  
ATOM    624  H   TRP A  64       2.936   1.104  -1.448  1.00  0.00           H  
ATOM    625  HE1 TRP A  64       0.531   1.401  -7.862  1.00  0.00           H  
ATOM    626  N   LEU A  65      -0.364   2.584  -3.660  1.00  0.00           N  
ATOM    627  CA  LEU A  65      -1.756   3.051  -3.667  1.00  0.00           C  
ATOM    628  C   LEU A  65      -1.935   4.548  -3.419  1.00  0.00           C  
ATOM    629  O   LEU A  65      -2.944   5.131  -3.807  1.00  0.00           O  
ATOM    630  CB  LEU A  65      -2.702   2.284  -2.746  1.00  0.00           C  
ATOM    631  CG  LEU A  65      -2.742   0.765  -2.944  1.00  0.00           C  
ATOM    632  CD1 LEU A  65      -3.809   0.173  -2.026  1.00  0.00           C  
ATOM    633  CD2 LEU A  65      -3.032   0.357  -4.386  1.00  0.00           C  
ATOM    634  H   LEU A  65      -0.022   2.271  -4.551  1.00  0.00           H  
ATOM    635  N   SER A  66      -1.084   5.073  -2.540  1.00  0.00           N  
ATOM    636  CA  SER A  66      -0.766   6.501  -2.366  1.00  0.00           C  
ATOM    637  C   SER A  66       0.217   6.938  -3.457  1.00  0.00           C  
ATOM    638  O   SER A  66       0.121   8.051  -3.961  1.00  0.00           O  
ATOM    639  CB  SER A  66      -0.170   6.757  -0.983  1.00  0.00           C  
ATOM    640  OG  SER A  66       1.133   6.178  -0.896  1.00  0.00           O  
ATOM    641  H   SER A  66      -0.601   4.455  -1.912  1.00  0.00           H  
ATOM    642  HG  SER A  66       1.156   5.455  -0.210  1.00  0.00           H  
ATOM    643  N   LYS A  67       1.199   6.085  -3.726  1.00  0.00           N  
ATOM    644  CA  LYS A  67       1.965   6.057  -4.988  1.00  0.00           C  
ATOM    645  C   LYS A  67       0.956   5.753  -6.103  1.00  0.00           C  
ATOM    646  O   LYS A  67       0.460   4.643  -6.281  1.00  0.00           O  
ATOM    647  CB  LYS A  67       3.070   5.009  -4.884  1.00  0.00           C  
ATOM    648  CG  LYS A  67       4.162   5.018  -5.946  1.00  0.00           C  
ATOM    649  CD  LYS A  67       3.681   4.677  -7.367  1.00  0.00           C  
ATOM    650  CE  LYS A  67       4.820   4.216  -8.274  1.00  0.00           C  
ATOM    651  NZ  LYS A  67       5.161   2.828  -7.952  1.00  0.00           N  
ATOM    652  H   LYS A  67       1.614   5.580  -2.969  1.00  0.00           H  
ATOM    653  HZ1 LYS A  67       5.413   2.758  -6.989  1.00  0.00           H  
ATOM    654  HZ2 LYS A  67       4.361   2.248  -8.117  1.00  0.00           H  
ATOM    655  HZ3 LYS A  67       5.915   2.508  -8.531  1.00  0.00           H  
ATOM    656  N   VAL A  68       0.592   6.858  -6.742  1.00  0.00           N  
ATOM    657  CA  VAL A  68      -0.517   6.897  -7.707  1.00  0.00           C  
ATOM    658  C   VAL A  68      -0.082   7.051  -9.170  1.00  0.00           C  
ATOM    659  O   VAL A  68       0.230   8.134  -9.661  1.00  0.00           O  
ATOM    660  CB  VAL A  68      -1.580   7.903  -7.290  1.00  0.00           C  
ATOM    661  CG1 VAL A  68      -2.311   7.450  -6.027  1.00  0.00           C  
ATOM    662  CG2 VAL A  68      -1.073   9.328  -7.094  1.00  0.00           C  
ATOM    663  H   VAL A  68       0.957   7.750  -6.491  1.00  0.00           H  
ATOM    664  N   GLY A  69       0.088   5.881  -9.777  1.00  0.00           N  
ATOM    665  CA  GLY A  69       0.301   5.684 -11.227  1.00  0.00           C  
ATOM    666  C   GLY A  69      -1.029   5.281 -11.865  1.00  0.00           C  
ATOM    667  O   GLY A  69      -1.899   4.694 -11.228  1.00  0.00           O  
ATOM    668  H   GLY A  69       0.085   5.026  -9.265  1.00  0.00           H  
ATOM    669  N   SER A  70      -1.123   5.493 -13.181  1.00  0.00           N  
ATOM    670  CA  SER A  70      -2.422   5.500 -13.874  1.00  0.00           C  
ATOM    671  C   SER A  70      -2.575   4.584 -15.080  1.00  0.00           C  
ATOM    672  O   SER A  70      -1.624   4.446 -15.858  1.00  0.00           O  
ATOM    673  CB  SER A  70      -2.693   6.939 -14.328  1.00  0.00           C  
ATOM    674  OG  SER A  70      -3.981   6.969 -14.954  1.00  0.00           O  
ATOM    675  H   SER A  70      -0.320   5.628 -13.754  1.00  0.00           H  
ATOM    676  HG  SER A  70      -4.609   7.300 -14.246  1.00  0.00           H  
ATOM    677  N   PRO A  71      -3.734   3.948 -15.213  1.00  0.00           N  
ATOM    678  CA  PRO A  71      -4.202   3.424 -16.511  1.00  0.00           C  
ATOM    679  C   PRO A  71      -5.266   4.255 -17.224  1.00  0.00           C  
ATOM    680  O   PRO A  71      -5.781   3.854 -18.268  1.00  0.00           O  
ATOM    681  CB  PRO A  71      -4.724   2.027 -16.160  1.00  0.00           C  
ATOM    682  CG  PRO A  71      -5.313   2.215 -14.756  1.00  0.00           C  
ATOM    683  CD  PRO A  71      -4.384   3.242 -14.103  1.00  0.00           C  
ATOM    684  N   SER A  72      -5.558   5.451 -16.711  1.00  0.00           N  
ATOM    685  CA  SER A  72      -6.536   6.423 -17.209  1.00  0.00           C  
ATOM    686  C   SER A  72      -6.561   7.700 -16.367  1.00  0.00           C  
ATOM    687  O   SER A  72      -6.069   8.750 -16.796  1.00  0.00           O  
ATOM    688  CB  SER A  72      -7.984   5.913 -17.278  1.00  0.00           C  
ATOM    689  OG  SER A  72      -8.251   5.295 -18.531  1.00  0.00           O  
ATOM    690  H   SER A  72      -4.948   5.836 -16.017  1.00  0.00           H  
ATOM    691  HG  SER A  72      -7.479   4.707 -18.755  1.00  0.00           H  
ATOM    692  N   SER A  73      -7.037   7.567 -15.139  1.00  0.00           N  
ATOM    693  CA  SER A  73      -7.282   8.686 -14.211  1.00  0.00           C  
ATOM    694  C   SER A  73      -6.387   8.668 -12.969  1.00  0.00           C  
ATOM    695  O   SER A  73      -5.568   7.766 -12.799  1.00  0.00           O  
ATOM    696  CB  SER A  73      -8.740   8.561 -13.758  1.00  0.00           C  
ATOM    697  OG  SER A  73      -8.933   7.244 -13.237  1.00  0.00           O  
ATOM    698  H   SER A  73      -7.367   6.689 -14.784  1.00  0.00           H  
ATOM    699  HG  SER A  73      -9.916   7.097 -13.266  1.00  0.00           H  
ATOM    700  N   ARG A  74      -6.497   9.747 -12.197  1.00  0.00           N  
ATOM    701  CA  ARG A  74      -5.839   9.840 -10.884  1.00  0.00           C  
ATOM    702  C   ARG A  74      -6.598   9.070  -9.804  1.00  0.00           C  
ATOM    703  O   ARG A  74      -7.821   9.161  -9.673  1.00  0.00           O  
ATOM    704  CB  ARG A  74      -5.594  11.295 -10.449  1.00  0.00           C  
ATOM    705  CG  ARG A  74      -6.807  12.138 -10.059  1.00  0.00           C  
ATOM    706  CD  ARG A  74      -7.308  13.073 -11.166  1.00  0.00           C  
ATOM    707  NE  ARG A  74      -8.354  12.457 -11.990  1.00  0.00           N  
ATOM    708  CZ  ARG A  74      -8.289  12.213 -13.303  1.00  0.00           C  
ATOM    709  NH1 ARG A  74      -7.145  12.316 -13.993  1.00  0.00           N  
ATOM    710  NH2 ARG A  74      -9.378  11.792 -13.953  1.00  0.00           N  
ATOM    711  H   ARG A  74      -7.015  10.554 -12.479  1.00  0.00           H  
ATOM    712  HE  ARG A  74      -9.214  12.264 -11.513  1.00  0.00           H  
ATOM    713 HH11 ARG A  74      -6.341  12.697 -13.549  1.00  0.00           H  
ATOM    714 HH12 ARG A  74      -7.127  12.108 -14.970  1.00  0.00           H  
ATOM    715 HH21 ARG A  74     -10.258  11.717 -13.488  1.00  0.00           H  
ATOM    716 HH22 ARG A  74      -9.316  11.605 -14.936  1.00  0.00           H  
ATOM    717  N   ILE A  75      -5.840   8.233  -9.102  1.00  0.00           N  
ATOM    718  CA  ILE A  75      -6.310   7.545  -7.886  1.00  0.00           C  
ATOM    719  C   ILE A  75      -6.326   8.581  -6.765  1.00  0.00           C  
ATOM    720  O   ILE A  75      -5.326   8.840  -6.079  1.00  0.00           O  
ATOM    721  CB  ILE A  75      -5.464   6.297  -7.637  1.00  0.00           C  
ATOM    722  CG1 ILE A  75      -5.679   5.223  -8.712  1.00  0.00           C  
ATOM    723  CG2 ILE A  75      -5.697   5.649  -6.274  1.00  0.00           C  
ATOM    724  CD1 ILE A  75      -4.816   5.401  -9.963  1.00  0.00           C  
ATOM    725  H   ILE A  75      -4.937   7.969  -9.415  1.00  0.00           H  
ATOM    726  N   ASP A  76      -7.439   9.300  -6.717  1.00  0.00           N  
ATOM    727  CA  ASP A  76      -7.632  10.475  -5.853  1.00  0.00           C  
ATOM    728  C   ASP A  76      -7.891  10.116  -4.380  1.00  0.00           C  
ATOM    729  O   ASP A  76      -8.980   9.699  -4.003  1.00  0.00           O  
ATOM    730  CB  ASP A  76      -8.672  11.453  -6.393  1.00  0.00           C  
ATOM    731  CG  ASP A  76     -10.110  10.944  -6.533  1.00  0.00           C  
ATOM    732  OD1 ASP A  76     -10.269   9.730  -6.747  1.00  0.00           O  
ATOM    733  OD2 ASP A  76     -11.012  11.813  -6.563  1.00  0.00           O  
ATOM    734  H   ASP A  76      -8.225   9.056  -7.286  1.00  0.00           H  
ATOM    735  N   ARG A  77      -6.758  10.065  -3.693  1.00  0.00           N  
ATOM    736  CA  ARG A  77      -6.629   9.901  -2.236  1.00  0.00           C  
ATOM    737  C   ARG A  77      -7.059   8.517  -1.726  1.00  0.00           C  
ATOM    738  O   ARG A  77      -8.241   8.208  -1.577  1.00  0.00           O  
ATOM    739  CB  ARG A  77      -7.277  11.029  -1.437  1.00  0.00           C  
ATOM    740  CG  ARG A  77      -7.091  10.959   0.076  1.00  0.00           C  
ATOM    741  CD  ARG A  77      -5.671  11.217   0.601  1.00  0.00           C  
ATOM    742  NE  ARG A  77      -4.763  10.077   0.421  1.00  0.00           N  
ATOM    743  CZ  ARG A  77      -3.717  10.002  -0.417  1.00  0.00           C  
ATOM    744  NH1 ARG A  77      -3.347  11.028  -1.197  1.00  0.00           N  
ATOM    745  NH2 ARG A  77      -3.072   8.841  -0.573  1.00  0.00           N  
ATOM    746  H   ARG A  77      -5.902   9.966  -4.195  1.00  0.00           H  
ATOM    747  HE  ARG A  77      -4.908   9.303   1.046  1.00  0.00           H  
ATOM    748 HH11 ARG A  77      -3.857  11.886  -1.156  1.00  0.00           H  
ATOM    749 HH12 ARG A  77      -2.544  10.942  -1.791  1.00  0.00           H  
ATOM    750 HH21 ARG A  77      -3.287   8.064   0.017  1.00  0.00           H  
ATOM    751 HH22 ARG A  77      -2.314   8.792  -1.223  1.00  0.00           H  
ATOM    752  N   THR A  78      -6.036   7.808  -1.244  1.00  0.00           N  
ATOM    753  CA  THR A  78      -6.193   6.483  -0.647  1.00  0.00           C  
ATOM    754  C   THR A  78      -5.771   6.509   0.825  1.00  0.00           C  
ATOM    755  O   THR A  78      -4.669   6.902   1.192  1.00  0.00           O  
ATOM    756  CB  THR A  78      -5.408   5.410  -1.407  1.00  0.00           C  
ATOM    757  OG1 THR A  78      -5.753   5.530  -2.792  1.00  0.00           O  
ATOM    758  CG2 THR A  78      -5.754   4.001  -0.932  1.00  0.00           C  
ATOM    759  H   THR A  78      -5.100   8.178  -1.252  1.00  0.00           H  
ATOM    760  HG1 THR A  78      -4.926   5.348  -3.329  1.00  0.00           H  
ATOM    761  N   ASN A  79      -6.786   6.224   1.647  1.00  0.00           N  
ATOM    762  CA  ASN A  79      -6.683   6.078   3.106  1.00  0.00           C  
ATOM    763  C   ASN A  79      -6.688   4.587   3.462  1.00  0.00           C  
ATOM    764  O   ASN A  79      -7.482   3.807   2.930  1.00  0.00           O  
ATOM    765  CB  ASN A  79      -7.869   6.804   3.744  1.00  0.00           C  
ATOM    766  CG  ASN A  79      -7.849   6.747   5.274  1.00  0.00           C  
ATOM    767  OD1 ASN A  79      -8.335   5.812   5.901  1.00  0.00           O  
ATOM    768  ND2 ASN A  79      -7.224   7.733   5.905  1.00  0.00           N  
ATOM    769  H   ASN A  79      -7.701   6.091   1.271  1.00  0.00           H  
ATOM    770 HD21 ASN A  79      -6.826   8.506   5.399  1.00  0.00           H  
ATOM    771 HD22 ASN A  79      -7.208   7.695   6.904  1.00  0.00           H  
ATOM    772  N   PHE A  80      -5.847   4.269   4.439  1.00  0.00           N  
ATOM    773  CA  PHE A  80      -5.642   2.892   4.926  1.00  0.00           C  
ATOM    774  C   PHE A  80      -6.097   2.792   6.385  1.00  0.00           C  
ATOM    775  O   PHE A  80      -5.443   3.297   7.291  1.00  0.00           O  
ATOM    776  CB  PHE A  80      -4.167   2.507   4.795  1.00  0.00           C  
ATOM    777  CG  PHE A  80      -3.591   2.681   3.393  1.00  0.00           C  
ATOM    778  CD1 PHE A  80      -3.753   1.671   2.445  1.00  0.00           C  
ATOM    779  CD2 PHE A  80      -2.863   3.828   3.092  1.00  0.00           C  
ATOM    780  CE1 PHE A  80      -3.179   1.817   1.188  1.00  0.00           C  
ATOM    781  CE2 PHE A  80      -2.288   3.973   1.836  1.00  0.00           C  
ATOM    782  CZ  PHE A  80      -2.454   2.963   0.897  1.00  0.00           C  
ATOM    783  H   PHE A  80      -5.312   4.971   4.920  1.00  0.00           H  
ATOM    784  N   SER A  81      -7.315   2.277   6.543  1.00  0.00           N  
ATOM    785  CA  SER A  81      -7.947   2.081   7.852  1.00  0.00           C  
ATOM    786  C   SER A  81      -8.658   0.729   7.906  1.00  0.00           C  
ATOM    787  O   SER A  81      -9.220   0.286   6.908  1.00  0.00           O  
ATOM    788  CB  SER A  81      -8.911   3.200   8.245  1.00  0.00           C  
ATOM    789  OG  SER A  81     -10.077   3.190   7.417  1.00  0.00           O  
ATOM    790  H   SER A  81      -7.773   1.813   5.792  1.00  0.00           H  
ATOM    791  HG  SER A  81      -9.908   3.810   6.655  1.00  0.00           H  
ATOM    792  N   ASN A  82      -8.836   0.245   9.136  1.00  0.00           N  
ATOM    793  CA  ASN A  82      -9.209  -1.139   9.465  1.00  0.00           C  
ATOM    794  C   ASN A  82      -8.061  -2.098   9.153  1.00  0.00           C  
ATOM    795  O   ASN A  82      -7.803  -2.466   8.008  1.00  0.00           O  
ATOM    796  CB  ASN A  82     -10.496  -1.616   8.797  1.00  0.00           C  
ATOM    797  CG  ASN A  82     -11.716  -0.816   9.267  1.00  0.00           C  
ATOM    798  OD1 ASN A  82     -12.358  -1.143  10.270  1.00  0.00           O  
ATOM    799  ND2 ASN A  82     -12.014   0.297   8.609  1.00  0.00           N  
ATOM    800  H   ASN A  82      -8.796   0.859   9.919  1.00  0.00           H  
ATOM    801 HD21 ASN A  82     -11.429   0.624   7.873  1.00  0.00           H  
ATOM    802 HD22 ASN A  82     -12.825   0.802   8.912  1.00  0.00           H  
ATOM    803  N   GLU A  83      -7.243  -2.276  10.181  1.00  0.00           N  
ATOM    804  CA  GLU A  83      -6.042  -3.141  10.157  1.00  0.00           C  
ATOM    805  C   GLU A  83      -6.171  -4.269  11.175  1.00  0.00           C  
ATOM    806  O   GLU A  83      -6.273  -4.029  12.379  1.00  0.00           O  
ATOM    807  CB  GLU A  83      -4.793  -2.321  10.478  1.00  0.00           C  
ATOM    808  CG  GLU A  83      -4.284  -1.420   9.349  1.00  0.00           C  
ATOM    809  CD  GLU A  83      -5.221  -0.250   9.023  1.00  0.00           C  
ATOM    810  OE1 GLU A  83      -5.534   0.524   9.954  1.00  0.00           O  
ATOM    811  OE2 GLU A  83      -5.632  -0.181   7.845  1.00  0.00           O  
ATOM    812  H   GLU A  83      -7.416  -1.840  11.062  1.00  0.00           H  
ATOM    813  N   LYS A  84      -6.301  -5.487  10.642  1.00  0.00           N  
ATOM    814  CA  LYS A  84      -6.475  -6.714  11.417  1.00  0.00           C  
ATOM    815  C   LYS A  84      -5.646  -7.902  10.900  1.00  0.00           C  
ATOM    816  O   LYS A  84      -5.829  -8.394   9.787  1.00  0.00           O  
ATOM    817  CB  LYS A  84      -7.954  -7.085  11.555  1.00  0.00           C  
ATOM    818  CG  LYS A  84      -8.745  -7.068  10.233  1.00  0.00           C  
ATOM    819  CD  LYS A  84     -10.213  -7.424  10.461  1.00  0.00           C  
ATOM    820  CE  LYS A  84     -11.061  -7.136   9.216  1.00  0.00           C  
ATOM    821  NZ  LYS A  84     -11.185  -5.683   9.004  1.00  0.00           N  
ATOM    822  H   LYS A  84      -6.366  -5.605   9.650  1.00  0.00           H  
ATOM    823  HZ1 LYS A  84     -10.268  -5.281   8.884  1.00  0.00           H  
ATOM    824  HZ2 LYS A  84     -11.704  -5.521   8.163  1.00  0.00           H  
ATOM    825  HZ3 LYS A  84     -11.650  -5.259   9.772  1.00  0.00           H  
ATOM    826  N   THR A  85      -4.650  -8.257  11.707  1.00  0.00           N  
ATOM    827  CA  THR A  85      -3.804  -9.434  11.503  1.00  0.00           C  
ATOM    828  C   THR A  85      -4.557 -10.749  11.703  1.00  0.00           C  
ATOM    829  O   THR A  85      -5.101 -11.026  12.773  1.00  0.00           O  
ATOM    830  CB  THR A  85      -2.575  -9.421  12.427  1.00  0.00           C  
ATOM    831  OG1 THR A  85      -2.945  -8.840  13.681  1.00  0.00           O  
ATOM    832  CG2 THR A  85      -1.367  -8.746  11.785  1.00  0.00           C  
ATOM    833  H   THR A  85      -4.411  -7.715  12.512  1.00  0.00           H  
ATOM    834  HG1 THR A  85      -3.477  -9.517  14.187  1.00  0.00           H  
ATOM    835  N   ILE A  86      -4.497 -11.543  10.640  1.00  0.00           N  
ATOM    836  CA  ILE A  86      -5.169 -12.840  10.498  1.00  0.00           C  
ATOM    837  C   ILE A  86      -4.167 -13.940  10.119  1.00  0.00           C  
ATOM    838  O   ILE A  86      -2.962 -13.769  10.258  1.00  0.00           O  
ATOM    839  CB  ILE A  86      -6.321 -12.757   9.488  1.00  0.00           C  
ATOM    840  CG1 ILE A  86      -5.851 -12.391   8.078  1.00  0.00           C  
ATOM    841  CG2 ILE A  86      -7.416 -11.812   9.976  1.00  0.00           C  
ATOM    842  CD1 ILE A  86      -6.714 -13.053   7.008  1.00  0.00           C  
ATOM    843  H   ILE A  86      -3.881 -11.319   9.878  1.00  0.00           H  
ATOM    844  N   SER A  87      -4.669 -15.037   9.568  1.00  0.00           N  
ATOM    845  CA  SER A  87      -3.842 -16.161   9.096  1.00  0.00           C  
ATOM    846  C   SER A  87      -4.279 -16.574   7.686  1.00  0.00           C  
ATOM    847  O   SER A  87      -5.478 -16.552   7.389  1.00  0.00           O  
ATOM    848  CB  SER A  87      -3.990 -17.356  10.041  1.00  0.00           C  
ATOM    849  OG  SER A  87      -2.829 -18.176   9.919  1.00  0.00           O  
ATOM    850  H   SER A  87      -5.629 -15.090   9.286  1.00  0.00           H  
ATOM    851  HG  SER A  87      -2.031 -17.611  10.136  1.00  0.00           H  
ATOM    852  N   LYS A  88      -3.305 -16.958   6.874  1.00  0.00           N  
ATOM    853  CA  LYS A  88      -3.472 -17.378   5.473  1.00  0.00           C  
ATOM    854  C   LYS A  88      -4.098 -16.359   4.517  1.00  0.00           C  
ATOM    855  O   LYS A  88      -4.741 -15.382   4.910  1.00  0.00           O  
ATOM    856  CB  LYS A  88      -4.191 -18.724   5.355  1.00  0.00           C  
ATOM    857  CG  LYS A  88      -3.229 -19.914   5.425  1.00  0.00           C  
ATOM    858  CD  LYS A  88      -2.679 -20.235   6.819  1.00  0.00           C  
ATOM    859  CE  LYS A  88      -3.718 -20.937   7.699  1.00  0.00           C  
ATOM    860  NZ  LYS A  88      -3.120 -21.194   9.018  1.00  0.00           N  
ATOM    861  H   LYS A  88      -2.372 -17.059   7.225  1.00  0.00           H  
ATOM    862  HZ1 LYS A  88      -2.289 -21.738   8.933  1.00  0.00           H  
ATOM    863  HZ2 LYS A  88      -2.917 -20.316   9.455  1.00  0.00           H  
ATOM    864  HZ3 LYS A  88      -3.787 -21.690   9.581  1.00  0.00           H  
ATOM    865  N   LEU A  89      -3.814 -16.553   3.230  1.00  0.00           N  
ATOM    866  CA  LEU A  89      -4.280 -15.677   2.154  1.00  0.00           C  
ATOM    867  C   LEU A  89      -5.540 -16.250   1.490  1.00  0.00           C  
ATOM    868  O   LEU A  89      -5.475 -17.029   0.536  1.00  0.00           O  
ATOM    869  CB  LEU A  89      -3.163 -15.457   1.131  1.00  0.00           C  
ATOM    870  CG  LEU A  89      -1.946 -14.741   1.712  1.00  0.00           C  
ATOM    871  CD1 LEU A  89      -0.755 -14.846   0.754  1.00  0.00           C  
ATOM    872  CD2 LEU A  89      -2.249 -13.269   2.000  1.00  0.00           C  
ATOM    873  H   LEU A  89      -3.274 -17.344   2.927  1.00  0.00           H  
ATOM    874  N   GLU A  90      -6.684 -15.818   1.992  1.00  0.00           N  
ATOM    875  CA  GLU A  90      -7.995 -16.404   1.671  1.00  0.00           C  
ATOM    876  C   GLU A  90      -8.685 -15.938   0.382  1.00  0.00           C  
ATOM    877  O   GLU A  90      -9.911 -15.954   0.285  1.00  0.00           O  
ATOM    878  CB  GLU A  90      -8.923 -16.269   2.880  1.00  0.00           C  
ATOM    879  CG  GLU A  90      -8.496 -17.179   4.037  1.00  0.00           C  
ATOM    880  CD  GLU A  90      -9.489 -17.096   5.190  1.00  0.00           C  
ATOM    881  OE1 GLU A  90      -9.320 -16.186   6.030  1.00  0.00           O  
ATOM    882  OE2 GLU A  90     -10.414 -17.942   5.203  1.00  0.00           O  
ATOM    883  H   GLU A  90      -6.708 -15.077   2.673  1.00  0.00           H  
ATOM    884  N   TYR A  91      -7.879 -15.660  -0.640  1.00  0.00           N  
ATOM    885  CA  TYR A  91      -8.351 -15.214  -1.959  1.00  0.00           C  
ATOM    886  C   TYR A  91      -7.343 -15.537  -3.065  1.00  0.00           C  
ATOM    887  O   TYR A  91      -6.131 -15.586  -2.837  1.00  0.00           O  
ATOM    888  CB  TYR A  91      -8.626 -13.710  -2.020  1.00  0.00           C  
ATOM    889  CG  TYR A  91      -9.829 -13.250  -1.209  1.00  0.00           C  
ATOM    890  CD1 TYR A  91     -11.106 -13.475  -1.725  1.00  0.00           C  
ATOM    891  CD2 TYR A  91      -9.625 -12.613   0.002  1.00  0.00           C  
ATOM    892  CE1 TYR A  91     -12.207 -13.051  -0.997  1.00  0.00           C  
ATOM    893  CE2 TYR A  91     -10.737 -12.183   0.737  1.00  0.00           C  
ATOM    894  CZ  TYR A  91     -12.005 -12.400   0.214  1.00  0.00           C  
ATOM    895  OH  TYR A  91     -13.063 -11.821   0.826  1.00  0.00           O  
ATOM    896  H   TYR A  91      -6.909 -15.885  -0.599  1.00  0.00           H  
ATOM    897  HH  TYR A  91     -12.735 -11.317   1.629  1.00  0.00           H  
ATOM    898  N   SER A  92      -7.883 -15.750  -4.257  1.00  0.00           N  
ATOM    899  CA  SER A  92      -7.119 -15.935  -5.494  1.00  0.00           C  
ATOM    900  C   SER A  92      -6.612 -14.605  -6.054  1.00  0.00           C  
ATOM    901  O   SER A  92      -7.301 -13.909  -6.792  1.00  0.00           O  
ATOM    902  CB  SER A  92      -7.999 -16.693  -6.500  1.00  0.00           C  
ATOM    903  OG  SER A  92      -9.310 -16.128  -6.517  1.00  0.00           O  
ATOM    904  H   SER A  92      -8.871 -15.813  -4.391  1.00  0.00           H  
ATOM    905  HG  SER A  92      -9.248 -15.236  -6.953  1.00  0.00           H  
ATOM    906  N   ASN A  93      -5.446 -14.231  -5.517  1.00  0.00           N  
ATOM    907  CA  ASN A  93      -4.736 -12.980  -5.788  1.00  0.00           C  
ATOM    908  C   ASN A  93      -5.532 -11.716  -5.436  1.00  0.00           C  
ATOM    909  O   ASN A  93      -6.500 -11.796  -4.695  1.00  0.00           O  
ATOM    910  CB  ASN A  93      -4.179 -12.937  -7.213  1.00  0.00           C  
ATOM    911  CG  ASN A  93      -2.821 -13.645  -7.293  1.00  0.00           C  
ATOM    912  OD1 ASN A  93      -2.666 -14.807  -6.941  1.00  0.00           O  
ATOM    913  ND2 ASN A  93      -1.790 -12.928  -7.730  1.00  0.00           N  
ATOM    914  H   ASN A  93      -5.030 -14.801  -4.805  1.00  0.00           H  
ATOM    915 HD21 ASN A  93      -1.896 -11.980  -8.032  1.00  0.00           H  
ATOM    916 HD22 ASN A  93      -0.914 -13.409  -7.755  1.00  0.00           H  
ATOM    917  N   PHE A  94      -4.870 -10.571  -5.612  1.00  0.00           N  
ATOM    918  CA  PHE A  94      -5.569  -9.289  -5.649  1.00  0.00           C  
ATOM    919  C   PHE A  94      -6.211  -9.109  -7.029  1.00  0.00           C  
ATOM    920  O   PHE A  94      -5.552  -9.087  -8.070  1.00  0.00           O  
ATOM    921  CB  PHE A  94      -4.625  -8.132  -5.302  1.00  0.00           C  
ATOM    922  CG  PHE A  94      -5.386  -6.871  -4.896  1.00  0.00           C  
ATOM    923  CD1 PHE A  94      -5.877  -6.006  -5.876  1.00  0.00           C  
ATOM    924  CD2 PHE A  94      -5.617  -6.620  -3.546  1.00  0.00           C  
ATOM    925  CE1 PHE A  94      -6.616  -4.892  -5.500  1.00  0.00           C  
ATOM    926  CE2 PHE A  94      -6.356  -5.506  -3.170  1.00  0.00           C  
ATOM    927  CZ  PHE A  94      -6.858  -4.657  -4.154  1.00  0.00           C  
ATOM    928  H   PHE A  94      -3.864 -10.527  -5.589  1.00  0.00           H  
ATOM    929  N   SER A  95      -7.539  -9.139  -6.961  1.00  0.00           N  
ATOM    930  CA  SER A  95      -8.436  -9.350  -8.107  1.00  0.00           C  
ATOM    931  C   SER A  95      -9.221  -8.116  -8.547  1.00  0.00           C  
ATOM    932  O   SER A  95      -8.742  -6.980  -8.459  1.00  0.00           O  
ATOM    933  CB  SER A  95      -9.346 -10.492  -7.636  1.00  0.00           C  
ATOM    934  OG  SER A  95     -10.106  -9.893  -6.570  1.00  0.00           O  
ATOM    935  H   SER A  95      -8.010  -9.186  -6.078  1.00  0.00           H  
ATOM    936  HG  SER A  95     -10.762 -10.552  -6.213  1.00  0.00           H  
ATOM    937  N   VAL A  96     -10.485  -8.324  -8.889  1.00  0.00           N  
ATOM    938  CA  VAL A  96     -11.354  -7.395  -9.637  1.00  0.00           C  
ATOM    939  C   VAL A  96     -12.368  -6.695  -8.728  1.00  0.00           C  
ATOM    940  O   VAL A  96     -12.276  -6.765  -7.503  1.00  0.00           O  
ATOM    941  CB  VAL A  96     -12.034  -8.140 -10.785  1.00  0.00           C  
ATOM    942  CG1 VAL A  96     -11.012  -8.590 -11.838  1.00  0.00           C  
ATOM    943  CG2 VAL A  96     -12.901  -9.327 -10.353  1.00  0.00           C  
ATOM    944  H   VAL A  96     -10.972  -9.067  -8.444  1.00  0.00           H  
ATOM    945  N   ARG A  97     -13.307  -5.989  -9.362  1.00  0.00           N  
ATOM    946  CA  ARG A  97     -14.432  -5.334  -8.674  1.00  0.00           C  
ATOM    947  C   ARG A  97     -15.544  -6.304  -8.255  1.00  0.00           C  
ATOM    948  O   ARG A  97     -15.945  -7.188  -9.005  1.00  0.00           O  
ATOM    949  CB  ARG A  97     -14.999  -4.179  -9.509  1.00  0.00           C  
ATOM    950  CG  ARG A  97     -15.636  -4.626 -10.830  1.00  0.00           C  
ATOM    951  CD  ARG A  97     -16.459  -3.490 -11.446  1.00  0.00           C  
ATOM    952  NE  ARG A  97     -16.991  -3.945 -12.741  1.00  0.00           N  
ATOM    953  CZ  ARG A  97     -17.044  -3.213 -13.861  1.00  0.00           C  
ATOM    954  NH1 ARG A  97     -16.656  -1.933 -13.914  1.00  0.00           N  
ATOM    955  NH2 ARG A  97     -17.395  -3.799 -15.015  1.00  0.00           N  
ATOM    956  H   ARG A  97     -13.289  -5.876 -10.357  1.00  0.00           H  
ATOM    957  HE  ARG A  97     -17.377  -4.868 -12.747  1.00  0.00           H  
ATOM    958 HH11 ARG A  97     -16.333  -1.487 -13.072  1.00  0.00           H  
ATOM    959 HH12 ARG A  97     -16.705  -1.421 -14.766  1.00  0.00           H  
ATOM    960 HH21 ARG A  97     -17.606  -4.777 -15.047  1.00  0.00           H  
ATOM    961 HH22 ARG A  97     -17.433  -3.250 -15.851  1.00  0.00           H  
ATOM    962  N   TYR A  98     -15.837  -6.219  -6.965  1.00  0.00           N  
ATOM    963  CA  TYR A  98     -16.901  -6.982  -6.287  1.00  0.00           C  
ATOM    964  C   TYR A  98     -17.969  -6.040  -5.726  1.00  0.00           C  
ATOM    965  O   TYR A  98     -19.163  -6.367  -5.879  1.00  0.00           O  
ATOM    966  CB  TYR A  98     -16.333  -7.815  -5.131  1.00  0.00           C  
ATOM    967  CG  TYR A  98     -15.337  -8.944  -5.440  1.00  0.00           C  
ATOM    968  CD1 TYR A  98     -14.519  -8.900  -6.552  1.00  0.00           C  
ATOM    969  CD2 TYR A  98     -15.150  -9.900  -4.442  1.00  0.00           C  
ATOM    970  CE1 TYR A  98     -13.463  -9.799  -6.671  1.00  0.00           C  
ATOM    971  CE2 TYR A  98     -14.096 -10.799  -4.551  1.00  0.00           C  
ATOM    972  CZ  TYR A  98     -13.256 -10.724  -5.655  1.00  0.00           C  
ATOM    973  OH  TYR A  98     -12.118 -11.455  -5.684  1.00  0.00           O  
ATOM    974  OXT TYR A  98     -17.581  -5.016  -5.123  1.00  0.00           O  
ATOM    975  H   TYR A  98     -15.220  -5.741  -6.349  1.00  0.00           H  
ATOM    976  HH  TYR A  98     -12.087 -12.033  -4.862  1.00  0.00           H  
TER     977      TYR A  98                                                      
END
MOLECULE T0437.pdb
ATOM    365  N   ASP    24      -1.217  -3.430  12.771  1.00 32.15           N  
ATOM    366  CA  ASP    24      -2.558  -3.784  13.227  1.00 11.24           C  
ATOM    367  C   ASP    24      -3.077  -4.985  12.447  1.00  3.52           C  
ATOM    368  O   ASP    24      -3.558  -5.955  13.031  1.00 72.30           O  
ATOM    369  CB  ASP    24      -3.550  -2.622  13.081  1.00 55.51           C  
ATOM    370  CG  ASP    24      -4.808  -2.840  13.907  1.00 50.34           C  
ATOM    371  OD1 ASP    24      -4.721  -2.781  15.153  1.00 45.42           O  
ATOM    372  OD2 ASP    24      -5.894  -3.051  13.323  1.00 64.32           O  
ATOM    373  H   ASP    24      -0.799  -3.973  12.068  1.00 54.01           H  
ATOM    374  HA  ASP    24      -2.484  -4.056  14.271  1.00 33.12           H  
ATOM    375  HB2 ASP    24      -3.078  -1.707  13.409  1.00 36.92           H  
ATOM    376  HB3 ASP    24      -3.834  -2.526  12.043  1.00 36.92           H  
ATOM    377  N   ASN    25      -2.962  -4.924  11.121  1.00 30.54           N  
ATOM    378  CA  ASN    25      -3.508  -5.964  10.256  1.00 13.41           C  
ATOM    379  C   ASN    25      -2.460  -6.507   9.295  1.00 63.53           C  
ATOM    380  O   ASN    25      -1.296  -6.099   9.311  1.00 14.31           O  
ATOM    381  CB  ASN    25      -4.679  -5.420   9.426  1.00 24.42           C  
ATOM    382  CG  ASN    25      -5.829  -4.927  10.269  1.00 32.35           C  
ATOM    383  OD1 ASN    25      -6.706  -5.697  10.646  1.00 43.01           O  
ATOM    384  ND2 ASN    25      -5.853  -3.633  10.534  1.00 44.23           N  
ATOM    385  H   ASN    25      -2.501  -4.158  10.709  1.00 41.11           H  
ATOM    386  HA  ASN    25      -3.864  -6.769  10.879  1.00 52.21           H  
ATOM    387  HB2 ASN    25      -4.327  -4.598   8.822  1.00 36.92           H  
ATOM    388  HB3 ASN    25      -5.043  -6.204   8.776  1.00 36.92           H  
ATOM    389 HD21 ASN    25      -5.133  -3.072  10.171  1.00 36.92           H  
ATOM    390 HD22 ASN    25      -6.577  -3.287  11.100  1.00 36.92           H  
ATOM    391  N   CYS    26      -2.899  -7.447   8.473  1.00 31.24           N  
ATOM    392  CA  CYS    26      -2.129  -7.926   7.338  1.00 12.34           C  
ATOM    393  C   CYS    26      -2.935  -7.685   6.063  1.00 73.22           C  
ATOM    394  O   CYS    26      -2.415  -7.757   4.950  1.00 24.23           O  
ATOM    395  CB  CYS    26      -1.796  -9.411   7.499  1.00 72.14           C  
ATOM    396  SG  CYS    26      -3.233 -10.466   7.786  1.00  1.02           S  
ATOM    397  H   CYS    26      -3.780  -7.844   8.643  1.00 23.14           H  
ATOM    398  HA  CYS    26      -1.212  -7.355   7.290  1.00 54.15           H  
ATOM    399  HB2 CYS    26      -1.310  -9.763   6.603  1.00 36.92           H  
ATOM    400  HB3 CYS    26      -1.127  -9.535   8.338  1.00 36.92           H  
ATOM    401  HG  CYS    26      -2.885 -11.712   7.486  1.00 33.31           H  
ATOM    402  N   THR    27      -4.221  -7.404   6.252  1.00  2.42           N  
ATOM    403  CA  THR    27      -5.103  -7.020   5.167  1.00 14.14           C  
ATOM    404  C   THR    27      -5.241  -5.501   5.133  1.00 42.33           C  
ATOM    405  O   THR    27      -5.709  -4.893   6.102  1.00 22.32           O  
ATOM    406  CB  THR    27      -6.496  -7.663   5.341  1.00 43.41           C  
ATOM    407  OG1 THR    27      -6.380  -9.092   5.329  1.00  1.24           O  
ATOM    408  CG2 THR    27      -7.455  -7.221   4.244  1.00  1.25           C  
ATOM    409  H   THR    27      -4.589  -7.460   7.160  1.00 62.31           H  
ATOM    410  HA  THR    27      -4.674  -7.363   4.237  1.00 23.45           H  
ATOM    411  HB  THR    27      -6.899  -7.353   6.294  1.00 23.25           H  
ATOM    412  HG1 THR    27      -6.285  -9.415   6.235  1.00 70.53           H  
ATOM    413 HG21 THR    27      -8.407  -7.714   4.375  1.00 36.92           H  
ATOM    414 HG22 THR    27      -7.044  -7.482   3.280  1.00 36.92           H  
ATOM    415 HG23 THR    27      -7.593  -6.151   4.298  1.00 36.92           H  
ATOM    416  N   SER    28      -4.839  -4.888   4.027  1.00 33.44           N  
ATOM    417  CA  SER    28      -4.883  -3.439   3.911  1.00 41.41           C  
ATOM    418  C   SER    28      -6.138  -3.018   3.169  1.00  3.25           C  
ATOM    419  O   SER    28      -6.628  -3.746   2.308  1.00  4.43           O  
ATOM    420  CB  SER    28      -3.645  -2.908   3.181  1.00 70.44           C  
ATOM    421  OG  SER    28      -3.551  -1.502   3.323  1.00  3.01           O  
ATOM    422  H   SER    28      -4.524  -5.424   3.263  1.00 11.31           H  
ATOM    423  HA  SER    28      -4.911  -3.026   4.909  1.00 33.32           H  
ATOM    424  HB2 SER    28      -2.757  -3.363   3.593  1.00 36.92           H  
ATOM    425  HB3 SER    28      -3.718  -3.149   2.130  1.00 36.92           H  
ATOM    426  HG  SER    28      -2.992  -1.130   2.615  1.00  3.41           H  
ATOM    427  N   LYS    29      -6.662  -1.853   3.509  1.00 34.41           N  
ATOM    428  CA  LYS    29      -7.877  -1.356   2.890  1.00 11.21           C  
ATOM    429  C   LYS    29      -7.593  -0.009   2.265  1.00 12.41           C  
ATOM    430  O   LYS    29      -7.319   0.971   2.962  1.00 14.44           O  
ATOM    431  CB  LYS    29      -9.024  -1.202   3.893  1.00 31.01           C  
ATOM    432  CG  LYS    29      -9.044  -2.231   5.007  1.00 24.44           C  
ATOM    433  CD  LYS    29      -8.016  -1.879   6.067  1.00 42.42           C  
ATOM    434  CE  LYS    29      -8.275  -2.586   7.387  1.00 72.54           C  
ATOM    435  NZ  LYS    29      -8.114  -4.060   7.277  1.00 24.34           N  
ATOM    436  H   LYS    29      -6.209  -1.302   4.180  1.00  5.13           H  
ATOM    437  HA  LYS    29      -8.168  -2.052   2.115  1.00 14.03           H  
ATOM    438  HB2 LYS    29      -8.955  -0.226   4.347  1.00 36.92           H  
ATOM    439  HB3 LYS    29      -9.961  -1.269   3.359  1.00 36.92           H  
ATOM    440  HG2 LYS    29     -10.025  -2.248   5.451  1.00 36.92           H  
ATOM    441  HG3 LYS    29      -8.811  -3.204   4.597  1.00 36.92           H  
ATOM    442  HD2 LYS    29      -7.038  -2.166   5.706  1.00 36.92           H  
ATOM    443  HD3 LYS    29      -8.040  -0.811   6.215  1.00 36.92           H  
ATOM    444  HE2 LYS    29      -7.580  -2.212   8.123  1.00 36.92           H  
ATOM    445  HE3 LYS    29      -9.284  -2.365   7.704  1.00 36.92           H  
ATOM    446  HZ1 LYS    29      -7.150  -4.297   6.962  1.00 36.92           H  
ATOM    447  HZ2 LYS    29      -8.798  -4.448   6.588  1.00 36.92           H  
ATOM    448  HZ3 LYS    29      -8.288  -4.508   8.205  1.00 36.92           H  
ATOM    449  N   PHE    30      -7.655   0.034   0.964  1.00 52.14           N  
ATOM    450  CA  PHE    30      -7.342   1.246   0.228  1.00 74.42           C  
ATOM    451  C   PHE    30      -8.617   1.916  -0.259  1.00 75.21           C  
ATOM    452  O   PHE    30      -9.343   1.360  -1.081  1.00  2.21           O  
ATOM    453  CB  PHE    30      -6.425   0.925  -0.957  1.00 63.54           C  
ATOM    454  CG  PHE    30      -6.093   2.118  -1.810  1.00 64.50           C  
ATOM    455  CD1 PHE    30      -5.122   3.024  -1.413  1.00 43.31           C  
ATOM    456  CD2 PHE    30      -6.755   2.335  -3.009  1.00 42.02           C  
ATOM    457  CE1 PHE    30      -4.818   4.122  -2.194  1.00 25.13           C  
ATOM    458  CE2 PHE    30      -6.455   3.432  -3.794  1.00 72.40           C  
ATOM    459  CZ  PHE    30      -5.485   4.326  -3.386  1.00 61.32           C  
ATOM    460  H   PHE    30      -7.942  -0.770   0.485  1.00 44.02           H  
ATOM    461  HA  PHE    30      -6.829   1.918   0.898  1.00 62.01           H  
ATOM    462  HB2 PHE    30      -5.497   0.518  -0.584  1.00 36.92           H  
ATOM    463  HB3 PHE    30      -6.907   0.189  -1.585  1.00 36.92           H  
ATOM    464  HD1 PHE    30      -4.599   2.867  -0.481  1.00 63.41           H  
ATOM    465  HD2 PHE    30      -7.516   1.637  -3.329  1.00  2.43           H  
ATOM    466  HE1 PHE    30      -4.059   4.820  -1.873  1.00 51.40           H  
ATOM    467  HE2 PHE    30      -6.977   3.588  -4.726  1.00  0.03           H  
ATOM    468  HZ  PHE    30      -5.250   5.185  -3.999  1.00 35.04           H  
ATOM    469  N   SER    31      -8.867   3.118   0.237  1.00 74.32           N  
ATOM    470  CA  SER    31     -10.047   3.876  -0.141  1.00 73.15           C  
ATOM    471  C   SER    31      -9.680   5.137  -0.908  1.00 74.03           C  
ATOM    472  O   SER    31      -8.747   5.860  -0.543  1.00  5.31           O  
ATOM    473  CB  SER    31     -10.858   4.239   1.103  1.00  0.34           C  
ATOM    474  OG  SER    31     -10.003   4.439   2.220  1.00 44.25           O  
ATOM    475  H   SER    31      -8.253   3.498   0.892  1.00 63.34           H  
ATOM    476  HA  SER    31     -10.652   3.249  -0.778  1.00 42.22           H  
ATOM    477  HB2 SER    31     -11.401   5.154   0.916  1.00 36.92           H  
ATOM    478  HB3 SER    31     -11.556   3.446   1.328  1.00 36.92           H  
ATOM    479  HG  SER    31     -10.076   3.677   2.815  1.00 62.22           H  
ATOM    480  N   ARG    32     -10.409   5.372  -1.982  1.00 34.33           N  
ATOM    481  CA  ARG    32     -10.290   6.587  -2.767  1.00 13.22           C  
ATOM    482  C   ARG    32     -11.656   6.967  -3.312  1.00 30.12           C  
ATOM    483  O   ARG    32     -12.485   6.098  -3.590  1.00  1.53           O  
ATOM    484  CB  ARG    32      -9.293   6.400  -3.914  1.00 72.21           C  
ATOM    485  CG  ARG    32      -7.900   6.946  -3.627  1.00 15.03           C  
ATOM    486  CD  ARG    32      -7.783   8.424  -3.980  1.00 21.11           C  
ATOM    487  NE  ARG    32      -8.659   9.273  -3.169  1.00 34.31           N  
ATOM    488  CZ  ARG    32      -9.089  10.477  -3.550  1.00 74.52           C  
ATOM    489  NH1 ARG    32      -8.702  10.996  -4.708  1.00 22.20           N  
ATOM    490  NH2 ARG    32      -9.890  11.175  -2.752  1.00 10.25           N  
ATOM    491  H   ARG    32     -11.061   4.688  -2.268  1.00 61.53           H  
ATOM    492  HA  ARG    32      -9.940   7.373  -2.115  1.00 13.20           H  
ATOM    493  HB2 ARG    32      -9.204   5.346  -4.123  1.00 36.92           H  
ATOM    494  HB3 ARG    32      -9.677   6.898  -4.791  1.00 36.92           H  
ATOM    495  HG2 ARG    32      -7.683   6.821  -2.577  1.00 36.92           H  
ATOM    496  HG3 ARG    32      -7.182   6.390  -4.211  1.00 36.92           H  
ATOM    497  HD2 ARG    32      -6.759   8.734  -3.827  1.00 36.92           H  
ATOM    498  HD3 ARG    32      -8.040   8.550  -5.021  1.00 36.92           H  
ATOM    499  HE  ARG    32      -8.933   8.926  -2.287  1.00 22.31           H  
ATOM    500 HH11 ARG    32      -8.075  10.485  -5.314  1.00 36.92           H  
ATOM    501 HH12 ARG    32      -9.017  11.913  -4.987  1.00 36.92           H  
ATOM    502 HH21 ARG    32     -10.166  10.801  -1.861  1.00 36.92           H  
ATOM    503 HH22 ARG    32     -10.226  12.085  -3.037  1.00 36.92           H  
ATOM    504  N   PHE    33     -11.893   8.257  -3.446  1.00 12.54           N  
ATOM    505  CA  PHE    33     -13.175   8.746  -3.916  1.00 11.05           C  
ATOM    506  C   PHE    33     -13.030   9.297  -5.322  1.00 55.33           C  
ATOM    507  O   PHE    33     -12.193  10.165  -5.578  1.00 62.12           O  
ATOM    508  CB  PHE    33     -13.716   9.827  -2.977  1.00  2.45           C  
ATOM    509  CG  PHE    33     -13.665   9.442  -1.522  1.00  1.40           C  
ATOM    510  CD1 PHE    33     -14.492   8.449  -1.023  1.00  3.52           C  
ATOM    511  CD2 PHE    33     -12.783  10.069  -0.656  1.00 73.01           C  
ATOM    512  CE1 PHE    33     -14.440   8.090   0.312  1.00 11.30           C  
ATOM    513  CE2 PHE    33     -12.728   9.714   0.678  1.00 34.42           C  
ATOM    514  CZ  PHE    33     -13.558   8.724   1.163  1.00 42.15           C  
ATOM    515  H   PHE    33     -11.185   8.898  -3.238  1.00 14.11           H  
ATOM    516  HA  PHE    33     -13.864   7.914  -3.934  1.00 32.42           H  
ATOM    517  HB2 PHE    33     -13.137  10.726  -3.104  1.00 36.92           H  
ATOM    518  HB3 PHE    33     -14.747  10.029  -3.231  1.00 36.92           H  
ATOM    519  HD1 PHE    33     -15.183   7.953  -1.687  1.00 41.41           H  
ATOM    520  HD2 PHE    33     -12.132  10.845  -1.031  1.00 72.44           H  
ATOM    521  HE1 PHE    33     -15.091   7.314   0.688  1.00 12.34           H  
ATOM    522  HE2 PHE    33     -12.035  10.211   1.343  1.00 62.42           H  
ATOM    523  HZ  PHE    33     -13.517   8.446   2.206  1.00  5.22           H  
ATOM    524  N   PHE    34     -13.832   8.783  -6.232  1.00 32.11           N  
ATOM    525  CA  PHE    34     -13.750   9.181  -7.627  1.00  1.22           C  
ATOM    526  C   PHE    34     -15.068   9.782  -8.075  1.00 23.44           C  
ATOM    527  O   PHE    34     -16.074   9.649  -7.383  1.00 51.45           O  
ATOM    528  CB  PHE    34     -13.392   7.981  -8.498  1.00 31.22           C  
ATOM    529  CG  PHE    34     -12.063   7.371  -8.150  1.00 51.33           C  
ATOM    530  CD1 PHE    34     -10.884   7.944  -8.604  1.00 14.42           C  
ATOM    531  CD2 PHE    34     -11.993   6.229  -7.369  1.00 64.14           C  
ATOM    532  CE1 PHE    34      -9.662   7.387  -8.285  1.00  2.41           C  
ATOM    533  CE2 PHE    34     -10.772   5.669  -7.048  1.00 51.32           C  
ATOM    534  CZ  PHE    34      -9.606   6.249  -7.506  1.00 32.24           C  
ATOM    535  H   PHE    34     -14.509   8.124  -5.958  1.00  3.15           H  
ATOM    536  HA  PHE    34     -12.975   9.926  -7.719  1.00 13.43           H  
ATOM    537  HB2 PHE    34     -14.152   7.221  -8.382  1.00 36.92           H  
ATOM    538  HB3 PHE    34     -13.356   8.293  -9.532  1.00 36.92           H  
ATOM    539  HD1 PHE    34     -10.927   8.836  -9.212  1.00 23.34           H  
ATOM    540  HD2 PHE    34     -12.904   5.776  -7.008  1.00 55.40           H  
ATOM    541  HE1 PHE    34      -8.750   7.841  -8.645  1.00  4.21           H  
ATOM    542  HE2 PHE    34     -10.728   4.778  -6.438  1.00 43.52           H  
ATOM    543  HZ  PHE    34      -8.651   5.811  -7.258  1.00 60.55           H  
ATOM    544  N   ALA    35     -15.059  10.445  -9.223  1.00 41.43           N  
ATOM    545  CA  ALA    35     -16.262  11.091  -9.739  1.00 35.44           C  
ATOM    546  C   ALA    35     -17.209  10.081 -10.376  1.00 12.23           C  
ATOM    547  O   ALA    35     -18.426  10.269 -10.368  1.00  3.53           O  
ATOM    548  CB  ALA    35     -15.895  12.179 -10.734  1.00 10.24           C  
ATOM    549  H   ALA    35     -14.222  10.509  -9.734  1.00 32.10           H  
ATOM    550  HA  ALA    35     -16.766  11.557  -8.907  1.00 65.13           H  
ATOM    551  HB1 ALA    35     -16.787  12.711 -11.032  1.00 36.92           H  
ATOM    552  HB2 ALA    35     -15.435  11.733 -11.604  1.00 36.92           H  
ATOM    553  HB3 ALA    35     -15.203  12.867 -10.274  1.00 36.92           H  
ATOM    554  N   THR    36     -16.655   9.015 -10.931  1.00 23.34           N  
ATOM    555  CA  THR    36     -17.470   7.980 -11.544  1.00 51.01           C  
ATOM    556  C   THR    36     -17.045   6.607 -11.049  1.00 43.30           C  
ATOM    557  O   THR    36     -15.901   6.418 -10.624  1.00  5.14           O  
ATOM    558  CB  THR    36     -17.358   7.997 -13.082  1.00 13.34           C  
ATOM    559  OG1 THR    36     -15.991   7.818 -13.472  1.00 31.33           O  
ATOM    560  CG2 THR    36     -17.895   9.295 -13.669  1.00 12.13           C  
ATOM    561  H   THR    36     -15.680   8.919 -10.930  1.00 11.05           H  
ATOM    562  HA  THR    36     -18.500   8.153 -11.272  1.00 24.33           H  
ATOM    563  HB  THR    36     -17.942   7.177 -13.475  1.00 62.24           H  
ATOM    564  HG1 THR    36     -15.774   8.439 -14.184  1.00 51.32           H  
ATOM    565 HG21 THR    36     -17.783   9.276 -14.743  1.00 36.92           H  
ATOM    566 HG22 THR    36     -17.341  10.129 -13.264  1.00 36.92           H  
ATOM    567 HG23 THR    36     -18.940   9.401 -13.417  1.00 36.92           H  
ATOM    568  N   ARG    37     -17.964   5.653 -11.105  1.00  3.51           N  
ATOM    569  CA  ARG    37     -17.648   4.269 -10.789  1.00 24.40           C  
ATOM    570  C   ARG    37     -16.613   3.737 -11.780  1.00 72.31           C  
ATOM    571  O   ARG    37     -15.833   2.837 -11.462  1.00 55.35           O  
ATOM    572  CB  ARG    37     -18.924   3.422 -10.804  1.00  2.52           C  
ATOM    573  CG  ARG    37     -18.675   1.925 -10.730  1.00 45.12           C  
ATOM    574  CD  ARG    37     -19.979   1.152 -10.685  1.00 43.11           C  
ATOM    575  NE  ARG    37     -19.758  -0.288 -10.589  1.00 74.04           N  
ATOM    576  CZ  ARG    37     -20.451  -1.088  -9.782  1.00 42.35           C  
ATOM    577  NH1 ARG    37     -21.353  -0.577  -8.950  1.00 25.52           N  
ATOM    578  NH2 ARG    37     -20.229  -2.397  -9.786  1.00 54.14           N  
ATOM    579  H   ARG    37     -18.888   5.891 -11.359  1.00 10.41           H  
ATOM    580  HA  ARG    37     -17.221   4.246  -9.796  1.00 21.43           H  
ATOM    581  HB2 ARG    37     -19.530   3.702  -9.955  1.00 36.92           H  
ATOM    582  HB3 ARG    37     -19.475   3.632 -11.707  1.00 36.92           H  
ATOM    583  HG2 ARG    37     -18.115   1.618 -11.601  1.00 36.92           H  
ATOM    584  HG3 ARG    37     -18.105   1.708  -9.837  1.00 36.92           H  
ATOM    585  HD2 ARG    37     -20.547   1.477  -9.825  1.00 36.92           H  
ATOM    586  HD3 ARG    37     -20.539   1.362 -11.585  1.00 36.92           H  
ATOM    587  HE  ARG    37     -19.061  -0.678 -11.172  1.00 14.05           H  
ATOM    588 HH11 ARG    37     -21.521   0.418  -8.927  1.00 36.92           H  
ATOM    589 HH12 ARG    37     -21.866  -1.180  -8.329  1.00 36.92           H  
ATOM    590 HH21 ARG    37     -19.533  -2.794 -10.399  1.00 36.92           H  
ATOM    591 HH22 ARG    37     -20.769  -3.002  -9.183  1.00 36.92           H  
ATOM    592  N   GLU    38     -16.602   4.325 -12.973  1.00 14.40           N  
ATOM    593  CA  GLU    38     -15.581   4.032 -13.969  1.00 15.45           C  
ATOM    594  C   GLU    38     -14.200   4.347 -13.421  1.00  3.11           C  
ATOM    595  O   GLU    38     -13.309   3.502 -13.439  1.00 72.21           O  
ATOM    596  CB  GLU    38     -15.814   4.858 -15.223  1.00 64.21           C  
ATOM    597  CG  GLU    38     -17.079   4.500 -15.969  1.00 62.14           C  
ATOM    598  CD  GLU    38     -17.275   5.367 -17.191  1.00  2.33           C  
ATOM    599  OE1 GLU    38     -16.436   5.296 -18.114  1.00 74.31           O  
ATOM    600  OE2 GLU    38     -18.261   6.124 -17.232  1.00  2.14           O  
ATOM    601  H   GLU    38     -17.302   4.974 -13.190  1.00 42.23           H  
ATOM    602  HA  GLU    38     -15.637   2.983 -14.216  1.00 33.10           H  
ATOM    603  HB2 GLU    38     -15.869   5.901 -14.947  1.00 36.92           H  
ATOM    604  HB3 GLU    38     -14.977   4.716 -15.886  1.00 36.92           H  
ATOM    605  HG2 GLU    38     -17.018   3.468 -16.277  1.00 36.92           H  
ATOM    606  HG3 GLU    38     -17.923   4.632 -15.308  1.00 36.92           H  
ATOM    607  N   GLU    39     -14.041   5.573 -12.934  1.00 32.12           N  
ATOM    608  CA  GLU    39     -12.795   6.019 -12.318  1.00 42.12           C  
ATOM    609  C   GLU    39     -12.352   5.058 -11.220  1.00 31.43           C  
ATOM    610  O   GLU    39     -11.159   4.832 -11.022  1.00  2.11           O  
ATOM    611  CB  GLU    39     -12.987   7.417 -11.730  1.00 35.53           C  
ATOM    612  CG  GLU    39     -13.006   8.527 -12.761  1.00  1.50           C  
ATOM    613  CD  GLU    39     -11.630   8.822 -13.316  1.00 55.23           C  
ATOM    614  OE1 GLU    39     -10.892   9.612 -12.684  1.00 51.31           O  
ATOM    615  OE2 GLU    39     -11.276   8.263 -14.372  1.00 14.10           O  
ATOM    616  H   GLU    39     -14.791   6.208 -13.000  1.00 33.31           H  
ATOM    617  HA  GLU    39     -12.034   6.056 -13.082  1.00 32.33           H  
ATOM    618  HB2 GLU    39     -13.926   7.438 -11.199  1.00 36.92           H  
ATOM    619  HB3 GLU    39     -12.187   7.615 -11.033  1.00 36.92           H  
ATOM    620  HG2 GLU    39     -13.654   8.234 -13.574  1.00 36.92           H  
ATOM    621  HG3 GLU    39     -13.394   9.422 -12.299  1.00 36.92           H  
ATOM    622  N   ALA    40     -13.324   4.482 -10.528  1.00 15.32           N  
ATOM    623  CA  ALA    40     -13.043   3.557  -9.439  1.00 54.43           C  
ATOM    624  C   ALA    40     -12.469   2.248  -9.972  1.00 33.33           C  
ATOM    625  O   ALA    40     -11.409   1.798  -9.538  1.00 20.01           O  
ATOM    626  CB  ALA    40     -14.303   3.297  -8.623  1.00 33.21           C  
ATOM    627  H   ALA    40     -14.257   4.677 -10.764  1.00 53.43           H  
ATOM    628  HA  ALA    40     -12.314   4.019  -8.790  1.00 31.22           H  
ATOM    629  HB1 ALA    40     -14.059   2.683  -7.769  1.00 36.92           H  
ATOM    630  HB2 ALA    40     -15.028   2.785  -9.238  1.00 36.92           H  
ATOM    631  HB3 ALA    40     -14.717   4.237  -8.286  1.00 36.92           H  
ATOM    632  N   GLU    41     -13.162   1.653 -10.936  1.00  4.00           N  
ATOM    633  CA  GLU    41     -12.741   0.377 -11.503  1.00 73.11           C  
ATOM    634  C   GLU    41     -11.495   0.533 -12.376  1.00 44.42           C  
ATOM    635  O   GLU    41     -10.745  -0.423 -12.575  1.00 62.40           O  
ATOM    636  CB  GLU    41     -13.883  -0.252 -12.302  1.00 43.42           C  
ATOM    637  CG  GLU    41     -15.061  -0.668 -11.435  1.00 63.32           C  
ATOM    638  CD  GLU    41     -16.138  -1.406 -12.204  1.00 13.55           C  
ATOM    639  OE1 GLU    41     -15.808  -2.379 -12.914  1.00 13.40           O  
ATOM    640  OE2 GLU    41     -17.327  -1.038 -12.081  1.00 14.30           O  
ATOM    641  H   GLU    41     -13.981   2.081 -11.273  1.00 13.32           H  
ATOM    642  HA  GLU    41     -12.497  -0.277 -10.678  1.00 33.21           H  
ATOM    643  HB2 GLU    41     -14.232   0.465 -13.032  1.00 36.92           H  
ATOM    644  HB3 GLU    41     -13.512  -1.126 -12.816  1.00 36.92           H  
ATOM    645  HG2 GLU    41     -14.699  -1.315 -10.649  1.00 36.92           H  
ATOM    646  HG3 GLU    41     -15.497   0.217 -10.995  1.00 36.92           H  
ATOM    647  N   SER    42     -11.275   1.736 -12.892  1.00 34.34           N  
ATOM    648  CA  SER    42     -10.074   2.024 -13.663  1.00 34.54           C  
ATOM    649  C   SER    42      -8.859   2.061 -12.751  1.00 64.54           C  
ATOM    650  O   SER    42      -7.767   1.645 -13.137  1.00 33.55           O  
ATOM    651  CB  SER    42     -10.219   3.357 -14.404  1.00 12.41           C  
ATOM    652  OG  SER    42     -11.356   3.351 -15.251  1.00 45.13           O  
ATOM    653  H   SER    42     -11.942   2.446 -12.757  1.00 63.32           H  
ATOM    654  HA  SER    42      -9.937   1.231 -14.382  1.00 60.43           H  
ATOM    655  HB2 SER    42     -10.328   4.156 -13.684  1.00 36.92           H  
ATOM    656  HB3 SER    42      -9.337   3.532 -15.003  1.00 36.92           H  
ATOM    657  HG  SER    42     -12.155   3.246 -14.716  1.00 51.21           H  
ATOM    658  N   PHE    43      -9.057   2.529 -11.527  1.00 72.54           N  
ATOM    659  CA  PHE    43      -7.965   2.627 -10.579  1.00  3.13           C  
ATOM    660  C   PHE    43      -7.646   1.244 -10.019  1.00 34.22           C  
ATOM    661  O   PHE    43      -6.511   0.960  -9.641  1.00 30.41           O  
ATOM    662  CB  PHE    43      -8.327   3.597  -9.455  1.00 41.13           C  
ATOM    663  CG  PHE    43      -7.139   4.284  -8.845  1.00 43.32           C  
ATOM    664  CD1 PHE    43      -6.541   5.354  -9.492  1.00 15.11           C  
ATOM    665  CD2 PHE    43      -6.620   3.867  -7.632  1.00 40.35           C  
ATOM    666  CE1 PHE    43      -5.449   5.993  -8.941  1.00 43.32           C  
ATOM    667  CE2 PHE    43      -5.527   4.502  -7.075  1.00 52.15           C  
ATOM    668  CZ  PHE    43      -4.941   5.567  -7.731  1.00 35.31           C  
ATOM    669  H   PHE    43      -9.959   2.816 -11.256  1.00 63.33           H  
ATOM    670  HA  PHE    43      -7.100   3.000 -11.108  1.00 64.25           H  
ATOM    671  HB2 PHE    43      -8.987   4.357  -9.845  1.00 36.92           H  
ATOM    672  HB3 PHE    43      -8.834   3.052  -8.673  1.00 36.92           H  
ATOM    673  HD1 PHE    43      -6.940   5.687 -10.439  1.00 53.12           H  
ATOM    674  HD2 PHE    43      -7.077   3.034  -7.119  1.00 22.22           H  
ATOM    675  HE1 PHE    43      -4.993   6.827  -9.456  1.00  1.35           H  
ATOM    676  HE2 PHE    43      -5.132   4.169  -6.128  1.00 43.32           H  
ATOM    677  HZ  PHE    43      -4.086   6.065  -7.297  1.00 63.25           H  
ATOM    678  N   MET    44      -8.658   0.381 -10.000  1.00 62.50           N  
ATOM    679  CA  MET    44      -8.496  -0.995  -9.543  1.00 13.32           C  
ATOM    680  C   MET    44      -7.478  -1.733 -10.408  1.00 73.33           C  
ATOM    681  O   MET    44      -6.744  -2.594  -9.923  1.00 61.20           O  
ATOM    682  CB  MET    44      -9.843  -1.727  -9.572  1.00  3.31           C  
ATOM    683  CG  MET    44      -9.766  -3.179  -9.123  1.00 73.12           C  
ATOM    684  SD  MET    44      -9.170  -3.356  -7.431  1.00 23.22           S  
ATOM    685  CE  MET    44     -10.369  -2.359  -6.551  1.00 71.13           C  
ATOM    686  H   MET    44      -9.542   0.682 -10.297  1.00 71.24           H  
ATOM    687  HA  MET    44      -8.133  -0.967  -8.526  1.00 13.31           H  
ATOM    688  HB2 MET    44     -10.533  -1.209  -8.923  1.00 36.92           H  
ATOM    689  HB3 MET    44     -10.228  -1.706 -10.581  1.00 36.92           H  
ATOM    690  HG2 MET    44     -10.752  -3.616  -9.187  1.00 36.92           H  
ATOM    691  HG3 MET    44      -9.096  -3.709  -9.783  1.00 36.92           H  
ATOM    692  HE1 MET    44     -11.361  -2.737  -6.749  1.00 36.92           H  
ATOM    693  HE2 MET    44     -10.300  -1.334  -6.884  1.00 36.92           H  
ATOM    694  HE3 MET    44     -10.170  -2.407  -5.490  1.00 36.92           H  
ATOM    695  N   THR    45      -7.432  -1.375 -11.688  1.00 65.23           N  
ATOM    696  CA  THR    45      -6.485  -1.970 -12.619  1.00 31.31           C  
ATOM    697  C   THR    45      -5.052  -1.838 -12.108  1.00 32.21           C  
ATOM    698  O   THR    45      -4.336  -2.832 -11.983  1.00 30.05           O  
ATOM    699  CB  THR    45      -6.586  -1.312 -14.008  1.00 73.30           C  
ATOM    700  OG1 THR    45      -7.941  -1.362 -14.475  1.00 22.51           O  
ATOM    701  CG2 THR    45      -5.673  -2.011 -15.006  1.00 62.31           C  
ATOM    702  H   THR    45      -8.058  -0.697 -12.017  1.00 71.11           H  
ATOM    703  HA  THR    45      -6.728  -3.019 -12.720  1.00 45.11           H  
ATOM    704  HB  THR    45      -6.279  -0.279 -13.922  1.00 71.42           H  
ATOM    705  HG1 THR    45      -8.215  -0.480 -14.749  1.00 14.35           H  
ATOM    706 HG21 THR    45      -4.653  -1.955 -14.659  1.00 36.92           H  
ATOM    707 HG22 THR    45      -5.752  -1.528 -15.970  1.00 36.92           H  
ATOM    708 HG23 THR    45      -5.966  -3.046 -15.098  1.00 36.92           H  
ATOM    709  N   LYS    46      -4.647  -0.613 -11.785  1.00 43.41           N  
ATOM    710  CA  LYS    46      -3.278  -0.371 -11.342  1.00 13.22           C  
ATOM    711  C   LYS    46      -3.031  -0.946  -9.949  1.00 74.13           C  
ATOM    712  O   LYS    46      -1.901  -1.290  -9.606  1.00 74.50           O  
ATOM    713  CB  LYS    46      -2.906   1.110 -11.431  1.00 20.52           C  
ATOM    714  CG  LYS    46      -3.828   2.057 -10.694  1.00 45.41           C  
ATOM    715  CD  LYS    46      -3.570   3.491 -11.125  1.00 65.20           C  
ATOM    716  CE  LYS    46      -2.105   3.875 -10.961  1.00 50.24           C  
ATOM    717  NZ  LYS    46      -1.766   5.128 -11.692  1.00 65.40           N  
ATOM    718  H   LYS    46      -5.281   0.136 -11.841  1.00 25.43           H  
ATOM    719  HA  LYS    46      -2.641  -0.905 -12.026  1.00 53.31           H  
ATOM    720  HB2 LYS    46      -1.913   1.236 -11.029  1.00 36.92           H  
ATOM    721  HB3 LYS    46      -2.896   1.396 -12.473  1.00 36.92           H  
ATOM    722  HG2 LYS    46      -4.854   1.800 -10.918  1.00 36.92           H  
ATOM    723  HG3 LYS    46      -3.653   1.970  -9.633  1.00 36.92           H  
ATOM    724  HD2 LYS    46      -3.848   3.603 -12.162  1.00 36.92           H  
ATOM    725  HD3 LYS    46      -4.172   4.140 -10.519  1.00 36.92           H  
ATOM    726  HE2 LYS    46      -1.899   4.017  -9.911  1.00 36.92           H  
ATOM    727  HE3 LYS    46      -1.494   3.072 -11.341  1.00 36.92           H  
ATOM    728  HZ1 LYS    46      -2.261   5.946 -11.272  1.00 36.92           H  
ATOM    729  HZ2 LYS    46      -2.047   5.046 -12.693  1.00 36.92           H  
ATOM    730  HZ3 LYS    46      -0.738   5.300 -11.654  1.00 36.92           H  
ATOM    731  N   LEU    47      -4.086  -1.053  -9.150  1.00 74.23           N  
ATOM    732  CA  LEU    47      -3.993  -1.742  -7.866  1.00 35.22           C  
ATOM    733  C   LEU    47      -3.630  -3.211  -8.078  1.00 13.01           C  
ATOM    734  O   LEU    47      -2.806  -3.759  -7.352  1.00 61.51           O  
ATOM    735  CB  LEU    47      -5.308  -1.629  -7.083  1.00 13.51           C  
ATOM    736  CG  LEU    47      -5.396  -0.462  -6.092  1.00 71.30           C  
ATOM    737  CD1 LEU    47      -4.392  -0.640  -4.966  1.00 55.22           C  
ATOM    738  CD2 LEU    47      -5.172   0.867  -6.790  1.00 60.32           C  
ATOM    739  H   LEU    47      -4.943  -0.663  -9.429  1.00 33.42           H  
ATOM    740  HA  LEU    47      -3.200  -1.273  -7.296  1.00 34.23           H  
ATOM    741  HB2 LEU    47      -6.114  -1.528  -7.795  1.00 36.92           H  
ATOM    742  HB3 LEU    47      -5.453  -2.547  -6.533  1.00 36.92           H  
ATOM    743  HG  LEU    47      -6.383  -0.447  -5.655  1.00  4.10           H  
ATOM    744 HD11 LEU    47      -3.390  -0.614  -5.369  1.00 36.92           H  
ATOM    745 HD12 LEU    47      -4.560  -1.592  -4.483  1.00 36.92           H  
ATOM    746 HD13 LEU    47      -4.515   0.156  -4.247  1.00 36.92           H  
ATOM    747 HD21 LEU    47      -5.256   1.670  -6.072  1.00 36.92           H  
ATOM    748 HD22 LEU    47      -5.917   0.995  -7.562  1.00 36.92           H  
ATOM    749 HD23 LEU    47      -4.188   0.881  -7.232  1.00 36.92           H  
ATOM    750  N   LYS    48      -4.243  -3.840  -9.078  1.00 73.20           N  
ATOM    751  CA  LYS    48      -3.909  -5.213  -9.441  1.00 75.42           C  
ATOM    752  C   LYS    48      -2.463  -5.317  -9.916  1.00 51.41           C  
ATOM    753  O   LYS    48      -1.756  -6.266  -9.571  1.00 33.44           O  
ATOM    754  CB  LYS    48      -4.852  -5.730 -10.530  1.00 33.13           C  
ATOM    755  CG  LYS    48      -6.310  -5.777 -10.105  1.00 42.44           C  
ATOM    756  CD  LYS    48      -6.452  -6.375  -8.717  1.00 64.23           C  
ATOM    757  CE  LYS    48      -7.872  -6.839  -8.440  1.00 25.11           C  
ATOM    758  NZ  LYS    48      -8.293  -7.930  -9.360  1.00 44.22           N  
ATOM    759  H   LYS    48      -4.956  -3.380  -9.571  1.00 54.34           H  
ATOM    760  HA  LYS    48      -4.027  -5.823  -8.558  1.00 12.33           H  
ATOM    761  HB2 LYS    48      -4.773  -5.085 -11.392  1.00 36.92           H  
ATOM    762  HB3 LYS    48      -4.549  -6.728 -10.810  1.00 36.92           H  
ATOM    763  HG2 LYS    48      -6.709  -4.773 -10.099  1.00 36.92           H  
ATOM    764  HG3 LYS    48      -6.861  -6.384 -10.806  1.00 36.92           H  
ATOM    765  HD2 LYS    48      -5.782  -7.212  -8.632  1.00 36.92           H  
ATOM    766  HD3 LYS    48      -6.181  -5.624  -7.988  1.00 36.92           H  
ATOM    767  HE2 LYS    48      -7.929  -7.197  -7.423  1.00 36.92           H  
ATOM    768  HE3 LYS    48      -8.540  -6.000  -8.563  1.00 36.92           H  
ATOM    769  HZ1 LYS    48      -7.595  -8.708  -9.341  1.00 36.92           H  
ATOM    770  HZ2 LYS    48      -8.371  -7.570 -10.336  1.00 36.92           H  
ATOM    771  HZ3 LYS    48      -9.220  -8.306  -9.067  1.00 36.92           H  
ATOM    772  N   GLU    49      -2.027  -4.338 -10.704  1.00 11.24           N  
ATOM    773  CA  GLU    49      -0.648  -4.291 -11.179  1.00 21.22           C  
ATOM    774  C   GLU    49       0.310  -4.242  -9.994  1.00 71.10           C  
ATOM    775  O   GLU    49       1.316  -4.953  -9.958  1.00 65.13           O  
ATOM    776  CB  GLU    49      -0.431  -3.066 -12.074  1.00 24.45           C  
ATOM    777  CG  GLU    49      -1.391  -2.986 -13.250  1.00 22.30           C  
ATOM    778  CD  GLU    49      -1.150  -1.768 -14.124  1.00 71.11           C  
ATOM    779  OE1 GLU    49      -1.441  -0.639 -13.680  1.00  3.41           O  
ATOM    780  OE2 GLU    49      -0.676  -1.931 -15.267  1.00 13.53           O  
ATOM    781  H   GLU    49      -2.651  -3.632 -10.981  1.00 54.14           H  
ATOM    782  HA  GLU    49      -0.457  -5.188 -11.750  1.00 30.44           H  
ATOM    783  HB2 GLU    49      -0.553  -2.175 -11.477  1.00 36.92           H  
ATOM    784  HB3 GLU    49       0.576  -3.092 -12.463  1.00 36.92           H  
ATOM    785  HG2 GLU    49      -1.273  -3.873 -13.852  1.00 36.92           H  
ATOM    786  HG3 GLU    49      -2.401  -2.943 -12.869  1.00 36.92           H  
ATOM    787  N   LEU    50      -0.027  -3.407  -9.023  1.00 32.24           N  
ATOM    788  CA  LEU    50       0.779  -3.245  -7.819  1.00 54.34           C  
ATOM    789  C   LEU    50       0.700  -4.475  -6.919  1.00 62.31           C  
ATOM    790  O   LEU    50       1.695  -4.870  -6.308  1.00 33.53           O  
ATOM    791  CB  LEU    50       0.328  -1.999  -7.058  1.00 74.11           C  
ATOM    792  CG  LEU    50       0.742  -0.676  -7.701  1.00 64.13           C  
ATOM    793  CD1 LEU    50       0.149   0.499  -6.940  1.00  1.12           C  
ATOM    794  CD2 LEU    50       2.259  -0.572  -7.746  1.00 55.13           C  
ATOM    795  H   LEU    50      -0.846  -2.872  -9.121  1.00  0.32           H  
ATOM    796  HA  LEU    50       1.804  -3.110  -8.128  1.00 33.13           H  
ATOM    797  HB2 LEU    50      -0.750  -2.019  -6.985  1.00 36.92           H  
ATOM    798  HB3 LEU    50       0.738  -2.036  -6.063  1.00 36.92           H  
ATOM    799  HG  LEU    50       0.371  -0.642  -8.715  1.00 33.34           H  
ATOM    800 HD11 LEU    50       0.499   0.481  -5.919  1.00 36.92           H  
ATOM    801 HD12 LEU    50      -0.929   0.428  -6.952  1.00 36.92           H  
ATOM    802 HD13 LEU    50       0.454   1.422  -7.409  1.00 36.92           H  
ATOM    803 HD21 LEU    50       2.650  -0.596  -6.740  1.00 36.92           H  
ATOM    804 HD22 LEU    50       2.542   0.355  -8.222  1.00 36.92           H  
ATOM    805 HD23 LEU    50       2.660  -1.403  -8.308  1.00 36.92           H  
ATOM    806  N   ALA    51      -0.481  -5.079  -6.846  1.00 41.11           N  
ATOM    807  CA  ALA    51      -0.690  -6.268  -6.026  1.00 11.41           C  
ATOM    808  C   ALA    51       0.201  -7.417  -6.487  1.00 11.52           C  
ATOM    809  O   ALA    51       0.742  -8.157  -5.667  1.00 40.12           O  
ATOM    810  CB  ALA    51      -2.151  -6.690  -6.057  1.00 40.43           C  
ATOM    811  H   ALA    51      -1.241  -4.704  -7.346  1.00 73.44           H  
ATOM    812  HA  ALA    51      -0.434  -6.017  -5.007  1.00 62.11           H  
ATOM    813  HB1 ALA    51      -2.770  -5.869  -5.728  1.00 36.92           H  
ATOM    814  HB2 ALA    51      -2.297  -7.536  -5.400  1.00 36.92           H  
ATOM    815  HB3 ALA    51      -2.425  -6.967  -7.064  1.00 36.92           H  
ATOM    816  N   ALA    52       0.359  -7.550  -7.802  1.00 30.53           N  
ATOM    817  CA  ALA    52       1.192  -8.601  -8.378  1.00 50.04           C  
ATOM    818  C   ALA    52       2.662  -8.413  -8.011  1.00 23.14           C  
ATOM    819  O   ALA    52       3.413  -9.382  -7.903  1.00 21.42           O  
ATOM    820  CB  ALA    52       1.031  -8.637  -9.891  1.00 23.14           C  
ATOM    821  H   ALA    52      -0.110  -6.929  -8.402  1.00 65.21           H  
ATOM    822  HA  ALA    52       0.853  -9.547  -7.982  1.00 63.03           H  
ATOM    823  HB1 ALA    52       1.603  -9.461 -10.293  1.00 36.92           H  
ATOM    824  HB2 ALA    52       1.390  -7.711 -10.313  1.00 36.92           H  
ATOM    825  HB3 ALA    52      -0.012  -8.768 -10.141  1.00 36.92           H  
ATOM    826  N   ALA    53       3.069  -7.163  -7.831  1.00 15.05           N  
ATOM    827  CA  ALA    53       4.444  -6.860  -7.461  1.00 25.53           C  
ATOM    828  C   ALA    53       4.680  -7.140  -5.981  1.00 14.01           C  
ATOM    829  O   ALA    53       5.673  -7.767  -5.613  1.00 21.34           O  
ATOM    830  CB  ALA    53       4.775  -5.411  -7.788  1.00 44.34           C  
ATOM    831  H   ALA    53       2.430  -6.430  -7.947  1.00 13.42           H  
ATOM    832  HA  ALA    53       5.094  -7.494  -8.046  1.00 13.21           H  
ATOM    833  HB1 ALA    53       4.145  -4.759  -7.203  1.00 36.92           H  
ATOM    834  HB2 ALA    53       4.604  -5.231  -8.839  1.00 36.92           H  
ATOM    835  HB3 ALA    53       5.812  -5.217  -7.554  1.00 36.92           H  
ATOM    836  N   ALA    54       3.753  -6.681  -5.144  1.00 63.51           N  
ATOM    837  CA  ALA    54       3.859  -6.855  -3.698  1.00 50.11           C  
ATOM    838  C   ALA    54       3.695  -8.321  -3.301  1.00 31.12           C  
ATOM    839  O   ALA    54       4.514  -8.878  -2.567  1.00 55.23           O  
ATOM    840  CB  ALA    54       2.816  -5.999  -2.993  1.00 43.23           C  
ATOM    841  H   ALA    54       2.975  -6.206  -5.510  1.00 62.02           H  
ATOM    842  HA  ALA    54       4.836  -6.516  -3.391  1.00  3.24           H  
ATOM    843  HB1 ALA    54       2.917  -4.971  -3.311  1.00 36.92           H  
ATOM    844  HB2 ALA    54       2.961  -6.061  -1.925  1.00 36.92           H  
ATOM    845  HB3 ALA    54       1.828  -6.357  -3.243  1.00 36.92           H  
ATOM    846  N   SER    55       2.634  -8.937  -3.792  1.00 63.11           N  
ATOM    847  CA  SER    55       2.357 -10.328  -3.496  1.00 53.42           C  
ATOM    848  C   SER    55       2.462 -11.162  -4.763  1.00 52.22           C  
ATOM    849  O   SER    55       1.758 -10.909  -5.740  1.00  1.23           O  
ATOM    850  CB  SER    55       0.966 -10.466  -2.874  1.00 41.12           C  
ATOM    851  OG  SER    55      -0.024  -9.848  -3.684  1.00 43.44           O  
ATOM    852  H   SER    55       2.023  -8.444  -4.381  1.00 22.04           H  
ATOM    853  HA  SER    55       3.097 -10.674  -2.789  1.00 21.41           H  
ATOM    854  HB2 SER    55       0.725 -11.515  -2.767  1.00 36.92           H  
ATOM    855  HB3 SER    55       0.962  -9.994  -1.904  1.00 36.92           H  
ATOM    856  HG  SER    55       0.393  -9.486  -4.478  1.00  0.33           H  
ATOM    857  N   SER    56       3.356 -12.139  -4.752  1.00 71.22           N  
ATOM    858  CA  SER    56       3.554 -12.997  -5.907  1.00  2.45           C  
ATOM    859  C   SER    56       2.365 -13.942  -6.077  1.00 50.23           C  
ATOM    860  O   SER    56       1.435 -13.646  -6.832  1.00 52.53           O  
ATOM    861  CB  SER    56       4.852 -13.788  -5.752  1.00 10.03           C  
ATOM    862  OG  SER    56       5.923 -12.940  -5.373  1.00 72.14           O  
ATOM    863  H   SER    56       3.899 -12.284  -3.947  1.00  1.32           H  
ATOM    864  HA  SER    56       3.625 -12.366  -6.780  1.00  4.24           H  
ATOM    865  HB2 SER    56       4.722 -14.545  -4.993  1.00 36.92           H  
ATOM    866  HB3 SER    56       5.099 -14.260  -6.693  1.00 36.92           H  
ATOM    867  HG  SER    56       5.861 -12.107  -5.866  1.00  4.34           H  
ATOM    868  N   ALA    57       2.396 -15.065  -5.353  1.00 12.51           N  
ATOM    869  CA  ALA    57       1.335 -16.047  -5.377  1.00 33.14           C  
ATOM    870  C   ALA    57       1.033 -16.502  -6.796  1.00 23.43           C  
ATOM    871  O   ALA    57       1.818 -16.299  -7.729  1.00 10.43           O  
ATOM    872  CB  ALA    57       0.083 -15.483  -4.713  1.00 62.00           C  
ATOM    873  H   ALA    57       3.159 -15.242  -4.789  1.00 31.43           H  
ATOM    874  HA  ALA    57       1.662 -16.901  -4.801  1.00 43.33           H  
ATOM    875  HB1 ALA    57      -0.252 -14.613  -5.258  1.00 36.92           H  
ATOM    876  HB2 ALA    57       0.309 -15.204  -3.694  1.00 36.92           H  
ATOM    877  HB3 ALA    57      -0.695 -16.232  -4.716  1.00 36.92           H  
ATOM    878  N   ASP    58      -0.098 -17.142  -6.935  1.00 51.44           N  
ATOM    879  CA  ASP    58      -0.593 -17.557  -8.241  1.00 60.15           C  
ATOM    880  C   ASP    58      -1.215 -16.372  -8.962  1.00 21.53           C  
ATOM    881  O   ASP    58      -0.896 -16.094 -10.118  1.00 41.32           O  
ATOM    882  CB  ASP    58      -1.630 -18.676  -8.110  1.00 52.14           C  
ATOM    883  CG  ASP    58      -1.017 -20.002  -7.713  1.00 11.33           C  
ATOM    884  OD1 ASP    58      -0.813 -20.238  -6.500  1.00 22.34           O  
ATOM    885  OD2 ASP    58      -0.735 -20.819  -8.612  1.00 61.34           O  
ATOM    886  H   ASP    58      -0.616 -17.340  -6.127  1.00 45.34           H  
ATOM    887  HA  ASP    58       0.247 -17.917  -8.816  1.00 63.12           H  
ATOM    888  HB2 ASP    58      -2.356 -18.399  -7.361  1.00 36.92           H  
ATOM    889  HB3 ASP    58      -2.131 -18.802  -9.060  1.00 36.92           H  
ATOM    890  N   GLU    59      -2.106 -15.675  -8.268  1.00  5.43           N  
ATOM    891  CA  GLU    59      -2.817 -14.540  -8.838  1.00 65.12           C  
ATOM    892  C   GLU    59      -2.734 -13.331  -7.912  1.00 42.44           C  
ATOM    893  O   GLU    59      -3.513 -12.381  -8.038  1.00 62.23           O  
ATOM    894  CB  GLU    59      -4.278 -14.922  -9.073  1.00 24.01           C  
ATOM    895  CG  GLU    59      -4.443 -16.070 -10.051  1.00 21.50           C  
ATOM    896  CD  GLU    59      -5.859 -16.586 -10.113  1.00 22.43           C  
ATOM    897  OE1 GLU    59      -6.689 -15.976 -10.815  1.00 73.42           O  
ATOM    898  OE2 GLU    59      -6.144 -17.611  -9.459  1.00 70.12           O  
ATOM    899  H   GLU    59      -2.307 -15.947  -7.341  1.00 73.32           H  
ATOM    900  HA  GLU    59      -2.358 -14.294  -9.783  1.00 21.01           H  
ATOM    901  HB2 GLU    59      -4.718 -15.214  -8.130  1.00 36.92           H  
ATOM    902  HB3 GLU    59      -4.808 -14.064  -9.460  1.00 36.92           H  
ATOM    903  HG2 GLU    59      -4.156 -15.734 -11.036  1.00 36.92           H  
ATOM    904  HG3 GLU    59      -3.796 -16.879  -9.746  1.00 36.92           H  
ATOM    905  N   GLY    60      -1.785 -13.372  -6.989  1.00 65.33           N  
ATOM    906  CA  GLY    60      -1.613 -12.283  -6.052  1.00 60.33           C  
ATOM    907  C   GLY    60      -2.392 -12.506  -4.771  1.00  3.34           C  
ATOM    908  O   GLY    60      -3.015 -13.554  -4.590  1.00 14.40           O  
ATOM    909  H   GLY    60      -1.195 -14.152  -6.939  1.00 72.33           H  
ATOM    910  HA2 GLY    60      -0.562 -12.188  -5.815  1.00 36.92           H  
ATOM    911  HA3 GLY    60      -1.954 -11.369  -6.514  1.00 36.92           H  
ATOM    912  N   ALA    61      -2.346 -11.526  -3.880  1.00 72.42           N  
ATOM    913  CA  ALA    61      -3.069 -11.591  -2.616  1.00 51.33           C  
ATOM    914  C   ALA    61      -4.578 -11.542  -2.840  1.00 33.41           C  
ATOM    915  O   ALA    61      -5.045 -11.232  -3.938  1.00 22.40           O  
ATOM    916  CB  ALA    61      -2.636 -10.451  -1.708  1.00 75.35           C  
ATOM    917  H   ALA    61      -1.799 -10.733  -4.074  1.00 11.03           H  
ATOM    918  HA  ALA    61      -2.817 -12.522  -2.131  1.00 14.23           H  
ATOM    919  HB1 ALA    61      -3.144 -10.536  -0.758  1.00 36.92           H  
ATOM    920  HB2 ALA    61      -2.892  -9.508  -2.169  1.00 36.92           H  
ATOM    921  HB3 ALA    61      -1.569 -10.498  -1.553  1.00 36.92           H  
ATOM    922  N   SER    62      -5.334 -11.843  -1.793  1.00 73.03           N  
ATOM    923  CA  SER    62      -6.787 -11.813  -1.866  1.00 13.25           C  
ATOM    924  C   SER    62      -7.280 -10.372  -1.920  1.00 31.33           C  
ATOM    925  O   SER    62      -6.742  -9.502  -1.239  1.00 73.22           O  
ATOM    926  CB  SER    62      -7.375 -12.533  -0.656  1.00 54.03           C  
ATOM    927  OG  SER    62      -6.856 -13.851  -0.560  1.00 72.43           O  
ATOM    928  H   SER    62      -4.903 -12.076  -0.942  1.00 71.44           H  
ATOM    929  HA  SER    62      -7.090 -12.325  -2.766  1.00 52.21           H  
ATOM    930  HB2 SER    62      -7.120 -11.994   0.245  1.00 36.92           H  
ATOM    931  HB3 SER    62      -8.448 -12.581  -0.755  1.00 36.92           H  
ATOM    932  HG  SER    62      -6.398 -14.071  -1.381  1.00 64.34           H  
ATOM    933  N   VAL    63      -8.296 -10.121  -2.728  1.00 44.14           N  
ATOM    934  CA  VAL    63      -8.796  -8.773  -2.909  1.00  5.32           C  
ATOM    935  C   VAL    63     -10.323  -8.737  -2.879  1.00 64.30           C  
ATOM    936  O   VAL    63     -10.999  -9.339  -3.715  1.00 54.23           O  
ATOM    937  CB  VAL    63      -8.267  -8.150  -4.225  1.00 12.20           C  
ATOM    938  CG1 VAL    63      -8.564  -9.045  -5.422  1.00 44.21           C  
ATOM    939  CG2 VAL    63      -8.845  -6.758  -4.438  1.00  3.44           C  
ATOM    940  H   VAL    63      -8.730 -10.863  -3.205  1.00 41.21           H  
ATOM    941  HA  VAL    63      -8.424  -8.176  -2.088  1.00 34.10           H  
ATOM    942  HB  VAL    63      -7.194  -8.057  -4.141  1.00 44.33           H  
ATOM    943 HG11 VAL    63      -9.633  -9.167  -5.524  1.00 36.92           H  
ATOM    944 HG12 VAL    63      -8.104 -10.010  -5.273  1.00 36.92           H  
ATOM    945 HG13 VAL    63      -8.166  -8.591  -6.318  1.00 36.92           H  
ATOM    946 HG21 VAL    63      -8.434  -6.330  -5.341  1.00 36.92           H  
ATOM    947 HG22 VAL    63      -8.594  -6.131  -3.595  1.00 36.92           H  
ATOM    948 HG23 VAL    63      -9.919  -6.825  -4.530  1.00 36.92           H  
ATOM    949  N   ALA    64     -10.856  -8.047  -1.887  1.00  0.14           N  
ATOM    950  CA  ALA    64     -12.288  -7.819  -1.788  1.00 21.41           C  
ATOM    951  C   ALA    64     -12.562  -6.327  -1.880  1.00 35.15           C  
ATOM    952  O   ALA    64     -12.278  -5.578  -0.946  1.00 43.34           O  
ATOM    953  CB  ALA    64     -12.834  -8.391  -0.489  1.00 63.04           C  
ATOM    954  H   ALA    64     -10.264  -7.673  -1.193  1.00 52.24           H  
ATOM    955  HA  ALA    64     -12.769  -8.322  -2.616  1.00 14.12           H  
ATOM    956  HB1 ALA    64     -12.364  -7.896   0.348  1.00 36.92           H  
ATOM    957  HB2 ALA    64     -12.625  -9.449  -0.445  1.00 36.92           H  
ATOM    958  HB3 ALA    64     -13.902  -8.233  -0.447  1.00 36.92           H  
ATOM    959  N   TYR    65     -13.097  -5.890  -3.004  1.00 54.34           N  
ATOM    960  CA  TYR    65     -13.224  -4.466  -3.259  1.00 14.20           C  
ATOM    961  C   TYR    65     -14.639  -3.974  -3.005  1.00 50.43           C  
ATOM    962  O   TYR    65     -15.609  -4.709  -3.185  1.00 43.51           O  
ATOM    963  CB  TYR    65     -12.788  -4.132  -4.693  1.00  1.20           C  
ATOM    964  CG  TYR    65     -13.635  -4.762  -5.787  1.00  2.44           C  
ATOM    965  CD1 TYR    65     -14.810  -4.154  -6.216  1.00  0.31           C  
ATOM    966  CD2 TYR    65     -13.252  -5.950  -6.401  1.00 62.40           C  
ATOM    967  CE1 TYR    65     -15.579  -4.712  -7.217  1.00 73.44           C  
ATOM    968  CE2 TYR    65     -14.017  -6.511  -7.408  1.00 12.11           C  
ATOM    969  CZ  TYR    65     -15.179  -5.887  -7.809  1.00  0.44           C  
ATOM    970  OH  TYR    65     -15.944  -6.433  -8.815  1.00 35.31           O  
ATOM    971  H   TYR    65     -13.431  -6.535  -3.668  1.00 31.52           H  
ATOM    972  HA  TYR    65     -12.560  -3.956  -2.575  1.00 43.25           H  
ATOM    973  HB2 TYR    65     -12.825  -3.062  -4.826  1.00 36.92           H  
ATOM    974  HB3 TYR    65     -11.770  -4.467  -4.830  1.00 36.92           H  
ATOM    975  HD1 TYR    65     -15.122  -3.233  -5.751  1.00 71.15           H  
ATOM    976  HD2 TYR    65     -12.342  -6.438  -6.083  1.00 51.12           H  
ATOM    977  HE1 TYR    65     -16.490  -4.225  -7.533  1.00 12.11           H  
ATOM    978  HE2 TYR    65     -13.706  -7.435  -7.874  1.00 43.35           H  
ATOM    979  HH  TYR    65     -16.005  -7.390  -8.696  1.00 23.11           H  
ATOM    980  N   LYS    66     -14.740  -2.736  -2.558  1.00 23.34           N  
ATOM    981  CA  LYS    66     -16.020  -2.076  -2.406  1.00 52.14           C  
ATOM    982  C   LYS    66     -16.198  -1.043  -3.489  1.00 45.51           C  
ATOM    983  O   LYS    66     -15.264  -0.320  -3.838  1.00 42.11           O  
ATOM    984  CB  LYS    66     -16.127  -1.366  -1.064  1.00 20.13           C  
ATOM    985  CG  LYS    66     -16.056  -2.280   0.131  1.00 13.54           C  
ATOM    986  CD  LYS    66     -15.737  -1.473   1.373  1.00 52.40           C  
ATOM    987  CE  LYS    66     -15.406  -2.345   2.568  1.00 75.44           C  
ATOM    988  NZ  LYS    66     -14.811  -1.538   3.664  1.00  1.23           N  
ATOM    989  H   LYS    66     -13.923  -2.248  -2.307  1.00 52.21           H  
ATOM    990  HA  LYS    66     -16.799  -2.817  -2.485  1.00 74.25           H  
ATOM    991  HB2 LYS    66     -15.321  -0.652  -0.985  1.00 36.92           H  
ATOM    992  HB3 LYS    66     -17.067  -0.836  -1.025  1.00 36.92           H  
ATOM    993  HG2 LYS    66     -17.011  -2.769   0.259  1.00 36.92           H  
ATOM    994  HG3 LYS    66     -15.287  -3.011  -0.035  1.00 36.92           H  
ATOM    995  HD2 LYS    66     -14.890  -0.837   1.165  1.00 36.92           H  
ATOM    996  HD3 LYS    66     -16.593  -0.859   1.616  1.00 36.92           H  
ATOM    997  HE2 LYS    66     -16.313  -2.811   2.923  1.00 36.92           H  
ATOM    998  HE3 LYS    66     -14.701  -3.103   2.264  1.00 36.92           H  
ATOM    999  HZ1 LYS    66     -15.471  -0.782   3.954  1.00 36.92           H  
ATOM   1000  HZ2 LYS    66     -13.921  -1.095   3.334  1.00 36.92           H  
ATOM   1001  HZ3 LYS    66     -14.602  -2.135   4.488  1.00 36.92           H  
ATOM   1002  N   ILE    67     -17.398  -0.991  -4.009  1.00 45.32           N  
ATOM   1003  CA  ILE    67     -17.793   0.051  -4.939  1.00 72.14           C  
ATOM   1004  C   ILE    67     -19.163   0.573  -4.544  1.00 63.23           C  
ATOM   1005  O   ILE    67     -20.180  -0.090  -4.764  1.00 32.20           O  
ATOM   1006  CB  ILE    67     -17.842  -0.437  -6.404  1.00 21.51           C  
ATOM   1007  CG1 ILE    67     -16.476  -0.963  -6.847  1.00 22.50           C  
ATOM   1008  CG2 ILE    67     -18.293   0.700  -7.315  1.00 22.44           C  
ATOM   1009  CD1 ILE    67     -16.452  -1.466  -8.275  1.00  1.44           C  
ATOM   1010  H   ILE    67     -18.049  -1.670  -3.740  1.00  2.22           H  
ATOM   1011  HA  ILE    67     -17.073   0.855  -4.866  1.00 75.03           H  
ATOM   1012  HB  ILE    67     -18.568  -1.233  -6.474  1.00 11.44           H  
ATOM   1013 HG12 ILE    67     -15.750  -0.169  -6.763  1.00 36.92           H  
ATOM   1014 HG13 ILE    67     -16.185  -1.779  -6.201  1.00 36.92           H  
ATOM   1015 HG21 ILE    67     -19.276   1.032  -7.018  1.00 36.92           H  
ATOM   1016 HG22 ILE    67     -18.323   0.353  -8.338  1.00 36.92           H  
ATOM   1017 HG23 ILE    67     -17.596   1.520  -7.235  1.00 36.92           H  
ATOM   1018 HD11 ILE    67     -17.154  -2.280  -8.381  1.00 36.92           H  
ATOM   1019 HD12 ILE    67     -15.459  -1.812  -8.518  1.00 36.92           H  
ATOM   1020 HD13 ILE    67     -16.726  -0.663  -8.943  1.00 36.92           H  
ATOM   1021  N   LYS    68     -19.186   1.740  -3.934  1.00 34.32           N  
ATOM   1022  CA  LYS    68     -20.437   2.340  -3.514  1.00 25.45           C  
ATOM   1023  C   LYS    68     -20.806   3.478  -4.442  1.00 45.23           C  
ATOM   1024  O   LYS    68     -20.070   4.459  -4.571  1.00 71.53           O  
ATOM   1025  CB  LYS    68     -20.345   2.827  -2.072  1.00 71.40           C  
ATOM   1026  CG  LYS    68     -21.651   3.377  -1.517  1.00 52.33           C  
ATOM   1027  CD  LYS    68     -21.542   3.652  -0.026  1.00 33.42           C  
ATOM   1028  CE  LYS    68     -22.825   4.245   0.538  1.00 50.52           C  
ATOM   1029  NZ  LYS    68     -23.997   3.355   0.327  1.00 72.10           N  
ATOM   1030  H   LYS    68     -18.341   2.211  -3.764  1.00 40.12           H  
ATOM   1031  HA  LYS    68     -21.205   1.582  -3.579  1.00 54.24           H  
ATOM   1032  HB2 LYS    68     -20.038   2.003  -1.451  1.00 36.92           H  
ATOM   1033  HB3 LYS    68     -19.602   3.607  -2.018  1.00 36.92           H  
ATOM   1034  HG2 LYS    68     -21.887   4.300  -2.025  1.00 36.92           H  
ATOM   1035  HG3 LYS    68     -22.438   2.657  -1.685  1.00 36.92           H  
ATOM   1036  HD2 LYS    68     -21.333   2.724   0.486  1.00 36.92           H  
ATOM   1037  HD3 LYS    68     -20.731   4.346   0.141  1.00 36.92           H  
ATOM   1038  HE2 LYS    68     -22.696   4.409   1.598  1.00 36.92           H  
ATOM   1039  HE3 LYS    68     -23.010   5.193   0.051  1.00 36.92           H  
ATOM   1040  HZ1 LYS    68     -23.818   2.416   0.742  1.00 36.92           H  
ATOM   1041  HZ2 LYS    68     -24.187   3.246  -0.691  1.00 36.92           H  
ATOM   1042  HZ3 LYS    68     -24.843   3.766   0.780  1.00 36.92           H  
ATOM   1043  N   ASP    69     -21.948   3.326  -5.082  1.00 60.11           N  
ATOM   1044  CA  ASP    69     -22.432   4.284  -6.053  1.00 21.41           C  
ATOM   1045  C   ASP    69     -23.101   5.447  -5.324  1.00 34.11           C  
ATOM   1046  O   ASP    69     -24.267   5.355  -4.939  1.00 44.23           O  
ATOM   1047  CB  ASP    69     -23.443   3.619  -6.996  1.00 24.45           C  
ATOM   1048  CG  ASP    69     -23.033   2.222  -7.437  1.00 63.23           C  
ATOM   1049  OD1 ASP    69     -22.338   2.087  -8.468  1.00 23.43           O  
ATOM   1050  OD2 ASP    69     -23.432   1.246  -6.762  1.00 74.32           O  
ATOM   1051  H   ASP    69     -22.499   2.539  -4.881  1.00 51.42           H  
ATOM   1052  HA  ASP    69     -21.589   4.649  -6.628  1.00 41.14           H  
ATOM   1053  HB2 ASP    69     -24.397   3.548  -6.495  1.00 36.92           H  
ATOM   1054  HB3 ASP    69     -23.553   4.231  -7.872  1.00 36.92           H  
ATOM   1055  N   LEU    70     -22.358   6.520  -5.106  1.00 53.24           N  
ATOM   1056  CA  LEU    70     -22.879   7.671  -4.381  1.00 44.32           C  
ATOM   1057  C   LEU    70     -23.393   8.734  -5.341  1.00 73.41           C  
ATOM   1058  O   LEU    70     -23.405   8.542  -6.559  1.00 72.32           O  
ATOM   1059  CB  LEU    70     -21.796   8.270  -3.478  1.00 24.22           C  
ATOM   1060  CG  LEU    70     -21.334   7.376  -2.330  1.00 55.12           C  
ATOM   1061  CD1 LEU    70     -20.155   8.007  -1.604  1.00 61.32           C  
ATOM   1062  CD2 LEU    70     -22.483   7.129  -1.367  1.00 75.23           C  
ATOM   1063  H   LEU    70     -21.438   6.548  -5.446  1.00 74.20           H  
ATOM   1064  HA  LEU    70     -23.700   7.332  -3.766  1.00 60.34           H  
ATOM   1065  HB2 LEU    70     -20.938   8.504  -4.092  1.00 36.92           H  
ATOM   1066  HB3 LEU    70     -22.177   9.189  -3.058  1.00 36.92           H  
ATOM   1067  HG  LEU    70     -21.015   6.424  -2.727  1.00 20.33           H  
ATOM   1068 HD11 LEU    70     -19.847   7.366  -0.790  1.00 36.92           H  
ATOM   1069 HD12 LEU    70     -20.445   8.971  -1.213  1.00 36.92           H  
ATOM   1070 HD13 LEU    70     -19.334   8.131  -2.294  1.00 36.92           H  
ATOM   1071 HD21 LEU    70     -22.155   6.473  -0.576  1.00 36.92           H  
ATOM   1072 HD22 LEU    70     -23.305   6.671  -1.898  1.00 36.92           H  
ATOM   1073 HD23 LEU    70     -22.807   8.069  -0.945  1.00 36.92           H  
ATOM   1074  N   GLU    71     -23.814   9.857  -4.785  1.00 23.43           N  
ATOM   1075  CA  GLU    71     -24.349  10.951  -5.573  1.00  1.01           C  
ATOM   1076  C   GLU    71     -23.249  11.955  -5.905  1.00 60.04           C  
ATOM   1077  O   GLU    71     -22.900  12.807  -5.086  1.00  1.51           O  
ATOM   1078  CB  GLU    71     -25.472  11.637  -4.801  1.00 70.31           C  
ATOM   1079  CG  GLU    71     -26.265  12.635  -5.619  1.00 62.41           C  
ATOM   1080  CD  GLU    71     -27.254  13.402  -4.774  1.00 30.54           C  
ATOM   1081  OE1 GLU    71     -28.047  12.768  -4.047  1.00 32.54           O  
ATOM   1082  OE2 GLU    71     -27.228  14.651  -4.815  1.00 74.10           O  
ATOM   1083  H   GLU    71     -23.765   9.954  -3.807  1.00 15.23           H  
ATOM   1084  HA  GLU    71     -24.744  10.545  -6.491  1.00 14.31           H  
ATOM   1085  HB2 GLU    71     -26.154  10.884  -4.436  1.00 36.92           H  
ATOM   1086  HB3 GLU    71     -25.043  12.158  -3.957  1.00 36.92           H  
ATOM   1087  HG2 GLU    71     -25.580  13.336  -6.072  1.00 36.92           H  
ATOM   1088  HG3 GLU    71     -26.805  12.107  -6.393  1.00 36.92           H  
ATOM   1089  N   GLY    72     -22.685  11.829  -7.094  1.00 12.40           N  
ATOM   1090  CA  GLY    72     -21.642  12.744  -7.518  1.00 54.51           C  
ATOM   1091  C   GLY    72     -20.257  12.149  -7.384  1.00 60.22           C  
ATOM   1092  O   GLY    72     -19.296  12.660  -7.960  1.00 71.13           O  
ATOM   1093  H   GLY    72     -22.982  11.111  -7.693  1.00 72.14           H  
ATOM   1094  HA2 GLY    72     -21.811  13.008  -8.553  1.00 36.92           H  
ATOM   1095  HA3 GLY    72     -21.696  13.638  -6.916  1.00 36.92           H  
ATOM   1096  N   GLN    73     -20.152  11.070  -6.626  1.00 12.51           N  
ATOM   1097  CA  GLN    73     -18.878  10.398  -6.423  1.00 65.04           C  
ATOM   1098  C   GLN    73     -19.103   8.924  -6.129  1.00 53.02           C  
ATOM   1099  O   GLN    73     -20.239   8.469  -6.037  1.00  4.34           O  
ATOM   1100  CB  GLN    73     -18.098  11.043  -5.271  1.00 73.13           C  
ATOM   1101  CG  GLN    73     -18.834  11.021  -3.939  1.00 20.53           C  
ATOM   1102  CD  GLN    73     -17.944  11.413  -2.774  1.00 32.52           C  
ATOM   1103  OE1 GLN    73     -17.817  12.589  -2.437  1.00 12.33           O  
ATOM   1104  NE2 GLN    73     -17.331  10.424  -2.142  1.00 64.02           N  
ATOM   1105  H   GLN    73     -20.955  10.705  -6.197  1.00  2.45           H  
ATOM   1106  HA  GLN    73     -18.304  10.489  -7.334  1.00 14.12           H  
ATOM   1107  HB2 GLN    73     -17.164  10.517  -5.148  1.00 36.92           H  
ATOM   1108  HB3 GLN    73     -17.890  12.072  -5.526  1.00 36.92           H  
ATOM   1109  HG2 GLN    73     -19.662  11.712  -3.987  1.00 36.92           H  
ATOM   1110  HG3 GLN    73     -19.208  10.023  -3.766  1.00 36.92           H  
ATOM   1111 HE21 GLN    73     -17.484   9.510  -2.455  1.00 36.92           H  
ATOM   1112 HE22 GLN    73     -16.755  10.646  -1.380  1.00 36.92           H  
ATOM   1113  N   VAL    74     -18.016   8.182  -6.000  1.00 44.24           N  
ATOM   1114  CA  VAL    74     -18.083   6.779  -5.618  1.00 51.30           C  
ATOM   1115  C   VAL    74     -16.989   6.451  -4.614  1.00 24.33           C  
ATOM   1116  O   VAL    74     -15.954   7.121  -4.569  1.00  0.32           O  
ATOM   1117  CB  VAL    74     -17.938   5.837  -6.832  1.00 13.50           C  
ATOM   1118  CG1 VAL    74     -19.130   5.966  -7.767  1.00 50.33           C  
ATOM   1119  CG2 VAL    74     -16.641   6.115  -7.573  1.00 32.50           C  
ATOM   1120  H   VAL    74     -17.138   8.591  -6.170  1.00 31.51           H  
ATOM   1121  HA  VAL    74     -19.046   6.601  -5.161  1.00 15.53           H  
ATOM   1122  HB  VAL    74     -17.903   4.822  -6.468  1.00  4.20           H  
ATOM   1123 HG11 VAL    74     -19.014   5.283  -8.595  1.00 36.92           H  
ATOM   1124 HG12 VAL    74     -19.188   6.978  -8.139  1.00 36.92           H  
ATOM   1125 HG13 VAL    74     -20.035   5.728  -7.228  1.00 36.92           H  
ATOM   1126 HG21 VAL    74     -16.557   5.445  -8.416  1.00 36.92           H  
ATOM   1127 HG22 VAL    74     -15.806   5.962  -6.906  1.00 36.92           H  
ATOM   1128 HG23 VAL    74     -16.639   7.137  -7.924  1.00 36.92           H  
ATOM   1129  N   GLU    75     -17.224   5.429  -3.807  1.00 25.23           N  
ATOM   1130  CA  GLU    75     -16.222   4.954  -2.868  1.00 61.11           C  
ATOM   1131  C   GLU    75     -15.567   3.690  -3.386  1.00 54.30           C  
ATOM   1132  O   GLU    75     -16.224   2.657  -3.540  1.00 60.22           O  
ATOM   1133  CB  GLU    75     -16.831   4.678  -1.495  1.00 44.30           C  
ATOM   1134  CG  GLU    75     -17.083   5.925  -0.679  1.00  2.41           C  
ATOM   1135  CD  GLU    75     -17.741   5.628   0.651  1.00 51.44           C  
ATOM   1136  OE1 GLU    75     -18.290   4.516   0.815  1.00 33.35           O  
ATOM   1137  OE2 GLU    75     -17.693   6.496   1.546  1.00 15.14           O  
ATOM   1138  H   GLU    75     -18.095   4.978  -3.847  1.00 52.23           H  
ATOM   1139  HA  GLU    75     -15.467   5.724  -2.770  1.00 22.00           H  
ATOM   1140  HB2 GLU    75     -17.774   4.168  -1.627  1.00 36.92           H  
ATOM   1141  HB3 GLU    75     -16.162   4.040  -0.938  1.00 36.92           H  
ATOM   1142  HG2 GLU    75     -16.137   6.411  -0.491  1.00 36.92           H  
ATOM   1143  HG3 GLU    75     -17.715   6.584  -1.244  1.00 36.92           H  
ATOM   1144  N   LEU    76     -14.285   3.786  -3.670  1.00 12.03           N  
ATOM   1145  CA  LEU    76     -13.500   2.625  -4.045  1.00 73.45           C  
ATOM   1146  C   LEU    76     -12.639   2.229  -2.859  1.00 13.34           C  
ATOM   1147  O   LEU    76     -11.725   2.958  -2.479  1.00 71.02           O  
ATOM   1148  CB  LEU    76     -12.638   2.929  -5.283  1.00 30.32           C  
ATOM   1149  CG  LEU    76     -11.966   1.718  -5.963  1.00 24.24           C  
ATOM   1150  CD1 LEU    76     -10.748   1.240  -5.183  1.00 52.21           C  
ATOM   1151  CD2 LEU    76     -12.963   0.581  -6.137  1.00 40.14           C  
ATOM   1152  H   LEU    76     -13.849   4.665  -3.617  1.00  2.51           H  
ATOM   1153  HA  LEU    76     -14.180   1.817  -4.271  1.00 12.21           H  
ATOM   1154  HB2 LEU    76     -13.265   3.416  -6.015  1.00 36.92           H  
ATOM   1155  HB3 LEU    76     -11.862   3.620  -4.989  1.00 36.92           H  
ATOM   1156  HG  LEU    76     -11.631   2.013  -6.943  1.00  3.32           H  
ATOM   1157 HD11 LEU    76     -10.305   0.395  -5.689  1.00 36.92           H  
ATOM   1158 HD12 LEU    76     -11.049   0.949  -4.189  1.00 36.92           H  
ATOM   1159 HD13 LEU    76     -10.024   2.040  -5.120  1.00 36.92           H  
ATOM   1160 HD21 LEU    76     -13.782   0.909  -6.759  1.00 36.92           H  
ATOM   1161 HD22 LEU    76     -13.343   0.282  -5.170  1.00 36.92           H  
ATOM   1162 HD23 LEU    76     -12.471  -0.259  -6.604  1.00 36.92           H  
ATOM   1163  N   ASP    77     -12.956   1.092  -2.270  1.00 44.04           N  
ATOM   1164  CA  ASP    77     -12.244   0.619  -1.085  1.00 71.33           C  
ATOM   1165  C   ASP    77     -11.896  -0.850  -1.246  1.00 21.25           C  
ATOM   1166  O   ASP    77     -12.757  -1.719  -1.129  1.00  5.21           O  
ATOM   1167  CB  ASP    77     -13.078   0.839   0.186  1.00 30.32           C  
ATOM   1168  CG  ASP    77     -12.360   0.396   1.454  1.00 43.10           C  
ATOM   1169  OD1 ASP    77     -11.302   0.975   1.778  1.00 52.23           O  
ATOM   1170  OD2 ASP    77     -12.863  -0.523   2.140  1.00 61.53           O  
ATOM   1171  H   ASP    77     -13.676   0.543  -2.655  1.00 11.34           H  
ATOM   1172  HA  ASP    77     -11.327   1.184  -1.006  1.00 53.23           H  
ATOM   1173  HB2 ASP    77     -13.308   1.891   0.279  1.00 36.92           H  
ATOM   1174  HB3 ASP    77     -14.001   0.283   0.105  1.00 36.92           H  
ATOM   1175  N   ALA    78     -10.642  -1.121  -1.553  1.00 23.23           N  
ATOM   1176  CA  ALA    78     -10.206  -2.479  -1.820  1.00 62.42           C  
ATOM   1177  C   ALA    78      -9.454  -3.060  -0.634  1.00 62.32           C  
ATOM   1178  O   ALA    78      -8.474  -2.483  -0.161  1.00  3.13           O  
ATOM   1179  CB  ALA    78      -9.338  -2.511  -3.067  1.00 32.42           C  
ATOM   1180  H   ALA    78      -9.988  -0.385  -1.591  1.00 35.04           H  
ATOM   1181  HA  ALA    78     -11.084  -3.079  -2.006  1.00 25.14           H  
ATOM   1182  HB1 ALA    78      -9.042  -3.529  -3.273  1.00 36.92           H  
ATOM   1183  HB2 ALA    78      -8.459  -1.906  -2.907  1.00 36.92           H  
ATOM   1184  HB3 ALA    78      -9.897  -2.122  -3.905  1.00 36.92           H  
ATOM   1185  N   ALA    79      -9.925  -4.201  -0.156  1.00 14.34           N  
ATOM   1186  CA  ALA    79      -9.272  -4.897   0.935  1.00 74.43           C  
ATOM   1187  C   ALA    79      -8.351  -5.982   0.396  1.00 62.11           C  
ATOM   1188  O   ALA    79      -8.807  -6.953  -0.212  1.00 60.22           O  
ATOM   1189  CB  ALA    79     -10.306  -5.489   1.880  1.00 15.01           C  
ATOM   1190  H   ALA    79     -10.743  -4.584  -0.546  1.00 24.21           H  
ATOM   1191  HA  ALA    79      -8.683  -4.177   1.484  1.00 62.25           H  
ATOM   1192  HB1 ALA    79     -10.983  -4.712   2.204  1.00 36.92           H  
ATOM   1193  HB2 ALA    79      -9.808  -5.914   2.739  1.00 36.92           H  
ATOM   1194  HB3 ALA    79     -10.861  -6.260   1.366  1.00 36.92           H  
ATOM   1195  N   PHE    80      -7.057  -5.796   0.603  1.00 44.11           N  
ATOM   1196  CA  PHE    80      -6.057  -6.747   0.142  1.00 65.22           C  
ATOM   1197  C   PHE    80      -5.550  -7.596   1.296  1.00 14.33           C  
ATOM   1198  O   PHE    80      -4.884  -7.094   2.201  1.00 43.53           O  
ATOM   1199  CB  PHE    80      -4.882  -6.015  -0.511  1.00 62.23           C  
ATOM   1200  CG  PHE    80      -5.197  -5.424  -1.857  1.00 12.12           C  
ATOM   1201  CD1 PHE    80      -5.026  -6.170  -3.012  1.00 64.12           C  
ATOM   1202  CD2 PHE    80      -5.660  -4.122  -1.965  1.00  1.25           C  
ATOM   1203  CE1 PHE    80      -5.311  -5.628  -4.251  1.00 23.20           C  
ATOM   1204  CE2 PHE    80      -5.946  -3.576  -3.201  1.00  1.44           C  
ATOM   1205  CZ  PHE    80      -5.771  -4.330  -4.345  1.00  4.21           C  
ATOM   1206  H   PHE    80      -6.763  -4.991   1.089  1.00 31.51           H  
ATOM   1207  HA  PHE    80      -6.522  -7.392  -0.587  1.00 30.54           H  
ATOM   1208  HB2 PHE    80      -4.570  -5.208   0.137  1.00 36.92           H  
ATOM   1209  HB3 PHE    80      -4.060  -6.704  -0.630  1.00 36.92           H  
ATOM   1210  HD1 PHE    80      -4.665  -7.186  -2.938  1.00 24.45           H  
ATOM   1211  HD2 PHE    80      -5.796  -3.530  -1.071  1.00 14.34           H  
ATOM   1212  HE1 PHE    80      -5.173  -6.219  -5.144  1.00 34.43           H  
ATOM   1213  HE2 PHE    80      -6.304  -2.561  -3.272  1.00 24.03           H  
ATOM   1214  HZ  PHE    80      -5.994  -3.904  -5.312  1.00 75.03           H  
ATOM   1215  N   THR    81      -5.864  -8.881   1.257  1.00 11.34           N  
ATOM   1216  CA  THR    81      -5.431  -9.800   2.291  1.00 63.13           C  
ATOM   1217  C   THR    81      -4.085 -10.406   1.929  1.00 62.21           C  
ATOM   1218  O   THR    81      -3.996 -11.274   1.055  1.00  1.30           O  
ATOM   1219  CB  THR    81      -6.464 -10.927   2.510  1.00 55.42           C  
ATOM   1220  OG1 THR    81      -7.730 -10.360   2.875  1.00 23.22           O  
ATOM   1221  CG2 THR    81      -6.002 -11.887   3.599  1.00 51.14           C  
ATOM   1222  H   THR    81      -6.388  -9.224   0.497  1.00 23.55           H  
ATOM   1223  HA  THR    81      -5.332  -9.244   3.212  1.00 12.00           H  
ATOM   1224  HB  THR    81      -6.579 -11.477   1.588  1.00 64.32           H  
ATOM   1225  HG1 THR    81      -7.582  -9.605   3.458  1.00 42.21           H  
ATOM   1226 HG21 THR    81      -5.911 -11.354   4.534  1.00 36.92           H  
ATOM   1227 HG22 THR    81      -5.043 -12.302   3.327  1.00 36.92           H  
ATOM   1228 HG23 THR    81      -6.722 -12.686   3.706  1.00 36.92           H  
ATOM   1229  N   PHE    82      -3.041  -9.929   2.585  1.00 30.33           N  
ATOM   1230  CA  PHE    82      -1.705 -10.441   2.361  1.00 25.52           C  
ATOM   1231  C   PHE    82      -1.409 -11.577   3.328  1.00 12.33           C  
ATOM   1232  O   PHE    82      -2.144 -11.791   4.296  1.00 63.14           O  
ATOM   1233  CB  PHE    82      -0.672  -9.324   2.523  1.00 61.22           C  
ATOM   1234  CG  PHE    82      -0.754  -8.263   1.458  1.00 34.50           C  
ATOM   1235  CD1 PHE    82      -0.074  -8.414   0.261  1.00  4.42           C  
ATOM   1236  CD2 PHE    82      -1.509  -7.119   1.654  1.00  5.35           C  
ATOM   1237  CE1 PHE    82      -0.145  -7.445  -0.720  1.00  1.34           C  
ATOM   1238  CE2 PHE    82      -1.584  -6.144   0.676  1.00 14.24           C  
ATOM   1239  CZ  PHE    82      -0.901  -6.309  -0.512  1.00 62.53           C  
ATOM   1240  H   PHE    82      -3.173  -9.213   3.242  1.00 62.12           H  
ATOM   1241  HA  PHE    82      -1.660 -10.821   1.350  1.00 14.25           H  
ATOM   1242  HB2 PHE    82      -0.819  -8.846   3.479  1.00 36.92           H  
ATOM   1243  HB3 PHE    82       0.320  -9.754   2.491  1.00 36.92           H  
ATOM   1244  HD1 PHE    82       0.517  -9.302   0.095  1.00  5.41           H  
ATOM   1245  HD2 PHE    82      -2.044  -6.991   2.584  1.00 23.51           H  
ATOM   1246  HE1 PHE    82       0.391  -7.574  -1.648  1.00 60.10           H  
ATOM   1247  HE2 PHE    82      -2.177  -5.255   0.840  1.00 64.21           H  
ATOM   1248  HZ  PHE    82      -0.959  -5.549  -1.279  1.00  4.14           H  
ATOM   1249  N   SER    83      -0.337 -12.299   3.069  1.00 75.03           N  
ATOM   1250  CA  SER    83       0.052 -13.409   3.916  1.00 22.32           C  
ATOM   1251  C   SER    83       1.024 -12.920   4.983  1.00 34.44           C  
ATOM   1252  O   SER    83       1.085 -13.455   6.088  1.00 72.02           O  
ATOM   1253  CB  SER    83       0.691 -14.510   3.071  1.00 42.15           C  
ATOM   1254  OG  SER    83      -0.133 -14.842   1.963  1.00 71.23           O  
ATOM   1255  H   SER    83       0.229 -12.062   2.292  1.00 64.54           H  
ATOM   1256  HA  SER    83      -0.834 -13.794   4.396  1.00 51.32           H  
ATOM   1257  HB2 SER    83       1.648 -14.171   2.703  1.00 36.92           H  
ATOM   1258  HB3 SER    83       0.830 -15.392   3.677  1.00 36.92           H  
ATOM   1259  HG  SER    83      -0.148 -14.102   1.347  1.00 63.13           H  
ATOM   1260  N   CYS    84       1.768 -11.880   4.646  1.00 14.33           N  
ATOM   1261  CA  CYS    84       2.748 -11.314   5.552  1.00  3.35           C  
ATOM   1262  C   CYS    84       2.442  -9.840   5.777  1.00 24.12           C  
ATOM   1263  O   CYS    84       1.700  -9.231   5.006  1.00 12.23           O  
ATOM   1264  CB  CYS    84       4.150 -11.465   4.959  1.00 32.54           C  
ATOM   1265  SG  CYS    84       4.440 -13.051   4.143  1.00 64.32           S  
ATOM   1266  H   CYS    84       1.647 -11.474   3.759  1.00 21.02           H  
ATOM   1267  HA  CYS    84       2.692 -11.842   6.493  1.00 43.40           H  
ATOM   1268  HB2 CYS    84       4.306 -10.687   4.228  1.00 36.92           H  
ATOM   1269  HB3 CYS    84       4.878 -11.362   5.750  1.00 36.92           H  
ATOM   1270  HG  CYS    84       4.291 -12.861   2.833  1.00  5.21           H  
ATOM   1271  N   GLN    85       3.009  -9.260   6.820  1.00 12.02           N  
ATOM   1272  CA  GLN    85       2.841  -7.837   7.060  1.00 45.42           C  
ATOM   1273  C   GLN    85       3.818  -7.049   6.206  1.00 45.23           C  
ATOM   1274  O   GLN    85       3.514  -5.945   5.759  1.00 72.34           O  
ATOM   1275  CB  GLN    85       3.032  -7.499   8.537  1.00 24.10           C  
ATOM   1276  CG  GLN    85       2.939  -6.011   8.832  1.00  4.41           C  
ATOM   1277  CD  GLN    85       2.667  -5.733  10.293  1.00 20.40           C  
ATOM   1278  OE1 GLN    85       3.589  -5.561  11.091  1.00  4.15           O  
ATOM   1279  NE2 GLN    85       1.395  -5.704  10.653  1.00  4.11           N  
ATOM   1280  H   GLN    85       3.551  -9.800   7.444  1.00 33.03           H  
ATOM   1281  HA  GLN    85       1.835  -7.572   6.768  1.00 11.14           H  
ATOM   1282  HB2 GLN    85       2.272  -8.005   9.112  1.00 36.92           H  
ATOM   1283  HB3 GLN    85       4.005  -7.848   8.852  1.00 36.92           H  
ATOM   1284  HG2 GLN    85       3.874  -5.544   8.559  1.00 36.92           H  
ATOM   1285  HG3 GLN    85       2.143  -5.586   8.240  1.00 36.92           H  
ATOM   1286 HE21 GLN    85       0.712  -5.861   9.963  1.00 36.92           H  
ATOM   1287 HE22 GLN    85       1.182  -5.534  11.599  1.00 36.92           H  
ATOM   1288  N   ALA    86       4.986  -7.639   5.971  1.00 43.40           N  
ATOM   1289  CA  ALA    86       6.013  -7.022   5.140  1.00  1.11           C  
ATOM   1290  C   ALA    86       5.460  -6.660   3.767  1.00 11.02           C  
ATOM   1291  O   ALA    86       5.602  -5.530   3.312  1.00 13.21           O  
ATOM   1292  CB  ALA    86       7.207  -7.954   5.003  1.00 60.14           C  
ATOM   1293  H   ALA    86       5.170  -8.508   6.384  1.00 20.34           H  
ATOM   1294  HA  ALA    86       6.343  -6.120   5.635  1.00 44.00           H  
ATOM   1295  HB1 ALA    86       6.904  -8.855   4.491  1.00 36.92           H  
ATOM   1296  HB2 ALA    86       7.582  -8.205   5.984  1.00 36.92           H  
ATOM   1297  HB3 ALA    86       7.982  -7.461   4.437  1.00 36.92           H  
ATOM   1298  N   GLU    87       4.804  -7.620   3.128  1.00 34.24           N  
ATOM   1299  CA  GLU    87       4.230  -7.407   1.802  1.00 53.14           C  
ATOM   1300  C   GLU    87       3.065  -6.412   1.851  1.00  2.12           C  
ATOM   1301  O   GLU    87       2.774  -5.740   0.863  1.00  2.04           O  
ATOM   1302  CB  GLU    87       3.792  -8.742   1.188  1.00 73.41           C  
ATOM   1303  CG  GLU    87       3.017  -9.630   2.144  1.00 12.24           C  
ATOM   1304  CD  GLU    87       2.751 -11.017   1.585  1.00 31.21           C  
ATOM   1305  OE1 GLU    87       3.725 -11.734   1.274  1.00 33.21           O  
ATOM   1306  OE2 GLU    87       1.570 -11.395   1.471  1.00 44.22           O  
ATOM   1307  H   GLU    87       4.705  -8.495   3.554  1.00 34.13           H  
ATOM   1308  HA  GLU    87       5.008  -6.984   1.182  1.00 52.24           H  
ATOM   1309  HB2 GLU    87       3.165  -8.540   0.332  1.00 36.92           H  
ATOM   1310  HB3 GLU    87       4.670  -9.279   0.861  1.00 36.92           H  
ATOM   1311  HG2 GLU    87       3.582  -9.732   3.058  1.00 36.92           H  
ATOM   1312  HG3 GLU    87       2.069  -9.159   2.359  1.00 36.92           H  
ATOM   1313  N   MET    88       2.413  -6.310   3.006  1.00 52.33           N  
ATOM   1314  CA  MET    88       1.300  -5.382   3.176  1.00 24.23           C  
ATOM   1315  C   MET    88       1.807  -3.942   3.255  1.00 14.41           C  
ATOM   1316  O   MET    88       1.372  -3.077   2.493  1.00  0.21           O  
ATOM   1317  CB  MET    88       0.490  -5.743   4.433  1.00 34.40           C  
ATOM   1318  CG  MET    88      -0.783  -4.924   4.616  1.00 60.15           C  
ATOM   1319  SD  MET    88      -0.493  -3.301   5.350  1.00  0.12           S  
ATOM   1320  CE  MET    88       0.031  -3.759   7.002  1.00 21.04           C  
ATOM   1321  H   MET    88       2.688  -6.870   3.759  1.00 35.21           H  
ATOM   1322  HA  MET    88       0.660  -5.473   2.309  1.00 72.13           H  
ATOM   1323  HB2 MET    88       0.211  -6.785   4.378  1.00 36.92           H  
ATOM   1324  HB3 MET    88       1.114  -5.594   5.303  1.00 36.92           H  
ATOM   1325  HG2 MET    88      -1.245  -4.783   3.649  1.00 36.92           H  
ATOM   1326  HG3 MET    88      -1.457  -5.476   5.254  1.00 36.92           H  
ATOM   1327  HE1 MET    88       0.905  -4.392   6.940  1.00 36.92           H  
ATOM   1328  HE2 MET    88      -0.767  -4.293   7.497  1.00 36.92           H  
ATOM   1329  HE3 MET    88       0.270  -2.868   7.564  1.00 36.92           H  
ATOM   1330  N   ILE    89       2.745  -3.695   4.163  1.00 35.42           N  
ATOM   1331  CA  ILE    89       3.269  -2.353   4.375  1.00 43.20           C  
ATOM   1332  C   ILE    89       3.995  -1.816   3.142  1.00 61.45           C  
ATOM   1333  O   ILE    89       3.833  -0.649   2.794  1.00 55.34           O  
ATOM   1334  CB  ILE    89       4.210  -2.290   5.596  1.00 34.31           C  
ATOM   1335  CG1 ILE    89       5.259  -3.401   5.532  1.00 51.41           C  
ATOM   1336  CG2 ILE    89       3.407  -2.386   6.884  1.00 41.33           C  
ATOM   1337  CD1 ILE    89       6.361  -3.268   6.558  1.00  5.14           C  
ATOM   1338  H   ILE    89       3.084  -4.429   4.713  1.00 34.24           H  
ATOM   1339  HA  ILE    89       2.425  -1.709   4.579  1.00  1.23           H  
ATOM   1340  HB  ILE    89       4.707  -1.335   5.584  1.00 43.22           H  
ATOM   1341 HG12 ILE    89       4.773  -4.350   5.696  1.00 36.92           H  
ATOM   1342 HG13 ILE    89       5.712  -3.401   4.555  1.00 36.92           H  
ATOM   1343 HG21 ILE    89       4.077  -2.342   7.730  1.00 36.92           H  
ATOM   1344 HG22 ILE    89       2.866  -3.320   6.900  1.00 36.92           H  
ATOM   1345 HG23 ILE    89       2.709  -1.564   6.934  1.00 36.92           H  
ATOM   1346 HD11 ILE    89       6.888  -2.337   6.402  1.00 36.92           H  
ATOM   1347 HD12 ILE    89       7.050  -4.093   6.455  1.00 36.92           H  
ATOM   1348 HD13 ILE    89       5.933  -3.276   7.549  1.00 36.92           H  
ATOM   1349  N   ILE    90       4.778  -2.659   2.470  1.00 32.24           N  
ATOM   1350  CA  ILE    90       5.503  -2.224   1.282  1.00 31.31           C  
ATOM   1351  C   ILE    90       4.533  -1.885   0.152  1.00 73.11           C  
ATOM   1352  O   ILE    90       4.821  -1.042  -0.700  1.00  4.12           O  
ATOM   1353  CB  ILE    90       6.558  -3.259   0.815  1.00 23.53           C  
ATOM   1354  CG1 ILE    90       5.924  -4.601   0.429  1.00 33.53           C  
ATOM   1355  CG2 ILE    90       7.607  -3.464   1.899  1.00 34.14           C  
ATOM   1356  CD1 ILE    90       5.578  -4.718  -1.040  1.00 53.43           C  
ATOM   1357  H   ILE    90       4.876  -3.585   2.779  1.00 55.43           H  
ATOM   1358  HA  ILE    90       6.030  -1.316   1.548  1.00 52.21           H  
ATOM   1359  HB  ILE    90       7.054  -2.849  -0.047  1.00 40.41           H  
ATOM   1360 HG12 ILE    90       6.612  -5.397   0.668  1.00 36.92           H  
ATOM   1361 HG13 ILE    90       5.014  -4.737   0.996  1.00 36.92           H  
ATOM   1362 HG21 ILE    90       8.068  -2.517   2.141  1.00 36.92           H  
ATOM   1363 HG22 ILE    90       8.361  -4.150   1.545  1.00 36.92           H  
ATOM   1364 HG23 ILE    90       7.137  -3.871   2.782  1.00 36.92           H  
ATOM   1365 HD11 ILE    90       5.115  -5.676  -1.223  1.00 36.92           H  
ATOM   1366 HD12 ILE    90       6.479  -4.634  -1.631  1.00 36.92           H  
ATOM   1367 HD13 ILE    90       4.893  -3.929  -1.311  1.00 36.92           H  
ATOM   1368  N   PHE    91       3.384  -2.548   0.152  1.00 12.44           N  
ATOM   1369  CA  PHE    91       2.319  -2.246  -0.793  1.00  4.12           C  
ATOM   1370  C   PHE    91       1.830  -0.816  -0.570  1.00 34.42           C  
ATOM   1371  O   PHE    91       1.723  -0.035  -1.515  1.00 51.31           O  
ATOM   1372  CB  PHE    91       1.172  -3.249  -0.628  1.00  3.51           C  
ATOM   1373  CG  PHE    91       0.042  -3.069  -1.600  1.00 12.43           C  
ATOM   1374  CD1 PHE    91       0.213  -3.358  -2.942  1.00 64.41           C  
ATOM   1375  CD2 PHE    91      -1.193  -2.620  -1.168  1.00  2.12           C  
ATOM   1376  CE1 PHE    91      -0.827  -3.202  -3.837  1.00  1.12           C  
ATOM   1377  CE2 PHE    91      -2.238  -2.463  -2.057  1.00 51.23           C  
ATOM   1378  CZ  PHE    91      -2.054  -2.754  -3.393  1.00 33.21           C  
ATOM   1379  H   PHE    91       3.248  -3.261   0.810  1.00 34.24           H  
ATOM   1380  HA  PHE    91       2.723  -2.328  -1.791  1.00 22.42           H  
ATOM   1381  HB2 PHE    91       1.560  -4.248  -0.757  1.00 36.92           H  
ATOM   1382  HB3 PHE    91       0.769  -3.155   0.370  1.00 36.92           H  
ATOM   1383  HD1 PHE    91       1.172  -3.709  -3.289  1.00 41.40           H  
ATOM   1384  HD2 PHE    91      -1.335  -2.391  -0.122  1.00 71.30           H  
ATOM   1385  HE1 PHE    91      -0.679  -3.430  -4.882  1.00 71.31           H  
ATOM   1386  HE2 PHE    91      -3.198  -2.112  -1.706  1.00 41.33           H  
ATOM   1387  HZ  PHE    91      -2.869  -2.633  -4.092  1.00 14.52           H  
ATOM   1388  N   GLU    92       1.566  -0.479   0.693  1.00 60.31           N  
ATOM   1389  CA  GLU    92       1.198   0.884   1.079  1.00 10.41           C  
ATOM   1390  C   GLU    92       2.265   1.883   0.648  1.00 35.53           C  
ATOM   1391  O   GLU    92       1.952   2.971   0.162  1.00 73.23           O  
ATOM   1392  CB  GLU    92       0.999   0.976   2.593  1.00 11.32           C  
ATOM   1393  CG  GLU    92      -0.192   0.187   3.105  1.00 64.52           C  
ATOM   1394  CD  GLU    92      -1.510   0.842   2.735  1.00 54.45           C  
ATOM   1395  OE1 GLU    92      -1.816   1.931   3.280  1.00 62.31           O  
ATOM   1396  OE2 GLU    92      -2.236   0.284   1.889  1.00 51.03           O  
ATOM   1397  H   GLU    92       1.610  -1.172   1.387  1.00 65.03           H  
ATOM   1398  HA  GLU    92       0.270   1.131   0.588  1.00 64.10           H  
ATOM   1399  HB2 GLU    92       1.887   0.604   3.083  1.00 36.92           H  
ATOM   1400  HB3 GLU    92       0.860   2.015   2.862  1.00 36.92           H  
ATOM   1401  HG2 GLU    92      -0.164  -0.803   2.672  1.00 36.92           H  
ATOM   1402  HG3 GLU    92      -0.125   0.109   4.181  1.00 36.92           H  
ATOM   1403  N   LEU    93       3.524   1.505   0.827  1.00 14.44           N  
ATOM   1404  CA  LEU    93       4.640   2.349   0.424  1.00 24.34           C  
ATOM   1405  C   LEU    93       4.606   2.583  -1.085  1.00 52.55           C  
ATOM   1406  O   LEU    93       4.647   3.724  -1.550  1.00 74.11           O  
ATOM   1407  CB  LEU    93       5.964   1.700   0.832  1.00  3.13           C  
ATOM   1408  CG  LEU    93       6.067   1.306   2.306  1.00 35.43           C  
ATOM   1409  CD1 LEU    93       7.460   0.789   2.622  1.00 62.01           C  
ATOM   1410  CD2 LEU    93       5.712   2.481   3.203  1.00 24.35           C  
ATOM   1411  H   LEU    93       3.706   0.635   1.248  1.00 15.41           H  
ATOM   1412  HA  LEU    93       4.539   3.298   0.929  1.00 74.31           H  
ATOM   1413  HB2 LEU    93       6.102   0.811   0.235  1.00 36.92           H  
ATOM   1414  HB3 LEU    93       6.764   2.391   0.610  1.00 36.92           H  
ATOM   1415  HG  LEU    93       5.364   0.510   2.507  1.00 55.25           H  
ATOM   1416 HD11 LEU    93       8.183   1.571   2.441  1.00 36.92           H  
ATOM   1417 HD12 LEU    93       7.681  -0.058   1.991  1.00 36.92           H  
ATOM   1418 HD13 LEU    93       7.506   0.487   3.659  1.00 36.92           H  
ATOM   1419 HD21 LEU    93       5.766   2.175   4.236  1.00 36.92           H  
ATOM   1420 HD22 LEU    93       4.710   2.818   2.978  1.00 36.92           H  
ATOM   1421 HD23 LEU    93       6.409   3.289   3.031  1.00 36.92           H  
ATOM   1422  N   SER    94       4.526   1.491  -1.834  1.00  0.42           N  
ATOM   1423  CA  SER    94       4.378   1.541  -3.285  1.00 43.13           C  
ATOM   1424  C   SER    94       3.182   2.409  -3.695  1.00 14.02           C  
ATOM   1425  O   SER    94       3.272   3.188  -4.643  1.00  4.35           O  
ATOM   1426  CB  SER    94       4.212   0.120  -3.833  1.00  2.31           C  
ATOM   1427  OG  SER    94       5.285  -0.711  -3.419  1.00 23.35           O  
ATOM   1428  H   SER    94       4.600   0.614  -1.398  1.00 60.22           H  
ATOM   1429  HA  SER    94       5.278   1.972  -3.695  1.00  1.32           H  
ATOM   1430  HB2 SER    94       3.288  -0.299  -3.467  1.00 36.92           H  
ATOM   1431  HB3 SER    94       4.192   0.151  -4.913  1.00 36.92           H  
ATOM   1432  HG  SER    94       5.171  -0.947  -2.492  1.00 41.11           H  
ATOM   1433  N   LEU    95       2.070   2.281  -2.972  1.00 65.10           N  
ATOM   1434  CA  LEU    95       0.882   3.091  -3.234  1.00 21.12           C  
ATOM   1435  C   LEU    95       1.207   4.574  -3.106  1.00 64.05           C  
ATOM   1436  O   LEU    95       0.848   5.375  -3.964  1.00  4.22           O  
ATOM   1437  CB  LEU    95      -0.252   2.736  -2.267  1.00 12.15           C  
ATOM   1438  CG  LEU    95      -0.826   1.327  -2.408  1.00 65.30           C  
ATOM   1439  CD1 LEU    95      -1.894   1.083  -1.355  1.00 40.24           C  
ATOM   1440  CD2 LEU    95      -1.397   1.125  -3.799  1.00 22.31           C  
ATOM   1441  H   LEU    95       2.047   1.617  -2.244  1.00 33.15           H  
ATOM   1442  HA  LEU    95       0.561   2.888  -4.246  1.00 51.10           H  
ATOM   1443  HB2 LEU    95       0.116   2.849  -1.258  1.00 36.92           H  
ATOM   1444  HB3 LEU    95      -1.056   3.442  -2.417  1.00 36.92           H  
ATOM   1445  HG  LEU    95      -0.036   0.604  -2.257  1.00 24.45           H  
ATOM   1446 HD11 LEU    95      -2.701   1.789  -1.489  1.00 36.92           H  
ATOM   1447 HD12 LEU    95      -1.466   1.210  -0.372  1.00 36.92           H  
ATOM   1448 HD13 LEU    95      -2.277   0.078  -1.454  1.00 36.92           H  
ATOM   1449 HD21 LEU    95      -2.186   1.842  -3.972  1.00 36.92           H  
ATOM   1450 HD22 LEU    95      -1.793   0.124  -3.886  1.00 36.92           H  
ATOM   1451 HD23 LEU    95      -0.616   1.267  -4.530  1.00 36.92           H  
ATOM   1452  N   ARG    96       1.900   4.920  -2.030  1.00 52.23           N  
ATOM   1453  CA  ARG    96       2.298   6.299  -1.768  1.00 74.33           C  
ATOM   1454  C   ARG    96       3.264   6.810  -2.829  1.00 44.22           C  
ATOM   1455  O   ARG    96       3.304   8.001  -3.123  1.00 53.24           O  
ATOM   1456  CB  ARG    96       2.932   6.407  -0.385  1.00 63.10           C  
ATOM   1457  CG  ARG    96       1.926   6.265   0.735  1.00 54.05           C  
ATOM   1458  CD  ARG    96       2.605   6.167   2.084  1.00 63.12           C  
ATOM   1459  NE  ARG    96       3.512   7.289   2.341  1.00 62.44           N  
ATOM   1460  CZ  ARG    96       4.058   7.550   3.530  1.00 22.01           C  
ATOM   1461  NH1 ARG    96       3.766   6.797   4.586  1.00  1.44           N  
ATOM   1462  NH2 ARG    96       4.889   8.573   3.660  1.00 42.11           N  
ATOM   1463  H   ARG    96       2.154   4.221  -1.385  1.00 51.31           H  
ATOM   1464  HA  ARG    96       1.407   6.904  -1.783  1.00 74.33           H  
ATOM   1465  HB2 ARG    96       3.676   5.630  -0.276  1.00 36.92           H  
ATOM   1466  HB3 ARG    96       3.411   7.371  -0.292  1.00 36.92           H  
ATOM   1467  HG2 ARG    96       1.272   7.125   0.731  1.00 36.92           H  
ATOM   1468  HG3 ARG    96       1.345   5.370   0.569  1.00 36.92           H  
ATOM   1469  HD2 ARG    96       1.843   6.152   2.842  1.00 36.92           H  
ATOM   1470  HD3 ARG    96       3.167   5.247   2.120  1.00 36.92           H  
ATOM   1471  HE  ARG    96       3.735   7.874   1.582  1.00 72.43           H  
ATOM   1472 HH11 ARG    96       3.136   6.026   4.496  1.00 36.92           H  
ATOM   1473 HH12 ARG    96       4.172   7.001   5.487  1.00 36.92           H  
ATOM   1474 HH21 ARG    96       5.105   9.149   2.864  1.00 36.92           H  
ATOM   1475 HH22 ARG    96       5.317   8.773   4.556  1.00 36.92           H  
ATOM   1476  N   SER    97       4.043   5.903  -3.390  1.00 72.43           N  
ATOM   1477  CA  SER    97       5.027   6.261  -4.398  1.00 45.52           C  
ATOM   1478  C   SER    97       4.378   6.420  -5.779  1.00 73.23           C  
ATOM   1479  O   SER    97       4.681   7.365  -6.510  1.00 53.10           O  
ATOM   1480  CB  SER    97       6.126   5.194  -4.444  1.00 74.24           C  
ATOM   1481  OG  SER    97       7.168   5.554  -5.335  1.00 11.23           O  
ATOM   1482  H   SER    97       3.963   4.965  -3.112  1.00  1.44           H  
ATOM   1483  HA  SER    97       5.467   7.203  -4.109  1.00 55.10           H  
ATOM   1484  HB2 SER    97       6.544   5.070  -3.457  1.00 36.92           H  
ATOM   1485  HB3 SER    97       5.697   4.259  -4.770  1.00 36.92           H  
ATOM   1486  HG  SER    97       7.251   6.522  -5.360  1.00 50.13           H  
ATOM   1487  N   LEU    98       3.481   5.505  -6.130  1.00 34.54           N  
ATOM   1488  CA  LEU    98       2.902   5.485  -7.469  1.00 34.41           C  
ATOM   1489  C   LEU    98       1.629   6.318  -7.543  1.00  1.11           C  
ATOM   1490  O   LEU    98       1.524   7.239  -8.354  1.00 72.25           O  
ATOM   1491  CB  LEU    98       2.597   4.050  -7.893  1.00 12.30           C  
ATOM   1492  CG  LEU    98       2.422   3.854  -9.401  1.00 10.13           C  
ATOM   1493  CD1 LEU    98       3.708   4.199 -10.134  1.00 33.50           C  
ATOM   1494  CD2 LEU    98       1.994   2.431  -9.713  1.00 62.21           C  
ATOM   1495  H   LEU    98       3.208   4.822  -5.477  1.00 62.32           H  
ATOM   1496  HA  LEU    98       3.630   5.901  -8.150  1.00 63.01           H  
ATOM   1497  HB2 LEU    98       3.398   3.419  -7.549  1.00 36.92           H  
ATOM   1498  HB3 LEU    98       1.685   3.740  -7.406  1.00 36.92           H  
ATOM   1499  HG  LEU    98       1.649   4.521  -9.756  1.00 15.40           H  
ATOM   1500 HD11 LEU    98       3.963   5.231  -9.946  1.00 36.92           H  
ATOM   1501 HD12 LEU    98       3.570   4.049 -11.194  1.00 36.92           H  
ATOM   1502 HD13 LEU    98       4.506   3.562  -9.781  1.00 36.92           H  
ATOM   1503 HD21 LEU    98       1.892   2.312 -10.782  1.00 36.92           H  
ATOM   1504 HD22 LEU    98       1.046   2.229  -9.237  1.00 36.92           H  
ATOM   1505 HD23 LEU    98       2.738   1.741  -9.344  1.00 36.92           H  
ATOM   1506  N   ALA    99       0.664   5.990  -6.698  1.00 63.54           N  
ATOM   1507  CA  ALA    99      -0.616   6.682  -6.705  1.00 23.02           C  
ATOM   1508  C   ALA    99      -0.475   8.024  -6.008  1.00  2.43           C  
ATOM   1509  O   ALA    99      -1.050   9.024  -6.441  1.00 53.01           O  
ATOM   1510  CB  ALA    99      -1.689   5.832  -6.036  1.00 72.13           C  
ATOM   1511  H   ALA    99       0.825   5.286  -6.033  1.00 42.21           H  
ATOM   1512  HA  ALA    99      -0.902   6.846  -7.734  1.00 51.33           H  
ATOM   1513  HB1 ALA    99      -1.413   5.645  -5.008  1.00 36.92           H  
ATOM   1514  HB2 ALA    99      -1.784   4.893  -6.560  1.00 36.92           H  
ATOM   1515  HB3 ALA    99      -2.634   6.356  -6.064  1.00 36.92           H  
END
