
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   92 (  691),  selected   92 , name 3bn4_F
# Molecule2: number of CA atoms   76 ( 1151),  selected   76 , name T0437.pdb
# PARAMETERS: 3bn4_F.T0437.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    I     3_F      D      24           -
LGA    -       -      N      25           -
LGA    A     4_F      C      26          1.417
LGA    V     5_F      T      27          0.297
LGA    G     6_F      S      28          0.973
LGA    M     7_F      K      29          1.541
LGA    I     8_F      F      30          1.020
LGA    E     9_F      S      31          1.203
LGA    T    10_F      R      32          1.763
LGA    L    11_F      F      33          2.265
LGA    G    12_F      F      34          3.238
LGA    -       -      A      35           -
LGA    -       -      T      36           -
LGA    -       -      R      37           -
LGA    -       -      E      38           -
LGA    -       -      E      39           -
LGA    F    13_F      A      40          1.577
LGA    -       -      E      41           -
LGA    P    14_F      S      42          1.865
LGA    A    15_F      F      43          2.112
LGA    V    16_F      M      44          2.877
LGA    V    17_F      T      45          2.244
LGA    E    18_F      K      46          1.327
LGA    A    19_F      L      47          2.294
LGA    A    20_F      K      48          2.939
LGA    D    21_F      E      49          2.001
LGA    S    22_F      L      50          0.975
LGA    M    23_F      A      51          2.509
LGA    V    24_F      A      52          2.670
LGA    K    25_F      A      53          1.582
LGA    A    26_F      A      54          2.647
LGA    A    27_F      S      55          3.315
LGA    R    28_F      S      56          3.937
LGA    -       -      A      57           -
LGA    -       -      D      58           -
LGA    -       -      E      59           -
LGA    V    29_F      G      60          5.151
LGA    T    30_F      A      61          0.465
LGA    L    31_F      S      62          3.395
LGA    V    32_F      V      63          2.057
LGA    G    33_F      A      64          1.478
LGA    Y    34_F      Y      65          1.248
LGA    E    35_F      K      66          0.776
LGA    K    36_F      I      67          1.326
LGA    I    37_F      K      68          2.590
LGA    G    38_F      D      69          3.160
LGA    S    39_F      L      70          2.999
LGA    -       -      E      71           -
LGA    -       -      G      72           -
LGA    -       -      Q      73           -
LGA    G    40_F      V      74          1.049
LGA    R    41_F      E      75          1.097
LGA    V    42_F      L      76          0.754
LGA    T    43_F      D      77          1.315
LGA    V    44_F      A      78          1.523
LGA    I    45_F      A      79          1.661
LGA    V    46_F      F      80          1.214
LGA    R    47_F      T      81          1.302
LGA    G    48_F      F      82          1.621
LGA    -       -      S      83           -
LGA    D    49_F      C      84          0.751
LGA    V    50_F      Q      85          0.732
LGA    S    51_F      A      86          0.805
LGA    E    52_F      E      87          0.783
LGA    V    53_F      M      88          0.965
LGA    Q    54_F      I      89          0.910
LGA    A    55_F      I      90          1.120
LGA    S    56_F      F      91          1.526
LGA    V    57_F      E      92          2.172
LGA    T    58_F      L      93          1.854
LGA    A    59_F      S      94          1.138
LGA    G    60_F      L      95          2.417
LGA    I    61_F      R      96          3.277
LGA    E    62_F      S      97          2.444
LGA    N    63_F      L      98          1.884
LGA    I    64_F      A      99          2.071
LGA    R    65_F      -       -           -
LGA    R    66_F      -       -           -
LGA    V    67_F      -       -           -
LGA    N    68_F      -       -           -
LGA    G    69_F      -       -           -
LGA    G    70_F      -       -           -
LGA    E    71_F      -       -           -
LGA    V    72_F      -       -           -
LGA    L    73_F      -       -           -
LGA    S    74_F      -       -           -
LGA    N    75_F      -       -           -
LGA    H    76_F      -       -           -
LGA    I    77_F      -       -           -
LGA    I    78_F      -       -           -
LGA    A    79_F      -       -           -
LGA    R    80_F      -       -           -
LGA    P    81_F      -       -           -
LGA    H    82_F      -       -           -
LGA    E    83_F      -       -           -
LGA    N    84_F      -       -           -
LGA    L    85_F      -       -           -
LGA    E    86_F      -       -           -
LGA    Y    87_F      -       -           -
LGA    V    88_F      -       -           -
LGA    L    89_F      -       -           -
LGA    P    90_F      -       -           -
LGA    I    91_F      -       -           -
LGA    R    92_F      -       -           -
LGA    Y    93_F      -       -           -
LGA    T    94_F      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   92   76    5.0     61    2.06     6.56     68.463     2.830

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.924243 * X  +   0.236214 * Y  +   0.299962 * Z  + -20.513332
  Y_new =  -0.325523 * X  +   0.076961 * Y  +   0.942397 * Z  + -26.528444
  Z_new =   0.199522 * X  +  -0.968648 * Y  +   0.148024 * Z  +  17.518265 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.419155    1.722438  [ DEG:   -81.3116     98.6884 ]
  Theta =  -0.200870   -2.940722  [ DEG:   -11.5090   -168.4910 ]
  Phi   =  -0.338638    2.802955  [ DEG:   -19.4025    160.5975 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3bn4_F                                        
REMARK     2: T0437.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3bn4_F.T0437.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   92   76   5.0   61   2.06    6.56  68.463
REMARK  ---------------------------------------------------------- 
MOLECULE 3bn4_F
HEADER    STRUCTURAL PROTEIN                      13-DEC-07   3BN4              
TITLE     CARBOXYSOME SUBUNIT, CCMK1                                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CARBON DIOXIDE-CONCENTRATING MECHANISM PROTEIN             
COMPND   3 CCMK HOMOLOG 1;                                                      
COMPND   4 CHAIN: A, B, C, D, E, F;                                             
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SYNECHOCYSTIS SP.;                              
SOURCE   3 GENE: CCMK1;                                                         
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)GOLD;                             
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET22B                                    
KEYWDS    HEXAMER, STRUCTURAL PROTEIN                                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.TANAKA,M.R.SAWAYA,T.O.YEATES                                        
REVDAT   1   04-MAR-08 3BN4    0                                                
JRNL        AUTH   S.TANAKA,C.A.KERFELD,M.R.SAWAYA,F.CAI,S.HEINHORST,           
JRNL        AUTH 2 G.C.CANNON,T.O.YEATES                                        
JRNL        TITL   ATOMIC-LEVEL MODELS OF THE BACTERIAL CARBOXYSOME             
JRNL        TITL 2 SHELL.                                                       
JRNL        REF    SCIENCE                       V. 319  1083 2008              
JRNL        REFN   ASTM SCIEAS  US ISSN 0036-8075                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  3BN4 A    1   111  UNP    P72760   CCMK1_SYNY3      1    111             
DBREF  3BN4 B    1   111  UNP    P72760   CCMK1_SYNY3      1    111             
DBREF  3BN4 C    1   111  UNP    P72760   CCMK1_SYNY3      1    111             
DBREF  3BN4 D    1   111  UNP    P72760   CCMK1_SYNY3      1    111             
DBREF  3BN4 E    1   111  UNP    P72760   CCMK1_SYNY3      1    111             
DBREF  3BN4 F    1   111  UNP    P72760   CCMK1_SYNY3      1    111             
SEQRES   1 A  122  MET SER ILE ALA VAL GLY MET ILE GLU THR LEU GLY PHE          
SEQRES   2 A  122  PRO ALA VAL VAL GLU ALA ALA ASP SER MET VAL LYS ALA          
SEQRES   3 A  122  ALA ARG VAL THR LEU VAL GLY TYR GLU LYS ILE GLY SER          
SEQRES   4 A  122  GLY ARG VAL THR VAL ILE VAL ARG GLY ASP VAL SER GLU          
SEQRES   5 A  122  VAL GLN ALA SER VAL THR ALA GLY ILE GLU ASN ILE ARG          
SEQRES   6 A  122  ARG VAL ASN GLY GLY GLU VAL LEU SER ASN HIS ILE ILE          
SEQRES   7 A  122  ALA ARG PRO HIS GLU ASN LEU GLU TYR VAL LEU PRO ILE          
SEQRES   8 A  122  ARG TYR THR GLU ALA VAL GLU GLN PHE ARG GLU ILE VAL          
SEQRES   9 A  122  ASN PRO SER ILE ILE ARG ARG ALA ALA ALA LEU GLU HIS          
SEQRES  10 A  122  HIS HIS HIS HIS HIS                                          
SEQRES   1 B  122  MET SER ILE ALA VAL GLY MET ILE GLU THR LEU GLY PHE          
SEQRES   2 B  122  PRO ALA VAL VAL GLU ALA ALA ASP SER MET VAL LYS ALA          
SEQRES   3 B  122  ALA ARG VAL THR LEU VAL GLY TYR GLU LYS ILE GLY SER          
SEQRES   4 B  122  GLY ARG VAL THR VAL ILE VAL ARG GLY ASP VAL SER GLU          
SEQRES   5 B  122  VAL GLN ALA SER VAL THR ALA GLY ILE GLU ASN ILE ARG          
SEQRES   6 B  122  ARG VAL ASN GLY GLY GLU VAL LEU SER ASN HIS ILE ILE          
SEQRES   7 B  122  ALA ARG PRO HIS GLU ASN LEU GLU TYR VAL LEU PRO ILE          
SEQRES   8 B  122  ARG TYR THR GLU ALA VAL GLU GLN PHE ARG GLU ILE VAL          
SEQRES   9 B  122  ASN PRO SER ILE ILE ARG ARG ALA ALA ALA LEU GLU HIS          
SEQRES  10 B  122  HIS HIS HIS HIS HIS                                          
SEQRES   1 C  122  MET SER ILE ALA VAL GLY MET ILE GLU THR LEU GLY PHE          
SEQRES   2 C  122  PRO ALA VAL VAL GLU ALA ALA ASP SER MET VAL LYS ALA          
SEQRES   3 C  122  ALA ARG VAL THR LEU VAL GLY TYR GLU LYS ILE GLY SER          
SEQRES   4 C  122  GLY ARG VAL THR VAL ILE VAL ARG GLY ASP VAL SER GLU          
SEQRES   5 C  122  VAL GLN ALA SER VAL THR ALA GLY ILE GLU ASN ILE ARG          
SEQRES   6 C  122  ARG VAL ASN GLY GLY GLU VAL LEU SER ASN HIS ILE ILE          
SEQRES   7 C  122  ALA ARG PRO HIS GLU ASN LEU GLU TYR VAL LEU PRO ILE          
SEQRES   8 C  122  ARG TYR THR GLU ALA VAL GLU GLN PHE ARG GLU ILE VAL          
SEQRES   9 C  122  ASN PRO SER ILE ILE ARG ARG ALA ALA ALA LEU GLU HIS          
SEQRES  10 C  122  HIS HIS HIS HIS HIS                                          
SEQRES   1 D  122  MET SER ILE ALA VAL GLY MET ILE GLU THR LEU GLY PHE          
SEQRES   2 D  122  PRO ALA VAL VAL GLU ALA ALA ASP SER MET VAL LYS ALA          
SEQRES   3 D  122  ALA ARG VAL THR LEU VAL GLY TYR GLU LYS ILE GLY SER          
SEQRES   4 D  122  GLY ARG VAL THR VAL ILE VAL ARG GLY ASP VAL SER GLU          
SEQRES   5 D  122  VAL GLN ALA SER VAL THR ALA GLY ILE GLU ASN ILE ARG          
SEQRES   6 D  122  ARG VAL ASN GLY GLY GLU VAL LEU SER ASN HIS ILE ILE          
SEQRES   7 D  122  ALA ARG PRO HIS GLU ASN LEU GLU TYR VAL LEU PRO ILE          
SEQRES   8 D  122  ARG TYR THR GLU ALA VAL GLU GLN PHE ARG GLU ILE VAL          
SEQRES   9 D  122  ASN PRO SER ILE ILE ARG ARG ALA ALA ALA LEU GLU HIS          
SEQRES  10 D  122  HIS HIS HIS HIS HIS                                          
SEQRES   1 E  122  MET SER ILE ALA VAL GLY MET ILE GLU THR LEU GLY PHE          
SEQRES   2 E  122  PRO ALA VAL VAL GLU ALA ALA ASP SER MET VAL LYS ALA          
SEQRES   3 E  122  ALA ARG VAL THR LEU VAL GLY TYR GLU LYS ILE GLY SER          
SEQRES   4 E  122  GLY ARG VAL THR VAL ILE VAL ARG GLY ASP VAL SER GLU          
SEQRES   5 E  122  VAL GLN ALA SER VAL THR ALA GLY ILE GLU ASN ILE ARG          
SEQRES   6 E  122  ARG VAL ASN GLY GLY GLU VAL LEU SER ASN HIS ILE ILE          
SEQRES   7 E  122  ALA ARG PRO HIS GLU ASN LEU GLU TYR VAL LEU PRO ILE          
SEQRES   8 E  122  ARG TYR THR GLU ALA VAL GLU GLN PHE ARG GLU ILE VAL          
SEQRES   9 E  122  ASN PRO SER ILE ILE ARG ARG ALA ALA ALA LEU GLU HIS          
SEQRES  10 E  122  HIS HIS HIS HIS HIS                                          
SEQRES   1 F  122  MET SER ILE ALA VAL GLY MET ILE GLU THR LEU GLY PHE          
SEQRES   2 F  122  PRO ALA VAL VAL GLU ALA ALA ASP SER MET VAL LYS ALA          
SEQRES   3 F  122  ALA ARG VAL THR LEU VAL GLY TYR GLU LYS ILE GLY SER          
SEQRES   4 F  122  GLY ARG VAL THR VAL ILE VAL ARG GLY ASP VAL SER GLU          
SEQRES   5 F  122  VAL GLN ALA SER VAL THR ALA GLY ILE GLU ASN ILE ARG          
SEQRES   6 F  122  ARG VAL ASN GLY GLY GLU VAL LEU SER ASN HIS ILE ILE          
SEQRES   7 F  122  ALA ARG PRO HIS GLU ASN LEU GLU TYR VAL LEU PRO ILE          
SEQRES   8 F  122  ARG TYR THR GLU ALA VAL GLU GLN PHE ARG GLU ILE VAL          
SEQRES   9 F  122  ASN PRO SER ILE ILE ARG ARG ALA ALA ALA LEU GLU HIS          
SEQRES  10 F  122  HIS HIS HIS HIS HIS                                          
HET    SO4  A 123       5                                                       
HET    SO4  B 123       5                                                       
HET    SO4  C 123       5                                                       
HET    SO4  E 123       5                                                       
HETNAM     SO4 SULFATE ION                                                      
FORMUL   7  SO4    4(O4 S 2-)                                                   
FORMUL  11  HOH   *104(H2 O)                                                    
CRYST1  120.900   69.770   78.010  90.00  94.61  90.00 C 1 2 1      24          
ATOM   3511  N   ILE F   3      -3.353 -13.423   9.236  1.00 54.22           N  
ATOM   3512  CA  ILE F   3      -3.002 -12.962   7.851  1.00 51.77           C  
ATOM   3513  C   ILE F   3      -3.436 -11.509   7.728  1.00 46.81           C  
ATOM   3514  O   ILE F   3      -4.609 -11.202   7.899  1.00 48.72           O  
ATOM   3515  CB  ILE F   3      -3.700 -13.810   6.780  1.00 53.26           C  
ATOM   3516  CG1 ILE F   3      -3.200 -15.251   6.782  1.00 55.12           C  
ATOM   3517  CG2 ILE F   3      -3.442 -13.266   5.382  1.00 55.00           C  
ATOM   3518  CD1 ILE F   3      -3.947 -16.122   5.732  1.00 55.68           C  
ATOM   3519  N   ALA F   4      -2.496 -10.615   7.463  1.00 44.42           N  
ATOM   3520  CA  ALA F   4      -2.793  -9.177   7.395  1.00 45.51           C  
ATOM   3521  C   ALA F   4      -3.734  -8.854   6.241  1.00 44.18           C  
ATOM   3522  O   ALA F   4      -3.858  -9.632   5.294  1.00 45.25           O  
ATOM   3523  CB  ALA F   4      -1.496  -8.343   7.289  1.00 44.08           C  
ATOM   3524  N   VAL F   5      -4.423  -7.727   6.362  1.00 41.87           N  
ATOM   3525  CA  VAL F   5      -5.302  -7.181   5.318  1.00 41.32           C  
ATOM   3526  C   VAL F   5      -4.830  -5.734   5.057  1.00 44.19           C  
ATOM   3527  O   VAL F   5      -4.478  -4.988   5.998  1.00 42.70           O  
ATOM   3528  CB  VAL F   5      -6.778  -7.217   5.744  1.00 41.09           C  
ATOM   3529  CG1 VAL F   5      -6.976  -6.512   7.073  1.00 38.85           C  
ATOM   3530  CG2 VAL F   5      -7.717  -6.595   4.662  1.00 37.93           C  
ATOM   3531  N   GLY F   6      -4.759  -5.383   3.771  1.00 41.61           N  
ATOM   3532  CA  GLY F   6      -4.396  -4.058   3.338  1.00 40.73           C  
ATOM   3533  C   GLY F   6      -5.500  -3.533   2.444  1.00 41.56           C  
ATOM   3534  O   GLY F   6      -6.167  -4.311   1.754  1.00 40.28           O  
ATOM   3535  N   MET F   7      -5.709  -2.217   2.481  1.00 38.31           N  
ATOM   3536  CA  MET F   7      -6.822  -1.608   1.795  1.00 41.61           C  
ATOM   3537  C   MET F   7      -6.441  -0.245   1.308  1.00 41.52           C  
ATOM   3538  O   MET F   7      -5.824   0.537   2.041  1.00 40.70           O  
ATOM   3539  CB  MET F   7      -8.011  -1.466   2.754  1.00 43.74           C  
ATOM   3540  CG  MET F   7      -8.571  -2.790   3.213  1.00 43.91           C  
ATOM   3541  SD  MET F   7      -9.726  -2.566   4.553  1.00 49.18           S  
ATOM   3542  CE  MET F   7      -8.579  -2.310   5.942  1.00 43.44           C  
ATOM   3543  N   ILE F   8      -6.808   0.037   0.061  1.00 40.89           N  
ATOM   3544  CA  ILE F   8      -6.643   1.367  -0.505  1.00 42.41           C  
ATOM   3545  C   ILE F   8      -7.993   1.734  -1.120  1.00 41.62           C  
ATOM   3546  O   ILE F   8      -8.555   0.962  -1.918  1.00 38.77           O  
ATOM   3547  CB  ILE F   8      -5.574   1.443  -1.602  1.00 39.95           C  
ATOM   3548  CG1 ILE F   8      -4.182   1.110  -1.045  1.00 40.69           C  
ATOM   3549  CG2 ILE F   8      -5.558   2.843  -2.227  1.00 38.89           C  
ATOM   3550  CD1 ILE F   8      -3.172   0.761  -2.114  1.00 39.52           C  
ATOM   3551  N   GLU F   9      -8.469   2.913  -0.734  1.00 42.08           N  
ATOM   3552  CA  GLU F   9      -9.729   3.456  -1.222  1.00 43.78           C  
ATOM   3553  C   GLU F   9      -9.424   4.656  -2.092  1.00 45.43           C  
ATOM   3554  O   GLU F   9      -8.698   5.576  -1.672  1.00 45.82           O  
ATOM   3555  CB  GLU F   9     -10.597   3.886  -0.047  1.00 45.55           C  
ATOM   3556  CG  GLU F   9     -11.886   4.589  -0.457  1.00 45.38           C  
ATOM   3557  CD  GLU F   9     -12.730   4.966   0.736  1.00 50.07           C  
ATOM   3558  OE1 GLU F   9     -12.174   5.548   1.703  1.00 52.88           O  
ATOM   3559  OE2 GLU F   9     -13.948   4.667   0.708  1.00 48.64           O  
ATOM   3560  N   THR F  10      -9.985   4.645  -3.296  1.00 45.78           N  
ATOM   3561  CA  THR F  10      -9.829   5.734  -4.239  1.00 47.45           C  
ATOM   3562  C   THR F  10     -11.191   6.309  -4.653  1.00 47.35           C  
ATOM   3563  O   THR F  10     -12.227   5.684  -4.488  1.00 47.33           O  
ATOM   3564  CB  THR F  10      -9.098   5.255  -5.514  1.00 48.46           C  
ATOM   3565  OG1 THR F  10      -9.979   4.448  -6.303  1.00 49.20           O  
ATOM   3566  CG2 THR F  10      -7.856   4.446  -5.173  1.00 45.71           C  
ATOM   3567  N   LEU F  11     -11.140   7.516  -5.194  1.00 46.92           N  
ATOM   3568  CA  LEU F  11     -12.236   8.143  -5.887  1.00 48.66           C  
ATOM   3569  C   LEU F  11     -12.015   7.810  -7.339  1.00 47.81           C  
ATOM   3570  O   LEU F  11     -11.039   8.260  -7.917  1.00 51.96           O  
ATOM   3571  CB  LEU F  11     -12.147   9.675  -5.733  1.00 50.76           C  
ATOM   3572  CG  LEU F  11     -13.444  10.451  -5.584  1.00 52.12           C  
ATOM   3573  CD1 LEU F  11     -13.300  11.770  -6.252  1.00 52.00           C  
ATOM   3574  CD2 LEU F  11     -14.660   9.687  -6.134  1.00 52.72           C  
ATOM   3575  N   GLY F  12     -12.850   6.987  -7.934  1.00 48.08           N  
ATOM   3576  CA  GLY F  12     -12.667   6.666  -9.355  1.00 45.83           C  
ATOM   3577  C   GLY F  12     -12.161   5.267  -9.562  1.00 43.83           C  
ATOM   3578  O   GLY F  12     -11.307   4.792  -8.807  1.00 42.56           O  
ATOM   3579  N   PHE F  13     -12.689   4.608 -10.595  1.00 41.11           N  
ATOM   3580  CA  PHE F  13     -12.402   3.206 -10.836  1.00 43.65           C  
ATOM   3581  C   PHE F  13     -11.023   2.967 -11.478  1.00 44.16           C  
ATOM   3582  O   PHE F  13     -10.379   1.989 -11.142  1.00 45.09           O  
ATOM   3583  CB  PHE F  13     -13.483   2.564 -11.693  1.00 45.00           C  
ATOM   3584  CG  PHE F  13     -13.274   1.107 -11.918  1.00 45.02           C  
ATOM   3585  CD1 PHE F  13     -13.526   0.199 -10.907  1.00 48.62           C  
ATOM   3586  CD2 PHE F  13     -12.788   0.643 -13.124  1.00 46.61           C  
ATOM   3587  CE1 PHE F  13     -13.304  -1.173 -11.119  1.00 49.73           C  
ATOM   3588  CE2 PHE F  13     -12.594  -0.701 -13.336  1.00 46.60           C  
ATOM   3589  CZ  PHE F  13     -12.839  -1.607 -12.330  1.00 48.97           C  
ATOM   3590  N   PRO F  14     -10.582   3.837 -12.416  1.00 43.61           N  
ATOM   3591  CA  PRO F  14      -9.252   3.561 -12.999  1.00 42.37           C  
ATOM   3592  C   PRO F  14      -8.118   3.520 -11.993  1.00 43.75           C  
ATOM   3593  O   PRO F  14      -7.222   2.656 -12.123  1.00 42.89           O  
ATOM   3594  CB  PRO F  14      -9.050   4.708 -13.993  1.00 41.41           C  
ATOM   3595  CG  PRO F  14     -10.458   5.073 -14.411  1.00 41.50           C  
ATOM   3596  CD  PRO F  14     -11.314   4.850 -13.202  1.00 43.72           C  
ATOM   3597  N   ALA F  15      -8.164   4.426 -11.007  1.00 42.77           N  
ATOM   3598  CA  ALA F  15      -7.162   4.469  -9.931  1.00 45.34           C  
ATOM   3599  C   ALA F  15      -7.212   3.202  -9.051  1.00 42.14           C  
ATOM   3600  O   ALA F  15      -6.205   2.745  -8.550  1.00 41.49           O  
ATOM   3601  CB  ALA F  15      -7.361   5.729  -9.061  1.00 44.69           C  
ATOM   3602  N   VAL F  16      -8.392   2.636  -8.855  1.00 41.87           N  
ATOM   3603  CA  VAL F  16      -8.488   1.451  -8.028  1.00 45.01           C  
ATOM   3604  C   VAL F  16      -7.843   0.230  -8.749  1.00 43.36           C  
ATOM   3605  O   VAL F  16      -7.227  -0.633  -8.123  1.00 41.76           O  
ATOM   3606  CB  VAL F  16      -9.949   1.210  -7.546  1.00 47.13           C  
ATOM   3607  CG1 VAL F  16     -10.601   0.050  -8.299  1.00 45.55           C  
ATOM   3608  CG2 VAL F  16      -9.926   0.967  -6.016  1.00 45.66           C  
ATOM   3609  N   VAL F  17      -7.939   0.202 -10.067  1.00 46.06           N  
ATOM   3610  CA  VAL F  17      -7.318  -0.871 -10.848  1.00 44.80           C  
ATOM   3611  C   VAL F  17      -5.799  -0.799 -10.733  1.00 43.32           C  
ATOM   3612  O   VAL F  17      -5.136  -1.819 -10.570  1.00 45.95           O  
ATOM   3613  CB  VAL F  17      -7.789  -0.830 -12.295  1.00 45.19           C  
ATOM   3614  CG1 VAL F  17      -7.308  -2.064 -13.057  1.00 47.30           C  
ATOM   3615  CG2 VAL F  17      -9.310  -0.750 -12.324  1.00 43.84           C  
ATOM   3616  N   GLU F  18      -5.257   0.406 -10.805  1.00 45.20           N  
ATOM   3617  CA  GLU F  18      -3.827   0.621 -10.653  1.00 47.02           C  
ATOM   3618  C   GLU F  18      -3.393   0.261  -9.225  1.00 46.90           C  
ATOM   3619  O   GLU F  18      -2.430  -0.480  -9.034  1.00 47.93           O  
ATOM   3620  CB  GLU F  18      -3.477   2.073 -10.991  1.00 49.15           C  
ATOM   3621  CG  GLU F  18      -2.023   2.446 -10.805  1.00 49.55           C  
ATOM   3622  CD  GLU F  18      -1.053   1.571 -11.600  1.00 54.03           C  
ATOM   3623  OE1 GLU F  18      -1.247   1.388 -12.825  1.00 56.11           O  
ATOM   3624  OE2 GLU F  18      -0.069   1.081 -11.000  1.00 58.49           O  
ATOM   3625  N   ALA F  19      -4.115   0.761  -8.229  1.00 45.73           N  
ATOM   3626  CA  ALA F  19      -3.895   0.316  -6.859  1.00 43.06           C  
ATOM   3627  C   ALA F  19      -3.820  -1.237  -6.779  1.00 39.69           C  
ATOM   3628  O   ALA F  19      -2.823  -1.770  -6.298  1.00 43.43           O  
ATOM   3629  CB  ALA F  19      -4.969   0.912  -5.913  1.00 41.53           C  
ATOM   3630  N   ALA F  20      -4.806  -1.955  -7.315  1.00 39.61           N  
ATOM   3631  CA  ALA F  20      -4.816  -3.457  -7.265  1.00 39.83           C  
ATOM   3632  C   ALA F  20      -3.608  -4.071  -7.972  1.00 42.71           C  
ATOM   3633  O   ALA F  20      -2.902  -4.911  -7.402  1.00 39.68           O  
ATOM   3634  CB  ALA F  20      -6.098  -4.035  -7.858  1.00 40.44           C  
ATOM   3635  N   ASP F  21      -3.356  -3.613  -9.194  1.00 41.60           N  
ATOM   3636  CA  ASP F  21      -2.238  -4.096  -9.980  1.00 42.64           C  
ATOM   3637  C   ASP F  21      -0.893  -3.909  -9.234  1.00 44.08           C  
ATOM   3638  O   ASP F  21      -0.140  -4.863  -9.036  1.00 43.74           O  
ATOM   3639  CB  ASP F  21      -2.232  -3.390 -11.333  1.00 45.83           C  
ATOM   3640  CG  ASP F  21      -1.232  -4.000 -12.315  1.00 50.88           C  
ATOM   3641  OD1 ASP F  21      -1.316  -5.229 -12.587  1.00 52.30           O  
ATOM   3642  OD2 ASP F  21      -0.354  -3.236 -12.804  1.00 55.25           O  
ATOM   3643  N   SER F  22      -0.618  -2.678  -8.818  1.00 44.07           N  
ATOM   3644  CA  SER F  22       0.603  -2.328  -8.098  1.00 45.28           C  
ATOM   3645  C   SER F  22       0.792  -3.139  -6.823  1.00 45.70           C  
ATOM   3646  O   SER F  22       1.900  -3.575  -6.510  1.00 43.65           O  
ATOM   3647  CB  SER F  22       0.549  -0.835  -7.733  1.00 46.45           C  
ATOM   3648  OG  SER F  22       0.845  -0.040  -8.866  1.00 48.81           O  
ATOM   3649  N   MET F  23      -0.293  -3.310  -6.075  1.00 42.96           N  
ATOM   3650  CA  MET F  23      -0.276  -4.092  -4.849  1.00 44.99           C  
ATOM   3651  C   MET F  23       0.162  -5.518  -5.103  1.00 43.95           C  
ATOM   3652  O   MET F  23       1.112  -5.988  -4.470  1.00 45.21           O  
ATOM   3653  CB  MET F  23      -1.653  -4.071  -4.160  1.00 44.30           C  
ATOM   3654  CG  MET F  23      -2.010  -2.700  -3.575  1.00 47.87           C  
ATOM   3655  SD  MET F  23      -3.781  -2.513  -3.102  1.00 55.87           S  
ATOM   3656  CE  MET F  23      -3.554  -3.184  -1.471  1.00 48.37           C  
ATOM   3657  N   VAL F  24      -0.482  -6.211  -6.039  1.00 42.40           N  
ATOM   3658  CA  VAL F  24      -0.121  -7.623  -6.269  1.00 41.84           C  
ATOM   3659  C   VAL F  24       1.260  -7.779  -6.910  1.00 45.44           C  
ATOM   3660  O   VAL F  24       1.893  -8.843  -6.788  1.00 41.17           O  
ATOM   3661  CB  VAL F  24      -1.185  -8.396  -7.061  1.00 45.17           C  
ATOM   3662  CG1 VAL F  24      -2.495  -8.520  -6.226  1.00 44.16           C  
ATOM   3663  CG2 VAL F  24      -1.490  -7.698  -8.408  1.00 45.99           C  
ATOM   3664  N   LYS F  25       1.742  -6.724  -7.564  1.00 44.72           N  
ATOM   3665  CA  LYS F  25       3.056  -6.787  -8.217  1.00 46.09           C  
ATOM   3666  C   LYS F  25       4.201  -6.453  -7.273  1.00 45.90           C  
ATOM   3667  O   LYS F  25       5.321  -6.942  -7.460  1.00 48.60           O  
ATOM   3668  CB  LYS F  25       3.112  -5.857  -9.429  1.00 43.74           C  
ATOM   3669  CG  LYS F  25       2.328  -6.368 -10.646  1.00 44.75           C  
ATOM   3670  CD  LYS F  25       2.329  -5.342 -11.743  1.00 44.02           C  
ATOM   3671  CE  LYS F  25       1.808  -5.916 -13.052  1.00 47.17           C  
ATOM   3672  NZ  LYS F  25       1.481  -4.851 -14.047  1.00 45.93           N  
ATOM   3673  N   ALA F  26       3.929  -5.617  -6.277  1.00 47.38           N  
ATOM   3674  CA  ALA F  26       4.977  -5.131  -5.366  1.00 46.55           C  
ATOM   3675  C   ALA F  26       5.382  -6.175  -4.329  1.00 47.20           C  
ATOM   3676  O   ALA F  26       6.483  -6.099  -3.780  1.00 50.15           O  
ATOM   3677  CB  ALA F  26       4.523  -3.841  -4.676  1.00 45.18           C  
ATOM   3678  N   ALA F  27       4.522  -7.156  -4.069  1.00 45.43           N  
ATOM   3679  CA  ALA F  27       4.781  -8.120  -3.007  1.00 47.73           C  
ATOM   3680  C   ALA F  27       3.899  -9.365  -3.099  1.00 46.87           C  
ATOM   3681  O   ALA F  27       3.034  -9.442  -3.945  1.00 44.82           O  
ATOM   3682  CB  ALA F  27       4.594  -7.445  -1.660  1.00 47.07           C  
ATOM   3683  N   ARG F  28       4.122 -10.335  -2.212  1.00 47.88           N  
ATOM   3684  CA  ARG F  28       3.369 -11.594  -2.233  1.00 48.51           C  
ATOM   3685  C   ARG F  28       2.080 -11.392  -1.438  1.00 47.26           C  
ATOM   3686  O   ARG F  28       1.965 -11.817  -0.298  1.00 46.85           O  
ATOM   3687  CB  ARG F  28       4.166 -12.758  -1.618  1.00 52.87           C  
ATOM   3688  CG  ARG F  28       5.668 -12.796  -1.894  1.00 57.96           C  
ATOM   3689  CD  ARG F  28       6.362 -13.512  -0.733  1.00 63.22           C  
ATOM   3690  NE  ARG F  28       7.825 -13.435  -0.738  1.00 68.20           N  
ATOM   3691  CZ  ARG F  28       8.635 -14.327  -1.315  1.00 72.80           C  
ATOM   3692  NH1 ARG F  28       9.956 -14.167  -1.237  1.00 73.20           N  
ATOM   3693  NH2 ARG F  28       8.140 -15.375  -1.986  1.00 74.82           N  
ATOM   3694  N   VAL F  29       1.118 -10.719  -2.042  1.00 43.92           N  
ATOM   3695  CA  VAL F  29      -0.176 -10.513  -1.432  1.00 43.66           C  
ATOM   3696  C   VAL F  29      -1.174 -11.007  -2.439  1.00 44.34           C  
ATOM   3697  O   VAL F  29      -0.886 -11.048  -3.633  1.00 44.27           O  
ATOM   3698  CB  VAL F  29      -0.471  -8.982  -1.110  1.00 42.84           C  
ATOM   3699  CG1 VAL F  29       0.509  -8.427  -0.058  1.00 44.27           C  
ATOM   3700  CG2 VAL F  29      -0.487  -8.113  -2.372  1.00 38.44           C  
ATOM   3701  N   THR F  30      -2.357 -11.363  -1.966  1.00 44.04           N  
ATOM   3702  CA  THR F  30      -3.457 -11.688  -2.854  1.00 45.59           C  
ATOM   3703  C   THR F  30      -4.507 -10.606  -2.769  1.00 45.06           C  
ATOM   3704  O   THR F  30      -4.899 -10.204  -1.693  1.00 45.31           O  
ATOM   3705  CB  THR F  30      -4.135 -13.002  -2.464  1.00 46.77           C  
ATOM   3706  OG1 THR F  30      -3.161 -14.032  -2.405  1.00 49.90           O  
ATOM   3707  CG2 THR F  30      -5.173 -13.371  -3.476  1.00 47.63           C  
ATOM   3708  N   LEU F  31      -4.932 -10.133  -3.924  1.00 45.78           N  
ATOM   3709  CA  LEU F  31      -6.122  -9.312  -4.064  1.00 44.31           C  
ATOM   3710  C   LEU F  31      -7.337 -10.212  -3.864  1.00 47.22           C  
ATOM   3711  O   LEU F  31      -7.538 -11.177  -4.613  1.00 46.62           O  
ATOM   3712  CB  LEU F  31      -6.134  -8.685  -5.464  1.00 42.01           C  
ATOM   3713  CG  LEU F  31      -7.320  -7.806  -5.814  1.00 44.14           C  
ATOM   3714  CD1 LEU F  31      -7.253  -6.498  -5.000  1.00 43.51           C  
ATOM   3715  CD2 LEU F  31      -7.372  -7.519  -7.349  1.00 42.85           C  
ATOM   3716  N   VAL F  32      -8.158  -9.886  -2.869  1.00 44.33           N  
ATOM   3717  CA  VAL F  32      -9.296 -10.734  -2.543  1.00 47.38           C  
ATOM   3718  C   VAL F  32     -10.612 -10.050  -2.827  1.00 49.91           C  
ATOM   3719  O   VAL F  32     -11.635 -10.710  -2.894  1.00 51.47           O  
ATOM   3720  CB  VAL F  32      -9.258 -11.215  -1.091  1.00 49.15           C  
ATOM   3721  CG1 VAL F  32      -8.042 -12.091  -0.894  1.00 46.67           C  
ATOM   3722  CG2 VAL F  32      -9.279 -10.013  -0.094  1.00 49.35           C  
ATOM   3723  N   GLY F  33     -10.587  -8.736  -3.034  1.00 49.79           N  
ATOM   3724  CA  GLY F  33     -11.821  -8.013  -3.177  1.00 47.93           C  
ATOM   3725  C   GLY F  33     -11.753  -6.563  -3.575  1.00 45.56           C  
ATOM   3726  O   GLY F  33     -10.715  -5.883  -3.530  1.00 41.60           O  
ATOM   3727  N   TYR F  34     -12.925  -6.133  -3.998  1.00 47.00           N  
ATOM   3728  CA  TYR F  34     -13.212  -4.792  -4.463  0.50 45.53           C  
ATOM   3730  C   TYR F  34     -14.565  -4.372  -3.836  1.00 45.78           C  
ATOM   3731  O   TYR F  34     -15.516  -5.091  -4.016  1.00 43.74           O  
ATOM   3732  CB  TYR F  34     -13.297  -4.922  -5.981  0.50 45.71           C  
ATOM   3734  CG  TYR F  34     -13.972  -3.835  -6.758  0.50 44.19           C  
ATOM   3736  CD1 TYR F  34     -13.575  -2.513  -6.642  0.50 42.75           C  
ATOM   3738  CD2 TYR F  34     -14.967  -4.150  -7.680  0.50 43.09           C  
ATOM   3740  CE1 TYR F  34     -14.181  -1.538  -7.377  0.50 40.91           C  
ATOM   3742  CE2 TYR F  34     -15.569  -3.180  -8.426  0.50 41.28           C  
ATOM   3744  CZ  TYR F  34     -15.175  -1.876  -8.272  0.50 41.24           C  
ATOM   3746  OH  TYR F  34     -15.769  -0.891  -9.010  0.50 37.94           O  
ATOM   3748  N   GLU F  35     -14.646  -3.237  -3.159  1.00 43.99           N  
ATOM   3749  CA  GLU F  35     -15.880  -2.836  -2.478  1.00 45.90           C  
ATOM   3750  C   GLU F  35     -16.301  -1.458  -2.924  1.00 45.04           C  
ATOM   3751  O   GLU F  35     -15.507  -0.531  -2.922  1.00 45.37           O  
ATOM   3752  CB  GLU F  35     -15.614  -2.831  -0.964  1.00 47.97           C  
ATOM   3753  CG  GLU F  35     -16.799  -2.474  -0.048  1.00 52.88           C  
ATOM   3754  CD  GLU F  35     -17.950  -3.512  -0.048  1.00 56.85           C  
ATOM   3755  OE1 GLU F  35     -17.810  -4.640  -0.613  1.00 57.11           O  
ATOM   3756  OE2 GLU F  35     -19.013  -3.167   0.539  1.00 57.31           O  
ATOM   3757  N   LYS F  36     -17.563  -1.323  -3.297  1.00 44.57           N  
ATOM   3758  CA  LYS F  36     -18.114  -0.063  -3.657  1.00 46.71           C  
ATOM   3759  C   LYS F  36     -19.092   0.317  -2.556  1.00 47.08           C  
ATOM   3760  O   LYS F  36     -19.937  -0.498  -2.175  1.00 47.72           O  
ATOM   3761  CB  LYS F  36     -18.852  -0.162  -5.003  1.00 46.94           C  
ATOM   3762  CG  LYS F  36     -18.064  -0.931  -6.072  1.00 51.94           C  
ATOM   3763  CD  LYS F  36     -18.963  -1.653  -7.089  1.00 53.14           C  
ATOM   3764  CE  LYS F  36     -19.394  -0.742  -8.176  1.00 57.10           C  
ATOM   3765  NZ  LYS F  36     -20.053  -1.460  -9.279  1.00 58.91           N  
ATOM   3766  N   ILE F  37     -18.970   1.554  -2.073  1.00 44.35           N  
ATOM   3767  CA  ILE F  37     -19.806   2.069  -1.017  1.00 44.93           C  
ATOM   3768  C   ILE F  37     -20.539   3.367  -1.428  1.00 47.14           C  
ATOM   3769  O   ILE F  37     -21.107   4.048  -0.573  1.00 44.21           O  
ATOM   3770  CB  ILE F  37     -18.986   2.316   0.270  1.00 44.65           C  
ATOM   3771  CG1 ILE F  37     -18.026   3.516   0.102  1.00 44.46           C  
ATOM   3772  CG2 ILE F  37     -18.264   1.039   0.669  1.00 41.74           C  
ATOM   3773  CD1 ILE F  37     -17.328   3.940   1.367  1.00 44.46           C  
ATOM   3774  N   GLY F  38     -20.479   3.717  -2.716  1.00 43.45           N  
ATOM   3775  CA  GLY F  38     -21.149   4.910  -3.234  1.00 45.34           C  
ATOM   3776  C   GLY F  38     -20.300   6.172  -3.185  1.00 47.12           C  
ATOM   3777  O   GLY F  38     -19.197   6.165  -2.645  1.00 44.31           O  
ATOM   3778  N   SER F  39     -20.811   7.260  -3.755  1.00 46.48           N  
ATOM   3779  CA  SER F  39     -20.048   8.513  -3.862  1.00 49.88           C  
ATOM   3780  C   SER F  39     -18.721   8.381  -4.582  1.00 48.43           C  
ATOM   3781  O   SER F  39     -17.810   9.139  -4.301  1.00 52.05           O  
ATOM   3782  CB  SER F  39     -19.799   9.154  -2.478  1.00 52.57           C  
ATOM   3783  OG  SER F  39     -20.796  10.120  -2.238  1.00 58.94           O  
ATOM   3784  N   GLY F  40     -18.618   7.445  -5.521  1.00 46.10           N  
ATOM   3785  CA  GLY F  40     -17.397   7.232  -6.270  1.00 44.06           C  
ATOM   3786  C   GLY F  40     -16.263   6.558  -5.521  1.00 44.23           C  
ATOM   3787  O   GLY F  40     -15.136   6.470  -6.037  1.00 44.63           O  
ATOM   3788  N   ARG F  41     -16.538   6.083  -4.302  1.00 40.27           N  
ATOM   3789  CA  ARG F  41     -15.501   5.570  -3.419  1.00 40.55           C  
ATOM   3790  C   ARG F  41     -15.478   4.080  -3.590  1.00 42.42           C  
ATOM   3791  O   ARG F  41     -16.529   3.411  -3.466  1.00 46.28           O  
ATOM   3792  CB  ARG F  41     -15.797   5.889  -1.955  1.00 45.04           C  
ATOM   3793  CG  ARG F  41     -16.032   7.362  -1.644  1.00 47.15           C  
ATOM   3794  CD  ARG F  41     -16.370   7.532  -0.167  1.00 49.56           C  
ATOM   3795  NE  ARG F  41     -15.204   7.357   0.691  1.00 52.83           N  
ATOM   3796  CZ  ARG F  41     -14.510   8.340   1.256  1.00 52.27           C  
ATOM   3797  NH1 ARG F  41     -14.834   9.616   1.059  1.00 53.11           N  
ATOM   3798  NH2 ARG F  41     -13.471   8.044   2.019  1.00 51.24           N  
ATOM   3799  N   VAL F  42     -14.296   3.570  -3.906  1.00 41.59           N  
ATOM   3800  CA  VAL F  42     -14.078   2.153  -4.155  1.00 38.18           C  
ATOM   3801  C   VAL F  42     -12.775   1.775  -3.462  1.00 41.20           C  
ATOM   3802  O   VAL F  42     -11.829   2.542  -3.472  1.00 41.42           O  
ATOM   3803  CB  VAL F  42     -14.036   1.868  -5.678  1.00 40.56           C  
ATOM   3804  CG1 VAL F  42     -15.442   2.051  -6.291  1.00 39.50           C  
ATOM   3805  CG2 VAL F  42     -13.095   2.829  -6.388  1.00 45.19           C  
ATOM   3806  N   THR F  43     -12.759   0.589  -2.852  1.00 43.07           N  
ATOM   3807  CA  THR F  43     -11.624   0.062  -2.103  1.00 43.14           C  
ATOM   3808  C   THR F  43     -11.227  -1.287  -2.693  1.00 41.82           C  
ATOM   3809  O   THR F  43     -12.075  -2.072  -3.107  1.00 42.61           O  
ATOM   3810  CB  THR F  43     -11.984  -0.109  -0.605  1.00 44.28           C  
ATOM   3811  OG1 THR F  43     -12.474   1.118  -0.102  1.00 40.98           O  
ATOM   3812  CG2 THR F  43     -10.752  -0.493   0.247  1.00 40.45           C  
ATOM   3813  N   VAL F  44      -9.928  -1.522  -2.772  1.00 41.63           N  
ATOM   3814  CA  VAL F  44      -9.393  -2.829  -3.059  1.00 39.27           C  
ATOM   3815  C   VAL F  44      -8.702  -3.354  -1.797  1.00 40.04           C  
ATOM   3816  O   VAL F  44      -8.058  -2.602  -1.055  1.00 37.78           O  
ATOM   3817  CB  VAL F  44      -8.378  -2.804  -4.289  1.00 40.35           C  
ATOM   3818  CG1 VAL F  44      -9.133  -2.725  -5.571  1.00 40.26           C  
ATOM   3819  CG2 VAL F  44      -7.365  -1.656  -4.196  1.00 40.85           C  
ATOM   3820  N   ILE F  45      -8.816  -4.667  -1.611  1.00 41.27           N  
ATOM   3821  CA  ILE F  45      -8.419  -5.358  -0.414  1.00 41.47           C  
ATOM   3822  C   ILE F  45      -7.496  -6.528  -0.777  1.00 41.02           C  
ATOM   3823  O   ILE F  45      -7.828  -7.372  -1.626  1.00 41.17           O  
ATOM   3824  CB  ILE F  45      -9.648  -5.941   0.327  1.00 40.82           C  
ATOM   3825  CG1 ILE F  45     -10.727  -4.881   0.536  1.00 43.55           C  
ATOM   3826  CG2 ILE F  45      -9.263  -6.516   1.677  1.00 41.42           C  
ATOM   3827  CD1 ILE F  45     -12.109  -5.401   0.241  1.00 46.55           C  
ATOM   3828  N   VAL F  46      -6.329  -6.566  -0.134  1.00 43.62           N  
ATOM   3829  CA  VAL F  46      -5.425  -7.689  -0.290  1.00 41.85           C  
ATOM   3830  C   VAL F  46      -5.169  -8.355   1.069  1.00 42.56           C  
ATOM   3831  O   VAL F  46      -5.411  -7.746   2.114  1.00 38.61           O  
ATOM   3832  CB  VAL F  46      -4.081  -7.278  -0.902  1.00 41.01           C  
ATOM   3833  CG1 VAL F  46      -4.293  -6.657  -2.292  1.00 39.54           C  
ATOM   3834  CG2 VAL F  46      -3.322  -6.336   0.038  1.00 39.55           C  
ATOM   3835  N   ARG F  47      -4.664  -9.596   1.013  1.00 44.93           N  
ATOM   3836  CA  ARG F  47      -4.256 -10.352   2.192  1.00 44.73           C  
ATOM   3837  C   ARG F  47      -2.855 -10.886   1.980  1.00 46.06           C  
ATOM   3838  O   ARG F  47      -2.430 -11.103   0.855  1.00 43.48           O  
ATOM   3839  CB  ARG F  47      -5.239 -11.501   2.464  1.00 46.80           C  
ATOM   3840  CG  ARG F  47      -6.711 -11.103   2.531  1.00 48.06           C  
ATOM   3841  CD  ARG F  47      -7.025 -10.206   3.735  1.00 50.07           C  
ATOM   3842  NE  ARG F  47      -6.697 -10.817   5.032  1.00 52.66           N  
ATOM   3843  CZ  ARG F  47      -7.466 -11.679   5.698  1.00 55.42           C  
ATOM   3844  NH1 ARG F  47      -8.622 -12.098   5.202  1.00 57.75           N  
ATOM   3845  NH2 ARG F  47      -7.051 -12.156   6.864  1.00 57.31           N  
ATOM   3846  N   GLY F  48      -2.122 -11.062   3.073  1.00 44.70           N  
ATOM   3847  CA  GLY F  48      -0.755 -11.567   3.038  1.00 45.18           C  
ATOM   3848  C   GLY F  48      -0.074 -11.313   4.364  1.00 44.78           C  
ATOM   3849  O   GLY F  48      -0.723 -10.856   5.307  1.00 43.54           O  
ATOM   3850  N   ASP F  49       1.215 -11.627   4.445  1.00 46.83           N  
ATOM   3851  CA  ASP F  49       2.005 -11.358   5.647  1.00 50.36           C  
ATOM   3852  C   ASP F  49       2.169  -9.858   5.853  1.00 49.41           C  
ATOM   3853  O   ASP F  49       2.213  -9.087   4.900  1.00 48.00           O  
ATOM   3854  CB  ASP F  49       3.385 -12.010   5.541  1.00 54.21           C  
ATOM   3855  CG  ASP F  49       3.344 -13.490   5.844  1.00 58.25           C  
ATOM   3856  OD1 ASP F  49       2.495 -14.184   5.257  1.00 63.84           O  
ATOM   3857  OD2 ASP F  49       4.146 -13.951   6.683  1.00 63.23           O  
ATOM   3858  N   VAL F  50       2.271  -9.435   7.098  1.00 45.60           N  
ATOM   3859  CA  VAL F  50       2.191  -8.007   7.350  1.00 47.85           C  
ATOM   3860  C   VAL F  50       3.245  -7.203   6.615  1.00 47.38           C  
ATOM   3861  O   VAL F  50       2.928  -6.132   6.099  1.00 45.72           O  
ATOM   3862  CB  VAL F  50       2.199  -7.669   8.851  1.00 51.44           C  
ATOM   3863  CG1 VAL F  50       3.409  -8.230   9.487  1.00 47.55           C  
ATOM   3864  CG2 VAL F  50       2.105  -6.145   9.068  1.00 53.35           C  
ATOM   3865  N   SER F  51       4.481  -7.712   6.529  1.00 47.35           N  
ATOM   3866  CA  SER F  51       5.543  -7.017   5.793  1.00 48.61           C  
ATOM   3867  C   SER F  51       5.228  -6.911   4.296  1.00 47.11           C  
ATOM   3868  O   SER F  51       5.435  -5.854   3.695  1.00 48.43           O  
ATOM   3869  CB  SER F  51       6.918  -7.696   5.990  1.00 51.08           C  
ATOM   3870  OG  SER F  51       6.895  -9.053   5.565  1.00 53.25           O  
ATOM   3871  N   GLU F  52       4.743  -8.003   3.702  1.00 46.55           N  
ATOM   3872  CA  GLU F  52       4.340  -8.003   2.297  1.00 48.50           C  
ATOM   3873  C   GLU F  52       3.204  -7.035   2.103  1.00 46.28           C  
ATOM   3874  O   GLU F  52       3.259  -6.198   1.204  1.00 47.79           O  
ATOM   3875  CB  GLU F  52       3.893  -9.399   1.819  1.00 51.58           C  
ATOM   3876  CG  GLU F  52       4.986 -10.481   1.892  1.00 55.55           C  
ATOM   3877  CD  GLU F  52       6.267 -10.121   1.138  1.00 58.53           C  
ATOM   3878  OE1 GLU F  52       7.346 -10.673   1.474  1.00 61.55           O  
ATOM   3879  OE2 GLU F  52       6.208  -9.288   0.206  1.00 62.81           O  
ATOM   3880  N   VAL F  53       2.173  -7.134   2.944  1.00 44.55           N  
ATOM   3881  CA  VAL F  53       1.023  -6.235   2.820  1.00 44.36           C  
ATOM   3882  C   VAL F  53       1.474  -4.774   2.961  1.00 45.08           C  
ATOM   3883  O   VAL F  53       0.998  -3.920   2.245  1.00 43.76           O  
ATOM   3884  CB  VAL F  53      -0.101  -6.574   3.824  1.00 45.32           C  
ATOM   3885  CG1 VAL F  53      -1.064  -5.410   3.964  1.00 42.56           C  
ATOM   3886  CG2 VAL F  53      -0.836  -7.865   3.402  1.00 43.47           C  
ATOM   3887  N   GLN F  54       2.419  -4.489   3.847  1.00 43.24           N  
ATOM   3888  CA  GLN F  54       2.899  -3.107   4.025  1.00 46.44           C  
ATOM   3889  C   GLN F  54       3.621  -2.597   2.757  1.00 48.90           C  
ATOM   3890  O   GLN F  54       3.537  -1.404   2.395  1.00 47.37           O  
ATOM   3891  CB  GLN F  54       3.825  -3.021   5.254  1.00 51.22           C  
ATOM   3892  CG  GLN F  54       4.428  -1.637   5.522  1.00 53.48           C  
ATOM   3893  CD  GLN F  54       3.377  -0.548   5.699  1.00 57.04           C  
ATOM   3894  OE1 GLN F  54       2.969  -0.235   6.835  1.00 57.79           O  
ATOM   3895  NE2 GLN F  54       2.924   0.043   4.575  1.00 54.85           N  
ATOM   3896  N   ALA F  55       4.343  -3.505   2.101  1.00 47.19           N  
ATOM   3897  CA  ALA F  55       5.069  -3.173   0.876  1.00 46.09           C  
ATOM   3898  C   ALA F  55       4.062  -2.917  -0.236  1.00 47.21           C  
ATOM   3899  O   ALA F  55       4.185  -1.960  -0.996  1.00 47.73           O  
ATOM   3900  CB  ALA F  55       6.023  -4.316   0.509  1.00 46.94           C  
ATOM   3901  N   SER F  56       3.031  -3.761  -0.285  1.00 48.07           N  
ATOM   3902  CA  SER F  56       1.974  -3.646  -1.293  0.50 45.53           C  
ATOM   3904  C   SER F  56       1.193  -2.332  -1.203  1.00 45.40           C  
ATOM   3905  O   SER F  56       0.942  -1.684  -2.216  1.00 45.34           O  
ATOM   3906  CB  SER F  56       1.010  -4.832  -1.197  0.50 44.15           C  
ATOM   3908  OG  SER F  56       1.599  -5.990  -1.754  0.50 44.93           O  
ATOM   3910  N   VAL F  57       0.796  -1.939  -0.000  1.00 45.59           N  
ATOM   3911  CA  VAL F  57       0.022  -0.707   0.181  1.00 45.62           C  
ATOM   3912  C   VAL F  57       0.835   0.563  -0.150  1.00 44.40           C  
ATOM   3913  O   VAL F  57       0.360   1.412  -0.856  1.00 42.52           O  
ATOM   3914  CB  VAL F  57      -0.577  -0.636   1.606  1.00 44.96           C  
ATOM   3915  CG1 VAL F  57      -1.167   0.731   1.881  1.00 46.88           C  
ATOM   3916  CG2 VAL F  57      -1.601  -1.724   1.793  1.00 42.10           C  
ATOM   3917  N   THR F  58       2.070   0.670   0.322  1.00 46.82           N  
ATOM   3918  CA  THR F  58       2.910   1.839  -0.005  1.00 49.66           C  
ATOM   3919  C   THR F  58       3.157   2.017  -1.518  1.00 48.81           C  
ATOM   3920  O   THR F  58       3.208   3.157  -2.011  1.00 47.42           O  
ATOM   3921  CB  THR F  58       4.301   1.795   0.726  1.00 51.78           C  
ATOM   3922  OG1 THR F  58       5.032   0.647   0.294  1.00 56.90           O  
ATOM   3923  CG2 THR F  58       4.124   1.736   2.237  1.00 47.52           C  
ATOM   3924  N   ALA F  59       3.332   0.908  -2.245  1.00 47.47           N  
ATOM   3925  CA  ALA F  59       3.491   0.966  -3.707  1.00 46.94           C  
ATOM   3926  C   ALA F  59       2.185   1.379  -4.395  1.00 50.88           C  
ATOM   3927  O   ALA F  59       2.214   2.159  -5.360  1.00 49.85           O  
ATOM   3928  CB  ALA F  59       3.982  -0.362  -4.268  1.00 47.89           C  
ATOM   3929  N   GLY F  60       1.052   0.875  -3.896  1.00 49.78           N  
ATOM   3930  CA  GLY F  60      -0.258   1.294  -4.378  1.00 49.58           C  
ATOM   3931  C   GLY F  60      -0.443   2.791  -4.249  1.00 49.33           C  
ATOM   3932  O   GLY F  60      -0.767   3.461  -5.215  1.00 49.78           O  
ATOM   3933  N   ILE F  61      -0.210   3.333  -3.066  1.00 50.88           N  
ATOM   3934  CA  ILE F  61      -0.388   4.770  -2.859  1.00 52.83           C  
ATOM   3935  C   ILE F  61       0.496   5.566  -3.803  1.00 52.34           C  
ATOM   3936  O   ILE F  61       0.062   6.585  -4.332  1.00 50.39           O  
ATOM   3937  CB  ILE F  61      -0.095   5.194  -1.412  1.00 54.91           C  
ATOM   3938  CG1 ILE F  61      -1.127   4.597  -0.457  1.00 55.19           C  
ATOM   3939  CG2 ILE F  61      -0.150   6.721  -1.289  1.00 55.45           C  
ATOM   3940  CD1 ILE F  61      -0.576   4.400   0.953  1.00 56.07           C  
ATOM   3941  N   GLU F  62       1.722   5.081  -4.034  1.00 52.97           N  
ATOM   3942  CA  GLU F  62       2.681   5.786  -4.890  1.00 53.85           C  
ATOM   3943  C   GLU F  62       2.330   5.699  -6.381  1.00 53.50           C  
ATOM   3944  O   GLU F  62       2.411   6.692  -7.094  1.00 52.46           O  
ATOM   3945  CB  GLU F  62       4.123   5.291  -4.636  1.00 58.04           C  
ATOM   3946  CG  GLU F  62       5.150   6.424  -4.435  1.00 61.28           C  
ATOM   3947  CD  GLU F  62       6.461   5.978  -3.745  1.00 66.80           C  
ATOM   3948  OE1 GLU F  62       7.553   6.288  -4.289  1.00 70.77           O  
ATOM   3949  OE2 GLU F  62       6.419   5.345  -2.650  1.00 69.42           O  
ATOM   3950  N   ASN F  63       1.934   4.523  -6.855  1.00 52.63           N  
ATOM   3951  CA  ASN F  63       1.619   4.363  -8.271  1.00 51.76           C  
ATOM   3952  C   ASN F  63       0.324   5.044  -8.717  1.00 51.72           C  
ATOM   3953  O   ASN F  63       0.192   5.397  -9.886  1.00 49.94           O  
ATOM   3954  CB  ASN F  63       1.580   2.892  -8.654  1.00 52.67           C  
ATOM   3955  CG  ASN F  63       2.938   2.266  -8.625  1.00 55.76           C  
ATOM   3956  OD1 ASN F  63       3.842   2.764  -7.957  1.00 54.37           O  
ATOM   3957  ND2 ASN F  63       3.098   1.158  -9.342  1.00 59.64           N  
ATOM   3958  N   ILE F  64      -0.626   5.236  -7.804  1.00 51.35           N  
ATOM   3959  CA  ILE F  64      -1.884   5.916  -8.152  1.00 55.19           C  
ATOM   3960  C   ILE F  64      -1.623   7.321  -8.702  1.00 56.20           C  
ATOM   3961  O   ILE F  64      -2.445   7.913  -9.406  1.00 54.73           O  
ATOM   3962  CB  ILE F  64      -2.837   5.961  -6.946  1.00 54.84           C  
ATOM   3963  CG1 ILE F  64      -3.579   4.630  -6.852  1.00 55.14           C  
ATOM   3964  CG2 ILE F  64      -3.834   7.095  -7.076  1.00 55.85           C  
ATOM   3965  CD1 ILE F  64      -4.175   4.342  -5.467  1.00 56.29           C  
ATOM   3966  N   ARG F  65      -0.432   7.822  -8.427  1.00 58.04           N  
ATOM   3967  CA  ARG F  65      -0.038   9.161  -8.842  1.00 60.00           C  
ATOM   3968  C   ARG F  65       0.283   9.312 -10.314  1.00 58.80           C  
ATOM   3969  O   ARG F  65       0.469  10.435 -10.800  1.00 57.54           O  
ATOM   3970  CB  ARG F  65       1.180   9.549  -8.067  1.00 63.54           C  
ATOM   3971  CG  ARG F  65       0.988   9.351  -6.595  1.00 67.72           C  
ATOM   3972  CD  ARG F  65       2.143   9.969  -5.963  1.00 70.89           C  
ATOM   3973  NE  ARG F  65       1.797  10.804  -4.833  1.00 75.25           N  
ATOM   3974  CZ  ARG F  65       2.434  11.939  -4.580  1.00 79.28           C  
ATOM   3975  NH1 ARG F  65       3.424  12.346  -5.383  1.00 80.01           N  
ATOM   3976  NH2 ARG F  65       2.086  12.675  -3.541  1.00 80.78           N  
ATOM   3977  N   ARG F  66       0.345   8.193 -11.023  1.00 56.42           N  
ATOM   3978  CA  ARG F  66       0.457   8.235 -12.463  1.00 56.10           C  
ATOM   3979  C   ARG F  66      -0.856   7.837 -13.139  1.00 55.65           C  
ATOM   3980  O   ARG F  66      -0.871   7.449 -14.301  1.00 53.99           O  
ATOM   3981  CB  ARG F  66       1.609   7.344 -12.911  1.00 61.86           C  
ATOM   3982  CG  ARG F  66       1.571   5.984 -12.304  1.00 64.68           C  
ATOM   3983  CD  ARG F  66       2.757   5.146 -12.680  1.00 66.11           C  
ATOM   3984  NE  ARG F  66       2.398   3.729 -12.646  1.00 69.04           N  
ATOM   3985  CZ  ARG F  66       3.264   2.721 -12.551  1.00 72.48           C  
ATOM   3986  NH1 ARG F  66       4.574   2.944 -12.467  1.00 74.28           N  
ATOM   3987  NH2 ARG F  66       2.809   1.474 -12.534  1.00 74.15           N  
ATOM   3988  N   VAL F  67      -1.962   7.924 -12.409  1.00 53.71           N  
ATOM   3989  CA  VAL F  67      -3.274   7.815 -13.030  1.00 51.05           C  
ATOM   3990  C   VAL F  67      -3.712   9.242 -13.282  1.00 51.99           C  
ATOM   3991  O   VAL F  67      -3.712  10.067 -12.361  1.00 53.74           O  
ATOM   3992  CB  VAL F  67      -4.300   7.073 -12.140  1.00 50.07           C  
ATOM   3993  CG1 VAL F  67      -5.694   7.124 -12.769  1.00 47.81           C  
ATOM   3994  CG2 VAL F  67      -3.853   5.614 -11.893  1.00 47.37           C  
ATOM   3995  N   ASN F  68      -4.070   9.548 -14.523  1.00 51.93           N  
ATOM   3996  CA  ASN F  68      -4.669  10.840 -14.816  1.00 53.74           C  
ATOM   3997  C   ASN F  68      -6.028  10.919 -14.147  1.00 51.17           C  
ATOM   3998  O   ASN F  68      -6.887  10.149 -14.465  1.00 50.14           O  
ATOM   3999  CB  ASN F  68      -4.858  11.038 -16.320  1.00 54.01           C  
ATOM   4000  CG  ASN F  68      -3.563  11.144 -17.064  1.00 57.02           C  
ATOM   4001  OD1 ASN F  68      -2.479  11.223 -16.474  1.00 59.80           O  
ATOM   4002  ND2 ASN F  68      -3.660  11.136 -18.389  1.00 59.85           N  
ATOM   4003  N   GLY F  69      -6.196  11.866 -13.230  1.00 51.85           N  
ATOM   4004  CA  GLY F  69      -7.425  12.028 -12.476  1.00 53.97           C  
ATOM   4005  C   GLY F  69      -7.523  11.130 -11.255  1.00 53.99           C  
ATOM   4006  O   GLY F  69      -8.542  11.091 -10.599  1.00 56.14           O  
ATOM   4007  N   GLY F  70      -6.445  10.435 -10.929  1.00 54.71           N  
ATOM   4008  CA  GLY F  70      -6.456   9.534  -9.790  1.00 55.99           C  
ATOM   4009  C   GLY F  70      -6.360  10.244  -8.444  1.00 57.14           C  
ATOM   4010  O   GLY F  70      -5.656  11.262  -8.291  1.00 57.01           O  
ATOM   4011  N   GLU F  71      -7.039   9.679  -7.449  1.00 56.70           N  
ATOM   4012  CA  GLU F  71      -6.936  10.173  -6.088  1.00 55.15           C  
ATOM   4013  C   GLU F  71      -7.164   9.063  -5.070  1.00 53.56           C  
ATOM   4014  O   GLU F  71      -8.092   8.261  -5.203  1.00 51.99           O  
ATOM   4015  CB  GLU F  71      -7.944  11.280  -5.900  1.00 58.48           C  
ATOM   4016  CG  GLU F  71      -7.945  11.923  -4.527  1.00 61.03           C  
ATOM   4017  CD  GLU F  71      -9.079  12.919  -4.376  1.00 62.99           C  
ATOM   4018  OE1 GLU F  71      -9.632  13.355  -5.413  1.00 65.67           O  
ATOM   4019  OE2 GLU F  71      -9.424  13.258  -3.221  1.00 67.30           O  
ATOM   4020  N   VAL F  72      -6.293   9.022  -4.065  1.00 52.27           N  
ATOM   4021  CA  VAL F  72      -6.450   8.143  -2.920  1.00 52.93           C  
ATOM   4022  C   VAL F  72      -7.253   8.902  -1.871  1.00 53.70           C  
ATOM   4023  O   VAL F  72      -6.996  10.078  -1.628  1.00 56.48           O  
ATOM   4024  CB  VAL F  72      -5.083   7.751  -2.333  1.00 52.02           C  
ATOM   4025  CG1 VAL F  72      -5.256   6.972  -1.056  1.00 49.67           C  
ATOM   4026  CG2 VAL F  72      -4.283   6.967  -3.351  1.00 51.41           C  
ATOM   4027  N   LEU F  73      -8.227   8.236  -1.259  1.00 52.22           N  
ATOM   4028  CA  LEU F  73      -9.049   8.865  -0.219  1.00 50.14           C  
ATOM   4029  C   LEU F  73      -8.659   8.386   1.163  1.00 51.26           C  
ATOM   4030  O   LEU F  73      -8.635   9.167   2.109  1.00 51.38           O  
ATOM   4031  CB  LEU F  73     -10.521   8.563  -0.447  1.00 49.20           C  
ATOM   4032  CG  LEU F  73     -11.143   9.176  -1.688  1.00 51.10           C  
ATOM   4033  CD1 LEU F  73     -12.527   8.601  -1.909  1.00 49.34           C  
ATOM   4034  CD2 LEU F  73     -11.184  10.712  -1.572  1.00 50.91           C  
ATOM   4035  N   SER F  74      -8.404   7.086   1.282  1.00 50.93           N  
ATOM   4036  CA  SER F  74      -7.928   6.511   2.523  1.00 49.84           C  
ATOM   4037  C   SER F  74      -7.183   5.206   2.271  1.00 48.54           C  
ATOM   4038  O   SER F  74      -7.180   4.660   1.167  1.00 45.63           O  
ATOM   4039  CB  SER F  74      -9.053   6.366   3.579  1.00 53.76           C  
ATOM   4040  OG  SER F  74     -10.099   5.461   3.238  1.00 56.54           O  
ATOM   4041  N   ASN F  75      -6.496   4.739   3.303  1.00 49.15           N  
ATOM   4042  CA  ASN F  75      -5.790   3.484   3.248  1.00 46.71           C  
ATOM   4043  C   ASN F  75      -5.458   3.024   4.665  1.00 47.27           C  
ATOM   4044  O   ASN F  75      -5.440   3.843   5.592  1.00 44.55           O  
ATOM   4045  CB  ASN F  75      -4.524   3.629   2.412  1.00 48.53           C  
ATOM   4046  CG  ASN F  75      -3.560   4.677   2.976  1.00 49.15           C  
ATOM   4047  OD1 ASN F  75      -3.669   5.876   2.690  1.00 52.19           O  
ATOM   4048  ND2 ASN F  75      -2.606   4.228   3.743  1.00 44.95           N  
ATOM   4049  N   HIS F  76      -5.198   1.719   4.809  1.00 44.73           N  
ATOM   4050  CA  HIS F  76      -5.038   1.097   6.086  1.00 43.53           C  
ATOM   4051  C   HIS F  76      -4.586  -0.357   5.969  1.00 43.28           C  
ATOM   4052  O   HIS F  76      -4.857  -1.026   4.977  1.00 42.77           O  
ATOM   4053  CB  HIS F  76      -6.350   1.152   6.881  1.00 45.43           C  
ATOM   4054  CG  HIS F  76      -6.169   0.891   8.341  1.00 46.98           C  
ATOM   4055  ND1 HIS F  76      -5.311   1.634   9.123  1.00 49.38           N  
ATOM   4056  CD2 HIS F  76      -6.713  -0.045   9.156  1.00 49.06           C  
ATOM   4057  CE1 HIS F  76      -5.331   1.164  10.357  1.00 50.94           C  
ATOM   4058  NE2 HIS F  76      -6.177   0.147  10.405  1.00 50.02           N  
ATOM   4059  N   ILE F  77      -3.861  -0.810   6.994  1.00 42.95           N  
ATOM   4060  CA  ILE F  77      -3.416  -2.174   7.133  1.00 40.01           C  
ATOM   4061  C   ILE F  77      -3.779  -2.636   8.536  1.00 42.88           C  
ATOM   4062  O   ILE F  77      -3.616  -1.882   9.484  1.00 42.05           O  
ATOM   4063  CB  ILE F  77      -1.885  -2.282   6.987  1.00 44.06           C  
ATOM   4064  CG1 ILE F  77      -1.459  -1.951   5.573  1.00 44.95           C  
ATOM   4065  CG2 ILE F  77      -1.414  -3.677   7.358  1.00 44.54           C  
ATOM   4066  CD1 ILE F  77       0.006  -1.997   5.397  1.00 49.21           C  
ATOM   4067  N   ILE F  78      -4.273  -3.870   8.664  1.00 43.29           N  
ATOM   4068  CA  ILE F  78      -4.443  -4.508   9.966  1.00 44.11           C  
ATOM   4069  C   ILE F  78      -3.618  -5.789   9.963  1.00 42.77           C  
ATOM   4070  O   ILE F  78      -3.867  -6.693   9.159  1.00 45.22           O  
ATOM   4071  CB  ILE F  78      -5.938  -4.781  10.293  1.00 45.35           C  
ATOM   4072  CG1 ILE F  78      -6.715  -3.459  10.355  1.00 46.05           C  
ATOM   4073  CG2 ILE F  78      -6.082  -5.500  11.664  1.00 50.19           C  
ATOM   4074  CD1 ILE F  78      -8.205  -3.634  10.140  1.00 42.46           C  
ATOM   4075  N   ALA F  79      -2.611  -5.861  10.842  1.00 42.97           N  
ATOM   4076  CA  ALA F  79      -1.693  -6.984  10.844  1.00 38.41           C  
ATOM   4077  C   ALA F  79      -2.423  -8.294  11.157  1.00 39.54           C  
ATOM   4078  O   ALA F  79      -2.160  -9.326  10.552  1.00 38.88           O  
ATOM   4079  CB  ALA F  79      -0.532  -6.743  11.848  1.00 41.81           C  
ATOM   4080  N   ARG F  80      -3.322  -8.271  12.124  1.00 40.27           N  
ATOM   4081  CA  ARG F  80      -3.941  -9.515  12.579  1.00 42.55           C  
ATOM   4082  C   ARG F  80      -5.389  -9.239  12.847  1.00 44.05           C  
ATOM   4083  O   ARG F  80      -5.757  -9.020  13.992  1.00 41.73           O  
ATOM   4084  CB  ARG F  80      -3.253 -10.016  13.856  1.00 45.32           C  
ATOM   4085  CG  ARG F  80      -1.852 -10.533  13.627  1.00 47.67           C  
ATOM   4086  CD  ARG F  80      -1.028 -10.550  14.922  1.00 50.71           C  
ATOM   4087  NE  ARG F  80      -0.691  -9.197  15.361  1.00 53.68           N  
ATOM   4088  CZ  ARG F  80       0.289  -8.446  14.853  1.00 54.98           C  
ATOM   4089  NH1 ARG F  80       1.075  -8.900  13.872  1.00 52.91           N  
ATOM   4090  NH2 ARG F  80       0.487  -7.220  15.343  1.00 56.76           N  
ATOM   4091  N   PRO F  81      -6.212  -9.217  11.783  1.00 44.02           N  
ATOM   4092  CA  PRO F  81      -7.628  -8.979  11.981  1.00 48.08           C  
ATOM   4093  C   PRO F  81      -8.315 -10.153  12.689  1.00 50.47           C  
ATOM   4094  O   PRO F  81      -7.955 -11.318  12.492  1.00 49.17           O  
ATOM   4095  CB  PRO F  81      -8.164  -8.819  10.548  1.00 48.17           C  
ATOM   4096  CG  PRO F  81      -7.256  -9.610   9.716  1.00 48.30           C  
ATOM   4097  CD  PRO F  81      -5.898  -9.490  10.373  1.00 46.14           C  
ATOM   4098  N   HIS F  82      -9.312  -9.826  13.500  1.00 50.54           N  
ATOM   4099  CA  HIS F  82     -10.010 -10.811  14.300  1.00 49.33           C  
ATOM   4100  C   HIS F  82     -10.847 -11.701  13.379  1.00 50.21           C  
ATOM   4101  O   HIS F  82     -11.389 -11.251  12.373  1.00 48.81           O  
ATOM   4102  CB  HIS F  82     -10.859 -10.058  15.311  1.00 52.24           C  
ATOM   4103  CG  HIS F  82     -11.479 -10.917  16.366  1.00 52.90           C  
ATOM   4104  ND1 HIS F  82     -12.513 -11.784  16.103  1.00 52.54           N  
ATOM   4105  CD2 HIS F  82     -11.252 -10.988  17.700  1.00 54.54           C  
ATOM   4106  CE1 HIS F  82     -12.882 -12.377  17.226  1.00 53.33           C  
ATOM   4107  NE2 HIS F  82     -12.127 -11.916  18.208  1.00 53.75           N  
ATOM   4108  N   GLU F  83     -10.968 -12.970  13.722  1.00 51.48           N  
ATOM   4109  CA  GLU F  83     -11.653 -13.944  12.841  1.00 54.55           C  
ATOM   4110  C   GLU F  83     -13.128 -13.620  12.512  1.00 53.68           C  
ATOM   4111  O   GLU F  83     -13.628 -13.990  11.459  1.00 56.26           O  
ATOM   4112  CB  GLU F  83     -11.543 -15.334  13.457  1.00 57.30           C  
ATOM   4113  CG  GLU F  83     -10.081 -15.802  13.643  1.00 61.82           C  
ATOM   4114  CD  GLU F  83      -9.398 -15.356  14.965  1.00 65.93           C  
ATOM   4115  OE1 GLU F  83      -9.961 -14.533  15.732  1.00 66.71           O  
ATOM   4116  OE2 GLU F  83      -8.263 -15.844  15.231  1.00 70.33           O  
ATOM   4117  N   ASN F  84     -13.811 -12.943  13.431  1.00 52.61           N  
ATOM   4118  CA  ASN F  84     -15.200 -12.451  13.266  1.00 51.43           C  
ATOM   4119  C   ASN F  84     -15.350 -11.579  12.018  1.00 51.86           C  
ATOM   4120  O   ASN F  84     -16.373 -11.626  11.330  1.00 49.36           O  
ATOM   4121  CB  ASN F  84     -15.565 -11.628  14.522  1.00 49.41           C  
ATOM   4122  CG  ASN F  84     -17.080 -11.450  14.751  1.00 49.01           C  
ATOM   4123  OD1 ASN F  84     -17.489 -11.228  15.886  1.00 47.57           O  
ATOM   4124  ND2 ASN F  84     -17.888 -11.525  13.709  1.00 49.90           N  
ATOM   4125  N   LEU F  85     -14.338 -10.758  11.746  1.00 51.52           N  
ATOM   4126  CA  LEU F  85     -14.339  -9.896  10.556  1.00 51.92           C  
ATOM   4127  C   LEU F  85     -14.488 -10.680   9.250  1.00 52.30           C  
ATOM   4128  O   LEU F  85     -15.144 -10.226   8.325  1.00 54.38           O  
ATOM   4129  CB  LEU F  85     -13.086  -9.015  10.521  1.00 51.06           C  
ATOM   4130  CG  LEU F  85     -13.213  -7.652  11.214  1.00 50.07           C  
ATOM   4131  CD1 LEU F  85     -13.475  -7.787  12.691  1.00 47.65           C  
ATOM   4132  CD2 LEU F  85     -11.954  -6.830  10.934  1.00 50.01           C  
ATOM   4133  N   GLU F  86     -13.942 -11.882   9.207  1.00 54.63           N  
ATOM   4134  CA  GLU F  86     -13.950 -12.723   7.994  1.00 59.16           C  
ATOM   4135  C   GLU F  86     -15.360 -13.104   7.552  1.00 59.00           C  
ATOM   4136  O   GLU F  86     -15.620 -13.242   6.366  1.00 62.30           O  
ATOM   4137  CB  GLU F  86     -13.168 -14.025   8.241  1.00 61.79           C  
ATOM   4138  CG  GLU F  86     -11.760 -13.857   8.804  1.00 63.35           C  
ATOM   4139  CD  GLU F  86     -10.698 -13.682   7.743  1.00 66.07           C  
ATOM   4140  OE1 GLU F  86     -11.000 -13.879   6.545  1.00 68.09           O  
ATOM   4141  OE2 GLU F  86      -9.552 -13.356   8.124  1.00 67.68           O  
ATOM   4142  N   TYR F  87     -16.263 -13.251   8.518  1.00 60.77           N  
ATOM   4143  CA  TYR F  87     -17.652 -13.662   8.276  1.00 60.67           C  
ATOM   4144  C   TYR F  87     -18.642 -12.513   8.015  1.00 61.00           C  
ATOM   4145  O   TYR F  87     -19.793 -12.761   7.668  1.00 62.00           O  
ATOM   4146  CB  TYR F  87     -18.142 -14.487   9.474  1.00 63.86           C  
ATOM   4147  CG  TYR F  87     -17.434 -15.808   9.578  1.00 67.80           C  
ATOM   4148  CD1 TYR F  87     -17.908 -16.921   8.892  1.00 70.74           C  
ATOM   4149  CD2 TYR F  87     -16.270 -15.941  10.325  1.00 69.30           C  
ATOM   4150  CE1 TYR F  87     -17.251 -18.146   8.961  1.00 72.26           C  
ATOM   4151  CE2 TYR F  87     -15.602 -17.161  10.402  1.00 72.67           C  
ATOM   4152  CZ  TYR F  87     -16.101 -18.263   9.715  1.00 73.44           C  
ATOM   4153  OH  TYR F  87     -15.454 -19.481   9.787  1.00 74.72           O  
ATOM   4154  N   VAL F  88     -18.219 -11.266   8.197  1.00 59.98           N  
ATOM   4155  CA  VAL F  88     -19.130 -10.148   8.047  1.00 58.25           C  
ATOM   4156  C   VAL F  88     -18.691  -9.147   6.980  1.00 56.89           C  
ATOM   4157  O   VAL F  88     -19.528  -8.652   6.227  1.00 55.81           O  
ATOM   4158  CB  VAL F  88     -19.345  -9.428   9.400  1.00 58.21           C  
ATOM   4159  CG1 VAL F  88     -20.116  -8.143   9.210  1.00 54.94           C  
ATOM   4160  CG2 VAL F  88     -20.074 -10.365  10.375  1.00 56.89           C  
ATOM   4161  N   LEU F  89     -17.391  -8.859   6.923  1.00 55.52           N  
ATOM   4162  CA  LEU F  89     -16.834  -7.937   5.948  1.00 56.61           C  
ATOM   4163  C   LEU F  89     -16.222  -8.682   4.760  1.00 58.62           C  
ATOM   4164  O   LEU F  89     -15.679  -9.772   4.921  1.00 59.06           O  
ATOM   4165  CB  LEU F  89     -15.759  -7.079   6.614  1.00 55.83           C  
ATOM   4166  CG  LEU F  89     -16.262  -6.243   7.784  1.00 56.07           C  
ATOM   4167  CD1 LEU F  89     -15.102  -5.623   8.570  1.00 56.81           C  
ATOM   4168  CD2 LEU F  89     -17.183  -5.177   7.300  1.00 54.12           C  
ATOM   4169  N   PRO F  90     -16.278  -8.078   3.563  1.00 60.85           N  
ATOM   4170  CA  PRO F  90     -15.712  -8.684   2.360  1.00 61.67           C  
ATOM   4171  C   PRO F  90     -14.186  -8.595   2.282  1.00 63.09           C  
ATOM   4172  O   PRO F  90     -13.643  -8.064   1.315  1.00 64.37           O  
ATOM   4173  CB  PRO F  90     -16.390  -7.902   1.231  1.00 62.25           C  
ATOM   4174  CG  PRO F  90     -16.700  -6.578   1.816  1.00 61.99           C  
ATOM   4175  CD  PRO F  90     -16.955  -6.797   3.274  1.00 61.78           C  
ATOM   4176  N   ILE F  91     -13.501  -9.151   3.281  1.00 62.57           N  
ATOM   4177  CA  ILE F  91     -12.044  -9.175   3.306  1.00 62.46           C  
ATOM   4178  C   ILE F  91     -11.474 -10.582   3.153  1.00 65.86           C  
ATOM   4179  O   ILE F  91     -10.275 -10.762   3.280  1.00 61.93           O  
ATOM   4180  CB  ILE F  91     -11.463  -8.537   4.616  1.00 61.35           C  
ATOM   4181  CG1 ILE F  91     -11.900  -9.321   5.856  1.00 60.04           C  
ATOM   4182  CG2 ILE F  91     -11.860  -7.070   4.735  1.00 60.08           C  
ATOM   4183  CD1 ILE F  91     -11.359  -8.726   7.148  1.00 60.30           C  
ATOM   4184  N   ARG F  92     -12.304 -11.591   2.900  1.00 73.59           N  
ATOM   4185  CA  ARG F  92     -11.786 -12.967   2.891  1.00 80.17           C  
ATOM   4186  C   ARG F  92     -11.615 -13.491   1.468  1.00 83.87           C  
ATOM   4187  O   ARG F  92     -11.898 -12.777   0.504  1.00 82.20           O  
ATOM   4188  CB  ARG F  92     -12.663 -13.900   3.746  1.00 82.07           C  
ATOM   4189  CG  ARG F  92     -13.819 -14.609   3.018  1.00 84.64           C  
ATOM   4190  CD  ARG F  92     -14.605 -15.544   3.953  1.00 86.90           C  
ATOM   4191  NE  ARG F  92     -13.749 -16.240   4.923  1.00 89.17           N  
ATOM   4192  CZ  ARG F  92     -12.938 -17.268   4.644  1.00 90.67           C  
ATOM   4193  NH1 ARG F  92     -12.849 -17.766   3.407  1.00 90.33           N  
ATOM   4194  NH2 ARG F  92     -12.209 -17.807   5.618  1.00 90.72           N  
ATOM   4195  N   TYR F  93     -11.172 -14.748   1.366  1.00 89.17           N  
ATOM   4196  CA  TYR F  93     -10.905 -15.431   0.086  1.00 93.09           C  
ATOM   4197  C   TYR F  93     -12.184 -15.953  -0.612  1.00 95.44           C  
ATOM   4198  O   TYR F  93     -12.126 -16.909  -1.390  1.00 95.62           O  
ATOM   4199  CB  TYR F  93      -9.919 -16.599   0.316  1.00 93.93           C  
ATOM   4200  CG  TYR F  93      -8.513 -16.162   0.690  1.00 95.46           C  
ATOM   4201  CD1 TYR F  93      -8.232 -15.648   1.960  1.00 96.70           C  
ATOM   4202  CD2 TYR F  93      -7.461 -16.265  -0.223  1.00 95.23           C  
ATOM   4203  CE1 TYR F  93      -6.943 -15.238   2.304  1.00 97.33           C  
ATOM   4204  CE2 TYR F  93      -6.168 -15.864   0.115  1.00 95.65           C  
ATOM   4205  CZ  TYR F  93      -5.917 -15.349   1.379  1.00 96.51           C  
ATOM   4206  OH  TYR F  93      -4.647 -14.942   1.727  1.00 96.76           O  
ATOM   4207  N   THR F  94     -13.322 -15.306  -0.351  1.00 98.05           N  
ATOM   4208  CA  THR F  94     -14.634 -15.724  -0.875  1.00 99.57           C  
ATOM   4209  C   THR F  94     -14.882 -17.235  -0.691  1.00100.28           C  
ATOM   4210  O   THR F  94     -16.015 -17.719  -0.794  1.00100.28           O  
ATOM   4211  CB  THR F  94     -14.796 -15.334  -2.372  1.00 99.52           C  
ATOM   4212  OG1 THR F  94     -13.832 -14.331  -2.721  1.00 99.01           O  
ATOM   4213  CG2 THR F  94     -16.209 -14.813  -2.652  1.00 98.77           C  
TER    4214      THR F  94                                                      
END
MOLECULE T0437.pdb
ATOM    365  N   ASP    24      -1.217  -3.430  12.771  1.00 32.15           N  
ATOM    366  CA  ASP    24      -2.558  -3.784  13.227  1.00 11.24           C  
ATOM    367  C   ASP    24      -3.077  -4.985  12.447  1.00  3.52           C  
ATOM    368  O   ASP    24      -3.558  -5.955  13.031  1.00 72.30           O  
ATOM    369  CB  ASP    24      -3.550  -2.622  13.081  1.00 55.51           C  
ATOM    370  CG  ASP    24      -4.808  -2.840  13.907  1.00 50.34           C  
ATOM    371  OD1 ASP    24      -4.721  -2.781  15.153  1.00 45.42           O  
ATOM    372  OD2 ASP    24      -5.894  -3.051  13.323  1.00 64.32           O  
ATOM    373  H   ASP    24      -0.799  -3.973  12.068  1.00 54.01           H  
ATOM    374  HA  ASP    24      -2.484  -4.056  14.271  1.00 33.12           H  
ATOM    375  HB2 ASP    24      -3.078  -1.707  13.409  1.00 36.92           H  
ATOM    376  HB3 ASP    24      -3.834  -2.526  12.043  1.00 36.92           H  
ATOM    377  N   ASN    25      -2.962  -4.924  11.121  1.00 30.54           N  
ATOM    378  CA  ASN    25      -3.508  -5.964  10.256  1.00 13.41           C  
ATOM    379  C   ASN    25      -2.460  -6.507   9.295  1.00 63.53           C  
ATOM    380  O   ASN    25      -1.296  -6.099   9.311  1.00 14.31           O  
ATOM    381  CB  ASN    25      -4.679  -5.420   9.426  1.00 24.42           C  
ATOM    382  CG  ASN    25      -5.829  -4.927  10.269  1.00 32.35           C  
ATOM    383  OD1 ASN    25      -6.706  -5.697  10.646  1.00 43.01           O  
ATOM    384  ND2 ASN    25      -5.853  -3.633  10.534  1.00 44.23           N  
ATOM    385  H   ASN    25      -2.501  -4.158  10.709  1.00 41.11           H  
ATOM    386  HA  ASN    25      -3.864  -6.769  10.879  1.00 52.21           H  
ATOM    387  HB2 ASN    25      -4.327  -4.598   8.822  1.00 36.92           H  
ATOM    388  HB3 ASN    25      -5.043  -6.204   8.776  1.00 36.92           H  
ATOM    389 HD21 ASN    25      -5.133  -3.072  10.171  1.00 36.92           H  
ATOM    390 HD22 ASN    25      -6.577  -3.287  11.100  1.00 36.92           H  
ATOM    391  N   CYS    26      -2.899  -7.447   8.473  1.00 31.24           N  
ATOM    392  CA  CYS    26      -2.129  -7.926   7.338  1.00 12.34           C  
ATOM    393  C   CYS    26      -2.935  -7.685   6.063  1.00 73.22           C  
ATOM    394  O   CYS    26      -2.415  -7.757   4.950  1.00 24.23           O  
ATOM    395  CB  CYS    26      -1.796  -9.411   7.499  1.00 72.14           C  
ATOM    396  SG  CYS    26      -3.233 -10.466   7.786  1.00  1.02           S  
ATOM    397  H   CYS    26      -3.780  -7.844   8.643  1.00 23.14           H  
ATOM    398  HA  CYS    26      -1.212  -7.355   7.290  1.00 54.15           H  
ATOM    399  HB2 CYS    26      -1.310  -9.763   6.603  1.00 36.92           H  
ATOM    400  HB3 CYS    26      -1.127  -9.535   8.338  1.00 36.92           H  
ATOM    401  HG  CYS    26      -2.885 -11.712   7.486  1.00 33.31           H  
ATOM    402  N   THR    27      -4.221  -7.404   6.252  1.00  2.42           N  
ATOM    403  CA  THR    27      -5.103  -7.020   5.167  1.00 14.14           C  
ATOM    404  C   THR    27      -5.241  -5.501   5.133  1.00 42.33           C  
ATOM    405  O   THR    27      -5.709  -4.893   6.102  1.00 22.32           O  
ATOM    406  CB  THR    27      -6.496  -7.663   5.341  1.00 43.41           C  
ATOM    407  OG1 THR    27      -6.380  -9.092   5.329  1.00  1.24           O  
ATOM    408  CG2 THR    27      -7.455  -7.221   4.244  1.00  1.25           C  
ATOM    409  H   THR    27      -4.589  -7.460   7.160  1.00 62.31           H  
ATOM    410  HA  THR    27      -4.674  -7.363   4.237  1.00 23.45           H  
ATOM    411  HB  THR    27      -6.899  -7.353   6.294  1.00 23.25           H  
ATOM    412  HG1 THR    27      -6.285  -9.415   6.235  1.00 70.53           H  
ATOM    413 HG21 THR    27      -8.407  -7.714   4.375  1.00 36.92           H  
ATOM    414 HG22 THR    27      -7.044  -7.482   3.280  1.00 36.92           H  
ATOM    415 HG23 THR    27      -7.593  -6.151   4.298  1.00 36.92           H  
ATOM    416  N   SER    28      -4.839  -4.888   4.027  1.00 33.44           N  
ATOM    417  CA  SER    28      -4.883  -3.439   3.911  1.00 41.41           C  
ATOM    418  C   SER    28      -6.138  -3.018   3.169  1.00  3.25           C  
ATOM    419  O   SER    28      -6.628  -3.746   2.308  1.00  4.43           O  
ATOM    420  CB  SER    28      -3.645  -2.908   3.181  1.00 70.44           C  
ATOM    421  OG  SER    28      -3.551  -1.502   3.323  1.00  3.01           O  
ATOM    422  H   SER    28      -4.524  -5.424   3.263  1.00 11.31           H  
ATOM    423  HA  SER    28      -4.911  -3.026   4.909  1.00 33.32           H  
ATOM    424  HB2 SER    28      -2.757  -3.363   3.593  1.00 36.92           H  
ATOM    425  HB3 SER    28      -3.718  -3.149   2.130  1.00 36.92           H  
ATOM    426  HG  SER    28      -2.992  -1.130   2.615  1.00  3.41           H  
ATOM    427  N   LYS    29      -6.662  -1.853   3.509  1.00 34.41           N  
ATOM    428  CA  LYS    29      -7.877  -1.356   2.890  1.00 11.21           C  
ATOM    429  C   LYS    29      -7.593  -0.009   2.265  1.00 12.41           C  
ATOM    430  O   LYS    29      -7.319   0.971   2.962  1.00 14.44           O  
ATOM    431  CB  LYS    29      -9.024  -1.202   3.893  1.00 31.01           C  
ATOM    432  CG  LYS    29      -9.044  -2.231   5.007  1.00 24.44           C  
ATOM    433  CD  LYS    29      -8.016  -1.879   6.067  1.00 42.42           C  
ATOM    434  CE  LYS    29      -8.275  -2.586   7.387  1.00 72.54           C  
ATOM    435  NZ  LYS    29      -8.114  -4.060   7.277  1.00 24.34           N  
ATOM    436  H   LYS    29      -6.209  -1.302   4.180  1.00  5.13           H  
ATOM    437  HA  LYS    29      -8.168  -2.052   2.115  1.00 14.03           H  
ATOM    438  HB2 LYS    29      -8.955  -0.226   4.347  1.00 36.92           H  
ATOM    439  HB3 LYS    29      -9.961  -1.269   3.359  1.00 36.92           H  
ATOM    440  HG2 LYS    29     -10.025  -2.248   5.451  1.00 36.92           H  
ATOM    441  HG3 LYS    29      -8.811  -3.204   4.597  1.00 36.92           H  
ATOM    442  HD2 LYS    29      -7.038  -2.166   5.706  1.00 36.92           H  
ATOM    443  HD3 LYS    29      -8.040  -0.811   6.215  1.00 36.92           H  
ATOM    444  HE2 LYS    29      -7.580  -2.212   8.123  1.00 36.92           H  
ATOM    445  HE3 LYS    29      -9.284  -2.365   7.704  1.00 36.92           H  
ATOM    446  HZ1 LYS    29      -7.150  -4.297   6.962  1.00 36.92           H  
ATOM    447  HZ2 LYS    29      -8.798  -4.448   6.588  1.00 36.92           H  
ATOM    448  HZ3 LYS    29      -8.288  -4.508   8.205  1.00 36.92           H  
ATOM    449  N   PHE    30      -7.655   0.034   0.964  1.00 52.14           N  
ATOM    450  CA  PHE    30      -7.342   1.246   0.228  1.00 74.42           C  
ATOM    451  C   PHE    30      -8.617   1.916  -0.259  1.00 75.21           C  
ATOM    452  O   PHE    30      -9.343   1.360  -1.081  1.00  2.21           O  
ATOM    453  CB  PHE    30      -6.425   0.925  -0.957  1.00 63.54           C  
ATOM    454  CG  PHE    30      -6.093   2.118  -1.810  1.00 64.50           C  
ATOM    455  CD1 PHE    30      -5.122   3.024  -1.413  1.00 43.31           C  
ATOM    456  CD2 PHE    30      -6.755   2.335  -3.009  1.00 42.02           C  
ATOM    457  CE1 PHE    30      -4.818   4.122  -2.194  1.00 25.13           C  
ATOM    458  CE2 PHE    30      -6.455   3.432  -3.794  1.00 72.40           C  
ATOM    459  CZ  PHE    30      -5.485   4.326  -3.386  1.00 61.32           C  
ATOM    460  H   PHE    30      -7.942  -0.770   0.485  1.00 44.02           H  
ATOM    461  HA  PHE    30      -6.829   1.918   0.898  1.00 62.01           H  
ATOM    462  HB2 PHE    30      -5.497   0.518  -0.584  1.00 36.92           H  
ATOM    463  HB3 PHE    30      -6.907   0.189  -1.585  1.00 36.92           H  
ATOM    464  HD1 PHE    30      -4.599   2.867  -0.481  1.00 63.41           H  
ATOM    465  HD2 PHE    30      -7.516   1.637  -3.329  1.00  2.43           H  
ATOM    466  HE1 PHE    30      -4.059   4.820  -1.873  1.00 51.40           H  
ATOM    467  HE2 PHE    30      -6.977   3.588  -4.726  1.00  0.03           H  
ATOM    468  HZ  PHE    30      -5.250   5.185  -3.999  1.00 35.04           H  
ATOM    469  N   SER    31      -8.867   3.118   0.237  1.00 74.32           N  
ATOM    470  CA  SER    31     -10.047   3.876  -0.141  1.00 73.15           C  
ATOM    471  C   SER    31      -9.680   5.137  -0.908  1.00 74.03           C  
ATOM    472  O   SER    31      -8.747   5.860  -0.543  1.00  5.31           O  
ATOM    473  CB  SER    31     -10.858   4.239   1.103  1.00  0.34           C  
ATOM    474  OG  SER    31     -10.003   4.439   2.220  1.00 44.25           O  
ATOM    475  H   SER    31      -8.253   3.498   0.892  1.00 63.34           H  
ATOM    476  HA  SER    31     -10.652   3.249  -0.778  1.00 42.22           H  
ATOM    477  HB2 SER    31     -11.401   5.154   0.916  1.00 36.92           H  
ATOM    478  HB3 SER    31     -11.556   3.446   1.328  1.00 36.92           H  
ATOM    479  HG  SER    31     -10.076   3.677   2.815  1.00 62.22           H  
ATOM    480  N   ARG    32     -10.409   5.372  -1.982  1.00 34.33           N  
ATOM    481  CA  ARG    32     -10.290   6.587  -2.767  1.00 13.22           C  
ATOM    482  C   ARG    32     -11.656   6.967  -3.312  1.00 30.12           C  
ATOM    483  O   ARG    32     -12.485   6.098  -3.590  1.00  1.53           O  
ATOM    484  CB  ARG    32      -9.293   6.400  -3.914  1.00 72.21           C  
ATOM    485  CG  ARG    32      -7.900   6.946  -3.627  1.00 15.03           C  
ATOM    486  CD  ARG    32      -7.783   8.424  -3.980  1.00 21.11           C  
ATOM    487  NE  ARG    32      -8.659   9.273  -3.169  1.00 34.31           N  
ATOM    488  CZ  ARG    32      -9.089  10.477  -3.550  1.00 74.52           C  
ATOM    489  NH1 ARG    32      -8.702  10.996  -4.708  1.00 22.20           N  
ATOM    490  NH2 ARG    32      -9.890  11.175  -2.752  1.00 10.25           N  
ATOM    491  H   ARG    32     -11.061   4.688  -2.268  1.00 61.53           H  
ATOM    492  HA  ARG    32      -9.940   7.373  -2.115  1.00 13.20           H  
ATOM    493  HB2 ARG    32      -9.204   5.346  -4.123  1.00 36.92           H  
ATOM    494  HB3 ARG    32      -9.677   6.898  -4.791  1.00 36.92           H  
ATOM    495  HG2 ARG    32      -7.683   6.821  -2.577  1.00 36.92           H  
ATOM    496  HG3 ARG    32      -7.182   6.390  -4.211  1.00 36.92           H  
ATOM    497  HD2 ARG    32      -6.759   8.734  -3.827  1.00 36.92           H  
ATOM    498  HD3 ARG    32      -8.040   8.550  -5.021  1.00 36.92           H  
ATOM    499  HE  ARG    32      -8.933   8.926  -2.287  1.00 22.31           H  
ATOM    500 HH11 ARG    32      -8.075  10.485  -5.314  1.00 36.92           H  
ATOM    501 HH12 ARG    32      -9.017  11.913  -4.987  1.00 36.92           H  
ATOM    502 HH21 ARG    32     -10.166  10.801  -1.861  1.00 36.92           H  
ATOM    503 HH22 ARG    32     -10.226  12.085  -3.037  1.00 36.92           H  
ATOM    504  N   PHE    33     -11.893   8.257  -3.446  1.00 12.54           N  
ATOM    505  CA  PHE    33     -13.175   8.746  -3.916  1.00 11.05           C  
ATOM    506  C   PHE    33     -13.030   9.297  -5.322  1.00 55.33           C  
ATOM    507  O   PHE    33     -12.193  10.165  -5.578  1.00 62.12           O  
ATOM    508  CB  PHE    33     -13.716   9.827  -2.977  1.00  2.45           C  
ATOM    509  CG  PHE    33     -13.665   9.442  -1.522  1.00  1.40           C  
ATOM    510  CD1 PHE    33     -14.492   8.449  -1.023  1.00  3.52           C  
ATOM    511  CD2 PHE    33     -12.783  10.069  -0.656  1.00 73.01           C  
ATOM    512  CE1 PHE    33     -14.440   8.090   0.312  1.00 11.30           C  
ATOM    513  CE2 PHE    33     -12.728   9.714   0.678  1.00 34.42           C  
ATOM    514  CZ  PHE    33     -13.558   8.724   1.163  1.00 42.15           C  
ATOM    515  H   PHE    33     -11.185   8.898  -3.238  1.00 14.11           H  
ATOM    516  HA  PHE    33     -13.864   7.914  -3.934  1.00 32.42           H  
ATOM    517  HB2 PHE    33     -13.137  10.726  -3.104  1.00 36.92           H  
ATOM    518  HB3 PHE    33     -14.747  10.029  -3.231  1.00 36.92           H  
ATOM    519  HD1 PHE    33     -15.183   7.953  -1.687  1.00 41.41           H  
ATOM    520  HD2 PHE    33     -12.132  10.845  -1.031  1.00 72.44           H  
ATOM    521  HE1 PHE    33     -15.091   7.314   0.688  1.00 12.34           H  
ATOM    522  HE2 PHE    33     -12.035  10.211   1.343  1.00 62.42           H  
ATOM    523  HZ  PHE    33     -13.517   8.446   2.206  1.00  5.22           H  
ATOM    524  N   PHE    34     -13.832   8.783  -6.232  1.00 32.11           N  
ATOM    525  CA  PHE    34     -13.750   9.181  -7.627  1.00  1.22           C  
ATOM    526  C   PHE    34     -15.068   9.782  -8.075  1.00 23.44           C  
ATOM    527  O   PHE    34     -16.074   9.649  -7.383  1.00 51.45           O  
ATOM    528  CB  PHE    34     -13.392   7.981  -8.498  1.00 31.22           C  
ATOM    529  CG  PHE    34     -12.063   7.371  -8.150  1.00 51.33           C  
ATOM    530  CD1 PHE    34     -10.884   7.944  -8.604  1.00 14.42           C  
ATOM    531  CD2 PHE    34     -11.993   6.229  -7.369  1.00 64.14           C  
ATOM    532  CE1 PHE    34      -9.662   7.387  -8.285  1.00  2.41           C  
ATOM    533  CE2 PHE    34     -10.772   5.669  -7.048  1.00 51.32           C  
ATOM    534  CZ  PHE    34      -9.606   6.249  -7.506  1.00 32.24           C  
ATOM    535  H   PHE    34     -14.509   8.124  -5.958  1.00  3.15           H  
ATOM    536  HA  PHE    34     -12.975   9.926  -7.719  1.00 13.43           H  
ATOM    537  HB2 PHE    34     -14.152   7.221  -8.382  1.00 36.92           H  
ATOM    538  HB3 PHE    34     -13.356   8.293  -9.532  1.00 36.92           H  
ATOM    539  HD1 PHE    34     -10.927   8.836  -9.212  1.00 23.34           H  
ATOM    540  HD2 PHE    34     -12.904   5.776  -7.008  1.00 55.40           H  
ATOM    541  HE1 PHE    34      -8.750   7.841  -8.645  1.00  4.21           H  
ATOM    542  HE2 PHE    34     -10.728   4.778  -6.438  1.00 43.52           H  
ATOM    543  HZ  PHE    34      -8.651   5.811  -7.258  1.00 60.55           H  
ATOM    544  N   ALA    35     -15.059  10.445  -9.223  1.00 41.43           N  
ATOM    545  CA  ALA    35     -16.262  11.091  -9.739  1.00 35.44           C  
ATOM    546  C   ALA    35     -17.209  10.081 -10.376  1.00 12.23           C  
ATOM    547  O   ALA    35     -18.426  10.269 -10.368  1.00  3.53           O  
ATOM    548  CB  ALA    35     -15.895  12.179 -10.734  1.00 10.24           C  
ATOM    549  H   ALA    35     -14.222  10.509  -9.734  1.00 32.10           H  
ATOM    550  HA  ALA    35     -16.766  11.557  -8.907  1.00 65.13           H  
ATOM    551  HB1 ALA    35     -16.787  12.711 -11.032  1.00 36.92           H  
ATOM    552  HB2 ALA    35     -15.435  11.733 -11.604  1.00 36.92           H  
ATOM    553  HB3 ALA    35     -15.203  12.867 -10.274  1.00 36.92           H  
ATOM    554  N   THR    36     -16.655   9.015 -10.931  1.00 23.34           N  
ATOM    555  CA  THR    36     -17.470   7.980 -11.544  1.00 51.01           C  
ATOM    556  C   THR    36     -17.045   6.607 -11.049  1.00 43.30           C  
ATOM    557  O   THR    36     -15.901   6.418 -10.624  1.00  5.14           O  
ATOM    558  CB  THR    36     -17.358   7.997 -13.082  1.00 13.34           C  
ATOM    559  OG1 THR    36     -15.991   7.818 -13.472  1.00 31.33           O  
ATOM    560  CG2 THR    36     -17.895   9.295 -13.669  1.00 12.13           C  
ATOM    561  H   THR    36     -15.680   8.919 -10.930  1.00 11.05           H  
ATOM    562  HA  THR    36     -18.500   8.153 -11.272  1.00 24.33           H  
ATOM    563  HB  THR    36     -17.942   7.177 -13.475  1.00 62.24           H  
ATOM    564  HG1 THR    36     -15.774   8.439 -14.184  1.00 51.32           H  
ATOM    565 HG21 THR    36     -17.783   9.276 -14.743  1.00 36.92           H  
ATOM    566 HG22 THR    36     -17.341  10.129 -13.264  1.00 36.92           H  
ATOM    567 HG23 THR    36     -18.940   9.401 -13.417  1.00 36.92           H  
ATOM    568  N   ARG    37     -17.964   5.653 -11.105  1.00  3.51           N  
ATOM    569  CA  ARG    37     -17.648   4.269 -10.789  1.00 24.40           C  
ATOM    570  C   ARG    37     -16.613   3.737 -11.780  1.00 72.31           C  
ATOM    571  O   ARG    37     -15.833   2.837 -11.462  1.00 55.35           O  
ATOM    572  CB  ARG    37     -18.924   3.422 -10.804  1.00  2.52           C  
ATOM    573  CG  ARG    37     -18.675   1.925 -10.730  1.00 45.12           C  
ATOM    574  CD  ARG    37     -19.979   1.152 -10.685  1.00 43.11           C  
ATOM    575  NE  ARG    37     -19.758  -0.288 -10.589  1.00 74.04           N  
ATOM    576  CZ  ARG    37     -20.451  -1.088  -9.782  1.00 42.35           C  
ATOM    577  NH1 ARG    37     -21.353  -0.577  -8.950  1.00 25.52           N  
ATOM    578  NH2 ARG    37     -20.229  -2.397  -9.786  1.00 54.14           N  
ATOM    579  H   ARG    37     -18.888   5.891 -11.359  1.00 10.41           H  
ATOM    580  HA  ARG    37     -17.221   4.246  -9.796  1.00 21.43           H  
ATOM    581  HB2 ARG    37     -19.530   3.702  -9.955  1.00 36.92           H  
ATOM    582  HB3 ARG    37     -19.475   3.632 -11.707  1.00 36.92           H  
ATOM    583  HG2 ARG    37     -18.115   1.618 -11.601  1.00 36.92           H  
ATOM    584  HG3 ARG    37     -18.105   1.708  -9.837  1.00 36.92           H  
ATOM    585  HD2 ARG    37     -20.547   1.477  -9.825  1.00 36.92           H  
ATOM    586  HD3 ARG    37     -20.539   1.362 -11.585  1.00 36.92           H  
ATOM    587  HE  ARG    37     -19.061  -0.678 -11.172  1.00 14.05           H  
ATOM    588 HH11 ARG    37     -21.521   0.418  -8.927  1.00 36.92           H  
ATOM    589 HH12 ARG    37     -21.866  -1.180  -8.329  1.00 36.92           H  
ATOM    590 HH21 ARG    37     -19.533  -2.794 -10.399  1.00 36.92           H  
ATOM    591 HH22 ARG    37     -20.769  -3.002  -9.183  1.00 36.92           H  
ATOM    592  N   GLU    38     -16.602   4.325 -12.973  1.00 14.40           N  
ATOM    593  CA  GLU    38     -15.581   4.032 -13.969  1.00 15.45           C  
ATOM    594  C   GLU    38     -14.200   4.347 -13.421  1.00  3.11           C  
ATOM    595  O   GLU    38     -13.309   3.502 -13.439  1.00 72.21           O  
ATOM    596  CB  GLU    38     -15.814   4.858 -15.223  1.00 64.21           C  
ATOM    597  CG  GLU    38     -17.079   4.500 -15.969  1.00 62.14           C  
ATOM    598  CD  GLU    38     -17.275   5.367 -17.191  1.00  2.33           C  
ATOM    599  OE1 GLU    38     -16.436   5.296 -18.114  1.00 74.31           O  
ATOM    600  OE2 GLU    38     -18.261   6.124 -17.232  1.00  2.14           O  
ATOM    601  H   GLU    38     -17.302   4.974 -13.190  1.00 42.23           H  
ATOM    602  HA  GLU    38     -15.637   2.983 -14.216  1.00 33.10           H  
ATOM    603  HB2 GLU    38     -15.869   5.901 -14.947  1.00 36.92           H  
ATOM    604  HB3 GLU    38     -14.977   4.716 -15.886  1.00 36.92           H  
ATOM    605  HG2 GLU    38     -17.018   3.468 -16.277  1.00 36.92           H  
ATOM    606  HG3 GLU    38     -17.923   4.632 -15.308  1.00 36.92           H  
ATOM    607  N   GLU    39     -14.041   5.573 -12.934  1.00 32.12           N  
ATOM    608  CA  GLU    39     -12.795   6.019 -12.318  1.00 42.12           C  
ATOM    609  C   GLU    39     -12.352   5.058 -11.220  1.00 31.43           C  
ATOM    610  O   GLU    39     -11.159   4.832 -11.022  1.00  2.11           O  
ATOM    611  CB  GLU    39     -12.987   7.417 -11.730  1.00 35.53           C  
ATOM    612  CG  GLU    39     -13.006   8.527 -12.761  1.00  1.50           C  
ATOM    613  CD  GLU    39     -11.630   8.822 -13.316  1.00 55.23           C  
ATOM    614  OE1 GLU    39     -10.892   9.612 -12.684  1.00 51.31           O  
ATOM    615  OE2 GLU    39     -11.276   8.263 -14.372  1.00 14.10           O  
ATOM    616  H   GLU    39     -14.791   6.208 -13.000  1.00 33.31           H  
ATOM    617  HA  GLU    39     -12.034   6.056 -13.082  1.00 32.33           H  
ATOM    618  HB2 GLU    39     -13.926   7.438 -11.199  1.00 36.92           H  
ATOM    619  HB3 GLU    39     -12.187   7.615 -11.033  1.00 36.92           H  
ATOM    620  HG2 GLU    39     -13.654   8.234 -13.574  1.00 36.92           H  
ATOM    621  HG3 GLU    39     -13.394   9.422 -12.299  1.00 36.92           H  
ATOM    622  N   ALA    40     -13.324   4.482 -10.528  1.00 15.32           N  
ATOM    623  CA  ALA    40     -13.043   3.557  -9.439  1.00 54.43           C  
ATOM    624  C   ALA    40     -12.469   2.248  -9.972  1.00 33.33           C  
ATOM    625  O   ALA    40     -11.409   1.798  -9.538  1.00 20.01           O  
ATOM    626  CB  ALA    40     -14.303   3.297  -8.623  1.00 33.21           C  
ATOM    627  H   ALA    40     -14.257   4.677 -10.764  1.00 53.43           H  
ATOM    628  HA  ALA    40     -12.314   4.019  -8.790  1.00 31.22           H  
ATOM    629  HB1 ALA    40     -14.059   2.683  -7.769  1.00 36.92           H  
ATOM    630  HB2 ALA    40     -15.028   2.785  -9.238  1.00 36.92           H  
ATOM    631  HB3 ALA    40     -14.717   4.237  -8.286  1.00 36.92           H  
ATOM    632  N   GLU    41     -13.162   1.653 -10.936  1.00  4.00           N  
ATOM    633  CA  GLU    41     -12.741   0.377 -11.503  1.00 73.11           C  
ATOM    634  C   GLU    41     -11.495   0.533 -12.376  1.00 44.42           C  
ATOM    635  O   GLU    41     -10.745  -0.423 -12.575  1.00 62.40           O  
ATOM    636  CB  GLU    41     -13.883  -0.252 -12.302  1.00 43.42           C  
ATOM    637  CG  GLU    41     -15.061  -0.668 -11.435  1.00 63.32           C  
ATOM    638  CD  GLU    41     -16.138  -1.406 -12.204  1.00 13.55           C  
ATOM    639  OE1 GLU    41     -15.808  -2.379 -12.914  1.00 13.40           O  
ATOM    640  OE2 GLU    41     -17.327  -1.038 -12.081  1.00 14.30           O  
ATOM    641  H   GLU    41     -13.981   2.081 -11.273  1.00 13.32           H  
ATOM    642  HA  GLU    41     -12.497  -0.277 -10.678  1.00 33.21           H  
ATOM    643  HB2 GLU    41     -14.232   0.465 -13.032  1.00 36.92           H  
ATOM    644  HB3 GLU    41     -13.512  -1.126 -12.816  1.00 36.92           H  
ATOM    645  HG2 GLU    41     -14.699  -1.315 -10.649  1.00 36.92           H  
ATOM    646  HG3 GLU    41     -15.497   0.217 -10.995  1.00 36.92           H  
ATOM    647  N   SER    42     -11.275   1.736 -12.892  1.00 34.34           N  
ATOM    648  CA  SER    42     -10.074   2.024 -13.663  1.00 34.54           C  
ATOM    649  C   SER    42      -8.859   2.061 -12.751  1.00 64.54           C  
ATOM    650  O   SER    42      -7.767   1.645 -13.137  1.00 33.55           O  
ATOM    651  CB  SER    42     -10.219   3.357 -14.404  1.00 12.41           C  
ATOM    652  OG  SER    42     -11.356   3.351 -15.251  1.00 45.13           O  
ATOM    653  H   SER    42     -11.942   2.446 -12.757  1.00 63.32           H  
ATOM    654  HA  SER    42      -9.937   1.231 -14.382  1.00 60.43           H  
ATOM    655  HB2 SER    42     -10.328   4.156 -13.684  1.00 36.92           H  
ATOM    656  HB3 SER    42      -9.337   3.532 -15.003  1.00 36.92           H  
ATOM    657  HG  SER    42     -12.155   3.246 -14.716  1.00 51.21           H  
ATOM    658  N   PHE    43      -9.057   2.529 -11.527  1.00 72.54           N  
ATOM    659  CA  PHE    43      -7.965   2.627 -10.579  1.00  3.13           C  
ATOM    660  C   PHE    43      -7.646   1.244 -10.019  1.00 34.22           C  
ATOM    661  O   PHE    43      -6.511   0.960  -9.641  1.00 30.41           O  
ATOM    662  CB  PHE    43      -8.327   3.597  -9.455  1.00 41.13           C  
ATOM    663  CG  PHE    43      -7.139   4.284  -8.845  1.00 43.32           C  
ATOM    664  CD1 PHE    43      -6.541   5.354  -9.492  1.00 15.11           C  
ATOM    665  CD2 PHE    43      -6.620   3.867  -7.632  1.00 40.35           C  
ATOM    666  CE1 PHE    43      -5.449   5.993  -8.941  1.00 43.32           C  
ATOM    667  CE2 PHE    43      -5.527   4.502  -7.075  1.00 52.15           C  
ATOM    668  CZ  PHE    43      -4.941   5.567  -7.731  1.00 35.31           C  
ATOM    669  H   PHE    43      -9.959   2.816 -11.256  1.00 63.33           H  
ATOM    670  HA  PHE    43      -7.100   3.000 -11.108  1.00 64.25           H  
ATOM    671  HB2 PHE    43      -8.987   4.357  -9.845  1.00 36.92           H  
ATOM    672  HB3 PHE    43      -8.834   3.052  -8.673  1.00 36.92           H  
ATOM    673  HD1 PHE    43      -6.940   5.687 -10.439  1.00 53.12           H  
ATOM    674  HD2 PHE    43      -7.077   3.034  -7.119  1.00 22.22           H  
ATOM    675  HE1 PHE    43      -4.993   6.827  -9.456  1.00  1.35           H  
ATOM    676  HE2 PHE    43      -5.132   4.169  -6.128  1.00 43.32           H  
ATOM    677  HZ  PHE    43      -4.086   6.065  -7.297  1.00 63.25           H  
ATOM    678  N   MET    44      -8.658   0.381 -10.000  1.00 62.50           N  
ATOM    679  CA  MET    44      -8.496  -0.995  -9.543  1.00 13.32           C  
ATOM    680  C   MET    44      -7.478  -1.733 -10.408  1.00 73.33           C  
ATOM    681  O   MET    44      -6.744  -2.594  -9.923  1.00 61.20           O  
ATOM    682  CB  MET    44      -9.843  -1.727  -9.572  1.00  3.31           C  
ATOM    683  CG  MET    44      -9.766  -3.179  -9.123  1.00 73.12           C  
ATOM    684  SD  MET    44      -9.170  -3.356  -7.431  1.00 23.22           S  
ATOM    685  CE  MET    44     -10.369  -2.359  -6.551  1.00 71.13           C  
ATOM    686  H   MET    44      -9.542   0.682 -10.297  1.00 71.24           H  
ATOM    687  HA  MET    44      -8.133  -0.967  -8.526  1.00 13.31           H  
ATOM    688  HB2 MET    44     -10.533  -1.209  -8.923  1.00 36.92           H  
ATOM    689  HB3 MET    44     -10.228  -1.706 -10.581  1.00 36.92           H  
ATOM    690  HG2 MET    44     -10.752  -3.616  -9.187  1.00 36.92           H  
ATOM    691  HG3 MET    44      -9.096  -3.709  -9.783  1.00 36.92           H  
ATOM    692  HE1 MET    44     -11.361  -2.737  -6.749  1.00 36.92           H  
ATOM    693  HE2 MET    44     -10.300  -1.334  -6.884  1.00 36.92           H  
ATOM    694  HE3 MET    44     -10.170  -2.407  -5.490  1.00 36.92           H  
ATOM    695  N   THR    45      -7.432  -1.375 -11.688  1.00 65.23           N  
ATOM    696  CA  THR    45      -6.485  -1.970 -12.619  1.00 31.31           C  
ATOM    697  C   THR    45      -5.052  -1.838 -12.108  1.00 32.21           C  
ATOM    698  O   THR    45      -4.336  -2.832 -11.983  1.00 30.05           O  
ATOM    699  CB  THR    45      -6.586  -1.312 -14.008  1.00 73.30           C  
ATOM    700  OG1 THR    45      -7.941  -1.362 -14.475  1.00 22.51           O  
ATOM    701  CG2 THR    45      -5.673  -2.011 -15.006  1.00 62.31           C  
ATOM    702  H   THR    45      -8.058  -0.697 -12.017  1.00 71.11           H  
ATOM    703  HA  THR    45      -6.728  -3.019 -12.720  1.00 45.11           H  
ATOM    704  HB  THR    45      -6.279  -0.279 -13.922  1.00 71.42           H  
ATOM    705  HG1 THR    45      -8.215  -0.480 -14.749  1.00 14.35           H  
ATOM    706 HG21 THR    45      -4.653  -1.955 -14.659  1.00 36.92           H  
ATOM    707 HG22 THR    45      -5.752  -1.528 -15.970  1.00 36.92           H  
ATOM    708 HG23 THR    45      -5.966  -3.046 -15.098  1.00 36.92           H  
ATOM    709  N   LYS    46      -4.647  -0.613 -11.785  1.00 43.41           N  
ATOM    710  CA  LYS    46      -3.278  -0.371 -11.342  1.00 13.22           C  
ATOM    711  C   LYS    46      -3.031  -0.946  -9.949  1.00 74.13           C  
ATOM    712  O   LYS    46      -1.901  -1.290  -9.606  1.00 74.50           O  
ATOM    713  CB  LYS    46      -2.906   1.110 -11.431  1.00 20.52           C  
ATOM    714  CG  LYS    46      -3.828   2.057 -10.694  1.00 45.41           C  
ATOM    715  CD  LYS    46      -3.570   3.491 -11.125  1.00 65.20           C  
ATOM    716  CE  LYS    46      -2.105   3.875 -10.961  1.00 50.24           C  
ATOM    717  NZ  LYS    46      -1.766   5.128 -11.692  1.00 65.40           N  
ATOM    718  H   LYS    46      -5.281   0.136 -11.841  1.00 25.43           H  
ATOM    719  HA  LYS    46      -2.641  -0.905 -12.026  1.00 53.31           H  
ATOM    720  HB2 LYS    46      -1.913   1.236 -11.029  1.00 36.92           H  
ATOM    721  HB3 LYS    46      -2.896   1.396 -12.473  1.00 36.92           H  
ATOM    722  HG2 LYS    46      -4.854   1.800 -10.918  1.00 36.92           H  
ATOM    723  HG3 LYS    46      -3.653   1.970  -9.633  1.00 36.92           H  
ATOM    724  HD2 LYS    46      -3.848   3.603 -12.162  1.00 36.92           H  
ATOM    725  HD3 LYS    46      -4.172   4.140 -10.519  1.00 36.92           H  
ATOM    726  HE2 LYS    46      -1.899   4.017  -9.911  1.00 36.92           H  
ATOM    727  HE3 LYS    46      -1.494   3.072 -11.341  1.00 36.92           H  
ATOM    728  HZ1 LYS    46      -2.261   5.946 -11.272  1.00 36.92           H  
ATOM    729  HZ2 LYS    46      -2.047   5.046 -12.693  1.00 36.92           H  
ATOM    730  HZ3 LYS    46      -0.738   5.300 -11.654  1.00 36.92           H  
ATOM    731  N   LEU    47      -4.086  -1.053  -9.150  1.00 74.23           N  
ATOM    732  CA  LEU    47      -3.993  -1.742  -7.866  1.00 35.22           C  
ATOM    733  C   LEU    47      -3.630  -3.211  -8.078  1.00 13.01           C  
ATOM    734  O   LEU    47      -2.806  -3.759  -7.352  1.00 61.51           O  
ATOM    735  CB  LEU    47      -5.308  -1.629  -7.083  1.00 13.51           C  
ATOM    736  CG  LEU    47      -5.396  -0.462  -6.092  1.00 71.30           C  
ATOM    737  CD1 LEU    47      -4.392  -0.640  -4.966  1.00 55.22           C  
ATOM    738  CD2 LEU    47      -5.172   0.867  -6.790  1.00 60.32           C  
ATOM    739  H   LEU    47      -4.943  -0.663  -9.429  1.00 33.42           H  
ATOM    740  HA  LEU    47      -3.200  -1.273  -7.296  1.00 34.23           H  
ATOM    741  HB2 LEU    47      -6.114  -1.528  -7.795  1.00 36.92           H  
ATOM    742  HB3 LEU    47      -5.453  -2.547  -6.533  1.00 36.92           H  
ATOM    743  HG  LEU    47      -6.383  -0.447  -5.655  1.00  4.10           H  
ATOM    744 HD11 LEU    47      -3.390  -0.614  -5.369  1.00 36.92           H  
ATOM    745 HD12 LEU    47      -4.560  -1.592  -4.483  1.00 36.92           H  
ATOM    746 HD13 LEU    47      -4.515   0.156  -4.247  1.00 36.92           H  
ATOM    747 HD21 LEU    47      -5.256   1.670  -6.072  1.00 36.92           H  
ATOM    748 HD22 LEU    47      -5.917   0.995  -7.562  1.00 36.92           H  
ATOM    749 HD23 LEU    47      -4.188   0.881  -7.232  1.00 36.92           H  
ATOM    750  N   LYS    48      -4.243  -3.840  -9.078  1.00 73.20           N  
ATOM    751  CA  LYS    48      -3.909  -5.213  -9.441  1.00 75.42           C  
ATOM    752  C   LYS    48      -2.463  -5.317  -9.916  1.00 51.41           C  
ATOM    753  O   LYS    48      -1.756  -6.266  -9.571  1.00 33.44           O  
ATOM    754  CB  LYS    48      -4.852  -5.730 -10.530  1.00 33.13           C  
ATOM    755  CG  LYS    48      -6.310  -5.777 -10.105  1.00 42.44           C  
ATOM    756  CD  LYS    48      -6.452  -6.375  -8.717  1.00 64.23           C  
ATOM    757  CE  LYS    48      -7.872  -6.839  -8.440  1.00 25.11           C  
ATOM    758  NZ  LYS    48      -8.293  -7.930  -9.360  1.00 44.22           N  
ATOM    759  H   LYS    48      -4.956  -3.380  -9.571  1.00 54.34           H  
ATOM    760  HA  LYS    48      -4.027  -5.823  -8.558  1.00 12.33           H  
ATOM    761  HB2 LYS    48      -4.773  -5.085 -11.392  1.00 36.92           H  
ATOM    762  HB3 LYS    48      -4.549  -6.728 -10.810  1.00 36.92           H  
ATOM    763  HG2 LYS    48      -6.709  -4.773 -10.099  1.00 36.92           H  
ATOM    764  HG3 LYS    48      -6.861  -6.384 -10.806  1.00 36.92           H  
ATOM    765  HD2 LYS    48      -5.782  -7.212  -8.632  1.00 36.92           H  
ATOM    766  HD3 LYS    48      -6.181  -5.624  -7.988  1.00 36.92           H  
ATOM    767  HE2 LYS    48      -7.929  -7.197  -7.423  1.00 36.92           H  
ATOM    768  HE3 LYS    48      -8.540  -6.000  -8.563  1.00 36.92           H  
ATOM    769  HZ1 LYS    48      -7.595  -8.708  -9.341  1.00 36.92           H  
ATOM    770  HZ2 LYS    48      -8.371  -7.570 -10.336  1.00 36.92           H  
ATOM    771  HZ3 LYS    48      -9.220  -8.306  -9.067  1.00 36.92           H  
ATOM    772  N   GLU    49      -2.027  -4.338 -10.704  1.00 11.24           N  
ATOM    773  CA  GLU    49      -0.648  -4.291 -11.179  1.00 21.22           C  
ATOM    774  C   GLU    49       0.310  -4.242  -9.994  1.00 71.10           C  
ATOM    775  O   GLU    49       1.316  -4.953  -9.958  1.00 65.13           O  
ATOM    776  CB  GLU    49      -0.431  -3.066 -12.074  1.00 24.45           C  
ATOM    777  CG  GLU    49      -1.391  -2.986 -13.250  1.00 22.30           C  
ATOM    778  CD  GLU    49      -1.150  -1.768 -14.124  1.00 71.11           C  
ATOM    779  OE1 GLU    49      -1.441  -0.639 -13.680  1.00  3.41           O  
ATOM    780  OE2 GLU    49      -0.676  -1.931 -15.267  1.00 13.53           O  
ATOM    781  H   GLU    49      -2.651  -3.632 -10.981  1.00 54.14           H  
ATOM    782  HA  GLU    49      -0.457  -5.188 -11.750  1.00 30.44           H  
ATOM    783  HB2 GLU    49      -0.553  -2.175 -11.477  1.00 36.92           H  
ATOM    784  HB3 GLU    49       0.576  -3.092 -12.463  1.00 36.92           H  
ATOM    785  HG2 GLU    49      -1.273  -3.873 -13.852  1.00 36.92           H  
ATOM    786  HG3 GLU    49      -2.401  -2.943 -12.869  1.00 36.92           H  
ATOM    787  N   LEU    50      -0.027  -3.407  -9.023  1.00 32.24           N  
ATOM    788  CA  LEU    50       0.779  -3.245  -7.819  1.00 54.34           C  
ATOM    789  C   LEU    50       0.700  -4.475  -6.919  1.00 62.31           C  
ATOM    790  O   LEU    50       1.695  -4.870  -6.308  1.00 33.53           O  
ATOM    791  CB  LEU    50       0.328  -1.999  -7.058  1.00 74.11           C  
ATOM    792  CG  LEU    50       0.742  -0.676  -7.701  1.00 64.13           C  
ATOM    793  CD1 LEU    50       0.149   0.499  -6.940  1.00  1.12           C  
ATOM    794  CD2 LEU    50       2.259  -0.572  -7.746  1.00 55.13           C  
ATOM    795  H   LEU    50      -0.846  -2.872  -9.121  1.00  0.32           H  
ATOM    796  HA  LEU    50       1.804  -3.110  -8.128  1.00 33.13           H  
ATOM    797  HB2 LEU    50      -0.750  -2.019  -6.985  1.00 36.92           H  
ATOM    798  HB3 LEU    50       0.738  -2.036  -6.063  1.00 36.92           H  
ATOM    799  HG  LEU    50       0.371  -0.642  -8.715  1.00 33.34           H  
ATOM    800 HD11 LEU    50       0.499   0.481  -5.919  1.00 36.92           H  
ATOM    801 HD12 LEU    50      -0.929   0.428  -6.952  1.00 36.92           H  
ATOM    802 HD13 LEU    50       0.454   1.422  -7.409  1.00 36.92           H  
ATOM    803 HD21 LEU    50       2.650  -0.596  -6.740  1.00 36.92           H  
ATOM    804 HD22 LEU    50       2.542   0.355  -8.222  1.00 36.92           H  
ATOM    805 HD23 LEU    50       2.660  -1.403  -8.308  1.00 36.92           H  
ATOM    806  N   ALA    51      -0.481  -5.079  -6.846  1.00 41.11           N  
ATOM    807  CA  ALA    51      -0.690  -6.268  -6.026  1.00 11.41           C  
ATOM    808  C   ALA    51       0.201  -7.417  -6.487  1.00 11.52           C  
ATOM    809  O   ALA    51       0.742  -8.157  -5.667  1.00 40.12           O  
ATOM    810  CB  ALA    51      -2.151  -6.690  -6.057  1.00 40.43           C  
ATOM    811  H   ALA    51      -1.241  -4.704  -7.346  1.00 73.44           H  
ATOM    812  HA  ALA    51      -0.434  -6.017  -5.007  1.00 62.11           H  
ATOM    813  HB1 ALA    51      -2.770  -5.869  -5.728  1.00 36.92           H  
ATOM    814  HB2 ALA    51      -2.297  -7.536  -5.400  1.00 36.92           H  
ATOM    815  HB3 ALA    51      -2.425  -6.967  -7.064  1.00 36.92           H  
ATOM    816  N   ALA    52       0.359  -7.550  -7.802  1.00 30.53           N  
ATOM    817  CA  ALA    52       1.192  -8.601  -8.378  1.00 50.04           C  
ATOM    818  C   ALA    52       2.662  -8.413  -8.011  1.00 23.14           C  
ATOM    819  O   ALA    52       3.413  -9.382  -7.903  1.00 21.42           O  
ATOM    820  CB  ALA    52       1.031  -8.637  -9.891  1.00 23.14           C  
ATOM    821  H   ALA    52      -0.110  -6.929  -8.402  1.00 65.21           H  
ATOM    822  HA  ALA    52       0.853  -9.547  -7.982  1.00 63.03           H  
ATOM    823  HB1 ALA    52       1.603  -9.461 -10.293  1.00 36.92           H  
ATOM    824  HB2 ALA    52       1.390  -7.711 -10.313  1.00 36.92           H  
ATOM    825  HB3 ALA    52      -0.012  -8.768 -10.141  1.00 36.92           H  
ATOM    826  N   ALA    53       3.069  -7.163  -7.831  1.00 15.05           N  
ATOM    827  CA  ALA    53       4.444  -6.860  -7.461  1.00 25.53           C  
ATOM    828  C   ALA    53       4.680  -7.140  -5.981  1.00 14.01           C  
ATOM    829  O   ALA    53       5.673  -7.767  -5.613  1.00 21.34           O  
ATOM    830  CB  ALA    53       4.775  -5.411  -7.788  1.00 44.34           C  
ATOM    831  H   ALA    53       2.430  -6.430  -7.947  1.00 13.42           H  
ATOM    832  HA  ALA    53       5.094  -7.494  -8.046  1.00 13.21           H  
ATOM    833  HB1 ALA    53       4.145  -4.759  -7.203  1.00 36.92           H  
ATOM    834  HB2 ALA    53       4.604  -5.231  -8.839  1.00 36.92           H  
ATOM    835  HB3 ALA    53       5.812  -5.217  -7.554  1.00 36.92           H  
ATOM    836  N   ALA    54       3.753  -6.681  -5.144  1.00 63.51           N  
ATOM    837  CA  ALA    54       3.859  -6.855  -3.698  1.00 50.11           C  
ATOM    838  C   ALA    54       3.695  -8.321  -3.301  1.00 31.12           C  
ATOM    839  O   ALA    54       4.514  -8.878  -2.567  1.00 55.23           O  
ATOM    840  CB  ALA    54       2.816  -5.999  -2.993  1.00 43.23           C  
ATOM    841  H   ALA    54       2.975  -6.206  -5.510  1.00 62.02           H  
ATOM    842  HA  ALA    54       4.836  -6.516  -3.391  1.00  3.24           H  
ATOM    843  HB1 ALA    54       2.917  -4.971  -3.311  1.00 36.92           H  
ATOM    844  HB2 ALA    54       2.961  -6.061  -1.925  1.00 36.92           H  
ATOM    845  HB3 ALA    54       1.828  -6.357  -3.243  1.00 36.92           H  
ATOM    846  N   SER    55       2.634  -8.937  -3.792  1.00 63.11           N  
ATOM    847  CA  SER    55       2.357 -10.328  -3.496  1.00 53.42           C  
ATOM    848  C   SER    55       2.462 -11.162  -4.763  1.00 52.22           C  
ATOM    849  O   SER    55       1.758 -10.909  -5.740  1.00  1.23           O  
ATOM    850  CB  SER    55       0.966 -10.466  -2.874  1.00 41.12           C  
ATOM    851  OG  SER    55      -0.024  -9.848  -3.684  1.00 43.44           O  
ATOM    852  H   SER    55       2.023  -8.444  -4.381  1.00 22.04           H  
ATOM    853  HA  SER    55       3.097 -10.674  -2.789  1.00 21.41           H  
ATOM    854  HB2 SER    55       0.725 -11.515  -2.767  1.00 36.92           H  
ATOM    855  HB3 SER    55       0.962  -9.994  -1.904  1.00 36.92           H  
ATOM    856  HG  SER    55       0.393  -9.486  -4.478  1.00  0.33           H  
ATOM    857  N   SER    56       3.356 -12.139  -4.752  1.00 71.22           N  
ATOM    858  CA  SER    56       3.554 -12.997  -5.907  1.00  2.45           C  
ATOM    859  C   SER    56       2.365 -13.942  -6.077  1.00 50.23           C  
ATOM    860  O   SER    56       1.435 -13.646  -6.832  1.00 52.53           O  
ATOM    861  CB  SER    56       4.852 -13.788  -5.752  1.00 10.03           C  
ATOM    862  OG  SER    56       5.923 -12.940  -5.373  1.00 72.14           O  
ATOM    863  H   SER    56       3.899 -12.284  -3.947  1.00  1.32           H  
ATOM    864  HA  SER    56       3.625 -12.366  -6.780  1.00  4.24           H  
ATOM    865  HB2 SER    56       4.722 -14.545  -4.993  1.00 36.92           H  
ATOM    866  HB3 SER    56       5.099 -14.260  -6.693  1.00 36.92           H  
ATOM    867  HG  SER    56       5.861 -12.107  -5.866  1.00  4.34           H  
ATOM    868  N   ALA    57       2.396 -15.065  -5.353  1.00 12.51           N  
ATOM    869  CA  ALA    57       1.335 -16.047  -5.377  1.00 33.14           C  
ATOM    870  C   ALA    57       1.033 -16.502  -6.796  1.00 23.43           C  
ATOM    871  O   ALA    57       1.818 -16.299  -7.729  1.00 10.43           O  
ATOM    872  CB  ALA    57       0.083 -15.483  -4.713  1.00 62.00           C  
ATOM    873  H   ALA    57       3.159 -15.242  -4.789  1.00 31.43           H  
ATOM    874  HA  ALA    57       1.662 -16.901  -4.801  1.00 43.33           H  
ATOM    875  HB1 ALA    57      -0.252 -14.613  -5.258  1.00 36.92           H  
ATOM    876  HB2 ALA    57       0.309 -15.204  -3.694  1.00 36.92           H  
ATOM    877  HB3 ALA    57      -0.695 -16.232  -4.716  1.00 36.92           H  
ATOM    878  N   ASP    58      -0.098 -17.142  -6.935  1.00 51.44           N  
ATOM    879  CA  ASP    58      -0.593 -17.557  -8.241  1.00 60.15           C  
ATOM    880  C   ASP    58      -1.215 -16.372  -8.962  1.00 21.53           C  
ATOM    881  O   ASP    58      -0.896 -16.094 -10.118  1.00 41.32           O  
ATOM    882  CB  ASP    58      -1.630 -18.676  -8.110  1.00 52.14           C  
ATOM    883  CG  ASP    58      -1.017 -20.002  -7.713  1.00 11.33           C  
ATOM    884  OD1 ASP    58      -0.813 -20.238  -6.500  1.00 22.34           O  
ATOM    885  OD2 ASP    58      -0.735 -20.819  -8.612  1.00 61.34           O  
ATOM    886  H   ASP    58      -0.616 -17.340  -6.127  1.00 45.34           H  
ATOM    887  HA  ASP    58       0.247 -17.917  -8.816  1.00 63.12           H  
ATOM    888  HB2 ASP    58      -2.356 -18.399  -7.361  1.00 36.92           H  
ATOM    889  HB3 ASP    58      -2.131 -18.802  -9.060  1.00 36.92           H  
ATOM    890  N   GLU    59      -2.106 -15.675  -8.268  1.00  5.43           N  
ATOM    891  CA  GLU    59      -2.817 -14.540  -8.838  1.00 65.12           C  
ATOM    892  C   GLU    59      -2.734 -13.331  -7.912  1.00 42.44           C  
ATOM    893  O   GLU    59      -3.513 -12.381  -8.038  1.00 62.23           O  
ATOM    894  CB  GLU    59      -4.278 -14.922  -9.073  1.00 24.01           C  
ATOM    895  CG  GLU    59      -4.443 -16.070 -10.051  1.00 21.50           C  
ATOM    896  CD  GLU    59      -5.859 -16.586 -10.113  1.00 22.43           C  
ATOM    897  OE1 GLU    59      -6.689 -15.976 -10.815  1.00 73.42           O  
ATOM    898  OE2 GLU    59      -6.144 -17.611  -9.459  1.00 70.12           O  
ATOM    899  H   GLU    59      -2.307 -15.947  -7.341  1.00 73.32           H  
ATOM    900  HA  GLU    59      -2.358 -14.294  -9.783  1.00 21.01           H  
ATOM    901  HB2 GLU    59      -4.718 -15.214  -8.130  1.00 36.92           H  
ATOM    902  HB3 GLU    59      -4.808 -14.064  -9.460  1.00 36.92           H  
ATOM    903  HG2 GLU    59      -4.156 -15.734 -11.036  1.00 36.92           H  
ATOM    904  HG3 GLU    59      -3.796 -16.879  -9.746  1.00 36.92           H  
ATOM    905  N   GLY    60      -1.785 -13.372  -6.989  1.00 65.33           N  
ATOM    906  CA  GLY    60      -1.613 -12.283  -6.052  1.00 60.33           C  
ATOM    907  C   GLY    60      -2.392 -12.506  -4.771  1.00  3.34           C  
ATOM    908  O   GLY    60      -3.015 -13.554  -4.590  1.00 14.40           O  
ATOM    909  H   GLY    60      -1.195 -14.152  -6.939  1.00 72.33           H  
ATOM    910  HA2 GLY    60      -0.562 -12.188  -5.815  1.00 36.92           H  
ATOM    911  HA3 GLY    60      -1.954 -11.369  -6.514  1.00 36.92           H  
ATOM    912  N   ALA    61      -2.346 -11.526  -3.880  1.00 72.42           N  
ATOM    913  CA  ALA    61      -3.069 -11.591  -2.616  1.00 51.33           C  
ATOM    914  C   ALA    61      -4.578 -11.542  -2.840  1.00 33.41           C  
ATOM    915  O   ALA    61      -5.045 -11.232  -3.938  1.00 22.40           O  
ATOM    916  CB  ALA    61      -2.636 -10.451  -1.708  1.00 75.35           C  
ATOM    917  H   ALA    61      -1.799 -10.733  -4.074  1.00 11.03           H  
ATOM    918  HA  ALA    61      -2.817 -12.522  -2.131  1.00 14.23           H  
ATOM    919  HB1 ALA    61      -3.144 -10.536  -0.758  1.00 36.92           H  
ATOM    920  HB2 ALA    61      -2.892  -9.508  -2.169  1.00 36.92           H  
ATOM    921  HB3 ALA    61      -1.569 -10.498  -1.553  1.00 36.92           H  
ATOM    922  N   SER    62      -5.334 -11.843  -1.793  1.00 73.03           N  
ATOM    923  CA  SER    62      -6.787 -11.813  -1.866  1.00 13.25           C  
ATOM    924  C   SER    62      -7.280 -10.372  -1.920  1.00 31.33           C  
ATOM    925  O   SER    62      -6.742  -9.502  -1.239  1.00 73.22           O  
ATOM    926  CB  SER    62      -7.375 -12.533  -0.656  1.00 54.03           C  
ATOM    927  OG  SER    62      -6.856 -13.851  -0.560  1.00 72.43           O  
ATOM    928  H   SER    62      -4.903 -12.076  -0.942  1.00 71.44           H  
ATOM    929  HA  SER    62      -7.090 -12.325  -2.766  1.00 52.21           H  
ATOM    930  HB2 SER    62      -7.120 -11.994   0.245  1.00 36.92           H  
ATOM    931  HB3 SER    62      -8.448 -12.581  -0.755  1.00 36.92           H  
ATOM    932  HG  SER    62      -6.398 -14.071  -1.381  1.00 64.34           H  
ATOM    933  N   VAL    63      -8.296 -10.121  -2.728  1.00 44.14           N  
ATOM    934  CA  VAL    63      -8.796  -8.773  -2.909  1.00  5.32           C  
ATOM    935  C   VAL    63     -10.323  -8.737  -2.879  1.00 64.30           C  
ATOM    936  O   VAL    63     -10.999  -9.339  -3.715  1.00 54.23           O  
ATOM    937  CB  VAL    63      -8.267  -8.150  -4.225  1.00 12.20           C  
ATOM    938  CG1 VAL    63      -8.564  -9.045  -5.422  1.00 44.21           C  
ATOM    939  CG2 VAL    63      -8.845  -6.758  -4.438  1.00  3.44           C  
ATOM    940  H   VAL    63      -8.730 -10.863  -3.205  1.00 41.21           H  
ATOM    941  HA  VAL    63      -8.424  -8.176  -2.088  1.00 34.10           H  
ATOM    942  HB  VAL    63      -7.194  -8.057  -4.141  1.00 44.33           H  
ATOM    943 HG11 VAL    63      -9.633  -9.167  -5.524  1.00 36.92           H  
ATOM    944 HG12 VAL    63      -8.104 -10.010  -5.273  1.00 36.92           H  
ATOM    945 HG13 VAL    63      -8.166  -8.591  -6.318  1.00 36.92           H  
ATOM    946 HG21 VAL    63      -8.434  -6.330  -5.341  1.00 36.92           H  
ATOM    947 HG22 VAL    63      -8.594  -6.131  -3.595  1.00 36.92           H  
ATOM    948 HG23 VAL    63      -9.919  -6.825  -4.530  1.00 36.92           H  
ATOM    949  N   ALA    64     -10.856  -8.047  -1.887  1.00  0.14           N  
ATOM    950  CA  ALA    64     -12.288  -7.819  -1.788  1.00 21.41           C  
ATOM    951  C   ALA    64     -12.562  -6.327  -1.880  1.00 35.15           C  
ATOM    952  O   ALA    64     -12.278  -5.578  -0.946  1.00 43.34           O  
ATOM    953  CB  ALA    64     -12.834  -8.391  -0.489  1.00 63.04           C  
ATOM    954  H   ALA    64     -10.264  -7.673  -1.193  1.00 52.24           H  
ATOM    955  HA  ALA    64     -12.769  -8.322  -2.616  1.00 14.12           H  
ATOM    956  HB1 ALA    64     -12.364  -7.896   0.348  1.00 36.92           H  
ATOM    957  HB2 ALA    64     -12.625  -9.449  -0.445  1.00 36.92           H  
ATOM    958  HB3 ALA    64     -13.902  -8.233  -0.447  1.00 36.92           H  
ATOM    959  N   TYR    65     -13.097  -5.890  -3.004  1.00 54.34           N  
ATOM    960  CA  TYR    65     -13.224  -4.466  -3.259  1.00 14.20           C  
ATOM    961  C   TYR    65     -14.639  -3.974  -3.005  1.00 50.43           C  
ATOM    962  O   TYR    65     -15.609  -4.709  -3.185  1.00 43.51           O  
ATOM    963  CB  TYR    65     -12.788  -4.132  -4.693  1.00  1.20           C  
ATOM    964  CG  TYR    65     -13.635  -4.762  -5.787  1.00  2.44           C  
ATOM    965  CD1 TYR    65     -14.810  -4.154  -6.216  1.00  0.31           C  
ATOM    966  CD2 TYR    65     -13.252  -5.950  -6.401  1.00 62.40           C  
ATOM    967  CE1 TYR    65     -15.579  -4.712  -7.217  1.00 73.44           C  
ATOM    968  CE2 TYR    65     -14.017  -6.511  -7.408  1.00 12.11           C  
ATOM    969  CZ  TYR    65     -15.179  -5.887  -7.809  1.00  0.44           C  
ATOM    970  OH  TYR    65     -15.944  -6.433  -8.815  1.00 35.31           O  
ATOM    971  H   TYR    65     -13.431  -6.535  -3.668  1.00 31.52           H  
ATOM    972  HA  TYR    65     -12.560  -3.956  -2.575  1.00 43.25           H  
ATOM    973  HB2 TYR    65     -12.825  -3.062  -4.826  1.00 36.92           H  
ATOM    974  HB3 TYR    65     -11.770  -4.467  -4.830  1.00 36.92           H  
ATOM    975  HD1 TYR    65     -15.122  -3.233  -5.751  1.00 71.15           H  
ATOM    976  HD2 TYR    65     -12.342  -6.438  -6.083  1.00 51.12           H  
ATOM    977  HE1 TYR    65     -16.490  -4.225  -7.533  1.00 12.11           H  
ATOM    978  HE2 TYR    65     -13.706  -7.435  -7.874  1.00 43.35           H  
ATOM    979  HH  TYR    65     -16.005  -7.390  -8.696  1.00 23.11           H  
ATOM    980  N   LYS    66     -14.740  -2.736  -2.558  1.00 23.34           N  
ATOM    981  CA  LYS    66     -16.020  -2.076  -2.406  1.00 52.14           C  
ATOM    982  C   LYS    66     -16.198  -1.043  -3.489  1.00 45.51           C  
ATOM    983  O   LYS    66     -15.264  -0.320  -3.838  1.00 42.11           O  
ATOM    984  CB  LYS    66     -16.127  -1.366  -1.064  1.00 20.13           C  
ATOM    985  CG  LYS    66     -16.056  -2.280   0.131  1.00 13.54           C  
ATOM    986  CD  LYS    66     -15.737  -1.473   1.373  1.00 52.40           C  
ATOM    987  CE  LYS    66     -15.406  -2.345   2.568  1.00 75.44           C  
ATOM    988  NZ  LYS    66     -14.811  -1.538   3.664  1.00  1.23           N  
ATOM    989  H   LYS    66     -13.923  -2.248  -2.307  1.00 52.21           H  
ATOM    990  HA  LYS    66     -16.799  -2.817  -2.485  1.00 74.25           H  
ATOM    991  HB2 LYS    66     -15.321  -0.652  -0.985  1.00 36.92           H  
ATOM    992  HB3 LYS    66     -17.067  -0.836  -1.025  1.00 36.92           H  
ATOM    993  HG2 LYS    66     -17.011  -2.769   0.259  1.00 36.92           H  
ATOM    994  HG3 LYS    66     -15.287  -3.011  -0.035  1.00 36.92           H  
ATOM    995  HD2 LYS    66     -14.890  -0.837   1.165  1.00 36.92           H  
ATOM    996  HD3 LYS    66     -16.593  -0.859   1.616  1.00 36.92           H  
ATOM    997  HE2 LYS    66     -16.313  -2.811   2.923  1.00 36.92           H  
ATOM    998  HE3 LYS    66     -14.701  -3.103   2.264  1.00 36.92           H  
ATOM    999  HZ1 LYS    66     -15.471  -0.782   3.954  1.00 36.92           H  
ATOM   1000  HZ2 LYS    66     -13.921  -1.095   3.334  1.00 36.92           H  
ATOM   1001  HZ3 LYS    66     -14.602  -2.135   4.488  1.00 36.92           H  
ATOM   1002  N   ILE    67     -17.398  -0.991  -4.009  1.00 45.32           N  
ATOM   1003  CA  ILE    67     -17.793   0.051  -4.939  1.00 72.14           C  
ATOM   1004  C   ILE    67     -19.163   0.573  -4.544  1.00 63.23           C  
ATOM   1005  O   ILE    67     -20.180  -0.090  -4.764  1.00 32.20           O  
ATOM   1006  CB  ILE    67     -17.842  -0.437  -6.404  1.00 21.51           C  
ATOM   1007  CG1 ILE    67     -16.476  -0.963  -6.847  1.00 22.50           C  
ATOM   1008  CG2 ILE    67     -18.293   0.700  -7.315  1.00 22.44           C  
ATOM   1009  CD1 ILE    67     -16.452  -1.466  -8.275  1.00  1.44           C  
ATOM   1010  H   ILE    67     -18.049  -1.670  -3.740  1.00  2.22           H  
ATOM   1011  HA  ILE    67     -17.073   0.855  -4.866  1.00 75.03           H  
ATOM   1012  HB  ILE    67     -18.568  -1.233  -6.474  1.00 11.44           H  
ATOM   1013 HG12 ILE    67     -15.750  -0.169  -6.763  1.00 36.92           H  
ATOM   1014 HG13 ILE    67     -16.185  -1.779  -6.201  1.00 36.92           H  
ATOM   1015 HG21 ILE    67     -19.276   1.032  -7.018  1.00 36.92           H  
ATOM   1016 HG22 ILE    67     -18.323   0.353  -8.338  1.00 36.92           H  
ATOM   1017 HG23 ILE    67     -17.596   1.520  -7.235  1.00 36.92           H  
ATOM   1018 HD11 ILE    67     -17.154  -2.280  -8.381  1.00 36.92           H  
ATOM   1019 HD12 ILE    67     -15.459  -1.812  -8.518  1.00 36.92           H  
ATOM   1020 HD13 ILE    67     -16.726  -0.663  -8.943  1.00 36.92           H  
ATOM   1021  N   LYS    68     -19.186   1.740  -3.934  1.00 34.32           N  
ATOM   1022  CA  LYS    68     -20.437   2.340  -3.514  1.00 25.45           C  
ATOM   1023  C   LYS    68     -20.806   3.478  -4.442  1.00 45.23           C  
ATOM   1024  O   LYS    68     -20.070   4.459  -4.571  1.00 71.53           O  
ATOM   1025  CB  LYS    68     -20.345   2.827  -2.072  1.00 71.40           C  
ATOM   1026  CG  LYS    68     -21.651   3.377  -1.517  1.00 52.33           C  
ATOM   1027  CD  LYS    68     -21.542   3.652  -0.026  1.00 33.42           C  
ATOM   1028  CE  LYS    68     -22.825   4.245   0.538  1.00 50.52           C  
ATOM   1029  NZ  LYS    68     -23.997   3.355   0.327  1.00 72.10           N  
ATOM   1030  H   LYS    68     -18.341   2.211  -3.764  1.00 40.12           H  
ATOM   1031  HA  LYS    68     -21.205   1.582  -3.579  1.00 54.24           H  
ATOM   1032  HB2 LYS    68     -20.038   2.003  -1.451  1.00 36.92           H  
ATOM   1033  HB3 LYS    68     -19.602   3.607  -2.018  1.00 36.92           H  
ATOM   1034  HG2 LYS    68     -21.887   4.300  -2.025  1.00 36.92           H  
ATOM   1035  HG3 LYS    68     -22.438   2.657  -1.685  1.00 36.92           H  
ATOM   1036  HD2 LYS    68     -21.333   2.724   0.486  1.00 36.92           H  
ATOM   1037  HD3 LYS    68     -20.731   4.346   0.141  1.00 36.92           H  
ATOM   1038  HE2 LYS    68     -22.696   4.409   1.598  1.00 36.92           H  
ATOM   1039  HE3 LYS    68     -23.010   5.193   0.051  1.00 36.92           H  
ATOM   1040  HZ1 LYS    68     -23.818   2.416   0.742  1.00 36.92           H  
ATOM   1041  HZ2 LYS    68     -24.187   3.246  -0.691  1.00 36.92           H  
ATOM   1042  HZ3 LYS    68     -24.843   3.766   0.780  1.00 36.92           H  
ATOM   1043  N   ASP    69     -21.948   3.326  -5.082  1.00 60.11           N  
ATOM   1044  CA  ASP    69     -22.432   4.284  -6.053  1.00 21.41           C  
ATOM   1045  C   ASP    69     -23.101   5.447  -5.324  1.00 34.11           C  
ATOM   1046  O   ASP    69     -24.267   5.355  -4.939  1.00 44.23           O  
ATOM   1047  CB  ASP    69     -23.443   3.619  -6.996  1.00 24.45           C  
ATOM   1048  CG  ASP    69     -23.033   2.222  -7.437  1.00 63.23           C  
ATOM   1049  OD1 ASP    69     -22.338   2.087  -8.468  1.00 23.43           O  
ATOM   1050  OD2 ASP    69     -23.432   1.246  -6.762  1.00 74.32           O  
ATOM   1051  H   ASP    69     -22.499   2.539  -4.881  1.00 51.42           H  
ATOM   1052  HA  ASP    69     -21.589   4.649  -6.628  1.00 41.14           H  
ATOM   1053  HB2 ASP    69     -24.397   3.548  -6.495  1.00 36.92           H  
ATOM   1054  HB3 ASP    69     -23.553   4.231  -7.872  1.00 36.92           H  
ATOM   1055  N   LEU    70     -22.358   6.520  -5.106  1.00 53.24           N  
ATOM   1056  CA  LEU    70     -22.879   7.671  -4.381  1.00 44.32           C  
ATOM   1057  C   LEU    70     -23.393   8.734  -5.341  1.00 73.41           C  
ATOM   1058  O   LEU    70     -23.405   8.542  -6.559  1.00 72.32           O  
ATOM   1059  CB  LEU    70     -21.796   8.270  -3.478  1.00 24.22           C  
ATOM   1060  CG  LEU    70     -21.334   7.376  -2.330  1.00 55.12           C  
ATOM   1061  CD1 LEU    70     -20.155   8.007  -1.604  1.00 61.32           C  
ATOM   1062  CD2 LEU    70     -22.483   7.129  -1.367  1.00 75.23           C  
ATOM   1063  H   LEU    70     -21.438   6.548  -5.446  1.00 74.20           H  
ATOM   1064  HA  LEU    70     -23.700   7.332  -3.766  1.00 60.34           H  
ATOM   1065  HB2 LEU    70     -20.938   8.504  -4.092  1.00 36.92           H  
ATOM   1066  HB3 LEU    70     -22.177   9.189  -3.058  1.00 36.92           H  
ATOM   1067  HG  LEU    70     -21.015   6.424  -2.727  1.00 20.33           H  
ATOM   1068 HD11 LEU    70     -19.847   7.366  -0.790  1.00 36.92           H  
ATOM   1069 HD12 LEU    70     -20.445   8.971  -1.213  1.00 36.92           H  
ATOM   1070 HD13 LEU    70     -19.334   8.131  -2.294  1.00 36.92           H  
ATOM   1071 HD21 LEU    70     -22.155   6.473  -0.576  1.00 36.92           H  
ATOM   1072 HD22 LEU    70     -23.305   6.671  -1.898  1.00 36.92           H  
ATOM   1073 HD23 LEU    70     -22.807   8.069  -0.945  1.00 36.92           H  
ATOM   1074  N   GLU    71     -23.814   9.857  -4.785  1.00 23.43           N  
ATOM   1075  CA  GLU    71     -24.349  10.951  -5.573  1.00  1.01           C  
ATOM   1076  C   GLU    71     -23.249  11.955  -5.905  1.00 60.04           C  
ATOM   1077  O   GLU    71     -22.900  12.807  -5.086  1.00  1.51           O  
ATOM   1078  CB  GLU    71     -25.472  11.637  -4.801  1.00 70.31           C  
ATOM   1079  CG  GLU    71     -26.265  12.635  -5.619  1.00 62.41           C  
ATOM   1080  CD  GLU    71     -27.254  13.402  -4.774  1.00 30.54           C  
ATOM   1081  OE1 GLU    71     -28.047  12.768  -4.047  1.00 32.54           O  
ATOM   1082  OE2 GLU    71     -27.228  14.651  -4.815  1.00 74.10           O  
ATOM   1083  H   GLU    71     -23.765   9.954  -3.807  1.00 15.23           H  
ATOM   1084  HA  GLU    71     -24.744  10.545  -6.491  1.00 14.31           H  
ATOM   1085  HB2 GLU    71     -26.154  10.884  -4.436  1.00 36.92           H  
ATOM   1086  HB3 GLU    71     -25.043  12.158  -3.957  1.00 36.92           H  
ATOM   1087  HG2 GLU    71     -25.580  13.336  -6.072  1.00 36.92           H  
ATOM   1088  HG3 GLU    71     -26.805  12.107  -6.393  1.00 36.92           H  
ATOM   1089  N   GLY    72     -22.685  11.829  -7.094  1.00 12.40           N  
ATOM   1090  CA  GLY    72     -21.642  12.744  -7.518  1.00 54.51           C  
ATOM   1091  C   GLY    72     -20.257  12.149  -7.384  1.00 60.22           C  
ATOM   1092  O   GLY    72     -19.296  12.660  -7.960  1.00 71.13           O  
ATOM   1093  H   GLY    72     -22.982  11.111  -7.693  1.00 72.14           H  
ATOM   1094  HA2 GLY    72     -21.811  13.008  -8.553  1.00 36.92           H  
ATOM   1095  HA3 GLY    72     -21.696  13.638  -6.916  1.00 36.92           H  
ATOM   1096  N   GLN    73     -20.152  11.070  -6.626  1.00 12.51           N  
ATOM   1097  CA  GLN    73     -18.878  10.398  -6.423  1.00 65.04           C  
ATOM   1098  C   GLN    73     -19.103   8.924  -6.129  1.00 53.02           C  
ATOM   1099  O   GLN    73     -20.239   8.469  -6.037  1.00  4.34           O  
ATOM   1100  CB  GLN    73     -18.098  11.043  -5.271  1.00 73.13           C  
ATOM   1101  CG  GLN    73     -18.834  11.021  -3.939  1.00 20.53           C  
ATOM   1102  CD  GLN    73     -17.944  11.413  -2.774  1.00 32.52           C  
ATOM   1103  OE1 GLN    73     -17.817  12.589  -2.437  1.00 12.33           O  
ATOM   1104  NE2 GLN    73     -17.331  10.424  -2.142  1.00 64.02           N  
ATOM   1105  H   GLN    73     -20.955  10.705  -6.197  1.00  2.45           H  
ATOM   1106  HA  GLN    73     -18.304  10.489  -7.334  1.00 14.12           H  
ATOM   1107  HB2 GLN    73     -17.164  10.517  -5.148  1.00 36.92           H  
ATOM   1108  HB3 GLN    73     -17.890  12.072  -5.526  1.00 36.92           H  
ATOM   1109  HG2 GLN    73     -19.662  11.712  -3.987  1.00 36.92           H  
ATOM   1110  HG3 GLN    73     -19.208  10.023  -3.766  1.00 36.92           H  
ATOM   1111 HE21 GLN    73     -17.484   9.510  -2.455  1.00 36.92           H  
ATOM   1112 HE22 GLN    73     -16.755  10.646  -1.380  1.00 36.92           H  
ATOM   1113  N   VAL    74     -18.016   8.182  -6.000  1.00 44.24           N  
ATOM   1114  CA  VAL    74     -18.083   6.779  -5.618  1.00 51.30           C  
ATOM   1115  C   VAL    74     -16.989   6.451  -4.614  1.00 24.33           C  
ATOM   1116  O   VAL    74     -15.954   7.121  -4.569  1.00  0.32           O  
ATOM   1117  CB  VAL    74     -17.938   5.837  -6.832  1.00 13.50           C  
ATOM   1118  CG1 VAL    74     -19.130   5.966  -7.767  1.00 50.33           C  
ATOM   1119  CG2 VAL    74     -16.641   6.115  -7.573  1.00 32.50           C  
ATOM   1120  H   VAL    74     -17.138   8.591  -6.170  1.00 31.51           H  
ATOM   1121  HA  VAL    74     -19.046   6.601  -5.161  1.00 15.53           H  
ATOM   1122  HB  VAL    74     -17.903   4.822  -6.468  1.00  4.20           H  
ATOM   1123 HG11 VAL    74     -19.014   5.283  -8.595  1.00 36.92           H  
ATOM   1124 HG12 VAL    74     -19.188   6.978  -8.139  1.00 36.92           H  
ATOM   1125 HG13 VAL    74     -20.035   5.728  -7.228  1.00 36.92           H  
ATOM   1126 HG21 VAL    74     -16.557   5.445  -8.416  1.00 36.92           H  
ATOM   1127 HG22 VAL    74     -15.806   5.962  -6.906  1.00 36.92           H  
ATOM   1128 HG23 VAL    74     -16.639   7.137  -7.924  1.00 36.92           H  
ATOM   1129  N   GLU    75     -17.224   5.429  -3.807  1.00 25.23           N  
ATOM   1130  CA  GLU    75     -16.222   4.954  -2.868  1.00 61.11           C  
ATOM   1131  C   GLU    75     -15.567   3.690  -3.386  1.00 54.30           C  
ATOM   1132  O   GLU    75     -16.224   2.657  -3.540  1.00 60.22           O  
ATOM   1133  CB  GLU    75     -16.831   4.678  -1.495  1.00 44.30           C  
ATOM   1134  CG  GLU    75     -17.083   5.925  -0.679  1.00  2.41           C  
ATOM   1135  CD  GLU    75     -17.741   5.628   0.651  1.00 51.44           C  
ATOM   1136  OE1 GLU    75     -18.290   4.516   0.815  1.00 33.35           O  
ATOM   1137  OE2 GLU    75     -17.693   6.496   1.546  1.00 15.14           O  
ATOM   1138  H   GLU    75     -18.095   4.978  -3.847  1.00 52.23           H  
ATOM   1139  HA  GLU    75     -15.467   5.724  -2.770  1.00 22.00           H  
ATOM   1140  HB2 GLU    75     -17.774   4.168  -1.627  1.00 36.92           H  
ATOM   1141  HB3 GLU    75     -16.162   4.040  -0.938  1.00 36.92           H  
ATOM   1142  HG2 GLU    75     -16.137   6.411  -0.491  1.00 36.92           H  
ATOM   1143  HG3 GLU    75     -17.715   6.584  -1.244  1.00 36.92           H  
ATOM   1144  N   LEU    76     -14.285   3.786  -3.670  1.00 12.03           N  
ATOM   1145  CA  LEU    76     -13.500   2.625  -4.045  1.00 73.45           C  
ATOM   1146  C   LEU    76     -12.639   2.229  -2.859  1.00 13.34           C  
ATOM   1147  O   LEU    76     -11.725   2.958  -2.479  1.00 71.02           O  
ATOM   1148  CB  LEU    76     -12.638   2.929  -5.283  1.00 30.32           C  
ATOM   1149  CG  LEU    76     -11.966   1.718  -5.963  1.00 24.24           C  
ATOM   1150  CD1 LEU    76     -10.748   1.240  -5.183  1.00 52.21           C  
ATOM   1151  CD2 LEU    76     -12.963   0.581  -6.137  1.00 40.14           C  
ATOM   1152  H   LEU    76     -13.849   4.665  -3.617  1.00  2.51           H  
ATOM   1153  HA  LEU    76     -14.180   1.817  -4.271  1.00 12.21           H  
ATOM   1154  HB2 LEU    76     -13.265   3.416  -6.015  1.00 36.92           H  
ATOM   1155  HB3 LEU    76     -11.862   3.620  -4.989  1.00 36.92           H  
ATOM   1156  HG  LEU    76     -11.631   2.013  -6.943  1.00  3.32           H  
ATOM   1157 HD11 LEU    76     -10.305   0.395  -5.689  1.00 36.92           H  
ATOM   1158 HD12 LEU    76     -11.049   0.949  -4.189  1.00 36.92           H  
ATOM   1159 HD13 LEU    76     -10.024   2.040  -5.120  1.00 36.92           H  
ATOM   1160 HD21 LEU    76     -13.782   0.909  -6.759  1.00 36.92           H  
ATOM   1161 HD22 LEU    76     -13.343   0.282  -5.170  1.00 36.92           H  
ATOM   1162 HD23 LEU    76     -12.471  -0.259  -6.604  1.00 36.92           H  
ATOM   1163  N   ASP    77     -12.956   1.092  -2.270  1.00 44.04           N  
ATOM   1164  CA  ASP    77     -12.244   0.619  -1.085  1.00 71.33           C  
ATOM   1165  C   ASP    77     -11.896  -0.850  -1.246  1.00 21.25           C  
ATOM   1166  O   ASP    77     -12.757  -1.719  -1.129  1.00  5.21           O  
ATOM   1167  CB  ASP    77     -13.078   0.839   0.186  1.00 30.32           C  
ATOM   1168  CG  ASP    77     -12.360   0.396   1.454  1.00 43.10           C  
ATOM   1169  OD1 ASP    77     -11.302   0.975   1.778  1.00 52.23           O  
ATOM   1170  OD2 ASP    77     -12.863  -0.523   2.140  1.00 61.53           O  
ATOM   1171  H   ASP    77     -13.676   0.543  -2.655  1.00 11.34           H  
ATOM   1172  HA  ASP    77     -11.327   1.184  -1.006  1.00 53.23           H  
ATOM   1173  HB2 ASP    77     -13.308   1.891   0.279  1.00 36.92           H  
ATOM   1174  HB3 ASP    77     -14.001   0.283   0.105  1.00 36.92           H  
ATOM   1175  N   ALA    78     -10.642  -1.121  -1.553  1.00 23.23           N  
ATOM   1176  CA  ALA    78     -10.206  -2.479  -1.820  1.00 62.42           C  
ATOM   1177  C   ALA    78      -9.454  -3.060  -0.634  1.00 62.32           C  
ATOM   1178  O   ALA    78      -8.474  -2.483  -0.161  1.00  3.13           O  
ATOM   1179  CB  ALA    78      -9.338  -2.511  -3.067  1.00 32.42           C  
ATOM   1180  H   ALA    78      -9.988  -0.385  -1.591  1.00 35.04           H  
ATOM   1181  HA  ALA    78     -11.084  -3.079  -2.006  1.00 25.14           H  
ATOM   1182  HB1 ALA    78      -9.042  -3.529  -3.273  1.00 36.92           H  
ATOM   1183  HB2 ALA    78      -8.459  -1.906  -2.907  1.00 36.92           H  
ATOM   1184  HB3 ALA    78      -9.897  -2.122  -3.905  1.00 36.92           H  
ATOM   1185  N   ALA    79      -9.925  -4.201  -0.156  1.00 14.34           N  
ATOM   1186  CA  ALA    79      -9.272  -4.897   0.935  1.00 74.43           C  
ATOM   1187  C   ALA    79      -8.351  -5.982   0.396  1.00 62.11           C  
ATOM   1188  O   ALA    79      -8.807  -6.953  -0.212  1.00 60.22           O  
ATOM   1189  CB  ALA    79     -10.306  -5.489   1.880  1.00 15.01           C  
ATOM   1190  H   ALA    79     -10.743  -4.584  -0.546  1.00 24.21           H  
ATOM   1191  HA  ALA    79      -8.683  -4.177   1.484  1.00 62.25           H  
ATOM   1192  HB1 ALA    79     -10.983  -4.712   2.204  1.00 36.92           H  
ATOM   1193  HB2 ALA    79      -9.808  -5.914   2.739  1.00 36.92           H  
ATOM   1194  HB3 ALA    79     -10.861  -6.260   1.366  1.00 36.92           H  
ATOM   1195  N   PHE    80      -7.057  -5.796   0.603  1.00 44.11           N  
ATOM   1196  CA  PHE    80      -6.057  -6.747   0.142  1.00 65.22           C  
ATOM   1197  C   PHE    80      -5.550  -7.596   1.296  1.00 14.33           C  
ATOM   1198  O   PHE    80      -4.884  -7.094   2.201  1.00 43.53           O  
ATOM   1199  CB  PHE    80      -4.882  -6.015  -0.511  1.00 62.23           C  
ATOM   1200  CG  PHE    80      -5.197  -5.424  -1.857  1.00 12.12           C  
ATOM   1201  CD1 PHE    80      -5.026  -6.170  -3.012  1.00 64.12           C  
ATOM   1202  CD2 PHE    80      -5.660  -4.122  -1.965  1.00  1.25           C  
ATOM   1203  CE1 PHE    80      -5.311  -5.628  -4.251  1.00 23.20           C  
ATOM   1204  CE2 PHE    80      -5.946  -3.576  -3.201  1.00  1.44           C  
ATOM   1205  CZ  PHE    80      -5.771  -4.330  -4.345  1.00  4.21           C  
ATOM   1206  H   PHE    80      -6.763  -4.991   1.089  1.00 31.51           H  
ATOM   1207  HA  PHE    80      -6.522  -7.392  -0.587  1.00 30.54           H  
ATOM   1208  HB2 PHE    80      -4.570  -5.208   0.137  1.00 36.92           H  
ATOM   1209  HB3 PHE    80      -4.060  -6.704  -0.630  1.00 36.92           H  
ATOM   1210  HD1 PHE    80      -4.665  -7.186  -2.938  1.00 24.45           H  
ATOM   1211  HD2 PHE    80      -5.796  -3.530  -1.071  1.00 14.34           H  
ATOM   1212  HE1 PHE    80      -5.173  -6.219  -5.144  1.00 34.43           H  
ATOM   1213  HE2 PHE    80      -6.304  -2.561  -3.272  1.00 24.03           H  
ATOM   1214  HZ  PHE    80      -5.994  -3.904  -5.312  1.00 75.03           H  
ATOM   1215  N   THR    81      -5.864  -8.881   1.257  1.00 11.34           N  
ATOM   1216  CA  THR    81      -5.431  -9.800   2.291  1.00 63.13           C  
ATOM   1217  C   THR    81      -4.085 -10.406   1.929  1.00 62.21           C  
ATOM   1218  O   THR    81      -3.996 -11.274   1.055  1.00  1.30           O  
ATOM   1219  CB  THR    81      -6.464 -10.927   2.510  1.00 55.42           C  
ATOM   1220  OG1 THR    81      -7.730 -10.360   2.875  1.00 23.22           O  
ATOM   1221  CG2 THR    81      -6.002 -11.887   3.599  1.00 51.14           C  
ATOM   1222  H   THR    81      -6.388  -9.224   0.497  1.00 23.55           H  
ATOM   1223  HA  THR    81      -5.332  -9.244   3.212  1.00 12.00           H  
ATOM   1224  HB  THR    81      -6.579 -11.477   1.588  1.00 64.32           H  
ATOM   1225  HG1 THR    81      -7.582  -9.605   3.458  1.00 42.21           H  
ATOM   1226 HG21 THR    81      -5.911 -11.354   4.534  1.00 36.92           H  
ATOM   1227 HG22 THR    81      -5.043 -12.302   3.327  1.00 36.92           H  
ATOM   1228 HG23 THR    81      -6.722 -12.686   3.706  1.00 36.92           H  
ATOM   1229  N   PHE    82      -3.041  -9.929   2.585  1.00 30.33           N  
ATOM   1230  CA  PHE    82      -1.705 -10.441   2.361  1.00 25.52           C  
ATOM   1231  C   PHE    82      -1.409 -11.577   3.328  1.00 12.33           C  
ATOM   1232  O   PHE    82      -2.144 -11.791   4.296  1.00 63.14           O  
ATOM   1233  CB  PHE    82      -0.672  -9.324   2.523  1.00 61.22           C  
ATOM   1234  CG  PHE    82      -0.754  -8.263   1.458  1.00 34.50           C  
ATOM   1235  CD1 PHE    82      -0.074  -8.414   0.261  1.00  4.42           C  
ATOM   1236  CD2 PHE    82      -1.509  -7.119   1.654  1.00  5.35           C  
ATOM   1237  CE1 PHE    82      -0.145  -7.445  -0.720  1.00  1.34           C  
ATOM   1238  CE2 PHE    82      -1.584  -6.144   0.676  1.00 14.24           C  
ATOM   1239  CZ  PHE    82      -0.901  -6.309  -0.512  1.00 62.53           C  
ATOM   1240  H   PHE    82      -3.173  -9.213   3.242  1.00 62.12           H  
ATOM   1241  HA  PHE    82      -1.660 -10.821   1.350  1.00 14.25           H  
ATOM   1242  HB2 PHE    82      -0.819  -8.846   3.479  1.00 36.92           H  
ATOM   1243  HB3 PHE    82       0.320  -9.754   2.491  1.00 36.92           H  
ATOM   1244  HD1 PHE    82       0.517  -9.302   0.095  1.00  5.41           H  
ATOM   1245  HD2 PHE    82      -2.044  -6.991   2.584  1.00 23.51           H  
ATOM   1246  HE1 PHE    82       0.391  -7.574  -1.648  1.00 60.10           H  
ATOM   1247  HE2 PHE    82      -2.177  -5.255   0.840  1.00 64.21           H  
ATOM   1248  HZ  PHE    82      -0.959  -5.549  -1.279  1.00  4.14           H  
ATOM   1249  N   SER    83      -0.337 -12.299   3.069  1.00 75.03           N  
ATOM   1250  CA  SER    83       0.052 -13.409   3.916  1.00 22.32           C  
ATOM   1251  C   SER    83       1.024 -12.920   4.983  1.00 34.44           C  
ATOM   1252  O   SER    83       1.085 -13.455   6.088  1.00 72.02           O  
ATOM   1253  CB  SER    83       0.691 -14.510   3.071  1.00 42.15           C  
ATOM   1254  OG  SER    83      -0.133 -14.842   1.963  1.00 71.23           O  
ATOM   1255  H   SER    83       0.229 -12.062   2.292  1.00 64.54           H  
ATOM   1256  HA  SER    83      -0.834 -13.794   4.396  1.00 51.32           H  
ATOM   1257  HB2 SER    83       1.648 -14.171   2.703  1.00 36.92           H  
ATOM   1258  HB3 SER    83       0.830 -15.392   3.677  1.00 36.92           H  
ATOM   1259  HG  SER    83      -0.148 -14.102   1.347  1.00 63.13           H  
ATOM   1260  N   CYS    84       1.768 -11.880   4.646  1.00 14.33           N  
ATOM   1261  CA  CYS    84       2.748 -11.314   5.552  1.00  3.35           C  
ATOM   1262  C   CYS    84       2.442  -9.840   5.777  1.00 24.12           C  
ATOM   1263  O   CYS    84       1.700  -9.231   5.006  1.00 12.23           O  
ATOM   1264  CB  CYS    84       4.150 -11.465   4.959  1.00 32.54           C  
ATOM   1265  SG  CYS    84       4.440 -13.051   4.143  1.00 64.32           S  
ATOM   1266  H   CYS    84       1.647 -11.474   3.759  1.00 21.02           H  
ATOM   1267  HA  CYS    84       2.692 -11.842   6.493  1.00 43.40           H  
ATOM   1268  HB2 CYS    84       4.306 -10.687   4.228  1.00 36.92           H  
ATOM   1269  HB3 CYS    84       4.878 -11.362   5.750  1.00 36.92           H  
ATOM   1270  HG  CYS    84       4.291 -12.861   2.833  1.00  5.21           H  
ATOM   1271  N   GLN    85       3.009  -9.260   6.820  1.00 12.02           N  
ATOM   1272  CA  GLN    85       2.841  -7.837   7.060  1.00 45.42           C  
ATOM   1273  C   GLN    85       3.818  -7.049   6.206  1.00 45.23           C  
ATOM   1274  O   GLN    85       3.514  -5.945   5.759  1.00 72.34           O  
ATOM   1275  CB  GLN    85       3.032  -7.499   8.537  1.00 24.10           C  
ATOM   1276  CG  GLN    85       2.939  -6.011   8.832  1.00  4.41           C  
ATOM   1277  CD  GLN    85       2.667  -5.733  10.293  1.00 20.40           C  
ATOM   1278  OE1 GLN    85       3.589  -5.561  11.091  1.00  4.15           O  
ATOM   1279  NE2 GLN    85       1.395  -5.704  10.653  1.00  4.11           N  
ATOM   1280  H   GLN    85       3.551  -9.800   7.444  1.00 33.03           H  
ATOM   1281  HA  GLN    85       1.835  -7.572   6.768  1.00 11.14           H  
ATOM   1282  HB2 GLN    85       2.272  -8.005   9.112  1.00 36.92           H  
ATOM   1283  HB3 GLN    85       4.005  -7.848   8.852  1.00 36.92           H  
ATOM   1284  HG2 GLN    85       3.874  -5.544   8.559  1.00 36.92           H  
ATOM   1285  HG3 GLN    85       2.143  -5.586   8.240  1.00 36.92           H  
ATOM   1286 HE21 GLN    85       0.712  -5.861   9.963  1.00 36.92           H  
ATOM   1287 HE22 GLN    85       1.182  -5.534  11.599  1.00 36.92           H  
ATOM   1288  N   ALA    86       4.986  -7.639   5.971  1.00 43.40           N  
ATOM   1289  CA  ALA    86       6.013  -7.022   5.140  1.00  1.11           C  
ATOM   1290  C   ALA    86       5.460  -6.660   3.767  1.00 11.02           C  
ATOM   1291  O   ALA    86       5.602  -5.530   3.312  1.00 13.21           O  
ATOM   1292  CB  ALA    86       7.207  -7.954   5.003  1.00 60.14           C  
ATOM   1293  H   ALA    86       5.170  -8.508   6.384  1.00 20.34           H  
ATOM   1294  HA  ALA    86       6.343  -6.120   5.635  1.00 44.00           H  
ATOM   1295  HB1 ALA    86       6.904  -8.855   4.491  1.00 36.92           H  
ATOM   1296  HB2 ALA    86       7.582  -8.205   5.984  1.00 36.92           H  
ATOM   1297  HB3 ALA    86       7.982  -7.461   4.437  1.00 36.92           H  
ATOM   1298  N   GLU    87       4.804  -7.620   3.128  1.00 34.24           N  
ATOM   1299  CA  GLU    87       4.230  -7.407   1.802  1.00 53.14           C  
ATOM   1300  C   GLU    87       3.065  -6.412   1.851  1.00  2.12           C  
ATOM   1301  O   GLU    87       2.774  -5.740   0.863  1.00  2.04           O  
ATOM   1302  CB  GLU    87       3.792  -8.742   1.188  1.00 73.41           C  
ATOM   1303  CG  GLU    87       3.017  -9.630   2.144  1.00 12.24           C  
ATOM   1304  CD  GLU    87       2.751 -11.017   1.585  1.00 31.21           C  
ATOM   1305  OE1 GLU    87       3.725 -11.734   1.274  1.00 33.21           O  
ATOM   1306  OE2 GLU    87       1.570 -11.395   1.471  1.00 44.22           O  
ATOM   1307  H   GLU    87       4.705  -8.495   3.554  1.00 34.13           H  
ATOM   1308  HA  GLU    87       5.008  -6.984   1.182  1.00 52.24           H  
ATOM   1309  HB2 GLU    87       3.165  -8.540   0.332  1.00 36.92           H  
ATOM   1310  HB3 GLU    87       4.670  -9.279   0.861  1.00 36.92           H  
ATOM   1311  HG2 GLU    87       3.582  -9.732   3.058  1.00 36.92           H  
ATOM   1312  HG3 GLU    87       2.069  -9.159   2.359  1.00 36.92           H  
ATOM   1313  N   MET    88       2.413  -6.310   3.006  1.00 52.33           N  
ATOM   1314  CA  MET    88       1.300  -5.382   3.176  1.00 24.23           C  
ATOM   1315  C   MET    88       1.807  -3.942   3.255  1.00 14.41           C  
ATOM   1316  O   MET    88       1.372  -3.077   2.493  1.00  0.21           O  
ATOM   1317  CB  MET    88       0.490  -5.743   4.433  1.00 34.40           C  
ATOM   1318  CG  MET    88      -0.783  -4.924   4.616  1.00 60.15           C  
ATOM   1319  SD  MET    88      -0.493  -3.301   5.350  1.00  0.12           S  
ATOM   1320  CE  MET    88       0.031  -3.759   7.002  1.00 21.04           C  
ATOM   1321  H   MET    88       2.688  -6.870   3.759  1.00 35.21           H  
ATOM   1322  HA  MET    88       0.660  -5.473   2.309  1.00 72.13           H  
ATOM   1323  HB2 MET    88       0.211  -6.785   4.378  1.00 36.92           H  
ATOM   1324  HB3 MET    88       1.114  -5.594   5.303  1.00 36.92           H  
ATOM   1325  HG2 MET    88      -1.245  -4.783   3.649  1.00 36.92           H  
ATOM   1326  HG3 MET    88      -1.457  -5.476   5.254  1.00 36.92           H  
ATOM   1327  HE1 MET    88       0.905  -4.392   6.940  1.00 36.92           H  
ATOM   1328  HE2 MET    88      -0.767  -4.293   7.497  1.00 36.92           H  
ATOM   1329  HE3 MET    88       0.270  -2.868   7.564  1.00 36.92           H  
ATOM   1330  N   ILE    89       2.745  -3.695   4.163  1.00 35.42           N  
ATOM   1331  CA  ILE    89       3.269  -2.353   4.375  1.00 43.20           C  
ATOM   1332  C   ILE    89       3.995  -1.816   3.142  1.00 61.45           C  
ATOM   1333  O   ILE    89       3.833  -0.649   2.794  1.00 55.34           O  
ATOM   1334  CB  ILE    89       4.210  -2.290   5.596  1.00 34.31           C  
ATOM   1335  CG1 ILE    89       5.259  -3.401   5.532  1.00 51.41           C  
ATOM   1336  CG2 ILE    89       3.407  -2.386   6.884  1.00 41.33           C  
ATOM   1337  CD1 ILE    89       6.361  -3.268   6.558  1.00  5.14           C  
ATOM   1338  H   ILE    89       3.084  -4.429   4.713  1.00 34.24           H  
ATOM   1339  HA  ILE    89       2.425  -1.709   4.579  1.00  1.23           H  
ATOM   1340  HB  ILE    89       4.707  -1.335   5.584  1.00 43.22           H  
ATOM   1341 HG12 ILE    89       4.773  -4.350   5.696  1.00 36.92           H  
ATOM   1342 HG13 ILE    89       5.712  -3.401   4.555  1.00 36.92           H  
ATOM   1343 HG21 ILE    89       4.077  -2.342   7.730  1.00 36.92           H  
ATOM   1344 HG22 ILE    89       2.866  -3.320   6.900  1.00 36.92           H  
ATOM   1345 HG23 ILE    89       2.709  -1.564   6.934  1.00 36.92           H  
ATOM   1346 HD11 ILE    89       6.888  -2.337   6.402  1.00 36.92           H  
ATOM   1347 HD12 ILE    89       7.050  -4.093   6.455  1.00 36.92           H  
ATOM   1348 HD13 ILE    89       5.933  -3.276   7.549  1.00 36.92           H  
ATOM   1349  N   ILE    90       4.778  -2.659   2.470  1.00 32.24           N  
ATOM   1350  CA  ILE    90       5.503  -2.224   1.282  1.00 31.31           C  
ATOM   1351  C   ILE    90       4.533  -1.885   0.152  1.00 73.11           C  
ATOM   1352  O   ILE    90       4.821  -1.042  -0.700  1.00  4.12           O  
ATOM   1353  CB  ILE    90       6.558  -3.259   0.815  1.00 23.53           C  
ATOM   1354  CG1 ILE    90       5.924  -4.601   0.429  1.00 33.53           C  
ATOM   1355  CG2 ILE    90       7.607  -3.464   1.899  1.00 34.14           C  
ATOM   1356  CD1 ILE    90       5.578  -4.718  -1.040  1.00 53.43           C  
ATOM   1357  H   ILE    90       4.876  -3.585   2.779  1.00 55.43           H  
ATOM   1358  HA  ILE    90       6.030  -1.316   1.548  1.00 52.21           H  
ATOM   1359  HB  ILE    90       7.054  -2.849  -0.047  1.00 40.41           H  
ATOM   1360 HG12 ILE    90       6.612  -5.397   0.668  1.00 36.92           H  
ATOM   1361 HG13 ILE    90       5.014  -4.737   0.996  1.00 36.92           H  
ATOM   1362 HG21 ILE    90       8.068  -2.517   2.141  1.00 36.92           H  
ATOM   1363 HG22 ILE    90       8.361  -4.150   1.545  1.00 36.92           H  
ATOM   1364 HG23 ILE    90       7.137  -3.871   2.782  1.00 36.92           H  
ATOM   1365 HD11 ILE    90       5.115  -5.676  -1.223  1.00 36.92           H  
ATOM   1366 HD12 ILE    90       6.479  -4.634  -1.631  1.00 36.92           H  
ATOM   1367 HD13 ILE    90       4.893  -3.929  -1.311  1.00 36.92           H  
ATOM   1368  N   PHE    91       3.384  -2.548   0.152  1.00 12.44           N  
ATOM   1369  CA  PHE    91       2.319  -2.246  -0.793  1.00  4.12           C  
ATOM   1370  C   PHE    91       1.830  -0.816  -0.570  1.00 34.42           C  
ATOM   1371  O   PHE    91       1.723  -0.035  -1.515  1.00 51.31           O  
ATOM   1372  CB  PHE    91       1.172  -3.249  -0.628  1.00  3.51           C  
ATOM   1373  CG  PHE    91       0.042  -3.069  -1.600  1.00 12.43           C  
ATOM   1374  CD1 PHE    91       0.213  -3.358  -2.942  1.00 64.41           C  
ATOM   1375  CD2 PHE    91      -1.193  -2.620  -1.168  1.00  2.12           C  
ATOM   1376  CE1 PHE    91      -0.827  -3.202  -3.837  1.00  1.12           C  
ATOM   1377  CE2 PHE    91      -2.238  -2.463  -2.057  1.00 51.23           C  
ATOM   1378  CZ  PHE    91      -2.054  -2.754  -3.393  1.00 33.21           C  
ATOM   1379  H   PHE    91       3.248  -3.261   0.810  1.00 34.24           H  
ATOM   1380  HA  PHE    91       2.723  -2.328  -1.791  1.00 22.42           H  
ATOM   1381  HB2 PHE    91       1.560  -4.248  -0.757  1.00 36.92           H  
ATOM   1382  HB3 PHE    91       0.769  -3.155   0.370  1.00 36.92           H  
ATOM   1383  HD1 PHE    91       1.172  -3.709  -3.289  1.00 41.40           H  
ATOM   1384  HD2 PHE    91      -1.335  -2.391  -0.122  1.00 71.30           H  
ATOM   1385  HE1 PHE    91      -0.679  -3.430  -4.882  1.00 71.31           H  
ATOM   1386  HE2 PHE    91      -3.198  -2.112  -1.706  1.00 41.33           H  
ATOM   1387  HZ  PHE    91      -2.869  -2.633  -4.092  1.00 14.52           H  
ATOM   1388  N   GLU    92       1.566  -0.479   0.693  1.00 60.31           N  
ATOM   1389  CA  GLU    92       1.198   0.884   1.079  1.00 10.41           C  
ATOM   1390  C   GLU    92       2.265   1.883   0.648  1.00 35.53           C  
ATOM   1391  O   GLU    92       1.952   2.971   0.162  1.00 73.23           O  
ATOM   1392  CB  GLU    92       0.999   0.976   2.593  1.00 11.32           C  
ATOM   1393  CG  GLU    92      -0.192   0.187   3.105  1.00 64.52           C  
ATOM   1394  CD  GLU    92      -1.510   0.842   2.735  1.00 54.45           C  
ATOM   1395  OE1 GLU    92      -1.816   1.931   3.280  1.00 62.31           O  
ATOM   1396  OE2 GLU    92      -2.236   0.284   1.889  1.00 51.03           O  
ATOM   1397  H   GLU    92       1.610  -1.172   1.387  1.00 65.03           H  
ATOM   1398  HA  GLU    92       0.270   1.131   0.588  1.00 64.10           H  
ATOM   1399  HB2 GLU    92       1.887   0.604   3.083  1.00 36.92           H  
ATOM   1400  HB3 GLU    92       0.860   2.015   2.862  1.00 36.92           H  
ATOM   1401  HG2 GLU    92      -0.164  -0.803   2.672  1.00 36.92           H  
ATOM   1402  HG3 GLU    92      -0.125   0.109   4.181  1.00 36.92           H  
ATOM   1403  N   LEU    93       3.524   1.505   0.827  1.00 14.44           N  
ATOM   1404  CA  LEU    93       4.640   2.349   0.424  1.00 24.34           C  
ATOM   1405  C   LEU    93       4.606   2.583  -1.085  1.00 52.55           C  
ATOM   1406  O   LEU    93       4.647   3.724  -1.550  1.00 74.11           O  
ATOM   1407  CB  LEU    93       5.964   1.700   0.832  1.00  3.13           C  
ATOM   1408  CG  LEU    93       6.067   1.306   2.306  1.00 35.43           C  
ATOM   1409  CD1 LEU    93       7.460   0.789   2.622  1.00 62.01           C  
ATOM   1410  CD2 LEU    93       5.712   2.481   3.203  1.00 24.35           C  
ATOM   1411  H   LEU    93       3.706   0.635   1.248  1.00 15.41           H  
ATOM   1412  HA  LEU    93       4.539   3.298   0.929  1.00 74.31           H  
ATOM   1413  HB2 LEU    93       6.102   0.811   0.235  1.00 36.92           H  
ATOM   1414  HB3 LEU    93       6.764   2.391   0.610  1.00 36.92           H  
ATOM   1415  HG  LEU    93       5.364   0.510   2.507  1.00 55.25           H  
ATOM   1416 HD11 LEU    93       8.183   1.571   2.441  1.00 36.92           H  
ATOM   1417 HD12 LEU    93       7.681  -0.058   1.991  1.00 36.92           H  
ATOM   1418 HD13 LEU    93       7.506   0.487   3.659  1.00 36.92           H  
ATOM   1419 HD21 LEU    93       5.766   2.175   4.236  1.00 36.92           H  
ATOM   1420 HD22 LEU    93       4.710   2.818   2.978  1.00 36.92           H  
ATOM   1421 HD23 LEU    93       6.409   3.289   3.031  1.00 36.92           H  
ATOM   1422  N   SER    94       4.526   1.491  -1.834  1.00  0.42           N  
ATOM   1423  CA  SER    94       4.378   1.541  -3.285  1.00 43.13           C  
ATOM   1424  C   SER    94       3.182   2.409  -3.695  1.00 14.02           C  
ATOM   1425  O   SER    94       3.272   3.188  -4.643  1.00  4.35           O  
ATOM   1426  CB  SER    94       4.212   0.120  -3.833  1.00  2.31           C  
ATOM   1427  OG  SER    94       5.285  -0.711  -3.419  1.00 23.35           O  
ATOM   1428  H   SER    94       4.600   0.614  -1.398  1.00 60.22           H  
ATOM   1429  HA  SER    94       5.278   1.972  -3.695  1.00  1.32           H  
ATOM   1430  HB2 SER    94       3.288  -0.299  -3.467  1.00 36.92           H  
ATOM   1431  HB3 SER    94       4.192   0.151  -4.913  1.00 36.92           H  
ATOM   1432  HG  SER    94       5.171  -0.947  -2.492  1.00 41.11           H  
ATOM   1433  N   LEU    95       2.070   2.281  -2.972  1.00 65.10           N  
ATOM   1434  CA  LEU    95       0.882   3.091  -3.234  1.00 21.12           C  
ATOM   1435  C   LEU    95       1.207   4.574  -3.106  1.00 64.05           C  
ATOM   1436  O   LEU    95       0.848   5.375  -3.964  1.00  4.22           O  
ATOM   1437  CB  LEU    95      -0.252   2.736  -2.267  1.00 12.15           C  
ATOM   1438  CG  LEU    95      -0.826   1.327  -2.408  1.00 65.30           C  
ATOM   1439  CD1 LEU    95      -1.894   1.083  -1.355  1.00 40.24           C  
ATOM   1440  CD2 LEU    95      -1.397   1.125  -3.799  1.00 22.31           C  
ATOM   1441  H   LEU    95       2.047   1.617  -2.244  1.00 33.15           H  
ATOM   1442  HA  LEU    95       0.561   2.888  -4.246  1.00 51.10           H  
ATOM   1443  HB2 LEU    95       0.116   2.849  -1.258  1.00 36.92           H  
ATOM   1444  HB3 LEU    95      -1.056   3.442  -2.417  1.00 36.92           H  
ATOM   1445  HG  LEU    95      -0.036   0.604  -2.257  1.00 24.45           H  
ATOM   1446 HD11 LEU    95      -2.701   1.789  -1.489  1.00 36.92           H  
ATOM   1447 HD12 LEU    95      -1.466   1.210  -0.372  1.00 36.92           H  
ATOM   1448 HD13 LEU    95      -2.277   0.078  -1.454  1.00 36.92           H  
ATOM   1449 HD21 LEU    95      -2.186   1.842  -3.972  1.00 36.92           H  
ATOM   1450 HD22 LEU    95      -1.793   0.124  -3.886  1.00 36.92           H  
ATOM   1451 HD23 LEU    95      -0.616   1.267  -4.530  1.00 36.92           H  
ATOM   1452  N   ARG    96       1.900   4.920  -2.030  1.00 52.23           N  
ATOM   1453  CA  ARG    96       2.298   6.299  -1.768  1.00 74.33           C  
ATOM   1454  C   ARG    96       3.264   6.810  -2.829  1.00 44.22           C  
ATOM   1455  O   ARG    96       3.304   8.001  -3.123  1.00 53.24           O  
ATOM   1456  CB  ARG    96       2.932   6.407  -0.385  1.00 63.10           C  
ATOM   1457  CG  ARG    96       1.926   6.265   0.735  1.00 54.05           C  
ATOM   1458  CD  ARG    96       2.605   6.167   2.084  1.00 63.12           C  
ATOM   1459  NE  ARG    96       3.512   7.289   2.341  1.00 62.44           N  
ATOM   1460  CZ  ARG    96       4.058   7.550   3.530  1.00 22.01           C  
ATOM   1461  NH1 ARG    96       3.766   6.797   4.586  1.00  1.44           N  
ATOM   1462  NH2 ARG    96       4.889   8.573   3.660  1.00 42.11           N  
ATOM   1463  H   ARG    96       2.154   4.221  -1.385  1.00 51.31           H  
ATOM   1464  HA  ARG    96       1.407   6.904  -1.783  1.00 74.33           H  
ATOM   1465  HB2 ARG    96       3.676   5.630  -0.276  1.00 36.92           H  
ATOM   1466  HB3 ARG    96       3.411   7.371  -0.292  1.00 36.92           H  
ATOM   1467  HG2 ARG    96       1.272   7.125   0.731  1.00 36.92           H  
ATOM   1468  HG3 ARG    96       1.345   5.370   0.569  1.00 36.92           H  
ATOM   1469  HD2 ARG    96       1.843   6.152   2.842  1.00 36.92           H  
ATOM   1470  HD3 ARG    96       3.167   5.247   2.120  1.00 36.92           H  
ATOM   1471  HE  ARG    96       3.735   7.874   1.582  1.00 72.43           H  
ATOM   1472 HH11 ARG    96       3.136   6.026   4.496  1.00 36.92           H  
ATOM   1473 HH12 ARG    96       4.172   7.001   5.487  1.00 36.92           H  
ATOM   1474 HH21 ARG    96       5.105   9.149   2.864  1.00 36.92           H  
ATOM   1475 HH22 ARG    96       5.317   8.773   4.556  1.00 36.92           H  
ATOM   1476  N   SER    97       4.043   5.903  -3.390  1.00 72.43           N  
ATOM   1477  CA  SER    97       5.027   6.261  -4.398  1.00 45.52           C  
ATOM   1478  C   SER    97       4.378   6.420  -5.779  1.00 73.23           C  
ATOM   1479  O   SER    97       4.681   7.365  -6.510  1.00 53.10           O  
ATOM   1480  CB  SER    97       6.126   5.194  -4.444  1.00 74.24           C  
ATOM   1481  OG  SER    97       7.168   5.554  -5.335  1.00 11.23           O  
ATOM   1482  H   SER    97       3.963   4.965  -3.112  1.00  1.44           H  
ATOM   1483  HA  SER    97       5.467   7.203  -4.109  1.00 55.10           H  
ATOM   1484  HB2 SER    97       6.544   5.070  -3.457  1.00 36.92           H  
ATOM   1485  HB3 SER    97       5.697   4.259  -4.770  1.00 36.92           H  
ATOM   1486  HG  SER    97       7.251   6.522  -5.360  1.00 50.13           H  
ATOM   1487  N   LEU    98       3.481   5.505  -6.130  1.00 34.54           N  
ATOM   1488  CA  LEU    98       2.902   5.485  -7.469  1.00 34.41           C  
ATOM   1489  C   LEU    98       1.629   6.318  -7.543  1.00  1.11           C  
ATOM   1490  O   LEU    98       1.524   7.239  -8.354  1.00 72.25           O  
ATOM   1491  CB  LEU    98       2.597   4.050  -7.893  1.00 12.30           C  
ATOM   1492  CG  LEU    98       2.422   3.854  -9.401  1.00 10.13           C  
ATOM   1493  CD1 LEU    98       3.708   4.199 -10.134  1.00 33.50           C  
ATOM   1494  CD2 LEU    98       1.994   2.431  -9.713  1.00 62.21           C  
ATOM   1495  H   LEU    98       3.208   4.822  -5.477  1.00 62.32           H  
ATOM   1496  HA  LEU    98       3.630   5.901  -8.150  1.00 63.01           H  
ATOM   1497  HB2 LEU    98       3.398   3.419  -7.549  1.00 36.92           H  
ATOM   1498  HB3 LEU    98       1.685   3.740  -7.406  1.00 36.92           H  
ATOM   1499  HG  LEU    98       1.649   4.521  -9.756  1.00 15.40           H  
ATOM   1500 HD11 LEU    98       3.963   5.231  -9.946  1.00 36.92           H  
ATOM   1501 HD12 LEU    98       3.570   4.049 -11.194  1.00 36.92           H  
ATOM   1502 HD13 LEU    98       4.506   3.562  -9.781  1.00 36.92           H  
ATOM   1503 HD21 LEU    98       1.892   2.312 -10.782  1.00 36.92           H  
ATOM   1504 HD22 LEU    98       1.046   2.229  -9.237  1.00 36.92           H  
ATOM   1505 HD23 LEU    98       2.738   1.741  -9.344  1.00 36.92           H  
ATOM   1506  N   ALA    99       0.664   5.990  -6.698  1.00 63.54           N  
ATOM   1507  CA  ALA    99      -0.616   6.682  -6.705  1.00 23.02           C  
ATOM   1508  C   ALA    99      -0.475   8.024  -6.008  1.00  2.43           C  
ATOM   1509  O   ALA    99      -1.050   9.024  -6.441  1.00 53.01           O  
ATOM   1510  CB  ALA    99      -1.689   5.832  -6.036  1.00 72.13           C  
ATOM   1511  H   ALA    99       0.825   5.286  -6.033  1.00 42.21           H  
ATOM   1512  HA  ALA    99      -0.902   6.846  -7.734  1.00 51.33           H  
ATOM   1513  HB1 ALA    99      -1.413   5.645  -5.008  1.00 36.92           H  
ATOM   1514  HB2 ALA    99      -1.784   4.893  -6.560  1.00 36.92           H  
ATOM   1515  HB3 ALA    99      -2.634   6.356  -6.064  1.00 36.92           H  
END
