
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  121 (  992),  selected  121 , name 2nxb_B
# Molecule2: number of CA atoms  130 ( 1064),  selected  130 , name T0432.pdb
# PARAMETERS: 2nxb_B.T0432.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M    23_B      S       1           -
LGA    P    24_B      M       2           -
LGA    E    25_B      Q       3           -
LGA    V    26_B      E       4           -
LGA    S    27_B      -       -           -
LGA    N    28_B      -       -           -
LGA    P    29_B      -       -           -
LGA    S    30_B      -       -           -
LGA    K    31_B      -       -           -
LGA    P    32_B      -       -           -
LGA    G    33_B      -       -           -
LGA    R    34_B      E       5           #
LGA    -       -      D       6           -
LGA    -       -      T       7           -
LGA    K    35_B      F       8          2.731
LGA    T    36_B      R       9          4.323
LGA    N    37_B      E      10          3.350
LGA    Q    38_B      L      11          3.555
LGA    L    39_B      R      12          3.591
LGA    Q    40_B      I      13          2.584
LGA    Y    41_B      F      14          1.907
LGA    M    42_B      L      15          1.947
LGA    Q    43_B      R      16          1.633
LGA    N    44_B      N      17          1.304
LGA    V    45_B      V      18          2.572
LGA    V    46_B      -       -           -
LGA    V    47_B      T      19          0.607
LGA    K    48_B      H      20          1.525
LGA    T    49_B      R      21          1.181
LGA    L    50_B      L      22          0.441
LGA    W    51_B      A      23          1.053
LGA    K    52_B      I      24          1.406
LGA    H    53_B      D      25          0.558
LGA    Q    54_B      K      26          0.535
LGA    F    55_B      R      27          1.638
LGA    A    56_B      F      28          2.004
LGA    W    57_B      R      29          1.641
LGA    P    58_B      V      30          1.357
LGA    F    59_B      F      31          1.318
LGA    Y    60_B      T      32          1.457
LGA    Q    61_B      K      33          1.425
LGA    P    62_B      P      34          0.938
LGA    V    63_B      V      35          1.302
LGA    D    64_B      D      36          1.516
LGA    A    65_B      P      37          3.601
LGA    I    66_B      D      38          2.178
LGA    K    67_B      E      39          1.271
LGA    L    68_B      V      40          3.765
LGA    N    69_B      -       -           -
LGA    L    70_B      -       -           -
LGA    P    71_B      P      41          3.757
LGA    D    72_B      D      42          2.656
LGA    Y    73_B      Y      43          1.903
LGA    H    74_B      V      44          1.864
LGA    K    75_B      T      45          1.777
LGA    I    76_B      V      46          1.649
LGA    I    77_B      I      47          0.735
LGA    K    78_B      K      48          0.427
LGA    N    79_B      Q      49          0.926
LGA    P    80_B      P      50          0.951
LGA    M    81_B      M      51          0.698
LGA    D    82_B      D      52          0.734
LGA    M    83_B      L      53          0.563
LGA    G    84_B      S      54          0.235
LGA    T    85_B      S      55          0.512
LGA    I    86_B      V      56          0.277
LGA    K    87_B      I      57          0.765
LGA    K    88_B      S      58          1.217
LGA    R    89_B      K      59          1.354
LGA    L    90_B      I      60          1.409
LGA    E    91_B      D      61          2.523
LGA    N    92_B      L      62          3.069
LGA    N    93_B      H      63          2.664
LGA    Y    94_B      K      64          2.959
LGA    Y    95_B      Y      65          2.188
LGA    W    96_B      L      66          1.863
LGA    S    97_B      T      67          1.870
LGA    A    98_B      V      68          2.006
LGA    S    99_B      K      69          1.475
LGA    E   100_B      D      70          1.249
LGA    C   101_B      Y      71          1.016
LGA    M   102_B      L      72          0.863
LGA    Q   103_B      R      73          0.869
LGA    D   104_B      D      74          0.784
LGA    F   105_B      I      75          0.756
LGA    N   106_B      D      76          0.740
LGA    T   107_B      L      77          0.859
LGA    M   108_B      I      78          0.992
LGA    F   109_B      C      79          0.639
LGA    T   110_B      S      80          0.485
LGA    N   111_B      N      81          0.554
LGA    C   112_B      A      82          0.582
LGA    Y   113_B      L      83          0.552
LGA    I   114_B      E      84          0.874
LGA    Y   115_B      Y      85          1.067
LGA    N   116_B      N      86          0.441
LGA    K   117_B      P      87          2.337
LGA    -       -      D      88           -
LGA    P   118_B      R      89          5.451
LGA    T   119_B      D      90          4.846
LGA    -       -      P      91           -
LGA    -       -      G      92           -
LGA    -       -      D      93           -
LGA    D   120_B      R      94          3.183
LGA    D   121_B      L      95          2.461
LGA    I   122_B      I      96          1.719
LGA    V   123_B      R      97          1.544
LGA    L   124_B      H      98          2.109
LGA    M   125_B      R      99          1.936
LGA    A   126_B      A     100          1.460
LGA    Q   127_B      C     101          2.109
LGA    A   128_B      A     102          2.306
LGA    L   129_B      L     103          1.689
LGA    E   130_B      R     104          1.845
LGA    K   131_B      D     105          2.222
LGA    I   132_B      T     106          1.033
LGA    F   133_B      A     107          1.171
LGA    L   134_B      Y     108          1.759
LGA    Q   135_B      A     109          0.960
LGA    K   136_B      I     110          0.839
LGA    V   137_B      I     111          1.963
LGA    A   138_B      K     112          1.265
LGA    Q   139_B      E     113          1.690
LGA    M   140_B      E     114          3.650
LGA    P   141_B      L     115          2.436
LGA    -       -      D     116           -
LGA    Q   142_B      E     117          2.049
LGA    E   143_B      D     118          3.859
LGA    -       -      F     119           -
LGA    -       -      E     120           -
LGA    -       -      Q     121           -
LGA    -       -      L     122           -
LGA    -       -      C     123           -
LGA    -       -      E     124           -
LGA    -       -      E     125           -
LGA    -       -      I     126           -
LGA    -       -      Q     127           -
LGA    -       -      E     128           -
LGA    -       -      S     129           -
LGA    -       -      R     130           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  121  130    5.0    106    1.99    22.64     71.681     5.060

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.705872 * X  +   0.435358 * Y  +  -0.558756 * Z  +   6.786092
  Y_new =   0.686527 * X  +  -0.226235 * Y  +   0.691012 * Z  +  34.133369
  Z_new =   0.174428 * X  +  -0.871367 * Y  +  -0.458578 * Z  +  13.527241 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.055242    1.086351  [ DEG:  -117.7567     62.2433 ]
  Theta =  -0.175325   -2.966268  [ DEG:   -10.0454   -169.9546 ]
  Phi   =   0.771506   -2.370087  [ DEG:    44.2040   -135.7960 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2nxb_B                                        
REMARK     2: T0432.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2nxb_B.T0432.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  121  130   5.0  106   1.99   22.64  71.681
REMARK  ---------------------------------------------------------- 
MOLECULE 2nxb_B
HEADER    SIGNALING PROTEIN                       17-NOV-06   2NXB              
TITLE     CRYSTAL STRUCTURE OF HUMAN BROMODOMAIN CONTAINING PROTEIN 3           
TITLE    2 (BRD3)                                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BROMODOMAIN-CONTAINING PROTEIN 3;                          
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: BROMO 1 DOMAIN;                                            
COMPND   5 SYNONYM: RING3-LIKE PROTEIN;                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: BRD3, KIAA0043, RING3L;                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: ROSETTA-R3;                                
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PNIC28-BSA4                               
KEYWDS    BRD3, BROMODOMAIN CONTAINING PROTEIN 3, ORFX, RING3 LIKE              
KEYWDS   2 GENE, RING3L, STRUCTURAL GENOMICS, STRUCTURAL GENOMICS               
KEYWDS   3 CONSORTIUM, SGC                                                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.FILIPPAKOPOULOS,A.BULLOCK,C.COOPER,K.KEATES,G.BERRIDGE,             
AUTHOR   2 A.PIKE,G.BUNKOCZI,A.EDWARDS,C.ARROWSMITH,M.SUNDSTROM,F.VON           
AUTHOR   3 DELFT,S.KNAPP,STRUCTURAL GENOMICS CONSORTIUM (SGC)                   
REVDAT   1   12-DEC-06 2NXB    0                                                
JRNL        AUTH   P.FILIPPAKOPOULOS,A.BULLOCK,C.COOPER,K.KEATES,               
JRNL        AUTH 2 G.BERRIDGE,A.PIKE,G.BUNKOCZI,A.EDWARDS,                      
JRNL        AUTH 3 C.ARROWSMITH,M.SUNDSTROM,F.VON DELFT,S.KNAPP,                
JRNL        AUTH 4 STRUCTURAL GENOMICS CONSORTIUM (SGC)                         
JRNL        TITL   CRYSTAL STRUCTURE OF HUMAN BROMODOMAIN CONTAINING            
JRNL        TITL 2 PROTEIN 3 (BRD3)                                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.40 ANGSTROMS.                                          
DBREF  2NXB A   24   144  UNP    Q15059   BRD3_HUMAN      24    144             
DBREF  2NXB B   24   144  UNP    Q15059   BRD3_HUMAN      24    144             
SEQRES   1 A  123  SER MET PRO GLU VAL SER ASN PRO SER LYS PRO GLY ARG          
SEQRES   2 A  123  LYS THR ASN GLN LEU GLN TYR MET GLN ASN VAL VAL VAL          
SEQRES   3 A  123  LYS THR LEU TRP LYS HIS GLN PHE ALA TRP PRO PHE TYR          
SEQRES   4 A  123  GLN PRO VAL ASP ALA ILE LYS LEU ASN LEU PRO ASP TYR          
SEQRES   5 A  123  HIS LYS ILE ILE LYS ASN PRO MET ASP MET GLY THR ILE          
SEQRES   6 A  123  LYS LYS ARG LEU GLU ASN ASN TYR TYR TRP SER ALA SER          
SEQRES   7 A  123  GLU CYS MET GLN ASP PHE ASN THR MET PHE THR ASN CYS          
SEQRES   8 A  123  TYR ILE TYR ASN LYS PRO THR ASP ASP ILE VAL LEU MET          
SEQRES   9 A  123  ALA GLN ALA LEU GLU LYS ILE PHE LEU GLN LYS VAL ALA          
SEQRES  10 A  123  GLN MET PRO GLN GLU GLU                                      
SEQRES   1 B  123  SER MET PRO GLU VAL SER ASN PRO SER LYS PRO GLY ARG          
SEQRES   2 B  123  LYS THR ASN GLN LEU GLN TYR MET GLN ASN VAL VAL VAL          
SEQRES   3 B  123  LYS THR LEU TRP LYS HIS GLN PHE ALA TRP PRO PHE TYR          
SEQRES   4 B  123  GLN PRO VAL ASP ALA ILE LYS LEU ASN LEU PRO ASP TYR          
SEQRES   5 B  123  HIS LYS ILE ILE LYS ASN PRO MET ASP MET GLY THR ILE          
SEQRES   6 B  123  LYS LYS ARG LEU GLU ASN ASN TYR TYR TRP SER ALA SER          
SEQRES   7 B  123  GLU CYS MET GLN ASP PHE ASN THR MET PHE THR ASN CYS          
SEQRES   8 B  123  TYR ILE TYR ASN LYS PRO THR ASP ASP ILE VAL LEU MET          
SEQRES   9 B  123  ALA GLN ALA LEU GLU LYS ILE PHE LEU GLN LYS VAL ALA          
SEQRES  10 B  123  GLN MET PRO GLN GLU GLU                                      
HET     NA    301       1                                                       
HET    EDO    302       4                                                       
HET    EDO    303       4                                                       
HET    EDO    304       4                                                       
HET    EDO    305       4                                                       
HET    EDO    306       4                                                       
HET    EDO    307       4                                                       
HET    EDO    308       7                                                       
HETNAM      NA SODIUM ION                                                       
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   3   NA    NA 1+                                                        
FORMUL   4  EDO    7(C2 H6 O2)                                                  
FORMUL  11  HOH   *277(H2 O)                                                    
CRYST1   51.504   61.840   84.523  90.00  90.00  90.00 P 21 21 21    8          
ATOM   1021  N   MET B  23     -12.241  53.204  14.754  1.00 30.69           N  
ATOM   1022  CA  MET B  23     -12.432  53.033  13.291  1.00 30.45           C  
ATOM   1023  C   MET B  23     -11.072  52.674  12.719  1.00 29.44           C  
ATOM   1024  O   MET B  23     -10.133  53.469  12.827  1.00 30.73           O  
ATOM   1025  CB  MET B  23     -12.954  54.333  12.670  1.00 31.35           C  
ATOM   1026  N   PRO B  24     -10.940  51.466  12.128  1.00 27.02           N  
ATOM   1027  CA  PRO B  24      -9.624  51.016  11.701  1.00 25.42           C  
ATOM   1028  C   PRO B  24      -8.961  51.996  10.734  1.00 23.48           C  
ATOM   1029  O   PRO B  24      -9.626  52.575   9.877  1.00 24.30           O  
ATOM   1030  CB  PRO B  24      -9.917  49.683  10.983  1.00 25.65           C  
ATOM   1031  CG  PRO B  24     -11.379  49.618  10.838  1.00 25.52           C  
ATOM   1032  CD  PRO B  24     -11.986  50.472  11.840  1.00 27.46           C  
ATOM   1033  N   GLU B  25      -7.650  52.154  10.863  1.00 21.27           N  
ATOM   1034  CA  GLU B  25      -6.913  53.039   9.964  1.00 20.34           C  
ATOM   1035  C   GLU B  25      -6.869  52.476   8.546  1.00 20.34           C  
ATOM   1036  O   GLU B  25      -6.888  51.258   8.330  1.00 20.71           O  
ATOM   1037  CB  GLU B  25      -5.496  53.275  10.481  1.00 20.62           C  
ATOM   1038  CG  GLU B  25      -4.627  52.059  10.429  1.00 22.41           C  
ATOM   1039  CD  GLU B  25      -3.258  52.236  11.040  1.00 22.61           C  
ATOM   1040  OE1 GLU B  25      -3.000  53.242  11.744  1.00 22.97           O  
ATOM   1041  OE2 GLU B  25      -2.418  51.321  10.817  1.00 23.62           O  
ATOM   1042  N   VAL B  26      -6.773  53.383   7.572  1.00 19.69           N  
ATOM   1043  CA  VAL B  26      -6.594  52.996   6.165  1.00 20.14           C  
ATOM   1044  C   VAL B  26      -5.271  53.476   5.576  1.00 19.92           C  
ATOM   1045  O   VAL B  26      -4.987  53.189   4.426  1.00 20.49           O  
ATOM   1046  CB  VAL B  26      -7.780  53.446   5.272  1.00 20.47           C  
ATOM   1047  CG1 VAL B  26      -9.096  52.814   5.761  1.00 20.12           C  
ATOM   1048  CG2 VAL B  26      -7.890  54.949   5.239  1.00 19.75           C  
ATOM   1049  N   SER B  27      -4.460  54.162   6.390  1.00 20.55           N  
ATOM   1050  CA  SER B  27      -3.166  54.721   5.985  1.00 21.40           C  
ATOM   1051  C   SER B  27      -2.273  54.679   7.221  1.00 20.81           C  
ATOM   1052  O   SER B  27      -2.756  54.901   8.320  1.00 21.60           O  
ATOM   1053  CB  SER B  27      -3.276  56.206   5.550  1.00 21.75           C  
ATOM   1054  OG  SER B  27      -4.155  56.237   4.446  0.70 23.63           O  
ATOM   1056  N   ASN B  28      -0.985  54.433   7.052  1.00 20.36           N  
ATOM   1057  CA  ASN B  28      -0.027  54.502   8.163  1.00 20.52           C  
ATOM   1058  C   ASN B  28       1.357  54.677   7.574  1.00 20.15           C  
ATOM   1059  O   ASN B  28       1.884  53.750   6.967  1.00 20.04           O  
ATOM   1060  CB  ASN B  28      -0.108  53.222   8.986  1.00 20.62           C  
ATOM   1061  CG  ASN B  28       0.798  53.223  10.205  1.00 22.14           C  
ATOM   1062  OD1 ASN B  28       1.832  53.907  10.257  1.00 22.67           O  
ATOM   1063  ND2 ASN B  28       0.418  52.423  11.200  1.00 26.82           N  
ATOM   1064  N   PRO B  29       1.971  55.857   7.758  1.00 20.69           N  
ATOM   1065  CA  PRO B  29       3.268  56.102   7.110  1.00 21.27           C  
ATOM   1066  C   PRO B  29       4.398  55.161   7.554  1.00 21.59           C  
ATOM   1067  O   PRO B  29       5.370  54.985   6.816  1.00 23.17           O  
ATOM   1068  CB  PRO B  29       3.586  57.556   7.480  1.00 21.89           C  
ATOM   1069  CG  PRO B  29       2.760  57.859   8.649  1.00 22.39           C  
ATOM   1070  CD  PRO B  29       1.536  56.997   8.577  1.00 21.12           C  
ATOM   1071  N   SER B  30       4.270  54.570   8.739  1.00 21.72           N  
ATOM   1072  CA  SER B  30       5.282  53.661   9.276  1.00 21.77           C  
ATOM   1073  C   SER B  30       5.163  52.219   8.755  1.00 21.54           C  
ATOM   1074  O   SER B  30       6.107  51.432   8.869  1.00 22.07           O  
ATOM   1075  CB  SER B  30       5.177  53.658  10.813  1.00 21.87           C  
ATOM   1076  OG  SER B  30       5.795  54.872  11.170  0.70 23.72           O  
ATOM   1078  N   LYS B  31       3.994  51.864   8.226  1.00 19.63           N  
ATOM   1079  CA  LYS B  31       3.702  50.478   7.883  1.00 19.71           C  
ATOM   1080  C   LYS B  31       4.020  50.219   6.397  1.00 20.41           C  
ATOM   1081  O   LYS B  31       3.438  50.849   5.522  1.00 20.16           O  
ATOM   1082  CB  LYS B  31       2.226  50.199   8.176  1.00 19.35           C  
ATOM   1083  CG  LYS B  31       1.823  48.760   7.885  1.00 19.39           C  
ATOM   1084  CD  LYS B  31       0.303  48.592   7.963  1.00 18.79           C  
ATOM   1085  CE  LYS B  31      -0.101  47.136   7.884  1.00 19.54           C  
ATOM   1086  NZ  LYS B  31       0.215  46.497   6.557  1.00 20.23           N  
ATOM   1087  N   PRO B  32       4.953  49.306   6.112  1.00 20.60           N  
ATOM   1088  CA  PRO B  32       5.181  48.965   4.704  1.00 20.78           C  
ATOM   1089  C   PRO B  32       3.899  48.515   4.006  1.00 19.90           C  
ATOM   1090  O   PRO B  32       3.094  47.746   4.555  1.00 20.42           O  
ATOM   1091  CB  PRO B  32       6.196  47.819   4.772  1.00 21.23           C  
ATOM   1092  CG  PRO B  32       6.902  48.011   6.112  1.00 21.43           C  
ATOM   1093  CD  PRO B  32       5.853  48.576   7.025  1.00 21.47           C  
ATOM   1094  N   GLY B  33       3.720  49.001   2.798  1.00 19.77           N  
ATOM   1095  CA  GLY B  33       2.586  48.612   1.991  1.00 19.78           C  
ATOM   1096  C   GLY B  33       2.963  48.490   0.544  1.00 20.06           C  
ATOM   1097  O   GLY B  33       3.943  49.097   0.092  1.00 20.20           O  
ATOM   1098  N   ARG B  34       2.181  47.712  -0.201  1.00 20.45           N  
ATOM   1099  CA  ARG B  34       2.487  47.435  -1.600  1.00 20.33           C  
ATOM   1100  C   ARG B  34       1.276  46.848  -2.278  1.00 20.84           C  
ATOM   1101  O   ARG B  34       0.234  46.661  -1.663  1.00 21.28           O  
ATOM   1102  CB  ARG B  34       3.665  46.454  -1.707  1.00 19.73           C  
ATOM   1103  CG  ARG B  34       3.349  45.087  -1.109  1.00 20.59           C  
ATOM   1104  CD  ARG B  34       4.477  44.131  -1.268  1.00 20.15           C  
ATOM   1105  NE  ARG B  34       4.217  42.884  -0.544  1.00 20.61           N  
ATOM   1106  CZ  ARG B  34       4.955  41.782  -0.636  1.00 21.27           C  
ATOM   1107  NH1 ARG B  34       4.615  40.698   0.058  1.00 21.85           N  
ATOM   1108  NH2 ARG B  34       6.048  41.749  -1.385  1.00 21.15           N  
ATOM   1109  N   LYS B  35       1.446  46.527  -3.557  1.00 22.22           N  
ATOM   1110  CA  LYS B  35       0.423  45.841  -4.327  1.00 23.31           C  
ATOM   1111  C   LYS B  35       1.060  44.706  -5.114  1.00 23.56           C  
ATOM   1112  O   LYS B  35       1.700  44.902  -6.133  1.00 25.33           O  
ATOM   1113  CB  LYS B  35      -0.282  46.791  -5.266  1.00 24.05           C  
ATOM   1114  CG  LYS B  35      -1.502  46.195  -5.940  1.00 26.46           C  
ATOM   1115  CD  LYS B  35      -2.279  47.326  -6.585  1.00 28.07           C  
ATOM   1116  CE  LYS B  35      -3.442  46.847  -7.365  1.00 30.97           C  
ATOM   1117  NZ  LYS B  35      -4.211  48.045  -7.784  1.00 30.53           N  
ATOM   1118  N   THR B  36       0.891  43.512  -4.612  1.00 24.05           N  
ATOM   1119  CA  THR B  36       1.402  42.336  -5.283  1.00 23.15           C  
ATOM   1120  C   THR B  36       0.307  41.777  -6.185  1.00 22.06           C  
ATOM   1121  O   THR B  36      -0.835  42.249  -6.164  1.00 21.62           O  
ATOM   1122  CB  THR B  36       1.707  41.299  -4.266  1.00 23.54           C  
ATOM   1123  OG1 THR B  36       0.513  41.060  -3.529  1.00 23.57           O  
ATOM   1124  CG2 THR B  36       2.830  41.763  -3.325  1.00 25.84           C  
ATOM   1125  N   ASN B  37       0.629  40.727  -6.928  1.00 20.99           N  
ATOM   1126  CA  ASN B  37      -0.385  40.061  -7.726  1.00 20.26           C  
ATOM   1127  C   ASN B  37      -1.548  39.563  -6.880  1.00 19.82           C  
ATOM   1128  O   ASN B  37      -2.708  39.674  -7.278  1.00 18.78           O  
ATOM   1129  CB  ASN B  37       0.221  38.894  -8.521  1.00 20.44           C  
ATOM   1130  N   GLN B  38      -1.250  39.032  -5.695  1.00 19.02           N  
ATOM   1131  CA  GLN B  38      -2.308  38.516  -4.847  1.00 19.10           C  
ATOM   1132  C   GLN B  38      -3.175  39.644  -4.322  1.00 18.86           C  
ATOM   1133  O   GLN B  38      -4.394  39.490  -4.226  1.00 18.97           O  
ATOM   1134  CB  GLN B  38      -1.758  37.691  -3.691  1.00 19.50           C  
ATOM   1135  CG  GLN B  38      -1.236  36.340  -4.126  1.00 19.79           C  
ATOM   1136  CD  GLN B  38      -0.875  35.464  -2.952  1.00 20.99           C  
ATOM   1137  OE1 GLN B  38      -0.502  35.963  -1.892  1.00 23.67           O  
ATOM   1138  NE2 GLN B  38      -0.979  34.160  -3.134  1.00 23.63           N  
ATOM   1139  N   LEU B  39      -2.560  40.772  -3.947  1.00 19.42           N  
ATOM   1140  CA  LEU B  39      -3.350  41.909  -3.480  1.00 19.90           C  
ATOM   1141  C   LEU B  39      -4.172  42.532  -4.604  1.00 19.75           C  
ATOM   1142  O   LEU B  39      -5.287  43.016  -4.370  1.00 20.31           O  
ATOM   1143  CB  LEU B  39      -2.475  42.964  -2.808  1.00 20.26           C  
ATOM   1144  CG  LEU B  39      -2.053  42.576  -1.393  1.00 21.03           C  
ATOM   1145  CD1 LEU B  39      -0.832  43.373  -0.902  1.00 23.11           C  
ATOM   1146  CD2 LEU B  39      -3.251  42.702  -0.428  1.00 21.52           C  
ATOM   1147  N   GLN B  40      -3.625  42.546  -5.817  1.00 19.87           N  
ATOM   1148  CA  GLN B  40      -4.421  42.965  -6.978  1.00 20.30           C  
ATOM   1149  C   GLN B  40      -5.641  42.063  -7.163  1.00 19.95           C  
ATOM   1150  O   GLN B  40      -6.742  42.534  -7.445  1.00 20.31           O  
ATOM   1151  CB  GLN B  40      -3.559  42.977  -8.241  1.00 20.40           C  
ATOM   1152  CG  GLN B  40      -4.281  43.459  -9.493  1.00 23.65           C  
ATOM   1153  CD  GLN B  40      -3.386  43.490 -10.705  1.00 29.58           C  
ATOM   1154  OE1 GLN B  40      -3.133  44.551 -11.270  1.00 34.40           O  
ATOM   1155  NE2 GLN B  40      -2.888  42.326 -11.112  1.00 33.09           N  
ATOM   1156  N   TYR B  41      -5.440  40.753  -7.035  1.00 19.57           N  
ATOM   1157  CA  TYR B  41      -6.550  39.799  -7.092  1.00 19.52           C  
ATOM   1158  C   TYR B  41      -7.573  40.068  -5.980  1.00 19.74           C  
ATOM   1159  O   TYR B  41      -8.773  40.059  -6.223  1.00 20.13           O  
ATOM   1160  CB  TYR B  41      -6.003  38.380  -6.998  1.00 19.68           C  
ATOM   1161  CG  TYR B  41      -7.042  37.296  -7.088  1.00 18.85           C  
ATOM   1162  CD1 TYR B  41      -7.379  36.737  -8.308  1.00 19.86           C  
ATOM   1163  CD2 TYR B  41      -7.689  36.822  -5.955  1.00 19.94           C  
ATOM   1164  CE1 TYR B  41      -8.330  35.730  -8.397  1.00 18.50           C  
ATOM   1165  CE2 TYR B  41      -8.651  35.823  -6.033  1.00 20.04           C  
ATOM   1166  CZ  TYR B  41      -8.961  35.284  -7.252  1.00 20.28           C  
ATOM   1167  OH  TYR B  41      -9.891  34.285  -7.366  1.00 20.05           O  
ATOM   1168  N   MET B  42      -7.097  40.345  -4.777  1.00 20.02           N  
ATOM   1169  CA  MET B  42      -8.025  40.662  -3.695  1.00 20.60           C  
ATOM   1170  C   MET B  42      -8.886  41.865  -4.038  1.00 20.99           C  
ATOM   1171  O   MET B  42     -10.074  41.877  -3.714  1.00 21.83           O  
ATOM   1172  CB  MET B  42      -7.313  40.913  -2.375  1.00 21.23           C  
ATOM   1173  CG  MET B  42      -6.612  39.717  -1.791  1.00 21.69           C  
ATOM   1174  SD  MET B  42      -7.587  38.208  -1.539  1.00 22.88           S  
ATOM   1175  CE  MET B  42      -8.776  38.794  -0.329  1.00 23.85           C  
ATOM   1176  N   GLN B  43      -8.308  42.870  -4.694  1.00 20.73           N  
ATOM   1177  CA  GLN B  43      -9.068  44.081  -5.034  1.00 21.13           C  
ATOM   1178  C   GLN B  43      -9.960  43.852  -6.248  1.00 21.10           C  
ATOM   1179  O   GLN B  43     -11.174  44.063  -6.201  1.00 21.07           O  
ATOM   1180  CB  GLN B  43      -8.129  45.260  -5.315  1.00 20.79           C  
ATOM   1181  CG  GLN B  43      -8.866  46.583  -5.630  1.00 22.18           C  
ATOM   1182  CD  GLN B  43      -7.962  47.829  -5.659  1.00 22.43           C  
ATOM   1183  OE1 GLN B  43      -6.789  47.769  -5.310  1.00 26.07           O  
ATOM   1184  NE2 GLN B  43      -8.541  48.966  -6.032  1.00 24.24           N  
ATOM   1185  N   ASN B  44      -9.336  43.454  -7.346  1.00 20.87           N  
ATOM   1186  CA  ASN B  44      -9.996  43.382  -8.650  1.00 21.41           C  
ATOM   1187  C   ASN B  44     -10.970  42.220  -8.778  1.00 20.70           C  
ATOM   1188  O   ASN B  44     -11.928  42.303  -9.542  1.00 21.09           O  
ATOM   1189  CB  ASN B  44      -8.927  43.271  -9.731  1.00 21.45           C  
ATOM   1190  CG  ASN B  44      -9.482  43.408 -11.120  1.00 25.11           C  
ATOM   1191  OD1 ASN B  44     -10.203  44.355 -11.419  1.00 28.47           O  
ATOM   1192  ND2 ASN B  44      -9.148  42.454 -11.986  1.00 26.47           N  
ATOM   1193  N   VAL B  45     -10.722  41.133  -8.050  1.00 20.65           N  
ATOM   1194  CA  VAL B  45     -11.586  39.957  -8.080  1.00 20.73           C  
ATOM   1195  C   VAL B  45     -12.419  39.785  -6.802  1.00 20.55           C  
ATOM   1196  O   VAL B  45     -13.647  39.763  -6.877  1.00 21.29           O  
ATOM   1197  CB  VAL B  45     -10.803  38.667  -8.391  1.00 20.89           C  
ATOM   1198  CG1 VAL B  45     -11.737  37.454  -8.332  1.00 22.59           C  
ATOM   1199  CG2 VAL B  45     -10.140  38.756  -9.778  1.00 20.46           C  
ATOM   1200  N   VAL B  46     -11.790  39.685  -5.631  1.00 20.53           N  
ATOM   1201  CA  VAL B  46     -12.532  39.325  -4.428  1.00 20.31           C  
ATOM   1202  C   VAL B  46     -13.455  40.470  -3.985  1.00 20.47           C  
ATOM   1203  O   VAL B  46     -14.681  40.302  -3.913  1.00 21.08           O  
ATOM   1204  CB  VAL B  46     -11.608  38.860  -3.287  1.00 19.98           C  
ATOM   1205  CG1 VAL B  46     -12.421  38.490  -2.044  1.00 21.13           C  
ATOM   1206  CG2 VAL B  46     -10.741  37.682  -3.757  1.00 20.05           C  
ATOM   1207  N   VAL B  47     -12.881  41.638  -3.699  1.00 21.10           N  
ATOM   1208  CA  VAL B  47     -13.702  42.750  -3.216  1.00 20.41           C  
ATOM   1209  C   VAL B  47     -14.671  43.220  -4.290  1.00 21.23           C  
ATOM   1210  O   VAL B  47     -15.868  43.423  -4.008  1.00 21.20           O  
ATOM   1211  CB  VAL B  47     -12.849  43.935  -2.699  1.00 20.34           C  
ATOM   1212  CG1 VAL B  47     -13.730  45.072  -2.214  1.00 22.11           C  
ATOM   1213  CG2 VAL B  47     -11.927  43.487  -1.594  1.00 21.09           C  
ATOM   1214  N   LYS B  48     -14.195  43.362  -5.522  1.00 21.18           N  
ATOM   1215  CA  LYS B  48     -15.061  43.871  -6.574  1.00 21.48           C  
ATOM   1216  C   LYS B  48     -16.253  42.939  -6.800  1.00 21.20           C  
ATOM   1217  O   LYS B  48     -17.374  43.422  -7.006  1.00 21.44           O  
ATOM   1218  CB  LYS B  48     -14.281  44.112  -7.876  1.00 20.89           C  
ATOM   1219  CG  LYS B  48     -15.016  44.989  -8.854  1.00 23.58           C  
ATOM   1220  CD  LYS B  48     -14.257  45.154 -10.135  1.00 24.38           C  
ATOM   1221  CE  LYS B  48     -12.910  45.805  -9.960  1.00 26.47           C  
ATOM   1222  NZ  LYS B  48     -12.247  45.977 -11.289  1.00 28.58           N  
ATOM   1223  N   THR B  49     -16.033  41.623  -6.756  1.00 21.23           N  
ATOM   1224  CA  THR B  49     -17.123  40.650  -6.917  1.00 21.20           C  
ATOM   1225  C   THR B  49     -18.129  40.739  -5.766  1.00 20.98           C  
ATOM   1226  O   THR B  49     -19.337  40.726  -5.991  1.00 21.12           O  
ATOM   1227  CB  THR B  49     -16.608  39.198  -7.026  1.00 21.90           C  
ATOM   1228  OG1 THR B  49     -15.776  39.070  -8.187  1.00 22.95           O  
ATOM   1229  CG2 THR B  49     -17.761  38.202  -7.138  1.00 22.80           C  
ATOM   1230  N   LEU B  50     -17.629  40.798  -4.536  1.00 21.12           N  
ATOM   1231  CA  LEU B  50     -18.518  40.897  -3.386  1.00 21.37           C  
ATOM   1232  C   LEU B  50     -19.289  42.218  -3.367  1.00 20.81           C  
ATOM   1233  O   LEU B  50     -20.426  42.261  -2.909  1.00 20.67           O  
ATOM   1234  CB  LEU B  50     -17.742  40.728  -2.082  1.00 21.64           C  
ATOM   1235  CG  LEU B  50     -17.152  39.325  -1.889  1.00 23.93           C  
ATOM   1236  CD1 LEU B  50     -16.133  39.346  -0.742  1.00 26.19           C  
ATOM   1237  CD2 LEU B  50     -18.236  38.317  -1.621  1.00 25.27           C  
ATOM   1238  N   TRP B  51     -18.666  43.294  -3.847  1.00 20.36           N  
ATOM   1239  CA  TRP B  51     -19.286  44.615  -3.858  1.00 19.08           C  
ATOM   1240  C   TRP B  51     -20.497  44.618  -4.776  1.00 19.21           C  
ATOM   1241  O   TRP B  51     -21.524  45.235  -4.489  1.00 18.25           O  
ATOM   1242  CB  TRP B  51     -18.274  45.665  -4.354  1.00 19.62           C  
ATOM   1243  CG  TRP B  51     -18.605  47.052  -3.989  1.00 18.72           C  
ATOM   1244  CD1 TRP B  51     -19.447  47.886  -4.644  1.00 19.74           C  
ATOM   1245  CD2 TRP B  51     -18.100  47.787  -2.867  1.00 19.23           C  
ATOM   1246  NE1 TRP B  51     -19.514  49.096  -3.998  1.00 19.27           N  
ATOM   1247  CE2 TRP B  51     -18.674  49.056  -2.913  1.00 17.94           C  
ATOM   1248  CE3 TRP B  51     -17.198  47.487  -1.826  1.00 20.16           C  
ATOM   1249  CZ2 TRP B  51     -18.407  50.034  -1.948  1.00 19.42           C  
ATOM   1250  CZ3 TRP B  51     -16.932  48.466  -0.892  1.00 20.22           C  
ATOM   1251  CH2 TRP B  51     -17.531  49.705  -0.948  1.00 20.95           C  
ATOM   1252  N   LYS B  52     -20.373  43.927  -5.903  1.00 19.78           N  
ATOM   1253  CA  LYS B  52     -21.376  43.983  -6.950  1.00 20.64           C  
ATOM   1254  C   LYS B  52     -22.355  42.836  -6.717  1.00 20.84           C  
ATOM   1255  O   LYS B  52     -22.500  41.941  -7.530  1.00 22.70           O  
ATOM   1256  CB  LYS B  52     -20.702  43.926  -8.330  1.00 20.90           C  
ATOM   1257  CG  LYS B  52     -19.727  45.092  -8.560  1.00 21.06           C  
ATOM   1258  CD  LYS B  52     -19.095  45.041  -9.946  1.00 21.08           C  
ATOM   1259  CE  LYS B  52     -18.400  46.352 -10.323  1.00 20.20           C  
ATOM   1260  NZ  LYS B  52     -17.852  46.286 -11.708  1.00 23.85           N  
ATOM   1261  N   HIS B  53     -23.022  42.894  -5.569  1.00 21.95           N  
ATOM   1262  CA  HIS B  53     -23.889  41.817  -5.086  1.00 22.06           C  
ATOM   1263  C   HIS B  53     -25.043  42.440  -4.318  1.00 21.92           C  
ATOM   1264  O   HIS B  53     -24.852  43.381  -3.551  1.00 21.53           O  
ATOM   1265  CB  HIS B  53     -23.099  40.878  -4.178  1.00 22.87           C  
ATOM   1266  CG  HIS B  53     -23.811  39.606  -3.834  1.00 22.60           C  
ATOM   1267  ND1 HIS B  53     -24.869  39.554  -2.954  1.00 22.78           N  
ATOM   1268  CD2 HIS B  53     -23.606  38.331  -4.248  1.00 24.82           C  
ATOM   1269  CE1 HIS B  53     -25.280  38.305  -2.831  1.00 23.13           C  
ATOM   1270  NE2 HIS B  53     -24.534  37.542  -3.610  1.00 22.78           N  
ATOM   1271  N   GLN B  54     -26.248  41.928  -4.533  1.00 21.35           N  
ATOM   1272  CA  GLN B  54     -27.436  42.480  -3.890  1.00 22.20           C  
ATOM   1273  C   GLN B  54     -27.428  42.457  -2.361  1.00 21.37           C  
ATOM   1274  O   GLN B  54     -28.149  43.224  -1.741  1.00 22.06           O  
ATOM   1275  CB  GLN B  54     -28.689  41.758  -4.393  1.00 22.57           C  
ATOM   1276  CG  GLN B  54     -28.801  40.264  -4.037  1.00 24.92           C  
ATOM   1277  CD  GLN B  54     -30.102  39.654  -4.526  1.00 28.87           C  
ATOM   1278  OE1 GLN B  54     -31.188  40.007  -4.054  1.00 31.50           O  
ATOM   1279  NE2 GLN B  54     -30.002  38.736  -5.481  1.00 31.33           N  
ATOM   1280  N   PHE B  55     -26.634  41.579  -1.759  1.00 20.72           N  
ATOM   1281  CA  PHE B  55     -26.569  41.465  -0.293  1.00 20.63           C  
ATOM   1282  C   PHE B  55     -25.379  42.219   0.298  1.00 20.13           C  
ATOM   1283  O   PHE B  55     -25.165  42.179   1.507  1.00 19.70           O  
ATOM   1284  CB  PHE B  55     -26.483  39.991   0.131  1.00 20.78           C  
ATOM   1285  CG  PHE B  55     -27.756  39.191  -0.068  1.00 22.77           C  
ATOM   1286  CD1 PHE B  55     -28.983  39.799  -0.325  1.00 23.06           C  
ATOM   1287  CD2 PHE B  55     -27.720  37.804   0.050  1.00 23.73           C  
ATOM   1288  CE1 PHE B  55     -30.136  39.037  -0.480  1.00 24.59           C  
ATOM   1289  CE2 PHE B  55     -28.863  37.041  -0.105  1.00 25.24           C  
ATOM   1290  CZ  PHE B  55     -30.074  37.654  -0.368  1.00 24.68           C  
ATOM   1291  N   ALA B  56     -24.610  42.920  -0.527  1.00 19.75           N  
ATOM   1292  CA  ALA B  56     -23.386  43.569  -0.061  1.00 20.02           C  
ATOM   1293  C   ALA B  56     -23.612  44.891   0.687  1.00 19.89           C  
ATOM   1294  O   ALA B  56     -22.783  45.286   1.501  1.00 19.97           O  
ATOM   1295  CB  ALA B  56     -22.443  43.782  -1.238  1.00 20.48           C  
ATOM   1296  N   TRP B  57     -24.741  45.555   0.444  1.00 20.12           N  
ATOM   1297  CA  TRP B  57     -24.940  46.931   0.909  1.00 20.85           C  
ATOM   1298  C   TRP B  57     -24.753  47.192   2.419  1.00 21.16           C  
ATOM   1299  O   TRP B  57     -24.224  48.248   2.773  1.00 22.36           O  
ATOM   1300  CB  TRP B  57     -26.278  47.514   0.402  1.00 21.96           C  
ATOM   1301  CG  TRP B  57     -27.469  46.756   0.837  1.00 22.03           C  
ATOM   1302  CD1 TRP B  57     -28.047  45.708   0.191  1.00 22.37           C  
ATOM   1303  CD2 TRP B  57     -28.242  46.970   2.026  1.00 23.18           C  
ATOM   1304  NE1 TRP B  57     -29.121  45.247   0.905  1.00 23.07           N  
ATOM   1305  CE2 TRP B  57     -29.261  46.003   2.036  1.00 23.01           C  
ATOM   1306  CE3 TRP B  57     -28.158  47.877   3.090  1.00 24.22           C  
ATOM   1307  CZ2 TRP B  57     -30.208  45.923   3.063  1.00 24.26           C  
ATOM   1308  CZ3 TRP B  57     -29.098  47.791   4.115  1.00 24.01           C  
ATOM   1309  CH2 TRP B  57     -30.102  46.821   4.091  1.00 23.30           C  
ATOM   1310  N   PRO B  58     -25.149  46.246   3.307  1.00 20.91           N  
ATOM   1311  CA  PRO B  58     -24.904  46.505   4.727  1.00 20.80           C  
ATOM   1312  C   PRO B  58     -23.442  46.560   5.099  1.00 21.32           C  
ATOM   1313  O   PRO B  58     -23.122  46.986   6.199  1.00 22.17           O  
ATOM   1314  CB  PRO B  58     -25.537  45.294   5.426  1.00 20.87           C  
ATOM   1315  CG  PRO B  58     -26.502  44.752   4.466  1.00 20.57           C  
ATOM   1316  CD  PRO B  58     -25.819  44.947   3.133  1.00 20.83           C  
ATOM   1317  N   PHE B  59     -22.572  46.120   4.199  1.00 20.13           N  
ATOM   1318  CA  PHE B  59     -21.146  45.994   4.463  1.00 19.81           C  
ATOM   1319  C   PHE B  59     -20.298  47.014   3.710  1.00 20.23           C  
ATOM   1320  O   PHE B  59     -19.079  46.988   3.823  1.00 20.74           O  
ATOM   1321  CB  PHE B  59     -20.680  44.570   4.140  1.00 20.42           C  
ATOM   1322  CG  PHE B  59     -21.497  43.508   4.810  1.00 20.94           C  
ATOM   1323  CD1 PHE B  59     -21.281  43.170   6.135  1.00 21.91           C  
ATOM   1324  CD2 PHE B  59     -22.519  42.887   4.123  1.00 21.91           C  
ATOM   1325  CE1 PHE B  59     -22.053  42.204   6.750  1.00 22.41           C  
ATOM   1326  CE2 PHE B  59     -23.301  41.914   4.733  1.00 20.87           C  
ATOM   1327  CZ  PHE B  59     -23.060  41.573   6.045  1.00 22.46           C  
ATOM   1328  N   TYR B  60     -20.920  47.919   2.966  1.00 19.79           N  
ATOM   1329  CA  TYR B  60     -20.163  48.955   2.251  1.00 20.16           C  
ATOM   1330  C   TYR B  60     -19.559  49.992   3.174  1.00 20.77           C  
ATOM   1331  O   TYR B  60     -18.643  50.718   2.767  1.00 21.32           O  
ATOM   1332  CB  TYR B  60     -21.029  49.727   1.257  1.00 19.48           C  
ATOM   1333  CG  TYR B  60     -21.532  48.999   0.043  1.00 20.04           C  
ATOM   1334  CD1 TYR B  60     -22.679  49.439  -0.600  1.00 20.49           C  
ATOM   1335  CD2 TYR B  60     -20.870  47.898  -0.486  1.00 20.64           C  
ATOM   1336  CE1 TYR B  60     -23.162  48.813  -1.744  1.00 20.69           C  
ATOM   1337  CE2 TYR B  60     -21.349  47.269  -1.615  1.00 19.12           C  
ATOM   1338  CZ  TYR B  60     -22.501  47.719  -2.242  1.00 19.30           C  
ATOM   1339  OH  TYR B  60     -23.005  47.107  -3.375  1.00 20.15           O  
ATOM   1340  N   GLN B  61     -20.112  50.109   4.378  1.00 20.49           N  
ATOM   1341  CA  GLN B  61     -19.702  51.126   5.336  1.00 20.95           C  
ATOM   1342  C   GLN B  61     -19.783  50.544   6.724  1.00 20.66           C  
ATOM   1343  O   GLN B  61     -20.400  49.494   6.908  1.00 20.32           O  
ATOM   1344  CB  GLN B  61     -20.590  52.367   5.232  1.00 21.36           C  
ATOM   1345  CG  GLN B  61     -22.071  52.128   5.541  1.00 23.58           C  
ATOM   1346  CD  GLN B  61     -22.814  51.357   4.443  1.00 25.45           C  
ATOM   1347  OE1 GLN B  61     -22.939  51.833   3.310  1.00 29.33           O  
ATOM   1348  NE2 GLN B  61     -23.318  50.163   4.785  1.00 25.86           N  
ATOM   1349  N   PRO B  62     -19.148  51.198   7.704  1.00 21.18           N  
ATOM   1350  CA  PRO B  62     -19.241  50.710   9.057  1.00 21.11           C  
ATOM   1351  C   PRO B  62     -20.690  50.530   9.540  1.00 21.23           C  
ATOM   1352  O   PRO B  62     -21.607  51.261   9.109  1.00 20.81           O  
ATOM   1353  CB  PRO B  62     -18.491  51.782   9.861  1.00 20.88           C  
ATOM   1354  CG  PRO B  62     -17.543  52.361   8.902  1.00 21.51           C  
ATOM   1355  CD  PRO B  62     -18.286  52.393   7.621  1.00 21.15           C  
ATOM   1356  N   VAL B  63     -20.900  49.529  10.396  1.00 21.76           N  
ATOM   1357  CA  VAL B  63     -22.195  49.344  11.034  1.00 21.69           C  
ATOM   1358  C   VAL B  63     -22.598  50.658  11.697  1.00 21.67           C  
ATOM   1359  O   VAL B  63     -21.786  51.290  12.383  1.00 21.95           O  
ATOM   1360  CB  VAL B  63     -22.152  48.210  12.086  1.00 21.78           C  
ATOM   1361  CG1 VAL B  63     -23.385  48.210  12.961  1.00 21.78           C  
ATOM   1362  CG2 VAL B  63     -21.962  46.854  11.410  1.00 22.69           C  
ATOM   1363  N   ASP B  64     -23.842  51.076  11.436  1.00 21.66           N  
ATOM   1364  CA  ASP B  64     -24.457  52.287  11.993  1.00 22.13           C  
ATOM   1365  C   ASP B  64     -25.385  51.877  13.143  1.00 21.94           C  
ATOM   1366  O   ASP B  64     -26.555  51.554  12.939  1.00 21.61           O  
ATOM   1367  CB  ASP B  64     -25.229  53.029  10.892  1.00 22.56           C  
ATOM   1368  CG  ASP B  64     -25.735  54.398  11.325  1.00 23.61           C  
ATOM   1369  OD1 ASP B  64     -25.820  54.682  12.539  1.00 25.29           O  
ATOM   1370  OD2 ASP B  64     -26.065  55.195  10.416  1.00 27.26           O  
ATOM   1371  N   ALA B  65     -24.838  51.889  14.357  1.00 22.39           N  
ATOM   1372  CA  ALA B  65     -25.536  51.403  15.544  1.00 22.37           C  
ATOM   1373  C   ALA B  65     -26.745  52.250  15.948  1.00 22.94           C  
ATOM   1374  O   ALA B  65     -27.730  51.745  16.502  1.00 23.62           O  
ATOM   1375  CB  ALA B  65     -24.540  51.313  16.712  1.00 22.96           C  
ATOM   1376  N   ILE B  66     -26.675  53.543  15.695  1.00 22.70           N  
ATOM   1377  CA  ILE B  66     -27.793  54.409  16.047  1.00 23.19           C  
ATOM   1378  C   ILE B  66     -28.965  54.190  15.096  1.00 23.77           C  
ATOM   1379  O   ILE B  66     -30.097  54.041  15.556  1.00 23.82           O  
ATOM   1380  CB  ILE B  66     -27.382  55.886  16.109  1.00 23.48           C  
ATOM   1381  CG1 ILE B  66     -26.352  56.084  17.231  1.00 23.79           C  
ATOM   1382  CG2 ILE B  66     -28.605  56.772  16.315  1.00 23.35           C  
ATOM   1383  CD1 ILE B  66     -26.833  55.644  18.623  1.00 25.78           C  
ATOM   1384  N   LYS B  67     -28.704  54.147  13.792  1.00 24.10           N  
ATOM   1385  CA  LYS B  67     -29.763  53.868  12.815  1.00 24.83           C  
ATOM   1386  C   LYS B  67     -30.450  52.538  13.127  1.00 24.55           C  
ATOM   1387  O   LYS B  67     -31.676  52.455  13.129  1.00 24.26           O  
ATOM   1388  CB  LYS B  67     -29.202  53.861  11.391  1.00 25.05           C  
ATOM   1389  CG  LYS B  67     -30.258  53.759  10.292  1.00 26.95           C  
ATOM   1390  CD  LYS B  67     -29.625  53.836   8.906  1.00 29.67           C  
ATOM   1391  CE  LYS B  67     -30.677  53.734   7.799  1.00 31.36           C  
ATOM   1392  NZ  LYS B  67     -31.630  54.872   7.809  1.00 32.37           N  
ATOM   1393  N   LEU B  68     -29.656  51.511  13.426  1.00 23.77           N  
ATOM   1394  CA  LEU B  68     -30.195  50.182  13.746  1.00 23.46           C  
ATOM   1395  C   LEU B  68     -30.694  50.035  15.190  1.00 23.00           C  
ATOM   1396  O   LEU B  68     -31.188  48.975  15.569  1.00 23.02           O  
ATOM   1397  CB  LEU B  68     -29.145  49.103  13.450  1.00 23.32           C  
ATOM   1398  CG  LEU B  68     -28.637  49.021  12.008  1.00 23.65           C  
ATOM   1399  CD1 LEU B  68     -27.462  48.063  11.935  1.00 25.97           C  
ATOM   1400  CD2 LEU B  68     -29.761  48.581  11.068  1.00 26.18           C  
ATOM   1401  N   ASN B  69     -30.552  51.084  16.007  1.00 22.99           N  
ATOM   1402  CA  ASN B  69     -30.954  51.059  17.417  1.00 23.42           C  
ATOM   1403  C   ASN B  69     -30.284  49.946  18.223  1.00 23.01           C  
ATOM   1404  O   ASN B  69     -30.953  49.134  18.861  1.00 23.53           O  
ATOM   1405  CB  ASN B  69     -32.484  50.978  17.540  1.00 23.58           C  
ATOM   1406  CG  ASN B  69     -32.980  51.329  18.935  1.00 25.70           C  
ATOM   1407  OD1 ASN B  69     -32.265  51.964  19.718  1.00 29.73           O  
ATOM   1408  ND2 ASN B  69     -34.201  50.910  19.259  1.00 28.49           N  
ATOM   1409  N   LEU B  70     -28.955  49.946  18.212  1.00 22.43           N  
ATOM   1410  CA  LEU B  70     -28.159  48.925  18.894  1.00 22.12           C  
ATOM   1411  C   LEU B  70     -27.225  49.590  19.908  1.00 21.24           C  
ATOM   1412  O   LEU B  70     -26.049  49.816  19.620  1.00 21.69           O  
ATOM   1413  CB  LEU B  70     -27.330  48.143  17.876  1.00 22.36           C  
ATOM   1414  CG  LEU B  70     -28.055  47.581  16.647  1.00 22.89           C  
ATOM   1415  CD1 LEU B  70     -27.043  47.004  15.669  1.00 23.50           C  
ATOM   1416  CD2 LEU B  70     -29.054  46.547  17.123  1.00 23.75           C  
ATOM   1417  N   PRO B  71     -27.748  49.938  21.095  1.00 21.17           N  
ATOM   1418  CA  PRO B  71     -26.895  50.639  22.057  1.00 21.16           C  
ATOM   1419  C   PRO B  71     -25.637  49.878  22.445  1.00 21.28           C  
ATOM   1420  O   PRO B  71     -24.624  50.500  22.804  1.00 19.91           O  
ATOM   1421  CB  PRO B  71     -27.791  50.787  23.282  1.00 21.07           C  
ATOM   1422  CG  PRO B  71     -29.172  50.695  22.771  1.00 21.86           C  
ATOM   1423  CD  PRO B  71     -29.114  49.753  21.614  1.00 21.19           C  
ATOM   1424  N   ASP B  72     -25.712  48.547  22.374  1.00 21.42           N  
ATOM   1425  CA  ASP B  72     -24.605  47.689  22.788  1.00 21.05           C  
ATOM   1426  C   ASP B  72     -23.654  47.290  21.667  1.00 21.02           C  
ATOM   1427  O   ASP B  72     -22.659  46.657  21.947  1.00 20.75           O  
ATOM   1428  CB  ASP B  72     -25.138  46.421  23.479  1.00 20.93           C  
ATOM   1429  CG  ASP B  72     -25.967  45.552  22.570  1.00 22.64           C  
ATOM   1430  OD1 ASP B  72     -26.306  45.986  21.454  1.00 22.71           O  
ATOM   1431  OD2 ASP B  72     -26.278  44.417  22.978  1.00 26.69           O  
ATOM   1432  N   TYR B  73     -23.914  47.665  20.415  1.00 20.72           N  
ATOM   1433  CA  TYR B  73     -23.106  47.136  19.320  1.00 20.81           C  
ATOM   1434  C   TYR B  73     -21.619  47.401  19.536  1.00 21.00           C  
ATOM   1435  O   TYR B  73     -20.791  46.496  19.449  1.00 20.31           O  
ATOM   1436  CB  TYR B  73     -23.550  47.677  17.942  1.00 21.11           C  
ATOM   1437  CG  TYR B  73     -22.733  47.058  16.849  1.00 20.23           C  
ATOM   1438  CD1 TYR B  73     -23.018  45.777  16.404  1.00 20.73           C  
ATOM   1439  CD2 TYR B  73     -21.613  47.689  16.326  1.00 20.25           C  
ATOM   1440  CE1 TYR B  73     -22.232  45.162  15.439  1.00 19.96           C  
ATOM   1441  CE2 TYR B  73     -20.810  47.076  15.374  1.00 20.89           C  
ATOM   1442  CZ  TYR B  73     -21.136  45.811  14.920  1.00 20.41           C  
ATOM   1443  OH  TYR B  73     -20.339  45.203  13.978  1.00 21.16           O  
ATOM   1444  N   HIS B  74     -21.273  48.649  19.828  1.00 20.19           N  
ATOM   1445  CA  HIS B  74     -19.873  49.020  19.983  1.00 21.04           C  
ATOM   1446  C   HIS B  74     -19.311  48.701  21.355  1.00 21.23           C  
ATOM   1447  O   HIS B  74     -18.124  48.888  21.579  1.00 22.23           O  
ATOM   1448  CB  HIS B  74     -19.693  50.494  19.669  1.00 20.87           C  
ATOM   1449  CG  HIS B  74     -20.044  50.851  18.260  1.00 21.80           C  
ATOM   1450  ND1 HIS B  74     -19.311  50.390  17.184  1.00 22.26           N  
ATOM   1451  CD2 HIS B  74     -21.033  51.619  17.743  1.00 22.64           C  
ATOM   1452  CE1 HIS B  74     -19.831  50.868  16.070  1.00 22.70           C  
ATOM   1453  NE2 HIS B  74     -20.879  51.611  16.372  1.00 22.02           N  
ATOM   1454  N   LYS B  75     -20.158  48.232  22.262  1.00 20.84           N  
ATOM   1455  CA  LYS B  75     -19.671  47.663  23.517  1.00 20.79           C  
ATOM   1456  C   LYS B  75     -19.206  46.218  23.303  1.00 21.07           C  
ATOM   1457  O   LYS B  75     -18.229  45.782  23.902  1.00 22.99           O  
ATOM   1458  CB  LYS B  75     -20.754  47.714  24.608  1.00 21.05           C  
ATOM   1459  CG  LYS B  75     -21.292  49.094  24.908  1.00 20.42           C  
ATOM   1460  CD  LYS B  75     -22.441  49.087  25.922  1.00 18.96           C  
ATOM   1461  CE  LYS B  75     -23.140  50.431  25.982  1.00 18.86           C  
ATOM   1462  NZ  LYS B  75     -24.302  50.408  26.932  1.00 18.53           N  
ATOM   1463  N   ILE B  76     -19.907  45.469  22.451  1.00 20.45           N  
ATOM   1464  CA  ILE B  76     -19.618  44.059  22.206  1.00 20.25           C  
ATOM   1465  C   ILE B  76     -18.551  43.900  21.115  1.00 20.04           C  
ATOM   1466  O   ILE B  76     -17.591  43.136  21.277  1.00 19.63           O  
ATOM   1467  CB  ILE B  76     -20.924  43.314  21.794  1.00 20.72           C  
ATOM   1468  CG1 ILE B  76     -21.916  43.357  22.957  1.00 21.59           C  
ATOM   1469  CG2 ILE B  76     -20.638  41.887  21.308  1.00 20.33           C  
ATOM   1470  CD1 ILE B  76     -23.253  42.712  22.681  1.00 23.33           C  
ATOM   1471  N   ILE B  77     -18.727  44.625  20.008  1.00 19.81           N  
ATOM   1472  CA  ILE B  77     -17.817  44.560  18.866  1.00 20.32           C  
ATOM   1473  C   ILE B  77     -16.725  45.619  19.037  1.00 21.84           C  
ATOM   1474  O   ILE B  77     -16.980  46.819  18.866  1.00 23.87           O  
ATOM   1475  CB  ILE B  77     -18.563  44.737  17.527  1.00 20.15           C  
ATOM   1476  CG1 ILE B  77     -19.595  43.617  17.371  1.00 21.01           C  
ATOM   1477  CG2 ILE B  77     -17.552  44.848  16.368  1.00 20.27           C  
ATOM   1478  CD1 ILE B  77     -19.053  42.178  17.480  1.00 20.09           C  
ATOM   1479  N   LYS B  78     -15.525  45.150  19.331  1.00 20.96           N  
ATOM   1480  CA  LYS B  78     -14.392  46.037  19.597  1.00 22.88           C  
ATOM   1481  C   LYS B  78     -13.401  46.170  18.440  1.00 22.23           C  
ATOM   1482  O   LYS B  78     -12.599  47.101  18.432  1.00 22.68           O  
ATOM   1483  CB  LYS B  78     -13.723  45.592  20.896  1.00 24.59           C  
ATOM   1484  CG  LYS B  78     -14.716  45.255  21.986  1.00 26.97           C  
ATOM   1485  CD  LYS B  78     -14.051  44.615  23.187  1.00 28.25           C  
ATOM   1486  CE  LYS B  78     -14.963  44.567  24.335  1.00 26.78           C  
ATOM   1487  NZ  LYS B  78     -16.191  43.749  24.151  1.00 23.74           N  
ATOM   1488  N   ASN B  79     -13.470  45.286  17.430  1.00 20.98           N  
ATOM   1489  CA  ASN B  79     -12.659  45.369  16.228  1.00 21.88           C  
ATOM   1490  C   ASN B  79     -13.599  45.497  15.030  1.00 20.54           C  
ATOM   1491  O   ASN B  79     -13.771  44.546  14.266  1.00 20.78           O  
ATOM   1492  CB  ASN B  79     -11.805  44.091  15.995  1.00 22.47           C  
ATOM   1493  CG  ASN B  79     -10.543  44.015  16.846  1.00 26.33           C  
ATOM   1494  OD1 ASN B  79     -10.301  44.831  17.730  1.00 28.22           O  
ATOM   1495  ND2 ASN B  79      -9.744  42.981  16.588  1.00 27.93           N  
ATOM   1496  N   PRO B  80     -14.203  46.661  14.817  1.00 19.77           N  
ATOM   1497  CA  PRO B  80     -15.121  46.787  13.685  1.00 20.15           C  
ATOM   1498  C   PRO B  80     -14.424  46.688  12.343  1.00 20.43           C  
ATOM   1499  O   PRO B  80     -13.250  47.048  12.204  1.00 20.95           O  
ATOM   1500  CB  PRO B  80     -15.743  48.171  13.891  1.00 20.70           C  
ATOM   1501  CG  PRO B  80     -14.658  48.927  14.627  1.00 20.68           C  
ATOM   1502  CD  PRO B  80     -14.124  47.904  15.590  1.00 20.21           C  
ATOM   1503  N   MET B  81     -15.123  46.160  11.343  1.00 19.87           N  
ATOM   1504  CA  MET B  81     -14.565  46.088  10.005  1.00 20.90           C  
ATOM   1505  C   MET B  81     -15.686  46.023   9.002  1.00 20.90           C  
ATOM   1506  O   MET B  81     -16.711  45.429   9.272  1.00 21.19           O  
ATOM   1507  CB  MET B  81     -13.664  44.855   9.861  1.00 21.19           C  
ATOM   1508  CG  MET B  81     -12.893  44.754   8.552  1.00 21.52           C  
ATOM   1509  SD  MET B  81     -11.909  46.203   8.092  1.00 21.74           S  
ATOM   1510  CE  MET B  81     -10.785  46.257   9.489  1.00 24.83           C  
ATOM   1511  N   ASP B  82     -15.466  46.632   7.837  1.00 20.24           N  
ATOM   1512  CA  ASP B  82     -16.452  46.670   6.759  1.00 20.20           C  
ATOM   1513  C   ASP B  82     -15.703  46.637   5.421  1.00 20.24           C  
ATOM   1514  O   ASP B  82     -14.491  46.892   5.357  1.00 21.01           O  
ATOM   1515  CB  ASP B  82     -17.301  47.928   6.846  1.00 20.64           C  
ATOM   1516  CG  ASP B  82     -16.481  49.161   6.621  1.00 21.21           C  
ATOM   1517  OD1 ASP B  82     -15.756  49.571   7.562  1.00 22.68           O  
ATOM   1518  OD2 ASP B  82     -16.541  49.699   5.481  1.00 21.92           O  
ATOM   1519  N   MET B  83     -16.438  46.346   4.361  1.00 20.39           N  
ATOM   1520  CA  MET B  83     -15.841  46.262   3.037  1.00 20.65           C  
ATOM   1521  C   MET B  83     -15.391  47.621   2.514  1.00 20.66           C  
ATOM   1522  O   MET B  83     -14.502  47.658   1.664  1.00 20.24           O  
ATOM   1523  CB  MET B  83     -16.786  45.626   2.015  1.00 22.18           C  
ATOM   1524  CG  MET B  83     -16.987  44.144   2.140  1.00 23.94           C  
ATOM   1525  SD  MET B  83     -17.355  43.357   0.530  1.00 26.79           S  
ATOM   1526  CE  MET B  83     -18.849  44.247   0.055  1.00 23.71           C  
ATOM   1527  N   GLY B  84     -16.009  48.725   2.929  1.00 20.33           N  
ATOM   1528  CA  GLY B  84     -15.525  50.034   2.500  1.00 20.50           C  
ATOM   1529  C   GLY B  84     -14.118  50.302   2.997  1.00 20.46           C  
ATOM   1530  O   GLY B  84     -13.273  50.835   2.270  1.00 21.10           O  
ATOM   1531  N   THR B  85     -13.843  49.936   4.242  1.00 20.49           N  
ATOM   1532  CA  THR B  85     -12.511  50.055   4.814  1.00 20.41           C  
ATOM   1533  C   THR B  85     -11.522  49.165   4.084  1.00 20.43           C  
ATOM   1534  O   THR B  85     -10.408  49.574   3.788  1.00 21.19           O  
ATOM   1535  CB  THR B  85     -12.557  49.697   6.305  1.00 20.81           C  
ATOM   1536  OG1 THR B  85     -13.386  50.655   6.979  1.00 21.68           O  
ATOM   1537  CG2 THR B  85     -11.181  49.710   6.941  1.00 22.21           C  
ATOM   1538  N   ILE B  86     -11.936  47.941   3.784  1.00 20.09           N  
ATOM   1539  CA  ILE B  86     -11.092  47.026   3.052  1.00 19.80           C  
ATOM   1540  C   ILE B  86     -10.733  47.601   1.680  1.00 19.75           C  
ATOM   1541  O   ILE B  86      -9.557  47.584   1.270  1.00 20.23           O  
ATOM   1542  CB  ILE B  86     -11.748  45.641   2.914  1.00 20.12           C  
ATOM   1543  CG1 ILE B  86     -11.864  44.976   4.285  1.00 21.33           C  
ATOM   1544  CG2 ILE B  86     -10.901  44.758   2.005  1.00 20.74           C  
ATOM   1545  CD1 ILE B  86     -12.722  43.710   4.324  1.00 21.95           C  
ATOM   1546  N   LYS B  87     -11.732  48.116   0.967  1.00 19.85           N  
ATOM   1547  CA  LYS B  87     -11.505  48.728  -0.355  1.00 19.95           C  
ATOM   1548  C   LYS B  87     -10.490  49.858  -0.236  1.00 19.97           C  
ATOM   1549  O   LYS B  87      -9.556  49.959  -1.044  1.00 20.64           O  
ATOM   1550  CB  LYS B  87     -12.825  49.195  -0.971  1.00 19.66           C  
ATOM   1551  CG  LYS B  87     -12.704  49.828  -2.361  1.00 19.94           C  
ATOM   1552  CD  LYS B  87     -14.064  50.094  -2.921  1.00 20.45           C  
ATOM   1553  CE  LYS B  87     -13.996  50.630  -4.341  1.00 20.88           C  
ATOM   1554  NZ  LYS B  87     -13.692  52.120  -4.430  1.00 21.81           N  
ATOM   1555  N   LYS B  88     -10.643  50.714   0.764  1.00 20.32           N  
ATOM   1556  CA  LYS B  88      -9.711  51.832   0.956  1.00 21.08           C  
ATOM   1557  C   LYS B  88      -8.301  51.362   1.284  1.00 21.23           C  
ATOM   1558  O   LYS B  88      -7.350  51.922   0.774  1.00 21.33           O  
ATOM   1559  CB  LYS B  88     -10.200  52.782   2.050  1.00 21.62           C  
ATOM   1560  CG  LYS B  88     -11.431  53.546   1.653  1.00 21.90           C  
ATOM   1561  CD  LYS B  88     -11.943  54.426   2.760  1.00 25.48           C  
ATOM   1562  CE  LYS B  88     -13.219  55.151   2.324  1.00 28.69           C  
ATOM   1563  NZ  LYS B  88     -13.808  55.991   3.394  1.00 31.40           N  
ATOM   1564  N   ARG B  89      -8.151  50.324   2.107  1.00 20.60           N  
ATOM   1565  CA  ARG B  89      -6.843  49.753   2.399  1.00 20.64           C  
ATOM   1566  C   ARG B  89      -6.192  49.277   1.109  1.00 21.03           C  
ATOM   1567  O   ARG B  89      -5.007  49.544   0.866  1.00 21.53           O  
ATOM   1568  CB  ARG B  89      -6.946  48.626   3.425  1.00 21.25           C  
ATOM   1569  CG  ARG B  89      -7.164  49.168   4.820  1.00 21.21           C  
ATOM   1570  CD  ARG B  89      -7.316  48.070   5.887  1.00 21.07           C  
ATOM   1571  NE  ARG B  89      -7.227  48.691   7.200  1.00 22.43           N  
ATOM   1572  CZ  ARG B  89      -7.054  48.016   8.331  1.00 22.67           C  
ATOM   1573  NH1 ARG B  89      -7.049  46.694   8.335  1.00 22.90           N  
ATOM   1574  NH2 ARG B  89      -6.878  48.677   9.451  1.00 21.81           N  
ATOM   1575  N   LEU B  90      -6.953  48.610   0.239  1.00 20.86           N  
ATOM   1576  CA  LEU B  90      -6.392  48.166  -1.024  1.00 20.35           C  
ATOM   1577  C   LEU B  90      -6.028  49.351  -1.921  1.00 20.42           C  
ATOM   1578  O   LEU B  90      -4.967  49.362  -2.555  1.00 20.58           O  
ATOM   1579  CB  LEU B  90      -7.375  47.227  -1.743  1.00 20.76           C  
ATOM   1580  CG  LEU B  90      -7.526  45.872  -1.040  1.00 21.39           C  
ATOM   1581  CD1 LEU B  90      -8.827  45.199  -1.419  1.00 21.77           C  
ATOM   1582  CD2 LEU B  90      -6.329  44.938  -1.331  1.00 22.70           C  
ATOM   1583  N   GLU B  91      -6.910  50.347  -1.994  1.00 19.89           N  
ATOM   1584  CA  GLU B  91      -6.641  51.553  -2.773  1.00 20.27           C  
ATOM   1585  C   GLU B  91      -5.405  52.310  -2.299  1.00 20.42           C  
ATOM   1586  O   GLU B  91      -4.749  52.992  -3.105  1.00 20.63           O  
ATOM   1587  CB  GLU B  91      -7.862  52.469  -2.732  1.00 20.08           C  
ATOM   1588  CG  GLU B  91      -8.998  51.905  -3.547  1.00 20.91           C  
ATOM   1589  CD  GLU B  91     -10.307  52.633  -3.351  1.00 20.29           C  
ATOM   1590  OE1 GLU B  91     -10.640  53.007  -2.208  1.00 21.80           O  
ATOM   1591  OE2 GLU B  91     -11.021  52.831  -4.345  1.00 21.17           O  
ATOM   1592  N   ASN B  92      -5.119  52.238  -1.006  1.00 20.55           N  
ATOM   1593  CA  ASN B  92      -3.990  52.956  -0.416  1.00 20.48           C  
ATOM   1594  C   ASN B  92      -2.701  52.144  -0.405  1.00 20.79           C  
ATOM   1595  O   ASN B  92      -1.672  52.630   0.053  1.00 21.89           O  
ATOM   1596  CB  ASN B  92      -4.359  53.380   1.006  1.00 20.82           C  
ATOM   1597  CG  ASN B  92      -5.371  54.482   1.005  1.00 21.00           C  
ATOM   1598  OD1 ASN B  92      -5.595  55.122  -0.027  1.00 21.31           O  
ATOM   1599  ND2 ASN B  92      -5.967  54.746   2.166  1.00 21.72           N  
ATOM   1600  N   ASN B  93      -2.733  50.909  -0.895  1.00 20.63           N  
ATOM   1601  CA  ASN B  93      -1.583  50.016  -0.759  1.00 20.58           C  
ATOM   1602  C   ASN B  93      -1.177  49.945   0.707  1.00 20.87           C  
ATOM   1603  O   ASN B  93      -0.008  50.010   1.044  1.00 21.73           O  
ATOM   1604  CB  ASN B  93      -0.413  50.414  -1.677  1.00 20.54           C  
ATOM   1605  CG  ASN B  93      -0.657  50.036  -3.138  1.00 23.33           C  
ATOM   1606  OD1 ASN B  93      -1.690  49.495  -3.493  1.00 24.06           O  
ATOM   1607  ND2 ASN B  93       0.339  50.264  -3.981  1.00 24.76           N  
ATOM   1608  N   TYR B  94      -2.165  49.770   1.578  1.00 20.54           N  
ATOM   1609  CA  TYR B  94      -1.955  49.675   3.025  1.00 20.85           C  
ATOM   1610  C   TYR B  94      -1.439  48.314   3.442  1.00 20.78           C  
ATOM   1611  O   TYR B  94      -0.662  48.205   4.394  1.00 21.02           O  
ATOM   1612  CB  TYR B  94      -3.295  49.947   3.724  1.00 20.42           C  
ATOM   1613  CG  TYR B  94      -3.277  49.771   5.224  1.00 20.41           C  
ATOM   1614  CD1 TYR B  94      -2.822  50.782   6.050  1.00 20.90           C  
ATOM   1615  CD2 TYR B  94      -3.695  48.585   5.817  1.00 21.12           C  
ATOM   1616  CE1 TYR B  94      -2.795  50.640   7.442  1.00 20.98           C  
ATOM   1617  CE2 TYR B  94      -3.669  48.427   7.191  1.00 21.23           C  
ATOM   1618  CZ  TYR B  94      -3.213  49.457   8.006  1.00 20.39           C  
ATOM   1619  OH  TYR B  94      -3.178  49.282   9.389  1.00 22.59           O  
ATOM   1620  N   TYR B  95      -1.880  47.265   2.762  1.00 20.81           N  
ATOM   1621  CA  TYR B  95      -1.469  45.924   3.121  1.00 20.69           C  
ATOM   1622  C   TYR B  95      -0.113  45.573   2.513  1.00 20.44           C  
ATOM   1623  O   TYR B  95       0.254  46.093   1.447  1.00 21.02           O  
ATOM   1624  CB  TYR B  95      -2.447  44.912   2.569  1.00 20.74           C  
ATOM   1625  CG  TYR B  95      -3.887  45.027   3.019  1.00 20.70           C  
ATOM   1626  CD1 TYR B  95      -4.234  44.937   4.356  1.00 19.88           C  
ATOM   1627  CD2 TYR B  95      -4.902  45.135   2.094  1.00 21.96           C  
ATOM   1628  CE1 TYR B  95      -5.598  44.951   4.743  1.00 20.53           C  
ATOM   1629  CE2 TYR B  95      -6.244  45.144   2.461  1.00 21.30           C  
ATOM   1630  CZ  TYR B  95      -6.585  45.032   3.775  1.00 21.47           C  
ATOM   1631  OH  TYR B  95      -7.925  45.025   4.079  1.00 21.98           O  
ATOM   1632  N   TRP B  96       0.605  44.669   3.181  1.00 20.20           N  
ATOM   1633  CA  TRP B  96       1.773  44.000   2.616  1.00 19.87           C  
ATOM   1634  C   TRP B  96       1.426  42.625   2.024  1.00 20.90           C  
ATOM   1635  O   TRP B  96       2.012  42.213   1.034  1.00 20.88           O  
ATOM   1636  CB  TRP B  96       2.863  43.845   3.682  1.00 20.40           C  
ATOM   1637  CG  TRP B  96       4.199  43.489   3.106  1.00 20.64           C  
ATOM   1638  CD1 TRP B  96       4.810  42.273   3.132  1.00 22.03           C  
ATOM   1639  CD2 TRP B  96       5.087  44.369   2.398  1.00 20.97           C  
ATOM   1640  NE1 TRP B  96       6.030  42.343   2.494  1.00 21.83           N  
ATOM   1641  CE2 TRP B  96       6.217  43.620   2.034  1.00 21.74           C  
ATOM   1642  CE3 TRP B  96       5.029  45.718   2.042  1.00 20.51           C  
ATOM   1643  CZ2 TRP B  96       7.280  44.177   1.325  1.00 21.61           C  
ATOM   1644  CZ3 TRP B  96       6.080  46.269   1.350  1.00 21.90           C  
ATOM   1645  CH2 TRP B  96       7.192  45.501   0.996  1.00 21.37           C  
ATOM   1646  N   SER B  97       0.470  41.943   2.644  1.00 20.67           N  
ATOM   1647  CA  SER B  97       0.105  40.581   2.288  1.00 20.21           C  
ATOM   1648  C   SER B  97      -1.404  40.436   2.081  1.00 20.14           C  
ATOM   1649  O   SER B  97      -2.192  41.043   2.805  1.00 20.80           O  
ATOM   1650  CB  SER B  97       0.523  39.655   3.438  1.00 20.71           C  
ATOM   1651  OG  SER B  97       0.086  38.324   3.218  1.00 21.15           O  
ATOM   1652  N   ALA B  98      -1.802  39.587   1.128  1.00 19.98           N  
ATOM   1653  CA  ALA B  98      -3.201  39.257   0.954  1.00 20.18           C  
ATOM   1654  C   ALA B  98      -3.776  38.619   2.216  1.00 20.27           C  
ATOM   1655  O   ALA B  98      -4.985  38.673   2.428  1.00 20.56           O  
ATOM   1656  CB  ALA B  98      -3.402  38.335  -0.245  1.00 20.44           C  
ATOM   1657  N   SER B  99      -2.946  38.001   3.052  1.00 19.89           N  
ATOM   1658  CA  SER B  99      -3.446  37.435   4.300  1.00 19.51           C  
ATOM   1659  C   SER B  99      -4.062  38.511   5.196  1.00 20.30           C  
ATOM   1660  O   SER B  99      -4.970  38.201   5.968  1.00 20.12           O  
ATOM   1661  CB  SER B  99      -2.330  36.738   5.068  1.00 19.92           C  
ATOM   1662  OG  SER B  99      -1.754  35.700   4.269  1.00 21.49           O  
ATOM   1663  N   GLU B 100      -3.581  39.744   5.113  1.00 19.57           N  
ATOM   1664  CA  GLU B 100      -4.173  40.836   5.915  1.00 20.27           C  
ATOM   1665  C   GLU B 100      -5.568  41.190   5.413  1.00 20.00           C  
ATOM   1666  O   GLU B 100      -6.468  41.501   6.201  1.00 20.88           O  
ATOM   1667  CB  GLU B 100      -3.319  42.098   5.860  1.00 20.42           C  
ATOM   1668  CG  GLU B 100      -1.975  42.000   6.502  1.00 21.61           C  
ATOM   1669  CD  GLU B 100      -1.138  43.199   6.120  1.00 21.56           C  
ATOM   1670  OE1 GLU B 100      -1.381  44.291   6.681  1.00 22.54           O  
ATOM   1671  OE2 GLU B 100      -0.279  43.058   5.222  1.00 21.57           O  
ATOM   1672  N   CYS B 101      -5.760  41.154   4.098  1.00 20.39           N  
ATOM   1673  CA  CYS B 101      -7.047  41.443   3.543  1.00 20.50           C  
ATOM   1674  C   CYS B 101      -8.029  40.345   3.950  1.00 20.17           C  
ATOM   1675  O   CYS B 101      -9.185  40.609   4.314  1.00 20.86           O  
ATOM   1676  CB  CYS B 101      -6.922  41.585   2.011  1.00 20.71           C  
ATOM   1677  SG  CYS B 101      -8.464  41.990   1.209  1.00 21.95           S  
ATOM   1678  N   MET B 102      -7.573  39.099   3.914  1.00 19.37           N  
ATOM   1679  CA  MET B 102      -8.396  37.970   4.375  1.00 19.70           C  
ATOM   1680  C   MET B 102      -8.755  38.108   5.846  1.00 19.50           C  
ATOM   1681  O   MET B 102      -9.913  37.877   6.234  1.00 20.58           O  
ATOM   1682  CB  MET B 102      -7.685  36.654   4.117  1.00 20.18           C  
ATOM   1683  CG  MET B 102      -7.566  36.342   2.641  1.00 21.97           C  
ATOM   1684  SD  MET B 102      -6.547  34.936   2.300  1.00 25.75           S  
ATOM   1685  CE  MET B 102      -7.275  33.736   3.402  1.00 27.15           C  
ATOM   1686  N   GLN B 103      -7.791  38.553   6.660  1.00 20.04           N  
ATOM   1687  CA  GLN B 103      -8.040  38.829   8.077  1.00 20.25           C  
ATOM   1688  C   GLN B 103      -9.197  39.810   8.224  1.00 20.40           C  
ATOM   1689  O   GLN B 103     -10.123  39.607   9.030  1.00 21.32           O  
ATOM   1690  CB  GLN B 103      -6.779  39.403   8.750  1.00 20.37           C  
ATOM   1691  CG  GLN B 103      -7.000  39.883  10.197  1.00 20.49           C  
ATOM   1692  CD  GLN B 103      -5.817  40.634  10.741  1.00 20.14           C  
ATOM   1693  OE1 GLN B 103      -5.053  41.242   9.994  1.00 21.96           O  
ATOM   1694  NE2 GLN B 103      -5.642  40.569  12.067  1.00 21.89           N  
ATOM   1695  N   ASP B 104      -9.168  40.885   7.469  1.00 20.56           N  
ATOM   1696  CA  ASP B 104     -10.223  41.892   7.569  1.00 20.42           C  
ATOM   1697  C   ASP B 104     -11.595  41.345   7.173  1.00 20.81           C  
ATOM   1698  O   ASP B 104     -12.603  41.614   7.842  1.00 20.87           O  
ATOM   1699  CB  ASP B 104      -9.866  43.137   6.758  1.00 20.70           C  
ATOM   1700  CG  ASP B 104      -8.712  43.936   7.350  1.00 20.83           C  
ATOM   1701  OD1 ASP B 104      -8.344  43.708   8.497  1.00 21.40           O  
ATOM   1702  OD2 ASP B 104      -8.200  44.842   6.638  1.00 20.87           O  
ATOM   1703  N   PHE B 105     -11.657  40.582   6.094  1.00 20.91           N  
ATOM   1704  CA  PHE B 105     -12.932  39.919   5.744  1.00 20.72           C  
ATOM   1705  C   PHE B 105     -13.402  39.000   6.854  1.00 20.29           C  
ATOM   1706  O   PHE B 105     -14.567  39.019   7.236  1.00 21.82           O  
ATOM   1707  CB  PHE B 105     -12.831  39.131   4.462  1.00 19.87           C  
ATOM   1708  CG  PHE B 105     -13.126  39.955   3.228  1.00 20.13           C  
ATOM   1709  CD1 PHE B 105     -14.431  40.345   2.968  1.00 19.77           C  
ATOM   1710  CD2 PHE B 105     -12.122  40.375   2.367  1.00 18.60           C  
ATOM   1711  CE1 PHE B 105     -14.733  41.098   1.869  1.00 19.36           C  
ATOM   1712  CE2 PHE B 105     -12.439  41.131   1.274  1.00 19.04           C  
ATOM   1713  CZ  PHE B 105     -13.757  41.502   1.028  1.00 19.45           C  
ATOM   1714  N   ASN B 106     -12.492  38.237   7.418  1.00 20.62           N  
ATOM   1715  CA  ASN B 106     -12.900  37.321   8.489  1.00 21.17           C  
ATOM   1716  C   ASN B 106     -13.371  38.054   9.742  1.00 21.34           C  
ATOM   1717  O   ASN B 106     -14.332  37.623  10.388  1.00 21.43           O  
ATOM   1718  CB  ASN B 106     -11.814  36.296   8.714  1.00 21.66           C  
ATOM   1719  CG  ASN B 106     -11.882  35.209   7.648  1.00 22.78           C  
ATOM   1720  OD1 ASN B 106     -12.985  34.754   7.311  1.00 30.49           O  
ATOM   1721  ND2 ASN B 106     -10.787  34.872   7.076  1.00 25.81           N  
ATOM   1722  N   THR B 107     -12.750  39.186  10.055  1.00 21.71           N  
ATOM   1723  CA  THR B 107     -13.218  40.011  11.168  1.00 21.61           C  
ATOM   1724  C   THR B 107     -14.636  40.511  10.899  1.00 21.55           C  
ATOM   1725  O   THR B 107     -15.507  40.460  11.765  1.00 22.18           O  
ATOM   1726  CB  THR B 107     -12.274  41.201  11.385  1.00 21.74           C  
ATOM   1727  OG1 THR B 107     -10.974  40.693  11.721  1.00 21.27           O  
ATOM   1728  CG2 THR B 107     -12.774  42.126  12.494  1.00 21.74           C  
ATOM   1729  N   MET B 108     -14.889  40.972   9.676  1.00 21.13           N  
ATOM   1730  CA  MET B 108     -16.197  41.466   9.298  1.00 21.12           C  
ATOM   1731  C   MET B 108     -17.253  40.375   9.465  1.00 21.07           C  
ATOM   1732  O   MET B 108     -18.332  40.627  10.029  1.00 20.92           O  
ATOM   1733  CB  MET B 108     -16.163  41.967   7.845  1.00 21.29           C  
ATOM   1734  CG  MET B 108     -17.447  42.590   7.375  1.00 22.53           C  
ATOM   1735  SD  MET B 108     -17.370  43.132   5.652  1.00 21.22           S  
ATOM   1736  CE  MET B 108     -17.757  41.605   4.799  1.00 22.88           C  
ATOM   1737  N   PHE B 109     -16.963  39.183   8.951  1.00 20.83           N  
ATOM   1738  CA  PHE B 109     -17.932  38.087   9.049  1.00 20.06           C  
ATOM   1739  C   PHE B 109     -18.091  37.653  10.494  1.00 20.38           C  
ATOM   1740  O   PHE B 109     -19.220  37.486  10.990  1.00 20.61           O  
ATOM   1741  CB  PHE B 109     -17.539  36.889   8.154  1.00 19.76           C  
ATOM   1742  CG  PHE B 109     -17.549  37.198   6.676  1.00 20.40           C  
ATOM   1743  CD1 PHE B 109     -18.664  37.760   6.062  1.00 21.97           C  
ATOM   1744  CD2 PHE B 109     -16.448  36.891   5.877  1.00 20.74           C  
ATOM   1745  CE1 PHE B 109     -18.651  38.037   4.700  1.00 22.62           C  
ATOM   1746  CE2 PHE B 109     -16.458  37.161   4.520  1.00 20.82           C  
ATOM   1747  CZ  PHE B 109     -17.565  37.719   3.939  1.00 21.64           C  
ATOM   1748  N   THR B 110     -16.979  37.469  11.198  1.00 20.29           N  
ATOM   1749  CA  THR B 110     -17.035  37.027  12.586  1.00 20.62           C  
ATOM   1750  C   THR B 110     -17.820  38.002  13.460  1.00 20.51           C  
ATOM   1751  O   THR B 110     -18.644  37.583  14.296  1.00 20.71           O  
ATOM   1752  CB  THR B 110     -15.618  36.839  13.137  1.00 20.92           C  
ATOM   1753  OG1 THR B 110     -15.011  35.742  12.457  1.00 21.48           O  
ATOM   1754  CG2 THR B 110     -15.620  36.557  14.635  1.00 20.96           C  
ATOM   1755  N   ASN B 111     -17.623  39.300  13.257  1.00 20.93           N  
ATOM   1756  CA  ASN B 111     -18.383  40.275  14.045  1.00 21.05           C  
ATOM   1757  C   ASN B 111     -19.882  40.080  13.847  1.00 20.92           C  
ATOM   1758  O   ASN B 111     -20.682  40.163  14.786  1.00 20.74           O  
ATOM   1759  CB  ASN B 111     -18.039  41.715  13.638  1.00 21.45           C  
ATOM   1760  CG  ASN B 111     -16.684  42.173  14.131  1.00 21.92           C  
ATOM   1761  OD1 ASN B 111     -16.124  41.593  15.037  1.00 22.63           O  
ATOM   1762  ND2 ASN B 111     -16.176  43.251  13.519  1.00 22.36           N  
ATOM   1763  N   CYS B 112     -20.267  39.847  12.606  1.00 20.62           N  
ATOM   1764  CA  CYS B 112     -21.674  39.660  12.279  1.00 21.14           C  
ATOM   1765  C   CYS B 112     -22.234  38.432  12.991  1.00 20.20           C  
ATOM   1766  O   CYS B 112     -23.322  38.461  13.581  1.00 20.80           O  
ATOM   1767  CB  CYS B 112     -21.809  39.528  10.758  1.00 21.63           C  
ATOM   1768  SG  CYS B 112     -23.468  39.444  10.160  1.00 22.52           S  
ATOM   1769  N   TYR B 113     -21.483  37.341  12.947  1.00 19.85           N  
ATOM   1770  CA  TYR B 113     -21.935  36.097  13.558  1.00 19.75           C  
ATOM   1771  C   TYR B 113     -21.922  36.154  15.080  1.00 19.52           C  
ATOM   1772  O   TYR B 113     -22.741  35.512  15.745  1.00 20.08           O  
ATOM   1773  CB  TYR B 113     -21.086  34.928  13.061  1.00 20.51           C  
ATOM   1774  CG  TYR B 113     -21.041  34.791  11.558  1.00 20.22           C  
ATOM   1775  CD1 TYR B 113     -22.113  35.171  10.762  1.00 20.91           C  
ATOM   1776  CD2 TYR B 113     -19.910  34.290  10.927  1.00 20.58           C  
ATOM   1777  CE1 TYR B 113     -22.067  35.047   9.386  1.00 21.00           C  
ATOM   1778  CE2 TYR B 113     -19.866  34.146   9.552  1.00 20.77           C  
ATOM   1779  CZ  TYR B 113     -20.947  34.534   8.791  1.00 20.84           C  
ATOM   1780  OH  TYR B 113     -20.921  34.420   7.422  1.00 22.76           O  
ATOM   1781  N   ILE B 114     -21.012  36.940  15.649  1.00 19.68           N  
ATOM   1782  CA  ILE B 114     -21.004  37.118  17.108  1.00 20.09           C  
ATOM   1783  C   ILE B 114     -22.213  37.916  17.569  1.00 19.93           C  
ATOM   1784  O   ILE B 114     -22.892  37.531  18.517  1.00 20.31           O  
ATOM   1785  CB  ILE B 114     -19.729  37.855  17.578  1.00 19.84           C  
ATOM   1786  CG1 ILE B 114     -18.506  36.927  17.493  1.00 20.27           C  
ATOM   1787  CG2 ILE B 114     -19.897  38.407  19.001  1.00 21.07           C  
ATOM   1788  CD1 ILE B 114     -17.185  37.683  17.638  1.00 20.90           C  
ATOM   1789  N   TYR B 115     -22.474  39.037  16.898  1.00 19.90           N  
ATOM   1790  CA  TYR B 115     -23.473  39.980  17.394  1.00 19.66           C  
ATOM   1791  C   TYR B 115     -24.907  39.524  17.160  1.00 20.29           C  
ATOM   1792  O   TYR B 115     -25.759  39.680  18.026  1.00 19.61           O  
ATOM   1793  CB  TYR B 115     -23.295  41.369  16.770  1.00 20.19           C  
ATOM   1794  CG  TYR B 115     -24.239  42.354  17.381  1.00 20.25           C  
ATOM   1795  CD1 TYR B 115     -23.986  42.891  18.635  1.00 20.21           C  
ATOM   1796  CD2 TYR B 115     -25.449  42.677  16.768  1.00 20.45           C  
ATOM   1797  CE1 TYR B 115     -24.868  43.754  19.229  1.00 20.37           C  
ATOM   1798  CE2 TYR B 115     -26.342  43.544  17.357  1.00 20.59           C  
ATOM   1799  CZ  TYR B 115     -26.054  44.074  18.590  1.00 19.90           C  
ATOM   1800  OH  TYR B 115     -26.959  44.939  19.171  1.00 23.58           O  
ATOM   1801  N   ASN B 116     -25.171  38.971  15.978  1.00 20.34           N  
ATOM   1802  CA  ASN B 116     -26.538  38.714  15.543  1.00 20.75           C  
ATOM   1803  C   ASN B 116     -27.001  37.293  15.815  1.00 21.83           C  
ATOM   1804  O   ASN B 116     -26.195  36.383  16.037  1.00 22.92           O  
ATOM   1805  CB  ASN B 116     -26.654  39.040  14.051  1.00 20.61           C  
ATOM   1806  CG  ASN B 116     -26.348  40.497  13.757  1.00 21.08           C  
ATOM   1807  OD1 ASN B 116     -27.189  41.371  13.976  1.00 21.45           O  
ATOM   1808  ND2 ASN B 116     -25.135  40.766  13.296  1.00 20.43           N  
ATOM   1809  N   LYS B 117     -28.315  37.111  15.823  1.00 22.41           N  
ATOM   1810  CA  LYS B 117     -28.897  35.778  15.923  1.00 23.30           C  
ATOM   1811  C   LYS B 117     -28.676  35.041  14.607  1.00 23.54           C  
ATOM   1812  O   LYS B 117     -28.693  35.661  13.535  1.00 23.72           O  
ATOM   1813  CB  LYS B 117     -30.392  35.854  16.206  1.00 23.29           C  
ATOM   1814  CG  LYS B 117     -30.759  36.529  17.515  1.00 24.81           C  
ATOM   1815  CD  LYS B 117     -32.267  36.430  17.774  1.00 26.07           C  
ATOM   1816  CE  LYS B 117     -32.740  37.449  18.801  1.00 27.56           C  
ATOM   1817  NZ  LYS B 117     -32.544  38.860  18.325  1.00 28.18           N  
ATOM   1818  N   PRO B 118     -28.475  33.709  14.664  1.00 24.75           N  
ATOM   1819  CA  PRO B 118     -28.237  32.916  13.443  1.00 24.97           C  
ATOM   1820  C   PRO B 118     -29.282  33.070  12.334  1.00 24.97           C  
ATOM   1821  O   PRO B 118     -28.967  32.850  11.161  1.00 26.11           O  
ATOM   1822  CB  PRO B 118     -28.229  31.474  13.949  1.00 25.69           C  
ATOM   1823  CG  PRO B 118     -27.904  31.566  15.394  1.00 26.30           C  
ATOM   1824  CD  PRO B 118     -28.410  32.886  15.885  1.00 24.91           C  
ATOM   1825  N   THR B 119     -30.506  33.438  12.702  1.00 24.19           N  
ATOM   1826  CA  THR B 119     -31.618  33.553  11.769  1.00 23.79           C  
ATOM   1827  C   THR B 119     -31.827  34.975  11.223  1.00 22.93           C  
ATOM   1828  O   THR B 119     -32.654  35.182  10.329  1.00 22.44           O  
ATOM   1829  CB  THR B 119     -32.918  33.105  12.445  1.00 23.91           C  
ATOM   1830  OG1 THR B 119     -33.109  33.844  13.659  1.00 24.03           O  
ATOM   1831  CG2 THR B 119     -32.873  31.608  12.772  1.00 25.09           C  
ATOM   1832  N   ASP B 120     -31.089  35.950  11.747  1.00 21.86           N  
ATOM   1833  CA  ASP B 120     -31.223  37.329  11.279  1.00 22.01           C  
ATOM   1834  C   ASP B 120     -30.865  37.448   9.798  1.00 22.31           C  
ATOM   1835  O   ASP B 120     -29.924  36.812   9.321  1.00 22.15           O  
ATOM   1836  CB  ASP B 120     -30.334  38.282  12.083  1.00 21.91           C  
ATOM   1837  CG  ASP B 120     -30.822  38.506  13.511  1.00 22.46           C  
ATOM   1838  OD1 ASP B 120     -31.983  38.167  13.841  1.00 22.52           O  
ATOM   1839  OD2 ASP B 120     -30.023  39.050  14.302  1.00 24.15           O  
ATOM   1840  N   ASP B 121     -31.622  38.270   9.080  1.00 22.67           N  
ATOM   1841  CA  ASP B 121     -31.341  38.545   7.666  1.00 23.03           C  
ATOM   1842  C   ASP B 121     -29.872  38.883   7.423  1.00 22.64           C  
ATOM   1843  O   ASP B 121     -29.288  38.400   6.462  1.00 22.74           O  
ATOM   1844  CB  ASP B 121     -32.226  39.684   7.149  1.00 23.49           C  
ATOM   1845  CG  ASP B 121     -33.672  39.266   6.963  1.00 25.02           C  
ATOM   1846  OD1 ASP B 121     -33.948  38.052   6.822  1.00 27.95           O  
ATOM   1847  OD2 ASP B 121     -34.546  40.161   6.946  1.00 28.58           O  
ATOM   1848  N   ILE B 122     -29.265  39.705   8.276  1.00 21.91           N  
ATOM   1849  CA  ILE B 122     -27.876  40.116   8.053  1.00 21.79           C  
ATOM   1850  C   ILE B 122     -26.890  38.940   8.091  1.00 21.66           C  
ATOM   1851  O   ILE B 122     -25.866  38.960   7.391  1.00 21.63           O  
ATOM   1852  CB  ILE B 122     -27.450  41.217   9.058  1.00 21.87           C  
ATOM   1853  CG1 ILE B 122     -26.189  41.929   8.584  1.00 23.31           C  
ATOM   1854  CG2 ILE B 122     -27.298  40.654  10.475  1.00 21.89           C  
ATOM   1855  CD1 ILE B 122     -26.372  42.712   7.313  1.00 26.05           C  
ATOM   1856  N   VAL B 123     -27.194  37.921   8.897  1.00 20.92           N  
ATOM   1857  CA  VAL B 123     -26.329  36.738   8.990  1.00 20.88           C  
ATOM   1858  C   VAL B 123     -26.455  35.924   7.703  1.00 21.07           C  
ATOM   1859  O   VAL B 123     -25.456  35.478   7.138  1.00 21.16           O  
ATOM   1860  CB  VAL B 123     -26.678  35.876  10.229  1.00 20.27           C  
ATOM   1861  CG1 VAL B 123     -26.034  34.495  10.135  1.00 21.52           C  
ATOM   1862  CG2 VAL B 123     -26.258  36.599  11.495  1.00 20.98           C  
ATOM   1863  N   LEU B 124     -27.670  35.763   7.215  1.00 20.96           N  
ATOM   1864  CA  LEU B 124     -27.876  35.062   5.951  1.00 20.69           C  
ATOM   1865  C   LEU B 124     -27.155  35.798   4.805  1.00 20.95           C  
ATOM   1866  O   LEU B 124     -26.542  35.165   3.942  1.00 21.82           O  
ATOM   1867  CB  LEU B 124     -29.374  34.901   5.673  1.00 20.86           C  
ATOM   1868  CG  LEU B 124     -30.118  33.810   6.468  1.00 21.92           C  
ATOM   1869  CD1 LEU B 124     -29.862  33.850   7.955  1.00 25.27           C  
ATOM   1870  CD2 LEU B 124     -31.629  33.899   6.195  1.00 21.94           C  
ATOM   1871  N   MET B 125     -27.216  37.126   4.805  1.00 19.89           N  
ATOM   1872  CA  MET B 125     -26.525  37.938   3.801  1.00 19.57           C  
ATOM   1873  C   MET B 125     -25.010  37.750   3.891  1.00 20.04           C  
ATOM   1874  O   MET B 125     -24.334  37.528   2.882  1.00 20.82           O  
ATOM   1875  CB  MET B 125     -26.908  39.410   3.956  1.00 19.04           C  
ATOM   1876  CG  MET B 125     -28.400  39.670   3.654  1.00 18.57           C  
ATOM   1877  SD  MET B 125     -28.991  41.276   4.156  1.00 17.76           S  
ATOM   1878  CE  MET B 125     -28.466  42.257   2.747  1.00 16.15           C  
ATOM   1879  N   ALA B 126     -24.483  37.837   5.107  1.00 19.94           N  
ATOM   1880  CA  ALA B 126     -23.060  37.607   5.350  1.00 20.38           C  
ATOM   1881  C   ALA B 126     -22.633  36.220   4.898  1.00 21.19           C  
ATOM   1882  O   ALA B 126     -21.566  36.064   4.309  1.00 22.29           O  
ATOM   1883  CB  ALA B 126     -22.720  37.796   6.812  1.00 20.36           C  
ATOM   1884  N   GLN B 127     -23.443  35.204   5.174  1.00 21.08           N  
ATOM   1885  CA  GLN B 127     -23.093  33.849   4.790  1.00 20.61           C  
ATOM   1886  C   GLN B 127     -23.019  33.701   3.275  1.00 20.79           C  
ATOM   1887  O   GLN B 127     -22.151  32.983   2.779  1.00 21.42           O  
ATOM   1888  CB  GLN B 127     -24.058  32.826   5.402  1.00 21.25           C  
ATOM   1889  CG  GLN B 127     -23.861  32.643   6.913  1.00 21.08           C  
ATOM   1890  CD  GLN B 127     -24.956  31.840   7.605  1.00 22.83           C  
ATOM   1891  OE1 GLN B 127     -24.720  31.227   8.649  1.00 25.95           O  
ATOM   1892  NE2 GLN B 127     -26.157  31.864   7.051  1.00 20.54           N  
ATOM   1893  N   ALA B 128     -23.913  34.375   2.548  1.00 20.91           N  
ATOM   1894  CA  ALA B 128     -23.897  34.322   1.084  1.00 21.22           C  
ATOM   1895  C   ALA B 128     -22.609  34.922   0.557  1.00 21.59           C  
ATOM   1896  O   ALA B 128     -21.965  34.356  -0.326  1.00 21.69           O  
ATOM   1897  CB  ALA B 128     -25.111  35.046   0.495  1.00 21.13           C  
ATOM   1898  N   LEU B 129     -22.218  36.056   1.117  1.00 21.33           N  
ATOM   1899  CA  LEU B 129     -20.980  36.709   0.713  1.00 21.03           C  
ATOM   1900  C   LEU B 129     -19.753  35.893   1.106  1.00 21.60           C  
ATOM   1901  O   LEU B 129     -18.802  35.813   0.333  1.00 21.38           O  
ATOM   1902  CB  LEU B 129     -20.890  38.108   1.322  1.00 20.70           C  
ATOM   1903  CG  LEU B 129     -21.979  39.087   0.899  1.00 21.52           C  
ATOM   1904  CD1 LEU B 129     -21.849  40.380   1.698  1.00 22.15           C  
ATOM   1905  CD2 LEU B 129     -21.904  39.379  -0.572  1.00 21.02           C  
ATOM   1906  N   GLU B 130     -19.770  35.283   2.292  1.00 21.24           N  
ATOM   1907  CA  GLU B 130     -18.632  34.500   2.759  1.00 20.87           C  
ATOM   1908  C   GLU B 130     -18.412  33.314   1.835  1.00 21.59           C  
ATOM   1909  O   GLU B 130     -17.266  32.961   1.543  1.00 21.32           O  
ATOM   1910  CB  GLU B 130     -18.824  34.034   4.216  1.00 20.41           C  
ATOM   1911  CG  GLU B 130     -17.600  33.313   4.757  1.00 20.29           C  
ATOM   1912  CD  GLU B 130     -17.762  32.782   6.160  1.00 20.42           C  
ATOM   1913  OE1 GLU B 130     -18.882  32.832   6.711  1.00 21.93           O  
ATOM   1914  OE2 GLU B 130     -16.755  32.282   6.714  1.00 23.52           O  
ATOM   1915  N   LYS B 131     -19.501  32.713   1.353  1.00 21.65           N  
ATOM   1916  CA  LYS B 131     -19.394  31.598   0.411  1.00 21.67           C  
ATOM   1917  C   LYS B 131     -18.615  32.007  -0.838  1.00 22.11           C  
ATOM   1918  O   LYS B 131     -17.719  31.288  -1.298  1.00 22.18           O  
ATOM   1919  CB  LYS B 131     -20.783  31.084   0.003  1.00 22.02           C  
ATOM   1920  CG  LYS B 131     -20.758  29.858  -0.876  1.00 23.16           C  
ATOM   1921  CD  LYS B 131     -22.136  29.238  -1.046  1.00 23.59           C  
ATOM   1922  CE  LYS B 131     -22.063  27.895  -1.760  1.00 24.70           C  
ATOM   1923  NZ  LYS B 131     -23.366  27.198  -1.741  1.00 25.62           N  
ATOM   1924  N   ILE B 132     -18.959  33.165  -1.384  1.00 21.85           N  
ATOM   1925  CA  ILE B 132     -18.290  33.663  -2.576  1.00 21.48           C  
ATOM   1926  C   ILE B 132     -16.844  34.041  -2.240  1.00 21.28           C  
ATOM   1927  O   ILE B 132     -15.932  33.743  -3.007  1.00 21.36           O  
ATOM   1928  CB  ILE B 132     -19.055  34.853  -3.199  1.00 21.06           C  
ATOM   1929  CG1 ILE B 132     -20.459  34.416  -3.627  1.00 22.53           C  
ATOM   1930  CG2 ILE B 132     -18.289  35.423  -4.381  1.00 21.39           C  
ATOM   1931  CD1 ILE B 132     -21.365  35.569  -4.037  1.00 23.91           C  
ATOM   1932  N   PHE B 133     -16.629  34.688  -1.093  1.00 20.46           N  
ATOM   1933  CA  PHE B 133     -15.284  35.027  -0.636  1.00 20.81           C  
ATOM   1934  C   PHE B 133     -14.388  33.794  -0.635  1.00 21.11           C  
ATOM   1935  O   PHE B 133     -13.297  33.810  -1.196  1.00 20.98           O  
ATOM   1936  CB  PHE B 133     -15.385  35.654   0.757  1.00 20.23           C  
ATOM   1937  CG  PHE B 133     -14.075  35.757   1.509  1.00 20.29           C  
ATOM   1938  CD1 PHE B 133     -13.167  36.752   1.205  1.00 18.78           C  
ATOM   1939  CD2 PHE B 133     -13.775  34.882   2.549  1.00 21.29           C  
ATOM   1940  CE1 PHE B 133     -11.974  36.854   1.886  1.00 18.46           C  
ATOM   1941  CE2 PHE B 133     -12.590  34.990   3.257  1.00 20.22           C  
ATOM   1942  CZ  PHE B 133     -11.683  35.980   2.933  1.00 19.84           C  
ATOM   1943  N   LEU B 134     -14.850  32.713  -0.023  1.00 20.73           N  
ATOM   1944  CA  LEU B 134     -14.058  31.492   0.053  1.00 20.76           C  
ATOM   1945  C   LEU B 134     -13.800  30.891  -1.330  1.00 20.99           C  
ATOM   1946  O   LEU B 134     -12.708  30.393  -1.603  1.00 21.30           O  
ATOM   1947  CB  LEU B 134     -14.740  30.480   0.980  1.00 20.30           C  
ATOM   1948  CG  LEU B 134     -14.746  30.927   2.440  1.00 20.14           C  
ATOM   1949  CD1 LEU B 134     -15.579  29.978   3.281  1.00 21.86           C  
ATOM   1950  CD2 LEU B 134     -13.323  30.989   2.971  1.00 20.36           C  
ATOM   1951  N   GLN B 135     -14.802  30.924  -2.198  1.00 21.24           N  
ATOM   1952  CA  GLN B 135     -14.642  30.405  -3.554  1.00 21.02           C  
ATOM   1953  C   GLN B 135     -13.582  31.196  -4.307  1.00 20.58           C  
ATOM   1954  O   GLN B 135     -12.732  30.617  -4.986  1.00 21.38           O  
ATOM   1955  CB  GLN B 135     -15.969  30.453  -4.323  1.00 21.48           C  
ATOM   1956  CG  GLN B 135     -16.926  29.325  -3.945  1.00 23.55           C  
ATOM   1957  CD  GLN B 135     -18.360  29.527  -4.456  1.00 27.87           C  
ATOM   1958  OE1 GLN B 135     -18.703  30.579  -4.999  1.00 32.15           O  
ATOM   1959  NE2 GLN B 135     -19.204  28.524  -4.252  1.00 27.30           N  
ATOM   1960  N   LYS B 136     -13.633  32.520  -4.195  1.00 20.13           N  
ATOM   1961  CA  LYS B 136     -12.652  33.355  -4.890  1.00 19.80           C  
ATOM   1962  C   LYS B 136     -11.255  33.220  -4.298  1.00 20.39           C  
ATOM   1963  O   LYS B 136     -10.268  33.184  -5.037  1.00 20.22           O  
ATOM   1964  CB  LYS B 136     -13.090  34.823  -4.930  1.00 19.97           C  
ATOM   1965  CG  LYS B 136     -14.371  35.074  -5.703  1.00 21.04           C  
ATOM   1966  CD  LYS B 136     -14.274  34.551  -7.124  1.00 22.50           C  
ATOM   1967  CE  LYS B 136     -15.392  35.068  -8.000  1.00 23.87           C  
ATOM   1968  NZ  LYS B 136     -15.297  34.508  -9.373  1.00 24.80           N  
ATOM   1969  N   VAL B 137     -11.156  33.130  -2.978  1.00 20.54           N  
ATOM   1970  CA  VAL B 137      -9.851  32.974  -2.343  1.00 20.82           C  
ATOM   1971  C   VAL B 137      -9.202  31.640  -2.758  1.00 20.91           C  
ATOM   1972  O   VAL B 137      -7.992  31.589  -2.976  1.00 20.62           O  
ATOM   1973  CB  VAL B 137      -9.958  33.090  -0.818  1.00 20.54           C  
ATOM   1974  CG1 VAL B 137      -8.686  32.568  -0.135  1.00 21.98           C  
ATOM   1975  CG2 VAL B 137     -10.245  34.539  -0.442  1.00 21.64           C  
ATOM   1976  N   ALA B 138     -10.003  30.585  -2.922  1.00 20.74           N  
ATOM   1977  CA  ALA B 138      -9.488  29.286  -3.332  1.00 20.98           C  
ATOM   1978  C   ALA B 138      -8.916  29.303  -4.750  1.00 20.93           C  
ATOM   1979  O   ALA B 138      -8.155  28.414  -5.106  1.00 21.38           O  
ATOM   1980  CB  ALA B 138     -10.582  28.232  -3.208  1.00 20.70           C  
ATOM   1981  N   GLN B 139      -9.291  30.296  -5.552  1.00 21.00           N  
ATOM   1982  CA  GLN B 139      -8.790  30.439  -6.924  1.00 21.63           C  
ATOM   1983  C   GLN B 139      -7.688  31.483  -7.051  1.00 21.31           C  
ATOM   1984  O   GLN B 139      -7.233  31.791  -8.145  1.00 21.72           O  
ATOM   1985  CB  GLN B 139      -9.941  30.830  -7.839  1.00 22.13           C  
ATOM   1986  CG  GLN B 139     -10.992  29.744  -7.978  1.00 23.28           C  
ATOM   1987  CD  GLN B 139     -12.200  30.223  -8.749  1.00 25.10           C  
ATOM   1988  OE1 GLN B 139     -12.784  31.248  -8.432  1.00 29.12           O  
ATOM   1989  NE2 GLN B 139     -12.581  29.477  -9.760  1.00 27.14           N  
ATOM   1990  N   MET B 140      -7.273  32.051  -5.927  1.00 21.06           N  
ATOM   1991  CA  MET B 140      -6.246  33.062  -5.969  1.00 21.20           C  
ATOM   1992  C   MET B 140      -4.936  32.429  -6.419  1.00 21.19           C  
ATOM   1993  O   MET B 140      -4.568  31.358  -5.930  1.00 21.34           O  
ATOM   1994  CB  MET B 140      -6.074  33.693  -4.602  1.00 21.52           C  
ATOM   1995  CG  MET B 140      -4.989  34.733  -4.568  1.00 21.85           C  
ATOM   1996  SD  MET B 140      -4.868  35.618  -3.029  1.00 25.65           S  
ATOM   1997  CE  MET B 140      -5.903  34.673  -1.899  1.00 26.65           C  
ATOM   1998  N   PRO B 141      -4.221  33.097  -7.339  1.00 21.71           N  
ATOM   1999  CA  PRO B 141      -2.950  32.549  -7.803  1.00 22.02           C  
ATOM   2000  C   PRO B 141      -1.907  32.560  -6.697  1.00 21.84           C  
ATOM   2001  O   PRO B 141      -1.971  33.391  -5.796  1.00 21.23           O  
ATOM   2002  CB  PRO B 141      -2.550  33.500  -8.941  1.00 22.36           C  
ATOM   2003  CG  PRO B 141      -3.271  34.763  -8.661  1.00 23.15           C  
ATOM   2004  CD  PRO B 141      -4.542  34.382  -7.993  1.00 22.48           C  
ATOM   2005  N   GLN B 142      -0.972  31.620  -6.751  1.00 22.19           N  
ATOM   2006  CA  GLN B 142       0.133  31.601  -5.803  1.00 22.98           C  
ATOM   2007  C   GLN B 142       1.019  32.833  -6.006  1.00 23.61           C  
ATOM   2008  O   GLN B 142       1.030  33.426  -7.084  1.00 23.66           O  
ATOM   2009  CB  GLN B 142       0.950  30.318  -5.959  1.00 23.22           C  
ATOM   2010  N   GLU B 143       1.746  33.213  -4.959  1.00 24.32           N  
ATOM   2011  CA  GLU B 143       2.590  34.416  -4.982  1.00 24.60           C  
ATOM   2012  C   GLU B 143       3.660  34.346  -6.059  1.00 24.75           C  
ATOM   2013  O   GLU B 143       4.284  33.304  -6.264  1.00 25.12           O  
ATOM   2014  CB  GLU B 143       3.253  34.634  -3.617  1.00 24.82           C  
TER    2015      GLU B 143                                                      
END
MOLECULE T0432.pdb
ATOM      1  N   SER     1      12.703  45.910  -3.320  1.00 50.93           N
ATOM      2  CA  SER     1      13.109  46.216  -4.712  1.00 47.13           C
ATOM      4  CB  SER     1      13.709  44.967  -5.358  1.00 53.53           C
ATOM      7  OG  SER     1      12.759  43.911  -5.430  1.00 42.48           O
ATOM      9  C   SER     1      11.931  46.715  -5.566  1.00 52.43           C
ATOM     10  O   SER     1      10.768  46.719  -5.114  1.00 45.72           O
ATOM     14  N   MET     2      12.255  47.142  -6.791  1.00 48.01           N
ATOM     15  CA  MET     2      11.257  47.418  -7.836  1.00 53.09           C
ATOM     17  CB  MET     2      11.927  47.928  -9.120  1.00 51.71           C
ATOM     23  C   MET     2      10.424  46.169  -8.153  1.00 49.18           C
ATOM     24  O   MET     2       9.206  46.267  -8.286  1.00 51.00           O
ATOM     26  N   GLN     3      11.078  45.011  -8.268  1.00 44.90           N
ATOM     27  CA  GLN     3      10.368  43.738  -8.433  1.00 49.87           C
ATOM     29  CB  GLN     3      11.334  42.538  -8.524  1.00 49.44           C
ATOM     32  CG  GLN     3      11.990  42.326  -9.886  1.00 56.96           C
ATOM     38  C   GLN     3       9.361  43.512  -7.283  1.00 43.65           C
ATOM     39  O   GLN     3       8.242  43.071  -7.521  1.00 37.83           O
ATOM     41  N   GLU     4       9.764  43.812  -6.049  1.00 34.49           N
ATOM     42  CA  GLU     4       8.896  43.571  -4.909  1.00 28.57           C
ATOM     44  CB  GLU     4       9.695  43.588  -3.619  1.00 30.35           C
ATOM     47  CG  GLU     4      10.564  42.317  -3.478  1.00 32.03           C
ATOM     50  CD  GLU     4      11.497  42.362  -2.284  1.00 34.53           C
ATOM     51  OE1 GLU     4      11.564  43.415  -1.624  1.00 39.92           O
ATOM     52  OE2 GLU     4      12.167  41.335  -2.002  1.00 35.71           O
ATOM     53  C   GLU     4       7.708  44.529  -4.871  1.00 25.78           C
ATOM     54  O   GLU     4       6.586  44.106  -4.548  1.00 21.89           O
ATOM     56  N   GLU     5       7.958  45.807  -5.172  1.00 27.67           N
ATOM     57  CA  GLU     5       6.900  46.803  -5.275  1.00 29.37           C
ATOM     59  CB  GLU     5       7.492  48.200  -5.504  1.00 32.93           C
ATOM     62  CG  GLU     5       8.329  48.698  -4.321  1.00 36.17           C
ATOM     68  C   GLU     5       5.841  46.464  -6.357  1.00 26.28           C
ATOM     69  O   GLU     5       4.652  46.729  -6.168  1.00 24.25           O
ATOM     71  N   ASP     6       6.276  45.882  -7.472  1.00 23.77           N
ATOM     72  CA  ASP     6       5.354  45.408  -8.499  1.00 26.67           C
ATOM     74  CB  ASP     6       6.099  44.978  -9.756  1.00 25.76           C
ATOM     77  CG  ASP     6       6.749  46.165 -10.526  1.00 24.96           C
ATOM     78  OD1 ASP     6       6.374  47.338 -10.325  1.00 41.80           O
ATOM     79  OD2 ASP     6       7.653  45.870 -11.317  1.00 39.42           O
ATOM     80  C   ASP     6       4.501  44.208  -7.998  1.00 20.23           C
ATOM     81  O   ASP     6       3.358  44.093  -8.388  1.00 20.47           O
ATOM     83  N   THR     7       5.093  43.319  -7.201  1.00 22.25           N
ATOM     84  CA  THR     7       4.384  42.184  -6.606  1.00 22.70           C
ATOM     86  CB  THR     7       5.332  41.245  -5.780  1.00 22.94           C
ATOM     88  OG1 THR     7       6.367  40.712  -6.630  1.00 26.30           O
ATOM     90  CG2 THR     7       4.556  40.047  -5.132  1.00 16.87           C
ATOM     94  C   THR     7       3.250  42.693  -5.726  1.00 21.27           C
ATOM     95  O   THR     7       2.114  42.227  -5.839  1.00 18.76           O
ATOM     97  N   PHE     8       3.574  43.615  -4.823  1.00 19.23           N
ATOM     98  CA  PHE     8       2.558  44.181  -3.944  1.00 19.60           C
ATOM    100  CB  PHE     8       3.176  45.001  -2.822  1.00 22.71           C
ATOM    103  CG  PHE     8       3.951  44.177  -1.823  1.00 23.51           C
ATOM    104  CD1 PHE     8       3.439  42.949  -1.346  1.00 28.77           C
ATOM    106  CE1 PHE     8       4.152  42.173  -0.434  1.00 28.06           C
ATOM    108  CZ  PHE     8       5.373  42.635   0.031  1.00 28.78           C
ATOM    110  CE2 PHE     8       5.884  43.835  -0.423  1.00 30.30           C
ATOM    112  CD2 PHE     8       5.169  44.616  -1.353  1.00 28.10           C
ATOM    114  C   PHE     8       1.496  44.993  -4.689  1.00 22.06           C
ATOM    115  O   PHE     8       0.320  44.959  -4.316  1.00 17.45           O
ATOM    117  N   ARG     9       1.904  45.735  -5.712  1.00 20.32           N
ATOM    118  CA  ARG     9       0.939  46.442  -6.556  1.00 18.47           C
ATOM    120  CB  ARG     9       1.639  47.343  -7.542  1.00 20.96           C
ATOM    123  CG  ARG     9       0.718  48.210  -8.324  1.00 30.12           C
ATOM    126  CD  ARG     9       1.462  49.336  -8.973  1.00 33.72           C
ATOM    129  NE  ARG     9       0.560  50.358  -9.495  1.00 49.38           N
ATOM    131  CZ  ARG     9      -0.009  50.371 -10.710  1.00 50.88           C
ATOM    132  NH1 ARG     9       0.198  49.411 -11.626  1.00 36.54           N
ATOM    135  NH2 ARG     9      -0.779  51.400 -11.024  1.00 35.58           N
ATOM    138  C   ARG     9      -0.005  45.464  -7.267  1.00 18.25           C
ATOM    139  O   ARG     9      -1.217  45.710  -7.282  1.00 15.91           O
ATOM    141  N   GLU    10       0.522  44.363  -7.832  1.00 15.31           N
ATOM    142  CA  GLU    10      -0.351  43.339  -8.413  1.00 19.50           C
ATOM    144  CB  GLU    10       0.439  42.219  -9.076  1.00 21.24           C
ATOM    147  CG  GLU    10      -0.467  41.097  -9.566  1.00 23.10           C
ATOM    150  CD  GLU    10       0.189  40.117 -10.508  1.00 33.77           C
ATOM    151  OE1 GLU    10      -0.487  39.118 -10.845  1.00 26.89           O
ATOM    152  OE2 GLU    10       1.358  40.328 -10.890  1.00 26.18           O
ATOM    153  C   GLU    10      -1.355  42.768  -7.382  1.00 23.48           C
ATOM    154  O   GLU    10      -2.548  42.617  -7.692  1.00 16.96           O
ATOM    156  N   LEU    11      -0.871  42.447  -6.176  1.00 22.33           N
ATOM    157  CA  LEU    11      -1.756  42.020  -5.079  1.00 17.97           C
ATOM    159  CB  LEU    11      -0.969  41.736  -3.779  1.00 21.21           C
ATOM    162  CG  LEU    11      -1.851  41.320  -2.564  1.00 18.71           C
ATOM    164  CD1 LEU    11      -2.569  39.975  -2.827  1.00 16.49           C
ATOM    168  CD2 LEU    11      -1.052  41.296  -1.292  1.00 17.23           C
ATOM    172  C   LEU    11      -2.872  43.029  -4.826  1.00 18.50           C
ATOM    173  O   LEU    11      -4.018  42.652  -4.757  1.00 17.18           O
ATOM    175  N   ARG    12      -2.554  44.316  -4.710  1.00 16.81           N
ATOM    176  CA  ARG    12      -3.587  45.342  -4.508  1.00 18.76           C
ATOM    178  CB  ARG    12      -2.975  46.756  -4.299  1.00 15.68           C
ATOM    181  CG  ARG    12      -2.092  46.846  -3.060  1.00 20.36           C
ATOM    184  CD  ARG    12      -1.799  48.294  -2.715  1.00 24.48           C
ATOM    187  NE  ARG    12      -0.943  48.950  -3.696  1.00 19.83           N
ATOM    189  CZ  ARG    12       0.393  48.875  -3.740  1.00 17.58           C
ATOM    190  NH1 ARG    12       1.084  48.164  -2.878  1.00 25.76           N
ATOM    193  NH2 ARG    12       1.034  49.530  -4.686  1.00 24.92           N
ATOM    196  C   ARG    12      -4.628  45.388  -5.624  1.00 16.66           C
ATOM    197  O   ARG    12      -5.828  45.475  -5.353  1.00 16.08           O
ATOM    199  N   ILE    13      -4.164  45.301  -6.864  1.00 19.21           N
ATOM    200  CA  ILE    13      -5.044  45.236  -8.043  1.00 17.95           C
ATOM    202  CB  ILE    13      -4.224  45.209  -9.367  1.00 17.89           C
ATOM    204  CG1 ILE    13      -3.478  46.541  -9.577  1.00 23.66           C
ATOM    207  CD1 ILE    13      -2.498  46.500 -10.707  1.00 27.76           C
ATOM    211  CG2 ILE    13      -5.101  44.894 -10.587  1.00 24.21           C
ATOM    215  C   ILE    13      -5.997  44.011  -7.963  1.00 14.86           C
ATOM    216  O   ILE    13      -7.218  44.155  -8.154  1.00 16.18           O
ATOM    218  N   PHE    14      -5.438  42.857  -7.652  1.00 16.54           N
ATOM    219  CA  PHE    14      -6.211  41.642  -7.441  1.00 15.48           C
ATOM    221  CB  PHE    14      -5.313  40.456  -7.134  1.00 18.04           C
ATOM    224  CG  PHE    14      -6.074  39.237  -6.793  1.00 18.02           C
ATOM    225  CD1 PHE    14      -6.678  38.465  -7.790  1.00 26.02           C
ATOM    227  CE1 PHE    14      -7.424  37.332  -7.462  1.00 20.26           C
ATOM    229  CZ  PHE    14      -7.559  36.973  -6.149  1.00 20.14           C
ATOM    231  CE2 PHE    14      -6.970  37.746  -5.142  1.00 23.20           C
ATOM    233  CD2 PHE    14      -6.239  38.861  -5.465  1.00 22.05           C
ATOM    235  C   PHE    14      -7.252  41.824  -6.314  1.00 17.60           C
ATOM    236  O   PHE    14      -8.431  41.558  -6.507  1.00 16.66           O
ATOM    238  N   LEU    15      -6.807  42.332  -5.166  1.00 15.25           N
ATOM    239  CA  LEU    15      -7.701  42.555  -4.016  1.00 15.48           C
ATOM    241  CB  LEU    15      -6.921  42.915  -2.741  1.00 17.25           C
ATOM    244  CG  LEU    15      -5.972  41.845  -2.195  1.00 20.45           C
ATOM    246  CD1 LEU    15      -5.225  42.342  -0.920  1.00 15.28           C
ATOM    250  CD2 LEU    15      -6.687  40.491  -1.929  1.00 17.37           C
ATOM    254  C   LEU    15      -8.826  43.550  -4.269  1.00 16.03           C
ATOM    255  O   LEU    15      -9.961  43.320  -3.815  1.00 15.92           O
ATOM    257  N   ARG    16      -8.542  44.625  -4.980  1.00 16.38           N
ATOM    258  CA  ARG    16      -9.590  45.593  -5.363  1.00 13.95           C
ATOM    260  CB  ARG    16      -9.022  46.796  -6.096  1.00 16.47           C
ATOM    263  CG  ARG    16      -8.327  47.808  -5.243  1.00 20.20           C
ATOM    266  CD  ARG    16      -7.975  49.054  -6.021  1.00 26.38           C
ATOM    269  NE  ARG    16      -6.868  49.676  -5.338  1.00 24.76           N
ATOM    271  CZ  ARG    16      -5.583  49.547  -5.650  1.00 23.18           C
ATOM    272  NH1 ARG    16      -5.178  48.910  -6.742  1.00 24.86           N
ATOM    275  NH2 ARG    16      -4.686  50.121  -4.856  1.00 30.66           N
ATOM    278  C   ARG    16     -10.679  44.968  -6.259  1.00 13.93           C
ATOM    279  O   ARG    16     -11.864  45.248  -6.112  1.00 14.07           O
ATOM    281  N   ASN    17     -10.257  44.175  -7.218  1.00 16.80           N
ATOM    282  CA  ASN    17     -11.176  43.522  -8.112  1.00 18.78           C
ATOM    284  CB  ASN    17     -10.401  42.870  -9.247  1.00 21.01           C
ATOM    287  CG  ASN    17     -11.295  42.036 -10.170  1.00 28.67           C
ATOM    288  OD1 ASN    17     -11.469  40.838  -9.941  1.00 21.42           O
ATOM    289  ND2 ASN    17     -11.827  42.664 -11.250  1.00 28.09           N
ATOM    292  C   ASN    17     -12.089  42.535  -7.382  1.00 16.00           C
ATOM    293  O   ASN    17     -13.302  42.574  -7.591  1.00 17.86           O
ATOM    295  N   VAL    18     -11.520  41.689  -6.521  1.00 18.79           N
ATOM    296  CA  VAL    18     -12.301  40.735  -5.735  1.00 17.67           C
ATOM    298  CB  VAL    18     -11.407  39.847  -4.834  1.00 19.56           C
ATOM    300  CG1 VAL    18     -12.271  39.004  -3.891  1.00 20.84           C
ATOM    304  CG2 VAL    18     -10.450  38.989  -5.687  1.00 14.57           C
ATOM    308  C   VAL    18     -13.266  41.501  -4.810  1.00 17.37           C
ATOM    309  O   VAL    18     -14.450  41.176  -4.721  1.00 19.43           O
ATOM    311  N   THR    19     -12.747  42.526  -4.146  1.00 16.37           N
ATOM    312  CA  THR    19     -13.563  43.341  -3.222  1.00 17.39           C
ATOM    314  CB  THR    19     -12.716  44.371  -2.443  1.00 16.96           C
ATOM    316  OG1 THR    19     -11.617  43.710  -1.816  1.00 17.66           O
ATOM    318  CG2 THR    19     -13.564  45.076  -1.343  1.00 20.05           C
ATOM    322  C   THR    19     -14.744  44.026  -3.933  1.00 17.65           C
ATOM    323  O   THR    19     -15.852  44.020  -3.417  1.00 19.09           O
ATOM    325  N   HIS    20     -14.508  44.595  -5.101  1.00 19.93           N
ATOM    326  CA  HIS    20     -15.611  45.135  -5.920  1.00 19.72           C
ATOM    328  CB  HIS    20     -15.059  45.947  -7.086  0.50 21.68           C
ATOM    334  CG  HIS    20     -14.484  47.263  -6.651  0.50 31.09           C
ATOM    336  ND1 HIS    20     -15.103  48.066  -5.710  0.50 15.30           N
ATOM    340  CE1 HIS    20     -14.376  49.152  -5.520  0.50 31.02           C
ATOM    344  NE2 HIS    20     -13.308  49.082  -6.295  0.50 28.85           N
ATOM    348  CD2 HIS    20     -13.355  47.914  -7.019  0.50 25.42           C
ATOM    352  C   HIS    20     -16.660  44.095  -6.319  1.00 17.96           C
ATOM    353  O   HIS    20     -17.853  44.378  -6.303  1.00 20.97           O
ATOM    355  N   ARG    21     -16.230  42.894  -6.686  1.00 17.03           N
ATOM    356  CA  ARG    21     -17.180  41.826  -7.010  1.00 18.99           C
ATOM    358  CB  ARG    21     -16.435  40.624  -7.602  1.00 14.36           C
ATOM    361  CG  ARG    21     -15.970  40.922  -9.011  1.00 20.10           C
ATOM    364  CD  ARG    21     -14.704  40.187  -9.358  1.00 26.48           C
ATOM    367  NE  ARG    21     -14.976  38.798  -9.527  1.00 23.70           N
ATOM    369  CZ  ARG    21     -14.059  37.850  -9.652  1.00 24.65           C
ATOM    370  NH1 ARG    21     -12.773  38.120  -9.628  1.00 21.13           N
ATOM    373  NH2 ARG    21     -14.461  36.619  -9.815  1.00 21.77           N
ATOM    376  C   ARG    21     -18.083  41.435  -5.822  1.00 19.61           C
ATOM    377  O   ARG    21     -19.285  41.157  -5.992  1.00 23.33           O
ATOM    379  N   LEU    22     -17.522  41.469  -4.622  1.00 19.80           N
ATOM    380  CA  LEU    22     -18.300  41.281  -3.399  1.00 18.25           C
ATOM    382  CB  LEU    22     -17.378  41.023  -2.193  1.00 19.98           C
ATOM    385  CG  LEU    22     -16.345  39.907  -2.263  1.00 18.93           C
ATOM    387  CD1 LEU    22     -15.396  39.999  -1.040  1.00 20.62           C
ATOM    391  CD2 LEU    22     -17.018  38.495  -2.365  1.00 20.07           C
ATOM    395  C   LEU    22     -19.228  42.459  -3.101  1.00 20.64           C
ATOM    396  O   LEU    22     -20.415  42.251  -2.807  1.00 21.92           O
ATOM    398  N   ALA    23     -18.701  43.679  -3.190  1.00 17.45           N
ATOM    399  CA  ALA    23     -19.441  44.866  -2.847  1.00 17.66           C
ATOM    401  CB  ALA    23     -18.527  46.122  -2.822  1.00 21.62           C
ATOM    405  C   ALA    23     -20.644  45.119  -3.776  1.00 26.04           C
ATOM    406  O   ALA    23     -21.590  45.756  -3.360  1.00 22.48           O
ATOM    408  N   ILE    24     -20.612  44.639  -5.014  1.00 25.86           N
ATOM    409  CA  ILE    24     -21.755  44.832  -5.895  1.00 27.15           C
ATOM    411  CB  ILE    24     -21.344  45.044  -7.374  1.00 28.18           C
ATOM    413  CG1 ILE    24     -20.761  43.768  -7.966  1.00 23.99           C
ATOM    416  CD1 ILE    24     -20.472  43.872  -9.443  1.00 35.51           C
ATOM    420  CG2 ILE    24     -20.408  46.213  -7.489  1.00 34.25           C
ATOM    424  C   ILE    24     -22.790  43.706  -5.793  1.00 28.62           C
ATOM    425  O   ILE    24     -23.850  43.801  -6.384  1.00 26.67           O
ATOM    427  N   ASP    25     -22.498  42.646  -5.046  1.00 25.41           N
ATOM    428  CA  ASP    25     -23.433  41.566  -4.884  1.00 26.94           C
ATOM    430  CB  ASP    25     -22.726  40.350  -4.319  1.00 26.56           C
ATOM    433  CG  ASP    25     -23.578  39.107  -4.362  1.00 23.90           C
ATOM    434  OD1 ASP    25     -24.730  39.106  -3.846  1.00 26.48           O
ATOM    435  OD2 ASP    25     -23.072  38.101  -4.865  1.00 25.65           O
ATOM    436  C   ASP    25     -24.552  42.053  -3.944  1.00 28.65           C
ATOM    437  O   ASP    25     -24.284  42.520  -2.852  1.00 22.14           O
ATOM    439  N   LYS    26     -25.805  41.969  -4.394  1.00 30.84           N
ATOM    440  CA  LYS    26     -26.972  42.460  -3.624  1.00 30.71           C
ATOM    442  CB  LYS    26     -28.269  42.264  -4.436  1.00 33.89           C
ATOM    445  CG  LYS    26     -28.511  43.357  -5.458  1.00 44.49           C
ATOM    451  C   LYS    26     -27.110  41.822  -2.229  1.00 20.07           C
ATOM    452  O   LYS    26     -27.539  42.461  -1.284  1.00 26.43           O
ATOM    454  N   ARG    27     -26.680  40.589  -2.087  1.00 21.15           N
ATOM    455  CA  ARG    27     -26.707  39.913  -0.798  1.00 22.60           C
ATOM    457  CB  ARG    27     -26.242  38.480  -0.963  1.00 25.57           C
ATOM    460  CG  ARG    27     -27.146  37.636  -1.841  1.00 27.66           C
ATOM    463  CD  ARG    27     -26.556  36.286  -2.013  1.00 23.29           C
ATOM    466  NE  ARG    27     -25.338  36.340  -2.817  1.00 26.58           N
ATOM    468  CZ  ARG    27     -24.476  35.332  -2.941  1.00 23.01           C
ATOM    469  NH1 ARG    27     -24.685  34.189  -2.338  1.00 28.51           N
ATOM    472  NH2 ARG    27     -23.403  35.463  -3.696  1.00 28.09           N
ATOM    475  C   ARG    27     -25.817  40.557   0.265  1.00 24.98           C
ATOM    476  O   ARG    27     -26.053  40.397   1.473  1.00 25.35           O
ATOM    478  N   PHE    28     -24.801  41.282  -0.186  1.00 21.49           N
ATOM    479  CA  PHE    28     -23.726  41.741   0.688  1.00 23.72           C
ATOM    481  CB  PHE    28     -22.367  41.350   0.071  1.00 18.92           C
ATOM    484  CG  PHE    28     -22.222  39.873  -0.238  1.00 22.49           C
ATOM    485  CD1 PHE    28     -22.890  38.896   0.509  1.00 18.05           C
ATOM    487  CE1 PHE    28     -22.755  37.560   0.217  1.00 23.57           C
ATOM    489  CZ  PHE    28     -21.918  37.162  -0.818  1.00 19.66           C
ATOM    491  CE2 PHE    28     -21.237  38.120  -1.551  1.00 19.19           C
ATOM    493  CD2 PHE    28     -21.387  39.456  -1.252  1.00 20.61           C
ATOM    495  C   PHE    28     -23.809  43.225   0.963  1.00 20.64           C
ATOM    496  O   PHE    28     -22.922  43.802   1.621  1.00 21.40           O
ATOM    498  N   ARG    29     -24.903  43.860   0.528  1.00 25.62           N
ATOM    499  CA  ARG    29     -25.106  45.308   0.727  1.00 25.06           C
ATOM    501  CB  ARG    29     -26.492  45.749   0.199  1.00 28.09           C
ATOM    504  CG  ARG    29     -26.750  47.252   0.234  1.00 35.00           C
ATOM    507  CD  ARG    29     -28.236  47.617   0.028  1.00 56.20           C
ATOM    510  NE  ARG    29     -29.158  46.670   0.671  1.00 80.68           N
ATOM    512  CZ  ARG    29     -29.425  46.591   1.982  1.00 79.44           C
ATOM    513  NH1 ARG    29     -28.846  47.409   2.863  1.00 66.15           N
ATOM    516  NH2 ARG    29     -30.277  45.662   2.420  1.00 79.04           N
ATOM    519  C   ARG    29     -24.931  45.753   2.180  1.00 20.06           C
ATOM    520  O   ARG    29     -24.355  46.816   2.424  1.00 26.41           O
ATOM    522  N   VAL    30     -25.391  44.932   3.117  1.00 27.21           N
ATOM    523  CA  VAL    30     -25.289  45.215   4.553  1.00 33.63           C
ATOM    525  CB  VAL    30     -26.019  44.115   5.436  1.00 38.16           C
ATOM    527  CG1 VAL    30     -25.513  42.687   5.162  1.00 30.77           C
ATOM    531  CG2 VAL    30     -25.887  44.414   6.918  1.00 51.45           C
ATOM    535  C   VAL    30     -23.825  45.365   5.002  1.00 33.95           C
ATOM    536  O   VAL    30     -23.536  46.052   5.976  1.00 28.60           O
ATOM    538  N   PHE    31     -22.908  44.747   4.262  1.00 27.31           N
ATOM    539  CA  PHE    31     -21.483  44.731   4.632  1.00 23.37           C
ATOM    541  CB  PHE    31     -20.917  43.326   4.423  1.00 24.67           C
ATOM    544  CG  PHE    31     -21.743  42.236   5.027  1.00 23.53           C
ATOM    545  CD1 PHE    31     -21.987  42.193   6.401  1.00 24.92           C
ATOM    547  CE1 PHE    31     -22.759  41.189   6.950  1.00 34.33           C
ATOM    549  CZ  PHE    31     -23.268  40.181   6.142  1.00 26.48           C
ATOM    551  CE2 PHE    31     -23.027  40.198   4.778  1.00 23.80           C
ATOM    553  CD2 PHE    31     -22.274  41.225   4.222  1.00 23.54           C
ATOM    555  C   PHE    31     -20.667  45.756   3.856  1.00 25.64           C
ATOM    556  O   PHE    31     -19.440  45.777   3.960  1.00 24.17           O
ATOM    558  N   THR    32     -21.344  46.619   3.093  1.00 24.94           N
ATOM    559  CA  THR    32     -20.680  47.593   2.255  1.00 23.72           C
ATOM    561  CB  THR    32     -21.469  47.932   0.964  1.00 31.83           C
ATOM    563  OG1 THR    32     -22.742  48.526   1.288  1.00 32.27           O
ATOM    565  CG2 THR    32     -21.633  46.678   0.069  1.00 22.27           C
ATOM    569  C   THR    32     -20.378  48.901   3.005  1.00 29.48           C
ATOM    570  O   THR    32     -19.567  49.691   2.546  1.00 30.50           O
ATOM    572  N   LYS    33     -21.018  49.116   4.153  1.00 29.86           N
ATOM    573  CA  LYS    33     -20.827  50.362   4.910  1.00 35.76           C
ATOM    575  CB  LYS    33     -22.004  51.342   4.691  1.00 36.32           C
ATOM    578  CG  LYS    33     -22.005  52.062   3.342  1.00 51.13           C
ATOM    581  CD  LYS    33     -23.340  52.779   3.070  1.00 45.23           C
ATOM    586  C   LYS    33     -20.703  50.066   6.387  1.00 30.75           C
ATOM    587  O   LYS    33     -21.211  49.038   6.877  1.00 34.04           O
ATOM    589  N   PRO    34     -20.022  50.975   7.124  1.00 40.34           N
ATOM    590  CA  PRO    34     -20.024  50.887   8.573  1.00 43.78           C
ATOM    592  CB  PRO    34     -19.289  52.160   9.007  1.00 44.37           C
ATOM    595  CG  PRO    34     -18.458  52.547   7.868  1.00 40.69           C
ATOM    598  CD  PRO    34     -19.251  52.142   6.652  1.00 39.52           C
ATOM    601  C   PRO    34     -21.445  50.906   9.117  1.00 46.49           C
ATOM    602  O   PRO    34     -22.348  51.411   8.462  1.00 46.86           O
ATOM    603  N   VAL    35     -21.629  50.357  10.306  1.00 52.73           N
ATOM    604  CA  VAL    35     -22.905  50.435  11.002  1.00 56.02           C
ATOM    606  CB  VAL    35     -22.963  49.408  12.141  1.00 52.91           C
ATOM    608  CG1 VAL    35     -22.966  47.996  11.569  1.00 47.77           C
ATOM    612  CG2 VAL    35     -24.191  49.658  13.016  1.00 45.00           C
ATOM    616  C   VAL    35     -23.139  51.853  11.562  1.00 63.10           C
ATOM    617  O   VAL    35     -22.258  52.435  12.205  1.00 67.79           O
ATOM    619  N   ASP    36     -24.333  52.394  11.320  1.00 66.89           N
ATOM    620  CA  ASP    36     -24.676  53.763  11.725  1.00 68.61           C
ATOM    622  CB  ASP    36     -25.929  54.218  10.964  1.00 70.39           C
ATOM    625  CG  ASP    36     -26.175  55.714  11.064  1.00 77.61           C
ATOM    626  OD1 ASP    36     -25.201  56.485  11.219  1.00 70.69           O
ATOM    627  OD2 ASP    36     -27.355  56.117  10.971  1.00 90.64           O
ATOM    628  C   ASP    36     -24.898  53.861  13.254  1.00 67.11           C
ATOM    629  O   ASP    36     -25.795  53.199  13.800  1.00 56.69           O
ATOM    631  N   PRO    37     -24.081  54.685  13.951  1.00 70.78           N
ATOM    632  CA  PRO    37     -24.197  54.744  15.420  1.00 75.96           C
ATOM    634  CB  PRO    37     -23.059  55.691  15.834  1.00 75.72           C
ATOM    637  CG  PRO    37     -22.765  56.499  14.625  1.00 71.83           C
ATOM    640  CD  PRO    37     -23.059  55.621  13.443  1.00 67.24           C
ATOM    643  C   PRO    37     -25.552  55.273  15.901  1.00 80.35           C
ATOM    644  O   PRO    37     -25.932  55.035  17.050  1.00 83.21           O
ATOM    645  N   ASP    38     -26.266  55.976  15.023  1.00 83.08           N
ATOM    646  CA  ASP    38     -27.612  56.454  15.320  1.00 85.90           C
ATOM    648  CB  ASP    38     -28.032  57.549  14.332  1.00 86.22           C
ATOM    651  CG  ASP    38     -26.946  58.600  14.122  1.00 91.26           C
ATOM    652  OD1 ASP    38     -26.291  59.000  15.112  1.00 80.39           O
ATOM    653  OD2 ASP    38     -26.747  59.019  12.960  1.00 95.27           O
ATOM    654  C   ASP    38     -28.582  55.275  15.258  1.00 86.84           C
ATOM    655  O   ASP    38     -29.307  55.008  16.220  1.00 87.15           O
ATOM    657  N   GLU    39     -28.574  54.568  14.127  1.00 85.88           N
ATOM    658  CA  GLU    39     -29.421  53.389  13.941  1.00 84.58           C
ATOM    660  CB  GLU    39     -29.302  52.861  12.505  1.00 83.92           C
ATOM    667  C   GLU    39     -29.085  52.284  14.956  1.00 84.18           C
ATOM    668  O   GLU    39     -29.990  51.719  15.580  1.00 83.93           O
ATOM    670  N   VAL    40     -27.791  51.994  15.127  1.00 82.97           N
ATOM    671  CA  VAL    40     -27.326  50.952  16.059  1.00 79.76           C
ATOM    673  CB  VAL    40     -26.710  49.752  15.311  1.00 77.63           C
ATOM    675  CG1 VAL    40     -26.842  48.498  16.145  1.00 78.57           C
ATOM    679  CG2 VAL    40     -27.387  49.554  13.963  1.00 78.81           C
ATOM    683  C   VAL    40     -26.291  51.535  17.035  1.00 78.94           C
ATOM    684  O   VAL    40     -25.088  51.526  16.748  1.00 74.58           O
ATOM    686  N   PRO    41     -26.760  52.045  18.194  1.00 78.72           N
ATOM    687  CA  PRO    41     -25.885  52.767  19.130  1.00 75.46           C
ATOM    689  CB  PRO    41     -26.876  53.520  20.018  1.00 76.25           C
ATOM    692  CG  PRO    41     -28.089  52.638  20.045  1.00 80.48           C
ATOM    695  CD  PRO    41     -28.127  51.890  18.730  1.00 78.09           C
ATOM    698  C   PRO    41     -24.988  51.852  19.962  1.00 69.89           C
ATOM    699  O   PRO    41     -23.862  52.235  20.284  1.00 71.29           O
ATOM    700  N   ASP    42     -25.477  50.655  20.285  1.00 64.93           N
ATOM    701  CA  ASP    42     -24.691  49.667  21.019  1.00 63.01           C
ATOM    703  CB  ASP    42     -25.616  48.712  21.801  1.00 65.05           C
ATOM    706  CG  ASP    42     -26.381  47.740  20.897  1.00 71.38           C
ATOM    707  OD1 ASP    42     -26.382  46.515  21.186  1.00 60.91           O
ATOM    708  OD2 ASP    42     -26.976  48.203  19.898  1.00 69.09           O
ATOM    709  C   ASP    42     -23.718  48.855  20.136  1.00 59.52           C
ATOM    710  O   ASP    42     -23.081  47.928  20.638  1.00 59.30           O
ATOM    712  N   TYR    43     -23.594  49.186  18.846  1.00 56.70           N
ATOM    713  CA  TYR    43     -22.720  48.402  17.952  1.00 54.71           C
ATOM    715  CB  TYR    43     -22.915  48.743  16.459  1.00 55.68           C
ATOM    718  CG  TYR    43     -22.255  47.707  15.545  1.00 45.79           C
ATOM    719  CD1 TYR    43     -22.908  46.519  15.245  1.00 50.75           C
ATOM    721  CE1 TYR    43     -22.322  45.546  14.436  1.00 42.58           C
ATOM    723  CZ  TYR    43     -21.059  45.744  13.920  1.00 34.68           C
ATOM    724  OH  TYR    43     -20.527  44.734  13.135  1.00 39.12           O
ATOM    726  CE2 TYR    43     -20.356  46.913  14.209  1.00 37.57           C
ATOM    728  CD2 TYR    43     -20.960  47.892  15.032  1.00 43.68           C
ATOM    730  C   TYR    43     -21.254  48.600  18.320  1.00 54.18           C
ATOM    731  O   TYR    43     -20.523  47.623  18.531  1.00 48.20           O
ATOM    733  N   VAL    44     -20.847  49.871  18.391  1.00 52.45           N
ATOM    734  CA  VAL    44     -19.454  50.239  18.637  1.00 55.94           C
ATOM    736  CB  VAL    44     -19.192  51.763  18.333  1.00 58.13           C
ATOM    738  CG1 VAL    44     -18.220  52.399  19.327  1.00 58.75           C
ATOM    742  CG2 VAL    44     -18.684  51.920  16.908  1.00 47.76           C
ATOM    746  C   VAL    44     -18.945  49.796  20.025  1.00 50.89           C
ATOM    747  O   VAL    44     -17.731  49.688  20.217  1.00 47.72           O
ATOM    749  N   THR    45     -19.866  49.487  20.947  1.00 49.61           N
ATOM    750  CA  THR    45     -19.520  48.909  22.259  1.00 48.11           C
ATOM    752  CB  THR    45     -20.445  49.461  23.395  1.00 52.57           C
ATOM    754  OG1 THR    45     -21.668  48.713  23.469  1.00 60.63           O
ATOM    756  CG2 THR    45     -20.767  50.929  23.165  1.00 43.51           C
ATOM    760  C   THR    45     -19.511  47.359  22.271  1.00 46.13           C
ATOM    761  O   THR    45     -18.704  46.746  22.995  1.00 44.43           O
ATOM    763  N   VAL    46     -20.385  46.723  21.480  1.00 42.70           N
ATOM    764  CA  VAL    46     -20.404  45.243  21.371  1.00 40.23           C
ATOM    766  CB  VAL    46     -21.778  44.712  20.870  1.00 44.94           C
ATOM    768  CG1 VAL    46     -21.747  43.180  20.691  1.00 46.94           C
ATOM    772  CG2 VAL    46     -22.893  45.133  21.829  1.00 44.05           C
ATOM    776  C   VAL    46     -19.287  44.702  20.453  1.00 36.60           C
ATOM    777  O   VAL    46     -18.654  43.673  20.744  1.00 38.38           O
ATOM    779  N   ILE    47     -19.065  45.396  19.341  1.00 30.45           N
ATOM    780  CA  ILE    47     -18.111  44.965  18.328  1.00 32.39           C
ATOM    782  CB  ILE    47     -18.734  44.983  16.890  1.00 35.54           C
ATOM    784  CG1 ILE    47     -19.956  44.028  16.779  1.00 27.28           C
ATOM    787  CD1 ILE    47     -19.707  42.525  17.097  1.00 23.48           C
ATOM    791  CG2 ILE    47     -17.682  44.619  15.842  1.00 25.81           C
ATOM    795  C   ILE    47     -16.864  45.865  18.401  1.00 33.66           C
ATOM    796  O   ILE    47     -16.883  47.050  18.031  1.00 36.10           O
ATOM    798  N   LYS    48     -15.798  45.270  18.901  1.00 33.32           N
ATOM    799  CA  LYS    48     -14.550  45.963  19.207  1.00 31.72           C
ATOM    801  CB  LYS    48     -13.689  45.068  20.118  1.00 31.65           C
ATOM    804  CG  LYS    48     -14.387  44.729  21.453  1.00 39.44           C
ATOM    807  CD  LYS    48     -14.892  46.002  22.158  1.00 43.13           C
ATOM    810  CE  LYS    48     -15.676  45.714  23.404  1.00 47.78           C
ATOM    813  NZ  LYS    48     -16.182  47.011  23.956  1.00 44.33           N
ATOM    817  C   LYS    48     -13.751  46.353  17.977  1.00 33.20           C
ATOM    818  O   LYS    48     -13.014  47.339  18.022  1.00 27.97           O
ATOM    820  N   GLN    49     -13.914  45.583  16.895  1.00 30.48           N
ATOM    821  CA  GLN    49     -13.217  45.843  15.662  1.00 32.30           C
ATOM    823  CB  GLN    49     -12.049  44.864  15.505  1.00 29.28           C
ATOM    826  CG  GLN    49     -11.013  45.463  14.632  1.00 39.19           C
ATOM    829  CD  GLN    49      -9.769  44.633  14.478  1.00 36.19           C
ATOM    830  OE1 GLN    49      -8.860  45.072  13.783  1.00 40.56           O
ATOM    831  NE2 GLN    49      -9.711  43.427  15.107  1.00 33.13           N
ATOM    834  C   GLN    49     -14.181  45.755  14.477  1.00 28.07           C
ATOM    835  O   GLN    49     -14.234  44.724  13.793  1.00 28.15           O
ATOM    837  N   PRO    50     -14.949  46.835  14.245  1.00 29.22           N
ATOM    838  CA  PRO    50     -15.875  46.936  13.125  1.00 27.66           C
ATOM    840  CB  PRO    50     -16.369  48.378  13.211  1.00 30.49           C
ATOM    843  CG  PRO    50     -16.195  48.758  14.591  1.00 36.52           C
ATOM    846  CD  PRO    50     -15.042  48.013  15.122  1.00 26.98           C
ATOM    849  C   PRO    50     -15.126  46.763  11.815  1.00 31.26           C
ATOM    850  O   PRO    50     -14.027  47.278  11.679  1.00 23.71           O
ATOM    851  N   MET    51     -15.696  46.044  10.861  1.00 21.15           N
ATOM    852  CA  MET    51     -15.055  45.935   9.533  1.00 22.60           C
ATOM    854  CB  MET    51     -14.158  44.700   9.485  1.00 21.22           C
ATOM    857  CG  MET    51     -13.218  44.584   8.232  1.00 20.96           C
ATOM    860  SD  MET    51     -12.243  46.051   7.847  1.00 26.36           S
ATOM    861  CE  MET    51     -11.246  46.176   9.359  1.00 22.19           C
ATOM    865  C   MET    51     -16.166  45.867   8.493  1.00 23.15           C
ATOM    866  O   MET    51     -17.221  45.344   8.772  1.00 23.61           O
ATOM    868  N   ASP    52     -15.924  46.436   7.328  1.00 24.76           N
ATOM    869  CA  ASP    52     -16.879  46.392   6.231  1.00 27.19           C
ATOM    871  CB  ASP    52     -17.922  47.511   6.360  1.00 26.13           C
ATOM    874  CG  ASP    52     -17.330  48.890   6.169  1.00 29.38           C
ATOM    875  OD1 ASP    52     -16.775  49.471   7.125  1.00 45.75           O
ATOM    876  OD2 ASP    52     -17.407  49.400   5.059  1.00 31.49           O
ATOM    877  C   ASP    52     -16.084  46.513   4.949  1.00 24.29           C
ATOM    878  O   ASP    52     -14.881  46.799   4.992  1.00 20.17           O
ATOM    880  N   LEU    53     -16.745  46.316   3.812  1.00 19.93           N
ATOM    881  CA  LEU    53     -16.042  46.295   2.513  1.00 22.93           C
ATOM    883  CB  LEU    53     -16.947  45.717   1.416  1.00 23.99           C
ATOM    886  CG  LEU    53     -17.426  44.279   1.629  1.00 25.34           C
ATOM    888  CD1 LEU    53     -18.492  43.886   0.568  1.00 17.36           C
ATOM    892  CD2 LEU    53     -16.274  43.274   1.667  1.00 17.56           C
ATOM    896  C   LEU    53     -15.496  47.665   2.091  1.00 25.54           C
ATOM    897  O   LEU    53     -14.483  47.745   1.360  1.00 19.91           O
ATOM    899  N   SER    54     -16.118  48.753   2.553  1.00 28.29           N
ATOM    900  CA  SER    54     -15.543  50.087   2.272  1.00 25.79           C
ATOM    902  CB  SER    54     -16.504  51.211   2.684  0.50 23.77           C
ATOM    908  OG  SER    54     -16.659  51.265   4.097  0.50 28.65           O
ATOM    912  C   SER    54     -14.227  50.281   3.014  1.00 20.81           C
ATOM    913  O   SER    54     -13.287  50.890   2.484  1.00 25.29           O
ATOM    915  N   SER    55     -14.176  49.791   4.241  1.00 23.85           N
ATOM    916  CA  SER    55     -12.940  49.887   5.038  1.00 28.64           C
ATOM    918  CB  SER    55     -13.218  49.548   6.498  1.00 26.98           C
ATOM    921  OG  SER    55     -14.248  50.389   7.006  1.00 35.24           O
ATOM    923  C   SER    55     -11.851  48.986   4.446  1.00 24.61           C
ATOM    924  O   SER    55     -10.673  49.347   4.432  1.00 22.37           O
ATOM    926  N   VAL    56     -12.257  47.833   3.912  1.00 22.80           N
ATOM    927  CA  VAL    56     -11.319  46.945   3.189  1.00 18.59           C
ATOM    929  CB  VAL    56     -11.984  45.581   2.798  1.00 17.04           C
ATOM    931  CG1 VAL    56     -11.131  44.796   1.802  1.00 18.98           C
ATOM    935  CG2 VAL    56     -12.279  44.718   4.064  1.00 19.48           C
ATOM    939  C   VAL    56     -10.697  47.650   1.997  1.00 17.03           C
ATOM    940  O   VAL    56      -9.478  47.572   1.825  1.00 19.42           O
ATOM    942  N   ILE    57     -11.496  48.352   1.177  1.00 17.41           N
ATOM    943  CA  ILE    57     -10.955  49.092   0.032  1.00 20.50           C
ATOM    945  CB  ILE    57     -12.062  49.736  -0.876  1.00 23.10           C
ATOM    947  CG1 ILE    57     -12.835  48.672  -1.676  1.00 22.23           C
ATOM    950  CD1 ILE    57     -12.019  48.001  -2.756  1.00 28.19           C
ATOM    954  CG2 ILE    57     -11.454  50.774  -1.819  1.00 25.28           C
ATOM    958  C   ILE    57      -9.960  50.162   0.503  1.00 19.54           C
ATOM    959  O   ILE    57      -8.878  50.288  -0.056  1.00 17.87           O
ATOM    961  N   SER    58     -10.317  50.912   1.539  1.00 23.61           N
ATOM    962  CA  SER    58      -9.392  51.897   2.129  1.00 21.37           C
ATOM    964  CB  SER    58     -10.054  52.624   3.304  1.00 26.17           C
ATOM    967  OG  SER    58     -11.054  53.483   2.846  1.00 29.50           O
ATOM    969  C   SER    58      -8.045  51.272   2.584  1.00 18.72           C
ATOM    970  O   SER    58      -6.973  51.822   2.297  1.00 21.54           O
ATOM    972  N   LYS    59      -8.108  50.123   3.249  1.00 20.54           N
ATOM    973  CA  LYS    59      -6.924  49.433   3.712  1.00 16.63           C
ATOM    975  CB  LYS    59      -7.293  48.329   4.700  1.00 17.74           C
ATOM    978  CG  LYS    59      -7.723  48.901   6.077  1.00 21.37           C
ATOM    981  CD  LYS    59      -8.114  47.798   7.067  1.00 19.34           C
ATOM    984  CE  LYS    59      -6.893  47.119   7.670  1.00 20.09           C
ATOM    987  NZ  LYS    59      -7.200  46.047   8.619  1.00 19.43           N
ATOM    991  C   LYS    59      -6.034  48.918   2.559  1.00 15.54           C
ATOM    992  O   LYS    59      -4.816  48.973   2.659  1.00 16.76           O
ATOM    994  N   ILE    60      -6.643  48.453   1.467  1.00 17.14           N
ATOM    995  CA  ILE    60      -5.871  48.056   0.280  1.00 17.12           C
ATOM    997  CB  ILE    60      -6.783  47.630  -0.911  1.00 18.90           C
ATOM    999  CG1 ILE    60      -7.619  46.371  -0.546  1.00 20.67           C
ATOM   1002  CD1 ILE    60      -8.756  46.014  -1.549  1.00 16.51           C
ATOM   1006  CG2 ILE    60      -5.914  47.410  -2.191  1.00 15.27           C
ATOM   1010  C   ILE    60      -4.983  49.238  -0.173  1.00 16.88           C
ATOM   1011  O   ILE    60      -3.762  49.112  -0.345  1.00 18.43           O
ATOM   1013  N   ASP    61      -5.640  50.373  -0.349  1.00 18.18           N
ATOM   1014  CA  ASP    61      -5.022  51.581  -0.838  1.00 21.27           C
ATOM   1016  CB  ASP    61      -6.111  52.614  -1.131  1.00 20.70           C
ATOM   1019  CG  ASP    61      -6.998  52.220  -2.305  1.00 32.84           C
ATOM   1020  OD1 ASP    61      -6.667  51.259  -3.026  1.00 27.00           O
ATOM   1021  OD2 ASP    61      -8.033  52.884  -2.509  1.00 25.46           O
ATOM   1022  C   ASP    61      -3.976  52.136   0.138  1.00 24.20           C
ATOM   1023  O   ASP    61      -2.950  52.691  -0.290  1.00 21.34           O
ATOM   1025  N   LEU    62      -4.190  51.924   1.436  1.00 22.90           N
ATOM   1026  CA  LEU    62      -3.176  52.248   2.457  1.00 23.80           C
ATOM   1028  CB  LEU    62      -3.850  52.442   3.827  1.00 18.19           C
ATOM   1031  CG  LEU    62      -4.757  53.639   4.064  1.00 23.24           C
ATOM   1033  CD1 LEU    62      -5.442  53.427   5.439  1.00 20.00           C
ATOM   1037  CD2 LEU    62      -3.927  54.941   4.004  1.00 20.71           C
ATOM   1041  C   LEU    62      -2.071  51.194   2.585  1.00 24.78           C
ATOM   1042  O   LEU    62      -1.231  51.288   3.456  1.00 23.89           O
ATOM   1044  N   HIS    63      -2.050  50.185   1.712  1.00 21.03           N
ATOM   1045  CA  HIS    63      -1.018  49.156   1.698  1.00 18.83           C
ATOM   1047  CB  HIS    63       0.395  49.728   1.399  1.00 22.34           C
ATOM   1050  CG  HIS    63       0.488  50.497   0.129  1.00 22.10           C
ATOM   1051  ND1 HIS    63       1.698  50.841  -0.426  1.00 25.42           N
ATOM   1053  CE1 HIS    63       1.486  51.534  -1.530  1.00 20.87           C
ATOM   1055  NE2 HIS    63       0.184  51.589  -1.748  1.00 27.01           N
ATOM   1057  CD2 HIS    63      -0.462  50.954  -0.722  1.00 27.64           C
ATOM   1059  C   HIS    63      -0.971  48.336   2.982  1.00 21.67           C
ATOM   1060  O   HIS    63       0.070  47.885   3.388  1.00 22.07           O
ATOM   1062  N   LYS    64      -2.122  48.098   3.586  1.00 22.14           N
ATOM   1063  CA  LYS    64      -2.188  47.316   4.796  1.00 21.91           C
ATOM   1065  CB  LYS    64      -3.440  47.663   5.583  1.00 19.04           C
ATOM   1068  CG  LYS    64      -3.536  49.112   5.934  1.00 24.59           C
ATOM   1071  CD  LYS    64      -2.562  49.504   6.961  1.00 30.67           C
ATOM   1074  CE  LYS    64      -2.888  50.916   7.485  1.00 48.26           C
ATOM   1077  NZ  LYS    64      -2.018  51.276   8.627  1.00 47.20           N
ATOM   1081  C   LYS    64      -2.194  45.831   4.565  1.00 23.75           C
ATOM   1082  O   LYS    64      -1.981  45.077   5.507  1.00 18.75           O
ATOM   1084  N   TYR    65      -2.463  45.407   3.337  1.00 21.37           N
ATOM   1085  CA  TYR    65      -2.490  43.990   3.044  1.00 17.52           C
ATOM   1087  CB  TYR    65      -3.788  43.577   2.327  1.00 15.32           C
ATOM   1090  CG  TYR    65      -5.083  43.992   3.050  1.00 16.36           C
ATOM   1091  CD1 TYR    65      -5.359  43.565   4.331  1.00 19.84           C
ATOM   1093  CE1 TYR    65      -6.552  43.924   4.968  1.00 19.40           C
ATOM   1095  CZ  TYR    65      -7.501  44.701   4.296  1.00 15.48           C
ATOM   1096  OH  TYR    65      -8.679  45.058   4.902  1.00 18.10           O
ATOM   1098  CE2 TYR    65      -7.266  45.119   3.033  1.00 17.29           C
ATOM   1100  CD2 TYR    65      -6.057  44.751   2.395  1.00 16.43           C
ATOM   1102  C   TYR    65      -1.301  43.672   2.162  1.00 21.48           C
ATOM   1103  O   TYR    65      -1.258  44.066   1.007  1.00 22.79           O
ATOM   1105  N   LEU    66      -0.346  42.935   2.713  1.00 19.79           N
ATOM   1106  CA  LEU    66       0.847  42.523   1.958  1.00 23.12           C
ATOM   1108  CB  LEU    66       2.089  42.712   2.836  1.00 25.01           C
ATOM   1111  CG  LEU    66       2.439  44.137   3.294  1.00 32.61           C
ATOM   1113  CD1 LEU    66       3.862  44.119   3.908  1.00 37.41           C
ATOM   1117  CD2 LEU    66       2.368  45.115   2.195  1.00 30.09           C
ATOM   1121  C   LEU    66       0.743  41.062   1.481  1.00 22.04           C
ATOM   1122  O   LEU    66       1.557  40.601   0.688  1.00 21.03           O
ATOM   1124  N   THR    67      -0.256  40.344   1.990  1.00 20.44           N
ATOM   1125  CA  THR    67      -0.543  38.972   1.589  1.00 19.04           C
ATOM   1127  CB  THR    67       0.039  37.928   2.563  1.00 18.54           C
ATOM   1129  OG1 THR    67      -0.742  37.899   3.757  1.00 21.70           O
ATOM   1131  CG2 THR    67       1.506  38.214   2.937  1.00 20.92           C
ATOM   1135  C   THR    67      -2.077  38.771   1.534  1.00 20.22           C
ATOM   1136  O   THR    67      -2.848  39.552   2.115  1.00 18.31           O
ATOM   1138  N   VAL    68      -2.518  37.724   0.835  1.00 16.57           N
ATOM   1139  CA  VAL    68      -3.937  37.398   0.800  1.00 19.83           C
ATOM   1141  CB  VAL    68      -4.303  36.338  -0.283  1.00 19.37           C
ATOM   1143  CG1 VAL    68      -5.768  36.553  -0.786  1.00 24.52           C
ATOM   1147  CG2 VAL    68      -4.149  34.918   0.242  1.00 25.02           C
ATOM   1151  C   VAL    68      -4.424  36.961   2.180  1.00 22.55           C
ATOM   1152  O   VAL    68      -5.586  37.163   2.527  1.00 18.78           O
ATOM   1154  N   LYS    69      -3.550  36.353   2.984  1.00 22.17           N
ATOM   1155  CA  LYS    69      -3.917  36.039   4.372  1.00 26.13           C
ATOM   1157  CB  LYS    69      -2.773  35.296   5.084  1.00 33.70           C
ATOM   1160  CG  LYS    69      -2.648  33.854   4.646  1.00 34.43           C
ATOM   1163  CD  LYS    69      -1.703  33.079   5.573  1.00 45.50           C
ATOM   1168  C   LYS    69      -4.365  37.232   5.216  1.00 21.88           C
ATOM   1169  O   LYS    69      -5.357  37.131   5.952  1.00 23.88           O
ATOM   1171  N   ASP    70      -3.647  38.346   5.089  1.00 19.84           N
ATOM   1172  CA  ASP    70      -3.959  39.615   5.762  1.00 24.88           C
ATOM   1174  CB  ASP    70      -2.992  40.738   5.326  1.00 26.51           C
ATOM   1177  CG  ASP    70      -1.541  40.593   5.828  1.00 34.56           C
ATOM   1178  OD1 ASP    70      -1.244  39.787   6.721  1.00 27.92           O
ATOM   1179  OD2 ASP    70      -0.694  41.379   5.313  1.00 34.87           O
ATOM   1180  C   ASP    70      -5.381  40.087   5.352  1.00 27.16           C
ATOM   1181  O   ASP    70      -6.205  40.493   6.187  1.00 20.43           O
ATOM   1183  N   TYR    71      -5.625  40.070   4.045  1.00 23.04           N
ATOM   1184  CA  TYR    71      -6.940  40.435   3.471  1.00 17.48           C
ATOM   1186  CB  TYR    71      -6.849  40.328   1.955  1.00 19.62           C
ATOM   1189  CG  TYR    71      -8.147  40.516   1.226  1.00 15.66           C
ATOM   1190  CD1 TYR    71      -8.624  41.803   0.949  1.00 15.77           C
ATOM   1192  CE1 TYR    71      -9.795  41.991   0.265  1.00 17.42           C
ATOM   1194  CZ  TYR    71     -10.536  40.878  -0.163  1.00 18.81           C
ATOM   1195  OH  TYR    71     -11.681  41.085  -0.870  1.00 16.07           O
ATOM   1197  CE2 TYR    71     -10.079  39.593   0.061  1.00 15.40           C
ATOM   1199  CD2 TYR    71      -8.886  39.406   0.764  1.00 17.77           C
ATOM   1201  C   TYR    71      -8.074  39.536   3.979  1.00 17.40           C
ATOM   1202  O   TYR    71      -9.115  40.032   4.445  1.00 18.24           O
ATOM   1204  N   LEU    72      -7.871  38.226   3.892  1.00 18.72           N
ATOM   1205  CA  LEU    72      -8.874  37.252   4.349  1.00 21.15           C
ATOM   1207  CB  LEU    72      -8.512  35.826   3.932  1.00 16.77           C
ATOM   1210  CG  LEU    72      -8.718  35.566   2.443  1.00 25.64           C
ATOM   1212  CD1 LEU    72      -8.040  34.297   2.112  1.00 19.37           C
ATOM   1216  CD2 LEU    72     -10.215  35.535   2.012  1.00 25.53           C
ATOM   1220  C   LEU    72      -9.182  37.340   5.843  1.00 26.45           C
ATOM   1221  O   LEU    72     -10.302  37.066   6.250  1.00 23.04           O
ATOM   1223  N   ARG    73      -8.219  37.790   6.636  1.00 22.93           N
ATOM   1224  CA  ARG    73      -8.434  38.055   8.047  1.00 28.03           C
ATOM   1226  CB  ARG    73      -7.122  38.490   8.726  1.00 31.55           C
ATOM   1229  CG  ARG    73      -7.105  38.285  10.212  1.00 38.49           C
ATOM   1232  CD  ARG    73      -5.699  38.518  10.812  1.00 49.01           C
ATOM   1235  NE  ARG    73      -4.676  37.784  10.065  1.00 44.82           N
ATOM   1237  CZ  ARG    73      -3.669  38.325   9.374  1.00 55.88           C
ATOM   1238  NH1 ARG    73      -3.476  39.648   9.322  1.00 40.38           N
ATOM   1241  NH2 ARG    73      -2.831  37.518   8.726  1.00 56.97           N
ATOM   1244  C   ARG    73      -9.524  39.098   8.278  1.00 18.44           C
ATOM   1245  O   ARG    73     -10.365  38.890   9.124  1.00 19.51           O
ATOM   1247  N   ASP    74      -9.523  40.171   7.494  1.00 18.76           N
ATOM   1248  CA  ASP    74     -10.571  41.193   7.504  1.00 16.55           C
ATOM   1250  CB  ASP    74     -10.082  42.492   6.874  1.00 19.52           C
ATOM   1253  CG  ASP    74      -9.294  43.326   7.848  1.00 24.75           C
ATOM   1254  OD1 ASP    74      -9.271  42.928   9.020  1.00 20.14           O
ATOM   1255  OD2 ASP    74      -8.719  44.344   7.449  1.00 22.36           O
ATOM   1256  C   ASP    74     -11.916  40.769   6.894  1.00 21.92           C
ATOM   1257  O   ASP    74     -12.975  41.148   7.406  1.00 18.70           O
ATOM   1259  N   ILE    75     -11.886  39.980   5.830  1.00 21.18           N
ATOM   1260  CA  ILE    75     -13.126  39.305   5.348  1.00 20.67           C
ATOM   1262  CB  ILE    75     -12.861  38.455   4.056  1.00 24.95           C
ATOM   1264  CG1 ILE    75     -12.392  39.357   2.884  1.00 19.84           C
ATOM   1267  CD1 ILE    75     -13.271  40.588   2.564  1.00 17.92           C
ATOM   1271  CG2 ILE    75     -14.123  37.542   3.678  1.00 17.77           C
ATOM   1275  C   ILE    75     -13.756  38.436   6.459  1.00 20.07           C
ATOM   1276  O   ILE    75     -14.957  38.520   6.766  1.00 21.18           O
ATOM   1278  N   ASP    76     -12.930  37.612   7.072  1.00 17.12           N
ATOM   1279  CA  ASP    76     -13.336  36.803   8.192  1.00 18.83           C
ATOM   1281  CB  ASP    76     -12.186  35.905   8.657  1.00 22.83           C
ATOM   1284  CG  ASP    76     -12.043  34.652   7.827  1.00 27.23           C
ATOM   1285  OD1 ASP    76     -13.057  34.078   7.372  1.00 31.01           O
ATOM   1286  OD2 ASP    76     -10.909  34.191   7.693  1.00 27.95           O
ATOM   1287  C   ASP    76     -13.899  37.617   9.377  1.00 23.19           C
ATOM   1288  O   ASP    76     -14.831  37.168  10.037  1.00 22.31           O
ATOM   1290  N   LEU    77     -13.351  38.804   9.612  1.00 18.46           N
ATOM   1291  CA  LEU    77     -13.819  39.701  10.637  1.00 21.75           C
ATOM   1293  CB  LEU    77     -12.778  40.796  10.830  1.00 25.24           C
ATOM   1296  CG  LEU    77     -12.948  41.754  12.004  1.00 29.92           C
ATOM   1298  CD1 LEU    77     -13.038  40.979  13.351  1.00 25.12           C
ATOM   1302  CD2 LEU    77     -11.808  42.828  11.972  1.00 29.35           C
ATOM   1306  C   LEU    77     -15.234  40.301  10.317  1.00 28.76           C
ATOM   1307  O   LEU    77     -16.106  40.401  11.187  1.00 24.23           O
ATOM   1309  N   ILE    78     -15.463  40.677   9.065  1.00 25.00           N
ATOM   1310  CA  ILE    78     -16.801  41.067   8.619  1.00 24.14           C
ATOM   1312  CB  ILE    78     -16.846  41.357   7.106  1.00 22.57           C
ATOM   1314  CG1 ILE    78     -15.939  42.551   6.759  1.00 18.05           C
ATOM   1317  CD1 ILE    78     -15.865  42.959   5.251  1.00 17.41           C
ATOM   1321  CG2 ILE    78     -18.325  41.594   6.622  1.00 22.52           C
ATOM   1325  C   ILE    78     -17.788  39.956   8.967  1.00 21.73           C
ATOM   1326  O   ILE    78     -18.855  40.200   9.585  1.00 21.65           O
ATOM   1328  N   CYS    79     -17.439  38.728   8.613  1.00 20.07           N
ATOM   1329  CA  CYS    79     -18.311  37.600   8.882  1.00 23.10           C
ATOM   1331  CB  CYS    79     -17.826  36.354   8.142  1.00 20.26           C
ATOM   1334  SG  CYS    79     -18.872  34.951   8.328  1.00 27.18           S
ATOM   1336  C   CYS    79     -18.495  37.325  10.382  1.00 30.41           C
ATOM   1337  O   CYS    79     -19.635  37.266  10.875  1.00 22.37           O
ATOM   1339  N   SER    80     -17.393  37.181  11.121  1.00 21.91           N
ATOM   1340  CA  SER    80     -17.494  36.878  12.545  1.00 24.30           C
ATOM   1342  CB  SER    80     -16.095  36.547  13.140  1.00 24.35           C
ATOM   1345  OG  SER    80     -15.237  37.672  13.063  1.00 25.08           O
ATOM   1347  C   SER    80     -18.235  37.984  13.349  1.00 18.40           C
ATOM   1348  O   SER    80     -18.966  37.663  14.285  1.00 23.97           O
ATOM   1350  N   ASN    81     -18.040  39.257  13.002  1.00 20.76           N
ATOM   1351  CA  ASN    81     -18.731  40.384  13.628  1.00 23.40           C
ATOM   1353  CB  ASN    81     -18.272  41.726  13.033  1.00 18.65           C
ATOM   1356  CG  ASN    81     -16.891  42.213  13.553  1.00 23.49           C
ATOM   1357  OD1 ASN    81     -16.312  41.626  14.419  1.00 22.48           O
ATOM   1358  ND2 ASN    81     -16.394  43.279  12.976  1.00 20.38           N
ATOM   1361  C   ASN    81     -20.283  40.263  13.424  1.00 31.33           C
ATOM   1362  O   ASN    81     -21.087  40.528  14.334  1.00 26.82           O
ATOM   1364  N   ALA    82     -20.677  39.859  12.217  1.00 25.71           N
ATOM   1365  CA  ALA    82     -22.082  39.664  11.864  1.00 25.53           C
ATOM   1367  CB  ALA    82     -22.259  39.508  10.281  1.00 21.68           C
ATOM   1371  C   ALA    82     -22.675  38.493  12.648  1.00 19.47           C
ATOM   1372  O   ALA    82     -23.782  38.620  13.195  1.00 28.46           O
ATOM   1374  N   LEU    83     -21.945  37.393  12.806  1.00 22.22           N
ATOM   1375  CA  LEU    83     -22.458  36.275  13.567  1.00 23.51           C
ATOM   1377  CB  LEU    83     -21.630  34.996  13.381  1.00 25.32           C
ATOM   1380  CG  LEU    83     -21.284  34.549  11.947  1.00 34.57           C
ATOM   1382  CD1 LEU    83     -20.593  33.216  11.961  1.00 35.58           C
ATOM   1386  CD2 LEU    83     -22.467  34.549  11.013  1.00 26.17           C
ATOM   1390  C   LEU    83     -22.621  36.565  15.064  1.00 29.52           C
ATOM   1391  O   LEU    83     -23.595  36.103  15.672  1.00 26.06           O
ATOM   1393  N   GLU    84     -21.666  37.318  15.619  1.00 32.26           N
ATOM   1394  CA  GLU    84     -21.643  37.710  17.035  1.00 32.94           C
ATOM   1396  CB  GLU    84     -20.292  38.372  17.403  1.00 28.31           C
ATOM   1399  CG  GLU    84     -20.112  38.708  18.919  1.00 46.52           C
ATOM   1402  CD  GLU    84     -19.012  39.774  19.248  1.00 64.97           C
ATOM   1403  OE1 GLU    84     -19.027  40.289  20.394  1.00 62.98           O
ATOM   1404  OE2 GLU    84     -18.146  40.107  18.397  1.00 54.59           O
ATOM   1405  C   GLU    84     -22.775  38.669  17.351  1.00 24.93           C
ATOM   1406  O   GLU    84     -23.505  38.480  18.326  1.00 31.68           O
ATOM   1408  N   TYR    85     -22.917  39.687  16.517  1.00 25.04           N
ATOM   1409  CA  TYR    85     -23.859  40.737  16.750  1.00 31.73           C
ATOM   1411  CB  TYR    85     -23.552  41.964  15.894  1.00 27.37           C
ATOM   1414  CG  TYR    85     -24.285  43.193  16.424  1.00 43.81           C
ATOM   1415  CD1 TYR    85     -23.935  43.754  17.660  1.00 43.60           C
ATOM   1417  CE1 TYR    85     -24.609  44.867  18.169  1.00 51.06           C
ATOM   1419  CZ  TYR    85     -25.656  45.414  17.451  1.00 53.75           C
ATOM   1420  OH  TYR    85     -26.323  46.502  17.953  1.00 59.40           O
ATOM   1422  CE2 TYR    85     -26.032  44.869  16.232  1.00 45.06           C
ATOM   1424  CD2 TYR    85     -25.355  43.757  15.730  1.00 46.35           C
ATOM   1426  C   TYR    85     -25.312  40.326  16.468  1.00 32.29           C
ATOM   1427  O   TYR    85     -26.218  41.016  16.913  1.00 28.58           O
ATOM   1429  N   ASN    86     -25.511  39.244  15.713  1.00 32.89           N
ATOM   1430  CA  ASN    86     -26.859  38.825  15.262  1.00 31.75           C
ATOM   1432  CB  ASN    86     -27.062  39.151  13.773  1.00 32.32           C
ATOM   1435  CG  ASN    86     -26.831  40.612  13.440  1.00 31.15           C
ATOM   1436  OD1 ASN    86     -27.673  41.450  13.688  1.00 30.56           O
ATOM   1437  ND2 ASN    86     -25.687  40.919  12.835  1.00 33.47           N
ATOM   1440  C   ASN    86     -27.014  37.350  15.457  1.00 27.49           C
ATOM   1441  O   ASN    86     -27.161  36.616  14.483  1.00 31.91           O
ATOM   1443  N   PRO    87     -26.979  36.884  16.722  1.00 26.55           N
ATOM   1444  CA  PRO    87     -26.859  35.458  17.020  1.00 26.12           C
ATOM   1446  CB  PRO    87     -26.139  35.465  18.366  1.00 32.64           C
ATOM   1449  CG  PRO    87     -26.617  36.704  19.004  1.00 27.94           C
ATOM   1452  CD  PRO    87     -26.987  37.682  17.965  1.00 31.83           C
ATOM   1455  C   PRO    87     -28.190  34.720  17.191  1.00 23.77           C
ATOM   1456  O   PRO    87     -28.184  33.511  17.376  1.00 31.41           O
ATOM   1457  N   ASP    88     -29.295  35.454  17.077  1.00 29.51           N
ATOM   1458  CA  ASP    88     -30.628  34.995  17.492  1.00 30.57           C
ATOM   1460  CB  ASP    88     -31.499  36.214  17.808  1.00 33.78           C
ATOM   1463  CG  ASP    88     -31.018  36.990  19.037  1.00 44.32           C
ATOM   1464  OD1 ASP    88     -30.049  36.557  19.695  1.00 30.51           O
ATOM   1465  OD2 ASP    88     -31.618  38.042  19.343  1.00 45.37           O
ATOM   1466  C   ASP    88     -31.314  34.154  16.417  1.00 35.10           C
ATOM   1467  O   ASP    88     -30.874  34.159  15.254  1.00 27.40           O
ATOM   1469  N   ARG    89     -32.377  33.435  16.798  1.00 30.45           N
ATOM   1470  CA  ARG    89     -33.120  32.566  15.840  1.00 28.72           C
ATOM   1472  CB  ARG    89     -33.869  31.411  16.551  0.50 33.38           C
ATOM   1478  CG  ARG    89     -35.167  31.777  17.355  0.50 37.37           C
ATOM   1484  CD  ARG    89     -36.517  31.729  16.550  0.50 23.22           C
ATOM   1490  NE  ARG    89     -36.709  30.558  15.702  0.50 14.53           N
ATOM   1494  CZ  ARG    89     -37.431  30.582  14.566  0.50 21.38           C
ATOM   1496  NH1 ARG    89     -37.964  31.725  14.152  0.50 19.03           N
ATOM   1502  NH2 ARG    89     -37.589  29.485  13.816  0.50 13.40           N
ATOM   1508  C   ARG    89     -34.104  33.315  14.959  1.00 26.11           C
ATOM   1509  O   ARG    89     -34.687  32.742  14.036  1.00 29.81           O
ATOM   1511  N   ASP    90     -34.292  34.590  15.208  1.00 23.54           N
ATOM   1512  CA  ASP    90     -35.264  35.315  14.430  1.00 29.60           C
ATOM   1514  CB  ASP    90     -35.570  36.660  15.055  1.00 30.13           C
ATOM   1517  CG  ASP    90     -34.416  37.592  15.029  1.00 38.59           C
ATOM   1518  OD1 ASP    90     -34.440  38.541  14.205  1.00 51.79           O
ATOM   1519  OD2 ASP    90     -33.495  37.374  15.835  1.00 59.04           O
ATOM   1520  C   ASP    90     -34.818  35.489  12.968  1.00 31.35           C
ATOM   1521  O   ASP    90     -33.608  35.485  12.679  1.00 27.12           O
ATOM   1523  N   PRO    91     -35.796  35.658  12.057  1.00 30.02           N
ATOM   1524  CA  PRO    91     -35.509  35.719  10.624  1.00 27.31           C
ATOM   1526  CB  PRO    91     -36.888  35.982   9.996  1.00 31.62           C
ATOM   1529  CG  PRO    91     -37.870  35.529  10.995  1.00 30.59           C
ATOM   1532  CD  PRO    91     -37.249  35.720  12.332  1.00 29.64           C
ATOM   1535  C   PRO    91     -34.517  36.811  10.209  1.00 22.34           C
ATOM   1536  O   PRO    91     -33.705  36.580   9.308  1.00 20.72           O
ATOM   1537  N   GLY    92     -34.594  37.996  10.814  1.00 21.91           N
ATOM   1538  CA  GLY    92     -33.644  39.081  10.479  1.00 27.46           C
ATOM   1541  C   GLY    92     -32.189  38.688  10.774  1.00 28.37           C
ATOM   1542  O   GLY    92     -31.291  38.926   9.959  1.00 26.07           O
ATOM   1544  N   ASP    93     -31.988  38.036  11.921  1.00 29.00           N
ATOM   1545  CA  ASP    93     -30.671  37.565  12.363  1.00 28.59           C
ATOM   1547  CB  ASP    93     -30.706  37.160  13.839  1.00 27.55           C
ATOM   1550  CG  ASP    93     -30.501  38.352  14.797  1.00 29.39           C
ATOM   1551  OD1 ASP    93     -30.830  39.510  14.444  1.00 34.06           O
ATOM   1552  OD2 ASP    93     -29.975  38.111  15.906  1.00 30.80           O
ATOM   1553  C   ASP    93     -30.200  36.391  11.496  1.00 27.19           C
ATOM   1554  O   ASP    93     -29.054  36.350  11.035  1.00 22.18           O
ATOM   1556  N   ARG    94     -31.084  35.433  11.257  1.00 23.21           N
ATOM   1557  CA  ARG    94     -30.707  34.307  10.424  1.00 23.79           C
ATOM   1559  CB  ARG    94     -31.766  33.209  10.471  1.00 25.48           C
ATOM   1562  CG  ARG    94     -31.737  32.427  11.740  1.00 27.61           C
ATOM   1565  CD  ARG    94     -32.760  31.383  11.762  1.00 30.35           C
ATOM   1568  NE  ARG    94     -32.587  30.462  12.881  1.00 29.92           N
ATOM   1570  CZ  ARG    94     -33.515  29.601  13.303  1.00 44.64           C
ATOM   1571  NH1 ARG    94     -34.696  29.524  12.707  1.00 49.89           N
ATOM   1574  NH2 ARG    94     -33.253  28.800  14.329  1.00 50.28           N
ATOM   1577  C   ARG    94     -30.353  34.733   8.984  1.00 20.18           C
ATOM   1578  O   ARG    94     -29.450  34.143   8.402  1.00 24.67           O
ATOM   1580  N   LEU    95     -31.024  35.742   8.429  1.00 22.52           N
ATOM   1581  CA  LEU    95     -30.721  36.233   7.093  1.00 22.83           C
ATOM   1583  CB  LEU    95     -31.778  37.231   6.586  1.00 17.27           C
ATOM   1586  CG  LEU    95     -31.622  37.872   5.193  1.00 13.78           C
ATOM   1588  CD1 LEU    95     -31.591  36.803   4.083  1.00 17.27           C
ATOM   1592  CD2 LEU    95     -32.741  38.938   4.931  1.00 18.04           C
ATOM   1596  C   LEU    95     -29.303  36.857   7.025  1.00 27.03           C
ATOM   1597  O   LEU    95     -28.513  36.509   6.145  1.00 18.85           O
ATOM   1599  N   ILE    96     -29.003  37.775   7.935  1.00 24.56           N
ATOM   1600  CA  ILE    96     -27.664  38.412   7.975  1.00 25.27           C
ATOM   1602  CB  ILE    96     -27.557  39.557   9.048  1.00 24.78           C
ATOM   1604  CG1 ILE    96     -26.213  40.323   8.878  1.00 26.50           C
ATOM   1607  CD1 ILE    96     -26.245  41.771   9.362  1.00 33.12           C
ATOM   1611  CG2 ILE    96     -27.670  38.996  10.451  1.00 39.55           C
ATOM   1615  C   ILE    96     -26.548  37.377   8.152  1.00 19.60           C
ATOM   1616  O   ILE    96     -25.527  37.461   7.468  1.00 21.18           O
ATOM   1618  N   ARG    97     -26.758  36.383   9.014  1.00 22.09           N
ATOM   1619  CA  ARG    97     -25.730  35.337   9.236  1.00 23.22           C
ATOM   1621  CB  ARG    97     -26.055  34.442  10.418  1.00 23.31           C
ATOM   1624  CG  ARG    97     -26.059  35.147  11.791  1.00 18.24           C
ATOM   1627  CD  ARG    97     -25.825  34.149  12.895  1.00 24.44           C
ATOM   1630  NE  ARG    97     -26.714  32.993  12.966  1.00 28.83           N
ATOM   1632  CZ  ARG    97     -27.954  32.988  13.471  1.00 27.43           C
ATOM   1633  NH1 ARG    97     -28.502  34.084  13.952  1.00 30.54           N
ATOM   1636  NH2 ARG    97     -28.636  31.867  13.506  1.00 34.39           N
ATOM   1639  C   ARG    97     -25.531  34.480   8.000  1.00 23.61           C
ATOM   1640  O   ARG    97     -24.405  34.077   7.685  1.00 19.92           O
ATOM   1642  N   HIS    98     -26.632  34.171   7.313  1.00 21.18           N
ATOM   1643  CA  HIS    98     -26.543  33.431   6.046  1.00 22.64           C
ATOM   1645  CB  HIS    98     -27.941  33.050   5.530  1.00 21.77           C
ATOM   1648  CG  HIS    98     -27.908  32.137   4.350  1.00 26.85           C
ATOM   1649  ND1 HIS    98     -27.908  32.597   3.046  1.00 26.01           N
ATOM   1651  CE1 HIS    98     -27.851  31.562   2.226  1.00 24.25           C
ATOM   1653  NE2 HIS    98     -27.801  30.456   2.946  1.00 24.82           N
ATOM   1655  CD2 HIS    98     -27.832  30.790   4.278  1.00 20.83           C
ATOM   1657  C   HIS    98     -25.762  34.212   4.969  1.00 17.30           C
ATOM   1658  O   HIS    98     -24.933  33.631   4.248  1.00 18.06           O
ATOM   1660  N   ARG    99     -26.027  35.506   4.899  1.00 19.10           N
ATOM   1661  CA  ARG    99     -25.316  36.441   4.018  1.00 20.88           C
ATOM   1663  CB  ARG    99     -26.027  37.773   3.997  1.00 20.64           C
ATOM   1666  CG  ARG    99     -27.387  37.732   3.223  1.00 20.88           C
ATOM   1669  CD  ARG    99     -28.174  38.962   3.458  1.00 21.51           C
ATOM   1672  NE  ARG    99     -29.294  39.078   2.521  1.00 23.06           N
ATOM   1674  CZ  ARG    99     -30.191  40.058   2.555  1.00 20.30           C
ATOM   1675  NH1 ARG    99     -30.091  41.023   3.440  1.00 21.05           N
ATOM   1678  NH2 ARG    99     -31.181  40.093   1.678  1.00 21.17           N
ATOM   1681  C   ARG    99     -23.838  36.630   4.382  1.00 20.58           C
ATOM   1682  O   ARG    99     -22.988  36.706   3.488  1.00 17.96           O
ATOM   1684  N   ALA   100     -23.558  36.732   5.683  1.00 19.17           N
ATOM   1685  CA  ALA   100     -22.195  36.813   6.217  1.00 21.85           C
ATOM   1687  CB  ALA   100     -22.225  36.938   7.764  1.00 16.22           C
ATOM   1691  C   ALA   100     -21.351  35.615   5.791  1.00 20.05           C
ATOM   1692  O   ALA   100     -20.221  35.796   5.311  1.00 23.60           O
ATOM   1694  N   CYS   101     -21.907  34.415   5.973  1.00 21.28           N
ATOM   1695  CA  CYS   101     -21.276  33.158   5.610  1.00 21.52           C
ATOM   1697  CB  CYS   101     -22.079  31.960   6.126  1.00 28.07           C
ATOM   1700  SG  CYS   101     -21.972  31.797   7.936  1.00 31.25           S
ATOM   1702  C   CYS   101     -21.051  33.023   4.124  1.00 25.37           C
ATOM   1703  O   CYS   101     -19.999  32.501   3.714  1.00 19.19           O
ATOM   1705  N   ALA   102     -22.016  33.503   3.337  1.00 21.90           N
ATOM   1706  CA  ALA   102     -21.892  33.511   1.882  1.00 22.12           C
ATOM   1708  CB  ALA   102     -23.235  33.849   1.188  1.00 15.78           C
ATOM   1712  C   ALA   102     -20.790  34.486   1.442  1.00 20.27           C
ATOM   1713  O   ALA   102     -20.054  34.187   0.513  1.00 19.10           O
ATOM   1715  N   LEU   103     -20.716  35.655   2.073  1.00 16.83           N
ATOM   1716  CA  LEU   103     -19.665  36.644   1.771  1.00 18.39           C
ATOM   1718  CB  LEU   103     -19.805  37.899   2.654  1.00 23.15           C
ATOM   1721  CG  LEU   103     -18.663  38.922   2.545  1.00 30.05           C
ATOM   1723  CD1 LEU   103     -18.835  39.688   1.281  1.00 28.54           C
ATOM   1727  CD2 LEU   103     -18.626  39.860   3.741  1.00 37.11           C
ATOM   1731  C   LEU   103     -18.284  35.999   1.972  1.00 22.05           C
ATOM   1732  O   LEU   103     -17.399  36.073   1.096  1.00 16.43           O
ATOM   1734  N   ARG   104     -18.145  35.347   3.118  1.00 20.87           N
ATOM   1735  CA  ARG   104     -16.942  34.619   3.490  1.00 19.58           C
ATOM   1737  CB  ARG   104     -17.073  34.081   4.903  1.00 21.66           C
ATOM   1740  CG  ARG   104     -15.809  33.343   5.449  1.00 26.94           C
ATOM   1743  CD  ARG   104     -16.189  32.403   6.579  1.00 37.02           C
ATOM   1746  NE  ARG   104     -17.176  31.418   6.120  1.00 39.15           N
ATOM   1748  CZ  ARG   104     -18.107  30.830   6.873  1.00 47.77           C
ATOM   1749  NH1 ARG   104     -18.226  31.107   8.170  1.00 40.34           N
ATOM   1752  NH2 ARG   104     -18.941  29.960   6.318  1.00 32.08           N
ATOM   1755  C   ARG   104     -16.608  33.498   2.514  1.00 21.51           C
ATOM   1756  O   ARG   104     -15.502  33.451   1.985  1.00 19.81           O
ATOM   1758  N   ASP   105     -17.569  32.614   2.252  1.00 19.85           N
ATOM   1759  CA  ASP   105     -17.371  31.514   1.328  1.00 18.95           C
ATOM   1761  CB  ASP   105     -18.589  30.579   1.310  1.00 19.94           C
ATOM   1764  CG  ASP   105     -18.786  29.817   2.617  1.00 29.87           C
ATOM   1765  OD1 ASP   105     -17.890  29.804   3.497  1.00 25.79           O
ATOM   1766  OD2 ASP   105     -19.875  29.240   2.759  1.00 32.06           O
ATOM   1767  C   ASP   105     -17.071  31.980  -0.091  1.00 18.74           C
ATOM   1768  O   ASP   105     -16.165  31.416  -0.760  1.00 18.41           O
ATOM   1770  N   THR   106     -17.805  32.999  -0.550  1.00 16.32           N
ATOM   1771  CA  THR   106     -17.554  33.568  -1.857  1.00 17.31           C
ATOM   1773  CB  THR   106     -18.592  34.671  -2.215  1.00 19.60           C
ATOM   1775  OG1 THR   106     -19.910  34.091  -2.200  1.00 21.70           O
ATOM   1777  CG2 THR   106     -18.293  35.280  -3.582  1.00 21.15           C
ATOM   1781  C   THR   106     -16.110  34.103  -2.046  1.00 18.99           C
ATOM   1782  O   THR   106     -15.477  33.831  -3.076  1.00 17.74           O
ATOM   1784  N   ALA   107     -15.637  34.895  -1.094  1.00 15.61           N
ATOM   1785  CA  ALA   107     -14.289  35.420  -1.112  1.00 21.64           C
ATOM   1787  CB  ALA   107     -14.046  36.389   0.104  1.00 18.61           C
ATOM   1791  C   ALA   107     -13.247  34.298  -1.143  1.00 18.51           C
ATOM   1792  O   ALA   107     -12.335  34.325  -1.983  1.00 17.14           O
ATOM   1794  N   TYR   108     -13.401  33.301  -0.262  1.00 19.06           N
ATOM   1795  CA  TYR   108     -12.468  32.196  -0.209  1.00 20.55           C
ATOM   1797  CB  TYR   108     -12.759  31.244   0.955  1.00 19.96           C
ATOM   1800  CG  TYR   108     -12.056  31.638   2.231  1.00 25.99           C
ATOM   1801  CD1 TYR   108     -12.606  32.576   3.103  1.00 24.70           C
ATOM   1803  CE1 TYR   108     -11.952  32.927   4.290  1.00 20.39           C
ATOM   1805  CZ  TYR   108     -10.747  32.334   4.587  1.00 20.84           C
ATOM   1806  OH  TYR   108     -10.069  32.659   5.731  1.00 24.88           O
ATOM   1808  CE2 TYR   108     -10.178  31.414   3.723  1.00 24.61           C
ATOM   1810  CD2 TYR   108     -10.817  31.077   2.565  1.00 25.48           C
ATOM   1812  C   TYR   108     -12.408  31.452  -1.529  1.00 20.31           C
ATOM   1813  O   TYR   108     -11.310  31.099  -1.995  1.00 17.23           O
ATOM   1815  N   ALA   109     -13.574  31.289  -2.149  1.00 19.03           N
ATOM   1816  CA  ALA   109     -13.706  30.564  -3.412  1.00 23.11           C
ATOM   1818  CB  ALA   109     -15.176  30.300  -3.685  1.00 18.89           C
ATOM   1822  C   ALA   109     -13.061  31.284  -4.604  1.00 20.50           C
ATOM   1823  O   ALA   109     -12.427  30.638  -5.470  1.00 18.55           O
ATOM   1825  N   ILE   110     -13.267  32.605  -4.688  1.00 19.36           N
ATOM   1826  CA  ILE   110     -12.599  33.421  -5.725  1.00 21.96           C
ATOM   1828  CB  ILE   110     -13.063  34.925  -5.709  1.00 18.58           C
ATOM   1830  CG1 ILE   110     -14.535  35.027  -6.122  1.00 22.18           C
ATOM   1833  CD1 ILE   110     -15.215  36.373  -5.838  1.00 14.78           C
ATOM   1837  CG2 ILE   110     -12.170  35.812  -6.630  1.00 14.29           C
ATOM   1841  C   ILE   110     -11.071  33.311  -5.607  1.00 19.10           C
ATOM   1842  O   ILE   110     -10.372  33.040  -6.591  1.00 17.26           O
ATOM   1844  N   ILE   111     -10.561  33.544  -4.408  1.00 19.19           N
ATOM   1845  CA  ILE   111      -9.131  33.411  -4.116  1.00 25.44           C
ATOM   1847  CB  ILE   111      -8.800  33.800  -2.614  1.00 22.02           C
ATOM   1849  CG1 ILE   111      -8.927  35.319  -2.466  0.50 24.12           C
ATOM   1855  CD1 ILE   111      -8.975  35.821  -1.034  0.50 24.28           C
ATOM   1863  CG2 ILE   111      -7.377  33.351  -2.186  0.50 20.27           C
ATOM   1871  C   ILE   111      -8.594  32.012  -4.480  1.00 23.43           C
ATOM   1872  O   ILE   111      -7.521  31.889  -5.076  1.00 21.51           O
ATOM   1874  N   LYS   112      -9.331  30.970  -4.113  1.00 20.95           N
ATOM   1875  CA  LYS   112      -8.891  29.605  -4.401  1.00 25.13           C
ATOM   1877  CB  LYS   112      -9.815  28.569  -3.758  1.00 24.23           C
ATOM   1880  CG  LYS   112      -9.267  27.139  -3.851  1.00 34.87           C
ATOM   1883  CD  LYS   112     -10.337  26.124  -3.532  1.00 39.00           C
ATOM   1886  CE  LYS   112      -9.719  24.728  -3.388  1.00 41.73           C
ATOM   1889  NZ  LYS   112     -10.780  23.712  -3.284  1.00 50.37           N
ATOM   1893  C   LYS   112      -8.788  29.353  -5.898  1.00 22.73           C
ATOM   1894  O   LYS   112      -7.847  28.719  -6.353  1.00 23.80           O
ATOM   1896  N   GLU   113      -9.746  29.853  -6.661  1.00 20.61           N
ATOM   1897  CA  GLU   113      -9.742  29.692  -8.104  1.00 21.10           C
ATOM   1899  CB  GLU   113     -11.151  29.903  -8.655  1.00 24.85           C
ATOM   1902  CG  GLU   113     -11.376  29.291 -10.028  1.00 42.67           C
ATOM   1905  CD  GLU   113     -12.830  28.871 -10.218  1.00 63.40           C
ATOM   1906  OE1 GLU   113     -13.664  29.740 -10.555  1.00 53.37           O
ATOM   1907  OE2 GLU   113     -13.141  27.678 -10.014  1.00 73.30           O
ATOM   1908  C   GLU   113      -8.761  30.627  -8.834  1.00 22.80           C
ATOM   1909  O   GLU   113      -8.143  30.225  -9.814  1.00 22.99           O
ATOM   1911  N   GLU   114      -8.624  31.869  -8.371  1.00 18.16           N
ATOM   1912  CA  GLU   114      -7.987  32.916  -9.174  1.00 20.66           C
ATOM   1914  CB  GLU   114      -8.942  34.104  -9.351  1.00 17.76           C
ATOM   1917  CG  GLU   114     -10.303  33.700 -10.004  1.00 20.51           C
ATOM   1920  CD  GLU   114     -11.257  34.857 -10.154  1.00 22.62           C
ATOM   1921  OE1 GLU   114     -10.785  36.015 -10.211  1.00 23.24           O
ATOM   1922  OE2 GLU   114     -12.497  34.622 -10.190  1.00 20.23           O
ATOM   1923  C   GLU   114      -6.638  33.436  -8.660  1.00 17.59           C
ATOM   1924  O   GLU   114      -5.978  34.135  -9.388  1.00 22.00           O
ATOM   1926  N   LEU   115      -6.264  33.152  -7.424  1.00 17.35           N
ATOM   1927  CA  LEU   115      -4.969  33.587  -6.918  1.00 22.63           C
ATOM   1929  CB  LEU   115      -5.031  34.089  -5.488  1.00 25.32           C
ATOM   1932  CG  LEU   115      -3.736  34.808  -5.019  1.00 27.81           C
ATOM   1934  CD1 LEU   115      -3.541  36.132  -5.784  1.00 29.99           C
ATOM   1938  CD2 LEU   115      -3.802  35.013  -3.544  1.00 34.72           C
ATOM   1942  C   LEU   115      -3.995  32.413  -7.027  1.00 22.59           C
ATOM   1943  O   LEU   115      -4.200  31.351  -6.437  1.00 25.27           O
ATOM   1945  N   ASP   116      -2.956  32.608  -7.823  1.00 26.87           N
ATOM   1946  CA  ASP   116      -1.931  31.598  -8.001  1.00 21.26           C
ATOM   1948  CB  ASP   116      -0.940  32.039  -9.085  1.00 24.60           C
ATOM   1951  CG  ASP   116      -0.014  30.945  -9.463  1.00 32.72           C
ATOM   1952  OD1 ASP   116       0.802  30.520  -8.621  1.00 35.85           O
ATOM   1953  OD2 ASP   116      -0.116  30.482 -10.603  1.00 30.51           O
ATOM   1954  C   ASP   116      -1.217  31.405  -6.686  1.00 19.88           C
ATOM   1955  O   ASP   116      -0.797  32.367  -6.070  1.00 17.18           O
ATOM   1957  N   GLU   117      -1.072  30.153  -6.273  1.00 19.70           N
ATOM   1958  CA  GLU   117      -0.423  29.793  -5.015  1.00 21.71           C
ATOM   1960  CB  GLU   117      -0.505  28.281  -4.806  1.00 24.97           C
ATOM   1963  CG  GLU   117      -1.873  27.805  -4.351  1.00 47.68           C
ATOM   1966  CD  GLU   117      -1.993  26.281  -4.377  1.00 62.52           C
ATOM   1967  OE1 GLU   117      -1.051  25.592  -3.917  1.00 68.27           O
ATOM   1968  OE2 GLU   117      -3.025  25.781  -4.872  1.00 64.53           O
ATOM   1969  C   GLU   117       1.034  30.252  -4.904  1.00 19.02           C
ATOM   1970  O   GLU   117       1.505  30.575  -3.804  1.00 21.23           O
ATOM   1972  N   ASP   118       1.726  30.300  -6.037  1.00 21.76           N
ATOM   1973  CA  ASP   118       3.114  30.755  -6.084  1.00 23.35           C
ATOM   1975  CB  ASP   118       3.807  30.259  -7.362  1.00 23.22           C
ATOM   1978  CG  ASP   118       4.031  28.759  -7.344  1.00 23.95           C
ATOM   1979  OD1 ASP   118       4.153  28.174  -6.239  1.00 27.42           O
ATOM   1980  OD2 ASP   118       4.053  28.181  -8.419  1.00 34.51           O
ATOM   1981  C   ASP   118       3.216  32.252  -5.989  1.00 19.61           C
ATOM   1982  O   ASP   118       4.183  32.772  -5.444  1.00 21.35           O
ATOM   1984  N   PHE   119       2.205  32.953  -6.489  1.00 20.03           N
ATOM   1985  CA  PHE   119       2.117  34.407  -6.319  1.00 18.31           C
ATOM   1987  CB  PHE   119       0.999  35.022  -7.194  1.00 21.75           C
ATOM   1990  CG  PHE   119       0.877  36.501  -7.019  1.00 18.23           C
ATOM   1991  CD1 PHE   119       1.697  37.368  -7.744  1.00 20.63           C
ATOM   1993  CE1 PHE   119       1.645  38.724  -7.536  1.00 20.18           C
ATOM   1995  CZ  PHE   119       0.778  39.242  -6.595  1.00 20.66           C
ATOM   1997  CE2 PHE   119      -0.028  38.399  -5.840  1.00 21.25           C
ATOM   1999  CD2 PHE   119       0.034  37.039  -6.034  1.00 23.39           C
ATOM   2001  C   PHE   119       1.943  34.760  -4.820  1.00 20.04           C
ATOM   2002  O   PHE   119       2.636  35.652  -4.300  1.00 19.24           O
ATOM   2004  N   GLU   120       1.019  34.061  -4.149  1.00 19.65           N
ATOM   2005  CA  GLU   120       0.771  34.243  -2.721  1.00 20.07           C
ATOM   2007  CB  GLU   120      -0.452  33.418  -2.270  1.00 19.67           C
ATOM   2010  CG  GLU   120      -0.776  33.431  -0.751  1.00 18.22           C
ATOM   2013  CD  GLU   120      -0.842  34.838  -0.076  1.00 24.26           C
ATOM   2014  OE1 GLU   120      -0.993  35.867  -0.749  1.00 22.01           O
ATOM   2015  OE2 GLU   120      -0.748  34.920   1.166  1.00 31.38           O
ATOM   2016  C   GLU   120       2.011  33.896  -1.906  1.00 20.48           C
ATOM   2017  O   GLU   120       2.382  34.653  -1.004  1.00 18.84           O
ATOM   2019  N   GLN   121       2.694  32.812  -2.281  1.00 23.00           N
ATOM   2020  CA  GLN   121       3.915  32.389  -1.584  1.00 25.45           C
ATOM   2022  CB  GLN   121       4.429  31.033  -2.118  1.00 27.28           C
ATOM   2025  CG  GLN   121       5.608  30.447  -1.317  1.00 21.66           C
ATOM   2028  CD  GLN   121       5.278  30.213   0.151  1.00 33.37           C
ATOM   2029  OE1 GLN   121       4.152  29.870   0.483  1.00 32.16           O
ATOM   2030  NE2 GLN   121       6.259  30.418   1.037  1.00 26.32           N
ATOM   2033  C   GLN   121       5.004  33.462  -1.667  1.00 23.94           C
ATOM   2034  O   GLN   121       5.652  33.769  -0.654  1.00 23.54           O
ATOM   2036  N   LEU   122       5.194  34.028  -2.859  1.00 20.47           N
ATOM   2037  CA  LEU   122       6.070  35.185  -3.031  1.00 18.08           C
ATOM   2039  CB  LEU   122       6.086  35.684  -4.483  1.00 19.06           C
ATOM   2042  CG  LEU   122       7.034  36.853  -4.806  1.00 21.41           C
ATOM   2044  CD1 LEU   122       8.500  36.550  -4.318  1.00 21.01           C
ATOM   2048  CD2 LEU   122       6.981  37.263  -6.284  1.00 19.35           C
ATOM   2052  C   LEU   122       5.717  36.346  -2.102  1.00 25.99           C
ATOM   2053  O   LEU   122       6.595  36.878  -1.426  1.00 22.53           O
ATOM   2055  N   CYS   123       4.442  36.746  -2.073  1.00 24.30           N
ATOM   2056  CA  CYS   123       3.986  37.824  -1.193  1.00 22.03           C
ATOM   2058  CB  CYS   123       2.462  38.013  -1.273  1.00 19.81           C
ATOM   2061  SG  CYS   123       1.949  38.719  -2.788  1.00 20.51           S
ATOM   2063  C   CYS   123       4.406  37.543   0.250  1.00 19.76           C
ATOM   2064  O   CYS   123       4.923  38.429   0.925  1.00 23.30           O
ATOM   2066  N   GLU   124       4.219  36.302   0.677  1.00 21.51           N
ATOM   2067  CA  GLU   124       4.498  35.894   2.033  1.00 23.50           C
ATOM   2069  CB  GLU   124       3.904  34.522   2.316  1.00 25.91           C
ATOM   2072  CG  GLU   124       2.354  34.523   2.426  1.00 34.93           C
ATOM   2075  CD  GLU   124       1.753  33.122   2.570  1.00 39.26           C
ATOM   2076  OE1 GLU   124       2.507  32.196   2.922  1.00 44.00           O
ATOM   2077  OE2 GLU   124       0.531  32.934   2.324  1.00 32.86           O
ATOM   2078  C   GLU   124       6.000  35.937   2.305  1.00 27.58           C
ATOM   2079  O   GLU   124       6.425  36.363   3.373  1.00 23.27           O
ATOM   2081  N   GLU   125       6.808  35.559   1.319  1.00 28.86           N
ATOM   2082  CA  GLU   125       8.266  35.568   1.498  1.00 28.47           C
ATOM   2084  CB  GLU   125       8.964  34.623   0.483  1.00 24.02           C
ATOM   2087  CG  GLU   125       8.640  33.169   0.845  1.00 24.03           C
ATOM   2090  CD  GLU   125       9.254  32.079  -0.028  1.00 24.11           C
ATOM   2091  OE1 GLU   125      10.097  32.389  -0.885  1.00 26.14           O
ATOM   2092  OE2 GLU   125       8.870  30.893   0.175  1.00 25.13           O
ATOM   2093  C   GLU   125       8.844  36.986   1.557  1.00 25.14           C
ATOM   2094  O   GLU   125       9.702  37.240   2.379  1.00 32.10           O
ATOM   2096  N   ILE   126       8.343  37.910   0.744  1.00 18.67           N
ATOM   2097  CA  ILE   126       8.744  39.303   0.794  1.00 28.52           C
ATOM   2099  CB  ILE   126       8.101  40.129  -0.336  1.00 27.83           C
ATOM   2101  CG1 ILE   126       8.493  39.568  -1.715  1.00 26.91           C
ATOM   2104  CD1 ILE   126       7.773  40.251  -2.894  1.00 26.67           C
ATOM   2108  CG2 ILE   126       8.485  41.616  -0.217  1.00 22.12           C
ATOM   2112  C   ILE   126       8.337  39.875   2.154  1.00 36.40           C
ATOM   2113  O   ILE   126       9.156  40.463   2.873  1.00 35.06           O
ATOM   2115  N   GLN   127       7.079  39.649   2.529  1.00 35.08           N
ATOM   2116  CA  GLN   127       6.566  40.142   3.807  1.00 38.66           C
ATOM   2118  CB  GLN   127       5.108  39.735   3.995  1.00 38.13           C
ATOM   2121  CG  GLN   127       4.372  40.616   4.976  1.00 46.73           C
ATOM   2124  CD  GLN   127       3.704  39.812   6.038  1.00 64.51           C
ATOM   2125  OE1 GLN   127       4.390  39.181   6.848  1.00 56.16           O
ATOM   2126  NE2 GLN   127       2.356  39.812   6.052  1.00 51.91           N
ATOM   2129  C   GLN   127       7.425  39.636   4.995  1.00 34.69           C
ATOM   2130  O   GLN   127       7.851  40.424   5.838  1.00 33.60           O
ATOM   2132  N   GLU   128       7.683  38.335   5.043  1.00 35.26           N
ATOM   2133  CA  GLU   128       8.563  37.745   6.067  1.00 40.39           C
ATOM   2135  CB  GLU   128       8.623  36.223   5.892  1.00 41.49           C
ATOM   2138  CG  GLU   128       7.485  35.491   6.573  1.00 47.02           C
ATOM   2141  CD  GLU   128       6.930  34.334   5.760  1.00 63.09           C
ATOM   2142  OE1 GLU   128       7.704  33.634   5.067  1.00 51.55           O
ATOM   2143  OE2 GLU   128       5.699  34.126   5.826  1.00 65.34           O
ATOM   2144  C   GLU   128      10.001  38.324   6.084  1.00 45.71           C
ATOM   2145  O   GLU   128      10.679  38.302   7.119  1.00 48.40           O
ATOM   2147  N   SER   129      10.462  38.833   4.946  1.00 43.84           N
ATOM   2148  CA  SER   129      11.809  39.391   4.843  1.00 48.65           C
ATOM   2150  CB  SER   129      12.296  39.375   3.386  1.00 43.37           C
ATOM   2153  OG  SER   129      11.800  40.487   2.656  1.00 42.87           O
ATOM   2155  C   SER   129      11.874  40.812   5.408  1.00 52.03           C
ATOM   2156  O   SER   129      12.965  41.358   5.592  1.00 53.77           O
ATOM   2158  N   ARG   130      10.711  41.410   5.661  1.00 53.93           N
ATOM   2159  CA  ARG   130      10.633  42.740   6.267  1.00 59.45           C
ATOM   2161  CB  ARG   130       9.391  43.497   5.759  1.00 54.21           C
ATOM   2164  CG  ARG   130       9.681  44.307   4.492  1.00 68.78           C
ATOM   2167  CD  ARG   130       8.593  44.234   3.428  1.00 58.27           C
ATOM   2170  NE  ARG   130       9.175  44.426   2.091  1.00 71.54           N
ATOM   2172  CZ  ARG   130       8.794  45.337   1.189  1.00 79.48           C
ATOM   2173  NH1 ARG   130       9.414  45.386   0.007  1.00 73.01           N
ATOM   2176  NH2 ARG   130       7.790  46.185   1.432  1.00 82.81           N
ATOM   2179  C   ARG   130      10.653  42.648   7.793  1.00 61.53           C
ATOM   2180  O   ARG   130       9.981  41.818   8.419  1.00 64.77           O
ATOM   2182  OXT ARG   130      11.374  43.409   8.435  1.00 67.56           O
END
