
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  110 (  931),  selected  110 , name 1e6i_A
# Molecule2: number of CA atoms  130 ( 1064),  selected  130 , name T0432.pdb
# PARAMETERS: 1e6i_A.T0432.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      S       1           -
LGA    -       -      M       2           -
LGA    -       -      Q       3           -
LGA    -       -      E       4           -
LGA    -       -      E       5           -
LGA    -       -      D       6           -
LGA    -       -      T       7           -
LGA    R   329_A      F       8          5.468
LGA    G   330_A      R       9          2.043
LGA    P   331_A      E      10          4.152
LGA    H   332_A      L      11          1.140
LGA    D   333_A      R      12          1.272
LGA    A   334_A      I      13          1.868
LGA    A   335_A      F      14          1.466
LGA    I   336_A      L      15          0.617
LGA    Q   337_A      R      16          1.094
LGA    N   338_A      N      17          1.274
LGA    I   339_A      V      18          0.752
LGA    L   340_A      T      19          0.474
LGA    T   341_A      H      20          0.836
LGA    E   342_A      R      21          0.612
LGA    L   343_A      L      22          0.785
LGA    Q   344_A      A      23          0.519
LGA    N   345_A      I      24          1.065
LGA    H   346_A      D      25          1.131
LGA    A   347_A      K      26          2.041
LGA    A   348_A      R      27          1.425
LGA    A   349_A      F      28          1.274
LGA    W   350_A      R      29          0.596
LGA    P   351_A      V      30          0.424
LGA    F   352_A      F      31          0.697
LGA    L   353_A      T      32          0.676
LGA    Q   354_A      K      33          0.764
LGA    P   355_A      P      34          0.534
LGA    V   356_A      V      35          0.567
LGA    N   357_A      D      36          0.736
LGA    K   358_A      P      37          1.043
LGA    E   359_A      D      38          0.849
LGA    E   360_A      E      39          0.438
LGA    V   361_A      V      40          0.646
LGA    P   362_A      P      41          1.092
LGA    D   363_A      D      42          0.627
LGA    Y   364_A      Y      43          0.808
LGA    Y   365_A      V      44          1.396
LGA    D   366_A      T      45          1.313
LGA    F   367_A      V      46          1.071
LGA    I   368_A      I      47          0.558
LGA    K   369_A      K      48          0.527
LGA    E   370_A      Q      49          0.969
LGA    P   371_A      P      50          0.812
LGA    M   372_A      M      51          0.314
LGA    D   373_A      D      52          0.478
LGA    L   374_A      L      53          0.630
LGA    S   375_A      S      54          0.613
LGA    T   376_A      S      55          0.479
LGA    M   377_A      V      56          0.531
LGA    E   378_A      I      57          0.620
LGA    I   379_A      S      58          0.661
LGA    K   380_A      K      59          0.769
LGA    L   381_A      I      60          0.868
LGA    E   382_A      D      61          1.294
LGA    S   383_A      L      62          1.576
LGA    N   384_A      H      63          1.559
LGA    K   385_A      K      64          1.443
LGA    Y   386_A      Y      65          1.337
LGA    Q   387_A      L      66          1.479
LGA    K   388_A      T      67          2.048
LGA    M   389_A      V      68          1.779
LGA    E   390_A      K      69          1.539
LGA    D   391_A      D      70          1.405
LGA    F   392_A      Y      71          0.855
LGA    I   393_A      L      72          0.674
LGA    Y   394_A      R      73          0.612
LGA    D   395_A      D      74          0.616
LGA    A   396_A      I      75          0.674
LGA    R   397_A      D      76          0.666
LGA    L   398_A      L      77          0.637
LGA    V   399_A      I      78          0.406
LGA    F   400_A      C      79          0.644
LGA    N   401_A      S      80          0.681
LGA    N   402_A      N      81          0.360
LGA    C   403_A      A      82          0.215
LGA    R   404_A      L      83          0.471
LGA    M   405_A      E      84          0.713
LGA    Y   406_A      Y      85          0.528
LGA    N   407_A      N      86          0.268
LGA    G   408_A      P      87          2.642
LGA    -       -      D      88           -
LGA    E   409_A      R      89          4.923
LGA    N   410_A      D      90          4.125
LGA    T   411_A      P      91          3.919
LGA    S   412_A      G      92          3.904
LGA    -       -      D      93           -
LGA    -       -      R      94           -
LGA    -       -      L      95           -
LGA    Y   413_A      I      96          1.192
LGA    Y   414_A      R      97          1.201
LGA    K   415_A      H      98          1.793
LGA    Y   416_A      R      99          1.287
LGA    A   417_A      A     100          0.668
LGA    N   418_A      C     101          1.690
LGA    R   419_A      A     102          1.826
LGA    L   420_A      L     103          1.477
LGA    E   421_A      R     104          1.640
LGA    K   422_A      D     105          1.899
LGA    F   423_A      T     106          1.220
LGA    F   424_A      A     107          1.327
LGA    N   425_A      Y     108          1.688
LGA    N   426_A      A     109          1.027
LGA    K   427_A      I     110          0.847
LGA    V   428_A      I     111          1.218
LGA    K   429_A      K     112          1.263
LGA    E   430_A      E     113          0.923
LGA    I   431_A      E     114          2.562
LGA    -       -      L     115           -
LGA    P   432_A      D     116          3.527
LGA    E   433_A      E     117          1.798
LGA    -       -      D     118           -
LGA    -       -      F     119           -
LGA    Y   434_A      E     120          5.327
LGA    S   435_A      Q     121           #
LGA    H   436_A      L     122           -
LGA    L   437_A      C     123           -
LGA    I   438_A      E     124           -
LGA    -       -      E     125           -
LGA    -       -      I     126           -
LGA    -       -      Q     127           -
LGA    -       -      E     128           -
LGA    -       -      S     129           -
LGA    -       -      R     130           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  110  130    5.0    106    1.65    29.25     75.965     6.056

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.645778 * X  +   0.483188 * Y  +   0.591185 * Z  + -23.122028
  Y_new =   0.302397 * X  +   0.872825 * Y  +  -0.383057 * Z  +  19.757074
  Z_new =  -0.701089 * X  +  -0.068598 * Y  +  -0.709766 * Z  +  14.585314 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -3.045244    0.096349  [ DEG:  -174.4796      5.5204 ]
  Theta =   0.776924    2.364669  [ DEG:    44.5145    135.4855 ]
  Phi   =   2.703652   -0.437940  [ DEG:   154.9079    -25.0921 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1e6i_A                                        
REMARK     2: T0432.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1e6i_A.T0432.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  110  130   5.0  106   1.65   29.25  75.965
REMARK  ---------------------------------------------------------- 
MOLECULE 1e6i_A
HEADER    GENE REGULATION                         18-AUG-00   1E6I              
TITLE     BROMODOMAIN FROM GCN5 COMPLEXED WITH ACETYLATED H4 PEPTIDE            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRANSCRIPTIONAL ACTIVATOR GCN5;                            
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: BROMODOMAIN;                                               
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MOL_ID: 2;                                                           
COMPND   7 MOLECULE: H4 PEPTIDE;                                                
COMPND   8 CHAIN: P;                                                            
COMPND   9 FRAGMENT: ACETYLATED TAIL;                                           
COMPND  10 OTHER_DETAILS: LYSINE 16 IS ACETYLATED ON NZ                         
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE   3 GENE: GCN5;                                                          
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_PLASMID: PET30A;                                   
SOURCE   6 MOL_ID: 2;                                                           
SOURCE   7 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE                        
KEYWDS    BROMODOMAIN, HISTONE BINDING, N-ACETYL LYSINE                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    D.J.OWEN,A.A.TRAVERS,P.R.EVANS                                        
REVDAT   1   24-NOV-00 1E6I    0                                                
JRNL        AUTH   D.J.OWEN,P.ORNAGHI,J.C.YANG,N.LOWE,P.R.EVANS,                
JRNL        AUTH 2 P.BALLARIO,D.NEUHAUS,P.FILETICI,A.A.TRAVERS                  
JRNL        TITL   THE STRUCTURAL BASIS FOR THE RECOGNITION OF                  
JRNL        TITL 2 ACETYLATED HISTONE H4 BY THE BROMODOMAIN OF                  
JRNL        TITL 3 HISTONE ACETYLTRANSFERASE GCN5P.                             
JRNL        REF    EMBO J.                       V.  19  6141 2000              
JRNL        REFN   ASTM EMJODG  UK ISSN 0261-4189                               
REMARK   2 RESOLUTION. 1.87 ANGSTROMS.                                          
DBREF  1E6I A  320   439  UNP    Q03330   GCN5_YEAST     320    439             
DBREF  1E6I P   15    29  UNP    P02309   H4_YEAST        15     29             
SEQRES   1 A  121  ALA MET ALA ASN ILE ALA GLN ARG PRO LYS ARG GLY PRO          
SEQRES   2 A  121  HIS ASP ALA ALA ILE GLN ASN ILE LEU THR GLU LEU GLN          
SEQRES   3 A  121  ASN HIS ALA ALA ALA TRP PRO PHE LEU GLN PRO VAL ASN          
SEQRES   4 A  121  LYS GLU GLU VAL PRO ASP TYR TYR ASP PHE ILE LYS GLU          
SEQRES   5 A  121  PRO MET ASP LEU SER THR MET GLU ILE LYS LEU GLU SER          
SEQRES   6 A  121  ASN LYS TYR GLN LYS MET GLU ASP PHE ILE TYR ASP ALA          
SEQRES   7 A  121  ARG LEU VAL PHE ASN ASN CYS ARG MET TYR ASN GLY GLU          
SEQRES   8 A  121  ASN THR SER TYR TYR LYS TYR ALA ASN ARG LEU GLU LYS          
SEQRES   9 A  121  PHE PHE ASN ASN LYS VAL LYS GLU ILE PRO GLU TYR SER          
SEQRES  10 A  121  HIS LEU ILE ASP                                              
SEQRES   1 P   15  ALA ALY ARG HIS ARG LYS ILE LEU ARG ASN SER ILE GLN          
SEQRES   2 P   15  GLY ILE                                                      
HET    ALY  P  16      12                                                       
HETNAM     ALY N(6)-ACETYLLYSINE                                                
FORMUL   2  ALY    C8 H16 N2 O3                                                 
FORMUL   3  HOH   *109(H2 O)                                                    
CRYST1   43.680   71.920   89.200  90.00  90.00  90.00 C 2 2 21      8          
ATOM      1  N   ARG A 329       3.214  47.786  -9.197  1.00 49.55           N  
ATOM      2  CA  ARG A 329       2.054  47.407  -8.330  1.00 48.41           C  
ATOM      3  C   ARG A 329       2.427  46.348  -7.295  1.00 47.85           C  
ATOM      4  O   ARG A 329       3.287  45.499  -7.540  1.00 47.81           O  
ATOM      5  CB  ARG A 329       0.885  46.889  -9.178  1.00 48.63           C  
ATOM      6  CG  ARG A 329      -0.079  47.968  -9.664  1.00 48.14           C  
ATOM      7  CD  ARG A 329      -1.516  47.494  -9.866  1.00 48.98           C  
ATOM      8  NE  ARG A 329      -2.425  48.014  -8.848  1.00 48.74           N  
ATOM      9  CZ  ARG A 329      -3.727  47.763  -8.801  1.00 47.64           C  
ATOM     10  NH1 ARG A 329      -4.296  47.000  -9.719  1.00 47.88           N  
ATOM     11  NH2 ARG A 329      -4.467  48.290  -7.838  1.00 47.78           N  
ATOM     12  N   GLY A 330       1.843  46.461  -6.106  1.00 45.58           N  
ATOM     13  CA  GLY A 330       1.938  45.423  -5.094  1.00 44.32           C  
ATOM     14  C   GLY A 330       1.659  44.038  -5.650  1.00 40.45           C  
ATOM     15  O   GLY A 330       0.795  43.891  -6.496  1.00 36.27           O  
ATOM     16  N   PRO A 331       2.393  43.031  -5.174  1.00 38.55           N  
ATOM     17  CA  PRO A 331       2.220  41.650  -5.625  1.00 37.06           C  
ATOM     18  C   PRO A 331       0.811  41.097  -5.443  1.00 34.05           C  
ATOM     19  O   PRO A 331       0.490  40.133  -6.122  1.00 35.25           O  
ATOM     20  CB  PRO A 331       3.197  40.868  -4.737  1.00 37.87           C  
ATOM     21  CG  PRO A 331       4.188  41.810  -4.360  1.00 40.39           C  
ATOM     22  CD  PRO A 331       3.478  43.125  -4.188  1.00 39.87           C  
ATOM     23  N   HIS A 332       0.004  41.677  -4.556  1.00 30.11           N  
ATOM     24  CA  HIS A 332      -1.373  41.220  -4.363  1.00 26.42           C  
ATOM     25  C   HIS A 332      -2.424  42.288  -4.669  1.00 23.99           C  
ATOM     26  O   HIS A 332      -3.626  42.025  -4.566  1.00 19.80           O  
ATOM     27  CB  HIS A 332      -1.589  40.761  -2.926  1.00 26.01           C  
ATOM     28  CG  HIS A 332      -0.503  39.884  -2.395  1.00 28.13           C  
ATOM     29  ND1 HIS A 332      -0.234  38.635  -2.913  1.00 29.44           N  
ATOM     30  CD2 HIS A 332       0.278  40.002  -1.298  1.00 30.17           C  
ATOM     31  CE1 HIS A 332       0.861  38.167  -2.339  1.00 31.32           C  
ATOM     32  NE2 HIS A 332       1.191  38.980  -1.350  1.00 29.46           N  
ATOM     33  N   ASP A 333      -1.988  43.487  -5.039  1.00 25.47           N  
ATOM     34  CA  ASP A 333      -2.917  44.590  -5.285  1.00 25.26           C  
ATOM     35  C   ASP A 333      -4.036  44.261  -6.278  1.00 22.69           C  
ATOM     36  O   ASP A 333      -5.204  44.571  -6.026  1.00 21.82           O  
ATOM     37  CB  ASP A 333      -2.161  45.826  -5.790  1.00 27.19           C  
ATOM     38  CG  ASP A 333      -1.299  46.467  -4.726  1.00 31.92           C  
ATOM     39  OD1 ASP A 333      -1.378  46.038  -3.556  1.00 29.16           O  
ATOM     40  OD2 ASP A 333      -0.511  47.416  -4.970  1.00 33.49           O  
ATOM     41  N   ALA A 334      -3.686  43.677  -7.420  1.00 22.74           N  
ATOM     42  CA  ALA A 334      -4.682  43.453  -8.464  1.00 23.64           C  
ATOM     43  C   ALA A 334      -5.671  42.380  -8.042  1.00 20.43           C  
ATOM     44  O   ALA A 334      -6.860  42.509  -8.268  1.00 19.32           O  
ATOM     45  CB  ALA A 334      -4.037  43.087  -9.807  1.00 26.18           C  
ATOM     46  N   ALA A 335      -5.179  41.343  -7.388  1.00 19.90           N  
ATOM     47  CA  ALA A 335      -6.048  40.259  -6.983  1.00 18.82           C  
ATOM     48  C   ALA A 335      -7.010  40.772  -5.904  1.00 17.87           C  
ATOM     49  O   ALA A 335      -8.207  40.487  -5.926  1.00 13.64           O  
ATOM     50  CB  ALA A 335      -5.224  39.093  -6.480  1.00 21.24           C  
ATOM     51  N   ILE A 336      -6.479  41.543  -4.965  1.00 18.80           N  
ATOM     52  CA  ILE A 336      -7.304  42.101  -3.888  1.00 18.23           C  
ATOM     53  C   ILE A 336      -8.382  43.065  -4.442  1.00 19.47           C  
ATOM     54  O   ILE A 336      -9.552  42.980  -4.044  1.00 18.19           O  
ATOM     55  CB  ILE A 336      -6.419  42.766  -2.813  1.00 17.84           C  
ATOM     56  CG1 ILE A 336      -5.514  41.712  -2.161  1.00 18.17           C  
ATOM     57  CG2 ILE A 336      -7.293  43.447  -1.744  1.00 19.00           C  
ATOM     58  CD1 ILE A 336      -4.658  42.198  -0.984  1.00 19.78           C  
ATOM     59  N   GLN A 337      -8.000  43.986  -5.335  1.00 16.80           N  
ATOM     60  CA  GLN A 337      -8.968  44.905  -5.943  1.00 19.11           C  
ATOM     61  C   GLN A 337     -10.078  44.146  -6.655  1.00 18.06           C  
ATOM     62  O   GLN A 337     -11.238  44.511  -6.546  1.00 16.45           O  
ATOM     63  CB  GLN A 337      -8.309  45.870  -6.951  1.00 19.05           C  
ATOM     64  CG  GLN A 337      -9.269  46.928  -7.517  1.00 23.26           C  
ATOM     65  CD  GLN A 337      -9.914  47.807  -6.444  1.00 27.70           C  
ATOM     66  OE1 GLN A 337      -9.377  48.856  -6.105  1.00 27.89           O  
ATOM     67  NE2 GLN A 337     -11.076  47.389  -5.930  1.00 24.71           N  
ATOM     68  N   ASN A 338      -9.717  43.115  -7.420  1.00 17.61           N  
ATOM     69  CA  ASN A 338     -10.722  42.332  -8.136  1.00 19.10           C  
ATOM     70  C   ASN A 338     -11.705  41.651  -7.165  1.00 16.85           C  
ATOM     71  O   ASN A 338     -12.906  41.674  -7.367  1.00 14.93           O  
ATOM     72  CB  ASN A 338     -10.060  41.281  -9.042  1.00 23.52           C  
ATOM     73  CG  ASN A 338     -11.066  40.265  -9.607  1.00 30.46           C  
ATOM     74  OD1 ASN A 338     -11.119  39.106  -9.178  1.00 34.60           O  
ATOM     75  ND2 ASN A 338     -11.866  40.702 -10.568  1.00 33.85           N  
ATOM     76  N   ILE A 339     -11.181  41.035  -6.114  1.00 16.27           N  
ATOM     77  CA  ILE A 339     -12.030  40.337  -5.158  1.00 15.64           C  
ATOM     78  C   ILE A 339     -12.918  41.334  -4.429  1.00 15.76           C  
ATOM     79  O   ILE A 339     -14.103  41.111  -4.259  1.00 12.37           O  
ATOM     80  CB  ILE A 339     -11.199  39.558  -4.121  1.00 14.56           C  
ATOM     81  CG1 ILE A 339     -10.437  38.415  -4.769  1.00 17.52           C  
ATOM     82  CG2 ILE A 339     -12.115  39.031  -3.038  1.00 13.27           C  
ATOM     83  CD1 ILE A 339      -9.239  37.993  -3.977  1.00 19.56           C  
ATOM     84  N   LEU A 340     -12.342  42.467  -4.040  1.00 13.08           N  
ATOM     85  CA  LEU A 340     -13.114  43.466  -3.305  1.00 14.53           C  
ATOM     86  C   LEU A 340     -14.258  44.047  -4.159  1.00 17.18           C  
ATOM     87  O   LEU A 340     -15.373  44.228  -3.686  1.00 13.85           O  
ATOM     88  CB  LEU A 340     -12.178  44.558  -2.822  1.00 14.27           C  
ATOM     89  CG  LEU A 340     -12.860  45.702  -2.090  1.00 15.91           C  
ATOM     90  CD1 LEU A 340     -13.553  45.147  -0.883  1.00 16.51           C  
ATOM     91  CD2 LEU A 340     -11.834  46.721  -1.671  1.00 16.41           C  
ATOM     92  N   THR A 341     -13.959  44.363  -5.410  1.00 14.75           N  
ATOM     93  CA  THR A 341     -14.980  44.798  -6.353  1.00 16.19           C  
ATOM     94  C   THR A 341     -16.152  43.784  -6.468  1.00 14.53           C  
ATOM     95  O   THR A 341     -17.322  44.156  -6.400  1.00 16.23           O  
ATOM     96  CB  THR A 341     -14.323  45.028  -7.706  1.00 19.98           C  
ATOM     97  OG1 THR A 341     -13.381  46.111  -7.589  1.00 20.70           O  
ATOM     98  CG2 THR A 341     -15.342  45.506  -8.725  1.00 21.21           C  
ATOM     99  N   GLU A 342     -15.827  42.512  -6.621  1.00 14.68           N  
ATOM    100  CA  GLU A 342     -16.844  41.460  -6.652  1.00 18.22           C  
ATOM    101  C   GLU A 342     -17.658  41.387  -5.353  1.00 15.66           C  
ATOM    102  O   GLU A 342     -18.859  41.214  -5.396  1.00 14.71           O  
ATOM    103  CB  GLU A 342     -16.188  40.114  -6.881  1.00 20.91           C  
ATOM    104  CG  GLU A 342     -15.519  39.995  -8.232  1.00 24.90           C  
ATOM    105  CD  GLU A 342     -16.274  39.104  -9.181  1.00 31.18           C  
ATOM    106  OE1 GLU A 342     -17.431  38.745  -8.869  1.00 31.19           O  
ATOM    107  OE2 GLU A 342     -15.692  38.767 -10.235  1.00 32.35           O  
ATOM    108  N   LEU A 343     -16.987  41.467  -4.207  1.00 13.97           N  
ATOM    109  CA  LEU A 343     -17.695  41.470  -2.936  1.00 15.04           C  
ATOM    110  C   LEU A 343     -18.662  42.630  -2.914  1.00 14.09           C  
ATOM    111  O   LEU A 343     -19.810  42.456  -2.571  1.00 15.00           O  
ATOM    112  CB  LEU A 343     -16.746  41.636  -1.750  1.00 15.57           C  
ATOM    113  CG  LEU A 343     -15.884  40.453  -1.374  1.00 14.09           C  
ATOM    114  CD1 LEU A 343     -14.834  40.803  -0.331  1.00 13.59           C  
ATOM    115  CD2 LEU A 343     -16.824  39.382  -0.793  1.00 15.57           C  
ATOM    116  N   GLN A 344     -18.192  43.825  -3.253  1.00  9.65           N  
ATOM    117  CA  GLN A 344     -19.055  44.999  -3.167  1.00 12.01           C  
ATOM    118  C   GLN A 344     -20.259  44.915  -4.109  1.00 14.23           C  
ATOM    119  O   GLN A 344     -21.301  45.468  -3.806  1.00 15.50           O  
ATOM    120  CB  GLN A 344     -18.280  46.300  -3.437  1.00 16.01           C  
ATOM    121  CG  GLN A 344     -17.194  46.599  -2.411  1.00 15.23           C  
ATOM    122  CD  GLN A 344     -16.276  47.726  -2.818  1.00 20.42           C  
ATOM    123  OE1 GLN A 344     -15.803  47.774  -3.958  1.00 19.31           O  
ATOM    124  NE2 GLN A 344     -15.992  48.624  -1.877  1.00 14.28           N  
ATOM    125  N   ASN A 345     -20.090  44.237  -5.239  1.00 13.40           N  
ATOM    126  CA  ASN A 345     -21.137  44.038  -6.245  1.00 14.03           C  
ATOM    127  C   ASN A 345     -22.141  42.950  -5.846  1.00 16.38           C  
ATOM    128  O   ASN A 345     -23.209  42.826  -6.437  1.00 12.27           O  
ATOM    129  CB  ASN A 345     -20.451  43.596  -7.547  1.00 18.89           C  
ATOM    130  CG  ASN A 345     -21.422  43.350  -8.683  1.00 22.11           C  
ATOM    131  OD1 ASN A 345     -22.089  44.287  -9.141  1.00 24.03           O  
ATOM    132  ND2 ASN A 345     -21.476  42.091  -9.186  1.00 20.57           N  
ATOM    133  N   HIS A 346     -21.782  42.153  -4.841  1.00 13.54           N  
ATOM    134  CA  HIS A 346     -22.558  40.944  -4.530  1.00 15.23           C  
ATOM    135  C   HIS A 346     -23.929  41.258  -3.950  1.00 14.15           C  
ATOM    136  O   HIS A 346     -24.090  42.223  -3.183  1.00 11.50           O  
ATOM    137  CB  HIS A 346     -21.765  40.022  -3.569  1.00 13.68           C  
ATOM    138  CG  HIS A 346     -22.284  38.615  -3.514  1.00 12.85           C  
ATOM    139  ND1 HIS A 346     -23.387  38.259  -2.777  1.00 15.76           N  
ATOM    140  CD2 HIS A 346     -21.860  37.485  -4.126  1.00 10.65           C  
ATOM    141  CE1 HIS A 346     -23.579  36.957  -2.872  1.00 12.12           C  
ATOM    142  NE2 HIS A 346     -22.706  36.472  -3.735  1.00 12.30           N  
ATOM    143  N   ALA A 347     -24.895  40.378  -4.242  1.00 13.30           N  
ATOM    144  CA  ALA A 347     -26.268  40.552  -3.786  1.00 12.47           C  
ATOM    145  C   ALA A 347     -26.351  40.606  -2.278  1.00 12.59           C  
ATOM    146  O   ALA A 347     -27.221  41.273  -1.724  1.00 13.55           O  
ATOM    147  CB  ALA A 347     -27.130  39.425  -4.276  1.00 13.18           C  
ATOM    148  N   ALA A 348     -25.439  39.890  -1.609  1.00 11.70           N  
ATOM    149  CA  ALA A 348     -25.446  39.818  -0.141  1.00 11.46           C  
ATOM    150  C   ALA A 348     -24.560  40.870   0.547  1.00 11.87           C  
ATOM    151  O   ALA A 348     -24.435  40.874   1.781  1.00 11.87           O  
ATOM    152  CB  ALA A 348     -25.051  38.419   0.296  1.00 12.10           C  
ATOM    153  N   ALA A 349     -24.006  41.800  -0.232  1.00 11.56           N  
ATOM    154  CA  ALA A 349     -23.033  42.748   0.331  1.00 12.57           C  
ATOM    155  C   ALA A 349     -23.650  43.960   1.007  1.00 10.87           C  
ATOM    156  O   ALA A 349     -22.996  44.573   1.864  1.00 12.85           O  
ATOM    157  CB  ALA A 349     -22.067  43.229  -0.751  1.00 12.42           C  
ATOM    158  N   TRP A 350     -24.878  44.313   0.627  1.00 10.05           N  
ATOM    159  CA  TRP A 350     -25.482  45.567   1.111  1.00 10.25           C  
ATOM    160  C   TRP A 350     -25.321  45.891   2.622  1.00  9.52           C  
ATOM    161  O   TRP A 350     -25.014  47.026   2.962  1.00 12.95           O  
ATOM    162  CB  TRP A 350     -26.927  45.805   0.604  1.00 12.35           C  
ATOM    163  CG  TRP A 350     -27.984  45.012   1.214  1.00 12.82           C  
ATOM    164  CD1 TRP A 350     -28.573  43.900   0.681  1.00 12.83           C  
ATOM    165  CD2 TRP A 350     -28.638  45.251   2.463  1.00 15.19           C  
ATOM    166  NE1 TRP A 350     -29.529  43.413   1.537  1.00 16.87           N  
ATOM    167  CE2 TRP A 350     -29.589  44.215   2.645  1.00 16.37           C  
ATOM    168  CE3 TRP A 350     -28.497  46.209   3.471  1.00 14.96           C  
ATOM    169  CZ2 TRP A 350     -30.409  44.131   3.768  1.00 14.54           C  
ATOM    170  CZ3 TRP A 350     -29.319  46.120   4.599  1.00 16.15           C  
ATOM    171  CH2 TRP A 350     -30.257  45.084   4.733  1.00 14.77           C  
ATOM    172  N   PRO A 351     -25.504  44.950   3.546  1.00  9.78           N  
ATOM    173  CA  PRO A 351     -25.320  45.292   4.969  1.00  7.76           C  
ATOM    174  C   PRO A 351     -23.887  45.672   5.378  1.00 12.61           C  
ATOM    175  O   PRO A 351     -23.676  46.262   6.443  1.00 10.70           O  
ATOM    176  CB  PRO A 351     -25.682  44.012   5.695  1.00 11.07           C  
ATOM    177  CG  PRO A 351     -26.455  43.222   4.749  1.00  9.95           C  
ATOM    178  CD  PRO A 351     -25.921  43.555   3.365  1.00  9.95           C  
ATOM    179  N   PHE A 352     -22.933  45.315   4.539  1.00 10.49           N  
ATOM    180  CA  PHE A 352     -21.502  45.389   4.861  1.00 12.05           C  
ATOM    181  C   PHE A 352     -20.745  46.474   4.068  1.00 13.22           C  
ATOM    182  O   PHE A 352     -19.541  46.607   4.199  1.00 12.38           O  
ATOM    183  CB  PHE A 352     -20.871  44.016   4.570  1.00 13.13           C  
ATOM    184  CG  PHE A 352     -21.647  42.849   5.170  1.00  9.09           C  
ATOM    185  CD1 PHE A 352     -21.797  42.719   6.541  1.00  9.90           C  
ATOM    186  CD2 PHE A 352     -22.237  41.909   4.355  1.00 13.73           C  
ATOM    187  CE1 PHE A 352     -22.514  41.659   7.072  1.00 13.76           C  
ATOM    188  CE2 PHE A 352     -22.966  40.852   4.879  1.00 12.14           C  
ATOM    189  CZ  PHE A 352     -23.107  40.731   6.228  1.00 12.97           C  
ATOM    190  N   LEU A 353     -21.452  47.245   3.246  1.00 13.74           N  
ATOM    191  CA  LEU A 353     -20.792  48.245   2.390  1.00 12.15           C  
ATOM    192  C   LEU A 353     -20.193  49.419   3.139  1.00 16.01           C  
ATOM    193  O   LEU A 353     -19.276  50.053   2.640  1.00 14.34           O  
ATOM    194  CB  LEU A 353     -21.767  48.818   1.360  1.00 12.81           C  
ATOM    195  CG  LEU A 353     -22.310  47.828   0.355  1.00 14.26           C  
ATOM    196  CD1 LEU A 353     -23.380  48.494  -0.524  1.00 17.11           C  
ATOM    197  CD2 LEU A 353     -21.172  47.253  -0.482  1.00 14.14           C  
ATOM    198  N   GLN A 354     -20.745  49.731   4.300  1.00 15.02           N  
ATOM    199  CA  GLN A 354     -20.266  50.839   5.112  1.00 17.90           C  
ATOM    200  C   GLN A 354     -20.268  50.437   6.568  1.00 15.86           C  
ATOM    201  O   GLN A 354     -20.928  49.463   6.933  1.00 13.88           O  
ATOM    202  CB  GLN A 354     -21.196  52.044   4.934  1.00 19.83           C  
ATOM    203  CG  GLN A 354     -20.946  52.763   3.620  1.00 29.97           C  
ATOM    204  CD  GLN A 354     -22.192  53.366   3.029  1.00 38.38           C  
ATOM    205  OE1 GLN A 354     -22.869  54.172   3.677  1.00 42.66           O  
ATOM    206  NE2 GLN A 354     -22.510  52.977   1.792  1.00 44.62           N  
ATOM    207  N   PRO A 355     -19.539  51.166   7.405  1.00 12.44           N  
ATOM    208  CA  PRO A 355     -19.562  50.877   8.841  1.00 14.68           C  
ATOM    209  C   PRO A 355     -20.962  50.893   9.405  1.00 13.53           C  
ATOM    210  O   PRO A 355     -21.844  51.618   8.932  1.00 10.05           O  
ATOM    211  CB  PRO A 355     -18.760  52.035   9.465  1.00 15.07           C  
ATOM    212  CG  PRO A 355     -17.921  52.549   8.394  1.00 13.41           C  
ATOM    213  CD  PRO A 355     -18.621  52.280   7.087  1.00 14.57           C  
ATOM    214  N   VAL A 356     -21.165  50.100  10.449  1.00 13.19           N  
ATOM    215  CA  VAL A 356     -22.445  50.126  11.121  1.00 12.86           C  
ATOM    216  C   VAL A 356     -22.624  51.498  11.736  1.00 14.41           C  
ATOM    217  O   VAL A 356     -21.692  52.050  12.302  1.00 15.12           O  
ATOM    218  CB  VAL A 356     -22.560  49.003  12.163  1.00 15.13           C  
ATOM    219  CG1 VAL A 356     -23.729  49.263  13.133  1.00 12.86           C  
ATOM    220  CG2 VAL A 356     -22.711  47.645  11.438  1.00 15.46           C  
ATOM    221  N   ASN A 357     -23.814  52.067  11.542  1.00 18.16           N  
ATOM    222  CA  ASN A 357     -24.184  53.356  12.092  1.00 19.60           C  
ATOM    223  C   ASN A 357     -24.617  53.247  13.551  1.00 17.63           C  
ATOM    224  O   ASN A 357     -25.622  52.607  13.854  1.00 19.71           O  
ATOM    225  CB  ASN A 357     -25.344  53.957  11.300  1.00 23.74           C  
ATOM    226  CG  ASN A 357     -25.661  55.372  11.733  1.00 28.56           C  
ATOM    227  OD1 ASN A 357     -25.826  55.651  12.917  1.00 32.21           O  
ATOM    228  ND2 ASN A 357     -25.746  56.271  10.773  1.00 35.42           N  
ATOM    229  N   LYS A 358     -23.868  53.891  14.435  1.00 19.33           N  
ATOM    230  CA  LYS A 358     -24.099  53.817  15.887  1.00 21.39           C  
ATOM    231  C   LYS A 358     -25.459  54.381  16.303  1.00 24.69           C  
ATOM    232  O   LYS A 358     -26.040  53.935  17.282  1.00 25.28           O  
ATOM    233  CB  LYS A 358     -22.976  54.540  16.638  1.00 24.50           C  
ATOM    234  CG  LYS A 358     -23.037  54.409  18.144  1.00 27.38           C  
ATOM    235  CD  LYS A 358     -21.762  54.884  18.856  1.00 32.55           C  
ATOM    236  CE  LYS A 358     -21.469  56.384  18.643  1.00 34.45           C  
ATOM    237  NZ  LYS A 358     -20.351  56.884  19.524  1.00 34.18           N  
ATOM    238  N   GLU A 359     -25.974  55.347  15.556  1.00 25.86           N  
ATOM    239  CA  GLU A 359     -27.266  55.932  15.893  1.00 28.96           C  
ATOM    240  C   GLU A 359     -28.401  54.965  15.559  1.00 28.85           C  
ATOM    241  O   GLU A 359     -29.452  54.993  16.205  1.00 29.40           O  
ATOM    242  CB  GLU A 359     -27.450  57.285  15.196  1.00 32.30           C  
ATOM    243  CG  GLU A 359     -26.458  58.314  15.716  1.00 37.13           C  
ATOM    244  CD  GLU A 359     -26.833  59.738  15.395  1.00 42.39           C  
ATOM    245  OE1 GLU A 359     -27.696  60.309  16.110  1.00 46.85           O  
ATOM    246  OE2 GLU A 359     -26.237  60.287  14.446  1.00 43.72           O  
ATOM    247  N   GLU A 360     -28.183  54.109  14.563  1.00 25.06           N  
ATOM    248  CA  GLU A 360     -29.180  53.114  14.182  1.00 25.55           C  
ATOM    249  C   GLU A 360     -29.017  51.825  14.994  1.00 24.60           C  
ATOM    250  O   GLU A 360     -29.972  51.067  15.156  1.00 21.26           O  
ATOM    251  CB  GLU A 360     -29.108  52.806  12.695  1.00 27.38           C  
ATOM    252  CG  GLU A 360     -29.765  53.846  11.788  1.00 37.23           C  
ATOM    253  CD  GLU A 360     -31.293  53.859  11.850  1.00 44.51           C  
ATOM    254  OE1 GLU A 360     -31.906  53.049  12.592  1.00 48.98           O  
ATOM    255  OE2 GLU A 360     -31.898  54.694  11.141  1.00 51.18           O  
ATOM    256  N   VAL A 361     -27.806  51.576  15.488  1.00 17.86           N  
ATOM    257  CA  VAL A 361     -27.523  50.372  16.266  1.00 19.91           C  
ATOM    258  C   VAL A 361     -26.661  50.791  17.442  1.00 22.95           C  
ATOM    259  O   VAL A 361     -25.473  50.511  17.467  1.00 16.14           O  
ATOM    260  CB  VAL A 361     -26.787  49.283  15.450  1.00 17.12           C  
ATOM    261  CG1 VAL A 361     -26.885  47.926  16.179  1.00 17.16           C  
ATOM    262  CG2 VAL A 361     -27.332  49.196  14.035  1.00 16.47           C  
ATOM    263  N   PRO A 362     -27.296  51.449  18.421  1.00 25.39           N  
ATOM    264  CA  PRO A 362     -26.616  52.079  19.559  1.00 23.10           C  
ATOM    265  C   PRO A 362     -25.611  51.248  20.354  1.00 21.41           C  
ATOM    266  O   PRO A 362     -24.645  51.835  20.820  1.00 21.96           O  
ATOM    267  CB  PRO A 362     -27.783  52.503  20.476  1.00 25.70           C  
ATOM    268  CG  PRO A 362     -28.965  52.591  19.605  1.00 25.56           C  
ATOM    269  CD  PRO A 362     -28.754  51.645  18.473  1.00 23.57           C  
ATOM    270  N   ASP A 363     -25.820  49.952  20.530  1.00 19.23           N  
ATOM    271  CA  ASP A 363     -24.873  49.150  21.324  1.00 19.26           C  
ATOM    272  C   ASP A 363     -23.840  48.393  20.488  1.00 17.85           C  
ATOM    273  O   ASP A 363     -23.028  47.667  21.039  1.00 18.01           O  
ATOM    274  CB  ASP A 363     -25.607  48.143  22.213  1.00 21.00           C  
ATOM    275  CG  ASP A 363     -26.345  47.082  21.428  1.00 23.81           C  
ATOM    276  OD1 ASP A 363     -26.268  47.071  20.178  1.00 24.65           O  
ATOM    277  OD2 ASP A 363     -27.051  46.225  21.990  1.00 24.18           O  
ATOM    278  N   TYR A 364     -23.886  48.536  19.168  1.00 15.61           N  
ATOM    279  CA  TYR A 364     -22.998  47.731  18.305  1.00 16.22           C  
ATOM    280  C   TYR A 364     -21.524  47.713  18.743  1.00 13.69           C  
ATOM    281  O   TYR A 364     -20.928  46.651  18.902  1.00 13.97           O  
ATOM    282  CB  TYR A 364     -23.111  48.177  16.860  1.00 14.44           C  
ATOM    283  CG  TYR A 364     -22.347  47.277  15.892  1.00 12.47           C  
ATOM    284  CD1 TYR A 364     -22.868  46.054  15.481  1.00 11.10           C  
ATOM    285  CD2 TYR A 364     -21.099  47.647  15.409  1.00 15.16           C  
ATOM    286  CE1 TYR A 364     -22.165  45.240  14.618  1.00 11.43           C  
ATOM    287  CE2 TYR A 364     -20.394  46.839  14.544  1.00 13.61           C  
ATOM    288  CZ  TYR A 364     -20.926  45.637  14.148  1.00 13.23           C  
ATOM    289  OH  TYR A 364     -20.218  44.843  13.274  1.00 12.47           O  
ATOM    290  N   TYR A 365     -20.956  48.893  18.987  1.00 13.98           N  
ATOM    291  CA  TYR A 365     -19.533  49.018  19.311  1.00 14.68           C  
ATOM    292  C   TYR A 365     -19.227  48.659  20.758  1.00 17.86           C  
ATOM    293  O   TYR A 365     -18.056  48.564  21.151  1.00 16.48           O  
ATOM    294  CB  TYR A 365     -19.014  50.417  18.926  1.00 15.25           C  
ATOM    295  CG  TYR A 365     -19.123  50.617  17.444  1.00 14.01           C  
ATOM    296  CD1 TYR A 365     -18.184  50.057  16.583  1.00 13.39           C  
ATOM    297  CD2 TYR A 365     -20.210  51.290  16.885  1.00 13.21           C  
ATOM    298  CE1 TYR A 365     -18.284  50.209  15.220  1.00 13.77           C  
ATOM    299  CE2 TYR A 365     -20.322  51.426  15.509  1.00 14.82           C  
ATOM    300  CZ  TYR A 365     -19.351  50.888  14.693  1.00 12.99           C  
ATOM    301  OH  TYR A 365     -19.439  51.005  13.354  1.00 11.60           O  
ATOM    302  N   ASP A 366     -20.272  48.427  21.543  1.00 18.97           N  
ATOM    303  CA  ASP A 366     -20.080  47.905  22.893  1.00 22.11           C  
ATOM    304  C   ASP A 366     -19.645  46.455  22.801  1.00 21.63           C  
ATOM    305  O   ASP A 366     -18.942  45.949  23.676  1.00 23.79           O  
ATOM    306  CB  ASP A 366     -21.367  47.935  23.700  1.00 26.09           C  
ATOM    307  CG  ASP A 366     -21.809  49.336  24.067  1.00 29.46           C  
ATOM    308  OD1 ASP A 366     -20.986  50.283  24.010  1.00 31.90           O  
ATOM    309  OD2 ASP A 366     -22.980  49.560  24.442  1.00 31.18           O  
ATOM    310  N   PHE A 367     -20.083  45.784  21.740  1.00 15.74           N  
ATOM    311  CA  PHE A 367     -19.804  44.377  21.562  1.00 18.62           C  
ATOM    312  C   PHE A 367     -18.737  44.048  20.533  1.00 16.50           C  
ATOM    313  O   PHE A 367     -17.990  43.100  20.708  1.00 17.78           O  
ATOM    314  CB  PHE A 367     -21.089  43.663  21.161  1.00 22.23           C  
ATOM    315  CG  PHE A 367     -22.139  43.716  22.214  1.00 24.91           C  
ATOM    316  CD1 PHE A 367     -22.030  42.931  23.345  1.00 30.56           C  
ATOM    317  CD2 PHE A 367     -23.224  44.562  22.083  1.00 27.59           C  
ATOM    318  CE1 PHE A 367     -22.992  42.981  24.338  1.00 36.03           C  
ATOM    319  CE2 PHE A 367     -24.195  44.623  23.065  1.00 34.03           C  
ATOM    320  CZ  PHE A 367     -24.083  43.827  24.201  1.00 36.16           C  
ATOM    321  N   ILE A 368     -18.709  44.798  19.440  1.00 11.53           N  
ATOM    322  CA  ILE A 368     -17.782  44.515  18.357  1.00 12.49           C  
ATOM    323  C   ILE A 368     -16.573  45.408  18.521  1.00 14.31           C  
ATOM    324  O   ILE A 368     -16.676  46.619  18.325  1.00 14.87           O  
ATOM    325  CB  ILE A 368     -18.488  44.742  16.996  1.00 14.83           C  
ATOM    326  CG1 ILE A 368     -19.689  43.778  16.873  1.00 17.15           C  
ATOM    327  CG2 ILE A 368     -17.524  44.565  15.877  1.00 14.33           C  
ATOM    328  CD1 ILE A 368     -19.329  42.330  16.958  1.00 19.48           C  
ATOM    329  N   LYS A 369     -15.438  44.806  18.908  1.00 12.52           N  
ATOM    330  CA  LYS A 369     -14.211  45.559  19.194  1.00 14.72           C  
ATOM    331  C   LYS A 369     -13.267  45.775  18.015  1.00 16.56           C  
ATOM    332  O   LYS A 369     -12.460  46.706  18.043  1.00 15.08           O  
ATOM    333  CB  LYS A 369     -13.487  44.941  20.395  1.00 15.44           C  
ATOM    334  CG  LYS A 369     -14.333  45.066  21.682  1.00 18.59           C  
ATOM    335  CD  LYS A 369     -15.027  46.430  21.769  1.00 26.58           C  
ATOM    336  CE  LYS A 369     -15.402  46.867  23.183  1.00 32.02           C  
ATOM    337  NZ  LYS A 369     -16.150  48.191  23.193  1.00 28.58           N  
ATOM    338  N   GLU A 370     -13.408  44.953  16.976  1.00 13.77           N  
ATOM    339  CA  GLU A 370     -12.625  45.080  15.743  1.00 11.76           C  
ATOM    340  C   GLU A 370     -13.603  45.181  14.579  1.00 11.56           C  
ATOM    341  O   GLU A 370     -13.748  44.256  13.799  1.00 12.30           O  
ATOM    342  CB  GLU A 370     -11.728  43.870  15.527  1.00 15.14           C  
ATOM    343  CG  GLU A 370     -10.553  43.770  16.488  1.00 19.43           C  
ATOM    344  CD  GLU A 370      -9.730  42.502  16.252  1.00 24.59           C  
ATOM    345  OE1 GLU A 370      -9.103  42.328  15.169  1.00 20.30           O  
ATOM    346  OE2 GLU A 370      -9.718  41.669  17.167  1.00 29.38           O  
ATOM    347  N   PRO A 371     -14.269  46.309  14.468  1.00 12.07           N  
ATOM    348  CA  PRO A 371     -15.274  46.476  13.420  1.00 12.12           C  
ATOM    349  C   PRO A 371     -14.616  46.475  12.057  1.00 12.11           C  
ATOM    350  O   PRO A 371     -13.428  46.794  11.915  1.00 13.07           O  
ATOM    351  CB  PRO A 371     -15.863  47.861  13.728  1.00 12.24           C  
ATOM    352  CG  PRO A 371     -14.704  48.595  14.436  1.00 15.85           C  
ATOM    353  CD  PRO A 371     -14.114  47.519  15.313  1.00 13.43           C  
ATOM    354  N   MET A 372     -15.370  46.114  11.040  1.00 12.74           N  
ATOM    355  CA  MET A 372     -14.834  46.094   9.691  1.00 11.88           C  
ATOM    356  C   MET A 372     -16.019  46.176   8.729  1.00 13.30           C  
ATOM    357  O   MET A 372     -17.125  45.781   9.080  1.00 10.86           O  
ATOM    358  CB  MET A 372     -14.031  44.821   9.469  1.00 12.49           C  
ATOM    359  CG  MET A 372     -13.313  44.698   8.149  1.00 10.67           C  
ATOM    360  SD  MET A 372     -12.314  46.117   7.662  1.00 11.99           S  
ATOM    361  CE  MET A 372     -11.086  46.151   8.964  1.00 15.92           C  
ATOM    362  N   ASP A 373     -15.762  46.646   7.515  1.00 13.37           N  
ATOM    363  CA  ASP A 373     -16.787  46.789   6.481  1.00 13.75           C  
ATOM    364  C   ASP A 373     -16.067  46.937   5.149  1.00 12.45           C  
ATOM    365  O   ASP A 373     -14.866  47.156   5.115  1.00 12.57           O  
ATOM    366  CB  ASP A 373     -17.680  47.995   6.748  1.00 12.61           C  
ATOM    367  CG  ASP A 373     -16.911  49.282   6.676  1.00 12.62           C  
ATOM    368  OD1 ASP A 373     -16.196  49.659   7.599  1.00 12.75           O  
ATOM    369  OD2 ASP A 373     -16.941  49.897   5.616  1.00 11.42           O  
ATOM    370  N   LEU A 374     -16.776  46.861   4.039  1.00 10.42           N  
ATOM    371  CA  LEU A 374     -16.078  46.871   2.764  1.00 11.21           C  
ATOM    372  C   LEU A 374     -15.497  48.246   2.355  1.00 12.78           C  
ATOM    373  O   LEU A 374     -14.579  48.310   1.523  1.00 14.13           O  
ATOM    374  CB  LEU A 374     -17.022  46.330   1.684  1.00 10.52           C  
ATOM    375  CG  LEU A 374     -17.570  44.901   1.879  1.00 14.06           C  
ATOM    376  CD1 LEU A 374     -18.624  44.541   0.839  1.00 13.62           C  
ATOM    377  CD2 LEU A 374     -16.433  43.888   1.881  1.00 13.15           C  
ATOM    378  N   SER A 375     -15.996  49.324   2.940  1.00 16.11           N  
ATOM    379  CA  SER A 375     -15.527  50.641   2.533  1.00 14.53           C  
ATOM    380  C   SER A 375     -14.200  50.832   3.266  1.00 15.44           C  
ATOM    381  O   SER A 375     -13.273  51.437   2.733  1.00 15.40           O  
ATOM    382  CB  SER A 375     -16.528  51.737   2.876  1.00 16.97           C  
ATOM    383  OG  SER A 375     -16.494  52.001   4.259  1.00 25.16           O  
ATOM    384  N   THR A 376     -14.124  50.313   4.484  1.00 10.41           N  
ATOM    385  CA  THR A 376     -12.869  50.328   5.212  1.00 13.40           C  
ATOM    386  C   THR A 376     -11.833  49.468   4.484  1.00 12.74           C  
ATOM    387  O   THR A 376     -10.672  49.835   4.368  1.00 12.68           O  
ATOM    388  CB  THR A 376     -13.066  49.808   6.645  1.00 13.03           C  
ATOM    389  OG1 THR A 376     -13.876  50.737   7.376  1.00 12.48           O  
ATOM    390  CG2 THR A 376     -11.729  49.747   7.395  1.00 15.02           C  
ATOM    391  N   MET A 377     -12.235  48.294   4.014  1.00 10.01           N  
ATOM    392  CA  MET A 377     -11.279  47.468   3.267  1.00 10.84           C  
ATOM    393  C   MET A 377     -10.790  48.164   1.998  1.00 11.99           C  
ATOM    394  O   MET A 377      -9.610  48.120   1.675  1.00 13.42           O  
ATOM    395  CB  MET A 377     -11.894  46.097   2.969  1.00 11.92           C  
ATOM    396  CG  MET A 377     -12.060  45.318   4.208  1.00 14.19           C  
ATOM    397  SD  MET A 377     -13.307  43.970   4.122  1.00  9.88           S  
ATOM    398  CE  MET A 377     -12.663  42.953   2.834  1.00 15.50           C  
ATOM    399  N   GLU A 378     -11.691  48.832   1.289  1.00 13.23           N  
ATOM    400  CA  GLU A 378     -11.308  49.597   0.100  1.00 15.30           C  
ATOM    401  C   GLU A 378     -10.298  50.709   0.456  1.00 13.63           C  
ATOM    402  O   GLU A 378      -9.316  50.929  -0.260  1.00 15.15           O  
ATOM    403  CB  GLU A 378     -12.542  50.240  -0.535  1.00 18.21           C  
ATOM    404  CG  GLU A 378     -12.229  51.111  -1.738  1.00 21.40           C  
ATOM    405  CD  GLU A 378     -13.483  51.695  -2.363  1.00 28.24           C  
ATOM    406  OE1 GLU A 378     -14.405  50.956  -2.720  1.00 21.33           O  
ATOM    407  OE2 GLU A 378     -13.569  52.941  -2.434  1.00 37.63           O  
ATOM    408  N   ILE A 379     -10.546  51.382   1.563  1.00 14.74           N  
ATOM    409  CA  ILE A 379      -9.665  52.479   1.976  1.00 15.94           C  
ATOM    410  C   ILE A 379      -8.288  51.938   2.400  1.00 16.41           C  
ATOM    411  O   ILE A 379      -7.242  52.533   2.098  1.00 14.34           O  
ATOM    412  CB  ILE A 379     -10.301  53.265   3.102  1.00 24.05           C  
ATOM    413  CG1 ILE A 379     -11.566  53.988   2.617  1.00 28.88           C  
ATOM    414  CG2 ILE A 379      -9.333  54.232   3.653  1.00 25.71           C  
ATOM    415  CD1 ILE A 379     -11.313  55.013   1.582  1.00 33.77           C  
ATOM    416  N   LYS A 380      -8.288  50.812   3.115  1.00 14.39           N  
ATOM    417  CA  LYS A 380      -7.038  50.150   3.458  1.00 14.65           C  
ATOM    418  C   LYS A 380      -6.273  49.739   2.179  1.00 17.85           C  
ATOM    419  O   LYS A 380      -5.065  49.960   2.063  1.00 17.05           O  
ATOM    420  CB  LYS A 380      -7.302  48.964   4.394  1.00 14.78           C  
ATOM    421  CG  LYS A 380      -7.657  49.443   5.823  1.00 16.18           C  
ATOM    422  CD  LYS A 380      -7.839  48.296   6.819  1.00 19.83           C  
ATOM    423  CE  LYS A 380      -6.550  47.543   7.088  1.00 19.08           C  
ATOM    424  NZ  LYS A 380      -6.667  46.557   8.210  1.00 18.32           N  
ATOM    425  N   LEU A 381      -6.973  49.174   1.204  1.00 15.58           N  
ATOM    426  CA  LEU A 381      -6.323  48.733  -0.019  1.00 15.56           C  
ATOM    427  C   LEU A 381      -5.611  49.956  -0.708  1.00 17.57           C  
ATOM    428  O   LEU A 381      -4.437  49.892  -1.076  1.00 14.66           O  
ATOM    429  CB  LEU A 381      -7.366  48.169  -0.962  1.00 15.16           C  
ATOM    430  CG  LEU A 381      -6.885  47.909  -2.380  1.00 17.63           C  
ATOM    431  CD1 LEU A 381      -5.738  46.923  -2.320  1.00 16.07           C  
ATOM    432  CD2 LEU A 381      -8.046  47.376  -3.205  1.00 22.14           C  
ATOM    433  N   GLU A 382      -6.367  51.037  -0.853  1.00 12.51           N  
ATOM    434  CA  GLU A 382      -5.895  52.253  -1.515  1.00 18.10           C  
ATOM    435  C   GLU A 382      -4.778  52.946  -0.750  1.00 18.28           C  
ATOM    436  O   GLU A 382      -3.953  53.639  -1.353  1.00 17.56           O  
ATOM    437  CB  GLU A 382      -7.065  53.200  -1.753  1.00 19.54           C  
ATOM    438  CG  GLU A 382      -8.014  52.673  -2.820  1.00 27.70           C  
ATOM    439  CD  GLU A 382      -9.241  53.545  -3.028  1.00 36.28           C  
ATOM    440  OE1 GLU A 382      -9.342  54.622  -2.389  1.00 42.35           O  
ATOM    441  OE2 GLU A 382     -10.112  53.142  -3.840  1.00 36.01           O  
ATOM    442  N   SER A 383      -4.757  52.741   0.566  1.00 16.56           N  
ATOM    443  CA  SER A 383      -3.760  53.335   1.477  1.00 18.55           C  
ATOM    444  C   SER A 383      -2.548  52.419   1.689  1.00 16.73           C  
ATOM    445  O   SER A 383      -1.780  52.621   2.614  1.00 15.16           O  
ATOM    446  CB  SER A 383      -4.416  53.651   2.838  1.00 18.94           C  
ATOM    447  OG  SER A 383      -5.456  54.606   2.671  1.00 22.49           O  
ATOM    448  N   ASN A 384      -2.415  51.389   0.850  1.00 15.91           N  
ATOM    449  CA  ASN A 384      -1.280  50.460   0.886  1.00 18.51           C  
ATOM    450  C   ASN A 384      -1.160  49.622   2.147  1.00 19.29           C  
ATOM    451  O   ASN A 384      -0.044  49.281   2.538  1.00 17.58           O  
ATOM    452  CB  ASN A 384       0.040  51.216   0.704  1.00 19.14           C  
ATOM    453  CG  ASN A 384       1.052  50.444  -0.139  1.00 21.75           C  
ATOM    454  OD1 ASN A 384       0.744  50.006  -1.263  1.00 20.60           O  
ATOM    455  ND2 ASN A 384       2.272  50.295   0.390  1.00 21.13           N  
ATOM    456  N   LYS A 385      -2.293  49.286   2.764  1.00 18.29           N  
ATOM    457  CA  LYS A 385      -2.310  48.518   4.008  1.00 17.13           C  
ATOM    458  C   LYS A 385      -2.341  46.989   3.809  1.00 21.72           C  
ATOM    459  O   LYS A 385      -2.193  46.253   4.770  1.00 18.43           O  
ATOM    460  CB  LYS A 385      -3.499  48.949   4.880  1.00 20.66           C  
ATOM    461  CG  LYS A 385      -3.600  50.457   5.131  1.00 22.07           C  
ATOM    462  CD  LYS A 385      -2.583  50.951   6.146  1.00 25.96           C  
ATOM    463  CE  LYS A 385      -2.839  52.411   6.535  1.00 25.93           C  
ATOM    464  NZ  LYS A 385      -3.730  52.560   7.705  1.00 27.98           N  
ATOM    465  N   TYR A 386      -2.520  46.534   2.577  1.00 21.39           N  
ATOM    466  CA  TYR A 386      -2.602  45.097   2.302  1.00 20.79           C  
ATOM    467  C   TYR A 386      -1.392  44.548   1.559  1.00 24.44           C  
ATOM    468  O   TYR A 386      -1.497  44.104   0.426  1.00 26.69           O  
ATOM    469  CB  TYR A 386      -3.872  44.755   1.529  1.00 19.84           C  
ATOM    470  CG  TYR A 386      -5.148  44.966   2.320  1.00 13.70           C  
ATOM    471  CD1 TYR A 386      -5.229  44.632   3.673  1.00 14.07           C  
ATOM    472  CD2 TYR A 386      -6.271  45.469   1.714  1.00 14.78           C  
ATOM    473  CE1 TYR A 386      -6.401  44.807   4.371  1.00 14.99           C  
ATOM    474  CE2 TYR A 386      -7.435  45.669   2.401  1.00 13.70           C  
ATOM    475  CZ  TYR A 386      -7.508  45.338   3.738  1.00 16.66           C  
ATOM    476  OH  TYR A 386      -8.691  45.546   4.438  1.00 17.32           O  
ATOM    477  N   GLN A 387      -0.269  44.560   2.250  1.00 28.28           N  
ATOM    478  CA  GLN A 387       1.009  43.983   1.779  1.00 31.35           C  
ATOM    479  C   GLN A 387       0.976  42.474   1.743  1.00 27.78           C  
ATOM    480  O   GLN A 387       1.666  41.849   0.927  1.00 23.59           O  
ATOM    481  CB  GLN A 387       2.108  44.328   2.771  1.00 35.57           C  
ATOM    482  CG  GLN A 387       1.810  43.723   4.140  1.00 40.83           C  
ATOM    483  CD  GLN A 387       2.405  44.492   5.263  1.00 45.67           C  
ATOM    484  OE1 GLN A 387       2.718  45.676   5.107  1.00 51.51           O  
ATOM    485  NE2 GLN A 387       2.563  43.847   6.410  1.00 50.43           N  
ATOM    486  N   LYS A 388       0.271  41.905   2.716  1.00 24.51           N  
ATOM    487  CA  LYS A 388       0.090  40.471   2.832  1.00 25.55           C  
ATOM    488  C   LYS A 388      -1.366  40.147   2.543  1.00 20.75           C  
ATOM    489  O   LYS A 388      -2.255  40.753   3.117  1.00 21.07           O  
ATOM    490  CB  LYS A 388       0.439  40.009   4.256  1.00 31.55           C  
ATOM    491  CG  LYS A 388       1.887  40.208   4.638  1.00 39.96           C  
ATOM    492  CD  LYS A 388       2.236  39.499   5.947  1.00 46.44           C  
ATOM    493  CE  LYS A 388       3.710  39.723   6.307  1.00 51.57           C  
ATOM    494  NZ  LYS A 388       4.103  39.047   7.589  1.00 54.00           N  
ATOM    495  N   MET A 389      -1.612  39.191   1.666  1.00 20.84           N  
ATOM    496  CA  MET A 389      -2.970  38.775   1.376  1.00 21.77           C  
ATOM    497  C   MET A 389      -3.667  38.406   2.691  1.00 20.30           C  
ATOM    498  O   MET A 389      -4.851  38.633   2.848  1.00 16.97           O  
ATOM    499  CB  MET A 389      -3.006  37.590   0.408  1.00 21.64           C  
ATOM    500  CG  MET A 389      -4.434  37.143   0.008  1.00 25.76           C  
ATOM    501  SD  MET A 389      -5.382  38.459  -0.658  1.00 26.97           S  
ATOM    502  CE  MET A 389      -6.649  37.810  -1.435  1.00 31.59           C  
ATOM    503  N   GLU A 390      -2.929  37.791   3.610  1.00 19.71           N  
ATOM    504  CA  GLU A 390      -3.460  37.401   4.923  1.00 17.34           C  
ATOM    505  C   GLU A 390      -4.203  38.520   5.663  1.00 16.56           C  
ATOM    506  O   GLU A 390      -5.178  38.264   6.357  1.00 13.37           O  
ATOM    507  CB  GLU A 390      -2.316  36.926   5.831  1.00 18.37           C  
ATOM    508  CG  GLU A 390      -1.797  35.538   5.521  1.00 21.81           C  
ATOM    509  CD  GLU A 390      -0.687  35.512   4.470  1.00 24.87           C  
ATOM    510  OE1 GLU A 390      -0.505  36.492   3.698  1.00 20.92           O  
ATOM    511  OE2 GLU A 390      -0.013  34.476   4.410  1.00 21.97           O  
ATOM    512  N   ASP A 391      -3.717  39.754   5.547  1.00 15.47           N  
ATOM    513  CA  ASP A 391      -4.374  40.887   6.191  1.00 15.84           C  
ATOM    514  C   ASP A 391      -5.746  41.195   5.592  1.00 12.94           C  
ATOM    515  O   ASP A 391      -6.661  41.547   6.311  1.00 11.19           O  
ATOM    516  CB  ASP A 391      -3.475  42.107   6.199  1.00 17.77           C  
ATOM    517  CG  ASP A 391      -2.303  41.923   7.119  1.00 23.62           C  
ATOM    518  OD1 ASP A 391      -2.444  41.197   8.117  1.00 27.53           O  
ATOM    519  OD2 ASP A 391      -1.217  42.447   6.925  1.00 26.00           O  
ATOM    520  N   PHE A 392      -5.877  41.018   4.284  1.00 12.08           N  
ATOM    521  CA  PHE A 392      -7.137  41.258   3.595  1.00 12.12           C  
ATOM    522  C   PHE A 392      -8.133  40.175   3.972  1.00 11.43           C  
ATOM    523  O   PHE A 392      -9.290  40.450   4.242  1.00 11.02           O  
ATOM    524  CB  PHE A 392      -6.910  41.221   2.093  1.00 11.53           C  
ATOM    525  CG  PHE A 392      -8.159  41.338   1.281  1.00 11.43           C  
ATOM    526  CD1 PHE A 392      -8.906  42.489   1.302  1.00 11.93           C  
ATOM    527  CD2 PHE A 392      -8.566  40.304   0.465  1.00 13.40           C  
ATOM    528  CE1 PHE A 392     -10.038  42.613   0.513  1.00 12.67           C  
ATOM    529  CE2 PHE A 392      -9.705  40.432  -0.314  1.00 13.34           C  
ATOM    530  CZ  PHE A 392     -10.435  41.589  -0.275  1.00 12.30           C  
ATOM    531  N   ILE A 393      -7.647  38.938   4.012  1.00 14.08           N  
ATOM    532  CA  ILE A 393      -8.511  37.819   4.364  1.00 11.35           C  
ATOM    533  C   ILE A 393      -8.991  37.989   5.808  1.00 13.81           C  
ATOM    534  O   ILE A 393     -10.162  37.716   6.144  1.00 11.93           O  
ATOM    535  CB  ILE A 393      -7.772  36.490   4.159  1.00 13.21           C  
ATOM    536  CG1 ILE A 393      -7.668  36.185   2.659  1.00 14.32           C  
ATOM    537  CG2 ILE A 393      -8.489  35.359   4.901  1.00 11.14           C  
ATOM    538  CD1 ILE A 393      -6.738  35.070   2.367  1.00 18.32           C  
ATOM    539  N   TYR A 394      -8.082  38.415   6.672  1.00 11.26           N  
ATOM    540  CA  TYR A 394      -8.450  38.666   8.076  1.00 11.19           C  
ATOM    541  C   TYR A 394      -9.588  39.671   8.169  1.00 10.30           C  
ATOM    542  O   TYR A 394     -10.529  39.498   8.931  1.00 11.50           O  
ATOM    543  CB  TYR A 394      -7.275  39.225   8.846  1.00 11.77           C  
ATOM    544  CG  TYR A 394      -7.540  39.401  10.329  1.00 13.57           C  
ATOM    545  CD1 TYR A 394      -7.354  38.364  11.200  1.00 12.71           C  
ATOM    546  CD2 TYR A 394      -8.004  40.605  10.842  1.00 11.52           C  
ATOM    547  CE1 TYR A 394      -7.578  38.519  12.557  1.00 12.92           C  
ATOM    548  CE2 TYR A 394      -8.261  40.763  12.214  1.00 14.08           C  
ATOM    549  CZ  TYR A 394      -8.031  39.705  13.064  1.00 13.78           C  
ATOM    550  OH  TYR A 394      -8.249  39.799  14.425  1.00 12.55           O  
ATOM    551  N   ASP A 395      -9.485  40.744   7.400  1.00 12.08           N  
ATOM    552  CA  ASP A 395     -10.482  41.802   7.460  1.00 11.10           C  
ATOM    553  C   ASP A 395     -11.817  41.305   6.911  1.00 10.24           C  
ATOM    554  O   ASP A 395     -12.855  41.617   7.473  1.00  8.21           O  
ATOM    555  CB  ASP A 395      -9.991  43.029   6.706  1.00 12.71           C  
ATOM    556  CG  ASP A 395      -8.999  43.851   7.499  1.00 13.20           C  
ATOM    557  OD1 ASP A 395      -8.737  43.521   8.687  1.00 11.62           O  
ATOM    558  OD2 ASP A 395      -8.468  44.872   6.996  1.00 13.11           O  
ATOM    559  N   ALA A 396     -11.789  40.576   5.801  1.00 10.46           N  
ATOM    560  CA  ALA A 396     -13.013  39.962   5.247  1.00 11.29           C  
ATOM    561  C   ALA A 396     -13.670  39.078   6.313  1.00 13.65           C  
ATOM    562  O   ALA A 396     -14.889  39.074   6.493  1.00 10.22           O  
ATOM    563  CB  ALA A 396     -12.701  39.170   4.024  1.00 12.05           C  
ATOM    564  N   ARG A 397     -12.855  38.302   7.015  1.00  9.05           N  
ATOM    565  CA  ARG A 397     -13.409  37.454   8.071  1.00 11.06           C  
ATOM    566  C   ARG A 397     -14.006  38.226   9.265  1.00 10.07           C  
ATOM    567  O   ARG A 397     -14.901  37.716   9.938  1.00 11.89           O  
ATOM    568  CB  ARG A 397     -12.396  36.397   8.501  1.00 11.38           C  
ATOM    569  CG  ARG A 397     -12.275  35.296   7.438  1.00 12.18           C  
ATOM    570  CD  ARG A 397     -11.076  34.379   7.630  1.00 13.25           C  
ATOM    571  NE  ARG A 397     -11.059  33.274   6.687  1.00 13.82           N  
ATOM    572  CZ  ARG A 397      -9.993  32.500   6.483  1.00 17.58           C  
ATOM    573  NH1 ARG A 397      -8.877  32.725   7.155  1.00 16.65           N  
ATOM    574  NH2 ARG A 397     -10.035  31.511   5.599  1.00 16.07           N  
ATOM    575  N   LEU A 398     -13.530  39.444   9.525  1.00 11.13           N  
ATOM    576  CA  LEU A 398     -14.114  40.264  10.591  1.00  8.87           C  
ATOM    577  C   LEU A 398     -15.524  40.625  10.169  1.00 12.50           C  
ATOM    578  O   LEU A 398     -16.415  40.619  10.944  1.00  9.26           O  
ATOM    579  CB  LEU A 398     -13.329  41.560  10.813  1.00 10.49           C  
ATOM    580  CG  LEU A 398     -12.015  41.510  11.592  1.00 10.43           C  
ATOM    581  CD1 LEU A 398     -11.358  42.907  11.531  1.00 12.23           C  
ATOM    582  CD2 LEU A 398     -12.223  41.032  13.017  1.00 11.66           C  
ATOM    583  N   VAL A 399     -15.688  40.986   8.910  1.00 10.43           N  
ATOM    584  CA  VAL A 399     -17.010  41.347   8.412  1.00 10.69           C  
ATOM    585  C   VAL A 399     -17.976  40.180   8.627  1.00 10.81           C  
ATOM    586  O   VAL A 399     -19.054  40.363   9.162  1.00 11.26           O  
ATOM    587  CB  VAL A 399     -17.002  41.686   6.899  1.00 10.80           C  
ATOM    588  CG1 VAL A 399     -18.440  41.979   6.379  1.00 11.74           C  
ATOM    589  CG2 VAL A 399     -16.082  42.869   6.600  1.00 13.04           C  
ATOM    590  N   PHE A 400     -17.569  38.972   8.265  1.00  8.38           N  
ATOM    591  CA  PHE A 400     -18.497  37.830   8.310  1.00 11.35           C  
ATOM    592  C   PHE A 400     -18.711  37.403   9.762  1.00 11.76           C  
ATOM    593  O   PHE A 400     -19.832  37.174  10.210  1.00 13.29           O  
ATOM    594  CB  PHE A 400     -17.954  36.610   7.553  1.00 11.08           C  
ATOM    595  CG  PHE A 400     -17.382  36.912   6.194  1.00 14.38           C  
ATOM    596  CD1 PHE A 400     -18.049  37.729   5.300  1.00 10.78           C  
ATOM    597  CD2 PHE A 400     -16.201  36.300   5.788  1.00 12.38           C  
ATOM    598  CE1 PHE A 400     -17.512  37.994   4.033  1.00 12.07           C  
ATOM    599  CE2 PHE A 400     -15.684  36.540   4.538  1.00 13.33           C  
ATOM    600  CZ  PHE A 400     -16.334  37.391   3.662  1.00 16.70           C  
ATOM    601  N   ASN A 401     -17.604  37.291  10.497  1.00 11.64           N  
ATOM    602  CA  ASN A 401     -17.642  36.813  11.883  1.00 12.23           C  
ATOM    603  C   ASN A 401     -18.235  37.794  12.888  1.00 14.32           C  
ATOM    604  O   ASN A 401     -18.971  37.393  13.827  1.00 10.00           O  
ATOM    605  CB  ASN A 401     -16.249  36.335  12.291  1.00 10.16           C  
ATOM    606  CG  ASN A 401     -15.901  35.047  11.606  1.00 14.13           C  
ATOM    607  OD1 ASN A 401     -16.459  34.000  11.937  1.00 13.85           O  
ATOM    608  ND2 ASN A 401     -15.025  35.113  10.610  1.00 12.51           N  
ATOM    609  N   ASN A 402     -17.914  39.083  12.717  1.00 11.84           N  
ATOM    610  CA  ASN A 402     -18.530  40.093  13.560  1.00 11.69           C  
ATOM    611  C   ASN A 402     -20.052  40.003  13.405  1.00 12.34           C  
ATOM    612  O   ASN A 402     -20.813  40.122  14.387  1.00 11.00           O  
ATOM    613  CB  ASN A 402     -18.084  41.511  13.157  1.00 11.84           C  
ATOM    614  CG  ASN A 402     -16.731  41.868  13.687  1.00 11.75           C  
ATOM    615  OD1 ASN A 402     -16.229  41.227  14.644  1.00  9.15           O  
ATOM    616  ND2 ASN A 402     -16.116  42.903  13.090  1.00  7.67           N  
ATOM    617  N   CYS A 403     -20.484  39.813  12.155  1.00 12.45           N  
ATOM    618  CA  CYS A 403     -21.909  39.787  11.829  1.00  9.51           C  
ATOM    619  C   CYS A 403     -22.603  38.620  12.527  1.00 12.45           C  
ATOM    620  O   CYS A 403     -23.666  38.785  13.093  1.00 12.02           O  
ATOM    621  CB  CYS A 403     -22.127  39.648  10.334  1.00  9.26           C  
ATOM    622  SG  CYS A 403     -23.896  39.794   9.860  1.00 10.31           S  
ATOM    623  N   ARG A 404     -21.982  37.451  12.489  1.00 10.76           N  
ATOM    624  CA  ARG A 404     -22.579  36.270  13.111  1.00 11.73           C  
ATOM    625  C   ARG A 404     -22.426  36.325  14.632  1.00 13.38           C  
ATOM    626  O   ARG A 404     -23.152  35.652  15.350  1.00 15.94           O  
ATOM    627  CB  ARG A 404     -21.993  34.992  12.543  1.00 11.22           C  
ATOM    628  CG  ARG A 404     -22.343  34.738  11.098  1.00 13.00           C  
ATOM    629  CD  ARG A 404     -21.946  33.378  10.610  1.00 15.33           C  
ATOM    630  NE  ARG A 404     -20.494  33.273  10.604  1.00 15.49           N  
ATOM    631  CZ  ARG A 404     -19.739  33.334   9.510  1.00 15.34           C  
ATOM    632  NH1 ARG A 404     -20.275  33.425   8.310  1.00 16.54           N  
ATOM    633  NH2 ARG A 404     -18.423  33.275   9.609  1.00 18.34           N  
ATOM    634  N   MET A 405     -21.488  37.124  15.122  1.00 12.66           N  
ATOM    635  CA  MET A 405     -21.339  37.288  16.548  1.00 13.30           C  
ATOM    636  C   MET A 405     -22.466  38.195  17.105  1.00 14.75           C  
ATOM    637  O   MET A 405     -23.033  37.912  18.161  1.00 13.18           O  
ATOM    638  CB  MET A 405     -19.969  37.878  16.886  1.00 14.38           C  
ATOM    639  CG  MET A 405     -19.755  38.176  18.381  1.00 15.13           C  
ATOM    640  SD  MET A 405     -18.173  39.038  18.657  1.00 11.96           S  
ATOM    641  CE  MET A 405     -18.280  39.393  20.359  1.00 19.19           C  
ATOM    642  N   TYR A 406     -22.773  39.285  16.408  1.00 12.48           N  
ATOM    643  CA  TYR A 406     -23.760  40.246  16.915  1.00 13.66           C  
ATOM    644  C   TYR A 406     -25.213  39.858  16.685  1.00 13.97           C  
ATOM    645  O   TYR A 406     -26.057  40.058  17.544  1.00 13.54           O  
ATOM    646  CB  TYR A 406     -23.506  41.624  16.309  1.00 13.15           C  
ATOM    647  CG  TYR A 406     -24.432  42.690  16.856  1.00 15.03           C  
ATOM    648  CD1 TYR A 406     -24.140  43.349  18.035  1.00 16.57           C  
ATOM    649  CD2 TYR A 406     -25.585  43.054  16.170  1.00 13.60           C  
ATOM    650  CE1 TYR A 406     -24.965  44.334  18.526  1.00 17.32           C  
ATOM    651  CE2 TYR A 406     -26.434  44.036  16.666  1.00 16.11           C  
ATOM    652  CZ  TYR A 406     -26.118  44.666  17.839  1.00 16.25           C  
ATOM    653  OH  TYR A 406     -26.957  45.631  18.314  1.00 19.32           O  
ATOM    654  N   ASN A 407     -25.487  39.313  15.499  1.00 15.83           N  
ATOM    655  CA  ASN A 407     -26.837  38.994  15.055  1.00 15.63           C  
ATOM    656  C   ASN A 407     -27.263  37.553  15.318  1.00 14.98           C  
ATOM    657  O   ASN A 407     -26.436  36.638  15.306  1.00 15.89           O  
ATOM    658  CB  ASN A 407     -26.926  39.248  13.563  1.00 11.28           C  
ATOM    659  CG  ASN A 407     -26.677  40.693  13.218  1.00 14.14           C  
ATOM    660  OD1 ASN A 407     -27.548  41.535  13.391  1.00 15.53           O  
ATOM    661  ND2 ASN A 407     -25.482  40.988  12.751  1.00 10.42           N  
ATOM    662  N   GLY A 408     -28.559  37.361  15.517  1.00 15.44           N  
ATOM    663  CA  GLY A 408     -29.117  36.038  15.775  1.00 16.04           C  
ATOM    664  C   GLY A 408     -28.997  35.135  14.573  1.00 17.52           C  
ATOM    665  O   GLY A 408     -29.046  35.613  13.435  1.00 14.93           O  
ATOM    666  N   GLU A 409     -28.866  33.825  14.808  1.00 17.55           N  
ATOM    667  CA  GLU A 409     -28.689  32.869  13.717  1.00 20.98           C  
ATOM    668  C   GLU A 409     -29.891  32.822  12.761  1.00 18.93           C  
ATOM    669  O   GLU A 409     -29.751  32.364  11.629  1.00 18.67           O  
ATOM    670  CB  GLU A 409     -28.373  31.462  14.256  1.00 26.43           C  
ATOM    671  CG  GLU A 409     -29.416  30.915  15.208  1.00 31.51           C  
ATOM    672  CD  GLU A 409     -29.042  29.563  15.819  1.00 39.16           C  
ATOM    673  OE1 GLU A 409     -28.015  28.972  15.410  1.00 38.40           O  
ATOM    674  OE2 GLU A 409     -29.793  29.101  16.720  1.00 43.19           O  
ATOM    675  N   ASN A 410     -31.047  33.318  13.212  1.00 17.62           N  
ATOM    676  CA  ASN A 410     -32.272  33.325  12.403  1.00 22.24           C  
ATOM    677  C   ASN A 410     -32.525  34.631  11.634  1.00 20.78           C  
ATOM    678  O   ASN A 410     -33.533  34.762  10.932  1.00 18.43           O  
ATOM    679  CB  ASN A 410     -33.480  33.018  13.299  1.00 24.79           C  
ATOM    680  CG  ASN A 410     -33.425  31.608  13.873  1.00 32.51           C  
ATOM    681  OD1 ASN A 410     -33.142  30.649  13.153  1.00 32.36           O  
ATOM    682  ND2 ASN A 410     -33.658  31.483  15.182  1.00 34.51           N  
ATOM    683  N   THR A 411     -31.608  35.589  11.745  1.00 16.93           N  
ATOM    684  CA  THR A 411     -31.798  36.885  11.101  1.00 15.89           C  
ATOM    685  C   THR A 411     -31.312  36.903   9.661  1.00 16.73           C  
ATOM    686  O   THR A 411     -30.481  36.091   9.260  1.00 15.53           O  
ATOM    687  CB  THR A 411     -31.033  37.994  11.864  1.00 17.59           C  
ATOM    688  OG1 THR A 411     -29.617  37.707  11.850  1.00 15.21           O  
ATOM    689  CG2 THR A 411     -31.428  38.036  13.358  1.00 15.40           C  
ATOM    690  N   SER A 412     -31.803  37.867   8.889  1.00 12.12           N  
ATOM    691  CA  SER A 412     -31.324  38.037   7.518  1.00 16.25           C  
ATOM    692  C   SER A 412     -29.798  38.316   7.475  1.00 11.35           C  
ATOM    693  O   SER A 412     -29.108  37.846   6.574  1.00 12.34           O  
ATOM    694  CB  SER A 412     -32.059  39.197   6.864  1.00 19.26           C  
ATOM    695  OG  SER A 412     -33.431  38.864   6.725  1.00 21.68           O  
ATOM    696  N   TYR A 413     -29.307  39.095   8.435  1.00 12.35           N  
ATOM    697  CA  TYR A 413     -27.881  39.473   8.474  1.00 12.44           C  
ATOM    698  C   TYR A 413     -26.981  38.262   8.562  1.00 13.45           C  
ATOM    699  O   TYR A 413     -25.945  38.168   7.875  1.00 11.93           O  
ATOM    700  CB  TYR A 413     -27.610  40.456   9.616  1.00 14.51           C  
ATOM    701  CG  TYR A 413     -28.431  41.713   9.478  1.00 15.92           C  
ATOM    702  CD1 TYR A 413     -28.180  42.611   8.444  1.00 17.85           C  
ATOM    703  CD2 TYR A 413     -29.500  41.984  10.336  1.00 15.20           C  
ATOM    704  CE1 TYR A 413     -28.929  43.749   8.284  1.00 16.85           C  
ATOM    705  CE2 TYR A 413     -30.267  43.139  10.175  1.00 17.53           C  
ATOM    706  CZ  TYR A 413     -29.966  44.015   9.149  1.00 20.46           C  
ATOM    707  OH  TYR A 413     -30.704  45.156   8.951  1.00 23.82           O  
ATOM    708  N   TYR A 414     -27.390  37.307   9.388  1.00 14.56           N  
ATOM    709  CA  TYR A 414     -26.629  36.071   9.543  1.00 16.47           C  
ATOM    710  C   TYR A 414     -26.605  35.335   8.193  1.00 14.85           C  
ATOM    711  O   TYR A 414     -25.571  34.873   7.747  1.00 13.01           O  
ATOM    712  CB  TYR A 414     -27.261  35.216  10.656  1.00 16.38           C  
ATOM    713  CG  TYR A 414     -26.351  34.228  11.357  1.00 16.07           C  
ATOM    714  CD1 TYR A 414     -26.100  32.985  10.809  1.00 16.54           C  
ATOM    715  CD2 TYR A 414     -25.780  34.526  12.601  1.00 16.18           C  
ATOM    716  CE1 TYR A 414     -25.302  32.072  11.457  1.00 19.06           C  
ATOM    717  CE2 TYR A 414     -24.981  33.615  13.255  1.00 16.49           C  
ATOM    718  CZ  TYR A 414     -24.751  32.392  12.689  1.00 20.44           C  
ATOM    719  OH  TYR A 414     -23.970  31.470  13.362  1.00 23.15           O  
ATOM    720  N   LYS A 415     -27.757  35.256   7.529  1.00 13.69           N  
ATOM    721  CA  LYS A 415     -27.849  34.648   6.216  1.00 17.43           C  
ATOM    722  C   LYS A 415     -26.941  35.363   5.205  1.00 14.79           C  
ATOM    723  O   LYS A 415     -26.237  34.724   4.453  1.00 14.71           O  
ATOM    724  CB  LYS A 415     -29.292  34.704   5.719  1.00 20.28           C  
ATOM    725  CG  LYS A 415     -29.665  33.664   4.704  1.00 27.82           C  
ATOM    726  CD  LYS A 415     -31.192  33.624   4.532  1.00 31.71           C  
ATOM    727  CE  LYS A 415     -31.624  32.588   3.470  1.00 36.39           C  
ATOM    728  NZ  LYS A 415     -33.131  32.483   3.318  1.00 40.05           N  
ATOM    729  N   TYR A 416     -26.979  36.691   5.168  1.00 11.55           N  
ATOM    730  CA  TYR A 416     -26.124  37.421   4.227  1.00 10.09           C  
ATOM    731  C   TYR A 416     -24.658  37.098   4.529  1.00 12.36           C  
ATOM    732  O   TYR A 416     -23.893  36.815   3.607  1.00 10.91           O  
ATOM    733  CB  TYR A 416     -26.330  38.938   4.317  1.00 10.01           C  
ATOM    734  CG  TYR A 416     -27.671  39.450   3.798  1.00 10.23           C  
ATOM    735  CD1 TYR A 416     -28.030  39.270   2.477  1.00 13.88           C  
ATOM    736  CD2 TYR A 416     -28.538  40.153   4.614  1.00  9.71           C  
ATOM    737  CE1 TYR A 416     -29.212  39.726   1.985  1.00 11.80           C  
ATOM    738  CE2 TYR A 416     -29.738  40.637   4.121  1.00 10.95           C  
ATOM    739  CZ  TYR A 416     -30.075  40.423   2.807  1.00 14.57           C  
ATOM    740  OH  TYR A 416     -31.284  40.868   2.310  1.00 13.70           O  
ATOM    741  N   ALA A 417     -24.258  37.149   5.797  1.00 10.50           N  
ATOM    742  CA  ALA A 417     -22.858  36.825   6.140  1.00 13.00           C  
ATOM    743  C   ALA A 417     -22.434  35.458   5.583  1.00 13.40           C  
ATOM    744  O   ALA A 417     -21.368  35.308   4.964  1.00  9.98           O  
ATOM    745  CB  ALA A 417     -22.633  36.868   7.647  1.00 14.70           C  
ATOM    746  N   ASN A 418     -23.288  34.460   5.771  1.00 12.24           N  
ATOM    747  CA  ASN A 418     -22.940  33.118   5.320  1.00 13.25           C  
ATOM    748  C   ASN A 418     -22.782  33.090   3.803  1.00 12.10           C  
ATOM    749  O   ASN A 418     -21.810  32.544   3.269  1.00 15.51           O  
ATOM    750  CB  ASN A 418     -23.963  32.087   5.810  1.00 15.06           C  
ATOM    751  CG  ASN A 418     -23.749  31.695   7.252  1.00 16.58           C  
ATOM    752  OD1 ASN A 418     -22.672  31.897   7.794  1.00 16.61           O  
ATOM    753  ND2 ASN A 418     -24.778  31.137   7.885  1.00 18.84           N  
ATOM    754  N   ARG A 419     -23.726  33.714   3.100  1.00 14.03           N  
ATOM    755  CA  ARG A 419     -23.688  33.753   1.658  1.00 13.06           C  
ATOM    756  C   ARG A 419     -22.453  34.490   1.134  1.00 14.83           C  
ATOM    757  O   ARG A 419     -21.789  34.003   0.215  1.00 12.70           O  
ATOM    758  CB  ARG A 419     -24.968  34.402   1.097  1.00 15.93           C  
ATOM    759  CG  ARG A 419     -25.062  34.364  -0.380  1.00 21.49           C  
ATOM    760  CD  ARG A 419     -24.782  32.983  -0.978  1.00 28.52           C  
ATOM    761  NE  ARG A 419     -25.933  32.093  -0.934  1.00 32.64           N  
ATOM    762  CZ  ARG A 419     -25.902  30.826  -1.315  1.00 32.04           C  
ATOM    763  NH1 ARG A 419     -24.778  30.302  -1.773  1.00 28.67           N  
ATOM    764  NH2 ARG A 419     -27.000  30.095  -1.257  1.00 33.35           N  
ATOM    765  N   LEU A 420     -22.169  35.669   1.690  1.00 13.08           N  
ATOM    766  CA  LEU A 420     -21.025  36.437   1.233  1.00 14.01           C  
ATOM    767  C   LEU A 420     -19.715  35.694   1.542  1.00 14.22           C  
ATOM    768  O   LEU A 420     -18.768  35.722   0.748  1.00 11.25           O  
ATOM    769  CB  LEU A 420     -20.991  37.828   1.881  1.00 12.00           C  
ATOM    770  CG  LEU A 420     -20.077  38.829   1.158  1.00 13.20           C  
ATOM    771  CD1 LEU A 420     -20.490  38.964  -0.308  1.00 11.59           C  
ATOM    772  CD2 LEU A 420     -20.136  40.155   1.855  1.00 14.51           C  
ATOM    773  N   GLU A 421     -19.677  35.003   2.667  1.00 11.21           N  
ATOM    774  CA  GLU A 421     -18.457  34.251   2.980  1.00 15.26           C  
ATOM    775  C   GLU A 421     -18.215  33.084   2.001  1.00 14.59           C  
ATOM    776  O   GLU A 421     -17.085  32.850   1.547  1.00 11.82           O  
ATOM    777  CB  GLU A 421     -18.447  33.736   4.406  1.00 14.45           C  
ATOM    778  CG  GLU A 421     -17.100  33.112   4.742  1.00 13.81           C  
ATOM    779  CD  GLU A 421     -16.815  32.943   6.239  1.00 14.93           C  
ATOM    780  OE1 GLU A 421     -17.720  33.063   7.065  1.00 13.53           O  
ATOM    781  OE2 GLU A 421     -15.635  32.700   6.596  1.00 15.85           O  
ATOM    782  N   LYS A 422     -19.271  32.332   1.712  1.00 15.37           N  
ATOM    783  CA  LYS A 422     -19.164  31.224   0.773  1.00 15.16           C  
ATOM    784  C   LYS A 422     -18.616  31.784  -0.538  1.00 13.33           C  
ATOM    785  O   LYS A 422     -17.728  31.223  -1.143  1.00 14.69           O  
ATOM    786  CB  LYS A 422     -20.532  30.550   0.566  1.00 17.34           C  
ATOM    787  CG  LYS A 422     -20.510  29.336  -0.418  1.00 19.86           C  
ATOM    788  CD  LYS A 422     -21.787  28.452  -0.370  1.00 21.28           C  
ATOM    789  CE  LYS A 422     -21.648  27.242  -1.349  1.00 25.48           C  
ATOM    790  NZ  LYS A 422     -22.858  26.345  -1.439  1.00 26.98           N  
ATOM    791  N   PHE A 423     -19.161  32.906  -0.983  1.00 13.64           N  
ATOM    792  CA  PHE A 423     -18.716  33.512  -2.226  1.00 11.36           C  
ATOM    793  C   PHE A 423     -17.240  33.902  -2.162  1.00 13.87           C  
ATOM    794  O   PHE A 423     -16.446  33.589  -3.069  1.00 13.44           O  
ATOM    795  CB  PHE A 423     -19.592  34.709  -2.551  1.00 14.30           C  
ATOM    796  CG  PHE A 423     -19.118  35.501  -3.709  1.00 13.19           C  
ATOM    797  CD1 PHE A 423     -19.263  35.035  -5.007  1.00 15.72           C  
ATOM    798  CD2 PHE A 423     -18.487  36.722  -3.491  1.00 17.28           C  
ATOM    799  CE1 PHE A 423     -18.807  35.779  -6.071  1.00 15.80           C  
ATOM    800  CE2 PHE A 423     -18.043  37.474  -4.538  1.00 17.26           C  
ATOM    801  CZ  PHE A 423     -18.195  37.006  -5.841  1.00 19.13           C  
ATOM    802  N   PHE A 424     -16.886  34.586  -1.079  1.00 14.32           N  
ATOM    803  CA  PHE A 424     -15.520  35.013  -0.832  1.00 13.82           C  
ATOM    804  C   PHE A 424     -14.561  33.810  -0.864  1.00 14.44           C  
ATOM    805  O   PHE A 424     -13.539  33.854  -1.527  1.00 12.77           O  
ATOM    806  CB  PHE A 424     -15.425  35.687   0.532  1.00 11.67           C  
ATOM    807  CG  PHE A 424     -14.030  36.129   0.886  1.00 12.49           C  
ATOM    808  CD1 PHE A 424     -13.472  37.254   0.300  1.00 15.19           C  
ATOM    809  CD2 PHE A 424     -13.270  35.403   1.784  1.00 14.74           C  
ATOM    810  CE1 PHE A 424     -12.210  37.654   0.616  1.00 13.39           C  
ATOM    811  CE2 PHE A 424     -11.998  35.809   2.096  1.00 10.87           C  
ATOM    812  CZ  PHE A 424     -11.474  36.921   1.526  1.00  9.81           C  
ATOM    813  N   ASN A 425     -14.902  32.750  -0.141  1.00 14.03           N  
ATOM    814  CA  ASN A 425     -14.033  31.575  -0.089  1.00 16.36           C  
ATOM    815  C   ASN A 425     -13.763  31.015  -1.489  1.00 18.28           C  
ATOM    816  O   ASN A 425     -12.624  30.687  -1.825  1.00 17.16           O  
ATOM    817  CB  ASN A 425     -14.616  30.506   0.804  1.00 16.01           C  
ATOM    818  CG  ASN A 425     -14.477  30.841   2.273  1.00 17.84           C  
ATOM    819  OD1 ASN A 425     -13.650  31.660   2.655  1.00 13.50           O  
ATOM    820  ND2 ASN A 425     -15.282  30.194   3.105  1.00 18.10           N  
ATOM    821  N   ASN A 426     -14.821  30.898  -2.288  1.00 16.45           N  
ATOM    822  CA  ASN A 426     -14.691  30.419  -3.666  1.00 19.88           C  
ATOM    823  C   ASN A 426     -13.806  31.326  -4.515  1.00 17.08           C  
ATOM    824  O   ASN A 426     -12.926  30.848  -5.227  1.00 19.57           O  
ATOM    825  CB  ASN A 426     -16.069  30.279  -4.329  1.00 23.81           C  
ATOM    826  CG  ASN A 426     -16.810  29.025  -3.888  1.00 30.57           C  
ATOM    827  OD1 ASN A 426     -16.197  28.032  -3.492  1.00 32.75           O  
ATOM    828  ND2 ASN A 426     -18.144  29.064  -3.958  1.00 29.88           N  
ATOM    829  N   LYS A 427     -14.031  32.634  -4.439  1.00 17.68           N  
ATOM    830  CA  LYS A 427     -13.263  33.594  -5.228  1.00 17.54           C  
ATOM    831  C   LYS A 427     -11.761  33.548  -4.898  1.00 19.71           C  
ATOM    832  O   LYS A 427     -10.920  33.696  -5.774  1.00 20.92           O  
ATOM    833  CB  LYS A 427     -13.785  35.023  -5.024  1.00 22.19           C  
ATOM    834  CG  LYS A 427     -15.101  35.341  -5.758  1.00 28.86           C  
ATOM    835  CD  LYS A 427     -14.911  35.305  -7.273  1.00 32.93           C  
ATOM    836  CE  LYS A 427     -16.086  35.893  -8.046  1.00 39.02           C  
ATOM    837  NZ  LYS A 427     -16.468  35.043  -9.232  1.00 40.76           N  
ATOM    838  N   VAL A 428     -11.418  33.392  -3.633  1.00 15.39           N  
ATOM    839  CA  VAL A 428     -10.002  33.344  -3.267  1.00 16.79           C  
ATOM    840  C   VAL A 428      -9.424  31.960  -3.568  1.00 20.71           C  
ATOM    841  O   VAL A 428      -8.338  31.842  -4.109  1.00 21.87           O  
ATOM    842  CB  VAL A 428      -9.797  33.640  -1.785  1.00 17.05           C  
ATOM    843  CG1 VAL A 428      -8.364  33.553  -1.417  1.00 18.40           C  
ATOM    844  CG2 VAL A 428     -10.316  35.045  -1.460  1.00 16.58           C  
ATOM    845  N   LYS A 429     -10.156  30.914  -3.217  1.00 21.02           N  
ATOM    846  CA  LYS A 429      -9.640  29.560  -3.385  1.00 24.25           C  
ATOM    847  C   LYS A 429      -9.343  29.226  -4.841  1.00 28.55           C  
ATOM    848  O   LYS A 429      -8.455  28.415  -5.119  1.00 29.21           O  
ATOM    849  CB  LYS A 429     -10.569  28.516  -2.773  1.00 25.06           C  
ATOM    850  CG  LYS A 429      -9.779  27.390  -2.161  1.00 30.61           C  
ATOM    851  CD  LYS A 429     -10.604  26.291  -1.566  1.00 32.65           C  
ATOM    852  CE  LYS A 429      -9.706  25.061  -1.323  1.00 37.79           C  
ATOM    853  NZ  LYS A 429      -8.527  25.347  -0.421  1.00 35.46           N  
ATOM    854  N   GLU A 430     -10.039  29.887  -5.766  1.00 30.33           N  
ATOM    855  CA  GLU A 430      -9.880  29.606  -7.195  1.00 32.24           C  
ATOM    856  C   GLU A 430      -8.625  30.236  -7.803  1.00 30.56           C  
ATOM    857  O   GLU A 430      -8.316  30.010  -8.968  1.00 32.72           O  
ATOM    858  CB  GLU A 430     -11.156  29.991  -7.980  1.00 32.52           C  
ATOM    859  CG  GLU A 430     -11.422  31.482  -8.126  1.00 35.37           C  
ATOM    860  CD  GLU A 430     -12.725  31.786  -8.875  1.00 39.53           C  
ATOM    861  OE1 GLU A 430     -13.562  30.877  -9.046  1.00 39.58           O  
ATOM    862  OE2 GLU A 430     -12.916  32.946  -9.281  1.00 41.69           O  
ATOM    863  N   ILE A 431      -7.912  31.041  -7.020  1.00 26.29           N  
ATOM    864  CA  ILE A 431      -6.634  31.590  -7.449  1.00 24.51           C  
ATOM    865  C   ILE A 431      -5.596  30.683  -6.800  1.00 24.24           C  
ATOM    866  O   ILE A 431      -5.441  30.697  -5.579  1.00 20.63           O  
ATOM    867  CB  ILE A 431      -6.495  33.031  -6.978  1.00 26.13           C  
ATOM    868  CG1 ILE A 431      -7.604  33.887  -7.592  1.00 28.50           C  
ATOM    869  CG2 ILE A 431      -5.106  33.586  -7.303  1.00 24.70           C  
ATOM    870  CD1 ILE A 431      -7.945  35.076  -6.759  1.00 30.54           C  
ATOM    871  N   PRO A 432      -4.901  29.882  -7.599  1.00 20.21           N  
ATOM    872  CA  PRO A 432      -3.975  28.887  -7.048  1.00 18.95           C  
ATOM    873  C   PRO A 432      -2.990  29.446  -6.010  1.00 15.50           C  
ATOM    874  O   PRO A 432      -2.764  28.770  -5.017  1.00 18.62           O  
ATOM    875  CB  PRO A 432      -3.236  28.364  -8.294  1.00 22.07           C  
ATOM    876  CG  PRO A 432      -4.160  28.602  -9.418  1.00 24.08           C  
ATOM    877  CD  PRO A 432      -4.978  29.819  -9.069  1.00 22.62           C  
ATOM    878  N   GLU A 433      -2.451  30.642  -6.207  1.00 15.12           N  
ATOM    879  CA  GLU A 433      -1.487  31.218  -5.280  1.00 19.41           C  
ATOM    880  C   GLU A 433      -2.033  31.412  -3.863  1.00 18.37           C  
ATOM    881  O   GLU A 433      -1.255  31.491  -2.911  1.00 15.91           O  
ATOM    882  CB  GLU A 433      -1.000  32.579  -5.781  1.00 24.02           C  
ATOM    883  CG  GLU A 433      -0.011  32.498  -6.917  1.00 33.45           C  
ATOM    884  CD  GLU A 433      -0.674  32.330  -8.266  1.00 38.23           C  
ATOM    885  OE1 GLU A 433      -1.918  32.537  -8.356  1.00 36.52           O  
ATOM    886  OE2 GLU A 433       0.064  31.982  -9.231  1.00 40.11           O  
ATOM    887  N   TYR A 434      -3.352  31.528  -3.724  1.00 13.15           N  
ATOM    888  CA  TYR A 434      -3.965  31.822  -2.427  1.00 15.66           C  
ATOM    889  C   TYR A 434      -4.827  30.674  -1.904  1.00 18.56           C  
ATOM    890  O   TYR A 434      -5.437  30.796  -0.847  1.00 19.06           O  
ATOM    891  CB  TYR A 434      -4.790  33.127  -2.500  1.00 18.02           C  
ATOM    892  CG  TYR A 434      -4.032  34.317  -3.016  1.00 16.26           C  
ATOM    893  CD1 TYR A 434      -2.876  34.750  -2.399  1.00 18.83           C  
ATOM    894  CD2 TYR A 434      -4.473  35.013  -4.132  1.00 20.48           C  
ATOM    895  CE1 TYR A 434      -2.176  35.836  -2.875  1.00 19.08           C  
ATOM    896  CE2 TYR A 434      -3.777  36.091  -4.614  1.00 21.20           C  
ATOM    897  CZ  TYR A 434      -2.628  36.498  -3.980  1.00 23.34           C  
ATOM    898  OH  TYR A 434      -1.947  37.582  -4.467  1.00 30.43           O  
ATOM    899  N   SER A 435      -4.845  29.540  -2.603  1.00 20.69           N  
ATOM    900  CA  SER A 435      -5.686  28.422  -2.197  1.00 23.01           C  
ATOM    901  C   SER A 435      -5.321  27.892  -0.815  1.00 22.60           C  
ATOM    902  O   SER A 435      -6.197  27.416  -0.098  1.00 27.91           O  
ATOM    903  CB  SER A 435      -5.634  27.281  -3.214  1.00 27.71           C  
ATOM    904  OG  SER A 435      -4.295  26.905  -3.489  1.00 33.03           O  
ATOM    905  N   HIS A 436      -4.046  28.000  -0.435  1.00 22.32           N  
ATOM    906  CA  HIS A 436      -3.564  27.545   0.877  1.00 20.23           C  
ATOM    907  C   HIS A 436      -4.158  28.336   2.059  1.00 21.74           C  
ATOM    908  O   HIS A 436      -4.075  27.893   3.211  1.00 21.86           O  
ATOM    909  CB  HIS A 436      -2.020  27.597   0.932  1.00 19.95           C  
ATOM    910  CG  HIS A 436      -1.436  28.982   0.931  1.00 16.65           C  
ATOM    911  ND1 HIS A 436      -1.296  29.733  -0.219  1.00 16.17           N  
ATOM    912  CD2 HIS A 436      -0.802  29.680   1.902  1.00 17.01           C  
ATOM    913  CE1 HIS A 436      -0.625  30.837   0.056  1.00 19.37           C  
ATOM    914  NE2 HIS A 436      -0.435  30.888   1.360  1.00 19.19           N  
ATOM    915  N   LEU A 437      -4.759  29.488   1.764  1.00 19.69           N  
ATOM    916  CA  LEU A 437      -5.304  30.380   2.795  1.00 19.66           C  
ATOM    917  C   LEU A 437      -6.794  30.191   3.083  1.00 21.25           C  
ATOM    918  O   LEU A 437      -7.341  30.871   3.967  1.00 20.93           O  
ATOM    919  CB  LEU A 437      -5.048  31.832   2.404  1.00 16.97           C  
ATOM    920  CG  LEU A 437      -3.582  32.207   2.186  1.00 18.15           C  
ATOM    921  CD1 LEU A 437      -3.482  33.606   1.671  1.00 18.51           C  
ATOM    922  CD2 LEU A 437      -2.775  32.024   3.467  1.00 17.62           C  
ATOM    923  N   ILE A 438      -7.435  29.267   2.360  1.00 21.46           N  
ATOM    924  CA  ILE A 438      -8.864  29.011   2.506  1.00 22.47           C  
ATOM    925  C   ILE A 438      -9.092  27.516   2.752  1.00 25.20           C  
ATOM    926  O   ILE A 438      -8.582  26.670   2.018  1.00 24.94           O  
ATOM    927  CB  ILE A 438      -9.634  29.458   1.221  1.00 21.54           C  
ATOM    928  CG1 ILE A 438      -9.417  30.942   0.917  1.00 18.91           C  
ATOM    929  CG2 ILE A 438     -11.125  29.114   1.321  1.00 21.64           C  
ATOM    930  CD1 ILE A 438      -9.973  31.934   1.944  1.00 20.33           C  
ATOM    931  N   ASP A 439      -9.863  27.196   3.788  1.00 27.46           N  
TER     932      ASP A 439                                                      
END
MOLECULE T0432.pdb
ATOM      1  N   SER     1      12.703  45.910  -3.320  1.00 50.93           N
ATOM      2  CA  SER     1      13.109  46.216  -4.712  1.00 47.13           C
ATOM      4  CB  SER     1      13.709  44.967  -5.358  1.00 53.53           C
ATOM      7  OG  SER     1      12.759  43.911  -5.430  1.00 42.48           O
ATOM      9  C   SER     1      11.931  46.715  -5.566  1.00 52.43           C
ATOM     10  O   SER     1      10.768  46.719  -5.114  1.00 45.72           O
ATOM     14  N   MET     2      12.255  47.142  -6.791  1.00 48.01           N
ATOM     15  CA  MET     2      11.257  47.418  -7.836  1.00 53.09           C
ATOM     17  CB  MET     2      11.927  47.928  -9.120  1.00 51.71           C
ATOM     23  C   MET     2      10.424  46.169  -8.153  1.00 49.18           C
ATOM     24  O   MET     2       9.206  46.267  -8.286  1.00 51.00           O
ATOM     26  N   GLN     3      11.078  45.011  -8.268  1.00 44.90           N
ATOM     27  CA  GLN     3      10.368  43.738  -8.433  1.00 49.87           C
ATOM     29  CB  GLN     3      11.334  42.538  -8.524  1.00 49.44           C
ATOM     32  CG  GLN     3      11.990  42.326  -9.886  1.00 56.96           C
ATOM     38  C   GLN     3       9.361  43.512  -7.283  1.00 43.65           C
ATOM     39  O   GLN     3       8.242  43.071  -7.521  1.00 37.83           O
ATOM     41  N   GLU     4       9.764  43.812  -6.049  1.00 34.49           N
ATOM     42  CA  GLU     4       8.896  43.571  -4.909  1.00 28.57           C
ATOM     44  CB  GLU     4       9.695  43.588  -3.619  1.00 30.35           C
ATOM     47  CG  GLU     4      10.564  42.317  -3.478  1.00 32.03           C
ATOM     50  CD  GLU     4      11.497  42.362  -2.284  1.00 34.53           C
ATOM     51  OE1 GLU     4      11.564  43.415  -1.624  1.00 39.92           O
ATOM     52  OE2 GLU     4      12.167  41.335  -2.002  1.00 35.71           O
ATOM     53  C   GLU     4       7.708  44.529  -4.871  1.00 25.78           C
ATOM     54  O   GLU     4       6.586  44.106  -4.548  1.00 21.89           O
ATOM     56  N   GLU     5       7.958  45.807  -5.172  1.00 27.67           N
ATOM     57  CA  GLU     5       6.900  46.803  -5.275  1.00 29.37           C
ATOM     59  CB  GLU     5       7.492  48.200  -5.504  1.00 32.93           C
ATOM     62  CG  GLU     5       8.329  48.698  -4.321  1.00 36.17           C
ATOM     68  C   GLU     5       5.841  46.464  -6.357  1.00 26.28           C
ATOM     69  O   GLU     5       4.652  46.729  -6.168  1.00 24.25           O
ATOM     71  N   ASP     6       6.276  45.882  -7.472  1.00 23.77           N
ATOM     72  CA  ASP     6       5.354  45.408  -8.499  1.00 26.67           C
ATOM     74  CB  ASP     6       6.099  44.978  -9.756  1.00 25.76           C
ATOM     77  CG  ASP     6       6.749  46.165 -10.526  1.00 24.96           C
ATOM     78  OD1 ASP     6       6.374  47.338 -10.325  1.00 41.80           O
ATOM     79  OD2 ASP     6       7.653  45.870 -11.317  1.00 39.42           O
ATOM     80  C   ASP     6       4.501  44.208  -7.998  1.00 20.23           C
ATOM     81  O   ASP     6       3.358  44.093  -8.388  1.00 20.47           O
ATOM     83  N   THR     7       5.093  43.319  -7.201  1.00 22.25           N
ATOM     84  CA  THR     7       4.384  42.184  -6.606  1.00 22.70           C
ATOM     86  CB  THR     7       5.332  41.245  -5.780  1.00 22.94           C
ATOM     88  OG1 THR     7       6.367  40.712  -6.630  1.00 26.30           O
ATOM     90  CG2 THR     7       4.556  40.047  -5.132  1.00 16.87           C
ATOM     94  C   THR     7       3.250  42.693  -5.726  1.00 21.27           C
ATOM     95  O   THR     7       2.114  42.227  -5.839  1.00 18.76           O
ATOM     97  N   PHE     8       3.574  43.615  -4.823  1.00 19.23           N
ATOM     98  CA  PHE     8       2.558  44.181  -3.944  1.00 19.60           C
ATOM    100  CB  PHE     8       3.176  45.001  -2.822  1.00 22.71           C
ATOM    103  CG  PHE     8       3.951  44.177  -1.823  1.00 23.51           C
ATOM    104  CD1 PHE     8       3.439  42.949  -1.346  1.00 28.77           C
ATOM    106  CE1 PHE     8       4.152  42.173  -0.434  1.00 28.06           C
ATOM    108  CZ  PHE     8       5.373  42.635   0.031  1.00 28.78           C
ATOM    110  CE2 PHE     8       5.884  43.835  -0.423  1.00 30.30           C
ATOM    112  CD2 PHE     8       5.169  44.616  -1.353  1.00 28.10           C
ATOM    114  C   PHE     8       1.496  44.993  -4.689  1.00 22.06           C
ATOM    115  O   PHE     8       0.320  44.959  -4.316  1.00 17.45           O
ATOM    117  N   ARG     9       1.904  45.735  -5.712  1.00 20.32           N
ATOM    118  CA  ARG     9       0.939  46.442  -6.556  1.00 18.47           C
ATOM    120  CB  ARG     9       1.639  47.343  -7.542  1.00 20.96           C
ATOM    123  CG  ARG     9       0.718  48.210  -8.324  1.00 30.12           C
ATOM    126  CD  ARG     9       1.462  49.336  -8.973  1.00 33.72           C
ATOM    129  NE  ARG     9       0.560  50.358  -9.495  1.00 49.38           N
ATOM    131  CZ  ARG     9      -0.009  50.371 -10.710  1.00 50.88           C
ATOM    132  NH1 ARG     9       0.198  49.411 -11.626  1.00 36.54           N
ATOM    135  NH2 ARG     9      -0.779  51.400 -11.024  1.00 35.58           N
ATOM    138  C   ARG     9      -0.005  45.464  -7.267  1.00 18.25           C
ATOM    139  O   ARG     9      -1.217  45.710  -7.282  1.00 15.91           O
ATOM    141  N   GLU    10       0.522  44.363  -7.832  1.00 15.31           N
ATOM    142  CA  GLU    10      -0.351  43.339  -8.413  1.00 19.50           C
ATOM    144  CB  GLU    10       0.439  42.219  -9.076  1.00 21.24           C
ATOM    147  CG  GLU    10      -0.467  41.097  -9.566  1.00 23.10           C
ATOM    150  CD  GLU    10       0.189  40.117 -10.508  1.00 33.77           C
ATOM    151  OE1 GLU    10      -0.487  39.118 -10.845  1.00 26.89           O
ATOM    152  OE2 GLU    10       1.358  40.328 -10.890  1.00 26.18           O
ATOM    153  C   GLU    10      -1.355  42.768  -7.382  1.00 23.48           C
ATOM    154  O   GLU    10      -2.548  42.617  -7.692  1.00 16.96           O
ATOM    156  N   LEU    11      -0.871  42.447  -6.176  1.00 22.33           N
ATOM    157  CA  LEU    11      -1.756  42.020  -5.079  1.00 17.97           C
ATOM    159  CB  LEU    11      -0.969  41.736  -3.779  1.00 21.21           C
ATOM    162  CG  LEU    11      -1.851  41.320  -2.564  1.00 18.71           C
ATOM    164  CD1 LEU    11      -2.569  39.975  -2.827  1.00 16.49           C
ATOM    168  CD2 LEU    11      -1.052  41.296  -1.292  1.00 17.23           C
ATOM    172  C   LEU    11      -2.872  43.029  -4.826  1.00 18.50           C
ATOM    173  O   LEU    11      -4.018  42.652  -4.757  1.00 17.18           O
ATOM    175  N   ARG    12      -2.554  44.316  -4.710  1.00 16.81           N
ATOM    176  CA  ARG    12      -3.587  45.342  -4.508  1.00 18.76           C
ATOM    178  CB  ARG    12      -2.975  46.756  -4.299  1.00 15.68           C
ATOM    181  CG  ARG    12      -2.092  46.846  -3.060  1.00 20.36           C
ATOM    184  CD  ARG    12      -1.799  48.294  -2.715  1.00 24.48           C
ATOM    187  NE  ARG    12      -0.943  48.950  -3.696  1.00 19.83           N
ATOM    189  CZ  ARG    12       0.393  48.875  -3.740  1.00 17.58           C
ATOM    190  NH1 ARG    12       1.084  48.164  -2.878  1.00 25.76           N
ATOM    193  NH2 ARG    12       1.034  49.530  -4.686  1.00 24.92           N
ATOM    196  C   ARG    12      -4.628  45.388  -5.624  1.00 16.66           C
ATOM    197  O   ARG    12      -5.828  45.475  -5.353  1.00 16.08           O
ATOM    199  N   ILE    13      -4.164  45.301  -6.864  1.00 19.21           N
ATOM    200  CA  ILE    13      -5.044  45.236  -8.043  1.00 17.95           C
ATOM    202  CB  ILE    13      -4.224  45.209  -9.367  1.00 17.89           C
ATOM    204  CG1 ILE    13      -3.478  46.541  -9.577  1.00 23.66           C
ATOM    207  CD1 ILE    13      -2.498  46.500 -10.707  1.00 27.76           C
ATOM    211  CG2 ILE    13      -5.101  44.894 -10.587  1.00 24.21           C
ATOM    215  C   ILE    13      -5.997  44.011  -7.963  1.00 14.86           C
ATOM    216  O   ILE    13      -7.218  44.155  -8.154  1.00 16.18           O
ATOM    218  N   PHE    14      -5.438  42.857  -7.652  1.00 16.54           N
ATOM    219  CA  PHE    14      -6.211  41.642  -7.441  1.00 15.48           C
ATOM    221  CB  PHE    14      -5.313  40.456  -7.134  1.00 18.04           C
ATOM    224  CG  PHE    14      -6.074  39.237  -6.793  1.00 18.02           C
ATOM    225  CD1 PHE    14      -6.678  38.465  -7.790  1.00 26.02           C
ATOM    227  CE1 PHE    14      -7.424  37.332  -7.462  1.00 20.26           C
ATOM    229  CZ  PHE    14      -7.559  36.973  -6.149  1.00 20.14           C
ATOM    231  CE2 PHE    14      -6.970  37.746  -5.142  1.00 23.20           C
ATOM    233  CD2 PHE    14      -6.239  38.861  -5.465  1.00 22.05           C
ATOM    235  C   PHE    14      -7.252  41.824  -6.314  1.00 17.60           C
ATOM    236  O   PHE    14      -8.431  41.558  -6.507  1.00 16.66           O
ATOM    238  N   LEU    15      -6.807  42.332  -5.166  1.00 15.25           N
ATOM    239  CA  LEU    15      -7.701  42.555  -4.016  1.00 15.48           C
ATOM    241  CB  LEU    15      -6.921  42.915  -2.741  1.00 17.25           C
ATOM    244  CG  LEU    15      -5.972  41.845  -2.195  1.00 20.45           C
ATOM    246  CD1 LEU    15      -5.225  42.342  -0.920  1.00 15.28           C
ATOM    250  CD2 LEU    15      -6.687  40.491  -1.929  1.00 17.37           C
ATOM    254  C   LEU    15      -8.826  43.550  -4.269  1.00 16.03           C
ATOM    255  O   LEU    15      -9.961  43.320  -3.815  1.00 15.92           O
ATOM    257  N   ARG    16      -8.542  44.625  -4.980  1.00 16.38           N
ATOM    258  CA  ARG    16      -9.590  45.593  -5.363  1.00 13.95           C
ATOM    260  CB  ARG    16      -9.022  46.796  -6.096  1.00 16.47           C
ATOM    263  CG  ARG    16      -8.327  47.808  -5.243  1.00 20.20           C
ATOM    266  CD  ARG    16      -7.975  49.054  -6.021  1.00 26.38           C
ATOM    269  NE  ARG    16      -6.868  49.676  -5.338  1.00 24.76           N
ATOM    271  CZ  ARG    16      -5.583  49.547  -5.650  1.00 23.18           C
ATOM    272  NH1 ARG    16      -5.178  48.910  -6.742  1.00 24.86           N
ATOM    275  NH2 ARG    16      -4.686  50.121  -4.856  1.00 30.66           N
ATOM    278  C   ARG    16     -10.679  44.968  -6.259  1.00 13.93           C
ATOM    279  O   ARG    16     -11.864  45.248  -6.112  1.00 14.07           O
ATOM    281  N   ASN    17     -10.257  44.175  -7.218  1.00 16.80           N
ATOM    282  CA  ASN    17     -11.176  43.522  -8.112  1.00 18.78           C
ATOM    284  CB  ASN    17     -10.401  42.870  -9.247  1.00 21.01           C
ATOM    287  CG  ASN    17     -11.295  42.036 -10.170  1.00 28.67           C
ATOM    288  OD1 ASN    17     -11.469  40.838  -9.941  1.00 21.42           O
ATOM    289  ND2 ASN    17     -11.827  42.664 -11.250  1.00 28.09           N
ATOM    292  C   ASN    17     -12.089  42.535  -7.382  1.00 16.00           C
ATOM    293  O   ASN    17     -13.302  42.574  -7.591  1.00 17.86           O
ATOM    295  N   VAL    18     -11.520  41.689  -6.521  1.00 18.79           N
ATOM    296  CA  VAL    18     -12.301  40.735  -5.735  1.00 17.67           C
ATOM    298  CB  VAL    18     -11.407  39.847  -4.834  1.00 19.56           C
ATOM    300  CG1 VAL    18     -12.271  39.004  -3.891  1.00 20.84           C
ATOM    304  CG2 VAL    18     -10.450  38.989  -5.687  1.00 14.57           C
ATOM    308  C   VAL    18     -13.266  41.501  -4.810  1.00 17.37           C
ATOM    309  O   VAL    18     -14.450  41.176  -4.721  1.00 19.43           O
ATOM    311  N   THR    19     -12.747  42.526  -4.146  1.00 16.37           N
ATOM    312  CA  THR    19     -13.563  43.341  -3.222  1.00 17.39           C
ATOM    314  CB  THR    19     -12.716  44.371  -2.443  1.00 16.96           C
ATOM    316  OG1 THR    19     -11.617  43.710  -1.816  1.00 17.66           O
ATOM    318  CG2 THR    19     -13.564  45.076  -1.343  1.00 20.05           C
ATOM    322  C   THR    19     -14.744  44.026  -3.933  1.00 17.65           C
ATOM    323  O   THR    19     -15.852  44.020  -3.417  1.00 19.09           O
ATOM    325  N   HIS    20     -14.508  44.595  -5.101  1.00 19.93           N
ATOM    326  CA  HIS    20     -15.611  45.135  -5.920  1.00 19.72           C
ATOM    328  CB  HIS    20     -15.059  45.947  -7.086  0.50 21.68           C
ATOM    334  CG  HIS    20     -14.484  47.263  -6.651  0.50 31.09           C
ATOM    336  ND1 HIS    20     -15.103  48.066  -5.710  0.50 15.30           N
ATOM    340  CE1 HIS    20     -14.376  49.152  -5.520  0.50 31.02           C
ATOM    344  NE2 HIS    20     -13.308  49.082  -6.295  0.50 28.85           N
ATOM    348  CD2 HIS    20     -13.355  47.914  -7.019  0.50 25.42           C
ATOM    352  C   HIS    20     -16.660  44.095  -6.319  1.00 17.96           C
ATOM    353  O   HIS    20     -17.853  44.378  -6.303  1.00 20.97           O
ATOM    355  N   ARG    21     -16.230  42.894  -6.686  1.00 17.03           N
ATOM    356  CA  ARG    21     -17.180  41.826  -7.010  1.00 18.99           C
ATOM    358  CB  ARG    21     -16.435  40.624  -7.602  1.00 14.36           C
ATOM    361  CG  ARG    21     -15.970  40.922  -9.011  1.00 20.10           C
ATOM    364  CD  ARG    21     -14.704  40.187  -9.358  1.00 26.48           C
ATOM    367  NE  ARG    21     -14.976  38.798  -9.527  1.00 23.70           N
ATOM    369  CZ  ARG    21     -14.059  37.850  -9.652  1.00 24.65           C
ATOM    370  NH1 ARG    21     -12.773  38.120  -9.628  1.00 21.13           N
ATOM    373  NH2 ARG    21     -14.461  36.619  -9.815  1.00 21.77           N
ATOM    376  C   ARG    21     -18.083  41.435  -5.822  1.00 19.61           C
ATOM    377  O   ARG    21     -19.285  41.157  -5.992  1.00 23.33           O
ATOM    379  N   LEU    22     -17.522  41.469  -4.622  1.00 19.80           N
ATOM    380  CA  LEU    22     -18.300  41.281  -3.399  1.00 18.25           C
ATOM    382  CB  LEU    22     -17.378  41.023  -2.193  1.00 19.98           C
ATOM    385  CG  LEU    22     -16.345  39.907  -2.263  1.00 18.93           C
ATOM    387  CD1 LEU    22     -15.396  39.999  -1.040  1.00 20.62           C
ATOM    391  CD2 LEU    22     -17.018  38.495  -2.365  1.00 20.07           C
ATOM    395  C   LEU    22     -19.228  42.459  -3.101  1.00 20.64           C
ATOM    396  O   LEU    22     -20.415  42.251  -2.807  1.00 21.92           O
ATOM    398  N   ALA    23     -18.701  43.679  -3.190  1.00 17.45           N
ATOM    399  CA  ALA    23     -19.441  44.866  -2.847  1.00 17.66           C
ATOM    401  CB  ALA    23     -18.527  46.122  -2.822  1.00 21.62           C
ATOM    405  C   ALA    23     -20.644  45.119  -3.776  1.00 26.04           C
ATOM    406  O   ALA    23     -21.590  45.756  -3.360  1.00 22.48           O
ATOM    408  N   ILE    24     -20.612  44.639  -5.014  1.00 25.86           N
ATOM    409  CA  ILE    24     -21.755  44.832  -5.895  1.00 27.15           C
ATOM    411  CB  ILE    24     -21.344  45.044  -7.374  1.00 28.18           C
ATOM    413  CG1 ILE    24     -20.761  43.768  -7.966  1.00 23.99           C
ATOM    416  CD1 ILE    24     -20.472  43.872  -9.443  1.00 35.51           C
ATOM    420  CG2 ILE    24     -20.408  46.213  -7.489  1.00 34.25           C
ATOM    424  C   ILE    24     -22.790  43.706  -5.793  1.00 28.62           C
ATOM    425  O   ILE    24     -23.850  43.801  -6.384  1.00 26.67           O
ATOM    427  N   ASP    25     -22.498  42.646  -5.046  1.00 25.41           N
ATOM    428  CA  ASP    25     -23.433  41.566  -4.884  1.00 26.94           C
ATOM    430  CB  ASP    25     -22.726  40.350  -4.319  1.00 26.56           C
ATOM    433  CG  ASP    25     -23.578  39.107  -4.362  1.00 23.90           C
ATOM    434  OD1 ASP    25     -24.730  39.106  -3.846  1.00 26.48           O
ATOM    435  OD2 ASP    25     -23.072  38.101  -4.865  1.00 25.65           O
ATOM    436  C   ASP    25     -24.552  42.053  -3.944  1.00 28.65           C
ATOM    437  O   ASP    25     -24.284  42.520  -2.852  1.00 22.14           O
ATOM    439  N   LYS    26     -25.805  41.969  -4.394  1.00 30.84           N
ATOM    440  CA  LYS    26     -26.972  42.460  -3.624  1.00 30.71           C
ATOM    442  CB  LYS    26     -28.269  42.264  -4.436  1.00 33.89           C
ATOM    445  CG  LYS    26     -28.511  43.357  -5.458  1.00 44.49           C
ATOM    451  C   LYS    26     -27.110  41.822  -2.229  1.00 20.07           C
ATOM    452  O   LYS    26     -27.539  42.461  -1.284  1.00 26.43           O
ATOM    454  N   ARG    27     -26.680  40.589  -2.087  1.00 21.15           N
ATOM    455  CA  ARG    27     -26.707  39.913  -0.798  1.00 22.60           C
ATOM    457  CB  ARG    27     -26.242  38.480  -0.963  1.00 25.57           C
ATOM    460  CG  ARG    27     -27.146  37.636  -1.841  1.00 27.66           C
ATOM    463  CD  ARG    27     -26.556  36.286  -2.013  1.00 23.29           C
ATOM    466  NE  ARG    27     -25.338  36.340  -2.817  1.00 26.58           N
ATOM    468  CZ  ARG    27     -24.476  35.332  -2.941  1.00 23.01           C
ATOM    469  NH1 ARG    27     -24.685  34.189  -2.338  1.00 28.51           N
ATOM    472  NH2 ARG    27     -23.403  35.463  -3.696  1.00 28.09           N
ATOM    475  C   ARG    27     -25.817  40.557   0.265  1.00 24.98           C
ATOM    476  O   ARG    27     -26.053  40.397   1.473  1.00 25.35           O
ATOM    478  N   PHE    28     -24.801  41.282  -0.186  1.00 21.49           N
ATOM    479  CA  PHE    28     -23.726  41.741   0.688  1.00 23.72           C
ATOM    481  CB  PHE    28     -22.367  41.350   0.071  1.00 18.92           C
ATOM    484  CG  PHE    28     -22.222  39.873  -0.238  1.00 22.49           C
ATOM    485  CD1 PHE    28     -22.890  38.896   0.509  1.00 18.05           C
ATOM    487  CE1 PHE    28     -22.755  37.560   0.217  1.00 23.57           C
ATOM    489  CZ  PHE    28     -21.918  37.162  -0.818  1.00 19.66           C
ATOM    491  CE2 PHE    28     -21.237  38.120  -1.551  1.00 19.19           C
ATOM    493  CD2 PHE    28     -21.387  39.456  -1.252  1.00 20.61           C
ATOM    495  C   PHE    28     -23.809  43.225   0.963  1.00 20.64           C
ATOM    496  O   PHE    28     -22.922  43.802   1.621  1.00 21.40           O
ATOM    498  N   ARG    29     -24.903  43.860   0.528  1.00 25.62           N
ATOM    499  CA  ARG    29     -25.106  45.308   0.727  1.00 25.06           C
ATOM    501  CB  ARG    29     -26.492  45.749   0.199  1.00 28.09           C
ATOM    504  CG  ARG    29     -26.750  47.252   0.234  1.00 35.00           C
ATOM    507  CD  ARG    29     -28.236  47.617   0.028  1.00 56.20           C
ATOM    510  NE  ARG    29     -29.158  46.670   0.671  1.00 80.68           N
ATOM    512  CZ  ARG    29     -29.425  46.591   1.982  1.00 79.44           C
ATOM    513  NH1 ARG    29     -28.846  47.409   2.863  1.00 66.15           N
ATOM    516  NH2 ARG    29     -30.277  45.662   2.420  1.00 79.04           N
ATOM    519  C   ARG    29     -24.931  45.753   2.180  1.00 20.06           C
ATOM    520  O   ARG    29     -24.355  46.816   2.424  1.00 26.41           O
ATOM    522  N   VAL    30     -25.391  44.932   3.117  1.00 27.21           N
ATOM    523  CA  VAL    30     -25.289  45.215   4.553  1.00 33.63           C
ATOM    525  CB  VAL    30     -26.019  44.115   5.436  1.00 38.16           C
ATOM    527  CG1 VAL    30     -25.513  42.687   5.162  1.00 30.77           C
ATOM    531  CG2 VAL    30     -25.887  44.414   6.918  1.00 51.45           C
ATOM    535  C   VAL    30     -23.825  45.365   5.002  1.00 33.95           C
ATOM    536  O   VAL    30     -23.536  46.052   5.976  1.00 28.60           O
ATOM    538  N   PHE    31     -22.908  44.747   4.262  1.00 27.31           N
ATOM    539  CA  PHE    31     -21.483  44.731   4.632  1.00 23.37           C
ATOM    541  CB  PHE    31     -20.917  43.326   4.423  1.00 24.67           C
ATOM    544  CG  PHE    31     -21.743  42.236   5.027  1.00 23.53           C
ATOM    545  CD1 PHE    31     -21.987  42.193   6.401  1.00 24.92           C
ATOM    547  CE1 PHE    31     -22.759  41.189   6.950  1.00 34.33           C
ATOM    549  CZ  PHE    31     -23.268  40.181   6.142  1.00 26.48           C
ATOM    551  CE2 PHE    31     -23.027  40.198   4.778  1.00 23.80           C
ATOM    553  CD2 PHE    31     -22.274  41.225   4.222  1.00 23.54           C
ATOM    555  C   PHE    31     -20.667  45.756   3.856  1.00 25.64           C
ATOM    556  O   PHE    31     -19.440  45.777   3.960  1.00 24.17           O
ATOM    558  N   THR    32     -21.344  46.619   3.093  1.00 24.94           N
ATOM    559  CA  THR    32     -20.680  47.593   2.255  1.00 23.72           C
ATOM    561  CB  THR    32     -21.469  47.932   0.964  1.00 31.83           C
ATOM    563  OG1 THR    32     -22.742  48.526   1.288  1.00 32.27           O
ATOM    565  CG2 THR    32     -21.633  46.678   0.069  1.00 22.27           C
ATOM    569  C   THR    32     -20.378  48.901   3.005  1.00 29.48           C
ATOM    570  O   THR    32     -19.567  49.691   2.546  1.00 30.50           O
ATOM    572  N   LYS    33     -21.018  49.116   4.153  1.00 29.86           N
ATOM    573  CA  LYS    33     -20.827  50.362   4.910  1.00 35.76           C
ATOM    575  CB  LYS    33     -22.004  51.342   4.691  1.00 36.32           C
ATOM    578  CG  LYS    33     -22.005  52.062   3.342  1.00 51.13           C
ATOM    581  CD  LYS    33     -23.340  52.779   3.070  1.00 45.23           C
ATOM    586  C   LYS    33     -20.703  50.066   6.387  1.00 30.75           C
ATOM    587  O   LYS    33     -21.211  49.038   6.877  1.00 34.04           O
ATOM    589  N   PRO    34     -20.022  50.975   7.124  1.00 40.34           N
ATOM    590  CA  PRO    34     -20.024  50.887   8.573  1.00 43.78           C
ATOM    592  CB  PRO    34     -19.289  52.160   9.007  1.00 44.37           C
ATOM    595  CG  PRO    34     -18.458  52.547   7.868  1.00 40.69           C
ATOM    598  CD  PRO    34     -19.251  52.142   6.652  1.00 39.52           C
ATOM    601  C   PRO    34     -21.445  50.906   9.117  1.00 46.49           C
ATOM    602  O   PRO    34     -22.348  51.411   8.462  1.00 46.86           O
ATOM    603  N   VAL    35     -21.629  50.357  10.306  1.00 52.73           N
ATOM    604  CA  VAL    35     -22.905  50.435  11.002  1.00 56.02           C
ATOM    606  CB  VAL    35     -22.963  49.408  12.141  1.00 52.91           C
ATOM    608  CG1 VAL    35     -22.966  47.996  11.569  1.00 47.77           C
ATOM    612  CG2 VAL    35     -24.191  49.658  13.016  1.00 45.00           C
ATOM    616  C   VAL    35     -23.139  51.853  11.562  1.00 63.10           C
ATOM    617  O   VAL    35     -22.258  52.435  12.205  1.00 67.79           O
ATOM    619  N   ASP    36     -24.333  52.394  11.320  1.00 66.89           N
ATOM    620  CA  ASP    36     -24.676  53.763  11.725  1.00 68.61           C
ATOM    622  CB  ASP    36     -25.929  54.218  10.964  1.00 70.39           C
ATOM    625  CG  ASP    36     -26.175  55.714  11.064  1.00 77.61           C
ATOM    626  OD1 ASP    36     -25.201  56.485  11.219  1.00 70.69           O
ATOM    627  OD2 ASP    36     -27.355  56.117  10.971  1.00 90.64           O
ATOM    628  C   ASP    36     -24.898  53.861  13.254  1.00 67.11           C
ATOM    629  O   ASP    36     -25.795  53.199  13.800  1.00 56.69           O
ATOM    631  N   PRO    37     -24.081  54.685  13.951  1.00 70.78           N
ATOM    632  CA  PRO    37     -24.197  54.744  15.420  1.00 75.96           C
ATOM    634  CB  PRO    37     -23.059  55.691  15.834  1.00 75.72           C
ATOM    637  CG  PRO    37     -22.765  56.499  14.625  1.00 71.83           C
ATOM    640  CD  PRO    37     -23.059  55.621  13.443  1.00 67.24           C
ATOM    643  C   PRO    37     -25.552  55.273  15.901  1.00 80.35           C
ATOM    644  O   PRO    37     -25.932  55.035  17.050  1.00 83.21           O
ATOM    645  N   ASP    38     -26.266  55.976  15.023  1.00 83.08           N
ATOM    646  CA  ASP    38     -27.612  56.454  15.320  1.00 85.90           C
ATOM    648  CB  ASP    38     -28.032  57.549  14.332  1.00 86.22           C
ATOM    651  CG  ASP    38     -26.946  58.600  14.122  1.00 91.26           C
ATOM    652  OD1 ASP    38     -26.291  59.000  15.112  1.00 80.39           O
ATOM    653  OD2 ASP    38     -26.747  59.019  12.960  1.00 95.27           O
ATOM    654  C   ASP    38     -28.582  55.275  15.258  1.00 86.84           C
ATOM    655  O   ASP    38     -29.307  55.008  16.220  1.00 87.15           O
ATOM    657  N   GLU    39     -28.574  54.568  14.127  1.00 85.88           N
ATOM    658  CA  GLU    39     -29.421  53.389  13.941  1.00 84.58           C
ATOM    660  CB  GLU    39     -29.302  52.861  12.505  1.00 83.92           C
ATOM    667  C   GLU    39     -29.085  52.284  14.956  1.00 84.18           C
ATOM    668  O   GLU    39     -29.990  51.719  15.580  1.00 83.93           O
ATOM    670  N   VAL    40     -27.791  51.994  15.127  1.00 82.97           N
ATOM    671  CA  VAL    40     -27.326  50.952  16.059  1.00 79.76           C
ATOM    673  CB  VAL    40     -26.710  49.752  15.311  1.00 77.63           C
ATOM    675  CG1 VAL    40     -26.842  48.498  16.145  1.00 78.57           C
ATOM    679  CG2 VAL    40     -27.387  49.554  13.963  1.00 78.81           C
ATOM    683  C   VAL    40     -26.291  51.535  17.035  1.00 78.94           C
ATOM    684  O   VAL    40     -25.088  51.526  16.748  1.00 74.58           O
ATOM    686  N   PRO    41     -26.760  52.045  18.194  1.00 78.72           N
ATOM    687  CA  PRO    41     -25.885  52.767  19.130  1.00 75.46           C
ATOM    689  CB  PRO    41     -26.876  53.520  20.018  1.00 76.25           C
ATOM    692  CG  PRO    41     -28.089  52.638  20.045  1.00 80.48           C
ATOM    695  CD  PRO    41     -28.127  51.890  18.730  1.00 78.09           C
ATOM    698  C   PRO    41     -24.988  51.852  19.962  1.00 69.89           C
ATOM    699  O   PRO    41     -23.862  52.235  20.284  1.00 71.29           O
ATOM    700  N   ASP    42     -25.477  50.655  20.285  1.00 64.93           N
ATOM    701  CA  ASP    42     -24.691  49.667  21.019  1.00 63.01           C
ATOM    703  CB  ASP    42     -25.616  48.712  21.801  1.00 65.05           C
ATOM    706  CG  ASP    42     -26.381  47.740  20.897  1.00 71.38           C
ATOM    707  OD1 ASP    42     -26.382  46.515  21.186  1.00 60.91           O
ATOM    708  OD2 ASP    42     -26.976  48.203  19.898  1.00 69.09           O
ATOM    709  C   ASP    42     -23.718  48.855  20.136  1.00 59.52           C
ATOM    710  O   ASP    42     -23.081  47.928  20.638  1.00 59.30           O
ATOM    712  N   TYR    43     -23.594  49.186  18.846  1.00 56.70           N
ATOM    713  CA  TYR    43     -22.720  48.402  17.952  1.00 54.71           C
ATOM    715  CB  TYR    43     -22.915  48.743  16.459  1.00 55.68           C
ATOM    718  CG  TYR    43     -22.255  47.707  15.545  1.00 45.79           C
ATOM    719  CD1 TYR    43     -22.908  46.519  15.245  1.00 50.75           C
ATOM    721  CE1 TYR    43     -22.322  45.546  14.436  1.00 42.58           C
ATOM    723  CZ  TYR    43     -21.059  45.744  13.920  1.00 34.68           C
ATOM    724  OH  TYR    43     -20.527  44.734  13.135  1.00 39.12           O
ATOM    726  CE2 TYR    43     -20.356  46.913  14.209  1.00 37.57           C
ATOM    728  CD2 TYR    43     -20.960  47.892  15.032  1.00 43.68           C
ATOM    730  C   TYR    43     -21.254  48.600  18.320  1.00 54.18           C
ATOM    731  O   TYR    43     -20.523  47.623  18.531  1.00 48.20           O
ATOM    733  N   VAL    44     -20.847  49.871  18.391  1.00 52.45           N
ATOM    734  CA  VAL    44     -19.454  50.239  18.637  1.00 55.94           C
ATOM    736  CB  VAL    44     -19.192  51.763  18.333  1.00 58.13           C
ATOM    738  CG1 VAL    44     -18.220  52.399  19.327  1.00 58.75           C
ATOM    742  CG2 VAL    44     -18.684  51.920  16.908  1.00 47.76           C
ATOM    746  C   VAL    44     -18.945  49.796  20.025  1.00 50.89           C
ATOM    747  O   VAL    44     -17.731  49.688  20.217  1.00 47.72           O
ATOM    749  N   THR    45     -19.866  49.487  20.947  1.00 49.61           N
ATOM    750  CA  THR    45     -19.520  48.909  22.259  1.00 48.11           C
ATOM    752  CB  THR    45     -20.445  49.461  23.395  1.00 52.57           C
ATOM    754  OG1 THR    45     -21.668  48.713  23.469  1.00 60.63           O
ATOM    756  CG2 THR    45     -20.767  50.929  23.165  1.00 43.51           C
ATOM    760  C   THR    45     -19.511  47.359  22.271  1.00 46.13           C
ATOM    761  O   THR    45     -18.704  46.746  22.995  1.00 44.43           O
ATOM    763  N   VAL    46     -20.385  46.723  21.480  1.00 42.70           N
ATOM    764  CA  VAL    46     -20.404  45.243  21.371  1.00 40.23           C
ATOM    766  CB  VAL    46     -21.778  44.712  20.870  1.00 44.94           C
ATOM    768  CG1 VAL    46     -21.747  43.180  20.691  1.00 46.94           C
ATOM    772  CG2 VAL    46     -22.893  45.133  21.829  1.00 44.05           C
ATOM    776  C   VAL    46     -19.287  44.702  20.453  1.00 36.60           C
ATOM    777  O   VAL    46     -18.654  43.673  20.744  1.00 38.38           O
ATOM    779  N   ILE    47     -19.065  45.396  19.341  1.00 30.45           N
ATOM    780  CA  ILE    47     -18.111  44.965  18.328  1.00 32.39           C
ATOM    782  CB  ILE    47     -18.734  44.983  16.890  1.00 35.54           C
ATOM    784  CG1 ILE    47     -19.956  44.028  16.779  1.00 27.28           C
ATOM    787  CD1 ILE    47     -19.707  42.525  17.097  1.00 23.48           C
ATOM    791  CG2 ILE    47     -17.682  44.619  15.842  1.00 25.81           C
ATOM    795  C   ILE    47     -16.864  45.865  18.401  1.00 33.66           C
ATOM    796  O   ILE    47     -16.883  47.050  18.031  1.00 36.10           O
ATOM    798  N   LYS    48     -15.798  45.270  18.901  1.00 33.32           N
ATOM    799  CA  LYS    48     -14.550  45.963  19.207  1.00 31.72           C
ATOM    801  CB  LYS    48     -13.689  45.068  20.118  1.00 31.65           C
ATOM    804  CG  LYS    48     -14.387  44.729  21.453  1.00 39.44           C
ATOM    807  CD  LYS    48     -14.892  46.002  22.158  1.00 43.13           C
ATOM    810  CE  LYS    48     -15.676  45.714  23.404  1.00 47.78           C
ATOM    813  NZ  LYS    48     -16.182  47.011  23.956  1.00 44.33           N
ATOM    817  C   LYS    48     -13.751  46.353  17.977  1.00 33.20           C
ATOM    818  O   LYS    48     -13.014  47.339  18.022  1.00 27.97           O
ATOM    820  N   GLN    49     -13.914  45.583  16.895  1.00 30.48           N
ATOM    821  CA  GLN    49     -13.217  45.843  15.662  1.00 32.30           C
ATOM    823  CB  GLN    49     -12.049  44.864  15.505  1.00 29.28           C
ATOM    826  CG  GLN    49     -11.013  45.463  14.632  1.00 39.19           C
ATOM    829  CD  GLN    49      -9.769  44.633  14.478  1.00 36.19           C
ATOM    830  OE1 GLN    49      -8.860  45.072  13.783  1.00 40.56           O
ATOM    831  NE2 GLN    49      -9.711  43.427  15.107  1.00 33.13           N
ATOM    834  C   GLN    49     -14.181  45.755  14.477  1.00 28.07           C
ATOM    835  O   GLN    49     -14.234  44.724  13.793  1.00 28.15           O
ATOM    837  N   PRO    50     -14.949  46.835  14.245  1.00 29.22           N
ATOM    838  CA  PRO    50     -15.875  46.936  13.125  1.00 27.66           C
ATOM    840  CB  PRO    50     -16.369  48.378  13.211  1.00 30.49           C
ATOM    843  CG  PRO    50     -16.195  48.758  14.591  1.00 36.52           C
ATOM    846  CD  PRO    50     -15.042  48.013  15.122  1.00 26.98           C
ATOM    849  C   PRO    50     -15.126  46.763  11.815  1.00 31.26           C
ATOM    850  O   PRO    50     -14.027  47.278  11.679  1.00 23.71           O
ATOM    851  N   MET    51     -15.696  46.044  10.861  1.00 21.15           N
ATOM    852  CA  MET    51     -15.055  45.935   9.533  1.00 22.60           C
ATOM    854  CB  MET    51     -14.158  44.700   9.485  1.00 21.22           C
ATOM    857  CG  MET    51     -13.218  44.584   8.232  1.00 20.96           C
ATOM    860  SD  MET    51     -12.243  46.051   7.847  1.00 26.36           S
ATOM    861  CE  MET    51     -11.246  46.176   9.359  1.00 22.19           C
ATOM    865  C   MET    51     -16.166  45.867   8.493  1.00 23.15           C
ATOM    866  O   MET    51     -17.221  45.344   8.772  1.00 23.61           O
ATOM    868  N   ASP    52     -15.924  46.436   7.328  1.00 24.76           N
ATOM    869  CA  ASP    52     -16.879  46.392   6.231  1.00 27.19           C
ATOM    871  CB  ASP    52     -17.922  47.511   6.360  1.00 26.13           C
ATOM    874  CG  ASP    52     -17.330  48.890   6.169  1.00 29.38           C
ATOM    875  OD1 ASP    52     -16.775  49.471   7.125  1.00 45.75           O
ATOM    876  OD2 ASP    52     -17.407  49.400   5.059  1.00 31.49           O
ATOM    877  C   ASP    52     -16.084  46.513   4.949  1.00 24.29           C
ATOM    878  O   ASP    52     -14.881  46.799   4.992  1.00 20.17           O
ATOM    880  N   LEU    53     -16.745  46.316   3.812  1.00 19.93           N
ATOM    881  CA  LEU    53     -16.042  46.295   2.513  1.00 22.93           C
ATOM    883  CB  LEU    53     -16.947  45.717   1.416  1.00 23.99           C
ATOM    886  CG  LEU    53     -17.426  44.279   1.629  1.00 25.34           C
ATOM    888  CD1 LEU    53     -18.492  43.886   0.568  1.00 17.36           C
ATOM    892  CD2 LEU    53     -16.274  43.274   1.667  1.00 17.56           C
ATOM    896  C   LEU    53     -15.496  47.665   2.091  1.00 25.54           C
ATOM    897  O   LEU    53     -14.483  47.745   1.360  1.00 19.91           O
ATOM    899  N   SER    54     -16.118  48.753   2.553  1.00 28.29           N
ATOM    900  CA  SER    54     -15.543  50.087   2.272  1.00 25.79           C
ATOM    902  CB  SER    54     -16.504  51.211   2.684  0.50 23.77           C
ATOM    908  OG  SER    54     -16.659  51.265   4.097  0.50 28.65           O
ATOM    912  C   SER    54     -14.227  50.281   3.014  1.00 20.81           C
ATOM    913  O   SER    54     -13.287  50.890   2.484  1.00 25.29           O
ATOM    915  N   SER    55     -14.176  49.791   4.241  1.00 23.85           N
ATOM    916  CA  SER    55     -12.940  49.887   5.038  1.00 28.64           C
ATOM    918  CB  SER    55     -13.218  49.548   6.498  1.00 26.98           C
ATOM    921  OG  SER    55     -14.248  50.389   7.006  1.00 35.24           O
ATOM    923  C   SER    55     -11.851  48.986   4.446  1.00 24.61           C
ATOM    924  O   SER    55     -10.673  49.347   4.432  1.00 22.37           O
ATOM    926  N   VAL    56     -12.257  47.833   3.912  1.00 22.80           N
ATOM    927  CA  VAL    56     -11.319  46.945   3.189  1.00 18.59           C
ATOM    929  CB  VAL    56     -11.984  45.581   2.798  1.00 17.04           C
ATOM    931  CG1 VAL    56     -11.131  44.796   1.802  1.00 18.98           C
ATOM    935  CG2 VAL    56     -12.279  44.718   4.064  1.00 19.48           C
ATOM    939  C   VAL    56     -10.697  47.650   1.997  1.00 17.03           C
ATOM    940  O   VAL    56      -9.478  47.572   1.825  1.00 19.42           O
ATOM    942  N   ILE    57     -11.496  48.352   1.177  1.00 17.41           N
ATOM    943  CA  ILE    57     -10.955  49.092   0.032  1.00 20.50           C
ATOM    945  CB  ILE    57     -12.062  49.736  -0.876  1.00 23.10           C
ATOM    947  CG1 ILE    57     -12.835  48.672  -1.676  1.00 22.23           C
ATOM    950  CD1 ILE    57     -12.019  48.001  -2.756  1.00 28.19           C
ATOM    954  CG2 ILE    57     -11.454  50.774  -1.819  1.00 25.28           C
ATOM    958  C   ILE    57      -9.960  50.162   0.503  1.00 19.54           C
ATOM    959  O   ILE    57      -8.878  50.288  -0.056  1.00 17.87           O
ATOM    961  N   SER    58     -10.317  50.912   1.539  1.00 23.61           N
ATOM    962  CA  SER    58      -9.392  51.897   2.129  1.00 21.37           C
ATOM    964  CB  SER    58     -10.054  52.624   3.304  1.00 26.17           C
ATOM    967  OG  SER    58     -11.054  53.483   2.846  1.00 29.50           O
ATOM    969  C   SER    58      -8.045  51.272   2.584  1.00 18.72           C
ATOM    970  O   SER    58      -6.973  51.822   2.297  1.00 21.54           O
ATOM    972  N   LYS    59      -8.108  50.123   3.249  1.00 20.54           N
ATOM    973  CA  LYS    59      -6.924  49.433   3.712  1.00 16.63           C
ATOM    975  CB  LYS    59      -7.293  48.329   4.700  1.00 17.74           C
ATOM    978  CG  LYS    59      -7.723  48.901   6.077  1.00 21.37           C
ATOM    981  CD  LYS    59      -8.114  47.798   7.067  1.00 19.34           C
ATOM    984  CE  LYS    59      -6.893  47.119   7.670  1.00 20.09           C
ATOM    987  NZ  LYS    59      -7.200  46.047   8.619  1.00 19.43           N
ATOM    991  C   LYS    59      -6.034  48.918   2.559  1.00 15.54           C
ATOM    992  O   LYS    59      -4.816  48.973   2.659  1.00 16.76           O
ATOM    994  N   ILE    60      -6.643  48.453   1.467  1.00 17.14           N
ATOM    995  CA  ILE    60      -5.871  48.056   0.280  1.00 17.12           C
ATOM    997  CB  ILE    60      -6.783  47.630  -0.911  1.00 18.90           C
ATOM    999  CG1 ILE    60      -7.619  46.371  -0.546  1.00 20.67           C
ATOM   1002  CD1 ILE    60      -8.756  46.014  -1.549  1.00 16.51           C
ATOM   1006  CG2 ILE    60      -5.914  47.410  -2.191  1.00 15.27           C
ATOM   1010  C   ILE    60      -4.983  49.238  -0.173  1.00 16.88           C
ATOM   1011  O   ILE    60      -3.762  49.112  -0.345  1.00 18.43           O
ATOM   1013  N   ASP    61      -5.640  50.373  -0.349  1.00 18.18           N
ATOM   1014  CA  ASP    61      -5.022  51.581  -0.838  1.00 21.27           C
ATOM   1016  CB  ASP    61      -6.111  52.614  -1.131  1.00 20.70           C
ATOM   1019  CG  ASP    61      -6.998  52.220  -2.305  1.00 32.84           C
ATOM   1020  OD1 ASP    61      -6.667  51.259  -3.026  1.00 27.00           O
ATOM   1021  OD2 ASP    61      -8.033  52.884  -2.509  1.00 25.46           O
ATOM   1022  C   ASP    61      -3.976  52.136   0.138  1.00 24.20           C
ATOM   1023  O   ASP    61      -2.950  52.691  -0.290  1.00 21.34           O
ATOM   1025  N   LEU    62      -4.190  51.924   1.436  1.00 22.90           N
ATOM   1026  CA  LEU    62      -3.176  52.248   2.457  1.00 23.80           C
ATOM   1028  CB  LEU    62      -3.850  52.442   3.827  1.00 18.19           C
ATOM   1031  CG  LEU    62      -4.757  53.639   4.064  1.00 23.24           C
ATOM   1033  CD1 LEU    62      -5.442  53.427   5.439  1.00 20.00           C
ATOM   1037  CD2 LEU    62      -3.927  54.941   4.004  1.00 20.71           C
ATOM   1041  C   LEU    62      -2.071  51.194   2.585  1.00 24.78           C
ATOM   1042  O   LEU    62      -1.231  51.288   3.456  1.00 23.89           O
ATOM   1044  N   HIS    63      -2.050  50.185   1.712  1.00 21.03           N
ATOM   1045  CA  HIS    63      -1.018  49.156   1.698  1.00 18.83           C
ATOM   1047  CB  HIS    63       0.395  49.728   1.399  1.00 22.34           C
ATOM   1050  CG  HIS    63       0.488  50.497   0.129  1.00 22.10           C
ATOM   1051  ND1 HIS    63       1.698  50.841  -0.426  1.00 25.42           N
ATOM   1053  CE1 HIS    63       1.486  51.534  -1.530  1.00 20.87           C
ATOM   1055  NE2 HIS    63       0.184  51.589  -1.748  1.00 27.01           N
ATOM   1057  CD2 HIS    63      -0.462  50.954  -0.722  1.00 27.64           C
ATOM   1059  C   HIS    63      -0.971  48.336   2.982  1.00 21.67           C
ATOM   1060  O   HIS    63       0.070  47.885   3.388  1.00 22.07           O
ATOM   1062  N   LYS    64      -2.122  48.098   3.586  1.00 22.14           N
ATOM   1063  CA  LYS    64      -2.188  47.316   4.796  1.00 21.91           C
ATOM   1065  CB  LYS    64      -3.440  47.663   5.583  1.00 19.04           C
ATOM   1068  CG  LYS    64      -3.536  49.112   5.934  1.00 24.59           C
ATOM   1071  CD  LYS    64      -2.562  49.504   6.961  1.00 30.67           C
ATOM   1074  CE  LYS    64      -2.888  50.916   7.485  1.00 48.26           C
ATOM   1077  NZ  LYS    64      -2.018  51.276   8.627  1.00 47.20           N
ATOM   1081  C   LYS    64      -2.194  45.831   4.565  1.00 23.75           C
ATOM   1082  O   LYS    64      -1.981  45.077   5.507  1.00 18.75           O
ATOM   1084  N   TYR    65      -2.463  45.407   3.337  1.00 21.37           N
ATOM   1085  CA  TYR    65      -2.490  43.990   3.044  1.00 17.52           C
ATOM   1087  CB  TYR    65      -3.788  43.577   2.327  1.00 15.32           C
ATOM   1090  CG  TYR    65      -5.083  43.992   3.050  1.00 16.36           C
ATOM   1091  CD1 TYR    65      -5.359  43.565   4.331  1.00 19.84           C
ATOM   1093  CE1 TYR    65      -6.552  43.924   4.968  1.00 19.40           C
ATOM   1095  CZ  TYR    65      -7.501  44.701   4.296  1.00 15.48           C
ATOM   1096  OH  TYR    65      -8.679  45.058   4.902  1.00 18.10           O
ATOM   1098  CE2 TYR    65      -7.266  45.119   3.033  1.00 17.29           C
ATOM   1100  CD2 TYR    65      -6.057  44.751   2.395  1.00 16.43           C
ATOM   1102  C   TYR    65      -1.301  43.672   2.162  1.00 21.48           C
ATOM   1103  O   TYR    65      -1.258  44.066   1.007  1.00 22.79           O
ATOM   1105  N   LEU    66      -0.346  42.935   2.713  1.00 19.79           N
ATOM   1106  CA  LEU    66       0.847  42.523   1.958  1.00 23.12           C
ATOM   1108  CB  LEU    66       2.089  42.712   2.836  1.00 25.01           C
ATOM   1111  CG  LEU    66       2.439  44.137   3.294  1.00 32.61           C
ATOM   1113  CD1 LEU    66       3.862  44.119   3.908  1.00 37.41           C
ATOM   1117  CD2 LEU    66       2.368  45.115   2.195  1.00 30.09           C
ATOM   1121  C   LEU    66       0.743  41.062   1.481  1.00 22.04           C
ATOM   1122  O   LEU    66       1.557  40.601   0.688  1.00 21.03           O
ATOM   1124  N   THR    67      -0.256  40.344   1.990  1.00 20.44           N
ATOM   1125  CA  THR    67      -0.543  38.972   1.589  1.00 19.04           C
ATOM   1127  CB  THR    67       0.039  37.928   2.563  1.00 18.54           C
ATOM   1129  OG1 THR    67      -0.742  37.899   3.757  1.00 21.70           O
ATOM   1131  CG2 THR    67       1.506  38.214   2.937  1.00 20.92           C
ATOM   1135  C   THR    67      -2.077  38.771   1.534  1.00 20.22           C
ATOM   1136  O   THR    67      -2.848  39.552   2.115  1.00 18.31           O
ATOM   1138  N   VAL    68      -2.518  37.724   0.835  1.00 16.57           N
ATOM   1139  CA  VAL    68      -3.937  37.398   0.800  1.00 19.83           C
ATOM   1141  CB  VAL    68      -4.303  36.338  -0.283  1.00 19.37           C
ATOM   1143  CG1 VAL    68      -5.768  36.553  -0.786  1.00 24.52           C
ATOM   1147  CG2 VAL    68      -4.149  34.918   0.242  1.00 25.02           C
ATOM   1151  C   VAL    68      -4.424  36.961   2.180  1.00 22.55           C
ATOM   1152  O   VAL    68      -5.586  37.163   2.527  1.00 18.78           O
ATOM   1154  N   LYS    69      -3.550  36.353   2.984  1.00 22.17           N
ATOM   1155  CA  LYS    69      -3.917  36.039   4.372  1.00 26.13           C
ATOM   1157  CB  LYS    69      -2.773  35.296   5.084  1.00 33.70           C
ATOM   1160  CG  LYS    69      -2.648  33.854   4.646  1.00 34.43           C
ATOM   1163  CD  LYS    69      -1.703  33.079   5.573  1.00 45.50           C
ATOM   1168  C   LYS    69      -4.365  37.232   5.216  1.00 21.88           C
ATOM   1169  O   LYS    69      -5.357  37.131   5.952  1.00 23.88           O
ATOM   1171  N   ASP    70      -3.647  38.346   5.089  1.00 19.84           N
ATOM   1172  CA  ASP    70      -3.959  39.615   5.762  1.00 24.88           C
ATOM   1174  CB  ASP    70      -2.992  40.738   5.326  1.00 26.51           C
ATOM   1177  CG  ASP    70      -1.541  40.593   5.828  1.00 34.56           C
ATOM   1178  OD1 ASP    70      -1.244  39.787   6.721  1.00 27.92           O
ATOM   1179  OD2 ASP    70      -0.694  41.379   5.313  1.00 34.87           O
ATOM   1180  C   ASP    70      -5.381  40.087   5.352  1.00 27.16           C
ATOM   1181  O   ASP    70      -6.205  40.493   6.187  1.00 20.43           O
ATOM   1183  N   TYR    71      -5.625  40.070   4.045  1.00 23.04           N
ATOM   1184  CA  TYR    71      -6.940  40.435   3.471  1.00 17.48           C
ATOM   1186  CB  TYR    71      -6.849  40.328   1.955  1.00 19.62           C
ATOM   1189  CG  TYR    71      -8.147  40.516   1.226  1.00 15.66           C
ATOM   1190  CD1 TYR    71      -8.624  41.803   0.949  1.00 15.77           C
ATOM   1192  CE1 TYR    71      -9.795  41.991   0.265  1.00 17.42           C
ATOM   1194  CZ  TYR    71     -10.536  40.878  -0.163  1.00 18.81           C
ATOM   1195  OH  TYR    71     -11.681  41.085  -0.870  1.00 16.07           O
ATOM   1197  CE2 TYR    71     -10.079  39.593   0.061  1.00 15.40           C
ATOM   1199  CD2 TYR    71      -8.886  39.406   0.764  1.00 17.77           C
ATOM   1201  C   TYR    71      -8.074  39.536   3.979  1.00 17.40           C
ATOM   1202  O   TYR    71      -9.115  40.032   4.445  1.00 18.24           O
ATOM   1204  N   LEU    72      -7.871  38.226   3.892  1.00 18.72           N
ATOM   1205  CA  LEU    72      -8.874  37.252   4.349  1.00 21.15           C
ATOM   1207  CB  LEU    72      -8.512  35.826   3.932  1.00 16.77           C
ATOM   1210  CG  LEU    72      -8.718  35.566   2.443  1.00 25.64           C
ATOM   1212  CD1 LEU    72      -8.040  34.297   2.112  1.00 19.37           C
ATOM   1216  CD2 LEU    72     -10.215  35.535   2.012  1.00 25.53           C
ATOM   1220  C   LEU    72      -9.182  37.340   5.843  1.00 26.45           C
ATOM   1221  O   LEU    72     -10.302  37.066   6.250  1.00 23.04           O
ATOM   1223  N   ARG    73      -8.219  37.790   6.636  1.00 22.93           N
ATOM   1224  CA  ARG    73      -8.434  38.055   8.047  1.00 28.03           C
ATOM   1226  CB  ARG    73      -7.122  38.490   8.726  1.00 31.55           C
ATOM   1229  CG  ARG    73      -7.105  38.285  10.212  1.00 38.49           C
ATOM   1232  CD  ARG    73      -5.699  38.518  10.812  1.00 49.01           C
ATOM   1235  NE  ARG    73      -4.676  37.784  10.065  1.00 44.82           N
ATOM   1237  CZ  ARG    73      -3.669  38.325   9.374  1.00 55.88           C
ATOM   1238  NH1 ARG    73      -3.476  39.648   9.322  1.00 40.38           N
ATOM   1241  NH2 ARG    73      -2.831  37.518   8.726  1.00 56.97           N
ATOM   1244  C   ARG    73      -9.524  39.098   8.278  1.00 18.44           C
ATOM   1245  O   ARG    73     -10.365  38.890   9.124  1.00 19.51           O
ATOM   1247  N   ASP    74      -9.523  40.171   7.494  1.00 18.76           N
ATOM   1248  CA  ASP    74     -10.571  41.193   7.504  1.00 16.55           C
ATOM   1250  CB  ASP    74     -10.082  42.492   6.874  1.00 19.52           C
ATOM   1253  CG  ASP    74      -9.294  43.326   7.848  1.00 24.75           C
ATOM   1254  OD1 ASP    74      -9.271  42.928   9.020  1.00 20.14           O
ATOM   1255  OD2 ASP    74      -8.719  44.344   7.449  1.00 22.36           O
ATOM   1256  C   ASP    74     -11.916  40.769   6.894  1.00 21.92           C
ATOM   1257  O   ASP    74     -12.975  41.148   7.406  1.00 18.70           O
ATOM   1259  N   ILE    75     -11.886  39.980   5.830  1.00 21.18           N
ATOM   1260  CA  ILE    75     -13.126  39.305   5.348  1.00 20.67           C
ATOM   1262  CB  ILE    75     -12.861  38.455   4.056  1.00 24.95           C
ATOM   1264  CG1 ILE    75     -12.392  39.357   2.884  1.00 19.84           C
ATOM   1267  CD1 ILE    75     -13.271  40.588   2.564  1.00 17.92           C
ATOM   1271  CG2 ILE    75     -14.123  37.542   3.678  1.00 17.77           C
ATOM   1275  C   ILE    75     -13.756  38.436   6.459  1.00 20.07           C
ATOM   1276  O   ILE    75     -14.957  38.520   6.766  1.00 21.18           O
ATOM   1278  N   ASP    76     -12.930  37.612   7.072  1.00 17.12           N
ATOM   1279  CA  ASP    76     -13.336  36.803   8.192  1.00 18.83           C
ATOM   1281  CB  ASP    76     -12.186  35.905   8.657  1.00 22.83           C
ATOM   1284  CG  ASP    76     -12.043  34.652   7.827  1.00 27.23           C
ATOM   1285  OD1 ASP    76     -13.057  34.078   7.372  1.00 31.01           O
ATOM   1286  OD2 ASP    76     -10.909  34.191   7.693  1.00 27.95           O
ATOM   1287  C   ASP    76     -13.899  37.617   9.377  1.00 23.19           C
ATOM   1288  O   ASP    76     -14.831  37.168  10.037  1.00 22.31           O
ATOM   1290  N   LEU    77     -13.351  38.804   9.612  1.00 18.46           N
ATOM   1291  CA  LEU    77     -13.819  39.701  10.637  1.00 21.75           C
ATOM   1293  CB  LEU    77     -12.778  40.796  10.830  1.00 25.24           C
ATOM   1296  CG  LEU    77     -12.948  41.754  12.004  1.00 29.92           C
ATOM   1298  CD1 LEU    77     -13.038  40.979  13.351  1.00 25.12           C
ATOM   1302  CD2 LEU    77     -11.808  42.828  11.972  1.00 29.35           C
ATOM   1306  C   LEU    77     -15.234  40.301  10.317  1.00 28.76           C
ATOM   1307  O   LEU    77     -16.106  40.401  11.187  1.00 24.23           O
ATOM   1309  N   ILE    78     -15.463  40.677   9.065  1.00 25.00           N
ATOM   1310  CA  ILE    78     -16.801  41.067   8.619  1.00 24.14           C
ATOM   1312  CB  ILE    78     -16.846  41.357   7.106  1.00 22.57           C
ATOM   1314  CG1 ILE    78     -15.939  42.551   6.759  1.00 18.05           C
ATOM   1317  CD1 ILE    78     -15.865  42.959   5.251  1.00 17.41           C
ATOM   1321  CG2 ILE    78     -18.325  41.594   6.622  1.00 22.52           C
ATOM   1325  C   ILE    78     -17.788  39.956   8.967  1.00 21.73           C
ATOM   1326  O   ILE    78     -18.855  40.200   9.585  1.00 21.65           O
ATOM   1328  N   CYS    79     -17.439  38.728   8.613  1.00 20.07           N
ATOM   1329  CA  CYS    79     -18.311  37.600   8.882  1.00 23.10           C
ATOM   1331  CB  CYS    79     -17.826  36.354   8.142  1.00 20.26           C
ATOM   1334  SG  CYS    79     -18.872  34.951   8.328  1.00 27.18           S
ATOM   1336  C   CYS    79     -18.495  37.325  10.382  1.00 30.41           C
ATOM   1337  O   CYS    79     -19.635  37.266  10.875  1.00 22.37           O
ATOM   1339  N   SER    80     -17.393  37.181  11.121  1.00 21.91           N
ATOM   1340  CA  SER    80     -17.494  36.878  12.545  1.00 24.30           C
ATOM   1342  CB  SER    80     -16.095  36.547  13.140  1.00 24.35           C
ATOM   1345  OG  SER    80     -15.237  37.672  13.063  1.00 25.08           O
ATOM   1347  C   SER    80     -18.235  37.984  13.349  1.00 18.40           C
ATOM   1348  O   SER    80     -18.966  37.663  14.285  1.00 23.97           O
ATOM   1350  N   ASN    81     -18.040  39.257  13.002  1.00 20.76           N
ATOM   1351  CA  ASN    81     -18.731  40.384  13.628  1.00 23.40           C
ATOM   1353  CB  ASN    81     -18.272  41.726  13.033  1.00 18.65           C
ATOM   1356  CG  ASN    81     -16.891  42.213  13.553  1.00 23.49           C
ATOM   1357  OD1 ASN    81     -16.312  41.626  14.419  1.00 22.48           O
ATOM   1358  ND2 ASN    81     -16.394  43.279  12.976  1.00 20.38           N
ATOM   1361  C   ASN    81     -20.283  40.263  13.424  1.00 31.33           C
ATOM   1362  O   ASN    81     -21.087  40.528  14.334  1.00 26.82           O
ATOM   1364  N   ALA    82     -20.677  39.859  12.217  1.00 25.71           N
ATOM   1365  CA  ALA    82     -22.082  39.664  11.864  1.00 25.53           C
ATOM   1367  CB  ALA    82     -22.259  39.508  10.281  1.00 21.68           C
ATOM   1371  C   ALA    82     -22.675  38.493  12.648  1.00 19.47           C
ATOM   1372  O   ALA    82     -23.782  38.620  13.195  1.00 28.46           O
ATOM   1374  N   LEU    83     -21.945  37.393  12.806  1.00 22.22           N
ATOM   1375  CA  LEU    83     -22.458  36.275  13.567  1.00 23.51           C
ATOM   1377  CB  LEU    83     -21.630  34.996  13.381  1.00 25.32           C
ATOM   1380  CG  LEU    83     -21.284  34.549  11.947  1.00 34.57           C
ATOM   1382  CD1 LEU    83     -20.593  33.216  11.961  1.00 35.58           C
ATOM   1386  CD2 LEU    83     -22.467  34.549  11.013  1.00 26.17           C
ATOM   1390  C   LEU    83     -22.621  36.565  15.064  1.00 29.52           C
ATOM   1391  O   LEU    83     -23.595  36.103  15.672  1.00 26.06           O
ATOM   1393  N   GLU    84     -21.666  37.318  15.619  1.00 32.26           N
ATOM   1394  CA  GLU    84     -21.643  37.710  17.035  1.00 32.94           C
ATOM   1396  CB  GLU    84     -20.292  38.372  17.403  1.00 28.31           C
ATOM   1399  CG  GLU    84     -20.112  38.708  18.919  1.00 46.52           C
ATOM   1402  CD  GLU    84     -19.012  39.774  19.248  1.00 64.97           C
ATOM   1403  OE1 GLU    84     -19.027  40.289  20.394  1.00 62.98           O
ATOM   1404  OE2 GLU    84     -18.146  40.107  18.397  1.00 54.59           O
ATOM   1405  C   GLU    84     -22.775  38.669  17.351  1.00 24.93           C
ATOM   1406  O   GLU    84     -23.505  38.480  18.326  1.00 31.68           O
ATOM   1408  N   TYR    85     -22.917  39.687  16.517  1.00 25.04           N
ATOM   1409  CA  TYR    85     -23.859  40.737  16.750  1.00 31.73           C
ATOM   1411  CB  TYR    85     -23.552  41.964  15.894  1.00 27.37           C
ATOM   1414  CG  TYR    85     -24.285  43.193  16.424  1.00 43.81           C
ATOM   1415  CD1 TYR    85     -23.935  43.754  17.660  1.00 43.60           C
ATOM   1417  CE1 TYR    85     -24.609  44.867  18.169  1.00 51.06           C
ATOM   1419  CZ  TYR    85     -25.656  45.414  17.451  1.00 53.75           C
ATOM   1420  OH  TYR    85     -26.323  46.502  17.953  1.00 59.40           O
ATOM   1422  CE2 TYR    85     -26.032  44.869  16.232  1.00 45.06           C
ATOM   1424  CD2 TYR    85     -25.355  43.757  15.730  1.00 46.35           C
ATOM   1426  C   TYR    85     -25.312  40.326  16.468  1.00 32.29           C
ATOM   1427  O   TYR    85     -26.218  41.016  16.913  1.00 28.58           O
ATOM   1429  N   ASN    86     -25.511  39.244  15.713  1.00 32.89           N
ATOM   1430  CA  ASN    86     -26.859  38.825  15.262  1.00 31.75           C
ATOM   1432  CB  ASN    86     -27.062  39.151  13.773  1.00 32.32           C
ATOM   1435  CG  ASN    86     -26.831  40.612  13.440  1.00 31.15           C
ATOM   1436  OD1 ASN    86     -27.673  41.450  13.688  1.00 30.56           O
ATOM   1437  ND2 ASN    86     -25.687  40.919  12.835  1.00 33.47           N
ATOM   1440  C   ASN    86     -27.014  37.350  15.457  1.00 27.49           C
ATOM   1441  O   ASN    86     -27.161  36.616  14.483  1.00 31.91           O
ATOM   1443  N   PRO    87     -26.979  36.884  16.722  1.00 26.55           N
ATOM   1444  CA  PRO    87     -26.859  35.458  17.020  1.00 26.12           C
ATOM   1446  CB  PRO    87     -26.139  35.465  18.366  1.00 32.64           C
ATOM   1449  CG  PRO    87     -26.617  36.704  19.004  1.00 27.94           C
ATOM   1452  CD  PRO    87     -26.987  37.682  17.965  1.00 31.83           C
ATOM   1455  C   PRO    87     -28.190  34.720  17.191  1.00 23.77           C
ATOM   1456  O   PRO    87     -28.184  33.511  17.376  1.00 31.41           O
ATOM   1457  N   ASP    88     -29.295  35.454  17.077  1.00 29.51           N
ATOM   1458  CA  ASP    88     -30.628  34.995  17.492  1.00 30.57           C
ATOM   1460  CB  ASP    88     -31.499  36.214  17.808  1.00 33.78           C
ATOM   1463  CG  ASP    88     -31.018  36.990  19.037  1.00 44.32           C
ATOM   1464  OD1 ASP    88     -30.049  36.557  19.695  1.00 30.51           O
ATOM   1465  OD2 ASP    88     -31.618  38.042  19.343  1.00 45.37           O
ATOM   1466  C   ASP    88     -31.314  34.154  16.417  1.00 35.10           C
ATOM   1467  O   ASP    88     -30.874  34.159  15.254  1.00 27.40           O
ATOM   1469  N   ARG    89     -32.377  33.435  16.798  1.00 30.45           N
ATOM   1470  CA  ARG    89     -33.120  32.566  15.840  1.00 28.72           C
ATOM   1472  CB  ARG    89     -33.869  31.411  16.551  0.50 33.38           C
ATOM   1478  CG  ARG    89     -35.167  31.777  17.355  0.50 37.37           C
ATOM   1484  CD  ARG    89     -36.517  31.729  16.550  0.50 23.22           C
ATOM   1490  NE  ARG    89     -36.709  30.558  15.702  0.50 14.53           N
ATOM   1494  CZ  ARG    89     -37.431  30.582  14.566  0.50 21.38           C
ATOM   1496  NH1 ARG    89     -37.964  31.725  14.152  0.50 19.03           N
ATOM   1502  NH2 ARG    89     -37.589  29.485  13.816  0.50 13.40           N
ATOM   1508  C   ARG    89     -34.104  33.315  14.959  1.00 26.11           C
ATOM   1509  O   ARG    89     -34.687  32.742  14.036  1.00 29.81           O
ATOM   1511  N   ASP    90     -34.292  34.590  15.208  1.00 23.54           N
ATOM   1512  CA  ASP    90     -35.264  35.315  14.430  1.00 29.60           C
ATOM   1514  CB  ASP    90     -35.570  36.660  15.055  1.00 30.13           C
ATOM   1517  CG  ASP    90     -34.416  37.592  15.029  1.00 38.59           C
ATOM   1518  OD1 ASP    90     -34.440  38.541  14.205  1.00 51.79           O
ATOM   1519  OD2 ASP    90     -33.495  37.374  15.835  1.00 59.04           O
ATOM   1520  C   ASP    90     -34.818  35.489  12.968  1.00 31.35           C
ATOM   1521  O   ASP    90     -33.608  35.485  12.679  1.00 27.12           O
ATOM   1523  N   PRO    91     -35.796  35.658  12.057  1.00 30.02           N
ATOM   1524  CA  PRO    91     -35.509  35.719  10.624  1.00 27.31           C
ATOM   1526  CB  PRO    91     -36.888  35.982   9.996  1.00 31.62           C
ATOM   1529  CG  PRO    91     -37.870  35.529  10.995  1.00 30.59           C
ATOM   1532  CD  PRO    91     -37.249  35.720  12.332  1.00 29.64           C
ATOM   1535  C   PRO    91     -34.517  36.811  10.209  1.00 22.34           C
ATOM   1536  O   PRO    91     -33.705  36.580   9.308  1.00 20.72           O
ATOM   1537  N   GLY    92     -34.594  37.996  10.814  1.00 21.91           N
ATOM   1538  CA  GLY    92     -33.644  39.081  10.479  1.00 27.46           C
ATOM   1541  C   GLY    92     -32.189  38.688  10.774  1.00 28.37           C
ATOM   1542  O   GLY    92     -31.291  38.926   9.959  1.00 26.07           O
ATOM   1544  N   ASP    93     -31.988  38.036  11.921  1.00 29.00           N
ATOM   1545  CA  ASP    93     -30.671  37.565  12.363  1.00 28.59           C
ATOM   1547  CB  ASP    93     -30.706  37.160  13.839  1.00 27.55           C
ATOM   1550  CG  ASP    93     -30.501  38.352  14.797  1.00 29.39           C
ATOM   1551  OD1 ASP    93     -30.830  39.510  14.444  1.00 34.06           O
ATOM   1552  OD2 ASP    93     -29.975  38.111  15.906  1.00 30.80           O
ATOM   1553  C   ASP    93     -30.200  36.391  11.496  1.00 27.19           C
ATOM   1554  O   ASP    93     -29.054  36.350  11.035  1.00 22.18           O
ATOM   1556  N   ARG    94     -31.084  35.433  11.257  1.00 23.21           N
ATOM   1557  CA  ARG    94     -30.707  34.307  10.424  1.00 23.79           C
ATOM   1559  CB  ARG    94     -31.766  33.209  10.471  1.00 25.48           C
ATOM   1562  CG  ARG    94     -31.737  32.427  11.740  1.00 27.61           C
ATOM   1565  CD  ARG    94     -32.760  31.383  11.762  1.00 30.35           C
ATOM   1568  NE  ARG    94     -32.587  30.462  12.881  1.00 29.92           N
ATOM   1570  CZ  ARG    94     -33.515  29.601  13.303  1.00 44.64           C
ATOM   1571  NH1 ARG    94     -34.696  29.524  12.707  1.00 49.89           N
ATOM   1574  NH2 ARG    94     -33.253  28.800  14.329  1.00 50.28           N
ATOM   1577  C   ARG    94     -30.353  34.733   8.984  1.00 20.18           C
ATOM   1578  O   ARG    94     -29.450  34.143   8.402  1.00 24.67           O
ATOM   1580  N   LEU    95     -31.024  35.742   8.429  1.00 22.52           N
ATOM   1581  CA  LEU    95     -30.721  36.233   7.093  1.00 22.83           C
ATOM   1583  CB  LEU    95     -31.778  37.231   6.586  1.00 17.27           C
ATOM   1586  CG  LEU    95     -31.622  37.872   5.193  1.00 13.78           C
ATOM   1588  CD1 LEU    95     -31.591  36.803   4.083  1.00 17.27           C
ATOM   1592  CD2 LEU    95     -32.741  38.938   4.931  1.00 18.04           C
ATOM   1596  C   LEU    95     -29.303  36.857   7.025  1.00 27.03           C
ATOM   1597  O   LEU    95     -28.513  36.509   6.145  1.00 18.85           O
ATOM   1599  N   ILE    96     -29.003  37.775   7.935  1.00 24.56           N
ATOM   1600  CA  ILE    96     -27.664  38.412   7.975  1.00 25.27           C
ATOM   1602  CB  ILE    96     -27.557  39.557   9.048  1.00 24.78           C
ATOM   1604  CG1 ILE    96     -26.213  40.323   8.878  1.00 26.50           C
ATOM   1607  CD1 ILE    96     -26.245  41.771   9.362  1.00 33.12           C
ATOM   1611  CG2 ILE    96     -27.670  38.996  10.451  1.00 39.55           C
ATOM   1615  C   ILE    96     -26.548  37.377   8.152  1.00 19.60           C
ATOM   1616  O   ILE    96     -25.527  37.461   7.468  1.00 21.18           O
ATOM   1618  N   ARG    97     -26.758  36.383   9.014  1.00 22.09           N
ATOM   1619  CA  ARG    97     -25.730  35.337   9.236  1.00 23.22           C
ATOM   1621  CB  ARG    97     -26.055  34.442  10.418  1.00 23.31           C
ATOM   1624  CG  ARG    97     -26.059  35.147  11.791  1.00 18.24           C
ATOM   1627  CD  ARG    97     -25.825  34.149  12.895  1.00 24.44           C
ATOM   1630  NE  ARG    97     -26.714  32.993  12.966  1.00 28.83           N
ATOM   1632  CZ  ARG    97     -27.954  32.988  13.471  1.00 27.43           C
ATOM   1633  NH1 ARG    97     -28.502  34.084  13.952  1.00 30.54           N
ATOM   1636  NH2 ARG    97     -28.636  31.867  13.506  1.00 34.39           N
ATOM   1639  C   ARG    97     -25.531  34.480   8.000  1.00 23.61           C
ATOM   1640  O   ARG    97     -24.405  34.077   7.685  1.00 19.92           O
ATOM   1642  N   HIS    98     -26.632  34.171   7.313  1.00 21.18           N
ATOM   1643  CA  HIS    98     -26.543  33.431   6.046  1.00 22.64           C
ATOM   1645  CB  HIS    98     -27.941  33.050   5.530  1.00 21.77           C
ATOM   1648  CG  HIS    98     -27.908  32.137   4.350  1.00 26.85           C
ATOM   1649  ND1 HIS    98     -27.908  32.597   3.046  1.00 26.01           N
ATOM   1651  CE1 HIS    98     -27.851  31.562   2.226  1.00 24.25           C
ATOM   1653  NE2 HIS    98     -27.801  30.456   2.946  1.00 24.82           N
ATOM   1655  CD2 HIS    98     -27.832  30.790   4.278  1.00 20.83           C
ATOM   1657  C   HIS    98     -25.762  34.212   4.969  1.00 17.30           C
ATOM   1658  O   HIS    98     -24.933  33.631   4.248  1.00 18.06           O
ATOM   1660  N   ARG    99     -26.027  35.506   4.899  1.00 19.10           N
ATOM   1661  CA  ARG    99     -25.316  36.441   4.018  1.00 20.88           C
ATOM   1663  CB  ARG    99     -26.027  37.773   3.997  1.00 20.64           C
ATOM   1666  CG  ARG    99     -27.387  37.732   3.223  1.00 20.88           C
ATOM   1669  CD  ARG    99     -28.174  38.962   3.458  1.00 21.51           C
ATOM   1672  NE  ARG    99     -29.294  39.078   2.521  1.00 23.06           N
ATOM   1674  CZ  ARG    99     -30.191  40.058   2.555  1.00 20.30           C
ATOM   1675  NH1 ARG    99     -30.091  41.023   3.440  1.00 21.05           N
ATOM   1678  NH2 ARG    99     -31.181  40.093   1.678  1.00 21.17           N
ATOM   1681  C   ARG    99     -23.838  36.630   4.382  1.00 20.58           C
ATOM   1682  O   ARG    99     -22.988  36.706   3.488  1.00 17.96           O
ATOM   1684  N   ALA   100     -23.558  36.732   5.683  1.00 19.17           N
ATOM   1685  CA  ALA   100     -22.195  36.813   6.217  1.00 21.85           C
ATOM   1687  CB  ALA   100     -22.225  36.938   7.764  1.00 16.22           C
ATOM   1691  C   ALA   100     -21.351  35.615   5.791  1.00 20.05           C
ATOM   1692  O   ALA   100     -20.221  35.796   5.311  1.00 23.60           O
ATOM   1694  N   CYS   101     -21.907  34.415   5.973  1.00 21.28           N
ATOM   1695  CA  CYS   101     -21.276  33.158   5.610  1.00 21.52           C
ATOM   1697  CB  CYS   101     -22.079  31.960   6.126  1.00 28.07           C
ATOM   1700  SG  CYS   101     -21.972  31.797   7.936  1.00 31.25           S
ATOM   1702  C   CYS   101     -21.051  33.023   4.124  1.00 25.37           C
ATOM   1703  O   CYS   101     -19.999  32.501   3.714  1.00 19.19           O
ATOM   1705  N   ALA   102     -22.016  33.503   3.337  1.00 21.90           N
ATOM   1706  CA  ALA   102     -21.892  33.511   1.882  1.00 22.12           C
ATOM   1708  CB  ALA   102     -23.235  33.849   1.188  1.00 15.78           C
ATOM   1712  C   ALA   102     -20.790  34.486   1.442  1.00 20.27           C
ATOM   1713  O   ALA   102     -20.054  34.187   0.513  1.00 19.10           O
ATOM   1715  N   LEU   103     -20.716  35.655   2.073  1.00 16.83           N
ATOM   1716  CA  LEU   103     -19.665  36.644   1.771  1.00 18.39           C
ATOM   1718  CB  LEU   103     -19.805  37.899   2.654  1.00 23.15           C
ATOM   1721  CG  LEU   103     -18.663  38.922   2.545  1.00 30.05           C
ATOM   1723  CD1 LEU   103     -18.835  39.688   1.281  1.00 28.54           C
ATOM   1727  CD2 LEU   103     -18.626  39.860   3.741  1.00 37.11           C
ATOM   1731  C   LEU   103     -18.284  35.999   1.972  1.00 22.05           C
ATOM   1732  O   LEU   103     -17.399  36.073   1.096  1.00 16.43           O
ATOM   1734  N   ARG   104     -18.145  35.347   3.118  1.00 20.87           N
ATOM   1735  CA  ARG   104     -16.942  34.619   3.490  1.00 19.58           C
ATOM   1737  CB  ARG   104     -17.073  34.081   4.903  1.00 21.66           C
ATOM   1740  CG  ARG   104     -15.809  33.343   5.449  1.00 26.94           C
ATOM   1743  CD  ARG   104     -16.189  32.403   6.579  1.00 37.02           C
ATOM   1746  NE  ARG   104     -17.176  31.418   6.120  1.00 39.15           N
ATOM   1748  CZ  ARG   104     -18.107  30.830   6.873  1.00 47.77           C
ATOM   1749  NH1 ARG   104     -18.226  31.107   8.170  1.00 40.34           N
ATOM   1752  NH2 ARG   104     -18.941  29.960   6.318  1.00 32.08           N
ATOM   1755  C   ARG   104     -16.608  33.498   2.514  1.00 21.51           C
ATOM   1756  O   ARG   104     -15.502  33.451   1.985  1.00 19.81           O
ATOM   1758  N   ASP   105     -17.569  32.614   2.252  1.00 19.85           N
ATOM   1759  CA  ASP   105     -17.371  31.514   1.328  1.00 18.95           C
ATOM   1761  CB  ASP   105     -18.589  30.579   1.310  1.00 19.94           C
ATOM   1764  CG  ASP   105     -18.786  29.817   2.617  1.00 29.87           C
ATOM   1765  OD1 ASP   105     -17.890  29.804   3.497  1.00 25.79           O
ATOM   1766  OD2 ASP   105     -19.875  29.240   2.759  1.00 32.06           O
ATOM   1767  C   ASP   105     -17.071  31.980  -0.091  1.00 18.74           C
ATOM   1768  O   ASP   105     -16.165  31.416  -0.760  1.00 18.41           O
ATOM   1770  N   THR   106     -17.805  32.999  -0.550  1.00 16.32           N
ATOM   1771  CA  THR   106     -17.554  33.568  -1.857  1.00 17.31           C
ATOM   1773  CB  THR   106     -18.592  34.671  -2.215  1.00 19.60           C
ATOM   1775  OG1 THR   106     -19.910  34.091  -2.200  1.00 21.70           O
ATOM   1777  CG2 THR   106     -18.293  35.280  -3.582  1.00 21.15           C
ATOM   1781  C   THR   106     -16.110  34.103  -2.046  1.00 18.99           C
ATOM   1782  O   THR   106     -15.477  33.831  -3.076  1.00 17.74           O
ATOM   1784  N   ALA   107     -15.637  34.895  -1.094  1.00 15.61           N
ATOM   1785  CA  ALA   107     -14.289  35.420  -1.112  1.00 21.64           C
ATOM   1787  CB  ALA   107     -14.046  36.389   0.104  1.00 18.61           C
ATOM   1791  C   ALA   107     -13.247  34.298  -1.143  1.00 18.51           C
ATOM   1792  O   ALA   107     -12.335  34.325  -1.983  1.00 17.14           O
ATOM   1794  N   TYR   108     -13.401  33.301  -0.262  1.00 19.06           N
ATOM   1795  CA  TYR   108     -12.468  32.196  -0.209  1.00 20.55           C
ATOM   1797  CB  TYR   108     -12.759  31.244   0.955  1.00 19.96           C
ATOM   1800  CG  TYR   108     -12.056  31.638   2.231  1.00 25.99           C
ATOM   1801  CD1 TYR   108     -12.606  32.576   3.103  1.00 24.70           C
ATOM   1803  CE1 TYR   108     -11.952  32.927   4.290  1.00 20.39           C
ATOM   1805  CZ  TYR   108     -10.747  32.334   4.587  1.00 20.84           C
ATOM   1806  OH  TYR   108     -10.069  32.659   5.731  1.00 24.88           O
ATOM   1808  CE2 TYR   108     -10.178  31.414   3.723  1.00 24.61           C
ATOM   1810  CD2 TYR   108     -10.817  31.077   2.565  1.00 25.48           C
ATOM   1812  C   TYR   108     -12.408  31.452  -1.529  1.00 20.31           C
ATOM   1813  O   TYR   108     -11.310  31.099  -1.995  1.00 17.23           O
ATOM   1815  N   ALA   109     -13.574  31.289  -2.149  1.00 19.03           N
ATOM   1816  CA  ALA   109     -13.706  30.564  -3.412  1.00 23.11           C
ATOM   1818  CB  ALA   109     -15.176  30.300  -3.685  1.00 18.89           C
ATOM   1822  C   ALA   109     -13.061  31.284  -4.604  1.00 20.50           C
ATOM   1823  O   ALA   109     -12.427  30.638  -5.470  1.00 18.55           O
ATOM   1825  N   ILE   110     -13.267  32.605  -4.688  1.00 19.36           N
ATOM   1826  CA  ILE   110     -12.599  33.421  -5.725  1.00 21.96           C
ATOM   1828  CB  ILE   110     -13.063  34.925  -5.709  1.00 18.58           C
ATOM   1830  CG1 ILE   110     -14.535  35.027  -6.122  1.00 22.18           C
ATOM   1833  CD1 ILE   110     -15.215  36.373  -5.838  1.00 14.78           C
ATOM   1837  CG2 ILE   110     -12.170  35.812  -6.630  1.00 14.29           C
ATOM   1841  C   ILE   110     -11.071  33.311  -5.607  1.00 19.10           C
ATOM   1842  O   ILE   110     -10.372  33.040  -6.591  1.00 17.26           O
ATOM   1844  N   ILE   111     -10.561  33.544  -4.408  1.00 19.19           N
ATOM   1845  CA  ILE   111      -9.131  33.411  -4.116  1.00 25.44           C
ATOM   1847  CB  ILE   111      -8.800  33.800  -2.614  1.00 22.02           C
ATOM   1849  CG1 ILE   111      -8.927  35.319  -2.466  0.50 24.12           C
ATOM   1855  CD1 ILE   111      -8.975  35.821  -1.034  0.50 24.28           C
ATOM   1863  CG2 ILE   111      -7.377  33.351  -2.186  0.50 20.27           C
ATOM   1871  C   ILE   111      -8.594  32.012  -4.480  1.00 23.43           C
ATOM   1872  O   ILE   111      -7.521  31.889  -5.076  1.00 21.51           O
ATOM   1874  N   LYS   112      -9.331  30.970  -4.113  1.00 20.95           N
ATOM   1875  CA  LYS   112      -8.891  29.605  -4.401  1.00 25.13           C
ATOM   1877  CB  LYS   112      -9.815  28.569  -3.758  1.00 24.23           C
ATOM   1880  CG  LYS   112      -9.267  27.139  -3.851  1.00 34.87           C
ATOM   1883  CD  LYS   112     -10.337  26.124  -3.532  1.00 39.00           C
ATOM   1886  CE  LYS   112      -9.719  24.728  -3.388  1.00 41.73           C
ATOM   1889  NZ  LYS   112     -10.780  23.712  -3.284  1.00 50.37           N
ATOM   1893  C   LYS   112      -8.788  29.353  -5.898  1.00 22.73           C
ATOM   1894  O   LYS   112      -7.847  28.719  -6.353  1.00 23.80           O
ATOM   1896  N   GLU   113      -9.746  29.853  -6.661  1.00 20.61           N
ATOM   1897  CA  GLU   113      -9.742  29.692  -8.104  1.00 21.10           C
ATOM   1899  CB  GLU   113     -11.151  29.903  -8.655  1.00 24.85           C
ATOM   1902  CG  GLU   113     -11.376  29.291 -10.028  1.00 42.67           C
ATOM   1905  CD  GLU   113     -12.830  28.871 -10.218  1.00 63.40           C
ATOM   1906  OE1 GLU   113     -13.664  29.740 -10.555  1.00 53.37           O
ATOM   1907  OE2 GLU   113     -13.141  27.678 -10.014  1.00 73.30           O
ATOM   1908  C   GLU   113      -8.761  30.627  -8.834  1.00 22.80           C
ATOM   1909  O   GLU   113      -8.143  30.225  -9.814  1.00 22.99           O
ATOM   1911  N   GLU   114      -8.624  31.869  -8.371  1.00 18.16           N
ATOM   1912  CA  GLU   114      -7.987  32.916  -9.174  1.00 20.66           C
ATOM   1914  CB  GLU   114      -8.942  34.104  -9.351  1.00 17.76           C
ATOM   1917  CG  GLU   114     -10.303  33.700 -10.004  1.00 20.51           C
ATOM   1920  CD  GLU   114     -11.257  34.857 -10.154  1.00 22.62           C
ATOM   1921  OE1 GLU   114     -10.785  36.015 -10.211  1.00 23.24           O
ATOM   1922  OE2 GLU   114     -12.497  34.622 -10.190  1.00 20.23           O
ATOM   1923  C   GLU   114      -6.638  33.436  -8.660  1.00 17.59           C
ATOM   1924  O   GLU   114      -5.978  34.135  -9.388  1.00 22.00           O
ATOM   1926  N   LEU   115      -6.264  33.152  -7.424  1.00 17.35           N
ATOM   1927  CA  LEU   115      -4.969  33.587  -6.918  1.00 22.63           C
ATOM   1929  CB  LEU   115      -5.031  34.089  -5.488  1.00 25.32           C
ATOM   1932  CG  LEU   115      -3.736  34.808  -5.019  1.00 27.81           C
ATOM   1934  CD1 LEU   115      -3.541  36.132  -5.784  1.00 29.99           C
ATOM   1938  CD2 LEU   115      -3.802  35.013  -3.544  1.00 34.72           C
ATOM   1942  C   LEU   115      -3.995  32.413  -7.027  1.00 22.59           C
ATOM   1943  O   LEU   115      -4.200  31.351  -6.437  1.00 25.27           O
ATOM   1945  N   ASP   116      -2.956  32.608  -7.823  1.00 26.87           N
ATOM   1946  CA  ASP   116      -1.931  31.598  -8.001  1.00 21.26           C
ATOM   1948  CB  ASP   116      -0.940  32.039  -9.085  1.00 24.60           C
ATOM   1951  CG  ASP   116      -0.014  30.945  -9.463  1.00 32.72           C
ATOM   1952  OD1 ASP   116       0.802  30.520  -8.621  1.00 35.85           O
ATOM   1953  OD2 ASP   116      -0.116  30.482 -10.603  1.00 30.51           O
ATOM   1954  C   ASP   116      -1.217  31.405  -6.686  1.00 19.88           C
ATOM   1955  O   ASP   116      -0.797  32.367  -6.070  1.00 17.18           O
ATOM   1957  N   GLU   117      -1.072  30.153  -6.273  1.00 19.70           N
ATOM   1958  CA  GLU   117      -0.423  29.793  -5.015  1.00 21.71           C
ATOM   1960  CB  GLU   117      -0.505  28.281  -4.806  1.00 24.97           C
ATOM   1963  CG  GLU   117      -1.873  27.805  -4.351  1.00 47.68           C
ATOM   1966  CD  GLU   117      -1.993  26.281  -4.377  1.00 62.52           C
ATOM   1967  OE1 GLU   117      -1.051  25.592  -3.917  1.00 68.27           O
ATOM   1968  OE2 GLU   117      -3.025  25.781  -4.872  1.00 64.53           O
ATOM   1969  C   GLU   117       1.034  30.252  -4.904  1.00 19.02           C
ATOM   1970  O   GLU   117       1.505  30.575  -3.804  1.00 21.23           O
ATOM   1972  N   ASP   118       1.726  30.300  -6.037  1.00 21.76           N
ATOM   1973  CA  ASP   118       3.114  30.755  -6.084  1.00 23.35           C
ATOM   1975  CB  ASP   118       3.807  30.259  -7.362  1.00 23.22           C
ATOM   1978  CG  ASP   118       4.031  28.759  -7.344  1.00 23.95           C
ATOM   1979  OD1 ASP   118       4.153  28.174  -6.239  1.00 27.42           O
ATOM   1980  OD2 ASP   118       4.053  28.181  -8.419  1.00 34.51           O
ATOM   1981  C   ASP   118       3.216  32.252  -5.989  1.00 19.61           C
ATOM   1982  O   ASP   118       4.183  32.772  -5.444  1.00 21.35           O
ATOM   1984  N   PHE   119       2.205  32.953  -6.489  1.00 20.03           N
ATOM   1985  CA  PHE   119       2.117  34.407  -6.319  1.00 18.31           C
ATOM   1987  CB  PHE   119       0.999  35.022  -7.194  1.00 21.75           C
ATOM   1990  CG  PHE   119       0.877  36.501  -7.019  1.00 18.23           C
ATOM   1991  CD1 PHE   119       1.697  37.368  -7.744  1.00 20.63           C
ATOM   1993  CE1 PHE   119       1.645  38.724  -7.536  1.00 20.18           C
ATOM   1995  CZ  PHE   119       0.778  39.242  -6.595  1.00 20.66           C
ATOM   1997  CE2 PHE   119      -0.028  38.399  -5.840  1.00 21.25           C
ATOM   1999  CD2 PHE   119       0.034  37.039  -6.034  1.00 23.39           C
ATOM   2001  C   PHE   119       1.943  34.760  -4.820  1.00 20.04           C
ATOM   2002  O   PHE   119       2.636  35.652  -4.300  1.00 19.24           O
ATOM   2004  N   GLU   120       1.019  34.061  -4.149  1.00 19.65           N
ATOM   2005  CA  GLU   120       0.771  34.243  -2.721  1.00 20.07           C
ATOM   2007  CB  GLU   120      -0.452  33.418  -2.270  1.00 19.67           C
ATOM   2010  CG  GLU   120      -0.776  33.431  -0.751  1.00 18.22           C
ATOM   2013  CD  GLU   120      -0.842  34.838  -0.076  1.00 24.26           C
ATOM   2014  OE1 GLU   120      -0.993  35.867  -0.749  1.00 22.01           O
ATOM   2015  OE2 GLU   120      -0.748  34.920   1.166  1.00 31.38           O
ATOM   2016  C   GLU   120       2.011  33.896  -1.906  1.00 20.48           C
ATOM   2017  O   GLU   120       2.382  34.653  -1.004  1.00 18.84           O
ATOM   2019  N   GLN   121       2.694  32.812  -2.281  1.00 23.00           N
ATOM   2020  CA  GLN   121       3.915  32.389  -1.584  1.00 25.45           C
ATOM   2022  CB  GLN   121       4.429  31.033  -2.118  1.00 27.28           C
ATOM   2025  CG  GLN   121       5.608  30.447  -1.317  1.00 21.66           C
ATOM   2028  CD  GLN   121       5.278  30.213   0.151  1.00 33.37           C
ATOM   2029  OE1 GLN   121       4.152  29.870   0.483  1.00 32.16           O
ATOM   2030  NE2 GLN   121       6.259  30.418   1.037  1.00 26.32           N
ATOM   2033  C   GLN   121       5.004  33.462  -1.667  1.00 23.94           C
ATOM   2034  O   GLN   121       5.652  33.769  -0.654  1.00 23.54           O
ATOM   2036  N   LEU   122       5.194  34.028  -2.859  1.00 20.47           N
ATOM   2037  CA  LEU   122       6.070  35.185  -3.031  1.00 18.08           C
ATOM   2039  CB  LEU   122       6.086  35.684  -4.483  1.00 19.06           C
ATOM   2042  CG  LEU   122       7.034  36.853  -4.806  1.00 21.41           C
ATOM   2044  CD1 LEU   122       8.500  36.550  -4.318  1.00 21.01           C
ATOM   2048  CD2 LEU   122       6.981  37.263  -6.284  1.00 19.35           C
ATOM   2052  C   LEU   122       5.717  36.346  -2.102  1.00 25.99           C
ATOM   2053  O   LEU   122       6.595  36.878  -1.426  1.00 22.53           O
ATOM   2055  N   CYS   123       4.442  36.746  -2.073  1.00 24.30           N
ATOM   2056  CA  CYS   123       3.986  37.824  -1.193  1.00 22.03           C
ATOM   2058  CB  CYS   123       2.462  38.013  -1.273  1.00 19.81           C
ATOM   2061  SG  CYS   123       1.949  38.719  -2.788  1.00 20.51           S
ATOM   2063  C   CYS   123       4.406  37.543   0.250  1.00 19.76           C
ATOM   2064  O   CYS   123       4.923  38.429   0.925  1.00 23.30           O
ATOM   2066  N   GLU   124       4.219  36.302   0.677  1.00 21.51           N
ATOM   2067  CA  GLU   124       4.498  35.894   2.033  1.00 23.50           C
ATOM   2069  CB  GLU   124       3.904  34.522   2.316  1.00 25.91           C
ATOM   2072  CG  GLU   124       2.354  34.523   2.426  1.00 34.93           C
ATOM   2075  CD  GLU   124       1.753  33.122   2.570  1.00 39.26           C
ATOM   2076  OE1 GLU   124       2.507  32.196   2.922  1.00 44.00           O
ATOM   2077  OE2 GLU   124       0.531  32.934   2.324  1.00 32.86           O
ATOM   2078  C   GLU   124       6.000  35.937   2.305  1.00 27.58           C
ATOM   2079  O   GLU   124       6.425  36.363   3.373  1.00 23.27           O
ATOM   2081  N   GLU   125       6.808  35.559   1.319  1.00 28.86           N
ATOM   2082  CA  GLU   125       8.266  35.568   1.498  1.00 28.47           C
ATOM   2084  CB  GLU   125       8.964  34.623   0.483  1.00 24.02           C
ATOM   2087  CG  GLU   125       8.640  33.169   0.845  1.00 24.03           C
ATOM   2090  CD  GLU   125       9.254  32.079  -0.028  1.00 24.11           C
ATOM   2091  OE1 GLU   125      10.097  32.389  -0.885  1.00 26.14           O
ATOM   2092  OE2 GLU   125       8.870  30.893   0.175  1.00 25.13           O
ATOM   2093  C   GLU   125       8.844  36.986   1.557  1.00 25.14           C
ATOM   2094  O   GLU   125       9.702  37.240   2.379  1.00 32.10           O
ATOM   2096  N   ILE   126       8.343  37.910   0.744  1.00 18.67           N
ATOM   2097  CA  ILE   126       8.744  39.303   0.794  1.00 28.52           C
ATOM   2099  CB  ILE   126       8.101  40.129  -0.336  1.00 27.83           C
ATOM   2101  CG1 ILE   126       8.493  39.568  -1.715  1.00 26.91           C
ATOM   2104  CD1 ILE   126       7.773  40.251  -2.894  1.00 26.67           C
ATOM   2108  CG2 ILE   126       8.485  41.616  -0.217  1.00 22.12           C
ATOM   2112  C   ILE   126       8.337  39.875   2.154  1.00 36.40           C
ATOM   2113  O   ILE   126       9.156  40.463   2.873  1.00 35.06           O
ATOM   2115  N   GLN   127       7.079  39.649   2.529  1.00 35.08           N
ATOM   2116  CA  GLN   127       6.566  40.142   3.807  1.00 38.66           C
ATOM   2118  CB  GLN   127       5.108  39.735   3.995  1.00 38.13           C
ATOM   2121  CG  GLN   127       4.372  40.616   4.976  1.00 46.73           C
ATOM   2124  CD  GLN   127       3.704  39.812   6.038  1.00 64.51           C
ATOM   2125  OE1 GLN   127       4.390  39.181   6.848  1.00 56.16           O
ATOM   2126  NE2 GLN   127       2.356  39.812   6.052  1.00 51.91           N
ATOM   2129  C   GLN   127       7.425  39.636   4.995  1.00 34.69           C
ATOM   2130  O   GLN   127       7.851  40.424   5.838  1.00 33.60           O
ATOM   2132  N   GLU   128       7.683  38.335   5.043  1.00 35.26           N
ATOM   2133  CA  GLU   128       8.563  37.745   6.067  1.00 40.39           C
ATOM   2135  CB  GLU   128       8.623  36.223   5.892  1.00 41.49           C
ATOM   2138  CG  GLU   128       7.485  35.491   6.573  1.00 47.02           C
ATOM   2141  CD  GLU   128       6.930  34.334   5.760  1.00 63.09           C
ATOM   2142  OE1 GLU   128       7.704  33.634   5.067  1.00 51.55           O
ATOM   2143  OE2 GLU   128       5.699  34.126   5.826  1.00 65.34           O
ATOM   2144  C   GLU   128      10.001  38.324   6.084  1.00 45.71           C
ATOM   2145  O   GLU   128      10.679  38.302   7.119  1.00 48.40           O
ATOM   2147  N   SER   129      10.462  38.833   4.946  1.00 43.84           N
ATOM   2148  CA  SER   129      11.809  39.391   4.843  1.00 48.65           C
ATOM   2150  CB  SER   129      12.296  39.375   3.386  1.00 43.37           C
ATOM   2153  OG  SER   129      11.800  40.487   2.656  1.00 42.87           O
ATOM   2155  C   SER   129      11.874  40.812   5.408  1.00 52.03           C
ATOM   2156  O   SER   129      12.965  41.358   5.592  1.00 53.77           O
ATOM   2158  N   ARG   130      10.711  41.410   5.661  1.00 53.93           N
ATOM   2159  CA  ARG   130      10.633  42.740   6.267  1.00 59.45           C
ATOM   2161  CB  ARG   130       9.391  43.497   5.759  1.00 54.21           C
ATOM   2164  CG  ARG   130       9.681  44.307   4.492  1.00 68.78           C
ATOM   2167  CD  ARG   130       8.593  44.234   3.428  1.00 58.27           C
ATOM   2170  NE  ARG   130       9.175  44.426   2.091  1.00 71.54           N
ATOM   2172  CZ  ARG   130       8.794  45.337   1.189  1.00 79.48           C
ATOM   2173  NH1 ARG   130       9.414  45.386   0.007  1.00 73.01           N
ATOM   2176  NH2 ARG   130       7.790  46.185   1.432  1.00 82.81           N
ATOM   2179  C   ARG   130      10.653  42.648   7.793  1.00 61.53           C
ATOM   2180  O   ARG   130       9.981  41.818   8.419  1.00 64.77           O
ATOM   2182  OXT ARG   130      11.374  43.409   8.435  1.00 67.56           O
END
