
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  121 (  982),  selected  121 , name 2grc_A
# Molecule2: number of CA atoms  130 ( 1064),  selected  130 , name T0432.pdb
# PARAMETERS: 2grc_A.T0432.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    E  1449_A      S       1           -
LGA    K  1450_A      M       2           -
LGA    L  1451_A      Q       3           -
LGA    S  1452_A      -       -           -
LGA    P  1453_A      -       -           -
LGA    N  1454_A      E       4           #
LGA    P  1455_A      E       5          3.558
LGA    -       -      D       6           -
LGA    -       -      T       7           -
LGA    -       -      F       8           -
LGA    P  1456_A      R       9          1.450
LGA    N  1457_A      E      10          0.667
LGA    L  1458_A      L      11          0.977
LGA    T  1459_A      R      12          0.776
LGA    K  1460_A      I      13          0.776
LGA    K  1461_A      F      14          0.995
LGA    M  1462_A      L      15          0.919
LGA    K  1463_A      R      16          0.955
LGA    K  1464_A      N      17          1.644
LGA    I  1465_A      V      18          1.621
LGA    V  1466_A      T      19          1.085
LGA    D  1467_A      H      20          1.671
LGA    A  1468_A      R      21          2.042
LGA    V  1469_A      L      22          2.171
LGA    I  1470_A      A      23          2.207
LGA    K  1471_A      I      24          2.955
LGA    Y  1472_A      D      25          3.476
LGA    K  1473_A      -       -           -
LGA    D  1474_A      -       -           -
LGA    S  1475_A      -       -           -
LGA    S  1476_A      -       -           -
LGA    S  1477_A      -       -           -
LGA    G  1478_A      -       -           -
LGA    R  1479_A      -       -           -
LGA    Q  1480_A      K      26          1.222
LGA    L  1481_A      R      27          1.664
LGA    S  1482_A      F      28          1.171
LGA    E  1483_A      R      29          0.191
LGA    V  1484_A      V      30          0.482
LGA    F  1485_A      F      31          0.873
LGA    I  1486_A      T      32          0.878
LGA    Q  1487_A      K      33          0.923
LGA    L  1488_A      P      34          1.501
LGA    P  1489_A      V      35          2.163
LGA    S  1490_A      D      36          2.322
LGA    R  1491_A      P      37          2.005
LGA    K  1492_A      D      38          2.997
LGA    E  1493_A      E      39          2.785
LGA    L  1494_A      V      40          1.365
LGA    P  1495_A      P      41          1.319
LGA    E  1496_A      D      42          1.053
LGA    Y  1497_A      Y      43          1.107
LGA    Y  1498_A      V      44          1.390
LGA    E  1499_A      T      45          1.801
LGA    L  1500_A      V      46          0.820
LGA    I  1501_A      I      47          0.363
LGA    R  1502_A      K      48          0.472
LGA    K  1503_A      Q      49          0.398
LGA    P  1504_A      P      50          0.404
LGA    V  1505_A      M      51          0.902
LGA    D  1506_A      D      52          1.061
LGA    F  1507_A      L      53          0.858
LGA    K  1508_A      S      54          0.828
LGA    K  1509_A      S      55          0.492
LGA    I  1510_A      V      56          0.489
LGA    K  1511_A      I      57          0.352
LGA    E  1512_A      S      58          0.040
LGA    R  1513_A      K      59          0.095
LGA    I  1514_A      I      60          0.385
LGA    R  1515_A      D      61          0.876
LGA    N  1516_A      L      62          1.052
LGA    H  1517_A      H      63          0.486
LGA    K  1518_A      K      64          1.106
LGA    Y  1519_A      Y      65          1.229
LGA    R  1520_A      L      66          1.325
LGA    S  1521_A      T      67          0.988
LGA    L  1522_A      V      68          0.851
LGA    N  1523_A      K      69          0.603
LGA    D  1524_A      D      70          0.578
LGA    L  1525_A      Y      71          0.636
LGA    E  1526_A      L      72          0.500
LGA    K  1527_A      R      73          0.265
LGA    D  1528_A      D      74          0.444
LGA    V  1529_A      I      75          0.718
LGA    M  1530_A      D      76          0.371
LGA    L  1531_A      L      77          0.287
LGA    L  1532_A      I      78          0.778
LGA    C  1533_A      C      79          0.700
LGA    Q  1534_A      S      80          0.471
LGA    N  1535_A      N      81          0.361
LGA    A  1536_A      A      82          0.479
LGA    Q  1537_A      L      83          0.456
LGA    T  1538_A      E      84          0.667
LGA    F  1539_A      Y      85          0.799
LGA    N  1540_A      N      86          0.961
LGA    L  1541_A      P      87          2.461
LGA    E  1542_A      D      88          5.126
LGA    G  1543_A      R      89          5.284
LGA    -       -      D      90           -
LGA    -       -      P      91           -
LGA    -       -      G      92           -
LGA    -       -      D      93           -
LGA    S  1544_A      R      94          1.329
LGA    L  1545_A      L      95          0.531
LGA    I  1546_A      I      96          0.610
LGA    Y  1547_A      R      97          1.124
LGA    E  1548_A      H      98          1.122
LGA    D  1549_A      R      99          0.662
LGA    S  1550_A      A     100          0.282
LGA    I  1551_A      C     101          0.899
LGA    V  1552_A      A     102          1.206
LGA    L  1553_A      L     103          1.121
LGA    Q  1554_A      R     104          0.962
LGA    S  1555_A      D     105          0.630
LGA    V  1556_A      T     106          0.299
LGA    F  1557_A      A     107          0.687
LGA    T  1558_A      Y     108          0.546
LGA    S  1559_A      A     109          0.455
LGA    V  1560_A      I     110          0.836
LGA    R  1561_A      I     111          0.882
LGA    Q  1562_A      K     112          1.550
LGA    K  1563_A      E     113          1.966
LGA    I  1564_A      E     114          1.665
LGA    E  1565_A      L     115          1.040
LGA    K  1566_A      D     116          4.240
LGA    E  1567_A      -       -           -
LGA    D  1568_A      -       -           -
LGA    D  1569_A      E     117           #
LGA    -       -      D     118           -
LGA    -       -      F     119           -
LGA    -       -      E     120           -
LGA    -       -      Q     121           -
LGA    -       -      L     122           -
LGA    -       -      C     123           -
LGA    -       -      E     124           -
LGA    -       -      E     125           -
LGA    -       -      I     126           -
LGA    -       -      Q     127           -
LGA    -       -      E     128           -
LGA    -       -      S     129           -
LGA    -       -      R     130           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  121  130    5.0    105    1.50    21.90     76.549     6.544

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.943813 * X  +   0.326736 * Y  +  -0.049601 * Z  +  -2.856309
  Y_new =   0.330344 * X  +   0.928435 * Y  +  -0.169947 * Z  +  40.389347
  Z_new =  -0.009477 * X  +  -0.176783 * Y  +  -0.984204 * Z  +  19.404329 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.963867    0.177725  [ DEG:  -169.8171     10.1829 ]
  Theta =   0.009477    3.132116  [ DEG:     0.5430    179.4570 ]
  Phi   =   2.804909   -0.336683  [ DEG:   160.7095    -19.2905 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2grc_A                                        
REMARK     2: T0432.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2grc_A.T0432.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  121  130   5.0  105   1.50   21.90  76.549
REMARK  ---------------------------------------------------------- 
MOLECULE 2grc_A
HEADER    HYDROLASE                               24-APR-06   2GRC              
TITLE     1.5 A STRUCTURE OF BROMODOMAIN FROM HUMAN BRG1 PROTEIN, A             
TITLE    2 CENTRAL ATPASE OF SWI/SNF REMODELING COMPLEX                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROBABLE GLOBAL TRANSCRIPTION ACTIVATOR SNF2L4;            
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: BROMODOMAIN, RESIDUES 1448-1575;                           
COMPND   5 SYNONYM: ATP- DEPENDENT HELICASE SMARCA4, SNF2-BETA, BRG-1           
COMPND   6 PROTEIN, MITOTIC GROWTH AND TRANSCRIPTION ACTIVATOR,                 
COMPND   7 BRAHMA PROTEIN HOMOLOG 1, SWI/SNF-RELATED MATRIX-                    
COMPND   8 ASSOCIATED ACTIN-DEPENDENT REGULATOR OF CHROMATIN                    
COMPND   9 SUBFAMILY A MEMBER 4;                                                
COMPND  10 EC: 3.6.1.-;                                                         
COMPND  11 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: SMARCA4, BRG1, SNF2B, SNF2L4;                                  
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET46LIC/EK                               
KEYWDS    BROMODOMAIN, BRG1, CHROMATIN REMODELLING, ACELY-LYSINE                
KEYWDS   2 BINDING, PROTEIN-PROTEIN INTERACTIONS                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.SINGH,G.M.POPOWICZ,M.KRAJEWSKI,T.A.HOLAK                            
REVDAT   1   08-MAY-07 2GRC    0                                                
JRNL        AUTH   M.SINGH,T.A.HOLAK,G.M.POPOWICZ,M.KRAJEWSKI                   
JRNL        TITL   1.5 A STRUCTURE OF BROMODOMAIN FROM HUMAN BRG1               
JRNL        TITL 2 PROTEIN, A CENTRAL ATPASE OF SWI/SNF REMODELING              
JRNL        TITL 3 COMPLEX                                                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.50 ANGSTROMS.                                          
DBREF  2GRC A 1448  1575  UNP    P51532   SMCA4_HUMAN   1448   1575             
SEQRES   1 A  129  MET ALA GLU LYS LEU SER PRO ASN PRO PRO ASN LEU THR          
SEQRES   2 A  129  LYS LYS MET LYS LYS ILE VAL ASP ALA VAL ILE LYS TYR          
SEQRES   3 A  129  LYS ASP SER SER SER GLY ARG GLN LEU SER GLU VAL PHE          
SEQRES   4 A  129  ILE GLN LEU PRO SER ARG LYS GLU LEU PRO GLU TYR TYR          
SEQRES   5 A  129  GLU LEU ILE ARG LYS PRO VAL ASP PHE LYS LYS ILE LYS          
SEQRES   6 A  129  GLU ARG ILE ARG ASN HIS LYS TYR ARG SER LEU ASN ASP          
SEQRES   7 A  129  LEU GLU LYS ASP VAL MET LEU LEU CYS GLN ASN ALA GLN          
SEQRES   8 A  129  THR PHE ASN LEU GLU GLY SER LEU ILE TYR GLU ASP SER          
SEQRES   9 A  129  ILE VAL LEU GLN SER VAL PHE THR SER VAL ARG GLN LYS          
SEQRES  10 A  129  ILE GLU LYS GLU ASP ASP SER GLU GLY GLU GLU SER              
FORMUL   2  HOH   *165(H2 O)                                                    
CRYST1   29.860   30.330   66.820  90.00  90.28  90.00 P 1 21 1      2          
ATOM      1  N   GLU A1449       1.755  59.349   8.003  1.00 27.92           N  
ATOM      2  CA  GLU A1449       2.776  58.619   7.187  1.00 27.19           C  
ATOM      3  C   GLU A1449       2.141  57.774   6.071  1.00 25.93           C  
ATOM      4  O   GLU A1449       1.146  57.067   6.282  1.00 26.95           O  
ATOM      5  CB  GLU A1449       3.620  57.696   8.066  1.00 27.72           C  
ATOM      6  CG  GLU A1449       4.975  58.229   8.508  1.00 28.28           C  
ATOM      7  CD  GLU A1449       5.903  57.107   8.983  1.00 29.38           C  
ATOM      8  OE1 GLU A1449       7.127  57.363   9.170  1.00 29.25           O  
ATOM      9  OE2 GLU A1449       5.400  55.966   9.160  1.00 30.31           O  
ATOM     10  N   LYS A1450       2.742  57.851   4.894  1.00 23.56           N  
ATOM     11  CA  LYS A1450       2.425  56.980   3.767  1.00 21.69           C  
ATOM     12  C   LYS A1450       3.121  55.625   3.930  1.00 19.68           C  
ATOM     13  O   LYS A1450       4.323  55.582   4.208  1.00 18.37           O  
ATOM     14  CB  LYS A1450       2.963  57.617   2.488  1.00 22.54           C  
ATOM     15  CG  LYS A1450       2.025  58.588   1.812  1.00 24.76           C  
ATOM     16  CD  LYS A1450       2.298  58.643   0.310  1.00 23.81           C  
ATOM     17  CE  LYS A1450       3.501  59.476  -0.044  1.00 25.43           C  
ATOM     18  NZ  LYS A1450       3.667  59.486  -1.538  1.00 21.73           N  
ATOM     19  N   LEU A1451       2.403  54.529   3.730  1.00 17.42           N  
ATOM     20  CA  LEU A1451       3.058  53.212   3.673  1.00 15.93           C  
ATOM     21  C   LEU A1451       3.686  52.972   2.313  1.00 14.66           C  
ATOM     22  O   LEU A1451       3.186  53.464   1.281  1.00 13.51           O  
ATOM     23  CB  LEU A1451       2.092  52.056   3.999  1.00 15.21           C  
ATOM     24  CG  LEU A1451       1.555  51.993   5.444  1.00 16.65           C  
ATOM     25  CD1 LEU A1451       0.540  50.886   5.578  1.00 14.30           C  
ATOM     26  CD2 LEU A1451       2.680  51.749   6.416  1.00 16.26           C  
ATOM     27  N   SER A1452       4.766  52.193   2.302  1.00 14.66           N  
ATOM     28  CA  SER A1452       5.390  51.771   1.050  1.00 14.71           C  
ATOM     29  C   SER A1452       4.382  50.954   0.249  1.00 14.89           C  
ATOM     30  O   SER A1452       3.877  49.948   0.754  1.00 14.16           O  
ATOM     31  CB  SER A1452       6.620  50.930   1.347  1.00 14.53           C  
ATOM     32  OG  SER A1452       7.296  50.602   0.163  1.00 16.71           O  
ATOM     33  N   PRO A1453       4.092  51.374  -0.997  1.00 15.14           N  
ATOM     34  CA  PRO A1453       3.138  50.611  -1.823  1.00 14.39           C  
ATOM     35  C   PRO A1453       3.453  49.119  -1.932  1.00 14.34           C  
ATOM     36  O   PRO A1453       4.605  48.718  -1.974  1.00 14.57           O  
ATOM     37  CB  PRO A1453       3.197  51.317  -3.197  1.00 15.13           C  
ATOM     38  CG  PRO A1453       3.618  52.717  -2.869  1.00 16.48           C  
ATOM     39  CD  PRO A1453       4.583  52.581  -1.704  1.00 15.49           C  
ATOM     40  N   ASN A1454       2.407  48.291  -1.955  1.00 13.36           N  
ATOM     41  CA  ASN A1454       2.548  46.905  -2.317  1.00 13.29           C  
ATOM     42  C   ASN A1454       2.944  46.800  -3.772  1.00 14.51           C  
ATOM     43  O   ASN A1454       2.759  47.760  -4.507  1.00 14.43           O  
ATOM     44  CB  ASN A1454       1.194  46.196  -2.164  1.00 12.26           C  
ATOM     45  CG  ASN A1454       0.894  45.808  -0.728  1.00 12.80           C  
ATOM     46  OD1 ASN A1454       1.728  45.291  -0.013  1.00 12.71           O  
ATOM     47  ND2 ASN A1454      -0.333  46.041  -0.321  1.00  9.70           N  
ATOM     48  N   PRO A1455       3.455  45.622  -4.193  1.00 14.55           N  
ATOM     49  CA  PRO A1455       3.646  45.408  -5.626  1.00 15.19           C  
ATOM     50  C   PRO A1455       2.289  45.606  -6.286  1.00 15.40           C  
ATOM     51  O   PRO A1455       1.279  45.101  -5.772  1.00 14.64           O  
ATOM     52  CB  PRO A1455       4.052  43.933  -5.721  1.00 15.53           C  
ATOM     53  CG  PRO A1455       4.604  43.590  -4.381  1.00 14.57           C  
ATOM     54  CD  PRO A1455       3.841  44.446  -3.396  1.00 15.66           C  
ATOM     55  N   PRO A1456       2.231  46.329  -7.402  1.00 14.52           N  
ATOM     56  CA  PRO A1456       0.910  46.631  -7.993  1.00 14.25           C  
ATOM     57  C   PRO A1456       0.059  45.405  -8.350  1.00 14.01           C  
ATOM     58  O   PRO A1456      -1.168  45.470  -8.272  1.00 13.98           O  
ATOM     59  CB  PRO A1456       1.260  47.499  -9.221  1.00 16.05           C  
ATOM     60  CG  PRO A1456       2.601  48.036  -8.894  1.00 16.65           C  
ATOM     61  CD  PRO A1456       3.319  46.946  -8.192  1.00 15.63           C  
ATOM     62  N   ASN A1457       0.673  44.275  -8.684  1.00 13.43           N  
ATOM     63  CA  ASN A1457      -0.110  43.077  -8.977  1.00 14.46           C  
ATOM     64  C   ASN A1457      -0.802  42.550  -7.726  1.00 13.90           C  
ATOM     65  O   ASN A1457      -1.880  41.970  -7.828  1.00 13.25           O  
ATOM     66  CB  ASN A1457       0.739  41.972  -9.608  1.00 16.10           C  
ATOM     67  CG  ASN A1457       1.283  42.363 -10.966  1.00 18.50           C  
ATOM     68  OD1 ASN A1457       0.824  43.340 -11.590  1.00 24.75           O  
ATOM     69  ND2 ASN A1457       2.264  41.601 -11.443  1.00 22.78           N  
ATOM     70  N   LEU A1458      -0.196  42.753  -6.556  1.00 11.94           N  
ATOM     71  CA  LEU A1458      -0.855  42.305  -5.326  1.00 11.25           C  
ATOM     72  C   LEU A1458      -2.067  43.189  -5.037  1.00 11.19           C  
ATOM     73  O   LEU A1458      -3.163  42.695  -4.729  1.00 10.32           O  
ATOM     74  CB  LEU A1458       0.118  42.284  -4.148  1.00 10.51           C  
ATOM     75  CG  LEU A1458      -0.451  41.894  -2.777  1.00 11.71           C  
ATOM     76  CD1 LEU A1458      -1.091  40.498  -2.769  1.00 11.58           C  
ATOM     77  CD2 LEU A1458       0.633  42.000  -1.729  1.00 10.39           C  
ATOM     78  N   THR A1459      -1.889  44.496  -5.132  1.00 11.32           N  
ATOM     79  CA  THR A1459      -3.007  45.436  -5.015  1.00 11.69           C  
ATOM     80  C   THR A1459      -4.124  45.106  -5.985  1.00 11.76           C  
ATOM     81  O   THR A1459      -5.302  45.059  -5.602  1.00 10.77           O  
ATOM     82  CB  THR A1459      -2.508  46.861  -5.281  1.00 11.43           C  
ATOM     83  OG1 THR A1459      -1.515  47.164  -4.319  1.00 12.23           O  
ATOM     84  CG2 THR A1459      -3.653  47.877  -5.166  1.00 12.50           C  
ATOM     85  N   LYS A1460      -3.768  44.874  -7.247  1.00 12.65           N  
ATOM     86  CA  LYS A1460      -4.751  44.545  -8.242  1.00 14.50           C  
ATOM     87  C   LYS A1460      -5.558  43.319  -7.839  1.00 12.64           C  
ATOM     88  O   LYS A1460      -6.793  43.321  -7.926  1.00 12.89           O  
ATOM     89  CB  LYS A1460      -4.060  44.396  -9.610  1.00 14.01           C  
ATOM     90  CG  LYS A1460      -3.735  45.774 -10.226  1.00 18.89           C  
ATOM     91  CD  LYS A1460      -3.249  45.731 -11.677  1.00 18.88           C  
ATOM     92  CE  LYS A1460      -2.121  46.750 -11.926  1.00 22.91           C  
ATOM     93  NZ  LYS A1460      -0.819  46.296 -11.373  1.00 26.33           N  
ATOM     94  N   LYS A1461      -4.892  42.285  -7.331  1.00 10.51           N  
ATOM     95  CA  LYS A1461      -5.565  41.068  -6.949  1.00 11.55           C  
ATOM     96  C   LYS A1461      -6.463  41.275  -5.737  1.00 10.60           C  
ATOM     97  O   LYS A1461      -7.573  40.722  -5.692  1.00 10.44           O  
ATOM     98  CB  LYS A1461      -4.571  39.977  -6.612  1.00 12.05           C  
ATOM     99  CG  LYS A1461      -3.999  39.257  -7.793  1.00 16.30           C  
ATOM    100  CD  LYS A1461      -3.084  38.138  -7.327  1.00 20.17           C  
ATOM    101  CE  LYS A1461      -1.646  38.632  -7.158  1.00 20.49           C  
ATOM    102  NZ  LYS A1461      -0.673  37.508  -6.982  1.00 21.53           N  
ATOM    103  N   MET A1462      -6.012  42.061  -4.756  1.00  9.73           N  
ATOM    104  CA  MET A1462      -6.881  42.406  -3.630  1.00 10.53           C  
ATOM    105  C   MET A1462      -8.164  43.079  -4.097  1.00  9.90           C  
ATOM    106  O   MET A1462      -9.265  42.727  -3.657  1.00 10.42           O  
ATOM    107  CB  MET A1462      -6.175  43.335  -2.663  1.00  9.14           C  
ATOM    108  CG  MET A1462      -4.981  42.721  -1.979  1.00 11.48           C  
ATOM    109  SD  MET A1462      -4.092  43.963  -0.995  1.00 11.03           S  
ATOM    110  CE  MET A1462      -2.929  42.935  -0.095  1.00 11.98           C  
ATOM    111  N   LYS A1463      -8.027  44.031  -5.001  1.00 10.29           N  
ATOM    112  CA  LYS A1463      -9.172  44.749  -5.521  1.00 11.10           C  
ATOM    113  C   LYS A1463     -10.126  43.836  -6.276  1.00 11.60           C  
ATOM    114  O   LYS A1463     -11.338  43.903  -6.063  1.00 11.10           O  
ATOM    115  CB  LYS A1463      -8.682  45.875  -6.412  1.00 10.75           C  
ATOM    116  CG  LYS A1463      -8.171  47.054  -5.650  1.00 15.11           C  
ATOM    117  CD  LYS A1463      -7.453  48.022  -6.567  1.00 19.43           C  
ATOM    118  CE  LYS A1463      -7.242  49.362  -5.904  1.00 24.42           C  
ATOM    119  NZ  LYS A1463      -6.633  50.291  -6.887  1.00 25.57           N  
ATOM    120  N   LYS A1464      -9.585  42.957  -7.120  1.00 12.16           N  
ATOM    121  CA  LYS A1464     -10.440  42.065  -7.910  1.00 11.94           C  
ATOM    122  C   LYS A1464     -11.216  41.117  -7.005  1.00 11.36           C  
ATOM    123  O   LYS A1464     -12.390  40.844  -7.248  1.00 12.35           O  
ATOM    124  CB  LYS A1464      -9.647  41.263  -8.943  1.00 13.18           C  
ATOM    125  CG  LYS A1464      -8.972  42.125  -9.966  1.00 16.54           C  
ATOM    126  CD  LYS A1464      -8.101  41.314 -10.925  1.00 22.70           C  
ATOM    127  CE  LYS A1464      -7.016  42.192 -11.553  1.00 25.01           C  
ATOM    128  NZ  LYS A1464      -6.895  41.984 -13.040  1.00 28.77           N  
ATOM    129  N   ILE A1465     -10.568  40.631  -5.966  1.00 10.60           N  
ATOM    130  CA  ILE A1465     -11.236  39.749  -5.014  1.00 10.68           C  
ATOM    131  C   ILE A1465     -12.368  40.471  -4.295  1.00 11.33           C  
ATOM    132  O   ILE A1465     -13.513  39.988  -4.256  1.00 11.27           O  
ATOM    133  CB  ILE A1465     -10.230  39.124  -4.012  1.00 11.45           C  
ATOM    134  CG1 ILE A1465      -9.289  38.187  -4.756  1.00 11.46           C  
ATOM    135  CG2 ILE A1465     -10.968  38.347  -2.926  1.00 10.89           C  
ATOM    136  CD1 ILE A1465      -8.036  37.895  -4.005  1.00 11.13           C  
ATOM    137  N   VAL A1466     -12.078  41.649  -3.746  1.00 10.61           N  
ATOM    138  CA  VAL A1466     -13.112  42.376  -3.018  1.00 11.46           C  
ATOM    139  C   VAL A1466     -14.247  42.773  -3.939  1.00 10.68           C  
ATOM    140  O   VAL A1466     -15.408  42.634  -3.544  1.00 10.27           O  
ATOM    141  CB  VAL A1466     -12.572  43.564  -2.223  1.00 11.29           C  
ATOM    142  CG1 VAL A1466     -13.698  44.416  -1.646  1.00 13.49           C  
ATOM    143  CG2 VAL A1466     -11.723  43.066  -1.082  1.00 11.73           C  
ATOM    144  N   ASP A1467     -13.946  43.232  -5.152  1.00 11.45           N  
ATOM    145  CA  ASP A1467     -15.009  43.586  -6.089  1.00 11.88           C  
ATOM    146  C   ASP A1467     -15.954  42.399  -6.333  1.00 12.05           C  
ATOM    147  O   ASP A1467     -17.183  42.572  -6.337  1.00 13.24           O  
ATOM    148  CB  ASP A1467     -14.429  44.104  -7.409  1.00 12.42           C  
ATOM    149  CG  ASP A1467     -13.919  45.515  -7.325  1.00 17.27           C  
ATOM    150  OD1 ASP A1467     -14.171  46.232  -6.328  1.00 22.29           O  
ATOM    151  OD2 ASP A1467     -13.259  45.923  -8.314  1.00 23.23           O  
ATOM    152  N   ALA A1468     -15.405  41.200  -6.525  1.00 11.83           N  
ATOM    153  CA  ALA A1468     -16.240  40.024  -6.817  1.00 12.24           C  
ATOM    154  C   ALA A1468     -17.083  39.609  -5.618  1.00 12.30           C  
ATOM    155  O   ALA A1468     -18.232  39.155  -5.741  1.00 13.70           O  
ATOM    156  CB  ALA A1468     -15.379  38.845  -7.277  1.00 11.83           C  
ATOM    157  N   VAL A1469     -16.510  39.739  -4.440  1.00 11.67           N  
ATOM    158  CA  VAL A1469     -17.229  39.400  -3.224  1.00 11.71           C  
ATOM    159  C   VAL A1469     -18.387  40.383  -3.046  1.00 12.15           C  
ATOM    160  O   VAL A1469     -19.507  39.989  -2.744  1.00 12.17           O  
ATOM    161  CB  VAL A1469     -16.283  39.355  -2.017  1.00 11.75           C  
ATOM    162  CG1 VAL A1469     -17.065  39.279  -0.722  1.00 14.03           C  
ATOM    163  CG2 VAL A1469     -15.287  38.159  -2.190  1.00 12.34           C  
ATOM    164  N   ILE A1470     -18.130  41.673  -3.272  1.00 11.73           N  
ATOM    165  CA  ILE A1470     -19.179  42.697  -3.164  1.00 12.70           C  
ATOM    166  C   ILE A1470     -20.323  42.488  -4.145  1.00 13.38           C  
ATOM    167  O   ILE A1470     -21.499  42.622  -3.772  1.00 13.61           O  
ATOM    168  CB  ILE A1470     -18.572  44.089  -3.327  1.00 12.01           C  
ATOM    169  CG1 ILE A1470     -17.819  44.417  -2.046  1.00 12.70           C  
ATOM    170  CG2 ILE A1470     -19.653  45.156  -3.615  1.00 12.06           C  
ATOM    171  CD1 ILE A1470     -17.023  45.714  -2.083  1.00 12.65           C  
ATOM    172  N   LYS A1471     -19.999  42.165  -5.387  1.00 14.17           N  
ATOM    173  CA  LYS A1471     -21.021  42.019  -6.427  1.00 15.63           C  
ATOM    174  C   LYS A1471     -21.815  40.705  -6.347  1.00 14.72           C  
ATOM    175  O   LYS A1471     -22.844  40.562  -7.035  1.00 15.92           O  
ATOM    176  CB  LYS A1471     -20.382  42.193  -7.818  1.00 17.12           C  
ATOM    177  CG  LYS A1471     -19.948  43.634  -8.126  1.00 18.37           C  
ATOM    178  CD  LYS A1471     -19.121  43.739  -9.403  1.00 20.22           C  
ATOM    179  CE  LYS A1471     -18.689  45.177  -9.706  1.00 21.74           C  
ATOM    180  NZ  LYS A1471     -17.980  45.269 -11.014  1.00 27.75           N  
ATOM    181  N   TYR A1472     -21.370  39.753  -5.523  1.00 14.13           N  
ATOM    182  CA  TYR A1472     -22.021  38.447  -5.486  1.00 14.48           C  
ATOM    183  C   TYR A1472     -23.503  38.599  -5.077  1.00 14.44           C  
ATOM    184  O   TYR A1472     -23.813  39.258  -4.077  1.00 13.72           O  
ATOM    185  CB  TYR A1472     -21.277  37.500  -4.542  1.00 15.46           C  
ATOM    186  CG  TYR A1472     -21.910  36.123  -4.454  1.00 15.17           C  
ATOM    187  CD1 TYR A1472     -22.839  35.832  -3.453  1.00 16.23           C  
ATOM    188  CD2 TYR A1472     -21.578  35.119  -5.352  1.00 16.88           C  
ATOM    189  CE1 TYR A1472     -23.441  34.562  -3.367  1.00 17.60           C  
ATOM    190  CE2 TYR A1472     -22.150  33.858  -5.264  1.00 17.23           C  
ATOM    191  CZ  TYR A1472     -23.080  33.590  -4.268  1.00 16.51           C  
ATOM    192  OH  TYR A1472     -23.625  32.325  -4.201  1.00 21.29           O  
ATOM    193  N   LYS A1473     -24.388  37.950  -5.832  1.00 14.96           N  
ATOM    194  CA  LYS A1473     -25.839  37.991  -5.601  1.00 16.27           C  
ATOM    195  C   LYS A1473     -26.398  36.582  -5.365  1.00 16.92           C  
ATOM    196  O   LYS A1473     -25.972  35.618  -5.999  1.00 16.62           O  
ATOM    197  CB  LYS A1473     -26.543  38.628  -6.808  1.00 16.43           C  
ATOM    198  CG  LYS A1473     -26.243  40.133  -6.936  1.00 17.07           C  
ATOM    199  CD  LYS A1473     -26.704  40.750  -8.240  1.00 18.81           C  
ATOM    200  CE  LYS A1473     -26.399  42.251  -8.218  1.00 21.81           C  
ATOM    201  NZ  LYS A1473     -26.742  42.912  -9.479  1.00 24.03           N  
ATOM    202  N   ASP A1474     -27.351  36.480  -4.443  1.00 16.95           N  
ATOM    203  CA  ASP A1474     -28.169  35.294  -4.282  1.00 17.78           C  
ATOM    204  C   ASP A1474     -28.908  35.030  -5.598  1.00 18.32           C  
ATOM    205  O   ASP A1474     -29.614  35.909  -6.090  1.00 17.81           O  
ATOM    206  CB  ASP A1474     -29.152  35.547  -3.131  1.00 18.42           C  
ATOM    207  CG  ASP A1474     -30.042  34.361  -2.845  1.00 20.13           C  
ATOM    208  OD1 ASP A1474     -29.538  33.337  -2.349  1.00 20.66           O  
ATOM    209  OD2 ASP A1474     -31.257  34.475  -3.123  1.00 23.69           O  
ATOM    210  N   SER A1475     -28.733  33.845  -6.181  1.00 19.92           N  
ATOM    211  CA  SER A1475     -29.340  33.564  -7.484  1.00 20.74           C  
ATOM    212  C   SER A1475     -30.875  33.599  -7.455  1.00 20.75           C  
ATOM    213  O   SER A1475     -31.509  34.165  -8.348  1.00 20.53           O  
ATOM    214  CB  SER A1475     -28.785  32.275  -8.120  1.00 21.59           C  
ATOM    215  OG  SER A1475     -29.365  31.091  -7.597  1.00 24.74           O  
ATOM    216  N   SER A1476     -31.468  33.067  -6.391  1.00 20.93           N  
ATOM    217  CA  SER A1476     -32.922  32.999  -6.345  1.00 22.16           C  
ATOM    218  C   SER A1476     -33.544  34.394  -6.257  1.00 21.43           C  
ATOM    219  O   SER A1476     -34.426  34.738  -7.051  1.00 23.12           O  
ATOM    220  CB  SER A1476     -33.370  32.139  -5.172  1.00 22.27           C  
ATOM    221  OG  SER A1476     -32.912  32.714  -3.970  1.00 26.43           O  
ATOM    222  N   SER A1477     -33.060  35.204  -5.312  1.00 19.35           N  
ATOM    223  CA  SER A1477     -33.682  36.492  -5.002  1.00 18.23           C  
ATOM    224  C   SER A1477     -33.010  37.708  -5.631  1.00 16.84           C  
ATOM    225  O   SER A1477     -33.586  38.802  -5.589  1.00 16.57           O  
ATOM    226  CB  SER A1477     -33.708  36.705  -3.494  1.00 17.30           C  
ATOM    227  OG  SER A1477     -32.386  36.908  -3.031  1.00 18.23           O  
ATOM    228  N   GLY A1478     -31.787  37.558  -6.127  1.00 16.34           N  
ATOM    229  CA  GLY A1478     -31.060  38.707  -6.675  1.00 14.27           C  
ATOM    230  C   GLY A1478     -30.416  39.617  -5.636  1.00 14.28           C  
ATOM    231  O   GLY A1478     -29.750  40.605  -5.981  1.00 13.52           O  
ATOM    232  N   ARG A1479     -30.590  39.277  -4.366  1.00 12.57           N  
ATOM    233  CA  ARG A1479     -30.026  40.091  -3.274  1.00 13.22           C  
ATOM    234  C   ARG A1479     -28.499  40.131  -3.304  1.00 13.01           C  
ATOM    235  O   ARG A1479     -27.840  39.100  -3.381  1.00 13.31           O  
ATOM    236  CB  ARG A1479     -30.501  39.542  -1.943  1.00 13.34           C  
ATOM    237  CG  ARG A1479     -30.081  40.323  -0.723  1.00 17.05           C  
ATOM    238  CD  ARG A1479     -30.783  39.714   0.490  1.00 20.28           C  
ATOM    239  NE  ARG A1479     -30.214  38.422   0.884  1.00 21.97           N  
ATOM    240  CZ  ARG A1479     -30.784  37.230   0.702  1.00 22.52           C  
ATOM    241  NH1 ARG A1479     -31.970  37.116   0.101  1.00 26.21           N  
ATOM    242  NH2 ARG A1479     -30.173  36.143   1.121  1.00 21.49           N  
ATOM    243  N   GLN A1480     -27.956  41.331  -3.181  1.00 13.13           N  
ATOM    244  CA  GLN A1480     -26.519  41.475  -3.059  1.00 12.53           C  
ATOM    245  C   GLN A1480     -26.172  41.184  -1.601  1.00 12.11           C  
ATOM    246  O   GLN A1480     -26.489  41.970  -0.714  1.00 12.04           O  
ATOM    247  CB  GLN A1480     -26.138  42.897  -3.457  1.00 13.33           C  
ATOM    248  CG  GLN A1480     -24.640  43.168  -3.345  1.00 14.37           C  
ATOM    249  CD  GLN A1480     -24.268  44.603  -3.662  1.00 14.85           C  
ATOM    250  OE1 GLN A1480     -24.743  45.168  -4.646  1.00 20.14           O  
ATOM    251  NE2 GLN A1480     -23.420  45.206  -2.819  1.00 14.56           N  
ATOM    252  N   LEU A1481     -25.515  40.060  -1.344  1.00 11.82           N  
ATOM    253  CA  LEU A1481     -25.291  39.652   0.036  1.00 12.52           C  
ATOM    254  C   LEU A1481     -24.535  40.711   0.822  1.00 12.19           C  
ATOM    255  O   LEU A1481     -24.789  40.924   2.002  1.00 15.62           O  
ATOM    256  CB  LEU A1481     -24.538  38.323   0.095  1.00 12.81           C  
ATOM    257  CG  LEU A1481     -25.332  37.018   0.016  1.00 16.81           C  
ATOM    258  CD1 LEU A1481     -26.353  36.997  -1.086  1.00 18.90           C  
ATOM    259  CD2 LEU A1481     -24.396  35.826  -0.076  1.00 17.01           C  
ATOM    260  N   SER A1482     -23.562  41.317   0.155  1.00 12.19           N  
ATOM    261  CA  SER A1482     -22.698  42.291   0.790  1.00 11.75           C  
ATOM    262  C   SER A1482     -23.330  43.642   1.061  1.00 10.67           C  
ATOM    263  O   SER A1482     -22.724  44.458   1.741  1.00 10.55           O  
ATOM    264  CB  SER A1482     -21.487  42.536  -0.102  1.00 11.64           C  
ATOM    265  OG  SER A1482     -21.894  43.228  -1.256  1.00 13.43           O  
ATOM    266  N   GLU A1483     -24.538  43.902   0.519  1.00 11.51           N  
ATOM    267  CA  GLU A1483     -25.034  45.292   0.550  1.00 12.34           C  
ATOM    268  C   GLU A1483     -25.198  45.847   1.960  1.00 12.32           C  
ATOM    269  O   GLU A1483     -25.097  47.039   2.179  1.00 11.17           O  
ATOM    270  CB  GLU A1483     -26.338  45.467  -0.241  1.00 12.29           C  
ATOM    271  CG  GLU A1483     -27.568  44.824   0.430  1.00 14.42           C  
ATOM    272  CD  GLU A1483     -28.727  45.773   0.612  1.00 17.25           C  
ATOM    273  OE1 GLU A1483     -29.455  45.578   1.620  1.00 14.75           O  
ATOM    274  OE2 GLU A1483     -28.903  46.703  -0.228  1.00 18.70           O  
ATOM    275  N   VAL A1484     -25.463  44.979   2.922  1.00 12.32           N  
ATOM    276  CA  VAL A1484     -25.654  45.419   4.313  1.00 12.93           C  
ATOM    277  C   VAL A1484     -24.330  45.663   5.064  1.00 13.00           C  
ATOM    278  O   VAL A1484     -24.331  46.099   6.214  1.00 13.76           O  
ATOM    279  CB  VAL A1484     -26.505  44.415   5.130  1.00 13.92           C  
ATOM    280  CG1 VAL A1484     -27.933  44.372   4.620  1.00 14.45           C  
ATOM    281  CG2 VAL A1484     -25.868  43.022   5.142  1.00 14.25           C  
ATOM    282  N   PHE A1485     -23.215  45.352   4.400  1.00 12.47           N  
ATOM    283  CA  PHE A1485     -21.890  45.409   5.001  1.00 12.37           C  
ATOM    284  C   PHE A1485     -21.017  46.465   4.361  1.00 10.52           C  
ATOM    285  O   PHE A1485     -19.852  46.566   4.663  1.00 10.97           O  
ATOM    286  CB  PHE A1485     -21.221  44.033   4.874  1.00 11.02           C  
ATOM    287  CG  PHE A1485     -21.985  42.912   5.567  1.00 11.12           C  
ATOM    288  CD1 PHE A1485     -22.323  41.774   4.870  1.00 11.11           C  
ATOM    289  CD2 PHE A1485     -22.397  43.033   6.889  1.00 13.21           C  
ATOM    290  CE1 PHE A1485     -23.056  40.740   5.488  1.00 14.89           C  
ATOM    291  CE2 PHE A1485     -23.116  42.005   7.490  1.00 12.61           C  
ATOM    292  CZ  PHE A1485     -23.440  40.878   6.786  1.00 12.90           C  
ATOM    293  N   ILE A1486     -21.581  47.247   3.458  1.00 10.00           N  
ATOM    294  CA  ILE A1486     -20.824  48.282   2.780  1.00 10.28           C  
ATOM    295  C   ILE A1486     -20.452  49.380   3.740  1.00 11.37           C  
ATOM    296  O   ILE A1486     -19.287  49.827   3.750  1.00 11.01           O  
ATOM    297  CB  ILE A1486     -21.601  48.840   1.570  1.00 11.32           C  
ATOM    298  CG1 ILE A1486     -21.952  47.695   0.616  1.00 10.00           C  
ATOM    299  CG2 ILE A1486     -20.793  49.938   0.888  1.00 12.44           C  
ATOM    300  CD1 ILE A1486     -20.746  46.906   0.148  1.00 11.66           C  
ATOM    301  N   GLN A1487     -21.442  49.836   4.511  1.00 12.21           N  
ATOM    302  CA  GLN A1487     -21.299  50.973   5.417  1.00 12.99           C  
ATOM    303  C   GLN A1487     -21.822  50.619   6.784  1.00 13.78           C  
ATOM    304  O   GLN A1487     -23.012  50.280   6.910  1.00 14.94           O  
ATOM    305  CB  GLN A1487     -22.104  52.186   4.893  1.00 12.71           C  
ATOM    306  CG  GLN A1487     -21.862  53.478   5.662  1.00 13.90           C  
ATOM    307  CD  GLN A1487     -22.502  54.705   5.019  1.00 13.91           C  
ATOM    308  OE1 GLN A1487     -22.611  54.802   3.796  1.00 15.67           O  
ATOM    309  NE2 GLN A1487     -22.938  55.656   5.862  1.00 15.73           N  
ATOM    310  N   LEU A1488     -20.952  50.709   7.798  1.00 14.97           N  
ATOM    311  CA  LEU A1488     -21.331  50.496   9.198  1.00 16.32           C  
ATOM    312  C   LEU A1488     -22.403  51.511   9.573  1.00 17.13           C  
ATOM    313  O   LEU A1488     -22.373  52.641   9.111  1.00 16.60           O  
ATOM    314  CB  LEU A1488     -20.131  50.692  10.144  1.00 16.79           C  
ATOM    315  CG  LEU A1488     -18.980  49.679  10.209  1.00 18.46           C  
ATOM    316  CD1 LEU A1488     -17.732  50.368  10.809  1.00 20.46           C  
ATOM    317  CD2 LEU A1488     -19.373  48.416  10.966  1.00 20.03           C  
ATOM    318  N   PRO A1489     -23.322  51.115  10.457  1.00 19.02           N  
ATOM    319  CA  PRO A1489     -24.274  52.109  10.941  1.00 20.00           C  
ATOM    320  C   PRO A1489     -23.521  53.060  11.867  1.00 20.47           C  
ATOM    321  O   PRO A1489     -22.492  52.674  12.425  1.00 20.60           O  
ATOM    322  CB  PRO A1489     -25.262  51.267  11.757  1.00 20.03           C  
ATOM    323  CG  PRO A1489     -24.479  50.082  12.209  1.00 20.93           C  
ATOM    324  CD  PRO A1489     -23.472  49.804  11.116  1.00 19.30           C  
ATOM    325  N   SER A1490     -23.998  54.287  12.019  1.00 21.39           N  
ATOM    326  CA  SER A1490     -23.334  55.213  12.945  1.00 23.02           C  
ATOM    327  C   SER A1490     -23.570  54.828  14.406  1.00 23.80           C  
ATOM    328  O   SER A1490     -24.545  54.147  14.741  1.00 23.07           O  
ATOM    329  CB  SER A1490     -23.754  56.666  12.686  1.00 22.97           C  
ATOM    330  OG  SER A1490     -25.019  56.946  13.264  1.00 24.79           O  
ATOM    331  N   ARG A1491     -22.651  55.276  15.260  1.00 25.28           N  
ATOM    332  CA  ARG A1491     -22.687  55.060  16.701  1.00 27.09           C  
ATOM    333  C   ARG A1491     -23.865  55.802  17.318  1.00 27.92           C  
ATOM    334  O   ARG A1491     -24.418  55.371  18.329  1.00 28.59           O  
ATOM    335  CB  ARG A1491     -21.378  55.561  17.298  1.00 27.03           C  
ATOM    336  CG  ARG A1491     -20.865  54.801  18.516  1.00 28.92           C  
ATOM    337  CD  ARG A1491     -19.397  55.136  18.691  1.00 30.96           C  
ATOM    338  NE  ARG A1491     -18.662  54.252  19.592  1.00 32.33           N  
ATOM    339  CZ  ARG A1491     -17.445  53.777  19.325  1.00 32.98           C  
ATOM    340  NH1 ARG A1491     -16.850  54.058  18.167  1.00 34.36           N  
ATOM    341  NH2 ARG A1491     -16.828  53.001  20.198  1.00 32.90           N  
ATOM    342  N   LYS A1492     -24.229  56.924  16.703  1.00 29.13           N  
ATOM    343  CA  LYS A1492     -25.457  57.649  17.026  1.00 30.31           C  
ATOM    344  C   LYS A1492     -26.703  56.808  16.767  1.00 30.62           C  
ATOM    345  O   LYS A1492     -27.598  56.737  17.618  1.00 31.23           O  
ATOM    346  CB  LYS A1492     -25.547  58.928  16.194  1.00 30.71           C  
ATOM    347  CG  LYS A1492     -25.051  60.183  16.876  1.00 31.68           C  
ATOM    348  CD  LYS A1492     -25.169  61.344  15.912  1.00 32.03           C  
ATOM    349  CE  LYS A1492     -24.752  62.665  16.536  1.00 33.11           C  
ATOM    350  NZ  LYS A1492     -25.397  63.787  15.795  1.00 34.31           N  
ATOM    351  N   GLU A1493     -26.752  56.182  15.587  1.00 30.70           N  
ATOM    352  CA  GLU A1493     -27.876  55.357  15.165  1.00 30.71           C  
ATOM    353  C   GLU A1493     -27.979  54.109  16.031  1.00 29.92           C  
ATOM    354  O   GLU A1493     -29.029  53.810  16.599  1.00 30.54           O  
ATOM    355  CB  GLU A1493     -27.705  54.940  13.696  1.00 31.35           C  
ATOM    356  CG  GLU A1493     -28.099  56.002  12.668  1.00 31.96           C  
ATOM    357  CD  GLU A1493     -27.209  55.994  11.425  1.00 33.91           C  
ATOM    358  OE1 GLU A1493     -26.900  57.106  10.931  1.00 33.85           O  
ATOM    359  OE2 GLU A1493     -26.802  54.897  10.950  1.00 31.43           O  
ATOM    360  N   LEU A1494     -26.862  53.399  16.145  1.00 28.91           N  
ATOM    361  CA  LEU A1494     -26.848  52.058  16.702  1.00 27.76           C  
ATOM    362  C   LEU A1494     -25.744  51.922  17.747  1.00 27.06           C  
ATOM    363  O   LEU A1494     -24.785  51.169  17.543  1.00 26.04           O  
ATOM    364  CB  LEU A1494     -26.669  51.012  15.582  1.00 27.83           C  
ATOM    365  CG  LEU A1494     -27.839  50.145  15.084  1.00 29.07           C  
ATOM    366  CD1 LEU A1494     -27.306  48.978  14.264  1.00 29.32           C  
ATOM    367  CD2 LEU A1494     -28.707  49.621  16.220  1.00 27.87           C  
ATOM    368  N   PRO A1495     -25.881  52.637  18.887  1.00 26.44           N  
ATOM    369  CA  PRO A1495     -24.851  52.586  19.929  1.00 26.30           C  
ATOM    370  C   PRO A1495     -24.571  51.182  20.458  1.00 25.58           C  
ATOM    371  O   PRO A1495     -23.443  50.881  20.825  1.00 26.33           O  
ATOM    372  CB  PRO A1495     -25.437  53.465  21.051  1.00 26.16           C  
ATOM    373  CG  PRO A1495     -26.873  53.582  20.752  1.00 26.61           C  
ATOM    374  CD  PRO A1495     -26.990  53.535  19.270  1.00 27.07           C  
ATOM    375  N   GLU A1496     -25.597  50.340  20.496  1.00 25.14           N  
ATOM    376  CA  GLU A1496     -25.464  48.954  20.968  1.00 25.43           C  
ATOM    377  C   GLU A1496     -24.580  48.073  20.087  1.00 24.25           C  
ATOM    378  O   GLU A1496     -23.978  47.111  20.562  1.00 24.05           O  
ATOM    379  CB  GLU A1496     -26.839  48.332  21.128  1.00 25.58           C  
ATOM    380  CG  GLU A1496     -27.651  48.991  22.225  1.00 28.70           C  
ATOM    381  CD  GLU A1496     -29.069  48.470  22.308  1.00 32.63           C  
ATOM    382  OE1 GLU A1496     -29.894  49.148  22.959  1.00 35.54           O  
ATOM    383  OE2 GLU A1496     -29.361  47.400  21.724  1.00 34.57           O  
ATOM    384  N   TYR A1497     -24.499  48.405  18.800  1.00 23.56           N  
ATOM    385  CA  TYR A1497     -23.574  47.698  17.926  1.00 23.12           C  
ATOM    386  C   TYR A1497     -22.151  47.902  18.428  1.00 22.72           C  
ATOM    387  O   TYR A1497     -21.388  46.944  18.543  1.00 21.90           O  
ATOM    388  CB  TYR A1497     -23.696  48.192  16.482  1.00 22.11           C  
ATOM    389  CG  TYR A1497     -22.826  47.424  15.513  1.00 20.52           C  
ATOM    390  CD1 TYR A1497     -21.506  47.810  15.249  1.00 19.01           C  
ATOM    391  CD2 TYR A1497     -23.320  46.291  14.870  1.00 20.69           C  
ATOM    392  CE1 TYR A1497     -20.707  47.071  14.351  1.00 19.57           C  
ATOM    393  CE2 TYR A1497     -22.546  45.558  13.985  1.00 20.68           C  
ATOM    394  CZ  TYR A1497     -21.245  45.945  13.731  1.00 20.58           C  
ATOM    395  OH  TYR A1497     -20.506  45.184  12.848  1.00 19.79           O  
ATOM    396  N   TYR A1498     -21.818  49.155  18.742  1.00 23.39           N  
ATOM    397  CA  TYR A1498     -20.482  49.496  19.205  1.00 24.04           C  
ATOM    398  C   TYR A1498     -20.216  49.102  20.660  1.00 25.08           C  
ATOM    399  O   TYR A1498     -19.073  49.158  21.108  1.00 26.13           O  
ATOM    400  CB  TYR A1498     -20.176  50.975  18.936  1.00 23.37           C  
ATOM    401  CG  TYR A1498     -20.235  51.283  17.456  1.00 22.14           C  
ATOM    402  CD1 TYR A1498     -21.456  51.528  16.822  1.00 22.78           C  
ATOM    403  CD2 TYR A1498     -19.071  51.282  16.680  1.00 22.88           C  
ATOM    404  CE1 TYR A1498     -21.523  51.779  15.443  1.00 20.02           C  
ATOM    405  CE2 TYR A1498     -19.120  51.547  15.309  1.00 23.02           C  
ATOM    406  CZ  TYR A1498     -20.352  51.787  14.702  1.00 21.24           C  
ATOM    407  OH  TYR A1498     -20.401  52.038  13.348  1.00 21.77           O  
ATOM    408  N   GLU A1499     -21.259  48.692  21.377  1.00 26.08           N  
ATOM    409  CA  GLU A1499     -21.063  48.089  22.698  1.00 27.38           C  
ATOM    410  C   GLU A1499     -20.559  46.652  22.560  1.00 26.66           C  
ATOM    411  O   GLU A1499     -19.673  46.232  23.310  1.00 27.81           O  
ATOM    412  CB  GLU A1499     -22.329  48.192  23.565  1.00 27.58           C  
ATOM    413  CG  GLU A1499     -22.672  49.643  23.966  1.00 29.24           C  
ATOM    414  CD  GLU A1499     -23.873  49.753  24.901  1.00 29.73           C  
ATOM    415  OE1 GLU A1499     -24.776  50.582  24.623  1.00 34.02           O  
ATOM    416  OE2 GLU A1499     -23.922  49.013  25.911  1.00 32.86           O  
ATOM    417  N   LEU A1500     -21.081  45.923  21.568  1.00 25.45           N  
ATOM    418  CA  LEU A1500     -20.763  44.506  21.390  1.00 24.37           C  
ATOM    419  C   LEU A1500     -19.601  44.240  20.436  1.00 23.37           C  
ATOM    420  O   LEU A1500     -18.867  43.283  20.597  1.00 24.25           O  
ATOM    421  CB  LEU A1500     -21.997  43.733  20.915  1.00 24.32           C  
ATOM    422  N   ILE A1501     -19.431  45.086  19.429  1.00 21.56           N  
ATOM    423  CA  ILE A1501     -18.426  44.801  18.399  1.00 20.00           C  
ATOM    424  C   ILE A1501     -17.222  45.716  18.590  1.00 19.70           C  
ATOM    425  O   ILE A1501     -17.329  46.912  18.345  1.00 20.12           O  
ATOM    426  CB  ILE A1501     -19.029  44.963  16.985  1.00 19.29           C  
ATOM    427  CG1 ILE A1501     -20.221  44.014  16.783  1.00 19.78           C  
ATOM    428  CG2 ILE A1501     -17.965  44.773  15.888  1.00 18.56           C  
ATOM    429  CD1 ILE A1501     -19.902  42.558  17.084  1.00 17.73           C  
ATOM    430  N   ARG A1502     -16.104  45.148  19.041  1.00 19.40           N  
ATOM    431  CA  ARG A1502     -14.953  45.953  19.452  1.00 19.69           C  
ATOM    432  C   ARG A1502     -14.074  46.421  18.299  1.00 19.23           C  
ATOM    433  O   ARG A1502     -13.391  47.450  18.421  1.00 20.57           O  
ATOM    434  CB  ARG A1502     -14.116  45.222  20.505  1.00 19.78           C  
ATOM    435  N   LYS A1503     -14.072  45.673  17.195  1.00 19.47           N  
ATOM    436  CA  LYS A1503     -13.297  46.043  15.997  1.00 18.64           C  
ATOM    437  C   LYS A1503     -14.170  46.086  14.727  1.00 18.34           C  
ATOM    438  O   LYS A1503     -14.075  45.195  13.879  1.00 17.41           O  
ATOM    439  CB  LYS A1503     -12.087  45.116  15.814  1.00 19.35           C  
ATOM    440  CG  LYS A1503     -10.814  45.645  16.519  1.00 21.94           C  
ATOM    441  CD  LYS A1503      -9.762  44.578  16.719  1.00 24.69           C  
ATOM    442  CE  LYS A1503      -8.568  45.194  17.454  1.00 26.93           C  
ATOM    443  NZ  LYS A1503      -7.831  44.226  18.320  1.00 30.34           N  
ATOM    444  N   PRO A1504     -14.997  47.143  14.589  1.00 17.54           N  
ATOM    445  CA  PRO A1504     -15.949  47.136  13.468  1.00 17.45           C  
ATOM    446  C   PRO A1504     -15.220  47.254  12.146  1.00 16.41           C  
ATOM    447  O   PRO A1504     -14.157  47.886  12.070  1.00 16.83           O  
ATOM    448  CB  PRO A1504     -16.793  48.389  13.712  1.00 17.02           C  
ATOM    449  CG  PRO A1504     -16.560  48.769  15.169  1.00 18.12           C  
ATOM    450  CD  PRO A1504     -15.133  48.363  15.404  1.00 18.65           C  
ATOM    451  N   VAL A1505     -15.779  46.635  11.114  1.00 15.69           N  
ATOM    452  CA  VAL A1505     -15.226  46.790   9.766  1.00 15.33           C  
ATOM    453  C   VAL A1505     -16.375  46.693   8.779  1.00 14.87           C  
ATOM    454  O   VAL A1505     -17.319  45.929   8.992  1.00 14.05           O  
ATOM    455  CB  VAL A1505     -14.147  45.721   9.500  1.00 16.30           C  
ATOM    456  CG1 VAL A1505     -14.703  44.322   9.688  1.00 15.54           C  
ATOM    457  CG2 VAL A1505     -13.520  45.887   8.111  1.00 17.08           C  
ATOM    458  N   ASP A1506     -16.287  47.479   7.714  1.00 13.30           N  
ATOM    459  CA  ASP A1506     -17.195  47.336   6.597  1.00 12.87           C  
ATOM    460  C   ASP A1506     -16.397  47.288   5.283  1.00 11.80           C  
ATOM    461  O   ASP A1506     -15.151  47.456   5.299  1.00 11.13           O  
ATOM    462  CB  ASP A1506     -18.219  48.483   6.585  1.00 13.04           C  
ATOM    463  CG  ASP A1506     -17.575  49.864   6.661  1.00 14.05           C  
ATOM    464  OD1 ASP A1506     -16.400  50.014   6.248  1.00 15.54           O  
ATOM    465  OD2 ASP A1506     -18.219  50.854   7.096  1.00 14.72           O  
ATOM    466  N   PHE A1507     -17.066  47.068   4.158  1.00 11.99           N  
ATOM    467  CA  PHE A1507     -16.307  47.016   2.896  1.00 10.60           C  
ATOM    468  C   PHE A1507     -15.685  48.357   2.505  1.00 11.73           C  
ATOM    469  O   PHE A1507     -14.646  48.378   1.823  1.00 12.43           O  
ATOM    470  CB  PHE A1507     -17.119  46.414   1.767  1.00  9.92           C  
ATOM    471  CG  PHE A1507     -17.220  44.933   1.842  1.00  9.12           C  
ATOM    472  CD1 PHE A1507     -18.404  44.326   2.231  1.00 10.19           C  
ATOM    473  CD2 PHE A1507     -16.104  44.134   1.580  1.00 12.36           C  
ATOM    474  CE1 PHE A1507     -18.510  42.925   2.286  1.00 11.40           C  
ATOM    475  CE2 PHE A1507     -16.196  42.727   1.635  1.00 13.68           C  
ATOM    476  CZ  PHE A1507     -17.395  42.125   2.017  1.00 12.89           C  
ATOM    477  N   LYS A1508     -16.261  49.481   2.945  1.00 11.78           N  
ATOM    478  CA  LYS A1508     -15.602  50.792   2.703  1.00 13.14           C  
ATOM    479  C   LYS A1508     -14.228  50.815   3.363  1.00 13.52           C  
ATOM    480  O   LYS A1508     -13.230  51.209   2.743  1.00 12.87           O  
ATOM    481  CB  LYS A1508     -16.445  51.971   3.208  1.00 14.79           C  
ATOM    482  CG  LYS A1508     -17.604  52.343   2.305  1.00 17.96           C  
ATOM    483  CD  LYS A1508     -18.403  53.494   2.893  1.00 22.30           C  
ATOM    484  N   LYS A1509     -14.152  50.334   4.606  1.00 12.43           N  
ATOM    485  CA  LYS A1509     -12.842  50.277   5.321  1.00 12.68           C  
ATOM    486  C   LYS A1509     -11.874  49.317   4.637  1.00 12.49           C  
ATOM    487  O   LYS A1509     -10.663  49.588   4.534  1.00 12.78           O  
ATOM    488  CB  LYS A1509     -13.014  49.837   6.778  1.00 13.43           C  
ATOM    489  CG  LYS A1509     -13.700  50.823   7.668  1.00 18.64           C  
ATOM    490  CD  LYS A1509     -13.455  50.451   9.113  1.00 22.58           C  
ATOM    491  CE  LYS A1509     -14.555  50.964  10.005  1.00 24.03           C  
ATOM    492  NZ  LYS A1509     -14.131  50.932  11.435  1.00 25.79           N  
ATOM    493  N   ILE A1510     -12.383  48.175   4.193  1.00 11.42           N  
ATOM    494  CA  ILE A1510     -11.535  47.190   3.553  1.00 11.52           C  
ATOM    495  C   ILE A1510     -10.936  47.795   2.265  1.00 11.71           C  
ATOM    496  O   ILE A1510      -9.707  47.684   2.014  1.00 10.64           O  
ATOM    497  CB  ILE A1510     -12.325  45.888   3.289  1.00 11.61           C  
ATOM    498  CG1 ILE A1510     -12.570  45.160   4.620  1.00 12.90           C  
ATOM    499  CG2 ILE A1510     -11.590  45.021   2.298  1.00 12.63           C  
ATOM    500  CD1 ILE A1510     -13.453  43.890   4.561  1.00 12.90           C  
ATOM    501  N   LYS A1511     -11.762  48.461   1.464  1.00 10.97           N  
ATOM    502  CA  LYS A1511     -11.237  49.105   0.242  1.00 12.26           C  
ATOM    503  C   LYS A1511     -10.174  50.185   0.544  1.00 12.80           C  
ATOM    504  O   LYS A1511      -9.194  50.329  -0.200  1.00 12.02           O  
ATOM    505  CB  LYS A1511     -12.364  49.662  -0.628  1.00 11.97           C  
ATOM    506  CG  LYS A1511     -13.142  48.594  -1.341  1.00 13.15           C  
ATOM    507  CD  LYS A1511     -14.298  49.157  -2.182  1.00 13.21           C  
ATOM    508  CE  LYS A1511     -15.061  48.046  -2.855  1.00 17.84           C  
ATOM    509  NZ  LYS A1511     -16.178  48.618  -3.674  1.00 19.26           N  
ATOM    510  N   GLU A1512     -10.382  50.943   1.609  1.00 12.72           N  
ATOM    511  CA  GLU A1512      -9.411  51.922   2.104  1.00 14.38           C  
ATOM    512  C   GLU A1512      -8.081  51.276   2.441  1.00 13.70           C  
ATOM    513  O   GLU A1512      -6.997  51.775   2.068  1.00 13.21           O  
ATOM    514  CB  GLU A1512      -9.977  52.592   3.356  1.00 14.69           C  
ATOM    515  CG  GLU A1512      -9.089  53.692   3.966  1.00 18.93           C  
ATOM    516  CD  GLU A1512      -9.594  54.164   5.312  1.00 19.33           C  
ATOM    517  OE1 GLU A1512      -8.775  54.606   6.144  1.00 26.52           O  
ATOM    518  OE2 GLU A1512     -10.816  54.096   5.557  1.00 26.63           O  
ATOM    519  N   ARG A1513      -8.148  50.151   3.155  1.00 12.61           N  
ATOM    520  CA  ARG A1513      -6.962  49.448   3.626  1.00 12.64           C  
ATOM    521  C   ARG A1513      -6.182  48.788   2.486  1.00 12.82           C  
ATOM    522  O   ARG A1513      -4.964  48.608   2.582  1.00 13.33           O  
ATOM    523  CB  ARG A1513      -7.357  48.460   4.719  1.00 12.37           C  
ATOM    524  CG  ARG A1513      -7.755  49.177   6.006  1.00 13.03           C  
ATOM    525  CD  ARG A1513      -8.408  48.246   7.010  1.00 16.36           C  
ATOM    526  NE  ARG A1513      -8.620  48.948   8.284  1.00 19.32           N  
ATOM    527  CZ  ARG A1513      -9.358  48.493   9.298  1.00 21.55           C  
ATOM    528  NH1 ARG A1513      -9.978  47.324   9.224  1.00 21.13           N  
ATOM    529  NH2 ARG A1513      -9.477  49.223  10.403  1.00 24.23           N  
ATOM    530  N   ILE A1514      -6.885  48.419   1.423  1.00 11.57           N  
ATOM    531  CA  ILE A1514      -6.240  48.041   0.168  1.00 11.80           C  
ATOM    532  C   ILE A1514      -5.539  49.218  -0.475  1.00 12.39           C  
ATOM    533  O   ILE A1514      -4.344  49.128  -0.789  1.00 13.33           O  
ATOM    534  CB  ILE A1514      -7.222  47.421  -0.840  1.00  9.90           C  
ATOM    535  CG1 ILE A1514      -7.738  46.057  -0.328  1.00 11.31           C  
ATOM    536  CG2 ILE A1514      -6.541  47.250  -2.214  1.00 11.92           C  
ATOM    537  CD1 ILE A1514      -8.922  45.520  -1.101  1.00  9.03           C  
ATOM    538  N   ARG A1515      -6.260  50.324  -0.638  1.00 12.78           N  
ATOM    539  CA  ARG A1515      -5.730  51.494  -1.347  1.00 13.37           C  
ATOM    540  C   ARG A1515      -4.501  52.059  -0.649  1.00 13.51           C  
ATOM    541  O   ARG A1515      -3.571  52.552  -1.330  1.00 13.85           O  
ATOM    542  CB  ARG A1515      -6.798  52.587  -1.481  1.00 14.30           C  
ATOM    543  CG  ARG A1515      -6.522  53.539  -2.610  1.00 17.41           C  
ATOM    544  N   ASN A1516      -4.510  52.019   0.687  1.00 12.60           N  
ATOM    545  CA  ASN A1516      -3.428  52.594   1.496  1.00 13.90           C  
ATOM    546  C   ASN A1516      -2.331  51.592   1.887  1.00 12.65           C  
ATOM    547  O   ASN A1516      -1.416  51.902   2.667  1.00 14.10           O  
ATOM    548  CB  ASN A1516      -3.993  53.325   2.710  1.00 15.41           C  
ATOM    549  CG  ASN A1516      -4.934  54.446   2.309  1.00 18.64           C  
ATOM    550  OD1 ASN A1516      -4.703  55.144   1.318  1.00 23.32           O  
ATOM    551  ND2 ASN A1516      -6.028  54.599   3.054  1.00 23.52           N  
ATOM    552  N   HIS A1517      -2.415  50.400   1.303  1.00 12.89           N  
ATOM    553  CA  HIS A1517      -1.391  49.358   1.461  1.00 11.50           C  
ATOM    554  C   HIS A1517      -1.266  48.835   2.885  1.00 12.01           C  
ATOM    555  O   HIS A1517      -0.206  48.305   3.287  1.00 11.37           O  
ATOM    556  CB  HIS A1517      -0.012  49.852   0.962  1.00 12.52           C  
ATOM    557  CG  HIS A1517      -0.078  50.631  -0.311  1.00 13.76           C  
ATOM    558  ND1 HIS A1517      -0.401  50.052  -1.518  1.00 13.26           N  
ATOM    559  CD2 HIS A1517       0.099  51.953  -0.562  1.00 14.70           C  
ATOM    560  CE1 HIS A1517      -0.416  50.979  -2.462  1.00 15.74           C  
ATOM    561  NE2 HIS A1517      -0.106  52.141  -1.910  1.00 14.72           N  
ATOM    562  N   LYS A1518      -2.352  48.903   3.658  1.00 11.87           N  
ATOM    563  CA  LYS A1518      -2.301  48.394   5.015  1.00 12.16           C  
ATOM    564  C   LYS A1518      -2.131  46.859   4.996  1.00 11.18           C  
ATOM    565  O   LYS A1518      -1.292  46.276   5.696  1.00 12.63           O  
ATOM    566  CB  LYS A1518      -3.567  48.780   5.807  1.00 12.51           C  
ATOM    567  CG  LYS A1518      -3.489  48.388   7.279  1.00 17.03           C  
ATOM    568  CD  LYS A1518      -4.795  48.595   8.008  1.00 23.30           C  
ATOM    569  CE  LYS A1518      -4.589  48.603   9.508  1.00 25.05           C  
ATOM    570  NZ  LYS A1518      -5.899  48.601  10.230  1.00 27.99           N  
ATOM    571  N   TYR A1519      -2.925  46.201   4.164  1.00 10.57           N  
ATOM    572  CA  TYR A1519      -2.760  44.763   3.961  1.00  9.83           C  
ATOM    573  C   TYR A1519      -1.465  44.519   3.184  1.00  9.78           C  
ATOM    574  O   TYR A1519      -1.248  45.144   2.143  1.00 11.74           O  
ATOM    575  CB  TYR A1519      -3.939  44.184   3.181  1.00  9.24           C  
ATOM    576  CG  TYR A1519      -5.314  44.491   3.727  1.00 10.40           C  
ATOM    577  CD1 TYR A1519      -6.326  44.848   2.874  1.00 11.76           C  
ATOM    578  CD2 TYR A1519      -5.569  44.415   5.087  1.00 10.37           C  
ATOM    579  CE1 TYR A1519      -7.615  45.107   3.364  1.00 11.03           C  
ATOM    580  CE2 TYR A1519      -6.843  44.642   5.597  1.00  9.88           C  
ATOM    581  CZ  TYR A1519      -7.835  45.009   4.747  1.00 10.99           C  
ATOM    582  OH  TYR A1519      -9.077  45.278   5.283  1.00 10.31           O  
ATOM    583  N   ARG A1520      -0.629  43.616   3.693  1.00  9.95           N  
ATOM    584  CA  ARG A1520       0.653  43.290   3.021  1.00 10.21           C  
ATOM    585  C   ARG A1520       0.635  41.931   2.320  1.00 11.11           C  
ATOM    586  O   ARG A1520       1.635  41.492   1.728  1.00 11.36           O  
ATOM    587  CB  ARG A1520       1.788  43.366   4.022  1.00 10.39           C  
ATOM    588  CG  ARG A1520       1.838  44.680   4.811  1.00 10.96           C  
ATOM    589  CD  ARG A1520       1.843  45.881   3.886  1.00 12.38           C  
ATOM    590  NE  ARG A1520       3.066  45.981   3.065  1.00 14.59           N  
ATOM    591  CZ  ARG A1520       3.306  46.973   2.212  1.00 14.58           C  
ATOM    592  NH1 ARG A1520       2.437  47.959   2.065  1.00 14.62           N  
ATOM    593  NH2 ARG A1520       4.447  46.991   1.525  1.00 16.10           N  
ATOM    594  N   SER A1521      -0.513  41.260   2.382  1.00 10.67           N  
ATOM    595  CA  SER A1521      -0.692  39.906   1.873  1.00 10.52           C  
ATOM    596  C   SER A1521      -2.198  39.646   1.690  1.00  9.99           C  
ATOM    597  O   SER A1521      -3.033  40.379   2.285  1.00 10.48           O  
ATOM    598  CB  SER A1521      -0.099  38.910   2.871  1.00 12.04           C  
ATOM    599  OG  SER A1521      -0.900  38.900   4.052  1.00 13.28           O  
ATOM    600  N   LEU A1522      -2.551  38.643   0.877  1.00 10.94           N  
ATOM    601  CA  LEU A1522      -3.949  38.249   0.779  1.00 10.57           C  
ATOM    602  C   LEU A1522      -4.417  37.698   2.131  1.00 11.38           C  
ATOM    603  O   LEU A1522      -5.586  37.867   2.501  1.00 11.07           O  
ATOM    604  CB  LEU A1522      -4.182  37.250  -0.358  1.00 10.37           C  
ATOM    605  CG  LEU A1522      -3.957  37.726  -1.780  1.00 12.33           C  
ATOM    606  CD1 LEU A1522      -4.455  36.695  -2.792  1.00 13.25           C  
ATOM    607  CD2 LEU A1522      -4.612  39.094  -2.021  1.00 10.05           C  
ATOM    608  N   ASN A1523      -3.533  37.061   2.899  1.00  9.78           N  
ATOM    609  CA  ASN A1523      -3.931  36.630   4.255  1.00 11.05           C  
ATOM    610  C   ASN A1523      -4.440  37.795   5.111  1.00 11.58           C  
ATOM    611  O   ASN A1523      -5.462  37.655   5.802  1.00 12.43           O  
ATOM    612  CB  ASN A1523      -2.741  35.962   4.951  1.00 12.45           C  
ATOM    613  CG  ASN A1523      -3.102  35.418   6.312  1.00 13.86           C  
ATOM    614  OD1 ASN A1523      -2.570  35.862   7.340  1.00 17.95           O  
ATOM    615  ND2 ASN A1523      -4.041  34.490   6.328  1.00 15.68           N  
ATOM    616  N   ASP A1524      -3.767  38.944   5.044  1.00 10.36           N  
ATOM    617  CA  ASP A1524      -4.161  40.156   5.795  1.00 10.48           C  
ATOM    618  C   ASP A1524      -5.553  40.585   5.343  1.00 10.48           C  
ATOM    619  O   ASP A1524      -6.429  40.834   6.185  1.00 10.95           O  
ATOM    620  CB  ASP A1524      -3.197  41.319   5.576  1.00 11.46           C  
ATOM    621  CG  ASP A1524      -1.882  41.135   6.297  1.00 11.48           C  
ATOM    622  OD1 ASP A1524      -1.798  40.311   7.214  1.00 14.12           O  
ATOM    623  OD2 ASP A1524      -0.915  41.840   5.942  1.00 14.05           O  
ATOM    624  N   LEU A1525      -5.764  40.668   4.031  1.00  9.84           N  
ATOM    625  CA  LEU A1525      -7.069  41.057   3.506  1.00 10.04           C  
ATOM    626  C   LEU A1525      -8.115  40.065   4.004  1.00 10.91           C  
ATOM    627  O   LEU A1525      -9.180  40.490   4.486  1.00 11.08           O  
ATOM    628  CB  LEU A1525      -7.028  41.141   1.979  1.00 10.59           C  
ATOM    629  CG  LEU A1525      -8.412  41.122   1.312  1.00  9.73           C  
ATOM    630  CD1 LEU A1525      -9.216  42.385   1.639  1.00 10.97           C  
ATOM    631  CD2 LEU A1525      -8.238  40.967  -0.167  1.00 11.89           C  
ATOM    632  N   GLU A1526      -7.838  38.772   3.842  1.00 10.43           N  
ATOM    633  CA  GLU A1526      -8.789  37.723   4.204  1.00 11.53           C  
ATOM    634  C   GLU A1526      -9.218  37.829   5.637  1.00 12.54           C  
ATOM    635  O   GLU A1526     -10.402  37.622   5.959  1.00 12.17           O  
ATOM    636  CB  GLU A1526      -8.166  36.349   3.974  1.00 13.06           C  
ATOM    637  CG  GLU A1526      -9.035  35.196   4.549  1.00 13.65           C  
ATOM    638  CD  GLU A1526      -8.852  33.882   3.794  1.00 16.65           C  
ATOM    639  OE1 GLU A1526      -9.213  32.825   4.330  1.00 20.82           O  
ATOM    640  OE2 GLU A1526      -8.355  33.907   2.667  1.00 17.07           O  
ATOM    641  N   LYS A1527      -8.268  38.116   6.521  1.00 12.53           N  
ATOM    642  CA  LYS A1527      -8.587  38.241   7.937  1.00 12.66           C  
ATOM    643  C   LYS A1527      -9.595  39.341   8.216  1.00 13.04           C  
ATOM    644  O   LYS A1527     -10.460  39.166   9.072  1.00 13.96           O  
ATOM    645  CB  LYS A1527      -7.334  38.488   8.747  1.00 14.17           C  
ATOM    646  CG  LYS A1527      -6.545  37.247   9.027  1.00 17.16           C  
ATOM    647  CD  LYS A1527      -5.257  37.720   9.608  1.00 22.26           C  
ATOM    648  CE  LYS A1527      -4.709  36.834  10.678  1.00 25.91           C  
ATOM    649  NZ  LYS A1527      -3.370  37.441  10.975  1.00 24.31           N  
ATOM    650  N   ASP A1528      -9.479  40.484   7.537  1.00 12.10           N  
ATOM    651  CA  ASP A1528     -10.441  41.545   7.741  1.00 11.79           C  
ATOM    652  C   ASP A1528     -11.798  41.142   7.172  1.00 11.36           C  
ATOM    653  O   ASP A1528     -12.827  41.485   7.752  1.00 10.78           O  
ATOM    654  CB  ASP A1528      -9.950  42.866   7.139  1.00 11.89           C  
ATOM    655  CG  ASP A1528      -9.589  43.915   8.209  1.00 13.87           C  
ATOM    656  OD1 ASP A1528      -9.582  43.649   9.446  1.00 14.95           O  
ATOM    657  OD2 ASP A1528      -9.303  45.049   7.809  1.00 13.80           O  
ATOM    658  N   VAL A1529     -11.840  40.424   6.054  1.00 10.71           N  
ATOM    659  CA  VAL A1529     -13.147  39.993   5.552  1.00 11.40           C  
ATOM    660  C   VAL A1529     -13.753  39.004   6.539  1.00 12.71           C  
ATOM    661  O   VAL A1529     -14.942  39.090   6.839  1.00 12.62           O  
ATOM    662  CB  VAL A1529     -13.097  39.384   4.121  1.00 11.57           C  
ATOM    663  CG1 VAL A1529     -14.437  38.864   3.726  1.00 12.97           C  
ATOM    664  CG2 VAL A1529     -12.667  40.417   3.108  1.00 11.47           C  
ATOM    665  N   MET A1530     -12.951  38.086   7.051  1.00 12.77           N  
ATOM    666  CA  MET A1530     -13.457  37.107   8.018  1.00 13.53           C  
ATOM    667  C   MET A1530     -13.914  37.809   9.303  1.00 13.32           C  
ATOM    668  O   MET A1530     -14.910  37.387   9.930  1.00 13.94           O  
ATOM    669  CB  MET A1530     -12.417  36.010   8.267  1.00 13.64           C  
ATOM    670  CG  MET A1530     -12.138  35.145   7.012  1.00 17.15           C  
ATOM    671  SD  MET A1530     -13.576  34.429   6.188  1.00 21.73           S  
ATOM    672  CE  MET A1530     -12.838  34.121   4.576  1.00 21.33           C  
ATOM    673  N   LEU A1531     -13.232  38.877   9.702  1.00 12.76           N  
ATOM    674  CA  LEU A1531     -13.639  39.666  10.858  1.00 13.71           C  
ATOM    675  C   LEU A1531     -14.988  40.382  10.600  1.00 12.37           C  
ATOM    676  O   LEU A1531     -15.878  40.363  11.466  1.00 14.03           O  
ATOM    677  CB  LEU A1531     -12.552  40.667  11.249  1.00 14.74           C  
ATOM    678  CG  LEU A1531     -12.869  41.667  12.351  1.00 16.39           C  
ATOM    679  CD1 LEU A1531     -13.225  40.988  13.693  1.00 16.05           C  
ATOM    680  CD2 LEU A1531     -11.707  42.651  12.524  1.00 15.34           C  
ATOM    681  N   LEU A1532     -15.128  41.023   9.434  1.00 11.01           N  
ATOM    682  CA  LEU A1532     -16.409  41.606   9.020  1.00 10.61           C  
ATOM    683  C   LEU A1532     -17.542  40.570   9.186  1.00 11.68           C  
ATOM    684  O   LEU A1532     -18.607  40.868   9.772  1.00 12.01           O  
ATOM    685  CB  LEU A1532     -16.289  42.094   7.579  1.00 10.76           C  
ATOM    686  CG  LEU A1532     -17.526  42.734   6.922  1.00  8.90           C  
ATOM    687  CD1 LEU A1532     -17.024  43.650   5.799  1.00  9.85           C  
ATOM    688  CD2 LEU A1532     -18.498  41.697   6.367  1.00 10.63           C  
ATOM    689  N   CYS A1533     -17.316  39.351   8.723  1.00 11.20           N  
ATOM    690  CA  CYS A1533     -18.353  38.295   8.811  1.00 12.04           C  
ATOM    691  C   CYS A1533     -18.546  37.824  10.269  1.00 12.58           C  
ATOM    692  O   CYS A1533     -19.684  37.568  10.687  1.00 13.52           O  
ATOM    693  CB  CYS A1533     -18.029  37.121   7.910  1.00 13.35           C  
ATOM    694  SG  CYS A1533     -18.005  37.527   6.163  1.00 14.07           S  
ATOM    695  N   GLN A1534     -17.456  37.712  11.023  1.00 13.92           N  
ATOM    696  CA  GLN A1534     -17.518  37.342  12.465  1.00 14.32           C  
ATOM    697  C   GLN A1534     -18.412  38.333  13.198  1.00 14.19           C  
ATOM    698  O   GLN A1534     -19.324  37.954  13.965  1.00 13.90           O  
ATOM    699  CB  GLN A1534     -16.098  37.338  13.094  1.00 14.42           C  
ATOM    700  CG  GLN A1534     -16.054  37.157  14.656  1.00 16.22           C  
ATOM    701  CD  GLN A1534     -14.755  37.718  15.325  1.00 17.28           C  
ATOM    702  OE1 GLN A1534     -13.636  37.280  15.025  1.00 22.03           O  
ATOM    703  NE2 GLN A1534     -14.914  38.708  16.197  1.00 21.25           N  
ATOM    704  N   ASN A1535     -18.150  39.622  12.983  1.00 13.43           N  
ATOM    705  CA  ASN A1535     -18.940  40.677  13.592  1.00 13.49           C  
ATOM    706  C   ASN A1535     -20.442  40.568  13.276  1.00 12.84           C  
ATOM    707  O   ASN A1535     -21.267  40.715  14.173  1.00 13.30           O  
ATOM    708  CB  ASN A1535     -18.367  42.058  13.244  1.00 13.80           C  
ATOM    709  CG  ASN A1535     -16.982  42.276  13.838  1.00 15.76           C  
ATOM    710  OD1 ASN A1535     -16.568  41.588  14.802  1.00 16.55           O  
ATOM    711  ND2 ASN A1535     -16.261  43.243  13.294  1.00 15.25           N  
ATOM    712  N   ALA A1536     -20.781  40.307  12.016  1.00 12.78           N  
ATOM    713  CA  ALA A1536     -22.171  40.071  11.628  1.00 12.08           C  
ATOM    714  C   ALA A1536     -22.765  38.911  12.424  1.00 12.46           C  
ATOM    715  O   ALA A1536     -23.945  38.944  12.785  1.00 13.50           O  
ATOM    716  CB  ALA A1536     -22.279  39.804  10.120  1.00 12.24           C  
ATOM    717  N   GLN A1537     -21.960  37.896  12.679  1.00 12.69           N  
ATOM    718  CA  GLN A1537     -22.449  36.681  13.358  1.00 13.63           C  
ATOM    719  C   GLN A1537     -22.584  36.855  14.858  1.00 15.70           C  
ATOM    720  O   GLN A1537     -23.276  36.071  15.524  1.00 17.57           O  
ATOM    721  CB  GLN A1537     -21.587  35.485  13.012  1.00 13.98           C  
ATOM    722  CG  GLN A1537     -21.725  35.106  11.562  1.00 13.45           C  
ATOM    723  CD  GLN A1537     -20.503  34.409  10.997  1.00 13.95           C  
ATOM    724  OE1 GLN A1537     -19.841  33.626  11.687  1.00 16.88           O  
ATOM    725  NE2 GLN A1537     -20.221  34.654   9.730  1.00 13.94           N  
ATOM    726  N   THR A1538     -21.965  37.901  15.374  1.00 16.20           N  
ATOM    727  CA  THR A1538     -22.000  38.221  16.796  1.00 17.55           C  
ATOM    728  C   THR A1538     -23.207  39.107  17.071  1.00 17.41           C  
ATOM    729  O   THR A1538     -23.941  38.870  18.046  1.00 17.99           O  
ATOM    730  CB  THR A1538     -20.703  38.943  17.229  1.00 18.26           C  
ATOM    731  OG1 THR A1538     -19.589  38.059  17.068  1.00 19.06           O  
ATOM    732  CG2 THR A1538     -20.782  39.433  18.687  1.00 20.22           C  
ATOM    733  N   PHE A1539     -23.416  40.110  16.208  1.00 16.76           N  
ATOM    734  CA  PHE A1539     -24.451  41.124  16.380  1.00 17.07           C  
ATOM    735  C   PHE A1539     -25.818  40.619  15.919  1.00 16.99           C  
ATOM    736  O   PHE A1539     -26.848  41.044  16.456  1.00 18.35           O  
ATOM    737  CB  PHE A1539     -24.107  42.416  15.614  1.00 16.55           C  
ATOM    738  CG  PHE A1539     -25.111  43.535  15.834  1.00 17.32           C  
ATOM    739  CD1 PHE A1539     -25.195  44.180  17.071  1.00 19.21           C  
ATOM    740  CD2 PHE A1539     -25.992  43.908  14.820  1.00 18.31           C  
ATOM    741  CE1 PHE A1539     -26.132  45.204  17.289  1.00 17.53           C  
ATOM    742  CE2 PHE A1539     -26.944  44.937  15.024  1.00 17.91           C  
ATOM    743  CZ  PHE A1539     -27.007  45.578  16.288  1.00 16.68           C  
ATOM    744  N   ASN A1540     -25.831  39.775  14.886  1.00 16.83           N  
ATOM    745  CA  ASN A1540     -27.083  39.198  14.405  1.00 17.32           C  
ATOM    746  C   ASN A1540     -27.204  37.750  14.847  1.00 17.71           C  
ATOM    747  O   ASN A1540     -26.210  37.091  15.140  1.00 18.16           O  
ATOM    748  CB  ASN A1540     -27.209  39.313  12.877  1.00 16.74           C  
ATOM    749  CG  ASN A1540     -26.994  40.731  12.377  1.00 17.01           C  
ATOM    750  OD1 ASN A1540     -27.946  41.482  12.210  1.00 19.30           O  
ATOM    751  ND2 ASN A1540     -25.722  41.105  12.125  1.00 14.29           N  
ATOM    752  N   LEU A1541     -28.434  37.248  14.897  1.00 18.72           N  
ATOM    753  CA  LEU A1541     -28.684  35.914  15.434  1.00 18.56           C  
ATOM    754  C   LEU A1541     -28.588  34.825  14.376  1.00 18.82           C  
ATOM    755  O   LEU A1541     -28.971  35.063  13.228  1.00 17.43           O  
ATOM    756  CB  LEU A1541     -30.072  35.892  16.081  1.00 19.33           C  
ATOM    757  CG  LEU A1541     -30.221  36.645  17.410  1.00 19.99           C  
ATOM    758  CD1 LEU A1541     -31.703  36.820  17.771  1.00 23.40           C  
ATOM    759  CD2 LEU A1541     -29.486  35.907  18.546  1.00 21.09           C  
ATOM    760  N   GLU A1542     -28.050  33.653  14.746  1.00 18.63           N  
ATOM    761  CA  GLU A1542     -28.033  32.483  13.855  1.00 19.94           C  
ATOM    762  C   GLU A1542     -29.434  32.311  13.259  1.00 18.48           C  
ATOM    763  O   GLU A1542     -30.445  32.438  13.966  1.00 19.81           O  
ATOM    764  CB  GLU A1542     -27.552  31.195  14.558  1.00 20.67           C  
ATOM    765  CG  GLU A1542     -27.230  30.017  13.618  1.00 22.84           C  
ATOM    766  CD  GLU A1542     -26.465  28.881  14.309  1.00 22.45           C  
ATOM    767  OE1 GLU A1542     -25.477  28.374  13.738  1.00 28.98           O  
ATOM    768  OE2 GLU A1542     -26.846  28.486  15.425  1.00 26.59           O  
ATOM    769  N   GLY A1543     -29.464  32.028  11.964  1.00 18.08           N  
ATOM    770  CA  GLY A1543     -30.692  31.839  11.204  1.00 16.36           C  
ATOM    771  C   GLY A1543     -31.303  33.108  10.642  1.00 15.50           C  
ATOM    772  O   GLY A1543     -32.247  33.049   9.846  1.00 14.44           O  
ATOM    773  N   SER A1544     -30.796  34.269  11.076  1.00 14.22           N  
ATOM    774  CA  SER A1544     -31.239  35.523  10.488  1.00 14.20           C  
ATOM    775  C   SER A1544     -30.653  35.669   9.084  1.00 13.90           C  
ATOM    776  O   SER A1544     -29.600  35.077   8.751  1.00 13.41           O  
ATOM    777  CB  SER A1544     -30.886  36.723  11.360  1.00 14.39           C  
ATOM    778  OG  SER A1544     -29.478  36.939  11.389  1.00 12.71           O  
ATOM    779  N   LEU A1545     -31.359  36.423   8.260  1.00 13.99           N  
ATOM    780  CA  LEU A1545     -30.891  36.708   6.928  1.00 13.98           C  
ATOM    781  C   LEU A1545     -29.463  37.270   6.953  1.00 13.82           C  
ATOM    782  O   LEU A1545     -28.605  36.737   6.286  1.00 12.83           O  
ATOM    783  CB  LEU A1545     -31.876  37.624   6.202  1.00 14.68           C  
ATOM    784  CG  LEU A1545     -31.547  37.870   4.724  1.00 17.28           C  
ATOM    785  CD1 LEU A1545     -32.793  38.147   3.879  1.00 19.82           C  
ATOM    786  CD2 LEU A1545     -30.568  39.022   4.592  1.00 20.03           C  
ATOM    787  N   ILE A1546     -29.204  38.303   7.747  1.00 12.65           N  
ATOM    788  CA  ILE A1546     -27.882  38.934   7.747  1.00 13.20           C  
ATOM    789  C   ILE A1546     -26.797  37.974   8.264  1.00 13.35           C  
ATOM    790  O   ILE A1546     -25.716  37.880   7.716  1.00 12.63           O  
ATOM    791  CB  ILE A1546     -27.912  40.250   8.530  1.00 12.37           C  
ATOM    792  CG1 ILE A1546     -28.795  41.253   7.787  1.00 14.16           C  
ATOM    793  CG2 ILE A1546     -26.526  40.831   8.611  1.00 12.38           C  
ATOM    794  CD1 ILE A1546     -29.100  42.520   8.557  1.00 14.03           C  
ATOM    795  N   TYR A1547     -27.066  37.238   9.334  1.00 13.28           N  
ATOM    796  CA  TYR A1547     -26.085  36.239   9.805  1.00 12.86           C  
ATOM    797  C   TYR A1547     -25.795  35.212   8.689  1.00 13.50           C  
ATOM    798  O   TYR A1547     -24.630  34.901   8.358  1.00 12.99           O  
ATOM    799  CB  TYR A1547     -26.665  35.560  11.038  1.00 14.47           C  
ATOM    800  CG  TYR A1547     -25.813  34.491  11.705  1.00 16.06           C  
ATOM    801  CD1 TYR A1547     -25.549  33.280  11.073  1.00 17.02           C  
ATOM    802  CD2 TYR A1547     -25.331  34.678  12.998  1.00 16.39           C  
ATOM    803  CE1 TYR A1547     -24.782  32.275  11.714  1.00 17.52           C  
ATOM    804  CE2 TYR A1547     -24.588  33.702  13.629  1.00 17.34           C  
ATOM    805  CZ  TYR A1547     -24.321  32.503  12.996  1.00 17.17           C  
ATOM    806  OH  TYR A1547     -23.563  31.549  13.670  1.00 18.83           O  
ATOM    807  N   GLU A1548     -26.830  34.655   8.090  1.00 13.85           N  
ATOM    808  CA  GLU A1548     -26.586  33.583   7.157  1.00 14.71           C  
ATOM    809  C   GLU A1548     -25.930  34.092   5.876  1.00 14.19           C  
ATOM    810  O   GLU A1548     -25.141  33.395   5.273  1.00 14.31           O  
ATOM    811  CB  GLU A1548     -27.872  32.793   6.899  1.00 15.64           C  
ATOM    812  CG  GLU A1548     -28.406  32.068   8.151  1.00 17.29           C  
ATOM    813  CD  GLU A1548     -27.470  31.018   8.724  1.00 18.84           C  
ATOM    814  OE1 GLU A1548     -26.655  30.436   7.972  1.00 21.38           O  
ATOM    815  OE2 GLU A1548     -27.566  30.745   9.932  1.00 21.13           O  
ATOM    816  N   ASP A1549     -26.241  35.314   5.482  1.00 13.17           N  
ATOM    817  CA  ASP A1549     -25.569  35.899   4.303  1.00 11.47           C  
ATOM    818  C   ASP A1549     -24.067  36.039   4.595  1.00 11.88           C  
ATOM    819  O   ASP A1549     -23.216  35.853   3.699  1.00 11.80           O  
ATOM    820  CB  ASP A1549     -26.192  37.244   3.936  1.00 12.65           C  
ATOM    821  CG  ASP A1549     -27.466  37.086   3.100  1.00 12.64           C  
ATOM    822  OD1 ASP A1549     -27.823  35.936   2.730  1.00 13.92           O  
ATOM    823  OD2 ASP A1549     -28.058  38.117   2.768  1.00 14.52           O  
ATOM    824  N   SER A1550     -23.738  36.398   5.830  1.00 10.33           N  
ATOM    825  CA  SER A1550     -22.310  36.560   6.171  1.00 11.40           C  
ATOM    826  C   SER A1550     -21.563  35.228   6.099  1.00 12.37           C  
ATOM    827  O   SER A1550     -20.416  35.184   5.660  1.00 13.01           O  
ATOM    828  CB  SER A1550     -22.121  37.273   7.510  1.00 12.16           C  
ATOM    829  OG  SER A1550     -22.361  36.410   8.627  1.00 11.81           O  
ATOM    830  N   ILE A1551     -22.209  34.143   6.514  1.00 13.01           N  
ATOM    831  CA  ILE A1551     -21.642  32.799   6.349  1.00 14.63           C  
ATOM    832  C   ILE A1551     -21.354  32.489   4.872  1.00 14.32           C  
ATOM    833  O   ILE A1551     -20.261  32.005   4.527  1.00 15.43           O  
ATOM    834  CB  ILE A1551     -22.599  31.738   6.929  1.00 15.55           C  
ATOM    835  CG1 ILE A1551     -22.722  31.885   8.447  1.00 16.44           C  
ATOM    836  CG2 ILE A1551     -22.161  30.324   6.519  1.00 16.65           C  
ATOM    837  CD1 ILE A1551     -21.580  31.333   9.292  1.00 19.40           C  
ATOM    838  N   VAL A1552     -22.294  32.805   3.996  1.00 13.68           N  
ATOM    839  CA  VAL A1552     -22.101  32.552   2.583  1.00 13.36           C  
ATOM    840  C   VAL A1552     -20.943  33.397   2.056  1.00 12.92           C  
ATOM    841  O   VAL A1552     -20.127  32.902   1.321  1.00 13.25           O  
ATOM    842  CB  VAL A1552     -23.373  32.732   1.743  1.00 13.92           C  
ATOM    843  CG1 VAL A1552     -23.071  32.500   0.303  1.00 13.55           C  
ATOM    844  CG2 VAL A1552     -24.447  31.742   2.185  1.00 14.96           C  
ATOM    845  N   LEU A1553     -20.874  34.650   2.470  1.00 12.60           N  
ATOM    846  CA  LEU A1553     -19.808  35.558   2.006  1.00 13.08           C  
ATOM    847  C   LEU A1553     -18.401  35.058   2.345  1.00 13.85           C  
ATOM    848  O   LEU A1553     -17.458  35.303   1.581  1.00 14.03           O  
ATOM    849  CB  LEU A1553     -20.021  36.965   2.574  1.00 12.81           C  
ATOM    850  CG  LEU A1553     -21.051  37.875   1.890  1.00 14.34           C  
ATOM    851  CD1 LEU A1553     -21.144  39.206   2.636  1.00 16.59           C  
ATOM    852  CD2 LEU A1553     -20.657  38.114   0.437  1.00 13.80           C  
ATOM    853  N   GLN A1554     -18.263  34.372   3.470  1.00 14.85           N  
ATOM    854  CA  GLN A1554     -16.975  33.724   3.840  1.00 16.20           C  
ATOM    855  C   GLN A1554     -16.565  32.745   2.747  1.00 16.71           C  
ATOM    856  O   GLN A1554     -15.417  32.753   2.301  1.00 18.33           O  
ATOM    857  CB  GLN A1554     -17.119  32.923   5.141  1.00 16.55           C  
ATOM    858  CG  GLN A1554     -17.241  33.744   6.389  1.00 17.94           C  
ATOM    859  CD  GLN A1554     -17.635  32.951   7.639  1.00 18.93           C  
ATOM    860  OE1 GLN A1554     -17.642  31.718   7.654  1.00 25.27           O  
ATOM    861  NE2 GLN A1554     -17.916  33.667   8.701  1.00 20.70           N  
ATOM    862  N   SER A1555     -17.497  31.887   2.331  1.00 16.69           N  
ATOM    863  CA  SER A1555     -17.246  30.899   1.277  1.00 17.51           C  
ATOM    864  C   SER A1555     -17.003  31.564  -0.076  1.00 16.28           C  
ATOM    865  O   SER A1555     -16.159  31.116  -0.849  1.00 17.68           O  
ATOM    866  CB  SER A1555     -18.389  29.888   1.186  1.00 18.63           C  
ATOM    867  OG  SER A1555     -19.599  30.496   0.782  1.00 23.47           O  
ATOM    868  N   VAL A1556     -17.750  32.633  -0.366  1.00 14.94           N  
ATOM    869  CA  VAL A1556     -17.556  33.394  -1.614  1.00 14.23           C  
ATOM    870  C   VAL A1556     -16.137  33.962  -1.644  1.00 14.06           C  
ATOM    871  O   VAL A1556     -15.466  33.857  -2.678  1.00 13.87           O  
ATOM    872  CB  VAL A1556     -18.629  34.520  -1.776  1.00 14.20           C  
ATOM    873  CG1 VAL A1556     -18.373  35.404  -2.995  1.00 14.28           C  
ATOM    874  CG2 VAL A1556     -20.008  33.896  -1.853  1.00 12.77           C  
ATOM    875  N   PHE A1557     -15.686  34.566  -0.544  1.00 13.45           N  
ATOM    876  CA  PHE A1557     -14.313  35.069  -0.522  1.00 13.83           C  
ATOM    877  C   PHE A1557     -13.311  33.963  -0.867  1.00 13.54           C  
ATOM    878  O   PHE A1557     -12.429  34.171  -1.683  1.00 13.78           O  
ATOM    879  CB  PHE A1557     -13.930  35.684   0.814  1.00 14.59           C  
ATOM    880  CG  PHE A1557     -12.529  36.260   0.834  1.00 14.35           C  
ATOM    881  CD1 PHE A1557     -11.419  35.439   1.068  1.00 15.99           C  
ATOM    882  CD2 PHE A1557     -12.324  37.609   0.616  1.00 12.35           C  
ATOM    883  CE1 PHE A1557     -10.120  35.972   1.071  1.00 16.60           C  
ATOM    884  CE2 PHE A1557     -11.031  38.154   0.639  1.00 14.10           C  
ATOM    885  CZ  PHE A1557      -9.938  37.340   0.868  1.00 15.44           C  
ATOM    886  N   THR A1558     -13.455  32.806  -0.243  1.00 15.65           N  
ATOM    887  CA  THR A1558     -12.522  31.716  -0.463  1.00 15.94           C  
ATOM    888  C   THR A1558     -12.534  31.271  -1.918  1.00 15.91           C  
ATOM    889  O   THR A1558     -11.486  31.122  -2.564  1.00 15.33           O  
ATOM    890  CB  THR A1558     -12.849  30.560   0.478  1.00 16.60           C  
ATOM    891  OG1 THR A1558     -12.552  30.966   1.817  1.00 16.66           O  
ATOM    892  CG2 THR A1558     -12.030  29.314   0.119  1.00 18.08           C  
ATOM    893  N   SER A1559     -13.724  31.095  -2.459  1.00 15.02           N  
ATOM    894  CA  SER A1559     -13.850  30.637  -3.837  1.00 15.59           C  
ATOM    895  C   SER A1559     -13.288  31.672  -4.804  1.00 14.54           C  
ATOM    896  O   SER A1559     -12.586  31.344  -5.751  1.00 14.05           O  
ATOM    897  CB  SER A1559     -15.314  30.350  -4.164  1.00 16.37           C  
ATOM    898  OG  SER A1559     -15.820  29.315  -3.327  1.00 21.36           O  
ATOM    899  N   VAL A1560     -13.586  32.948  -4.549  1.00 12.38           N  
ATOM    900  CA  VAL A1560     -13.145  33.999  -5.465  1.00 12.68           C  
ATOM    901  C   VAL A1560     -11.629  34.117  -5.394  1.00 12.20           C  
ATOM    902  O   VAL A1560     -10.979  34.238  -6.431  1.00 13.57           O  
ATOM    903  CB  VAL A1560     -13.828  35.342  -5.127  1.00 12.45           C  
ATOM    904  CG1 VAL A1560     -13.144  36.524  -5.844  1.00 14.61           C  
ATOM    905  CG2 VAL A1560     -15.315  35.262  -5.509  1.00 13.08           C  
ATOM    906  N   ARG A1561     -11.074  34.071  -4.184  1.00 12.58           N  
ATOM    907  CA  ARG A1561      -9.601  34.154  -4.050  1.00 12.40           C  
ATOM    908  C   ARG A1561      -8.899  33.074  -4.853  1.00 13.37           C  
ATOM    909  O   ARG A1561      -7.873  33.330  -5.504  1.00 14.58           O  
ATOM    910  CB  ARG A1561      -9.184  34.060  -2.600  1.00 12.12           C  
ATOM    911  CG  ARG A1561      -7.690  34.046  -2.412  1.00 12.49           C  
ATOM    912  CD  ARG A1561      -7.294  34.005  -0.978  1.00 12.68           C  
ATOM    913  NE  ARG A1561      -5.849  33.759  -0.907  1.00 13.84           N  
ATOM    914  CZ  ARG A1561      -5.137  33.713   0.212  1.00 12.14           C  
ATOM    915  NH1 ARG A1561      -5.712  33.856   1.406  1.00 11.34           N  
ATOM    916  NH2 ARG A1561      -3.814  33.501   0.126  1.00 13.66           N  
ATOM    917  N   GLN A1562      -9.444  31.867  -4.776  1.00 14.48           N  
ATOM    918  CA  GLN A1562      -8.834  30.732  -5.464  1.00 15.41           C  
ATOM    919  C   GLN A1562      -8.971  30.813  -6.954  1.00 16.27           C  
ATOM    920  O   GLN A1562      -8.021  30.496  -7.668  1.00 16.58           O  
ATOM    921  CB  GLN A1562      -9.432  29.435  -4.987  1.00 15.75           C  
ATOM    922  CG  GLN A1562      -8.999  29.113  -3.602  1.00 20.01           C  
ATOM    923  CD  GLN A1562      -9.719  27.938  -3.005  1.00 25.46           C  
ATOM    924  OE1 GLN A1562     -10.714  27.446  -3.550  1.00 28.73           O  
ATOM    925  NE2 GLN A1562      -9.222  27.478  -1.873  1.00 25.24           N  
ATOM    926  N   LYS A1563     -10.143  31.221  -7.444  1.00 14.80           N  
ATOM    927  CA  LYS A1563     -10.291  31.415  -8.876  1.00 16.33           C  
ATOM    928  C   LYS A1563      -9.242  32.385  -9.414  1.00 16.20           C  
ATOM    929  O   LYS A1563      -8.585  32.096 -10.419  1.00 16.93           O  
ATOM    930  CB  LYS A1563     -11.711  31.846  -9.243  1.00 16.98           C  
ATOM    931  CG  LYS A1563     -12.584  30.647  -9.625  1.00 19.96           C  
ATOM    932  N   ILE A1564      -9.076  33.508  -8.709  1.00 16.08           N  
ATOM    933  CA  ILE A1564      -8.165  34.570  -9.117  1.00 16.84           C  
ATOM    934  C   ILE A1564      -6.705  34.109  -9.036  1.00 16.93           C  
ATOM    935  O   ILE A1564      -5.936  34.290  -9.982  1.00 17.64           O  
ATOM    936  CB  ILE A1564      -8.445  35.865  -8.305  1.00 16.83           C  
ATOM    937  CG1 ILE A1564      -9.661  36.555  -8.929  1.00 18.50           C  
ATOM    938  CG2 ILE A1564      -7.172  36.778  -8.219  1.00 17.58           C  
ATOM    939  CD1 ILE A1564     -10.376  37.492  -8.019  1.00 21.39           C  
ATOM    940  N   GLU A1565      -6.326  33.506  -7.928  1.00 15.98           N  
ATOM    941  CA  GLU A1565      -4.939  33.038  -7.801  1.00 16.26           C  
ATOM    942  C   GLU A1565      -4.586  31.893  -8.748  1.00 17.60           C  
ATOM    943  O   GLU A1565      -3.462  31.843  -9.251  1.00 18.12           O  
ATOM    944  CB  GLU A1565      -4.615  32.660  -6.372  1.00 15.74           C  
ATOM    945  CG  GLU A1565      -4.739  33.834  -5.447  1.00 13.03           C  
ATOM    946  CD  GLU A1565      -3.980  33.619  -4.194  1.00 14.31           C  
ATOM    947  OE1 GLU A1565      -2.847  34.133  -4.144  1.00 17.99           O  
ATOM    948  OE2 GLU A1565      -4.446  32.944  -3.261  1.00 14.29           O  
ATOM    949  N   LYS A1566      -5.519  30.970  -8.994  1.00 19.09           N  
ATOM    950  CA  LYS A1566      -5.281  29.898  -9.966  1.00 20.03           C  
ATOM    951  C   LYS A1566      -5.079  30.466 -11.356  1.00 22.00           C  
ATOM    952  O   LYS A1566      -4.224  29.993 -12.113  1.00 21.76           O  
ATOM    953  CB  LYS A1566      -6.433  28.906  -9.974  1.00 20.00           C  
ATOM    954  CG  LYS A1566      -6.445  28.003  -8.751  1.00 19.85           C  
ATOM    955  CD  LYS A1566      -7.725  27.191  -8.697  1.00 22.23           C  
ATOM    956  CE  LYS A1566      -7.799  26.117  -9.793  1.00 25.22           C  
ATOM    957  NZ  LYS A1566      -7.213  24.829  -9.308  1.00 27.21           N  
ATOM    958  N   GLU A1567      -5.868  31.487 -11.684  1.00 23.34           N  
ATOM    959  CA  GLU A1567      -5.737  32.191 -12.952  1.00 26.40           C  
ATOM    960  C   GLU A1567      -4.336  32.751 -13.099  1.00 27.21           C  
ATOM    961  O   GLU A1567      -3.735  32.632 -14.161  1.00 26.82           O  
ATOM    962  CB  GLU A1567      -6.780  33.298 -13.074  1.00 26.36           C  
ATOM    963  CG  GLU A1567      -8.186  32.772 -13.348  1.00 27.91           C  
ATOM    964  CD  GLU A1567      -9.282  33.827 -13.216  1.00 28.14           C  
ATOM    965  OE1 GLU A1567     -10.458  33.461 -13.432  1.00 29.56           O  
ATOM    966  OE2 GLU A1567      -8.987  35.009 -12.900  1.00 29.35           O  
ATOM    967  N   ASP A1568      -3.816  33.335 -12.019  1.00 28.66           N  
ATOM    968  CA  ASP A1568      -2.452  33.880 -11.993  1.00 30.29           C  
ATOM    969  C   ASP A1568      -1.387  32.785 -11.827  1.00 31.26           C  
ATOM    970  O   ASP A1568      -0.208  33.071 -11.573  1.00 31.80           O  
ATOM    971  CB  ASP A1568      -2.341  34.943 -10.900  1.00 30.79           C  
ATOM    972  CG  ASP A1568      -3.177  36.173 -11.201  1.00 32.22           C  
ATOM    973  OD1 ASP A1568      -3.451  36.444 -12.395  1.00 34.00           O  
ATOM    974  OD2 ASP A1568      -3.565  36.875 -10.245  1.00 34.36           O  
ATOM    975  N   ASP A1569      -1.832  31.537 -11.959  1.00 31.86           N  
ATOM    976  CA  ASP A1569      -0.976  30.344 -12.042  1.00 33.07           C  
ATOM    977  C   ASP A1569      -0.258  30.004 -10.747  1.00 33.29           C  
ATOM    978  O   ASP A1569      -0.741  29.176  -9.972  1.00 33.76           O  
ATOM    979  CB  ASP A1569      -0.010  30.420 -13.240  1.00 33.11           C  
ATOM    980  CG  ASP A1569      -0.734  30.346 -14.577  1.00 34.64           C  
ATOM    981  OD1 ASP A1569      -1.929  30.707 -14.621  1.00 35.97           O  
ATOM    982  OD2 ASP A1569      -0.124  29.931 -15.590  1.00 35.80           O  
TER     983      ASP A1569                                                      
END
MOLECULE T0432.pdb
ATOM      1  N   SER     1      12.703  45.910  -3.320  1.00 50.93           N
ATOM      2  CA  SER     1      13.109  46.216  -4.712  1.00 47.13           C
ATOM      4  CB  SER     1      13.709  44.967  -5.358  1.00 53.53           C
ATOM      7  OG  SER     1      12.759  43.911  -5.430  1.00 42.48           O
ATOM      9  C   SER     1      11.931  46.715  -5.566  1.00 52.43           C
ATOM     10  O   SER     1      10.768  46.719  -5.114  1.00 45.72           O
ATOM     14  N   MET     2      12.255  47.142  -6.791  1.00 48.01           N
ATOM     15  CA  MET     2      11.257  47.418  -7.836  1.00 53.09           C
ATOM     17  CB  MET     2      11.927  47.928  -9.120  1.00 51.71           C
ATOM     23  C   MET     2      10.424  46.169  -8.153  1.00 49.18           C
ATOM     24  O   MET     2       9.206  46.267  -8.286  1.00 51.00           O
ATOM     26  N   GLN     3      11.078  45.011  -8.268  1.00 44.90           N
ATOM     27  CA  GLN     3      10.368  43.738  -8.433  1.00 49.87           C
ATOM     29  CB  GLN     3      11.334  42.538  -8.524  1.00 49.44           C
ATOM     32  CG  GLN     3      11.990  42.326  -9.886  1.00 56.96           C
ATOM     38  C   GLN     3       9.361  43.512  -7.283  1.00 43.65           C
ATOM     39  O   GLN     3       8.242  43.071  -7.521  1.00 37.83           O
ATOM     41  N   GLU     4       9.764  43.812  -6.049  1.00 34.49           N
ATOM     42  CA  GLU     4       8.896  43.571  -4.909  1.00 28.57           C
ATOM     44  CB  GLU     4       9.695  43.588  -3.619  1.00 30.35           C
ATOM     47  CG  GLU     4      10.564  42.317  -3.478  1.00 32.03           C
ATOM     50  CD  GLU     4      11.497  42.362  -2.284  1.00 34.53           C
ATOM     51  OE1 GLU     4      11.564  43.415  -1.624  1.00 39.92           O
ATOM     52  OE2 GLU     4      12.167  41.335  -2.002  1.00 35.71           O
ATOM     53  C   GLU     4       7.708  44.529  -4.871  1.00 25.78           C
ATOM     54  O   GLU     4       6.586  44.106  -4.548  1.00 21.89           O
ATOM     56  N   GLU     5       7.958  45.807  -5.172  1.00 27.67           N
ATOM     57  CA  GLU     5       6.900  46.803  -5.275  1.00 29.37           C
ATOM     59  CB  GLU     5       7.492  48.200  -5.504  1.00 32.93           C
ATOM     62  CG  GLU     5       8.329  48.698  -4.321  1.00 36.17           C
ATOM     68  C   GLU     5       5.841  46.464  -6.357  1.00 26.28           C
ATOM     69  O   GLU     5       4.652  46.729  -6.168  1.00 24.25           O
ATOM     71  N   ASP     6       6.276  45.882  -7.472  1.00 23.77           N
ATOM     72  CA  ASP     6       5.354  45.408  -8.499  1.00 26.67           C
ATOM     74  CB  ASP     6       6.099  44.978  -9.756  1.00 25.76           C
ATOM     77  CG  ASP     6       6.749  46.165 -10.526  1.00 24.96           C
ATOM     78  OD1 ASP     6       6.374  47.338 -10.325  1.00 41.80           O
ATOM     79  OD2 ASP     6       7.653  45.870 -11.317  1.00 39.42           O
ATOM     80  C   ASP     6       4.501  44.208  -7.998  1.00 20.23           C
ATOM     81  O   ASP     6       3.358  44.093  -8.388  1.00 20.47           O
ATOM     83  N   THR     7       5.093  43.319  -7.201  1.00 22.25           N
ATOM     84  CA  THR     7       4.384  42.184  -6.606  1.00 22.70           C
ATOM     86  CB  THR     7       5.332  41.245  -5.780  1.00 22.94           C
ATOM     88  OG1 THR     7       6.367  40.712  -6.630  1.00 26.30           O
ATOM     90  CG2 THR     7       4.556  40.047  -5.132  1.00 16.87           C
ATOM     94  C   THR     7       3.250  42.693  -5.726  1.00 21.27           C
ATOM     95  O   THR     7       2.114  42.227  -5.839  1.00 18.76           O
ATOM     97  N   PHE     8       3.574  43.615  -4.823  1.00 19.23           N
ATOM     98  CA  PHE     8       2.558  44.181  -3.944  1.00 19.60           C
ATOM    100  CB  PHE     8       3.176  45.001  -2.822  1.00 22.71           C
ATOM    103  CG  PHE     8       3.951  44.177  -1.823  1.00 23.51           C
ATOM    104  CD1 PHE     8       3.439  42.949  -1.346  1.00 28.77           C
ATOM    106  CE1 PHE     8       4.152  42.173  -0.434  1.00 28.06           C
ATOM    108  CZ  PHE     8       5.373  42.635   0.031  1.00 28.78           C
ATOM    110  CE2 PHE     8       5.884  43.835  -0.423  1.00 30.30           C
ATOM    112  CD2 PHE     8       5.169  44.616  -1.353  1.00 28.10           C
ATOM    114  C   PHE     8       1.496  44.993  -4.689  1.00 22.06           C
ATOM    115  O   PHE     8       0.320  44.959  -4.316  1.00 17.45           O
ATOM    117  N   ARG     9       1.904  45.735  -5.712  1.00 20.32           N
ATOM    118  CA  ARG     9       0.939  46.442  -6.556  1.00 18.47           C
ATOM    120  CB  ARG     9       1.639  47.343  -7.542  1.00 20.96           C
ATOM    123  CG  ARG     9       0.718  48.210  -8.324  1.00 30.12           C
ATOM    126  CD  ARG     9       1.462  49.336  -8.973  1.00 33.72           C
ATOM    129  NE  ARG     9       0.560  50.358  -9.495  1.00 49.38           N
ATOM    131  CZ  ARG     9      -0.009  50.371 -10.710  1.00 50.88           C
ATOM    132  NH1 ARG     9       0.198  49.411 -11.626  1.00 36.54           N
ATOM    135  NH2 ARG     9      -0.779  51.400 -11.024  1.00 35.58           N
ATOM    138  C   ARG     9      -0.005  45.464  -7.267  1.00 18.25           C
ATOM    139  O   ARG     9      -1.217  45.710  -7.282  1.00 15.91           O
ATOM    141  N   GLU    10       0.522  44.363  -7.832  1.00 15.31           N
ATOM    142  CA  GLU    10      -0.351  43.339  -8.413  1.00 19.50           C
ATOM    144  CB  GLU    10       0.439  42.219  -9.076  1.00 21.24           C
ATOM    147  CG  GLU    10      -0.467  41.097  -9.566  1.00 23.10           C
ATOM    150  CD  GLU    10       0.189  40.117 -10.508  1.00 33.77           C
ATOM    151  OE1 GLU    10      -0.487  39.118 -10.845  1.00 26.89           O
ATOM    152  OE2 GLU    10       1.358  40.328 -10.890  1.00 26.18           O
ATOM    153  C   GLU    10      -1.355  42.768  -7.382  1.00 23.48           C
ATOM    154  O   GLU    10      -2.548  42.617  -7.692  1.00 16.96           O
ATOM    156  N   LEU    11      -0.871  42.447  -6.176  1.00 22.33           N
ATOM    157  CA  LEU    11      -1.756  42.020  -5.079  1.00 17.97           C
ATOM    159  CB  LEU    11      -0.969  41.736  -3.779  1.00 21.21           C
ATOM    162  CG  LEU    11      -1.851  41.320  -2.564  1.00 18.71           C
ATOM    164  CD1 LEU    11      -2.569  39.975  -2.827  1.00 16.49           C
ATOM    168  CD2 LEU    11      -1.052  41.296  -1.292  1.00 17.23           C
ATOM    172  C   LEU    11      -2.872  43.029  -4.826  1.00 18.50           C
ATOM    173  O   LEU    11      -4.018  42.652  -4.757  1.00 17.18           O
ATOM    175  N   ARG    12      -2.554  44.316  -4.710  1.00 16.81           N
ATOM    176  CA  ARG    12      -3.587  45.342  -4.508  1.00 18.76           C
ATOM    178  CB  ARG    12      -2.975  46.756  -4.299  1.00 15.68           C
ATOM    181  CG  ARG    12      -2.092  46.846  -3.060  1.00 20.36           C
ATOM    184  CD  ARG    12      -1.799  48.294  -2.715  1.00 24.48           C
ATOM    187  NE  ARG    12      -0.943  48.950  -3.696  1.00 19.83           N
ATOM    189  CZ  ARG    12       0.393  48.875  -3.740  1.00 17.58           C
ATOM    190  NH1 ARG    12       1.084  48.164  -2.878  1.00 25.76           N
ATOM    193  NH2 ARG    12       1.034  49.530  -4.686  1.00 24.92           N
ATOM    196  C   ARG    12      -4.628  45.388  -5.624  1.00 16.66           C
ATOM    197  O   ARG    12      -5.828  45.475  -5.353  1.00 16.08           O
ATOM    199  N   ILE    13      -4.164  45.301  -6.864  1.00 19.21           N
ATOM    200  CA  ILE    13      -5.044  45.236  -8.043  1.00 17.95           C
ATOM    202  CB  ILE    13      -4.224  45.209  -9.367  1.00 17.89           C
ATOM    204  CG1 ILE    13      -3.478  46.541  -9.577  1.00 23.66           C
ATOM    207  CD1 ILE    13      -2.498  46.500 -10.707  1.00 27.76           C
ATOM    211  CG2 ILE    13      -5.101  44.894 -10.587  1.00 24.21           C
ATOM    215  C   ILE    13      -5.997  44.011  -7.963  1.00 14.86           C
ATOM    216  O   ILE    13      -7.218  44.155  -8.154  1.00 16.18           O
ATOM    218  N   PHE    14      -5.438  42.857  -7.652  1.00 16.54           N
ATOM    219  CA  PHE    14      -6.211  41.642  -7.441  1.00 15.48           C
ATOM    221  CB  PHE    14      -5.313  40.456  -7.134  1.00 18.04           C
ATOM    224  CG  PHE    14      -6.074  39.237  -6.793  1.00 18.02           C
ATOM    225  CD1 PHE    14      -6.678  38.465  -7.790  1.00 26.02           C
ATOM    227  CE1 PHE    14      -7.424  37.332  -7.462  1.00 20.26           C
ATOM    229  CZ  PHE    14      -7.559  36.973  -6.149  1.00 20.14           C
ATOM    231  CE2 PHE    14      -6.970  37.746  -5.142  1.00 23.20           C
ATOM    233  CD2 PHE    14      -6.239  38.861  -5.465  1.00 22.05           C
ATOM    235  C   PHE    14      -7.252  41.824  -6.314  1.00 17.60           C
ATOM    236  O   PHE    14      -8.431  41.558  -6.507  1.00 16.66           O
ATOM    238  N   LEU    15      -6.807  42.332  -5.166  1.00 15.25           N
ATOM    239  CA  LEU    15      -7.701  42.555  -4.016  1.00 15.48           C
ATOM    241  CB  LEU    15      -6.921  42.915  -2.741  1.00 17.25           C
ATOM    244  CG  LEU    15      -5.972  41.845  -2.195  1.00 20.45           C
ATOM    246  CD1 LEU    15      -5.225  42.342  -0.920  1.00 15.28           C
ATOM    250  CD2 LEU    15      -6.687  40.491  -1.929  1.00 17.37           C
ATOM    254  C   LEU    15      -8.826  43.550  -4.269  1.00 16.03           C
ATOM    255  O   LEU    15      -9.961  43.320  -3.815  1.00 15.92           O
ATOM    257  N   ARG    16      -8.542  44.625  -4.980  1.00 16.38           N
ATOM    258  CA  ARG    16      -9.590  45.593  -5.363  1.00 13.95           C
ATOM    260  CB  ARG    16      -9.022  46.796  -6.096  1.00 16.47           C
ATOM    263  CG  ARG    16      -8.327  47.808  -5.243  1.00 20.20           C
ATOM    266  CD  ARG    16      -7.975  49.054  -6.021  1.00 26.38           C
ATOM    269  NE  ARG    16      -6.868  49.676  -5.338  1.00 24.76           N
ATOM    271  CZ  ARG    16      -5.583  49.547  -5.650  1.00 23.18           C
ATOM    272  NH1 ARG    16      -5.178  48.910  -6.742  1.00 24.86           N
ATOM    275  NH2 ARG    16      -4.686  50.121  -4.856  1.00 30.66           N
ATOM    278  C   ARG    16     -10.679  44.968  -6.259  1.00 13.93           C
ATOM    279  O   ARG    16     -11.864  45.248  -6.112  1.00 14.07           O
ATOM    281  N   ASN    17     -10.257  44.175  -7.218  1.00 16.80           N
ATOM    282  CA  ASN    17     -11.176  43.522  -8.112  1.00 18.78           C
ATOM    284  CB  ASN    17     -10.401  42.870  -9.247  1.00 21.01           C
ATOM    287  CG  ASN    17     -11.295  42.036 -10.170  1.00 28.67           C
ATOM    288  OD1 ASN    17     -11.469  40.838  -9.941  1.00 21.42           O
ATOM    289  ND2 ASN    17     -11.827  42.664 -11.250  1.00 28.09           N
ATOM    292  C   ASN    17     -12.089  42.535  -7.382  1.00 16.00           C
ATOM    293  O   ASN    17     -13.302  42.574  -7.591  1.00 17.86           O
ATOM    295  N   VAL    18     -11.520  41.689  -6.521  1.00 18.79           N
ATOM    296  CA  VAL    18     -12.301  40.735  -5.735  1.00 17.67           C
ATOM    298  CB  VAL    18     -11.407  39.847  -4.834  1.00 19.56           C
ATOM    300  CG1 VAL    18     -12.271  39.004  -3.891  1.00 20.84           C
ATOM    304  CG2 VAL    18     -10.450  38.989  -5.687  1.00 14.57           C
ATOM    308  C   VAL    18     -13.266  41.501  -4.810  1.00 17.37           C
ATOM    309  O   VAL    18     -14.450  41.176  -4.721  1.00 19.43           O
ATOM    311  N   THR    19     -12.747  42.526  -4.146  1.00 16.37           N
ATOM    312  CA  THR    19     -13.563  43.341  -3.222  1.00 17.39           C
ATOM    314  CB  THR    19     -12.716  44.371  -2.443  1.00 16.96           C
ATOM    316  OG1 THR    19     -11.617  43.710  -1.816  1.00 17.66           O
ATOM    318  CG2 THR    19     -13.564  45.076  -1.343  1.00 20.05           C
ATOM    322  C   THR    19     -14.744  44.026  -3.933  1.00 17.65           C
ATOM    323  O   THR    19     -15.852  44.020  -3.417  1.00 19.09           O
ATOM    325  N   HIS    20     -14.508  44.595  -5.101  1.00 19.93           N
ATOM    326  CA  HIS    20     -15.611  45.135  -5.920  1.00 19.72           C
ATOM    328  CB  HIS    20     -15.059  45.947  -7.086  0.50 21.68           C
ATOM    334  CG  HIS    20     -14.484  47.263  -6.651  0.50 31.09           C
ATOM    336  ND1 HIS    20     -15.103  48.066  -5.710  0.50 15.30           N
ATOM    340  CE1 HIS    20     -14.376  49.152  -5.520  0.50 31.02           C
ATOM    344  NE2 HIS    20     -13.308  49.082  -6.295  0.50 28.85           N
ATOM    348  CD2 HIS    20     -13.355  47.914  -7.019  0.50 25.42           C
ATOM    352  C   HIS    20     -16.660  44.095  -6.319  1.00 17.96           C
ATOM    353  O   HIS    20     -17.853  44.378  -6.303  1.00 20.97           O
ATOM    355  N   ARG    21     -16.230  42.894  -6.686  1.00 17.03           N
ATOM    356  CA  ARG    21     -17.180  41.826  -7.010  1.00 18.99           C
ATOM    358  CB  ARG    21     -16.435  40.624  -7.602  1.00 14.36           C
ATOM    361  CG  ARG    21     -15.970  40.922  -9.011  1.00 20.10           C
ATOM    364  CD  ARG    21     -14.704  40.187  -9.358  1.00 26.48           C
ATOM    367  NE  ARG    21     -14.976  38.798  -9.527  1.00 23.70           N
ATOM    369  CZ  ARG    21     -14.059  37.850  -9.652  1.00 24.65           C
ATOM    370  NH1 ARG    21     -12.773  38.120  -9.628  1.00 21.13           N
ATOM    373  NH2 ARG    21     -14.461  36.619  -9.815  1.00 21.77           N
ATOM    376  C   ARG    21     -18.083  41.435  -5.822  1.00 19.61           C
ATOM    377  O   ARG    21     -19.285  41.157  -5.992  1.00 23.33           O
ATOM    379  N   LEU    22     -17.522  41.469  -4.622  1.00 19.80           N
ATOM    380  CA  LEU    22     -18.300  41.281  -3.399  1.00 18.25           C
ATOM    382  CB  LEU    22     -17.378  41.023  -2.193  1.00 19.98           C
ATOM    385  CG  LEU    22     -16.345  39.907  -2.263  1.00 18.93           C
ATOM    387  CD1 LEU    22     -15.396  39.999  -1.040  1.00 20.62           C
ATOM    391  CD2 LEU    22     -17.018  38.495  -2.365  1.00 20.07           C
ATOM    395  C   LEU    22     -19.228  42.459  -3.101  1.00 20.64           C
ATOM    396  O   LEU    22     -20.415  42.251  -2.807  1.00 21.92           O
ATOM    398  N   ALA    23     -18.701  43.679  -3.190  1.00 17.45           N
ATOM    399  CA  ALA    23     -19.441  44.866  -2.847  1.00 17.66           C
ATOM    401  CB  ALA    23     -18.527  46.122  -2.822  1.00 21.62           C
ATOM    405  C   ALA    23     -20.644  45.119  -3.776  1.00 26.04           C
ATOM    406  O   ALA    23     -21.590  45.756  -3.360  1.00 22.48           O
ATOM    408  N   ILE    24     -20.612  44.639  -5.014  1.00 25.86           N
ATOM    409  CA  ILE    24     -21.755  44.832  -5.895  1.00 27.15           C
ATOM    411  CB  ILE    24     -21.344  45.044  -7.374  1.00 28.18           C
ATOM    413  CG1 ILE    24     -20.761  43.768  -7.966  1.00 23.99           C
ATOM    416  CD1 ILE    24     -20.472  43.872  -9.443  1.00 35.51           C
ATOM    420  CG2 ILE    24     -20.408  46.213  -7.489  1.00 34.25           C
ATOM    424  C   ILE    24     -22.790  43.706  -5.793  1.00 28.62           C
ATOM    425  O   ILE    24     -23.850  43.801  -6.384  1.00 26.67           O
ATOM    427  N   ASP    25     -22.498  42.646  -5.046  1.00 25.41           N
ATOM    428  CA  ASP    25     -23.433  41.566  -4.884  1.00 26.94           C
ATOM    430  CB  ASP    25     -22.726  40.350  -4.319  1.00 26.56           C
ATOM    433  CG  ASP    25     -23.578  39.107  -4.362  1.00 23.90           C
ATOM    434  OD1 ASP    25     -24.730  39.106  -3.846  1.00 26.48           O
ATOM    435  OD2 ASP    25     -23.072  38.101  -4.865  1.00 25.65           O
ATOM    436  C   ASP    25     -24.552  42.053  -3.944  1.00 28.65           C
ATOM    437  O   ASP    25     -24.284  42.520  -2.852  1.00 22.14           O
ATOM    439  N   LYS    26     -25.805  41.969  -4.394  1.00 30.84           N
ATOM    440  CA  LYS    26     -26.972  42.460  -3.624  1.00 30.71           C
ATOM    442  CB  LYS    26     -28.269  42.264  -4.436  1.00 33.89           C
ATOM    445  CG  LYS    26     -28.511  43.357  -5.458  1.00 44.49           C
ATOM    451  C   LYS    26     -27.110  41.822  -2.229  1.00 20.07           C
ATOM    452  O   LYS    26     -27.539  42.461  -1.284  1.00 26.43           O
ATOM    454  N   ARG    27     -26.680  40.589  -2.087  1.00 21.15           N
ATOM    455  CA  ARG    27     -26.707  39.913  -0.798  1.00 22.60           C
ATOM    457  CB  ARG    27     -26.242  38.480  -0.963  1.00 25.57           C
ATOM    460  CG  ARG    27     -27.146  37.636  -1.841  1.00 27.66           C
ATOM    463  CD  ARG    27     -26.556  36.286  -2.013  1.00 23.29           C
ATOM    466  NE  ARG    27     -25.338  36.340  -2.817  1.00 26.58           N
ATOM    468  CZ  ARG    27     -24.476  35.332  -2.941  1.00 23.01           C
ATOM    469  NH1 ARG    27     -24.685  34.189  -2.338  1.00 28.51           N
ATOM    472  NH2 ARG    27     -23.403  35.463  -3.696  1.00 28.09           N
ATOM    475  C   ARG    27     -25.817  40.557   0.265  1.00 24.98           C
ATOM    476  O   ARG    27     -26.053  40.397   1.473  1.00 25.35           O
ATOM    478  N   PHE    28     -24.801  41.282  -0.186  1.00 21.49           N
ATOM    479  CA  PHE    28     -23.726  41.741   0.688  1.00 23.72           C
ATOM    481  CB  PHE    28     -22.367  41.350   0.071  1.00 18.92           C
ATOM    484  CG  PHE    28     -22.222  39.873  -0.238  1.00 22.49           C
ATOM    485  CD1 PHE    28     -22.890  38.896   0.509  1.00 18.05           C
ATOM    487  CE1 PHE    28     -22.755  37.560   0.217  1.00 23.57           C
ATOM    489  CZ  PHE    28     -21.918  37.162  -0.818  1.00 19.66           C
ATOM    491  CE2 PHE    28     -21.237  38.120  -1.551  1.00 19.19           C
ATOM    493  CD2 PHE    28     -21.387  39.456  -1.252  1.00 20.61           C
ATOM    495  C   PHE    28     -23.809  43.225   0.963  1.00 20.64           C
ATOM    496  O   PHE    28     -22.922  43.802   1.621  1.00 21.40           O
ATOM    498  N   ARG    29     -24.903  43.860   0.528  1.00 25.62           N
ATOM    499  CA  ARG    29     -25.106  45.308   0.727  1.00 25.06           C
ATOM    501  CB  ARG    29     -26.492  45.749   0.199  1.00 28.09           C
ATOM    504  CG  ARG    29     -26.750  47.252   0.234  1.00 35.00           C
ATOM    507  CD  ARG    29     -28.236  47.617   0.028  1.00 56.20           C
ATOM    510  NE  ARG    29     -29.158  46.670   0.671  1.00 80.68           N
ATOM    512  CZ  ARG    29     -29.425  46.591   1.982  1.00 79.44           C
ATOM    513  NH1 ARG    29     -28.846  47.409   2.863  1.00 66.15           N
ATOM    516  NH2 ARG    29     -30.277  45.662   2.420  1.00 79.04           N
ATOM    519  C   ARG    29     -24.931  45.753   2.180  1.00 20.06           C
ATOM    520  O   ARG    29     -24.355  46.816   2.424  1.00 26.41           O
ATOM    522  N   VAL    30     -25.391  44.932   3.117  1.00 27.21           N
ATOM    523  CA  VAL    30     -25.289  45.215   4.553  1.00 33.63           C
ATOM    525  CB  VAL    30     -26.019  44.115   5.436  1.00 38.16           C
ATOM    527  CG1 VAL    30     -25.513  42.687   5.162  1.00 30.77           C
ATOM    531  CG2 VAL    30     -25.887  44.414   6.918  1.00 51.45           C
ATOM    535  C   VAL    30     -23.825  45.365   5.002  1.00 33.95           C
ATOM    536  O   VAL    30     -23.536  46.052   5.976  1.00 28.60           O
ATOM    538  N   PHE    31     -22.908  44.747   4.262  1.00 27.31           N
ATOM    539  CA  PHE    31     -21.483  44.731   4.632  1.00 23.37           C
ATOM    541  CB  PHE    31     -20.917  43.326   4.423  1.00 24.67           C
ATOM    544  CG  PHE    31     -21.743  42.236   5.027  1.00 23.53           C
ATOM    545  CD1 PHE    31     -21.987  42.193   6.401  1.00 24.92           C
ATOM    547  CE1 PHE    31     -22.759  41.189   6.950  1.00 34.33           C
ATOM    549  CZ  PHE    31     -23.268  40.181   6.142  1.00 26.48           C
ATOM    551  CE2 PHE    31     -23.027  40.198   4.778  1.00 23.80           C
ATOM    553  CD2 PHE    31     -22.274  41.225   4.222  1.00 23.54           C
ATOM    555  C   PHE    31     -20.667  45.756   3.856  1.00 25.64           C
ATOM    556  O   PHE    31     -19.440  45.777   3.960  1.00 24.17           O
ATOM    558  N   THR    32     -21.344  46.619   3.093  1.00 24.94           N
ATOM    559  CA  THR    32     -20.680  47.593   2.255  1.00 23.72           C
ATOM    561  CB  THR    32     -21.469  47.932   0.964  1.00 31.83           C
ATOM    563  OG1 THR    32     -22.742  48.526   1.288  1.00 32.27           O
ATOM    565  CG2 THR    32     -21.633  46.678   0.069  1.00 22.27           C
ATOM    569  C   THR    32     -20.378  48.901   3.005  1.00 29.48           C
ATOM    570  O   THR    32     -19.567  49.691   2.546  1.00 30.50           O
ATOM    572  N   LYS    33     -21.018  49.116   4.153  1.00 29.86           N
ATOM    573  CA  LYS    33     -20.827  50.362   4.910  1.00 35.76           C
ATOM    575  CB  LYS    33     -22.004  51.342   4.691  1.00 36.32           C
ATOM    578  CG  LYS    33     -22.005  52.062   3.342  1.00 51.13           C
ATOM    581  CD  LYS    33     -23.340  52.779   3.070  1.00 45.23           C
ATOM    586  C   LYS    33     -20.703  50.066   6.387  1.00 30.75           C
ATOM    587  O   LYS    33     -21.211  49.038   6.877  1.00 34.04           O
ATOM    589  N   PRO    34     -20.022  50.975   7.124  1.00 40.34           N
ATOM    590  CA  PRO    34     -20.024  50.887   8.573  1.00 43.78           C
ATOM    592  CB  PRO    34     -19.289  52.160   9.007  1.00 44.37           C
ATOM    595  CG  PRO    34     -18.458  52.547   7.868  1.00 40.69           C
ATOM    598  CD  PRO    34     -19.251  52.142   6.652  1.00 39.52           C
ATOM    601  C   PRO    34     -21.445  50.906   9.117  1.00 46.49           C
ATOM    602  O   PRO    34     -22.348  51.411   8.462  1.00 46.86           O
ATOM    603  N   VAL    35     -21.629  50.357  10.306  1.00 52.73           N
ATOM    604  CA  VAL    35     -22.905  50.435  11.002  1.00 56.02           C
ATOM    606  CB  VAL    35     -22.963  49.408  12.141  1.00 52.91           C
ATOM    608  CG1 VAL    35     -22.966  47.996  11.569  1.00 47.77           C
ATOM    612  CG2 VAL    35     -24.191  49.658  13.016  1.00 45.00           C
ATOM    616  C   VAL    35     -23.139  51.853  11.562  1.00 63.10           C
ATOM    617  O   VAL    35     -22.258  52.435  12.205  1.00 67.79           O
ATOM    619  N   ASP    36     -24.333  52.394  11.320  1.00 66.89           N
ATOM    620  CA  ASP    36     -24.676  53.763  11.725  1.00 68.61           C
ATOM    622  CB  ASP    36     -25.929  54.218  10.964  1.00 70.39           C
ATOM    625  CG  ASP    36     -26.175  55.714  11.064  1.00 77.61           C
ATOM    626  OD1 ASP    36     -25.201  56.485  11.219  1.00 70.69           O
ATOM    627  OD2 ASP    36     -27.355  56.117  10.971  1.00 90.64           O
ATOM    628  C   ASP    36     -24.898  53.861  13.254  1.00 67.11           C
ATOM    629  O   ASP    36     -25.795  53.199  13.800  1.00 56.69           O
ATOM    631  N   PRO    37     -24.081  54.685  13.951  1.00 70.78           N
ATOM    632  CA  PRO    37     -24.197  54.744  15.420  1.00 75.96           C
ATOM    634  CB  PRO    37     -23.059  55.691  15.834  1.00 75.72           C
ATOM    637  CG  PRO    37     -22.765  56.499  14.625  1.00 71.83           C
ATOM    640  CD  PRO    37     -23.059  55.621  13.443  1.00 67.24           C
ATOM    643  C   PRO    37     -25.552  55.273  15.901  1.00 80.35           C
ATOM    644  O   PRO    37     -25.932  55.035  17.050  1.00 83.21           O
ATOM    645  N   ASP    38     -26.266  55.976  15.023  1.00 83.08           N
ATOM    646  CA  ASP    38     -27.612  56.454  15.320  1.00 85.90           C
ATOM    648  CB  ASP    38     -28.032  57.549  14.332  1.00 86.22           C
ATOM    651  CG  ASP    38     -26.946  58.600  14.122  1.00 91.26           C
ATOM    652  OD1 ASP    38     -26.291  59.000  15.112  1.00 80.39           O
ATOM    653  OD2 ASP    38     -26.747  59.019  12.960  1.00 95.27           O
ATOM    654  C   ASP    38     -28.582  55.275  15.258  1.00 86.84           C
ATOM    655  O   ASP    38     -29.307  55.008  16.220  1.00 87.15           O
ATOM    657  N   GLU    39     -28.574  54.568  14.127  1.00 85.88           N
ATOM    658  CA  GLU    39     -29.421  53.389  13.941  1.00 84.58           C
ATOM    660  CB  GLU    39     -29.302  52.861  12.505  1.00 83.92           C
ATOM    667  C   GLU    39     -29.085  52.284  14.956  1.00 84.18           C
ATOM    668  O   GLU    39     -29.990  51.719  15.580  1.00 83.93           O
ATOM    670  N   VAL    40     -27.791  51.994  15.127  1.00 82.97           N
ATOM    671  CA  VAL    40     -27.326  50.952  16.059  1.00 79.76           C
ATOM    673  CB  VAL    40     -26.710  49.752  15.311  1.00 77.63           C
ATOM    675  CG1 VAL    40     -26.842  48.498  16.145  1.00 78.57           C
ATOM    679  CG2 VAL    40     -27.387  49.554  13.963  1.00 78.81           C
ATOM    683  C   VAL    40     -26.291  51.535  17.035  1.00 78.94           C
ATOM    684  O   VAL    40     -25.088  51.526  16.748  1.00 74.58           O
ATOM    686  N   PRO    41     -26.760  52.045  18.194  1.00 78.72           N
ATOM    687  CA  PRO    41     -25.885  52.767  19.130  1.00 75.46           C
ATOM    689  CB  PRO    41     -26.876  53.520  20.018  1.00 76.25           C
ATOM    692  CG  PRO    41     -28.089  52.638  20.045  1.00 80.48           C
ATOM    695  CD  PRO    41     -28.127  51.890  18.730  1.00 78.09           C
ATOM    698  C   PRO    41     -24.988  51.852  19.962  1.00 69.89           C
ATOM    699  O   PRO    41     -23.862  52.235  20.284  1.00 71.29           O
ATOM    700  N   ASP    42     -25.477  50.655  20.285  1.00 64.93           N
ATOM    701  CA  ASP    42     -24.691  49.667  21.019  1.00 63.01           C
ATOM    703  CB  ASP    42     -25.616  48.712  21.801  1.00 65.05           C
ATOM    706  CG  ASP    42     -26.381  47.740  20.897  1.00 71.38           C
ATOM    707  OD1 ASP    42     -26.382  46.515  21.186  1.00 60.91           O
ATOM    708  OD2 ASP    42     -26.976  48.203  19.898  1.00 69.09           O
ATOM    709  C   ASP    42     -23.718  48.855  20.136  1.00 59.52           C
ATOM    710  O   ASP    42     -23.081  47.928  20.638  1.00 59.30           O
ATOM    712  N   TYR    43     -23.594  49.186  18.846  1.00 56.70           N
ATOM    713  CA  TYR    43     -22.720  48.402  17.952  1.00 54.71           C
ATOM    715  CB  TYR    43     -22.915  48.743  16.459  1.00 55.68           C
ATOM    718  CG  TYR    43     -22.255  47.707  15.545  1.00 45.79           C
ATOM    719  CD1 TYR    43     -22.908  46.519  15.245  1.00 50.75           C
ATOM    721  CE1 TYR    43     -22.322  45.546  14.436  1.00 42.58           C
ATOM    723  CZ  TYR    43     -21.059  45.744  13.920  1.00 34.68           C
ATOM    724  OH  TYR    43     -20.527  44.734  13.135  1.00 39.12           O
ATOM    726  CE2 TYR    43     -20.356  46.913  14.209  1.00 37.57           C
ATOM    728  CD2 TYR    43     -20.960  47.892  15.032  1.00 43.68           C
ATOM    730  C   TYR    43     -21.254  48.600  18.320  1.00 54.18           C
ATOM    731  O   TYR    43     -20.523  47.623  18.531  1.00 48.20           O
ATOM    733  N   VAL    44     -20.847  49.871  18.391  1.00 52.45           N
ATOM    734  CA  VAL    44     -19.454  50.239  18.637  1.00 55.94           C
ATOM    736  CB  VAL    44     -19.192  51.763  18.333  1.00 58.13           C
ATOM    738  CG1 VAL    44     -18.220  52.399  19.327  1.00 58.75           C
ATOM    742  CG2 VAL    44     -18.684  51.920  16.908  1.00 47.76           C
ATOM    746  C   VAL    44     -18.945  49.796  20.025  1.00 50.89           C
ATOM    747  O   VAL    44     -17.731  49.688  20.217  1.00 47.72           O
ATOM    749  N   THR    45     -19.866  49.487  20.947  1.00 49.61           N
ATOM    750  CA  THR    45     -19.520  48.909  22.259  1.00 48.11           C
ATOM    752  CB  THR    45     -20.445  49.461  23.395  1.00 52.57           C
ATOM    754  OG1 THR    45     -21.668  48.713  23.469  1.00 60.63           O
ATOM    756  CG2 THR    45     -20.767  50.929  23.165  1.00 43.51           C
ATOM    760  C   THR    45     -19.511  47.359  22.271  1.00 46.13           C
ATOM    761  O   THR    45     -18.704  46.746  22.995  1.00 44.43           O
ATOM    763  N   VAL    46     -20.385  46.723  21.480  1.00 42.70           N
ATOM    764  CA  VAL    46     -20.404  45.243  21.371  1.00 40.23           C
ATOM    766  CB  VAL    46     -21.778  44.712  20.870  1.00 44.94           C
ATOM    768  CG1 VAL    46     -21.747  43.180  20.691  1.00 46.94           C
ATOM    772  CG2 VAL    46     -22.893  45.133  21.829  1.00 44.05           C
ATOM    776  C   VAL    46     -19.287  44.702  20.453  1.00 36.60           C
ATOM    777  O   VAL    46     -18.654  43.673  20.744  1.00 38.38           O
ATOM    779  N   ILE    47     -19.065  45.396  19.341  1.00 30.45           N
ATOM    780  CA  ILE    47     -18.111  44.965  18.328  1.00 32.39           C
ATOM    782  CB  ILE    47     -18.734  44.983  16.890  1.00 35.54           C
ATOM    784  CG1 ILE    47     -19.956  44.028  16.779  1.00 27.28           C
ATOM    787  CD1 ILE    47     -19.707  42.525  17.097  1.00 23.48           C
ATOM    791  CG2 ILE    47     -17.682  44.619  15.842  1.00 25.81           C
ATOM    795  C   ILE    47     -16.864  45.865  18.401  1.00 33.66           C
ATOM    796  O   ILE    47     -16.883  47.050  18.031  1.00 36.10           O
ATOM    798  N   LYS    48     -15.798  45.270  18.901  1.00 33.32           N
ATOM    799  CA  LYS    48     -14.550  45.963  19.207  1.00 31.72           C
ATOM    801  CB  LYS    48     -13.689  45.068  20.118  1.00 31.65           C
ATOM    804  CG  LYS    48     -14.387  44.729  21.453  1.00 39.44           C
ATOM    807  CD  LYS    48     -14.892  46.002  22.158  1.00 43.13           C
ATOM    810  CE  LYS    48     -15.676  45.714  23.404  1.00 47.78           C
ATOM    813  NZ  LYS    48     -16.182  47.011  23.956  1.00 44.33           N
ATOM    817  C   LYS    48     -13.751  46.353  17.977  1.00 33.20           C
ATOM    818  O   LYS    48     -13.014  47.339  18.022  1.00 27.97           O
ATOM    820  N   GLN    49     -13.914  45.583  16.895  1.00 30.48           N
ATOM    821  CA  GLN    49     -13.217  45.843  15.662  1.00 32.30           C
ATOM    823  CB  GLN    49     -12.049  44.864  15.505  1.00 29.28           C
ATOM    826  CG  GLN    49     -11.013  45.463  14.632  1.00 39.19           C
ATOM    829  CD  GLN    49      -9.769  44.633  14.478  1.00 36.19           C
ATOM    830  OE1 GLN    49      -8.860  45.072  13.783  1.00 40.56           O
ATOM    831  NE2 GLN    49      -9.711  43.427  15.107  1.00 33.13           N
ATOM    834  C   GLN    49     -14.181  45.755  14.477  1.00 28.07           C
ATOM    835  O   GLN    49     -14.234  44.724  13.793  1.00 28.15           O
ATOM    837  N   PRO    50     -14.949  46.835  14.245  1.00 29.22           N
ATOM    838  CA  PRO    50     -15.875  46.936  13.125  1.00 27.66           C
ATOM    840  CB  PRO    50     -16.369  48.378  13.211  1.00 30.49           C
ATOM    843  CG  PRO    50     -16.195  48.758  14.591  1.00 36.52           C
ATOM    846  CD  PRO    50     -15.042  48.013  15.122  1.00 26.98           C
ATOM    849  C   PRO    50     -15.126  46.763  11.815  1.00 31.26           C
ATOM    850  O   PRO    50     -14.027  47.278  11.679  1.00 23.71           O
ATOM    851  N   MET    51     -15.696  46.044  10.861  1.00 21.15           N
ATOM    852  CA  MET    51     -15.055  45.935   9.533  1.00 22.60           C
ATOM    854  CB  MET    51     -14.158  44.700   9.485  1.00 21.22           C
ATOM    857  CG  MET    51     -13.218  44.584   8.232  1.00 20.96           C
ATOM    860  SD  MET    51     -12.243  46.051   7.847  1.00 26.36           S
ATOM    861  CE  MET    51     -11.246  46.176   9.359  1.00 22.19           C
ATOM    865  C   MET    51     -16.166  45.867   8.493  1.00 23.15           C
ATOM    866  O   MET    51     -17.221  45.344   8.772  1.00 23.61           O
ATOM    868  N   ASP    52     -15.924  46.436   7.328  1.00 24.76           N
ATOM    869  CA  ASP    52     -16.879  46.392   6.231  1.00 27.19           C
ATOM    871  CB  ASP    52     -17.922  47.511   6.360  1.00 26.13           C
ATOM    874  CG  ASP    52     -17.330  48.890   6.169  1.00 29.38           C
ATOM    875  OD1 ASP    52     -16.775  49.471   7.125  1.00 45.75           O
ATOM    876  OD2 ASP    52     -17.407  49.400   5.059  1.00 31.49           O
ATOM    877  C   ASP    52     -16.084  46.513   4.949  1.00 24.29           C
ATOM    878  O   ASP    52     -14.881  46.799   4.992  1.00 20.17           O
ATOM    880  N   LEU    53     -16.745  46.316   3.812  1.00 19.93           N
ATOM    881  CA  LEU    53     -16.042  46.295   2.513  1.00 22.93           C
ATOM    883  CB  LEU    53     -16.947  45.717   1.416  1.00 23.99           C
ATOM    886  CG  LEU    53     -17.426  44.279   1.629  1.00 25.34           C
ATOM    888  CD1 LEU    53     -18.492  43.886   0.568  1.00 17.36           C
ATOM    892  CD2 LEU    53     -16.274  43.274   1.667  1.00 17.56           C
ATOM    896  C   LEU    53     -15.496  47.665   2.091  1.00 25.54           C
ATOM    897  O   LEU    53     -14.483  47.745   1.360  1.00 19.91           O
ATOM    899  N   SER    54     -16.118  48.753   2.553  1.00 28.29           N
ATOM    900  CA  SER    54     -15.543  50.087   2.272  1.00 25.79           C
ATOM    902  CB  SER    54     -16.504  51.211   2.684  0.50 23.77           C
ATOM    908  OG  SER    54     -16.659  51.265   4.097  0.50 28.65           O
ATOM    912  C   SER    54     -14.227  50.281   3.014  1.00 20.81           C
ATOM    913  O   SER    54     -13.287  50.890   2.484  1.00 25.29           O
ATOM    915  N   SER    55     -14.176  49.791   4.241  1.00 23.85           N
ATOM    916  CA  SER    55     -12.940  49.887   5.038  1.00 28.64           C
ATOM    918  CB  SER    55     -13.218  49.548   6.498  1.00 26.98           C
ATOM    921  OG  SER    55     -14.248  50.389   7.006  1.00 35.24           O
ATOM    923  C   SER    55     -11.851  48.986   4.446  1.00 24.61           C
ATOM    924  O   SER    55     -10.673  49.347   4.432  1.00 22.37           O
ATOM    926  N   VAL    56     -12.257  47.833   3.912  1.00 22.80           N
ATOM    927  CA  VAL    56     -11.319  46.945   3.189  1.00 18.59           C
ATOM    929  CB  VAL    56     -11.984  45.581   2.798  1.00 17.04           C
ATOM    931  CG1 VAL    56     -11.131  44.796   1.802  1.00 18.98           C
ATOM    935  CG2 VAL    56     -12.279  44.718   4.064  1.00 19.48           C
ATOM    939  C   VAL    56     -10.697  47.650   1.997  1.00 17.03           C
ATOM    940  O   VAL    56      -9.478  47.572   1.825  1.00 19.42           O
ATOM    942  N   ILE    57     -11.496  48.352   1.177  1.00 17.41           N
ATOM    943  CA  ILE    57     -10.955  49.092   0.032  1.00 20.50           C
ATOM    945  CB  ILE    57     -12.062  49.736  -0.876  1.00 23.10           C
ATOM    947  CG1 ILE    57     -12.835  48.672  -1.676  1.00 22.23           C
ATOM    950  CD1 ILE    57     -12.019  48.001  -2.756  1.00 28.19           C
ATOM    954  CG2 ILE    57     -11.454  50.774  -1.819  1.00 25.28           C
ATOM    958  C   ILE    57      -9.960  50.162   0.503  1.00 19.54           C
ATOM    959  O   ILE    57      -8.878  50.288  -0.056  1.00 17.87           O
ATOM    961  N   SER    58     -10.317  50.912   1.539  1.00 23.61           N
ATOM    962  CA  SER    58      -9.392  51.897   2.129  1.00 21.37           C
ATOM    964  CB  SER    58     -10.054  52.624   3.304  1.00 26.17           C
ATOM    967  OG  SER    58     -11.054  53.483   2.846  1.00 29.50           O
ATOM    969  C   SER    58      -8.045  51.272   2.584  1.00 18.72           C
ATOM    970  O   SER    58      -6.973  51.822   2.297  1.00 21.54           O
ATOM    972  N   LYS    59      -8.108  50.123   3.249  1.00 20.54           N
ATOM    973  CA  LYS    59      -6.924  49.433   3.712  1.00 16.63           C
ATOM    975  CB  LYS    59      -7.293  48.329   4.700  1.00 17.74           C
ATOM    978  CG  LYS    59      -7.723  48.901   6.077  1.00 21.37           C
ATOM    981  CD  LYS    59      -8.114  47.798   7.067  1.00 19.34           C
ATOM    984  CE  LYS    59      -6.893  47.119   7.670  1.00 20.09           C
ATOM    987  NZ  LYS    59      -7.200  46.047   8.619  1.00 19.43           N
ATOM    991  C   LYS    59      -6.034  48.918   2.559  1.00 15.54           C
ATOM    992  O   LYS    59      -4.816  48.973   2.659  1.00 16.76           O
ATOM    994  N   ILE    60      -6.643  48.453   1.467  1.00 17.14           N
ATOM    995  CA  ILE    60      -5.871  48.056   0.280  1.00 17.12           C
ATOM    997  CB  ILE    60      -6.783  47.630  -0.911  1.00 18.90           C
ATOM    999  CG1 ILE    60      -7.619  46.371  -0.546  1.00 20.67           C
ATOM   1002  CD1 ILE    60      -8.756  46.014  -1.549  1.00 16.51           C
ATOM   1006  CG2 ILE    60      -5.914  47.410  -2.191  1.00 15.27           C
ATOM   1010  C   ILE    60      -4.983  49.238  -0.173  1.00 16.88           C
ATOM   1011  O   ILE    60      -3.762  49.112  -0.345  1.00 18.43           O
ATOM   1013  N   ASP    61      -5.640  50.373  -0.349  1.00 18.18           N
ATOM   1014  CA  ASP    61      -5.022  51.581  -0.838  1.00 21.27           C
ATOM   1016  CB  ASP    61      -6.111  52.614  -1.131  1.00 20.70           C
ATOM   1019  CG  ASP    61      -6.998  52.220  -2.305  1.00 32.84           C
ATOM   1020  OD1 ASP    61      -6.667  51.259  -3.026  1.00 27.00           O
ATOM   1021  OD2 ASP    61      -8.033  52.884  -2.509  1.00 25.46           O
ATOM   1022  C   ASP    61      -3.976  52.136   0.138  1.00 24.20           C
ATOM   1023  O   ASP    61      -2.950  52.691  -0.290  1.00 21.34           O
ATOM   1025  N   LEU    62      -4.190  51.924   1.436  1.00 22.90           N
ATOM   1026  CA  LEU    62      -3.176  52.248   2.457  1.00 23.80           C
ATOM   1028  CB  LEU    62      -3.850  52.442   3.827  1.00 18.19           C
ATOM   1031  CG  LEU    62      -4.757  53.639   4.064  1.00 23.24           C
ATOM   1033  CD1 LEU    62      -5.442  53.427   5.439  1.00 20.00           C
ATOM   1037  CD2 LEU    62      -3.927  54.941   4.004  1.00 20.71           C
ATOM   1041  C   LEU    62      -2.071  51.194   2.585  1.00 24.78           C
ATOM   1042  O   LEU    62      -1.231  51.288   3.456  1.00 23.89           O
ATOM   1044  N   HIS    63      -2.050  50.185   1.712  1.00 21.03           N
ATOM   1045  CA  HIS    63      -1.018  49.156   1.698  1.00 18.83           C
ATOM   1047  CB  HIS    63       0.395  49.728   1.399  1.00 22.34           C
ATOM   1050  CG  HIS    63       0.488  50.497   0.129  1.00 22.10           C
ATOM   1051  ND1 HIS    63       1.698  50.841  -0.426  1.00 25.42           N
ATOM   1053  CE1 HIS    63       1.486  51.534  -1.530  1.00 20.87           C
ATOM   1055  NE2 HIS    63       0.184  51.589  -1.748  1.00 27.01           N
ATOM   1057  CD2 HIS    63      -0.462  50.954  -0.722  1.00 27.64           C
ATOM   1059  C   HIS    63      -0.971  48.336   2.982  1.00 21.67           C
ATOM   1060  O   HIS    63       0.070  47.885   3.388  1.00 22.07           O
ATOM   1062  N   LYS    64      -2.122  48.098   3.586  1.00 22.14           N
ATOM   1063  CA  LYS    64      -2.188  47.316   4.796  1.00 21.91           C
ATOM   1065  CB  LYS    64      -3.440  47.663   5.583  1.00 19.04           C
ATOM   1068  CG  LYS    64      -3.536  49.112   5.934  1.00 24.59           C
ATOM   1071  CD  LYS    64      -2.562  49.504   6.961  1.00 30.67           C
ATOM   1074  CE  LYS    64      -2.888  50.916   7.485  1.00 48.26           C
ATOM   1077  NZ  LYS    64      -2.018  51.276   8.627  1.00 47.20           N
ATOM   1081  C   LYS    64      -2.194  45.831   4.565  1.00 23.75           C
ATOM   1082  O   LYS    64      -1.981  45.077   5.507  1.00 18.75           O
ATOM   1084  N   TYR    65      -2.463  45.407   3.337  1.00 21.37           N
ATOM   1085  CA  TYR    65      -2.490  43.990   3.044  1.00 17.52           C
ATOM   1087  CB  TYR    65      -3.788  43.577   2.327  1.00 15.32           C
ATOM   1090  CG  TYR    65      -5.083  43.992   3.050  1.00 16.36           C
ATOM   1091  CD1 TYR    65      -5.359  43.565   4.331  1.00 19.84           C
ATOM   1093  CE1 TYR    65      -6.552  43.924   4.968  1.00 19.40           C
ATOM   1095  CZ  TYR    65      -7.501  44.701   4.296  1.00 15.48           C
ATOM   1096  OH  TYR    65      -8.679  45.058   4.902  1.00 18.10           O
ATOM   1098  CE2 TYR    65      -7.266  45.119   3.033  1.00 17.29           C
ATOM   1100  CD2 TYR    65      -6.057  44.751   2.395  1.00 16.43           C
ATOM   1102  C   TYR    65      -1.301  43.672   2.162  1.00 21.48           C
ATOM   1103  O   TYR    65      -1.258  44.066   1.007  1.00 22.79           O
ATOM   1105  N   LEU    66      -0.346  42.935   2.713  1.00 19.79           N
ATOM   1106  CA  LEU    66       0.847  42.523   1.958  1.00 23.12           C
ATOM   1108  CB  LEU    66       2.089  42.712   2.836  1.00 25.01           C
ATOM   1111  CG  LEU    66       2.439  44.137   3.294  1.00 32.61           C
ATOM   1113  CD1 LEU    66       3.862  44.119   3.908  1.00 37.41           C
ATOM   1117  CD2 LEU    66       2.368  45.115   2.195  1.00 30.09           C
ATOM   1121  C   LEU    66       0.743  41.062   1.481  1.00 22.04           C
ATOM   1122  O   LEU    66       1.557  40.601   0.688  1.00 21.03           O
ATOM   1124  N   THR    67      -0.256  40.344   1.990  1.00 20.44           N
ATOM   1125  CA  THR    67      -0.543  38.972   1.589  1.00 19.04           C
ATOM   1127  CB  THR    67       0.039  37.928   2.563  1.00 18.54           C
ATOM   1129  OG1 THR    67      -0.742  37.899   3.757  1.00 21.70           O
ATOM   1131  CG2 THR    67       1.506  38.214   2.937  1.00 20.92           C
ATOM   1135  C   THR    67      -2.077  38.771   1.534  1.00 20.22           C
ATOM   1136  O   THR    67      -2.848  39.552   2.115  1.00 18.31           O
ATOM   1138  N   VAL    68      -2.518  37.724   0.835  1.00 16.57           N
ATOM   1139  CA  VAL    68      -3.937  37.398   0.800  1.00 19.83           C
ATOM   1141  CB  VAL    68      -4.303  36.338  -0.283  1.00 19.37           C
ATOM   1143  CG1 VAL    68      -5.768  36.553  -0.786  1.00 24.52           C
ATOM   1147  CG2 VAL    68      -4.149  34.918   0.242  1.00 25.02           C
ATOM   1151  C   VAL    68      -4.424  36.961   2.180  1.00 22.55           C
ATOM   1152  O   VAL    68      -5.586  37.163   2.527  1.00 18.78           O
ATOM   1154  N   LYS    69      -3.550  36.353   2.984  1.00 22.17           N
ATOM   1155  CA  LYS    69      -3.917  36.039   4.372  1.00 26.13           C
ATOM   1157  CB  LYS    69      -2.773  35.296   5.084  1.00 33.70           C
ATOM   1160  CG  LYS    69      -2.648  33.854   4.646  1.00 34.43           C
ATOM   1163  CD  LYS    69      -1.703  33.079   5.573  1.00 45.50           C
ATOM   1168  C   LYS    69      -4.365  37.232   5.216  1.00 21.88           C
ATOM   1169  O   LYS    69      -5.357  37.131   5.952  1.00 23.88           O
ATOM   1171  N   ASP    70      -3.647  38.346   5.089  1.00 19.84           N
ATOM   1172  CA  ASP    70      -3.959  39.615   5.762  1.00 24.88           C
ATOM   1174  CB  ASP    70      -2.992  40.738   5.326  1.00 26.51           C
ATOM   1177  CG  ASP    70      -1.541  40.593   5.828  1.00 34.56           C
ATOM   1178  OD1 ASP    70      -1.244  39.787   6.721  1.00 27.92           O
ATOM   1179  OD2 ASP    70      -0.694  41.379   5.313  1.00 34.87           O
ATOM   1180  C   ASP    70      -5.381  40.087   5.352  1.00 27.16           C
ATOM   1181  O   ASP    70      -6.205  40.493   6.187  1.00 20.43           O
ATOM   1183  N   TYR    71      -5.625  40.070   4.045  1.00 23.04           N
ATOM   1184  CA  TYR    71      -6.940  40.435   3.471  1.00 17.48           C
ATOM   1186  CB  TYR    71      -6.849  40.328   1.955  1.00 19.62           C
ATOM   1189  CG  TYR    71      -8.147  40.516   1.226  1.00 15.66           C
ATOM   1190  CD1 TYR    71      -8.624  41.803   0.949  1.00 15.77           C
ATOM   1192  CE1 TYR    71      -9.795  41.991   0.265  1.00 17.42           C
ATOM   1194  CZ  TYR    71     -10.536  40.878  -0.163  1.00 18.81           C
ATOM   1195  OH  TYR    71     -11.681  41.085  -0.870  1.00 16.07           O
ATOM   1197  CE2 TYR    71     -10.079  39.593   0.061  1.00 15.40           C
ATOM   1199  CD2 TYR    71      -8.886  39.406   0.764  1.00 17.77           C
ATOM   1201  C   TYR    71      -8.074  39.536   3.979  1.00 17.40           C
ATOM   1202  O   TYR    71      -9.115  40.032   4.445  1.00 18.24           O
ATOM   1204  N   LEU    72      -7.871  38.226   3.892  1.00 18.72           N
ATOM   1205  CA  LEU    72      -8.874  37.252   4.349  1.00 21.15           C
ATOM   1207  CB  LEU    72      -8.512  35.826   3.932  1.00 16.77           C
ATOM   1210  CG  LEU    72      -8.718  35.566   2.443  1.00 25.64           C
ATOM   1212  CD1 LEU    72      -8.040  34.297   2.112  1.00 19.37           C
ATOM   1216  CD2 LEU    72     -10.215  35.535   2.012  1.00 25.53           C
ATOM   1220  C   LEU    72      -9.182  37.340   5.843  1.00 26.45           C
ATOM   1221  O   LEU    72     -10.302  37.066   6.250  1.00 23.04           O
ATOM   1223  N   ARG    73      -8.219  37.790   6.636  1.00 22.93           N
ATOM   1224  CA  ARG    73      -8.434  38.055   8.047  1.00 28.03           C
ATOM   1226  CB  ARG    73      -7.122  38.490   8.726  1.00 31.55           C
ATOM   1229  CG  ARG    73      -7.105  38.285  10.212  1.00 38.49           C
ATOM   1232  CD  ARG    73      -5.699  38.518  10.812  1.00 49.01           C
ATOM   1235  NE  ARG    73      -4.676  37.784  10.065  1.00 44.82           N
ATOM   1237  CZ  ARG    73      -3.669  38.325   9.374  1.00 55.88           C
ATOM   1238  NH1 ARG    73      -3.476  39.648   9.322  1.00 40.38           N
ATOM   1241  NH2 ARG    73      -2.831  37.518   8.726  1.00 56.97           N
ATOM   1244  C   ARG    73      -9.524  39.098   8.278  1.00 18.44           C
ATOM   1245  O   ARG    73     -10.365  38.890   9.124  1.00 19.51           O
ATOM   1247  N   ASP    74      -9.523  40.171   7.494  1.00 18.76           N
ATOM   1248  CA  ASP    74     -10.571  41.193   7.504  1.00 16.55           C
ATOM   1250  CB  ASP    74     -10.082  42.492   6.874  1.00 19.52           C
ATOM   1253  CG  ASP    74      -9.294  43.326   7.848  1.00 24.75           C
ATOM   1254  OD1 ASP    74      -9.271  42.928   9.020  1.00 20.14           O
ATOM   1255  OD2 ASP    74      -8.719  44.344   7.449  1.00 22.36           O
ATOM   1256  C   ASP    74     -11.916  40.769   6.894  1.00 21.92           C
ATOM   1257  O   ASP    74     -12.975  41.148   7.406  1.00 18.70           O
ATOM   1259  N   ILE    75     -11.886  39.980   5.830  1.00 21.18           N
ATOM   1260  CA  ILE    75     -13.126  39.305   5.348  1.00 20.67           C
ATOM   1262  CB  ILE    75     -12.861  38.455   4.056  1.00 24.95           C
ATOM   1264  CG1 ILE    75     -12.392  39.357   2.884  1.00 19.84           C
ATOM   1267  CD1 ILE    75     -13.271  40.588   2.564  1.00 17.92           C
ATOM   1271  CG2 ILE    75     -14.123  37.542   3.678  1.00 17.77           C
ATOM   1275  C   ILE    75     -13.756  38.436   6.459  1.00 20.07           C
ATOM   1276  O   ILE    75     -14.957  38.520   6.766  1.00 21.18           O
ATOM   1278  N   ASP    76     -12.930  37.612   7.072  1.00 17.12           N
ATOM   1279  CA  ASP    76     -13.336  36.803   8.192  1.00 18.83           C
ATOM   1281  CB  ASP    76     -12.186  35.905   8.657  1.00 22.83           C
ATOM   1284  CG  ASP    76     -12.043  34.652   7.827  1.00 27.23           C
ATOM   1285  OD1 ASP    76     -13.057  34.078   7.372  1.00 31.01           O
ATOM   1286  OD2 ASP    76     -10.909  34.191   7.693  1.00 27.95           O
ATOM   1287  C   ASP    76     -13.899  37.617   9.377  1.00 23.19           C
ATOM   1288  O   ASP    76     -14.831  37.168  10.037  1.00 22.31           O
ATOM   1290  N   LEU    77     -13.351  38.804   9.612  1.00 18.46           N
ATOM   1291  CA  LEU    77     -13.819  39.701  10.637  1.00 21.75           C
ATOM   1293  CB  LEU    77     -12.778  40.796  10.830  1.00 25.24           C
ATOM   1296  CG  LEU    77     -12.948  41.754  12.004  1.00 29.92           C
ATOM   1298  CD1 LEU    77     -13.038  40.979  13.351  1.00 25.12           C
ATOM   1302  CD2 LEU    77     -11.808  42.828  11.972  1.00 29.35           C
ATOM   1306  C   LEU    77     -15.234  40.301  10.317  1.00 28.76           C
ATOM   1307  O   LEU    77     -16.106  40.401  11.187  1.00 24.23           O
ATOM   1309  N   ILE    78     -15.463  40.677   9.065  1.00 25.00           N
ATOM   1310  CA  ILE    78     -16.801  41.067   8.619  1.00 24.14           C
ATOM   1312  CB  ILE    78     -16.846  41.357   7.106  1.00 22.57           C
ATOM   1314  CG1 ILE    78     -15.939  42.551   6.759  1.00 18.05           C
ATOM   1317  CD1 ILE    78     -15.865  42.959   5.251  1.00 17.41           C
ATOM   1321  CG2 ILE    78     -18.325  41.594   6.622  1.00 22.52           C
ATOM   1325  C   ILE    78     -17.788  39.956   8.967  1.00 21.73           C
ATOM   1326  O   ILE    78     -18.855  40.200   9.585  1.00 21.65           O
ATOM   1328  N   CYS    79     -17.439  38.728   8.613  1.00 20.07           N
ATOM   1329  CA  CYS    79     -18.311  37.600   8.882  1.00 23.10           C
ATOM   1331  CB  CYS    79     -17.826  36.354   8.142  1.00 20.26           C
ATOM   1334  SG  CYS    79     -18.872  34.951   8.328  1.00 27.18           S
ATOM   1336  C   CYS    79     -18.495  37.325  10.382  1.00 30.41           C
ATOM   1337  O   CYS    79     -19.635  37.266  10.875  1.00 22.37           O
ATOM   1339  N   SER    80     -17.393  37.181  11.121  1.00 21.91           N
ATOM   1340  CA  SER    80     -17.494  36.878  12.545  1.00 24.30           C
ATOM   1342  CB  SER    80     -16.095  36.547  13.140  1.00 24.35           C
ATOM   1345  OG  SER    80     -15.237  37.672  13.063  1.00 25.08           O
ATOM   1347  C   SER    80     -18.235  37.984  13.349  1.00 18.40           C
ATOM   1348  O   SER    80     -18.966  37.663  14.285  1.00 23.97           O
ATOM   1350  N   ASN    81     -18.040  39.257  13.002  1.00 20.76           N
ATOM   1351  CA  ASN    81     -18.731  40.384  13.628  1.00 23.40           C
ATOM   1353  CB  ASN    81     -18.272  41.726  13.033  1.00 18.65           C
ATOM   1356  CG  ASN    81     -16.891  42.213  13.553  1.00 23.49           C
ATOM   1357  OD1 ASN    81     -16.312  41.626  14.419  1.00 22.48           O
ATOM   1358  ND2 ASN    81     -16.394  43.279  12.976  1.00 20.38           N
ATOM   1361  C   ASN    81     -20.283  40.263  13.424  1.00 31.33           C
ATOM   1362  O   ASN    81     -21.087  40.528  14.334  1.00 26.82           O
ATOM   1364  N   ALA    82     -20.677  39.859  12.217  1.00 25.71           N
ATOM   1365  CA  ALA    82     -22.082  39.664  11.864  1.00 25.53           C
ATOM   1367  CB  ALA    82     -22.259  39.508  10.281  1.00 21.68           C
ATOM   1371  C   ALA    82     -22.675  38.493  12.648  1.00 19.47           C
ATOM   1372  O   ALA    82     -23.782  38.620  13.195  1.00 28.46           O
ATOM   1374  N   LEU    83     -21.945  37.393  12.806  1.00 22.22           N
ATOM   1375  CA  LEU    83     -22.458  36.275  13.567  1.00 23.51           C
ATOM   1377  CB  LEU    83     -21.630  34.996  13.381  1.00 25.32           C
ATOM   1380  CG  LEU    83     -21.284  34.549  11.947  1.00 34.57           C
ATOM   1382  CD1 LEU    83     -20.593  33.216  11.961  1.00 35.58           C
ATOM   1386  CD2 LEU    83     -22.467  34.549  11.013  1.00 26.17           C
ATOM   1390  C   LEU    83     -22.621  36.565  15.064  1.00 29.52           C
ATOM   1391  O   LEU    83     -23.595  36.103  15.672  1.00 26.06           O
ATOM   1393  N   GLU    84     -21.666  37.318  15.619  1.00 32.26           N
ATOM   1394  CA  GLU    84     -21.643  37.710  17.035  1.00 32.94           C
ATOM   1396  CB  GLU    84     -20.292  38.372  17.403  1.00 28.31           C
ATOM   1399  CG  GLU    84     -20.112  38.708  18.919  1.00 46.52           C
ATOM   1402  CD  GLU    84     -19.012  39.774  19.248  1.00 64.97           C
ATOM   1403  OE1 GLU    84     -19.027  40.289  20.394  1.00 62.98           O
ATOM   1404  OE2 GLU    84     -18.146  40.107  18.397  1.00 54.59           O
ATOM   1405  C   GLU    84     -22.775  38.669  17.351  1.00 24.93           C
ATOM   1406  O   GLU    84     -23.505  38.480  18.326  1.00 31.68           O
ATOM   1408  N   TYR    85     -22.917  39.687  16.517  1.00 25.04           N
ATOM   1409  CA  TYR    85     -23.859  40.737  16.750  1.00 31.73           C
ATOM   1411  CB  TYR    85     -23.552  41.964  15.894  1.00 27.37           C
ATOM   1414  CG  TYR    85     -24.285  43.193  16.424  1.00 43.81           C
ATOM   1415  CD1 TYR    85     -23.935  43.754  17.660  1.00 43.60           C
ATOM   1417  CE1 TYR    85     -24.609  44.867  18.169  1.00 51.06           C
ATOM   1419  CZ  TYR    85     -25.656  45.414  17.451  1.00 53.75           C
ATOM   1420  OH  TYR    85     -26.323  46.502  17.953  1.00 59.40           O
ATOM   1422  CE2 TYR    85     -26.032  44.869  16.232  1.00 45.06           C
ATOM   1424  CD2 TYR    85     -25.355  43.757  15.730  1.00 46.35           C
ATOM   1426  C   TYR    85     -25.312  40.326  16.468  1.00 32.29           C
ATOM   1427  O   TYR    85     -26.218  41.016  16.913  1.00 28.58           O
ATOM   1429  N   ASN    86     -25.511  39.244  15.713  1.00 32.89           N
ATOM   1430  CA  ASN    86     -26.859  38.825  15.262  1.00 31.75           C
ATOM   1432  CB  ASN    86     -27.062  39.151  13.773  1.00 32.32           C
ATOM   1435  CG  ASN    86     -26.831  40.612  13.440  1.00 31.15           C
ATOM   1436  OD1 ASN    86     -27.673  41.450  13.688  1.00 30.56           O
ATOM   1437  ND2 ASN    86     -25.687  40.919  12.835  1.00 33.47           N
ATOM   1440  C   ASN    86     -27.014  37.350  15.457  1.00 27.49           C
ATOM   1441  O   ASN    86     -27.161  36.616  14.483  1.00 31.91           O
ATOM   1443  N   PRO    87     -26.979  36.884  16.722  1.00 26.55           N
ATOM   1444  CA  PRO    87     -26.859  35.458  17.020  1.00 26.12           C
ATOM   1446  CB  PRO    87     -26.139  35.465  18.366  1.00 32.64           C
ATOM   1449  CG  PRO    87     -26.617  36.704  19.004  1.00 27.94           C
ATOM   1452  CD  PRO    87     -26.987  37.682  17.965  1.00 31.83           C
ATOM   1455  C   PRO    87     -28.190  34.720  17.191  1.00 23.77           C
ATOM   1456  O   PRO    87     -28.184  33.511  17.376  1.00 31.41           O
ATOM   1457  N   ASP    88     -29.295  35.454  17.077  1.00 29.51           N
ATOM   1458  CA  ASP    88     -30.628  34.995  17.492  1.00 30.57           C
ATOM   1460  CB  ASP    88     -31.499  36.214  17.808  1.00 33.78           C
ATOM   1463  CG  ASP    88     -31.018  36.990  19.037  1.00 44.32           C
ATOM   1464  OD1 ASP    88     -30.049  36.557  19.695  1.00 30.51           O
ATOM   1465  OD2 ASP    88     -31.618  38.042  19.343  1.00 45.37           O
ATOM   1466  C   ASP    88     -31.314  34.154  16.417  1.00 35.10           C
ATOM   1467  O   ASP    88     -30.874  34.159  15.254  1.00 27.40           O
ATOM   1469  N   ARG    89     -32.377  33.435  16.798  1.00 30.45           N
ATOM   1470  CA  ARG    89     -33.120  32.566  15.840  1.00 28.72           C
ATOM   1472  CB  ARG    89     -33.869  31.411  16.551  0.50 33.38           C
ATOM   1478  CG  ARG    89     -35.167  31.777  17.355  0.50 37.37           C
ATOM   1484  CD  ARG    89     -36.517  31.729  16.550  0.50 23.22           C
ATOM   1490  NE  ARG    89     -36.709  30.558  15.702  0.50 14.53           N
ATOM   1494  CZ  ARG    89     -37.431  30.582  14.566  0.50 21.38           C
ATOM   1496  NH1 ARG    89     -37.964  31.725  14.152  0.50 19.03           N
ATOM   1502  NH2 ARG    89     -37.589  29.485  13.816  0.50 13.40           N
ATOM   1508  C   ARG    89     -34.104  33.315  14.959  1.00 26.11           C
ATOM   1509  O   ARG    89     -34.687  32.742  14.036  1.00 29.81           O
ATOM   1511  N   ASP    90     -34.292  34.590  15.208  1.00 23.54           N
ATOM   1512  CA  ASP    90     -35.264  35.315  14.430  1.00 29.60           C
ATOM   1514  CB  ASP    90     -35.570  36.660  15.055  1.00 30.13           C
ATOM   1517  CG  ASP    90     -34.416  37.592  15.029  1.00 38.59           C
ATOM   1518  OD1 ASP    90     -34.440  38.541  14.205  1.00 51.79           O
ATOM   1519  OD2 ASP    90     -33.495  37.374  15.835  1.00 59.04           O
ATOM   1520  C   ASP    90     -34.818  35.489  12.968  1.00 31.35           C
ATOM   1521  O   ASP    90     -33.608  35.485  12.679  1.00 27.12           O
ATOM   1523  N   PRO    91     -35.796  35.658  12.057  1.00 30.02           N
ATOM   1524  CA  PRO    91     -35.509  35.719  10.624  1.00 27.31           C
ATOM   1526  CB  PRO    91     -36.888  35.982   9.996  1.00 31.62           C
ATOM   1529  CG  PRO    91     -37.870  35.529  10.995  1.00 30.59           C
ATOM   1532  CD  PRO    91     -37.249  35.720  12.332  1.00 29.64           C
ATOM   1535  C   PRO    91     -34.517  36.811  10.209  1.00 22.34           C
ATOM   1536  O   PRO    91     -33.705  36.580   9.308  1.00 20.72           O
ATOM   1537  N   GLY    92     -34.594  37.996  10.814  1.00 21.91           N
ATOM   1538  CA  GLY    92     -33.644  39.081  10.479  1.00 27.46           C
ATOM   1541  C   GLY    92     -32.189  38.688  10.774  1.00 28.37           C
ATOM   1542  O   GLY    92     -31.291  38.926   9.959  1.00 26.07           O
ATOM   1544  N   ASP    93     -31.988  38.036  11.921  1.00 29.00           N
ATOM   1545  CA  ASP    93     -30.671  37.565  12.363  1.00 28.59           C
ATOM   1547  CB  ASP    93     -30.706  37.160  13.839  1.00 27.55           C
ATOM   1550  CG  ASP    93     -30.501  38.352  14.797  1.00 29.39           C
ATOM   1551  OD1 ASP    93     -30.830  39.510  14.444  1.00 34.06           O
ATOM   1552  OD2 ASP    93     -29.975  38.111  15.906  1.00 30.80           O
ATOM   1553  C   ASP    93     -30.200  36.391  11.496  1.00 27.19           C
ATOM   1554  O   ASP    93     -29.054  36.350  11.035  1.00 22.18           O
ATOM   1556  N   ARG    94     -31.084  35.433  11.257  1.00 23.21           N
ATOM   1557  CA  ARG    94     -30.707  34.307  10.424  1.00 23.79           C
ATOM   1559  CB  ARG    94     -31.766  33.209  10.471  1.00 25.48           C
ATOM   1562  CG  ARG    94     -31.737  32.427  11.740  1.00 27.61           C
ATOM   1565  CD  ARG    94     -32.760  31.383  11.762  1.00 30.35           C
ATOM   1568  NE  ARG    94     -32.587  30.462  12.881  1.00 29.92           N
ATOM   1570  CZ  ARG    94     -33.515  29.601  13.303  1.00 44.64           C
ATOM   1571  NH1 ARG    94     -34.696  29.524  12.707  1.00 49.89           N
ATOM   1574  NH2 ARG    94     -33.253  28.800  14.329  1.00 50.28           N
ATOM   1577  C   ARG    94     -30.353  34.733   8.984  1.00 20.18           C
ATOM   1578  O   ARG    94     -29.450  34.143   8.402  1.00 24.67           O
ATOM   1580  N   LEU    95     -31.024  35.742   8.429  1.00 22.52           N
ATOM   1581  CA  LEU    95     -30.721  36.233   7.093  1.00 22.83           C
ATOM   1583  CB  LEU    95     -31.778  37.231   6.586  1.00 17.27           C
ATOM   1586  CG  LEU    95     -31.622  37.872   5.193  1.00 13.78           C
ATOM   1588  CD1 LEU    95     -31.591  36.803   4.083  1.00 17.27           C
ATOM   1592  CD2 LEU    95     -32.741  38.938   4.931  1.00 18.04           C
ATOM   1596  C   LEU    95     -29.303  36.857   7.025  1.00 27.03           C
ATOM   1597  O   LEU    95     -28.513  36.509   6.145  1.00 18.85           O
ATOM   1599  N   ILE    96     -29.003  37.775   7.935  1.00 24.56           N
ATOM   1600  CA  ILE    96     -27.664  38.412   7.975  1.00 25.27           C
ATOM   1602  CB  ILE    96     -27.557  39.557   9.048  1.00 24.78           C
ATOM   1604  CG1 ILE    96     -26.213  40.323   8.878  1.00 26.50           C
ATOM   1607  CD1 ILE    96     -26.245  41.771   9.362  1.00 33.12           C
ATOM   1611  CG2 ILE    96     -27.670  38.996  10.451  1.00 39.55           C
ATOM   1615  C   ILE    96     -26.548  37.377   8.152  1.00 19.60           C
ATOM   1616  O   ILE    96     -25.527  37.461   7.468  1.00 21.18           O
ATOM   1618  N   ARG    97     -26.758  36.383   9.014  1.00 22.09           N
ATOM   1619  CA  ARG    97     -25.730  35.337   9.236  1.00 23.22           C
ATOM   1621  CB  ARG    97     -26.055  34.442  10.418  1.00 23.31           C
ATOM   1624  CG  ARG    97     -26.059  35.147  11.791  1.00 18.24           C
ATOM   1627  CD  ARG    97     -25.825  34.149  12.895  1.00 24.44           C
ATOM   1630  NE  ARG    97     -26.714  32.993  12.966  1.00 28.83           N
ATOM   1632  CZ  ARG    97     -27.954  32.988  13.471  1.00 27.43           C
ATOM   1633  NH1 ARG    97     -28.502  34.084  13.952  1.00 30.54           N
ATOM   1636  NH2 ARG    97     -28.636  31.867  13.506  1.00 34.39           N
ATOM   1639  C   ARG    97     -25.531  34.480   8.000  1.00 23.61           C
ATOM   1640  O   ARG    97     -24.405  34.077   7.685  1.00 19.92           O
ATOM   1642  N   HIS    98     -26.632  34.171   7.313  1.00 21.18           N
ATOM   1643  CA  HIS    98     -26.543  33.431   6.046  1.00 22.64           C
ATOM   1645  CB  HIS    98     -27.941  33.050   5.530  1.00 21.77           C
ATOM   1648  CG  HIS    98     -27.908  32.137   4.350  1.00 26.85           C
ATOM   1649  ND1 HIS    98     -27.908  32.597   3.046  1.00 26.01           N
ATOM   1651  CE1 HIS    98     -27.851  31.562   2.226  1.00 24.25           C
ATOM   1653  NE2 HIS    98     -27.801  30.456   2.946  1.00 24.82           N
ATOM   1655  CD2 HIS    98     -27.832  30.790   4.278  1.00 20.83           C
ATOM   1657  C   HIS    98     -25.762  34.212   4.969  1.00 17.30           C
ATOM   1658  O   HIS    98     -24.933  33.631   4.248  1.00 18.06           O
ATOM   1660  N   ARG    99     -26.027  35.506   4.899  1.00 19.10           N
ATOM   1661  CA  ARG    99     -25.316  36.441   4.018  1.00 20.88           C
ATOM   1663  CB  ARG    99     -26.027  37.773   3.997  1.00 20.64           C
ATOM   1666  CG  ARG    99     -27.387  37.732   3.223  1.00 20.88           C
ATOM   1669  CD  ARG    99     -28.174  38.962   3.458  1.00 21.51           C
ATOM   1672  NE  ARG    99     -29.294  39.078   2.521  1.00 23.06           N
ATOM   1674  CZ  ARG    99     -30.191  40.058   2.555  1.00 20.30           C
ATOM   1675  NH1 ARG    99     -30.091  41.023   3.440  1.00 21.05           N
ATOM   1678  NH2 ARG    99     -31.181  40.093   1.678  1.00 21.17           N
ATOM   1681  C   ARG    99     -23.838  36.630   4.382  1.00 20.58           C
ATOM   1682  O   ARG    99     -22.988  36.706   3.488  1.00 17.96           O
ATOM   1684  N   ALA   100     -23.558  36.732   5.683  1.00 19.17           N
ATOM   1685  CA  ALA   100     -22.195  36.813   6.217  1.00 21.85           C
ATOM   1687  CB  ALA   100     -22.225  36.938   7.764  1.00 16.22           C
ATOM   1691  C   ALA   100     -21.351  35.615   5.791  1.00 20.05           C
ATOM   1692  O   ALA   100     -20.221  35.796   5.311  1.00 23.60           O
ATOM   1694  N   CYS   101     -21.907  34.415   5.973  1.00 21.28           N
ATOM   1695  CA  CYS   101     -21.276  33.158   5.610  1.00 21.52           C
ATOM   1697  CB  CYS   101     -22.079  31.960   6.126  1.00 28.07           C
ATOM   1700  SG  CYS   101     -21.972  31.797   7.936  1.00 31.25           S
ATOM   1702  C   CYS   101     -21.051  33.023   4.124  1.00 25.37           C
ATOM   1703  O   CYS   101     -19.999  32.501   3.714  1.00 19.19           O
ATOM   1705  N   ALA   102     -22.016  33.503   3.337  1.00 21.90           N
ATOM   1706  CA  ALA   102     -21.892  33.511   1.882  1.00 22.12           C
ATOM   1708  CB  ALA   102     -23.235  33.849   1.188  1.00 15.78           C
ATOM   1712  C   ALA   102     -20.790  34.486   1.442  1.00 20.27           C
ATOM   1713  O   ALA   102     -20.054  34.187   0.513  1.00 19.10           O
ATOM   1715  N   LEU   103     -20.716  35.655   2.073  1.00 16.83           N
ATOM   1716  CA  LEU   103     -19.665  36.644   1.771  1.00 18.39           C
ATOM   1718  CB  LEU   103     -19.805  37.899   2.654  1.00 23.15           C
ATOM   1721  CG  LEU   103     -18.663  38.922   2.545  1.00 30.05           C
ATOM   1723  CD1 LEU   103     -18.835  39.688   1.281  1.00 28.54           C
ATOM   1727  CD2 LEU   103     -18.626  39.860   3.741  1.00 37.11           C
ATOM   1731  C   LEU   103     -18.284  35.999   1.972  1.00 22.05           C
ATOM   1732  O   LEU   103     -17.399  36.073   1.096  1.00 16.43           O
ATOM   1734  N   ARG   104     -18.145  35.347   3.118  1.00 20.87           N
ATOM   1735  CA  ARG   104     -16.942  34.619   3.490  1.00 19.58           C
ATOM   1737  CB  ARG   104     -17.073  34.081   4.903  1.00 21.66           C
ATOM   1740  CG  ARG   104     -15.809  33.343   5.449  1.00 26.94           C
ATOM   1743  CD  ARG   104     -16.189  32.403   6.579  1.00 37.02           C
ATOM   1746  NE  ARG   104     -17.176  31.418   6.120  1.00 39.15           N
ATOM   1748  CZ  ARG   104     -18.107  30.830   6.873  1.00 47.77           C
ATOM   1749  NH1 ARG   104     -18.226  31.107   8.170  1.00 40.34           N
ATOM   1752  NH2 ARG   104     -18.941  29.960   6.318  1.00 32.08           N
ATOM   1755  C   ARG   104     -16.608  33.498   2.514  1.00 21.51           C
ATOM   1756  O   ARG   104     -15.502  33.451   1.985  1.00 19.81           O
ATOM   1758  N   ASP   105     -17.569  32.614   2.252  1.00 19.85           N
ATOM   1759  CA  ASP   105     -17.371  31.514   1.328  1.00 18.95           C
ATOM   1761  CB  ASP   105     -18.589  30.579   1.310  1.00 19.94           C
ATOM   1764  CG  ASP   105     -18.786  29.817   2.617  1.00 29.87           C
ATOM   1765  OD1 ASP   105     -17.890  29.804   3.497  1.00 25.79           O
ATOM   1766  OD2 ASP   105     -19.875  29.240   2.759  1.00 32.06           O
ATOM   1767  C   ASP   105     -17.071  31.980  -0.091  1.00 18.74           C
ATOM   1768  O   ASP   105     -16.165  31.416  -0.760  1.00 18.41           O
ATOM   1770  N   THR   106     -17.805  32.999  -0.550  1.00 16.32           N
ATOM   1771  CA  THR   106     -17.554  33.568  -1.857  1.00 17.31           C
ATOM   1773  CB  THR   106     -18.592  34.671  -2.215  1.00 19.60           C
ATOM   1775  OG1 THR   106     -19.910  34.091  -2.200  1.00 21.70           O
ATOM   1777  CG2 THR   106     -18.293  35.280  -3.582  1.00 21.15           C
ATOM   1781  C   THR   106     -16.110  34.103  -2.046  1.00 18.99           C
ATOM   1782  O   THR   106     -15.477  33.831  -3.076  1.00 17.74           O
ATOM   1784  N   ALA   107     -15.637  34.895  -1.094  1.00 15.61           N
ATOM   1785  CA  ALA   107     -14.289  35.420  -1.112  1.00 21.64           C
ATOM   1787  CB  ALA   107     -14.046  36.389   0.104  1.00 18.61           C
ATOM   1791  C   ALA   107     -13.247  34.298  -1.143  1.00 18.51           C
ATOM   1792  O   ALA   107     -12.335  34.325  -1.983  1.00 17.14           O
ATOM   1794  N   TYR   108     -13.401  33.301  -0.262  1.00 19.06           N
ATOM   1795  CA  TYR   108     -12.468  32.196  -0.209  1.00 20.55           C
ATOM   1797  CB  TYR   108     -12.759  31.244   0.955  1.00 19.96           C
ATOM   1800  CG  TYR   108     -12.056  31.638   2.231  1.00 25.99           C
ATOM   1801  CD1 TYR   108     -12.606  32.576   3.103  1.00 24.70           C
ATOM   1803  CE1 TYR   108     -11.952  32.927   4.290  1.00 20.39           C
ATOM   1805  CZ  TYR   108     -10.747  32.334   4.587  1.00 20.84           C
ATOM   1806  OH  TYR   108     -10.069  32.659   5.731  1.00 24.88           O
ATOM   1808  CE2 TYR   108     -10.178  31.414   3.723  1.00 24.61           C
ATOM   1810  CD2 TYR   108     -10.817  31.077   2.565  1.00 25.48           C
ATOM   1812  C   TYR   108     -12.408  31.452  -1.529  1.00 20.31           C
ATOM   1813  O   TYR   108     -11.310  31.099  -1.995  1.00 17.23           O
ATOM   1815  N   ALA   109     -13.574  31.289  -2.149  1.00 19.03           N
ATOM   1816  CA  ALA   109     -13.706  30.564  -3.412  1.00 23.11           C
ATOM   1818  CB  ALA   109     -15.176  30.300  -3.685  1.00 18.89           C
ATOM   1822  C   ALA   109     -13.061  31.284  -4.604  1.00 20.50           C
ATOM   1823  O   ALA   109     -12.427  30.638  -5.470  1.00 18.55           O
ATOM   1825  N   ILE   110     -13.267  32.605  -4.688  1.00 19.36           N
ATOM   1826  CA  ILE   110     -12.599  33.421  -5.725  1.00 21.96           C
ATOM   1828  CB  ILE   110     -13.063  34.925  -5.709  1.00 18.58           C
ATOM   1830  CG1 ILE   110     -14.535  35.027  -6.122  1.00 22.18           C
ATOM   1833  CD1 ILE   110     -15.215  36.373  -5.838  1.00 14.78           C
ATOM   1837  CG2 ILE   110     -12.170  35.812  -6.630  1.00 14.29           C
ATOM   1841  C   ILE   110     -11.071  33.311  -5.607  1.00 19.10           C
ATOM   1842  O   ILE   110     -10.372  33.040  -6.591  1.00 17.26           O
ATOM   1844  N   ILE   111     -10.561  33.544  -4.408  1.00 19.19           N
ATOM   1845  CA  ILE   111      -9.131  33.411  -4.116  1.00 25.44           C
ATOM   1847  CB  ILE   111      -8.800  33.800  -2.614  1.00 22.02           C
ATOM   1849  CG1 ILE   111      -8.927  35.319  -2.466  0.50 24.12           C
ATOM   1855  CD1 ILE   111      -8.975  35.821  -1.034  0.50 24.28           C
ATOM   1863  CG2 ILE   111      -7.377  33.351  -2.186  0.50 20.27           C
ATOM   1871  C   ILE   111      -8.594  32.012  -4.480  1.00 23.43           C
ATOM   1872  O   ILE   111      -7.521  31.889  -5.076  1.00 21.51           O
ATOM   1874  N   LYS   112      -9.331  30.970  -4.113  1.00 20.95           N
ATOM   1875  CA  LYS   112      -8.891  29.605  -4.401  1.00 25.13           C
ATOM   1877  CB  LYS   112      -9.815  28.569  -3.758  1.00 24.23           C
ATOM   1880  CG  LYS   112      -9.267  27.139  -3.851  1.00 34.87           C
ATOM   1883  CD  LYS   112     -10.337  26.124  -3.532  1.00 39.00           C
ATOM   1886  CE  LYS   112      -9.719  24.728  -3.388  1.00 41.73           C
ATOM   1889  NZ  LYS   112     -10.780  23.712  -3.284  1.00 50.37           N
ATOM   1893  C   LYS   112      -8.788  29.353  -5.898  1.00 22.73           C
ATOM   1894  O   LYS   112      -7.847  28.719  -6.353  1.00 23.80           O
ATOM   1896  N   GLU   113      -9.746  29.853  -6.661  1.00 20.61           N
ATOM   1897  CA  GLU   113      -9.742  29.692  -8.104  1.00 21.10           C
ATOM   1899  CB  GLU   113     -11.151  29.903  -8.655  1.00 24.85           C
ATOM   1902  CG  GLU   113     -11.376  29.291 -10.028  1.00 42.67           C
ATOM   1905  CD  GLU   113     -12.830  28.871 -10.218  1.00 63.40           C
ATOM   1906  OE1 GLU   113     -13.664  29.740 -10.555  1.00 53.37           O
ATOM   1907  OE2 GLU   113     -13.141  27.678 -10.014  1.00 73.30           O
ATOM   1908  C   GLU   113      -8.761  30.627  -8.834  1.00 22.80           C
ATOM   1909  O   GLU   113      -8.143  30.225  -9.814  1.00 22.99           O
ATOM   1911  N   GLU   114      -8.624  31.869  -8.371  1.00 18.16           N
ATOM   1912  CA  GLU   114      -7.987  32.916  -9.174  1.00 20.66           C
ATOM   1914  CB  GLU   114      -8.942  34.104  -9.351  1.00 17.76           C
ATOM   1917  CG  GLU   114     -10.303  33.700 -10.004  1.00 20.51           C
ATOM   1920  CD  GLU   114     -11.257  34.857 -10.154  1.00 22.62           C
ATOM   1921  OE1 GLU   114     -10.785  36.015 -10.211  1.00 23.24           O
ATOM   1922  OE2 GLU   114     -12.497  34.622 -10.190  1.00 20.23           O
ATOM   1923  C   GLU   114      -6.638  33.436  -8.660  1.00 17.59           C
ATOM   1924  O   GLU   114      -5.978  34.135  -9.388  1.00 22.00           O
ATOM   1926  N   LEU   115      -6.264  33.152  -7.424  1.00 17.35           N
ATOM   1927  CA  LEU   115      -4.969  33.587  -6.918  1.00 22.63           C
ATOM   1929  CB  LEU   115      -5.031  34.089  -5.488  1.00 25.32           C
ATOM   1932  CG  LEU   115      -3.736  34.808  -5.019  1.00 27.81           C
ATOM   1934  CD1 LEU   115      -3.541  36.132  -5.784  1.00 29.99           C
ATOM   1938  CD2 LEU   115      -3.802  35.013  -3.544  1.00 34.72           C
ATOM   1942  C   LEU   115      -3.995  32.413  -7.027  1.00 22.59           C
ATOM   1943  O   LEU   115      -4.200  31.351  -6.437  1.00 25.27           O
ATOM   1945  N   ASP   116      -2.956  32.608  -7.823  1.00 26.87           N
ATOM   1946  CA  ASP   116      -1.931  31.598  -8.001  1.00 21.26           C
ATOM   1948  CB  ASP   116      -0.940  32.039  -9.085  1.00 24.60           C
ATOM   1951  CG  ASP   116      -0.014  30.945  -9.463  1.00 32.72           C
ATOM   1952  OD1 ASP   116       0.802  30.520  -8.621  1.00 35.85           O
ATOM   1953  OD2 ASP   116      -0.116  30.482 -10.603  1.00 30.51           O
ATOM   1954  C   ASP   116      -1.217  31.405  -6.686  1.00 19.88           C
ATOM   1955  O   ASP   116      -0.797  32.367  -6.070  1.00 17.18           O
ATOM   1957  N   GLU   117      -1.072  30.153  -6.273  1.00 19.70           N
ATOM   1958  CA  GLU   117      -0.423  29.793  -5.015  1.00 21.71           C
ATOM   1960  CB  GLU   117      -0.505  28.281  -4.806  1.00 24.97           C
ATOM   1963  CG  GLU   117      -1.873  27.805  -4.351  1.00 47.68           C
ATOM   1966  CD  GLU   117      -1.993  26.281  -4.377  1.00 62.52           C
ATOM   1967  OE1 GLU   117      -1.051  25.592  -3.917  1.00 68.27           O
ATOM   1968  OE2 GLU   117      -3.025  25.781  -4.872  1.00 64.53           O
ATOM   1969  C   GLU   117       1.034  30.252  -4.904  1.00 19.02           C
ATOM   1970  O   GLU   117       1.505  30.575  -3.804  1.00 21.23           O
ATOM   1972  N   ASP   118       1.726  30.300  -6.037  1.00 21.76           N
ATOM   1973  CA  ASP   118       3.114  30.755  -6.084  1.00 23.35           C
ATOM   1975  CB  ASP   118       3.807  30.259  -7.362  1.00 23.22           C
ATOM   1978  CG  ASP   118       4.031  28.759  -7.344  1.00 23.95           C
ATOM   1979  OD1 ASP   118       4.153  28.174  -6.239  1.00 27.42           O
ATOM   1980  OD2 ASP   118       4.053  28.181  -8.419  1.00 34.51           O
ATOM   1981  C   ASP   118       3.216  32.252  -5.989  1.00 19.61           C
ATOM   1982  O   ASP   118       4.183  32.772  -5.444  1.00 21.35           O
ATOM   1984  N   PHE   119       2.205  32.953  -6.489  1.00 20.03           N
ATOM   1985  CA  PHE   119       2.117  34.407  -6.319  1.00 18.31           C
ATOM   1987  CB  PHE   119       0.999  35.022  -7.194  1.00 21.75           C
ATOM   1990  CG  PHE   119       0.877  36.501  -7.019  1.00 18.23           C
ATOM   1991  CD1 PHE   119       1.697  37.368  -7.744  1.00 20.63           C
ATOM   1993  CE1 PHE   119       1.645  38.724  -7.536  1.00 20.18           C
ATOM   1995  CZ  PHE   119       0.778  39.242  -6.595  1.00 20.66           C
ATOM   1997  CE2 PHE   119      -0.028  38.399  -5.840  1.00 21.25           C
ATOM   1999  CD2 PHE   119       0.034  37.039  -6.034  1.00 23.39           C
ATOM   2001  C   PHE   119       1.943  34.760  -4.820  1.00 20.04           C
ATOM   2002  O   PHE   119       2.636  35.652  -4.300  1.00 19.24           O
ATOM   2004  N   GLU   120       1.019  34.061  -4.149  1.00 19.65           N
ATOM   2005  CA  GLU   120       0.771  34.243  -2.721  1.00 20.07           C
ATOM   2007  CB  GLU   120      -0.452  33.418  -2.270  1.00 19.67           C
ATOM   2010  CG  GLU   120      -0.776  33.431  -0.751  1.00 18.22           C
ATOM   2013  CD  GLU   120      -0.842  34.838  -0.076  1.00 24.26           C
ATOM   2014  OE1 GLU   120      -0.993  35.867  -0.749  1.00 22.01           O
ATOM   2015  OE2 GLU   120      -0.748  34.920   1.166  1.00 31.38           O
ATOM   2016  C   GLU   120       2.011  33.896  -1.906  1.00 20.48           C
ATOM   2017  O   GLU   120       2.382  34.653  -1.004  1.00 18.84           O
ATOM   2019  N   GLN   121       2.694  32.812  -2.281  1.00 23.00           N
ATOM   2020  CA  GLN   121       3.915  32.389  -1.584  1.00 25.45           C
ATOM   2022  CB  GLN   121       4.429  31.033  -2.118  1.00 27.28           C
ATOM   2025  CG  GLN   121       5.608  30.447  -1.317  1.00 21.66           C
ATOM   2028  CD  GLN   121       5.278  30.213   0.151  1.00 33.37           C
ATOM   2029  OE1 GLN   121       4.152  29.870   0.483  1.00 32.16           O
ATOM   2030  NE2 GLN   121       6.259  30.418   1.037  1.00 26.32           N
ATOM   2033  C   GLN   121       5.004  33.462  -1.667  1.00 23.94           C
ATOM   2034  O   GLN   121       5.652  33.769  -0.654  1.00 23.54           O
ATOM   2036  N   LEU   122       5.194  34.028  -2.859  1.00 20.47           N
ATOM   2037  CA  LEU   122       6.070  35.185  -3.031  1.00 18.08           C
ATOM   2039  CB  LEU   122       6.086  35.684  -4.483  1.00 19.06           C
ATOM   2042  CG  LEU   122       7.034  36.853  -4.806  1.00 21.41           C
ATOM   2044  CD1 LEU   122       8.500  36.550  -4.318  1.00 21.01           C
ATOM   2048  CD2 LEU   122       6.981  37.263  -6.284  1.00 19.35           C
ATOM   2052  C   LEU   122       5.717  36.346  -2.102  1.00 25.99           C
ATOM   2053  O   LEU   122       6.595  36.878  -1.426  1.00 22.53           O
ATOM   2055  N   CYS   123       4.442  36.746  -2.073  1.00 24.30           N
ATOM   2056  CA  CYS   123       3.986  37.824  -1.193  1.00 22.03           C
ATOM   2058  CB  CYS   123       2.462  38.013  -1.273  1.00 19.81           C
ATOM   2061  SG  CYS   123       1.949  38.719  -2.788  1.00 20.51           S
ATOM   2063  C   CYS   123       4.406  37.543   0.250  1.00 19.76           C
ATOM   2064  O   CYS   123       4.923  38.429   0.925  1.00 23.30           O
ATOM   2066  N   GLU   124       4.219  36.302   0.677  1.00 21.51           N
ATOM   2067  CA  GLU   124       4.498  35.894   2.033  1.00 23.50           C
ATOM   2069  CB  GLU   124       3.904  34.522   2.316  1.00 25.91           C
ATOM   2072  CG  GLU   124       2.354  34.523   2.426  1.00 34.93           C
ATOM   2075  CD  GLU   124       1.753  33.122   2.570  1.00 39.26           C
ATOM   2076  OE1 GLU   124       2.507  32.196   2.922  1.00 44.00           O
ATOM   2077  OE2 GLU   124       0.531  32.934   2.324  1.00 32.86           O
ATOM   2078  C   GLU   124       6.000  35.937   2.305  1.00 27.58           C
ATOM   2079  O   GLU   124       6.425  36.363   3.373  1.00 23.27           O
ATOM   2081  N   GLU   125       6.808  35.559   1.319  1.00 28.86           N
ATOM   2082  CA  GLU   125       8.266  35.568   1.498  1.00 28.47           C
ATOM   2084  CB  GLU   125       8.964  34.623   0.483  1.00 24.02           C
ATOM   2087  CG  GLU   125       8.640  33.169   0.845  1.00 24.03           C
ATOM   2090  CD  GLU   125       9.254  32.079  -0.028  1.00 24.11           C
ATOM   2091  OE1 GLU   125      10.097  32.389  -0.885  1.00 26.14           O
ATOM   2092  OE2 GLU   125       8.870  30.893   0.175  1.00 25.13           O
ATOM   2093  C   GLU   125       8.844  36.986   1.557  1.00 25.14           C
ATOM   2094  O   GLU   125       9.702  37.240   2.379  1.00 32.10           O
ATOM   2096  N   ILE   126       8.343  37.910   0.744  1.00 18.67           N
ATOM   2097  CA  ILE   126       8.744  39.303   0.794  1.00 28.52           C
ATOM   2099  CB  ILE   126       8.101  40.129  -0.336  1.00 27.83           C
ATOM   2101  CG1 ILE   126       8.493  39.568  -1.715  1.00 26.91           C
ATOM   2104  CD1 ILE   126       7.773  40.251  -2.894  1.00 26.67           C
ATOM   2108  CG2 ILE   126       8.485  41.616  -0.217  1.00 22.12           C
ATOM   2112  C   ILE   126       8.337  39.875   2.154  1.00 36.40           C
ATOM   2113  O   ILE   126       9.156  40.463   2.873  1.00 35.06           O
ATOM   2115  N   GLN   127       7.079  39.649   2.529  1.00 35.08           N
ATOM   2116  CA  GLN   127       6.566  40.142   3.807  1.00 38.66           C
ATOM   2118  CB  GLN   127       5.108  39.735   3.995  1.00 38.13           C
ATOM   2121  CG  GLN   127       4.372  40.616   4.976  1.00 46.73           C
ATOM   2124  CD  GLN   127       3.704  39.812   6.038  1.00 64.51           C
ATOM   2125  OE1 GLN   127       4.390  39.181   6.848  1.00 56.16           O
ATOM   2126  NE2 GLN   127       2.356  39.812   6.052  1.00 51.91           N
ATOM   2129  C   GLN   127       7.425  39.636   4.995  1.00 34.69           C
ATOM   2130  O   GLN   127       7.851  40.424   5.838  1.00 33.60           O
ATOM   2132  N   GLU   128       7.683  38.335   5.043  1.00 35.26           N
ATOM   2133  CA  GLU   128       8.563  37.745   6.067  1.00 40.39           C
ATOM   2135  CB  GLU   128       8.623  36.223   5.892  1.00 41.49           C
ATOM   2138  CG  GLU   128       7.485  35.491   6.573  1.00 47.02           C
ATOM   2141  CD  GLU   128       6.930  34.334   5.760  1.00 63.09           C
ATOM   2142  OE1 GLU   128       7.704  33.634   5.067  1.00 51.55           O
ATOM   2143  OE2 GLU   128       5.699  34.126   5.826  1.00 65.34           O
ATOM   2144  C   GLU   128      10.001  38.324   6.084  1.00 45.71           C
ATOM   2145  O   GLU   128      10.679  38.302   7.119  1.00 48.40           O
ATOM   2147  N   SER   129      10.462  38.833   4.946  1.00 43.84           N
ATOM   2148  CA  SER   129      11.809  39.391   4.843  1.00 48.65           C
ATOM   2150  CB  SER   129      12.296  39.375   3.386  1.00 43.37           C
ATOM   2153  OG  SER   129      11.800  40.487   2.656  1.00 42.87           O
ATOM   2155  C   SER   129      11.874  40.812   5.408  1.00 52.03           C
ATOM   2156  O   SER   129      12.965  41.358   5.592  1.00 53.77           O
ATOM   2158  N   ARG   130      10.711  41.410   5.661  1.00 53.93           N
ATOM   2159  CA  ARG   130      10.633  42.740   6.267  1.00 59.45           C
ATOM   2161  CB  ARG   130       9.391  43.497   5.759  1.00 54.21           C
ATOM   2164  CG  ARG   130       9.681  44.307   4.492  1.00 68.78           C
ATOM   2167  CD  ARG   130       8.593  44.234   3.428  1.00 58.27           C
ATOM   2170  NE  ARG   130       9.175  44.426   2.091  1.00 71.54           N
ATOM   2172  CZ  ARG   130       8.794  45.337   1.189  1.00 79.48           C
ATOM   2173  NH1 ARG   130       9.414  45.386   0.007  1.00 73.01           N
ATOM   2176  NH2 ARG   130       7.790  46.185   1.432  1.00 82.81           N
ATOM   2179  C   ARG   130      10.653  42.648   7.793  1.00 61.53           C
ATOM   2180  O   ARG   130       9.981  41.818   8.419  1.00 64.77           O
ATOM   2182  OXT ARG   130      11.374  43.409   8.435  1.00 67.56           O
END
