
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  112 ( 1772),  selected  112 , name 2e7o_A
# Molecule2: number of CA atoms  130 ( 1064),  selected  130 , name T0432.pdb
# PARAMETERS: 2e7o_A.T0432.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      S       1           -
LGA    S     2_A      M       2           -
LGA    S     3_A      Q       3           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      E       4          4.997
LGA    -       -      E       5           -
LGA    -       -      D       6           -
LGA    -       -      T       7           -
LGA    D     8_A      F       8          2.308
LGA    S     9_A      R       9          1.966
LGA    K    10_A      E      10          1.644
LGA    D    11_A      L      11          2.073
LGA    L    12_A      R      12          2.388
LGA    A    13_A      I      13          1.787
LGA    L    14_A      F      14          0.871
LGA    C    15_A      L      15          1.023
LGA    S    16_A      R      16          1.089
LGA    M    17_A      N      17          1.231
LGA    I    18_A      V      18          0.913
LGA    L    19_A      T      19          0.575
LGA    T    20_A      H      20          0.837
LGA    E    21_A      R      21          0.405
LGA    M    22_A      L      22          0.614
LGA    E    23_A      A      23          0.693
LGA    T    24_A      I      24          1.010
LGA    H    25_A      D      25          1.052
LGA    E    26_A      K      26          1.829
LGA    D    27_A      R      27          1.306
LGA    A    28_A      F      28          1.054
LGA    W    29_A      R      29          0.921
LGA    P    30_A      V      30          1.194
LGA    F    31_A      F      31          0.969
LGA    L    32_A      T      32          0.435
LGA    L    33_A      K      33          1.320
LGA    P    34_A      P      34          0.833
LGA    V    35_A      V      35          0.276
LGA    N    36_A      D      36          1.294
LGA    L    37_A      P      37          2.297
LGA    K    38_A      D      38          3.236
LGA    L    39_A      E      39          2.398
LGA    V    40_A      V      40          0.519
LGA    P    41_A      P      41          3.827
LGA    G    42_A      D      42          0.604
LGA    Y    43_A      Y      43          0.657
LGA    K    44_A      V      44          1.794
LGA    K    45_A      T      45          2.012
LGA    V    46_A      V      46          1.779
LGA    I    47_A      I      47          1.050
LGA    K    48_A      K      48          1.375
LGA    K    49_A      Q      49          0.349
LGA    P    50_A      P      50          0.407
LGA    M    51_A      M      51          0.758
LGA    D    52_A      D      52          1.012
LGA    F    53_A      L      53          0.885
LGA    S    54_A      S      54          1.211
LGA    T    55_A      S      55          1.421
LGA    I    56_A      V      56          1.304
LGA    R    57_A      I      57          0.779
LGA    E    58_A      S      58          1.647
LGA    K    59_A      K      59          1.866
LGA    L    60_A      I      60          0.965
LGA    S    61_A      D      61          1.796
LGA    S    62_A      L      62          2.909
LGA    G    63_A      H      63          2.195
LGA    Q    64_A      K      64          2.710
LGA    Y    65_A      Y      65          2.279
LGA    P    66_A      L      66          3.043
LGA    N    67_A      T      67          3.023
LGA    L    68_A      V      68          2.573
LGA    E    69_A      K      69          2.528
LGA    T    70_A      D      70          1.948
LGA    F    71_A      Y      71          1.967
LGA    A    72_A      L      72          1.997
LGA    L    73_A      R      73          1.415
LGA    D    74_A      D      74          1.241
LGA    V    75_A      I      75          1.631
LGA    R    76_A      D      76          1.586
LGA    L    77_A      L      77          0.918
LGA    V    78_A      I      78          1.112
LGA    F    79_A      C      79          1.490
LGA    D    80_A      S      80          1.521
LGA    N    81_A      N      81          0.627
LGA    C    82_A      A      82          0.764
LGA    E    83_A      L      83          1.393
LGA    T    84_A      E      84          1.308
LGA    F    85_A      Y      85          0.890
LGA    N    86_A      N      86          2.098
LGA    -       -      P      87           -
LGA    -       -      D      88           -
LGA    -       -      R      89           -
LGA    -       -      D      90           -
LGA    -       -      P      91           -
LGA    E    87_A      G      92           #
LGA    D    88_A      D      93          4.853
LGA    D    89_A      R      94          1.737
LGA    S    90_A      -       -           -
LGA    D    91_A      L      95          3.108
LGA    I    92_A      I      96          2.085
LGA    G    93_A      R      97          2.237
LGA    R    94_A      H      98          2.035
LGA    A    95_A      R      99          1.110
LGA    G    96_A      A     100          0.826
LGA    H    97_A      C     101          2.046
LGA    N    98_A      A     102          1.825
LGA    M    99_A      L     103          1.456
LGA    R   100_A      R     104          1.584
LGA    K   101_A      D     105          1.648
LGA    Y   102_A      T     106          0.759
LGA    F   103_A      A     107          1.132
LGA    E   104_A      Y     108          1.372
LGA    K   105_A      A     109          1.245
LGA    K   106_A      I     110          1.155
LGA    W   107_A      I     111          1.482
LGA    T   108_A      K     112          1.099
LGA    D   109_A      E     113          1.120
LGA    T   110_A      E     114          1.941
LGA    F   111_A      L     115          1.931
LGA    -       -      D     116           -
LGA    K   112_A      E     117          4.681
LGA    -       -      D     118           -
LGA    -       -      F     119           -
LGA    -       -      E     120           -
LGA    -       -      Q     121           -
LGA    -       -      L     122           -
LGA    -       -      C     123           -
LGA    -       -      E     124           -
LGA    -       -      E     125           -
LGA    -       -      I     126           -
LGA    -       -      Q     127           -
LGA    -       -      E     128           -
LGA    -       -      S     129           -
LGA    -       -      R     130           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  112  130    5.0    104    1.82    21.15     72.203     5.420

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.287042 * X  +   0.949523 * Y  +   0.126544 * Z  + -16.654196
  Y_new =   0.618485 * X  +  -0.284584 * Y  +   0.732453 * Z  +  42.995285
  Z_new =   0.731494 * X  +  -0.131979 * Y  +  -0.668953 * Z  +   3.873234 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.946803    0.194790  [ DEG:  -168.8394     11.1606 ]
  Theta =  -0.820510   -2.321083  [ DEG:   -47.0118   -132.9882 ]
  Phi   =   1.136275   -2.005317  [ DEG:    65.1038   -114.8962 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2e7o_A                                        
REMARK     2: T0432.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2e7o_A.T0432.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  112  130   5.0  104   1.82   21.15  72.203
REMARK  ---------------------------------------------------------- 
MOLECULE 2e7o_A
HEADER    DNA BINDING PROTEIN                     11-JAN-07   2E7O              
TITLE     SOLUTION STRUCTURE OF THE BROMODOMAIN FROM HUMAN                      
TITLE    2 BROMODOMAIN ADJACENT TO ZINC FINGER DOMAIN 2B                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BROMODOMAIN ADJACENT TO ZINC FINGER DOMAIN 2B;             
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: BROMODOMAIN;                                               
COMPND   5 SYNONYM: HWALP4;                                                     
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: BAZ2B, KIAA1476;                                               
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P060731-12;                               
SOURCE   7 OTHER_DETAILS: CELL FREE PROTEIN SYNTHESIS                           
KEYWDS    BROMODOMAIN, BROMODOMAIN ADJACENT TO ZINC FINGER DOMAIN 2B,           
KEYWDS   2 STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT ON PROTEIN             
KEYWDS   3 STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                 
KEYWDS   4 GENOMICS/PROTEOMICS INITIATIVE, RSGI                                 
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    X.R.QIN,C.KUROSAKI,F.HAYASHI,S.YOKOYAMA,RIKEN STRUCTURAL              
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   17-JUL-07 2E7O    0                                                
JRNL        AUTH   X.R.QIN,C.KUROSAKI,F.HAYASHI,S.YOKOYAMA                      
JRNL        TITL   SOLUTION STRUCTURE OF THE BROMODOMAIN FROM HUMAN             
JRNL        TITL 2 BROMODOMAIN ADJACENT TO ZINC FINGER DOMAIN 2B                
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2E7O A    8   112  UNP    Q9UIF8   BAZ2B_HUMAN   1866   1970             
SEQRES   1 A  112  GLY SER SER GLY SER SER GLY ASP SER LYS ASP LEU ALA          
SEQRES   2 A  112  LEU CYS SER MET ILE LEU THR GLU MET GLU THR HIS GLU          
SEQRES   3 A  112  ASP ALA TRP PRO PHE LEU LEU PRO VAL ASN LEU LYS LEU          
SEQRES   4 A  112  VAL PRO GLY TYR LYS LYS VAL ILE LYS LYS PRO MET ASP          
SEQRES   5 A  112  PHE SER THR ILE ARG GLU LYS LEU SER SER GLY GLN TYR          
SEQRES   6 A  112  PRO ASN LEU GLU THR PHE ALA LEU ASP VAL ARG LEU VAL          
SEQRES   7 A  112  PHE ASP ASN CYS GLU THR PHE ASN GLU ASP ASP SER ASP          
SEQRES   8 A  112  ILE GLY ARG ALA GLY HIS ASN MET ARG LYS TYR PHE GLU          
SEQRES   9 A  112  LYS LYS TRP THR ASP THR PHE LYS                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1       9.320  24.387   1.047  1.00  0.00           N  
ATOM      2  CA  GLY A   1       8.448  25.528   0.837  1.00  0.00           C  
ATOM      3  C   GLY A   1       8.550  26.083  -0.570  1.00  0.00           C  
ATOM      4  O   GLY A   1       8.400  25.348  -1.546  1.00  0.00           O  
ATOM      5  HA2 GLY A   1       7.428  25.226   1.022  1.00  0.00           H  
ATOM      6  HA3 GLY A   1       8.716  26.305   1.537  1.00  0.00           H  
ATOM      7  H1  GLY A   1      10.132  24.487   1.588  1.00  0.00           H  
ATOM      8  N   SER A   2       8.802  27.383  -0.675  1.00  0.00           N  
ATOM      9  CA  SER A   2       8.917  28.037  -1.973  1.00  0.00           C  
ATOM     10  C   SER A   2       7.546  28.199  -2.624  1.00  0.00           C  
ATOM     11  O   SER A   2       7.433  28.276  -3.847  1.00  0.00           O  
ATOM     12  CB  SER A   2       9.839  27.234  -2.893  1.00  0.00           C  
ATOM     13  OG  SER A   2      10.409  28.062  -3.892  1.00  0.00           O  
ATOM     14  H   SER A   2       8.912  27.917   0.140  1.00  0.00           H  
ATOM     15  HA  SER A   2       9.344  29.016  -1.815  1.00  0.00           H  
ATOM     16  HB2 SER A   2      10.633  26.797  -2.309  1.00  0.00           H  
ATOM     17  HB3 SER A   2       9.271  26.450  -3.372  1.00  0.00           H  
ATOM     18  HG  SER A   2      10.873  27.517  -4.532  1.00  0.00           H  
ATOM     19  N   SER A   3       6.508  28.250  -1.796  1.00  0.00           N  
ATOM     20  CA  SER A   3       5.144  28.398  -2.289  1.00  0.00           C  
ATOM     21  C   SER A   3       4.659  29.836  -2.124  1.00  0.00           C  
ATOM     22  O   SER A   3       4.111  30.203  -1.086  1.00  0.00           O  
ATOM     23  CB  SER A   3       4.204  27.444  -1.549  1.00  0.00           C  
ATOM     24  OG  SER A   3       4.176  27.731  -0.161  1.00  0.00           O  
ATOM     25  H   SER A   3       6.663  28.184  -0.830  1.00  0.00           H  
ATOM     26  HA  SER A   3       5.142  28.148  -3.339  1.00  0.00           H  
ATOM     27  HB2 SER A   3       3.206  27.545  -1.945  1.00  0.00           H  
ATOM     28  HB3 SER A   3       4.545  26.428  -1.688  1.00  0.00           H  
ATOM     29  HG  SER A   3       3.296  27.560   0.184  1.00  0.00           H  
ATOM     30  N   GLY A   4       4.867  30.645  -3.158  1.00  0.00           N  
ATOM     31  CA  GLY A   4       4.447  32.034  -3.109  1.00  0.00           C  
ATOM     32  C   GLY A   4       4.148  32.598  -4.483  1.00  0.00           C  
ATOM     33  O   GLY A   4       3.024  33.018  -4.759  1.00  0.00           O  
ATOM     34  H   GLY A   4       5.309  30.298  -3.960  1.00  0.00           H  
ATOM     35  HA2 GLY A   4       3.558  32.108  -2.500  1.00  0.00           H  
ATOM     36  HA3 GLY A   4       5.232  32.620  -2.655  1.00  0.00           H  
ATOM     37  N   SER A   5       5.158  32.611  -5.348  1.00  0.00           N  
ATOM     38  CA  SER A   5       5.000  33.134  -6.700  1.00  0.00           C  
ATOM     39  C   SER A   5       4.228  34.450  -6.687  1.00  0.00           C  
ATOM     40  O   SER A   5       3.344  34.672  -7.513  1.00  0.00           O  
ATOM     41  CB  SER A   5       4.277  32.114  -7.583  1.00  0.00           C  
ATOM     42  OG  SER A   5       4.911  30.848  -7.524  1.00  0.00           O  
ATOM     43  H   SER A   5       6.030  32.262  -5.069  1.00  0.00           H  
ATOM     44  HA  SER A   5       5.985  33.311  -7.104  1.00  0.00           H  
ATOM     45  HB2 SER A   5       3.257  32.008  -7.244  1.00  0.00           H  
ATOM     46  HB3 SER A   5       4.282  32.460  -8.606  1.00  0.00           H  
ATOM     47  HG  SER A   5       4.642  30.391  -6.724  1.00  0.00           H  
ATOM     48  N   SER A   6       4.571  35.320  -5.742  1.00  0.00           N  
ATOM     49  CA  SER A   6       3.909  36.613  -5.617  1.00  0.00           C  
ATOM     50  C   SER A   6       4.932  37.742  -5.540  1.00  0.00           C  
ATOM     51  O   SER A   6       6.134  37.500  -5.433  1.00  0.00           O  
ATOM     52  CB  SER A   6       3.015  36.634  -4.376  1.00  0.00           C  
ATOM     53  OG  SER A   6       3.739  36.255  -3.219  1.00  0.00           O  
ATOM     54  H   SER A   6       5.284  35.085  -5.112  1.00  0.00           H  
ATOM     55  HA  SER A   6       3.296  36.757  -6.495  1.00  0.00           H  
ATOM     56  HB2 SER A   6       2.627  37.631  -4.233  1.00  0.00           H  
ATOM     57  HB3 SER A   6       2.193  35.944  -4.515  1.00  0.00           H  
ATOM     58  HG  SER A   6       3.750  35.298  -3.147  1.00  0.00           H  
ATOM     59  N   GLY A   7       4.446  38.978  -5.596  1.00  0.00           N  
ATOM     60  CA  GLY A   7       5.330  40.127  -5.531  1.00  0.00           C  
ATOM     61  C   GLY A   7       4.961  41.080  -4.412  1.00  0.00           C  
ATOM     62  O   GLY A   7       4.610  40.652  -3.313  1.00  0.00           O  
ATOM     63  H   GLY A   7       3.478  39.111  -5.682  1.00  0.00           H  
ATOM     64  HA2 GLY A   7       6.341  39.781  -5.377  1.00  0.00           H  
ATOM     65  HA3 GLY A   7       5.282  40.657  -6.471  1.00  0.00           H  
ATOM     66  N   ASP A   8       5.042  42.377  -4.692  1.00  0.00           N  
ATOM     67  CA  ASP A   8       4.714  43.394  -3.699  1.00  0.00           C  
ATOM     68  C   ASP A   8       3.305  43.937  -3.922  1.00  0.00           C  
ATOM     69  O   ASP A   8       2.453  43.860  -3.037  1.00  0.00           O  
ATOM     70  CB  ASP A   8       5.729  44.537  -3.756  1.00  0.00           C  
ATOM     71  CG  ASP A   8       7.161  44.040  -3.746  1.00  0.00           C  
ATOM     72  OD1 ASP A   8       7.438  43.043  -3.049  1.00  0.00           O  
ATOM     73  OD2 ASP A   8       8.005  44.651  -4.435  1.00  0.00           O  
ATOM     74  H   ASP A   8       5.327  42.656  -5.586  1.00  0.00           H  
ATOM     75  HA  ASP A   8       4.758  42.934  -2.724  1.00  0.00           H  
ATOM     76  HB2 ASP A   8       5.570  45.106  -4.660  1.00  0.00           H  
ATOM     77  HB3 ASP A   8       5.583  45.181  -2.900  1.00  0.00           H  
ATOM     78  N   SER A   9       3.068  44.484  -5.109  1.00  0.00           N  
ATOM     79  CA  SER A   9       1.764  45.044  -5.447  1.00  0.00           C  
ATOM     80  C   SER A   9       0.883  43.997  -6.123  1.00  0.00           C  
ATOM     81  O   SER A   9      -0.289  43.840  -5.780  1.00  0.00           O  
ATOM     82  CB  SER A   9       1.929  46.257  -6.364  1.00  0.00           C  
ATOM     83  OG  SER A   9       2.807  47.211  -5.793  1.00  0.00           O  
ATOM     84  H   SER A   9       3.789  44.514  -5.774  1.00  0.00           H  
ATOM     85  HA  SER A   9       1.291  45.358  -4.529  1.00  0.00           H  
ATOM     86  HB2 SER A   9       2.332  45.937  -7.312  1.00  0.00           H  
ATOM     87  HB3 SER A   9       0.965  46.720  -6.519  1.00  0.00           H  
ATOM     88  HG  SER A   9       3.714  46.908  -5.884  1.00  0.00           H  
ATOM     89  N   LYS A  10       1.455  43.283  -7.087  1.00  0.00           N  
ATOM     90  CA  LYS A  10       0.724  42.251  -7.811  1.00  0.00           C  
ATOM     91  C   LYS A  10      -0.279  41.552  -6.899  1.00  0.00           C  
ATOM     92  O   LYS A  10      -1.477  41.528  -7.182  1.00  0.00           O  
ATOM     93  CB  LYS A  10       1.697  41.225  -8.397  1.00  0.00           C  
ATOM     94  CG  LYS A  10       1.010  40.080  -9.123  1.00  0.00           C  
ATOM     95  CD  LYS A  10       1.824  38.801  -9.042  1.00  0.00           C  
ATOM     96  CE  LYS A  10       1.362  37.780 -10.071  1.00  0.00           C  
ATOM     97  NZ  LYS A  10       2.128  36.506  -9.972  1.00  0.00           N  
ATOM     98  H   LYS A  10       2.394  43.455  -7.314  1.00  0.00           H  
ATOM     99  HA  LYS A  10       0.188  42.728  -8.618  1.00  0.00           H  
ATOM    100  HB2 LYS A  10       2.351  41.725  -9.096  1.00  0.00           H  
ATOM    101  HB3 LYS A  10       2.291  40.810  -7.596  1.00  0.00           H  
ATOM    102  HG2 LYS A  10       0.044  39.909  -8.673  1.00  0.00           H  
ATOM    103  HG3 LYS A  10       0.882  40.351 -10.162  1.00  0.00           H  
ATOM    104  HD2 LYS A  10       2.863  39.032  -9.223  1.00  0.00           H  
ATOM    105  HD3 LYS A  10       1.716  38.377  -8.053  1.00  0.00           H  
ATOM    106  HE2 LYS A  10       0.316  37.574  -9.910  1.00  0.00           H  
ATOM    107  HE3 LYS A  10       1.499  38.197 -11.058  1.00  0.00           H  
ATOM    108  HZ1 LYS A  10       1.502  35.699 -10.166  1.00  0.00           H  
ATOM    109  HZ2 LYS A  10       2.524  36.402  -9.017  1.00  0.00           H  
ATOM    110  HZ3 LYS A  10       2.906  36.502 -10.662  1.00  0.00           H  
ATOM    111  N   ASP A  11       0.218  40.987  -5.804  1.00  0.00           N  
ATOM    112  CA  ASP A  11      -0.637  40.290  -4.848  1.00  0.00           C  
ATOM    113  C   ASP A  11      -1.797  41.177  -4.409  1.00  0.00           C  
ATOM    114  O   ASP A  11      -2.944  40.733  -4.349  1.00  0.00           O  
ATOM    115  CB  ASP A  11       0.178  39.852  -3.630  1.00  0.00           C  
ATOM    116  CG  ASP A  11       0.986  40.989  -3.035  1.00  0.00           C  
ATOM    117  OD1 ASP A  11       0.424  41.762  -2.232  1.00  0.00           O  
ATOM    118  OD2 ASP A  11       2.183  41.104  -3.372  1.00  0.00           O  
ATOM    119  H   ASP A  11       1.182  41.040  -5.634  1.00  0.00           H  
ATOM    120  HA  ASP A  11      -1.035  39.414  -5.337  1.00  0.00           H  
ATOM    121  HB2 ASP A  11      -0.495  39.479  -2.871  1.00  0.00           H  
ATOM    122  HB3 ASP A  11       0.856  39.065  -3.922  1.00  0.00           H  
ATOM    123  N   LEU A  12      -1.491  42.434  -4.103  1.00  0.00           N  
ATOM    124  CA  LEU A  12      -2.509  43.384  -3.667  1.00  0.00           C  
ATOM    125  C   LEU A  12      -3.523  43.642  -4.776  1.00  0.00           C  
ATOM    126  O   LEU A  12      -4.731  43.534  -4.564  1.00  0.00           O  
ATOM    127  CB  LEU A  12      -1.856  44.700  -3.241  1.00  0.00           C  
ATOM    128  CG  LEU A  12      -1.337  44.758  -1.805  1.00  0.00           C  
ATOM    129  CD1 LEU A  12      -0.717  46.117  -1.515  1.00  0.00           C  
ATOM    130  CD2 LEU A  12      -2.459  44.462  -0.820  1.00  0.00           C  
ATOM    131  H   LEU A  12      -0.560  42.730  -4.170  1.00  0.00           H  
ATOM    132  HA  LEU A  12      -3.021  42.955  -2.819  1.00  0.00           H  
ATOM    133  HB2 LEU A  12      -1.022  44.884  -3.902  1.00  0.00           H  
ATOM    134  HB3 LEU A  12      -2.588  45.486  -3.363  1.00  0.00           H  
ATOM    135  HG  LEU A  12      -0.569  44.008  -1.674  1.00  0.00           H  
ATOM    136 HD11 LEU A  12       0.047  46.011  -0.759  1.00  0.00           H  
ATOM    137 HD12 LEU A  12      -1.481  46.793  -1.162  1.00  0.00           H  
ATOM    138 HD13 LEU A  12      -0.277  46.512  -2.420  1.00  0.00           H  
ATOM    139 HD21 LEU A  12      -2.707  43.412  -0.864  1.00  0.00           H  
ATOM    140 HD22 LEU A  12      -3.329  45.049  -1.079  1.00  0.00           H  
ATOM    141 HD23 LEU A  12      -2.138  44.715   0.179  1.00  0.00           H  
ATOM    142  N   ALA A  13      -3.025  43.981  -5.961  1.00  0.00           N  
ATOM    143  CA  ALA A  13      -3.888  44.249  -7.104  1.00  0.00           C  
ATOM    144  C   ALA A  13      -5.070  43.287  -7.137  1.00  0.00           C  
ATOM    145  O   ALA A  13      -6.222  43.708  -7.265  1.00  0.00           O  
ATOM    146  CB  ALA A  13      -3.093  44.156  -8.398  1.00  0.00           C  
ATOM    147  H   ALA A  13      -2.053  44.051  -6.068  1.00  0.00           H  
ATOM    148  HA  ALA A  13      -4.260  45.259  -7.011  1.00  0.00           H  
ATOM    149  HB1 ALA A  13      -2.179  43.607  -8.220  1.00  0.00           H  
ATOM    150  HB2 ALA A  13      -3.681  43.644  -9.146  1.00  0.00           H  
ATOM    151  HB3 ALA A  13      -2.854  45.150  -8.746  1.00  0.00           H  
ATOM    152  N   LEU A  14      -4.781  41.997  -7.021  1.00  0.00           N  
ATOM    153  CA  LEU A  14      -5.822  40.974  -7.039  1.00  0.00           C  
ATOM    154  C   LEU A  14      -6.872  41.250  -5.969  1.00  0.00           C  
ATOM    155  O   LEU A  14      -8.068  41.306  -6.258  1.00  0.00           O  
ATOM    156  CB  LEU A  14      -5.207  39.590  -6.824  1.00  0.00           C  
ATOM    157  CG  LEU A  14      -4.524  38.962  -8.038  1.00  0.00           C  
ATOM    158  CD1 LEU A  14      -3.467  37.961  -7.598  1.00  0.00           C  
ATOM    159  CD2 LEU A  14      -5.550  38.295  -8.943  1.00  0.00           C  
ATOM    160  H   LEU A  14      -3.845  41.723  -6.922  1.00  0.00           H  
ATOM    161  HA  LEU A  14      -6.296  41.002  -8.008  1.00  0.00           H  
ATOM    162  HB2 LEU A  14      -4.473  39.673  -6.036  1.00  0.00           H  
ATOM    163  HB3 LEU A  14      -5.998  38.924  -6.507  1.00  0.00           H  
ATOM    164  HG  LEU A  14      -4.030  39.739  -8.607  1.00  0.00           H  
ATOM    165 HD11 LEU A  14      -3.359  37.196  -8.352  1.00  0.00           H  
ATOM    166 HD12 LEU A  14      -3.769  37.506  -6.665  1.00  0.00           H  
ATOM    167 HD13 LEU A  14      -2.524  38.469  -7.462  1.00  0.00           H  
ATOM    168 HD21 LEU A  14      -5.426  38.656  -9.953  1.00  0.00           H  
ATOM    169 HD22 LEU A  14      -6.544  38.533  -8.595  1.00  0.00           H  
ATOM    170 HD23 LEU A  14      -5.406  37.226  -8.922  1.00  0.00           H  
ATOM    171  N   CYS A  15      -6.419  41.422  -4.732  1.00  0.00           N  
ATOM    172  CA  CYS A  15      -7.320  41.693  -3.618  1.00  0.00           C  
ATOM    173  C   CYS A  15      -8.402  42.689  -4.023  1.00  0.00           C  
ATOM    174  O   CYS A  15      -9.565  42.544  -3.648  1.00  0.00           O  
ATOM    175  CB  CYS A  15      -6.537  42.231  -2.420  1.00  0.00           C  
ATOM    176  SG  CYS A  15      -5.409  41.030  -1.675  1.00  0.00           S  
ATOM    177  H   CYS A  15      -5.455  41.365  -4.563  1.00  0.00           H  
ATOM    178  HA  CYS A  15      -7.791  40.762  -3.340  1.00  0.00           H  
ATOM    179  HB2 CYS A  15      -5.948  43.079  -2.737  1.00  0.00           H  
ATOM    180  HB3 CYS A  15      -7.232  42.547  -1.657  1.00  0.00           H  
ATOM    181  HG  CYS A  15      -4.521  40.679  -2.592  1.00  0.00           H  
ATOM    182  N   SER A  16      -8.009  43.701  -4.790  1.00  0.00           N  
ATOM    183  CA  SER A  16      -8.944  44.725  -5.241  1.00  0.00           C  
ATOM    184  C   SER A  16     -10.067  44.108  -6.070  1.00  0.00           C  
ATOM    185  O   SER A  16     -11.225  44.512  -5.964  1.00  0.00           O  
ATOM    186  CB  SER A  16      -8.211  45.786  -6.065  1.00  0.00           C  
ATOM    187  OG  SER A  16      -9.080  46.849  -6.415  1.00  0.00           O  
ATOM    188  H   SER A  16      -7.068  43.761  -5.056  1.00  0.00           H  
ATOM    189  HA  SER A  16      -9.371  45.192  -4.367  1.00  0.00           H  
ATOM    190  HB2 SER A  16      -7.391  46.184  -5.487  1.00  0.00           H  
ATOM    191  HB3 SER A  16      -7.830  45.335  -6.969  1.00  0.00           H  
ATOM    192  HG  SER A  16      -8.755  47.668  -6.033  1.00  0.00           H  
ATOM    193  N   MET A  17      -9.716  43.127  -6.894  1.00  0.00           N  
ATOM    194  CA  MET A  17     -10.693  42.453  -7.739  1.00  0.00           C  
ATOM    195  C   MET A  17     -11.736  41.727  -6.893  1.00  0.00           C  
ATOM    196  O   MET A  17     -12.912  42.090  -6.897  1.00  0.00           O  
ATOM    197  CB  MET A  17      -9.996  41.459  -8.671  1.00  0.00           C  
ATOM    198  CG  MET A  17      -8.802  42.051  -9.405  1.00  0.00           C  
ATOM    199  SD  MET A  17      -8.487  41.240 -10.983  1.00  0.00           S  
ATOM    200  CE  MET A  17      -8.330  39.533 -10.463  1.00  0.00           C  
ATOM    201  H   MET A  17      -8.777  42.848  -6.933  1.00  0.00           H  
ATOM    202  HA  MET A  17     -11.189  43.204  -8.335  1.00  0.00           H  
ATOM    203  HB2 MET A  17      -9.652  40.618  -8.089  1.00  0.00           H  
ATOM    204  HB3 MET A  17     -10.706  41.113  -9.406  1.00  0.00           H  
ATOM    205  HG2 MET A  17      -8.991  43.098  -9.586  1.00  0.00           H  
ATOM    206  HG3 MET A  17      -7.927  41.946  -8.781  1.00  0.00           H  
ATOM    207  HE1 MET A  17      -8.894  39.380  -9.555  1.00  0.00           H  
ATOM    208  HE2 MET A  17      -8.712  38.884 -11.237  1.00  0.00           H  
ATOM    209  HE3 MET A  17      -7.288  39.307 -10.283  1.00  0.00           H  
ATOM    210  N   ILE A  18     -11.296  40.703  -6.171  1.00  0.00           N  
ATOM    211  CA  ILE A  18     -12.191  39.929  -5.321  1.00  0.00           C  
ATOM    212  C   ILE A  18     -13.124  40.840  -4.531  1.00  0.00           C  
ATOM    213  O   ILE A  18     -14.334  40.614  -4.478  1.00  0.00           O  
ATOM    214  CB  ILE A  18     -11.406  39.040  -4.338  1.00  0.00           C  
ATOM    215  CG1 ILE A  18     -10.493  38.079  -5.102  1.00  0.00           C  
ATOM    216  CG2 ILE A  18     -12.362  38.269  -3.441  1.00  0.00           C  
ATOM    217  CD1 ILE A  18      -9.237  37.707  -4.344  1.00  0.00           C  
ATOM    218  H   ILE A  18     -10.347  40.462  -6.210  1.00  0.00           H  
ATOM    219  HA  ILE A  18     -12.785  39.289  -5.957  1.00  0.00           H  
ATOM    220  HB  ILE A  18     -10.802  39.680  -3.713  1.00  0.00           H  
ATOM    221 HG12 ILE A  18     -11.033  37.171  -5.314  1.00  0.00           H  
ATOM    222 HG13 ILE A  18     -10.195  38.542  -6.032  1.00  0.00           H  
ATOM    223 HG21 ILE A  18     -13.264  38.845  -3.297  1.00  0.00           H  
ATOM    224 HG22 ILE A  18     -12.608  37.325  -3.903  1.00  0.00           H  
ATOM    225 HG23 ILE A  18     -11.894  38.090  -2.484  1.00  0.00           H  
ATOM    226 HD11 ILE A  18      -8.371  37.945  -4.943  1.00  0.00           H  
ATOM    227 HD12 ILE A  18      -9.199  38.260  -3.417  1.00  0.00           H  
ATOM    228 HD13 ILE A  18      -9.247  36.648  -4.132  1.00  0.00           H  
ATOM    229  N   LEU A  19     -12.554  41.872  -3.918  1.00  0.00           N  
ATOM    230  CA  LEU A  19     -13.335  42.821  -3.131  1.00  0.00           C  
ATOM    231  C   LEU A  19     -14.470  43.412  -3.961  1.00  0.00           C  
ATOM    232  O   LEU A  19     -15.621  43.446  -3.523  1.00  0.00           O  
ATOM    233  CB  LEU A  19     -12.435  43.941  -2.606  1.00  0.00           C  
ATOM    234  CG  LEU A  19     -13.107  44.973  -1.701  1.00  0.00           C  
ATOM    235  CD1 LEU A  19     -13.634  44.312  -0.436  1.00  0.00           C  
ATOM    236  CD2 LEU A  19     -12.135  46.092  -1.355  1.00  0.00           C  
ATOM    237  H   LEU A  19     -11.586  42.000  -3.996  1.00  0.00           H  
ATOM    238  HA  LEU A  19     -13.758  42.288  -2.293  1.00  0.00           H  
ATOM    239  HB2 LEU A  19     -11.632  43.485  -2.049  1.00  0.00           H  
ATOM    240  HB3 LEU A  19     -12.028  44.463  -3.460  1.00  0.00           H  
ATOM    241  HG  LEU A  19     -13.947  45.409  -2.224  1.00  0.00           H  
ATOM    242 HD11 LEU A  19     -13.492  44.976   0.403  1.00  0.00           H  
ATOM    243 HD12 LEU A  19     -13.097  43.391  -0.262  1.00  0.00           H  
ATOM    244 HD13 LEU A  19     -14.686  44.097  -0.554  1.00  0.00           H  
ATOM    245 HD21 LEU A  19     -12.311  46.935  -2.006  1.00  0.00           H  
ATOM    246 HD22 LEU A  19     -11.122  45.741  -1.484  1.00  0.00           H  
ATOM    247 HD23 LEU A  19     -12.283  46.393  -0.328  1.00  0.00           H  
ATOM    248  N   THR A  20     -14.140  43.875  -5.163  1.00  0.00           N  
ATOM    249  CA  THR A  20     -15.131  44.463  -6.054  1.00  0.00           C  
ATOM    250  C   THR A  20     -16.334  43.542  -6.223  1.00  0.00           C  
ATOM    251  O   THR A  20     -17.440  43.865  -5.790  1.00  0.00           O  
ATOM    252  CB  THR A  20     -14.531  44.765  -7.440  1.00  0.00           C  
ATOM    253  OG1 THR A  20     -13.443  45.687  -7.313  1.00  0.00           O  
ATOM    254  CG2 THR A  20     -15.586  45.342  -8.373  1.00  0.00           C  
ATOM    255  H   THR A  20     -13.206  43.819  -5.454  1.00  0.00           H  
ATOM    256  HA  THR A  20     -15.461  45.394  -5.617  1.00  0.00           H  
ATOM    257  HB  THR A  20     -14.163  43.841  -7.865  1.00  0.00           H  
ATOM    258  HG1 THR A  20     -13.782  46.548  -7.055  1.00  0.00           H  
ATOM    259 HG21 THR A  20     -16.521  44.823  -8.222  1.00  0.00           H  
ATOM    260 HG22 THR A  20     -15.266  45.218  -9.397  1.00  0.00           H  
ATOM    261 HG23 THR A  20     -15.718  46.392  -8.160  1.00  0.00           H  
ATOM    262  N   GLU A  21     -16.111  42.394  -6.856  1.00  0.00           N  
ATOM    263  CA  GLU A  21     -17.179  41.427  -7.081  1.00  0.00           C  
ATOM    264  C   GLU A  21     -18.034  41.259  -5.829  1.00  0.00           C  
ATOM    265  O   GLU A  21     -19.249  41.451  -5.865  1.00  0.00           O  
ATOM    266  CB  GLU A  21     -16.593  40.077  -7.497  1.00  0.00           C  
ATOM    267  CG  GLU A  21     -15.972  40.083  -8.884  1.00  0.00           C  
ATOM    268  CD  GLU A  21     -17.012  40.099  -9.988  1.00  0.00           C  
ATOM    269  OE1 GLU A  21     -17.655  41.151 -10.182  1.00  0.00           O  
ATOM    270  OE2 GLU A  21     -17.180  39.059 -10.659  1.00  0.00           O  
ATOM    271  H   GLU A  21     -15.208  42.194  -7.178  1.00  0.00           H  
ATOM    272  HA  GLU A  21     -17.801  41.800  -7.880  1.00  0.00           H  
ATOM    273  HB2 GLU A  21     -15.832  39.792  -6.786  1.00  0.00           H  
ATOM    274  HB3 GLU A  21     -17.381  39.337  -7.481  1.00  0.00           H  
ATOM    275  HG2 GLU A  21     -15.351  40.960  -8.982  1.00  0.00           H  
ATOM    276  HG3 GLU A  21     -15.363  39.197  -8.996  1.00  0.00           H  
ATOM    277  N   MET A  22     -17.390  40.899  -4.723  1.00  0.00           N  
ATOM    278  CA  MET A  22     -18.092  40.706  -3.459  1.00  0.00           C  
ATOM    279  C   MET A  22     -18.899  41.946  -3.090  1.00  0.00           C  
ATOM    280  O   MET A  22     -20.033  41.843  -2.624  1.00  0.00           O  
ATOM    281  CB  MET A  22     -17.097  40.381  -2.344  1.00  0.00           C  
ATOM    282  CG  MET A  22     -16.361  39.066  -2.550  1.00  0.00           C  
ATOM    283  SD  MET A  22     -15.693  38.396  -1.016  1.00  0.00           S  
ATOM    284  CE  MET A  22     -14.648  39.749  -0.481  1.00  0.00           C  
ATOM    285  H   MET A  22     -16.420  40.761  -4.757  1.00  0.00           H  
ATOM    286  HA  MET A  22     -18.768  39.873  -3.580  1.00  0.00           H  
ATOM    287  HB2 MET A  22     -16.365  41.173  -2.288  1.00  0.00           H  
ATOM    288  HB3 MET A  22     -17.630  40.326  -1.406  1.00  0.00           H  
ATOM    289  HG2 MET A  22     -17.047  38.346  -2.972  1.00  0.00           H  
ATOM    290  HG3 MET A  22     -15.546  39.231  -3.241  1.00  0.00           H  
ATOM    291  HE1 MET A  22     -13.704  39.359  -0.133  1.00  0.00           H  
ATOM    292  HE2 MET A  22     -14.478  40.421  -1.310  1.00  0.00           H  
ATOM    293  HE3 MET A  22     -15.135  40.284   0.322  1.00  0.00           H  
ATOM    294  N   GLU A  23     -18.307  43.118  -3.303  1.00  0.00           N  
ATOM    295  CA  GLU A  23     -18.972  44.377  -2.991  1.00  0.00           C  
ATOM    296  C   GLU A  23     -20.254  44.531  -3.804  1.00  0.00           C  
ATOM    297  O   GLU A  23     -21.150  45.292  -3.436  1.00  0.00           O  
ATOM    298  CB  GLU A  23     -18.035  45.556  -3.266  1.00  0.00           C  
ATOM    299  CG  GLU A  23     -17.035  45.810  -2.152  1.00  0.00           C  
ATOM    300  CD  GLU A  23     -16.644  47.271  -2.040  1.00  0.00           C  
ATOM    301  OE1 GLU A  23     -17.546  48.132  -2.119  1.00  0.00           O  
ATOM    302  OE2 GLU A  23     -15.439  47.554  -1.875  1.00  0.00           O  
ATOM    303  H   GLU A  23     -17.402  43.135  -3.678  1.00  0.00           H  
ATOM    304  HA  GLU A  23     -19.225  44.368  -1.942  1.00  0.00           H  
ATOM    305  HB2 GLU A  23     -17.489  45.361  -4.177  1.00  0.00           H  
ATOM    306  HB3 GLU A  23     -18.630  46.448  -3.398  1.00  0.00           H  
ATOM    307  HG2 GLU A  23     -17.470  45.497  -1.215  1.00  0.00           H  
ATOM    308  HG3 GLU A  23     -16.144  45.229  -2.346  1.00  0.00           H  
ATOM    309  N   THR A  24     -20.335  43.804  -4.915  1.00  0.00           N  
ATOM    310  CA  THR A  24     -21.505  43.860  -5.781  1.00  0.00           C  
ATOM    311  C   THR A  24     -22.351  42.599  -5.646  1.00  0.00           C  
ATOM    312  O   THR A  24     -22.955  42.138  -6.615  1.00  0.00           O  
ATOM    313  CB  THR A  24     -21.103  44.039  -7.257  1.00  0.00           C  
ATOM    314  OG1 THR A  24     -20.317  42.923  -7.689  1.00  0.00           O  
ATOM    315  CG2 THR A  24     -20.315  45.326  -7.451  1.00  0.00           C  
ATOM    316  H   THR A  24     -19.589  43.215  -5.154  1.00  0.00           H  
ATOM    317  HA  THR A  24     -22.098  44.713  -5.486  1.00  0.00           H  
ATOM    318  HB  THR A  24     -22.000  44.091  -7.856  1.00  0.00           H  
ATOM    319  HG1 THR A  24     -19.582  42.796  -7.084  1.00  0.00           H  
ATOM    320 HG21 THR A  24     -20.028  45.721  -6.488  1.00  0.00           H  
ATOM    321 HG22 THR A  24     -20.929  46.048  -7.969  1.00  0.00           H  
ATOM    322 HG23 THR A  24     -19.430  45.121  -8.034  1.00  0.00           H  
ATOM    323  N   HIS A  25     -22.389  42.044  -4.439  1.00  0.00           N  
ATOM    324  CA  HIS A  25     -23.163  40.836  -4.177  1.00  0.00           C  
ATOM    325  C   HIS A  25     -24.518  41.179  -3.564  1.00  0.00           C  
ATOM    326  O   HIS A  25     -24.631  42.113  -2.772  1.00  0.00           O  
ATOM    327  CB  HIS A  25     -22.390  39.902  -3.244  1.00  0.00           C  
ATOM    328  CG  HIS A  25     -22.692  38.452  -3.464  1.00  0.00           C  
ATOM    329  ND1 HIS A  25     -23.488  37.712  -2.614  1.00  0.00           N  
ATOM    330  CD2 HIS A  25     -22.302  37.604  -4.445  1.00  0.00           C  
ATOM    331  CE1 HIS A  25     -23.573  36.472  -3.062  1.00  0.00           C  
ATOM    332  NE2 HIS A  25     -22.862  36.380  -4.172  1.00  0.00           N  
ATOM    333  H   HIS A  25     -21.887  42.458  -3.707  1.00  0.00           H  
ATOM    334  HA  HIS A  25     -23.325  40.335  -5.119  1.00  0.00           H  
ATOM    335  HB2 HIS A  25     -21.331  40.046  -3.398  1.00  0.00           H  
ATOM    336  HB3 HIS A  25     -22.637  40.142  -2.220  1.00  0.00           H  
ATOM    337  HD1 HIS A  25     -23.925  38.046  -1.803  1.00  0.00           H  
ATOM    338  HD2 HIS A  25     -21.668  37.845  -5.285  1.00  0.00           H  
ATOM    339  HE1 HIS A  25     -24.129  35.669  -2.601  1.00  0.00           H  
ATOM    340  N   GLU A  26     -25.541  40.418  -3.938  1.00  0.00           N  
ATOM    341  CA  GLU A  26     -26.887  40.644  -3.426  1.00  0.00           C  
ATOM    342  C   GLU A  26     -26.930  40.470  -1.912  1.00  0.00           C  
ATOM    343  O   GLU A  26     -27.914  40.824  -1.262  1.00  0.00           O  
ATOM    344  CB  GLU A  26     -27.877  39.683  -4.089  1.00  0.00           C  
ATOM    345  CG  GLU A  26     -27.607  38.221  -3.777  1.00  0.00           C  
ATOM    346  CD  GLU A  26     -28.396  37.279  -4.668  1.00  0.00           C  
ATOM    347  OE1 GLU A  26     -28.265  37.386  -5.905  1.00  0.00           O  
ATOM    348  OE2 GLU A  26     -29.142  36.437  -4.127  1.00  0.00           O  
ATOM    349  H   GLU A  26     -25.387  39.688  -4.574  1.00  0.00           H  
ATOM    350  HA  GLU A  26     -27.168  41.658  -3.669  1.00  0.00           H  
ATOM    351  HB2 GLU A  26     -28.874  39.924  -3.752  1.00  0.00           H  
ATOM    352  HB3 GLU A  26     -27.827  39.816  -5.160  1.00  0.00           H  
ATOM    353  HG2 GLU A  26     -26.554  38.025  -3.915  1.00  0.00           H  
ATOM    354  HG3 GLU A  26     -27.876  38.030  -2.749  1.00  0.00           H  
ATOM    355  N   ASP A  27     -25.855  39.922  -1.355  1.00  0.00           N  
ATOM    356  CA  ASP A  27     -25.768  39.701   0.084  1.00  0.00           C  
ATOM    357  C   ASP A  27     -24.437  40.206   0.632  1.00  0.00           C  
ATOM    358  O   ASP A  27     -23.855  39.601   1.532  1.00  0.00           O  
ATOM    359  CB  ASP A  27     -25.934  38.215   0.404  1.00  0.00           C  
ATOM    360  CG  ASP A  27     -27.390  37.797   0.475  1.00  0.00           C  
ATOM    361  OD1 ASP A  27     -27.948  37.415  -0.573  1.00  0.00           O  
ATOM    362  OD2 ASP A  27     -27.970  37.853   1.580  1.00  0.00           O  
ATOM    363  H   ASP A  27     -25.102  39.662  -1.925  1.00  0.00           H  
ATOM    364  HA  ASP A  27     -26.568  40.253   0.554  1.00  0.00           H  
ATOM    365  HB2 ASP A  27     -25.449  37.631  -0.365  1.00  0.00           H  
ATOM    366  HB3 ASP A  27     -25.471  38.004   1.357  1.00  0.00           H  
ATOM    367  N   ALA A  28     -23.960  41.319   0.082  1.00  0.00           N  
ATOM    368  CA  ALA A  28     -22.699  41.906   0.517  1.00  0.00           C  
ATOM    369  C   ALA A  28     -22.896  43.342   0.990  1.00  0.00           C  
ATOM    370  O   ALA A  28     -21.942  44.010   1.389  1.00  0.00           O  
ATOM    371  CB  ALA A  28     -21.678  41.855  -0.611  1.00  0.00           C  
ATOM    372  H   ALA A  28     -24.471  41.756  -0.631  1.00  0.00           H  
ATOM    373  HA  ALA A  28     -22.321  41.315   1.338  1.00  0.00           H  
ATOM    374  HB1 ALA A  28     -21.166  40.904  -0.589  1.00  0.00           H  
ATOM    375  HB2 ALA A  28     -22.182  41.972  -1.557  1.00  0.00           H  
ATOM    376  HB3 ALA A  28     -20.961  42.652  -0.482  1.00  0.00           H  
ATOM    377  N   TRP A  29     -24.138  43.811   0.942  1.00  0.00           N  
ATOM    378  CA  TRP A  29     -24.459  45.168   1.366  1.00  0.00           C  
ATOM    379  C   TRP A  29     -24.448  45.281   2.887  1.00  0.00           C  
ATOM    380  O   TRP A  29     -24.148  46.330   3.457  1.00  0.00           O  
ATOM    381  CB  TRP A  29     -25.826  45.585   0.821  1.00  0.00           C  
ATOM    382  CG  TRP A  29     -26.965  44.822   1.427  1.00  0.00           C  
ATOM    383  CD1 TRP A  29     -27.707  43.845   0.828  1.00  0.00           C  
ATOM    384  CD2 TRP A  29     -27.491  44.975   2.750  1.00  0.00           C  
ATOM    385  NE1 TRP A  29     -28.663  43.382   1.699  1.00  0.00           N  
ATOM    386  CE2 TRP A  29     -28.551  44.058   2.885  1.00  0.00           C  
ATOM    387  CE3 TRP A  29     -27.168  45.796   3.834  1.00  0.00           C  
ATOM    388  CZ2 TRP A  29     -29.289  43.941   4.059  1.00  0.00           C  
ATOM    389  CZ3 TRP A  29     -27.902  45.679   4.999  1.00  0.00           C  
ATOM    390  CH2 TRP A  29     -28.952  44.757   5.105  1.00  0.00           C  
ATOM    391  H   TRP A  29     -24.856  43.230   0.614  1.00  0.00           H  
ATOM    392  HA  TRP A  29     -23.704  45.828   0.962  1.00  0.00           H  
ATOM    393  HB2 TRP A  29     -25.983  46.635   1.023  1.00  0.00           H  
ATOM    394  HB3 TRP A  29     -25.844  45.421  -0.247  1.00  0.00           H  
ATOM    395  HD1 TRP A  29     -27.555  43.500  -0.183  1.00  0.00           H  
ATOM    396  HE1 TRP A  29     -29.319  42.679   1.502  1.00  0.00           H  
ATOM    397  HE3 TRP A  29     -26.362  46.512   3.772  1.00  0.00           H  
ATOM    398  HZ2 TRP A  29     -30.101  43.235   4.157  1.00  0.00           H  
ATOM    399  HZ3 TRP A  29     -27.668  46.305   5.847  1.00  0.00           H  
ATOM    400  HH2 TRP A  29     -29.498  44.701   6.033  1.00  0.00           H  
ATOM    401  N   PRO A  30     -24.783  44.174   3.565  1.00  0.00           N  
ATOM    402  CA  PRO A  30     -24.784  44.244   5.030  1.00  0.00           C  
ATOM    403  C   PRO A  30     -23.513  44.880   5.580  1.00  0.00           C  
ATOM    404  O   PRO A  30     -23.482  45.344   6.721  1.00  0.00           O  
ATOM    405  CB  PRO A  30     -24.873  42.776   5.454  1.00  0.00           C  
ATOM    406  CG  PRO A  30     -25.542  42.091   4.313  1.00  0.00           C  
ATOM    407  CD  PRO A  30     -25.167  42.841   3.072  1.00  0.00           C  
ATOM    408  HA  PRO A  30     -25.644  44.780   5.401  1.00  0.00           H  
ATOM    409  HB2 PRO A  30     -23.879  42.386   5.623  1.00  0.00           H  
ATOM    410  HB3 PRO A  30     -25.456  42.695   6.359  1.00  0.00           H  
ATOM    411  HG2 PRO A  30     -25.196  41.071   4.243  1.00  0.00           H  
ATOM    412  HG3 PRO A  30     -26.613  42.117   4.445  1.00  0.00           H  
ATOM    413  HD3 PRO A  30     -24.335  42.357   2.581  1.00  0.00           H  
ATOM    414  HD2 PRO A  30     -26.014  42.906   2.404  1.00  0.00           H  
ATOM    415  N   PHE A  31     -22.464  44.902   4.762  1.00  0.00           N  
ATOM    416  CA  PHE A  31     -21.190  45.483   5.168  1.00  0.00           C  
ATOM    417  C   PHE A  31     -20.870  46.725   4.341  1.00  0.00           C  
ATOM    418  O   PHE A  31     -20.265  47.677   4.837  1.00  0.00           O  
ATOM    419  CB  PHE A  31     -20.067  44.455   5.021  1.00  0.00           C  
ATOM    420  CG  PHE A  31     -20.516  43.040   5.251  1.00  0.00           C  
ATOM    421  CD1 PHE A  31     -21.116  42.315   4.235  1.00  0.00           C  
ATOM    422  CD2 PHE A  31     -20.337  42.435   6.485  1.00  0.00           C  
ATOM    423  CE1 PHE A  31     -21.531  41.013   4.444  1.00  0.00           C  
ATOM    424  CE2 PHE A  31     -20.749  41.133   6.701  1.00  0.00           C  
ATOM    425  CZ  PHE A  31     -21.346  40.421   5.679  1.00  0.00           C  
ATOM    426  H   PHE A  31     -22.551  44.518   3.865  1.00  0.00           H  
ATOM    427  HA  PHE A  31     -21.271  45.768   6.206  1.00  0.00           H  
ATOM    428  HB2 PHE A  31     -19.662  44.514   4.022  1.00  0.00           H  
ATOM    429  HB3 PHE A  31     -19.289  44.677   5.735  1.00  0.00           H  
ATOM    430  HD1 PHE A  31     -21.261  42.776   3.269  1.00  0.00           H  
ATOM    431  HD2 PHE A  31     -19.870  42.990   7.285  1.00  0.00           H  
ATOM    432  HE1 PHE A  31     -21.998  40.460   3.644  1.00  0.00           H  
ATOM    433  HE2 PHE A  31     -20.603  40.672   7.667  1.00  0.00           H  
ATOM    434  HZ  PHE A  31     -21.670  39.405   5.845  1.00  0.00           H  
ATOM    435  N   LEU A  32     -21.278  46.707   3.077  1.00  0.00           N  
ATOM    436  CA  LEU A  32     -21.036  47.831   2.179  1.00  0.00           C  
ATOM    437  C   LEU A  32     -21.035  49.150   2.945  1.00  0.00           C  
ATOM    438  O   LEU A  32     -20.179  50.008   2.726  1.00  0.00           O  
ATOM    439  CB  LEU A  32     -22.096  47.867   1.077  1.00  0.00           C  
ATOM    440  CG  LEU A  32     -21.865  46.929  -0.108  1.00  0.00           C  
ATOM    441  CD1 LEU A  32     -22.995  47.058  -1.118  1.00  0.00           C  
ATOM    442  CD2 LEU A  32     -20.525  47.220  -0.765  1.00  0.00           C  
ATOM    443  H   LEU A  32     -21.756  45.921   2.739  1.00  0.00           H  
ATOM    444  HA  LEU A  32     -20.064  47.690   1.728  1.00  0.00           H  
ATOM    445  HB2 LEU A  32     -23.045  47.610   1.524  1.00  0.00           H  
ATOM    446  HB3 LEU A  32     -22.141  48.878   0.697  1.00  0.00           H  
ATOM    447  HG  LEU A  32     -21.851  45.908   0.248  1.00  0.00           H  
ATOM    448 HD11 LEU A  32     -23.572  46.146  -1.130  1.00  0.00           H  
ATOM    449 HD12 LEU A  32     -22.582  47.236  -2.099  1.00  0.00           H  
ATOM    450 HD13 LEU A  32     -23.633  47.884  -0.841  1.00  0.00           H  
ATOM    451 HD21 LEU A  32     -20.233  48.237  -0.552  1.00  0.00           H  
ATOM    452 HD22 LEU A  32     -20.610  47.086  -1.833  1.00  0.00           H  
ATOM    453 HD23 LEU A  32     -19.778  46.542  -0.376  1.00  0.00           H  
ATOM    454  N   LEU A  33     -22.000  49.305   3.845  1.00  0.00           N  
ATOM    455  CA  LEU A  33     -22.110  50.520   4.646  1.00  0.00           C  
ATOM    456  C   LEU A  33     -21.735  50.249   6.101  1.00  0.00           C  
ATOM    457  O   LEU A  33     -21.993  49.175   6.644  1.00  0.00           O  
ATOM    458  CB  LEU A  33     -23.533  51.077   4.569  1.00  0.00           C  
ATOM    459  CG  LEU A  33     -23.887  51.838   3.292  1.00  0.00           C  
ATOM    460  CD1 LEU A  33     -25.377  52.141   3.248  1.00  0.00           C  
ATOM    461  CD2 LEU A  33     -23.077  53.122   3.194  1.00  0.00           C  
ATOM    462  H   LEU A  33     -22.653  48.587   3.975  1.00  0.00           H  
ATOM    463  HA  LEU A  33     -21.425  51.248   4.240  1.00  0.00           H  
ATOM    464  HB2 LEU A  33     -24.218  50.248   4.661  1.00  0.00           H  
ATOM    465  HB3 LEU A  33     -23.669  51.749   5.405  1.00  0.00           H  
ATOM    466  HG  LEU A  33     -23.647  51.223   2.436  1.00  0.00           H  
ATOM    467 HD11 LEU A  33     -25.554  52.986   2.601  1.00  0.00           H  
ATOM    468 HD12 LEU A  33     -25.729  52.370   4.243  1.00  0.00           H  
ATOM    469 HD13 LEU A  33     -25.908  51.280   2.869  1.00  0.00           H  
ATOM    470 HD21 LEU A  33     -22.031  52.879   3.086  1.00  0.00           H  
ATOM    471 HD22 LEU A  33     -23.219  53.707   4.091  1.00  0.00           H  
ATOM    472 HD23 LEU A  33     -23.406  53.690   2.337  1.00  0.00           H  
ATOM    473  N   PRO A  34     -21.114  51.246   6.747  1.00  0.00           N  
ATOM    474  CA  PRO A  34     -20.693  51.142   8.147  1.00  0.00           C  
ATOM    475  C   PRO A  34     -21.876  51.124   9.108  1.00  0.00           C  
ATOM    476  O   PRO A  34     -22.891  51.779   8.872  1.00  0.00           O  
ATOM    477  CB  PRO A  34     -19.849  52.400   8.359  1.00  0.00           C  
ATOM    478  CG  PRO A  34     -20.358  53.372   7.351  1.00  0.00           C  
ATOM    479  CD  PRO A  34     -20.774  52.554   6.160  1.00  0.00           C  
ATOM    480  HA  PRO A  34     -20.083  50.265   8.312  1.00  0.00           H  
ATOM    481  HB2 PRO A  34     -19.989  52.765   9.368  1.00  0.00           H  
ATOM    482  HB3 PRO A  34     -18.806  52.172   8.195  1.00  0.00           H  
ATOM    483  HG2 PRO A  34     -21.205  53.907   7.753  1.00  0.00           H  
ATOM    484  HG3 PRO A  34     -19.574  54.061   7.076  1.00  0.00           H  
ATOM    485  HD3 PRO A  34     -21.635  52.996   5.681  1.00  0.00           H  
ATOM    486  HD2 PRO A  34     -19.956  52.462   5.462  1.00  0.00           H  
ATOM    487  N   VAL A  35     -21.739  50.371  10.194  1.00  0.00           N  
ATOM    488  CA  VAL A  35     -22.796  50.270  11.194  1.00  0.00           C  
ATOM    489  C   VAL A  35     -22.814  51.495  12.101  1.00  0.00           C  
ATOM    490  O   VAL A  35     -21.889  51.715  12.882  1.00  0.00           O  
ATOM    491  CB  VAL A  35     -22.632  49.006  12.059  1.00  0.00           C  
ATOM    492  CG1 VAL A  35     -23.734  48.929  13.106  1.00  0.00           C  
ATOM    493  CG2 VAL A  35     -22.628  47.760  11.186  1.00  0.00           C  
ATOM    494  H   VAL A  35     -20.906  49.871  10.328  1.00  0.00           H  
ATOM    495  HA  VAL A  35     -23.742  50.204  10.674  1.00  0.00           H  
ATOM    496  HB  VAL A  35     -21.683  49.065  12.570  1.00  0.00           H  
ATOM    497 HG11 VAL A  35     -23.299  49.014  14.091  1.00  0.00           H  
ATOM    498 HG12 VAL A  35     -24.436  49.735  12.950  1.00  0.00           H  
ATOM    499 HG13 VAL A  35     -24.246  47.982  13.019  1.00  0.00           H  
ATOM    500 HG21 VAL A  35     -21.616  47.539  10.881  1.00  0.00           H  
ATOM    501 HG22 VAL A  35     -23.025  46.926  11.746  1.00  0.00           H  
ATOM    502 HG23 VAL A  35     -23.238  47.930  10.312  1.00  0.00           H  
ATOM    503  N   ASN A  36     -23.874  52.290  11.992  1.00  0.00           N  
ATOM    504  CA  ASN A  36     -24.012  53.494  12.803  1.00  0.00           C  
ATOM    505  C   ASN A  36     -24.058  53.147  14.288  1.00  0.00           C  
ATOM    506  O   ASN A  36     -25.061  52.636  14.787  1.00  0.00           O  
ATOM    507  CB  ASN A  36     -25.277  54.258  12.407  1.00  0.00           C  
ATOM    508  CG  ASN A  36     -25.041  55.204  11.245  1.00  0.00           C  
ATOM    509  OD1 ASN A  36     -25.316  54.870  10.092  1.00  0.00           O  
ATOM    510  ND2 ASN A  36     -24.529  56.392  11.545  1.00  0.00           N  
ATOM    511  H   ASN A  36     -24.579  52.062  11.350  1.00  0.00           H  
ATOM    512  HA  ASN A  36     -23.152  54.119  12.617  1.00  0.00           H  
ATOM    513  HB2 ASN A  36     -26.043  53.551  12.120  1.00  0.00           H  
ATOM    514  HB3 ASN A  36     -25.623  54.834  13.252  1.00  0.00           H  
ATOM    515 HD21 ASN A  36     -24.335  56.589  12.485  1.00  0.00           H  
ATOM    516 HD22 ASN A  36     -24.367  57.023  10.814  1.00  0.00           H  
ATOM    517  N   LEU A  37     -22.966  53.428  14.989  1.00  0.00           N  
ATOM    518  CA  LEU A  37     -22.881  53.147  16.418  1.00  0.00           C  
ATOM    519  C   LEU A  37     -23.929  53.940  17.192  1.00  0.00           C  
ATOM    520  O   LEU A  37     -24.495  53.452  18.171  1.00  0.00           O  
ATOM    521  CB  LEU A  37     -21.482  53.482  16.941  1.00  0.00           C  
ATOM    522  CG  LEU A  37     -20.311  52.957  16.109  1.00  0.00           C  
ATOM    523  CD1 LEU A  37     -18.988  53.418  16.699  1.00  0.00           C  
ATOM    524  CD2 LEU A  37     -20.357  51.438  16.024  1.00  0.00           C  
ATOM    525  H   LEU A  37     -22.198  53.834  14.537  1.00  0.00           H  
ATOM    526  HA  LEU A  37     -23.066  52.093  16.561  1.00  0.00           H  
ATOM    527  HB2 LEU A  37     -21.396  54.556  16.992  1.00  0.00           H  
ATOM    528  HB3 LEU A  37     -21.395  53.068  17.936  1.00  0.00           H  
ATOM    529  HG  LEU A  37     -20.386  53.352  15.106  1.00  0.00           H  
ATOM    530 HD11 LEU A  37     -18.925  53.107  17.731  1.00  0.00           H  
ATOM    531 HD12 LEU A  37     -18.927  54.496  16.644  1.00  0.00           H  
ATOM    532 HD13 LEU A  37     -18.173  52.983  16.141  1.00  0.00           H  
ATOM    533 HD21 LEU A  37     -21.260  51.078  16.495  1.00  0.00           H  
ATOM    534 HD22 LEU A  37     -19.497  51.023  16.529  1.00  0.00           H  
ATOM    535 HD23 LEU A  37     -20.346  51.136  14.986  1.00  0.00           H  
ATOM    536  N   LYS A  38     -24.183  55.166  16.748  1.00  0.00           N  
ATOM    537  CA  LYS A  38     -25.166  56.027  17.396  1.00  0.00           C  
ATOM    538  C   LYS A  38     -26.577  55.477  17.210  1.00  0.00           C  
ATOM    539  O   LYS A  38     -27.409  55.558  18.114  1.00  0.00           O  
ATOM    540  CB  LYS A  38     -25.082  57.446  16.831  1.00  0.00           C  
ATOM    541  CG  LYS A  38     -24.016  58.302  17.493  1.00  0.00           C  
ATOM    542  CD  LYS A  38     -23.835  59.626  16.769  1.00  0.00           C  
ATOM    543  CE  LYS A  38     -22.447  60.205  17.004  1.00  0.00           C  
ATOM    544  NZ  LYS A  38     -22.387  61.008  18.256  1.00  0.00           N  
ATOM    545  H   LYS A  38     -23.699  55.500  15.963  1.00  0.00           H  
ATOM    546  HA  LYS A  38     -24.939  56.054  18.451  1.00  0.00           H  
ATOM    547  HB2 LYS A  38     -24.863  57.389  15.775  1.00  0.00           H  
ATOM    548  HB3 LYS A  38     -26.038  57.932  16.965  1.00  0.00           H  
ATOM    549  HG2 LYS A  38     -24.308  58.500  18.514  1.00  0.00           H  
ATOM    550  HG3 LYS A  38     -23.078  57.765  17.483  1.00  0.00           H  
ATOM    551  HD2 LYS A  38     -23.971  59.468  15.709  1.00  0.00           H  
ATOM    552  HD3 LYS A  38     -24.574  60.327  17.129  1.00  0.00           H  
ATOM    553  HE2 LYS A  38     -21.740  59.393  17.074  1.00  0.00           H  
ATOM    554  HE3 LYS A  38     -22.189  60.836  16.167  1.00  0.00           H  
ATOM    555  HZ1 LYS A  38     -21.809  60.519  18.968  1.00  0.00           H  
ATOM    556  HZ2 LYS A  38     -23.344  61.148  18.638  1.00  0.00           H  
ATOM    557  HZ3 LYS A  38     -21.964  61.939  18.063  1.00  0.00           H  
ATOM    558  N   LEU A  39     -26.839  54.917  16.035  1.00  0.00           N  
ATOM    559  CA  LEU A  39     -28.149  54.352  15.732  1.00  0.00           C  
ATOM    560  C   LEU A  39     -28.304  52.969  16.357  1.00  0.00           C  
ATOM    561  O   LEU A  39     -29.182  52.749  17.193  1.00  0.00           O  
ATOM    562  CB  LEU A  39     -28.351  54.265  14.218  1.00  0.00           C  
ATOM    563  CG  LEU A  39     -28.193  55.574  13.443  1.00  0.00           C  
ATOM    564  CD1 LEU A  39     -28.285  55.323  11.946  1.00  0.00           C  
ATOM    565  CD2 LEU A  39     -29.245  56.583  13.882  1.00  0.00           C  
ATOM    566  H   LEU A  39     -26.136  54.881  15.354  1.00  0.00           H  
ATOM    567  HA  LEU A  39     -28.898  55.009  16.150  1.00  0.00           H  
ATOM    568  HB2 LEU A  39     -27.631  53.562  13.828  1.00  0.00           H  
ATOM    569  HB3 LEU A  39     -29.350  53.892  14.040  1.00  0.00           H  
ATOM    570  HG  LEU A  39     -27.219  55.993  13.652  1.00  0.00           H  
ATOM    571 HD11 LEU A  39     -28.116  54.276  11.747  1.00  0.00           H  
ATOM    572 HD12 LEU A  39     -27.537  55.911  11.436  1.00  0.00           H  
ATOM    573 HD13 LEU A  39     -29.267  55.604  11.593  1.00  0.00           H  
ATOM    574 HD21 LEU A  39     -30.158  56.064  14.133  1.00  0.00           H  
ATOM    575 HD22 LEU A  39     -29.435  57.277  13.076  1.00  0.00           H  
ATOM    576 HD23 LEU A  39     -28.887  57.124  14.746  1.00  0.00           H  
ATOM    577  N   VAL A  40     -27.445  52.041  15.949  1.00  0.00           N  
ATOM    578  CA  VAL A  40     -27.484  50.681  16.472  1.00  0.00           C  
ATOM    579  C   VAL A  40     -27.261  50.665  17.980  1.00  0.00           C  
ATOM    580  O   VAL A  40     -26.402  51.367  18.513  1.00  0.00           O  
ATOM    581  CB  VAL A  40     -26.424  49.790  15.798  1.00  0.00           C  
ATOM    582  CG1 VAL A  40     -26.527  48.360  16.304  1.00  0.00           C  
ATOM    583  CG2 VAL A  40     -26.569  49.841  14.285  1.00  0.00           C  
ATOM    584  H   VAL A  40     -26.768  52.277  15.282  1.00  0.00           H  
ATOM    585  HA  VAL A  40     -28.459  50.269  16.258  1.00  0.00           H  
ATOM    586  HB  VAL A  40     -25.446  50.170  16.057  1.00  0.00           H  
ATOM    587 HG11 VAL A  40     -26.608  48.365  17.381  1.00  0.00           H  
ATOM    588 HG12 VAL A  40     -27.401  47.889  15.879  1.00  0.00           H  
ATOM    589 HG13 VAL A  40     -25.645  47.810  16.013  1.00  0.00           H  
ATOM    590 HG21 VAL A  40     -27.617  49.840  14.025  1.00  0.00           H  
ATOM    591 HG22 VAL A  40     -26.106  50.742  13.908  1.00  0.00           H  
ATOM    592 HG23 VAL A  40     -26.088  48.979  13.847  1.00  0.00           H  
ATOM    593  N   PRO A  41     -28.053  49.845  18.686  1.00  0.00           N  
ATOM    594  CA  PRO A  41     -27.961  49.716  20.144  1.00  0.00           C  
ATOM    595  C   PRO A  41     -26.679  49.017  20.584  1.00  0.00           C  
ATOM    596  O   PRO A  41     -26.617  47.790  20.638  1.00  0.00           O  
ATOM    597  CB  PRO A  41     -29.184  48.868  20.503  1.00  0.00           C  
ATOM    598  CG  PRO A  41     -29.481  48.090  19.268  1.00  0.00           C  
ATOM    599  CD  PRO A  41     -29.100  48.980  18.117  1.00  0.00           C  
ATOM    600  HA  PRO A  41     -28.032  50.677  20.632  1.00  0.00           H  
ATOM    601  HB2 PRO A  41     -28.942  48.218  21.332  1.00  0.00           H  
ATOM    602  HB3 PRO A  41     -30.006  49.512  20.772  1.00  0.00           H  
ATOM    603  HG2 PRO A  41     -28.893  47.184  19.253  1.00  0.00           H  
ATOM    604  HG3 PRO A  41     -30.534  47.856  19.227  1.00  0.00           H  
ATOM    605  HD3 PRO A  41     -28.710  48.391  17.298  1.00  0.00           H  
ATOM    606  HD2 PRO A  41     -29.949  49.563  17.794  1.00  0.00           H  
ATOM    607  N   GLY A  42     -25.658  49.808  20.900  1.00  0.00           N  
ATOM    608  CA  GLY A  42     -24.391  49.246  21.331  1.00  0.00           C  
ATOM    609  C   GLY A  42     -23.844  48.227  20.352  1.00  0.00           C  
ATOM    610  O   GLY A  42     -23.990  47.021  20.555  1.00  0.00           O  
ATOM    611  H   GLY A  42     -25.765  50.780  20.837  1.00  0.00           H  
ATOM    612  HA2 GLY A  42     -23.673  50.046  21.440  1.00  0.00           H  
ATOM    613  HA3 GLY A  42     -24.531  48.769  22.290  1.00  0.00           H  
ATOM    614  N   TYR A  43     -23.216  48.710  19.286  1.00  0.00           N  
ATOM    615  CA  TYR A  43     -22.649  47.832  18.270  1.00  0.00           C  
ATOM    616  C   TYR A  43     -21.168  47.579  18.533  1.00  0.00           C  
ATOM    617  O   TYR A  43     -20.712  46.434  18.532  1.00  0.00           O  
ATOM    618  CB  TYR A  43     -22.833  48.442  16.879  1.00  0.00           C  
ATOM    619  CG  TYR A  43     -22.252  47.600  15.767  1.00  0.00           C  
ATOM    620  CD1 TYR A  43     -22.804  46.367  15.440  1.00  0.00           C  
ATOM    621  CD2 TYR A  43     -21.151  48.036  15.042  1.00  0.00           C  
ATOM    622  CE1 TYR A  43     -22.275  45.594  14.424  1.00  0.00           C  
ATOM    623  CE2 TYR A  43     -20.616  47.271  14.024  1.00  0.00           C  
ATOM    624  CZ  TYR A  43     -21.181  46.050  13.719  1.00  0.00           C  
ATOM    625  OH  TYR A  43     -20.652  45.283  12.706  1.00  0.00           O  
ATOM    626  H   TYR A  43     -23.131  49.681  19.181  1.00  0.00           H  
ATOM    627  HA  TYR A  43     -23.177  46.891  18.314  1.00  0.00           H  
ATOM    628  HB2 TYR A  43     -23.889  48.564  16.685  1.00  0.00           H  
ATOM    629  HB3 TYR A  43     -22.353  49.408  16.850  1.00  0.00           H  
ATOM    630  HD1 TYR A  43     -23.662  46.013  15.994  1.00  0.00           H  
ATOM    631  HD2 TYR A  43     -20.709  48.993  15.282  1.00  0.00           H  
ATOM    632  HE1 TYR A  43     -22.718  44.638  14.186  1.00  0.00           H  
ATOM    633  HE2 TYR A  43     -19.759  47.627  13.472  1.00  0.00           H  
ATOM    634  HH  TYR A  43     -20.799  45.721  11.865  1.00  0.00           H  
ATOM    635  N   LYS A  44     -20.421  48.654  18.760  1.00  0.00           N  
ATOM    636  CA  LYS A  44     -18.991  48.551  19.027  1.00  0.00           C  
ATOM    637  C   LYS A  44     -18.725  47.634  20.217  1.00  0.00           C  
ATOM    638  O   LYS A  44     -17.770  46.857  20.215  1.00  0.00           O  
ATOM    639  CB  LYS A  44     -18.401  49.936  19.296  1.00  0.00           C  
ATOM    640  CG  LYS A  44     -16.946  50.068  18.880  1.00  0.00           C  
ATOM    641  CD  LYS A  44     -16.575  51.514  18.596  1.00  0.00           C  
ATOM    642  CE  LYS A  44     -15.106  51.651  18.227  1.00  0.00           C  
ATOM    643  NZ  LYS A  44     -14.815  51.074  16.884  1.00  0.00           N  
ATOM    644  H   LYS A  44     -20.842  49.539  18.747  1.00  0.00           H  
ATOM    645  HA  LYS A  44     -18.520  48.131  18.151  1.00  0.00           H  
ATOM    646  HB2 LYS A  44     -18.976  50.671  18.752  1.00  0.00           H  
ATOM    647  HB3 LYS A  44     -18.472  50.147  20.353  1.00  0.00           H  
ATOM    648  HG2 LYS A  44     -16.318  49.697  19.677  1.00  0.00           H  
ATOM    649  HG3 LYS A  44     -16.781  49.481  17.987  1.00  0.00           H  
ATOM    650  HD2 LYS A  44     -17.176  51.875  17.774  1.00  0.00           H  
ATOM    651  HD3 LYS A  44     -16.773  52.107  19.478  1.00  0.00           H  
ATOM    652  HE2 LYS A  44     -14.846  52.699  18.223  1.00  0.00           H  
ATOM    653  HE3 LYS A  44     -14.513  51.135  18.967  1.00  0.00           H  
ATOM    654  HZ1 LYS A  44     -14.821  51.824  16.165  1.00  0.00           H  
ATOM    655  HZ2 LYS A  44     -15.536  50.366  16.637  1.00  0.00           H  
ATOM    656  HZ3 LYS A  44     -13.881  50.617  16.887  1.00  0.00           H  
ATOM    657  N   LYS A  45     -19.577  47.728  21.232  1.00  0.00           N  
ATOM    658  CA  LYS A  45     -19.435  46.906  22.428  1.00  0.00           C  
ATOM    659  C   LYS A  45     -19.336  45.428  22.064  1.00  0.00           C  
ATOM    660  O   LYS A  45     -18.480  44.708  22.576  1.00  0.00           O  
ATOM    661  CB  LYS A  45     -20.620  47.131  23.370  1.00  0.00           C  
ATOM    662  CG  LYS A  45     -20.588  48.474  24.078  1.00  0.00           C  
ATOM    663  CD  LYS A  45     -21.439  48.462  25.337  1.00  0.00           C  
ATOM    664  CE  LYS A  45     -22.908  48.692  25.019  1.00  0.00           C  
ATOM    665  NZ  LYS A  45     -23.621  47.416  24.736  1.00  0.00           N  
ATOM    666  H   LYS A  45     -20.319  48.365  21.176  1.00  0.00           H  
ATOM    667  HA  LYS A  45     -18.527  47.202  22.930  1.00  0.00           H  
ATOM    668  HB2 LYS A  45     -21.535  47.070  22.798  1.00  0.00           H  
ATOM    669  HB3 LYS A  45     -20.622  46.352  24.119  1.00  0.00           H  
ATOM    670  HG2 LYS A  45     -19.569  48.704  24.348  1.00  0.00           H  
ATOM    671  HG3 LYS A  45     -20.964  49.233  23.407  1.00  0.00           H  
ATOM    672  HD2 LYS A  45     -21.334  47.504  25.823  1.00  0.00           H  
ATOM    673  HD3 LYS A  45     -21.096  49.244  26.000  1.00  0.00           H  
ATOM    674  HE2 LYS A  45     -23.375  49.175  25.864  1.00  0.00           H  
ATOM    675  HE3 LYS A  45     -22.979  49.334  24.153  1.00  0.00           H  
ATOM    676  HZ1 LYS A  45     -22.971  46.735  24.292  1.00  0.00           H  
ATOM    677  HZ2 LYS A  45     -24.418  47.587  24.090  1.00  0.00           H  
ATOM    678  HZ3 LYS A  45     -23.987  47.006  25.619  1.00  0.00           H  
ATOM    679  N   VAL A  46     -20.217  44.982  21.174  1.00  0.00           N  
ATOM    680  CA  VAL A  46     -20.227  43.589  20.739  1.00  0.00           C  
ATOM    681  C   VAL A  46     -19.129  43.327  19.714  1.00  0.00           C  
ATOM    682  O   VAL A  46     -18.434  42.313  19.780  1.00  0.00           O  
ATOM    683  CB  VAL A  46     -21.587  43.202  20.129  1.00  0.00           C  
ATOM    684  CG1 VAL A  46     -21.527  41.801  19.539  1.00  0.00           C  
ATOM    685  CG2 VAL A  46     -22.688  43.304  21.174  1.00  0.00           C  
ATOM    686  H   VAL A  46     -20.876  45.604  20.801  1.00  0.00           H  
ATOM    687  HA  VAL A  46     -20.053  42.968  21.605  1.00  0.00           H  
ATOM    688  HB  VAL A  46     -21.811  43.895  19.331  1.00  0.00           H  
ATOM    689 HG11 VAL A  46     -20.623  41.693  18.959  1.00  0.00           H  
ATOM    690 HG12 VAL A  46     -21.534  41.074  20.338  1.00  0.00           H  
ATOM    691 HG13 VAL A  46     -22.385  41.643  18.902  1.00  0.00           H  
ATOM    692 HG21 VAL A  46     -22.594  42.487  21.875  1.00  0.00           H  
ATOM    693 HG22 VAL A  46     -22.598  44.242  21.701  1.00  0.00           H  
ATOM    694 HG23 VAL A  46     -23.650  43.254  20.690  1.00  0.00           H  
ATOM    695  N   ILE A  47     -18.978  44.248  18.767  1.00  0.00           N  
ATOM    696  CA  ILE A  47     -17.964  44.115  17.729  1.00  0.00           C  
ATOM    697  C   ILE A  47     -16.684  44.850  18.115  1.00  0.00           C  
ATOM    698  O   ILE A  47     -16.643  46.080  18.136  1.00  0.00           O  
ATOM    699  CB  ILE A  47     -18.467  44.658  16.378  1.00  0.00           C  
ATOM    700  CG1 ILE A  47     -19.764  43.956  15.973  1.00  0.00           C  
ATOM    701  CG2 ILE A  47     -17.403  44.478  15.306  1.00  0.00           C  
ATOM    702  CD1 ILE A  47     -19.659  42.446  15.972  1.00  0.00           C  
ATOM    703  H   ILE A  47     -19.563  45.033  18.767  1.00  0.00           H  
ATOM    704  HA  ILE A  47     -17.742  43.065  17.611  1.00  0.00           H  
ATOM    705  HB  ILE A  47     -18.657  45.715  16.489  1.00  0.00           H  
ATOM    706 HG12 ILE A  47     -20.547  44.232  16.661  1.00  0.00           H  
ATOM    707 HG13 ILE A  47     -20.039  44.270  14.976  1.00  0.00           H  
ATOM    708 HG21 ILE A  47     -16.776  43.637  15.559  1.00  0.00           H  
ATOM    709 HG22 ILE A  47     -17.879  44.297  14.354  1.00  0.00           H  
ATOM    710 HG23 ILE A  47     -16.800  45.371  15.243  1.00  0.00           H  
ATOM    711 HD11 ILE A  47     -18.621  42.157  15.909  1.00  0.00           H  
ATOM    712 HD12 ILE A  47     -20.088  42.054  16.882  1.00  0.00           H  
ATOM    713 HD13 ILE A  47     -20.195  42.048  15.121  1.00  0.00           H  
ATOM    714  N   LYS A  48     -15.640  44.087  18.417  1.00  0.00           N  
ATOM    715  CA  LYS A  48     -14.355  44.664  18.799  1.00  0.00           C  
ATOM    716  C   LYS A  48     -13.812  45.561  17.692  1.00  0.00           C  
ATOM    717  O   LYS A  48     -13.425  46.705  17.938  1.00  0.00           O  
ATOM    718  CB  LYS A  48     -13.349  43.555  19.113  1.00  0.00           C  
ATOM    719  CG  LYS A  48     -13.644  42.813  20.405  1.00  0.00           C  
ATOM    720  CD  LYS A  48     -13.301  43.655  21.623  1.00  0.00           C  
ATOM    721  CE  LYS A  48     -11.858  43.445  22.056  1.00  0.00           C  
ATOM    722  NZ  LYS A  48     -10.919  44.322  21.302  1.00  0.00           N  
ATOM    723  H   LYS A  48     -15.734  43.112  18.381  1.00  0.00           H  
ATOM    724  HA  LYS A  48     -14.510  45.261  19.685  1.00  0.00           H  
ATOM    725  HB2 LYS A  48     -13.353  42.842  18.302  1.00  0.00           H  
ATOM    726  HB3 LYS A  48     -12.363  43.993  19.190  1.00  0.00           H  
ATOM    727  HG2 LYS A  48     -14.695  42.567  20.436  1.00  0.00           H  
ATOM    728  HG3 LYS A  48     -13.059  41.905  20.429  1.00  0.00           H  
ATOM    729  HD2 LYS A  48     -13.443  44.697  21.381  1.00  0.00           H  
ATOM    730  HD3 LYS A  48     -13.956  43.378  22.436  1.00  0.00           H  
ATOM    731  HE2 LYS A  48     -11.776  43.666  23.110  1.00  0.00           H  
ATOM    732  HE3 LYS A  48     -11.590  42.413  21.882  1.00  0.00           H  
ATOM    733  HZ1 LYS A  48     -11.445  45.084  20.829  1.00  0.00           H  
ATOM    734  HZ2 LYS A  48     -10.411  43.768  20.584  1.00  0.00           H  
ATOM    735  HZ3 LYS A  48     -10.226  44.746  21.953  1.00  0.00           H  
ATOM    736  N   LYS A  49     -13.785  45.037  16.471  1.00  0.00           N  
ATOM    737  CA  LYS A  49     -13.290  45.791  15.325  1.00  0.00           C  
ATOM    738  C   LYS A  49     -14.324  45.815  14.203  1.00  0.00           C  
ATOM    739  O   LYS A  49     -14.334  44.960  13.318  1.00  0.00           O  
ATOM    740  CB  LYS A  49     -11.983  45.183  14.814  1.00  0.00           C  
ATOM    741  CG  LYS A  49     -10.744  45.764  15.474  1.00  0.00           C  
ATOM    742  CD  LYS A  49      -9.471  45.244  14.825  1.00  0.00           C  
ATOM    743  CE  LYS A  49      -9.274  45.829  13.435  1.00  0.00           C  
ATOM    744  NZ  LYS A  49      -7.905  45.567  12.912  1.00  0.00           N  
ATOM    745  H   LYS A  49     -14.106  44.120  16.338  1.00  0.00           H  
ATOM    746  HA  LYS A  49     -13.105  46.804  15.649  1.00  0.00           H  
ATOM    747  HB2 LYS A  49     -11.997  44.119  14.999  1.00  0.00           H  
ATOM    748  HB3 LYS A  49     -11.911  45.353  13.749  1.00  0.00           H  
ATOM    749  HG2 LYS A  49     -10.768  46.840  15.381  1.00  0.00           H  
ATOM    750  HG3 LYS A  49     -10.741  45.492  16.520  1.00  0.00           H  
ATOM    751  HD2 LYS A  49      -8.627  45.516  15.441  1.00  0.00           H  
ATOM    752  HD3 LYS A  49      -9.531  44.168  14.749  1.00  0.00           H  
ATOM    753  HE2 LYS A  49      -9.996  45.385  12.767  1.00  0.00           H  
ATOM    754  HE3 LYS A  49      -9.435  46.896  13.481  1.00  0.00           H  
ATOM    755  HZ1 LYS A  49      -7.807  45.961  11.954  1.00  0.00           H  
ATOM    756  HZ2 LYS A  49      -7.728  44.543  12.872  1.00  0.00           H  
ATOM    757  HZ3 LYS A  49      -7.195  46.007  13.532  1.00  0.00           H  
ATOM    758  N   PRO A  50     -15.213  46.818  14.240  1.00  0.00           N  
ATOM    759  CA  PRO A  50     -16.266  46.979  13.231  1.00  0.00           C  
ATOM    760  C   PRO A  50     -15.710  47.390  11.873  1.00  0.00           C  
ATOM    761  O   PRO A  50     -15.523  48.576  11.601  1.00  0.00           O  
ATOM    762  CB  PRO A  50     -17.143  48.092  13.809  1.00  0.00           C  
ATOM    763  CG  PRO A  50     -16.234  48.870  14.698  1.00  0.00           C  
ATOM    764  CD  PRO A  50     -15.260  47.873  15.265  1.00  0.00           C  
ATOM    765  HA  PRO A  50     -16.851  46.078  13.122  1.00  0.00           H  
ATOM    766  HB2 PRO A  50     -17.529  48.705  13.005  1.00  0.00           H  
ATOM    767  HB3 PRO A  50     -17.962  47.660  14.365  1.00  0.00           H  
ATOM    768  HG2 PRO A  50     -15.711  49.619  14.123  1.00  0.00           H  
ATOM    769  HG3 PRO A  50     -16.802  49.331  15.492  1.00  0.00           H  
ATOM    770  HD3 PRO A  50     -14.288  48.328  15.396  1.00  0.00           H  
ATOM    771  HD2 PRO A  50     -15.625  47.482  16.204  1.00  0.00           H  
ATOM    772  N   MET A  51     -15.448  46.403  11.022  1.00  0.00           N  
ATOM    773  CA  MET A  51     -14.915  46.663   9.691  1.00  0.00           C  
ATOM    774  C   MET A  51     -16.037  46.739   8.660  1.00  0.00           C  
ATOM    775  O   MET A  51     -17.171  46.347   8.934  1.00  0.00           O  
ATOM    776  CB  MET A  51     -13.917  45.573   9.295  1.00  0.00           C  
ATOM    777  CG  MET A  51     -13.107  45.911   8.054  1.00  0.00           C  
ATOM    778  SD  MET A  51     -12.263  47.499   8.186  1.00  0.00           S  
ATOM    779  CE  MET A  51     -11.066  47.139   9.470  1.00  0.00           C  
ATOM    780  H   MET A  51     -15.618  45.477  11.296  1.00  0.00           H  
ATOM    781  HA  MET A  51     -14.403  47.613   9.718  1.00  0.00           H  
ATOM    782  HB2 MET A  51     -13.231  45.416  10.114  1.00  0.00           H  
ATOM    783  HB3 MET A  51     -14.458  44.657   9.107  1.00  0.00           H  
ATOM    784  HG2 MET A  51     -12.368  45.139   7.901  1.00  0.00           H  
ATOM    785  HG3 MET A  51     -13.773  45.943   7.205  1.00  0.00           H  
ATOM    786  HE1 MET A  51     -11.513  46.488  10.207  1.00  0.00           H  
ATOM    787  HE2 MET A  51     -10.205  46.654   9.034  1.00  0.00           H  
ATOM    788  HE3 MET A  51     -10.759  48.061   9.944  1.00  0.00           H  
ATOM    789  N   ASP A  52     -15.714  47.245   7.476  1.00  0.00           N  
ATOM    790  CA  ASP A  52     -16.695  47.372   6.405  1.00  0.00           C  
ATOM    791  C   ASP A  52     -16.006  47.476   5.047  1.00  0.00           C  
ATOM    792  O   ASP A  52     -14.847  47.880   4.956  1.00  0.00           O  
ATOM    793  CB  ASP A  52     -17.580  48.597   6.637  1.00  0.00           C  
ATOM    794  CG  ASP A  52     -16.777  49.875   6.771  1.00  0.00           C  
ATOM    795  OD1 ASP A  52     -15.820  49.892   7.574  1.00  0.00           O  
ATOM    796  OD2 ASP A  52     -17.105  50.858   6.074  1.00  0.00           O  
ATOM    797  H   ASP A  52     -14.792  47.541   7.317  1.00  0.00           H  
ATOM    798  HA  ASP A  52     -17.312  46.486   6.413  1.00  0.00           H  
ATOM    799  HB2 ASP A  52     -18.258  48.706   5.803  1.00  0.00           H  
ATOM    800  HB3 ASP A  52     -18.151  48.454   7.543  1.00  0.00           H  
ATOM    801  N   PHE A  53     -16.728  47.109   3.994  1.00  0.00           N  
ATOM    802  CA  PHE A  53     -16.187  47.159   2.640  1.00  0.00           C  
ATOM    803  C   PHE A  53     -15.816  48.589   2.256  1.00  0.00           C  
ATOM    804  O   PHE A  53     -14.821  48.818   1.569  1.00  0.00           O  
ATOM    805  CB  PHE A  53     -17.202  46.599   1.642  1.00  0.00           C  
ATOM    806  CG  PHE A  53     -17.335  45.104   1.697  1.00  0.00           C  
ATOM    807  CD1 PHE A  53     -16.211  44.294   1.677  1.00  0.00           C  
ATOM    808  CD2 PHE A  53     -18.584  44.508   1.771  1.00  0.00           C  
ATOM    809  CE1 PHE A  53     -16.330  42.917   1.728  1.00  0.00           C  
ATOM    810  CE2 PHE A  53     -18.709  43.133   1.822  1.00  0.00           C  
ATOM    811  CZ  PHE A  53     -17.582  42.337   1.802  1.00  0.00           C  
ATOM    812  H   PHE A  53     -17.648  46.796   4.130  1.00  0.00           H  
ATOM    813  HA  PHE A  53     -15.298  46.550   2.617  1.00  0.00           H  
ATOM    814  HB2 PHE A  53     -18.171  47.025   1.846  1.00  0.00           H  
ATOM    815  HB3 PHE A  53     -16.898  46.869   0.640  1.00  0.00           H  
ATOM    816  HD1 PHE A  53     -15.231  44.746   1.620  1.00  0.00           H  
ATOM    817  HD2 PHE A  53     -19.468  45.131   1.788  1.00  0.00           H  
ATOM    818  HE1 PHE A  53     -15.447  42.298   1.712  1.00  0.00           H  
ATOM    819  HE2 PHE A  53     -19.690  42.682   1.880  1.00  0.00           H  
ATOM    820  HZ  PHE A  53     -17.677  41.262   1.841  1.00  0.00           H  
ATOM    821  N   SER A  54     -16.622  49.545   2.706  1.00  0.00           N  
ATOM    822  CA  SER A  54     -16.381  50.951   2.406  1.00  0.00           C  
ATOM    823  C   SER A  54     -15.015  51.391   2.926  1.00  0.00           C  
ATOM    824  O   SER A  54     -14.322  52.188   2.291  1.00  0.00           O  
ATOM    825  CB  SER A  54     -17.477  51.821   3.023  1.00  0.00           C  
ATOM    826  OG  SER A  54     -17.356  53.169   2.604  1.00  0.00           O  
ATOM    827  H   SER A  54     -17.399  49.297   3.250  1.00  0.00           H  
ATOM    828  HA  SER A  54     -16.400  51.070   1.333  1.00  0.00           H  
ATOM    829  HB2 SER A  54     -18.443  51.449   2.718  1.00  0.00           H  
ATOM    830  HB3 SER A  54     -17.400  51.783   4.100  1.00  0.00           H  
ATOM    831  HG  SER A  54     -17.936  53.327   1.857  1.00  0.00           H  
ATOM    832  N   THR A  55     -14.632  50.866   4.085  1.00  0.00           N  
ATOM    833  CA  THR A  55     -13.351  51.203   4.692  1.00  0.00           C  
ATOM    834  C   THR A  55     -12.218  50.393   4.072  1.00  0.00           C  
ATOM    835  O   THR A  55     -11.266  50.954   3.530  1.00  0.00           O  
ATOM    836  CB  THR A  55     -13.368  50.960   6.213  1.00  0.00           C  
ATOM    837  OG1 THR A  55     -14.383  51.763   6.826  1.00  0.00           O  
ATOM    838  CG2 THR A  55     -12.015  51.288   6.828  1.00  0.00           C  
ATOM    839  H   THR A  55     -15.227  50.236   4.543  1.00  0.00           H  
ATOM    840  HA  THR A  55     -13.166  52.253   4.518  1.00  0.00           H  
ATOM    841  HB  THR A  55     -13.586  49.917   6.393  1.00  0.00           H  
ATOM    842  HG1 THR A  55     -14.317  51.688   7.781  1.00  0.00           H  
ATOM    843 HG21 THR A  55     -11.316  51.541   6.046  1.00  0.00           H  
ATOM    844 HG22 THR A  55     -11.651  50.429   7.373  1.00  0.00           H  
ATOM    845 HG23 THR A  55     -12.120  52.124   7.502  1.00  0.00           H  
ATOM    846  N   ILE A  56     -12.329  49.071   4.155  1.00  0.00           N  
ATOM    847  CA  ILE A  56     -11.314  48.183   3.599  1.00  0.00           C  
ATOM    848  C   ILE A  56     -10.851  48.668   2.230  1.00  0.00           C  
ATOM    849  O   ILE A  56      -9.667  48.592   1.901  1.00  0.00           O  
ATOM    850  CB  ILE A  56     -11.837  46.741   3.472  1.00  0.00           C  
ATOM    851  CG1 ILE A  56     -12.264  46.207   4.840  1.00  0.00           C  
ATOM    852  CG2 ILE A  56     -10.774  45.845   2.856  1.00  0.00           C  
ATOM    853  CD1 ILE A  56     -13.061  44.924   4.767  1.00  0.00           C  
ATOM    854  H   ILE A  56     -13.112  48.684   4.598  1.00  0.00           H  
ATOM    855  HA  ILE A  56     -10.469  48.181   4.273  1.00  0.00           H  
ATOM    856  HB  ILE A  56     -12.692  46.748   2.813  1.00  0.00           H  
ATOM    857 HG12 ILE A  56     -11.385  46.018   5.436  1.00  0.00           H  
ATOM    858 HG13 ILE A  56     -12.874  46.950   5.333  1.00  0.00           H  
ATOM    859 HG21 ILE A  56     -11.249  45.061   2.284  1.00  0.00           H  
ATOM    860 HG22 ILE A  56     -10.142  46.431   2.204  1.00  0.00           H  
ATOM    861 HG23 ILE A  56     -10.174  45.406   3.639  1.00  0.00           H  
ATOM    862 HD11 ILE A  56     -14.095  45.153   4.560  1.00  0.00           H  
ATOM    863 HD12 ILE A  56     -12.665  44.298   3.982  1.00  0.00           H  
ATOM    864 HD13 ILE A  56     -12.991  44.402   5.712  1.00  0.00           H  
ATOM    865  N   ARG A  57     -11.793  49.166   1.435  1.00  0.00           N  
ATOM    866  CA  ARG A  57     -11.480  49.663   0.100  1.00  0.00           C  
ATOM    867  C   ARG A  57     -10.471  50.806   0.168  1.00  0.00           C  
ATOM    868  O   ARG A  57      -9.402  50.738  -0.436  1.00  0.00           O  
ATOM    869  CB  ARG A  57     -12.755  50.135  -0.603  1.00  0.00           C  
ATOM    870  CG  ARG A  57     -12.494  50.901  -1.889  1.00  0.00           C  
ATOM    871  CD  ARG A  57     -12.275  49.960  -3.063  1.00  0.00           C  
ATOM    872  NE  ARG A  57     -13.533  49.443  -3.593  1.00  0.00           N  
ATOM    873  CZ  ARG A  57     -13.664  48.932  -4.812  1.00  0.00           C  
ATOM    874  NH1 ARG A  57     -12.617  48.871  -5.623  1.00  0.00           N  
ATOM    875  NH2 ARG A  57     -14.843  48.482  -5.223  1.00  0.00           N  
ATOM    876  H   ARG A  57     -12.719  49.200   1.753  1.00  0.00           H  
ATOM    877  HA  ARG A  57     -11.049  48.850  -0.465  1.00  0.00           H  
ATOM    878  HB2 ARG A  57     -13.362  49.272  -0.840  1.00  0.00           H  
ATOM    879  HB3 ARG A  57     -13.304  50.778   0.069  1.00  0.00           H  
ATOM    880  HG2 ARG A  57     -13.346  51.531  -2.101  1.00  0.00           H  
ATOM    881  HG3 ARG A  57     -11.614  51.513  -1.760  1.00  0.00           H  
ATOM    882  HD2 ARG A  57     -11.759  50.496  -3.846  1.00  0.00           H  
ATOM    883  HD3 ARG A  57     -11.666  49.131  -2.733  1.00  0.00           H  
ATOM    884  HE  ARG A  57     -14.321  49.479  -3.010  1.00  0.00           H  
ATOM    885 HH11 ARG A  57     -11.726  49.208  -5.317  1.00  0.00           H  
ATOM    886 HH12 ARG A  57     -12.717  48.484  -6.541  1.00  0.00           H  
ATOM    887 HH21 ARG A  57     -15.634  48.527  -4.614  1.00  0.00           H  
ATOM    888 HH22 ARG A  57     -14.939  48.098  -6.140  1.00  0.00           H  
ATOM    889  N   GLU A  58     -10.821  51.854   0.906  1.00  0.00           N  
ATOM    890  CA  GLU A  58      -9.946  53.012   1.051  1.00  0.00           C  
ATOM    891  C   GLU A  58      -8.576  52.596   1.577  1.00  0.00           C  
ATOM    892  O   GLU A  58      -7.550  53.139   1.167  1.00  0.00           O  
ATOM    893  CB  GLU A  58     -10.576  54.040   1.993  1.00  0.00           C  
ATOM    894  CG  GLU A  58     -11.950  54.514   1.547  1.00  0.00           C  
ATOM    895  CD  GLU A  58     -12.717  55.207   2.656  1.00  0.00           C  
ATOM    896  OE1 GLU A  58     -12.185  56.187   3.220  1.00  0.00           O  
ATOM    897  OE2 GLU A  58     -13.845  54.772   2.960  1.00  0.00           O  
ATOM    898  H   GLU A  58     -11.688  51.850   1.363  1.00  0.00           H  
ATOM    899  HA  GLU A  58      -9.824  53.459   0.075  1.00  0.00           H  
ATOM    900  HB2 GLU A  58     -10.670  53.602   2.975  1.00  0.00           H  
ATOM    901  HB3 GLU A  58      -9.926  54.900   2.054  1.00  0.00           H  
ATOM    902  HG2 GLU A  58     -11.830  55.205   0.726  1.00  0.00           H  
ATOM    903  HG3 GLU A  58     -12.521  53.659   1.215  1.00  0.00           H  
ATOM    904  N   LYS A  59      -8.567  51.630   2.489  1.00  0.00           N  
ATOM    905  CA  LYS A  59      -7.325  51.139   3.073  1.00  0.00           C  
ATOM    906  C   LYS A  59      -6.517  50.350   2.048  1.00  0.00           C  
ATOM    907  O   LYS A  59      -5.293  50.470   1.980  1.00  0.00           O  
ATOM    908  CB  LYS A  59      -7.622  50.261   4.290  1.00  0.00           C  
ATOM    909  CG  LYS A  59      -8.235  51.021   5.454  1.00  0.00           C  
ATOM    910  CD  LYS A  59      -8.812  50.076   6.495  1.00  0.00           C  
ATOM    911  CE  LYS A  59      -7.716  49.329   7.239  1.00  0.00           C  
ATOM    912  NZ  LYS A  59      -8.261  48.197   8.038  1.00  0.00           N  
ATOM    913  H   LYS A  59      -9.419  51.237   2.777  1.00  0.00           H  
ATOM    914  HA  LYS A  59      -6.746  51.994   3.389  1.00  0.00           H  
ATOM    915  HB2 LYS A  59      -8.307  49.479   3.998  1.00  0.00           H  
ATOM    916  HB3 LYS A  59      -6.698  49.811   4.628  1.00  0.00           H  
ATOM    917  HG2 LYS A  59      -7.470  51.627   5.919  1.00  0.00           H  
ATOM    918  HG3 LYS A  59      -9.024  51.656   5.080  1.00  0.00           H  
ATOM    919  HD2 LYS A  59      -9.390  50.648   7.206  1.00  0.00           H  
ATOM    920  HD3 LYS A  59      -9.453  49.359   6.001  1.00  0.00           H  
ATOM    921  HE2 LYS A  59      -7.009  48.945   6.521  1.00  0.00           H  
ATOM    922  HE3 LYS A  59      -7.216  50.020   7.902  1.00  0.00           H  
ATOM    923  HZ1 LYS A  59      -9.296  48.274   8.108  1.00  0.00           H  
ATOM    924  HZ2 LYS A  59      -7.858  48.210   8.997  1.00  0.00           H  
ATOM    925  HZ3 LYS A  59      -8.021  47.292   7.586  1.00  0.00           H  
ATOM    926  N   LEU A  60      -7.209  49.542   1.251  1.00  0.00           N  
ATOM    927  CA  LEU A  60      -6.556  48.734   0.227  1.00  0.00           C  
ATOM    928  C   LEU A  60      -5.805  49.615  -0.766  1.00  0.00           C  
ATOM    929  O   LEU A  60      -4.596  49.471  -0.950  1.00  0.00           O  
ATOM    930  CB  LEU A  60      -7.587  47.879  -0.511  1.00  0.00           C  
ATOM    931  CG  LEU A  60      -7.089  46.534  -1.040  1.00  0.00           C  
ATOM    932  CD1 LEU A  60      -8.198  45.809  -1.786  1.00  0.00           C  
ATOM    933  CD2 LEU A  60      -5.879  46.731  -1.942  1.00  0.00           C  
ATOM    934  H   LEU A  60      -8.181  49.489   1.352  1.00  0.00           H  
ATOM    935  HA  LEU A  60      -5.848  48.084   0.720  1.00  0.00           H  
ATOM    936  HB2 LEU A  60      -8.403  47.684   0.169  1.00  0.00           H  
ATOM    937  HB3 LEU A  60      -7.951  48.452  -1.351  1.00  0.00           H  
ATOM    938  HG  LEU A  60      -6.789  45.915  -0.207  1.00  0.00           H  
ATOM    939 HD11 LEU A  60      -9.148  46.030  -1.322  1.00  0.00           H  
ATOM    940 HD12 LEU A  60      -8.020  44.744  -1.752  1.00  0.00           H  
ATOM    941 HD13 LEU A  60      -8.215  46.138  -2.815  1.00  0.00           H  
ATOM    942 HD21 LEU A  60      -5.803  47.772  -2.220  1.00  0.00           H  
ATOM    943 HD22 LEU A  60      -5.990  46.128  -2.831  1.00  0.00           H  
ATOM    944 HD23 LEU A  60      -4.985  46.433  -1.414  1.00  0.00           H  
ATOM    945  N   SER A  61      -6.530  50.529  -1.403  1.00  0.00           N  
ATOM    946  CA  SER A  61      -5.933  51.434  -2.379  1.00  0.00           C  
ATOM    947  C   SER A  61      -4.894  52.335  -1.720  1.00  0.00           C  
ATOM    948  O   SER A  61      -3.824  52.582  -2.280  1.00  0.00           O  
ATOM    949  CB  SER A  61      -7.015  52.286  -3.045  1.00  0.00           C  
ATOM    950  OG  SER A  61      -6.600  52.724  -4.328  1.00  0.00           O  
ATOM    951  H   SER A  61      -7.489  50.596  -1.214  1.00  0.00           H  
ATOM    952  HA  SER A  61      -5.445  50.833  -3.133  1.00  0.00           H  
ATOM    953  HB2 SER A  61      -7.915  51.700  -3.152  1.00  0.00           H  
ATOM    954  HB3 SER A  61      -7.218  53.149  -2.430  1.00  0.00           H  
ATOM    955  HG  SER A  61      -6.514  51.968  -4.913  1.00  0.00           H  
ATOM    956  N   SER A  62      -5.216  52.825  -0.527  1.00  0.00           N  
ATOM    957  CA  SER A  62      -4.313  53.703   0.208  1.00  0.00           C  
ATOM    958  C   SER A  62      -2.974  53.015   0.462  1.00  0.00           C  
ATOM    959  O   SER A  62      -1.960  53.673   0.694  1.00  0.00           O  
ATOM    960  CB  SER A  62      -4.944  54.121   1.538  1.00  0.00           C  
ATOM    961  OG  SER A  62      -5.845  55.201   1.357  1.00  0.00           O  
ATOM    962  H   SER A  62      -6.082  52.592  -0.133  1.00  0.00           H  
ATOM    963  HA  SER A  62      -4.144  54.583  -0.393  1.00  0.00           H  
ATOM    964  HB2 SER A  62      -5.483  53.285   1.956  1.00  0.00           H  
ATOM    965  HB3 SER A  62      -4.166  54.427   2.222  1.00  0.00           H  
ATOM    966  HG  SER A  62      -6.181  55.191   0.457  1.00  0.00           H  
ATOM    967  N   GLY A  63      -2.980  51.688   0.417  1.00  0.00           N  
ATOM    968  CA  GLY A  63      -1.762  50.932   0.644  1.00  0.00           C  
ATOM    969  C   GLY A  63      -1.563  50.578   2.105  1.00  0.00           C  
ATOM    970  O   GLY A  63      -0.437  50.571   2.600  1.00  0.00           O  
ATOM    971  H   GLY A  63      -3.819  51.216   0.228  1.00  0.00           H  
ATOM    972  HA2 GLY A  63      -1.803  50.021   0.066  1.00  0.00           H  
ATOM    973  HA3 GLY A  63      -0.920  51.521   0.310  1.00  0.00           H  
ATOM    974  N   GLN A  64      -2.660  50.285   2.795  1.00  0.00           N  
ATOM    975  CA  GLN A  64      -2.600  49.929   4.209  1.00  0.00           C  
ATOM    976  C   GLN A  64      -2.195  48.471   4.388  1.00  0.00           C  
ATOM    977  O   GLN A  64      -1.559  48.109   5.378  1.00  0.00           O  
ATOM    978  CB  GLN A  64      -3.952  50.182   4.877  1.00  0.00           C  
ATOM    979  CG  GLN A  64      -4.373  51.643   4.868  1.00  0.00           C  
ATOM    980  CD  GLN A  64      -3.804  52.422   6.038  1.00  0.00           C  
ATOM    981  OE1 GLN A  64      -2.604  52.367   6.309  1.00  0.00           O  
ATOM    982  NE2 GLN A  64      -4.664  53.153   6.736  1.00  0.00           N  
ATOM    983  H   GLN A  64      -3.529  50.307   2.344  1.00  0.00           H  
ATOM    984  HA  GLN A  64      -1.856  50.556   4.676  1.00  0.00           H  
ATOM    985  HB2 GLN A  64      -4.708  49.608   4.361  1.00  0.00           H  
ATOM    986  HB3 GLN A  64      -3.900  49.852   5.904  1.00  0.00           H  
ATOM    987  HG2 GLN A  64      -4.027  52.098   3.951  1.00  0.00           H  
ATOM    988  HG3 GLN A  64      -5.450  51.694   4.909  1.00  0.00           H  
ATOM    989 HE21 GLN A  64      -5.606  53.148   6.462  1.00  0.00           H  
ATOM    990 HE22 GLN A  64      -4.324  53.665   7.498  1.00  0.00           H  
ATOM    991  N   TYR A  65      -2.569  47.636   3.424  1.00  0.00           N  
ATOM    992  CA  TYR A  65      -2.247  46.215   3.476  1.00  0.00           C  
ATOM    993  C   TYR A  65      -0.901  45.936   2.816  1.00  0.00           C  
ATOM    994  O   TYR A  65      -0.741  46.050   1.600  1.00  0.00           O  
ATOM    995  CB  TYR A  65      -3.343  45.397   2.790  1.00  0.00           C  
ATOM    996  CG  TYR A  65      -4.726  45.654   3.344  1.00  0.00           C  
ATOM    997  CD1 TYR A  65      -4.988  45.526   4.703  1.00  0.00           C  
ATOM    998  CD2 TYR A  65      -5.773  46.025   2.509  1.00  0.00           C  
ATOM    999  CE1 TYR A  65      -6.250  45.759   5.213  1.00  0.00           C  
ATOM   1000  CE2 TYR A  65      -7.038  46.262   3.010  1.00  0.00           C  
ATOM   1001  CZ  TYR A  65      -7.272  46.127   4.362  1.00  0.00           C  
ATOM   1002  OH  TYR A  65      -8.530  46.361   4.866  1.00  0.00           O  
ATOM   1003  H   TYR A  65      -3.074  47.983   2.659  1.00  0.00           H  
ATOM   1004  HA  TYR A  65      -2.193  45.926   4.515  1.00  0.00           H  
ATOM   1005  HB2 TYR A  65      -3.358  45.637   1.738  1.00  0.00           H  
ATOM   1006  HB3 TYR A  65      -3.127  44.346   2.912  1.00  0.00           H  
ATOM   1007  HD1 TYR A  65      -4.185  45.237   5.366  1.00  0.00           H  
ATOM   1008  HD2 TYR A  65      -5.587  46.129   1.450  1.00  0.00           H  
ATOM   1009  HE1 TYR A  65      -6.433  45.654   6.272  1.00  0.00           H  
ATOM   1010  HE2 TYR A  65      -7.839  46.550   2.344  1.00  0.00           H  
ATOM   1011  HH  TYR A  65      -8.608  45.960   5.735  1.00  0.00           H  
ATOM   1012  N   PRO A  66       0.093  45.561   3.635  1.00  0.00           N  
ATOM   1013  CA  PRO A  66       1.444  45.257   3.153  1.00  0.00           C  
ATOM   1014  C   PRO A  66       1.493  43.967   2.344  1.00  0.00           C  
ATOM   1015  O   PRO A  66       2.376  43.782   1.506  1.00  0.00           O  
ATOM   1016  CB  PRO A  66       2.255  45.111   4.443  1.00  0.00           C  
ATOM   1017  CG  PRO A  66       1.256  44.719   5.476  1.00  0.00           C  
ATOM   1018  CD  PRO A  66      -0.026  45.406   5.094  1.00  0.00           C  
ATOM   1019  HA  PRO A  66       1.846  46.068   2.563  1.00  0.00           H  
ATOM   1020  HB2 PRO A  66       3.009  44.348   4.313  1.00  0.00           H  
ATOM   1021  HB3 PRO A  66       2.726  46.052   4.685  1.00  0.00           H  
ATOM   1022  HG2 PRO A  66       1.124  43.648   5.473  1.00  0.00           H  
ATOM   1023  HG3 PRO A  66       1.585  45.055   6.450  1.00  0.00           H  
ATOM   1024  HD3 PRO A  66      -0.875  44.788   5.348  1.00  0.00           H  
ATOM   1025  HD2 PRO A  66      -0.099  46.368   5.579  1.00  0.00           H  
ATOM   1026  N   ASN A  67       0.540  43.076   2.598  1.00  0.00           N  
ATOM   1027  CA  ASN A  67       0.476  41.802   1.892  1.00  0.00           C  
ATOM   1028  C   ASN A  67      -0.950  41.259   1.877  1.00  0.00           C  
ATOM   1029  O   ASN A  67      -1.876  41.903   2.373  1.00  0.00           O  
ATOM   1030  CB  ASN A  67       1.414  40.785   2.546  1.00  0.00           C  
ATOM   1031  CG  ASN A  67       1.579  41.024   4.034  1.00  0.00           C  
ATOM   1032  OD1 ASN A  67       2.677  41.312   4.509  1.00  0.00           O  
ATOM   1033  ND2 ASN A  67       0.485  40.905   4.777  1.00  0.00           N  
ATOM   1034  H   ASN A  67      -0.136  43.281   3.277  1.00  0.00           H  
ATOM   1035  HA  ASN A  67       0.795  41.970   0.875  1.00  0.00           H  
ATOM   1036  HB2 ASN A  67       1.013  39.792   2.403  1.00  0.00           H  
ATOM   1037  HB3 ASN A  67       2.385  40.847   2.079  1.00  0.00           H  
ATOM   1038 HD21 ASN A  67      -0.356  40.674   4.331  1.00  0.00           H  
ATOM   1039 HD22 ASN A  67       0.564  41.055   5.743  1.00  0.00           H  
ATOM   1040  N   LEU A  68      -1.120  40.072   1.306  1.00  0.00           N  
ATOM   1041  CA  LEU A  68      -2.433  39.441   1.228  1.00  0.00           C  
ATOM   1042  C   LEU A  68      -2.959  39.103   2.618  1.00  0.00           C  
ATOM   1043  O   LEU A  68      -4.103  39.413   2.952  1.00  0.00           O  
ATOM   1044  CB  LEU A  68      -2.361  38.174   0.375  1.00  0.00           C  
ATOM   1045  CG  LEU A  68      -1.814  38.347  -1.043  1.00  0.00           C  
ATOM   1046  CD1 LEU A  68      -1.596  36.993  -1.701  1.00  0.00           C  
ATOM   1047  CD2 LEU A  68      -2.757  39.202  -1.876  1.00  0.00           C  
ATOM   1048  H   LEU A  68      -0.344  39.607   0.929  1.00  0.00           H  
ATOM   1049  HA  LEU A  68      -3.108  40.141   0.760  1.00  0.00           H  
ATOM   1050  HB2 LEU A  68      -1.728  37.465   0.889  1.00  0.00           H  
ATOM   1051  HB3 LEU A  68      -3.360  37.770   0.298  1.00  0.00           H  
ATOM   1052  HG  LEU A  68      -0.859  38.851  -0.993  1.00  0.00           H  
ATOM   1053 HD11 LEU A  68      -1.464  36.240  -0.939  1.00  0.00           H  
ATOM   1054 HD12 LEU A  68      -0.715  37.034  -2.324  1.00  0.00           H  
ATOM   1055 HD13 LEU A  68      -2.455  36.746  -2.307  1.00  0.00           H  
ATOM   1056 HD21 LEU A  68      -2.504  39.102  -2.921  1.00  0.00           H  
ATOM   1057 HD22 LEU A  68      -2.661  40.237  -1.581  1.00  0.00           H  
ATOM   1058 HD23 LEU A  68      -3.774  38.875  -1.719  1.00  0.00           H  
ATOM   1059  N   GLU A  69      -2.116  38.467   3.427  1.00  0.00           N  
ATOM   1060  CA  GLU A  69      -2.497  38.090   4.783  1.00  0.00           C  
ATOM   1061  C   GLU A  69      -3.373  39.164   5.421  1.00  0.00           C  
ATOM   1062  O   GLU A  69      -4.540  38.927   5.733  1.00  0.00           O  
ATOM   1063  CB  GLU A  69      -1.251  37.855   5.639  1.00  0.00           C  
ATOM   1064  CG  GLU A  69      -1.536  37.120   6.939  1.00  0.00           C  
ATOM   1065  CD  GLU A  69      -0.273  36.782   7.706  1.00  0.00           C  
ATOM   1066  OE1 GLU A  69       0.639  37.634   7.753  1.00  0.00           O  
ATOM   1067  OE2 GLU A  69      -0.196  35.665   8.261  1.00  0.00           O  
ATOM   1068  H   GLU A  69      -1.218  38.248   3.104  1.00  0.00           H  
ATOM   1069  HA  GLU A  69      -3.061  37.171   4.724  1.00  0.00           H  
ATOM   1070  HB2 GLU A  69      -0.541  37.276   5.069  1.00  0.00           H  
ATOM   1071  HB3 GLU A  69      -0.811  38.811   5.881  1.00  0.00           H  
ATOM   1072  HG2 GLU A  69      -2.161  37.742   7.560  1.00  0.00           H  
ATOM   1073  HG3 GLU A  69      -2.057  36.201   6.710  1.00  0.00           H  
ATOM   1074  N   THR A  70      -2.799  40.349   5.615  1.00  0.00           N  
ATOM   1075  CA  THR A  70      -3.525  41.459   6.217  1.00  0.00           C  
ATOM   1076  C   THR A  70      -4.871  41.672   5.534  1.00  0.00           C  
ATOM   1077  O   THR A  70      -5.922  41.574   6.168  1.00  0.00           O  
ATOM   1078  CB  THR A  70      -2.713  42.767   6.145  1.00  0.00           C  
ATOM   1079  OG1 THR A  70      -2.275  42.997   4.801  1.00  0.00           O  
ATOM   1080  CG2 THR A  70      -1.510  42.708   7.073  1.00  0.00           C  
ATOM   1081  H   THR A  70      -1.866  40.476   5.346  1.00  0.00           H  
ATOM   1082  HA  THR A  70      -3.694  41.222   7.258  1.00  0.00           H  
ATOM   1083  HB  THR A  70      -3.348  43.584   6.454  1.00  0.00           H  
ATOM   1084  HG1 THR A  70      -1.912  42.184   4.439  1.00  0.00           H  
ATOM   1085 HG21 THR A  70      -1.774  43.131   8.031  1.00  0.00           H  
ATOM   1086 HG22 THR A  70      -0.696  43.271   6.642  1.00  0.00           H  
ATOM   1087 HG23 THR A  70      -1.207  41.680   7.206  1.00  0.00           H  
ATOM   1088  N   PHE A  71      -4.832  41.962   4.239  1.00  0.00           N  
ATOM   1089  CA  PHE A  71      -6.051  42.190   3.469  1.00  0.00           C  
ATOM   1090  C   PHE A  71      -7.108  41.142   3.804  1.00  0.00           C  
ATOM   1091  O   PHE A  71      -8.264  41.473   4.064  1.00  0.00           O  
ATOM   1092  CB  PHE A  71      -5.744  42.162   1.970  1.00  0.00           C  
ATOM   1093  CG  PHE A  71      -6.973  42.166   1.108  1.00  0.00           C  
ATOM   1094  CD1 PHE A  71      -7.617  43.355   0.801  1.00  0.00           C  
ATOM   1095  CD2 PHE A  71      -7.486  40.982   0.602  1.00  0.00           C  
ATOM   1096  CE1 PHE A  71      -8.749  43.363   0.007  1.00  0.00           C  
ATOM   1097  CE2 PHE A  71      -8.617  40.984  -0.193  1.00  0.00           C  
ATOM   1098  CZ  PHE A  71      -9.250  42.175  -0.490  1.00  0.00           C  
ATOM   1099  H   PHE A  71      -3.963  42.027   3.789  1.00  0.00           H  
ATOM   1100  HA  PHE A  71      -6.431  43.164   3.732  1.00  0.00           H  
ATOM   1101  HB2 PHE A  71      -5.156  43.030   1.714  1.00  0.00           H  
ATOM   1102  HB3 PHE A  71      -5.180  41.270   1.742  1.00  0.00           H  
ATOM   1103  HD1 PHE A  71      -7.226  44.284   1.190  1.00  0.00           H  
ATOM   1104  HD2 PHE A  71      -6.994  40.050   0.834  1.00  0.00           H  
ATOM   1105  HE1 PHE A  71      -9.240  44.296  -0.222  1.00  0.00           H  
ATOM   1106  HE2 PHE A  71      -9.007  40.055  -0.580  1.00  0.00           H  
ATOM   1107  HZ  PHE A  71     -10.133  42.180  -1.111  1.00  0.00           H  
ATOM   1108  N   ALA A  72      -6.702  39.876   3.793  1.00  0.00           N  
ATOM   1109  CA  ALA A  72      -7.613  38.780   4.096  1.00  0.00           C  
ATOM   1110  C   ALA A  72      -8.145  38.886   5.522  1.00  0.00           C  
ATOM   1111  O   ALA A  72      -9.352  38.795   5.754  1.00  0.00           O  
ATOM   1112  CB  ALA A  72      -6.918  37.443   3.890  1.00  0.00           C  
ATOM   1113  H   ALA A  72      -5.767  39.675   3.579  1.00  0.00           H  
ATOM   1114  HA  ALA A  72      -8.444  38.836   3.409  1.00  0.00           H  
ATOM   1115  HB1 ALA A  72      -6.612  37.353   2.857  1.00  0.00           H  
ATOM   1116  HB2 ALA A  72      -6.049  37.386   4.528  1.00  0.00           H  
ATOM   1117  HB3 ALA A  72      -7.598  36.641   4.135  1.00  0.00           H  
ATOM   1118  N   LEU A  73      -7.239  39.079   6.474  1.00  0.00           N  
ATOM   1119  CA  LEU A  73      -7.617  39.198   7.878  1.00  0.00           C  
ATOM   1120  C   LEU A  73      -8.818  40.123   8.042  1.00  0.00           C  
ATOM   1121  O   LEU A  73      -9.750  39.820   8.788  1.00  0.00           O  
ATOM   1122  CB  LEU A  73      -6.439  39.721   8.701  1.00  0.00           C  
ATOM   1123  CG  LEU A  73      -5.248  38.773   8.848  1.00  0.00           C  
ATOM   1124  CD1 LEU A  73      -4.057  39.501   9.453  1.00  0.00           C  
ATOM   1125  CD2 LEU A  73      -5.627  37.569   9.698  1.00  0.00           C  
ATOM   1126  H   LEU A  73      -6.292  39.144   6.228  1.00  0.00           H  
ATOM   1127  HA  LEU A  73      -7.884  38.213   8.233  1.00  0.00           H  
ATOM   1128  HB2 LEU A  73      -6.084  40.626   8.233  1.00  0.00           H  
ATOM   1129  HB3 LEU A  73      -6.805  39.950   9.691  1.00  0.00           H  
ATOM   1130  HG  LEU A  73      -4.958  38.415   7.870  1.00  0.00           H  
ATOM   1131 HD11 LEU A  73      -3.399  39.830   8.664  1.00  0.00           H  
ATOM   1132 HD12 LEU A  73      -3.525  38.833  10.112  1.00  0.00           H  
ATOM   1133 HD13 LEU A  73      -4.406  40.356  10.013  1.00  0.00           H  
ATOM   1134 HD21 LEU A  73      -4.783  36.898   9.768  1.00  0.00           H  
ATOM   1135 HD22 LEU A  73      -6.458  37.053   9.240  1.00  0.00           H  
ATOM   1136 HD23 LEU A  73      -5.909  37.900  10.687  1.00  0.00           H  
ATOM   1137  N   ASP A  74      -8.791  41.250   7.339  1.00  0.00           N  
ATOM   1138  CA  ASP A  74      -9.879  42.218   7.404  1.00  0.00           C  
ATOM   1139  C   ASP A  74     -11.156  41.643   6.798  1.00  0.00           C  
ATOM   1140  O   ASP A  74     -12.215  41.658   7.423  1.00  0.00           O  
ATOM   1141  CB  ASP A  74      -9.489  43.506   6.678  1.00  0.00           C  
ATOM   1142  CG  ASP A  74      -8.275  44.173   7.293  1.00  0.00           C  
ATOM   1143  OD1 ASP A  74      -7.165  43.615   7.169  1.00  0.00           O  
ATOM   1144  OD2 ASP A  74      -8.435  45.253   7.900  1.00  0.00           O  
ATOM   1145  H   ASP A  74      -8.020  41.435   6.762  1.00  0.00           H  
ATOM   1146  HA  ASP A  74     -10.061  42.443   8.445  1.00  0.00           H  
ATOM   1147  HB2 ASP A  74      -9.266  43.275   5.646  1.00  0.00           H  
ATOM   1148  HB3 ASP A  74     -10.317  44.198   6.717  1.00  0.00           H  
ATOM   1149  N   VAL A  75     -11.046  41.137   5.573  1.00  0.00           N  
ATOM   1150  CA  VAL A  75     -12.191  40.557   4.881  1.00  0.00           C  
ATOM   1151  C   VAL A  75     -12.878  39.503   5.742  1.00  0.00           C  
ATOM   1152  O   VAL A  75     -14.032  39.667   6.140  1.00  0.00           O  
ATOM   1153  CB  VAL A  75     -11.773  39.918   3.543  1.00  0.00           C  
ATOM   1154  CG1 VAL A  75     -12.981  39.326   2.833  1.00  0.00           C  
ATOM   1155  CG2 VAL A  75     -11.073  40.941   2.660  1.00  0.00           C  
ATOM   1156  H   VAL A  75     -10.175  41.153   5.125  1.00  0.00           H  
ATOM   1157  HA  VAL A  75     -12.893  41.351   4.672  1.00  0.00           H  
ATOM   1158  HB  VAL A  75     -11.077  39.117   3.751  1.00  0.00           H  
ATOM   1159 HG11 VAL A  75     -13.070  38.280   3.087  1.00  0.00           H  
ATOM   1160 HG12 VAL A  75     -13.873  39.851   3.142  1.00  0.00           H  
ATOM   1161 HG13 VAL A  75     -12.855  39.427   1.764  1.00  0.00           H  
ATOM   1162 HG21 VAL A  75     -10.298  41.434   3.227  1.00  0.00           H  
ATOM   1163 HG22 VAL A  75     -10.634  40.441   1.809  1.00  0.00           H  
ATOM   1164 HG23 VAL A  75     -11.790  41.672   2.318  1.00  0.00           H  
ATOM   1165  N   ARG A  76     -12.161  38.421   6.027  1.00  0.00           N  
ATOM   1166  CA  ARG A  76     -12.702  37.339   6.841  1.00  0.00           C  
ATOM   1167  C   ARG A  76     -13.383  37.888   8.092  1.00  0.00           C  
ATOM   1168  O   ARG A  76     -14.398  37.355   8.544  1.00  0.00           O  
ATOM   1169  CB  ARG A  76     -11.590  36.365   7.238  1.00  0.00           C  
ATOM   1170  CG  ARG A  76     -10.990  35.614   6.061  1.00  0.00           C  
ATOM   1171  CD  ARG A  76      -9.592  35.108   6.378  1.00  0.00           C  
ATOM   1172  NE  ARG A  76      -9.614  33.769   6.960  1.00  0.00           N  
ATOM   1173  CZ  ARG A  76      -9.806  33.533   8.253  1.00  0.00           C  
ATOM   1174  NH1 ARG A  76      -9.994  34.541   9.094  1.00  0.00           N  
ATOM   1175  NH2 ARG A  76      -9.814  32.286   8.707  1.00  0.00           N  
ATOM   1176  H   ARG A  76     -11.247  38.348   5.681  1.00  0.00           H  
ATOM   1177  HA  ARG A  76     -13.435  36.812   6.248  1.00  0.00           H  
ATOM   1178  HB2 ARG A  76     -10.800  36.919   7.724  1.00  0.00           H  
ATOM   1179  HB3 ARG A  76     -11.993  35.643   7.931  1.00  0.00           H  
ATOM   1180  HG2 ARG A  76     -11.621  34.770   5.825  1.00  0.00           H  
ATOM   1181  HG3 ARG A  76     -10.940  36.277   5.210  1.00  0.00           H  
ATOM   1182  HD2 ARG A  76      -9.017  35.083   5.464  1.00  0.00           H  
ATOM   1183  HD3 ARG A  76      -9.128  35.788   7.077  1.00  0.00           H  
ATOM   1184  HE  ARG A  76      -9.478  33.009   6.357  1.00  0.00           H  
ATOM   1185 HH11 ARG A  76      -9.990  35.481   8.755  1.00  0.00           H  
ATOM   1186 HH12 ARG A  76     -10.140  34.360  10.067  1.00  0.00           H  
ATOM   1187 HH21 ARG A  76      -9.673  31.523   8.076  1.00  0.00           H  
ATOM   1188 HH22 ARG A  76      -9.958  32.109   9.680  1.00  0.00           H  
ATOM   1189  N   LEU A  77     -12.818  38.954   8.647  1.00  0.00           N  
ATOM   1190  CA  LEU A  77     -13.369  39.575   9.846  1.00  0.00           C  
ATOM   1191  C   LEU A  77     -14.701  40.253   9.544  1.00  0.00           C  
ATOM   1192  O   LEU A  77     -15.609  40.262  10.377  1.00  0.00           O  
ATOM   1193  CB  LEU A  77     -12.382  40.596  10.415  1.00  0.00           C  
ATOM   1194  CG  LEU A  77     -12.889  41.439  11.586  1.00  0.00           C  
ATOM   1195  CD1 LEU A  77     -12.836  40.642  12.880  1.00  0.00           C  
ATOM   1196  CD2 LEU A  77     -12.077  42.720  11.713  1.00  0.00           C  
ATOM   1197  H   LEU A  77     -12.010  39.334   8.241  1.00  0.00           H  
ATOM   1198  HA  LEU A  77     -13.531  38.798  10.577  1.00  0.00           H  
ATOM   1199  HB2 LEU A  77     -11.507  40.060  10.748  1.00  0.00           H  
ATOM   1200  HB3 LEU A  77     -12.107  41.270   9.616  1.00  0.00           H  
ATOM   1201  HG  LEU A  77     -13.919  41.712  11.406  1.00  0.00           H  
ATOM   1202 HD11 LEU A  77     -13.838  40.485  13.249  1.00  0.00           H  
ATOM   1203 HD12 LEU A  77     -12.262  41.187  13.616  1.00  0.00           H  
ATOM   1204 HD13 LEU A  77     -12.366  39.687  12.695  1.00  0.00           H  
ATOM   1205 HD21 LEU A  77     -12.741  43.548  11.906  1.00  0.00           H  
ATOM   1206 HD22 LEU A  77     -11.539  42.896  10.792  1.00  0.00           H  
ATOM   1207 HD23 LEU A  77     -11.376  42.622  12.528  1.00  0.00           H  
ATOM   1208  N   VAL A  78     -14.814  40.819   8.347  1.00  0.00           N  
ATOM   1209  CA  VAL A  78     -16.038  41.496   7.934  1.00  0.00           C  
ATOM   1210  C   VAL A  78     -17.247  40.578   8.070  1.00  0.00           C  
ATOM   1211  O   VAL A  78     -18.274  40.966   8.629  1.00  0.00           O  
ATOM   1212  CB  VAL A  78     -15.942  41.988   6.476  1.00  0.00           C  
ATOM   1213  CG1 VAL A  78     -17.293  42.495   5.994  1.00  0.00           C  
ATOM   1214  CG2 VAL A  78     -14.880  43.069   6.348  1.00  0.00           C  
ATOM   1215  H   VAL A  78     -14.057  40.779   7.726  1.00  0.00           H  
ATOM   1216  HA  VAL A  78     -16.176  42.357   8.573  1.00  0.00           H  
ATOM   1217  HB  VAL A  78     -15.653  41.153   5.854  1.00  0.00           H  
ATOM   1218 HG11 VAL A  78     -17.627  41.894   5.161  1.00  0.00           H  
ATOM   1219 HG12 VAL A  78     -18.011  42.428   6.799  1.00  0.00           H  
ATOM   1220 HG13 VAL A  78     -17.199  43.524   5.680  1.00  0.00           H  
ATOM   1221 HG21 VAL A  78     -14.810  43.615   7.276  1.00  0.00           H  
ATOM   1222 HG22 VAL A  78     -13.926  42.612   6.126  1.00  0.00           H  
ATOM   1223 HG23 VAL A  78     -15.149  43.745   5.550  1.00  0.00           H  
ATOM   1224  N   PHE A  79     -17.120  39.360   7.556  1.00  0.00           N  
ATOM   1225  CA  PHE A  79     -18.203  38.386   7.621  1.00  0.00           C  
ATOM   1226  C   PHE A  79     -18.321  37.796   9.023  1.00  0.00           C  
ATOM   1227  O   PHE A  79     -19.399  37.371   9.440  1.00  0.00           O  
ATOM   1228  CB  PHE A  79     -17.973  37.267   6.602  1.00  0.00           C  
ATOM   1229  CG  PHE A  79     -17.637  37.769   5.227  1.00  0.00           C  
ATOM   1230  CD1 PHE A  79     -18.495  38.630   4.561  1.00  0.00           C  
ATOM   1231  CD2 PHE A  79     -16.464  37.380   4.601  1.00  0.00           C  
ATOM   1232  CE1 PHE A  79     -18.188  39.092   3.294  1.00  0.00           C  
ATOM   1233  CE2 PHE A  79     -16.152  37.839   3.335  1.00  0.00           C  
ATOM   1234  CZ  PHE A  79     -17.015  38.697   2.681  1.00  0.00           C  
ATOM   1235  H   PHE A  79     -16.277  39.110   7.123  1.00  0.00           H  
ATOM   1236  HA  PHE A  79     -19.122  38.897   7.380  1.00  0.00           H  
ATOM   1237  HB2 PHE A  79     -17.155  36.648   6.938  1.00  0.00           H  
ATOM   1238  HB3 PHE A  79     -18.868  36.667   6.530  1.00  0.00           H  
ATOM   1239  HD1 PHE A  79     -19.412  38.940   5.039  1.00  0.00           H  
ATOM   1240  HD2 PHE A  79     -15.788  36.708   5.112  1.00  0.00           H  
ATOM   1241  HE1 PHE A  79     -18.864  39.763   2.786  1.00  0.00           H  
ATOM   1242  HE2 PHE A  79     -15.234  37.528   2.859  1.00  0.00           H  
ATOM   1243  HZ  PHE A  79     -16.774  39.057   1.693  1.00  0.00           H  
ATOM   1244  N   ASP A  80     -17.206  37.772   9.744  1.00  0.00           N  
ATOM   1245  CA  ASP A  80     -17.183  37.235  11.100  1.00  0.00           C  
ATOM   1246  C   ASP A  80     -18.087  38.048  12.022  1.00  0.00           C  
ATOM   1247  O   ASP A  80     -19.068  37.534  12.555  1.00  0.00           O  
ATOM   1248  CB  ASP A  80     -15.753  37.228  11.644  1.00  0.00           C  
ATOM   1249  CG  ASP A  80     -15.680  36.725  13.073  1.00  0.00           C  
ATOM   1250  OD1 ASP A  80     -16.342  35.713  13.379  1.00  0.00           O  
ATOM   1251  OD2 ASP A  80     -14.962  37.347  13.884  1.00  0.00           O  
ATOM   1252  H   ASP A  80     -16.378  38.127   9.356  1.00  0.00           H  
ATOM   1253  HA  ASP A  80     -17.549  36.221  11.061  1.00  0.00           H  
ATOM   1254  HB2 ASP A  80     -15.143  36.585  11.025  1.00  0.00           H  
ATOM   1255  HB3 ASP A  80     -15.358  38.232  11.614  1.00  0.00           H  
ATOM   1256  N   ASN A  81     -17.747  39.320  12.205  1.00  0.00           N  
ATOM   1257  CA  ASN A  81     -18.526  40.203  13.064  1.00  0.00           C  
ATOM   1258  C   ASN A  81     -20.021  40.020  12.820  1.00  0.00           C  
ATOM   1259  O   ASN A  81     -20.799  39.857  13.760  1.00  0.00           O  
ATOM   1260  CB  ASN A  81     -18.133  41.662  12.822  1.00  0.00           C  
ATOM   1261  CG  ASN A  81     -16.638  41.884  12.932  1.00  0.00           C  
ATOM   1262  OD1 ASN A  81     -15.930  41.109  13.575  1.00  0.00           O  
ATOM   1263  ND2 ASN A  81     -16.150  42.947  12.304  1.00  0.00           N  
ATOM   1264  H   ASN A  81     -16.952  39.673  11.752  1.00  0.00           H  
ATOM   1265  HA  ASN A  81     -18.307  39.947  14.090  1.00  0.00           H  
ATOM   1266  HB2 ASN A  81     -18.449  41.954  11.830  1.00  0.00           H  
ATOM   1267  HB3 ASN A  81     -18.627  42.288  13.550  1.00  0.00           H  
ATOM   1268 HD21 ASN A  81     -16.773  43.521  11.811  1.00  0.00           H  
ATOM   1269 HD22 ASN A  81     -15.185  43.114  12.358  1.00  0.00           H  
ATOM   1270  N   CYS A  82     -20.415  40.048  11.551  1.00  0.00           N  
ATOM   1271  CA  CYS A  82     -21.816  39.885  11.182  1.00  0.00           C  
ATOM   1272  C   CYS A  82     -22.411  38.643  11.839  1.00  0.00           C  
ATOM   1273  O   CYS A  82     -23.428  38.721  12.527  1.00  0.00           O  
ATOM   1274  CB  CYS A  82     -21.958  39.788   9.663  1.00  0.00           C  
ATOM   1275  SG  CYS A  82     -23.487  38.998   9.112  1.00  0.00           S  
ATOM   1276  H   CYS A  82     -19.748  40.181  10.846  1.00  0.00           H  
ATOM   1277  HA  CYS A  82     -22.353  40.753  11.531  1.00  0.00           H  
ATOM   1278  HB2 CYS A  82     -21.933  40.783   9.242  1.00  0.00           H  
ATOM   1279  HB3 CYS A  82     -21.130  39.217   9.267  1.00  0.00           H  
ATOM   1280  HG  CYS A  82     -23.235  37.713   8.915  1.00  0.00           H  
ATOM   1281  N   GLU A  83     -21.770  37.500  11.622  1.00  0.00           N  
ATOM   1282  CA  GLU A  83     -22.237  36.241  12.192  1.00  0.00           C  
ATOM   1283  C   GLU A  83     -22.421  36.363  13.701  1.00  0.00           C  
ATOM   1284  O   GLU A  83     -23.220  35.644  14.302  1.00  0.00           O  
ATOM   1285  CB  GLU A  83     -21.251  35.115  11.875  1.00  0.00           C  
ATOM   1286  CG  GLU A  83     -21.602  33.794  12.540  1.00  0.00           C  
ATOM   1287  CD  GLU A  83     -23.012  33.338  12.223  1.00  0.00           C  
ATOM   1288  OE1 GLU A  83     -23.323  33.160  11.026  1.00  0.00           O  
ATOM   1289  OE2 GLU A  83     -23.806  33.160  13.170  1.00  0.00           O  
ATOM   1290  H   GLU A  83     -20.963  37.502  11.065  1.00  0.00           H  
ATOM   1291  HA  GLU A  83     -23.191  36.009  11.743  1.00  0.00           H  
ATOM   1292  HB2 GLU A  83     -21.228  34.962  10.806  1.00  0.00           H  
ATOM   1293  HB3 GLU A  83     -20.267  35.411  12.208  1.00  0.00           H  
ATOM   1294  HG2 GLU A  83     -20.911  33.039  12.198  1.00  0.00           H  
ATOM   1295  HG3 GLU A  83     -21.508  33.909  13.610  1.00  0.00           H  
ATOM   1296  N   THR A  84     -21.672  37.278  14.310  1.00  0.00           N  
ATOM   1297  CA  THR A  84     -21.750  37.493  15.750  1.00  0.00           C  
ATOM   1298  C   THR A  84     -22.898  38.431  16.105  1.00  0.00           C  
ATOM   1299  O   THR A  84     -23.826  38.050  16.819  1.00  0.00           O  
ATOM   1300  CB  THR A  84     -20.436  38.078  16.303  1.00  0.00           C  
ATOM   1301  OG1 THR A  84     -19.369  37.140  16.123  1.00  0.00           O  
ATOM   1302  CG2 THR A  84     -20.574  38.420  17.779  1.00  0.00           C  
ATOM   1303  H   THR A  84     -21.054  37.820  13.779  1.00  0.00           H  
ATOM   1304  HA  THR A  84     -21.920  36.537  16.222  1.00  0.00           H  
ATOM   1305  HB  THR A  84     -20.206  38.982  15.758  1.00  0.00           H  
ATOM   1306  HG1 THR A  84     -18.631  37.383  16.687  1.00  0.00           H  
ATOM   1307 HG21 THR A  84     -21.593  38.248  18.094  1.00  0.00           H  
ATOM   1308 HG22 THR A  84     -20.319  39.458  17.932  1.00  0.00           H  
ATOM   1309 HG23 THR A  84     -19.909  37.796  18.356  1.00  0.00           H  
ATOM   1310  N   PHE A  85     -22.831  39.658  15.600  1.00  0.00           N  
ATOM   1311  CA  PHE A  85     -23.867  40.651  15.864  1.00  0.00           C  
ATOM   1312  C   PHE A  85     -25.206  40.208  15.282  1.00  0.00           C  
ATOM   1313  O   PHE A  85     -26.211  40.148  15.989  1.00  0.00           O  
ATOM   1314  CB  PHE A  85     -23.465  42.006  15.277  1.00  0.00           C  
ATOM   1315  CG  PHE A  85     -24.273  43.153  15.811  1.00  0.00           C  
ATOM   1316  CD1 PHE A  85     -24.108  43.587  17.117  1.00  0.00           C  
ATOM   1317  CD2 PHE A  85     -25.199  43.799  15.008  1.00  0.00           C  
ATOM   1318  CE1 PHE A  85     -24.850  44.643  17.610  1.00  0.00           C  
ATOM   1319  CE2 PHE A  85     -25.944  44.856  15.496  1.00  0.00           C  
ATOM   1320  CZ  PHE A  85     -25.770  45.277  16.799  1.00  0.00           C  
ATOM   1321  H   PHE A  85     -22.067  39.903  15.037  1.00  0.00           H  
ATOM   1322  HA  PHE A  85     -23.966  40.747  16.934  1.00  0.00           H  
ATOM   1323  HB2 PHE A  85     -22.428  42.196  15.506  1.00  0.00           H  
ATOM   1324  HB3 PHE A  85     -23.594  41.977  14.205  1.00  0.00           H  
ATOM   1325  HD1 PHE A  85     -23.388  43.090  17.752  1.00  0.00           H  
ATOM   1326  HD2 PHE A  85     -25.337  43.470  13.988  1.00  0.00           H  
ATOM   1327  HE1 PHE A  85     -24.711  44.970  18.630  1.00  0.00           H  
ATOM   1328  HE2 PHE A  85     -26.663  45.350  14.860  1.00  0.00           H  
ATOM   1329  HZ  PHE A  85     -26.350  46.104  17.184  1.00  0.00           H  
ATOM   1330  N   ASN A  86     -25.210  39.900  13.990  1.00  0.00           N  
ATOM   1331  CA  ASN A  86     -26.425  39.463  13.311  1.00  0.00           C  
ATOM   1332  C   ASN A  86     -26.675  37.977  13.545  1.00  0.00           C  
ATOM   1333  O   ASN A  86     -25.806  37.263  14.046  1.00  0.00           O  
ATOM   1334  CB  ASN A  86     -26.326  39.745  11.811  1.00  0.00           C  
ATOM   1335  CG  ASN A  86     -26.222  41.227  11.507  1.00  0.00           C  
ATOM   1336  OD1 ASN A  86     -27.233  41.921  11.390  1.00  0.00           O  
ATOM   1337  ND2 ASN A  86     -24.996  41.720  11.376  1.00  0.00           N  
ATOM   1338  H   ASN A  86     -24.376  39.968  13.480  1.00  0.00           H  
ATOM   1339  HA  ASN A  86     -27.252  40.025  13.720  1.00  0.00           H  
ATOM   1340  HB2 ASN A  86     -25.448  39.254  11.417  1.00  0.00           H  
ATOM   1341  HB3 ASN A  86     -27.204  39.356  11.318  1.00  0.00           H  
ATOM   1342 HD21 ASN A  86     -24.237  41.109  11.481  1.00  0.00           H  
ATOM   1343 HD22 ASN A  86     -24.900  42.676  11.179  1.00  0.00           H  
ATOM   1344  N   GLU A  87     -27.868  37.518  13.181  1.00  0.00           N  
ATOM   1345  CA  GLU A  87     -28.231  36.116  13.351  1.00  0.00           C  
ATOM   1346  C   GLU A  87     -28.662  35.500  12.023  1.00  0.00           C  
ATOM   1347  O   GLU A  87     -29.322  36.148  11.210  1.00  0.00           O  
ATOM   1348  CB  GLU A  87     -29.357  35.980  14.378  1.00  0.00           C  
ATOM   1349  CG  GLU A  87     -28.863  35.809  15.805  1.00  0.00           C  
ATOM   1350  CD  GLU A  87     -28.342  34.412  16.078  1.00  0.00           C  
ATOM   1351  OE1 GLU A  87     -27.179  34.133  15.720  1.00  0.00           O  
ATOM   1352  OE2 GLU A  87     -29.097  33.599  16.650  1.00  0.00           O  
ATOM   1353  H   GLU A  87     -28.518  38.137  12.787  1.00  0.00           H  
ATOM   1354  HA  GLU A  87     -27.361  35.590  13.713  1.00  0.00           H  
ATOM   1355  HB2 GLU A  87     -29.975  36.865  14.336  1.00  0.00           H  
ATOM   1356  HB3 GLU A  87     -29.958  35.120  14.122  1.00  0.00           H  
ATOM   1357  HG2 GLU A  87     -28.066  36.515  15.982  1.00  0.00           H  
ATOM   1358  HG3 GLU A  87     -29.680  36.013  16.481  1.00  0.00           H  
ATOM   1359  N   ASP A  88     -28.283  34.245  11.810  1.00  0.00           N  
ATOM   1360  CA  ASP A  88     -28.629  33.540  10.581  1.00  0.00           C  
ATOM   1361  C   ASP A  88     -30.094  33.766  10.219  1.00  0.00           C  
ATOM   1362  O   ASP A  88     -30.472  33.703   9.049  1.00  0.00           O  
ATOM   1363  CB  ASP A  88     -28.353  32.043  10.732  1.00  0.00           C  
ATOM   1364  CG  ASP A  88     -28.986  31.460  11.980  1.00  0.00           C  
ATOM   1365  OD1 ASP A  88     -30.184  31.109  11.930  1.00  0.00           O  
ATOM   1366  OD2 ASP A  88     -28.284  31.356  13.007  1.00  0.00           O  
ATOM   1367  H   ASP A  88     -27.758  33.781  12.495  1.00  0.00           H  
ATOM   1368  HA  ASP A  88     -28.011  33.932   9.788  1.00  0.00           H  
ATOM   1369  HB2 ASP A  88     -28.751  31.522   9.873  1.00  0.00           H  
ATOM   1370  HB3 ASP A  88     -27.286  31.884  10.782  1.00  0.00           H  
ATOM   1371  N   ASP A  89     -30.914  34.028  11.231  1.00  0.00           N  
ATOM   1372  CA  ASP A  89     -32.338  34.263  11.020  1.00  0.00           C  
ATOM   1373  C   ASP A  89     -32.576  35.637  10.402  1.00  0.00           C  
ATOM   1374  O   ASP A  89     -33.455  35.805   9.557  1.00  0.00           O  
ATOM   1375  CB  ASP A  89     -33.098  34.146  12.342  1.00  0.00           C  
ATOM   1376  CG  ASP A  89     -32.744  32.883  13.103  1.00  0.00           C  
ATOM   1377  OD1 ASP A  89     -33.328  31.822  12.797  1.00  0.00           O  
ATOM   1378  OD2 ASP A  89     -31.884  32.955  14.005  1.00  0.00           O  
ATOM   1379  H   ASP A  89     -30.553  34.064  12.142  1.00  0.00           H  
ATOM   1380  HA  ASP A  89     -32.702  33.508  10.339  1.00  0.00           H  
ATOM   1381  HB2 ASP A  89     -32.858  34.997  12.964  1.00  0.00           H  
ATOM   1382  HB3 ASP A  89     -34.159  34.139  12.141  1.00  0.00           H  
ATOM   1383  N   SER A  90     -31.787  36.617  10.831  1.00  0.00           N  
ATOM   1384  CA  SER A  90     -31.915  37.979  10.323  1.00  0.00           C  
ATOM   1385  C   SER A  90     -31.362  38.083   8.905  1.00  0.00           C  
ATOM   1386  O   SER A  90     -30.473  37.327   8.515  1.00  0.00           O  
ATOM   1387  CB  SER A  90     -31.183  38.959  11.241  1.00  0.00           C  
ATOM   1388  OG  SER A  90     -29.793  38.976  10.966  1.00  0.00           O  
ATOM   1389  H   SER A  90     -31.104  36.421  11.506  1.00  0.00           H  
ATOM   1390  HA  SER A  90     -32.965  38.229  10.307  1.00  0.00           H  
ATOM   1391  HB2 SER A  90     -31.579  39.952  11.093  1.00  0.00           H  
ATOM   1392  HB3 SER A  90     -31.330  38.662  12.270  1.00  0.00           H  
ATOM   1393  HG  SER A  90     -29.534  38.138  10.576  1.00  0.00           H  
ATOM   1394  N   ASP A  91     -31.896  39.028   8.138  1.00  0.00           N  
ATOM   1395  CA  ASP A  91     -31.457  39.235   6.763  1.00  0.00           C  
ATOM   1396  C   ASP A  91     -29.934  39.251   6.675  1.00  0.00           C  
ATOM   1397  O   ASP A  91     -29.329  38.381   6.047  1.00  0.00           O  
ATOM   1398  CB  ASP A  91     -32.026  40.544   6.214  1.00  0.00           C  
ATOM   1399  CG  ASP A  91     -33.542  40.567   6.229  1.00  0.00           C  
ATOM   1400  OD1 ASP A  91     -34.154  39.498   6.026  1.00  0.00           O  
ATOM   1401  OD2 ASP A  91     -34.117  41.656   6.442  1.00  0.00           O  
ATOM   1402  H   ASP A  91     -32.602  39.601   8.505  1.00  0.00           H  
ATOM   1403  HA  ASP A  91     -31.830  38.415   6.169  1.00  0.00           H  
ATOM   1404  HB2 ASP A  91     -31.666  41.366   6.816  1.00  0.00           H  
ATOM   1405  HB3 ASP A  91     -31.691  40.676   5.196  1.00  0.00           H  
ATOM   1406  N   ILE A  92     -29.321  40.246   7.308  1.00  0.00           N  
ATOM   1407  CA  ILE A  92     -27.869  40.375   7.302  1.00  0.00           C  
ATOM   1408  C   ILE A  92     -27.198  39.042   7.614  1.00  0.00           C  
ATOM   1409  O   ILE A  92     -26.323  38.587   6.878  1.00  0.00           O  
ATOM   1410  CB  ILE A  92     -27.393  41.428   8.318  1.00  0.00           C  
ATOM   1411  CG1 ILE A  92     -27.747  42.836   7.832  1.00  0.00           C  
ATOM   1412  CG2 ILE A  92     -25.894  41.303   8.548  1.00  0.00           C  
ATOM   1413  CD1 ILE A  92     -27.158  43.936   8.687  1.00  0.00           C  
ATOM   1414  H   ILE A  92     -29.858  40.908   7.791  1.00  0.00           H  
ATOM   1415  HA  ILE A  92     -27.568  40.695   6.314  1.00  0.00           H  
ATOM   1416  HB  ILE A  92     -27.894  41.243   9.257  1.00  0.00           H  
ATOM   1417 HG12 ILE A  92     -27.379  42.965   6.827  1.00  0.00           H  
ATOM   1418 HG13 ILE A  92     -28.821  42.950   7.836  1.00  0.00           H  
ATOM   1419 HG21 ILE A  92     -25.700  40.475   9.213  1.00  0.00           H  
ATOM   1420 HG22 ILE A  92     -25.399  41.129   7.606  1.00  0.00           H  
ATOM   1421 HG23 ILE A  92     -25.520  42.215   8.989  1.00  0.00           H  
ATOM   1422 HD11 ILE A  92     -27.076  43.594   9.708  1.00  0.00           H  
ATOM   1423 HD12 ILE A  92     -26.180  44.199   8.313  1.00  0.00           H  
ATOM   1424 HD13 ILE A  92     -27.803  44.803   8.650  1.00  0.00           H  
ATOM   1425  N   GLY A  93     -27.613  38.419   8.713  1.00  0.00           N  
ATOM   1426  CA  GLY A  93     -27.043  37.143   9.104  1.00  0.00           C  
ATOM   1427  C   GLY A  93     -26.851  36.209   7.926  1.00  0.00           C  
ATOM   1428  O   GLY A  93     -25.727  35.822   7.607  1.00  0.00           O  
ATOM   1429  H   GLY A  93     -28.314  38.829   9.263  1.00  0.00           H  
ATOM   1430  HA2 GLY A  93     -26.085  37.318   9.571  1.00  0.00           H  
ATOM   1431  HA3 GLY A  93     -27.701  36.672   9.819  1.00  0.00           H  
ATOM   1432  N   ARG A  94     -27.953  35.843   7.278  1.00  0.00           N  
ATOM   1433  CA  ARG A  94     -27.901  34.945   6.131  1.00  0.00           C  
ATOM   1434  C   ARG A  94     -26.874  35.426   5.109  1.00  0.00           C  
ATOM   1435  O   ARG A  94     -26.060  34.645   4.617  1.00  0.00           O  
ATOM   1436  CB  ARG A  94     -29.279  34.842   5.475  1.00  0.00           C  
ATOM   1437  CG  ARG A  94     -30.369  34.362   6.419  1.00  0.00           C  
ATOM   1438  CD  ARG A  94     -31.717  34.281   5.719  1.00  0.00           C  
ATOM   1439  NE  ARG A  94     -32.696  33.532   6.503  1.00  0.00           N  
ATOM   1440  CZ  ARG A  94     -33.912  33.228   6.062  1.00  0.00           C  
ATOM   1441  NH1 ARG A  94     -34.295  33.606   4.850  1.00  0.00           N  
ATOM   1442  NH2 ARG A  94     -34.746  32.544   6.834  1.00  0.00           N  
ATOM   1443  H   ARG A  94     -28.820  36.185   7.579  1.00  0.00           H  
ATOM   1444  HA  ARG A  94     -27.607  33.969   6.486  1.00  0.00           H  
ATOM   1445  HB2 ARG A  94     -29.561  35.816   5.101  1.00  0.00           H  
ATOM   1446  HB3 ARG A  94     -29.220  34.151   4.647  1.00  0.00           H  
ATOM   1447  HG2 ARG A  94     -30.107  33.380   6.787  1.00  0.00           H  
ATOM   1448  HG3 ARG A  94     -30.444  35.051   7.247  1.00  0.00           H  
ATOM   1449  HD2 ARG A  94     -32.086  35.283   5.562  1.00  0.00           H  
ATOM   1450  HD3 ARG A  94     -31.583  33.793   4.765  1.00  0.00           H  
ATOM   1451  HE  ARG A  94     -32.433  33.244   7.401  1.00  0.00           H  
ATOM   1452 HH11 ARG A  94     -33.668  34.121   4.266  1.00  0.00           H  
ATOM   1453 HH12 ARG A  94     -35.211  33.374   4.520  1.00  0.00           H  
ATOM   1454 HH21 ARG A  94     -34.460  32.258   7.748  1.00  0.00           H  
ATOM   1455 HH22 ARG A  94     -35.661  32.316   6.502  1.00  0.00           H  
ATOM   1456  N   ALA A  95     -26.920  36.716   4.795  1.00  0.00           N  
ATOM   1457  CA  ALA A  95     -25.993  37.301   3.834  1.00  0.00           C  
ATOM   1458  C   ALA A  95     -24.557  36.888   4.134  1.00  0.00           C  
ATOM   1459  O   ALA A  95     -23.791  36.566   3.227  1.00  0.00           O  
ATOM   1460  CB  ALA A  95     -26.118  38.819   3.836  1.00  0.00           C  
ATOM   1461  H   ALA A  95     -27.591  37.289   5.221  1.00  0.00           H  
ATOM   1462  HA  ALA A  95     -26.262  36.944   2.850  1.00  0.00           H  
ATOM   1463  HB1 ALA A  95     -25.817  39.203   4.800  1.00  0.00           H  
ATOM   1464  HB2 ALA A  95     -25.484  39.233   3.067  1.00  0.00           H  
ATOM   1465  HB3 ALA A  95     -27.145  39.095   3.643  1.00  0.00           H  
ATOM   1466  N   GLY A  96     -24.197  36.900   5.414  1.00  0.00           N  
ATOM   1467  CA  GLY A  96     -22.853  36.524   5.810  1.00  0.00           C  
ATOM   1468  C   GLY A  96     -22.478  35.132   5.343  1.00  0.00           C  
ATOM   1469  O   GLY A  96     -21.342  34.891   4.931  1.00  0.00           O  
ATOM   1470  H   GLY A  96     -24.851  37.165   6.095  1.00  0.00           H  
ATOM   1471  HA2 GLY A  96     -22.154  37.232   5.392  1.00  0.00           H  
ATOM   1472  HA3 GLY A  96     -22.784  36.560   6.888  1.00  0.00           H  
ATOM   1473  N   HIS A  97     -23.434  34.210   5.408  1.00  0.00           N  
ATOM   1474  CA  HIS A  97     -23.198  32.832   4.990  1.00  0.00           C  
ATOM   1475  C   HIS A  97     -22.913  32.762   3.493  1.00  0.00           C  
ATOM   1476  O   HIS A  97     -21.945  32.135   3.064  1.00  0.00           O  
ATOM   1477  CB  HIS A  97     -24.406  31.959   5.333  1.00  0.00           C  
ATOM   1478  CG  HIS A  97     -24.536  31.665   6.795  1.00  0.00           C  
ATOM   1479  ND1 HIS A  97     -23.589  30.958   7.508  1.00  0.00           N  
ATOM   1480  CD2 HIS A  97     -25.507  31.987   7.680  1.00  0.00           C  
ATOM   1481  CE1 HIS A  97     -23.975  30.857   8.767  1.00  0.00           C  
ATOM   1482  NE2 HIS A  97     -25.136  31.473   8.898  1.00  0.00           N  
ATOM   1483  H   HIS A  97     -24.318  34.462   5.746  1.00  0.00           H  
ATOM   1484  HA  HIS A  97     -22.336  32.466   5.526  1.00  0.00           H  
ATOM   1485  HB2 HIS A  97     -25.307  32.461   5.014  1.00  0.00           H  
ATOM   1486  HB3 HIS A  97     -24.320  31.017   4.810  1.00  0.00           H  
ATOM   1487  HD1 HIS A  97     -22.761  30.585   7.144  1.00  0.00           H  
ATOM   1488  HD2 HIS A  97     -26.409  32.545   7.468  1.00  0.00           H  
ATOM   1489  HE1 HIS A  97     -23.434  30.356   9.556  1.00  0.00           H  
ATOM   1490  N   ASN A  98     -23.763  33.408   2.702  1.00  0.00           N  
ATOM   1491  CA  ASN A  98     -23.603  33.417   1.252  1.00  0.00           C  
ATOM   1492  C   ASN A  98     -22.242  33.983   0.858  1.00  0.00           C  
ATOM   1493  O   ASN A  98     -21.502  33.371   0.090  1.00  0.00           O  
ATOM   1494  CB  ASN A  98     -24.718  34.237   0.600  1.00  0.00           C  
ATOM   1495  CG  ASN A  98     -25.976  33.421   0.369  1.00  0.00           C  
ATOM   1496  OD1 ASN A  98     -25.926  32.194   0.280  1.00  0.00           O  
ATOM   1497  ND2 ASN A  98     -27.111  34.102   0.272  1.00  0.00           N  
ATOM   1498  H   ASN A  98     -24.517  33.890   3.102  1.00  0.00           H  
ATOM   1499  HA  ASN A  98     -23.668  32.396   0.905  1.00  0.00           H  
ATOM   1500  HB2 ASN A  98     -24.965  35.070   1.240  1.00  0.00           H  
ATOM   1501  HB3 ASN A  98     -24.372  34.609  -0.353  1.00  0.00           H  
ATOM   1502 HD21 ASN A  98     -27.075  35.079   0.352  1.00  0.00           H  
ATOM   1503 HD22 ASN A  98     -27.940  33.601   0.124  1.00  0.00           H  
ATOM   1504  N   MET A  99     -21.920  35.157   1.392  1.00  0.00           N  
ATOM   1505  CA  MET A  99     -20.648  35.806   1.099  1.00  0.00           C  
ATOM   1506  C   MET A  99     -19.477  34.919   1.510  1.00  0.00           C  
ATOM   1507  O   MET A  99     -18.686  34.489   0.669  1.00  0.00           O  
ATOM   1508  CB  MET A  99     -20.559  37.154   1.818  1.00  0.00           C  
ATOM   1509  CG  MET A  99     -21.613  38.153   1.369  1.00  0.00           C  
ATOM   1510  SD  MET A  99     -21.658  38.356  -0.422  1.00  0.00           S  
ATOM   1511  CE  MET A  99     -19.930  38.674  -0.771  1.00  0.00           C  
ATOM   1512  H   MET A  99     -22.552  35.597   1.998  1.00  0.00           H  
ATOM   1513  HA  MET A  99     -20.599  35.974   0.033  1.00  0.00           H  
ATOM   1514  HB2 MET A  99     -20.679  36.990   2.879  1.00  0.00           H  
ATOM   1515  HB3 MET A  99     -19.586  37.583   1.635  1.00  0.00           H  
ATOM   1516  HG2 MET A  99     -22.581  37.810   1.701  1.00  0.00           H  
ATOM   1517  HG3 MET A  99     -21.397  39.110   1.821  1.00  0.00           H  
ATOM   1518  HE1 MET A  99     -19.449  37.756  -1.075  1.00  0.00           H  
ATOM   1519  HE2 MET A  99     -19.852  39.403  -1.564  1.00  0.00           H  
ATOM   1520  HE3 MET A  99     -19.448  39.056   0.118  1.00  0.00           H  
ATOM   1521  N   ARG A 100     -19.372  34.649   2.807  1.00  0.00           N  
ATOM   1522  CA  ARG A 100     -18.297  33.815   3.329  1.00  0.00           C  
ATOM   1523  C   ARG A 100     -17.977  32.675   2.367  1.00  0.00           C  
ATOM   1524  O   ARG A 100     -16.817  32.445   2.022  1.00  0.00           O  
ATOM   1525  CB  ARG A 100     -18.681  33.248   4.698  1.00  0.00           C  
ATOM   1526  CG  ARG A 100     -17.526  32.577   5.425  1.00  0.00           C  
ATOM   1527  CD  ARG A 100     -18.025  31.600   6.477  1.00  0.00           C  
ATOM   1528  NE  ARG A 100     -18.581  32.284   7.641  1.00  0.00           N  
ATOM   1529  CZ  ARG A 100     -19.453  31.727   8.473  1.00  0.00           C  
ATOM   1530  NH1 ARG A 100     -19.867  30.483   8.271  1.00  0.00           N  
ATOM   1531  NH2 ARG A 100     -19.914  32.414   9.510  1.00  0.00           N  
ATOM   1532  H   ARG A 100     -20.033  35.022   3.428  1.00  0.00           H  
ATOM   1533  HA  ARG A 100     -17.419  34.434   3.439  1.00  0.00           H  
ATOM   1534  HB2 ARG A 100     -19.048  34.054   5.317  1.00  0.00           H  
ATOM   1535  HB3 ARG A 100     -19.466  32.520   4.565  1.00  0.00           H  
ATOM   1536  HG2 ARG A 100     -16.924  32.041   4.706  1.00  0.00           H  
ATOM   1537  HG3 ARG A 100     -16.927  33.336   5.905  1.00  0.00           H  
ATOM   1538  HD2 ARG A 100     -18.790  30.977   6.038  1.00  0.00           H  
ATOM   1539  HD3 ARG A 100     -17.198  30.982   6.795  1.00  0.00           H  
ATOM   1540  HE  ARG A 100     -18.290  33.204   7.808  1.00  0.00           H  
ATOM   1541 HH11 ARG A 100     -19.520  29.962   7.491  1.00  0.00           H  
ATOM   1542 HH12 ARG A 100     -20.523  30.065   8.900  1.00  0.00           H  
ATOM   1543 HH21 ARG A 100     -19.605  33.352   9.666  1.00  0.00           H  
ATOM   1544 HH22 ARG A 100     -20.571  31.994  10.136  1.00  0.00           H  
ATOM   1545  N   LYS A 101     -19.013  31.963   1.937  1.00  0.00           N  
ATOM   1546  CA  LYS A 101     -18.845  30.847   1.013  1.00  0.00           C  
ATOM   1547  C   LYS A 101     -18.180  31.306  -0.281  1.00  0.00           C  
ATOM   1548  O   LYS A 101     -17.303  30.626  -0.814  1.00  0.00           O  
ATOM   1549  CB  LYS A 101     -20.199  30.205   0.703  1.00  0.00           C  
ATOM   1550  CG  LYS A 101     -20.679  29.246   1.779  1.00  0.00           C  
ATOM   1551  CD  LYS A 101     -22.057  28.694   1.459  1.00  0.00           C  
ATOM   1552  CE  LYS A 101     -23.153  29.685   1.822  1.00  0.00           C  
ATOM   1553  NZ  LYS A 101     -24.422  29.398   1.098  1.00  0.00           N  
ATOM   1554  H   LYS A 101     -19.914  32.194   2.247  1.00  0.00           H  
ATOM   1555  HA  LYS A 101     -18.210  30.114   1.489  1.00  0.00           H  
ATOM   1556  HB2 LYS A 101     -20.937  30.987   0.593  1.00  0.00           H  
ATOM   1557  HB3 LYS A 101     -20.121  29.660  -0.227  1.00  0.00           H  
ATOM   1558  HG2 LYS A 101     -19.982  28.424   1.852  1.00  0.00           H  
ATOM   1559  HG3 LYS A 101     -20.721  29.770   2.723  1.00  0.00           H  
ATOM   1560  HD2 LYS A 101     -22.115  28.482   0.402  1.00  0.00           H  
ATOM   1561  HD3 LYS A 101     -22.209  27.781   2.019  1.00  0.00           H  
ATOM   1562  HE2 LYS A 101     -23.333  29.628   2.885  1.00  0.00           H  
ATOM   1563  HE3 LYS A 101     -22.819  30.679   1.567  1.00  0.00           H  
ATOM   1564  HZ1 LYS A 101     -24.479  28.386   0.863  1.00  0.00           H  
ATOM   1565  HZ2 LYS A 101     -24.464  29.949   0.217  1.00  0.00           H  
ATOM   1566  HZ3 LYS A 101     -25.237  29.651   1.692  1.00  0.00           H  
ATOM   1567  N   TYR A 102     -18.602  32.463  -0.779  1.00  0.00           N  
ATOM   1568  CA  TYR A 102     -18.048  33.012  -2.010  1.00  0.00           C  
ATOM   1569  C   TYR A 102     -16.588  33.415  -1.819  1.00  0.00           C  
ATOM   1570  O   TYR A 102     -15.706  32.961  -2.547  1.00  0.00           O  
ATOM   1571  CB  TYR A 102     -18.866  34.221  -2.468  1.00  0.00           C  
ATOM   1572  CG  TYR A 102     -18.289  34.920  -3.677  1.00  0.00           C  
ATOM   1573  CD1 TYR A 102     -17.718  34.195  -4.716  1.00  0.00           C  
ATOM   1574  CD2 TYR A 102     -18.314  36.305  -3.782  1.00  0.00           C  
ATOM   1575  CE1 TYR A 102     -17.189  34.830  -5.824  1.00  0.00           C  
ATOM   1576  CE2 TYR A 102     -17.790  36.948  -4.887  1.00  0.00           C  
ATOM   1577  CZ  TYR A 102     -17.228  36.206  -5.904  1.00  0.00           C  
ATOM   1578  OH  TYR A 102     -16.702  36.842  -7.005  1.00  0.00           O  
ATOM   1579  H   TYR A 102     -19.304  32.959  -0.307  1.00  0.00           H  
ATOM   1580  HA  TYR A 102     -18.101  32.246  -2.769  1.00  0.00           H  
ATOM   1581  HB2 TYR A 102     -19.865  33.897  -2.716  1.00  0.00           H  
ATOM   1582  HB3 TYR A 102     -18.917  34.939  -1.662  1.00  0.00           H  
ATOM   1583  HD1 TYR A 102     -17.690  33.116  -4.650  1.00  0.00           H  
ATOM   1584  HD2 TYR A 102     -18.755  36.884  -2.983  1.00  0.00           H  
ATOM   1585  HE1 TYR A 102     -16.749  34.248  -6.621  1.00  0.00           H  
ATOM   1586  HE2 TYR A 102     -17.819  38.026  -4.950  1.00  0.00           H  
ATOM   1587  HH  TYR A 102     -16.429  37.729  -6.762  1.00  0.00           H  
ATOM   1588  N   PHE A 103     -16.343  34.272  -0.832  1.00  0.00           N  
ATOM   1589  CA  PHE A 103     -14.991  34.738  -0.544  1.00  0.00           C  
ATOM   1590  C   PHE A 103     -13.984  33.598  -0.670  1.00  0.00           C  
ATOM   1591  O   PHE A 103     -12.904  33.770  -1.234  1.00  0.00           O  
ATOM   1592  CB  PHE A 103     -14.925  35.339   0.862  1.00  0.00           C  
ATOM   1593  CG  PHE A 103     -13.539  35.742   1.276  1.00  0.00           C  
ATOM   1594  CD1 PHE A 103     -12.838  36.698   0.560  1.00  0.00           C  
ATOM   1595  CD2 PHE A 103     -12.938  35.165   2.383  1.00  0.00           C  
ATOM   1596  CE1 PHE A 103     -11.563  37.073   0.939  1.00  0.00           C  
ATOM   1597  CE2 PHE A 103     -11.662  35.536   2.767  1.00  0.00           C  
ATOM   1598  CZ  PHE A 103     -10.974  36.490   2.044  1.00  0.00           C  
ATOM   1599  H   PHE A 103     -17.088  34.599  -0.286  1.00  0.00           H  
ATOM   1600  HA  PHE A 103     -14.744  35.502  -1.265  1.00  0.00           H  
ATOM   1601  HB2 PHE A 103     -15.552  36.216   0.900  1.00  0.00           H  
ATOM   1602  HB3 PHE A 103     -15.287  34.611   1.573  1.00  0.00           H  
ATOM   1603  HD1 PHE A 103     -13.299  37.155  -0.306  1.00  0.00           H  
ATOM   1604  HD2 PHE A 103     -13.474  34.418   2.949  1.00  0.00           H  
ATOM   1605  HE1 PHE A 103     -11.028  37.819   0.370  1.00  0.00           H  
ATOM   1606  HE2 PHE A 103     -11.204  35.079   3.631  1.00  0.00           H  
ATOM   1607  HZ  PHE A 103      -9.978  36.781   2.342  1.00  0.00           H  
ATOM   1608  N   GLU A 104     -14.348  32.434  -0.140  1.00  0.00           N  
ATOM   1609  CA  GLU A 104     -13.476  31.266  -0.192  1.00  0.00           C  
ATOM   1610  C   GLU A 104     -13.382  30.720  -1.614  1.00  0.00           C  
ATOM   1611  O   GLU A 104     -12.324  30.772  -2.243  1.00  0.00           O  
ATOM   1612  CB  GLU A 104     -13.989  30.177   0.751  1.00  0.00           C  
ATOM   1613  CG  GLU A 104     -14.087  30.623   2.200  1.00  0.00           C  
ATOM   1614  CD  GLU A 104     -15.050  29.774   3.008  1.00  0.00           C  
ATOM   1615  OE1 GLU A 104     -14.836  28.546   3.087  1.00  0.00           O  
ATOM   1616  OE2 GLU A 104     -16.018  30.338   3.560  1.00  0.00           O  
ATOM   1617  H   GLU A 104     -15.222  32.359   0.296  1.00  0.00           H  
ATOM   1618  HA  GLU A 104     -12.492  31.573   0.128  1.00  0.00           H  
ATOM   1619  HB2 GLU A 104     -14.971  29.867   0.423  1.00  0.00           H  
ATOM   1620  HB3 GLU A 104     -13.319  29.331   0.702  1.00  0.00           H  
ATOM   1621  HG2 GLU A 104     -13.109  30.556   2.651  1.00  0.00           H  
ATOM   1622  HG3 GLU A 104     -14.425  31.648   2.226  1.00  0.00           H  
ATOM   1623  N   LYS A 105     -14.496  30.197  -2.116  1.00  0.00           N  
ATOM   1624  CA  LYS A 105     -14.541  29.641  -3.463  1.00  0.00           C  
ATOM   1625  C   LYS A 105     -13.926  30.607  -4.470  1.00  0.00           C  
ATOM   1626  O   LYS A 105     -13.496  30.202  -5.551  1.00  0.00           O  
ATOM   1627  CB  LYS A 105     -15.987  29.327  -3.858  1.00  0.00           C  
ATOM   1628  CG  LYS A 105     -16.464  27.966  -3.383  1.00  0.00           C  
ATOM   1629  CD  LYS A 105     -15.712  26.839  -4.072  1.00  0.00           C  
ATOM   1630  CE  LYS A 105     -16.421  25.506  -3.893  1.00  0.00           C  
ATOM   1631  NZ  LYS A 105     -16.049  24.533  -4.959  1.00  0.00           N  
ATOM   1632  H   LYS A 105     -15.307  30.184  -1.565  1.00  0.00           H  
ATOM   1633  HA  LYS A 105     -13.970  28.726  -3.464  1.00  0.00           H  
ATOM   1634  HB2 LYS A 105     -16.634  30.081  -3.436  1.00  0.00           H  
ATOM   1635  HB3 LYS A 105     -16.067  29.359  -4.936  1.00  0.00           H  
ATOM   1636  HG2 LYS A 105     -16.308  27.890  -2.318  1.00  0.00           H  
ATOM   1637  HG3 LYS A 105     -17.519  27.870  -3.602  1.00  0.00           H  
ATOM   1638  HD2 LYS A 105     -15.642  27.058  -5.128  1.00  0.00           H  
ATOM   1639  HD3 LYS A 105     -14.720  26.770  -3.650  1.00  0.00           H  
ATOM   1640  HE2 LYS A 105     -16.149  25.095  -2.933  1.00  0.00           H  
ATOM   1641  HE3 LYS A 105     -17.487  25.672  -3.925  1.00  0.00           H  
ATOM   1642  HZ1 LYS A 105     -16.452  24.831  -5.870  1.00  0.00           H  
ATOM   1643  HZ2 LYS A 105     -16.416  23.589  -4.724  1.00  0.00           H  
ATOM   1644  HZ3 LYS A 105     -15.015  24.480  -5.050  1.00  0.00           H  
ATOM   1645  N   LYS A 106     -13.885  31.885  -4.110  1.00  0.00           N  
ATOM   1646  CA  LYS A 106     -13.319  32.908  -4.981  1.00  0.00           C  
ATOM   1647  C   LYS A 106     -11.835  33.110  -4.690  1.00  0.00           C  
ATOM   1648  O   LYS A 106     -11.024  33.225  -5.609  1.00  0.00           O  
ATOM   1649  CB  LYS A 106     -14.069  34.231  -4.802  1.00  0.00           C  
ATOM   1650  CG  LYS A 106     -13.560  35.345  -5.700  1.00  0.00           C  
ATOM   1651  CD  LYS A 106     -13.899  35.085  -7.158  1.00  0.00           C  
ATOM   1652  CE  LYS A 106     -13.085  35.973  -8.087  1.00  0.00           C  
ATOM   1653  NZ  LYS A 106     -13.680  37.333  -8.214  1.00  0.00           N  
ATOM   1654  H   LYS A 106     -14.243  32.146  -3.236  1.00  0.00           H  
ATOM   1655  HA  LYS A 106     -13.432  32.575  -6.001  1.00  0.00           H  
ATOM   1656  HB2 LYS A 106     -15.115  34.069  -5.021  1.00  0.00           H  
ATOM   1657  HB3 LYS A 106     -13.970  34.551  -3.775  1.00  0.00           H  
ATOM   1658  HG2 LYS A 106     -14.016  36.276  -5.396  1.00  0.00           H  
ATOM   1659  HG3 LYS A 106     -12.487  35.416  -5.596  1.00  0.00           H  
ATOM   1660  HD2 LYS A 106     -13.686  34.052  -7.390  1.00  0.00           H  
ATOM   1661  HD3 LYS A 106     -14.950  35.281  -7.315  1.00  0.00           H  
ATOM   1662  HE2 LYS A 106     -12.085  36.063  -7.693  1.00  0.00           H  
ATOM   1663  HE3 LYS A 106     -13.047  35.513  -9.063  1.00  0.00           H  
ATOM   1664  HZ1 LYS A 106     -13.100  37.917  -8.852  1.00  0.00           H  
ATOM   1665  HZ2 LYS A 106     -13.721  37.794  -7.284  1.00  0.00           H  
ATOM   1666  HZ3 LYS A 106     -14.643  37.268  -8.601  1.00  0.00           H  
ATOM   1667  N   TRP A 107     -11.489  33.153  -3.409  1.00  0.00           N  
ATOM   1668  CA  TRP A 107     -10.102  33.340  -2.999  1.00  0.00           C  
ATOM   1669  C   TRP A 107      -9.249  32.142  -3.400  1.00  0.00           C  
ATOM   1670  O   TRP A 107      -8.224  32.291  -4.067  1.00  0.00           O  
ATOM   1671  CB  TRP A 107     -10.020  33.555  -1.486  1.00  0.00           C  
ATOM   1672  CG  TRP A 107      -8.623  33.778  -0.993  1.00  0.00           C  
ATOM   1673  CD1 TRP A 107      -7.701  32.820  -0.681  1.00  0.00           C  
ATOM   1674  CD2 TRP A 107      -7.991  35.040  -0.751  1.00  0.00           C  
ATOM   1675  NE1 TRP A 107      -6.533  33.411  -0.262  1.00  0.00           N  
ATOM   1676  CE2 TRP A 107      -6.685  34.772  -0.296  1.00  0.00           C  
ATOM   1677  CE3 TRP A 107      -8.401  36.371  -0.877  1.00  0.00           C  
ATOM   1678  CZ2 TRP A 107      -5.789  35.785   0.034  1.00  0.00           C  
ATOM   1679  CZ3 TRP A 107      -7.510  37.375  -0.549  1.00  0.00           C  
ATOM   1680  CH2 TRP A 107      -6.216  37.078  -0.099  1.00  0.00           C  
ATOM   1681  H   TRP A 107     -12.181  33.056  -2.722  1.00  0.00           H  
ATOM   1682  HA  TRP A 107      -9.725  34.220  -3.499  1.00  0.00           H  
ATOM   1683  HB2 TRP A 107     -10.610  34.418  -1.219  1.00  0.00           H  
ATOM   1684  HB3 TRP A 107     -10.417  32.683  -0.985  1.00  0.00           H  
ATOM   1685  HD1 TRP A 107      -7.877  31.758  -0.758  1.00  0.00           H  
ATOM   1686  HE1 TRP A 107      -5.723  32.934   0.017  1.00  0.00           H  
ATOM   1687  HE3 TRP A 107      -9.393  36.619  -1.222  1.00  0.00           H  
ATOM   1688  HZ2 TRP A 107      -4.789  35.572   0.382  1.00  0.00           H  
ATOM   1689  HZ3 TRP A 107      -7.809  38.409  -0.640  1.00  0.00           H  
ATOM   1690  HH2 TRP A 107      -5.555  37.895   0.146  1.00  0.00           H  
ATOM   1691  N   THR A 108      -9.678  30.951  -2.993  1.00  0.00           N  
ATOM   1692  CA  THR A 108      -8.952  29.727  -3.310  1.00  0.00           C  
ATOM   1693  C   THR A 108      -8.642  29.643  -4.800  1.00  0.00           C  
ATOM   1694  O   THR A 108      -7.550  29.234  -5.195  1.00  0.00           O  
ATOM   1695  CB  THR A 108      -9.750  28.478  -2.892  1.00  0.00           C  
ATOM   1696  OG1 THR A 108      -8.909  27.320  -2.947  1.00  0.00           O  
ATOM   1697  CG2 THR A 108     -10.957  28.278  -3.796  1.00  0.00           C  
ATOM   1698  H   THR A 108     -10.501  30.897  -2.465  1.00  0.00           H  
ATOM   1699  HA  THR A 108      -8.024  29.737  -2.759  1.00  0.00           H  
ATOM   1700  HB  THR A 108     -10.097  28.614  -1.877  1.00  0.00           H  
ATOM   1701  HG1 THR A 108      -9.361  26.577  -2.538  1.00  0.00           H  
ATOM   1702 HG21 THR A 108     -10.634  27.873  -4.744  1.00  0.00           H  
ATOM   1703 HG22 THR A 108     -11.447  29.226  -3.956  1.00  0.00           H  
ATOM   1704 HG23 THR A 108     -11.646  27.590  -3.328  1.00  0.00           H  
ATOM   1705  N   ASP A 109      -9.609  30.032  -5.625  1.00  0.00           N  
ATOM   1706  CA  ASP A 109      -9.438  30.002  -7.072  1.00  0.00           C  
ATOM   1707  C   ASP A 109      -8.452  31.074  -7.525  1.00  0.00           C  
ATOM   1708  O   ASP A 109      -7.588  30.822  -8.367  1.00  0.00           O  
ATOM   1709  CB  ASP A 109     -10.784  30.202  -7.770  1.00  0.00           C  
ATOM   1710  CG  ASP A 109     -10.800  29.629  -9.173  1.00  0.00           C  
ATOM   1711  OD1 ASP A 109     -10.999  28.404  -9.312  1.00  0.00           O  
ATOM   1712  OD2 ASP A 109     -10.612  30.405 -10.134  1.00  0.00           O  
ATOM   1713  H   ASP A 109     -10.459  30.348  -5.249  1.00  0.00           H  
ATOM   1714  HA  ASP A 109      -9.046  29.033  -7.340  1.00  0.00           H  
ATOM   1715  HB2 ASP A 109     -11.558  29.715  -7.194  1.00  0.00           H  
ATOM   1716  HB3 ASP A 109     -10.998  31.259  -7.830  1.00  0.00           H  
ATOM   1717  N   THR A 110      -8.587  32.270  -6.963  1.00  0.00           N  
ATOM   1718  CA  THR A 110      -7.710  33.381  -7.310  1.00  0.00           C  
ATOM   1719  C   THR A 110      -6.244  32.970  -7.232  1.00  0.00           C  
ATOM   1720  O   THR A 110      -5.503  33.087  -8.209  1.00  0.00           O  
ATOM   1721  CB  THR A 110      -7.941  34.591  -6.385  1.00  0.00           C  
ATOM   1722  OG1 THR A 110      -9.271  35.091  -6.557  1.00  0.00           O  
ATOM   1723  CG2 THR A 110      -6.936  35.696  -6.677  1.00  0.00           C  
ATOM   1724  H   THR A 110      -9.294  32.409  -6.299  1.00  0.00           H  
ATOM   1725  HA  THR A 110      -7.936  33.681  -8.323  1.00  0.00           H  
ATOM   1726  HB  THR A 110      -7.815  34.271  -5.360  1.00  0.00           H  
ATOM   1727  HG1 THR A 110      -9.348  35.951  -6.134  1.00  0.00           H  
ATOM   1728 HG21 THR A 110      -6.359  35.902  -5.788  1.00  0.00           H  
ATOM   1729 HG22 THR A 110      -7.462  36.589  -6.980  1.00  0.00           H  
ATOM   1730 HG23 THR A 110      -6.276  35.380  -7.469  1.00  0.00           H  
ATOM   1731  N   PHE A 111      -5.831  32.486  -6.065  1.00  0.00           N  
ATOM   1732  CA  PHE A 111      -4.453  32.057  -5.860  1.00  0.00           C  
ATOM   1733  C   PHE A 111      -4.347  30.535  -5.887  1.00  0.00           C  
ATOM   1734  O   PHE A 111      -3.757  29.957  -6.801  1.00  0.00           O  
ATOM   1735  CB  PHE A 111      -3.922  32.592  -4.529  1.00  0.00           C  
ATOM   1736  CG  PHE A 111      -3.966  34.090  -4.425  1.00  0.00           C  
ATOM   1737  CD1 PHE A 111      -2.932  34.864  -4.925  1.00  0.00           C  
ATOM   1738  CD2 PHE A 111      -5.043  34.724  -3.827  1.00  0.00           C  
ATOM   1739  CE1 PHE A 111      -2.969  36.242  -4.831  1.00  0.00           C  
ATOM   1740  CE2 PHE A 111      -5.088  36.102  -3.730  1.00  0.00           C  
ATOM   1741  CZ  PHE A 111      -4.048  36.862  -4.232  1.00  0.00           C  
ATOM   1742  H   PHE A 111      -6.469  32.417  -5.324  1.00  0.00           H  
ATOM   1743  HA  PHE A 111      -3.858  32.461  -6.664  1.00  0.00           H  
ATOM   1744  HB2 PHE A 111      -4.516  32.186  -3.724  1.00  0.00           H  
ATOM   1745  HB3 PHE A 111      -2.896  32.279  -4.407  1.00  0.00           H  
ATOM   1746  HD1 PHE A 111      -2.086  34.379  -5.393  1.00  0.00           H  
ATOM   1747  HD2 PHE A 111      -5.856  34.132  -3.433  1.00  0.00           H  
ATOM   1748  HE1 PHE A 111      -2.155  36.832  -5.224  1.00  0.00           H  
ATOM   1749  HE2 PHE A 111      -5.932  36.585  -3.261  1.00  0.00           H  
ATOM   1750  HZ  PHE A 111      -4.080  37.939  -4.158  1.00  0.00           H  
ATOM   1751  N   LYS A 112      -4.924  29.890  -4.878  1.00  0.00           N  
ATOM   1752  CA  LYS A 112      -4.897  28.435  -4.785  1.00  0.00           C  
ATOM   1753  C   LYS A 112      -5.536  27.798  -6.015  1.00  0.00           C  
ATOM   1754  O   LYS A 112      -5.932  26.633  -5.987  1.00  0.00           O  
ATOM   1755  CB  LYS A 112      -5.624  27.971  -3.521  1.00  0.00           C  
ATOM   1756  CG  LYS A 112      -4.723  27.869  -2.303  1.00  0.00           C  
ATOM   1757  CD  LYS A 112      -4.341  29.242  -1.774  1.00  0.00           C  
ATOM   1758  CE  LYS A 112      -3.075  29.763  -2.438  1.00  0.00           C  
ATOM   1759  NZ  LYS A 112      -1.848  29.207  -1.804  1.00  0.00           N  
ATOM   1760  H   LYS A 112      -5.380  30.405  -4.179  1.00  0.00           H  
ATOM   1761  HA  LYS A 112      -3.864  28.125  -4.730  1.00  0.00           H  
ATOM   1762  HB2 LYS A 112      -6.416  28.671  -3.299  1.00  0.00           H  
ATOM   1763  HB3 LYS A 112      -6.057  26.998  -3.705  1.00  0.00           H  
ATOM   1764  HG2 LYS A 112      -5.242  27.327  -1.526  1.00  0.00           H  
ATOM   1765  HG3 LYS A 112      -3.823  27.336  -2.576  1.00  0.00           H  
ATOM   1766  HD2 LYS A 112      -5.148  29.932  -1.972  1.00  0.00           H  
ATOM   1767  HD3 LYS A 112      -4.177  29.175  -0.709  1.00  0.00           H  
ATOM   1768  HE2 LYS A 112      -3.090  29.483  -3.481  1.00  0.00           H  
ATOM   1769  HE3 LYS A 112      -3.058  30.840  -2.354  1.00  0.00           H  
ATOM   1770  HZ1 LYS A 112      -1.138  28.990  -2.532  1.00  0.00           H  
ATOM   1771  HZ2 LYS A 112      -2.077  28.334  -1.288  1.00  0.00           H  
ATOM   1772  HZ3 LYS A 112      -1.446  29.896  -1.138  1.00  0.00           H  
TER    1773      LYS A 112                                                      
END
MOLECULE T0432.pdb
ATOM      1  N   SER     1      12.703  45.910  -3.320  1.00 50.93           N
ATOM      2  CA  SER     1      13.109  46.216  -4.712  1.00 47.13           C
ATOM      4  CB  SER     1      13.709  44.967  -5.358  1.00 53.53           C
ATOM      7  OG  SER     1      12.759  43.911  -5.430  1.00 42.48           O
ATOM      9  C   SER     1      11.931  46.715  -5.566  1.00 52.43           C
ATOM     10  O   SER     1      10.768  46.719  -5.114  1.00 45.72           O
ATOM     14  N   MET     2      12.255  47.142  -6.791  1.00 48.01           N
ATOM     15  CA  MET     2      11.257  47.418  -7.836  1.00 53.09           C
ATOM     17  CB  MET     2      11.927  47.928  -9.120  1.00 51.71           C
ATOM     23  C   MET     2      10.424  46.169  -8.153  1.00 49.18           C
ATOM     24  O   MET     2       9.206  46.267  -8.286  1.00 51.00           O
ATOM     26  N   GLN     3      11.078  45.011  -8.268  1.00 44.90           N
ATOM     27  CA  GLN     3      10.368  43.738  -8.433  1.00 49.87           C
ATOM     29  CB  GLN     3      11.334  42.538  -8.524  1.00 49.44           C
ATOM     32  CG  GLN     3      11.990  42.326  -9.886  1.00 56.96           C
ATOM     38  C   GLN     3       9.361  43.512  -7.283  1.00 43.65           C
ATOM     39  O   GLN     3       8.242  43.071  -7.521  1.00 37.83           O
ATOM     41  N   GLU     4       9.764  43.812  -6.049  1.00 34.49           N
ATOM     42  CA  GLU     4       8.896  43.571  -4.909  1.00 28.57           C
ATOM     44  CB  GLU     4       9.695  43.588  -3.619  1.00 30.35           C
ATOM     47  CG  GLU     4      10.564  42.317  -3.478  1.00 32.03           C
ATOM     50  CD  GLU     4      11.497  42.362  -2.284  1.00 34.53           C
ATOM     51  OE1 GLU     4      11.564  43.415  -1.624  1.00 39.92           O
ATOM     52  OE2 GLU     4      12.167  41.335  -2.002  1.00 35.71           O
ATOM     53  C   GLU     4       7.708  44.529  -4.871  1.00 25.78           C
ATOM     54  O   GLU     4       6.586  44.106  -4.548  1.00 21.89           O
ATOM     56  N   GLU     5       7.958  45.807  -5.172  1.00 27.67           N
ATOM     57  CA  GLU     5       6.900  46.803  -5.275  1.00 29.37           C
ATOM     59  CB  GLU     5       7.492  48.200  -5.504  1.00 32.93           C
ATOM     62  CG  GLU     5       8.329  48.698  -4.321  1.00 36.17           C
ATOM     68  C   GLU     5       5.841  46.464  -6.357  1.00 26.28           C
ATOM     69  O   GLU     5       4.652  46.729  -6.168  1.00 24.25           O
ATOM     71  N   ASP     6       6.276  45.882  -7.472  1.00 23.77           N
ATOM     72  CA  ASP     6       5.354  45.408  -8.499  1.00 26.67           C
ATOM     74  CB  ASP     6       6.099  44.978  -9.756  1.00 25.76           C
ATOM     77  CG  ASP     6       6.749  46.165 -10.526  1.00 24.96           C
ATOM     78  OD1 ASP     6       6.374  47.338 -10.325  1.00 41.80           O
ATOM     79  OD2 ASP     6       7.653  45.870 -11.317  1.00 39.42           O
ATOM     80  C   ASP     6       4.501  44.208  -7.998  1.00 20.23           C
ATOM     81  O   ASP     6       3.358  44.093  -8.388  1.00 20.47           O
ATOM     83  N   THR     7       5.093  43.319  -7.201  1.00 22.25           N
ATOM     84  CA  THR     7       4.384  42.184  -6.606  1.00 22.70           C
ATOM     86  CB  THR     7       5.332  41.245  -5.780  1.00 22.94           C
ATOM     88  OG1 THR     7       6.367  40.712  -6.630  1.00 26.30           O
ATOM     90  CG2 THR     7       4.556  40.047  -5.132  1.00 16.87           C
ATOM     94  C   THR     7       3.250  42.693  -5.726  1.00 21.27           C
ATOM     95  O   THR     7       2.114  42.227  -5.839  1.00 18.76           O
ATOM     97  N   PHE     8       3.574  43.615  -4.823  1.00 19.23           N
ATOM     98  CA  PHE     8       2.558  44.181  -3.944  1.00 19.60           C
ATOM    100  CB  PHE     8       3.176  45.001  -2.822  1.00 22.71           C
ATOM    103  CG  PHE     8       3.951  44.177  -1.823  1.00 23.51           C
ATOM    104  CD1 PHE     8       3.439  42.949  -1.346  1.00 28.77           C
ATOM    106  CE1 PHE     8       4.152  42.173  -0.434  1.00 28.06           C
ATOM    108  CZ  PHE     8       5.373  42.635   0.031  1.00 28.78           C
ATOM    110  CE2 PHE     8       5.884  43.835  -0.423  1.00 30.30           C
ATOM    112  CD2 PHE     8       5.169  44.616  -1.353  1.00 28.10           C
ATOM    114  C   PHE     8       1.496  44.993  -4.689  1.00 22.06           C
ATOM    115  O   PHE     8       0.320  44.959  -4.316  1.00 17.45           O
ATOM    117  N   ARG     9       1.904  45.735  -5.712  1.00 20.32           N
ATOM    118  CA  ARG     9       0.939  46.442  -6.556  1.00 18.47           C
ATOM    120  CB  ARG     9       1.639  47.343  -7.542  1.00 20.96           C
ATOM    123  CG  ARG     9       0.718  48.210  -8.324  1.00 30.12           C
ATOM    126  CD  ARG     9       1.462  49.336  -8.973  1.00 33.72           C
ATOM    129  NE  ARG     9       0.560  50.358  -9.495  1.00 49.38           N
ATOM    131  CZ  ARG     9      -0.009  50.371 -10.710  1.00 50.88           C
ATOM    132  NH1 ARG     9       0.198  49.411 -11.626  1.00 36.54           N
ATOM    135  NH2 ARG     9      -0.779  51.400 -11.024  1.00 35.58           N
ATOM    138  C   ARG     9      -0.005  45.464  -7.267  1.00 18.25           C
ATOM    139  O   ARG     9      -1.217  45.710  -7.282  1.00 15.91           O
ATOM    141  N   GLU    10       0.522  44.363  -7.832  1.00 15.31           N
ATOM    142  CA  GLU    10      -0.351  43.339  -8.413  1.00 19.50           C
ATOM    144  CB  GLU    10       0.439  42.219  -9.076  1.00 21.24           C
ATOM    147  CG  GLU    10      -0.467  41.097  -9.566  1.00 23.10           C
ATOM    150  CD  GLU    10       0.189  40.117 -10.508  1.00 33.77           C
ATOM    151  OE1 GLU    10      -0.487  39.118 -10.845  1.00 26.89           O
ATOM    152  OE2 GLU    10       1.358  40.328 -10.890  1.00 26.18           O
ATOM    153  C   GLU    10      -1.355  42.768  -7.382  1.00 23.48           C
ATOM    154  O   GLU    10      -2.548  42.617  -7.692  1.00 16.96           O
ATOM    156  N   LEU    11      -0.871  42.447  -6.176  1.00 22.33           N
ATOM    157  CA  LEU    11      -1.756  42.020  -5.079  1.00 17.97           C
ATOM    159  CB  LEU    11      -0.969  41.736  -3.779  1.00 21.21           C
ATOM    162  CG  LEU    11      -1.851  41.320  -2.564  1.00 18.71           C
ATOM    164  CD1 LEU    11      -2.569  39.975  -2.827  1.00 16.49           C
ATOM    168  CD2 LEU    11      -1.052  41.296  -1.292  1.00 17.23           C
ATOM    172  C   LEU    11      -2.872  43.029  -4.826  1.00 18.50           C
ATOM    173  O   LEU    11      -4.018  42.652  -4.757  1.00 17.18           O
ATOM    175  N   ARG    12      -2.554  44.316  -4.710  1.00 16.81           N
ATOM    176  CA  ARG    12      -3.587  45.342  -4.508  1.00 18.76           C
ATOM    178  CB  ARG    12      -2.975  46.756  -4.299  1.00 15.68           C
ATOM    181  CG  ARG    12      -2.092  46.846  -3.060  1.00 20.36           C
ATOM    184  CD  ARG    12      -1.799  48.294  -2.715  1.00 24.48           C
ATOM    187  NE  ARG    12      -0.943  48.950  -3.696  1.00 19.83           N
ATOM    189  CZ  ARG    12       0.393  48.875  -3.740  1.00 17.58           C
ATOM    190  NH1 ARG    12       1.084  48.164  -2.878  1.00 25.76           N
ATOM    193  NH2 ARG    12       1.034  49.530  -4.686  1.00 24.92           N
ATOM    196  C   ARG    12      -4.628  45.388  -5.624  1.00 16.66           C
ATOM    197  O   ARG    12      -5.828  45.475  -5.353  1.00 16.08           O
ATOM    199  N   ILE    13      -4.164  45.301  -6.864  1.00 19.21           N
ATOM    200  CA  ILE    13      -5.044  45.236  -8.043  1.00 17.95           C
ATOM    202  CB  ILE    13      -4.224  45.209  -9.367  1.00 17.89           C
ATOM    204  CG1 ILE    13      -3.478  46.541  -9.577  1.00 23.66           C
ATOM    207  CD1 ILE    13      -2.498  46.500 -10.707  1.00 27.76           C
ATOM    211  CG2 ILE    13      -5.101  44.894 -10.587  1.00 24.21           C
ATOM    215  C   ILE    13      -5.997  44.011  -7.963  1.00 14.86           C
ATOM    216  O   ILE    13      -7.218  44.155  -8.154  1.00 16.18           O
ATOM    218  N   PHE    14      -5.438  42.857  -7.652  1.00 16.54           N
ATOM    219  CA  PHE    14      -6.211  41.642  -7.441  1.00 15.48           C
ATOM    221  CB  PHE    14      -5.313  40.456  -7.134  1.00 18.04           C
ATOM    224  CG  PHE    14      -6.074  39.237  -6.793  1.00 18.02           C
ATOM    225  CD1 PHE    14      -6.678  38.465  -7.790  1.00 26.02           C
ATOM    227  CE1 PHE    14      -7.424  37.332  -7.462  1.00 20.26           C
ATOM    229  CZ  PHE    14      -7.559  36.973  -6.149  1.00 20.14           C
ATOM    231  CE2 PHE    14      -6.970  37.746  -5.142  1.00 23.20           C
ATOM    233  CD2 PHE    14      -6.239  38.861  -5.465  1.00 22.05           C
ATOM    235  C   PHE    14      -7.252  41.824  -6.314  1.00 17.60           C
ATOM    236  O   PHE    14      -8.431  41.558  -6.507  1.00 16.66           O
ATOM    238  N   LEU    15      -6.807  42.332  -5.166  1.00 15.25           N
ATOM    239  CA  LEU    15      -7.701  42.555  -4.016  1.00 15.48           C
ATOM    241  CB  LEU    15      -6.921  42.915  -2.741  1.00 17.25           C
ATOM    244  CG  LEU    15      -5.972  41.845  -2.195  1.00 20.45           C
ATOM    246  CD1 LEU    15      -5.225  42.342  -0.920  1.00 15.28           C
ATOM    250  CD2 LEU    15      -6.687  40.491  -1.929  1.00 17.37           C
ATOM    254  C   LEU    15      -8.826  43.550  -4.269  1.00 16.03           C
ATOM    255  O   LEU    15      -9.961  43.320  -3.815  1.00 15.92           O
ATOM    257  N   ARG    16      -8.542  44.625  -4.980  1.00 16.38           N
ATOM    258  CA  ARG    16      -9.590  45.593  -5.363  1.00 13.95           C
ATOM    260  CB  ARG    16      -9.022  46.796  -6.096  1.00 16.47           C
ATOM    263  CG  ARG    16      -8.327  47.808  -5.243  1.00 20.20           C
ATOM    266  CD  ARG    16      -7.975  49.054  -6.021  1.00 26.38           C
ATOM    269  NE  ARG    16      -6.868  49.676  -5.338  1.00 24.76           N
ATOM    271  CZ  ARG    16      -5.583  49.547  -5.650  1.00 23.18           C
ATOM    272  NH1 ARG    16      -5.178  48.910  -6.742  1.00 24.86           N
ATOM    275  NH2 ARG    16      -4.686  50.121  -4.856  1.00 30.66           N
ATOM    278  C   ARG    16     -10.679  44.968  -6.259  1.00 13.93           C
ATOM    279  O   ARG    16     -11.864  45.248  -6.112  1.00 14.07           O
ATOM    281  N   ASN    17     -10.257  44.175  -7.218  1.00 16.80           N
ATOM    282  CA  ASN    17     -11.176  43.522  -8.112  1.00 18.78           C
ATOM    284  CB  ASN    17     -10.401  42.870  -9.247  1.00 21.01           C
ATOM    287  CG  ASN    17     -11.295  42.036 -10.170  1.00 28.67           C
ATOM    288  OD1 ASN    17     -11.469  40.838  -9.941  1.00 21.42           O
ATOM    289  ND2 ASN    17     -11.827  42.664 -11.250  1.00 28.09           N
ATOM    292  C   ASN    17     -12.089  42.535  -7.382  1.00 16.00           C
ATOM    293  O   ASN    17     -13.302  42.574  -7.591  1.00 17.86           O
ATOM    295  N   VAL    18     -11.520  41.689  -6.521  1.00 18.79           N
ATOM    296  CA  VAL    18     -12.301  40.735  -5.735  1.00 17.67           C
ATOM    298  CB  VAL    18     -11.407  39.847  -4.834  1.00 19.56           C
ATOM    300  CG1 VAL    18     -12.271  39.004  -3.891  1.00 20.84           C
ATOM    304  CG2 VAL    18     -10.450  38.989  -5.687  1.00 14.57           C
ATOM    308  C   VAL    18     -13.266  41.501  -4.810  1.00 17.37           C
ATOM    309  O   VAL    18     -14.450  41.176  -4.721  1.00 19.43           O
ATOM    311  N   THR    19     -12.747  42.526  -4.146  1.00 16.37           N
ATOM    312  CA  THR    19     -13.563  43.341  -3.222  1.00 17.39           C
ATOM    314  CB  THR    19     -12.716  44.371  -2.443  1.00 16.96           C
ATOM    316  OG1 THR    19     -11.617  43.710  -1.816  1.00 17.66           O
ATOM    318  CG2 THR    19     -13.564  45.076  -1.343  1.00 20.05           C
ATOM    322  C   THR    19     -14.744  44.026  -3.933  1.00 17.65           C
ATOM    323  O   THR    19     -15.852  44.020  -3.417  1.00 19.09           O
ATOM    325  N   HIS    20     -14.508  44.595  -5.101  1.00 19.93           N
ATOM    326  CA  HIS    20     -15.611  45.135  -5.920  1.00 19.72           C
ATOM    328  CB  HIS    20     -15.059  45.947  -7.086  0.50 21.68           C
ATOM    334  CG  HIS    20     -14.484  47.263  -6.651  0.50 31.09           C
ATOM    336  ND1 HIS    20     -15.103  48.066  -5.710  0.50 15.30           N
ATOM    340  CE1 HIS    20     -14.376  49.152  -5.520  0.50 31.02           C
ATOM    344  NE2 HIS    20     -13.308  49.082  -6.295  0.50 28.85           N
ATOM    348  CD2 HIS    20     -13.355  47.914  -7.019  0.50 25.42           C
ATOM    352  C   HIS    20     -16.660  44.095  -6.319  1.00 17.96           C
ATOM    353  O   HIS    20     -17.853  44.378  -6.303  1.00 20.97           O
ATOM    355  N   ARG    21     -16.230  42.894  -6.686  1.00 17.03           N
ATOM    356  CA  ARG    21     -17.180  41.826  -7.010  1.00 18.99           C
ATOM    358  CB  ARG    21     -16.435  40.624  -7.602  1.00 14.36           C
ATOM    361  CG  ARG    21     -15.970  40.922  -9.011  1.00 20.10           C
ATOM    364  CD  ARG    21     -14.704  40.187  -9.358  1.00 26.48           C
ATOM    367  NE  ARG    21     -14.976  38.798  -9.527  1.00 23.70           N
ATOM    369  CZ  ARG    21     -14.059  37.850  -9.652  1.00 24.65           C
ATOM    370  NH1 ARG    21     -12.773  38.120  -9.628  1.00 21.13           N
ATOM    373  NH2 ARG    21     -14.461  36.619  -9.815  1.00 21.77           N
ATOM    376  C   ARG    21     -18.083  41.435  -5.822  1.00 19.61           C
ATOM    377  O   ARG    21     -19.285  41.157  -5.992  1.00 23.33           O
ATOM    379  N   LEU    22     -17.522  41.469  -4.622  1.00 19.80           N
ATOM    380  CA  LEU    22     -18.300  41.281  -3.399  1.00 18.25           C
ATOM    382  CB  LEU    22     -17.378  41.023  -2.193  1.00 19.98           C
ATOM    385  CG  LEU    22     -16.345  39.907  -2.263  1.00 18.93           C
ATOM    387  CD1 LEU    22     -15.396  39.999  -1.040  1.00 20.62           C
ATOM    391  CD2 LEU    22     -17.018  38.495  -2.365  1.00 20.07           C
ATOM    395  C   LEU    22     -19.228  42.459  -3.101  1.00 20.64           C
ATOM    396  O   LEU    22     -20.415  42.251  -2.807  1.00 21.92           O
ATOM    398  N   ALA    23     -18.701  43.679  -3.190  1.00 17.45           N
ATOM    399  CA  ALA    23     -19.441  44.866  -2.847  1.00 17.66           C
ATOM    401  CB  ALA    23     -18.527  46.122  -2.822  1.00 21.62           C
ATOM    405  C   ALA    23     -20.644  45.119  -3.776  1.00 26.04           C
ATOM    406  O   ALA    23     -21.590  45.756  -3.360  1.00 22.48           O
ATOM    408  N   ILE    24     -20.612  44.639  -5.014  1.00 25.86           N
ATOM    409  CA  ILE    24     -21.755  44.832  -5.895  1.00 27.15           C
ATOM    411  CB  ILE    24     -21.344  45.044  -7.374  1.00 28.18           C
ATOM    413  CG1 ILE    24     -20.761  43.768  -7.966  1.00 23.99           C
ATOM    416  CD1 ILE    24     -20.472  43.872  -9.443  1.00 35.51           C
ATOM    420  CG2 ILE    24     -20.408  46.213  -7.489  1.00 34.25           C
ATOM    424  C   ILE    24     -22.790  43.706  -5.793  1.00 28.62           C
ATOM    425  O   ILE    24     -23.850  43.801  -6.384  1.00 26.67           O
ATOM    427  N   ASP    25     -22.498  42.646  -5.046  1.00 25.41           N
ATOM    428  CA  ASP    25     -23.433  41.566  -4.884  1.00 26.94           C
ATOM    430  CB  ASP    25     -22.726  40.350  -4.319  1.00 26.56           C
ATOM    433  CG  ASP    25     -23.578  39.107  -4.362  1.00 23.90           C
ATOM    434  OD1 ASP    25     -24.730  39.106  -3.846  1.00 26.48           O
ATOM    435  OD2 ASP    25     -23.072  38.101  -4.865  1.00 25.65           O
ATOM    436  C   ASP    25     -24.552  42.053  -3.944  1.00 28.65           C
ATOM    437  O   ASP    25     -24.284  42.520  -2.852  1.00 22.14           O
ATOM    439  N   LYS    26     -25.805  41.969  -4.394  1.00 30.84           N
ATOM    440  CA  LYS    26     -26.972  42.460  -3.624  1.00 30.71           C
ATOM    442  CB  LYS    26     -28.269  42.264  -4.436  1.00 33.89           C
ATOM    445  CG  LYS    26     -28.511  43.357  -5.458  1.00 44.49           C
ATOM    451  C   LYS    26     -27.110  41.822  -2.229  1.00 20.07           C
ATOM    452  O   LYS    26     -27.539  42.461  -1.284  1.00 26.43           O
ATOM    454  N   ARG    27     -26.680  40.589  -2.087  1.00 21.15           N
ATOM    455  CA  ARG    27     -26.707  39.913  -0.798  1.00 22.60           C
ATOM    457  CB  ARG    27     -26.242  38.480  -0.963  1.00 25.57           C
ATOM    460  CG  ARG    27     -27.146  37.636  -1.841  1.00 27.66           C
ATOM    463  CD  ARG    27     -26.556  36.286  -2.013  1.00 23.29           C
ATOM    466  NE  ARG    27     -25.338  36.340  -2.817  1.00 26.58           N
ATOM    468  CZ  ARG    27     -24.476  35.332  -2.941  1.00 23.01           C
ATOM    469  NH1 ARG    27     -24.685  34.189  -2.338  1.00 28.51           N
ATOM    472  NH2 ARG    27     -23.403  35.463  -3.696  1.00 28.09           N
ATOM    475  C   ARG    27     -25.817  40.557   0.265  1.00 24.98           C
ATOM    476  O   ARG    27     -26.053  40.397   1.473  1.00 25.35           O
ATOM    478  N   PHE    28     -24.801  41.282  -0.186  1.00 21.49           N
ATOM    479  CA  PHE    28     -23.726  41.741   0.688  1.00 23.72           C
ATOM    481  CB  PHE    28     -22.367  41.350   0.071  1.00 18.92           C
ATOM    484  CG  PHE    28     -22.222  39.873  -0.238  1.00 22.49           C
ATOM    485  CD1 PHE    28     -22.890  38.896   0.509  1.00 18.05           C
ATOM    487  CE1 PHE    28     -22.755  37.560   0.217  1.00 23.57           C
ATOM    489  CZ  PHE    28     -21.918  37.162  -0.818  1.00 19.66           C
ATOM    491  CE2 PHE    28     -21.237  38.120  -1.551  1.00 19.19           C
ATOM    493  CD2 PHE    28     -21.387  39.456  -1.252  1.00 20.61           C
ATOM    495  C   PHE    28     -23.809  43.225   0.963  1.00 20.64           C
ATOM    496  O   PHE    28     -22.922  43.802   1.621  1.00 21.40           O
ATOM    498  N   ARG    29     -24.903  43.860   0.528  1.00 25.62           N
ATOM    499  CA  ARG    29     -25.106  45.308   0.727  1.00 25.06           C
ATOM    501  CB  ARG    29     -26.492  45.749   0.199  1.00 28.09           C
ATOM    504  CG  ARG    29     -26.750  47.252   0.234  1.00 35.00           C
ATOM    507  CD  ARG    29     -28.236  47.617   0.028  1.00 56.20           C
ATOM    510  NE  ARG    29     -29.158  46.670   0.671  1.00 80.68           N
ATOM    512  CZ  ARG    29     -29.425  46.591   1.982  1.00 79.44           C
ATOM    513  NH1 ARG    29     -28.846  47.409   2.863  1.00 66.15           N
ATOM    516  NH2 ARG    29     -30.277  45.662   2.420  1.00 79.04           N
ATOM    519  C   ARG    29     -24.931  45.753   2.180  1.00 20.06           C
ATOM    520  O   ARG    29     -24.355  46.816   2.424  1.00 26.41           O
ATOM    522  N   VAL    30     -25.391  44.932   3.117  1.00 27.21           N
ATOM    523  CA  VAL    30     -25.289  45.215   4.553  1.00 33.63           C
ATOM    525  CB  VAL    30     -26.019  44.115   5.436  1.00 38.16           C
ATOM    527  CG1 VAL    30     -25.513  42.687   5.162  1.00 30.77           C
ATOM    531  CG2 VAL    30     -25.887  44.414   6.918  1.00 51.45           C
ATOM    535  C   VAL    30     -23.825  45.365   5.002  1.00 33.95           C
ATOM    536  O   VAL    30     -23.536  46.052   5.976  1.00 28.60           O
ATOM    538  N   PHE    31     -22.908  44.747   4.262  1.00 27.31           N
ATOM    539  CA  PHE    31     -21.483  44.731   4.632  1.00 23.37           C
ATOM    541  CB  PHE    31     -20.917  43.326   4.423  1.00 24.67           C
ATOM    544  CG  PHE    31     -21.743  42.236   5.027  1.00 23.53           C
ATOM    545  CD1 PHE    31     -21.987  42.193   6.401  1.00 24.92           C
ATOM    547  CE1 PHE    31     -22.759  41.189   6.950  1.00 34.33           C
ATOM    549  CZ  PHE    31     -23.268  40.181   6.142  1.00 26.48           C
ATOM    551  CE2 PHE    31     -23.027  40.198   4.778  1.00 23.80           C
ATOM    553  CD2 PHE    31     -22.274  41.225   4.222  1.00 23.54           C
ATOM    555  C   PHE    31     -20.667  45.756   3.856  1.00 25.64           C
ATOM    556  O   PHE    31     -19.440  45.777   3.960  1.00 24.17           O
ATOM    558  N   THR    32     -21.344  46.619   3.093  1.00 24.94           N
ATOM    559  CA  THR    32     -20.680  47.593   2.255  1.00 23.72           C
ATOM    561  CB  THR    32     -21.469  47.932   0.964  1.00 31.83           C
ATOM    563  OG1 THR    32     -22.742  48.526   1.288  1.00 32.27           O
ATOM    565  CG2 THR    32     -21.633  46.678   0.069  1.00 22.27           C
ATOM    569  C   THR    32     -20.378  48.901   3.005  1.00 29.48           C
ATOM    570  O   THR    32     -19.567  49.691   2.546  1.00 30.50           O
ATOM    572  N   LYS    33     -21.018  49.116   4.153  1.00 29.86           N
ATOM    573  CA  LYS    33     -20.827  50.362   4.910  1.00 35.76           C
ATOM    575  CB  LYS    33     -22.004  51.342   4.691  1.00 36.32           C
ATOM    578  CG  LYS    33     -22.005  52.062   3.342  1.00 51.13           C
ATOM    581  CD  LYS    33     -23.340  52.779   3.070  1.00 45.23           C
ATOM    586  C   LYS    33     -20.703  50.066   6.387  1.00 30.75           C
ATOM    587  O   LYS    33     -21.211  49.038   6.877  1.00 34.04           O
ATOM    589  N   PRO    34     -20.022  50.975   7.124  1.00 40.34           N
ATOM    590  CA  PRO    34     -20.024  50.887   8.573  1.00 43.78           C
ATOM    592  CB  PRO    34     -19.289  52.160   9.007  1.00 44.37           C
ATOM    595  CG  PRO    34     -18.458  52.547   7.868  1.00 40.69           C
ATOM    598  CD  PRO    34     -19.251  52.142   6.652  1.00 39.52           C
ATOM    601  C   PRO    34     -21.445  50.906   9.117  1.00 46.49           C
ATOM    602  O   PRO    34     -22.348  51.411   8.462  1.00 46.86           O
ATOM    603  N   VAL    35     -21.629  50.357  10.306  1.00 52.73           N
ATOM    604  CA  VAL    35     -22.905  50.435  11.002  1.00 56.02           C
ATOM    606  CB  VAL    35     -22.963  49.408  12.141  1.00 52.91           C
ATOM    608  CG1 VAL    35     -22.966  47.996  11.569  1.00 47.77           C
ATOM    612  CG2 VAL    35     -24.191  49.658  13.016  1.00 45.00           C
ATOM    616  C   VAL    35     -23.139  51.853  11.562  1.00 63.10           C
ATOM    617  O   VAL    35     -22.258  52.435  12.205  1.00 67.79           O
ATOM    619  N   ASP    36     -24.333  52.394  11.320  1.00 66.89           N
ATOM    620  CA  ASP    36     -24.676  53.763  11.725  1.00 68.61           C
ATOM    622  CB  ASP    36     -25.929  54.218  10.964  1.00 70.39           C
ATOM    625  CG  ASP    36     -26.175  55.714  11.064  1.00 77.61           C
ATOM    626  OD1 ASP    36     -25.201  56.485  11.219  1.00 70.69           O
ATOM    627  OD2 ASP    36     -27.355  56.117  10.971  1.00 90.64           O
ATOM    628  C   ASP    36     -24.898  53.861  13.254  1.00 67.11           C
ATOM    629  O   ASP    36     -25.795  53.199  13.800  1.00 56.69           O
ATOM    631  N   PRO    37     -24.081  54.685  13.951  1.00 70.78           N
ATOM    632  CA  PRO    37     -24.197  54.744  15.420  1.00 75.96           C
ATOM    634  CB  PRO    37     -23.059  55.691  15.834  1.00 75.72           C
ATOM    637  CG  PRO    37     -22.765  56.499  14.625  1.00 71.83           C
ATOM    640  CD  PRO    37     -23.059  55.621  13.443  1.00 67.24           C
ATOM    643  C   PRO    37     -25.552  55.273  15.901  1.00 80.35           C
ATOM    644  O   PRO    37     -25.932  55.035  17.050  1.00 83.21           O
ATOM    645  N   ASP    38     -26.266  55.976  15.023  1.00 83.08           N
ATOM    646  CA  ASP    38     -27.612  56.454  15.320  1.00 85.90           C
ATOM    648  CB  ASP    38     -28.032  57.549  14.332  1.00 86.22           C
ATOM    651  CG  ASP    38     -26.946  58.600  14.122  1.00 91.26           C
ATOM    652  OD1 ASP    38     -26.291  59.000  15.112  1.00 80.39           O
ATOM    653  OD2 ASP    38     -26.747  59.019  12.960  1.00 95.27           O
ATOM    654  C   ASP    38     -28.582  55.275  15.258  1.00 86.84           C
ATOM    655  O   ASP    38     -29.307  55.008  16.220  1.00 87.15           O
ATOM    657  N   GLU    39     -28.574  54.568  14.127  1.00 85.88           N
ATOM    658  CA  GLU    39     -29.421  53.389  13.941  1.00 84.58           C
ATOM    660  CB  GLU    39     -29.302  52.861  12.505  1.00 83.92           C
ATOM    667  C   GLU    39     -29.085  52.284  14.956  1.00 84.18           C
ATOM    668  O   GLU    39     -29.990  51.719  15.580  1.00 83.93           O
ATOM    670  N   VAL    40     -27.791  51.994  15.127  1.00 82.97           N
ATOM    671  CA  VAL    40     -27.326  50.952  16.059  1.00 79.76           C
ATOM    673  CB  VAL    40     -26.710  49.752  15.311  1.00 77.63           C
ATOM    675  CG1 VAL    40     -26.842  48.498  16.145  1.00 78.57           C
ATOM    679  CG2 VAL    40     -27.387  49.554  13.963  1.00 78.81           C
ATOM    683  C   VAL    40     -26.291  51.535  17.035  1.00 78.94           C
ATOM    684  O   VAL    40     -25.088  51.526  16.748  1.00 74.58           O
ATOM    686  N   PRO    41     -26.760  52.045  18.194  1.00 78.72           N
ATOM    687  CA  PRO    41     -25.885  52.767  19.130  1.00 75.46           C
ATOM    689  CB  PRO    41     -26.876  53.520  20.018  1.00 76.25           C
ATOM    692  CG  PRO    41     -28.089  52.638  20.045  1.00 80.48           C
ATOM    695  CD  PRO    41     -28.127  51.890  18.730  1.00 78.09           C
ATOM    698  C   PRO    41     -24.988  51.852  19.962  1.00 69.89           C
ATOM    699  O   PRO    41     -23.862  52.235  20.284  1.00 71.29           O
ATOM    700  N   ASP    42     -25.477  50.655  20.285  1.00 64.93           N
ATOM    701  CA  ASP    42     -24.691  49.667  21.019  1.00 63.01           C
ATOM    703  CB  ASP    42     -25.616  48.712  21.801  1.00 65.05           C
ATOM    706  CG  ASP    42     -26.381  47.740  20.897  1.00 71.38           C
ATOM    707  OD1 ASP    42     -26.382  46.515  21.186  1.00 60.91           O
ATOM    708  OD2 ASP    42     -26.976  48.203  19.898  1.00 69.09           O
ATOM    709  C   ASP    42     -23.718  48.855  20.136  1.00 59.52           C
ATOM    710  O   ASP    42     -23.081  47.928  20.638  1.00 59.30           O
ATOM    712  N   TYR    43     -23.594  49.186  18.846  1.00 56.70           N
ATOM    713  CA  TYR    43     -22.720  48.402  17.952  1.00 54.71           C
ATOM    715  CB  TYR    43     -22.915  48.743  16.459  1.00 55.68           C
ATOM    718  CG  TYR    43     -22.255  47.707  15.545  1.00 45.79           C
ATOM    719  CD1 TYR    43     -22.908  46.519  15.245  1.00 50.75           C
ATOM    721  CE1 TYR    43     -22.322  45.546  14.436  1.00 42.58           C
ATOM    723  CZ  TYR    43     -21.059  45.744  13.920  1.00 34.68           C
ATOM    724  OH  TYR    43     -20.527  44.734  13.135  1.00 39.12           O
ATOM    726  CE2 TYR    43     -20.356  46.913  14.209  1.00 37.57           C
ATOM    728  CD2 TYR    43     -20.960  47.892  15.032  1.00 43.68           C
ATOM    730  C   TYR    43     -21.254  48.600  18.320  1.00 54.18           C
ATOM    731  O   TYR    43     -20.523  47.623  18.531  1.00 48.20           O
ATOM    733  N   VAL    44     -20.847  49.871  18.391  1.00 52.45           N
ATOM    734  CA  VAL    44     -19.454  50.239  18.637  1.00 55.94           C
ATOM    736  CB  VAL    44     -19.192  51.763  18.333  1.00 58.13           C
ATOM    738  CG1 VAL    44     -18.220  52.399  19.327  1.00 58.75           C
ATOM    742  CG2 VAL    44     -18.684  51.920  16.908  1.00 47.76           C
ATOM    746  C   VAL    44     -18.945  49.796  20.025  1.00 50.89           C
ATOM    747  O   VAL    44     -17.731  49.688  20.217  1.00 47.72           O
ATOM    749  N   THR    45     -19.866  49.487  20.947  1.00 49.61           N
ATOM    750  CA  THR    45     -19.520  48.909  22.259  1.00 48.11           C
ATOM    752  CB  THR    45     -20.445  49.461  23.395  1.00 52.57           C
ATOM    754  OG1 THR    45     -21.668  48.713  23.469  1.00 60.63           O
ATOM    756  CG2 THR    45     -20.767  50.929  23.165  1.00 43.51           C
ATOM    760  C   THR    45     -19.511  47.359  22.271  1.00 46.13           C
ATOM    761  O   THR    45     -18.704  46.746  22.995  1.00 44.43           O
ATOM    763  N   VAL    46     -20.385  46.723  21.480  1.00 42.70           N
ATOM    764  CA  VAL    46     -20.404  45.243  21.371  1.00 40.23           C
ATOM    766  CB  VAL    46     -21.778  44.712  20.870  1.00 44.94           C
ATOM    768  CG1 VAL    46     -21.747  43.180  20.691  1.00 46.94           C
ATOM    772  CG2 VAL    46     -22.893  45.133  21.829  1.00 44.05           C
ATOM    776  C   VAL    46     -19.287  44.702  20.453  1.00 36.60           C
ATOM    777  O   VAL    46     -18.654  43.673  20.744  1.00 38.38           O
ATOM    779  N   ILE    47     -19.065  45.396  19.341  1.00 30.45           N
ATOM    780  CA  ILE    47     -18.111  44.965  18.328  1.00 32.39           C
ATOM    782  CB  ILE    47     -18.734  44.983  16.890  1.00 35.54           C
ATOM    784  CG1 ILE    47     -19.956  44.028  16.779  1.00 27.28           C
ATOM    787  CD1 ILE    47     -19.707  42.525  17.097  1.00 23.48           C
ATOM    791  CG2 ILE    47     -17.682  44.619  15.842  1.00 25.81           C
ATOM    795  C   ILE    47     -16.864  45.865  18.401  1.00 33.66           C
ATOM    796  O   ILE    47     -16.883  47.050  18.031  1.00 36.10           O
ATOM    798  N   LYS    48     -15.798  45.270  18.901  1.00 33.32           N
ATOM    799  CA  LYS    48     -14.550  45.963  19.207  1.00 31.72           C
ATOM    801  CB  LYS    48     -13.689  45.068  20.118  1.00 31.65           C
ATOM    804  CG  LYS    48     -14.387  44.729  21.453  1.00 39.44           C
ATOM    807  CD  LYS    48     -14.892  46.002  22.158  1.00 43.13           C
ATOM    810  CE  LYS    48     -15.676  45.714  23.404  1.00 47.78           C
ATOM    813  NZ  LYS    48     -16.182  47.011  23.956  1.00 44.33           N
ATOM    817  C   LYS    48     -13.751  46.353  17.977  1.00 33.20           C
ATOM    818  O   LYS    48     -13.014  47.339  18.022  1.00 27.97           O
ATOM    820  N   GLN    49     -13.914  45.583  16.895  1.00 30.48           N
ATOM    821  CA  GLN    49     -13.217  45.843  15.662  1.00 32.30           C
ATOM    823  CB  GLN    49     -12.049  44.864  15.505  1.00 29.28           C
ATOM    826  CG  GLN    49     -11.013  45.463  14.632  1.00 39.19           C
ATOM    829  CD  GLN    49      -9.769  44.633  14.478  1.00 36.19           C
ATOM    830  OE1 GLN    49      -8.860  45.072  13.783  1.00 40.56           O
ATOM    831  NE2 GLN    49      -9.711  43.427  15.107  1.00 33.13           N
ATOM    834  C   GLN    49     -14.181  45.755  14.477  1.00 28.07           C
ATOM    835  O   GLN    49     -14.234  44.724  13.793  1.00 28.15           O
ATOM    837  N   PRO    50     -14.949  46.835  14.245  1.00 29.22           N
ATOM    838  CA  PRO    50     -15.875  46.936  13.125  1.00 27.66           C
ATOM    840  CB  PRO    50     -16.369  48.378  13.211  1.00 30.49           C
ATOM    843  CG  PRO    50     -16.195  48.758  14.591  1.00 36.52           C
ATOM    846  CD  PRO    50     -15.042  48.013  15.122  1.00 26.98           C
ATOM    849  C   PRO    50     -15.126  46.763  11.815  1.00 31.26           C
ATOM    850  O   PRO    50     -14.027  47.278  11.679  1.00 23.71           O
ATOM    851  N   MET    51     -15.696  46.044  10.861  1.00 21.15           N
ATOM    852  CA  MET    51     -15.055  45.935   9.533  1.00 22.60           C
ATOM    854  CB  MET    51     -14.158  44.700   9.485  1.00 21.22           C
ATOM    857  CG  MET    51     -13.218  44.584   8.232  1.00 20.96           C
ATOM    860  SD  MET    51     -12.243  46.051   7.847  1.00 26.36           S
ATOM    861  CE  MET    51     -11.246  46.176   9.359  1.00 22.19           C
ATOM    865  C   MET    51     -16.166  45.867   8.493  1.00 23.15           C
ATOM    866  O   MET    51     -17.221  45.344   8.772  1.00 23.61           O
ATOM    868  N   ASP    52     -15.924  46.436   7.328  1.00 24.76           N
ATOM    869  CA  ASP    52     -16.879  46.392   6.231  1.00 27.19           C
ATOM    871  CB  ASP    52     -17.922  47.511   6.360  1.00 26.13           C
ATOM    874  CG  ASP    52     -17.330  48.890   6.169  1.00 29.38           C
ATOM    875  OD1 ASP    52     -16.775  49.471   7.125  1.00 45.75           O
ATOM    876  OD2 ASP    52     -17.407  49.400   5.059  1.00 31.49           O
ATOM    877  C   ASP    52     -16.084  46.513   4.949  1.00 24.29           C
ATOM    878  O   ASP    52     -14.881  46.799   4.992  1.00 20.17           O
ATOM    880  N   LEU    53     -16.745  46.316   3.812  1.00 19.93           N
ATOM    881  CA  LEU    53     -16.042  46.295   2.513  1.00 22.93           C
ATOM    883  CB  LEU    53     -16.947  45.717   1.416  1.00 23.99           C
ATOM    886  CG  LEU    53     -17.426  44.279   1.629  1.00 25.34           C
ATOM    888  CD1 LEU    53     -18.492  43.886   0.568  1.00 17.36           C
ATOM    892  CD2 LEU    53     -16.274  43.274   1.667  1.00 17.56           C
ATOM    896  C   LEU    53     -15.496  47.665   2.091  1.00 25.54           C
ATOM    897  O   LEU    53     -14.483  47.745   1.360  1.00 19.91           O
ATOM    899  N   SER    54     -16.118  48.753   2.553  1.00 28.29           N
ATOM    900  CA  SER    54     -15.543  50.087   2.272  1.00 25.79           C
ATOM    902  CB  SER    54     -16.504  51.211   2.684  0.50 23.77           C
ATOM    908  OG  SER    54     -16.659  51.265   4.097  0.50 28.65           O
ATOM    912  C   SER    54     -14.227  50.281   3.014  1.00 20.81           C
ATOM    913  O   SER    54     -13.287  50.890   2.484  1.00 25.29           O
ATOM    915  N   SER    55     -14.176  49.791   4.241  1.00 23.85           N
ATOM    916  CA  SER    55     -12.940  49.887   5.038  1.00 28.64           C
ATOM    918  CB  SER    55     -13.218  49.548   6.498  1.00 26.98           C
ATOM    921  OG  SER    55     -14.248  50.389   7.006  1.00 35.24           O
ATOM    923  C   SER    55     -11.851  48.986   4.446  1.00 24.61           C
ATOM    924  O   SER    55     -10.673  49.347   4.432  1.00 22.37           O
ATOM    926  N   VAL    56     -12.257  47.833   3.912  1.00 22.80           N
ATOM    927  CA  VAL    56     -11.319  46.945   3.189  1.00 18.59           C
ATOM    929  CB  VAL    56     -11.984  45.581   2.798  1.00 17.04           C
ATOM    931  CG1 VAL    56     -11.131  44.796   1.802  1.00 18.98           C
ATOM    935  CG2 VAL    56     -12.279  44.718   4.064  1.00 19.48           C
ATOM    939  C   VAL    56     -10.697  47.650   1.997  1.00 17.03           C
ATOM    940  O   VAL    56      -9.478  47.572   1.825  1.00 19.42           O
ATOM    942  N   ILE    57     -11.496  48.352   1.177  1.00 17.41           N
ATOM    943  CA  ILE    57     -10.955  49.092   0.032  1.00 20.50           C
ATOM    945  CB  ILE    57     -12.062  49.736  -0.876  1.00 23.10           C
ATOM    947  CG1 ILE    57     -12.835  48.672  -1.676  1.00 22.23           C
ATOM    950  CD1 ILE    57     -12.019  48.001  -2.756  1.00 28.19           C
ATOM    954  CG2 ILE    57     -11.454  50.774  -1.819  1.00 25.28           C
ATOM    958  C   ILE    57      -9.960  50.162   0.503  1.00 19.54           C
ATOM    959  O   ILE    57      -8.878  50.288  -0.056  1.00 17.87           O
ATOM    961  N   SER    58     -10.317  50.912   1.539  1.00 23.61           N
ATOM    962  CA  SER    58      -9.392  51.897   2.129  1.00 21.37           C
ATOM    964  CB  SER    58     -10.054  52.624   3.304  1.00 26.17           C
ATOM    967  OG  SER    58     -11.054  53.483   2.846  1.00 29.50           O
ATOM    969  C   SER    58      -8.045  51.272   2.584  1.00 18.72           C
ATOM    970  O   SER    58      -6.973  51.822   2.297  1.00 21.54           O
ATOM    972  N   LYS    59      -8.108  50.123   3.249  1.00 20.54           N
ATOM    973  CA  LYS    59      -6.924  49.433   3.712  1.00 16.63           C
ATOM    975  CB  LYS    59      -7.293  48.329   4.700  1.00 17.74           C
ATOM    978  CG  LYS    59      -7.723  48.901   6.077  1.00 21.37           C
ATOM    981  CD  LYS    59      -8.114  47.798   7.067  1.00 19.34           C
ATOM    984  CE  LYS    59      -6.893  47.119   7.670  1.00 20.09           C
ATOM    987  NZ  LYS    59      -7.200  46.047   8.619  1.00 19.43           N
ATOM    991  C   LYS    59      -6.034  48.918   2.559  1.00 15.54           C
ATOM    992  O   LYS    59      -4.816  48.973   2.659  1.00 16.76           O
ATOM    994  N   ILE    60      -6.643  48.453   1.467  1.00 17.14           N
ATOM    995  CA  ILE    60      -5.871  48.056   0.280  1.00 17.12           C
ATOM    997  CB  ILE    60      -6.783  47.630  -0.911  1.00 18.90           C
ATOM    999  CG1 ILE    60      -7.619  46.371  -0.546  1.00 20.67           C
ATOM   1002  CD1 ILE    60      -8.756  46.014  -1.549  1.00 16.51           C
ATOM   1006  CG2 ILE    60      -5.914  47.410  -2.191  1.00 15.27           C
ATOM   1010  C   ILE    60      -4.983  49.238  -0.173  1.00 16.88           C
ATOM   1011  O   ILE    60      -3.762  49.112  -0.345  1.00 18.43           O
ATOM   1013  N   ASP    61      -5.640  50.373  -0.349  1.00 18.18           N
ATOM   1014  CA  ASP    61      -5.022  51.581  -0.838  1.00 21.27           C
ATOM   1016  CB  ASP    61      -6.111  52.614  -1.131  1.00 20.70           C
ATOM   1019  CG  ASP    61      -6.998  52.220  -2.305  1.00 32.84           C
ATOM   1020  OD1 ASP    61      -6.667  51.259  -3.026  1.00 27.00           O
ATOM   1021  OD2 ASP    61      -8.033  52.884  -2.509  1.00 25.46           O
ATOM   1022  C   ASP    61      -3.976  52.136   0.138  1.00 24.20           C
ATOM   1023  O   ASP    61      -2.950  52.691  -0.290  1.00 21.34           O
ATOM   1025  N   LEU    62      -4.190  51.924   1.436  1.00 22.90           N
ATOM   1026  CA  LEU    62      -3.176  52.248   2.457  1.00 23.80           C
ATOM   1028  CB  LEU    62      -3.850  52.442   3.827  1.00 18.19           C
ATOM   1031  CG  LEU    62      -4.757  53.639   4.064  1.00 23.24           C
ATOM   1033  CD1 LEU    62      -5.442  53.427   5.439  1.00 20.00           C
ATOM   1037  CD2 LEU    62      -3.927  54.941   4.004  1.00 20.71           C
ATOM   1041  C   LEU    62      -2.071  51.194   2.585  1.00 24.78           C
ATOM   1042  O   LEU    62      -1.231  51.288   3.456  1.00 23.89           O
ATOM   1044  N   HIS    63      -2.050  50.185   1.712  1.00 21.03           N
ATOM   1045  CA  HIS    63      -1.018  49.156   1.698  1.00 18.83           C
ATOM   1047  CB  HIS    63       0.395  49.728   1.399  1.00 22.34           C
ATOM   1050  CG  HIS    63       0.488  50.497   0.129  1.00 22.10           C
ATOM   1051  ND1 HIS    63       1.698  50.841  -0.426  1.00 25.42           N
ATOM   1053  CE1 HIS    63       1.486  51.534  -1.530  1.00 20.87           C
ATOM   1055  NE2 HIS    63       0.184  51.589  -1.748  1.00 27.01           N
ATOM   1057  CD2 HIS    63      -0.462  50.954  -0.722  1.00 27.64           C
ATOM   1059  C   HIS    63      -0.971  48.336   2.982  1.00 21.67           C
ATOM   1060  O   HIS    63       0.070  47.885   3.388  1.00 22.07           O
ATOM   1062  N   LYS    64      -2.122  48.098   3.586  1.00 22.14           N
ATOM   1063  CA  LYS    64      -2.188  47.316   4.796  1.00 21.91           C
ATOM   1065  CB  LYS    64      -3.440  47.663   5.583  1.00 19.04           C
ATOM   1068  CG  LYS    64      -3.536  49.112   5.934  1.00 24.59           C
ATOM   1071  CD  LYS    64      -2.562  49.504   6.961  1.00 30.67           C
ATOM   1074  CE  LYS    64      -2.888  50.916   7.485  1.00 48.26           C
ATOM   1077  NZ  LYS    64      -2.018  51.276   8.627  1.00 47.20           N
ATOM   1081  C   LYS    64      -2.194  45.831   4.565  1.00 23.75           C
ATOM   1082  O   LYS    64      -1.981  45.077   5.507  1.00 18.75           O
ATOM   1084  N   TYR    65      -2.463  45.407   3.337  1.00 21.37           N
ATOM   1085  CA  TYR    65      -2.490  43.990   3.044  1.00 17.52           C
ATOM   1087  CB  TYR    65      -3.788  43.577   2.327  1.00 15.32           C
ATOM   1090  CG  TYR    65      -5.083  43.992   3.050  1.00 16.36           C
ATOM   1091  CD1 TYR    65      -5.359  43.565   4.331  1.00 19.84           C
ATOM   1093  CE1 TYR    65      -6.552  43.924   4.968  1.00 19.40           C
ATOM   1095  CZ  TYR    65      -7.501  44.701   4.296  1.00 15.48           C
ATOM   1096  OH  TYR    65      -8.679  45.058   4.902  1.00 18.10           O
ATOM   1098  CE2 TYR    65      -7.266  45.119   3.033  1.00 17.29           C
ATOM   1100  CD2 TYR    65      -6.057  44.751   2.395  1.00 16.43           C
ATOM   1102  C   TYR    65      -1.301  43.672   2.162  1.00 21.48           C
ATOM   1103  O   TYR    65      -1.258  44.066   1.007  1.00 22.79           O
ATOM   1105  N   LEU    66      -0.346  42.935   2.713  1.00 19.79           N
ATOM   1106  CA  LEU    66       0.847  42.523   1.958  1.00 23.12           C
ATOM   1108  CB  LEU    66       2.089  42.712   2.836  1.00 25.01           C
ATOM   1111  CG  LEU    66       2.439  44.137   3.294  1.00 32.61           C
ATOM   1113  CD1 LEU    66       3.862  44.119   3.908  1.00 37.41           C
ATOM   1117  CD2 LEU    66       2.368  45.115   2.195  1.00 30.09           C
ATOM   1121  C   LEU    66       0.743  41.062   1.481  1.00 22.04           C
ATOM   1122  O   LEU    66       1.557  40.601   0.688  1.00 21.03           O
ATOM   1124  N   THR    67      -0.256  40.344   1.990  1.00 20.44           N
ATOM   1125  CA  THR    67      -0.543  38.972   1.589  1.00 19.04           C
ATOM   1127  CB  THR    67       0.039  37.928   2.563  1.00 18.54           C
ATOM   1129  OG1 THR    67      -0.742  37.899   3.757  1.00 21.70           O
ATOM   1131  CG2 THR    67       1.506  38.214   2.937  1.00 20.92           C
ATOM   1135  C   THR    67      -2.077  38.771   1.534  1.00 20.22           C
ATOM   1136  O   THR    67      -2.848  39.552   2.115  1.00 18.31           O
ATOM   1138  N   VAL    68      -2.518  37.724   0.835  1.00 16.57           N
ATOM   1139  CA  VAL    68      -3.937  37.398   0.800  1.00 19.83           C
ATOM   1141  CB  VAL    68      -4.303  36.338  -0.283  1.00 19.37           C
ATOM   1143  CG1 VAL    68      -5.768  36.553  -0.786  1.00 24.52           C
ATOM   1147  CG2 VAL    68      -4.149  34.918   0.242  1.00 25.02           C
ATOM   1151  C   VAL    68      -4.424  36.961   2.180  1.00 22.55           C
ATOM   1152  O   VAL    68      -5.586  37.163   2.527  1.00 18.78           O
ATOM   1154  N   LYS    69      -3.550  36.353   2.984  1.00 22.17           N
ATOM   1155  CA  LYS    69      -3.917  36.039   4.372  1.00 26.13           C
ATOM   1157  CB  LYS    69      -2.773  35.296   5.084  1.00 33.70           C
ATOM   1160  CG  LYS    69      -2.648  33.854   4.646  1.00 34.43           C
ATOM   1163  CD  LYS    69      -1.703  33.079   5.573  1.00 45.50           C
ATOM   1168  C   LYS    69      -4.365  37.232   5.216  1.00 21.88           C
ATOM   1169  O   LYS    69      -5.357  37.131   5.952  1.00 23.88           O
ATOM   1171  N   ASP    70      -3.647  38.346   5.089  1.00 19.84           N
ATOM   1172  CA  ASP    70      -3.959  39.615   5.762  1.00 24.88           C
ATOM   1174  CB  ASP    70      -2.992  40.738   5.326  1.00 26.51           C
ATOM   1177  CG  ASP    70      -1.541  40.593   5.828  1.00 34.56           C
ATOM   1178  OD1 ASP    70      -1.244  39.787   6.721  1.00 27.92           O
ATOM   1179  OD2 ASP    70      -0.694  41.379   5.313  1.00 34.87           O
ATOM   1180  C   ASP    70      -5.381  40.087   5.352  1.00 27.16           C
ATOM   1181  O   ASP    70      -6.205  40.493   6.187  1.00 20.43           O
ATOM   1183  N   TYR    71      -5.625  40.070   4.045  1.00 23.04           N
ATOM   1184  CA  TYR    71      -6.940  40.435   3.471  1.00 17.48           C
ATOM   1186  CB  TYR    71      -6.849  40.328   1.955  1.00 19.62           C
ATOM   1189  CG  TYR    71      -8.147  40.516   1.226  1.00 15.66           C
ATOM   1190  CD1 TYR    71      -8.624  41.803   0.949  1.00 15.77           C
ATOM   1192  CE1 TYR    71      -9.795  41.991   0.265  1.00 17.42           C
ATOM   1194  CZ  TYR    71     -10.536  40.878  -0.163  1.00 18.81           C
ATOM   1195  OH  TYR    71     -11.681  41.085  -0.870  1.00 16.07           O
ATOM   1197  CE2 TYR    71     -10.079  39.593   0.061  1.00 15.40           C
ATOM   1199  CD2 TYR    71      -8.886  39.406   0.764  1.00 17.77           C
ATOM   1201  C   TYR    71      -8.074  39.536   3.979  1.00 17.40           C
ATOM   1202  O   TYR    71      -9.115  40.032   4.445  1.00 18.24           O
ATOM   1204  N   LEU    72      -7.871  38.226   3.892  1.00 18.72           N
ATOM   1205  CA  LEU    72      -8.874  37.252   4.349  1.00 21.15           C
ATOM   1207  CB  LEU    72      -8.512  35.826   3.932  1.00 16.77           C
ATOM   1210  CG  LEU    72      -8.718  35.566   2.443  1.00 25.64           C
ATOM   1212  CD1 LEU    72      -8.040  34.297   2.112  1.00 19.37           C
ATOM   1216  CD2 LEU    72     -10.215  35.535   2.012  1.00 25.53           C
ATOM   1220  C   LEU    72      -9.182  37.340   5.843  1.00 26.45           C
ATOM   1221  O   LEU    72     -10.302  37.066   6.250  1.00 23.04           O
ATOM   1223  N   ARG    73      -8.219  37.790   6.636  1.00 22.93           N
ATOM   1224  CA  ARG    73      -8.434  38.055   8.047  1.00 28.03           C
ATOM   1226  CB  ARG    73      -7.122  38.490   8.726  1.00 31.55           C
ATOM   1229  CG  ARG    73      -7.105  38.285  10.212  1.00 38.49           C
ATOM   1232  CD  ARG    73      -5.699  38.518  10.812  1.00 49.01           C
ATOM   1235  NE  ARG    73      -4.676  37.784  10.065  1.00 44.82           N
ATOM   1237  CZ  ARG    73      -3.669  38.325   9.374  1.00 55.88           C
ATOM   1238  NH1 ARG    73      -3.476  39.648   9.322  1.00 40.38           N
ATOM   1241  NH2 ARG    73      -2.831  37.518   8.726  1.00 56.97           N
ATOM   1244  C   ARG    73      -9.524  39.098   8.278  1.00 18.44           C
ATOM   1245  O   ARG    73     -10.365  38.890   9.124  1.00 19.51           O
ATOM   1247  N   ASP    74      -9.523  40.171   7.494  1.00 18.76           N
ATOM   1248  CA  ASP    74     -10.571  41.193   7.504  1.00 16.55           C
ATOM   1250  CB  ASP    74     -10.082  42.492   6.874  1.00 19.52           C
ATOM   1253  CG  ASP    74      -9.294  43.326   7.848  1.00 24.75           C
ATOM   1254  OD1 ASP    74      -9.271  42.928   9.020  1.00 20.14           O
ATOM   1255  OD2 ASP    74      -8.719  44.344   7.449  1.00 22.36           O
ATOM   1256  C   ASP    74     -11.916  40.769   6.894  1.00 21.92           C
ATOM   1257  O   ASP    74     -12.975  41.148   7.406  1.00 18.70           O
ATOM   1259  N   ILE    75     -11.886  39.980   5.830  1.00 21.18           N
ATOM   1260  CA  ILE    75     -13.126  39.305   5.348  1.00 20.67           C
ATOM   1262  CB  ILE    75     -12.861  38.455   4.056  1.00 24.95           C
ATOM   1264  CG1 ILE    75     -12.392  39.357   2.884  1.00 19.84           C
ATOM   1267  CD1 ILE    75     -13.271  40.588   2.564  1.00 17.92           C
ATOM   1271  CG2 ILE    75     -14.123  37.542   3.678  1.00 17.77           C
ATOM   1275  C   ILE    75     -13.756  38.436   6.459  1.00 20.07           C
ATOM   1276  O   ILE    75     -14.957  38.520   6.766  1.00 21.18           O
ATOM   1278  N   ASP    76     -12.930  37.612   7.072  1.00 17.12           N
ATOM   1279  CA  ASP    76     -13.336  36.803   8.192  1.00 18.83           C
ATOM   1281  CB  ASP    76     -12.186  35.905   8.657  1.00 22.83           C
ATOM   1284  CG  ASP    76     -12.043  34.652   7.827  1.00 27.23           C
ATOM   1285  OD1 ASP    76     -13.057  34.078   7.372  1.00 31.01           O
ATOM   1286  OD2 ASP    76     -10.909  34.191   7.693  1.00 27.95           O
ATOM   1287  C   ASP    76     -13.899  37.617   9.377  1.00 23.19           C
ATOM   1288  O   ASP    76     -14.831  37.168  10.037  1.00 22.31           O
ATOM   1290  N   LEU    77     -13.351  38.804   9.612  1.00 18.46           N
ATOM   1291  CA  LEU    77     -13.819  39.701  10.637  1.00 21.75           C
ATOM   1293  CB  LEU    77     -12.778  40.796  10.830  1.00 25.24           C
ATOM   1296  CG  LEU    77     -12.948  41.754  12.004  1.00 29.92           C
ATOM   1298  CD1 LEU    77     -13.038  40.979  13.351  1.00 25.12           C
ATOM   1302  CD2 LEU    77     -11.808  42.828  11.972  1.00 29.35           C
ATOM   1306  C   LEU    77     -15.234  40.301  10.317  1.00 28.76           C
ATOM   1307  O   LEU    77     -16.106  40.401  11.187  1.00 24.23           O
ATOM   1309  N   ILE    78     -15.463  40.677   9.065  1.00 25.00           N
ATOM   1310  CA  ILE    78     -16.801  41.067   8.619  1.00 24.14           C
ATOM   1312  CB  ILE    78     -16.846  41.357   7.106  1.00 22.57           C
ATOM   1314  CG1 ILE    78     -15.939  42.551   6.759  1.00 18.05           C
ATOM   1317  CD1 ILE    78     -15.865  42.959   5.251  1.00 17.41           C
ATOM   1321  CG2 ILE    78     -18.325  41.594   6.622  1.00 22.52           C
ATOM   1325  C   ILE    78     -17.788  39.956   8.967  1.00 21.73           C
ATOM   1326  O   ILE    78     -18.855  40.200   9.585  1.00 21.65           O
ATOM   1328  N   CYS    79     -17.439  38.728   8.613  1.00 20.07           N
ATOM   1329  CA  CYS    79     -18.311  37.600   8.882  1.00 23.10           C
ATOM   1331  CB  CYS    79     -17.826  36.354   8.142  1.00 20.26           C
ATOM   1334  SG  CYS    79     -18.872  34.951   8.328  1.00 27.18           S
ATOM   1336  C   CYS    79     -18.495  37.325  10.382  1.00 30.41           C
ATOM   1337  O   CYS    79     -19.635  37.266  10.875  1.00 22.37           O
ATOM   1339  N   SER    80     -17.393  37.181  11.121  1.00 21.91           N
ATOM   1340  CA  SER    80     -17.494  36.878  12.545  1.00 24.30           C
ATOM   1342  CB  SER    80     -16.095  36.547  13.140  1.00 24.35           C
ATOM   1345  OG  SER    80     -15.237  37.672  13.063  1.00 25.08           O
ATOM   1347  C   SER    80     -18.235  37.984  13.349  1.00 18.40           C
ATOM   1348  O   SER    80     -18.966  37.663  14.285  1.00 23.97           O
ATOM   1350  N   ASN    81     -18.040  39.257  13.002  1.00 20.76           N
ATOM   1351  CA  ASN    81     -18.731  40.384  13.628  1.00 23.40           C
ATOM   1353  CB  ASN    81     -18.272  41.726  13.033  1.00 18.65           C
ATOM   1356  CG  ASN    81     -16.891  42.213  13.553  1.00 23.49           C
ATOM   1357  OD1 ASN    81     -16.312  41.626  14.419  1.00 22.48           O
ATOM   1358  ND2 ASN    81     -16.394  43.279  12.976  1.00 20.38           N
ATOM   1361  C   ASN    81     -20.283  40.263  13.424  1.00 31.33           C
ATOM   1362  O   ASN    81     -21.087  40.528  14.334  1.00 26.82           O
ATOM   1364  N   ALA    82     -20.677  39.859  12.217  1.00 25.71           N
ATOM   1365  CA  ALA    82     -22.082  39.664  11.864  1.00 25.53           C
ATOM   1367  CB  ALA    82     -22.259  39.508  10.281  1.00 21.68           C
ATOM   1371  C   ALA    82     -22.675  38.493  12.648  1.00 19.47           C
ATOM   1372  O   ALA    82     -23.782  38.620  13.195  1.00 28.46           O
ATOM   1374  N   LEU    83     -21.945  37.393  12.806  1.00 22.22           N
ATOM   1375  CA  LEU    83     -22.458  36.275  13.567  1.00 23.51           C
ATOM   1377  CB  LEU    83     -21.630  34.996  13.381  1.00 25.32           C
ATOM   1380  CG  LEU    83     -21.284  34.549  11.947  1.00 34.57           C
ATOM   1382  CD1 LEU    83     -20.593  33.216  11.961  1.00 35.58           C
ATOM   1386  CD2 LEU    83     -22.467  34.549  11.013  1.00 26.17           C
ATOM   1390  C   LEU    83     -22.621  36.565  15.064  1.00 29.52           C
ATOM   1391  O   LEU    83     -23.595  36.103  15.672  1.00 26.06           O
ATOM   1393  N   GLU    84     -21.666  37.318  15.619  1.00 32.26           N
ATOM   1394  CA  GLU    84     -21.643  37.710  17.035  1.00 32.94           C
ATOM   1396  CB  GLU    84     -20.292  38.372  17.403  1.00 28.31           C
ATOM   1399  CG  GLU    84     -20.112  38.708  18.919  1.00 46.52           C
ATOM   1402  CD  GLU    84     -19.012  39.774  19.248  1.00 64.97           C
ATOM   1403  OE1 GLU    84     -19.027  40.289  20.394  1.00 62.98           O
ATOM   1404  OE2 GLU    84     -18.146  40.107  18.397  1.00 54.59           O
ATOM   1405  C   GLU    84     -22.775  38.669  17.351  1.00 24.93           C
ATOM   1406  O   GLU    84     -23.505  38.480  18.326  1.00 31.68           O
ATOM   1408  N   TYR    85     -22.917  39.687  16.517  1.00 25.04           N
ATOM   1409  CA  TYR    85     -23.859  40.737  16.750  1.00 31.73           C
ATOM   1411  CB  TYR    85     -23.552  41.964  15.894  1.00 27.37           C
ATOM   1414  CG  TYR    85     -24.285  43.193  16.424  1.00 43.81           C
ATOM   1415  CD1 TYR    85     -23.935  43.754  17.660  1.00 43.60           C
ATOM   1417  CE1 TYR    85     -24.609  44.867  18.169  1.00 51.06           C
ATOM   1419  CZ  TYR    85     -25.656  45.414  17.451  1.00 53.75           C
ATOM   1420  OH  TYR    85     -26.323  46.502  17.953  1.00 59.40           O
ATOM   1422  CE2 TYR    85     -26.032  44.869  16.232  1.00 45.06           C
ATOM   1424  CD2 TYR    85     -25.355  43.757  15.730  1.00 46.35           C
ATOM   1426  C   TYR    85     -25.312  40.326  16.468  1.00 32.29           C
ATOM   1427  O   TYR    85     -26.218  41.016  16.913  1.00 28.58           O
ATOM   1429  N   ASN    86     -25.511  39.244  15.713  1.00 32.89           N
ATOM   1430  CA  ASN    86     -26.859  38.825  15.262  1.00 31.75           C
ATOM   1432  CB  ASN    86     -27.062  39.151  13.773  1.00 32.32           C
ATOM   1435  CG  ASN    86     -26.831  40.612  13.440  1.00 31.15           C
ATOM   1436  OD1 ASN    86     -27.673  41.450  13.688  1.00 30.56           O
ATOM   1437  ND2 ASN    86     -25.687  40.919  12.835  1.00 33.47           N
ATOM   1440  C   ASN    86     -27.014  37.350  15.457  1.00 27.49           C
ATOM   1441  O   ASN    86     -27.161  36.616  14.483  1.00 31.91           O
ATOM   1443  N   PRO    87     -26.979  36.884  16.722  1.00 26.55           N
ATOM   1444  CA  PRO    87     -26.859  35.458  17.020  1.00 26.12           C
ATOM   1446  CB  PRO    87     -26.139  35.465  18.366  1.00 32.64           C
ATOM   1449  CG  PRO    87     -26.617  36.704  19.004  1.00 27.94           C
ATOM   1452  CD  PRO    87     -26.987  37.682  17.965  1.00 31.83           C
ATOM   1455  C   PRO    87     -28.190  34.720  17.191  1.00 23.77           C
ATOM   1456  O   PRO    87     -28.184  33.511  17.376  1.00 31.41           O
ATOM   1457  N   ASP    88     -29.295  35.454  17.077  1.00 29.51           N
ATOM   1458  CA  ASP    88     -30.628  34.995  17.492  1.00 30.57           C
ATOM   1460  CB  ASP    88     -31.499  36.214  17.808  1.00 33.78           C
ATOM   1463  CG  ASP    88     -31.018  36.990  19.037  1.00 44.32           C
ATOM   1464  OD1 ASP    88     -30.049  36.557  19.695  1.00 30.51           O
ATOM   1465  OD2 ASP    88     -31.618  38.042  19.343  1.00 45.37           O
ATOM   1466  C   ASP    88     -31.314  34.154  16.417  1.00 35.10           C
ATOM   1467  O   ASP    88     -30.874  34.159  15.254  1.00 27.40           O
ATOM   1469  N   ARG    89     -32.377  33.435  16.798  1.00 30.45           N
ATOM   1470  CA  ARG    89     -33.120  32.566  15.840  1.00 28.72           C
ATOM   1472  CB  ARG    89     -33.869  31.411  16.551  0.50 33.38           C
ATOM   1478  CG  ARG    89     -35.167  31.777  17.355  0.50 37.37           C
ATOM   1484  CD  ARG    89     -36.517  31.729  16.550  0.50 23.22           C
ATOM   1490  NE  ARG    89     -36.709  30.558  15.702  0.50 14.53           N
ATOM   1494  CZ  ARG    89     -37.431  30.582  14.566  0.50 21.38           C
ATOM   1496  NH1 ARG    89     -37.964  31.725  14.152  0.50 19.03           N
ATOM   1502  NH2 ARG    89     -37.589  29.485  13.816  0.50 13.40           N
ATOM   1508  C   ARG    89     -34.104  33.315  14.959  1.00 26.11           C
ATOM   1509  O   ARG    89     -34.687  32.742  14.036  1.00 29.81           O
ATOM   1511  N   ASP    90     -34.292  34.590  15.208  1.00 23.54           N
ATOM   1512  CA  ASP    90     -35.264  35.315  14.430  1.00 29.60           C
ATOM   1514  CB  ASP    90     -35.570  36.660  15.055  1.00 30.13           C
ATOM   1517  CG  ASP    90     -34.416  37.592  15.029  1.00 38.59           C
ATOM   1518  OD1 ASP    90     -34.440  38.541  14.205  1.00 51.79           O
ATOM   1519  OD2 ASP    90     -33.495  37.374  15.835  1.00 59.04           O
ATOM   1520  C   ASP    90     -34.818  35.489  12.968  1.00 31.35           C
ATOM   1521  O   ASP    90     -33.608  35.485  12.679  1.00 27.12           O
ATOM   1523  N   PRO    91     -35.796  35.658  12.057  1.00 30.02           N
ATOM   1524  CA  PRO    91     -35.509  35.719  10.624  1.00 27.31           C
ATOM   1526  CB  PRO    91     -36.888  35.982   9.996  1.00 31.62           C
ATOM   1529  CG  PRO    91     -37.870  35.529  10.995  1.00 30.59           C
ATOM   1532  CD  PRO    91     -37.249  35.720  12.332  1.00 29.64           C
ATOM   1535  C   PRO    91     -34.517  36.811  10.209  1.00 22.34           C
ATOM   1536  O   PRO    91     -33.705  36.580   9.308  1.00 20.72           O
ATOM   1537  N   GLY    92     -34.594  37.996  10.814  1.00 21.91           N
ATOM   1538  CA  GLY    92     -33.644  39.081  10.479  1.00 27.46           C
ATOM   1541  C   GLY    92     -32.189  38.688  10.774  1.00 28.37           C
ATOM   1542  O   GLY    92     -31.291  38.926   9.959  1.00 26.07           O
ATOM   1544  N   ASP    93     -31.988  38.036  11.921  1.00 29.00           N
ATOM   1545  CA  ASP    93     -30.671  37.565  12.363  1.00 28.59           C
ATOM   1547  CB  ASP    93     -30.706  37.160  13.839  1.00 27.55           C
ATOM   1550  CG  ASP    93     -30.501  38.352  14.797  1.00 29.39           C
ATOM   1551  OD1 ASP    93     -30.830  39.510  14.444  1.00 34.06           O
ATOM   1552  OD2 ASP    93     -29.975  38.111  15.906  1.00 30.80           O
ATOM   1553  C   ASP    93     -30.200  36.391  11.496  1.00 27.19           C
ATOM   1554  O   ASP    93     -29.054  36.350  11.035  1.00 22.18           O
ATOM   1556  N   ARG    94     -31.084  35.433  11.257  1.00 23.21           N
ATOM   1557  CA  ARG    94     -30.707  34.307  10.424  1.00 23.79           C
ATOM   1559  CB  ARG    94     -31.766  33.209  10.471  1.00 25.48           C
ATOM   1562  CG  ARG    94     -31.737  32.427  11.740  1.00 27.61           C
ATOM   1565  CD  ARG    94     -32.760  31.383  11.762  1.00 30.35           C
ATOM   1568  NE  ARG    94     -32.587  30.462  12.881  1.00 29.92           N
ATOM   1570  CZ  ARG    94     -33.515  29.601  13.303  1.00 44.64           C
ATOM   1571  NH1 ARG    94     -34.696  29.524  12.707  1.00 49.89           N
ATOM   1574  NH2 ARG    94     -33.253  28.800  14.329  1.00 50.28           N
ATOM   1577  C   ARG    94     -30.353  34.733   8.984  1.00 20.18           C
ATOM   1578  O   ARG    94     -29.450  34.143   8.402  1.00 24.67           O
ATOM   1580  N   LEU    95     -31.024  35.742   8.429  1.00 22.52           N
ATOM   1581  CA  LEU    95     -30.721  36.233   7.093  1.00 22.83           C
ATOM   1583  CB  LEU    95     -31.778  37.231   6.586  1.00 17.27           C
ATOM   1586  CG  LEU    95     -31.622  37.872   5.193  1.00 13.78           C
ATOM   1588  CD1 LEU    95     -31.591  36.803   4.083  1.00 17.27           C
ATOM   1592  CD2 LEU    95     -32.741  38.938   4.931  1.00 18.04           C
ATOM   1596  C   LEU    95     -29.303  36.857   7.025  1.00 27.03           C
ATOM   1597  O   LEU    95     -28.513  36.509   6.145  1.00 18.85           O
ATOM   1599  N   ILE    96     -29.003  37.775   7.935  1.00 24.56           N
ATOM   1600  CA  ILE    96     -27.664  38.412   7.975  1.00 25.27           C
ATOM   1602  CB  ILE    96     -27.557  39.557   9.048  1.00 24.78           C
ATOM   1604  CG1 ILE    96     -26.213  40.323   8.878  1.00 26.50           C
ATOM   1607  CD1 ILE    96     -26.245  41.771   9.362  1.00 33.12           C
ATOM   1611  CG2 ILE    96     -27.670  38.996  10.451  1.00 39.55           C
ATOM   1615  C   ILE    96     -26.548  37.377   8.152  1.00 19.60           C
ATOM   1616  O   ILE    96     -25.527  37.461   7.468  1.00 21.18           O
ATOM   1618  N   ARG    97     -26.758  36.383   9.014  1.00 22.09           N
ATOM   1619  CA  ARG    97     -25.730  35.337   9.236  1.00 23.22           C
ATOM   1621  CB  ARG    97     -26.055  34.442  10.418  1.00 23.31           C
ATOM   1624  CG  ARG    97     -26.059  35.147  11.791  1.00 18.24           C
ATOM   1627  CD  ARG    97     -25.825  34.149  12.895  1.00 24.44           C
ATOM   1630  NE  ARG    97     -26.714  32.993  12.966  1.00 28.83           N
ATOM   1632  CZ  ARG    97     -27.954  32.988  13.471  1.00 27.43           C
ATOM   1633  NH1 ARG    97     -28.502  34.084  13.952  1.00 30.54           N
ATOM   1636  NH2 ARG    97     -28.636  31.867  13.506  1.00 34.39           N
ATOM   1639  C   ARG    97     -25.531  34.480   8.000  1.00 23.61           C
ATOM   1640  O   ARG    97     -24.405  34.077   7.685  1.00 19.92           O
ATOM   1642  N   HIS    98     -26.632  34.171   7.313  1.00 21.18           N
ATOM   1643  CA  HIS    98     -26.543  33.431   6.046  1.00 22.64           C
ATOM   1645  CB  HIS    98     -27.941  33.050   5.530  1.00 21.77           C
ATOM   1648  CG  HIS    98     -27.908  32.137   4.350  1.00 26.85           C
ATOM   1649  ND1 HIS    98     -27.908  32.597   3.046  1.00 26.01           N
ATOM   1651  CE1 HIS    98     -27.851  31.562   2.226  1.00 24.25           C
ATOM   1653  NE2 HIS    98     -27.801  30.456   2.946  1.00 24.82           N
ATOM   1655  CD2 HIS    98     -27.832  30.790   4.278  1.00 20.83           C
ATOM   1657  C   HIS    98     -25.762  34.212   4.969  1.00 17.30           C
ATOM   1658  O   HIS    98     -24.933  33.631   4.248  1.00 18.06           O
ATOM   1660  N   ARG    99     -26.027  35.506   4.899  1.00 19.10           N
ATOM   1661  CA  ARG    99     -25.316  36.441   4.018  1.00 20.88           C
ATOM   1663  CB  ARG    99     -26.027  37.773   3.997  1.00 20.64           C
ATOM   1666  CG  ARG    99     -27.387  37.732   3.223  1.00 20.88           C
ATOM   1669  CD  ARG    99     -28.174  38.962   3.458  1.00 21.51           C
ATOM   1672  NE  ARG    99     -29.294  39.078   2.521  1.00 23.06           N
ATOM   1674  CZ  ARG    99     -30.191  40.058   2.555  1.00 20.30           C
ATOM   1675  NH1 ARG    99     -30.091  41.023   3.440  1.00 21.05           N
ATOM   1678  NH2 ARG    99     -31.181  40.093   1.678  1.00 21.17           N
ATOM   1681  C   ARG    99     -23.838  36.630   4.382  1.00 20.58           C
ATOM   1682  O   ARG    99     -22.988  36.706   3.488  1.00 17.96           O
ATOM   1684  N   ALA   100     -23.558  36.732   5.683  1.00 19.17           N
ATOM   1685  CA  ALA   100     -22.195  36.813   6.217  1.00 21.85           C
ATOM   1687  CB  ALA   100     -22.225  36.938   7.764  1.00 16.22           C
ATOM   1691  C   ALA   100     -21.351  35.615   5.791  1.00 20.05           C
ATOM   1692  O   ALA   100     -20.221  35.796   5.311  1.00 23.60           O
ATOM   1694  N   CYS   101     -21.907  34.415   5.973  1.00 21.28           N
ATOM   1695  CA  CYS   101     -21.276  33.158   5.610  1.00 21.52           C
ATOM   1697  CB  CYS   101     -22.079  31.960   6.126  1.00 28.07           C
ATOM   1700  SG  CYS   101     -21.972  31.797   7.936  1.00 31.25           S
ATOM   1702  C   CYS   101     -21.051  33.023   4.124  1.00 25.37           C
ATOM   1703  O   CYS   101     -19.999  32.501   3.714  1.00 19.19           O
ATOM   1705  N   ALA   102     -22.016  33.503   3.337  1.00 21.90           N
ATOM   1706  CA  ALA   102     -21.892  33.511   1.882  1.00 22.12           C
ATOM   1708  CB  ALA   102     -23.235  33.849   1.188  1.00 15.78           C
ATOM   1712  C   ALA   102     -20.790  34.486   1.442  1.00 20.27           C
ATOM   1713  O   ALA   102     -20.054  34.187   0.513  1.00 19.10           O
ATOM   1715  N   LEU   103     -20.716  35.655   2.073  1.00 16.83           N
ATOM   1716  CA  LEU   103     -19.665  36.644   1.771  1.00 18.39           C
ATOM   1718  CB  LEU   103     -19.805  37.899   2.654  1.00 23.15           C
ATOM   1721  CG  LEU   103     -18.663  38.922   2.545  1.00 30.05           C
ATOM   1723  CD1 LEU   103     -18.835  39.688   1.281  1.00 28.54           C
ATOM   1727  CD2 LEU   103     -18.626  39.860   3.741  1.00 37.11           C
ATOM   1731  C   LEU   103     -18.284  35.999   1.972  1.00 22.05           C
ATOM   1732  O   LEU   103     -17.399  36.073   1.096  1.00 16.43           O
ATOM   1734  N   ARG   104     -18.145  35.347   3.118  1.00 20.87           N
ATOM   1735  CA  ARG   104     -16.942  34.619   3.490  1.00 19.58           C
ATOM   1737  CB  ARG   104     -17.073  34.081   4.903  1.00 21.66           C
ATOM   1740  CG  ARG   104     -15.809  33.343   5.449  1.00 26.94           C
ATOM   1743  CD  ARG   104     -16.189  32.403   6.579  1.00 37.02           C
ATOM   1746  NE  ARG   104     -17.176  31.418   6.120  1.00 39.15           N
ATOM   1748  CZ  ARG   104     -18.107  30.830   6.873  1.00 47.77           C
ATOM   1749  NH1 ARG   104     -18.226  31.107   8.170  1.00 40.34           N
ATOM   1752  NH2 ARG   104     -18.941  29.960   6.318  1.00 32.08           N
ATOM   1755  C   ARG   104     -16.608  33.498   2.514  1.00 21.51           C
ATOM   1756  O   ARG   104     -15.502  33.451   1.985  1.00 19.81           O
ATOM   1758  N   ASP   105     -17.569  32.614   2.252  1.00 19.85           N
ATOM   1759  CA  ASP   105     -17.371  31.514   1.328  1.00 18.95           C
ATOM   1761  CB  ASP   105     -18.589  30.579   1.310  1.00 19.94           C
ATOM   1764  CG  ASP   105     -18.786  29.817   2.617  1.00 29.87           C
ATOM   1765  OD1 ASP   105     -17.890  29.804   3.497  1.00 25.79           O
ATOM   1766  OD2 ASP   105     -19.875  29.240   2.759  1.00 32.06           O
ATOM   1767  C   ASP   105     -17.071  31.980  -0.091  1.00 18.74           C
ATOM   1768  O   ASP   105     -16.165  31.416  -0.760  1.00 18.41           O
ATOM   1770  N   THR   106     -17.805  32.999  -0.550  1.00 16.32           N
ATOM   1771  CA  THR   106     -17.554  33.568  -1.857  1.00 17.31           C
ATOM   1773  CB  THR   106     -18.592  34.671  -2.215  1.00 19.60           C
ATOM   1775  OG1 THR   106     -19.910  34.091  -2.200  1.00 21.70           O
ATOM   1777  CG2 THR   106     -18.293  35.280  -3.582  1.00 21.15           C
ATOM   1781  C   THR   106     -16.110  34.103  -2.046  1.00 18.99           C
ATOM   1782  O   THR   106     -15.477  33.831  -3.076  1.00 17.74           O
ATOM   1784  N   ALA   107     -15.637  34.895  -1.094  1.00 15.61           N
ATOM   1785  CA  ALA   107     -14.289  35.420  -1.112  1.00 21.64           C
ATOM   1787  CB  ALA   107     -14.046  36.389   0.104  1.00 18.61           C
ATOM   1791  C   ALA   107     -13.247  34.298  -1.143  1.00 18.51           C
ATOM   1792  O   ALA   107     -12.335  34.325  -1.983  1.00 17.14           O
ATOM   1794  N   TYR   108     -13.401  33.301  -0.262  1.00 19.06           N
ATOM   1795  CA  TYR   108     -12.468  32.196  -0.209  1.00 20.55           C
ATOM   1797  CB  TYR   108     -12.759  31.244   0.955  1.00 19.96           C
ATOM   1800  CG  TYR   108     -12.056  31.638   2.231  1.00 25.99           C
ATOM   1801  CD1 TYR   108     -12.606  32.576   3.103  1.00 24.70           C
ATOM   1803  CE1 TYR   108     -11.952  32.927   4.290  1.00 20.39           C
ATOM   1805  CZ  TYR   108     -10.747  32.334   4.587  1.00 20.84           C
ATOM   1806  OH  TYR   108     -10.069  32.659   5.731  1.00 24.88           O
ATOM   1808  CE2 TYR   108     -10.178  31.414   3.723  1.00 24.61           C
ATOM   1810  CD2 TYR   108     -10.817  31.077   2.565  1.00 25.48           C
ATOM   1812  C   TYR   108     -12.408  31.452  -1.529  1.00 20.31           C
ATOM   1813  O   TYR   108     -11.310  31.099  -1.995  1.00 17.23           O
ATOM   1815  N   ALA   109     -13.574  31.289  -2.149  1.00 19.03           N
ATOM   1816  CA  ALA   109     -13.706  30.564  -3.412  1.00 23.11           C
ATOM   1818  CB  ALA   109     -15.176  30.300  -3.685  1.00 18.89           C
ATOM   1822  C   ALA   109     -13.061  31.284  -4.604  1.00 20.50           C
ATOM   1823  O   ALA   109     -12.427  30.638  -5.470  1.00 18.55           O
ATOM   1825  N   ILE   110     -13.267  32.605  -4.688  1.00 19.36           N
ATOM   1826  CA  ILE   110     -12.599  33.421  -5.725  1.00 21.96           C
ATOM   1828  CB  ILE   110     -13.063  34.925  -5.709  1.00 18.58           C
ATOM   1830  CG1 ILE   110     -14.535  35.027  -6.122  1.00 22.18           C
ATOM   1833  CD1 ILE   110     -15.215  36.373  -5.838  1.00 14.78           C
ATOM   1837  CG2 ILE   110     -12.170  35.812  -6.630  1.00 14.29           C
ATOM   1841  C   ILE   110     -11.071  33.311  -5.607  1.00 19.10           C
ATOM   1842  O   ILE   110     -10.372  33.040  -6.591  1.00 17.26           O
ATOM   1844  N   ILE   111     -10.561  33.544  -4.408  1.00 19.19           N
ATOM   1845  CA  ILE   111      -9.131  33.411  -4.116  1.00 25.44           C
ATOM   1847  CB  ILE   111      -8.800  33.800  -2.614  1.00 22.02           C
ATOM   1849  CG1 ILE   111      -8.927  35.319  -2.466  0.50 24.12           C
ATOM   1855  CD1 ILE   111      -8.975  35.821  -1.034  0.50 24.28           C
ATOM   1863  CG2 ILE   111      -7.377  33.351  -2.186  0.50 20.27           C
ATOM   1871  C   ILE   111      -8.594  32.012  -4.480  1.00 23.43           C
ATOM   1872  O   ILE   111      -7.521  31.889  -5.076  1.00 21.51           O
ATOM   1874  N   LYS   112      -9.331  30.970  -4.113  1.00 20.95           N
ATOM   1875  CA  LYS   112      -8.891  29.605  -4.401  1.00 25.13           C
ATOM   1877  CB  LYS   112      -9.815  28.569  -3.758  1.00 24.23           C
ATOM   1880  CG  LYS   112      -9.267  27.139  -3.851  1.00 34.87           C
ATOM   1883  CD  LYS   112     -10.337  26.124  -3.532  1.00 39.00           C
ATOM   1886  CE  LYS   112      -9.719  24.728  -3.388  1.00 41.73           C
ATOM   1889  NZ  LYS   112     -10.780  23.712  -3.284  1.00 50.37           N
ATOM   1893  C   LYS   112      -8.788  29.353  -5.898  1.00 22.73           C
ATOM   1894  O   LYS   112      -7.847  28.719  -6.353  1.00 23.80           O
ATOM   1896  N   GLU   113      -9.746  29.853  -6.661  1.00 20.61           N
ATOM   1897  CA  GLU   113      -9.742  29.692  -8.104  1.00 21.10           C
ATOM   1899  CB  GLU   113     -11.151  29.903  -8.655  1.00 24.85           C
ATOM   1902  CG  GLU   113     -11.376  29.291 -10.028  1.00 42.67           C
ATOM   1905  CD  GLU   113     -12.830  28.871 -10.218  1.00 63.40           C
ATOM   1906  OE1 GLU   113     -13.664  29.740 -10.555  1.00 53.37           O
ATOM   1907  OE2 GLU   113     -13.141  27.678 -10.014  1.00 73.30           O
ATOM   1908  C   GLU   113      -8.761  30.627  -8.834  1.00 22.80           C
ATOM   1909  O   GLU   113      -8.143  30.225  -9.814  1.00 22.99           O
ATOM   1911  N   GLU   114      -8.624  31.869  -8.371  1.00 18.16           N
ATOM   1912  CA  GLU   114      -7.987  32.916  -9.174  1.00 20.66           C
ATOM   1914  CB  GLU   114      -8.942  34.104  -9.351  1.00 17.76           C
ATOM   1917  CG  GLU   114     -10.303  33.700 -10.004  1.00 20.51           C
ATOM   1920  CD  GLU   114     -11.257  34.857 -10.154  1.00 22.62           C
ATOM   1921  OE1 GLU   114     -10.785  36.015 -10.211  1.00 23.24           O
ATOM   1922  OE2 GLU   114     -12.497  34.622 -10.190  1.00 20.23           O
ATOM   1923  C   GLU   114      -6.638  33.436  -8.660  1.00 17.59           C
ATOM   1924  O   GLU   114      -5.978  34.135  -9.388  1.00 22.00           O
ATOM   1926  N   LEU   115      -6.264  33.152  -7.424  1.00 17.35           N
ATOM   1927  CA  LEU   115      -4.969  33.587  -6.918  1.00 22.63           C
ATOM   1929  CB  LEU   115      -5.031  34.089  -5.488  1.00 25.32           C
ATOM   1932  CG  LEU   115      -3.736  34.808  -5.019  1.00 27.81           C
ATOM   1934  CD1 LEU   115      -3.541  36.132  -5.784  1.00 29.99           C
ATOM   1938  CD2 LEU   115      -3.802  35.013  -3.544  1.00 34.72           C
ATOM   1942  C   LEU   115      -3.995  32.413  -7.027  1.00 22.59           C
ATOM   1943  O   LEU   115      -4.200  31.351  -6.437  1.00 25.27           O
ATOM   1945  N   ASP   116      -2.956  32.608  -7.823  1.00 26.87           N
ATOM   1946  CA  ASP   116      -1.931  31.598  -8.001  1.00 21.26           C
ATOM   1948  CB  ASP   116      -0.940  32.039  -9.085  1.00 24.60           C
ATOM   1951  CG  ASP   116      -0.014  30.945  -9.463  1.00 32.72           C
ATOM   1952  OD1 ASP   116       0.802  30.520  -8.621  1.00 35.85           O
ATOM   1953  OD2 ASP   116      -0.116  30.482 -10.603  1.00 30.51           O
ATOM   1954  C   ASP   116      -1.217  31.405  -6.686  1.00 19.88           C
ATOM   1955  O   ASP   116      -0.797  32.367  -6.070  1.00 17.18           O
ATOM   1957  N   GLU   117      -1.072  30.153  -6.273  1.00 19.70           N
ATOM   1958  CA  GLU   117      -0.423  29.793  -5.015  1.00 21.71           C
ATOM   1960  CB  GLU   117      -0.505  28.281  -4.806  1.00 24.97           C
ATOM   1963  CG  GLU   117      -1.873  27.805  -4.351  1.00 47.68           C
ATOM   1966  CD  GLU   117      -1.993  26.281  -4.377  1.00 62.52           C
ATOM   1967  OE1 GLU   117      -1.051  25.592  -3.917  1.00 68.27           O
ATOM   1968  OE2 GLU   117      -3.025  25.781  -4.872  1.00 64.53           O
ATOM   1969  C   GLU   117       1.034  30.252  -4.904  1.00 19.02           C
ATOM   1970  O   GLU   117       1.505  30.575  -3.804  1.00 21.23           O
ATOM   1972  N   ASP   118       1.726  30.300  -6.037  1.00 21.76           N
ATOM   1973  CA  ASP   118       3.114  30.755  -6.084  1.00 23.35           C
ATOM   1975  CB  ASP   118       3.807  30.259  -7.362  1.00 23.22           C
ATOM   1978  CG  ASP   118       4.031  28.759  -7.344  1.00 23.95           C
ATOM   1979  OD1 ASP   118       4.153  28.174  -6.239  1.00 27.42           O
ATOM   1980  OD2 ASP   118       4.053  28.181  -8.419  1.00 34.51           O
ATOM   1981  C   ASP   118       3.216  32.252  -5.989  1.00 19.61           C
ATOM   1982  O   ASP   118       4.183  32.772  -5.444  1.00 21.35           O
ATOM   1984  N   PHE   119       2.205  32.953  -6.489  1.00 20.03           N
ATOM   1985  CA  PHE   119       2.117  34.407  -6.319  1.00 18.31           C
ATOM   1987  CB  PHE   119       0.999  35.022  -7.194  1.00 21.75           C
ATOM   1990  CG  PHE   119       0.877  36.501  -7.019  1.00 18.23           C
ATOM   1991  CD1 PHE   119       1.697  37.368  -7.744  1.00 20.63           C
ATOM   1993  CE1 PHE   119       1.645  38.724  -7.536  1.00 20.18           C
ATOM   1995  CZ  PHE   119       0.778  39.242  -6.595  1.00 20.66           C
ATOM   1997  CE2 PHE   119      -0.028  38.399  -5.840  1.00 21.25           C
ATOM   1999  CD2 PHE   119       0.034  37.039  -6.034  1.00 23.39           C
ATOM   2001  C   PHE   119       1.943  34.760  -4.820  1.00 20.04           C
ATOM   2002  O   PHE   119       2.636  35.652  -4.300  1.00 19.24           O
ATOM   2004  N   GLU   120       1.019  34.061  -4.149  1.00 19.65           N
ATOM   2005  CA  GLU   120       0.771  34.243  -2.721  1.00 20.07           C
ATOM   2007  CB  GLU   120      -0.452  33.418  -2.270  1.00 19.67           C
ATOM   2010  CG  GLU   120      -0.776  33.431  -0.751  1.00 18.22           C
ATOM   2013  CD  GLU   120      -0.842  34.838  -0.076  1.00 24.26           C
ATOM   2014  OE1 GLU   120      -0.993  35.867  -0.749  1.00 22.01           O
ATOM   2015  OE2 GLU   120      -0.748  34.920   1.166  1.00 31.38           O
ATOM   2016  C   GLU   120       2.011  33.896  -1.906  1.00 20.48           C
ATOM   2017  O   GLU   120       2.382  34.653  -1.004  1.00 18.84           O
ATOM   2019  N   GLN   121       2.694  32.812  -2.281  1.00 23.00           N
ATOM   2020  CA  GLN   121       3.915  32.389  -1.584  1.00 25.45           C
ATOM   2022  CB  GLN   121       4.429  31.033  -2.118  1.00 27.28           C
ATOM   2025  CG  GLN   121       5.608  30.447  -1.317  1.00 21.66           C
ATOM   2028  CD  GLN   121       5.278  30.213   0.151  1.00 33.37           C
ATOM   2029  OE1 GLN   121       4.152  29.870   0.483  1.00 32.16           O
ATOM   2030  NE2 GLN   121       6.259  30.418   1.037  1.00 26.32           N
ATOM   2033  C   GLN   121       5.004  33.462  -1.667  1.00 23.94           C
ATOM   2034  O   GLN   121       5.652  33.769  -0.654  1.00 23.54           O
ATOM   2036  N   LEU   122       5.194  34.028  -2.859  1.00 20.47           N
ATOM   2037  CA  LEU   122       6.070  35.185  -3.031  1.00 18.08           C
ATOM   2039  CB  LEU   122       6.086  35.684  -4.483  1.00 19.06           C
ATOM   2042  CG  LEU   122       7.034  36.853  -4.806  1.00 21.41           C
ATOM   2044  CD1 LEU   122       8.500  36.550  -4.318  1.00 21.01           C
ATOM   2048  CD2 LEU   122       6.981  37.263  -6.284  1.00 19.35           C
ATOM   2052  C   LEU   122       5.717  36.346  -2.102  1.00 25.99           C
ATOM   2053  O   LEU   122       6.595  36.878  -1.426  1.00 22.53           O
ATOM   2055  N   CYS   123       4.442  36.746  -2.073  1.00 24.30           N
ATOM   2056  CA  CYS   123       3.986  37.824  -1.193  1.00 22.03           C
ATOM   2058  CB  CYS   123       2.462  38.013  -1.273  1.00 19.81           C
ATOM   2061  SG  CYS   123       1.949  38.719  -2.788  1.00 20.51           S
ATOM   2063  C   CYS   123       4.406  37.543   0.250  1.00 19.76           C
ATOM   2064  O   CYS   123       4.923  38.429   0.925  1.00 23.30           O
ATOM   2066  N   GLU   124       4.219  36.302   0.677  1.00 21.51           N
ATOM   2067  CA  GLU   124       4.498  35.894   2.033  1.00 23.50           C
ATOM   2069  CB  GLU   124       3.904  34.522   2.316  1.00 25.91           C
ATOM   2072  CG  GLU   124       2.354  34.523   2.426  1.00 34.93           C
ATOM   2075  CD  GLU   124       1.753  33.122   2.570  1.00 39.26           C
ATOM   2076  OE1 GLU   124       2.507  32.196   2.922  1.00 44.00           O
ATOM   2077  OE2 GLU   124       0.531  32.934   2.324  1.00 32.86           O
ATOM   2078  C   GLU   124       6.000  35.937   2.305  1.00 27.58           C
ATOM   2079  O   GLU   124       6.425  36.363   3.373  1.00 23.27           O
ATOM   2081  N   GLU   125       6.808  35.559   1.319  1.00 28.86           N
ATOM   2082  CA  GLU   125       8.266  35.568   1.498  1.00 28.47           C
ATOM   2084  CB  GLU   125       8.964  34.623   0.483  1.00 24.02           C
ATOM   2087  CG  GLU   125       8.640  33.169   0.845  1.00 24.03           C
ATOM   2090  CD  GLU   125       9.254  32.079  -0.028  1.00 24.11           C
ATOM   2091  OE1 GLU   125      10.097  32.389  -0.885  1.00 26.14           O
ATOM   2092  OE2 GLU   125       8.870  30.893   0.175  1.00 25.13           O
ATOM   2093  C   GLU   125       8.844  36.986   1.557  1.00 25.14           C
ATOM   2094  O   GLU   125       9.702  37.240   2.379  1.00 32.10           O
ATOM   2096  N   ILE   126       8.343  37.910   0.744  1.00 18.67           N
ATOM   2097  CA  ILE   126       8.744  39.303   0.794  1.00 28.52           C
ATOM   2099  CB  ILE   126       8.101  40.129  -0.336  1.00 27.83           C
ATOM   2101  CG1 ILE   126       8.493  39.568  -1.715  1.00 26.91           C
ATOM   2104  CD1 ILE   126       7.773  40.251  -2.894  1.00 26.67           C
ATOM   2108  CG2 ILE   126       8.485  41.616  -0.217  1.00 22.12           C
ATOM   2112  C   ILE   126       8.337  39.875   2.154  1.00 36.40           C
ATOM   2113  O   ILE   126       9.156  40.463   2.873  1.00 35.06           O
ATOM   2115  N   GLN   127       7.079  39.649   2.529  1.00 35.08           N
ATOM   2116  CA  GLN   127       6.566  40.142   3.807  1.00 38.66           C
ATOM   2118  CB  GLN   127       5.108  39.735   3.995  1.00 38.13           C
ATOM   2121  CG  GLN   127       4.372  40.616   4.976  1.00 46.73           C
ATOM   2124  CD  GLN   127       3.704  39.812   6.038  1.00 64.51           C
ATOM   2125  OE1 GLN   127       4.390  39.181   6.848  1.00 56.16           O
ATOM   2126  NE2 GLN   127       2.356  39.812   6.052  1.00 51.91           N
ATOM   2129  C   GLN   127       7.425  39.636   4.995  1.00 34.69           C
ATOM   2130  O   GLN   127       7.851  40.424   5.838  1.00 33.60           O
ATOM   2132  N   GLU   128       7.683  38.335   5.043  1.00 35.26           N
ATOM   2133  CA  GLU   128       8.563  37.745   6.067  1.00 40.39           C
ATOM   2135  CB  GLU   128       8.623  36.223   5.892  1.00 41.49           C
ATOM   2138  CG  GLU   128       7.485  35.491   6.573  1.00 47.02           C
ATOM   2141  CD  GLU   128       6.930  34.334   5.760  1.00 63.09           C
ATOM   2142  OE1 GLU   128       7.704  33.634   5.067  1.00 51.55           O
ATOM   2143  OE2 GLU   128       5.699  34.126   5.826  1.00 65.34           O
ATOM   2144  C   GLU   128      10.001  38.324   6.084  1.00 45.71           C
ATOM   2145  O   GLU   128      10.679  38.302   7.119  1.00 48.40           O
ATOM   2147  N   SER   129      10.462  38.833   4.946  1.00 43.84           N
ATOM   2148  CA  SER   129      11.809  39.391   4.843  1.00 48.65           C
ATOM   2150  CB  SER   129      12.296  39.375   3.386  1.00 43.37           C
ATOM   2153  OG  SER   129      11.800  40.487   2.656  1.00 42.87           O
ATOM   2155  C   SER   129      11.874  40.812   5.408  1.00 52.03           C
ATOM   2156  O   SER   129      12.965  41.358   5.592  1.00 53.77           O
ATOM   2158  N   ARG   130      10.711  41.410   5.661  1.00 53.93           N
ATOM   2159  CA  ARG   130      10.633  42.740   6.267  1.00 59.45           C
ATOM   2161  CB  ARG   130       9.391  43.497   5.759  1.00 54.21           C
ATOM   2164  CG  ARG   130       9.681  44.307   4.492  1.00 68.78           C
ATOM   2167  CD  ARG   130       8.593  44.234   3.428  1.00 58.27           C
ATOM   2170  NE  ARG   130       9.175  44.426   2.091  1.00 71.54           N
ATOM   2172  CZ  ARG   130       8.794  45.337   1.189  1.00 79.48           C
ATOM   2173  NH1 ARG   130       9.414  45.386   0.007  1.00 73.01           N
ATOM   2176  NH2 ARG   130       7.790  46.185   1.432  1.00 82.81           N
ATOM   2179  C   ARG   130      10.653  42.648   7.793  1.00 61.53           C
ATOM   2180  O   ARG   130       9.981  41.818   8.419  1.00 64.77           O
ATOM   2182  OXT ARG   130      11.374  43.409   8.435  1.00 67.56           O
END
