
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  114 (  925),  selected  114 , name 2dww_A
# Molecule2: number of CA atoms  130 ( 1064),  selected  130 , name T0432.pdb
# PARAMETERS: 2dww_A.T0432.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      S       1           -
LGA    -       -      M       2           -
LGA    K     1_A      Q       3           #
LGA    S     2_A      E       4          3.008
LGA    -       -      E       5           -
LGA    S     3_A      D       6          3.824
LGA    K     4_A      T       7          3.427
LGA    I     5_A      F       8          3.303
LGA    S     6_A      R       9          2.960
LGA    E     7_A      E      10          2.208
LGA    Q     8_A      L      11          2.509
LGA    L     9_A      R      12          2.479
LGA    K    10_A      I      13          1.822
LGA    C    11_A      F      14          1.308
LGA    C    12_A      L      15          0.965
LGA    S    13_A      R      16          0.936
LGA    G    14_A      N      17          1.020
LGA    I    15_A      V      18          0.575
LGA    L    16_A      T      19          0.311
LGA    K    17_A      H      20          0.945
LGA    E    18_A      R      21          0.361
LGA    X    19_A      L      22          0.610
LGA    F    20_A      A      23          1.791
LGA    A    21_A      I      24          2.116
LGA    K    22_A      -       -           -
LGA    K    23_A      -       -           -
LGA    H    24_A      D      25          1.923
LGA    A    25_A      K      26          0.977
LGA    A    26_A      R      27          3.123
LGA    Y    27_A      -       -           -
LGA    A    28_A      F      28          0.536
LGA    W    29_A      R      29          0.697
LGA    P    30_A      V      30          0.469
LGA    F    31_A      F      31          0.452
LGA    Y    32_A      T      32          0.709
LGA    K    33_A      K      33          0.408
LGA    P    34_A      P      34          0.115
LGA    V    35_A      V      35          0.821
LGA    D    36_A      D      36          1.137
LGA    V    37_A      P      37          2.217
LGA    E    38_A      D      38          1.455
LGA    A    39_A      E      39          0.938
LGA    L    40_A      -       -           -
LGA    G    41_A      -       -           -
LGA    L    42_A      V      40          2.662
LGA    H    43_A      P      41          3.038
LGA    D    44_A      D      42          2.259
LGA    Y    45_A      Y      43          1.575
LGA    C    46_A      V      44          1.947
LGA    D    47_A      T      45          2.110
LGA    I    48_A      V      46          1.613
LGA    I    49_A      I      47          0.633
LGA    K    50_A      K      48          0.577
LGA    H    51_A      Q      49          0.775
LGA    P    52_A      P      50          0.524
LGA    X    53_A      M      51          0.871
LGA    D    54_A      D      52          0.777
LGA    X    55_A      L      53          0.750
LGA    S    56_A      S      54          0.887
LGA    T    57_A      S      55          1.231
LGA    I    58_A      V      56          1.082
LGA    K    59_A      I      57          1.097
LGA    S    60_A      S      58          1.677
LGA    K    61_A      K      59          1.780
LGA    L    62_A      I      60          1.432
LGA    E    63_A      D      61          2.159
LGA    S    64_A      L      62          2.827
LGA    R    65_A      H      63          2.475
LGA    E    66_A      -       -           -
LGA    Y    67_A      K      64          1.604
LGA    R    68_A      Y      65          3.839
LGA    D    69_A      L      66          1.184
LGA    A    70_A      T      67          3.009
LGA    Q    71_A      V      68          3.451
LGA    -       -      K      69           -
LGA    E    72_A      D      70          2.009
LGA    F    73_A      Y      71          1.928
LGA    G    74_A      L      72          1.843
LGA    A    75_A      R      73          1.561
LGA    D    76_A      D      74          1.517
LGA    V    77_A      I      75          1.585
LGA    R    78_A      D      76          1.353
LGA    L    79_A      L      77          1.175
LGA    X    80_A      I      78          1.280
LGA    F    81_A      C      79          1.203
LGA    S    82_A      S      80          1.035
LGA    N    83_A      N      81          0.730
LGA    C    84_A      A      82          0.690
LGA    Y    85_A      L      83          1.122
LGA    K    86_A      E      84          1.303
LGA    Y    87_A      Y      85          1.146
LGA    N    88_A      N      86          1.006
LGA    P    89_A      P      87          1.431
LGA    P    90_A      D      88          4.798
LGA    D    91_A      R      89          3.508
LGA    -       -      D      90           -
LGA    -       -      P      91           -
LGA    -       -      G      92           -
LGA    H    92_A      D      93          1.258
LGA    E    93_A      R      94          3.319
LGA    -       -      L      95           -
LGA    V    94_A      I      96          0.747
LGA    V    95_A      R      97          0.696
LGA    A    96_A      H      98          0.979
LGA    X    97_A      R      99          1.188
LGA    A    98_A      A     100          0.920
LGA    R    99_A      C     101          1.500
LGA    K   100_A      A     102          1.783
LGA    L   101_A      L     103          1.667
LGA    Q   102_A      R     104          1.570
LGA    D   103_A      D     105          1.986
LGA    V   104_A      T     106          1.317
LGA    F   105_A      A     107          0.776
LGA    E   106_A      Y     108          1.119
LGA    X   107_A      A     109          0.418
LGA    R   108_A      I     110          1.061
LGA    F   109_A      I     111          2.091
LGA    A   110_A      K     112          2.303
LGA    K   111_A      E     113          2.651
LGA    X   112_A      E     114          3.617
LGA    P   113_A      L     115          2.719
LGA    -       -      D     116           -
LGA    D   114_A      E     117          3.124
LGA    -       -      D     118           -
LGA    -       -      F     119           -
LGA    -       -      E     120           -
LGA    -       -      Q     121           -
LGA    -       -      L     122           -
LGA    -       -      C     123           -
LGA    -       -      E     124           -
LGA    -       -      E     125           -
LGA    -       -      I     126           -
LGA    -       -      Q     127           -
LGA    -       -      E     128           -
LGA    -       -      S     129           -
LGA    -       -      R     130           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  114  130    5.0    107    1.88    23.36     73.704     5.404

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.401320 * X  +  -0.254591 * Y  +   0.879844 * Z  + -61.837662
  Y_new =  -0.238366 * X  +   0.898465 * Y  +   0.368704 * Z  +  41.943394
  Z_new =  -0.884377 * X  +  -0.357694 * Y  +   0.299886 * Z  +  65.643311 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.873082    2.268511  [ DEG:   -50.0239    129.9761 ]
  Theta =   1.085158    2.056434  [ DEG:    62.1750    117.8250 ]
  Phi   =  -0.535963    2.605629  [ DEG:   -30.7084    149.2916 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2dww_A                                        
REMARK     2: T0432.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2dww_A.T0432.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  114  130   5.0  107   1.88   23.36  73.704
REMARK  ---------------------------------------------------------- 
MOLECULE 2dww_A
HEADER    TRANSCRIPTION                           21-AUG-06   2DWW              
TITLE     CRYSTAL STRUCTURE OF BROMODOMAIN-CONTAINING PROTEIN 4                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BROMODOMAIN-CONTAINING PROTEIN 4;                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: BROMODOMAIN, BD2;                                          
COMPND   5 SYNONYM: MITOTIC CHROMOSOME-ASSOCIATED PROTEIN, MCAP, BRD4;          
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   3 ORGANISM_COMMON: MOUSE;                                              
SOURCE   4 GENE: BRD4, MCAP;                                                    
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: PCR2.1-TOPO VECTOR;                       
SOURCE   7 OTHER_DETAILS: CELL-FREE                                             
KEYWDS    ALPHA-HELICAL DOMAIN, STRUCTURAL GENOMICS, NPPSFA, NATIONAL           
KEYWDS   2 PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES,               
KEYWDS   3 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI,               
KEYWDS   4 TRANSCRIPTION                                                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    B.PADMANABHAN,S.YOKOYAMA,RIKEN STRUCTURAL                             
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   21-AUG-07 2DWW    0                                                
JRNL        AUTH   B.PADMANABHAN,S.YOKOYAMA                                     
JRNL        TITL   CRYSTAL STRUCTURE OF BROMODOMAIN-CONTAINING                  
JRNL        TITL 2 PROTEIN 4                                                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2DWW A    1   114  UNP    Q9ESU6   BRD4_MOUSE     347    460             
SEQRES   1 A  114  LYS SER SER LYS ILE SER GLU GLN LEU LYS CYS CYS SER          
SEQRES   2 A  114  GLY ILE LEU LYS GLU MSE PHE ALA LYS LYS HIS ALA ALA          
SEQRES   3 A  114  TYR ALA TRP PRO PHE TYR LYS PRO VAL ASP VAL GLU ALA          
SEQRES   4 A  114  LEU GLY LEU HIS ASP TYR CYS ASP ILE ILE LYS HIS PRO          
SEQRES   5 A  114  MSE ASP MSE SER THR ILE LYS SER LYS LEU GLU SER ARG          
SEQRES   6 A  114  GLU TYR ARG ASP ALA GLN GLU PHE GLY ALA ASP VAL ARG          
SEQRES   7 A  114  LEU MSE PHE SER ASN CYS TYR LYS TYR ASN PRO PRO ASP          
SEQRES   8 A  114  HIS GLU VAL VAL ALA MSE ALA ARG LYS LEU GLN ASP VAL          
SEQRES   9 A  114  PHE GLU MSE ARG PHE ALA LYS MSE PRO ASP                      
HET    MSE  A  19       8                                                       
HET    MSE  A  53       8                                                       
HET    MSE  A  55       8                                                       
HET    MSE  A  80       8                                                       
HET    MSE  A  97       8                                                       
HET    MSE  A 107       8                                                       
HET    MSE  A 112       8                                                       
HET     CL  A 201       1                                                       
HET     CL  A 202       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CL CHLORIDE ION                                                     
FORMUL   1  MSE    7(C5 H11 N O2 SE)                                            
FORMUL   2   CL    2(CL 1-)                                                     
FORMUL   4  HOH   *186(H2 O)                                                    
CRYST1   73.891   57.779   33.588  90.00  90.00  90.00 P 21 21 2     4          
ATOM      1  N   LYS A   1       9.810  38.300  -5.545  1.00 50.66           N  
ATOM      2  CA  LYS A   1       9.107  37.909  -4.272  1.00 51.88           C  
ATOM      3  C   LYS A   1       8.373  39.085  -3.608  1.00 48.71           C  
ATOM      4  O   LYS A   1       8.164  39.100  -2.381  1.00 49.61           O  
ATOM      5  CB  LYS A   1      10.089  37.235  -3.292  1.00 49.57           C  
ATOM      6  N   SER A   2       7.975  40.057  -4.433  1.00 51.02           N  
ATOM      7  CA  SER A   2       7.235  41.241  -3.981  1.00 49.27           C  
ATOM      8  C   SER A   2       6.464  41.924  -5.130  1.00 46.44           C  
ATOM      9  O   SER A   2       5.574  42.753  -4.889  1.00 47.72           O  
ATOM     10  CB  SER A   2       8.160  42.220  -3.243  1.00 48.80           C  
ATOM     11  OG  SER A   2       7.462  43.335  -2.700  1.00 50.26           O  
ATOM     12  N   SER A   3       6.814  41.565  -6.367  1.00 47.40           N  
ATOM     13  CA  SER A   3       5.938  41.755  -7.532  1.00 40.05           C  
ATOM     14  C   SER A   3       4.737  40.803  -7.422  1.00 44.03           C  
ATOM     15  O   SER A   3       3.664  41.058  -7.999  1.00 41.77           O  
ATOM     16  CB  SER A   3       6.705  41.468  -8.835  1.00 48.72           C  
ATOM     17  OG  SER A   3       5.901  40.803  -9.815  1.00 48.93           O  
ATOM     18  N   LYS A   4       4.916  39.689  -6.712  1.00 39.22           N  
ATOM     19  CA  LYS A   4       3.783  38.813  -6.464  1.00 36.27           C  
ATOM     20  C   LYS A   4       2.850  39.470  -5.455  1.00 33.23           C  
ATOM     21  O   LYS A   4       1.628  39.392  -5.622  1.00 36.70           O  
ATOM     22  CB  LYS A   4       4.208  37.432  -5.991  1.00 33.46           C  
ATOM     23  CG  LYS A   4       3.586  36.282  -6.805  1.00 45.38           C  
ATOM     24  CD  LYS A   4       2.105  36.021  -6.457  1.00 44.80           C  
ATOM     25  CE  LYS A   4       1.347  35.393  -7.639  1.00 47.56           C  
ATOM     26  NZ  LYS A   4       1.067  36.369  -8.739  1.00 42.29           N  
ATOM     27  N   ILE A   5       3.416  40.138  -4.440  1.00 35.11           N  
ATOM     28  CA  ILE A   5       2.608  40.911  -3.483  1.00 34.30           C  
ATOM     29  C   ILE A   5       1.738  41.930  -4.223  1.00 35.03           C  
ATOM     30  O   ILE A   5       0.537  42.035  -3.977  1.00 29.98           O  
ATOM     31  CB  ILE A   5       3.474  41.589  -2.383  1.00 33.73           C  
ATOM     32  CG1 ILE A   5       3.982  40.548  -1.378  1.00 35.01           C  
ATOM     33  CG2 ILE A   5       2.666  42.674  -1.642  1.00 36.78           C  
ATOM     34  CD1 ILE A   5       5.273  40.931  -0.646  1.00 34.88           C  
ATOM     35  N   SER A   6       2.343  42.652  -5.159  1.00 33.98           N  
ATOM     36  CA  SER A   6       1.615  43.621  -5.968  1.00 34.99           C  
ATOM     37  C   SER A   6       0.483  42.990  -6.789  1.00 31.85           C  
ATOM     38  O   SER A   6      -0.601  43.570  -6.890  1.00 32.44           O  
ATOM     39  CB  SER A   6       2.591  44.433  -6.850  1.00 34.78           C  
ATOM     40  OG  SER A   6       1.960  44.955  -8.009  1.00 35.77           O  
ATOM     41  N   GLU A   7       0.713  41.804  -7.355  1.00 30.39           N  
ATOM     42  CA  GLU A   7      -0.313  41.145  -8.165  1.00 28.50           C  
ATOM     43  C   GLU A   7      -1.431  40.556  -7.294  1.00 25.55           C  
ATOM     44  O   GLU A   7      -2.583  40.537  -7.706  1.00 26.39           O  
ATOM     45  CB  GLU A   7       0.284  40.050  -9.057  1.00 30.33           C  
ATOM     46  CG  GLU A   7      -0.734  39.298  -9.924  1.00 35.98           C  
ATOM     47  CD  GLU A   7      -1.663  40.202 -10.741  1.00 51.02           C  
ATOM     48  OE1 GLU A   7      -1.145  41.034 -11.533  1.00 57.97           O  
ATOM     49  OE2 GLU A   7      -2.914  40.076 -10.602  1.00 44.68           O  
ATOM     50  N   GLN A   8      -1.079  40.066  -6.115  1.00 24.13           N  
ATOM     51  CA  GLN A   8      -2.092  39.536  -5.188  1.00 27.44           C  
ATOM     52  C   GLN A   8      -2.970  40.664  -4.671  1.00 21.39           C  
ATOM     53  O   GLN A   8      -4.198  40.519  -4.616  1.00 22.25           O  
ATOM     54  CB  GLN A   8      -1.442  38.765  -4.026  1.00 25.58           C  
ATOM     55  CG  GLN A   8      -0.861  37.387  -4.444  1.00 31.33           C  
ATOM     56  CD  GLN A   8      -0.945  36.317  -3.351  1.00 32.15           C  
ATOM     57  OE1 GLN A   8      -0.758  36.610  -2.179  1.00 33.68           O  
ATOM     58  NE2 GLN A   8      -1.225  35.071  -3.746  1.00 35.42           N  
ATOM     59  N   LEU A   9      -2.360  41.797  -4.310  1.00 23.92           N  
ATOM     60  CA  LEU A   9      -3.164  42.969  -3.927  1.00 21.45           C  
ATOM     61  C   LEU A   9      -4.087  43.460  -5.053  1.00 23.86           C  
ATOM     62  O   LEU A   9      -5.209  43.942  -4.820  1.00 26.75           O  
ATOM     63  CB  LEU A   9      -2.282  44.095  -3.369  1.00 23.19           C  
ATOM     64  CG  LEU A   9      -1.807  43.772  -1.949  1.00 25.09           C  
ATOM     65  CD1 LEU A   9      -0.646  44.652  -1.530  1.00 28.82           C  
ATOM     66  CD2 LEU A   9      -2.960  43.861  -0.950  1.00 20.68           C  
ATOM     67  N   LYS A  10      -3.624  43.328  -6.288  1.00 24.02           N  
ATOM     68  CA  LYS A  10      -4.481  43.614  -7.433  1.00 19.56           C  
ATOM     69  C   LYS A  10      -5.695  42.689  -7.483  1.00 24.90           C  
ATOM     70  O   LYS A  10      -6.827  43.143  -7.751  1.00 25.26           O  
ATOM     71  CB  LYS A  10      -3.677  43.483  -8.721  1.00 29.41           C  
ATOM     72  CG  LYS A  10      -4.294  44.123  -9.934  1.00 36.77           C  
ATOM     73  CD  LYS A  10      -3.230  44.344 -11.008  1.00 44.51           C  
ATOM     74  CE  LYS A  10      -1.836  44.528 -10.390  1.00 43.20           C  
ATOM     75  NZ  LYS A  10      -0.954  45.444 -11.185  1.00 50.88           N  
ATOM     76  N   CYS A  11      -5.466  41.397  -7.230  1.00 20.97           N  
ATOM     77  CA  CYS A  11      -6.569  40.416  -7.159  1.00 18.88           C  
ATOM     78  C   CYS A  11      -7.541  40.780  -6.049  1.00 18.78           C  
ATOM     79  O   CYS A  11      -8.738  40.638  -6.210  1.00 19.37           O  
ATOM     80  CB  CYS A  11      -6.060  38.987  -6.939  1.00 21.51           C  
ATOM     81  SG  CYS A  11      -5.353  38.276  -8.463  1.00 31.55           S  
ATOM     82  N   CYS A  12      -7.008  41.255  -4.933  1.00 19.96           N  
ATOM     83  CA  CYS A  12      -7.839  41.630  -3.779  1.00 20.54           C  
ATOM     84  C   CYS A  12      -8.792  42.722  -4.161  1.00 21.77           C  
ATOM     85  O   CYS A  12      -9.969  42.679  -3.804  1.00 16.44           O  
ATOM     86  CB  CYS A  12      -6.981  42.032  -2.580  1.00 20.37           C  
ATOM     87  SG  CYS A  12      -6.053  40.671  -1.834  1.00 21.28           S  
ATOM     88  N   SER A  13      -8.298  43.716  -4.901  1.00 22.09           N  
ATOM     89  CA  SER A  13      -9.160  44.764  -5.424  1.00 20.47           C  
ATOM     90  C   SER A  13     -10.270  44.186  -6.312  1.00 21.01           C  
ATOM     91  O   SER A  13     -11.433  44.592  -6.207  1.00 21.28           O  
ATOM     92  CB  SER A  13      -8.312  45.811  -6.178  1.00 27.79           C  
ATOM     93  OG  SER A  13      -9.131  46.738  -6.870  1.00 36.41           O  
ATOM     94  N   GLY A  14      -9.911  43.223  -7.168  1.00 19.75           N  
ATOM     95  CA  GLY A  14     -10.874  42.552  -8.021  1.00 16.02           C  
ATOM     96  C   GLY A  14     -11.920  41.785  -7.207  1.00 17.50           C  
ATOM     97  O   GLY A  14     -13.099  41.773  -7.531  1.00 20.43           O  
ATOM     98  N   ILE A  15     -11.489  41.136  -6.131  1.00 17.55           N  
ATOM     99  CA  ILE A  15     -12.446  40.415  -5.280  1.00 17.45           C  
ATOM    100  C   ILE A  15     -13.422  41.371  -4.633  1.00 14.49           C  
ATOM    101  O   ILE A  15     -14.643  41.170  -4.685  1.00 15.99           O  
ATOM    102  CB  ILE A  15     -11.690  39.592  -4.238  1.00 16.32           C  
ATOM    103  CG1 ILE A  15     -10.962  38.453  -4.973  1.00 14.79           C  
ATOM    104  CG2 ILE A  15     -12.637  39.069  -3.183  1.00 16.78           C  
ATOM    105  CD1 ILE A  15      -9.905  37.777  -4.120  1.00 18.18           C  
ATOM    106  N   LEU A  16     -12.895  42.446  -4.058  1.00 15.17           N  
ATOM    107  CA  LEU A  16     -13.783  43.416  -3.428  1.00 18.23           C  
ATOM    108  C   LEU A  16     -14.758  44.054  -4.430  1.00 22.49           C  
ATOM    109  O   LEU A  16     -15.932  44.224  -4.124  1.00 15.77           O  
ATOM    110  CB  LEU A  16     -12.985  44.440  -2.636  1.00 17.98           C  
ATOM    111  CG  LEU A  16     -13.809  45.326  -1.693  1.00 20.05           C  
ATOM    112  CD1 LEU A  16     -14.222  44.507  -0.478  1.00 22.53           C  
ATOM    113  CD2 LEU A  16     -12.967  46.497  -1.279  1.00 20.75           C  
ATOM    114  N   LYS A  17     -14.284  44.362  -5.636  1.00 21.56           N  
ATOM    115  CA  LYS A  17     -15.162  44.850  -6.701  1.00 21.60           C  
ATOM    116  C   LYS A  17     -16.313  43.894  -7.004  1.00 19.02           C  
ATOM    117  O   LYS A  17     -17.465  44.317  -7.148  1.00 19.19           O  
ATOM    118  CB  LYS A  17     -14.370  45.129  -7.985  1.00 24.88           C  
ATOM    119  CG  LYS A  17     -15.193  45.733  -9.117  1.00 28.55           C  
ATOM    120  CD  LYS A  17     -14.431  45.634 -10.445  1.00 31.35           C  
ATOM    121  CE  LYS A  17     -15.273  46.151 -11.598  1.00 33.39           C  
ATOM    122  NZ  LYS A  17     -14.492  47.158 -12.401  1.00 46.80           N  
ATOM    123  N   GLU A  18     -16.022  42.601  -7.074  1.00 17.51           N  
ATOM    124  CA  GLU A  18     -17.097  41.641  -7.308  1.00 16.99           C  
ATOM    125  C   GLU A  18     -18.081  41.660  -6.120  1.00 18.35           C  
ATOM    126  O   GLU A  18     -19.306  41.645  -6.312  1.00 15.64           O  
ATOM    127  CB  GLU A  18     -16.574  40.219  -7.561  1.00 14.76           C  
ATOM    128  CG  GLU A  18     -17.766  39.287  -7.811  1.00 21.63           C  
ATOM    129  CD  GLU A  18     -17.396  37.853  -8.109  1.00 23.63           C  
ATOM    130  OE1 GLU A  18     -16.232  37.593  -8.465  1.00 24.77           O  
ATOM    131  OE2 GLU A  18     -18.288  36.979  -7.992  1.00 22.33           O  
HETATM  132  N   MSE A  19     -17.552  41.736  -4.901  1.00 18.71           N  
HETATM  133  CA  MSE A  19     -18.424  41.786  -3.717  1.00 19.01           C  
HETATM  134  C   MSE A  19     -19.398  42.986  -3.733  1.00 18.97           C  
HETATM  135  O   MSE A  19     -20.529  42.901  -3.215  1.00 16.47           O  
HETATM  136  CB  MSE A  19     -17.595  41.737  -2.439  1.00 17.67           C  
HETATM  137  CG  MSE A  19     -16.851  40.402  -2.267  1.00 20.78           C  
HETATM  138 SE   MSE A  19     -15.482  40.458  -0.897  1.00 20.44          SE  
HETATM  139  CE  MSE A  19     -16.627  40.835   0.710  1.00 18.54           C  
ATOM    140  N   PHE A  20     -18.967  44.078  -4.368  1.00 17.49           N  
ATOM    141  CA  PHE A  20     -19.792  45.292  -4.551  1.00 19.02           C  
ATOM    142  C   PHE A  20     -20.729  45.212  -5.753  1.00 24.32           C  
ATOM    143  O   PHE A  20     -21.555  46.118  -5.946  1.00 25.68           O  
ATOM    144  CB  PHE A  20     -18.889  46.538  -4.735  1.00 19.56           C  
ATOM    145  CG  PHE A  20     -18.545  47.263  -3.470  1.00 20.79           C  
ATOM    146  CD1 PHE A  20     -17.209  47.332  -3.031  1.00 18.88           C  
ATOM    147  CD2 PHE A  20     -19.525  47.951  -2.750  1.00 18.62           C  
ATOM    148  CE1 PHE A  20     -16.852  48.010  -1.868  1.00 21.04           C  
ATOM    149  CE2 PHE A  20     -19.188  48.645  -1.583  1.00 19.69           C  
ATOM    150  CZ  PHE A  20     -17.858  48.683  -1.135  1.00 23.14           C  
ATOM    151  N   ALA A  21     -20.629  44.152  -6.557  1.00 24.30           N  
ATOM    152  CA  ALA A  21     -21.342  44.122  -7.845  1.00 22.68           C  
ATOM    153  C   ALA A  21     -22.801  43.693  -7.715  1.00 24.50           C  
ATOM    154  O   ALA A  21     -23.184  43.006  -6.765  1.00 23.66           O  
ATOM    155  CB  ALA A  21     -20.604  43.275  -8.857  1.00 20.36           C  
ATOM    156  N   LYS A  22     -23.628  44.138  -8.656  1.00 23.46           N  
ATOM    157  CA  LYS A  22     -25.050  43.788  -8.680  1.00 24.41           C  
ATOM    158  C   LYS A  22     -25.298  42.301  -8.434  1.00 27.31           C  
ATOM    159  O   LYS A  22     -26.258  41.922  -7.770  1.00 25.63           O  
ATOM    160  CB  LYS A  22     -25.679  44.229 -10.024  1.00 27.01           C  
ATOM    161  CG  LYS A  22     -27.103  43.716 -10.277  1.00 37.92           C  
ATOM    162  CD  LYS A  22     -28.094  44.087  -9.174  1.00 39.26           C  
ATOM    163  CE  LYS A  22     -29.520  43.910  -9.660  1.00 55.39           C  
ATOM    164  NZ  LYS A  22     -30.183  42.827  -8.906  1.00 46.73           N  
ATOM    165  N   LYS A  23     -24.431  41.449  -8.982  1.00 24.66           N  
ATOM    166  CA  LYS A  23     -24.604  40.020  -8.817  1.00 21.86           C  
ATOM    167  C   LYS A  23     -24.865  39.593  -7.361  1.00 22.84           C  
ATOM    168  O   LYS A  23     -25.696  38.727  -7.127  1.00 22.70           O  
ATOM    169  CB  LYS A  23     -23.408  39.287  -9.400  1.00 25.71           C  
ATOM    170  CG  LYS A  23     -23.428  37.816  -9.185  1.00 23.35           C  
ATOM    171  CD  LYS A  23     -22.244  37.223  -9.928  1.00 24.67           C  
ATOM    172  CE  LYS A  23     -22.085  35.764  -9.592  1.00 42.59           C  
ATOM    173  NZ  LYS A  23     -22.432  34.926 -10.748  1.00 33.35           N  
ATOM    174  N   HIS A  24     -24.199  40.245  -6.408  1.00 20.63           N  
ATOM    175  CA  HIS A  24     -24.242  39.825  -4.998  1.00 19.39           C  
ATOM    176  C   HIS A  24     -24.986  40.807  -4.117  1.00 16.84           C  
ATOM    177  O   HIS A  24     -25.081  40.610  -2.909  1.00 19.52           O  
ATOM    178  CB  HIS A  24     -22.816  39.642  -4.463  1.00 17.20           C  
ATOM    179  CG  HIS A  24     -22.002  38.700  -5.278  1.00 23.00           C  
ATOM    180  ND1 HIS A  24     -22.314  37.360  -5.394  1.00 21.49           N  
ATOM    181  CD2 HIS A  24     -20.917  38.907  -6.059  1.00 15.24           C  
ATOM    182  CE1 HIS A  24     -21.443  36.780  -6.202  1.00 26.80           C  
ATOM    183  NE2 HIS A  24     -20.585  37.695  -6.616  1.00 19.96           N  
ATOM    184  N   ALA A  25     -25.545  41.842  -4.734  1.00 20.83           N  
ATOM    185  CA  ALA A  25     -26.198  42.919  -4.005  1.00 20.38           C  
ATOM    186  C   ALA A  25     -27.333  42.525  -3.055  1.00 22.65           C  
ATOM    187  O   ALA A  25     -27.581  43.229  -2.071  1.00 21.58           O  
ATOM    188  CB  ALA A  25     -26.682  43.994  -4.986  1.00 23.25           C  
ATOM    189  N   ALA A  26     -27.983  41.395  -3.320  1.00 24.28           N  
ATOM    190  CA  ALA A  26     -29.116  40.942  -2.498  1.00 25.39           C  
ATOM    191  C   ALA A  26     -28.706  40.559  -1.086  1.00 22.59           C  
ATOM    192  O   ALA A  26     -29.518  40.638  -0.148  1.00 22.56           O  
ATOM    193  CB  ALA A  26     -29.826  39.752  -3.156  1.00 28.13           C  
ATOM    194  N   TYR A  27     -27.458  40.114  -0.940  1.00 23.91           N  
ATOM    195  CA  TYR A  27     -26.928  39.747   0.377  1.00 19.93           C  
ATOM    196  C   TYR A  27     -25.689  40.556   0.821  1.00 18.03           C  
ATOM    197  O   TYR A  27     -25.309  40.504   1.990  1.00 22.45           O  
ATOM    198  CB  TYR A  27     -26.647  38.240   0.452  1.00 17.63           C  
ATOM    199  CG  TYR A  27     -25.982  37.661  -0.780  1.00 18.16           C  
ATOM    200  CD1 TYR A  27     -24.594  37.562  -0.861  1.00 18.22           C  
ATOM    201  CD2 TYR A  27     -26.744  37.200  -1.863  1.00 22.47           C  
ATOM    202  CE1 TYR A  27     -23.983  37.032  -1.984  1.00 22.96           C  
ATOM    203  CE2 TYR A  27     -26.140  36.663  -2.986  1.00 17.80           C  
ATOM    204  CZ  TYR A  27     -24.768  36.596  -3.046  1.00 21.96           C  
ATOM    205  OH  TYR A  27     -24.173  36.039  -4.131  1.00 21.56           O  
ATOM    206  N   ALA A  28     -25.066  41.298  -0.090  1.00 16.39           N  
ATOM    207  CA  ALA A  28     -23.883  42.074   0.299  1.00 16.68           C  
ATOM    208  C   ALA A  28     -24.210  43.399   0.952  1.00 16.55           C  
ATOM    209  O   ALA A  28     -23.371  43.962   1.651  1.00 19.15           O  
ATOM    210  CB  ALA A  28     -22.932  42.306  -0.904  1.00 16.46           C  
ATOM    211  N   TRP A  29     -25.416  43.921   0.706  1.00 17.43           N  
ATOM    212  CA  TRP A  29     -25.713  45.308   1.070  1.00 17.62           C  
ATOM    213  C   TRP A  29     -25.517  45.679   2.559  1.00 19.57           C  
ATOM    214  O   TRP A  29     -25.139  46.820   2.837  1.00 16.99           O  
ATOM    215  CB  TRP A  29     -27.098  45.732   0.556  1.00 18.18           C  
ATOM    216  CG  TRP A  29     -28.235  45.031   1.210  1.00 18.36           C  
ATOM    217  CD1 TRP A  29     -28.903  43.927   0.737  1.00 18.65           C  
ATOM    218  CD2 TRP A  29     -28.856  45.368   2.454  1.00 26.27           C  
ATOM    219  NE1 TRP A  29     -29.883  43.556   1.621  1.00 29.35           N  
ATOM    220  CE2 TRP A  29     -29.877  44.419   2.685  1.00 30.97           C  
ATOM    221  CE3 TRP A  29     -28.633  46.361   3.425  1.00 33.49           C  
ATOM    222  CZ2 TRP A  29     -30.691  44.449   3.824  1.00 34.90           C  
ATOM    223  CZ3 TRP A  29     -29.448  46.388   4.566  1.00 30.84           C  
ATOM    224  CH2 TRP A  29     -30.457  45.435   4.752  1.00 38.77           C  
ATOM    225  N   PRO A  30     -25.752  44.759   3.513  1.00 19.36           N  
ATOM    226  CA  PRO A  30     -25.502  45.058   4.940  1.00 14.47           C  
ATOM    227  C   PRO A  30     -24.030  45.371   5.241  1.00 21.64           C  
ATOM    228  O   PRO A  30     -23.740  45.949   6.292  1.00 21.01           O  
ATOM    229  CB  PRO A  30     -25.885  43.749   5.657  1.00 19.48           C  
ATOM    230  CG  PRO A  30     -26.840  43.102   4.736  1.00 17.42           C  
ATOM    231  CD  PRO A  30     -26.292  43.400   3.340  1.00 16.52           C  
ATOM    232  N   PHE A  31     -23.141  45.003   4.319  1.00 16.70           N  
ATOM    233  CA  PHE A  31     -21.700  45.104   4.499  1.00 19.13           C  
ATOM    234  C   PHE A  31     -21.025  46.248   3.734  1.00 16.15           C  
ATOM    235  O   PHE A  31     -19.844  46.500   3.934  1.00 15.59           O  
ATOM    236  CB  PHE A  31     -21.069  43.733   4.183  1.00 14.39           C  
ATOM    237  CG  PHE A  31     -21.760  42.620   4.894  1.00 18.70           C  
ATOM    238  CD1 PHE A  31     -21.572  42.454   6.265  1.00 20.21           C  
ATOM    239  CD2 PHE A  31     -22.669  41.791   4.227  1.00 20.34           C  
ATOM    240  CE1 PHE A  31     -22.252  41.460   6.970  1.00 15.98           C  
ATOM    241  CE2 PHE A  31     -23.365  40.784   4.919  1.00 17.06           C  
ATOM    242  CZ  PHE A  31     -23.168  40.637   6.304  1.00 16.21           C  
ATOM    243  N   TYR A  32     -21.778  46.962   2.905  1.00 17.33           N  
ATOM    244  CA  TYR A  32     -21.202  48.042   2.085  1.00 18.19           C  
ATOM    245  C   TYR A  32     -20.573  49.178   2.909  1.00 21.85           C  
ATOM    246  O   TYR A  32     -19.526  49.742   2.549  1.00 20.31           O  
ATOM    247  CB  TYR A  32     -22.296  48.664   1.211  1.00 20.07           C  
ATOM    248  CG  TYR A  32     -22.802  47.844   0.058  1.00 19.68           C  
ATOM    249  CD1 TYR A  32     -22.171  46.678  -0.339  1.00 18.86           C  
ATOM    250  CD2 TYR A  32     -23.922  48.262  -0.663  1.00 25.44           C  
ATOM    251  CE1 TYR A  32     -22.631  45.948  -1.423  1.00 17.75           C  
ATOM    252  CE2 TYR A  32     -24.396  47.532  -1.747  1.00 26.31           C  
ATOM    253  CZ  TYR A  32     -23.740  46.374  -2.128  1.00 20.06           C  
ATOM    254  OH  TYR A  32     -24.213  45.627  -3.207  1.00 21.54           O  
ATOM    255  N   LYS A  33     -21.217  49.534   4.014  1.00 17.10           N  
ATOM    256  CA  LYS A  33     -20.802  50.734   4.744  1.00 16.91           C  
ATOM    257  C   LYS A  33     -20.707  50.378   6.220  1.00 20.06           C  
ATOM    258  O   LYS A  33     -21.262  49.358   6.618  1.00 20.52           O  
ATOM    259  CB  LYS A  33     -21.848  51.843   4.534  1.00 21.83           C  
ATOM    260  CG  LYS A  33     -21.767  52.482   3.135  1.00 28.60           C  
ATOM    261  CD  LYS A  33     -22.776  53.634   2.983  1.00 39.91           C  
ATOM    262  CE  LYS A  33     -22.234  54.772   2.101  1.00 48.23           C  
ATOM    263  NZ  LYS A  33     -20.940  54.446   1.404  1.00 49.17           N  
ATOM    264  N   PRO A  34     -20.055  51.217   7.041  1.00 16.60           N  
ATOM    265  CA  PRO A  34     -19.988  50.940   8.477  1.00 17.48           C  
ATOM    266  C   PRO A  34     -21.359  50.762   9.114  1.00 19.19           C  
ATOM    267  O   PRO A  34     -22.321  51.433   8.722  1.00 18.73           O  
ATOM    268  CB  PRO A  34     -19.299  52.181   9.055  1.00 24.57           C  
ATOM    269  CG  PRO A  34     -18.547  52.788   7.901  1.00 23.81           C  
ATOM    270  CD  PRO A  34     -19.347  52.466   6.673  1.00 18.77           C  
ATOM    271  N   VAL A  35     -21.436  49.863  10.097  1.00 18.28           N  
ATOM    272  CA  VAL A  35     -22.663  49.662  10.871  1.00 16.94           C  
ATOM    273  C   VAL A  35     -23.024  51.008  11.508  1.00 19.04           C  
ATOM    274  O   VAL A  35     -22.144  51.695  12.052  1.00 18.55           O  
ATOM    275  CB  VAL A  35     -22.456  48.590  11.958  1.00 16.49           C  
ATOM    276  CG1 VAL A  35     -23.566  48.611  13.039  1.00 25.21           C  
ATOM    277  CG2 VAL A  35     -22.345  47.196  11.326  1.00 21.01           C  
ATOM    278  N   ASP A  36     -24.304  51.381  11.391  1.00 22.42           N  
ATOM    279  CA  ASP A  36     -24.808  52.649  11.907  1.00 21.40           C  
ATOM    280  C   ASP A  36     -25.174  52.456  13.350  1.00 19.91           C  
ATOM    281  O   ASP A  36     -26.272  51.994  13.645  1.00 22.80           O  
ATOM    282  CB  ASP A  36     -26.059  53.078  11.157  1.00 20.22           C  
ATOM    283  CG  ASP A  36     -26.629  54.382  11.673  1.00 34.72           C  
ATOM    284  OD1 ASP A  36     -26.025  54.981  12.592  1.00 23.74           O  
ATOM    285  OD2 ASP A  36     -27.672  54.883  11.201  1.00 24.44           O  
ATOM    286  N   VAL A  37     -24.277  52.853  14.239  1.00 16.68           N  
ATOM    287  CA  VAL A  37     -24.430  52.552  15.655  1.00 21.34           C  
ATOM    288  C   VAL A  37     -25.402  53.526  16.322  1.00 19.00           C  
ATOM    289  O   VAL A  37     -25.666  53.419  17.502  1.00 22.42           O  
ATOM    290  CB  VAL A  37     -23.082  52.532  16.414  1.00 26.23           C  
ATOM    291  CG1 VAL A  37     -22.182  51.368  15.914  1.00 24.95           C  
ATOM    292  CG2 VAL A  37     -22.367  53.886  16.324  1.00 25.21           C  
ATOM    293  N   GLU A  38     -25.922  54.468  15.540  1.00 21.65           N  
ATOM    294  CA  GLU A  38     -26.942  55.381  16.039  1.00 25.11           C  
ATOM    295  C   GLU A  38     -28.352  54.808  15.872  1.00 27.51           C  
ATOM    296  O   GLU A  38     -29.321  55.373  16.390  1.00 23.69           O  
ATOM    297  CB  GLU A  38     -26.876  56.722  15.297  1.00 25.94           C  
ATOM    298  CG  GLU A  38     -25.554  57.466  15.352  1.00 32.90           C  
ATOM    299  CD  GLU A  38     -24.993  57.571  16.754  1.00 38.63           C  
ATOM    300  OE1 GLU A  38     -25.753  57.897  17.696  1.00 37.82           O  
ATOM    301  OE2 GLU A  38     -23.782  57.324  16.904  1.00 39.63           O  
ATOM    302  N   ALA A  39     -28.475  53.712  15.127  1.00 20.08           N  
ATOM    303  CA  ALA A  39     -29.784  53.147  14.772  1.00 22.71           C  
ATOM    304  C   ALA A  39     -30.400  52.395  15.929  1.00 17.10           C  
ATOM    305  O   ALA A  39     -29.684  51.890  16.789  1.00 17.56           O  
ATOM    306  CB  ALA A  39     -29.672  52.224  13.579  1.00 25.10           C  
ATOM    307  N   LEU A  40     -31.725  52.321  15.933  1.00 18.49           N  
ATOM    308  CA  LEU A  40     -32.442  51.624  17.005  1.00 22.00           C  
ATOM    309  C   LEU A  40     -31.995  50.172  17.039  1.00 22.13           C  
ATOM    310  O   LEU A  40     -31.973  49.505  15.997  1.00 22.89           O  
ATOM    311  CB  LEU A  40     -33.958  51.698  16.801  1.00 24.36           C  
ATOM    312  CG  LEU A  40     -34.806  51.052  17.913  1.00 28.20           C  
ATOM    313  CD1 LEU A  40     -34.704  51.748  19.278  1.00 21.92           C  
ATOM    314  CD2 LEU A  40     -36.253  50.964  17.469  1.00 26.17           C  
ATOM    315  N   GLY A  41     -31.618  49.710  18.230  1.00 19.34           N  
ATOM    316  CA  GLY A  41     -31.189  48.332  18.414  1.00 24.89           C  
ATOM    317  C   GLY A  41     -29.681  48.167  18.451  1.00 21.84           C  
ATOM    318  O   GLY A  41     -29.181  47.114  18.874  1.00 21.44           O  
ATOM    319  N   LEU A  42     -28.945  49.197  18.040  1.00 21.97           N  
ATOM    320  CA  LEU A  42     -27.482  49.073  17.939  1.00 21.62           C  
ATOM    321  C   LEU A  42     -26.743  49.800  19.051  1.00 20.53           C  
ATOM    322  O   LEU A  42     -25.562  50.085  18.920  1.00 21.74           O  
ATOM    323  CB  LEU A  42     -27.004  49.518  16.544  1.00 21.78           C  
ATOM    324  CG  LEU A  42     -27.438  48.531  15.443  1.00 22.76           C  
ATOM    325  CD1 LEU A  42     -27.386  49.143  14.070  1.00 30.27           C  
ATOM    326  CD2 LEU A  42     -26.525  47.298  15.490  1.00 26.85           C  
ATOM    327  N   HIS A  43     -27.444  50.100  20.150  1.00 21.65           N  
ATOM    328  CA  HIS A  43     -26.869  50.855  21.277  1.00 20.86           C  
ATOM    329  C   HIS A  43     -25.756  50.094  22.025  1.00 26.52           C  
ATOM    330  O   HIS A  43     -24.977  50.710  22.761  1.00 24.37           O  
ATOM    331  CB  HIS A  43     -27.966  51.204  22.307  1.00 20.16           C  
ATOM    332  CG  HIS A  43     -28.740  50.009  22.748  1.00 21.40           C  
ATOM    333  ND1 HIS A  43     -28.420  49.284  23.879  1.00 22.72           N  
ATOM    334  CD2 HIS A  43     -29.754  49.346  22.150  1.00 14.70           C  
ATOM    335  CE1 HIS A  43     -29.236  48.250  23.978  1.00 17.18           C  
ATOM    336  NE2 HIS A  43     -30.060  48.269  22.947  1.00 28.70           N  
ATOM    337  N   ASP A  44     -25.699  48.773  21.833  1.00 19.78           N  
ATOM    338  CA  ASP A  44     -24.686  47.901  22.428  1.00 20.90           C  
ATOM    339  C   ASP A  44     -23.622  47.434  21.429  1.00 20.87           C  
ATOM    340  O   ASP A  44     -22.765  46.628  21.777  1.00 18.68           O  
ATOM    341  CB  ASP A  44     -25.351  46.656  23.049  1.00 19.63           C  
ATOM    342  CG  ASP A  44     -26.209  45.888  22.049  1.00 24.13           C  
ATOM    343  OD1 ASP A  44     -26.380  46.372  20.903  1.00 22.81           O  
ATOM    344  OD2 ASP A  44     -26.774  44.800  22.316  1.00 24.72           O  
ATOM    345  N   TYR A  45     -23.691  47.908  20.188  1.00 15.90           N  
ATOM    346  CA  TYR A  45     -22.775  47.400  19.166  1.00 22.12           C  
ATOM    347  C   TYR A  45     -21.298  47.605  19.539  1.00 20.38           C  
ATOM    348  O   TYR A  45     -20.537  46.638  19.538  1.00 20.22           O  
ATOM    349  CB  TYR A  45     -23.070  48.037  17.804  1.00 17.49           C  
ATOM    350  CG  TYR A  45     -22.358  47.320  16.690  1.00 17.37           C  
ATOM    351  CD1 TYR A  45     -22.872  46.125  16.165  1.00 15.06           C  
ATOM    352  CD2 TYR A  45     -21.154  47.811  16.191  1.00 18.30           C  
ATOM    353  CE1 TYR A  45     -22.191  45.446  15.126  1.00 19.92           C  
ATOM    354  CE2 TYR A  45     -20.472  47.145  15.175  1.00 18.02           C  
ATOM    355  CZ  TYR A  45     -20.992  45.974  14.648  1.00 16.24           C  
ATOM    356  OH  TYR A  45     -20.304  45.334  13.630  1.00 16.80           O  
ATOM    357  N   CYS A  46     -20.905  48.846  19.855  1.00 22.78           N  
ATOM    358  CA  CYS A  46     -19.522  49.147  20.248  1.00 22.64           C  
ATOM    359  C   CYS A  46     -19.068  48.461  21.544  1.00 22.56           C  
ATOM    360  O   CYS A  46     -17.876  48.247  21.734  1.00 23.84           O  
ATOM    361  CB  CYS A  46     -19.234  50.655  20.303  1.00 23.30           C  
ATOM    362  SG  CYS A  46     -19.633  51.561  18.787  1.00 33.56           S  
ATOM    363  N   ASP A  47     -20.005  48.099  22.417  1.00 23.39           N  
ATOM    364  CA  ASP A  47     -19.702  47.294  23.604  1.00 23.79           C  
ATOM    365  C   ASP A  47     -19.186  45.897  23.235  1.00 28.50           C  
ATOM    366  O   ASP A  47     -18.320  45.336  23.925  1.00 28.95           O  
ATOM    367  CB  ASP A  47     -20.959  47.109  24.447  1.00 22.97           C  
ATOM    368  CG  ASP A  47     -21.345  48.354  25.221  1.00 37.22           C  
ATOM    369  OD1 ASP A  47     -20.573  49.336  25.234  1.00 32.29           O  
ATOM    370  OD2 ASP A  47     -22.412  48.418  25.866  1.00 28.41           O  
ATOM    371  N   ILE A  48     -19.734  45.350  22.151  1.00 21.45           N  
ATOM    372  CA  ILE A  48     -19.503  43.960  21.750  1.00 20.15           C  
ATOM    373  C   ILE A  48     -18.451  43.845  20.658  1.00 21.44           C  
ATOM    374  O   ILE A  48     -17.600  42.934  20.675  1.00 22.32           O  
ATOM    375  CB  ILE A  48     -20.853  43.307  21.313  1.00 19.79           C  
ATOM    376  CG1 ILE A  48     -21.778  43.148  22.531  1.00 24.97           C  
ATOM    377  CG2 ILE A  48     -20.616  41.924  20.670  1.00 22.37           C  
ATOM    378  CD1 ILE A  48     -23.260  43.139  22.184  1.00 22.38           C  
ATOM    379  N   ILE A  49     -18.478  44.794  19.734  1.00 18.16           N  
ATOM    380  CA  ILE A  49     -17.570  44.782  18.602  1.00 19.74           C  
ATOM    381  C   ILE A  49     -16.497  45.855  18.804  1.00 22.52           C  
ATOM    382  O   ILE A  49     -16.730  47.061  18.575  1.00 23.00           O  
ATOM    383  CB  ILE A  49     -18.375  44.989  17.295  1.00 18.11           C  
ATOM    384  CG1 ILE A  49     -19.233  43.761  16.987  1.00 19.84           C  
ATOM    385  CG2 ILE A  49     -17.457  45.271  16.101  1.00 24.03           C  
ATOM    386  CD1 ILE A  49     -20.548  43.781  17.620  1.00 37.41           C  
ATOM    387  N   LYS A  50     -15.314  45.401  19.225  1.00 23.25           N  
ATOM    388  CA  LYS A  50     -14.170  46.285  19.498  1.00 27.40           C  
ATOM    389  C   LYS A  50     -13.547  46.863  18.217  1.00 29.40           C  
ATOM    390  O   LYS A  50     -12.966  47.958  18.231  1.00 22.10           O  
ATOM    391  CB  LYS A  50     -13.116  45.504  20.320  1.00 31.04           C  
ATOM    392  CG  LYS A  50     -12.060  46.346  21.035  1.00 42.87           C  
ATOM    393  CD  LYS A  50     -11.059  45.449  21.770  1.00 45.26           C  
ATOM    394  CE  LYS A  50      -9.618  45.898  21.563  1.00 41.14           C  
ATOM    395  NZ  LYS A  50      -8.633  44.875  22.074  1.00 47.91           N  
ATOM    396  N   HIS A  51     -13.673  46.141  17.098  1.00 23.10           N  
ATOM    397  CA  HIS A  51     -13.044  46.576  15.844  1.00 21.47           C  
ATOM    398  C   HIS A  51     -13.981  46.456  14.631  1.00 23.03           C  
ATOM    399  O   HIS A  51     -13.920  45.462  13.884  1.00 20.11           O  
ATOM    400  CB  HIS A  51     -11.767  45.761  15.562  1.00 22.65           C  
ATOM    401  CG  HIS A  51     -10.777  45.763  16.687  1.00 31.30           C  
ATOM    402  ND1 HIS A  51      -9.948  46.835  16.941  1.00 31.88           N  
ATOM    403  CD2 HIS A  51     -10.475  44.821  17.614  1.00 32.51           C  
ATOM    404  CE1 HIS A  51      -9.183  46.555  17.983  1.00 29.45           C  
ATOM    405  NE2 HIS A  51      -9.480  45.340  18.407  1.00 36.70           N  
ATOM    406  N   PRO A  52     -14.830  47.458  14.425  1.00 19.60           N  
ATOM    407  CA  PRO A  52     -15.780  47.420  13.303  1.00 17.09           C  
ATOM    408  C   PRO A  52     -15.024  47.445  11.971  1.00 15.17           C  
ATOM    409  O   PRO A  52     -13.908  48.031  11.873  1.00 22.00           O  
ATOM    410  CB  PRO A  52     -16.647  48.666  13.520  1.00 20.83           C  
ATOM    411  CG  PRO A  52     -15.781  49.602  14.336  1.00 31.85           C  
ATOM    412  CD  PRO A  52     -14.946  48.703  15.220  1.00 23.66           C  
HETATM  413  N   MSE A  53     -15.623  46.830  10.951  1.00 17.70           N  
HETATM  414  CA  MSE A  53     -15.052  46.803   9.606  1.00 14.42           C  
HETATM  415  C   MSE A  53     -16.190  46.621   8.599  1.00 17.46           C  
HETATM  416  O   MSE A  53     -17.188  45.947   8.898  1.00 16.88           O  
HETATM  417  CB  MSE A  53     -14.035  45.641   9.514  1.00 15.96           C  
HETATM  418  CG  MSE A  53     -13.192  45.579   8.254  1.00 12.22           C  
HETATM  419 SE   MSE A  53     -12.351  47.259   7.734  1.00 23.91          SE  
HETATM  420  CE  MSE A  53     -11.398  47.553   9.421  1.00 17.74           C  
ATOM    421  N   ASP A  54     -16.023  47.213   7.414  1.00 15.24           N  
ATOM    422  CA  ASP A  54     -17.004  47.150   6.349  1.00 15.36           C  
ATOM    423  C   ASP A  54     -16.297  47.279   4.997  1.00 18.74           C  
ATOM    424  O   ASP A  54     -15.127  47.624   4.946  1.00 19.42           O  
ATOM    425  CB  ASP A  54     -17.980  48.312   6.516  1.00 16.82           C  
ATOM    426  CG  ASP A  54     -17.308  49.629   6.272  1.00 17.86           C  
ATOM    427  OD1 ASP A  54     -16.588  50.116   7.175  1.00 19.97           O  
ATOM    428  OD2 ASP A  54     -17.386  50.202   5.179  1.00 23.08           O  
HETATM  429  N   MSE A  55     -17.020  47.030   3.908  1.00 17.09           N  
HETATM  430  CA  MSE A  55     -16.380  46.959   2.594  1.00 14.40           C  
HETATM  431  C   MSE A  55     -15.837  48.317   2.097  1.00 20.31           C  
HETATM  432  O   MSE A  55     -14.813  48.356   1.434  1.00 18.52           O  
HETATM  433  CB  MSE A  55     -17.333  46.349   1.576  1.00 17.34           C  
HETATM  434  CG  MSE A  55     -17.615  44.839   1.846  1.00 16.46           C  
HETATM  435 SE   MSE A  55     -19.151  44.260   0.836  1.00 21.09          SE  
HETATM  436  CE  MSE A  55     -18.630  44.953  -0.934  1.00 15.26           C  
ATOM    437  N   SER A  56     -16.513  49.417   2.431  1.00 20.52           N  
ATOM    438  CA  SER A  56     -16.060  50.747   1.983  1.00 21.74           C  
ATOM    439  C   SER A  56     -14.757  51.130   2.671  1.00 19.91           C  
ATOM    440  O   SER A  56     -13.890  51.754   2.056  1.00 23.93           O  
ATOM    441  CB  SER A  56     -17.139  51.809   2.226  1.00 21.50           C  
ATOM    442  OG  SER A  56     -18.239  51.615   1.346  1.00 23.14           O  
ATOM    443  N   THR A  57     -14.624  50.765   3.943  1.00 17.56           N  
ATOM    444  CA  THR A  57     -13.387  50.977   4.682  1.00 17.87           C  
ATOM    445  C   THR A  57     -12.281  50.126   4.093  1.00 22.94           C  
ATOM    446  O   THR A  57     -11.155  50.612   3.896  1.00 19.84           O  
ATOM    447  CB  THR A  57     -13.565  50.684   6.170  1.00 18.54           C  
ATOM    448  OG1 THR A  57     -14.510  51.610   6.736  1.00 22.04           O  
ATOM    449  CG2 THR A  57     -12.279  50.969   6.945  1.00 21.17           C  
ATOM    450  N   ILE A  58     -12.591  48.859   3.789  1.00 17.50           N  
ATOM    451  CA  ILE A  58     -11.587  47.993   3.171  1.00 17.36           C  
ATOM    452  C   ILE A  58     -11.140  48.610   1.833  1.00 21.03           C  
ATOM    453  O   ILE A  58      -9.929  48.652   1.542  1.00 19.37           O  
ATOM    454  CB  ILE A  58     -12.108  46.521   3.010  1.00 16.16           C  
ATOM    455  CG1 ILE A  58     -12.309  45.877   4.380  1.00 19.08           C  
ATOM    456  CG2 ILE A  58     -11.124  45.680   2.159  1.00 14.89           C  
ATOM    457  CD1 ILE A  58     -12.997  44.491   4.328  1.00 17.87           C  
ATOM    458  N   LYS A  59     -12.101  49.116   1.053  1.00 17.34           N  
ATOM    459  CA  LYS A  59     -11.802  49.728  -0.254  1.00 24.59           C  
ATOM    460  C   LYS A  59     -10.838  50.905  -0.090  1.00 25.87           C  
ATOM    461  O   LYS A  59      -9.826  50.999  -0.798  1.00 25.06           O  
ATOM    462  CB  LYS A  59     -13.072  50.206  -0.975  1.00 25.01           C  
ATOM    463  CG  LYS A  59     -12.798  50.860  -2.354  1.00 25.25           C  
ATOM    464  CD  LYS A  59     -13.965  50.725  -3.314  1.00 32.55           C  
ATOM    465  CE  LYS A  59     -13.691  51.503  -4.622  1.00 36.34           C  
ATOM    466  NZ  LYS A  59     -14.729  52.561  -4.863  1.00 45.75           N  
ATOM    467  N   SER A  60     -11.143  51.779   0.863  1.00 23.49           N  
ATOM    468  CA  SER A  60     -10.276  52.927   1.145  1.00 27.00           C  
ATOM    469  C   SER A  60      -8.890  52.485   1.610  1.00 28.79           C  
ATOM    470  O   SER A  60      -7.898  53.108   1.243  1.00 26.05           O  
ATOM    471  CB  SER A  60     -10.905  53.863   2.191  1.00 27.11           C  
ATOM    472  OG  SER A  60     -12.213  54.234   1.801  1.00 34.01           O  
ATOM    473  N   LYS A  61      -8.818  51.410   2.396  1.00 22.74           N  
ATOM    474  CA  LYS A  61      -7.533  50.887   2.885  1.00 26.19           C  
ATOM    475  C   LYS A  61      -6.684  50.274   1.764  1.00 27.85           C  
ATOM    476  O   LYS A  61      -5.477  50.448   1.741  1.00 26.88           O  
ATOM    477  CB  LYS A  61      -7.712  49.892   4.049  1.00 24.98           C  
ATOM    478  CG  LYS A  61      -8.003  50.586   5.394  1.00 20.38           C  
ATOM    479  CD  LYS A  61      -8.184  49.636   6.570  1.00 21.48           C  
ATOM    480  CE  LYS A  61      -6.890  48.933   6.944  1.00 18.86           C  
ATOM    481  NZ  LYS A  61      -7.018  48.204   8.244  1.00 24.92           N  
ATOM    482  N   LEU A  62      -7.310  49.563   0.830  1.00 28.85           N  
ATOM    483  CA  LEU A  62      -6.602  49.103  -0.367  1.00 27.47           C  
ATOM    484  C   LEU A  62      -6.020  50.293  -1.125  1.00 34.21           C  
ATOM    485  O   LEU A  62      -4.843  50.291  -1.495  1.00 33.42           O  
ATOM    486  CB  LEU A  62      -7.563  48.383  -1.308  1.00 29.42           C  
ATOM    487  CG  LEU A  62      -7.849  46.915  -1.005  1.00 28.87           C  
ATOM    488  CD1 LEU A  62      -9.072  46.506  -1.805  1.00 28.34           C  
ATOM    489  CD2 LEU A  62      -6.623  46.030  -1.333  1.00 28.98           C  
ATOM    490  N   GLU A  63      -6.855  51.311  -1.329  1.00 30.53           N  
ATOM    491  CA  GLU A  63      -6.491  52.476  -2.141  1.00 29.95           C  
ATOM    492  C   GLU A  63      -5.437  53.350  -1.474  1.00 31.29           C  
ATOM    493  O   GLU A  63      -4.686  54.060  -2.153  1.00 35.80           O  
ATOM    494  CB  GLU A  63      -7.731  53.312  -2.454  1.00 31.13           C  
ATOM    495  CG  GLU A  63      -8.462  52.850  -3.699  1.00 32.58           C  
ATOM    496  CD  GLU A  63      -9.916  53.267  -3.730  1.00 36.52           C  
ATOM    497  OE1 GLU A  63     -10.338  54.107  -2.890  1.00 49.07           O  
ATOM    498  OE2 GLU A  63     -10.641  52.761  -4.611  1.00 44.40           O  
ATOM    499  N   SER A  64      -5.391  53.299  -0.149  1.00 30.79           N  
ATOM    500  CA  SER A  64      -4.401  54.024   0.630  1.00 31.87           C  
ATOM    501  C   SER A  64      -3.208  53.158   1.009  1.00 37.67           C  
ATOM    502  O   SER A  64      -2.391  53.552   1.872  1.00 31.73           O  
ATOM    503  CB  SER A  64      -5.058  54.618   1.878  1.00 32.78           C  
ATOM    504  OG  SER A  64      -5.910  55.684   1.487  1.00 40.53           O  
ATOM    505  N   ARG A  65      -3.141  51.977   0.379  1.00 31.82           N  
ATOM    506  CA  ARG A  65      -2.012  51.053   0.459  1.00 33.93           C  
ATOM    507  C   ARG A  65      -1.672  50.669   1.889  1.00 35.84           C  
ATOM    508  O   ARG A  65      -0.501  50.539   2.267  1.00 41.05           O  
ATOM    509  CB  ARG A  65      -0.814  51.631  -0.306  1.00 36.36           C  
ATOM    510  CG  ARG A  65      -1.174  51.872  -1.758  1.00 31.46           C  
ATOM    511  CD  ARG A  65       0.015  52.189  -2.664  1.00 51.85           C  
ATOM    512  NE  ARG A  65      -0.260  51.871  -4.069  1.00 52.50           N  
ATOM    513  CZ  ARG A  65       0.600  51.270  -4.896  1.00 55.02           C  
ATOM    514  NH1 ARG A  65       1.809  50.912  -4.469  1.00 54.99           N  
ATOM    515  NH2 ARG A  65       0.248  51.022  -6.160  1.00 57.91           N  
ATOM    516  N   GLU A  66      -2.730  50.466   2.667  1.00 29.52           N  
ATOM    517  CA  GLU A  66      -2.643  50.181   4.085  1.00 28.54           C  
ATOM    518  C   GLU A  66      -2.561  48.668   4.371  1.00 23.88           C  
ATOM    519  O   GLU A  66      -2.525  48.245   5.540  1.00 30.33           O  
ATOM    520  CB  GLU A  66      -3.869  50.819   4.756  1.00 28.66           C  
ATOM    521  CG  GLU A  66      -3.786  51.044   6.261  1.00 36.18           C  
ATOM    522  CD  GLU A  66      -4.746  52.120   6.765  1.00 42.70           C  
ATOM    523  OE1 GLU A  66      -5.062  53.074   5.996  1.00 43.65           O  
ATOM    524  OE2 GLU A  66      -5.187  52.013   7.939  1.00 50.70           O  
ATOM    525  N   TYR A  67      -2.596  47.850   3.317  1.00 21.50           N  
ATOM    526  CA  TYR A  67      -2.357  46.420   3.476  1.00 23.40           C  
ATOM    527  C   TYR A  67      -0.989  46.076   2.909  1.00 23.35           C  
ATOM    528  O   TYR A  67      -0.728  46.375   1.741  1.00 24.81           O  
ATOM    529  CB  TYR A  67      -3.451  45.588   2.781  1.00 20.80           C  
ATOM    530  CG  TYR A  67      -4.866  45.821   3.326  1.00 19.80           C  
ATOM    531  CD1 TYR A  67      -5.189  45.518   4.654  1.00 22.70           C  
ATOM    532  CD2 TYR A  67      -5.874  46.302   2.489  1.00 19.73           C  
ATOM    533  CE1 TYR A  67      -6.500  45.718   5.154  1.00 16.15           C  
ATOM    534  CE2 TYR A  67      -7.198  46.516   2.982  1.00 21.29           C  
ATOM    535  CZ  TYR A  67      -7.483  46.212   4.300  1.00 16.31           C  
ATOM    536  OH  TYR A  67      -8.751  46.418   4.815  1.00 20.82           O  
ATOM    537  N   ARG A  68      -0.147  45.441   3.735  1.00 24.84           N  
ATOM    538  CA  ARG A  68       1.201  44.999   3.356  1.00 23.25           C  
ATOM    539  C   ARG A  68       1.109  43.861   2.352  1.00 32.45           C  
ATOM    540  O   ARG A  68       1.929  43.736   1.450  1.00 28.76           O  
ATOM    541  CB  ARG A  68       1.998  44.496   4.575  1.00 32.04           C  
ATOM    542  CG  ARG A  68       2.546  45.582   5.502  1.00 33.90           C  
ATOM    543  CD  ARG A  68       3.628  45.101   6.489  1.00 30.72           C  
ATOM    544  NE  ARG A  68       3.142  44.107   7.465  1.00 32.63           N  
ATOM    545  CZ  ARG A  68       3.929  43.414   8.293  1.00 34.26           C  
ATOM    546  NH1 ARG A  68       5.234  43.621   8.270  1.00 30.37           N  
ATOM    547  NH2 ARG A  68       3.418  42.520   9.150  1.00 29.89           N  
ATOM    548  N   ASP A  69       0.093  43.023   2.506  1.00 29.24           N  
ATOM    549  CA  ASP A  69      -0.092  41.902   1.592  1.00 28.71           C  
ATOM    550  C   ASP A  69      -1.570  41.479   1.557  1.00 23.92           C  
ATOM    551  O   ASP A  69      -2.385  42.074   2.258  1.00 22.04           O  
ATOM    552  CB  ASP A  69       0.839  40.744   1.980  1.00 20.71           C  
ATOM    553  CG  ASP A  69       0.712  40.327   3.442  1.00 34.94           C  
ATOM    554  OD1 ASP A  69      -0.412  40.329   4.000  1.00 27.05           O  
ATOM    555  OD2 ASP A  69       1.689  39.933   4.117  1.00 33.68           O  
ATOM    556  N   ALA A  70      -1.886  40.469   0.744  1.00 20.10           N  
ATOM    557  CA  ALA A  70      -3.241  39.902   0.634  1.00 18.87           C  
ATOM    558  C   ALA A  70      -3.736  39.335   1.951  1.00 21.08           C  
ATOM    559  O   ALA A  70      -4.947  39.315   2.199  1.00 19.82           O  
ATOM    560  CB  ALA A  70      -3.274  38.810  -0.425  1.00 19.47           C  
ATOM    561  N   GLN A  71      -2.823  38.813   2.760  1.00 21.98           N  
ATOM    562  CA  GLN A  71      -3.185  38.245   4.060  1.00 24.17           C  
ATOM    563  C   GLN A  71      -3.788  39.323   4.979  1.00 20.63           C  
ATOM    564  O   GLN A  71      -4.772  39.067   5.675  1.00 19.61           O  
ATOM    565  CB  GLN A  71      -1.999  37.514   4.718  1.00 25.73           C  
ATOM    566  CG  GLN A  71      -1.527  36.244   3.961  1.00 30.15           C  
ATOM    567  CD  GLN A  71      -0.970  36.504   2.542  1.00 46.21           C  
ATOM    568  OE1 GLN A  71      -0.155  37.423   2.323  1.00 41.13           O  
ATOM    569  NE2 GLN A  71      -1.403  35.680   1.582  1.00 51.18           N  
ATOM    570  N   GLU A  72      -3.239  40.535   4.954  1.00 22.50           N  
ATOM    571  CA  GLU A  72      -3.823  41.620   5.769  1.00 21.42           C  
ATOM    572  C   GLU A  72      -5.198  42.037   5.241  1.00 22.46           C  
ATOM    573  O   GLU A  72      -6.124  42.328   6.026  1.00 20.22           O  
ATOM    574  CB  GLU A  72      -2.863  42.820   5.864  1.00 23.43           C  
ATOM    575  CG  GLU A  72      -1.527  42.416   6.481  1.00 19.22           C  
ATOM    576  CD  GLU A  72      -0.655  43.609   6.829  1.00 31.55           C  
ATOM    577  OE1 GLU A  72      -0.981  44.728   6.400  1.00 22.09           O  
ATOM    578  OE2 GLU A  72       0.356  43.416   7.530  1.00 34.44           O  
ATOM    579  N   PHE A  73      -5.341  42.061   3.914  1.00 22.36           N  
ATOM    580  CA  PHE A  73      -6.641  42.331   3.284  1.00 20.93           C  
ATOM    581  C   PHE A  73      -7.641  41.260   3.739  1.00 20.54           C  
ATOM    582  O   PHE A  73      -8.748  41.571   4.178  1.00 17.74           O  
ATOM    583  CB  PHE A  73      -6.517  42.344   1.750  1.00 18.38           C  
ATOM    584  CG  PHE A  73      -7.841  42.220   1.010  1.00 17.83           C  
ATOM    585  CD1 PHE A  73      -8.581  43.353   0.718  1.00 17.75           C  
ATOM    586  CD2 PHE A  73      -8.320  40.975   0.578  1.00 20.21           C  
ATOM    587  CE1 PHE A  73      -9.777  43.276   0.009  1.00 19.49           C  
ATOM    588  CE2 PHE A  73      -9.541  40.872  -0.136  1.00 17.51           C  
ATOM    589  CZ  PHE A  73     -10.268  42.026  -0.414  1.00 19.15           C  
ATOM    590  N   GLY A  74      -7.253  39.996   3.628  1.00 16.22           N  
ATOM    591  CA  GLY A  74      -8.165  38.915   3.992  1.00 18.09           C  
ATOM    592  C   GLY A  74      -8.569  38.968   5.455  1.00 20.37           C  
ATOM    593  O   GLY A  74      -9.694  38.628   5.798  1.00 16.70           O  
ATOM    594  N   ALA A  75      -7.645  39.386   6.325  1.00 17.78           N  
ATOM    595  CA  ALA A  75      -7.952  39.510   7.749  1.00 19.58           C  
ATOM    596  C   ALA A  75      -9.064  40.531   8.014  1.00 14.79           C  
ATOM    597  O   ALA A  75      -9.930  40.286   8.853  1.00 19.47           O  
ATOM    598  CB  ALA A  75      -6.687  39.839   8.574  1.00 19.36           C  
ATOM    599  N   ASP A  76      -9.051  41.644   7.304  1.00 19.13           N  
ATOM    600  CA  ASP A  76     -10.127  42.643   7.464  1.00 19.93           C  
ATOM    601  C   ASP A  76     -11.459  42.130   6.918  1.00 18.28           C  
ATOM    602  O   ASP A  76     -12.508  42.364   7.529  1.00 17.63           O  
ATOM    603  CB  ASP A  76      -9.779  43.956   6.776  1.00 19.32           C  
ATOM    604  CG  ASP A  76      -9.163  45.000   7.728  1.00 20.44           C  
ATOM    605  OD1 ASP A  76      -8.994  44.769   8.951  1.00 20.35           O  
ATOM    606  OD2 ASP A  76      -8.839  46.110   7.292  1.00 22.46           O  
ATOM    607  N   VAL A  77     -11.444  41.477   5.754  1.00 15.90           N  
ATOM    608  CA  VAL A  77     -12.684  40.825   5.269  1.00 15.59           C  
ATOM    609  C   VAL A  77     -13.219  39.824   6.293  1.00 17.17           C  
ATOM    610  O   VAL A  77     -14.401  39.816   6.586  1.00 16.14           O  
ATOM    611  CB  VAL A  77     -12.520  40.116   3.896  1.00 18.62           C  
ATOM    612  CG1 VAL A  77     -13.850  39.529   3.445  1.00 17.17           C  
ATOM    613  CG2 VAL A  77     -12.047  41.093   2.815  1.00 15.69           C  
ATOM    614  N   ARG A  78     -12.355  38.969   6.830  1.00 16.10           N  
ATOM    615  CA  ARG A  78     -12.811  37.993   7.821  1.00 19.59           C  
ATOM    616  C   ARG A  78     -13.215  38.634   9.135  1.00 18.07           C  
ATOM    617  O   ARG A  78     -14.116  38.147   9.800  1.00 16.73           O  
ATOM    618  CB  ARG A  78     -11.768  36.915   8.027  1.00 21.41           C  
ATOM    619  CG  ARG A  78     -11.539  36.131   6.727  1.00 17.45           C  
ATOM    620  CD  ARG A  78     -10.999  34.831   7.021  1.00 21.63           C  
ATOM    621  NE  ARG A  78     -10.781  34.029   5.821  1.00 22.17           N  
ATOM    622  CZ  ARG A  78      -9.591  33.824   5.295  1.00 21.12           C  
ATOM    623  NH1 ARG A  78      -8.510  34.389   5.822  1.00 22.38           N  
ATOM    624  NH2 ARG A  78      -9.475  33.044   4.241  1.00 16.70           N  
ATOM    625  N   LEU A  79     -12.555  39.733   9.502  1.00 16.15           N  
ATOM    626  CA  LEU A  79     -12.970  40.512  10.677  1.00 19.40           C  
ATOM    627  C   LEU A  79     -14.399  41.030  10.512  1.00 17.16           C  
ATOM    628  O   LEU A  79     -15.217  40.915  11.423  1.00 19.33           O  
ATOM    629  CB  LEU A  79     -12.013  41.700  10.888  1.00 20.98           C  
ATOM    630  CG  LEU A  79     -12.415  42.811  11.869  1.00 18.49           C  
ATOM    631  CD1 LEU A  79     -12.633  42.271  13.303  1.00 19.33           C  
ATOM    632  CD2 LEU A  79     -11.393  43.943  11.845  1.00 22.90           C  
HETATM  633  N   MSE A  80     -14.696  41.579   9.333  1.00 16.01           N  
HETATM  634  CA  MSE A  80     -16.057  42.035   9.002  1.00 18.55           C  
HETATM  635  C   MSE A  80     -17.065  40.904   9.186  1.00 16.15           C  
HETATM  636  O   MSE A  80     -18.154  41.086   9.787  1.00 13.90           O  
HETATM  637  CB  MSE A  80     -16.082  42.534   7.566  1.00 18.00           C  
HETATM  638  CG  MSE A  80     -17.447  42.959   7.038  1.00 19.61           C  
HETATM  639 SE   MSE A  80     -17.264  43.626   5.251  1.00 20.92          SE  
HETATM  640  CE  MSE A  80     -17.227  41.902   4.339  1.00 17.29           C  
ATOM    641  N   PHE A  81     -16.738  39.722   8.667  1.00 15.79           N  
ATOM    642  CA  PHE A  81     -17.712  38.639   8.791  1.00 12.07           C  
ATOM    643  C   PHE A  81     -17.828  38.165  10.236  1.00 13.13           C  
ATOM    644  O   PHE A  81     -18.930  37.907  10.731  1.00 13.29           O  
ATOM    645  CB  PHE A  81     -17.364  37.455   7.873  1.00 11.90           C  
ATOM    646  CG  PHE A  81     -17.558  37.758   6.421  1.00 15.65           C  
ATOM    647  CD1 PHE A  81     -18.754  38.315   5.972  1.00 14.02           C  
ATOM    648  CD2 PHE A  81     -16.554  37.475   5.495  1.00 16.98           C  
ATOM    649  CE1 PHE A  81     -18.951  38.602   4.629  1.00 18.96           C  
ATOM    650  CE2 PHE A  81     -16.758  37.775   4.134  1.00 19.35           C  
ATOM    651  CZ  PHE A  81     -17.959  38.331   3.719  1.00 17.93           C  
ATOM    652  N   SER A  82     -16.697  38.047  10.925  1.00 12.63           N  
ATOM    653  CA  SER A  82     -16.750  37.554  12.298  1.00 14.21           C  
ATOM    654  C   SER A  82     -17.506  38.549  13.175  1.00 13.91           C  
ATOM    655  O   SER A  82     -18.159  38.149  14.117  1.00 18.84           O  
ATOM    656  CB  SER A  82     -15.341  37.373  12.855  1.00 18.77           C  
ATOM    657  OG  SER A  82     -14.681  36.386  12.074  1.00 23.86           O  
ATOM    658  N   ASN A  83     -17.367  39.839  12.903  1.00 14.16           N  
ATOM    659  CA  ASN A  83     -18.158  40.836  13.650  1.00 15.68           C  
ATOM    660  C   ASN A  83     -19.658  40.566  13.550  1.00 17.64           C  
ATOM    661  O   ASN A  83     -20.414  40.638  14.549  1.00 17.69           O  
ATOM    662  CB  ASN A  83     -17.881  42.255  13.153  1.00 18.07           C  
ATOM    663  CG  ASN A  83     -16.540  42.780  13.608  1.00 17.64           C  
ATOM    664  OD1 ASN A  83     -15.936  42.237  14.532  1.00 16.65           O  
ATOM    665  ND2 ASN A  83     -16.066  43.857  12.961  1.00 15.50           N  
ATOM    666  N   CYS A  84     -20.087  40.236  12.335  1.00 14.64           N  
ATOM    667  CA  CYS A  84     -21.479  39.894  12.107  1.00 12.91           C  
ATOM    668  C   CYS A  84     -21.861  38.627  12.873  1.00 19.08           C  
ATOM    669  O   CYS A  84     -22.896  38.602  13.569  1.00 18.00           O  
ATOM    670  CB  CYS A  84     -21.726  39.744  10.593  1.00 15.77           C  
ATOM    671  SG  CYS A  84     -23.431  39.331  10.182  1.00 16.87           S  
ATOM    672  N   TYR A  85     -21.037  37.579  12.773  1.00 14.00           N  
ATOM    673  CA  TYR A  85     -21.341  36.361  13.510  1.00 15.64           C  
ATOM    674  C   TYR A  85     -21.318  36.570  15.018  1.00 16.21           C  
ATOM    675  O   TYR A  85     -22.100  35.937  15.703  1.00 18.88           O  
ATOM    676  CB  TYR A  85     -20.419  35.203  13.132  1.00 16.84           C  
ATOM    677  CG  TYR A  85     -20.322  34.942  11.656  1.00 14.49           C  
ATOM    678  CD1 TYR A  85     -21.454  34.959  10.849  1.00 17.99           C  
ATOM    679  CD2 TYR A  85     -19.082  34.652  11.060  1.00 16.38           C  
ATOM    680  CE1 TYR A  85     -21.368  34.704   9.462  1.00 18.70           C  
ATOM    681  CE2 TYR A  85     -18.994  34.403   9.683  1.00 17.20           C  
ATOM    682  CZ  TYR A  85     -20.127  34.435   8.905  1.00 22.54           C  
ATOM    683  OH  TYR A  85     -20.034  34.192   7.565  1.00 18.88           O  
ATOM    684  N   LYS A  86     -20.424  37.411  15.529  1.00 15.89           N  
ATOM    685  CA  LYS A  86     -20.342  37.658  16.988  1.00 18.80           C  
ATOM    686  C   LYS A  86     -21.560  38.418  17.537  1.00 22.03           C  
ATOM    687  O   LYS A  86     -22.138  38.072  18.597  1.00 17.74           O  
ATOM    688  CB  LYS A  86     -19.103  38.477  17.303  1.00 17.30           C  
ATOM    689  CG  LYS A  86     -18.798  38.638  18.798  1.00 17.02           C  
ATOM    690  CD  LYS A  86     -17.603  39.553  19.001  1.00 19.32           C  
ATOM    691  CE  LYS A  86     -17.346  39.677  20.497  1.00 30.27           C  
ATOM    692  NZ  LYS A  86     -16.011  40.237  20.800  1.00 37.31           N  
ATOM    693  N   TYR A  87     -21.940  39.455  16.812  1.00 19.55           N  
ATOM    694  CA  TYR A  87     -22.921  40.415  17.324  1.00 19.69           C  
ATOM    695  C   TYR A  87     -24.346  39.903  17.233  1.00 21.94           C  
ATOM    696  O   TYR A  87     -25.167  40.110  18.155  1.00 21.13           O  
ATOM    697  CB  TYR A  87     -22.805  41.770  16.587  1.00 20.75           C  
ATOM    698  CG  TYR A  87     -23.856  42.749  17.071  1.00 17.70           C  
ATOM    699  CD1 TYR A  87     -23.801  43.263  18.365  1.00 19.04           C  
ATOM    700  CD2 TYR A  87     -24.922  43.122  16.255  1.00 16.96           C  
ATOM    701  CE1 TYR A  87     -24.766  44.139  18.832  1.00 18.19           C  
ATOM    702  CE2 TYR A  87     -25.906  44.011  16.722  1.00 17.71           C  
ATOM    703  CZ  TYR A  87     -25.823  44.490  18.012  1.00 18.79           C  
ATOM    704  OH  TYR A  87     -26.788  45.366  18.493  1.00 20.90           O  
ATOM    705  N   ASN A  88     -24.657  39.247  16.116  1.00 20.17           N  
ATOM    706  CA  ASN A  88     -26.032  38.862  15.833  1.00 22.23           C  
ATOM    707  C   ASN A  88     -26.398  37.478  16.354  1.00 26.04           C  
ATOM    708  O   ASN A  88     -25.508  36.650  16.563  1.00 24.61           O  
ATOM    709  CB  ASN A  88     -26.325  39.004  14.334  1.00 20.94           C  
ATOM    710  CG  ASN A  88     -26.207  40.414  13.879  1.00 27.18           C  
ATOM    711  OD1 ASN A  88     -27.112  41.216  14.108  1.00 21.68           O  
ATOM    712  ND2 ASN A  88     -25.068  40.762  13.275  1.00 16.85           N  
ATOM    713  N   PRO A  89     -27.690  37.252  16.619  1.00 29.41           N  
ATOM    714  CA  PRO A  89     -28.213  35.901  16.878  1.00 29.43           C  
ATOM    715  C   PRO A  89     -27.985  34.992  15.663  1.00 27.07           C  
ATOM    716  O   PRO A  89     -28.141  35.442  14.532  1.00 28.50           O  
ATOM    717  CB  PRO A  89     -29.721  36.143  17.079  1.00 21.87           C  
ATOM    718  CG  PRO A  89     -29.806  37.539  17.535  1.00 32.51           C  
ATOM    719  CD  PRO A  89     -28.754  38.269  16.726  1.00 26.75           C  
ATOM    720  N   PRO A  90     -27.626  33.735  15.894  1.00 33.73           N  
ATOM    721  CA  PRO A  90     -27.311  32.808  14.802  1.00 29.17           C  
ATOM    722  C   PRO A  90     -28.434  32.590  13.773  1.00 27.58           C  
ATOM    723  O   PRO A  90     -28.117  32.291  12.617  1.00 30.17           O  
ATOM    724  CB  PRO A  90     -26.958  31.514  15.540  1.00 29.12           C  
ATOM    725  CG  PRO A  90     -26.546  31.961  16.879  1.00 32.19           C  
ATOM    726  CD  PRO A  90     -27.452  33.101  17.214  1.00 32.88           C  
ATOM    727  N   ASP A  91     -29.698  32.780  14.151  1.00 30.03           N  
ATOM    728  CA  ASP A  91     -30.817  32.652  13.195  1.00 27.60           C  
ATOM    729  C   ASP A  91     -31.195  33.961  12.521  1.00 29.18           C  
ATOM    730  O   ASP A  91     -32.197  34.030  11.804  1.00 35.74           O  
ATOM    731  CB  ASP A  91     -32.058  31.986  13.841  1.00 31.32           C  
ATOM    732  CG  ASP A  91     -32.599  32.748  15.064  1.00 45.31           C  
ATOM    733  OD1 ASP A  91     -31.994  33.761  15.492  1.00 44.85           O  
ATOM    734  OD2 ASP A  91     -33.642  32.391  15.669  1.00 39.98           O  
ATOM    735  N   HIS A  92     -30.394  35.004  12.745  1.00 29.06           N  
ATOM    736  CA  HIS A  92     -30.682  36.322  12.171  1.00 27.99           C  
ATOM    737  C   HIS A  92     -30.465  36.284  10.670  1.00 24.96           C  
ATOM    738  O   HIS A  92     -29.498  35.681  10.191  1.00 22.85           O  
ATOM    739  CB  HIS A  92     -29.808  37.406  12.809  1.00 24.62           C  
ATOM    740  CG  HIS A  92     -30.310  38.803  12.587  1.00 29.17           C  
ATOM    741  ND1 HIS A  92     -30.379  39.384  11.339  1.00 26.29           N  
ATOM    742  CD2 HIS A  92     -30.760  39.737  13.457  1.00 29.40           C  
ATOM    743  CE1 HIS A  92     -30.856  40.612  11.448  1.00 34.32           C  
ATOM    744  NE2 HIS A  92     -31.092  40.851  12.725  1.00 37.61           N  
ATOM    745  N   GLU A  93     -31.356  36.930   9.920  1.00 26.49           N  
ATOM    746  CA  GLU A  93     -31.232  36.934   8.464  1.00 22.47           C  
ATOM    747  C   GLU A  93     -29.892  37.482   7.970  1.00 22.49           C  
ATOM    748  O   GLU A  93     -29.426  37.097   6.897  1.00 23.62           O  
ATOM    749  CB  GLU A  93     -32.403  37.643   7.788  1.00 27.76           C  
ATOM    750  CG  GLU A  93     -32.496  39.152   7.921  1.00 28.00           C  
ATOM    751  CD  GLU A  93     -33.768  39.685   7.273  1.00 47.13           C  
ATOM    752  OE1 GLU A  93     -34.574  40.314   7.991  1.00 49.86           O  
ATOM    753  OE2 GLU A  93     -33.975  39.454   6.051  1.00 51.39           O  
ATOM    754  N   VAL A  94     -29.280  38.370   8.751  1.00 21.96           N  
ATOM    755  CA  VAL A  94     -28.014  38.969   8.328  1.00 22.88           C  
ATOM    756  C   VAL A  94     -26.852  37.988   8.396  1.00 21.52           C  
ATOM    757  O   VAL A  94     -25.884  38.114   7.626  1.00 21.41           O  
ATOM    758  CB  VAL A  94     -27.705  40.287   9.073  1.00 23.02           C  
ATOM    759  CG1 VAL A  94     -27.253  40.023  10.494  1.00 18.19           C  
ATOM    760  CG2 VAL A  94     -26.644  41.128   8.300  1.00 18.67           C  
ATOM    761  N   VAL A  95     -26.926  37.027   9.323  1.00 19.83           N  
ATOM    762  CA  VAL A  95     -25.904  35.987   9.415  1.00 21.94           C  
ATOM    763  C   VAL A  95     -25.903  35.126   8.156  1.00 21.28           C  
ATOM    764  O   VAL A  95     -24.835  34.817   7.599  1.00 20.34           O  
ATOM    765  CB  VAL A  95     -26.127  35.104  10.668  1.00 21.09           C  
ATOM    766  CG1 VAL A  95     -25.199  33.875  10.664  1.00 23.40           C  
ATOM    767  CG2 VAL A  95     -25.953  35.916  11.908  1.00 19.91           C  
ATOM    768  N   ALA A  96     -27.094  34.735   7.703  1.00 23.57           N  
ATOM    769  CA  ALA A  96     -27.230  34.017   6.424  1.00 22.29           C  
ATOM    770  C   ALA A  96     -26.681  34.808   5.239  1.00 20.82           C  
ATOM    771  O   ALA A  96     -26.056  34.237   4.337  1.00 22.93           O  
ATOM    772  CB  ALA A  96     -28.716  33.638   6.152  1.00 23.28           C  
HETATM  773  N   MSE A  97     -26.933  36.108   5.222  1.00 18.59           N  
HETATM  774  CA  MSE A  97     -26.375  36.956   4.175  1.00 18.76           C  
HETATM  775  C   MSE A  97     -24.836  36.997   4.239  1.00 20.17           C  
HETATM  776  O   MSE A  97     -24.176  36.891   3.211  1.00 19.95           O  
HETATM  777  CB  MSE A  97     -26.968  38.358   4.224  1.00 17.12           C  
HETATM  778  CG  MSE A  97     -28.422  38.375   3.812  1.00 20.70           C  
HETATM  779 SE   MSE A  97     -29.147  40.159   4.096  1.00 33.08          SE  
HETATM  780  CE  MSE A  97     -29.791  39.886   5.446  1.00 19.32           C  
ATOM    781  N   ALA A  98     -24.278  37.177   5.438  1.00 17.31           N  
ATOM    782  CA  ALA A  98     -22.817  37.112   5.608  1.00 18.36           C  
ATOM    783  C   ALA A  98     -22.259  35.801   5.062  1.00 20.56           C  
ATOM    784  O   ALA A  98     -21.204  35.774   4.417  1.00 19.08           O  
ATOM    785  CB  ALA A  98     -22.435  37.271   7.087  1.00 15.74           C  
ATOM    786  N   ARG A  99     -22.967  34.705   5.307  1.00 20.65           N  
ATOM    787  CA  ARG A  99     -22.518  33.397   4.803  1.00 25.52           C  
ATOM    788  C   ARG A  99     -22.469  33.328   3.299  1.00 21.22           C  
ATOM    789  O   ARG A  99     -21.477  32.841   2.746  1.00 19.58           O  
ATOM    790  CB  ARG A  99     -23.383  32.249   5.315  1.00 20.61           C  
ATOM    791  CG  ARG A  99     -23.006  31.824   6.687  1.00 30.54           C  
ATOM    792  CD  ARG A  99     -23.702  30.559   7.156  1.00 25.05           C  
ATOM    793  NE  ARG A  99     -23.537  30.487   8.602  1.00 42.49           N  
ATOM    794  CZ  ARG A  99     -24.529  30.448   9.479  1.00 37.71           C  
ATOM    795  NH1 ARG A  99     -25.802  30.447   9.081  1.00 36.79           N  
ATOM    796  NH2 ARG A  99     -24.230  30.410  10.764  1.00 30.22           N  
ATOM    797  N   LYS A 100     -23.510  33.828   2.633  1.00 20.79           N  
ATOM    798  CA  LYS A 100     -23.486  33.882   1.174  1.00 19.72           C  
ATOM    799  C   LYS A 100     -22.334  34.723   0.649  1.00 23.78           C  
ATOM    800  O   LYS A 100     -21.686  34.366  -0.340  1.00 19.81           O  
ATOM    801  CB  LYS A 100     -24.818  34.394   0.613  1.00 19.08           C  
ATOM    802  CG  LYS A 100     -25.940  33.392   0.764  1.00 22.20           C  
ATOM    803  CD  LYS A 100     -27.268  34.050   0.448  1.00 23.97           C  
ATOM    804  CE  LYS A 100     -28.393  33.042   0.541  1.00 41.13           C  
ATOM    805  NZ  LYS A 100     -29.712  33.708   0.406  1.00 35.29           N  
ATOM    806  N   LEU A 101     -22.102  35.857   1.291  1.00 17.37           N  
ATOM    807  CA  LEU A 101     -21.044  36.741   0.839  1.00 19.75           C  
ATOM    808  C   LEU A 101     -19.677  36.160   1.138  1.00 15.98           C  
ATOM    809  O   LEU A 101     -18.790  36.255   0.286  1.00 15.87           O  
ATOM    810  CB  LEU A 101     -21.192  38.149   1.404  1.00 14.99           C  
ATOM    811  CG  LEU A 101     -20.247  39.183   0.775  1.00 21.25           C  
ATOM    812  CD1 LEU A 101     -20.453  39.273  -0.725  1.00 19.14           C  
ATOM    813  CD2 LEU A 101     -20.400  40.523   1.473  1.00 19.60           C  
ATOM    814  N   GLN A 102     -19.522  35.514   2.301  1.00 12.17           N  
ATOM    815  CA  GLN A 102     -18.238  34.894   2.648  1.00 17.33           C  
ATOM    816  C   GLN A 102     -17.919  33.754   1.712  1.00 20.02           C  
ATOM    817  O   GLN A 102     -16.760  33.524   1.395  1.00 16.68           O  
ATOM    818  CB  GLN A 102     -18.186  34.468   4.109  1.00 17.37           C  
ATOM    819  CG  GLN A 102     -16.802  33.911   4.516  1.00 17.71           C  
ATOM    820  CD  GLN A 102     -16.579  33.870   6.004  1.00 21.26           C  
ATOM    821  OE1 GLN A 102     -17.526  33.929   6.781  1.00 22.22           O  
ATOM    822  NE2 GLN A 102     -15.326  33.761   6.414  1.00 22.64           N  
ATOM    823  N   ASP A 103     -18.972  33.089   1.217  1.00 17.78           N  
ATOM    824  CA  ASP A 103     -18.853  32.106   0.145  1.00 24.39           C  
ATOM    825  C   ASP A 103     -18.112  32.686  -1.038  1.00 15.38           C  
ATOM    826  O   ASP A 103     -17.175  32.064  -1.529  1.00 20.35           O  
ATOM    827  CB  ASP A 103     -20.248  31.624  -0.337  1.00 20.51           C  
ATOM    828  CG  ASP A 103     -20.869  30.571   0.574  1.00 37.17           C  
ATOM    829  OD1 ASP A 103     -20.198  30.096   1.525  1.00 31.35           O  
ATOM    830  OD2 ASP A 103     -22.034  30.145   0.406  1.00 41.90           O  
ATOM    831  N   VAL A 104     -18.554  33.859  -1.516  1.00 13.61           N  
ATOM    832  CA  VAL A 104     -17.945  34.514  -2.686  1.00 17.96           C  
ATOM    833  C   VAL A 104     -16.486  34.779  -2.368  1.00 19.11           C  
ATOM    834  O   VAL A 104     -15.590  34.429  -3.146  1.00 16.85           O  
ATOM    835  CB  VAL A 104     -18.628  35.875  -3.031  1.00 20.03           C  
ATOM    836  CG1 VAL A 104     -17.871  36.615  -4.189  1.00 19.00           C  
ATOM    837  CG2 VAL A 104     -20.085  35.678  -3.376  1.00 30.83           C  
ATOM    838  N   PHE A 105     -16.252  35.401  -1.213  1.00 17.00           N  
ATOM    839  CA  PHE A 105     -14.902  35.811  -0.842  1.00 15.08           C  
ATOM    840  C   PHE A 105     -13.944  34.617  -0.714  1.00 18.00           C  
ATOM    841  O   PHE A 105     -12.827  34.629  -1.272  1.00 13.75           O  
ATOM    842  CB  PHE A 105     -14.915  36.598   0.477  1.00 15.28           C  
ATOM    843  CG  PHE A 105     -13.559  36.709   1.085  1.00 13.53           C  
ATOM    844  CD1 PHE A 105     -12.639  37.592   0.542  1.00 16.61           C  
ATOM    845  CD2 PHE A 105     -13.172  35.870   2.122  1.00 12.87           C  
ATOM    846  CE1 PHE A 105     -11.355  37.684   1.062  1.00 14.74           C  
ATOM    847  CE2 PHE A 105     -11.872  35.951   2.656  1.00 15.47           C  
ATOM    848  CZ  PHE A 105     -10.981  36.867   2.123  1.00 13.99           C  
ATOM    849  N   GLU A 106     -14.359  33.572   0.007  1.00 15.41           N  
ATOM    850  CA  GLU A 106     -13.447  32.457   0.267  1.00 15.40           C  
ATOM    851  C   GLU A 106     -13.026  31.725  -1.006  1.00 15.32           C  
ATOM    852  O   GLU A 106     -11.837  31.334  -1.173  1.00 16.82           O  
ATOM    853  CB  GLU A 106     -14.040  31.456   1.268  1.00 15.92           C  
ATOM    854  CG  GLU A 106     -14.242  32.006   2.707  1.00 18.43           C  
ATOM    855  CD  GLU A 106     -12.974  32.356   3.475  1.00 16.92           C  
ATOM    856  OE1 GLU A 106     -11.875  31.903   3.102  1.00 20.50           O  
ATOM    857  OE2 GLU A 106     -13.082  33.077   4.500  1.00 19.01           O  
HETATM  858  N   MSE A 107     -13.980  31.558  -1.897  1.00 17.14           N  
HETATM  859  CA  MSE A 107     -13.715  30.909  -3.176  1.00 20.33           C  
HETATM  860  C   MSE A 107     -12.739  31.749  -4.009  1.00 23.11           C  
HETATM  861  O   MSE A 107     -11.750  31.230  -4.502  1.00 18.50           O  
HETATM  862  CB  MSE A 107     -15.003  30.649  -3.952  1.00 20.60           C  
HETATM  863  CG  MSE A 107     -14.752  29.956  -5.275  1.00 28.05           C  
HETATM  864 SE   MSE A 107     -14.096  28.113  -5.024  1.00 39.59          SE  
HETATM  865  CE  MSE A 107     -12.256  28.412  -4.764  1.00 46.50           C  
ATOM    866  N   ARG A 108     -12.982  33.048  -4.133  1.00 15.22           N  
ATOM    867  CA  ARG A 108     -12.061  33.872  -4.929  1.00 13.47           C  
ATOM    868  C   ARG A 108     -10.676  33.974  -4.316  1.00 16.62           C  
ATOM    869  O   ARG A 108      -9.671  33.905  -5.024  1.00 17.94           O  
ATOM    870  CB  ARG A 108     -12.620  35.280  -5.137  1.00 14.61           C  
ATOM    871  CG  ARG A 108     -13.862  35.338  -6.007  1.00 19.26           C  
ATOM    872  CD  ARG A 108     -13.595  34.830  -7.437  1.00 21.25           C  
ATOM    873  NE  ARG A 108     -14.654  35.224  -8.370  1.00 22.09           N  
ATOM    874  CZ  ARG A 108     -14.739  34.778  -9.614  1.00 21.63           C  
ATOM    875  NH1 ARG A 108     -13.845  33.894 -10.062  1.00 18.56           N  
ATOM    876  NH2 ARG A 108     -15.735  35.182 -10.394  1.00 22.87           N  
ATOM    877  N   PHE A 109     -10.634  34.132  -2.994  1.00 15.16           N  
ATOM    878  CA  PHE A 109      -9.391  34.332  -2.257  1.00 18.84           C  
ATOM    879  C   PHE A 109      -8.522  33.083  -2.317  1.00 17.50           C  
ATOM    880  O   PHE A 109      -7.270  33.146  -2.343  1.00 19.07           O  
ATOM    881  CB  PHE A 109      -9.733  34.631  -0.808  1.00 13.26           C  
ATOM    882  CG  PHE A 109      -8.596  35.250  -0.013  1.00 15.65           C  
ATOM    883  CD1 PHE A 109      -8.059  36.494  -0.364  1.00 20.58           C  
ATOM    884  CD2 PHE A 109      -8.105  34.595   1.115  1.00 18.72           C  
ATOM    885  CE1 PHE A 109      -7.046  37.069   0.393  1.00 19.58           C  
ATOM    886  CE2 PHE A 109      -7.076  35.154   1.881  1.00 21.88           C  
ATOM    887  CZ  PHE A 109      -6.543  36.403   1.509  1.00 20.22           C  
ATOM    888  N   ALA A 110      -9.195  31.944  -2.346  1.00 17.23           N  
ATOM    889  CA  ALA A 110      -8.518  30.659  -2.388  1.00 16.82           C  
ATOM    890  C   ALA A 110      -7.891  30.401  -3.748  1.00 18.89           C  
ATOM    891  O   ALA A 110      -6.889  29.689  -3.844  1.00 20.34           O  
ATOM    892  CB  ALA A 110      -9.519  29.536  -2.063  1.00 20.29           C  
ATOM    893  N   LYS A 111      -8.526  30.918  -4.798  1.00 20.17           N  
ATOM    894  CA  LYS A 111      -8.144  30.584  -6.187  1.00 24.52           C  
ATOM    895  C   LYS A 111      -7.185  31.606  -6.758  1.00 29.24           C  
ATOM    896  O   LYS A 111      -6.716  31.453  -7.883  1.00 30.76           O  
ATOM    897  CB  LYS A 111      -9.362  30.503  -7.116  1.00 22.78           C  
ATOM    898  CG  LYS A 111     -10.281  29.295  -6.911  1.00 26.09           C  
ATOM    899  CD  LYS A 111      -9.916  28.107  -7.748  1.00 24.94           C  
ATOM    900  CE  LYS A 111     -10.740  26.860  -7.393  1.00 31.91           C  
ATOM    901  NZ  LYS A 111     -12.157  26.976  -7.844  1.00 42.39           N  
HETATM  902  N   MSE A 112      -6.941  32.665  -5.992  1.00 27.34           N  
HETATM  903  CA  MSE A 112      -5.934  33.668  -6.292  1.00 30.09           C  
HETATM  904  C   MSE A 112      -4.568  32.994  -6.491  1.00 30.27           C  
HETATM  905  O   MSE A 112      -4.141  32.191  -5.657  1.00 35.62           O  
HETATM  906  CB  MSE A 112      -5.878  34.652  -5.126  1.00 30.17           C  
HETATM  907  CG  MSE A 112      -4.835  35.723  -5.218  1.00 32.46           C  
HETATM  908 SE   MSE A 112      -5.074  36.953  -3.718  1.00 34.47          SE  
HETATM  909  CE  MSE A 112      -4.729  35.825  -2.229  1.00 26.73           C  
ATOM    910  N   PRO A 113      -3.897  33.308  -7.600  1.00 31.91           N  
ATOM    911  CA  PRO A 113      -2.590  32.708  -7.899  1.00 35.80           C  
ATOM    912  C   PRO A 113      -1.510  33.093  -6.894  1.00 38.57           C  
ATOM    913  O   PRO A 113      -1.594  34.161  -6.276  1.00 37.34           O  
ATOM    914  CB  PRO A 113      -2.265  33.261  -9.290  1.00 35.16           C  
ATOM    915  CG  PRO A 113      -3.612  33.638  -9.862  1.00 38.32           C  
ATOM    916  CD  PRO A 113      -4.339  34.219  -8.671  1.00 27.15           C  
ATOM    917  N   ASP A 114      -0.534  32.201  -6.705  1.00 44.56           N  
ATOM    918  CA  ASP A 114       0.709  32.534  -5.995  1.00 45.53           C  
ATOM    919  C   ASP A 114       1.945  31.788  -6.506  1.00 49.51           C  
ATOM    920  O   ASP A 114       2.981  32.413  -6.770  1.00 49.78           O  
ATOM    921  CB  ASP A 114       0.578  32.430  -4.462  1.00 51.80           C  
ATOM    922  CG  ASP A 114       0.144  31.056  -3.979  1.00 46.39           C  
ATOM    923  OD1 ASP A 114       0.471  30.037  -4.630  1.00 49.17           O  
ATOM    924  OD2 ASP A 114      -0.520  30.906  -2.924  1.00 50.60           O  
ATOM    925  OXT ASP A 114       1.920  30.562  -6.662  1.00 51.11           O  
TER     926      ASP A 114                                                      
END
MOLECULE T0432.pdb
ATOM      1  N   SER     1      12.703  45.910  -3.320  1.00 50.93           N
ATOM      2  CA  SER     1      13.109  46.216  -4.712  1.00 47.13           C
ATOM      4  CB  SER     1      13.709  44.967  -5.358  1.00 53.53           C
ATOM      7  OG  SER     1      12.759  43.911  -5.430  1.00 42.48           O
ATOM      9  C   SER     1      11.931  46.715  -5.566  1.00 52.43           C
ATOM     10  O   SER     1      10.768  46.719  -5.114  1.00 45.72           O
ATOM     14  N   MET     2      12.255  47.142  -6.791  1.00 48.01           N
ATOM     15  CA  MET     2      11.257  47.418  -7.836  1.00 53.09           C
ATOM     17  CB  MET     2      11.927  47.928  -9.120  1.00 51.71           C
ATOM     23  C   MET     2      10.424  46.169  -8.153  1.00 49.18           C
ATOM     24  O   MET     2       9.206  46.267  -8.286  1.00 51.00           O
ATOM     26  N   GLN     3      11.078  45.011  -8.268  1.00 44.90           N
ATOM     27  CA  GLN     3      10.368  43.738  -8.433  1.00 49.87           C
ATOM     29  CB  GLN     3      11.334  42.538  -8.524  1.00 49.44           C
ATOM     32  CG  GLN     3      11.990  42.326  -9.886  1.00 56.96           C
ATOM     38  C   GLN     3       9.361  43.512  -7.283  1.00 43.65           C
ATOM     39  O   GLN     3       8.242  43.071  -7.521  1.00 37.83           O
ATOM     41  N   GLU     4       9.764  43.812  -6.049  1.00 34.49           N
ATOM     42  CA  GLU     4       8.896  43.571  -4.909  1.00 28.57           C
ATOM     44  CB  GLU     4       9.695  43.588  -3.619  1.00 30.35           C
ATOM     47  CG  GLU     4      10.564  42.317  -3.478  1.00 32.03           C
ATOM     50  CD  GLU     4      11.497  42.362  -2.284  1.00 34.53           C
ATOM     51  OE1 GLU     4      11.564  43.415  -1.624  1.00 39.92           O
ATOM     52  OE2 GLU     4      12.167  41.335  -2.002  1.00 35.71           O
ATOM     53  C   GLU     4       7.708  44.529  -4.871  1.00 25.78           C
ATOM     54  O   GLU     4       6.586  44.106  -4.548  1.00 21.89           O
ATOM     56  N   GLU     5       7.958  45.807  -5.172  1.00 27.67           N
ATOM     57  CA  GLU     5       6.900  46.803  -5.275  1.00 29.37           C
ATOM     59  CB  GLU     5       7.492  48.200  -5.504  1.00 32.93           C
ATOM     62  CG  GLU     5       8.329  48.698  -4.321  1.00 36.17           C
ATOM     68  C   GLU     5       5.841  46.464  -6.357  1.00 26.28           C
ATOM     69  O   GLU     5       4.652  46.729  -6.168  1.00 24.25           O
ATOM     71  N   ASP     6       6.276  45.882  -7.472  1.00 23.77           N
ATOM     72  CA  ASP     6       5.354  45.408  -8.499  1.00 26.67           C
ATOM     74  CB  ASP     6       6.099  44.978  -9.756  1.00 25.76           C
ATOM     77  CG  ASP     6       6.749  46.165 -10.526  1.00 24.96           C
ATOM     78  OD1 ASP     6       6.374  47.338 -10.325  1.00 41.80           O
ATOM     79  OD2 ASP     6       7.653  45.870 -11.317  1.00 39.42           O
ATOM     80  C   ASP     6       4.501  44.208  -7.998  1.00 20.23           C
ATOM     81  O   ASP     6       3.358  44.093  -8.388  1.00 20.47           O
ATOM     83  N   THR     7       5.093  43.319  -7.201  1.00 22.25           N
ATOM     84  CA  THR     7       4.384  42.184  -6.606  1.00 22.70           C
ATOM     86  CB  THR     7       5.332  41.245  -5.780  1.00 22.94           C
ATOM     88  OG1 THR     7       6.367  40.712  -6.630  1.00 26.30           O
ATOM     90  CG2 THR     7       4.556  40.047  -5.132  1.00 16.87           C
ATOM     94  C   THR     7       3.250  42.693  -5.726  1.00 21.27           C
ATOM     95  O   THR     7       2.114  42.227  -5.839  1.00 18.76           O
ATOM     97  N   PHE     8       3.574  43.615  -4.823  1.00 19.23           N
ATOM     98  CA  PHE     8       2.558  44.181  -3.944  1.00 19.60           C
ATOM    100  CB  PHE     8       3.176  45.001  -2.822  1.00 22.71           C
ATOM    103  CG  PHE     8       3.951  44.177  -1.823  1.00 23.51           C
ATOM    104  CD1 PHE     8       3.439  42.949  -1.346  1.00 28.77           C
ATOM    106  CE1 PHE     8       4.152  42.173  -0.434  1.00 28.06           C
ATOM    108  CZ  PHE     8       5.373  42.635   0.031  1.00 28.78           C
ATOM    110  CE2 PHE     8       5.884  43.835  -0.423  1.00 30.30           C
ATOM    112  CD2 PHE     8       5.169  44.616  -1.353  1.00 28.10           C
ATOM    114  C   PHE     8       1.496  44.993  -4.689  1.00 22.06           C
ATOM    115  O   PHE     8       0.320  44.959  -4.316  1.00 17.45           O
ATOM    117  N   ARG     9       1.904  45.735  -5.712  1.00 20.32           N
ATOM    118  CA  ARG     9       0.939  46.442  -6.556  1.00 18.47           C
ATOM    120  CB  ARG     9       1.639  47.343  -7.542  1.00 20.96           C
ATOM    123  CG  ARG     9       0.718  48.210  -8.324  1.00 30.12           C
ATOM    126  CD  ARG     9       1.462  49.336  -8.973  1.00 33.72           C
ATOM    129  NE  ARG     9       0.560  50.358  -9.495  1.00 49.38           N
ATOM    131  CZ  ARG     9      -0.009  50.371 -10.710  1.00 50.88           C
ATOM    132  NH1 ARG     9       0.198  49.411 -11.626  1.00 36.54           N
ATOM    135  NH2 ARG     9      -0.779  51.400 -11.024  1.00 35.58           N
ATOM    138  C   ARG     9      -0.005  45.464  -7.267  1.00 18.25           C
ATOM    139  O   ARG     9      -1.217  45.710  -7.282  1.00 15.91           O
ATOM    141  N   GLU    10       0.522  44.363  -7.832  1.00 15.31           N
ATOM    142  CA  GLU    10      -0.351  43.339  -8.413  1.00 19.50           C
ATOM    144  CB  GLU    10       0.439  42.219  -9.076  1.00 21.24           C
ATOM    147  CG  GLU    10      -0.467  41.097  -9.566  1.00 23.10           C
ATOM    150  CD  GLU    10       0.189  40.117 -10.508  1.00 33.77           C
ATOM    151  OE1 GLU    10      -0.487  39.118 -10.845  1.00 26.89           O
ATOM    152  OE2 GLU    10       1.358  40.328 -10.890  1.00 26.18           O
ATOM    153  C   GLU    10      -1.355  42.768  -7.382  1.00 23.48           C
ATOM    154  O   GLU    10      -2.548  42.617  -7.692  1.00 16.96           O
ATOM    156  N   LEU    11      -0.871  42.447  -6.176  1.00 22.33           N
ATOM    157  CA  LEU    11      -1.756  42.020  -5.079  1.00 17.97           C
ATOM    159  CB  LEU    11      -0.969  41.736  -3.779  1.00 21.21           C
ATOM    162  CG  LEU    11      -1.851  41.320  -2.564  1.00 18.71           C
ATOM    164  CD1 LEU    11      -2.569  39.975  -2.827  1.00 16.49           C
ATOM    168  CD2 LEU    11      -1.052  41.296  -1.292  1.00 17.23           C
ATOM    172  C   LEU    11      -2.872  43.029  -4.826  1.00 18.50           C
ATOM    173  O   LEU    11      -4.018  42.652  -4.757  1.00 17.18           O
ATOM    175  N   ARG    12      -2.554  44.316  -4.710  1.00 16.81           N
ATOM    176  CA  ARG    12      -3.587  45.342  -4.508  1.00 18.76           C
ATOM    178  CB  ARG    12      -2.975  46.756  -4.299  1.00 15.68           C
ATOM    181  CG  ARG    12      -2.092  46.846  -3.060  1.00 20.36           C
ATOM    184  CD  ARG    12      -1.799  48.294  -2.715  1.00 24.48           C
ATOM    187  NE  ARG    12      -0.943  48.950  -3.696  1.00 19.83           N
ATOM    189  CZ  ARG    12       0.393  48.875  -3.740  1.00 17.58           C
ATOM    190  NH1 ARG    12       1.084  48.164  -2.878  1.00 25.76           N
ATOM    193  NH2 ARG    12       1.034  49.530  -4.686  1.00 24.92           N
ATOM    196  C   ARG    12      -4.628  45.388  -5.624  1.00 16.66           C
ATOM    197  O   ARG    12      -5.828  45.475  -5.353  1.00 16.08           O
ATOM    199  N   ILE    13      -4.164  45.301  -6.864  1.00 19.21           N
ATOM    200  CA  ILE    13      -5.044  45.236  -8.043  1.00 17.95           C
ATOM    202  CB  ILE    13      -4.224  45.209  -9.367  1.00 17.89           C
ATOM    204  CG1 ILE    13      -3.478  46.541  -9.577  1.00 23.66           C
ATOM    207  CD1 ILE    13      -2.498  46.500 -10.707  1.00 27.76           C
ATOM    211  CG2 ILE    13      -5.101  44.894 -10.587  1.00 24.21           C
ATOM    215  C   ILE    13      -5.997  44.011  -7.963  1.00 14.86           C
ATOM    216  O   ILE    13      -7.218  44.155  -8.154  1.00 16.18           O
ATOM    218  N   PHE    14      -5.438  42.857  -7.652  1.00 16.54           N
ATOM    219  CA  PHE    14      -6.211  41.642  -7.441  1.00 15.48           C
ATOM    221  CB  PHE    14      -5.313  40.456  -7.134  1.00 18.04           C
ATOM    224  CG  PHE    14      -6.074  39.237  -6.793  1.00 18.02           C
ATOM    225  CD1 PHE    14      -6.678  38.465  -7.790  1.00 26.02           C
ATOM    227  CE1 PHE    14      -7.424  37.332  -7.462  1.00 20.26           C
ATOM    229  CZ  PHE    14      -7.559  36.973  -6.149  1.00 20.14           C
ATOM    231  CE2 PHE    14      -6.970  37.746  -5.142  1.00 23.20           C
ATOM    233  CD2 PHE    14      -6.239  38.861  -5.465  1.00 22.05           C
ATOM    235  C   PHE    14      -7.252  41.824  -6.314  1.00 17.60           C
ATOM    236  O   PHE    14      -8.431  41.558  -6.507  1.00 16.66           O
ATOM    238  N   LEU    15      -6.807  42.332  -5.166  1.00 15.25           N
ATOM    239  CA  LEU    15      -7.701  42.555  -4.016  1.00 15.48           C
ATOM    241  CB  LEU    15      -6.921  42.915  -2.741  1.00 17.25           C
ATOM    244  CG  LEU    15      -5.972  41.845  -2.195  1.00 20.45           C
ATOM    246  CD1 LEU    15      -5.225  42.342  -0.920  1.00 15.28           C
ATOM    250  CD2 LEU    15      -6.687  40.491  -1.929  1.00 17.37           C
ATOM    254  C   LEU    15      -8.826  43.550  -4.269  1.00 16.03           C
ATOM    255  O   LEU    15      -9.961  43.320  -3.815  1.00 15.92           O
ATOM    257  N   ARG    16      -8.542  44.625  -4.980  1.00 16.38           N
ATOM    258  CA  ARG    16      -9.590  45.593  -5.363  1.00 13.95           C
ATOM    260  CB  ARG    16      -9.022  46.796  -6.096  1.00 16.47           C
ATOM    263  CG  ARG    16      -8.327  47.808  -5.243  1.00 20.20           C
ATOM    266  CD  ARG    16      -7.975  49.054  -6.021  1.00 26.38           C
ATOM    269  NE  ARG    16      -6.868  49.676  -5.338  1.00 24.76           N
ATOM    271  CZ  ARG    16      -5.583  49.547  -5.650  1.00 23.18           C
ATOM    272  NH1 ARG    16      -5.178  48.910  -6.742  1.00 24.86           N
ATOM    275  NH2 ARG    16      -4.686  50.121  -4.856  1.00 30.66           N
ATOM    278  C   ARG    16     -10.679  44.968  -6.259  1.00 13.93           C
ATOM    279  O   ARG    16     -11.864  45.248  -6.112  1.00 14.07           O
ATOM    281  N   ASN    17     -10.257  44.175  -7.218  1.00 16.80           N
ATOM    282  CA  ASN    17     -11.176  43.522  -8.112  1.00 18.78           C
ATOM    284  CB  ASN    17     -10.401  42.870  -9.247  1.00 21.01           C
ATOM    287  CG  ASN    17     -11.295  42.036 -10.170  1.00 28.67           C
ATOM    288  OD1 ASN    17     -11.469  40.838  -9.941  1.00 21.42           O
ATOM    289  ND2 ASN    17     -11.827  42.664 -11.250  1.00 28.09           N
ATOM    292  C   ASN    17     -12.089  42.535  -7.382  1.00 16.00           C
ATOM    293  O   ASN    17     -13.302  42.574  -7.591  1.00 17.86           O
ATOM    295  N   VAL    18     -11.520  41.689  -6.521  1.00 18.79           N
ATOM    296  CA  VAL    18     -12.301  40.735  -5.735  1.00 17.67           C
ATOM    298  CB  VAL    18     -11.407  39.847  -4.834  1.00 19.56           C
ATOM    300  CG1 VAL    18     -12.271  39.004  -3.891  1.00 20.84           C
ATOM    304  CG2 VAL    18     -10.450  38.989  -5.687  1.00 14.57           C
ATOM    308  C   VAL    18     -13.266  41.501  -4.810  1.00 17.37           C
ATOM    309  O   VAL    18     -14.450  41.176  -4.721  1.00 19.43           O
ATOM    311  N   THR    19     -12.747  42.526  -4.146  1.00 16.37           N
ATOM    312  CA  THR    19     -13.563  43.341  -3.222  1.00 17.39           C
ATOM    314  CB  THR    19     -12.716  44.371  -2.443  1.00 16.96           C
ATOM    316  OG1 THR    19     -11.617  43.710  -1.816  1.00 17.66           O
ATOM    318  CG2 THR    19     -13.564  45.076  -1.343  1.00 20.05           C
ATOM    322  C   THR    19     -14.744  44.026  -3.933  1.00 17.65           C
ATOM    323  O   THR    19     -15.852  44.020  -3.417  1.00 19.09           O
ATOM    325  N   HIS    20     -14.508  44.595  -5.101  1.00 19.93           N
ATOM    326  CA  HIS    20     -15.611  45.135  -5.920  1.00 19.72           C
ATOM    328  CB  HIS    20     -15.059  45.947  -7.086  0.50 21.68           C
ATOM    334  CG  HIS    20     -14.484  47.263  -6.651  0.50 31.09           C
ATOM    336  ND1 HIS    20     -15.103  48.066  -5.710  0.50 15.30           N
ATOM    340  CE1 HIS    20     -14.376  49.152  -5.520  0.50 31.02           C
ATOM    344  NE2 HIS    20     -13.308  49.082  -6.295  0.50 28.85           N
ATOM    348  CD2 HIS    20     -13.355  47.914  -7.019  0.50 25.42           C
ATOM    352  C   HIS    20     -16.660  44.095  -6.319  1.00 17.96           C
ATOM    353  O   HIS    20     -17.853  44.378  -6.303  1.00 20.97           O
ATOM    355  N   ARG    21     -16.230  42.894  -6.686  1.00 17.03           N
ATOM    356  CA  ARG    21     -17.180  41.826  -7.010  1.00 18.99           C
ATOM    358  CB  ARG    21     -16.435  40.624  -7.602  1.00 14.36           C
ATOM    361  CG  ARG    21     -15.970  40.922  -9.011  1.00 20.10           C
ATOM    364  CD  ARG    21     -14.704  40.187  -9.358  1.00 26.48           C
ATOM    367  NE  ARG    21     -14.976  38.798  -9.527  1.00 23.70           N
ATOM    369  CZ  ARG    21     -14.059  37.850  -9.652  1.00 24.65           C
ATOM    370  NH1 ARG    21     -12.773  38.120  -9.628  1.00 21.13           N
ATOM    373  NH2 ARG    21     -14.461  36.619  -9.815  1.00 21.77           N
ATOM    376  C   ARG    21     -18.083  41.435  -5.822  1.00 19.61           C
ATOM    377  O   ARG    21     -19.285  41.157  -5.992  1.00 23.33           O
ATOM    379  N   LEU    22     -17.522  41.469  -4.622  1.00 19.80           N
ATOM    380  CA  LEU    22     -18.300  41.281  -3.399  1.00 18.25           C
ATOM    382  CB  LEU    22     -17.378  41.023  -2.193  1.00 19.98           C
ATOM    385  CG  LEU    22     -16.345  39.907  -2.263  1.00 18.93           C
ATOM    387  CD1 LEU    22     -15.396  39.999  -1.040  1.00 20.62           C
ATOM    391  CD2 LEU    22     -17.018  38.495  -2.365  1.00 20.07           C
ATOM    395  C   LEU    22     -19.228  42.459  -3.101  1.00 20.64           C
ATOM    396  O   LEU    22     -20.415  42.251  -2.807  1.00 21.92           O
ATOM    398  N   ALA    23     -18.701  43.679  -3.190  1.00 17.45           N
ATOM    399  CA  ALA    23     -19.441  44.866  -2.847  1.00 17.66           C
ATOM    401  CB  ALA    23     -18.527  46.122  -2.822  1.00 21.62           C
ATOM    405  C   ALA    23     -20.644  45.119  -3.776  1.00 26.04           C
ATOM    406  O   ALA    23     -21.590  45.756  -3.360  1.00 22.48           O
ATOM    408  N   ILE    24     -20.612  44.639  -5.014  1.00 25.86           N
ATOM    409  CA  ILE    24     -21.755  44.832  -5.895  1.00 27.15           C
ATOM    411  CB  ILE    24     -21.344  45.044  -7.374  1.00 28.18           C
ATOM    413  CG1 ILE    24     -20.761  43.768  -7.966  1.00 23.99           C
ATOM    416  CD1 ILE    24     -20.472  43.872  -9.443  1.00 35.51           C
ATOM    420  CG2 ILE    24     -20.408  46.213  -7.489  1.00 34.25           C
ATOM    424  C   ILE    24     -22.790  43.706  -5.793  1.00 28.62           C
ATOM    425  O   ILE    24     -23.850  43.801  -6.384  1.00 26.67           O
ATOM    427  N   ASP    25     -22.498  42.646  -5.046  1.00 25.41           N
ATOM    428  CA  ASP    25     -23.433  41.566  -4.884  1.00 26.94           C
ATOM    430  CB  ASP    25     -22.726  40.350  -4.319  1.00 26.56           C
ATOM    433  CG  ASP    25     -23.578  39.107  -4.362  1.00 23.90           C
ATOM    434  OD1 ASP    25     -24.730  39.106  -3.846  1.00 26.48           O
ATOM    435  OD2 ASP    25     -23.072  38.101  -4.865  1.00 25.65           O
ATOM    436  C   ASP    25     -24.552  42.053  -3.944  1.00 28.65           C
ATOM    437  O   ASP    25     -24.284  42.520  -2.852  1.00 22.14           O
ATOM    439  N   LYS    26     -25.805  41.969  -4.394  1.00 30.84           N
ATOM    440  CA  LYS    26     -26.972  42.460  -3.624  1.00 30.71           C
ATOM    442  CB  LYS    26     -28.269  42.264  -4.436  1.00 33.89           C
ATOM    445  CG  LYS    26     -28.511  43.357  -5.458  1.00 44.49           C
ATOM    451  C   LYS    26     -27.110  41.822  -2.229  1.00 20.07           C
ATOM    452  O   LYS    26     -27.539  42.461  -1.284  1.00 26.43           O
ATOM    454  N   ARG    27     -26.680  40.589  -2.087  1.00 21.15           N
ATOM    455  CA  ARG    27     -26.707  39.913  -0.798  1.00 22.60           C
ATOM    457  CB  ARG    27     -26.242  38.480  -0.963  1.00 25.57           C
ATOM    460  CG  ARG    27     -27.146  37.636  -1.841  1.00 27.66           C
ATOM    463  CD  ARG    27     -26.556  36.286  -2.013  1.00 23.29           C
ATOM    466  NE  ARG    27     -25.338  36.340  -2.817  1.00 26.58           N
ATOM    468  CZ  ARG    27     -24.476  35.332  -2.941  1.00 23.01           C
ATOM    469  NH1 ARG    27     -24.685  34.189  -2.338  1.00 28.51           N
ATOM    472  NH2 ARG    27     -23.403  35.463  -3.696  1.00 28.09           N
ATOM    475  C   ARG    27     -25.817  40.557   0.265  1.00 24.98           C
ATOM    476  O   ARG    27     -26.053  40.397   1.473  1.00 25.35           O
ATOM    478  N   PHE    28     -24.801  41.282  -0.186  1.00 21.49           N
ATOM    479  CA  PHE    28     -23.726  41.741   0.688  1.00 23.72           C
ATOM    481  CB  PHE    28     -22.367  41.350   0.071  1.00 18.92           C
ATOM    484  CG  PHE    28     -22.222  39.873  -0.238  1.00 22.49           C
ATOM    485  CD1 PHE    28     -22.890  38.896   0.509  1.00 18.05           C
ATOM    487  CE1 PHE    28     -22.755  37.560   0.217  1.00 23.57           C
ATOM    489  CZ  PHE    28     -21.918  37.162  -0.818  1.00 19.66           C
ATOM    491  CE2 PHE    28     -21.237  38.120  -1.551  1.00 19.19           C
ATOM    493  CD2 PHE    28     -21.387  39.456  -1.252  1.00 20.61           C
ATOM    495  C   PHE    28     -23.809  43.225   0.963  1.00 20.64           C
ATOM    496  O   PHE    28     -22.922  43.802   1.621  1.00 21.40           O
ATOM    498  N   ARG    29     -24.903  43.860   0.528  1.00 25.62           N
ATOM    499  CA  ARG    29     -25.106  45.308   0.727  1.00 25.06           C
ATOM    501  CB  ARG    29     -26.492  45.749   0.199  1.00 28.09           C
ATOM    504  CG  ARG    29     -26.750  47.252   0.234  1.00 35.00           C
ATOM    507  CD  ARG    29     -28.236  47.617   0.028  1.00 56.20           C
ATOM    510  NE  ARG    29     -29.158  46.670   0.671  1.00 80.68           N
ATOM    512  CZ  ARG    29     -29.425  46.591   1.982  1.00 79.44           C
ATOM    513  NH1 ARG    29     -28.846  47.409   2.863  1.00 66.15           N
ATOM    516  NH2 ARG    29     -30.277  45.662   2.420  1.00 79.04           N
ATOM    519  C   ARG    29     -24.931  45.753   2.180  1.00 20.06           C
ATOM    520  O   ARG    29     -24.355  46.816   2.424  1.00 26.41           O
ATOM    522  N   VAL    30     -25.391  44.932   3.117  1.00 27.21           N
ATOM    523  CA  VAL    30     -25.289  45.215   4.553  1.00 33.63           C
ATOM    525  CB  VAL    30     -26.019  44.115   5.436  1.00 38.16           C
ATOM    527  CG1 VAL    30     -25.513  42.687   5.162  1.00 30.77           C
ATOM    531  CG2 VAL    30     -25.887  44.414   6.918  1.00 51.45           C
ATOM    535  C   VAL    30     -23.825  45.365   5.002  1.00 33.95           C
ATOM    536  O   VAL    30     -23.536  46.052   5.976  1.00 28.60           O
ATOM    538  N   PHE    31     -22.908  44.747   4.262  1.00 27.31           N
ATOM    539  CA  PHE    31     -21.483  44.731   4.632  1.00 23.37           C
ATOM    541  CB  PHE    31     -20.917  43.326   4.423  1.00 24.67           C
ATOM    544  CG  PHE    31     -21.743  42.236   5.027  1.00 23.53           C
ATOM    545  CD1 PHE    31     -21.987  42.193   6.401  1.00 24.92           C
ATOM    547  CE1 PHE    31     -22.759  41.189   6.950  1.00 34.33           C
ATOM    549  CZ  PHE    31     -23.268  40.181   6.142  1.00 26.48           C
ATOM    551  CE2 PHE    31     -23.027  40.198   4.778  1.00 23.80           C
ATOM    553  CD2 PHE    31     -22.274  41.225   4.222  1.00 23.54           C
ATOM    555  C   PHE    31     -20.667  45.756   3.856  1.00 25.64           C
ATOM    556  O   PHE    31     -19.440  45.777   3.960  1.00 24.17           O
ATOM    558  N   THR    32     -21.344  46.619   3.093  1.00 24.94           N
ATOM    559  CA  THR    32     -20.680  47.593   2.255  1.00 23.72           C
ATOM    561  CB  THR    32     -21.469  47.932   0.964  1.00 31.83           C
ATOM    563  OG1 THR    32     -22.742  48.526   1.288  1.00 32.27           O
ATOM    565  CG2 THR    32     -21.633  46.678   0.069  1.00 22.27           C
ATOM    569  C   THR    32     -20.378  48.901   3.005  1.00 29.48           C
ATOM    570  O   THR    32     -19.567  49.691   2.546  1.00 30.50           O
ATOM    572  N   LYS    33     -21.018  49.116   4.153  1.00 29.86           N
ATOM    573  CA  LYS    33     -20.827  50.362   4.910  1.00 35.76           C
ATOM    575  CB  LYS    33     -22.004  51.342   4.691  1.00 36.32           C
ATOM    578  CG  LYS    33     -22.005  52.062   3.342  1.00 51.13           C
ATOM    581  CD  LYS    33     -23.340  52.779   3.070  1.00 45.23           C
ATOM    586  C   LYS    33     -20.703  50.066   6.387  1.00 30.75           C
ATOM    587  O   LYS    33     -21.211  49.038   6.877  1.00 34.04           O
ATOM    589  N   PRO    34     -20.022  50.975   7.124  1.00 40.34           N
ATOM    590  CA  PRO    34     -20.024  50.887   8.573  1.00 43.78           C
ATOM    592  CB  PRO    34     -19.289  52.160   9.007  1.00 44.37           C
ATOM    595  CG  PRO    34     -18.458  52.547   7.868  1.00 40.69           C
ATOM    598  CD  PRO    34     -19.251  52.142   6.652  1.00 39.52           C
ATOM    601  C   PRO    34     -21.445  50.906   9.117  1.00 46.49           C
ATOM    602  O   PRO    34     -22.348  51.411   8.462  1.00 46.86           O
ATOM    603  N   VAL    35     -21.629  50.357  10.306  1.00 52.73           N
ATOM    604  CA  VAL    35     -22.905  50.435  11.002  1.00 56.02           C
ATOM    606  CB  VAL    35     -22.963  49.408  12.141  1.00 52.91           C
ATOM    608  CG1 VAL    35     -22.966  47.996  11.569  1.00 47.77           C
ATOM    612  CG2 VAL    35     -24.191  49.658  13.016  1.00 45.00           C
ATOM    616  C   VAL    35     -23.139  51.853  11.562  1.00 63.10           C
ATOM    617  O   VAL    35     -22.258  52.435  12.205  1.00 67.79           O
ATOM    619  N   ASP    36     -24.333  52.394  11.320  1.00 66.89           N
ATOM    620  CA  ASP    36     -24.676  53.763  11.725  1.00 68.61           C
ATOM    622  CB  ASP    36     -25.929  54.218  10.964  1.00 70.39           C
ATOM    625  CG  ASP    36     -26.175  55.714  11.064  1.00 77.61           C
ATOM    626  OD1 ASP    36     -25.201  56.485  11.219  1.00 70.69           O
ATOM    627  OD2 ASP    36     -27.355  56.117  10.971  1.00 90.64           O
ATOM    628  C   ASP    36     -24.898  53.861  13.254  1.00 67.11           C
ATOM    629  O   ASP    36     -25.795  53.199  13.800  1.00 56.69           O
ATOM    631  N   PRO    37     -24.081  54.685  13.951  1.00 70.78           N
ATOM    632  CA  PRO    37     -24.197  54.744  15.420  1.00 75.96           C
ATOM    634  CB  PRO    37     -23.059  55.691  15.834  1.00 75.72           C
ATOM    637  CG  PRO    37     -22.765  56.499  14.625  1.00 71.83           C
ATOM    640  CD  PRO    37     -23.059  55.621  13.443  1.00 67.24           C
ATOM    643  C   PRO    37     -25.552  55.273  15.901  1.00 80.35           C
ATOM    644  O   PRO    37     -25.932  55.035  17.050  1.00 83.21           O
ATOM    645  N   ASP    38     -26.266  55.976  15.023  1.00 83.08           N
ATOM    646  CA  ASP    38     -27.612  56.454  15.320  1.00 85.90           C
ATOM    648  CB  ASP    38     -28.032  57.549  14.332  1.00 86.22           C
ATOM    651  CG  ASP    38     -26.946  58.600  14.122  1.00 91.26           C
ATOM    652  OD1 ASP    38     -26.291  59.000  15.112  1.00 80.39           O
ATOM    653  OD2 ASP    38     -26.747  59.019  12.960  1.00 95.27           O
ATOM    654  C   ASP    38     -28.582  55.275  15.258  1.00 86.84           C
ATOM    655  O   ASP    38     -29.307  55.008  16.220  1.00 87.15           O
ATOM    657  N   GLU    39     -28.574  54.568  14.127  1.00 85.88           N
ATOM    658  CA  GLU    39     -29.421  53.389  13.941  1.00 84.58           C
ATOM    660  CB  GLU    39     -29.302  52.861  12.505  1.00 83.92           C
ATOM    667  C   GLU    39     -29.085  52.284  14.956  1.00 84.18           C
ATOM    668  O   GLU    39     -29.990  51.719  15.580  1.00 83.93           O
ATOM    670  N   VAL    40     -27.791  51.994  15.127  1.00 82.97           N
ATOM    671  CA  VAL    40     -27.326  50.952  16.059  1.00 79.76           C
ATOM    673  CB  VAL    40     -26.710  49.752  15.311  1.00 77.63           C
ATOM    675  CG1 VAL    40     -26.842  48.498  16.145  1.00 78.57           C
ATOM    679  CG2 VAL    40     -27.387  49.554  13.963  1.00 78.81           C
ATOM    683  C   VAL    40     -26.291  51.535  17.035  1.00 78.94           C
ATOM    684  O   VAL    40     -25.088  51.526  16.748  1.00 74.58           O
ATOM    686  N   PRO    41     -26.760  52.045  18.194  1.00 78.72           N
ATOM    687  CA  PRO    41     -25.885  52.767  19.130  1.00 75.46           C
ATOM    689  CB  PRO    41     -26.876  53.520  20.018  1.00 76.25           C
ATOM    692  CG  PRO    41     -28.089  52.638  20.045  1.00 80.48           C
ATOM    695  CD  PRO    41     -28.127  51.890  18.730  1.00 78.09           C
ATOM    698  C   PRO    41     -24.988  51.852  19.962  1.00 69.89           C
ATOM    699  O   PRO    41     -23.862  52.235  20.284  1.00 71.29           O
ATOM    700  N   ASP    42     -25.477  50.655  20.285  1.00 64.93           N
ATOM    701  CA  ASP    42     -24.691  49.667  21.019  1.00 63.01           C
ATOM    703  CB  ASP    42     -25.616  48.712  21.801  1.00 65.05           C
ATOM    706  CG  ASP    42     -26.381  47.740  20.897  1.00 71.38           C
ATOM    707  OD1 ASP    42     -26.382  46.515  21.186  1.00 60.91           O
ATOM    708  OD2 ASP    42     -26.976  48.203  19.898  1.00 69.09           O
ATOM    709  C   ASP    42     -23.718  48.855  20.136  1.00 59.52           C
ATOM    710  O   ASP    42     -23.081  47.928  20.638  1.00 59.30           O
ATOM    712  N   TYR    43     -23.594  49.186  18.846  1.00 56.70           N
ATOM    713  CA  TYR    43     -22.720  48.402  17.952  1.00 54.71           C
ATOM    715  CB  TYR    43     -22.915  48.743  16.459  1.00 55.68           C
ATOM    718  CG  TYR    43     -22.255  47.707  15.545  1.00 45.79           C
ATOM    719  CD1 TYR    43     -22.908  46.519  15.245  1.00 50.75           C
ATOM    721  CE1 TYR    43     -22.322  45.546  14.436  1.00 42.58           C
ATOM    723  CZ  TYR    43     -21.059  45.744  13.920  1.00 34.68           C
ATOM    724  OH  TYR    43     -20.527  44.734  13.135  1.00 39.12           O
ATOM    726  CE2 TYR    43     -20.356  46.913  14.209  1.00 37.57           C
ATOM    728  CD2 TYR    43     -20.960  47.892  15.032  1.00 43.68           C
ATOM    730  C   TYR    43     -21.254  48.600  18.320  1.00 54.18           C
ATOM    731  O   TYR    43     -20.523  47.623  18.531  1.00 48.20           O
ATOM    733  N   VAL    44     -20.847  49.871  18.391  1.00 52.45           N
ATOM    734  CA  VAL    44     -19.454  50.239  18.637  1.00 55.94           C
ATOM    736  CB  VAL    44     -19.192  51.763  18.333  1.00 58.13           C
ATOM    738  CG1 VAL    44     -18.220  52.399  19.327  1.00 58.75           C
ATOM    742  CG2 VAL    44     -18.684  51.920  16.908  1.00 47.76           C
ATOM    746  C   VAL    44     -18.945  49.796  20.025  1.00 50.89           C
ATOM    747  O   VAL    44     -17.731  49.688  20.217  1.00 47.72           O
ATOM    749  N   THR    45     -19.866  49.487  20.947  1.00 49.61           N
ATOM    750  CA  THR    45     -19.520  48.909  22.259  1.00 48.11           C
ATOM    752  CB  THR    45     -20.445  49.461  23.395  1.00 52.57           C
ATOM    754  OG1 THR    45     -21.668  48.713  23.469  1.00 60.63           O
ATOM    756  CG2 THR    45     -20.767  50.929  23.165  1.00 43.51           C
ATOM    760  C   THR    45     -19.511  47.359  22.271  1.00 46.13           C
ATOM    761  O   THR    45     -18.704  46.746  22.995  1.00 44.43           O
ATOM    763  N   VAL    46     -20.385  46.723  21.480  1.00 42.70           N
ATOM    764  CA  VAL    46     -20.404  45.243  21.371  1.00 40.23           C
ATOM    766  CB  VAL    46     -21.778  44.712  20.870  1.00 44.94           C
ATOM    768  CG1 VAL    46     -21.747  43.180  20.691  1.00 46.94           C
ATOM    772  CG2 VAL    46     -22.893  45.133  21.829  1.00 44.05           C
ATOM    776  C   VAL    46     -19.287  44.702  20.453  1.00 36.60           C
ATOM    777  O   VAL    46     -18.654  43.673  20.744  1.00 38.38           O
ATOM    779  N   ILE    47     -19.065  45.396  19.341  1.00 30.45           N
ATOM    780  CA  ILE    47     -18.111  44.965  18.328  1.00 32.39           C
ATOM    782  CB  ILE    47     -18.734  44.983  16.890  1.00 35.54           C
ATOM    784  CG1 ILE    47     -19.956  44.028  16.779  1.00 27.28           C
ATOM    787  CD1 ILE    47     -19.707  42.525  17.097  1.00 23.48           C
ATOM    791  CG2 ILE    47     -17.682  44.619  15.842  1.00 25.81           C
ATOM    795  C   ILE    47     -16.864  45.865  18.401  1.00 33.66           C
ATOM    796  O   ILE    47     -16.883  47.050  18.031  1.00 36.10           O
ATOM    798  N   LYS    48     -15.798  45.270  18.901  1.00 33.32           N
ATOM    799  CA  LYS    48     -14.550  45.963  19.207  1.00 31.72           C
ATOM    801  CB  LYS    48     -13.689  45.068  20.118  1.00 31.65           C
ATOM    804  CG  LYS    48     -14.387  44.729  21.453  1.00 39.44           C
ATOM    807  CD  LYS    48     -14.892  46.002  22.158  1.00 43.13           C
ATOM    810  CE  LYS    48     -15.676  45.714  23.404  1.00 47.78           C
ATOM    813  NZ  LYS    48     -16.182  47.011  23.956  1.00 44.33           N
ATOM    817  C   LYS    48     -13.751  46.353  17.977  1.00 33.20           C
ATOM    818  O   LYS    48     -13.014  47.339  18.022  1.00 27.97           O
ATOM    820  N   GLN    49     -13.914  45.583  16.895  1.00 30.48           N
ATOM    821  CA  GLN    49     -13.217  45.843  15.662  1.00 32.30           C
ATOM    823  CB  GLN    49     -12.049  44.864  15.505  1.00 29.28           C
ATOM    826  CG  GLN    49     -11.013  45.463  14.632  1.00 39.19           C
ATOM    829  CD  GLN    49      -9.769  44.633  14.478  1.00 36.19           C
ATOM    830  OE1 GLN    49      -8.860  45.072  13.783  1.00 40.56           O
ATOM    831  NE2 GLN    49      -9.711  43.427  15.107  1.00 33.13           N
ATOM    834  C   GLN    49     -14.181  45.755  14.477  1.00 28.07           C
ATOM    835  O   GLN    49     -14.234  44.724  13.793  1.00 28.15           O
ATOM    837  N   PRO    50     -14.949  46.835  14.245  1.00 29.22           N
ATOM    838  CA  PRO    50     -15.875  46.936  13.125  1.00 27.66           C
ATOM    840  CB  PRO    50     -16.369  48.378  13.211  1.00 30.49           C
ATOM    843  CG  PRO    50     -16.195  48.758  14.591  1.00 36.52           C
ATOM    846  CD  PRO    50     -15.042  48.013  15.122  1.00 26.98           C
ATOM    849  C   PRO    50     -15.126  46.763  11.815  1.00 31.26           C
ATOM    850  O   PRO    50     -14.027  47.278  11.679  1.00 23.71           O
ATOM    851  N   MET    51     -15.696  46.044  10.861  1.00 21.15           N
ATOM    852  CA  MET    51     -15.055  45.935   9.533  1.00 22.60           C
ATOM    854  CB  MET    51     -14.158  44.700   9.485  1.00 21.22           C
ATOM    857  CG  MET    51     -13.218  44.584   8.232  1.00 20.96           C
ATOM    860  SD  MET    51     -12.243  46.051   7.847  1.00 26.36           S
ATOM    861  CE  MET    51     -11.246  46.176   9.359  1.00 22.19           C
ATOM    865  C   MET    51     -16.166  45.867   8.493  1.00 23.15           C
ATOM    866  O   MET    51     -17.221  45.344   8.772  1.00 23.61           O
ATOM    868  N   ASP    52     -15.924  46.436   7.328  1.00 24.76           N
ATOM    869  CA  ASP    52     -16.879  46.392   6.231  1.00 27.19           C
ATOM    871  CB  ASP    52     -17.922  47.511   6.360  1.00 26.13           C
ATOM    874  CG  ASP    52     -17.330  48.890   6.169  1.00 29.38           C
ATOM    875  OD1 ASP    52     -16.775  49.471   7.125  1.00 45.75           O
ATOM    876  OD2 ASP    52     -17.407  49.400   5.059  1.00 31.49           O
ATOM    877  C   ASP    52     -16.084  46.513   4.949  1.00 24.29           C
ATOM    878  O   ASP    52     -14.881  46.799   4.992  1.00 20.17           O
ATOM    880  N   LEU    53     -16.745  46.316   3.812  1.00 19.93           N
ATOM    881  CA  LEU    53     -16.042  46.295   2.513  1.00 22.93           C
ATOM    883  CB  LEU    53     -16.947  45.717   1.416  1.00 23.99           C
ATOM    886  CG  LEU    53     -17.426  44.279   1.629  1.00 25.34           C
ATOM    888  CD1 LEU    53     -18.492  43.886   0.568  1.00 17.36           C
ATOM    892  CD2 LEU    53     -16.274  43.274   1.667  1.00 17.56           C
ATOM    896  C   LEU    53     -15.496  47.665   2.091  1.00 25.54           C
ATOM    897  O   LEU    53     -14.483  47.745   1.360  1.00 19.91           O
ATOM    899  N   SER    54     -16.118  48.753   2.553  1.00 28.29           N
ATOM    900  CA  SER    54     -15.543  50.087   2.272  1.00 25.79           C
ATOM    902  CB  SER    54     -16.504  51.211   2.684  0.50 23.77           C
ATOM    908  OG  SER    54     -16.659  51.265   4.097  0.50 28.65           O
ATOM    912  C   SER    54     -14.227  50.281   3.014  1.00 20.81           C
ATOM    913  O   SER    54     -13.287  50.890   2.484  1.00 25.29           O
ATOM    915  N   SER    55     -14.176  49.791   4.241  1.00 23.85           N
ATOM    916  CA  SER    55     -12.940  49.887   5.038  1.00 28.64           C
ATOM    918  CB  SER    55     -13.218  49.548   6.498  1.00 26.98           C
ATOM    921  OG  SER    55     -14.248  50.389   7.006  1.00 35.24           O
ATOM    923  C   SER    55     -11.851  48.986   4.446  1.00 24.61           C
ATOM    924  O   SER    55     -10.673  49.347   4.432  1.00 22.37           O
ATOM    926  N   VAL    56     -12.257  47.833   3.912  1.00 22.80           N
ATOM    927  CA  VAL    56     -11.319  46.945   3.189  1.00 18.59           C
ATOM    929  CB  VAL    56     -11.984  45.581   2.798  1.00 17.04           C
ATOM    931  CG1 VAL    56     -11.131  44.796   1.802  1.00 18.98           C
ATOM    935  CG2 VAL    56     -12.279  44.718   4.064  1.00 19.48           C
ATOM    939  C   VAL    56     -10.697  47.650   1.997  1.00 17.03           C
ATOM    940  O   VAL    56      -9.478  47.572   1.825  1.00 19.42           O
ATOM    942  N   ILE    57     -11.496  48.352   1.177  1.00 17.41           N
ATOM    943  CA  ILE    57     -10.955  49.092   0.032  1.00 20.50           C
ATOM    945  CB  ILE    57     -12.062  49.736  -0.876  1.00 23.10           C
ATOM    947  CG1 ILE    57     -12.835  48.672  -1.676  1.00 22.23           C
ATOM    950  CD1 ILE    57     -12.019  48.001  -2.756  1.00 28.19           C
ATOM    954  CG2 ILE    57     -11.454  50.774  -1.819  1.00 25.28           C
ATOM    958  C   ILE    57      -9.960  50.162   0.503  1.00 19.54           C
ATOM    959  O   ILE    57      -8.878  50.288  -0.056  1.00 17.87           O
ATOM    961  N   SER    58     -10.317  50.912   1.539  1.00 23.61           N
ATOM    962  CA  SER    58      -9.392  51.897   2.129  1.00 21.37           C
ATOM    964  CB  SER    58     -10.054  52.624   3.304  1.00 26.17           C
ATOM    967  OG  SER    58     -11.054  53.483   2.846  1.00 29.50           O
ATOM    969  C   SER    58      -8.045  51.272   2.584  1.00 18.72           C
ATOM    970  O   SER    58      -6.973  51.822   2.297  1.00 21.54           O
ATOM    972  N   LYS    59      -8.108  50.123   3.249  1.00 20.54           N
ATOM    973  CA  LYS    59      -6.924  49.433   3.712  1.00 16.63           C
ATOM    975  CB  LYS    59      -7.293  48.329   4.700  1.00 17.74           C
ATOM    978  CG  LYS    59      -7.723  48.901   6.077  1.00 21.37           C
ATOM    981  CD  LYS    59      -8.114  47.798   7.067  1.00 19.34           C
ATOM    984  CE  LYS    59      -6.893  47.119   7.670  1.00 20.09           C
ATOM    987  NZ  LYS    59      -7.200  46.047   8.619  1.00 19.43           N
ATOM    991  C   LYS    59      -6.034  48.918   2.559  1.00 15.54           C
ATOM    992  O   LYS    59      -4.816  48.973   2.659  1.00 16.76           O
ATOM    994  N   ILE    60      -6.643  48.453   1.467  1.00 17.14           N
ATOM    995  CA  ILE    60      -5.871  48.056   0.280  1.00 17.12           C
ATOM    997  CB  ILE    60      -6.783  47.630  -0.911  1.00 18.90           C
ATOM    999  CG1 ILE    60      -7.619  46.371  -0.546  1.00 20.67           C
ATOM   1002  CD1 ILE    60      -8.756  46.014  -1.549  1.00 16.51           C
ATOM   1006  CG2 ILE    60      -5.914  47.410  -2.191  1.00 15.27           C
ATOM   1010  C   ILE    60      -4.983  49.238  -0.173  1.00 16.88           C
ATOM   1011  O   ILE    60      -3.762  49.112  -0.345  1.00 18.43           O
ATOM   1013  N   ASP    61      -5.640  50.373  -0.349  1.00 18.18           N
ATOM   1014  CA  ASP    61      -5.022  51.581  -0.838  1.00 21.27           C
ATOM   1016  CB  ASP    61      -6.111  52.614  -1.131  1.00 20.70           C
ATOM   1019  CG  ASP    61      -6.998  52.220  -2.305  1.00 32.84           C
ATOM   1020  OD1 ASP    61      -6.667  51.259  -3.026  1.00 27.00           O
ATOM   1021  OD2 ASP    61      -8.033  52.884  -2.509  1.00 25.46           O
ATOM   1022  C   ASP    61      -3.976  52.136   0.138  1.00 24.20           C
ATOM   1023  O   ASP    61      -2.950  52.691  -0.290  1.00 21.34           O
ATOM   1025  N   LEU    62      -4.190  51.924   1.436  1.00 22.90           N
ATOM   1026  CA  LEU    62      -3.176  52.248   2.457  1.00 23.80           C
ATOM   1028  CB  LEU    62      -3.850  52.442   3.827  1.00 18.19           C
ATOM   1031  CG  LEU    62      -4.757  53.639   4.064  1.00 23.24           C
ATOM   1033  CD1 LEU    62      -5.442  53.427   5.439  1.00 20.00           C
ATOM   1037  CD2 LEU    62      -3.927  54.941   4.004  1.00 20.71           C
ATOM   1041  C   LEU    62      -2.071  51.194   2.585  1.00 24.78           C
ATOM   1042  O   LEU    62      -1.231  51.288   3.456  1.00 23.89           O
ATOM   1044  N   HIS    63      -2.050  50.185   1.712  1.00 21.03           N
ATOM   1045  CA  HIS    63      -1.018  49.156   1.698  1.00 18.83           C
ATOM   1047  CB  HIS    63       0.395  49.728   1.399  1.00 22.34           C
ATOM   1050  CG  HIS    63       0.488  50.497   0.129  1.00 22.10           C
ATOM   1051  ND1 HIS    63       1.698  50.841  -0.426  1.00 25.42           N
ATOM   1053  CE1 HIS    63       1.486  51.534  -1.530  1.00 20.87           C
ATOM   1055  NE2 HIS    63       0.184  51.589  -1.748  1.00 27.01           N
ATOM   1057  CD2 HIS    63      -0.462  50.954  -0.722  1.00 27.64           C
ATOM   1059  C   HIS    63      -0.971  48.336   2.982  1.00 21.67           C
ATOM   1060  O   HIS    63       0.070  47.885   3.388  1.00 22.07           O
ATOM   1062  N   LYS    64      -2.122  48.098   3.586  1.00 22.14           N
ATOM   1063  CA  LYS    64      -2.188  47.316   4.796  1.00 21.91           C
ATOM   1065  CB  LYS    64      -3.440  47.663   5.583  1.00 19.04           C
ATOM   1068  CG  LYS    64      -3.536  49.112   5.934  1.00 24.59           C
ATOM   1071  CD  LYS    64      -2.562  49.504   6.961  1.00 30.67           C
ATOM   1074  CE  LYS    64      -2.888  50.916   7.485  1.00 48.26           C
ATOM   1077  NZ  LYS    64      -2.018  51.276   8.627  1.00 47.20           N
ATOM   1081  C   LYS    64      -2.194  45.831   4.565  1.00 23.75           C
ATOM   1082  O   LYS    64      -1.981  45.077   5.507  1.00 18.75           O
ATOM   1084  N   TYR    65      -2.463  45.407   3.337  1.00 21.37           N
ATOM   1085  CA  TYR    65      -2.490  43.990   3.044  1.00 17.52           C
ATOM   1087  CB  TYR    65      -3.788  43.577   2.327  1.00 15.32           C
ATOM   1090  CG  TYR    65      -5.083  43.992   3.050  1.00 16.36           C
ATOM   1091  CD1 TYR    65      -5.359  43.565   4.331  1.00 19.84           C
ATOM   1093  CE1 TYR    65      -6.552  43.924   4.968  1.00 19.40           C
ATOM   1095  CZ  TYR    65      -7.501  44.701   4.296  1.00 15.48           C
ATOM   1096  OH  TYR    65      -8.679  45.058   4.902  1.00 18.10           O
ATOM   1098  CE2 TYR    65      -7.266  45.119   3.033  1.00 17.29           C
ATOM   1100  CD2 TYR    65      -6.057  44.751   2.395  1.00 16.43           C
ATOM   1102  C   TYR    65      -1.301  43.672   2.162  1.00 21.48           C
ATOM   1103  O   TYR    65      -1.258  44.066   1.007  1.00 22.79           O
ATOM   1105  N   LEU    66      -0.346  42.935   2.713  1.00 19.79           N
ATOM   1106  CA  LEU    66       0.847  42.523   1.958  1.00 23.12           C
ATOM   1108  CB  LEU    66       2.089  42.712   2.836  1.00 25.01           C
ATOM   1111  CG  LEU    66       2.439  44.137   3.294  1.00 32.61           C
ATOM   1113  CD1 LEU    66       3.862  44.119   3.908  1.00 37.41           C
ATOM   1117  CD2 LEU    66       2.368  45.115   2.195  1.00 30.09           C
ATOM   1121  C   LEU    66       0.743  41.062   1.481  1.00 22.04           C
ATOM   1122  O   LEU    66       1.557  40.601   0.688  1.00 21.03           O
ATOM   1124  N   THR    67      -0.256  40.344   1.990  1.00 20.44           N
ATOM   1125  CA  THR    67      -0.543  38.972   1.589  1.00 19.04           C
ATOM   1127  CB  THR    67       0.039  37.928   2.563  1.00 18.54           C
ATOM   1129  OG1 THR    67      -0.742  37.899   3.757  1.00 21.70           O
ATOM   1131  CG2 THR    67       1.506  38.214   2.937  1.00 20.92           C
ATOM   1135  C   THR    67      -2.077  38.771   1.534  1.00 20.22           C
ATOM   1136  O   THR    67      -2.848  39.552   2.115  1.00 18.31           O
ATOM   1138  N   VAL    68      -2.518  37.724   0.835  1.00 16.57           N
ATOM   1139  CA  VAL    68      -3.937  37.398   0.800  1.00 19.83           C
ATOM   1141  CB  VAL    68      -4.303  36.338  -0.283  1.00 19.37           C
ATOM   1143  CG1 VAL    68      -5.768  36.553  -0.786  1.00 24.52           C
ATOM   1147  CG2 VAL    68      -4.149  34.918   0.242  1.00 25.02           C
ATOM   1151  C   VAL    68      -4.424  36.961   2.180  1.00 22.55           C
ATOM   1152  O   VAL    68      -5.586  37.163   2.527  1.00 18.78           O
ATOM   1154  N   LYS    69      -3.550  36.353   2.984  1.00 22.17           N
ATOM   1155  CA  LYS    69      -3.917  36.039   4.372  1.00 26.13           C
ATOM   1157  CB  LYS    69      -2.773  35.296   5.084  1.00 33.70           C
ATOM   1160  CG  LYS    69      -2.648  33.854   4.646  1.00 34.43           C
ATOM   1163  CD  LYS    69      -1.703  33.079   5.573  1.00 45.50           C
ATOM   1168  C   LYS    69      -4.365  37.232   5.216  1.00 21.88           C
ATOM   1169  O   LYS    69      -5.357  37.131   5.952  1.00 23.88           O
ATOM   1171  N   ASP    70      -3.647  38.346   5.089  1.00 19.84           N
ATOM   1172  CA  ASP    70      -3.959  39.615   5.762  1.00 24.88           C
ATOM   1174  CB  ASP    70      -2.992  40.738   5.326  1.00 26.51           C
ATOM   1177  CG  ASP    70      -1.541  40.593   5.828  1.00 34.56           C
ATOM   1178  OD1 ASP    70      -1.244  39.787   6.721  1.00 27.92           O
ATOM   1179  OD2 ASP    70      -0.694  41.379   5.313  1.00 34.87           O
ATOM   1180  C   ASP    70      -5.381  40.087   5.352  1.00 27.16           C
ATOM   1181  O   ASP    70      -6.205  40.493   6.187  1.00 20.43           O
ATOM   1183  N   TYR    71      -5.625  40.070   4.045  1.00 23.04           N
ATOM   1184  CA  TYR    71      -6.940  40.435   3.471  1.00 17.48           C
ATOM   1186  CB  TYR    71      -6.849  40.328   1.955  1.00 19.62           C
ATOM   1189  CG  TYR    71      -8.147  40.516   1.226  1.00 15.66           C
ATOM   1190  CD1 TYR    71      -8.624  41.803   0.949  1.00 15.77           C
ATOM   1192  CE1 TYR    71      -9.795  41.991   0.265  1.00 17.42           C
ATOM   1194  CZ  TYR    71     -10.536  40.878  -0.163  1.00 18.81           C
ATOM   1195  OH  TYR    71     -11.681  41.085  -0.870  1.00 16.07           O
ATOM   1197  CE2 TYR    71     -10.079  39.593   0.061  1.00 15.40           C
ATOM   1199  CD2 TYR    71      -8.886  39.406   0.764  1.00 17.77           C
ATOM   1201  C   TYR    71      -8.074  39.536   3.979  1.00 17.40           C
ATOM   1202  O   TYR    71      -9.115  40.032   4.445  1.00 18.24           O
ATOM   1204  N   LEU    72      -7.871  38.226   3.892  1.00 18.72           N
ATOM   1205  CA  LEU    72      -8.874  37.252   4.349  1.00 21.15           C
ATOM   1207  CB  LEU    72      -8.512  35.826   3.932  1.00 16.77           C
ATOM   1210  CG  LEU    72      -8.718  35.566   2.443  1.00 25.64           C
ATOM   1212  CD1 LEU    72      -8.040  34.297   2.112  1.00 19.37           C
ATOM   1216  CD2 LEU    72     -10.215  35.535   2.012  1.00 25.53           C
ATOM   1220  C   LEU    72      -9.182  37.340   5.843  1.00 26.45           C
ATOM   1221  O   LEU    72     -10.302  37.066   6.250  1.00 23.04           O
ATOM   1223  N   ARG    73      -8.219  37.790   6.636  1.00 22.93           N
ATOM   1224  CA  ARG    73      -8.434  38.055   8.047  1.00 28.03           C
ATOM   1226  CB  ARG    73      -7.122  38.490   8.726  1.00 31.55           C
ATOM   1229  CG  ARG    73      -7.105  38.285  10.212  1.00 38.49           C
ATOM   1232  CD  ARG    73      -5.699  38.518  10.812  1.00 49.01           C
ATOM   1235  NE  ARG    73      -4.676  37.784  10.065  1.00 44.82           N
ATOM   1237  CZ  ARG    73      -3.669  38.325   9.374  1.00 55.88           C
ATOM   1238  NH1 ARG    73      -3.476  39.648   9.322  1.00 40.38           N
ATOM   1241  NH2 ARG    73      -2.831  37.518   8.726  1.00 56.97           N
ATOM   1244  C   ARG    73      -9.524  39.098   8.278  1.00 18.44           C
ATOM   1245  O   ARG    73     -10.365  38.890   9.124  1.00 19.51           O
ATOM   1247  N   ASP    74      -9.523  40.171   7.494  1.00 18.76           N
ATOM   1248  CA  ASP    74     -10.571  41.193   7.504  1.00 16.55           C
ATOM   1250  CB  ASP    74     -10.082  42.492   6.874  1.00 19.52           C
ATOM   1253  CG  ASP    74      -9.294  43.326   7.848  1.00 24.75           C
ATOM   1254  OD1 ASP    74      -9.271  42.928   9.020  1.00 20.14           O
ATOM   1255  OD2 ASP    74      -8.719  44.344   7.449  1.00 22.36           O
ATOM   1256  C   ASP    74     -11.916  40.769   6.894  1.00 21.92           C
ATOM   1257  O   ASP    74     -12.975  41.148   7.406  1.00 18.70           O
ATOM   1259  N   ILE    75     -11.886  39.980   5.830  1.00 21.18           N
ATOM   1260  CA  ILE    75     -13.126  39.305   5.348  1.00 20.67           C
ATOM   1262  CB  ILE    75     -12.861  38.455   4.056  1.00 24.95           C
ATOM   1264  CG1 ILE    75     -12.392  39.357   2.884  1.00 19.84           C
ATOM   1267  CD1 ILE    75     -13.271  40.588   2.564  1.00 17.92           C
ATOM   1271  CG2 ILE    75     -14.123  37.542   3.678  1.00 17.77           C
ATOM   1275  C   ILE    75     -13.756  38.436   6.459  1.00 20.07           C
ATOM   1276  O   ILE    75     -14.957  38.520   6.766  1.00 21.18           O
ATOM   1278  N   ASP    76     -12.930  37.612   7.072  1.00 17.12           N
ATOM   1279  CA  ASP    76     -13.336  36.803   8.192  1.00 18.83           C
ATOM   1281  CB  ASP    76     -12.186  35.905   8.657  1.00 22.83           C
ATOM   1284  CG  ASP    76     -12.043  34.652   7.827  1.00 27.23           C
ATOM   1285  OD1 ASP    76     -13.057  34.078   7.372  1.00 31.01           O
ATOM   1286  OD2 ASP    76     -10.909  34.191   7.693  1.00 27.95           O
ATOM   1287  C   ASP    76     -13.899  37.617   9.377  1.00 23.19           C
ATOM   1288  O   ASP    76     -14.831  37.168  10.037  1.00 22.31           O
ATOM   1290  N   LEU    77     -13.351  38.804   9.612  1.00 18.46           N
ATOM   1291  CA  LEU    77     -13.819  39.701  10.637  1.00 21.75           C
ATOM   1293  CB  LEU    77     -12.778  40.796  10.830  1.00 25.24           C
ATOM   1296  CG  LEU    77     -12.948  41.754  12.004  1.00 29.92           C
ATOM   1298  CD1 LEU    77     -13.038  40.979  13.351  1.00 25.12           C
ATOM   1302  CD2 LEU    77     -11.808  42.828  11.972  1.00 29.35           C
ATOM   1306  C   LEU    77     -15.234  40.301  10.317  1.00 28.76           C
ATOM   1307  O   LEU    77     -16.106  40.401  11.187  1.00 24.23           O
ATOM   1309  N   ILE    78     -15.463  40.677   9.065  1.00 25.00           N
ATOM   1310  CA  ILE    78     -16.801  41.067   8.619  1.00 24.14           C
ATOM   1312  CB  ILE    78     -16.846  41.357   7.106  1.00 22.57           C
ATOM   1314  CG1 ILE    78     -15.939  42.551   6.759  1.00 18.05           C
ATOM   1317  CD1 ILE    78     -15.865  42.959   5.251  1.00 17.41           C
ATOM   1321  CG2 ILE    78     -18.325  41.594   6.622  1.00 22.52           C
ATOM   1325  C   ILE    78     -17.788  39.956   8.967  1.00 21.73           C
ATOM   1326  O   ILE    78     -18.855  40.200   9.585  1.00 21.65           O
ATOM   1328  N   CYS    79     -17.439  38.728   8.613  1.00 20.07           N
ATOM   1329  CA  CYS    79     -18.311  37.600   8.882  1.00 23.10           C
ATOM   1331  CB  CYS    79     -17.826  36.354   8.142  1.00 20.26           C
ATOM   1334  SG  CYS    79     -18.872  34.951   8.328  1.00 27.18           S
ATOM   1336  C   CYS    79     -18.495  37.325  10.382  1.00 30.41           C
ATOM   1337  O   CYS    79     -19.635  37.266  10.875  1.00 22.37           O
ATOM   1339  N   SER    80     -17.393  37.181  11.121  1.00 21.91           N
ATOM   1340  CA  SER    80     -17.494  36.878  12.545  1.00 24.30           C
ATOM   1342  CB  SER    80     -16.095  36.547  13.140  1.00 24.35           C
ATOM   1345  OG  SER    80     -15.237  37.672  13.063  1.00 25.08           O
ATOM   1347  C   SER    80     -18.235  37.984  13.349  1.00 18.40           C
ATOM   1348  O   SER    80     -18.966  37.663  14.285  1.00 23.97           O
ATOM   1350  N   ASN    81     -18.040  39.257  13.002  1.00 20.76           N
ATOM   1351  CA  ASN    81     -18.731  40.384  13.628  1.00 23.40           C
ATOM   1353  CB  ASN    81     -18.272  41.726  13.033  1.00 18.65           C
ATOM   1356  CG  ASN    81     -16.891  42.213  13.553  1.00 23.49           C
ATOM   1357  OD1 ASN    81     -16.312  41.626  14.419  1.00 22.48           O
ATOM   1358  ND2 ASN    81     -16.394  43.279  12.976  1.00 20.38           N
ATOM   1361  C   ASN    81     -20.283  40.263  13.424  1.00 31.33           C
ATOM   1362  O   ASN    81     -21.087  40.528  14.334  1.00 26.82           O
ATOM   1364  N   ALA    82     -20.677  39.859  12.217  1.00 25.71           N
ATOM   1365  CA  ALA    82     -22.082  39.664  11.864  1.00 25.53           C
ATOM   1367  CB  ALA    82     -22.259  39.508  10.281  1.00 21.68           C
ATOM   1371  C   ALA    82     -22.675  38.493  12.648  1.00 19.47           C
ATOM   1372  O   ALA    82     -23.782  38.620  13.195  1.00 28.46           O
ATOM   1374  N   LEU    83     -21.945  37.393  12.806  1.00 22.22           N
ATOM   1375  CA  LEU    83     -22.458  36.275  13.567  1.00 23.51           C
ATOM   1377  CB  LEU    83     -21.630  34.996  13.381  1.00 25.32           C
ATOM   1380  CG  LEU    83     -21.284  34.549  11.947  1.00 34.57           C
ATOM   1382  CD1 LEU    83     -20.593  33.216  11.961  1.00 35.58           C
ATOM   1386  CD2 LEU    83     -22.467  34.549  11.013  1.00 26.17           C
ATOM   1390  C   LEU    83     -22.621  36.565  15.064  1.00 29.52           C
ATOM   1391  O   LEU    83     -23.595  36.103  15.672  1.00 26.06           O
ATOM   1393  N   GLU    84     -21.666  37.318  15.619  1.00 32.26           N
ATOM   1394  CA  GLU    84     -21.643  37.710  17.035  1.00 32.94           C
ATOM   1396  CB  GLU    84     -20.292  38.372  17.403  1.00 28.31           C
ATOM   1399  CG  GLU    84     -20.112  38.708  18.919  1.00 46.52           C
ATOM   1402  CD  GLU    84     -19.012  39.774  19.248  1.00 64.97           C
ATOM   1403  OE1 GLU    84     -19.027  40.289  20.394  1.00 62.98           O
ATOM   1404  OE2 GLU    84     -18.146  40.107  18.397  1.00 54.59           O
ATOM   1405  C   GLU    84     -22.775  38.669  17.351  1.00 24.93           C
ATOM   1406  O   GLU    84     -23.505  38.480  18.326  1.00 31.68           O
ATOM   1408  N   TYR    85     -22.917  39.687  16.517  1.00 25.04           N
ATOM   1409  CA  TYR    85     -23.859  40.737  16.750  1.00 31.73           C
ATOM   1411  CB  TYR    85     -23.552  41.964  15.894  1.00 27.37           C
ATOM   1414  CG  TYR    85     -24.285  43.193  16.424  1.00 43.81           C
ATOM   1415  CD1 TYR    85     -23.935  43.754  17.660  1.00 43.60           C
ATOM   1417  CE1 TYR    85     -24.609  44.867  18.169  1.00 51.06           C
ATOM   1419  CZ  TYR    85     -25.656  45.414  17.451  1.00 53.75           C
ATOM   1420  OH  TYR    85     -26.323  46.502  17.953  1.00 59.40           O
ATOM   1422  CE2 TYR    85     -26.032  44.869  16.232  1.00 45.06           C
ATOM   1424  CD2 TYR    85     -25.355  43.757  15.730  1.00 46.35           C
ATOM   1426  C   TYR    85     -25.312  40.326  16.468  1.00 32.29           C
ATOM   1427  O   TYR    85     -26.218  41.016  16.913  1.00 28.58           O
ATOM   1429  N   ASN    86     -25.511  39.244  15.713  1.00 32.89           N
ATOM   1430  CA  ASN    86     -26.859  38.825  15.262  1.00 31.75           C
ATOM   1432  CB  ASN    86     -27.062  39.151  13.773  1.00 32.32           C
ATOM   1435  CG  ASN    86     -26.831  40.612  13.440  1.00 31.15           C
ATOM   1436  OD1 ASN    86     -27.673  41.450  13.688  1.00 30.56           O
ATOM   1437  ND2 ASN    86     -25.687  40.919  12.835  1.00 33.47           N
ATOM   1440  C   ASN    86     -27.014  37.350  15.457  1.00 27.49           C
ATOM   1441  O   ASN    86     -27.161  36.616  14.483  1.00 31.91           O
ATOM   1443  N   PRO    87     -26.979  36.884  16.722  1.00 26.55           N
ATOM   1444  CA  PRO    87     -26.859  35.458  17.020  1.00 26.12           C
ATOM   1446  CB  PRO    87     -26.139  35.465  18.366  1.00 32.64           C
ATOM   1449  CG  PRO    87     -26.617  36.704  19.004  1.00 27.94           C
ATOM   1452  CD  PRO    87     -26.987  37.682  17.965  1.00 31.83           C
ATOM   1455  C   PRO    87     -28.190  34.720  17.191  1.00 23.77           C
ATOM   1456  O   PRO    87     -28.184  33.511  17.376  1.00 31.41           O
ATOM   1457  N   ASP    88     -29.295  35.454  17.077  1.00 29.51           N
ATOM   1458  CA  ASP    88     -30.628  34.995  17.492  1.00 30.57           C
ATOM   1460  CB  ASP    88     -31.499  36.214  17.808  1.00 33.78           C
ATOM   1463  CG  ASP    88     -31.018  36.990  19.037  1.00 44.32           C
ATOM   1464  OD1 ASP    88     -30.049  36.557  19.695  1.00 30.51           O
ATOM   1465  OD2 ASP    88     -31.618  38.042  19.343  1.00 45.37           O
ATOM   1466  C   ASP    88     -31.314  34.154  16.417  1.00 35.10           C
ATOM   1467  O   ASP    88     -30.874  34.159  15.254  1.00 27.40           O
ATOM   1469  N   ARG    89     -32.377  33.435  16.798  1.00 30.45           N
ATOM   1470  CA  ARG    89     -33.120  32.566  15.840  1.00 28.72           C
ATOM   1472  CB  ARG    89     -33.869  31.411  16.551  0.50 33.38           C
ATOM   1478  CG  ARG    89     -35.167  31.777  17.355  0.50 37.37           C
ATOM   1484  CD  ARG    89     -36.517  31.729  16.550  0.50 23.22           C
ATOM   1490  NE  ARG    89     -36.709  30.558  15.702  0.50 14.53           N
ATOM   1494  CZ  ARG    89     -37.431  30.582  14.566  0.50 21.38           C
ATOM   1496  NH1 ARG    89     -37.964  31.725  14.152  0.50 19.03           N
ATOM   1502  NH2 ARG    89     -37.589  29.485  13.816  0.50 13.40           N
ATOM   1508  C   ARG    89     -34.104  33.315  14.959  1.00 26.11           C
ATOM   1509  O   ARG    89     -34.687  32.742  14.036  1.00 29.81           O
ATOM   1511  N   ASP    90     -34.292  34.590  15.208  1.00 23.54           N
ATOM   1512  CA  ASP    90     -35.264  35.315  14.430  1.00 29.60           C
ATOM   1514  CB  ASP    90     -35.570  36.660  15.055  1.00 30.13           C
ATOM   1517  CG  ASP    90     -34.416  37.592  15.029  1.00 38.59           C
ATOM   1518  OD1 ASP    90     -34.440  38.541  14.205  1.00 51.79           O
ATOM   1519  OD2 ASP    90     -33.495  37.374  15.835  1.00 59.04           O
ATOM   1520  C   ASP    90     -34.818  35.489  12.968  1.00 31.35           C
ATOM   1521  O   ASP    90     -33.608  35.485  12.679  1.00 27.12           O
ATOM   1523  N   PRO    91     -35.796  35.658  12.057  1.00 30.02           N
ATOM   1524  CA  PRO    91     -35.509  35.719  10.624  1.00 27.31           C
ATOM   1526  CB  PRO    91     -36.888  35.982   9.996  1.00 31.62           C
ATOM   1529  CG  PRO    91     -37.870  35.529  10.995  1.00 30.59           C
ATOM   1532  CD  PRO    91     -37.249  35.720  12.332  1.00 29.64           C
ATOM   1535  C   PRO    91     -34.517  36.811  10.209  1.00 22.34           C
ATOM   1536  O   PRO    91     -33.705  36.580   9.308  1.00 20.72           O
ATOM   1537  N   GLY    92     -34.594  37.996  10.814  1.00 21.91           N
ATOM   1538  CA  GLY    92     -33.644  39.081  10.479  1.00 27.46           C
ATOM   1541  C   GLY    92     -32.189  38.688  10.774  1.00 28.37           C
ATOM   1542  O   GLY    92     -31.291  38.926   9.959  1.00 26.07           O
ATOM   1544  N   ASP    93     -31.988  38.036  11.921  1.00 29.00           N
ATOM   1545  CA  ASP    93     -30.671  37.565  12.363  1.00 28.59           C
ATOM   1547  CB  ASP    93     -30.706  37.160  13.839  1.00 27.55           C
ATOM   1550  CG  ASP    93     -30.501  38.352  14.797  1.00 29.39           C
ATOM   1551  OD1 ASP    93     -30.830  39.510  14.444  1.00 34.06           O
ATOM   1552  OD2 ASP    93     -29.975  38.111  15.906  1.00 30.80           O
ATOM   1553  C   ASP    93     -30.200  36.391  11.496  1.00 27.19           C
ATOM   1554  O   ASP    93     -29.054  36.350  11.035  1.00 22.18           O
ATOM   1556  N   ARG    94     -31.084  35.433  11.257  1.00 23.21           N
ATOM   1557  CA  ARG    94     -30.707  34.307  10.424  1.00 23.79           C
ATOM   1559  CB  ARG    94     -31.766  33.209  10.471  1.00 25.48           C
ATOM   1562  CG  ARG    94     -31.737  32.427  11.740  1.00 27.61           C
ATOM   1565  CD  ARG    94     -32.760  31.383  11.762  1.00 30.35           C
ATOM   1568  NE  ARG    94     -32.587  30.462  12.881  1.00 29.92           N
ATOM   1570  CZ  ARG    94     -33.515  29.601  13.303  1.00 44.64           C
ATOM   1571  NH1 ARG    94     -34.696  29.524  12.707  1.00 49.89           N
ATOM   1574  NH2 ARG    94     -33.253  28.800  14.329  1.00 50.28           N
ATOM   1577  C   ARG    94     -30.353  34.733   8.984  1.00 20.18           C
ATOM   1578  O   ARG    94     -29.450  34.143   8.402  1.00 24.67           O
ATOM   1580  N   LEU    95     -31.024  35.742   8.429  1.00 22.52           N
ATOM   1581  CA  LEU    95     -30.721  36.233   7.093  1.00 22.83           C
ATOM   1583  CB  LEU    95     -31.778  37.231   6.586  1.00 17.27           C
ATOM   1586  CG  LEU    95     -31.622  37.872   5.193  1.00 13.78           C
ATOM   1588  CD1 LEU    95     -31.591  36.803   4.083  1.00 17.27           C
ATOM   1592  CD2 LEU    95     -32.741  38.938   4.931  1.00 18.04           C
ATOM   1596  C   LEU    95     -29.303  36.857   7.025  1.00 27.03           C
ATOM   1597  O   LEU    95     -28.513  36.509   6.145  1.00 18.85           O
ATOM   1599  N   ILE    96     -29.003  37.775   7.935  1.00 24.56           N
ATOM   1600  CA  ILE    96     -27.664  38.412   7.975  1.00 25.27           C
ATOM   1602  CB  ILE    96     -27.557  39.557   9.048  1.00 24.78           C
ATOM   1604  CG1 ILE    96     -26.213  40.323   8.878  1.00 26.50           C
ATOM   1607  CD1 ILE    96     -26.245  41.771   9.362  1.00 33.12           C
ATOM   1611  CG2 ILE    96     -27.670  38.996  10.451  1.00 39.55           C
ATOM   1615  C   ILE    96     -26.548  37.377   8.152  1.00 19.60           C
ATOM   1616  O   ILE    96     -25.527  37.461   7.468  1.00 21.18           O
ATOM   1618  N   ARG    97     -26.758  36.383   9.014  1.00 22.09           N
ATOM   1619  CA  ARG    97     -25.730  35.337   9.236  1.00 23.22           C
ATOM   1621  CB  ARG    97     -26.055  34.442  10.418  1.00 23.31           C
ATOM   1624  CG  ARG    97     -26.059  35.147  11.791  1.00 18.24           C
ATOM   1627  CD  ARG    97     -25.825  34.149  12.895  1.00 24.44           C
ATOM   1630  NE  ARG    97     -26.714  32.993  12.966  1.00 28.83           N
ATOM   1632  CZ  ARG    97     -27.954  32.988  13.471  1.00 27.43           C
ATOM   1633  NH1 ARG    97     -28.502  34.084  13.952  1.00 30.54           N
ATOM   1636  NH2 ARG    97     -28.636  31.867  13.506  1.00 34.39           N
ATOM   1639  C   ARG    97     -25.531  34.480   8.000  1.00 23.61           C
ATOM   1640  O   ARG    97     -24.405  34.077   7.685  1.00 19.92           O
ATOM   1642  N   HIS    98     -26.632  34.171   7.313  1.00 21.18           N
ATOM   1643  CA  HIS    98     -26.543  33.431   6.046  1.00 22.64           C
ATOM   1645  CB  HIS    98     -27.941  33.050   5.530  1.00 21.77           C
ATOM   1648  CG  HIS    98     -27.908  32.137   4.350  1.00 26.85           C
ATOM   1649  ND1 HIS    98     -27.908  32.597   3.046  1.00 26.01           N
ATOM   1651  CE1 HIS    98     -27.851  31.562   2.226  1.00 24.25           C
ATOM   1653  NE2 HIS    98     -27.801  30.456   2.946  1.00 24.82           N
ATOM   1655  CD2 HIS    98     -27.832  30.790   4.278  1.00 20.83           C
ATOM   1657  C   HIS    98     -25.762  34.212   4.969  1.00 17.30           C
ATOM   1658  O   HIS    98     -24.933  33.631   4.248  1.00 18.06           O
ATOM   1660  N   ARG    99     -26.027  35.506   4.899  1.00 19.10           N
ATOM   1661  CA  ARG    99     -25.316  36.441   4.018  1.00 20.88           C
ATOM   1663  CB  ARG    99     -26.027  37.773   3.997  1.00 20.64           C
ATOM   1666  CG  ARG    99     -27.387  37.732   3.223  1.00 20.88           C
ATOM   1669  CD  ARG    99     -28.174  38.962   3.458  1.00 21.51           C
ATOM   1672  NE  ARG    99     -29.294  39.078   2.521  1.00 23.06           N
ATOM   1674  CZ  ARG    99     -30.191  40.058   2.555  1.00 20.30           C
ATOM   1675  NH1 ARG    99     -30.091  41.023   3.440  1.00 21.05           N
ATOM   1678  NH2 ARG    99     -31.181  40.093   1.678  1.00 21.17           N
ATOM   1681  C   ARG    99     -23.838  36.630   4.382  1.00 20.58           C
ATOM   1682  O   ARG    99     -22.988  36.706   3.488  1.00 17.96           O
ATOM   1684  N   ALA   100     -23.558  36.732   5.683  1.00 19.17           N
ATOM   1685  CA  ALA   100     -22.195  36.813   6.217  1.00 21.85           C
ATOM   1687  CB  ALA   100     -22.225  36.938   7.764  1.00 16.22           C
ATOM   1691  C   ALA   100     -21.351  35.615   5.791  1.00 20.05           C
ATOM   1692  O   ALA   100     -20.221  35.796   5.311  1.00 23.60           O
ATOM   1694  N   CYS   101     -21.907  34.415   5.973  1.00 21.28           N
ATOM   1695  CA  CYS   101     -21.276  33.158   5.610  1.00 21.52           C
ATOM   1697  CB  CYS   101     -22.079  31.960   6.126  1.00 28.07           C
ATOM   1700  SG  CYS   101     -21.972  31.797   7.936  1.00 31.25           S
ATOM   1702  C   CYS   101     -21.051  33.023   4.124  1.00 25.37           C
ATOM   1703  O   CYS   101     -19.999  32.501   3.714  1.00 19.19           O
ATOM   1705  N   ALA   102     -22.016  33.503   3.337  1.00 21.90           N
ATOM   1706  CA  ALA   102     -21.892  33.511   1.882  1.00 22.12           C
ATOM   1708  CB  ALA   102     -23.235  33.849   1.188  1.00 15.78           C
ATOM   1712  C   ALA   102     -20.790  34.486   1.442  1.00 20.27           C
ATOM   1713  O   ALA   102     -20.054  34.187   0.513  1.00 19.10           O
ATOM   1715  N   LEU   103     -20.716  35.655   2.073  1.00 16.83           N
ATOM   1716  CA  LEU   103     -19.665  36.644   1.771  1.00 18.39           C
ATOM   1718  CB  LEU   103     -19.805  37.899   2.654  1.00 23.15           C
ATOM   1721  CG  LEU   103     -18.663  38.922   2.545  1.00 30.05           C
ATOM   1723  CD1 LEU   103     -18.835  39.688   1.281  1.00 28.54           C
ATOM   1727  CD2 LEU   103     -18.626  39.860   3.741  1.00 37.11           C
ATOM   1731  C   LEU   103     -18.284  35.999   1.972  1.00 22.05           C
ATOM   1732  O   LEU   103     -17.399  36.073   1.096  1.00 16.43           O
ATOM   1734  N   ARG   104     -18.145  35.347   3.118  1.00 20.87           N
ATOM   1735  CA  ARG   104     -16.942  34.619   3.490  1.00 19.58           C
ATOM   1737  CB  ARG   104     -17.073  34.081   4.903  1.00 21.66           C
ATOM   1740  CG  ARG   104     -15.809  33.343   5.449  1.00 26.94           C
ATOM   1743  CD  ARG   104     -16.189  32.403   6.579  1.00 37.02           C
ATOM   1746  NE  ARG   104     -17.176  31.418   6.120  1.00 39.15           N
ATOM   1748  CZ  ARG   104     -18.107  30.830   6.873  1.00 47.77           C
ATOM   1749  NH1 ARG   104     -18.226  31.107   8.170  1.00 40.34           N
ATOM   1752  NH2 ARG   104     -18.941  29.960   6.318  1.00 32.08           N
ATOM   1755  C   ARG   104     -16.608  33.498   2.514  1.00 21.51           C
ATOM   1756  O   ARG   104     -15.502  33.451   1.985  1.00 19.81           O
ATOM   1758  N   ASP   105     -17.569  32.614   2.252  1.00 19.85           N
ATOM   1759  CA  ASP   105     -17.371  31.514   1.328  1.00 18.95           C
ATOM   1761  CB  ASP   105     -18.589  30.579   1.310  1.00 19.94           C
ATOM   1764  CG  ASP   105     -18.786  29.817   2.617  1.00 29.87           C
ATOM   1765  OD1 ASP   105     -17.890  29.804   3.497  1.00 25.79           O
ATOM   1766  OD2 ASP   105     -19.875  29.240   2.759  1.00 32.06           O
ATOM   1767  C   ASP   105     -17.071  31.980  -0.091  1.00 18.74           C
ATOM   1768  O   ASP   105     -16.165  31.416  -0.760  1.00 18.41           O
ATOM   1770  N   THR   106     -17.805  32.999  -0.550  1.00 16.32           N
ATOM   1771  CA  THR   106     -17.554  33.568  -1.857  1.00 17.31           C
ATOM   1773  CB  THR   106     -18.592  34.671  -2.215  1.00 19.60           C
ATOM   1775  OG1 THR   106     -19.910  34.091  -2.200  1.00 21.70           O
ATOM   1777  CG2 THR   106     -18.293  35.280  -3.582  1.00 21.15           C
ATOM   1781  C   THR   106     -16.110  34.103  -2.046  1.00 18.99           C
ATOM   1782  O   THR   106     -15.477  33.831  -3.076  1.00 17.74           O
ATOM   1784  N   ALA   107     -15.637  34.895  -1.094  1.00 15.61           N
ATOM   1785  CA  ALA   107     -14.289  35.420  -1.112  1.00 21.64           C
ATOM   1787  CB  ALA   107     -14.046  36.389   0.104  1.00 18.61           C
ATOM   1791  C   ALA   107     -13.247  34.298  -1.143  1.00 18.51           C
ATOM   1792  O   ALA   107     -12.335  34.325  -1.983  1.00 17.14           O
ATOM   1794  N   TYR   108     -13.401  33.301  -0.262  1.00 19.06           N
ATOM   1795  CA  TYR   108     -12.468  32.196  -0.209  1.00 20.55           C
ATOM   1797  CB  TYR   108     -12.759  31.244   0.955  1.00 19.96           C
ATOM   1800  CG  TYR   108     -12.056  31.638   2.231  1.00 25.99           C
ATOM   1801  CD1 TYR   108     -12.606  32.576   3.103  1.00 24.70           C
ATOM   1803  CE1 TYR   108     -11.952  32.927   4.290  1.00 20.39           C
ATOM   1805  CZ  TYR   108     -10.747  32.334   4.587  1.00 20.84           C
ATOM   1806  OH  TYR   108     -10.069  32.659   5.731  1.00 24.88           O
ATOM   1808  CE2 TYR   108     -10.178  31.414   3.723  1.00 24.61           C
ATOM   1810  CD2 TYR   108     -10.817  31.077   2.565  1.00 25.48           C
ATOM   1812  C   TYR   108     -12.408  31.452  -1.529  1.00 20.31           C
ATOM   1813  O   TYR   108     -11.310  31.099  -1.995  1.00 17.23           O
ATOM   1815  N   ALA   109     -13.574  31.289  -2.149  1.00 19.03           N
ATOM   1816  CA  ALA   109     -13.706  30.564  -3.412  1.00 23.11           C
ATOM   1818  CB  ALA   109     -15.176  30.300  -3.685  1.00 18.89           C
ATOM   1822  C   ALA   109     -13.061  31.284  -4.604  1.00 20.50           C
ATOM   1823  O   ALA   109     -12.427  30.638  -5.470  1.00 18.55           O
ATOM   1825  N   ILE   110     -13.267  32.605  -4.688  1.00 19.36           N
ATOM   1826  CA  ILE   110     -12.599  33.421  -5.725  1.00 21.96           C
ATOM   1828  CB  ILE   110     -13.063  34.925  -5.709  1.00 18.58           C
ATOM   1830  CG1 ILE   110     -14.535  35.027  -6.122  1.00 22.18           C
ATOM   1833  CD1 ILE   110     -15.215  36.373  -5.838  1.00 14.78           C
ATOM   1837  CG2 ILE   110     -12.170  35.812  -6.630  1.00 14.29           C
ATOM   1841  C   ILE   110     -11.071  33.311  -5.607  1.00 19.10           C
ATOM   1842  O   ILE   110     -10.372  33.040  -6.591  1.00 17.26           O
ATOM   1844  N   ILE   111     -10.561  33.544  -4.408  1.00 19.19           N
ATOM   1845  CA  ILE   111      -9.131  33.411  -4.116  1.00 25.44           C
ATOM   1847  CB  ILE   111      -8.800  33.800  -2.614  1.00 22.02           C
ATOM   1849  CG1 ILE   111      -8.927  35.319  -2.466  0.50 24.12           C
ATOM   1855  CD1 ILE   111      -8.975  35.821  -1.034  0.50 24.28           C
ATOM   1863  CG2 ILE   111      -7.377  33.351  -2.186  0.50 20.27           C
ATOM   1871  C   ILE   111      -8.594  32.012  -4.480  1.00 23.43           C
ATOM   1872  O   ILE   111      -7.521  31.889  -5.076  1.00 21.51           O
ATOM   1874  N   LYS   112      -9.331  30.970  -4.113  1.00 20.95           N
ATOM   1875  CA  LYS   112      -8.891  29.605  -4.401  1.00 25.13           C
ATOM   1877  CB  LYS   112      -9.815  28.569  -3.758  1.00 24.23           C
ATOM   1880  CG  LYS   112      -9.267  27.139  -3.851  1.00 34.87           C
ATOM   1883  CD  LYS   112     -10.337  26.124  -3.532  1.00 39.00           C
ATOM   1886  CE  LYS   112      -9.719  24.728  -3.388  1.00 41.73           C
ATOM   1889  NZ  LYS   112     -10.780  23.712  -3.284  1.00 50.37           N
ATOM   1893  C   LYS   112      -8.788  29.353  -5.898  1.00 22.73           C
ATOM   1894  O   LYS   112      -7.847  28.719  -6.353  1.00 23.80           O
ATOM   1896  N   GLU   113      -9.746  29.853  -6.661  1.00 20.61           N
ATOM   1897  CA  GLU   113      -9.742  29.692  -8.104  1.00 21.10           C
ATOM   1899  CB  GLU   113     -11.151  29.903  -8.655  1.00 24.85           C
ATOM   1902  CG  GLU   113     -11.376  29.291 -10.028  1.00 42.67           C
ATOM   1905  CD  GLU   113     -12.830  28.871 -10.218  1.00 63.40           C
ATOM   1906  OE1 GLU   113     -13.664  29.740 -10.555  1.00 53.37           O
ATOM   1907  OE2 GLU   113     -13.141  27.678 -10.014  1.00 73.30           O
ATOM   1908  C   GLU   113      -8.761  30.627  -8.834  1.00 22.80           C
ATOM   1909  O   GLU   113      -8.143  30.225  -9.814  1.00 22.99           O
ATOM   1911  N   GLU   114      -8.624  31.869  -8.371  1.00 18.16           N
ATOM   1912  CA  GLU   114      -7.987  32.916  -9.174  1.00 20.66           C
ATOM   1914  CB  GLU   114      -8.942  34.104  -9.351  1.00 17.76           C
ATOM   1917  CG  GLU   114     -10.303  33.700 -10.004  1.00 20.51           C
ATOM   1920  CD  GLU   114     -11.257  34.857 -10.154  1.00 22.62           C
ATOM   1921  OE1 GLU   114     -10.785  36.015 -10.211  1.00 23.24           O
ATOM   1922  OE2 GLU   114     -12.497  34.622 -10.190  1.00 20.23           O
ATOM   1923  C   GLU   114      -6.638  33.436  -8.660  1.00 17.59           C
ATOM   1924  O   GLU   114      -5.978  34.135  -9.388  1.00 22.00           O
ATOM   1926  N   LEU   115      -6.264  33.152  -7.424  1.00 17.35           N
ATOM   1927  CA  LEU   115      -4.969  33.587  -6.918  1.00 22.63           C
ATOM   1929  CB  LEU   115      -5.031  34.089  -5.488  1.00 25.32           C
ATOM   1932  CG  LEU   115      -3.736  34.808  -5.019  1.00 27.81           C
ATOM   1934  CD1 LEU   115      -3.541  36.132  -5.784  1.00 29.99           C
ATOM   1938  CD2 LEU   115      -3.802  35.013  -3.544  1.00 34.72           C
ATOM   1942  C   LEU   115      -3.995  32.413  -7.027  1.00 22.59           C
ATOM   1943  O   LEU   115      -4.200  31.351  -6.437  1.00 25.27           O
ATOM   1945  N   ASP   116      -2.956  32.608  -7.823  1.00 26.87           N
ATOM   1946  CA  ASP   116      -1.931  31.598  -8.001  1.00 21.26           C
ATOM   1948  CB  ASP   116      -0.940  32.039  -9.085  1.00 24.60           C
ATOM   1951  CG  ASP   116      -0.014  30.945  -9.463  1.00 32.72           C
ATOM   1952  OD1 ASP   116       0.802  30.520  -8.621  1.00 35.85           O
ATOM   1953  OD2 ASP   116      -0.116  30.482 -10.603  1.00 30.51           O
ATOM   1954  C   ASP   116      -1.217  31.405  -6.686  1.00 19.88           C
ATOM   1955  O   ASP   116      -0.797  32.367  -6.070  1.00 17.18           O
ATOM   1957  N   GLU   117      -1.072  30.153  -6.273  1.00 19.70           N
ATOM   1958  CA  GLU   117      -0.423  29.793  -5.015  1.00 21.71           C
ATOM   1960  CB  GLU   117      -0.505  28.281  -4.806  1.00 24.97           C
ATOM   1963  CG  GLU   117      -1.873  27.805  -4.351  1.00 47.68           C
ATOM   1966  CD  GLU   117      -1.993  26.281  -4.377  1.00 62.52           C
ATOM   1967  OE1 GLU   117      -1.051  25.592  -3.917  1.00 68.27           O
ATOM   1968  OE2 GLU   117      -3.025  25.781  -4.872  1.00 64.53           O
ATOM   1969  C   GLU   117       1.034  30.252  -4.904  1.00 19.02           C
ATOM   1970  O   GLU   117       1.505  30.575  -3.804  1.00 21.23           O
ATOM   1972  N   ASP   118       1.726  30.300  -6.037  1.00 21.76           N
ATOM   1973  CA  ASP   118       3.114  30.755  -6.084  1.00 23.35           C
ATOM   1975  CB  ASP   118       3.807  30.259  -7.362  1.00 23.22           C
ATOM   1978  CG  ASP   118       4.031  28.759  -7.344  1.00 23.95           C
ATOM   1979  OD1 ASP   118       4.153  28.174  -6.239  1.00 27.42           O
ATOM   1980  OD2 ASP   118       4.053  28.181  -8.419  1.00 34.51           O
ATOM   1981  C   ASP   118       3.216  32.252  -5.989  1.00 19.61           C
ATOM   1982  O   ASP   118       4.183  32.772  -5.444  1.00 21.35           O
ATOM   1984  N   PHE   119       2.205  32.953  -6.489  1.00 20.03           N
ATOM   1985  CA  PHE   119       2.117  34.407  -6.319  1.00 18.31           C
ATOM   1987  CB  PHE   119       0.999  35.022  -7.194  1.00 21.75           C
ATOM   1990  CG  PHE   119       0.877  36.501  -7.019  1.00 18.23           C
ATOM   1991  CD1 PHE   119       1.697  37.368  -7.744  1.00 20.63           C
ATOM   1993  CE1 PHE   119       1.645  38.724  -7.536  1.00 20.18           C
ATOM   1995  CZ  PHE   119       0.778  39.242  -6.595  1.00 20.66           C
ATOM   1997  CE2 PHE   119      -0.028  38.399  -5.840  1.00 21.25           C
ATOM   1999  CD2 PHE   119       0.034  37.039  -6.034  1.00 23.39           C
ATOM   2001  C   PHE   119       1.943  34.760  -4.820  1.00 20.04           C
ATOM   2002  O   PHE   119       2.636  35.652  -4.300  1.00 19.24           O
ATOM   2004  N   GLU   120       1.019  34.061  -4.149  1.00 19.65           N
ATOM   2005  CA  GLU   120       0.771  34.243  -2.721  1.00 20.07           C
ATOM   2007  CB  GLU   120      -0.452  33.418  -2.270  1.00 19.67           C
ATOM   2010  CG  GLU   120      -0.776  33.431  -0.751  1.00 18.22           C
ATOM   2013  CD  GLU   120      -0.842  34.838  -0.076  1.00 24.26           C
ATOM   2014  OE1 GLU   120      -0.993  35.867  -0.749  1.00 22.01           O
ATOM   2015  OE2 GLU   120      -0.748  34.920   1.166  1.00 31.38           O
ATOM   2016  C   GLU   120       2.011  33.896  -1.906  1.00 20.48           C
ATOM   2017  O   GLU   120       2.382  34.653  -1.004  1.00 18.84           O
ATOM   2019  N   GLN   121       2.694  32.812  -2.281  1.00 23.00           N
ATOM   2020  CA  GLN   121       3.915  32.389  -1.584  1.00 25.45           C
ATOM   2022  CB  GLN   121       4.429  31.033  -2.118  1.00 27.28           C
ATOM   2025  CG  GLN   121       5.608  30.447  -1.317  1.00 21.66           C
ATOM   2028  CD  GLN   121       5.278  30.213   0.151  1.00 33.37           C
ATOM   2029  OE1 GLN   121       4.152  29.870   0.483  1.00 32.16           O
ATOM   2030  NE2 GLN   121       6.259  30.418   1.037  1.00 26.32           N
ATOM   2033  C   GLN   121       5.004  33.462  -1.667  1.00 23.94           C
ATOM   2034  O   GLN   121       5.652  33.769  -0.654  1.00 23.54           O
ATOM   2036  N   LEU   122       5.194  34.028  -2.859  1.00 20.47           N
ATOM   2037  CA  LEU   122       6.070  35.185  -3.031  1.00 18.08           C
ATOM   2039  CB  LEU   122       6.086  35.684  -4.483  1.00 19.06           C
ATOM   2042  CG  LEU   122       7.034  36.853  -4.806  1.00 21.41           C
ATOM   2044  CD1 LEU   122       8.500  36.550  -4.318  1.00 21.01           C
ATOM   2048  CD2 LEU   122       6.981  37.263  -6.284  1.00 19.35           C
ATOM   2052  C   LEU   122       5.717  36.346  -2.102  1.00 25.99           C
ATOM   2053  O   LEU   122       6.595  36.878  -1.426  1.00 22.53           O
ATOM   2055  N   CYS   123       4.442  36.746  -2.073  1.00 24.30           N
ATOM   2056  CA  CYS   123       3.986  37.824  -1.193  1.00 22.03           C
ATOM   2058  CB  CYS   123       2.462  38.013  -1.273  1.00 19.81           C
ATOM   2061  SG  CYS   123       1.949  38.719  -2.788  1.00 20.51           S
ATOM   2063  C   CYS   123       4.406  37.543   0.250  1.00 19.76           C
ATOM   2064  O   CYS   123       4.923  38.429   0.925  1.00 23.30           O
ATOM   2066  N   GLU   124       4.219  36.302   0.677  1.00 21.51           N
ATOM   2067  CA  GLU   124       4.498  35.894   2.033  1.00 23.50           C
ATOM   2069  CB  GLU   124       3.904  34.522   2.316  1.00 25.91           C
ATOM   2072  CG  GLU   124       2.354  34.523   2.426  1.00 34.93           C
ATOM   2075  CD  GLU   124       1.753  33.122   2.570  1.00 39.26           C
ATOM   2076  OE1 GLU   124       2.507  32.196   2.922  1.00 44.00           O
ATOM   2077  OE2 GLU   124       0.531  32.934   2.324  1.00 32.86           O
ATOM   2078  C   GLU   124       6.000  35.937   2.305  1.00 27.58           C
ATOM   2079  O   GLU   124       6.425  36.363   3.373  1.00 23.27           O
ATOM   2081  N   GLU   125       6.808  35.559   1.319  1.00 28.86           N
ATOM   2082  CA  GLU   125       8.266  35.568   1.498  1.00 28.47           C
ATOM   2084  CB  GLU   125       8.964  34.623   0.483  1.00 24.02           C
ATOM   2087  CG  GLU   125       8.640  33.169   0.845  1.00 24.03           C
ATOM   2090  CD  GLU   125       9.254  32.079  -0.028  1.00 24.11           C
ATOM   2091  OE1 GLU   125      10.097  32.389  -0.885  1.00 26.14           O
ATOM   2092  OE2 GLU   125       8.870  30.893   0.175  1.00 25.13           O
ATOM   2093  C   GLU   125       8.844  36.986   1.557  1.00 25.14           C
ATOM   2094  O   GLU   125       9.702  37.240   2.379  1.00 32.10           O
ATOM   2096  N   ILE   126       8.343  37.910   0.744  1.00 18.67           N
ATOM   2097  CA  ILE   126       8.744  39.303   0.794  1.00 28.52           C
ATOM   2099  CB  ILE   126       8.101  40.129  -0.336  1.00 27.83           C
ATOM   2101  CG1 ILE   126       8.493  39.568  -1.715  1.00 26.91           C
ATOM   2104  CD1 ILE   126       7.773  40.251  -2.894  1.00 26.67           C
ATOM   2108  CG2 ILE   126       8.485  41.616  -0.217  1.00 22.12           C
ATOM   2112  C   ILE   126       8.337  39.875   2.154  1.00 36.40           C
ATOM   2113  O   ILE   126       9.156  40.463   2.873  1.00 35.06           O
ATOM   2115  N   GLN   127       7.079  39.649   2.529  1.00 35.08           N
ATOM   2116  CA  GLN   127       6.566  40.142   3.807  1.00 38.66           C
ATOM   2118  CB  GLN   127       5.108  39.735   3.995  1.00 38.13           C
ATOM   2121  CG  GLN   127       4.372  40.616   4.976  1.00 46.73           C
ATOM   2124  CD  GLN   127       3.704  39.812   6.038  1.00 64.51           C
ATOM   2125  OE1 GLN   127       4.390  39.181   6.848  1.00 56.16           O
ATOM   2126  NE2 GLN   127       2.356  39.812   6.052  1.00 51.91           N
ATOM   2129  C   GLN   127       7.425  39.636   4.995  1.00 34.69           C
ATOM   2130  O   GLN   127       7.851  40.424   5.838  1.00 33.60           O
ATOM   2132  N   GLU   128       7.683  38.335   5.043  1.00 35.26           N
ATOM   2133  CA  GLU   128       8.563  37.745   6.067  1.00 40.39           C
ATOM   2135  CB  GLU   128       8.623  36.223   5.892  1.00 41.49           C
ATOM   2138  CG  GLU   128       7.485  35.491   6.573  1.00 47.02           C
ATOM   2141  CD  GLU   128       6.930  34.334   5.760  1.00 63.09           C
ATOM   2142  OE1 GLU   128       7.704  33.634   5.067  1.00 51.55           O
ATOM   2143  OE2 GLU   128       5.699  34.126   5.826  1.00 65.34           O
ATOM   2144  C   GLU   128      10.001  38.324   6.084  1.00 45.71           C
ATOM   2145  O   GLU   128      10.679  38.302   7.119  1.00 48.40           O
ATOM   2147  N   SER   129      10.462  38.833   4.946  1.00 43.84           N
ATOM   2148  CA  SER   129      11.809  39.391   4.843  1.00 48.65           C
ATOM   2150  CB  SER   129      12.296  39.375   3.386  1.00 43.37           C
ATOM   2153  OG  SER   129      11.800  40.487   2.656  1.00 42.87           O
ATOM   2155  C   SER   129      11.874  40.812   5.408  1.00 52.03           C
ATOM   2156  O   SER   129      12.965  41.358   5.592  1.00 53.77           O
ATOM   2158  N   ARG   130      10.711  41.410   5.661  1.00 53.93           N
ATOM   2159  CA  ARG   130      10.633  42.740   6.267  1.00 59.45           C
ATOM   2161  CB  ARG   130       9.391  43.497   5.759  1.00 54.21           C
ATOM   2164  CG  ARG   130       9.681  44.307   4.492  1.00 68.78           C
ATOM   2167  CD  ARG   130       8.593  44.234   3.428  1.00 58.27           C
ATOM   2170  NE  ARG   130       9.175  44.426   2.091  1.00 71.54           N
ATOM   2172  CZ  ARG   130       8.794  45.337   1.189  1.00 79.48           C
ATOM   2173  NH1 ARG   130       9.414  45.386   0.007  1.00 73.01           N
ATOM   2176  NH2 ARG   130       7.790  46.185   1.432  1.00 82.81           N
ATOM   2179  C   ARG   130      10.653  42.648   7.793  1.00 61.53           C
ATOM   2180  O   ARG   130       9.981  41.818   8.419  1.00 64.77           O
ATOM   2182  OXT ARG   130      11.374  43.409   8.435  1.00 67.56           O
END
