
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  111 (  907),  selected  111 , name 2nxb_A
# Molecule2: number of CA atoms  130 ( 1064),  selected  130 , name T0432.pdb
# PARAMETERS: 2nxb_A.T0432.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      S       1           -
LGA    -       -      M       2           -
LGA    -       -      Q       3           -
LGA    -       -      E       4           -
LGA    -       -      E       5           -
LGA    -       -      D       6           -
LGA    -       -      T       7           -
LGA    R    34_A      F       8          4.808
LGA    K    35_A      R       9          2.263
LGA    T    36_A      E      10          4.677
LGA    N    37_A      L      11          3.148
LGA    Q    38_A      -       -           -
LGA    L    39_A      R      12          3.940
LGA    Q    40_A      I      13          3.022
LGA    Y    41_A      F      14          2.274
LGA    M    42_A      L      15          2.173
LGA    Q    43_A      R      16          1.786
LGA    N    44_A      N      17          1.348
LGA    V    45_A      V      18          2.479
LGA    V    46_A      -       -           -
LGA    V    47_A      T      19          0.707
LGA    K    48_A      H      20          2.068
LGA    T    49_A      R      21          1.572
LGA    L    50_A      L      22          0.748
LGA    W    51_A      A      23          1.234
LGA    K    52_A      I      24          1.651
LGA    H    53_A      D      25          0.771
LGA    Q    54_A      K      26          0.679
LGA    F    55_A      R      27          1.492
LGA    A    56_A      F      28          1.699
LGA    W    57_A      R      29          1.466
LGA    P    58_A      V      30          1.360
LGA    F    59_A      F      31          1.186
LGA    Y    60_A      T      32          1.370
LGA    Q    61_A      K      33          1.549
LGA    P    62_A      P      34          1.305
LGA    V    63_A      V      35          1.204
LGA    D    64_A      D      36          1.805
LGA    A    65_A      P      37          2.340
LGA    I    66_A      D      38          2.071
LGA    K    67_A      -       -           -
LGA    L    68_A      E      39          0.835
LGA    N    69_A      V      40          3.364
LGA    L    70_A      P      41          3.037
LGA    P    71_A      -       -           -
LGA    D    72_A      D      42          2.280
LGA    Y    73_A      Y      43          1.661
LGA    H    74_A      V      44          2.220
LGA    K    75_A      T      45          2.288
LGA    I    76_A      V      46          1.946
LGA    I    77_A      I      47          0.857
LGA    K    78_A      K      48          1.154
LGA    N    79_A      Q      49          0.974
LGA    P    80_A      P      50          0.895
LGA    M    81_A      M      51          0.609
LGA    D    82_A      D      52          0.606
LGA    M    83_A      L      53          0.604
LGA    G    84_A      S      54          0.449
LGA    T    85_A      S      55          0.343
LGA    I    86_A      V      56          0.101
LGA    K    87_A      I      57          1.110
LGA    K    88_A      S      58          1.613
LGA    R    89_A      K      59          1.462
LGA    L    90_A      I      60          1.429
LGA    E    91_A      D      61          2.783
LGA    N    92_A      L      62          3.344
LGA    N    93_A      H      63          2.598
LGA    Y    94_A      K      64          2.848
LGA    Y    95_A      Y      65          2.169
LGA    W    96_A      L      66          2.661
LGA    S    97_A      T      67          2.422
LGA    A    98_A      V      68          2.333
LGA    S    99_A      K      69          1.624
LGA    E   100_A      D      70          1.426
LGA    C   101_A      Y      71          1.265
LGA    M   102_A      L      72          0.996
LGA    Q   103_A      R      73          0.578
LGA    D   104_A      D      74          0.720
LGA    F   105_A      I      75          0.768
LGA    N   106_A      D      76          0.534
LGA    T   107_A      L      77          0.631
LGA    M   108_A      I      78          0.835
LGA    F   109_A      C      79          0.635
LGA    T   110_A      S      80          0.283
LGA    N   111_A      N      81          0.231
LGA    C   112_A      A      82          0.412
LGA    Y   113_A      L      83          0.347
LGA    I   114_A      E      84          0.158
LGA    Y   115_A      Y      85          0.470
LGA    N   116_A      N      86          0.168
LGA    K   117_A      P      87          2.874
LGA    -       -      D      88           -
LGA    P   118_A      R      89          4.527
LGA    T   119_A      D      90          3.911
LGA    D   120_A      P      91          4.061
LGA    D   121_A      G      92          3.449
LGA    -       -      D      93           -
LGA    -       -      R      94           -
LGA    -       -      L      95           -
LGA    I   122_A      I      96          1.820
LGA    V   123_A      R      97          1.876
LGA    L   124_A      H      98          2.486
LGA    M   125_A      R      99          2.191
LGA    A   126_A      A     100          1.709
LGA    Q   127_A      C     101          2.554
LGA    A   128_A      A     102          2.458
LGA    L   129_A      L     103          1.834
LGA    E   130_A      R     104          2.104
LGA    K   131_A      D     105          2.147
LGA    I   132_A      T     106          0.878
LGA    F   133_A      A     107          1.537
LGA    L   134_A      Y     108          2.176
LGA    Q   135_A      A     109          1.191
LGA    K   136_A      I     110          1.527
LGA    V   137_A      I     111          2.567
LGA    A   138_A      K     112          2.067
LGA    Q   139_A      E     113          2.553
LGA    -       -      E     114           -
LGA    M   140_A      L     115          2.397
LGA    P   141_A      D     116          1.903
LGA    Q   142_A      E     117          2.912
LGA    -       -      D     118           -
LGA    E   143_A      F     119          1.340
LGA    -       -      E     120           -
LGA    -       -      Q     121           -
LGA    E   144_A      L     122          5.461
LGA    -       -      C     123           -
LGA    -       -      E     124           -
LGA    -       -      E     125           -
LGA    -       -      I     126           -
LGA    -       -      Q     127           -
LGA    -       -      E     128           -
LGA    -       -      S     129           -
LGA    -       -      R     130           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  111  130    5.0    107    2.10    21.50     71.354     4.868

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.519749 * X  +  -0.763417 * Y  +   0.383478 * Z  + -23.749716
  Y_new =   0.581654 * X  +  -0.012553 * Y  +  -0.813339 * Z  +  45.974258
  Z_new =   0.625730 * X  +   0.645784 * Y  +   0.437520 * Z  +  11.313453 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.975330   -2.166263  [ DEG:    55.8823   -124.1177 ]
  Theta =  -0.676068   -2.465525  [ DEG:   -38.7358   -141.2642 ]
  Phi   =   0.841545   -2.300048  [ DEG:    48.2170   -131.7830 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2nxb_A                                        
REMARK     2: T0432.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2nxb_A.T0432.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  111  130   5.0  107   2.10   21.50  71.354
REMARK  ---------------------------------------------------------- 
MOLECULE 2nxb_A
HEADER    SIGNALING PROTEIN                       17-NOV-06   2NXB              
TITLE     CRYSTAL STRUCTURE OF HUMAN BROMODOMAIN CONTAINING PROTEIN 3           
TITLE    2 (BRD3)                                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BROMODOMAIN-CONTAINING PROTEIN 3;                          
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: BROMO 1 DOMAIN;                                            
COMPND   5 SYNONYM: RING3-LIKE PROTEIN;                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: BRD3, KIAA0043, RING3L;                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: ROSETTA-R3;                                
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PNIC28-BSA4                               
KEYWDS    BRD3, BROMODOMAIN CONTAINING PROTEIN 3, ORFX, RING3 LIKE              
KEYWDS   2 GENE, RING3L, STRUCTURAL GENOMICS, STRUCTURAL GENOMICS               
KEYWDS   3 CONSORTIUM, SGC                                                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.FILIPPAKOPOULOS,A.BULLOCK,C.COOPER,K.KEATES,G.BERRIDGE,             
AUTHOR   2 A.PIKE,G.BUNKOCZI,A.EDWARDS,C.ARROWSMITH,M.SUNDSTROM,F.VON           
AUTHOR   3 DELFT,S.KNAPP,STRUCTURAL GENOMICS CONSORTIUM (SGC)                   
REVDAT   1   12-DEC-06 2NXB    0                                                
JRNL        AUTH   P.FILIPPAKOPOULOS,A.BULLOCK,C.COOPER,K.KEATES,               
JRNL        AUTH 2 G.BERRIDGE,A.PIKE,G.BUNKOCZI,A.EDWARDS,                      
JRNL        AUTH 3 C.ARROWSMITH,M.SUNDSTROM,F.VON DELFT,S.KNAPP,                
JRNL        AUTH 4 STRUCTURAL GENOMICS CONSORTIUM (SGC)                         
JRNL        TITL   CRYSTAL STRUCTURE OF HUMAN BROMODOMAIN CONTAINING            
JRNL        TITL 2 PROTEIN 3 (BRD3)                                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.40 ANGSTROMS.                                          
DBREF  2NXB A   24   144  UNP    Q15059   BRD3_HUMAN      24    144             
DBREF  2NXB B   24   144  UNP    Q15059   BRD3_HUMAN      24    144             
SEQRES   1 A  123  SER MET PRO GLU VAL SER ASN PRO SER LYS PRO GLY ARG          
SEQRES   2 A  123  LYS THR ASN GLN LEU GLN TYR MET GLN ASN VAL VAL VAL          
SEQRES   3 A  123  LYS THR LEU TRP LYS HIS GLN PHE ALA TRP PRO PHE TYR          
SEQRES   4 A  123  GLN PRO VAL ASP ALA ILE LYS LEU ASN LEU PRO ASP TYR          
SEQRES   5 A  123  HIS LYS ILE ILE LYS ASN PRO MET ASP MET GLY THR ILE          
SEQRES   6 A  123  LYS LYS ARG LEU GLU ASN ASN TYR TYR TRP SER ALA SER          
SEQRES   7 A  123  GLU CYS MET GLN ASP PHE ASN THR MET PHE THR ASN CYS          
SEQRES   8 A  123  TYR ILE TYR ASN LYS PRO THR ASP ASP ILE VAL LEU MET          
SEQRES   9 A  123  ALA GLN ALA LEU GLU LYS ILE PHE LEU GLN LYS VAL ALA          
SEQRES  10 A  123  GLN MET PRO GLN GLU GLU                                      
SEQRES   1 B  123  SER MET PRO GLU VAL SER ASN PRO SER LYS PRO GLY ARG          
SEQRES   2 B  123  LYS THR ASN GLN LEU GLN TYR MET GLN ASN VAL VAL VAL          
SEQRES   3 B  123  LYS THR LEU TRP LYS HIS GLN PHE ALA TRP PRO PHE TYR          
SEQRES   4 B  123  GLN PRO VAL ASP ALA ILE LYS LEU ASN LEU PRO ASP TYR          
SEQRES   5 B  123  HIS LYS ILE ILE LYS ASN PRO MET ASP MET GLY THR ILE          
SEQRES   6 B  123  LYS LYS ARG LEU GLU ASN ASN TYR TYR TRP SER ALA SER          
SEQRES   7 B  123  GLU CYS MET GLN ASP PHE ASN THR MET PHE THR ASN CYS          
SEQRES   8 B  123  TYR ILE TYR ASN LYS PRO THR ASP ASP ILE VAL LEU MET          
SEQRES   9 B  123  ALA GLN ALA LEU GLU LYS ILE PHE LEU GLN LYS VAL ALA          
SEQRES  10 B  123  GLN MET PRO GLN GLU GLU                                      
HET     NA    301       1                                                       
HET    EDO    302       4                                                       
HET    EDO    303       4                                                       
HET    EDO    304       4                                                       
HET    EDO    305       4                                                       
HET    EDO    306       4                                                       
HET    EDO    307       4                                                       
HET    EDO    308       7                                                       
HETNAM      NA SODIUM ION                                                       
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   3   NA    NA 1+                                                        
FORMUL   4  EDO    7(C2 H6 O2)                                                  
FORMUL  11  HOH   *277(H2 O)                                                    
CRYST1   51.504   61.840   84.523  90.00  90.00  90.00 P 21 21 21    8          
ATOM      1  N   ARG A  34       3.563  49.011  -6.485  1.00 28.00           N  
ATOM      2  CA  ARG A  34       2.527  48.003  -6.860  1.00 27.88           C  
ATOM      3  C   ARG A  34       2.305  46.990  -5.732  1.00 27.40           C  
ATOM      4  O   ARG A  34       3.262  46.519  -5.108  1.00 28.58           O  
ATOM      5  CB  ARG A  34       2.945  47.278  -8.145  1.00 28.12           C  
ATOM      6  N   LYS A  35       1.043  46.663  -5.476  1.00 26.38           N  
ATOM      7  CA  LYS A  35       0.658  45.692  -4.440  1.00 24.94           C  
ATOM      8  C   LYS A  35       1.062  44.288  -4.856  1.00 23.20           C  
ATOM      9  O   LYS A  35       1.300  44.040  -6.033  1.00 22.10           O  
ATOM     10  CB  LYS A  35      -0.857  45.741  -4.217  1.00 25.48           C  
ATOM     11  CG  LYS A  35      -1.332  47.068  -3.672  1.00 27.21           C  
ATOM     12  CD  LYS A  35      -2.726  46.987  -3.079  1.00 28.54           C  
ATOM     13  CE  LYS A  35      -3.773  46.918  -4.150  1.00 29.50           C  
ATOM     14  NZ  LYS A  35      -3.892  48.213  -4.886  1.00 27.44           N  
ATOM     15  N   THR A  36       1.084  43.342  -3.913  1.00 21.48           N  
ATOM     16  CA  THR A  36       1.352  41.959  -4.281  1.00 20.39           C  
ATOM     17  C   THR A  36       0.287  41.463  -5.245  1.00 20.92           C  
ATOM     18  O   THR A  36      -0.829  42.006  -5.294  1.00 20.48           O  
ATOM     19  CB  THR A  36       1.402  41.000  -3.074  1.00 20.15           C  
ATOM     20  OG1 THR A  36       0.084  40.817  -2.522  1.00 20.20           O  
ATOM     21  CG2 THR A  36       2.354  41.508  -2.010  1.00 18.99           C  
ATOM     22  N   ASN A  37       0.612  40.421  -6.005  1.00 21.27           N  
ATOM     23  CA  ASN A  37      -0.389  39.852  -6.908  1.00 22.30           C  
ATOM     24  C   ASN A  37      -1.623  39.349  -6.154  1.00 21.80           C  
ATOM     25  O   ASN A  37      -2.761  39.481  -6.630  1.00 22.19           O  
ATOM     26  CB  ASN A  37       0.230  38.756  -7.771  1.00 23.34           C  
ATOM     27  CG  ASN A  37       1.214  39.311  -8.813  1.00 25.84           C  
ATOM     28  OD1 ASN A  37       1.153  40.487  -9.180  1.00 32.22           O  
ATOM     29  ND2 ASN A  37       2.113  38.461  -9.296  1.00 29.63           N  
ATOM     30  N   GLN A  38      -1.407  38.773  -4.973  1.00 21.15           N  
ATOM     31  CA  GLN A  38      -2.528  38.314  -4.157  1.00 20.45           C  
ATOM     32  C   GLN A  38      -3.397  39.463  -3.673  1.00 20.78           C  
ATOM     33  O   GLN A  38      -4.613  39.321  -3.620  1.00 21.75           O  
ATOM     34  CB  GLN A  38      -2.024  37.499  -2.970  1.00 20.48           C  
ATOM     35  CG  GLN A  38      -1.364  36.201  -3.368  1.00 20.24           C  
ATOM     36  CD  GLN A  38      -0.676  35.507  -2.229  1.00 20.21           C  
ATOM     37  OE1 GLN A  38      -0.388  36.111  -1.193  1.00 19.90           O  
ATOM     38  NE2 GLN A  38      -0.420  34.212  -2.398  1.00 19.82           N  
ATOM     39  N   LEU A  39      -2.789  40.582  -3.281  1.00 20.09           N  
ATOM     40  CA  LEU A  39      -3.594  41.745  -2.902  1.00 19.78           C  
ATOM     41  C   LEU A  39      -4.347  42.331  -4.106  1.00 20.30           C  
ATOM     42  O   LEU A  39      -5.477  42.768  -3.967  1.00 19.82           O  
ATOM     43  CB  LEU A  39      -2.726  42.799  -2.203  1.00 19.87           C  
ATOM     44  CG  LEU A  39      -2.425  42.450  -0.747  1.00 20.22           C  
ATOM     45  CD1 LEU A  39      -1.287  43.327  -0.255  1.00 21.63           C  
ATOM     46  CD2 LEU A  39      -3.666  42.640   0.097  1.00 19.84           C  
ATOM     47  N   GLN A  40      -3.736  42.314  -5.280  1.00 19.99           N  
ATOM     48  CA  GLN A  40      -4.448  42.719  -6.481  1.00 20.37           C  
ATOM     49  C   GLN A  40      -5.649  41.823  -6.715  1.00 20.31           C  
ATOM     50  O   GLN A  40      -6.695  42.309  -7.107  1.00 20.89           O  
ATOM     51  CB  GLN A  40      -3.518  42.705  -7.693  1.00 20.31           C  
ATOM     52  CG  GLN A  40      -2.459  43.786  -7.640  1.00 22.44           C  
ATOM     53  CD  GLN A  40      -1.463  43.686  -8.760  1.00 24.78           C  
ATOM     54  OE1 GLN A  40      -1.836  43.591  -9.929  1.00 26.72           O  
ATOM     55  NE2 GLN A  40      -0.174  43.737  -8.417  1.00 25.04           N  
ATOM     56  N   TYR A  41      -5.488  40.524  -6.503  1.00 20.15           N  
ATOM     57  CA  TYR A  41      -6.603  39.572  -6.584  1.00 20.84           C  
ATOM     58  C   TYR A  41      -7.696  39.888  -5.555  1.00 21.09           C  
ATOM     59  O   TYR A  41      -8.898  39.869  -5.847  1.00 21.98           O  
ATOM     60  CB  TYR A  41      -6.054  38.148  -6.410  1.00 21.28           C  
ATOM     61  CG  TYR A  41      -7.100  37.052  -6.480  1.00 20.43           C  
ATOM     62  CD1 TYR A  41      -7.474  36.502  -7.694  1.00 19.83           C  
ATOM     63  CD2 TYR A  41      -7.669  36.548  -5.319  1.00 21.45           C  
ATOM     64  CE1 TYR A  41      -8.405  35.498  -7.766  1.00 20.85           C  
ATOM     65  CE2 TYR A  41      -8.601  35.536  -5.371  1.00 20.27           C  
ATOM     66  CZ  TYR A  41      -8.971  35.013  -6.596  1.00 18.91           C  
ATOM     67  OH  TYR A  41      -9.897  33.997  -6.699  1.00 20.26           O  
ATOM     68  N   MET A  42      -7.296  40.197  -4.331  1.00 21.50           N  
ATOM     69  CA  MET A  42      -8.289  40.579  -3.328  1.00 20.99           C  
ATOM     70  C   MET A  42      -9.096  41.787  -3.767  1.00 20.98           C  
ATOM     71  O   MET A  42     -10.286  41.875  -3.505  1.00 21.13           O  
ATOM     72  CB  MET A  42      -7.640  40.902  -1.985  1.00 21.46           C  
ATOM     73  CG  MET A  42      -6.951  39.728  -1.304  1.00 21.42           C  
ATOM     74  SD  MET A  42      -8.004  38.293  -1.014  1.00 22.98           S  
ATOM     75  CE  MET A  42      -9.222  38.964   0.086  1.00 24.26           C  
ATOM     76  N   GLN A  43      -8.449  42.724  -4.443  1.00 20.21           N  
ATOM     77  CA  GLN A  43      -9.127  43.935  -4.888  1.00 20.43           C  
ATOM     78  C   GLN A  43      -9.972  43.707  -6.134  1.00 20.65           C  
ATOM     79  O   GLN A  43     -11.156  44.090  -6.174  1.00 20.63           O  
ATOM     80  CB  GLN A  43      -8.099  45.038  -5.173  1.00 20.38           C  
ATOM     81  CG  GLN A  43      -8.714  46.386  -5.525  1.00 21.14           C  
ATOM     82  CD  GLN A  43      -7.671  47.486  -5.670  1.00 21.17           C  
ATOM     83  OE1 GLN A  43      -6.475  47.230  -5.584  1.00 24.01           O  
ATOM     84  NE2 GLN A  43      -8.126  48.701  -5.891  1.00 22.27           N  
ATOM     85  N   ASN A  44      -9.376  43.090  -7.149  1.00 20.37           N  
ATOM     86  CA  ASN A  44      -9.972  43.043  -8.484  1.00 20.53           C  
ATOM     87  C   ASN A  44     -10.867  41.835  -8.698  1.00 20.83           C  
ATOM     88  O   ASN A  44     -11.641  41.801  -9.673  1.00 21.59           O  
ATOM     89  CB  ASN A  44      -8.877  43.070  -9.540  1.00 20.77           C  
ATOM     90  CG  ASN A  44      -8.057  44.338  -9.492  1.00 22.37           C  
ATOM     91  OD1 ASN A  44      -6.868  44.327  -9.822  1.00 29.57           O  
ATOM     92  ND2 ASN A  44      -8.675  45.435  -9.084  1.00 23.67           N  
ATOM     93  N   VAL A  45     -10.754  40.842  -7.811  1.00 21.16           N  
ATOM     94  CA  VAL A  45     -11.634  39.679  -7.876  1.00 21.61           C  
ATOM     95  C   VAL A  45     -12.535  39.561  -6.644  1.00 21.23           C  
ATOM     96  O   VAL A  45     -13.754  39.507  -6.760  1.00 21.34           O  
ATOM     97  CB  VAL A  45     -10.853  38.376  -8.100  1.00 21.36           C  
ATOM     98  CG1 VAL A  45     -11.810  37.169  -8.032  1.00 22.46           C  
ATOM     99  CG2 VAL A  45     -10.118  38.436  -9.460  1.00 21.68           C  
ATOM    100  N   VAL A  46     -11.956  39.524  -5.456  1.00 21.11           N  
ATOM    101  CA  VAL A  46     -12.735  39.237  -4.258  1.00 21.23           C  
ATOM    102  C   VAL A  46     -13.660  40.412  -3.931  1.00 20.13           C  
ATOM    103  O   VAL A  46     -14.890  40.271  -3.925  1.00 19.47           O  
ATOM    104  CB  VAL A  46     -11.833  38.836  -3.065  1.00 20.97           C  
ATOM    105  CG1 VAL A  46     -12.687  38.570  -1.831  1.00 21.63           C  
ATOM    106  CG2 VAL A  46     -10.952  37.620  -3.417  1.00 22.79           C  
ATOM    107  N   VAL A  47     -13.086  41.589  -3.698  1.00 18.76           N  
ATOM    108  CA  VAL A  47     -13.914  42.756  -3.405  1.00 19.01           C  
ATOM    109  C   VAL A  47     -14.834  43.083  -4.584  1.00 19.36           C  
ATOM    110  O   VAL A  47     -16.002  43.352  -4.383  1.00 20.17           O  
ATOM    111  CB  VAL A  47     -13.068  43.994  -3.044  1.00 19.15           C  
ATOM    112  CG1 VAL A  47     -13.954  45.246  -2.908  1.00 20.20           C  
ATOM    113  CG2 VAL A  47     -12.308  43.745  -1.757  1.00 19.75           C  
ATOM    114  N   LYS A  48     -14.288  43.086  -5.798  1.00 20.13           N  
ATOM    115  CA  LYS A  48     -15.094  43.437  -6.982  1.00 21.50           C  
ATOM    116  C   LYS A  48     -16.307  42.528  -7.129  1.00 21.60           C  
ATOM    117  O   LYS A  48     -17.398  43.006  -7.450  1.00 23.29           O  
ATOM    118  CB  LYS A  48     -14.238  43.393  -8.238  1.00 22.33           C  
ATOM    119  CG  LYS A  48     -14.889  43.921  -9.508  1.00 24.42           C  
ATOM    120  CD  LYS A  48     -13.880  43.927 -10.643  1.00 27.19           C  
ATOM    121  N   THR A  49     -16.137  41.227  -6.880  1.00 21.24           N  
ATOM    122  CA  THR A  49     -17.220  40.255  -7.013  1.00 22.05           C  
ATOM    123  C   THR A  49     -18.231  40.448  -5.900  1.00 21.49           C  
ATOM    124  O   THR A  49     -19.431  40.528  -6.134  1.00 22.94           O  
ATOM    125  CB  THR A  49     -16.712  38.804  -7.001  1.00 22.45           C  
ATOM    126  OG1 THR A  49     -15.856  38.588  -8.124  1.00 24.61           O  
ATOM    127  CG2 THR A  49     -17.902  37.818  -7.035  1.00 24.53           C  
ATOM    128  N   LEU A  50     -17.748  40.476  -4.662  1.00 20.99           N  
ATOM    129  CA  LEU A  50     -18.637  40.625  -3.526  1.00 21.14           C  
ATOM    130  C   LEU A  50     -19.430  41.914  -3.548  1.00 21.67           C  
ATOM    131  O   LEU A  50     -20.614  41.910  -3.213  1.00 22.88           O  
ATOM    132  CB  LEU A  50     -17.869  40.545  -2.206  1.00 21.20           C  
ATOM    133  CG  LEU A  50     -17.303  39.166  -1.860  0.50 21.12           C  
ATOM    135  CD1 LEU A  50     -16.341  39.251  -0.684  0.50 20.54           C  
ATOM    137  CD2 LEU A  50     -18.422  38.179  -1.563  0.50 20.26           C  
ATOM    139  N   TRP A  51     -18.778  43.012  -3.923  1.00 21.29           N  
ATOM    140  CA  TRP A  51     -19.425  44.323  -3.955  1.00 21.85           C  
ATOM    141  C   TRP A  51     -20.678  44.295  -4.830  1.00 21.80           C  
ATOM    142  O   TRP A  51     -21.681  44.964  -4.533  1.00 22.34           O  
ATOM    143  CB  TRP A  51     -18.466  45.405  -4.481  1.00 22.03           C  
ATOM    144  CG  TRP A  51     -18.880  46.773  -4.081  1.00 21.84           C  
ATOM    145  CD1 TRP A  51     -19.756  47.594  -4.730  1.00 23.02           C  
ATOM    146  CD2 TRP A  51     -18.424  47.491  -2.939  1.00 20.48           C  
ATOM    147  NE1 TRP A  51     -19.875  48.782  -4.051  1.00 22.43           N  
ATOM    148  CE2 TRP A  51     -19.057  48.751  -2.954  1.00 21.46           C  
ATOM    149  CE3 TRP A  51     -17.531  47.207  -1.916  1.00 22.12           C  
ATOM    150  CZ2 TRP A  51     -18.839  49.704  -1.953  1.00 21.53           C  
ATOM    151  CZ3 TRP A  51     -17.310  48.151  -0.938  1.00 22.43           C  
ATOM    152  CH2 TRP A  51     -17.959  49.380  -0.957  1.00 22.58           C  
ATOM    153  N   LYS A  52     -20.627  43.539  -5.922  1.00 21.85           N  
ATOM    154  CA  LYS A  52     -21.729  43.505  -6.878  1.00 22.27           C  
ATOM    155  C   LYS A  52     -22.883  42.601  -6.464  1.00 21.13           C  
ATOM    156  O   LYS A  52     -23.971  42.670  -7.033  1.00 22.22           O  
ATOM    157  CB  LYS A  52     -21.214  43.082  -8.253  1.00 23.21           C  
ATOM    158  CG  LYS A  52     -20.256  44.088  -8.880  1.00 26.55           C  
ATOM    159  CD  LYS A  52     -19.981  43.785 -10.347  1.00 30.87           C  
ATOM    160  CE  LYS A  52     -19.096  42.562 -10.521  1.00 32.26           C  
ATOM    161  NZ  LYS A  52     -18.575  42.435 -11.929  1.00 32.75           N  
ATOM    162  N   HIS A  53     -22.662  41.751  -5.472  1.00 21.20           N  
ATOM    163  CA  HIS A  53     -23.700  40.850  -4.983  1.00 20.49           C  
ATOM    164  C   HIS A  53     -24.844  41.688  -4.381  1.00 20.67           C  
ATOM    165  O   HIS A  53     -24.578  42.651  -3.670  1.00 21.12           O  
ATOM    166  CB  HIS A  53     -23.120  39.909  -3.926  1.00 21.06           C  
ATOM    167  CG  HIS A  53     -24.009  38.765  -3.570  1.00 20.57           C  
ATOM    168  ND1 HIS A  53     -25.196  38.917  -2.870  1.00 20.68           N  
ATOM    169  CD2 HIS A  53     -23.887  37.441  -3.817  1.00 20.99           C  
ATOM    170  CE1 HIS A  53     -25.769  37.734  -2.730  1.00 21.93           C  
ATOM    171  NE2 HIS A  53     -24.987  36.819  -3.284  1.00 22.17           N  
ATOM    172  N   GLN A  54     -26.094  41.327  -4.644  1.00 19.74           N  
ATOM    173  CA  GLN A  54     -27.238  42.106  -4.139  1.00 19.95           C  
ATOM    174  C   GLN A  54     -27.275  42.236  -2.626  1.00 20.18           C  
ATOM    175  O   GLN A  54     -27.961  43.124  -2.137  1.00 20.80           O  
ATOM    176  CB  GLN A  54     -28.571  41.547  -4.631  1.00 19.16           C  
ATOM    177  CG  GLN A  54     -28.915  40.168  -4.105  1.00 19.12           C  
ATOM    178  CD  GLN A  54     -30.377  39.858  -4.107  1.00 19.28           C  
ATOM    179  OE1 GLN A  54     -31.217  40.746  -4.144  1.00 20.48           O  
ATOM    180  NE2 GLN A  54     -30.706  38.562  -4.044  1.00 21.66           N  
ATOM    181  N   PHE A  55     -26.631  41.336  -1.896  1.00 20.41           N  
ATOM    182  CA  PHE A  55     -26.692  41.357  -0.423  1.00 20.40           C  
ATOM    183  C   PHE A  55     -25.497  42.064   0.221  1.00 20.89           C  
ATOM    184  O   PHE A  55     -25.379  42.080   1.442  1.00 21.18           O  
ATOM    185  CB  PHE A  55     -26.761  39.928   0.147  1.00 20.56           C  
ATOM    186  CG  PHE A  55     -28.047  39.183  -0.128  1.00 20.79           C  
ATOM    187  CD1 PHE A  55     -29.230  39.820  -0.442  1.00 21.65           C  
ATOM    188  CD2 PHE A  55     -28.064  37.786   0.026  1.00 22.28           C  
ATOM    189  CE1 PHE A  55     -30.396  39.067  -0.634  1.00 22.13           C  
ATOM    190  CE2 PHE A  55     -29.225  37.052  -0.178  1.00 23.52           C  
ATOM    191  CZ  PHE A  55     -30.361  37.678  -0.490  1.00 22.45           C  
ATOM    192  N   ALA A  56     -24.616  42.639  -0.582  1.00 20.71           N  
ATOM    193  CA  ALA A  56     -23.386  43.226  -0.064  1.00 20.72           C  
ATOM    194  C   ALA A  56     -23.583  44.594   0.592  1.00 21.11           C  
ATOM    195  O   ALA A  56     -22.772  44.986   1.431  1.00 21.49           O  
ATOM    196  CB  ALA A  56     -22.367  43.337  -1.174  1.00 22.50           C  
ATOM    197  N   TRP A  57     -24.640  45.312   0.246  1.00 20.65           N  
ATOM    198  CA  TRP A  57     -24.732  46.721   0.614  1.00 20.78           C  
ATOM    199  C   TRP A  57     -24.642  47.045   2.129  1.00 20.45           C  
ATOM    200  O   TRP A  57     -24.098  48.085   2.476  1.00 20.59           O  
ATOM    201  CB  TRP A  57     -25.937  47.384  -0.062  1.00 20.94           C  
ATOM    202  CG  TRP A  57     -27.247  46.849   0.389  1.00 20.04           C  
ATOM    203  CD1 TRP A  57     -27.975  45.839  -0.190  1.00 21.58           C  
ATOM    204  CD2 TRP A  57     -27.991  47.259   1.541  1.00 20.86           C  
ATOM    205  NE1 TRP A  57     -29.100  45.605   0.526  1.00 22.04           N  
ATOM    206  CE2 TRP A  57     -29.147  46.463   1.595  1.00 20.63           C  
ATOM    207  CE3 TRP A  57     -27.791  48.224   2.529  1.00 20.76           C  
ATOM    208  CZ2 TRP A  57     -30.088  46.593   2.601  1.00 21.17           C  
ATOM    209  CZ3 TRP A  57     -28.717  48.347   3.527  1.00 21.55           C  
ATOM    210  CH2 TRP A  57     -29.869  47.553   3.547  1.00 20.85           C  
ATOM    211  N   PRO A  58     -25.163  46.178   3.024  1.00 19.86           N  
ATOM    212  CA  PRO A  58     -24.987  46.537   4.448  1.00 20.04           C  
ATOM    213  C   PRO A  58     -23.526  46.548   4.892  1.00 20.64           C  
ATOM    214  O   PRO A  58     -23.229  47.081   5.950  1.00 21.64           O  
ATOM    215  CB  PRO A  58     -25.757  45.430   5.200  1.00 19.96           C  
ATOM    216  CG  PRO A  58     -26.736  44.901   4.172  1.00 20.24           C  
ATOM    217  CD  PRO A  58     -25.931  44.918   2.894  1.00 20.13           C  
ATOM    218  N   PHE A  59     -22.651  45.958   4.084  1.00 20.63           N  
ATOM    219  CA  PHE A  59     -21.232  45.867   4.402  1.00 20.60           C  
ATOM    220  C   PHE A  59     -20.394  46.937   3.701  1.00 20.64           C  
ATOM    221  O   PHE A  59     -19.176  46.933   3.844  1.00 21.14           O  
ATOM    222  CB  PHE A  59     -20.729  44.458   4.073  1.00 20.30           C  
ATOM    223  CG  PHE A  59     -21.526  43.382   4.772  1.00 21.43           C  
ATOM    224  CD1 PHE A  59     -21.270  43.060   6.094  1.00 22.05           C  
ATOM    225  CD2 PHE A  59     -22.583  42.752   4.129  1.00 23.10           C  
ATOM    226  CE1 PHE A  59     -22.045  42.104   6.750  1.00 22.76           C  
ATOM    227  CE2 PHE A  59     -23.334  41.783   4.786  1.00 23.95           C  
ATOM    228  CZ  PHE A  59     -23.061  41.476   6.080  1.00 23.08           C  
ATOM    229  N   TYR A  60     -21.023  47.884   3.007  1.00 20.69           N  
ATOM    230  CA  TYR A  60     -20.263  48.898   2.269  1.00 20.54           C  
ATOM    231  C   TYR A  60     -19.602  49.974   3.131  1.00 20.84           C  
ATOM    232  O   TYR A  60     -18.743  50.721   2.643  1.00 21.79           O  
ATOM    233  CB  TYR A  60     -21.172  49.625   1.275  1.00 20.46           C  
ATOM    234  CG  TYR A  60     -21.624  48.853   0.049  1.00 20.84           C  
ATOM    235  CD1 TYR A  60     -21.075  47.622  -0.303  1.00 21.35           C  
ATOM    236  CD2 TYR A  60     -22.616  49.373  -0.762  1.00 20.77           C  
ATOM    237  CE1 TYR A  60     -21.492  46.951  -1.445  1.00 22.10           C  
ATOM    238  CE2 TYR A  60     -23.038  48.708  -1.894  1.00 20.41           C  
ATOM    239  CZ  TYR A  60     -22.480  47.497  -2.229  1.00 21.91           C  
ATOM    240  OH  TYR A  60     -22.914  46.851  -3.364  1.00 23.69           O  
ATOM    241  N   GLN A  61     -20.037  50.103   4.375  1.00 20.78           N  
ATOM    242  CA  GLN A  61     -19.543  51.154   5.261  1.00 21.20           C  
ATOM    243  C   GLN A  61     -19.557  50.674   6.696  1.00 21.21           C  
ATOM    244  O   GLN A  61     -20.286  49.736   7.033  1.00 20.71           O  
ATOM    245  CB  GLN A  61     -20.395  52.417   5.148  1.00 22.47           C  
ATOM    246  CG  GLN A  61     -21.845  52.235   5.563  1.00 25.17           C  
ATOM    247  CD  GLN A  61     -22.643  51.436   4.558  1.00 29.92           C  
ATOM    248  OE1 GLN A  61     -22.726  51.815   3.388  1.00 33.96           O  
ATOM    249  NE2 GLN A  61     -23.226  50.315   5.001  1.00 32.42           N  
ATOM    250  N   PRO A  62     -18.760  51.309   7.557  1.00 20.66           N  
ATOM    251  CA  PRO A  62     -18.775  50.920   8.950  1.00 21.17           C  
ATOM    252  C   PRO A  62     -20.170  50.992   9.539  1.00 22.72           C  
ATOM    253  O   PRO A  62     -20.970  51.873   9.169  1.00 23.24           O  
ATOM    254  CB  PRO A  62     -17.843  51.931   9.630  1.00 20.86           C  
ATOM    255  CG  PRO A  62     -17.010  52.455   8.552  1.00 20.95           C  
ATOM    256  CD  PRO A  62     -17.787  52.385   7.291  1.00 20.97           C  
ATOM    257  N   VAL A  63     -20.505  49.988  10.347  0.50 23.26           N  
ATOM    259  CA  VAL A  63     -21.802  49.954  10.998  0.50 23.64           C  
ATOM    261  C   VAL A  63     -21.873  51.209  11.841  0.50 23.79           C  
ATOM    263  O   VAL A  63     -21.000  51.476  12.657  0.50 24.25           O  
ATOM    265  CB  VAL A  63     -21.983  48.707  11.888  0.50 23.35           C  
ATOM    267  CG1 VAL A  63     -23.313  48.768  12.618  0.50 23.13           C  
ATOM    269  CG2 VAL A  63     -21.890  47.432  11.059  0.50 23.77           C  
ATOM    271  N   ASP A  64     -22.903  52.007  11.608  0.50 24.45           N  
ATOM    273  CA  ASP A  64     -23.076  53.231  12.370  0.50 24.84           C  
ATOM    275  C   ASP A  64     -24.075  52.983  13.496  0.50 24.86           C  
ATOM    277  O   ASP A  64     -25.292  52.952  13.285  0.50 24.60           O  
ATOM    279  CB  ASP A  64     -23.498  54.404  11.470  0.50 25.14           C  
ATOM    281  CG  ASP A  64     -24.615  54.045  10.507  0.50 26.39           C  
ATOM    283  OD1 ASP A  64     -25.209  54.974   9.912  0.50 29.32           O  
ATOM    285  OD2 ASP A  64     -24.903  52.838  10.348  0.50 29.00           O  
ATOM    287  N   ALA A  65     -23.533  52.773  14.692  0.50 24.81           N  
ATOM    289  CA  ALA A  65     -24.334  52.450  15.865  0.50 24.86           C  
ATOM    291  C   ALA A  65     -25.315  53.573  16.165  0.50 24.78           C  
ATOM    293  O   ALA A  65     -26.406  53.328  16.675  0.50 24.78           O  
ATOM    295  CB  ALA A  65     -23.434  52.194  17.066  0.50 24.87           C  
ATOM    297  N   ILE A  66     -24.927  54.800  15.832  0.50 24.66           N  
ATOM    299  CA  ILE A  66     -25.760  55.971  16.113  0.50 24.55           C  
ATOM    301  C   ILE A  66     -26.929  56.046  15.135  0.50 24.62           C  
ATOM    303  O   ILE A  66     -28.089  56.099  15.543  0.50 24.65           O  
ATOM    305  CB  ILE A  66     -24.954  57.294  16.028  0.50 24.49           C  
ATOM    307  CG1 ILE A  66     -23.762  57.265  16.992  0.50 24.42           C  
ATOM    309  CG2 ILE A  66     -25.858  58.484  16.323  0.50 24.58           C  
ATOM    311  CD1 ILE A  66     -22.996  58.569  17.066  0.50 24.26           C  
ATOM    313  N   LYS A  67     -26.618  56.048  13.842  0.50 24.53           N  
ATOM    315  CA  LYS A  67     -27.647  56.172  12.814  0.50 24.55           C  
ATOM    317  C   LYS A  67     -28.652  55.032  12.918  0.50 24.55           C  
ATOM    319  O   LYS A  67     -29.820  55.193  12.576  0.50 24.67           O  
ATOM    321  CB  LYS A  67     -27.021  56.190  11.417  0.50 24.63           C  
ATOM    323  N   LEU A  68     -28.192  53.876  13.385  0.50 24.46           N  
ATOM    325  CA  LEU A  68     -29.071  52.730  13.566  0.50 24.42           C  
ATOM    327  C   LEU A  68     -29.417  52.553  15.042  0.50 24.33           C  
ATOM    329  O   LEU A  68     -30.015  51.557  15.437  0.50 24.85           O  
ATOM    331  CB  LEU A  68     -28.412  51.462  13.016  0.50 24.37           C  
ATOM    333  N   ASN A  69     -29.050  53.534  15.856  0.50 24.30           N  
ATOM    335  CA  ASN A  69     -29.241  53.426  17.294  0.50 24.08           C  
ATOM    337  C   ASN A  69     -29.050  51.979  17.752  0.50 23.93           C  
ATOM    339  O   ASN A  69     -30.009  51.285  18.096  0.50 23.97           O  
ATOM    341  CB  ASN A  69     -30.626  53.943  17.696  0.50 24.27           C  
ATOM    343  CG  ASN A  69     -29.324  55.374  21.148  0.50 27.35           C  
ATOM    344  OD1 ASN A  69     -30.181  54.871  20.420  0.50 28.19           O  
ATOM    345  ND2 ASN A  69     -29.489  55.512  22.461  0.50 27.07           N  
ATOM    346  N   LEU A  70     -27.799  51.525  17.720  0.50 23.45           N  
ATOM    348  CA  LEU A  70     -27.410  50.263  18.337  0.50 23.14           C  
ATOM    350  C   LEU A  70     -26.370  50.568  19.418  0.50 22.68           C  
ATOM    352  O   LEU A  70     -25.168  50.474  19.171  0.50 22.88           O  
ATOM    354  CB  LEU A  70     -26.836  49.306  17.288  0.50 23.18           C  
ATOM    356  CG  LEU A  70     -26.552  50.273  18.863  0.50 25.65           C  
ATOM    357  CD1 LEU A  70     -26.104  49.362  17.734  0.50 25.95           C  
ATOM    358  CD2 LEU A  70     -27.716  49.659  19.634  0.50 25.92           C  
ATOM    359  N   PRO A  71     -26.837  50.947  20.619  0.50 22.17           N  
ATOM    361  CA  PRO A  71     -25.996  51.442  21.718  0.50 21.79           C  
ATOM    363  C   PRO A  71     -24.946  50.455  22.236  0.50 21.40           C  
ATOM    365  O   PRO A  71     -23.893  50.873  22.710  0.50 21.34           O  
ATOM    367  CB  PRO A  71     -27.011  51.765  22.826  0.50 21.83           C  
ATOM    369  CG  PRO A  71     -28.328  51.871  22.140  0.50 21.96           C  
ATOM    371  CD  PRO A  71     -28.263  50.928  20.984  0.50 22.09           C  
ATOM    373  N   ASP A  72     -25.224  49.161  22.146  0.50 20.87           N  
ATOM    375  CA  ASP A  72     -24.308  48.154  22.681  0.50 20.52           C  
ATOM    377  C   ASP A  72     -23.344  47.591  21.628  0.50 19.79           C  
ATOM    379  O   ASP A  72     -22.472  46.787  21.954  0.50 19.45           O  
ATOM    381  CB  ASP A  72     -25.097  46.997  23.303  0.50 20.80           C  
ATOM    383  CG  ASP A  72     -25.904  46.221  22.276  0.50 21.53           C  
ATOM    385  OD1 ASP A  72     -26.160  46.771  21.182  0.50 22.68           O  
ATOM    387  OD2 ASP A  72     -26.281  45.064  22.555  0.50 22.97           O  
ATOM    389  N   TYR A  73     -23.494  48.010  20.375  0.50 19.05           N  
ATOM    391  CA  TYR A  73     -22.690  47.426  19.295  0.50 18.61           C  
ATOM    393  C   TYR A  73     -21.202  47.433  19.618  0.50 18.81           C  
ATOM    395  O   TYR A  73     -20.520  46.422  19.472  0.50 18.26           O  
ATOM    397  CB  TYR A  73     -22.906  48.143  17.962  0.50 18.39           C  
ATOM    399  CG  TYR A  73     -22.209  47.435  16.820  0.50 17.14           C  
ATOM    401  CD1 TYR A  73     -22.773  46.305  16.244  0.50 17.16           C  
ATOM    403  CD2 TYR A  73     -20.973  47.878  16.342  0.50 16.92           C  
ATOM    405  CE1 TYR A  73     -22.141  45.635  15.213  0.50 15.76           C  
ATOM    407  CE2 TYR A  73     -20.325  47.211  15.306  0.50 16.88           C  
ATOM    409  CZ  TYR A  73     -20.918  46.094  14.745  0.50 17.15           C  
ATOM    411  OH  TYR A  73     -20.298  45.418  13.722  0.50 17.54           O  
ATOM    413  N   HIS A  74     -20.699  48.581  20.045  0.50 19.25           N  
ATOM    415  CA  HIS A  74     -19.272  48.735  20.260  0.50 19.77           C  
ATOM    417  C   HIS A  74     -18.847  48.233  21.638  0.50 20.21           C  
ATOM    419  O   HIS A  74     -17.664  48.215  21.971  0.50 20.23           O  
ATOM    421  CB  HIS A  74     -18.868  50.186  20.007  0.50 20.20           C  
ATOM    423  CG  HIS A  74     -19.021  50.595  18.573  0.50 20.64           C  
ATOM    425  ND1 HIS A  74     -18.237  50.077  17.568  0.50 22.74           N  
ATOM    427  CD2 HIS A  74     -19.878  51.458  17.975  0.50 20.68           C  
ATOM    429  CE1 HIS A  74     -18.595  50.607  16.412  0.50 21.69           C  
ATOM    431  NE2 HIS A  74     -19.588  51.450  16.630  0.50 21.47           N  
ATOM    433  N   LYS A  75     -19.830  47.783  22.413  0.50 20.68           N  
ATOM    435  CA  LYS A  75     -19.579  47.134  23.701  0.50 21.01           C  
ATOM    437  C   LYS A  75     -19.301  45.635  23.508  0.50 21.35           C  
ATOM    439  O   LYS A  75     -18.676  44.999  24.350  0.50 21.93           O  
ATOM    441  CB  LYS A  75     -20.777  47.325  24.631  0.50 21.34           C  
ATOM    443  N   ILE A  76     -19.775  45.077  22.399  0.50 21.72           N  
ATOM    445  CA  ILE A  76     -19.545  43.653  22.093  0.50 21.79           C  
ATOM    447  C   ILE A  76     -18.549  43.457  20.944  0.50 21.91           C  
ATOM    449  O   ILE A  76     -17.656  42.607  21.032  0.50 22.60           O  
ATOM    451  CB  ILE A  76     -20.889  42.909  21.826  0.50 21.54           C  
ATOM    453  CG1 ILE A  76     -20.669  41.508  21.225  0.50 21.70           C  
ATOM    455  CG2 ILE A  76     -21.787  43.723  20.922  0.50 21.75           C  
ATOM    457  CD1 ILE A  76     -19.864  40.569  22.112  0.50 21.87           C  
ATOM    459  N   ILE A  77     -18.694  44.265  19.886  1.00 21.56           N  
ATOM    460  CA  ILE A  77     -17.853  44.232  18.689  1.00 21.67           C  
ATOM    461  C   ILE A  77     -16.588  45.032  18.957  1.00 21.87           C  
ATOM    462  O   ILE A  77     -16.595  46.267  18.896  1.00 22.78           O  
ATOM    463  CB  ILE A  77     -18.601  44.760  17.459  1.00 21.21           C  
ATOM    464  CG1 ILE A  77     -19.816  43.873  17.200  1.00 21.34           C  
ATOM    465  CG2 ILE A  77     -17.650  44.779  16.232  1.00 22.37           C  
ATOM    466  CD1 ILE A  77     -19.480  42.361  17.117  1.00 23.60           C  
ATOM    467  N   LYS A  78     -15.504  44.322  19.258  1.00 22.43           N  
ATOM    468  CA  LYS A  78     -14.265  44.955  19.692  1.00 22.92           C  
ATOM    469  C   LYS A  78     -13.448  45.476  18.522  1.00 22.65           C  
ATOM    470  O   LYS A  78     -12.730  46.452  18.669  1.00 22.81           O  
ATOM    471  CB  LYS A  78     -13.390  43.983  20.499  1.00 23.59           C  
ATOM    472  CG  LYS A  78     -14.094  43.273  21.625  1.00 25.58           C  
ATOM    473  CD  LYS A  78     -14.517  44.240  22.686  1.00 26.29           C  
ATOM    474  CE  LYS A  78     -15.017  43.512  23.918  1.00 28.01           C  
ATOM    475  NZ  LYS A  78     -15.452  44.475  24.977  1.00 29.50           N  
ATOM    476  N   ASN A  79     -13.530  44.809  17.377  1.00 22.36           N  
ATOM    477  CA  ASN A  79     -12.746  45.182  16.200  1.00 22.43           C  
ATOM    478  C   ASN A  79     -13.668  45.317  14.978  1.00 21.24           C  
ATOM    479  O   ASN A  79     -13.762  44.394  14.175  1.00 20.76           O  
ATOM    480  CB  ASN A  79     -11.652  44.128  15.938  1.00 23.36           C  
ATOM    481  CG  ASN A  79     -10.659  44.015  17.084  1.00 26.67           C  
ATOM    482  OD1 ASN A  79      -9.870  44.923  17.325  1.00 32.04           O  
ATOM    483  ND2 ASN A  79     -10.700  42.899  17.792  1.00 30.46           N  
ATOM    484  N   PRO A  80     -14.366  46.457  14.853  1.00 20.83           N  
ATOM    485  CA  PRO A  80     -15.269  46.633  13.710  1.00 20.52           C  
ATOM    486  C   PRO A  80     -14.559  46.534  12.361  1.00 21.16           C  
ATOM    487  O   PRO A  80     -13.417  46.977  12.238  1.00 20.96           O  
ATOM    488  CB  PRO A  80     -15.847  48.041  13.914  1.00 20.77           C  
ATOM    489  CG  PRO A  80     -15.607  48.364  15.326  1.00 22.31           C  
ATOM    490  CD  PRO A  80     -14.376  47.634  15.734  1.00 20.81           C  
ATOM    491  N   MET A  81     -15.227  45.982  11.356  1.00 21.07           N  
ATOM    492  CA  MET A  81     -14.682  45.956  10.013  1.00 21.16           C  
ATOM    493  C   MET A  81     -15.823  45.917   8.998  1.00 21.42           C  
ATOM    494  O   MET A  81     -16.915  45.437   9.291  1.00 21.70           O  
ATOM    495  CB  MET A  81     -13.760  44.759   9.836  1.00 21.81           C  
ATOM    496  CG  MET A  81     -12.954  44.737   8.559  1.00 22.13           C  
ATOM    497  SD  MET A  81     -12.104  46.273   8.090  1.00 21.77           S  
ATOM    498  CE  MET A  81     -11.143  46.574   9.580  1.00 21.26           C  
ATOM    499  N   ASP A  82     -15.563  46.450   7.813  1.00 20.48           N  
ATOM    500  CA  ASP A  82     -16.555  46.476   6.736  1.00 20.15           C  
ATOM    501  C   ASP A  82     -15.814  46.456   5.406  1.00 20.76           C  
ATOM    502  O   ASP A  82     -14.604  46.685   5.356  1.00 19.99           O  
ATOM    503  CB  ASP A  82     -17.432  47.718   6.826  1.00 20.31           C  
ATOM    504  CG  ASP A  82     -16.646  48.961   6.558  1.00 20.26           C  
ATOM    505  OD1 ASP A  82     -15.948  49.401   7.493  1.00 20.62           O  
ATOM    506  OD2 ASP A  82     -16.708  49.469   5.425  1.00 19.96           O  
ATOM    507  N   MET A  83     -16.536  46.174   4.332  1.00 20.22           N  
ATOM    508  CA  MET A  83     -15.934  45.986   3.021  1.00 20.72           C  
ATOM    509  C   MET A  83     -15.547  47.309   2.386  1.00 20.24           C  
ATOM    510  O   MET A  83     -14.649  47.354   1.567  1.00 21.11           O  
ATOM    511  CB  MET A  83     -16.867  45.178   2.099  1.00 21.38           C  
ATOM    512  CG  MET A  83     -16.155  44.698   0.821  1.00 22.19           C  
ATOM    513  SD  MET A  83     -16.993  43.333  -0.006  1.00 23.48           S  
ATOM    514  CE  MET A  83     -18.606  44.090  -0.157  1.00 20.65           C  
ATOM    515  N   GLY A  84     -16.220  48.393   2.756  1.00 19.91           N  
ATOM    516  CA  GLY A  84     -15.788  49.716   2.333  1.00 19.98           C  
ATOM    517  C   GLY A  84     -14.397  50.035   2.840  1.00 19.57           C  
ATOM    518  O   GLY A  84     -13.555  50.530   2.089  1.00 20.20           O  
ATOM    519  N   THR A  85     -14.164  49.759   4.112  1.00 19.57           N  
ATOM    520  CA  THR A  85     -12.848  49.955   4.714  1.00 19.72           C  
ATOM    521  C   THR A  85     -11.825  49.049   4.040  1.00 20.01           C  
ATOM    522  O   THR A  85     -10.721  49.477   3.713  1.00 20.33           O  
ATOM    523  CB  THR A  85     -12.886  49.717   6.215  1.00 19.48           C  
ATOM    524  OG1 THR A  85     -13.771  50.663   6.827  1.00 20.23           O  
ATOM    525  CG2 THR A  85     -11.496  49.823   6.838  1.00 21.17           C  
ATOM    526  N   ILE A  86     -12.169  47.789   3.819  1.00 20.28           N  
ATOM    527  CA  ILE A  86     -11.260  46.877   3.142  1.00 19.82           C  
ATOM    528  C   ILE A  86     -10.900  47.432   1.724  1.00 20.24           C  
ATOM    529  O   ILE A  86      -9.745  47.434   1.341  1.00 20.49           O  
ATOM    530  CB  ILE A  86     -11.839  45.459   3.053  1.00 20.15           C  
ATOM    531  CG1 ILE A  86     -11.888  44.855   4.452  1.00 20.46           C  
ATOM    532  CG2 ILE A  86     -10.967  44.596   2.131  1.00 21.48           C  
ATOM    533  CD1 ILE A  86     -12.713  43.602   4.559  1.00 21.41           C  
ATOM    534  N   LYS A  87     -11.903  47.825   0.964  1.00 20.70           N  
ATOM    535  CA  LYS A  87     -11.678  48.352  -0.369  1.00 20.61           C  
ATOM    536  C   LYS A  87     -10.762  49.581  -0.355  1.00 20.84           C  
ATOM    537  O   LYS A  87      -9.857  49.710  -1.175  1.00 20.91           O  
ATOM    538  CB  LYS A  87     -13.027  48.706  -1.006  1.00 21.24           C  
ATOM    539  CG  LYS A  87     -12.976  49.265  -2.426  1.00 23.55           C  
ATOM    540  CD  LYS A  87     -14.406  49.423  -2.969  1.00 26.80           C  
ATOM    541  CE  LYS A  87     -14.485  50.117  -4.308  1.00 30.65           C  
ATOM    542  NZ  LYS A  87     -15.903  50.198  -4.751  1.00 33.52           N  
ATOM    543  N   LYS A  88     -11.004  50.490   0.578  1.00 21.39           N  
ATOM    544  CA  LYS A  88     -10.153  51.675   0.724  1.00 21.31           C  
ATOM    545  C   LYS A  88      -8.703  51.300   1.057  1.00 20.81           C  
ATOM    546  O   LYS A  88      -7.753  51.873   0.505  1.00 21.38           O  
ATOM    547  CB  LYS A  88     -10.716  52.571   1.829  1.00 22.22           C  
ATOM    548  CG  LYS A  88      -9.896  53.793   2.099  1.00 25.63           C  
ATOM    549  N   ARG A  89      -8.536  50.335   1.956  1.00 19.76           N  
ATOM    550  CA  ARG A  89      -7.212  49.845   2.339  1.00 20.33           C  
ATOM    551  C   ARG A  89      -6.486  49.272   1.130  1.00 20.32           C  
ATOM    552  O   ARG A  89      -5.280  49.492   0.963  1.00 21.58           O  
ATOM    553  CB  ARG A  89      -7.326  48.813   3.468  1.00 20.63           C  
ATOM    554  CG  ARG A  89      -7.637  49.459   4.832  1.00 19.70           C  
ATOM    555  CD  ARG A  89      -7.838  48.422   5.918  1.00 21.00           C  
ATOM    556  NE  ARG A  89      -8.064  49.090   7.197  1.00 21.44           N  
ATOM    557  CZ  ARG A  89      -8.030  48.506   8.384  1.00 21.67           C  
ATOM    558  NH1 ARG A  89      -7.855  47.196   8.483  1.00 23.49           N  
ATOM    559  NH2 ARG A  89      -8.201  49.249   9.482  1.00 23.27           N  
ATOM    560  N   LEU A  90      -7.193  48.550   0.276  1.00 20.53           N  
ATOM    561  CA  LEU A  90      -6.583  48.053  -0.959  1.00 20.23           C  
ATOM    562  C   LEU A  90      -6.181  49.216  -1.880  1.00 20.94           C  
ATOM    563  O   LEU A  90      -5.061  49.257  -2.384  1.00 20.90           O  
ATOM    564  CB  LEU A  90      -7.532  47.063  -1.646  1.00 20.58           C  
ATOM    565  CG  LEU A  90      -7.641  45.734  -0.899  1.00 19.87           C  
ATOM    566  CD1 LEU A  90      -8.911  45.003  -1.231  1.00 21.18           C  
ATOM    567  CD2 LEU A  90      -6.428  44.848  -1.196  1.00 20.50           C  
ATOM    568  N   GLU A  91      -7.084  50.166  -2.062  1.00 20.93           N  
ATOM    569  CA  GLU A  91      -6.833  51.315  -2.934  1.00 21.61           C  
ATOM    570  C   GLU A  91      -5.688  52.206  -2.408  1.00 22.12           C  
ATOM    571  O   GLU A  91      -4.905  52.746  -3.200  1.00 23.27           O  
ATOM    572  CB  GLU A  91      -8.126  52.125  -3.127  1.00 21.93           C  
ATOM    573  CG  GLU A  91      -9.178  51.375  -3.947  1.00 23.66           C  
ATOM    574  CD  GLU A  91     -10.578  51.976  -3.864  1.00 27.73           C  
ATOM    575  OE1 GLU A  91     -10.789  52.942  -3.092  1.00 30.03           O  
ATOM    576  OE2 GLU A  91     -11.476  51.452  -4.563  1.00 27.36           O  
ATOM    577  N   ASN A  92      -5.579  52.303  -1.085  1.00 21.74           N  
ATOM    578  CA  ASN A  92      -4.639  53.200  -0.396  1.00 21.83           C  
ATOM    579  C   ASN A  92      -3.302  52.461  -0.063  1.00 21.66           C  
ATOM    580  O   ASN A  92      -2.417  53.016   0.575  1.00 21.85           O  
ATOM    581  CB  ASN A  92      -5.268  53.791   0.901  0.50 22.28           C  
ATOM    583  CG  ASN A  92      -6.174  55.035   0.657  0.50 21.56           C  
ATOM    585  OD1 ASN A  92      -5.970  55.804  -0.284  0.50 21.64           O  
ATOM    587  ND2 ASN A  92      -7.146  55.247   1.550  0.50 21.60           N  
ATOM    589  N   ASN A  93      -3.140  51.226  -0.533  1.00 21.89           N  
ATOM    590  CA  ASN A  93      -1.892  50.497  -0.349  1.00 21.70           C  
ATOM    591  C   ASN A  93      -1.555  50.177   1.106  1.00 20.97           C  
ATOM    592  O   ASN A  93      -0.394  50.072   1.475  1.00 20.34           O  
ATOM    593  CB  ASN A  93      -0.748  51.308  -0.953  1.00 22.64           C  
ATOM    594  CG  ASN A  93       0.192  50.473  -1.719  1.00 24.51           C  
ATOM    595  OD1 ASN A  93       0.299  49.267  -1.503  1.00 27.19           O  
ATOM    596  ND2 ASN A  93       0.917  51.109  -2.637  1.00 27.25           N  
ATOM    597  N   TYR A  94      -2.579  49.956   1.917  1.00 19.71           N  
ATOM    598  CA  TYR A  94      -2.409  49.765   3.358  1.00 19.72           C  
ATOM    599  C   TYR A  94      -1.783  48.414   3.722  1.00 19.30           C  
ATOM    600  O   TYR A  94      -1.007  48.328   4.669  1.00 17.96           O  
ATOM    601  CB  TYR A  94      -3.796  49.885   4.007  1.00 20.74           C  
ATOM    602  CG  TYR A  94      -3.975  49.531   5.471  1.00 20.64           C  
ATOM    603  CD1 TYR A  94      -3.985  50.505   6.462  1.00 24.36           C  
ATOM    604  CD2 TYR A  94      -4.198  48.216   5.852  1.00 22.72           C  
ATOM    605  CE1 TYR A  94      -4.217  50.172   7.804  1.00 24.87           C  
ATOM    606  CE2 TYR A  94      -4.419  47.878   7.203  1.00 24.91           C  
ATOM    607  CZ  TYR A  94      -4.429  48.864   8.151  1.00 25.64           C  
ATOM    608  OH  TYR A  94      -4.651  48.574   9.491  1.00 29.04           O  
ATOM    609  N   TYR A  95      -2.171  47.360   3.002  1.00 19.65           N  
ATOM    610  CA  TYR A  95      -1.788  46.011   3.405  1.00 19.71           C  
ATOM    611  C   TYR A  95      -0.385  45.632   2.982  1.00 19.60           C  
ATOM    612  O   TYR A  95       0.029  45.908   1.866  1.00 20.45           O  
ATOM    613  CB  TYR A  95      -2.742  44.989   2.811  1.00 19.77           C  
ATOM    614  CG  TYR A  95      -4.170  45.070   3.308  1.00 19.62           C  
ATOM    615  CD1 TYR A  95      -4.499  44.753   4.629  1.00 21.00           C  
ATOM    616  CD2 TYR A  95      -5.199  45.405   2.448  1.00 19.58           C  
ATOM    617  CE1 TYR A  95      -5.813  44.802   5.070  1.00 20.13           C  
ATOM    618  CE2 TYR A  95      -6.514  45.429   2.889  1.00 19.29           C  
ATOM    619  CZ  TYR A  95      -6.807  45.128   4.200  1.00 20.56           C  
ATOM    620  OH  TYR A  95      -8.124  45.137   4.632  1.00 21.68           O  
ATOM    621  N   TRP A  96       0.327  44.976   3.879  1.00 19.10           N  
ATOM    622  CA  TRP A  96       1.652  44.458   3.599  1.00 18.14           C  
ATOM    623  C   TRP A  96       1.564  43.101   2.880  1.00 18.23           C  
ATOM    624  O   TRP A  96       2.397  42.800   2.021  1.00 18.53           O  
ATOM    625  CB  TRP A  96       2.418  44.373   4.912  1.00 18.01           C  
ATOM    626  CG  TRP A  96       3.832  43.897   4.815  1.00 17.14           C  
ATOM    627  CD1 TRP A  96       4.937  44.617   4.442  1.00 17.30           C  
ATOM    628  CD2 TRP A  96       4.322  42.595   5.171  1.00 17.61           C  
ATOM    629  NE1 TRP A  96       6.071  43.836   4.515  1.00 16.91           N  
ATOM    630  CE2 TRP A  96       5.715  42.595   4.971  1.00 16.54           C  
ATOM    631  CE3 TRP A  96       3.715  41.431   5.641  1.00 17.55           C  
ATOM    632  CZ2 TRP A  96       6.506  41.462   5.222  1.00 17.08           C  
ATOM    633  CZ3 TRP A  96       4.494  40.326   5.878  1.00 18.41           C  
ATOM    634  CH2 TRP A  96       5.866  40.343   5.662  1.00 18.17           C  
ATOM    635  N   SER A  97       0.561  42.296   3.232  1.00 18.83           N  
ATOM    636  CA  SER A  97       0.352  40.966   2.633  1.00 19.46           C  
ATOM    637  C   SER A  97      -1.128  40.634   2.586  1.00 18.80           C  
ATOM    638  O   SER A  97      -1.925  41.207   3.321  1.00 19.20           O  
ATOM    639  CB  SER A  97       1.058  39.845   3.427  1.00 20.29           C  
ATOM    640  OG  SER A  97       0.655  40.008   4.762  0.50 23.11           O  
ATOM    642  N   ALA A  98      -1.509  39.695   1.735  1.00 18.33           N  
ATOM    643  CA  ALA A  98      -2.918  39.358   1.550  1.00 18.60           C  
ATOM    644  C   ALA A  98      -3.546  38.733   2.787  1.00 18.90           C  
ATOM    645  O   ALA A  98      -4.759  38.833   2.969  1.00 19.50           O  
ATOM    646  CB  ALA A  98      -3.102  38.425   0.347  1.00 18.73           C  
ATOM    647  N   SER A  99      -2.759  38.089   3.647  1.00 18.91           N  
ATOM    648  CA  SER A  99      -3.311  37.465   4.859  1.00 19.67           C  
ATOM    649  C   SER A  99      -4.014  38.496   5.741  1.00 19.39           C  
ATOM    650  O   SER A  99      -5.020  38.210   6.376  1.00 20.08           O  
ATOM    651  CB  SER A  99      -2.168  36.771   5.656  1.00 19.43           C  
ATOM    652  OG  SER A  99      -1.900  35.534   5.019  0.50 18.27           O  
ATOM    654  N   GLU A 100      -3.495  39.716   5.764  1.00 19.32           N  
ATOM    655  CA  GLU A 100      -4.073  40.762   6.602  1.00 20.37           C  
ATOM    656  C   GLU A 100      -5.455  41.151   6.064  1.00 20.18           C  
ATOM    657  O   GLU A 100      -6.414  41.400   6.798  1.00 21.45           O  
ATOM    658  CB  GLU A 100      -3.159  41.987   6.612  1.00 20.95           C  
ATOM    659  CG  GLU A 100      -1.710  41.769   7.098  1.00 22.53           C  
ATOM    660  CD  GLU A 100      -0.721  42.883   6.734  1.00 22.59           C  
ATOM    661  OE1 GLU A 100      -0.977  43.637   5.812  1.00 26.04           O  
ATOM    662  OE2 GLU A 100       0.306  42.996   7.420  1.00 29.70           O  
ATOM    663  N   CYS A 101      -5.569  41.214   4.743  1.00 19.89           N  
ATOM    664  CA  CYS A 101      -6.842  41.518   4.117  1.00 19.91           C  
ATOM    665  C   CYS A 101      -7.848  40.401   4.361  1.00 20.44           C  
ATOM    666  O   CYS A 101      -9.007  40.652   4.693  1.00 21.04           O  
ATOM    667  CB  CYS A 101      -6.603  41.781   2.628  1.00 19.62           C  
ATOM    668  SG  CYS A 101      -8.075  42.131   1.674  1.00 21.31           S  
ATOM    669  N   MET A 102      -7.408  39.160   4.191  1.00 20.08           N  
ATOM    670  CA  MET A 102      -8.272  38.030   4.505  1.00 20.40           C  
ATOM    671  C   MET A 102      -8.758  38.074   5.952  1.00 20.89           C  
ATOM    672  O   MET A 102      -9.939  37.808   6.210  1.00 21.06           O  
ATOM    673  CB  MET A 102      -7.565  36.710   4.182  1.00 21.25           C  
ATOM    674  CG  MET A 102      -7.399  36.533   2.665  1.00 23.21           C  
ATOM    675  SD  MET A 102      -6.793  34.940   2.148  1.00 31.03           S  
ATOM    676  CE  MET A 102      -5.289  34.999   2.998  1.00 27.65           C  
ATOM    677  N   GLN A 103      -7.868  38.408   6.888  1.00 20.77           N  
ATOM    678  CA  GLN A 103      -8.259  38.547   8.296  1.00 21.39           C  
ATOM    679  C   GLN A 103      -9.334  39.606   8.473  1.00 20.92           C  
ATOM    680  O   GLN A 103     -10.284  39.402   9.220  1.00 21.30           O  
ATOM    681  CB  GLN A 103      -7.070  38.894   9.170  1.00 21.80           C  
ATOM    682  CG  GLN A 103      -7.393  39.041  10.667  1.00 25.53           C  
ATOM    683  N   ASP A 104      -9.212  40.722   7.767  1.00 20.39           N  
ATOM    684  CA  ASP A 104     -10.246  41.731   7.854  1.00 20.94           C  
ATOM    685  C   ASP A 104     -11.593  41.209   7.346  1.00 20.97           C  
ATOM    686  O   ASP A 104     -12.631  41.494   7.942  1.00 21.14           O  
ATOM    687  CB  ASP A 104      -9.844  43.007   7.107  1.00 20.84           C  
ATOM    688  CG  ASP A 104      -8.850  43.853   7.855  1.00 22.23           C  
ATOM    689  OD1 ASP A 104      -8.629  43.708   9.081  1.00 22.87           O  
ATOM    690  OD2 ASP A 104      -8.280  44.723   7.168  1.00 22.82           O  
ATOM    691  N   PHE A 105     -11.611  40.453   6.258  1.00 20.95           N  
ATOM    692  CA  PHE A 105     -12.882  39.846   5.835  1.00 20.59           C  
ATOM    693  C   PHE A 105     -13.430  38.891   6.889  1.00 20.43           C  
ATOM    694  O   PHE A 105     -14.621  38.908   7.181  1.00 20.53           O  
ATOM    695  CB  PHE A 105     -12.714  39.088   4.522  1.00 20.19           C  
ATOM    696  CG  PHE A 105     -12.958  39.933   3.289  1.00 19.13           C  
ATOM    697  CD1 PHE A 105     -14.247  40.289   2.969  1.00 19.52           C  
ATOM    698  CD2 PHE A 105     -11.924  40.362   2.476  1.00 20.49           C  
ATOM    699  CE1 PHE A 105     -14.512  41.039   1.831  1.00 21.52           C  
ATOM    700  CE2 PHE A 105     -12.190  41.112   1.325  1.00 20.36           C  
ATOM    701  CZ  PHE A 105     -13.486  41.453   1.043  1.00 21.16           C  
ATOM    702  N   ASN A 106     -12.574  38.064   7.464  1.00 20.36           N  
ATOM    703  CA  ASN A 106     -13.029  37.124   8.489  1.00 20.73           C  
ATOM    704  C   ASN A 106     -13.635  37.880   9.674  1.00 20.80           C  
ATOM    705  O   ASN A 106     -14.653  37.472  10.237  1.00 21.76           O  
ATOM    706  CB  ASN A 106     -11.854  36.229   8.955  1.00 20.16           C  
ATOM    707  CG  ASN A 106     -11.424  35.177   7.907  1.00 24.37           C  
ATOM    708  OD1 ASN A 106     -12.190  34.785   7.024  1.00 25.90           O  
ATOM    709  ND2 ASN A 106     -10.194  34.685   8.052  1.00 28.10           N  
ATOM    710  N   THR A 107     -12.991  38.968  10.074  1.00 21.01           N  
ATOM    711  CA  THR A 107     -13.490  39.815  11.163  1.00 20.70           C  
ATOM    712  C   THR A 107     -14.861  40.398  10.814  1.00 20.98           C  
ATOM    713  O   THR A 107     -15.791  40.387  11.633  1.00 21.92           O  
ATOM    714  CB  THR A 107     -12.486  40.928  11.452  1.00 21.05           C  
ATOM    715  OG1 THR A 107     -11.287  40.332  11.956  1.00 22.69           O  
ATOM    716  CG2 THR A 107     -13.032  41.936  12.463  1.00 20.80           C  
ATOM    717  N   MET A 108     -15.017  40.883   9.591  1.00 21.15           N  
ATOM    718  CA  MET A 108     -16.282  41.451   9.149  1.00 20.72           C  
ATOM    719  C   MET A 108     -17.409  40.425   9.276  1.00 20.46           C  
ATOM    720  O   MET A 108     -18.477  40.725   9.812  1.00 21.24           O  
ATOM    721  CB  MET A 108     -16.141  41.924   7.694  1.00 21.29           C  
ATOM    722  CG  MET A 108     -17.398  42.571   7.134  1.00 21.19           C  
ATOM    723  SD  MET A 108     -17.281  42.963   5.393  1.00 21.13           S  
ATOM    724  CE  MET A 108     -17.678  41.374   4.702  1.00 21.79           C  
ATOM    725  N   PHE A 109     -17.193  39.235   8.739  1.00 20.71           N  
ATOM    726  CA  PHE A 109     -18.227  38.222   8.788  1.00 20.67           C  
ATOM    727  C   PHE A 109     -18.504  37.765  10.216  1.00 20.81           C  
ATOM    728  O   PHE A 109     -19.657  37.714  10.644  1.00 21.25           O  
ATOM    729  CB  PHE A 109     -17.828  37.025   7.934  1.00 20.52           C  
ATOM    730  CG  PHE A 109     -17.813  37.316   6.446  1.00 21.13           C  
ATOM    731  CD1 PHE A 109     -18.939  37.840   5.819  1.00 20.81           C  
ATOM    732  CD2 PHE A 109     -16.694  37.033   5.673  1.00 20.90           C  
ATOM    733  CE1 PHE A 109     -18.930  38.093   4.459  1.00 21.45           C  
ATOM    734  CE2 PHE A 109     -16.679  37.310   4.308  1.00 20.50           C  
ATOM    735  CZ  PHE A 109     -17.809  37.818   3.710  1.00 20.84           C  
ATOM    736  N   THR A 110     -17.450  37.452  10.949  1.00 20.86           N  
ATOM    737  CA  THR A 110     -17.629  36.953  12.308  1.00 20.97           C  
ATOM    738  C   THR A 110     -18.346  37.961  13.184  1.00 21.38           C  
ATOM    739  O   THR A 110     -19.219  37.574  13.965  1.00 21.16           O  
ATOM    740  CB  THR A 110     -16.318  36.511  12.898  1.00 21.55           C  
ATOM    741  OG1 THR A 110     -15.758  35.514  12.034  1.00 22.28           O  
ATOM    742  CG2 THR A 110     -16.523  35.890  14.282  1.00 21.94           C  
ATOM    743  N   ASN A 111     -18.007  39.243  13.062  1.00 20.37           N  
ATOM    744  CA  ASN A 111     -18.679  40.288  13.831  1.00 20.56           C  
ATOM    745  C   ASN A 111     -20.184  40.270  13.574  1.00 20.23           C  
ATOM    746  O   ASN A 111     -20.991  40.444  14.484  1.00 20.99           O  
ATOM    747  CB  ASN A 111     -18.152  41.686  13.491  1.00 20.35           C  
ATOM    748  CG  ASN A 111     -16.749  41.944  14.014  1.00 20.26           C  
ATOM    749  OD1 ASN A 111     -16.206  41.193  14.821  1.00 22.88           O  
ATOM    750  ND2 ASN A 111     -16.186  43.072  13.580  1.00 21.52           N  
ATOM    751  N   CYS A 112     -20.572  40.093  12.312  1.00 20.37           N  
ATOM    752  CA  CYS A 112     -21.986  40.047  11.982  1.00 20.31           C  
ATOM    753  C   CYS A 112     -22.681  38.895  12.734  1.00 19.85           C  
ATOM    754  O   CYS A 112     -23.768  39.054  13.290  1.00 20.37           O  
ATOM    755  CB  CYS A 112     -22.149  39.866  10.470  1.00 20.43           C  
ATOM    756  SG  CYS A 112     -23.855  39.844   9.911  1.00 21.33           S  
ATOM    757  N   TYR A 113     -22.027  37.745  12.756  1.00 19.70           N  
ATOM    758  CA  TYR A 113     -22.572  36.579  13.445  1.00 19.31           C  
ATOM    759  C   TYR A 113     -22.597  36.724  14.960  1.00 19.64           C  
ATOM    760  O   TYR A 113     -23.539  36.266  15.609  1.00 20.20           O  
ATOM    761  CB  TYR A 113     -21.832  35.303  13.037  1.00 19.30           C  
ATOM    762  CG  TYR A 113     -21.827  35.089  11.540  1.00 19.60           C  
ATOM    763  CD1 TYR A 113     -22.971  35.288  10.759  1.00 20.21           C  
ATOM    764  CD2 TYR A 113     -20.673  34.702  10.899  1.00 20.00           C  
ATOM    765  CE1 TYR A 113     -22.937  35.069   9.371  1.00 20.62           C  
ATOM    766  CE2 TYR A 113     -20.624  34.493   9.544  1.00 20.09           C  
ATOM    767  CZ  TYR A 113     -21.745  34.690   8.781  1.00 21.42           C  
ATOM    768  OH  TYR A 113     -21.690  34.480   7.418  1.00 21.24           O  
ATOM    769  N   ILE A 114     -21.572  37.344  15.526  1.00 19.04           N  
ATOM    770  CA  ILE A 114     -21.539  37.611  16.970  1.00 18.28           C  
ATOM    771  C   ILE A 114     -22.753  38.434  17.404  1.00 18.30           C  
ATOM    772  O   ILE A 114     -23.372  38.179  18.428  1.00 17.97           O  
ATOM    773  CB  ILE A 114     -20.235  38.364  17.358  1.00 18.23           C  
ATOM    774  CG1 ILE A 114     -19.020  37.419  17.297  1.00 17.90           C  
ATOM    775  CG2 ILE A 114     -20.370  39.015  18.727  1.00 17.58           C  
ATOM    776  CD1 ILE A 114     -17.664  38.159  17.300  1.00 18.58           C  
ATOM    777  N   TYR A 115     -23.084  39.451  16.619  1.00 18.99           N  
ATOM    778  CA  TYR A 115     -24.061  40.432  17.045  1.00 19.60           C  
ATOM    779  C   TYR A 115     -25.503  39.993  16.780  1.00 20.16           C  
ATOM    780  O   TYR A 115     -26.431  40.468  17.449  1.00 20.56           O  
ATOM    781  CB  TYR A 115     -23.789  41.777  16.357  1.00 20.37           C  
ATOM    782  CG  TYR A 115     -24.516  42.922  16.987  1.00 20.52           C  
ATOM    783  CD1 TYR A 115     -24.041  43.499  18.151  1.00 20.32           C  
ATOM    784  CD2 TYR A 115     -25.683  43.427  16.430  1.00 21.17           C  
ATOM    785  CE1 TYR A 115     -24.707  44.554  18.746  1.00 21.18           C  
ATOM    786  CE2 TYR A 115     -26.360  44.483  17.017  1.00 22.72           C  
ATOM    787  CZ  TYR A 115     -25.864  45.040  18.177  1.00 21.92           C  
ATOM    788  OH  TYR A 115     -26.543  46.089  18.762  1.00 24.80           O  
ATOM    789  N   ASN A 116     -25.687  39.109  15.796  1.00 20.92           N  
ATOM    790  CA  ASN A 116     -27.023  38.801  15.288  1.00 21.19           C  
ATOM    791  C   ASN A 116     -27.436  37.350  15.466  1.00 21.85           C  
ATOM    792  O   ASN A 116     -26.593  36.449  15.464  1.00 23.00           O  
ATOM    793  CB  ASN A 116     -27.105  39.168  13.807  1.00 20.93           C  
ATOM    794  CG  ASN A 116     -26.922  40.650  13.565  1.00 21.73           C  
ATOM    795  OD1 ASN A 116     -27.822  41.451  13.843  1.00 23.79           O  
ATOM    796  ND2 ASN A 116     -25.749  41.033  13.069  1.00 22.46           N  
ATOM    797  N   LYS A 117     -28.749  37.165  15.555  1.00 22.72           N  
ATOM    798  CA  LYS A 117     -29.406  35.859  15.750  1.00 23.35           C  
ATOM    799  C   LYS A 117     -29.388  35.043  14.456  1.00 22.51           C  
ATOM    800  O   LYS A 117     -29.435  35.618  13.368  1.00 21.12           O  
ATOM    801  CB  LYS A 117     -30.900  36.062  16.122  1.00 24.35           C  
ATOM    802  CG  LYS A 117     -31.199  37.040  17.258  1.00 26.87           C  
ATOM    803  CD  LYS A 117     -32.658  36.969  17.647  1.00 28.52           C  
ATOM    804  N   PRO A 118     -29.376  33.704  14.560  1.00 21.96           N  
ATOM    805  CA  PRO A 118     -29.353  32.863  13.346  1.00 22.83           C  
ATOM    806  C   PRO A 118     -30.455  33.123  12.310  1.00 22.61           C  
ATOM    807  O   PRO A 118     -30.223  32.957  11.110  1.00 23.81           O  
ATOM    808  CB  PRO A 118     -29.490  31.445  13.903  1.00 23.67           C  
ATOM    809  CG  PRO A 118     -28.983  31.512  15.270  1.00 23.25           C  
ATOM    810  CD  PRO A 118     -29.248  32.898  15.788  1.00 22.10           C  
ATOM    811  N   THR A 119     -31.628  33.542  12.757  1.00 21.88           N  
ATOM    812  CA  THR A 119     -32.749  33.791  11.852  1.00 22.17           C  
ATOM    813  C   THR A 119     -32.801  35.209  11.280  1.00 21.55           C  
ATOM    814  O   THR A 119     -33.696  35.515  10.487  1.00 21.80           O  
ATOM    815  CB  THR A 119     -34.090  33.538  12.573  1.00 22.21           C  
ATOM    816  OG1 THR A 119     -34.119  34.268  13.809  1.00 24.70           O  
ATOM    817  CG2 THR A 119     -34.304  32.052  12.844  1.00 23.04           C  
ATOM    818  N   ASP A 120     -31.882  36.080  11.686  1.00 20.59           N  
ATOM    819  CA  ASP A 120     -31.890  37.466  11.208  1.00 21.09           C  
ATOM    820  C   ASP A 120     -31.532  37.509   9.715  1.00 21.13           C  
ATOM    821  O   ASP A 120     -30.615  36.807   9.252  1.00 21.22           O  
ATOM    822  CB  ASP A 120     -30.897  38.347  11.977  1.00 21.48           C  
ATOM    823  CG  ASP A 120     -31.362  38.704  13.387  1.00 23.73           C  
ATOM    824  OD1 ASP A 120     -32.556  38.536  13.682  1.00 24.73           O  
ATOM    825  OD2 ASP A 120     -30.507  39.133  14.202  1.00 24.63           O  
ATOM    826  N   ASP A 121     -32.205  38.378   8.973  1.00 20.83           N  
ATOM    827  CA  ASP A 121     -31.915  38.530   7.546  1.00 21.09           C  
ATOM    828  C   ASP A 121     -30.452  38.832   7.288  1.00 20.85           C  
ATOM    829  O   ASP A 121     -29.870  38.317   6.326  1.00 20.40           O  
ATOM    830  CB  ASP A 121     -32.767  39.644   6.942  1.00 21.76           C  
ATOM    831  CG  ASP A 121     -34.234  39.281   6.846  1.00 23.91           C  
ATOM    832  OD1 ASP A 121     -34.581  38.083   6.908  1.00 26.82           O  
ATOM    833  OD2 ASP A 121     -35.057  40.211   6.686  1.00 28.28           O  
ATOM    834  N   ILE A 122     -29.829  39.679   8.109  1.00 20.05           N  
ATOM    835  CA  ILE A 122     -28.433  40.056   7.845  1.00 20.62           C  
ATOM    836  C   ILE A 122     -27.494  38.838   7.913  1.00 21.02           C  
ATOM    837  O   ILE A 122     -26.450  38.800   7.235  1.00 20.35           O  
ATOM    838  CB  ILE A 122     -27.946  41.183   8.818  1.00 20.29           C  
ATOM    839  CG1 ILE A 122     -26.627  41.811   8.348  1.00 21.61           C  
ATOM    840  CG2 ILE A 122     -27.839  40.672  10.259  1.00 21.88           C  
ATOM    841  CD1 ILE A 122     -26.682  42.435   6.952  1.00 22.15           C  
ATOM    842  N   VAL A 123     -27.860  37.848   8.718  1.00 21.15           N  
ATOM    843  CA  VAL A 123     -27.022  36.638   8.840  1.00 20.88           C  
ATOM    844  C   VAL A 123     -27.088  35.812   7.561  1.00 21.29           C  
ATOM    845  O   VAL A 123     -26.056  35.327   7.067  1.00 21.35           O  
ATOM    846  CB  VAL A 123     -27.431  35.790  10.064  1.00 21.60           C  
ATOM    847  CG1 VAL A 123     -26.795  34.393  10.008  1.00 22.16           C  
ATOM    848  CG2 VAL A 123     -27.058  36.511  11.338  1.00 22.67           C  
ATOM    849  N   LEU A 124     -28.281  35.687   6.994  1.00 21.08           N  
ATOM    850  CA  LEU A 124     -28.420  35.026   5.711  1.00 21.15           C  
ATOM    851  C   LEU A 124     -27.635  35.761   4.628  1.00 20.73           C  
ATOM    852  O   LEU A 124     -27.045  35.129   3.761  1.00 20.84           O  
ATOM    853  CB  LEU A 124     -29.890  34.930   5.311  1.00 21.04           C  
ATOM    854  CG  LEU A 124     -30.157  34.401   3.897  1.00 24.73           C  
ATOM    855  N   MET A 125     -27.632  37.092   4.682  1.00 20.50           N  
ATOM    856  CA  MET A 125     -26.908  37.916   3.716  1.00 20.56           C  
ATOM    857  C   MET A 125     -25.418  37.681   3.848  1.00 20.70           C  
ATOM    858  O   MET A 125     -24.746  37.399   2.865  1.00 21.31           O  
ATOM    859  CB  MET A 125     -27.296  39.396   3.909  1.00 19.91           C  
ATOM    860  CG  MET A 125     -28.744  39.652   3.513  1.00 20.83           C  
ATOM    861  SD  MET A 125     -29.328  41.292   3.984  1.00 20.58           S  
ATOM    862  CE  MET A 125     -28.770  42.271   2.588  1.00 21.53           C  
ATOM    863  N   ALA A 126     -24.903  37.782   5.066  1.00 20.52           N  
ATOM    864  CA  ALA A 126     -23.492  37.495   5.338  1.00 20.42           C  
ATOM    865  C   ALA A 126     -23.101  36.093   4.887  1.00 20.26           C  
ATOM    866  O   ALA A 126     -22.043  35.907   4.293  1.00 21.03           O  
ATOM    867  CB  ALA A 126     -23.177  37.693   6.808  1.00 20.46           C  
ATOM    868  N   GLN A 127     -23.954  35.111   5.145  1.00 20.61           N  
ATOM    869  CA  GLN A 127     -23.621  33.735   4.779  1.00 21.19           C  
ATOM    870  C   GLN A 127     -23.401  33.566   3.289  1.00 21.43           C  
ATOM    871  O   GLN A 127     -22.518  32.813   2.866  1.00 20.95           O  
ATOM    872  CB  GLN A 127     -24.716  32.779   5.209  1.00 21.75           C  
ATOM    873  CG  GLN A 127     -24.727  32.492   6.680  1.00 23.58           C  
ATOM    874  CD  GLN A 127     -25.917  31.642   7.080  1.00 25.57           C  
ATOM    875  OE1 GLN A 127     -27.031  31.809   6.572  1.00 26.86           O  
ATOM    876  NE2 GLN A 127     -25.691  30.720   7.996  1.00 28.21           N  
ATOM    877  N   ALA A 128     -24.232  34.229   2.489  1.00 21.14           N  
ATOM    878  CA  ALA A 128     -24.114  34.145   1.044  1.00 21.54           C  
ATOM    879  C   ALA A 128     -22.786  34.734   0.597  1.00 21.53           C  
ATOM    880  O   ALA A 128     -22.065  34.160  -0.240  1.00 22.53           O  
ATOM    881  CB  ALA A 128     -25.278  34.890   0.383  1.00 21.48           C  
ATOM    882  N   LEU A 129     -22.461  35.898   1.148  1.00 21.89           N  
ATOM    883  CA  LEU A 129     -21.225  36.593   0.808  1.00 21.23           C  
ATOM    884  C   LEU A 129     -20.011  35.771   1.249  1.00 21.63           C  
ATOM    885  O   LEU A 129     -19.013  35.673   0.528  1.00 21.55           O  
ATOM    886  CB  LEU A 129     -21.214  37.975   1.467  1.00 21.79           C  
ATOM    887  CG  LEU A 129     -22.428  38.858   1.126  1.00 22.36           C  
ATOM    888  CD1 LEU A 129     -22.477  40.082   2.003  1.00 25.23           C  
ATOM    889  CD2 LEU A 129     -22.369  39.249  -0.321  1.00 22.29           C  
ATOM    890  N   GLU A 130     -20.103  35.181   2.440  1.00 21.03           N  
ATOM    891  CA  GLU A 130     -18.974  34.434   2.975  1.00 20.99           C  
ATOM    892  C   GLU A 130     -18.672  33.194   2.164  1.00 22.04           C  
ATOM    893  O   GLU A 130     -17.500  32.840   1.970  1.00 22.20           O  
ATOM    894  CB  GLU A 130     -19.216  34.052   4.426  1.00 20.98           C  
ATOM    895  CG  GLU A 130     -17.991  33.452   5.094  1.00 21.04           C  
ATOM    896  CD  GLU A 130     -18.176  33.242   6.570  1.00 22.14           C  
ATOM    897  OE1 GLU A 130     -19.337  33.162   7.003  1.00 21.65           O  
ATOM    898  OE2 GLU A 130     -17.155  33.134   7.292  1.00 22.34           O  
ATOM    899  N   LYS A 131     -19.703  32.509   1.696  1.00 22.07           N  
ATOM    900  CA  LYS A 131     -19.464  31.334   0.886  1.00 21.90           C  
ATOM    901  C   LYS A 131     -18.692  31.711  -0.385  1.00 22.26           C  
ATOM    902  O   LYS A 131     -17.760  31.010  -0.779  1.00 22.12           O  
ATOM    903  CB  LYS A 131     -20.779  30.626   0.541  1.00 22.51           C  
ATOM    904  CG  LYS A 131     -20.613  29.319  -0.200  1.00 23.43           C  
ATOM    905  CD  LYS A 131     -21.919  28.506  -0.252  1.00 25.14           C  
ATOM    906  N   ILE A 132     -19.054  32.837  -0.994  1.00 21.64           N  
ATOM    907  CA  ILE A 132     -18.346  33.344  -2.162  1.00 21.59           C  
ATOM    908  C   ILE A 132     -16.887  33.728  -1.823  1.00 21.51           C  
ATOM    909  O   ILE A 132     -15.953  33.373  -2.555  1.00 21.37           O  
ATOM    910  CB  ILE A 132     -19.060  34.558  -2.746  1.00 22.62           C  
ATOM    911  CG1 ILE A 132     -20.444  34.186  -3.266  1.00 22.52           C  
ATOM    912  CG2 ILE A 132     -18.246  35.160  -3.871  1.00 23.35           C  
ATOM    913  CD1 ILE A 132     -21.338  35.394  -3.391  1.00 22.80           C  
ATOM    914  N   PHE A 133     -16.702  34.440  -0.711  1.00 21.28           N  
ATOM    915  CA  PHE A 133     -15.364  34.762  -0.233  1.00 21.09           C  
ATOM    916  C   PHE A 133     -14.489  33.508  -0.160  1.00 20.88           C  
ATOM    917  O   PHE A 133     -13.351  33.500  -0.641  1.00 21.09           O  
ATOM    918  CB  PHE A 133     -15.483  35.436   1.142  1.00 21.46           C  
ATOM    919  CG  PHE A 133     -14.183  35.595   1.866  1.00 20.86           C  
ATOM    920  CD1 PHE A 133     -13.307  36.621   1.553  1.00 21.55           C  
ATOM    921  CD2 PHE A 133     -13.840  34.720   2.885  1.00 22.90           C  
ATOM    922  CE1 PHE A 133     -12.110  36.752   2.227  1.00 20.64           C  
ATOM    923  CE2 PHE A 133     -12.640  34.853   3.558  1.00 22.58           C  
ATOM    924  CZ  PHE A 133     -11.778  35.864   3.226  1.00 21.09           C  
ATOM    925  N   LEU A 134     -15.011  32.460   0.470  1.00 20.32           N  
ATOM    926  CA  LEU A 134     -14.228  31.224   0.624  1.00 20.36           C  
ATOM    927  C   LEU A 134     -13.896  30.612  -0.732  1.00 20.31           C  
ATOM    928  O   LEU A 134     -12.758  30.193  -0.980  1.00 19.97           O  
ATOM    929  CB  LEU A 134     -14.943  30.218   1.521  1.00 19.78           C  
ATOM    930  CG  LEU A 134     -15.127  30.611   2.990  1.00 20.48           C  
ATOM    931  CD1 LEU A 134     -15.943  29.544   3.737  1.00 20.65           C  
ATOM    932  CD2 LEU A 134     -13.782  30.858   3.693  1.00 22.36           C  
ATOM    933  N   GLN A 135     -14.879  30.555  -1.620  1.00 20.03           N  
ATOM    934  CA  GLN A 135     -14.654  30.003  -2.959  1.00 20.31           C  
ATOM    935  C   GLN A 135     -13.585  30.806  -3.712  1.00 21.02           C  
ATOM    936  O   GLN A 135     -12.737  30.224  -4.392  1.00 21.17           O  
ATOM    937  CB  GLN A 135     -15.981  29.977  -3.734  1.00 20.57           C  
ATOM    938  CG  GLN A 135     -16.968  28.921  -3.227  1.00 21.25           C  
ATOM    939  CD  GLN A 135     -18.401  29.090  -3.750  1.00 22.37           C  
ATOM    940  OE1 GLN A 135     -18.790  30.151  -4.269  1.00 24.80           O  
ATOM    941  NE2 GLN A 135     -19.199  28.048  -3.589  1.00 23.26           N  
ATOM    942  N   LYS A 136     -13.612  32.129  -3.570  1.00 20.33           N  
ATOM    943  CA  LYS A 136     -12.625  32.971  -4.266  1.00 20.71           C  
ATOM    944  C   LYS A 136     -11.239  32.880  -3.636  1.00 21.11           C  
ATOM    945  O   LYS A 136     -10.249  32.820  -4.346  1.00 21.70           O  
ATOM    946  CB  LYS A 136     -13.073  34.437  -4.345  1.00 21.35           C  
ATOM    947  CG  LYS A 136     -14.319  34.671  -5.213  1.00 22.02           C  
ATOM    948  CD  LYS A 136     -14.164  34.147  -6.618  1.00 24.33           C  
ATOM    949  CE  LYS A 136     -15.338  34.567  -7.462  1.00 25.74           C  
ATOM    950  NZ  LYS A 136     -15.233  34.029  -8.836  1.00 26.67           N  
ATOM    951  N   VAL A 137     -11.138  32.874  -2.311  1.00 20.97           N  
ATOM    952  CA  VAL A 137      -9.797  32.811  -1.710  1.00 21.78           C  
ATOM    953  C   VAL A 137      -9.159  31.440  -1.910  1.00 21.61           C  
ATOM    954  O   VAL A 137      -7.930  31.330  -1.950  1.00 21.34           O  
ATOM    955  CB  VAL A 137      -9.765  33.254  -0.221  1.00 22.12           C  
ATOM    956  CG1 VAL A 137     -10.229  34.714  -0.101  1.00 23.26           C  
ATOM    957  CG2 VAL A 137     -10.580  32.311   0.656  1.00 25.70           C  
ATOM    958  N   ALA A 138      -9.964  30.394  -2.107  1.00 21.41           N  
ATOM    959  CA  ALA A 138      -9.420  29.095  -2.469  1.00 21.07           C  
ATOM    960  C   ALA A 138      -8.690  29.117  -3.808  1.00 20.84           C  
ATOM    961  O   ALA A 138      -7.832  28.269  -4.052  1.00 22.18           O  
ATOM    962  CB  ALA A 138     -10.530  28.028  -2.487  1.00 21.00           C  
ATOM    963  N   GLN A 139      -9.043  30.076  -4.653  1.00 19.98           N  
ATOM    964  CA  GLN A 139      -8.423  30.214  -5.982  1.00 19.51           C  
ATOM    965  C   GLN A 139      -7.396  31.343  -6.035  1.00 20.32           C  
ATOM    966  O   GLN A 139      -6.973  31.749  -7.101  1.00 20.40           O  
ATOM    967  CB  GLN A 139      -9.522  30.407  -7.027  1.00 19.25           C  
ATOM    968  CG  GLN A 139     -10.477  29.228  -7.103  1.00 20.16           C  
ATOM    969  CD  GLN A 139     -11.591  29.431  -8.099  1.00 23.28           C  
ATOM    970  OE1 GLN A 139     -11.961  30.559  -8.415  1.00 26.67           O  
ATOM    971  NE2 GLN A 139     -12.142  28.329  -8.596  1.00 24.95           N  
ATOM    972  N   MET A 140      -6.987  31.850  -4.879  1.00 20.60           N  
ATOM    973  CA  MET A 140      -5.998  32.909  -4.862  0.50 20.55           C  
ATOM    975  C   MET A 140      -4.714  32.431  -5.555  1.00 20.74           C  
ATOM    976  O   MET A 140      -4.261  31.297  -5.369  1.00 21.62           O  
ATOM    977  CB  MET A 140      -5.706  33.346  -3.439  0.50 20.37           C  
ATOM    979  CG  MET A 140      -4.674  34.463  -3.290  0.50 18.90           C  
ATOM    981  SD  MET A 140      -4.288  34.685  -1.548  0.50 16.43           S  
ATOM    983  CE  MET A 140      -5.514  35.923  -1.130  0.50 19.34           C  
ATOM    985  N   PRO A 141      -4.140  33.306  -6.390  1.00 20.61           N  
ATOM    986  CA  PRO A 141      -2.896  32.955  -7.079  1.00 20.22           C  
ATOM    987  C   PRO A 141      -1.673  32.923  -6.170  1.00 20.33           C  
ATOM    988  O   PRO A 141      -1.663  33.448  -5.068  1.00 21.69           O  
ATOM    989  CB  PRO A 141      -2.747  34.078  -8.107  1.00 20.27           C  
ATOM    990  CG  PRO A 141      -3.393  35.237  -7.465  1.00 21.36           C  
ATOM    991  CD  PRO A 141      -4.608  34.641  -6.790  1.00 20.14           C  
ATOM    992  N   GLN A 142      -0.656  32.243  -6.667  1.00 20.61           N  
ATOM    993  CA  GLN A 142       0.667  32.281  -6.065  1.00 20.52           C  
ATOM    994  C   GLN A 142       1.343  33.599  -6.422  1.00 20.22           C  
ATOM    995  O   GLN A 142       1.151  34.143  -7.521  1.00 20.19           O  
ATOM    996  CB  GLN A 142       1.501  31.122  -6.599  1.00 21.16           C  
ATOM    997  CG  GLN A 142       0.941  29.762  -6.232  1.00 22.30           C  
ATOM    998  CD  GLN A 142       1.427  29.265  -4.903  1.00 23.62           C  
ATOM    999  OE1 GLN A 142       2.607  29.036  -4.711  1.00 24.98           O  
ATOM   1000  NE2 GLN A 142       0.502  29.061  -3.977  1.00 28.89           N  
ATOM   1001  N   GLU A 143       2.111  34.134  -5.479  1.00 20.01           N  
ATOM   1002  CA  GLU A 143       3.097  35.166  -5.808  1.00 20.71           C  
ATOM   1003  C   GLU A 143       4.185  34.547  -6.675  1.00 21.60           C  
ATOM   1004  O   GLU A 143       4.538  33.387  -6.497  1.00 20.46           O  
ATOM   1005  CB  GLU A 143       3.777  35.710  -4.554  1.00 22.12           C  
ATOM   1006  CG  GLU A 143       2.935  36.590  -3.704  1.00 22.59           C  
ATOM   1007  CD  GLU A 143       2.229  37.737  -4.457  1.00 24.00           C  
ATOM   1008  OE1 GLU A 143       2.833  38.502  -5.239  1.00 22.93           O  
ATOM   1009  OE2 GLU A 143       1.033  37.865  -4.203  1.00 24.30           O  
ATOM   1010  N   GLU A 144       4.758  35.319  -7.593  1.00 22.57           N  
ATOM   1011  CA  GLU A 144       5.803  34.801  -8.472  1.00 24.14           C  
ATOM   1012  C   GLU A 144       7.140  35.489  -8.239  1.00 24.65           C  
ATOM   1013  O   GLU A 144       8.221  34.937  -8.487  1.00 25.72           O  
ATOM   1014  CB  GLU A 144       5.365  34.952  -9.928  1.00 24.62           C  
ATOM   1015  CG  GLU A 144       4.117  34.155 -10.224  1.00 26.02           C  
ATOM   1016  CD  GLU A 144       3.575  34.380 -11.615  1.00 28.67           C  
ATOM   1017  OE1 GLU A 144       4.310  34.905 -12.467  1.00 29.68           O  
ATOM   1018  OE2 GLU A 144       2.399  34.022 -11.838  1.00 32.05           O  
ATOM   1019  OXT GLU A 144       7.160  36.636  -7.796  1.00 26.29           O  
TER    1020      GLU A 144                                                      
END
MOLECULE T0432.pdb
ATOM      1  N   SER     1      12.703  45.910  -3.320  1.00 50.93           N
ATOM      2  CA  SER     1      13.109  46.216  -4.712  1.00 47.13           C
ATOM      4  CB  SER     1      13.709  44.967  -5.358  1.00 53.53           C
ATOM      7  OG  SER     1      12.759  43.911  -5.430  1.00 42.48           O
ATOM      9  C   SER     1      11.931  46.715  -5.566  1.00 52.43           C
ATOM     10  O   SER     1      10.768  46.719  -5.114  1.00 45.72           O
ATOM     14  N   MET     2      12.255  47.142  -6.791  1.00 48.01           N
ATOM     15  CA  MET     2      11.257  47.418  -7.836  1.00 53.09           C
ATOM     17  CB  MET     2      11.927  47.928  -9.120  1.00 51.71           C
ATOM     23  C   MET     2      10.424  46.169  -8.153  1.00 49.18           C
ATOM     24  O   MET     2       9.206  46.267  -8.286  1.00 51.00           O
ATOM     26  N   GLN     3      11.078  45.011  -8.268  1.00 44.90           N
ATOM     27  CA  GLN     3      10.368  43.738  -8.433  1.00 49.87           C
ATOM     29  CB  GLN     3      11.334  42.538  -8.524  1.00 49.44           C
ATOM     32  CG  GLN     3      11.990  42.326  -9.886  1.00 56.96           C
ATOM     38  C   GLN     3       9.361  43.512  -7.283  1.00 43.65           C
ATOM     39  O   GLN     3       8.242  43.071  -7.521  1.00 37.83           O
ATOM     41  N   GLU     4       9.764  43.812  -6.049  1.00 34.49           N
ATOM     42  CA  GLU     4       8.896  43.571  -4.909  1.00 28.57           C
ATOM     44  CB  GLU     4       9.695  43.588  -3.619  1.00 30.35           C
ATOM     47  CG  GLU     4      10.564  42.317  -3.478  1.00 32.03           C
ATOM     50  CD  GLU     4      11.497  42.362  -2.284  1.00 34.53           C
ATOM     51  OE1 GLU     4      11.564  43.415  -1.624  1.00 39.92           O
ATOM     52  OE2 GLU     4      12.167  41.335  -2.002  1.00 35.71           O
ATOM     53  C   GLU     4       7.708  44.529  -4.871  1.00 25.78           C
ATOM     54  O   GLU     4       6.586  44.106  -4.548  1.00 21.89           O
ATOM     56  N   GLU     5       7.958  45.807  -5.172  1.00 27.67           N
ATOM     57  CA  GLU     5       6.900  46.803  -5.275  1.00 29.37           C
ATOM     59  CB  GLU     5       7.492  48.200  -5.504  1.00 32.93           C
ATOM     62  CG  GLU     5       8.329  48.698  -4.321  1.00 36.17           C
ATOM     68  C   GLU     5       5.841  46.464  -6.357  1.00 26.28           C
ATOM     69  O   GLU     5       4.652  46.729  -6.168  1.00 24.25           O
ATOM     71  N   ASP     6       6.276  45.882  -7.472  1.00 23.77           N
ATOM     72  CA  ASP     6       5.354  45.408  -8.499  1.00 26.67           C
ATOM     74  CB  ASP     6       6.099  44.978  -9.756  1.00 25.76           C
ATOM     77  CG  ASP     6       6.749  46.165 -10.526  1.00 24.96           C
ATOM     78  OD1 ASP     6       6.374  47.338 -10.325  1.00 41.80           O
ATOM     79  OD2 ASP     6       7.653  45.870 -11.317  1.00 39.42           O
ATOM     80  C   ASP     6       4.501  44.208  -7.998  1.00 20.23           C
ATOM     81  O   ASP     6       3.358  44.093  -8.388  1.00 20.47           O
ATOM     83  N   THR     7       5.093  43.319  -7.201  1.00 22.25           N
ATOM     84  CA  THR     7       4.384  42.184  -6.606  1.00 22.70           C
ATOM     86  CB  THR     7       5.332  41.245  -5.780  1.00 22.94           C
ATOM     88  OG1 THR     7       6.367  40.712  -6.630  1.00 26.30           O
ATOM     90  CG2 THR     7       4.556  40.047  -5.132  1.00 16.87           C
ATOM     94  C   THR     7       3.250  42.693  -5.726  1.00 21.27           C
ATOM     95  O   THR     7       2.114  42.227  -5.839  1.00 18.76           O
ATOM     97  N   PHE     8       3.574  43.615  -4.823  1.00 19.23           N
ATOM     98  CA  PHE     8       2.558  44.181  -3.944  1.00 19.60           C
ATOM    100  CB  PHE     8       3.176  45.001  -2.822  1.00 22.71           C
ATOM    103  CG  PHE     8       3.951  44.177  -1.823  1.00 23.51           C
ATOM    104  CD1 PHE     8       3.439  42.949  -1.346  1.00 28.77           C
ATOM    106  CE1 PHE     8       4.152  42.173  -0.434  1.00 28.06           C
ATOM    108  CZ  PHE     8       5.373  42.635   0.031  1.00 28.78           C
ATOM    110  CE2 PHE     8       5.884  43.835  -0.423  1.00 30.30           C
ATOM    112  CD2 PHE     8       5.169  44.616  -1.353  1.00 28.10           C
ATOM    114  C   PHE     8       1.496  44.993  -4.689  1.00 22.06           C
ATOM    115  O   PHE     8       0.320  44.959  -4.316  1.00 17.45           O
ATOM    117  N   ARG     9       1.904  45.735  -5.712  1.00 20.32           N
ATOM    118  CA  ARG     9       0.939  46.442  -6.556  1.00 18.47           C
ATOM    120  CB  ARG     9       1.639  47.343  -7.542  1.00 20.96           C
ATOM    123  CG  ARG     9       0.718  48.210  -8.324  1.00 30.12           C
ATOM    126  CD  ARG     9       1.462  49.336  -8.973  1.00 33.72           C
ATOM    129  NE  ARG     9       0.560  50.358  -9.495  1.00 49.38           N
ATOM    131  CZ  ARG     9      -0.009  50.371 -10.710  1.00 50.88           C
ATOM    132  NH1 ARG     9       0.198  49.411 -11.626  1.00 36.54           N
ATOM    135  NH2 ARG     9      -0.779  51.400 -11.024  1.00 35.58           N
ATOM    138  C   ARG     9      -0.005  45.464  -7.267  1.00 18.25           C
ATOM    139  O   ARG     9      -1.217  45.710  -7.282  1.00 15.91           O
ATOM    141  N   GLU    10       0.522  44.363  -7.832  1.00 15.31           N
ATOM    142  CA  GLU    10      -0.351  43.339  -8.413  1.00 19.50           C
ATOM    144  CB  GLU    10       0.439  42.219  -9.076  1.00 21.24           C
ATOM    147  CG  GLU    10      -0.467  41.097  -9.566  1.00 23.10           C
ATOM    150  CD  GLU    10       0.189  40.117 -10.508  1.00 33.77           C
ATOM    151  OE1 GLU    10      -0.487  39.118 -10.845  1.00 26.89           O
ATOM    152  OE2 GLU    10       1.358  40.328 -10.890  1.00 26.18           O
ATOM    153  C   GLU    10      -1.355  42.768  -7.382  1.00 23.48           C
ATOM    154  O   GLU    10      -2.548  42.617  -7.692  1.00 16.96           O
ATOM    156  N   LEU    11      -0.871  42.447  -6.176  1.00 22.33           N
ATOM    157  CA  LEU    11      -1.756  42.020  -5.079  1.00 17.97           C
ATOM    159  CB  LEU    11      -0.969  41.736  -3.779  1.00 21.21           C
ATOM    162  CG  LEU    11      -1.851  41.320  -2.564  1.00 18.71           C
ATOM    164  CD1 LEU    11      -2.569  39.975  -2.827  1.00 16.49           C
ATOM    168  CD2 LEU    11      -1.052  41.296  -1.292  1.00 17.23           C
ATOM    172  C   LEU    11      -2.872  43.029  -4.826  1.00 18.50           C
ATOM    173  O   LEU    11      -4.018  42.652  -4.757  1.00 17.18           O
ATOM    175  N   ARG    12      -2.554  44.316  -4.710  1.00 16.81           N
ATOM    176  CA  ARG    12      -3.587  45.342  -4.508  1.00 18.76           C
ATOM    178  CB  ARG    12      -2.975  46.756  -4.299  1.00 15.68           C
ATOM    181  CG  ARG    12      -2.092  46.846  -3.060  1.00 20.36           C
ATOM    184  CD  ARG    12      -1.799  48.294  -2.715  1.00 24.48           C
ATOM    187  NE  ARG    12      -0.943  48.950  -3.696  1.00 19.83           N
ATOM    189  CZ  ARG    12       0.393  48.875  -3.740  1.00 17.58           C
ATOM    190  NH1 ARG    12       1.084  48.164  -2.878  1.00 25.76           N
ATOM    193  NH2 ARG    12       1.034  49.530  -4.686  1.00 24.92           N
ATOM    196  C   ARG    12      -4.628  45.388  -5.624  1.00 16.66           C
ATOM    197  O   ARG    12      -5.828  45.475  -5.353  1.00 16.08           O
ATOM    199  N   ILE    13      -4.164  45.301  -6.864  1.00 19.21           N
ATOM    200  CA  ILE    13      -5.044  45.236  -8.043  1.00 17.95           C
ATOM    202  CB  ILE    13      -4.224  45.209  -9.367  1.00 17.89           C
ATOM    204  CG1 ILE    13      -3.478  46.541  -9.577  1.00 23.66           C
ATOM    207  CD1 ILE    13      -2.498  46.500 -10.707  1.00 27.76           C
ATOM    211  CG2 ILE    13      -5.101  44.894 -10.587  1.00 24.21           C
ATOM    215  C   ILE    13      -5.997  44.011  -7.963  1.00 14.86           C
ATOM    216  O   ILE    13      -7.218  44.155  -8.154  1.00 16.18           O
ATOM    218  N   PHE    14      -5.438  42.857  -7.652  1.00 16.54           N
ATOM    219  CA  PHE    14      -6.211  41.642  -7.441  1.00 15.48           C
ATOM    221  CB  PHE    14      -5.313  40.456  -7.134  1.00 18.04           C
ATOM    224  CG  PHE    14      -6.074  39.237  -6.793  1.00 18.02           C
ATOM    225  CD1 PHE    14      -6.678  38.465  -7.790  1.00 26.02           C
ATOM    227  CE1 PHE    14      -7.424  37.332  -7.462  1.00 20.26           C
ATOM    229  CZ  PHE    14      -7.559  36.973  -6.149  1.00 20.14           C
ATOM    231  CE2 PHE    14      -6.970  37.746  -5.142  1.00 23.20           C
ATOM    233  CD2 PHE    14      -6.239  38.861  -5.465  1.00 22.05           C
ATOM    235  C   PHE    14      -7.252  41.824  -6.314  1.00 17.60           C
ATOM    236  O   PHE    14      -8.431  41.558  -6.507  1.00 16.66           O
ATOM    238  N   LEU    15      -6.807  42.332  -5.166  1.00 15.25           N
ATOM    239  CA  LEU    15      -7.701  42.555  -4.016  1.00 15.48           C
ATOM    241  CB  LEU    15      -6.921  42.915  -2.741  1.00 17.25           C
ATOM    244  CG  LEU    15      -5.972  41.845  -2.195  1.00 20.45           C
ATOM    246  CD1 LEU    15      -5.225  42.342  -0.920  1.00 15.28           C
ATOM    250  CD2 LEU    15      -6.687  40.491  -1.929  1.00 17.37           C
ATOM    254  C   LEU    15      -8.826  43.550  -4.269  1.00 16.03           C
ATOM    255  O   LEU    15      -9.961  43.320  -3.815  1.00 15.92           O
ATOM    257  N   ARG    16      -8.542  44.625  -4.980  1.00 16.38           N
ATOM    258  CA  ARG    16      -9.590  45.593  -5.363  1.00 13.95           C
ATOM    260  CB  ARG    16      -9.022  46.796  -6.096  1.00 16.47           C
ATOM    263  CG  ARG    16      -8.327  47.808  -5.243  1.00 20.20           C
ATOM    266  CD  ARG    16      -7.975  49.054  -6.021  1.00 26.38           C
ATOM    269  NE  ARG    16      -6.868  49.676  -5.338  1.00 24.76           N
ATOM    271  CZ  ARG    16      -5.583  49.547  -5.650  1.00 23.18           C
ATOM    272  NH1 ARG    16      -5.178  48.910  -6.742  1.00 24.86           N
ATOM    275  NH2 ARG    16      -4.686  50.121  -4.856  1.00 30.66           N
ATOM    278  C   ARG    16     -10.679  44.968  -6.259  1.00 13.93           C
ATOM    279  O   ARG    16     -11.864  45.248  -6.112  1.00 14.07           O
ATOM    281  N   ASN    17     -10.257  44.175  -7.218  1.00 16.80           N
ATOM    282  CA  ASN    17     -11.176  43.522  -8.112  1.00 18.78           C
ATOM    284  CB  ASN    17     -10.401  42.870  -9.247  1.00 21.01           C
ATOM    287  CG  ASN    17     -11.295  42.036 -10.170  1.00 28.67           C
ATOM    288  OD1 ASN    17     -11.469  40.838  -9.941  1.00 21.42           O
ATOM    289  ND2 ASN    17     -11.827  42.664 -11.250  1.00 28.09           N
ATOM    292  C   ASN    17     -12.089  42.535  -7.382  1.00 16.00           C
ATOM    293  O   ASN    17     -13.302  42.574  -7.591  1.00 17.86           O
ATOM    295  N   VAL    18     -11.520  41.689  -6.521  1.00 18.79           N
ATOM    296  CA  VAL    18     -12.301  40.735  -5.735  1.00 17.67           C
ATOM    298  CB  VAL    18     -11.407  39.847  -4.834  1.00 19.56           C
ATOM    300  CG1 VAL    18     -12.271  39.004  -3.891  1.00 20.84           C
ATOM    304  CG2 VAL    18     -10.450  38.989  -5.687  1.00 14.57           C
ATOM    308  C   VAL    18     -13.266  41.501  -4.810  1.00 17.37           C
ATOM    309  O   VAL    18     -14.450  41.176  -4.721  1.00 19.43           O
ATOM    311  N   THR    19     -12.747  42.526  -4.146  1.00 16.37           N
ATOM    312  CA  THR    19     -13.563  43.341  -3.222  1.00 17.39           C
ATOM    314  CB  THR    19     -12.716  44.371  -2.443  1.00 16.96           C
ATOM    316  OG1 THR    19     -11.617  43.710  -1.816  1.00 17.66           O
ATOM    318  CG2 THR    19     -13.564  45.076  -1.343  1.00 20.05           C
ATOM    322  C   THR    19     -14.744  44.026  -3.933  1.00 17.65           C
ATOM    323  O   THR    19     -15.852  44.020  -3.417  1.00 19.09           O
ATOM    325  N   HIS    20     -14.508  44.595  -5.101  1.00 19.93           N
ATOM    326  CA  HIS    20     -15.611  45.135  -5.920  1.00 19.72           C
ATOM    328  CB  HIS    20     -15.059  45.947  -7.086  0.50 21.68           C
ATOM    334  CG  HIS    20     -14.484  47.263  -6.651  0.50 31.09           C
ATOM    336  ND1 HIS    20     -15.103  48.066  -5.710  0.50 15.30           N
ATOM    340  CE1 HIS    20     -14.376  49.152  -5.520  0.50 31.02           C
ATOM    344  NE2 HIS    20     -13.308  49.082  -6.295  0.50 28.85           N
ATOM    348  CD2 HIS    20     -13.355  47.914  -7.019  0.50 25.42           C
ATOM    352  C   HIS    20     -16.660  44.095  -6.319  1.00 17.96           C
ATOM    353  O   HIS    20     -17.853  44.378  -6.303  1.00 20.97           O
ATOM    355  N   ARG    21     -16.230  42.894  -6.686  1.00 17.03           N
ATOM    356  CA  ARG    21     -17.180  41.826  -7.010  1.00 18.99           C
ATOM    358  CB  ARG    21     -16.435  40.624  -7.602  1.00 14.36           C
ATOM    361  CG  ARG    21     -15.970  40.922  -9.011  1.00 20.10           C
ATOM    364  CD  ARG    21     -14.704  40.187  -9.358  1.00 26.48           C
ATOM    367  NE  ARG    21     -14.976  38.798  -9.527  1.00 23.70           N
ATOM    369  CZ  ARG    21     -14.059  37.850  -9.652  1.00 24.65           C
ATOM    370  NH1 ARG    21     -12.773  38.120  -9.628  1.00 21.13           N
ATOM    373  NH2 ARG    21     -14.461  36.619  -9.815  1.00 21.77           N
ATOM    376  C   ARG    21     -18.083  41.435  -5.822  1.00 19.61           C
ATOM    377  O   ARG    21     -19.285  41.157  -5.992  1.00 23.33           O
ATOM    379  N   LEU    22     -17.522  41.469  -4.622  1.00 19.80           N
ATOM    380  CA  LEU    22     -18.300  41.281  -3.399  1.00 18.25           C
ATOM    382  CB  LEU    22     -17.378  41.023  -2.193  1.00 19.98           C
ATOM    385  CG  LEU    22     -16.345  39.907  -2.263  1.00 18.93           C
ATOM    387  CD1 LEU    22     -15.396  39.999  -1.040  1.00 20.62           C
ATOM    391  CD2 LEU    22     -17.018  38.495  -2.365  1.00 20.07           C
ATOM    395  C   LEU    22     -19.228  42.459  -3.101  1.00 20.64           C
ATOM    396  O   LEU    22     -20.415  42.251  -2.807  1.00 21.92           O
ATOM    398  N   ALA    23     -18.701  43.679  -3.190  1.00 17.45           N
ATOM    399  CA  ALA    23     -19.441  44.866  -2.847  1.00 17.66           C
ATOM    401  CB  ALA    23     -18.527  46.122  -2.822  1.00 21.62           C
ATOM    405  C   ALA    23     -20.644  45.119  -3.776  1.00 26.04           C
ATOM    406  O   ALA    23     -21.590  45.756  -3.360  1.00 22.48           O
ATOM    408  N   ILE    24     -20.612  44.639  -5.014  1.00 25.86           N
ATOM    409  CA  ILE    24     -21.755  44.832  -5.895  1.00 27.15           C
ATOM    411  CB  ILE    24     -21.344  45.044  -7.374  1.00 28.18           C
ATOM    413  CG1 ILE    24     -20.761  43.768  -7.966  1.00 23.99           C
ATOM    416  CD1 ILE    24     -20.472  43.872  -9.443  1.00 35.51           C
ATOM    420  CG2 ILE    24     -20.408  46.213  -7.489  1.00 34.25           C
ATOM    424  C   ILE    24     -22.790  43.706  -5.793  1.00 28.62           C
ATOM    425  O   ILE    24     -23.850  43.801  -6.384  1.00 26.67           O
ATOM    427  N   ASP    25     -22.498  42.646  -5.046  1.00 25.41           N
ATOM    428  CA  ASP    25     -23.433  41.566  -4.884  1.00 26.94           C
ATOM    430  CB  ASP    25     -22.726  40.350  -4.319  1.00 26.56           C
ATOM    433  CG  ASP    25     -23.578  39.107  -4.362  1.00 23.90           C
ATOM    434  OD1 ASP    25     -24.730  39.106  -3.846  1.00 26.48           O
ATOM    435  OD2 ASP    25     -23.072  38.101  -4.865  1.00 25.65           O
ATOM    436  C   ASP    25     -24.552  42.053  -3.944  1.00 28.65           C
ATOM    437  O   ASP    25     -24.284  42.520  -2.852  1.00 22.14           O
ATOM    439  N   LYS    26     -25.805  41.969  -4.394  1.00 30.84           N
ATOM    440  CA  LYS    26     -26.972  42.460  -3.624  1.00 30.71           C
ATOM    442  CB  LYS    26     -28.269  42.264  -4.436  1.00 33.89           C
ATOM    445  CG  LYS    26     -28.511  43.357  -5.458  1.00 44.49           C
ATOM    451  C   LYS    26     -27.110  41.822  -2.229  1.00 20.07           C
ATOM    452  O   LYS    26     -27.539  42.461  -1.284  1.00 26.43           O
ATOM    454  N   ARG    27     -26.680  40.589  -2.087  1.00 21.15           N
ATOM    455  CA  ARG    27     -26.707  39.913  -0.798  1.00 22.60           C
ATOM    457  CB  ARG    27     -26.242  38.480  -0.963  1.00 25.57           C
ATOM    460  CG  ARG    27     -27.146  37.636  -1.841  1.00 27.66           C
ATOM    463  CD  ARG    27     -26.556  36.286  -2.013  1.00 23.29           C
ATOM    466  NE  ARG    27     -25.338  36.340  -2.817  1.00 26.58           N
ATOM    468  CZ  ARG    27     -24.476  35.332  -2.941  1.00 23.01           C
ATOM    469  NH1 ARG    27     -24.685  34.189  -2.338  1.00 28.51           N
ATOM    472  NH2 ARG    27     -23.403  35.463  -3.696  1.00 28.09           N
ATOM    475  C   ARG    27     -25.817  40.557   0.265  1.00 24.98           C
ATOM    476  O   ARG    27     -26.053  40.397   1.473  1.00 25.35           O
ATOM    478  N   PHE    28     -24.801  41.282  -0.186  1.00 21.49           N
ATOM    479  CA  PHE    28     -23.726  41.741   0.688  1.00 23.72           C
ATOM    481  CB  PHE    28     -22.367  41.350   0.071  1.00 18.92           C
ATOM    484  CG  PHE    28     -22.222  39.873  -0.238  1.00 22.49           C
ATOM    485  CD1 PHE    28     -22.890  38.896   0.509  1.00 18.05           C
ATOM    487  CE1 PHE    28     -22.755  37.560   0.217  1.00 23.57           C
ATOM    489  CZ  PHE    28     -21.918  37.162  -0.818  1.00 19.66           C
ATOM    491  CE2 PHE    28     -21.237  38.120  -1.551  1.00 19.19           C
ATOM    493  CD2 PHE    28     -21.387  39.456  -1.252  1.00 20.61           C
ATOM    495  C   PHE    28     -23.809  43.225   0.963  1.00 20.64           C
ATOM    496  O   PHE    28     -22.922  43.802   1.621  1.00 21.40           O
ATOM    498  N   ARG    29     -24.903  43.860   0.528  1.00 25.62           N
ATOM    499  CA  ARG    29     -25.106  45.308   0.727  1.00 25.06           C
ATOM    501  CB  ARG    29     -26.492  45.749   0.199  1.00 28.09           C
ATOM    504  CG  ARG    29     -26.750  47.252   0.234  1.00 35.00           C
ATOM    507  CD  ARG    29     -28.236  47.617   0.028  1.00 56.20           C
ATOM    510  NE  ARG    29     -29.158  46.670   0.671  1.00 80.68           N
ATOM    512  CZ  ARG    29     -29.425  46.591   1.982  1.00 79.44           C
ATOM    513  NH1 ARG    29     -28.846  47.409   2.863  1.00 66.15           N
ATOM    516  NH2 ARG    29     -30.277  45.662   2.420  1.00 79.04           N
ATOM    519  C   ARG    29     -24.931  45.753   2.180  1.00 20.06           C
ATOM    520  O   ARG    29     -24.355  46.816   2.424  1.00 26.41           O
ATOM    522  N   VAL    30     -25.391  44.932   3.117  1.00 27.21           N
ATOM    523  CA  VAL    30     -25.289  45.215   4.553  1.00 33.63           C
ATOM    525  CB  VAL    30     -26.019  44.115   5.436  1.00 38.16           C
ATOM    527  CG1 VAL    30     -25.513  42.687   5.162  1.00 30.77           C
ATOM    531  CG2 VAL    30     -25.887  44.414   6.918  1.00 51.45           C
ATOM    535  C   VAL    30     -23.825  45.365   5.002  1.00 33.95           C
ATOM    536  O   VAL    30     -23.536  46.052   5.976  1.00 28.60           O
ATOM    538  N   PHE    31     -22.908  44.747   4.262  1.00 27.31           N
ATOM    539  CA  PHE    31     -21.483  44.731   4.632  1.00 23.37           C
ATOM    541  CB  PHE    31     -20.917  43.326   4.423  1.00 24.67           C
ATOM    544  CG  PHE    31     -21.743  42.236   5.027  1.00 23.53           C
ATOM    545  CD1 PHE    31     -21.987  42.193   6.401  1.00 24.92           C
ATOM    547  CE1 PHE    31     -22.759  41.189   6.950  1.00 34.33           C
ATOM    549  CZ  PHE    31     -23.268  40.181   6.142  1.00 26.48           C
ATOM    551  CE2 PHE    31     -23.027  40.198   4.778  1.00 23.80           C
ATOM    553  CD2 PHE    31     -22.274  41.225   4.222  1.00 23.54           C
ATOM    555  C   PHE    31     -20.667  45.756   3.856  1.00 25.64           C
ATOM    556  O   PHE    31     -19.440  45.777   3.960  1.00 24.17           O
ATOM    558  N   THR    32     -21.344  46.619   3.093  1.00 24.94           N
ATOM    559  CA  THR    32     -20.680  47.593   2.255  1.00 23.72           C
ATOM    561  CB  THR    32     -21.469  47.932   0.964  1.00 31.83           C
ATOM    563  OG1 THR    32     -22.742  48.526   1.288  1.00 32.27           O
ATOM    565  CG2 THR    32     -21.633  46.678   0.069  1.00 22.27           C
ATOM    569  C   THR    32     -20.378  48.901   3.005  1.00 29.48           C
ATOM    570  O   THR    32     -19.567  49.691   2.546  1.00 30.50           O
ATOM    572  N   LYS    33     -21.018  49.116   4.153  1.00 29.86           N
ATOM    573  CA  LYS    33     -20.827  50.362   4.910  1.00 35.76           C
ATOM    575  CB  LYS    33     -22.004  51.342   4.691  1.00 36.32           C
ATOM    578  CG  LYS    33     -22.005  52.062   3.342  1.00 51.13           C
ATOM    581  CD  LYS    33     -23.340  52.779   3.070  1.00 45.23           C
ATOM    586  C   LYS    33     -20.703  50.066   6.387  1.00 30.75           C
ATOM    587  O   LYS    33     -21.211  49.038   6.877  1.00 34.04           O
ATOM    589  N   PRO    34     -20.022  50.975   7.124  1.00 40.34           N
ATOM    590  CA  PRO    34     -20.024  50.887   8.573  1.00 43.78           C
ATOM    592  CB  PRO    34     -19.289  52.160   9.007  1.00 44.37           C
ATOM    595  CG  PRO    34     -18.458  52.547   7.868  1.00 40.69           C
ATOM    598  CD  PRO    34     -19.251  52.142   6.652  1.00 39.52           C
ATOM    601  C   PRO    34     -21.445  50.906   9.117  1.00 46.49           C
ATOM    602  O   PRO    34     -22.348  51.411   8.462  1.00 46.86           O
ATOM    603  N   VAL    35     -21.629  50.357  10.306  1.00 52.73           N
ATOM    604  CA  VAL    35     -22.905  50.435  11.002  1.00 56.02           C
ATOM    606  CB  VAL    35     -22.963  49.408  12.141  1.00 52.91           C
ATOM    608  CG1 VAL    35     -22.966  47.996  11.569  1.00 47.77           C
ATOM    612  CG2 VAL    35     -24.191  49.658  13.016  1.00 45.00           C
ATOM    616  C   VAL    35     -23.139  51.853  11.562  1.00 63.10           C
ATOM    617  O   VAL    35     -22.258  52.435  12.205  1.00 67.79           O
ATOM    619  N   ASP    36     -24.333  52.394  11.320  1.00 66.89           N
ATOM    620  CA  ASP    36     -24.676  53.763  11.725  1.00 68.61           C
ATOM    622  CB  ASP    36     -25.929  54.218  10.964  1.00 70.39           C
ATOM    625  CG  ASP    36     -26.175  55.714  11.064  1.00 77.61           C
ATOM    626  OD1 ASP    36     -25.201  56.485  11.219  1.00 70.69           O
ATOM    627  OD2 ASP    36     -27.355  56.117  10.971  1.00 90.64           O
ATOM    628  C   ASP    36     -24.898  53.861  13.254  1.00 67.11           C
ATOM    629  O   ASP    36     -25.795  53.199  13.800  1.00 56.69           O
ATOM    631  N   PRO    37     -24.081  54.685  13.951  1.00 70.78           N
ATOM    632  CA  PRO    37     -24.197  54.744  15.420  1.00 75.96           C
ATOM    634  CB  PRO    37     -23.059  55.691  15.834  1.00 75.72           C
ATOM    637  CG  PRO    37     -22.765  56.499  14.625  1.00 71.83           C
ATOM    640  CD  PRO    37     -23.059  55.621  13.443  1.00 67.24           C
ATOM    643  C   PRO    37     -25.552  55.273  15.901  1.00 80.35           C
ATOM    644  O   PRO    37     -25.932  55.035  17.050  1.00 83.21           O
ATOM    645  N   ASP    38     -26.266  55.976  15.023  1.00 83.08           N
ATOM    646  CA  ASP    38     -27.612  56.454  15.320  1.00 85.90           C
ATOM    648  CB  ASP    38     -28.032  57.549  14.332  1.00 86.22           C
ATOM    651  CG  ASP    38     -26.946  58.600  14.122  1.00 91.26           C
ATOM    652  OD1 ASP    38     -26.291  59.000  15.112  1.00 80.39           O
ATOM    653  OD2 ASP    38     -26.747  59.019  12.960  1.00 95.27           O
ATOM    654  C   ASP    38     -28.582  55.275  15.258  1.00 86.84           C
ATOM    655  O   ASP    38     -29.307  55.008  16.220  1.00 87.15           O
ATOM    657  N   GLU    39     -28.574  54.568  14.127  1.00 85.88           N
ATOM    658  CA  GLU    39     -29.421  53.389  13.941  1.00 84.58           C
ATOM    660  CB  GLU    39     -29.302  52.861  12.505  1.00 83.92           C
ATOM    667  C   GLU    39     -29.085  52.284  14.956  1.00 84.18           C
ATOM    668  O   GLU    39     -29.990  51.719  15.580  1.00 83.93           O
ATOM    670  N   VAL    40     -27.791  51.994  15.127  1.00 82.97           N
ATOM    671  CA  VAL    40     -27.326  50.952  16.059  1.00 79.76           C
ATOM    673  CB  VAL    40     -26.710  49.752  15.311  1.00 77.63           C
ATOM    675  CG1 VAL    40     -26.842  48.498  16.145  1.00 78.57           C
ATOM    679  CG2 VAL    40     -27.387  49.554  13.963  1.00 78.81           C
ATOM    683  C   VAL    40     -26.291  51.535  17.035  1.00 78.94           C
ATOM    684  O   VAL    40     -25.088  51.526  16.748  1.00 74.58           O
ATOM    686  N   PRO    41     -26.760  52.045  18.194  1.00 78.72           N
ATOM    687  CA  PRO    41     -25.885  52.767  19.130  1.00 75.46           C
ATOM    689  CB  PRO    41     -26.876  53.520  20.018  1.00 76.25           C
ATOM    692  CG  PRO    41     -28.089  52.638  20.045  1.00 80.48           C
ATOM    695  CD  PRO    41     -28.127  51.890  18.730  1.00 78.09           C
ATOM    698  C   PRO    41     -24.988  51.852  19.962  1.00 69.89           C
ATOM    699  O   PRO    41     -23.862  52.235  20.284  1.00 71.29           O
ATOM    700  N   ASP    42     -25.477  50.655  20.285  1.00 64.93           N
ATOM    701  CA  ASP    42     -24.691  49.667  21.019  1.00 63.01           C
ATOM    703  CB  ASP    42     -25.616  48.712  21.801  1.00 65.05           C
ATOM    706  CG  ASP    42     -26.381  47.740  20.897  1.00 71.38           C
ATOM    707  OD1 ASP    42     -26.382  46.515  21.186  1.00 60.91           O
ATOM    708  OD2 ASP    42     -26.976  48.203  19.898  1.00 69.09           O
ATOM    709  C   ASP    42     -23.718  48.855  20.136  1.00 59.52           C
ATOM    710  O   ASP    42     -23.081  47.928  20.638  1.00 59.30           O
ATOM    712  N   TYR    43     -23.594  49.186  18.846  1.00 56.70           N
ATOM    713  CA  TYR    43     -22.720  48.402  17.952  1.00 54.71           C
ATOM    715  CB  TYR    43     -22.915  48.743  16.459  1.00 55.68           C
ATOM    718  CG  TYR    43     -22.255  47.707  15.545  1.00 45.79           C
ATOM    719  CD1 TYR    43     -22.908  46.519  15.245  1.00 50.75           C
ATOM    721  CE1 TYR    43     -22.322  45.546  14.436  1.00 42.58           C
ATOM    723  CZ  TYR    43     -21.059  45.744  13.920  1.00 34.68           C
ATOM    724  OH  TYR    43     -20.527  44.734  13.135  1.00 39.12           O
ATOM    726  CE2 TYR    43     -20.356  46.913  14.209  1.00 37.57           C
ATOM    728  CD2 TYR    43     -20.960  47.892  15.032  1.00 43.68           C
ATOM    730  C   TYR    43     -21.254  48.600  18.320  1.00 54.18           C
ATOM    731  O   TYR    43     -20.523  47.623  18.531  1.00 48.20           O
ATOM    733  N   VAL    44     -20.847  49.871  18.391  1.00 52.45           N
ATOM    734  CA  VAL    44     -19.454  50.239  18.637  1.00 55.94           C
ATOM    736  CB  VAL    44     -19.192  51.763  18.333  1.00 58.13           C
ATOM    738  CG1 VAL    44     -18.220  52.399  19.327  1.00 58.75           C
ATOM    742  CG2 VAL    44     -18.684  51.920  16.908  1.00 47.76           C
ATOM    746  C   VAL    44     -18.945  49.796  20.025  1.00 50.89           C
ATOM    747  O   VAL    44     -17.731  49.688  20.217  1.00 47.72           O
ATOM    749  N   THR    45     -19.866  49.487  20.947  1.00 49.61           N
ATOM    750  CA  THR    45     -19.520  48.909  22.259  1.00 48.11           C
ATOM    752  CB  THR    45     -20.445  49.461  23.395  1.00 52.57           C
ATOM    754  OG1 THR    45     -21.668  48.713  23.469  1.00 60.63           O
ATOM    756  CG2 THR    45     -20.767  50.929  23.165  1.00 43.51           C
ATOM    760  C   THR    45     -19.511  47.359  22.271  1.00 46.13           C
ATOM    761  O   THR    45     -18.704  46.746  22.995  1.00 44.43           O
ATOM    763  N   VAL    46     -20.385  46.723  21.480  1.00 42.70           N
ATOM    764  CA  VAL    46     -20.404  45.243  21.371  1.00 40.23           C
ATOM    766  CB  VAL    46     -21.778  44.712  20.870  1.00 44.94           C
ATOM    768  CG1 VAL    46     -21.747  43.180  20.691  1.00 46.94           C
ATOM    772  CG2 VAL    46     -22.893  45.133  21.829  1.00 44.05           C
ATOM    776  C   VAL    46     -19.287  44.702  20.453  1.00 36.60           C
ATOM    777  O   VAL    46     -18.654  43.673  20.744  1.00 38.38           O
ATOM    779  N   ILE    47     -19.065  45.396  19.341  1.00 30.45           N
ATOM    780  CA  ILE    47     -18.111  44.965  18.328  1.00 32.39           C
ATOM    782  CB  ILE    47     -18.734  44.983  16.890  1.00 35.54           C
ATOM    784  CG1 ILE    47     -19.956  44.028  16.779  1.00 27.28           C
ATOM    787  CD1 ILE    47     -19.707  42.525  17.097  1.00 23.48           C
ATOM    791  CG2 ILE    47     -17.682  44.619  15.842  1.00 25.81           C
ATOM    795  C   ILE    47     -16.864  45.865  18.401  1.00 33.66           C
ATOM    796  O   ILE    47     -16.883  47.050  18.031  1.00 36.10           O
ATOM    798  N   LYS    48     -15.798  45.270  18.901  1.00 33.32           N
ATOM    799  CA  LYS    48     -14.550  45.963  19.207  1.00 31.72           C
ATOM    801  CB  LYS    48     -13.689  45.068  20.118  1.00 31.65           C
ATOM    804  CG  LYS    48     -14.387  44.729  21.453  1.00 39.44           C
ATOM    807  CD  LYS    48     -14.892  46.002  22.158  1.00 43.13           C
ATOM    810  CE  LYS    48     -15.676  45.714  23.404  1.00 47.78           C
ATOM    813  NZ  LYS    48     -16.182  47.011  23.956  1.00 44.33           N
ATOM    817  C   LYS    48     -13.751  46.353  17.977  1.00 33.20           C
ATOM    818  O   LYS    48     -13.014  47.339  18.022  1.00 27.97           O
ATOM    820  N   GLN    49     -13.914  45.583  16.895  1.00 30.48           N
ATOM    821  CA  GLN    49     -13.217  45.843  15.662  1.00 32.30           C
ATOM    823  CB  GLN    49     -12.049  44.864  15.505  1.00 29.28           C
ATOM    826  CG  GLN    49     -11.013  45.463  14.632  1.00 39.19           C
ATOM    829  CD  GLN    49      -9.769  44.633  14.478  1.00 36.19           C
ATOM    830  OE1 GLN    49      -8.860  45.072  13.783  1.00 40.56           O
ATOM    831  NE2 GLN    49      -9.711  43.427  15.107  1.00 33.13           N
ATOM    834  C   GLN    49     -14.181  45.755  14.477  1.00 28.07           C
ATOM    835  O   GLN    49     -14.234  44.724  13.793  1.00 28.15           O
ATOM    837  N   PRO    50     -14.949  46.835  14.245  1.00 29.22           N
ATOM    838  CA  PRO    50     -15.875  46.936  13.125  1.00 27.66           C
ATOM    840  CB  PRO    50     -16.369  48.378  13.211  1.00 30.49           C
ATOM    843  CG  PRO    50     -16.195  48.758  14.591  1.00 36.52           C
ATOM    846  CD  PRO    50     -15.042  48.013  15.122  1.00 26.98           C
ATOM    849  C   PRO    50     -15.126  46.763  11.815  1.00 31.26           C
ATOM    850  O   PRO    50     -14.027  47.278  11.679  1.00 23.71           O
ATOM    851  N   MET    51     -15.696  46.044  10.861  1.00 21.15           N
ATOM    852  CA  MET    51     -15.055  45.935   9.533  1.00 22.60           C
ATOM    854  CB  MET    51     -14.158  44.700   9.485  1.00 21.22           C
ATOM    857  CG  MET    51     -13.218  44.584   8.232  1.00 20.96           C
ATOM    860  SD  MET    51     -12.243  46.051   7.847  1.00 26.36           S
ATOM    861  CE  MET    51     -11.246  46.176   9.359  1.00 22.19           C
ATOM    865  C   MET    51     -16.166  45.867   8.493  1.00 23.15           C
ATOM    866  O   MET    51     -17.221  45.344   8.772  1.00 23.61           O
ATOM    868  N   ASP    52     -15.924  46.436   7.328  1.00 24.76           N
ATOM    869  CA  ASP    52     -16.879  46.392   6.231  1.00 27.19           C
ATOM    871  CB  ASP    52     -17.922  47.511   6.360  1.00 26.13           C
ATOM    874  CG  ASP    52     -17.330  48.890   6.169  1.00 29.38           C
ATOM    875  OD1 ASP    52     -16.775  49.471   7.125  1.00 45.75           O
ATOM    876  OD2 ASP    52     -17.407  49.400   5.059  1.00 31.49           O
ATOM    877  C   ASP    52     -16.084  46.513   4.949  1.00 24.29           C
ATOM    878  O   ASP    52     -14.881  46.799   4.992  1.00 20.17           O
ATOM    880  N   LEU    53     -16.745  46.316   3.812  1.00 19.93           N
ATOM    881  CA  LEU    53     -16.042  46.295   2.513  1.00 22.93           C
ATOM    883  CB  LEU    53     -16.947  45.717   1.416  1.00 23.99           C
ATOM    886  CG  LEU    53     -17.426  44.279   1.629  1.00 25.34           C
ATOM    888  CD1 LEU    53     -18.492  43.886   0.568  1.00 17.36           C
ATOM    892  CD2 LEU    53     -16.274  43.274   1.667  1.00 17.56           C
ATOM    896  C   LEU    53     -15.496  47.665   2.091  1.00 25.54           C
ATOM    897  O   LEU    53     -14.483  47.745   1.360  1.00 19.91           O
ATOM    899  N   SER    54     -16.118  48.753   2.553  1.00 28.29           N
ATOM    900  CA  SER    54     -15.543  50.087   2.272  1.00 25.79           C
ATOM    902  CB  SER    54     -16.504  51.211   2.684  0.50 23.77           C
ATOM    908  OG  SER    54     -16.659  51.265   4.097  0.50 28.65           O
ATOM    912  C   SER    54     -14.227  50.281   3.014  1.00 20.81           C
ATOM    913  O   SER    54     -13.287  50.890   2.484  1.00 25.29           O
ATOM    915  N   SER    55     -14.176  49.791   4.241  1.00 23.85           N
ATOM    916  CA  SER    55     -12.940  49.887   5.038  1.00 28.64           C
ATOM    918  CB  SER    55     -13.218  49.548   6.498  1.00 26.98           C
ATOM    921  OG  SER    55     -14.248  50.389   7.006  1.00 35.24           O
ATOM    923  C   SER    55     -11.851  48.986   4.446  1.00 24.61           C
ATOM    924  O   SER    55     -10.673  49.347   4.432  1.00 22.37           O
ATOM    926  N   VAL    56     -12.257  47.833   3.912  1.00 22.80           N
ATOM    927  CA  VAL    56     -11.319  46.945   3.189  1.00 18.59           C
ATOM    929  CB  VAL    56     -11.984  45.581   2.798  1.00 17.04           C
ATOM    931  CG1 VAL    56     -11.131  44.796   1.802  1.00 18.98           C
ATOM    935  CG2 VAL    56     -12.279  44.718   4.064  1.00 19.48           C
ATOM    939  C   VAL    56     -10.697  47.650   1.997  1.00 17.03           C
ATOM    940  O   VAL    56      -9.478  47.572   1.825  1.00 19.42           O
ATOM    942  N   ILE    57     -11.496  48.352   1.177  1.00 17.41           N
ATOM    943  CA  ILE    57     -10.955  49.092   0.032  1.00 20.50           C
ATOM    945  CB  ILE    57     -12.062  49.736  -0.876  1.00 23.10           C
ATOM    947  CG1 ILE    57     -12.835  48.672  -1.676  1.00 22.23           C
ATOM    950  CD1 ILE    57     -12.019  48.001  -2.756  1.00 28.19           C
ATOM    954  CG2 ILE    57     -11.454  50.774  -1.819  1.00 25.28           C
ATOM    958  C   ILE    57      -9.960  50.162   0.503  1.00 19.54           C
ATOM    959  O   ILE    57      -8.878  50.288  -0.056  1.00 17.87           O
ATOM    961  N   SER    58     -10.317  50.912   1.539  1.00 23.61           N
ATOM    962  CA  SER    58      -9.392  51.897   2.129  1.00 21.37           C
ATOM    964  CB  SER    58     -10.054  52.624   3.304  1.00 26.17           C
ATOM    967  OG  SER    58     -11.054  53.483   2.846  1.00 29.50           O
ATOM    969  C   SER    58      -8.045  51.272   2.584  1.00 18.72           C
ATOM    970  O   SER    58      -6.973  51.822   2.297  1.00 21.54           O
ATOM    972  N   LYS    59      -8.108  50.123   3.249  1.00 20.54           N
ATOM    973  CA  LYS    59      -6.924  49.433   3.712  1.00 16.63           C
ATOM    975  CB  LYS    59      -7.293  48.329   4.700  1.00 17.74           C
ATOM    978  CG  LYS    59      -7.723  48.901   6.077  1.00 21.37           C
ATOM    981  CD  LYS    59      -8.114  47.798   7.067  1.00 19.34           C
ATOM    984  CE  LYS    59      -6.893  47.119   7.670  1.00 20.09           C
ATOM    987  NZ  LYS    59      -7.200  46.047   8.619  1.00 19.43           N
ATOM    991  C   LYS    59      -6.034  48.918   2.559  1.00 15.54           C
ATOM    992  O   LYS    59      -4.816  48.973   2.659  1.00 16.76           O
ATOM    994  N   ILE    60      -6.643  48.453   1.467  1.00 17.14           N
ATOM    995  CA  ILE    60      -5.871  48.056   0.280  1.00 17.12           C
ATOM    997  CB  ILE    60      -6.783  47.630  -0.911  1.00 18.90           C
ATOM    999  CG1 ILE    60      -7.619  46.371  -0.546  1.00 20.67           C
ATOM   1002  CD1 ILE    60      -8.756  46.014  -1.549  1.00 16.51           C
ATOM   1006  CG2 ILE    60      -5.914  47.410  -2.191  1.00 15.27           C
ATOM   1010  C   ILE    60      -4.983  49.238  -0.173  1.00 16.88           C
ATOM   1011  O   ILE    60      -3.762  49.112  -0.345  1.00 18.43           O
ATOM   1013  N   ASP    61      -5.640  50.373  -0.349  1.00 18.18           N
ATOM   1014  CA  ASP    61      -5.022  51.581  -0.838  1.00 21.27           C
ATOM   1016  CB  ASP    61      -6.111  52.614  -1.131  1.00 20.70           C
ATOM   1019  CG  ASP    61      -6.998  52.220  -2.305  1.00 32.84           C
ATOM   1020  OD1 ASP    61      -6.667  51.259  -3.026  1.00 27.00           O
ATOM   1021  OD2 ASP    61      -8.033  52.884  -2.509  1.00 25.46           O
ATOM   1022  C   ASP    61      -3.976  52.136   0.138  1.00 24.20           C
ATOM   1023  O   ASP    61      -2.950  52.691  -0.290  1.00 21.34           O
ATOM   1025  N   LEU    62      -4.190  51.924   1.436  1.00 22.90           N
ATOM   1026  CA  LEU    62      -3.176  52.248   2.457  1.00 23.80           C
ATOM   1028  CB  LEU    62      -3.850  52.442   3.827  1.00 18.19           C
ATOM   1031  CG  LEU    62      -4.757  53.639   4.064  1.00 23.24           C
ATOM   1033  CD1 LEU    62      -5.442  53.427   5.439  1.00 20.00           C
ATOM   1037  CD2 LEU    62      -3.927  54.941   4.004  1.00 20.71           C
ATOM   1041  C   LEU    62      -2.071  51.194   2.585  1.00 24.78           C
ATOM   1042  O   LEU    62      -1.231  51.288   3.456  1.00 23.89           O
ATOM   1044  N   HIS    63      -2.050  50.185   1.712  1.00 21.03           N
ATOM   1045  CA  HIS    63      -1.018  49.156   1.698  1.00 18.83           C
ATOM   1047  CB  HIS    63       0.395  49.728   1.399  1.00 22.34           C
ATOM   1050  CG  HIS    63       0.488  50.497   0.129  1.00 22.10           C
ATOM   1051  ND1 HIS    63       1.698  50.841  -0.426  1.00 25.42           N
ATOM   1053  CE1 HIS    63       1.486  51.534  -1.530  1.00 20.87           C
ATOM   1055  NE2 HIS    63       0.184  51.589  -1.748  1.00 27.01           N
ATOM   1057  CD2 HIS    63      -0.462  50.954  -0.722  1.00 27.64           C
ATOM   1059  C   HIS    63      -0.971  48.336   2.982  1.00 21.67           C
ATOM   1060  O   HIS    63       0.070  47.885   3.388  1.00 22.07           O
ATOM   1062  N   LYS    64      -2.122  48.098   3.586  1.00 22.14           N
ATOM   1063  CA  LYS    64      -2.188  47.316   4.796  1.00 21.91           C
ATOM   1065  CB  LYS    64      -3.440  47.663   5.583  1.00 19.04           C
ATOM   1068  CG  LYS    64      -3.536  49.112   5.934  1.00 24.59           C
ATOM   1071  CD  LYS    64      -2.562  49.504   6.961  1.00 30.67           C
ATOM   1074  CE  LYS    64      -2.888  50.916   7.485  1.00 48.26           C
ATOM   1077  NZ  LYS    64      -2.018  51.276   8.627  1.00 47.20           N
ATOM   1081  C   LYS    64      -2.194  45.831   4.565  1.00 23.75           C
ATOM   1082  O   LYS    64      -1.981  45.077   5.507  1.00 18.75           O
ATOM   1084  N   TYR    65      -2.463  45.407   3.337  1.00 21.37           N
ATOM   1085  CA  TYR    65      -2.490  43.990   3.044  1.00 17.52           C
ATOM   1087  CB  TYR    65      -3.788  43.577   2.327  1.00 15.32           C
ATOM   1090  CG  TYR    65      -5.083  43.992   3.050  1.00 16.36           C
ATOM   1091  CD1 TYR    65      -5.359  43.565   4.331  1.00 19.84           C
ATOM   1093  CE1 TYR    65      -6.552  43.924   4.968  1.00 19.40           C
ATOM   1095  CZ  TYR    65      -7.501  44.701   4.296  1.00 15.48           C
ATOM   1096  OH  TYR    65      -8.679  45.058   4.902  1.00 18.10           O
ATOM   1098  CE2 TYR    65      -7.266  45.119   3.033  1.00 17.29           C
ATOM   1100  CD2 TYR    65      -6.057  44.751   2.395  1.00 16.43           C
ATOM   1102  C   TYR    65      -1.301  43.672   2.162  1.00 21.48           C
ATOM   1103  O   TYR    65      -1.258  44.066   1.007  1.00 22.79           O
ATOM   1105  N   LEU    66      -0.346  42.935   2.713  1.00 19.79           N
ATOM   1106  CA  LEU    66       0.847  42.523   1.958  1.00 23.12           C
ATOM   1108  CB  LEU    66       2.089  42.712   2.836  1.00 25.01           C
ATOM   1111  CG  LEU    66       2.439  44.137   3.294  1.00 32.61           C
ATOM   1113  CD1 LEU    66       3.862  44.119   3.908  1.00 37.41           C
ATOM   1117  CD2 LEU    66       2.368  45.115   2.195  1.00 30.09           C
ATOM   1121  C   LEU    66       0.743  41.062   1.481  1.00 22.04           C
ATOM   1122  O   LEU    66       1.557  40.601   0.688  1.00 21.03           O
ATOM   1124  N   THR    67      -0.256  40.344   1.990  1.00 20.44           N
ATOM   1125  CA  THR    67      -0.543  38.972   1.589  1.00 19.04           C
ATOM   1127  CB  THR    67       0.039  37.928   2.563  1.00 18.54           C
ATOM   1129  OG1 THR    67      -0.742  37.899   3.757  1.00 21.70           O
ATOM   1131  CG2 THR    67       1.506  38.214   2.937  1.00 20.92           C
ATOM   1135  C   THR    67      -2.077  38.771   1.534  1.00 20.22           C
ATOM   1136  O   THR    67      -2.848  39.552   2.115  1.00 18.31           O
ATOM   1138  N   VAL    68      -2.518  37.724   0.835  1.00 16.57           N
ATOM   1139  CA  VAL    68      -3.937  37.398   0.800  1.00 19.83           C
ATOM   1141  CB  VAL    68      -4.303  36.338  -0.283  1.00 19.37           C
ATOM   1143  CG1 VAL    68      -5.768  36.553  -0.786  1.00 24.52           C
ATOM   1147  CG2 VAL    68      -4.149  34.918   0.242  1.00 25.02           C
ATOM   1151  C   VAL    68      -4.424  36.961   2.180  1.00 22.55           C
ATOM   1152  O   VAL    68      -5.586  37.163   2.527  1.00 18.78           O
ATOM   1154  N   LYS    69      -3.550  36.353   2.984  1.00 22.17           N
ATOM   1155  CA  LYS    69      -3.917  36.039   4.372  1.00 26.13           C
ATOM   1157  CB  LYS    69      -2.773  35.296   5.084  1.00 33.70           C
ATOM   1160  CG  LYS    69      -2.648  33.854   4.646  1.00 34.43           C
ATOM   1163  CD  LYS    69      -1.703  33.079   5.573  1.00 45.50           C
ATOM   1168  C   LYS    69      -4.365  37.232   5.216  1.00 21.88           C
ATOM   1169  O   LYS    69      -5.357  37.131   5.952  1.00 23.88           O
ATOM   1171  N   ASP    70      -3.647  38.346   5.089  1.00 19.84           N
ATOM   1172  CA  ASP    70      -3.959  39.615   5.762  1.00 24.88           C
ATOM   1174  CB  ASP    70      -2.992  40.738   5.326  1.00 26.51           C
ATOM   1177  CG  ASP    70      -1.541  40.593   5.828  1.00 34.56           C
ATOM   1178  OD1 ASP    70      -1.244  39.787   6.721  1.00 27.92           O
ATOM   1179  OD2 ASP    70      -0.694  41.379   5.313  1.00 34.87           O
ATOM   1180  C   ASP    70      -5.381  40.087   5.352  1.00 27.16           C
ATOM   1181  O   ASP    70      -6.205  40.493   6.187  1.00 20.43           O
ATOM   1183  N   TYR    71      -5.625  40.070   4.045  1.00 23.04           N
ATOM   1184  CA  TYR    71      -6.940  40.435   3.471  1.00 17.48           C
ATOM   1186  CB  TYR    71      -6.849  40.328   1.955  1.00 19.62           C
ATOM   1189  CG  TYR    71      -8.147  40.516   1.226  1.00 15.66           C
ATOM   1190  CD1 TYR    71      -8.624  41.803   0.949  1.00 15.77           C
ATOM   1192  CE1 TYR    71      -9.795  41.991   0.265  1.00 17.42           C
ATOM   1194  CZ  TYR    71     -10.536  40.878  -0.163  1.00 18.81           C
ATOM   1195  OH  TYR    71     -11.681  41.085  -0.870  1.00 16.07           O
ATOM   1197  CE2 TYR    71     -10.079  39.593   0.061  1.00 15.40           C
ATOM   1199  CD2 TYR    71      -8.886  39.406   0.764  1.00 17.77           C
ATOM   1201  C   TYR    71      -8.074  39.536   3.979  1.00 17.40           C
ATOM   1202  O   TYR    71      -9.115  40.032   4.445  1.00 18.24           O
ATOM   1204  N   LEU    72      -7.871  38.226   3.892  1.00 18.72           N
ATOM   1205  CA  LEU    72      -8.874  37.252   4.349  1.00 21.15           C
ATOM   1207  CB  LEU    72      -8.512  35.826   3.932  1.00 16.77           C
ATOM   1210  CG  LEU    72      -8.718  35.566   2.443  1.00 25.64           C
ATOM   1212  CD1 LEU    72      -8.040  34.297   2.112  1.00 19.37           C
ATOM   1216  CD2 LEU    72     -10.215  35.535   2.012  1.00 25.53           C
ATOM   1220  C   LEU    72      -9.182  37.340   5.843  1.00 26.45           C
ATOM   1221  O   LEU    72     -10.302  37.066   6.250  1.00 23.04           O
ATOM   1223  N   ARG    73      -8.219  37.790   6.636  1.00 22.93           N
ATOM   1224  CA  ARG    73      -8.434  38.055   8.047  1.00 28.03           C
ATOM   1226  CB  ARG    73      -7.122  38.490   8.726  1.00 31.55           C
ATOM   1229  CG  ARG    73      -7.105  38.285  10.212  1.00 38.49           C
ATOM   1232  CD  ARG    73      -5.699  38.518  10.812  1.00 49.01           C
ATOM   1235  NE  ARG    73      -4.676  37.784  10.065  1.00 44.82           N
ATOM   1237  CZ  ARG    73      -3.669  38.325   9.374  1.00 55.88           C
ATOM   1238  NH1 ARG    73      -3.476  39.648   9.322  1.00 40.38           N
ATOM   1241  NH2 ARG    73      -2.831  37.518   8.726  1.00 56.97           N
ATOM   1244  C   ARG    73      -9.524  39.098   8.278  1.00 18.44           C
ATOM   1245  O   ARG    73     -10.365  38.890   9.124  1.00 19.51           O
ATOM   1247  N   ASP    74      -9.523  40.171   7.494  1.00 18.76           N
ATOM   1248  CA  ASP    74     -10.571  41.193   7.504  1.00 16.55           C
ATOM   1250  CB  ASP    74     -10.082  42.492   6.874  1.00 19.52           C
ATOM   1253  CG  ASP    74      -9.294  43.326   7.848  1.00 24.75           C
ATOM   1254  OD1 ASP    74      -9.271  42.928   9.020  1.00 20.14           O
ATOM   1255  OD2 ASP    74      -8.719  44.344   7.449  1.00 22.36           O
ATOM   1256  C   ASP    74     -11.916  40.769   6.894  1.00 21.92           C
ATOM   1257  O   ASP    74     -12.975  41.148   7.406  1.00 18.70           O
ATOM   1259  N   ILE    75     -11.886  39.980   5.830  1.00 21.18           N
ATOM   1260  CA  ILE    75     -13.126  39.305   5.348  1.00 20.67           C
ATOM   1262  CB  ILE    75     -12.861  38.455   4.056  1.00 24.95           C
ATOM   1264  CG1 ILE    75     -12.392  39.357   2.884  1.00 19.84           C
ATOM   1267  CD1 ILE    75     -13.271  40.588   2.564  1.00 17.92           C
ATOM   1271  CG2 ILE    75     -14.123  37.542   3.678  1.00 17.77           C
ATOM   1275  C   ILE    75     -13.756  38.436   6.459  1.00 20.07           C
ATOM   1276  O   ILE    75     -14.957  38.520   6.766  1.00 21.18           O
ATOM   1278  N   ASP    76     -12.930  37.612   7.072  1.00 17.12           N
ATOM   1279  CA  ASP    76     -13.336  36.803   8.192  1.00 18.83           C
ATOM   1281  CB  ASP    76     -12.186  35.905   8.657  1.00 22.83           C
ATOM   1284  CG  ASP    76     -12.043  34.652   7.827  1.00 27.23           C
ATOM   1285  OD1 ASP    76     -13.057  34.078   7.372  1.00 31.01           O
ATOM   1286  OD2 ASP    76     -10.909  34.191   7.693  1.00 27.95           O
ATOM   1287  C   ASP    76     -13.899  37.617   9.377  1.00 23.19           C
ATOM   1288  O   ASP    76     -14.831  37.168  10.037  1.00 22.31           O
ATOM   1290  N   LEU    77     -13.351  38.804   9.612  1.00 18.46           N
ATOM   1291  CA  LEU    77     -13.819  39.701  10.637  1.00 21.75           C
ATOM   1293  CB  LEU    77     -12.778  40.796  10.830  1.00 25.24           C
ATOM   1296  CG  LEU    77     -12.948  41.754  12.004  1.00 29.92           C
ATOM   1298  CD1 LEU    77     -13.038  40.979  13.351  1.00 25.12           C
ATOM   1302  CD2 LEU    77     -11.808  42.828  11.972  1.00 29.35           C
ATOM   1306  C   LEU    77     -15.234  40.301  10.317  1.00 28.76           C
ATOM   1307  O   LEU    77     -16.106  40.401  11.187  1.00 24.23           O
ATOM   1309  N   ILE    78     -15.463  40.677   9.065  1.00 25.00           N
ATOM   1310  CA  ILE    78     -16.801  41.067   8.619  1.00 24.14           C
ATOM   1312  CB  ILE    78     -16.846  41.357   7.106  1.00 22.57           C
ATOM   1314  CG1 ILE    78     -15.939  42.551   6.759  1.00 18.05           C
ATOM   1317  CD1 ILE    78     -15.865  42.959   5.251  1.00 17.41           C
ATOM   1321  CG2 ILE    78     -18.325  41.594   6.622  1.00 22.52           C
ATOM   1325  C   ILE    78     -17.788  39.956   8.967  1.00 21.73           C
ATOM   1326  O   ILE    78     -18.855  40.200   9.585  1.00 21.65           O
ATOM   1328  N   CYS    79     -17.439  38.728   8.613  1.00 20.07           N
ATOM   1329  CA  CYS    79     -18.311  37.600   8.882  1.00 23.10           C
ATOM   1331  CB  CYS    79     -17.826  36.354   8.142  1.00 20.26           C
ATOM   1334  SG  CYS    79     -18.872  34.951   8.328  1.00 27.18           S
ATOM   1336  C   CYS    79     -18.495  37.325  10.382  1.00 30.41           C
ATOM   1337  O   CYS    79     -19.635  37.266  10.875  1.00 22.37           O
ATOM   1339  N   SER    80     -17.393  37.181  11.121  1.00 21.91           N
ATOM   1340  CA  SER    80     -17.494  36.878  12.545  1.00 24.30           C
ATOM   1342  CB  SER    80     -16.095  36.547  13.140  1.00 24.35           C
ATOM   1345  OG  SER    80     -15.237  37.672  13.063  1.00 25.08           O
ATOM   1347  C   SER    80     -18.235  37.984  13.349  1.00 18.40           C
ATOM   1348  O   SER    80     -18.966  37.663  14.285  1.00 23.97           O
ATOM   1350  N   ASN    81     -18.040  39.257  13.002  1.00 20.76           N
ATOM   1351  CA  ASN    81     -18.731  40.384  13.628  1.00 23.40           C
ATOM   1353  CB  ASN    81     -18.272  41.726  13.033  1.00 18.65           C
ATOM   1356  CG  ASN    81     -16.891  42.213  13.553  1.00 23.49           C
ATOM   1357  OD1 ASN    81     -16.312  41.626  14.419  1.00 22.48           O
ATOM   1358  ND2 ASN    81     -16.394  43.279  12.976  1.00 20.38           N
ATOM   1361  C   ASN    81     -20.283  40.263  13.424  1.00 31.33           C
ATOM   1362  O   ASN    81     -21.087  40.528  14.334  1.00 26.82           O
ATOM   1364  N   ALA    82     -20.677  39.859  12.217  1.00 25.71           N
ATOM   1365  CA  ALA    82     -22.082  39.664  11.864  1.00 25.53           C
ATOM   1367  CB  ALA    82     -22.259  39.508  10.281  1.00 21.68           C
ATOM   1371  C   ALA    82     -22.675  38.493  12.648  1.00 19.47           C
ATOM   1372  O   ALA    82     -23.782  38.620  13.195  1.00 28.46           O
ATOM   1374  N   LEU    83     -21.945  37.393  12.806  1.00 22.22           N
ATOM   1375  CA  LEU    83     -22.458  36.275  13.567  1.00 23.51           C
ATOM   1377  CB  LEU    83     -21.630  34.996  13.381  1.00 25.32           C
ATOM   1380  CG  LEU    83     -21.284  34.549  11.947  1.00 34.57           C
ATOM   1382  CD1 LEU    83     -20.593  33.216  11.961  1.00 35.58           C
ATOM   1386  CD2 LEU    83     -22.467  34.549  11.013  1.00 26.17           C
ATOM   1390  C   LEU    83     -22.621  36.565  15.064  1.00 29.52           C
ATOM   1391  O   LEU    83     -23.595  36.103  15.672  1.00 26.06           O
ATOM   1393  N   GLU    84     -21.666  37.318  15.619  1.00 32.26           N
ATOM   1394  CA  GLU    84     -21.643  37.710  17.035  1.00 32.94           C
ATOM   1396  CB  GLU    84     -20.292  38.372  17.403  1.00 28.31           C
ATOM   1399  CG  GLU    84     -20.112  38.708  18.919  1.00 46.52           C
ATOM   1402  CD  GLU    84     -19.012  39.774  19.248  1.00 64.97           C
ATOM   1403  OE1 GLU    84     -19.027  40.289  20.394  1.00 62.98           O
ATOM   1404  OE2 GLU    84     -18.146  40.107  18.397  1.00 54.59           O
ATOM   1405  C   GLU    84     -22.775  38.669  17.351  1.00 24.93           C
ATOM   1406  O   GLU    84     -23.505  38.480  18.326  1.00 31.68           O
ATOM   1408  N   TYR    85     -22.917  39.687  16.517  1.00 25.04           N
ATOM   1409  CA  TYR    85     -23.859  40.737  16.750  1.00 31.73           C
ATOM   1411  CB  TYR    85     -23.552  41.964  15.894  1.00 27.37           C
ATOM   1414  CG  TYR    85     -24.285  43.193  16.424  1.00 43.81           C
ATOM   1415  CD1 TYR    85     -23.935  43.754  17.660  1.00 43.60           C
ATOM   1417  CE1 TYR    85     -24.609  44.867  18.169  1.00 51.06           C
ATOM   1419  CZ  TYR    85     -25.656  45.414  17.451  1.00 53.75           C
ATOM   1420  OH  TYR    85     -26.323  46.502  17.953  1.00 59.40           O
ATOM   1422  CE2 TYR    85     -26.032  44.869  16.232  1.00 45.06           C
ATOM   1424  CD2 TYR    85     -25.355  43.757  15.730  1.00 46.35           C
ATOM   1426  C   TYR    85     -25.312  40.326  16.468  1.00 32.29           C
ATOM   1427  O   TYR    85     -26.218  41.016  16.913  1.00 28.58           O
ATOM   1429  N   ASN    86     -25.511  39.244  15.713  1.00 32.89           N
ATOM   1430  CA  ASN    86     -26.859  38.825  15.262  1.00 31.75           C
ATOM   1432  CB  ASN    86     -27.062  39.151  13.773  1.00 32.32           C
ATOM   1435  CG  ASN    86     -26.831  40.612  13.440  1.00 31.15           C
ATOM   1436  OD1 ASN    86     -27.673  41.450  13.688  1.00 30.56           O
ATOM   1437  ND2 ASN    86     -25.687  40.919  12.835  1.00 33.47           N
ATOM   1440  C   ASN    86     -27.014  37.350  15.457  1.00 27.49           C
ATOM   1441  O   ASN    86     -27.161  36.616  14.483  1.00 31.91           O
ATOM   1443  N   PRO    87     -26.979  36.884  16.722  1.00 26.55           N
ATOM   1444  CA  PRO    87     -26.859  35.458  17.020  1.00 26.12           C
ATOM   1446  CB  PRO    87     -26.139  35.465  18.366  1.00 32.64           C
ATOM   1449  CG  PRO    87     -26.617  36.704  19.004  1.00 27.94           C
ATOM   1452  CD  PRO    87     -26.987  37.682  17.965  1.00 31.83           C
ATOM   1455  C   PRO    87     -28.190  34.720  17.191  1.00 23.77           C
ATOM   1456  O   PRO    87     -28.184  33.511  17.376  1.00 31.41           O
ATOM   1457  N   ASP    88     -29.295  35.454  17.077  1.00 29.51           N
ATOM   1458  CA  ASP    88     -30.628  34.995  17.492  1.00 30.57           C
ATOM   1460  CB  ASP    88     -31.499  36.214  17.808  1.00 33.78           C
ATOM   1463  CG  ASP    88     -31.018  36.990  19.037  1.00 44.32           C
ATOM   1464  OD1 ASP    88     -30.049  36.557  19.695  1.00 30.51           O
ATOM   1465  OD2 ASP    88     -31.618  38.042  19.343  1.00 45.37           O
ATOM   1466  C   ASP    88     -31.314  34.154  16.417  1.00 35.10           C
ATOM   1467  O   ASP    88     -30.874  34.159  15.254  1.00 27.40           O
ATOM   1469  N   ARG    89     -32.377  33.435  16.798  1.00 30.45           N
ATOM   1470  CA  ARG    89     -33.120  32.566  15.840  1.00 28.72           C
ATOM   1472  CB  ARG    89     -33.869  31.411  16.551  0.50 33.38           C
ATOM   1478  CG  ARG    89     -35.167  31.777  17.355  0.50 37.37           C
ATOM   1484  CD  ARG    89     -36.517  31.729  16.550  0.50 23.22           C
ATOM   1490  NE  ARG    89     -36.709  30.558  15.702  0.50 14.53           N
ATOM   1494  CZ  ARG    89     -37.431  30.582  14.566  0.50 21.38           C
ATOM   1496  NH1 ARG    89     -37.964  31.725  14.152  0.50 19.03           N
ATOM   1502  NH2 ARG    89     -37.589  29.485  13.816  0.50 13.40           N
ATOM   1508  C   ARG    89     -34.104  33.315  14.959  1.00 26.11           C
ATOM   1509  O   ARG    89     -34.687  32.742  14.036  1.00 29.81           O
ATOM   1511  N   ASP    90     -34.292  34.590  15.208  1.00 23.54           N
ATOM   1512  CA  ASP    90     -35.264  35.315  14.430  1.00 29.60           C
ATOM   1514  CB  ASP    90     -35.570  36.660  15.055  1.00 30.13           C
ATOM   1517  CG  ASP    90     -34.416  37.592  15.029  1.00 38.59           C
ATOM   1518  OD1 ASP    90     -34.440  38.541  14.205  1.00 51.79           O
ATOM   1519  OD2 ASP    90     -33.495  37.374  15.835  1.00 59.04           O
ATOM   1520  C   ASP    90     -34.818  35.489  12.968  1.00 31.35           C
ATOM   1521  O   ASP    90     -33.608  35.485  12.679  1.00 27.12           O
ATOM   1523  N   PRO    91     -35.796  35.658  12.057  1.00 30.02           N
ATOM   1524  CA  PRO    91     -35.509  35.719  10.624  1.00 27.31           C
ATOM   1526  CB  PRO    91     -36.888  35.982   9.996  1.00 31.62           C
ATOM   1529  CG  PRO    91     -37.870  35.529  10.995  1.00 30.59           C
ATOM   1532  CD  PRO    91     -37.249  35.720  12.332  1.00 29.64           C
ATOM   1535  C   PRO    91     -34.517  36.811  10.209  1.00 22.34           C
ATOM   1536  O   PRO    91     -33.705  36.580   9.308  1.00 20.72           O
ATOM   1537  N   GLY    92     -34.594  37.996  10.814  1.00 21.91           N
ATOM   1538  CA  GLY    92     -33.644  39.081  10.479  1.00 27.46           C
ATOM   1541  C   GLY    92     -32.189  38.688  10.774  1.00 28.37           C
ATOM   1542  O   GLY    92     -31.291  38.926   9.959  1.00 26.07           O
ATOM   1544  N   ASP    93     -31.988  38.036  11.921  1.00 29.00           N
ATOM   1545  CA  ASP    93     -30.671  37.565  12.363  1.00 28.59           C
ATOM   1547  CB  ASP    93     -30.706  37.160  13.839  1.00 27.55           C
ATOM   1550  CG  ASP    93     -30.501  38.352  14.797  1.00 29.39           C
ATOM   1551  OD1 ASP    93     -30.830  39.510  14.444  1.00 34.06           O
ATOM   1552  OD2 ASP    93     -29.975  38.111  15.906  1.00 30.80           O
ATOM   1553  C   ASP    93     -30.200  36.391  11.496  1.00 27.19           C
ATOM   1554  O   ASP    93     -29.054  36.350  11.035  1.00 22.18           O
ATOM   1556  N   ARG    94     -31.084  35.433  11.257  1.00 23.21           N
ATOM   1557  CA  ARG    94     -30.707  34.307  10.424  1.00 23.79           C
ATOM   1559  CB  ARG    94     -31.766  33.209  10.471  1.00 25.48           C
ATOM   1562  CG  ARG    94     -31.737  32.427  11.740  1.00 27.61           C
ATOM   1565  CD  ARG    94     -32.760  31.383  11.762  1.00 30.35           C
ATOM   1568  NE  ARG    94     -32.587  30.462  12.881  1.00 29.92           N
ATOM   1570  CZ  ARG    94     -33.515  29.601  13.303  1.00 44.64           C
ATOM   1571  NH1 ARG    94     -34.696  29.524  12.707  1.00 49.89           N
ATOM   1574  NH2 ARG    94     -33.253  28.800  14.329  1.00 50.28           N
ATOM   1577  C   ARG    94     -30.353  34.733   8.984  1.00 20.18           C
ATOM   1578  O   ARG    94     -29.450  34.143   8.402  1.00 24.67           O
ATOM   1580  N   LEU    95     -31.024  35.742   8.429  1.00 22.52           N
ATOM   1581  CA  LEU    95     -30.721  36.233   7.093  1.00 22.83           C
ATOM   1583  CB  LEU    95     -31.778  37.231   6.586  1.00 17.27           C
ATOM   1586  CG  LEU    95     -31.622  37.872   5.193  1.00 13.78           C
ATOM   1588  CD1 LEU    95     -31.591  36.803   4.083  1.00 17.27           C
ATOM   1592  CD2 LEU    95     -32.741  38.938   4.931  1.00 18.04           C
ATOM   1596  C   LEU    95     -29.303  36.857   7.025  1.00 27.03           C
ATOM   1597  O   LEU    95     -28.513  36.509   6.145  1.00 18.85           O
ATOM   1599  N   ILE    96     -29.003  37.775   7.935  1.00 24.56           N
ATOM   1600  CA  ILE    96     -27.664  38.412   7.975  1.00 25.27           C
ATOM   1602  CB  ILE    96     -27.557  39.557   9.048  1.00 24.78           C
ATOM   1604  CG1 ILE    96     -26.213  40.323   8.878  1.00 26.50           C
ATOM   1607  CD1 ILE    96     -26.245  41.771   9.362  1.00 33.12           C
ATOM   1611  CG2 ILE    96     -27.670  38.996  10.451  1.00 39.55           C
ATOM   1615  C   ILE    96     -26.548  37.377   8.152  1.00 19.60           C
ATOM   1616  O   ILE    96     -25.527  37.461   7.468  1.00 21.18           O
ATOM   1618  N   ARG    97     -26.758  36.383   9.014  1.00 22.09           N
ATOM   1619  CA  ARG    97     -25.730  35.337   9.236  1.00 23.22           C
ATOM   1621  CB  ARG    97     -26.055  34.442  10.418  1.00 23.31           C
ATOM   1624  CG  ARG    97     -26.059  35.147  11.791  1.00 18.24           C
ATOM   1627  CD  ARG    97     -25.825  34.149  12.895  1.00 24.44           C
ATOM   1630  NE  ARG    97     -26.714  32.993  12.966  1.00 28.83           N
ATOM   1632  CZ  ARG    97     -27.954  32.988  13.471  1.00 27.43           C
ATOM   1633  NH1 ARG    97     -28.502  34.084  13.952  1.00 30.54           N
ATOM   1636  NH2 ARG    97     -28.636  31.867  13.506  1.00 34.39           N
ATOM   1639  C   ARG    97     -25.531  34.480   8.000  1.00 23.61           C
ATOM   1640  O   ARG    97     -24.405  34.077   7.685  1.00 19.92           O
ATOM   1642  N   HIS    98     -26.632  34.171   7.313  1.00 21.18           N
ATOM   1643  CA  HIS    98     -26.543  33.431   6.046  1.00 22.64           C
ATOM   1645  CB  HIS    98     -27.941  33.050   5.530  1.00 21.77           C
ATOM   1648  CG  HIS    98     -27.908  32.137   4.350  1.00 26.85           C
ATOM   1649  ND1 HIS    98     -27.908  32.597   3.046  1.00 26.01           N
ATOM   1651  CE1 HIS    98     -27.851  31.562   2.226  1.00 24.25           C
ATOM   1653  NE2 HIS    98     -27.801  30.456   2.946  1.00 24.82           N
ATOM   1655  CD2 HIS    98     -27.832  30.790   4.278  1.00 20.83           C
ATOM   1657  C   HIS    98     -25.762  34.212   4.969  1.00 17.30           C
ATOM   1658  O   HIS    98     -24.933  33.631   4.248  1.00 18.06           O
ATOM   1660  N   ARG    99     -26.027  35.506   4.899  1.00 19.10           N
ATOM   1661  CA  ARG    99     -25.316  36.441   4.018  1.00 20.88           C
ATOM   1663  CB  ARG    99     -26.027  37.773   3.997  1.00 20.64           C
ATOM   1666  CG  ARG    99     -27.387  37.732   3.223  1.00 20.88           C
ATOM   1669  CD  ARG    99     -28.174  38.962   3.458  1.00 21.51           C
ATOM   1672  NE  ARG    99     -29.294  39.078   2.521  1.00 23.06           N
ATOM   1674  CZ  ARG    99     -30.191  40.058   2.555  1.00 20.30           C
ATOM   1675  NH1 ARG    99     -30.091  41.023   3.440  1.00 21.05           N
ATOM   1678  NH2 ARG    99     -31.181  40.093   1.678  1.00 21.17           N
ATOM   1681  C   ARG    99     -23.838  36.630   4.382  1.00 20.58           C
ATOM   1682  O   ARG    99     -22.988  36.706   3.488  1.00 17.96           O
ATOM   1684  N   ALA   100     -23.558  36.732   5.683  1.00 19.17           N
ATOM   1685  CA  ALA   100     -22.195  36.813   6.217  1.00 21.85           C
ATOM   1687  CB  ALA   100     -22.225  36.938   7.764  1.00 16.22           C
ATOM   1691  C   ALA   100     -21.351  35.615   5.791  1.00 20.05           C
ATOM   1692  O   ALA   100     -20.221  35.796   5.311  1.00 23.60           O
ATOM   1694  N   CYS   101     -21.907  34.415   5.973  1.00 21.28           N
ATOM   1695  CA  CYS   101     -21.276  33.158   5.610  1.00 21.52           C
ATOM   1697  CB  CYS   101     -22.079  31.960   6.126  1.00 28.07           C
ATOM   1700  SG  CYS   101     -21.972  31.797   7.936  1.00 31.25           S
ATOM   1702  C   CYS   101     -21.051  33.023   4.124  1.00 25.37           C
ATOM   1703  O   CYS   101     -19.999  32.501   3.714  1.00 19.19           O
ATOM   1705  N   ALA   102     -22.016  33.503   3.337  1.00 21.90           N
ATOM   1706  CA  ALA   102     -21.892  33.511   1.882  1.00 22.12           C
ATOM   1708  CB  ALA   102     -23.235  33.849   1.188  1.00 15.78           C
ATOM   1712  C   ALA   102     -20.790  34.486   1.442  1.00 20.27           C
ATOM   1713  O   ALA   102     -20.054  34.187   0.513  1.00 19.10           O
ATOM   1715  N   LEU   103     -20.716  35.655   2.073  1.00 16.83           N
ATOM   1716  CA  LEU   103     -19.665  36.644   1.771  1.00 18.39           C
ATOM   1718  CB  LEU   103     -19.805  37.899   2.654  1.00 23.15           C
ATOM   1721  CG  LEU   103     -18.663  38.922   2.545  1.00 30.05           C
ATOM   1723  CD1 LEU   103     -18.835  39.688   1.281  1.00 28.54           C
ATOM   1727  CD2 LEU   103     -18.626  39.860   3.741  1.00 37.11           C
ATOM   1731  C   LEU   103     -18.284  35.999   1.972  1.00 22.05           C
ATOM   1732  O   LEU   103     -17.399  36.073   1.096  1.00 16.43           O
ATOM   1734  N   ARG   104     -18.145  35.347   3.118  1.00 20.87           N
ATOM   1735  CA  ARG   104     -16.942  34.619   3.490  1.00 19.58           C
ATOM   1737  CB  ARG   104     -17.073  34.081   4.903  1.00 21.66           C
ATOM   1740  CG  ARG   104     -15.809  33.343   5.449  1.00 26.94           C
ATOM   1743  CD  ARG   104     -16.189  32.403   6.579  1.00 37.02           C
ATOM   1746  NE  ARG   104     -17.176  31.418   6.120  1.00 39.15           N
ATOM   1748  CZ  ARG   104     -18.107  30.830   6.873  1.00 47.77           C
ATOM   1749  NH1 ARG   104     -18.226  31.107   8.170  1.00 40.34           N
ATOM   1752  NH2 ARG   104     -18.941  29.960   6.318  1.00 32.08           N
ATOM   1755  C   ARG   104     -16.608  33.498   2.514  1.00 21.51           C
ATOM   1756  O   ARG   104     -15.502  33.451   1.985  1.00 19.81           O
ATOM   1758  N   ASP   105     -17.569  32.614   2.252  1.00 19.85           N
ATOM   1759  CA  ASP   105     -17.371  31.514   1.328  1.00 18.95           C
ATOM   1761  CB  ASP   105     -18.589  30.579   1.310  1.00 19.94           C
ATOM   1764  CG  ASP   105     -18.786  29.817   2.617  1.00 29.87           C
ATOM   1765  OD1 ASP   105     -17.890  29.804   3.497  1.00 25.79           O
ATOM   1766  OD2 ASP   105     -19.875  29.240   2.759  1.00 32.06           O
ATOM   1767  C   ASP   105     -17.071  31.980  -0.091  1.00 18.74           C
ATOM   1768  O   ASP   105     -16.165  31.416  -0.760  1.00 18.41           O
ATOM   1770  N   THR   106     -17.805  32.999  -0.550  1.00 16.32           N
ATOM   1771  CA  THR   106     -17.554  33.568  -1.857  1.00 17.31           C
ATOM   1773  CB  THR   106     -18.592  34.671  -2.215  1.00 19.60           C
ATOM   1775  OG1 THR   106     -19.910  34.091  -2.200  1.00 21.70           O
ATOM   1777  CG2 THR   106     -18.293  35.280  -3.582  1.00 21.15           C
ATOM   1781  C   THR   106     -16.110  34.103  -2.046  1.00 18.99           C
ATOM   1782  O   THR   106     -15.477  33.831  -3.076  1.00 17.74           O
ATOM   1784  N   ALA   107     -15.637  34.895  -1.094  1.00 15.61           N
ATOM   1785  CA  ALA   107     -14.289  35.420  -1.112  1.00 21.64           C
ATOM   1787  CB  ALA   107     -14.046  36.389   0.104  1.00 18.61           C
ATOM   1791  C   ALA   107     -13.247  34.298  -1.143  1.00 18.51           C
ATOM   1792  O   ALA   107     -12.335  34.325  -1.983  1.00 17.14           O
ATOM   1794  N   TYR   108     -13.401  33.301  -0.262  1.00 19.06           N
ATOM   1795  CA  TYR   108     -12.468  32.196  -0.209  1.00 20.55           C
ATOM   1797  CB  TYR   108     -12.759  31.244   0.955  1.00 19.96           C
ATOM   1800  CG  TYR   108     -12.056  31.638   2.231  1.00 25.99           C
ATOM   1801  CD1 TYR   108     -12.606  32.576   3.103  1.00 24.70           C
ATOM   1803  CE1 TYR   108     -11.952  32.927   4.290  1.00 20.39           C
ATOM   1805  CZ  TYR   108     -10.747  32.334   4.587  1.00 20.84           C
ATOM   1806  OH  TYR   108     -10.069  32.659   5.731  1.00 24.88           O
ATOM   1808  CE2 TYR   108     -10.178  31.414   3.723  1.00 24.61           C
ATOM   1810  CD2 TYR   108     -10.817  31.077   2.565  1.00 25.48           C
ATOM   1812  C   TYR   108     -12.408  31.452  -1.529  1.00 20.31           C
ATOM   1813  O   TYR   108     -11.310  31.099  -1.995  1.00 17.23           O
ATOM   1815  N   ALA   109     -13.574  31.289  -2.149  1.00 19.03           N
ATOM   1816  CA  ALA   109     -13.706  30.564  -3.412  1.00 23.11           C
ATOM   1818  CB  ALA   109     -15.176  30.300  -3.685  1.00 18.89           C
ATOM   1822  C   ALA   109     -13.061  31.284  -4.604  1.00 20.50           C
ATOM   1823  O   ALA   109     -12.427  30.638  -5.470  1.00 18.55           O
ATOM   1825  N   ILE   110     -13.267  32.605  -4.688  1.00 19.36           N
ATOM   1826  CA  ILE   110     -12.599  33.421  -5.725  1.00 21.96           C
ATOM   1828  CB  ILE   110     -13.063  34.925  -5.709  1.00 18.58           C
ATOM   1830  CG1 ILE   110     -14.535  35.027  -6.122  1.00 22.18           C
ATOM   1833  CD1 ILE   110     -15.215  36.373  -5.838  1.00 14.78           C
ATOM   1837  CG2 ILE   110     -12.170  35.812  -6.630  1.00 14.29           C
ATOM   1841  C   ILE   110     -11.071  33.311  -5.607  1.00 19.10           C
ATOM   1842  O   ILE   110     -10.372  33.040  -6.591  1.00 17.26           O
ATOM   1844  N   ILE   111     -10.561  33.544  -4.408  1.00 19.19           N
ATOM   1845  CA  ILE   111      -9.131  33.411  -4.116  1.00 25.44           C
ATOM   1847  CB  ILE   111      -8.800  33.800  -2.614  1.00 22.02           C
ATOM   1849  CG1 ILE   111      -8.927  35.319  -2.466  0.50 24.12           C
ATOM   1855  CD1 ILE   111      -8.975  35.821  -1.034  0.50 24.28           C
ATOM   1863  CG2 ILE   111      -7.377  33.351  -2.186  0.50 20.27           C
ATOM   1871  C   ILE   111      -8.594  32.012  -4.480  1.00 23.43           C
ATOM   1872  O   ILE   111      -7.521  31.889  -5.076  1.00 21.51           O
ATOM   1874  N   LYS   112      -9.331  30.970  -4.113  1.00 20.95           N
ATOM   1875  CA  LYS   112      -8.891  29.605  -4.401  1.00 25.13           C
ATOM   1877  CB  LYS   112      -9.815  28.569  -3.758  1.00 24.23           C
ATOM   1880  CG  LYS   112      -9.267  27.139  -3.851  1.00 34.87           C
ATOM   1883  CD  LYS   112     -10.337  26.124  -3.532  1.00 39.00           C
ATOM   1886  CE  LYS   112      -9.719  24.728  -3.388  1.00 41.73           C
ATOM   1889  NZ  LYS   112     -10.780  23.712  -3.284  1.00 50.37           N
ATOM   1893  C   LYS   112      -8.788  29.353  -5.898  1.00 22.73           C
ATOM   1894  O   LYS   112      -7.847  28.719  -6.353  1.00 23.80           O
ATOM   1896  N   GLU   113      -9.746  29.853  -6.661  1.00 20.61           N
ATOM   1897  CA  GLU   113      -9.742  29.692  -8.104  1.00 21.10           C
ATOM   1899  CB  GLU   113     -11.151  29.903  -8.655  1.00 24.85           C
ATOM   1902  CG  GLU   113     -11.376  29.291 -10.028  1.00 42.67           C
ATOM   1905  CD  GLU   113     -12.830  28.871 -10.218  1.00 63.40           C
ATOM   1906  OE1 GLU   113     -13.664  29.740 -10.555  1.00 53.37           O
ATOM   1907  OE2 GLU   113     -13.141  27.678 -10.014  1.00 73.30           O
ATOM   1908  C   GLU   113      -8.761  30.627  -8.834  1.00 22.80           C
ATOM   1909  O   GLU   113      -8.143  30.225  -9.814  1.00 22.99           O
ATOM   1911  N   GLU   114      -8.624  31.869  -8.371  1.00 18.16           N
ATOM   1912  CA  GLU   114      -7.987  32.916  -9.174  1.00 20.66           C
ATOM   1914  CB  GLU   114      -8.942  34.104  -9.351  1.00 17.76           C
ATOM   1917  CG  GLU   114     -10.303  33.700 -10.004  1.00 20.51           C
ATOM   1920  CD  GLU   114     -11.257  34.857 -10.154  1.00 22.62           C
ATOM   1921  OE1 GLU   114     -10.785  36.015 -10.211  1.00 23.24           O
ATOM   1922  OE2 GLU   114     -12.497  34.622 -10.190  1.00 20.23           O
ATOM   1923  C   GLU   114      -6.638  33.436  -8.660  1.00 17.59           C
ATOM   1924  O   GLU   114      -5.978  34.135  -9.388  1.00 22.00           O
ATOM   1926  N   LEU   115      -6.264  33.152  -7.424  1.00 17.35           N
ATOM   1927  CA  LEU   115      -4.969  33.587  -6.918  1.00 22.63           C
ATOM   1929  CB  LEU   115      -5.031  34.089  -5.488  1.00 25.32           C
ATOM   1932  CG  LEU   115      -3.736  34.808  -5.019  1.00 27.81           C
ATOM   1934  CD1 LEU   115      -3.541  36.132  -5.784  1.00 29.99           C
ATOM   1938  CD2 LEU   115      -3.802  35.013  -3.544  1.00 34.72           C
ATOM   1942  C   LEU   115      -3.995  32.413  -7.027  1.00 22.59           C
ATOM   1943  O   LEU   115      -4.200  31.351  -6.437  1.00 25.27           O
ATOM   1945  N   ASP   116      -2.956  32.608  -7.823  1.00 26.87           N
ATOM   1946  CA  ASP   116      -1.931  31.598  -8.001  1.00 21.26           C
ATOM   1948  CB  ASP   116      -0.940  32.039  -9.085  1.00 24.60           C
ATOM   1951  CG  ASP   116      -0.014  30.945  -9.463  1.00 32.72           C
ATOM   1952  OD1 ASP   116       0.802  30.520  -8.621  1.00 35.85           O
ATOM   1953  OD2 ASP   116      -0.116  30.482 -10.603  1.00 30.51           O
ATOM   1954  C   ASP   116      -1.217  31.405  -6.686  1.00 19.88           C
ATOM   1955  O   ASP   116      -0.797  32.367  -6.070  1.00 17.18           O
ATOM   1957  N   GLU   117      -1.072  30.153  -6.273  1.00 19.70           N
ATOM   1958  CA  GLU   117      -0.423  29.793  -5.015  1.00 21.71           C
ATOM   1960  CB  GLU   117      -0.505  28.281  -4.806  1.00 24.97           C
ATOM   1963  CG  GLU   117      -1.873  27.805  -4.351  1.00 47.68           C
ATOM   1966  CD  GLU   117      -1.993  26.281  -4.377  1.00 62.52           C
ATOM   1967  OE1 GLU   117      -1.051  25.592  -3.917  1.00 68.27           O
ATOM   1968  OE2 GLU   117      -3.025  25.781  -4.872  1.00 64.53           O
ATOM   1969  C   GLU   117       1.034  30.252  -4.904  1.00 19.02           C
ATOM   1970  O   GLU   117       1.505  30.575  -3.804  1.00 21.23           O
ATOM   1972  N   ASP   118       1.726  30.300  -6.037  1.00 21.76           N
ATOM   1973  CA  ASP   118       3.114  30.755  -6.084  1.00 23.35           C
ATOM   1975  CB  ASP   118       3.807  30.259  -7.362  1.00 23.22           C
ATOM   1978  CG  ASP   118       4.031  28.759  -7.344  1.00 23.95           C
ATOM   1979  OD1 ASP   118       4.153  28.174  -6.239  1.00 27.42           O
ATOM   1980  OD2 ASP   118       4.053  28.181  -8.419  1.00 34.51           O
ATOM   1981  C   ASP   118       3.216  32.252  -5.989  1.00 19.61           C
ATOM   1982  O   ASP   118       4.183  32.772  -5.444  1.00 21.35           O
ATOM   1984  N   PHE   119       2.205  32.953  -6.489  1.00 20.03           N
ATOM   1985  CA  PHE   119       2.117  34.407  -6.319  1.00 18.31           C
ATOM   1987  CB  PHE   119       0.999  35.022  -7.194  1.00 21.75           C
ATOM   1990  CG  PHE   119       0.877  36.501  -7.019  1.00 18.23           C
ATOM   1991  CD1 PHE   119       1.697  37.368  -7.744  1.00 20.63           C
ATOM   1993  CE1 PHE   119       1.645  38.724  -7.536  1.00 20.18           C
ATOM   1995  CZ  PHE   119       0.778  39.242  -6.595  1.00 20.66           C
ATOM   1997  CE2 PHE   119      -0.028  38.399  -5.840  1.00 21.25           C
ATOM   1999  CD2 PHE   119       0.034  37.039  -6.034  1.00 23.39           C
ATOM   2001  C   PHE   119       1.943  34.760  -4.820  1.00 20.04           C
ATOM   2002  O   PHE   119       2.636  35.652  -4.300  1.00 19.24           O
ATOM   2004  N   GLU   120       1.019  34.061  -4.149  1.00 19.65           N
ATOM   2005  CA  GLU   120       0.771  34.243  -2.721  1.00 20.07           C
ATOM   2007  CB  GLU   120      -0.452  33.418  -2.270  1.00 19.67           C
ATOM   2010  CG  GLU   120      -0.776  33.431  -0.751  1.00 18.22           C
ATOM   2013  CD  GLU   120      -0.842  34.838  -0.076  1.00 24.26           C
ATOM   2014  OE1 GLU   120      -0.993  35.867  -0.749  1.00 22.01           O
ATOM   2015  OE2 GLU   120      -0.748  34.920   1.166  1.00 31.38           O
ATOM   2016  C   GLU   120       2.011  33.896  -1.906  1.00 20.48           C
ATOM   2017  O   GLU   120       2.382  34.653  -1.004  1.00 18.84           O
ATOM   2019  N   GLN   121       2.694  32.812  -2.281  1.00 23.00           N
ATOM   2020  CA  GLN   121       3.915  32.389  -1.584  1.00 25.45           C
ATOM   2022  CB  GLN   121       4.429  31.033  -2.118  1.00 27.28           C
ATOM   2025  CG  GLN   121       5.608  30.447  -1.317  1.00 21.66           C
ATOM   2028  CD  GLN   121       5.278  30.213   0.151  1.00 33.37           C
ATOM   2029  OE1 GLN   121       4.152  29.870   0.483  1.00 32.16           O
ATOM   2030  NE2 GLN   121       6.259  30.418   1.037  1.00 26.32           N
ATOM   2033  C   GLN   121       5.004  33.462  -1.667  1.00 23.94           C
ATOM   2034  O   GLN   121       5.652  33.769  -0.654  1.00 23.54           O
ATOM   2036  N   LEU   122       5.194  34.028  -2.859  1.00 20.47           N
ATOM   2037  CA  LEU   122       6.070  35.185  -3.031  1.00 18.08           C
ATOM   2039  CB  LEU   122       6.086  35.684  -4.483  1.00 19.06           C
ATOM   2042  CG  LEU   122       7.034  36.853  -4.806  1.00 21.41           C
ATOM   2044  CD1 LEU   122       8.500  36.550  -4.318  1.00 21.01           C
ATOM   2048  CD2 LEU   122       6.981  37.263  -6.284  1.00 19.35           C
ATOM   2052  C   LEU   122       5.717  36.346  -2.102  1.00 25.99           C
ATOM   2053  O   LEU   122       6.595  36.878  -1.426  1.00 22.53           O
ATOM   2055  N   CYS   123       4.442  36.746  -2.073  1.00 24.30           N
ATOM   2056  CA  CYS   123       3.986  37.824  -1.193  1.00 22.03           C
ATOM   2058  CB  CYS   123       2.462  38.013  -1.273  1.00 19.81           C
ATOM   2061  SG  CYS   123       1.949  38.719  -2.788  1.00 20.51           S
ATOM   2063  C   CYS   123       4.406  37.543   0.250  1.00 19.76           C
ATOM   2064  O   CYS   123       4.923  38.429   0.925  1.00 23.30           O
ATOM   2066  N   GLU   124       4.219  36.302   0.677  1.00 21.51           N
ATOM   2067  CA  GLU   124       4.498  35.894   2.033  1.00 23.50           C
ATOM   2069  CB  GLU   124       3.904  34.522   2.316  1.00 25.91           C
ATOM   2072  CG  GLU   124       2.354  34.523   2.426  1.00 34.93           C
ATOM   2075  CD  GLU   124       1.753  33.122   2.570  1.00 39.26           C
ATOM   2076  OE1 GLU   124       2.507  32.196   2.922  1.00 44.00           O
ATOM   2077  OE2 GLU   124       0.531  32.934   2.324  1.00 32.86           O
ATOM   2078  C   GLU   124       6.000  35.937   2.305  1.00 27.58           C
ATOM   2079  O   GLU   124       6.425  36.363   3.373  1.00 23.27           O
ATOM   2081  N   GLU   125       6.808  35.559   1.319  1.00 28.86           N
ATOM   2082  CA  GLU   125       8.266  35.568   1.498  1.00 28.47           C
ATOM   2084  CB  GLU   125       8.964  34.623   0.483  1.00 24.02           C
ATOM   2087  CG  GLU   125       8.640  33.169   0.845  1.00 24.03           C
ATOM   2090  CD  GLU   125       9.254  32.079  -0.028  1.00 24.11           C
ATOM   2091  OE1 GLU   125      10.097  32.389  -0.885  1.00 26.14           O
ATOM   2092  OE2 GLU   125       8.870  30.893   0.175  1.00 25.13           O
ATOM   2093  C   GLU   125       8.844  36.986   1.557  1.00 25.14           C
ATOM   2094  O   GLU   125       9.702  37.240   2.379  1.00 32.10           O
ATOM   2096  N   ILE   126       8.343  37.910   0.744  1.00 18.67           N
ATOM   2097  CA  ILE   126       8.744  39.303   0.794  1.00 28.52           C
ATOM   2099  CB  ILE   126       8.101  40.129  -0.336  1.00 27.83           C
ATOM   2101  CG1 ILE   126       8.493  39.568  -1.715  1.00 26.91           C
ATOM   2104  CD1 ILE   126       7.773  40.251  -2.894  1.00 26.67           C
ATOM   2108  CG2 ILE   126       8.485  41.616  -0.217  1.00 22.12           C
ATOM   2112  C   ILE   126       8.337  39.875   2.154  1.00 36.40           C
ATOM   2113  O   ILE   126       9.156  40.463   2.873  1.00 35.06           O
ATOM   2115  N   GLN   127       7.079  39.649   2.529  1.00 35.08           N
ATOM   2116  CA  GLN   127       6.566  40.142   3.807  1.00 38.66           C
ATOM   2118  CB  GLN   127       5.108  39.735   3.995  1.00 38.13           C
ATOM   2121  CG  GLN   127       4.372  40.616   4.976  1.00 46.73           C
ATOM   2124  CD  GLN   127       3.704  39.812   6.038  1.00 64.51           C
ATOM   2125  OE1 GLN   127       4.390  39.181   6.848  1.00 56.16           O
ATOM   2126  NE2 GLN   127       2.356  39.812   6.052  1.00 51.91           N
ATOM   2129  C   GLN   127       7.425  39.636   4.995  1.00 34.69           C
ATOM   2130  O   GLN   127       7.851  40.424   5.838  1.00 33.60           O
ATOM   2132  N   GLU   128       7.683  38.335   5.043  1.00 35.26           N
ATOM   2133  CA  GLU   128       8.563  37.745   6.067  1.00 40.39           C
ATOM   2135  CB  GLU   128       8.623  36.223   5.892  1.00 41.49           C
ATOM   2138  CG  GLU   128       7.485  35.491   6.573  1.00 47.02           C
ATOM   2141  CD  GLU   128       6.930  34.334   5.760  1.00 63.09           C
ATOM   2142  OE1 GLU   128       7.704  33.634   5.067  1.00 51.55           O
ATOM   2143  OE2 GLU   128       5.699  34.126   5.826  1.00 65.34           O
ATOM   2144  C   GLU   128      10.001  38.324   6.084  1.00 45.71           C
ATOM   2145  O   GLU   128      10.679  38.302   7.119  1.00 48.40           O
ATOM   2147  N   SER   129      10.462  38.833   4.946  1.00 43.84           N
ATOM   2148  CA  SER   129      11.809  39.391   4.843  1.00 48.65           C
ATOM   2150  CB  SER   129      12.296  39.375   3.386  1.00 43.37           C
ATOM   2153  OG  SER   129      11.800  40.487   2.656  1.00 42.87           O
ATOM   2155  C   SER   129      11.874  40.812   5.408  1.00 52.03           C
ATOM   2156  O   SER   129      12.965  41.358   5.592  1.00 53.77           O
ATOM   2158  N   ARG   130      10.711  41.410   5.661  1.00 53.93           N
ATOM   2159  CA  ARG   130      10.633  42.740   6.267  1.00 59.45           C
ATOM   2161  CB  ARG   130       9.391  43.497   5.759  1.00 54.21           C
ATOM   2164  CG  ARG   130       9.681  44.307   4.492  1.00 68.78           C
ATOM   2167  CD  ARG   130       8.593  44.234   3.428  1.00 58.27           C
ATOM   2170  NE  ARG   130       9.175  44.426   2.091  1.00 71.54           N
ATOM   2172  CZ  ARG   130       8.794  45.337   1.189  1.00 79.48           C
ATOM   2173  NH1 ARG   130       9.414  45.386   0.007  1.00 73.01           N
ATOM   2176  NH2 ARG   130       7.790  46.185   1.432  1.00 82.81           N
ATOM   2179  C   ARG   130      10.653  42.648   7.793  1.00 61.53           C
ATOM   2180  O   ARG   130       9.981  41.818   8.419  1.00 64.77           O
ATOM   2182  OXT ARG   130      11.374  43.409   8.435  1.00 67.56           O
END
