
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   90 (  689),  selected   90 , name 2hqx_A
# Molecule2: number of CA atoms  135 ( 1110),  selected  135 , name T0429.pdb
# PARAMETERS: 2hqx_A.T0429.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     8_A      E      22           -
LGA    Q     9_A      T      23           -
LGA    F    10_A      E      24           -
LGA    Q    11_A      L      25           -
LGA    K    12_A      L      27           -
LGA    L    13_A      Y      28           -
LGA    M    14_A      K      29           -
LGA    -       -      V      30           -
LGA    -       -      N      31           -
LGA    -       -      E      32           -
LGA    -       -      Y      33           -
LGA    -       -      V      34           -
LGA    -       -      D      35           -
LGA    E    15_A      A      36          0.777
LGA    -       -      R      37           -
LGA    -       -      D      38           -
LGA    -       -      T      39           -
LGA    -       -      N      40           -
LGA    -       -      M      41           -
LGA    -       -      G      42           -
LGA    -       -      A      43           -
LGA    -       -      W      44           -
LGA    -       -      F      45           -
LGA    -       -      E      46           -
LGA    -       -      A      47           -
LGA    -       -      Q      48           -
LGA    -       -      V      49           -
LGA    -       -      V      50           -
LGA    -       -      R      51           -
LGA    -       -      V      52           -
LGA    -       -      T      53           -
LGA    -       -      R      54           -
LGA    -       -      E      73           -
LGA    -       -      D      74           -
LGA    -       -      V      75           -
LGA    -       -      I      76           -
LGA    -       -      Y      77           -
LGA    -       -      H      78           -
LGA    -       -      V      79           -
LGA    -       -      K      80           -
LGA    -       -      Y      81           -
LGA    -       -      D      82           -
LGA    -       -      D      83           -
LGA    -       -      Y      84           -
LGA    -       -      P      85           -
LGA    -       -      E      86           -
LGA    -       -      N      87           -
LGA    -       -      G      88           -
LGA    -       -      V      89           -
LGA    -       -      V      90           -
LGA    -       -      Q      91           -
LGA    -       -      M      92           -
LGA    -       -      N      93           -
LGA    -       -      S      94           -
LGA    -       -      R      95           -
LGA    -       -      D      96           -
LGA    N    16_A      V      97          2.844
LGA    M    17_A      R      98          4.115
LGA    R    18_A      A      99           -
LGA    N    19_A      -       -           -
LGA    D    20_A      R     100          0.883
LGA    I    21_A      A     101          2.327
LGA    A    22_A      -       -           -
LGA    S    23_A      -       -           -
LGA    H    24_A      -       -           -
LGA    P    25_A      R     102          3.844
LGA    P    26_A      T     103          3.794
LGA    V    27_A      I     104          3.507
LGA    E    28_A      -       -           -
LGA    G    29_A      -       -           -
LGA    S    30_A      I     105          3.683
LGA    Y    31_A      K     106          3.955
LGA    -       -      W     107           -
LGA    -       -      Q     108           -
LGA    A    32_A      D     109          2.051
LGA    P    33_A      L     110          1.374
LGA    R    34_A      E     111          0.734
LGA    R    35_A      V     112          0.943
LGA    G    36_A      G     113          1.265
LGA    E    37_A      Q     114          1.463
LGA    F    38_A      V     115          1.218
LGA    C    39_A      V     116          1.061
LGA    I    40_A      M     117          1.134
LGA    A    41_A      L     118          1.448
LGA    K    42_A      N     119          1.070
LGA    F    43_A      Y     120          1.394
LGA    V    44_A      N     121          2.416
LGA    -       -      P     122           -
LGA    -       -      D     123           -
LGA    -       -      N     124           -
LGA    -       -      P     125           -
LGA    -       -      K     126           -
LGA    -       -      E     127           -
LGA    D    45_A      R     128          5.306
LGA    G    46_A      G     129          3.289
LGA    E    47_A      F     130          2.023
LGA    W    48_A      W     131          1.249
LGA    Y    49_A      Y     132          1.227
LGA    R    50_A      D     133          1.099
LGA    A    51_A      A     134          0.864
LGA    R    52_A      E     135          0.457
LGA    V    53_A      I     136          0.717
LGA    E    54_A      S     137          0.735
LGA    K    55_A      R     138          0.723
LGA    V    56_A      K     139          0.359
LGA    E    57_A      R     140          1.275
LGA    S    58_A      E     141          2.374
LGA    P    59_A      T     142           -
LGA    -       -      R     143           -
LGA    -       -      T     144           -
LGA    -       -      A     145           -
LGA    A    60_A      R     146          2.762
LGA    K    61_A      E     147          1.349
LGA    I    62_A      L     148          0.752
LGA    H    63_A      Y     149          0.488
LGA    V    64_A      A     150          0.343
LGA    F    65_A      N     151          0.387
LGA    Y    66_A      V     152          1.117
LGA    I    67_A      V     153          2.953
LGA    D    68_A      L     154          4.078
LGA    -       -      D     156           -
LGA    Y    69_A      D     157          3.736
LGA    G    70_A      S     158          1.512
LGA    N    71_A      L     159          1.192
LGA    R    72_A      N     160          3.547
LGA    -       -      D     161           -
LGA    E    73_A      C     162          1.656
LGA    V    74_A      R     163          1.335
LGA    L    75_A      I     164          1.639
LGA    -       -      I     165           -
LGA    P    76_A      F     166          4.108
LGA    S    77_A      V     167          2.351
LGA    T    78_A      D     168          1.081
LGA    R    79_A      E     169          3.131
LGA    L    80_A      V     170          1.555
LGA    G    81_A      F     171          1.600
LGA    T    82_A      K     172          0.931
LGA    L    83_A      I     173          1.642
LGA    S    84_A      E     174          1.557
LGA    P    85_A      R     175          1.404
LGA    A    86_A      P     176          4.147
LGA    F    87_A      -       -           -
LGA    S    88_A      -       -           -
LGA    T    89_A      -       -           -
LGA    R    90_A      -       -           -
LGA    V    91_A      -       -           -
LGA    L    92_A      -       -           -
LGA    P    93_A      -       -           -
LGA    A    94_A      -       -           -
LGA    Q    95_A      -       -           -
LGA    A    96_A      -       -           -
LGA    T    97_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   90  135    5.0     64    2.25     7.81     39.040     2.723

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.514207 * X  +  -0.781787 * Y  +  -0.352704 * Z  +  30.603685
  Y_new =  -0.780433 * X  +   0.255960 * Y  +   0.570446 * Z  + -19.209419
  Z_new =  -0.355689 * X  +   0.568589 * Y  +  -0.741749 * Z  +   1.205012 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.487582   -0.654010  [ DEG:   142.5280    -37.4720 ]
  Theta =   0.363651    2.777941  [ DEG:    20.8357    159.1643 ]
  Phi   =  -2.153385    0.988208  [ DEG:  -123.3799     56.6201 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hqx_A                                        
REMARK     2: T0429.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hqx_A.T0429.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   90  135   5.0   64   2.25    7.81  39.040
REMARK  ---------------------------------------------------------- 
MOLECULE 2hqx_A
HEADER    TRANSCRIPTION                           19-JUL-06   2HQX              
TITLE     CRYSTAL STRUCTURE OF HUMAN P100 TUDOR DOMAIN CONSERVED                
TITLE    2 REGION                                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: P100 CO-ACTIVATOR TUDOR DOMAIN;                            
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: CONSERVED REGION;                                          
COMPND   5 SYNONYM: P100 CO-ACTIVATOR, 100 KDA COACTIVATOR, EBNA2               
COMPND   6 COACTIVATOR P100;                                                    
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: SND1;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    HUMAN P100 TUDOR DOMAIN, PROTEOLYTIC FRAGMENT, PSI,                   
KEYWDS   2 STRUCTURAL GENOMICS, SOUTHEAST COLLABORATORY FOR STRUCTURAL          
KEYWDS   3 GENOMICS, PROTEIN STRUCTURE INITIATIVE, SECSG                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.ZHAO,Z.J.LIU,H.XU,J.YANG,O.SILVENNOINEN,B.C.WANG,                   
AUTHOR   2 SOUTHEAST COLLABORATORY FOR STRUCTURAL GENOMICS (SECSG)              
REVDAT   1   10-OCT-06 2HQX    0                                                
JRNL        AUTH   M.ZHAO,Z.J.LIU,H.XU,J.YANG,O.SILVENNOINEN,B.C.WANG           
JRNL        TITL   CRYSTAL STRUCTURE OF HUMAN P100 TUDOR DOMAIN                 
JRNL        TITL 2 CONSERVED REGION                                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.42 ANGSTROMS.                                          
DBREF  2HQX A  -32   213  UNP    Q7KZF4   SND1_HUMAN     665    910             
DBREF  2HQX B  -32   213  UNP    Q7KZF4   SND1_HUMAN     665    910             
SEQRES   1 A  246  PRO VAL GLU GLU VAL MET PRO VAL LEU GLU GLU LYS GLU          
SEQRES   2 A  246  ARG SER ALA SER TYR LYS PRO VAL PHE VAL THR GLU ILE          
SEQRES   3 A  246  THR ASP ASP LEU HIS PHE TYR VAL GLN ASP VAL GLU THR          
SEQRES   4 A  246  GLY THR GLN PHE GLN LYS LEU MET GLU ASN MET ARG ASN          
SEQRES   5 A  246  ASP ILE ALA SER HIS PRO PRO VAL GLU GLY SER TYR ALA          
SEQRES   6 A  246  PRO ARG ARG GLY GLU PHE CYS ILE ALA LYS PHE VAL ASP          
SEQRES   7 A  246  GLY GLU TRP TYR ARG ALA ARG VAL GLU LYS VAL GLU SER          
SEQRES   8 A  246  PRO ALA LYS ILE HIS VAL PHE TYR ILE ASP TYR GLY ASN          
SEQRES   9 A  246  ARG GLU VAL LEU PRO SER THR ARG LEU GLY THR LEU SER          
SEQRES  10 A  246  PRO ALA PHE SER THR ARG VAL LEU PRO ALA GLN ALA THR          
SEQRES  11 A  246  GLU TYR ALA PHE ALA PHE ILE GLN VAL PRO GLN ASP ASP          
SEQRES  12 A  246  ASP ALA ARG THR ASP ALA VAL ASP SER VAL VAL ARG ASP          
SEQRES  13 A  246  ILE GLN ASN THR GLN CYS LEU LEU ASN VAL GLU HIS LEU          
SEQRES  14 A  246  SER ALA GLY CYS PRO HIS VAL THR LEU GLN PHE ALA ASP          
SEQRES  15 A  246  SER LYS GLY ASP VAL GLY LEU GLY LEU VAL LYS GLU GLY          
SEQRES  16 A  246  LEU VAL MET VAL GLU VAL ARG LYS GLU LYS GLN PHE GLN          
SEQRES  17 A  246  LYS VAL ILE THR GLU TYR LEU ASN ALA GLN GLU SER ALA          
SEQRES  18 A  246  LYS SER ALA ARG LEU ASN LEU TRP ARG TYR GLY ASP PHE          
SEQRES  19 A  246  ARG ALA ASP ASP ALA ASP GLU PHE GLY TYR SER ARG              
SEQRES   1 B  246  PRO VAL GLU GLU VAL MET PRO VAL LEU GLU GLU LYS GLU          
SEQRES   2 B  246  ARG SER ALA SER TYR LYS PRO VAL PHE VAL THR GLU ILE          
SEQRES   3 B  246  THR ASP ASP LEU HIS PHE TYR VAL GLN ASP VAL GLU THR          
SEQRES   4 B  246  GLY THR GLN PHE GLN LYS LEU MET GLU ASN MET ARG ASN          
SEQRES   5 B  246  ASP ILE ALA SER HIS PRO PRO VAL GLU GLY SER TYR ALA          
SEQRES   6 B  246  PRO ARG ARG GLY GLU PHE CYS ILE ALA LYS PHE VAL ASP          
SEQRES   7 B  246  GLY GLU TRP TYR ARG ALA ARG VAL GLU LYS VAL GLU SER          
SEQRES   8 B  246  PRO ALA LYS ILE HIS VAL PHE TYR ILE ASP TYR GLY ASN          
SEQRES   9 B  246  ARG GLU VAL LEU PRO SER THR ARG LEU GLY THR LEU SER          
SEQRES  10 B  246  PRO ALA PHE SER THR ARG VAL LEU PRO ALA GLN ALA THR          
SEQRES  11 B  246  GLU TYR ALA PHE ALA PHE ILE GLN VAL PRO GLN ASP ASP          
SEQRES  12 B  246  ASP ALA ARG THR ASP ALA VAL ASP SER VAL VAL ARG ASP          
SEQRES  13 B  246  ILE GLN ASN THR GLN CYS LEU LEU ASN VAL GLU HIS LEU          
SEQRES  14 B  246  SER ALA GLY CYS PRO HIS VAL THR LEU GLN PHE ALA ASP          
SEQRES  15 B  246  SER LYS GLY ASP VAL GLY LEU GLY LEU VAL LYS GLU GLY          
SEQRES  16 B  246  LEU VAL MET VAL GLU VAL ARG LYS GLU LYS GLN PHE GLN          
SEQRES  17 B  246  LYS VAL ILE THR GLU TYR LEU ASN ALA GLN GLU SER ALA          
SEQRES  18 B  246  LYS SER ALA ARG LEU ASN LEU TRP ARG TYR GLY ASP PHE          
SEQRES  19 B  246  ARG ALA ASP ASP ALA ASP GLU PHE GLY TYR SER ARG              
FORMUL   3  HOH   *238(H2 O)                                                    
CRYST1   30.777   37.684   40.202  90.03 105.32  99.72 P 1           2          
ATOM      1  N   THR A   8      24.443  -0.561   3.485  1.00 16.75           N  
ATOM      2  CA  THR A   8      23.404  -1.519   3.058  1.00 16.10           C  
ATOM      3  C   THR A   8      23.453  -2.715   4.061  1.00 14.88           C  
ATOM      4  O   THR A   8      24.499  -2.974   4.669  1.00 14.71           O  
ATOM      5  CB  THR A   8      23.713  -1.881   1.589  1.00 17.47           C  
ATOM      6  OG1 THR A   8      22.679  -1.439   0.694  1.00 19.52           O  
ATOM      7  CG2 THR A   8      24.067  -3.314   1.407  1.00 15.31           C  
ATOM      8  N   GLN A   9      22.338  -3.416   4.279  1.00 13.80           N  
ATOM      9  CA  GLN A   9      22.337  -4.583   5.182  1.00 13.61           C  
ATOM     10  C   GLN A   9      23.379  -5.617   4.773  1.00 12.48           C  
ATOM     11  O   GLN A   9      24.094  -6.168   5.609  1.00 11.58           O  
ATOM     12  CB  GLN A   9      20.960  -5.237   5.228  1.00 13.92           C  
ATOM     13  CG  GLN A   9      19.965  -4.437   6.022  1.00 15.09           C  
ATOM     14  CD  GLN A   9      18.608  -5.083   6.043  1.00 19.09           C  
ATOM     15  OE1 GLN A   9      18.334  -5.943   6.881  1.00 20.50           O  
ATOM     16  NE2 GLN A   9      17.744  -4.670   5.129  1.00 19.89           N  
ATOM     17  N   PHE A  10      23.457  -5.866   3.473  1.00 11.78           N  
ATOM     18  CA  PHE A  10      24.452  -6.769   2.918  1.00 12.54           C  
ATOM     19  C   PHE A  10      25.866  -6.275   3.240  1.00 12.65           C  
ATOM     20  O   PHE A  10      26.706  -7.040   3.715  1.00 11.53           O  
ATOM     21  CB  PHE A  10      24.235  -6.831   1.417  1.00 13.20           C  
ATOM     22  CG  PHE A  10      25.032  -7.878   0.712  1.00 15.30           C  
ATOM     23  CD1 PHE A  10      25.703  -8.879   1.407  1.00 18.59           C  
ATOM     24  CD2 PHE A  10      25.006  -7.914  -0.679  1.00 16.10           C  
ATOM     25  CE1 PHE A  10      26.408  -9.828   0.731  1.00 22.43           C  
ATOM     26  CE2 PHE A  10      25.692  -8.868  -1.362  1.00 20.68           C  
ATOM     27  CZ  PHE A  10      26.402  -9.823  -0.662  1.00 21.20           C  
ATOM     28  N   GLN A  11      26.139  -4.998   2.990  1.00 12.37           N  
ATOM     29  CA  GLN A  11      27.470  -4.433   3.233  1.00 12.83           C  
ATOM     30  C   GLN A  11      27.878  -4.560   4.688  1.00 12.37           C  
ATOM     31  O   GLN A  11      29.012  -4.914   4.984  1.00 12.13           O  
ATOM     32  CB  GLN A  11      27.542  -2.971   2.776  1.00 12.82           C  
ATOM     33  CG  GLN A  11      27.627  -2.813   1.251  1.00 14.23           C  
ATOM     34  CD  GLN A  11      27.531  -1.353   0.794  1.00 15.49           C  
ATOM     35  OE1 GLN A  11      26.840  -0.538   1.413  1.00 17.16           O  
ATOM     36  NE2 GLN A  11      28.246  -1.019  -0.276  1.00 20.39           N  
ATOM     37  N   LYS A  12      26.945  -4.277   5.590  1.00 12.00           N  
ATOM     38  CA  LYS A  12      27.193  -4.347   7.020  1.00 12.13           C  
ATOM     39  C   LYS A  12      27.448  -5.785   7.451  1.00 11.57           C  
ATOM     40  O   LYS A  12      28.343  -6.039   8.247  1.00 11.16           O  
ATOM     41  CB  LYS A  12      26.033  -3.756   7.829  1.00 11.93           C  
ATOM     42  CG  LYS A  12      25.834  -2.246   7.668  1.00 14.52           C  
ATOM     43  CD  LYS A  12      24.637  -1.746   8.479  1.00 14.51           C  
ATOM     44  CE  LYS A  12      24.577  -0.214   8.499  1.00 19.55           C  
ATOM     45  NZ  LYS A  12      24.418   0.359   7.135  1.00 24.55           N  
ATOM     46  N   LEU A  13      26.652  -6.731   6.940  1.00 10.51           N  
ATOM     47  CA  LEU A  13      26.868  -8.140   7.301  1.00 10.73           C  
ATOM     48  C   LEU A  13      28.232  -8.624   6.811  1.00 10.21           C  
ATOM     49  O   LEU A  13      28.918  -9.335   7.532  1.00 10.01           O  
ATOM     50  CB  LEU A  13      25.747  -9.059   6.773  1.00 11.42           C  
ATOM     51  CG  LEU A  13      25.830 -10.553   7.165  1.00 11.17           C  
ATOM     52  CD1 LEU A  13      25.355 -10.788   8.597  1.00 16.37           C  
ATOM     53  CD2 LEU A  13      25.030 -11.437   6.214  1.00 11.27           C  
ATOM     54  N   MET A  14      28.637  -8.229   5.606  1.00 10.36           N  
ATOM     55  CA  MET A  14      29.918  -8.695   5.063  1.00 10.20           C  
ATOM     56  C   MET A  14      31.078  -8.185   5.870  1.00 10.43           C  
ATOM     57  O   MET A  14      32.037  -8.907   6.114  1.00  9.31           O  
ATOM     58  CB  MET A  14      30.090  -8.339   3.582  1.00 11.05           C  
ATOM     59  CG  MET A  14      29.179  -9.128   2.699  1.00 11.11           C  
ATOM     60  SD  MET A  14      29.523 -10.899   2.726  1.00  9.40           S  
ATOM     61  CE  MET A  14      30.112 -11.027   1.059  1.00 17.93           C  
ATOM     62  N   GLU A  15      30.996  -6.924   6.283  1.00 10.81           N  
ATOM     63  CA  GLU A  15      32.027  -6.351   7.131  1.00 12.10           C  
ATOM     64  C   GLU A  15      32.116  -7.104   8.449  1.00 10.89           C  
ATOM     65  O   GLU A  15      33.200  -7.505   8.865  1.00 11.54           O  
ATOM     66  CB  GLU A  15      31.752  -4.870   7.389  1.00 12.70           C  
ATOM     67  CG  GLU A  15      32.842  -4.159   8.153  1.00 17.88           C  
ATOM     68  CD  GLU A  15      32.733  -2.650   8.052  1.00 23.93           C  
ATOM     69  OE1 GLU A  15      31.648  -2.103   8.362  1.00 27.87           O  
ATOM     70  OE2 GLU A  15      33.737  -2.005   7.665  1.00 26.43           O  
ATOM     71  N   ASN A  16      30.974  -7.308   9.093  1.00 10.07           N  
ATOM     72  CA  ASN A  16      30.974  -7.972  10.392  1.00 10.59           C  
ATOM     73  C   ASN A  16      31.452  -9.423  10.235  1.00  9.32           C  
ATOM     74  O   ASN A  16      32.279  -9.883  10.995  1.00  9.80           O  
ATOM     75  CB  ASN A  16      29.596  -7.903  11.051  1.00 11.24           C  
ATOM     76  CG  ASN A  16      29.249  -6.504  11.533  1.00 15.04           C  
ATOM     77  OD1 ASN A  16      30.099  -5.805  12.091  1.00 20.56           O  
ATOM     78  ND2 ASN A  16      27.987  -6.100  11.354  1.00 17.70           N  
ATOM     79  N   MET A  17      30.954 -10.118   9.205  1.00  7.97           N  
ATOM     80  CA  MET A  17      31.342 -11.505   8.961  1.00  7.30           C  
ATOM     81  C   MET A  17      32.839 -11.629   8.703  1.00  8.02           C  
ATOM     82  O   MET A  17      33.508 -12.475   9.279  1.00  8.57           O  
ATOM     83  CB  MET A  17      30.538 -12.096   7.787  1.00  7.38           C  
ATOM     84  CG  MET A  17      30.851 -13.554   7.531  1.00  6.92           C  
ATOM     85  SD  MET A  17      29.951 -14.245   6.128  1.00  6.16           S  
ATOM     86  CE  MET A  17      31.026 -13.700   4.795  1.00 10.56           C  
ATOM     87  N   ARG A  18      33.371 -10.789   7.817  1.00  7.24           N  
ATOM     88  CA  ARG A  18      34.797 -10.824   7.482  1.00  7.54           C  
ATOM     89  C   ARG A  18      35.692 -10.459   8.660  1.00  7.83           C  
ATOM     90  O   ARG A  18      36.766 -11.053   8.826  1.00  7.75           O  
ATOM     91  CB  ARG A  18      35.112  -9.953   6.250  1.00  6.41           C  
ATOM     92  CG  ARG A  18      34.451 -10.538   4.993  1.00  5.70           C  
ATOM     93  CD  ARG A  18      34.555  -9.672   3.774  1.00  7.84           C  
ATOM     94  NE  ARG A  18      33.967 -10.376   2.634  1.00  8.77           N  
ATOM     95  CZ  ARG A  18      33.323  -9.778   1.647  1.00 11.57           C  
ATOM     96  NH1 ARG A  18      32.819 -10.514   0.668  1.00 11.75           N  
ATOM     97  NH2 ARG A  18      33.149  -8.458   1.662  1.00 13.32           N  
ATOM     98  N   ASN A  19      35.236  -9.537   9.504  1.00  7.94           N  
ATOM     99  CA  ASN A  19      36.007  -9.225  10.717  1.00  9.63           C  
ATOM    100  C   ASN A  19      36.033 -10.413  11.662  1.00  9.80           C  
ATOM    101  O   ASN A  19      37.057 -10.715  12.283  1.00 10.63           O  
ATOM    102  CB  ASN A  19      35.473  -7.974  11.401  1.00  9.99           C  
ATOM    103  CG  ASN A  19      35.755  -6.722  10.611  1.00 10.90           C  
ATOM    104  OD1 ASN A  19      36.616  -6.696   9.726  1.00 13.73           O  
ATOM    105  ND2 ASN A  19      35.012  -5.662  10.918  1.00 14.33           N  
ATOM    106  N   ASP A  20      34.904 -11.124  11.749  1.00 10.18           N  
ATOM    107  CA  ASP A  20      34.837 -12.323  12.582  1.00 10.64           C  
ATOM    108  C   ASP A  20      35.691 -13.458  12.007  1.00  9.95           C  
ATOM    109  O   ASP A  20      36.392 -14.155  12.740  1.00 10.82           O  
ATOM    110  CB  ASP A  20      33.405 -12.808  12.737  1.00 11.83           C  
ATOM    111  CG  ASP A  20      33.302 -13.904  13.774  1.00 14.49           C  
ATOM    112  OD1 ASP A  20      33.137 -15.082  13.391  1.00 16.19           O  
ATOM    113  OD2 ASP A  20      33.455 -13.595  14.978  1.00 17.87           O  
ATOM    114  N   ILE A  21      35.626 -13.661  10.693  1.00  8.95           N  
ATOM    115  CA  ILE A  21      36.443 -14.708  10.060  1.00 10.19           C  
ATOM    116  C   ILE A  21      37.922 -14.419  10.319  1.00 11.00           C  
ATOM    117  O   ILE A  21      38.676 -15.317  10.642  1.00 11.76           O  
ATOM    118  CB  ILE A  21      36.169 -14.840   8.541  1.00 10.21           C  
ATOM    119  CG1 ILE A  21      34.732 -15.334   8.314  1.00  9.69           C  
ATOM    120  CG2 ILE A  21      37.162 -15.789   7.857  1.00 11.20           C  
ATOM    121  CD1 ILE A  21      34.180 -15.052   6.943  1.00  9.96           C  
ATOM    122  N   ALA A  22      38.331 -13.160  10.204  1.00 12.28           N  
ATOM    123  CA  ALA A  22      39.724 -12.791  10.435  1.00 14.08           C  
ATOM    124  C   ALA A  22      40.146 -13.075  11.885  1.00 15.06           C  
ATOM    125  O   ALA A  22      41.296 -13.462  12.121  1.00 16.83           O  
ATOM    126  CB  ALA A  22      39.932 -11.331  10.071  1.00 13.99           C  
ATOM    127  N   SER A  23      39.221 -12.936  12.837  1.00 15.85           N  
ATOM    128  CA  SER A  23      39.485 -13.252  14.255  1.00 17.23           C  
ATOM    129  C   SER A  23      39.610 -14.755  14.522  1.00 17.27           C  
ATOM    130  O   SER A  23      40.214 -15.158  15.513  1.00 17.49           O  
ATOM    131  CB  SER A  23      38.372 -12.728  15.168  1.00 17.43           C  
ATOM    132  OG  SER A  23      37.944 -11.420  14.826  1.00 22.52           O  
ATOM    133  N   HIS A  24      39.005 -15.569  13.656  1.00 16.17           N  
ATOM    134  CA  HIS A  24      38.945 -17.022  13.831  1.00 16.68           C  
ATOM    135  C   HIS A  24      38.945 -17.715  12.463  1.00 16.31           C  
ATOM    136  O   HIS A  24      37.938 -18.288  12.032  1.00 16.05           O  
ATOM    137  CB  HIS A  24      37.682 -17.410  14.651  1.00 16.85           C  
ATOM    138  N   PRO A  25      40.087 -17.655  11.788  1.00 16.86           N  
ATOM    139  CA  PRO A  25      40.219 -18.154  10.424  1.00 16.33           C  
ATOM    140  C   PRO A  25      39.832 -19.631  10.345  1.00 16.33           C  
ATOM    141  O   PRO A  25      40.150 -20.396  11.261  1.00 16.20           O  
ATOM    142  CB  PRO A  25      41.653 -17.951   9.935  1.00 16.95           C  
ATOM    143  N   PRO A  26      39.139 -20.048   9.264  1.00 15.96           N  
ATOM    144  CA  PRO A  26      38.785 -21.466   9.176  1.00 15.73           C  
ATOM    145  C   PRO A  26      40.006 -22.366   9.317  1.00 15.54           C  
ATOM    146  O   PRO A  26      41.076 -22.046   8.779  1.00 15.34           O  
ATOM    147  CB  PRO A  26      38.217 -21.599   7.758  1.00 16.16           C  
ATOM    148  CG  PRO A  26      37.681 -20.253   7.452  1.00 15.87           C  
ATOM    149  CD  PRO A  26      38.622 -19.283   8.112  1.00 16.27           C  
ATOM    150  N   VAL A  27      39.821 -23.487  10.017  1.00 15.82           N  
ATOM    151  CA  VAL A  27      40.894 -24.461  10.227  1.00 16.24           C  
ATOM    152  C   VAL A  27      40.773 -25.585   9.215  1.00 16.84           C  
ATOM    153  O   VAL A  27      39.713 -26.185   9.082  1.00 16.47           O  
ATOM    154  CB  VAL A  27      40.823 -25.014  11.622  1.00 16.32           C  
ATOM    155  N   GLU A  28      41.865 -25.879   8.509  1.00 17.35           N  
ATOM    156  CA  GLU A  28      41.844 -26.918   7.486  1.00 17.90           C  
ATOM    157  C   GLU A  28      41.374 -28.237   8.091  1.00 18.07           C  
ATOM    158  O   GLU A  28      41.863 -28.661   9.139  1.00 18.38           O  
ATOM    159  CB  GLU A  28      43.218 -27.058   6.827  1.00 18.46           C  
ATOM    160  N   GLY A  29      40.354 -28.824   7.463  1.00 18.18           N  
ATOM    161  CA  GLY A  29      39.796 -30.125   7.834  1.00 18.38           C  
ATOM    162  C   GLY A  29      38.590 -30.061   8.771  1.00 18.05           C  
ATOM    163  O   GLY A  29      37.853 -31.036   8.903  1.00 18.58           O  
ATOM    164  N   SER A  30      38.384 -28.911   9.400  1.00 17.44           N  
ATOM    165  CA  SER A  30      37.295 -28.771  10.338  1.00 16.41           C  
ATOM    166  C   SER A  30      35.922 -28.755   9.624  1.00 16.16           C  
ATOM    167  O   SER A  30      35.011 -29.483  10.023  1.00 16.83           O  
ATOM    168  CB  SER A  30      37.503 -27.541  11.185  1.00 16.65           C  
ATOM    169  N   TYR A  31      35.777 -27.947   8.572  1.00 14.74           N  
ATOM    170  CA  TYR A  31      34.521 -27.924   7.812  1.00 14.07           C  
ATOM    171  C   TYR A  31      34.502 -28.966   6.694  1.00 13.73           C  
ATOM    172  O   TYR A  31      35.405 -28.989   5.864  1.00 14.48           O  
ATOM    173  CB  TYR A  31      34.211 -26.537   7.221  1.00 13.89           C  
ATOM    174  CG  TYR A  31      32.942 -26.573   6.391  1.00 12.59           C  
ATOM    175  CD1 TYR A  31      31.695 -26.693   7.003  1.00 14.24           C  
ATOM    176  CD2 TYR A  31      32.990 -26.553   5.007  1.00 11.84           C  
ATOM    177  CE1 TYR A  31      30.521 -26.776   6.255  1.00 14.96           C  
ATOM    178  CE2 TYR A  31      31.811 -26.619   4.229  1.00 11.87           C  
ATOM    179  CZ  TYR A  31      30.586 -26.751   4.870  1.00 13.26           C  
ATOM    180  OH  TYR A  31      29.412 -26.837   4.158  1.00 14.31           O  
ATOM    181  N   ALA A  32      33.463 -29.799   6.674  1.00 13.28           N  
ATOM    182  CA  ALA A  32      33.276 -30.811   5.634  1.00 13.65           C  
ATOM    183  C   ALA A  32      32.048 -30.434   4.802  1.00 13.02           C  
ATOM    184  O   ALA A  32      30.962 -30.258   5.348  1.00 14.27           O  
ATOM    185  CB  ALA A  32      33.096 -32.187   6.260  1.00 14.64           C  
ATOM    186  N   PRO A  33      32.232 -30.316   3.490  1.00 13.08           N  
ATOM    187  CA  PRO A  33      31.159 -29.876   2.596  1.00 13.26           C  
ATOM    188  C   PRO A  33      30.113 -30.964   2.402  1.00 13.46           C  
ATOM    189  O   PRO A  33      30.452 -32.133   2.173  1.00 13.90           O  
ATOM    190  CB  PRO A  33      31.733 -29.455   1.249  1.00 13.84           C  
ATOM    191  N   ARG A  34      28.844 -30.595   2.515  1.00 12.70           N  
ATOM    192  CA  ARG A  34      27.760 -31.502   2.162  1.00 12.98           C  
ATOM    193  C   ARG A  34      26.698 -30.745   1.382  1.00 12.57           C  
ATOM    194  O   ARG A  34      26.426 -29.571   1.657  1.00 11.54           O  
ATOM    195  CB  ARG A  34      27.160 -32.142   3.409  1.00 14.13           C  
ATOM    196  N   ARG A  35      26.117 -31.425   0.394  1.00 11.58           N  
ATOM    197  CA  ARG A  35      25.143 -30.820  -0.490  1.00 10.64           C  
ATOM    198  C   ARG A  35      24.022 -30.172   0.299  1.00 10.06           C  
ATOM    199  O   ARG A  35      23.458 -30.774   1.224  1.00 10.34           O  
ATOM    200  CB  ARG A  35      24.587 -31.850  -1.487  1.00 10.80           C  
ATOM    201  CG  ARG A  35      23.734 -31.235  -2.561  1.00 10.90           C  
ATOM    202  CD  ARG A  35      22.961 -32.300  -3.333  1.00 14.85           C  
ATOM    203  NE  ARG A  35      23.717 -32.889  -4.429  1.00 19.14           N  
ATOM    204  CZ  ARG A  35      23.383 -32.826  -5.723  1.00 18.83           C  
ATOM    205  NH1 ARG A  35      22.291 -32.183  -6.131  1.00 19.19           N  
ATOM    206  NH2 ARG A  35      24.160 -33.417  -6.615  1.00 19.76           N  
ATOM    207  N   GLY A  36      23.731 -28.921  -0.066  1.00  9.39           N  
ATOM    208  CA  GLY A  36      22.630 -28.173   0.512  1.00 10.24           C  
ATOM    209  C   GLY A  36      22.980 -27.364   1.752  1.00  9.55           C  
ATOM    210  O   GLY A  36      22.173 -26.523   2.198  1.00 11.29           O  
ATOM    211  N   GLU A  37      24.171 -27.598   2.305  1.00 10.51           N  
ATOM    212  CA  GLU A  37      24.634 -26.864   3.489  1.00 10.26           C  
ATOM    213  C   GLU A  37      25.163 -25.506   3.090  1.00 10.03           C  
ATOM    214  O   GLU A  37      25.721 -25.342   2.003  1.00  9.59           O  
ATOM    215  CB  GLU A  37      25.718 -27.638   4.230  1.00 10.87           C  
ATOM    216  N   PHE A  38      24.975 -24.538   3.985  1.00  9.32           N  
ATOM    217  CA  PHE A  38      25.612 -23.229   3.846  1.00  9.33           C  
ATOM    218  C   PHE A  38      27.024 -23.259   4.437  1.00 10.00           C  
ATOM    219  O   PHE A  38      27.348 -24.052   5.330  1.00 11.29           O  
ATOM    220  CB  PHE A  38      24.766 -22.152   4.535  1.00  9.49           C  
ATOM    221  CG  PHE A  38      23.409 -21.955   3.912  1.00  9.71           C  
ATOM    222  CD1 PHE A  38      22.282 -22.609   4.413  1.00 10.29           C  
ATOM    223  CD2 PHE A  38      23.261 -21.120   2.815  1.00 10.46           C  
ATOM    224  CE1 PHE A  38      21.034 -22.411   3.815  1.00 12.80           C  
ATOM    225  CE2 PHE A  38      22.031 -20.929   2.224  1.00 10.65           C  
ATOM    226  CZ  PHE A  38      20.917 -21.577   2.722  1.00 12.32           C  
ATOM    227  N   CYS A  39      27.879 -22.404   3.894  1.00  8.76           N  
ATOM    228  CA  CYS A  39      29.257 -22.310   4.318  1.00  8.92           C  
ATOM    229  C   CYS A  39      29.783 -20.947   3.953  1.00  9.07           C  
ATOM    230  O   CYS A  39      29.051 -20.119   3.426  1.00  7.04           O  
ATOM    231  CB  CYS A  39      30.083 -23.407   3.640  1.00  9.88           C  
ATOM    232  SG  CYS A  39      30.132 -23.273   1.850  1.00 11.93           S  
ATOM    233  N   ILE A  40      31.056 -20.700   4.236  1.00  7.30           N  
ATOM    234  CA  ILE A  40      31.719 -19.556   3.633  1.00  7.17           C  
ATOM    235  C   ILE A  40      32.689 -20.087   2.575  1.00  6.57           C  
ATOM    236  O   ILE A  40      33.212 -21.197   2.705  1.00  7.57           O  
ATOM    237  CB  ILE A  40      32.430 -18.643   4.667  1.00  7.18           C  
ATOM    238  CG1 ILE A  40      33.417 -19.426   5.544  1.00  7.23           C  
ATOM    239  CG2 ILE A  40      31.398 -17.915   5.498  1.00  8.07           C  
ATOM    240  CD1 ILE A  40      34.315 -18.600   6.476  1.00  6.16           C  
ATOM    241  N   ALA A  41      32.901 -19.303   1.526  1.00  6.55           N  
ATOM    242  CA  ALA A  41      33.752 -19.686   0.410  1.00  7.00           C  
ATOM    243  C   ALA A  41      34.677 -18.534   0.072  1.00  6.77           C  
ATOM    244  O   ALA A  41      34.224 -17.373   0.033  1.00  7.27           O  
ATOM    245  CB  ALA A  41      32.892 -20.066  -0.802  1.00  8.18           C  
ATOM    246  N   LYS A  42      35.951 -18.853  -0.155  1.00  7.93           N  
ATOM    247  CA  LYS A  42      36.941 -17.845  -0.458  1.00  7.59           C  
ATOM    248  C   LYS A  42      37.060 -17.657  -1.957  1.00  8.24           C  
ATOM    249  O   LYS A  42      37.557 -18.529  -2.653  1.00  9.17           O  
ATOM    250  CB  LYS A  42      38.289 -18.244   0.143  1.00  8.67           C  
ATOM    251  CG  LYS A  42      39.167 -17.049   0.392  1.00 10.02           C  
ATOM    252  CD  LYS A  42      40.444 -17.466   1.116  1.00 13.40           C  
ATOM    253  CE  LYS A  42      41.299 -16.273   1.505  1.00 17.13           C  
ATOM    254  NZ  LYS A  42      42.578 -16.682   2.163  1.00 20.07           N  
ATOM    255  N   PHE A  43      36.579 -16.513  -2.447  1.00  8.28           N  
ATOM    256  CA  PHE A  43      36.487 -16.239  -3.881  1.00  9.61           C  
ATOM    257  C   PHE A  43      37.872 -15.876  -4.429  1.00 10.38           C  
ATOM    258  O   PHE A  43      38.847 -15.776  -3.671  1.00 10.99           O  
ATOM    259  CB  PHE A  43      35.479 -15.107  -4.080  1.00  9.52           C  
ATOM    260  CG  PHE A  43      35.127 -14.810  -5.506  1.00  9.45           C  
ATOM    261  CD1 PHE A  43      34.732 -15.823  -6.383  1.00 10.26           C  
ATOM    262  CD2 PHE A  43      35.136 -13.502  -5.955  1.00  9.98           C  
ATOM    263  CE1 PHE A  43      34.384 -15.539  -7.725  1.00 11.32           C  
ATOM    264  CE2 PHE A  43      34.792 -13.207  -7.294  1.00 12.02           C  
ATOM    265  CZ  PHE A  43      34.430 -14.230  -8.171  1.00 11.39           C  
ATOM    266  N   VAL A  44      37.961 -15.641  -5.737  1.00 10.56           N  
ATOM    267  CA  VAL A  44      39.246 -15.382  -6.389  1.00 12.17           C  
ATOM    268  C   VAL A  44      39.888 -14.049  -5.980  1.00 12.29           C  
ATOM    269  O   VAL A  44      41.070 -13.794  -6.282  1.00 13.89           O  
ATOM    270  CB  VAL A  44      39.124 -15.443  -7.932  1.00 12.04           C  
ATOM    271  CG1 VAL A  44      38.571 -16.792  -8.390  1.00 12.53           C  
ATOM    272  CG2 VAL A  44      38.313 -14.252  -8.463  1.00 14.43           C  
ATOM    273  N   ASP A  45      39.128 -13.191  -5.307  1.00 11.75           N  
ATOM    274  CA  ASP A  45      39.655 -11.914  -4.806  1.00 11.56           C  
ATOM    275  C   ASP A  45      40.303 -12.041  -3.417  1.00 11.69           C  
ATOM    276  O   ASP A  45      40.764 -11.050  -2.834  1.00 12.71           O  
ATOM    277  CB  ASP A  45      38.561 -10.834  -4.808  1.00 12.03           C  
ATOM    278  CG  ASP A  45      37.335 -11.216  -3.974  1.00 12.79           C  
ATOM    279  OD1 ASP A  45      37.280 -12.348  -3.452  1.00 13.95           O  
ATOM    280  OD2 ASP A  45      36.428 -10.358  -3.844  1.00 13.84           O  
ATOM    281  N   GLY A  46      40.342 -13.269  -2.910  1.00 12.07           N  
ATOM    282  CA  GLY A  46      40.897 -13.548  -1.599  1.00 11.77           C  
ATOM    283  C   GLY A  46      39.959 -13.162  -0.464  1.00 11.72           C  
ATOM    284  O   GLY A  46      40.352 -13.187   0.703  1.00 12.53           O  
ATOM    285  N   GLU A  47      38.713 -12.818  -0.802  1.00 11.04           N  
ATOM    286  CA  GLU A  47      37.694 -12.480   0.202  1.00 10.73           C  
ATOM    287  C   GLU A  47      36.695 -13.621   0.429  1.00  9.61           C  
ATOM    288  O   GLU A  47      36.423 -14.417  -0.484  1.00  8.04           O  
ATOM    289  CB  GLU A  47      36.942 -11.190  -0.170  1.00 11.61           C  
ATOM    290  CG  GLU A  47      37.804  -9.903  -0.225  1.00 13.87           C  
ATOM    291  CD  GLU A  47      38.368  -9.453   1.131  1.00 19.30           C  
ATOM    292  OE1 GLU A  47      37.801  -9.790   2.188  1.00 19.25           O  
ATOM    293  OE2 GLU A  47      39.387  -8.727   1.129  1.00 22.42           O  
ATOM    294  N   TRP A  48      36.141 -13.676   1.647  1.00  7.80           N  
ATOM    295  CA  TRP A  48      35.176 -14.706   2.033  1.00  7.49           C  
ATOM    296  C   TRP A  48      33.754 -14.203   1.763  1.00  6.22           C  
ATOM    297  O   TRP A  48      33.429 -13.021   1.977  1.00  8.16           O  
ATOM    298  CB  TRP A  48      35.297 -15.074   3.514  1.00  7.64           C  
ATOM    299  CG  TRP A  48      36.557 -15.828   3.864  1.00  8.14           C  
ATOM    300  CD1 TRP A  48      37.715 -15.275   4.341  1.00  9.85           C  
ATOM    301  CD2 TRP A  48      36.810 -17.248   3.748  1.00  7.56           C  
ATOM    302  NE1 TRP A  48      38.668 -16.263   4.544  1.00  9.76           N  
ATOM    303  CE2 TRP A  48      38.142 -17.476   4.173  1.00  8.96           C  
ATOM    304  CE3 TRP A  48      36.046 -18.346   3.315  1.00  8.13           C  
ATOM    305  CZ2 TRP A  48      38.713 -18.750   4.198  1.00  9.76           C  
ATOM    306  CZ3 TRP A  48      36.612 -19.607   3.346  1.00  8.12           C  
ATOM    307  CH2 TRP A  48      37.936 -19.803   3.780  1.00  8.47           C  
ATOM    308  N   TYR A  49      32.928 -15.131   1.288  1.00  6.59           N  
ATOM    309  CA  TYR A  49      31.532 -14.875   0.930  1.00  5.81           C  
ATOM    310  C   TYR A  49      30.639 -15.981   1.453  1.00  6.55           C  
ATOM    311  O   TYR A  49      31.103 -17.105   1.642  1.00  6.22           O  
ATOM    312  CB  TYR A  49      31.359 -14.806  -0.605  1.00  6.84           C  
ATOM    313  CG  TYR A  49      32.025 -13.621  -1.283  1.00  4.42           C  
ATOM    314  CD1 TYR A  49      31.287 -12.513  -1.681  1.00  6.47           C  
ATOM    315  CD2 TYR A  49      33.386 -13.649  -1.558  1.00  6.71           C  
ATOM    316  CE1 TYR A  49      31.898 -11.430  -2.309  1.00  8.18           C  
ATOM    317  CE2 TYR A  49      33.999 -12.582  -2.198  1.00  6.74           C  
ATOM    318  CZ  TYR A  49      33.251 -11.472  -2.560  1.00  7.87           C  
ATOM    319  OH  TYR A  49      33.860 -10.408  -3.201  1.00  8.51           O  
ATOM    320  N   ARG A  50      29.361 -15.689   1.671  1.00  5.91           N  
ATOM    321  CA  ARG A  50      28.412 -16.744   2.034  1.00  6.00           C  
ATOM    322  C   ARG A  50      28.097 -17.608   0.801  1.00  6.57           C  
ATOM    323  O   ARG A  50      27.941 -17.122  -0.333  1.00  6.30           O  
ATOM    324  CB  ARG A  50      27.110 -16.176   2.630  1.00  6.85           C  
ATOM    325  CG  ARG A  50      27.338 -15.200   3.767  1.00  6.36           C  
ATOM    326  CD  ARG A  50      26.056 -14.930   4.563  1.00  6.42           C  
ATOM    327  NE  ARG A  50      25.027 -14.283   3.766  1.00  8.38           N  
ATOM    328  CZ  ARG A  50      23.771 -14.138   4.168  1.00  8.14           C  
ATOM    329  NH1 ARG A  50      23.408 -14.549   5.386  1.00  5.80           N  
ATOM    330  NH2 ARG A  50      22.889 -13.541   3.375  1.00  7.81           N  
ATOM    331  N   ALA A  51      27.996 -18.915   1.028  1.00  6.13           N  
ATOM    332  CA  ALA A  51      27.764 -19.823  -0.077  1.00  6.66           C  
ATOM    333  C   ALA A  51      26.954 -21.029   0.347  1.00  7.06           C  
ATOM    334  O   ALA A  51      26.726 -21.282   1.527  1.00  7.33           O  
ATOM    335  CB  ALA A  51      29.105 -20.262  -0.713  1.00  7.24           C  
ATOM    336  N   ARG A  52      26.466 -21.741  -0.661  1.00  6.95           N  
ATOM    337  CA  ARG A  52      25.765 -23.002  -0.443  1.00  8.40           C  
ATOM    338  C   ARG A  52      26.374 -24.082  -1.334  1.00  7.82           C  
ATOM    339  O   ARG A  52      26.687 -23.842  -2.499  1.00  7.57           O  
ATOM    340  CB  ARG A  52      24.270 -22.860  -0.736  1.00  9.34           C  
ATOM    341  CG  ARG A  52      23.431 -23.884   0.004  1.00 14.05           C  
ATOM    342  CD  ARG A  52      22.057 -24.083  -0.612  1.00 21.67           C  
ATOM    343  NE  ARG A  52      21.107 -23.043  -0.246  1.00 27.25           N  
ATOM    344  CZ  ARG A  52      19.778 -23.186  -0.266  1.00 30.14           C  
ATOM    345  NH1 ARG A  52      19.225 -24.340  -0.628  1.00 31.61           N  
ATOM    346  NH2 ARG A  52      18.997 -22.171   0.080  1.00 31.46           N  
ATOM    347  N   VAL A  53      26.552 -25.275  -0.765  1.00  7.72           N  
ATOM    348  CA  VAL A  53      27.152 -26.377  -1.514  1.00  7.95           C  
ATOM    349  C   VAL A  53      26.088 -27.000  -2.440  1.00  7.94           C  
ATOM    350  O   VAL A  53      25.004 -27.385  -1.979  1.00  8.14           O  
ATOM    351  CB  VAL A  53      27.771 -27.442  -0.557  1.00  7.49           C  
ATOM    352  CG1 VAL A  53      28.299 -28.625  -1.347  1.00  8.67           C  
ATOM    353  CG2 VAL A  53      28.945 -26.853   0.306  1.00  9.36           C  
ATOM    354  N   GLU A  54      26.399 -27.077  -3.737  1.00  8.91           N  
ATOM    355  CA  GLU A  54      25.491 -27.660  -4.729  1.00 10.14           C  
ATOM    356  C   GLU A  54      25.848 -29.084  -5.180  1.00 10.92           C  
ATOM    357  O   GLU A  54      24.947 -29.840  -5.601  1.00 11.78           O  
ATOM    358  CB  GLU A  54      25.357 -26.732  -5.936  1.00 11.42           C  
ATOM    359  CG  GLU A  54      24.614 -25.454  -5.569  1.00 12.99           C  
ATOM    360  CD  GLU A  54      24.185 -24.637  -6.764  1.00 15.12           C  
ATOM    361  OE1 GLU A  54      24.947 -24.572  -7.753  1.00 17.54           O  
ATOM    362  OE2 GLU A  54      23.085 -24.047  -6.696  1.00 18.66           O  
ATOM    363  N   LYS A  55      27.134 -29.443  -5.100  1.00 10.13           N  
ATOM    364  CA  LYS A  55      27.586 -30.773  -5.521  1.00 11.57           C  
ATOM    365  C   LYS A  55      29.014 -30.987  -5.061  1.00 11.31           C  
ATOM    366  O   LYS A  55      29.861 -30.094  -5.173  1.00 11.70           O  
ATOM    367  CB  LYS A  55      27.489 -30.920  -7.037  1.00 11.44           C  
ATOM    368  CG  LYS A  55      27.993 -32.243  -7.604  1.00 14.80           C  
ATOM    369  CD  LYS A  55      27.772 -32.275  -9.104  1.00 18.11           C  
ATOM    370  CE  LYS A  55      28.952 -32.936  -9.806  1.00 22.97           C  
ATOM    371  NZ  LYS A  55      28.901 -32.783 -11.304  1.00 25.41           N  
ATOM    372  N   VAL A  56      29.282 -32.196  -4.577  1.00 11.94           N  
ATOM    373  CA  VAL A  56      30.616 -32.594  -4.192  1.00 13.37           C  
ATOM    374  C   VAL A  56      31.159 -33.556  -5.240  1.00 14.42           C  
ATOM    375  O   VAL A  56      30.690 -34.705  -5.359  1.00 15.27           O  
ATOM    376  CB  VAL A  56      30.639 -33.239  -2.789  1.00 12.94           C  
ATOM    377  CG1 VAL A  56      32.034 -33.700  -2.468  1.00 13.48           C  
ATOM    378  CG2 VAL A  56      30.169 -32.260  -1.738  1.00 13.45           C  
ATOM    379  N   GLU A  57      32.149 -33.078  -5.989  1.00 14.85           N  
ATOM    380  CA  GLU A  57      32.777 -33.859  -7.058  1.00 17.44           C  
ATOM    381  C   GLU A  57      33.983 -34.641  -6.518  1.00 16.69           C  
ATOM    382  O   GLU A  57      34.130 -35.850  -6.779  1.00 17.75           O  
ATOM    383  CB  GLU A  57      33.164 -32.920  -8.214  1.00 17.03           C  
ATOM    384  CG  GLU A  57      33.786 -33.594  -9.454  1.00 19.50           C  
ATOM    385  CD  GLU A  57      34.210 -32.604 -10.547  1.00 20.48           C  
ATOM    386  OE1 GLU A  57      35.007 -33.008 -11.424  1.00 22.98           O  
ATOM    387  OE2 GLU A  57      33.763 -31.434 -10.553  1.00 23.49           O  
ATOM    388  N   SER A  58      34.832 -33.953  -5.761  1.00 16.72           N  
ATOM    389  CA  SER A  58      35.995 -34.544  -5.097  1.00 15.59           C  
ATOM    390  C   SER A  58      36.475 -33.594  -3.999  1.00 15.52           C  
ATOM    391  O   SER A  58      35.955 -32.488  -3.889  1.00 15.12           O  
ATOM    392  CB  SER A  58      37.097 -34.821  -6.131  1.00 15.52           C  
ATOM    393  OG  SER A  58      37.730 -33.634  -6.577  1.00 16.88           O  
ATOM    394  N   PRO A  59      37.438 -34.011  -3.156  1.00 14.52           N  
ATOM    395  CA  PRO A  59      37.960 -33.071  -2.167  1.00 14.85           C  
ATOM    396  C   PRO A  59      38.476 -31.743  -2.720  1.00 14.65           C  
ATOM    397  O   PRO A  59      38.463 -30.732  -1.998  1.00 14.96           O  
ATOM    398  CB  PRO A  59      39.095 -33.867  -1.539  1.00 14.79           C  
ATOM    399  CG  PRO A  59      38.608 -35.268  -1.615  1.00 14.11           C  
ATOM    400  CD  PRO A  59      38.055 -35.344  -2.986  1.00 14.37           C  
ATOM    401  N   ALA A  60      38.907 -31.740  -3.987  1.00 14.00           N  
ATOM    402  CA  ALA A  60      39.461 -30.544  -4.612  1.00 14.09           C  
ATOM    403  C   ALA A  60      38.407 -29.829  -5.447  1.00 13.95           C  
ATOM    404  O   ALA A  60      38.667 -28.744  -5.947  1.00 14.68           O  
ATOM    405  CB  ALA A  60      40.672 -30.893  -5.477  1.00 14.66           C  
ATOM    406  N   LYS A  61      37.233 -30.441  -5.608  1.00 13.50           N  
ATOM    407  CA  LYS A  61      36.213 -29.885  -6.498  1.00 13.26           C  
ATOM    408  C   LYS A  61      34.801 -29.870  -5.909  1.00 12.70           C  
ATOM    409  O   LYS A  61      34.016 -30.807  -6.074  1.00 12.88           O  
ATOM    410  CB  LYS A  61      36.251 -30.551  -7.885  1.00 14.17           C  
ATOM    411  CG  LYS A  61      37.495 -30.142  -8.684  1.00 14.50           C  
ATOM    412  CD  LYS A  61      37.554 -30.807 -10.058  1.00 14.60           C  
ATOM    413  CE  LYS A  61      38.922 -30.619 -10.697  1.00 18.45           C  
ATOM    414  NZ  LYS A  61      38.962 -31.231 -12.062  1.00 20.20           N  
ATOM    415  N   ILE A  62      34.499 -28.779  -5.216  1.00 10.99           N  
ATOM    416  CA  ILE A  62      33.206 -28.589  -4.579  1.00 10.38           C  
ATOM    417  C   ILE A  62      32.480 -27.470  -5.305  1.00  9.57           C  
ATOM    418  O   ILE A  62      33.015 -26.371  -5.430  1.00  9.85           O  
ATOM    419  CB  ILE A  62      33.363 -28.246  -3.081  1.00 10.81           C  
ATOM    420  CG1 ILE A  62      34.289 -29.271  -2.424  1.00 13.60           C  
ATOM    421  CG2 ILE A  62      32.002 -28.184  -2.396  1.00 10.34           C  
ATOM    422  CD1 ILE A  62      34.595 -29.060  -0.985  1.00 19.47           C  
ATOM    423  N   HIS A  63      31.285 -27.775  -5.813  1.00  8.72           N  
ATOM    424  CA  HIS A  63      30.475 -26.812  -6.557  1.00  9.01           C  
ATOM    425  C   HIS A  63      29.687 -26.004  -5.551  1.00  8.69           C  
ATOM    426  O   HIS A  63      28.914 -26.563  -4.792  1.00  8.99           O  
ATOM    427  CB  HIS A  63      29.510 -27.509  -7.525  1.00 10.21           C  
ATOM    428  CG  HIS A  63      30.187 -28.314  -8.596  1.00 11.62           C  
ATOM    429  ND1 HIS A  63      31.167 -29.246  -8.328  1.00 15.19           N  
ATOM    430  CD2 HIS A  63      29.978 -28.361  -9.932  1.00 14.31           C  
ATOM    431  CE1 HIS A  63      31.566 -29.801  -9.459  1.00 15.96           C  
ATOM    432  NE2 HIS A  63      30.846 -29.298 -10.445  1.00 14.96           N  
ATOM    433  N   VAL A  64      29.904 -24.690  -5.545  1.00  7.77           N  
ATOM    434  CA  VAL A  64      29.152 -23.799  -4.657  1.00  8.19           C  
ATOM    435  C   VAL A  64      28.424 -22.681  -5.390  1.00  8.74           C  
ATOM    436  O   VAL A  64      28.754 -22.330  -6.530  1.00  8.21           O  
ATOM    437  CB  VAL A  64      30.050 -23.156  -3.562  1.00  8.10           C  
ATOM    438  CG1 VAL A  64      30.758 -24.250  -2.749  1.00  9.03           C  
ATOM    439  CG2 VAL A  64      31.038 -22.120  -4.164  1.00  7.74           C  
ATOM    440  N   PHE A  65      27.446 -22.125  -4.696  1.00  7.92           N  
ATOM    441  CA  PHE A  65      26.628 -21.017  -5.171  1.00  7.55           C  
ATOM    442  C   PHE A  65      26.816 -19.905  -4.155  1.00  6.71           C  
ATOM    443  O   PHE A  65      26.581 -20.104  -2.966  1.00  6.44           O  
ATOM    444  CB  PHE A  65      25.161 -21.463  -5.219  1.00  8.39           C  
ATOM    445  CG  PHE A  65      24.173 -20.367  -5.531  1.00  8.22           C  
ATOM    446  CD1 PHE A  65      24.033 -19.918  -6.827  1.00 11.38           C  
ATOM    447  CD2 PHE A  65      23.314 -19.862  -4.545  1.00 11.16           C  
ATOM    448  CE1 PHE A  65      23.083 -18.915  -7.144  1.00 12.53           C  
ATOM    449  CE2 PHE A  65      22.378 -18.864  -4.847  1.00 11.65           C  
ATOM    450  CZ  PHE A  65      22.266 -18.400  -6.156  1.00 11.67           C  
ATOM    451  N   TYR A  66      27.284 -18.751  -4.632  1.00  7.49           N  
ATOM    452  CA  TYR A  66      27.457 -17.585  -3.781  1.00  7.11           C  
ATOM    453  C   TYR A  66      26.084 -16.947  -3.556  1.00  6.88           C  
ATOM    454  O   TYR A  66      25.534 -16.296  -4.462  1.00  6.36           O  
ATOM    455  CB  TYR A  66      28.436 -16.598  -4.423  1.00  7.67           C  
ATOM    456  CG  TYR A  66      29.852 -17.075  -4.394  1.00  8.49           C  
ATOM    457  CD1 TYR A  66      30.630 -16.925  -3.259  1.00  8.17           C  
ATOM    458  CD2 TYR A  66      30.420 -17.674  -5.508  1.00 10.47           C  
ATOM    459  CE1 TYR A  66      31.951 -17.375  -3.230  1.00  9.97           C  
ATOM    460  CE2 TYR A  66      31.761 -18.115  -5.493  1.00 12.04           C  
ATOM    461  CZ  TYR A  66      32.502 -17.959  -4.353  1.00 11.25           C  
ATOM    462  OH  TYR A  66      33.814 -18.388  -4.311  1.00 11.44           O  
ATOM    463  N   ILE A  67      25.531 -17.119  -2.354  1.00  7.14           N  
ATOM    464  CA  ILE A  67      24.124 -16.840  -2.145  1.00  7.34           C  
ATOM    465  C   ILE A  67      23.761 -15.373  -2.177  1.00  7.59           C  
ATOM    466  O   ILE A  67      22.596 -15.046  -2.337  1.00  8.49           O  
ATOM    467  CB  ILE A  67      23.566 -17.476  -0.829  1.00  7.60           C  
ATOM    468  CG1 ILE A  67      24.181 -16.828   0.424  1.00  7.26           C  
ATOM    469  CG2 ILE A  67      23.770 -18.987  -0.854  1.00  7.87           C  
ATOM    470  CD1 ILE A  67      23.501 -17.217   1.772  1.00  7.54           C  
ATOM    471  N   ASP A  68      24.758 -14.507  -2.040  1.00  6.63           N  
ATOM    472  CA  ASP A  68      24.497 -13.065  -2.057  1.00  7.05           C  
ATOM    473  C   ASP A  68      24.788 -12.407  -3.390  1.00  9.18           C  
ATOM    474  O   ASP A  68      24.514 -11.209  -3.556  1.00  7.85           O  
ATOM    475  CB  ASP A  68      25.265 -12.378  -0.921  1.00  7.68           C  
ATOM    476  CG  ASP A  68      24.842 -12.870   0.451  1.00  6.89           C  
ATOM    477  OD1 ASP A  68      23.614 -12.997   0.670  1.00  7.64           O  
ATOM    478  OD2 ASP A  68      25.733 -13.114   1.310  1.00  6.50           O  
ATOM    479  N   TYR A  69      25.302 -13.189  -4.338  1.00  9.32           N  
ATOM    480  CA  TYR A  69      25.764 -12.673  -5.628  1.00 11.47           C  
ATOM    481  C   TYR A  69      25.247 -13.437  -6.851  1.00 12.87           C  
ATOM    482  O   TYR A  69      25.200 -12.873  -7.945  1.00 15.01           O  
ATOM    483  CB  TYR A  69      27.302 -12.561  -5.614  1.00 12.57           C  
ATOM    484  CG  TYR A  69      27.769 -11.485  -4.658  1.00 13.30           C  
ATOM    485  CD1 TYR A  69      27.887 -10.164  -5.092  1.00 14.89           C  
ATOM    486  CD2 TYR A  69      28.039 -11.765  -3.307  1.00 13.30           C  
ATOM    487  CE1 TYR A  69      28.269  -9.169  -4.232  1.00 15.28           C  
ATOM    488  CE2 TYR A  69      28.439 -10.756  -2.431  1.00 14.23           C  
ATOM    489  CZ  TYR A  69      28.554  -9.452  -2.911  1.00 15.88           C  
ATOM    490  OH  TYR A  69      28.929  -8.433  -2.050  1.00 18.62           O  
ATOM    491  N   GLY A  70      24.878 -14.709  -6.693  1.00 12.41           N  
ATOM    492  CA  GLY A  70      24.196 -15.443  -7.776  1.00 12.77           C  
ATOM    493  C   GLY A  70      25.049 -16.223  -8.760  1.00 13.80           C  
ATOM    494  O   GLY A  70      24.538 -16.810  -9.727  1.00 15.56           O  
ATOM    495  N   ASN A  71      26.350 -16.266  -8.507  1.00 11.91           N  
ATOM    496  CA  ASN A  71      27.284 -16.996  -9.358  1.00 12.06           C  
ATOM    497  C   ASN A  71      27.728 -18.278  -8.696  1.00 11.00           C  
ATOM    498  O   ASN A  71      27.557 -18.465  -7.492  1.00  9.86           O  
ATOM    499  CB  ASN A  71      28.524 -16.162  -9.645  1.00 13.54           C  
ATOM    500  CG  ASN A  71      29.359 -15.948  -8.415  1.00 15.80           C  
ATOM    501  OD1 ASN A  71      28.836 -15.519  -7.390  1.00 17.84           O  
ATOM    502  ND2 ASN A  71      30.666 -16.235  -8.499  1.00 20.38           N  
ATOM    503  N   ARG A  72      28.342 -19.130  -9.500  1.00 10.26           N  
ATOM    504  CA  ARG A  72      28.845 -20.411  -9.044  1.00 10.82           C  
ATOM    505  C   ARG A  72      30.349 -20.523  -9.233  1.00 11.23           C  
ATOM    506  O   ARG A  72      30.951 -19.822 -10.063  1.00 12.12           O  
ATOM    507  CB  ARG A  72      28.116 -21.531  -9.779  1.00 10.82           C  
ATOM    508  CG  ARG A  72      26.661 -21.578  -9.441  1.00 11.43           C  
ATOM    509  CD  ARG A  72      25.858 -22.570 -10.226  1.00 16.64           C  
ATOM    510  NE  ARG A  72      24.572 -22.766  -9.565  1.00 20.12           N  
ATOM    511  CZ  ARG A  72      23.525 -21.948  -9.655  1.00 22.27           C  
ATOM    512  NH1 ARG A  72      23.575 -20.851 -10.410  1.00 21.85           N  
ATOM    513  NH2 ARG A  72      22.414 -22.234  -8.988  1.00 24.71           N  
ATOM    514  N   GLU A  73      30.962 -21.390  -8.436  1.00 10.61           N  
ATOM    515  CA  GLU A  73      32.376 -21.677  -8.575  1.00 11.24           C  
ATOM    516  C   GLU A  73      32.622 -23.092  -8.128  1.00 11.43           C  
ATOM    517  O   GLU A  73      31.898 -23.604  -7.277  1.00 10.84           O  
ATOM    518  CB  GLU A  73      33.233 -20.709  -7.734  1.00 10.72           C  
ATOM    519  CG  GLU A  73      34.733 -20.812  -8.026  1.00 11.40           C  
ATOM    520  CD  GLU A  73      35.591 -19.843  -7.208  1.00 12.76           C  
ATOM    521  OE1 GLU A  73      36.821 -19.840  -7.389  1.00 14.44           O  
ATOM    522  OE2 GLU A  73      35.055 -19.087  -6.378  1.00 14.95           O  
ATOM    523  N   VAL A  74      33.646 -23.716  -8.711  1.00 11.98           N  
ATOM    524  CA  VAL A  74      34.132 -25.011  -8.276  1.00 12.92           C  
ATOM    525  C   VAL A  74      35.448 -24.764  -7.572  1.00 13.54           C  
ATOM    526  O   VAL A  74      36.398 -24.234  -8.167  1.00 14.80           O  
ATOM    527  CB  VAL A  74      34.364 -25.960  -9.461  1.00 12.80           C  
ATOM    528  CG1 VAL A  74      34.911 -27.287  -8.953  1.00 13.58           C  
ATOM    529  CG2 VAL A  74      33.056 -26.186 -10.225  1.00 12.51           C  
ATOM    530  N   LEU A  75      35.513 -25.126  -6.296  1.00 13.44           N  
ATOM    531  CA  LEU A  75      36.712 -24.843  -5.512  1.00 14.25           C  
ATOM    532  C   LEU A  75      37.081 -25.964  -4.551  1.00 13.22           C  
ATOM    533  O   LEU A  75      36.259 -26.822  -4.248  1.00 12.25           O  
ATOM    534  CB  LEU A  75      36.616 -23.490  -4.789  1.00 15.99           C  
ATOM    535  CG  LEU A  75      35.282 -22.872  -4.396  1.00 17.07           C  
ATOM    536  CD1 LEU A  75      34.436 -23.855  -3.580  1.00 20.86           C  
ATOM    537  CD2 LEU A  75      35.486 -21.568  -3.655  1.00 15.99           C  
ATOM    538  N   PRO A  76      38.333 -25.965  -4.077  1.00 12.74           N  
ATOM    539  CA  PRO A  76      38.747 -27.029  -3.182  1.00 12.92           C  
ATOM    540  C   PRO A  76      38.180 -26.826  -1.768  1.00 13.41           C  
ATOM    541  O   PRO A  76      37.810 -25.705  -1.412  1.00 12.87           O  
ATOM    542  CB  PRO A  76      40.273 -26.912  -3.192  1.00 12.86           C  
ATOM    543  CG  PRO A  76      40.539 -25.467  -3.415  1.00 14.03           C  
ATOM    544  CD  PRO A  76      39.418 -24.996  -4.335  1.00 13.02           C  
ATOM    545  N   SER A  77      38.110 -27.905  -0.988  1.00 14.51           N  
ATOM    546  CA  SER A  77      37.651 -27.853   0.401  1.00 15.00           C  
ATOM    547  C   SER A  77      38.431 -26.855   1.256  1.00 14.09           C  
ATOM    548  O   SER A  77      37.915 -26.336   2.253  1.00 13.74           O  
ATOM    549  CB  SER A  77      37.712 -29.252   1.046  1.00 16.06           C  
ATOM    550  OG  SER A  77      37.594 -29.145   2.455  1.00 22.19           O  
ATOM    551  N   THR A  78      39.683 -26.598   0.875  1.00 13.92           N  
ATOM    552  CA  THR A  78      40.556 -25.711   1.639  1.00 14.96           C  
ATOM    553  C   THR A  78      40.027 -24.271   1.621  1.00 13.76           C  
ATOM    554  O   THR A  78      40.293 -23.502   2.539  1.00 14.77           O  
ATOM    555  CB  THR A  78      42.021 -25.743   1.136  1.00 15.98           C  
ATOM    556  OG1 THR A  78      42.449 -27.098   0.951  1.00 19.42           O  
ATOM    557  CG2 THR A  78      42.942 -25.097   2.151  1.00 17.39           C  
ATOM    558  N   ARG A  79      39.248 -23.933   0.591  1.00 11.80           N  
ATOM    559  CA  ARG A  79      38.720 -22.584   0.456  1.00 11.23           C  
ATOM    560  C   ARG A  79      37.268 -22.492   0.919  1.00  9.42           C  
ATOM    561  O   ARG A  79      36.540 -21.566   0.543  1.00 10.11           O  
ATOM    562  CB  ARG A  79      38.861 -22.105  -0.982  1.00 10.10           C  
ATOM    563  CG  ARG A  79      40.317 -21.959  -1.393  1.00 12.61           C  
ATOM    564  CD  ARG A  79      40.451 -21.448  -2.802  1.00 15.74           C  
ATOM    565  NE  ARG A  79      40.229 -20.004  -2.876  1.00 17.57           N  
ATOM    566  CZ  ARG A  79      41.156 -19.082  -2.632  1.00 17.11           C  
ATOM    567  NH1 ARG A  79      42.387 -19.438  -2.263  1.00 17.10           N  
ATOM    568  NH2 ARG A  79      40.847 -17.791  -2.740  1.00 16.38           N  
ATOM    569  N   LEU A  80      36.855 -23.445   1.735  1.00  8.73           N  
ATOM    570  CA  LEU A  80      35.522 -23.424   2.328  1.00  8.38           C  
ATOM    571  C   LEU A  80      35.657 -23.449   3.841  1.00  8.09           C  
ATOM    572  O   LEU A  80      36.575 -24.022   4.385  1.00  9.50           O  
ATOM    573  CB  LEU A  80      34.666 -24.607   1.856  1.00  8.40           C  
ATOM    574  CG  LEU A  80      34.477 -24.770   0.350  1.00  8.76           C  
ATOM    575  CD1 LEU A  80      33.704 -26.027   0.100  1.00 11.21           C  
ATOM    576  CD2 LEU A  80      33.735 -23.597  -0.271  1.00 10.32           C  
ATOM    577  N   GLY A  81      34.706 -22.846   4.532  1.00  6.58           N  
ATOM    578  CA  GLY A  81      34.700 -22.858   5.983  1.00  7.37           C  
ATOM    579  C   GLY A  81      33.288 -22.865   6.543  1.00  7.23           C  
ATOM    580  O   GLY A  81      32.320 -22.725   5.807  1.00  8.53           O  
ATOM    581  N   THR A  82      33.180 -23.016   7.865  1.00  7.85           N  
ATOM    582  CA  THR A  82      31.892 -22.984   8.529  1.00  8.67           C  
ATOM    583  C   THR A  82      31.303 -21.584   8.464  1.00  8.64           C  
ATOM    584  O   THR A  82      31.996 -20.594   8.716  1.00  9.11           O  
ATOM    585  CB  THR A  82      32.033 -23.408  10.010  1.00  8.03           C  
ATOM    586  OG1 THR A  82      32.495 -24.770  10.058  1.00 10.15           O  
ATOM    587  CG2 THR A  82      30.706 -23.329  10.752  1.00  9.85           C  
ATOM    588  N   LEU A  83      30.007 -21.504   8.159  1.00  8.23           N  
ATOM    589  CA  LEU A  83      29.271 -20.249   8.260  1.00  9.11           C  
ATOM    590  C   LEU A  83      28.762 -20.098   9.687  1.00  9.64           C  
ATOM    591  O   LEU A  83      27.905 -20.851  10.130  1.00 11.99           O  
ATOM    592  CB  LEU A  83      28.092 -20.217   7.281  1.00  8.12           C  
ATOM    593  CG  LEU A  83      27.216 -18.961   7.275  1.00  9.31           C  
ATOM    594  CD1 LEU A  83      28.068 -17.739   6.931  1.00  7.70           C  
ATOM    595  CD2 LEU A  83      26.098 -19.126   6.259  1.00  9.48           C  
ATOM    596  N   SER A  84      29.316 -19.147  10.424  1.00 11.22           N  
ATOM    597  CA  SER A  84      28.881 -18.955  11.808  1.00 11.88           C  
ATOM    598  C   SER A  84      27.431 -18.537  11.874  1.00 12.27           C  
ATOM    599  O   SER A  84      26.950 -17.841  10.982  1.00 10.46           O  
ATOM    600  CB  SER A  84      29.762 -17.953  12.532  1.00 13.17           C  
ATOM    601  OG  SER A  84      30.092 -16.873  11.699  1.00 19.63           O  
ATOM    602  N   PRO A  85      26.706 -19.030  12.896  1.00 12.42           N  
ATOM    603  CA  PRO A  85      25.292 -18.710  13.072  1.00 12.91           C  
ATOM    604  C   PRO A  85      24.977 -17.204  13.028  1.00 12.58           C  
ATOM    605  O   PRO A  85      23.898 -16.837  12.568  1.00 13.12           O  
ATOM    606  CB  PRO A  85      24.976 -19.289  14.457  1.00 13.18           C  
ATOM    607  CG  PRO A  85      25.941 -20.417  14.613  1.00 13.97           C  
ATOM    608  CD  PRO A  85      27.192 -20.003  13.902  1.00 12.73           C  
ATOM    609  N   ALA A  86      25.904 -16.360  13.482  1.00 12.52           N  
ATOM    610  CA  ALA A  86      25.718 -14.899  13.508  1.00 12.25           C  
ATOM    611  C   ALA A  86      25.549 -14.278  12.125  1.00 11.58           C  
ATOM    612  O   ALA A  86      25.077 -13.148  12.010  1.00 12.16           O  
ATOM    613  CB  ALA A  86      26.870 -14.225  14.253  1.00 12.44           C  
ATOM    614  N   PHE A  87      25.935 -15.023  11.086  1.00 10.45           N  
ATOM    615  CA  PHE A  87      25.893 -14.532   9.701  1.00  9.91           C  
ATOM    616  C   PHE A  87      25.094 -15.433   8.781  1.00  9.11           C  
ATOM    617  O   PHE A  87      25.232 -15.372   7.554  1.00  8.99           O  
ATOM    618  CB  PHE A  87      27.319 -14.349   9.178  1.00  9.75           C  
ATOM    619  CG  PHE A  87      28.204 -13.651  10.161  1.00 10.67           C  
ATOM    620  CD1 PHE A  87      27.961 -12.325  10.525  1.00 12.63           C  
ATOM    621  CD2 PHE A  87      29.215 -14.344  10.794  1.00 11.81           C  
ATOM    622  CE1 PHE A  87      28.750 -11.695  11.491  1.00 13.02           C  
ATOM    623  CE2 PHE A  87      30.009 -13.712  11.752  1.00 13.06           C  
ATOM    624  CZ  PHE A  87      29.770 -12.389  12.088  1.00 13.42           C  
ATOM    625  N   SER A  88      24.247 -16.259   9.395  1.00  9.50           N  
ATOM    626  CA  SER A  88      23.422 -17.224   8.677  1.00  9.78           C  
ATOM    627  C   SER A  88      22.244 -16.547   7.953  1.00  9.08           C  
ATOM    628  O   SER A  88      22.005 -15.333   8.085  1.00  8.46           O  
ATOM    629  CB  SER A  88      22.879 -18.251   9.660  1.00 10.33           C  
ATOM    630  OG  SER A  88      21.880 -17.687  10.482  1.00 12.56           O  
ATOM    631  N   THR A  89      21.506 -17.348   7.186  1.00  9.54           N  
ATOM    632  CA  THR A  89      20.326 -16.861   6.487  1.00 10.48           C  
ATOM    633  C   THR A  89      19.148 -16.602   7.417  1.00 11.01           C  
ATOM    634  O   THR A  89      18.155 -16.003   7.004  1.00 11.02           O  
ATOM    635  CB  THR A  89      19.889 -17.796   5.343  1.00 10.45           C  
ATOM    636  OG1 THR A  89      19.732 -19.132   5.837  1.00 13.43           O  
ATOM    637  CG2 THR A  89      20.915 -17.785   4.212  1.00 11.31           C  
ATOM    638  N   ARG A  90      19.263 -17.050   8.664  1.00 10.98           N  
ATOM    639  CA  ARG A  90      18.308 -16.652   9.701  1.00 11.79           C  
ATOM    640  C   ARG A  90      18.505 -15.181  10.056  1.00 12.16           C  
ATOM    641  O   ARG A  90      17.570 -14.512  10.477  1.00 14.09           O  
ATOM    642  CB  ARG A  90      18.473 -17.538  10.955  1.00 12.18           C  
ATOM    643  N   VAL A  91      19.734 -14.686   9.896  1.00 12.40           N  
ATOM    644  CA  VAL A  91      20.072 -13.290  10.214  1.00 11.61           C  
ATOM    645  C   VAL A  91      19.796 -12.346   9.032  1.00 11.55           C  
ATOM    646  O   VAL A  91      19.166 -11.286   9.197  1.00 11.34           O  
ATOM    647  CB  VAL A  91      21.535 -13.171  10.704  1.00 12.01           C  
ATOM    648  CG1 VAL A  91      21.925 -11.709  10.928  1.00 11.38           C  
ATOM    649  CG2 VAL A  91      21.735 -13.978  11.994  1.00 13.46           C  
ATOM    650  N   LEU A  92      20.278 -12.713   7.850  1.00 10.49           N  
ATOM    651  CA  LEU A  92      19.960 -11.977   6.634  1.00 10.13           C  
ATOM    652  C   LEU A  92      19.765 -12.986   5.518  1.00 10.20           C  
ATOM    653  O   LEU A  92      20.664 -13.777   5.262  1.00 10.43           O  
ATOM    654  CB  LEU A  92      21.083 -11.000   6.255  1.00 10.47           C  
ATOM    655  CG  LEU A  92      20.874 -10.122   5.015  1.00 10.62           C  
ATOM    656  CD1 LEU A  92      19.828  -9.039   5.289  1.00 12.68           C  
ATOM    657  CD2 LEU A  92      22.205  -9.531   4.603  1.00 12.44           C  
ATOM    658  N   PRO A  93      18.592 -12.972   4.851  1.00 10.99           N  
ATOM    659  CA  PRO A  93      18.337 -13.904   3.753  1.00 10.94           C  
ATOM    660  C   PRO A  93      19.356 -13.755   2.599  1.00 10.31           C  
ATOM    661  O   PRO A  93      20.059 -12.720   2.515  1.00 10.05           O  
ATOM    662  CB  PRO A  93      16.919 -13.505   3.274  1.00 11.38           C  
ATOM    663  CG  PRO A  93      16.306 -12.826   4.458  1.00 12.85           C  
ATOM    664  CD  PRO A  93      17.445 -12.075   5.084  1.00 11.33           C  
ATOM    665  N   ALA A  94      19.444 -14.783   1.750  1.00 10.77           N  
ATOM    666  CA  ALA A  94      20.278 -14.749   0.528  1.00 10.61           C  
ATOM    667  C   ALA A  94      19.959 -13.502  -0.301  1.00 11.01           C  
ATOM    668  O   ALA A  94      18.784 -13.242  -0.598  1.00 11.18           O  
ATOM    669  CB  ALA A  94      20.047 -15.999  -0.309  1.00 10.59           C  
ATOM    670  N   GLN A  95      21.000 -12.763  -0.691  1.00 11.03           N  
ATOM    671  CA  GLN A  95      20.820 -11.464  -1.353  1.00 11.79           C  
ATOM    672  C   GLN A  95      21.015 -11.501  -2.872  1.00 12.79           C  
ATOM    673  O   GLN A  95      21.052 -10.439  -3.505  1.00 12.98           O  
ATOM    674  CB  GLN A  95      21.726 -10.397  -0.709  1.00 12.29           C  
ATOM    675  CG  GLN A  95      21.454 -10.159   0.783  1.00 13.45           C  
ATOM    676  CD  GLN A  95      20.118  -9.446   1.053  1.00 13.31           C  
ATOM    677  OE1 GLN A  95      19.206  -9.997   1.700  1.00 14.52           O  
ATOM    678  NE2 GLN A  95      19.986  -8.231   0.529  1.00 13.82           N  
ATOM    679  N   ALA A  96      21.136 -12.688  -3.474  1.00 13.37           N  
ATOM    680  CA  ALA A  96      21.381 -12.750  -4.923  1.00 14.24           C  
ATOM    681  C   ALA A  96      20.287 -11.957  -5.626  1.00 15.32           C  
ATOM    682  O   ALA A  96      19.118 -12.069  -5.256  1.00 16.13           O  
ATOM    683  CB  ALA A  96      21.442 -14.186  -5.419  1.00 14.07           C  
ATOM    684  N   THR A  97      20.689 -11.128  -6.598  1.00 16.22           N  
ATOM    685  CA  THR A  97      19.769 -10.227  -7.319  1.00 16.79           C  
ATOM    686  C   THR A  97      19.092 -10.920  -8.494  1.00 17.26           C  
ATOM    687  CB  THR A  97      20.463  -8.925  -7.845  1.00 17.23           C  
ATOM    688  OG1 THR A  97      21.302  -9.203  -8.984  1.00 19.66           O  
ATOM    689  CG2 THR A  97      21.287  -8.262  -6.754  1.00 17.25           C  
TER     690      THR A  97                                                      
END
MOLECULE T0429.pdb
ATOM      1  N   GLU    22      23.143   8.727  21.130  1.00172.90      A    N  
ATOM      2  CA  GLU    22      22.374   7.758  20.286  1.00169.34      A    C  
ATOM      3  CB  GLU    22      22.276   8.259  18.835  1.00168.54      A    C  
ATOM      4  CG  GLU    22      23.616   8.393  18.103  1.00158.10      A    C  
ATOM      5  CD  GLU    22      23.457   8.575  16.601  1.00157.25      A    C  
ATOM      6  OE1 GLU    22      24.348   8.113  15.852  1.00147.23      A    O  
ATOM      7  OE2 GLU    22      22.446   9.173  16.165  1.00167.76      A    O  
ATOM      8  C   GLU    22      22.931   6.322  20.338  1.00157.48      A    C  
ATOM      9  O   GLU    22      22.498   5.455  19.576  1.00152.96      A    O  
ATOM     10  N   THR    23      23.876   6.088  21.250  1.00154.10      A    N  
ATOM     11  CA  THR    23      24.505   4.776  21.452  1.00145.40      A    C  
ATOM     12  CB  THR    23      25.730   4.896  22.405  1.00143.94      A    C  
ATOM     13  OG1 THR    23      26.652   5.863  21.883  1.00141.32      A    O  
ATOM     14  CG2 THR    23      26.454   3.563  22.562  1.00136.43      A    C  
ATOM     15  C   THR    23      23.503   3.729  21.972  1.00150.21      A    C  
ATOM     16  O   THR    23      22.570   4.068  22.704  1.00162.36      A    O  
ATOM     17  N   GLU    24      23.706   2.466  21.590  1.00143.04      A    N  
ATOM     18  CA  GLU    24      22.756   1.383  21.886  1.00147.93      A    C  
ATOM     19  CB  GLU    24      22.210   0.789  20.580  1.00144.01      A    C  
ATOM     24  C   GLU    24      23.290   0.256  22.791  1.00146.91      A    C  
ATOM     25  O   GLU    24      22.482  -0.568  23.303  1.00154.53      A    O  
ATOM     26  N   LEU    25      24.636   0.215  22.968  1.00139.01      A    N  
ATOM     27  CA  LEU    25      25.295  -0.776  23.847  1.00138.87      A    C  
ATOM     28  CB  LEU    25      25.029  -0.457  25.346  1.00151.41      A    C  
ATOM     29  CG  LEU    25      26.098  -0.729  26.420  1.00153.60      A    C  
ATOM     30  CD1 LEU    25      25.557  -0.342  27.808  1.00166.65      A    C  
ATOM     31  CD2 LEU    25      26.620  -2.188  26.419  1.00150.16      A    C  
ATOM     32  C   LEU    25      24.901  -2.238  23.511  1.00137.26      A    C  
ATOM     33  O   LEU    25      24.248  -2.938  24.308  1.00144.91      A    O  
ATOM     34  N   LEU    27      24.229  -6.765  19.987  1.00124.47      A    N  
ATOM     35  CA  LEU    27      24.721  -8.135  19.817  1.00123.94      A    C  
ATOM     36  CB  LEU    27      24.018  -8.864  18.654  1.00124.12      A    C  
ATOM     37  CG  LEU    27      23.652  -8.221  17.310  1.00118.98      A    C  
ATOM     38  CD1 LEU    27      23.488  -9.322  16.264  1.00118.08      A    C  
ATOM     38  CD2 LEU    27      22.365  -7.397  17.414  1.00128.31      A    C  
ATOM     40  C   LEU    27      26.247  -8.245  19.696  1.00114.60      A    C  
ATOM     41  O   LEU    27      26.853  -9.156  20.263  1.00117.26      A    O  
ATOM     42  N   TYR    28      26.862  -7.335  18.947  1.00105.66      A    N  
ATOM     43  CA  TYR    28      28.319  -7.200  18.963  1.00 99.30      A    C  
ATOM     44  CB  TYR    28      28.923  -7.286  17.548  1.00 89.68      A    C  
ATOM     45  CG  TYR    28      28.406  -8.478  16.772  1.00 88.71      A    C  
ATOM     46  CD1 TYR    28      28.819  -9.774  17.087  1.00 90.89      A    C  
ATOM     47  CE1 TYR    28      28.325 -10.875  16.393  1.00 93.27      A    C  
ATOM     48  CZ  TYR    28      27.402 -10.683  15.376  1.00 92.44      A    C  
ATOM     49  OH  TYR    28      26.907 -11.765  14.685  1.00 96.36      A    O  
ATOM     50  CE2 TYR    28      26.974  -9.408  15.047  1.00 89.46      A    C  
ATOM     51  CD2 TYR    28      27.475  -8.315  15.748  1.00 87.20      A    C  
ATOM     52  C   TYR    28      28.651  -5.890  19.660  1.00100.94      A    C  
ATOM     53  O   TYR    28      28.114  -4.836  19.311  1.00100.23      A    O  
ATOM     54  N   LYS    29      29.505  -5.973  20.675  1.00104.98      A    N  
ATOM     55  CA  LYS    29      29.862  -4.813  21.481  1.00108.51      A    C  
ATOM     56  CB  LYS    29      30.333  -5.254  22.871  1.00116.86      A    C  
ATOM     61  C   LYS    29      30.923  -3.949  20.793  1.00102.56      A    C  
ATOM     62  O   LYS    29      31.688  -4.428  19.957  1.00 96.86      A    O  
ATOM     63  N   VAL    30      30.941  -2.667  21.147  1.00106.01      A    N  
ATOM     64  CA  VAL    30      31.946  -1.717  20.668  1.00103.19      A    C  
ATOM     65  CB  VAL    30      31.691  -0.300  21.261  1.00109.00      A    C  
ATOM     66  CG1 VAL    30      31.681  -0.327  22.793  1.00117.99      A    C  
ATOM     67  CG2 VAL    30      32.698   0.704  20.741  1.00108.94      A    C  
ATOM     68  C   VAL    30      33.374  -2.211  20.960  1.00103.89      A    C  
ATOM     69  O   VAL    30      33.667  -2.667  22.065  1.00110.81      A    O  
ATOM     70  N   ASN    31      34.238  -2.134  19.948  1.00 98.81      A    N  
ATOM     71  CA  ASN    31      35.638  -2.589  20.016  1.00 99.77      A    C  
ATOM     72  CB  ASN    31      36.312  -2.208  21.337  1.00108.53      A    C  
ATOM     73  CG  ASN    31      36.624  -0.747  21.416  1.00112.78      A    C  
ATOM     74  OD1 ASN    31      35.766   0.061  21.763  1.00116.34      A    O  
ATOM     75  ND2 ASN    31      37.861  -0.390  21.095  1.00116.64      A    N  
ATOM     76  C   ASN    31      35.858  -4.066  19.726  1.00 96.91      A    C  
ATOM     77  O   ASN    31      37.000  -4.499  19.568  1.00 98.59      A    O  
ATOM     78  N   GLU    32      34.779  -4.839  19.660  1.00 94.41      A    N  
ATOM     79  CA  GLU    32      34.889  -6.234  19.254  1.00 93.05      A    C  
ATOM     80  CB  GLU    32      33.592  -6.998  19.533  1.00 94.24      A    C  
ATOM     81  CG  GLU    32      33.730  -8.518  19.443  1.00 96.69      A    C  
ATOM     82  CD  GLU    32      32.437  -9.259  19.760  1.00101.02      A    C  
ATOM     83  OE1 GLU    32      31.677  -8.814  20.653  1.00104.59      A    O  
ATOM     84  OE2 GLU    32      32.191 -10.304  19.112  1.00101.68      A    O  
ATOM     85  C   GLU    32      35.248  -6.293  17.770  1.00 85.89      A    C  
ATOM     86  O   GLU    32      34.742  -5.503  16.970  1.00 81.52      A    O  
ATOM     87  N   TYR    33      36.146  -7.212  17.424  1.00 86.41      A    N  
ATOM     88  CA  TYR    33      36.514  -7.452  16.032  1.00 80.84      A    C  
ATOM     89  CB  TYR    33      37.902  -8.087  15.933  1.00 84.64      A    C  
ATOM     90  CG  TYR    33      39.026  -7.173  16.361  1.00 88.89      A    C  
ATOM     91  CD1 TYR    33      39.565  -6.233  15.478  1.00 87.72      A    C  
ATOM     92  CE1 TYR    33      40.604  -5.390  15.869  1.00 93.77      A    C  
ATOM     93  CZ  TYR    33      41.113  -5.488  17.158  1.00102.17      A    C  
ATOM     94  OH  TYR    33      42.137  -4.665  17.562  1.00109.70      A    O  
ATOM     95  CE2 TYR    33      40.595  -6.415  18.049  1.00103.06      A    C  
ATOM     96  CD2 TYR    33      39.558  -7.251  17.645  1.00 96.63      A    C  
ATOM     97  C   TYR    33      35.481  -8.343  15.365  1.00 77.13      A    C  
ATOM     98  O   TYR    33      34.999  -9.304  15.962  1.00 80.54      A    O  
ATOM     99  N   VAL    34      35.150  -8.015  14.121  1.00 71.92      A    N  
ATOM    100  CA  VAL    34      34.093  -8.702  13.387  1.00 68.82      A    C  
ATOM    101  CB  VAL    34      32.747  -7.920  13.464  1.00 68.44      A    C  
ATOM    102  CG1 VAL    34      32.177  -7.925  14.884  1.00 71.47      A    C  
ATOM    103  CG2 VAL    34      32.898  -6.493  12.926  1.00 64.40      A    C  
ATOM    104  C   VAL    34      34.460  -8.908  11.914  1.00 66.21      A    C  
ATOM    105  O   VAL    34      35.567  -8.577  11.481  1.00 66.29      A    O  
ATOM    106  N   ASP    35      33.522  -9.472  11.162  1.00 64.66      A    N  
ATOM    107  CA  ASP    35      33.597  -9.509   9.715  1.00 63.00      A    C  
ATOM    108  CB  ASP    35      33.407 -10.939   9.202  1.00 63.65      A    C  
ATOM    109  CG  ASP    35      34.686 -11.759   9.244  1.00 64.32      A    C  
ATOM    110  OD1 ASP    35      35.783 -11.188   9.069  1.00 62.56      A    O  
ATOM    111  OD2 ASP    35      34.591 -12.990   9.434  1.00 66.48      A    O  
ATOM    112  C   ASP    35      32.473  -8.627   9.199  1.00 63.11      A    C  
ATOM    113  O   ASP    35      31.344  -8.719   9.686  1.00 65.91      A    O  
ATOM    114  N   ALA    36      32.775  -7.773   8.221  1.00 62.20      A    N  
ATOM    115  CA  ALA    36      31.779  -6.853   7.670  1.00 62.48      A    C  
ATOM    116  CB  ALA    36      32.182  -5.415   7.934  1.00 63.64      A    C  
ATOM    117  C   ALA    36      31.607  -7.080   6.186  1.00 63.86      A    C  
ATOM    118  O   ALA    36      32.589  -7.191   5.452  1.00 65.27      A    O  
ATOM    119  N   ARG    37      30.358  -7.138   5.744  1.00 66.32      A    N  
ATOM    120  CA  ARG    37      30.057  -7.410   4.344  1.00 70.06      A    C  
ATOM    121  CB  ARG    37      28.720  -8.159   4.199  1.00 73.46      A    C  
ATOM    122  CG  ARG    37      28.518  -8.813   2.829  1.00 77.70      A    C  
ATOM    123  CD  ARG    37      27.182  -9.543   2.729  1.00 83.79      A    C  
ATOM    124  NE  ARG    37      26.063  -8.613   2.586  1.00 92.01      A    N  
ATOM    125  CZ  ARG    37      25.427  -8.344   1.445  1.00 99.69      A    C  
ATOM    126  NH1 ARG    37      25.775  -8.943   0.309  1.00101.62      A    N  
ATOM    127  NH2 ARG    37      24.425  -7.472   1.444  1.00105.62      A    N  
ATOM    128  C   ARG    37      30.043  -6.122   3.535  1.00 72.97      A    C  
ATOM    129  O   ARG    37      29.183  -5.267   3.734  1.00 76.28      A    O  
ATOM    130  N   ASP    38      31.015  -5.980   2.640  1.00 74.45      A    N  
ATOM    131  CA  ASP    38      30.995  -4.906   1.661  1.00 81.28      A    C  
ATOM    132  CB  ASP    38      32.279  -4.924   0.825  1.00 83.16      A    C  
ATOM    133  CG  ASP    38      32.369  -3.768  -0.157  1.00 91.41      A    C  
ATOM    134  OD1 ASP    38      31.439  -3.583  -0.965  1.00 98.91      A    O  
ATOM    135  OD2 ASP    38      33.394  -3.058  -0.145  1.00 93.84      A    O  
ATOM    136  C   ASP    38      29.768  -5.148   0.794  1.00 87.58      A    C  
ATOM    137  O   ASP    38      29.730  -6.094   0.011  1.00 90.08      A    O  
ATOM    138  N   THR    39      28.754  -4.307   0.961  1.00 92.61      A    N  
ATOM    139  CA  THR    39      27.483  -4.487   0.262  1.00101.09      A    C  
ATOM    140  CB  THR    39      26.377  -3.589   0.863  1.00105.79      A    C  
ATOM    141  OG1 THR    39      26.310  -3.809   2.276  1.00100.08      A    O  
ATOM    142  CG2 THR    39      25.014  -3.910   0.258  1.00115.77      A    C  
ATOM    143  C   THR    39      27.621  -4.263  -1.246  1.00109.30      A    C  
ATOM    144  O   THR    39      26.849  -4.811  -2.034  1.00116.02      A    O  
ATOM    145  N   ASN    40      28.617  -3.475  -1.640  1.00111.13      A    N  
ATOM    146  CA  ASN    40      28.866  -3.188  -3.050  1.00121.02      A    C  
ATOM    147  CB  ASN    40      29.891  -2.057  -3.191  1.00124.44      A    C  
ATOM    148  CG  ASN    40      30.409  -1.907  -4.609  1.00135.60      A    C  
ATOM    149  OD1 ASN    40      31.550  -2.269  -4.903  1.00135.88      A    O  
ATOM    150  ND2 ASN    40      29.567  -1.391  -5.502  1.00147.42      A    N  
ATOM    151  C   ASN    40      29.296  -4.418  -3.857  1.00120.57      A    C  
ATOM    152  O   ASN    40      28.922  -4.560  -5.022  1.00129.57      A    O  
ATOM    153  N   MET    41      30.064  -5.308  -3.234  1.00111.84      A    N  
ATOM    154  CA  MET    41      30.606  -6.478  -3.933  1.00112.47      A    C  
ATOM    155  CB  MET    41      32.122  -6.373  -4.048  1.00111.40      A    C  
ATOM    156  CG  MET    41      32.807  -6.077  -2.737  1.00103.73      A    C  
ATOM    157  SD  MET    41      34.733  -6.073  -2.908  1.00108.38      A   SE  
ATOM    158  CE  MET    41      34.947  -4.830  -4.410  1.00120.35      A    C  
ATOM    159  C   MET    41      30.224  -7.818  -3.307  1.00105.36      A    C  
ATOM    160  O   MET    41      30.327  -8.863  -3.955  1.00106.85      A    O  
ATOM    161  N   GLY    42      29.804  -7.780  -2.047  1.00 83.71      A    N  
ATOM    162  CA  GLY    42      29.269  -8.959  -1.367  1.00 83.07      A    C  
ATOM    163  C   GLY    42      30.262  -9.792  -0.578  1.00 77.08      A    C  
ATOM    164  O   GLY    42      29.914 -10.867  -0.090  1.00 77.31      A    O  
ATOM    165  N   ALA    43      31.490  -9.300  -0.446  1.00 72.89      A    N  
ATOM    166  CA  ALA    43      32.548 -10.041   0.234  1.00 69.07      A    C  
ATOM    167  CB  ALA    43      33.865  -9.848  -0.491  1.00 68.37      A    C  
ATOM    168  C   ALA    43      32.669  -9.636   1.703  1.00 65.34      A    C  
ATOM    169  O   ALA    43      32.300  -8.525   2.077  1.00 65.78      A    O  
ATOM    170  N   TRP    44      33.183 -10.537   2.535  1.00 64.28      A    N  
ATOM    171  CA  TRP    44      33.399 -10.241   3.953  1.00 61.58      A    C  
ATOM    172  CB  TRP    44      32.987 -11.425   4.830  1.00 63.28      A    C  
ATOM    173  CG  TRP    44      31.522 -11.742   4.770  1.00 66.96      A    C  
ATOM    174  CD1 TRP    44      30.893 -12.523   3.846  1.00 71.29      A    C  
ATOM    175  NE1 TRP    44      29.547 -12.583   4.112  1.00 75.54      A    N  
ATOM    176  CE2 TRP    44      29.278 -11.826   5.222  1.00 74.38      A    C  
ATOM    177  CD2 TRP    44      30.503 -11.280   5.667  1.00 69.18      A    C  
ATOM    178  CE3 TRP    44      30.505 -10.458   6.805  1.00 68.75      A    C  
ATOM    179  CZ3 TRP    44      29.298 -10.209   7.452  1.00 70.28      A    C  
ATOM    180  CH2 TRP    44      28.096 -10.769   6.986  1.00 75.60      A    C  
ATOM    181  CZ2 TRP    44      28.063 -11.578   5.876  1.00 76.96      A    C  
ATOM    182  C   TRP    44      34.850  -9.851   4.236  1.00 60.04      A    C  
ATOM    183  O   TRP    44      35.789 -10.497   3.740  1.00 59.62      A    O  
ATOM    184  N   PHE    45      35.017  -8.797   5.038  1.00 57.06      A    N  
ATOM    185  CA  PHE    45      36.331  -8.252   5.361  1.00 55.38      A    C  
ATOM    186  CB  PHE    45      36.541  -6.899   4.673  1.00 54.74      A    C  
ATOM    187  CG  PHE    45      36.523  -6.953   3.157  1.00 58.74      A    C  
ATOM    188  CD1 PHE    45      37.701  -7.144   2.439  1.00 58.08      A    C  
ATOM    189  CE1 PHE    45      37.695  -7.170   1.046  1.00 62.77      A    C  
ATOM    190  CZ  PHE    45      36.501  -7.000   0.344  1.00 63.52      A    C  
ATOM    191  CE2 PHE    45      35.321  -6.799   1.049  1.00 65.02      A    C  
ATOM    192  CD2 PHE    45      35.334  -6.773   2.448  1.00 58.18      A    C  
ATOM    193  C   PHE    45      36.481  -8.089   6.879  1.00 55.58      A    C  
ATOM    194  O   PHE    45      35.519  -7.741   7.578  1.00 55.09      A    O  
ATOM    195  N   GLU    46      37.686  -8.344   7.381  1.00 56.08      A    N  
ATOM    196  CA  GLU    46      37.969  -8.188   8.805  1.00 57.83      A    C  
ATOM    197  CB  GLU    46      39.401  -8.620   9.155  1.00 59.91      A    C  
ATOM    198  CG  GLU    46      39.750 -10.086   8.880  1.00 61.88      A    C  
ATOM    199  CD  GLU    46      40.313 -10.306   7.470  1.00 65.85      A    C  
ATOM    200  OE1 GLU    46      39.935  -9.574   6.516  1.00 60.16      A    O  
ATOM    201  OE2 GLU    46      41.147 -11.223   7.320  1.00 72.28      A    O  
ATOM    202  C   GLU    46      37.762  -6.724   9.155  1.00 57.63      A    C  
ATOM    203  O   GLU    46      38.320  -5.836   8.509  1.00 58.66      A    O  
ATOM    204  N   ALA    47      36.924  -6.478  10.150  1.00 57.65      A    N  
ATOM    205  CA  ALA    47      36.649  -5.120  10.594  1.00 58.18      A    C  
ATOM    206  CB  ALA    47      35.406  -4.582   9.895  1.00 56.70      A    C  
ATOM    207  C   ALA    47      36.505  -5.054  12.117  1.00 60.50      A    C  
ATOM    208  O   ALA    47      36.526  -6.082  12.792  1.00 61.81      A    O  
ATOM    209  N   GLN    48      36.390  -3.842  12.652  1.00 63.44      A    N  
ATOM    210  CA  GLN    48      36.171  -3.640  14.084  1.00 67.12      A    C  
ATOM    211  CB  GLN    48      37.456  -3.160  14.766  1.00 71.03      A    C  
ATOM    212  CG  GLN    48      37.367  -3.069  16.297  1.00 75.40      A    C  
ATOM    213  CD  GLN    48      38.641  -2.565  16.949  1.00 80.70      A    C  
ATOM    214  OE1 GLN    48      39.520  -2.019  16.287  1.00 80.17      A    O  
ATOM    215  NE2 GLN    48      38.742  -2.741  18.266  1.00 86.01      A    N  
ATOM    216  C   GLN    48      35.030  -2.652  14.331  1.00 69.25      A    C  
ATOM    217  O   GLN    48      34.873  -1.667  13.598  1.00 67.51      A    O  
ATOM    218  N   VAL    49      34.243  -2.927  15.369  1.00 72.79      A    N  
ATOM    219  CA  VAL    49      33.117  -2.082  15.740  1.00 76.25      A    C  
ATOM    220  CB  VAL    49      32.072  -2.853  16.579  1.00 80.46      A    C  
ATOM    221  CG1 VAL    49      30.933  -1.925  17.006  1.00 82.55      A    C  
ATOM    222  CG2 VAL    49      31.539  -4.055  15.802  1.00 75.52      A    C  
ATOM    223  C   VAL    49      33.586  -0.852  16.516  1.00 81.59      A    C  
ATOM    224  O   VAL    49      34.141  -0.962  17.614  1.00 86.04      A    O  
ATOM    225  N   VAL    50      33.342   0.318  15.936  1.00 81.58      A    N  
ATOM    226  CA  VAL    50      33.742   1.586  16.532  1.00 85.85      A    C  
ATOM    227  CB  VAL    50      34.190   2.582  15.439  1.00 82.87      A    C  
ATOM    228  CG1 VAL    50      34.390   3.946  16.021  1.00 90.16      A    C  
ATOM    229  CG2 VAL    50      35.466   2.109  14.799  1.00 79.12      A    C  
ATOM    230  C   VAL    50      32.618   2.185  17.389  1.00 91.85      A    C  
ATOM    231  O   VAL    50      32.866   2.721  18.476  1.00 97.97      A    O  
ATOM    232  N   ARG    51      31.391   2.106  16.883  1.00 91.35      A    N  
ATOM    233  CA  ARG    51      30.213   2.553  17.613  1.00 98.00      A    C  
ATOM    234  CB  ARG    51      29.917   4.032  17.340  1.00100.80      A    C  
ATOM    235  CG  ARG    51      30.506   4.983  18.377  1.00107.46      A    C  
ATOM    236  CD  ARG    51      30.332   6.443  17.985  1.00110.40      A    C  
ATOM    237  NE  ARG    51      28.942   6.883  18.103  1.00118.29      A    N  
ATOM    238  CZ  ARG    51      28.426   7.482  19.175  1.00129.05      A    C  
ATOM    239  NH1 ARG    51      29.181   7.730  20.240  1.00134.40      A    N  
ATOM    240  NH2 ARG    51      27.146   7.840  19.187  1.00134.91      A    N  
ATOM    241  C   ARG    51      29.012   1.691  17.255  1.00 97.71      A    C  
ATOM    242  O   ARG    51      28.957   1.107  16.169  1.00 92.82      A    O  
ATOM    243  N   VAL    52      28.066   1.598  18.186  1.00104.09      A    N  
ATOM    244  CA  VAL    52      26.811   0.891  17.951  1.00105.53      A    C  
ATOM    245  CB  VAL    52      26.746  -0.447  18.749  1.00107.07      A    C  
ATOM    246  CG1 VAL    52      26.856  -0.214  20.262  1.00116.59      A    C  
ATOM    247  CG2 VAL    52      25.491  -1.224  18.406  1.00109.24      A    C  
ATOM    248  C   VAL    52      25.618   1.825  18.217  1.00112.85      A    C  
ATOM    249  O   VAL    52      25.528   2.453  19.276  1.00118.62      A    O  
ATOM    250  N   THR    53      24.724   1.920  17.235  1.00113.10      A    N  
ATOM    251  CA  THR    53      23.602   2.862  17.269  1.00121.51      A    C  
ATOM    252  CB  THR    53      23.697   3.858  16.086  1.00119.01      A    C  
ATOM    253  OG1 THR    53      25.050   4.292  15.937  1.00114.19      A    O  
ATOM    254  CG2 THR    53      22.815   5.078  16.309  1.00129.22      A    C  
ATOM    255  C   THR    53      22.252   2.129  17.233  1.00126.92      A    C  
ATOM    256  O   THR    53      22.201   0.930  16.948  1.00124.34      A    O  
ATOM    257  N   ARG    54      21.171   2.851  17.529  1.00135.79      A    N  
ATOM    258  CA  ARG    54      19.816   2.299  17.465  1.00143.10      A    C  
ATOM    259  CB  ARG    54      19.136   2.367  18.841  1.00152.93      A    C  
ATOM    266  C   ARG    54      18.965   3.026  16.419  1.00146.96      A    C  
ATOM    267  O   ARG    54      18.946   2.629  15.229  1.00142.84      A    O  
ATOM    268  N   GLU    73      20.100  -6.332  15.059  1.00123.32      A    N  
ATOM    269  CA  GLU    73      18.671  -6.470  14.844  1.00132.67      A    C  
ATOM    270  CB  GLU    73      18.053  -7.343  15.943  1.00141.48      A    C  
ATOM    271  CG  GLU    73      18.457  -6.965  17.377  1.00145.34      A    C  
ATOM    272  CD  GLU    73      17.406  -7.360  18.407  1.00159.33      A    C  
ATOM    273  OE1 GLU    73      16.940  -8.524  18.379  1.00163.38      A    O  
ATOM    274  OE2 GLU    73      17.047  -6.503  19.249  1.00167.09      A    O  
ATOM    275  C   GLU    73      18.000  -5.098  14.802  1.00137.46      A    C  
ATOM    276  O   GLU    73      17.488  -4.614  15.820  1.00144.45      A    O  
ATOM    277  N   ASP    74      18.001  -4.475  13.621  1.00134.20      A    N  
ATOM    278  CA  ASP    74      17.565  -3.076  13.462  1.00137.77      A    C  
ATOM    279  CB  ASP    74      16.132  -2.870  13.992  1.00150.47      A    C  
ATOM    280  CG  ASP    74      15.447  -1.638  13.404  1.00157.01      A    C  
ATOM    281  OD1 ASP    74      16.084  -0.904  12.614  1.00151.95      A    O  
ATOM    282  OD2 ASP    74      14.261  -1.406  13.738  1.00166.48      A    O  
ATOM    283  C   ASP    74      18.571  -2.133  14.150  1.00132.38      A    C  
ATOM    284  O   ASP    74      18.362  -0.917  14.243  1.00135.67      A    O  
ATOM    285  N   VAL    75      19.658  -2.731  14.633  1.00124.52      A    N  
ATOM    286  CA  VAL    75      20.823  -2.029  15.155  1.00117.47      A    C  
ATOM    287  CB  VAL    75      21.627  -2.956  16.115  1.00114.64      A    C  
ATOM    288  CG1 VAL    75      23.095  -2.588  16.171  1.00105.73      A    C  
ATOM    289  CG2 VAL    75      21.012  -2.949  17.511  1.00123.12      A    C  
ATOM    290  C   VAL    75      21.679  -1.621  13.962  1.00108.96      A    C  
ATOM    291  O   VAL    75      21.740  -2.351  12.968  1.00104.98      A    O  
ATOM    292  N   ILE    76      22.315  -0.453  14.052  1.00106.20      A    N  
ATOM    293  CA  ILE    76      23.261  -0.013  13.023  1.00 99.14      A    C  
ATOM    294  CB  ILE    76      22.765   1.254  12.255  1.00102.73      A    C  
ATOM    295  CG1 ILE    76      23.853   1.796  11.319  1.00 96.23      A    C  
ATOM    296  CD1 ILE    76      23.310   2.429  10.045  1.00 99.72      A    C  
ATOM    297  CG2 ILE    76      22.252   2.323  13.216  1.00110.67      A    C  
ATOM    298  C   ILE    76      24.690   0.120  13.573  1.00 92.90      A    C  
ATOM    299  O   ILE    76      24.945   0.887  14.499  1.00 95.46      A    O  
ATOM    300  N   TYR    77      25.607  -0.649  12.990  1.00 93.66      A    N  
ATOM    301  CA  TYR    77      26.991  -0.728  13.458  1.00 88.85      A    C  
ATOM    302  CB  TYR    77      27.533  -2.147  13.273  1.00 85.70      A    C  
ATOM    303  CG  TYR    77      26.943  -3.158  14.228  1.00 89.17      A    C  
ATOM    304  CD1 TYR    77      27.333  -3.187  15.566  1.00 90.70      A    C  
ATOM    305  CE1 TYR    77      26.796  -4.113  16.452  1.00 95.37      A    C  
ATOM    306  CZ  TYR    77      25.860  -5.028  16.005  1.00 96.78      A    C  
ATOM    307  OH  TYR    77      25.339  -5.937  16.890  1.00100.18      A    O  
ATOM    308  CE2 TYR    77      25.456  -5.027  14.677  1.00 95.16      A    C  
ATOM    309  CD2 TYR    77      26.000  -4.091  13.797  1.00 90.70      A    C  
ATOM    310  C   TYR    77      27.916   0.258  12.760  1.00 85.38      A    C  
ATOM    311  O   TYR    77      27.856   0.421  11.542  1.00 84.45      A    O  
ATOM    312  N   HIS    78      28.773   0.910  13.541  1.00 83.71      A    N  
ATOM    313  CA  HIS    78      29.810   1.770  12.989  1.00 81.14      A    C  
ATOM    314  CB  HIS    78      29.910   3.077  13.762  1.00 83.22      A    C  
ATOM    315  CG  HIS    78      28.703   3.945  13.615  1.00 87.89      A    C  
ATOM    316  ND1 HIS    78      28.769   5.234  13.134  1.00 90.48      A    N  
ATOM    317  CE1 HIS    78      27.554   5.752  13.107  1.00 94.69      A    C  
ATOM    318  NE2 HIS    78      26.702   4.840  13.539  1.00 96.87      A    N  
ATOM    319  CD2 HIS    78      27.395   3.699  13.861  1.00 91.50      A    C  
ATOM    320  C   HIS    78      31.117   1.019  13.031  1.00 77.65      A    C  
ATOM    321  O   HIS    78      31.556   0.572  14.093  1.00 78.47      A    O  
ATOM    322  N   VAL    79      31.736   0.895  11.864  1.00 73.81      A    N  
ATOM    323  CA  VAL    79      32.790  -0.070  11.660  1.00 70.60      A    C  
ATOM    324  CB  VAL    79      32.193  -1.323  10.934  1.00 70.59      A    C  
ATOM    325  CG1 VAL    79      33.109  -1.881   9.858  1.00 64.14      A    C  
ATOM    326  CG2 VAL    79      31.785  -2.385  11.956  1.00 70.14      A    C  
ATOM    327  C   VAL    79      33.993   0.529  10.929  1.00 69.42      A    C  
ATOM    328  O   VAL    79      33.844   1.379  10.051  1.00 69.22      A    O  
ATOM    329  N   LYS    80      35.186   0.100  11.328  1.00 69.05      A    N  
ATOM    330  CA  LYS    80      36.402   0.409  10.586  1.00 69.09      A    C  
ATOM    331  CB  LYS    80      37.372   1.251  11.422  1.00 70.54      A    C  
ATOM    332  CG  LYS    80      38.019   0.522  12.589  1.00 71.11      A    C  
ATOM    333  CD  LYS    80      38.951   1.430  13.346  1.00 72.80      A    C  
ATOM    334  CE  LYS    80      39.612   0.680  14.484  1.00 77.21      A    C  
ATOM    335  NZ  LYS    80      40.206   1.598  15.499  1.00 80.41      A    N  
ATOM    336  C   LYS    80      37.069  -0.878  10.094  1.00 68.73      A    C  
ATOM    337  O   LYS    80      37.050  -1.904  10.783  1.00 67.58      A    O  
ATOM    338  N   TYR    81      37.642  -0.809   8.895  1.00 69.17      A    N  
ATOM    339  CA  TYR    81      38.314  -1.942   8.276  1.00 69.65      A    C  
ATOM    340  CB  TYR    81      38.192  -1.871   6.756  1.00 71.26      A    C  
ATOM    341  CG  TYR    81      36.782  -2.058   6.257  1.00 73.36      A    C  
ATOM    342  CD1 TYR    81      35.942  -0.962   6.046  1.00 76.49      A    C  
ATOM    343  CE1 TYR    81      34.632  -1.135   5.589  1.00 78.01      A    C  
ATOM    344  CZ  TYR    81      34.160  -2.417   5.342  1.00 77.56      A    C  
ATOM    345  OH  TYR    81      32.871  -2.611   4.885  1.00 80.19      A    O  
ATOM    346  CE2 TYR    81      34.981  -3.517   5.552  1.00 75.57      A    C  
ATOM    347  CD2 TYR    81      36.279  -3.333   6.010  1.00 72.40      A    C  
ATOM    348  C   TYR    81      39.777  -2.026   8.675  1.00 70.89      A    C  
ATOM    349  O   TYR    81      40.533  -1.050   8.563  1.00 71.51      A    O  
ATOM    350  N   ASP    82      40.164  -3.215   9.130  1.00 71.89      A    N  
ATOM    351  CA  ASP    82      41.516  -3.480   9.609  1.00 73.79      A    C  
ATOM    352  CB  ASP    82      41.648  -4.954  10.017  1.00 74.15      A    C  
ATOM    353  CG  ASP    82      40.868  -5.285  11.286  1.00 76.59      A    C  
ATOM    354  OD1 ASP    82      40.138  -4.405  11.803  1.00 78.41      A    O  
ATOM    355  OD2 ASP    82      40.989  -6.432  11.775  1.00 78.61      A    O  
ATOM    356  C   ASP    82      42.576  -3.103   8.576  1.00 74.38      A    C  
ATOM    357  O   ASP    82      43.536  -2.406   8.898  1.00 77.23      A    O  
ATOM    358  N   ASP    83      42.376  -3.540   7.336  1.00 72.34      A    N  
ATOM    359  CA  ASP    83      43.368  -3.352   6.288  1.00 72.89      A    C  
ATOM    360  CB  ASP    83      43.600  -4.675   5.546  1.00 73.65      A    C  
ATOM    361  CG  ASP    83      44.090  -5.780   6.467  1.00 75.64      A    C  
ATOM    362  OD1 ASP    83      45.026  -5.529   7.263  1.00 79.90      A    O  
ATOM    363  OD2 ASP    83      43.535  -6.899   6.399  1.00 75.47      A    O  
ATOM    364  C   ASP    83      43.012  -2.238   5.307  1.00 72.04      A    C  
ATOM    365  O   ASP    83      43.717  -2.037   4.311  1.00 73.88      A    O  
ATOM    366  N   TYR    84      41.927  -1.517   5.582  1.00 69.13      A    N  
ATOM    367  CA  TYR    84      41.477  -0.450   4.687  1.00 69.06      A    C  
ATOM    368  CB  TYR    84      40.293  -0.925   3.838  1.00 67.58      A    C  
ATOM    369  CG  TYR    84      40.560  -2.187   3.072  1.00 66.36      A    C  
ATOM    370  CD1 TYR    84      41.057  -2.140   1.773  1.00 68.00      A    C  
ATOM    371  CE1 TYR    84      41.312  -3.305   1.067  1.00 69.12      A    C  
ATOM    372  CZ  TYR    84      41.063  -4.533   1.656  1.00 66.52      A    C  
ATOM    373  OH  TYR    84      41.309  -5.690   0.957  1.00 68.36      A    O  
ATOM    374  CE2 TYR    84      40.569  -4.603   2.945  1.00 65.02      A    C  
ATOM    375  CD2 TYR    84      40.318  -3.433   3.644  1.00 63.68      A    C  
ATOM    376  C   TYR    84      41.094   0.836   5.421  1.00 69.64      A    C  
ATOM    377  O   TYR    84      39.916   1.207   5.433  1.00 69.47      A    O  
ATOM    378  N   PRO    85      42.084   1.534   6.020  1.00 70.58      A    N  
ATOM    379  CA  PRO    85      41.773   2.784   6.721  1.00 70.66      A    C  
ATOM    380  CB  PRO    85      43.114   3.175   7.348  1.00 72.50      A    C  
ATOM    381  CG  PRO    85      44.141   2.518   6.489  1.00 73.96      A    C  
ATOM    382  CD  PRO    85      43.525   1.219   6.080  1.00 72.47      A    C  
ATOM    383  C   PRO    85      41.266   3.886   5.780  1.00 71.62      A    C  
ATOM    384  O   PRO    85      40.622   4.830   6.230  1.00 71.33      A    O  
ATOM    385  N   GLU    86      41.546   3.751   4.485  1.00 73.37      A    N  
ATOM    386  CA  GLU    86      41.039   4.679   3.476  1.00 75.64      A    C  
ATOM    387  CB  GLU    86      41.735   4.463   2.122  1.00 78.50      A    C  
ATOM    388  CG  GLU    86      41.443   3.121   1.422  1.00 78.65      A    C  
ATOM    389  CD  GLU    86      42.359   1.979   1.859  1.00 76.94      A    C  
ATOM    390  OE1 GLU    86      42.547   1.037   1.060  1.00 77.72      A    O  
ATOM    391  OE2 GLU    86      42.890   2.012   2.992  1.00 76.80      A    O  
ATOM    392  C   GLU    86      39.514   4.604   3.332  1.00 75.93      A    C  
ATOM    393  O   GLU    86      38.896   5.510   2.775  1.00 79.57      A    O  
ATOM    394  N   ASN    87      38.915   3.529   3.843  1.00 74.12      A    N  
ATOM    395  CA  ASN    87      37.456   3.377   3.865  1.00 73.88      A    C  
ATOM    396  CB  ASN    87      37.066   1.910   4.057  1.00 72.05      A    C  
ATOM    397  CG  ASN    87      37.319   1.066   2.821  1.00 73.77      A    C  
ATOM    398  OD1 ASN    87      37.855   1.542   1.815  1.00 75.97      A    O  
ATOM    399  ND2 ASN    87      36.926  -0.201   2.891  1.00 74.00      A    N  
ATOM    400  C   ASN    87      36.762   4.227   4.928  1.00 73.27      A    C  
ATOM    401  O   ASN    87      35.550   4.423   4.874  1.00 75.05      A    O  
ATOM    402  N   GLY    88      37.531   4.721   5.894  1.00 71.73      A    N  
ATOM    403  CA  GLY    88      36.985   5.521   6.984  1.00 70.82      A    C  
ATOM    404  C   GLY    88      36.114   4.688   7.898  1.00 69.49      A    C  
ATOM    405  O   GLY    88      36.270   3.471   7.961  1.00 68.16      A    O  
ATOM    406  N   VAL    89      35.206   5.350   8.612  1.00 70.56      A    N  
ATOM    407  CA  VAL    89      34.196   4.670   9.414  1.00 71.17      A    C  
ATOM    408  CB  VAL    89      33.888   5.413  10.748  1.00 72.80      A    C  
ATOM    409  CG1 VAL    89      32.826   4.671  11.550  1.00 73.51      A    C  
ATOM    410  CG2 VAL    89      35.142   5.548  11.580  1.00 71.42      A    C  
ATOM    411  C   VAL    89      32.928   4.502   8.570  1.00 73.41      A    C  
ATOM    412  O   VAL    89      32.409   5.472   8.000  1.00 74.86      A    O  
ATOM    413  N   VAL    90      32.453   3.258   8.493  1.00 73.03      A    N  
ATOM    414  CA  VAL    90      31.321   2.886   7.650  1.00 75.55      A    C  
ATOM    415  CB  VAL    90      31.726   1.802   6.610  1.00 73.49      A    C  
ATOM    416  CG1 VAL    90      30.564   1.471   5.676  1.00 76.90      A    C  
ATOM    417  CG2 VAL    90      32.935   2.247   5.802  1.00 72.13      A    C  
ATOM    418  C   VAL    90      30.170   2.361   8.509  1.00 78.45      A    C  
ATOM    419  O   VAL    90      30.374   1.542   9.411  1.00 77.22      A    O  
ATOM    420  N   GLN    91      28.965   2.843   8.218  1.00 83.52      A    N  
ATOM    421  CA  GLN    91      27.755   2.390   8.897  1.00 87.88      A    C  
ATOM    422  CB  GLN    91      26.682   3.467   8.832  1.00 92.88      A    C  
ATOM    423  CG  GLN    91      27.037   4.717   9.618  1.00 93.91      A    C  
ATOM    424  CD  GLN    91      25.943   5.755   9.589  1.00 99.60      A    C  
ATOM    425  OE1 GLN    91      26.208   6.939   9.389  1.00101.46      A    O  
ATOM    426  NE2 GLN    91      24.703   5.322   9.788  1.00105.50      A    N  
ATOM    427  C   GLN    91      27.243   1.090   8.293  1.00 88.99      A    C  
ATOM    428  O   GLN    91      27.083   0.980   7.079  1.00 90.22      A    O  
ATOM    429  N   MET    92      26.981   0.113   9.156  1.00 90.02      A    N  
ATOM    430  CA  MET    92      26.645  -1.241   8.737  1.00 90.94      A    C  
ATOM    431  CB  MET    92      27.692  -2.221   9.268  1.00 88.07      A    C  
ATOM    432  CG  MET    92      29.111  -1.959   8.803  1.00 88.61      A    C  
ATOM    433  SD  MET    92      29.351  -2.318   6.905  1.00 98.62      A   SE  
ATOM    434  CE  MET    92      28.929  -4.197   6.883  1.00 91.66      A    C  
ATOM    435  C   MET    92      25.273  -1.687   9.236  1.00 95.56      A    C  
ATOM    436  O   MET    92      24.911  -1.435  10.385  1.00 97.05      A    O  
ATOM    437  N   ASN    93      24.522  -2.361   8.368  1.00 97.87      A    N  
ATOM    438  CA  ASN    93      23.301  -3.045   8.779  1.00102.77      A    C  
ATOM    439  CB  ASN    93      22.460  -3.441   7.563  1.00106.54      A    C  
ATOM    440  CG  ASN    93      21.019  -3.772   7.928  1.00114.89      A    C  
ATOM    441  OD1 ASN    93      20.744  -4.745   8.638  1.00116.51      A    O  
ATOM    442  ND2 ASN    93      20.090  -2.967   7.431  1.00121.11      A    N  
ATOM    443  C   ASN    93      23.673  -4.280   9.590  1.00100.09      A    C  
ATOM    444  O   ASN    93      24.659  -4.952   9.284  1.00 94.90      A    O  
ATOM    445  N   SER    94      22.877  -4.571  10.617  1.00103.84      A    N  
ATOM    446  CA  SER    94      23.168  -5.647  11.574  1.00102.37      A    C  
ATOM    447  CB  SER    94      22.088  -5.692  12.660  1.00109.16      A    C  
ATOM    448  OG  SER    94      22.463  -6.552  13.726  1.00109.46      A    O  
ATOM    449  C   SER    94      23.328  -7.033  10.943  1.00 99.33      A    C  
ATOM    450  O   SER    94      23.924  -7.923  11.548  1.00 96.67      A    O  
ATOM    451  N   ARG    95      22.787  -7.207   9.738  1.00100.12      A    N  
ATOM    452  CA  ARG    95      22.866  -8.476   9.012  1.00 98.31      A    C  
ATOM    453  CB  ARG    95      21.658  -8.642   8.083  1.00103.51      A    C  
ATOM    454  CG  ARG    95      21.541  -7.572   7.000  1.00105.74      A    C  
ATOM    455  CD  ARG    95      20.258  -7.724   6.207  1.00112.78      A    C  
ATOM    456  NE  ARG    95      20.009  -6.556   5.366  1.00118.15      A    N  
ATOM    460  C   ARG    95      24.162  -8.567   8.214  1.00 91.56      A    C  
ATOM    461  O   ARG    95      24.609  -9.665   7.850  1.00 88.39      A    O  
ATOM    462  N   ASP    96      24.750  -7.399   7.951  1.00 89.10      A    N  
ATOM    463  CA  ASP    96      25.999  -7.276   7.205  1.00 82.96      A    C  
ATOM    464  CB  ASP    96      25.998  -5.988   6.373  1.00 83.81      A    C  
ATOM    465  CG  ASP    96      25.193  -6.112   5.088  1.00 87.00      A    C  
ATOM    466  OD1 ASP    96      24.933  -7.246   4.636  1.00 87.12      A    O  
ATOM    467  OD2 ASP    96      24.829  -5.063   4.519  1.00 89.68      A    O  
ATOM    468  C   ASP    96      27.236  -7.329   8.109  1.00 78.81      A    C  
ATOM    469  O   ASP    96      28.366  -7.175   7.633  1.00 75.79      A    O  
ATOM    470  N   VAL    97      27.025  -7.546   9.406  1.00 79.24      A    N  
ATOM    471  CA  VAL    97      28.137  -7.792  10.337  1.00 76.33      A    C  
ATOM    472  CB  VAL    97      28.549  -6.514  11.163  1.00 76.33      A    C  
ATOM    473  CG1 VAL    97      27.457  -5.473  11.146  1.00 81.16      A    C  
ATOM    474  CG2 VAL    97      28.977  -6.853  12.599  1.00 76.18      A    C  
ATOM    475  C   VAL    97      27.883  -9.017  11.216  1.00 77.38      A    C  
ATOM    476  O   VAL    97      26.768  -9.236  11.698  1.00 81.25      A    O  
ATOM    477  N   ARG    98      28.926  -9.823  11.394  1.00 73.62      A    N  
ATOM    478  CA  ARG    98      28.844 -11.037  12.197  1.00 74.98      A    C  
ATOM    479  CB  ARG    98      28.402 -12.230  11.333  1.00 74.25      A    C  
ATOM    480  CG  ARG    98      29.415 -12.653  10.279  1.00 69.79      A    C  
ATOM    481  CD  ARG    98      28.820 -13.641   9.295  1.00 70.18      A    C  
ATOM    482  NE  ARG    98      29.792 -14.010   8.269  1.00 67.23      A    N  
ATOM    483  CZ  ARG    98      29.480 -14.503   7.072  1.00 66.25      A    C  
ATOM    484  NH1 ARG    98      28.214 -14.686   6.730  1.00 69.46      A    N  
ATOM    485  NH2 ARG    98      30.438 -14.808   6.209  1.00 62.39      A    N  
ATOM    486  C   ARG    98      30.189 -11.316  12.861  1.00 73.07      A    C  
ATOM    487  O   ARG    98      31.182 -10.655  12.555  1.00 70.00      A    O  
ATOM    488  N   ALA    99      30.215 -12.295  13.763  1.00 75.78      A    N  
ATOM    489  CA  ALA    99      31.446 -12.698  14.440  1.00 76.68      A    C  
ATOM    490  CB  ALA    99      31.164 -13.801  15.444  1.00 79.68      A    C  
ATOM    491  C   ALA    99      32.484 -13.157  13.423  1.00 73.07      A    C  
ATOM    492  O   ALA    99      32.138 -13.801  12.434  1.00 72.70      A    O  
ATOM    493  N   ARG   100      33.748 -12.822  13.671  1.00 72.44      A    N  
ATOM    494  CA  ARG   100      34.839 -13.184  12.777  1.00 71.01      A    C  
ATOM    495  CB  ARG   100      36.168 -12.642  13.305  1.00 71.60      A    C  
ATOM    496  CG  ARG   100      37.275 -12.682  12.273  1.00 71.40      A    C  
ATOM    497  CD  ARG   100      38.385 -11.712  12.580  1.00 73.85      A    C  
ATOM    498  NE  ARG   100      38.010 -10.331  12.296  1.00 73.41      A    N  
ATOM    499  CZ  ARG   100      38.795  -9.285  12.528  1.00 75.14      A    C  
ATOM    500  NH1 ARG   100      38.373  -8.063  12.255  1.00 75.99      A    N  
ATOM    501  NH2 ARG   100      40.004  -9.457  13.035  1.00 80.38      A    N  
ATOM    502  C   ARG   100      34.921 -14.695  12.550  1.00 71.83      A    C  
ATOM    503  O   ARG   100      34.724 -15.474  13.472  1.00 75.13      A    O  
ATOM    504  N   ALA   101      35.185 -15.103  11.312  1.00 71.01      A    N  
ATOM    505  CA  ALA   101      35.329 -16.525  10.994  1.00 72.17      A    C  
ATOM    506  CB  ALA   101      35.429 -16.722   9.503  1.00 68.85      A    C  
ATOM    507  C   ALA   101      36.552 -17.119  11.710  1.00 75.15      A    C  
ATOM    508  O   ALA   101      37.615 -16.494  11.754  1.00 76.06      A    O  
ATOM    509  N   ARG   102      36.393 -18.307  12.292  1.00 77.04      A    N  
ATOM    510  CA  ARG   102      37.495 -18.945  13.018  1.00 80.24      A    C  
ATOM    511  CB  ARG   102      37.422 -18.649  14.532  1.00 84.15      A    C  
ATOM    512  CG  ARG   102      36.203 -19.204  15.271  1.00 87.78      A    C  
ATOM    513  CD  ARG   102      36.375 -19.083  16.790  1.00 94.35      A    C  
ATOM    514  NE  ARG   102      35.293 -19.729  17.539  1.00100.75      A    N  
ATOM    515  CZ  ARG   102      35.301 -21.003  17.926  1.00102.53      A    C  
ATOM    518  C   ARG   102      37.656 -20.449  12.745  1.00 80.42      A    C  
ATOM    519  O   ARG   102      38.732 -21.007  12.968  1.00 82.56      A    O  
ATOM    520  N   THR   103      36.603 -21.092  12.243  1.00 78.34      A    N  
ATOM    521  CA  THR   103      36.599 -22.546  12.083  1.00 78.04      A    C  
ATOM    522  CB  THR   103      35.419 -23.186  12.852  1.00 80.45      A    C  
ATOM    523  OG1 THR   103      35.405 -22.698  14.199  1.00 83.17      A    O  
ATOM    524  CG2 THR   103      35.535 -24.702  12.867  1.00 81.05      A    C  
ATOM    525  C   THR   103      36.580 -22.993  10.620  1.00 74.75      A    C  
ATOM    526  O   THR   103      35.704 -22.597   9.843  1.00 72.85      A    O  
ATOM    527  N   ILE   104      37.563 -23.816  10.260  1.00 74.51      A    N  
ATOM    528  CA  ILE   104      37.632 -24.436   8.939  1.00 71.52      A    C  
ATOM    529  CB  ILE   104      39.104 -24.721   8.524  1.00 72.44      A    C  
ATOM    530  CG1 ILE   104      39.888 -23.415   8.327  1.00 72.05      A    C  
ATOM    531  CD1 ILE   104      39.530 -22.634   7.057  1.00 70.80      A    C  
ATOM    532  CG2 ILE   104      39.176 -25.610   7.273  1.00 71.84      A    C  
ATOM    533  C   ILE   104      36.840 -25.745   8.930  1.00 72.09      A    C  
ATOM    534  O   ILE   104      37.025 -26.603   9.804  1.00 75.02      A    O  
ATOM    535  N   ILE   105      35.952 -25.885   7.951  1.00 69.18      A    N  
ATOM    536  CA  ILE   105      35.303 -27.162   7.691  1.00 69.78      A    C  
ATOM    537  CB  ILE   105      33.883 -26.988   7.109  1.00 68.99      A    C  
ATOM    538  CG1 ILE   105      33.034 -26.087   8.021  1.00 70.06      A    C  
ATOM    539  CD1 ILE   105      31.766 -25.553   7.376  1.00 68.53      A    C  
ATOM    540  CG2 ILE   105      33.218 -28.359   6.902  1.00 69.89      A    C  
ATOM    541  C   ILE   105      36.177 -27.947   6.721  1.00 69.20      A    C  
ATOM    542  O   ILE   105      36.321 -27.559   5.557  1.00 67.81      A    O  
ATOM    543  N   LYS   106      36.768 -29.036   7.213  1.00 71.18      A    N  
ATOM    544  CA  LYS   106      37.645 -29.901   6.409  1.00 71.31      A    C  
ATOM    545  CB  LYS   106      38.240 -31.027   7.268  1.00 74.66      A    C  
ATOM    546  CG  LYS   106      39.235 -30.553   8.327  1.00 78.99      A    C  
ATOM    547  CD  LYS   106      39.729 -31.711   9.190  1.00 83.40      A    C  
ATOM    550  C   LYS   106      36.906 -30.487   5.204  1.00 68.56      A    C  
ATOM    551  O   LYS   106      35.686 -30.651   5.238  1.00 67.81      A    O  
ATOM    552  N   TRP   107      37.645 -30.803   4.143  1.00 67.47      A    N  
ATOM    553  CA  TRP   107      37.031 -31.309   2.911  1.00 66.13      A    C  
ATOM    554  CB  TRP   107      38.099 -31.666   1.875  1.00 65.53      A    C  
ATOM    555  CG  TRP   107      37.617 -32.592   0.793  1.00 64.63      A    C  
ATOM    556  CD1 TRP   107      37.749 -33.948   0.764  1.00 64.45      A    C  
ATOM    557  NE1 TRP   107      37.178 -34.455  -0.377  1.00 65.36      A    N  
ATOM    558  CE2 TRP   107      36.661 -33.425  -1.117  1.00 63.71      A    C  
ATOM    559  CD2 TRP   107      36.913 -32.231  -0.408  1.00 63.14      A    C  
ATOM    560  CE3 TRP   107      36.481 -31.017  -0.957  1.00 60.76      A    C  
ATOM    561  CZ3 TRP   107      35.822 -31.035  -2.188  1.00 63.26      A    C  
ATOM    562  CH2 TRP   107      35.583 -32.242  -2.864  1.00 62.56      A    C  
ATOM    563  CZ2 TRP   107      35.996 -33.441  -2.350  1.00 63.71      A    C  
ATOM    564  C   TRP   107      36.088 -32.487   3.158  1.00 68.02      A    C  
ATOM    565  O   TRP   107      35.038 -32.587   2.516  1.00 67.19      A    O  
ATOM    566  N   GLN   108      36.462 -33.367   4.090  1.00 81.54      A    N  
ATOM    567  CA  GLN   108      35.651 -34.544   4.428  1.00 86.61      A    C  
ATOM    568  CB  GLN   108      36.355 -35.444   5.453  1.00 94.14      A    C  
ATOM    569  CG  GLN   108      37.838 -35.684   5.202  1.00100.96      A    C  
ATOM    570  CD  GLN   108      38.722 -34.745   6.006  1.00102.76      A    C  
ATOM    571  OE1 GLN   108      39.223 -33.746   5.486  1.00 97.70      A    O  
ATOM    572  NE2 GLN   108      38.908 -35.060   7.288  1.00109.40      A    N  
ATOM    573  C   GLN   108      34.288 -34.148   4.977  1.00 84.65      A    C  
ATOM    574  O   GLN   108      33.279 -34.788   4.683  1.00 85.99      A    O  
ATOM    575  N   ASP   109      34.272 -33.087   5.776  1.00 83.07      A    N  
ATOM    576  CA  ASP   109      33.076 -32.667   6.485  1.00 82.93      A    C  
ATOM    577  CB  ASP   109      33.458 -32.054   7.837  1.00 85.14      A    C  
ATOM    578  CG  ASP   109      33.997 -33.091   8.823  1.00 92.55      A    C  
ATOM    579  OD1 ASP   109      33.546 -34.258   8.794  1.00 96.19      A    O  
ATOM    580  OD2 ASP   109      34.871 -32.738   9.637  1.00 95.06      A    O  
ATOM    581  C   ASP   109      32.200 -31.720   5.661  1.00 77.96      A    C  
ATOM    582  O   ASP   109      31.094 -31.376   6.079  1.00 78.84      A    O  
ATOM    583  N   LEU   110      32.685 -31.320   4.488  1.00 74.26      A    N  
ATOM    584  CA  LEU   110      31.899 -30.489   3.577  1.00 70.92      A    C  
ATOM    585  CB  LEU   110      32.768 -29.936   2.443  1.00 67.27      A    C  
ATOM    586  CG  LEU   110      33.781 -28.845   2.798  1.00 65.09      A    C  
ATOM    587  CD1 LEU   110      34.700 -28.569   1.631  1.00 63.20      A    C  
ATOM    588  CD2 LEU   110      33.085 -27.570   3.234  1.00 62.99      A    C  
ATOM    589  C   LEU   110      30.732 -31.285   3.010  1.00 73.58      A    C  
ATOM    590  O   LEU   110      30.908 -32.409   2.549  1.00 76.26      A    O  
ATOM    591  N   GLU   111      29.540 -30.700   3.062  1.00 74.24      A    N  
ATOM    592  CA  GLU   111      28.329 -31.373   2.607  1.00 78.02      A    C  
ATOM    593  CB  GLU   111      27.497 -31.848   3.800  1.00 82.71      A    C  
ATOM    594  CG  GLU   111      28.116 -33.011   4.560  1.00 90.53      A    C  
ATOM    595  CD  GLU   111      27.602 -33.126   5.988  1.00 98.41      A    C  
ATOM    596  OE1 GLU   111      26.455 -33.590   6.180  1.00102.57      A    O  
ATOM    597  OE2 GLU   111      28.355 -32.761   6.920  1.00100.99      A    O  
ATOM    598  C   GLU   111      27.490 -30.469   1.715  1.00 76.64      A    C  
ATOM    599  O   GLU   111      27.457 -29.251   1.901  1.00 75.67      A    O  
ATOM    600  N   VAL   112      26.813 -31.083   0.749  1.00 78.34      A    N  
ATOM    601  CA  VAL   112      25.915 -30.384  -0.168  1.00 77.86      A    C  
ATOM    602  CB  VAL   112      25.330 -31.365  -1.218  1.00 81.46      A    C  
ATOM    603  CG1 VAL   112      24.284 -30.689  -2.078  1.00 82.23      A    C  
ATOM    604  CG2 VAL   112      26.442 -31.937  -2.088  1.00 78.08      A    C  
ATOM    605  C   VAL   112      24.794 -29.655   0.586  1.00 80.43      A    C  
ATOM    606  O   VAL   112      24.029 -30.264   1.345  1.00 83.79      A    O  
ATOM    607  N   GLY   113      24.722 -28.342   0.386  1.00 79.05      A    N  
ATOM    608  CA  GLY   113      23.639 -27.542   0.943  1.00 82.32      A    C  
ATOM    609  C   GLY   113      24.029 -26.621   2.082  1.00 81.33      A    C  
ATOM    610  O   GLY   113      23.254 -25.742   2.463  1.00 84.67      A    O  
ATOM    611  N   GLN   114      25.226 -26.827   2.628  1.00 77.51      A    N  
ATOM    612  CA  GLN   114      25.771 -25.961   3.668  1.00 76.18      A    C  
ATOM    613  CB  GLN   114      27.088 -26.527   4.198  1.00 74.01      A    C  
ATOM    614  CG  GLN   114      26.983 -27.842   4.950  1.00 78.35      A    C  
ATOM    615  CD  GLN   114      28.343 -28.391   5.344  1.00 76.40      A    C  
ATOM    616  OE1 GLN   114      29.316 -28.243   4.614  1.00 73.16      A    O  
ATOM    617  NE2 GLN   114      28.412 -29.031   6.502  1.00 82.18      A    N  
ATOM    618  C   GLN   114      26.038 -24.559   3.130  1.00 73.65      A    C  
ATOM    619  O   GLN   114      26.486 -24.404   1.987  1.00 70.71      A    O  
ATOM    620  N   VAL   115      25.760 -23.544   3.949  1.00 75.05      A    N  
ATOM    621  CA  VAL   115      26.222 -22.194   3.640  1.00 72.83      A    C  
ATOM    622  CB  VAL   115      25.147 -21.100   3.813  1.00 76.99      A    C  
ATOM    623  CG1 VAL   115      23.943 -21.419   2.939  1.00 81.10      A    C  
ATOM    624  CG2 VAL   115      24.744 -20.935   5.272  1.00 83.11      A    C  
ATOM    625  C   VAL   115      27.496 -21.896   4.416  1.00 70.02      A    C  
ATOM    626  O   VAL   115      27.543 -21.972   5.652  1.00 71.87      A    O  
ATOM    627  N   VAL   116      28.535 -21.575   3.657  1.00 65.64      A    N  
ATOM    628  CA  VAL   116      29.880 -21.463   4.175  1.00 63.59      A    C  
ATOM    629  CB  VAL   116      30.730 -22.663   3.704  1.00 62.16      A    C  
ATOM    630  CG1 VAL   116      30.220 -23.965   4.306  1.00 63.67      A    C  
ATOM    631  CG2 VAL   116      30.729 -22.751   2.189  1.00 60.61      A    C  
ATOM    632  C   VAL   116      30.519 -20.168   3.671  1.00 62.26      A    C  
ATOM    633  O   VAL   116      29.996 -19.539   2.752  1.00 61.77      A    O  
ATOM    634  N   MET   117      31.639 -19.770   4.276  1.00 61.42      A    N  
ATOM    635  CA  MET   117      32.456 -18.698   3.712  1.00 60.96      A    C  
ATOM    636  CB  MET   117      32.820 -17.642   4.757  1.00 61.90      A    C  
ATOM    637  CG  MET   117      33.221 -16.318   4.116  1.00 62.48      A    C  
ATOM    638  SD  MET   117      33.916 -15.018   5.390  1.00 66.12      A   SE  
ATOM    639  CE  MET   117      35.602 -15.886   5.817  1.00 66.17      A    C  
ATOM    640  C   MET   117      33.716 -19.269   3.064  1.00 58.29      A    C  
ATOM    641  O   MET   117      34.464 -20.014   3.688  1.00 59.06      A    O  
ATOM    642  N   LEU   118      33.946 -18.901   1.812  1.00 57.12      A    N  
ATOM    643  CA  LEU   118      35.039 -19.463   1.034  1.00 56.29      A    C  
ATOM    644  CB  LEU   118      34.557 -20.698   0.265  1.00 56.76      A    C  
ATOM    645  CG  LEU   118      33.252 -20.615  -0.531  1.00 57.64      A    C  
ATOM    646  CD1 LEU   118      33.420 -19.891  -1.874  1.00 59.59      A    C  
ATOM    647  CD2 LEU   118      32.730 -22.021  -0.747  1.00 60.22      A    C  
ATOM    648  C   LEU   118      35.646 -18.452   0.064  1.00 56.96      A    C  
ATOM    649  O   LEU   118      35.047 -17.412  -0.233  1.00 57.12      A    O  
ATOM    650  N   ASN   119      36.832 -18.789  -0.438  1.00 56.86      A    N  
ATOM    651  CA  ASN   119      37.591 -17.907  -1.306  1.00 57.26      A    C  
ATOM    652  CB  ASN   119      39.094 -18.065  -1.047  1.00 58.13      A    C  
ATOM    653  CG  ASN   119      39.881 -16.825  -1.412  1.00 59.37      A    C  
ATOM    654  OD1 ASN   119      40.059 -16.510  -2.592  1.00 52.64      A    O  
ATOM    655  ND2 ASN   119      40.346 -16.097  -0.389  1.00 56.44      A    N  
ATOM    656  C   ASN   119      37.264 -18.177  -2.756  1.00 58.04      A    C  
ATOM    657  O   ASN   119      37.354 -19.312  -3.229  1.00 59.26      A    O  
ATOM    658  N   TYR   120      36.866 -17.127  -3.459  1.00 58.92      A    N  
ATOM    659  CA  TYR   120      36.514 -17.235  -4.856  1.00 58.75      A    C  
ATOM    660  CB  TYR   120      35.028 -17.595  -4.993  1.00 60.08      A    C  
ATOM    661  CG  TYR   120      34.561 -17.864  -6.416  1.00 63.34      A    C  
ATOM    662  CD1 TYR   120      35.007 -18.984  -7.126  1.00 65.99      A    C  
ATOM    663  CE1 TYR   120      34.575 -19.233  -8.437  1.00 67.83      A    C  
ATOM    664  CZ  TYR   120      33.681 -18.356  -9.046  1.00 74.16      A    C  
ATOM    665  OH  TYR   120      33.240 -18.592 -10.343  1.00 80.05      A    O  
ATOM    666  CE2 TYR   120      33.219 -17.243  -8.356  1.00 72.18      A    C  
ATOM    667  CD2 TYR   120      33.662 -17.003  -7.047  1.00 68.44      A    C  
ATOM    668  C   TYR   120      36.837 -15.934  -5.568  1.00 61.83      A    C  
ATOM    669  O   TYR   120      36.938 -14.887  -4.938  1.00 58.65      A    O  
ATOM    670  N   ASN   121      36.987 -16.005  -6.894  1.00 66.19      A    N  
ATOM    671  CA  ASN   121      37.288 -14.834  -7.695  1.00 69.65      A    C  
ATOM    672  CB  ASN   121      38.759 -14.832  -8.091  1.00 71.49      A    C  
ATOM    673  CG  ASN   121      39.213 -13.497  -8.646  1.00 78.45      A    C  
ATOM    674  OD1 ASN   121      38.577 -12.918  -9.538  1.00 85.52      A    O  
ATOM    675  ND2 ASN   121      40.341 -13.013  -8.144  1.00 77.55      A    N  
ATOM    676  C   ASN   121      36.384 -14.766  -8.924  1.00 77.49      A    C  
ATOM    677  O   ASN   121      36.703 -15.335  -9.972  1.00 78.65      A    O  
ATOM    678  N   PRO   122      35.246 -14.063  -8.791  1.00 80.08      A    N  
ATOM    679  CA  PRO   122      34.210 -13.957  -9.812  1.00 86.20      A    C  
ATOM    680  CB  PRO   122      33.292 -12.865  -9.259  1.00 86.42      A    C  
ATOM    681  CG  PRO   122      33.448 -12.974  -7.791  1.00 82.10      A    C  
ATOM    682  CD  PRO   122      34.890 -13.316  -7.567  1.00 76.62      A    C  
ATOM    683  C   PRO   122      34.740 -13.582 -11.205  1.00 95.34      A    C  
ATOM    684  O   PRO   122      34.304 -14.165 -12.200  1.00 98.08      A    O  
ATOM    685  N   ASP   123      35.680 -12.637 -11.255  1.00 98.70      A    N  
ATOM    686  CA  ASP   123      36.210 -12.096 -12.512  1.00107.79      A    C  
ATOM    687  CB  ASP   123      36.952 -10.783 -12.250  1.00110.01      A    C  
ATOM    688  CG  ASP   123      36.012  -9.599 -12.080  1.00113.62      A    C  
ATOM    689  OD1 ASP   123      35.072  -9.457 -12.894  1.00118.87      A    O  
ATOM    690  OD2 ASP   123      36.223  -8.800 -11.140  1.00109.85      A    O  
ATOM    691  C   ASP   123      37.124 -13.073 -13.247  1.00110.22      A    C  
ATOM    692  O   ASP   123      37.163 -13.092 -14.484  1.00119.05      A    O  
ATOM    693  N   ASN   124      37.868 -13.860 -12.472  1.00104.22      A    N  
ATOM    694  CA  ASN   124      38.691 -14.958 -12.984  1.00106.51      A    C  
ATOM    695  CB  ASN   124      40.090 -14.477 -13.400  1.00111.43      A    C  
ATOM    696  CG  ASN   124      40.625 -13.375 -12.508  1.00109.34      A    C  
ATOM    697  OD1 ASN   124      40.850 -12.255 -12.961  1.00114.42      A    O  
ATOM    698  ND2 ASN   124      40.823 -13.685 -11.229  1.00102.69      A    N  
ATOM    699  C   ASN   124      38.754 -16.096 -11.960  1.00 99.63      A    C  
ATOM    700  O   ASN   124      39.585 -16.073 -11.036  1.00 94.87      A    O  
ATOM    701  N   PRO   125      37.834 -17.072 -12.096  1.00 98.76      A    N  
ATOM    702  CA  PRO   125      37.609 -18.161 -11.135  1.00 93.07      A    C  
ATOM    703  CB  PRO   125      36.475 -18.965 -11.787  1.00 95.03      A    C  
ATOM    704  CG  PRO   125      35.763 -17.960 -12.623  1.00100.37      A    C  
ATOM    705  CD  PRO   125      36.874 -17.146 -13.209  1.00104.85      A    C  
ATOM    706  C   PRO   125      38.812 -19.059 -10.845  1.00 92.16      A    C  
ATOM    707  O   PRO   125      38.794 -19.805  -9.862  1.00 88.10      A    O  
ATOM    708  N   LYS   126      39.842 -18.980 -11.681  1.00 97.48      A    N  
ATOM    709  CA  LYS   126      41.031 -19.804 -11.512  1.00 97.83      A    C  
ATOM    710  CB  LYS   126      41.771 -19.925 -12.846  1.00106.86      A    C  
ATOM    711  CG  LYS   126      42.246 -21.332 -13.163  1.00110.33      A    C  
ATOM    712  CD  LYS   126      42.605 -21.471 -14.634  1.00120.99      A    C  
ATOM    715  C   LYS   126      41.958 -19.245 -10.424  1.00 93.86      A    C  
ATOM    716  O   LYS   126      42.812 -19.961  -9.895  1.00 93.82      A    O  
ATOM    717  N   GLU   127      41.772 -17.973 -10.080  1.00 90.96      A    N  
ATOM    718  CA  GLU   127      42.707 -17.271  -9.204  1.00 89.03      A    C  
ATOM    719  CB  GLU   127      43.092 -15.909  -9.803  1.00 93.54      A    C  
ATOM    720  CG  GLU   127      43.371 -15.901 -11.315  1.00103.30      A    C  
ATOM    721  CD  GLU   127      44.637 -16.650 -11.711  1.00110.07      A    C  
ATOM    722  OE1 GLU   127      45.603 -16.662 -10.911  1.00107.71      A    O  
ATOM    723  OE2 GLU   127      44.666 -17.215 -12.835  1.00117.64      A    O  
ATOM    724  C   GLU   127      42.157 -17.070  -7.795  1.00 81.22      A    C  
ATOM    725  O   GLU   127      40.973 -17.283  -7.540  1.00 77.05      A    O  
ATOM    726  N   ARG   128      43.042 -16.663  -6.890  1.00 79.99      A    N  
ATOM    727  CA  ARG   128      42.665 -16.219  -5.550  1.00 75.18      A    C  
ATOM    728  CB  ARG   128      43.931 -15.974  -4.728  1.00 76.60      A    C  
ATOM    729  CG  ARG   128      43.724 -15.886  -3.242  1.00 73.49      A    C  
ATOM    730  CD  ARG   128      44.193 -17.147  -2.542  1.00 75.64      A    C  
ATOM    731  NE  ARG   128      43.646 -17.232  -1.188  1.00 72.47      A    N  
ATOM    732  CZ  ARG   128      43.729 -18.300  -0.402  1.00 70.66      A    C  
ATOM    733  NH1 ARG   128      44.344 -19.402  -0.816  1.00 72.28      A    N  
ATOM    734  NH2 ARG   128      43.187 -18.265   0.806  1.00 68.19      A    N  
ATOM    735  C   ARG   128      41.853 -14.923  -5.645  1.00 73.74      A    C  
ATOM    736  O   ARG   128      42.171 -14.051  -6.458  1.00 78.40      A    O  
ATOM    737  N   GLY   129      40.801 -14.816  -4.832  1.00 68.65      A    N  
ATOM    738  CA  GLY   129      39.968 -13.607  -4.753  1.00 67.08      A    C  
ATOM    739  C   GLY   129      39.572 -13.235  -3.324  1.00 63.44      A    C  
ATOM    740  O   GLY   129      40.431 -13.034  -2.461  1.00 62.31      A    O  
ATOM    741  N   PHE   130      38.265 -13.163  -3.078  1.00 61.38      A    N  
ATOM    742  CA  PHE   130      37.728 -12.673  -1.812  1.00 59.66      A    C  
ATOM    743  CB  PHE   130      36.996 -11.352  -2.025  1.00 63.17      A    C  
ATOM    744  CG  PHE   130      37.902 -10.225  -2.408  1.00 68.02      A    C  
ATOM    745  CD1 PHE   130      38.714  -9.614  -1.451  1.00 66.81      A    C  
ATOM    746  CE1 PHE   130      39.567  -8.575  -1.803  1.00 70.40      A    C  
ATOM    747  CZ  PHE   130      39.615  -8.142  -3.122  1.00 73.35      A    C  
ATOM    748  CE2 PHE   130      38.814  -8.750  -4.085  1.00 74.05      A    C  
ATOM    749  CD2 PHE   130      37.966  -9.788  -3.726  1.00 69.66      A    C  
ATOM    750  C   PHE   130      36.801 -13.666  -1.143  1.00 57.34      A    C  
ATOM    751  O   PHE   130      36.334 -14.608  -1.796  1.00 55.77      A    O  
ATOM    752  N   TRP   131      36.561 -13.442   0.159  1.00 49.70      A    N  
ATOM    753  CA  TRP   131      35.706 -14.272   0.989  1.00 51.23      A    C  
ATOM    754  CB  TRP   131      36.162 -14.149   2.445  1.00 50.95      A    C  
ATOM    755  CG  TRP   131      37.572 -14.545   2.508  1.00 47.90      A    C  
ATOM    756  CD1 TRP   131      38.665 -13.738   2.335  1.00 46.38      A    C  
ATOM    757  NE1 TRP   131      39.818 -14.490   2.399  1.00 43.72      A    N  
ATOM    758  CE2 TRP   131      39.480 -15.811   2.579  1.00 43.47      A    C  
ATOM    759  CD2 TRP   131      38.070 -15.884   2.632  1.00 47.54      A    C  
ATOM    760  CE3 TRP   131      37.460 -17.139   2.809  1.00 50.34      A    C  
ATOM    761  CZ3 TRP   131      38.272 -18.267   2.948  1.00 49.31      A    C  
ATOM    762  CH2 TRP   131      39.676 -18.159   2.898  1.00 47.35      A    C  
ATOM    763  CZ2 TRP   131      40.296 -16.946   2.703  1.00 45.25      A    C  
ATOM    764  C   TRP   131      34.214 -13.976   0.855  1.00 56.74      A    C  
ATOM    765  O   TRP   131      33.694 -13.045   1.493  1.00 58.95      A    O  
ATOM    766  N   TYR   132      33.546 -14.787   0.027  1.00 57.70      A    N  
ATOM    767  CA  TYR   132      32.093 -14.756  -0.155  1.00 62.06      A    C  
ATOM    768  CB  TYR   132      31.738 -14.902  -1.640  1.00 64.36      A    C  
ATOM    769  CG  TYR   132      32.346 -13.845  -2.512  1.00 66.16      A    C  
ATOM    770  CD1 TYR   132      31.693 -12.636  -2.724  1.00 69.59      A    C  
ATOM    771  CE1 TYR   132      32.252 -11.656  -3.516  1.00 70.75      A    C  
ATOM    772  CZ  TYR   132      33.480 -11.880  -4.109  1.00 68.34      A    C  
ATOM    773  OH  TYR   132      34.038 -10.905  -4.903  1.00 72.83      A    O  
ATOM    774  CE2 TYR   132      34.149 -13.073  -3.917  1.00 64.55      A    C  
ATOM    775  CD2 TYR   132      33.579 -14.048  -3.122  1.00 64.03      A    C  
ATOM    776  C   TYR   132      31.413 -15.900   0.577  1.00 61.98      A    C  
ATOM    777  O   TYR   132      32.010 -16.959   0.773  1.00 60.18      A    O  
ATOM    778  N   ASP   133      30.155 -15.686   0.959  1.00 64.85      A    N  
ATOM    779  CA  ASP   133      29.273 -16.783   1.352  1.00 65.55      A    C  
ATOM    780  CB  ASP   133      28.057 -16.258   2.099  1.00 68.42      A    C  
ATOM    781  CG  ASP   133      28.402 -15.750   3.477  1.00 69.42      A    C  
ATOM    782  OD1 ASP   133      29.599 -15.713   3.823  1.00 64.53      A    O  
ATOM    783  OD2 ASP   133      27.468 -15.378   4.215  1.00 76.31      A    O  
ATOM    784  C   ASP   133      28.823 -17.591   0.136  1.00 66.63      A    C  
ATOM    785  O   ASP   133      28.615 -17.038  -0.950  1.00 67.26      A    O  
ATOM    786  N   ALA   134      28.668 -18.897   0.333  1.00 65.82      A    N  
ATOM    787  CA  ALA   134      28.311 -19.804  -0.745  1.00 67.57      A    C  
ATOM    788  CB  ALA   134      29.558 -20.239  -1.510  1.00 64.02      A    C  
ATOM    789  C   ALA   134      27.558 -21.022  -0.232  1.00 69.20      A    C  
ATOM    790  O   ALA   134      27.790 -21.492   0.884  1.00 68.34      A    O  
ATOM    791  N   GLU   135      26.655 -21.525  -1.066  1.00 72.04      A    N  
ATOM    792  CA  GLU   135      25.925 -22.744  -0.785  1.00 72.93      A    C  
ATOM    793  CB  GLU   135      24.484 -22.591  -1.263  1.00 77.11      A    C  
ATOM    794  CG  GLU   135      23.524 -23.682  -0.821  1.00 78.37      A    C  
ATOM    795  CD  GLU   135      22.088 -23.368  -1.212  1.00 84.76      A    C  
ATOM    796  OE1 GLU   135      21.844 -23.039  -2.399  1.00 85.93      A    O  
ATOM    797  OE2 GLU   135      21.203 -23.447  -0.328  1.00 88.15      A    O  
ATOM    798  C   GLU   135      26.616 -23.878  -1.529  1.00 71.76      A    C  
ATOM    799  O   GLU   135      26.707 -23.854  -2.758  1.00 73.06      A    O  
ATOM    800  N   ILE   136      27.121 -24.862  -0.792  1.00 69.88      A    N  
ATOM    801  CA  ILE   136      27.764 -26.015  -1.425  1.00 68.91      A    C  
ATOM    802  CB  ILE   136      28.472 -26.926  -0.400  1.00 67.43      A    C  
ATOM    803  CG1 ILE   136      29.694 -26.201   0.170  1.00 62.29      A    C  
ATOM    804  CD1 ILE   136      29.976 -26.548   1.601  1.00 63.43      A    C  
ATOM    805  CG2 ILE   136      28.913 -28.244  -1.043  1.00 67.94      A    C  
ATOM    806  C   ILE   136      26.741 -26.759  -2.275  1.00 72.33      A    C  
ATOM    807  O   ILE   136      25.671 -27.145  -1.795  1.00 74.69      A    O  
ATOM    808  N   SER   137      27.080 -26.921  -3.548  1.00 72.39      A    N  
ATOM    809  CA  SER   137      26.134 -27.344  -4.560  1.00 76.27      A    C  
ATOM    810  CB  SER   137      26.209 -26.382  -5.745  1.00 76.90      A    C  
ATOM    811  OG  SER   137      25.221 -26.684  -6.705  1.00 82.68      A    O  
ATOM    812  C   SER   137      26.401 -28.785  -5.001  1.00 77.57      A    C  
ATOM    813  O   SER   137      25.517 -29.638  -4.931  1.00 79.63      A    O  
ATOM    814  N   ARG   138      27.628 -29.038  -5.451  1.00 76.31      A    N  
ATOM    815  CA  ARG   138      28.067 -30.361  -5.869  1.00 77.35      A    C  
ATOM    816  CB  ARG   138      28.178 -30.448  -7.393  1.00 79.55      A    C  
ATOM    817  CG  ARG   138      26.877 -30.215  -8.119  1.00 85.11      A    C  
ATOM    818  CD  ARG   138      26.947 -30.659  -9.564  1.00 89.42      A    C  
ATOM    819  NE  ARG   138      27.580 -29.666 -10.429  1.00 89.97      A    N  
ATOM    820  CZ  ARG   138      28.649 -29.898 -11.183  1.00 89.04      A    C  
ATOM    821  NH1 ARG   138      29.145 -28.930 -11.941  1.00 88.78      A    N  
ATOM    822  NH2 ARG   138      29.218 -31.098 -11.191  1.00 89.11      A    N  
ATOM    823  C   ARG   138      29.419 -30.657  -5.251  1.00 74.79      A    C  
ATOM    824  O   ARG   138      30.264 -29.765  -5.126  1.00 71.88      A    O  
ATOM    825  N   LYS   139      29.613 -31.914  -4.866  1.00 75.98      A    N  
ATOM    826  CA  LYS   139      30.874 -32.372  -4.306  1.00 74.86      A    C  
ATOM    827  CB  LYS   139      30.779 -32.469  -2.782  1.00 73.48      A    C  
ATOM    828  CG  LYS   139      32.087 -32.834  -2.115  1.00 71.58      A    C  
ATOM    829  CD  LYS   139      31.904 -32.996  -0.626  1.00 72.19      A    C  
ATOM    830  CE  LYS   139      33.155 -33.579  -0.006  1.00 72.78      A    C  
ATOM    831  NZ  LYS   139      32.987 -33.821   1.453  1.00 73.28      A    N  
ATOM    832  C   LYS   139      31.272 -33.712  -4.933  1.00 77.81      A    C  
ATOM    833  O   LYS   139      30.529 -34.697  -4.856  1.00 79.78      A    O  
ATOM    834  N   ARG   140      32.446 -33.724  -5.561  1.00 77.81      A    N  
ATOM    835  CA  ARG   140      32.943 -34.878  -6.310  1.00 80.86      A    C  
ATOM    836  CB  ARG   140      32.831 -34.614  -7.815  1.00 83.30      A    C  
ATOM    837  CG  ARG   140      31.731 -35.391  -8.524  1.00 91.05      A    C  
ATOM    838  CD  ARG   140      32.212 -36.778  -8.943  1.00 96.65      A    C  
ATOM    839  NE  ARG   140      33.416 -36.699  -9.771  1.00 98.96      A    N  
ATOM    840  CZ  ARG   140      33.469 -36.995 -11.067  1.00103.38      A    C  
ATOM    841  NH1 ARG   140      32.384 -37.411 -11.709  1.00108.22      A    N  
ATOM    842  NH2 ARG   140      34.617 -36.887 -11.723  1.00103.90      A    N  
ATOM    843  C   ARG   140      34.393 -35.183  -5.967  1.00 79.17      A    C  
ATOM    844  O   ARG   140      35.221 -34.279  -5.877  1.00 76.53      A    O  
ATOM    845  N   GLU   141      34.702 -36.461  -5.784  1.00 80.97      A    N  
ATOM    846  CA  GLU   141      36.079 -36.872  -5.552  1.00 80.09      A    C  
ATOM    847  CB  GLU   141      36.318 -37.213  -4.081  1.00 78.65      A    C  
ATOM    848  CG  GLU   141      37.779 -37.137  -3.680  1.00 78.55      A    C  
ATOM    849  CD  GLU   141      38.015 -37.247  -2.182  1.00 77.93      A    C  
ATOM    850  OE1 GLU   141      37.038 -37.196  -1.405  1.00 78.44      A    O  
ATOM    851  OE2 GLU   141      39.194 -37.383  -1.781  1.00 77.29      A    O  
ATOM    852  C   GLU   141      36.508 -38.020  -6.465  1.00 83.79      A    C  
ATOM    853  O   GLU   141      35.761 -38.959  -6.720  1.00 86.12      A    O  
ATOM    854  N   THR   142      37.732 -37.899  -6.956  1.00 63.92      A    N  
ATOM    855  CA  THR   142      38.372 -38.851  -7.848  1.00 63.74      A    C  
ATOM    856  CB  THR   142      38.654 -38.156  -9.215  1.00 66.30      A    C  
ATOM    857  OG1 THR   142      37.666 -38.567 -10.168  1.00 66.73      A    O  
ATOM    858  CG2 THR   142      40.026 -38.473  -9.776  1.00 71.31      A    C  
ATOM    859  C   THR   142      39.630 -39.330  -7.117  1.00 63.29      A    C  
ATOM    860  O   THR   142      39.944 -38.823  -6.025  1.00 64.51      A    O  
ATOM    861  N   ARG   143      40.326 -40.317  -7.675  1.00 63.14      A    N  
ATOM    862  CA  ARG   143      41.597 -40.770  -7.109  1.00 63.64      A    C  
ATOM    863  CB  ARG   143      42.221 -41.858  -7.977  1.00 64.32      A    C  
ATOM    864  CG  ARG   143      41.596 -43.245  -7.869  1.00 64.07      A    C  
ATOM    865  CD  ARG   143      42.347 -44.211  -8.831  1.00 64.06      A    C  
ATOM    866  NE  ARG   143      41.787 -45.568  -8.930  1.00 62.34      A    N  
ATOM    867  CZ  ARG   143      41.671 -46.437  -7.915  1.00 62.98      A    C  
ATOM    868  NH1 ARG   143      42.045 -46.114  -6.669  1.00 52.94      A    N  
ATOM    869  NH2 ARG   143      41.163 -47.643  -8.148  1.00 61.64      A    N  
ATOM    870  C   ARG   143      42.601 -39.619  -6.916  1.00 65.93      A    C  
ATOM    871  O   ARG   143      43.346 -39.596  -5.929  1.00 67.55      A    O  
ATOM    872  N   THR   144      42.601 -38.666  -7.848  1.00 67.27      A    N  
ATOM    873  CA  THR   144      43.565 -37.562  -7.855  1.00 71.21      A    C  
ATOM    874  CB  THR   144      44.425 -37.591  -9.130  1.00 74.46      A    C  
ATOM    875  OG1 THR   144      43.566 -37.704 -10.270  1.00 74.50      A    O  
ATOM    876  CG2 THR   144      45.397 -38.767  -9.108  1.00 73.69      A    C  
ATOM    877  C   THR   144      42.938 -36.165  -7.756  1.00 73.03      A    C  
ATOM    878  O   THR   144      43.651 -35.186  -7.568  1.00 77.46      A    O  
ATOM    879  N   ALA   145      41.617 -36.073  -7.882  1.00 71.51      A    N  
ATOM    880  CA  ALA   145      40.935 -34.776  -7.947  1.00 73.21      A    C  
ATOM    881  CB  ALA   145      40.374 -34.544  -9.350  1.00 74.63      A    C  
ATOM    882  C   ALA   145      39.825 -34.619  -6.906  1.00 70.73      A    C  
ATOM    883  O   ALA   145      39.049 -35.544  -6.667  1.00 68.81      A    O  
ATOM    884  N   ARG   146      39.765 -33.441  -6.291  1.00 72.52      A    N  
ATOM    885  CA  ARG   146      38.660 -33.067  -5.401  1.00 71.12      A    C  
ATOM    886  CB  ARG   146      39.164 -32.716  -4.001  1.00 70.21      A    C  
ATOM    887  CG  ARG   146      39.659 -33.912  -3.215  1.00 70.44      A    C  
ATOM    888  CD  ARG   146      40.246 -33.502  -1.882  1.00 72.19      A    C  
ATOM    889  NE  ARG   146      41.331 -32.537  -2.043  1.00 76.34      A    N  
ATOM    890  CZ  ARG   146      41.717 -31.677  -1.105  1.00 79.37      A    C  
ATOM    891  NH1 ARG   146      41.109 -31.647   0.073  1.00 79.76      A    N  
ATOM    892  NH2 ARG   146      42.708 -30.834  -1.349  1.00 84.02      A    N  
ATOM    893  C   ARG   146      37.908 -31.892  -6.008  1.00 72.38      A    C  
ATOM    894  O   ARG   146      38.483 -30.830  -6.257  1.00 76.52      A    O  
ATOM    895  N   GLU   147      36.620 -32.088  -6.255  1.00 70.89      A    N  
ATOM    896  CA  GLU   147      35.828 -31.092  -6.962  1.00 72.27      A    C  
ATOM    897  CB  GLU   147      35.261 -31.688  -8.251  1.00 73.83      A    C  
ATOM    898  CG  GLU   147      36.336 -32.129  -9.238  1.00 78.97      A    C  
ATOM    899  CD  GLU   147      35.844 -33.164 -10.233  1.00 82.68      A    C  
ATOM    900  OE1 GLU   147      34.708 -33.023 -10.738  1.00 85.63      A    O  
ATOM    901  OE2 GLU   147      36.602 -34.121 -10.510  1.00 83.65      A    O  
ATOM    902  C   GLU   147      34.718 -30.537  -6.081  1.00 69.40      A    C  
ATOM    903  O   GLU   147      33.914 -31.289  -5.531  1.00 67.18      A    O  
ATOM    904  N   LEU   148      34.692 -29.215  -5.949  1.00 69.74      A    N  
ATOM    905  CA  LEU   148      33.662 -28.544  -5.175  1.00 67.30      A    C  
ATOM    906  CB  LEU   148      34.243 -27.963  -3.884  1.00 66.54      A    C  
ATOM    907  CG  LEU   148      33.276 -27.429  -2.823  1.00 64.58      A    C  
ATOM    908  CD1 LEU   148      32.415 -28.550  -2.267  1.00 59.27      A    C  
ATOM    909  CD2 LEU   148      34.048 -26.727  -1.710  1.00 63.81      A    C  
ATOM    910  C   LEU   148      32.982 -27.463  -6.002  1.00 70.05      A    C  
ATOM    911  O   LEU   148      33.641 -26.629  -6.631  1.00 72.97      A    O  
ATOM    912  N   TYR   149      31.654 -27.507  -6.004  1.00 69.71      A    N  
ATOM    913  CA  TYR   149      30.842 -26.527  -6.707  1.00 71.79      A    C  
ATOM    914  CB  TYR   149      30.053 -27.187  -7.847  1.00 74.98      A    C  
ATOM    915  CG  TYR   149      30.963 -27.719  -8.929  1.00 78.32      A    C  
ATOM    916  CD1 TYR   149      31.505 -29.004  -8.844  1.00 76.82      A    C  
ATOM    917  CE1 TYR   149      32.363 -29.492  -9.827  1.00 79.06      A    C  
ATOM    918  CZ  TYR   149      32.694 -28.685 -10.903  1.00 84.35      A    C  
ATOM    919  OH  TYR   149      33.544 -29.160 -11.878  1.00 88.75      A    O  
ATOM    920  CE2 TYR   149      32.173 -27.404 -11.008  1.00 86.90      A    C  
ATOM    921  CD2 TYR   149      31.317 -26.926 -10.020  1.00 83.14      A    C  
ATOM    922  C   TYR   149      29.935 -25.839  -5.704  1.00 69.60      A    C  
ATOM    923  O   TYR   149      29.459 -26.466  -4.757  1.00 67.80      A    O  
ATOM    924  N   ALA   150      29.723 -24.543  -5.896  1.00 70.24      A    N  
ATOM    925  CA  ALA   150      28.964 -23.765  -4.941  1.00 68.76      A    C  
ATOM    926  CB  ALA   150      29.885 -23.235  -3.834  1.00 67.20      A    C  
ATOM    927  C   ALA   150      28.202 -22.625  -5.596  1.00 72.22      A    C  
ATOM    928  O   ALA   150      28.631 -22.069  -6.612  1.00 74.74      A    O  
ATOM    929  N   ASN   151      27.055 -22.303  -5.003  1.00 72.44      A    N  
ATOM    930  CA  ASN   151      26.300 -21.119  -5.350  1.00 76.20      A    C  
ATOM    931  CB  ASN   151      24.810 -21.330  -5.072  1.00 76.85      A    C  
ATOM    932  CG  ASN   151      24.247 -22.554  -5.770  1.00 79.45      A    C  
ATOM    933  OD1 ASN   151      24.580 -22.845  -6.918  1.00 79.71      A    O  
ATOM    934  ND2 ASN   151      23.380 -23.276  -5.073  1.00 80.94      A    N  
ATOM    935  C   ASN   151      26.839 -19.979  -4.507  1.00 76.24      A    C  
ATOM    936  O   ASN   151      26.602 -19.927  -3.295  1.00 75.45      A    O  
ATOM    937  N   VAL   152      27.584 -19.081  -5.143  1.00 79.41      A    N  
ATOM    938  CA  VAL   152      28.259 -17.990  -4.444  1.00 79.50      A    C  
ATOM    939  CB  VAL   152      29.614 -17.661  -5.119  1.00 82.99      A    C  
ATOM    940  CG1 VAL   152      30.288 -16.454  -4.472  1.00 83.32      A    C  
ATOM    941  CG2 VAL   152      30.527 -18.868  -5.071  1.00 80.21      A    C  
ATOM    942  C   VAL   152      27.350 -16.759  -4.391  1.00 82.04      A    C  
ATOM    943  O   VAL   152      26.821 -16.325  -5.418  1.00 85.53      A    O  
ATOM    944  N   VAL   153      27.170 -16.213  -3.190  1.00 80.24      A    N  
ATOM    945  CA  VAL   153      26.318 -15.043  -2.970  1.00 81.79      A    C  
ATOM    946  CB  VAL   153      25.723 -15.040  -1.539  1.00 78.70      A    C  
ATOM    947  CG1 VAL   153      24.841 -13.821  -1.319  1.00 78.84      A    C  
ATOM    948  CG2 VAL   153      24.932 -16.323  -1.290  1.00 76.38      A    C  
ATOM    949  C   VAL   153      27.097 -13.751  -3.232  1.00 86.30      A    C  
ATOM    950  O   VAL   153      28.098 -13.467  -2.562  1.00 86.64      A    O  
ATOM    951  N   LEU   154      26.615 -12.970  -4.199  1.00 90.89      A    N  
ATOM    952  CA  LEU   154      27.335 -11.803  -4.699  1.00 96.61      A    C  
ATOM    953  CB  LEU   154      27.674 -12.010  -6.177  1.00102.18      A    C  
ATOM    954  CG  LEU   154      29.126 -11.829  -6.622  1.00107.79      A    C  
ATOM    955  CD1 LEU   154      29.946 -13.084  -6.325  1.00104.39      A    C  
ATOM    956  CD2 LEU   154      29.195 -11.476  -8.100  1.00115.33      A    C  
ATOM    957  C   LEU   154      26.523 -10.521  -4.528  1.00 98.73      A    C  
ATOM    958  O   LEU   154      26.057 -10.203  -3.430  1.00 95.85      A    O  
ATOM    959  N   ASP   156      20.327  -9.075  -2.880  1.00154.49      A    N  
ATOM    960  CA  ASP   156      21.569  -9.607  -3.441  1.00145.75      A    C  
ATOM    961  CB  ASP   156      22.488 -10.157  -2.331  1.00135.92      A    C  
ATOM    962  CG  ASP   156      21.872 -11.329  -1.568  1.00134.46      A    C  
ATOM    963  OD1 ASP   156      21.793 -12.447  -2.127  1.00132.68      A    O  
ATOM    964  OD2 ASP   156      21.490 -11.137  -0.394  1.00135.89      A    O  
ATOM    965  C   ASP   156      21.316 -10.670  -4.512  1.00145.37      A    C  
ATOM    966  O   ASP   156      20.268 -11.319  -4.518  1.00150.14      A    O  
ATOM    967  N   ASP   157      22.283 -10.837  -5.413  1.00140.52      A    N  
ATOM    968  CA  ASP   157      22.213 -11.861  -6.458  1.00139.58      A    C  
ATOM    969  CB  ASP   157      22.328 -11.238  -7.860  1.00145.97      A    C  
ATOM    970  CG  ASP   157      23.279 -10.046  -7.904  1.00145.70      A    C  
ATOM    971  OD1 ASP   157      22.852  -8.926  -7.545  1.00151.65      A    O  
ATOM    972  OD2 ASP   157      24.446 -10.224  -8.314  1.00140.51      A    O  
ATOM    973  C   ASP   157      23.284 -12.932  -6.249  1.00128.46      A    C  
ATOM    974  O   ASP   157      24.418 -12.619  -5.887  1.00122.38      A    O  
ATOM    975  N   SER   158      22.914 -14.192  -6.468  1.00126.34      A    N  
ATOM    976  CA  SER   158      23.850 -15.305  -6.310  1.00116.90      A    C  
ATOM    977  CB  SER   158      23.222 -16.443  -5.500  1.00115.95      A    C  
ATOM    978  OG  SER   158      22.159 -17.046  -6.211  1.00124.65      A    O  
ATOM    979  C   SER   158      24.386 -15.823  -7.647  1.00115.72      A    C  
ATOM    980  O   SER   158      23.766 -15.637  -8.693  1.00122.87      A    O  
ATOM    981  N   LEU   159      25.543 -16.475  -7.587  1.00107.30      A    N  
ATOM    982  CA  LEU   159      26.252 -16.962  -8.762  1.00105.78      A    C  
ATOM    983  CB  LEU   159      27.643 -16.324  -8.812  1.00100.96      A    C  
ATOM    984  CG  LEU   159      28.366 -16.132 -10.145  1.00104.00      A    C  
ATOM    985  CD2 LEU   159      27.532 -15.316 -11.129  1.00112.58      A    C  
ATOM    987  C   LEU   159      26.341 -18.490  -8.703  1.00102.25      A    C  
ATOM    988  O   LEU   159      27.136 -19.049  -7.948  1.00 95.25      A    O  
ATOM    989  N   ASN   160      25.514 -19.156  -9.504  1.00107.82      A    N  
ATOM    990  CA  ASN   160      25.321 -20.604  -9.394  1.00107.03      A    C  
ATOM    991  CB  ASN   160      23.945 -21.006  -9.941  1.00115.89      A    C  
ATOM    992  CG  ASN   160      22.789 -20.368  -9.174  1.00119.98      A    C  
ATOM    993  OD1 ASN   160      21.844 -19.859  -9.777  1.00128.07      A    O  
ATOM    994  ND2 ASN   160      22.859 -20.395  -7.844  1.00115.38      A    N  
ATOM    995  C   ASN   160      26.406 -21.460 -10.044  1.00103.95      A    C  
ATOM    996  O   ASN   160      26.986 -21.079 -11.064  1.00105.22      A    O  
ATOM    997  N   ASP   161      26.665 -22.614  -9.424  1.00100.72      A    N  
ATOM    998  CA  ASP   161      27.538 -23.670  -9.958  1.00 99.67      A    C  
ATOM    999  CB  ASP   161      26.903 -24.310 -11.206  1.00108.04      A    C  
ATOM   1000  CG  ASP   161      27.456 -25.693 -11.506  1.00109.23      A    C  
ATOM   1001  OD1 ASP   161      27.756 -26.442 -10.547  1.00105.93      A    O  
ATOM   1002  OD2 ASP   161      27.577 -26.033 -12.705  1.00114.11      A    O  
ATOM   1003  C   ASP   161      28.976 -23.220 -10.238  1.00 94.88      A    C  
ATOM   1004  O   ASP   161      29.499 -23.410 -11.340  1.00 97.52      A    O  
ATOM   1005  N   CYS   162      29.608 -22.634  -9.226  1.00 88.51      A    N  
ATOM   1006  CA  CYS   162      30.981 -22.149  -9.332  1.00 85.07      A    C  
ATOM   1007  CB  CYS   162      31.178 -20.924  -8.431  1.00 81.92      A    C  
ATOM   1008  SG  CYS   162      30.225 -19.464  -8.900  1.00 88.32      A    S  
ATOM   1009  C   CYS   162      31.993 -23.225  -8.942  1.00 81.26      A    C  
ATOM   1010  O   CYS   162      31.833 -23.883  -7.913  1.00 79.50      A    O  
ATOM   1011  N   ARG   163      33.041 -23.388  -9.748  1.00 80.96      A    N  
ATOM   1012  CA  ARG   163      34.135 -24.297  -9.403  1.00 78.45      A    C  
ATOM   1013  CB  ARG   163      34.936 -24.699 -10.649  1.00 82.87      A    C  
ATOM   1014  CG  ARG   163      36.139 -25.619 -10.389  1.00 83.57      A    C  
ATOM   1015  CD  ARG   163      35.735 -26.950  -9.752  1.00 86.25      A    C  
ATOM   1016  NE  ARG   163      36.895 -27.771  -9.402  1.00 86.46      A    N  
ATOM   1017  CZ  ARG   163      37.383 -28.758 -10.151  1.00 91.21      A    C  
ATOM   1018  NH1 ARG   163      36.813 -29.077 -11.312  1.00 95.37      A    N  
ATOM   1019  NH2 ARG   163      38.444 -29.439  -9.732  1.00 90.22      A    N  
ATOM   1020  C   ARG   163      35.044 -23.655  -8.359  1.00 73.09      A    C  
ATOM   1021  O   ARG   163      35.798 -22.727  -8.665  1.00 73.28      A    O  
ATOM   1022  N   ILE   164      34.963 -24.155  -7.129  1.00 68.86      A    N  
ATOM   1023  CA  ILE   164      35.743 -23.620  -6.011  1.00 63.46      A    C  
ATOM   1024  CB  ILE   164      34.998 -23.798  -4.656  1.00 61.55      A    C  
ATOM   1025  CG1 ILE   164      33.573 -23.218  -4.724  1.00 60.30      A    C  
ATOM   1026  CD1 ILE   164      33.499 -21.745  -5.097  1.00 60.78      A    C  
ATOM   1027  CG2 ILE   164      35.823 -23.220  -3.477  1.00 57.88      A    C  
ATOM   1028  C   ILE   164      37.130 -24.257  -5.942  1.00 63.17      A    C  
ATOM   1029  O   ILE   164      37.258 -25.473  -5.803  1.00 63.90      A    O  
ATOM   1030  N   ILE   165      38.160 -23.419  -6.033  1.00 63.23      A    N  
ATOM   1031  CA  ILE   165      39.553 -23.873  -6.071  1.00 64.54      A    C  
ATOM   1032  CB  ILE   165      40.486 -22.816  -6.735  1.00 65.87      A    C  
ATOM   1033  CG1 ILE   165      40.033 -22.474  -8.161  1.00 68.67      A    C  
ATOM   1034  CD1 ILE   165      39.820 -23.676  -9.066  1.00 70.55      A    C  
ATOM   1035  CG2 ILE   165      41.943 -23.279  -6.718  1.00 68.94      A    C  
ATOM   1036  C   ILE   165      40.090 -24.196  -4.681  1.00 63.36      A    C  
ATOM   1037  O   ILE   165      40.739 -25.220  -4.487  1.00 65.13      A    O  
ATOM   1038  N   PHE   166      39.808 -23.316  -3.724  1.00 60.96      A    N  
ATOM   1039  CA  PHE   166      40.423 -23.363  -2.391  1.00 61.51      A    C  
ATOM   1040  CB  PHE   166      40.778 -21.947  -1.921  1.00 59.92      A    C  
ATOM   1041  CG  PHE   166      41.515 -21.179  -2.976  1.00 63.59      A    C  
ATOM   1042  CD1 PHE   166      40.831 -20.338  -3.851  1.00 63.67      A    C  
ATOM   1043  CE1 PHE   166      41.500 -19.672  -4.874  1.00 65.74      A    C  
ATOM   1044  CZ  PHE   166      42.863 -19.866  -5.048  1.00 69.84      A    C  
ATOM   1045  CE2 PHE   166      43.555 -20.726  -4.199  1.00 71.18      A    C  
ATOM   1046  CD2 PHE   166      42.875 -21.391  -3.179  1.00 67.07      A    C  
ATOM   1047  C   PHE   166      39.555 -24.164  -1.448  1.00 60.34      A    C  
ATOM   1048  O   PHE   166      38.857 -23.654  -0.577  1.00 59.81      A    O  
ATOM   1049  N   VAL   167      39.639 -25.461  -1.683  1.00 61.90      A    N  
ATOM   1050  CA  VAL   167      38.760 -26.465  -1.138  1.00 62.51      A    C  
ATOM   1051  CB  VAL   167      38.817 -27.678  -2.085  1.00 66.35      A    C  
ATOM   1052  CG1 VAL   167      38.694 -29.004  -1.355  1.00 71.14      A    C  
ATOM   1053  CG2 VAL   167      37.789 -27.517  -3.209  1.00 67.21      A    C  
ATOM   1054  C   VAL   167      39.147 -26.822   0.296  1.00 62.61      A    C  
ATOM   1055  O   VAL   167      38.380 -27.472   1.015  1.00 61.76      A    O  
ATOM   1056  N   ASP   168      40.332 -26.369   0.706  1.00 63.36      A    N  
ATOM   1057  CA  ASP   168      40.879 -26.668   2.024  1.00 65.08      A    C  
ATOM   1058  CB  ASP   168      42.323 -27.177   1.907  1.00 68.67      A    C  
ATOM   1059  CG  ASP   168      42.404 -28.597   1.360  1.00 73.05      A    C  
ATOM   1060  OD1 ASP   168      41.677 -29.482   1.868  1.00 73.62      A    O  
ATOM   1061  OD2 ASP   168      43.199 -28.833   0.422  1.00 74.94      A    O  
ATOM   1062  C   ASP   168      40.810 -25.459   2.946  1.00 63.54      A    C  
ATOM   1063  O   ASP   168      41.340 -25.489   4.062  1.00 66.02      A    O  
ATOM   1064  N   GLU   169      40.141 -24.405   2.482  1.00 60.46      A    N  
ATOM   1065  CA  GLU   169      40.110 -23.134   3.207  1.00 59.46      A    C  
ATOM   1066  CB  GLU   169      40.988 -22.107   2.487  1.00 60.15      A    C  
ATOM   1067  CG  GLU   169      42.468 -22.435   2.516  1.00 60.33      A    C  
ATOM   1068  CD  GLU   169      43.285 -21.528   1.627  1.00 63.26      A    C  
ATOM   1069  OE1 GLU   169      43.919 -20.597   2.166  1.00 63.21      A    O  
ATOM   1070  OE2 GLU   169      43.296 -21.742   0.389  1.00 63.55      A    O  
ATOM   1071  C   GLU   169      38.691 -22.593   3.412  1.00 57.50      A    C  
ATOM   1072  O   GLU   169      38.475 -21.378   3.494  1.00 56.14      A    O  
ATOM   1073  N   VAL   170      37.735 -23.511   3.511  1.00 57.46      A    N  
ATOM   1074  CA  VAL   170      36.325 -23.175   3.636  1.00 56.44      A    C  
ATOM   1075  CB  VAL   170      35.449 -24.277   2.987  1.00 56.48      A    C  
ATOM   1076  CG1 VAL   170      33.980 -24.001   3.212  1.00 55.51      A    C  
ATOM   1077  CG2 VAL   170      35.751 -24.397   1.489  1.00 54.79      A    C  
ATOM   1078  C   VAL   170      35.952 -22.981   5.112  1.00 59.01      A    C  
ATOM   1079  O   VAL   170      36.236 -23.839   5.957  1.00 61.69      A    O  
ATOM   1080  N   PHE   171      35.312 -21.855   5.412  1.00 58.99      A    N  
ATOM   1081  CA  PHE   171      34.969 -21.499   6.783  1.00 61.65      A    C  
ATOM   1082  CB  PHE   171      35.233 -20.014   7.044  1.00 60.78      A    C  
ATOM   1083  CG  PHE   171      36.670 -19.678   7.281  1.00 60.82      A    C  
ATOM   1084  CD1 PHE   171      37.210 -19.739   8.562  1.00 60.71      A    C  
ATOM   1085  CE1 PHE   171      38.544 -19.413   8.789  1.00 60.33      A    C  
ATOM   1086  CZ  PHE   171      39.352 -19.009   7.736  1.00 61.60      A    C  
ATOM   1087  CE2 PHE   171      38.825 -18.946   6.441  1.00 61.24      A    C  
ATOM   1088  CD2 PHE   171      37.487 -19.275   6.224  1.00 60.28      A    C  
ATOM   1089  C   PHE   171      33.524 -21.794   7.147  1.00 64.12      A    C  
ATOM   1090  O   PHE   171      32.615 -21.693   6.314  1.00 64.50      A    O  
ATOM   1091  N   LYS   172      33.339 -22.152   8.413  1.00 77.04      A    N  
ATOM   1092  CA  LYS   172      32.037 -22.227   9.050  1.00 79.53      A    C  
ATOM   1093  CB  LYS   172      32.164 -23.050  10.337  1.00 88.91      A    C  
ATOM   1094  CG  LYS   172      30.940 -23.105  11.231  1.00 93.59      A    C  
ATOM   1095  CD  LYS   172      31.219 -24.011  12.426  1.00105.42      A    C  
ATOM   1096  CE  LYS   172      30.081 -24.008  13.435  1.00111.71      A    C  
ATOM   1097  NZ  LYS   172      30.086 -22.782  14.282  1.00110.49      A    N  
ATOM   1098  C   LYS   172      31.600 -20.804   9.366  1.00 77.33      A    C  
ATOM   1099  O   LYS   172      32.382 -20.015   9.907  1.00 79.81      A    O  
ATOM   1100  N   ILE   173      30.364 -20.468   9.018  1.00 76.02      A    N  
ATOM   1101  CA  ILE   173      29.820 -19.163   9.362  1.00 76.65      A    C  
ATOM   1102  CB  ILE   173      28.692 -18.719   8.397  1.00 76.78      A    C  
ATOM   1103  CG1 ILE   173      29.263 -18.449   7.002  1.00 70.61      A    C  
ATOM   1104  CD1 ILE   173      28.220 -18.403   5.902  1.00 71.51      A    C  
ATOM   1105  CG2 ILE   173      27.983 -17.471   8.924  1.00 81.49      A    C  
ATOM   1106  C   ILE   173      29.330 -19.219  10.805  1.00 83.32      A    C  
ATOM   1107  O   ILE   173      28.477 -20.038  11.153  1.00 87.13      A    O  
ATOM   1108  N   GLU   174      29.896 -18.353  11.639  1.00 86.51      A    N  
ATOM   1109  CA  GLU   174      29.536 -18.283  13.050  1.00 93.69      A    C  
ATOM   1110  CB  GLU   174      30.549 -17.437  13.835  1.00 97.60      A    C  
ATOM   1111  CG  GLU   174      32.024 -17.729  13.538  1.00 98.58      A    C  
ATOM   1112  CD  GLU   174      32.480 -19.103  14.005  1.00103.15      A    C  
ATOM   1113  OE1 GLU   174      32.267 -19.434  15.190  1.00110.24      A    O  
ATOM   1114  OE2 GLU   174      33.069 -19.847  13.186  1.00102.50      A    O  
ATOM   1115  C   GLU   174      28.128 -17.711  13.215  1.00 97.65      A    C  
ATOM   1116  O   GLU   174      27.849 -16.589  12.779  1.00 98.79      A    O  
ATOM   1117  N   ARG   175      27.250 -18.506  13.826  1.00102.48      A    N  
ATOM   1118  CA  ARG   175      25.891 -18.080  14.174  1.00109.50      A    C  
ATOM   1119  CB  ARG   175      24.881 -19.185  13.842  1.00114.39      A    C  
ATOM   1120  CG  ARG   175      24.124 -18.977  12.535  1.00116.97      A    C  
ATOM   1121  CD  ARG   175      24.920 -19.414  11.313  1.00109.78      A    C  
ATOM   1122  NE  ARG   175      24.355 -18.861  10.080  1.00112.40      A    N  
ATOM   1123  CZ  ARG   175      24.629 -19.298   8.851  1.00109.33      A    C  
ATOM   1124  NH1 ARG   175      25.462 -20.318   8.661  1.00103.11      A    N  
ATOM   1125  NH2 ARG   175      24.058 -18.714   7.803  1.00112.61      A    N  
ATOM   1126  C   ARG   175      25.781 -17.680  15.653  1.00114.90      A    C  
ATOM   1127  O   ARG   175      26.443 -18.279  16.504  1.00115.25      A    O  
ATOM   1128  N   PRO   176      24.947 -16.661  15.961  1.00121.13      A    N  
ATOM   1129  CA  PRO   176      24.769 -16.177  17.338  1.00127.15      A    C  
ATOM   1130  CB  PRO   176      23.739 -15.054  17.186  1.00135.40      A    C  
ATOM   1131  CG  PRO   176      23.825 -14.640  15.761  1.00132.78      A    C  
ATOM   1132  CD  PRO   176      24.125 -15.891  15.009  1.00124.80      A    C  
ATOM   1133  C   PRO   176      24.226 -17.248  18.281  1.00131.43      A    C  
ATOM   1134  O   PRO   176      24.738 -17.408  19.389  1.00133.23      A    O  
END
