
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  100 ( 1611),  selected  100 , name 2efi_A
# Molecule2: number of CA atoms  135 ( 1110),  selected  135 , name T0429.pdb
# PARAMETERS: 2efi_A.T0429.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      -       -           -
LGA    S     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    M     8_A      -       -           -
LGA    A     9_A      -       -           -
LGA    P    10_A      -       -           -
LGA    K    11_A      -       -           -
LGA    Q    12_A      -       -           -
LGA    D    13_A      E      22           #
LGA    P    14_A      T      23           -
LGA    K    15_A      E      24          5.236
LGA    P    16_A      L      25          5.402
LGA    K    17_A      L      27          0.919
LGA    F    18_A      Y      28          0.864
LGA    Q    19_A      K      29          0.950
LGA    E    20_A      V      30          1.118
LGA    G    21_A      N      31          0.899
LGA    E    22_A      E      32          0.586
LGA    R    23_A      Y      33          0.566
LGA    V    24_A      V      34          0.547
LGA    L    25_A      D      35          0.616
LGA    C    26_A      A      36          0.461
LGA    F    27_A      R      37          0.489
LGA    H    28_A      D      38          0.678
LGA    -       -      T      39           -
LGA    -       -      N      40           -
LGA    G    29_A      M      41          3.205
LGA    P    30_A      G      42          2.748
LGA    L    31_A      A      43          1.757
LGA    L    32_A      W      44          0.865
LGA    Y    33_A      F      45          0.283
LGA    E    34_A      E      46          0.189
LGA    A    35_A      A      47          0.325
LGA    K    36_A      Q      48          0.445
LGA    C    37_A      V      49          0.371
LGA    V    38_A      V      50          0.806
LGA    K    39_A      R      51          0.768
LGA    V    40_A      V      52          0.718
LGA    A    41_A      T      53          1.173
LGA    I    42_A      R      54          1.340
LGA    K    43_A      E      73           -
LGA    D    44_A      -       -           -
LGA    K    45_A      -       -           -
LGA    Q    46_A      D      74          2.388
LGA    V    47_A      V      75          0.843
LGA    K    48_A      I      76          0.806
LGA    Y    49_A      Y      77          0.942
LGA    F    50_A      H      78          0.824
LGA    I    51_A      V      79          0.980
LGA    H    52_A      K      80          0.548
LGA    Y    53_A      Y      81          0.885
LGA    S    54_A      D      82          0.881
LGA    G    55_A      D      83          1.253
LGA    W    56_A      Y      84          1.834
LGA    N    57_A      P      85          1.393
LGA    K    58_A      E      86          3.762
LGA    N    59_A      N      87          1.598
LGA    W    60_A      G      88          4.164
LGA    D    61_A      V      89          3.304
LGA    E    62_A      V      90          1.495
LGA    W    63_A      Q      91          0.443
LGA    V    64_A      M      92          0.356
LGA    P    65_A      N      93          1.696
LGA    E    66_A      S      94          1.511
LGA    S    67_A      R      95          1.333
LGA    R    68_A      D      96          1.155
LGA    V    69_A      V      97          1.061
LGA    L    70_A      R      98          0.817
LGA    K    71_A      A      99          1.934
LGA    Y    72_A      R     100          2.051
LGA    V    73_A      -       -           -
LGA    D    74_A      -       -           -
LGA    T    75_A      -       -           -
LGA    N    76_A      A     101          4.100
LGA    L    77_A      R     102          3.889
LGA    Q    78_A      T     103          4.773
LGA    -       -      I     104           -
LGA    -       -      I     105           -
LGA    -       -      K     106           -
LGA    -       -      W     107           -
LGA    -       -      Q     108           -
LGA    -       -      D     109           -
LGA    -       -      L     110           -
LGA    -       -      E     111           -
LGA    -       -      V     112           -
LGA    -       -      G     113           -
LGA    -       -      Q     114           -
LGA    -       -      V     115           -
LGA    K    79_A      V     116          4.060
LGA    Q    80_A      M     117          4.296
LGA    R    81_A      -       -           -
LGA    E    82_A      L     118          1.510
LGA    L    83_A      N     119          3.439
LGA    Q    84_A      -       -           -
LGA    K    85_A      Y     120          5.395
LGA    A    86_A      N     121           #
LGA    N    87_A      P     122           #
LGA    -       -      D     123           -
LGA    -       -      N     124           -
LGA    -       -      P     125           -
LGA    -       -      K     126           -
LGA    Q    88_A      E     127           #
LGA    E    89_A      R     128          4.182
LGA    Q    90_A      G     129          3.988
LGA    Y    91_A      F     130          3.524
LGA    A    92_A      W     131           -
LGA    E    93_A      Y     132           -
LGA    G    94_A      D     133           -
LGA    K    95_A      A     134           -
LGA    M    96_A      E     135           -
LGA    R    97_A      I     136           -
LGA    G    98_A      S     137           -
LGA    A    99_A      R     138           -
LGA    A   100_A      K     139           -
LGA    -       -      R     140           -
LGA    -       -      E     141           -
LGA    -       -      T     142           -
LGA    -       -      R     143           -
LGA    -       -      T     144           -
LGA    -       -      A     145           -
LGA    -       -      R     146           -
LGA    -       -      E     147           -
LGA    -       -      L     148           -
LGA    -       -      Y     149           -
LGA    -       -      A     150           -
LGA    -       -      N     151           -
LGA    -       -      V     152           -
LGA    -       -      V     153           -
LGA    -       -      L     154           -
LGA    -       -      D     156           -
LGA    -       -      D     157           -
LGA    -       -      S     158           -
LGA    -       -      L     159           -
LGA    -       -      N     160           -
LGA    -       -      D     161           -
LGA    -       -      C     162           -
LGA    -       -      R     163           -
LGA    -       -      I     164           -
LGA    -       -      I     165           -
LGA    -       -      F     166           -
LGA    -       -      V     167           -
LGA    -       -      D     168           -
LGA    -       -      E     169           -
LGA    -       -      V     170           -
LGA    -       -      F     171           -
LGA    -       -      K     172           -
LGA    -       -      I     173           -
LGA    -       -      E     174           -
LGA    -       -      R     175           -
LGA    -       -      P     176           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  100  135    5.0     66    2.31    16.67     42.063     2.735

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.095203 * X  +  -0.729144 * Y  +  -0.677706 * Z  +  32.095726
  Y_new =  -0.655209 * X  +   0.558433 * Y  +  -0.508776 * Z  +  -4.790030
  Z_new =   0.749425 * X  +   0.395602 * Y  +  -0.530906 * Z  +   9.884964 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.501206   -0.640386  [ DEG:   143.3086    -36.6914 ]
  Theta =  -0.847193   -2.294400  [ DEG:   -48.5406   -131.4594 ]
  Phi   =  -1.715088    1.426505  [ DEG:   -98.2673     81.7327 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2efi_A                                        
REMARK     2: T0429.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2efi_A.T0429.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  100  135   5.0   66   2.31   16.67  42.063
REMARK  ---------------------------------------------------------- 
MOLECULE 2efi_A
HEADER    TRANSCRIPTION                           22-FEB-07   2EFI              
TITLE     SOLUTION STRUCTURE OF THE CHROMO DOMAIN OF MORTALITY FACTOR           
TITLE    2 4-LIKE PROTEIN 1 FROM HUMAN                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MORTALITY FACTOR 4-LIKE PROTEIN 1;                         
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: CHROMO DOMAIN;                                             
COMPND   5 SYNONYM: MORF-RELATED GENE 15 PROTEIN, TRANSCRIPTION                 
COMPND   6 FACTOR-LIKE PROTEIN MRG15, MSL3-1 PROTEIN;                           
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: MORF4L1;                                                       
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P060522-07;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    CHROMO DOMAIN, MORTALITY FACTOR 4-LIKE PROTEIN 1,                     
KEYWDS   2 STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT ON PROTEIN             
KEYWDS   3 STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                 
KEYWDS   4 GENOMICS/PROTEOMICS INITIATIVE, RSGI, TRANSCRIPTION                  
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.LI,M.SATO,N.TOCHIO,T.TOMIZAWA,S.KOSHIBA,T.HARADA,                   
AUTHOR   2 S.WATANABE,T.KIGAWA,S.YOKOYAMA,RIKEN STRUCTURAL                      
AUTHOR   3 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   28-AUG-07 2EFI    0                                                
JRNL        AUTH   H.LI,M.SATO,N.TOCHIO,T.TOMIZAWA,S.KOSHIBA,T.HARADA,          
JRNL        AUTH 2 S.WATANABE,T.KIGAWA,S.YOKOYAMA                               
JRNL        TITL   SOLUTION STRUCTURE OF THE CHROMO DOMAIN OF                   
JRNL        TITL 2 MORTALITY FACTOR 4-LIKE PROTEIN 1 FROM HUMAN                 
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2EFI A    8   100  UNP    Q9UBU8   MO4L1_HUMAN      1     93             
SEQRES   1 A  100  GLY SER SER GLY SER SER GLY MET ALA PRO LYS GLN ASP          
SEQRES   2 A  100  PRO LYS PRO LYS PHE GLN GLU GLY GLU ARG VAL LEU CYS          
SEQRES   3 A  100  PHE HIS GLY PRO LEU LEU TYR GLU ALA LYS CYS VAL LYS          
SEQRES   4 A  100  VAL ALA ILE LYS ASP LYS GLN VAL LYS TYR PHE ILE HIS          
SEQRES   5 A  100  TYR SER GLY TRP ASN LYS ASN TRP ASP GLU TRP VAL PRO          
SEQRES   6 A  100  GLU SER ARG VAL LEU LYS TYR VAL ASP THR ASN LEU GLN          
SEQRES   7 A  100  LYS GLN ARG GLU LEU GLN LYS ALA ASN GLN GLU GLN TYR          
SEQRES   8 A  100  ALA GLU GLY LYS MET ARG GLY ALA ALA                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      31.202  -9.999  30.513  1.00  0.00           N  
ATOM      2  CA  GLY A   1      30.089  -9.879  31.436  1.00  0.00           C  
ATOM      3  C   GLY A   1      29.409 -11.208  31.699  1.00  0.00           C  
ATOM      4  O   GLY A   1      28.758 -11.765  30.815  1.00  0.00           O  
ATOM      5  H1  GLY A   1      31.614 -10.874  30.355  1.00  0.00           H  
ATOM      6  HA2 GLY A   1      30.453  -9.481  32.371  1.00  0.00           H  
ATOM      7  HA3 GLY A   1      29.365  -9.193  31.022  1.00  0.00           H  
ATOM      8  N   SER A   2      29.562 -11.718  32.916  1.00  0.00           N  
ATOM      9  CA  SER A   2      28.961 -12.994  33.291  1.00  0.00           C  
ATOM     10  C   SER A   2      28.044 -12.828  34.500  1.00  0.00           C  
ATOM     11  O   SER A   2      28.498 -12.508  35.597  1.00  0.00           O  
ATOM     12  CB  SER A   2      30.050 -14.022  33.601  1.00  0.00           C  
ATOM     13  OG  SER A   2      30.477 -14.684  32.422  1.00  0.00           O  
ATOM     14  H   SER A   2      30.092 -11.227  33.578  1.00  0.00           H  
ATOM     15  HA  SER A   2      28.374 -13.342  32.454  1.00  0.00           H  
ATOM     16  HB2 SER A   2      30.897 -13.524  34.046  1.00  0.00           H  
ATOM     17  HB3 SER A   2      29.661 -14.758  34.291  1.00  0.00           H  
ATOM     18  HG  SER A   2      30.925 -14.057  31.848  1.00  0.00           H  
ATOM     19  N   SER A   3      26.750 -13.048  34.287  1.00  0.00           N  
ATOM     20  CA  SER A   3      25.767 -12.920  35.356  1.00  0.00           C  
ATOM     21  C   SER A   3      24.389 -13.370  34.885  1.00  0.00           C  
ATOM     22  O   SER A   3      24.195 -13.688  33.712  1.00  0.00           O  
ATOM     23  CB  SER A   3      25.703 -11.472  35.848  1.00  0.00           C  
ATOM     24  OG  SER A   3      25.284 -11.412  37.201  1.00  0.00           O  
ATOM     25  H   SER A   3      26.449 -13.300  33.389  1.00  0.00           H  
ATOM     26  HA  SER A   3      26.081 -13.554  36.173  1.00  0.00           H  
ATOM     27  HB2 SER A   3      26.681 -11.023  35.767  1.00  0.00           H  
ATOM     28  HB3 SER A   3      25.001 -10.920  35.241  1.00  0.00           H  
ATOM     29  HG  SER A   3      25.305 -10.500  37.501  1.00  0.00           H  
ATOM     30  N   GLY A   4      23.433 -13.394  35.808  1.00  0.00           N  
ATOM     31  CA  GLY A   4      22.083 -13.807  35.468  1.00  0.00           C  
ATOM     32  C   GLY A   4      21.422 -12.868  34.478  1.00  0.00           C  
ATOM     33  O   GLY A   4      21.703 -11.670  34.466  1.00  0.00           O  
ATOM     34  H   GLY A   4      23.644 -13.130  36.727  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      22.118 -14.797  35.040  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      21.490 -13.836  36.370  1.00  0.00           H  
ATOM     37  N   SER A   5      20.541 -13.414  33.645  1.00  0.00           N  
ATOM     38  CA  SER A   5      19.842 -12.618  32.643  1.00  0.00           C  
ATOM     39  C   SER A   5      18.382 -12.415  33.034  1.00  0.00           C  
ATOM     40  O   SER A   5      17.500 -13.148  32.585  1.00  0.00           O  
ATOM     41  CB  SER A   5      19.927 -13.295  31.273  1.00  0.00           C  
ATOM     42  OG  SER A   5      21.160 -13.008  30.637  1.00  0.00           O  
ATOM     43  H   SER A   5      20.360 -14.377  33.704  1.00  0.00           H  
ATOM     44  HA  SER A   5      20.326 -11.654  32.589  1.00  0.00           H  
ATOM     45  HB2 SER A   5      19.840 -14.364  31.397  1.00  0.00           H  
ATOM     46  HB3 SER A   5      19.121 -12.939  30.648  1.00  0.00           H  
ATOM     47  HG  SER A   5      21.490 -12.161  30.946  1.00  0.00           H  
ATOM     48  N   SER A   6      18.134 -11.415  33.872  1.00  0.00           N  
ATOM     49  CA  SER A   6      16.781 -11.115  34.326  1.00  0.00           C  
ATOM     50  C   SER A   6      16.581  -9.611  34.488  1.00  0.00           C  
ATOM     51  O   SER A   6      17.332  -8.948  35.201  1.00  0.00           O  
ATOM     52  CB  SER A   6      16.498 -11.823  35.652  1.00  0.00           C  
ATOM     53  OG  SER A   6      16.122 -13.173  35.440  1.00  0.00           O  
ATOM     54  H   SER A   6      18.879 -10.865  34.194  1.00  0.00           H  
ATOM     55  HA  SER A   6      16.092 -11.480  33.579  1.00  0.00           H  
ATOM     56  HB2 SER A   6      17.385 -11.802  36.266  1.00  0.00           H  
ATOM     57  HB3 SER A   6      15.693 -11.315  36.164  1.00  0.00           H  
ATOM     58  HG  SER A   6      16.845 -13.752  35.697  1.00  0.00           H  
ATOM     59  N   GLY A   7      15.563  -9.080  33.818  1.00  0.00           N  
ATOM     60  CA  GLY A   7      15.282  -7.659  33.900  1.00  0.00           C  
ATOM     61  C   GLY A   7      14.434  -7.169  32.743  1.00  0.00           C  
ATOM     62  O   GLY A   7      14.836  -7.270  31.584  1.00  0.00           O  
ATOM     63  H   GLY A   7      14.996  -9.659  33.264  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      14.761  -7.458  34.824  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      16.217  -7.119  33.900  1.00  0.00           H  
ATOM     66  N   MET A   8      13.258  -6.636  33.056  1.00  0.00           N  
ATOM     67  CA  MET A   8      12.351  -6.128  32.033  1.00  0.00           C  
ATOM     68  C   MET A   8      12.850  -4.797  31.478  1.00  0.00           C  
ATOM     69  O   MET A   8      13.623  -4.094  32.126  1.00  0.00           O  
ATOM     70  CB  MET A   8      10.943  -5.960  32.607  1.00  0.00           C  
ATOM     71  CG  MET A   8      10.186  -7.270  32.753  1.00  0.00           C  
ATOM     72  SD  MET A   8       8.450  -7.026  33.176  1.00  0.00           S  
ATOM     73  CE  MET A   8       8.496  -7.269  34.950  1.00  0.00           C  
ATOM     74  H   MET A   8      12.993  -6.582  33.998  1.00  0.00           H  
ATOM     75  HA  MET A   8      12.320  -6.851  31.231  1.00  0.00           H  
ATOM     76  HB2 MET A   8      11.016  -5.501  33.581  1.00  0.00           H  
ATOM     77  HB3 MET A   8      10.376  -5.313  31.954  1.00  0.00           H  
ATOM     78  HG2 MET A   8      10.242  -7.809  31.820  1.00  0.00           H  
ATOM     79  HG3 MET A   8      10.654  -7.854  33.532  1.00  0.00           H  
ATOM     80  HE1 MET A   8       9.490  -7.056  35.317  1.00  0.00           H  
ATOM     81  HE2 MET A   8       7.789  -6.604  35.422  1.00  0.00           H  
ATOM     82  HE3 MET A   8       8.239  -8.292  35.179  1.00  0.00           H  
ATOM     83  N   ALA A   9      12.401  -4.459  30.273  1.00  0.00           N  
ATOM     84  CA  ALA A   9      12.799  -3.212  29.632  1.00  0.00           C  
ATOM     85  C   ALA A   9      11.598  -2.500  29.021  1.00  0.00           C  
ATOM     86  O   ALA A   9      10.645  -3.126  28.554  1.00  0.00           O  
ATOM     87  CB  ALA A   9      13.854  -3.480  28.568  1.00  0.00           C  
ATOM     88  H   ALA A   9      11.787  -5.062  29.806  1.00  0.00           H  
ATOM     89  HA  ALA A   9      13.239  -2.575  30.386  1.00  0.00           H  
ATOM     90  HB1 ALA A   9      14.831  -3.503  29.027  1.00  0.00           H  
ATOM     91  HB2 ALA A   9      13.654  -4.431  28.096  1.00  0.00           H  
ATOM     92  HB3 ALA A   9      13.823  -2.696  27.826  1.00  0.00           H  
ATOM     93  N   PRO A  10      11.639  -1.160  29.025  1.00  0.00           N  
ATOM     94  CA  PRO A  10      10.560  -0.333  28.475  1.00  0.00           C  
ATOM     95  C   PRO A  10      10.477  -0.424  26.955  1.00  0.00           C  
ATOM     96  O   PRO A  10      11.146  -1.252  26.335  1.00  0.00           O  
ATOM     97  CB  PRO A  10      10.944   1.084  28.905  1.00  0.00           C  
ATOM     98  CG  PRO A  10      12.424   1.040  29.078  1.00  0.00           C  
ATOM     99  CD  PRO A  10      12.741  -0.347  29.565  1.00  0.00           C  
ATOM    100  HA  PRO A  10       9.603  -0.594  28.902  1.00  0.00           H  
ATOM    101  HB2 PRO A  10      10.657   1.788  28.136  1.00  0.00           H  
ATOM    102  HB3 PRO A  10      10.445   1.331  29.830  1.00  0.00           H  
ATOM    103  HG2 PRO A  10      12.910   1.227  28.133  1.00  0.00           H  
ATOM    104  HG3 PRO A  10      12.730   1.773  29.810  1.00  0.00           H  
ATOM    105  HD2 PRO A  10      13.692  -0.677  29.172  1.00  0.00           H  
ATOM    106  HD3 PRO A  10      12.748  -0.376  30.645  1.00  0.00           H  
ATOM    107  N   LYS A  11       9.652   0.431  26.359  1.00  0.00           N  
ATOM    108  CA  LYS A  11       9.483   0.448  24.911  1.00  0.00           C  
ATOM    109  C   LYS A  11      10.471   1.410  24.260  1.00  0.00           C  
ATOM    110  O   LYS A  11      10.080   2.284  23.485  1.00  0.00           O  
ATOM    111  CB  LYS A  11       8.051   0.848  24.550  1.00  0.00           C  
ATOM    112  CG  LYS A  11       7.010  -0.183  24.954  1.00  0.00           C  
ATOM    113  CD  LYS A  11       6.590  -0.011  26.404  1.00  0.00           C  
ATOM    114  CE  LYS A  11       5.802  -1.214  26.902  1.00  0.00           C  
ATOM    115  NZ  LYS A  11       5.539  -1.135  28.365  1.00  0.00           N  
ATOM    116  H   LYS A  11       9.146   1.066  26.908  1.00  0.00           H  
ATOM    117  HA  LYS A  11       9.674  -0.548  24.542  1.00  0.00           H  
ATOM    118  HB2 LYS A  11       7.815   1.779  25.042  1.00  0.00           H  
ATOM    119  HB3 LYS A  11       7.988   0.991  23.480  1.00  0.00           H  
ATOM    120  HG2 LYS A  11       6.143  -0.072  24.322  1.00  0.00           H  
ATOM    121  HG3 LYS A  11       7.428  -1.172  24.825  1.00  0.00           H  
ATOM    122  HD2 LYS A  11       7.473   0.106  27.015  1.00  0.00           H  
ATOM    123  HD3 LYS A  11       5.973   0.873  26.488  1.00  0.00           H  
ATOM    124  HE2 LYS A  11       4.861  -1.253  26.377  1.00  0.00           H  
ATOM    125  HE3 LYS A  11       6.369  -2.109  26.694  1.00  0.00           H  
ATOM    126  HZ1 LYS A  11       4.737  -0.498  28.550  1.00  0.00           H  
ATOM    127  HZ2 LYS A  11       6.377  -0.772  28.861  1.00  0.00           H  
ATOM    128  HZ3 LYS A  11       5.311  -2.080  28.738  1.00  0.00           H  
ATOM    129  N   GLN A  12      11.750   1.244  24.578  1.00  0.00           N  
ATOM    130  CA  GLN A  12      12.793   2.098  24.022  1.00  0.00           C  
ATOM    131  C   GLN A  12      13.609   1.349  22.974  1.00  0.00           C  
ATOM    132  O   GLN A  12      13.538   0.124  22.877  1.00  0.00           O  
ATOM    133  CB  GLN A  12      13.712   2.606  25.134  1.00  0.00           C  
ATOM    134  CG  GLN A  12      14.679   3.687  24.678  1.00  0.00           C  
ATOM    135  CD  GLN A  12      15.267   4.470  25.834  1.00  0.00           C  
ATOM    136  OE1 GLN A  12      16.477   4.445  26.066  1.00  0.00           O  
ATOM    137  NE2 GLN A  12      14.413   5.173  26.569  1.00  0.00           N  
ATOM    138  H   GLN A  12      11.999   0.530  25.202  1.00  0.00           H  
ATOM    139  HA  GLN A  12      12.313   2.943  23.550  1.00  0.00           H  
ATOM    140  HB2 GLN A  12      13.105   3.010  25.930  1.00  0.00           H  
ATOM    141  HB3 GLN A  12      14.288   1.777  25.516  1.00  0.00           H  
ATOM    142  HG2 GLN A  12      15.487   3.222  24.131  1.00  0.00           H  
ATOM    143  HG3 GLN A  12      14.154   4.371  24.028  1.00  0.00           H  
ATOM    144 HE21 GLN A  12      13.463   5.145  26.326  1.00  0.00           H  
ATOM    145 HE22 GLN A  12      14.765   5.688  27.323  1.00  0.00           H  
ATOM    146  N   ASP A  13      14.384   2.093  22.191  1.00  0.00           N  
ATOM    147  CA  ASP A  13      15.214   1.499  21.150  1.00  0.00           C  
ATOM    148  C   ASP A  13      15.830   0.188  21.629  1.00  0.00           C  
ATOM    149  O   ASP A  13      16.106  -0.001  22.814  1.00  0.00           O  
ATOM    150  CB  ASP A  13      16.318   2.472  20.732  1.00  0.00           C  
ATOM    151  CG  ASP A  13      16.766   3.365  21.872  1.00  0.00           C  
ATOM    152  OD1 ASP A  13      17.320   2.835  22.858  1.00  0.00           O  
ATOM    153  OD2 ASP A  13      16.561   4.594  21.780  1.00  0.00           O  
ATOM    154  H   ASP A  13      14.397   3.065  22.318  1.00  0.00           H  
ATOM    155  HA  ASP A  13      14.584   1.296  20.298  1.00  0.00           H  
ATOM    156  HB2 ASP A  13      17.172   1.909  20.383  1.00  0.00           H  
ATOM    157  HB3 ASP A  13      15.952   3.097  19.931  1.00  0.00           H  
ATOM    158  N   PRO A  14      16.050  -0.741  20.687  1.00  0.00           N  
ATOM    159  CA  PRO A  14      16.633  -2.052  20.988  1.00  0.00           C  
ATOM    160  C   PRO A  14      18.106  -1.955  21.374  1.00  0.00           C  
ATOM    161  O   PRO A  14      18.762  -0.947  21.113  1.00  0.00           O  
ATOM    162  CB  PRO A  14      16.474  -2.822  19.674  1.00  0.00           C  
ATOM    163  CG  PRO A  14      16.422  -1.768  18.622  1.00  0.00           C  
ATOM    164  CD  PRO A  14      15.744  -0.585  19.254  1.00  0.00           C  
ATOM    165  HA  PRO A  14      16.089  -2.558  21.772  1.00  0.00           H  
ATOM    166  HB2 PRO A  14      17.321  -3.478  19.535  1.00  0.00           H  
ATOM    167  HB3 PRO A  14      15.563  -3.400  19.700  1.00  0.00           H  
ATOM    168  HG2 PRO A  14      17.422  -1.507  18.314  1.00  0.00           H  
ATOM    169  HG3 PRO A  14      15.848  -2.122  17.778  1.00  0.00           H  
ATOM    170  HD2 PRO A  14      16.156   0.337  18.871  1.00  0.00           H  
ATOM    171  HD3 PRO A  14      14.679  -0.623  19.082  1.00  0.00           H  
ATOM    172  N   LYS A  15      18.619  -3.010  21.997  1.00  0.00           N  
ATOM    173  CA  LYS A  15      20.014  -3.045  22.419  1.00  0.00           C  
ATOM    174  C   LYS A  15      20.853  -3.873  21.451  1.00  0.00           C  
ATOM    175  O   LYS A  15      20.440  -4.933  20.981  1.00  0.00           O  
ATOM    176  CB  LYS A  15      20.128  -3.624  23.831  1.00  0.00           C  
ATOM    177  CG  LYS A  15      21.402  -3.221  24.554  1.00  0.00           C  
ATOM    178  CD  LYS A  15      21.440  -3.772  25.969  1.00  0.00           C  
ATOM    179  CE  LYS A  15      22.694  -3.330  26.707  1.00  0.00           C  
ATOM    180  NZ  LYS A  15      22.537  -1.976  27.306  1.00  0.00           N  
ATOM    181  H   LYS A  15      18.045  -3.785  22.179  1.00  0.00           H  
ATOM    182  HA  LYS A  15      20.386  -2.032  22.423  1.00  0.00           H  
ATOM    183  HB2 LYS A  15      19.285  -3.284  24.415  1.00  0.00           H  
ATOM    184  HB3 LYS A  15      20.099  -4.702  23.770  1.00  0.00           H  
ATOM    185  HG2 LYS A  15      22.251  -3.604  24.007  1.00  0.00           H  
ATOM    186  HG3 LYS A  15      21.456  -2.142  24.595  1.00  0.00           H  
ATOM    187  HD2 LYS A  15      20.574  -3.414  26.508  1.00  0.00           H  
ATOM    188  HD3 LYS A  15      21.418  -4.852  25.927  1.00  0.00           H  
ATOM    189  HE2 LYS A  15      22.903  -4.040  27.492  1.00  0.00           H  
ATOM    190  HE3 LYS A  15      23.518  -3.312  26.009  1.00  0.00           H  
ATOM    191  HZ1 LYS A  15      22.009  -1.357  26.658  1.00  0.00           H  
ATOM    192  HZ2 LYS A  15      23.471  -1.555  27.487  1.00  0.00           H  
ATOM    193  HZ3 LYS A  15      22.019  -2.041  28.205  1.00  0.00           H  
ATOM    194  N   PRO A  16      22.064  -3.380  21.145  1.00  0.00           N  
ATOM    195  CA  PRO A  16      22.988  -4.060  20.232  1.00  0.00           C  
ATOM    196  C   PRO A  16      23.552  -5.344  20.828  1.00  0.00           C  
ATOM    197  O   PRO A  16      23.461  -5.574  22.035  1.00  0.00           O  
ATOM    198  CB  PRO A  16      24.102  -3.031  20.024  1.00  0.00           C  
ATOM    199  CG  PRO A  16      24.065  -2.181  21.247  1.00  0.00           C  
ATOM    200  CD  PRO A  16      22.623  -2.123  21.668  1.00  0.00           C  
ATOM    201  HA  PRO A  16      22.517  -4.281  19.285  1.00  0.00           H  
ATOM    202  HB2 PRO A  16      25.050  -3.540  19.924  1.00  0.00           H  
ATOM    203  HB3 PRO A  16      23.901  -2.452  19.135  1.00  0.00           H  
ATOM    204  HG2 PRO A  16      24.665  -2.631  22.024  1.00  0.00           H  
ATOM    205  HG3 PRO A  16      24.429  -1.191  21.017  1.00  0.00           H  
ATOM    206  HD2 PRO A  16      22.546  -2.084  22.745  1.00  0.00           H  
ATOM    207  HD3 PRO A  16      22.134  -1.270  21.222  1.00  0.00           H  
ATOM    208  N   LYS A  17      24.137  -6.180  19.977  1.00  0.00           N  
ATOM    209  CA  LYS A  17      24.720  -7.441  20.420  1.00  0.00           C  
ATOM    210  C   LYS A  17      26.239  -7.339  20.503  1.00  0.00           C  
ATOM    211  O   LYS A  17      26.856  -7.849  21.438  1.00  0.00           O  
ATOM    212  CB  LYS A  17      24.325  -8.571  19.467  1.00  0.00           C  
ATOM    213  CG  LYS A  17      22.825  -8.796  19.378  1.00  0.00           C  
ATOM    214  CD  LYS A  17      22.478  -9.834  18.324  1.00  0.00           C  
ATOM    215  CE  LYS A  17      21.201 -10.581  18.677  1.00  0.00           C  
ATOM    216  NZ  LYS A  17      20.542 -11.154  17.470  1.00  0.00           N  
ATOM    217  H   LYS A  17      24.179  -5.942  19.026  1.00  0.00           H  
ATOM    218  HA  LYS A  17      24.332  -7.659  21.404  1.00  0.00           H  
ATOM    219  HB2 LYS A  17      24.691  -8.338  18.478  1.00  0.00           H  
ATOM    220  HB3 LYS A  17      24.785  -9.488  19.805  1.00  0.00           H  
ATOM    221  HG2 LYS A  17      22.465  -9.138  20.337  1.00  0.00           H  
ATOM    222  HG3 LYS A  17      22.344  -7.863  19.123  1.00  0.00           H  
ATOM    223  HD2 LYS A  17      22.341  -9.337  17.375  1.00  0.00           H  
ATOM    224  HD3 LYS A  17      23.290 -10.542  18.248  1.00  0.00           H  
ATOM    225  HE2 LYS A  17      21.444 -11.381  19.358  1.00  0.00           H  
ATOM    226  HE3 LYS A  17      20.518  -9.894  19.156  1.00  0.00           H  
ATOM    227  HZ1 LYS A  17      21.158 -11.041  16.640  1.00  0.00           H  
ATOM    228  HZ2 LYS A  17      19.641 -10.668  17.289  1.00  0.00           H  
ATOM    229  HZ3 LYS A  17      20.354 -12.167  17.613  1.00  0.00           H  
ATOM    230  N   PHE A  18      26.838  -6.677  19.518  1.00  0.00           N  
ATOM    231  CA  PHE A  18      28.286  -6.508  19.480  1.00  0.00           C  
ATOM    232  C   PHE A  18      28.709  -5.265  20.256  1.00  0.00           C  
ATOM    233  O   PHE A  18      27.911  -4.351  20.466  1.00  0.00           O  
ATOM    234  CB  PHE A  18      28.771  -6.409  18.032  1.00  0.00           C  
ATOM    235  CG  PHE A  18      28.185  -7.458  17.130  1.00  0.00           C  
ATOM    236  CD1 PHE A  18      26.983  -7.237  16.478  1.00  0.00           C  
ATOM    237  CD2 PHE A  18      28.837  -8.664  16.934  1.00  0.00           C  
ATOM    238  CE1 PHE A  18      26.441  -8.200  15.649  1.00  0.00           C  
ATOM    239  CE2 PHE A  18      28.301  -9.631  16.104  1.00  0.00           C  
ATOM    240  CZ  PHE A  18      27.101  -9.398  15.460  1.00  0.00           C  
ATOM    241  H   PHE A  18      26.293  -6.293  18.799  1.00  0.00           H  
ATOM    242  HA  PHE A  18      28.732  -7.376  19.941  1.00  0.00           H  
ATOM    243  HB2 PHE A  18      28.501  -5.442  17.634  1.00  0.00           H  
ATOM    244  HB3 PHE A  18      29.845  -6.515  18.012  1.00  0.00           H  
ATOM    245  HD1 PHE A  18      26.466  -6.299  16.623  1.00  0.00           H  
ATOM    246  HD2 PHE A  18      29.776  -8.848  17.437  1.00  0.00           H  
ATOM    247  HE1 PHE A  18      25.504  -8.015  15.146  1.00  0.00           H  
ATOM    248  HE2 PHE A  18      28.820 -10.567  15.960  1.00  0.00           H  
ATOM    249  HZ  PHE A  18      26.681 -10.153  14.813  1.00  0.00           H  
ATOM    250  N   GLN A  19      29.969  -5.239  20.679  1.00  0.00           N  
ATOM    251  CA  GLN A  19      30.498  -4.109  21.434  1.00  0.00           C  
ATOM    252  C   GLN A  19      31.661  -3.457  20.693  1.00  0.00           C  
ATOM    253  O   GLN A  19      32.331  -4.098  19.884  1.00  0.00           O  
ATOM    254  CB  GLN A  19      30.950  -4.563  22.823  1.00  0.00           C  
ATOM    255  CG  GLN A  19      29.801  -4.866  23.768  1.00  0.00           C  
ATOM    256  CD  GLN A  19      30.196  -5.818  24.881  1.00  0.00           C  
ATOM    257  OE1 GLN A  19      31.150  -5.569  25.617  1.00  0.00           O  
ATOM    258  NE2 GLN A  19      29.461  -6.917  25.008  1.00  0.00           N  
ATOM    259  H   GLN A  19      30.556  -5.998  20.480  1.00  0.00           H  
ATOM    260  HA  GLN A  19      29.706  -3.384  21.543  1.00  0.00           H  
ATOM    261  HB2 GLN A  19      31.549  -5.456  22.718  1.00  0.00           H  
ATOM    262  HB3 GLN A  19      31.555  -3.784  23.263  1.00  0.00           H  
ATOM    263  HG2 GLN A  19      29.463  -3.941  24.212  1.00  0.00           H  
ATOM    264  HG3 GLN A  19      28.995  -5.310  23.204  1.00  0.00           H  
ATOM    265 HE21 GLN A  19      28.716  -7.050  24.385  1.00  0.00           H  
ATOM    266 HE22 GLN A  19      29.694  -7.550  25.717  1.00  0.00           H  
ATOM    267  N   GLU A  20      31.895  -2.179  20.977  1.00  0.00           N  
ATOM    268  CA  GLU A  20      32.977  -1.442  20.337  1.00  0.00           C  
ATOM    269  C   GLU A  20      34.335  -2.022  20.722  1.00  0.00           C  
ATOM    270  O   GLU A  20      34.588  -2.315  21.890  1.00  0.00           O  
ATOM    271  CB  GLU A  20      32.915   0.038  20.724  1.00  0.00           C  
ATOM    272  CG  GLU A  20      31.611   0.714  20.335  1.00  0.00           C  
ATOM    273  CD  GLU A  20      31.237   1.844  21.274  1.00  0.00           C  
ATOM    274  OE1 GLU A  20      32.146   2.586  21.703  1.00  0.00           O  
ATOM    275  OE2 GLU A  20      30.035   1.987  21.580  1.00  0.00           O  
ATOM    276  H   GLU A  20      31.327  -1.723  21.632  1.00  0.00           H  
ATOM    277  HA  GLU A  20      32.852  -1.530  19.268  1.00  0.00           H  
ATOM    278  HB2 GLU A  20      33.036   0.123  21.793  1.00  0.00           H  
ATOM    279  HB3 GLU A  20      33.726   0.559  20.237  1.00  0.00           H  
ATOM    280  HG2 GLU A  20      31.712   1.115  19.336  1.00  0.00           H  
ATOM    281  HG3 GLU A  20      30.820  -0.022  20.347  1.00  0.00           H  
ATOM    282  N   GLY A  21      35.205  -2.188  19.730  1.00  0.00           N  
ATOM    283  CA  GLY A  21      36.525  -2.734  19.985  1.00  0.00           C  
ATOM    284  C   GLY A  21      36.608  -4.216  19.677  1.00  0.00           C  
ATOM    285  O   GLY A  21      37.685  -4.734  19.381  1.00  0.00           O  
ATOM    286  H   GLY A  21      34.947  -1.937  18.818  1.00  0.00           H  
ATOM    287  HA2 GLY A  21      37.244  -2.208  19.373  1.00  0.00           H  
ATOM    288  HA3 GLY A  21      36.771  -2.580  21.024  1.00  0.00           H  
ATOM    289  N   GLU A  22      35.470  -4.899  19.748  1.00  0.00           N  
ATOM    290  CA  GLU A  22      35.422  -6.331  19.478  1.00  0.00           C  
ATOM    291  C   GLU A  22      35.580  -6.608  17.985  1.00  0.00           C  
ATOM    292  O   GLU A  22      34.955  -5.951  17.151  1.00  0.00           O  
ATOM    293  CB  GLU A  22      34.103  -6.923  19.980  1.00  0.00           C  
ATOM    294  CG  GLU A  22      34.049  -8.439  19.905  1.00  0.00           C  
ATOM    295  CD  GLU A  22      34.837  -9.107  21.016  1.00  0.00           C  
ATOM    296  OE1 GLU A  22      36.014  -8.739  21.213  1.00  0.00           O  
ATOM    297  OE2 GLU A  22      34.275  -9.997  21.688  1.00  0.00           O  
ATOM    298  H   GLU A  22      34.645  -4.429  19.989  1.00  0.00           H  
ATOM    299  HA  GLU A  22      36.240  -6.796  20.006  1.00  0.00           H  
ATOM    300  HB2 GLU A  22      33.960  -6.628  21.009  1.00  0.00           H  
ATOM    301  HB3 GLU A  22      33.294  -6.524  19.385  1.00  0.00           H  
ATOM    302  HG2 GLU A  22      33.019  -8.754  19.976  1.00  0.00           H  
ATOM    303  HG3 GLU A  22      34.456  -8.755  18.956  1.00  0.00           H  
ATOM    304  N   ARG A  23      36.419  -7.584  17.656  1.00  0.00           N  
ATOM    305  CA  ARG A  23      36.661  -7.947  16.265  1.00  0.00           C  
ATOM    306  C   ARG A  23      35.445  -8.649  15.666  1.00  0.00           C  
ATOM    307  O   ARG A  23      34.945  -9.628  16.220  1.00  0.00           O  
ATOM    308  CB  ARG A  23      37.889  -8.853  16.159  1.00  0.00           C  
ATOM    309  CG  ARG A  23      38.358  -9.079  14.730  1.00  0.00           C  
ATOM    310  CD  ARG A  23      39.614  -9.934  14.684  1.00  0.00           C  
ATOM    311  NE  ARG A  23      40.829  -9.125  14.731  1.00  0.00           N  
ATOM    312  CZ  ARG A  23      42.002  -9.585  15.152  1.00  0.00           C  
ATOM    313  NH1 ARG A  23      42.118 -10.842  15.560  1.00  0.00           N  
ATOM    314  NH2 ARG A  23      43.063  -8.787  15.165  1.00  0.00           N  
ATOM    315  H   ARG A  23      36.887  -8.071  18.365  1.00  0.00           H  
ATOM    316  HA  ARG A  23      36.846  -7.038  15.712  1.00  0.00           H  
ATOM    317  HB2 ARG A  23      38.701  -8.406  16.714  1.00  0.00           H  
ATOM    318  HB3 ARG A  23      37.652  -9.813  16.592  1.00  0.00           H  
ATOM    319  HG2 ARG A  23      37.575  -9.578  14.179  1.00  0.00           H  
ATOM    320  HG3 ARG A  23      38.567  -8.122  14.275  1.00  0.00           H  
ATOM    321  HD2 ARG A  23      39.607 -10.605  15.530  1.00  0.00           H  
ATOM    322  HD3 ARG A  23      39.609 -10.507  13.770  1.00  0.00           H  
ATOM    323  HE  ARG A  23      40.767  -8.195  14.434  1.00  0.00           H  
ATOM    324 HH11 ARG A  23      41.321 -11.445  15.551  1.00  0.00           H  
ATOM    325 HH12 ARG A  23      43.002 -11.186  15.876  1.00  0.00           H  
ATOM    326 HH21 ARG A  23      42.979  -7.840  14.858  1.00  0.00           H  
ATOM    327 HH22 ARG A  23      43.945  -9.135  15.482  1.00  0.00           H  
ATOM    328  N   VAL A  24      34.974  -8.140  14.532  1.00  0.00           N  
ATOM    329  CA  VAL A  24      33.817  -8.717  13.858  1.00  0.00           C  
ATOM    330  C   VAL A  24      34.030  -8.771  12.350  1.00  0.00           C  
ATOM    331  O   VAL A  24      34.961  -8.161  11.821  1.00  0.00           O  
ATOM    332  CB  VAL A  24      32.535  -7.917  14.157  1.00  0.00           C  
ATOM    333  CG1 VAL A  24      32.215  -7.958  15.643  1.00  0.00           C  
ATOM    334  CG2 VAL A  24      32.680  -6.482  13.674  1.00  0.00           C  
ATOM    335  H   VAL A  24      35.414  -7.358  14.139  1.00  0.00           H  
ATOM    336  HA  VAL A  24      33.682  -9.723  14.229  1.00  0.00           H  
ATOM    337  HB  VAL A  24      31.717  -8.374  13.622  1.00  0.00           H  
ATOM    338 HG11 VAL A  24      32.293  -6.963  16.057  1.00  0.00           H  
ATOM    339 HG12 VAL A  24      31.211  -8.329  15.785  1.00  0.00           H  
ATOM    340 HG13 VAL A  24      32.914  -8.611  16.145  1.00  0.00           H  
ATOM    341 HG21 VAL A  24      33.424  -5.975  14.269  1.00  0.00           H  
ATOM    342 HG22 VAL A  24      32.983  -6.480  12.638  1.00  0.00           H  
ATOM    343 HG23 VAL A  24      31.733  -5.971  13.773  1.00  0.00           H  
ATOM    344  N   LEU A  25      33.160  -9.502  11.661  1.00  0.00           N  
ATOM    345  CA  LEU A  25      33.252  -9.635  10.210  1.00  0.00           C  
ATOM    346  C   LEU A  25      32.131  -8.865   9.522  1.00  0.00           C  
ATOM    347  O   LEU A  25      30.951  -9.159   9.719  1.00  0.00           O  
ATOM    348  CB  LEU A  25      33.196 -11.109   9.810  1.00  0.00           C  
ATOM    349  CG  LEU A  25      34.328 -11.992  10.336  1.00  0.00           C  
ATOM    350  CD1 LEU A  25      34.023 -13.460  10.081  1.00  0.00           C  
ATOM    351  CD2 LEU A  25      35.652 -11.601   9.694  1.00  0.00           C  
ATOM    352  H   LEU A  25      32.441  -9.964  12.137  1.00  0.00           H  
ATOM    353  HA  LEU A  25      34.200  -9.221   9.900  1.00  0.00           H  
ATOM    354  HB2 LEU A  25      32.264 -11.516  10.172  1.00  0.00           H  
ATOM    355  HB3 LEU A  25      33.212 -11.158   8.729  1.00  0.00           H  
ATOM    356  HG  LEU A  25      34.419 -11.851  11.404  1.00  0.00           H  
ATOM    357 HD11 LEU A  25      33.429 -13.850  10.893  1.00  0.00           H  
ATOM    358 HD12 LEU A  25      34.949 -14.013  10.013  1.00  0.00           H  
ATOM    359 HD13 LEU A  25      33.477 -13.559   9.154  1.00  0.00           H  
ATOM    360 HD21 LEU A  25      35.576 -11.701   8.623  1.00  0.00           H  
ATOM    361 HD22 LEU A  25      36.434 -12.248  10.062  1.00  0.00           H  
ATOM    362 HD23 LEU A  25      35.885 -10.576   9.946  1.00  0.00           H  
ATOM    363  N   CYS A  26      32.505  -7.880   8.713  1.00  0.00           N  
ATOM    364  CA  CYS A  26      31.531  -7.069   7.993  1.00  0.00           C  
ATOM    365  C   CYS A  26      31.305  -7.611   6.585  1.00  0.00           C  
ATOM    366  O   CYS A  26      32.142  -8.335   6.046  1.00  0.00           O  
ATOM    367  CB  CYS A  26      31.999  -5.615   7.923  1.00  0.00           C  
ATOM    368  SG  CYS A  26      30.808  -4.491   7.155  1.00  0.00           S  
ATOM    369  H   CYS A  26      33.461  -7.693   8.597  1.00  0.00           H  
ATOM    370  HA  CYS A  26      30.599  -7.112   8.536  1.00  0.00           H  
ATOM    371  HB2 CYS A  26      32.190  -5.256   8.924  1.00  0.00           H  
ATOM    372  HB3 CYS A  26      32.913  -5.566   7.351  1.00  0.00           H  
ATOM    373  HG  CYS A  26      31.060  -4.454   5.856  1.00  0.00           H  
ATOM    374  N   PHE A  27      30.167  -7.260   5.997  1.00  0.00           N  
ATOM    375  CA  PHE A  27      29.830  -7.713   4.653  1.00  0.00           C  
ATOM    376  C   PHE A  27      29.924  -6.567   3.651  1.00  0.00           C  
ATOM    377  O   PHE A  27      29.029  -5.726   3.565  1.00  0.00           O  
ATOM    378  CB  PHE A  27      28.419  -8.308   4.632  1.00  0.00           C  
ATOM    379  CG  PHE A  27      28.387  -9.783   4.911  1.00  0.00           C  
ATOM    380  CD1 PHE A  27      28.965 -10.682   4.029  1.00  0.00           C  
ATOM    381  CD2 PHE A  27      27.776 -10.272   6.055  1.00  0.00           C  
ATOM    382  CE1 PHE A  27      28.938 -12.040   4.283  1.00  0.00           C  
ATOM    383  CE2 PHE A  27      27.745 -11.628   6.315  1.00  0.00           C  
ATOM    384  CZ  PHE A  27      28.326 -12.514   5.427  1.00  0.00           C  
ATOM    385  H   PHE A  27      29.538  -6.681   6.478  1.00  0.00           H  
ATOM    386  HA  PHE A  27      30.538  -8.478   4.374  1.00  0.00           H  
ATOM    387  HB2 PHE A  27      27.818  -7.816   5.381  1.00  0.00           H  
ATOM    388  HB3 PHE A  27      27.981  -8.144   3.659  1.00  0.00           H  
ATOM    389  HD1 PHE A  27      29.445 -10.312   3.134  1.00  0.00           H  
ATOM    390  HD2 PHE A  27      27.321  -9.580   6.749  1.00  0.00           H  
ATOM    391  HE1 PHE A  27      29.392 -12.730   3.587  1.00  0.00           H  
ATOM    392  HE2 PHE A  27      27.266 -11.997   7.210  1.00  0.00           H  
ATOM    393  HZ  PHE A  27      28.303 -13.574   5.629  1.00  0.00           H  
ATOM    394  N   HIS A  28      31.018  -6.538   2.896  1.00  0.00           N  
ATOM    395  CA  HIS A  28      31.232  -5.495   1.899  1.00  0.00           C  
ATOM    396  C   HIS A  28      31.156  -6.068   0.488  1.00  0.00           C  
ATOM    397  O   HIS A  28      31.861  -5.617  -0.415  1.00  0.00           O  
ATOM    398  CB  HIS A  28      32.587  -4.822   2.117  1.00  0.00           C  
ATOM    399  CG  HIS A  28      32.825  -3.648   1.218  1.00  0.00           C  
ATOM    400  ND1 HIS A  28      33.895  -3.568   0.351  1.00  0.00           N  
ATOM    401  CD2 HIS A  28      32.123  -2.503   1.053  1.00  0.00           C  
ATOM    402  CE1 HIS A  28      33.840  -2.424  -0.307  1.00  0.00           C  
ATOM    403  NE2 HIS A  28      32.776  -1.759   0.100  1.00  0.00           N  
ATOM    404  H   HIS A  28      31.697  -7.235   3.010  1.00  0.00           H  
ATOM    405  HA  HIS A  28      30.452  -4.759   2.018  1.00  0.00           H  
ATOM    406  HB2 HIS A  28      32.650  -4.474   3.138  1.00  0.00           H  
ATOM    407  HB3 HIS A  28      33.373  -5.542   1.938  1.00  0.00           H  
ATOM    408  HD1 HIS A  28      34.590  -4.248   0.237  1.00  0.00           H  
ATOM    409  HD2 HIS A  28      31.219  -2.224   1.574  1.00  0.00           H  
ATOM    410  HE1 HIS A  28      34.547  -2.090  -1.052  1.00  0.00           H  
ATOM    411  HE2 HIS A  28      32.546  -0.844  -0.164  1.00  0.00           H  
ATOM    412  N   GLY A  29      30.298  -7.066   0.304  1.00  0.00           N  
ATOM    413  CA  GLY A  29      30.147  -7.685  -1.000  1.00  0.00           C  
ATOM    414  C   GLY A  29      30.099  -9.197  -0.922  1.00  0.00           C  
ATOM    415  O   GLY A  29      29.758  -9.776   0.110  1.00  0.00           O  
ATOM    416  H   GLY A  29      29.762  -7.385   1.060  1.00  0.00           H  
ATOM    417  HA2 GLY A  29      29.234  -7.328  -1.453  1.00  0.00           H  
ATOM    418  HA3 GLY A  29      30.981  -7.395  -1.622  1.00  0.00           H  
ATOM    419  N   PRO A  30      30.444  -9.863  -2.034  1.00  0.00           N  
ATOM    420  CA  PRO A  30      30.446 -11.327  -2.112  1.00  0.00           C  
ATOM    421  C   PRO A  30      31.557 -11.951  -1.275  1.00  0.00           C  
ATOM    422  O   PRO A  30      31.736 -13.170  -1.271  1.00  0.00           O  
ATOM    423  CB  PRO A  30      30.678 -11.602  -3.600  1.00  0.00           C  
ATOM    424  CG  PRO A  30      31.391 -10.395  -4.102  1.00  0.00           C  
ATOM    425  CD  PRO A  30      30.862  -9.238  -3.300  1.00  0.00           C  
ATOM    426  HA  PRO A  30      29.495 -11.741  -1.812  1.00  0.00           H  
ATOM    427  HB2 PRO A  30      31.280 -12.493  -3.715  1.00  0.00           H  
ATOM    428  HB3 PRO A  30      29.729 -11.736  -4.098  1.00  0.00           H  
ATOM    429  HG2 PRO A  30      32.454 -10.503  -3.946  1.00  0.00           H  
ATOM    430  HG3 PRO A  30      31.177 -10.252  -5.151  1.00  0.00           H  
ATOM    431  HD2 PRO A  30      31.639  -8.508  -3.132  1.00  0.00           H  
ATOM    432  HD3 PRO A  30      30.018  -8.786  -3.801  1.00  0.00           H  
ATOM    433  N   LEU A  31      32.302 -11.110  -0.566  1.00  0.00           N  
ATOM    434  CA  LEU A  31      33.397 -11.579   0.276  1.00  0.00           C  
ATOM    435  C   LEU A  31      33.411 -10.842   1.611  1.00  0.00           C  
ATOM    436  O   LEU A  31      33.052  -9.666   1.687  1.00  0.00           O  
ATOM    437  CB  LEU A  31      34.734 -11.390  -0.440  1.00  0.00           C  
ATOM    438  CG  LEU A  31      34.905 -12.147  -1.757  1.00  0.00           C  
ATOM    439  CD1 LEU A  31      35.853 -11.401  -2.683  1.00  0.00           C  
ATOM    440  CD2 LEU A  31      35.411 -13.558  -1.498  1.00  0.00           C  
ATOM    441  H   LEU A  31      32.111 -10.149  -0.610  1.00  0.00           H  
ATOM    442  HA  LEU A  31      33.243 -12.632   0.462  1.00  0.00           H  
ATOM    443  HB2 LEU A  31      34.852 -10.336  -0.646  1.00  0.00           H  
ATOM    444  HB3 LEU A  31      35.517 -11.711   0.232  1.00  0.00           H  
ATOM    445  HG  LEU A  31      33.945 -12.220  -2.250  1.00  0.00           H  
ATOM    446 HD11 LEU A  31      35.533 -11.532  -3.706  1.00  0.00           H  
ATOM    447 HD12 LEU A  31      36.852 -11.790  -2.566  1.00  0.00           H  
ATOM    448 HD13 LEU A  31      35.844 -10.350  -2.435  1.00  0.00           H  
ATOM    449 HD21 LEU A  31      36.206 -13.789  -2.192  1.00  0.00           H  
ATOM    450 HD22 LEU A  31      34.602 -14.261  -1.631  1.00  0.00           H  
ATOM    451 HD23 LEU A  31      35.784 -13.628  -0.486  1.00  0.00           H  
ATOM    452  N   LEU A  32      33.830 -11.539   2.661  1.00  0.00           N  
ATOM    453  CA  LEU A  32      33.893 -10.950   3.994  1.00  0.00           C  
ATOM    454  C   LEU A  32      35.250 -10.292   4.234  1.00  0.00           C  
ATOM    455  O   LEU A  32      36.274 -10.758   3.735  1.00  0.00           O  
ATOM    456  CB  LEU A  32      33.637 -12.018   5.059  1.00  0.00           C  
ATOM    457  CG  LEU A  32      32.170 -12.296   5.390  1.00  0.00           C  
ATOM    458  CD1 LEU A  32      32.046 -13.534   6.264  1.00  0.00           C  
ATOM    459  CD2 LEU A  32      31.540 -11.091   6.075  1.00  0.00           C  
ATOM    460  H   LEU A  32      34.102 -12.472   2.539  1.00  0.00           H  
ATOM    461  HA  LEU A  32      33.125 -10.195   4.060  1.00  0.00           H  
ATOM    462  HB2 LEU A  32      34.078 -12.940   4.715  1.00  0.00           H  
ATOM    463  HB3 LEU A  32      34.128 -11.703   5.968  1.00  0.00           H  
ATOM    464  HG  LEU A  32      31.628 -12.480   4.472  1.00  0.00           H  
ATOM    465 HD11 LEU A  32      31.012 -13.677   6.541  1.00  0.00           H  
ATOM    466 HD12 LEU A  32      32.643 -13.406   7.156  1.00  0.00           H  
ATOM    467 HD13 LEU A  32      32.396 -14.397   5.718  1.00  0.00           H  
ATOM    468 HD21 LEU A  32      31.286 -10.348   5.334  1.00  0.00           H  
ATOM    469 HD22 LEU A  32      32.243 -10.672   6.780  1.00  0.00           H  
ATOM    470 HD23 LEU A  32      30.647 -11.401   6.598  1.00  0.00           H  
ATOM    471  N   TYR A  33      35.248  -9.210   5.004  1.00  0.00           N  
ATOM    472  CA  TYR A  33      36.477  -8.489   5.310  1.00  0.00           C  
ATOM    473  C   TYR A  33      36.626  -8.279   6.815  1.00  0.00           C  
ATOM    474  O   TYR A  33      35.655  -7.976   7.508  1.00  0.00           O  
ATOM    475  CB  TYR A  33      36.494  -7.138   4.592  1.00  0.00           C  
ATOM    476  CG  TYR A  33      36.285  -7.245   3.099  1.00  0.00           C  
ATOM    477  CD1 TYR A  33      35.022  -7.477   2.569  1.00  0.00           C  
ATOM    478  CD2 TYR A  33      37.352  -7.113   2.217  1.00  0.00           C  
ATOM    479  CE1 TYR A  33      34.827  -7.576   1.205  1.00  0.00           C  
ATOM    480  CE2 TYR A  33      37.165  -7.209   0.852  1.00  0.00           C  
ATOM    481  CZ  TYR A  33      35.901  -7.441   0.350  1.00  0.00           C  
ATOM    482  OH  TYR A  33      35.711  -7.537  -1.010  1.00  0.00           O  
ATOM    483  H   TYR A  33      34.400  -8.888   5.374  1.00  0.00           H  
ATOM    484  HA  TYR A  33      37.308  -9.084   4.958  1.00  0.00           H  
ATOM    485  HB2 TYR A  33      35.710  -6.515   4.993  1.00  0.00           H  
ATOM    486  HB3 TYR A  33      37.448  -6.661   4.761  1.00  0.00           H  
ATOM    487  HD1 TYR A  33      34.182  -7.582   3.240  1.00  0.00           H  
ATOM    488  HD2 TYR A  33      38.340  -6.932   2.613  1.00  0.00           H  
ATOM    489  HE1 TYR A  33      33.837  -7.756   0.812  1.00  0.00           H  
ATOM    490  HE2 TYR A  33      38.006  -7.104   0.182  1.00  0.00           H  
ATOM    491  HH  TYR A  33      35.285  -8.373  -1.214  1.00  0.00           H  
ATOM    492  N   GLU A  34      37.848  -8.442   7.311  1.00  0.00           N  
ATOM    493  CA  GLU A  34      38.123  -8.270   8.733  1.00  0.00           C  
ATOM    494  C   GLU A  34      37.911  -6.820   9.157  1.00  0.00           C  
ATOM    495  O   GLU A  34      38.419  -5.896   8.522  1.00  0.00           O  
ATOM    496  CB  GLU A  34      39.556  -8.703   9.053  1.00  0.00           C  
ATOM    497  CG  GLU A  34      39.948  -8.484  10.505  1.00  0.00           C  
ATOM    498  CD  GLU A  34      41.434  -8.672  10.743  1.00  0.00           C  
ATOM    499  OE1 GLU A  34      41.890  -9.834  10.750  1.00  0.00           O  
ATOM    500  OE2 GLU A  34      42.139  -7.656  10.921  1.00  0.00           O  
ATOM    501  H   GLU A  34      38.581  -8.683   6.707  1.00  0.00           H  
ATOM    502  HA  GLU A  34      37.437  -8.897   9.281  1.00  0.00           H  
ATOM    503  HB2 GLU A  34      39.661  -9.754   8.828  1.00  0.00           H  
ATOM    504  HB3 GLU A  34      40.236  -8.141   8.430  1.00  0.00           H  
ATOM    505  HG2 GLU A  34      39.678  -7.478  10.789  1.00  0.00           H  
ATOM    506  HG3 GLU A  34      39.407  -9.187  11.121  1.00  0.00           H  
ATOM    507  N   ALA A  35      37.157  -6.629  10.235  1.00  0.00           N  
ATOM    508  CA  ALA A  35      36.879  -5.292  10.745  1.00  0.00           C  
ATOM    509  C   ALA A  35      36.578  -5.327  12.239  1.00  0.00           C  
ATOM    510  O   ALA A  35      36.442  -6.398  12.832  1.00  0.00           O  
ATOM    511  CB  ALA A  35      35.718  -4.668   9.985  1.00  0.00           C  
ATOM    512  H   ALA A  35      36.781  -7.406  10.698  1.00  0.00           H  
ATOM    513  HA  ALA A  35      37.756  -4.682  10.579  1.00  0.00           H  
ATOM    514  HB1 ALA A  35      34.787  -4.972  10.439  1.00  0.00           H  
ATOM    515  HB2 ALA A  35      35.802  -3.591  10.021  1.00  0.00           H  
ATOM    516  HB3 ALA A  35      35.743  -4.997   8.957  1.00  0.00           H  
ATOM    517  N   LYS A  36      36.475  -4.148  12.845  1.00  0.00           N  
ATOM    518  CA  LYS A  36      36.190  -4.043  14.271  1.00  0.00           C  
ATOM    519  C   LYS A  36      35.076  -3.032  14.529  1.00  0.00           C  
ATOM    520  O   LYS A  36      34.962  -2.027  13.827  1.00  0.00           O  
ATOM    521  CB  LYS A  36      37.451  -3.636  15.036  1.00  0.00           C  
ATOM    522  CG  LYS A  36      37.185  -3.235  16.477  1.00  0.00           C  
ATOM    523  CD  LYS A  36      36.900  -1.748  16.599  1.00  0.00           C  
ATOM    524  CE  LYS A  36      38.187  -0.937  16.658  1.00  0.00           C  
ATOM    525  NZ  LYS A  36      38.675  -0.570  15.300  1.00  0.00           N  
ATOM    526  H   LYS A  36      36.593  -3.330  12.319  1.00  0.00           H  
ATOM    527  HA  LYS A  36      35.866  -5.013  14.618  1.00  0.00           H  
ATOM    528  HB2 LYS A  36      38.140  -4.466  15.036  1.00  0.00           H  
ATOM    529  HB3 LYS A  36      37.908  -2.798  14.531  1.00  0.00           H  
ATOM    530  HG2 LYS A  36      36.330  -3.785  16.842  1.00  0.00           H  
ATOM    531  HG3 LYS A  36      38.053  -3.477  17.074  1.00  0.00           H  
ATOM    532  HD2 LYS A  36      36.327  -1.428  15.741  1.00  0.00           H  
ATOM    533  HD3 LYS A  36      36.331  -1.571  17.500  1.00  0.00           H  
ATOM    534  HE2 LYS A  36      38.002  -0.036  17.222  1.00  0.00           H  
ATOM    535  HE3 LYS A  36      38.943  -1.525  17.158  1.00  0.00           H  
ATOM    536  HZ1 LYS A  36      39.582  -1.039  15.108  1.00  0.00           H  
ATOM    537  HZ2 LYS A  36      38.808   0.459  15.235  1.00  0.00           H  
ATOM    538  HZ3 LYS A  36      37.984  -0.865  14.581  1.00  0.00           H  
ATOM    539  N   CYS A  37      34.260  -3.305  15.541  1.00  0.00           N  
ATOM    540  CA  CYS A  37      33.156  -2.418  15.892  1.00  0.00           C  
ATOM    541  C   CYS A  37      33.676  -1.077  16.398  1.00  0.00           C  
ATOM    542  O   CYS A  37      34.100  -0.957  17.549  1.00  0.00           O  
ATOM    543  CB  CYS A  37      32.270  -3.070  16.955  1.00  0.00           C  
ATOM    544  SG  CYS A  37      30.637  -2.311  17.122  1.00  0.00           S  
ATOM    545  H   CYS A  37      34.401  -4.121  16.064  1.00  0.00           H  
ATOM    546  HA  CYS A  37      32.570  -2.250  15.001  1.00  0.00           H  
ATOM    547  HB2 CYS A  37      32.123  -4.110  16.703  1.00  0.00           H  
ATOM    548  HB3 CYS A  37      32.763  -3.005  17.914  1.00  0.00           H  
ATOM    549  HG  CYS A  37      30.785  -0.998  17.025  1.00  0.00           H  
ATOM    550  N   VAL A  38      33.642  -0.069  15.532  1.00  0.00           N  
ATOM    551  CA  VAL A  38      34.110   1.264  15.891  1.00  0.00           C  
ATOM    552  C   VAL A  38      33.081   1.997  16.744  1.00  0.00           C  
ATOM    553  O   VAL A  38      33.420   2.610  17.756  1.00  0.00           O  
ATOM    554  CB  VAL A  38      34.417   2.106  14.639  1.00  0.00           C  
ATOM    555  CG1 VAL A  38      35.199   3.355  15.015  1.00  0.00           C  
ATOM    556  CG2 VAL A  38      35.178   1.280  13.614  1.00  0.00           C  
ATOM    557  H   VAL A  38      33.292  -0.226  14.630  1.00  0.00           H  
ATOM    558  HA  VAL A  38      35.023   1.155  16.460  1.00  0.00           H  
ATOM    559  HB  VAL A  38      33.480   2.415  14.198  1.00  0.00           H  
ATOM    560 HG11 VAL A  38      35.463   3.898  14.119  1.00  0.00           H  
ATOM    561 HG12 VAL A  38      34.592   3.983  15.651  1.00  0.00           H  
ATOM    562 HG13 VAL A  38      36.099   3.072  15.542  1.00  0.00           H  
ATOM    563 HG21 VAL A  38      36.238   1.356  13.803  1.00  0.00           H  
ATOM    564 HG22 VAL A  38      34.873   0.246  13.688  1.00  0.00           H  
ATOM    565 HG23 VAL A  38      34.962   1.648  12.622  1.00  0.00           H  
ATOM    566  N   LYS A  39      31.820   1.929  16.329  1.00  0.00           N  
ATOM    567  CA  LYS A  39      30.740   2.584  17.055  1.00  0.00           C  
ATOM    568  C   LYS A  39      29.443   1.788  16.936  1.00  0.00           C  
ATOM    569  O   LYS A  39      29.343   0.862  16.131  1.00  0.00           O  
ATOM    570  CB  LYS A  39      30.528   4.003  16.524  1.00  0.00           C  
ATOM    571  CG  LYS A  39      31.620   4.976  16.935  1.00  0.00           C  
ATOM    572  CD  LYS A  39      31.211   6.416  16.675  1.00  0.00           C  
ATOM    573  CE  LYS A  39      32.419   7.296  16.393  1.00  0.00           C  
ATOM    574  NZ  LYS A  39      32.792   7.280  14.951  1.00  0.00           N  
ATOM    575  H   LYS A  39      31.612   1.425  15.514  1.00  0.00           H  
ATOM    576  HA  LYS A  39      31.022   2.636  18.095  1.00  0.00           H  
ATOM    577  HB2 LYS A  39      30.492   3.970  15.445  1.00  0.00           H  
ATOM    578  HB3 LYS A  39      29.584   4.377  16.895  1.00  0.00           H  
ATOM    579  HG2 LYS A  39      31.819   4.854  17.989  1.00  0.00           H  
ATOM    580  HG3 LYS A  39      32.515   4.757  16.369  1.00  0.00           H  
ATOM    581  HD2 LYS A  39      30.551   6.446  15.821  1.00  0.00           H  
ATOM    582  HD3 LYS A  39      30.694   6.797  17.545  1.00  0.00           H  
ATOM    583  HE2 LYS A  39      32.187   8.308  16.685  1.00  0.00           H  
ATOM    584  HE3 LYS A  39      33.254   6.935  16.975  1.00  0.00           H  
ATOM    585  HZ1 LYS A  39      32.407   8.120  14.473  1.00  0.00           H  
ATOM    586  HZ2 LYS A  39      32.410   6.428  14.493  1.00  0.00           H  
ATOM    587  HZ3 LYS A  39      33.826   7.281  14.850  1.00  0.00           H  
ATOM    588  N   VAL A  40      28.453   2.154  17.743  1.00  0.00           N  
ATOM    589  CA  VAL A  40      27.163   1.476  17.727  1.00  0.00           C  
ATOM    590  C   VAL A  40      26.014   2.475  17.808  1.00  0.00           C  
ATOM    591  O   VAL A  40      25.743   3.040  18.867  1.00  0.00           O  
ATOM    592  CB  VAL A  40      27.040   0.475  18.891  1.00  0.00           C  
ATOM    593  CG1 VAL A  40      25.701  -0.244  18.838  1.00  0.00           C  
ATOM    594  CG2 VAL A  40      28.190  -0.520  18.861  1.00  0.00           C  
ATOM    595  H   VAL A  40      28.593   2.900  18.364  1.00  0.00           H  
ATOM    596  HA  VAL A  40      27.085   0.928  16.799  1.00  0.00           H  
ATOM    597  HB  VAL A  40      27.091   1.025  19.819  1.00  0.00           H  
ATOM    598 HG11 VAL A  40      25.475  -0.510  17.815  1.00  0.00           H  
ATOM    599 HG12 VAL A  40      25.748  -1.140  19.441  1.00  0.00           H  
ATOM    600 HG13 VAL A  40      24.927   0.406  19.219  1.00  0.00           H  
ATOM    601 HG21 VAL A  40      27.892  -1.431  19.357  1.00  0.00           H  
ATOM    602 HG22 VAL A  40      28.452  -0.737  17.836  1.00  0.00           H  
ATOM    603 HG23 VAL A  40      29.046  -0.097  19.369  1.00  0.00           H  
ATOM    604  N   ALA A  41      25.343   2.690  16.681  1.00  0.00           N  
ATOM    605  CA  ALA A  41      24.223   3.620  16.624  1.00  0.00           C  
ATOM    606  C   ALA A  41      22.911   2.884  16.368  1.00  0.00           C  
ATOM    607  O   ALA A  41      22.908   1.751  15.887  1.00  0.00           O  
ATOM    608  CB  ALA A  41      24.460   4.669  15.549  1.00  0.00           C  
ATOM    609  H   ALA A  41      25.607   2.210  15.869  1.00  0.00           H  
ATOM    610  HA  ALA A  41      24.160   4.125  17.577  1.00  0.00           H  
ATOM    611  HB1 ALA A  41      25.491   4.990  15.582  1.00  0.00           H  
ATOM    612  HB2 ALA A  41      24.246   4.243  14.579  1.00  0.00           H  
ATOM    613  HB3 ALA A  41      23.813   5.516  15.721  1.00  0.00           H  
ATOM    614  N   ILE A  42      21.800   3.536  16.693  1.00  0.00           N  
ATOM    615  CA  ILE A  42      20.483   2.943  16.497  1.00  0.00           C  
ATOM    616  C   ILE A  42      19.493   3.969  15.955  1.00  0.00           C  
ATOM    617  O   ILE A  42      19.278   5.021  16.558  1.00  0.00           O  
ATOM    618  CB  ILE A  42      19.929   2.357  17.809  1.00  0.00           C  
ATOM    619  CG1 ILE A  42      20.891   1.307  18.369  1.00  0.00           C  
ATOM    620  CG2 ILE A  42      18.552   1.750  17.578  1.00  0.00           C  
ATOM    621  CD1 ILE A  42      20.697   1.036  19.845  1.00  0.00           C  
ATOM    622  H   ILE A  42      21.867   4.436  17.072  1.00  0.00           H  
ATOM    623  HA  ILE A  42      20.582   2.141  15.780  1.00  0.00           H  
ATOM    624  HB  ILE A  42      19.826   3.159  18.522  1.00  0.00           H  
ATOM    625 HG12 ILE A  42      20.748   0.378  17.841  1.00  0.00           H  
ATOM    626 HG13 ILE A  42      21.907   1.647  18.224  1.00  0.00           H  
ATOM    627 HG21 ILE A  42      17.864   2.127  18.321  1.00  0.00           H  
ATOM    628 HG22 ILE A  42      18.201   2.020  16.593  1.00  0.00           H  
ATOM    629 HG23 ILE A  42      18.614   0.675  17.657  1.00  0.00           H  
ATOM    630 HD11 ILE A  42      21.277   0.171  20.131  1.00  0.00           H  
ATOM    631 HD12 ILE A  42      21.026   1.893  20.415  1.00  0.00           H  
ATOM    632 HD13 ILE A  42      19.653   0.850  20.043  1.00  0.00           H  
ATOM    633  N   LYS A  43      18.890   3.656  14.813  1.00  0.00           N  
ATOM    634  CA  LYS A  43      17.920   4.549  14.190  1.00  0.00           C  
ATOM    635  C   LYS A  43      17.050   3.793  13.190  1.00  0.00           C  
ATOM    636  O   LYS A  43      17.270   2.610  12.932  1.00  0.00           O  
ATOM    637  CB  LYS A  43      18.637   5.703  13.487  1.00  0.00           C  
ATOM    638  CG  LYS A  43      18.916   6.890  14.394  1.00  0.00           C  
ATOM    639  CD  LYS A  43      19.107   8.169  13.596  1.00  0.00           C  
ATOM    640  CE  LYS A  43      19.633   9.297  14.472  1.00  0.00           C  
ATOM    641  NZ  LYS A  43      18.619   9.748  15.464  1.00  0.00           N  
ATOM    642  H   LYS A  43      19.103   2.803  14.379  1.00  0.00           H  
ATOM    643  HA  LYS A  43      17.289   4.949  14.968  1.00  0.00           H  
ATOM    644  HB2 LYS A  43      19.579   5.344  13.099  1.00  0.00           H  
ATOM    645  HB3 LYS A  43      18.025   6.044  12.663  1.00  0.00           H  
ATOM    646  HG2 LYS A  43      18.081   7.020  15.067  1.00  0.00           H  
ATOM    647  HG3 LYS A  43      19.813   6.692  14.963  1.00  0.00           H  
ATOM    648  HD2 LYS A  43      19.815   7.984  12.802  1.00  0.00           H  
ATOM    649  HD3 LYS A  43      18.158   8.465  13.174  1.00  0.00           H  
ATOM    650  HE2 LYS A  43      20.509   8.949  14.996  1.00  0.00           H  
ATOM    651  HE3 LYS A  43      19.900  10.130  13.838  1.00  0.00           H  
ATOM    652  HZ1 LYS A  43      18.782   9.278  16.378  1.00  0.00           H  
ATOM    653  HZ2 LYS A  43      17.663   9.511  15.131  1.00  0.00           H  
ATOM    654  HZ3 LYS A  43      18.683  10.777  15.598  1.00  0.00           H  
ATOM    655  N   ASP A  44      16.063   4.484  12.631  1.00  0.00           N  
ATOM    656  CA  ASP A  44      15.160   3.879  11.658  1.00  0.00           C  
ATOM    657  C   ASP A  44      14.707   2.499  12.123  1.00  0.00           C  
ATOM    658  O   ASP A  44      14.478   1.602  11.312  1.00  0.00           O  
ATOM    659  CB  ASP A  44      15.845   3.773  10.295  1.00  0.00           C  
ATOM    660  CG  ASP A  44      14.858   3.834   9.145  1.00  0.00           C  
ATOM    661  OD1 ASP A  44      14.471   4.955   8.755  1.00  0.00           O  
ATOM    662  OD2 ASP A  44      14.471   2.761   8.637  1.00  0.00           O  
ATOM    663  H   ASP A  44      15.938   5.425  12.879  1.00  0.00           H  
ATOM    664  HA  ASP A  44      14.295   4.517  11.567  1.00  0.00           H  
ATOM    665  HB2 ASP A  44      16.547   4.587  10.186  1.00  0.00           H  
ATOM    666  HB3 ASP A  44      16.377   2.834  10.239  1.00  0.00           H  
ATOM    667  N   LYS A  45      14.580   2.335  13.435  1.00  0.00           N  
ATOM    668  CA  LYS A  45      14.154   1.064  14.010  1.00  0.00           C  
ATOM    669  C   LYS A  45      15.134  -0.049  13.658  1.00  0.00           C  
ATOM    670  O   LYS A  45      14.733  -1.181  13.390  1.00  0.00           O  
ATOM    671  CB  LYS A  45      12.753   0.701  13.513  1.00  0.00           C  
ATOM    672  CG  LYS A  45      11.640   1.439  14.236  1.00  0.00           C  
ATOM    673  CD  LYS A  45      11.491   2.862  13.724  1.00  0.00           C  
ATOM    674  CE  LYS A  45      10.368   3.597  14.440  1.00  0.00           C  
ATOM    675  NZ  LYS A  45      10.800   4.109  15.770  1.00  0.00           N  
ATOM    676  H   LYS A  45      14.778   3.087  14.033  1.00  0.00           H  
ATOM    677  HA  LYS A  45      14.127   1.178  15.083  1.00  0.00           H  
ATOM    678  HB2 LYS A  45      12.686   0.933  12.460  1.00  0.00           H  
ATOM    679  HB3 LYS A  45      12.600  -0.360  13.650  1.00  0.00           H  
ATOM    680  HG2 LYS A  45      10.710   0.913  14.079  1.00  0.00           H  
ATOM    681  HG3 LYS A  45      11.866   1.468  15.292  1.00  0.00           H  
ATOM    682  HD2 LYS A  45      12.417   3.393  13.890  1.00  0.00           H  
ATOM    683  HD3 LYS A  45      11.274   2.834  12.666  1.00  0.00           H  
ATOM    684  HE2 LYS A  45      10.052   4.429  13.829  1.00  0.00           H  
ATOM    685  HE3 LYS A  45       9.540   2.917  14.577  1.00  0.00           H  
ATOM    686  HZ1 LYS A  45      11.764   4.495  15.709  1.00  0.00           H  
ATOM    687  HZ2 LYS A  45      10.789   3.339  16.470  1.00  0.00           H  
ATOM    688  HZ3 LYS A  45      10.156   4.860  16.090  1.00  0.00           H  
ATOM    689  N   GLN A  46      16.422   0.280  13.661  1.00  0.00           N  
ATOM    690  CA  GLN A  46      17.461  -0.693  13.341  1.00  0.00           C  
ATOM    691  C   GLN A  46      18.765  -0.353  14.055  1.00  0.00           C  
ATOM    692  O   GLN A  46      19.057   0.815  14.313  1.00  0.00           O  
ATOM    693  CB  GLN A  46      17.692  -0.747  11.830  1.00  0.00           C  
ATOM    694  CG  GLN A  46      18.637   0.331  11.320  1.00  0.00           C  
ATOM    695  CD  GLN A  46      19.054   0.107   9.881  1.00  0.00           C  
ATOM    696  OE1 GLN A  46      19.342  -1.019   9.473  1.00  0.00           O  
ATOM    697  NE2 GLN A  46      19.090   1.181   9.100  1.00  0.00           N  
ATOM    698  H   GLN A  46      16.681   1.199  13.882  1.00  0.00           H  
ATOM    699  HA  GLN A  46      17.122  -1.661  13.678  1.00  0.00           H  
ATOM    700  HB2 GLN A  46      18.107  -1.710  11.575  1.00  0.00           H  
ATOM    701  HB3 GLN A  46      16.743  -0.629  11.328  1.00  0.00           H  
ATOM    702  HG2 GLN A  46      18.140   1.288  11.391  1.00  0.00           H  
ATOM    703  HG3 GLN A  46      19.520   0.338  11.941  1.00  0.00           H  
ATOM    704 HE21 GLN A  46      18.848   2.046   9.494  1.00  0.00           H  
ATOM    705 HE22 GLN A  46      19.357   1.065   8.166  1.00  0.00           H  
ATOM    706  N   VAL A  47      19.544  -1.381  14.373  1.00  0.00           N  
ATOM    707  CA  VAL A  47      20.818  -1.191  15.057  1.00  0.00           C  
ATOM    708  C   VAL A  47      21.988  -1.323  14.088  1.00  0.00           C  
ATOM    709  O   VAL A  47      22.118  -2.325  13.386  1.00  0.00           O  
ATOM    710  CB  VAL A  47      20.998  -2.206  16.201  1.00  0.00           C  
ATOM    711  CG1 VAL A  47      22.170  -1.812  17.086  1.00  0.00           C  
ATOM    712  CG2 VAL A  47      19.719  -2.321  17.016  1.00  0.00           C  
ATOM    713  H   VAL A  47      19.258  -2.289  14.141  1.00  0.00           H  
ATOM    714  HA  VAL A  47      20.824  -0.197  15.481  1.00  0.00           H  
ATOM    715  HB  VAL A  47      21.211  -3.172  15.768  1.00  0.00           H  
ATOM    716 HG11 VAL A  47      22.013  -2.195  18.084  1.00  0.00           H  
ATOM    717 HG12 VAL A  47      23.083  -2.224  16.681  1.00  0.00           H  
ATOM    718 HG13 VAL A  47      22.247  -0.735  17.123  1.00  0.00           H  
ATOM    719 HG21 VAL A  47      19.401  -3.353  17.045  1.00  0.00           H  
ATOM    720 HG22 VAL A  47      19.901  -1.973  18.022  1.00  0.00           H  
ATOM    721 HG23 VAL A  47      18.946  -1.719  16.561  1.00  0.00           H  
ATOM    722  N   LYS A  48      22.838  -0.302  14.054  1.00  0.00           N  
ATOM    723  CA  LYS A  48      23.999  -0.302  13.171  1.00  0.00           C  
ATOM    724  C   LYS A  48      25.293  -0.259  13.977  1.00  0.00           C  
ATOM    725  O   LYS A  48      25.272  -0.100  15.197  1.00  0.00           O  
ATOM    726  CB  LYS A  48      23.940   0.893  12.218  1.00  0.00           C  
ATOM    727  CG  LYS A  48      22.882   0.756  11.136  1.00  0.00           C  
ATOM    728  CD  LYS A  48      23.287   1.483   9.864  1.00  0.00           C  
ATOM    729  CE  LYS A  48      22.080   1.799   8.995  1.00  0.00           C  
ATOM    730  NZ  LYS A  48      22.433   2.698   7.861  1.00  0.00           N  
ATOM    731  H   LYS A  48      22.681   0.472  14.637  1.00  0.00           H  
ATOM    732  HA  LYS A  48      23.978  -1.214  12.595  1.00  0.00           H  
ATOM    733  HB2 LYS A  48      23.729   1.784  12.789  1.00  0.00           H  
ATOM    734  HB3 LYS A  48      24.902   1.003  11.738  1.00  0.00           H  
ATOM    735  HG2 LYS A  48      22.743  -0.290  10.911  1.00  0.00           H  
ATOM    736  HG3 LYS A  48      21.954   1.175  11.499  1.00  0.00           H  
ATOM    737  HD2 LYS A  48      23.777   2.408  10.130  1.00  0.00           H  
ATOM    738  HD3 LYS A  48      23.970   0.859   9.305  1.00  0.00           H  
ATOM    739  HE2 LYS A  48      21.685   0.875   8.601  1.00  0.00           H  
ATOM    740  HE3 LYS A  48      21.330   2.280   9.605  1.00  0.00           H  
ATOM    741  HZ1 LYS A  48      21.785   3.512   7.835  1.00  0.00           H  
ATOM    742  HZ2 LYS A  48      22.361   2.183   6.961  1.00  0.00           H  
ATOM    743  HZ3 LYS A  48      23.406   3.047   7.972  1.00  0.00           H  
ATOM    744  N   TYR A  49      26.420  -0.401  13.286  1.00  0.00           N  
ATOM    745  CA  TYR A  49      27.723  -0.380  13.938  1.00  0.00           C  
ATOM    746  C   TYR A  49      28.800   0.131  12.985  1.00  0.00           C  
ATOM    747  O   TYR A  49      29.032  -0.448  11.924  1.00  0.00           O  
ATOM    748  CB  TYR A  49      28.090  -1.779  14.437  1.00  0.00           C  
ATOM    749  CG  TYR A  49      26.948  -2.498  15.118  1.00  0.00           C  
ATOM    750  CD1 TYR A  49      25.823  -2.890  14.403  1.00  0.00           C  
ATOM    751  CD2 TYR A  49      26.993  -2.786  16.477  1.00  0.00           C  
ATOM    752  CE1 TYR A  49      24.776  -3.547  15.021  1.00  0.00           C  
ATOM    753  CE2 TYR A  49      25.952  -3.443  17.103  1.00  0.00           C  
ATOM    754  CZ  TYR A  49      24.846  -3.821  16.371  1.00  0.00           C  
ATOM    755  OH  TYR A  49      23.806  -4.476  16.990  1.00  0.00           O  
ATOM    756  H   TYR A  49      26.373  -0.525  12.316  1.00  0.00           H  
ATOM    757  HA  TYR A  49      27.661   0.288  14.783  1.00  0.00           H  
ATOM    758  HB2 TYR A  49      28.408  -2.381  13.600  1.00  0.00           H  
ATOM    759  HB3 TYR A  49      28.902  -1.700  15.146  1.00  0.00           H  
ATOM    760  HD1 TYR A  49      25.772  -2.673  13.346  1.00  0.00           H  
ATOM    761  HD2 TYR A  49      27.862  -2.489  17.047  1.00  0.00           H  
ATOM    762  HE1 TYR A  49      23.910  -3.842  14.448  1.00  0.00           H  
ATOM    763  HE2 TYR A  49      26.007  -3.659  18.160  1.00  0.00           H  
ATOM    764  HH  TYR A  49      23.009  -4.379  16.465  1.00  0.00           H  
ATOM    765  N   PHE A  50      29.455   1.219  13.373  1.00  0.00           N  
ATOM    766  CA  PHE A  50      30.509   1.810  12.554  1.00  0.00           C  
ATOM    767  C   PHE A  50      31.678   0.844  12.391  1.00  0.00           C  
ATOM    768  O   PHE A  50      32.489   0.674  13.303  1.00  0.00           O  
ATOM    769  CB  PHE A  50      30.997   3.118  13.180  1.00  0.00           C  
ATOM    770  CG  PHE A  50      31.928   3.896  12.295  1.00  0.00           C  
ATOM    771  CD1 PHE A  50      31.663   4.037  10.942  1.00  0.00           C  
ATOM    772  CD2 PHE A  50      33.069   4.485  12.815  1.00  0.00           C  
ATOM    773  CE1 PHE A  50      32.519   4.750  10.125  1.00  0.00           C  
ATOM    774  CE2 PHE A  50      33.929   5.200  12.003  1.00  0.00           C  
ATOM    775  CZ  PHE A  50      33.653   5.334  10.657  1.00  0.00           C  
ATOM    776  H   PHE A  50      29.226   1.636  14.230  1.00  0.00           H  
ATOM    777  HA  PHE A  50      30.092   2.020  11.582  1.00  0.00           H  
ATOM    778  HB2 PHE A  50      30.145   3.745  13.397  1.00  0.00           H  
ATOM    779  HB3 PHE A  50      31.518   2.897  14.100  1.00  0.00           H  
ATOM    780  HD1 PHE A  50      30.776   3.581  10.526  1.00  0.00           H  
ATOM    781  HD2 PHE A  50      33.286   4.381  13.870  1.00  0.00           H  
ATOM    782  HE1 PHE A  50      32.301   4.853   9.072  1.00  0.00           H  
ATOM    783  HE2 PHE A  50      34.814   5.656  12.423  1.00  0.00           H  
ATOM    784  HZ  PHE A  50      34.324   5.892  10.020  1.00  0.00           H  
ATOM    785  N   ILE A  51      31.757   0.211  11.226  1.00  0.00           N  
ATOM    786  CA  ILE A  51      32.826  -0.737  10.943  1.00  0.00           C  
ATOM    787  C   ILE A  51      34.081  -0.022  10.455  1.00  0.00           C  
ATOM    788  O   ILE A  51      34.004   1.051   9.854  1.00  0.00           O  
ATOM    789  CB  ILE A  51      32.396  -1.773   9.888  1.00  0.00           C  
ATOM    790  CG1 ILE A  51      31.165  -2.542  10.370  1.00  0.00           C  
ATOM    791  CG2 ILE A  51      33.541  -2.729   9.586  1.00  0.00           C  
ATOM    792  CD1 ILE A  51      31.411  -3.354  11.622  1.00  0.00           C  
ATOM    793  H   ILE A  51      31.081   0.388  10.539  1.00  0.00           H  
ATOM    794  HA  ILE A  51      33.058  -1.262  11.859  1.00  0.00           H  
ATOM    795  HB  ILE A  51      32.149  -1.247   8.979  1.00  0.00           H  
ATOM    796 HG12 ILE A  51      30.370  -1.844  10.579  1.00  0.00           H  
ATOM    797 HG13 ILE A  51      30.846  -3.221   9.591  1.00  0.00           H  
ATOM    798 HG21 ILE A  51      34.355  -2.184   9.132  1.00  0.00           H  
ATOM    799 HG22 ILE A  51      33.880  -3.183  10.505  1.00  0.00           H  
ATOM    800 HG23 ILE A  51      33.199  -3.497   8.908  1.00  0.00           H  
ATOM    801 HD11 ILE A  51      30.546  -3.967  11.830  1.00  0.00           H  
ATOM    802 HD12 ILE A  51      32.274  -3.988  11.477  1.00  0.00           H  
ATOM    803 HD13 ILE A  51      31.588  -2.689  12.454  1.00  0.00           H  
ATOM    804  N   HIS A  52      35.238  -0.623  10.714  1.00  0.00           N  
ATOM    805  CA  HIS A  52      36.512  -0.045  10.299  1.00  0.00           C  
ATOM    806  C   HIS A  52      37.370  -1.080   9.579  1.00  0.00           C  
ATOM    807  O   HIS A  52      38.116  -1.828  10.209  1.00  0.00           O  
ATOM    808  CB  HIS A  52      37.264   0.506  11.510  1.00  0.00           C  
ATOM    809  CG  HIS A  52      38.703   0.818  11.230  1.00  0.00           C  
ATOM    810  ND1 HIS A  52      39.114   1.979  10.611  1.00  0.00           N  
ATOM    811  CD2 HIS A  52      39.828   0.111  11.490  1.00  0.00           C  
ATOM    812  CE1 HIS A  52      40.431   1.974  10.500  1.00  0.00           C  
ATOM    813  NE2 HIS A  52      40.888   0.851  11.026  1.00  0.00           N  
ATOM    814  H   HIS A  52      35.236  -1.476  11.197  1.00  0.00           H  
ATOM    815  HA  HIS A  52      36.300   0.767   9.618  1.00  0.00           H  
ATOM    816  HB2 HIS A  52      36.787   1.417  11.839  1.00  0.00           H  
ATOM    817  HB3 HIS A  52      37.231  -0.222  12.308  1.00  0.00           H  
ATOM    818  HD1 HIS A  52      38.529   2.699  10.298  1.00  0.00           H  
ATOM    819  HD2 HIS A  52      39.883  -0.854  11.971  1.00  0.00           H  
ATOM    820  HE1 HIS A  52      41.031   2.753  10.057  1.00  0.00           H  
ATOM    821  HE2 HIS A  52      41.821   0.555  10.999  1.00  0.00           H  
ATOM    822  N   TYR A  53      37.257  -1.117   8.255  1.00  0.00           N  
ATOM    823  CA  TYR A  53      38.019  -2.064   7.450  1.00  0.00           C  
ATOM    824  C   TYR A  53      39.493  -2.049   7.843  1.00  0.00           C  
ATOM    825  O   TYR A  53      40.176  -1.036   7.699  1.00  0.00           O  
ATOM    826  CB  TYR A  53      37.873  -1.733   5.963  1.00  0.00           C  
ATOM    827  CG  TYR A  53      36.466  -1.906   5.440  1.00  0.00           C  
ATOM    828  CD1 TYR A  53      35.723  -3.039   5.750  1.00  0.00           C  
ATOM    829  CD2 TYR A  53      35.879  -0.937   4.635  1.00  0.00           C  
ATOM    830  CE1 TYR A  53      34.436  -3.201   5.273  1.00  0.00           C  
ATOM    831  CE2 TYR A  53      34.593  -1.090   4.156  1.00  0.00           C  
ATOM    832  CZ  TYR A  53      33.876  -2.223   4.477  1.00  0.00           C  
ATOM    833  OH  TYR A  53      32.595  -2.382   4.000  1.00  0.00           O  
ATOM    834  H   TYR A  53      36.644  -0.495   7.810  1.00  0.00           H  
ATOM    835  HA  TYR A  53      37.620  -3.050   7.631  1.00  0.00           H  
ATOM    836  HB2 TYR A  53      38.164  -0.707   5.799  1.00  0.00           H  
ATOM    837  HB3 TYR A  53      38.522  -2.382   5.393  1.00  0.00           H  
ATOM    838  HD1 TYR A  53      36.165  -3.802   6.373  1.00  0.00           H  
ATOM    839  HD2 TYR A  53      36.444  -0.050   4.386  1.00  0.00           H  
ATOM    840  HE1 TYR A  53      33.874  -4.088   5.524  1.00  0.00           H  
ATOM    841  HE2 TYR A  53      34.154  -0.326   3.532  1.00  0.00           H  
ATOM    842  HH  TYR A  53      32.157  -3.085   4.485  1.00  0.00           H  
ATOM    843  N   SER A  54      39.977  -3.183   8.341  1.00  0.00           N  
ATOM    844  CA  SER A  54      41.369  -3.302   8.759  1.00  0.00           C  
ATOM    845  C   SER A  54      42.309  -3.156   7.565  1.00  0.00           C  
ATOM    846  O   SER A  54      43.348  -2.505   7.656  1.00  0.00           O  
ATOM    847  CB  SER A  54      41.605  -4.649   9.446  1.00  0.00           C  
ATOM    848  OG  SER A  54      42.733  -4.595  10.301  1.00  0.00           O  
ATOM    849  H   SER A  54      39.382  -3.957   8.431  1.00  0.00           H  
ATOM    850  HA  SER A  54      41.573  -2.509   9.462  1.00  0.00           H  
ATOM    851  HB2 SER A  54      40.736  -4.906  10.033  1.00  0.00           H  
ATOM    852  HB3 SER A  54      41.771  -5.408   8.696  1.00  0.00           H  
ATOM    853  HG  SER A  54      43.444  -5.121   9.926  1.00  0.00           H  
ATOM    854  N   GLY A  55      41.935  -3.771   6.447  1.00  0.00           N  
ATOM    855  CA  GLY A  55      42.754  -3.698   5.251  1.00  0.00           C  
ATOM    856  C   GLY A  55      43.460  -2.364   5.113  1.00  0.00           C  
ATOM    857  O   GLY A  55      44.688  -2.297   5.144  1.00  0.00           O  
ATOM    858  H   GLY A  55      41.095  -4.276   6.434  1.00  0.00           H  
ATOM    859  HA2 GLY A  55      43.494  -4.483   5.287  1.00  0.00           H  
ATOM    860  HA3 GLY A  55      42.123  -3.851   4.387  1.00  0.00           H  
ATOM    861  N   TRP A  56      42.681  -1.299   4.956  1.00  0.00           N  
ATOM    862  CA  TRP A  56      43.240   0.040   4.809  1.00  0.00           C  
ATOM    863  C   TRP A  56      42.625   1.001   5.820  1.00  0.00           C  
ATOM    864  O   TRP A  56      41.420   0.967   6.068  1.00  0.00           O  
ATOM    865  CB  TRP A  56      43.008   0.559   3.389  1.00  0.00           C  
ATOM    866  CG  TRP A  56      44.054   0.107   2.414  1.00  0.00           C  
ATOM    867  CD1 TRP A  56      45.370  -0.146   2.681  1.00  0.00           C  
ATOM    868  CD2 TRP A  56      43.872  -0.142   1.016  1.00  0.00           C  
ATOM    869  NE1 TRP A  56      46.015  -0.539   1.534  1.00  0.00           N  
ATOM    870  CE2 TRP A  56      45.118  -0.545   0.498  1.00  0.00           C  
ATOM    871  CE3 TRP A  56      42.777  -0.066   0.151  1.00  0.00           C  
ATOM    872  CZ2 TRP A  56      45.297  -0.868  -0.844  1.00  0.00           C  
ATOM    873  CZ3 TRP A  56      42.956  -0.387  -1.181  1.00  0.00           C  
ATOM    874  CH2 TRP A  56      44.209  -0.785  -1.668  1.00  0.00           C  
ATOM    875  H   TRP A  56      41.708  -1.416   4.939  1.00  0.00           H  
ATOM    876  HA  TRP A  56      44.303  -0.023   4.990  1.00  0.00           H  
ATOM    877  HB2 TRP A  56      42.051   0.208   3.035  1.00  0.00           H  
ATOM    878  HB3 TRP A  56      43.010   1.639   3.404  1.00  0.00           H  
ATOM    879  HD1 TRP A  56      45.822  -0.048   3.656  1.00  0.00           H  
ATOM    880  HE1 TRP A  56      46.965  -0.777   1.468  1.00  0.00           H  
ATOM    881  HE3 TRP A  56      41.804   0.238   0.508  1.00  0.00           H  
ATOM    882  HZ2 TRP A  56      46.256  -1.177  -1.235  1.00  0.00           H  
ATOM    883  HZ3 TRP A  56      42.122  -0.334  -1.864  1.00  0.00           H  
ATOM    884  HH2 TRP A  56      44.302  -1.026  -2.715  1.00  0.00           H  
ATOM    885  N   ASN A  57      43.459   1.856   6.402  1.00  0.00           N  
ATOM    886  CA  ASN A  57      42.995   2.827   7.387  1.00  0.00           C  
ATOM    887  C   ASN A  57      41.988   3.790   6.769  1.00  0.00           C  
ATOM    888  O   ASN A  57      42.162   4.248   5.639  1.00  0.00           O  
ATOM    889  CB  ASN A  57      44.179   3.608   7.961  1.00  0.00           C  
ATOM    890  CG  ASN A  57      44.833   2.893   9.128  1.00  0.00           C  
ATOM    891  OD1 ASN A  57      44.869   1.663   9.175  1.00  0.00           O  
ATOM    892  ND2 ASN A  57      45.352   3.663  10.076  1.00  0.00           N  
ATOM    893  H   ASN A  57      44.409   1.835   6.162  1.00  0.00           H  
ATOM    894  HA  ASN A  57      42.513   2.283   8.185  1.00  0.00           H  
ATOM    895  HB2 ASN A  57      44.921   3.745   7.187  1.00  0.00           H  
ATOM    896  HB3 ASN A  57      43.836   4.574   8.300  1.00  0.00           H  
ATOM    897 HD21 ASN A  57      45.286   4.635   9.972  1.00  0.00           H  
ATOM    898 HD22 ASN A  57      45.781   3.227  10.843  1.00  0.00           H  
ATOM    899  N   LYS A  58      40.933   4.096   7.517  1.00  0.00           N  
ATOM    900  CA  LYS A  58      39.897   5.007   7.046  1.00  0.00           C  
ATOM    901  C   LYS A  58      39.557   4.734   5.584  1.00  0.00           C  
ATOM    902  O   LYS A  58      39.479   5.656   4.772  1.00  0.00           O  
ATOM    903  CB  LYS A  58      40.351   6.459   7.212  1.00  0.00           C  
ATOM    904  CG  LYS A  58      39.208   7.430   7.452  1.00  0.00           C  
ATOM    905  CD  LYS A  58      38.593   7.902   6.145  1.00  0.00           C  
ATOM    906  CE  LYS A  58      37.619   9.049   6.369  1.00  0.00           C  
ATOM    907  NZ  LYS A  58      36.410   8.611   7.120  1.00  0.00           N  
ATOM    908  H   LYS A  58      40.850   3.699   8.410  1.00  0.00           H  
ATOM    909  HA  LYS A  58      39.014   4.844   7.644  1.00  0.00           H  
ATOM    910  HB2 LYS A  58      41.027   6.518   8.052  1.00  0.00           H  
ATOM    911  HB3 LYS A  58      40.874   6.765   6.318  1.00  0.00           H  
ATOM    912  HG2 LYS A  58      38.446   6.937   8.039  1.00  0.00           H  
ATOM    913  HG3 LYS A  58      39.583   8.287   7.993  1.00  0.00           H  
ATOM    914  HD2 LYS A  58      39.381   8.238   5.487  1.00  0.00           H  
ATOM    915  HD3 LYS A  58      38.065   7.078   5.687  1.00  0.00           H  
ATOM    916  HE2 LYS A  58      38.119   9.824   6.930  1.00  0.00           H  
ATOM    917  HE3 LYS A  58      37.315   9.438   5.409  1.00  0.00           H  
ATOM    918  HZ1 LYS A  58      35.890   9.438   7.473  1.00  0.00           H  
ATOM    919  HZ2 LYS A  58      36.687   8.017   7.928  1.00  0.00           H  
ATOM    920  HZ3 LYS A  58      35.784   8.060   6.499  1.00  0.00           H  
ATOM    921  N   ASN A  59      39.355   3.463   5.256  1.00  0.00           N  
ATOM    922  CA  ASN A  59      39.024   3.070   3.890  1.00  0.00           C  
ATOM    923  C   ASN A  59      37.539   3.284   3.609  1.00  0.00           C  
ATOM    924  O   ASN A  59      36.750   2.340   3.633  1.00  0.00           O  
ATOM    925  CB  ASN A  59      39.392   1.603   3.656  1.00  0.00           C  
ATOM    926  CG  ASN A  59      39.640   1.296   2.192  1.00  0.00           C  
ATOM    927  OD1 ASN A  59      40.276   2.075   1.483  1.00  0.00           O  
ATOM    928  ND2 ASN A  59      39.137   0.156   1.733  1.00  0.00           N  
ATOM    929  H   ASN A  59      39.432   2.772   5.946  1.00  0.00           H  
ATOM    930  HA  ASN A  59      39.598   3.687   3.218  1.00  0.00           H  
ATOM    931  HB2 ASN A  59      40.289   1.371   4.209  1.00  0.00           H  
ATOM    932  HB3 ASN A  59      38.585   0.976   4.005  1.00  0.00           H  
ATOM    933 HD21 ASN A  59      38.640  -0.415   2.356  1.00  0.00           H  
ATOM    934 HD22 ASN A  59      39.283  -0.068   0.790  1.00  0.00           H  
ATOM    935  N   TRP A  60      37.168   4.531   3.340  1.00  0.00           N  
ATOM    936  CA  TRP A  60      35.779   4.869   3.053  1.00  0.00           C  
ATOM    937  C   TRP A  60      34.836   4.178   4.033  1.00  0.00           C  
ATOM    938  O   TRP A  60      33.770   3.697   3.647  1.00  0.00           O  
ATOM    939  CB  TRP A  60      35.423   4.475   1.619  1.00  0.00           C  
ATOM    940  CG  TRP A  60      36.440   4.916   0.611  1.00  0.00           C  
ATOM    941  CD1 TRP A  60      36.748   6.201   0.265  1.00  0.00           C  
ATOM    942  CD2 TRP A  60      37.283   4.073  -0.182  1.00  0.00           C  
ATOM    943  NE1 TRP A  60      37.731   6.208  -0.695  1.00  0.00           N  
ATOM    944  CE2 TRP A  60      38.076   4.915  -0.986  1.00  0.00           C  
ATOM    945  CE3 TRP A  60      37.445   2.689  -0.290  1.00  0.00           C  
ATOM    946  CZ2 TRP A  60      39.015   4.415  -1.885  1.00  0.00           C  
ATOM    947  CZ3 TRP A  60      38.376   2.196  -1.184  1.00  0.00           C  
ATOM    948  CH2 TRP A  60      39.153   3.057  -1.971  1.00  0.00           C  
ATOM    949  H   TRP A  60      37.844   5.241   3.335  1.00  0.00           H  
ATOM    950  HA  TRP A  60      35.670   5.939   3.161  1.00  0.00           H  
ATOM    951  HB2 TRP A  60      35.337   3.401   1.558  1.00  0.00           H  
ATOM    952  HB3 TRP A  60      34.475   4.924   1.355  1.00  0.00           H  
ATOM    953  HD1 TRP A  60      36.279   7.075   0.692  1.00  0.00           H  
ATOM    954  HE1 TRP A  60      38.122   7.009  -1.103  1.00  0.00           H  
ATOM    955  HE3 TRP A  60      36.855   2.010   0.307  1.00  0.00           H  
ATOM    956  HZ2 TRP A  60      39.622   5.066  -2.497  1.00  0.00           H  
ATOM    957  HZ3 TRP A  60      38.516   1.129  -1.281  1.00  0.00           H  
ATOM    958  HH2 TRP A  60      39.868   2.627  -2.654  1.00  0.00           H  
ATOM    959  N   ASP A  61      35.235   4.132   5.299  1.00  0.00           N  
ATOM    960  CA  ASP A  61      34.425   3.501   6.333  1.00  0.00           C  
ATOM    961  C   ASP A  61      32.938   3.705   6.059  1.00  0.00           C  
ATOM    962  O   ASP A  61      32.539   4.703   5.460  1.00  0.00           O  
ATOM    963  CB  ASP A  61      34.785   4.065   7.708  1.00  0.00           C  
ATOM    964  CG  ASP A  61      35.983   3.370   8.324  1.00  0.00           C  
ATOM    965  OD1 ASP A  61      37.027   3.276   7.646  1.00  0.00           O  
ATOM    966  OD2 ASP A  61      35.876   2.920   9.485  1.00  0.00           O  
ATOM    967  H   ASP A  61      36.096   4.533   5.542  1.00  0.00           H  
ATOM    968  HA  ASP A  61      34.638   2.442   6.322  1.00  0.00           H  
ATOM    969  HB2 ASP A  61      35.013   5.117   7.610  1.00  0.00           H  
ATOM    970  HB3 ASP A  61      33.941   3.945   8.372  1.00  0.00           H  
ATOM    971  N   GLU A  62      32.124   2.751   6.501  1.00  0.00           N  
ATOM    972  CA  GLU A  62      30.681   2.826   6.300  1.00  0.00           C  
ATOM    973  C   GLU A  62      29.936   2.154   7.450  1.00  0.00           C  
ATOM    974  O   GLU A  62      30.481   1.287   8.133  1.00  0.00           O  
ATOM    975  CB  GLU A  62      30.293   2.170   4.974  1.00  0.00           C  
ATOM    976  CG  GLU A  62      31.085   0.910   4.664  1.00  0.00           C  
ATOM    977  CD  GLU A  62      32.455   1.209   4.090  1.00  0.00           C  
ATOM    978  OE1 GLU A  62      32.559   1.379   2.857  1.00  0.00           O  
ATOM    979  OE2 GLU A  62      33.426   1.272   4.874  1.00  0.00           O  
ATOM    980  H   GLU A  62      32.502   1.979   6.971  1.00  0.00           H  
ATOM    981  HA  GLU A  62      30.405   3.869   6.269  1.00  0.00           H  
ATOM    982  HB2 GLU A  62      29.245   1.913   5.007  1.00  0.00           H  
ATOM    983  HB3 GLU A  62      30.456   2.877   4.175  1.00  0.00           H  
ATOM    984  HG2 GLU A  62      31.209   0.344   5.576  1.00  0.00           H  
ATOM    985  HG3 GLU A  62      30.532   0.319   3.948  1.00  0.00           H  
ATOM    986  N   TRP A  63      28.690   2.561   7.657  1.00  0.00           N  
ATOM    987  CA  TRP A  63      27.870   1.998   8.725  1.00  0.00           C  
ATOM    988  C   TRP A  63      27.153   0.738   8.254  1.00  0.00           C  
ATOM    989  O   TRP A  63      26.661   0.676   7.128  1.00  0.00           O  
ATOM    990  CB  TRP A  63      26.849   3.030   9.209  1.00  0.00           C  
ATOM    991  CG  TRP A  63      27.431   4.050  10.141  1.00  0.00           C  
ATOM    992  CD1 TRP A  63      27.963   5.262   9.802  1.00  0.00           C  
ATOM    993  CD2 TRP A  63      27.543   3.945  11.564  1.00  0.00           C  
ATOM    994  NE1 TRP A  63      28.398   5.916  10.929  1.00  0.00           N  
ATOM    995  CE2 TRP A  63      28.150   5.130  12.023  1.00  0.00           C  
ATOM    996  CE3 TRP A  63      27.186   2.966  12.496  1.00  0.00           C  
ATOM    997  CZ2 TRP A  63      28.408   5.360  13.372  1.00  0.00           C  
ATOM    998  CZ3 TRP A  63      27.444   3.196  13.834  1.00  0.00           C  
ATOM    999  CH2 TRP A  63      28.049   4.385  14.262  1.00  0.00           C  
ATOM   1000  H   TRP A  63      28.311   3.256   7.079  1.00  0.00           H  
ATOM   1001  HA  TRP A  63      28.526   1.742   9.544  1.00  0.00           H  
ATOM   1002  HB2 TRP A  63      26.442   3.552   8.356  1.00  0.00           H  
ATOM   1003  HB3 TRP A  63      26.052   2.520   9.729  1.00  0.00           H  
ATOM   1004  HD1 TRP A  63      28.027   5.635   8.791  1.00  0.00           H  
ATOM   1005  HE1 TRP A  63      28.815   6.803  10.946  1.00  0.00           H  
ATOM   1006  HE3 TRP A  63      26.718   2.044  12.186  1.00  0.00           H  
ATOM   1007  HZ2 TRP A  63      28.874   6.271  13.717  1.00  0.00           H  
ATOM   1008  HZ3 TRP A  63      27.175   2.451  14.568  1.00  0.00           H  
ATOM   1009  HH2 TRP A  63      28.231   4.521  15.317  1.00  0.00           H  
ATOM   1010  N   VAL A  64      27.097  -0.265   9.125  1.00  0.00           N  
ATOM   1011  CA  VAL A  64      26.439  -1.525   8.797  1.00  0.00           C  
ATOM   1012  C   VAL A  64      25.476  -1.944   9.903  1.00  0.00           C  
ATOM   1013  O   VAL A  64      25.657  -1.617  11.076  1.00  0.00           O  
ATOM   1014  CB  VAL A  64      27.464  -2.651   8.570  1.00  0.00           C  
ATOM   1015  CG1 VAL A  64      28.664  -2.132   7.793  1.00  0.00           C  
ATOM   1016  CG2 VAL A  64      27.897  -3.252   9.898  1.00  0.00           C  
ATOM   1017  H   VAL A  64      27.507  -0.156  10.007  1.00  0.00           H  
ATOM   1018  HA  VAL A  64      25.881  -1.383   7.883  1.00  0.00           H  
ATOM   1019  HB  VAL A  64      26.992  -3.426   7.984  1.00  0.00           H  
ATOM   1020 HG11 VAL A  64      28.858  -2.783   6.953  1.00  0.00           H  
ATOM   1021 HG12 VAL A  64      28.458  -1.134   7.437  1.00  0.00           H  
ATOM   1022 HG13 VAL A  64      29.529  -2.113   8.439  1.00  0.00           H  
ATOM   1023 HG21 VAL A  64      28.882  -3.684   9.794  1.00  0.00           H  
ATOM   1024 HG22 VAL A  64      27.920  -2.480  10.652  1.00  0.00           H  
ATOM   1025 HG23 VAL A  64      27.197  -4.021  10.191  1.00  0.00           H  
ATOM   1026  N   PRO A  65      24.426  -2.687   9.523  1.00  0.00           N  
ATOM   1027  CA  PRO A  65      23.414  -3.170  10.467  1.00  0.00           C  
ATOM   1028  C   PRO A  65      23.959  -4.242  11.404  1.00  0.00           C  
ATOM   1029  O   PRO A  65      25.169  -4.435  11.502  1.00  0.00           O  
ATOM   1030  CB  PRO A  65      22.331  -3.754   9.557  1.00  0.00           C  
ATOM   1031  CG  PRO A  65      23.048  -4.127   8.305  1.00  0.00           C  
ATOM   1032  CD  PRO A  65      24.147  -3.115   8.142  1.00  0.00           C  
ATOM   1033  HA  PRO A  65      22.998  -2.360  11.050  1.00  0.00           H  
ATOM   1034  HB2 PRO A  65      21.886  -4.618  10.031  1.00  0.00           H  
ATOM   1035  HB3 PRO A  65      21.572  -3.009   9.370  1.00  0.00           H  
ATOM   1036  HG2 PRO A  65      23.461  -5.119   8.401  1.00  0.00           H  
ATOM   1037  HG3 PRO A  65      22.369  -4.082   7.466  1.00  0.00           H  
ATOM   1038  HD2 PRO A  65      25.018  -3.574   7.696  1.00  0.00           H  
ATOM   1039  HD3 PRO A  65      23.809  -2.283   7.541  1.00  0.00           H  
ATOM   1040  N   GLU A  66      23.057  -4.936  12.089  1.00  0.00           N  
ATOM   1041  CA  GLU A  66      23.448  -5.990  13.019  1.00  0.00           C  
ATOM   1042  C   GLU A  66      23.513  -7.341  12.314  1.00  0.00           C  
ATOM   1043  O   GLU A  66      24.058  -8.307  12.848  1.00  0.00           O  
ATOM   1044  CB  GLU A  66      22.465  -6.059  14.189  1.00  0.00           C  
ATOM   1045  CG  GLU A  66      22.918  -6.982  15.309  1.00  0.00           C  
ATOM   1046  CD  GLU A  66      21.789  -7.351  16.253  1.00  0.00           C  
ATOM   1047  OE1 GLU A  66      21.011  -8.267  15.917  1.00  0.00           O  
ATOM   1048  OE2 GLU A  66      21.685  -6.722  17.327  1.00  0.00           O  
ATOM   1049  H   GLU A  66      22.105  -4.736  11.967  1.00  0.00           H  
ATOM   1050  HA  GLU A  66      24.430  -5.748  13.397  1.00  0.00           H  
ATOM   1051  HB2 GLU A  66      22.338  -5.067  14.596  1.00  0.00           H  
ATOM   1052  HB3 GLU A  66      21.514  -6.412  13.823  1.00  0.00           H  
ATOM   1053  HG2 GLU A  66      23.314  -7.887  14.875  1.00  0.00           H  
ATOM   1054  HG3 GLU A  66      23.693  -6.485  15.875  1.00  0.00           H  
ATOM   1055  N   SER A  67      22.951  -7.402  11.110  1.00  0.00           N  
ATOM   1056  CA  SER A  67      22.940  -8.635  10.333  1.00  0.00           C  
ATOM   1057  C   SER A  67      24.168  -8.720   9.431  1.00  0.00           C  
ATOM   1058  O   SER A  67      24.540  -9.800   8.971  1.00  0.00           O  
ATOM   1059  CB  SER A  67      21.666  -8.721   9.489  1.00  0.00           C  
ATOM   1060  OG  SER A  67      21.394 -10.059   9.111  1.00  0.00           O  
ATOM   1061  H   SER A  67      22.532  -6.598  10.737  1.00  0.00           H  
ATOM   1062  HA  SER A  67      22.959  -9.464  11.026  1.00  0.00           H  
ATOM   1063  HB2 SER A  67      20.833  -8.343  10.062  1.00  0.00           H  
ATOM   1064  HB3 SER A  67      21.790  -8.124   8.596  1.00  0.00           H  
ATOM   1065  HG  SER A  67      20.597 -10.360   9.555  1.00  0.00           H  
ATOM   1066  N   ARG A  68      24.792  -7.573   9.182  1.00  0.00           N  
ATOM   1067  CA  ARG A  68      25.977  -7.516   8.335  1.00  0.00           C  
ATOM   1068  C   ARG A  68      27.241  -7.765   9.151  1.00  0.00           C  
ATOM   1069  O   ARG A  68      28.333  -7.901   8.598  1.00  0.00           O  
ATOM   1070  CB  ARG A  68      26.065  -6.158   7.636  1.00  0.00           C  
ATOM   1071  CG  ARG A  68      25.215  -6.062   6.380  1.00  0.00           C  
ATOM   1072  CD  ARG A  68      25.817  -5.094   5.373  1.00  0.00           C  
ATOM   1073  NE  ARG A  68      24.805  -4.530   4.484  1.00  0.00           N  
ATOM   1074  CZ  ARG A  68      25.006  -3.453   3.732  1.00  0.00           C  
ATOM   1075  NH1 ARG A  68      26.175  -2.828   3.761  1.00  0.00           N  
ATOM   1076  NH2 ARG A  68      24.035  -2.999   2.949  1.00  0.00           N  
ATOM   1077  H   ARG A  68      24.446  -6.745   9.578  1.00  0.00           H  
ATOM   1078  HA  ARG A  68      25.887  -8.290   7.586  1.00  0.00           H  
ATOM   1079  HB2 ARG A  68      25.740  -5.391   8.324  1.00  0.00           H  
ATOM   1080  HB3 ARG A  68      27.094  -5.974   7.365  1.00  0.00           H  
ATOM   1081  HG2 ARG A  68      25.148  -7.040   5.926  1.00  0.00           H  
ATOM   1082  HG3 ARG A  68      24.228  -5.719   6.650  1.00  0.00           H  
ATOM   1083  HD2 ARG A  68      26.300  -4.292   5.910  1.00  0.00           H  
ATOM   1084  HD3 ARG A  68      26.550  -5.622   4.781  1.00  0.00           H  
ATOM   1085  HE  ARG A  68      23.934  -4.975   4.448  1.00  0.00           H  
ATOM   1086 HH11 ARG A  68      26.908  -3.169   4.349  1.00  0.00           H  
ATOM   1087 HH12 ARG A  68      26.324  -2.020   3.193  1.00  0.00           H  
ATOM   1088 HH21 ARG A  68      23.153  -3.468   2.925  1.00  0.00           H  
ATOM   1089 HH22 ARG A  68      24.187  -2.189   2.383  1.00  0.00           H  
ATOM   1090  N   VAL A  69      27.087  -7.821  10.470  1.00  0.00           N  
ATOM   1091  CA  VAL A  69      28.216  -8.053  11.363  1.00  0.00           C  
ATOM   1092  C   VAL A  69      28.142  -9.439  11.992  1.00  0.00           C  
ATOM   1093  O   VAL A  69      27.066  -9.908  12.365  1.00  0.00           O  
ATOM   1094  CB  VAL A  69      28.274  -6.995  12.481  1.00  0.00           C  
ATOM   1095  CG1 VAL A  69      29.611  -7.055  13.204  1.00  0.00           C  
ATOM   1096  CG2 VAL A  69      28.027  -5.606  11.912  1.00  0.00           C  
ATOM   1097  H   VAL A  69      26.191  -7.704  10.852  1.00  0.00           H  
ATOM   1098  HA  VAL A  69      29.123  -7.981  10.780  1.00  0.00           H  
ATOM   1099  HB  VAL A  69      27.494  -7.213  13.195  1.00  0.00           H  
ATOM   1100 HG11 VAL A  69      29.632  -6.306  13.981  1.00  0.00           H  
ATOM   1101 HG12 VAL A  69      29.741  -8.034  13.640  1.00  0.00           H  
ATOM   1102 HG13 VAL A  69      30.409  -6.865  12.500  1.00  0.00           H  
ATOM   1103 HG21 VAL A  69      27.057  -5.577  11.439  1.00  0.00           H  
ATOM   1104 HG22 VAL A  69      28.061  -4.880  12.711  1.00  0.00           H  
ATOM   1105 HG23 VAL A  69      28.791  -5.374  11.183  1.00  0.00           H  
ATOM   1106  N   LEU A  70      29.293 -10.092  12.110  1.00  0.00           N  
ATOM   1107  CA  LEU A  70      29.361 -11.426  12.696  1.00  0.00           C  
ATOM   1108  C   LEU A  70      30.071 -11.393  14.046  1.00  0.00           C  
ATOM   1109  O   LEU A  70      30.761 -10.426  14.373  1.00  0.00           O  
ATOM   1110  CB  LEU A  70      30.083 -12.385  11.750  1.00  0.00           C  
ATOM   1111  CG  LEU A  70      29.625 -12.359  10.291  1.00  0.00           C  
ATOM   1112  CD1 LEU A  70      30.420 -13.359   9.464  1.00  0.00           C  
ATOM   1113  CD2 LEU A  70      28.135 -12.653  10.195  1.00  0.00           C  
ATOM   1114  H   LEU A  70      30.118  -9.667  11.796  1.00  0.00           H  
ATOM   1115  HA  LEU A  70      28.349 -11.774  12.845  1.00  0.00           H  
ATOM   1116  HB2 LEU A  70      31.134 -12.141  11.770  1.00  0.00           H  
ATOM   1117  HB3 LEU A  70      29.942 -13.389  12.125  1.00  0.00           H  
ATOM   1118  HG  LEU A  70      29.801 -11.374   9.882  1.00  0.00           H  
ATOM   1119 HD11 LEU A  70      30.057 -14.357   9.660  1.00  0.00           H  
ATOM   1120 HD12 LEU A  70      31.465 -13.297   9.732  1.00  0.00           H  
ATOM   1121 HD13 LEU A  70      30.303 -13.132   8.415  1.00  0.00           H  
ATOM   1122 HD21 LEU A  70      27.963 -13.705  10.358  1.00  0.00           H  
ATOM   1123 HD22 LEU A  70      27.776 -12.376   9.214  1.00  0.00           H  
ATOM   1124 HD23 LEU A  70      27.607 -12.080  10.945  1.00  0.00           H  
ATOM   1125  N   LYS A  71      29.902 -12.455  14.825  1.00  0.00           N  
ATOM   1126  CA  LYS A  71      30.530 -12.550  16.137  1.00  0.00           C  
ATOM   1127  C   LYS A  71      31.975 -13.023  16.015  1.00  0.00           C  
ATOM   1128  O   LYS A  71      32.629 -13.317  17.017  1.00  0.00           O  
ATOM   1129  CB  LYS A  71      29.742 -13.509  17.033  1.00  0.00           C  
ATOM   1130  CG  LYS A  71      28.384 -12.973  17.452  1.00  0.00           C  
ATOM   1131  CD  LYS A  71      27.413 -12.941  16.284  1.00  0.00           C  
ATOM   1132  CE  LYS A  71      26.025 -12.503  16.725  1.00  0.00           C  
ATOM   1133  NZ  LYS A  71      26.076 -11.306  17.609  1.00  0.00           N  
ATOM   1134  H   LYS A  71      29.341 -13.195  14.508  1.00  0.00           H  
ATOM   1135  HA  LYS A  71      30.522 -11.567  16.581  1.00  0.00           H  
ATOM   1136  HB2 LYS A  71      29.592 -14.438  16.503  1.00  0.00           H  
ATOM   1137  HB3 LYS A  71      30.320 -13.704  17.926  1.00  0.00           H  
ATOM   1138  HG2 LYS A  71      27.980 -13.607  18.226  1.00  0.00           H  
ATOM   1139  HG3 LYS A  71      28.507 -11.969  17.835  1.00  0.00           H  
ATOM   1140  HD2 LYS A  71      27.779 -12.246  15.542  1.00  0.00           H  
ATOM   1141  HD3 LYS A  71      27.350 -13.930  15.853  1.00  0.00           H  
ATOM   1142  HE2 LYS A  71      25.440 -12.269  15.850  1.00  0.00           H  
ATOM   1143  HE3 LYS A  71      25.560 -13.317  17.261  1.00  0.00           H  
ATOM   1144  HZ1 LYS A  71      26.994 -10.828  17.512  1.00  0.00           H  
ATOM   1145  HZ2 LYS A  71      25.947 -11.589  18.601  1.00  0.00           H  
ATOM   1146  HZ3 LYS A  71      25.321 -10.639  17.351  1.00  0.00           H  
ATOM   1147  N   TYR A  72      32.468 -13.095  14.784  1.00  0.00           N  
ATOM   1148  CA  TYR A  72      33.836 -13.533  14.531  1.00  0.00           C  
ATOM   1149  C   TYR A  72      34.127 -14.848  15.248  1.00  0.00           C  
ATOM   1150  O   TYR A  72      35.203 -15.033  15.817  1.00  0.00           O  
ATOM   1151  CB  TYR A  72      34.829 -12.461  14.985  1.00  0.00           C  
ATOM   1152  CG  TYR A  72      36.108 -12.440  14.179  1.00  0.00           C  
ATOM   1153  CD1 TYR A  72      37.165 -13.285  14.496  1.00  0.00           C  
ATOM   1154  CD2 TYR A  72      36.260 -11.577  13.102  1.00  0.00           C  
ATOM   1155  CE1 TYR A  72      38.336 -13.269  13.763  1.00  0.00           C  
ATOM   1156  CE2 TYR A  72      37.427 -11.556  12.362  1.00  0.00           C  
ATOM   1157  CZ  TYR A  72      38.462 -12.404  12.697  1.00  0.00           C  
ATOM   1158  OH  TYR A  72      39.626 -12.384  11.964  1.00  0.00           O  
ATOM   1159  H   TYR A  72      31.899 -12.848  14.025  1.00  0.00           H  
ATOM   1160  HA  TYR A  72      33.945 -13.683  13.468  1.00  0.00           H  
ATOM   1161  HB2 TYR A  72      34.366 -11.490  14.896  1.00  0.00           H  
ATOM   1162  HB3 TYR A  72      35.090 -12.636  16.019  1.00  0.00           H  
ATOM   1163  HD1 TYR A  72      37.063 -13.962  15.332  1.00  0.00           H  
ATOM   1164  HD2 TYR A  72      35.447 -10.914  12.843  1.00  0.00           H  
ATOM   1165  HE1 TYR A  72      39.146 -13.933  14.025  1.00  0.00           H  
ATOM   1166  HE2 TYR A  72      37.525 -10.877  11.528  1.00  0.00           H  
ATOM   1167  HH  TYR A  72      39.795 -11.491  11.655  1.00  0.00           H  
ATOM   1168  N   VAL A  73      33.161 -15.759  15.215  1.00  0.00           N  
ATOM   1169  CA  VAL A  73      33.312 -17.058  15.858  1.00  0.00           C  
ATOM   1170  C   VAL A  73      33.598 -18.150  14.834  1.00  0.00           C  
ATOM   1171  O   VAL A  73      33.359 -17.971  13.639  1.00  0.00           O  
ATOM   1172  CB  VAL A  73      32.053 -17.438  16.660  1.00  0.00           C  
ATOM   1173  CG1 VAL A  73      31.852 -16.481  17.825  1.00  0.00           C  
ATOM   1174  CG2 VAL A  73      30.830 -17.452  15.755  1.00  0.00           C  
ATOM   1175  H   VAL A  73      32.325 -15.553  14.746  1.00  0.00           H  
ATOM   1176  HA  VAL A  73      34.144 -16.996  16.545  1.00  0.00           H  
ATOM   1177  HB  VAL A  73      32.191 -18.433  17.059  1.00  0.00           H  
ATOM   1178 HG11 VAL A  73      32.550 -15.661  17.742  1.00  0.00           H  
ATOM   1179 HG12 VAL A  73      30.842 -16.099  17.808  1.00  0.00           H  
ATOM   1180 HG13 VAL A  73      32.024 -17.005  18.754  1.00  0.00           H  
ATOM   1181 HG21 VAL A  73      31.145 -17.525  14.725  1.00  0.00           H  
ATOM   1182 HG22 VAL A  73      30.209 -18.301  16.003  1.00  0.00           H  
ATOM   1183 HG23 VAL A  73      30.267 -16.541  15.896  1.00  0.00           H  
ATOM   1184  N   ASP A  74      34.108 -19.281  15.308  1.00  0.00           N  
ATOM   1185  CA  ASP A  74      34.425 -20.403  14.432  1.00  0.00           C  
ATOM   1186  C   ASP A  74      33.425 -20.495  13.283  1.00  0.00           C  
ATOM   1187  O   ASP A  74      33.795 -20.380  12.114  1.00  0.00           O  
ATOM   1188  CB  ASP A  74      34.429 -21.711  15.226  1.00  0.00           C  
ATOM   1189  CG  ASP A  74      34.932 -21.526  16.644  1.00  0.00           C  
ATOM   1190  OD1 ASP A  74      35.869 -20.723  16.841  1.00  0.00           O  
ATOM   1191  OD2 ASP A  74      34.390 -22.184  17.558  1.00  0.00           O  
ATOM   1192  H   ASP A  74      34.275 -19.363  16.270  1.00  0.00           H  
ATOM   1193  HA  ASP A  74      35.410 -20.237  14.024  1.00  0.00           H  
ATOM   1194  HB2 ASP A  74      33.423 -22.103  15.269  1.00  0.00           H  
ATOM   1195  HB3 ASP A  74      35.068 -22.425  14.727  1.00  0.00           H  
ATOM   1196  N   THR A  75      32.157 -20.704  13.624  1.00  0.00           N  
ATOM   1197  CA  THR A  75      31.105 -20.814  12.622  1.00  0.00           C  
ATOM   1198  C   THR A  75      31.242 -19.727  11.560  1.00  0.00           C  
ATOM   1199  O   THR A  75      31.387 -20.020  10.374  1.00  0.00           O  
ATOM   1200  CB  THR A  75      29.707 -20.717  13.261  1.00  0.00           C  
ATOM   1201  OG1 THR A  75      29.623 -21.596  14.389  1.00  0.00           O  
ATOM   1202  CG2 THR A  75      28.625 -21.073  12.253  1.00  0.00           C  
ATOM   1203  H   THR A  75      31.925 -20.786  14.573  1.00  0.00           H  
ATOM   1204  HA  THR A  75      31.195 -21.780  12.147  1.00  0.00           H  
ATOM   1205  HB  THR A  75      29.549 -19.701  13.594  1.00  0.00           H  
ATOM   1206  HG1 THR A  75      30.116 -22.400  14.206  1.00  0.00           H  
ATOM   1207 HG21 THR A  75      27.943 -21.783  12.694  1.00  0.00           H  
ATOM   1208 HG22 THR A  75      29.080 -21.507  11.375  1.00  0.00           H  
ATOM   1209 HG23 THR A  75      28.085 -20.180  11.975  1.00  0.00           H  
ATOM   1210  N   ASN A  76      31.193 -18.473  11.995  1.00  0.00           N  
ATOM   1211  CA  ASN A  76      31.312 -17.341  11.081  1.00  0.00           C  
ATOM   1212  C   ASN A  76      32.590 -17.443  10.254  1.00  0.00           C  
ATOM   1213  O   ASN A  76      32.587 -17.172   9.052  1.00  0.00           O  
ATOM   1214  CB  ASN A  76      31.298 -16.025  11.861  1.00  0.00           C  
ATOM   1215  CG  ASN A  76      29.936 -15.718  12.453  1.00  0.00           C  
ATOM   1216  OD1 ASN A  76      28.904 -16.013  11.850  1.00  0.00           O  
ATOM   1217  ND2 ASN A  76      29.928 -15.120  13.639  1.00  0.00           N  
ATOM   1218  H   ASN A  76      31.074 -18.302  12.952  1.00  0.00           H  
ATOM   1219  HA  ASN A  76      30.462 -17.364  10.415  1.00  0.00           H  
ATOM   1220  HB2 ASN A  76      32.014 -16.084  12.667  1.00  0.00           H  
ATOM   1221  HB3 ASN A  76      31.574 -15.218  11.199  1.00  0.00           H  
ATOM   1222 HD21 ASN A  76      30.788 -14.915  14.060  1.00  0.00           H  
ATOM   1223 HD22 ASN A  76      29.060 -14.910  14.044  1.00  0.00           H  
ATOM   1224  N   LEU A  77      33.680 -17.834  10.904  1.00  0.00           N  
ATOM   1225  CA  LEU A  77      34.965 -17.972  10.230  1.00  0.00           C  
ATOM   1226  C   LEU A  77      34.871 -18.966   9.075  1.00  0.00           C  
ATOM   1227  O   LEU A  77      35.380 -18.713   7.984  1.00  0.00           O  
ATOM   1228  CB  LEU A  77      36.038 -18.425  11.221  1.00  0.00           C  
ATOM   1229  CG  LEU A  77      36.428 -17.412  12.298  1.00  0.00           C  
ATOM   1230  CD1 LEU A  77      37.359 -18.049  13.318  1.00  0.00           C  
ATOM   1231  CD2 LEU A  77      37.080 -16.190  11.668  1.00  0.00           C  
ATOM   1232  H   LEU A  77      33.619 -18.036  11.861  1.00  0.00           H  
ATOM   1233  HA  LEU A  77      35.237 -17.005   9.834  1.00  0.00           H  
ATOM   1234  HB2 LEU A  77      35.676 -19.312  11.718  1.00  0.00           H  
ATOM   1235  HB3 LEU A  77      36.927 -18.669  10.656  1.00  0.00           H  
ATOM   1236  HG  LEU A  77      35.536 -17.087  12.817  1.00  0.00           H  
ATOM   1237 HD11 LEU A  77      36.861 -18.883  13.787  1.00  0.00           H  
ATOM   1238 HD12 LEU A  77      37.624 -17.319  14.067  1.00  0.00           H  
ATOM   1239 HD13 LEU A  77      38.254 -18.395  12.821  1.00  0.00           H  
ATOM   1240 HD21 LEU A  77      38.145 -16.216  11.849  1.00  0.00           H  
ATOM   1241 HD22 LEU A  77      36.661 -15.294  12.104  1.00  0.00           H  
ATOM   1242 HD23 LEU A  77      36.895 -16.192  10.603  1.00  0.00           H  
ATOM   1243  N   GLN A  78      34.214 -20.094   9.325  1.00  0.00           N  
ATOM   1244  CA  GLN A  78      34.052 -21.123   8.306  1.00  0.00           C  
ATOM   1245  C   GLN A  78      33.698 -20.505   6.957  1.00  0.00           C  
ATOM   1246  O   GLN A  78      34.152 -20.967   5.911  1.00  0.00           O  
ATOM   1247  CB  GLN A  78      32.968 -22.119   8.724  1.00  0.00           C  
ATOM   1248  CG  GLN A  78      33.220 -22.761  10.079  1.00  0.00           C  
ATOM   1249  CD  GLN A  78      34.007 -24.053   9.974  1.00  0.00           C  
ATOM   1250  OE1 GLN A  78      35.005 -24.129   9.258  1.00  0.00           O  
ATOM   1251  NE2 GLN A  78      33.559 -25.078  10.690  1.00  0.00           N  
ATOM   1252  H   GLN A  78      33.830 -20.237  10.215  1.00  0.00           H  
ATOM   1253  HA  GLN A  78      34.991 -21.648   8.212  1.00  0.00           H  
ATOM   1254  HB2 GLN A  78      32.019 -21.603   8.766  1.00  0.00           H  
ATOM   1255  HB3 GLN A  78      32.910 -22.903   7.983  1.00  0.00           H  
ATOM   1256  HG2 GLN A  78      33.777 -22.068  10.693  1.00  0.00           H  
ATOM   1257  HG3 GLN A  78      32.270 -22.971  10.546  1.00  0.00           H  
ATOM   1258 HE21 GLN A  78      32.757 -24.944  11.237  1.00  0.00           H  
ATOM   1259 HE22 GLN A  78      34.048 -25.925  10.640  1.00  0.00           H  
ATOM   1260  N   LYS A  79      32.883 -19.455   6.990  1.00  0.00           N  
ATOM   1261  CA  LYS A  79      32.467 -18.771   5.771  1.00  0.00           C  
ATOM   1262  C   LYS A  79      33.525 -17.768   5.323  1.00  0.00           C  
ATOM   1263  O   LYS A  79      34.151 -17.938   4.278  1.00  0.00           O  
ATOM   1264  CB  LYS A  79      31.132 -18.057   5.992  1.00  0.00           C  
ATOM   1265  CG  LYS A  79      30.686 -17.220   4.806  1.00  0.00           C  
ATOM   1266  CD  LYS A  79      29.375 -16.506   5.089  1.00  0.00           C  
ATOM   1267  CE  LYS A  79      28.576 -16.282   3.814  1.00  0.00           C  
ATOM   1268  NZ  LYS A  79      28.053 -17.559   3.256  1.00  0.00           N  
ATOM   1269  H   LYS A  79      32.553 -19.133   7.855  1.00  0.00           H  
ATOM   1270  HA  LYS A  79      32.345 -19.516   4.998  1.00  0.00           H  
ATOM   1271  HB2 LYS A  79      30.370 -18.797   6.191  1.00  0.00           H  
ATOM   1272  HB3 LYS A  79      31.223 -17.407   6.850  1.00  0.00           H  
ATOM   1273  HG2 LYS A  79      31.446 -16.483   4.591  1.00  0.00           H  
ATOM   1274  HG3 LYS A  79      30.557 -17.866   3.950  1.00  0.00           H  
ATOM   1275  HD2 LYS A  79      28.787 -17.106   5.768  1.00  0.00           H  
ATOM   1276  HD3 LYS A  79      29.587 -15.549   5.544  1.00  0.00           H  
ATOM   1277  HE2 LYS A  79      27.746 -15.628   4.035  1.00  0.00           H  
ATOM   1278  HE3 LYS A  79      29.217 -15.814   3.081  1.00  0.00           H  
ATOM   1279  HZ1 LYS A  79      27.678 -18.156   4.020  1.00  0.00           H  
ATOM   1280  HZ2 LYS A  79      28.814 -18.074   2.768  1.00  0.00           H  
ATOM   1281  HZ3 LYS A  79      27.290 -17.366   2.576  1.00  0.00           H  
ATOM   1282  N   GLN A  80      33.719 -16.723   6.122  1.00  0.00           N  
ATOM   1283  CA  GLN A  80      34.700 -15.693   5.807  1.00  0.00           C  
ATOM   1284  C   GLN A  80      35.903 -16.290   5.083  1.00  0.00           C  
ATOM   1285  O   GLN A  80      36.485 -15.659   4.200  1.00  0.00           O  
ATOM   1286  CB  GLN A  80      35.159 -14.987   7.084  1.00  0.00           C  
ATOM   1287  CG  GLN A  80      36.325 -14.036   6.869  1.00  0.00           C  
ATOM   1288  CD  GLN A  80      37.172 -13.861   8.114  1.00  0.00           C  
ATOM   1289  OE1 GLN A  80      36.938 -14.509   9.135  1.00  0.00           O  
ATOM   1290  NE2 GLN A  80      38.166 -12.982   8.036  1.00  0.00           N  
ATOM   1291  H   GLN A  80      33.188 -16.643   6.941  1.00  0.00           H  
ATOM   1292  HA  GLN A  80      34.228 -14.971   5.158  1.00  0.00           H  
ATOM   1293  HB2 GLN A  80      34.331 -14.424   7.487  1.00  0.00           H  
ATOM   1294  HB3 GLN A  80      35.460 -15.733   7.805  1.00  0.00           H  
ATOM   1295  HG2 GLN A  80      36.950 -14.424   6.079  1.00  0.00           H  
ATOM   1296  HG3 GLN A  80      35.936 -13.071   6.578  1.00  0.00           H  
ATOM   1297 HE21 GLN A  80      38.292 -12.502   7.190  1.00  0.00           H  
ATOM   1298 HE22 GLN A  80      38.728 -12.849   8.825  1.00  0.00           H  
ATOM   1299  N   ARG A  81      36.270 -17.509   5.463  1.00  0.00           N  
ATOM   1300  CA  ARG A  81      37.404 -18.192   4.851  1.00  0.00           C  
ATOM   1301  C   ARG A  81      37.003 -18.830   3.523  1.00  0.00           C  
ATOM   1302  O   ARG A  81      37.708 -18.700   2.524  1.00  0.00           O  
ATOM   1303  CB  ARG A  81      37.955 -19.260   5.797  1.00  0.00           C  
ATOM   1304  CG  ARG A  81      37.020 -20.442   5.992  1.00  0.00           C  
ATOM   1305  CD  ARG A  81      37.630 -21.490   6.909  1.00  0.00           C  
ATOM   1306  NE  ARG A  81      38.917 -21.970   6.411  1.00  0.00           N  
ATOM   1307  CZ  ARG A  81      39.612 -22.944   6.988  1.00  0.00           C  
ATOM   1308  NH1 ARG A  81      39.146 -23.538   8.078  1.00  0.00           N  
ATOM   1309  NH2 ARG A  81      40.775 -23.325   6.476  1.00  0.00           N  
ATOM   1310  H   ARG A  81      35.767 -17.962   6.172  1.00  0.00           H  
ATOM   1311  HA  ARG A  81      38.173 -17.456   4.666  1.00  0.00           H  
ATOM   1312  HB2 ARG A  81      38.889 -19.630   5.399  1.00  0.00           H  
ATOM   1313  HB3 ARG A  81      38.138 -18.811   6.761  1.00  0.00           H  
ATOM   1314  HG2 ARG A  81      36.097 -20.091   6.430  1.00  0.00           H  
ATOM   1315  HG3 ARG A  81      36.817 -20.891   5.031  1.00  0.00           H  
ATOM   1316  HD2 ARG A  81      37.773 -21.055   7.887  1.00  0.00           H  
ATOM   1317  HD3 ARG A  81      36.950 -22.325   6.982  1.00  0.00           H  
ATOM   1318  HE  ARG A  81      39.280 -21.544   5.606  1.00  0.00           H  
ATOM   1319 HH11 ARG A  81      38.269 -23.255   8.466  1.00  0.00           H  
ATOM   1320 HH12 ARG A  81      39.670 -24.273   8.510  1.00  0.00           H  
ATOM   1321 HH21 ARG A  81      41.129 -22.878   5.654  1.00  0.00           H  
ATOM   1322 HH22 ARG A  81      41.297 -24.057   6.912  1.00  0.00           H  
ATOM   1323  N   GLU A  82      35.867 -19.519   3.525  1.00  0.00           N  
ATOM   1324  CA  GLU A  82      35.373 -20.179   2.321  1.00  0.00           C  
ATOM   1325  C   GLU A  82      35.288 -19.194   1.157  1.00  0.00           C  
ATOM   1326  O   GLU A  82      35.545 -19.551   0.006  1.00  0.00           O  
ATOM   1327  CB  GLU A  82      34.000 -20.800   2.579  1.00  0.00           C  
ATOM   1328  CG  GLU A  82      32.840 -19.887   2.218  1.00  0.00           C  
ATOM   1329  CD  GLU A  82      31.491 -20.523   2.487  1.00  0.00           C  
ATOM   1330  OE1 GLU A  82      31.373 -21.756   2.323  1.00  0.00           O  
ATOM   1331  OE2 GLU A  82      30.552 -19.790   2.862  1.00  0.00           O  
ATOM   1332  H   GLU A  82      35.348 -19.586   4.353  1.00  0.00           H  
ATOM   1333  HA  GLU A  82      36.069 -20.962   2.062  1.00  0.00           H  
ATOM   1334  HB2 GLU A  82      33.913 -21.707   1.998  1.00  0.00           H  
ATOM   1335  HB3 GLU A  82      33.922 -21.048   3.628  1.00  0.00           H  
ATOM   1336  HG2 GLU A  82      32.917 -18.981   2.801  1.00  0.00           H  
ATOM   1337  HG3 GLU A  82      32.904 -19.644   1.167  1.00  0.00           H  
ATOM   1338  N   LEU A  83      34.924 -17.954   1.465  1.00  0.00           N  
ATOM   1339  CA  LEU A  83      34.803 -16.917   0.447  1.00  0.00           C  
ATOM   1340  C   LEU A  83      36.173 -16.366   0.066  1.00  0.00           C  
ATOM   1341  O   LEU A  83      36.523 -16.308  -1.113  1.00  0.00           O  
ATOM   1342  CB  LEU A  83      33.907 -15.784   0.949  1.00  0.00           C  
ATOM   1343  CG  LEU A  83      32.663 -16.208   1.730  1.00  0.00           C  
ATOM   1344  CD1 LEU A  83      32.106 -15.036   2.524  1.00  0.00           C  
ATOM   1345  CD2 LEU A  83      31.606 -16.768   0.789  1.00  0.00           C  
ATOM   1346  H   LEU A  83      34.732 -17.730   2.400  1.00  0.00           H  
ATOM   1347  HA  LEU A  83      34.351 -17.362  -0.428  1.00  0.00           H  
ATOM   1348  HB2 LEU A  83      34.501 -15.151   1.591  1.00  0.00           H  
ATOM   1349  HB3 LEU A  83      33.580 -15.216   0.089  1.00  0.00           H  
ATOM   1350  HG  LEU A  83      32.934 -16.986   2.431  1.00  0.00           H  
ATOM   1351 HD11 LEU A  83      32.535 -15.035   3.514  1.00  0.00           H  
ATOM   1352 HD12 LEU A  83      31.032 -15.129   2.597  1.00  0.00           H  
ATOM   1353 HD13 LEU A  83      32.353 -14.112   2.022  1.00  0.00           H  
ATOM   1354 HD21 LEU A  83      31.568 -17.842   0.890  1.00  0.00           H  
ATOM   1355 HD22 LEU A  83      31.859 -16.510  -0.229  1.00  0.00           H  
ATOM   1356 HD23 LEU A  83      30.643 -16.347   1.039  1.00  0.00           H  
ATOM   1357  N   GLN A  84      36.945 -15.965   1.070  1.00  0.00           N  
ATOM   1358  CA  GLN A  84      38.277 -15.420   0.840  1.00  0.00           C  
ATOM   1359  C   GLN A  84      39.116 -16.372  -0.006  1.00  0.00           C  
ATOM   1360  O   GLN A  84      40.002 -15.947  -0.747  1.00  0.00           O  
ATOM   1361  CB  GLN A  84      38.979 -15.150   2.172  1.00  0.00           C  
ATOM   1362  CG  GLN A  84      38.607 -13.814   2.796  1.00  0.00           C  
ATOM   1363  CD  GLN A  84      39.454 -13.480   4.007  1.00  0.00           C  
ATOM   1364  OE1 GLN A  84      40.620 -13.868   4.091  1.00  0.00           O  
ATOM   1365  NE2 GLN A  84      38.872 -12.754   4.955  1.00  0.00           N  
ATOM   1366  H   GLN A  84      36.609 -16.035   1.988  1.00  0.00           H  
ATOM   1367  HA  GLN A  84      38.166 -14.488   0.307  1.00  0.00           H  
ATOM   1368  HB2 GLN A  84      38.717 -15.933   2.868  1.00  0.00           H  
ATOM   1369  HB3 GLN A  84      40.046 -15.163   2.012  1.00  0.00           H  
ATOM   1370  HG2 GLN A  84      38.739 -13.037   2.058  1.00  0.00           H  
ATOM   1371  HG3 GLN A  84      37.570 -13.848   3.097  1.00  0.00           H  
ATOM   1372 HE21 GLN A  84      37.939 -12.481   4.821  1.00  0.00           H  
ATOM   1373 HE22 GLN A  84      39.396 -12.524   5.749  1.00  0.00           H  
ATOM   1374  N   LYS A  85      38.831 -17.666   0.111  1.00  0.00           N  
ATOM   1375  CA  LYS A  85      39.558 -18.680  -0.644  1.00  0.00           C  
ATOM   1376  C   LYS A  85      38.822 -19.032  -1.932  1.00  0.00           C  
ATOM   1377  O   LYS A  85      39.444 -19.329  -2.951  1.00  0.00           O  
ATOM   1378  CB  LYS A  85      39.748 -19.937   0.208  1.00  0.00           C  
ATOM   1379  CG  LYS A  85      38.516 -20.823   0.269  1.00  0.00           C  
ATOM   1380  CD  LYS A  85      38.822 -22.161   0.920  1.00  0.00           C  
ATOM   1381  CE  LYS A  85      39.295 -23.184  -0.103  1.00  0.00           C  
ATOM   1382  NZ  LYS A  85      40.747 -23.041  -0.400  1.00  0.00           N  
ATOM   1383  H   LYS A  85      38.114 -17.944   0.719  1.00  0.00           H  
ATOM   1384  HA  LYS A  85      40.527 -18.276  -0.894  1.00  0.00           H  
ATOM   1385  HB2 LYS A  85      40.562 -20.517  -0.204  1.00  0.00           H  
ATOM   1386  HB3 LYS A  85      40.003 -19.641   1.215  1.00  0.00           H  
ATOM   1387  HG2 LYS A  85      37.752 -20.322   0.845  1.00  0.00           H  
ATOM   1388  HG3 LYS A  85      38.158 -20.995  -0.736  1.00  0.00           H  
ATOM   1389  HD2 LYS A  85      39.599 -22.024   1.658  1.00  0.00           H  
ATOM   1390  HD3 LYS A  85      37.928 -22.532   1.399  1.00  0.00           H  
ATOM   1391  HE2 LYS A  85      39.110 -24.173   0.284  1.00  0.00           H  
ATOM   1392  HE3 LYS A  85      38.734 -23.045  -1.016  1.00  0.00           H  
ATOM   1393  HZ1 LYS A  85      41.185 -22.379   0.271  1.00  0.00           H  
ATOM   1394  HZ2 LYS A  85      40.880 -22.679  -1.366  1.00  0.00           H  
ATOM   1395  HZ3 LYS A  85      41.220 -23.964  -0.319  1.00  0.00           H  
ATOM   1396  N   ALA A  86      37.495 -18.993  -1.879  1.00  0.00           N  
ATOM   1397  CA  ALA A  86      36.674 -19.305  -3.043  1.00  0.00           C  
ATOM   1398  C   ALA A  86      37.032 -18.407  -4.222  1.00  0.00           C  
ATOM   1399  O   ALA A  86      37.122 -18.867  -5.360  1.00  0.00           O  
ATOM   1400  CB  ALA A  86      35.198 -19.168  -2.701  1.00  0.00           C  
ATOM   1401  H   ALA A  86      37.056 -18.749  -1.037  1.00  0.00           H  
ATOM   1402  HA  ALA A  86      36.861 -20.334  -3.317  1.00  0.00           H  
ATOM   1403  HB1 ALA A  86      34.631 -19.019  -3.607  1.00  0.00           H  
ATOM   1404  HB2 ALA A  86      34.859 -20.067  -2.206  1.00  0.00           H  
ATOM   1405  HB3 ALA A  86      35.059 -18.321  -2.045  1.00  0.00           H  
ATOM   1406  N   ASN A  87      37.232 -17.123  -3.943  1.00  0.00           N  
ATOM   1407  CA  ASN A  87      37.579 -16.160  -4.982  1.00  0.00           C  
ATOM   1408  C   ASN A  87      38.794 -15.333  -4.574  1.00  0.00           C  
ATOM   1409  O   ASN A  87      38.673 -14.358  -3.834  1.00  0.00           O  
ATOM   1410  CB  ASN A  87      36.393 -15.237  -5.266  1.00  0.00           C  
ATOM   1411  CG  ASN A  87      35.061 -15.950  -5.136  1.00  0.00           C  
ATOM   1412  OD1 ASN A  87      34.577 -16.564  -6.088  1.00  0.00           O  
ATOM   1413  ND2 ASN A  87      34.461 -15.871  -3.954  1.00  0.00           N  
ATOM   1414  H   ASN A  87      37.146 -16.816  -3.016  1.00  0.00           H  
ATOM   1415  HA  ASN A  87      37.818 -16.712  -5.879  1.00  0.00           H  
ATOM   1416  HB2 ASN A  87      36.409 -14.414  -4.566  1.00  0.00           H  
ATOM   1417  HB3 ASN A  87      36.477 -14.851  -6.271  1.00  0.00           H  
ATOM   1418 HD21 ASN A  87      34.905 -15.365  -3.243  1.00  0.00           H  
ATOM   1419 HD22 ASN A  87      33.599 -16.324  -3.842  1.00  0.00           H  
ATOM   1420  N   GLN A  88      39.965 -15.731  -5.063  1.00  0.00           N  
ATOM   1421  CA  GLN A  88      41.202 -15.026  -4.749  1.00  0.00           C  
ATOM   1422  C   GLN A  88      41.359 -13.786  -5.622  1.00  0.00           C  
ATOM   1423  O   GLN A  88      41.379 -12.663  -5.122  1.00  0.00           O  
ATOM   1424  CB  GLN A  88      42.404 -15.954  -4.937  1.00  0.00           C  
ATOM   1425  CG  GLN A  88      42.455 -17.095  -3.935  1.00  0.00           C  
ATOM   1426  CD  GLN A  88      41.635 -18.293  -4.371  1.00  0.00           C  
ATOM   1427  OE1 GLN A  88      40.632 -18.151  -5.073  1.00  0.00           O  
ATOM   1428  NE2 GLN A  88      42.057 -19.483  -3.958  1.00  0.00           N  
ATOM   1429  H   GLN A  88      39.997 -16.516  -5.647  1.00  0.00           H  
ATOM   1430  HA  GLN A  88      41.156 -14.719  -3.715  1.00  0.00           H  
ATOM   1431  HB2 GLN A  88      42.365 -16.377  -5.930  1.00  0.00           H  
ATOM   1432  HB3 GLN A  88      43.310 -15.375  -4.837  1.00  0.00           H  
ATOM   1433  HG2 GLN A  88      43.482 -17.407  -3.816  1.00  0.00           H  
ATOM   1434  HG3 GLN A  88      42.074 -16.742  -2.988  1.00  0.00           H  
ATOM   1435 HE21 GLN A  88      42.863 -19.520  -3.401  1.00  0.00           H  
ATOM   1436 HE22 GLN A  88      41.545 -20.274  -4.225  1.00  0.00           H  
ATOM   1437  N   GLU A  89      41.472 -14.000  -6.929  1.00  0.00           N  
ATOM   1438  CA  GLU A  89      41.629 -12.899  -7.872  1.00  0.00           C  
ATOM   1439  C   GLU A  89      40.718 -11.732  -7.502  1.00  0.00           C  
ATOM   1440  O   GLU A  89      41.190 -10.655  -7.140  1.00  0.00           O  
ATOM   1441  CB  GLU A  89      41.321 -13.368  -9.295  1.00  0.00           C  
ATOM   1442  CG  GLU A  89      42.494 -14.054  -9.977  1.00  0.00           C  
ATOM   1443  CD  GLU A  89      42.211 -14.385 -11.429  1.00  0.00           C  
ATOM   1444  OE1 GLU A  89      41.639 -15.464 -11.692  1.00  0.00           O  
ATOM   1445  OE2 GLU A  89      42.563 -13.566 -12.303  1.00  0.00           O  
ATOM   1446  H   GLU A  89      41.450 -14.920  -7.268  1.00  0.00           H  
ATOM   1447  HA  GLU A  89      42.655 -12.567  -7.827  1.00  0.00           H  
ATOM   1448  HB2 GLU A  89      40.494 -14.062  -9.262  1.00  0.00           H  
ATOM   1449  HB3 GLU A  89      41.037 -12.513  -9.890  1.00  0.00           H  
ATOM   1450  HG2 GLU A  89      43.351 -13.399  -9.933  1.00  0.00           H  
ATOM   1451  HG3 GLU A  89      42.714 -14.970  -9.449  1.00  0.00           H  
ATOM   1452  N   GLN A  90      39.411 -11.955  -7.597  1.00  0.00           N  
ATOM   1453  CA  GLN A  90      38.435 -10.922  -7.273  1.00  0.00           C  
ATOM   1454  C   GLN A  90      38.846 -10.158  -6.019  1.00  0.00           C  
ATOM   1455  O   GLN A  90      38.915  -8.929  -6.024  1.00  0.00           O  
ATOM   1456  CB  GLN A  90      37.051 -11.544  -7.075  1.00  0.00           C  
ATOM   1457  CG  GLN A  90      36.279 -11.736  -8.371  1.00  0.00           C  
ATOM   1458  CD  GLN A  90      35.067 -12.630  -8.201  1.00  0.00           C  
ATOM   1459  OE1 GLN A  90      35.175 -13.755  -7.711  1.00  0.00           O  
ATOM   1460  NE2 GLN A  90      33.904 -12.136  -8.608  1.00  0.00           N  
ATOM   1461  H   GLN A  90      39.097 -12.835  -7.892  1.00  0.00           H  
ATOM   1462  HA  GLN A  90      38.395 -10.233  -8.103  1.00  0.00           H  
ATOM   1463  HB2 GLN A  90      37.166 -12.508  -6.604  1.00  0.00           H  
ATOM   1464  HB3 GLN A  90      36.471 -10.902  -6.429  1.00  0.00           H  
ATOM   1465  HG2 GLN A  90      35.948 -10.771  -8.725  1.00  0.00           H  
ATOM   1466  HG3 GLN A  90      36.937 -12.180  -9.104  1.00  0.00           H  
ATOM   1467 HE21 GLN A  90      33.895 -11.233  -8.991  1.00  0.00           H  
ATOM   1468 HE22 GLN A  90      33.105 -12.692  -8.511  1.00  0.00           H  
ATOM   1469  N   TYR A  91      39.117 -10.893  -4.947  1.00  0.00           N  
ATOM   1470  CA  TYR A  91      39.518 -10.284  -3.684  1.00  0.00           C  
ATOM   1471  C   TYR A  91      40.747  -9.399  -3.873  1.00  0.00           C  
ATOM   1472  O   TYR A  91      40.857  -8.333  -3.268  1.00  0.00           O  
ATOM   1473  CB  TYR A  91      39.810 -11.366  -2.642  1.00  0.00           C  
ATOM   1474  CG  TYR A  91      39.804 -10.852  -1.220  1.00  0.00           C  
ATOM   1475  CD1 TYR A  91      40.759  -9.942  -0.786  1.00  0.00           C  
ATOM   1476  CD2 TYR A  91      38.845 -11.281  -0.310  1.00  0.00           C  
ATOM   1477  CE1 TYR A  91      40.759  -9.471   0.513  1.00  0.00           C  
ATOM   1478  CE2 TYR A  91      38.836 -10.814   0.991  1.00  0.00           C  
ATOM   1479  CZ  TYR A  91      39.795  -9.910   1.398  1.00  0.00           C  
ATOM   1480  OH  TYR A  91      39.790  -9.443   2.692  1.00  0.00           O  
ATOM   1481  H   TYR A  91      39.044 -11.868  -5.004  1.00  0.00           H  
ATOM   1482  HA  TYR A  91      38.699  -9.674  -3.335  1.00  0.00           H  
ATOM   1483  HB2 TYR A  91      39.062 -12.140  -2.718  1.00  0.00           H  
ATOM   1484  HB3 TYR A  91      40.783 -11.791  -2.838  1.00  0.00           H  
ATOM   1485  HD1 TYR A  91      41.512  -9.600  -1.480  1.00  0.00           H  
ATOM   1486  HD2 TYR A  91      38.096 -11.989  -0.632  1.00  0.00           H  
ATOM   1487  HE1 TYR A  91      41.509  -8.763   0.833  1.00  0.00           H  
ATOM   1488  HE2 TYR A  91      38.082 -11.158   1.682  1.00  0.00           H  
ATOM   1489  HH  TYR A  91      38.884  -9.296   2.976  1.00  0.00           H  
ATOM   1490  N   ALA A  92      41.669  -9.851  -4.716  1.00  0.00           N  
ATOM   1491  CA  ALA A  92      42.889  -9.099  -4.988  1.00  0.00           C  
ATOM   1492  C   ALA A  92      42.591  -7.844  -5.800  1.00  0.00           C  
ATOM   1493  O   ALA A  92      43.119  -6.770  -5.512  1.00  0.00           O  
ATOM   1494  CB  ALA A  92      43.896  -9.976  -5.718  1.00  0.00           C  
ATOM   1495  H   ALA A  92      41.525 -10.708  -5.169  1.00  0.00           H  
ATOM   1496  HA  ALA A  92      43.320  -8.811  -4.041  1.00  0.00           H  
ATOM   1497  HB1 ALA A  92      44.078 -10.872  -5.143  1.00  0.00           H  
ATOM   1498  HB2 ALA A  92      43.502 -10.244  -6.687  1.00  0.00           H  
ATOM   1499  HB3 ALA A  92      44.822  -9.433  -5.843  1.00  0.00           H  
ATOM   1500  N   GLU A  93      41.744  -7.987  -6.813  1.00  0.00           N  
ATOM   1501  CA  GLU A  93      41.378  -6.862  -7.667  1.00  0.00           C  
ATOM   1502  C   GLU A  93      41.123  -5.609  -6.836  1.00  0.00           C  
ATOM   1503  O   GLU A  93      40.427  -5.654  -5.822  1.00  0.00           O  
ATOM   1504  CB  GLU A  93      40.135  -7.202  -8.492  1.00  0.00           C  
ATOM   1505  CG  GLU A  93      40.411  -8.156  -9.643  1.00  0.00           C  
ATOM   1506  CD  GLU A  93      39.140  -8.681 -10.282  1.00  0.00           C  
ATOM   1507  OE1 GLU A  93      38.290  -7.855 -10.677  1.00  0.00           O  
ATOM   1508  OE2 GLU A  93      38.995  -9.917 -10.386  1.00  0.00           O  
ATOM   1509  H   GLU A  93      41.355  -8.868  -6.993  1.00  0.00           H  
ATOM   1510  HA  GLU A  93      42.203  -6.673  -8.337  1.00  0.00           H  
ATOM   1511  HB2 GLU A  93      39.400  -7.656  -7.844  1.00  0.00           H  
ATOM   1512  HB3 GLU A  93      39.728  -6.289  -8.899  1.00  0.00           H  
ATOM   1513  HG2 GLU A  93      40.985  -7.635 -10.395  1.00  0.00           H  
ATOM   1514  HG3 GLU A  93      40.982  -8.993  -9.271  1.00  0.00           H  
ATOM   1515  N   GLY A  94      41.693  -4.489  -7.272  1.00  0.00           N  
ATOM   1516  CA  GLY A  94      41.516  -3.239  -6.557  1.00  0.00           C  
ATOM   1517  C   GLY A  94      42.672  -2.936  -5.625  1.00  0.00           C  
ATOM   1518  O   GLY A  94      43.171  -1.812  -5.587  1.00  0.00           O  
ATOM   1519  H   GLY A  94      42.236  -4.513  -8.087  1.00  0.00           H  
ATOM   1520  HA2 GLY A  94      41.425  -2.436  -7.274  1.00  0.00           H  
ATOM   1521  HA3 GLY A  94      40.606  -3.294  -5.977  1.00  0.00           H  
ATOM   1522  N   LYS A  95      43.098  -3.941  -4.867  1.00  0.00           N  
ATOM   1523  CA  LYS A  95      44.202  -3.778  -3.929  1.00  0.00           C  
ATOM   1524  C   LYS A  95      45.519  -3.571  -4.670  1.00  0.00           C  
ATOM   1525  O   LYS A  95      45.690  -4.043  -5.794  1.00  0.00           O  
ATOM   1526  CB  LYS A  95      44.306  -5.001  -3.015  1.00  0.00           C  
ATOM   1527  CG  LYS A  95      43.340  -4.967  -1.842  1.00  0.00           C  
ATOM   1528  CD  LYS A  95      43.181  -6.340  -1.211  1.00  0.00           C  
ATOM   1529  CE  LYS A  95      42.505  -6.253   0.149  1.00  0.00           C  
ATOM   1530  NZ  LYS A  95      41.032  -6.071   0.025  1.00  0.00           N  
ATOM   1531  H   LYS A  95      42.659  -4.815  -4.942  1.00  0.00           H  
ATOM   1532  HA  LYS A  95      44.000  -2.905  -3.327  1.00  0.00           H  
ATOM   1533  HB2 LYS A  95      44.102  -5.889  -3.596  1.00  0.00           H  
ATOM   1534  HB3 LYS A  95      45.311  -5.060  -2.624  1.00  0.00           H  
ATOM   1535  HG2 LYS A  95      43.716  -4.282  -1.098  1.00  0.00           H  
ATOM   1536  HG3 LYS A  95      42.376  -4.627  -2.192  1.00  0.00           H  
ATOM   1537  HD2 LYS A  95      42.580  -6.958  -1.861  1.00  0.00           H  
ATOM   1538  HD3 LYS A  95      44.159  -6.786  -1.090  1.00  0.00           H  
ATOM   1539  HE2 LYS A  95      42.702  -7.164   0.693  1.00  0.00           H  
ATOM   1540  HE3 LYS A  95      42.919  -5.415   0.689  1.00  0.00           H  
ATOM   1541  HZ1 LYS A  95      40.600  -6.922  -0.386  1.00  0.00           H  
ATOM   1542  HZ2 LYS A  95      40.824  -5.257  -0.588  1.00  0.00           H  
ATOM   1543  HZ3 LYS A  95      40.614  -5.900   0.962  1.00  0.00           H  
ATOM   1544  N   MET A  96      46.447  -2.866  -4.032  1.00  0.00           N  
ATOM   1545  CA  MET A  96      47.750  -2.599  -4.631  1.00  0.00           C  
ATOM   1546  C   MET A  96      48.794  -3.589  -4.124  1.00  0.00           C  
ATOM   1547  O   MET A  96      49.285  -3.467  -3.002  1.00  0.00           O  
ATOM   1548  CB  MET A  96      48.195  -1.169  -4.320  1.00  0.00           C  
ATOM   1549  CG  MET A  96      49.178  -0.605  -5.333  1.00  0.00           C  
ATOM   1550  SD  MET A  96      49.874   0.977  -4.820  1.00  0.00           S  
ATOM   1551  CE  MET A  96      48.645   2.111  -5.460  1.00  0.00           C  
ATOM   1552  H   MET A  96      46.251  -2.516  -3.137  1.00  0.00           H  
ATOM   1553  HA  MET A  96      47.652  -2.712  -5.700  1.00  0.00           H  
ATOM   1554  HB2 MET A  96      47.324  -0.529  -4.303  1.00  0.00           H  
ATOM   1555  HB3 MET A  96      48.663  -1.153  -3.348  1.00  0.00           H  
ATOM   1556  HG2 MET A  96      49.986  -1.311  -5.463  1.00  0.00           H  
ATOM   1557  HG3 MET A  96      48.666  -0.470  -6.274  1.00  0.00           H  
ATOM   1558  HE1 MET A  96      48.766   3.076  -4.989  1.00  0.00           H  
ATOM   1559  HE2 MET A  96      48.772   2.214  -6.528  1.00  0.00           H  
ATOM   1560  HE3 MET A  96      47.658   1.729  -5.250  1.00  0.00           H  
ATOM   1561  N   ARG A  97      49.126  -4.570  -4.956  1.00  0.00           N  
ATOM   1562  CA  ARG A  97      50.110  -5.582  -4.591  1.00  0.00           C  
ATOM   1563  C   ARG A  97      51.402  -4.933  -4.102  1.00  0.00           C  
ATOM   1564  O   ARG A  97      51.517  -3.709  -4.063  1.00  0.00           O  
ATOM   1565  CB  ARG A  97      50.405  -6.492  -5.786  1.00  0.00           C  
ATOM   1566  CG  ARG A  97      51.437  -5.923  -6.745  1.00  0.00           C  
ATOM   1567  CD  ARG A  97      51.844  -6.943  -7.796  1.00  0.00           C  
ATOM   1568  NE  ARG A  97      50.974  -6.897  -8.968  1.00  0.00           N  
ATOM   1569  CZ  ARG A  97      50.978  -5.900  -9.847  1.00  0.00           C  
ATOM   1570  NH1 ARG A  97      51.801  -4.874  -9.687  1.00  0.00           N  
ATOM   1571  NH2 ARG A  97      50.158  -5.931 -10.889  1.00  0.00           N  
ATOM   1572  H   ARG A  97      48.699  -4.615  -5.837  1.00  0.00           H  
ATOM   1573  HA  ARG A  97      49.694  -6.176  -3.792  1.00  0.00           H  
ATOM   1574  HB2 ARG A  97      50.770  -7.440  -5.420  1.00  0.00           H  
ATOM   1575  HB3 ARG A  97      49.488  -6.654  -6.334  1.00  0.00           H  
ATOM   1576  HG2 ARG A  97      51.019  -5.060  -7.240  1.00  0.00           H  
ATOM   1577  HG3 ARG A  97      52.312  -5.629  -6.184  1.00  0.00           H  
ATOM   1578  HD2 ARG A  97      52.859  -6.739  -8.104  1.00  0.00           H  
ATOM   1579  HD3 ARG A  97      51.793  -7.929  -7.360  1.00  0.00           H  
ATOM   1580  HE  ARG A  97      50.358  -7.646  -9.106  1.00  0.00           H  
ATOM   1581 HH11 ARG A  97      52.422  -4.849  -8.904  1.00  0.00           H  
ATOM   1582 HH12 ARG A  97      51.804  -4.125 -10.351  1.00  0.00           H  
ATOM   1583 HH21 ARG A  97      49.535  -6.703 -11.014  1.00  0.00           H  
ATOM   1584 HH22 ARG A  97      50.161  -5.181 -11.550  1.00  0.00           H  
ATOM   1585  N   GLY A  98      52.370  -5.764  -3.728  1.00  0.00           N  
ATOM   1586  CA  GLY A  98      53.639  -5.253  -3.245  1.00  0.00           C  
ATOM   1587  C   GLY A  98      54.102  -5.948  -1.980  1.00  0.00           C  
ATOM   1588  O   GLY A  98      53.607  -7.022  -1.639  1.00  0.00           O  
ATOM   1589  H   GLY A  98      52.222  -6.731  -3.781  1.00  0.00           H  
ATOM   1590  HA2 GLY A  98      54.386  -5.391  -4.013  1.00  0.00           H  
ATOM   1591  HA3 GLY A  98      53.536  -4.196  -3.044  1.00  0.00           H  
ATOM   1592  N   ALA A  99      55.053  -5.336  -1.284  1.00  0.00           N  
ATOM   1593  CA  ALA A  99      55.581  -5.903  -0.050  1.00  0.00           C  
ATOM   1594  C   ALA A  99      55.886  -7.387  -0.213  1.00  0.00           C  
ATOM   1595  O   ALA A  99      55.533  -8.202   0.639  1.00  0.00           O  
ATOM   1596  CB  ALA A  99      54.599  -5.686   1.093  1.00  0.00           C  
ATOM   1597  H   ALA A  99      55.407  -4.481  -1.607  1.00  0.00           H  
ATOM   1598  HA  ALA A  99      56.497  -5.382   0.193  1.00  0.00           H  
ATOM   1599  HB1 ALA A  99      54.871  -4.794   1.637  1.00  0.00           H  
ATOM   1600  HB2 ALA A  99      53.602  -5.576   0.693  1.00  0.00           H  
ATOM   1601  HB3 ALA A  99      54.629  -6.536   1.759  1.00  0.00           H  
ATOM   1602  N   ALA A 100      56.544  -7.734  -1.316  1.00  0.00           N  
ATOM   1603  CA  ALA A 100      56.896  -9.121  -1.591  1.00  0.00           C  
ATOM   1604  C   ALA A 100      58.171  -9.518  -0.855  1.00  0.00           C  
ATOM   1605  O   ALA A 100      58.981  -8.666  -0.490  1.00  0.00           O  
ATOM   1606  CB  ALA A 100      57.059  -9.337  -3.088  1.00  0.00           C  
ATOM   1607  H   ALA A 100      56.798  -7.039  -1.958  1.00  0.00           H  
ATOM   1608  HA  ALA A 100      56.084  -9.746  -1.248  1.00  0.00           H  
ATOM   1609  HB1 ALA A 100      56.572  -8.535  -3.623  1.00  0.00           H  
ATOM   1610  HB2 ALA A 100      58.111  -9.348  -3.337  1.00  0.00           H  
ATOM   1611  HB3 ALA A 100      56.612 -10.280  -3.366  1.00  0.00           H  
TER    1612      ALA A 100                                                      
END
MOLECULE T0429.pdb
ATOM      1  N   GLU    22      23.143   8.727  21.130  1.00172.90      A    N  
ATOM      2  CA  GLU    22      22.374   7.758  20.286  1.00169.34      A    C  
ATOM      3  CB  GLU    22      22.276   8.259  18.835  1.00168.54      A    C  
ATOM      4  CG  GLU    22      23.616   8.393  18.103  1.00158.10      A    C  
ATOM      5  CD  GLU    22      23.457   8.575  16.601  1.00157.25      A    C  
ATOM      6  OE1 GLU    22      24.348   8.113  15.852  1.00147.23      A    O  
ATOM      7  OE2 GLU    22      22.446   9.173  16.165  1.00167.76      A    O  
ATOM      8  C   GLU    22      22.931   6.322  20.338  1.00157.48      A    C  
ATOM      9  O   GLU    22      22.498   5.455  19.576  1.00152.96      A    O  
ATOM     10  N   THR    23      23.876   6.088  21.250  1.00154.10      A    N  
ATOM     11  CA  THR    23      24.505   4.776  21.452  1.00145.40      A    C  
ATOM     12  CB  THR    23      25.730   4.896  22.405  1.00143.94      A    C  
ATOM     13  OG1 THR    23      26.652   5.863  21.883  1.00141.32      A    O  
ATOM     14  CG2 THR    23      26.454   3.563  22.562  1.00136.43      A    C  
ATOM     15  C   THR    23      23.503   3.729  21.972  1.00150.21      A    C  
ATOM     16  O   THR    23      22.570   4.068  22.704  1.00162.36      A    O  
ATOM     17  N   GLU    24      23.706   2.466  21.590  1.00143.04      A    N  
ATOM     18  CA  GLU    24      22.756   1.383  21.886  1.00147.93      A    C  
ATOM     19  CB  GLU    24      22.210   0.789  20.580  1.00144.01      A    C  
ATOM     24  C   GLU    24      23.290   0.256  22.791  1.00146.91      A    C  
ATOM     25  O   GLU    24      22.482  -0.568  23.303  1.00154.53      A    O  
ATOM     26  N   LEU    25      24.636   0.215  22.968  1.00139.01      A    N  
ATOM     27  CA  LEU    25      25.295  -0.776  23.847  1.00138.87      A    C  
ATOM     28  CB  LEU    25      25.029  -0.457  25.346  1.00151.41      A    C  
ATOM     29  CG  LEU    25      26.098  -0.729  26.420  1.00153.60      A    C  
ATOM     30  CD1 LEU    25      25.557  -0.342  27.808  1.00166.65      A    C  
ATOM     31  CD2 LEU    25      26.620  -2.188  26.419  1.00150.16      A    C  
ATOM     32  C   LEU    25      24.901  -2.238  23.511  1.00137.26      A    C  
ATOM     33  O   LEU    25      24.248  -2.938  24.308  1.00144.91      A    O  
ATOM     34  N   LEU    27      24.229  -6.765  19.987  1.00124.47      A    N  
ATOM     35  CA  LEU    27      24.721  -8.135  19.817  1.00123.94      A    C  
ATOM     36  CB  LEU    27      24.018  -8.864  18.654  1.00124.12      A    C  
ATOM     37  CG  LEU    27      23.652  -8.221  17.310  1.00118.98      A    C  
ATOM     38  CD1 LEU    27      23.488  -9.322  16.264  1.00118.08      A    C  
ATOM     38  CD2 LEU    27      22.365  -7.397  17.414  1.00128.31      A    C  
ATOM     40  C   LEU    27      26.247  -8.245  19.696  1.00114.60      A    C  
ATOM     41  O   LEU    27      26.853  -9.156  20.263  1.00117.26      A    O  
ATOM     42  N   TYR    28      26.862  -7.335  18.947  1.00105.66      A    N  
ATOM     43  CA  TYR    28      28.319  -7.200  18.963  1.00 99.30      A    C  
ATOM     44  CB  TYR    28      28.923  -7.286  17.548  1.00 89.68      A    C  
ATOM     45  CG  TYR    28      28.406  -8.478  16.772  1.00 88.71      A    C  
ATOM     46  CD1 TYR    28      28.819  -9.774  17.087  1.00 90.89      A    C  
ATOM     47  CE1 TYR    28      28.325 -10.875  16.393  1.00 93.27      A    C  
ATOM     48  CZ  TYR    28      27.402 -10.683  15.376  1.00 92.44      A    C  
ATOM     49  OH  TYR    28      26.907 -11.765  14.685  1.00 96.36      A    O  
ATOM     50  CE2 TYR    28      26.974  -9.408  15.047  1.00 89.46      A    C  
ATOM     51  CD2 TYR    28      27.475  -8.315  15.748  1.00 87.20      A    C  
ATOM     52  C   TYR    28      28.651  -5.890  19.660  1.00100.94      A    C  
ATOM     53  O   TYR    28      28.114  -4.836  19.311  1.00100.23      A    O  
ATOM     54  N   LYS    29      29.505  -5.973  20.675  1.00104.98      A    N  
ATOM     55  CA  LYS    29      29.862  -4.813  21.481  1.00108.51      A    C  
ATOM     56  CB  LYS    29      30.333  -5.254  22.871  1.00116.86      A    C  
ATOM     61  C   LYS    29      30.923  -3.949  20.793  1.00102.56      A    C  
ATOM     62  O   LYS    29      31.688  -4.428  19.957  1.00 96.86      A    O  
ATOM     63  N   VAL    30      30.941  -2.667  21.147  1.00106.01      A    N  
ATOM     64  CA  VAL    30      31.946  -1.717  20.668  1.00103.19      A    C  
ATOM     65  CB  VAL    30      31.691  -0.300  21.261  1.00109.00      A    C  
ATOM     66  CG1 VAL    30      31.681  -0.327  22.793  1.00117.99      A    C  
ATOM     67  CG2 VAL    30      32.698   0.704  20.741  1.00108.94      A    C  
ATOM     68  C   VAL    30      33.374  -2.211  20.960  1.00103.89      A    C  
ATOM     69  O   VAL    30      33.667  -2.667  22.065  1.00110.81      A    O  
ATOM     70  N   ASN    31      34.238  -2.134  19.948  1.00 98.81      A    N  
ATOM     71  CA  ASN    31      35.638  -2.589  20.016  1.00 99.77      A    C  
ATOM     72  CB  ASN    31      36.312  -2.208  21.337  1.00108.53      A    C  
ATOM     73  CG  ASN    31      36.624  -0.747  21.416  1.00112.78      A    C  
ATOM     74  OD1 ASN    31      35.766   0.061  21.763  1.00116.34      A    O  
ATOM     75  ND2 ASN    31      37.861  -0.390  21.095  1.00116.64      A    N  
ATOM     76  C   ASN    31      35.858  -4.066  19.726  1.00 96.91      A    C  
ATOM     77  O   ASN    31      37.000  -4.499  19.568  1.00 98.59      A    O  
ATOM     78  N   GLU    32      34.779  -4.839  19.660  1.00 94.41      A    N  
ATOM     79  CA  GLU    32      34.889  -6.234  19.254  1.00 93.05      A    C  
ATOM     80  CB  GLU    32      33.592  -6.998  19.533  1.00 94.24      A    C  
ATOM     81  CG  GLU    32      33.730  -8.518  19.443  1.00 96.69      A    C  
ATOM     82  CD  GLU    32      32.437  -9.259  19.760  1.00101.02      A    C  
ATOM     83  OE1 GLU    32      31.677  -8.814  20.653  1.00104.59      A    O  
ATOM     84  OE2 GLU    32      32.191 -10.304  19.112  1.00101.68      A    O  
ATOM     85  C   GLU    32      35.248  -6.293  17.770  1.00 85.89      A    C  
ATOM     86  O   GLU    32      34.742  -5.503  16.970  1.00 81.52      A    O  
ATOM     87  N   TYR    33      36.146  -7.212  17.424  1.00 86.41      A    N  
ATOM     88  CA  TYR    33      36.514  -7.452  16.032  1.00 80.84      A    C  
ATOM     89  CB  TYR    33      37.902  -8.087  15.933  1.00 84.64      A    C  
ATOM     90  CG  TYR    33      39.026  -7.173  16.361  1.00 88.89      A    C  
ATOM     91  CD1 TYR    33      39.565  -6.233  15.478  1.00 87.72      A    C  
ATOM     92  CE1 TYR    33      40.604  -5.390  15.869  1.00 93.77      A    C  
ATOM     93  CZ  TYR    33      41.113  -5.488  17.158  1.00102.17      A    C  
ATOM     94  OH  TYR    33      42.137  -4.665  17.562  1.00109.70      A    O  
ATOM     95  CE2 TYR    33      40.595  -6.415  18.049  1.00103.06      A    C  
ATOM     96  CD2 TYR    33      39.558  -7.251  17.645  1.00 96.63      A    C  
ATOM     97  C   TYR    33      35.481  -8.343  15.365  1.00 77.13      A    C  
ATOM     98  O   TYR    33      34.999  -9.304  15.962  1.00 80.54      A    O  
ATOM     99  N   VAL    34      35.150  -8.015  14.121  1.00 71.92      A    N  
ATOM    100  CA  VAL    34      34.093  -8.702  13.387  1.00 68.82      A    C  
ATOM    101  CB  VAL    34      32.747  -7.920  13.464  1.00 68.44      A    C  
ATOM    102  CG1 VAL    34      32.177  -7.925  14.884  1.00 71.47      A    C  
ATOM    103  CG2 VAL    34      32.898  -6.493  12.926  1.00 64.40      A    C  
ATOM    104  C   VAL    34      34.460  -8.908  11.914  1.00 66.21      A    C  
ATOM    105  O   VAL    34      35.567  -8.577  11.481  1.00 66.29      A    O  
ATOM    106  N   ASP    35      33.522  -9.472  11.162  1.00 64.66      A    N  
ATOM    107  CA  ASP    35      33.597  -9.509   9.715  1.00 63.00      A    C  
ATOM    108  CB  ASP    35      33.407 -10.939   9.202  1.00 63.65      A    C  
ATOM    109  CG  ASP    35      34.686 -11.759   9.244  1.00 64.32      A    C  
ATOM    110  OD1 ASP    35      35.783 -11.188   9.069  1.00 62.56      A    O  
ATOM    111  OD2 ASP    35      34.591 -12.990   9.434  1.00 66.48      A    O  
ATOM    112  C   ASP    35      32.473  -8.627   9.199  1.00 63.11      A    C  
ATOM    113  O   ASP    35      31.344  -8.719   9.686  1.00 65.91      A    O  
ATOM    114  N   ALA    36      32.775  -7.773   8.221  1.00 62.20      A    N  
ATOM    115  CA  ALA    36      31.779  -6.853   7.670  1.00 62.48      A    C  
ATOM    116  CB  ALA    36      32.182  -5.415   7.934  1.00 63.64      A    C  
ATOM    117  C   ALA    36      31.607  -7.080   6.186  1.00 63.86      A    C  
ATOM    118  O   ALA    36      32.589  -7.191   5.452  1.00 65.27      A    O  
ATOM    119  N   ARG    37      30.358  -7.138   5.744  1.00 66.32      A    N  
ATOM    120  CA  ARG    37      30.057  -7.410   4.344  1.00 70.06      A    C  
ATOM    121  CB  ARG    37      28.720  -8.159   4.199  1.00 73.46      A    C  
ATOM    122  CG  ARG    37      28.518  -8.813   2.829  1.00 77.70      A    C  
ATOM    123  CD  ARG    37      27.182  -9.543   2.729  1.00 83.79      A    C  
ATOM    124  NE  ARG    37      26.063  -8.613   2.586  1.00 92.01      A    N  
ATOM    125  CZ  ARG    37      25.427  -8.344   1.445  1.00 99.69      A    C  
ATOM    126  NH1 ARG    37      25.775  -8.943   0.309  1.00101.62      A    N  
ATOM    127  NH2 ARG    37      24.425  -7.472   1.444  1.00105.62      A    N  
ATOM    128  C   ARG    37      30.043  -6.122   3.535  1.00 72.97      A    C  
ATOM    129  O   ARG    37      29.183  -5.267   3.734  1.00 76.28      A    O  
ATOM    130  N   ASP    38      31.015  -5.980   2.640  1.00 74.45      A    N  
ATOM    131  CA  ASP    38      30.995  -4.906   1.661  1.00 81.28      A    C  
ATOM    132  CB  ASP    38      32.279  -4.924   0.825  1.00 83.16      A    C  
ATOM    133  CG  ASP    38      32.369  -3.768  -0.157  1.00 91.41      A    C  
ATOM    134  OD1 ASP    38      31.439  -3.583  -0.965  1.00 98.91      A    O  
ATOM    135  OD2 ASP    38      33.394  -3.058  -0.145  1.00 93.84      A    O  
ATOM    136  C   ASP    38      29.768  -5.148   0.794  1.00 87.58      A    C  
ATOM    137  O   ASP    38      29.730  -6.094   0.011  1.00 90.08      A    O  
ATOM    138  N   THR    39      28.754  -4.307   0.961  1.00 92.61      A    N  
ATOM    139  CA  THR    39      27.483  -4.487   0.262  1.00101.09      A    C  
ATOM    140  CB  THR    39      26.377  -3.589   0.863  1.00105.79      A    C  
ATOM    141  OG1 THR    39      26.310  -3.809   2.276  1.00100.08      A    O  
ATOM    142  CG2 THR    39      25.014  -3.910   0.258  1.00115.77      A    C  
ATOM    143  C   THR    39      27.621  -4.263  -1.246  1.00109.30      A    C  
ATOM    144  O   THR    39      26.849  -4.811  -2.034  1.00116.02      A    O  
ATOM    145  N   ASN    40      28.617  -3.475  -1.640  1.00111.13      A    N  
ATOM    146  CA  ASN    40      28.866  -3.188  -3.050  1.00121.02      A    C  
ATOM    147  CB  ASN    40      29.891  -2.057  -3.191  1.00124.44      A    C  
ATOM    148  CG  ASN    40      30.409  -1.907  -4.609  1.00135.60      A    C  
ATOM    149  OD1 ASN    40      31.550  -2.269  -4.903  1.00135.88      A    O  
ATOM    150  ND2 ASN    40      29.567  -1.391  -5.502  1.00147.42      A    N  
ATOM    151  C   ASN    40      29.296  -4.418  -3.857  1.00120.57      A    C  
ATOM    152  O   ASN    40      28.922  -4.560  -5.022  1.00129.57      A    O  
ATOM    153  N   MET    41      30.064  -5.308  -3.234  1.00111.84      A    N  
ATOM    154  CA  MET    41      30.606  -6.478  -3.933  1.00112.47      A    C  
ATOM    155  CB  MET    41      32.122  -6.373  -4.048  1.00111.40      A    C  
ATOM    156  CG  MET    41      32.807  -6.077  -2.737  1.00103.73      A    C  
ATOM    157  SD  MET    41      34.733  -6.073  -2.908  1.00108.38      A   SE  
ATOM    158  CE  MET    41      34.947  -4.830  -4.410  1.00120.35      A    C  
ATOM    159  C   MET    41      30.224  -7.818  -3.307  1.00105.36      A    C  
ATOM    160  O   MET    41      30.327  -8.863  -3.955  1.00106.85      A    O  
ATOM    161  N   GLY    42      29.804  -7.780  -2.047  1.00 83.71      A    N  
ATOM    162  CA  GLY    42      29.269  -8.959  -1.367  1.00 83.07      A    C  
ATOM    163  C   GLY    42      30.262  -9.792  -0.578  1.00 77.08      A    C  
ATOM    164  O   GLY    42      29.914 -10.867  -0.090  1.00 77.31      A    O  
ATOM    165  N   ALA    43      31.490  -9.300  -0.446  1.00 72.89      A    N  
ATOM    166  CA  ALA    43      32.548 -10.041   0.234  1.00 69.07      A    C  
ATOM    167  CB  ALA    43      33.865  -9.848  -0.491  1.00 68.37      A    C  
ATOM    168  C   ALA    43      32.669  -9.636   1.703  1.00 65.34      A    C  
ATOM    169  O   ALA    43      32.300  -8.525   2.077  1.00 65.78      A    O  
ATOM    170  N   TRP    44      33.183 -10.537   2.535  1.00 64.28      A    N  
ATOM    171  CA  TRP    44      33.399 -10.241   3.953  1.00 61.58      A    C  
ATOM    172  CB  TRP    44      32.987 -11.425   4.830  1.00 63.28      A    C  
ATOM    173  CG  TRP    44      31.522 -11.742   4.770  1.00 66.96      A    C  
ATOM    174  CD1 TRP    44      30.893 -12.523   3.846  1.00 71.29      A    C  
ATOM    175  NE1 TRP    44      29.547 -12.583   4.112  1.00 75.54      A    N  
ATOM    176  CE2 TRP    44      29.278 -11.826   5.222  1.00 74.38      A    C  
ATOM    177  CD2 TRP    44      30.503 -11.280   5.667  1.00 69.18      A    C  
ATOM    178  CE3 TRP    44      30.505 -10.458   6.805  1.00 68.75      A    C  
ATOM    179  CZ3 TRP    44      29.298 -10.209   7.452  1.00 70.28      A    C  
ATOM    180  CH2 TRP    44      28.096 -10.769   6.986  1.00 75.60      A    C  
ATOM    181  CZ2 TRP    44      28.063 -11.578   5.876  1.00 76.96      A    C  
ATOM    182  C   TRP    44      34.850  -9.851   4.236  1.00 60.04      A    C  
ATOM    183  O   TRP    44      35.789 -10.497   3.740  1.00 59.62      A    O  
ATOM    184  N   PHE    45      35.017  -8.797   5.038  1.00 57.06      A    N  
ATOM    185  CA  PHE    45      36.331  -8.252   5.361  1.00 55.38      A    C  
ATOM    186  CB  PHE    45      36.541  -6.899   4.673  1.00 54.74      A    C  
ATOM    187  CG  PHE    45      36.523  -6.953   3.157  1.00 58.74      A    C  
ATOM    188  CD1 PHE    45      37.701  -7.144   2.439  1.00 58.08      A    C  
ATOM    189  CE1 PHE    45      37.695  -7.170   1.046  1.00 62.77      A    C  
ATOM    190  CZ  PHE    45      36.501  -7.000   0.344  1.00 63.52      A    C  
ATOM    191  CE2 PHE    45      35.321  -6.799   1.049  1.00 65.02      A    C  
ATOM    192  CD2 PHE    45      35.334  -6.773   2.448  1.00 58.18      A    C  
ATOM    193  C   PHE    45      36.481  -8.089   6.879  1.00 55.58      A    C  
ATOM    194  O   PHE    45      35.519  -7.741   7.578  1.00 55.09      A    O  
ATOM    195  N   GLU    46      37.686  -8.344   7.381  1.00 56.08      A    N  
ATOM    196  CA  GLU    46      37.969  -8.188   8.805  1.00 57.83      A    C  
ATOM    197  CB  GLU    46      39.401  -8.620   9.155  1.00 59.91      A    C  
ATOM    198  CG  GLU    46      39.750 -10.086   8.880  1.00 61.88      A    C  
ATOM    199  CD  GLU    46      40.313 -10.306   7.470  1.00 65.85      A    C  
ATOM    200  OE1 GLU    46      39.935  -9.574   6.516  1.00 60.16      A    O  
ATOM    201  OE2 GLU    46      41.147 -11.223   7.320  1.00 72.28      A    O  
ATOM    202  C   GLU    46      37.762  -6.724   9.155  1.00 57.63      A    C  
ATOM    203  O   GLU    46      38.320  -5.836   8.509  1.00 58.66      A    O  
ATOM    204  N   ALA    47      36.924  -6.478  10.150  1.00 57.65      A    N  
ATOM    205  CA  ALA    47      36.649  -5.120  10.594  1.00 58.18      A    C  
ATOM    206  CB  ALA    47      35.406  -4.582   9.895  1.00 56.70      A    C  
ATOM    207  C   ALA    47      36.505  -5.054  12.117  1.00 60.50      A    C  
ATOM    208  O   ALA    47      36.526  -6.082  12.792  1.00 61.81      A    O  
ATOM    209  N   GLN    48      36.390  -3.842  12.652  1.00 63.44      A    N  
ATOM    210  CA  GLN    48      36.171  -3.640  14.084  1.00 67.12      A    C  
ATOM    211  CB  GLN    48      37.456  -3.160  14.766  1.00 71.03      A    C  
ATOM    212  CG  GLN    48      37.367  -3.069  16.297  1.00 75.40      A    C  
ATOM    213  CD  GLN    48      38.641  -2.565  16.949  1.00 80.70      A    C  
ATOM    214  OE1 GLN    48      39.520  -2.019  16.287  1.00 80.17      A    O  
ATOM    215  NE2 GLN    48      38.742  -2.741  18.266  1.00 86.01      A    N  
ATOM    216  C   GLN    48      35.030  -2.652  14.331  1.00 69.25      A    C  
ATOM    217  O   GLN    48      34.873  -1.667  13.598  1.00 67.51      A    O  
ATOM    218  N   VAL    49      34.243  -2.927  15.369  1.00 72.79      A    N  
ATOM    219  CA  VAL    49      33.117  -2.082  15.740  1.00 76.25      A    C  
ATOM    220  CB  VAL    49      32.072  -2.853  16.579  1.00 80.46      A    C  
ATOM    221  CG1 VAL    49      30.933  -1.925  17.006  1.00 82.55      A    C  
ATOM    222  CG2 VAL    49      31.539  -4.055  15.802  1.00 75.52      A    C  
ATOM    223  C   VAL    49      33.586  -0.852  16.516  1.00 81.59      A    C  
ATOM    224  O   VAL    49      34.141  -0.962  17.614  1.00 86.04      A    O  
ATOM    225  N   VAL    50      33.342   0.318  15.936  1.00 81.58      A    N  
ATOM    226  CA  VAL    50      33.742   1.586  16.532  1.00 85.85      A    C  
ATOM    227  CB  VAL    50      34.190   2.582  15.439  1.00 82.87      A    C  
ATOM    228  CG1 VAL    50      34.390   3.946  16.021  1.00 90.16      A    C  
ATOM    229  CG2 VAL    50      35.466   2.109  14.799  1.00 79.12      A    C  
ATOM    230  C   VAL    50      32.618   2.185  17.389  1.00 91.85      A    C  
ATOM    231  O   VAL    50      32.866   2.721  18.476  1.00 97.97      A    O  
ATOM    232  N   ARG    51      31.391   2.106  16.883  1.00 91.35      A    N  
ATOM    233  CA  ARG    51      30.213   2.553  17.613  1.00 98.00      A    C  
ATOM    234  CB  ARG    51      29.917   4.032  17.340  1.00100.80      A    C  
ATOM    235  CG  ARG    51      30.506   4.983  18.377  1.00107.46      A    C  
ATOM    236  CD  ARG    51      30.332   6.443  17.985  1.00110.40      A    C  
ATOM    237  NE  ARG    51      28.942   6.883  18.103  1.00118.29      A    N  
ATOM    238  CZ  ARG    51      28.426   7.482  19.175  1.00129.05      A    C  
ATOM    239  NH1 ARG    51      29.181   7.730  20.240  1.00134.40      A    N  
ATOM    240  NH2 ARG    51      27.146   7.840  19.187  1.00134.91      A    N  
ATOM    241  C   ARG    51      29.012   1.691  17.255  1.00 97.71      A    C  
ATOM    242  O   ARG    51      28.957   1.107  16.169  1.00 92.82      A    O  
ATOM    243  N   VAL    52      28.066   1.598  18.186  1.00104.09      A    N  
ATOM    244  CA  VAL    52      26.811   0.891  17.951  1.00105.53      A    C  
ATOM    245  CB  VAL    52      26.746  -0.447  18.749  1.00107.07      A    C  
ATOM    246  CG1 VAL    52      26.856  -0.214  20.262  1.00116.59      A    C  
ATOM    247  CG2 VAL    52      25.491  -1.224  18.406  1.00109.24      A    C  
ATOM    248  C   VAL    52      25.618   1.825  18.217  1.00112.85      A    C  
ATOM    249  O   VAL    52      25.528   2.453  19.276  1.00118.62      A    O  
ATOM    250  N   THR    53      24.724   1.920  17.235  1.00113.10      A    N  
ATOM    251  CA  THR    53      23.602   2.862  17.269  1.00121.51      A    C  
ATOM    252  CB  THR    53      23.697   3.858  16.086  1.00119.01      A    C  
ATOM    253  OG1 THR    53      25.050   4.292  15.937  1.00114.19      A    O  
ATOM    254  CG2 THR    53      22.815   5.078  16.309  1.00129.22      A    C  
ATOM    255  C   THR    53      22.252   2.129  17.233  1.00126.92      A    C  
ATOM    256  O   THR    53      22.201   0.930  16.948  1.00124.34      A    O  
ATOM    257  N   ARG    54      21.171   2.851  17.529  1.00135.79      A    N  
ATOM    258  CA  ARG    54      19.816   2.299  17.465  1.00143.10      A    C  
ATOM    259  CB  ARG    54      19.136   2.367  18.841  1.00152.93      A    C  
ATOM    266  C   ARG    54      18.965   3.026  16.419  1.00146.96      A    C  
ATOM    267  O   ARG    54      18.946   2.629  15.229  1.00142.84      A    O  
ATOM    268  N   GLU    73      20.100  -6.332  15.059  1.00123.32      A    N  
ATOM    269  CA  GLU    73      18.671  -6.470  14.844  1.00132.67      A    C  
ATOM    270  CB  GLU    73      18.053  -7.343  15.943  1.00141.48      A    C  
ATOM    271  CG  GLU    73      18.457  -6.965  17.377  1.00145.34      A    C  
ATOM    272  CD  GLU    73      17.406  -7.360  18.407  1.00159.33      A    C  
ATOM    273  OE1 GLU    73      16.940  -8.524  18.379  1.00163.38      A    O  
ATOM    274  OE2 GLU    73      17.047  -6.503  19.249  1.00167.09      A    O  
ATOM    275  C   GLU    73      18.000  -5.098  14.802  1.00137.46      A    C  
ATOM    276  O   GLU    73      17.488  -4.614  15.820  1.00144.45      A    O  
ATOM    277  N   ASP    74      18.001  -4.475  13.621  1.00134.20      A    N  
ATOM    278  CA  ASP    74      17.565  -3.076  13.462  1.00137.77      A    C  
ATOM    279  CB  ASP    74      16.132  -2.870  13.992  1.00150.47      A    C  
ATOM    280  CG  ASP    74      15.447  -1.638  13.404  1.00157.01      A    C  
ATOM    281  OD1 ASP    74      16.084  -0.904  12.614  1.00151.95      A    O  
ATOM    282  OD2 ASP    74      14.261  -1.406  13.738  1.00166.48      A    O  
ATOM    283  C   ASP    74      18.571  -2.133  14.150  1.00132.38      A    C  
ATOM    284  O   ASP    74      18.362  -0.917  14.243  1.00135.67      A    O  
ATOM    285  N   VAL    75      19.658  -2.731  14.633  1.00124.52      A    N  
ATOM    286  CA  VAL    75      20.823  -2.029  15.155  1.00117.47      A    C  
ATOM    287  CB  VAL    75      21.627  -2.956  16.115  1.00114.64      A    C  
ATOM    288  CG1 VAL    75      23.095  -2.588  16.171  1.00105.73      A    C  
ATOM    289  CG2 VAL    75      21.012  -2.949  17.511  1.00123.12      A    C  
ATOM    290  C   VAL    75      21.679  -1.621  13.962  1.00108.96      A    C  
ATOM    291  O   VAL    75      21.740  -2.351  12.968  1.00104.98      A    O  
ATOM    292  N   ILE    76      22.315  -0.453  14.052  1.00106.20      A    N  
ATOM    293  CA  ILE    76      23.261  -0.013  13.023  1.00 99.14      A    C  
ATOM    294  CB  ILE    76      22.765   1.254  12.255  1.00102.73      A    C  
ATOM    295  CG1 ILE    76      23.853   1.796  11.319  1.00 96.23      A    C  
ATOM    296  CD1 ILE    76      23.310   2.429  10.045  1.00 99.72      A    C  
ATOM    297  CG2 ILE    76      22.252   2.323  13.216  1.00110.67      A    C  
ATOM    298  C   ILE    76      24.690   0.120  13.573  1.00 92.90      A    C  
ATOM    299  O   ILE    76      24.945   0.887  14.499  1.00 95.46      A    O  
ATOM    300  N   TYR    77      25.607  -0.649  12.990  1.00 93.66      A    N  
ATOM    301  CA  TYR    77      26.991  -0.728  13.458  1.00 88.85      A    C  
ATOM    302  CB  TYR    77      27.533  -2.147  13.273  1.00 85.70      A    C  
ATOM    303  CG  TYR    77      26.943  -3.158  14.228  1.00 89.17      A    C  
ATOM    304  CD1 TYR    77      27.333  -3.187  15.566  1.00 90.70      A    C  
ATOM    305  CE1 TYR    77      26.796  -4.113  16.452  1.00 95.37      A    C  
ATOM    306  CZ  TYR    77      25.860  -5.028  16.005  1.00 96.78      A    C  
ATOM    307  OH  TYR    77      25.339  -5.937  16.890  1.00100.18      A    O  
ATOM    308  CE2 TYR    77      25.456  -5.027  14.677  1.00 95.16      A    C  
ATOM    309  CD2 TYR    77      26.000  -4.091  13.797  1.00 90.70      A    C  
ATOM    310  C   TYR    77      27.916   0.258  12.760  1.00 85.38      A    C  
ATOM    311  O   TYR    77      27.856   0.421  11.542  1.00 84.45      A    O  
ATOM    312  N   HIS    78      28.773   0.910  13.541  1.00 83.71      A    N  
ATOM    313  CA  HIS    78      29.810   1.770  12.989  1.00 81.14      A    C  
ATOM    314  CB  HIS    78      29.910   3.077  13.762  1.00 83.22      A    C  
ATOM    315  CG  HIS    78      28.703   3.945  13.615  1.00 87.89      A    C  
ATOM    316  ND1 HIS    78      28.769   5.234  13.134  1.00 90.48      A    N  
ATOM    317  CE1 HIS    78      27.554   5.752  13.107  1.00 94.69      A    C  
ATOM    318  NE2 HIS    78      26.702   4.840  13.539  1.00 96.87      A    N  
ATOM    319  CD2 HIS    78      27.395   3.699  13.861  1.00 91.50      A    C  
ATOM    320  C   HIS    78      31.117   1.019  13.031  1.00 77.65      A    C  
ATOM    321  O   HIS    78      31.556   0.572  14.093  1.00 78.47      A    O  
ATOM    322  N   VAL    79      31.736   0.895  11.864  1.00 73.81      A    N  
ATOM    323  CA  VAL    79      32.790  -0.070  11.660  1.00 70.60      A    C  
ATOM    324  CB  VAL    79      32.193  -1.323  10.934  1.00 70.59      A    C  
ATOM    325  CG1 VAL    79      33.109  -1.881   9.858  1.00 64.14      A    C  
ATOM    326  CG2 VAL    79      31.785  -2.385  11.956  1.00 70.14      A    C  
ATOM    327  C   VAL    79      33.993   0.529  10.929  1.00 69.42      A    C  
ATOM    328  O   VAL    79      33.844   1.379  10.051  1.00 69.22      A    O  
ATOM    329  N   LYS    80      35.186   0.100  11.328  1.00 69.05      A    N  
ATOM    330  CA  LYS    80      36.402   0.409  10.586  1.00 69.09      A    C  
ATOM    331  CB  LYS    80      37.372   1.251  11.422  1.00 70.54      A    C  
ATOM    332  CG  LYS    80      38.019   0.522  12.589  1.00 71.11      A    C  
ATOM    333  CD  LYS    80      38.951   1.430  13.346  1.00 72.80      A    C  
ATOM    334  CE  LYS    80      39.612   0.680  14.484  1.00 77.21      A    C  
ATOM    335  NZ  LYS    80      40.206   1.598  15.499  1.00 80.41      A    N  
ATOM    336  C   LYS    80      37.069  -0.878  10.094  1.00 68.73      A    C  
ATOM    337  O   LYS    80      37.050  -1.904  10.783  1.00 67.58      A    O  
ATOM    338  N   TYR    81      37.642  -0.809   8.895  1.00 69.17      A    N  
ATOM    339  CA  TYR    81      38.314  -1.942   8.276  1.00 69.65      A    C  
ATOM    340  CB  TYR    81      38.192  -1.871   6.756  1.00 71.26      A    C  
ATOM    341  CG  TYR    81      36.782  -2.058   6.257  1.00 73.36      A    C  
ATOM    342  CD1 TYR    81      35.942  -0.962   6.046  1.00 76.49      A    C  
ATOM    343  CE1 TYR    81      34.632  -1.135   5.589  1.00 78.01      A    C  
ATOM    344  CZ  TYR    81      34.160  -2.417   5.342  1.00 77.56      A    C  
ATOM    345  OH  TYR    81      32.871  -2.611   4.885  1.00 80.19      A    O  
ATOM    346  CE2 TYR    81      34.981  -3.517   5.552  1.00 75.57      A    C  
ATOM    347  CD2 TYR    81      36.279  -3.333   6.010  1.00 72.40      A    C  
ATOM    348  C   TYR    81      39.777  -2.026   8.675  1.00 70.89      A    C  
ATOM    349  O   TYR    81      40.533  -1.050   8.563  1.00 71.51      A    O  
ATOM    350  N   ASP    82      40.164  -3.215   9.130  1.00 71.89      A    N  
ATOM    351  CA  ASP    82      41.516  -3.480   9.609  1.00 73.79      A    C  
ATOM    352  CB  ASP    82      41.648  -4.954  10.017  1.00 74.15      A    C  
ATOM    353  CG  ASP    82      40.868  -5.285  11.286  1.00 76.59      A    C  
ATOM    354  OD1 ASP    82      40.138  -4.405  11.803  1.00 78.41      A    O  
ATOM    355  OD2 ASP    82      40.989  -6.432  11.775  1.00 78.61      A    O  
ATOM    356  C   ASP    82      42.576  -3.103   8.576  1.00 74.38      A    C  
ATOM    357  O   ASP    82      43.536  -2.406   8.898  1.00 77.23      A    O  
ATOM    358  N   ASP    83      42.376  -3.540   7.336  1.00 72.34      A    N  
ATOM    359  CA  ASP    83      43.368  -3.352   6.288  1.00 72.89      A    C  
ATOM    360  CB  ASP    83      43.600  -4.675   5.546  1.00 73.65      A    C  
ATOM    361  CG  ASP    83      44.090  -5.780   6.467  1.00 75.64      A    C  
ATOM    362  OD1 ASP    83      45.026  -5.529   7.263  1.00 79.90      A    O  
ATOM    363  OD2 ASP    83      43.535  -6.899   6.399  1.00 75.47      A    O  
ATOM    364  C   ASP    83      43.012  -2.238   5.307  1.00 72.04      A    C  
ATOM    365  O   ASP    83      43.717  -2.037   4.311  1.00 73.88      A    O  
ATOM    366  N   TYR    84      41.927  -1.517   5.582  1.00 69.13      A    N  
ATOM    367  CA  TYR    84      41.477  -0.450   4.687  1.00 69.06      A    C  
ATOM    368  CB  TYR    84      40.293  -0.925   3.838  1.00 67.58      A    C  
ATOM    369  CG  TYR    84      40.560  -2.187   3.072  1.00 66.36      A    C  
ATOM    370  CD1 TYR    84      41.057  -2.140   1.773  1.00 68.00      A    C  
ATOM    371  CE1 TYR    84      41.312  -3.305   1.067  1.00 69.12      A    C  
ATOM    372  CZ  TYR    84      41.063  -4.533   1.656  1.00 66.52      A    C  
ATOM    373  OH  TYR    84      41.309  -5.690   0.957  1.00 68.36      A    O  
ATOM    374  CE2 TYR    84      40.569  -4.603   2.945  1.00 65.02      A    C  
ATOM    375  CD2 TYR    84      40.318  -3.433   3.644  1.00 63.68      A    C  
ATOM    376  C   TYR    84      41.094   0.836   5.421  1.00 69.64      A    C  
ATOM    377  O   TYR    84      39.916   1.207   5.433  1.00 69.47      A    O  
ATOM    378  N   PRO    85      42.084   1.534   6.020  1.00 70.58      A    N  
ATOM    379  CA  PRO    85      41.773   2.784   6.721  1.00 70.66      A    C  
ATOM    380  CB  PRO    85      43.114   3.175   7.348  1.00 72.50      A    C  
ATOM    381  CG  PRO    85      44.141   2.518   6.489  1.00 73.96      A    C  
ATOM    382  CD  PRO    85      43.525   1.219   6.080  1.00 72.47      A    C  
ATOM    383  C   PRO    85      41.266   3.886   5.780  1.00 71.62      A    C  
ATOM    384  O   PRO    85      40.622   4.830   6.230  1.00 71.33      A    O  
ATOM    385  N   GLU    86      41.546   3.751   4.485  1.00 73.37      A    N  
ATOM    386  CA  GLU    86      41.039   4.679   3.476  1.00 75.64      A    C  
ATOM    387  CB  GLU    86      41.735   4.463   2.122  1.00 78.50      A    C  
ATOM    388  CG  GLU    86      41.443   3.121   1.422  1.00 78.65      A    C  
ATOM    389  CD  GLU    86      42.359   1.979   1.859  1.00 76.94      A    C  
ATOM    390  OE1 GLU    86      42.547   1.037   1.060  1.00 77.72      A    O  
ATOM    391  OE2 GLU    86      42.890   2.012   2.992  1.00 76.80      A    O  
ATOM    392  C   GLU    86      39.514   4.604   3.332  1.00 75.93      A    C  
ATOM    393  O   GLU    86      38.896   5.510   2.775  1.00 79.57      A    O  
ATOM    394  N   ASN    87      38.915   3.529   3.843  1.00 74.12      A    N  
ATOM    395  CA  ASN    87      37.456   3.377   3.865  1.00 73.88      A    C  
ATOM    396  CB  ASN    87      37.066   1.910   4.057  1.00 72.05      A    C  
ATOM    397  CG  ASN    87      37.319   1.066   2.821  1.00 73.77      A    C  
ATOM    398  OD1 ASN    87      37.855   1.542   1.815  1.00 75.97      A    O  
ATOM    399  ND2 ASN    87      36.926  -0.201   2.891  1.00 74.00      A    N  
ATOM    400  C   ASN    87      36.762   4.227   4.928  1.00 73.27      A    C  
ATOM    401  O   ASN    87      35.550   4.423   4.874  1.00 75.05      A    O  
ATOM    402  N   GLY    88      37.531   4.721   5.894  1.00 71.73      A    N  
ATOM    403  CA  GLY    88      36.985   5.521   6.984  1.00 70.82      A    C  
ATOM    404  C   GLY    88      36.114   4.688   7.898  1.00 69.49      A    C  
ATOM    405  O   GLY    88      36.270   3.471   7.961  1.00 68.16      A    O  
ATOM    406  N   VAL    89      35.206   5.350   8.612  1.00 70.56      A    N  
ATOM    407  CA  VAL    89      34.196   4.670   9.414  1.00 71.17      A    C  
ATOM    408  CB  VAL    89      33.888   5.413  10.748  1.00 72.80      A    C  
ATOM    409  CG1 VAL    89      32.826   4.671  11.550  1.00 73.51      A    C  
ATOM    410  CG2 VAL    89      35.142   5.548  11.580  1.00 71.42      A    C  
ATOM    411  C   VAL    89      32.928   4.502   8.570  1.00 73.41      A    C  
ATOM    412  O   VAL    89      32.409   5.472   8.000  1.00 74.86      A    O  
ATOM    413  N   VAL    90      32.453   3.258   8.493  1.00 73.03      A    N  
ATOM    414  CA  VAL    90      31.321   2.886   7.650  1.00 75.55      A    C  
ATOM    415  CB  VAL    90      31.726   1.802   6.610  1.00 73.49      A    C  
ATOM    416  CG1 VAL    90      30.564   1.471   5.676  1.00 76.90      A    C  
ATOM    417  CG2 VAL    90      32.935   2.247   5.802  1.00 72.13      A    C  
ATOM    418  C   VAL    90      30.170   2.361   8.509  1.00 78.45      A    C  
ATOM    419  O   VAL    90      30.374   1.542   9.411  1.00 77.22      A    O  
ATOM    420  N   GLN    91      28.965   2.843   8.218  1.00 83.52      A    N  
ATOM    421  CA  GLN    91      27.755   2.390   8.897  1.00 87.88      A    C  
ATOM    422  CB  GLN    91      26.682   3.467   8.832  1.00 92.88      A    C  
ATOM    423  CG  GLN    91      27.037   4.717   9.618  1.00 93.91      A    C  
ATOM    424  CD  GLN    91      25.943   5.755   9.589  1.00 99.60      A    C  
ATOM    425  OE1 GLN    91      26.208   6.939   9.389  1.00101.46      A    O  
ATOM    426  NE2 GLN    91      24.703   5.322   9.788  1.00105.50      A    N  
ATOM    427  C   GLN    91      27.243   1.090   8.293  1.00 88.99      A    C  
ATOM    428  O   GLN    91      27.083   0.980   7.079  1.00 90.22      A    O  
ATOM    429  N   MET    92      26.981   0.113   9.156  1.00 90.02      A    N  
ATOM    430  CA  MET    92      26.645  -1.241   8.737  1.00 90.94      A    C  
ATOM    431  CB  MET    92      27.692  -2.221   9.268  1.00 88.07      A    C  
ATOM    432  CG  MET    92      29.111  -1.959   8.803  1.00 88.61      A    C  
ATOM    433  SD  MET    92      29.351  -2.318   6.905  1.00 98.62      A   SE  
ATOM    434  CE  MET    92      28.929  -4.197   6.883  1.00 91.66      A    C  
ATOM    435  C   MET    92      25.273  -1.687   9.236  1.00 95.56      A    C  
ATOM    436  O   MET    92      24.911  -1.435  10.385  1.00 97.05      A    O  
ATOM    437  N   ASN    93      24.522  -2.361   8.368  1.00 97.87      A    N  
ATOM    438  CA  ASN    93      23.301  -3.045   8.779  1.00102.77      A    C  
ATOM    439  CB  ASN    93      22.460  -3.441   7.563  1.00106.54      A    C  
ATOM    440  CG  ASN    93      21.019  -3.772   7.928  1.00114.89      A    C  
ATOM    441  OD1 ASN    93      20.744  -4.745   8.638  1.00116.51      A    O  
ATOM    442  ND2 ASN    93      20.090  -2.967   7.431  1.00121.11      A    N  
ATOM    443  C   ASN    93      23.673  -4.280   9.590  1.00100.09      A    C  
ATOM    444  O   ASN    93      24.659  -4.952   9.284  1.00 94.90      A    O  
ATOM    445  N   SER    94      22.877  -4.571  10.617  1.00103.84      A    N  
ATOM    446  CA  SER    94      23.168  -5.647  11.574  1.00102.37      A    C  
ATOM    447  CB  SER    94      22.088  -5.692  12.660  1.00109.16      A    C  
ATOM    448  OG  SER    94      22.463  -6.552  13.726  1.00109.46      A    O  
ATOM    449  C   SER    94      23.328  -7.033  10.943  1.00 99.33      A    C  
ATOM    450  O   SER    94      23.924  -7.923  11.548  1.00 96.67      A    O  
ATOM    451  N   ARG    95      22.787  -7.207   9.738  1.00100.12      A    N  
ATOM    452  CA  ARG    95      22.866  -8.476   9.012  1.00 98.31      A    C  
ATOM    453  CB  ARG    95      21.658  -8.642   8.083  1.00103.51      A    C  
ATOM    454  CG  ARG    95      21.541  -7.572   7.000  1.00105.74      A    C  
ATOM    455  CD  ARG    95      20.258  -7.724   6.207  1.00112.78      A    C  
ATOM    456  NE  ARG    95      20.009  -6.556   5.366  1.00118.15      A    N  
ATOM    460  C   ARG    95      24.162  -8.567   8.214  1.00 91.56      A    C  
ATOM    461  O   ARG    95      24.609  -9.665   7.850  1.00 88.39      A    O  
ATOM    462  N   ASP    96      24.750  -7.399   7.951  1.00 89.10      A    N  
ATOM    463  CA  ASP    96      25.999  -7.276   7.205  1.00 82.96      A    C  
ATOM    464  CB  ASP    96      25.998  -5.988   6.373  1.00 83.81      A    C  
ATOM    465  CG  ASP    96      25.193  -6.112   5.088  1.00 87.00      A    C  
ATOM    466  OD1 ASP    96      24.933  -7.246   4.636  1.00 87.12      A    O  
ATOM    467  OD2 ASP    96      24.829  -5.063   4.519  1.00 89.68      A    O  
ATOM    468  C   ASP    96      27.236  -7.329   8.109  1.00 78.81      A    C  
ATOM    469  O   ASP    96      28.366  -7.175   7.633  1.00 75.79      A    O  
ATOM    470  N   VAL    97      27.025  -7.546   9.406  1.00 79.24      A    N  
ATOM    471  CA  VAL    97      28.137  -7.792  10.337  1.00 76.33      A    C  
ATOM    472  CB  VAL    97      28.549  -6.514  11.163  1.00 76.33      A    C  
ATOM    473  CG1 VAL    97      27.457  -5.473  11.146  1.00 81.16      A    C  
ATOM    474  CG2 VAL    97      28.977  -6.853  12.599  1.00 76.18      A    C  
ATOM    475  C   VAL    97      27.883  -9.017  11.216  1.00 77.38      A    C  
ATOM    476  O   VAL    97      26.768  -9.236  11.698  1.00 81.25      A    O  
ATOM    477  N   ARG    98      28.926  -9.823  11.394  1.00 73.62      A    N  
ATOM    478  CA  ARG    98      28.844 -11.037  12.197  1.00 74.98      A    C  
ATOM    479  CB  ARG    98      28.402 -12.230  11.333  1.00 74.25      A    C  
ATOM    480  CG  ARG    98      29.415 -12.653  10.279  1.00 69.79      A    C  
ATOM    481  CD  ARG    98      28.820 -13.641   9.295  1.00 70.18      A    C  
ATOM    482  NE  ARG    98      29.792 -14.010   8.269  1.00 67.23      A    N  
ATOM    483  CZ  ARG    98      29.480 -14.503   7.072  1.00 66.25      A    C  
ATOM    484  NH1 ARG    98      28.214 -14.686   6.730  1.00 69.46      A    N  
ATOM    485  NH2 ARG    98      30.438 -14.808   6.209  1.00 62.39      A    N  
ATOM    486  C   ARG    98      30.189 -11.316  12.861  1.00 73.07      A    C  
ATOM    487  O   ARG    98      31.182 -10.655  12.555  1.00 70.00      A    O  
ATOM    488  N   ALA    99      30.215 -12.295  13.763  1.00 75.78      A    N  
ATOM    489  CA  ALA    99      31.446 -12.698  14.440  1.00 76.68      A    C  
ATOM    490  CB  ALA    99      31.164 -13.801  15.444  1.00 79.68      A    C  
ATOM    491  C   ALA    99      32.484 -13.157  13.423  1.00 73.07      A    C  
ATOM    492  O   ALA    99      32.138 -13.801  12.434  1.00 72.70      A    O  
ATOM    493  N   ARG   100      33.748 -12.822  13.671  1.00 72.44      A    N  
ATOM    494  CA  ARG   100      34.839 -13.184  12.777  1.00 71.01      A    C  
ATOM    495  CB  ARG   100      36.168 -12.642  13.305  1.00 71.60      A    C  
ATOM    496  CG  ARG   100      37.275 -12.682  12.273  1.00 71.40      A    C  
ATOM    497  CD  ARG   100      38.385 -11.712  12.580  1.00 73.85      A    C  
ATOM    498  NE  ARG   100      38.010 -10.331  12.296  1.00 73.41      A    N  
ATOM    499  CZ  ARG   100      38.795  -9.285  12.528  1.00 75.14      A    C  
ATOM    500  NH1 ARG   100      38.373  -8.063  12.255  1.00 75.99      A    N  
ATOM    501  NH2 ARG   100      40.004  -9.457  13.035  1.00 80.38      A    N  
ATOM    502  C   ARG   100      34.921 -14.695  12.550  1.00 71.83      A    C  
ATOM    503  O   ARG   100      34.724 -15.474  13.472  1.00 75.13      A    O  
ATOM    504  N   ALA   101      35.185 -15.103  11.312  1.00 71.01      A    N  
ATOM    505  CA  ALA   101      35.329 -16.525  10.994  1.00 72.17      A    C  
ATOM    506  CB  ALA   101      35.429 -16.722   9.503  1.00 68.85      A    C  
ATOM    507  C   ALA   101      36.552 -17.119  11.710  1.00 75.15      A    C  
ATOM    508  O   ALA   101      37.615 -16.494  11.754  1.00 76.06      A    O  
ATOM    509  N   ARG   102      36.393 -18.307  12.292  1.00 77.04      A    N  
ATOM    510  CA  ARG   102      37.495 -18.945  13.018  1.00 80.24      A    C  
ATOM    511  CB  ARG   102      37.422 -18.649  14.532  1.00 84.15      A    C  
ATOM    512  CG  ARG   102      36.203 -19.204  15.271  1.00 87.78      A    C  
ATOM    513  CD  ARG   102      36.375 -19.083  16.790  1.00 94.35      A    C  
ATOM    514  NE  ARG   102      35.293 -19.729  17.539  1.00100.75      A    N  
ATOM    515  CZ  ARG   102      35.301 -21.003  17.926  1.00102.53      A    C  
ATOM    518  C   ARG   102      37.656 -20.449  12.745  1.00 80.42      A    C  
ATOM    519  O   ARG   102      38.732 -21.007  12.968  1.00 82.56      A    O  
ATOM    520  N   THR   103      36.603 -21.092  12.243  1.00 78.34      A    N  
ATOM    521  CA  THR   103      36.599 -22.546  12.083  1.00 78.04      A    C  
ATOM    522  CB  THR   103      35.419 -23.186  12.852  1.00 80.45      A    C  
ATOM    523  OG1 THR   103      35.405 -22.698  14.199  1.00 83.17      A    O  
ATOM    524  CG2 THR   103      35.535 -24.702  12.867  1.00 81.05      A    C  
ATOM    525  C   THR   103      36.580 -22.993  10.620  1.00 74.75      A    C  
ATOM    526  O   THR   103      35.704 -22.597   9.843  1.00 72.85      A    O  
ATOM    527  N   ILE   104      37.563 -23.816  10.260  1.00 74.51      A    N  
ATOM    528  CA  ILE   104      37.632 -24.436   8.939  1.00 71.52      A    C  
ATOM    529  CB  ILE   104      39.104 -24.721   8.524  1.00 72.44      A    C  
ATOM    530  CG1 ILE   104      39.888 -23.415   8.327  1.00 72.05      A    C  
ATOM    531  CD1 ILE   104      39.530 -22.634   7.057  1.00 70.80      A    C  
ATOM    532  CG2 ILE   104      39.176 -25.610   7.273  1.00 71.84      A    C  
ATOM    533  C   ILE   104      36.840 -25.745   8.930  1.00 72.09      A    C  
ATOM    534  O   ILE   104      37.025 -26.603   9.804  1.00 75.02      A    O  
ATOM    535  N   ILE   105      35.952 -25.885   7.951  1.00 69.18      A    N  
ATOM    536  CA  ILE   105      35.303 -27.162   7.691  1.00 69.78      A    C  
ATOM    537  CB  ILE   105      33.883 -26.988   7.109  1.00 68.99      A    C  
ATOM    538  CG1 ILE   105      33.034 -26.087   8.021  1.00 70.06      A    C  
ATOM    539  CD1 ILE   105      31.766 -25.553   7.376  1.00 68.53      A    C  
ATOM    540  CG2 ILE   105      33.218 -28.359   6.902  1.00 69.89      A    C  
ATOM    541  C   ILE   105      36.177 -27.947   6.721  1.00 69.20      A    C  
ATOM    542  O   ILE   105      36.321 -27.559   5.557  1.00 67.81      A    O  
ATOM    543  N   LYS   106      36.768 -29.036   7.213  1.00 71.18      A    N  
ATOM    544  CA  LYS   106      37.645 -29.901   6.409  1.00 71.31      A    C  
ATOM    545  CB  LYS   106      38.240 -31.027   7.268  1.00 74.66      A    C  
ATOM    546  CG  LYS   106      39.235 -30.553   8.327  1.00 78.99      A    C  
ATOM    547  CD  LYS   106      39.729 -31.711   9.190  1.00 83.40      A    C  
ATOM    550  C   LYS   106      36.906 -30.487   5.204  1.00 68.56      A    C  
ATOM    551  O   LYS   106      35.686 -30.651   5.238  1.00 67.81      A    O  
ATOM    552  N   TRP   107      37.645 -30.803   4.143  1.00 67.47      A    N  
ATOM    553  CA  TRP   107      37.031 -31.309   2.911  1.00 66.13      A    C  
ATOM    554  CB  TRP   107      38.099 -31.666   1.875  1.00 65.53      A    C  
ATOM    555  CG  TRP   107      37.617 -32.592   0.793  1.00 64.63      A    C  
ATOM    556  CD1 TRP   107      37.749 -33.948   0.764  1.00 64.45      A    C  
ATOM    557  NE1 TRP   107      37.178 -34.455  -0.377  1.00 65.36      A    N  
ATOM    558  CE2 TRP   107      36.661 -33.425  -1.117  1.00 63.71      A    C  
ATOM    559  CD2 TRP   107      36.913 -32.231  -0.408  1.00 63.14      A    C  
ATOM    560  CE3 TRP   107      36.481 -31.017  -0.957  1.00 60.76      A    C  
ATOM    561  CZ3 TRP   107      35.822 -31.035  -2.188  1.00 63.26      A    C  
ATOM    562  CH2 TRP   107      35.583 -32.242  -2.864  1.00 62.56      A    C  
ATOM    563  CZ2 TRP   107      35.996 -33.441  -2.350  1.00 63.71      A    C  
ATOM    564  C   TRP   107      36.088 -32.487   3.158  1.00 68.02      A    C  
ATOM    565  O   TRP   107      35.038 -32.587   2.516  1.00 67.19      A    O  
ATOM    566  N   GLN   108      36.462 -33.367   4.090  1.00 81.54      A    N  
ATOM    567  CA  GLN   108      35.651 -34.544   4.428  1.00 86.61      A    C  
ATOM    568  CB  GLN   108      36.355 -35.444   5.453  1.00 94.14      A    C  
ATOM    569  CG  GLN   108      37.838 -35.684   5.202  1.00100.96      A    C  
ATOM    570  CD  GLN   108      38.722 -34.745   6.006  1.00102.76      A    C  
ATOM    571  OE1 GLN   108      39.223 -33.746   5.486  1.00 97.70      A    O  
ATOM    572  NE2 GLN   108      38.908 -35.060   7.288  1.00109.40      A    N  
ATOM    573  C   GLN   108      34.288 -34.148   4.977  1.00 84.65      A    C  
ATOM    574  O   GLN   108      33.279 -34.788   4.683  1.00 85.99      A    O  
ATOM    575  N   ASP   109      34.272 -33.087   5.776  1.00 83.07      A    N  
ATOM    576  CA  ASP   109      33.076 -32.667   6.485  1.00 82.93      A    C  
ATOM    577  CB  ASP   109      33.458 -32.054   7.837  1.00 85.14      A    C  
ATOM    578  CG  ASP   109      33.997 -33.091   8.823  1.00 92.55      A    C  
ATOM    579  OD1 ASP   109      33.546 -34.258   8.794  1.00 96.19      A    O  
ATOM    580  OD2 ASP   109      34.871 -32.738   9.637  1.00 95.06      A    O  
ATOM    581  C   ASP   109      32.200 -31.720   5.661  1.00 77.96      A    C  
ATOM    582  O   ASP   109      31.094 -31.376   6.079  1.00 78.84      A    O  
ATOM    583  N   LEU   110      32.685 -31.320   4.488  1.00 74.26      A    N  
ATOM    584  CA  LEU   110      31.899 -30.489   3.577  1.00 70.92      A    C  
ATOM    585  CB  LEU   110      32.768 -29.936   2.443  1.00 67.27      A    C  
ATOM    586  CG  LEU   110      33.781 -28.845   2.798  1.00 65.09      A    C  
ATOM    587  CD1 LEU   110      34.700 -28.569   1.631  1.00 63.20      A    C  
ATOM    588  CD2 LEU   110      33.085 -27.570   3.234  1.00 62.99      A    C  
ATOM    589  C   LEU   110      30.732 -31.285   3.010  1.00 73.58      A    C  
ATOM    590  O   LEU   110      30.908 -32.409   2.549  1.00 76.26      A    O  
ATOM    591  N   GLU   111      29.540 -30.700   3.062  1.00 74.24      A    N  
ATOM    592  CA  GLU   111      28.329 -31.373   2.607  1.00 78.02      A    C  
ATOM    593  CB  GLU   111      27.497 -31.848   3.800  1.00 82.71      A    C  
ATOM    594  CG  GLU   111      28.116 -33.011   4.560  1.00 90.53      A    C  
ATOM    595  CD  GLU   111      27.602 -33.126   5.988  1.00 98.41      A    C  
ATOM    596  OE1 GLU   111      26.455 -33.590   6.180  1.00102.57      A    O  
ATOM    597  OE2 GLU   111      28.355 -32.761   6.920  1.00100.99      A    O  
ATOM    598  C   GLU   111      27.490 -30.469   1.715  1.00 76.64      A    C  
ATOM    599  O   GLU   111      27.457 -29.251   1.901  1.00 75.67      A    O  
ATOM    600  N   VAL   112      26.813 -31.083   0.749  1.00 78.34      A    N  
ATOM    601  CA  VAL   112      25.915 -30.384  -0.168  1.00 77.86      A    C  
ATOM    602  CB  VAL   112      25.330 -31.365  -1.218  1.00 81.46      A    C  
ATOM    603  CG1 VAL   112      24.284 -30.689  -2.078  1.00 82.23      A    C  
ATOM    604  CG2 VAL   112      26.442 -31.937  -2.088  1.00 78.08      A    C  
ATOM    605  C   VAL   112      24.794 -29.655   0.586  1.00 80.43      A    C  
ATOM    606  O   VAL   112      24.029 -30.264   1.345  1.00 83.79      A    O  
ATOM    607  N   GLY   113      24.722 -28.342   0.386  1.00 79.05      A    N  
ATOM    608  CA  GLY   113      23.639 -27.542   0.943  1.00 82.32      A    C  
ATOM    609  C   GLY   113      24.029 -26.621   2.082  1.00 81.33      A    C  
ATOM    610  O   GLY   113      23.254 -25.742   2.463  1.00 84.67      A    O  
ATOM    611  N   GLN   114      25.226 -26.827   2.628  1.00 77.51      A    N  
ATOM    612  CA  GLN   114      25.771 -25.961   3.668  1.00 76.18      A    C  
ATOM    613  CB  GLN   114      27.088 -26.527   4.198  1.00 74.01      A    C  
ATOM    614  CG  GLN   114      26.983 -27.842   4.950  1.00 78.35      A    C  
ATOM    615  CD  GLN   114      28.343 -28.391   5.344  1.00 76.40      A    C  
ATOM    616  OE1 GLN   114      29.316 -28.243   4.614  1.00 73.16      A    O  
ATOM    617  NE2 GLN   114      28.412 -29.031   6.502  1.00 82.18      A    N  
ATOM    618  C   GLN   114      26.038 -24.559   3.130  1.00 73.65      A    C  
ATOM    619  O   GLN   114      26.486 -24.404   1.987  1.00 70.71      A    O  
ATOM    620  N   VAL   115      25.760 -23.544   3.949  1.00 75.05      A    N  
ATOM    621  CA  VAL   115      26.222 -22.194   3.640  1.00 72.83      A    C  
ATOM    622  CB  VAL   115      25.147 -21.100   3.813  1.00 76.99      A    C  
ATOM    623  CG1 VAL   115      23.943 -21.419   2.939  1.00 81.10      A    C  
ATOM    624  CG2 VAL   115      24.744 -20.935   5.272  1.00 83.11      A    C  
ATOM    625  C   VAL   115      27.496 -21.896   4.416  1.00 70.02      A    C  
ATOM    626  O   VAL   115      27.543 -21.972   5.652  1.00 71.87      A    O  
ATOM    627  N   VAL   116      28.535 -21.575   3.657  1.00 65.64      A    N  
ATOM    628  CA  VAL   116      29.880 -21.463   4.175  1.00 63.59      A    C  
ATOM    629  CB  VAL   116      30.730 -22.663   3.704  1.00 62.16      A    C  
ATOM    630  CG1 VAL   116      30.220 -23.965   4.306  1.00 63.67      A    C  
ATOM    631  CG2 VAL   116      30.729 -22.751   2.189  1.00 60.61      A    C  
ATOM    632  C   VAL   116      30.519 -20.168   3.671  1.00 62.26      A    C  
ATOM    633  O   VAL   116      29.996 -19.539   2.752  1.00 61.77      A    O  
ATOM    634  N   MET   117      31.639 -19.770   4.276  1.00 61.42      A    N  
ATOM    635  CA  MET   117      32.456 -18.698   3.712  1.00 60.96      A    C  
ATOM    636  CB  MET   117      32.820 -17.642   4.757  1.00 61.90      A    C  
ATOM    637  CG  MET   117      33.221 -16.318   4.116  1.00 62.48      A    C  
ATOM    638  SD  MET   117      33.916 -15.018   5.390  1.00 66.12      A   SE  
ATOM    639  CE  MET   117      35.602 -15.886   5.817  1.00 66.17      A    C  
ATOM    640  C   MET   117      33.716 -19.269   3.064  1.00 58.29      A    C  
ATOM    641  O   MET   117      34.464 -20.014   3.688  1.00 59.06      A    O  
ATOM    642  N   LEU   118      33.946 -18.901   1.812  1.00 57.12      A    N  
ATOM    643  CA  LEU   118      35.039 -19.463   1.034  1.00 56.29      A    C  
ATOM    644  CB  LEU   118      34.557 -20.698   0.265  1.00 56.76      A    C  
ATOM    645  CG  LEU   118      33.252 -20.615  -0.531  1.00 57.64      A    C  
ATOM    646  CD1 LEU   118      33.420 -19.891  -1.874  1.00 59.59      A    C  
ATOM    647  CD2 LEU   118      32.730 -22.021  -0.747  1.00 60.22      A    C  
ATOM    648  C   LEU   118      35.646 -18.452   0.064  1.00 56.96      A    C  
ATOM    649  O   LEU   118      35.047 -17.412  -0.233  1.00 57.12      A    O  
ATOM    650  N   ASN   119      36.832 -18.789  -0.438  1.00 56.86      A    N  
ATOM    651  CA  ASN   119      37.591 -17.907  -1.306  1.00 57.26      A    C  
ATOM    652  CB  ASN   119      39.094 -18.065  -1.047  1.00 58.13      A    C  
ATOM    653  CG  ASN   119      39.881 -16.825  -1.412  1.00 59.37      A    C  
ATOM    654  OD1 ASN   119      40.059 -16.510  -2.592  1.00 52.64      A    O  
ATOM    655  ND2 ASN   119      40.346 -16.097  -0.389  1.00 56.44      A    N  
ATOM    656  C   ASN   119      37.264 -18.177  -2.756  1.00 58.04      A    C  
ATOM    657  O   ASN   119      37.354 -19.312  -3.229  1.00 59.26      A    O  
ATOM    658  N   TYR   120      36.866 -17.127  -3.459  1.00 58.92      A    N  
ATOM    659  CA  TYR   120      36.514 -17.235  -4.856  1.00 58.75      A    C  
ATOM    660  CB  TYR   120      35.028 -17.595  -4.993  1.00 60.08      A    C  
ATOM    661  CG  TYR   120      34.561 -17.864  -6.416  1.00 63.34      A    C  
ATOM    662  CD1 TYR   120      35.007 -18.984  -7.126  1.00 65.99      A    C  
ATOM    663  CE1 TYR   120      34.575 -19.233  -8.437  1.00 67.83      A    C  
ATOM    664  CZ  TYR   120      33.681 -18.356  -9.046  1.00 74.16      A    C  
ATOM    665  OH  TYR   120      33.240 -18.592 -10.343  1.00 80.05      A    O  
ATOM    666  CE2 TYR   120      33.219 -17.243  -8.356  1.00 72.18      A    C  
ATOM    667  CD2 TYR   120      33.662 -17.003  -7.047  1.00 68.44      A    C  
ATOM    668  C   TYR   120      36.837 -15.934  -5.568  1.00 61.83      A    C  
ATOM    669  O   TYR   120      36.938 -14.887  -4.938  1.00 58.65      A    O  
ATOM    670  N   ASN   121      36.987 -16.005  -6.894  1.00 66.19      A    N  
ATOM    671  CA  ASN   121      37.288 -14.834  -7.695  1.00 69.65      A    C  
ATOM    672  CB  ASN   121      38.759 -14.832  -8.091  1.00 71.49      A    C  
ATOM    673  CG  ASN   121      39.213 -13.497  -8.646  1.00 78.45      A    C  
ATOM    674  OD1 ASN   121      38.577 -12.918  -9.538  1.00 85.52      A    O  
ATOM    675  ND2 ASN   121      40.341 -13.013  -8.144  1.00 77.55      A    N  
ATOM    676  C   ASN   121      36.384 -14.766  -8.924  1.00 77.49      A    C  
ATOM    677  O   ASN   121      36.703 -15.335  -9.972  1.00 78.65      A    O  
ATOM    678  N   PRO   122      35.246 -14.063  -8.791  1.00 80.08      A    N  
ATOM    679  CA  PRO   122      34.210 -13.957  -9.812  1.00 86.20      A    C  
ATOM    680  CB  PRO   122      33.292 -12.865  -9.259  1.00 86.42      A    C  
ATOM    681  CG  PRO   122      33.448 -12.974  -7.791  1.00 82.10      A    C  
ATOM    682  CD  PRO   122      34.890 -13.316  -7.567  1.00 76.62      A    C  
ATOM    683  C   PRO   122      34.740 -13.582 -11.205  1.00 95.34      A    C  
ATOM    684  O   PRO   122      34.304 -14.165 -12.200  1.00 98.08      A    O  
ATOM    685  N   ASP   123      35.680 -12.637 -11.255  1.00 98.70      A    N  
ATOM    686  CA  ASP   123      36.210 -12.096 -12.512  1.00107.79      A    C  
ATOM    687  CB  ASP   123      36.952 -10.783 -12.250  1.00110.01      A    C  
ATOM    688  CG  ASP   123      36.012  -9.599 -12.080  1.00113.62      A    C  
ATOM    689  OD1 ASP   123      35.072  -9.457 -12.894  1.00118.87      A    O  
ATOM    690  OD2 ASP   123      36.223  -8.800 -11.140  1.00109.85      A    O  
ATOM    691  C   ASP   123      37.124 -13.073 -13.247  1.00110.22      A    C  
ATOM    692  O   ASP   123      37.163 -13.092 -14.484  1.00119.05      A    O  
ATOM    693  N   ASN   124      37.868 -13.860 -12.472  1.00104.22      A    N  
ATOM    694  CA  ASN   124      38.691 -14.958 -12.984  1.00106.51      A    C  
ATOM    695  CB  ASN   124      40.090 -14.477 -13.400  1.00111.43      A    C  
ATOM    696  CG  ASN   124      40.625 -13.375 -12.508  1.00109.34      A    C  
ATOM    697  OD1 ASN   124      40.850 -12.255 -12.961  1.00114.42      A    O  
ATOM    698  ND2 ASN   124      40.823 -13.685 -11.229  1.00102.69      A    N  
ATOM    699  C   ASN   124      38.754 -16.096 -11.960  1.00 99.63      A    C  
ATOM    700  O   ASN   124      39.585 -16.073 -11.036  1.00 94.87      A    O  
ATOM    701  N   PRO   125      37.834 -17.072 -12.096  1.00 98.76      A    N  
ATOM    702  CA  PRO   125      37.609 -18.161 -11.135  1.00 93.07      A    C  
ATOM    703  CB  PRO   125      36.475 -18.965 -11.787  1.00 95.03      A    C  
ATOM    704  CG  PRO   125      35.763 -17.960 -12.623  1.00100.37      A    C  
ATOM    705  CD  PRO   125      36.874 -17.146 -13.209  1.00104.85      A    C  
ATOM    706  C   PRO   125      38.812 -19.059 -10.845  1.00 92.16      A    C  
ATOM    707  O   PRO   125      38.794 -19.805  -9.862  1.00 88.10      A    O  
ATOM    708  N   LYS   126      39.842 -18.980 -11.681  1.00 97.48      A    N  
ATOM    709  CA  LYS   126      41.031 -19.804 -11.512  1.00 97.83      A    C  
ATOM    710  CB  LYS   126      41.771 -19.925 -12.846  1.00106.86      A    C  
ATOM    711  CG  LYS   126      42.246 -21.332 -13.163  1.00110.33      A    C  
ATOM    712  CD  LYS   126      42.605 -21.471 -14.634  1.00120.99      A    C  
ATOM    715  C   LYS   126      41.958 -19.245 -10.424  1.00 93.86      A    C  
ATOM    716  O   LYS   126      42.812 -19.961  -9.895  1.00 93.82      A    O  
ATOM    717  N   GLU   127      41.772 -17.973 -10.080  1.00 90.96      A    N  
ATOM    718  CA  GLU   127      42.707 -17.271  -9.204  1.00 89.03      A    C  
ATOM    719  CB  GLU   127      43.092 -15.909  -9.803  1.00 93.54      A    C  
ATOM    720  CG  GLU   127      43.371 -15.901 -11.315  1.00103.30      A    C  
ATOM    721  CD  GLU   127      44.637 -16.650 -11.711  1.00110.07      A    C  
ATOM    722  OE1 GLU   127      45.603 -16.662 -10.911  1.00107.71      A    O  
ATOM    723  OE2 GLU   127      44.666 -17.215 -12.835  1.00117.64      A    O  
ATOM    724  C   GLU   127      42.157 -17.070  -7.795  1.00 81.22      A    C  
ATOM    725  O   GLU   127      40.973 -17.283  -7.540  1.00 77.05      A    O  
ATOM    726  N   ARG   128      43.042 -16.663  -6.890  1.00 79.99      A    N  
ATOM    727  CA  ARG   128      42.665 -16.219  -5.550  1.00 75.18      A    C  
ATOM    728  CB  ARG   128      43.931 -15.974  -4.728  1.00 76.60      A    C  
ATOM    729  CG  ARG   128      43.724 -15.886  -3.242  1.00 73.49      A    C  
ATOM    730  CD  ARG   128      44.193 -17.147  -2.542  1.00 75.64      A    C  
ATOM    731  NE  ARG   128      43.646 -17.232  -1.188  1.00 72.47      A    N  
ATOM    732  CZ  ARG   128      43.729 -18.300  -0.402  1.00 70.66      A    C  
ATOM    733  NH1 ARG   128      44.344 -19.402  -0.816  1.00 72.28      A    N  
ATOM    734  NH2 ARG   128      43.187 -18.265   0.806  1.00 68.19      A    N  
ATOM    735  C   ARG   128      41.853 -14.923  -5.645  1.00 73.74      A    C  
ATOM    736  O   ARG   128      42.171 -14.051  -6.458  1.00 78.40      A    O  
ATOM    737  N   GLY   129      40.801 -14.816  -4.832  1.00 68.65      A    N  
ATOM    738  CA  GLY   129      39.968 -13.607  -4.753  1.00 67.08      A    C  
ATOM    739  C   GLY   129      39.572 -13.235  -3.324  1.00 63.44      A    C  
ATOM    740  O   GLY   129      40.431 -13.034  -2.461  1.00 62.31      A    O  
ATOM    741  N   PHE   130      38.265 -13.163  -3.078  1.00 61.38      A    N  
ATOM    742  CA  PHE   130      37.728 -12.673  -1.812  1.00 59.66      A    C  
ATOM    743  CB  PHE   130      36.996 -11.352  -2.025  1.00 63.17      A    C  
ATOM    744  CG  PHE   130      37.902 -10.225  -2.408  1.00 68.02      A    C  
ATOM    745  CD1 PHE   130      38.714  -9.614  -1.451  1.00 66.81      A    C  
ATOM    746  CE1 PHE   130      39.567  -8.575  -1.803  1.00 70.40      A    C  
ATOM    747  CZ  PHE   130      39.615  -8.142  -3.122  1.00 73.35      A    C  
ATOM    748  CE2 PHE   130      38.814  -8.750  -4.085  1.00 74.05      A    C  
ATOM    749  CD2 PHE   130      37.966  -9.788  -3.726  1.00 69.66      A    C  
ATOM    750  C   PHE   130      36.801 -13.666  -1.143  1.00 57.34      A    C  
ATOM    751  O   PHE   130      36.334 -14.608  -1.796  1.00 55.77      A    O  
ATOM    752  N   TRP   131      36.561 -13.442   0.159  1.00 49.70      A    N  
ATOM    753  CA  TRP   131      35.706 -14.272   0.989  1.00 51.23      A    C  
ATOM    754  CB  TRP   131      36.162 -14.149   2.445  1.00 50.95      A    C  
ATOM    755  CG  TRP   131      37.572 -14.545   2.508  1.00 47.90      A    C  
ATOM    756  CD1 TRP   131      38.665 -13.738   2.335  1.00 46.38      A    C  
ATOM    757  NE1 TRP   131      39.818 -14.490   2.399  1.00 43.72      A    N  
ATOM    758  CE2 TRP   131      39.480 -15.811   2.579  1.00 43.47      A    C  
ATOM    759  CD2 TRP   131      38.070 -15.884   2.632  1.00 47.54      A    C  
ATOM    760  CE3 TRP   131      37.460 -17.139   2.809  1.00 50.34      A    C  
ATOM    761  CZ3 TRP   131      38.272 -18.267   2.948  1.00 49.31      A    C  
ATOM    762  CH2 TRP   131      39.676 -18.159   2.898  1.00 47.35      A    C  
ATOM    763  CZ2 TRP   131      40.296 -16.946   2.703  1.00 45.25      A    C  
ATOM    764  C   TRP   131      34.214 -13.976   0.855  1.00 56.74      A    C  
ATOM    765  O   TRP   131      33.694 -13.045   1.493  1.00 58.95      A    O  
ATOM    766  N   TYR   132      33.546 -14.787   0.027  1.00 57.70      A    N  
ATOM    767  CA  TYR   132      32.093 -14.756  -0.155  1.00 62.06      A    C  
ATOM    768  CB  TYR   132      31.738 -14.902  -1.640  1.00 64.36      A    C  
ATOM    769  CG  TYR   132      32.346 -13.845  -2.512  1.00 66.16      A    C  
ATOM    770  CD1 TYR   132      31.693 -12.636  -2.724  1.00 69.59      A    C  
ATOM    771  CE1 TYR   132      32.252 -11.656  -3.516  1.00 70.75      A    C  
ATOM    772  CZ  TYR   132      33.480 -11.880  -4.109  1.00 68.34      A    C  
ATOM    773  OH  TYR   132      34.038 -10.905  -4.903  1.00 72.83      A    O  
ATOM    774  CE2 TYR   132      34.149 -13.073  -3.917  1.00 64.55      A    C  
ATOM    775  CD2 TYR   132      33.579 -14.048  -3.122  1.00 64.03      A    C  
ATOM    776  C   TYR   132      31.413 -15.900   0.577  1.00 61.98      A    C  
ATOM    777  O   TYR   132      32.010 -16.959   0.773  1.00 60.18      A    O  
ATOM    778  N   ASP   133      30.155 -15.686   0.959  1.00 64.85      A    N  
ATOM    779  CA  ASP   133      29.273 -16.783   1.352  1.00 65.55      A    C  
ATOM    780  CB  ASP   133      28.057 -16.258   2.099  1.00 68.42      A    C  
ATOM    781  CG  ASP   133      28.402 -15.750   3.477  1.00 69.42      A    C  
ATOM    782  OD1 ASP   133      29.599 -15.713   3.823  1.00 64.53      A    O  
ATOM    783  OD2 ASP   133      27.468 -15.378   4.215  1.00 76.31      A    O  
ATOM    784  C   ASP   133      28.823 -17.591   0.136  1.00 66.63      A    C  
ATOM    785  O   ASP   133      28.615 -17.038  -0.950  1.00 67.26      A    O  
ATOM    786  N   ALA   134      28.668 -18.897   0.333  1.00 65.82      A    N  
ATOM    787  CA  ALA   134      28.311 -19.804  -0.745  1.00 67.57      A    C  
ATOM    788  CB  ALA   134      29.558 -20.239  -1.510  1.00 64.02      A    C  
ATOM    789  C   ALA   134      27.558 -21.022  -0.232  1.00 69.20      A    C  
ATOM    790  O   ALA   134      27.790 -21.492   0.884  1.00 68.34      A    O  
ATOM    791  N   GLU   135      26.655 -21.525  -1.066  1.00 72.04      A    N  
ATOM    792  CA  GLU   135      25.925 -22.744  -0.785  1.00 72.93      A    C  
ATOM    793  CB  GLU   135      24.484 -22.591  -1.263  1.00 77.11      A    C  
ATOM    794  CG  GLU   135      23.524 -23.682  -0.821  1.00 78.37      A    C  
ATOM    795  CD  GLU   135      22.088 -23.368  -1.212  1.00 84.76      A    C  
ATOM    796  OE1 GLU   135      21.844 -23.039  -2.399  1.00 85.93      A    O  
ATOM    797  OE2 GLU   135      21.203 -23.447  -0.328  1.00 88.15      A    O  
ATOM    798  C   GLU   135      26.616 -23.878  -1.529  1.00 71.76      A    C  
ATOM    799  O   GLU   135      26.707 -23.854  -2.758  1.00 73.06      A    O  
ATOM    800  N   ILE   136      27.121 -24.862  -0.792  1.00 69.88      A    N  
ATOM    801  CA  ILE   136      27.764 -26.015  -1.425  1.00 68.91      A    C  
ATOM    802  CB  ILE   136      28.472 -26.926  -0.400  1.00 67.43      A    C  
ATOM    803  CG1 ILE   136      29.694 -26.201   0.170  1.00 62.29      A    C  
ATOM    804  CD1 ILE   136      29.976 -26.548   1.601  1.00 63.43      A    C  
ATOM    805  CG2 ILE   136      28.913 -28.244  -1.043  1.00 67.94      A    C  
ATOM    806  C   ILE   136      26.741 -26.759  -2.275  1.00 72.33      A    C  
ATOM    807  O   ILE   136      25.671 -27.145  -1.795  1.00 74.69      A    O  
ATOM    808  N   SER   137      27.080 -26.921  -3.548  1.00 72.39      A    N  
ATOM    809  CA  SER   137      26.134 -27.344  -4.560  1.00 76.27      A    C  
ATOM    810  CB  SER   137      26.209 -26.382  -5.745  1.00 76.90      A    C  
ATOM    811  OG  SER   137      25.221 -26.684  -6.705  1.00 82.68      A    O  
ATOM    812  C   SER   137      26.401 -28.785  -5.001  1.00 77.57      A    C  
ATOM    813  O   SER   137      25.517 -29.638  -4.931  1.00 79.63      A    O  
ATOM    814  N   ARG   138      27.628 -29.038  -5.451  1.00 76.31      A    N  
ATOM    815  CA  ARG   138      28.067 -30.361  -5.869  1.00 77.35      A    C  
ATOM    816  CB  ARG   138      28.178 -30.448  -7.393  1.00 79.55      A    C  
ATOM    817  CG  ARG   138      26.877 -30.215  -8.119  1.00 85.11      A    C  
ATOM    818  CD  ARG   138      26.947 -30.659  -9.564  1.00 89.42      A    C  
ATOM    819  NE  ARG   138      27.580 -29.666 -10.429  1.00 89.97      A    N  
ATOM    820  CZ  ARG   138      28.649 -29.898 -11.183  1.00 89.04      A    C  
ATOM    821  NH1 ARG   138      29.145 -28.930 -11.941  1.00 88.78      A    N  
ATOM    822  NH2 ARG   138      29.218 -31.098 -11.191  1.00 89.11      A    N  
ATOM    823  C   ARG   138      29.419 -30.657  -5.251  1.00 74.79      A    C  
ATOM    824  O   ARG   138      30.264 -29.765  -5.126  1.00 71.88      A    O  
ATOM    825  N   LYS   139      29.613 -31.914  -4.866  1.00 75.98      A    N  
ATOM    826  CA  LYS   139      30.874 -32.372  -4.306  1.00 74.86      A    C  
ATOM    827  CB  LYS   139      30.779 -32.469  -2.782  1.00 73.48      A    C  
ATOM    828  CG  LYS   139      32.087 -32.834  -2.115  1.00 71.58      A    C  
ATOM    829  CD  LYS   139      31.904 -32.996  -0.626  1.00 72.19      A    C  
ATOM    830  CE  LYS   139      33.155 -33.579  -0.006  1.00 72.78      A    C  
ATOM    831  NZ  LYS   139      32.987 -33.821   1.453  1.00 73.28      A    N  
ATOM    832  C   LYS   139      31.272 -33.712  -4.933  1.00 77.81      A    C  
ATOM    833  O   LYS   139      30.529 -34.697  -4.856  1.00 79.78      A    O  
ATOM    834  N   ARG   140      32.446 -33.724  -5.561  1.00 77.81      A    N  
ATOM    835  CA  ARG   140      32.943 -34.878  -6.310  1.00 80.86      A    C  
ATOM    836  CB  ARG   140      32.831 -34.614  -7.815  1.00 83.30      A    C  
ATOM    837  CG  ARG   140      31.731 -35.391  -8.524  1.00 91.05      A    C  
ATOM    838  CD  ARG   140      32.212 -36.778  -8.943  1.00 96.65      A    C  
ATOM    839  NE  ARG   140      33.416 -36.699  -9.771  1.00 98.96      A    N  
ATOM    840  CZ  ARG   140      33.469 -36.995 -11.067  1.00103.38      A    C  
ATOM    841  NH1 ARG   140      32.384 -37.411 -11.709  1.00108.22      A    N  
ATOM    842  NH2 ARG   140      34.617 -36.887 -11.723  1.00103.90      A    N  
ATOM    843  C   ARG   140      34.393 -35.183  -5.967  1.00 79.17      A    C  
ATOM    844  O   ARG   140      35.221 -34.279  -5.877  1.00 76.53      A    O  
ATOM    845  N   GLU   141      34.702 -36.461  -5.784  1.00 80.97      A    N  
ATOM    846  CA  GLU   141      36.079 -36.872  -5.552  1.00 80.09      A    C  
ATOM    847  CB  GLU   141      36.318 -37.213  -4.081  1.00 78.65      A    C  
ATOM    848  CG  GLU   141      37.779 -37.137  -3.680  1.00 78.55      A    C  
ATOM    849  CD  GLU   141      38.015 -37.247  -2.182  1.00 77.93      A    C  
ATOM    850  OE1 GLU   141      37.038 -37.196  -1.405  1.00 78.44      A    O  
ATOM    851  OE2 GLU   141      39.194 -37.383  -1.781  1.00 77.29      A    O  
ATOM    852  C   GLU   141      36.508 -38.020  -6.465  1.00 83.79      A    C  
ATOM    853  O   GLU   141      35.761 -38.959  -6.720  1.00 86.12      A    O  
ATOM    854  N   THR   142      37.732 -37.899  -6.956  1.00 63.92      A    N  
ATOM    855  CA  THR   142      38.372 -38.851  -7.848  1.00 63.74      A    C  
ATOM    856  CB  THR   142      38.654 -38.156  -9.215  1.00 66.30      A    C  
ATOM    857  OG1 THR   142      37.666 -38.567 -10.168  1.00 66.73      A    O  
ATOM    858  CG2 THR   142      40.026 -38.473  -9.776  1.00 71.31      A    C  
ATOM    859  C   THR   142      39.630 -39.330  -7.117  1.00 63.29      A    C  
ATOM    860  O   THR   142      39.944 -38.823  -6.025  1.00 64.51      A    O  
ATOM    861  N   ARG   143      40.326 -40.317  -7.675  1.00 63.14      A    N  
ATOM    862  CA  ARG   143      41.597 -40.770  -7.109  1.00 63.64      A    C  
ATOM    863  CB  ARG   143      42.221 -41.858  -7.977  1.00 64.32      A    C  
ATOM    864  CG  ARG   143      41.596 -43.245  -7.869  1.00 64.07      A    C  
ATOM    865  CD  ARG   143      42.347 -44.211  -8.831  1.00 64.06      A    C  
ATOM    866  NE  ARG   143      41.787 -45.568  -8.930  1.00 62.34      A    N  
ATOM    867  CZ  ARG   143      41.671 -46.437  -7.915  1.00 62.98      A    C  
ATOM    868  NH1 ARG   143      42.045 -46.114  -6.669  1.00 52.94      A    N  
ATOM    869  NH2 ARG   143      41.163 -47.643  -8.148  1.00 61.64      A    N  
ATOM    870  C   ARG   143      42.601 -39.619  -6.916  1.00 65.93      A    C  
ATOM    871  O   ARG   143      43.346 -39.596  -5.929  1.00 67.55      A    O  
ATOM    872  N   THR   144      42.601 -38.666  -7.848  1.00 67.27      A    N  
ATOM    873  CA  THR   144      43.565 -37.562  -7.855  1.00 71.21      A    C  
ATOM    874  CB  THR   144      44.425 -37.591  -9.130  1.00 74.46      A    C  
ATOM    875  OG1 THR   144      43.566 -37.704 -10.270  1.00 74.50      A    O  
ATOM    876  CG2 THR   144      45.397 -38.767  -9.108  1.00 73.69      A    C  
ATOM    877  C   THR   144      42.938 -36.165  -7.756  1.00 73.03      A    C  
ATOM    878  O   THR   144      43.651 -35.186  -7.568  1.00 77.46      A    O  
ATOM    879  N   ALA   145      41.617 -36.073  -7.882  1.00 71.51      A    N  
ATOM    880  CA  ALA   145      40.935 -34.776  -7.947  1.00 73.21      A    C  
ATOM    881  CB  ALA   145      40.374 -34.544  -9.350  1.00 74.63      A    C  
ATOM    882  C   ALA   145      39.825 -34.619  -6.906  1.00 70.73      A    C  
ATOM    883  O   ALA   145      39.049 -35.544  -6.667  1.00 68.81      A    O  
ATOM    884  N   ARG   146      39.765 -33.441  -6.291  1.00 72.52      A    N  
ATOM    885  CA  ARG   146      38.660 -33.067  -5.401  1.00 71.12      A    C  
ATOM    886  CB  ARG   146      39.164 -32.716  -4.001  1.00 70.21      A    C  
ATOM    887  CG  ARG   146      39.659 -33.912  -3.215  1.00 70.44      A    C  
ATOM    888  CD  ARG   146      40.246 -33.502  -1.882  1.00 72.19      A    C  
ATOM    889  NE  ARG   146      41.331 -32.537  -2.043  1.00 76.34      A    N  
ATOM    890  CZ  ARG   146      41.717 -31.677  -1.105  1.00 79.37      A    C  
ATOM    891  NH1 ARG   146      41.109 -31.647   0.073  1.00 79.76      A    N  
ATOM    892  NH2 ARG   146      42.708 -30.834  -1.349  1.00 84.02      A    N  
ATOM    893  C   ARG   146      37.908 -31.892  -6.008  1.00 72.38      A    C  
ATOM    894  O   ARG   146      38.483 -30.830  -6.257  1.00 76.52      A    O  
ATOM    895  N   GLU   147      36.620 -32.088  -6.255  1.00 70.89      A    N  
ATOM    896  CA  GLU   147      35.828 -31.092  -6.962  1.00 72.27      A    C  
ATOM    897  CB  GLU   147      35.261 -31.688  -8.251  1.00 73.83      A    C  
ATOM    898  CG  GLU   147      36.336 -32.129  -9.238  1.00 78.97      A    C  
ATOM    899  CD  GLU   147      35.844 -33.164 -10.233  1.00 82.68      A    C  
ATOM    900  OE1 GLU   147      34.708 -33.023 -10.738  1.00 85.63      A    O  
ATOM    901  OE2 GLU   147      36.602 -34.121 -10.510  1.00 83.65      A    O  
ATOM    902  C   GLU   147      34.718 -30.537  -6.081  1.00 69.40      A    C  
ATOM    903  O   GLU   147      33.914 -31.289  -5.531  1.00 67.18      A    O  
ATOM    904  N   LEU   148      34.692 -29.215  -5.949  1.00 69.74      A    N  
ATOM    905  CA  LEU   148      33.662 -28.544  -5.175  1.00 67.30      A    C  
ATOM    906  CB  LEU   148      34.243 -27.963  -3.884  1.00 66.54      A    C  
ATOM    907  CG  LEU   148      33.276 -27.429  -2.823  1.00 64.58      A    C  
ATOM    908  CD1 LEU   148      32.415 -28.550  -2.267  1.00 59.27      A    C  
ATOM    909  CD2 LEU   148      34.048 -26.727  -1.710  1.00 63.81      A    C  
ATOM    910  C   LEU   148      32.982 -27.463  -6.002  1.00 70.05      A    C  
ATOM    911  O   LEU   148      33.641 -26.629  -6.631  1.00 72.97      A    O  
ATOM    912  N   TYR   149      31.654 -27.507  -6.004  1.00 69.71      A    N  
ATOM    913  CA  TYR   149      30.842 -26.527  -6.707  1.00 71.79      A    C  
ATOM    914  CB  TYR   149      30.053 -27.187  -7.847  1.00 74.98      A    C  
ATOM    915  CG  TYR   149      30.963 -27.719  -8.929  1.00 78.32      A    C  
ATOM    916  CD1 TYR   149      31.505 -29.004  -8.844  1.00 76.82      A    C  
ATOM    917  CE1 TYR   149      32.363 -29.492  -9.827  1.00 79.06      A    C  
ATOM    918  CZ  TYR   149      32.694 -28.685 -10.903  1.00 84.35      A    C  
ATOM    919  OH  TYR   149      33.544 -29.160 -11.878  1.00 88.75      A    O  
ATOM    920  CE2 TYR   149      32.173 -27.404 -11.008  1.00 86.90      A    C  
ATOM    921  CD2 TYR   149      31.317 -26.926 -10.020  1.00 83.14      A    C  
ATOM    922  C   TYR   149      29.935 -25.839  -5.704  1.00 69.60      A    C  
ATOM    923  O   TYR   149      29.459 -26.466  -4.757  1.00 67.80      A    O  
ATOM    924  N   ALA   150      29.723 -24.543  -5.896  1.00 70.24      A    N  
ATOM    925  CA  ALA   150      28.964 -23.765  -4.941  1.00 68.76      A    C  
ATOM    926  CB  ALA   150      29.885 -23.235  -3.834  1.00 67.20      A    C  
ATOM    927  C   ALA   150      28.202 -22.625  -5.596  1.00 72.22      A    C  
ATOM    928  O   ALA   150      28.631 -22.069  -6.612  1.00 74.74      A    O  
ATOM    929  N   ASN   151      27.055 -22.303  -5.003  1.00 72.44      A    N  
ATOM    930  CA  ASN   151      26.300 -21.119  -5.350  1.00 76.20      A    C  
ATOM    931  CB  ASN   151      24.810 -21.330  -5.072  1.00 76.85      A    C  
ATOM    932  CG  ASN   151      24.247 -22.554  -5.770  1.00 79.45      A    C  
ATOM    933  OD1 ASN   151      24.580 -22.845  -6.918  1.00 79.71      A    O  
ATOM    934  ND2 ASN   151      23.380 -23.276  -5.073  1.00 80.94      A    N  
ATOM    935  C   ASN   151      26.839 -19.979  -4.507  1.00 76.24      A    C  
ATOM    936  O   ASN   151      26.602 -19.927  -3.295  1.00 75.45      A    O  
ATOM    937  N   VAL   152      27.584 -19.081  -5.143  1.00 79.41      A    N  
ATOM    938  CA  VAL   152      28.259 -17.990  -4.444  1.00 79.50      A    C  
ATOM    939  CB  VAL   152      29.614 -17.661  -5.119  1.00 82.99      A    C  
ATOM    940  CG1 VAL   152      30.288 -16.454  -4.472  1.00 83.32      A    C  
ATOM    941  CG2 VAL   152      30.527 -18.868  -5.071  1.00 80.21      A    C  
ATOM    942  C   VAL   152      27.350 -16.759  -4.391  1.00 82.04      A    C  
ATOM    943  O   VAL   152      26.821 -16.325  -5.418  1.00 85.53      A    O  
ATOM    944  N   VAL   153      27.170 -16.213  -3.190  1.00 80.24      A    N  
ATOM    945  CA  VAL   153      26.318 -15.043  -2.970  1.00 81.79      A    C  
ATOM    946  CB  VAL   153      25.723 -15.040  -1.539  1.00 78.70      A    C  
ATOM    947  CG1 VAL   153      24.841 -13.821  -1.319  1.00 78.84      A    C  
ATOM    948  CG2 VAL   153      24.932 -16.323  -1.290  1.00 76.38      A    C  
ATOM    949  C   VAL   153      27.097 -13.751  -3.232  1.00 86.30      A    C  
ATOM    950  O   VAL   153      28.098 -13.467  -2.562  1.00 86.64      A    O  
ATOM    951  N   LEU   154      26.615 -12.970  -4.199  1.00 90.89      A    N  
ATOM    952  CA  LEU   154      27.335 -11.803  -4.699  1.00 96.61      A    C  
ATOM    953  CB  LEU   154      27.674 -12.010  -6.177  1.00102.18      A    C  
ATOM    954  CG  LEU   154      29.126 -11.829  -6.622  1.00107.79      A    C  
ATOM    955  CD1 LEU   154      29.946 -13.084  -6.325  1.00104.39      A    C  
ATOM    956  CD2 LEU   154      29.195 -11.476  -8.100  1.00115.33      A    C  
ATOM    957  C   LEU   154      26.523 -10.521  -4.528  1.00 98.73      A    C  
ATOM    958  O   LEU   154      26.057 -10.203  -3.430  1.00 95.85      A    O  
ATOM    959  N   ASP   156      20.327  -9.075  -2.880  1.00154.49      A    N  
ATOM    960  CA  ASP   156      21.569  -9.607  -3.441  1.00145.75      A    C  
ATOM    961  CB  ASP   156      22.488 -10.157  -2.331  1.00135.92      A    C  
ATOM    962  CG  ASP   156      21.872 -11.329  -1.568  1.00134.46      A    C  
ATOM    963  OD1 ASP   156      21.793 -12.447  -2.127  1.00132.68      A    O  
ATOM    964  OD2 ASP   156      21.490 -11.137  -0.394  1.00135.89      A    O  
ATOM    965  C   ASP   156      21.316 -10.670  -4.512  1.00145.37      A    C  
ATOM    966  O   ASP   156      20.268 -11.319  -4.518  1.00150.14      A    O  
ATOM    967  N   ASP   157      22.283 -10.837  -5.413  1.00140.52      A    N  
ATOM    968  CA  ASP   157      22.213 -11.861  -6.458  1.00139.58      A    C  
ATOM    969  CB  ASP   157      22.328 -11.238  -7.860  1.00145.97      A    C  
ATOM    970  CG  ASP   157      23.279 -10.046  -7.904  1.00145.70      A    C  
ATOM    971  OD1 ASP   157      22.852  -8.926  -7.545  1.00151.65      A    O  
ATOM    972  OD2 ASP   157      24.446 -10.224  -8.314  1.00140.51      A    O  
ATOM    973  C   ASP   157      23.284 -12.932  -6.249  1.00128.46      A    C  
ATOM    974  O   ASP   157      24.418 -12.619  -5.887  1.00122.38      A    O  
ATOM    975  N   SER   158      22.914 -14.192  -6.468  1.00126.34      A    N  
ATOM    976  CA  SER   158      23.850 -15.305  -6.310  1.00116.90      A    C  
ATOM    977  CB  SER   158      23.222 -16.443  -5.500  1.00115.95      A    C  
ATOM    978  OG  SER   158      22.159 -17.046  -6.211  1.00124.65      A    O  
ATOM    979  C   SER   158      24.386 -15.823  -7.647  1.00115.72      A    C  
ATOM    980  O   SER   158      23.766 -15.637  -8.693  1.00122.87      A    O  
ATOM    981  N   LEU   159      25.543 -16.475  -7.587  1.00107.30      A    N  
ATOM    982  CA  LEU   159      26.252 -16.962  -8.762  1.00105.78      A    C  
ATOM    983  CB  LEU   159      27.643 -16.324  -8.812  1.00100.96      A    C  
ATOM    984  CG  LEU   159      28.366 -16.132 -10.145  1.00104.00      A    C  
ATOM    985  CD2 LEU   159      27.532 -15.316 -11.129  1.00112.58      A    C  
ATOM    987  C   LEU   159      26.341 -18.490  -8.703  1.00102.25      A    C  
ATOM    988  O   LEU   159      27.136 -19.049  -7.948  1.00 95.25      A    O  
ATOM    989  N   ASN   160      25.514 -19.156  -9.504  1.00107.82      A    N  
ATOM    990  CA  ASN   160      25.321 -20.604  -9.394  1.00107.03      A    C  
ATOM    991  CB  ASN   160      23.945 -21.006  -9.941  1.00115.89      A    C  
ATOM    992  CG  ASN   160      22.789 -20.368  -9.174  1.00119.98      A    C  
ATOM    993  OD1 ASN   160      21.844 -19.859  -9.777  1.00128.07      A    O  
ATOM    994  ND2 ASN   160      22.859 -20.395  -7.844  1.00115.38      A    N  
ATOM    995  C   ASN   160      26.406 -21.460 -10.044  1.00103.95      A    C  
ATOM    996  O   ASN   160      26.986 -21.079 -11.064  1.00105.22      A    O  
ATOM    997  N   ASP   161      26.665 -22.614  -9.424  1.00100.72      A    N  
ATOM    998  CA  ASP   161      27.538 -23.670  -9.958  1.00 99.67      A    C  
ATOM    999  CB  ASP   161      26.903 -24.310 -11.206  1.00108.04      A    C  
ATOM   1000  CG  ASP   161      27.456 -25.693 -11.506  1.00109.23      A    C  
ATOM   1001  OD1 ASP   161      27.756 -26.442 -10.547  1.00105.93      A    O  
ATOM   1002  OD2 ASP   161      27.577 -26.033 -12.705  1.00114.11      A    O  
ATOM   1003  C   ASP   161      28.976 -23.220 -10.238  1.00 94.88      A    C  
ATOM   1004  O   ASP   161      29.499 -23.410 -11.340  1.00 97.52      A    O  
ATOM   1005  N   CYS   162      29.608 -22.634  -9.226  1.00 88.51      A    N  
ATOM   1006  CA  CYS   162      30.981 -22.149  -9.332  1.00 85.07      A    C  
ATOM   1007  CB  CYS   162      31.178 -20.924  -8.431  1.00 81.92      A    C  
ATOM   1008  SG  CYS   162      30.225 -19.464  -8.900  1.00 88.32      A    S  
ATOM   1009  C   CYS   162      31.993 -23.225  -8.942  1.00 81.26      A    C  
ATOM   1010  O   CYS   162      31.833 -23.883  -7.913  1.00 79.50      A    O  
ATOM   1011  N   ARG   163      33.041 -23.388  -9.748  1.00 80.96      A    N  
ATOM   1012  CA  ARG   163      34.135 -24.297  -9.403  1.00 78.45      A    C  
ATOM   1013  CB  ARG   163      34.936 -24.699 -10.649  1.00 82.87      A    C  
ATOM   1014  CG  ARG   163      36.139 -25.619 -10.389  1.00 83.57      A    C  
ATOM   1015  CD  ARG   163      35.735 -26.950  -9.752  1.00 86.25      A    C  
ATOM   1016  NE  ARG   163      36.895 -27.771  -9.402  1.00 86.46      A    N  
ATOM   1017  CZ  ARG   163      37.383 -28.758 -10.151  1.00 91.21      A    C  
ATOM   1018  NH1 ARG   163      36.813 -29.077 -11.312  1.00 95.37      A    N  
ATOM   1019  NH2 ARG   163      38.444 -29.439  -9.732  1.00 90.22      A    N  
ATOM   1020  C   ARG   163      35.044 -23.655  -8.359  1.00 73.09      A    C  
ATOM   1021  O   ARG   163      35.798 -22.727  -8.665  1.00 73.28      A    O  
ATOM   1022  N   ILE   164      34.963 -24.155  -7.129  1.00 68.86      A    N  
ATOM   1023  CA  ILE   164      35.743 -23.620  -6.011  1.00 63.46      A    C  
ATOM   1024  CB  ILE   164      34.998 -23.798  -4.656  1.00 61.55      A    C  
ATOM   1025  CG1 ILE   164      33.573 -23.218  -4.724  1.00 60.30      A    C  
ATOM   1026  CD1 ILE   164      33.499 -21.745  -5.097  1.00 60.78      A    C  
ATOM   1027  CG2 ILE   164      35.823 -23.220  -3.477  1.00 57.88      A    C  
ATOM   1028  C   ILE   164      37.130 -24.257  -5.942  1.00 63.17      A    C  
ATOM   1029  O   ILE   164      37.258 -25.473  -5.803  1.00 63.90      A    O  
ATOM   1030  N   ILE   165      38.160 -23.419  -6.033  1.00 63.23      A    N  
ATOM   1031  CA  ILE   165      39.553 -23.873  -6.071  1.00 64.54      A    C  
ATOM   1032  CB  ILE   165      40.486 -22.816  -6.735  1.00 65.87      A    C  
ATOM   1033  CG1 ILE   165      40.033 -22.474  -8.161  1.00 68.67      A    C  
ATOM   1034  CD1 ILE   165      39.820 -23.676  -9.066  1.00 70.55      A    C  
ATOM   1035  CG2 ILE   165      41.943 -23.279  -6.718  1.00 68.94      A    C  
ATOM   1036  C   ILE   165      40.090 -24.196  -4.681  1.00 63.36      A    C  
ATOM   1037  O   ILE   165      40.739 -25.220  -4.487  1.00 65.13      A    O  
ATOM   1038  N   PHE   166      39.808 -23.316  -3.724  1.00 60.96      A    N  
ATOM   1039  CA  PHE   166      40.423 -23.363  -2.391  1.00 61.51      A    C  
ATOM   1040  CB  PHE   166      40.778 -21.947  -1.921  1.00 59.92      A    C  
ATOM   1041  CG  PHE   166      41.515 -21.179  -2.976  1.00 63.59      A    C  
ATOM   1042  CD1 PHE   166      40.831 -20.338  -3.851  1.00 63.67      A    C  
ATOM   1043  CE1 PHE   166      41.500 -19.672  -4.874  1.00 65.74      A    C  
ATOM   1044  CZ  PHE   166      42.863 -19.866  -5.048  1.00 69.84      A    C  
ATOM   1045  CE2 PHE   166      43.555 -20.726  -4.199  1.00 71.18      A    C  
ATOM   1046  CD2 PHE   166      42.875 -21.391  -3.179  1.00 67.07      A    C  
ATOM   1047  C   PHE   166      39.555 -24.164  -1.448  1.00 60.34      A    C  
ATOM   1048  O   PHE   166      38.857 -23.654  -0.577  1.00 59.81      A    O  
ATOM   1049  N   VAL   167      39.639 -25.461  -1.683  1.00 61.90      A    N  
ATOM   1050  CA  VAL   167      38.760 -26.465  -1.138  1.00 62.51      A    C  
ATOM   1051  CB  VAL   167      38.817 -27.678  -2.085  1.00 66.35      A    C  
ATOM   1052  CG1 VAL   167      38.694 -29.004  -1.355  1.00 71.14      A    C  
ATOM   1053  CG2 VAL   167      37.789 -27.517  -3.209  1.00 67.21      A    C  
ATOM   1054  C   VAL   167      39.147 -26.822   0.296  1.00 62.61      A    C  
ATOM   1055  O   VAL   167      38.380 -27.472   1.015  1.00 61.76      A    O  
ATOM   1056  N   ASP   168      40.332 -26.369   0.706  1.00 63.36      A    N  
ATOM   1057  CA  ASP   168      40.879 -26.668   2.024  1.00 65.08      A    C  
ATOM   1058  CB  ASP   168      42.323 -27.177   1.907  1.00 68.67      A    C  
ATOM   1059  CG  ASP   168      42.404 -28.597   1.360  1.00 73.05      A    C  
ATOM   1060  OD1 ASP   168      41.677 -29.482   1.868  1.00 73.62      A    O  
ATOM   1061  OD2 ASP   168      43.199 -28.833   0.422  1.00 74.94      A    O  
ATOM   1062  C   ASP   168      40.810 -25.459   2.946  1.00 63.54      A    C  
ATOM   1063  O   ASP   168      41.340 -25.489   4.062  1.00 66.02      A    O  
ATOM   1064  N   GLU   169      40.141 -24.405   2.482  1.00 60.46      A    N  
ATOM   1065  CA  GLU   169      40.110 -23.134   3.207  1.00 59.46      A    C  
ATOM   1066  CB  GLU   169      40.988 -22.107   2.487  1.00 60.15      A    C  
ATOM   1067  CG  GLU   169      42.468 -22.435   2.516  1.00 60.33      A    C  
ATOM   1068  CD  GLU   169      43.285 -21.528   1.627  1.00 63.26      A    C  
ATOM   1069  OE1 GLU   169      43.919 -20.597   2.166  1.00 63.21      A    O  
ATOM   1070  OE2 GLU   169      43.296 -21.742   0.389  1.00 63.55      A    O  
ATOM   1071  C   GLU   169      38.691 -22.593   3.412  1.00 57.50      A    C  
ATOM   1072  O   GLU   169      38.475 -21.378   3.494  1.00 56.14      A    O  
ATOM   1073  N   VAL   170      37.735 -23.511   3.511  1.00 57.46      A    N  
ATOM   1074  CA  VAL   170      36.325 -23.175   3.636  1.00 56.44      A    C  
ATOM   1075  CB  VAL   170      35.449 -24.277   2.987  1.00 56.48      A    C  
ATOM   1076  CG1 VAL   170      33.980 -24.001   3.212  1.00 55.51      A    C  
ATOM   1077  CG2 VAL   170      35.751 -24.397   1.489  1.00 54.79      A    C  
ATOM   1078  C   VAL   170      35.952 -22.981   5.112  1.00 59.01      A    C  
ATOM   1079  O   VAL   170      36.236 -23.839   5.957  1.00 61.69      A    O  
ATOM   1080  N   PHE   171      35.312 -21.855   5.412  1.00 58.99      A    N  
ATOM   1081  CA  PHE   171      34.969 -21.499   6.783  1.00 61.65      A    C  
ATOM   1082  CB  PHE   171      35.233 -20.014   7.044  1.00 60.78      A    C  
ATOM   1083  CG  PHE   171      36.670 -19.678   7.281  1.00 60.82      A    C  
ATOM   1084  CD1 PHE   171      37.210 -19.739   8.562  1.00 60.71      A    C  
ATOM   1085  CE1 PHE   171      38.544 -19.413   8.789  1.00 60.33      A    C  
ATOM   1086  CZ  PHE   171      39.352 -19.009   7.736  1.00 61.60      A    C  
ATOM   1087  CE2 PHE   171      38.825 -18.946   6.441  1.00 61.24      A    C  
ATOM   1088  CD2 PHE   171      37.487 -19.275   6.224  1.00 60.28      A    C  
ATOM   1089  C   PHE   171      33.524 -21.794   7.147  1.00 64.12      A    C  
ATOM   1090  O   PHE   171      32.615 -21.693   6.314  1.00 64.50      A    O  
ATOM   1091  N   LYS   172      33.339 -22.152   8.413  1.00 77.04      A    N  
ATOM   1092  CA  LYS   172      32.037 -22.227   9.050  1.00 79.53      A    C  
ATOM   1093  CB  LYS   172      32.164 -23.050  10.337  1.00 88.91      A    C  
ATOM   1094  CG  LYS   172      30.940 -23.105  11.231  1.00 93.59      A    C  
ATOM   1095  CD  LYS   172      31.219 -24.011  12.426  1.00105.42      A    C  
ATOM   1096  CE  LYS   172      30.081 -24.008  13.435  1.00111.71      A    C  
ATOM   1097  NZ  LYS   172      30.086 -22.782  14.282  1.00110.49      A    N  
ATOM   1098  C   LYS   172      31.600 -20.804   9.366  1.00 77.33      A    C  
ATOM   1099  O   LYS   172      32.382 -20.015   9.907  1.00 79.81      A    O  
ATOM   1100  N   ILE   173      30.364 -20.468   9.018  1.00 76.02      A    N  
ATOM   1101  CA  ILE   173      29.820 -19.163   9.362  1.00 76.65      A    C  
ATOM   1102  CB  ILE   173      28.692 -18.719   8.397  1.00 76.78      A    C  
ATOM   1103  CG1 ILE   173      29.263 -18.449   7.002  1.00 70.61      A    C  
ATOM   1104  CD1 ILE   173      28.220 -18.403   5.902  1.00 71.51      A    C  
ATOM   1105  CG2 ILE   173      27.983 -17.471   8.924  1.00 81.49      A    C  
ATOM   1106  C   ILE   173      29.330 -19.219  10.805  1.00 83.32      A    C  
ATOM   1107  O   ILE   173      28.477 -20.038  11.153  1.00 87.13      A    O  
ATOM   1108  N   GLU   174      29.896 -18.353  11.639  1.00 86.51      A    N  
ATOM   1109  CA  GLU   174      29.536 -18.283  13.050  1.00 93.69      A    C  
ATOM   1110  CB  GLU   174      30.549 -17.437  13.835  1.00 97.60      A    C  
ATOM   1111  CG  GLU   174      32.024 -17.729  13.538  1.00 98.58      A    C  
ATOM   1112  CD  GLU   174      32.480 -19.103  14.005  1.00103.15      A    C  
ATOM   1113  OE1 GLU   174      32.267 -19.434  15.190  1.00110.24      A    O  
ATOM   1114  OE2 GLU   174      33.069 -19.847  13.186  1.00102.50      A    O  
ATOM   1115  C   GLU   174      28.128 -17.711  13.215  1.00 97.65      A    C  
ATOM   1116  O   GLU   174      27.849 -16.589  12.779  1.00 98.79      A    O  
ATOM   1117  N   ARG   175      27.250 -18.506  13.826  1.00102.48      A    N  
ATOM   1118  CA  ARG   175      25.891 -18.080  14.174  1.00109.50      A    C  
ATOM   1119  CB  ARG   175      24.881 -19.185  13.842  1.00114.39      A    C  
ATOM   1120  CG  ARG   175      24.124 -18.977  12.535  1.00116.97      A    C  
ATOM   1121  CD  ARG   175      24.920 -19.414  11.313  1.00109.78      A    C  
ATOM   1122  NE  ARG   175      24.355 -18.861  10.080  1.00112.40      A    N  
ATOM   1123  CZ  ARG   175      24.629 -19.298   8.851  1.00109.33      A    C  
ATOM   1124  NH1 ARG   175      25.462 -20.318   8.661  1.00103.11      A    N  
ATOM   1125  NH2 ARG   175      24.058 -18.714   7.803  1.00112.61      A    N  
ATOM   1126  C   ARG   175      25.781 -17.680  15.653  1.00114.90      A    C  
ATOM   1127  O   ARG   175      26.443 -18.279  16.504  1.00115.25      A    O  
ATOM   1128  N   PRO   176      24.947 -16.661  15.961  1.00121.13      A    N  
ATOM   1129  CA  PRO   176      24.769 -16.177  17.338  1.00127.15      A    C  
ATOM   1130  CB  PRO   176      23.739 -15.054  17.186  1.00135.40      A    C  
ATOM   1131  CG  PRO   176      23.825 -14.640  15.761  1.00132.78      A    C  
ATOM   1132  CD  PRO   176      24.125 -15.891  15.009  1.00124.80      A    C  
ATOM   1133  C   PRO   176      24.226 -17.248  18.281  1.00131.43      A    C  
ATOM   1134  O   PRO   176      24.738 -17.408  19.389  1.00133.23      A    O  
END
