
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   92 ( 1434),  selected   92 , name 2bud_A
# Molecule2: number of CA atoms  135 ( 1110),  selected  135 , name T0429.pdb
# PARAMETERS: 2bud_A.T0429.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G   363_A      E      22           -
LGA    S   364_A      T      23           -
LGA    H   365_A      -       -           -
LGA    M   366_A      -       -           -
LGA    D   367_A      -       -           -
LGA    P   368_A      -       -           -
LGA    L   369_A      -       -           -
LGA    M   370_A      -       -           -
LGA    Q   371_A      -       -           -
LGA    K   372_A      E      24           #
LGA    -       -      L      25           -
LGA    I   373_A      L      27          1.320
LGA    D   374_A      Y      28          4.570
LGA    I   375_A      K      29          1.631
LGA    S   376_A      V      30           #
LGA    E   377_A      -       -           -
LGA    N   378_A      -       -           -
LGA    P   379_A      -       -           -
LGA    D   380_A      N      31          4.676
LGA    K   381_A      E      32          3.442
LGA    I   382_A      Y      33          1.494
LGA    Y   383_A      V      34          0.799
LGA    F   384_A      D      35          0.803
LGA    I   385_A      A      36          0.909
LGA    R   386_A      R      37          1.645
LGA    R   387_A      D      38          1.389
LGA    E   388_A      T      39          1.497
LGA    -       -      N      40           -
LGA    D   389_A      M      41          0.992
LGA    G   390_A      G      42          1.646
LGA    T   391_A      A      43          1.535
LGA    V   392_A      W      44          0.797
LGA    H   393_A      F      45          0.436
LGA    R   394_A      E      46          0.649
LGA    G   395_A      A      47          0.669
LGA    Q   396_A      Q      48          0.710
LGA    V   397_A      V      49          0.169
LGA    L   398_A      V      50          1.747
LGA    Q   399_A      R      51          0.951
LGA    S   400_A      V      52          1.348
LGA    R   401_A      T      53          1.384
LGA    T   402_A      R      54          1.632
LGA    T   403_A      -       -           -
LGA    E   404_A      -       -           -
LGA    N   405_A      -       -           -
LGA    A   406_A      -       -           -
LGA    A   407_A      -       -           -
LGA    A   408_A      E      73          5.065
LGA    P   409_A      D      74          2.017
LGA    D   410_A      V      75          1.114
LGA    E   411_A      I      76          0.605
LGA    Y   412_A      Y      77          0.458
LGA    Y   413_A      H      78          0.352
LGA    V   414_A      V      79          0.553
LGA    H   415_A      K      80          0.370
LGA    Y   416_A      Y      81          0.356
LGA    V   417_A      D      82          0.705
LGA    G   418_A      D      83          2.113
LGA    L   419_A      Y      84          0.432
LGA    N   420_A      P      85          3.272
LGA    R   421_A      E      86          3.115
LGA    R   422_A      N      87          3.005
LGA    L   423_A      G      88          4.624
LGA    D   424_A      V      89          2.772
LGA    G   425_A      V      90          0.984
LGA    W   426_A      Q      91          0.261
LGA    V   427_A      M      92          0.449
LGA    G   428_A      N      93          0.788
LGA    R   429_A      S      94          1.013
LGA    H   430_A      R      95          0.675
LGA    R   431_A      D      96          0.988
LGA    I   432_A      V      97          0.782
LGA    S   433_A      R      98          0.642
LGA    D   434_A      A      99          0.645
LGA    N   435_A      R     100          3.819
LGA    A   436_A      A     101          2.885
LGA    -       -      R     102           -
LGA    -       -      T     103           -
LGA    -       -      I     104           -
LGA    -       -      I     105           -
LGA    -       -      K     106           -
LGA    -       -      W     107           -
LGA    -       -      Q     108           -
LGA    -       -      D     109           -
LGA    -       -      L     110           -
LGA    -       -      E     111           -
LGA    -       -      V     112           -
LGA    -       -      G     113           -
LGA    -       -      Q     114           -
LGA    -       -      V     115           -
LGA    D   437_A      V     116          4.928
LGA    D   438_A      -       -           -
LGA    L   439_A      -       -           -
LGA    G   440_A      M     117          3.584
LGA    G   441_A      L     118          3.932
LGA    I   442_A      N     119           #
LGA    -       -      Y     120           -
LGA    -       -      N     121           -
LGA    -       -      P     122           -
LGA    -       -      D     123           -
LGA    -       -      N     124           -
LGA    -       -      P     125           -
LGA    -       -      K     126           -
LGA    -       -      E     127           -
LGA    -       -      R     128           -
LGA    -       -      G     129           -
LGA    -       -      F     130           -
LGA    T   443_A      W     131          0.164
LGA    V   444_A      Y     132          2.890
LGA    L   445_A      D     133          4.188
LGA    P   446_A      A     134          0.995
LGA    A   447_A      E     135          4.063
LGA    -       -      I     136           -
LGA    -       -      S     137           -
LGA    -       -      R     138           -
LGA    -       -      K     139           -
LGA    -       -      R     140           -
LGA    -       -      E     141           -
LGA    -       -      T     142           -
LGA    -       -      R     143           -
LGA    -       -      T     144           -
LGA    -       -      A     145           -
LGA    -       -      R     146           -
LGA    -       -      E     147           -
LGA    -       -      L     148           -
LGA    -       -      Y     149           -
LGA    -       -      A     150           -
LGA    P   448_A      N     151          3.139
LGA    P   449_A      V     152           -
LGA    L   450_A      V     153           -
LGA    A   451_A      L     154           -
LGA    P   452_A      D     156           -
LGA    D   453_A      D     157           -
LGA    Q   454_A      S     158           -
LGA    -       -      L     159           -
LGA    -       -      N     160           -
LGA    -       -      D     161           -
LGA    -       -      C     162           -
LGA    -       -      R     163           -
LGA    -       -      I     164           -
LGA    -       -      I     165           -
LGA    -       -      F     166           -
LGA    -       -      V     167           -
LGA    -       -      D     168           -
LGA    -       -      E     169           -
LGA    -       -      V     170           -
LGA    -       -      F     171           -
LGA    -       -      K     172           -
LGA    -       -      I     173           -
LGA    -       -      E     174           -
LGA    -       -      R     175           -
LGA    -       -      P     176           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   92  135    5.0     64    2.23    12.50     39.258     2.743

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.075556 * X  +   0.915596 * Y  +   0.394936 * Z  +  29.815760
  Y_new =  -0.642073 * X  +   0.258358 * Y  +  -0.721798 * Z  +  -5.963168
  Z_new =  -0.762911 * X  +  -0.308114 * Y  +   0.568360 * Z  +   9.999934 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.496766    2.644826  [ DEG:   -28.4626    151.5374 ]
  Theta =   0.867804    2.273789  [ DEG:    49.7215    130.2785 ]
  Phi   =  -1.687932    1.453661  [ DEG:   -96.7114     83.2886 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2bud_A                                        
REMARK     2: T0429.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2bud_A.T0429.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   92  135   5.0   64   2.23   12.50  39.258
REMARK  ---------------------------------------------------------- 
MOLECULE 2bud_A
HEADER    TRANSFERASE                             09-JUN-05   2BUD              
TITLE     THE SOLUTION STRUCTURE OF THE CHROMO BARREL DOMAIN FROM THE           
TITLE    2 MALES-ABSENT ON THE FIRST (MOF) PROTEIN                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MALES-ABSENT ON THE FIRST PROTEIN;                         
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: CHROMO BARREL DOMAIN, RESIDUES 367-454;                    
COMPND   5 SYNONYM: PUTATIVE ACETYL TRANSFERASE MOF;                            
COMPND   6 EC: 2.3.1.48;                                                        
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: DROSOPHILA MELANOGASTER;                        
SOURCE   3 ORGANISM_COMMON: FRUIT FLY;                                          
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   6 EXPRESSION_SYSTEM_VARIANT: TUNER(DE3) PLACI;                         
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    MOF,HAT,ACETYL-TRANSFER,DOSAGE COMPENSATION COMPLEX,DCC,              
KEYWDS   2 ROYAL FAMILY,CHROMODOMAIN LIKE,BETA BARREL,TRANSFERASE               
KEYWDS   3 ACYLTRANSFERASE, METAL-BINDING                                       
EXPDTA    NMR, 25 STRUCTURES                                                    
AUTHOR    P.R.NIELSEN,D.NIETLISPACH,A.BUSCAINO,R.J.WARNER,A.AKHTAR,             
AUTHOR   2 A.G.MURZIN,N.V.MURZINA,E.D.LAUE                                      
REVDAT   2   15-SEP-05 2BUD    1       JRNL                                     
REVDAT   1   24-JUN-05 2BUD    0                                                
JRNL        AUTH   P.R.NIELSEN,D.NIETLISPACH,A.BUSCAINO,R.J.WARNER,             
JRNL        AUTH 2 A.AKHTAR,A.G.MURZIN,N.V.MURZINA,E.D.LAUE                     
JRNL        TITL   STRUCTURE OF THE CHROMO BARREL DOMAIN FROM THE MOF           
JRNL        TITL 2 ACETYLTRANSFERASE.                                           
JRNL        REF    J.BIOL.CHEM.                  V. 280 32326 2005              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2BUD A  363   366  UNP    O02193   MOF_DROME      363    366             
DBREF  2BUD A  367   454  UNP    O02193   MOF_DROME      367    454             
SEQRES   1 A   92  GLY SER HIS MET ASP PRO LEU MET GLN LYS ILE ASP ILE          
SEQRES   2 A   92  SER GLU ASN PRO ASP LYS ILE TYR PHE ILE ARG ARG GLU          
SEQRES   3 A   92  ASP GLY THR VAL HIS ARG GLY GLN VAL LEU GLN SER ARG          
SEQRES   4 A   92  THR THR GLU ASN ALA ALA ALA PRO ASP GLU TYR TYR VAL          
SEQRES   5 A   92  HIS TYR VAL GLY LEU ASN ARG ARG LEU ASP GLY TRP VAL          
SEQRES   6 A   92  GLY ARG HIS ARG ILE SER ASP ASN ALA ASP ASP LEU GLY          
SEQRES   7 A   92  GLY ILE THR VAL LEU PRO ALA PRO PRO LEU ALA PRO ASP          
SEQRES   8 A   92  GLN                                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A 363      11.077 -11.826  14.662  1.00 11.64           N  
ATOM      2  CA  GLY A 363      10.715 -10.397  14.440  1.00 11.03           C  
ATOM      3  C   GLY A 363       9.680  -9.899  15.429  1.00 10.23           C  
ATOM      4  O   GLY A 363       8.726  -9.218  15.048  1.00 10.21           O  
ATOM      5  H2  GLY A 363      11.656 -12.174  13.872  1.00 11.91           H  
ATOM      6  HA2 GLY A 363      11.606  -9.794  14.533  1.00 11.23           H  
ATOM      7  HA3 GLY A 363      10.324 -10.289  13.439  1.00 11.16           H  
ATOM      8  H1  GLY A 363      10.217 -12.406  14.729  1.00 11.74           H  
ATOM      9  H3  GLY A 363      11.618 -11.923  15.545  1.00 11.90           H  
ATOM     10  N   SER A 364       9.867 -10.237  16.702  1.00  9.80           N  
ATOM     11  CA  SER A 364       8.945  -9.821  17.753  1.00  9.25           C  
ATOM     12  C   SER A 364       9.492 -10.186  19.128  1.00  8.36           C  
ATOM     13  O   SER A 364       9.912 -11.321  19.356  1.00  8.24           O  
ATOM     14  CB  SER A 364       7.577 -10.476  17.550  1.00  9.60           C  
ATOM     15  OG  SER A 364       7.678 -11.889  17.581  1.00  9.86           O  
ATOM     16  H   SER A 364      10.648 -10.780  16.940  1.00 10.02           H  
ATOM     17  HA  SER A 364       8.834  -8.749  17.694  1.00  9.49           H  
ATOM     18  HB2 SER A 364       6.907 -10.159  18.335  1.00  9.79           H  
ATOM     19  HB3 SER A 364       7.175 -10.176  16.592  1.00  9.74           H  
ATOM     20  HG  SER A 364       7.592 -12.236  16.690  1.00 10.13           H  
ATOM     21  N   HIS A 365       9.483  -9.213  20.037  1.00  7.98           N  
ATOM     22  CA  HIS A 365       9.979  -9.416  21.396  1.00  7.35           C  
ATOM     23  C   HIS A 365      11.446  -9.838  21.388  1.00  6.30           C  
ATOM     24  O   HIS A 365      11.780 -10.954  20.991  1.00  6.44           O  
ATOM     25  CB  HIS A 365       9.136 -10.469  22.122  1.00  7.88           C  
ATOM     26  CG  HIS A 365       9.647 -10.810  23.489  1.00  7.65           C  
ATOM     27  ND1 HIS A 365       9.778  -9.881  24.499  1.00  7.18           N  
ATOM     28  CD2 HIS A 365      10.062 -11.990  24.009  1.00  8.07           C  
ATOM     29  CE1 HIS A 365      10.252 -10.474  25.581  1.00  7.26           C  
ATOM     30  NE2 HIS A 365      10.432 -11.753  25.310  1.00  7.79           N  
ATOM     31  H   HIS A 365       9.134  -8.332  19.787  1.00  8.31           H  
ATOM     32  HA  HIS A 365       9.893  -8.477  21.922  1.00  7.51           H  
ATOM     33  HB2 HIS A 365       8.128 -10.100  22.229  1.00  8.26           H  
ATOM     34  HB3 HIS A 365       9.123 -11.375  21.535  1.00  8.33           H  
ATOM     35  HD1 HIS A 365       9.558  -8.929  24.433  1.00  7.00           H  
ATOM     36  HD2 HIS A 365      10.096 -12.941  23.495  1.00  8.67           H  
ATOM     37  HE1 HIS A 365      10.455  -9.993  26.527  1.00  7.11           H  
ATOM     38  HE2 HIS A 365      10.865 -12.401  25.905  1.00  8.09           H  
ATOM     39  N   MET A 366      12.316  -8.939  21.838  1.00  5.51           N  
ATOM     40  CA  MET A 366      13.744  -9.223  21.887  1.00  4.67           C  
ATOM     41  C   MET A 366      14.059 -10.225  22.992  1.00  4.56           C  
ATOM     42  O   MET A 366      13.628 -10.060  24.134  1.00  4.71           O  
ATOM     43  CB  MET A 366      14.536  -7.932  22.107  1.00  4.15           C  
ATOM     44  CG  MET A 366      14.343  -6.902  21.005  1.00  3.72           C  
ATOM     45  SD  MET A 366      14.897  -7.496  19.393  1.00  3.31           S  
ATOM     46  CE  MET A 366      14.541  -6.074  18.362  1.00  2.76           C  
ATOM     47  H   MET A 366      11.989  -8.069  22.147  1.00  5.70           H  
ATOM     48  HA  MET A 366      14.030  -9.652  20.938  1.00  4.86           H  
ATOM     49  HB2 MET A 366      14.227  -7.489  23.043  1.00  4.39           H  
ATOM     50  HB3 MET A 366      15.587  -8.173  22.164  1.00  4.31           H  
ATOM     51  HG2 MET A 366      13.294  -6.657  20.939  1.00  4.07           H  
ATOM     52  HG3 MET A 366      14.903  -6.015  21.258  1.00  3.90           H  
ATOM     53  HE1 MET A 366      14.377  -5.208  18.986  1.00  2.90           H  
ATOM     54  HE2 MET A 366      15.376  -5.889  17.702  1.00  2.96           H  
ATOM     55  HE3 MET A 366      13.654  -6.268  17.776  1.00  2.91           H  
ATOM     56  N   ASP A 367      14.815 -11.261  22.645  1.00  4.67           N  
ATOM     57  CA  ASP A 367      15.194 -12.292  23.606  1.00  4.80           C  
ATOM     58  C   ASP A 367      15.985 -11.683  24.763  1.00  4.50           C  
ATOM     59  O   ASP A 367      16.661 -10.669  24.591  1.00  4.10           O  
ATOM     60  CB  ASP A 367      16.018 -13.383  22.919  1.00  4.92           C  
ATOM     61  CG  ASP A 367      15.240 -14.094  21.830  1.00  5.55           C  
ATOM     62  OD1 ASP A 367      14.190 -14.693  22.145  1.00  6.06           O  
ATOM     63  OD2 ASP A 367      15.681 -14.052  20.662  1.00  5.80           O  
ATOM     64  H   ASP A 367      15.129 -11.334  21.719  1.00  4.91           H  
ATOM     65  HA  ASP A 367      14.288 -12.729  23.997  1.00  5.35           H  
ATOM     66  HB2 ASP A 367      16.896 -12.936  22.476  1.00  4.64           H  
ATOM     67  HB3 ASP A 367      16.322 -14.112  23.655  1.00  5.17           H  
ATOM     68  N   PRO A 368      15.902 -12.290  25.964  1.00  4.98           N  
ATOM     69  CA  PRO A 368      16.612 -11.795  27.152  1.00  5.12           C  
ATOM     70  C   PRO A 368      18.117 -12.052  27.092  1.00  5.15           C  
ATOM     71  O   PRO A 368      18.741 -12.374  28.103  1.00  5.66           O  
ATOM     72  CB  PRO A 368      15.980 -12.590  28.295  1.00  5.90           C  
ATOM     73  CG  PRO A 368      15.529 -13.860  27.662  1.00  6.16           C  
ATOM     74  CD  PRO A 368      15.109 -13.499  26.262  1.00  5.69           C  
ATOM     75  HA  PRO A 368      16.435 -10.740  27.305  1.00  4.98           H  
ATOM     76  HB2 PRO A 368      16.718 -12.770  29.061  1.00  6.24           H  
ATOM     77  HB3 PRO A 368      15.149 -12.038  28.706  1.00  6.10           H  
ATOM     78  HG2 PRO A 368      16.343 -14.568  27.638  1.00  6.43           H  
ATOM     79  HG3 PRO A 368      14.692 -14.267  28.211  1.00  6.59           H  
ATOM     80  HD2 PRO A 368      15.355 -14.298  25.579  1.00  5.88           H  
ATOM     81  HD3 PRO A 368      14.052 -13.284  26.228  1.00  5.87           H  
ATOM     82  N   LEU A 369      18.691 -11.904  25.902  1.00  4.84           N  
ATOM     83  CA  LEU A 369      20.116 -12.114  25.699  1.00  5.12           C  
ATOM     84  C   LEU A 369      20.531 -11.645  24.312  1.00  4.61           C  
ATOM     85  O   LEU A 369      21.587 -11.035  24.142  1.00  4.91           O  
ATOM     86  CB  LEU A 369      20.468 -13.593  25.893  1.00  5.80           C  
ATOM     87  CG  LEU A 369      21.948 -13.965  25.709  1.00  6.34           C  
ATOM     88  CD1 LEU A 369      22.285 -14.139  24.234  1.00  6.73           C  
ATOM     89  CD2 LEU A 369      22.854 -12.912  26.333  1.00  6.94           C  
ATOM     90  H   LEU A 369      18.142 -11.648  25.140  1.00  4.61           H  
ATOM     91  HA  LEU A 369      20.646 -11.529  26.436  1.00  5.45           H  
ATOM     92  HB2 LEU A 369      20.168 -13.877  26.889  1.00  6.13           H  
ATOM     93  HB3 LEU A 369      19.888 -14.168  25.187  1.00  5.89           H  
ATOM     94  HG  LEU A 369      22.140 -14.907  26.204  1.00  6.42           H  
ATOM     95 HD11 LEU A 369      21.377 -14.314  23.676  1.00  7.08           H  
ATOM     96 HD12 LEU A 369      22.766 -13.243  23.867  1.00  6.77           H  
ATOM     97 HD13 LEU A 369      22.950 -14.981  24.111  1.00  6.95           H  
ATOM     98 HD21 LEU A 369      22.364 -12.480  27.192  1.00  7.21           H  
ATOM     99 HD22 LEU A 369      23.783 -13.370  26.640  1.00  7.21           H  
ATOM    100 HD23 LEU A 369      23.057 -12.137  25.607  1.00  7.18           H  
ATOM    101  N   MET A 370      19.692 -11.932  23.323  1.00  4.12           N  
ATOM    102  CA  MET A 370      19.971 -11.535  21.948  1.00  3.87           C  
ATOM    103  C   MET A 370      19.670 -10.048  21.746  1.00  3.02           C  
ATOM    104  O   MET A 370      19.228  -9.629  20.675  1.00  3.06           O  
ATOM    105  CB  MET A 370      19.142 -12.389  20.981  1.00  4.63           C  
ATOM    106  CG  MET A 370      19.526 -12.221  19.518  1.00  5.03           C  
ATOM    107  SD  MET A 370      21.247 -12.650  19.196  1.00  5.63           S  
ATOM    108  CE  MET A 370      21.340 -12.377  17.428  1.00  5.52           C  
ATOM    109  H   MET A 370      18.865 -12.419  23.521  1.00  4.15           H  
ATOM    110  HA  MET A 370      21.021 -11.709  21.762  1.00  4.18           H  
ATOM    111  HB2 MET A 370      19.267 -13.431  21.243  1.00  5.14           H  
ATOM    112  HB3 MET A 370      18.101 -12.124  21.089  1.00  4.81           H  
ATOM    113  HG2 MET A 370      18.894 -12.859  18.919  1.00  5.22           H  
ATOM    114  HG3 MET A 370      19.367 -11.191  19.234  1.00  5.24           H  
ATOM    115  HE1 MET A 370      20.625 -11.620  17.141  1.00  5.67           H  
ATOM    116  HE2 MET A 370      22.336 -12.051  17.166  1.00  5.67           H  
ATOM    117  HE3 MET A 370      21.114 -13.298  16.909  1.00  5.59           H  
ATOM    118  N   GLN A 371      19.916  -9.254  22.785  1.00  2.80           N  
ATOM    119  CA  GLN A 371      19.681  -7.815  22.729  1.00  2.63           C  
ATOM    120  C   GLN A 371      20.839  -7.109  22.035  1.00  2.21           C  
ATOM    121  O   GLN A 371      21.534  -6.304  22.653  1.00  2.80           O  
ATOM    122  CB  GLN A 371      19.490  -7.249  24.137  1.00  3.46           C  
ATOM    123  CG  GLN A 371      18.308  -7.853  24.879  1.00  3.91           C  
ATOM    124  CD  GLN A 371      18.106  -7.263  26.266  1.00  4.54           C  
ATOM    125  OE1 GLN A 371      17.189  -7.657  26.987  1.00  4.97           O  
ATOM    126  NE2 GLN A 371      18.957  -6.316  26.649  1.00  5.04           N  
ATOM    127  H   GLN A 371      20.269  -9.644  23.611  1.00  3.22           H  
ATOM    128  HA  GLN A 371      18.780  -7.649  22.157  1.00  2.81           H  
ATOM    129  HB2 GLN A 371      20.385  -7.438  24.713  1.00  3.90           H  
ATOM    130  HB3 GLN A 371      19.337  -6.183  24.065  1.00  3.78           H  
ATOM    131  HG2 GLN A 371      17.413  -7.681  24.300  1.00  3.97           H  
ATOM    132  HG3 GLN A 371      18.469  -8.917  24.979  1.00  4.18           H  
ATOM    133 HE21 GLN A 371      19.664  -6.047  26.028  1.00  5.03           H  
ATOM    134 HE22 GLN A 371      18.840  -5.923  27.539  1.00  5.61           H  
ATOM    135  N   LYS A 372      21.035  -7.439  20.753  1.00  1.82           N  
ATOM    136  CA  LYS A 372      22.108  -6.874  19.923  1.00  1.77           C  
ATOM    137  C   LYS A 372      23.486  -7.019  20.576  1.00  1.50           C  
ATOM    138  O   LYS A 372      23.649  -6.831  21.780  1.00  1.89           O  
ATOM    139  CB  LYS A 372      21.829  -5.409  19.538  1.00  2.26           C  
ATOM    140  CG  LYS A 372      21.718  -4.441  20.704  1.00  2.93           C  
ATOM    141  CD  LYS A 372      21.524  -3.013  20.221  1.00  3.98           C  
ATOM    142  CE  LYS A 372      21.388  -2.041  21.382  1.00  4.77           C  
ATOM    143  NZ  LYS A 372      21.213  -0.638  20.912  1.00  5.39           N  
ATOM    144  H   LYS A 372      20.436  -8.098  20.349  1.00  2.14           H  
ATOM    145  HA  LYS A 372      22.123  -7.457  19.012  1.00  2.10           H  
ATOM    146  HB2 LYS A 372      22.628  -5.066  18.900  1.00  2.35           H  
ATOM    147  HB3 LYS A 372      20.904  -5.371  18.982  1.00  2.71           H  
ATOM    148  HG2 LYS A 372      20.870  -4.722  21.312  1.00  3.14           H  
ATOM    149  HG3 LYS A 372      22.620  -4.495  21.295  1.00  3.02           H  
ATOM    150  HD2 LYS A 372      22.378  -2.726  19.623  1.00  4.25           H  
ATOM    151  HD3 LYS A 372      20.630  -2.966  19.616  1.00  4.37           H  
ATOM    152  HE2 LYS A 372      20.529  -2.324  21.971  1.00  5.03           H  
ATOM    153  HE3 LYS A 372      22.278  -2.101  21.989  1.00  5.07           H  
ATOM    154  HZ1 LYS A 372      20.942  -0.629  19.907  1.00  5.55           H  
ATOM    155  HZ2 LYS A 372      20.471  -0.166  21.465  1.00  5.68           H  
ATOM    156  HZ3 LYS A 372      22.102  -0.110  21.024  1.00  5.78           H  
ATOM    157  N   ILE A 373      24.475  -7.379  19.759  1.00  1.42           N  
ATOM    158  CA  ILE A 373      25.843  -7.577  20.231  1.00  1.22           C  
ATOM    159  C   ILE A 373      26.328  -6.415  21.094  1.00  1.13           C  
ATOM    160  O   ILE A 373      26.240  -5.252  20.699  1.00  1.20           O  
ATOM    161  CB  ILE A 373      26.818  -7.762  19.049  1.00  1.16           C  
ATOM    162  CG1 ILE A 373      26.471  -9.032  18.268  1.00  1.40           C  
ATOM    163  CG2 ILE A 373      28.258  -7.811  19.542  1.00  1.26           C  
ATOM    164  CD1 ILE A 373      27.366  -9.275  17.071  1.00  1.48           C  
ATOM    165  H   ILE A 373      24.275  -7.524  18.811  1.00  1.86           H  
ATOM    166  HA  ILE A 373      25.860  -8.481  20.825  1.00  1.44           H  
ATOM    167  HB  ILE A 373      26.719  -6.910  18.395  1.00  1.17           H  
ATOM    168 HG12 ILE A 373      26.557  -9.887  18.924  1.00  1.60           H  
ATOM    169 HG13 ILE A 373      25.453  -8.960  17.913  1.00  1.77           H  
ATOM    170 HG21 ILE A 373      28.286  -7.565  20.593  1.00  1.69           H  
ATOM    171 HG22 ILE A 373      28.656  -8.804  19.393  1.00  1.62           H  
ATOM    172 HG23 ILE A 373      28.851  -7.099  18.989  1.00  1.63           H  
ATOM    173 HD11 ILE A 373      28.032  -8.434  16.944  1.00  1.86           H  
ATOM    174 HD12 ILE A 373      27.944 -10.173  17.231  1.00  1.77           H  
ATOM    175 HD13 ILE A 373      26.760  -9.390  16.185  1.00  1.93           H  
ATOM    176  N   ASP A 374      26.855  -6.750  22.269  1.00  1.16           N  
ATOM    177  CA  ASP A 374      27.377  -5.748  23.193  1.00  1.17           C  
ATOM    178  C   ASP A 374      28.854  -5.483  22.922  1.00  1.03           C  
ATOM    179  O   ASP A 374      29.649  -6.415  22.813  1.00  1.25           O  
ATOM    180  CB  ASP A 374      27.194  -6.212  24.640  1.00  1.40           C  
ATOM    181  CG  ASP A 374      25.733  -6.320  25.033  1.00  1.77           C  
ATOM    182  OD1 ASP A 374      25.027  -5.291  24.977  1.00  2.04           O  
ATOM    183  OD2 ASP A 374      25.297  -7.432  25.397  1.00  2.17           O  
ATOM    184  H   ASP A 374      26.905  -7.697  22.518  1.00  1.29           H  
ATOM    185  HA  ASP A 374      26.824  -4.834  23.044  1.00  1.24           H  
ATOM    186  HB2 ASP A 374      27.649  -7.183  24.758  1.00  1.49           H  
ATOM    187  HB3 ASP A 374      27.678  -5.509  25.302  1.00  1.43           H  
ATOM    188  N   ILE A 375      29.215  -4.211  22.813  1.00  0.84           N  
ATOM    189  CA  ILE A 375      30.599  -3.835  22.558  1.00  0.76           C  
ATOM    190  C   ILE A 375      31.422  -3.839  23.839  1.00  0.76           C  
ATOM    191  O   ILE A 375      32.554  -4.318  23.856  1.00  0.79           O  
ATOM    192  CB  ILE A 375      30.700  -2.447  21.905  1.00  0.77           C  
ATOM    193  CG1 ILE A 375      30.015  -2.458  20.538  1.00  0.82           C  
ATOM    194  CG2 ILE A 375      32.160  -2.033  21.783  1.00  0.84           C  
ATOM    195  CD1 ILE A 375      29.985  -1.105  19.861  1.00  0.92           C  
ATOM    196  H   ILE A 375      28.538  -3.510  22.910  1.00  0.92           H  
ATOM    197  HA  ILE A 375      31.017  -4.559  21.876  1.00  0.81           H  
ATOM    198  HB  ILE A 375      30.202  -1.735  22.546  1.00  0.83           H  
ATOM    199 HG12 ILE A 375      30.538  -3.142  19.885  1.00  0.98           H  
ATOM    200 HG13 ILE A 375      28.993  -2.793  20.656  1.00  1.01           H  
ATOM    201 HG21 ILE A 375      32.703  -2.373  22.655  1.00  1.34           H  
ATOM    202 HG22 ILE A 375      32.590  -2.479  20.898  1.00  1.37           H  
ATOM    203 HG23 ILE A 375      32.228  -0.958  21.714  1.00  1.30           H  
ATOM    204 HD11 ILE A 375      30.987  -0.706  19.811  1.00  1.43           H  
ATOM    205 HD12 ILE A 375      29.590  -1.211  18.861  1.00  1.35           H  
ATOM    206 HD13 ILE A 375      29.357  -0.434  20.425  1.00  1.44           H  
ATOM    207  N   SER A 376      30.845  -3.290  24.903  1.00  0.79           N  
ATOM    208  CA  SER A 376      31.517  -3.214  26.196  1.00  0.87           C  
ATOM    209  C   SER A 376      31.748  -4.603  26.780  1.00  0.96           C  
ATOM    210  O   SER A 376      31.071  -5.018  27.720  1.00  1.54           O  
ATOM    211  CB  SER A 376      30.704  -2.363  27.166  1.00  0.95           C  
ATOM    212  OG  SER A 376      29.396  -2.884  27.336  1.00  1.71           O  
ATOM    213  H   SER A 376      29.942  -2.919  24.814  1.00  0.81           H  
ATOM    214  HA  SER A 376      32.475  -2.743  26.039  1.00  0.88           H  
ATOM    215  HB2 SER A 376      31.197  -2.344  28.128  1.00  1.35           H  
ATOM    216  HB3 SER A 376      30.633  -1.362  26.779  1.00  1.34           H  
ATOM    217  HG  SER A 376      28.840  -2.224  27.755  1.00  2.20           H  
ATOM    218  N   GLU A 377      32.714  -5.310  26.208  1.00  0.93           N  
ATOM    219  CA  GLU A 377      33.056  -6.651  26.650  1.00  1.03           C  
ATOM    220  C   GLU A 377      34.291  -7.141  25.911  1.00  0.87           C  
ATOM    221  O   GLU A 377      35.050  -7.969  26.415  1.00  0.93           O  
ATOM    222  CB  GLU A 377      31.889  -7.611  26.418  1.00  1.18           C  
ATOM    223  CG  GLU A 377      31.521  -7.793  24.955  1.00  1.28           C  
ATOM    224  CD  GLU A 377      30.467  -8.863  24.751  1.00  1.54           C  
ATOM    225  OE1 GLU A 377      30.736 -10.034  25.092  1.00  1.90           O  
ATOM    226  OE2 GLU A 377      29.371  -8.532  24.252  1.00  1.92           O  
ATOM    227  H   GLU A 377      33.215  -4.916  25.467  1.00  1.26           H  
ATOM    228  HA  GLU A 377      33.275  -6.604  27.703  1.00  1.21           H  
ATOM    229  HB2 GLU A 377      32.145  -8.576  26.824  1.00  1.72           H  
ATOM    230  HB3 GLU A 377      31.023  -7.233  26.938  1.00  1.51           H  
ATOM    231  HG2 GLU A 377      31.142  -6.856  24.572  1.00  1.35           H  
ATOM    232  HG3 GLU A 377      32.409  -8.072  24.406  1.00  1.79           H  
ATOM    233  N   ASN A 378      34.482  -6.612  24.708  1.00  0.71           N  
ATOM    234  CA  ASN A 378      35.625  -6.981  23.877  1.00  0.61           C  
ATOM    235  C   ASN A 378      35.813  -5.998  22.720  1.00  0.58           C  
ATOM    236  O   ASN A 378      35.809  -6.395  21.555  1.00  0.59           O  
ATOM    237  CB  ASN A 378      35.462  -8.412  23.342  1.00  0.62           C  
ATOM    238  CG  ASN A 378      34.137  -8.642  22.633  1.00  1.15           C  
ATOM    239  OD1 ASN A 378      33.741  -9.782  22.401  1.00  1.16           O  
ATOM    240  ND2 ASN A 378      33.458  -7.563  22.261  1.00  2.14           N  
ATOM    241  H   ASN A 378      33.835  -5.953  24.373  1.00  0.72           H  
ATOM    242  HA  ASN A 378      36.505  -6.944  24.503  1.00  0.66           H  
ATOM    243  HB2 ASN A 378      36.258  -8.615  22.641  1.00  1.18           H  
ATOM    244  HB3 ASN A 378      35.534  -9.106  24.163  1.00  1.15           H  
ATOM    245 HD21 ASN A 378      33.842  -6.686  22.453  1.00  2.14           H  
ATOM    246 HD22 ASN A 378      32.599  -7.692  21.809  1.00  2.89           H  
ATOM    247  N   PRO A 379      35.988  -4.695  23.021  1.00  0.62           N  
ATOM    248  CA  PRO A 379      36.183  -3.673  21.988  1.00  0.65           C  
ATOM    249  C   PRO A 379      37.328  -4.035  21.049  1.00  0.61           C  
ATOM    250  O   PRO A 379      37.247  -3.821  19.838  1.00  0.62           O  
ATOM    251  CB  PRO A 379      36.524  -2.412  22.785  1.00  0.77           C  
ATOM    252  CG  PRO A 379      35.929  -2.640  24.132  1.00  0.85           C  
ATOM    253  CD  PRO A 379      36.018  -4.121  24.379  1.00  0.75           C  
ATOM    254  HA  PRO A 379      35.283  -3.511  21.413  1.00  0.67           H  
ATOM    255  HB2 PRO A 379      37.598  -2.297  22.842  1.00  0.80           H  
ATOM    256  HB3 PRO A 379      36.089  -1.549  22.304  1.00  0.85           H  
ATOM    257  HG2 PRO A 379      36.492  -2.102  24.879  1.00  0.98           H  
ATOM    258  HG3 PRO A 379      34.897  -2.322  24.137  1.00  0.95           H  
ATOM    259  HD2 PRO A 379      36.942  -4.365  24.880  1.00  0.80           H  
ATOM    260  HD3 PRO A 379      35.171  -4.459  24.959  1.00  0.80           H  
ATOM    261  N   ASP A 380      38.389  -4.592  21.621  1.00  0.62           N  
ATOM    262  CA  ASP A 380      39.557  -4.999  20.852  1.00  0.64           C  
ATOM    263  C   ASP A 380      39.199  -6.103  19.859  1.00  0.55           C  
ATOM    264  O   ASP A 380      39.782  -6.188  18.779  1.00  0.55           O  
ATOM    265  CB  ASP A 380      40.664  -5.481  21.790  1.00  0.75           C  
ATOM    266  CG  ASP A 380      41.142  -4.389  22.725  1.00  0.86           C  
ATOM    267  OD1 ASP A 380      41.628  -3.350  22.228  1.00  1.21           O  
ATOM    268  OD2 ASP A 380      41.029  -4.570  23.956  1.00  1.20           O  
ATOM    269  H   ASP A 380      38.384  -4.738  22.591  1.00  0.65           H  
ATOM    270  HA  ASP A 380      39.910  -4.140  20.304  1.00  0.68           H  
ATOM    271  HB2 ASP A 380      40.292  -6.301  22.384  1.00  0.73           H  
ATOM    272  HB3 ASP A 380      41.505  -5.821  21.199  1.00  0.79           H  
ATOM    273  N   LYS A 381      38.241  -6.948  20.238  1.00  0.51           N  
ATOM    274  CA  LYS A 381      37.809  -8.051  19.383  1.00  0.47           C  
ATOM    275  C   LYS A 381      37.493  -7.563  17.973  1.00  0.39           C  
ATOM    276  O   LYS A 381      36.708  -6.633  17.789  1.00  0.37           O  
ATOM    277  CB  LYS A 381      36.577  -8.740  19.978  1.00  0.50           C  
ATOM    278  CG  LYS A 381      36.053  -9.885  19.128  1.00  0.52           C  
ATOM    279  CD  LYS A 381      34.747 -10.439  19.670  1.00  0.59           C  
ATOM    280  CE  LYS A 381      34.203 -11.548  18.784  1.00  0.67           C  
ATOM    281  NZ  LYS A 381      32.858 -12.007  19.228  1.00  1.66           N  
ATOM    282  H   LYS A 381      37.818  -6.830  21.114  1.00  0.53           H  
ATOM    283  HA  LYS A 381      38.615  -8.764  19.334  1.00  0.51           H  
ATOM    284  HB2 LYS A 381      36.833  -9.130  20.953  1.00  0.56           H  
ATOM    285  HB3 LYS A 381      35.789  -8.010  20.088  1.00  0.50           H  
ATOM    286  HG2 LYS A 381      35.888  -9.524  18.126  1.00  0.48           H  
ATOM    287  HG3 LYS A 381      36.791 -10.675  19.109  1.00  0.55           H  
ATOM    288  HD2 LYS A 381      34.918 -10.835  20.660  1.00  0.64           H  
ATOM    289  HD3 LYS A 381      34.020  -9.641  19.719  1.00  0.60           H  
ATOM    290  HE2 LYS A 381      34.131 -11.180  17.771  1.00  1.17           H  
ATOM    291  HE3 LYS A 381      34.887 -12.383  18.814  1.00  1.04           H  
ATOM    292  HZ1 LYS A 381      32.681 -11.703  20.207  1.00  2.16           H  
ATOM    293  HZ2 LYS A 381      32.122 -11.604  18.614  1.00  2.27           H  
ATOM    294  HZ3 LYS A 381      32.802 -13.045  19.183  1.00  2.11           H  
ATOM    295  N   ILE A 382      38.105  -8.202  16.980  1.00  0.40           N  
ATOM    296  CA  ILE A 382      37.886  -7.837  15.586  1.00  0.35           C  
ATOM    297  C   ILE A 382      36.627  -8.505  15.045  1.00  0.34           C  
ATOM    298  O   ILE A 382      36.474  -9.722  15.141  1.00  0.41           O  
ATOM    299  CB  ILE A 382      39.083  -8.245  14.703  1.00  0.37           C  
ATOM    300  CG1 ILE A 382      40.383  -7.637  15.244  1.00  0.38           C  
ATOM    301  CG2 ILE A 382      38.853  -7.822  13.259  1.00  0.41           C  
ATOM    302  CD1 ILE A 382      40.373  -6.124  15.302  1.00  0.37           C  
ATOM    303  H   ILE A 382      38.718  -8.936  17.191  1.00  0.47           H  
ATOM    304  HA  ILE A 382      37.771  -6.765  15.531  1.00  0.35           H  
ATOM    305  HB  ILE A 382      39.165  -9.321  14.725  1.00  0.41           H  
ATOM    306 HG12 ILE A 382      40.552  -8.002  16.246  1.00  0.40           H  
ATOM    307 HG13 ILE A 382      41.204  -7.941  14.612  1.00  0.42           H  
ATOM    308 HG21 ILE A 382      37.799  -7.647  13.100  1.00  1.13           H  
ATOM    309 HG22 ILE A 382      39.402  -6.914  13.056  1.00  1.07           H  
ATOM    310 HG23 ILE A 382      39.192  -8.604  12.595  1.00  1.06           H  
ATOM    311 HD11 ILE A 382      39.551  -5.747  14.710  1.00  1.05           H  
ATOM    312 HD12 ILE A 382      40.257  -5.803  16.326  1.00  1.03           H  
ATOM    313 HD13 ILE A 382      41.304  -5.743  14.908  1.00  1.10           H  
ATOM    314  N   TYR A 383      35.730  -7.711  14.466  1.00  0.30           N  
ATOM    315  CA  TYR A 383      34.498  -8.252  13.909  1.00  0.30           C  
ATOM    316  C   TYR A 383      34.591  -8.350  12.391  1.00  0.28           C  
ATOM    317  O   TYR A 383      35.184  -7.492  11.741  1.00  0.25           O  
ATOM    318  CB  TYR A 383      33.290  -7.397  14.312  1.00  0.32           C  
ATOM    319  CG  TYR A 383      32.996  -7.421  15.795  1.00  0.36           C  
ATOM    320  CD1 TYR A 383      33.881  -6.863  16.708  1.00  0.40           C  
ATOM    321  CD2 TYR A 383      31.831  -8.004  16.280  1.00  0.48           C  
ATOM    322  CE1 TYR A 383      33.613  -6.881  18.063  1.00  0.48           C  
ATOM    323  CE2 TYR A 383      31.557  -8.027  17.633  1.00  0.55           C  
ATOM    324  CZ  TYR A 383      32.449  -7.464  18.520  1.00  0.52           C  
ATOM    325  OH  TYR A 383      32.178  -7.485  19.868  1.00  0.63           O  
ATOM    326  H   TYR A 383      35.903  -6.746  14.407  1.00  0.31           H  
ATOM    327  HA  TYR A 383      34.368  -9.247  14.308  1.00  0.34           H  
ATOM    328  HB2 TYR A 383      33.470  -6.369  14.032  1.00  0.31           H  
ATOM    329  HB3 TYR A 383      32.413  -7.757  13.794  1.00  0.35           H  
ATOM    330  HD1 TYR A 383      34.791  -6.406  16.346  1.00  0.44           H  
ATOM    331  HD2 TYR A 383      31.135  -8.448  15.583  1.00  0.58           H  
ATOM    332  HE1 TYR A 383      34.312  -6.441  18.759  1.00  0.58           H  
ATOM    333  HE2 TYR A 383      30.647  -8.484  17.992  1.00  0.68           H  
ATOM    334  HH  TYR A 383      31.916  -8.372  20.129  1.00  1.10           H  
ATOM    335  N   PHE A 384      34.004  -9.402  11.833  1.00  0.31           N  
ATOM    336  CA  PHE A 384      34.022  -9.609  10.389  1.00  0.30           C  
ATOM    337  C   PHE A 384      32.783  -8.989   9.752  1.00  0.28           C  
ATOM    338  O   PHE A 384      31.687  -9.073  10.305  1.00  0.33           O  
ATOM    339  CB  PHE A 384      34.092 -11.103  10.056  1.00  0.40           C  
ATOM    340  CG  PHE A 384      35.307 -11.802  10.607  1.00  0.48           C  
ATOM    341  CD1 PHE A 384      35.536 -11.868  11.973  1.00  0.83           C  
ATOM    342  CD2 PHE A 384      36.218 -12.401   9.751  1.00  0.57           C  
ATOM    343  CE1 PHE A 384      36.650 -12.515  12.473  1.00  0.96           C  
ATOM    344  CE2 PHE A 384      37.332 -13.052  10.246  1.00  0.64           C  
ATOM    345  CZ  PHE A 384      37.549 -13.108  11.608  1.00  0.74           C  
ATOM    346  H   PHE A 384      33.548 -10.055  12.404  1.00  0.35           H  
ATOM    347  HA  PHE A 384      34.898  -9.118   9.996  1.00  0.30           H  
ATOM    348  HB2 PHE A 384      33.215 -11.594  10.453  1.00  0.45           H  
ATOM    349  HB3 PHE A 384      34.102 -11.218   8.982  1.00  0.44           H  
ATOM    350  HD1 PHE A 384      34.834 -11.405  12.650  1.00  1.11           H  
ATOM    351  HD2 PHE A 384      36.051 -12.357   8.684  1.00  0.82           H  
ATOM    352  HE1 PHE A 384      36.817 -12.559  13.539  1.00  1.32           H  
ATOM    353  HE2 PHE A 384      38.033 -13.515   9.568  1.00  0.86           H  
ATOM    354  HZ  PHE A 384      38.420 -13.615  11.996  1.00  0.86           H  
ATOM    355  N   ILE A 385      32.957  -8.362   8.592  1.00  0.26           N  
ATOM    356  CA  ILE A 385      31.838  -7.730   7.901  1.00  0.27           C  
ATOM    357  C   ILE A 385      31.834  -8.090   6.421  1.00  0.24           C  
ATOM    358  O   ILE A 385      32.832  -7.908   5.725  1.00  0.30           O  
ATOM    359  CB  ILE A 385      31.871  -6.190   8.024  1.00  0.33           C  
ATOM    360  CG1 ILE A 385      32.295  -5.751   9.428  1.00  0.32           C  
ATOM    361  CG2 ILE A 385      30.506  -5.610   7.678  1.00  0.49           C  
ATOM    362  CD1 ILE A 385      33.780  -5.883   9.680  1.00  0.32           C  
ATOM    363  H   ILE A 385      33.853  -8.322   8.195  1.00  0.28           H  
ATOM    364  HA  ILE A 385      30.923  -8.087   8.352  1.00  0.31           H  
ATOM    365  HB  ILE A 385      32.584  -5.812   7.306  1.00  0.37           H  
ATOM    366 HG12 ILE A 385      32.027  -4.716   9.572  1.00  0.41           H  
ATOM    367 HG13 ILE A 385      31.782  -6.355  10.160  1.00  0.43           H  
ATOM    368 HG21 ILE A 385      29.746  -6.364   7.818  1.00  1.12           H  
ATOM    369 HG22 ILE A 385      30.300  -4.767   8.323  1.00  1.12           H  
ATOM    370 HG23 ILE A 385      30.504  -5.283   6.648  1.00  1.20           H  
ATOM    371 HD11 ILE A 385      34.133  -6.819   9.274  1.00  0.98           H  
ATOM    372 HD12 ILE A 385      34.299  -5.065   9.205  1.00  1.10           H  
ATOM    373 HD13 ILE A 385      33.967  -5.858  10.744  1.00  1.08           H  
ATOM    374  N   ARG A 386      30.700  -8.590   5.948  1.00  0.29           N  
ATOM    375  CA  ARG A 386      30.554  -8.965   4.549  1.00  0.30           C  
ATOM    376  C   ARG A 386      30.292  -7.732   3.692  1.00  0.33           C  
ATOM    377  O   ARG A 386      29.269  -7.066   3.856  1.00  0.42           O  
ATOM    378  CB  ARG A 386      29.396  -9.954   4.401  1.00  0.38           C  
ATOM    379  CG  ARG A 386      29.187 -10.458   2.981  1.00  0.50           C  
ATOM    380  CD  ARG A 386      27.974 -11.370   2.897  1.00  1.02           C  
ATOM    381  NE  ARG A 386      27.768 -11.896   1.548  1.00  1.40           N  
ATOM    382  CZ  ARG A 386      28.613 -12.721   0.937  1.00  1.86           C  
ATOM    383  NH1 ARG A 386      29.720 -13.119   1.548  1.00  2.42           N  
ATOM    384  NH2 ARG A 386      28.348 -13.154  -0.288  1.00  2.39           N  
ATOM    385  H   ARG A 386      29.939  -8.702   6.554  1.00  0.37           H  
ATOM    386  HA  ARG A 386      31.470  -9.435   4.227  1.00  0.35           H  
ATOM    387  HB2 ARG A 386      29.584 -10.808   5.036  1.00  0.45           H  
ATOM    388  HB3 ARG A 386      28.485  -9.471   4.725  1.00  0.42           H  
ATOM    389  HG2 ARG A 386      29.038  -9.611   2.327  1.00  1.01           H  
ATOM    390  HG3 ARG A 386      30.064 -11.008   2.672  1.00  0.98           H  
ATOM    391  HD2 ARG A 386      28.115 -12.197   3.576  1.00  1.53           H  
ATOM    392  HD3 ARG A 386      27.099 -10.809   3.193  1.00  1.53           H  
ATOM    393  HE  ARG A 386      26.955 -11.620   1.074  1.00  1.90           H  
ATOM    394 HH11 ARG A 386      29.925 -12.800   2.473  1.00  2.37           H  
ATOM    395 HH12 ARG A 386      30.353 -13.739   1.084  1.00  3.17           H  
ATOM    396 HH21 ARG A 386      27.513 -12.859  -0.753  1.00  2.55           H  
ATOM    397 HH22 ARG A 386      28.982 -13.776  -0.747  1.00  2.93           H  
ATOM    398  N   ARG A 387      31.207  -7.430   2.776  1.00  0.41           N  
ATOM    399  CA  ARG A 387      31.035  -6.273   1.907  1.00  0.51           C  
ATOM    400  C   ARG A 387      29.905  -6.521   0.917  1.00  0.49           C  
ATOM    401  O   ARG A 387      29.570  -7.668   0.623  1.00  0.47           O  
ATOM    402  CB  ARG A 387      32.329  -5.938   1.168  1.00  0.63           C  
ATOM    403  CG  ARG A 387      33.491  -5.617   2.093  1.00  0.84           C  
ATOM    404  CD  ARG A 387      34.603  -4.889   1.356  1.00  0.94           C  
ATOM    405  NE  ARG A 387      35.041  -5.608   0.164  1.00  1.32           N  
ATOM    406  CZ  ARG A 387      35.981  -5.159  -0.663  1.00  1.79           C  
ATOM    407  NH1 ARG A 387      36.587  -4.004  -0.419  1.00  2.30           N  
ATOM    408  NH2 ARG A 387      36.317  -5.863  -1.735  1.00  2.25           N  
ATOM    409  H   ARG A 387      32.006  -7.995   2.678  1.00  0.46           H  
ATOM    410  HA  ARG A 387      30.764  -5.435   2.531  1.00  0.58           H  
ATOM    411  HB2 ARG A 387      32.610  -6.783   0.553  1.00  0.63           H  
ATOM    412  HB3 ARG A 387      32.158  -5.083   0.532  1.00  0.77           H  
ATOM    413  HG2 ARG A 387      33.136  -4.991   2.898  1.00  1.24           H  
ATOM    414  HG3 ARG A 387      33.884  -6.539   2.497  1.00  1.17           H  
ATOM    415  HD2 ARG A 387      34.243  -3.914   1.064  1.00  1.21           H  
ATOM    416  HD3 ARG A 387      35.444  -4.772   2.025  1.00  1.21           H  
ATOM    417  HE  ARG A 387      34.608  -6.464  -0.033  1.00  1.73           H  
ATOM    418 HH11 ARG A 387      36.337  -3.469   0.388  1.00  2.22           H  
ATOM    419 HH12 ARG A 387      37.293  -3.669  -1.042  1.00  2.99           H  
ATOM    420 HH21 ARG A 387      35.865  -6.735  -1.924  1.00  2.35           H  
ATOM    421 HH22 ARG A 387      37.025  -5.523  -2.356  1.00  2.76           H  
ATOM    422  N   GLU A 388      29.305  -5.443   0.424  1.00  0.64           N  
ATOM    423  CA  GLU A 388      28.194  -5.550  -0.516  1.00  0.69           C  
ATOM    424  C   GLU A 388      28.537  -6.465  -1.685  1.00  0.61           C  
ATOM    425  O   GLU A 388      27.736  -7.322  -2.055  1.00  0.63           O  
ATOM    426  CB  GLU A 388      27.790  -4.167  -1.029  1.00  0.88           C  
ATOM    427  CG  GLU A 388      27.330  -3.219   0.068  1.00  1.58           C  
ATOM    428  CD  GLU A 388      26.927  -1.857  -0.465  1.00  2.20           C  
ATOM    429  OE1 GLU A 388      27.013  -1.650  -1.694  1.00  2.82           O  
ATOM    430  OE2 GLU A 388      26.523  -0.996   0.345  1.00  2.65           O  
ATOM    431  H   GLU A 388      29.604  -4.556   0.711  1.00  0.79           H  
ATOM    432  HA  GLU A 388      27.362  -5.985   0.016  1.00  0.72           H  
ATOM    433  HB2 GLU A 388      28.638  -3.719  -1.528  1.00  1.18           H  
ATOM    434  HB3 GLU A 388      26.985  -4.279  -1.740  1.00  1.27           H  
ATOM    435  HG2 GLU A 388      26.480  -3.657   0.571  1.00  2.17           H  
ATOM    436  HG3 GLU A 388      28.136  -3.088   0.775  1.00  2.04           H  
ATOM    437  N   ASP A 389      29.728  -6.300  -2.252  1.00  0.65           N  
ATOM    438  CA  ASP A 389      30.145  -7.147  -3.363  1.00  0.69           C  
ATOM    439  C   ASP A 389      30.083  -8.604  -2.929  1.00  0.64           C  
ATOM    440  O   ASP A 389      29.745  -9.489  -3.715  1.00  0.91           O  
ATOM    441  CB  ASP A 389      31.554  -6.787  -3.839  1.00  0.81           C  
ATOM    442  CG  ASP A 389      32.609  -7.011  -2.776  1.00  0.80           C  
ATOM    443  OD1 ASP A 389      32.527  -6.361  -1.715  1.00  1.06           O  
ATOM    444  OD2 ASP A 389      33.517  -7.836  -3.005  1.00  1.23           O  
ATOM    445  H   ASP A 389      30.338  -5.612  -1.912  1.00  0.72           H  
ATOM    446  HA  ASP A 389      29.446  -6.995  -4.173  1.00  0.76           H  
ATOM    447  HB2 ASP A 389      31.803  -7.395  -4.696  1.00  0.89           H  
ATOM    448  HB3 ASP A 389      31.575  -5.746  -4.128  1.00  0.90           H  
ATOM    449  N   GLY A 390      30.393  -8.836  -1.656  1.00  0.55           N  
ATOM    450  CA  GLY A 390      30.348 -10.175  -1.109  1.00  0.53           C  
ATOM    451  C   GLY A 390      31.590 -10.531  -0.310  1.00  0.55           C  
ATOM    452  O   GLY A 390      31.508 -11.231   0.698  1.00  1.03           O  
ATOM    453  H   GLY A 390      30.637  -8.083  -1.079  1.00  0.70           H  
ATOM    454  HA2 GLY A 390      29.484 -10.249  -0.462  1.00  0.51           H  
ATOM    455  HA3 GLY A 390      30.241 -10.881  -1.919  1.00  0.62           H  
ATOM    456  N   THR A 391      32.743 -10.055  -0.771  1.00  0.57           N  
ATOM    457  CA  THR A 391      34.015 -10.334  -0.109  1.00  0.54           C  
ATOM    458  C   THR A 391      34.035  -9.833   1.333  1.00  0.41           C  
ATOM    459  O   THR A 391      34.014  -8.629   1.590  1.00  0.44           O  
ATOM    460  CB  THR A 391      35.197  -9.709  -0.872  1.00  0.71           C  
ATOM    461  OG1 THR A 391      35.048  -8.288  -0.935  1.00  0.98           O  
ATOM    462  CG2 THR A 391      35.291 -10.278  -2.281  1.00  0.88           C  
ATOM    463  H   THR A 391      32.740  -9.511  -1.586  1.00  0.95           H  
ATOM    464  HA  THR A 391      34.152 -11.405  -0.103  1.00  0.58           H  
ATOM    465  HB  THR A 391      36.111  -9.944  -0.346  1.00  0.81           H  
ATOM    466  HG1 THR A 391      34.156  -8.046  -0.672  1.00  1.19           H  
ATOM    467 HG21 THR A 391      34.384 -10.820  -2.511  1.00  1.34           H  
ATOM    468 HG22 THR A 391      35.419  -9.472  -2.988  1.00  1.30           H  
ATOM    469 HG23 THR A 391      36.135 -10.949  -2.343  1.00  1.46           H  
ATOM    470  N   VAL A 392      34.085 -10.776   2.271  1.00  0.37           N  
ATOM    471  CA  VAL A 392      34.123 -10.451   3.693  1.00  0.33           C  
ATOM    472  C   VAL A 392      35.495  -9.906   4.087  1.00  0.32           C  
ATOM    473  O   VAL A 392      36.520 -10.368   3.588  1.00  0.41           O  
ATOM    474  CB  VAL A 392      33.801 -11.687   4.556  1.00  0.45           C  
ATOM    475  CG1 VAL A 392      33.840 -11.338   6.036  1.00  0.55           C  
ATOM    476  CG2 VAL A 392      32.446 -12.261   4.172  1.00  0.52           C  
ATOM    477  H   VAL A 392      34.104 -11.717   1.998  1.00  0.45           H  
ATOM    478  HA  VAL A 392      33.375  -9.696   3.886  1.00  0.35           H  
ATOM    479  HB  VAL A 392      34.553 -12.440   4.367  1.00  0.53           H  
ATOM    480 HG11 VAL A 392      34.793 -10.893   6.277  1.00  1.13           H  
ATOM    481 HG12 VAL A 392      33.048 -10.639   6.262  1.00  1.12           H  
ATOM    482 HG13 VAL A 392      33.705 -12.235   6.622  1.00  1.24           H  
ATOM    483 HG21 VAL A 392      31.976 -11.616   3.444  1.00  1.14           H  
ATOM    484 HG22 VAL A 392      32.580 -13.246   3.746  1.00  1.14           H  
ATOM    485 HG23 VAL A 392      31.823 -12.330   5.049  1.00  1.13           H  
ATOM    486  N   HIS A 393      35.507  -8.923   4.983  1.00  0.29           N  
ATOM    487  CA  HIS A 393      36.756  -8.315   5.437  1.00  0.31           C  
ATOM    488  C   HIS A 393      36.652  -7.854   6.889  1.00  0.27           C  
ATOM    489  O   HIS A 393      35.598  -7.395   7.333  1.00  0.26           O  
ATOM    490  CB  HIS A 393      37.132  -7.133   4.539  1.00  0.37           C  
ATOM    491  CG  HIS A 393      37.566  -7.536   3.164  1.00  0.92           C  
ATOM    492  ND1 HIS A 393      38.669  -8.331   2.926  1.00  1.92           N  
ATOM    493  CD2 HIS A 393      37.039  -7.257   1.949  1.00  0.94           C  
ATOM    494  CE1 HIS A 393      38.800  -8.520   1.625  1.00  2.43           C  
ATOM    495  NE2 HIS A 393      37.825  -7.879   1.011  1.00  1.82           N  
ATOM    496  H   HIS A 393      34.658  -8.594   5.344  1.00  0.32           H  
ATOM    497  HA  HIS A 393      37.528  -9.067   5.367  1.00  0.37           H  
ATOM    498  HB2 HIS A 393      36.276  -6.483   4.438  1.00  0.68           H  
ATOM    499  HB3 HIS A 393      37.942  -6.584   4.997  1.00  0.71           H  
ATOM    500  HD1 HIS A 393      39.267  -8.698   3.610  1.00  2.24           H  
ATOM    501  HD2 HIS A 393      36.162  -6.655   1.755  1.00  0.73           H  
ATOM    502  HE1 HIS A 393      39.574  -9.101   1.146  1.00  3.24           H  
ATOM    503  HE2 HIS A 393      37.647  -7.907   0.047  1.00  2.04           H  
ATOM    504  N   ARG A 394      37.753  -7.992   7.623  1.00  0.29           N  
ATOM    505  CA  ARG A 394      37.803  -7.603   9.030  1.00  0.28           C  
ATOM    506  C   ARG A 394      37.402  -6.144   9.230  1.00  0.26           C  
ATOM    507  O   ARG A 394      37.534  -5.321   8.324  1.00  0.32           O  
ATOM    508  CB  ARG A 394      39.204  -7.828   9.600  1.00  0.35           C  
ATOM    509  CG  ARG A 394      39.630  -9.284   9.618  1.00  0.42           C  
ATOM    510  CD  ARG A 394      40.987  -9.455  10.283  1.00  0.52           C  
ATOM    511  NE  ARG A 394      42.045  -8.747   9.563  1.00  1.34           N  
ATOM    512  CZ  ARG A 394      43.320  -8.741   9.944  1.00  2.01           C  
ATOM    513  NH1 ARG A 394      43.695  -9.396  11.035  1.00  2.41           N  
ATOM    514  NH2 ARG A 394      44.221  -8.077   9.233  1.00  2.96           N  
ATOM    515  H   ARG A 394      38.556  -8.371   7.208  1.00  0.34           H  
ATOM    516  HA  ARG A 394      37.106  -8.228   9.569  1.00  0.27           H  
ATOM    517  HB2 ARG A 394      39.915  -7.273   9.005  1.00  0.41           H  
ATOM    518  HB3 ARG A 394      39.230  -7.456  10.615  1.00  0.38           H  
ATOM    519  HG2 ARG A 394      38.898  -9.858  10.165  1.00  0.45           H  
ATOM    520  HG3 ARG A 394      39.690  -9.645   8.601  1.00  0.44           H  
ATOM    521  HD2 ARG A 394      40.930  -9.065  11.290  1.00  1.07           H  
ATOM    522  HD3 ARG A 394      41.228 -10.507  10.317  1.00  1.04           H  
ATOM    523  HE  ARG A 394      41.792  -8.254   8.755  1.00  2.01           H  
ATOM    524 HH11 ARG A 394      43.018  -9.897  11.574  1.00  2.28           H  
ATOM    525 HH12 ARG A 394      44.654  -9.389  11.316  1.00  3.24           H  
ATOM    526 HH21 ARG A 394      43.944  -7.581   8.410  1.00  3.32           H  
ATOM    527 HH22 ARG A 394      45.180  -8.072   9.521  1.00  3.56           H  
ATOM    528  N   GLY A 395      36.913  -5.839  10.430  1.00  0.23           N  
ATOM    529  CA  GLY A 395      36.498  -4.488  10.753  1.00  0.25           C  
ATOM    530  C   GLY A 395      36.173  -4.321  12.226  1.00  0.23           C  
ATOM    531  O   GLY A 395      35.414  -5.109  12.793  1.00  0.26           O  
ATOM    532  H   GLY A 395      36.838  -6.543  11.106  1.00  0.24           H  
ATOM    533  HA2 GLY A 395      37.288  -3.805  10.487  1.00  0.32           H  
ATOM    534  HA3 GLY A 395      35.619  -4.245  10.174  1.00  0.27           H  
ATOM    535  N   GLN A 396      36.748  -3.298  12.851  1.00  0.29           N  
ATOM    536  CA  GLN A 396      36.507  -3.041  14.266  1.00  0.34           C  
ATOM    537  C   GLN A 396      35.236  -2.221  14.458  1.00  0.35           C  
ATOM    538  O   GLN A 396      35.069  -1.168  13.846  1.00  0.46           O  
ATOM    539  CB  GLN A 396      37.696  -2.298  14.879  1.00  0.43           C  
ATOM    540  CG  GLN A 396      39.014  -3.044  14.752  1.00  0.50           C  
ATOM    541  CD  GLN A 396      40.175  -2.281  15.353  1.00  0.64           C  
ATOM    542  OE1 GLN A 396      40.385  -1.104  15.056  1.00  1.28           O  
ATOM    543  NE2 GLN A 396      40.946  -2.960  16.185  1.00  0.61           N  
ATOM    544  H   GLN A 396      37.344  -2.703  12.350  1.00  0.34           H  
ATOM    545  HA  GLN A 396      36.390  -3.991  14.763  1.00  0.36           H  
ATOM    546  HB2 GLN A 396      37.801  -1.343  14.387  1.00  0.44           H  
ATOM    547  HB3 GLN A 396      37.500  -2.134  15.928  1.00  0.50           H  
ATOM    548  HG2 GLN A 396      38.926  -3.990  15.264  1.00  0.53           H  
ATOM    549  HG3 GLN A 396      39.221  -3.220  13.712  1.00  0.48           H  
ATOM    550 HE21 GLN A 396      40.721  -3.898  16.353  1.00  0.99           H  
ATOM    551 HE22 GLN A 396      41.708  -2.499  16.596  1.00  0.64           H  
ATOM    552  N   VAL A 397      34.349  -2.697  15.321  1.00  0.33           N  
ATOM    553  CA  VAL A 397      33.103  -1.996  15.596  1.00  0.33           C  
ATOM    554  C   VAL A 397      33.236  -1.149  16.862  1.00  0.33           C  
ATOM    555  O   VAL A 397      33.788  -1.603  17.865  1.00  0.37           O  
ATOM    556  CB  VAL A 397      31.920  -2.990  15.695  1.00  0.38           C  
ATOM    557  CG1 VAL A 397      31.246  -2.955  17.054  1.00  0.73           C  
ATOM    558  CG2 VAL A 397      30.912  -2.713  14.594  1.00  0.83           C  
ATOM    559  H   VAL A 397      34.540  -3.537  15.790  1.00  0.40           H  
ATOM    560  HA  VAL A 397      32.915  -1.334  14.762  1.00  0.36           H  
ATOM    561  HB  VAL A 397      32.306  -3.983  15.542  1.00  0.82           H  
ATOM    562 HG11 VAL A 397      31.971  -2.702  17.811  1.00  1.27           H  
ATOM    563 HG12 VAL A 397      30.456  -2.218  17.047  1.00  1.42           H  
ATOM    564 HG13 VAL A 397      30.828  -3.928  17.268  1.00  1.31           H  
ATOM    565 HG21 VAL A 397      31.396  -2.802  13.632  1.00  1.42           H  
ATOM    566 HG22 VAL A 397      30.104  -3.424  14.659  1.00  1.22           H  
ATOM    567 HG23 VAL A 397      30.522  -1.712  14.708  1.00  1.58           H  
ATOM    568  N   LEU A 398      32.765   0.096  16.798  1.00  0.36           N  
ATOM    569  CA  LEU A 398      32.876   1.006  17.935  1.00  0.40           C  
ATOM    570  C   LEU A 398      31.519   1.506  18.436  1.00  0.41           C  
ATOM    571  O   LEU A 398      31.293   1.577  19.644  1.00  0.47           O  
ATOM    572  CB  LEU A 398      33.749   2.202  17.550  1.00  0.46           C  
ATOM    573  CG  LEU A 398      35.160   1.848  17.074  1.00  0.49           C  
ATOM    574  CD1 LEU A 398      35.888   3.092  16.590  1.00  1.16           C  
ATOM    575  CD2 LEU A 398      35.946   1.169  18.187  1.00  1.45           C  
ATOM    576  H   LEU A 398      32.361   0.414  15.964  1.00  0.40           H  
ATOM    577  HA  LEU A 398      33.362   0.472  18.734  1.00  0.43           H  
ATOM    578  HB2 LEU A 398      33.250   2.746  16.760  1.00  0.48           H  
ATOM    579  HB3 LEU A 398      33.836   2.849  18.410  1.00  0.54           H  
ATOM    580  HG  LEU A 398      35.091   1.159  16.244  1.00  0.90           H  
ATOM    581 HD11 LEU A 398      35.208   3.710  16.021  1.00  1.63           H  
ATOM    582 HD12 LEU A 398      36.255   3.649  17.439  1.00  1.74           H  
ATOM    583 HD13 LEU A 398      36.720   2.802  15.965  1.00  1.81           H  
ATOM    584 HD21 LEU A 398      35.384   1.223  19.107  1.00  2.01           H  
ATOM    585 HD22 LEU A 398      36.116   0.135  17.928  1.00  1.95           H  
ATOM    586 HD23 LEU A 398      36.895   1.670  18.313  1.00  2.04           H  
ATOM    587  N   GLN A 399      30.631   1.880  17.517  1.00  0.39           N  
ATOM    588  CA  GLN A 399      29.320   2.402  17.903  1.00  0.43           C  
ATOM    589  C   GLN A 399      28.176   1.593  17.300  1.00  0.38           C  
ATOM    590  O   GLN A 399      28.393   0.684  16.501  1.00  0.35           O  
ATOM    591  CB  GLN A 399      29.189   3.864  17.476  1.00  0.49           C  
ATOM    592  CG  GLN A 399      30.264   4.769  18.061  1.00  0.60           C  
ATOM    593  CD  GLN A 399      30.131   6.218  17.620  1.00  1.36           C  
ATOM    594  OE1 GLN A 399      30.917   7.072  18.030  1.00  2.08           O  
ATOM    595  NE2 GLN A 399      29.138   6.507  16.784  1.00  2.04           N  
ATOM    596  H   GLN A 399      30.869   1.826  16.567  1.00  0.39           H  
ATOM    597  HA  GLN A 399      29.250   2.350  18.978  1.00  0.49           H  
ATOM    598  HB2 GLN A 399      29.248   3.919  16.399  1.00  0.46           H  
ATOM    599  HB3 GLN A 399      28.226   4.234  17.793  1.00  0.53           H  
ATOM    600  HG2 GLN A 399      30.198   4.731  19.137  1.00  0.92           H  
ATOM    601  HG3 GLN A 399      31.231   4.402  17.748  1.00  1.00           H  
ATOM    602 HE21 GLN A 399      28.547   5.782  16.495  1.00  2.28           H  
ATOM    603 HE22 GLN A 399      29.039   7.437  16.488  1.00  2.64           H  
ATOM    604  N   SER A 400      26.954   1.944  17.695  1.00  0.42           N  
ATOM    605  CA  SER A 400      25.755   1.273  17.205  1.00  0.41           C  
ATOM    606  C   SER A 400      24.506   2.083  17.550  1.00  0.47           C  
ATOM    607  O   SER A 400      24.444   2.716  18.604  1.00  0.54           O  
ATOM    608  CB  SER A 400      25.651  -0.134  17.797  1.00  0.47           C  
ATOM    609  OG  SER A 400      25.531  -0.088  19.207  1.00  0.56           O  
ATOM    610  H   SER A 400      26.855   2.681  18.334  1.00  0.47           H  
ATOM    611  HA  SER A 400      25.835   1.197  16.131  1.00  0.38           H  
ATOM    612  HB2 SER A 400      24.782  -0.629  17.390  1.00  0.49           H  
ATOM    613  HB3 SER A 400      26.536  -0.697  17.542  1.00  0.48           H  
ATOM    614  HG  SER A 400      25.900   0.736  19.534  1.00  1.13           H  
ATOM    615  N   ARG A 401      23.516   2.064  16.660  1.00  0.51           N  
ATOM    616  CA  ARG A 401      22.274   2.804  16.884  1.00  0.60           C  
ATOM    617  C   ARG A 401      21.073   2.026  16.345  1.00  0.73           C  
ATOM    618  O   ARG A 401      21.115   1.487  15.240  1.00  0.86           O  
ATOM    619  CB  ARG A 401      22.348   4.180  16.216  1.00  0.65           C  
ATOM    620  CG  ARG A 401      22.329   4.125  14.698  1.00  0.72           C  
ATOM    621  CD  ARG A 401      22.354   5.518  14.089  1.00  0.91           C  
ATOM    622  NE  ARG A 401      22.277   5.472  12.631  1.00  1.02           N  
ATOM    623  CZ  ARG A 401      22.276   6.554  11.858  1.00  1.25           C  
ATOM    624  NH1 ARG A 401      22.351   7.761  12.402  1.00  1.55           N  
ATOM    625  NH2 ARG A 401      22.199   6.428  10.540  1.00  1.43           N  
ATOM    626  H   ARG A 401      23.620   1.542  15.837  1.00  0.53           H  
ATOM    627  HA  ARG A 401      22.154   2.935  17.949  1.00  0.64           H  
ATOM    628  HB2 ARG A 401      21.509   4.775  16.543  1.00  0.72           H  
ATOM    629  HB3 ARG A 401      23.262   4.667  16.525  1.00  0.66           H  
ATOM    630  HG2 ARG A 401      23.195   3.579  14.357  1.00  0.74           H  
ATOM    631  HG3 ARG A 401      21.432   3.618  14.379  1.00  0.85           H  
ATOM    632  HD2 ARG A 401      21.512   6.077  14.468  1.00  1.06           H  
ATOM    633  HD3 ARG A 401      23.272   6.007  14.378  1.00  1.07           H  
ATOM    634  HE  ARG A 401      22.220   4.590  12.207  1.00  1.14           H  
ATOM    635 HH11 ARG A 401      22.410   7.859  13.396  1.00  1.56           H  
ATOM    636 HH12 ARG A 401      22.349   8.572  11.818  1.00  1.88           H  
ATOM    637 HH21 ARG A 401      22.141   5.519  10.126  1.00  1.47           H  
ATOM    638 HH22 ARG A 401      22.197   7.242   9.959  1.00  1.68           H  
ATOM    639  N   THR A 402      20.006   1.963  17.140  1.00  0.82           N  
ATOM    640  CA  THR A 402      18.799   1.244  16.748  1.00  0.99           C  
ATOM    641  C   THR A 402      17.726   2.181  16.198  1.00  1.16           C  
ATOM    642  O   THR A 402      16.535   1.979  16.442  1.00  1.79           O  
ATOM    643  CB  THR A 402      18.218   0.452  17.931  1.00  1.14           C  
ATOM    644  OG1 THR A 402      18.157   1.284  19.097  1.00  1.38           O  
ATOM    645  CG2 THR A 402      19.057  -0.784  18.215  1.00  1.29           C  
ATOM    646  H   THR A 402      20.034   2.405  18.013  1.00  0.85           H  
ATOM    647  HA  THR A 402      19.071   0.539  15.975  1.00  1.02           H  
ATOM    648  HB  THR A 402      17.218   0.137  17.675  1.00  1.29           H  
ATOM    649  HG1 THR A 402      18.723   2.050  18.974  1.00  1.65           H  
ATOM    650 HG21 THR A 402      19.151  -1.367  17.309  1.00  1.62           H  
ATOM    651 HG22 THR A 402      20.038  -0.485  18.554  1.00  1.72           H  
ATOM    652 HG23 THR A 402      18.578  -1.378  18.978  1.00  1.77           H  
ATOM    653  N   THR A 403      18.155   3.189  15.444  1.00  1.43           N  
ATOM    654  CA  THR A 403      17.238   4.160  14.843  1.00  1.62           C  
ATOM    655  C   THR A 403      16.218   4.675  15.871  1.00  1.84           C  
ATOM    656  O   THR A 403      16.315   4.374  17.061  1.00  1.85           O  
ATOM    657  CB  THR A 403      16.504   3.541  13.634  1.00  1.77           C  
ATOM    658  OG1 THR A 403      17.416   2.733  12.881  1.00  1.78           O  
ATOM    659  CG2 THR A 403      15.939   4.617  12.716  1.00  1.95           C  
ATOM    660  H   THR A 403      19.115   3.276  15.275  1.00  1.94           H  
ATOM    661  HA  THR A 403      17.826   4.994  14.490  1.00  1.60           H  
ATOM    662  HB  THR A 403      15.693   2.927  13.993  1.00  1.85           H  
ATOM    663  HG1 THR A 403      18.081   2.367  13.470  1.00  1.98           H  
ATOM    664 HG21 THR A 403      16.359   5.575  12.982  1.00  2.13           H  
ATOM    665 HG22 THR A 403      16.189   4.386  11.692  1.00  2.29           H  
ATOM    666 HG23 THR A 403      14.864   4.652  12.824  1.00  2.30           H  
ATOM    667  N   GLU A 404      15.251   5.463  15.409  1.00  2.08           N  
ATOM    668  CA  GLU A 404      14.228   6.020  16.288  1.00  2.34           C  
ATOM    669  C   GLU A 404      13.292   4.934  16.813  1.00  2.30           C  
ATOM    670  O   GLU A 404      12.910   4.942  17.983  1.00  2.37           O  
ATOM    671  CB  GLU A 404      13.414   7.082  15.545  1.00  2.72           C  
ATOM    672  CG  GLU A 404      14.247   8.244  15.035  1.00  2.91           C  
ATOM    673  CD  GLU A 404      13.420   9.275  14.290  1.00  3.42           C  
ATOM    674  OE1 GLU A 404      12.192   9.078  14.170  1.00  3.79           O  
ATOM    675  OE2 GLU A 404      14.000  10.279  13.826  1.00  3.87           O  
ATOM    676  H   GLU A 404      15.227   5.680  14.457  1.00  2.11           H  
ATOM    677  HA  GLU A 404      14.725   6.485  17.126  1.00  2.36           H  
ATOM    678  HB2 GLU A 404      12.926   6.617  14.701  1.00  2.90           H  
ATOM    679  HB3 GLU A 404      12.661   7.473  16.213  1.00  2.84           H  
ATOM    680  HG2 GLU A 404      14.723   8.727  15.875  1.00  3.03           H  
ATOM    681  HG3 GLU A 404      15.005   7.860  14.365  1.00  3.07           H  
ATOM    682  N   ASN A 405      12.913   4.010  15.932  1.00  2.26           N  
ATOM    683  CA  ASN A 405      12.007   2.923  16.296  1.00  2.30           C  
ATOM    684  C   ASN A 405      12.528   2.145  17.504  1.00  2.07           C  
ATOM    685  O   ASN A 405      11.811   1.964  18.489  1.00  2.40           O  
ATOM    686  CB  ASN A 405      11.815   1.982  15.104  1.00  2.43           C  
ATOM    687  CG  ASN A 405      10.799   0.892  15.382  1.00  2.67           C  
ATOM    688  OD1 ASN A 405      10.979   0.075  16.282  1.00  3.16           O  
ATOM    689  ND2 ASN A 405       9.720   0.876  14.608  1.00  2.73           N  
ATOM    690  H   ASN A 405      13.244   4.067  15.012  1.00  2.26           H  
ATOM    691  HA  ASN A 405      11.055   3.361  16.551  1.00  2.52           H  
ATOM    692  HB2 ASN A 405      11.476   2.554  14.254  1.00  2.67           H  
ATOM    693  HB3 ASN A 405      12.760   1.516  14.865  1.00  2.30           H  
ATOM    694 HD21 ASN A 405       9.641   1.560  13.909  1.00  2.82           H  
ATOM    695 HD22 ASN A 405       9.046   0.183  14.766  1.00  2.96           H  
ATOM    696  N   ALA A 406      13.776   1.697  17.424  1.00  1.82           N  
ATOM    697  CA  ALA A 406      14.398   0.947  18.515  1.00  1.67           C  
ATOM    698  C   ALA A 406      13.572  -0.282  18.901  1.00  1.85           C  
ATOM    699  O   ALA A 406      13.133  -0.415  20.043  1.00  2.18           O  
ATOM    700  CB  ALA A 406      14.609   1.848  19.720  1.00  1.72           C  
ATOM    701  H   ALA A 406      14.298   1.878  16.614  1.00  2.00           H  
ATOM    702  HA  ALA A 406      15.368   0.616  18.173  1.00  1.53           H  
ATOM    703  HB1 ALA A 406      13.947   1.546  20.517  1.00  1.91           H  
ATOM    704  HB2 ALA A 406      14.401   2.871  19.446  1.00  2.07           H  
ATOM    705  HB3 ALA A 406      15.634   1.765  20.054  1.00  2.10           H  
ATOM    706  N   ALA A 407      13.375  -1.174  17.938  1.00  1.91           N  
ATOM    707  CA  ALA A 407      12.613  -2.398  18.160  1.00  2.19           C  
ATOM    708  C   ALA A 407      12.890  -3.394  17.044  1.00  2.37           C  
ATOM    709  O   ALA A 407      12.212  -4.411  16.909  1.00  2.77           O  
ATOM    710  CB  ALA A 407      11.128  -2.093  18.242  1.00  2.38           C  
ATOM    711  H   ALA A 407      13.756  -1.008  17.051  1.00  1.96           H  
ATOM    712  HA  ALA A 407      12.927  -2.825  19.102  1.00  2.22           H  
ATOM    713  HB1 ALA A 407      10.988  -1.091  18.617  1.00  2.52           H  
ATOM    714  HB2 ALA A 407      10.650  -2.799  18.905  1.00  2.76           H  
ATOM    715  HB3 ALA A 407      10.692  -2.172  17.256  1.00  2.63           H  
ATOM    716  N   ALA A 408      13.902  -3.072  16.249  1.00  2.15           N  
ATOM    717  CA  ALA A 408      14.318  -3.897  15.124  1.00  2.35           C  
ATOM    718  C   ALA A 408      15.546  -3.286  14.445  1.00  2.05           C  
ATOM    719  O   ALA A 408      16.538  -3.978  14.216  1.00  1.99           O  
ATOM    720  CB  ALA A 408      13.180  -4.064  14.124  1.00  2.76           C  
ATOM    721  H   ALA A 408      14.392  -2.243  16.428  1.00  1.90           H  
ATOM    722  HA  ALA A 408      14.579  -4.873  15.506  1.00  2.50           H  
ATOM    723  HB1 ALA A 408      12.750  -5.050  14.228  1.00  3.28           H  
ATOM    724  HB2 ALA A 408      12.422  -3.319  14.313  1.00  3.03           H  
ATOM    725  HB3 ALA A 408      13.562  -3.944  13.121  1.00  2.78           H  
ATOM    726  N   PRO A 409      15.506  -1.974  14.121  1.00  1.99           N  
ATOM    727  CA  PRO A 409      16.633  -1.287  13.481  1.00  1.80           C  
ATOM    728  C   PRO A 409      17.878  -1.283  14.351  1.00  1.41           C  
ATOM    729  O   PRO A 409      17.786  -1.210  15.572  1.00  1.86           O  
ATOM    730  CB  PRO A 409      16.123   0.140  13.266  1.00  2.10           C  
ATOM    731  CG  PRO A 409      15.011   0.302  14.239  1.00  2.49           C  
ATOM    732  CD  PRO A 409      14.375  -1.050  14.355  1.00  2.27           C  
ATOM    733  HA  PRO A 409      16.874  -1.727  12.537  1.00  1.94           H  
ATOM    734  HB2 PRO A 409      16.922   0.842  13.458  1.00  2.00           H  
ATOM    735  HB3 PRO A 409      15.776   0.251  12.249  1.00  2.29           H  
ATOM    736  HG2 PRO A 409      15.402   0.617  15.196  1.00  2.74           H  
ATOM    737  HG3 PRO A 409      14.298   1.021  13.867  1.00  2.87           H  
ATOM    738  HD2 PRO A 409      13.959  -1.189  15.341  1.00  2.22           H  
ATOM    739  HD3 PRO A 409      13.614  -1.177  13.601  1.00  2.54           H  
ATOM    740  N   ASP A 410      19.041  -1.366  13.707  1.00  0.92           N  
ATOM    741  CA  ASP A 410      20.316  -1.368  14.415  1.00  0.79           C  
ATOM    742  C   ASP A 410      21.480  -1.433  13.432  1.00  0.68           C  
ATOM    743  O   ASP A 410      21.558  -2.339  12.601  1.00  0.93           O  
ATOM    744  CB  ASP A 410      20.390  -2.546  15.391  1.00  1.18           C  
ATOM    745  CG  ASP A 410      20.297  -3.887  14.692  1.00  1.62           C  
ATOM    746  OD1 ASP A 410      19.276  -4.136  14.018  1.00  1.99           O  
ATOM    747  OD2 ASP A 410      21.246  -4.689  14.820  1.00  2.14           O  
ATOM    748  H   ASP A 410      19.039  -1.423  12.729  1.00  1.11           H  
ATOM    749  HA  ASP A 410      20.383  -0.446  14.973  1.00  0.99           H  
ATOM    750  HB2 ASP A 410      21.328  -2.503  15.924  1.00  1.50           H  
ATOM    751  HB3 ASP A 410      19.575  -2.470  16.098  1.00  1.35           H  
ATOM    752  N   GLU A 411      22.386  -0.467  13.538  1.00  0.54           N  
ATOM    753  CA  GLU A 411      23.556  -0.403  12.668  1.00  0.45           C  
ATOM    754  C   GLU A 411      24.820  -0.227  13.500  1.00  0.40           C  
ATOM    755  O   GLU A 411      24.832   0.539  14.463  1.00  0.42           O  
ATOM    756  CB  GLU A 411      23.430   0.748  11.664  1.00  0.49           C  
ATOM    757  CG  GLU A 411      22.332   0.557  10.628  1.00  0.58           C  
ATOM    758  CD  GLU A 411      20.939   0.562  11.228  1.00  1.47           C  
ATOM    759  OE1 GLU A 411      20.574   1.567  11.874  1.00  2.10           O  
ATOM    760  OE2 GLU A 411      20.212  -0.439  11.048  1.00  2.08           O  
ATOM    761  H   GLU A 411      22.267   0.222  14.223  1.00  0.68           H  
ATOM    762  HA  GLU A 411      23.621  -1.339  12.130  1.00  0.49           H  
ATOM    763  HB2 GLU A 411      23.223   1.659  12.208  1.00  0.55           H  
ATOM    764  HB3 GLU A 411      24.371   0.857  11.144  1.00  0.51           H  
ATOM    765  HG2 GLU A 411      22.395   1.358   9.905  1.00  0.98           H  
ATOM    766  HG3 GLU A 411      22.489  -0.387  10.127  1.00  1.09           H  
ATOM    767  N   TYR A 412      25.874  -0.946  13.137  1.00  0.38           N  
ATOM    768  CA  TYR A 412      27.135  -0.870  13.869  1.00  0.35           C  
ATOM    769  C   TYR A 412      28.217  -0.168  13.055  1.00  0.33           C  
ATOM    770  O   TYR A 412      28.425  -0.476  11.883  1.00  0.34           O  
ATOM    771  CB  TYR A 412      27.621  -2.272  14.244  1.00  0.39           C  
ATOM    772  CG  TYR A 412      26.733  -3.010  15.223  1.00  0.45           C  
ATOM    773  CD1 TYR A 412      25.368  -3.146  15.000  1.00  0.50           C  
ATOM    774  CD2 TYR A 412      27.270  -3.582  16.369  1.00  0.53           C  
ATOM    775  CE1 TYR A 412      24.564  -3.829  15.891  1.00  0.58           C  
ATOM    776  CE2 TYR A 412      26.473  -4.266  17.267  1.00  0.61           C  
ATOM    777  CZ  TYR A 412      25.123  -4.387  17.023  1.00  0.62           C  
ATOM    778  OH  TYR A 412      24.329  -5.071  17.912  1.00  0.72           O  
ATOM    779  H   TYR A 412      25.804  -1.548  12.367  1.00  0.41           H  
ATOM    780  HA  TYR A 412      26.959  -0.308  14.773  1.00  0.36           H  
ATOM    781  HB2 TYR A 412      27.687  -2.868  13.349  1.00  0.41           H  
ATOM    782  HB3 TYR A 412      28.603  -2.191  14.687  1.00  0.40           H  
ATOM    783  HD1 TYR A 412      24.935  -2.706  14.113  1.00  0.52           H  
ATOM    784  HD2 TYR A 412      28.329  -3.485  16.558  1.00  0.58           H  
ATOM    785  HE1 TYR A 412      23.507  -3.924  15.701  1.00  0.66           H  
ATOM    786  HE2 TYR A 412      26.911  -4.703  18.151  1.00  0.70           H  
ATOM    787  HH  TYR A 412      24.367  -4.643  18.770  1.00  1.06           H  
ATOM    788  N   TYR A 413      28.922   0.759  13.697  1.00  0.33           N  
ATOM    789  CA  TYR A 413      30.005   1.482  13.044  1.00  0.32           C  
ATOM    790  C   TYR A 413      31.202   0.556  12.873  1.00  0.32           C  
ATOM    791  O   TYR A 413      31.723   0.026  13.853  1.00  0.40           O  
ATOM    792  CB  TYR A 413      30.409   2.692  13.886  1.00  0.36           C  
ATOM    793  CG  TYR A 413      31.445   3.576  13.228  1.00  0.38           C  
ATOM    794  CD1 TYR A 413      31.242   4.093  11.954  1.00  0.40           C  
ATOM    795  CD2 TYR A 413      32.627   3.897  13.885  1.00  0.44           C  
ATOM    796  CE1 TYR A 413      32.188   4.902  11.353  1.00  0.44           C  
ATOM    797  CE2 TYR A 413      33.576   4.706  13.290  1.00  0.48           C  
ATOM    798  CZ  TYR A 413      33.353   5.206  12.025  1.00  0.46           C  
ATOM    799  OH  TYR A 413      34.296   6.011  11.431  1.00  0.51           O  
ATOM    800  H   TYR A 413      28.721   0.946  14.635  1.00  0.35           H  
ATOM    801  HA  TYR A 413      29.663   1.813  12.076  1.00  0.33           H  
ATOM    802  HB2 TYR A 413      29.535   3.294  14.083  1.00  0.38           H  
ATOM    803  HB3 TYR A 413      30.819   2.341  14.824  1.00  0.37           H  
ATOM    804  HD1 TYR A 413      30.328   3.855  11.430  1.00  0.42           H  
ATOM    805  HD2 TYR A 413      32.800   3.503  14.875  1.00  0.49           H  
ATOM    806  HE1 TYR A 413      32.012   5.293  10.361  1.00  0.49           H  
ATOM    807  HE2 TYR A 413      34.488   4.944  13.819  1.00  0.55           H  
ATOM    808  HH  TYR A 413      34.064   6.151  10.509  1.00  1.05           H  
ATOM    809  N   VAL A 414      31.632   0.346  11.634  1.00  0.33           N  
ATOM    810  CA  VAL A 414      32.757  -0.543  11.375  1.00  0.33           C  
ATOM    811  C   VAL A 414      33.984   0.201  10.856  1.00  0.29           C  
ATOM    812  O   VAL A 414      33.882   1.091  10.011  1.00  0.38           O  
ATOM    813  CB  VAL A 414      32.382  -1.650  10.373  1.00  0.39           C  
ATOM    814  CG1 VAL A 414      31.951  -1.051   9.045  1.00  1.09           C  
ATOM    815  CG2 VAL A 414      33.544  -2.611  10.182  1.00  1.15           C  
ATOM    816  H   VAL A 414      31.178   0.782  10.885  1.00  0.40           H  
ATOM    817  HA  VAL A 414      33.018  -1.018  12.309  1.00  0.36           H  
ATOM    818  HB  VAL A 414      31.548  -2.206  10.778  1.00  1.07           H  
ATOM    819 HG11 VAL A 414      32.281  -0.025   8.987  1.00  1.58           H  
ATOM    820 HG12 VAL A 414      32.391  -1.617   8.237  1.00  1.65           H  
ATOM    821 HG13 VAL A 414      30.874  -1.089   8.966  1.00  1.74           H  
ATOM    822 HG21 VAL A 414      34.466  -2.120  10.458  1.00  1.84           H  
ATOM    823 HG22 VAL A 414      33.398  -3.480  10.807  1.00  1.58           H  
ATOM    824 HG23 VAL A 414      33.594  -2.916   9.148  1.00  1.76           H  
ATOM    825  N   HIS A 415      35.145  -0.199  11.361  1.00  0.33           N  
ATOM    826  CA  HIS A 415      36.416   0.383  10.955  1.00  0.32           C  
ATOM    827  C   HIS A 415      37.312  -0.708  10.379  1.00  0.32           C  
ATOM    828  O   HIS A 415      38.075  -1.344  11.107  1.00  0.34           O  
ATOM    829  CB  HIS A 415      37.101   1.052  12.150  1.00  0.37           C  
ATOM    830  CG  HIS A 415      38.385   1.739  11.800  1.00  0.44           C  
ATOM    831  ND1 HIS A 415      38.451   2.814  10.939  1.00  0.50           N  
ATOM    832  CD2 HIS A 415      39.657   1.498  12.198  1.00  0.54           C  
ATOM    833  CE1 HIS A 415      39.709   3.205  10.823  1.00  0.60           C  
ATOM    834  NE2 HIS A 415      40.459   2.424  11.575  1.00  0.62           N  
ATOM    835  H   HIS A 415      35.148  -0.927  12.015  1.00  0.43           H  
ATOM    836  HA  HIS A 415      36.221   1.123  10.193  1.00  0.33           H  
ATOM    837  HB2 HIS A 415      36.436   1.789  12.574  1.00  0.40           H  
ATOM    838  HB3 HIS A 415      37.319   0.301  12.896  1.00  0.39           H  
ATOM    839  HD1 HIS A 415      37.690   3.230  10.484  1.00  0.52           H  
ATOM    840  HD2 HIS A 415      39.980   0.723  12.877  1.00  0.59           H  
ATOM    841  HE1 HIS A 415      40.060   4.025  10.214  1.00  0.68           H  
ATOM    842  HE2 HIS A 415      41.437   2.455  11.623  1.00  0.71           H  
ATOM    843  N   TYR A 416      37.199  -0.935   9.073  1.00  0.37           N  
ATOM    844  CA  TYR A 416      37.984  -1.968   8.406  1.00  0.40           C  
ATOM    845  C   TYR A 416      39.471  -1.809   8.698  1.00  0.45           C  
ATOM    846  O   TYR A 416      40.086  -0.809   8.327  1.00  0.57           O  
ATOM    847  CB  TYR A 416      37.739  -1.935   6.895  1.00  0.46           C  
ATOM    848  CG  TYR A 416      36.289  -2.124   6.509  1.00  0.47           C  
ATOM    849  CD1 TYR A 416      35.387  -1.068   6.578  1.00  0.53           C  
ATOM    850  CD2 TYR A 416      35.821  -3.354   6.065  1.00  0.51           C  
ATOM    851  CE1 TYR A 416      34.063  -1.234   6.219  1.00  0.59           C  
ATOM    852  CE2 TYR A 416      34.498  -3.529   5.703  1.00  0.54           C  
ATOM    853  CZ  TYR A 416      33.624  -2.465   5.784  1.00  0.57           C  
ATOM    854  OH  TYR A 416      32.307  -2.635   5.426  1.00  0.65           O  
ATOM    855  H   TYR A 416      36.563  -0.405   8.551  1.00  0.42           H  
ATOM    856  HA  TYR A 416      37.658  -2.924   8.789  1.00  0.39           H  
ATOM    857  HB2 TYR A 416      38.065  -0.982   6.506  1.00  0.51           H  
ATOM    858  HB3 TYR A 416      38.313  -2.724   6.429  1.00  0.50           H  
ATOM    859  HD1 TYR A 416      35.734  -0.102   6.919  1.00  0.59           H  
ATOM    860  HD2 TYR A 416      36.510  -4.184   6.006  1.00  0.56           H  
ATOM    861  HE1 TYR A 416      33.378  -0.402   6.281  1.00  0.69           H  
ATOM    862  HE2 TYR A 416      34.155  -4.495   5.363  1.00  0.61           H  
ATOM    863  HH  TYR A 416      32.046  -3.546   5.584  1.00  1.13           H  
ATOM    864  N   VAL A 417      40.040  -2.805   9.371  1.00  0.45           N  
ATOM    865  CA  VAL A 417      41.454  -2.787   9.722  1.00  0.55           C  
ATOM    866  C   VAL A 417      42.334  -2.762   8.481  1.00  0.66           C  
ATOM    867  O   VAL A 417      42.181  -3.586   7.581  1.00  1.34           O  
ATOM    868  CB  VAL A 417      41.835  -4.006  10.583  1.00  0.68           C  
ATOM    869  CG1 VAL A 417      43.314  -3.972  10.943  1.00  1.10           C  
ATOM    870  CG2 VAL A 417      40.979  -4.055  11.836  1.00  1.01           C  
ATOM    871  H   VAL A 417      39.493  -3.574   9.639  1.00  0.45           H  
ATOM    872  HA  VAL A 417      41.642  -1.893  10.300  1.00  0.55           H  
ATOM    873  HB  VAL A 417      41.648  -4.901  10.009  1.00  0.84           H  
ATOM    874 HG11 VAL A 417      43.902  -3.878  10.043  1.00  1.53           H  
ATOM    875 HG12 VAL A 417      43.507  -3.129  11.590  1.00  1.70           H  
ATOM    876 HG13 VAL A 417      43.581  -4.886  11.454  1.00  1.57           H  
ATOM    877 HG21 VAL A 417      39.968  -3.763  11.591  1.00  1.48           H  
ATOM    878 HG22 VAL A 417      40.978  -5.060  12.233  1.00  1.56           H  
ATOM    879 HG23 VAL A 417      41.382  -3.375  12.571  1.00  1.54           H  
ATOM    880  N   GLY A 418      43.265  -1.818   8.452  1.00  0.71           N  
ATOM    881  CA  GLY A 418      44.174  -1.697   7.325  1.00  0.82           C  
ATOM    882  C   GLY A 418      43.541  -1.040   6.107  1.00  0.72           C  
ATOM    883  O   GLY A 418      44.169  -0.211   5.450  1.00  0.76           O  
ATOM    884  H   GLY A 418      43.339  -1.200   9.210  1.00  1.17           H  
ATOM    885  HA2 GLY A 418      45.026  -1.106   7.629  1.00  0.94           H  
ATOM    886  HA3 GLY A 418      44.517  -2.683   7.049  1.00  0.94           H  
ATOM    887  N   LEU A 419      42.302  -1.417   5.800  1.00  0.66           N  
ATOM    888  CA  LEU A 419      41.596  -0.863   4.646  1.00  0.60           C  
ATOM    889  C   LEU A 419      41.452   0.654   4.751  1.00  0.59           C  
ATOM    890  O   LEU A 419      41.581   1.230   5.831  1.00  0.76           O  
ATOM    891  CB  LEU A 419      40.213  -1.503   4.495  1.00  0.58           C  
ATOM    892  CG  LEU A 419      40.210  -2.949   3.988  1.00  0.78           C  
ATOM    893  CD1 LEU A 419      40.787  -3.894   5.027  1.00  1.60           C  
ATOM    894  CD2 LEU A 419      38.800  -3.371   3.600  1.00  1.40           C  
ATOM    895  H   LEU A 419      41.854  -2.088   6.354  1.00  0.72           H  
ATOM    896  HA  LEU A 419      42.179  -1.091   3.767  1.00  0.67           H  
ATOM    897  HB2 LEU A 419      39.725  -1.484   5.458  1.00  0.73           H  
ATOM    898  HB3 LEU A 419      39.637  -0.904   3.807  1.00  0.65           H  
ATOM    899  HG  LEU A 419      40.829  -3.009   3.106  1.00  1.43           H  
ATOM    900 HD11 LEU A 419      40.322  -3.706   5.983  1.00  2.09           H  
ATOM    901 HD12 LEU A 419      40.600  -4.916   4.730  1.00  2.15           H  
ATOM    902 HD13 LEU A 419      41.852  -3.733   5.109  1.00  2.14           H  
ATOM    903 HD21 LEU A 419      38.143  -3.255   4.449  1.00  1.98           H  
ATOM    904 HD22 LEU A 419      38.450  -2.752   2.786  1.00  1.92           H  
ATOM    905 HD23 LEU A 419      38.806  -4.404   3.287  1.00  1.94           H  
ATOM    906  N   ASN A 420      41.190   1.285   3.608  1.00  0.61           N  
ATOM    907  CA  ASN A 420      41.026   2.735   3.536  1.00  0.63           C  
ATOM    908  C   ASN A 420      40.052   3.251   4.588  1.00  0.56           C  
ATOM    909  O   ASN A 420      39.028   2.625   4.864  1.00  0.56           O  
ATOM    910  CB  ASN A 420      40.530   3.137   2.146  1.00  0.75           C  
ATOM    911  CG  ASN A 420      41.558   2.886   1.063  1.00  1.57           C  
ATOM    912  OD1 ASN A 420      42.033   1.763   0.886  1.00  2.53           O  
ATOM    913  ND2 ASN A 420      41.900   3.935   0.328  1.00  1.98           N  
ATOM    914  H   ASN A 420      41.104   0.759   2.786  1.00  0.75           H  
ATOM    915  HA  ASN A 420      41.992   3.185   3.705  1.00  0.71           H  
ATOM    916  HB2 ASN A 420      39.643   2.570   1.911  1.00  1.30           H  
ATOM    917  HB3 ASN A 420      40.289   4.188   2.149  1.00  1.19           H  
ATOM    918 HD21 ASN A 420      41.478   4.796   0.527  1.00  1.91           H  
ATOM    919 HD22 ASN A 420      42.559   3.807  -0.385  1.00  2.76           H  
ATOM    920  N   ARG A 421      40.379   4.403   5.166  1.00  0.62           N  
ATOM    921  CA  ARG A 421      39.536   5.021   6.183  1.00  0.67           C  
ATOM    922  C   ARG A 421      38.194   5.444   5.592  1.00  0.66           C  
ATOM    923  O   ARG A 421      37.159   5.349   6.251  1.00  0.69           O  
ATOM    924  CB  ARG A 421      40.244   6.227   6.802  1.00  0.87           C  
ATOM    925  CG  ARG A 421      41.497   5.857   7.582  1.00  1.09           C  
ATOM    926  CD  ARG A 421      42.164   7.085   8.177  1.00  1.51           C  
ATOM    927  NE  ARG A 421      42.627   8.010   7.148  1.00  2.25           N  
ATOM    928  CZ  ARG A 421      43.245   9.158   7.412  1.00  3.00           C  
ATOM    929  NH1 ARG A 421      43.466   9.523   8.667  1.00  3.28           N  
ATOM    930  NH2 ARG A 421      43.642   9.942   6.419  1.00  3.98           N  
ATOM    931  H   ARG A 421      41.205   4.854   4.895  1.00  0.68           H  
ATOM    932  HA  ARG A 421      39.359   4.286   6.952  1.00  0.66           H  
ATOM    933  HB2 ARG A 421      40.526   6.909   6.014  1.00  1.30           H  
ATOM    934  HB3 ARG A 421      39.562   6.726   7.473  1.00  1.29           H  
ATOM    935  HG2 ARG A 421      41.225   5.185   8.381  1.00  1.61           H  
ATOM    936  HG3 ARG A 421      42.191   5.367   6.916  1.00  1.39           H  
ATOM    937  HD2 ARG A 421      41.455   7.594   8.812  1.00  1.91           H  
ATOM    938  HD3 ARG A 421      43.010   6.767   8.770  1.00  1.94           H  
ATOM    939  HE  ARG A 421      42.473   7.763   6.211  1.00  2.72           H  
ATOM    940 HH11 ARG A 421      43.169   8.935   9.419  1.00  2.99           H  
ATOM    941 HH12 ARG A 421      43.931  10.387   8.861  1.00  4.12           H  
ATOM    942 HH21 ARG A 421      43.477   9.670   5.470  1.00  4.27           H  
ATOM    943 HH22 ARG A 421      44.107  10.805   6.618  1.00  4.65           H  
ATOM    944  N   ARG A 422      38.219   5.907   4.344  1.00  0.71           N  
ATOM    945  CA  ARG A 422      37.003   6.340   3.663  1.00  0.83           C  
ATOM    946  C   ARG A 422      35.962   5.223   3.656  1.00  0.72           C  
ATOM    947  O   ARG A 422      34.762   5.476   3.758  1.00  0.77           O  
ATOM    948  CB  ARG A 422      37.325   6.771   2.227  1.00  1.01           C  
ATOM    949  CG  ARG A 422      37.886   5.654   1.363  1.00  1.19           C  
ATOM    950  CD  ARG A 422      38.222   6.132  -0.047  1.00  1.49           C  
ATOM    951  NE  ARG A 422      37.037   6.560  -0.794  1.00  2.09           N  
ATOM    952  CZ  ARG A 422      36.489   7.770  -0.699  1.00  2.79           C  
ATOM    953  NH1 ARG A 422      37.052   8.702   0.059  1.00  3.07           N  
ATOM    954  NH2 ARG A 422      35.388   8.055  -1.380  1.00  3.71           N  
ATOM    955  H   ARG A 422      39.075   5.958   3.871  1.00  0.72           H  
ATOM    956  HA  ARG A 422      36.602   7.186   4.203  1.00  0.93           H  
ATOM    957  HB2 ARG A 422      36.421   7.136   1.763  1.00  1.40           H  
ATOM    958  HB3 ARG A 422      38.051   7.572   2.259  1.00  1.63           H  
ATOM    959  HG2 ARG A 422      38.785   5.279   1.824  1.00  1.77           H  
ATOM    960  HG3 ARG A 422      37.155   4.863   1.299  1.00  1.59           H  
ATOM    961  HD2 ARG A 422      38.906   6.964   0.025  1.00  1.85           H  
ATOM    962  HD3 ARG A 422      38.700   5.324  -0.579  1.00  1.98           H  
ATOM    963  HE  ARG A 422      36.619   5.903  -1.389  1.00  2.50           H  
ATOM    964 HH11 ARG A 422      37.892   8.499   0.561  1.00  2.89           H  
ATOM    965 HH12 ARG A 422      36.634   9.609   0.128  1.00  3.81           H  
ATOM    966 HH21 ARG A 422      34.970   7.362  -1.968  1.00  4.01           H  
ATOM    967 HH22 ARG A 422      34.976   8.963  -1.308  1.00  4.32           H  
ATOM    968  N   LEU A 423      36.440   3.989   3.535  1.00  0.65           N  
ATOM    969  CA  LEU A 423      35.568   2.817   3.512  1.00  0.62           C  
ATOM    970  C   LEU A 423      34.735   2.716   4.789  1.00  0.52           C  
ATOM    971  O   LEU A 423      33.589   2.268   4.760  1.00  0.53           O  
ATOM    972  CB  LEU A 423      36.406   1.547   3.345  1.00  0.69           C  
ATOM    973  CG  LEU A 423      37.287   1.504   2.093  1.00  0.89           C  
ATOM    974  CD1 LEU A 423      38.173   0.268   2.106  1.00  1.31           C  
ATOM    975  CD2 LEU A 423      36.431   1.528   0.836  1.00  1.49           C  
ATOM    976  H   LEU A 423      37.407   3.859   3.458  1.00  0.67           H  
ATOM    977  HA  LEU A 423      34.903   2.912   2.667  1.00  0.70           H  
ATOM    978  HB2 LEU A 423      37.045   1.447   4.211  1.00  0.84           H  
ATOM    979  HB3 LEU A 423      35.737   0.701   3.314  1.00  0.96           H  
ATOM    980  HG  LEU A 423      37.927   2.374   2.080  1.00  1.73           H  
ATOM    981 HD11 LEU A 423      38.038  -0.262   3.038  1.00  1.89           H  
ATOM    982 HD12 LEU A 423      37.905  -0.376   1.282  1.00  1.84           H  
ATOM    983 HD13 LEU A 423      39.207   0.567   2.008  1.00  1.77           H  
ATOM    984 HD21 LEU A 423      35.572   2.163   0.999  1.00  2.04           H  
ATOM    985 HD22 LEU A 423      37.013   1.913   0.011  1.00  1.97           H  
ATOM    986 HD23 LEU A 423      36.100   0.526   0.608  1.00  2.03           H  
ATOM    987  N   ASP A 424      35.329   3.120   5.909  1.00  0.49           N  
ATOM    988  CA  ASP A 424      34.657   3.060   7.205  1.00  0.50           C  
ATOM    989  C   ASP A 424      33.317   3.790   7.186  1.00  0.45           C  
ATOM    990  O   ASP A 424      33.184   4.865   6.603  1.00  0.49           O  
ATOM    991  CB  ASP A 424      35.551   3.653   8.294  1.00  0.66           C  
ATOM    992  CG  ASP A 424      36.921   3.007   8.331  1.00  0.81           C  
ATOM    993  OD1 ASP A 424      36.989   1.763   8.392  1.00  0.97           O  
ATOM    994  OD2 ASP A 424      37.925   3.747   8.306  1.00  1.20           O  
ATOM    995  H   ASP A 424      36.249   3.455   5.866  1.00  0.54           H  
ATOM    996  HA  ASP A 424      34.479   2.020   7.433  1.00  0.53           H  
ATOM    997  HB2 ASP A 424      35.677   4.710   8.112  1.00  0.64           H  
ATOM    998  HB3 ASP A 424      35.079   3.510   9.254  1.00  0.77           H  
ATOM    999  N   GLY A 425      32.329   3.189   7.846  1.00  0.44           N  
ATOM   1000  CA  GLY A 425      31.003   3.778   7.920  1.00  0.50           C  
ATOM   1001  C   GLY A 425      30.043   2.909   8.710  1.00  0.45           C  
ATOM   1002  O   GLY A 425      30.464   2.142   9.574  1.00  0.70           O  
ATOM   1003  H   GLY A 425      32.505   2.337   8.295  1.00  0.44           H  
ATOM   1004  HA2 GLY A 425      31.074   4.746   8.393  1.00  0.64           H  
ATOM   1005  HA3 GLY A 425      30.619   3.902   6.918  1.00  0.55           H  
ATOM   1006  N   TRP A 426      28.753   3.020   8.410  1.00  0.50           N  
ATOM   1007  CA  TRP A 426      27.743   2.226   9.100  1.00  0.44           C  
ATOM   1008  C   TRP A 426      27.414   0.958   8.319  1.00  0.45           C  
ATOM   1009  O   TRP A 426      27.333   0.977   7.090  1.00  0.57           O  
ATOM   1010  CB  TRP A 426      26.471   3.039   9.342  1.00  0.47           C  
ATOM   1011  CG  TRP A 426      26.652   4.145  10.339  1.00  0.49           C  
ATOM   1012  CD1 TRP A 426      27.188   5.379  10.112  1.00  0.57           C  
ATOM   1013  CD2 TRP A 426      26.312   4.105  11.731  1.00  0.48           C  
ATOM   1014  NE1 TRP A 426      27.184   6.116  11.273  1.00  0.61           N  
ATOM   1015  CE2 TRP A 426      26.654   5.354  12.281  1.00  0.55           C  
ATOM   1016  CE3 TRP A 426      25.745   3.135  12.563  1.00  0.50           C  
ATOM   1017  CZ2 TRP A 426      26.447   5.657  13.625  1.00  0.59           C  
ATOM   1018  CZ3 TRP A 426      25.543   3.436  13.897  1.00  0.56           C  
ATOM   1019  CH2 TRP A 426      25.894   4.688  14.416  1.00  0.59           C  
ATOM   1020  H   TRP A 426      28.475   3.643   7.706  1.00  0.76           H  
ATOM   1021  HA  TRP A 426      28.155   1.938  10.056  1.00  0.40           H  
ATOM   1022  HB2 TRP A 426      26.152   3.481   8.410  1.00  0.54           H  
ATOM   1023  HB3 TRP A 426      25.696   2.382   9.709  1.00  0.48           H  
ATOM   1024  HD1 TRP A 426      27.548   5.719   9.151  1.00  0.64           H  
ATOM   1025  HE1 TRP A 426      27.512   7.034  11.364  1.00  0.69           H  
ATOM   1026  HE3 TRP A 426      25.471   2.163  12.181  1.00  0.51           H  
ATOM   1027  HZ2 TRP A 426      26.706   6.617  14.043  1.00  0.66           H  
ATOM   1028  HZ3 TRP A 426      25.110   2.698  14.554  1.00  0.62           H  
ATOM   1029  HH2 TRP A 426      25.719   4.880  15.464  1.00  0.66           H  
ATOM   1030  N   VAL A 427      27.228  -0.141   9.042  1.00  0.39           N  
ATOM   1031  CA  VAL A 427      26.912  -1.422   8.424  1.00  0.46           C  
ATOM   1032  C   VAL A 427      25.846  -2.172   9.213  1.00  0.51           C  
ATOM   1033  O   VAL A 427      25.883  -2.218  10.443  1.00  0.70           O  
ATOM   1034  CB  VAL A 427      28.161  -2.311   8.304  1.00  0.64           C  
ATOM   1035  CG1 VAL A 427      29.125  -1.751   7.275  1.00  0.89           C  
ATOM   1036  CG2 VAL A 427      28.845  -2.446   9.652  1.00  0.85           C  
ATOM   1037  H   VAL A 427      27.309  -0.089  10.018  1.00  0.36           H  
ATOM   1038  HA  VAL A 427      26.538  -1.228   7.428  1.00  0.51           H  
ATOM   1039  HB  VAL A 427      27.853  -3.294   7.981  1.00  0.82           H  
ATOM   1040 HG11 VAL A 427      28.962  -0.688   7.169  1.00  1.39           H  
ATOM   1041 HG12 VAL A 427      30.139  -1.930   7.599  1.00  1.37           H  
ATOM   1042 HG13 VAL A 427      28.961  -2.237   6.325  1.00  1.44           H  
ATOM   1043 HG21 VAL A 427      28.154  -2.866  10.368  1.00  1.41           H  
ATOM   1044 HG22 VAL A 427      29.703  -3.094   9.559  1.00  1.32           H  
ATOM   1045 HG23 VAL A 427      29.166  -1.472   9.993  1.00  1.42           H  
ATOM   1046  N   GLY A 428      24.901  -2.764   8.492  1.00  0.52           N  
ATOM   1047  CA  GLY A 428      23.833  -3.511   9.127  1.00  0.65           C  
ATOM   1048  C   GLY A 428      24.343  -4.702   9.913  1.00  0.79           C  
ATOM   1049  O   GLY A 428      25.373  -5.286   9.571  1.00  1.72           O  
ATOM   1050  H   GLY A 428      24.928  -2.693   7.514  1.00  0.55           H  
ATOM   1051  HA2 GLY A 428      23.298  -2.855   9.798  1.00  0.70           H  
ATOM   1052  HA3 GLY A 428      23.153  -3.861   8.366  1.00  0.71           H  
ATOM   1053  N   ARG A 429      23.620  -5.059  10.968  1.00  0.54           N  
ATOM   1054  CA  ARG A 429      23.990  -6.187  11.816  1.00  0.54           C  
ATOM   1055  C   ARG A 429      24.190  -7.459  10.993  1.00  0.49           C  
ATOM   1056  O   ARG A 429      25.084  -8.256  11.275  1.00  0.53           O  
ATOM   1057  CB  ARG A 429      22.914  -6.413  12.883  1.00  0.68           C  
ATOM   1058  CG  ARG A 429      23.149  -7.638  13.753  1.00  0.83           C  
ATOM   1059  CD  ARG A 429      24.459  -7.545  14.522  1.00  0.85           C  
ATOM   1060  NE  ARG A 429      24.673  -8.708  15.381  1.00  1.20           N  
ATOM   1061  CZ  ARG A 429      24.911  -9.935  14.921  1.00  1.26           C  
ATOM   1062  NH1 ARG A 429      25.037 -10.149  13.619  1.00  1.73           N  
ATOM   1063  NH2 ARG A 429      25.047 -10.945  15.769  1.00  1.65           N  
ATOM   1064  H   ARG A 429      22.810  -4.551  11.184  1.00  1.16           H  
ATOM   1065  HA  ARG A 429      24.921  -5.941  12.305  1.00  0.54           H  
ATOM   1066  HB2 ARG A 429      22.876  -5.545  13.525  1.00  0.75           H  
ATOM   1067  HB3 ARG A 429      21.959  -6.525  12.392  1.00  0.75           H  
ATOM   1068  HG2 ARG A 429      22.336  -7.723  14.459  1.00  1.02           H  
ATOM   1069  HG3 ARG A 429      23.170  -8.514  13.123  1.00  0.96           H  
ATOM   1070  HD2 ARG A 429      25.273  -7.477  13.816  1.00  0.83           H  
ATOM   1071  HD3 ARG A 429      24.439  -6.655  15.134  1.00  0.95           H  
ATOM   1072  HE  ARG A 429      24.618  -8.572  16.350  1.00  1.83           H  
ATOM   1073 HH11 ARG A 429      24.954  -9.388  12.976  1.00  1.78           H  
ATOM   1074 HH12 ARG A 429      25.216 -11.073  13.280  1.00  2.32           H  
ATOM   1075 HH21 ARG A 429      24.968 -10.786  16.754  1.00  2.00           H  
ATOM   1076 HH22 ARG A 429      25.227 -11.867  15.424  1.00  1.92           H  
ATOM   1077  N   HIS A 430      23.349  -7.647   9.980  1.00  0.49           N  
ATOM   1078  CA  HIS A 430      23.432  -8.826   9.123  1.00  0.53           C  
ATOM   1079  C   HIS A 430      24.797  -8.950   8.454  1.00  0.47           C  
ATOM   1080  O   HIS A 430      25.254 -10.055   8.160  1.00  0.49           O  
ATOM   1081  CB  HIS A 430      22.335  -8.801   8.058  1.00  0.65           C  
ATOM   1082  CG  HIS A 430      22.282  -7.534   7.263  1.00  0.77           C  
ATOM   1083  ND1 HIS A 430      21.979  -6.308   7.817  1.00  1.20           N  
ATOM   1084  CD2 HIS A 430      22.481  -7.308   5.943  1.00  1.47           C  
ATOM   1085  CE1 HIS A 430      21.992  -5.383   6.872  1.00  1.31           C  
ATOM   1086  NE2 HIS A 430      22.294  -5.965   5.726  1.00  1.46           N  
ATOM   1087  H   HIS A 430      22.653  -6.979   9.806  1.00  0.54           H  
ATOM   1088  HA  HIS A 430      23.282  -9.692   9.751  1.00  0.60           H  
ATOM   1089  HB2 HIS A 430      22.504  -9.613   7.366  1.00  0.79           H  
ATOM   1090  HB3 HIS A 430      21.376  -8.937   8.536  1.00  0.84           H  
ATOM   1091  HD1 HIS A 430      21.783  -6.139   8.764  1.00  1.81           H  
ATOM   1092  HD2 HIS A 430      22.738  -8.048   5.198  1.00  2.23           H  
ATOM   1093  HE1 HIS A 430      21.784  -4.334   7.012  1.00  1.79           H  
ATOM   1094  HE2 HIS A 430      22.261  -5.530   4.849  1.00  1.93           H  
ATOM   1095  N   ARG A 431      25.441  -7.816   8.206  1.00  0.43           N  
ATOM   1096  CA  ARG A 431      26.749  -7.812   7.559  1.00  0.41           C  
ATOM   1097  C   ARG A 431      27.854  -8.181   8.544  1.00  0.37           C  
ATOM   1098  O   ARG A 431      28.819  -8.852   8.181  1.00  0.57           O  
ATOM   1099  CB  ARG A 431      27.036  -6.443   6.939  1.00  0.44           C  
ATOM   1100  CG  ARG A 431      26.022  -6.031   5.885  1.00  0.53           C  
ATOM   1101  CD  ARG A 431      26.383  -4.696   5.256  1.00  0.64           C  
ATOM   1102  NE  ARG A 431      25.386  -4.266   4.279  1.00  1.39           N  
ATOM   1103  CZ  ARG A 431      25.447  -3.114   3.616  1.00  2.05           C  
ATOM   1104  NH1 ARG A 431      26.449  -2.272   3.832  1.00  2.55           N  
ATOM   1105  NH2 ARG A 431      24.502  -2.801   2.740  1.00  2.84           N  
ATOM   1106  H   ARG A 431      25.027  -6.964   8.454  1.00  0.44           H  
ATOM   1107  HA  ARG A 431      26.727  -8.552   6.772  1.00  0.45           H  
ATOM   1108  HB2 ARG A 431      27.034  -5.699   7.722  1.00  0.44           H  
ATOM   1109  HB3 ARG A 431      28.012  -6.465   6.479  1.00  0.48           H  
ATOM   1110  HG2 ARG A 431      25.992  -6.785   5.114  1.00  0.79           H  
ATOM   1111  HG3 ARG A 431      25.050  -5.948   6.349  1.00  0.68           H  
ATOM   1112  HD2 ARG A 431      26.456  -3.952   6.035  1.00  1.04           H  
ATOM   1113  HD3 ARG A 431      27.339  -4.792   4.762  1.00  1.03           H  
ATOM   1114  HE  ARG A 431      24.633  -4.868   4.105  1.00  1.96           H  
ATOM   1115 HH11 ARG A 431      27.162  -2.501   4.493  1.00  2.45           H  
ATOM   1116 HH12 ARG A 431      26.491  -1.407   3.331  1.00  3.35           H  
ATOM   1117 HH21 ARG A 431      23.742  -3.431   2.577  1.00  3.11           H  
ATOM   1118 HH22 ARG A 431      24.547  -1.935   2.243  1.00  3.42           H  
ATOM   1119  N   ILE A 432      27.711  -7.743   9.790  1.00  0.39           N  
ATOM   1120  CA  ILE A 432      28.703  -8.038  10.817  1.00  0.36           C  
ATOM   1121  C   ILE A 432      28.387  -9.347  11.534  1.00  0.38           C  
ATOM   1122  O   ILE A 432      27.229  -9.643  11.831  1.00  0.44           O  
ATOM   1123  CB  ILE A 432      28.804  -6.899  11.850  1.00  0.38           C  
ATOM   1124  CG1 ILE A 432      29.219  -5.601  11.154  1.00  0.40           C  
ATOM   1125  CG2 ILE A 432      29.794  -7.265  12.951  1.00  0.42           C  
ATOM   1126  CD1 ILE A 432      29.397  -4.431  12.096  1.00  0.46           C  
ATOM   1127  H   ILE A 432      26.921  -7.213  10.024  1.00  0.58           H  
ATOM   1128  HA  ILE A 432      29.662  -8.134  10.330  1.00  0.36           H  
ATOM   1129  HB  ILE A 432      27.833  -6.765  12.304  1.00  0.42           H  
ATOM   1130 HG12 ILE A 432      30.156  -5.759  10.644  1.00  0.45           H  
ATOM   1131 HG13 ILE A 432      28.462  -5.333  10.432  1.00  0.41           H  
ATOM   1132 HG21 ILE A 432      30.514  -7.973  12.567  1.00  1.14           H  
ATOM   1133 HG22 ILE A 432      30.308  -6.373  13.282  1.00  1.08           H  
ATOM   1134 HG23 ILE A 432      29.263  -7.703  13.782  1.00  1.07           H  
ATOM   1135 HD11 ILE A 432      30.104  -4.696  12.867  1.00  1.14           H  
ATOM   1136 HD12 ILE A 432      29.768  -3.580  11.542  1.00  1.11           H  
ATOM   1137 HD13 ILE A 432      28.448  -4.183  12.546  1.00  1.08           H  
ATOM   1138  N   SER A 433      29.428 -10.125  11.811  1.00  0.34           N  
ATOM   1139  CA  SER A 433      29.278 -11.406  12.492  1.00  0.38           C  
ATOM   1140  C   SER A 433      30.605 -11.856  13.091  1.00  0.36           C  
ATOM   1141  O   SER A 433      31.659 -11.700  12.475  1.00  0.34           O  
ATOM   1142  CB  SER A 433      28.758 -12.472  11.526  1.00  0.41           C  
ATOM   1143  OG  SER A 433      27.470 -12.142  11.041  1.00  0.53           O  
ATOM   1144  H   SER A 433      30.326  -9.830  11.548  1.00  0.31           H  
ATOM   1145  HA  SER A 433      28.561 -11.276  13.290  1.00  0.46           H  
ATOM   1146  HB2 SER A 433      29.434 -12.551  10.687  1.00  0.39           H  
ATOM   1147  HB3 SER A 433      28.706 -13.423  12.034  1.00  0.44           H  
ATOM   1148  HG  SER A 433      26.806 -12.459  11.657  1.00  0.96           H  
ATOM   1149  N   ASP A 434      30.544 -12.408  14.297  1.00  0.43           N  
ATOM   1150  CA  ASP A 434      31.741 -12.876  14.985  1.00  0.48           C  
ATOM   1151  C   ASP A 434      32.405 -14.022  14.225  1.00  0.48           C  
ATOM   1152  O   ASP A 434      33.613 -14.231  14.334  1.00  0.74           O  
ATOM   1153  CB  ASP A 434      31.389 -13.325  16.403  1.00  0.60           C  
ATOM   1154  CG  ASP A 434      30.381 -14.457  16.416  1.00  0.83           C  
ATOM   1155  OD1 ASP A 434      29.262 -14.263  15.899  1.00  1.12           O  
ATOM   1156  OD2 ASP A 434      30.713 -15.540  16.943  1.00  1.35           O  
ATOM   1157  H   ASP A 434      29.675 -12.501  14.738  1.00  0.48           H  
ATOM   1158  HA  ASP A 434      32.434 -12.051  15.042  1.00  0.50           H  
ATOM   1159  HB2 ASP A 434      32.286 -13.659  16.902  1.00  0.63           H  
ATOM   1160  HB3 ASP A 434      30.971 -12.486  16.942  1.00  0.77           H  
ATOM   1161  N   ASN A 435      31.612 -14.761  13.454  1.00  0.43           N  
ATOM   1162  CA  ASN A 435      32.136 -15.881  12.679  1.00  0.47           C  
ATOM   1163  C   ASN A 435      32.126 -15.557  11.188  1.00  0.39           C  
ATOM   1164  O   ASN A 435      31.143 -15.036  10.660  1.00  0.38           O  
ATOM   1165  CB  ASN A 435      31.322 -17.149  12.948  1.00  0.59           C  
ATOM   1166  CG  ASN A 435      31.989 -18.390  12.386  1.00  1.26           C  
ATOM   1167  OD1 ASN A 435      33.118 -18.720  12.750  1.00  2.16           O  
ATOM   1168  ND2 ASN A 435      31.293 -19.086  11.497  1.00  1.81           N  
ATOM   1169  H   ASN A 435      30.656 -14.549  13.404  1.00  0.58           H  
ATOM   1170  HA  ASN A 435      33.157 -16.047  12.991  1.00  0.57           H  
ATOM   1171  HB2 ASN A 435      31.207 -17.276  14.015  1.00  1.33           H  
ATOM   1172  HB3 ASN A 435      30.349 -17.048  12.494  1.00  1.18           H  
ATOM   1173 HD21 ASN A 435      30.401 -18.764  11.254  1.00  1.92           H  
ATOM   1174 HD22 ASN A 435      31.700 -19.895  11.121  1.00  2.53           H  
ATOM   1175  N   ALA A 436      33.235 -15.855  10.519  1.00  0.49           N  
ATOM   1176  CA  ALA A 436      33.373 -15.585   9.093  1.00  0.55           C  
ATOM   1177  C   ALA A 436      32.554 -16.550   8.238  1.00  0.55           C  
ATOM   1178  O   ALA A 436      31.966 -16.150   7.232  1.00  0.54           O  
ATOM   1179  CB  ALA A 436      34.840 -15.646   8.692  1.00  0.75           C  
ATOM   1180  H   ALA A 436      33.986 -16.259  11.002  1.00  0.58           H  
ATOM   1181  HA  ALA A 436      33.023 -14.580   8.911  1.00  0.55           H  
ATOM   1182  HB1 ALA A 436      35.441 -15.873   9.561  1.00  1.33           H  
ATOM   1183  HB2 ALA A 436      35.142 -14.691   8.285  1.00  1.30           H  
ATOM   1184  HB3 ALA A 436      34.977 -16.415   7.947  1.00  1.23           H  
ATOM   1185  N   ASP A 437      32.536 -17.822   8.629  1.00  0.65           N  
ATOM   1186  CA  ASP A 437      31.806 -18.848   7.881  1.00  0.75           C  
ATOM   1187  C   ASP A 437      30.372 -18.416   7.579  1.00  0.71           C  
ATOM   1188  O   ASP A 437      29.868 -18.647   6.479  1.00  0.78           O  
ATOM   1189  CB  ASP A 437      31.798 -20.167   8.656  1.00  0.92           C  
ATOM   1190  CG  ASP A 437      33.195 -20.699   8.909  1.00  1.02           C  
ATOM   1191  OD1 ASP A 437      33.922 -20.950   7.925  1.00  1.34           O  
ATOM   1192  OD2 ASP A 437      33.562 -20.865  10.092  1.00  1.34           O  
ATOM   1193  H   ASP A 437      33.038 -18.083   9.429  1.00  0.70           H  
ATOM   1194  HA  ASP A 437      32.323 -18.999   6.947  1.00  0.80           H  
ATOM   1195  HB2 ASP A 437      31.313 -20.015   9.608  1.00  0.91           H  
ATOM   1196  HB3 ASP A 437      31.248 -20.905   8.091  1.00  1.02           H  
ATOM   1197  N   ASP A 438      29.721 -17.787   8.552  1.00  0.68           N  
ATOM   1198  CA  ASP A 438      28.348 -17.325   8.372  1.00  0.73           C  
ATOM   1199  C   ASP A 438      28.274 -16.231   7.311  1.00  0.73           C  
ATOM   1200  O   ASP A 438      27.354 -16.205   6.495  1.00  1.35           O  
ATOM   1201  CB  ASP A 438      27.775 -16.811   9.695  1.00  0.88           C  
ATOM   1202  CG  ASP A 438      27.534 -17.924  10.695  1.00  1.08           C  
ATOM   1203  OD1 ASP A 438      28.501 -18.634  11.038  1.00  1.56           O  
ATOM   1204  OD2 ASP A 438      26.376 -18.086  11.135  1.00  1.36           O  
ATOM   1205  H   ASP A 438      30.172 -17.627   9.406  1.00  0.69           H  
ATOM   1206  HA  ASP A 438      27.759 -18.168   8.040  1.00  0.83           H  
ATOM   1207  HB2 ASP A 438      28.469 -16.107  10.129  1.00  0.89           H  
ATOM   1208  HB3 ASP A 438      26.836 -16.314   9.502  1.00  0.96           H  
ATOM   1209  N   LEU A 439      29.247 -15.327   7.336  1.00  0.54           N  
ATOM   1210  CA  LEU A 439      29.295 -14.223   6.385  1.00  0.53           C  
ATOM   1211  C   LEU A 439      29.500 -14.724   4.955  1.00  0.61           C  
ATOM   1212  O   LEU A 439      28.537 -14.872   4.201  1.00  0.86           O  
ATOM   1213  CB  LEU A 439      30.399 -13.238   6.768  1.00  0.52           C  
ATOM   1214  CG  LEU A 439      30.236 -12.582   8.139  1.00  0.63           C  
ATOM   1215  CD1 LEU A 439      31.389 -11.634   8.407  1.00  1.12           C  
ATOM   1216  CD2 LEU A 439      28.914 -11.842   8.229  1.00  1.10           C  
ATOM   1217  H   LEU A 439      29.950 -15.401   8.016  1.00  0.93           H  
ATOM   1218  HA  LEU A 439      28.345 -13.713   6.434  1.00  0.63           H  
ATOM   1219  HB2 LEU A 439      31.343 -13.762   6.756  1.00  0.73           H  
ATOM   1220  HB3 LEU A 439      30.428 -12.457   6.025  1.00  0.76           H  
ATOM   1221  HG  LEU A 439      30.248 -13.347   8.902  1.00  1.38           H  
ATOM   1222 HD11 LEU A 439      31.437 -10.894   7.622  1.00  1.76           H  
ATOM   1223 HD12 LEU A 439      31.236 -11.141   9.357  1.00  1.65           H  
ATOM   1224 HD13 LEU A 439      32.314 -12.191   8.435  1.00  1.66           H  
ATOM   1225 HD21 LEU A 439      28.674 -11.411   7.268  1.00  1.65           H  
ATOM   1226 HD22 LEU A 439      28.135 -12.529   8.521  1.00  1.70           H  
ATOM   1227 HD23 LEU A 439      28.995 -11.054   8.966  1.00  1.63           H  
ATOM   1228  N   GLY A 440      30.755 -14.972   4.578  1.00  0.59           N  
ATOM   1229  CA  GLY A 440      31.042 -15.440   3.234  1.00  0.77           C  
ATOM   1230  C   GLY A 440      32.094 -16.533   3.196  1.00  0.96           C  
ATOM   1231  O   GLY A 440      32.873 -16.612   2.249  1.00  1.36           O  
ATOM   1232  H   GLY A 440      31.487 -14.832   5.212  1.00  0.62           H  
ATOM   1233  HA2 GLY A 440      30.131 -15.816   2.791  1.00  0.83           H  
ATOM   1234  HA3 GLY A 440      31.392 -14.604   2.645  1.00  0.91           H  
ATOM   1235  N   GLY A 441      32.102 -17.385   4.222  1.00  0.93           N  
ATOM   1236  CA  GLY A 441      33.055 -18.486   4.285  1.00  1.24           C  
ATOM   1237  C   GLY A 441      34.468 -18.095   3.895  1.00  1.14           C  
ATOM   1238  O   GLY A 441      35.137 -18.821   3.162  1.00  1.83           O  
ATOM   1239  H   GLY A 441      31.445 -17.273   4.940  1.00  0.91           H  
ATOM   1240  HA2 GLY A 441      33.071 -18.872   5.292  1.00  1.44           H  
ATOM   1241  HA3 GLY A 441      32.720 -19.266   3.624  1.00  1.56           H  
ATOM   1242  N   ILE A 442      34.916 -16.956   4.398  1.00  1.10           N  
ATOM   1243  CA  ILE A 442      36.255 -16.454   4.121  1.00  1.03           C  
ATOM   1244  C   ILE A 442      36.385 -15.971   2.672  1.00  1.05           C  
ATOM   1245  O   ILE A 442      37.034 -16.604   1.837  1.00  1.39           O  
ATOM   1246  CB  ILE A 442      37.311 -17.529   4.424  1.00  1.26           C  
ATOM   1247  CG1 ILE A 442      37.255 -17.934   5.900  1.00  1.41           C  
ATOM   1248  CG2 ILE A 442      38.710 -17.048   4.053  1.00  1.38           C  
ATOM   1249  CD1 ILE A 442      37.552 -16.802   6.860  1.00  1.48           C  
ATOM   1250  H   ILE A 442      34.336 -16.446   4.979  1.00  1.64           H  
ATOM   1251  HA  ILE A 442      36.432 -15.615   4.780  1.00  0.97           H  
ATOM   1252  HB  ILE A 442      37.074 -18.386   3.821  1.00  1.41           H  
ATOM   1253 HG12 ILE A 442      36.267 -18.307   6.126  1.00  1.56           H  
ATOM   1254 HG13 ILE A 442      37.978 -18.718   6.078  1.00  1.74           H  
ATOM   1255 HG21 ILE A 442      38.904 -16.101   4.534  1.00  1.61           H  
ATOM   1256 HG22 ILE A 442      39.440 -17.774   4.380  1.00  1.81           H  
ATOM   1257 HG23 ILE A 442      38.778 -16.928   2.982  1.00  1.80           H  
ATOM   1258 HD11 ILE A 442      37.249 -15.865   6.416  1.00  1.92           H  
ATOM   1259 HD12 ILE A 442      37.009 -16.957   7.780  1.00  1.89           H  
ATOM   1260 HD13 ILE A 442      38.612 -16.773   7.068  1.00  1.76           H  
ATOM   1261  N   THR A 443      35.771 -14.822   2.401  1.00  1.13           N  
ATOM   1262  CA  THR A 443      35.806 -14.188   1.089  1.00  1.36           C  
ATOM   1263  C   THR A 443      35.556 -15.158  -0.064  1.00  1.47           C  
ATOM   1264  O   THR A 443      36.380 -15.303  -0.969  1.00  2.20           O  
ATOM   1265  CB  THR A 443      37.140 -13.462   0.882  1.00  2.21           C  
ATOM   1266  OG1 THR A 443      37.372 -12.555   1.966  1.00  3.05           O  
ATOM   1267  CG2 THR A 443      37.160 -12.694  -0.433  1.00  2.78           C  
ATOM   1268  H   THR A 443      35.296 -14.369   3.120  1.00  1.32           H  
ATOM   1269  HA  THR A 443      35.023 -13.452   1.067  1.00  1.77           H  
ATOM   1270  HB  THR A 443      37.918 -14.202   0.870  1.00  2.55           H  
ATOM   1271  HG1 THR A 443      37.179 -12.993   2.798  1.00  3.42           H  
ATOM   1272 HG21 THR A 443      36.341 -13.025  -1.057  1.00  3.13           H  
ATOM   1273 HG22 THR A 443      37.059 -11.638  -0.235  1.00  3.23           H  
ATOM   1274 HG23 THR A 443      38.096 -12.876  -0.944  1.00  3.10           H  
ATOM   1275  N   VAL A 444      34.399 -15.797  -0.037  1.00  1.90           N  
ATOM   1276  CA  VAL A 444      34.006 -16.719  -1.073  1.00  2.70           C  
ATOM   1277  C   VAL A 444      32.486 -16.758  -1.191  1.00  3.02           C  
ATOM   1278  O   VAL A 444      31.782 -16.954  -0.200  1.00  3.60           O  
ATOM   1279  CB  VAL A 444      34.520 -18.130  -0.798  1.00  3.53           C  
ATOM   1280  CG1 VAL A 444      36.032 -18.209  -0.949  1.00  4.18           C  
ATOM   1281  CG2 VAL A 444      34.087 -18.614   0.571  1.00  4.02           C  
ATOM   1282  H   VAL A 444      33.785 -15.635   0.693  1.00  2.21           H  
ATOM   1283  HA  VAL A 444      34.426 -16.375  -2.007  1.00  3.01           H  
ATOM   1284  HB  VAL A 444      34.079 -18.762  -1.523  1.00  3.88           H  
ATOM   1285 HG11 VAL A 444      36.361 -17.475  -1.669  1.00  4.32           H  
ATOM   1286 HG12 VAL A 444      36.499 -18.011   0.005  1.00  4.55           H  
ATOM   1287 HG13 VAL A 444      36.307 -19.196  -1.289  1.00  4.64           H  
ATOM   1288 HG21 VAL A 444      34.236 -17.827   1.296  1.00  4.34           H  
ATOM   1289 HG22 VAL A 444      33.042 -18.884   0.544  1.00  4.35           H  
ATOM   1290 HG23 VAL A 444      34.674 -19.476   0.851  1.00  4.27           H  
ATOM   1291  N   LEU A 445      31.983 -16.559  -2.403  1.00  3.13           N  
ATOM   1292  CA  LEU A 445      30.544 -16.563  -2.632  1.00  3.83           C  
ATOM   1293  C   LEU A 445      29.985 -17.985  -2.633  1.00  4.75           C  
ATOM   1294  O   LEU A 445      30.458 -18.844  -3.377  1.00  4.99           O  
ATOM   1295  CB  LEU A 445      30.216 -15.868  -3.954  1.00  3.87           C  
ATOM   1296  CG  LEU A 445      30.663 -14.407  -4.047  1.00  3.48           C  
ATOM   1297  CD1 LEU A 445      30.262 -13.813  -5.388  1.00  3.82           C  
ATOM   1298  CD2 LEU A 445      30.075 -13.593  -2.904  1.00  3.70           C  
ATOM   1299  H   LEU A 445      32.589 -16.399  -3.155  1.00  3.04           H  
ATOM   1300  HA  LEU A 445      30.084 -16.010  -1.827  1.00  4.04           H  
ATOM   1301  HB2 LEU A 445      30.689 -16.419  -4.753  1.00  4.14           H  
ATOM   1302  HB3 LEU A 445      29.147 -15.902  -4.100  1.00  4.36           H  
ATOM   1303  HG  LEU A 445      31.741 -14.362  -3.971  1.00  3.46           H  
ATOM   1304 HD11 LEU A 445      29.938 -14.602  -6.049  1.00  4.26           H  
ATOM   1305 HD12 LEU A 445      29.455 -13.109  -5.243  1.00  4.01           H  
ATOM   1306 HD13 LEU A 445      31.109 -13.302  -5.823  1.00  3.98           H  
ATOM   1307 HD21 LEU A 445      30.063 -14.191  -2.004  1.00  3.88           H  
ATOM   1308 HD22 LEU A 445      30.677 -12.711  -2.743  1.00  3.91           H  
ATOM   1309 HD23 LEU A 445      29.066 -13.299  -3.153  1.00  4.11           H  
ATOM   1310  N   PRO A 446      28.961 -18.250  -1.800  1.00  5.56           N  
ATOM   1311  CA  PRO A 446      28.336 -19.574  -1.713  1.00  6.59           C  
ATOM   1312  C   PRO A 446      27.498 -19.894  -2.947  1.00  7.07           C  
ATOM   1313  O   PRO A 446      26.806 -19.025  -3.477  1.00  7.26           O  
ATOM   1314  CB  PRO A 446      27.446 -19.465  -0.475  1.00  7.40           C  
ATOM   1315  CG  PRO A 446      27.119 -18.015  -0.374  1.00  6.97           C  
ATOM   1316  CD  PRO A 446      28.329 -17.281  -0.880  1.00  5.82           C  
ATOM   1317  HA  PRO A 446      29.072 -20.351  -1.566  1.00  6.67           H  
ATOM   1318  HB2 PRO A 446      26.556 -20.064  -0.612  1.00  8.01           H  
ATOM   1319  HB3 PRO A 446      27.987 -19.808   0.394  1.00  7.82           H  
ATOM   1320  HG2 PRO A 446      26.259 -17.790  -0.986  1.00  7.47           H  
ATOM   1321  HG3 PRO A 446      26.926 -17.754   0.657  1.00  7.18           H  
ATOM   1322  HD2 PRO A 446      28.034 -16.387  -1.409  1.00  5.90           H  
ATOM   1323  HD3 PRO A 446      28.993 -17.038  -0.064  1.00  5.41           H  
ATOM   1324  N   ALA A 447      27.567 -21.144  -3.399  1.00  7.52           N  
ATOM   1325  CA  ALA A 447      26.813 -21.570  -4.572  1.00  8.19           C  
ATOM   1326  C   ALA A 447      25.324 -21.265  -4.406  1.00  8.83           C  
ATOM   1327  O   ALA A 447      24.718 -21.631  -3.399  1.00  9.06           O  
ATOM   1328  CB  ALA A 447      27.025 -23.056  -4.823  1.00  8.42           C  
ATOM   1329  H   ALA A 447      28.137 -21.791  -2.934  1.00  7.56           H  
ATOM   1330  HA  ALA A 447      27.191 -21.028  -5.425  1.00  8.35           H  
ATOM   1331  HB1 ALA A 447      26.959 -23.255  -5.882  1.00  8.54           H  
ATOM   1332  HB2 ALA A 447      26.266 -23.622  -4.303  1.00  8.56           H  
ATOM   1333  HB3 ALA A 447      28.001 -23.347  -4.462  1.00  8.62           H  
ATOM   1334  N   PRO A 448      24.715 -20.582  -5.395  1.00  9.38           N  
ATOM   1335  CA  PRO A 448      23.292 -20.223  -5.347  1.00 10.23           C  
ATOM   1336  C   PRO A 448      22.384 -21.449  -5.261  1.00 10.87           C  
ATOM   1337  O   PRO A 448      22.535 -22.398  -6.030  1.00 11.06           O  
ATOM   1338  CB  PRO A 448      23.056 -19.481  -6.667  1.00 10.80           C  
ATOM   1339  CG  PRO A 448      24.408 -19.049  -7.118  1.00 10.31           C  
ATOM   1340  CD  PRO A 448      25.361 -20.099  -6.626  1.00  9.48           C  
ATOM   1341  HA  PRO A 448      23.081 -19.564  -4.519  1.00 10.21           H  
ATOM   1342  HB2 PRO A 448      22.597 -20.152  -7.380  1.00 11.42           H  
ATOM   1343  HB3 PRO A 448      22.408 -18.635  -6.495  1.00 11.10           H  
ATOM   1344  HG2 PRO A 448      24.434 -18.993  -8.197  1.00 10.69           H  
ATOM   1345  HG3 PRO A 448      24.650 -18.089  -6.685  1.00 10.36           H  
ATOM   1346  HD2 PRO A 448      25.456 -20.892  -7.352  1.00  9.62           H  
ATOM   1347  HD3 PRO A 448      26.324 -19.662  -6.410  1.00  9.08           H  
ATOM   1348  N   PRO A 449      21.420 -21.444  -4.321  1.00 11.41           N  
ATOM   1349  CA  PRO A 449      20.486 -22.560  -4.141  1.00 12.23           C  
ATOM   1350  C   PRO A 449      19.582 -22.754  -5.353  1.00 13.10           C  
ATOM   1351  O   PRO A 449      19.011 -21.794  -5.873  1.00 13.50           O  
ATOM   1352  CB  PRO A 449      19.653 -22.152  -2.917  1.00 12.72           C  
ATOM   1353  CG  PRO A 449      20.422 -21.055  -2.261  1.00 12.39           C  
ATOM   1354  CD  PRO A 449      21.166 -20.359  -3.362  1.00 11.49           C  
ATOM   1355  HA  PRO A 449      21.009 -23.482  -3.933  1.00 12.04           H  
ATOM   1356  HB2 PRO A 449      18.681 -21.811  -3.240  1.00 13.53           H  
ATOM   1357  HB3 PRO A 449      19.541 -23.000  -2.259  1.00 12.61           H  
ATOM   1358  HG2 PRO A 449      19.744 -20.370  -1.774  1.00 13.04           H  
ATOM   1359  HG3 PRO A 449      21.117 -21.472  -1.545  1.00 12.30           H  
ATOM   1360  HD2 PRO A 449      20.554 -19.587  -3.804  1.00 11.77           H  
ATOM   1361  HD3 PRO A 449      22.092 -19.945  -2.993  1.00 10.85           H  
ATOM   1362  N   LEU A 450      19.451 -24.000  -5.796  1.00 13.55           N  
ATOM   1363  CA  LEU A 450      18.610 -24.321  -6.945  1.00 14.50           C  
ATOM   1364  C   LEU A 450      17.140 -24.415  -6.538  1.00 14.96           C  
ATOM   1365  O   LEU A 450      16.445 -25.363  -6.905  1.00 15.17           O  
ATOM   1366  CB  LEU A 450      19.063 -25.638  -7.582  1.00 15.07           C  
ATOM   1367  CG  LEU A 450      20.500 -25.649  -8.110  1.00 15.25           C  
ATOM   1368  CD1 LEU A 450      20.856 -27.023  -8.656  1.00 15.76           C  
ATOM   1369  CD2 LEU A 450      20.684 -24.587  -9.185  1.00 15.35           C  
ATOM   1370  H   LEU A 450      19.928 -24.723  -5.337  1.00 13.32           H  
ATOM   1371  HA  LEU A 450      18.721 -23.527  -7.666  1.00 14.63           H  
ATOM   1372  HB2 LEU A 450      18.968 -26.422  -6.845  1.00 15.17           H  
ATOM   1373  HB3 LEU A 450      18.400 -25.861  -8.405  1.00 15.44           H  
ATOM   1374  HG  LEU A 450      21.177 -25.427  -7.297  1.00 15.14           H  
ATOM   1375 HD11 LEU A 450      20.048 -27.710  -8.457  1.00 16.01           H  
ATOM   1376 HD12 LEU A 450      21.018 -26.956  -9.721  1.00 15.88           H  
ATOM   1377 HD13 LEU A 450      21.758 -27.378  -8.177  1.00 15.90           H  
ATOM   1378 HD21 LEU A 450      19.757 -24.449  -9.717  1.00 15.59           H  
ATOM   1379 HD22 LEU A 450      20.976 -23.655  -8.724  1.00 15.19           H  
ATOM   1380 HD23 LEU A 450      21.453 -24.903  -9.875  1.00 15.50           H  
ATOM   1381  N   ALA A 451      16.674 -23.428  -5.773  1.00 15.28           N  
ATOM   1382  CA  ALA A 451      15.288 -23.402  -5.313  1.00 15.91           C  
ATOM   1383  C   ALA A 451      14.954 -24.664  -4.518  1.00 16.47           C  
ATOM   1384  O   ALA A 451      14.100 -25.454  -4.920  1.00 16.74           O  
ATOM   1385  CB  ALA A 451      14.336 -23.243  -6.490  1.00 16.18           C  
ATOM   1386  H   ALA A 451      17.276 -22.703  -5.511  1.00 15.21           H  
ATOM   1387  HA  ALA A 451      15.173 -22.545  -4.666  1.00 15.94           H  
ATOM   1388  HB1 ALA A 451      13.327 -23.450  -6.168  1.00 16.28           H  
ATOM   1389  HB2 ALA A 451      14.613 -23.933  -7.273  1.00 16.27           H  
ATOM   1390  HB3 ALA A 451      14.394 -22.231  -6.865  1.00 16.32           H  
ATOM   1391  N   PRO A 452      15.633 -24.872  -3.374  1.00 16.82           N  
ATOM   1392  CA  PRO A 452      15.409 -26.049  -2.527  1.00 17.52           C  
ATOM   1393  C   PRO A 452      14.017 -26.069  -1.908  1.00 18.21           C  
ATOM   1394  O   PRO A 452      13.535 -25.056  -1.400  1.00 18.53           O  
ATOM   1395  CB  PRO A 452      16.479 -25.922  -1.437  1.00 17.79           C  
ATOM   1396  CG  PRO A 452      16.841 -24.478  -1.413  1.00 17.36           C  
ATOM   1397  CD  PRO A 452      16.669 -23.981  -2.821  1.00 16.73           C  
ATOM   1398  HA  PRO A 452      15.566 -26.963  -3.080  1.00 17.50           H  
ATOM   1399  HB2 PRO A 452      16.068 -26.241  -0.490  1.00 18.40           H  
ATOM   1400  HB3 PRO A 452      17.329 -26.536  -1.691  1.00 17.78           H  
ATOM   1401  HG2 PRO A 452      16.180 -23.945  -0.745  1.00 17.76           H  
ATOM   1402  HG3 PRO A 452      17.867 -24.362  -1.099  1.00 17.23           H  
ATOM   1403  HD2 PRO A 452      16.333 -22.954  -2.820  1.00 16.84           H  
ATOM   1404  HD3 PRO A 452      17.592 -24.076  -3.372  1.00 16.27           H  
ATOM   1405  N   ASP A 453      13.379 -27.236  -1.951  1.00 18.57           N  
ATOM   1406  CA  ASP A 453      12.043 -27.408  -1.393  1.00 19.36           C  
ATOM   1407  C   ASP A 453      11.645 -28.881  -1.401  1.00 19.52           C  
ATOM   1408  O   ASP A 453      11.731 -29.551  -2.431  1.00 19.55           O  
ATOM   1409  CB  ASP A 453      11.024 -26.588  -2.191  1.00 19.71           C  
ATOM   1410  CG  ASP A 453       9.622 -26.677  -1.615  1.00 20.25           C  
ATOM   1411  OD1 ASP A 453       9.062 -27.795  -1.581  1.00 20.55           O  
ATOM   1412  OD2 ASP A 453       9.085 -25.631  -1.196  1.00 20.48           O  
ATOM   1413  H   ASP A 453      13.824 -28.004  -2.367  1.00 18.38           H  
ATOM   1414  HA  ASP A 453      12.059 -27.055  -0.373  1.00 19.73           H  
ATOM   1415  HB2 ASP A 453      11.325 -25.550  -2.188  1.00 19.66           H  
ATOM   1416  HB3 ASP A 453      10.998 -26.948  -3.208  1.00 19.75           H  
ATOM   1417  N   GLN A 454      11.214 -29.379  -0.247  1.00 19.77           N  
ATOM   1418  CA  GLN A 454      10.805 -30.773  -0.121  1.00 20.09           C  
ATOM   1419  C   GLN A 454       9.505 -31.029  -0.877  1.00 20.37           C  
ATOM   1420  O   GLN A 454       8.504 -30.345  -0.579  1.00 20.63           O  
ATOM   1421  CB  GLN A 454      10.639 -31.148   1.353  1.00 20.30           C  
ATOM   1422  CG  GLN A 454      11.910 -30.979   2.171  1.00 20.53           C  
ATOM   1423  CD  GLN A 454      11.747 -31.395   3.624  1.00 20.93           C  
ATOM   1424  OE1 GLN A 454      12.686 -31.301   4.414  1.00 21.22           O  
ATOM   1425  NE2 GLN A 454      10.555 -31.862   3.986  1.00 21.08           N  
ATOM   1426  OXT GLN A 454       9.499 -31.913  -1.759  1.00 20.45           O  
ATOM   1427  H   GLN A 454      11.169 -28.794   0.539  1.00 19.82           H  
ATOM   1428  HA  GLN A 454      11.583 -31.384  -0.553  1.00 20.12           H  
ATOM   1429  HB2 GLN A 454       9.872 -30.524   1.788  1.00 20.31           H  
ATOM   1430  HB3 GLN A 454      10.330 -32.180   1.418  1.00 20.42           H  
ATOM   1431  HG2 GLN A 454      12.688 -31.582   1.728  1.00 20.46           H  
ATOM   1432  HG3 GLN A 454      12.203 -29.939   2.142  1.00 20.59           H  
ATOM   1433 HE21 GLN A 454       9.849 -31.912   3.310  1.00 20.91           H  
ATOM   1434 HE22 GLN A 454      10.432 -32.137   4.919  1.00 21.41           H  
TER    1435      GLN A 454                                                      
END
MOLECULE T0429.pdb
ATOM      1  N   GLU    22      23.143   8.727  21.130  1.00172.90      A    N  
ATOM      2  CA  GLU    22      22.374   7.758  20.286  1.00169.34      A    C  
ATOM      3  CB  GLU    22      22.276   8.259  18.835  1.00168.54      A    C  
ATOM      4  CG  GLU    22      23.616   8.393  18.103  1.00158.10      A    C  
ATOM      5  CD  GLU    22      23.457   8.575  16.601  1.00157.25      A    C  
ATOM      6  OE1 GLU    22      24.348   8.113  15.852  1.00147.23      A    O  
ATOM      7  OE2 GLU    22      22.446   9.173  16.165  1.00167.76      A    O  
ATOM      8  C   GLU    22      22.931   6.322  20.338  1.00157.48      A    C  
ATOM      9  O   GLU    22      22.498   5.455  19.576  1.00152.96      A    O  
ATOM     10  N   THR    23      23.876   6.088  21.250  1.00154.10      A    N  
ATOM     11  CA  THR    23      24.505   4.776  21.452  1.00145.40      A    C  
ATOM     12  CB  THR    23      25.730   4.896  22.405  1.00143.94      A    C  
ATOM     13  OG1 THR    23      26.652   5.863  21.883  1.00141.32      A    O  
ATOM     14  CG2 THR    23      26.454   3.563  22.562  1.00136.43      A    C  
ATOM     15  C   THR    23      23.503   3.729  21.972  1.00150.21      A    C  
ATOM     16  O   THR    23      22.570   4.068  22.704  1.00162.36      A    O  
ATOM     17  N   GLU    24      23.706   2.466  21.590  1.00143.04      A    N  
ATOM     18  CA  GLU    24      22.756   1.383  21.886  1.00147.93      A    C  
ATOM     19  CB  GLU    24      22.210   0.789  20.580  1.00144.01      A    C  
ATOM     24  C   GLU    24      23.290   0.256  22.791  1.00146.91      A    C  
ATOM     25  O   GLU    24      22.482  -0.568  23.303  1.00154.53      A    O  
ATOM     26  N   LEU    25      24.636   0.215  22.968  1.00139.01      A    N  
ATOM     27  CA  LEU    25      25.295  -0.776  23.847  1.00138.87      A    C  
ATOM     28  CB  LEU    25      25.029  -0.457  25.346  1.00151.41      A    C  
ATOM     29  CG  LEU    25      26.098  -0.729  26.420  1.00153.60      A    C  
ATOM     30  CD1 LEU    25      25.557  -0.342  27.808  1.00166.65      A    C  
ATOM     31  CD2 LEU    25      26.620  -2.188  26.419  1.00150.16      A    C  
ATOM     32  C   LEU    25      24.901  -2.238  23.511  1.00137.26      A    C  
ATOM     33  O   LEU    25      24.248  -2.938  24.308  1.00144.91      A    O  
ATOM     34  N   LEU    27      24.229  -6.765  19.987  1.00124.47      A    N  
ATOM     35  CA  LEU    27      24.721  -8.135  19.817  1.00123.94      A    C  
ATOM     36  CB  LEU    27      24.018  -8.864  18.654  1.00124.12      A    C  
ATOM     37  CG  LEU    27      23.652  -8.221  17.310  1.00118.98      A    C  
ATOM     38  CD1 LEU    27      23.488  -9.322  16.264  1.00118.08      A    C  
ATOM     38  CD2 LEU    27      22.365  -7.397  17.414  1.00128.31      A    C  
ATOM     40  C   LEU    27      26.247  -8.245  19.696  1.00114.60      A    C  
ATOM     41  O   LEU    27      26.853  -9.156  20.263  1.00117.26      A    O  
ATOM     42  N   TYR    28      26.862  -7.335  18.947  1.00105.66      A    N  
ATOM     43  CA  TYR    28      28.319  -7.200  18.963  1.00 99.30      A    C  
ATOM     44  CB  TYR    28      28.923  -7.286  17.548  1.00 89.68      A    C  
ATOM     45  CG  TYR    28      28.406  -8.478  16.772  1.00 88.71      A    C  
ATOM     46  CD1 TYR    28      28.819  -9.774  17.087  1.00 90.89      A    C  
ATOM     47  CE1 TYR    28      28.325 -10.875  16.393  1.00 93.27      A    C  
ATOM     48  CZ  TYR    28      27.402 -10.683  15.376  1.00 92.44      A    C  
ATOM     49  OH  TYR    28      26.907 -11.765  14.685  1.00 96.36      A    O  
ATOM     50  CE2 TYR    28      26.974  -9.408  15.047  1.00 89.46      A    C  
ATOM     51  CD2 TYR    28      27.475  -8.315  15.748  1.00 87.20      A    C  
ATOM     52  C   TYR    28      28.651  -5.890  19.660  1.00100.94      A    C  
ATOM     53  O   TYR    28      28.114  -4.836  19.311  1.00100.23      A    O  
ATOM     54  N   LYS    29      29.505  -5.973  20.675  1.00104.98      A    N  
ATOM     55  CA  LYS    29      29.862  -4.813  21.481  1.00108.51      A    C  
ATOM     56  CB  LYS    29      30.333  -5.254  22.871  1.00116.86      A    C  
ATOM     61  C   LYS    29      30.923  -3.949  20.793  1.00102.56      A    C  
ATOM     62  O   LYS    29      31.688  -4.428  19.957  1.00 96.86      A    O  
ATOM     63  N   VAL    30      30.941  -2.667  21.147  1.00106.01      A    N  
ATOM     64  CA  VAL    30      31.946  -1.717  20.668  1.00103.19      A    C  
ATOM     65  CB  VAL    30      31.691  -0.300  21.261  1.00109.00      A    C  
ATOM     66  CG1 VAL    30      31.681  -0.327  22.793  1.00117.99      A    C  
ATOM     67  CG2 VAL    30      32.698   0.704  20.741  1.00108.94      A    C  
ATOM     68  C   VAL    30      33.374  -2.211  20.960  1.00103.89      A    C  
ATOM     69  O   VAL    30      33.667  -2.667  22.065  1.00110.81      A    O  
ATOM     70  N   ASN    31      34.238  -2.134  19.948  1.00 98.81      A    N  
ATOM     71  CA  ASN    31      35.638  -2.589  20.016  1.00 99.77      A    C  
ATOM     72  CB  ASN    31      36.312  -2.208  21.337  1.00108.53      A    C  
ATOM     73  CG  ASN    31      36.624  -0.747  21.416  1.00112.78      A    C  
ATOM     74  OD1 ASN    31      35.766   0.061  21.763  1.00116.34      A    O  
ATOM     75  ND2 ASN    31      37.861  -0.390  21.095  1.00116.64      A    N  
ATOM     76  C   ASN    31      35.858  -4.066  19.726  1.00 96.91      A    C  
ATOM     77  O   ASN    31      37.000  -4.499  19.568  1.00 98.59      A    O  
ATOM     78  N   GLU    32      34.779  -4.839  19.660  1.00 94.41      A    N  
ATOM     79  CA  GLU    32      34.889  -6.234  19.254  1.00 93.05      A    C  
ATOM     80  CB  GLU    32      33.592  -6.998  19.533  1.00 94.24      A    C  
ATOM     81  CG  GLU    32      33.730  -8.518  19.443  1.00 96.69      A    C  
ATOM     82  CD  GLU    32      32.437  -9.259  19.760  1.00101.02      A    C  
ATOM     83  OE1 GLU    32      31.677  -8.814  20.653  1.00104.59      A    O  
ATOM     84  OE2 GLU    32      32.191 -10.304  19.112  1.00101.68      A    O  
ATOM     85  C   GLU    32      35.248  -6.293  17.770  1.00 85.89      A    C  
ATOM     86  O   GLU    32      34.742  -5.503  16.970  1.00 81.52      A    O  
ATOM     87  N   TYR    33      36.146  -7.212  17.424  1.00 86.41      A    N  
ATOM     88  CA  TYR    33      36.514  -7.452  16.032  1.00 80.84      A    C  
ATOM     89  CB  TYR    33      37.902  -8.087  15.933  1.00 84.64      A    C  
ATOM     90  CG  TYR    33      39.026  -7.173  16.361  1.00 88.89      A    C  
ATOM     91  CD1 TYR    33      39.565  -6.233  15.478  1.00 87.72      A    C  
ATOM     92  CE1 TYR    33      40.604  -5.390  15.869  1.00 93.77      A    C  
ATOM     93  CZ  TYR    33      41.113  -5.488  17.158  1.00102.17      A    C  
ATOM     94  OH  TYR    33      42.137  -4.665  17.562  1.00109.70      A    O  
ATOM     95  CE2 TYR    33      40.595  -6.415  18.049  1.00103.06      A    C  
ATOM     96  CD2 TYR    33      39.558  -7.251  17.645  1.00 96.63      A    C  
ATOM     97  C   TYR    33      35.481  -8.343  15.365  1.00 77.13      A    C  
ATOM     98  O   TYR    33      34.999  -9.304  15.962  1.00 80.54      A    O  
ATOM     99  N   VAL    34      35.150  -8.015  14.121  1.00 71.92      A    N  
ATOM    100  CA  VAL    34      34.093  -8.702  13.387  1.00 68.82      A    C  
ATOM    101  CB  VAL    34      32.747  -7.920  13.464  1.00 68.44      A    C  
ATOM    102  CG1 VAL    34      32.177  -7.925  14.884  1.00 71.47      A    C  
ATOM    103  CG2 VAL    34      32.898  -6.493  12.926  1.00 64.40      A    C  
ATOM    104  C   VAL    34      34.460  -8.908  11.914  1.00 66.21      A    C  
ATOM    105  O   VAL    34      35.567  -8.577  11.481  1.00 66.29      A    O  
ATOM    106  N   ASP    35      33.522  -9.472  11.162  1.00 64.66      A    N  
ATOM    107  CA  ASP    35      33.597  -9.509   9.715  1.00 63.00      A    C  
ATOM    108  CB  ASP    35      33.407 -10.939   9.202  1.00 63.65      A    C  
ATOM    109  CG  ASP    35      34.686 -11.759   9.244  1.00 64.32      A    C  
ATOM    110  OD1 ASP    35      35.783 -11.188   9.069  1.00 62.56      A    O  
ATOM    111  OD2 ASP    35      34.591 -12.990   9.434  1.00 66.48      A    O  
ATOM    112  C   ASP    35      32.473  -8.627   9.199  1.00 63.11      A    C  
ATOM    113  O   ASP    35      31.344  -8.719   9.686  1.00 65.91      A    O  
ATOM    114  N   ALA    36      32.775  -7.773   8.221  1.00 62.20      A    N  
ATOM    115  CA  ALA    36      31.779  -6.853   7.670  1.00 62.48      A    C  
ATOM    116  CB  ALA    36      32.182  -5.415   7.934  1.00 63.64      A    C  
ATOM    117  C   ALA    36      31.607  -7.080   6.186  1.00 63.86      A    C  
ATOM    118  O   ALA    36      32.589  -7.191   5.452  1.00 65.27      A    O  
ATOM    119  N   ARG    37      30.358  -7.138   5.744  1.00 66.32      A    N  
ATOM    120  CA  ARG    37      30.057  -7.410   4.344  1.00 70.06      A    C  
ATOM    121  CB  ARG    37      28.720  -8.159   4.199  1.00 73.46      A    C  
ATOM    122  CG  ARG    37      28.518  -8.813   2.829  1.00 77.70      A    C  
ATOM    123  CD  ARG    37      27.182  -9.543   2.729  1.00 83.79      A    C  
ATOM    124  NE  ARG    37      26.063  -8.613   2.586  1.00 92.01      A    N  
ATOM    125  CZ  ARG    37      25.427  -8.344   1.445  1.00 99.69      A    C  
ATOM    126  NH1 ARG    37      25.775  -8.943   0.309  1.00101.62      A    N  
ATOM    127  NH2 ARG    37      24.425  -7.472   1.444  1.00105.62      A    N  
ATOM    128  C   ARG    37      30.043  -6.122   3.535  1.00 72.97      A    C  
ATOM    129  O   ARG    37      29.183  -5.267   3.734  1.00 76.28      A    O  
ATOM    130  N   ASP    38      31.015  -5.980   2.640  1.00 74.45      A    N  
ATOM    131  CA  ASP    38      30.995  -4.906   1.661  1.00 81.28      A    C  
ATOM    132  CB  ASP    38      32.279  -4.924   0.825  1.00 83.16      A    C  
ATOM    133  CG  ASP    38      32.369  -3.768  -0.157  1.00 91.41      A    C  
ATOM    134  OD1 ASP    38      31.439  -3.583  -0.965  1.00 98.91      A    O  
ATOM    135  OD2 ASP    38      33.394  -3.058  -0.145  1.00 93.84      A    O  
ATOM    136  C   ASP    38      29.768  -5.148   0.794  1.00 87.58      A    C  
ATOM    137  O   ASP    38      29.730  -6.094   0.011  1.00 90.08      A    O  
ATOM    138  N   THR    39      28.754  -4.307   0.961  1.00 92.61      A    N  
ATOM    139  CA  THR    39      27.483  -4.487   0.262  1.00101.09      A    C  
ATOM    140  CB  THR    39      26.377  -3.589   0.863  1.00105.79      A    C  
ATOM    141  OG1 THR    39      26.310  -3.809   2.276  1.00100.08      A    O  
ATOM    142  CG2 THR    39      25.014  -3.910   0.258  1.00115.77      A    C  
ATOM    143  C   THR    39      27.621  -4.263  -1.246  1.00109.30      A    C  
ATOM    144  O   THR    39      26.849  -4.811  -2.034  1.00116.02      A    O  
ATOM    145  N   ASN    40      28.617  -3.475  -1.640  1.00111.13      A    N  
ATOM    146  CA  ASN    40      28.866  -3.188  -3.050  1.00121.02      A    C  
ATOM    147  CB  ASN    40      29.891  -2.057  -3.191  1.00124.44      A    C  
ATOM    148  CG  ASN    40      30.409  -1.907  -4.609  1.00135.60      A    C  
ATOM    149  OD1 ASN    40      31.550  -2.269  -4.903  1.00135.88      A    O  
ATOM    150  ND2 ASN    40      29.567  -1.391  -5.502  1.00147.42      A    N  
ATOM    151  C   ASN    40      29.296  -4.418  -3.857  1.00120.57      A    C  
ATOM    152  O   ASN    40      28.922  -4.560  -5.022  1.00129.57      A    O  
ATOM    153  N   MET    41      30.064  -5.308  -3.234  1.00111.84      A    N  
ATOM    154  CA  MET    41      30.606  -6.478  -3.933  1.00112.47      A    C  
ATOM    155  CB  MET    41      32.122  -6.373  -4.048  1.00111.40      A    C  
ATOM    156  CG  MET    41      32.807  -6.077  -2.737  1.00103.73      A    C  
ATOM    157  SD  MET    41      34.733  -6.073  -2.908  1.00108.38      A   SE  
ATOM    158  CE  MET    41      34.947  -4.830  -4.410  1.00120.35      A    C  
ATOM    159  C   MET    41      30.224  -7.818  -3.307  1.00105.36      A    C  
ATOM    160  O   MET    41      30.327  -8.863  -3.955  1.00106.85      A    O  
ATOM    161  N   GLY    42      29.804  -7.780  -2.047  1.00 83.71      A    N  
ATOM    162  CA  GLY    42      29.269  -8.959  -1.367  1.00 83.07      A    C  
ATOM    163  C   GLY    42      30.262  -9.792  -0.578  1.00 77.08      A    C  
ATOM    164  O   GLY    42      29.914 -10.867  -0.090  1.00 77.31      A    O  
ATOM    165  N   ALA    43      31.490  -9.300  -0.446  1.00 72.89      A    N  
ATOM    166  CA  ALA    43      32.548 -10.041   0.234  1.00 69.07      A    C  
ATOM    167  CB  ALA    43      33.865  -9.848  -0.491  1.00 68.37      A    C  
ATOM    168  C   ALA    43      32.669  -9.636   1.703  1.00 65.34      A    C  
ATOM    169  O   ALA    43      32.300  -8.525   2.077  1.00 65.78      A    O  
ATOM    170  N   TRP    44      33.183 -10.537   2.535  1.00 64.28      A    N  
ATOM    171  CA  TRP    44      33.399 -10.241   3.953  1.00 61.58      A    C  
ATOM    172  CB  TRP    44      32.987 -11.425   4.830  1.00 63.28      A    C  
ATOM    173  CG  TRP    44      31.522 -11.742   4.770  1.00 66.96      A    C  
ATOM    174  CD1 TRP    44      30.893 -12.523   3.846  1.00 71.29      A    C  
ATOM    175  NE1 TRP    44      29.547 -12.583   4.112  1.00 75.54      A    N  
ATOM    176  CE2 TRP    44      29.278 -11.826   5.222  1.00 74.38      A    C  
ATOM    177  CD2 TRP    44      30.503 -11.280   5.667  1.00 69.18      A    C  
ATOM    178  CE3 TRP    44      30.505 -10.458   6.805  1.00 68.75      A    C  
ATOM    179  CZ3 TRP    44      29.298 -10.209   7.452  1.00 70.28      A    C  
ATOM    180  CH2 TRP    44      28.096 -10.769   6.986  1.00 75.60      A    C  
ATOM    181  CZ2 TRP    44      28.063 -11.578   5.876  1.00 76.96      A    C  
ATOM    182  C   TRP    44      34.850  -9.851   4.236  1.00 60.04      A    C  
ATOM    183  O   TRP    44      35.789 -10.497   3.740  1.00 59.62      A    O  
ATOM    184  N   PHE    45      35.017  -8.797   5.038  1.00 57.06      A    N  
ATOM    185  CA  PHE    45      36.331  -8.252   5.361  1.00 55.38      A    C  
ATOM    186  CB  PHE    45      36.541  -6.899   4.673  1.00 54.74      A    C  
ATOM    187  CG  PHE    45      36.523  -6.953   3.157  1.00 58.74      A    C  
ATOM    188  CD1 PHE    45      37.701  -7.144   2.439  1.00 58.08      A    C  
ATOM    189  CE1 PHE    45      37.695  -7.170   1.046  1.00 62.77      A    C  
ATOM    190  CZ  PHE    45      36.501  -7.000   0.344  1.00 63.52      A    C  
ATOM    191  CE2 PHE    45      35.321  -6.799   1.049  1.00 65.02      A    C  
ATOM    192  CD2 PHE    45      35.334  -6.773   2.448  1.00 58.18      A    C  
ATOM    193  C   PHE    45      36.481  -8.089   6.879  1.00 55.58      A    C  
ATOM    194  O   PHE    45      35.519  -7.741   7.578  1.00 55.09      A    O  
ATOM    195  N   GLU    46      37.686  -8.344   7.381  1.00 56.08      A    N  
ATOM    196  CA  GLU    46      37.969  -8.188   8.805  1.00 57.83      A    C  
ATOM    197  CB  GLU    46      39.401  -8.620   9.155  1.00 59.91      A    C  
ATOM    198  CG  GLU    46      39.750 -10.086   8.880  1.00 61.88      A    C  
ATOM    199  CD  GLU    46      40.313 -10.306   7.470  1.00 65.85      A    C  
ATOM    200  OE1 GLU    46      39.935  -9.574   6.516  1.00 60.16      A    O  
ATOM    201  OE2 GLU    46      41.147 -11.223   7.320  1.00 72.28      A    O  
ATOM    202  C   GLU    46      37.762  -6.724   9.155  1.00 57.63      A    C  
ATOM    203  O   GLU    46      38.320  -5.836   8.509  1.00 58.66      A    O  
ATOM    204  N   ALA    47      36.924  -6.478  10.150  1.00 57.65      A    N  
ATOM    205  CA  ALA    47      36.649  -5.120  10.594  1.00 58.18      A    C  
ATOM    206  CB  ALA    47      35.406  -4.582   9.895  1.00 56.70      A    C  
ATOM    207  C   ALA    47      36.505  -5.054  12.117  1.00 60.50      A    C  
ATOM    208  O   ALA    47      36.526  -6.082  12.792  1.00 61.81      A    O  
ATOM    209  N   GLN    48      36.390  -3.842  12.652  1.00 63.44      A    N  
ATOM    210  CA  GLN    48      36.171  -3.640  14.084  1.00 67.12      A    C  
ATOM    211  CB  GLN    48      37.456  -3.160  14.766  1.00 71.03      A    C  
ATOM    212  CG  GLN    48      37.367  -3.069  16.297  1.00 75.40      A    C  
ATOM    213  CD  GLN    48      38.641  -2.565  16.949  1.00 80.70      A    C  
ATOM    214  OE1 GLN    48      39.520  -2.019  16.287  1.00 80.17      A    O  
ATOM    215  NE2 GLN    48      38.742  -2.741  18.266  1.00 86.01      A    N  
ATOM    216  C   GLN    48      35.030  -2.652  14.331  1.00 69.25      A    C  
ATOM    217  O   GLN    48      34.873  -1.667  13.598  1.00 67.51      A    O  
ATOM    218  N   VAL    49      34.243  -2.927  15.369  1.00 72.79      A    N  
ATOM    219  CA  VAL    49      33.117  -2.082  15.740  1.00 76.25      A    C  
ATOM    220  CB  VAL    49      32.072  -2.853  16.579  1.00 80.46      A    C  
ATOM    221  CG1 VAL    49      30.933  -1.925  17.006  1.00 82.55      A    C  
ATOM    222  CG2 VAL    49      31.539  -4.055  15.802  1.00 75.52      A    C  
ATOM    223  C   VAL    49      33.586  -0.852  16.516  1.00 81.59      A    C  
ATOM    224  O   VAL    49      34.141  -0.962  17.614  1.00 86.04      A    O  
ATOM    225  N   VAL    50      33.342   0.318  15.936  1.00 81.58      A    N  
ATOM    226  CA  VAL    50      33.742   1.586  16.532  1.00 85.85      A    C  
ATOM    227  CB  VAL    50      34.190   2.582  15.439  1.00 82.87      A    C  
ATOM    228  CG1 VAL    50      34.390   3.946  16.021  1.00 90.16      A    C  
ATOM    229  CG2 VAL    50      35.466   2.109  14.799  1.00 79.12      A    C  
ATOM    230  C   VAL    50      32.618   2.185  17.389  1.00 91.85      A    C  
ATOM    231  O   VAL    50      32.866   2.721  18.476  1.00 97.97      A    O  
ATOM    232  N   ARG    51      31.391   2.106  16.883  1.00 91.35      A    N  
ATOM    233  CA  ARG    51      30.213   2.553  17.613  1.00 98.00      A    C  
ATOM    234  CB  ARG    51      29.917   4.032  17.340  1.00100.80      A    C  
ATOM    235  CG  ARG    51      30.506   4.983  18.377  1.00107.46      A    C  
ATOM    236  CD  ARG    51      30.332   6.443  17.985  1.00110.40      A    C  
ATOM    237  NE  ARG    51      28.942   6.883  18.103  1.00118.29      A    N  
ATOM    238  CZ  ARG    51      28.426   7.482  19.175  1.00129.05      A    C  
ATOM    239  NH1 ARG    51      29.181   7.730  20.240  1.00134.40      A    N  
ATOM    240  NH2 ARG    51      27.146   7.840  19.187  1.00134.91      A    N  
ATOM    241  C   ARG    51      29.012   1.691  17.255  1.00 97.71      A    C  
ATOM    242  O   ARG    51      28.957   1.107  16.169  1.00 92.82      A    O  
ATOM    243  N   VAL    52      28.066   1.598  18.186  1.00104.09      A    N  
ATOM    244  CA  VAL    52      26.811   0.891  17.951  1.00105.53      A    C  
ATOM    245  CB  VAL    52      26.746  -0.447  18.749  1.00107.07      A    C  
ATOM    246  CG1 VAL    52      26.856  -0.214  20.262  1.00116.59      A    C  
ATOM    247  CG2 VAL    52      25.491  -1.224  18.406  1.00109.24      A    C  
ATOM    248  C   VAL    52      25.618   1.825  18.217  1.00112.85      A    C  
ATOM    249  O   VAL    52      25.528   2.453  19.276  1.00118.62      A    O  
ATOM    250  N   THR    53      24.724   1.920  17.235  1.00113.10      A    N  
ATOM    251  CA  THR    53      23.602   2.862  17.269  1.00121.51      A    C  
ATOM    252  CB  THR    53      23.697   3.858  16.086  1.00119.01      A    C  
ATOM    253  OG1 THR    53      25.050   4.292  15.937  1.00114.19      A    O  
ATOM    254  CG2 THR    53      22.815   5.078  16.309  1.00129.22      A    C  
ATOM    255  C   THR    53      22.252   2.129  17.233  1.00126.92      A    C  
ATOM    256  O   THR    53      22.201   0.930  16.948  1.00124.34      A    O  
ATOM    257  N   ARG    54      21.171   2.851  17.529  1.00135.79      A    N  
ATOM    258  CA  ARG    54      19.816   2.299  17.465  1.00143.10      A    C  
ATOM    259  CB  ARG    54      19.136   2.367  18.841  1.00152.93      A    C  
ATOM    266  C   ARG    54      18.965   3.026  16.419  1.00146.96      A    C  
ATOM    267  O   ARG    54      18.946   2.629  15.229  1.00142.84      A    O  
ATOM    268  N   GLU    73      20.100  -6.332  15.059  1.00123.32      A    N  
ATOM    269  CA  GLU    73      18.671  -6.470  14.844  1.00132.67      A    C  
ATOM    270  CB  GLU    73      18.053  -7.343  15.943  1.00141.48      A    C  
ATOM    271  CG  GLU    73      18.457  -6.965  17.377  1.00145.34      A    C  
ATOM    272  CD  GLU    73      17.406  -7.360  18.407  1.00159.33      A    C  
ATOM    273  OE1 GLU    73      16.940  -8.524  18.379  1.00163.38      A    O  
ATOM    274  OE2 GLU    73      17.047  -6.503  19.249  1.00167.09      A    O  
ATOM    275  C   GLU    73      18.000  -5.098  14.802  1.00137.46      A    C  
ATOM    276  O   GLU    73      17.488  -4.614  15.820  1.00144.45      A    O  
ATOM    277  N   ASP    74      18.001  -4.475  13.621  1.00134.20      A    N  
ATOM    278  CA  ASP    74      17.565  -3.076  13.462  1.00137.77      A    C  
ATOM    279  CB  ASP    74      16.132  -2.870  13.992  1.00150.47      A    C  
ATOM    280  CG  ASP    74      15.447  -1.638  13.404  1.00157.01      A    C  
ATOM    281  OD1 ASP    74      16.084  -0.904  12.614  1.00151.95      A    O  
ATOM    282  OD2 ASP    74      14.261  -1.406  13.738  1.00166.48      A    O  
ATOM    283  C   ASP    74      18.571  -2.133  14.150  1.00132.38      A    C  
ATOM    284  O   ASP    74      18.362  -0.917  14.243  1.00135.67      A    O  
ATOM    285  N   VAL    75      19.658  -2.731  14.633  1.00124.52      A    N  
ATOM    286  CA  VAL    75      20.823  -2.029  15.155  1.00117.47      A    C  
ATOM    287  CB  VAL    75      21.627  -2.956  16.115  1.00114.64      A    C  
ATOM    288  CG1 VAL    75      23.095  -2.588  16.171  1.00105.73      A    C  
ATOM    289  CG2 VAL    75      21.012  -2.949  17.511  1.00123.12      A    C  
ATOM    290  C   VAL    75      21.679  -1.621  13.962  1.00108.96      A    C  
ATOM    291  O   VAL    75      21.740  -2.351  12.968  1.00104.98      A    O  
ATOM    292  N   ILE    76      22.315  -0.453  14.052  1.00106.20      A    N  
ATOM    293  CA  ILE    76      23.261  -0.013  13.023  1.00 99.14      A    C  
ATOM    294  CB  ILE    76      22.765   1.254  12.255  1.00102.73      A    C  
ATOM    295  CG1 ILE    76      23.853   1.796  11.319  1.00 96.23      A    C  
ATOM    296  CD1 ILE    76      23.310   2.429  10.045  1.00 99.72      A    C  
ATOM    297  CG2 ILE    76      22.252   2.323  13.216  1.00110.67      A    C  
ATOM    298  C   ILE    76      24.690   0.120  13.573  1.00 92.90      A    C  
ATOM    299  O   ILE    76      24.945   0.887  14.499  1.00 95.46      A    O  
ATOM    300  N   TYR    77      25.607  -0.649  12.990  1.00 93.66      A    N  
ATOM    301  CA  TYR    77      26.991  -0.728  13.458  1.00 88.85      A    C  
ATOM    302  CB  TYR    77      27.533  -2.147  13.273  1.00 85.70      A    C  
ATOM    303  CG  TYR    77      26.943  -3.158  14.228  1.00 89.17      A    C  
ATOM    304  CD1 TYR    77      27.333  -3.187  15.566  1.00 90.70      A    C  
ATOM    305  CE1 TYR    77      26.796  -4.113  16.452  1.00 95.37      A    C  
ATOM    306  CZ  TYR    77      25.860  -5.028  16.005  1.00 96.78      A    C  
ATOM    307  OH  TYR    77      25.339  -5.937  16.890  1.00100.18      A    O  
ATOM    308  CE2 TYR    77      25.456  -5.027  14.677  1.00 95.16      A    C  
ATOM    309  CD2 TYR    77      26.000  -4.091  13.797  1.00 90.70      A    C  
ATOM    310  C   TYR    77      27.916   0.258  12.760  1.00 85.38      A    C  
ATOM    311  O   TYR    77      27.856   0.421  11.542  1.00 84.45      A    O  
ATOM    312  N   HIS    78      28.773   0.910  13.541  1.00 83.71      A    N  
ATOM    313  CA  HIS    78      29.810   1.770  12.989  1.00 81.14      A    C  
ATOM    314  CB  HIS    78      29.910   3.077  13.762  1.00 83.22      A    C  
ATOM    315  CG  HIS    78      28.703   3.945  13.615  1.00 87.89      A    C  
ATOM    316  ND1 HIS    78      28.769   5.234  13.134  1.00 90.48      A    N  
ATOM    317  CE1 HIS    78      27.554   5.752  13.107  1.00 94.69      A    C  
ATOM    318  NE2 HIS    78      26.702   4.840  13.539  1.00 96.87      A    N  
ATOM    319  CD2 HIS    78      27.395   3.699  13.861  1.00 91.50      A    C  
ATOM    320  C   HIS    78      31.117   1.019  13.031  1.00 77.65      A    C  
ATOM    321  O   HIS    78      31.556   0.572  14.093  1.00 78.47      A    O  
ATOM    322  N   VAL    79      31.736   0.895  11.864  1.00 73.81      A    N  
ATOM    323  CA  VAL    79      32.790  -0.070  11.660  1.00 70.60      A    C  
ATOM    324  CB  VAL    79      32.193  -1.323  10.934  1.00 70.59      A    C  
ATOM    325  CG1 VAL    79      33.109  -1.881   9.858  1.00 64.14      A    C  
ATOM    326  CG2 VAL    79      31.785  -2.385  11.956  1.00 70.14      A    C  
ATOM    327  C   VAL    79      33.993   0.529  10.929  1.00 69.42      A    C  
ATOM    328  O   VAL    79      33.844   1.379  10.051  1.00 69.22      A    O  
ATOM    329  N   LYS    80      35.186   0.100  11.328  1.00 69.05      A    N  
ATOM    330  CA  LYS    80      36.402   0.409  10.586  1.00 69.09      A    C  
ATOM    331  CB  LYS    80      37.372   1.251  11.422  1.00 70.54      A    C  
ATOM    332  CG  LYS    80      38.019   0.522  12.589  1.00 71.11      A    C  
ATOM    333  CD  LYS    80      38.951   1.430  13.346  1.00 72.80      A    C  
ATOM    334  CE  LYS    80      39.612   0.680  14.484  1.00 77.21      A    C  
ATOM    335  NZ  LYS    80      40.206   1.598  15.499  1.00 80.41      A    N  
ATOM    336  C   LYS    80      37.069  -0.878  10.094  1.00 68.73      A    C  
ATOM    337  O   LYS    80      37.050  -1.904  10.783  1.00 67.58      A    O  
ATOM    338  N   TYR    81      37.642  -0.809   8.895  1.00 69.17      A    N  
ATOM    339  CA  TYR    81      38.314  -1.942   8.276  1.00 69.65      A    C  
ATOM    340  CB  TYR    81      38.192  -1.871   6.756  1.00 71.26      A    C  
ATOM    341  CG  TYR    81      36.782  -2.058   6.257  1.00 73.36      A    C  
ATOM    342  CD1 TYR    81      35.942  -0.962   6.046  1.00 76.49      A    C  
ATOM    343  CE1 TYR    81      34.632  -1.135   5.589  1.00 78.01      A    C  
ATOM    344  CZ  TYR    81      34.160  -2.417   5.342  1.00 77.56      A    C  
ATOM    345  OH  TYR    81      32.871  -2.611   4.885  1.00 80.19      A    O  
ATOM    346  CE2 TYR    81      34.981  -3.517   5.552  1.00 75.57      A    C  
ATOM    347  CD2 TYR    81      36.279  -3.333   6.010  1.00 72.40      A    C  
ATOM    348  C   TYR    81      39.777  -2.026   8.675  1.00 70.89      A    C  
ATOM    349  O   TYR    81      40.533  -1.050   8.563  1.00 71.51      A    O  
ATOM    350  N   ASP    82      40.164  -3.215   9.130  1.00 71.89      A    N  
ATOM    351  CA  ASP    82      41.516  -3.480   9.609  1.00 73.79      A    C  
ATOM    352  CB  ASP    82      41.648  -4.954  10.017  1.00 74.15      A    C  
ATOM    353  CG  ASP    82      40.868  -5.285  11.286  1.00 76.59      A    C  
ATOM    354  OD1 ASP    82      40.138  -4.405  11.803  1.00 78.41      A    O  
ATOM    355  OD2 ASP    82      40.989  -6.432  11.775  1.00 78.61      A    O  
ATOM    356  C   ASP    82      42.576  -3.103   8.576  1.00 74.38      A    C  
ATOM    357  O   ASP    82      43.536  -2.406   8.898  1.00 77.23      A    O  
ATOM    358  N   ASP    83      42.376  -3.540   7.336  1.00 72.34      A    N  
ATOM    359  CA  ASP    83      43.368  -3.352   6.288  1.00 72.89      A    C  
ATOM    360  CB  ASP    83      43.600  -4.675   5.546  1.00 73.65      A    C  
ATOM    361  CG  ASP    83      44.090  -5.780   6.467  1.00 75.64      A    C  
ATOM    362  OD1 ASP    83      45.026  -5.529   7.263  1.00 79.90      A    O  
ATOM    363  OD2 ASP    83      43.535  -6.899   6.399  1.00 75.47      A    O  
ATOM    364  C   ASP    83      43.012  -2.238   5.307  1.00 72.04      A    C  
ATOM    365  O   ASP    83      43.717  -2.037   4.311  1.00 73.88      A    O  
ATOM    366  N   TYR    84      41.927  -1.517   5.582  1.00 69.13      A    N  
ATOM    367  CA  TYR    84      41.477  -0.450   4.687  1.00 69.06      A    C  
ATOM    368  CB  TYR    84      40.293  -0.925   3.838  1.00 67.58      A    C  
ATOM    369  CG  TYR    84      40.560  -2.187   3.072  1.00 66.36      A    C  
ATOM    370  CD1 TYR    84      41.057  -2.140   1.773  1.00 68.00      A    C  
ATOM    371  CE1 TYR    84      41.312  -3.305   1.067  1.00 69.12      A    C  
ATOM    372  CZ  TYR    84      41.063  -4.533   1.656  1.00 66.52      A    C  
ATOM    373  OH  TYR    84      41.309  -5.690   0.957  1.00 68.36      A    O  
ATOM    374  CE2 TYR    84      40.569  -4.603   2.945  1.00 65.02      A    C  
ATOM    375  CD2 TYR    84      40.318  -3.433   3.644  1.00 63.68      A    C  
ATOM    376  C   TYR    84      41.094   0.836   5.421  1.00 69.64      A    C  
ATOM    377  O   TYR    84      39.916   1.207   5.433  1.00 69.47      A    O  
ATOM    378  N   PRO    85      42.084   1.534   6.020  1.00 70.58      A    N  
ATOM    379  CA  PRO    85      41.773   2.784   6.721  1.00 70.66      A    C  
ATOM    380  CB  PRO    85      43.114   3.175   7.348  1.00 72.50      A    C  
ATOM    381  CG  PRO    85      44.141   2.518   6.489  1.00 73.96      A    C  
ATOM    382  CD  PRO    85      43.525   1.219   6.080  1.00 72.47      A    C  
ATOM    383  C   PRO    85      41.266   3.886   5.780  1.00 71.62      A    C  
ATOM    384  O   PRO    85      40.622   4.830   6.230  1.00 71.33      A    O  
ATOM    385  N   GLU    86      41.546   3.751   4.485  1.00 73.37      A    N  
ATOM    386  CA  GLU    86      41.039   4.679   3.476  1.00 75.64      A    C  
ATOM    387  CB  GLU    86      41.735   4.463   2.122  1.00 78.50      A    C  
ATOM    388  CG  GLU    86      41.443   3.121   1.422  1.00 78.65      A    C  
ATOM    389  CD  GLU    86      42.359   1.979   1.859  1.00 76.94      A    C  
ATOM    390  OE1 GLU    86      42.547   1.037   1.060  1.00 77.72      A    O  
ATOM    391  OE2 GLU    86      42.890   2.012   2.992  1.00 76.80      A    O  
ATOM    392  C   GLU    86      39.514   4.604   3.332  1.00 75.93      A    C  
ATOM    393  O   GLU    86      38.896   5.510   2.775  1.00 79.57      A    O  
ATOM    394  N   ASN    87      38.915   3.529   3.843  1.00 74.12      A    N  
ATOM    395  CA  ASN    87      37.456   3.377   3.865  1.00 73.88      A    C  
ATOM    396  CB  ASN    87      37.066   1.910   4.057  1.00 72.05      A    C  
ATOM    397  CG  ASN    87      37.319   1.066   2.821  1.00 73.77      A    C  
ATOM    398  OD1 ASN    87      37.855   1.542   1.815  1.00 75.97      A    O  
ATOM    399  ND2 ASN    87      36.926  -0.201   2.891  1.00 74.00      A    N  
ATOM    400  C   ASN    87      36.762   4.227   4.928  1.00 73.27      A    C  
ATOM    401  O   ASN    87      35.550   4.423   4.874  1.00 75.05      A    O  
ATOM    402  N   GLY    88      37.531   4.721   5.894  1.00 71.73      A    N  
ATOM    403  CA  GLY    88      36.985   5.521   6.984  1.00 70.82      A    C  
ATOM    404  C   GLY    88      36.114   4.688   7.898  1.00 69.49      A    C  
ATOM    405  O   GLY    88      36.270   3.471   7.961  1.00 68.16      A    O  
ATOM    406  N   VAL    89      35.206   5.350   8.612  1.00 70.56      A    N  
ATOM    407  CA  VAL    89      34.196   4.670   9.414  1.00 71.17      A    C  
ATOM    408  CB  VAL    89      33.888   5.413  10.748  1.00 72.80      A    C  
ATOM    409  CG1 VAL    89      32.826   4.671  11.550  1.00 73.51      A    C  
ATOM    410  CG2 VAL    89      35.142   5.548  11.580  1.00 71.42      A    C  
ATOM    411  C   VAL    89      32.928   4.502   8.570  1.00 73.41      A    C  
ATOM    412  O   VAL    89      32.409   5.472   8.000  1.00 74.86      A    O  
ATOM    413  N   VAL    90      32.453   3.258   8.493  1.00 73.03      A    N  
ATOM    414  CA  VAL    90      31.321   2.886   7.650  1.00 75.55      A    C  
ATOM    415  CB  VAL    90      31.726   1.802   6.610  1.00 73.49      A    C  
ATOM    416  CG1 VAL    90      30.564   1.471   5.676  1.00 76.90      A    C  
ATOM    417  CG2 VAL    90      32.935   2.247   5.802  1.00 72.13      A    C  
ATOM    418  C   VAL    90      30.170   2.361   8.509  1.00 78.45      A    C  
ATOM    419  O   VAL    90      30.374   1.542   9.411  1.00 77.22      A    O  
ATOM    420  N   GLN    91      28.965   2.843   8.218  1.00 83.52      A    N  
ATOM    421  CA  GLN    91      27.755   2.390   8.897  1.00 87.88      A    C  
ATOM    422  CB  GLN    91      26.682   3.467   8.832  1.00 92.88      A    C  
ATOM    423  CG  GLN    91      27.037   4.717   9.618  1.00 93.91      A    C  
ATOM    424  CD  GLN    91      25.943   5.755   9.589  1.00 99.60      A    C  
ATOM    425  OE1 GLN    91      26.208   6.939   9.389  1.00101.46      A    O  
ATOM    426  NE2 GLN    91      24.703   5.322   9.788  1.00105.50      A    N  
ATOM    427  C   GLN    91      27.243   1.090   8.293  1.00 88.99      A    C  
ATOM    428  O   GLN    91      27.083   0.980   7.079  1.00 90.22      A    O  
ATOM    429  N   MET    92      26.981   0.113   9.156  1.00 90.02      A    N  
ATOM    430  CA  MET    92      26.645  -1.241   8.737  1.00 90.94      A    C  
ATOM    431  CB  MET    92      27.692  -2.221   9.268  1.00 88.07      A    C  
ATOM    432  CG  MET    92      29.111  -1.959   8.803  1.00 88.61      A    C  
ATOM    433  SD  MET    92      29.351  -2.318   6.905  1.00 98.62      A   SE  
ATOM    434  CE  MET    92      28.929  -4.197   6.883  1.00 91.66      A    C  
ATOM    435  C   MET    92      25.273  -1.687   9.236  1.00 95.56      A    C  
ATOM    436  O   MET    92      24.911  -1.435  10.385  1.00 97.05      A    O  
ATOM    437  N   ASN    93      24.522  -2.361   8.368  1.00 97.87      A    N  
ATOM    438  CA  ASN    93      23.301  -3.045   8.779  1.00102.77      A    C  
ATOM    439  CB  ASN    93      22.460  -3.441   7.563  1.00106.54      A    C  
ATOM    440  CG  ASN    93      21.019  -3.772   7.928  1.00114.89      A    C  
ATOM    441  OD1 ASN    93      20.744  -4.745   8.638  1.00116.51      A    O  
ATOM    442  ND2 ASN    93      20.090  -2.967   7.431  1.00121.11      A    N  
ATOM    443  C   ASN    93      23.673  -4.280   9.590  1.00100.09      A    C  
ATOM    444  O   ASN    93      24.659  -4.952   9.284  1.00 94.90      A    O  
ATOM    445  N   SER    94      22.877  -4.571  10.617  1.00103.84      A    N  
ATOM    446  CA  SER    94      23.168  -5.647  11.574  1.00102.37      A    C  
ATOM    447  CB  SER    94      22.088  -5.692  12.660  1.00109.16      A    C  
ATOM    448  OG  SER    94      22.463  -6.552  13.726  1.00109.46      A    O  
ATOM    449  C   SER    94      23.328  -7.033  10.943  1.00 99.33      A    C  
ATOM    450  O   SER    94      23.924  -7.923  11.548  1.00 96.67      A    O  
ATOM    451  N   ARG    95      22.787  -7.207   9.738  1.00100.12      A    N  
ATOM    452  CA  ARG    95      22.866  -8.476   9.012  1.00 98.31      A    C  
ATOM    453  CB  ARG    95      21.658  -8.642   8.083  1.00103.51      A    C  
ATOM    454  CG  ARG    95      21.541  -7.572   7.000  1.00105.74      A    C  
ATOM    455  CD  ARG    95      20.258  -7.724   6.207  1.00112.78      A    C  
ATOM    456  NE  ARG    95      20.009  -6.556   5.366  1.00118.15      A    N  
ATOM    460  C   ARG    95      24.162  -8.567   8.214  1.00 91.56      A    C  
ATOM    461  O   ARG    95      24.609  -9.665   7.850  1.00 88.39      A    O  
ATOM    462  N   ASP    96      24.750  -7.399   7.951  1.00 89.10      A    N  
ATOM    463  CA  ASP    96      25.999  -7.276   7.205  1.00 82.96      A    C  
ATOM    464  CB  ASP    96      25.998  -5.988   6.373  1.00 83.81      A    C  
ATOM    465  CG  ASP    96      25.193  -6.112   5.088  1.00 87.00      A    C  
ATOM    466  OD1 ASP    96      24.933  -7.246   4.636  1.00 87.12      A    O  
ATOM    467  OD2 ASP    96      24.829  -5.063   4.519  1.00 89.68      A    O  
ATOM    468  C   ASP    96      27.236  -7.329   8.109  1.00 78.81      A    C  
ATOM    469  O   ASP    96      28.366  -7.175   7.633  1.00 75.79      A    O  
ATOM    470  N   VAL    97      27.025  -7.546   9.406  1.00 79.24      A    N  
ATOM    471  CA  VAL    97      28.137  -7.792  10.337  1.00 76.33      A    C  
ATOM    472  CB  VAL    97      28.549  -6.514  11.163  1.00 76.33      A    C  
ATOM    473  CG1 VAL    97      27.457  -5.473  11.146  1.00 81.16      A    C  
ATOM    474  CG2 VAL    97      28.977  -6.853  12.599  1.00 76.18      A    C  
ATOM    475  C   VAL    97      27.883  -9.017  11.216  1.00 77.38      A    C  
ATOM    476  O   VAL    97      26.768  -9.236  11.698  1.00 81.25      A    O  
ATOM    477  N   ARG    98      28.926  -9.823  11.394  1.00 73.62      A    N  
ATOM    478  CA  ARG    98      28.844 -11.037  12.197  1.00 74.98      A    C  
ATOM    479  CB  ARG    98      28.402 -12.230  11.333  1.00 74.25      A    C  
ATOM    480  CG  ARG    98      29.415 -12.653  10.279  1.00 69.79      A    C  
ATOM    481  CD  ARG    98      28.820 -13.641   9.295  1.00 70.18      A    C  
ATOM    482  NE  ARG    98      29.792 -14.010   8.269  1.00 67.23      A    N  
ATOM    483  CZ  ARG    98      29.480 -14.503   7.072  1.00 66.25      A    C  
ATOM    484  NH1 ARG    98      28.214 -14.686   6.730  1.00 69.46      A    N  
ATOM    485  NH2 ARG    98      30.438 -14.808   6.209  1.00 62.39      A    N  
ATOM    486  C   ARG    98      30.189 -11.316  12.861  1.00 73.07      A    C  
ATOM    487  O   ARG    98      31.182 -10.655  12.555  1.00 70.00      A    O  
ATOM    488  N   ALA    99      30.215 -12.295  13.763  1.00 75.78      A    N  
ATOM    489  CA  ALA    99      31.446 -12.698  14.440  1.00 76.68      A    C  
ATOM    490  CB  ALA    99      31.164 -13.801  15.444  1.00 79.68      A    C  
ATOM    491  C   ALA    99      32.484 -13.157  13.423  1.00 73.07      A    C  
ATOM    492  O   ALA    99      32.138 -13.801  12.434  1.00 72.70      A    O  
ATOM    493  N   ARG   100      33.748 -12.822  13.671  1.00 72.44      A    N  
ATOM    494  CA  ARG   100      34.839 -13.184  12.777  1.00 71.01      A    C  
ATOM    495  CB  ARG   100      36.168 -12.642  13.305  1.00 71.60      A    C  
ATOM    496  CG  ARG   100      37.275 -12.682  12.273  1.00 71.40      A    C  
ATOM    497  CD  ARG   100      38.385 -11.712  12.580  1.00 73.85      A    C  
ATOM    498  NE  ARG   100      38.010 -10.331  12.296  1.00 73.41      A    N  
ATOM    499  CZ  ARG   100      38.795  -9.285  12.528  1.00 75.14      A    C  
ATOM    500  NH1 ARG   100      38.373  -8.063  12.255  1.00 75.99      A    N  
ATOM    501  NH2 ARG   100      40.004  -9.457  13.035  1.00 80.38      A    N  
ATOM    502  C   ARG   100      34.921 -14.695  12.550  1.00 71.83      A    C  
ATOM    503  O   ARG   100      34.724 -15.474  13.472  1.00 75.13      A    O  
ATOM    504  N   ALA   101      35.185 -15.103  11.312  1.00 71.01      A    N  
ATOM    505  CA  ALA   101      35.329 -16.525  10.994  1.00 72.17      A    C  
ATOM    506  CB  ALA   101      35.429 -16.722   9.503  1.00 68.85      A    C  
ATOM    507  C   ALA   101      36.552 -17.119  11.710  1.00 75.15      A    C  
ATOM    508  O   ALA   101      37.615 -16.494  11.754  1.00 76.06      A    O  
ATOM    509  N   ARG   102      36.393 -18.307  12.292  1.00 77.04      A    N  
ATOM    510  CA  ARG   102      37.495 -18.945  13.018  1.00 80.24      A    C  
ATOM    511  CB  ARG   102      37.422 -18.649  14.532  1.00 84.15      A    C  
ATOM    512  CG  ARG   102      36.203 -19.204  15.271  1.00 87.78      A    C  
ATOM    513  CD  ARG   102      36.375 -19.083  16.790  1.00 94.35      A    C  
ATOM    514  NE  ARG   102      35.293 -19.729  17.539  1.00100.75      A    N  
ATOM    515  CZ  ARG   102      35.301 -21.003  17.926  1.00102.53      A    C  
ATOM    518  C   ARG   102      37.656 -20.449  12.745  1.00 80.42      A    C  
ATOM    519  O   ARG   102      38.732 -21.007  12.968  1.00 82.56      A    O  
ATOM    520  N   THR   103      36.603 -21.092  12.243  1.00 78.34      A    N  
ATOM    521  CA  THR   103      36.599 -22.546  12.083  1.00 78.04      A    C  
ATOM    522  CB  THR   103      35.419 -23.186  12.852  1.00 80.45      A    C  
ATOM    523  OG1 THR   103      35.405 -22.698  14.199  1.00 83.17      A    O  
ATOM    524  CG2 THR   103      35.535 -24.702  12.867  1.00 81.05      A    C  
ATOM    525  C   THR   103      36.580 -22.993  10.620  1.00 74.75      A    C  
ATOM    526  O   THR   103      35.704 -22.597   9.843  1.00 72.85      A    O  
ATOM    527  N   ILE   104      37.563 -23.816  10.260  1.00 74.51      A    N  
ATOM    528  CA  ILE   104      37.632 -24.436   8.939  1.00 71.52      A    C  
ATOM    529  CB  ILE   104      39.104 -24.721   8.524  1.00 72.44      A    C  
ATOM    530  CG1 ILE   104      39.888 -23.415   8.327  1.00 72.05      A    C  
ATOM    531  CD1 ILE   104      39.530 -22.634   7.057  1.00 70.80      A    C  
ATOM    532  CG2 ILE   104      39.176 -25.610   7.273  1.00 71.84      A    C  
ATOM    533  C   ILE   104      36.840 -25.745   8.930  1.00 72.09      A    C  
ATOM    534  O   ILE   104      37.025 -26.603   9.804  1.00 75.02      A    O  
ATOM    535  N   ILE   105      35.952 -25.885   7.951  1.00 69.18      A    N  
ATOM    536  CA  ILE   105      35.303 -27.162   7.691  1.00 69.78      A    C  
ATOM    537  CB  ILE   105      33.883 -26.988   7.109  1.00 68.99      A    C  
ATOM    538  CG1 ILE   105      33.034 -26.087   8.021  1.00 70.06      A    C  
ATOM    539  CD1 ILE   105      31.766 -25.553   7.376  1.00 68.53      A    C  
ATOM    540  CG2 ILE   105      33.218 -28.359   6.902  1.00 69.89      A    C  
ATOM    541  C   ILE   105      36.177 -27.947   6.721  1.00 69.20      A    C  
ATOM    542  O   ILE   105      36.321 -27.559   5.557  1.00 67.81      A    O  
ATOM    543  N   LYS   106      36.768 -29.036   7.213  1.00 71.18      A    N  
ATOM    544  CA  LYS   106      37.645 -29.901   6.409  1.00 71.31      A    C  
ATOM    545  CB  LYS   106      38.240 -31.027   7.268  1.00 74.66      A    C  
ATOM    546  CG  LYS   106      39.235 -30.553   8.327  1.00 78.99      A    C  
ATOM    547  CD  LYS   106      39.729 -31.711   9.190  1.00 83.40      A    C  
ATOM    550  C   LYS   106      36.906 -30.487   5.204  1.00 68.56      A    C  
ATOM    551  O   LYS   106      35.686 -30.651   5.238  1.00 67.81      A    O  
ATOM    552  N   TRP   107      37.645 -30.803   4.143  1.00 67.47      A    N  
ATOM    553  CA  TRP   107      37.031 -31.309   2.911  1.00 66.13      A    C  
ATOM    554  CB  TRP   107      38.099 -31.666   1.875  1.00 65.53      A    C  
ATOM    555  CG  TRP   107      37.617 -32.592   0.793  1.00 64.63      A    C  
ATOM    556  CD1 TRP   107      37.749 -33.948   0.764  1.00 64.45      A    C  
ATOM    557  NE1 TRP   107      37.178 -34.455  -0.377  1.00 65.36      A    N  
ATOM    558  CE2 TRP   107      36.661 -33.425  -1.117  1.00 63.71      A    C  
ATOM    559  CD2 TRP   107      36.913 -32.231  -0.408  1.00 63.14      A    C  
ATOM    560  CE3 TRP   107      36.481 -31.017  -0.957  1.00 60.76      A    C  
ATOM    561  CZ3 TRP   107      35.822 -31.035  -2.188  1.00 63.26      A    C  
ATOM    562  CH2 TRP   107      35.583 -32.242  -2.864  1.00 62.56      A    C  
ATOM    563  CZ2 TRP   107      35.996 -33.441  -2.350  1.00 63.71      A    C  
ATOM    564  C   TRP   107      36.088 -32.487   3.158  1.00 68.02      A    C  
ATOM    565  O   TRP   107      35.038 -32.587   2.516  1.00 67.19      A    O  
ATOM    566  N   GLN   108      36.462 -33.367   4.090  1.00 81.54      A    N  
ATOM    567  CA  GLN   108      35.651 -34.544   4.428  1.00 86.61      A    C  
ATOM    568  CB  GLN   108      36.355 -35.444   5.453  1.00 94.14      A    C  
ATOM    569  CG  GLN   108      37.838 -35.684   5.202  1.00100.96      A    C  
ATOM    570  CD  GLN   108      38.722 -34.745   6.006  1.00102.76      A    C  
ATOM    571  OE1 GLN   108      39.223 -33.746   5.486  1.00 97.70      A    O  
ATOM    572  NE2 GLN   108      38.908 -35.060   7.288  1.00109.40      A    N  
ATOM    573  C   GLN   108      34.288 -34.148   4.977  1.00 84.65      A    C  
ATOM    574  O   GLN   108      33.279 -34.788   4.683  1.00 85.99      A    O  
ATOM    575  N   ASP   109      34.272 -33.087   5.776  1.00 83.07      A    N  
ATOM    576  CA  ASP   109      33.076 -32.667   6.485  1.00 82.93      A    C  
ATOM    577  CB  ASP   109      33.458 -32.054   7.837  1.00 85.14      A    C  
ATOM    578  CG  ASP   109      33.997 -33.091   8.823  1.00 92.55      A    C  
ATOM    579  OD1 ASP   109      33.546 -34.258   8.794  1.00 96.19      A    O  
ATOM    580  OD2 ASP   109      34.871 -32.738   9.637  1.00 95.06      A    O  
ATOM    581  C   ASP   109      32.200 -31.720   5.661  1.00 77.96      A    C  
ATOM    582  O   ASP   109      31.094 -31.376   6.079  1.00 78.84      A    O  
ATOM    583  N   LEU   110      32.685 -31.320   4.488  1.00 74.26      A    N  
ATOM    584  CA  LEU   110      31.899 -30.489   3.577  1.00 70.92      A    C  
ATOM    585  CB  LEU   110      32.768 -29.936   2.443  1.00 67.27      A    C  
ATOM    586  CG  LEU   110      33.781 -28.845   2.798  1.00 65.09      A    C  
ATOM    587  CD1 LEU   110      34.700 -28.569   1.631  1.00 63.20      A    C  
ATOM    588  CD2 LEU   110      33.085 -27.570   3.234  1.00 62.99      A    C  
ATOM    589  C   LEU   110      30.732 -31.285   3.010  1.00 73.58      A    C  
ATOM    590  O   LEU   110      30.908 -32.409   2.549  1.00 76.26      A    O  
ATOM    591  N   GLU   111      29.540 -30.700   3.062  1.00 74.24      A    N  
ATOM    592  CA  GLU   111      28.329 -31.373   2.607  1.00 78.02      A    C  
ATOM    593  CB  GLU   111      27.497 -31.848   3.800  1.00 82.71      A    C  
ATOM    594  CG  GLU   111      28.116 -33.011   4.560  1.00 90.53      A    C  
ATOM    595  CD  GLU   111      27.602 -33.126   5.988  1.00 98.41      A    C  
ATOM    596  OE1 GLU   111      26.455 -33.590   6.180  1.00102.57      A    O  
ATOM    597  OE2 GLU   111      28.355 -32.761   6.920  1.00100.99      A    O  
ATOM    598  C   GLU   111      27.490 -30.469   1.715  1.00 76.64      A    C  
ATOM    599  O   GLU   111      27.457 -29.251   1.901  1.00 75.67      A    O  
ATOM    600  N   VAL   112      26.813 -31.083   0.749  1.00 78.34      A    N  
ATOM    601  CA  VAL   112      25.915 -30.384  -0.168  1.00 77.86      A    C  
ATOM    602  CB  VAL   112      25.330 -31.365  -1.218  1.00 81.46      A    C  
ATOM    603  CG1 VAL   112      24.284 -30.689  -2.078  1.00 82.23      A    C  
ATOM    604  CG2 VAL   112      26.442 -31.937  -2.088  1.00 78.08      A    C  
ATOM    605  C   VAL   112      24.794 -29.655   0.586  1.00 80.43      A    C  
ATOM    606  O   VAL   112      24.029 -30.264   1.345  1.00 83.79      A    O  
ATOM    607  N   GLY   113      24.722 -28.342   0.386  1.00 79.05      A    N  
ATOM    608  CA  GLY   113      23.639 -27.542   0.943  1.00 82.32      A    C  
ATOM    609  C   GLY   113      24.029 -26.621   2.082  1.00 81.33      A    C  
ATOM    610  O   GLY   113      23.254 -25.742   2.463  1.00 84.67      A    O  
ATOM    611  N   GLN   114      25.226 -26.827   2.628  1.00 77.51      A    N  
ATOM    612  CA  GLN   114      25.771 -25.961   3.668  1.00 76.18      A    C  
ATOM    613  CB  GLN   114      27.088 -26.527   4.198  1.00 74.01      A    C  
ATOM    614  CG  GLN   114      26.983 -27.842   4.950  1.00 78.35      A    C  
ATOM    615  CD  GLN   114      28.343 -28.391   5.344  1.00 76.40      A    C  
ATOM    616  OE1 GLN   114      29.316 -28.243   4.614  1.00 73.16      A    O  
ATOM    617  NE2 GLN   114      28.412 -29.031   6.502  1.00 82.18      A    N  
ATOM    618  C   GLN   114      26.038 -24.559   3.130  1.00 73.65      A    C  
ATOM    619  O   GLN   114      26.486 -24.404   1.987  1.00 70.71      A    O  
ATOM    620  N   VAL   115      25.760 -23.544   3.949  1.00 75.05      A    N  
ATOM    621  CA  VAL   115      26.222 -22.194   3.640  1.00 72.83      A    C  
ATOM    622  CB  VAL   115      25.147 -21.100   3.813  1.00 76.99      A    C  
ATOM    623  CG1 VAL   115      23.943 -21.419   2.939  1.00 81.10      A    C  
ATOM    624  CG2 VAL   115      24.744 -20.935   5.272  1.00 83.11      A    C  
ATOM    625  C   VAL   115      27.496 -21.896   4.416  1.00 70.02      A    C  
ATOM    626  O   VAL   115      27.543 -21.972   5.652  1.00 71.87      A    O  
ATOM    627  N   VAL   116      28.535 -21.575   3.657  1.00 65.64      A    N  
ATOM    628  CA  VAL   116      29.880 -21.463   4.175  1.00 63.59      A    C  
ATOM    629  CB  VAL   116      30.730 -22.663   3.704  1.00 62.16      A    C  
ATOM    630  CG1 VAL   116      30.220 -23.965   4.306  1.00 63.67      A    C  
ATOM    631  CG2 VAL   116      30.729 -22.751   2.189  1.00 60.61      A    C  
ATOM    632  C   VAL   116      30.519 -20.168   3.671  1.00 62.26      A    C  
ATOM    633  O   VAL   116      29.996 -19.539   2.752  1.00 61.77      A    O  
ATOM    634  N   MET   117      31.639 -19.770   4.276  1.00 61.42      A    N  
ATOM    635  CA  MET   117      32.456 -18.698   3.712  1.00 60.96      A    C  
ATOM    636  CB  MET   117      32.820 -17.642   4.757  1.00 61.90      A    C  
ATOM    637  CG  MET   117      33.221 -16.318   4.116  1.00 62.48      A    C  
ATOM    638  SD  MET   117      33.916 -15.018   5.390  1.00 66.12      A   SE  
ATOM    639  CE  MET   117      35.602 -15.886   5.817  1.00 66.17      A    C  
ATOM    640  C   MET   117      33.716 -19.269   3.064  1.00 58.29      A    C  
ATOM    641  O   MET   117      34.464 -20.014   3.688  1.00 59.06      A    O  
ATOM    642  N   LEU   118      33.946 -18.901   1.812  1.00 57.12      A    N  
ATOM    643  CA  LEU   118      35.039 -19.463   1.034  1.00 56.29      A    C  
ATOM    644  CB  LEU   118      34.557 -20.698   0.265  1.00 56.76      A    C  
ATOM    645  CG  LEU   118      33.252 -20.615  -0.531  1.00 57.64      A    C  
ATOM    646  CD1 LEU   118      33.420 -19.891  -1.874  1.00 59.59      A    C  
ATOM    647  CD2 LEU   118      32.730 -22.021  -0.747  1.00 60.22      A    C  
ATOM    648  C   LEU   118      35.646 -18.452   0.064  1.00 56.96      A    C  
ATOM    649  O   LEU   118      35.047 -17.412  -0.233  1.00 57.12      A    O  
ATOM    650  N   ASN   119      36.832 -18.789  -0.438  1.00 56.86      A    N  
ATOM    651  CA  ASN   119      37.591 -17.907  -1.306  1.00 57.26      A    C  
ATOM    652  CB  ASN   119      39.094 -18.065  -1.047  1.00 58.13      A    C  
ATOM    653  CG  ASN   119      39.881 -16.825  -1.412  1.00 59.37      A    C  
ATOM    654  OD1 ASN   119      40.059 -16.510  -2.592  1.00 52.64      A    O  
ATOM    655  ND2 ASN   119      40.346 -16.097  -0.389  1.00 56.44      A    N  
ATOM    656  C   ASN   119      37.264 -18.177  -2.756  1.00 58.04      A    C  
ATOM    657  O   ASN   119      37.354 -19.312  -3.229  1.00 59.26      A    O  
ATOM    658  N   TYR   120      36.866 -17.127  -3.459  1.00 58.92      A    N  
ATOM    659  CA  TYR   120      36.514 -17.235  -4.856  1.00 58.75      A    C  
ATOM    660  CB  TYR   120      35.028 -17.595  -4.993  1.00 60.08      A    C  
ATOM    661  CG  TYR   120      34.561 -17.864  -6.416  1.00 63.34      A    C  
ATOM    662  CD1 TYR   120      35.007 -18.984  -7.126  1.00 65.99      A    C  
ATOM    663  CE1 TYR   120      34.575 -19.233  -8.437  1.00 67.83      A    C  
ATOM    664  CZ  TYR   120      33.681 -18.356  -9.046  1.00 74.16      A    C  
ATOM    665  OH  TYR   120      33.240 -18.592 -10.343  1.00 80.05      A    O  
ATOM    666  CE2 TYR   120      33.219 -17.243  -8.356  1.00 72.18      A    C  
ATOM    667  CD2 TYR   120      33.662 -17.003  -7.047  1.00 68.44      A    C  
ATOM    668  C   TYR   120      36.837 -15.934  -5.568  1.00 61.83      A    C  
ATOM    669  O   TYR   120      36.938 -14.887  -4.938  1.00 58.65      A    O  
ATOM    670  N   ASN   121      36.987 -16.005  -6.894  1.00 66.19      A    N  
ATOM    671  CA  ASN   121      37.288 -14.834  -7.695  1.00 69.65      A    C  
ATOM    672  CB  ASN   121      38.759 -14.832  -8.091  1.00 71.49      A    C  
ATOM    673  CG  ASN   121      39.213 -13.497  -8.646  1.00 78.45      A    C  
ATOM    674  OD1 ASN   121      38.577 -12.918  -9.538  1.00 85.52      A    O  
ATOM    675  ND2 ASN   121      40.341 -13.013  -8.144  1.00 77.55      A    N  
ATOM    676  C   ASN   121      36.384 -14.766  -8.924  1.00 77.49      A    C  
ATOM    677  O   ASN   121      36.703 -15.335  -9.972  1.00 78.65      A    O  
ATOM    678  N   PRO   122      35.246 -14.063  -8.791  1.00 80.08      A    N  
ATOM    679  CA  PRO   122      34.210 -13.957  -9.812  1.00 86.20      A    C  
ATOM    680  CB  PRO   122      33.292 -12.865  -9.259  1.00 86.42      A    C  
ATOM    681  CG  PRO   122      33.448 -12.974  -7.791  1.00 82.10      A    C  
ATOM    682  CD  PRO   122      34.890 -13.316  -7.567  1.00 76.62      A    C  
ATOM    683  C   PRO   122      34.740 -13.582 -11.205  1.00 95.34      A    C  
ATOM    684  O   PRO   122      34.304 -14.165 -12.200  1.00 98.08      A    O  
ATOM    685  N   ASP   123      35.680 -12.637 -11.255  1.00 98.70      A    N  
ATOM    686  CA  ASP   123      36.210 -12.096 -12.512  1.00107.79      A    C  
ATOM    687  CB  ASP   123      36.952 -10.783 -12.250  1.00110.01      A    C  
ATOM    688  CG  ASP   123      36.012  -9.599 -12.080  1.00113.62      A    C  
ATOM    689  OD1 ASP   123      35.072  -9.457 -12.894  1.00118.87      A    O  
ATOM    690  OD2 ASP   123      36.223  -8.800 -11.140  1.00109.85      A    O  
ATOM    691  C   ASP   123      37.124 -13.073 -13.247  1.00110.22      A    C  
ATOM    692  O   ASP   123      37.163 -13.092 -14.484  1.00119.05      A    O  
ATOM    693  N   ASN   124      37.868 -13.860 -12.472  1.00104.22      A    N  
ATOM    694  CA  ASN   124      38.691 -14.958 -12.984  1.00106.51      A    C  
ATOM    695  CB  ASN   124      40.090 -14.477 -13.400  1.00111.43      A    C  
ATOM    696  CG  ASN   124      40.625 -13.375 -12.508  1.00109.34      A    C  
ATOM    697  OD1 ASN   124      40.850 -12.255 -12.961  1.00114.42      A    O  
ATOM    698  ND2 ASN   124      40.823 -13.685 -11.229  1.00102.69      A    N  
ATOM    699  C   ASN   124      38.754 -16.096 -11.960  1.00 99.63      A    C  
ATOM    700  O   ASN   124      39.585 -16.073 -11.036  1.00 94.87      A    O  
ATOM    701  N   PRO   125      37.834 -17.072 -12.096  1.00 98.76      A    N  
ATOM    702  CA  PRO   125      37.609 -18.161 -11.135  1.00 93.07      A    C  
ATOM    703  CB  PRO   125      36.475 -18.965 -11.787  1.00 95.03      A    C  
ATOM    704  CG  PRO   125      35.763 -17.960 -12.623  1.00100.37      A    C  
ATOM    705  CD  PRO   125      36.874 -17.146 -13.209  1.00104.85      A    C  
ATOM    706  C   PRO   125      38.812 -19.059 -10.845  1.00 92.16      A    C  
ATOM    707  O   PRO   125      38.794 -19.805  -9.862  1.00 88.10      A    O  
ATOM    708  N   LYS   126      39.842 -18.980 -11.681  1.00 97.48      A    N  
ATOM    709  CA  LYS   126      41.031 -19.804 -11.512  1.00 97.83      A    C  
ATOM    710  CB  LYS   126      41.771 -19.925 -12.846  1.00106.86      A    C  
ATOM    711  CG  LYS   126      42.246 -21.332 -13.163  1.00110.33      A    C  
ATOM    712  CD  LYS   126      42.605 -21.471 -14.634  1.00120.99      A    C  
ATOM    715  C   LYS   126      41.958 -19.245 -10.424  1.00 93.86      A    C  
ATOM    716  O   LYS   126      42.812 -19.961  -9.895  1.00 93.82      A    O  
ATOM    717  N   GLU   127      41.772 -17.973 -10.080  1.00 90.96      A    N  
ATOM    718  CA  GLU   127      42.707 -17.271  -9.204  1.00 89.03      A    C  
ATOM    719  CB  GLU   127      43.092 -15.909  -9.803  1.00 93.54      A    C  
ATOM    720  CG  GLU   127      43.371 -15.901 -11.315  1.00103.30      A    C  
ATOM    721  CD  GLU   127      44.637 -16.650 -11.711  1.00110.07      A    C  
ATOM    722  OE1 GLU   127      45.603 -16.662 -10.911  1.00107.71      A    O  
ATOM    723  OE2 GLU   127      44.666 -17.215 -12.835  1.00117.64      A    O  
ATOM    724  C   GLU   127      42.157 -17.070  -7.795  1.00 81.22      A    C  
ATOM    725  O   GLU   127      40.973 -17.283  -7.540  1.00 77.05      A    O  
ATOM    726  N   ARG   128      43.042 -16.663  -6.890  1.00 79.99      A    N  
ATOM    727  CA  ARG   128      42.665 -16.219  -5.550  1.00 75.18      A    C  
ATOM    728  CB  ARG   128      43.931 -15.974  -4.728  1.00 76.60      A    C  
ATOM    729  CG  ARG   128      43.724 -15.886  -3.242  1.00 73.49      A    C  
ATOM    730  CD  ARG   128      44.193 -17.147  -2.542  1.00 75.64      A    C  
ATOM    731  NE  ARG   128      43.646 -17.232  -1.188  1.00 72.47      A    N  
ATOM    732  CZ  ARG   128      43.729 -18.300  -0.402  1.00 70.66      A    C  
ATOM    733  NH1 ARG   128      44.344 -19.402  -0.816  1.00 72.28      A    N  
ATOM    734  NH2 ARG   128      43.187 -18.265   0.806  1.00 68.19      A    N  
ATOM    735  C   ARG   128      41.853 -14.923  -5.645  1.00 73.74      A    C  
ATOM    736  O   ARG   128      42.171 -14.051  -6.458  1.00 78.40      A    O  
ATOM    737  N   GLY   129      40.801 -14.816  -4.832  1.00 68.65      A    N  
ATOM    738  CA  GLY   129      39.968 -13.607  -4.753  1.00 67.08      A    C  
ATOM    739  C   GLY   129      39.572 -13.235  -3.324  1.00 63.44      A    C  
ATOM    740  O   GLY   129      40.431 -13.034  -2.461  1.00 62.31      A    O  
ATOM    741  N   PHE   130      38.265 -13.163  -3.078  1.00 61.38      A    N  
ATOM    742  CA  PHE   130      37.728 -12.673  -1.812  1.00 59.66      A    C  
ATOM    743  CB  PHE   130      36.996 -11.352  -2.025  1.00 63.17      A    C  
ATOM    744  CG  PHE   130      37.902 -10.225  -2.408  1.00 68.02      A    C  
ATOM    745  CD1 PHE   130      38.714  -9.614  -1.451  1.00 66.81      A    C  
ATOM    746  CE1 PHE   130      39.567  -8.575  -1.803  1.00 70.40      A    C  
ATOM    747  CZ  PHE   130      39.615  -8.142  -3.122  1.00 73.35      A    C  
ATOM    748  CE2 PHE   130      38.814  -8.750  -4.085  1.00 74.05      A    C  
ATOM    749  CD2 PHE   130      37.966  -9.788  -3.726  1.00 69.66      A    C  
ATOM    750  C   PHE   130      36.801 -13.666  -1.143  1.00 57.34      A    C  
ATOM    751  O   PHE   130      36.334 -14.608  -1.796  1.00 55.77      A    O  
ATOM    752  N   TRP   131      36.561 -13.442   0.159  1.00 49.70      A    N  
ATOM    753  CA  TRP   131      35.706 -14.272   0.989  1.00 51.23      A    C  
ATOM    754  CB  TRP   131      36.162 -14.149   2.445  1.00 50.95      A    C  
ATOM    755  CG  TRP   131      37.572 -14.545   2.508  1.00 47.90      A    C  
ATOM    756  CD1 TRP   131      38.665 -13.738   2.335  1.00 46.38      A    C  
ATOM    757  NE1 TRP   131      39.818 -14.490   2.399  1.00 43.72      A    N  
ATOM    758  CE2 TRP   131      39.480 -15.811   2.579  1.00 43.47      A    C  
ATOM    759  CD2 TRP   131      38.070 -15.884   2.632  1.00 47.54      A    C  
ATOM    760  CE3 TRP   131      37.460 -17.139   2.809  1.00 50.34      A    C  
ATOM    761  CZ3 TRP   131      38.272 -18.267   2.948  1.00 49.31      A    C  
ATOM    762  CH2 TRP   131      39.676 -18.159   2.898  1.00 47.35      A    C  
ATOM    763  CZ2 TRP   131      40.296 -16.946   2.703  1.00 45.25      A    C  
ATOM    764  C   TRP   131      34.214 -13.976   0.855  1.00 56.74      A    C  
ATOM    765  O   TRP   131      33.694 -13.045   1.493  1.00 58.95      A    O  
ATOM    766  N   TYR   132      33.546 -14.787   0.027  1.00 57.70      A    N  
ATOM    767  CA  TYR   132      32.093 -14.756  -0.155  1.00 62.06      A    C  
ATOM    768  CB  TYR   132      31.738 -14.902  -1.640  1.00 64.36      A    C  
ATOM    769  CG  TYR   132      32.346 -13.845  -2.512  1.00 66.16      A    C  
ATOM    770  CD1 TYR   132      31.693 -12.636  -2.724  1.00 69.59      A    C  
ATOM    771  CE1 TYR   132      32.252 -11.656  -3.516  1.00 70.75      A    C  
ATOM    772  CZ  TYR   132      33.480 -11.880  -4.109  1.00 68.34      A    C  
ATOM    773  OH  TYR   132      34.038 -10.905  -4.903  1.00 72.83      A    O  
ATOM    774  CE2 TYR   132      34.149 -13.073  -3.917  1.00 64.55      A    C  
ATOM    775  CD2 TYR   132      33.579 -14.048  -3.122  1.00 64.03      A    C  
ATOM    776  C   TYR   132      31.413 -15.900   0.577  1.00 61.98      A    C  
ATOM    777  O   TYR   132      32.010 -16.959   0.773  1.00 60.18      A    O  
ATOM    778  N   ASP   133      30.155 -15.686   0.959  1.00 64.85      A    N  
ATOM    779  CA  ASP   133      29.273 -16.783   1.352  1.00 65.55      A    C  
ATOM    780  CB  ASP   133      28.057 -16.258   2.099  1.00 68.42      A    C  
ATOM    781  CG  ASP   133      28.402 -15.750   3.477  1.00 69.42      A    C  
ATOM    782  OD1 ASP   133      29.599 -15.713   3.823  1.00 64.53      A    O  
ATOM    783  OD2 ASP   133      27.468 -15.378   4.215  1.00 76.31      A    O  
ATOM    784  C   ASP   133      28.823 -17.591   0.136  1.00 66.63      A    C  
ATOM    785  O   ASP   133      28.615 -17.038  -0.950  1.00 67.26      A    O  
ATOM    786  N   ALA   134      28.668 -18.897   0.333  1.00 65.82      A    N  
ATOM    787  CA  ALA   134      28.311 -19.804  -0.745  1.00 67.57      A    C  
ATOM    788  CB  ALA   134      29.558 -20.239  -1.510  1.00 64.02      A    C  
ATOM    789  C   ALA   134      27.558 -21.022  -0.232  1.00 69.20      A    C  
ATOM    790  O   ALA   134      27.790 -21.492   0.884  1.00 68.34      A    O  
ATOM    791  N   GLU   135      26.655 -21.525  -1.066  1.00 72.04      A    N  
ATOM    792  CA  GLU   135      25.925 -22.744  -0.785  1.00 72.93      A    C  
ATOM    793  CB  GLU   135      24.484 -22.591  -1.263  1.00 77.11      A    C  
ATOM    794  CG  GLU   135      23.524 -23.682  -0.821  1.00 78.37      A    C  
ATOM    795  CD  GLU   135      22.088 -23.368  -1.212  1.00 84.76      A    C  
ATOM    796  OE1 GLU   135      21.844 -23.039  -2.399  1.00 85.93      A    O  
ATOM    797  OE2 GLU   135      21.203 -23.447  -0.328  1.00 88.15      A    O  
ATOM    798  C   GLU   135      26.616 -23.878  -1.529  1.00 71.76      A    C  
ATOM    799  O   GLU   135      26.707 -23.854  -2.758  1.00 73.06      A    O  
ATOM    800  N   ILE   136      27.121 -24.862  -0.792  1.00 69.88      A    N  
ATOM    801  CA  ILE   136      27.764 -26.015  -1.425  1.00 68.91      A    C  
ATOM    802  CB  ILE   136      28.472 -26.926  -0.400  1.00 67.43      A    C  
ATOM    803  CG1 ILE   136      29.694 -26.201   0.170  1.00 62.29      A    C  
ATOM    804  CD1 ILE   136      29.976 -26.548   1.601  1.00 63.43      A    C  
ATOM    805  CG2 ILE   136      28.913 -28.244  -1.043  1.00 67.94      A    C  
ATOM    806  C   ILE   136      26.741 -26.759  -2.275  1.00 72.33      A    C  
ATOM    807  O   ILE   136      25.671 -27.145  -1.795  1.00 74.69      A    O  
ATOM    808  N   SER   137      27.080 -26.921  -3.548  1.00 72.39      A    N  
ATOM    809  CA  SER   137      26.134 -27.344  -4.560  1.00 76.27      A    C  
ATOM    810  CB  SER   137      26.209 -26.382  -5.745  1.00 76.90      A    C  
ATOM    811  OG  SER   137      25.221 -26.684  -6.705  1.00 82.68      A    O  
ATOM    812  C   SER   137      26.401 -28.785  -5.001  1.00 77.57      A    C  
ATOM    813  O   SER   137      25.517 -29.638  -4.931  1.00 79.63      A    O  
ATOM    814  N   ARG   138      27.628 -29.038  -5.451  1.00 76.31      A    N  
ATOM    815  CA  ARG   138      28.067 -30.361  -5.869  1.00 77.35      A    C  
ATOM    816  CB  ARG   138      28.178 -30.448  -7.393  1.00 79.55      A    C  
ATOM    817  CG  ARG   138      26.877 -30.215  -8.119  1.00 85.11      A    C  
ATOM    818  CD  ARG   138      26.947 -30.659  -9.564  1.00 89.42      A    C  
ATOM    819  NE  ARG   138      27.580 -29.666 -10.429  1.00 89.97      A    N  
ATOM    820  CZ  ARG   138      28.649 -29.898 -11.183  1.00 89.04      A    C  
ATOM    821  NH1 ARG   138      29.145 -28.930 -11.941  1.00 88.78      A    N  
ATOM    822  NH2 ARG   138      29.218 -31.098 -11.191  1.00 89.11      A    N  
ATOM    823  C   ARG   138      29.419 -30.657  -5.251  1.00 74.79      A    C  
ATOM    824  O   ARG   138      30.264 -29.765  -5.126  1.00 71.88      A    O  
ATOM    825  N   LYS   139      29.613 -31.914  -4.866  1.00 75.98      A    N  
ATOM    826  CA  LYS   139      30.874 -32.372  -4.306  1.00 74.86      A    C  
ATOM    827  CB  LYS   139      30.779 -32.469  -2.782  1.00 73.48      A    C  
ATOM    828  CG  LYS   139      32.087 -32.834  -2.115  1.00 71.58      A    C  
ATOM    829  CD  LYS   139      31.904 -32.996  -0.626  1.00 72.19      A    C  
ATOM    830  CE  LYS   139      33.155 -33.579  -0.006  1.00 72.78      A    C  
ATOM    831  NZ  LYS   139      32.987 -33.821   1.453  1.00 73.28      A    N  
ATOM    832  C   LYS   139      31.272 -33.712  -4.933  1.00 77.81      A    C  
ATOM    833  O   LYS   139      30.529 -34.697  -4.856  1.00 79.78      A    O  
ATOM    834  N   ARG   140      32.446 -33.724  -5.561  1.00 77.81      A    N  
ATOM    835  CA  ARG   140      32.943 -34.878  -6.310  1.00 80.86      A    C  
ATOM    836  CB  ARG   140      32.831 -34.614  -7.815  1.00 83.30      A    C  
ATOM    837  CG  ARG   140      31.731 -35.391  -8.524  1.00 91.05      A    C  
ATOM    838  CD  ARG   140      32.212 -36.778  -8.943  1.00 96.65      A    C  
ATOM    839  NE  ARG   140      33.416 -36.699  -9.771  1.00 98.96      A    N  
ATOM    840  CZ  ARG   140      33.469 -36.995 -11.067  1.00103.38      A    C  
ATOM    841  NH1 ARG   140      32.384 -37.411 -11.709  1.00108.22      A    N  
ATOM    842  NH2 ARG   140      34.617 -36.887 -11.723  1.00103.90      A    N  
ATOM    843  C   ARG   140      34.393 -35.183  -5.967  1.00 79.17      A    C  
ATOM    844  O   ARG   140      35.221 -34.279  -5.877  1.00 76.53      A    O  
ATOM    845  N   GLU   141      34.702 -36.461  -5.784  1.00 80.97      A    N  
ATOM    846  CA  GLU   141      36.079 -36.872  -5.552  1.00 80.09      A    C  
ATOM    847  CB  GLU   141      36.318 -37.213  -4.081  1.00 78.65      A    C  
ATOM    848  CG  GLU   141      37.779 -37.137  -3.680  1.00 78.55      A    C  
ATOM    849  CD  GLU   141      38.015 -37.247  -2.182  1.00 77.93      A    C  
ATOM    850  OE1 GLU   141      37.038 -37.196  -1.405  1.00 78.44      A    O  
ATOM    851  OE2 GLU   141      39.194 -37.383  -1.781  1.00 77.29      A    O  
ATOM    852  C   GLU   141      36.508 -38.020  -6.465  1.00 83.79      A    C  
ATOM    853  O   GLU   141      35.761 -38.959  -6.720  1.00 86.12      A    O  
ATOM    854  N   THR   142      37.732 -37.899  -6.956  1.00 63.92      A    N  
ATOM    855  CA  THR   142      38.372 -38.851  -7.848  1.00 63.74      A    C  
ATOM    856  CB  THR   142      38.654 -38.156  -9.215  1.00 66.30      A    C  
ATOM    857  OG1 THR   142      37.666 -38.567 -10.168  1.00 66.73      A    O  
ATOM    858  CG2 THR   142      40.026 -38.473  -9.776  1.00 71.31      A    C  
ATOM    859  C   THR   142      39.630 -39.330  -7.117  1.00 63.29      A    C  
ATOM    860  O   THR   142      39.944 -38.823  -6.025  1.00 64.51      A    O  
ATOM    861  N   ARG   143      40.326 -40.317  -7.675  1.00 63.14      A    N  
ATOM    862  CA  ARG   143      41.597 -40.770  -7.109  1.00 63.64      A    C  
ATOM    863  CB  ARG   143      42.221 -41.858  -7.977  1.00 64.32      A    C  
ATOM    864  CG  ARG   143      41.596 -43.245  -7.869  1.00 64.07      A    C  
ATOM    865  CD  ARG   143      42.347 -44.211  -8.831  1.00 64.06      A    C  
ATOM    866  NE  ARG   143      41.787 -45.568  -8.930  1.00 62.34      A    N  
ATOM    867  CZ  ARG   143      41.671 -46.437  -7.915  1.00 62.98      A    C  
ATOM    868  NH1 ARG   143      42.045 -46.114  -6.669  1.00 52.94      A    N  
ATOM    869  NH2 ARG   143      41.163 -47.643  -8.148  1.00 61.64      A    N  
ATOM    870  C   ARG   143      42.601 -39.619  -6.916  1.00 65.93      A    C  
ATOM    871  O   ARG   143      43.346 -39.596  -5.929  1.00 67.55      A    O  
ATOM    872  N   THR   144      42.601 -38.666  -7.848  1.00 67.27      A    N  
ATOM    873  CA  THR   144      43.565 -37.562  -7.855  1.00 71.21      A    C  
ATOM    874  CB  THR   144      44.425 -37.591  -9.130  1.00 74.46      A    C  
ATOM    875  OG1 THR   144      43.566 -37.704 -10.270  1.00 74.50      A    O  
ATOM    876  CG2 THR   144      45.397 -38.767  -9.108  1.00 73.69      A    C  
ATOM    877  C   THR   144      42.938 -36.165  -7.756  1.00 73.03      A    C  
ATOM    878  O   THR   144      43.651 -35.186  -7.568  1.00 77.46      A    O  
ATOM    879  N   ALA   145      41.617 -36.073  -7.882  1.00 71.51      A    N  
ATOM    880  CA  ALA   145      40.935 -34.776  -7.947  1.00 73.21      A    C  
ATOM    881  CB  ALA   145      40.374 -34.544  -9.350  1.00 74.63      A    C  
ATOM    882  C   ALA   145      39.825 -34.619  -6.906  1.00 70.73      A    C  
ATOM    883  O   ALA   145      39.049 -35.544  -6.667  1.00 68.81      A    O  
ATOM    884  N   ARG   146      39.765 -33.441  -6.291  1.00 72.52      A    N  
ATOM    885  CA  ARG   146      38.660 -33.067  -5.401  1.00 71.12      A    C  
ATOM    886  CB  ARG   146      39.164 -32.716  -4.001  1.00 70.21      A    C  
ATOM    887  CG  ARG   146      39.659 -33.912  -3.215  1.00 70.44      A    C  
ATOM    888  CD  ARG   146      40.246 -33.502  -1.882  1.00 72.19      A    C  
ATOM    889  NE  ARG   146      41.331 -32.537  -2.043  1.00 76.34      A    N  
ATOM    890  CZ  ARG   146      41.717 -31.677  -1.105  1.00 79.37      A    C  
ATOM    891  NH1 ARG   146      41.109 -31.647   0.073  1.00 79.76      A    N  
ATOM    892  NH2 ARG   146      42.708 -30.834  -1.349  1.00 84.02      A    N  
ATOM    893  C   ARG   146      37.908 -31.892  -6.008  1.00 72.38      A    C  
ATOM    894  O   ARG   146      38.483 -30.830  -6.257  1.00 76.52      A    O  
ATOM    895  N   GLU   147      36.620 -32.088  -6.255  1.00 70.89      A    N  
ATOM    896  CA  GLU   147      35.828 -31.092  -6.962  1.00 72.27      A    C  
ATOM    897  CB  GLU   147      35.261 -31.688  -8.251  1.00 73.83      A    C  
ATOM    898  CG  GLU   147      36.336 -32.129  -9.238  1.00 78.97      A    C  
ATOM    899  CD  GLU   147      35.844 -33.164 -10.233  1.00 82.68      A    C  
ATOM    900  OE1 GLU   147      34.708 -33.023 -10.738  1.00 85.63      A    O  
ATOM    901  OE2 GLU   147      36.602 -34.121 -10.510  1.00 83.65      A    O  
ATOM    902  C   GLU   147      34.718 -30.537  -6.081  1.00 69.40      A    C  
ATOM    903  O   GLU   147      33.914 -31.289  -5.531  1.00 67.18      A    O  
ATOM    904  N   LEU   148      34.692 -29.215  -5.949  1.00 69.74      A    N  
ATOM    905  CA  LEU   148      33.662 -28.544  -5.175  1.00 67.30      A    C  
ATOM    906  CB  LEU   148      34.243 -27.963  -3.884  1.00 66.54      A    C  
ATOM    907  CG  LEU   148      33.276 -27.429  -2.823  1.00 64.58      A    C  
ATOM    908  CD1 LEU   148      32.415 -28.550  -2.267  1.00 59.27      A    C  
ATOM    909  CD2 LEU   148      34.048 -26.727  -1.710  1.00 63.81      A    C  
ATOM    910  C   LEU   148      32.982 -27.463  -6.002  1.00 70.05      A    C  
ATOM    911  O   LEU   148      33.641 -26.629  -6.631  1.00 72.97      A    O  
ATOM    912  N   TYR   149      31.654 -27.507  -6.004  1.00 69.71      A    N  
ATOM    913  CA  TYR   149      30.842 -26.527  -6.707  1.00 71.79      A    C  
ATOM    914  CB  TYR   149      30.053 -27.187  -7.847  1.00 74.98      A    C  
ATOM    915  CG  TYR   149      30.963 -27.719  -8.929  1.00 78.32      A    C  
ATOM    916  CD1 TYR   149      31.505 -29.004  -8.844  1.00 76.82      A    C  
ATOM    917  CE1 TYR   149      32.363 -29.492  -9.827  1.00 79.06      A    C  
ATOM    918  CZ  TYR   149      32.694 -28.685 -10.903  1.00 84.35      A    C  
ATOM    919  OH  TYR   149      33.544 -29.160 -11.878  1.00 88.75      A    O  
ATOM    920  CE2 TYR   149      32.173 -27.404 -11.008  1.00 86.90      A    C  
ATOM    921  CD2 TYR   149      31.317 -26.926 -10.020  1.00 83.14      A    C  
ATOM    922  C   TYR   149      29.935 -25.839  -5.704  1.00 69.60      A    C  
ATOM    923  O   TYR   149      29.459 -26.466  -4.757  1.00 67.80      A    O  
ATOM    924  N   ALA   150      29.723 -24.543  -5.896  1.00 70.24      A    N  
ATOM    925  CA  ALA   150      28.964 -23.765  -4.941  1.00 68.76      A    C  
ATOM    926  CB  ALA   150      29.885 -23.235  -3.834  1.00 67.20      A    C  
ATOM    927  C   ALA   150      28.202 -22.625  -5.596  1.00 72.22      A    C  
ATOM    928  O   ALA   150      28.631 -22.069  -6.612  1.00 74.74      A    O  
ATOM    929  N   ASN   151      27.055 -22.303  -5.003  1.00 72.44      A    N  
ATOM    930  CA  ASN   151      26.300 -21.119  -5.350  1.00 76.20      A    C  
ATOM    931  CB  ASN   151      24.810 -21.330  -5.072  1.00 76.85      A    C  
ATOM    932  CG  ASN   151      24.247 -22.554  -5.770  1.00 79.45      A    C  
ATOM    933  OD1 ASN   151      24.580 -22.845  -6.918  1.00 79.71      A    O  
ATOM    934  ND2 ASN   151      23.380 -23.276  -5.073  1.00 80.94      A    N  
ATOM    935  C   ASN   151      26.839 -19.979  -4.507  1.00 76.24      A    C  
ATOM    936  O   ASN   151      26.602 -19.927  -3.295  1.00 75.45      A    O  
ATOM    937  N   VAL   152      27.584 -19.081  -5.143  1.00 79.41      A    N  
ATOM    938  CA  VAL   152      28.259 -17.990  -4.444  1.00 79.50      A    C  
ATOM    939  CB  VAL   152      29.614 -17.661  -5.119  1.00 82.99      A    C  
ATOM    940  CG1 VAL   152      30.288 -16.454  -4.472  1.00 83.32      A    C  
ATOM    941  CG2 VAL   152      30.527 -18.868  -5.071  1.00 80.21      A    C  
ATOM    942  C   VAL   152      27.350 -16.759  -4.391  1.00 82.04      A    C  
ATOM    943  O   VAL   152      26.821 -16.325  -5.418  1.00 85.53      A    O  
ATOM    944  N   VAL   153      27.170 -16.213  -3.190  1.00 80.24      A    N  
ATOM    945  CA  VAL   153      26.318 -15.043  -2.970  1.00 81.79      A    C  
ATOM    946  CB  VAL   153      25.723 -15.040  -1.539  1.00 78.70      A    C  
ATOM    947  CG1 VAL   153      24.841 -13.821  -1.319  1.00 78.84      A    C  
ATOM    948  CG2 VAL   153      24.932 -16.323  -1.290  1.00 76.38      A    C  
ATOM    949  C   VAL   153      27.097 -13.751  -3.232  1.00 86.30      A    C  
ATOM    950  O   VAL   153      28.098 -13.467  -2.562  1.00 86.64      A    O  
ATOM    951  N   LEU   154      26.615 -12.970  -4.199  1.00 90.89      A    N  
ATOM    952  CA  LEU   154      27.335 -11.803  -4.699  1.00 96.61      A    C  
ATOM    953  CB  LEU   154      27.674 -12.010  -6.177  1.00102.18      A    C  
ATOM    954  CG  LEU   154      29.126 -11.829  -6.622  1.00107.79      A    C  
ATOM    955  CD1 LEU   154      29.946 -13.084  -6.325  1.00104.39      A    C  
ATOM    956  CD2 LEU   154      29.195 -11.476  -8.100  1.00115.33      A    C  
ATOM    957  C   LEU   154      26.523 -10.521  -4.528  1.00 98.73      A    C  
ATOM    958  O   LEU   154      26.057 -10.203  -3.430  1.00 95.85      A    O  
ATOM    959  N   ASP   156      20.327  -9.075  -2.880  1.00154.49      A    N  
ATOM    960  CA  ASP   156      21.569  -9.607  -3.441  1.00145.75      A    C  
ATOM    961  CB  ASP   156      22.488 -10.157  -2.331  1.00135.92      A    C  
ATOM    962  CG  ASP   156      21.872 -11.329  -1.568  1.00134.46      A    C  
ATOM    963  OD1 ASP   156      21.793 -12.447  -2.127  1.00132.68      A    O  
ATOM    964  OD2 ASP   156      21.490 -11.137  -0.394  1.00135.89      A    O  
ATOM    965  C   ASP   156      21.316 -10.670  -4.512  1.00145.37      A    C  
ATOM    966  O   ASP   156      20.268 -11.319  -4.518  1.00150.14      A    O  
ATOM    967  N   ASP   157      22.283 -10.837  -5.413  1.00140.52      A    N  
ATOM    968  CA  ASP   157      22.213 -11.861  -6.458  1.00139.58      A    C  
ATOM    969  CB  ASP   157      22.328 -11.238  -7.860  1.00145.97      A    C  
ATOM    970  CG  ASP   157      23.279 -10.046  -7.904  1.00145.70      A    C  
ATOM    971  OD1 ASP   157      22.852  -8.926  -7.545  1.00151.65      A    O  
ATOM    972  OD2 ASP   157      24.446 -10.224  -8.314  1.00140.51      A    O  
ATOM    973  C   ASP   157      23.284 -12.932  -6.249  1.00128.46      A    C  
ATOM    974  O   ASP   157      24.418 -12.619  -5.887  1.00122.38      A    O  
ATOM    975  N   SER   158      22.914 -14.192  -6.468  1.00126.34      A    N  
ATOM    976  CA  SER   158      23.850 -15.305  -6.310  1.00116.90      A    C  
ATOM    977  CB  SER   158      23.222 -16.443  -5.500  1.00115.95      A    C  
ATOM    978  OG  SER   158      22.159 -17.046  -6.211  1.00124.65      A    O  
ATOM    979  C   SER   158      24.386 -15.823  -7.647  1.00115.72      A    C  
ATOM    980  O   SER   158      23.766 -15.637  -8.693  1.00122.87      A    O  
ATOM    981  N   LEU   159      25.543 -16.475  -7.587  1.00107.30      A    N  
ATOM    982  CA  LEU   159      26.252 -16.962  -8.762  1.00105.78      A    C  
ATOM    983  CB  LEU   159      27.643 -16.324  -8.812  1.00100.96      A    C  
ATOM    984  CG  LEU   159      28.366 -16.132 -10.145  1.00104.00      A    C  
ATOM    985  CD2 LEU   159      27.532 -15.316 -11.129  1.00112.58      A    C  
ATOM    987  C   LEU   159      26.341 -18.490  -8.703  1.00102.25      A    C  
ATOM    988  O   LEU   159      27.136 -19.049  -7.948  1.00 95.25      A    O  
ATOM    989  N   ASN   160      25.514 -19.156  -9.504  1.00107.82      A    N  
ATOM    990  CA  ASN   160      25.321 -20.604  -9.394  1.00107.03      A    C  
ATOM    991  CB  ASN   160      23.945 -21.006  -9.941  1.00115.89      A    C  
ATOM    992  CG  ASN   160      22.789 -20.368  -9.174  1.00119.98      A    C  
ATOM    993  OD1 ASN   160      21.844 -19.859  -9.777  1.00128.07      A    O  
ATOM    994  ND2 ASN   160      22.859 -20.395  -7.844  1.00115.38      A    N  
ATOM    995  C   ASN   160      26.406 -21.460 -10.044  1.00103.95      A    C  
ATOM    996  O   ASN   160      26.986 -21.079 -11.064  1.00105.22      A    O  
ATOM    997  N   ASP   161      26.665 -22.614  -9.424  1.00100.72      A    N  
ATOM    998  CA  ASP   161      27.538 -23.670  -9.958  1.00 99.67      A    C  
ATOM    999  CB  ASP   161      26.903 -24.310 -11.206  1.00108.04      A    C  
ATOM   1000  CG  ASP   161      27.456 -25.693 -11.506  1.00109.23      A    C  
ATOM   1001  OD1 ASP   161      27.756 -26.442 -10.547  1.00105.93      A    O  
ATOM   1002  OD2 ASP   161      27.577 -26.033 -12.705  1.00114.11      A    O  
ATOM   1003  C   ASP   161      28.976 -23.220 -10.238  1.00 94.88      A    C  
ATOM   1004  O   ASP   161      29.499 -23.410 -11.340  1.00 97.52      A    O  
ATOM   1005  N   CYS   162      29.608 -22.634  -9.226  1.00 88.51      A    N  
ATOM   1006  CA  CYS   162      30.981 -22.149  -9.332  1.00 85.07      A    C  
ATOM   1007  CB  CYS   162      31.178 -20.924  -8.431  1.00 81.92      A    C  
ATOM   1008  SG  CYS   162      30.225 -19.464  -8.900  1.00 88.32      A    S  
ATOM   1009  C   CYS   162      31.993 -23.225  -8.942  1.00 81.26      A    C  
ATOM   1010  O   CYS   162      31.833 -23.883  -7.913  1.00 79.50      A    O  
ATOM   1011  N   ARG   163      33.041 -23.388  -9.748  1.00 80.96      A    N  
ATOM   1012  CA  ARG   163      34.135 -24.297  -9.403  1.00 78.45      A    C  
ATOM   1013  CB  ARG   163      34.936 -24.699 -10.649  1.00 82.87      A    C  
ATOM   1014  CG  ARG   163      36.139 -25.619 -10.389  1.00 83.57      A    C  
ATOM   1015  CD  ARG   163      35.735 -26.950  -9.752  1.00 86.25      A    C  
ATOM   1016  NE  ARG   163      36.895 -27.771  -9.402  1.00 86.46      A    N  
ATOM   1017  CZ  ARG   163      37.383 -28.758 -10.151  1.00 91.21      A    C  
ATOM   1018  NH1 ARG   163      36.813 -29.077 -11.312  1.00 95.37      A    N  
ATOM   1019  NH2 ARG   163      38.444 -29.439  -9.732  1.00 90.22      A    N  
ATOM   1020  C   ARG   163      35.044 -23.655  -8.359  1.00 73.09      A    C  
ATOM   1021  O   ARG   163      35.798 -22.727  -8.665  1.00 73.28      A    O  
ATOM   1022  N   ILE   164      34.963 -24.155  -7.129  1.00 68.86      A    N  
ATOM   1023  CA  ILE   164      35.743 -23.620  -6.011  1.00 63.46      A    C  
ATOM   1024  CB  ILE   164      34.998 -23.798  -4.656  1.00 61.55      A    C  
ATOM   1025  CG1 ILE   164      33.573 -23.218  -4.724  1.00 60.30      A    C  
ATOM   1026  CD1 ILE   164      33.499 -21.745  -5.097  1.00 60.78      A    C  
ATOM   1027  CG2 ILE   164      35.823 -23.220  -3.477  1.00 57.88      A    C  
ATOM   1028  C   ILE   164      37.130 -24.257  -5.942  1.00 63.17      A    C  
ATOM   1029  O   ILE   164      37.258 -25.473  -5.803  1.00 63.90      A    O  
ATOM   1030  N   ILE   165      38.160 -23.419  -6.033  1.00 63.23      A    N  
ATOM   1031  CA  ILE   165      39.553 -23.873  -6.071  1.00 64.54      A    C  
ATOM   1032  CB  ILE   165      40.486 -22.816  -6.735  1.00 65.87      A    C  
ATOM   1033  CG1 ILE   165      40.033 -22.474  -8.161  1.00 68.67      A    C  
ATOM   1034  CD1 ILE   165      39.820 -23.676  -9.066  1.00 70.55      A    C  
ATOM   1035  CG2 ILE   165      41.943 -23.279  -6.718  1.00 68.94      A    C  
ATOM   1036  C   ILE   165      40.090 -24.196  -4.681  1.00 63.36      A    C  
ATOM   1037  O   ILE   165      40.739 -25.220  -4.487  1.00 65.13      A    O  
ATOM   1038  N   PHE   166      39.808 -23.316  -3.724  1.00 60.96      A    N  
ATOM   1039  CA  PHE   166      40.423 -23.363  -2.391  1.00 61.51      A    C  
ATOM   1040  CB  PHE   166      40.778 -21.947  -1.921  1.00 59.92      A    C  
ATOM   1041  CG  PHE   166      41.515 -21.179  -2.976  1.00 63.59      A    C  
ATOM   1042  CD1 PHE   166      40.831 -20.338  -3.851  1.00 63.67      A    C  
ATOM   1043  CE1 PHE   166      41.500 -19.672  -4.874  1.00 65.74      A    C  
ATOM   1044  CZ  PHE   166      42.863 -19.866  -5.048  1.00 69.84      A    C  
ATOM   1045  CE2 PHE   166      43.555 -20.726  -4.199  1.00 71.18      A    C  
ATOM   1046  CD2 PHE   166      42.875 -21.391  -3.179  1.00 67.07      A    C  
ATOM   1047  C   PHE   166      39.555 -24.164  -1.448  1.00 60.34      A    C  
ATOM   1048  O   PHE   166      38.857 -23.654  -0.577  1.00 59.81      A    O  
ATOM   1049  N   VAL   167      39.639 -25.461  -1.683  1.00 61.90      A    N  
ATOM   1050  CA  VAL   167      38.760 -26.465  -1.138  1.00 62.51      A    C  
ATOM   1051  CB  VAL   167      38.817 -27.678  -2.085  1.00 66.35      A    C  
ATOM   1052  CG1 VAL   167      38.694 -29.004  -1.355  1.00 71.14      A    C  
ATOM   1053  CG2 VAL   167      37.789 -27.517  -3.209  1.00 67.21      A    C  
ATOM   1054  C   VAL   167      39.147 -26.822   0.296  1.00 62.61      A    C  
ATOM   1055  O   VAL   167      38.380 -27.472   1.015  1.00 61.76      A    O  
ATOM   1056  N   ASP   168      40.332 -26.369   0.706  1.00 63.36      A    N  
ATOM   1057  CA  ASP   168      40.879 -26.668   2.024  1.00 65.08      A    C  
ATOM   1058  CB  ASP   168      42.323 -27.177   1.907  1.00 68.67      A    C  
ATOM   1059  CG  ASP   168      42.404 -28.597   1.360  1.00 73.05      A    C  
ATOM   1060  OD1 ASP   168      41.677 -29.482   1.868  1.00 73.62      A    O  
ATOM   1061  OD2 ASP   168      43.199 -28.833   0.422  1.00 74.94      A    O  
ATOM   1062  C   ASP   168      40.810 -25.459   2.946  1.00 63.54      A    C  
ATOM   1063  O   ASP   168      41.340 -25.489   4.062  1.00 66.02      A    O  
ATOM   1064  N   GLU   169      40.141 -24.405   2.482  1.00 60.46      A    N  
ATOM   1065  CA  GLU   169      40.110 -23.134   3.207  1.00 59.46      A    C  
ATOM   1066  CB  GLU   169      40.988 -22.107   2.487  1.00 60.15      A    C  
ATOM   1067  CG  GLU   169      42.468 -22.435   2.516  1.00 60.33      A    C  
ATOM   1068  CD  GLU   169      43.285 -21.528   1.627  1.00 63.26      A    C  
ATOM   1069  OE1 GLU   169      43.919 -20.597   2.166  1.00 63.21      A    O  
ATOM   1070  OE2 GLU   169      43.296 -21.742   0.389  1.00 63.55      A    O  
ATOM   1071  C   GLU   169      38.691 -22.593   3.412  1.00 57.50      A    C  
ATOM   1072  O   GLU   169      38.475 -21.378   3.494  1.00 56.14      A    O  
ATOM   1073  N   VAL   170      37.735 -23.511   3.511  1.00 57.46      A    N  
ATOM   1074  CA  VAL   170      36.325 -23.175   3.636  1.00 56.44      A    C  
ATOM   1075  CB  VAL   170      35.449 -24.277   2.987  1.00 56.48      A    C  
ATOM   1076  CG1 VAL   170      33.980 -24.001   3.212  1.00 55.51      A    C  
ATOM   1077  CG2 VAL   170      35.751 -24.397   1.489  1.00 54.79      A    C  
ATOM   1078  C   VAL   170      35.952 -22.981   5.112  1.00 59.01      A    C  
ATOM   1079  O   VAL   170      36.236 -23.839   5.957  1.00 61.69      A    O  
ATOM   1080  N   PHE   171      35.312 -21.855   5.412  1.00 58.99      A    N  
ATOM   1081  CA  PHE   171      34.969 -21.499   6.783  1.00 61.65      A    C  
ATOM   1082  CB  PHE   171      35.233 -20.014   7.044  1.00 60.78      A    C  
ATOM   1083  CG  PHE   171      36.670 -19.678   7.281  1.00 60.82      A    C  
ATOM   1084  CD1 PHE   171      37.210 -19.739   8.562  1.00 60.71      A    C  
ATOM   1085  CE1 PHE   171      38.544 -19.413   8.789  1.00 60.33      A    C  
ATOM   1086  CZ  PHE   171      39.352 -19.009   7.736  1.00 61.60      A    C  
ATOM   1087  CE2 PHE   171      38.825 -18.946   6.441  1.00 61.24      A    C  
ATOM   1088  CD2 PHE   171      37.487 -19.275   6.224  1.00 60.28      A    C  
ATOM   1089  C   PHE   171      33.524 -21.794   7.147  1.00 64.12      A    C  
ATOM   1090  O   PHE   171      32.615 -21.693   6.314  1.00 64.50      A    O  
ATOM   1091  N   LYS   172      33.339 -22.152   8.413  1.00 77.04      A    N  
ATOM   1092  CA  LYS   172      32.037 -22.227   9.050  1.00 79.53      A    C  
ATOM   1093  CB  LYS   172      32.164 -23.050  10.337  1.00 88.91      A    C  
ATOM   1094  CG  LYS   172      30.940 -23.105  11.231  1.00 93.59      A    C  
ATOM   1095  CD  LYS   172      31.219 -24.011  12.426  1.00105.42      A    C  
ATOM   1096  CE  LYS   172      30.081 -24.008  13.435  1.00111.71      A    C  
ATOM   1097  NZ  LYS   172      30.086 -22.782  14.282  1.00110.49      A    N  
ATOM   1098  C   LYS   172      31.600 -20.804   9.366  1.00 77.33      A    C  
ATOM   1099  O   LYS   172      32.382 -20.015   9.907  1.00 79.81      A    O  
ATOM   1100  N   ILE   173      30.364 -20.468   9.018  1.00 76.02      A    N  
ATOM   1101  CA  ILE   173      29.820 -19.163   9.362  1.00 76.65      A    C  
ATOM   1102  CB  ILE   173      28.692 -18.719   8.397  1.00 76.78      A    C  
ATOM   1103  CG1 ILE   173      29.263 -18.449   7.002  1.00 70.61      A    C  
ATOM   1104  CD1 ILE   173      28.220 -18.403   5.902  1.00 71.51      A    C  
ATOM   1105  CG2 ILE   173      27.983 -17.471   8.924  1.00 81.49      A    C  
ATOM   1106  C   ILE   173      29.330 -19.219  10.805  1.00 83.32      A    C  
ATOM   1107  O   ILE   173      28.477 -20.038  11.153  1.00 87.13      A    O  
ATOM   1108  N   GLU   174      29.896 -18.353  11.639  1.00 86.51      A    N  
ATOM   1109  CA  GLU   174      29.536 -18.283  13.050  1.00 93.69      A    C  
ATOM   1110  CB  GLU   174      30.549 -17.437  13.835  1.00 97.60      A    C  
ATOM   1111  CG  GLU   174      32.024 -17.729  13.538  1.00 98.58      A    C  
ATOM   1112  CD  GLU   174      32.480 -19.103  14.005  1.00103.15      A    C  
ATOM   1113  OE1 GLU   174      32.267 -19.434  15.190  1.00110.24      A    O  
ATOM   1114  OE2 GLU   174      33.069 -19.847  13.186  1.00102.50      A    O  
ATOM   1115  C   GLU   174      28.128 -17.711  13.215  1.00 97.65      A    C  
ATOM   1116  O   GLU   174      27.849 -16.589  12.779  1.00 98.79      A    O  
ATOM   1117  N   ARG   175      27.250 -18.506  13.826  1.00102.48      A    N  
ATOM   1118  CA  ARG   175      25.891 -18.080  14.174  1.00109.50      A    C  
ATOM   1119  CB  ARG   175      24.881 -19.185  13.842  1.00114.39      A    C  
ATOM   1120  CG  ARG   175      24.124 -18.977  12.535  1.00116.97      A    C  
ATOM   1121  CD  ARG   175      24.920 -19.414  11.313  1.00109.78      A    C  
ATOM   1122  NE  ARG   175      24.355 -18.861  10.080  1.00112.40      A    N  
ATOM   1123  CZ  ARG   175      24.629 -19.298   8.851  1.00109.33      A    C  
ATOM   1124  NH1 ARG   175      25.462 -20.318   8.661  1.00103.11      A    N  
ATOM   1125  NH2 ARG   175      24.058 -18.714   7.803  1.00112.61      A    N  
ATOM   1126  C   ARG   175      25.781 -17.680  15.653  1.00114.90      A    C  
ATOM   1127  O   ARG   175      26.443 -18.279  16.504  1.00115.25      A    O  
ATOM   1128  N   PRO   176      24.947 -16.661  15.961  1.00121.13      A    N  
ATOM   1129  CA  PRO   176      24.769 -16.177  17.338  1.00127.15      A    C  
ATOM   1130  CB  PRO   176      23.739 -15.054  17.186  1.00135.40      A    C  
ATOM   1131  CG  PRO   176      23.825 -14.640  15.761  1.00132.78      A    C  
ATOM   1132  CD  PRO   176      24.125 -15.891  15.009  1.00124.80      A    C  
ATOM   1133  C   PRO   176      24.226 -17.248  18.281  1.00131.43      A    C  
ATOM   1134  O   PRO   176      24.738 -17.408  19.389  1.00133.23      A    O  
END
