
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  133 ( 2097),  selected  133 , name 1wgs_A
# Molecule2: number of CA atoms  135 ( 1110),  selected  135 , name T0429.pdb
# PARAMETERS: 1wgs_A.T0429.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      E      22           -
LGA    S     2_A      T      23           -
LGA    S     3_A      E      24           -
LGA    G     4_A      L      25           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    E     8_A      -       -           -
LGA    P     9_A      -       -           -
LGA    E    10_A      -       -           -
LGA    V    11_A      -       -           -
LGA    T    12_A      L      27          1.077
LGA    V    13_A      Y      28          1.119
LGA    E    14_A      K      29          1.573
LGA    I    15_A      V      30          1.351
LGA    G    16_A      N      31          0.856
LGA    E    17_A      E      32          1.100
LGA    T    18_A      Y      33          1.013
LGA    Y    19_A      V      34          0.702
LGA    L    20_A      D      35          0.545
LGA    C    21_A      A      36          0.441
LGA    R    22_A      R      37          0.435
LGA    R    23_A      D      38          1.495
LGA    -       -      T      39           -
LGA    P    24_A      N      40          2.409
LGA    D    25_A      M      41          2.229
LGA    S    26_A      G      42          2.964
LGA    T    27_A      A      43          1.251
LGA    W    28_A      W      44          0.573
LGA    H    29_A      F      45          0.628
LGA    S    30_A      E      46          1.178
LGA    A    31_A      A      47          1.097
LGA    E    32_A      Q      48          0.723
LGA    V    33_A      V      49          0.404
LGA    I    34_A      V      50          0.664
LGA    Q    35_A      R      51          1.399
LGA    S    36_A      V      52          0.699
LGA    R    37_A      T      53          0.749
LGA    V    38_A      R      54          0.580
LGA    N    39_A      E      73           -
LGA    D    40_A      -       -           -
LGA    Q    41_A      -       -           -
LGA    E    42_A      -       -           -
LGA    G    43_A      -       -           -
LGA    R    44_A      D      74          3.188
LGA    E    45_A      V      75          1.544
LGA    E    46_A      I      76          0.873
LGA    F    47_A      Y      77          1.133
LGA    Y    48_A      H      78          0.742
LGA    V    49_A      V      79          0.586
LGA    H    50_A      K      80          0.451
LGA    Y    51_A      Y      81          0.896
LGA    V    52_A      D      82          1.512
LGA    G    53_A      D      83          1.420
LGA    F    54_A      Y      84          1.678
LGA    N    55_A      P      85          3.106
LGA    R    56_A      E      86          3.547
LGA    R    57_A      N      87          5.076
LGA    L    58_A      G      88          1.929
LGA    D    59_A      V      89          0.696
LGA    E    60_A      V      90          1.550
LGA    W    61_A      Q      91          1.432
LGA    V    62_A      M      92          0.621
LGA    D    63_A      N      93          1.313
LGA    K    64_A      S      94          1.230
LGA    N    65_A      R      95          0.238
LGA    R    66_A      D      96          0.458
LGA    L    67_A      V      97          0.549
LGA    A    68_A      R      98          1.606
LGA    L    69_A      A      99          4.480
LGA    T    70_A      R     100           #
LGA    K    71_A      A     101           #
LGA    T    72_A      R     102           -
LGA    V    73_A      T     103           -
LGA    -       -      I     104           -
LGA    -       -      I     105           -
LGA    -       -      K     106           -
LGA    -       -      W     107           -
LGA    -       -      Q     108           -
LGA    -       -      D     109           -
LGA    -       -      L     110           -
LGA    -       -      E     111           -
LGA    -       -      V     112           -
LGA    -       -      G     113           -
LGA    -       -      Q     114           -
LGA    K    74_A      V     115           #
LGA    D    75_A      -       -           -
LGA    A    76_A      V     116          1.697
LGA    V    77_A      M     117          5.004
LGA    -       -      L     118           -
LGA    -       -      N     119           -
LGA    -       -      Y     120           -
LGA    -       -      N     121           -
LGA    -       -      P     122           -
LGA    -       -      D     123           -
LGA    -       -      N     124           -
LGA    -       -      P     125           -
LGA    -       -      K     126           -
LGA    -       -      E     127           -
LGA    -       -      R     128           -
LGA    -       -      G     129           -
LGA    -       -      F     130           -
LGA    -       -      W     131           -
LGA    -       -      Y     132           -
LGA    -       -      D     133           -
LGA    -       -      A     134           -
LGA    -       -      E     135           -
LGA    -       -      I     136           -
LGA    -       -      S     137           -
LGA    -       -      R     138           -
LGA    -       -      K     139           -
LGA    -       -      R     140           -
LGA    -       -      E     141           -
LGA    -       -      T     142           -
LGA    -       -      R     143           -
LGA    -       -      T     144           -
LGA    -       -      A     145           -
LGA    -       -      R     146           -
LGA    -       -      E     147           -
LGA    -       -      L     148           -
LGA    -       -      Y     149           -
LGA    -       -      A     150           -
LGA    -       -      N     151           -
LGA    -       -      V     152           -
LGA    -       -      V     153           -
LGA    -       -      L     154           -
LGA    -       -      D     156           -
LGA    -       -      D     157           -
LGA    -       -      S     158           -
LGA    -       -      L     159           -
LGA    -       -      N     160           -
LGA    -       -      D     161           -
LGA    -       -      C     162           -
LGA    -       -      R     163           -
LGA    -       -      I     164           -
LGA    -       -      I     165           -
LGA    -       -      F     166           -
LGA    -       -      V     167           -
LGA    -       -      D     168           -
LGA    -       -      E     169           -
LGA    Q    78_A      V     170          4.272
LGA    K    79_A      F     171          3.851
LGA    N    80_A      K     172          3.714
LGA    -       -      I     173           -
LGA    S    81_A      E     174           #
LGA    E    82_A      R     175           -
LGA    K    83_A      P     176           -
LGA    Y    84_A      -       -           -
LGA    L    85_A      -       -           -
LGA    S    86_A      -       -           -
LGA    E    87_A      -       -           -
LGA    L    88_A      -       -           -
LGA    A    89_A      -       -           -
LGA    E    90_A      -       -           -
LGA    Q    91_A      -       -           -
LGA    P    92_A      -       -           -
LGA    E    93_A      -       -           -
LGA    R    94_A      -       -           -
LGA    K    95_A      -       -           -
LGA    I    96_A      -       -           -
LGA    T    97_A      -       -           -
LGA    R    98_A      -       -           -
LGA    N    99_A      -       -           -
LGA    Q   100_A      -       -           -
LGA    K   101_A      -       -           -
LGA    R   102_A      -       -           -
LGA    K   103_A      -       -           -
LGA    H   104_A      -       -           -
LGA    D   105_A      -       -           -
LGA    E   106_A      -       -           -
LGA    I   107_A      -       -           -
LGA    N   108_A      -       -           -
LGA    H   109_A      -       -           -
LGA    V   110_A      -       -           -
LGA    Q   111_A      -       -           -
LGA    K   112_A      -       -           -
LGA    T   113_A      -       -           -
LGA    Y   114_A      -       -           -
LGA    A   115_A      -       -           -
LGA    E   116_A      -       -           -
LGA    M   117_A      -       -           -
LGA    D   118_A      -       -           -
LGA    P   119_A      -       -           -
LGA    T   120_A      -       -           -
LGA    T   121_A      -       -           -
LGA    A   122_A      -       -           -
LGA    A   123_A      -       -           -
LGA    L   124_A      -       -           -
LGA    E   125_A      -       -           -
LGA    K   126_A      -       -           -
LGA    E   127_A      -       -           -
LGA    S   128_A      -       -           -
LGA    G   129_A      -       -           -
LGA    P   130_A      -       -           -
LGA    S   131_A      -       -           -
LGA    S   132_A      -       -           -
LGA    G   133_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  133  135    5.0     58    1.96    12.07     37.464     2.809

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.371322 * X  +   0.736873 * Y  +   0.564923 * Z  +  47.185448
  Y_new =  -0.877657 * X  +   0.477127 * Y  +  -0.045473 * Z  + -57.739086
  Z_new =  -0.303048 * X  +  -0.478923 * Y  +   0.823890 * Z  +  -5.730598 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.526552    2.615040  [ DEG:   -30.1692    149.8308 ]
  Theta =   0.307890    2.833703  [ DEG:    17.6408    162.3592 ]
  Phi   =  -1.170550    1.971042  [ DEG:   -67.0676    112.9324 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1wgs_A                                        
REMARK     2: T0429.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1wgs_A.T0429.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  133  135   5.0   58   1.96   12.07  37.464
REMARK  ---------------------------------------------------------- 
MOLECULE 1wgs_A
HEADER    TRANSFERASE                             28-MAY-04   1WGS              
TITLE     SOLUTION STRUCTURE OF THE TUDOR DOMAIN FROM MOUSE                     
TITLE    2 HYPOTHETICAL PROTEIN HOMOLOGOUS TO HISTONE                           
TITLE    3 ACETYLTRANSFERASE                                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MYST HISTONE ACETYLTRANSFERASE 1;                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: TUDOR DOMAIN;                                              
COMPND   5 SYNONYM: HYPOTHETICAL PROTEIN 5830450F21RIK;                         
COMPND   6 EC: 2.3.1.48;                                                        
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   3 ORGANISM_COMMON: MOUSE;                                              
SOURCE   4 GENE: RIKEN CDNA 5830450F21;                                         
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P031110-09;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    TUDOR DOMAIN, MYST FAMILY, HISTONE ACETYLTRANFERASE,                  
KEYWDS   2 STRUCTURAL GENOMICS, RIKEN STRUCTURAL GENOMICS/PROTEOMICS            
KEYWDS   3 INITIATIVE, RSGI                                                     
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.LI,K.SAITO,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA,RIKEN              
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   28-NOV-04 1WGS    0                                                
JRNL        AUTH   H.LI,K.SAITO,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA           
JRNL        TITL   SOLUTION STRUCTURE OF THE TUDOR DOMAIN FROM MOUSE            
JRNL        TITL 2 HYPOTHETICAL PROTEIN HOMOLOGOUS TO HISTONE                   
JRNL        TITL 3 ACETYLTRANSFERASE                                            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1WGS A    8   127  UNP    Q9D1P2   MYST1_MOUSE     50    169             
SEQRES   1 A  133  GLY SER SER GLY SER SER GLY GLU PRO GLU VAL THR VAL          
SEQRES   2 A  133  GLU ILE GLY GLU THR TYR LEU CYS ARG ARG PRO ASP SER          
SEQRES   3 A  133  THR TRP HIS SER ALA GLU VAL ILE GLN SER ARG VAL ASN          
SEQRES   4 A  133  ASP GLN GLU GLY ARG GLU GLU PHE TYR VAL HIS TYR VAL          
SEQRES   5 A  133  GLY PHE ASN ARG ARG LEU ASP GLU TRP VAL ASP LYS ASN          
SEQRES   6 A  133  ARG LEU ALA LEU THR LYS THR VAL LYS ASP ALA VAL GLN          
SEQRES   7 A  133  LYS ASN SER GLU LYS TYR LEU SER GLU LEU ALA GLU GLN          
SEQRES   8 A  133  PRO GLU ARG LYS ILE THR ARG ASN GLN LYS ARG LYS HIS          
SEQRES   9 A  133  ASP GLU ILE ASN HIS VAL GLN LYS THR TYR ALA GLU MET          
SEQRES  10 A  133  ASP PRO THR THR ALA ALA LEU GLU LYS GLU SER GLY PRO          
SEQRES  11 A  133  SER SER GLY                                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      10.264 -33.489  12.615  1.00  0.00           N  
ATOM      2  CA  GLY A   1       9.185 -32.519  12.676  1.00  0.00           C  
ATOM      3  C   GLY A   1       9.727 -31.090  12.612  1.00  0.00           C  
ATOM      4  O   GLY A   1      10.367 -30.709  11.634  1.00  0.00           O  
ATOM      5  HA2 GLY A   1       8.492 -32.687  11.851  1.00  0.00           H  
ATOM      6  HA3 GLY A   1       8.619 -32.657  13.598  1.00  0.00           H  
ATOM      7  H1  GLY A   1      11.185 -33.098  12.625  1.00  0.00           H  
ATOM      8  N   SER A   2       9.450 -30.338  13.667  1.00  0.00           N  
ATOM      9  CA  SER A   2       9.902 -28.960  13.744  1.00  0.00           C  
ATOM     10  C   SER A   2       9.316 -28.152  12.583  1.00  0.00           C  
ATOM     11  O   SER A   2       9.772 -28.271  11.447  1.00  0.00           O  
ATOM     12  CB  SER A   2      11.430 -28.879  13.729  1.00  0.00           C  
ATOM     13  OG  SER A   2      11.982 -28.973  15.038  1.00  0.00           O  
ATOM     14  H   SER A   2       8.928 -30.657  14.459  1.00  0.00           H  
ATOM     15  HA  SER A   2       9.528 -28.586  14.697  1.00  0.00           H  
ATOM     16  HB2 SER A   2      11.829 -29.681  13.109  1.00  0.00           H  
ATOM     17  HB3 SER A   2      11.739 -27.939  13.272  1.00  0.00           H  
ATOM     18  HG  SER A   2      12.981 -28.960  14.990  1.00  0.00           H  
ATOM     19  N   SER A   3       8.315 -27.349  12.910  1.00  0.00           N  
ATOM     20  CA  SER A   3       7.662 -26.521  11.909  1.00  0.00           C  
ATOM     21  C   SER A   3       7.463 -25.104  12.451  1.00  0.00           C  
ATOM     22  O   SER A   3       7.960 -24.140  11.871  1.00  0.00           O  
ATOM     23  CB  SER A   3       6.320 -27.123  11.488  1.00  0.00           C  
ATOM     24  OG  SER A   3       6.173 -27.162  10.072  1.00  0.00           O  
ATOM     25  H   SER A   3       7.950 -27.258  13.836  1.00  0.00           H  
ATOM     26  HA  SER A   3       8.340 -26.513  11.055  1.00  0.00           H  
ATOM     27  HB2 SER A   3       6.233 -28.133  11.890  1.00  0.00           H  
ATOM     28  HB3 SER A   3       5.508 -26.537  11.921  1.00  0.00           H  
ATOM     29  HG  SER A   3       7.069 -27.248   9.637  1.00  0.00           H  
ATOM     30  N   GLY A   4       6.734 -25.024  13.554  1.00  0.00           N  
ATOM     31  CA  GLY A   4       6.463 -23.740  14.180  1.00  0.00           C  
ATOM     32  C   GLY A   4       7.433 -23.478  15.334  1.00  0.00           C  
ATOM     33  O   GLY A   4       7.500 -24.258  16.283  1.00  0.00           O  
ATOM     34  H   GLY A   4       6.334 -25.813  14.019  1.00  0.00           H  
ATOM     35  HA2 GLY A   4       6.550 -22.946  13.439  1.00  0.00           H  
ATOM     36  HA3 GLY A   4       5.439 -23.722  14.549  1.00  0.00           H  
ATOM     37  N   SER A   5       8.159 -22.376  15.215  1.00  0.00           N  
ATOM     38  CA  SER A   5       9.122 -22.001  16.237  1.00  0.00           C  
ATOM     39  C   SER A   5       8.422 -21.225  17.356  1.00  0.00           C  
ATOM     40  O   SER A   5       7.610 -20.341  17.088  1.00  0.00           O  
ATOM     41  CB  SER A   5      10.259 -21.167  15.643  1.00  0.00           C  
ATOM     42  OG  SER A   5      11.229 -21.976  14.986  1.00  0.00           O  
ATOM     43  H   SER A   5       8.098 -21.747  14.441  1.00  0.00           H  
ATOM     44  HA  SER A   5       9.522 -22.941  16.616  1.00  0.00           H  
ATOM     45  HB2 SER A   5       9.848 -20.447  14.935  1.00  0.00           H  
ATOM     46  HB3 SER A   5      10.740 -20.594  16.436  1.00  0.00           H  
ATOM     47  HG  SER A   5      10.882 -22.909  14.883  1.00  0.00           H  
ATOM     48  N   SER A   6       8.764 -21.584  18.584  1.00  0.00           N  
ATOM     49  CA  SER A   6       8.178 -20.932  19.744  1.00  0.00           C  
ATOM     50  C   SER A   6       9.265 -20.213  20.544  1.00  0.00           C  
ATOM     51  O   SER A   6       9.760 -20.740  21.540  1.00  0.00           O  
ATOM     52  CB  SER A   6       7.446 -21.941  20.631  1.00  0.00           C  
ATOM     53  OG  SER A   6       6.125 -22.203  20.165  1.00  0.00           O  
ATOM     54  H   SER A   6       9.426 -22.304  18.793  1.00  0.00           H  
ATOM     55  HA  SER A   6       7.462 -20.217  19.342  1.00  0.00           H  
ATOM     56  HB2 SER A   6       8.010 -22.873  20.662  1.00  0.00           H  
ATOM     57  HB3 SER A   6       7.402 -21.562  21.651  1.00  0.00           H  
ATOM     58  HG  SER A   6       5.502 -22.302  20.941  1.00  0.00           H  
ATOM     59  N   GLY A   7       9.606 -19.021  20.079  1.00  0.00           N  
ATOM     60  CA  GLY A   7      10.627 -18.223  20.739  1.00  0.00           C  
ATOM     61  C   GLY A   7      11.982 -18.387  20.049  1.00  0.00           C  
ATOM     62  O   GLY A   7      12.265 -19.435  19.471  1.00  0.00           O  
ATOM     63  H   GLY A   7       9.199 -18.599  19.269  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      10.334 -17.173  20.730  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      10.707 -18.523  21.784  1.00  0.00           H  
ATOM     66  N   GLU A   8      12.784 -17.336  20.134  1.00  0.00           N  
ATOM     67  CA  GLU A   8      14.104 -17.350  19.525  1.00  0.00           C  
ATOM     68  C   GLU A   8      15.034 -16.377  20.252  1.00  0.00           C  
ATOM     69  O   GLU A   8      14.581 -15.379  20.810  1.00  0.00           O  
ATOM     70  CB  GLU A   8      14.023 -17.021  18.033  1.00  0.00           C  
ATOM     71  CG  GLU A   8      13.459 -15.616  17.812  1.00  0.00           C  
ATOM     72  CD  GLU A   8      12.590 -15.568  16.553  1.00  0.00           C  
ATOM     73  OE1 GLU A   8      13.183 -15.571  15.453  1.00  0.00           O  
ATOM     74  OE2 GLU A   8      11.351 -15.527  16.720  1.00  0.00           O  
ATOM     75  H   GLU A   8      12.547 -16.488  20.607  1.00  0.00           H  
ATOM     76  HA  GLU A   8      14.468 -18.371  19.647  1.00  0.00           H  
ATOM     77  HB2 GLU A   8      15.015 -17.093  17.587  1.00  0.00           H  
ATOM     78  HB3 GLU A   8      13.392 -17.754  17.529  1.00  0.00           H  
ATOM     79  HG2 GLU A   8      12.869 -15.317  18.677  1.00  0.00           H  
ATOM     80  HG3 GLU A   8      14.278 -14.903  17.721  1.00  0.00           H  
ATOM     81  N   PRO A   9      16.352 -16.710  20.220  1.00  0.00           N  
ATOM     82  CA  PRO A   9      17.351 -15.877  20.869  1.00  0.00           C  
ATOM     83  C   PRO A   9      17.616 -14.607  20.057  1.00  0.00           C  
ATOM     84  O   PRO A   9      17.337 -14.562  18.859  1.00  0.00           O  
ATOM     85  CB  PRO A   9      18.577 -16.764  21.002  1.00  0.00           C  
ATOM     86  CG  PRO A   9      18.379 -17.901  20.012  1.00  0.00           C  
ATOM     87  CD  PRO A   9      16.925 -17.884  19.568  1.00  0.00           C  
ATOM     88  HA  PRO A   9      17.019 -15.567  21.759  1.00  0.00           H  
ATOM     89  HB2 PRO A   9      19.488 -16.208  20.780  1.00  0.00           H  
ATOM     90  HB3 PRO A   9      18.676 -17.144  22.018  1.00  0.00           H  
ATOM     91  HG2 PRO A   9      19.041 -17.780  19.154  1.00  0.00           H  
ATOM     92  HG3 PRO A   9      18.626 -18.856  20.474  1.00  0.00           H  
ATOM     93  HD2 PRO A   9      16.843 -17.814  18.483  1.00  0.00           H  
ATOM     94  HD3 PRO A   9      16.409 -18.796  19.869  1.00  0.00           H  
ATOM     95  N   GLU A  10      18.151 -13.607  20.741  1.00  0.00           N  
ATOM     96  CA  GLU A  10      18.457 -12.340  20.099  1.00  0.00           C  
ATOM     97  C   GLU A  10      19.972 -12.138  20.018  1.00  0.00           C  
ATOM     98  O   GLU A  10      20.662 -12.184  21.035  1.00  0.00           O  
ATOM     99  CB  GLU A  10      17.787 -11.177  20.834  1.00  0.00           C  
ATOM    100  CG  GLU A  10      18.511 -10.866  22.145  1.00  0.00           C  
ATOM    101  CD  GLU A  10      17.749  -9.817  22.957  1.00  0.00           C  
ATOM    102  OE1 GLU A  10      16.504  -9.920  22.989  1.00  0.00           O  
ATOM    103  OE2 GLU A  10      18.429  -8.937  23.527  1.00  0.00           O  
ATOM    104  H   GLU A  10      18.374 -13.652  21.715  1.00  0.00           H  
ATOM    105  HA  GLU A  10      18.040 -12.416  19.095  1.00  0.00           H  
ATOM    106  HB2 GLU A  10      17.786 -10.292  20.196  1.00  0.00           H  
ATOM    107  HB3 GLU A  10      16.746 -11.423  21.039  1.00  0.00           H  
ATOM    108  HG2 GLU A  10      18.617 -11.780  22.731  1.00  0.00           H  
ATOM    109  HG3 GLU A  10      19.518 -10.506  21.933  1.00  0.00           H  
ATOM    110  N   VAL A  11      20.444 -11.919  18.799  1.00  0.00           N  
ATOM    111  CA  VAL A  11      21.864 -11.710  18.574  1.00  0.00           C  
ATOM    112  C   VAL A  11      22.317 -10.457  19.326  1.00  0.00           C  
ATOM    113  O   VAL A  11      21.498  -9.753  19.917  1.00  0.00           O  
ATOM    114  CB  VAL A  11      22.149 -11.640  17.072  1.00  0.00           C  
ATOM    115  CG1 VAL A  11      21.746 -10.280  16.499  1.00  0.00           C  
ATOM    116  CG2 VAL A  11      23.620 -11.944  16.779  1.00  0.00           C  
ATOM    117  H   VAL A  11      19.875 -11.883  17.978  1.00  0.00           H  
ATOM    118  HA  VAL A  11      22.392 -12.573  18.978  1.00  0.00           H  
ATOM    119  HB  VAL A  11      21.545 -12.404  16.580  1.00  0.00           H  
ATOM    120 HG11 VAL A  11      22.641  -9.707  16.260  1.00  0.00           H  
ATOM    121 HG12 VAL A  11      21.156 -10.428  15.594  1.00  0.00           H  
ATOM    122 HG13 VAL A  11      21.153  -9.738  17.235  1.00  0.00           H  
ATOM    123 HG21 VAL A  11      23.694 -12.536  15.866  1.00  0.00           H  
ATOM    124 HG22 VAL A  11      24.166 -11.010  16.651  1.00  0.00           H  
ATOM    125 HG23 VAL A  11      24.048 -12.504  17.610  1.00  0.00           H  
ATOM    126  N   THR A  12      23.619 -10.218  19.282  1.00  0.00           N  
ATOM    127  CA  THR A  12      24.191  -9.063  19.953  1.00  0.00           C  
ATOM    128  C   THR A  12      25.577  -8.749  19.386  1.00  0.00           C  
ATOM    129  O   THR A  12      26.282  -9.646  18.930  1.00  0.00           O  
ATOM    130  CB  THR A  12      24.199  -9.346  21.457  1.00  0.00           C  
ATOM    131  OG1 THR A  12      22.967  -8.800  21.919  1.00  0.00           O  
ATOM    132  CG2 THR A  12      25.266  -8.538  22.198  1.00  0.00           C  
ATOM    133  H   THR A  12      24.278 -10.796  18.800  1.00  0.00           H  
ATOM    134  HA  THR A  12      23.558  -8.199  19.749  1.00  0.00           H  
ATOM    135  HB  THR A  12      24.312 -10.412  21.652  1.00  0.00           H  
ATOM    136  HG1 THR A  12      22.846  -9.003  22.891  1.00  0.00           H  
ATOM    137 HG21 THR A  12      25.357  -8.907  23.220  1.00  0.00           H  
ATOM    138 HG22 THR A  12      26.223  -8.646  21.688  1.00  0.00           H  
ATOM    139 HG23 THR A  12      24.980  -7.487  22.216  1.00  0.00           H  
ATOM    140  N   VAL A  13      25.924  -7.471  19.433  1.00  0.00           N  
ATOM    141  CA  VAL A  13      27.214  -7.027  18.930  1.00  0.00           C  
ATOM    142  C   VAL A  13      28.054  -6.496  20.092  1.00  0.00           C  
ATOM    143  O   VAL A  13      27.519  -5.920  21.038  1.00  0.00           O  
ATOM    144  CB  VAL A  13      27.014  -5.997  17.817  1.00  0.00           C  
ATOM    145  CG1 VAL A  13      28.271  -5.146  17.626  1.00  0.00           C  
ATOM    146  CG2 VAL A  13      26.606  -6.677  16.507  1.00  0.00           C  
ATOM    147  H   VAL A  13      25.344  -6.746  19.806  1.00  0.00           H  
ATOM    148  HA  VAL A  13      27.716  -7.895  18.501  1.00  0.00           H  
ATOM    149  HB  VAL A  13      26.202  -5.333  18.115  1.00  0.00           H  
ATOM    150 HG11 VAL A  13      29.153  -5.747  17.844  1.00  0.00           H  
ATOM    151 HG12 VAL A  13      28.317  -4.793  16.595  1.00  0.00           H  
ATOM    152 HG13 VAL A  13      28.237  -4.291  18.300  1.00  0.00           H  
ATOM    153 HG21 VAL A  13      27.500  -7.006  15.977  1.00  0.00           H  
ATOM    154 HG22 VAL A  13      25.975  -7.538  16.726  1.00  0.00           H  
ATOM    155 HG23 VAL A  13      26.056  -5.969  15.887  1.00  0.00           H  
ATOM    156  N   GLU A  14      29.357  -6.707  19.983  1.00  0.00           N  
ATOM    157  CA  GLU A  14      30.278  -6.256  21.013  1.00  0.00           C  
ATOM    158  C   GLU A  14      31.234  -5.205  20.448  1.00  0.00           C  
ATOM    159  O   GLU A  14      31.818  -5.401  19.383  1.00  0.00           O  
ATOM    160  CB  GLU A  14      31.049  -7.435  21.612  1.00  0.00           C  
ATOM    161  CG  GLU A  14      30.113  -8.371  22.378  1.00  0.00           C  
ATOM    162  CD  GLU A  14      30.858  -9.091  23.504  1.00  0.00           C  
ATOM    163  OE1 GLU A  14      31.773  -8.459  24.074  1.00  0.00           O  
ATOM    164  OE2 GLU A  14      30.494 -10.258  23.769  1.00  0.00           O  
ATOM    165  H   GLU A  14      29.785  -7.176  19.210  1.00  0.00           H  
ATOM    166  HA  GLU A  14      29.652  -5.810  21.785  1.00  0.00           H  
ATOM    167  HB2 GLU A  14      31.552  -7.986  20.818  1.00  0.00           H  
ATOM    168  HB3 GLU A  14      31.824  -7.062  22.282  1.00  0.00           H  
ATOM    169  HG2 GLU A  14      29.282  -7.800  22.793  1.00  0.00           H  
ATOM    170  HG3 GLU A  14      29.685  -9.103  21.693  1.00  0.00           H  
ATOM    171  N   ILE A  15      31.367  -4.113  21.186  1.00  0.00           N  
ATOM    172  CA  ILE A  15      32.243  -3.031  20.771  1.00  0.00           C  
ATOM    173  C   ILE A  15      33.685  -3.376  21.145  1.00  0.00           C  
ATOM    174  O   ILE A  15      33.922  -4.120  22.096  1.00  0.00           O  
ATOM    175  CB  ILE A  15      31.759  -1.699  21.349  1.00  0.00           C  
ATOM    176  CG1 ILE A  15      30.249  -1.535  21.160  1.00  0.00           C  
ATOM    177  CG2 ILE A  15      32.541  -0.527  20.752  1.00  0.00           C  
ATOM    178  CD1 ILE A  15      29.884  -1.483  19.675  1.00  0.00           C  
ATOM    179  H   ILE A  15      30.889  -3.961  22.051  1.00  0.00           H  
ATOM    180  HA  ILE A  15      32.176  -2.954  19.685  1.00  0.00           H  
ATOM    181  HB  ILE A  15      31.951  -1.701  22.421  1.00  0.00           H  
ATOM    182 HG12 ILE A  15      29.728  -2.365  21.638  1.00  0.00           H  
ATOM    183 HG13 ILE A  15      29.915  -0.623  21.653  1.00  0.00           H  
ATOM    184 HG21 ILE A  15      32.032   0.408  20.989  1.00  0.00           H  
ATOM    185 HG22 ILE A  15      33.546  -0.509  21.173  1.00  0.00           H  
ATOM    186 HG23 ILE A  15      32.603  -0.644  19.670  1.00  0.00           H  
ATOM    187 HD11 ILE A  15      29.177  -0.671  19.503  1.00  0.00           H  
ATOM    188 HD12 ILE A  15      30.785  -1.312  19.085  1.00  0.00           H  
ATOM    189 HD13 ILE A  15      29.430  -2.429  19.379  1.00  0.00           H  
ATOM    190  N   GLY A  16      34.611  -2.819  20.379  1.00  0.00           N  
ATOM    191  CA  GLY A  16      36.024  -3.058  20.619  1.00  0.00           C  
ATOM    192  C   GLY A  16      36.512  -4.284  19.844  1.00  0.00           C  
ATOM    193  O   GLY A  16      37.690  -4.379  19.504  1.00  0.00           O  
ATOM    194  H   GLY A  16      34.409  -2.214  19.608  1.00  0.00           H  
ATOM    195  HA2 GLY A  16      36.601  -2.182  20.321  1.00  0.00           H  
ATOM    196  HA3 GLY A  16      36.196  -3.205  21.685  1.00  0.00           H  
ATOM    197  N   GLU A  17      35.580  -5.190  19.587  1.00  0.00           N  
ATOM    198  CA  GLU A  17      35.901  -6.406  18.858  1.00  0.00           C  
ATOM    199  C   GLU A  17      35.803  -6.162  17.351  1.00  0.00           C  
ATOM    200  O   GLU A  17      35.221  -5.170  16.915  1.00  0.00           O  
ATOM    201  CB  GLU A  17      34.990  -7.558  19.287  1.00  0.00           C  
ATOM    202  CG  GLU A  17      35.567  -8.290  20.500  1.00  0.00           C  
ATOM    203  CD  GLU A  17      34.643  -8.157  21.712  1.00  0.00           C  
ATOM    204  OE1 GLU A  17      34.815  -7.163  22.451  1.00  0.00           O  
ATOM    205  OE2 GLU A  17      33.786  -9.052  21.873  1.00  0.00           O  
ATOM    206  H   GLU A  17      34.624  -5.104  19.866  1.00  0.00           H  
ATOM    207  HA  GLU A  17      36.930  -6.644  19.129  1.00  0.00           H  
ATOM    208  HB2 GLU A  17      33.999  -7.173  19.528  1.00  0.00           H  
ATOM    209  HB3 GLU A  17      34.867  -8.257  18.459  1.00  0.00           H  
ATOM    210  HG2 GLU A  17      35.709  -9.344  20.260  1.00  0.00           H  
ATOM    211  HG3 GLU A  17      36.550  -7.884  20.741  1.00  0.00           H  
ATOM    212  N   THR A  18      36.381  -7.085  16.596  1.00  0.00           N  
ATOM    213  CA  THR A  18      36.367  -6.983  15.146  1.00  0.00           C  
ATOM    214  C   THR A  18      35.397  -8.006  14.550  1.00  0.00           C  
ATOM    215  O   THR A  18      35.320  -9.141  15.017  1.00  0.00           O  
ATOM    216  CB  THR A  18      37.803  -7.145  14.647  1.00  0.00           C  
ATOM    217  OG1 THR A  18      38.556  -6.240  15.450  1.00  0.00           O  
ATOM    218  CG2 THR A  18      37.991  -6.623  13.222  1.00  0.00           C  
ATOM    219  H   THR A  18      36.852  -7.889  16.959  1.00  0.00           H  
ATOM    220  HA  THR A  18      35.996  -5.995  14.875  1.00  0.00           H  
ATOM    221  HB  THR A  18      38.129  -8.183  14.727  1.00  0.00           H  
ATOM    222  HG1 THR A  18      39.515  -6.252  15.173  1.00  0.00           H  
ATOM    223 HG21 THR A  18      39.018  -6.283  13.091  1.00  0.00           H  
ATOM    224 HG22 THR A  18      37.779  -7.422  12.511  1.00  0.00           H  
ATOM    225 HG23 THR A  18      37.309  -5.791  13.047  1.00  0.00           H  
ATOM    226  N   TYR A  19      34.681  -7.565  13.525  1.00  0.00           N  
ATOM    227  CA  TYR A  19      33.720  -8.428  12.860  1.00  0.00           C  
ATOM    228  C   TYR A  19      33.874  -8.350  11.339  1.00  0.00           C  
ATOM    229  O   TYR A  19      34.473  -7.410  10.819  1.00  0.00           O  
ATOM    230  CB  TYR A  19      32.338  -7.896  13.247  1.00  0.00           C  
ATOM    231  CG  TYR A  19      31.998  -8.068  14.729  1.00  0.00           C  
ATOM    232  CD1 TYR A  19      32.726  -7.391  15.686  1.00  0.00           C  
ATOM    233  CD2 TYR A  19      30.965  -8.900  15.108  1.00  0.00           C  
ATOM    234  CE1 TYR A  19      32.407  -7.552  17.081  1.00  0.00           C  
ATOM    235  CE2 TYR A  19      30.646  -9.061  16.503  1.00  0.00           C  
ATOM    236  CZ  TYR A  19      31.382  -8.379  17.421  1.00  0.00           C  
ATOM    237  OH  TYR A  19      31.080  -8.531  18.739  1.00  0.00           O  
ATOM    238  H   TYR A  19      34.750  -6.641  13.150  1.00  0.00           H  
ATOM    239  HA  TYR A  19      33.904  -9.451  13.184  1.00  0.00           H  
ATOM    240  HB2 TYR A  19      32.282  -6.838  12.991  1.00  0.00           H  
ATOM    241  HB3 TYR A  19      31.583  -8.409  12.650  1.00  0.00           H  
ATOM    242  HD1 TYR A  19      33.542  -6.733  15.386  1.00  0.00           H  
ATOM    243  HD2 TYR A  19      30.390  -9.435  14.352  1.00  0.00           H  
ATOM    244  HE1 TYR A  19      32.973  -7.022  17.847  1.00  0.00           H  
ATOM    245  HE2 TYR A  19      29.832  -9.715  16.816  1.00  0.00           H  
ATOM    246  HH  TYR A  19      30.624  -9.409  18.885  1.00  0.00           H  
ATOM    247  N   LEU A  20      33.325  -9.353  10.669  1.00  0.00           N  
ATOM    248  CA  LEU A  20      33.394  -9.410   9.219  1.00  0.00           C  
ATOM    249  C   LEU A  20      32.234  -8.609   8.624  1.00  0.00           C  
ATOM    250  O   LEU A  20      31.071  -8.968   8.804  1.00  0.00           O  
ATOM    251  CB  LEU A  20      33.447 -10.863   8.742  1.00  0.00           C  
ATOM    252  CG  LEU A  20      34.551 -11.729   9.351  1.00  0.00           C  
ATOM    253  CD1 LEU A  20      35.934 -11.161   9.030  1.00  0.00           C  
ATOM    254  CD2 LEU A  20      34.341 -11.909  10.856  1.00  0.00           C  
ATOM    255  H   LEU A  20      32.840 -10.114  11.099  1.00  0.00           H  
ATOM    256  HA  LEU A  20      34.330  -8.938   8.918  1.00  0.00           H  
ATOM    257  HB2 LEU A  20      32.485 -11.330   8.958  1.00  0.00           H  
ATOM    258  HB3 LEU A  20      33.566 -10.865   7.659  1.00  0.00           H  
ATOM    259  HG  LEU A  20      34.498 -12.720   8.897  1.00  0.00           H  
ATOM    260 HD11 LEU A  20      36.556 -11.942   8.593  1.00  0.00           H  
ATOM    261 HD12 LEU A  20      35.833 -10.338   8.322  1.00  0.00           H  
ATOM    262 HD13 LEU A  20      36.398 -10.795   9.947  1.00  0.00           H  
ATOM    263 HD21 LEU A  20      34.863 -12.805  11.192  1.00  0.00           H  
ATOM    264 HD22 LEU A  20      34.731 -11.040  11.384  1.00  0.00           H  
ATOM    265 HD23 LEU A  20      33.275 -12.012  11.064  1.00  0.00           H  
ATOM    266  N   CYS A  21      32.590  -7.540   7.928  1.00  0.00           N  
ATOM    267  CA  CYS A  21      31.593  -6.686   7.306  1.00  0.00           C  
ATOM    268  C   CYS A  21      31.521  -7.035   5.818  1.00  0.00           C  
ATOM    269  O   CYS A  21      32.544  -7.080   5.137  1.00  0.00           O  
ATOM    270  CB  CYS A  21      31.900  -5.203   7.530  1.00  0.00           C  
ATOM    271  SG  CYS A  21      30.423  -4.194   7.143  1.00  0.00           S  
ATOM    272  H   CYS A  21      33.538  -7.256   7.786  1.00  0.00           H  
ATOM    273  HA  CYS A  21      30.646  -6.899   7.801  1.00  0.00           H  
ATOM    274  HB2 CYS A  21      32.203  -5.038   8.563  1.00  0.00           H  
ATOM    275  HB3 CYS A  21      32.735  -4.897   6.900  1.00  0.00           H  
ATOM    276  HG  CYS A  21      30.022  -4.045   8.403  1.00  0.00           H  
ATOM    277  N   ARG A  22      30.302  -7.275   5.358  1.00  0.00           N  
ATOM    278  CA  ARG A  22      30.082  -7.619   3.964  1.00  0.00           C  
ATOM    279  C   ARG A  22      30.681  -6.547   3.051  1.00  0.00           C  
ATOM    280  O   ARG A  22      30.874  -5.407   3.471  1.00  0.00           O  
ATOM    281  CB  ARG A  22      28.590  -7.761   3.660  1.00  0.00           C  
ATOM    282  CG  ARG A  22      28.328  -8.967   2.755  1.00  0.00           C  
ATOM    283  CD  ARG A  22      27.133  -9.780   3.257  1.00  0.00           C  
ATOM    284  NE  ARG A  22      26.084  -9.836   2.215  1.00  0.00           N  
ATOM    285  CZ  ARG A  22      25.105 -10.750   2.181  1.00  0.00           C  
ATOM    286  NH1 ARG A  22      25.035 -11.690   3.133  1.00  0.00           N  
ATOM    287  NH2 ARG A  22      24.196 -10.724   1.196  1.00  0.00           N  
ATOM    288  H   ARG A  22      29.475  -7.236   5.919  1.00  0.00           H  
ATOM    289  HA  ARG A  22      30.589  -8.575   3.830  1.00  0.00           H  
ATOM    290  HB2 ARG A  22      28.034  -7.874   4.591  1.00  0.00           H  
ATOM    291  HB3 ARG A  22      28.225  -6.855   3.178  1.00  0.00           H  
ATOM    292  HG2 ARG A  22      28.139  -8.628   1.737  1.00  0.00           H  
ATOM    293  HG3 ARG A  22      29.214  -9.600   2.720  1.00  0.00           H  
ATOM    294  HD2 ARG A  22      27.452 -10.789   3.517  1.00  0.00           H  
ATOM    295  HD3 ARG A  22      26.732  -9.329   4.164  1.00  0.00           H  
ATOM    296  HE  ARG A  22      26.108  -9.148   1.489  1.00  0.00           H  
ATOM    297 HH11 ARG A  22      25.713 -11.711   3.867  1.00  0.00           H  
ATOM    298 HH12 ARG A  22      24.304 -12.373   3.108  1.00  0.00           H  
ATOM    299 HH21 ARG A  22      24.248 -10.021   0.487  1.00  0.00           H  
ATOM    300 HH22 ARG A  22      23.466 -11.406   1.172  1.00  0.00           H  
ATOM    301  N   ARG A  23      30.959  -6.950   1.820  1.00  0.00           N  
ATOM    302  CA  ARG A  23      31.533  -6.038   0.845  1.00  0.00           C  
ATOM    303  C   ARG A  23      30.859  -6.223  -0.515  1.00  0.00           C  
ATOM    304  O   ARG A  23      30.397  -7.316  -0.839  1.00  0.00           O  
ATOM    305  CB  ARG A  23      33.038  -6.266   0.696  1.00  0.00           C  
ATOM    306  CG  ARG A  23      33.760  -6.046   2.028  1.00  0.00           C  
ATOM    307  CD  ARG A  23      34.283  -4.612   2.137  1.00  0.00           C  
ATOM    308  NE  ARG A  23      33.165  -3.688   2.432  1.00  0.00           N  
ATOM    309  CZ  ARG A  23      33.214  -2.363   2.236  1.00  0.00           C  
ATOM    310  NH1 ARG A  23      34.327  -1.799   1.745  1.00  0.00           N  
ATOM    311  NH2 ARG A  23      32.153  -1.602   2.533  1.00  0.00           N  
ATOM    312  H   ARG A  23      30.799  -7.879   1.487  1.00  0.00           H  
ATOM    313  HA  ARG A  23      31.339  -5.043   1.248  1.00  0.00           H  
ATOM    314  HB2 ARG A  23      33.222  -7.280   0.342  1.00  0.00           H  
ATOM    315  HB3 ARG A  23      33.440  -5.587  -0.056  1.00  0.00           H  
ATOM    316  HG2 ARG A  23      33.079  -6.253   2.853  1.00  0.00           H  
ATOM    317  HG3 ARG A  23      34.591  -6.747   2.115  1.00  0.00           H  
ATOM    318  HD2 ARG A  23      35.035  -4.549   2.924  1.00  0.00           H  
ATOM    319  HD3 ARG A  23      34.770  -4.321   1.207  1.00  0.00           H  
ATOM    320  HE  ARG A  23      32.321  -4.076   2.801  1.00  0.00           H  
ATOM    321 HH11 ARG A  23      35.119  -2.367   1.523  1.00  0.00           H  
ATOM    322 HH12 ARG A  23      34.363  -0.810   1.598  1.00  0.00           H  
ATOM    323 HH21 ARG A  23      31.323  -2.022   2.900  1.00  0.00           H  
ATOM    324 HH22 ARG A  23      32.189  -0.614   2.387  1.00  0.00           H  
ATOM    325  N   PRO A  24      30.821  -5.109  -1.294  1.00  0.00           N  
ATOM    326  CA  PRO A  24      30.211  -5.139  -2.613  1.00  0.00           C  
ATOM    327  C   PRO A  24      31.114  -5.854  -3.619  1.00  0.00           C  
ATOM    328  O   PRO A  24      31.460  -5.293  -4.657  1.00  0.00           O  
ATOM    329  CB  PRO A  24      29.967  -3.680  -2.966  1.00  0.00           C  
ATOM    330  CG  PRO A  24      30.866  -2.872  -2.044  1.00  0.00           C  
ATOM    331  CD  PRO A  24      31.357  -3.797  -0.942  1.00  0.00           C  
ATOM    332  HA  PRO A  24      29.359  -5.662  -2.590  1.00  0.00           H  
ATOM    333  HB2 PRO A  24      30.204  -3.487  -4.012  1.00  0.00           H  
ATOM    334  HB3 PRO A  24      28.920  -3.413  -2.822  1.00  0.00           H  
ATOM    335  HG2 PRO A  24      31.709  -2.459  -2.600  1.00  0.00           H  
ATOM    336  HG3 PRO A  24      30.320  -2.029  -1.621  1.00  0.00           H  
ATOM    337  HD2 PRO A  24      32.445  -3.815  -0.895  1.00  0.00           H  
ATOM    338  HD3 PRO A  24      31.000  -3.473   0.034  1.00  0.00           H  
ATOM    339  N   ASP A  25      31.470  -7.084  -3.277  1.00  0.00           N  
ATOM    340  CA  ASP A  25      32.326  -7.882  -4.137  1.00  0.00           C  
ATOM    341  C   ASP A  25      32.207  -9.356  -3.743  1.00  0.00           C  
ATOM    342  O   ASP A  25      33.148 -10.127  -3.920  1.00  0.00           O  
ATOM    343  CB  ASP A  25      33.791  -7.471  -3.992  1.00  0.00           C  
ATOM    344  CG  ASP A  25      34.780  -8.291  -4.823  1.00  0.00           C  
ATOM    345  OD1 ASP A  25      34.510  -8.449  -6.033  1.00  0.00           O  
ATOM    346  OD2 ASP A  25      35.783  -8.742  -4.229  1.00  0.00           O  
ATOM    347  H   ASP A  25      31.184  -7.533  -2.431  1.00  0.00           H  
ATOM    348  HA  ASP A  25      31.970  -7.693  -5.150  1.00  0.00           H  
ATOM    349  HB2 ASP A  25      33.888  -6.421  -4.272  1.00  0.00           H  
ATOM    350  HB3 ASP A  25      34.073  -7.547  -2.941  1.00  0.00           H  
ATOM    351  N   SER A  26      31.042  -9.701  -3.213  1.00  0.00           N  
ATOM    352  CA  SER A  26      30.789 -11.068  -2.791  1.00  0.00           C  
ATOM    353  C   SER A  26      31.906 -11.544  -1.860  1.00  0.00           C  
ATOM    354  O   SER A  26      32.382 -12.672  -1.982  1.00  0.00           O  
ATOM    355  CB  SER A  26      30.668 -12.003  -3.996  1.00  0.00           C  
ATOM    356  OG  SER A  26      29.516 -11.713  -4.783  1.00  0.00           O  
ATOM    357  H   SER A  26      30.282  -9.068  -3.072  1.00  0.00           H  
ATOM    358  HA  SER A  26      29.837 -11.035  -2.262  1.00  0.00           H  
ATOM    359  HB2 SER A  26      31.561 -11.916  -4.615  1.00  0.00           H  
ATOM    360  HB3 SER A  26      30.620 -13.037  -3.650  1.00  0.00           H  
ATOM    361  HG  SER A  26      28.765 -11.417  -4.193  1.00  0.00           H  
ATOM    362  N   THR A  27      32.292 -10.661  -0.952  1.00  0.00           N  
ATOM    363  CA  THR A  27      33.345 -10.977   0.000  1.00  0.00           C  
ATOM    364  C   THR A  27      33.068 -10.302   1.345  1.00  0.00           C  
ATOM    365  O   THR A  27      32.091  -9.567   1.485  1.00  0.00           O  
ATOM    366  CB  THR A  27      34.682 -10.568  -0.621  1.00  0.00           C  
ATOM    367  OG1 THR A  27      34.419  -9.295  -1.203  1.00  0.00           O  
ATOM    368  CG2 THR A  27      35.067 -11.449  -1.812  1.00  0.00           C  
ATOM    369  H   THR A  27      31.900  -9.745  -0.859  1.00  0.00           H  
ATOM    370  HA  THR A  27      33.338 -12.052   0.175  1.00  0.00           H  
ATOM    371  HB  THR A  27      35.473 -10.559   0.129  1.00  0.00           H  
ATOM    372  HG1 THR A  27      33.631  -9.354  -1.816  1.00  0.00           H  
ATOM    373 HG21 THR A  27      35.230 -12.472  -1.469  1.00  0.00           H  
ATOM    374 HG22 THR A  27      34.265 -11.436  -2.549  1.00  0.00           H  
ATOM    375 HG23 THR A  27      35.983 -11.068  -2.264  1.00  0.00           H  
ATOM    376  N   TRP A  28      33.944 -10.576   2.299  1.00  0.00           N  
ATOM    377  CA  TRP A  28      33.807 -10.004   3.628  1.00  0.00           C  
ATOM    378  C   TRP A  28      35.158  -9.409   4.028  1.00  0.00           C  
ATOM    379  O   TRP A  28      36.206  -9.940   3.666  1.00  0.00           O  
ATOM    380  CB  TRP A  28      33.294 -11.048   4.623  1.00  0.00           C  
ATOM    381  CG  TRP A  28      31.828 -11.434   4.419  1.00  0.00           C  
ATOM    382  CD1 TRP A  28      31.260 -11.966   3.328  1.00  0.00           C  
ATOM    383  CD2 TRP A  28      30.762 -11.298   5.381  1.00  0.00           C  
ATOM    384  NE1 TRP A  28      29.909 -12.182   3.516  1.00  0.00           N  
ATOM    385  CE2 TRP A  28      29.597 -11.763   4.804  1.00  0.00           C  
ATOM    386  CE3 TRP A  28      30.779 -10.800   6.696  1.00  0.00           C  
ATOM    387  CZ2 TRP A  28      28.364 -11.774   5.467  1.00  0.00           C  
ATOM    388  CZ3 TRP A  28      29.539 -10.818   7.346  1.00  0.00           C  
ATOM    389  CH2 TRP A  28      28.358 -11.282   6.778  1.00  0.00           C  
ATOM    390  H   TRP A  28      34.735 -11.175   2.177  1.00  0.00           H  
ATOM    391  HA  TRP A  28      33.053  -9.218   3.576  1.00  0.00           H  
ATOM    392  HB2 TRP A  28      33.911 -11.943   4.544  1.00  0.00           H  
ATOM    393  HB3 TRP A  28      33.420 -10.662   5.635  1.00  0.00           H  
ATOM    394  HD1 TRP A  28      31.796 -12.199   2.409  1.00  0.00           H  
ATOM    395  HE1 TRP A  28      29.216 -12.603   2.788  1.00  0.00           H  
ATOM    396  HE3 TRP A  28      31.686 -10.428   7.174  1.00  0.00           H  
ATOM    397  HZ2 TRP A  28      27.458 -12.146   4.989  1.00  0.00           H  
ATOM    398  HZ3 TRP A  28      29.497 -10.442   8.367  1.00  0.00           H  
ATOM    399  HH2 TRP A  28      27.431 -11.263   7.352  1.00  0.00           H  
ATOM    400  N   HIS A  29      35.089  -8.314   4.772  1.00  0.00           N  
ATOM    401  CA  HIS A  29      36.294  -7.640   5.226  1.00  0.00           C  
ATOM    402  C   HIS A  29      36.147  -7.264   6.701  1.00  0.00           C  
ATOM    403  O   HIS A  29      35.153  -6.654   7.093  1.00  0.00           O  
ATOM    404  CB  HIS A  29      36.612  -6.437   4.335  1.00  0.00           C  
ATOM    405  CG  HIS A  29      37.892  -6.578   3.547  1.00  0.00           C  
ATOM    406  ND1 HIS A  29      39.136  -6.283   4.077  1.00  0.00           N  
ATOM    407  CD2 HIS A  29      38.108  -6.987   2.263  1.00  0.00           C  
ATOM    408  CE1 HIS A  29      40.051  -6.506   3.145  1.00  0.00           C  
ATOM    409  NE2 HIS A  29      39.412  -6.942   2.022  1.00  0.00           N  
ATOM    410  H   HIS A  29      34.233  -7.888   5.062  1.00  0.00           H  
ATOM    411  HA  HIS A  29      37.111  -8.355   5.122  1.00  0.00           H  
ATOM    412  HB2 HIS A  29      35.785  -6.282   3.642  1.00  0.00           H  
ATOM    413  HB3 HIS A  29      36.678  -5.546   4.958  1.00  0.00           H  
ATOM    414  HD1 HIS A  29      39.314  -5.956   5.005  1.00  0.00           H  
ATOM    415  HD2 HIS A  29      37.338  -7.298   1.556  1.00  0.00           H  
ATOM    416  HE1 HIS A  29      41.127  -6.366   3.257  1.00  0.00           H  
ATOM    417  N   SER A  30      37.151  -7.643   7.478  1.00  0.00           N  
ATOM    418  CA  SER A  30      37.144  -7.352   8.902  1.00  0.00           C  
ATOM    419  C   SER A  30      36.885  -5.863   9.131  1.00  0.00           C  
ATOM    420  O   SER A  30      37.138  -5.042   8.250  1.00  0.00           O  
ATOM    421  CB  SER A  30      38.465  -7.768   9.554  1.00  0.00           C  
ATOM    422  OG  SER A  30      39.590  -7.405   8.758  1.00  0.00           O  
ATOM    423  H   SER A  30      37.955  -8.139   7.151  1.00  0.00           H  
ATOM    424  HA  SER A  30      36.332  -7.951   9.316  1.00  0.00           H  
ATOM    425  HB2 SER A  30      38.549  -7.299  10.535  1.00  0.00           H  
ATOM    426  HB3 SER A  30      38.467  -8.846   9.714  1.00  0.00           H  
ATOM    427  HG  SER A  30      39.833  -8.157   8.145  1.00  0.00           H  
ATOM    428  N   ALA A  31      36.385  -5.557  10.319  1.00  0.00           N  
ATOM    429  CA  ALA A  31      36.089  -4.180  10.676  1.00  0.00           C  
ATOM    430  C   ALA A  31      35.863  -4.086  12.186  1.00  0.00           C  
ATOM    431  O   ALA A  31      34.980  -4.749  12.728  1.00  0.00           O  
ATOM    432  CB  ALA A  31      34.880  -3.694   9.873  1.00  0.00           C  
ATOM    433  H   ALA A  31      36.183  -6.231  11.031  1.00  0.00           H  
ATOM    434  HA  ALA A  31      36.954  -3.574  10.409  1.00  0.00           H  
ATOM    435  HB1 ALA A  31      34.590  -2.702  10.219  1.00  0.00           H  
ATOM    436  HB2 ALA A  31      35.140  -3.649   8.817  1.00  0.00           H  
ATOM    437  HB3 ALA A  31      34.049  -4.385  10.015  1.00  0.00           H  
ATOM    438  N   GLU A  32      36.675  -3.256  12.823  1.00  0.00           N  
ATOM    439  CA  GLU A  32      36.575  -3.066  14.260  1.00  0.00           C  
ATOM    440  C   GLU A  32      35.327  -2.249  14.602  1.00  0.00           C  
ATOM    441  O   GLU A  32      35.054  -1.231  13.968  1.00  0.00           O  
ATOM    442  CB  GLU A  32      37.835  -2.400  14.815  1.00  0.00           C  
ATOM    443  CG  GLU A  32      37.951  -0.954  14.328  1.00  0.00           C  
ATOM    444  CD  GLU A  32      39.014  -0.191  15.122  1.00  0.00           C  
ATOM    445  OE1 GLU A  32      39.132  -0.480  16.332  1.00  0.00           O  
ATOM    446  OE2 GLU A  32      39.680   0.664  14.501  1.00  0.00           O  
ATOM    447  H   GLU A  32      37.390  -2.720  12.375  1.00  0.00           H  
ATOM    448  HA  GLU A  32      36.487  -4.069  14.679  1.00  0.00           H  
ATOM    449  HB2 GLU A  32      37.812  -2.419  15.904  1.00  0.00           H  
ATOM    450  HB3 GLU A  32      38.715  -2.963  14.505  1.00  0.00           H  
ATOM    451  HG2 GLU A  32      38.207  -0.944  13.268  1.00  0.00           H  
ATOM    452  HG3 GLU A  32      36.987  -0.454  14.428  1.00  0.00           H  
ATOM    453  N   VAL A  33      34.601  -2.727  15.603  1.00  0.00           N  
ATOM    454  CA  VAL A  33      33.390  -2.053  16.036  1.00  0.00           C  
ATOM    455  C   VAL A  33      33.760  -0.884  16.952  1.00  0.00           C  
ATOM    456  O   VAL A  33      34.168  -1.090  18.094  1.00  0.00           O  
ATOM    457  CB  VAL A  33      32.443  -3.056  16.701  1.00  0.00           C  
ATOM    458  CG1 VAL A  33      31.077  -2.421  16.974  1.00  0.00           C  
ATOM    459  CG2 VAL A  33      32.301  -4.320  15.852  1.00  0.00           C  
ATOM    460  H   VAL A  33      34.831  -3.555  16.114  1.00  0.00           H  
ATOM    461  HA  VAL A  33      32.896  -1.660  15.148  1.00  0.00           H  
ATOM    462  HB  VAL A  33      32.877  -3.342  17.658  1.00  0.00           H  
ATOM    463 HG11 VAL A  33      31.201  -1.351  17.141  1.00  0.00           H  
ATOM    464 HG12 VAL A  33      30.424  -2.583  16.117  1.00  0.00           H  
ATOM    465 HG13 VAL A  33      30.636  -2.878  17.859  1.00  0.00           H  
ATOM    466 HG21 VAL A  33      32.793  -5.153  16.355  1.00  0.00           H  
ATOM    467 HG22 VAL A  33      31.244  -4.550  15.717  1.00  0.00           H  
ATOM    468 HG23 VAL A  33      32.764  -4.158  14.878  1.00  0.00           H  
ATOM    469  N   ILE A  34      33.604   0.317  16.415  1.00  0.00           N  
ATOM    470  CA  ILE A  34      33.916   1.519  17.169  1.00  0.00           C  
ATOM    471  C   ILE A  34      32.891   1.695  18.291  1.00  0.00           C  
ATOM    472  O   ILE A  34      33.250   1.723  19.466  1.00  0.00           O  
ATOM    473  CB  ILE A  34      34.019   2.727  16.235  1.00  0.00           C  
ATOM    474  CG1 ILE A  34      34.948   2.431  15.056  1.00  0.00           C  
ATOM    475  CG2 ILE A  34      34.447   3.980  17.002  1.00  0.00           C  
ATOM    476  CD1 ILE A  34      36.381   2.868  15.364  1.00  0.00           C  
ATOM    477  H   ILE A  34      33.271   0.477  15.486  1.00  0.00           H  
ATOM    478  HA  ILE A  34      34.900   1.377  17.619  1.00  0.00           H  
ATOM    479  HB  ILE A  34      33.029   2.924  15.823  1.00  0.00           H  
ATOM    480 HG12 ILE A  34      34.929   1.364  14.833  1.00  0.00           H  
ATOM    481 HG13 ILE A  34      34.589   2.949  14.166  1.00  0.00           H  
ATOM    482 HG21 ILE A  34      35.439   3.824  17.425  1.00  0.00           H  
ATOM    483 HG22 ILE A  34      34.472   4.831  16.322  1.00  0.00           H  
ATOM    484 HG23 ILE A  34      33.736   4.175  17.805  1.00  0.00           H  
ATOM    485 HD11 ILE A  34      36.451   3.954  15.303  1.00  0.00           H  
ATOM    486 HD12 ILE A  34      36.653   2.543  16.369  1.00  0.00           H  
ATOM    487 HD13 ILE A  34      37.062   2.419  14.641  1.00  0.00           H  
ATOM    488  N   GLN A  35      31.634   1.808  17.887  1.00  0.00           N  
ATOM    489  CA  GLN A  35      30.553   1.979  18.842  1.00  0.00           C  
ATOM    490  C   GLN A  35      29.254   1.394  18.286  1.00  0.00           C  
ATOM    491  O   GLN A  35      29.260   0.740  17.244  1.00  0.00           O  
ATOM    492  CB  GLN A  35      30.377   3.454  19.213  1.00  0.00           C  
ATOM    493  CG  GLN A  35      31.090   3.780  20.526  1.00  0.00           C  
ATOM    494  CD  GLN A  35      30.248   3.346  21.728  1.00  0.00           C  
ATOM    495  OE1 GLN A  35      29.035   3.472  21.748  1.00  0.00           O  
ATOM    496  NE2 GLN A  35      30.958   2.828  22.727  1.00  0.00           N  
ATOM    497  H   GLN A  35      31.351   1.784  16.928  1.00  0.00           H  
ATOM    498  HA  GLN A  35      30.860   1.424  19.729  1.00  0.00           H  
ATOM    499  HB2 GLN A  35      30.773   4.082  18.414  1.00  0.00           H  
ATOM    500  HB3 GLN A  35      29.315   3.685  19.302  1.00  0.00           H  
ATOM    501  HG2 GLN A  35      32.056   3.277  20.554  1.00  0.00           H  
ATOM    502  HG3 GLN A  35      31.285   4.850  20.582  1.00  0.00           H  
ATOM    503 HE21 GLN A  35      31.952   2.754  22.647  1.00  0.00           H  
ATOM    504 HE22 GLN A  35      30.498   2.516  23.557  1.00  0.00           H  
ATOM    505  N   SER A  36      28.171   1.651  19.005  1.00  0.00           N  
ATOM    506  CA  SER A  36      26.867   1.158  18.595  1.00  0.00           C  
ATOM    507  C   SER A  36      25.816   2.257  18.764  1.00  0.00           C  
ATOM    508  O   SER A  36      25.887   3.051  19.699  1.00  0.00           O  
ATOM    509  CB  SER A  36      26.470  -0.083  19.398  1.00  0.00           C  
ATOM    510  OG  SER A  36      26.652   0.107  20.799  1.00  0.00           O  
ATOM    511  H   SER A  36      28.175   2.185  19.851  1.00  0.00           H  
ATOM    512  HA  SER A  36      26.976   0.890  17.544  1.00  0.00           H  
ATOM    513  HB2 SER A  36      25.427  -0.327  19.197  1.00  0.00           H  
ATOM    514  HB3 SER A  36      27.065  -0.934  19.067  1.00  0.00           H  
ATOM    515  HG  SER A  36      27.576   0.440  20.982  1.00  0.00           H  
ATOM    516  N   ARG A  37      24.863   2.266  17.842  1.00  0.00           N  
ATOM    517  CA  ARG A  37      23.799   3.254  17.876  1.00  0.00           C  
ATOM    518  C   ARG A  37      22.512   2.670  17.289  1.00  0.00           C  
ATOM    519  O   ARG A  37      22.560   1.756  16.467  1.00  0.00           O  
ATOM    520  CB  ARG A  37      24.186   4.509  17.090  1.00  0.00           C  
ATOM    521  CG  ARG A  37      24.240   4.220  15.589  1.00  0.00           C  
ATOM    522  CD  ARG A  37      24.390   5.515  14.786  1.00  0.00           C  
ATOM    523  NE  ARG A  37      23.442   5.519  13.651  1.00  0.00           N  
ATOM    524  CZ  ARG A  37      23.255   6.564  12.832  1.00  0.00           C  
ATOM    525  NH1 ARG A  37      23.951   7.694  13.020  1.00  0.00           N  
ATOM    526  NH2 ARG A  37      22.374   6.478  11.827  1.00  0.00           N  
ATOM    527  H   ARG A  37      24.812   1.616  17.084  1.00  0.00           H  
ATOM    528  HA  ARG A  37      23.674   3.494  18.933  1.00  0.00           H  
ATOM    529  HB2 ARG A  37      23.464   5.302  17.286  1.00  0.00           H  
ATOM    530  HB3 ARG A  37      25.157   4.870  17.430  1.00  0.00           H  
ATOM    531  HG2 ARG A  37      25.075   3.554  15.373  1.00  0.00           H  
ATOM    532  HG3 ARG A  37      23.331   3.701  15.282  1.00  0.00           H  
ATOM    533  HD2 ARG A  37      24.205   6.374  15.430  1.00  0.00           H  
ATOM    534  HD3 ARG A  37      25.412   5.607  14.419  1.00  0.00           H  
ATOM    535  HE  ARG A  37      22.907   4.691  13.483  1.00  0.00           H  
ATOM    536 HH11 ARG A  37      24.610   7.758  13.769  1.00  0.00           H  
ATOM    537 HH12 ARG A  37      23.811   8.473  12.408  1.00  0.00           H  
ATOM    538 HH21 ARG A  37      21.855   5.635  11.688  1.00  0.00           H  
ATOM    539 HH22 ARG A  37      22.234   7.258  11.216  1.00  0.00           H  
ATOM    540  N   VAL A  38      21.393   3.221  17.734  1.00  0.00           N  
ATOM    541  CA  VAL A  38      20.096   2.765  17.262  1.00  0.00           C  
ATOM    542  C   VAL A  38      19.332   3.947  16.662  1.00  0.00           C  
ATOM    543  O   VAL A  38      19.431   5.069  17.156  1.00  0.00           O  
ATOM    544  CB  VAL A  38      19.337   2.079  18.400  1.00  0.00           C  
ATOM    545  CG1 VAL A  38      17.826   2.143  18.169  1.00  0.00           C  
ATOM    546  CG2 VAL A  38      19.804   0.632  18.576  1.00  0.00           C  
ATOM    547  H   VAL A  38      21.362   3.964  18.402  1.00  0.00           H  
ATOM    548  HA  VAL A  38      20.271   2.027  16.480  1.00  0.00           H  
ATOM    549  HB  VAL A  38      19.558   2.616  19.322  1.00  0.00           H  
ATOM    550 HG11 VAL A  38      17.338   1.355  18.742  1.00  0.00           H  
ATOM    551 HG12 VAL A  38      17.451   3.114  18.492  1.00  0.00           H  
ATOM    552 HG13 VAL A  38      17.615   2.006  17.108  1.00  0.00           H  
ATOM    553 HG21 VAL A  38      19.090   0.093  19.198  1.00  0.00           H  
ATOM    554 HG22 VAL A  38      19.871   0.151  17.600  1.00  0.00           H  
ATOM    555 HG23 VAL A  38      20.783   0.621  19.054  1.00  0.00           H  
ATOM    556  N   ASN A  39      18.588   3.655  15.606  1.00  0.00           N  
ATOM    557  CA  ASN A  39      17.808   4.680  14.933  1.00  0.00           C  
ATOM    558  C   ASN A  39      16.357   4.607  15.413  1.00  0.00           C  
ATOM    559  O   ASN A  39      15.742   3.541  15.382  1.00  0.00           O  
ATOM    560  CB  ASN A  39      17.816   4.471  13.418  1.00  0.00           C  
ATOM    561  CG  ASN A  39      19.052   5.112  12.783  1.00  0.00           C  
ATOM    562  OD1 ASN A  39      19.975   5.542  13.455  1.00  0.00           O  
ATOM    563  ND2 ASN A  39      19.020   5.152  11.454  1.00  0.00           N  
ATOM    564  H   ASN A  39      18.514   2.739  15.211  1.00  0.00           H  
ATOM    565  HA  ASN A  39      18.287   5.622  15.196  1.00  0.00           H  
ATOM    566  HB2 ASN A  39      17.798   3.406  13.193  1.00  0.00           H  
ATOM    567  HB3 ASN A  39      16.915   4.905  12.983  1.00  0.00           H  
ATOM    568 HD21 ASN A  39      18.231   4.781  10.962  1.00  0.00           H  
ATOM    569 HD22 ASN A  39      19.783   5.551  10.947  1.00  0.00           H  
ATOM    570  N   ASP A  40      15.851   5.752  15.845  1.00  0.00           N  
ATOM    571  CA  ASP A  40      14.484   5.832  16.330  1.00  0.00           C  
ATOM    572  C   ASP A  40      13.553   6.172  15.164  1.00  0.00           C  
ATOM    573  O   ASP A  40      12.502   5.553  15.002  1.00  0.00           O  
ATOM    574  CB  ASP A  40      14.337   6.927  17.388  1.00  0.00           C  
ATOM    575  CG  ASP A  40      13.663   6.484  18.688  1.00  0.00           C  
ATOM    576  OD1 ASP A  40      12.762   5.623  18.595  1.00  0.00           O  
ATOM    577  OD2 ASP A  40      14.062   7.018  19.745  1.00  0.00           O  
ATOM    578  H   ASP A  40      16.358   6.614  15.866  1.00  0.00           H  
ATOM    579  HA  ASP A  40      14.274   4.852  16.758  1.00  0.00           H  
ATOM    580  HB2 ASP A  40      15.327   7.318  17.624  1.00  0.00           H  
ATOM    581  HB3 ASP A  40      13.765   7.749  16.961  1.00  0.00           H  
ATOM    582  N   GLN A  41      13.971   7.157  14.383  1.00  0.00           N  
ATOM    583  CA  GLN A  41      13.188   7.588  13.238  1.00  0.00           C  
ATOM    584  C   GLN A  41      13.000   6.429  12.256  1.00  0.00           C  
ATOM    585  O   GLN A  41      11.896   6.197  11.767  1.00  0.00           O  
ATOM    586  CB  GLN A  41      13.837   8.790  12.549  1.00  0.00           C  
ATOM    587  CG  GLN A  41      13.756  10.038  13.431  1.00  0.00           C  
ATOM    588  CD  GLN A  41      12.307  10.505  13.586  1.00  0.00           C  
ATOM    589  OE1 GLN A  41      11.378   9.920  13.055  1.00  0.00           O  
ATOM    590  NE2 GLN A  41      12.167  11.590  14.343  1.00  0.00           N  
ATOM    591  H   GLN A  41      14.827   7.656  14.522  1.00  0.00           H  
ATOM    592  HA  GLN A  41      12.221   7.889  13.644  1.00  0.00           H  
ATOM    593  HB2 GLN A  41      14.881   8.566  12.326  1.00  0.00           H  
ATOM    594  HB3 GLN A  41      13.343   8.980  11.597  1.00  0.00           H  
ATOM    595  HG2 GLN A  41      14.179   9.822  14.412  1.00  0.00           H  
ATOM    596  HG3 GLN A  41      14.354  10.836  12.994  1.00  0.00           H  
ATOM    597 HE21 GLN A  41      12.971  12.022  14.751  1.00  0.00           H  
ATOM    598 HE22 GLN A  41      11.258  11.973  14.505  1.00  0.00           H  
ATOM    599  N   GLU A  42      14.097   5.733  11.997  1.00  0.00           N  
ATOM    600  CA  GLU A  42      14.068   4.604  11.083  1.00  0.00           C  
ATOM    601  C   GLU A  42      13.630   3.336  11.820  1.00  0.00           C  
ATOM    602  O   GLU A  42      12.836   2.554  11.298  1.00  0.00           O  
ATOM    603  CB  GLU A  42      15.430   4.405  10.413  1.00  0.00           C  
ATOM    604  CG  GLU A  42      15.555   5.274   9.160  1.00  0.00           C  
ATOM    605  CD  GLU A  42      14.767   4.674   7.995  1.00  0.00           C  
ATOM    606  OE1 GLU A  42      15.169   3.581   7.540  1.00  0.00           O  
ATOM    607  OE2 GLU A  42      13.779   5.320   7.584  1.00  0.00           O  
ATOM    608  H   GLU A  42      14.992   5.928  12.399  1.00  0.00           H  
ATOM    609  HA  GLU A  42      13.331   4.864  10.324  1.00  0.00           H  
ATOM    610  HB2 GLU A  42      16.224   4.656  11.115  1.00  0.00           H  
ATOM    611  HB3 GLU A  42      15.558   3.356  10.147  1.00  0.00           H  
ATOM    612  HG2 GLU A  42      15.190   6.279   9.371  1.00  0.00           H  
ATOM    613  HG3 GLU A  42      16.605   5.369   8.882  1.00  0.00           H  
ATOM    614  N   GLY A  43      14.166   3.171  13.020  1.00  0.00           N  
ATOM    615  CA  GLY A  43      13.841   2.012  13.832  1.00  0.00           C  
ATOM    616  C   GLY A  43      14.734   0.823  13.474  1.00  0.00           C  
ATOM    617  O   GLY A  43      14.241  -0.276  13.220  1.00  0.00           O  
ATOM    618  H   GLY A  43      14.812   3.812  13.436  1.00  0.00           H  
ATOM    619  HA2 GLY A  43      13.962   2.257  14.887  1.00  0.00           H  
ATOM    620  HA3 GLY A  43      12.795   1.742  13.685  1.00  0.00           H  
ATOM    621  N   ARG A  44      16.034   1.082  13.465  1.00  0.00           N  
ATOM    622  CA  ARG A  44      17.001   0.046  13.143  1.00  0.00           C  
ATOM    623  C   ARG A  44      18.279   0.239  13.962  1.00  0.00           C  
ATOM    624  O   ARG A  44      18.413   1.224  14.687  1.00  0.00           O  
ATOM    625  CB  ARG A  44      17.351   0.063  11.654  1.00  0.00           C  
ATOM    626  CG  ARG A  44      16.087   0.005  10.792  1.00  0.00           C  
ATOM    627  CD  ARG A  44      16.412  -0.467   9.373  1.00  0.00           C  
ATOM    628  NE  ARG A  44      16.862   0.676   8.550  1.00  0.00           N  
ATOM    629  CZ  ARG A  44      17.617   0.559   7.449  1.00  0.00           C  
ATOM    630  NH1 ARG A  44      18.010  -0.652   7.033  1.00  0.00           N  
ATOM    631  NH2 ARG A  44      17.978   1.652   6.764  1.00  0.00           N  
ATOM    632  H   ARG A  44      16.427   1.976  13.673  1.00  0.00           H  
ATOM    633  HA  ARG A  44      16.505  -0.890  13.403  1.00  0.00           H  
ATOM    634  HB2 ARG A  44      17.913   0.968  11.419  1.00  0.00           H  
ATOM    635  HB3 ARG A  44      17.996  -0.783  11.417  1.00  0.00           H  
ATOM    636  HG2 ARG A  44      15.364  -0.672  11.248  1.00  0.00           H  
ATOM    637  HG3 ARG A  44      15.623   0.991  10.754  1.00  0.00           H  
ATOM    638  HD2 ARG A  44      17.188  -1.232   9.405  1.00  0.00           H  
ATOM    639  HD3 ARG A  44      15.531  -0.925   8.924  1.00  0.00           H  
ATOM    640  HE  ARG A  44      16.587   1.596   8.833  1.00  0.00           H  
ATOM    641 HH11 ARG A  44      17.740  -1.468   7.544  1.00  0.00           H  
ATOM    642 HH12 ARG A  44      18.573  -0.740   6.211  1.00  0.00           H  
ATOM    643 HH21 ARG A  44      17.685   2.557   7.075  1.00  0.00           H  
ATOM    644 HH22 ARG A  44      18.542   1.565   5.942  1.00  0.00           H  
ATOM    645  N   GLU A  45      19.185  -0.717  13.820  1.00  0.00           N  
ATOM    646  CA  GLU A  45      20.447  -0.664  14.538  1.00  0.00           C  
ATOM    647  C   GLU A  45      21.595  -0.365  13.571  1.00  0.00           C  
ATOM    648  O   GLU A  45      21.527  -0.714  12.394  1.00  0.00           O  
ATOM    649  CB  GLU A  45      20.698  -1.966  15.302  1.00  0.00           C  
ATOM    650  CG  GLU A  45      19.541  -2.276  16.253  1.00  0.00           C  
ATOM    651  CD  GLU A  45      19.175  -3.760  16.207  1.00  0.00           C  
ATOM    652  OE1 GLU A  45      19.132  -4.300  15.080  1.00  0.00           O  
ATOM    653  OE2 GLU A  45      18.946  -4.322  17.300  1.00  0.00           O  
ATOM    654  H   GLU A  45      19.068  -1.515  13.228  1.00  0.00           H  
ATOM    655  HA  GLU A  45      20.341   0.154  15.251  1.00  0.00           H  
ATOM    656  HB2 GLU A  45      20.823  -2.788  14.596  1.00  0.00           H  
ATOM    657  HB3 GLU A  45      21.627  -1.887  15.866  1.00  0.00           H  
ATOM    658  HG2 GLU A  45      19.817  -1.996  17.270  1.00  0.00           H  
ATOM    659  HG3 GLU A  45      18.672  -1.675  15.983  1.00  0.00           H  
ATOM    660  N   GLU A  46      22.624   0.276  14.106  1.00  0.00           N  
ATOM    661  CA  GLU A  46      23.785   0.626  13.305  1.00  0.00           C  
ATOM    662  C   GLU A  46      25.048   0.611  14.169  1.00  0.00           C  
ATOM    663  O   GLU A  46      25.062   1.168  15.266  1.00  0.00           O  
ATOM    664  CB  GLU A  46      23.597   1.986  12.632  1.00  0.00           C  
ATOM    665  CG  GLU A  46      23.252   1.822  11.151  1.00  0.00           C  
ATOM    666  CD  GLU A  46      21.777   2.135  10.894  1.00  0.00           C  
ATOM    667  OE1 GLU A  46      20.934   1.430  11.489  1.00  0.00           O  
ATOM    668  OE2 GLU A  46      21.525   3.075  10.108  1.00  0.00           O  
ATOM    669  H   GLU A  46      22.672   0.555  15.065  1.00  0.00           H  
ATOM    670  HA  GLU A  46      23.852  -0.146  12.539  1.00  0.00           H  
ATOM    671  HB2 GLU A  46      22.804   2.539  13.135  1.00  0.00           H  
ATOM    672  HB3 GLU A  46      24.510   2.576  12.733  1.00  0.00           H  
ATOM    673  HG2 GLU A  46      23.877   2.484  10.552  1.00  0.00           H  
ATOM    674  HG3 GLU A  46      23.471   0.802  10.834  1.00  0.00           H  
ATOM    675  N   PHE A  47      26.080  -0.032  13.641  1.00  0.00           N  
ATOM    676  CA  PHE A  47      27.345  -0.126  14.350  1.00  0.00           C  
ATOM    677  C   PHE A  47      28.481   0.482  13.526  1.00  0.00           C  
ATOM    678  O   PHE A  47      28.719   0.071  12.390  1.00  0.00           O  
ATOM    679  CB  PHE A  47      27.627  -1.615  14.565  1.00  0.00           C  
ATOM    680  CG  PHE A  47      26.669  -2.294  15.545  1.00  0.00           C  
ATOM    681  CD1 PHE A  47      26.933  -2.272  16.879  1.00  0.00           C  
ATOM    682  CD2 PHE A  47      25.554  -2.919  15.083  1.00  0.00           C  
ATOM    683  CE1 PHE A  47      26.044  -2.902  17.790  1.00  0.00           C  
ATOM    684  CE2 PHE A  47      24.664  -3.549  15.993  1.00  0.00           C  
ATOM    685  CZ  PHE A  47      24.928  -3.528  17.327  1.00  0.00           C  
ATOM    686  H   PHE A  47      26.061  -0.482  12.748  1.00  0.00           H  
ATOM    687  HA  PHE A  47      27.236   0.429  15.281  1.00  0.00           H  
ATOM    688  HB2 PHE A  47      27.572  -2.127  13.605  1.00  0.00           H  
ATOM    689  HB3 PHE A  47      28.647  -1.732  14.931  1.00  0.00           H  
ATOM    690  HD1 PHE A  47      27.826  -1.770  17.250  1.00  0.00           H  
ATOM    691  HD2 PHE A  47      25.341  -2.937  14.014  1.00  0.00           H  
ATOM    692  HE1 PHE A  47      26.255  -2.885  18.858  1.00  0.00           H  
ATOM    693  HE2 PHE A  47      23.770  -4.052  15.622  1.00  0.00           H  
ATOM    694  HZ  PHE A  47      24.245  -4.012  18.026  1.00  0.00           H  
ATOM    695  N   TYR A  48      29.154   1.451  14.129  1.00  0.00           N  
ATOM    696  CA  TYR A  48      30.259   2.120  13.465  1.00  0.00           C  
ATOM    697  C   TYR A  48      31.499   1.223  13.427  1.00  0.00           C  
ATOM    698  O   TYR A  48      32.285   1.204  14.373  1.00  0.00           O  
ATOM    699  CB  TYR A  48      30.569   3.361  14.306  1.00  0.00           C  
ATOM    700  CG  TYR A  48      31.324   4.454  13.547  1.00  0.00           C  
ATOM    701  CD1 TYR A  48      30.912   4.827  12.284  1.00  0.00           C  
ATOM    702  CD2 TYR A  48      32.416   5.067  14.126  1.00  0.00           C  
ATOM    703  CE1 TYR A  48      31.622   5.858  11.570  1.00  0.00           C  
ATOM    704  CE2 TYR A  48      33.127   6.096  13.413  1.00  0.00           C  
ATOM    705  CZ  TYR A  48      32.694   6.440  12.170  1.00  0.00           C  
ATOM    706  OH  TYR A  48      33.366   7.413  11.496  1.00  0.00           O  
ATOM    707  H   TYR A  48      28.955   1.779  15.052  1.00  0.00           H  
ATOM    708  HA  TYR A  48      29.953   2.346  12.444  1.00  0.00           H  
ATOM    709  HB2 TYR A  48      29.632   3.774  14.682  1.00  0.00           H  
ATOM    710  HB3 TYR A  48      31.157   3.062  15.172  1.00  0.00           H  
ATOM    711  HD1 TYR A  48      30.048   4.344  11.827  1.00  0.00           H  
ATOM    712  HD2 TYR A  48      32.741   4.771  15.124  1.00  0.00           H  
ATOM    713  HE1 TYR A  48      31.308   6.161  10.572  1.00  0.00           H  
ATOM    714  HE2 TYR A  48      33.991   6.588  13.858  1.00  0.00           H  
ATOM    715  HH  TYR A  48      34.215   7.637  11.974  1.00  0.00           H  
ATOM    716  N   VAL A  49      31.635   0.503  12.323  1.00  0.00           N  
ATOM    717  CA  VAL A  49      32.766  -0.393  12.149  1.00  0.00           C  
ATOM    718  C   VAL A  49      33.852   0.315  11.337  1.00  0.00           C  
ATOM    719  O   VAL A  49      33.550   1.126  10.463  1.00  0.00           O  
ATOM    720  CB  VAL A  49      32.301  -1.703  11.510  1.00  0.00           C  
ATOM    721  CG1 VAL A  49      31.098  -2.281  12.257  1.00  0.00           C  
ATOM    722  CG2 VAL A  49      31.983  -1.508  10.027  1.00  0.00           C  
ATOM    723  H   VAL A  49      30.992   0.525  11.558  1.00  0.00           H  
ATOM    724  HA  VAL A  49      33.160  -0.622  13.139  1.00  0.00           H  
ATOM    725  HB  VAL A  49      33.118  -2.421  11.585  1.00  0.00           H  
ATOM    726 HG11 VAL A  49      31.280  -3.331  12.483  1.00  0.00           H  
ATOM    727 HG12 VAL A  49      30.948  -1.730  13.186  1.00  0.00           H  
ATOM    728 HG13 VAL A  49      30.207  -2.193  11.635  1.00  0.00           H  
ATOM    729 HG21 VAL A  49      31.665  -0.479   9.856  1.00  0.00           H  
ATOM    730 HG22 VAL A  49      32.875  -1.715   9.434  1.00  0.00           H  
ATOM    731 HG23 VAL A  49      31.185  -2.190   9.733  1.00  0.00           H  
ATOM    732  N   HIS A  50      35.095  -0.017  11.655  1.00  0.00           N  
ATOM    733  CA  HIS A  50      36.228   0.577  10.967  1.00  0.00           C  
ATOM    734  C   HIS A  50      36.990  -0.507  10.201  1.00  0.00           C  
ATOM    735  O   HIS A  50      37.451  -1.482  10.794  1.00  0.00           O  
ATOM    736  CB  HIS A  50      37.117   1.347  11.947  1.00  0.00           C  
ATOM    737  CG  HIS A  50      38.410   1.840  11.344  1.00  0.00           C  
ATOM    738  ND1 HIS A  50      38.590   3.146  10.921  1.00  0.00           N  
ATOM    739  CD2 HIS A  50      39.585   1.191  11.100  1.00  0.00           C  
ATOM    740  CE1 HIS A  50      39.821   3.265  10.445  1.00  0.00           C  
ATOM    741  NE2 HIS A  50      40.435   2.053  10.556  1.00  0.00           N  
ATOM    742  H   HIS A  50      35.332  -0.677  12.368  1.00  0.00           H  
ATOM    743  HA  HIS A  50      35.820   1.294  10.254  1.00  0.00           H  
ATOM    744  HB2 HIS A  50      36.559   2.200  12.333  1.00  0.00           H  
ATOM    745  HB3 HIS A  50      37.345   0.704  12.796  1.00  0.00           H  
ATOM    746  HD1 HIS A  50      37.908   3.875  10.968  1.00  0.00           H  
ATOM    747  HD2 HIS A  50      39.789   0.142  11.315  1.00  0.00           H  
ATOM    748  HE1 HIS A  50      40.264   4.173  10.036  1.00  0.00           H  
ATOM    749  N   TYR A  51      37.099  -0.300   8.898  1.00  0.00           N  
ATOM    750  CA  TYR A  51      37.796  -1.248   8.046  1.00  0.00           C  
ATOM    751  C   TYR A  51      39.312  -1.117   8.207  1.00  0.00           C  
ATOM    752  O   TYR A  51      39.923  -0.212   7.642  1.00  0.00           O  
ATOM    753  CB  TYR A  51      37.415  -0.884   6.610  1.00  0.00           C  
ATOM    754  CG  TYR A  51      35.982  -1.265   6.231  1.00  0.00           C  
ATOM    755  CD1 TYR A  51      35.654  -2.587   6.009  1.00  0.00           C  
ATOM    756  CD2 TYR A  51      35.017  -0.286   6.112  1.00  0.00           C  
ATOM    757  CE1 TYR A  51      34.306  -2.944   5.652  1.00  0.00           C  
ATOM    758  CE2 TYR A  51      33.669  -0.643   5.756  1.00  0.00           C  
ATOM    759  CZ  TYR A  51      33.379  -1.955   5.543  1.00  0.00           C  
ATOM    760  OH  TYR A  51      32.106  -2.293   5.207  1.00  0.00           O  
ATOM    761  H   TYR A  51      36.720   0.495   8.425  1.00  0.00           H  
ATOM    762  HA  TYR A  51      37.492  -2.253   8.341  1.00  0.00           H  
ATOM    763  HB2 TYR A  51      37.544   0.189   6.471  1.00  0.00           H  
ATOM    764  HB3 TYR A  51      38.104  -1.379   5.924  1.00  0.00           H  
ATOM    765  HD1 TYR A  51      36.416  -3.360   6.103  1.00  0.00           H  
ATOM    766  HD2 TYR A  51      35.275   0.759   6.287  1.00  0.00           H  
ATOM    767  HE1 TYR A  51      34.033  -3.985   5.474  1.00  0.00           H  
ATOM    768  HE2 TYR A  51      32.897   0.121   5.658  1.00  0.00           H  
ATOM    769  HH  TYR A  51      31.560  -1.467   5.062  1.00  0.00           H  
ATOM    770  N   VAL A  52      39.874  -2.035   8.980  1.00  0.00           N  
ATOM    771  CA  VAL A  52      41.307  -2.034   9.223  1.00  0.00           C  
ATOM    772  C   VAL A  52      42.025  -2.635   8.013  1.00  0.00           C  
ATOM    773  O   VAL A  52      42.668  -3.677   8.123  1.00  0.00           O  
ATOM    774  CB  VAL A  52      41.617  -2.769  10.528  1.00  0.00           C  
ATOM    775  CG1 VAL A  52      40.849  -2.154  11.700  1.00  0.00           C  
ATOM    776  CG2 VAL A  52      41.319  -4.264  10.400  1.00  0.00           C  
ATOM    777  H   VAL A  52      39.369  -2.768   9.436  1.00  0.00           H  
ATOM    778  HA  VAL A  52      41.620  -0.995   9.336  1.00  0.00           H  
ATOM    779  HB  VAL A  52      42.683  -2.656  10.731  1.00  0.00           H  
ATOM    780 HG11 VAL A  52      40.998  -2.762  12.591  1.00  0.00           H  
ATOM    781 HG12 VAL A  52      41.213  -1.143  11.883  1.00  0.00           H  
ATOM    782 HG13 VAL A  52      39.786  -2.118  11.458  1.00  0.00           H  
ATOM    783 HG21 VAL A  52      42.238  -4.831  10.547  1.00  0.00           H  
ATOM    784 HG22 VAL A  52      40.586  -4.554  11.154  1.00  0.00           H  
ATOM    785 HG23 VAL A  52      40.919  -4.471   9.408  1.00  0.00           H  
ATOM    786  N   GLY A  53      41.891  -1.952   6.885  1.00  0.00           N  
ATOM    787  CA  GLY A  53      42.519  -2.405   5.656  1.00  0.00           C  
ATOM    788  C   GLY A  53      41.723  -1.948   4.432  1.00  0.00           C  
ATOM    789  O   GLY A  53      41.207  -2.771   3.679  1.00  0.00           O  
ATOM    790  H   GLY A  53      41.366  -1.105   6.804  1.00  0.00           H  
ATOM    791  HA2 GLY A  53      43.536  -2.018   5.599  1.00  0.00           H  
ATOM    792  HA3 GLY A  53      42.591  -3.494   5.661  1.00  0.00           H  
ATOM    793  N   PHE A  54      41.649  -0.634   4.273  1.00  0.00           N  
ATOM    794  CA  PHE A  54      40.925  -0.056   3.152  1.00  0.00           C  
ATOM    795  C   PHE A  54      41.268   1.425   2.984  1.00  0.00           C  
ATOM    796  O   PHE A  54      41.993   1.797   2.062  1.00  0.00           O  
ATOM    797  CB  PHE A  54      39.434  -0.189   3.467  1.00  0.00           C  
ATOM    798  CG  PHE A  54      38.690  -1.163   2.552  1.00  0.00           C  
ATOM    799  CD1 PHE A  54      38.150  -0.721   1.385  1.00  0.00           C  
ATOM    800  CD2 PHE A  54      38.566  -2.470   2.906  1.00  0.00           C  
ATOM    801  CE1 PHE A  54      37.459  -1.624   0.534  1.00  0.00           C  
ATOM    802  CE2 PHE A  54      37.875  -3.374   2.057  1.00  0.00           C  
ATOM    803  CZ  PHE A  54      37.336  -2.931   0.889  1.00  0.00           C  
ATOM    804  H   PHE A  54      42.072   0.029   4.889  1.00  0.00           H  
ATOM    805  HA  PHE A  54      41.225  -0.600   2.257  1.00  0.00           H  
ATOM    806  HB2 PHE A  54      39.319  -0.518   4.500  1.00  0.00           H  
ATOM    807  HB3 PHE A  54      38.968   0.793   3.392  1.00  0.00           H  
ATOM    808  HD1 PHE A  54      38.248   0.327   1.101  1.00  0.00           H  
ATOM    809  HD2 PHE A  54      38.998  -2.825   3.841  1.00  0.00           H  
ATOM    810  HE1 PHE A  54      37.026  -1.270  -0.401  1.00  0.00           H  
ATOM    811  HE2 PHE A  54      37.776  -4.421   2.340  1.00  0.00           H  
ATOM    812  HZ  PHE A  54      36.805  -3.626   0.236  1.00  0.00           H  
ATOM    813  N   ASN A  55      40.732   2.231   3.888  1.00  0.00           N  
ATOM    814  CA  ASN A  55      40.972   3.663   3.851  1.00  0.00           C  
ATOM    815  C   ASN A  55      40.613   4.272   5.209  1.00  0.00           C  
ATOM    816  O   ASN A  55      39.883   3.665   5.991  1.00  0.00           O  
ATOM    817  CB  ASN A  55      40.107   4.340   2.786  1.00  0.00           C  
ATOM    818  CG  ASN A  55      40.965   5.166   1.827  1.00  0.00           C  
ATOM    819  OD1 ASN A  55      42.176   5.032   1.762  1.00  0.00           O  
ATOM    820  ND2 ASN A  55      40.272   6.028   1.086  1.00  0.00           N  
ATOM    821  H   ASN A  55      40.144   1.921   4.636  1.00  0.00           H  
ATOM    822  HA  ASN A  55      42.030   3.770   3.613  1.00  0.00           H  
ATOM    823  HB2 ASN A  55      39.555   3.584   2.227  1.00  0.00           H  
ATOM    824  HB3 ASN A  55      39.369   4.983   3.266  1.00  0.00           H  
ATOM    825 HD21 ASN A  55      39.280   6.089   1.188  1.00  0.00           H  
ATOM    826 HD22 ASN A  55      40.745   6.614   0.428  1.00  0.00           H  
ATOM    827  N   ARG A  56      41.142   5.463   5.446  1.00  0.00           N  
ATOM    828  CA  ARG A  56      40.885   6.161   6.695  1.00  0.00           C  
ATOM    829  C   ARG A  56      39.686   7.098   6.543  1.00  0.00           C  
ATOM    830  O   ARG A  56      39.104   7.534   7.535  1.00  0.00           O  
ATOM    831  CB  ARG A  56      42.106   6.972   7.133  1.00  0.00           C  
ATOM    832  CG  ARG A  56      43.042   6.128   8.002  1.00  0.00           C  
ATOM    833  CD  ARG A  56      42.676   6.251   9.482  1.00  0.00           C  
ATOM    834  NE  ARG A  56      43.845   6.728  10.254  1.00  0.00           N  
ATOM    835  CZ  ARG A  56      43.817   7.003  11.565  1.00  0.00           C  
ATOM    836  NH1 ARG A  56      42.680   6.852  12.258  1.00  0.00           N  
ATOM    837  NH2 ARG A  56      44.926   7.432  12.183  1.00  0.00           N  
ATOM    838  H   ARG A  56      41.734   5.950   4.803  1.00  0.00           H  
ATOM    839  HA  ARG A  56      40.677   5.371   7.416  1.00  0.00           H  
ATOM    840  HB2 ARG A  56      42.644   7.330   6.255  1.00  0.00           H  
ATOM    841  HB3 ARG A  56      41.783   7.852   7.689  1.00  0.00           H  
ATOM    842  HG2 ARG A  56      42.986   5.084   7.695  1.00  0.00           H  
ATOM    843  HG3 ARG A  56      44.073   6.449   7.851  1.00  0.00           H  
ATOM    844  HD2 ARG A  56      41.843   6.944   9.602  1.00  0.00           H  
ATOM    845  HD3 ARG A  56      42.346   5.286   9.865  1.00  0.00           H  
ATOM    846  HE  ARG A  56      44.709   6.853   9.767  1.00  0.00           H  
ATOM    847 HH11 ARG A  56      41.853   6.532  11.796  1.00  0.00           H  
ATOM    848 HH12 ARG A  56      42.661   7.057  13.236  1.00  0.00           H  
ATOM    849 HH21 ARG A  56      45.775   7.546  11.667  1.00  0.00           H  
ATOM    850 HH22 ARG A  56      44.906   7.637  13.162  1.00  0.00           H  
ATOM    851  N   ARG A  57      39.354   7.385   5.292  1.00  0.00           N  
ATOM    852  CA  ARG A  57      38.235   8.263   4.998  1.00  0.00           C  
ATOM    853  C   ARG A  57      36.949   7.450   4.839  1.00  0.00           C  
ATOM    854  O   ARG A  57      36.061   7.827   4.075  1.00  0.00           O  
ATOM    855  CB  ARG A  57      38.485   9.064   3.718  1.00  0.00           C  
ATOM    856  CG  ARG A  57      38.587   8.138   2.504  1.00  0.00           C  
ATOM    857  CD  ARG A  57      37.414   8.358   1.547  1.00  0.00           C  
ATOM    858  NE  ARG A  57      37.917   8.761   0.215  1.00  0.00           N  
ATOM    859  CZ  ARG A  57      38.396   9.981  -0.070  1.00  0.00           C  
ATOM    860  NH1 ARG A  57      38.441  10.922   0.882  1.00  0.00           N  
ATOM    861  NH2 ARG A  57      38.831  10.258  -1.307  1.00  0.00           N  
ATOM    862  H   ARG A  57      39.832   7.027   4.491  1.00  0.00           H  
ATOM    863  HA  ARG A  57      38.173   8.932   5.856  1.00  0.00           H  
ATOM    864  HB2 ARG A  57      37.676   9.778   3.567  1.00  0.00           H  
ATOM    865  HB3 ARG A  57      39.404   9.640   3.819  1.00  0.00           H  
ATOM    866  HG2 ARG A  57      39.526   8.320   1.981  1.00  0.00           H  
ATOM    867  HG3 ARG A  57      38.602   7.099   2.834  1.00  0.00           H  
ATOM    868  HD2 ARG A  57      36.827   7.444   1.461  1.00  0.00           H  
ATOM    869  HD3 ARG A  57      36.751   9.127   1.942  1.00  0.00           H  
ATOM    870  HE  ARG A  57      37.898   8.083  -0.520  1.00  0.00           H  
ATOM    871 HH11 ARG A  57      38.116  10.715   1.806  1.00  0.00           H  
ATOM    872 HH12 ARG A  57      38.798  11.831   0.670  1.00  0.00           H  
ATOM    873 HH21 ARG A  57      38.797   9.555  -2.018  1.00  0.00           H  
ATOM    874 HH22 ARG A  57      39.188  11.167  -1.519  1.00  0.00           H  
ATOM    875  N   LEU A  58      36.888   6.348   5.574  1.00  0.00           N  
ATOM    876  CA  LEU A  58      35.725   5.479   5.524  1.00  0.00           C  
ATOM    877  C   LEU A  58      35.012   5.511   6.877  1.00  0.00           C  
ATOM    878  O   LEU A  58      34.343   6.489   7.207  1.00  0.00           O  
ATOM    879  CB  LEU A  58      36.127   4.073   5.073  1.00  0.00           C  
ATOM    880  CG  LEU A  58      36.660   3.953   3.645  1.00  0.00           C  
ATOM    881  CD1 LEU A  58      37.405   2.631   3.447  1.00  0.00           C  
ATOM    882  CD2 LEU A  58      35.536   4.135   2.623  1.00  0.00           C  
ATOM    883  H   LEU A  58      37.615   6.049   6.193  1.00  0.00           H  
ATOM    884  HA  LEU A  58      35.050   5.879   4.767  1.00  0.00           H  
ATOM    885  HB2 LEU A  58      36.888   3.697   5.758  1.00  0.00           H  
ATOM    886  HB3 LEU A  58      35.260   3.420   5.173  1.00  0.00           H  
ATOM    887  HG  LEU A  58      37.379   4.755   3.480  1.00  0.00           H  
ATOM    888 HD11 LEU A  58      38.372   2.681   3.948  1.00  0.00           H  
ATOM    889 HD12 LEU A  58      36.818   1.816   3.869  1.00  0.00           H  
ATOM    890 HD13 LEU A  58      37.558   2.456   2.382  1.00  0.00           H  
ATOM    891 HD21 LEU A  58      35.224   5.180   2.609  1.00  0.00           H  
ATOM    892 HD22 LEU A  58      35.895   3.850   1.633  1.00  0.00           H  
ATOM    893 HD23 LEU A  58      34.689   3.506   2.898  1.00  0.00           H  
ATOM    894  N   ASP A  59      35.178   4.429   7.624  1.00  0.00           N  
ATOM    895  CA  ASP A  59      34.558   4.321   8.933  1.00  0.00           C  
ATOM    896  C   ASP A  59      33.098   4.768   8.840  1.00  0.00           C  
ATOM    897  O   ASP A  59      32.798   5.953   8.969  1.00  0.00           O  
ATOM    898  CB  ASP A  59      35.262   5.220   9.952  1.00  0.00           C  
ATOM    899  CG  ASP A  59      36.402   6.069   9.386  1.00  0.00           C  
ATOM    900  OD1 ASP A  59      37.489   5.490   9.172  1.00  0.00           O  
ATOM    901  OD2 ASP A  59      36.160   7.278   9.180  1.00  0.00           O  
ATOM    902  H   ASP A  59      35.724   3.638   7.348  1.00  0.00           H  
ATOM    903  HA  ASP A  59      34.657   3.272   9.211  1.00  0.00           H  
ATOM    904  HB2 ASP A  59      34.523   5.882  10.402  1.00  0.00           H  
ATOM    905  HB3 ASP A  59      35.659   4.595  10.753  1.00  0.00           H  
ATOM    906  N   GLU A  60      32.228   3.794   8.616  1.00  0.00           N  
ATOM    907  CA  GLU A  60      30.805   4.072   8.505  1.00  0.00           C  
ATOM    908  C   GLU A  60      29.999   3.045   9.302  1.00  0.00           C  
ATOM    909  O   GLU A  60      30.513   1.982   9.650  1.00  0.00           O  
ATOM    910  CB  GLU A  60      30.366   4.096   7.039  1.00  0.00           C  
ATOM    911  CG  GLU A  60      30.515   2.714   6.399  1.00  0.00           C  
ATOM    912  CD  GLU A  60      30.756   2.832   4.892  1.00  0.00           C  
ATOM    913  OE1 GLU A  60      31.398   3.828   4.496  1.00  0.00           O  
ATOM    914  OE2 GLU A  60      30.293   1.922   4.171  1.00  0.00           O  
ATOM    915  H   GLU A  60      32.480   2.831   8.513  1.00  0.00           H  
ATOM    916  HA  GLU A  60      30.670   5.065   8.934  1.00  0.00           H  
ATOM    917  HB2 GLU A  60      29.327   4.421   6.973  1.00  0.00           H  
ATOM    918  HB3 GLU A  60      30.963   4.822   6.488  1.00  0.00           H  
ATOM    919  HG2 GLU A  60      31.346   2.183   6.863  1.00  0.00           H  
ATOM    920  HG3 GLU A  60      29.616   2.126   6.582  1.00  0.00           H  
ATOM    921  N   TRP A  61      28.750   3.398   9.568  1.00  0.00           N  
ATOM    922  CA  TRP A  61      27.868   2.521  10.319  1.00  0.00           C  
ATOM    923  C   TRP A  61      27.453   1.370   9.399  1.00  0.00           C  
ATOM    924  O   TRP A  61      27.391   1.535   8.182  1.00  0.00           O  
ATOM    925  CB  TRP A  61      26.677   3.294  10.885  1.00  0.00           C  
ATOM    926  CG  TRP A  61      27.060   4.589  11.605  1.00  0.00           C  
ATOM    927  CD1 TRP A  61      27.327   5.785  11.064  1.00  0.00           C  
ATOM    928  CD2 TRP A  61      27.210   4.769  13.029  1.00  0.00           C  
ATOM    929  NE1 TRP A  61      27.637   6.721  12.031  1.00  0.00           N  
ATOM    930  CE2 TRP A  61      27.563   6.082  13.264  1.00  0.00           C  
ATOM    931  CE3 TRP A  61      27.052   3.853  14.083  1.00  0.00           C  
ATOM    932  CZ2 TRP A  61      27.788   6.598  14.546  1.00  0.00           C  
ATOM    933  CZ3 TRP A  61      27.281   4.383  15.359  1.00  0.00           C  
ATOM    934  CH2 TRP A  61      27.637   5.703  15.612  1.00  0.00           C  
ATOM    935  H   TRP A  61      28.341   4.264   9.281  1.00  0.00           H  
ATOM    936  HA  TRP A  61      28.428   2.133  11.170  1.00  0.00           H  
ATOM    937  HB2 TRP A  61      25.991   3.532  10.072  1.00  0.00           H  
ATOM    938  HB3 TRP A  61      26.135   2.651  11.579  1.00  0.00           H  
ATOM    939  HD1 TRP A  61      27.302   5.995   9.994  1.00  0.00           H  
ATOM    940  HE1 TRP A  61      27.892   7.766  11.859  1.00  0.00           H  
ATOM    941  HE3 TRP A  61      26.775   2.811  13.924  1.00  0.00           H  
ATOM    942  HZ2 TRP A  61      28.067   7.639  14.706  1.00  0.00           H  
ATOM    943  HZ3 TRP A  61      27.172   3.714  16.212  1.00  0.00           H  
ATOM    944  HH2 TRP A  61      27.798   6.039  16.636  1.00  0.00           H  
ATOM    945  N   VAL A  62      27.177   0.231  10.017  1.00  0.00           N  
ATOM    946  CA  VAL A  62      26.769  -0.946   9.270  1.00  0.00           C  
ATOM    947  C   VAL A  62      25.546  -1.574   9.943  1.00  0.00           C  
ATOM    948  O   VAL A  62      25.062  -1.068  10.954  1.00  0.00           O  
ATOM    949  CB  VAL A  62      27.944  -1.917   9.140  1.00  0.00           C  
ATOM    950  CG1 VAL A  62      29.214  -1.186   8.700  1.00  0.00           C  
ATOM    951  CG2 VAL A  62      28.174  -2.679  10.446  1.00  0.00           C  
ATOM    952  H   VAL A  62      27.230   0.105  11.008  1.00  0.00           H  
ATOM    953  HA  VAL A  62      26.488  -0.619   8.269  1.00  0.00           H  
ATOM    954  HB  VAL A  62      27.693  -2.645   8.367  1.00  0.00           H  
ATOM    955 HG11 VAL A  62      29.693  -0.735   9.570  1.00  0.00           H  
ATOM    956 HG12 VAL A  62      29.898  -1.894   8.234  1.00  0.00           H  
ATOM    957 HG13 VAL A  62      28.955  -0.406   7.985  1.00  0.00           H  
ATOM    958 HG21 VAL A  62      27.334  -3.349  10.628  1.00  0.00           H  
ATOM    959 HG22 VAL A  62      29.092  -3.260  10.371  1.00  0.00           H  
ATOM    960 HG23 VAL A  62      28.259  -1.970  11.269  1.00  0.00           H  
ATOM    961  N   ASP A  63      25.084  -2.667   9.355  1.00  0.00           N  
ATOM    962  CA  ASP A  63      23.927  -3.369   9.886  1.00  0.00           C  
ATOM    963  C   ASP A  63      24.366  -4.732  10.424  1.00  0.00           C  
ATOM    964  O   ASP A  63      25.328  -5.319   9.929  1.00  0.00           O  
ATOM    965  CB  ASP A  63      22.879  -3.605   8.797  1.00  0.00           C  
ATOM    966  CG  ASP A  63      22.071  -2.369   8.397  1.00  0.00           C  
ATOM    967  OD1 ASP A  63      21.431  -1.792   9.303  1.00  0.00           O  
ATOM    968  OD2 ASP A  63      22.110  -2.029   7.196  1.00  0.00           O  
ATOM    969  H   ASP A  63      25.483  -3.072   8.533  1.00  0.00           H  
ATOM    970  HA  ASP A  63      23.532  -2.720  10.667  1.00  0.00           H  
ATOM    971  HB2 ASP A  63      23.379  -3.996   7.910  1.00  0.00           H  
ATOM    972  HB3 ASP A  63      22.189  -4.377   9.139  1.00  0.00           H  
ATOM    973  N   LYS A  64      23.641  -5.197  11.430  1.00  0.00           N  
ATOM    974  CA  LYS A  64      23.943  -6.481  12.040  1.00  0.00           C  
ATOM    975  C   LYS A  64      24.086  -7.541  10.945  1.00  0.00           C  
ATOM    976  O   LYS A  64      25.067  -8.281  10.917  1.00  0.00           O  
ATOM    977  CB  LYS A  64      22.896  -6.829  13.100  1.00  0.00           C  
ATOM    978  CG  LYS A  64      23.012  -5.902  14.311  1.00  0.00           C  
ATOM    979  CD  LYS A  64      22.408  -6.550  15.559  1.00  0.00           C  
ATOM    980  CE  LYS A  64      23.474  -6.764  16.636  1.00  0.00           C  
ATOM    981  NZ  LYS A  64      22.850  -6.829  17.976  1.00  0.00           N  
ATOM    982  H   LYS A  64      22.860  -4.714  11.827  1.00  0.00           H  
ATOM    983  HA  LYS A  64      24.900  -6.383  12.552  1.00  0.00           H  
ATOM    984  HB2 LYS A  64      21.898  -6.751  12.671  1.00  0.00           H  
ATOM    985  HB3 LYS A  64      23.025  -7.865  13.417  1.00  0.00           H  
ATOM    986  HG2 LYS A  64      24.060  -5.664  14.493  1.00  0.00           H  
ATOM    987  HG3 LYS A  64      22.503  -4.960  14.103  1.00  0.00           H  
ATOM    988  HD2 LYS A  64      21.612  -5.917  15.952  1.00  0.00           H  
ATOM    989  HD3 LYS A  64      21.955  -7.504  15.294  1.00  0.00           H  
ATOM    990  HE2 LYS A  64      24.018  -7.688  16.437  1.00  0.00           H  
ATOM    991  HE3 LYS A  64      24.199  -5.952  16.605  1.00  0.00           H  
ATOM    992  HZ1 LYS A  64      22.066  -6.209  18.010  1.00  0.00           H  
ATOM    993  HZ2 LYS A  64      22.541  -7.765  18.156  1.00  0.00           H  
ATOM    994  HZ3 LYS A  64      23.519  -6.561  18.668  1.00  0.00           H  
ATOM    995  N   ASN A  65      23.091  -7.579  10.071  1.00  0.00           N  
ATOM    996  CA  ASN A  65      23.094  -8.535   8.976  1.00  0.00           C  
ATOM    997  C   ASN A  65      24.388  -8.381   8.173  1.00  0.00           C  
ATOM    998  O   ASN A  65      25.051  -9.370   7.864  1.00  0.00           O  
ATOM    999  CB  ASN A  65      21.918  -8.290   8.028  1.00  0.00           C  
ATOM   1000  CG  ASN A  65      20.918  -9.447   8.087  1.00  0.00           C  
ATOM   1001  OD1 ASN A  65      21.271 -10.599   8.278  1.00  0.00           O  
ATOM   1002  ND2 ASN A  65      19.652  -9.077   7.913  1.00  0.00           N  
ATOM   1003  H   ASN A  65      22.297  -6.972  10.100  1.00  0.00           H  
ATOM   1004  HA  ASN A  65      23.011  -9.513   9.450  1.00  0.00           H  
ATOM   1005  HB2 ASN A  65      21.418  -7.360   8.295  1.00  0.00           H  
ATOM   1006  HB3 ASN A  65      22.285  -8.175   7.009  1.00  0.00           H  
ATOM   1007 HD21 ASN A  65      19.429  -8.113   7.760  1.00  0.00           H  
ATOM   1008 HD22 ASN A  65      18.923  -9.761   7.935  1.00  0.00           H  
ATOM   1009  N   ARG A  66      24.706  -7.135   7.859  1.00  0.00           N  
ATOM   1010  CA  ARG A  66      25.909  -6.840   7.097  1.00  0.00           C  
ATOM   1011  C   ARG A  66      27.139  -7.416   7.803  1.00  0.00           C  
ATOM   1012  O   ARG A  66      28.156  -7.681   7.166  1.00  0.00           O  
ATOM   1013  CB  ARG A  66      26.092  -5.331   6.921  1.00  0.00           C  
ATOM   1014  CG  ARG A  66      25.103  -4.776   5.894  1.00  0.00           C  
ATOM   1015  CD  ARG A  66      25.375  -3.296   5.614  1.00  0.00           C  
ATOM   1016  NE  ARG A  66      24.196  -2.677   4.968  1.00  0.00           N  
ATOM   1017  CZ  ARG A  66      23.877  -2.839   3.676  1.00  0.00           C  
ATOM   1018  NH1 ARG A  66      24.646  -3.599   2.886  1.00  0.00           N  
ATOM   1019  NH2 ARG A  66      22.788  -2.239   3.175  1.00  0.00           N  
ATOM   1020  H   ARG A  66      24.161  -6.336   8.114  1.00  0.00           H  
ATOM   1021  HA  ARG A  66      25.751  -7.318   6.131  1.00  0.00           H  
ATOM   1022  HB2 ARG A  66      25.948  -4.828   7.877  1.00  0.00           H  
ATOM   1023  HB3 ARG A  66      27.111  -5.120   6.599  1.00  0.00           H  
ATOM   1024  HG2 ARG A  66      25.178  -5.344   4.967  1.00  0.00           H  
ATOM   1025  HG3 ARG A  66      24.084  -4.899   6.262  1.00  0.00           H  
ATOM   1026  HD2 ARG A  66      25.602  -2.778   6.546  1.00  0.00           H  
ATOM   1027  HD3 ARG A  66      26.248  -3.193   4.971  1.00  0.00           H  
ATOM   1028  HE  ARG A  66      23.599  -2.104   5.530  1.00  0.00           H  
ATOM   1029 HH11 ARG A  66      25.459  -4.046   3.260  1.00  0.00           H  
ATOM   1030 HH12 ARG A  66      24.409  -3.719   1.922  1.00  0.00           H  
ATOM   1031 HH21 ARG A  66      22.214  -1.672   3.766  1.00  0.00           H  
ATOM   1032 HH22 ARG A  66      22.550  -2.359   2.212  1.00  0.00           H  
ATOM   1033  N   LEU A  67      27.004  -7.592   9.109  1.00  0.00           N  
ATOM   1034  CA  LEU A  67      28.090  -8.132   9.909  1.00  0.00           C  
ATOM   1035  C   LEU A  67      27.952  -9.654   9.988  1.00  0.00           C  
ATOM   1036  O   LEU A  67      26.970 -10.217   9.507  1.00  0.00           O  
ATOM   1037  CB  LEU A  67      28.142  -7.447  11.275  1.00  0.00           C  
ATOM   1038  CG  LEU A  67      28.418  -5.942  11.260  1.00  0.00           C  
ATOM   1039  CD1 LEU A  67      27.771  -5.254  12.464  1.00  0.00           C  
ATOM   1040  CD2 LEU A  67      29.920  -5.660  11.178  1.00  0.00           C  
ATOM   1041  H   LEU A  67      26.171  -7.373   9.621  1.00  0.00           H  
ATOM   1042  HA  LEU A  67      29.022  -7.897   9.393  1.00  0.00           H  
ATOM   1043  HB2 LEU A  67      27.192  -7.617  11.781  1.00  0.00           H  
ATOM   1044  HB3 LEU A  67      28.914  -7.932  11.873  1.00  0.00           H  
ATOM   1045  HG  LEU A  67      27.962  -5.520  10.366  1.00  0.00           H  
ATOM   1046 HD11 LEU A  67      27.432  -6.008  13.175  1.00  0.00           H  
ATOM   1047 HD12 LEU A  67      28.500  -4.604  12.946  1.00  0.00           H  
ATOM   1048 HD13 LEU A  67      26.920  -4.661  12.130  1.00  0.00           H  
ATOM   1049 HD21 LEU A  67      30.161  -5.255  10.195  1.00  0.00           H  
ATOM   1050 HD22 LEU A  67      30.197  -4.937  11.946  1.00  0.00           H  
ATOM   1051 HD23 LEU A  67      30.473  -6.586  11.335  1.00  0.00           H  
ATOM   1052  N   ALA A  68      28.950 -10.275  10.599  1.00  0.00           N  
ATOM   1053  CA  ALA A  68      28.951 -11.721  10.748  1.00  0.00           C  
ATOM   1054  C   ALA A  68      28.658 -12.079  12.206  1.00  0.00           C  
ATOM   1055  O   ALA A  68      29.517 -11.924  13.073  1.00  0.00           O  
ATOM   1056  CB  ALA A  68      30.292 -12.282  10.269  1.00  0.00           C  
ATOM   1057  H   ALA A  68      29.744  -9.810  10.987  1.00  0.00           H  
ATOM   1058  HA  ALA A  68      28.158 -12.121  10.117  1.00  0.00           H  
ATOM   1059  HB1 ALA A  68      30.505 -11.908   9.267  1.00  0.00           H  
ATOM   1060  HB2 ALA A  68      31.082 -11.966  10.949  1.00  0.00           H  
ATOM   1061  HB3 ALA A  68      30.243 -13.371  10.247  1.00  0.00           H  
ATOM   1062  N   LEU A  69      27.441 -12.553  12.432  1.00  0.00           N  
ATOM   1063  CA  LEU A  69      27.023 -12.934  13.770  1.00  0.00           C  
ATOM   1064  C   LEU A  69      26.791 -14.446  13.816  1.00  0.00           C  
ATOM   1065  O   LEU A  69      25.755 -14.932  13.366  1.00  0.00           O  
ATOM   1066  CB  LEU A  69      25.809 -12.112  14.208  1.00  0.00           C  
ATOM   1067  CG  LEU A  69      25.953 -10.593  14.097  1.00  0.00           C  
ATOM   1068  CD1 LEU A  69      24.584  -9.919  13.979  1.00  0.00           C  
ATOM   1069  CD2 LEU A  69      26.767 -10.033  15.265  1.00  0.00           C  
ATOM   1070  H   LEU A  69      26.748 -12.676  11.722  1.00  0.00           H  
ATOM   1071  HA  LEU A  69      27.839 -12.689  14.450  1.00  0.00           H  
ATOM   1072  HB2 LEU A  69      24.952 -12.420  13.609  1.00  0.00           H  
ATOM   1073  HB3 LEU A  69      25.581 -12.361  15.244  1.00  0.00           H  
ATOM   1074  HG  LEU A  69      26.502 -10.367  13.184  1.00  0.00           H  
ATOM   1075 HD11 LEU A  69      24.086 -10.268  13.075  1.00  0.00           H  
ATOM   1076 HD12 LEU A  69      23.978 -10.173  14.849  1.00  0.00           H  
ATOM   1077 HD13 LEU A  69      24.714  -8.838  13.929  1.00  0.00           H  
ATOM   1078 HD21 LEU A  69      27.756 -10.492  15.272  1.00  0.00           H  
ATOM   1079 HD22 LEU A  69      26.869  -8.954  15.153  1.00  0.00           H  
ATOM   1080 HD23 LEU A  69      26.257 -10.254  16.204  1.00  0.00           H  
ATOM   1081  N   THR A  70      27.773 -15.147  14.363  1.00  0.00           N  
ATOM   1082  CA  THR A  70      27.688 -16.593  14.473  1.00  0.00           C  
ATOM   1083  C   THR A  70      27.798 -17.240  13.091  1.00  0.00           C  
ATOM   1084  O   THR A  70      27.560 -16.589  12.075  1.00  0.00           O  
ATOM   1085  CB  THR A  70      26.389 -16.936  15.203  1.00  0.00           C  
ATOM   1086  OG1 THR A  70      26.411 -16.106  16.360  1.00  0.00           O  
ATOM   1087  CG2 THR A  70      26.391 -18.360  15.766  1.00  0.00           C  
ATOM   1088  H   THR A  70      28.613 -14.744  14.726  1.00  0.00           H  
ATOM   1089  HA  THR A  70      28.539 -16.943  15.059  1.00  0.00           H  
ATOM   1090  HB  THR A  70      25.525 -16.775  14.557  1.00  0.00           H  
ATOM   1091  HG1 THR A  70      26.349 -15.144  16.092  1.00  0.00           H  
ATOM   1092 HG21 THR A  70      27.194 -18.461  16.495  1.00  0.00           H  
ATOM   1093 HG22 THR A  70      25.434 -18.562  16.247  1.00  0.00           H  
ATOM   1094 HG23 THR A  70      26.547 -19.071  14.954  1.00  0.00           H  
ATOM   1095  N   LYS A  71      28.161 -18.515  13.097  1.00  0.00           N  
ATOM   1096  CA  LYS A  71      28.305 -19.258  11.857  1.00  0.00           C  
ATOM   1097  C   LYS A  71      27.032 -19.101  11.022  1.00  0.00           C  
ATOM   1098  O   LYS A  71      27.066 -19.241   9.800  1.00  0.00           O  
ATOM   1099  CB  LYS A  71      28.676 -20.714  12.144  1.00  0.00           C  
ATOM   1100  CG  LYS A  71      30.195 -20.901  12.155  1.00  0.00           C  
ATOM   1101  CD  LYS A  71      30.694 -21.255  13.557  1.00  0.00           C  
ATOM   1102  CE  LYS A  71      31.995 -20.516  13.878  1.00  0.00           C  
ATOM   1103  NZ  LYS A  71      31.755 -19.456  14.881  1.00  0.00           N  
ATOM   1104  H   LYS A  71      28.352 -19.038  13.928  1.00  0.00           H  
ATOM   1105  HA  LYS A  71      29.136 -18.816  11.306  1.00  0.00           H  
ATOM   1106  HB2 LYS A  71      28.262 -21.016  13.107  1.00  0.00           H  
ATOM   1107  HB3 LYS A  71      28.231 -21.362  11.390  1.00  0.00           H  
ATOM   1108  HG2 LYS A  71      30.472 -21.690  11.456  1.00  0.00           H  
ATOM   1109  HG3 LYS A  71      30.679 -19.988  11.811  1.00  0.00           H  
ATOM   1110  HD2 LYS A  71      29.933 -20.996  14.294  1.00  0.00           H  
ATOM   1111  HD3 LYS A  71      30.855 -22.331  13.628  1.00  0.00           H  
ATOM   1112  HE2 LYS A  71      32.737 -21.221  14.254  1.00  0.00           H  
ATOM   1113  HE3 LYS A  71      32.405 -20.077  12.968  1.00  0.00           H  
ATOM   1114  HZ1 LYS A  71      32.537 -19.401  15.503  1.00  0.00           H  
ATOM   1115  HZ2 LYS A  71      31.635 -18.578  14.417  1.00  0.00           H  
ATOM   1116  HZ3 LYS A  71      30.929 -19.672  15.404  1.00  0.00           H  
ATOM   1117  N   THR A  72      25.941 -18.812  11.714  1.00  0.00           N  
ATOM   1118  CA  THR A  72      24.660 -18.634  11.052  1.00  0.00           C  
ATOM   1119  C   THR A  72      24.844 -17.893   9.726  1.00  0.00           C  
ATOM   1120  O   THR A  72      24.354 -18.339   8.689  1.00  0.00           O  
ATOM   1121  CB  THR A  72      23.721 -17.916  12.024  1.00  0.00           C  
ATOM   1122  OG1 THR A  72      23.177 -18.966  12.820  1.00  0.00           O  
ATOM   1123  CG2 THR A  72      22.502 -17.311  11.322  1.00  0.00           C  
ATOM   1124  H   THR A  72      25.922 -18.699  12.708  1.00  0.00           H  
ATOM   1125  HA  THR A  72      24.256 -19.618  10.815  1.00  0.00           H  
ATOM   1126  HB  THR A  72      24.257 -17.159  12.595  1.00  0.00           H  
ATOM   1127  HG1 THR A  72      22.801 -19.682  12.232  1.00  0.00           H  
ATOM   1128 HG21 THR A  72      22.833 -16.695  10.487  1.00  0.00           H  
ATOM   1129 HG22 THR A  72      21.863 -18.111  10.952  1.00  0.00           H  
ATOM   1130 HG23 THR A  72      21.945 -16.697  12.028  1.00  0.00           H  
ATOM   1131  N   VAL A  73      25.549 -16.775   9.802  1.00  0.00           N  
ATOM   1132  CA  VAL A  73      25.803 -15.968   8.621  1.00  0.00           C  
ATOM   1133  C   VAL A  73      27.313 -15.862   8.396  1.00  0.00           C  
ATOM   1134  O   VAL A  73      28.075 -15.692   9.347  1.00  0.00           O  
ATOM   1135  CB  VAL A  73      25.122 -14.604   8.761  1.00  0.00           C  
ATOM   1136  CG1 VAL A  73      23.628 -14.766   9.048  1.00  0.00           C  
ATOM   1137  CG2 VAL A  73      25.800 -13.763   9.844  1.00  0.00           C  
ATOM   1138  H   VAL A  73      25.943 -16.419  10.650  1.00  0.00           H  
ATOM   1139  HA  VAL A  73      25.357 -16.481   7.769  1.00  0.00           H  
ATOM   1140  HB  VAL A  73      25.227 -14.078   7.813  1.00  0.00           H  
ATOM   1141 HG11 VAL A  73      23.292 -15.739   8.691  1.00  0.00           H  
ATOM   1142 HG12 VAL A  73      23.453 -14.691  10.121  1.00  0.00           H  
ATOM   1143 HG13 VAL A  73      23.073 -13.980   8.534  1.00  0.00           H  
ATOM   1144 HG21 VAL A  73      25.444 -12.734   9.780  1.00  0.00           H  
ATOM   1145 HG22 VAL A  73      25.559 -14.169  10.826  1.00  0.00           H  
ATOM   1146 HG23 VAL A  73      26.880 -13.783   9.698  1.00  0.00           H  
ATOM   1147  N   LYS A  74      27.700 -15.965   7.133  1.00  0.00           N  
ATOM   1148  CA  LYS A  74      29.104 -15.883   6.772  1.00  0.00           C  
ATOM   1149  C   LYS A  74      29.257 -16.150   5.272  1.00  0.00           C  
ATOM   1150  O   LYS A  74      28.276 -16.432   4.586  1.00  0.00           O  
ATOM   1151  CB  LYS A  74      29.939 -16.818   7.650  1.00  0.00           C  
ATOM   1152  CG  LYS A  74      30.863 -16.021   8.573  1.00  0.00           C  
ATOM   1153  CD  LYS A  74      31.536 -16.936   9.598  1.00  0.00           C  
ATOM   1154  CE  LYS A  74      32.849 -17.500   9.052  1.00  0.00           C  
ATOM   1155  NZ  LYS A  74      32.600 -18.741   8.285  1.00  0.00           N  
ATOM   1156  H   LYS A  74      27.073 -16.103   6.366  1.00  0.00           H  
ATOM   1157  HA  LYS A  74      29.436 -14.866   6.977  1.00  0.00           H  
ATOM   1158  HB2 LYS A  74      29.280 -17.448   8.246  1.00  0.00           H  
ATOM   1159  HB3 LYS A  74      30.532 -17.481   7.021  1.00  0.00           H  
ATOM   1160  HG2 LYS A  74      31.624 -15.511   7.982  1.00  0.00           H  
ATOM   1161  HG3 LYS A  74      30.291 -15.249   9.090  1.00  0.00           H  
ATOM   1162  HD2 LYS A  74      31.729 -16.380  10.516  1.00  0.00           H  
ATOM   1163  HD3 LYS A  74      30.864 -17.754   9.857  1.00  0.00           H  
ATOM   1164  HE2 LYS A  74      33.330 -16.761   8.412  1.00  0.00           H  
ATOM   1165  HE3 LYS A  74      33.534 -17.705   9.874  1.00  0.00           H  
ATOM   1166  HZ1 LYS A  74      32.591 -18.533   7.307  1.00  0.00           H  
ATOM   1167  HZ2 LYS A  74      33.323 -19.403   8.478  1.00  0.00           H  
ATOM   1168  HZ3 LYS A  74      31.716 -19.126   8.552  1.00  0.00           H  
ATOM   1169  N   ASP A  75      30.495 -16.048   4.809  1.00  0.00           N  
ATOM   1170  CA  ASP A  75      30.788 -16.275   3.404  1.00  0.00           C  
ATOM   1171  C   ASP A  75      30.425 -17.715   3.037  1.00  0.00           C  
ATOM   1172  O   ASP A  75      29.732 -17.952   2.049  1.00  0.00           O  
ATOM   1173  CB  ASP A  75      32.277 -16.074   3.114  1.00  0.00           C  
ATOM   1174  CG  ASP A  75      32.738 -16.559   1.738  1.00  0.00           C  
ATOM   1175  OD1 ASP A  75      31.847 -16.868   0.917  1.00  0.00           O  
ATOM   1176  OD2 ASP A  75      33.971 -16.611   1.539  1.00  0.00           O  
ATOM   1177  H   ASP A  75      31.286 -15.818   5.375  1.00  0.00           H  
ATOM   1178  HA  ASP A  75      30.187 -15.542   2.865  1.00  0.00           H  
ATOM   1179  HB2 ASP A  75      32.509 -15.013   3.205  1.00  0.00           H  
ATOM   1180  HB3 ASP A  75      32.854 -16.594   3.878  1.00  0.00           H  
ATOM   1181  N   ALA A  76      30.908 -18.640   3.854  1.00  0.00           N  
ATOM   1182  CA  ALA A  76      30.644 -20.050   3.627  1.00  0.00           C  
ATOM   1183  C   ALA A  76      31.239 -20.868   4.774  1.00  0.00           C  
ATOM   1184  O   ALA A  76      32.421 -20.731   5.091  1.00  0.00           O  
ATOM   1185  CB  ALA A  76      31.204 -20.464   2.265  1.00  0.00           C  
ATOM   1186  H   ALA A  76      31.471 -18.439   4.655  1.00  0.00           H  
ATOM   1187  HA  ALA A  76      29.562 -20.188   3.617  1.00  0.00           H  
ATOM   1188  HB1 ALA A  76      30.927 -21.497   2.055  1.00  0.00           H  
ATOM   1189  HB2 ALA A  76      30.796 -19.813   1.491  1.00  0.00           H  
ATOM   1190  HB3 ALA A  76      32.291 -20.374   2.277  1.00  0.00           H  
ATOM   1191  N   VAL A  77      30.395 -21.700   5.367  1.00  0.00           N  
ATOM   1192  CA  VAL A  77      30.824 -22.538   6.473  1.00  0.00           C  
ATOM   1193  C   VAL A  77      31.292 -23.890   5.931  1.00  0.00           C  
ATOM   1194  O   VAL A  77      31.005 -24.932   6.517  1.00  0.00           O  
ATOM   1195  CB  VAL A  77      29.697 -22.665   7.501  1.00  0.00           C  
ATOM   1196  CG1 VAL A  77      29.313 -21.296   8.066  1.00  0.00           C  
ATOM   1197  CG2 VAL A  77      28.481 -23.370   6.897  1.00  0.00           C  
ATOM   1198  H   VAL A  77      29.436 -21.804   5.104  1.00  0.00           H  
ATOM   1199  HA  VAL A  77      31.665 -22.042   6.955  1.00  0.00           H  
ATOM   1200  HB  VAL A  77      30.063 -23.277   8.326  1.00  0.00           H  
ATOM   1201 HG11 VAL A  77      30.122 -20.922   8.693  1.00  0.00           H  
ATOM   1202 HG12 VAL A  77      29.139 -20.600   7.244  1.00  0.00           H  
ATOM   1203 HG13 VAL A  77      28.405 -21.390   8.660  1.00  0.00           H  
ATOM   1204 HG21 VAL A  77      28.408 -24.380   7.301  1.00  0.00           H  
ATOM   1205 HG22 VAL A  77      27.577 -22.814   7.147  1.00  0.00           H  
ATOM   1206 HG23 VAL A  77      28.591 -23.419   5.814  1.00  0.00           H  
ATOM   1207  N   GLN A  78      32.007 -23.829   4.816  1.00  0.00           N  
ATOM   1208  CA  GLN A  78      32.518 -25.035   4.188  1.00  0.00           C  
ATOM   1209  C   GLN A  78      33.703 -25.587   4.984  1.00  0.00           C  
ATOM   1210  O   GLN A  78      33.682 -26.737   5.417  1.00  0.00           O  
ATOM   1211  CB  GLN A  78      32.911 -24.771   2.733  1.00  0.00           C  
ATOM   1212  CG  GLN A  78      32.190 -25.734   1.787  1.00  0.00           C  
ATOM   1213  CD  GLN A  78      32.735 -25.615   0.363  1.00  0.00           C  
ATOM   1214  OE1 GLN A  78      33.855 -25.995   0.066  1.00  0.00           O  
ATOM   1215  NE2 GLN A  78      31.882 -25.068  -0.498  1.00  0.00           N  
ATOM   1216  H   GLN A  78      32.237 -22.977   4.346  1.00  0.00           H  
ATOM   1217  HA  GLN A  78      31.693 -25.746   4.212  1.00  0.00           H  
ATOM   1218  HB2 GLN A  78      32.665 -23.743   2.467  1.00  0.00           H  
ATOM   1219  HB3 GLN A  78      33.988 -24.881   2.617  1.00  0.00           H  
ATOM   1220  HG2 GLN A  78      32.311 -26.757   2.143  1.00  0.00           H  
ATOM   1221  HG3 GLN A  78      31.121 -25.521   1.790  1.00  0.00           H  
ATOM   1222 HE21 GLN A  78      30.977 -24.777  -0.190  1.00  0.00           H  
ATOM   1223 HE22 GLN A  78      32.147 -24.947  -1.455  1.00  0.00           H  
ATOM   1224  N   LYS A  79      34.708 -24.739   5.152  1.00  0.00           N  
ATOM   1225  CA  LYS A  79      35.899 -25.127   5.888  1.00  0.00           C  
ATOM   1226  C   LYS A  79      35.724 -24.759   7.363  1.00  0.00           C  
ATOM   1227  O   LYS A  79      35.513 -25.632   8.203  1.00  0.00           O  
ATOM   1228  CB  LYS A  79      37.147 -24.519   5.246  1.00  0.00           C  
ATOM   1229  CG  LYS A  79      38.406 -25.282   5.665  1.00  0.00           C  
ATOM   1230  CD  LYS A  79      39.560 -25.009   4.698  1.00  0.00           C  
ATOM   1231  CE  LYS A  79      39.773 -26.191   3.752  1.00  0.00           C  
ATOM   1232  NZ  LYS A  79      39.242 -25.882   2.407  1.00  0.00           N  
ATOM   1233  H   LYS A  79      34.716 -23.805   4.797  1.00  0.00           H  
ATOM   1234  HA  LYS A  79      35.991 -26.210   5.812  1.00  0.00           H  
ATOM   1235  HB2 LYS A  79      37.050 -24.540   4.161  1.00  0.00           H  
ATOM   1236  HB3 LYS A  79      37.238 -23.472   5.538  1.00  0.00           H  
ATOM   1237  HG2 LYS A  79      38.695 -24.987   6.674  1.00  0.00           H  
ATOM   1238  HG3 LYS A  79      38.196 -26.350   5.693  1.00  0.00           H  
ATOM   1239  HD2 LYS A  79      39.349 -24.109   4.119  1.00  0.00           H  
ATOM   1240  HD3 LYS A  79      40.473 -24.818   5.261  1.00  0.00           H  
ATOM   1241  HE2 LYS A  79      40.837 -26.424   3.685  1.00  0.00           H  
ATOM   1242  HE3 LYS A  79      39.279 -27.077   4.151  1.00  0.00           H  
ATOM   1243  HZ1 LYS A  79      39.768 -26.380   1.717  1.00  0.00           H  
ATOM   1244  HZ2 LYS A  79      38.282 -26.157   2.356  1.00  0.00           H  
ATOM   1245  HZ3 LYS A  79      39.316 -24.899   2.237  1.00  0.00           H  
ATOM   1246  N   ASN A  80      35.819 -23.465   7.632  1.00  0.00           N  
ATOM   1247  CA  ASN A  80      35.675 -22.971   8.990  1.00  0.00           C  
ATOM   1248  C   ASN A  80      36.815 -23.519   9.852  1.00  0.00           C  
ATOM   1249  O   ASN A  80      36.828 -24.700  10.194  1.00  0.00           O  
ATOM   1250  CB  ASN A  80      34.354 -23.433   9.608  1.00  0.00           C  
ATOM   1251  CG  ASN A  80      33.874 -22.450  10.678  1.00  0.00           C  
ATOM   1252  OD1 ASN A  80      33.058 -21.577  10.435  1.00  0.00           O  
ATOM   1253  ND2 ASN A  80      34.425 -22.641  11.873  1.00  0.00           N  
ATOM   1254  H   ASN A  80      35.992 -22.762   6.943  1.00  0.00           H  
ATOM   1255  HA  ASN A  80      35.702 -21.885   8.905  1.00  0.00           H  
ATOM   1256  HB2 ASN A  80      33.597 -23.525   8.828  1.00  0.00           H  
ATOM   1257  HB3 ASN A  80      34.479 -24.423  10.047  1.00  0.00           H  
ATOM   1258 HD21 ASN A  80      35.090 -23.376  12.006  1.00  0.00           H  
ATOM   1259 HD22 ASN A  80      34.176 -22.048  12.638  1.00  0.00           H  
ATOM   1260  N   SER A  81      37.746 -22.633  10.178  1.00  0.00           N  
ATOM   1261  CA  SER A  81      38.887 -23.013  10.993  1.00  0.00           C  
ATOM   1262  C   SER A  81      39.137 -21.955  12.069  1.00  0.00           C  
ATOM   1263  O   SER A  81      39.583 -20.849  11.767  1.00  0.00           O  
ATOM   1264  CB  SER A  81      40.140 -23.200  10.133  1.00  0.00           C  
ATOM   1265  OG  SER A  81      41.288 -23.502  10.921  1.00  0.00           O  
ATOM   1266  H   SER A  81      37.728 -21.674   9.895  1.00  0.00           H  
ATOM   1267  HA  SER A  81      38.614 -23.964  11.447  1.00  0.00           H  
ATOM   1268  HB2 SER A  81      39.970 -24.004   9.416  1.00  0.00           H  
ATOM   1269  HB3 SER A  81      40.323 -22.293   9.557  1.00  0.00           H  
ATOM   1270  HG  SER A  81      41.623 -22.673  11.369  1.00  0.00           H  
ATOM   1271  N   GLU A  82      38.837 -22.332  13.304  1.00  0.00           N  
ATOM   1272  CA  GLU A  82      39.023 -21.428  14.427  1.00  0.00           C  
ATOM   1273  C   GLU A  82      39.169 -22.222  15.727  1.00  0.00           C  
ATOM   1274  O   GLU A  82      38.640 -23.326  15.848  1.00  0.00           O  
ATOM   1275  CB  GLU A  82      37.869 -20.427  14.523  1.00  0.00           C  
ATOM   1276  CG  GLU A  82      38.363 -18.999  14.290  1.00  0.00           C  
ATOM   1277  CD  GLU A  82      37.262 -18.131  13.677  1.00  0.00           C  
ATOM   1278  OE1 GLU A  82      36.087 -18.376  14.027  1.00  0.00           O  
ATOM   1279  OE2 GLU A  82      37.620 -17.243  12.874  1.00  0.00           O  
ATOM   1280  H   GLU A  82      38.474 -23.233  13.541  1.00  0.00           H  
ATOM   1281  HA  GLU A  82      39.946 -20.890  14.217  1.00  0.00           H  
ATOM   1282  HB2 GLU A  82      37.105 -20.677  13.788  1.00  0.00           H  
ATOM   1283  HB3 GLU A  82      37.402 -20.499  15.505  1.00  0.00           H  
ATOM   1284  HG2 GLU A  82      38.691 -18.564  15.234  1.00  0.00           H  
ATOM   1285  HG3 GLU A  82      39.230 -19.013  13.628  1.00  0.00           H  
ATOM   1286  N   LYS A  83      39.890 -21.629  16.668  1.00  0.00           N  
ATOM   1287  CA  LYS A  83      40.112 -22.266  17.953  1.00  0.00           C  
ATOM   1288  C   LYS A  83      38.839 -22.162  18.797  1.00  0.00           C  
ATOM   1289  O   LYS A  83      37.798 -21.729  18.305  1.00  0.00           O  
ATOM   1290  CB  LYS A  83      41.351 -21.681  18.635  1.00  0.00           C  
ATOM   1291  CG  LYS A  83      42.626 -22.358  18.129  1.00  0.00           C  
ATOM   1292  CD  LYS A  83      43.837 -21.438  18.295  1.00  0.00           C  
ATOM   1293  CE  LYS A  83      45.053 -22.216  18.799  1.00  0.00           C  
ATOM   1294  NZ  LYS A  83      46.199 -21.306  19.015  1.00  0.00           N  
ATOM   1295  H   LYS A  83      40.317 -20.731  16.562  1.00  0.00           H  
ATOM   1296  HA  LYS A  83      40.316 -23.320  17.765  1.00  0.00           H  
ATOM   1297  HB2 LYS A  83      41.403 -20.609  18.444  1.00  0.00           H  
ATOM   1298  HB3 LYS A  83      41.271 -21.808  19.715  1.00  0.00           H  
ATOM   1299  HG2 LYS A  83      42.792 -23.285  18.678  1.00  0.00           H  
ATOM   1300  HG3 LYS A  83      42.508 -22.625  17.079  1.00  0.00           H  
ATOM   1301  HD2 LYS A  83      44.074 -20.966  17.341  1.00  0.00           H  
ATOM   1302  HD3 LYS A  83      43.598 -20.637  18.994  1.00  0.00           H  
ATOM   1303  HE2 LYS A  83      44.806 -22.726  19.731  1.00  0.00           H  
ATOM   1304  HE3 LYS A  83      45.324 -22.988  18.078  1.00  0.00           H  
ATOM   1305  HZ1 LYS A  83      47.048 -21.771  18.762  1.00  0.00           H  
ATOM   1306  HZ2 LYS A  83      46.087 -20.488  18.451  1.00  0.00           H  
ATOM   1307  HZ3 LYS A  83      46.239 -21.043  19.980  1.00  0.00           H  
ATOM   1308  N   TYR A  84      38.965 -22.568  20.052  1.00  0.00           N  
ATOM   1309  CA  TYR A  84      37.838 -22.525  20.968  1.00  0.00           C  
ATOM   1310  C   TYR A  84      38.123 -21.592  22.146  1.00  0.00           C  
ATOM   1311  O   TYR A  84      39.263 -21.179  22.353  1.00  0.00           O  
ATOM   1312  CB  TYR A  84      37.668 -23.952  21.494  1.00  0.00           C  
ATOM   1313  CG  TYR A  84      36.268 -24.255  22.030  1.00  0.00           C  
ATOM   1314  CD1 TYR A  84      35.901 -23.824  23.288  1.00  0.00           C  
ATOM   1315  CD2 TYR A  84      35.369 -24.961  21.253  1.00  0.00           C  
ATOM   1316  CE1 TYR A  84      34.583 -24.109  23.792  1.00  0.00           C  
ATOM   1317  CE2 TYR A  84      34.051 -25.246  21.758  1.00  0.00           C  
ATOM   1318  CZ  TYR A  84      33.723 -24.806  23.002  1.00  0.00           C  
ATOM   1319  OH  TYR A  84      32.478 -25.076  23.478  1.00  0.00           O  
ATOM   1320  H   TYR A  84      39.815 -22.919  20.444  1.00  0.00           H  
ATOM   1321  HA  TYR A  84      36.972 -22.154  20.420  1.00  0.00           H  
ATOM   1322  HB2 TYR A  84      37.899 -24.654  20.692  1.00  0.00           H  
ATOM   1323  HB3 TYR A  84      38.394 -24.125  22.287  1.00  0.00           H  
ATOM   1324  HD1 TYR A  84      36.610 -23.267  23.900  1.00  0.00           H  
ATOM   1325  HD2 TYR A  84      35.659 -25.302  20.259  1.00  0.00           H  
ATOM   1326  HE1 TYR A  84      34.281 -23.774  24.785  1.00  0.00           H  
ATOM   1327  HE2 TYR A  84      33.333 -25.802  21.155  1.00  0.00           H  
ATOM   1328  HH  TYR A  84      31.868 -24.304  23.297  1.00  0.00           H  
ATOM   1329  N   LEU A  85      37.067 -21.286  22.886  1.00  0.00           N  
ATOM   1330  CA  LEU A  85      37.190 -20.407  24.037  1.00  0.00           C  
ATOM   1331  C   LEU A  85      38.509 -20.697  24.756  1.00  0.00           C  
ATOM   1332  O   LEU A  85      38.768 -21.831  25.155  1.00  0.00           O  
ATOM   1333  CB  LEU A  85      35.959 -20.531  24.938  1.00  0.00           C  
ATOM   1334  CG  LEU A  85      36.079 -21.513  26.106  1.00  0.00           C  
ATOM   1335  CD1 LEU A  85      37.084 -21.010  27.145  1.00  0.00           C  
ATOM   1336  CD2 LEU A  85      34.708 -21.797  26.725  1.00  0.00           C  
ATOM   1337  H   LEU A  85      36.143 -21.626  22.710  1.00  0.00           H  
ATOM   1338  HA  LEU A  85      37.216 -19.383  23.666  1.00  0.00           H  
ATOM   1339  HB2 LEU A  85      35.728 -19.545  25.341  1.00  0.00           H  
ATOM   1340  HB3 LEU A  85      35.112 -20.830  24.323  1.00  0.00           H  
ATOM   1341  HG  LEU A  85      36.461 -22.458  25.720  1.00  0.00           H  
ATOM   1342 HD11 LEU A  85      36.606 -20.969  28.123  1.00  0.00           H  
ATOM   1343 HD12 LEU A  85      37.936 -21.689  27.184  1.00  0.00           H  
ATOM   1344 HD13 LEU A  85      37.427 -20.013  26.865  1.00  0.00           H  
ATOM   1345 HD21 LEU A  85      33.965 -21.136  26.281  1.00  0.00           H  
ATOM   1346 HD22 LEU A  85      34.433 -22.834  26.535  1.00  0.00           H  
ATOM   1347 HD23 LEU A  85      34.753 -21.624  27.800  1.00  0.00           H  
ATOM   1348  N   SER A  86      39.310 -19.651  24.898  1.00  0.00           N  
ATOM   1349  CA  SER A  86      40.597 -19.778  25.561  1.00  0.00           C  
ATOM   1350  C   SER A  86      40.565 -19.054  26.909  1.00  0.00           C  
ATOM   1351  O   SER A  86      40.964 -17.893  27.004  1.00  0.00           O  
ATOM   1352  CB  SER A  86      41.724 -19.224  24.687  1.00  0.00           C  
ATOM   1353  OG  SER A  86      42.850 -20.096  24.654  1.00  0.00           O  
ATOM   1354  H   SER A  86      39.092 -18.732  24.571  1.00  0.00           H  
ATOM   1355  HA  SER A  86      40.742 -20.848  25.706  1.00  0.00           H  
ATOM   1356  HB2 SER A  86      41.354 -19.070  23.673  1.00  0.00           H  
ATOM   1357  HB3 SER A  86      42.031 -18.250  25.067  1.00  0.00           H  
ATOM   1358  HG  SER A  86      43.672 -19.606  24.943  1.00  0.00           H  
ATOM   1359  N   GLU A  87      40.087 -19.767  27.918  1.00  0.00           N  
ATOM   1360  CA  GLU A  87      39.998 -19.207  29.255  1.00  0.00           C  
ATOM   1361  C   GLU A  87      39.879 -20.325  30.292  1.00  0.00           C  
ATOM   1362  O   GLU A  87      38.965 -21.146  30.222  1.00  0.00           O  
ATOM   1363  CB  GLU A  87      38.825 -18.231  29.363  1.00  0.00           C  
ATOM   1364  CG  GLU A  87      38.793 -17.564  30.740  1.00  0.00           C  
ATOM   1365  CD  GLU A  87      37.719 -18.194  31.629  1.00  0.00           C  
ATOM   1366  OE1 GLU A  87      36.592 -18.370  31.119  1.00  0.00           O  
ATOM   1367  OE2 GLU A  87      38.050 -18.484  32.799  1.00  0.00           O  
ATOM   1368  H   GLU A  87      39.765 -20.710  27.832  1.00  0.00           H  
ATOM   1369  HA  GLU A  87      40.931 -18.663  29.403  1.00  0.00           H  
ATOM   1370  HB2 GLU A  87      38.909 -17.469  28.588  1.00  0.00           H  
ATOM   1371  HB3 GLU A  87      37.889 -18.761  29.190  1.00  0.00           H  
ATOM   1372  HG2 GLU A  87      39.769 -17.660  31.218  1.00  0.00           H  
ATOM   1373  HG3 GLU A  87      38.598 -16.497  30.627  1.00  0.00           H  
ATOM   1374  N   LEU A  88      40.815 -20.323  31.230  1.00  0.00           N  
ATOM   1375  CA  LEU A  88      40.826 -21.327  32.280  1.00  0.00           C  
ATOM   1376  C   LEU A  88      41.081 -20.647  33.627  1.00  0.00           C  
ATOM   1377  O   LEU A  88      41.933 -19.766  33.730  1.00  0.00           O  
ATOM   1378  CB  LEU A  88      41.827 -22.435  31.951  1.00  0.00           C  
ATOM   1379  CG  LEU A  88      41.448 -23.358  30.791  1.00  0.00           C  
ATOM   1380  CD1 LEU A  88      40.150 -24.109  31.088  1.00  0.00           C  
ATOM   1381  CD2 LEU A  88      41.372 -22.581  29.474  1.00  0.00           C  
ATOM   1382  H   LEU A  88      41.555 -19.652  31.279  1.00  0.00           H  
ATOM   1383  HA  LEU A  88      39.836 -21.783  32.306  1.00  0.00           H  
ATOM   1384  HB2 LEU A  88      42.789 -21.974  31.724  1.00  0.00           H  
ATOM   1385  HB3 LEU A  88      41.970 -23.046  32.843  1.00  0.00           H  
ATOM   1386  HG  LEU A  88      42.234 -24.105  30.678  1.00  0.00           H  
ATOM   1387 HD11 LEU A  88      40.310 -25.179  30.956  1.00  0.00           H  
ATOM   1388 HD12 LEU A  88      39.844 -23.913  32.115  1.00  0.00           H  
ATOM   1389 HD13 LEU A  88      39.369 -23.772  30.405  1.00  0.00           H  
ATOM   1390 HD21 LEU A  88      41.813 -21.593  29.610  1.00  0.00           H  
ATOM   1391 HD22 LEU A  88      41.921 -23.120  28.702  1.00  0.00           H  
ATOM   1392 HD23 LEU A  88      40.331 -22.477  29.173  1.00  0.00           H  
ATOM   1393  N   ALA A  89      40.327 -21.082  34.625  1.00  0.00           N  
ATOM   1394  CA  ALA A  89      40.462 -20.527  35.961  1.00  0.00           C  
ATOM   1395  C   ALA A  89      39.615 -21.347  36.937  1.00  0.00           C  
ATOM   1396  O   ALA A  89      39.007 -22.344  36.550  1.00  0.00           O  
ATOM   1397  CB  ALA A  89      40.063 -19.050  35.943  1.00  0.00           C  
ATOM   1398  H   ALA A  89      39.636 -21.799  34.533  1.00  0.00           H  
ATOM   1399  HA  ALA A  89      41.510 -20.604  36.249  1.00  0.00           H  
ATOM   1400  HB1 ALA A  89      40.715 -18.506  35.260  1.00  0.00           H  
ATOM   1401  HB2 ALA A  89      39.030 -18.957  35.609  1.00  0.00           H  
ATOM   1402  HB3 ALA A  89      40.159 -18.635  36.946  1.00  0.00           H  
ATOM   1403  N   GLU A  90      39.604 -20.897  38.184  1.00  0.00           N  
ATOM   1404  CA  GLU A  90      38.841 -21.577  39.217  1.00  0.00           C  
ATOM   1405  C   GLU A  90      37.342 -21.383  38.987  1.00  0.00           C  
ATOM   1406  O   GLU A  90      36.784 -20.348  39.349  1.00  0.00           O  
ATOM   1407  CB  GLU A  90      39.250 -21.089  40.609  1.00  0.00           C  
ATOM   1408  CG  GLU A  90      38.887 -22.120  41.679  1.00  0.00           C  
ATOM   1409  CD  GLU A  90      39.375 -21.673  43.059  1.00  0.00           C  
ATOM   1410  OE1 GLU A  90      40.607 -21.521  43.204  1.00  0.00           O  
ATOM   1411  OE2 GLU A  90      38.504 -21.492  43.938  1.00  0.00           O  
ATOM   1412  H   GLU A  90      40.101 -20.086  38.489  1.00  0.00           H  
ATOM   1413  HA  GLU A  90      39.097 -22.632  39.119  1.00  0.00           H  
ATOM   1414  HB2 GLU A  90      40.323 -20.899  40.631  1.00  0.00           H  
ATOM   1415  HB3 GLU A  90      38.755 -20.143  40.827  1.00  0.00           H  
ATOM   1416  HG2 GLU A  90      37.806 -22.262  41.700  1.00  0.00           H  
ATOM   1417  HG3 GLU A  90      39.331 -23.083  41.428  1.00  0.00           H  
ATOM   1418  N   GLN A  91      36.732 -22.393  38.384  1.00  0.00           N  
ATOM   1419  CA  GLN A  91      35.308 -22.346  38.101  1.00  0.00           C  
ATOM   1420  C   GLN A  91      34.510 -22.251  39.403  1.00  0.00           C  
ATOM   1421  O   GLN A  91      34.951 -22.739  40.442  1.00  0.00           O  
ATOM   1422  CB  GLN A  91      34.872 -23.561  37.279  1.00  0.00           C  
ATOM   1423  CG  GLN A  91      34.884 -24.831  38.131  1.00  0.00           C  
ATOM   1424  CD  GLN A  91      35.886 -25.850  37.584  1.00  0.00           C  
ATOM   1425  OE1 GLN A  91      36.675 -25.568  36.697  1.00  0.00           O  
ATOM   1426  NE2 GLN A  91      35.810 -27.047  38.160  1.00  0.00           N  
ATOM   1427  H   GLN A  91      37.194 -23.231  38.093  1.00  0.00           H  
ATOM   1428  HA  GLN A  91      35.160 -21.443  37.509  1.00  0.00           H  
ATOM   1429  HB2 GLN A  91      33.872 -23.395  36.879  1.00  0.00           H  
ATOM   1430  HB3 GLN A  91      35.539 -23.685  36.425  1.00  0.00           H  
ATOM   1431  HG2 GLN A  91      35.139 -24.582  39.160  1.00  0.00           H  
ATOM   1432  HG3 GLN A  91      33.886 -25.271  38.148  1.00  0.00           H  
ATOM   1433 HE21 GLN A  91      35.139 -27.212  38.881  1.00  0.00           H  
ATOM   1434 HE22 GLN A  91      36.425 -27.780  37.870  1.00  0.00           H  
ATOM   1435  N   PRO A  92      33.320 -21.601  39.301  1.00  0.00           N  
ATOM   1436  CA  PRO A  92      32.456 -21.435  40.458  1.00  0.00           C  
ATOM   1437  C   PRO A  92      31.751 -22.747  40.808  1.00  0.00           C  
ATOM   1438  O   PRO A  92      30.883 -23.206  40.068  1.00  0.00           O  
ATOM   1439  CB  PRO A  92      31.492 -20.326  40.073  1.00  0.00           C  
ATOM   1440  CG  PRO A  92      31.547 -20.232  38.557  1.00  0.00           C  
ATOM   1441  CD  PRO A  92      32.766 -21.010  38.086  1.00  0.00           C  
ATOM   1442  HA  PRO A  92      32.998 -21.193  41.264  1.00  0.00           H  
ATOM   1443  HB2 PRO A  92      30.481 -20.552  40.414  1.00  0.00           H  
ATOM   1444  HB3 PRO A  92      31.779 -19.381  40.534  1.00  0.00           H  
ATOM   1445  HG2 PRO A  92      30.639 -20.642  38.116  1.00  0.00           H  
ATOM   1446  HG3 PRO A  92      31.614 -19.192  38.241  1.00  0.00           H  
ATOM   1447  HD2 PRO A  92      32.491 -21.777  37.363  1.00  0.00           H  
ATOM   1448  HD3 PRO A  92      33.489 -20.356  37.599  1.00  0.00           H  
ATOM   1449  N   GLU A  93      32.150 -23.313  41.938  1.00  0.00           N  
ATOM   1450  CA  GLU A  93      31.567 -24.563  42.395  1.00  0.00           C  
ATOM   1451  C   GLU A  93      31.870 -24.778  43.879  1.00  0.00           C  
ATOM   1452  O   GLU A  93      33.010 -25.052  44.250  1.00  0.00           O  
ATOM   1453  CB  GLU A  93      32.067 -25.740  41.556  1.00  0.00           C  
ATOM   1454  CG  GLU A  93      31.208 -26.985  41.792  1.00  0.00           C  
ATOM   1455  CD  GLU A  93      31.878 -27.932  42.789  1.00  0.00           C  
ATOM   1456  OE1 GLU A  93      32.754 -28.702  42.340  1.00  0.00           O  
ATOM   1457  OE2 GLU A  93      31.499 -27.865  43.979  1.00  0.00           O  
ATOM   1458  H   GLU A  93      32.857 -22.933  42.535  1.00  0.00           H  
ATOM   1459  HA  GLU A  93      30.492 -24.451  42.249  1.00  0.00           H  
ATOM   1460  HB2 GLU A  93      32.045 -25.475  40.499  1.00  0.00           H  
ATOM   1461  HB3 GLU A  93      33.104 -25.957  41.809  1.00  0.00           H  
ATOM   1462  HG2 GLU A  93      30.229 -26.689  42.168  1.00  0.00           H  
ATOM   1463  HG3 GLU A  93      31.044 -27.502  40.846  1.00  0.00           H  
ATOM   1464  N   ARG A  94      30.830 -24.647  44.688  1.00  0.00           N  
ATOM   1465  CA  ARG A  94      30.971 -24.824  46.124  1.00  0.00           C  
ATOM   1466  C   ARG A  94      29.641 -25.266  46.738  1.00  0.00           C  
ATOM   1467  O   ARG A  94      28.578 -25.017  46.170  1.00  0.00           O  
ATOM   1468  CB  ARG A  94      31.430 -23.529  46.796  1.00  0.00           C  
ATOM   1469  CG  ARG A  94      30.392 -22.420  46.615  1.00  0.00           C  
ATOM   1470  CD  ARG A  94      30.726 -21.208  47.487  1.00  0.00           C  
ATOM   1471  NE  ARG A  94      30.548 -19.961  46.711  1.00  0.00           N  
ATOM   1472  CZ  ARG A  94      30.891 -18.745  47.155  1.00  0.00           C  
ATOM   1473  NH1 ARG A  94      31.431 -18.603  48.373  1.00  0.00           N  
ATOM   1474  NH2 ARG A  94      30.694 -17.668  46.382  1.00  0.00           N  
ATOM   1475  H   ARG A  94      29.905 -24.425  44.379  1.00  0.00           H  
ATOM   1476  HA  ARG A  94      31.730 -25.598  46.236  1.00  0.00           H  
ATOM   1477  HB2 ARG A  94      31.597 -23.706  47.859  1.00  0.00           H  
ATOM   1478  HB3 ARG A  94      32.382 -23.213  46.373  1.00  0.00           H  
ATOM   1479  HG2 ARG A  94      30.354 -22.119  45.568  1.00  0.00           H  
ATOM   1480  HG3 ARG A  94      29.402 -22.797  46.874  1.00  0.00           H  
ATOM   1481  HD2 ARG A  94      30.082 -21.194  48.367  1.00  0.00           H  
ATOM   1482  HD3 ARG A  94      31.752 -21.281  47.846  1.00  0.00           H  
ATOM   1483  HE  ARG A  94      30.147 -20.031  45.797  1.00  0.00           H  
ATOM   1484 HH11 ARG A  94      31.579 -19.407  48.951  1.00  0.00           H  
ATOM   1485 HH12 ARG A  94      31.687 -17.696  48.705  1.00  0.00           H  
ATOM   1486 HH21 ARG A  94      30.290 -17.773  45.473  1.00  0.00           H  
ATOM   1487 HH22 ARG A  94      30.950 -16.760  46.713  1.00  0.00           H  
ATOM   1488  N   LYS A  95      29.743 -25.915  47.888  1.00  0.00           N  
ATOM   1489  CA  LYS A  95      28.561 -26.394  48.585  1.00  0.00           C  
ATOM   1490  C   LYS A  95      28.968 -26.940  49.955  1.00  0.00           C  
ATOM   1491  O   LYS A  95      29.025 -28.153  50.152  1.00  0.00           O  
ATOM   1492  CB  LYS A  95      27.803 -27.404  47.721  1.00  0.00           C  
ATOM   1493  CG  LYS A  95      26.300 -27.350  48.006  1.00  0.00           C  
ATOM   1494  CD  LYS A  95      25.592 -26.404  47.034  1.00  0.00           C  
ATOM   1495  CE  LYS A  95      25.010 -25.196  47.772  1.00  0.00           C  
ATOM   1496  NZ  LYS A  95      23.759 -24.746  47.122  1.00  0.00           N  
ATOM   1497  H   LYS A  95      30.611 -26.115  48.342  1.00  0.00           H  
ATOM   1498  HA  LYS A  95      27.902 -25.540  48.735  1.00  0.00           H  
ATOM   1499  HB2 LYS A  95      27.985 -27.196  46.667  1.00  0.00           H  
ATOM   1500  HB3 LYS A  95      28.177 -28.409  47.916  1.00  0.00           H  
ATOM   1501  HG2 LYS A  95      25.875 -28.350  47.921  1.00  0.00           H  
ATOM   1502  HG3 LYS A  95      26.133 -27.017  49.030  1.00  0.00           H  
ATOM   1503  HD2 LYS A  95      26.295 -26.066  46.273  1.00  0.00           H  
ATOM   1504  HD3 LYS A  95      24.795 -26.938  46.518  1.00  0.00           H  
ATOM   1505  HE2 LYS A  95      24.813 -25.457  48.811  1.00  0.00           H  
ATOM   1506  HE3 LYS A  95      25.735 -24.383  47.779  1.00  0.00           H  
ATOM   1507  HZ1 LYS A  95      22.974 -25.039  47.669  1.00  0.00           H  
ATOM   1508  HZ2 LYS A  95      23.760 -23.749  47.050  1.00  0.00           H  
ATOM   1509  HZ3 LYS A  95      23.695 -25.146  46.208  1.00  0.00           H  
ATOM   1510  N   ILE A  96      29.242 -26.019  50.866  1.00  0.00           N  
ATOM   1511  CA  ILE A  96      29.642 -26.391  52.212  1.00  0.00           C  
ATOM   1512  C   ILE A  96      28.491 -27.132  52.895  1.00  0.00           C  
ATOM   1513  O   ILE A  96      27.376 -27.166  52.377  1.00  0.00           O  
ATOM   1514  CB  ILE A  96      30.130 -25.165  52.986  1.00  0.00           C  
ATOM   1515  CG1 ILE A  96      30.835 -25.578  54.280  1.00  0.00           C  
ATOM   1516  CG2 ILE A  96      28.981 -24.188  53.245  1.00  0.00           C  
ATOM   1517  CD1 ILE A  96      31.711 -24.443  54.813  1.00  0.00           C  
ATOM   1518  H   ILE A  96      29.195 -25.034  50.698  1.00  0.00           H  
ATOM   1519  HA  ILE A  96      30.488 -27.074  52.124  1.00  0.00           H  
ATOM   1520  HB  ILE A  96      30.864 -24.644  52.372  1.00  0.00           H  
ATOM   1521 HG12 ILE A  96      30.093 -25.852  55.030  1.00  0.00           H  
ATOM   1522 HG13 ILE A  96      31.447 -26.461  54.100  1.00  0.00           H  
ATOM   1523 HG21 ILE A  96      28.049 -24.618  52.879  1.00  0.00           H  
ATOM   1524 HG22 ILE A  96      28.898 -24.000  54.315  1.00  0.00           H  
ATOM   1525 HG23 ILE A  96      29.177 -23.251  52.724  1.00  0.00           H  
ATOM   1526 HD11 ILE A  96      32.251 -24.785  55.696  1.00  0.00           H  
ATOM   1527 HD12 ILE A  96      32.424 -24.144  54.044  1.00  0.00           H  
ATOM   1528 HD13 ILE A  96      31.084 -23.592  55.077  1.00  0.00           H  
ATOM   1529  N   THR A  97      28.801 -27.709  54.047  1.00  0.00           N  
ATOM   1530  CA  THR A  97      27.805 -28.447  54.806  1.00  0.00           C  
ATOM   1531  C   THR A  97      28.320 -28.739  56.217  1.00  0.00           C  
ATOM   1532  O   THR A  97      29.526 -28.723  56.458  1.00  0.00           O  
ATOM   1533  CB  THR A  97      27.449 -29.708  54.016  1.00  0.00           C  
ATOM   1534  OG1 THR A  97      26.472 -30.359  54.825  1.00  0.00           O  
ATOM   1535  CG2 THR A  97      28.607 -30.707  53.954  1.00  0.00           C  
ATOM   1536  H   THR A  97      29.710 -27.677  54.461  1.00  0.00           H  
ATOM   1537  HA  THR A  97      26.920 -27.820  54.911  1.00  0.00           H  
ATOM   1538  HB  THR A  97      27.098 -29.455  53.016  1.00  0.00           H  
ATOM   1539  HG1 THR A  97      26.267 -31.264  54.452  1.00  0.00           H  
ATOM   1540 HG21 THR A  97      28.233 -31.710  54.157  1.00  0.00           H  
ATOM   1541 HG22 THR A  97      29.056 -30.680  52.961  1.00  0.00           H  
ATOM   1542 HG23 THR A  97      29.356 -30.441  54.699  1.00  0.00           H  
ATOM   1543  N   ARG A  98      27.379 -28.998  57.113  1.00  0.00           N  
ATOM   1544  CA  ARG A  98      27.721 -29.293  58.494  1.00  0.00           C  
ATOM   1545  C   ARG A  98      26.452 -29.517  59.319  1.00  0.00           C  
ATOM   1546  O   ARG A  98      25.368 -29.090  58.926  1.00  0.00           O  
ATOM   1547  CB  ARG A  98      28.531 -28.153  59.116  1.00  0.00           C  
ATOM   1548  CG  ARG A  98      29.998 -28.551  59.285  1.00  0.00           C  
ATOM   1549  CD  ARG A  98      30.390 -28.586  60.764  1.00  0.00           C  
ATOM   1550  NE  ARG A  98      31.585 -29.438  60.950  1.00  0.00           N  
ATOM   1551  CZ  ARG A  98      31.566 -30.777  60.916  1.00  0.00           C  
ATOM   1552  NH1 ARG A  98      30.412 -31.425  60.702  1.00  0.00           N  
ATOM   1553  NH2 ARG A  98      32.700 -31.469  61.096  1.00  0.00           N  
ATOM   1554  H   ARG A  98      26.400 -29.009  56.909  1.00  0.00           H  
ATOM   1555  HA  ARG A  98      28.323 -30.200  58.445  1.00  0.00           H  
ATOM   1556  HB2 ARG A  98      28.461 -27.266  58.486  1.00  0.00           H  
ATOM   1557  HB3 ARG A  98      28.108 -27.888  60.085  1.00  0.00           H  
ATOM   1558  HG2 ARG A  98      30.167 -29.531  58.838  1.00  0.00           H  
ATOM   1559  HG3 ARG A  98      30.634 -27.843  58.753  1.00  0.00           H  
ATOM   1560  HD2 ARG A  98      30.595 -27.576  61.118  1.00  0.00           H  
ATOM   1561  HD3 ARG A  98      29.562 -28.971  61.359  1.00  0.00           H  
ATOM   1562  HE  ARG A  98      32.463 -28.986  61.113  1.00  0.00           H  
ATOM   1563 HH11 ARG A  98      29.567 -30.910  60.569  1.00  0.00           H  
ATOM   1564 HH12 ARG A  98      30.398 -32.425  60.677  1.00  0.00           H  
ATOM   1565 HH21 ARG A  98      33.560 -30.986  61.256  1.00  0.00           H  
ATOM   1566 HH22 ARG A  98      32.685 -32.469  61.071  1.00  0.00           H  
ATOM   1567  N   ASN A  99      26.631 -30.186  60.449  1.00  0.00           N  
ATOM   1568  CA  ASN A  99      25.514 -30.473  61.333  1.00  0.00           C  
ATOM   1569  C   ASN A  99      25.991 -31.369  62.478  1.00  0.00           C  
ATOM   1570  O   ASN A  99      26.928 -32.148  62.311  1.00  0.00           O  
ATOM   1571  CB  ASN A  99      24.398 -31.210  60.590  1.00  0.00           C  
ATOM   1572  CG  ASN A  99      24.943 -32.445  59.868  1.00  0.00           C  
ATOM   1573  OD1 ASN A  99      25.319 -33.435  60.475  1.00  0.00           O  
ATOM   1574  ND2 ASN A  99      24.964 -32.332  58.543  1.00  0.00           N  
ATOM   1575  H   ASN A  99      27.515 -30.531  60.762  1.00  0.00           H  
ATOM   1576  HA  ASN A  99      25.167 -29.500  61.681  1.00  0.00           H  
ATOM   1577  HB2 ASN A  99      23.623 -31.509  61.295  1.00  0.00           H  
ATOM   1578  HB3 ASN A  99      23.931 -30.540  59.869  1.00  0.00           H  
ATOM   1579 HD21 ASN A  99      24.642 -31.491  58.108  1.00  0.00           H  
ATOM   1580 HD22 ASN A  99      25.304 -33.087  57.982  1.00  0.00           H  
ATOM   1581  N   GLN A 100      25.326 -31.226  63.615  1.00  0.00           N  
ATOM   1582  CA  GLN A 100      25.672 -32.013  64.787  1.00  0.00           C  
ATOM   1583  C   GLN A 100      24.667 -31.757  65.912  1.00  0.00           C  
ATOM   1584  O   GLN A 100      23.939 -30.766  65.886  1.00  0.00           O  
ATOM   1585  CB  GLN A 100      27.099 -31.713  65.247  1.00  0.00           C  
ATOM   1586  CG  GLN A 100      27.837 -33.000  65.620  1.00  0.00           C  
ATOM   1587  CD  GLN A 100      28.505 -33.624  64.393  1.00  0.00           C  
ATOM   1588  OE1 GLN A 100      29.592 -33.247  63.987  1.00  0.00           O  
ATOM   1589  NE2 GLN A 100      27.797 -34.598  63.828  1.00  0.00           N  
ATOM   1590  H   GLN A 100      24.566 -30.590  63.742  1.00  0.00           H  
ATOM   1591  HA  GLN A 100      25.611 -33.053  64.466  1.00  0.00           H  
ATOM   1592  HB2 GLN A 100      27.640 -31.197  64.454  1.00  0.00           H  
ATOM   1593  HB3 GLN A 100      27.075 -31.042  66.106  1.00  0.00           H  
ATOM   1594  HG2 GLN A 100      28.589 -32.786  66.379  1.00  0.00           H  
ATOM   1595  HG3 GLN A 100      27.137 -33.712  66.059  1.00  0.00           H  
ATOM   1596 HE21 GLN A 100      26.911 -34.859  64.211  1.00  0.00           H  
ATOM   1597 HE22 GLN A 100      28.149 -35.068  63.019  1.00  0.00           H  
ATOM   1598  N   LYS A 101      24.661 -32.668  66.875  1.00  0.00           N  
ATOM   1599  CA  LYS A 101      23.758 -32.553  68.007  1.00  0.00           C  
ATOM   1600  C   LYS A 101      24.076 -33.654  69.022  1.00  0.00           C  
ATOM   1601  O   LYS A 101      24.870 -34.549  68.740  1.00  0.00           O  
ATOM   1602  CB  LYS A 101      22.302 -32.554  67.535  1.00  0.00           C  
ATOM   1603  CG  LYS A 101      21.917 -33.913  66.948  1.00  0.00           C  
ATOM   1604  CD  LYS A 101      21.284 -34.812  68.012  1.00  0.00           C  
ATOM   1605  CE  LYS A 101      19.789 -35.003  67.750  1.00  0.00           C  
ATOM   1606  NZ  LYS A 101      19.407 -36.421  67.943  1.00  0.00           N  
ATOM   1607  H   LYS A 101      25.256 -33.471  66.888  1.00  0.00           H  
ATOM   1608  HA  LYS A 101      23.943 -31.587  68.476  1.00  0.00           H  
ATOM   1609  HB2 LYS A 101      21.644 -32.315  68.370  1.00  0.00           H  
ATOM   1610  HB3 LYS A 101      22.159 -31.776  66.785  1.00  0.00           H  
ATOM   1611  HG2 LYS A 101      21.218 -33.772  66.123  1.00  0.00           H  
ATOM   1612  HG3 LYS A 101      22.801 -34.399  66.536  1.00  0.00           H  
ATOM   1613  HD2 LYS A 101      21.783 -35.780  68.021  1.00  0.00           H  
ATOM   1614  HD3 LYS A 101      21.430 -34.370  68.998  1.00  0.00           H  
ATOM   1615  HE2 LYS A 101      19.211 -34.369  68.421  1.00  0.00           H  
ATOM   1616  HE3 LYS A 101      19.550 -34.692  66.733  1.00  0.00           H  
ATOM   1617  HZ1 LYS A 101      18.972 -36.765  67.112  1.00  0.00           H  
ATOM   1618  HZ2 LYS A 101      20.224 -36.961  68.142  1.00  0.00           H  
ATOM   1619  HZ3 LYS A 101      18.766 -36.491  68.708  1.00  0.00           H  
ATOM   1620  N   ARG A 102      23.438 -33.551  70.178  1.00  0.00           N  
ATOM   1621  CA  ARG A 102      23.643 -34.527  71.235  1.00  0.00           C  
ATOM   1622  C   ARG A 102      22.752 -34.202  72.436  1.00  0.00           C  
ATOM   1623  O   ARG A 102      22.499 -33.035  72.728  1.00  0.00           O  
ATOM   1624  CB  ARG A 102      25.106 -34.553  71.684  1.00  0.00           C  
ATOM   1625  CG  ARG A 102      25.585 -35.989  71.907  1.00  0.00           C  
ATOM   1626  CD  ARG A 102      27.110 -36.076  71.828  1.00  0.00           C  
ATOM   1627  NE  ARG A 102      27.592 -37.232  72.618  1.00  0.00           N  
ATOM   1628  CZ  ARG A 102      28.883 -37.471  72.887  1.00  0.00           C  
ATOM   1629  NH1 ARG A 102      29.828 -36.639  72.430  1.00  0.00           N  
ATOM   1630  NH2 ARG A 102      29.228 -38.545  73.611  1.00  0.00           N  
ATOM   1631  H   ARG A 102      22.793 -32.819  70.398  1.00  0.00           H  
ATOM   1632  HA  ARG A 102      23.367 -35.483  70.789  1.00  0.00           H  
ATOM   1633  HB2 ARG A 102      25.729 -34.071  70.932  1.00  0.00           H  
ATOM   1634  HB3 ARG A 102      25.216 -33.982  72.605  1.00  0.00           H  
ATOM   1635  HG2 ARG A 102      25.247 -36.342  72.881  1.00  0.00           H  
ATOM   1636  HG3 ARG A 102      25.140 -36.645  71.158  1.00  0.00           H  
ATOM   1637  HD2 ARG A 102      27.424 -36.179  70.790  1.00  0.00           H  
ATOM   1638  HD3 ARG A 102      27.555 -35.156  72.206  1.00  0.00           H  
ATOM   1639  HE  ARG A 102      26.913 -37.873  72.973  1.00  0.00           H  
ATOM   1640 HH11 ARG A 102      29.570 -35.838  71.890  1.00  0.00           H  
ATOM   1641 HH12 ARG A 102      30.791 -36.819  72.631  1.00  0.00           H  
ATOM   1642 HH21 ARG A 102      28.523 -39.167  73.951  1.00  0.00           H  
ATOM   1643 HH22 ARG A 102      30.191 -38.725  73.811  1.00  0.00           H  
ATOM   1644  N   LYS A 103      22.305 -35.257  73.102  1.00  0.00           N  
ATOM   1645  CA  LYS A 103      21.448 -35.100  74.265  1.00  0.00           C  
ATOM   1646  C   LYS A 103      21.589 -36.328  75.166  1.00  0.00           C  
ATOM   1647  O   LYS A 103      21.710 -37.450  74.677  1.00  0.00           O  
ATOM   1648  CB  LYS A 103      20.008 -34.812  73.835  1.00  0.00           C  
ATOM   1649  CG  LYS A 103      19.643 -33.347  74.084  1.00  0.00           C  
ATOM   1650  CD  LYS A 103      18.835 -33.194  75.373  1.00  0.00           C  
ATOM   1651  CE  LYS A 103      19.339 -32.009  76.199  1.00  0.00           C  
ATOM   1652  NZ  LYS A 103      20.358 -32.454  77.175  1.00  0.00           N  
ATOM   1653  H   LYS A 103      22.516 -36.204  72.857  1.00  0.00           H  
ATOM   1654  HA  LYS A 103      21.801 -34.226  74.814  1.00  0.00           H  
ATOM   1655  HB2 LYS A 103      19.886 -35.048  72.778  1.00  0.00           H  
ATOM   1656  HB3 LYS A 103      19.325 -35.459  74.386  1.00  0.00           H  
ATOM   1657  HG2 LYS A 103      20.552 -32.749  74.147  1.00  0.00           H  
ATOM   1658  HG3 LYS A 103      19.067 -32.964  73.241  1.00  0.00           H  
ATOM   1659  HD2 LYS A 103      17.781 -33.051  75.132  1.00  0.00           H  
ATOM   1660  HD3 LYS A 103      18.905 -34.109  75.962  1.00  0.00           H  
ATOM   1661  HE2 LYS A 103      19.764 -31.254  75.539  1.00  0.00           H  
ATOM   1662  HE3 LYS A 103      18.505 -31.542  76.722  1.00  0.00           H  
ATOM   1663  HZ1 LYS A 103      21.018 -31.718  77.328  1.00  0.00           H  
ATOM   1664  HZ2 LYS A 103      19.912 -32.686  78.040  1.00  0.00           H  
ATOM   1665  HZ3 LYS A 103      20.832 -33.259  76.819  1.00  0.00           H  
ATOM   1666  N   HIS A 104      21.566 -36.075  76.467  1.00  0.00           N  
ATOM   1667  CA  HIS A 104      21.688 -37.145  77.440  1.00  0.00           C  
ATOM   1668  C   HIS A 104      20.967 -36.751  78.731  1.00  0.00           C  
ATOM   1669  O   HIS A 104      20.650 -35.581  78.936  1.00  0.00           O  
ATOM   1670  CB  HIS A 104      23.158 -37.507  77.669  1.00  0.00           C  
ATOM   1671  CG  HIS A 104      24.020 -36.338  78.079  1.00  0.00           C  
ATOM   1672  ND1 HIS A 104      25.317 -36.166  77.624  1.00  0.00           N  
ATOM   1673  CD2 HIS A 104      23.760 -35.284  78.905  1.00  0.00           C  
ATOM   1674  CE1 HIS A 104      25.804 -35.056  78.161  1.00  0.00           C  
ATOM   1675  NE2 HIS A 104      24.838 -34.512  78.954  1.00  0.00           N  
ATOM   1676  H   HIS A 104      21.466 -35.159  76.856  1.00  0.00           H  
ATOM   1677  HA  HIS A 104      21.195 -38.016  77.010  1.00  0.00           H  
ATOM   1678  HB2 HIS A 104      23.217 -38.276  78.438  1.00  0.00           H  
ATOM   1679  HB3 HIS A 104      23.561 -37.938  76.753  1.00  0.00           H  
ATOM   1680  HD1 HIS A 104      25.802 -36.775  76.998  1.00  0.00           H  
ATOM   1681  HD2 HIS A 104      22.824 -35.107  79.436  1.00  0.00           H  
ATOM   1682  HE1 HIS A 104      26.802 -34.651  77.995  1.00  0.00           H  
ATOM   1683  N   ASP A 105      20.729 -37.751  79.567  1.00  0.00           N  
ATOM   1684  CA  ASP A 105      20.052 -37.523  80.832  1.00  0.00           C  
ATOM   1685  C   ASP A 105      20.008 -38.831  81.624  1.00  0.00           C  
ATOM   1686  O   ASP A 105      20.296 -39.898  81.085  1.00  0.00           O  
ATOM   1687  CB  ASP A 105      18.612 -37.057  80.609  1.00  0.00           C  
ATOM   1688  CG  ASP A 105      17.702 -38.075  79.921  1.00  0.00           C  
ATOM   1689  OD1 ASP A 105      17.218 -38.979  80.636  1.00  0.00           O  
ATOM   1690  OD2 ASP A 105      17.510 -37.926  78.694  1.00  0.00           O  
ATOM   1691  H   ASP A 105      20.991 -38.700  79.392  1.00  0.00           H  
ATOM   1692  HA  ASP A 105      20.634 -36.750  81.334  1.00  0.00           H  
ATOM   1693  HB2 ASP A 105      18.177 -36.797  81.575  1.00  0.00           H  
ATOM   1694  HB3 ASP A 105      18.630 -36.145  80.012  1.00  0.00           H  
ATOM   1695  N   GLU A 106      19.646 -38.705  82.893  1.00  0.00           N  
ATOM   1696  CA  GLU A 106      19.560 -39.864  83.765  1.00  0.00           C  
ATOM   1697  C   GLU A 106      18.602 -39.586  84.926  1.00  0.00           C  
ATOM   1698  O   GLU A 106      18.617 -38.498  85.500  1.00  0.00           O  
ATOM   1699  CB  GLU A 106      20.944 -40.265  84.281  1.00  0.00           C  
ATOM   1700  CG  GLU A 106      20.932 -41.692  84.832  1.00  0.00           C  
ATOM   1701  CD  GLU A 106      21.990 -41.868  85.922  1.00  0.00           C  
ATOM   1702  OE1 GLU A 106      22.069 -40.970  86.788  1.00  0.00           O  
ATOM   1703  OE2 GLU A 106      22.698 -42.898  85.865  1.00  0.00           O  
ATOM   1704  H   GLU A 106      19.413 -37.833  83.324  1.00  0.00           H  
ATOM   1705  HA  GLU A 106      19.164 -40.666  83.143  1.00  0.00           H  
ATOM   1706  HB2 GLU A 106      21.673 -40.190  83.474  1.00  0.00           H  
ATOM   1707  HB3 GLU A 106      21.261 -39.572  85.061  1.00  0.00           H  
ATOM   1708  HG2 GLU A 106      19.945 -41.920  85.238  1.00  0.00           H  
ATOM   1709  HG3 GLU A 106      21.115 -42.400  84.023  1.00  0.00           H  
ATOM   1710  N   ILE A 107      17.792 -40.587  85.235  1.00  0.00           N  
ATOM   1711  CA  ILE A 107      16.830 -40.464  86.317  1.00  0.00           C  
ATOM   1712  C   ILE A 107      17.544 -40.664  87.655  1.00  0.00           C  
ATOM   1713  O   ILE A 107      18.742 -40.943  87.688  1.00  0.00           O  
ATOM   1714  CB  ILE A 107      15.654 -41.417  86.098  1.00  0.00           C  
ATOM   1715  CG1 ILE A 107      16.123 -42.873  86.091  1.00  0.00           C  
ATOM   1716  CG2 ILE A 107      14.884 -41.057  84.826  1.00  0.00           C  
ATOM   1717  CD1 ILE A 107      15.768 -43.570  87.407  1.00  0.00           C  
ATOM   1718  H   ILE A 107      17.787 -41.469  84.763  1.00  0.00           H  
ATOM   1719  HA  ILE A 107      16.433 -39.449  86.286  1.00  0.00           H  
ATOM   1720  HB  ILE A 107      14.963 -41.305  86.934  1.00  0.00           H  
ATOM   1721 HG12 ILE A 107      15.661 -43.404  85.258  1.00  0.00           H  
ATOM   1722 HG13 ILE A 107      17.201 -42.911  85.935  1.00  0.00           H  
ATOM   1723 HG21 ILE A 107      13.916 -41.558  84.832  1.00  0.00           H  
ATOM   1724 HG22 ILE A 107      14.735 -39.978  84.784  1.00  0.00           H  
ATOM   1725 HG23 ILE A 107      15.454 -41.377  83.953  1.00  0.00           H  
ATOM   1726 HD11 ILE A 107      16.589 -43.452  88.113  1.00  0.00           H  
ATOM   1727 HD12 ILE A 107      14.864 -43.124  87.822  1.00  0.00           H  
ATOM   1728 HD13 ILE A 107      15.596 -44.631  87.221  1.00  0.00           H  
ATOM   1729  N   ASN A 108      16.779 -40.514  88.726  1.00  0.00           N  
ATOM   1730  CA  ASN A 108      17.323 -40.676  90.064  1.00  0.00           C  
ATOM   1731  C   ASN A 108      16.183 -40.626  91.083  1.00  0.00           C  
ATOM   1732  O   ASN A 108      15.125 -40.060  90.810  1.00  0.00           O  
ATOM   1733  CB  ASN A 108      18.305 -39.551  90.398  1.00  0.00           C  
ATOM   1734  CG  ASN A 108      19.738 -39.949  90.036  1.00  0.00           C  
ATOM   1735  OD1 ASN A 108      20.049 -41.107  89.807  1.00  0.00           O  
ATOM   1736  ND2 ASN A 108      20.589 -38.928  89.996  1.00  0.00           N  
ATOM   1737  H   ASN A 108      15.805 -40.287  88.690  1.00  0.00           H  
ATOM   1738  HA  ASN A 108      17.829 -41.641  90.052  1.00  0.00           H  
ATOM   1739  HB2 ASN A 108      18.027 -38.648  89.855  1.00  0.00           H  
ATOM   1740  HB3 ASN A 108      18.247 -39.316  91.460  1.00  0.00           H  
ATOM   1741 HD21 ASN A 108      20.268 -38.002  90.194  1.00  0.00           H  
ATOM   1742 HD22 ASN A 108      21.550 -39.088  89.768  1.00  0.00           H  
ATOM   1743  N   HIS A 109      16.437 -41.225  92.237  1.00  0.00           N  
ATOM   1744  CA  HIS A 109      15.446 -41.256  93.299  1.00  0.00           C  
ATOM   1745  C   HIS A 109      16.061 -41.869  94.558  1.00  0.00           C  
ATOM   1746  O   HIS A 109      17.116 -42.497  94.495  1.00  0.00           O  
ATOM   1747  CB  HIS A 109      14.182 -41.988  92.840  1.00  0.00           C  
ATOM   1748  CG  HIS A 109      12.925 -41.547  93.553  1.00  0.00           C  
ATOM   1749  ND1 HIS A 109      12.008 -40.678  92.987  1.00  0.00           N  
ATOM   1750  CD2 HIS A 109      12.443 -41.865  94.789  1.00  0.00           C  
ATOM   1751  CE1 HIS A 109      11.023 -40.488  93.853  1.00  0.00           C  
ATOM   1752  NE2 HIS A 109      11.295 -41.224  94.968  1.00  0.00           N  
ATOM   1753  H   HIS A 109      17.300 -41.684  92.451  1.00  0.00           H  
ATOM   1754  HA  HIS A 109      15.174 -40.221  93.503  1.00  0.00           H  
ATOM   1755  HB2 HIS A 109      14.053 -41.833  91.769  1.00  0.00           H  
ATOM   1756  HB3 HIS A 109      14.318 -43.058  92.994  1.00  0.00           H  
ATOM   1757  HD1 HIS A 109      12.077 -40.264  92.080  1.00  0.00           H  
ATOM   1758  HD2 HIS A 109      12.920 -42.533  95.506  1.00  0.00           H  
ATOM   1759  HE1 HIS A 109      10.150 -39.854  93.700  1.00  0.00           H  
ATOM   1760  N   VAL A 110      15.375 -41.664  95.673  1.00  0.00           N  
ATOM   1761  CA  VAL A 110      15.841 -42.188  96.945  1.00  0.00           C  
ATOM   1762  C   VAL A 110      14.637 -42.622  97.785  1.00  0.00           C  
ATOM   1763  O   VAL A 110      13.570 -42.015  97.707  1.00  0.00           O  
ATOM   1764  CB  VAL A 110      16.718 -41.151  97.649  1.00  0.00           C  
ATOM   1765  CG1 VAL A 110      15.968 -40.497  98.811  1.00  0.00           C  
ATOM   1766  CG2 VAL A 110      18.031 -41.775  98.126  1.00  0.00           C  
ATOM   1767  H   VAL A 110      14.517 -41.152  95.715  1.00  0.00           H  
ATOM   1768  HA  VAL A 110      16.456 -43.063  96.735  1.00  0.00           H  
ATOM   1769  HB  VAL A 110      16.960 -40.371  96.926  1.00  0.00           H  
ATOM   1770 HG11 VAL A 110      16.023 -41.142  99.688  1.00  0.00           H  
ATOM   1771 HG12 VAL A 110      16.423 -39.533  99.040  1.00  0.00           H  
ATOM   1772 HG13 VAL A 110      14.925 -40.349  98.533  1.00  0.00           H  
ATOM   1773 HG21 VAL A 110      18.471 -41.148  98.901  1.00  0.00           H  
ATOM   1774 HG22 VAL A 110      17.835 -42.768  98.531  1.00  0.00           H  
ATOM   1775 HG23 VAL A 110      18.721 -41.855  97.286  1.00  0.00           H  
ATOM   1776  N   GLN A 111      14.849 -43.670  98.569  1.00  0.00           N  
ATOM   1777  CA  GLN A 111      13.795 -44.191  99.422  1.00  0.00           C  
ATOM   1778  C   GLN A 111      14.394 -44.811 100.686  1.00  0.00           C  
ATOM   1779  O   GLN A 111      15.555 -45.219 100.692  1.00  0.00           O  
ATOM   1780  CB  GLN A 111      12.933 -45.206  98.669  1.00  0.00           C  
ATOM   1781  CG  GLN A 111      12.079 -44.518  97.603  1.00  0.00           C  
ATOM   1782  CD  GLN A 111      11.352 -43.303  98.184  1.00  0.00           C  
ATOM   1783  OE1 GLN A 111      11.202 -42.273  97.547  1.00  0.00           O  
ATOM   1784  NE2 GLN A 111      10.911 -43.480  99.426  1.00  0.00           N  
ATOM   1785  H   GLN A 111      15.720 -44.157  98.626  1.00  0.00           H  
ATOM   1786  HA  GLN A 111      13.183 -43.329  99.685  1.00  0.00           H  
ATOM   1787  HB2 GLN A 111      13.572 -45.955  98.200  1.00  0.00           H  
ATOM   1788  HB3 GLN A 111      12.288 -45.734  99.372  1.00  0.00           H  
ATOM   1789  HG2 GLN A 111      12.710 -44.205  96.771  1.00  0.00           H  
ATOM   1790  HG3 GLN A 111      11.351 -45.224  97.203  1.00  0.00           H  
ATOM   1791 HE21 GLN A 111      11.068 -44.349  99.893  1.00  0.00           H  
ATOM   1792 HE22 GLN A 111      10.423 -42.742  99.893  1.00  0.00           H  
ATOM   1793  N   LYS A 112      13.575 -44.862 101.727  1.00  0.00           N  
ATOM   1794  CA  LYS A 112      14.010 -45.424 102.994  1.00  0.00           C  
ATOM   1795  C   LYS A 112      12.801 -45.579 103.918  1.00  0.00           C  
ATOM   1796  O   LYS A 112      11.861 -44.788 103.855  1.00  0.00           O  
ATOM   1797  CB  LYS A 112      15.138 -44.584 103.594  1.00  0.00           C  
ATOM   1798  CG  LYS A 112      15.854 -45.346 104.711  1.00  0.00           C  
ATOM   1799  CD  LYS A 112      15.332 -44.922 106.085  1.00  0.00           C  
ATOM   1800  CE  LYS A 112      16.003 -45.729 107.199  1.00  0.00           C  
ATOM   1801  NZ  LYS A 112      15.767 -45.092 108.514  1.00  0.00           N  
ATOM   1802  H   LYS A 112      12.633 -44.527 101.712  1.00  0.00           H  
ATOM   1803  HA  LYS A 112      14.417 -46.414 102.788  1.00  0.00           H  
ATOM   1804  HB2 LYS A 112      15.854 -44.319 102.815  1.00  0.00           H  
ATOM   1805  HB3 LYS A 112      14.734 -43.651 103.986  1.00  0.00           H  
ATOM   1806  HG2 LYS A 112      15.707 -46.418 104.577  1.00  0.00           H  
ATOM   1807  HG3 LYS A 112      16.927 -45.162 104.653  1.00  0.00           H  
ATOM   1808  HD2 LYS A 112      15.519 -43.859 106.238  1.00  0.00           H  
ATOM   1809  HD3 LYS A 112      14.252 -45.065 106.128  1.00  0.00           H  
ATOM   1810  HE2 LYS A 112      15.613 -46.746 107.206  1.00  0.00           H  
ATOM   1811  HE3 LYS A 112      17.074 -45.800 107.010  1.00  0.00           H  
ATOM   1812  HZ1 LYS A 112      15.504 -44.137 108.379  1.00  0.00           H  
ATOM   1813  HZ2 LYS A 112      15.033 -45.575 108.992  1.00  0.00           H  
ATOM   1814  HZ3 LYS A 112      16.604 -45.133 109.060  1.00  0.00           H  
ATOM   1815  N   THR A 113      12.864 -46.604 104.756  1.00  0.00           N  
ATOM   1816  CA  THR A 113      11.786 -46.873 105.692  1.00  0.00           C  
ATOM   1817  C   THR A 113      12.337 -47.504 106.973  1.00  0.00           C  
ATOM   1818  O   THR A 113      13.485 -47.945 107.007  1.00  0.00           O  
ATOM   1819  CB  THR A 113      10.749 -47.746 104.982  1.00  0.00           C  
ATOM   1820  OG1 THR A 113      10.307 -46.942 103.892  1.00  0.00           O  
ATOM   1821  CG2 THR A 113       9.489 -47.959 105.823  1.00  0.00           C  
ATOM   1822  H   THR A 113      13.631 -47.243 104.801  1.00  0.00           H  
ATOM   1823  HA  THR A 113      11.330 -45.923 105.974  1.00  0.00           H  
ATOM   1824  HB  THR A 113      11.183 -48.699 104.682  1.00  0.00           H  
ATOM   1825  HG1 THR A 113       9.809 -46.145 104.235  1.00  0.00           H  
ATOM   1826 HG21 THR A 113       9.228 -47.030 106.329  1.00  0.00           H  
ATOM   1827 HG22 THR A 113       8.667 -48.263 105.175  1.00  0.00           H  
ATOM   1828 HG23 THR A 113       9.674 -48.736 106.564  1.00  0.00           H  
ATOM   1829  N   TYR A 114      11.492 -47.527 107.994  1.00  0.00           N  
ATOM   1830  CA  TYR A 114      11.881 -48.097 109.272  1.00  0.00           C  
ATOM   1831  C   TYR A 114      10.679 -48.725 109.981  1.00  0.00           C  
ATOM   1832  O   TYR A 114       9.558 -48.670 109.477  1.00  0.00           O  
ATOM   1833  CB  TYR A 114      12.401 -46.930 110.114  1.00  0.00           C  
ATOM   1834  CG  TYR A 114      11.301 -46.117 110.799  1.00  0.00           C  
ATOM   1835  CD1 TYR A 114      10.802 -46.523 112.019  1.00  0.00           C  
ATOM   1836  CD2 TYR A 114      10.806 -44.979 110.195  1.00  0.00           C  
ATOM   1837  CE1 TYR A 114       9.766 -45.758 112.664  1.00  0.00           C  
ATOM   1838  CE2 TYR A 114       9.770 -44.214 110.839  1.00  0.00           C  
ATOM   1839  CZ  TYR A 114       9.301 -44.642 112.043  1.00  0.00           C  
ATOM   1840  OH  TYR A 114       8.323 -43.919 112.652  1.00  0.00           O  
ATOM   1841  H   TYR A 114      10.561 -47.167 107.957  1.00  0.00           H  
ATOM   1842  HA  TYR A 114      12.626 -48.870 109.084  1.00  0.00           H  
ATOM   1843  HB2 TYR A 114      13.079 -47.318 110.874  1.00  0.00           H  
ATOM   1844  HB3 TYR A 114      12.984 -46.267 109.475  1.00  0.00           H  
ATOM   1845  HD1 TYR A 114      11.192 -47.423 112.496  1.00  0.00           H  
ATOM   1846  HD2 TYR A 114      11.200 -44.659 109.230  1.00  0.00           H  
ATOM   1847  HE1 TYR A 114       9.364 -46.067 113.629  1.00  0.00           H  
ATOM   1848  HE2 TYR A 114       9.371 -43.313 110.374  1.00  0.00           H  
ATOM   1849  HH  TYR A 114       7.563 -44.517 112.904  1.00  0.00           H  
ATOM   1850  N   ALA A 115      10.952 -49.307 111.139  1.00  0.00           N  
ATOM   1851  CA  ALA A 115       9.906 -49.944 111.921  1.00  0.00           C  
ATOM   1852  C   ALA A 115      10.155 -49.679 113.408  1.00  0.00           C  
ATOM   1853  O   ALA A 115      11.301 -49.573 113.840  1.00  0.00           O  
ATOM   1854  CB  ALA A 115       9.863 -51.438 111.596  1.00  0.00           C  
ATOM   1855  H   ALA A 115      11.866 -49.348 111.543  1.00  0.00           H  
ATOM   1856  HA  ALA A 115       8.957 -49.494 111.635  1.00  0.00           H  
ATOM   1857  HB1 ALA A 115       9.197 -51.944 112.295  1.00  0.00           H  
ATOM   1858  HB2 ALA A 115       9.496 -51.578 110.579  1.00  0.00           H  
ATOM   1859  HB3 ALA A 115      10.865 -51.858 111.680  1.00  0.00           H  
ATOM   1860  N   GLU A 116       9.062 -49.581 114.149  1.00  0.00           N  
ATOM   1861  CA  GLU A 116       9.146 -49.329 115.578  1.00  0.00           C  
ATOM   1862  C   GLU A 116       8.999 -50.638 116.357  1.00  0.00           C  
ATOM   1863  O   GLU A 116       7.979 -51.318 116.248  1.00  0.00           O  
ATOM   1864  CB  GLU A 116       8.095 -48.308 116.018  1.00  0.00           C  
ATOM   1865  CG  GLU A 116       8.744 -46.964 116.353  1.00  0.00           C  
ATOM   1866  CD  GLU A 116       7.684 -45.878 116.550  1.00  0.00           C  
ATOM   1867  OE1 GLU A 116       7.048 -45.895 117.625  1.00  0.00           O  
ATOM   1868  OE2 GLU A 116       7.535 -45.055 115.620  1.00  0.00           O  
ATOM   1869  H   GLU A 116       8.132 -49.669 113.790  1.00  0.00           H  
ATOM   1870  HA  GLU A 116      10.140 -48.913 115.741  1.00  0.00           H  
ATOM   1871  HB2 GLU A 116       7.359 -48.174 115.227  1.00  0.00           H  
ATOM   1872  HB3 GLU A 116       7.561 -48.685 116.891  1.00  0.00           H  
ATOM   1873  HG2 GLU A 116       9.343 -47.059 117.257  1.00  0.00           H  
ATOM   1874  HG3 GLU A 116       9.422 -46.673 115.550  1.00  0.00           H  
ATOM   1875  N   MET A 117      10.032 -50.954 117.124  1.00  0.00           N  
ATOM   1876  CA  MET A 117      10.030 -52.169 117.920  1.00  0.00           C  
ATOM   1877  C   MET A 117       9.652 -51.873 119.373  1.00  0.00           C  
ATOM   1878  O   MET A 117       9.667 -50.718 119.798  1.00  0.00           O  
ATOM   1879  CB  MET A 117      11.418 -52.812 117.873  1.00  0.00           C  
ATOM   1880  CG  MET A 117      12.446 -51.950 118.609  1.00  0.00           C  
ATOM   1881  SD  MET A 117      13.937 -51.815 117.637  1.00  0.00           S  
ATOM   1882  CE  MET A 117      13.406 -50.620 116.421  1.00  0.00           C  
ATOM   1883  H   MET A 117      10.857 -50.395 117.207  1.00  0.00           H  
ATOM   1884  HA  MET A 117       9.278 -52.814 117.466  1.00  0.00           H  
ATOM   1885  HB2 MET A 117      11.379 -53.803 118.325  1.00  0.00           H  
ATOM   1886  HB3 MET A 117      11.726 -52.947 116.837  1.00  0.00           H  
ATOM   1887  HG2 MET A 117      12.034 -50.959 118.797  1.00  0.00           H  
ATOM   1888  HG3 MET A 117      12.674 -52.391 119.580  1.00  0.00           H  
ATOM   1889  HE1 MET A 117      12.550 -51.014 115.873  1.00  0.00           H  
ATOM   1890  HE2 MET A 117      13.122 -49.694 116.922  1.00  0.00           H  
ATOM   1891  HE3 MET A 117      14.222 -50.422 115.726  1.00  0.00           H  
ATOM   1892  N   ASP A 118       9.324 -52.935 120.094  1.00  0.00           N  
ATOM   1893  CA  ASP A 118       8.944 -52.802 121.490  1.00  0.00           C  
ATOM   1894  C   ASP A 118      10.179 -52.446 122.319  1.00  0.00           C  
ATOM   1895  O   ASP A 118      11.275 -52.933 122.047  1.00  0.00           O  
ATOM   1896  CB  ASP A 118       8.374 -54.114 122.032  1.00  0.00           C  
ATOM   1897  CG  ASP A 118       7.721 -54.015 123.412  1.00  0.00           C  
ATOM   1898  OD1 ASP A 118       6.642 -53.387 123.485  1.00  0.00           O  
ATOM   1899  OD2 ASP A 118       8.314 -54.568 124.363  1.00  0.00           O  
ATOM   1900  H   ASP A 118       9.315 -53.869 119.740  1.00  0.00           H  
ATOM   1901  HA  ASP A 118       8.188 -52.017 121.508  1.00  0.00           H  
ATOM   1902  HB2 ASP A 118       7.636 -54.492 121.324  1.00  0.00           H  
ATOM   1903  HB3 ASP A 118       9.177 -54.850 122.078  1.00  0.00           H  
ATOM   1904  N   PRO A 119       9.955 -51.575 123.340  1.00  0.00           N  
ATOM   1905  CA  PRO A 119      11.037 -51.148 124.210  1.00  0.00           C  
ATOM   1906  C   PRO A 119      11.420 -52.256 125.193  1.00  0.00           C  
ATOM   1907  O   PRO A 119      12.481 -52.865 125.065  1.00  0.00           O  
ATOM   1908  CB  PRO A 119      10.517 -49.897 124.899  1.00  0.00           C  
ATOM   1909  CG  PRO A 119       9.005 -49.933 124.743  1.00  0.00           C  
ATOM   1910  CD  PRO A 119       8.670 -50.978 123.691  1.00  0.00           C  
ATOM   1911  HA  PRO A 119      11.860 -50.961 123.674  1.00  0.00           H  
ATOM   1912  HB2 PRO A 119      10.800 -49.884 125.951  1.00  0.00           H  
ATOM   1913  HB3 PRO A 119      10.934 -48.998 124.445  1.00  0.00           H  
ATOM   1914  HG2 PRO A 119       8.529 -50.181 125.692  1.00  0.00           H  
ATOM   1915  HG3 PRO A 119       8.629 -48.955 124.443  1.00  0.00           H  
ATOM   1916  HD2 PRO A 119       7.979 -51.726 124.082  1.00  0.00           H  
ATOM   1917  HD3 PRO A 119       8.193 -50.526 122.822  1.00  0.00           H  
ATOM   1918  N   THR A 120      10.536 -52.484 126.154  1.00  0.00           N  
ATOM   1919  CA  THR A 120      10.768 -53.507 127.158  1.00  0.00           C  
ATOM   1920  C   THR A 120       9.469 -53.838 127.893  1.00  0.00           C  
ATOM   1921  O   THR A 120       8.631 -52.963 128.106  1.00  0.00           O  
ATOM   1922  CB  THR A 120      11.883 -53.017 128.083  1.00  0.00           C  
ATOM   1923  OG1 THR A 120      12.112 -54.115 128.963  1.00  0.00           O  
ATOM   1924  CG2 THR A 120      11.421 -51.889 129.008  1.00  0.00           C  
ATOM   1925  H   THR A 120       9.675 -51.984 126.251  1.00  0.00           H  
ATOM   1926  HA  THR A 120      11.090 -54.418 126.651  1.00  0.00           H  
ATOM   1927  HB  THR A 120      12.761 -52.717 127.511  1.00  0.00           H  
ATOM   1928  HG1 THR A 120      11.292 -54.294 129.507  1.00  0.00           H  
ATOM   1929 HG21 THR A 120      11.643 -52.153 130.042  1.00  0.00           H  
ATOM   1930 HG22 THR A 120      11.946 -50.969 128.748  1.00  0.00           H  
ATOM   1931 HG23 THR A 120      10.348 -51.740 128.893  1.00  0.00           H  
ATOM   1932  N   THR A 121       9.340 -55.105 128.261  1.00  0.00           N  
ATOM   1933  CA  THR A 121       8.156 -55.562 128.969  1.00  0.00           C  
ATOM   1934  C   THR A 121       8.514 -56.699 129.928  1.00  0.00           C  
ATOM   1935  O   THR A 121       9.525 -57.375 129.746  1.00  0.00           O  
ATOM   1936  CB  THR A 121       7.105 -55.952 127.929  1.00  0.00           C  
ATOM   1937  OG1 THR A 121       5.943 -56.246 128.701  1.00  0.00           O  
ATOM   1938  CG2 THR A 121       7.433 -57.275 127.232  1.00  0.00           C  
ATOM   1939  H   THR A 121      10.026 -55.811 128.085  1.00  0.00           H  
ATOM   1940  HA  THR A 121       7.779 -54.738 129.575  1.00  0.00           H  
ATOM   1941  HB  THR A 121       6.963 -55.155 127.200  1.00  0.00           H  
ATOM   1942  HG1 THR A 121       5.591 -55.408 129.117  1.00  0.00           H  
ATOM   1943 HG21 THR A 121       6.562 -57.930 127.267  1.00  0.00           H  
ATOM   1944 HG22 THR A 121       7.702 -57.083 126.194  1.00  0.00           H  
ATOM   1945 HG23 THR A 121       8.269 -57.756 127.742  1.00  0.00           H  
ATOM   1946  N   ALA A 122       7.665 -56.874 130.930  1.00  0.00           N  
ATOM   1947  CA  ALA A 122       7.878 -57.917 131.919  1.00  0.00           C  
ATOM   1948  C   ALA A 122       6.697 -57.942 132.891  1.00  0.00           C  
ATOM   1949  O   ALA A 122       5.770 -57.144 132.767  1.00  0.00           O  
ATOM   1950  CB  ALA A 122       9.213 -57.682 132.629  1.00  0.00           C  
ATOM   1951  H   ALA A 122       6.845 -56.319 131.071  1.00  0.00           H  
ATOM   1952  HA  ALA A 122       7.925 -58.869 131.391  1.00  0.00           H  
ATOM   1953  HB1 ALA A 122      10.005 -57.574 131.888  1.00  0.00           H  
ATOM   1954  HB2 ALA A 122       9.150 -56.773 133.228  1.00  0.00           H  
ATOM   1955  HB3 ALA A 122       9.434 -58.530 133.277  1.00  0.00           H  
ATOM   1956  N   ALA A 123       6.769 -58.868 133.836  1.00  0.00           N  
ATOM   1957  CA  ALA A 123       5.717 -59.008 134.828  1.00  0.00           C  
ATOM   1958  C   ALA A 123       6.289 -58.713 136.217  1.00  0.00           C  
ATOM   1959  O   ALA A 123       7.436 -58.287 136.341  1.00  0.00           O  
ATOM   1960  CB  ALA A 123       5.110 -60.409 134.734  1.00  0.00           C  
ATOM   1961  H   ALA A 123       7.527 -59.514 133.929  1.00  0.00           H  
ATOM   1962  HA  ALA A 123       4.945 -58.274 134.599  1.00  0.00           H  
ATOM   1963  HB1 ALA A 123       4.950 -60.805 135.738  1.00  0.00           H  
ATOM   1964  HB2 ALA A 123       4.156 -60.357 134.208  1.00  0.00           H  
ATOM   1965  HB3 ALA A 123       5.789 -61.065 134.189  1.00  0.00           H  
ATOM   1966  N   LEU A 124       5.463 -58.951 137.224  1.00  0.00           N  
ATOM   1967  CA  LEU A 124       5.872 -58.716 138.598  1.00  0.00           C  
ATOM   1968  C   LEU A 124       6.062 -60.058 139.307  1.00  0.00           C  
ATOM   1969  O   LEU A 124       6.993 -60.801 138.998  1.00  0.00           O  
ATOM   1970  CB  LEU A 124       4.882 -57.784 139.301  1.00  0.00           C  
ATOM   1971  CG  LEU A 124       3.400 -58.112 139.106  1.00  0.00           C  
ATOM   1972  CD1 LEU A 124       2.617 -57.903 140.403  1.00  0.00           C  
ATOM   1973  CD2 LEU A 124       2.809 -57.310 137.945  1.00  0.00           C  
ATOM   1974  H   LEU A 124       4.531 -59.297 137.114  1.00  0.00           H  
ATOM   1975  HA  LEU A 124       6.833 -58.201 138.570  1.00  0.00           H  
ATOM   1976  HB2 LEU A 124       5.098 -57.795 140.369  1.00  0.00           H  
ATOM   1977  HB3 LEU A 124       5.058 -56.768 138.950  1.00  0.00           H  
ATOM   1978  HG  LEU A 124       3.314 -59.166 138.845  1.00  0.00           H  
ATOM   1979 HD11 LEU A 124       1.797 -57.206 140.225  1.00  0.00           H  
ATOM   1980 HD12 LEU A 124       2.215 -58.857 140.743  1.00  0.00           H  
ATOM   1981 HD13 LEU A 124       3.280 -57.496 141.166  1.00  0.00           H  
ATOM   1982 HD21 LEU A 124       1.747 -57.143 138.122  1.00  0.00           H  
ATOM   1983 HD22 LEU A 124       3.321 -56.350 137.869  1.00  0.00           H  
ATOM   1984 HD23 LEU A 124       2.940 -57.865 137.016  1.00  0.00           H  
ATOM   1985  N   GLU A 125       5.164 -60.330 140.243  1.00  0.00           N  
ATOM   1986  CA  GLU A 125       5.221 -61.571 140.997  1.00  0.00           C  
ATOM   1987  C   GLU A 125       4.140 -61.583 142.080  1.00  0.00           C  
ATOM   1988  O   GLU A 125       4.146 -60.742 142.978  1.00  0.00           O  
ATOM   1989  CB  GLU A 125       6.609 -61.779 141.605  1.00  0.00           C  
ATOM   1990  CG  GLU A 125       7.106 -63.205 141.359  1.00  0.00           C  
ATOM   1991  CD  GLU A 125       8.576 -63.350 141.759  1.00  0.00           C  
ATOM   1992  OE1 GLU A 125       9.423 -62.808 141.018  1.00  0.00           O  
ATOM   1993  OE2 GLU A 125       8.819 -64.000 142.799  1.00  0.00           O  
ATOM   1994  H   GLU A 125       4.409 -59.720 140.487  1.00  0.00           H  
ATOM   1995  HA  GLU A 125       5.026 -62.360 140.272  1.00  0.00           H  
ATOM   1996  HB2 GLU A 125       7.311 -61.066 141.172  1.00  0.00           H  
ATOM   1997  HB3 GLU A 125       6.574 -61.583 142.677  1.00  0.00           H  
ATOM   1998  HG2 GLU A 125       6.499 -63.909 141.928  1.00  0.00           H  
ATOM   1999  HG3 GLU A 125       6.986 -63.459 140.305  1.00  0.00           H  
ATOM   2000  N   LYS A 126       3.238 -62.546 141.961  1.00  0.00           N  
ATOM   2001  CA  LYS A 126       2.154 -62.679 142.919  1.00  0.00           C  
ATOM   2002  C   LYS A 126       2.604 -63.581 144.069  1.00  0.00           C  
ATOM   2003  O   LYS A 126       3.535 -64.369 143.917  1.00  0.00           O  
ATOM   2004  CB  LYS A 126       0.880 -63.160 142.222  1.00  0.00           C  
ATOM   2005  CG  LYS A 126       0.410 -64.498 142.800  1.00  0.00           C  
ATOM   2006  CD  LYS A 126      -0.895 -64.950 142.145  1.00  0.00           C  
ATOM   2007  CE  LYS A 126      -1.778 -65.701 143.143  1.00  0.00           C  
ATOM   2008  NZ  LYS A 126      -3.127 -65.926 142.576  1.00  0.00           N  
ATOM   2009  H   LYS A 126       3.240 -63.227 141.227  1.00  0.00           H  
ATOM   2010  HA  LYS A 126       1.947 -61.686 143.318  1.00  0.00           H  
ATOM   2011  HB2 LYS A 126       0.094 -62.415 142.336  1.00  0.00           H  
ATOM   2012  HB3 LYS A 126       1.064 -63.267 141.153  1.00  0.00           H  
ATOM   2013  HG2 LYS A 126       1.180 -65.254 142.646  1.00  0.00           H  
ATOM   2014  HG3 LYS A 126       0.268 -64.402 143.877  1.00  0.00           H  
ATOM   2015  HD2 LYS A 126      -1.433 -64.083 141.759  1.00  0.00           H  
ATOM   2016  HD3 LYS A 126      -0.676 -65.593 141.293  1.00  0.00           H  
ATOM   2017  HE2 LYS A 126      -1.319 -66.657 143.396  1.00  0.00           H  
ATOM   2018  HE3 LYS A 126      -1.857 -65.132 144.069  1.00  0.00           H  
ATOM   2019  HZ1 LYS A 126      -3.668 -66.477 143.212  1.00  0.00           H  
ATOM   2020  HZ2 LYS A 126      -3.579 -65.046 142.431  1.00  0.00           H  
ATOM   2021  HZ3 LYS A 126      -3.046 -66.407 141.704  1.00  0.00           H  
ATOM   2022  N   GLU A 127       1.921 -63.433 145.196  1.00  0.00           N  
ATOM   2023  CA  GLU A 127       2.239 -64.225 146.372  1.00  0.00           C  
ATOM   2024  C   GLU A 127       1.103 -64.136 147.394  1.00  0.00           C  
ATOM   2025  O   GLU A 127       0.175 -63.346 147.229  1.00  0.00           O  
ATOM   2026  CB  GLU A 127       3.567 -63.781 146.989  1.00  0.00           C  
ATOM   2027  CG  GLU A 127       3.461 -62.365 147.559  1.00  0.00           C  
ATOM   2028  CD  GLU A 127       4.715 -61.550 147.238  1.00  0.00           C  
ATOM   2029  OE1 GLU A 127       5.773 -61.887 147.811  1.00  0.00           O  
ATOM   2030  OE2 GLU A 127       4.586 -60.607 146.427  1.00  0.00           O  
ATOM   2031  H   GLU A 127       1.164 -62.790 145.311  1.00  0.00           H  
ATOM   2032  HA  GLU A 127       2.336 -65.250 146.014  1.00  0.00           H  
ATOM   2033  HB2 GLU A 127       3.854 -64.475 147.780  1.00  0.00           H  
ATOM   2034  HB3 GLU A 127       4.352 -63.815 146.233  1.00  0.00           H  
ATOM   2035  HG2 GLU A 127       2.583 -61.868 147.147  1.00  0.00           H  
ATOM   2036  HG3 GLU A 127       3.322 -62.414 148.640  1.00  0.00           H  
ATOM   2037  N   SER A 128       1.214 -64.959 148.427  1.00  0.00           N  
ATOM   2038  CA  SER A 128       0.209 -64.983 149.476  1.00  0.00           C  
ATOM   2039  C   SER A 128       0.711 -65.804 150.665  1.00  0.00           C  
ATOM   2040  O   SER A 128       1.770 -66.425 150.591  1.00  0.00           O  
ATOM   2041  CB  SER A 128      -1.113 -65.553 148.957  1.00  0.00           C  
ATOM   2042  OG  SER A 128      -1.078 -66.975 148.856  1.00  0.00           O  
ATOM   2043  H   SER A 128       1.973 -65.598 148.554  1.00  0.00           H  
ATOM   2044  HA  SER A 128       0.066 -63.942 149.763  1.00  0.00           H  
ATOM   2045  HB2 SER A 128      -1.923 -65.258 149.624  1.00  0.00           H  
ATOM   2046  HB3 SER A 128      -1.335 -65.126 147.980  1.00  0.00           H  
ATOM   2047  HG  SER A 128      -1.345 -67.258 147.936  1.00  0.00           H  
ATOM   2048  N   GLY A 129      -0.072 -65.780 151.732  1.00  0.00           N  
ATOM   2049  CA  GLY A 129       0.281 -66.515 152.936  1.00  0.00           C  
ATOM   2050  C   GLY A 129      -0.952 -66.769 153.805  1.00  0.00           C  
ATOM   2051  O   GLY A 129      -1.894 -65.979 153.798  1.00  0.00           O  
ATOM   2052  H   GLY A 129      -0.931 -65.272 151.785  1.00  0.00           H  
ATOM   2053  HA2 GLY A 129       0.742 -67.465 152.664  1.00  0.00           H  
ATOM   2054  HA3 GLY A 129       1.021 -65.953 153.505  1.00  0.00           H  
ATOM   2055  N   PRO A 130      -0.905 -67.906 154.551  1.00  0.00           N  
ATOM   2056  CA  PRO A 130      -2.007 -68.274 155.423  1.00  0.00           C  
ATOM   2057  C   PRO A 130      -2.024 -67.406 156.682  1.00  0.00           C  
ATOM   2058  O   PRO A 130      -1.257 -66.451 156.792  1.00  0.00           O  
ATOM   2059  CB  PRO A 130      -1.796 -69.750 155.721  1.00  0.00           C  
ATOM   2060  CG  PRO A 130      -0.341 -70.038 155.389  1.00  0.00           C  
ATOM   2061  CD  PRO A 130       0.195 -68.865 154.584  1.00  0.00           C  
ATOM   2062  HA  PRO A 130      -2.881 -68.109 154.966  1.00  0.00           H  
ATOM   2063  HB2 PRO A 130      -2.009 -69.971 156.767  1.00  0.00           H  
ATOM   2064  HB3 PRO A 130      -2.464 -70.369 155.122  1.00  0.00           H  
ATOM   2065  HG2 PRO A 130       0.239 -70.172 156.301  1.00  0.00           H  
ATOM   2066  HG3 PRO A 130      -0.255 -70.963 154.819  1.00  0.00           H  
ATOM   2067  HD2 PRO A 130       1.081 -68.436 155.052  1.00  0.00           H  
ATOM   2068  HD3 PRO A 130       0.482 -69.173 153.579  1.00  0.00           H  
ATOM   2069  N   SER A 131      -2.907 -67.769 157.601  1.00  0.00           N  
ATOM   2070  CA  SER A 131      -3.034 -67.035 158.848  1.00  0.00           C  
ATOM   2071  C   SER A 131      -3.026 -68.006 160.030  1.00  0.00           C  
ATOM   2072  O   SER A 131      -2.182 -67.902 160.919  1.00  0.00           O  
ATOM   2073  CB  SER A 131      -4.310 -66.191 158.863  1.00  0.00           C  
ATOM   2074  OG  SER A 131      -4.240 -65.102 157.946  1.00  0.00           O  
ATOM   2075  H   SER A 131      -3.528 -68.547 157.503  1.00  0.00           H  
ATOM   2076  HA  SER A 131      -2.164 -66.379 158.887  1.00  0.00           H  
ATOM   2077  HB2 SER A 131      -5.164 -66.820 158.615  1.00  0.00           H  
ATOM   2078  HB3 SER A 131      -4.479 -65.807 159.870  1.00  0.00           H  
ATOM   2079  HG  SER A 131      -3.462 -65.222 157.331  1.00  0.00           H  
ATOM   2080  N   SER A 132      -3.977 -68.929 160.003  1.00  0.00           N  
ATOM   2081  CA  SER A 132      -4.090 -69.919 161.061  1.00  0.00           C  
ATOM   2082  C   SER A 132      -2.707 -70.466 161.416  1.00  0.00           C  
ATOM   2083  O   SER A 132      -1.759 -70.314 160.647  1.00  0.00           O  
ATOM   2084  CB  SER A 132      -5.022 -71.061 160.649  1.00  0.00           C  
ATOM   2085  OG  SER A 132      -6.395 -70.708 160.797  1.00  0.00           O  
ATOM   2086  H   SER A 132      -4.660 -69.007 159.276  1.00  0.00           H  
ATOM   2087  HA  SER A 132      -4.521 -69.387 161.909  1.00  0.00           H  
ATOM   2088  HB2 SER A 132      -4.827 -71.332 159.612  1.00  0.00           H  
ATOM   2089  HB3 SER A 132      -4.807 -71.941 161.255  1.00  0.00           H  
ATOM   2090  HG  SER A 132      -6.958 -71.268 160.189  1.00  0.00           H  
ATOM   2091  N   GLY A 133      -2.633 -71.089 162.583  1.00  0.00           N  
ATOM   2092  CA  GLY A 133      -1.381 -71.660 163.050  1.00  0.00           C  
ATOM   2093  C   GLY A 133      -0.296 -70.587 163.154  1.00  0.00           C  
ATOM   2094  O   GLY A 133       0.418 -70.515 164.152  1.00  0.00           O  
ATOM   2095  H   GLY A 133      -3.410 -71.208 163.203  1.00  0.00           H  
ATOM   2096  HA2 GLY A 133      -1.531 -72.125 164.024  1.00  0.00           H  
ATOM   2097  HA3 GLY A 133      -1.057 -72.444 162.367  1.00  0.00           H  
TER    2098      GLY A 133                                                      
END
MOLECULE T0429.pdb
ATOM      1  N   GLU    22      23.143   8.727  21.130  1.00172.90      A    N  
ATOM      2  CA  GLU    22      22.374   7.758  20.286  1.00169.34      A    C  
ATOM      3  CB  GLU    22      22.276   8.259  18.835  1.00168.54      A    C  
ATOM      4  CG  GLU    22      23.616   8.393  18.103  1.00158.10      A    C  
ATOM      5  CD  GLU    22      23.457   8.575  16.601  1.00157.25      A    C  
ATOM      6  OE1 GLU    22      24.348   8.113  15.852  1.00147.23      A    O  
ATOM      7  OE2 GLU    22      22.446   9.173  16.165  1.00167.76      A    O  
ATOM      8  C   GLU    22      22.931   6.322  20.338  1.00157.48      A    C  
ATOM      9  O   GLU    22      22.498   5.455  19.576  1.00152.96      A    O  
ATOM     10  N   THR    23      23.876   6.088  21.250  1.00154.10      A    N  
ATOM     11  CA  THR    23      24.505   4.776  21.452  1.00145.40      A    C  
ATOM     12  CB  THR    23      25.730   4.896  22.405  1.00143.94      A    C  
ATOM     13  OG1 THR    23      26.652   5.863  21.883  1.00141.32      A    O  
ATOM     14  CG2 THR    23      26.454   3.563  22.562  1.00136.43      A    C  
ATOM     15  C   THR    23      23.503   3.729  21.972  1.00150.21      A    C  
ATOM     16  O   THR    23      22.570   4.068  22.704  1.00162.36      A    O  
ATOM     17  N   GLU    24      23.706   2.466  21.590  1.00143.04      A    N  
ATOM     18  CA  GLU    24      22.756   1.383  21.886  1.00147.93      A    C  
ATOM     19  CB  GLU    24      22.210   0.789  20.580  1.00144.01      A    C  
ATOM     24  C   GLU    24      23.290   0.256  22.791  1.00146.91      A    C  
ATOM     25  O   GLU    24      22.482  -0.568  23.303  1.00154.53      A    O  
ATOM     26  N   LEU    25      24.636   0.215  22.968  1.00139.01      A    N  
ATOM     27  CA  LEU    25      25.295  -0.776  23.847  1.00138.87      A    C  
ATOM     28  CB  LEU    25      25.029  -0.457  25.346  1.00151.41      A    C  
ATOM     29  CG  LEU    25      26.098  -0.729  26.420  1.00153.60      A    C  
ATOM     30  CD1 LEU    25      25.557  -0.342  27.808  1.00166.65      A    C  
ATOM     31  CD2 LEU    25      26.620  -2.188  26.419  1.00150.16      A    C  
ATOM     32  C   LEU    25      24.901  -2.238  23.511  1.00137.26      A    C  
ATOM     33  O   LEU    25      24.248  -2.938  24.308  1.00144.91      A    O  
ATOM     34  N   LEU    27      24.229  -6.765  19.987  1.00124.47      A    N  
ATOM     35  CA  LEU    27      24.721  -8.135  19.817  1.00123.94      A    C  
ATOM     36  CB  LEU    27      24.018  -8.864  18.654  1.00124.12      A    C  
ATOM     37  CG  LEU    27      23.652  -8.221  17.310  1.00118.98      A    C  
ATOM     38  CD1 LEU    27      23.488  -9.322  16.264  1.00118.08      A    C  
ATOM     38  CD2 LEU    27      22.365  -7.397  17.414  1.00128.31      A    C  
ATOM     40  C   LEU    27      26.247  -8.245  19.696  1.00114.60      A    C  
ATOM     41  O   LEU    27      26.853  -9.156  20.263  1.00117.26      A    O  
ATOM     42  N   TYR    28      26.862  -7.335  18.947  1.00105.66      A    N  
ATOM     43  CA  TYR    28      28.319  -7.200  18.963  1.00 99.30      A    C  
ATOM     44  CB  TYR    28      28.923  -7.286  17.548  1.00 89.68      A    C  
ATOM     45  CG  TYR    28      28.406  -8.478  16.772  1.00 88.71      A    C  
ATOM     46  CD1 TYR    28      28.819  -9.774  17.087  1.00 90.89      A    C  
ATOM     47  CE1 TYR    28      28.325 -10.875  16.393  1.00 93.27      A    C  
ATOM     48  CZ  TYR    28      27.402 -10.683  15.376  1.00 92.44      A    C  
ATOM     49  OH  TYR    28      26.907 -11.765  14.685  1.00 96.36      A    O  
ATOM     50  CE2 TYR    28      26.974  -9.408  15.047  1.00 89.46      A    C  
ATOM     51  CD2 TYR    28      27.475  -8.315  15.748  1.00 87.20      A    C  
ATOM     52  C   TYR    28      28.651  -5.890  19.660  1.00100.94      A    C  
ATOM     53  O   TYR    28      28.114  -4.836  19.311  1.00100.23      A    O  
ATOM     54  N   LYS    29      29.505  -5.973  20.675  1.00104.98      A    N  
ATOM     55  CA  LYS    29      29.862  -4.813  21.481  1.00108.51      A    C  
ATOM     56  CB  LYS    29      30.333  -5.254  22.871  1.00116.86      A    C  
ATOM     61  C   LYS    29      30.923  -3.949  20.793  1.00102.56      A    C  
ATOM     62  O   LYS    29      31.688  -4.428  19.957  1.00 96.86      A    O  
ATOM     63  N   VAL    30      30.941  -2.667  21.147  1.00106.01      A    N  
ATOM     64  CA  VAL    30      31.946  -1.717  20.668  1.00103.19      A    C  
ATOM     65  CB  VAL    30      31.691  -0.300  21.261  1.00109.00      A    C  
ATOM     66  CG1 VAL    30      31.681  -0.327  22.793  1.00117.99      A    C  
ATOM     67  CG2 VAL    30      32.698   0.704  20.741  1.00108.94      A    C  
ATOM     68  C   VAL    30      33.374  -2.211  20.960  1.00103.89      A    C  
ATOM     69  O   VAL    30      33.667  -2.667  22.065  1.00110.81      A    O  
ATOM     70  N   ASN    31      34.238  -2.134  19.948  1.00 98.81      A    N  
ATOM     71  CA  ASN    31      35.638  -2.589  20.016  1.00 99.77      A    C  
ATOM     72  CB  ASN    31      36.312  -2.208  21.337  1.00108.53      A    C  
ATOM     73  CG  ASN    31      36.624  -0.747  21.416  1.00112.78      A    C  
ATOM     74  OD1 ASN    31      35.766   0.061  21.763  1.00116.34      A    O  
ATOM     75  ND2 ASN    31      37.861  -0.390  21.095  1.00116.64      A    N  
ATOM     76  C   ASN    31      35.858  -4.066  19.726  1.00 96.91      A    C  
ATOM     77  O   ASN    31      37.000  -4.499  19.568  1.00 98.59      A    O  
ATOM     78  N   GLU    32      34.779  -4.839  19.660  1.00 94.41      A    N  
ATOM     79  CA  GLU    32      34.889  -6.234  19.254  1.00 93.05      A    C  
ATOM     80  CB  GLU    32      33.592  -6.998  19.533  1.00 94.24      A    C  
ATOM     81  CG  GLU    32      33.730  -8.518  19.443  1.00 96.69      A    C  
ATOM     82  CD  GLU    32      32.437  -9.259  19.760  1.00101.02      A    C  
ATOM     83  OE1 GLU    32      31.677  -8.814  20.653  1.00104.59      A    O  
ATOM     84  OE2 GLU    32      32.191 -10.304  19.112  1.00101.68      A    O  
ATOM     85  C   GLU    32      35.248  -6.293  17.770  1.00 85.89      A    C  
ATOM     86  O   GLU    32      34.742  -5.503  16.970  1.00 81.52      A    O  
ATOM     87  N   TYR    33      36.146  -7.212  17.424  1.00 86.41      A    N  
ATOM     88  CA  TYR    33      36.514  -7.452  16.032  1.00 80.84      A    C  
ATOM     89  CB  TYR    33      37.902  -8.087  15.933  1.00 84.64      A    C  
ATOM     90  CG  TYR    33      39.026  -7.173  16.361  1.00 88.89      A    C  
ATOM     91  CD1 TYR    33      39.565  -6.233  15.478  1.00 87.72      A    C  
ATOM     92  CE1 TYR    33      40.604  -5.390  15.869  1.00 93.77      A    C  
ATOM     93  CZ  TYR    33      41.113  -5.488  17.158  1.00102.17      A    C  
ATOM     94  OH  TYR    33      42.137  -4.665  17.562  1.00109.70      A    O  
ATOM     95  CE2 TYR    33      40.595  -6.415  18.049  1.00103.06      A    C  
ATOM     96  CD2 TYR    33      39.558  -7.251  17.645  1.00 96.63      A    C  
ATOM     97  C   TYR    33      35.481  -8.343  15.365  1.00 77.13      A    C  
ATOM     98  O   TYR    33      34.999  -9.304  15.962  1.00 80.54      A    O  
ATOM     99  N   VAL    34      35.150  -8.015  14.121  1.00 71.92      A    N  
ATOM    100  CA  VAL    34      34.093  -8.702  13.387  1.00 68.82      A    C  
ATOM    101  CB  VAL    34      32.747  -7.920  13.464  1.00 68.44      A    C  
ATOM    102  CG1 VAL    34      32.177  -7.925  14.884  1.00 71.47      A    C  
ATOM    103  CG2 VAL    34      32.898  -6.493  12.926  1.00 64.40      A    C  
ATOM    104  C   VAL    34      34.460  -8.908  11.914  1.00 66.21      A    C  
ATOM    105  O   VAL    34      35.567  -8.577  11.481  1.00 66.29      A    O  
ATOM    106  N   ASP    35      33.522  -9.472  11.162  1.00 64.66      A    N  
ATOM    107  CA  ASP    35      33.597  -9.509   9.715  1.00 63.00      A    C  
ATOM    108  CB  ASP    35      33.407 -10.939   9.202  1.00 63.65      A    C  
ATOM    109  CG  ASP    35      34.686 -11.759   9.244  1.00 64.32      A    C  
ATOM    110  OD1 ASP    35      35.783 -11.188   9.069  1.00 62.56      A    O  
ATOM    111  OD2 ASP    35      34.591 -12.990   9.434  1.00 66.48      A    O  
ATOM    112  C   ASP    35      32.473  -8.627   9.199  1.00 63.11      A    C  
ATOM    113  O   ASP    35      31.344  -8.719   9.686  1.00 65.91      A    O  
ATOM    114  N   ALA    36      32.775  -7.773   8.221  1.00 62.20      A    N  
ATOM    115  CA  ALA    36      31.779  -6.853   7.670  1.00 62.48      A    C  
ATOM    116  CB  ALA    36      32.182  -5.415   7.934  1.00 63.64      A    C  
ATOM    117  C   ALA    36      31.607  -7.080   6.186  1.00 63.86      A    C  
ATOM    118  O   ALA    36      32.589  -7.191   5.452  1.00 65.27      A    O  
ATOM    119  N   ARG    37      30.358  -7.138   5.744  1.00 66.32      A    N  
ATOM    120  CA  ARG    37      30.057  -7.410   4.344  1.00 70.06      A    C  
ATOM    121  CB  ARG    37      28.720  -8.159   4.199  1.00 73.46      A    C  
ATOM    122  CG  ARG    37      28.518  -8.813   2.829  1.00 77.70      A    C  
ATOM    123  CD  ARG    37      27.182  -9.543   2.729  1.00 83.79      A    C  
ATOM    124  NE  ARG    37      26.063  -8.613   2.586  1.00 92.01      A    N  
ATOM    125  CZ  ARG    37      25.427  -8.344   1.445  1.00 99.69      A    C  
ATOM    126  NH1 ARG    37      25.775  -8.943   0.309  1.00101.62      A    N  
ATOM    127  NH2 ARG    37      24.425  -7.472   1.444  1.00105.62      A    N  
ATOM    128  C   ARG    37      30.043  -6.122   3.535  1.00 72.97      A    C  
ATOM    129  O   ARG    37      29.183  -5.267   3.734  1.00 76.28      A    O  
ATOM    130  N   ASP    38      31.015  -5.980   2.640  1.00 74.45      A    N  
ATOM    131  CA  ASP    38      30.995  -4.906   1.661  1.00 81.28      A    C  
ATOM    132  CB  ASP    38      32.279  -4.924   0.825  1.00 83.16      A    C  
ATOM    133  CG  ASP    38      32.369  -3.768  -0.157  1.00 91.41      A    C  
ATOM    134  OD1 ASP    38      31.439  -3.583  -0.965  1.00 98.91      A    O  
ATOM    135  OD2 ASP    38      33.394  -3.058  -0.145  1.00 93.84      A    O  
ATOM    136  C   ASP    38      29.768  -5.148   0.794  1.00 87.58      A    C  
ATOM    137  O   ASP    38      29.730  -6.094   0.011  1.00 90.08      A    O  
ATOM    138  N   THR    39      28.754  -4.307   0.961  1.00 92.61      A    N  
ATOM    139  CA  THR    39      27.483  -4.487   0.262  1.00101.09      A    C  
ATOM    140  CB  THR    39      26.377  -3.589   0.863  1.00105.79      A    C  
ATOM    141  OG1 THR    39      26.310  -3.809   2.276  1.00100.08      A    O  
ATOM    142  CG2 THR    39      25.014  -3.910   0.258  1.00115.77      A    C  
ATOM    143  C   THR    39      27.621  -4.263  -1.246  1.00109.30      A    C  
ATOM    144  O   THR    39      26.849  -4.811  -2.034  1.00116.02      A    O  
ATOM    145  N   ASN    40      28.617  -3.475  -1.640  1.00111.13      A    N  
ATOM    146  CA  ASN    40      28.866  -3.188  -3.050  1.00121.02      A    C  
ATOM    147  CB  ASN    40      29.891  -2.057  -3.191  1.00124.44      A    C  
ATOM    148  CG  ASN    40      30.409  -1.907  -4.609  1.00135.60      A    C  
ATOM    149  OD1 ASN    40      31.550  -2.269  -4.903  1.00135.88      A    O  
ATOM    150  ND2 ASN    40      29.567  -1.391  -5.502  1.00147.42      A    N  
ATOM    151  C   ASN    40      29.296  -4.418  -3.857  1.00120.57      A    C  
ATOM    152  O   ASN    40      28.922  -4.560  -5.022  1.00129.57      A    O  
ATOM    153  N   MET    41      30.064  -5.308  -3.234  1.00111.84      A    N  
ATOM    154  CA  MET    41      30.606  -6.478  -3.933  1.00112.47      A    C  
ATOM    155  CB  MET    41      32.122  -6.373  -4.048  1.00111.40      A    C  
ATOM    156  CG  MET    41      32.807  -6.077  -2.737  1.00103.73      A    C  
ATOM    157  SD  MET    41      34.733  -6.073  -2.908  1.00108.38      A   SE  
ATOM    158  CE  MET    41      34.947  -4.830  -4.410  1.00120.35      A    C  
ATOM    159  C   MET    41      30.224  -7.818  -3.307  1.00105.36      A    C  
ATOM    160  O   MET    41      30.327  -8.863  -3.955  1.00106.85      A    O  
ATOM    161  N   GLY    42      29.804  -7.780  -2.047  1.00 83.71      A    N  
ATOM    162  CA  GLY    42      29.269  -8.959  -1.367  1.00 83.07      A    C  
ATOM    163  C   GLY    42      30.262  -9.792  -0.578  1.00 77.08      A    C  
ATOM    164  O   GLY    42      29.914 -10.867  -0.090  1.00 77.31      A    O  
ATOM    165  N   ALA    43      31.490  -9.300  -0.446  1.00 72.89      A    N  
ATOM    166  CA  ALA    43      32.548 -10.041   0.234  1.00 69.07      A    C  
ATOM    167  CB  ALA    43      33.865  -9.848  -0.491  1.00 68.37      A    C  
ATOM    168  C   ALA    43      32.669  -9.636   1.703  1.00 65.34      A    C  
ATOM    169  O   ALA    43      32.300  -8.525   2.077  1.00 65.78      A    O  
ATOM    170  N   TRP    44      33.183 -10.537   2.535  1.00 64.28      A    N  
ATOM    171  CA  TRP    44      33.399 -10.241   3.953  1.00 61.58      A    C  
ATOM    172  CB  TRP    44      32.987 -11.425   4.830  1.00 63.28      A    C  
ATOM    173  CG  TRP    44      31.522 -11.742   4.770  1.00 66.96      A    C  
ATOM    174  CD1 TRP    44      30.893 -12.523   3.846  1.00 71.29      A    C  
ATOM    175  NE1 TRP    44      29.547 -12.583   4.112  1.00 75.54      A    N  
ATOM    176  CE2 TRP    44      29.278 -11.826   5.222  1.00 74.38      A    C  
ATOM    177  CD2 TRP    44      30.503 -11.280   5.667  1.00 69.18      A    C  
ATOM    178  CE3 TRP    44      30.505 -10.458   6.805  1.00 68.75      A    C  
ATOM    179  CZ3 TRP    44      29.298 -10.209   7.452  1.00 70.28      A    C  
ATOM    180  CH2 TRP    44      28.096 -10.769   6.986  1.00 75.60      A    C  
ATOM    181  CZ2 TRP    44      28.063 -11.578   5.876  1.00 76.96      A    C  
ATOM    182  C   TRP    44      34.850  -9.851   4.236  1.00 60.04      A    C  
ATOM    183  O   TRP    44      35.789 -10.497   3.740  1.00 59.62      A    O  
ATOM    184  N   PHE    45      35.017  -8.797   5.038  1.00 57.06      A    N  
ATOM    185  CA  PHE    45      36.331  -8.252   5.361  1.00 55.38      A    C  
ATOM    186  CB  PHE    45      36.541  -6.899   4.673  1.00 54.74      A    C  
ATOM    187  CG  PHE    45      36.523  -6.953   3.157  1.00 58.74      A    C  
ATOM    188  CD1 PHE    45      37.701  -7.144   2.439  1.00 58.08      A    C  
ATOM    189  CE1 PHE    45      37.695  -7.170   1.046  1.00 62.77      A    C  
ATOM    190  CZ  PHE    45      36.501  -7.000   0.344  1.00 63.52      A    C  
ATOM    191  CE2 PHE    45      35.321  -6.799   1.049  1.00 65.02      A    C  
ATOM    192  CD2 PHE    45      35.334  -6.773   2.448  1.00 58.18      A    C  
ATOM    193  C   PHE    45      36.481  -8.089   6.879  1.00 55.58      A    C  
ATOM    194  O   PHE    45      35.519  -7.741   7.578  1.00 55.09      A    O  
ATOM    195  N   GLU    46      37.686  -8.344   7.381  1.00 56.08      A    N  
ATOM    196  CA  GLU    46      37.969  -8.188   8.805  1.00 57.83      A    C  
ATOM    197  CB  GLU    46      39.401  -8.620   9.155  1.00 59.91      A    C  
ATOM    198  CG  GLU    46      39.750 -10.086   8.880  1.00 61.88      A    C  
ATOM    199  CD  GLU    46      40.313 -10.306   7.470  1.00 65.85      A    C  
ATOM    200  OE1 GLU    46      39.935  -9.574   6.516  1.00 60.16      A    O  
ATOM    201  OE2 GLU    46      41.147 -11.223   7.320  1.00 72.28      A    O  
ATOM    202  C   GLU    46      37.762  -6.724   9.155  1.00 57.63      A    C  
ATOM    203  O   GLU    46      38.320  -5.836   8.509  1.00 58.66      A    O  
ATOM    204  N   ALA    47      36.924  -6.478  10.150  1.00 57.65      A    N  
ATOM    205  CA  ALA    47      36.649  -5.120  10.594  1.00 58.18      A    C  
ATOM    206  CB  ALA    47      35.406  -4.582   9.895  1.00 56.70      A    C  
ATOM    207  C   ALA    47      36.505  -5.054  12.117  1.00 60.50      A    C  
ATOM    208  O   ALA    47      36.526  -6.082  12.792  1.00 61.81      A    O  
ATOM    209  N   GLN    48      36.390  -3.842  12.652  1.00 63.44      A    N  
ATOM    210  CA  GLN    48      36.171  -3.640  14.084  1.00 67.12      A    C  
ATOM    211  CB  GLN    48      37.456  -3.160  14.766  1.00 71.03      A    C  
ATOM    212  CG  GLN    48      37.367  -3.069  16.297  1.00 75.40      A    C  
ATOM    213  CD  GLN    48      38.641  -2.565  16.949  1.00 80.70      A    C  
ATOM    214  OE1 GLN    48      39.520  -2.019  16.287  1.00 80.17      A    O  
ATOM    215  NE2 GLN    48      38.742  -2.741  18.266  1.00 86.01      A    N  
ATOM    216  C   GLN    48      35.030  -2.652  14.331  1.00 69.25      A    C  
ATOM    217  O   GLN    48      34.873  -1.667  13.598  1.00 67.51      A    O  
ATOM    218  N   VAL    49      34.243  -2.927  15.369  1.00 72.79      A    N  
ATOM    219  CA  VAL    49      33.117  -2.082  15.740  1.00 76.25      A    C  
ATOM    220  CB  VAL    49      32.072  -2.853  16.579  1.00 80.46      A    C  
ATOM    221  CG1 VAL    49      30.933  -1.925  17.006  1.00 82.55      A    C  
ATOM    222  CG2 VAL    49      31.539  -4.055  15.802  1.00 75.52      A    C  
ATOM    223  C   VAL    49      33.586  -0.852  16.516  1.00 81.59      A    C  
ATOM    224  O   VAL    49      34.141  -0.962  17.614  1.00 86.04      A    O  
ATOM    225  N   VAL    50      33.342   0.318  15.936  1.00 81.58      A    N  
ATOM    226  CA  VAL    50      33.742   1.586  16.532  1.00 85.85      A    C  
ATOM    227  CB  VAL    50      34.190   2.582  15.439  1.00 82.87      A    C  
ATOM    228  CG1 VAL    50      34.390   3.946  16.021  1.00 90.16      A    C  
ATOM    229  CG2 VAL    50      35.466   2.109  14.799  1.00 79.12      A    C  
ATOM    230  C   VAL    50      32.618   2.185  17.389  1.00 91.85      A    C  
ATOM    231  O   VAL    50      32.866   2.721  18.476  1.00 97.97      A    O  
ATOM    232  N   ARG    51      31.391   2.106  16.883  1.00 91.35      A    N  
ATOM    233  CA  ARG    51      30.213   2.553  17.613  1.00 98.00      A    C  
ATOM    234  CB  ARG    51      29.917   4.032  17.340  1.00100.80      A    C  
ATOM    235  CG  ARG    51      30.506   4.983  18.377  1.00107.46      A    C  
ATOM    236  CD  ARG    51      30.332   6.443  17.985  1.00110.40      A    C  
ATOM    237  NE  ARG    51      28.942   6.883  18.103  1.00118.29      A    N  
ATOM    238  CZ  ARG    51      28.426   7.482  19.175  1.00129.05      A    C  
ATOM    239  NH1 ARG    51      29.181   7.730  20.240  1.00134.40      A    N  
ATOM    240  NH2 ARG    51      27.146   7.840  19.187  1.00134.91      A    N  
ATOM    241  C   ARG    51      29.012   1.691  17.255  1.00 97.71      A    C  
ATOM    242  O   ARG    51      28.957   1.107  16.169  1.00 92.82      A    O  
ATOM    243  N   VAL    52      28.066   1.598  18.186  1.00104.09      A    N  
ATOM    244  CA  VAL    52      26.811   0.891  17.951  1.00105.53      A    C  
ATOM    245  CB  VAL    52      26.746  -0.447  18.749  1.00107.07      A    C  
ATOM    246  CG1 VAL    52      26.856  -0.214  20.262  1.00116.59      A    C  
ATOM    247  CG2 VAL    52      25.491  -1.224  18.406  1.00109.24      A    C  
ATOM    248  C   VAL    52      25.618   1.825  18.217  1.00112.85      A    C  
ATOM    249  O   VAL    52      25.528   2.453  19.276  1.00118.62      A    O  
ATOM    250  N   THR    53      24.724   1.920  17.235  1.00113.10      A    N  
ATOM    251  CA  THR    53      23.602   2.862  17.269  1.00121.51      A    C  
ATOM    252  CB  THR    53      23.697   3.858  16.086  1.00119.01      A    C  
ATOM    253  OG1 THR    53      25.050   4.292  15.937  1.00114.19      A    O  
ATOM    254  CG2 THR    53      22.815   5.078  16.309  1.00129.22      A    C  
ATOM    255  C   THR    53      22.252   2.129  17.233  1.00126.92      A    C  
ATOM    256  O   THR    53      22.201   0.930  16.948  1.00124.34      A    O  
ATOM    257  N   ARG    54      21.171   2.851  17.529  1.00135.79      A    N  
ATOM    258  CA  ARG    54      19.816   2.299  17.465  1.00143.10      A    C  
ATOM    259  CB  ARG    54      19.136   2.367  18.841  1.00152.93      A    C  
ATOM    266  C   ARG    54      18.965   3.026  16.419  1.00146.96      A    C  
ATOM    267  O   ARG    54      18.946   2.629  15.229  1.00142.84      A    O  
ATOM    268  N   GLU    73      20.100  -6.332  15.059  1.00123.32      A    N  
ATOM    269  CA  GLU    73      18.671  -6.470  14.844  1.00132.67      A    C  
ATOM    270  CB  GLU    73      18.053  -7.343  15.943  1.00141.48      A    C  
ATOM    271  CG  GLU    73      18.457  -6.965  17.377  1.00145.34      A    C  
ATOM    272  CD  GLU    73      17.406  -7.360  18.407  1.00159.33      A    C  
ATOM    273  OE1 GLU    73      16.940  -8.524  18.379  1.00163.38      A    O  
ATOM    274  OE2 GLU    73      17.047  -6.503  19.249  1.00167.09      A    O  
ATOM    275  C   GLU    73      18.000  -5.098  14.802  1.00137.46      A    C  
ATOM    276  O   GLU    73      17.488  -4.614  15.820  1.00144.45      A    O  
ATOM    277  N   ASP    74      18.001  -4.475  13.621  1.00134.20      A    N  
ATOM    278  CA  ASP    74      17.565  -3.076  13.462  1.00137.77      A    C  
ATOM    279  CB  ASP    74      16.132  -2.870  13.992  1.00150.47      A    C  
ATOM    280  CG  ASP    74      15.447  -1.638  13.404  1.00157.01      A    C  
ATOM    281  OD1 ASP    74      16.084  -0.904  12.614  1.00151.95      A    O  
ATOM    282  OD2 ASP    74      14.261  -1.406  13.738  1.00166.48      A    O  
ATOM    283  C   ASP    74      18.571  -2.133  14.150  1.00132.38      A    C  
ATOM    284  O   ASP    74      18.362  -0.917  14.243  1.00135.67      A    O  
ATOM    285  N   VAL    75      19.658  -2.731  14.633  1.00124.52      A    N  
ATOM    286  CA  VAL    75      20.823  -2.029  15.155  1.00117.47      A    C  
ATOM    287  CB  VAL    75      21.627  -2.956  16.115  1.00114.64      A    C  
ATOM    288  CG1 VAL    75      23.095  -2.588  16.171  1.00105.73      A    C  
ATOM    289  CG2 VAL    75      21.012  -2.949  17.511  1.00123.12      A    C  
ATOM    290  C   VAL    75      21.679  -1.621  13.962  1.00108.96      A    C  
ATOM    291  O   VAL    75      21.740  -2.351  12.968  1.00104.98      A    O  
ATOM    292  N   ILE    76      22.315  -0.453  14.052  1.00106.20      A    N  
ATOM    293  CA  ILE    76      23.261  -0.013  13.023  1.00 99.14      A    C  
ATOM    294  CB  ILE    76      22.765   1.254  12.255  1.00102.73      A    C  
ATOM    295  CG1 ILE    76      23.853   1.796  11.319  1.00 96.23      A    C  
ATOM    296  CD1 ILE    76      23.310   2.429  10.045  1.00 99.72      A    C  
ATOM    297  CG2 ILE    76      22.252   2.323  13.216  1.00110.67      A    C  
ATOM    298  C   ILE    76      24.690   0.120  13.573  1.00 92.90      A    C  
ATOM    299  O   ILE    76      24.945   0.887  14.499  1.00 95.46      A    O  
ATOM    300  N   TYR    77      25.607  -0.649  12.990  1.00 93.66      A    N  
ATOM    301  CA  TYR    77      26.991  -0.728  13.458  1.00 88.85      A    C  
ATOM    302  CB  TYR    77      27.533  -2.147  13.273  1.00 85.70      A    C  
ATOM    303  CG  TYR    77      26.943  -3.158  14.228  1.00 89.17      A    C  
ATOM    304  CD1 TYR    77      27.333  -3.187  15.566  1.00 90.70      A    C  
ATOM    305  CE1 TYR    77      26.796  -4.113  16.452  1.00 95.37      A    C  
ATOM    306  CZ  TYR    77      25.860  -5.028  16.005  1.00 96.78      A    C  
ATOM    307  OH  TYR    77      25.339  -5.937  16.890  1.00100.18      A    O  
ATOM    308  CE2 TYR    77      25.456  -5.027  14.677  1.00 95.16      A    C  
ATOM    309  CD2 TYR    77      26.000  -4.091  13.797  1.00 90.70      A    C  
ATOM    310  C   TYR    77      27.916   0.258  12.760  1.00 85.38      A    C  
ATOM    311  O   TYR    77      27.856   0.421  11.542  1.00 84.45      A    O  
ATOM    312  N   HIS    78      28.773   0.910  13.541  1.00 83.71      A    N  
ATOM    313  CA  HIS    78      29.810   1.770  12.989  1.00 81.14      A    C  
ATOM    314  CB  HIS    78      29.910   3.077  13.762  1.00 83.22      A    C  
ATOM    315  CG  HIS    78      28.703   3.945  13.615  1.00 87.89      A    C  
ATOM    316  ND1 HIS    78      28.769   5.234  13.134  1.00 90.48      A    N  
ATOM    317  CE1 HIS    78      27.554   5.752  13.107  1.00 94.69      A    C  
ATOM    318  NE2 HIS    78      26.702   4.840  13.539  1.00 96.87      A    N  
ATOM    319  CD2 HIS    78      27.395   3.699  13.861  1.00 91.50      A    C  
ATOM    320  C   HIS    78      31.117   1.019  13.031  1.00 77.65      A    C  
ATOM    321  O   HIS    78      31.556   0.572  14.093  1.00 78.47      A    O  
ATOM    322  N   VAL    79      31.736   0.895  11.864  1.00 73.81      A    N  
ATOM    323  CA  VAL    79      32.790  -0.070  11.660  1.00 70.60      A    C  
ATOM    324  CB  VAL    79      32.193  -1.323  10.934  1.00 70.59      A    C  
ATOM    325  CG1 VAL    79      33.109  -1.881   9.858  1.00 64.14      A    C  
ATOM    326  CG2 VAL    79      31.785  -2.385  11.956  1.00 70.14      A    C  
ATOM    327  C   VAL    79      33.993   0.529  10.929  1.00 69.42      A    C  
ATOM    328  O   VAL    79      33.844   1.379  10.051  1.00 69.22      A    O  
ATOM    329  N   LYS    80      35.186   0.100  11.328  1.00 69.05      A    N  
ATOM    330  CA  LYS    80      36.402   0.409  10.586  1.00 69.09      A    C  
ATOM    331  CB  LYS    80      37.372   1.251  11.422  1.00 70.54      A    C  
ATOM    332  CG  LYS    80      38.019   0.522  12.589  1.00 71.11      A    C  
ATOM    333  CD  LYS    80      38.951   1.430  13.346  1.00 72.80      A    C  
ATOM    334  CE  LYS    80      39.612   0.680  14.484  1.00 77.21      A    C  
ATOM    335  NZ  LYS    80      40.206   1.598  15.499  1.00 80.41      A    N  
ATOM    336  C   LYS    80      37.069  -0.878  10.094  1.00 68.73      A    C  
ATOM    337  O   LYS    80      37.050  -1.904  10.783  1.00 67.58      A    O  
ATOM    338  N   TYR    81      37.642  -0.809   8.895  1.00 69.17      A    N  
ATOM    339  CA  TYR    81      38.314  -1.942   8.276  1.00 69.65      A    C  
ATOM    340  CB  TYR    81      38.192  -1.871   6.756  1.00 71.26      A    C  
ATOM    341  CG  TYR    81      36.782  -2.058   6.257  1.00 73.36      A    C  
ATOM    342  CD1 TYR    81      35.942  -0.962   6.046  1.00 76.49      A    C  
ATOM    343  CE1 TYR    81      34.632  -1.135   5.589  1.00 78.01      A    C  
ATOM    344  CZ  TYR    81      34.160  -2.417   5.342  1.00 77.56      A    C  
ATOM    345  OH  TYR    81      32.871  -2.611   4.885  1.00 80.19      A    O  
ATOM    346  CE2 TYR    81      34.981  -3.517   5.552  1.00 75.57      A    C  
ATOM    347  CD2 TYR    81      36.279  -3.333   6.010  1.00 72.40      A    C  
ATOM    348  C   TYR    81      39.777  -2.026   8.675  1.00 70.89      A    C  
ATOM    349  O   TYR    81      40.533  -1.050   8.563  1.00 71.51      A    O  
ATOM    350  N   ASP    82      40.164  -3.215   9.130  1.00 71.89      A    N  
ATOM    351  CA  ASP    82      41.516  -3.480   9.609  1.00 73.79      A    C  
ATOM    352  CB  ASP    82      41.648  -4.954  10.017  1.00 74.15      A    C  
ATOM    353  CG  ASP    82      40.868  -5.285  11.286  1.00 76.59      A    C  
ATOM    354  OD1 ASP    82      40.138  -4.405  11.803  1.00 78.41      A    O  
ATOM    355  OD2 ASP    82      40.989  -6.432  11.775  1.00 78.61      A    O  
ATOM    356  C   ASP    82      42.576  -3.103   8.576  1.00 74.38      A    C  
ATOM    357  O   ASP    82      43.536  -2.406   8.898  1.00 77.23      A    O  
ATOM    358  N   ASP    83      42.376  -3.540   7.336  1.00 72.34      A    N  
ATOM    359  CA  ASP    83      43.368  -3.352   6.288  1.00 72.89      A    C  
ATOM    360  CB  ASP    83      43.600  -4.675   5.546  1.00 73.65      A    C  
ATOM    361  CG  ASP    83      44.090  -5.780   6.467  1.00 75.64      A    C  
ATOM    362  OD1 ASP    83      45.026  -5.529   7.263  1.00 79.90      A    O  
ATOM    363  OD2 ASP    83      43.535  -6.899   6.399  1.00 75.47      A    O  
ATOM    364  C   ASP    83      43.012  -2.238   5.307  1.00 72.04      A    C  
ATOM    365  O   ASP    83      43.717  -2.037   4.311  1.00 73.88      A    O  
ATOM    366  N   TYR    84      41.927  -1.517   5.582  1.00 69.13      A    N  
ATOM    367  CA  TYR    84      41.477  -0.450   4.687  1.00 69.06      A    C  
ATOM    368  CB  TYR    84      40.293  -0.925   3.838  1.00 67.58      A    C  
ATOM    369  CG  TYR    84      40.560  -2.187   3.072  1.00 66.36      A    C  
ATOM    370  CD1 TYR    84      41.057  -2.140   1.773  1.00 68.00      A    C  
ATOM    371  CE1 TYR    84      41.312  -3.305   1.067  1.00 69.12      A    C  
ATOM    372  CZ  TYR    84      41.063  -4.533   1.656  1.00 66.52      A    C  
ATOM    373  OH  TYR    84      41.309  -5.690   0.957  1.00 68.36      A    O  
ATOM    374  CE2 TYR    84      40.569  -4.603   2.945  1.00 65.02      A    C  
ATOM    375  CD2 TYR    84      40.318  -3.433   3.644  1.00 63.68      A    C  
ATOM    376  C   TYR    84      41.094   0.836   5.421  1.00 69.64      A    C  
ATOM    377  O   TYR    84      39.916   1.207   5.433  1.00 69.47      A    O  
ATOM    378  N   PRO    85      42.084   1.534   6.020  1.00 70.58      A    N  
ATOM    379  CA  PRO    85      41.773   2.784   6.721  1.00 70.66      A    C  
ATOM    380  CB  PRO    85      43.114   3.175   7.348  1.00 72.50      A    C  
ATOM    381  CG  PRO    85      44.141   2.518   6.489  1.00 73.96      A    C  
ATOM    382  CD  PRO    85      43.525   1.219   6.080  1.00 72.47      A    C  
ATOM    383  C   PRO    85      41.266   3.886   5.780  1.00 71.62      A    C  
ATOM    384  O   PRO    85      40.622   4.830   6.230  1.00 71.33      A    O  
ATOM    385  N   GLU    86      41.546   3.751   4.485  1.00 73.37      A    N  
ATOM    386  CA  GLU    86      41.039   4.679   3.476  1.00 75.64      A    C  
ATOM    387  CB  GLU    86      41.735   4.463   2.122  1.00 78.50      A    C  
ATOM    388  CG  GLU    86      41.443   3.121   1.422  1.00 78.65      A    C  
ATOM    389  CD  GLU    86      42.359   1.979   1.859  1.00 76.94      A    C  
ATOM    390  OE1 GLU    86      42.547   1.037   1.060  1.00 77.72      A    O  
ATOM    391  OE2 GLU    86      42.890   2.012   2.992  1.00 76.80      A    O  
ATOM    392  C   GLU    86      39.514   4.604   3.332  1.00 75.93      A    C  
ATOM    393  O   GLU    86      38.896   5.510   2.775  1.00 79.57      A    O  
ATOM    394  N   ASN    87      38.915   3.529   3.843  1.00 74.12      A    N  
ATOM    395  CA  ASN    87      37.456   3.377   3.865  1.00 73.88      A    C  
ATOM    396  CB  ASN    87      37.066   1.910   4.057  1.00 72.05      A    C  
ATOM    397  CG  ASN    87      37.319   1.066   2.821  1.00 73.77      A    C  
ATOM    398  OD1 ASN    87      37.855   1.542   1.815  1.00 75.97      A    O  
ATOM    399  ND2 ASN    87      36.926  -0.201   2.891  1.00 74.00      A    N  
ATOM    400  C   ASN    87      36.762   4.227   4.928  1.00 73.27      A    C  
ATOM    401  O   ASN    87      35.550   4.423   4.874  1.00 75.05      A    O  
ATOM    402  N   GLY    88      37.531   4.721   5.894  1.00 71.73      A    N  
ATOM    403  CA  GLY    88      36.985   5.521   6.984  1.00 70.82      A    C  
ATOM    404  C   GLY    88      36.114   4.688   7.898  1.00 69.49      A    C  
ATOM    405  O   GLY    88      36.270   3.471   7.961  1.00 68.16      A    O  
ATOM    406  N   VAL    89      35.206   5.350   8.612  1.00 70.56      A    N  
ATOM    407  CA  VAL    89      34.196   4.670   9.414  1.00 71.17      A    C  
ATOM    408  CB  VAL    89      33.888   5.413  10.748  1.00 72.80      A    C  
ATOM    409  CG1 VAL    89      32.826   4.671  11.550  1.00 73.51      A    C  
ATOM    410  CG2 VAL    89      35.142   5.548  11.580  1.00 71.42      A    C  
ATOM    411  C   VAL    89      32.928   4.502   8.570  1.00 73.41      A    C  
ATOM    412  O   VAL    89      32.409   5.472   8.000  1.00 74.86      A    O  
ATOM    413  N   VAL    90      32.453   3.258   8.493  1.00 73.03      A    N  
ATOM    414  CA  VAL    90      31.321   2.886   7.650  1.00 75.55      A    C  
ATOM    415  CB  VAL    90      31.726   1.802   6.610  1.00 73.49      A    C  
ATOM    416  CG1 VAL    90      30.564   1.471   5.676  1.00 76.90      A    C  
ATOM    417  CG2 VAL    90      32.935   2.247   5.802  1.00 72.13      A    C  
ATOM    418  C   VAL    90      30.170   2.361   8.509  1.00 78.45      A    C  
ATOM    419  O   VAL    90      30.374   1.542   9.411  1.00 77.22      A    O  
ATOM    420  N   GLN    91      28.965   2.843   8.218  1.00 83.52      A    N  
ATOM    421  CA  GLN    91      27.755   2.390   8.897  1.00 87.88      A    C  
ATOM    422  CB  GLN    91      26.682   3.467   8.832  1.00 92.88      A    C  
ATOM    423  CG  GLN    91      27.037   4.717   9.618  1.00 93.91      A    C  
ATOM    424  CD  GLN    91      25.943   5.755   9.589  1.00 99.60      A    C  
ATOM    425  OE1 GLN    91      26.208   6.939   9.389  1.00101.46      A    O  
ATOM    426  NE2 GLN    91      24.703   5.322   9.788  1.00105.50      A    N  
ATOM    427  C   GLN    91      27.243   1.090   8.293  1.00 88.99      A    C  
ATOM    428  O   GLN    91      27.083   0.980   7.079  1.00 90.22      A    O  
ATOM    429  N   MET    92      26.981   0.113   9.156  1.00 90.02      A    N  
ATOM    430  CA  MET    92      26.645  -1.241   8.737  1.00 90.94      A    C  
ATOM    431  CB  MET    92      27.692  -2.221   9.268  1.00 88.07      A    C  
ATOM    432  CG  MET    92      29.111  -1.959   8.803  1.00 88.61      A    C  
ATOM    433  SD  MET    92      29.351  -2.318   6.905  1.00 98.62      A   SE  
ATOM    434  CE  MET    92      28.929  -4.197   6.883  1.00 91.66      A    C  
ATOM    435  C   MET    92      25.273  -1.687   9.236  1.00 95.56      A    C  
ATOM    436  O   MET    92      24.911  -1.435  10.385  1.00 97.05      A    O  
ATOM    437  N   ASN    93      24.522  -2.361   8.368  1.00 97.87      A    N  
ATOM    438  CA  ASN    93      23.301  -3.045   8.779  1.00102.77      A    C  
ATOM    439  CB  ASN    93      22.460  -3.441   7.563  1.00106.54      A    C  
ATOM    440  CG  ASN    93      21.019  -3.772   7.928  1.00114.89      A    C  
ATOM    441  OD1 ASN    93      20.744  -4.745   8.638  1.00116.51      A    O  
ATOM    442  ND2 ASN    93      20.090  -2.967   7.431  1.00121.11      A    N  
ATOM    443  C   ASN    93      23.673  -4.280   9.590  1.00100.09      A    C  
ATOM    444  O   ASN    93      24.659  -4.952   9.284  1.00 94.90      A    O  
ATOM    445  N   SER    94      22.877  -4.571  10.617  1.00103.84      A    N  
ATOM    446  CA  SER    94      23.168  -5.647  11.574  1.00102.37      A    C  
ATOM    447  CB  SER    94      22.088  -5.692  12.660  1.00109.16      A    C  
ATOM    448  OG  SER    94      22.463  -6.552  13.726  1.00109.46      A    O  
ATOM    449  C   SER    94      23.328  -7.033  10.943  1.00 99.33      A    C  
ATOM    450  O   SER    94      23.924  -7.923  11.548  1.00 96.67      A    O  
ATOM    451  N   ARG    95      22.787  -7.207   9.738  1.00100.12      A    N  
ATOM    452  CA  ARG    95      22.866  -8.476   9.012  1.00 98.31      A    C  
ATOM    453  CB  ARG    95      21.658  -8.642   8.083  1.00103.51      A    C  
ATOM    454  CG  ARG    95      21.541  -7.572   7.000  1.00105.74      A    C  
ATOM    455  CD  ARG    95      20.258  -7.724   6.207  1.00112.78      A    C  
ATOM    456  NE  ARG    95      20.009  -6.556   5.366  1.00118.15      A    N  
ATOM    460  C   ARG    95      24.162  -8.567   8.214  1.00 91.56      A    C  
ATOM    461  O   ARG    95      24.609  -9.665   7.850  1.00 88.39      A    O  
ATOM    462  N   ASP    96      24.750  -7.399   7.951  1.00 89.10      A    N  
ATOM    463  CA  ASP    96      25.999  -7.276   7.205  1.00 82.96      A    C  
ATOM    464  CB  ASP    96      25.998  -5.988   6.373  1.00 83.81      A    C  
ATOM    465  CG  ASP    96      25.193  -6.112   5.088  1.00 87.00      A    C  
ATOM    466  OD1 ASP    96      24.933  -7.246   4.636  1.00 87.12      A    O  
ATOM    467  OD2 ASP    96      24.829  -5.063   4.519  1.00 89.68      A    O  
ATOM    468  C   ASP    96      27.236  -7.329   8.109  1.00 78.81      A    C  
ATOM    469  O   ASP    96      28.366  -7.175   7.633  1.00 75.79      A    O  
ATOM    470  N   VAL    97      27.025  -7.546   9.406  1.00 79.24      A    N  
ATOM    471  CA  VAL    97      28.137  -7.792  10.337  1.00 76.33      A    C  
ATOM    472  CB  VAL    97      28.549  -6.514  11.163  1.00 76.33      A    C  
ATOM    473  CG1 VAL    97      27.457  -5.473  11.146  1.00 81.16      A    C  
ATOM    474  CG2 VAL    97      28.977  -6.853  12.599  1.00 76.18      A    C  
ATOM    475  C   VAL    97      27.883  -9.017  11.216  1.00 77.38      A    C  
ATOM    476  O   VAL    97      26.768  -9.236  11.698  1.00 81.25      A    O  
ATOM    477  N   ARG    98      28.926  -9.823  11.394  1.00 73.62      A    N  
ATOM    478  CA  ARG    98      28.844 -11.037  12.197  1.00 74.98      A    C  
ATOM    479  CB  ARG    98      28.402 -12.230  11.333  1.00 74.25      A    C  
ATOM    480  CG  ARG    98      29.415 -12.653  10.279  1.00 69.79      A    C  
ATOM    481  CD  ARG    98      28.820 -13.641   9.295  1.00 70.18      A    C  
ATOM    482  NE  ARG    98      29.792 -14.010   8.269  1.00 67.23      A    N  
ATOM    483  CZ  ARG    98      29.480 -14.503   7.072  1.00 66.25      A    C  
ATOM    484  NH1 ARG    98      28.214 -14.686   6.730  1.00 69.46      A    N  
ATOM    485  NH2 ARG    98      30.438 -14.808   6.209  1.00 62.39      A    N  
ATOM    486  C   ARG    98      30.189 -11.316  12.861  1.00 73.07      A    C  
ATOM    487  O   ARG    98      31.182 -10.655  12.555  1.00 70.00      A    O  
ATOM    488  N   ALA    99      30.215 -12.295  13.763  1.00 75.78      A    N  
ATOM    489  CA  ALA    99      31.446 -12.698  14.440  1.00 76.68      A    C  
ATOM    490  CB  ALA    99      31.164 -13.801  15.444  1.00 79.68      A    C  
ATOM    491  C   ALA    99      32.484 -13.157  13.423  1.00 73.07      A    C  
ATOM    492  O   ALA    99      32.138 -13.801  12.434  1.00 72.70      A    O  
ATOM    493  N   ARG   100      33.748 -12.822  13.671  1.00 72.44      A    N  
ATOM    494  CA  ARG   100      34.839 -13.184  12.777  1.00 71.01      A    C  
ATOM    495  CB  ARG   100      36.168 -12.642  13.305  1.00 71.60      A    C  
ATOM    496  CG  ARG   100      37.275 -12.682  12.273  1.00 71.40      A    C  
ATOM    497  CD  ARG   100      38.385 -11.712  12.580  1.00 73.85      A    C  
ATOM    498  NE  ARG   100      38.010 -10.331  12.296  1.00 73.41      A    N  
ATOM    499  CZ  ARG   100      38.795  -9.285  12.528  1.00 75.14      A    C  
ATOM    500  NH1 ARG   100      38.373  -8.063  12.255  1.00 75.99      A    N  
ATOM    501  NH2 ARG   100      40.004  -9.457  13.035  1.00 80.38      A    N  
ATOM    502  C   ARG   100      34.921 -14.695  12.550  1.00 71.83      A    C  
ATOM    503  O   ARG   100      34.724 -15.474  13.472  1.00 75.13      A    O  
ATOM    504  N   ALA   101      35.185 -15.103  11.312  1.00 71.01      A    N  
ATOM    505  CA  ALA   101      35.329 -16.525  10.994  1.00 72.17      A    C  
ATOM    506  CB  ALA   101      35.429 -16.722   9.503  1.00 68.85      A    C  
ATOM    507  C   ALA   101      36.552 -17.119  11.710  1.00 75.15      A    C  
ATOM    508  O   ALA   101      37.615 -16.494  11.754  1.00 76.06      A    O  
ATOM    509  N   ARG   102      36.393 -18.307  12.292  1.00 77.04      A    N  
ATOM    510  CA  ARG   102      37.495 -18.945  13.018  1.00 80.24      A    C  
ATOM    511  CB  ARG   102      37.422 -18.649  14.532  1.00 84.15      A    C  
ATOM    512  CG  ARG   102      36.203 -19.204  15.271  1.00 87.78      A    C  
ATOM    513  CD  ARG   102      36.375 -19.083  16.790  1.00 94.35      A    C  
ATOM    514  NE  ARG   102      35.293 -19.729  17.539  1.00100.75      A    N  
ATOM    515  CZ  ARG   102      35.301 -21.003  17.926  1.00102.53      A    C  
ATOM    518  C   ARG   102      37.656 -20.449  12.745  1.00 80.42      A    C  
ATOM    519  O   ARG   102      38.732 -21.007  12.968  1.00 82.56      A    O  
ATOM    520  N   THR   103      36.603 -21.092  12.243  1.00 78.34      A    N  
ATOM    521  CA  THR   103      36.599 -22.546  12.083  1.00 78.04      A    C  
ATOM    522  CB  THR   103      35.419 -23.186  12.852  1.00 80.45      A    C  
ATOM    523  OG1 THR   103      35.405 -22.698  14.199  1.00 83.17      A    O  
ATOM    524  CG2 THR   103      35.535 -24.702  12.867  1.00 81.05      A    C  
ATOM    525  C   THR   103      36.580 -22.993  10.620  1.00 74.75      A    C  
ATOM    526  O   THR   103      35.704 -22.597   9.843  1.00 72.85      A    O  
ATOM    527  N   ILE   104      37.563 -23.816  10.260  1.00 74.51      A    N  
ATOM    528  CA  ILE   104      37.632 -24.436   8.939  1.00 71.52      A    C  
ATOM    529  CB  ILE   104      39.104 -24.721   8.524  1.00 72.44      A    C  
ATOM    530  CG1 ILE   104      39.888 -23.415   8.327  1.00 72.05      A    C  
ATOM    531  CD1 ILE   104      39.530 -22.634   7.057  1.00 70.80      A    C  
ATOM    532  CG2 ILE   104      39.176 -25.610   7.273  1.00 71.84      A    C  
ATOM    533  C   ILE   104      36.840 -25.745   8.930  1.00 72.09      A    C  
ATOM    534  O   ILE   104      37.025 -26.603   9.804  1.00 75.02      A    O  
ATOM    535  N   ILE   105      35.952 -25.885   7.951  1.00 69.18      A    N  
ATOM    536  CA  ILE   105      35.303 -27.162   7.691  1.00 69.78      A    C  
ATOM    537  CB  ILE   105      33.883 -26.988   7.109  1.00 68.99      A    C  
ATOM    538  CG1 ILE   105      33.034 -26.087   8.021  1.00 70.06      A    C  
ATOM    539  CD1 ILE   105      31.766 -25.553   7.376  1.00 68.53      A    C  
ATOM    540  CG2 ILE   105      33.218 -28.359   6.902  1.00 69.89      A    C  
ATOM    541  C   ILE   105      36.177 -27.947   6.721  1.00 69.20      A    C  
ATOM    542  O   ILE   105      36.321 -27.559   5.557  1.00 67.81      A    O  
ATOM    543  N   LYS   106      36.768 -29.036   7.213  1.00 71.18      A    N  
ATOM    544  CA  LYS   106      37.645 -29.901   6.409  1.00 71.31      A    C  
ATOM    545  CB  LYS   106      38.240 -31.027   7.268  1.00 74.66      A    C  
ATOM    546  CG  LYS   106      39.235 -30.553   8.327  1.00 78.99      A    C  
ATOM    547  CD  LYS   106      39.729 -31.711   9.190  1.00 83.40      A    C  
ATOM    550  C   LYS   106      36.906 -30.487   5.204  1.00 68.56      A    C  
ATOM    551  O   LYS   106      35.686 -30.651   5.238  1.00 67.81      A    O  
ATOM    552  N   TRP   107      37.645 -30.803   4.143  1.00 67.47      A    N  
ATOM    553  CA  TRP   107      37.031 -31.309   2.911  1.00 66.13      A    C  
ATOM    554  CB  TRP   107      38.099 -31.666   1.875  1.00 65.53      A    C  
ATOM    555  CG  TRP   107      37.617 -32.592   0.793  1.00 64.63      A    C  
ATOM    556  CD1 TRP   107      37.749 -33.948   0.764  1.00 64.45      A    C  
ATOM    557  NE1 TRP   107      37.178 -34.455  -0.377  1.00 65.36      A    N  
ATOM    558  CE2 TRP   107      36.661 -33.425  -1.117  1.00 63.71      A    C  
ATOM    559  CD2 TRP   107      36.913 -32.231  -0.408  1.00 63.14      A    C  
ATOM    560  CE3 TRP   107      36.481 -31.017  -0.957  1.00 60.76      A    C  
ATOM    561  CZ3 TRP   107      35.822 -31.035  -2.188  1.00 63.26      A    C  
ATOM    562  CH2 TRP   107      35.583 -32.242  -2.864  1.00 62.56      A    C  
ATOM    563  CZ2 TRP   107      35.996 -33.441  -2.350  1.00 63.71      A    C  
ATOM    564  C   TRP   107      36.088 -32.487   3.158  1.00 68.02      A    C  
ATOM    565  O   TRP   107      35.038 -32.587   2.516  1.00 67.19      A    O  
ATOM    566  N   GLN   108      36.462 -33.367   4.090  1.00 81.54      A    N  
ATOM    567  CA  GLN   108      35.651 -34.544   4.428  1.00 86.61      A    C  
ATOM    568  CB  GLN   108      36.355 -35.444   5.453  1.00 94.14      A    C  
ATOM    569  CG  GLN   108      37.838 -35.684   5.202  1.00100.96      A    C  
ATOM    570  CD  GLN   108      38.722 -34.745   6.006  1.00102.76      A    C  
ATOM    571  OE1 GLN   108      39.223 -33.746   5.486  1.00 97.70      A    O  
ATOM    572  NE2 GLN   108      38.908 -35.060   7.288  1.00109.40      A    N  
ATOM    573  C   GLN   108      34.288 -34.148   4.977  1.00 84.65      A    C  
ATOM    574  O   GLN   108      33.279 -34.788   4.683  1.00 85.99      A    O  
ATOM    575  N   ASP   109      34.272 -33.087   5.776  1.00 83.07      A    N  
ATOM    576  CA  ASP   109      33.076 -32.667   6.485  1.00 82.93      A    C  
ATOM    577  CB  ASP   109      33.458 -32.054   7.837  1.00 85.14      A    C  
ATOM    578  CG  ASP   109      33.997 -33.091   8.823  1.00 92.55      A    C  
ATOM    579  OD1 ASP   109      33.546 -34.258   8.794  1.00 96.19      A    O  
ATOM    580  OD2 ASP   109      34.871 -32.738   9.637  1.00 95.06      A    O  
ATOM    581  C   ASP   109      32.200 -31.720   5.661  1.00 77.96      A    C  
ATOM    582  O   ASP   109      31.094 -31.376   6.079  1.00 78.84      A    O  
ATOM    583  N   LEU   110      32.685 -31.320   4.488  1.00 74.26      A    N  
ATOM    584  CA  LEU   110      31.899 -30.489   3.577  1.00 70.92      A    C  
ATOM    585  CB  LEU   110      32.768 -29.936   2.443  1.00 67.27      A    C  
ATOM    586  CG  LEU   110      33.781 -28.845   2.798  1.00 65.09      A    C  
ATOM    587  CD1 LEU   110      34.700 -28.569   1.631  1.00 63.20      A    C  
ATOM    588  CD2 LEU   110      33.085 -27.570   3.234  1.00 62.99      A    C  
ATOM    589  C   LEU   110      30.732 -31.285   3.010  1.00 73.58      A    C  
ATOM    590  O   LEU   110      30.908 -32.409   2.549  1.00 76.26      A    O  
ATOM    591  N   GLU   111      29.540 -30.700   3.062  1.00 74.24      A    N  
ATOM    592  CA  GLU   111      28.329 -31.373   2.607  1.00 78.02      A    C  
ATOM    593  CB  GLU   111      27.497 -31.848   3.800  1.00 82.71      A    C  
ATOM    594  CG  GLU   111      28.116 -33.011   4.560  1.00 90.53      A    C  
ATOM    595  CD  GLU   111      27.602 -33.126   5.988  1.00 98.41      A    C  
ATOM    596  OE1 GLU   111      26.455 -33.590   6.180  1.00102.57      A    O  
ATOM    597  OE2 GLU   111      28.355 -32.761   6.920  1.00100.99      A    O  
ATOM    598  C   GLU   111      27.490 -30.469   1.715  1.00 76.64      A    C  
ATOM    599  O   GLU   111      27.457 -29.251   1.901  1.00 75.67      A    O  
ATOM    600  N   VAL   112      26.813 -31.083   0.749  1.00 78.34      A    N  
ATOM    601  CA  VAL   112      25.915 -30.384  -0.168  1.00 77.86      A    C  
ATOM    602  CB  VAL   112      25.330 -31.365  -1.218  1.00 81.46      A    C  
ATOM    603  CG1 VAL   112      24.284 -30.689  -2.078  1.00 82.23      A    C  
ATOM    604  CG2 VAL   112      26.442 -31.937  -2.088  1.00 78.08      A    C  
ATOM    605  C   VAL   112      24.794 -29.655   0.586  1.00 80.43      A    C  
ATOM    606  O   VAL   112      24.029 -30.264   1.345  1.00 83.79      A    O  
ATOM    607  N   GLY   113      24.722 -28.342   0.386  1.00 79.05      A    N  
ATOM    608  CA  GLY   113      23.639 -27.542   0.943  1.00 82.32      A    C  
ATOM    609  C   GLY   113      24.029 -26.621   2.082  1.00 81.33      A    C  
ATOM    610  O   GLY   113      23.254 -25.742   2.463  1.00 84.67      A    O  
ATOM    611  N   GLN   114      25.226 -26.827   2.628  1.00 77.51      A    N  
ATOM    612  CA  GLN   114      25.771 -25.961   3.668  1.00 76.18      A    C  
ATOM    613  CB  GLN   114      27.088 -26.527   4.198  1.00 74.01      A    C  
ATOM    614  CG  GLN   114      26.983 -27.842   4.950  1.00 78.35      A    C  
ATOM    615  CD  GLN   114      28.343 -28.391   5.344  1.00 76.40      A    C  
ATOM    616  OE1 GLN   114      29.316 -28.243   4.614  1.00 73.16      A    O  
ATOM    617  NE2 GLN   114      28.412 -29.031   6.502  1.00 82.18      A    N  
ATOM    618  C   GLN   114      26.038 -24.559   3.130  1.00 73.65      A    C  
ATOM    619  O   GLN   114      26.486 -24.404   1.987  1.00 70.71      A    O  
ATOM    620  N   VAL   115      25.760 -23.544   3.949  1.00 75.05      A    N  
ATOM    621  CA  VAL   115      26.222 -22.194   3.640  1.00 72.83      A    C  
ATOM    622  CB  VAL   115      25.147 -21.100   3.813  1.00 76.99      A    C  
ATOM    623  CG1 VAL   115      23.943 -21.419   2.939  1.00 81.10      A    C  
ATOM    624  CG2 VAL   115      24.744 -20.935   5.272  1.00 83.11      A    C  
ATOM    625  C   VAL   115      27.496 -21.896   4.416  1.00 70.02      A    C  
ATOM    626  O   VAL   115      27.543 -21.972   5.652  1.00 71.87      A    O  
ATOM    627  N   VAL   116      28.535 -21.575   3.657  1.00 65.64      A    N  
ATOM    628  CA  VAL   116      29.880 -21.463   4.175  1.00 63.59      A    C  
ATOM    629  CB  VAL   116      30.730 -22.663   3.704  1.00 62.16      A    C  
ATOM    630  CG1 VAL   116      30.220 -23.965   4.306  1.00 63.67      A    C  
ATOM    631  CG2 VAL   116      30.729 -22.751   2.189  1.00 60.61      A    C  
ATOM    632  C   VAL   116      30.519 -20.168   3.671  1.00 62.26      A    C  
ATOM    633  O   VAL   116      29.996 -19.539   2.752  1.00 61.77      A    O  
ATOM    634  N   MET   117      31.639 -19.770   4.276  1.00 61.42      A    N  
ATOM    635  CA  MET   117      32.456 -18.698   3.712  1.00 60.96      A    C  
ATOM    636  CB  MET   117      32.820 -17.642   4.757  1.00 61.90      A    C  
ATOM    637  CG  MET   117      33.221 -16.318   4.116  1.00 62.48      A    C  
ATOM    638  SD  MET   117      33.916 -15.018   5.390  1.00 66.12      A   SE  
ATOM    639  CE  MET   117      35.602 -15.886   5.817  1.00 66.17      A    C  
ATOM    640  C   MET   117      33.716 -19.269   3.064  1.00 58.29      A    C  
ATOM    641  O   MET   117      34.464 -20.014   3.688  1.00 59.06      A    O  
ATOM    642  N   LEU   118      33.946 -18.901   1.812  1.00 57.12      A    N  
ATOM    643  CA  LEU   118      35.039 -19.463   1.034  1.00 56.29      A    C  
ATOM    644  CB  LEU   118      34.557 -20.698   0.265  1.00 56.76      A    C  
ATOM    645  CG  LEU   118      33.252 -20.615  -0.531  1.00 57.64      A    C  
ATOM    646  CD1 LEU   118      33.420 -19.891  -1.874  1.00 59.59      A    C  
ATOM    647  CD2 LEU   118      32.730 -22.021  -0.747  1.00 60.22      A    C  
ATOM    648  C   LEU   118      35.646 -18.452   0.064  1.00 56.96      A    C  
ATOM    649  O   LEU   118      35.047 -17.412  -0.233  1.00 57.12      A    O  
ATOM    650  N   ASN   119      36.832 -18.789  -0.438  1.00 56.86      A    N  
ATOM    651  CA  ASN   119      37.591 -17.907  -1.306  1.00 57.26      A    C  
ATOM    652  CB  ASN   119      39.094 -18.065  -1.047  1.00 58.13      A    C  
ATOM    653  CG  ASN   119      39.881 -16.825  -1.412  1.00 59.37      A    C  
ATOM    654  OD1 ASN   119      40.059 -16.510  -2.592  1.00 52.64      A    O  
ATOM    655  ND2 ASN   119      40.346 -16.097  -0.389  1.00 56.44      A    N  
ATOM    656  C   ASN   119      37.264 -18.177  -2.756  1.00 58.04      A    C  
ATOM    657  O   ASN   119      37.354 -19.312  -3.229  1.00 59.26      A    O  
ATOM    658  N   TYR   120      36.866 -17.127  -3.459  1.00 58.92      A    N  
ATOM    659  CA  TYR   120      36.514 -17.235  -4.856  1.00 58.75      A    C  
ATOM    660  CB  TYR   120      35.028 -17.595  -4.993  1.00 60.08      A    C  
ATOM    661  CG  TYR   120      34.561 -17.864  -6.416  1.00 63.34      A    C  
ATOM    662  CD1 TYR   120      35.007 -18.984  -7.126  1.00 65.99      A    C  
ATOM    663  CE1 TYR   120      34.575 -19.233  -8.437  1.00 67.83      A    C  
ATOM    664  CZ  TYR   120      33.681 -18.356  -9.046  1.00 74.16      A    C  
ATOM    665  OH  TYR   120      33.240 -18.592 -10.343  1.00 80.05      A    O  
ATOM    666  CE2 TYR   120      33.219 -17.243  -8.356  1.00 72.18      A    C  
ATOM    667  CD2 TYR   120      33.662 -17.003  -7.047  1.00 68.44      A    C  
ATOM    668  C   TYR   120      36.837 -15.934  -5.568  1.00 61.83      A    C  
ATOM    669  O   TYR   120      36.938 -14.887  -4.938  1.00 58.65      A    O  
ATOM    670  N   ASN   121      36.987 -16.005  -6.894  1.00 66.19      A    N  
ATOM    671  CA  ASN   121      37.288 -14.834  -7.695  1.00 69.65      A    C  
ATOM    672  CB  ASN   121      38.759 -14.832  -8.091  1.00 71.49      A    C  
ATOM    673  CG  ASN   121      39.213 -13.497  -8.646  1.00 78.45      A    C  
ATOM    674  OD1 ASN   121      38.577 -12.918  -9.538  1.00 85.52      A    O  
ATOM    675  ND2 ASN   121      40.341 -13.013  -8.144  1.00 77.55      A    N  
ATOM    676  C   ASN   121      36.384 -14.766  -8.924  1.00 77.49      A    C  
ATOM    677  O   ASN   121      36.703 -15.335  -9.972  1.00 78.65      A    O  
ATOM    678  N   PRO   122      35.246 -14.063  -8.791  1.00 80.08      A    N  
ATOM    679  CA  PRO   122      34.210 -13.957  -9.812  1.00 86.20      A    C  
ATOM    680  CB  PRO   122      33.292 -12.865  -9.259  1.00 86.42      A    C  
ATOM    681  CG  PRO   122      33.448 -12.974  -7.791  1.00 82.10      A    C  
ATOM    682  CD  PRO   122      34.890 -13.316  -7.567  1.00 76.62      A    C  
ATOM    683  C   PRO   122      34.740 -13.582 -11.205  1.00 95.34      A    C  
ATOM    684  O   PRO   122      34.304 -14.165 -12.200  1.00 98.08      A    O  
ATOM    685  N   ASP   123      35.680 -12.637 -11.255  1.00 98.70      A    N  
ATOM    686  CA  ASP   123      36.210 -12.096 -12.512  1.00107.79      A    C  
ATOM    687  CB  ASP   123      36.952 -10.783 -12.250  1.00110.01      A    C  
ATOM    688  CG  ASP   123      36.012  -9.599 -12.080  1.00113.62      A    C  
ATOM    689  OD1 ASP   123      35.072  -9.457 -12.894  1.00118.87      A    O  
ATOM    690  OD2 ASP   123      36.223  -8.800 -11.140  1.00109.85      A    O  
ATOM    691  C   ASP   123      37.124 -13.073 -13.247  1.00110.22      A    C  
ATOM    692  O   ASP   123      37.163 -13.092 -14.484  1.00119.05      A    O  
ATOM    693  N   ASN   124      37.868 -13.860 -12.472  1.00104.22      A    N  
ATOM    694  CA  ASN   124      38.691 -14.958 -12.984  1.00106.51      A    C  
ATOM    695  CB  ASN   124      40.090 -14.477 -13.400  1.00111.43      A    C  
ATOM    696  CG  ASN   124      40.625 -13.375 -12.508  1.00109.34      A    C  
ATOM    697  OD1 ASN   124      40.850 -12.255 -12.961  1.00114.42      A    O  
ATOM    698  ND2 ASN   124      40.823 -13.685 -11.229  1.00102.69      A    N  
ATOM    699  C   ASN   124      38.754 -16.096 -11.960  1.00 99.63      A    C  
ATOM    700  O   ASN   124      39.585 -16.073 -11.036  1.00 94.87      A    O  
ATOM    701  N   PRO   125      37.834 -17.072 -12.096  1.00 98.76      A    N  
ATOM    702  CA  PRO   125      37.609 -18.161 -11.135  1.00 93.07      A    C  
ATOM    703  CB  PRO   125      36.475 -18.965 -11.787  1.00 95.03      A    C  
ATOM    704  CG  PRO   125      35.763 -17.960 -12.623  1.00100.37      A    C  
ATOM    705  CD  PRO   125      36.874 -17.146 -13.209  1.00104.85      A    C  
ATOM    706  C   PRO   125      38.812 -19.059 -10.845  1.00 92.16      A    C  
ATOM    707  O   PRO   125      38.794 -19.805  -9.862  1.00 88.10      A    O  
ATOM    708  N   LYS   126      39.842 -18.980 -11.681  1.00 97.48      A    N  
ATOM    709  CA  LYS   126      41.031 -19.804 -11.512  1.00 97.83      A    C  
ATOM    710  CB  LYS   126      41.771 -19.925 -12.846  1.00106.86      A    C  
ATOM    711  CG  LYS   126      42.246 -21.332 -13.163  1.00110.33      A    C  
ATOM    712  CD  LYS   126      42.605 -21.471 -14.634  1.00120.99      A    C  
ATOM    715  C   LYS   126      41.958 -19.245 -10.424  1.00 93.86      A    C  
ATOM    716  O   LYS   126      42.812 -19.961  -9.895  1.00 93.82      A    O  
ATOM    717  N   GLU   127      41.772 -17.973 -10.080  1.00 90.96      A    N  
ATOM    718  CA  GLU   127      42.707 -17.271  -9.204  1.00 89.03      A    C  
ATOM    719  CB  GLU   127      43.092 -15.909  -9.803  1.00 93.54      A    C  
ATOM    720  CG  GLU   127      43.371 -15.901 -11.315  1.00103.30      A    C  
ATOM    721  CD  GLU   127      44.637 -16.650 -11.711  1.00110.07      A    C  
ATOM    722  OE1 GLU   127      45.603 -16.662 -10.911  1.00107.71      A    O  
ATOM    723  OE2 GLU   127      44.666 -17.215 -12.835  1.00117.64      A    O  
ATOM    724  C   GLU   127      42.157 -17.070  -7.795  1.00 81.22      A    C  
ATOM    725  O   GLU   127      40.973 -17.283  -7.540  1.00 77.05      A    O  
ATOM    726  N   ARG   128      43.042 -16.663  -6.890  1.00 79.99      A    N  
ATOM    727  CA  ARG   128      42.665 -16.219  -5.550  1.00 75.18      A    C  
ATOM    728  CB  ARG   128      43.931 -15.974  -4.728  1.00 76.60      A    C  
ATOM    729  CG  ARG   128      43.724 -15.886  -3.242  1.00 73.49      A    C  
ATOM    730  CD  ARG   128      44.193 -17.147  -2.542  1.00 75.64      A    C  
ATOM    731  NE  ARG   128      43.646 -17.232  -1.188  1.00 72.47      A    N  
ATOM    732  CZ  ARG   128      43.729 -18.300  -0.402  1.00 70.66      A    C  
ATOM    733  NH1 ARG   128      44.344 -19.402  -0.816  1.00 72.28      A    N  
ATOM    734  NH2 ARG   128      43.187 -18.265   0.806  1.00 68.19      A    N  
ATOM    735  C   ARG   128      41.853 -14.923  -5.645  1.00 73.74      A    C  
ATOM    736  O   ARG   128      42.171 -14.051  -6.458  1.00 78.40      A    O  
ATOM    737  N   GLY   129      40.801 -14.816  -4.832  1.00 68.65      A    N  
ATOM    738  CA  GLY   129      39.968 -13.607  -4.753  1.00 67.08      A    C  
ATOM    739  C   GLY   129      39.572 -13.235  -3.324  1.00 63.44      A    C  
ATOM    740  O   GLY   129      40.431 -13.034  -2.461  1.00 62.31      A    O  
ATOM    741  N   PHE   130      38.265 -13.163  -3.078  1.00 61.38      A    N  
ATOM    742  CA  PHE   130      37.728 -12.673  -1.812  1.00 59.66      A    C  
ATOM    743  CB  PHE   130      36.996 -11.352  -2.025  1.00 63.17      A    C  
ATOM    744  CG  PHE   130      37.902 -10.225  -2.408  1.00 68.02      A    C  
ATOM    745  CD1 PHE   130      38.714  -9.614  -1.451  1.00 66.81      A    C  
ATOM    746  CE1 PHE   130      39.567  -8.575  -1.803  1.00 70.40      A    C  
ATOM    747  CZ  PHE   130      39.615  -8.142  -3.122  1.00 73.35      A    C  
ATOM    748  CE2 PHE   130      38.814  -8.750  -4.085  1.00 74.05      A    C  
ATOM    749  CD2 PHE   130      37.966  -9.788  -3.726  1.00 69.66      A    C  
ATOM    750  C   PHE   130      36.801 -13.666  -1.143  1.00 57.34      A    C  
ATOM    751  O   PHE   130      36.334 -14.608  -1.796  1.00 55.77      A    O  
ATOM    752  N   TRP   131      36.561 -13.442   0.159  1.00 49.70      A    N  
ATOM    753  CA  TRP   131      35.706 -14.272   0.989  1.00 51.23      A    C  
ATOM    754  CB  TRP   131      36.162 -14.149   2.445  1.00 50.95      A    C  
ATOM    755  CG  TRP   131      37.572 -14.545   2.508  1.00 47.90      A    C  
ATOM    756  CD1 TRP   131      38.665 -13.738   2.335  1.00 46.38      A    C  
ATOM    757  NE1 TRP   131      39.818 -14.490   2.399  1.00 43.72      A    N  
ATOM    758  CE2 TRP   131      39.480 -15.811   2.579  1.00 43.47      A    C  
ATOM    759  CD2 TRP   131      38.070 -15.884   2.632  1.00 47.54      A    C  
ATOM    760  CE3 TRP   131      37.460 -17.139   2.809  1.00 50.34      A    C  
ATOM    761  CZ3 TRP   131      38.272 -18.267   2.948  1.00 49.31      A    C  
ATOM    762  CH2 TRP   131      39.676 -18.159   2.898  1.00 47.35      A    C  
ATOM    763  CZ2 TRP   131      40.296 -16.946   2.703  1.00 45.25      A    C  
ATOM    764  C   TRP   131      34.214 -13.976   0.855  1.00 56.74      A    C  
ATOM    765  O   TRP   131      33.694 -13.045   1.493  1.00 58.95      A    O  
ATOM    766  N   TYR   132      33.546 -14.787   0.027  1.00 57.70      A    N  
ATOM    767  CA  TYR   132      32.093 -14.756  -0.155  1.00 62.06      A    C  
ATOM    768  CB  TYR   132      31.738 -14.902  -1.640  1.00 64.36      A    C  
ATOM    769  CG  TYR   132      32.346 -13.845  -2.512  1.00 66.16      A    C  
ATOM    770  CD1 TYR   132      31.693 -12.636  -2.724  1.00 69.59      A    C  
ATOM    771  CE1 TYR   132      32.252 -11.656  -3.516  1.00 70.75      A    C  
ATOM    772  CZ  TYR   132      33.480 -11.880  -4.109  1.00 68.34      A    C  
ATOM    773  OH  TYR   132      34.038 -10.905  -4.903  1.00 72.83      A    O  
ATOM    774  CE2 TYR   132      34.149 -13.073  -3.917  1.00 64.55      A    C  
ATOM    775  CD2 TYR   132      33.579 -14.048  -3.122  1.00 64.03      A    C  
ATOM    776  C   TYR   132      31.413 -15.900   0.577  1.00 61.98      A    C  
ATOM    777  O   TYR   132      32.010 -16.959   0.773  1.00 60.18      A    O  
ATOM    778  N   ASP   133      30.155 -15.686   0.959  1.00 64.85      A    N  
ATOM    779  CA  ASP   133      29.273 -16.783   1.352  1.00 65.55      A    C  
ATOM    780  CB  ASP   133      28.057 -16.258   2.099  1.00 68.42      A    C  
ATOM    781  CG  ASP   133      28.402 -15.750   3.477  1.00 69.42      A    C  
ATOM    782  OD1 ASP   133      29.599 -15.713   3.823  1.00 64.53      A    O  
ATOM    783  OD2 ASP   133      27.468 -15.378   4.215  1.00 76.31      A    O  
ATOM    784  C   ASP   133      28.823 -17.591   0.136  1.00 66.63      A    C  
ATOM    785  O   ASP   133      28.615 -17.038  -0.950  1.00 67.26      A    O  
ATOM    786  N   ALA   134      28.668 -18.897   0.333  1.00 65.82      A    N  
ATOM    787  CA  ALA   134      28.311 -19.804  -0.745  1.00 67.57      A    C  
ATOM    788  CB  ALA   134      29.558 -20.239  -1.510  1.00 64.02      A    C  
ATOM    789  C   ALA   134      27.558 -21.022  -0.232  1.00 69.20      A    C  
ATOM    790  O   ALA   134      27.790 -21.492   0.884  1.00 68.34      A    O  
ATOM    791  N   GLU   135      26.655 -21.525  -1.066  1.00 72.04      A    N  
ATOM    792  CA  GLU   135      25.925 -22.744  -0.785  1.00 72.93      A    C  
ATOM    793  CB  GLU   135      24.484 -22.591  -1.263  1.00 77.11      A    C  
ATOM    794  CG  GLU   135      23.524 -23.682  -0.821  1.00 78.37      A    C  
ATOM    795  CD  GLU   135      22.088 -23.368  -1.212  1.00 84.76      A    C  
ATOM    796  OE1 GLU   135      21.844 -23.039  -2.399  1.00 85.93      A    O  
ATOM    797  OE2 GLU   135      21.203 -23.447  -0.328  1.00 88.15      A    O  
ATOM    798  C   GLU   135      26.616 -23.878  -1.529  1.00 71.76      A    C  
ATOM    799  O   GLU   135      26.707 -23.854  -2.758  1.00 73.06      A    O  
ATOM    800  N   ILE   136      27.121 -24.862  -0.792  1.00 69.88      A    N  
ATOM    801  CA  ILE   136      27.764 -26.015  -1.425  1.00 68.91      A    C  
ATOM    802  CB  ILE   136      28.472 -26.926  -0.400  1.00 67.43      A    C  
ATOM    803  CG1 ILE   136      29.694 -26.201   0.170  1.00 62.29      A    C  
ATOM    804  CD1 ILE   136      29.976 -26.548   1.601  1.00 63.43      A    C  
ATOM    805  CG2 ILE   136      28.913 -28.244  -1.043  1.00 67.94      A    C  
ATOM    806  C   ILE   136      26.741 -26.759  -2.275  1.00 72.33      A    C  
ATOM    807  O   ILE   136      25.671 -27.145  -1.795  1.00 74.69      A    O  
ATOM    808  N   SER   137      27.080 -26.921  -3.548  1.00 72.39      A    N  
ATOM    809  CA  SER   137      26.134 -27.344  -4.560  1.00 76.27      A    C  
ATOM    810  CB  SER   137      26.209 -26.382  -5.745  1.00 76.90      A    C  
ATOM    811  OG  SER   137      25.221 -26.684  -6.705  1.00 82.68      A    O  
ATOM    812  C   SER   137      26.401 -28.785  -5.001  1.00 77.57      A    C  
ATOM    813  O   SER   137      25.517 -29.638  -4.931  1.00 79.63      A    O  
ATOM    814  N   ARG   138      27.628 -29.038  -5.451  1.00 76.31      A    N  
ATOM    815  CA  ARG   138      28.067 -30.361  -5.869  1.00 77.35      A    C  
ATOM    816  CB  ARG   138      28.178 -30.448  -7.393  1.00 79.55      A    C  
ATOM    817  CG  ARG   138      26.877 -30.215  -8.119  1.00 85.11      A    C  
ATOM    818  CD  ARG   138      26.947 -30.659  -9.564  1.00 89.42      A    C  
ATOM    819  NE  ARG   138      27.580 -29.666 -10.429  1.00 89.97      A    N  
ATOM    820  CZ  ARG   138      28.649 -29.898 -11.183  1.00 89.04      A    C  
ATOM    821  NH1 ARG   138      29.145 -28.930 -11.941  1.00 88.78      A    N  
ATOM    822  NH2 ARG   138      29.218 -31.098 -11.191  1.00 89.11      A    N  
ATOM    823  C   ARG   138      29.419 -30.657  -5.251  1.00 74.79      A    C  
ATOM    824  O   ARG   138      30.264 -29.765  -5.126  1.00 71.88      A    O  
ATOM    825  N   LYS   139      29.613 -31.914  -4.866  1.00 75.98      A    N  
ATOM    826  CA  LYS   139      30.874 -32.372  -4.306  1.00 74.86      A    C  
ATOM    827  CB  LYS   139      30.779 -32.469  -2.782  1.00 73.48      A    C  
ATOM    828  CG  LYS   139      32.087 -32.834  -2.115  1.00 71.58      A    C  
ATOM    829  CD  LYS   139      31.904 -32.996  -0.626  1.00 72.19      A    C  
ATOM    830  CE  LYS   139      33.155 -33.579  -0.006  1.00 72.78      A    C  
ATOM    831  NZ  LYS   139      32.987 -33.821   1.453  1.00 73.28      A    N  
ATOM    832  C   LYS   139      31.272 -33.712  -4.933  1.00 77.81      A    C  
ATOM    833  O   LYS   139      30.529 -34.697  -4.856  1.00 79.78      A    O  
ATOM    834  N   ARG   140      32.446 -33.724  -5.561  1.00 77.81      A    N  
ATOM    835  CA  ARG   140      32.943 -34.878  -6.310  1.00 80.86      A    C  
ATOM    836  CB  ARG   140      32.831 -34.614  -7.815  1.00 83.30      A    C  
ATOM    837  CG  ARG   140      31.731 -35.391  -8.524  1.00 91.05      A    C  
ATOM    838  CD  ARG   140      32.212 -36.778  -8.943  1.00 96.65      A    C  
ATOM    839  NE  ARG   140      33.416 -36.699  -9.771  1.00 98.96      A    N  
ATOM    840  CZ  ARG   140      33.469 -36.995 -11.067  1.00103.38      A    C  
ATOM    841  NH1 ARG   140      32.384 -37.411 -11.709  1.00108.22      A    N  
ATOM    842  NH2 ARG   140      34.617 -36.887 -11.723  1.00103.90      A    N  
ATOM    843  C   ARG   140      34.393 -35.183  -5.967  1.00 79.17      A    C  
ATOM    844  O   ARG   140      35.221 -34.279  -5.877  1.00 76.53      A    O  
ATOM    845  N   GLU   141      34.702 -36.461  -5.784  1.00 80.97      A    N  
ATOM    846  CA  GLU   141      36.079 -36.872  -5.552  1.00 80.09      A    C  
ATOM    847  CB  GLU   141      36.318 -37.213  -4.081  1.00 78.65      A    C  
ATOM    848  CG  GLU   141      37.779 -37.137  -3.680  1.00 78.55      A    C  
ATOM    849  CD  GLU   141      38.015 -37.247  -2.182  1.00 77.93      A    C  
ATOM    850  OE1 GLU   141      37.038 -37.196  -1.405  1.00 78.44      A    O  
ATOM    851  OE2 GLU   141      39.194 -37.383  -1.781  1.00 77.29      A    O  
ATOM    852  C   GLU   141      36.508 -38.020  -6.465  1.00 83.79      A    C  
ATOM    853  O   GLU   141      35.761 -38.959  -6.720  1.00 86.12      A    O  
ATOM    854  N   THR   142      37.732 -37.899  -6.956  1.00 63.92      A    N  
ATOM    855  CA  THR   142      38.372 -38.851  -7.848  1.00 63.74      A    C  
ATOM    856  CB  THR   142      38.654 -38.156  -9.215  1.00 66.30      A    C  
ATOM    857  OG1 THR   142      37.666 -38.567 -10.168  1.00 66.73      A    O  
ATOM    858  CG2 THR   142      40.026 -38.473  -9.776  1.00 71.31      A    C  
ATOM    859  C   THR   142      39.630 -39.330  -7.117  1.00 63.29      A    C  
ATOM    860  O   THR   142      39.944 -38.823  -6.025  1.00 64.51      A    O  
ATOM    861  N   ARG   143      40.326 -40.317  -7.675  1.00 63.14      A    N  
ATOM    862  CA  ARG   143      41.597 -40.770  -7.109  1.00 63.64      A    C  
ATOM    863  CB  ARG   143      42.221 -41.858  -7.977  1.00 64.32      A    C  
ATOM    864  CG  ARG   143      41.596 -43.245  -7.869  1.00 64.07      A    C  
ATOM    865  CD  ARG   143      42.347 -44.211  -8.831  1.00 64.06      A    C  
ATOM    866  NE  ARG   143      41.787 -45.568  -8.930  1.00 62.34      A    N  
ATOM    867  CZ  ARG   143      41.671 -46.437  -7.915  1.00 62.98      A    C  
ATOM    868  NH1 ARG   143      42.045 -46.114  -6.669  1.00 52.94      A    N  
ATOM    869  NH2 ARG   143      41.163 -47.643  -8.148  1.00 61.64      A    N  
ATOM    870  C   ARG   143      42.601 -39.619  -6.916  1.00 65.93      A    C  
ATOM    871  O   ARG   143      43.346 -39.596  -5.929  1.00 67.55      A    O  
ATOM    872  N   THR   144      42.601 -38.666  -7.848  1.00 67.27      A    N  
ATOM    873  CA  THR   144      43.565 -37.562  -7.855  1.00 71.21      A    C  
ATOM    874  CB  THR   144      44.425 -37.591  -9.130  1.00 74.46      A    C  
ATOM    875  OG1 THR   144      43.566 -37.704 -10.270  1.00 74.50      A    O  
ATOM    876  CG2 THR   144      45.397 -38.767  -9.108  1.00 73.69      A    C  
ATOM    877  C   THR   144      42.938 -36.165  -7.756  1.00 73.03      A    C  
ATOM    878  O   THR   144      43.651 -35.186  -7.568  1.00 77.46      A    O  
ATOM    879  N   ALA   145      41.617 -36.073  -7.882  1.00 71.51      A    N  
ATOM    880  CA  ALA   145      40.935 -34.776  -7.947  1.00 73.21      A    C  
ATOM    881  CB  ALA   145      40.374 -34.544  -9.350  1.00 74.63      A    C  
ATOM    882  C   ALA   145      39.825 -34.619  -6.906  1.00 70.73      A    C  
ATOM    883  O   ALA   145      39.049 -35.544  -6.667  1.00 68.81      A    O  
ATOM    884  N   ARG   146      39.765 -33.441  -6.291  1.00 72.52      A    N  
ATOM    885  CA  ARG   146      38.660 -33.067  -5.401  1.00 71.12      A    C  
ATOM    886  CB  ARG   146      39.164 -32.716  -4.001  1.00 70.21      A    C  
ATOM    887  CG  ARG   146      39.659 -33.912  -3.215  1.00 70.44      A    C  
ATOM    888  CD  ARG   146      40.246 -33.502  -1.882  1.00 72.19      A    C  
ATOM    889  NE  ARG   146      41.331 -32.537  -2.043  1.00 76.34      A    N  
ATOM    890  CZ  ARG   146      41.717 -31.677  -1.105  1.00 79.37      A    C  
ATOM    891  NH1 ARG   146      41.109 -31.647   0.073  1.00 79.76      A    N  
ATOM    892  NH2 ARG   146      42.708 -30.834  -1.349  1.00 84.02      A    N  
ATOM    893  C   ARG   146      37.908 -31.892  -6.008  1.00 72.38      A    C  
ATOM    894  O   ARG   146      38.483 -30.830  -6.257  1.00 76.52      A    O  
ATOM    895  N   GLU   147      36.620 -32.088  -6.255  1.00 70.89      A    N  
ATOM    896  CA  GLU   147      35.828 -31.092  -6.962  1.00 72.27      A    C  
ATOM    897  CB  GLU   147      35.261 -31.688  -8.251  1.00 73.83      A    C  
ATOM    898  CG  GLU   147      36.336 -32.129  -9.238  1.00 78.97      A    C  
ATOM    899  CD  GLU   147      35.844 -33.164 -10.233  1.00 82.68      A    C  
ATOM    900  OE1 GLU   147      34.708 -33.023 -10.738  1.00 85.63      A    O  
ATOM    901  OE2 GLU   147      36.602 -34.121 -10.510  1.00 83.65      A    O  
ATOM    902  C   GLU   147      34.718 -30.537  -6.081  1.00 69.40      A    C  
ATOM    903  O   GLU   147      33.914 -31.289  -5.531  1.00 67.18      A    O  
ATOM    904  N   LEU   148      34.692 -29.215  -5.949  1.00 69.74      A    N  
ATOM    905  CA  LEU   148      33.662 -28.544  -5.175  1.00 67.30      A    C  
ATOM    906  CB  LEU   148      34.243 -27.963  -3.884  1.00 66.54      A    C  
ATOM    907  CG  LEU   148      33.276 -27.429  -2.823  1.00 64.58      A    C  
ATOM    908  CD1 LEU   148      32.415 -28.550  -2.267  1.00 59.27      A    C  
ATOM    909  CD2 LEU   148      34.048 -26.727  -1.710  1.00 63.81      A    C  
ATOM    910  C   LEU   148      32.982 -27.463  -6.002  1.00 70.05      A    C  
ATOM    911  O   LEU   148      33.641 -26.629  -6.631  1.00 72.97      A    O  
ATOM    912  N   TYR   149      31.654 -27.507  -6.004  1.00 69.71      A    N  
ATOM    913  CA  TYR   149      30.842 -26.527  -6.707  1.00 71.79      A    C  
ATOM    914  CB  TYR   149      30.053 -27.187  -7.847  1.00 74.98      A    C  
ATOM    915  CG  TYR   149      30.963 -27.719  -8.929  1.00 78.32      A    C  
ATOM    916  CD1 TYR   149      31.505 -29.004  -8.844  1.00 76.82      A    C  
ATOM    917  CE1 TYR   149      32.363 -29.492  -9.827  1.00 79.06      A    C  
ATOM    918  CZ  TYR   149      32.694 -28.685 -10.903  1.00 84.35      A    C  
ATOM    919  OH  TYR   149      33.544 -29.160 -11.878  1.00 88.75      A    O  
ATOM    920  CE2 TYR   149      32.173 -27.404 -11.008  1.00 86.90      A    C  
ATOM    921  CD2 TYR   149      31.317 -26.926 -10.020  1.00 83.14      A    C  
ATOM    922  C   TYR   149      29.935 -25.839  -5.704  1.00 69.60      A    C  
ATOM    923  O   TYR   149      29.459 -26.466  -4.757  1.00 67.80      A    O  
ATOM    924  N   ALA   150      29.723 -24.543  -5.896  1.00 70.24      A    N  
ATOM    925  CA  ALA   150      28.964 -23.765  -4.941  1.00 68.76      A    C  
ATOM    926  CB  ALA   150      29.885 -23.235  -3.834  1.00 67.20      A    C  
ATOM    927  C   ALA   150      28.202 -22.625  -5.596  1.00 72.22      A    C  
ATOM    928  O   ALA   150      28.631 -22.069  -6.612  1.00 74.74      A    O  
ATOM    929  N   ASN   151      27.055 -22.303  -5.003  1.00 72.44      A    N  
ATOM    930  CA  ASN   151      26.300 -21.119  -5.350  1.00 76.20      A    C  
ATOM    931  CB  ASN   151      24.810 -21.330  -5.072  1.00 76.85      A    C  
ATOM    932  CG  ASN   151      24.247 -22.554  -5.770  1.00 79.45      A    C  
ATOM    933  OD1 ASN   151      24.580 -22.845  -6.918  1.00 79.71      A    O  
ATOM    934  ND2 ASN   151      23.380 -23.276  -5.073  1.00 80.94      A    N  
ATOM    935  C   ASN   151      26.839 -19.979  -4.507  1.00 76.24      A    C  
ATOM    936  O   ASN   151      26.602 -19.927  -3.295  1.00 75.45      A    O  
ATOM    937  N   VAL   152      27.584 -19.081  -5.143  1.00 79.41      A    N  
ATOM    938  CA  VAL   152      28.259 -17.990  -4.444  1.00 79.50      A    C  
ATOM    939  CB  VAL   152      29.614 -17.661  -5.119  1.00 82.99      A    C  
ATOM    940  CG1 VAL   152      30.288 -16.454  -4.472  1.00 83.32      A    C  
ATOM    941  CG2 VAL   152      30.527 -18.868  -5.071  1.00 80.21      A    C  
ATOM    942  C   VAL   152      27.350 -16.759  -4.391  1.00 82.04      A    C  
ATOM    943  O   VAL   152      26.821 -16.325  -5.418  1.00 85.53      A    O  
ATOM    944  N   VAL   153      27.170 -16.213  -3.190  1.00 80.24      A    N  
ATOM    945  CA  VAL   153      26.318 -15.043  -2.970  1.00 81.79      A    C  
ATOM    946  CB  VAL   153      25.723 -15.040  -1.539  1.00 78.70      A    C  
ATOM    947  CG1 VAL   153      24.841 -13.821  -1.319  1.00 78.84      A    C  
ATOM    948  CG2 VAL   153      24.932 -16.323  -1.290  1.00 76.38      A    C  
ATOM    949  C   VAL   153      27.097 -13.751  -3.232  1.00 86.30      A    C  
ATOM    950  O   VAL   153      28.098 -13.467  -2.562  1.00 86.64      A    O  
ATOM    951  N   LEU   154      26.615 -12.970  -4.199  1.00 90.89      A    N  
ATOM    952  CA  LEU   154      27.335 -11.803  -4.699  1.00 96.61      A    C  
ATOM    953  CB  LEU   154      27.674 -12.010  -6.177  1.00102.18      A    C  
ATOM    954  CG  LEU   154      29.126 -11.829  -6.622  1.00107.79      A    C  
ATOM    955  CD1 LEU   154      29.946 -13.084  -6.325  1.00104.39      A    C  
ATOM    956  CD2 LEU   154      29.195 -11.476  -8.100  1.00115.33      A    C  
ATOM    957  C   LEU   154      26.523 -10.521  -4.528  1.00 98.73      A    C  
ATOM    958  O   LEU   154      26.057 -10.203  -3.430  1.00 95.85      A    O  
ATOM    959  N   ASP   156      20.327  -9.075  -2.880  1.00154.49      A    N  
ATOM    960  CA  ASP   156      21.569  -9.607  -3.441  1.00145.75      A    C  
ATOM    961  CB  ASP   156      22.488 -10.157  -2.331  1.00135.92      A    C  
ATOM    962  CG  ASP   156      21.872 -11.329  -1.568  1.00134.46      A    C  
ATOM    963  OD1 ASP   156      21.793 -12.447  -2.127  1.00132.68      A    O  
ATOM    964  OD2 ASP   156      21.490 -11.137  -0.394  1.00135.89      A    O  
ATOM    965  C   ASP   156      21.316 -10.670  -4.512  1.00145.37      A    C  
ATOM    966  O   ASP   156      20.268 -11.319  -4.518  1.00150.14      A    O  
ATOM    967  N   ASP   157      22.283 -10.837  -5.413  1.00140.52      A    N  
ATOM    968  CA  ASP   157      22.213 -11.861  -6.458  1.00139.58      A    C  
ATOM    969  CB  ASP   157      22.328 -11.238  -7.860  1.00145.97      A    C  
ATOM    970  CG  ASP   157      23.279 -10.046  -7.904  1.00145.70      A    C  
ATOM    971  OD1 ASP   157      22.852  -8.926  -7.545  1.00151.65      A    O  
ATOM    972  OD2 ASP   157      24.446 -10.224  -8.314  1.00140.51      A    O  
ATOM    973  C   ASP   157      23.284 -12.932  -6.249  1.00128.46      A    C  
ATOM    974  O   ASP   157      24.418 -12.619  -5.887  1.00122.38      A    O  
ATOM    975  N   SER   158      22.914 -14.192  -6.468  1.00126.34      A    N  
ATOM    976  CA  SER   158      23.850 -15.305  -6.310  1.00116.90      A    C  
ATOM    977  CB  SER   158      23.222 -16.443  -5.500  1.00115.95      A    C  
ATOM    978  OG  SER   158      22.159 -17.046  -6.211  1.00124.65      A    O  
ATOM    979  C   SER   158      24.386 -15.823  -7.647  1.00115.72      A    C  
ATOM    980  O   SER   158      23.766 -15.637  -8.693  1.00122.87      A    O  
ATOM    981  N   LEU   159      25.543 -16.475  -7.587  1.00107.30      A    N  
ATOM    982  CA  LEU   159      26.252 -16.962  -8.762  1.00105.78      A    C  
ATOM    983  CB  LEU   159      27.643 -16.324  -8.812  1.00100.96      A    C  
ATOM    984  CG  LEU   159      28.366 -16.132 -10.145  1.00104.00      A    C  
ATOM    985  CD2 LEU   159      27.532 -15.316 -11.129  1.00112.58      A    C  
ATOM    987  C   LEU   159      26.341 -18.490  -8.703  1.00102.25      A    C  
ATOM    988  O   LEU   159      27.136 -19.049  -7.948  1.00 95.25      A    O  
ATOM    989  N   ASN   160      25.514 -19.156  -9.504  1.00107.82      A    N  
ATOM    990  CA  ASN   160      25.321 -20.604  -9.394  1.00107.03      A    C  
ATOM    991  CB  ASN   160      23.945 -21.006  -9.941  1.00115.89      A    C  
ATOM    992  CG  ASN   160      22.789 -20.368  -9.174  1.00119.98      A    C  
ATOM    993  OD1 ASN   160      21.844 -19.859  -9.777  1.00128.07      A    O  
ATOM    994  ND2 ASN   160      22.859 -20.395  -7.844  1.00115.38      A    N  
ATOM    995  C   ASN   160      26.406 -21.460 -10.044  1.00103.95      A    C  
ATOM    996  O   ASN   160      26.986 -21.079 -11.064  1.00105.22      A    O  
ATOM    997  N   ASP   161      26.665 -22.614  -9.424  1.00100.72      A    N  
ATOM    998  CA  ASP   161      27.538 -23.670  -9.958  1.00 99.67      A    C  
ATOM    999  CB  ASP   161      26.903 -24.310 -11.206  1.00108.04      A    C  
ATOM   1000  CG  ASP   161      27.456 -25.693 -11.506  1.00109.23      A    C  
ATOM   1001  OD1 ASP   161      27.756 -26.442 -10.547  1.00105.93      A    O  
ATOM   1002  OD2 ASP   161      27.577 -26.033 -12.705  1.00114.11      A    O  
ATOM   1003  C   ASP   161      28.976 -23.220 -10.238  1.00 94.88      A    C  
ATOM   1004  O   ASP   161      29.499 -23.410 -11.340  1.00 97.52      A    O  
ATOM   1005  N   CYS   162      29.608 -22.634  -9.226  1.00 88.51      A    N  
ATOM   1006  CA  CYS   162      30.981 -22.149  -9.332  1.00 85.07      A    C  
ATOM   1007  CB  CYS   162      31.178 -20.924  -8.431  1.00 81.92      A    C  
ATOM   1008  SG  CYS   162      30.225 -19.464  -8.900  1.00 88.32      A    S  
ATOM   1009  C   CYS   162      31.993 -23.225  -8.942  1.00 81.26      A    C  
ATOM   1010  O   CYS   162      31.833 -23.883  -7.913  1.00 79.50      A    O  
ATOM   1011  N   ARG   163      33.041 -23.388  -9.748  1.00 80.96      A    N  
ATOM   1012  CA  ARG   163      34.135 -24.297  -9.403  1.00 78.45      A    C  
ATOM   1013  CB  ARG   163      34.936 -24.699 -10.649  1.00 82.87      A    C  
ATOM   1014  CG  ARG   163      36.139 -25.619 -10.389  1.00 83.57      A    C  
ATOM   1015  CD  ARG   163      35.735 -26.950  -9.752  1.00 86.25      A    C  
ATOM   1016  NE  ARG   163      36.895 -27.771  -9.402  1.00 86.46      A    N  
ATOM   1017  CZ  ARG   163      37.383 -28.758 -10.151  1.00 91.21      A    C  
ATOM   1018  NH1 ARG   163      36.813 -29.077 -11.312  1.00 95.37      A    N  
ATOM   1019  NH2 ARG   163      38.444 -29.439  -9.732  1.00 90.22      A    N  
ATOM   1020  C   ARG   163      35.044 -23.655  -8.359  1.00 73.09      A    C  
ATOM   1021  O   ARG   163      35.798 -22.727  -8.665  1.00 73.28      A    O  
ATOM   1022  N   ILE   164      34.963 -24.155  -7.129  1.00 68.86      A    N  
ATOM   1023  CA  ILE   164      35.743 -23.620  -6.011  1.00 63.46      A    C  
ATOM   1024  CB  ILE   164      34.998 -23.798  -4.656  1.00 61.55      A    C  
ATOM   1025  CG1 ILE   164      33.573 -23.218  -4.724  1.00 60.30      A    C  
ATOM   1026  CD1 ILE   164      33.499 -21.745  -5.097  1.00 60.78      A    C  
ATOM   1027  CG2 ILE   164      35.823 -23.220  -3.477  1.00 57.88      A    C  
ATOM   1028  C   ILE   164      37.130 -24.257  -5.942  1.00 63.17      A    C  
ATOM   1029  O   ILE   164      37.258 -25.473  -5.803  1.00 63.90      A    O  
ATOM   1030  N   ILE   165      38.160 -23.419  -6.033  1.00 63.23      A    N  
ATOM   1031  CA  ILE   165      39.553 -23.873  -6.071  1.00 64.54      A    C  
ATOM   1032  CB  ILE   165      40.486 -22.816  -6.735  1.00 65.87      A    C  
ATOM   1033  CG1 ILE   165      40.033 -22.474  -8.161  1.00 68.67      A    C  
ATOM   1034  CD1 ILE   165      39.820 -23.676  -9.066  1.00 70.55      A    C  
ATOM   1035  CG2 ILE   165      41.943 -23.279  -6.718  1.00 68.94      A    C  
ATOM   1036  C   ILE   165      40.090 -24.196  -4.681  1.00 63.36      A    C  
ATOM   1037  O   ILE   165      40.739 -25.220  -4.487  1.00 65.13      A    O  
ATOM   1038  N   PHE   166      39.808 -23.316  -3.724  1.00 60.96      A    N  
ATOM   1039  CA  PHE   166      40.423 -23.363  -2.391  1.00 61.51      A    C  
ATOM   1040  CB  PHE   166      40.778 -21.947  -1.921  1.00 59.92      A    C  
ATOM   1041  CG  PHE   166      41.515 -21.179  -2.976  1.00 63.59      A    C  
ATOM   1042  CD1 PHE   166      40.831 -20.338  -3.851  1.00 63.67      A    C  
ATOM   1043  CE1 PHE   166      41.500 -19.672  -4.874  1.00 65.74      A    C  
ATOM   1044  CZ  PHE   166      42.863 -19.866  -5.048  1.00 69.84      A    C  
ATOM   1045  CE2 PHE   166      43.555 -20.726  -4.199  1.00 71.18      A    C  
ATOM   1046  CD2 PHE   166      42.875 -21.391  -3.179  1.00 67.07      A    C  
ATOM   1047  C   PHE   166      39.555 -24.164  -1.448  1.00 60.34      A    C  
ATOM   1048  O   PHE   166      38.857 -23.654  -0.577  1.00 59.81      A    O  
ATOM   1049  N   VAL   167      39.639 -25.461  -1.683  1.00 61.90      A    N  
ATOM   1050  CA  VAL   167      38.760 -26.465  -1.138  1.00 62.51      A    C  
ATOM   1051  CB  VAL   167      38.817 -27.678  -2.085  1.00 66.35      A    C  
ATOM   1052  CG1 VAL   167      38.694 -29.004  -1.355  1.00 71.14      A    C  
ATOM   1053  CG2 VAL   167      37.789 -27.517  -3.209  1.00 67.21      A    C  
ATOM   1054  C   VAL   167      39.147 -26.822   0.296  1.00 62.61      A    C  
ATOM   1055  O   VAL   167      38.380 -27.472   1.015  1.00 61.76      A    O  
ATOM   1056  N   ASP   168      40.332 -26.369   0.706  1.00 63.36      A    N  
ATOM   1057  CA  ASP   168      40.879 -26.668   2.024  1.00 65.08      A    C  
ATOM   1058  CB  ASP   168      42.323 -27.177   1.907  1.00 68.67      A    C  
ATOM   1059  CG  ASP   168      42.404 -28.597   1.360  1.00 73.05      A    C  
ATOM   1060  OD1 ASP   168      41.677 -29.482   1.868  1.00 73.62      A    O  
ATOM   1061  OD2 ASP   168      43.199 -28.833   0.422  1.00 74.94      A    O  
ATOM   1062  C   ASP   168      40.810 -25.459   2.946  1.00 63.54      A    C  
ATOM   1063  O   ASP   168      41.340 -25.489   4.062  1.00 66.02      A    O  
ATOM   1064  N   GLU   169      40.141 -24.405   2.482  1.00 60.46      A    N  
ATOM   1065  CA  GLU   169      40.110 -23.134   3.207  1.00 59.46      A    C  
ATOM   1066  CB  GLU   169      40.988 -22.107   2.487  1.00 60.15      A    C  
ATOM   1067  CG  GLU   169      42.468 -22.435   2.516  1.00 60.33      A    C  
ATOM   1068  CD  GLU   169      43.285 -21.528   1.627  1.00 63.26      A    C  
ATOM   1069  OE1 GLU   169      43.919 -20.597   2.166  1.00 63.21      A    O  
ATOM   1070  OE2 GLU   169      43.296 -21.742   0.389  1.00 63.55      A    O  
ATOM   1071  C   GLU   169      38.691 -22.593   3.412  1.00 57.50      A    C  
ATOM   1072  O   GLU   169      38.475 -21.378   3.494  1.00 56.14      A    O  
ATOM   1073  N   VAL   170      37.735 -23.511   3.511  1.00 57.46      A    N  
ATOM   1074  CA  VAL   170      36.325 -23.175   3.636  1.00 56.44      A    C  
ATOM   1075  CB  VAL   170      35.449 -24.277   2.987  1.00 56.48      A    C  
ATOM   1076  CG1 VAL   170      33.980 -24.001   3.212  1.00 55.51      A    C  
ATOM   1077  CG2 VAL   170      35.751 -24.397   1.489  1.00 54.79      A    C  
ATOM   1078  C   VAL   170      35.952 -22.981   5.112  1.00 59.01      A    C  
ATOM   1079  O   VAL   170      36.236 -23.839   5.957  1.00 61.69      A    O  
ATOM   1080  N   PHE   171      35.312 -21.855   5.412  1.00 58.99      A    N  
ATOM   1081  CA  PHE   171      34.969 -21.499   6.783  1.00 61.65      A    C  
ATOM   1082  CB  PHE   171      35.233 -20.014   7.044  1.00 60.78      A    C  
ATOM   1083  CG  PHE   171      36.670 -19.678   7.281  1.00 60.82      A    C  
ATOM   1084  CD1 PHE   171      37.210 -19.739   8.562  1.00 60.71      A    C  
ATOM   1085  CE1 PHE   171      38.544 -19.413   8.789  1.00 60.33      A    C  
ATOM   1086  CZ  PHE   171      39.352 -19.009   7.736  1.00 61.60      A    C  
ATOM   1087  CE2 PHE   171      38.825 -18.946   6.441  1.00 61.24      A    C  
ATOM   1088  CD2 PHE   171      37.487 -19.275   6.224  1.00 60.28      A    C  
ATOM   1089  C   PHE   171      33.524 -21.794   7.147  1.00 64.12      A    C  
ATOM   1090  O   PHE   171      32.615 -21.693   6.314  1.00 64.50      A    O  
ATOM   1091  N   LYS   172      33.339 -22.152   8.413  1.00 77.04      A    N  
ATOM   1092  CA  LYS   172      32.037 -22.227   9.050  1.00 79.53      A    C  
ATOM   1093  CB  LYS   172      32.164 -23.050  10.337  1.00 88.91      A    C  
ATOM   1094  CG  LYS   172      30.940 -23.105  11.231  1.00 93.59      A    C  
ATOM   1095  CD  LYS   172      31.219 -24.011  12.426  1.00105.42      A    C  
ATOM   1096  CE  LYS   172      30.081 -24.008  13.435  1.00111.71      A    C  
ATOM   1097  NZ  LYS   172      30.086 -22.782  14.282  1.00110.49      A    N  
ATOM   1098  C   LYS   172      31.600 -20.804   9.366  1.00 77.33      A    C  
ATOM   1099  O   LYS   172      32.382 -20.015   9.907  1.00 79.81      A    O  
ATOM   1100  N   ILE   173      30.364 -20.468   9.018  1.00 76.02      A    N  
ATOM   1101  CA  ILE   173      29.820 -19.163   9.362  1.00 76.65      A    C  
ATOM   1102  CB  ILE   173      28.692 -18.719   8.397  1.00 76.78      A    C  
ATOM   1103  CG1 ILE   173      29.263 -18.449   7.002  1.00 70.61      A    C  
ATOM   1104  CD1 ILE   173      28.220 -18.403   5.902  1.00 71.51      A    C  
ATOM   1105  CG2 ILE   173      27.983 -17.471   8.924  1.00 81.49      A    C  
ATOM   1106  C   ILE   173      29.330 -19.219  10.805  1.00 83.32      A    C  
ATOM   1107  O   ILE   173      28.477 -20.038  11.153  1.00 87.13      A    O  
ATOM   1108  N   GLU   174      29.896 -18.353  11.639  1.00 86.51      A    N  
ATOM   1109  CA  GLU   174      29.536 -18.283  13.050  1.00 93.69      A    C  
ATOM   1110  CB  GLU   174      30.549 -17.437  13.835  1.00 97.60      A    C  
ATOM   1111  CG  GLU   174      32.024 -17.729  13.538  1.00 98.58      A    C  
ATOM   1112  CD  GLU   174      32.480 -19.103  14.005  1.00103.15      A    C  
ATOM   1113  OE1 GLU   174      32.267 -19.434  15.190  1.00110.24      A    O  
ATOM   1114  OE2 GLU   174      33.069 -19.847  13.186  1.00102.50      A    O  
ATOM   1115  C   GLU   174      28.128 -17.711  13.215  1.00 97.65      A    C  
ATOM   1116  O   GLU   174      27.849 -16.589  12.779  1.00 98.79      A    O  
ATOM   1117  N   ARG   175      27.250 -18.506  13.826  1.00102.48      A    N  
ATOM   1118  CA  ARG   175      25.891 -18.080  14.174  1.00109.50      A    C  
ATOM   1119  CB  ARG   175      24.881 -19.185  13.842  1.00114.39      A    C  
ATOM   1120  CG  ARG   175      24.124 -18.977  12.535  1.00116.97      A    C  
ATOM   1121  CD  ARG   175      24.920 -19.414  11.313  1.00109.78      A    C  
ATOM   1122  NE  ARG   175      24.355 -18.861  10.080  1.00112.40      A    N  
ATOM   1123  CZ  ARG   175      24.629 -19.298   8.851  1.00109.33      A    C  
ATOM   1124  NH1 ARG   175      25.462 -20.318   8.661  1.00103.11      A    N  
ATOM   1125  NH2 ARG   175      24.058 -18.714   7.803  1.00112.61      A    N  
ATOM   1126  C   ARG   175      25.781 -17.680  15.653  1.00114.90      A    C  
ATOM   1127  O   ARG   175      26.443 -18.279  16.504  1.00115.25      A    O  
ATOM   1128  N   PRO   176      24.947 -16.661  15.961  1.00121.13      A    N  
ATOM   1129  CA  PRO   176      24.769 -16.177  17.338  1.00127.15      A    C  
ATOM   1130  CB  PRO   176      23.739 -15.054  17.186  1.00135.40      A    C  
ATOM   1131  CG  PRO   176      23.825 -14.640  15.761  1.00132.78      A    C  
ATOM   1132  CD  PRO   176      24.125 -15.891  15.009  1.00124.80      A    C  
ATOM   1133  C   PRO   176      24.226 -17.248  18.281  1.00131.43      A    C  
ATOM   1134  O   PRO   176      24.738 -17.408  19.389  1.00133.23      A    O  
END
