
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   90 (  689),  selected   90 , name 2hqx_A
# Molecule2: number of CA atoms   76 (  635),  selected   76 , name T0429_100_176.pdb
# PARAMETERS: 2hqx_A.T0429_100_176.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     8_A      -       -           -
LGA    Q     9_A      -       -           -
LGA    F    10_A      -       -           -
LGA    Q    11_A      -       -           -
LGA    K    12_A      -       -           -
LGA    L    13_A      -       -           -
LGA    M    14_A      -       -           -
LGA    E    15_A      -       -           -
LGA    N    16_A      -       -           -
LGA    M    17_A      -       -           -
LGA    R    18_A      -       -           -
LGA    N    19_A      -       -           -
LGA    D    20_A      R     100          1.059
LGA    I    21_A      A     101          2.567
LGA    A    22_A      -       -           -
LGA    S    23_A      -       -           -
LGA    H    24_A      -       -           -
LGA    P    25_A      R     102          4.133
LGA    P    26_A      T     103          3.965
LGA    V    27_A      I     104          3.624
LGA    E    28_A      -       -           -
LGA    G    29_A      -       -           -
LGA    S    30_A      I     105          3.717
LGA    Y    31_A      K     106          3.907
LGA    -       -      W     107           -
LGA    -       -      Q     108           -
LGA    A    32_A      D     109          2.041
LGA    P    33_A      L     110          1.392
LGA    R    34_A      E     111          0.758
LGA    R    35_A      V     112          0.925
LGA    G    36_A      G     113          1.143
LGA    E    37_A      Q     114          1.293
LGA    F    38_A      V     115          0.981
LGA    C    39_A      V     116          0.880
LGA    I    40_A      M     117          0.981
LGA    A    41_A      L     118          1.304
LGA    K    42_A      N     119          0.831
LGA    F    43_A      Y     120          1.213
LGA    V    44_A      N     121          2.671
LGA    -       -      P     122           -
LGA    -       -      D     123           -
LGA    -       -      N     124           -
LGA    -       -      P     125           -
LGA    -       -      K     126           -
LGA    -       -      E     127           -
LGA    D    45_A      R     128          4.837
LGA    G    46_A      G     129          3.264
LGA    E    47_A      F     130          1.889
LGA    W    48_A      W     131          1.063
LGA    Y    49_A      Y     132          1.000
LGA    R    50_A      D     133          0.823
LGA    A    51_A      A     134          0.703
LGA    R    52_A      E     135          0.349
LGA    V    53_A      I     136          0.634
LGA    E    54_A      S     137          0.696
LGA    K    55_A      R     138          0.788
LGA    V    56_A      K     139          0.492
LGA    E    57_A      R     140          1.214
LGA    S    58_A      E     141          2.239
LGA    P    59_A      T     142           -
LGA    -       -      R     143           -
LGA    -       -      T     144           -
LGA    -       -      A     145           -
LGA    A    60_A      R     146          2.499
LGA    K    61_A      E     147          1.162
LGA    I    62_A      L     148          0.786
LGA    H    63_A      Y     149          0.506
LGA    V    64_A      A     150          0.384
LGA    F    65_A      N     151          0.546
LGA    Y    66_A      V     152          0.934
LGA    I    67_A      V     153          2.613
LGA    D    68_A      L     154          3.698
LGA    Y    69_A      D     156           #
LGA    -       -      D     157           -
LGA    G    70_A      S     158          1.666
LGA    N    71_A      L     159          1.445
LGA    R    72_A      N     160          3.700
LGA    -       -      D     161           -
LGA    E    73_A      C     162          1.716
LGA    V    74_A      R     163          1.389
LGA    L    75_A      I     164          1.803
LGA    -       -      I     165           -
LGA    P    76_A      F     166          4.314
LGA    S    77_A      V     167          2.430
LGA    T    78_A      D     168          0.889
LGA    R    79_A      E     169          3.113
LGA    L    80_A      V     170          1.557
LGA    G    81_A      F     171          1.643
LGA    T    82_A      K     172          0.898
LGA    L    83_A      I     173          1.530
LGA    S    84_A      E     174          1.441
LGA    P    85_A      R     175          1.234
LGA    A    86_A      P     176          4.427
LGA    F    87_A      -       -           -
LGA    S    88_A      -       -           -
LGA    T    89_A      -       -           -
LGA    R    90_A      -       -           -
LGA    V    91_A      -       -           -
LGA    L    92_A      -       -           -
LGA    P    93_A      -       -           -
LGA    A    94_A      -       -           -
LGA    Q    95_A      -       -           -
LGA    A    96_A      -       -           -
LGA    T    97_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   90   76    5.0     60    2.16     8.33     67.038     2.656

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.536921 * X  +  -0.771574 * Y  +  -0.341158 * Z  +  30.849176
  Y_new =  -0.769325 * X  +   0.281857 * Y  +   0.573320 * Z  + -19.179054
  Z_new =  -0.346201 * X  +   0.570289 * Y  +  -0.744927 * Z  +   1.135643 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.488205   -0.653388  [ DEG:   142.5636    -37.4364 ]
  Theta =   0.353519    2.788074  [ DEG:    20.2551    159.7449 ]
  Phi   =  -2.180119    0.961473  [ DEG:  -124.9116     55.0884 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hqx_A                                        
REMARK     2: T0429_100_176.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hqx_A.T0429_100_176.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   90   76   5.0   60   2.16    8.33  67.038
REMARK  ---------------------------------------------------------- 
MOLECULE 2hqx_A
HEADER    TRANSCRIPTION                           19-JUL-06   2HQX              
TITLE     CRYSTAL STRUCTURE OF HUMAN P100 TUDOR DOMAIN CONSERVED                
TITLE    2 REGION                                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: P100 CO-ACTIVATOR TUDOR DOMAIN;                            
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: CONSERVED REGION;                                          
COMPND   5 SYNONYM: P100 CO-ACTIVATOR, 100 KDA COACTIVATOR, EBNA2               
COMPND   6 COACTIVATOR P100;                                                    
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: SND1;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    HUMAN P100 TUDOR DOMAIN, PROTEOLYTIC FRAGMENT, PSI,                   
KEYWDS   2 STRUCTURAL GENOMICS, SOUTHEAST COLLABORATORY FOR STRUCTURAL          
KEYWDS   3 GENOMICS, PROTEIN STRUCTURE INITIATIVE, SECSG                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.ZHAO,Z.J.LIU,H.XU,J.YANG,O.SILVENNOINEN,B.C.WANG,                   
AUTHOR   2 SOUTHEAST COLLABORATORY FOR STRUCTURAL GENOMICS (SECSG)              
REVDAT   1   10-OCT-06 2HQX    0                                                
JRNL        AUTH   M.ZHAO,Z.J.LIU,H.XU,J.YANG,O.SILVENNOINEN,B.C.WANG           
JRNL        TITL   CRYSTAL STRUCTURE OF HUMAN P100 TUDOR DOMAIN                 
JRNL        TITL 2 CONSERVED REGION                                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.42 ANGSTROMS.                                          
DBREF  2HQX A  -32   213  UNP    Q7KZF4   SND1_HUMAN     665    910             
DBREF  2HQX B  -32   213  UNP    Q7KZF4   SND1_HUMAN     665    910             
SEQRES   1 A  246  PRO VAL GLU GLU VAL MET PRO VAL LEU GLU GLU LYS GLU          
SEQRES   2 A  246  ARG SER ALA SER TYR LYS PRO VAL PHE VAL THR GLU ILE          
SEQRES   3 A  246  THR ASP ASP LEU HIS PHE TYR VAL GLN ASP VAL GLU THR          
SEQRES   4 A  246  GLY THR GLN PHE GLN LYS LEU MET GLU ASN MET ARG ASN          
SEQRES   5 A  246  ASP ILE ALA SER HIS PRO PRO VAL GLU GLY SER TYR ALA          
SEQRES   6 A  246  PRO ARG ARG GLY GLU PHE CYS ILE ALA LYS PHE VAL ASP          
SEQRES   7 A  246  GLY GLU TRP TYR ARG ALA ARG VAL GLU LYS VAL GLU SER          
SEQRES   8 A  246  PRO ALA LYS ILE HIS VAL PHE TYR ILE ASP TYR GLY ASN          
SEQRES   9 A  246  ARG GLU VAL LEU PRO SER THR ARG LEU GLY THR LEU SER          
SEQRES  10 A  246  PRO ALA PHE SER THR ARG VAL LEU PRO ALA GLN ALA THR          
SEQRES  11 A  246  GLU TYR ALA PHE ALA PHE ILE GLN VAL PRO GLN ASP ASP          
SEQRES  12 A  246  ASP ALA ARG THR ASP ALA VAL ASP SER VAL VAL ARG ASP          
SEQRES  13 A  246  ILE GLN ASN THR GLN CYS LEU LEU ASN VAL GLU HIS LEU          
SEQRES  14 A  246  SER ALA GLY CYS PRO HIS VAL THR LEU GLN PHE ALA ASP          
SEQRES  15 A  246  SER LYS GLY ASP VAL GLY LEU GLY LEU VAL LYS GLU GLY          
SEQRES  16 A  246  LEU VAL MET VAL GLU VAL ARG LYS GLU LYS GLN PHE GLN          
SEQRES  17 A  246  LYS VAL ILE THR GLU TYR LEU ASN ALA GLN GLU SER ALA          
SEQRES  18 A  246  LYS SER ALA ARG LEU ASN LEU TRP ARG TYR GLY ASP PHE          
SEQRES  19 A  246  ARG ALA ASP ASP ALA ASP GLU PHE GLY TYR SER ARG              
SEQRES   1 B  246  PRO VAL GLU GLU VAL MET PRO VAL LEU GLU GLU LYS GLU          
SEQRES   2 B  246  ARG SER ALA SER TYR LYS PRO VAL PHE VAL THR GLU ILE          
SEQRES   3 B  246  THR ASP ASP LEU HIS PHE TYR VAL GLN ASP VAL GLU THR          
SEQRES   4 B  246  GLY THR GLN PHE GLN LYS LEU MET GLU ASN MET ARG ASN          
SEQRES   5 B  246  ASP ILE ALA SER HIS PRO PRO VAL GLU GLY SER TYR ALA          
SEQRES   6 B  246  PRO ARG ARG GLY GLU PHE CYS ILE ALA LYS PHE VAL ASP          
SEQRES   7 B  246  GLY GLU TRP TYR ARG ALA ARG VAL GLU LYS VAL GLU SER          
SEQRES   8 B  246  PRO ALA LYS ILE HIS VAL PHE TYR ILE ASP TYR GLY ASN          
SEQRES   9 B  246  ARG GLU VAL LEU PRO SER THR ARG LEU GLY THR LEU SER          
SEQRES  10 B  246  PRO ALA PHE SER THR ARG VAL LEU PRO ALA GLN ALA THR          
SEQRES  11 B  246  GLU TYR ALA PHE ALA PHE ILE GLN VAL PRO GLN ASP ASP          
SEQRES  12 B  246  ASP ALA ARG THR ASP ALA VAL ASP SER VAL VAL ARG ASP          
SEQRES  13 B  246  ILE GLN ASN THR GLN CYS LEU LEU ASN VAL GLU HIS LEU          
SEQRES  14 B  246  SER ALA GLY CYS PRO HIS VAL THR LEU GLN PHE ALA ASP          
SEQRES  15 B  246  SER LYS GLY ASP VAL GLY LEU GLY LEU VAL LYS GLU GLY          
SEQRES  16 B  246  LEU VAL MET VAL GLU VAL ARG LYS GLU LYS GLN PHE GLN          
SEQRES  17 B  246  LYS VAL ILE THR GLU TYR LEU ASN ALA GLN GLU SER ALA          
SEQRES  18 B  246  LYS SER ALA ARG LEU ASN LEU TRP ARG TYR GLY ASP PHE          
SEQRES  19 B  246  ARG ALA ASP ASP ALA ASP GLU PHE GLY TYR SER ARG              
FORMUL   3  HOH   *238(H2 O)                                                    
CRYST1   30.777   37.684   40.202  90.03 105.32  99.72 P 1           2          
ATOM      1  N   THR A   8      25.205  -0.352   3.283  1.00 16.75           N  
ATOM      2  CA  THR A   8      24.139  -1.286   2.870  1.00 16.10           C  
ATOM      3  C   THR A   8      24.160  -2.474   3.883  1.00 14.88           C  
ATOM      4  O   THR A   8      25.202  -2.755   4.488  1.00 14.71           O  
ATOM      5  CB  THR A   8      24.430  -1.669   1.403  1.00 17.47           C  
ATOM      6  OG1 THR A   8      23.404  -1.207   0.509  1.00 19.52           O  
ATOM      7  CG2 THR A   8      24.744  -3.112   1.232  1.00 15.31           C  
ATOM      8  N   GLN A   9      23.028  -3.142   4.112  1.00 13.80           N  
ATOM      9  CA  GLN A   9      23.001  -4.301   5.026  1.00 13.61           C  
ATOM     10  C   GLN A   9      24.012  -5.367   4.621  1.00 12.48           C  
ATOM     11  O   GLN A   9      24.717  -5.929   5.458  1.00 11.58           O  
ATOM     12  CB  GLN A   9      21.606  -4.918   5.084  1.00 13.92           C  
ATOM     13  CG  GLN A   9      20.638  -4.084   5.877  1.00 15.09           C  
ATOM     14  CD  GLN A   9      19.264  -4.693   5.910  1.00 19.09           C  
ATOM     15  OE1 GLN A   9      18.972  -5.538   6.757  1.00 20.50           O  
ATOM     16  NE2 GLN A   9      18.407  -4.265   4.997  1.00 19.89           N  
ATOM     17  N   PHE A  10      24.076  -5.629   3.323  1.00 11.78           N  
ATOM     18  CA  PHE A  10      25.043  -6.563   2.771  1.00 12.54           C  
ATOM     19  C   PHE A  10      26.472  -6.104   3.081  1.00 12.65           C  
ATOM     20  O   PHE A  10      27.294  -6.888   3.558  1.00 11.53           O  
ATOM     21  CB  PHE A  10      24.817  -6.632   1.272  1.00 13.20           C  
ATOM     22  CG  PHE A  10      25.582  -7.706   0.571  1.00 15.30           C  
ATOM     23  CD1 PHE A  10      26.230  -8.719   1.271  1.00 18.59           C  
ATOM     24  CD2 PHE A  10      25.548  -7.753  -0.819  1.00 16.10           C  
ATOM     25  CE1 PHE A  10      26.905  -9.692   0.601  1.00 22.43           C  
ATOM     26  CE2 PHE A  10      26.204  -8.731  -1.498  1.00 20.68           C  
ATOM     27  CZ  PHE A  10      26.892  -9.699  -0.792  1.00 21.20           C  
ATOM     28  N   GLN A  11      26.778  -4.838   2.819  1.00 12.37           N  
ATOM     29  CA  GLN A  11      28.126  -4.307   3.050  1.00 12.83           C  
ATOM     30  C   GLN A  11      28.537  -4.432   4.503  1.00 12.37           C  
ATOM     31  O   GLN A  11      29.663  -4.814   4.797  1.00 12.13           O  
ATOM     32  CB  GLN A  11      28.234  -2.851   2.579  1.00 12.82           C  
ATOM     33  CG  GLN A  11      28.315  -2.709   1.053  1.00 14.23           C  
ATOM     34  CD  GLN A  11      28.256  -1.251   0.583  1.00 15.49           C  
ATOM     35  OE1 GLN A  11      27.591  -0.411   1.199  1.00 17.16           O  
ATOM     36  NE2 GLN A  11      28.974  -0.945  -0.493  1.00 20.39           N  
ATOM     37  N   LYS A  12      27.617  -4.116   5.408  1.00 12.00           N  
ATOM     38  CA  LYS A  12      27.871  -4.180   6.837  1.00 12.13           C  
ATOM     39  C   LYS A  12      28.089  -5.621   7.280  1.00 11.57           C  
ATOM     40  O   LYS A  12      28.981  -5.892   8.073  1.00 11.16           O  
ATOM     41  CB  LYS A  12      26.732  -3.552   7.647  1.00 11.93           C  
ATOM     42  CG  LYS A  12      26.573  -2.038   7.473  1.00 14.52           C  
ATOM     43  CD  LYS A  12      25.393  -1.499   8.286  1.00 14.51           C  
ATOM     44  CE  LYS A  12      25.375   0.034   8.293  1.00 19.55           C  
ATOM     45  NZ  LYS A  12      25.224   0.599   6.925  1.00 24.55           N  
ATOM     46  N   LEU A  13      27.266  -6.549   6.781  1.00 10.51           N  
ATOM     47  CA  LEU A  13      27.445  -7.961   7.153  1.00 10.73           C  
ATOM     48  C   LEU A  13      28.793  -8.485   6.660  1.00 10.21           C  
ATOM     49  O   LEU A  13      29.464  -9.209   7.385  1.00 10.01           O  
ATOM     50  CB  LEU A  13      26.297  -8.854   6.639  1.00 11.42           C  
ATOM     51  CG  LEU A  13      26.342 -10.346   7.044  1.00 11.17           C  
ATOM     52  CD1 LEU A  13      25.869 -10.555   8.480  1.00 16.37           C  
ATOM     53  CD2 LEU A  13      25.513 -11.217   6.104  1.00 11.27           C  
ATOM     54  N   MET A  14      29.202  -8.111   5.450  1.00 10.36           N  
ATOM     55  CA  MET A  14      30.467  -8.617   4.905  1.00 10.20           C  
ATOM     56  C   MET A  14      31.645  -8.132   5.701  1.00 10.43           C  
ATOM     57  O   MET A  14      32.585  -8.877   5.947  1.00  9.31           O  
ATOM     58  CB  MET A  14      30.641  -8.278   3.420  1.00 11.05           C  
ATOM     59  CG  MET A  14      29.704  -9.050   2.549  1.00 11.11           C  
ATOM     60  SD  MET A  14      30.000 -10.829   2.589  1.00  9.40           S  
ATOM     61  CE  MET A  14      30.577 -10.988   0.921  1.00 17.93           C  
ATOM     62  N   GLU A  15      31.599  -6.865   6.104  1.00 10.81           N  
ATOM     63  CA  GLU A  15      32.650  -6.313   6.942  1.00 12.10           C  
ATOM     64  C   GLU A  15      32.726  -7.056   8.265  1.00 10.89           C  
ATOM     65  O   GLU A  15      33.800  -7.483   8.680  1.00 11.54           O  
ATOM     66  CB  GLU A  15      32.416  -4.823   7.188  1.00 12.70           C  
ATOM     67  CG  GLU A  15      33.529  -4.135   7.940  1.00 17.88           C  
ATOM     68  CD  GLU A  15      33.460  -2.625   7.826  1.00 23.93           C  
ATOM     69  OE1 GLU A  15      32.392  -2.046   8.137  1.00 27.87           O  
ATOM     70  OE2 GLU A  15      34.479  -2.010   7.429  1.00 26.43           O  
ATOM     71  N   ASN A  16      31.581  -7.224   8.917  1.00 10.07           N  
ATOM     72  CA  ASN A  16      31.571  -7.877  10.221  1.00 10.59           C  
ATOM     73  C   ASN A  16      32.009  -9.341  10.075  1.00  9.32           C  
ATOM     74  O   ASN A  16      32.827  -9.817  10.834  1.00  9.80           O  
ATOM     75  CB  ASN A  16      30.199  -7.765  10.887  1.00 11.24           C  
ATOM     76  CG  ASN A  16      29.892  -6.352  11.359  1.00 15.04           C  
ATOM     77  OD1 ASN A  16      30.764  -5.672  11.906  1.00 20.56           O  
ATOM     78  ND2 ASN A  16      28.641  -5.916  11.183  1.00 17.70           N  
ATOM     79  N   MET A  17      31.487 -10.031   9.053  1.00  7.97           N  
ATOM     80  CA  MET A  17      31.836 -11.430   8.820  1.00  7.30           C  
ATOM     81  C   MET A  17      33.328 -11.598   8.555  1.00  8.02           C  
ATOM     82  O   MET A  17      33.977 -12.456   9.136  1.00  8.57           O  
ATOM     83  CB  MET A  17      31.010 -12.010   7.655  1.00  7.38           C  
ATOM     84  CG  MET A  17      31.282 -13.478   7.410  1.00  6.92           C  
ATOM     85  SD  MET A  17      30.357 -14.157   6.018  1.00  6.16           S  
ATOM     86  CE  MET A  17      31.438 -13.652   4.675  1.00 10.56           C  
ATOM     87  N   ARG A  18      33.877 -10.780   7.659  1.00  7.24           N  
ATOM     88  CA  ARG A  18      35.300 -10.856   7.317  1.00  7.54           C  
ATOM     89  C   ARG A  18      36.211 -10.505   8.488  1.00  7.83           C  
ATOM     90  O   ARG A  18      37.270 -11.127   8.653  1.00  7.75           O  
ATOM     91  CB  ARG A  18      35.632 -10.004   6.076  1.00  6.41           C  
ATOM     92  CG  ARG A  18      34.949 -10.582   4.827  1.00  5.70           C  
ATOM     93  CD  ARG A  18      35.069  -9.729   3.600  1.00  7.84           C  
ATOM     94  NE  ARG A  18      34.457 -10.427   2.470  1.00  8.77           N  
ATOM     95  CZ  ARG A  18      33.823  -9.821   1.481  1.00 11.57           C  
ATOM     96  NH1 ARG A  18      33.295 -10.552   0.511  1.00 11.75           N  
ATOM     97  NH2 ARG A  18      33.685  -8.497   1.486  1.00 13.32           N  
ATOM     98  N   ASN A  19      35.785  -9.563   9.326  1.00  7.94           N  
ATOM     99  CA  ASN A  19      36.570  -9.262  10.532  1.00  9.63           C  
ATOM    100  C   ASN A  19      36.569 -10.443  11.488  1.00  9.80           C  
ATOM    101  O   ASN A  19      37.587 -10.766  12.105  1.00 10.63           O  
ATOM    102  CB  ASN A  19      36.074  -7.991  11.207  1.00  9.99           C  
ATOM    103  CG  ASN A  19      36.385  -6.754  10.405  1.00 10.90           C  
ATOM    104  OD1 ASN A  19      37.241  -6.759   9.516  1.00 13.73           O  
ATOM    105  ND2 ASN A  19      35.672  -5.672  10.706  1.00 14.33           N  
ATOM    106  N   ASP A  20      35.422 -11.121  11.586  1.00 10.18           N  
ATOM    107  CA  ASP A  20      35.327 -12.311  12.430  1.00 10.64           C  
ATOM    108  C   ASP A  20      36.147 -13.474  11.861  1.00  9.95           C  
ATOM    109  O   ASP A  20      36.833 -14.183  12.597  1.00 10.82           O  
ATOM    110  CB  ASP A  20      33.883 -12.756  12.596  1.00 11.83           C  
ATOM    111  CG  ASP A  20      33.756 -13.840  13.643  1.00 14.49           C  
ATOM    112  OD1 ASP A  20      33.557 -15.016  13.272  1.00 16.19           O  
ATOM    113  OD2 ASP A  20      33.924 -13.525  14.844  1.00 17.87           O  
ATOM    114  N   ILE A  21      36.070 -13.687  10.548  1.00  8.95           N  
ATOM    115  CA  ILE A  21      36.854 -14.761   9.921  1.00 10.19           C  
ATOM    116  C   ILE A  21      38.342 -14.509  10.170  1.00 11.00           C  
ATOM    117  O   ILE A  21      39.074 -15.425  10.497  1.00 11.76           O  
ATOM    118  CB  ILE A  21      36.569 -14.898   8.405  1.00 10.21           C  
ATOM    119  CG1 ILE A  21      35.118 -15.355   8.189  1.00  9.69           C  
ATOM    120  CG2 ILE A  21      37.532 -15.879   7.724  1.00 11.20           C  
ATOM    121  CD1 ILE A  21      34.566 -15.071   6.819  1.00  9.96           C  
ATOM    122  N   ALA A  22      38.785 -13.263  10.042  1.00 12.28           N  
ATOM    123  CA  ALA A  22      40.188 -12.929  10.263  1.00 14.08           C  
ATOM    124  C   ALA A  22      40.610 -13.212  11.712  1.00 15.06           C  
ATOM    125  O   ALA A  22      41.750 -13.628  11.947  1.00 16.83           O  
ATOM    126  CB  ALA A  22      40.433 -11.478   9.884  1.00 13.99           C  
ATOM    127  N   SER A  23      39.694 -13.040  12.668  1.00 15.85           N  
ATOM    128  CA  SER A  23      39.957 -13.351  14.088  1.00 17.23           C  
ATOM    129  C   SER A  23      40.043 -14.854  14.367  1.00 17.27           C  
ATOM    130  O   SER A  23      40.642 -15.265  15.359  1.00 17.49           O  
ATOM    131  CB  SER A  23      38.864 -12.789  15.002  1.00 17.43           C  
ATOM    132  OG  SER A  23      38.469 -11.473  14.651  1.00 22.52           O  
ATOM    133  N   HIS A  24      39.412 -15.659  13.511  1.00 16.17           N  
ATOM    134  CA  HIS A  24      39.313 -17.109  13.700  1.00 16.68           C  
ATOM    135  C   HIS A  24      39.287 -17.813  12.338  1.00 16.31           C  
ATOM    136  O   HIS A  24      38.263 -18.363  11.916  1.00 16.05           O  
ATOM    137  CB  HIS A  24      38.045 -17.455  14.529  1.00 16.85           C  
ATOM    138  N   PRO A  25      40.427 -17.789  11.657  1.00 16.86           N  
ATOM    139  CA  PRO A  25      40.538 -18.303  10.296  1.00 16.33           C  
ATOM    140  C   PRO A  25      40.112 -19.771  10.232  1.00 16.33           C  
ATOM    141  O   PRO A  25      40.414 -20.535  11.153  1.00 16.20           O  
ATOM    142  CB  PRO A  25      41.975 -18.144   9.798  1.00 16.95           C  
ATOM    143  N   PRO A  26      39.401 -20.177   9.158  1.00 15.96           N  
ATOM    144  CA  PRO A  26      39.009 -21.586   9.084  1.00 15.73           C  
ATOM    145  C   PRO A  26      40.206 -22.518   9.227  1.00 15.54           C  
ATOM    146  O   PRO A  26      41.282 -22.232   8.681  1.00 15.34           O  
ATOM    147  CB  PRO A  26      38.430 -21.716   7.671  1.00 16.16           C  
ATOM    148  CG  PRO A  26      37.929 -20.359   7.355  1.00 15.87           C  
ATOM    149  CD  PRO A  26      38.899 -19.409   8.002  1.00 16.27           C  
ATOM    150  N   VAL A  27      39.995 -23.627   9.937  1.00 15.82           N  
ATOM    151  CA  VAL A  27      41.042 -24.628  10.151  1.00 16.24           C  
ATOM    152  C   VAL A  27      40.886 -25.758   9.149  1.00 16.84           C  
ATOM    153  O   VAL A  27      39.809 -26.329   9.027  1.00 16.47           O  
ATOM    154  CB  VAL A  27      40.964 -25.167  11.551  1.00 16.32           C  
ATOM    155  N   GLU A  28      41.965 -26.087   8.440  1.00 17.35           N  
ATOM    156  CA  GLU A  28      41.911 -27.133   7.427  1.00 17.90           C  
ATOM    157  C   GLU A  28      41.409 -28.434   8.045  1.00 18.07           C  
ATOM    158  O   GLU A  28      41.892 -28.862   9.095  1.00 18.38           O  
ATOM    159  CB  GLU A  28      43.277 -27.316   6.762  1.00 18.46           C  
ATOM    160  N   GLY A  29      40.370 -28.998   7.428  1.00 18.18           N  
ATOM    161  CA  GLY A  29      39.779 -30.281   7.814  1.00 18.38           C  
ATOM    162  C   GLY A  29      38.580 -30.176   8.756  1.00 18.05           C  
ATOM    163  O   GLY A  29      37.818 -31.129   8.900  1.00 18.58           O  
ATOM    164  N   SER A  30      38.409 -29.016   9.376  1.00 17.44           N  
ATOM    165  CA  SER A  30      37.329 -28.838  10.319  1.00 16.41           C  
ATOM    166  C   SER A  30      35.953 -28.791   9.611  1.00 16.16           C  
ATOM    167  O   SER A  30      35.025 -29.491  10.021  1.00 16.83           O  
ATOM    168  CB  SER A  30      37.575 -27.607  11.153  1.00 16.65           C  
ATOM    169  N   TYR A  31      35.824 -27.989   8.552  1.00 14.74           N  
ATOM    170  CA  TYR A  31      34.565 -27.939   7.799  1.00 14.07           C  
ATOM    171  C   TYR A  31      34.512 -28.990   6.690  1.00 13.73           C  
ATOM    172  O   TYR A  31      35.411 -29.044   5.856  1.00 14.48           O  
ATOM    173  CB  TYR A  31      34.290 -26.549   7.197  1.00 13.89           C  
ATOM    174  CG  TYR A  31      33.016 -26.558   6.374  1.00 12.59           C  
ATOM    175  CD1 TYR A  31      31.770 -26.639   6.994  1.00 14.24           C  
ATOM    176  CD2 TYR A  31      33.057 -26.552   4.989  1.00 11.84           C  
ATOM    177  CE1 TYR A  31      30.590 -26.697   6.252  1.00 14.96           C  
ATOM    178  CE2 TYR A  31      31.873 -26.592   4.219  1.00 11.87           C  
ATOM    179  CZ  TYR A  31      30.648 -26.685   4.866  1.00 13.26           C  
ATOM    180  OH  TYR A  31      29.469 -26.746   4.161  1.00 14.31           O  
ATOM    181  N   ALA A  32      33.451 -29.794   6.683  1.00 13.28           N  
ATOM    182  CA  ALA A  32      33.231 -30.810   5.653  1.00 13.65           C  
ATOM    183  C   ALA A  32      32.010 -30.407   4.824  1.00 13.02           C  
ATOM    184  O   ALA A  32      30.932 -30.197   5.373  1.00 14.27           O  
ATOM    185  CB  ALA A  32      33.018 -32.175   6.292  1.00 14.64           C  
ATOM    186  N   PRO A  33      32.190 -30.306   3.510  1.00 13.08           N  
ATOM    187  CA  PRO A  33      31.124 -29.844   2.618  1.00 13.26           C  
ATOM    188  C   PRO A  33      30.048 -30.905   2.439  1.00 13.46           C  
ATOM    189  O   PRO A  33      30.355 -32.085   2.218  1.00 13.90           O  
ATOM    190  CB  PRO A  33      31.702 -29.451   1.264  1.00 13.84           C  
ATOM    191  N   ARG A  34      28.791 -30.502   2.554  1.00 12.70           N  
ATOM    192  CA  ARG A  34      27.681 -31.381   2.215  1.00 12.98           C  
ATOM    193  C   ARG A  34      26.635 -30.603   1.434  1.00 12.57           C  
ATOM    194  O   ARG A  34      26.397 -29.420   1.700  1.00 11.54           O  
ATOM    195  CB  ARG A  34      27.070 -31.995   3.471  1.00 14.13           C  
ATOM    196  N   ARG A  35      26.031 -31.276   0.455  1.00 11.58           N  
ATOM    197  CA  ARG A  35      25.069 -30.652  -0.429  1.00 10.64           C  
ATOM    198  C   ARG A  35      23.970 -29.967   0.360  1.00 10.06           C  
ATOM    199  O   ARG A  35      23.395 -30.546   1.293  1.00 10.34           O  
ATOM    200  CB  ARG A  35      24.480 -31.675  -1.414  1.00 10.80           C  
ATOM    201  CG  ARG A  35      23.638 -31.047  -2.490  1.00 10.90           C  
ATOM    202  CD  ARG A  35      22.833 -32.097  -3.248  1.00 14.85           C  
ATOM    203  NE  ARG A  35      23.567 -32.716  -4.343  1.00 19.14           N  
ATOM    204  CZ  ARG A  35      23.227 -32.655  -5.635  1.00 18.83           C  
ATOM    205  NH1 ARG A  35      22.151 -31.987  -6.044  1.00 19.19           N  
ATOM    206  NH2 ARG A  35      23.983 -33.274  -6.527  1.00 19.76           N  
ATOM    207  N   GLY A  36      23.711 -28.712  -0.015  1.00  9.39           N  
ATOM    208  CA  GLY A  36      22.634 -27.930   0.562  1.00 10.24           C  
ATOM    209  C   GLY A  36      23.012 -27.120   1.793  1.00  9.55           C  
ATOM    210  O   GLY A  36      22.230 -26.254   2.236  1.00 11.29           O  
ATOM    211  N   GLU A  37      24.199 -27.381   2.342  1.00 10.51           N  
ATOM    212  CA  GLU A  37      24.687 -26.649   3.517  1.00 10.26           C  
ATOM    213  C   GLU A  37      25.251 -25.310   3.104  1.00 10.03           C  
ATOM    214  O   GLU A  37      25.808 -25.171   2.012  1.00  9.59           O  
ATOM    215  CB  GLU A  37      25.755 -27.446   4.260  1.00 10.87           C  
ATOM    216  N   PHE A  38      25.094 -24.329   3.990  1.00  9.32           N  
ATOM    217  CA  PHE A  38      25.765 -23.039   3.837  1.00  9.33           C  
ATOM    218  C   PHE A  38      27.179 -23.102   4.422  1.00 10.00           C  
ATOM    219  O   PHE A  38      27.487 -23.896   5.320  1.00 11.29           O  
ATOM    220  CB  PHE A  38      24.952 -21.935   4.521  1.00  9.49           C  
ATOM    221  CG  PHE A  38      23.598 -21.706   3.904  1.00  9.71           C  
ATOM    222  CD1 PHE A  38      22.456 -22.325   4.416  1.00 10.29           C  
ATOM    223  CD2 PHE A  38      23.466 -20.877   2.800  1.00 10.46           C  
ATOM    224  CE1 PHE A  38      21.211 -22.099   3.822  1.00 12.80           C  
ATOM    225  CE2 PHE A  38      22.239 -20.658   2.213  1.00 10.65           C  
ATOM    226  CZ  PHE A  38      21.111 -21.271   2.722  1.00 12.32           C  
ATOM    227  N   CYS A  39      28.054 -22.276   3.866  1.00  8.76           N  
ATOM    228  CA  CYS A  39      29.436 -22.215   4.283  1.00  8.92           C  
ATOM    229  C   CYS A  39      29.997 -20.870   3.903  1.00  9.07           C  
ATOM    230  O   CYS A  39      29.285 -20.027   3.373  1.00  7.04           O  
ATOM    231  CB  CYS A  39      30.229 -23.340   3.610  1.00  9.88           C  
ATOM    232  SG  CYS A  39      30.272 -23.223   1.818  1.00 11.93           S  
ATOM    233  N   ILE A  40      31.278 -20.655   4.177  1.00  7.30           N  
ATOM    234  CA  ILE A  40      31.967 -19.535   3.561  1.00  7.17           C  
ATOM    235  C   ILE A  40      32.917 -20.100   2.503  1.00  6.57           C  
ATOM    236  O   ILE A  40      33.411 -21.223   2.639  1.00  7.57           O  
ATOM    237  CB  ILE A  40      32.708 -18.632   4.584  1.00  7.18           C  
ATOM    238  CG1 ILE A  40      33.679 -19.434   5.462  1.00  7.23           C  
ATOM    239  CG2 ILE A  40      31.701 -17.869   5.413  1.00  8.07           C  
ATOM    240  CD1 ILE A  40      34.603 -18.624   6.382  1.00  6.16           C  
ATOM    241  N   ALA A  41      33.144 -19.332   1.446  1.00  6.55           N  
ATOM    242  CA  ALA A  41      33.979 -19.748   0.329  1.00  7.00           C  
ATOM    243  C   ALA A  41      34.933 -18.623  -0.024  1.00  6.77           C  
ATOM    244  O   ALA A  41      34.511 -17.451  -0.070  1.00  7.27           O  
ATOM    245  CB  ALA A  41      33.103 -20.115  -0.876  1.00  8.18           C  
ATOM    246  N   LYS A  42      36.196 -18.979  -0.254  1.00  7.93           N  
ATOM    247  CA  LYS A  42      37.212 -18.000  -0.572  1.00  7.59           C  
ATOM    248  C   LYS A  42      37.328 -17.828  -2.073  1.00  8.24           C  
ATOM    249  O   LYS A  42      37.797 -18.720  -2.763  1.00  9.17           O  
ATOM    250  CB  LYS A  42      38.552 -18.430   0.026  1.00  8.67           C  
ATOM    251  CG  LYS A  42      39.463 -17.258   0.260  1.00 10.02           C  
ATOM    252  CD  LYS A  42      40.733 -17.703   0.981  1.00 13.40           C  
ATOM    253  CE  LYS A  42      41.621 -16.529   1.355  1.00 17.13           C  
ATOM    254  NZ  LYS A  42      42.892 -16.968   2.010  1.00 20.07           N  
ATOM    255  N   PHE A  43      36.875 -16.676  -2.571  1.00  8.28           N  
ATOM    256  CA  PHE A  43      36.783 -16.413  -4.006  1.00  9.61           C  
ATOM    257  C   PHE A  43      38.175 -16.092  -4.565  1.00 10.38           C  
ATOM    258  O   PHE A  43      39.156 -16.011  -3.812  1.00 10.99           O  
ATOM    259  CB  PHE A  43      35.805 -15.255  -4.210  1.00  9.52           C  
ATOM    260  CG  PHE A  43      35.454 -14.961  -5.636  1.00  9.45           C  
ATOM    261  CD1 PHE A  43      35.027 -15.971  -6.502  1.00 10.26           C  
ATOM    262  CD2 PHE A  43      35.495 -13.658  -6.097  1.00  9.98           C  
ATOM    263  CE1 PHE A  43      34.679 -15.689  -7.845  1.00 11.32           C  
ATOM    264  CE2 PHE A  43      35.153 -13.366  -7.437  1.00 12.02           C  
ATOM    265  CZ  PHE A  43      34.758 -14.385  -8.303  1.00 11.39           C  
ATOM    266  N   VAL A  44      38.262 -15.870  -5.874  1.00 10.56           N  
ATOM    267  CA  VAL A  44      39.550 -15.652  -6.535  1.00 12.17           C  
ATOM    268  C   VAL A  44      40.231 -14.333  -6.141  1.00 12.29           C  
ATOM    269  O   VAL A  44      41.417 -14.113  -6.452  1.00 13.89           O  
ATOM    270  CB  VAL A  44      39.419 -15.722  -8.077  1.00 12.04           C  
ATOM    271  CG1 VAL A  44      38.827 -17.060  -8.520  1.00 12.53           C  
ATOM    272  CG2 VAL A  44      38.637 -14.515  -8.615  1.00 14.43           C  
ATOM    273  N   ASP A  45      39.498 -13.449  -5.473  1.00 11.75           N  
ATOM    274  CA  ASP A  45      40.061 -12.182  -4.985  1.00 11.56           C  
ATOM    275  C   ASP A  45      40.713 -12.315  -3.599  1.00 11.69           C  
ATOM    276  O   ASP A  45      41.204 -11.332  -3.026  1.00 12.71           O  
ATOM    277  CB  ASP A  45      38.997 -11.073  -4.991  1.00 12.03           C  
ATOM    278  CG  ASP A  45      37.766 -11.415  -4.147  1.00 12.79           C  
ATOM    279  OD1 ASP A  45      37.682 -12.541  -3.616  1.00 13.95           O  
ATOM    280  OD2 ASP A  45      36.882 -10.532  -4.020  1.00 13.84           O  
ATOM    281  N   GLY A  46      40.722 -13.539  -3.081  1.00 12.07           N  
ATOM    282  CA  GLY A  46      41.276 -13.822  -1.770  1.00 11.77           C  
ATOM    283  C   GLY A  46      40.355 -13.401  -0.634  1.00 11.72           C  
ATOM    284  O   GLY A  46      40.753 -13.426   0.531  1.00 12.53           O  
ATOM    285  N   GLU A  47      39.117 -13.026  -0.969  1.00 11.04           N  
ATOM    286  CA  GLU A  47      38.113 -12.652   0.037  1.00 10.73           C  
ATOM    287  C   GLU A  47      37.084 -13.764   0.279  1.00  9.61           C  
ATOM    288  O   GLU A  47      36.786 -14.560  -0.625  1.00  8.04           O  
ATOM    289  CB  GLU A  47      37.394 -11.345  -0.342  1.00 11.61           C  
ATOM    290  CG  GLU A  47      38.290 -10.083  -0.413  1.00 13.87           C  
ATOM    291  CD  GLU A  47      38.873  -9.637   0.936  1.00 19.30           C  
ATOM    292  OE1 GLU A  47      38.303  -9.949   1.999  1.00 19.25           O  
ATOM    293  OE2 GLU A  47      39.911  -8.939   0.923  1.00 22.42           O  
ATOM    294  N   TRP A  48      36.535 -13.793   1.501  1.00  7.80           N  
ATOM    295  CA  TRP A  48      35.545 -14.794   1.901  1.00  7.49           C  
ATOM    296  C   TRP A  48      34.136 -14.254   1.634  1.00  6.22           C  
ATOM    297  O   TRP A  48      33.844 -13.063   1.839  1.00  8.16           O  
ATOM    298  CB  TRP A  48      35.664 -15.152   3.384  1.00  7.64           C  
ATOM    299  CG  TRP A  48      36.906 -15.937   3.734  1.00  8.14           C  
ATOM    300  CD1 TRP A  48      38.080 -15.411   4.201  1.00  9.85           C  
ATOM    301  CD2 TRP A  48      37.119 -17.364   3.629  1.00  7.56           C  
ATOM    302  NE1 TRP A  48      39.008 -16.422   4.407  1.00  9.76           N  
ATOM    303  CE2 TRP A  48      38.447 -17.624   4.050  1.00  8.96           C  
ATOM    304  CE3 TRP A  48      36.324 -18.444   3.210  1.00  8.13           C  
ATOM    305  CZ2 TRP A  48      38.984 -18.913   4.083  1.00  9.76           C  
ATOM    306  CZ3 TRP A  48      36.856 -19.720   3.249  1.00  8.12           C  
ATOM    307  CH2 TRP A  48      38.176 -19.947   3.678  1.00  8.47           C  
ATOM    308  N   TYR A  49      33.283 -15.164   1.171  1.00  6.59           N  
ATOM    309  CA  TYR A  49      31.893 -14.874   0.818  1.00  5.81           C  
ATOM    310  C   TYR A  49      30.973 -15.951   1.355  1.00  6.55           C  
ATOM    311  O   TYR A  49      31.407 -17.086   1.552  1.00  6.22           O  
ATOM    312  CB  TYR A  49      31.713 -14.813  -0.716  1.00  6.84           C  
ATOM    313  CG  TYR A  49      32.408 -13.653  -1.409  1.00  4.42           C  
ATOM    314  CD1 TYR A  49      31.697 -12.528  -1.813  1.00  6.47           C  
ATOM    315  CD2 TYR A  49      33.765 -13.720  -1.690  1.00  6.71           C  
ATOM    316  CE1 TYR A  49      32.334 -11.468  -2.453  1.00  8.18           C  
ATOM    317  CE2 TYR A  49      34.404 -12.675  -2.342  1.00  6.74           C  
ATOM    318  CZ  TYR A  49      33.683 -11.549  -2.711  1.00  7.87           C  
ATOM    319  OH  TYR A  49      34.318 -10.507  -3.364  1.00  8.51           O  
ATOM    320  N   ARG A  50      29.704 -15.622   1.577  1.00  5.91           N  
ATOM    321  CA  ARG A  50      28.729 -16.648   1.954  1.00  6.00           C  
ATOM    322  C   ARG A  50      28.384 -17.514   0.731  1.00  6.57           C  
ATOM    323  O   ARG A  50      28.235 -17.034  -0.407  1.00  6.30           O  
ATOM    324  CB  ARG A  50      27.446 -16.040   2.552  1.00  6.85           C  
ATOM    325  CG  ARG A  50      27.706 -15.061   3.679  1.00  6.36           C  
ATOM    326  CD  ARG A  50      26.437 -14.750   4.479  1.00  6.42           C  
ATOM    327  NE  ARG A  50      25.421 -14.082   3.681  1.00  8.38           N  
ATOM    328  CZ  ARG A  50      24.172 -13.900   4.088  1.00  8.14           C  
ATOM    329  NH1 ARG A  50      23.804 -14.290   5.312  1.00  5.80           N  
ATOM    330  NH2 ARG A  50      23.302 -13.286   3.295  1.00  7.81           N  
ATOM    331  N   ALA A  51      28.250 -18.816   0.969  1.00  6.13           N  
ATOM    332  CA  ALA A  51      27.987 -19.727  -0.126  1.00  6.66           C  
ATOM    333  C   ALA A  51      27.147 -20.907   0.312  1.00  7.06           C  
ATOM    334  O   ALA A  51      26.919 -21.144   1.496  1.00  7.33           O  
ATOM    335  CB  ALA A  51      29.312 -20.207  -0.765  1.00  7.24           C  
ATOM    336  N   ARG A  52      26.635 -21.614  -0.687  1.00  6.95           N  
ATOM    337  CA  ARG A  52      25.901 -22.854  -0.455  1.00  8.40           C  
ATOM    338  C   ARG A  52      26.476 -23.957  -1.339  1.00  7.82           C  
ATOM    339  O   ARG A  52      26.790 -23.736  -2.508  1.00  7.57           O  
ATOM    340  CB  ARG A  52      24.409 -22.674  -0.740  1.00  9.34           C  
ATOM    341  CG  ARG A  52      23.547 -23.668   0.012  1.00 14.05           C  
ATOM    342  CD  ARG A  52      22.165 -23.836  -0.595  1.00 21.67           C  
ATOM    343  NE  ARG A  52      21.245 -22.767  -0.233  1.00 27.25           N  
ATOM    344  CZ  ARG A  52      19.913 -22.875  -0.245  1.00 30.14           C  
ATOM    345  NH1 ARG A  52      19.327 -24.017  -0.594  1.00 31.61           N  
ATOM    346  NH2 ARG A  52      19.161 -21.836   0.095  1.00 31.46           N  
ATOM    347  N   VAL A  53      26.625 -25.150  -0.760  1.00  7.72           N  
ATOM    348  CA  VAL A  53      27.191 -26.275  -1.502  1.00  7.95           C  
ATOM    349  C   VAL A  53      26.106 -26.877  -2.418  1.00  7.94           C  
ATOM    350  O   VAL A  53      25.015 -27.227  -1.948  1.00  8.14           O  
ATOM    351  CB  VAL A  53      27.786 -27.347  -0.539  1.00  7.49           C  
ATOM    352  CG1 VAL A  53      28.278 -28.550  -1.322  1.00  8.67           C  
ATOM    353  CG2 VAL A  53      28.981 -26.783   0.313  1.00  9.36           C  
ATOM    354  N   GLU A  54      26.408 -26.973  -3.716  1.00  8.91           N  
ATOM    355  CA  GLU A  54      25.480 -27.539  -4.697  1.00 10.14           C  
ATOM    356  C   GLU A  54      25.796 -28.977  -5.138  1.00 10.92           C  
ATOM    357  O   GLU A  54      24.873 -29.712  -5.548  1.00 11.78           O  
ATOM    358  CB  GLU A  54      25.364 -26.619  -5.912  1.00 11.42           C  
ATOM    359  CG  GLU A  54      24.657 -25.318  -5.553  1.00 12.99           C  
ATOM    360  CD  GLU A  54      24.244 -24.500  -6.753  1.00 15.12           C  
ATOM    361  OE1 GLU A  54      25.003 -24.464  -7.746  1.00 17.54           O  
ATOM    362  OE2 GLU A  54      23.161 -23.880  -6.685  1.00 18.66           O  
ATOM    363  N   LYS A  55      27.071 -29.370  -5.062  1.00 10.13           N  
ATOM    364  CA  LYS A  55      27.485 -30.715  -5.473  1.00 11.57           C  
ATOM    365  C   LYS A  55      28.910 -30.963  -5.019  1.00 11.31           C  
ATOM    366  O   LYS A  55      29.780 -30.094  -5.143  1.00 11.70           O  
ATOM    367  CB  LYS A  55      27.377 -30.872  -6.987  1.00 11.44           C  
ATOM    368  CG  LYS A  55      27.842 -32.213  -7.545  1.00 14.80           C  
ATOM    369  CD  LYS A  55      27.612 -32.252  -9.044  1.00 18.11           C  
ATOM    370  CE  LYS A  55      28.770 -32.951  -9.746  1.00 22.97           C  
ATOM    371  NZ  LYS A  55      28.715 -32.809 -11.244  1.00 25.41           N  
ATOM    372  N   VAL A  56      29.147 -32.174  -4.525  1.00 11.94           N  
ATOM    373  CA  VAL A  56      30.472 -32.605  -4.144  1.00 13.37           C  
ATOM    374  C   VAL A  56      30.983 -33.591  -5.186  1.00 14.42           C  
ATOM    375  O   VAL A  56      30.484 -34.727  -5.292  1.00 15.27           O  
ATOM    376  CB  VAL A  56      30.486 -33.239  -2.736  1.00 12.94           C  
ATOM    377  CG1 VAL A  56      31.869 -33.734  -2.418  1.00 13.48           C  
ATOM    378  CG2 VAL A  56      30.047 -32.238  -1.691  1.00 13.45           C  
ATOM    379  N   GLU A  57      31.982 -33.146  -5.944  1.00 14.85           N  
ATOM    380  CA  GLU A  57      32.583 -33.953  -7.010  1.00 17.44           C  
ATOM    381  C   GLU A  57      33.770 -34.762  -6.469  1.00 16.69           C  
ATOM    382  O   GLU A  57      33.883 -35.977  -6.720  1.00 17.75           O  
ATOM    383  CB  GLU A  57      32.990 -33.035  -8.176  1.00 17.03           C  
ATOM    384  CG  GLU A  57      33.586 -33.736  -9.412  1.00 19.50           C  
ATOM    385  CD  GLU A  57      34.031 -32.767 -10.516  1.00 20.48           C  
ATOM    386  OE1 GLU A  57      34.812 -33.200 -11.394  1.00 22.98           O  
ATOM    387  OE2 GLU A  57      33.615 -31.585 -10.530  1.00 23.49           O  
ATOM    388  N   SER A  58      34.642 -34.091  -5.722  1.00 16.72           N  
ATOM    389  CA  SER A  58      35.792 -34.707  -5.059  1.00 15.59           C  
ATOM    390  C   SER A  58      36.304 -33.761  -3.971  1.00 15.52           C  
ATOM    391  O   SER A  58      35.814 -32.641  -3.869  1.00 15.12           O  
ATOM    392  CB  SER A  58      36.881 -35.023  -6.096  1.00 15.52           C  
ATOM    393  OG  SER A  58      37.543 -33.857  -6.555  1.00 16.88           O  
ATOM    394  N   PRO A  59      37.259 -34.197  -3.130  1.00 14.52           N  
ATOM    395  CA  PRO A  59      37.811 -33.263  -2.152  1.00 14.85           C  
ATOM    396  C   PRO A  59      38.360 -31.954  -2.719  1.00 14.65           C  
ATOM    397  O   PRO A  59      38.378 -30.937  -2.006  1.00 14.96           O  
ATOM    398  CB  PRO A  59      38.928 -34.083  -1.522  1.00 14.79           C  
ATOM    399  CG  PRO A  59      38.403 -35.472  -1.584  1.00 14.11           C  
ATOM    400  CD  PRO A  59      37.841 -35.544  -2.951  1.00 14.37           C  
ATOM    401  N   ALA A  60      38.785 -31.973  -3.988  1.00 14.00           N  
ATOM    402  CA  ALA A  60      39.367 -30.799  -4.627  1.00 14.09           C  
ATOM    403  C   ALA A  60      38.328 -30.062  -5.462  1.00 13.95           C  
ATOM    404  O   ALA A  60      38.615 -28.989  -5.973  1.00 14.68           O  
ATOM    405  CB  ALA A  60      40.563 -31.187  -5.495  1.00 14.66           C  
ATOM    406  N   LYS A  61      37.137 -30.644  -5.612  1.00 13.50           N  
ATOM    407  CA  LYS A  61      36.128 -30.068  -6.502  1.00 13.26           C  
ATOM    408  C   LYS A  61      34.720 -30.010  -5.906  1.00 12.70           C  
ATOM    409  O   LYS A  61      33.909 -30.927  -6.059  1.00 12.88           O  
ATOM    410  CB  LYS A  61      36.141 -30.747  -7.883  1.00 14.17           C  
ATOM    411  CG  LYS A  61      37.390 -30.378  -8.691  1.00 14.50           C  
ATOM    412  CD  LYS A  61      37.425 -31.057 -10.060  1.00 14.60           C  
ATOM    413  CE  LYS A  61      38.794 -30.911 -10.708  1.00 18.45           C  
ATOM    414  NZ  LYS A  61      38.810 -31.536 -12.068  1.00 20.20           N  
ATOM    415  N   ILE A  62      34.451 -28.905  -5.220  1.00 10.99           N  
ATOM    416  CA  ILE A  62      33.167 -28.675  -4.579  1.00 10.38           C  
ATOM    417  C   ILE A  62      32.468 -27.543  -5.311  1.00  9.57           C  
ATOM    418  O   ILE A  62      33.032 -26.460  -5.449  1.00  9.85           O  
ATOM    419  CB  ILE A  62      33.341 -28.323  -3.085  1.00 10.81           C  
ATOM    420  CG1 ILE A  62      34.243 -29.367  -2.423  1.00 13.60           C  
ATOM    421  CG2 ILE A  62      31.986 -28.219  -2.393  1.00 10.34           C  
ATOM    422  CD1 ILE A  62      34.562 -29.152  -0.988  1.00 19.47           C  
ATOM    423  N   HIS A  63      31.263 -27.821  -5.811  1.00  8.72           N  
ATOM    424  CA  HIS A  63      30.475 -26.842  -6.559  1.00  9.01           C  
ATOM    425  C   HIS A  63      29.714 -26.004  -5.556  1.00  8.69           C  
ATOM    426  O   HIS A  63      28.930 -26.536  -4.788  1.00  8.99           O  
ATOM    427  CB  HIS A  63      29.486 -27.521  -7.516  1.00 10.21           C  
ATOM    428  CG  HIS A  63      30.136 -28.354  -8.583  1.00 11.62           C  
ATOM    429  ND1 HIS A  63      31.092 -29.309  -8.312  1.00 15.19           N  
ATOM    430  CD2 HIS A  63      29.918 -28.406  -9.917  1.00 14.31           C  
ATOM    431  CE1 HIS A  63      31.469 -29.884  -9.440  1.00 15.96           C  
ATOM    432  NE2 HIS A  63      30.758 -29.370 -10.426  1.00 14.96           N  
ATOM    433  N   VAL A  64      29.966 -24.697  -5.562  1.00  7.77           N  
ATOM    434  CA  VAL A  64      29.244 -23.778  -4.678  1.00  8.19           C  
ATOM    435  C   VAL A  64      28.541 -22.648  -5.417  1.00  8.74           C  
ATOM    436  O   VAL A  64      28.875 -22.315  -6.563  1.00  8.21           O  
ATOM    437  CB  VAL A  64      30.164 -23.150  -3.594  1.00  8.10           C  
ATOM    438  CG1 VAL A  64      30.847 -24.256  -2.775  1.00  9.03           C  
ATOM    439  CG2 VAL A  64      31.177 -22.147  -4.210  1.00  7.74           C  
ATOM    440  N   PHE A  65      27.583 -22.059  -4.724  1.00  7.92           N  
ATOM    441  CA  PHE A  65      26.792 -20.934  -5.204  1.00  7.55           C  
ATOM    442  C   PHE A  65      27.015 -19.818  -4.198  1.00  6.71           C  
ATOM    443  O   PHE A  65      26.782 -20.001  -3.007  1.00  6.44           O  
ATOM    444  CB  PHE A  65      25.314 -21.340  -5.240  1.00  8.39           C  
ATOM    445  CG  PHE A  65      24.354 -20.221  -5.557  1.00  8.22           C  
ATOM    446  CD1 PHE A  65      24.219 -19.780  -6.857  1.00 11.38           C  
ATOM    447  CD2 PHE A  65      23.514 -19.684  -4.571  1.00 11.16           C  
ATOM    448  CE1 PHE A  65      23.295 -18.754  -7.177  1.00 12.53           C  
ATOM    449  CE2 PHE A  65      22.604 -18.665  -4.877  1.00 11.65           C  
ATOM    450  CZ  PHE A  65      22.497 -18.209  -6.189  1.00 11.67           C  
ATOM    451  N   TYR A  66      27.512 -18.681  -4.688  1.00  7.49           N  
ATOM    452  CA  TYR A  66      27.721 -17.514  -3.848  1.00  7.11           C  
ATOM    453  C   TYR A  66      26.366 -16.837  -3.622  1.00  6.88           C  
ATOM    454  O   TYR A  66      25.830 -16.179  -4.530  1.00  6.36           O  
ATOM    455  CB  TYR A  66      28.723 -16.558  -4.504  1.00  7.67           C  
ATOM    456  CG  TYR A  66      30.126 -17.073  -4.478  1.00  8.49           C  
ATOM    457  CD1 TYR A  66      30.913 -16.935  -3.348  1.00  8.17           C  
ATOM    458  CD2 TYR A  66      30.672 -17.698  -5.590  1.00 10.47           C  
ATOM    459  CE1 TYR A  66      32.221 -17.420  -3.322  1.00  9.97           C  
ATOM    460  CE2 TYR A  66      32.000 -18.174  -5.577  1.00 12.04           C  
ATOM    461  CZ  TYR A  66      32.751 -18.029  -4.442  1.00 11.25           C  
ATOM    462  OH  TYR A  66      34.051 -18.492  -4.404  1.00 11.44           O  
ATOM    463  N   ILE A  67      25.816 -16.984  -2.416  1.00  7.14           N  
ATOM    464  CA  ILE A  67      24.418 -16.665  -2.202  1.00  7.34           C  
ATOM    465  C   ILE A  67      24.095 -15.188  -2.246  1.00  7.59           C  
ATOM    466  O   ILE A  67      22.938 -14.832  -2.402  1.00  8.49           O  
ATOM    467  CB  ILE A  67      23.850 -17.274  -0.878  1.00  7.60           C  
ATOM    468  CG1 ILE A  67      24.489 -16.632   0.367  1.00  7.26           C  
ATOM    469  CG2 ILE A  67      24.013 -18.791  -0.890  1.00  7.87           C  
ATOM    470  CD1 ILE A  67      23.806 -16.991   1.721  1.00  7.54           C  
ATOM    471  N   ASP A  68      25.115 -14.349  -2.120  1.00  6.63           N  
ATOM    472  CA  ASP A  68      24.893 -12.901  -2.149  1.00  7.05           C  
ATOM    473  C   ASP A  68      25.194 -12.262  -3.489  1.00  9.18           C  
ATOM    474  O   ASP A  68      24.952 -11.059  -3.665  1.00  7.85           O  
ATOM    475  CB  ASP A  68      25.685 -12.225  -1.023  1.00  7.68           C  
ATOM    476  CG  ASP A  68      25.257 -12.693   0.355  1.00  6.89           C  
ATOM    477  OD1 ASP A  68      24.026 -12.785   0.582  1.00  7.64           O  
ATOM    478  OD2 ASP A  68      26.145 -12.954   1.212  1.00  6.50           O  
ATOM    479  N   TYR A  69      25.682 -13.066  -4.433  1.00  9.32           N  
ATOM    480  CA  TYR A  69      26.151 -12.574  -5.730  1.00 11.47           C  
ATOM    481  C   TYR A  69      25.607 -13.334  -6.943  1.00 12.87           C  
ATOM    482  O   TYR A  69      25.569 -12.779  -8.042  1.00 15.01           O  
ATOM    483  CB  TYR A  69      27.692 -12.503  -5.724  1.00 12.57           C  
ATOM    484  CG  TYR A  69      28.192 -11.432  -4.780  1.00 13.30           C  
ATOM    485  CD1 TYR A  69      28.344 -10.118  -5.226  1.00 14.89           C  
ATOM    486  CD2 TYR A  69      28.462 -11.708  -3.429  1.00 13.30           C  
ATOM    487  CE1 TYR A  69      28.756  -9.127  -4.378  1.00 15.28           C  
ATOM    488  CE2 TYR A  69      28.893 -10.702  -2.563  1.00 14.23           C  
ATOM    489  CZ  TYR A  69      29.041  -9.406  -3.055  1.00 15.88           C  
ATOM    490  OH  TYR A  69      29.448  -8.390  -2.205  1.00 18.62           O  
ATOM    491  N   GLY A  70      25.204 -14.594  -6.772  1.00 12.41           N  
ATOM    492  CA  GLY A  70      24.498 -15.319  -7.845  1.00 12.77           C  
ATOM    493  C   GLY A  70      25.324 -16.130  -8.827  1.00 13.80           C  
ATOM    494  O   GLY A  70      24.792 -16.712  -9.786  1.00 15.56           O  
ATOM    495  N   ASN A  71      26.624 -16.206  -8.580  1.00 11.91           N  
ATOM    496  CA  ASN A  71      27.534 -16.968  -9.430  1.00 12.06           C  
ATOM    497  C   ASN A  71      27.947 -18.256  -8.759  1.00 11.00           C  
ATOM    498  O   ASN A  71      27.778 -18.428  -7.552  1.00  9.86           O  
ATOM    499  CB  ASN A  71      28.794 -16.170  -9.730  1.00 13.54           C  
ATOM    500  CG  ASN A  71      29.642 -15.968  -8.506  1.00 15.80           C  
ATOM    501  OD1 ASN A  71      29.136 -15.517  -7.483  1.00 17.84           O  
ATOM    502  ND2 ASN A  71      30.940 -16.291  -8.594  1.00 20.38           N  
ATOM    503  N   ARG A  72      28.533 -19.132  -9.558  1.00 10.26           N  
ATOM    504  CA  ARG A  72      29.004 -20.421  -9.093  1.00 10.82           C  
ATOM    505  C   ARG A  72      30.503 -20.576  -9.289  1.00 11.23           C  
ATOM    506  O   ARG A  72      31.120 -19.898 -10.128  1.00 12.12           O  
ATOM    507  CB  ARG A  72      28.242 -21.528  -9.815  1.00 10.82           C  
ATOM    508  CG  ARG A  72      26.788 -21.532  -9.469  1.00 11.43           C  
ATOM    509  CD  ARG A  72      25.954 -22.509 -10.242  1.00 16.64           C  
ATOM    510  NE  ARG A  72      24.666 -22.665  -9.571  1.00 20.12           N  
ATOM    511  CZ  ARG A  72      23.642 -21.819  -9.664  1.00 22.27           C  
ATOM    512  NH1 ARG A  72      23.717 -20.731 -10.429  1.00 21.85           N  
ATOM    513  NH2 ARG A  72      22.527 -22.069  -8.989  1.00 24.71           N  
ATOM    514  N   GLU A  73      31.097 -21.452  -8.488  1.00 10.61           N  
ATOM    515  CA  GLU A  73      32.503 -21.778  -8.631  1.00 11.24           C  
ATOM    516  C   GLU A  73      32.712 -23.195  -8.173  1.00 11.43           C  
ATOM    517  O   GLU A  73      31.980 -23.680  -7.314  1.00 10.84           O  
ATOM    518  CB  GLU A  73      33.389 -20.826  -7.803  1.00 10.72           C  
ATOM    519  CG  GLU A  73      34.885 -20.973  -8.101  1.00 11.40           C  
ATOM    520  CD  GLU A  73      35.773 -20.020  -7.297  1.00 12.76           C  
ATOM    521  OE1 GLU A  73      37.001 -20.051  -7.484  1.00 14.44           O  
ATOM    522  OE2 GLU A  73      35.261 -19.242  -6.471  1.00 14.95           O  
ATOM    523  N   VAL A  74      33.716 -23.851  -8.756  1.00 11.98           N  
ATOM    524  CA  VAL A  74      34.169 -25.156  -8.311  1.00 12.92           C  
ATOM    525  C   VAL A  74      35.495 -24.938  -7.616  1.00 13.54           C  
ATOM    526  O   VAL A  74      36.456 -24.439  -8.221  1.00 14.80           O  
ATOM    527  CB  VAL A  74      34.369 -26.121  -9.489  1.00 12.80           C  
ATOM    528  CG1 VAL A  74      34.884 -27.457  -8.973  1.00 13.58           C  
ATOM    529  CG2 VAL A  74      33.052 -26.317 -10.245  1.00 12.51           C  
ATOM    530  N   LEU A  75      35.557 -25.290  -6.338  1.00 13.44           N  
ATOM    531  CA  LEU A  75      36.768 -25.034  -5.563  1.00 14.25           C  
ATOM    532  C   LEU A  75      37.111 -26.155  -4.593  1.00 13.22           C  
ATOM    533  O   LEU A  75      36.268 -26.989  -4.279  1.00 12.25           O  
ATOM    534  CB  LEU A  75      36.712 -23.672  -4.851  1.00 15.99           C  
ATOM    535  CG  LEU A  75      35.398 -23.015  -4.457  1.00 17.07           C  
ATOM    536  CD1 LEU A  75      34.530 -23.968  -3.628  1.00 20.86           C  
ATOM    537  CD2 LEU A  75      35.640 -21.710  -3.729  1.00 15.99           C  
ATOM    538  N   PRO A  76      38.366 -26.186  -4.126  1.00 12.74           N  
ATOM    539  CA  PRO A  76      38.755 -27.253  -3.224  1.00 12.92           C  
ATOM    540  C   PRO A  76      38.202 -27.023  -1.809  1.00 13.41           C  
ATOM    541  O   PRO A  76      37.863 -25.889  -1.461  1.00 12.87           O  
ATOM    542  CB  PRO A  76      40.284 -27.177  -3.242  1.00 12.86           C  
ATOM    543  CG  PRO A  76      40.588 -25.742  -3.480  1.00 14.03           C  
ATOM    544  CD  PRO A  76      39.475 -25.249  -4.398  1.00 13.02           C  
ATOM    545  N   SER A  77      38.107 -28.093  -1.019  1.00 14.51           N  
ATOM    546  CA  SER A  77      37.657 -28.016   0.372  1.00 15.00           C  
ATOM    547  C   SER A  77      38.468 -27.032   1.214  1.00 14.09           C  
ATOM    548  O   SER A  77      37.971 -26.491   2.209  1.00 13.74           O  
ATOM    549  CB  SER A  77      37.683 -29.411   1.029  1.00 16.06           C  
ATOM    550  OG  SER A  77      37.576 -29.288   2.437  1.00 22.19           O  
ATOM    551  N   THR A  78      39.725 -26.813   0.825  1.00 13.92           N  
ATOM    552  CA  THR A  78      40.625 -25.943   1.576  1.00 14.96           C  
ATOM    553  C   THR A  78      40.135 -24.490   1.548  1.00 13.76           C  
ATOM    554  O   THR A  78      40.426 -23.720   2.458  1.00 14.77           O  
ATOM    555  CB  THR A  78      42.085 -26.019   1.066  1.00 15.98           C  
ATOM    556  OG1 THR A  78      42.476 -27.386   0.891  1.00 19.42           O  
ATOM    557  CG2 THR A  78      43.029 -25.389   2.071  1.00 17.39           C  
ATOM    558  N   ARG A  79      39.360 -24.139   0.519  1.00 11.80           N  
ATOM    559  CA  ARG A  79      38.868 -22.777   0.375  1.00 11.23           C  
ATOM    560  C   ARG A  79      37.422 -22.642   0.845  1.00  9.42           C  
ATOM    561  O   ARG A  79      36.717 -21.701   0.464  1.00 10.11           O  
ATOM    562  CB  ARG A  79      39.014 -22.315  -1.068  1.00 10.10           C  
ATOM    563  CG  ARG A  79      40.471 -22.212  -1.488  1.00 12.61           C  
ATOM    564  CD  ARG A  79      40.611 -21.717  -2.902  1.00 15.74           C  
ATOM    565  NE  ARG A  79      40.428 -20.268  -2.987  1.00 17.57           N  
ATOM    566  CZ  ARG A  79      41.381 -19.369  -2.756  1.00 17.11           C  
ATOM    567  NH1 ARG A  79      42.604 -19.756  -2.391  1.00 17.10           N  
ATOM    568  NH2 ARG A  79      41.106 -18.071  -2.874  1.00 16.38           N  
ATOM    569  N   LEU A  80      36.987 -23.577   1.671  1.00  8.73           N  
ATOM    570  CA  LEU A  80      35.658 -23.515   2.271  1.00  8.38           C  
ATOM    571  C   LEU A  80      35.800 -23.531   3.783  1.00  8.09           C  
ATOM    572  O   LEU A  80      36.706 -24.123   4.327  1.00  9.50           O  
ATOM    573  CB  LEU A  80      34.768 -24.678   1.814  1.00  8.40           C  
ATOM    574  CG  LEU A  80      34.566 -24.849   0.310  1.00  8.76           C  
ATOM    575  CD1 LEU A  80      33.759 -26.087   0.075  1.00 11.21           C  
ATOM    576  CD2 LEU A  80      33.853 -23.662  -0.318  1.00 10.32           C  
ATOM    577  N   GLY A  81      34.870 -22.896   4.474  1.00  6.58           N  
ATOM    578  CA  GLY A  81      34.871 -22.896   5.924  1.00  7.37           C  
ATOM    579  C   GLY A  81      33.463 -22.860   6.492  1.00  7.23           C  
ATOM    580  O   GLY A  81      32.495 -22.699   5.759  1.00  8.53           O  
ATOM    581  N   THR A  82      33.358 -22.996   7.815  1.00  7.85           N  
ATOM    582  CA  THR A  82      32.074 -22.924   8.485  1.00  8.67           C  
ATOM    583  C   THR A  82      31.522 -21.509   8.411  1.00  8.64           C  
ATOM    584  O   THR A  82      32.243 -20.536   8.651  1.00  9.11           O  
ATOM    585  CB  THR A  82      32.212 -23.338   9.969  1.00  8.03           C  
ATOM    586  OG1 THR A  82      32.637 -24.712  10.028  1.00 10.15           O  
ATOM    587  CG2 THR A  82      30.891 -23.218  10.718  1.00  9.85           C  
ATOM    588  N   LEU A  83      30.228 -21.397   8.113  1.00  8.23           N  
ATOM    589  CA  LEU A  83      29.527 -20.121   8.206  1.00  9.11           C  
ATOM    590  C   LEU A  83      29.029 -19.945   9.634  1.00  9.64           C  
ATOM    591  O   LEU A  83      28.155 -20.670  10.088  1.00 11.99           O  
ATOM    592  CB  LEU A  83      28.343 -20.066   7.233  1.00  8.12           C  
ATOM    593  CG  LEU A  83      27.502 -18.787   7.220  1.00  9.31           C  
ATOM    594  CD1 LEU A  83      28.385 -17.592   6.861  1.00  7.70           C  
ATOM    595  CD2 LEU A  83      26.375 -18.931   6.211  1.00  9.48           C  
ATOM    596  N   SER A  84      29.613 -19.002  10.360  1.00 11.22           N  
ATOM    597  CA  SER A  84      29.190 -18.787  11.745  1.00 11.88           C  
ATOM    598  C   SER A  84      27.752 -18.329  11.814  1.00 12.27           C  
ATOM    599  O   SER A  84      27.286 -17.628  10.919  1.00 10.46           O  
ATOM    600  CB  SER A  84      30.102 -17.803  12.455  1.00 13.17           C  
ATOM    601  OG  SER A  84      30.456 -16.739  11.612  1.00 19.63           O  
ATOM    602  N   PRO A  85      27.020 -18.794  12.844  1.00 12.42           N  
ATOM    603  CA  PRO A  85      25.616 -18.434  13.025  1.00 12.91           C  
ATOM    604  C   PRO A  85      25.341 -16.920  12.969  1.00 12.58           C  
ATOM    605  O   PRO A  85      24.270 -16.528  12.512  1.00 13.12           O  
ATOM    606  CB  PRO A  85      25.292 -18.992  14.416  1.00 13.18           C  
ATOM    607  CG  PRO A  85      26.227 -20.145  14.578  1.00 13.97           C  
ATOM    608  CD  PRO A  85      27.485 -19.770  13.856  1.00 12.73           C  
ATOM    609  N   ALA A  86      26.294 -16.098  13.411  1.00 12.52           N  
ATOM    610  CA  ALA A  86      26.147 -14.632  13.425  1.00 12.25           C  
ATOM    611  C   ALA A  86      25.987 -14.019  12.037  1.00 11.58           C  
ATOM    612  O   ALA A  86      25.545 -12.877  11.915  1.00 12.16           O  
ATOM    613  CB  ALA A  86      27.320 -13.983  14.158  1.00 12.44           C  
ATOM    614  N   PHE A  87      26.347 -14.783  11.003  1.00 10.45           N  
ATOM    615  CA  PHE A  87      26.311 -14.303   9.614  1.00  9.91           C  
ATOM    616  C   PHE A  87      25.483 -15.190   8.706  1.00  9.11           C  
ATOM    617  O   PHE A  87      25.617 -15.143   7.478  1.00  8.99           O  
ATOM    618  CB  PHE A  87      27.739 -14.163   9.082  1.00  9.75           C  
ATOM    619  CG  PHE A  87      28.648 -13.480  10.055  1.00 10.67           C  
ATOM    620  CD1 PHE A  87      28.443 -12.146  10.408  1.00 12.63           C  
ATOM    621  CD2 PHE A  87      29.643 -14.195  10.688  1.00 11.81           C  
ATOM    622  CE1 PHE A  87      29.253 -11.529  11.364  1.00 13.02           C  
ATOM    623  CE2 PHE A  87      30.459 -13.577  11.637  1.00 13.06           C  
ATOM    624  CZ  PHE A  87      30.257 -12.245  11.963  1.00 13.42           C  
ATOM    625  N   SER A  88      24.618 -15.988   9.332  1.00  9.50           N  
ATOM    626  CA  SER A  88      23.764 -16.937   8.626  1.00  9.78           C  
ATOM    627  C   SER A  88      22.600 -16.234   7.902  1.00  9.08           C  
ATOM    628  O   SER A  88      22.394 -15.013   8.025  1.00  8.46           O  
ATOM    629  CB  SER A  88      23.198 -17.940   9.621  1.00 10.33           C  
ATOM    630  OG  SER A  88      22.220 -17.342  10.443  1.00 12.56           O  
ATOM    631  N   THR A  89      21.837 -17.021   7.147  1.00  9.54           N  
ATOM    632  CA  THR A  89      20.667 -16.508   6.449  1.00 10.48           C  
ATOM    633  C   THR A  89      19.501 -16.210   7.383  1.00 11.01           C  
ATOM    634  O   THR A  89      18.522 -15.588   6.969  1.00 11.02           O  
ATOM    635  CB  THR A  89      20.199 -17.442   5.315  1.00 10.45           C  
ATOM    636  OG1 THR A  89      20.008 -18.769   5.822  1.00 13.43           O  
ATOM    637  CG2 THR A  89      21.218 -17.468   4.179  1.00 11.31           C  
ATOM    638  N   ARG A  90      19.611 -16.650   8.633  1.00 10.98           N  
ATOM    639  CA  ARG A  90      18.672 -16.218   9.671  1.00 11.79           C  
ATOM    640  C   ARG A  90      18.910 -14.749  10.013  1.00 12.16           C  
ATOM    641  O   ARG A  90      17.996 -14.052  10.432  1.00 14.09           O  
ATOM    642  CB  ARG A  90      18.820 -17.097  10.932  1.00 12.18           C  
ATOM    643  N   VAL A  91      20.152 -14.289   9.841  1.00 12.40           N  
ATOM    644  CA  VAL A  91      20.528 -12.901  10.145  1.00 11.61           C  
ATOM    645  C   VAL A  91      20.272 -11.960   8.957  1.00 11.55           C  
ATOM    646  O   VAL A  91      19.672 -10.881   9.116  1.00 11.34           O  
ATOM    647  CB  VAL A  91      21.997 -12.817  10.627  1.00 12.01           C  
ATOM    648  CG1 VAL A  91      22.427 -11.364  10.836  1.00 11.38           C  
ATOM    649  CG2 VAL A  91      22.182 -13.617  11.923  1.00 13.46           C  
ATOM    650  N   LEU A  92      20.738 -12.349   7.775  1.00 10.49           N  
ATOM    651  CA  LEU A  92      20.433 -11.616   6.555  1.00 10.13           C  
ATOM    652  C   LEU A  92      20.205 -12.628   5.449  1.00 10.20           C  
ATOM    653  O   LEU A  92      21.081 -13.446   5.196  1.00 10.43           O  
ATOM    654  CB  LEU A  92      21.580 -10.672   6.162  1.00 10.47           C  
ATOM    655  CG  LEU A  92      21.388  -9.800   4.916  1.00 10.62           C  
ATOM    656  CD1 LEU A  92      20.374  -8.687   5.185  1.00 12.68           C  
ATOM    657  CD2 LEU A  92      22.732  -9.249   4.491  1.00 12.44           C  
ATOM    658  N   PRO A  93      19.029 -12.589   4.788  1.00 10.99           N  
ATOM    659  CA  PRO A  93      18.744 -13.523   3.699  1.00 10.94           C  
ATOM    660  C   PRO A  93      19.760 -13.411   2.539  1.00 10.31           C  
ATOM    661  O   PRO A  93      20.490 -12.397   2.443  1.00 10.05           O  
ATOM    662  CB  PRO A  93      17.334 -13.090   3.224  1.00 11.38           C  
ATOM    663  CG  PRO A  93      16.746 -12.385   4.405  1.00 12.85           C  
ATOM    664  CD  PRO A  93      17.908 -11.659   5.018  1.00 11.33           C  
ATOM    665  N   ALA A  94      19.816 -14.449   1.698  1.00 10.77           N  
ATOM    666  CA  ALA A  94      20.644 -14.447   0.472  1.00 10.61           C  
ATOM    667  C   ALA A  94      20.355 -13.200  -0.366  1.00 11.01           C  
ATOM    668  O   ALA A  94      19.185 -12.911  -0.659  1.00 11.18           O  
ATOM    669  CB  ALA A  94      20.375 -15.698  -0.353  1.00 10.59           C  
ATOM    670  N   GLN A  95      21.412 -12.493  -0.768  1.00 11.03           N  
ATOM    671  CA  GLN A  95      21.264 -11.195  -1.440  1.00 11.79           C  
ATOM    672  C   GLN A  95      21.450 -11.251  -2.960  1.00 12.79           C  
ATOM    673  O   GLN A  95      21.513 -10.196  -3.602  1.00 12.98           O  
ATOM    674  CB  GLN A  95      22.202 -10.147  -0.810  1.00 12.29           C  
ATOM    675  CG  GLN A  95      21.944  -9.889   0.681  1.00 13.45           C  
ATOM    676  CD  GLN A  95      20.630  -9.138   0.951  1.00 13.31           C  
ATOM    677  OE1 GLN A  95      19.707  -9.659   1.608  1.00 14.52           O  
ATOM    678  NE2 GLN A  95      20.528  -7.924   0.417  1.00 13.82           N  
ATOM    679  N   ALA A  96      21.535 -12.445  -3.552  1.00 13.37           N  
ATOM    680  CA  ALA A  96      21.771 -12.527  -5.002  1.00 14.24           C  
ATOM    681  C   ALA A  96      20.695 -11.710  -5.706  1.00 15.32           C  
ATOM    682  O   ALA A  96      19.526 -11.787  -5.330  1.00 16.13           O  
ATOM    683  CB  ALA A  96      21.791 -13.968  -5.485  1.00 14.07           C  
ATOM    684  N   THR A  97      21.114 -10.901  -6.688  1.00 16.22           N  
ATOM    685  CA  THR A  97      20.215  -9.982  -7.412  1.00 16.79           C  
ATOM    686  C   THR A  97      19.513 -10.666  -8.577  1.00 17.26           C  
ATOM    687  CB  THR A  97      20.941  -8.703  -7.952  1.00 17.23           C  
ATOM    688  OG1 THR A  97      21.766  -9.014  -9.094  1.00 19.66           O  
ATOM    689  CG2 THR A  97      21.789  -8.054  -6.872  1.00 17.25           C  
TER     690      THR A  97                                                      
END
MOLECULE T0429_100_176.pdb
ATOM    493  N   ARG   100      33.748 -12.822  13.671  1.00 72.44      A    N  
ATOM    494  CA  ARG   100      34.839 -13.184  12.777  1.00 71.01      A    C  
ATOM    495  CB  ARG   100      36.168 -12.642  13.305  1.00 71.60      A    C  
ATOM    496  CG  ARG   100      37.275 -12.682  12.273  1.00 71.40      A    C  
ATOM    497  CD  ARG   100      38.385 -11.712  12.580  1.00 73.85      A    C  
ATOM    498  NE  ARG   100      38.010 -10.331  12.296  1.00 73.41      A    N  
ATOM    499  CZ  ARG   100      38.795  -9.285  12.528  1.00 75.14      A    C  
ATOM    500  NH1 ARG   100      38.373  -8.063  12.255  1.00 75.99      A    N  
ATOM    501  NH2 ARG   100      40.004  -9.457  13.035  1.00 80.38      A    N  
ATOM    502  C   ARG   100      34.921 -14.695  12.550  1.00 71.83      A    C  
ATOM    503  O   ARG   100      34.724 -15.474  13.472  1.00 75.13      A    O  
ATOM    504  N   ALA   101      35.185 -15.103  11.312  1.00 71.01      A    N  
ATOM    505  CA  ALA   101      35.329 -16.525  10.994  1.00 72.17      A    C  
ATOM    506  CB  ALA   101      35.429 -16.722   9.503  1.00 68.85      A    C  
ATOM    507  C   ALA   101      36.552 -17.119  11.710  1.00 75.15      A    C  
ATOM    508  O   ALA   101      37.615 -16.494  11.754  1.00 76.06      A    O  
ATOM    509  N   ARG   102      36.393 -18.307  12.292  1.00 77.04      A    N  
ATOM    510  CA  ARG   102      37.495 -18.945  13.018  1.00 80.24      A    C  
ATOM    511  CB  ARG   102      37.422 -18.649  14.532  1.00 84.15      A    C  
ATOM    512  CG  ARG   102      36.203 -19.204  15.271  1.00 87.78      A    C  
ATOM    513  CD  ARG   102      36.375 -19.083  16.790  1.00 94.35      A    C  
ATOM    514  NE  ARG   102      35.293 -19.729  17.539  1.00100.75      A    N  
ATOM    515  CZ  ARG   102      35.301 -21.003  17.926  1.00102.53      A    C  
ATOM    518  C   ARG   102      37.656 -20.449  12.745  1.00 80.42      A    C  
ATOM    519  O   ARG   102      38.732 -21.007  12.968  1.00 82.56      A    O  
ATOM    520  N   THR   103      36.603 -21.092  12.243  1.00 78.34      A    N  
ATOM    521  CA  THR   103      36.599 -22.546  12.083  1.00 78.04      A    C  
ATOM    522  CB  THR   103      35.419 -23.186  12.852  1.00 80.45      A    C  
ATOM    523  OG1 THR   103      35.405 -22.698  14.199  1.00 83.17      A    O  
ATOM    524  CG2 THR   103      35.535 -24.702  12.867  1.00 81.05      A    C  
ATOM    525  C   THR   103      36.580 -22.993  10.620  1.00 74.75      A    C  
ATOM    526  O   THR   103      35.704 -22.597   9.843  1.00 72.85      A    O  
ATOM    527  N   ILE   104      37.563 -23.816  10.260  1.00 74.51      A    N  
ATOM    528  CA  ILE   104      37.632 -24.436   8.939  1.00 71.52      A    C  
ATOM    529  CB  ILE   104      39.104 -24.721   8.524  1.00 72.44      A    C  
ATOM    530  CG1 ILE   104      39.888 -23.415   8.327  1.00 72.05      A    C  
ATOM    531  CD1 ILE   104      39.530 -22.634   7.057  1.00 70.80      A    C  
ATOM    532  CG2 ILE   104      39.176 -25.610   7.273  1.00 71.84      A    C  
ATOM    533  C   ILE   104      36.840 -25.745   8.930  1.00 72.09      A    C  
ATOM    534  O   ILE   104      37.025 -26.603   9.804  1.00 75.02      A    O  
ATOM    535  N   ILE   105      35.952 -25.885   7.951  1.00 69.18      A    N  
ATOM    536  CA  ILE   105      35.303 -27.162   7.691  1.00 69.78      A    C  
ATOM    537  CB  ILE   105      33.883 -26.988   7.109  1.00 68.99      A    C  
ATOM    538  CG1 ILE   105      33.034 -26.087   8.021  1.00 70.06      A    C  
ATOM    539  CD1 ILE   105      31.766 -25.553   7.376  1.00 68.53      A    C  
ATOM    540  CG2 ILE   105      33.218 -28.359   6.902  1.00 69.89      A    C  
ATOM    541  C   ILE   105      36.177 -27.947   6.721  1.00 69.20      A    C  
ATOM    542  O   ILE   105      36.321 -27.559   5.557  1.00 67.81      A    O  
ATOM    543  N   LYS   106      36.768 -29.036   7.213  1.00 71.18      A    N  
ATOM    544  CA  LYS   106      37.645 -29.901   6.409  1.00 71.31      A    C  
ATOM    545  CB  LYS   106      38.240 -31.027   7.268  1.00 74.66      A    C  
ATOM    546  CG  LYS   106      39.235 -30.553   8.327  1.00 78.99      A    C  
ATOM    547  CD  LYS   106      39.729 -31.711   9.190  1.00 83.40      A    C  
ATOM    550  C   LYS   106      36.906 -30.487   5.204  1.00 68.56      A    C  
ATOM    551  O   LYS   106      35.686 -30.651   5.238  1.00 67.81      A    O  
ATOM    552  N   TRP   107      37.645 -30.803   4.143  1.00 67.47      A    N  
ATOM    553  CA  TRP   107      37.031 -31.309   2.911  1.00 66.13      A    C  
ATOM    554  CB  TRP   107      38.099 -31.666   1.875  1.00 65.53      A    C  
ATOM    555  CG  TRP   107      37.617 -32.592   0.793  1.00 64.63      A    C  
ATOM    556  CD1 TRP   107      37.749 -33.948   0.764  1.00 64.45      A    C  
ATOM    557  NE1 TRP   107      37.178 -34.455  -0.377  1.00 65.36      A    N  
ATOM    558  CE2 TRP   107      36.661 -33.425  -1.117  1.00 63.71      A    C  
ATOM    559  CD2 TRP   107      36.913 -32.231  -0.408  1.00 63.14      A    C  
ATOM    560  CE3 TRP   107      36.481 -31.017  -0.957  1.00 60.76      A    C  
ATOM    561  CZ3 TRP   107      35.822 -31.035  -2.188  1.00 63.26      A    C  
ATOM    562  CH2 TRP   107      35.583 -32.242  -2.864  1.00 62.56      A    C  
ATOM    563  CZ2 TRP   107      35.996 -33.441  -2.350  1.00 63.71      A    C  
ATOM    564  C   TRP   107      36.088 -32.487   3.158  1.00 68.02      A    C  
ATOM    565  O   TRP   107      35.038 -32.587   2.516  1.00 67.19      A    O  
ATOM    566  N   GLN   108      36.462 -33.367   4.090  1.00 81.54      A    N  
ATOM    567  CA  GLN   108      35.651 -34.544   4.428  1.00 86.61      A    C  
ATOM    568  CB  GLN   108      36.355 -35.444   5.453  1.00 94.14      A    C  
ATOM    569  CG  GLN   108      37.838 -35.684   5.202  1.00100.96      A    C  
ATOM    570  CD  GLN   108      38.722 -34.745   6.006  1.00102.76      A    C  
ATOM    571  OE1 GLN   108      39.223 -33.746   5.486  1.00 97.70      A    O  
ATOM    572  NE2 GLN   108      38.908 -35.060   7.288  1.00109.40      A    N  
ATOM    573  C   GLN   108      34.288 -34.148   4.977  1.00 84.65      A    C  
ATOM    574  O   GLN   108      33.279 -34.788   4.683  1.00 85.99      A    O  
ATOM    575  N   ASP   109      34.272 -33.087   5.776  1.00 83.07      A    N  
ATOM    576  CA  ASP   109      33.076 -32.667   6.485  1.00 82.93      A    C  
ATOM    577  CB  ASP   109      33.458 -32.054   7.837  1.00 85.14      A    C  
ATOM    578  CG  ASP   109      33.997 -33.091   8.823  1.00 92.55      A    C  
ATOM    579  OD1 ASP   109      33.546 -34.258   8.794  1.00 96.19      A    O  
ATOM    580  OD2 ASP   109      34.871 -32.738   9.637  1.00 95.06      A    O  
ATOM    581  C   ASP   109      32.200 -31.720   5.661  1.00 77.96      A    C  
ATOM    582  O   ASP   109      31.094 -31.376   6.079  1.00 78.84      A    O  
ATOM    583  N   LEU   110      32.685 -31.320   4.488  1.00 74.26      A    N  
ATOM    584  CA  LEU   110      31.899 -30.489   3.577  1.00 70.92      A    C  
ATOM    585  CB  LEU   110      32.768 -29.936   2.443  1.00 67.27      A    C  
ATOM    586  CG  LEU   110      33.781 -28.845   2.798  1.00 65.09      A    C  
ATOM    587  CD1 LEU   110      34.700 -28.569   1.631  1.00 63.20      A    C  
ATOM    588  CD2 LEU   110      33.085 -27.570   3.234  1.00 62.99      A    C  
ATOM    589  C   LEU   110      30.732 -31.285   3.010  1.00 73.58      A    C  
ATOM    590  O   LEU   110      30.908 -32.409   2.549  1.00 76.26      A    O  
ATOM    591  N   GLU   111      29.540 -30.700   3.062  1.00 74.24      A    N  
ATOM    592  CA  GLU   111      28.329 -31.373   2.607  1.00 78.02      A    C  
ATOM    593  CB  GLU   111      27.497 -31.848   3.800  1.00 82.71      A    C  
ATOM    594  CG  GLU   111      28.116 -33.011   4.560  1.00 90.53      A    C  
ATOM    595  CD  GLU   111      27.602 -33.126   5.988  1.00 98.41      A    C  
ATOM    596  OE1 GLU   111      26.455 -33.590   6.180  1.00102.57      A    O  
ATOM    597  OE2 GLU   111      28.355 -32.761   6.920  1.00100.99      A    O  
ATOM    598  C   GLU   111      27.490 -30.469   1.715  1.00 76.64      A    C  
ATOM    599  O   GLU   111      27.457 -29.251   1.901  1.00 75.67      A    O  
ATOM    600  N   VAL   112      26.813 -31.083   0.749  1.00 78.34      A    N  
ATOM    601  CA  VAL   112      25.915 -30.384  -0.168  1.00 77.86      A    C  
ATOM    602  CB  VAL   112      25.330 -31.365  -1.218  1.00 81.46      A    C  
ATOM    603  CG1 VAL   112      24.284 -30.689  -2.078  1.00 82.23      A    C  
ATOM    604  CG2 VAL   112      26.442 -31.937  -2.088  1.00 78.08      A    C  
ATOM    605  C   VAL   112      24.794 -29.655   0.586  1.00 80.43      A    C  
ATOM    606  O   VAL   112      24.029 -30.264   1.345  1.00 83.79      A    O  
ATOM    607  N   GLY   113      24.722 -28.342   0.386  1.00 79.05      A    N  
ATOM    608  CA  GLY   113      23.639 -27.542   0.943  1.00 82.32      A    C  
ATOM    609  C   GLY   113      24.029 -26.621   2.082  1.00 81.33      A    C  
ATOM    610  O   GLY   113      23.254 -25.742   2.463  1.00 84.67      A    O  
ATOM    611  N   GLN   114      25.226 -26.827   2.628  1.00 77.51      A    N  
ATOM    612  CA  GLN   114      25.771 -25.961   3.668  1.00 76.18      A    C  
ATOM    613  CB  GLN   114      27.088 -26.527   4.198  1.00 74.01      A    C  
ATOM    614  CG  GLN   114      26.983 -27.842   4.950  1.00 78.35      A    C  
ATOM    615  CD  GLN   114      28.343 -28.391   5.344  1.00 76.40      A    C  
ATOM    616  OE1 GLN   114      29.316 -28.243   4.614  1.00 73.16      A    O  
ATOM    617  NE2 GLN   114      28.412 -29.031   6.502  1.00 82.18      A    N  
ATOM    618  C   GLN   114      26.038 -24.559   3.130  1.00 73.65      A    C  
ATOM    619  O   GLN   114      26.486 -24.404   1.987  1.00 70.71      A    O  
ATOM    620  N   VAL   115      25.760 -23.544   3.949  1.00 75.05      A    N  
ATOM    621  CA  VAL   115      26.222 -22.194   3.640  1.00 72.83      A    C  
ATOM    622  CB  VAL   115      25.147 -21.100   3.813  1.00 76.99      A    C  
ATOM    623  CG1 VAL   115      23.943 -21.419   2.939  1.00 81.10      A    C  
ATOM    624  CG2 VAL   115      24.744 -20.935   5.272  1.00 83.11      A    C  
ATOM    625  C   VAL   115      27.496 -21.896   4.416  1.00 70.02      A    C  
ATOM    626  O   VAL   115      27.543 -21.972   5.652  1.00 71.87      A    O  
ATOM    627  N   VAL   116      28.535 -21.575   3.657  1.00 65.64      A    N  
ATOM    628  CA  VAL   116      29.880 -21.463   4.175  1.00 63.59      A    C  
ATOM    629  CB  VAL   116      30.730 -22.663   3.704  1.00 62.16      A    C  
ATOM    630  CG1 VAL   116      30.220 -23.965   4.306  1.00 63.67      A    C  
ATOM    631  CG2 VAL   116      30.729 -22.751   2.189  1.00 60.61      A    C  
ATOM    632  C   VAL   116      30.519 -20.168   3.671  1.00 62.26      A    C  
ATOM    633  O   VAL   116      29.996 -19.539   2.752  1.00 61.77      A    O  
ATOM    634  N   MET   117      31.639 -19.770   4.276  1.00 61.42      A    N  
ATOM    635  CA  MET   117      32.456 -18.698   3.712  1.00 60.96      A    C  
ATOM    636  CB  MET   117      32.820 -17.642   4.757  1.00 61.90      A    C  
ATOM    637  CG  MET   117      33.221 -16.318   4.116  1.00 62.48      A    C  
ATOM    638  SD  MET   117      33.916 -15.018   5.390  1.00 66.12      A   SE  
ATOM    639  CE  MET   117      35.602 -15.886   5.817  1.00 66.17      A    C  
ATOM    640  C   MET   117      33.716 -19.269   3.064  1.00 58.29      A    C  
ATOM    641  O   MET   117      34.464 -20.014   3.688  1.00 59.06      A    O  
ATOM    642  N   LEU   118      33.946 -18.901   1.812  1.00 57.12      A    N  
ATOM    643  CA  LEU   118      35.039 -19.463   1.034  1.00 56.29      A    C  
ATOM    644  CB  LEU   118      34.557 -20.698   0.265  1.00 56.76      A    C  
ATOM    645  CG  LEU   118      33.252 -20.615  -0.531  1.00 57.64      A    C  
ATOM    646  CD1 LEU   118      33.420 -19.891  -1.874  1.00 59.59      A    C  
ATOM    647  CD2 LEU   118      32.730 -22.021  -0.747  1.00 60.22      A    C  
ATOM    648  C   LEU   118      35.646 -18.452   0.064  1.00 56.96      A    C  
ATOM    649  O   LEU   118      35.047 -17.412  -0.233  1.00 57.12      A    O  
ATOM    650  N   ASN   119      36.832 -18.789  -0.438  1.00 56.86      A    N  
ATOM    651  CA  ASN   119      37.591 -17.907  -1.306  1.00 57.26      A    C  
ATOM    652  CB  ASN   119      39.094 -18.065  -1.047  1.00 58.13      A    C  
ATOM    653  CG  ASN   119      39.881 -16.825  -1.412  1.00 59.37      A    C  
ATOM    654  OD1 ASN   119      40.059 -16.510  -2.592  1.00 52.64      A    O  
ATOM    655  ND2 ASN   119      40.346 -16.097  -0.389  1.00 56.44      A    N  
ATOM    656  C   ASN   119      37.264 -18.177  -2.756  1.00 58.04      A    C  
ATOM    657  O   ASN   119      37.354 -19.312  -3.229  1.00 59.26      A    O  
ATOM    658  N   TYR   120      36.866 -17.127  -3.459  1.00 58.92      A    N  
ATOM    659  CA  TYR   120      36.514 -17.235  -4.856  1.00 58.75      A    C  
ATOM    660  CB  TYR   120      35.028 -17.595  -4.993  1.00 60.08      A    C  
ATOM    661  CG  TYR   120      34.561 -17.864  -6.416  1.00 63.34      A    C  
ATOM    662  CD1 TYR   120      35.007 -18.984  -7.126  1.00 65.99      A    C  
ATOM    663  CE1 TYR   120      34.575 -19.233  -8.437  1.00 67.83      A    C  
ATOM    664  CZ  TYR   120      33.681 -18.356  -9.046  1.00 74.16      A    C  
ATOM    665  OH  TYR   120      33.240 -18.592 -10.343  1.00 80.05      A    O  
ATOM    666  CE2 TYR   120      33.219 -17.243  -8.356  1.00 72.18      A    C  
ATOM    667  CD2 TYR   120      33.662 -17.003  -7.047  1.00 68.44      A    C  
ATOM    668  C   TYR   120      36.837 -15.934  -5.568  1.00 61.83      A    C  
ATOM    669  O   TYR   120      36.938 -14.887  -4.938  1.00 58.65      A    O  
ATOM    670  N   ASN   121      36.987 -16.005  -6.894  1.00 66.19      A    N  
ATOM    671  CA  ASN   121      37.288 -14.834  -7.695  1.00 69.65      A    C  
ATOM    672  CB  ASN   121      38.759 -14.832  -8.091  1.00 71.49      A    C  
ATOM    673  CG  ASN   121      39.213 -13.497  -8.646  1.00 78.45      A    C  
ATOM    674  OD1 ASN   121      38.577 -12.918  -9.538  1.00 85.52      A    O  
ATOM    675  ND2 ASN   121      40.341 -13.013  -8.144  1.00 77.55      A    N  
ATOM    676  C   ASN   121      36.384 -14.766  -8.924  1.00 77.49      A    C  
ATOM    677  O   ASN   121      36.703 -15.335  -9.972  1.00 78.65      A    O  
ATOM    678  N   PRO   122      35.246 -14.063  -8.791  1.00 80.08      A    N  
ATOM    679  CA  PRO   122      34.210 -13.957  -9.812  1.00 86.20      A    C  
ATOM    680  CB  PRO   122      33.292 -12.865  -9.259  1.00 86.42      A    C  
ATOM    681  CG  PRO   122      33.448 -12.974  -7.791  1.00 82.10      A    C  
ATOM    682  CD  PRO   122      34.890 -13.316  -7.567  1.00 76.62      A    C  
ATOM    683  C   PRO   122      34.740 -13.582 -11.205  1.00 95.34      A    C  
ATOM    684  O   PRO   122      34.304 -14.165 -12.200  1.00 98.08      A    O  
ATOM    685  N   ASP   123      35.680 -12.637 -11.255  1.00 98.70      A    N  
ATOM    686  CA  ASP   123      36.210 -12.096 -12.512  1.00107.79      A    C  
ATOM    687  CB  ASP   123      36.952 -10.783 -12.250  1.00110.01      A    C  
ATOM    688  CG  ASP   123      36.012  -9.599 -12.080  1.00113.62      A    C  
ATOM    689  OD1 ASP   123      35.072  -9.457 -12.894  1.00118.87      A    O  
ATOM    690  OD2 ASP   123      36.223  -8.800 -11.140  1.00109.85      A    O  
ATOM    691  C   ASP   123      37.124 -13.073 -13.247  1.00110.22      A    C  
ATOM    692  O   ASP   123      37.163 -13.092 -14.484  1.00119.05      A    O  
ATOM    693  N   ASN   124      37.868 -13.860 -12.472  1.00104.22      A    N  
ATOM    694  CA  ASN   124      38.691 -14.958 -12.984  1.00106.51      A    C  
ATOM    695  CB  ASN   124      40.090 -14.477 -13.400  1.00111.43      A    C  
ATOM    696  CG  ASN   124      40.625 -13.375 -12.508  1.00109.34      A    C  
ATOM    697  OD1 ASN   124      40.850 -12.255 -12.961  1.00114.42      A    O  
ATOM    698  ND2 ASN   124      40.823 -13.685 -11.229  1.00102.69      A    N  
ATOM    699  C   ASN   124      38.754 -16.096 -11.960  1.00 99.63      A    C  
ATOM    700  O   ASN   124      39.585 -16.073 -11.036  1.00 94.87      A    O  
ATOM    701  N   PRO   125      37.834 -17.072 -12.096  1.00 98.76      A    N  
ATOM    702  CA  PRO   125      37.609 -18.161 -11.135  1.00 93.07      A    C  
ATOM    703  CB  PRO   125      36.475 -18.965 -11.787  1.00 95.03      A    C  
ATOM    704  CG  PRO   125      35.763 -17.960 -12.623  1.00100.37      A    C  
ATOM    705  CD  PRO   125      36.874 -17.146 -13.209  1.00104.85      A    C  
ATOM    706  C   PRO   125      38.812 -19.059 -10.845  1.00 92.16      A    C  
ATOM    707  O   PRO   125      38.794 -19.805  -9.862  1.00 88.10      A    O  
ATOM    708  N   LYS   126      39.842 -18.980 -11.681  1.00 97.48      A    N  
ATOM    709  CA  LYS   126      41.031 -19.804 -11.512  1.00 97.83      A    C  
ATOM    710  CB  LYS   126      41.771 -19.925 -12.846  1.00106.86      A    C  
ATOM    711  CG  LYS   126      42.246 -21.332 -13.163  1.00110.33      A    C  
ATOM    712  CD  LYS   126      42.605 -21.471 -14.634  1.00120.99      A    C  
ATOM    715  C   LYS   126      41.958 -19.245 -10.424  1.00 93.86      A    C  
ATOM    716  O   LYS   126      42.812 -19.961  -9.895  1.00 93.82      A    O  
ATOM    717  N   GLU   127      41.772 -17.973 -10.080  1.00 90.96      A    N  
ATOM    718  CA  GLU   127      42.707 -17.271  -9.204  1.00 89.03      A    C  
ATOM    719  CB  GLU   127      43.092 -15.909  -9.803  1.00 93.54      A    C  
ATOM    720  CG  GLU   127      43.371 -15.901 -11.315  1.00103.30      A    C  
ATOM    721  CD  GLU   127      44.637 -16.650 -11.711  1.00110.07      A    C  
ATOM    722  OE1 GLU   127      45.603 -16.662 -10.911  1.00107.71      A    O  
ATOM    723  OE2 GLU   127      44.666 -17.215 -12.835  1.00117.64      A    O  
ATOM    724  C   GLU   127      42.157 -17.070  -7.795  1.00 81.22      A    C  
ATOM    725  O   GLU   127      40.973 -17.283  -7.540  1.00 77.05      A    O  
ATOM    726  N   ARG   128      43.042 -16.663  -6.890  1.00 79.99      A    N  
ATOM    727  CA  ARG   128      42.665 -16.219  -5.550  1.00 75.18      A    C  
ATOM    728  CB  ARG   128      43.931 -15.974  -4.728  1.00 76.60      A    C  
ATOM    729  CG  ARG   128      43.724 -15.886  -3.242  1.00 73.49      A    C  
ATOM    730  CD  ARG   128      44.193 -17.147  -2.542  1.00 75.64      A    C  
ATOM    731  NE  ARG   128      43.646 -17.232  -1.188  1.00 72.47      A    N  
ATOM    732  CZ  ARG   128      43.729 -18.300  -0.402  1.00 70.66      A    C  
ATOM    733  NH1 ARG   128      44.344 -19.402  -0.816  1.00 72.28      A    N  
ATOM    734  NH2 ARG   128      43.187 -18.265   0.806  1.00 68.19      A    N  
ATOM    735  C   ARG   128      41.853 -14.923  -5.645  1.00 73.74      A    C  
ATOM    736  O   ARG   128      42.171 -14.051  -6.458  1.00 78.40      A    O  
ATOM    737  N   GLY   129      40.801 -14.816  -4.832  1.00 68.65      A    N  
ATOM    738  CA  GLY   129      39.968 -13.607  -4.753  1.00 67.08      A    C  
ATOM    739  C   GLY   129      39.572 -13.235  -3.324  1.00 63.44      A    C  
ATOM    740  O   GLY   129      40.431 -13.034  -2.461  1.00 62.31      A    O  
ATOM    741  N   PHE   130      38.265 -13.163  -3.078  1.00 61.38      A    N  
ATOM    742  CA  PHE   130      37.728 -12.673  -1.812  1.00 59.66      A    C  
ATOM    743  CB  PHE   130      36.996 -11.352  -2.025  1.00 63.17      A    C  
ATOM    744  CG  PHE   130      37.902 -10.225  -2.408  1.00 68.02      A    C  
ATOM    745  CD1 PHE   130      38.714  -9.614  -1.451  1.00 66.81      A    C  
ATOM    746  CE1 PHE   130      39.567  -8.575  -1.803  1.00 70.40      A    C  
ATOM    747  CZ  PHE   130      39.615  -8.142  -3.122  1.00 73.35      A    C  
ATOM    748  CE2 PHE   130      38.814  -8.750  -4.085  1.00 74.05      A    C  
ATOM    749  CD2 PHE   130      37.966  -9.788  -3.726  1.00 69.66      A    C  
ATOM    750  C   PHE   130      36.801 -13.666  -1.143  1.00 57.34      A    C  
ATOM    751  O   PHE   130      36.334 -14.608  -1.796  1.00 55.77      A    O  
ATOM    752  N   TRP   131      36.561 -13.442   0.159  1.00 49.70      A    N  
ATOM    753  CA  TRP   131      35.706 -14.272   0.989  1.00 51.23      A    C  
ATOM    754  CB  TRP   131      36.162 -14.149   2.445  1.00 50.95      A    C  
ATOM    755  CG  TRP   131      37.572 -14.545   2.508  1.00 47.90      A    C  
ATOM    756  CD1 TRP   131      38.665 -13.738   2.335  1.00 46.38      A    C  
ATOM    757  NE1 TRP   131      39.818 -14.490   2.399  1.00 43.72      A    N  
ATOM    758  CE2 TRP   131      39.480 -15.811   2.579  1.00 43.47      A    C  
ATOM    759  CD2 TRP   131      38.070 -15.884   2.632  1.00 47.54      A    C  
ATOM    760  CE3 TRP   131      37.460 -17.139   2.809  1.00 50.34      A    C  
ATOM    761  CZ3 TRP   131      38.272 -18.267   2.948  1.00 49.31      A    C  
ATOM    762  CH2 TRP   131      39.676 -18.159   2.898  1.00 47.35      A    C  
ATOM    763  CZ2 TRP   131      40.296 -16.946   2.703  1.00 45.25      A    C  
ATOM    764  C   TRP   131      34.214 -13.976   0.855  1.00 56.74      A    C  
ATOM    765  O   TRP   131      33.694 -13.045   1.493  1.00 58.95      A    O  
ATOM    766  N   TYR   132      33.546 -14.787   0.027  1.00 57.70      A    N  
ATOM    767  CA  TYR   132      32.093 -14.756  -0.155  1.00 62.06      A    C  
ATOM    768  CB  TYR   132      31.738 -14.902  -1.640  1.00 64.36      A    C  
ATOM    769  CG  TYR   132      32.346 -13.845  -2.512  1.00 66.16      A    C  
ATOM    770  CD1 TYR   132      31.693 -12.636  -2.724  1.00 69.59      A    C  
ATOM    771  CE1 TYR   132      32.252 -11.656  -3.516  1.00 70.75      A    C  
ATOM    772  CZ  TYR   132      33.480 -11.880  -4.109  1.00 68.34      A    C  
ATOM    773  OH  TYR   132      34.038 -10.905  -4.903  1.00 72.83      A    O  
ATOM    774  CE2 TYR   132      34.149 -13.073  -3.917  1.00 64.55      A    C  
ATOM    775  CD2 TYR   132      33.579 -14.048  -3.122  1.00 64.03      A    C  
ATOM    776  C   TYR   132      31.413 -15.900   0.577  1.00 61.98      A    C  
ATOM    777  O   TYR   132      32.010 -16.959   0.773  1.00 60.18      A    O  
ATOM    778  N   ASP   133      30.155 -15.686   0.959  1.00 64.85      A    N  
ATOM    779  CA  ASP   133      29.273 -16.783   1.352  1.00 65.55      A    C  
ATOM    780  CB  ASP   133      28.057 -16.258   2.099  1.00 68.42      A    C  
ATOM    781  CG  ASP   133      28.402 -15.750   3.477  1.00 69.42      A    C  
ATOM    782  OD1 ASP   133      29.599 -15.713   3.823  1.00 64.53      A    O  
ATOM    783  OD2 ASP   133      27.468 -15.378   4.215  1.00 76.31      A    O  
ATOM    784  C   ASP   133      28.823 -17.591   0.136  1.00 66.63      A    C  
ATOM    785  O   ASP   133      28.615 -17.038  -0.950  1.00 67.26      A    O  
ATOM    786  N   ALA   134      28.668 -18.897   0.333  1.00 65.82      A    N  
ATOM    787  CA  ALA   134      28.311 -19.804  -0.745  1.00 67.57      A    C  
ATOM    788  CB  ALA   134      29.558 -20.239  -1.510  1.00 64.02      A    C  
ATOM    789  C   ALA   134      27.558 -21.022  -0.232  1.00 69.20      A    C  
ATOM    790  O   ALA   134      27.790 -21.492   0.884  1.00 68.34      A    O  
ATOM    791  N   GLU   135      26.655 -21.525  -1.066  1.00 72.04      A    N  
ATOM    792  CA  GLU   135      25.925 -22.744  -0.785  1.00 72.93      A    C  
ATOM    793  CB  GLU   135      24.484 -22.591  -1.263  1.00 77.11      A    C  
ATOM    794  CG  GLU   135      23.524 -23.682  -0.821  1.00 78.37      A    C  
ATOM    795  CD  GLU   135      22.088 -23.368  -1.212  1.00 84.76      A    C  
ATOM    796  OE1 GLU   135      21.844 -23.039  -2.399  1.00 85.93      A    O  
ATOM    797  OE2 GLU   135      21.203 -23.447  -0.328  1.00 88.15      A    O  
ATOM    798  C   GLU   135      26.616 -23.878  -1.529  1.00 71.76      A    C  
ATOM    799  O   GLU   135      26.707 -23.854  -2.758  1.00 73.06      A    O  
ATOM    800  N   ILE   136      27.121 -24.862  -0.792  1.00 69.88      A    N  
ATOM    801  CA  ILE   136      27.764 -26.015  -1.425  1.00 68.91      A    C  
ATOM    802  CB  ILE   136      28.472 -26.926  -0.400  1.00 67.43      A    C  
ATOM    803  CG1 ILE   136      29.694 -26.201   0.170  1.00 62.29      A    C  
ATOM    804  CD1 ILE   136      29.976 -26.548   1.601  1.00 63.43      A    C  
ATOM    805  CG2 ILE   136      28.913 -28.244  -1.043  1.00 67.94      A    C  
ATOM    806  C   ILE   136      26.741 -26.759  -2.275  1.00 72.33      A    C  
ATOM    807  O   ILE   136      25.671 -27.145  -1.795  1.00 74.69      A    O  
ATOM    808  N   SER   137      27.080 -26.921  -3.548  1.00 72.39      A    N  
ATOM    809  CA  SER   137      26.134 -27.344  -4.560  1.00 76.27      A    C  
ATOM    810  CB  SER   137      26.209 -26.382  -5.745  1.00 76.90      A    C  
ATOM    811  OG  SER   137      25.221 -26.684  -6.705  1.00 82.68      A    O  
ATOM    812  C   SER   137      26.401 -28.785  -5.001  1.00 77.57      A    C  
ATOM    813  O   SER   137      25.517 -29.638  -4.931  1.00 79.63      A    O  
ATOM    814  N   ARG   138      27.628 -29.038  -5.451  1.00 76.31      A    N  
ATOM    815  CA  ARG   138      28.067 -30.361  -5.869  1.00 77.35      A    C  
ATOM    816  CB  ARG   138      28.178 -30.448  -7.393  1.00 79.55      A    C  
ATOM    817  CG  ARG   138      26.877 -30.215  -8.119  1.00 85.11      A    C  
ATOM    818  CD  ARG   138      26.947 -30.659  -9.564  1.00 89.42      A    C  
ATOM    819  NE  ARG   138      27.580 -29.666 -10.429  1.00 89.97      A    N  
ATOM    820  CZ  ARG   138      28.649 -29.898 -11.183  1.00 89.04      A    C  
ATOM    821  NH1 ARG   138      29.145 -28.930 -11.941  1.00 88.78      A    N  
ATOM    822  NH2 ARG   138      29.218 -31.098 -11.191  1.00 89.11      A    N  
ATOM    823  C   ARG   138      29.419 -30.657  -5.251  1.00 74.79      A    C  
ATOM    824  O   ARG   138      30.264 -29.765  -5.126  1.00 71.88      A    O  
ATOM    825  N   LYS   139      29.613 -31.914  -4.866  1.00 75.98      A    N  
ATOM    826  CA  LYS   139      30.874 -32.372  -4.306  1.00 74.86      A    C  
ATOM    827  CB  LYS   139      30.779 -32.469  -2.782  1.00 73.48      A    C  
ATOM    828  CG  LYS   139      32.087 -32.834  -2.115  1.00 71.58      A    C  
ATOM    829  CD  LYS   139      31.904 -32.996  -0.626  1.00 72.19      A    C  
ATOM    830  CE  LYS   139      33.155 -33.579  -0.006  1.00 72.78      A    C  
ATOM    831  NZ  LYS   139      32.987 -33.821   1.453  1.00 73.28      A    N  
ATOM    832  C   LYS   139      31.272 -33.712  -4.933  1.00 77.81      A    C  
ATOM    833  O   LYS   139      30.529 -34.697  -4.856  1.00 79.78      A    O  
ATOM    834  N   ARG   140      32.446 -33.724  -5.561  1.00 77.81      A    N  
ATOM    835  CA  ARG   140      32.943 -34.878  -6.310  1.00 80.86      A    C  
ATOM    836  CB  ARG   140      32.831 -34.614  -7.815  1.00 83.30      A    C  
ATOM    837  CG  ARG   140      31.731 -35.391  -8.524  1.00 91.05      A    C  
ATOM    838  CD  ARG   140      32.212 -36.778  -8.943  1.00 96.65      A    C  
ATOM    839  NE  ARG   140      33.416 -36.699  -9.771  1.00 98.96      A    N  
ATOM    840  CZ  ARG   140      33.469 -36.995 -11.067  1.00103.38      A    C  
ATOM    841  NH1 ARG   140      32.384 -37.411 -11.709  1.00108.22      A    N  
ATOM    842  NH2 ARG   140      34.617 -36.887 -11.723  1.00103.90      A    N  
ATOM    843  C   ARG   140      34.393 -35.183  -5.967  1.00 79.17      A    C  
ATOM    844  O   ARG   140      35.221 -34.279  -5.877  1.00 76.53      A    O  
ATOM    845  N   GLU   141      34.702 -36.461  -5.784  1.00 80.97      A    N  
ATOM    846  CA  GLU   141      36.079 -36.872  -5.552  1.00 80.09      A    C  
ATOM    847  CB  GLU   141      36.318 -37.213  -4.081  1.00 78.65      A    C  
ATOM    848  CG  GLU   141      37.779 -37.137  -3.680  1.00 78.55      A    C  
ATOM    849  CD  GLU   141      38.015 -37.247  -2.182  1.00 77.93      A    C  
ATOM    850  OE1 GLU   141      37.038 -37.196  -1.405  1.00 78.44      A    O  
ATOM    851  OE2 GLU   141      39.194 -37.383  -1.781  1.00 77.29      A    O  
ATOM    852  C   GLU   141      36.508 -38.020  -6.465  1.00 83.79      A    C  
ATOM    853  O   GLU   141      35.761 -38.959  -6.720  1.00 86.12      A    O  
ATOM    854  N   THR   142      37.732 -37.899  -6.956  1.00 63.92      A    N  
ATOM    855  CA  THR   142      38.372 -38.851  -7.848  1.00 63.74      A    C  
ATOM    856  CB  THR   142      38.654 -38.156  -9.215  1.00 66.30      A    C  
ATOM    857  OG1 THR   142      37.666 -38.567 -10.168  1.00 66.73      A    O  
ATOM    858  CG2 THR   142      40.026 -38.473  -9.776  1.00 71.31      A    C  
ATOM    859  C   THR   142      39.630 -39.330  -7.117  1.00 63.29      A    C  
ATOM    860  O   THR   142      39.944 -38.823  -6.025  1.00 64.51      A    O  
ATOM    861  N   ARG   143      40.326 -40.317  -7.675  1.00 63.14      A    N  
ATOM    862  CA  ARG   143      41.597 -40.770  -7.109  1.00 63.64      A    C  
ATOM    863  CB  ARG   143      42.221 -41.858  -7.977  1.00 64.32      A    C  
ATOM    864  CG  ARG   143      41.596 -43.245  -7.869  1.00 64.07      A    C  
ATOM    865  CD  ARG   143      42.347 -44.211  -8.831  1.00 64.06      A    C  
ATOM    866  NE  ARG   143      41.787 -45.568  -8.930  1.00 62.34      A    N  
ATOM    867  CZ  ARG   143      41.671 -46.437  -7.915  1.00 62.98      A    C  
ATOM    868  NH1 ARG   143      42.045 -46.114  -6.669  1.00 52.94      A    N  
ATOM    869  NH2 ARG   143      41.163 -47.643  -8.148  1.00 61.64      A    N  
ATOM    870  C   ARG   143      42.601 -39.619  -6.916  1.00 65.93      A    C  
ATOM    871  O   ARG   143      43.346 -39.596  -5.929  1.00 67.55      A    O  
ATOM    872  N   THR   144      42.601 -38.666  -7.848  1.00 67.27      A    N  
ATOM    873  CA  THR   144      43.565 -37.562  -7.855  1.00 71.21      A    C  
ATOM    874  CB  THR   144      44.425 -37.591  -9.130  1.00 74.46      A    C  
ATOM    875  OG1 THR   144      43.566 -37.704 -10.270  1.00 74.50      A    O  
ATOM    876  CG2 THR   144      45.397 -38.767  -9.108  1.00 73.69      A    C  
ATOM    877  C   THR   144      42.938 -36.165  -7.756  1.00 73.03      A    C  
ATOM    878  O   THR   144      43.651 -35.186  -7.568  1.00 77.46      A    O  
ATOM    879  N   ALA   145      41.617 -36.073  -7.882  1.00 71.51      A    N  
ATOM    880  CA  ALA   145      40.935 -34.776  -7.947  1.00 73.21      A    C  
ATOM    881  CB  ALA   145      40.374 -34.544  -9.350  1.00 74.63      A    C  
ATOM    882  C   ALA   145      39.825 -34.619  -6.906  1.00 70.73      A    C  
ATOM    883  O   ALA   145      39.049 -35.544  -6.667  1.00 68.81      A    O  
ATOM    884  N   ARG   146      39.765 -33.441  -6.291  1.00 72.52      A    N  
ATOM    885  CA  ARG   146      38.660 -33.067  -5.401  1.00 71.12      A    C  
ATOM    886  CB  ARG   146      39.164 -32.716  -4.001  1.00 70.21      A    C  
ATOM    887  CG  ARG   146      39.659 -33.912  -3.215  1.00 70.44      A    C  
ATOM    888  CD  ARG   146      40.246 -33.502  -1.882  1.00 72.19      A    C  
ATOM    889  NE  ARG   146      41.331 -32.537  -2.043  1.00 76.34      A    N  
ATOM    890  CZ  ARG   146      41.717 -31.677  -1.105  1.00 79.37      A    C  
ATOM    891  NH1 ARG   146      41.109 -31.647   0.073  1.00 79.76      A    N  
ATOM    892  NH2 ARG   146      42.708 -30.834  -1.349  1.00 84.02      A    N  
ATOM    893  C   ARG   146      37.908 -31.892  -6.008  1.00 72.38      A    C  
ATOM    894  O   ARG   146      38.483 -30.830  -6.257  1.00 76.52      A    O  
ATOM    895  N   GLU   147      36.620 -32.088  -6.255  1.00 70.89      A    N  
ATOM    896  CA  GLU   147      35.828 -31.092  -6.962  1.00 72.27      A    C  
ATOM    897  CB  GLU   147      35.261 -31.688  -8.251  1.00 73.83      A    C  
ATOM    898  CG  GLU   147      36.336 -32.129  -9.238  1.00 78.97      A    C  
ATOM    899  CD  GLU   147      35.844 -33.164 -10.233  1.00 82.68      A    C  
ATOM    900  OE1 GLU   147      34.708 -33.023 -10.738  1.00 85.63      A    O  
ATOM    901  OE2 GLU   147      36.602 -34.121 -10.510  1.00 83.65      A    O  
ATOM    902  C   GLU   147      34.718 -30.537  -6.081  1.00 69.40      A    C  
ATOM    903  O   GLU   147      33.914 -31.289  -5.531  1.00 67.18      A    O  
ATOM    904  N   LEU   148      34.692 -29.215  -5.949  1.00 69.74      A    N  
ATOM    905  CA  LEU   148      33.662 -28.544  -5.175  1.00 67.30      A    C  
ATOM    906  CB  LEU   148      34.243 -27.963  -3.884  1.00 66.54      A    C  
ATOM    907  CG  LEU   148      33.276 -27.429  -2.823  1.00 64.58      A    C  
ATOM    908  CD1 LEU   148      32.415 -28.550  -2.267  1.00 59.27      A    C  
ATOM    909  CD2 LEU   148      34.048 -26.727  -1.710  1.00 63.81      A    C  
ATOM    910  C   LEU   148      32.982 -27.463  -6.002  1.00 70.05      A    C  
ATOM    911  O   LEU   148      33.641 -26.629  -6.631  1.00 72.97      A    O  
ATOM    912  N   TYR   149      31.654 -27.507  -6.004  1.00 69.71      A    N  
ATOM    913  CA  TYR   149      30.842 -26.527  -6.707  1.00 71.79      A    C  
ATOM    914  CB  TYR   149      30.053 -27.187  -7.847  1.00 74.98      A    C  
ATOM    915  CG  TYR   149      30.963 -27.719  -8.929  1.00 78.32      A    C  
ATOM    916  CD1 TYR   149      31.505 -29.004  -8.844  1.00 76.82      A    C  
ATOM    917  CE1 TYR   149      32.363 -29.492  -9.827  1.00 79.06      A    C  
ATOM    918  CZ  TYR   149      32.694 -28.685 -10.903  1.00 84.35      A    C  
ATOM    919  OH  TYR   149      33.544 -29.160 -11.878  1.00 88.75      A    O  
ATOM    920  CE2 TYR   149      32.173 -27.404 -11.008  1.00 86.90      A    C  
ATOM    921  CD2 TYR   149      31.317 -26.926 -10.020  1.00 83.14      A    C  
ATOM    922  C   TYR   149      29.935 -25.839  -5.704  1.00 69.60      A    C  
ATOM    923  O   TYR   149      29.459 -26.466  -4.757  1.00 67.80      A    O  
ATOM    924  N   ALA   150      29.723 -24.543  -5.896  1.00 70.24      A    N  
ATOM    925  CA  ALA   150      28.964 -23.765  -4.941  1.00 68.76      A    C  
ATOM    926  CB  ALA   150      29.885 -23.235  -3.834  1.00 67.20      A    C  
ATOM    927  C   ALA   150      28.202 -22.625  -5.596  1.00 72.22      A    C  
ATOM    928  O   ALA   150      28.631 -22.069  -6.612  1.00 74.74      A    O  
ATOM    929  N   ASN   151      27.055 -22.303  -5.003  1.00 72.44      A    N  
ATOM    930  CA  ASN   151      26.300 -21.119  -5.350  1.00 76.20      A    C  
ATOM    931  CB  ASN   151      24.810 -21.330  -5.072  1.00 76.85      A    C  
ATOM    932  CG  ASN   151      24.247 -22.554  -5.770  1.00 79.45      A    C  
ATOM    933  OD1 ASN   151      24.580 -22.845  -6.918  1.00 79.71      A    O  
ATOM    934  ND2 ASN   151      23.380 -23.276  -5.073  1.00 80.94      A    N  
ATOM    935  C   ASN   151      26.839 -19.979  -4.507  1.00 76.24      A    C  
ATOM    936  O   ASN   151      26.602 -19.927  -3.295  1.00 75.45      A    O  
ATOM    937  N   VAL   152      27.584 -19.081  -5.143  1.00 79.41      A    N  
ATOM    938  CA  VAL   152      28.259 -17.990  -4.444  1.00 79.50      A    C  
ATOM    939  CB  VAL   152      29.614 -17.661  -5.119  1.00 82.99      A    C  
ATOM    940  CG1 VAL   152      30.288 -16.454  -4.472  1.00 83.32      A    C  
ATOM    941  CG2 VAL   152      30.527 -18.868  -5.071  1.00 80.21      A    C  
ATOM    942  C   VAL   152      27.350 -16.759  -4.391  1.00 82.04      A    C  
ATOM    943  O   VAL   152      26.821 -16.325  -5.418  1.00 85.53      A    O  
ATOM    944  N   VAL   153      27.170 -16.213  -3.190  1.00 80.24      A    N  
ATOM    945  CA  VAL   153      26.318 -15.043  -2.970  1.00 81.79      A    C  
ATOM    946  CB  VAL   153      25.723 -15.040  -1.539  1.00 78.70      A    C  
ATOM    947  CG1 VAL   153      24.841 -13.821  -1.319  1.00 78.84      A    C  
ATOM    948  CG2 VAL   153      24.932 -16.323  -1.290  1.00 76.38      A    C  
ATOM    949  C   VAL   153      27.097 -13.751  -3.232  1.00 86.30      A    C  
ATOM    950  O   VAL   153      28.098 -13.467  -2.562  1.00 86.64      A    O  
ATOM    951  N   LEU   154      26.615 -12.970  -4.199  1.00 90.89      A    N  
ATOM    952  CA  LEU   154      27.335 -11.803  -4.699  1.00 96.61      A    C  
ATOM    953  CB  LEU   154      27.674 -12.010  -6.177  1.00102.18      A    C  
ATOM    954  CG  LEU   154      29.126 -11.829  -6.622  1.00107.79      A    C  
ATOM    955  CD1 LEU   154      29.946 -13.084  -6.325  1.00104.39      A    C  
ATOM    956  CD2 LEU   154      29.195 -11.476  -8.100  1.00115.33      A    C  
ATOM    957  C   LEU   154      26.523 -10.521  -4.528  1.00 98.73      A    C  
ATOM    958  O   LEU   154      26.057 -10.203  -3.430  1.00 95.85      A    O  
ATOM    959  N   ASP   156      20.327  -9.075  -2.880  1.00154.49      A    N  
ATOM    960  CA  ASP   156      21.569  -9.607  -3.441  1.00145.75      A    C  
ATOM    961  CB  ASP   156      22.488 -10.157  -2.331  1.00135.92      A    C  
ATOM    962  CG  ASP   156      21.872 -11.329  -1.568  1.00134.46      A    C  
ATOM    963  OD1 ASP   156      21.793 -12.447  -2.127  1.00132.68      A    O  
ATOM    964  OD2 ASP   156      21.490 -11.137  -0.394  1.00135.89      A    O  
ATOM    965  C   ASP   156      21.316 -10.670  -4.512  1.00145.37      A    C  
ATOM    966  O   ASP   156      20.268 -11.319  -4.518  1.00150.14      A    O  
ATOM    967  N   ASP   157      22.283 -10.837  -5.413  1.00140.52      A    N  
ATOM    968  CA  ASP   157      22.213 -11.861  -6.458  1.00139.58      A    C  
ATOM    969  CB  ASP   157      22.328 -11.238  -7.860  1.00145.97      A    C  
ATOM    970  CG  ASP   157      23.279 -10.046  -7.904  1.00145.70      A    C  
ATOM    971  OD1 ASP   157      22.852  -8.926  -7.545  1.00151.65      A    O  
ATOM    972  OD2 ASP   157      24.446 -10.224  -8.314  1.00140.51      A    O  
ATOM    973  C   ASP   157      23.284 -12.932  -6.249  1.00128.46      A    C  
ATOM    974  O   ASP   157      24.418 -12.619  -5.887  1.00122.38      A    O  
ATOM    975  N   SER   158      22.914 -14.192  -6.468  1.00126.34      A    N  
ATOM    976  CA  SER   158      23.850 -15.305  -6.310  1.00116.90      A    C  
ATOM    977  CB  SER   158      23.222 -16.443  -5.500  1.00115.95      A    C  
ATOM    978  OG  SER   158      22.159 -17.046  -6.211  1.00124.65      A    O  
ATOM    979  C   SER   158      24.386 -15.823  -7.647  1.00115.72      A    C  
ATOM    980  O   SER   158      23.766 -15.637  -8.693  1.00122.87      A    O  
ATOM    981  N   LEU   159      25.543 -16.475  -7.587  1.00107.30      A    N  
ATOM    982  CA  LEU   159      26.252 -16.962  -8.762  1.00105.78      A    C  
ATOM    983  CB  LEU   159      27.643 -16.324  -8.812  1.00100.96      A    C  
ATOM    984  CG  LEU   159      28.366 -16.132 -10.145  1.00104.00      A    C  
ATOM    985  CD2 LEU   159      27.532 -15.316 -11.129  1.00112.58      A    C  
ATOM    987  C   LEU   159      26.341 -18.490  -8.703  1.00102.25      A    C  
ATOM    988  O   LEU   159      27.136 -19.049  -7.948  1.00 95.25      A    O  
ATOM    989  N   ASN   160      25.514 -19.156  -9.504  1.00107.82      A    N  
ATOM    990  CA  ASN   160      25.321 -20.604  -9.394  1.00107.03      A    C  
ATOM    991  CB  ASN   160      23.945 -21.006  -9.941  1.00115.89      A    C  
ATOM    992  CG  ASN   160      22.789 -20.368  -9.174  1.00119.98      A    C  
ATOM    993  OD1 ASN   160      21.844 -19.859  -9.777  1.00128.07      A    O  
ATOM    994  ND2 ASN   160      22.859 -20.395  -7.844  1.00115.38      A    N  
ATOM    995  C   ASN   160      26.406 -21.460 -10.044  1.00103.95      A    C  
ATOM    996  O   ASN   160      26.986 -21.079 -11.064  1.00105.22      A    O  
ATOM    997  N   ASP   161      26.665 -22.614  -9.424  1.00100.72      A    N  
ATOM    998  CA  ASP   161      27.538 -23.670  -9.958  1.00 99.67      A    C  
ATOM    999  CB  ASP   161      26.903 -24.310 -11.206  1.00108.04      A    C  
ATOM   1000  CG  ASP   161      27.456 -25.693 -11.506  1.00109.23      A    C  
ATOM   1001  OD1 ASP   161      27.756 -26.442 -10.547  1.00105.93      A    O  
ATOM   1002  OD2 ASP   161      27.577 -26.033 -12.705  1.00114.11      A    O  
ATOM   1003  C   ASP   161      28.976 -23.220 -10.238  1.00 94.88      A    C  
ATOM   1004  O   ASP   161      29.499 -23.410 -11.340  1.00 97.52      A    O  
ATOM   1005  N   CYS   162      29.608 -22.634  -9.226  1.00 88.51      A    N  
ATOM   1006  CA  CYS   162      30.981 -22.149  -9.332  1.00 85.07      A    C  
ATOM   1007  CB  CYS   162      31.178 -20.924  -8.431  1.00 81.92      A    C  
ATOM   1008  SG  CYS   162      30.225 -19.464  -8.900  1.00 88.32      A    S  
ATOM   1009  C   CYS   162      31.993 -23.225  -8.942  1.00 81.26      A    C  
ATOM   1010  O   CYS   162      31.833 -23.883  -7.913  1.00 79.50      A    O  
ATOM   1011  N   ARG   163      33.041 -23.388  -9.748  1.00 80.96      A    N  
ATOM   1012  CA  ARG   163      34.135 -24.297  -9.403  1.00 78.45      A    C  
ATOM   1013  CB  ARG   163      34.936 -24.699 -10.649  1.00 82.87      A    C  
ATOM   1014  CG  ARG   163      36.139 -25.619 -10.389  1.00 83.57      A    C  
ATOM   1015  CD  ARG   163      35.735 -26.950  -9.752  1.00 86.25      A    C  
ATOM   1016  NE  ARG   163      36.895 -27.771  -9.402  1.00 86.46      A    N  
ATOM   1017  CZ  ARG   163      37.383 -28.758 -10.151  1.00 91.21      A    C  
ATOM   1018  NH1 ARG   163      36.813 -29.077 -11.312  1.00 95.37      A    N  
ATOM   1019  NH2 ARG   163      38.444 -29.439  -9.732  1.00 90.22      A    N  
ATOM   1020  C   ARG   163      35.044 -23.655  -8.359  1.00 73.09      A    C  
ATOM   1021  O   ARG   163      35.798 -22.727  -8.665  1.00 73.28      A    O  
ATOM   1022  N   ILE   164      34.963 -24.155  -7.129  1.00 68.86      A    N  
ATOM   1023  CA  ILE   164      35.743 -23.620  -6.011  1.00 63.46      A    C  
ATOM   1024  CB  ILE   164      34.998 -23.798  -4.656  1.00 61.55      A    C  
ATOM   1025  CG1 ILE   164      33.573 -23.218  -4.724  1.00 60.30      A    C  
ATOM   1026  CD1 ILE   164      33.499 -21.745  -5.097  1.00 60.78      A    C  
ATOM   1027  CG2 ILE   164      35.823 -23.220  -3.477  1.00 57.88      A    C  
ATOM   1028  C   ILE   164      37.130 -24.257  -5.942  1.00 63.17      A    C  
ATOM   1029  O   ILE   164      37.258 -25.473  -5.803  1.00 63.90      A    O  
ATOM   1030  N   ILE   165      38.160 -23.419  -6.033  1.00 63.23      A    N  
ATOM   1031  CA  ILE   165      39.553 -23.873  -6.071  1.00 64.54      A    C  
ATOM   1032  CB  ILE   165      40.486 -22.816  -6.735  1.00 65.87      A    C  
ATOM   1033  CG1 ILE   165      40.033 -22.474  -8.161  1.00 68.67      A    C  
ATOM   1034  CD1 ILE   165      39.820 -23.676  -9.066  1.00 70.55      A    C  
ATOM   1035  CG2 ILE   165      41.943 -23.279  -6.718  1.00 68.94      A    C  
ATOM   1036  C   ILE   165      40.090 -24.196  -4.681  1.00 63.36      A    C  
ATOM   1037  O   ILE   165      40.739 -25.220  -4.487  1.00 65.13      A    O  
ATOM   1038  N   PHE   166      39.808 -23.316  -3.724  1.00 60.96      A    N  
ATOM   1039  CA  PHE   166      40.423 -23.363  -2.391  1.00 61.51      A    C  
ATOM   1040  CB  PHE   166      40.778 -21.947  -1.921  1.00 59.92      A    C  
ATOM   1041  CG  PHE   166      41.515 -21.179  -2.976  1.00 63.59      A    C  
ATOM   1042  CD1 PHE   166      40.831 -20.338  -3.851  1.00 63.67      A    C  
ATOM   1043  CE1 PHE   166      41.500 -19.672  -4.874  1.00 65.74      A    C  
ATOM   1044  CZ  PHE   166      42.863 -19.866  -5.048  1.00 69.84      A    C  
ATOM   1045  CE2 PHE   166      43.555 -20.726  -4.199  1.00 71.18      A    C  
ATOM   1046  CD2 PHE   166      42.875 -21.391  -3.179  1.00 67.07      A    C  
ATOM   1047  C   PHE   166      39.555 -24.164  -1.448  1.00 60.34      A    C  
ATOM   1048  O   PHE   166      38.857 -23.654  -0.577  1.00 59.81      A    O  
ATOM   1049  N   VAL   167      39.639 -25.461  -1.683  1.00 61.90      A    N  
ATOM   1050  CA  VAL   167      38.760 -26.465  -1.138  1.00 62.51      A    C  
ATOM   1051  CB  VAL   167      38.817 -27.678  -2.085  1.00 66.35      A    C  
ATOM   1052  CG1 VAL   167      38.694 -29.004  -1.355  1.00 71.14      A    C  
ATOM   1053  CG2 VAL   167      37.789 -27.517  -3.209  1.00 67.21      A    C  
ATOM   1054  C   VAL   167      39.147 -26.822   0.296  1.00 62.61      A    C  
ATOM   1055  O   VAL   167      38.380 -27.472   1.015  1.00 61.76      A    O  
ATOM   1056  N   ASP   168      40.332 -26.369   0.706  1.00 63.36      A    N  
ATOM   1057  CA  ASP   168      40.879 -26.668   2.024  1.00 65.08      A    C  
ATOM   1058  CB  ASP   168      42.323 -27.177   1.907  1.00 68.67      A    C  
ATOM   1059  CG  ASP   168      42.404 -28.597   1.360  1.00 73.05      A    C  
ATOM   1060  OD1 ASP   168      41.677 -29.482   1.868  1.00 73.62      A    O  
ATOM   1061  OD2 ASP   168      43.199 -28.833   0.422  1.00 74.94      A    O  
ATOM   1062  C   ASP   168      40.810 -25.459   2.946  1.00 63.54      A    C  
ATOM   1063  O   ASP   168      41.340 -25.489   4.062  1.00 66.02      A    O  
ATOM   1064  N   GLU   169      40.141 -24.405   2.482  1.00 60.46      A    N  
ATOM   1065  CA  GLU   169      40.110 -23.134   3.207  1.00 59.46      A    C  
ATOM   1066  CB  GLU   169      40.988 -22.107   2.487  1.00 60.15      A    C  
ATOM   1067  CG  GLU   169      42.468 -22.435   2.516  1.00 60.33      A    C  
ATOM   1068  CD  GLU   169      43.285 -21.528   1.627  1.00 63.26      A    C  
ATOM   1069  OE1 GLU   169      43.919 -20.597   2.166  1.00 63.21      A    O  
ATOM   1070  OE2 GLU   169      43.296 -21.742   0.389  1.00 63.55      A    O  
ATOM   1071  C   GLU   169      38.691 -22.593   3.412  1.00 57.50      A    C  
ATOM   1072  O   GLU   169      38.475 -21.378   3.494  1.00 56.14      A    O  
ATOM   1073  N   VAL   170      37.735 -23.511   3.511  1.00 57.46      A    N  
ATOM   1074  CA  VAL   170      36.325 -23.175   3.636  1.00 56.44      A    C  
ATOM   1075  CB  VAL   170      35.449 -24.277   2.987  1.00 56.48      A    C  
ATOM   1076  CG1 VAL   170      33.980 -24.001   3.212  1.00 55.51      A    C  
ATOM   1077  CG2 VAL   170      35.751 -24.397   1.489  1.00 54.79      A    C  
ATOM   1078  C   VAL   170      35.952 -22.981   5.112  1.00 59.01      A    C  
ATOM   1079  O   VAL   170      36.236 -23.839   5.957  1.00 61.69      A    O  
ATOM   1080  N   PHE   171      35.312 -21.855   5.412  1.00 58.99      A    N  
ATOM   1081  CA  PHE   171      34.969 -21.499   6.783  1.00 61.65      A    C  
ATOM   1082  CB  PHE   171      35.233 -20.014   7.044  1.00 60.78      A    C  
ATOM   1083  CG  PHE   171      36.670 -19.678   7.281  1.00 60.82      A    C  
ATOM   1084  CD1 PHE   171      37.210 -19.739   8.562  1.00 60.71      A    C  
ATOM   1085  CE1 PHE   171      38.544 -19.413   8.789  1.00 60.33      A    C  
ATOM   1086  CZ  PHE   171      39.352 -19.009   7.736  1.00 61.60      A    C  
ATOM   1087  CE2 PHE   171      38.825 -18.946   6.441  1.00 61.24      A    C  
ATOM   1088  CD2 PHE   171      37.487 -19.275   6.224  1.00 60.28      A    C  
ATOM   1089  C   PHE   171      33.524 -21.794   7.147  1.00 64.12      A    C  
ATOM   1090  O   PHE   171      32.615 -21.693   6.314  1.00 64.50      A    O  
ATOM   1091  N   LYS   172      33.339 -22.152   8.413  1.00 77.04      A    N  
ATOM   1092  CA  LYS   172      32.037 -22.227   9.050  1.00 79.53      A    C  
ATOM   1093  CB  LYS   172      32.164 -23.050  10.337  1.00 88.91      A    C  
ATOM   1094  CG  LYS   172      30.940 -23.105  11.231  1.00 93.59      A    C  
ATOM   1095  CD  LYS   172      31.219 -24.011  12.426  1.00105.42      A    C  
ATOM   1096  CE  LYS   172      30.081 -24.008  13.435  1.00111.71      A    C  
ATOM   1097  NZ  LYS   172      30.086 -22.782  14.282  1.00110.49      A    N  
ATOM   1098  C   LYS   172      31.600 -20.804   9.366  1.00 77.33      A    C  
ATOM   1099  O   LYS   172      32.382 -20.015   9.907  1.00 79.81      A    O  
ATOM   1100  N   ILE   173      30.364 -20.468   9.018  1.00 76.02      A    N  
ATOM   1101  CA  ILE   173      29.820 -19.163   9.362  1.00 76.65      A    C  
ATOM   1102  CB  ILE   173      28.692 -18.719   8.397  1.00 76.78      A    C  
ATOM   1103  CG1 ILE   173      29.263 -18.449   7.002  1.00 70.61      A    C  
ATOM   1104  CD1 ILE   173      28.220 -18.403   5.902  1.00 71.51      A    C  
ATOM   1105  CG2 ILE   173      27.983 -17.471   8.924  1.00 81.49      A    C  
ATOM   1106  C   ILE   173      29.330 -19.219  10.805  1.00 83.32      A    C  
ATOM   1107  O   ILE   173      28.477 -20.038  11.153  1.00 87.13      A    O  
ATOM   1108  N   GLU   174      29.896 -18.353  11.639  1.00 86.51      A    N  
ATOM   1109  CA  GLU   174      29.536 -18.283  13.050  1.00 93.69      A    C  
ATOM   1110  CB  GLU   174      30.549 -17.437  13.835  1.00 97.60      A    C  
ATOM   1111  CG  GLU   174      32.024 -17.729  13.538  1.00 98.58      A    C  
ATOM   1112  CD  GLU   174      32.480 -19.103  14.005  1.00103.15      A    C  
ATOM   1113  OE1 GLU   174      32.267 -19.434  15.190  1.00110.24      A    O  
ATOM   1114  OE2 GLU   174      33.069 -19.847  13.186  1.00102.50      A    O  
ATOM   1115  C   GLU   174      28.128 -17.711  13.215  1.00 97.65      A    C  
ATOM   1116  O   GLU   174      27.849 -16.589  12.779  1.00 98.79      A    O  
ATOM   1117  N   ARG   175      27.250 -18.506  13.826  1.00102.48      A    N  
ATOM   1118  CA  ARG   175      25.891 -18.080  14.174  1.00109.50      A    C  
ATOM   1119  CB  ARG   175      24.881 -19.185  13.842  1.00114.39      A    C  
ATOM   1120  CG  ARG   175      24.124 -18.977  12.535  1.00116.97      A    C  
ATOM   1121  CD  ARG   175      24.920 -19.414  11.313  1.00109.78      A    C  
ATOM   1122  NE  ARG   175      24.355 -18.861  10.080  1.00112.40      A    N  
ATOM   1123  CZ  ARG   175      24.629 -19.298   8.851  1.00109.33      A    C  
ATOM   1124  NH1 ARG   175      25.462 -20.318   8.661  1.00103.11      A    N  
ATOM   1125  NH2 ARG   175      24.058 -18.714   7.803  1.00112.61      A    N  
ATOM   1126  C   ARG   175      25.781 -17.680  15.653  1.00114.90      A    C  
ATOM   1127  O   ARG   175      26.443 -18.279  16.504  1.00115.25      A    O  
ATOM   1128  N   PRO   176      24.947 -16.661  15.961  1.00121.13      A    N  
ATOM   1129  CA  PRO   176      24.769 -16.177  17.338  1.00127.15      A    C  
ATOM   1130  CB  PRO   176      23.739 -15.054  17.186  1.00135.40      A    C  
ATOM   1131  CG  PRO   176      23.825 -14.640  15.761  1.00132.78      A    C  
ATOM   1132  CD  PRO   176      24.125 -15.891  15.009  1.00124.80      A    C  
ATOM   1133  C   PRO   176      24.226 -17.248  18.281  1.00131.43      A    C  
ATOM   1134  O   PRO   176      24.738 -17.408  19.389  1.00133.23      A    O  
END
