
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   59 (  465),  selected   59 , name 1mhn_A
# Molecule2: number of CA atoms   76 (  635),  selected   76 , name T0429_100_176.pdb
# PARAMETERS: 1mhn_A.T0429_100_176.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    L    89_A      R     100           -
LGA    -       -      A     101           -
LGA    -       -      R     102           -
LGA    -       -      T     103           -
LGA    -       -      I     104           -
LGA    -       -      I     105           -
LGA    -       -      K     106           -
LGA    Q    90_A      W     107          2.850
LGA    Q    91_A      Q     108          2.402
LGA    -       -      D     109           -
LGA    W    92_A      L     110          0.662
LGA    K    93_A      E     111          0.918
LGA    V    94_A      V     112          0.638
LGA    G    95_A      G     113          0.689
LGA    D    96_A      Q     114          1.458
LGA    K    97_A      V     115          1.687
LGA    C    98_A      V     116          1.303
LGA    S    99_A      M     117          1.428
LGA    A   100_A      L     118          1.607
LGA    I   101_A      N     119          1.700
LGA    W   102_A      Y     120          2.045
LGA    S   103_A      N     121          1.506
LGA    E   104_A      P     122          2.374
LGA    D   105_A      D     123          5.423
LGA    -       -      N     124           -
LGA    -       -      P     125           -
LGA    -       -      K     126           -
LGA    -       -      E     127           -
LGA    -       -      R     128           -
LGA    G   106_A      G     129          1.364
LGA    C   107_A      F     130          1.292
LGA    I   108_A      W     131          0.777
LGA    Y   109_A      Y     132          0.412
LGA    P   110_A      D     133          0.410
LGA    A   111_A      A     134          0.484
LGA    T   112_A      E     135          0.737
LGA    I   113_A      I     136          0.436
LGA    A   114_A      S     137          0.521
LGA    S   115_A      R     138          0.508
LGA    I   116_A      K     139          0.622
LGA    D   117_A      R     140          1.079
LGA    F   118_A      E     141          1.407
LGA    K   119_A      T     142          1.467
LGA    -       -      R     143           -
LGA    -       -      T     144           -
LGA    R   120_A      A     145          2.540
LGA    E   121_A      R     146          0.521
LGA    T   122_A      E     147          1.052
LGA    C   123_A      L     148          1.081
LGA    V   124_A      Y     149          0.643
LGA    V   125_A      A     150          0.571
LGA    V   126_A      N     151          0.448
LGA    Y   127_A      V     152          1.159
LGA    T   128_A      V     153          2.954
LGA    -       -      L     154           -
LGA    G   129_A      D     156          4.480
LGA    Y   130_A      D     157          3.205
LGA    G   131_A      S     158          1.845
LGA    N   132_A      L     159          0.612
LGA    R   133_A      N     160          3.029
LGA    -       -      D     161           -
LGA    E   134_A      C     162          1.107
LGA    E   135_A      R     163          0.456
LGA    Q   136_A      I     164          1.174
LGA    N   137_A      I     165          3.612
LGA    L   138_A      F     166           #
LGA    S   139_A      V     167          2.595
LGA    D   140_A      D     168          3.848
LGA    L   141_A      E     169          4.152
LGA    L   142_A      V     170          1.522
LGA    S   143_A      F     171          0.824
LGA    P   144_A      K     172          3.159
LGA    I   145_A      I     173          2.793
LGA    C   146_A      E     174           -
LGA    E   147_A      R     175           -
LGA    -       -      P     176           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   59   76    5.0     55    2.01    18.18     61.378     2.607

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.006654 * X  +  -0.448808 * Y  +   0.893604 * Z  +  26.662544
  Y_new =   0.258786 * X  +   0.862407 * Y  +   0.435067 * Z  + -15.427459
  Z_new =  -0.965912 * X  +   0.234147 * Y  +   0.110407 * Z  +  -0.594404 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.130184   -2.011409  [ DEG:    64.7548   -115.2452 ]
  Theta =   1.308942    1.832650  [ DEG:    74.9969    105.0031 ]
  Phi   =   1.596502   -1.545091  [ DEG:    91.4728    -88.5272 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1mhn_A                                        
REMARK     2: T0429_100_176.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1mhn_A.T0429_100_176.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   59   76   5.0   55   2.01   18.18  61.378
REMARK  ---------------------------------------------------------- 
MOLECULE 1mhn_A
HEADER    RNA BINDING PROTEIN                     20-AUG-02   1MHN              
TITLE     HIGH RESOLUTION CRYSTAL STRUCTURE OF THE SMN TUDOR DOMAIN             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SURVIVAL MOTOR NEURON PROTEIN;                             
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: TUDOR DOMAIN;                                              
COMPND   5 SYNONYM: SMN, COMPONENT OF GEMS 1, GEMIN1;                           
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: SMN1;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PET24D (MODIFIED)                     
KEYWDS    SMN, SMA, SPINAL MUSCULAR ATROPHY                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.SPRANGERS,M.R.GROVES,I.SINNING,M.SATTLER                            
REVDAT   1   25-MAR-03 1MHN    0                                                
JRNL        AUTH   R.SPRANGERS,M.R.GROVES,I.SINNING,M.SATTLER                   
JRNL        TITL   HIGH RESOLUTION X-RAY AND NMR STRUCTURES OF THE              
JRNL        TITL 2 SMN TUDOR DOMAIN: CONFORMATIONAL VARIATION IN THE            
JRNL        TITL 3 BINDING SITE FOR SYMMETRICALLY DIMETHYLATED                  
JRNL        TITL 4 ARGININE RESIDUES                                            
JRNL        REF    J.MOL.BIOL.                   V. 327   507 2003              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  1MHN A   89   147  UNP    Q16637   SMN_HUMAN       89    147             
SEQRES   1 A   59  LEU GLN GLN TRP LYS VAL GLY ASP LYS CYS SER ALA ILE          
SEQRES   2 A   59  TRP SER GLU ASP GLY CYS ILE TYR PRO ALA THR ILE ALA          
SEQRES   3 A   59  SER ILE ASP PHE LYS ARG GLU THR CYS VAL VAL VAL TYR          
SEQRES   4 A   59  THR GLY TYR GLY ASN ARG GLU GLU GLN ASN LEU SER ASP          
SEQRES   5 A   59  LEU LEU SER PRO ILE CYS GLU                                  
FORMUL   2  HOH   *65(H2 O)                                                     
CRYST1   27.652   27.652  110.299  90.00  90.00 120.00 P 65          6          
ATOM      1  N   LEU A  89      41.925 -31.216   3.639  1.00 24.98           N  
ATOM      2  CA  LEU A  89      40.495 -31.218   3.280  1.00 24.12           C  
ATOM      3  C   LEU A  89      39.729 -31.242   4.576  1.00 23.96           C  
ATOM      4  O   LEU A  89      40.159 -31.873   5.556  1.00 24.32           O  
ATOM      5  CB  LEU A  89      40.117 -32.465   2.443  1.00 23.63           C  
ATOM      6  CG  LEU A  89      40.644 -32.639   1.029  1.00 26.77           C  
ATOM      7  CD1 LEU A  89      40.577 -34.066   0.565  1.00 25.38           C  
ATOM      8  CD2 LEU A  89      39.866 -31.749   0.063  1.00 25.60           C  
ATOM      9  N   GLN A  90      38.584 -30.560   4.592  1.00 22.23           N  
ATOM     10  CA  GLN A  90      37.606 -30.754   5.646  1.00 22.13           C  
ATOM     11  C   GLN A  90      36.439 -31.577   5.092  1.00 20.54           C  
ATOM     12  O   GLN A  90      36.302 -31.780   3.876  1.00 18.15           O  
ATOM     13  CB  GLN A  90      37.131 -29.400   6.202  1.00 22.97           C  
ATOM     14  CG  GLN A  90      38.291 -28.436   6.437  1.00 28.57           C  
ATOM     15  CD  GLN A  90      37.955 -27.288   7.340  1.00 36.43           C  
ATOM     16  OE1 GLN A  90      37.430 -26.260   6.879  1.00 38.45           O  
ATOM     17  NE2 GLN A  90      38.271 -27.435   8.635  1.00 39.04           N  
ATOM     18  N   GLN A  91      35.584 -32.050   5.987  1.00 19.57           N  
ATOM     19  CA  GLN A  91      34.432 -32.835   5.594  1.00 18.47           C  
ATOM     20  C   GLN A  91      33.345 -31.840   5.187  1.00 18.52           C  
ATOM     21  O   GLN A  91      32.902 -30.929   5.965  1.00 20.83           O  
ATOM     22  CB  GLN A  91      33.941 -33.755   6.738  1.00 19.16           C  
ATOM     23  CG  GLN A  91      34.915 -34.870   7.081  1.00 22.55           C  
ATOM     24  CD  GLN A  91      34.696 -35.516   8.466  1.00 28.43           C  
ATOM     25  OE1 GLN A  91      34.134 -34.898   9.395  1.00 33.66           O  
ATOM     26  NE2 GLN A  91      35.161 -36.743   8.610  1.00 27.12           N  
ATOM     27  N   TRP A  92      32.928 -31.984   3.958  1.00 16.19           N  
ATOM     28  CA  TRP A  92      31.893 -31.137   3.442  1.00 14.81           C  
ATOM     29  C   TRP A  92      30.802 -32.039   2.900  1.00 15.35           C  
ATOM     30  O   TRP A  92      31.070 -33.181   2.467  1.00 15.05           O  
ATOM     31  CB  TRP A  92      32.481 -30.285   2.325  1.00 14.17           C  
ATOM     32  CG  TRP A  92      33.452 -29.276   2.835  1.00 12.91           C  
ATOM     33  CD1 TRP A  92      34.828 -29.306   2.696  1.00 13.33           C  
ATOM     34  CD2 TRP A  92      33.156 -28.079   3.575  1.00 13.52           C  
ATOM     35  NE1 TRP A  92      35.394 -28.192   3.270  1.00 15.53           N  
ATOM     36  CE2 TRP A  92      34.394 -27.426   3.833  1.00 15.15           C  
ATOM     37  CE3 TRP A  92      31.964 -27.474   4.030  1.00 11.66           C  
ATOM     38  CZ2 TRP A  92      34.476 -26.204   4.538  1.00 15.45           C  
ATOM     39  CZ3 TRP A  92      32.043 -26.267   4.724  1.00 12.34           C  
ATOM     40  CH2 TRP A  92      33.300 -25.642   4.973  1.00 13.15           C  
ATOM     41  N   LYS A  93      29.594 -31.486   2.842  1.00 15.43           N  
ATOM     42  CA  LYS A  93      28.484 -32.195   2.227  1.00 14.65           C  
ATOM     43  C   LYS A  93      27.661 -31.233   1.395  1.00 14.04           C  
ATOM     44  O   LYS A  93      27.696 -30.010   1.604  1.00 12.98           O  
ATOM     45  CB  LYS A  93      27.628 -32.906   3.277  1.00 15.47           C  
ATOM     46  CG  LYS A  93      26.914 -32.059   4.249  1.00 19.62           C  
ATOM     47  CD  LYS A  93      26.738 -32.865   5.576  1.00 27.90           C  
ATOM     48  CE  LYS A  93      26.145 -31.970   6.679  1.00 27.15           C  
ATOM     49  NZ  LYS A  93      24.743 -31.794   6.283  1.00 32.85           N  
ATOM     50  N   VAL A  94      26.933 -31.773   0.445  1.00 12.55           N  
ATOM     51  CA  VAL A  94      26.079 -30.953  -0.406  1.00 13.46           C  
ATOM     52  C   VAL A  94      25.115 -30.217   0.523  1.00 13.78           C  
ATOM     53  O   VAL A  94      24.562 -30.808   1.510  1.00 14.88           O  
ATOM     54  CB  VAL A  94      25.313 -31.811  -1.441  1.00 13.04           C  
ATOM     55  CG1 VAL A  94      24.304 -30.969  -2.236  1.00 12.39           C  
ATOM     56  CG2 VAL A  94      26.289 -32.434  -2.454  1.00 14.56           C  
ATOM     57  N   GLY A  95      24.910 -28.937   0.234  1.00 13.03           N  
ATOM     58  CA  GLY A  95      23.984 -28.134   1.013  1.00 13.55           C  
ATOM     59  C   GLY A  95      24.674 -27.417   2.172  1.00 12.52           C  
ATOM     60  O   GLY A  95      24.067 -26.546   2.796  1.00 14.03           O  
ATOM     61  N   ASP A  96      25.911 -27.788   2.498  1.00 13.27           N  
ATOM     62  CA  ASP A  96      26.636 -27.135   3.630  1.00 11.63           C  
ATOM     63  C   ASP A  96      26.840 -25.667   3.362  1.00 12.60           C  
ATOM     64  O   ASP A  96      27.013 -25.271   2.207  1.00 10.59           O  
ATOM     65  CB  ASP A  96      28.028 -27.714   3.851  1.00 12.58           C  
ATOM     66  CG  ASP A  96      28.043 -28.857   4.792  1.00 15.59           C  
ATOM     67  OD1 ASP A  96      27.030 -29.046   5.549  1.00 17.45           O  
ATOM     68  OD2 ASP A  96      29.069 -29.608   4.871  1.00 15.07           O  
ATOM     69  N   LYS A  97      26.767 -24.848   4.417  1.00 10.27           N  
ATOM     70  CA  LYS A  97      27.140 -23.454   4.286  1.00 11.34           C  
ATOM     71  C   LYS A  97      28.661 -23.355   4.401  1.00 10.56           C  
ATOM     72  O   LYS A  97      29.280 -23.975   5.278  1.00 10.62           O  
ATOM     73  CB  LYS A  97      26.553 -22.637   5.430  1.00 10.78           C  
ATOM     74  CG  LYS A  97      25.032 -22.530   5.423  1.00 16.39           C  
ATOM     75  CD  LYS A  97      24.718 -21.761   6.770  1.00 23.84           C  
ATOM     76  CE  LYS A  97      23.258 -21.434   7.002  1.00 31.15           C  
ATOM     77  NZ  LYS A  97      23.136 -19.972   7.290  1.00 33.93           N  
ATOM     78  N   CYS A  98      29.268 -22.516   3.578  1.00 11.64           N  
ATOM     79  CA  CYS A  98      30.703 -22.339   3.673  1.00 10.84           C  
ATOM     80  C   CYS A  98      30.976 -20.885   3.212  1.00 11.41           C  
ATOM     81  O   CYS A  98      30.039 -20.116   2.950  1.00 12.26           O  
ATOM     82  CB  CYS A  98      31.446 -23.344   2.763  1.00 12.56           C  
ATOM     83  SG  CYS A  98      31.114 -23.086   1.006  1.00 13.22           S  
ATOM     84  N   SER A  99      32.251 -20.512   3.118  1.00 10.29           N  
ATOM     85  CA  SER A  99      32.602 -19.290   2.420  1.00  9.74           C  
ATOM     86  C   SER A  99      33.721 -19.638   1.450  1.00  9.45           C  
ATOM     87  O   SER A  99      34.355 -20.663   1.583  1.00  9.89           O  
ATOM     88  CB  SER A  99      33.045 -18.248   3.434  1.00 11.97           C  
ATOM     89  OG  SER A  99      31.862 -17.904   4.207  1.00 10.62           O  
ATOM     90  N   ALA A 100      33.876 -18.833   0.411  1.00 10.80           N  
ATOM     91  CA  ALA A 100      34.938 -19.133  -0.535  1.00 10.51           C  
ATOM     92  C   ALA A 100      35.405 -17.873  -1.204  1.00 11.16           C  
ATOM     93  O   ALA A 100      34.698 -16.868  -1.224  1.00 10.85           O  
ATOM     94  CB  ALA A 100      34.398 -20.177  -1.593  1.00 11.66           C  
ATOM     95  N   ILE A 101      36.631 -17.912  -1.741  1.00 12.15           N  
ATOM     96  CA  ILE A 101      37.141 -16.783  -2.499  1.00 12.14           C  
ATOM     97  C   ILE A 101      36.595 -16.827  -3.908  1.00 13.09           C  
ATOM     98  O   ILE A 101      36.867 -17.778  -4.662  1.00 12.15           O  
ATOM     99  CB  ILE A 101      38.735 -16.842  -2.500  1.00 11.75           C  
ATOM    100  CG1 ILE A 101      39.253 -16.909  -1.044  1.00 12.63           C  
ATOM    101  CG2 ILE A 101      39.317 -15.719  -3.323  1.00 11.99           C  
ATOM    102  CD1 ILE A 101      40.809 -17.295  -0.894  1.00 13.30           C  
ATOM    103  N   TRP A 102      35.886 -15.790  -4.318  1.00 13.23           N  
ATOM    104  CA  TRP A 102      35.371 -15.748  -5.672  1.00 15.00           C  
ATOM    105  C   TRP A 102      36.491 -15.366  -6.645  1.00 16.94           C  
ATOM    106  O   TRP A 102      37.230 -14.407  -6.399  1.00 15.64           O  
ATOM    107  CB  TRP A 102      34.287 -14.702  -5.739  1.00 17.63           C  
ATOM    108  CG  TRP A 102      33.351 -14.820  -6.889  1.00 19.22           C  
ATOM    109  CD1 TRP A 102      33.539 -15.476  -8.089  1.00 20.09           C  
ATOM    110  CD2 TRP A 102      32.042 -14.256  -6.933  1.00 21.77           C  
ATOM    111  NE1 TRP A 102      32.408 -15.340  -8.870  1.00 22.51           N  
ATOM    112  CE2 TRP A 102      31.474 -14.606  -8.172  1.00 23.67           C  
ATOM    113  CE3 TRP A 102      31.270 -13.505  -6.014  1.00 23.79           C  
ATOM    114  CZ2 TRP A 102      30.174 -14.201  -8.537  1.00 26.89           C  
ATOM    115  CZ3 TRP A 102      29.986 -13.114  -6.356  1.00 25.93           C  
ATOM    116  CH2 TRP A 102      29.444 -13.463  -7.616  1.00 27.49           C  
ATOM    117  N   SER A 103      36.616 -16.110  -7.736  1.00 17.32           N  
ATOM    118  CA  SER A 103      37.781 -15.924  -8.609  1.00 20.48           C  
ATOM    119  C   SER A 103      37.686 -14.630  -9.396  1.00 20.42           C  
ATOM    120  O   SER A 103      38.689 -14.167  -9.968  1.00 20.80           O  
ATOM    121  CB  SER A 103      38.034 -17.124  -9.542  1.00 20.20           C  
ATOM    122  OG  SER A 103      36.960 -17.279 -10.458  1.00 26.42           O  
ATOM    123  N   GLU A 104      36.498 -14.048  -9.424  1.00 20.34           N  
ATOM    124  CA  GLU A 104      36.264 -12.825 -10.179  1.00 22.28           C  
ATOM    125  C   GLU A 104      36.889 -11.601  -9.511  1.00 20.57           C  
ATOM    126  O   GLU A 104      37.332 -10.655 -10.195  1.00 20.50           O  
ATOM    127  CB  GLU A 104      34.745 -12.649 -10.407  1.00 24.78           C  
ATOM    128  CG  GLU A 104      34.126 -11.348  -9.943  1.00 30.32           C  
ATOM    129  CD  GLU A 104      32.744 -11.548  -9.342  1.00 38.29           C  
ATOM    130  OE1 GLU A 104      31.841 -12.022 -10.091  1.00 39.09           O  
ATOM    131  OE2 GLU A 104      32.593 -11.246  -8.120  1.00 38.17           O  
ATOM    132  N   ASP A 105      36.934 -11.588  -8.190  1.00 18.29           N  
ATOM    133  CA  ASP A 105      37.449 -10.384  -7.518  1.00 17.58           C  
ATOM    134  C   ASP A 105      38.405 -10.655  -6.385  1.00 14.68           C  
ATOM    135  O   ASP A 105      38.936  -9.708  -5.823  1.00 16.83           O  
ATOM    136  CB  ASP A 105      36.327  -9.413  -7.088  1.00 17.63           C  
ATOM    137  CG  ASP A 105      35.532  -9.935  -5.897  1.00 20.47           C  
ATOM    138  OD1 ASP A 105      35.732 -11.109  -5.499  1.00 16.43           O  
ATOM    139  OD2 ASP A 105      34.720  -9.230  -5.287  1.00 20.50           O  
ATOM    140  N   GLY A 106      38.657 -11.937  -6.069  1.00 13.48           N  
ATOM    141  CA  GLY A 106      39.563 -12.328  -4.998  1.00 11.88           C  
ATOM    142  C   GLY A 106      39.066 -12.019  -3.595  1.00 13.55           C  
ATOM    143  O   GLY A 106      39.867 -11.905  -2.679  1.00 13.22           O  
ATOM    144  N   CYS A 107      37.745 -11.868  -3.445  1.00 13.06           N  
ATOM    145  CA  CYS A 107      37.147 -11.564  -2.133  1.00 14.57           C  
ATOM    146  C   CYS A 107      36.397 -12.776  -1.618  1.00 13.39           C  
ATOM    147  O   CYS A 107      35.976 -13.606  -2.410  1.00 13.06           O  
ATOM    148  CB  CYS A 107      36.146 -10.438  -2.272  1.00 14.21           C  
ATOM    149  SG  CYS A 107      36.955  -8.837  -2.666  1.00 20.69           S  
ATOM    150  N   ILE A 108      36.180 -12.810  -0.308  1.00 12.60           N  
ATOM    151  CA  ILE A 108      35.496 -13.932   0.323  1.00 12.49           C  
ATOM    152  C   ILE A 108      33.990 -13.680   0.255  1.00 11.02           C  
ATOM    153  O   ILE A 108      33.563 -12.554   0.549  1.00 11.27           O  
ATOM    154  CB  ILE A 108      35.884 -14.020   1.773  1.00 12.05           C  
ATOM    155  CG1 ILE A 108      37.368 -14.402   1.932  1.00 14.13           C  
ATOM    156  CG2 ILE A 108      35.002 -15.125   2.519  1.00 12.86           C  
ATOM    157  CD1 ILE A 108      37.868 -14.268   3.411  1.00 18.26           C  
ATOM    158  N   TYR A 109      33.191 -14.713  -0.064  1.00 10.20           N  
ATOM    159  CA  TYR A 109      31.741 -14.554  -0.085  1.00 10.90           C  
ATOM    160  C   TYR A 109      31.115 -15.727   0.591  1.00 11.43           C  
ATOM    161  O   TYR A 109      31.672 -16.809   0.522  1.00 10.59           O  
ATOM    162  CB  TYR A 109      31.222 -14.486  -1.502  1.00 12.34           C  
ATOM    163  CG  TYR A 109      31.548 -13.168  -2.169  1.00 14.56           C  
ATOM    164  CD1 TYR A 109      32.754 -13.011  -2.922  1.00 15.29           C  
ATOM    165  CD2 TYR A 109      30.702 -12.105  -2.071  1.00 17.04           C  
ATOM    166  CE1 TYR A 109      33.081 -11.842  -3.529  1.00 14.67           C  
ATOM    167  CE2 TYR A 109      31.027 -10.872  -2.716  1.00 17.35           C  
ATOM    168  CZ  TYR A 109      32.224 -10.762  -3.436  1.00 18.16           C  
ATOM    169  OH  TYR A 109      32.536  -9.583  -4.083  1.00 20.05           O  
ATOM    170  N   PRO A 110      29.940 -15.559   1.238  1.00 11.19           N  
ATOM    171  CA  PRO A 110      29.213 -16.727   1.753  1.00 11.58           C  
ATOM    172  C   PRO A 110      28.724 -17.572   0.581  1.00 10.75           C  
ATOM    173  O   PRO A 110      28.326 -17.045  -0.468  1.00 11.36           O  
ATOM    174  CB  PRO A 110      27.969 -16.097   2.431  1.00 10.04           C  
ATOM    175  CG  PRO A 110      27.765 -14.722   1.715  1.00 11.06           C  
ATOM    176  CD  PRO A 110      29.214 -14.295   1.483  1.00 13.79           C  
ATOM    177  N   ALA A 111      28.676 -18.889   0.788  1.00 10.42           N  
ATOM    178  CA  ALA A 111      28.251 -19.801  -0.264  1.00 10.95           C  
ATOM    179  C   ALA A 111      27.594 -21.043   0.330  1.00 11.55           C  
ATOM    180  O   ALA A 111      27.684 -21.269   1.547  1.00 10.55           O  
ATOM    181  CB  ALA A 111      29.453 -20.193  -1.098  1.00  9.80           C  
ATOM    182  N   THR A 112      26.863 -21.768  -0.530  1.00 11.13           N  
ATOM    183  CA  THR A 112      26.293 -23.105  -0.258  1.00 12.64           C  
ATOM    184  C   THR A 112      26.901 -24.093  -1.281  1.00 12.50           C  
ATOM    185  O   THR A 112      27.066 -23.747  -2.451  1.00 13.72           O  
ATOM    186  CB  THR A 112      24.779 -23.064  -0.500  1.00 11.23           C  
ATOM    187  OG1 THR A 112      24.210 -22.026   0.326  1.00 17.52           O  
ATOM    188  CG2 THR A 112      24.182 -24.306   0.014  1.00 15.61           C  
ATOM    189  N   ILE A 113      27.246 -25.305  -0.833  1.00 12.93           N  
ATOM    190  CA  ILE A 113      27.744 -26.330  -1.726  1.00 11.97           C  
ATOM    191  C   ILE A 113      26.597 -26.966  -2.492  1.00 12.75           C  
ATOM    192  O   ILE A 113      25.668 -27.489  -1.887  1.00 12.84           O  
ATOM    193  CB  ILE A 113      28.540 -27.402  -0.988  1.00 12.62           C  
ATOM    194  CG1 ILE A 113      29.743 -26.778  -0.248  1.00  9.88           C  
ATOM    195  CG2 ILE A 113      29.002 -28.485  -2.010  1.00 10.79           C  
ATOM    196  CD1 ILE A 113      30.429 -27.767   0.742  1.00 10.89           C  
ATOM    197  N   ALA A 114      26.688 -26.900  -3.811  1.00 13.06           N  
ATOM    198  CA  ALA A 114      25.649 -27.379  -4.747  1.00 14.44           C  
ATOM    199  C   ALA A 114      25.923 -28.815  -5.207  1.00 14.15           C  
ATOM    200  O   ALA A 114      24.997 -29.541  -5.527  1.00 13.53           O  
ATOM    201  CB  ALA A 114      25.602 -26.464  -5.991  1.00 13.48           C  
ATOM    202  N   SER A 115      27.194 -29.181  -5.295  1.00 13.78           N  
ATOM    203  CA  SER A 115      27.585 -30.501  -5.795  1.00 13.59           C  
ATOM    204  C   SER A 115      29.012 -30.739  -5.381  1.00 12.87           C  
ATOM    205  O   SER A 115      29.782 -29.781  -5.229  1.00 12.31           O  
ATOM    206  CB  SER A 115      27.433 -30.611  -7.317  1.00 14.19           C  
ATOM    207  OG  SER A 115      28.305 -29.728  -8.013  1.00 16.14           O  
ATOM    208  N   ILE A 116      29.378 -31.994  -5.174  1.00 12.82           N  
ATOM    209  CA  ILE A 116      30.785 -32.306  -4.918  1.00 13.35           C  
ATOM    210  C   ILE A 116      31.234 -33.425  -5.904  1.00 13.79           C  
ATOM    211  O   ILE A 116      30.500 -34.370  -6.159  1.00 15.12           O  
ATOM    212  CB  ILE A 116      30.985 -32.767  -3.464  1.00 13.26           C  
ATOM    213  CG1 ILE A 116      30.553 -31.685  -2.433  1.00 12.72           C  
ATOM    214  CG2 ILE A 116      32.452 -33.200  -3.172  1.00 12.87           C  
ATOM    215  CD1 ILE A 116      30.412 -32.218  -1.048  1.00 13.05           C  
ATOM    216  N   ASP A 117      32.426 -33.292  -6.432  1.00 13.13           N  
ATOM    217  CA  ASP A 117      33.038 -34.340  -7.241  1.00 14.69           C  
ATOM    218  C   ASP A 117      34.215 -34.862  -6.481  1.00 15.18           C  
ATOM    219  O   ASP A 117      35.329 -34.284  -6.488  1.00 15.48           O  
ATOM    220  CB  ASP A 117      33.422 -33.744  -8.607  1.00 14.24           C  
ATOM    221  CG  ASP A 117      34.074 -34.751  -9.541  1.00 18.13           C  
ATOM    222  OD1 ASP A 117      34.564 -35.812  -9.085  1.00 19.47           O  
ATOM    223  OD2 ASP A 117      34.143 -34.504 -10.750  1.00 20.06           O  
ATOM    224  N   PHE A 118      33.967 -35.967  -5.779  1.00 15.31           N  
ATOM    225  CA  PHE A 118      34.938 -36.473  -4.831  1.00 16.43           C  
ATOM    226  C   PHE A 118      36.175 -36.977  -5.566  1.00 17.80           C  
ATOM    227  O   PHE A 118      37.282 -36.779  -5.090  1.00 19.78           O  
ATOM    228  CB  PHE A 118      34.299 -37.561  -3.952  1.00 15.86           C  
ATOM    229  CG  PHE A 118      33.463 -37.005  -2.836  1.00 15.90           C  
ATOM    230  CD1 PHE A 118      32.070 -37.208  -2.809  1.00 18.31           C  
ATOM    231  CD2 PHE A 118      34.045 -36.245  -1.829  1.00 17.37           C  
ATOM    232  CE1 PHE A 118      31.306 -36.623  -1.811  1.00 15.60           C  
ATOM    233  CE2 PHE A 118      33.266 -35.674  -0.806  1.00 17.36           C  
ATOM    234  CZ  PHE A 118      31.910 -35.881  -0.800  1.00 14.32           C  
ATOM    235  N   LYS A 119      36.002 -37.570  -6.741  1.00 18.51           N  
ATOM    236  CA  LYS A 119      37.158 -38.118  -7.472  1.00 20.39           C  
ATOM    237  C   LYS A 119      38.147 -37.027  -7.890  1.00 18.80           C  
ATOM    238  O   LYS A 119      39.371 -37.238  -7.860  1.00 20.18           O  
ATOM    239  CB  LYS A 119      36.729 -38.954  -8.688  1.00 21.63           C  
ATOM    240  CG  LYS A 119      37.008 -40.489  -8.516  1.00 28.48           C  
ATOM    241  CD  LYS A 119      35.919 -41.364  -9.194  1.00 36.13           C  
ATOM    242  CE  LYS A 119      35.752 -42.770  -8.551  1.00 38.94           C  
ATOM    243  NZ  LYS A 119      34.286 -43.169  -8.415  1.00 41.55           N  
ATOM    244  N   ARG A 120      37.621 -35.855  -8.250  1.00 17.23           N  
ATOM    245  CA  ARG A 120      38.487 -34.737  -8.624  1.00 15.97           C  
ATOM    246  C   ARG A 120      38.782 -33.785  -7.469  1.00 16.15           C  
ATOM    247  O   ARG A 120      39.608 -32.884  -7.598  1.00 15.94           O  
ATOM    248  CB  ARG A 120      37.897 -33.991  -9.810  1.00 16.59           C  
ATOM    249  CG  ARG A 120      37.675 -34.901 -11.013  1.00 15.54           C  
ATOM    250  CD  ARG A 120      37.637 -34.183 -12.329  1.00 16.50           C  
ATOM    251  NE  ARG A 120      37.280 -35.121 -13.412  1.00 15.46           N  
ATOM    252  CZ  ARG A 120      38.198 -35.780 -14.158  1.00 15.79           C  
ATOM    253  NH1 ARG A 120      39.502 -35.575 -13.978  1.00 13.86           N  
ATOM    254  NH2 ARG A 120      37.804 -36.582 -15.124  1.00 13.79           N  
ATOM    255  N   GLU A 121      38.125 -34.028  -6.332  1.00 15.83           N  
ATOM    256  CA  GLU A 121      38.241 -33.203  -5.123  1.00 16.50           C  
ATOM    257  C   GLU A 121      37.809 -31.758  -5.383  1.00 15.79           C  
ATOM    258  O   GLU A 121      38.391 -30.801  -4.871  1.00 17.02           O  
ATOM    259  CB  GLU A 121      39.660 -33.280  -4.541  1.00 16.84           C  
ATOM    260  CG  GLU A 121      40.062 -34.688  -4.151  1.00 21.26           C  
ATOM    261  CD  GLU A 121      39.377 -35.256  -2.897  1.00 27.84           C  
ATOM    262  OE1 GLU A 121      38.307 -34.823  -2.466  1.00 30.26           O  
ATOM    263  OE2 GLU A 121      39.938 -36.201  -2.325  1.00 34.42           O  
ATOM    264  N   THR A 122      36.779 -31.612  -6.170  1.00 14.63           N  
ATOM    265  CA  THR A 122      36.253 -30.293  -6.427  1.00 14.44           C  
ATOM    266  C   THR A 122      34.800 -30.266  -6.003  1.00 12.73           C  
ATOM    267  O   THR A 122      34.169 -31.317  -5.725  1.00 12.77           O  
ATOM    268  CB  THR A 122      36.374 -29.870  -7.929  1.00 15.00           C  
ATOM    269  OG1 THR A 122      35.617 -30.754  -8.766  1.00 14.90           O  
ATOM    270  CG2 THR A 122      37.815 -30.021  -8.451  1.00 17.82           C  
ATOM    271  N   CYS A 123      34.274 -29.057  -5.970  1.00 12.36           N  
ATOM    272  CA  CYS A 123      32.835 -28.881  -5.784  1.00 12.67           C  
ATOM    273  C   CYS A 123      32.378 -27.669  -6.573  1.00 12.83           C  
ATOM    274  O   CYS A 123      33.210 -26.929  -7.117  1.00 13.81           O  
ATOM    275  CB  CYS A 123      32.516 -28.730  -4.304  1.00 11.40           C  
ATOM    276  SG  CYS A 123      33.340 -27.262  -3.591  1.00 13.78           S  
ATOM    277  N   VAL A 124      31.063 -27.488  -6.682  1.00 11.72           N  
ATOM    278  CA  VAL A 124      30.497 -26.260  -7.180  1.00 12.15           C  
ATOM    279  C   VAL A 124      29.815 -25.585  -5.957  1.00 12.46           C  
ATOM    280  O   VAL A 124      29.022 -26.204  -5.251  1.00 11.23           O  
ATOM    281  CB  VAL A 124      29.457 -26.484  -8.242  1.00 13.52           C  
ATOM    282  CG1 VAL A 124      28.716 -25.139  -8.635  1.00 14.49           C  
ATOM    283  CG2 VAL A 124      30.087 -27.117  -9.465  1.00 13.54           C  
ATOM    284  N   VAL A 125      30.138 -24.314  -5.759  1.00 11.94           N  
ATOM    285  CA  VAL A 125      29.428 -23.481  -4.767  1.00 12.01           C  
ATOM    286  C   VAL A 125      28.582 -22.415  -5.434  1.00 11.98           C  
ATOM    287  O   VAL A 125      28.869 -21.954  -6.570  1.00 14.06           O  
ATOM    288  CB  VAL A 125      30.403 -22.839  -3.747  1.00 11.85           C  
ATOM    289  CG1 VAL A 125      31.263 -23.896  -3.155  1.00 10.80           C  
ATOM    290  CG2 VAL A 125      31.327 -21.781  -4.419  1.00 13.39           C  
ATOM    291  N   VAL A 126      27.522 -22.018  -4.726  1.00 11.36           N  
ATOM    292  CA  VAL A 126      26.676 -20.951  -5.173  1.00 12.68           C  
ATOM    293  C   VAL A 126      26.834 -19.824  -4.165  1.00 12.94           C  
ATOM    294  O   VAL A 126      26.588 -20.006  -2.979  1.00 12.27           O  
ATOM    295  CB  VAL A 126      25.207 -21.398  -5.225  1.00 13.33           C  
ATOM    296  CG1 VAL A 126      24.272 -20.230  -5.574  1.00 14.79           C  
ATOM    297  CG2 VAL A 126      25.023 -22.584  -6.239  1.00 14.04           C  
ATOM    298  N   TYR A 127      27.229 -18.663  -4.648  1.00 13.53           N  
ATOM    299  CA  TYR A 127      27.444 -17.538  -3.756  1.00 13.83           C  
ATOM    300  C   TYR A 127      26.093 -16.983  -3.363  1.00 15.12           C  
ATOM    301  O   TYR A 127      25.340 -16.511  -4.201  1.00 14.70           O  
ATOM    302  CB  TYR A 127      28.311 -16.484  -4.414  1.00 12.96           C  
ATOM    303  CG  TYR A 127      29.679 -17.013  -4.673  1.00 12.64           C  
ATOM    304  CD1 TYR A 127      30.084 -17.285  -5.986  1.00 12.69           C  
ATOM    305  CD2 TYR A 127      30.555 -17.337  -3.590  1.00 12.95           C  
ATOM    306  CE1 TYR A 127      31.394 -17.828  -6.257  1.00 14.20           C  
ATOM    307  CE2 TYR A 127      31.829 -17.890  -3.865  1.00 14.11           C  
ATOM    308  CZ  TYR A 127      32.236 -18.102  -5.197  1.00 13.71           C  
ATOM    309  OH  TYR A 127      33.491 -18.646  -5.466  1.00 14.52           O  
ATOM    310  N   THR A 128      25.837 -17.082  -2.067  1.00 16.87           N  
ATOM    311  CA  THR A 128      24.527 -16.817  -1.429  1.00 17.00           C  
ATOM    312  C   THR A 128      24.061 -15.411  -1.605  1.00 16.18           C  
ATOM    313  O   THR A 128      24.611 -14.485  -0.983  1.00 19.10           O  
ATOM    314  CB  THR A 128      24.708 -17.007   0.091  1.00 17.63           C  
ATOM    315  OG1 THR A 128      25.046 -18.349   0.367  1.00 18.88           O  
ATOM    316  CG2 THR A 128      23.404 -16.827   0.850  1.00 21.38           C  
ATOM    317  N   GLY A 129      23.017 -15.224  -2.397  1.00 16.38           N  
ATOM    318  CA  GLY A 129      22.486 -13.913  -2.610  1.00 16.60           C  
ATOM    319  C   GLY A 129      23.232 -13.143  -3.680  1.00 18.07           C  
ATOM    320  O   GLY A 129      22.948 -11.948  -3.907  1.00 18.86           O  
ATOM    321  N   TYR A 130      24.170 -13.814  -4.351  1.00 17.89           N  
ATOM    322  CA  TYR A 130      24.934 -13.196  -5.417  1.00 18.37           C  
ATOM    323  C   TYR A 130      24.668 -13.817  -6.799  1.00 19.33           C  
ATOM    324  O   TYR A 130      25.281 -13.400  -7.798  1.00 19.21           O  
ATOM    325  CB  TYR A 130      26.417 -13.257  -5.090  1.00 18.52           C  
ATOM    326  CG  TYR A 130      26.775 -12.501  -3.842  1.00 18.99           C  
ATOM    327  CD1 TYR A 130      26.826 -13.136  -2.610  1.00 20.70           C  
ATOM    328  CD2 TYR A 130      27.032 -11.127  -3.883  1.00 18.98           C  
ATOM    329  CE1 TYR A 130      27.153 -12.433  -1.450  1.00 21.80           C  
ATOM    330  CE2 TYR A 130      27.366 -10.437  -2.743  1.00 20.61           C  
ATOM    331  CZ  TYR A 130      27.418 -11.088  -1.526  1.00 23.14           C  
ATOM    332  OH  TYR A 130      27.734 -10.404  -0.356  1.00 27.79           O  
ATOM    333  N   GLY A 131      23.818 -14.854  -6.834  1.00 18.30           N  
ATOM    334  CA  GLY A 131      23.269 -15.413  -8.057  1.00 18.95           C  
ATOM    335  C   GLY A 131      24.219 -16.102  -8.987  1.00 20.71           C  
ATOM    336  O   GLY A 131      23.906 -16.286 -10.162  1.00 21.00           O  
ATOM    337  N   ASN A 132      25.396 -16.467  -8.482  1.00 20.36           N  
ATOM    338  CA  ASN A 132      26.463 -16.945  -9.336  1.00 21.54           C  
ATOM    339  C   ASN A 132      27.080 -18.181  -8.703  1.00 20.96           C  
ATOM    340  O   ASN A 132      26.992 -18.365  -7.493  1.00 20.70           O  
ATOM    341  CB  ASN A 132      27.555 -15.866  -9.471  1.00 22.58           C  
ATOM    342  CG  ASN A 132      27.382 -14.996 -10.711  1.00 27.86           C  
ATOM    343  OD1 ASN A 132      27.187 -13.775 -10.605  1.00 31.24           O  
ATOM    344  ND2 ASN A 132      27.450 -15.621 -11.905  1.00 32.44           N  
ATOM    345  N   ARG A 133      27.715 -19.021  -9.517  1.00 20.25           N  
ATOM    346  CA  ARG A 133      28.304 -20.241  -9.015  1.00 19.80           C  
ATOM    347  C   ARG A 133      29.713 -20.419  -9.570  1.00 20.40           C  
ATOM    348  O   ARG A 133      30.097 -19.804 -10.574  1.00 19.90           O  
ATOM    349  CB  ARG A 133      27.418 -21.438  -9.397  1.00 20.38           C  
ATOM    350  CG  ARG A 133      27.585 -21.807 -10.862  1.00 22.71           C  
ATOM    351  CD  ARG A 133      26.741 -22.963 -11.280  1.00 25.76           C  
ATOM    352  NE  ARG A 133      25.349 -22.577 -11.214  1.00 26.60           N  
ATOM    353  CZ  ARG A 133      24.361 -23.437 -11.273  1.00 26.60           C  
ATOM    354  NH1 ARG A 133      24.646 -24.723 -11.414  1.00 28.78           N  
ATOM    355  NH2 ARG A 133      23.108 -23.008 -11.208  1.00 22.60           N  
ATOM    356  N   GLU A 134      30.472 -21.300  -8.950  1.00 18.63           N  
ATOM    357  CA  GLU A 134      31.845 -21.458  -9.349  1.00 20.06           C  
ATOM    358  C   GLU A 134      32.339 -22.806  -8.850  1.00 19.00           C  
ATOM    359  O   GLU A 134      31.942 -23.236  -7.772  1.00 18.38           O  
ATOM    360  CB  GLU A 134      32.628 -20.292  -8.723  1.00 19.72           C  
ATOM    361  CG  GLU A 134      34.083 -20.479  -8.511  1.00 24.74           C  
ATOM    362  CD  GLU A 134      34.756 -19.137  -8.548  1.00 28.00           C  
ATOM    363  OE1 GLU A 134      34.865 -18.502  -7.508  1.00 25.35           O  
ATOM    364  OE2 GLU A 134      35.134 -18.724  -9.654  1.00 34.34           O  
ATOM    365  N   GLU A 135      33.195 -23.475  -9.644  1.00 18.23           N  
ATOM    366  CA  GLU A 135      33.937 -24.626  -9.157  1.00 17.78           C  
ATOM    367  C   GLU A 135      35.015 -24.171  -8.231  1.00 16.52           C  
ATOM    368  O   GLU A 135      35.709 -23.169  -8.497  1.00 16.85           O  
ATOM    369  CB  GLU A 135      34.553 -25.403 -10.345  1.00 20.25           C  
ATOM    370  CG  GLU A 135      35.218 -26.727  -9.990  1.00 25.46           C  
ATOM    371  CD  GLU A 135      35.121 -27.685 -11.169  1.00 35.03           C  
ATOM    372  OE1 GLU A 135      36.049 -27.678 -12.008  1.00 35.95           O  
ATOM    373  OE2 GLU A 135      34.082 -28.389 -11.291  1.00 39.30           O  
ATOM    374  N   GLN A 136      35.179 -24.915  -7.148  1.00 14.27           N  
ATOM    375  CA  GLN A 136      36.191 -24.697  -6.138  1.00 14.69           C  
ATOM    376  C   GLN A 136      36.843 -26.039  -5.832  1.00 15.36           C  
ATOM    377  O   GLN A 136      36.174 -27.089  -5.846  1.00 15.68           O  
ATOM    378  CB  GLN A 136      35.574 -24.187  -4.806  1.00 14.28           C  
ATOM    379  CG  GLN A 136      35.011 -22.790  -4.832  1.00 13.40           C  
ATOM    380  CD  GLN A 136      36.044 -21.662  -4.695  1.00 15.88           C  
ATOM    381  OE1 GLN A 136      37.158 -21.862  -4.197  1.00 16.89           O  
ATOM    382  NE2 GLN A 136      35.642 -20.458  -5.111  1.00 14.22           N  
ATOM    383  N   ASN A 137      38.137 -26.031  -5.545  1.00 15.31           N  
ATOM    384  CA  ASN A 137      38.736 -27.192  -4.903  1.00 16.53           C  
ATOM    385  C   ASN A 137      38.148 -27.302  -3.518  1.00 15.03           C  
ATOM    386  O   ASN A 137      37.986 -26.282  -2.834  1.00 13.44           O  
ATOM    387  CB  ASN A 137      40.241 -27.038  -4.778  1.00 18.97           C  
ATOM    388  CG  ASN A 137      40.909 -26.926  -6.127  1.00 22.69           C  
ATOM    389  OD1 ASN A 137      40.565 -27.656  -7.058  1.00 21.51           O  
ATOM    390  ND2 ASN A 137      41.828 -25.966  -6.255  1.00 23.88           N  
ATOM    391  N   LEU A 138      37.785 -28.518  -3.109  1.00 13.95           N  
ATOM    392  CA  LEU A 138      37.339 -28.710  -1.719  1.00 13.03           C  
ATOM    393  C   LEU A 138      38.371 -28.146  -0.716  1.00 13.55           C  
ATOM    394  O   LEU A 138      37.968 -27.563   0.304  1.00 12.76           O  
ATOM    395  CB  LEU A 138      37.083 -30.187  -1.409  1.00 12.70           C  
ATOM    396  CG  LEU A 138      35.849 -30.794  -2.064  1.00 14.13           C  
ATOM    397  CD1 LEU A 138      35.922 -32.255  -2.013  1.00 15.22           C  
ATOM    398  CD2 LEU A 138      34.605 -30.295  -1.301  1.00 12.31           C  
ATOM    399  N   SER A 139      39.675 -28.275  -1.001  1.00 12.04           N  
ATOM    400  CA  SER A 139      40.700 -27.804  -0.051  1.00 14.70           C  
ATOM    401  C   SER A 139      40.659 -26.287   0.175  1.00 14.00           C  
ATOM    402  O   SER A 139      41.239 -25.811   1.142  1.00 16.53           O  
ATOM    403  CB  SER A 139      42.125 -28.202  -0.481  1.00 13.76           C  
ATOM    404  OG  SER A 139      42.321 -27.758  -1.796  1.00 17.61           O  
ATOM    405  N   ASP A 140      40.028 -25.558  -0.730  1.00 14.52           N  
ATOM    406  CA  ASP A 140      40.023 -24.101  -0.712  1.00 13.21           C  
ATOM    407  C   ASP A 140      38.788 -23.533  -0.018  1.00 13.57           C  
ATOM    408  O   ASP A 140      38.690 -22.304   0.117  1.00 13.77           O  
ATOM    409  CB  ASP A 140      40.080 -23.524  -2.127  1.00 13.35           C  
ATOM    410  CG  ASP A 140      41.427 -23.735  -2.804  1.00 14.72           C  
ATOM    411  OD1 ASP A 140      42.435 -23.914  -2.091  1.00 18.24           O  
ATOM    412  OD2 ASP A 140      41.529 -23.715  -4.046  1.00 17.84           O  
ATOM    413  N   LEU A 141      37.856 -24.395   0.423  1.00 11.97           N  
ATOM    414  CA  LEU A 141      36.622 -23.866   1.077  1.00 11.52           C  
ATOM    415  C   LEU A 141      37.000 -23.376   2.465  1.00 11.40           C  
ATOM    416  O   LEU A 141      37.944 -23.894   3.111  1.00 11.40           O  
ATOM    417  CB  LEU A 141      35.536 -24.963   1.164  1.00 10.24           C  
ATOM    418  CG  LEU A 141      35.006 -25.394  -0.207  1.00 10.59           C  
ATOM    419  CD1 LEU A 141      33.916 -26.480   0.106  1.00 10.72           C  
ATOM    420  CD2 LEU A 141      34.411 -24.293  -1.107  1.00  8.38           C  
ATOM    421  N   LEU A 142      36.252 -22.370   2.926  1.00 12.13           N  
ATOM    422  CA  LEU A 142      36.484 -21.775   4.211  1.00 10.57           C  
ATOM    423  C   LEU A 142      35.261 -21.931   5.109  1.00 11.42           C  
ATOM    424  O   LEU A 142      34.118 -22.104   4.645  1.00 10.91           O  
ATOM    425  CB  LEU A 142      36.751 -20.283   4.062  1.00 10.93           C  
ATOM    426  CG  LEU A 142      37.762 -19.799   2.993  1.00 13.72           C  
ATOM    427  CD1 LEU A 142      37.662 -18.316   2.720  1.00 13.71           C  
ATOM    428  CD2 LEU A 142      39.142 -20.209   3.476  1.00 15.19           C  
ATOM    429  N   SER A 143      35.530 -21.811   6.390  1.00 11.77           N  
ATOM    430  CA  SER A 143      34.476 -21.708   7.409  1.00 12.35           C  
ATOM    431  C   SER A 143      33.398 -20.727   7.031  1.00 11.34           C  
ATOM    432  O   SER A 143      33.719 -19.623   6.583  1.00 12.53           O  
ATOM    433  CB  SER A 143      35.086 -21.171   8.704  1.00 12.83           C  
ATOM    434  OG  SER A 143      34.040 -20.983   9.653  1.00 17.49           O  
ATOM    435  N   PRO A 144      32.109 -21.056   7.263  1.00 11.95           N  
ATOM    436  CA  PRO A 144      31.069 -20.103   6.921  1.00 12.92           C  
ATOM    437  C   PRO A 144      31.135 -18.848   7.803  1.00 13.91           C  
ATOM    438  O   PRO A 144      30.466 -17.917   7.465  1.00 12.67           O  
ATOM    439  CB  PRO A 144      29.759 -20.881   7.128  1.00 13.67           C  
ATOM    440  CG  PRO A 144      30.085 -21.961   8.075  1.00 13.27           C  
ATOM    441  CD  PRO A 144      31.541 -22.359   7.697  1.00 11.28           C  
ATOM    442  N   ILE A 145      31.911 -18.856   8.894  1.00 15.28           N  
ATOM    443  CA  ILE A 145      32.134 -17.631   9.681  1.00 18.46           C  
ATOM    444  C   ILE A 145      32.932 -16.545   8.922  1.00 19.93           C  
ATOM    445  O   ILE A 145      32.730 -15.335   9.154  1.00 19.05           O  
ATOM    446  CB  ILE A 145      32.800 -17.985  10.994  1.00 18.94           C  
ATOM    447  CG1 ILE A 145      31.872 -18.896  11.818  1.00 21.76           C  
ATOM    448  CG2 ILE A 145      33.206 -16.711  11.807  1.00 21.94           C  
ATOM    449  CD1 ILE A 145      32.565 -19.505  13.031  1.00 27.58           C  
ATOM    450  N   CYS A 146      33.841 -16.939   8.022  1.00 21.33           N  
ATOM    451  CA  CYS A 146      34.587 -15.935   7.240  1.00 23.96           C  
ATOM    452  C   CYS A 146      33.711 -15.215   6.286  1.00 24.98           C  
ATOM    453  O   CYS A 146      33.158 -15.835   5.382  1.00 25.48           O  
ATOM    454  CB  CYS A 146      35.684 -16.542   6.391  1.00 25.09           C  
ATOM    455  SG  CYS A 146      36.533 -17.688   7.356  1.00 27.50           S  
ATOM    456  N   GLU A 147      33.637 -13.905   6.429  1.00 26.02           N  
ATOM    457  CA  GLU A 147      32.889 -13.115   5.450  1.00 28.66           C  
ATOM    458  C   GLU A 147      33.609 -11.827   5.036  1.00 28.95           C  
ATOM    459  O   GLU A 147      33.210 -11.061   4.162  1.00 29.73           O  
ATOM    460  CB  GLU A 147      31.452 -12.894   5.945  1.00 29.32           C  
ATOM    461  CG  GLU A 147      30.597 -14.147   5.759  1.00 31.74           C  
ATOM    462  CD  GLU A 147      29.167 -14.020   6.230  1.00 33.34           C  
ATOM    463  OE1 GLU A 147      28.265 -14.102   5.368  1.00 36.57           O  
ATOM    464  OE2 GLU A 147      28.933 -13.908   7.450  1.00 33.03           O  
ATOM    465  OXT GLU A 147      34.681 -11.507   5.549  1.00 30.39           O  
TER     466      GLU A 147                                                      
END
MOLECULE T0429_100_176.pdb
ATOM    493  N   ARG   100      33.748 -12.822  13.671  1.00 72.44      A    N  
ATOM    494  CA  ARG   100      34.839 -13.184  12.777  1.00 71.01      A    C  
ATOM    495  CB  ARG   100      36.168 -12.642  13.305  1.00 71.60      A    C  
ATOM    496  CG  ARG   100      37.275 -12.682  12.273  1.00 71.40      A    C  
ATOM    497  CD  ARG   100      38.385 -11.712  12.580  1.00 73.85      A    C  
ATOM    498  NE  ARG   100      38.010 -10.331  12.296  1.00 73.41      A    N  
ATOM    499  CZ  ARG   100      38.795  -9.285  12.528  1.00 75.14      A    C  
ATOM    500  NH1 ARG   100      38.373  -8.063  12.255  1.00 75.99      A    N  
ATOM    501  NH2 ARG   100      40.004  -9.457  13.035  1.00 80.38      A    N  
ATOM    502  C   ARG   100      34.921 -14.695  12.550  1.00 71.83      A    C  
ATOM    503  O   ARG   100      34.724 -15.474  13.472  1.00 75.13      A    O  
ATOM    504  N   ALA   101      35.185 -15.103  11.312  1.00 71.01      A    N  
ATOM    505  CA  ALA   101      35.329 -16.525  10.994  1.00 72.17      A    C  
ATOM    506  CB  ALA   101      35.429 -16.722   9.503  1.00 68.85      A    C  
ATOM    507  C   ALA   101      36.552 -17.119  11.710  1.00 75.15      A    C  
ATOM    508  O   ALA   101      37.615 -16.494  11.754  1.00 76.06      A    O  
ATOM    509  N   ARG   102      36.393 -18.307  12.292  1.00 77.04      A    N  
ATOM    510  CA  ARG   102      37.495 -18.945  13.018  1.00 80.24      A    C  
ATOM    511  CB  ARG   102      37.422 -18.649  14.532  1.00 84.15      A    C  
ATOM    512  CG  ARG   102      36.203 -19.204  15.271  1.00 87.78      A    C  
ATOM    513  CD  ARG   102      36.375 -19.083  16.790  1.00 94.35      A    C  
ATOM    514  NE  ARG   102      35.293 -19.729  17.539  1.00100.75      A    N  
ATOM    515  CZ  ARG   102      35.301 -21.003  17.926  1.00102.53      A    C  
ATOM    518  C   ARG   102      37.656 -20.449  12.745  1.00 80.42      A    C  
ATOM    519  O   ARG   102      38.732 -21.007  12.968  1.00 82.56      A    O  
ATOM    520  N   THR   103      36.603 -21.092  12.243  1.00 78.34      A    N  
ATOM    521  CA  THR   103      36.599 -22.546  12.083  1.00 78.04      A    C  
ATOM    522  CB  THR   103      35.419 -23.186  12.852  1.00 80.45      A    C  
ATOM    523  OG1 THR   103      35.405 -22.698  14.199  1.00 83.17      A    O  
ATOM    524  CG2 THR   103      35.535 -24.702  12.867  1.00 81.05      A    C  
ATOM    525  C   THR   103      36.580 -22.993  10.620  1.00 74.75      A    C  
ATOM    526  O   THR   103      35.704 -22.597   9.843  1.00 72.85      A    O  
ATOM    527  N   ILE   104      37.563 -23.816  10.260  1.00 74.51      A    N  
ATOM    528  CA  ILE   104      37.632 -24.436   8.939  1.00 71.52      A    C  
ATOM    529  CB  ILE   104      39.104 -24.721   8.524  1.00 72.44      A    C  
ATOM    530  CG1 ILE   104      39.888 -23.415   8.327  1.00 72.05      A    C  
ATOM    531  CD1 ILE   104      39.530 -22.634   7.057  1.00 70.80      A    C  
ATOM    532  CG2 ILE   104      39.176 -25.610   7.273  1.00 71.84      A    C  
ATOM    533  C   ILE   104      36.840 -25.745   8.930  1.00 72.09      A    C  
ATOM    534  O   ILE   104      37.025 -26.603   9.804  1.00 75.02      A    O  
ATOM    535  N   ILE   105      35.952 -25.885   7.951  1.00 69.18      A    N  
ATOM    536  CA  ILE   105      35.303 -27.162   7.691  1.00 69.78      A    C  
ATOM    537  CB  ILE   105      33.883 -26.988   7.109  1.00 68.99      A    C  
ATOM    538  CG1 ILE   105      33.034 -26.087   8.021  1.00 70.06      A    C  
ATOM    539  CD1 ILE   105      31.766 -25.553   7.376  1.00 68.53      A    C  
ATOM    540  CG2 ILE   105      33.218 -28.359   6.902  1.00 69.89      A    C  
ATOM    541  C   ILE   105      36.177 -27.947   6.721  1.00 69.20      A    C  
ATOM    542  O   ILE   105      36.321 -27.559   5.557  1.00 67.81      A    O  
ATOM    543  N   LYS   106      36.768 -29.036   7.213  1.00 71.18      A    N  
ATOM    544  CA  LYS   106      37.645 -29.901   6.409  1.00 71.31      A    C  
ATOM    545  CB  LYS   106      38.240 -31.027   7.268  1.00 74.66      A    C  
ATOM    546  CG  LYS   106      39.235 -30.553   8.327  1.00 78.99      A    C  
ATOM    547  CD  LYS   106      39.729 -31.711   9.190  1.00 83.40      A    C  
ATOM    550  C   LYS   106      36.906 -30.487   5.204  1.00 68.56      A    C  
ATOM    551  O   LYS   106      35.686 -30.651   5.238  1.00 67.81      A    O  
ATOM    552  N   TRP   107      37.645 -30.803   4.143  1.00 67.47      A    N  
ATOM    553  CA  TRP   107      37.031 -31.309   2.911  1.00 66.13      A    C  
ATOM    554  CB  TRP   107      38.099 -31.666   1.875  1.00 65.53      A    C  
ATOM    555  CG  TRP   107      37.617 -32.592   0.793  1.00 64.63      A    C  
ATOM    556  CD1 TRP   107      37.749 -33.948   0.764  1.00 64.45      A    C  
ATOM    557  NE1 TRP   107      37.178 -34.455  -0.377  1.00 65.36      A    N  
ATOM    558  CE2 TRP   107      36.661 -33.425  -1.117  1.00 63.71      A    C  
ATOM    559  CD2 TRP   107      36.913 -32.231  -0.408  1.00 63.14      A    C  
ATOM    560  CE3 TRP   107      36.481 -31.017  -0.957  1.00 60.76      A    C  
ATOM    561  CZ3 TRP   107      35.822 -31.035  -2.188  1.00 63.26      A    C  
ATOM    562  CH2 TRP   107      35.583 -32.242  -2.864  1.00 62.56      A    C  
ATOM    563  CZ2 TRP   107      35.996 -33.441  -2.350  1.00 63.71      A    C  
ATOM    564  C   TRP   107      36.088 -32.487   3.158  1.00 68.02      A    C  
ATOM    565  O   TRP   107      35.038 -32.587   2.516  1.00 67.19      A    O  
ATOM    566  N   GLN   108      36.462 -33.367   4.090  1.00 81.54      A    N  
ATOM    567  CA  GLN   108      35.651 -34.544   4.428  1.00 86.61      A    C  
ATOM    568  CB  GLN   108      36.355 -35.444   5.453  1.00 94.14      A    C  
ATOM    569  CG  GLN   108      37.838 -35.684   5.202  1.00100.96      A    C  
ATOM    570  CD  GLN   108      38.722 -34.745   6.006  1.00102.76      A    C  
ATOM    571  OE1 GLN   108      39.223 -33.746   5.486  1.00 97.70      A    O  
ATOM    572  NE2 GLN   108      38.908 -35.060   7.288  1.00109.40      A    N  
ATOM    573  C   GLN   108      34.288 -34.148   4.977  1.00 84.65      A    C  
ATOM    574  O   GLN   108      33.279 -34.788   4.683  1.00 85.99      A    O  
ATOM    575  N   ASP   109      34.272 -33.087   5.776  1.00 83.07      A    N  
ATOM    576  CA  ASP   109      33.076 -32.667   6.485  1.00 82.93      A    C  
ATOM    577  CB  ASP   109      33.458 -32.054   7.837  1.00 85.14      A    C  
ATOM    578  CG  ASP   109      33.997 -33.091   8.823  1.00 92.55      A    C  
ATOM    579  OD1 ASP   109      33.546 -34.258   8.794  1.00 96.19      A    O  
ATOM    580  OD2 ASP   109      34.871 -32.738   9.637  1.00 95.06      A    O  
ATOM    581  C   ASP   109      32.200 -31.720   5.661  1.00 77.96      A    C  
ATOM    582  O   ASP   109      31.094 -31.376   6.079  1.00 78.84      A    O  
ATOM    583  N   LEU   110      32.685 -31.320   4.488  1.00 74.26      A    N  
ATOM    584  CA  LEU   110      31.899 -30.489   3.577  1.00 70.92      A    C  
ATOM    585  CB  LEU   110      32.768 -29.936   2.443  1.00 67.27      A    C  
ATOM    586  CG  LEU   110      33.781 -28.845   2.798  1.00 65.09      A    C  
ATOM    587  CD1 LEU   110      34.700 -28.569   1.631  1.00 63.20      A    C  
ATOM    588  CD2 LEU   110      33.085 -27.570   3.234  1.00 62.99      A    C  
ATOM    589  C   LEU   110      30.732 -31.285   3.010  1.00 73.58      A    C  
ATOM    590  O   LEU   110      30.908 -32.409   2.549  1.00 76.26      A    O  
ATOM    591  N   GLU   111      29.540 -30.700   3.062  1.00 74.24      A    N  
ATOM    592  CA  GLU   111      28.329 -31.373   2.607  1.00 78.02      A    C  
ATOM    593  CB  GLU   111      27.497 -31.848   3.800  1.00 82.71      A    C  
ATOM    594  CG  GLU   111      28.116 -33.011   4.560  1.00 90.53      A    C  
ATOM    595  CD  GLU   111      27.602 -33.126   5.988  1.00 98.41      A    C  
ATOM    596  OE1 GLU   111      26.455 -33.590   6.180  1.00102.57      A    O  
ATOM    597  OE2 GLU   111      28.355 -32.761   6.920  1.00100.99      A    O  
ATOM    598  C   GLU   111      27.490 -30.469   1.715  1.00 76.64      A    C  
ATOM    599  O   GLU   111      27.457 -29.251   1.901  1.00 75.67      A    O  
ATOM    600  N   VAL   112      26.813 -31.083   0.749  1.00 78.34      A    N  
ATOM    601  CA  VAL   112      25.915 -30.384  -0.168  1.00 77.86      A    C  
ATOM    602  CB  VAL   112      25.330 -31.365  -1.218  1.00 81.46      A    C  
ATOM    603  CG1 VAL   112      24.284 -30.689  -2.078  1.00 82.23      A    C  
ATOM    604  CG2 VAL   112      26.442 -31.937  -2.088  1.00 78.08      A    C  
ATOM    605  C   VAL   112      24.794 -29.655   0.586  1.00 80.43      A    C  
ATOM    606  O   VAL   112      24.029 -30.264   1.345  1.00 83.79      A    O  
ATOM    607  N   GLY   113      24.722 -28.342   0.386  1.00 79.05      A    N  
ATOM    608  CA  GLY   113      23.639 -27.542   0.943  1.00 82.32      A    C  
ATOM    609  C   GLY   113      24.029 -26.621   2.082  1.00 81.33      A    C  
ATOM    610  O   GLY   113      23.254 -25.742   2.463  1.00 84.67      A    O  
ATOM    611  N   GLN   114      25.226 -26.827   2.628  1.00 77.51      A    N  
ATOM    612  CA  GLN   114      25.771 -25.961   3.668  1.00 76.18      A    C  
ATOM    613  CB  GLN   114      27.088 -26.527   4.198  1.00 74.01      A    C  
ATOM    614  CG  GLN   114      26.983 -27.842   4.950  1.00 78.35      A    C  
ATOM    615  CD  GLN   114      28.343 -28.391   5.344  1.00 76.40      A    C  
ATOM    616  OE1 GLN   114      29.316 -28.243   4.614  1.00 73.16      A    O  
ATOM    617  NE2 GLN   114      28.412 -29.031   6.502  1.00 82.18      A    N  
ATOM    618  C   GLN   114      26.038 -24.559   3.130  1.00 73.65      A    C  
ATOM    619  O   GLN   114      26.486 -24.404   1.987  1.00 70.71      A    O  
ATOM    620  N   VAL   115      25.760 -23.544   3.949  1.00 75.05      A    N  
ATOM    621  CA  VAL   115      26.222 -22.194   3.640  1.00 72.83      A    C  
ATOM    622  CB  VAL   115      25.147 -21.100   3.813  1.00 76.99      A    C  
ATOM    623  CG1 VAL   115      23.943 -21.419   2.939  1.00 81.10      A    C  
ATOM    624  CG2 VAL   115      24.744 -20.935   5.272  1.00 83.11      A    C  
ATOM    625  C   VAL   115      27.496 -21.896   4.416  1.00 70.02      A    C  
ATOM    626  O   VAL   115      27.543 -21.972   5.652  1.00 71.87      A    O  
ATOM    627  N   VAL   116      28.535 -21.575   3.657  1.00 65.64      A    N  
ATOM    628  CA  VAL   116      29.880 -21.463   4.175  1.00 63.59      A    C  
ATOM    629  CB  VAL   116      30.730 -22.663   3.704  1.00 62.16      A    C  
ATOM    630  CG1 VAL   116      30.220 -23.965   4.306  1.00 63.67      A    C  
ATOM    631  CG2 VAL   116      30.729 -22.751   2.189  1.00 60.61      A    C  
ATOM    632  C   VAL   116      30.519 -20.168   3.671  1.00 62.26      A    C  
ATOM    633  O   VAL   116      29.996 -19.539   2.752  1.00 61.77      A    O  
ATOM    634  N   MET   117      31.639 -19.770   4.276  1.00 61.42      A    N  
ATOM    635  CA  MET   117      32.456 -18.698   3.712  1.00 60.96      A    C  
ATOM    636  CB  MET   117      32.820 -17.642   4.757  1.00 61.90      A    C  
ATOM    637  CG  MET   117      33.221 -16.318   4.116  1.00 62.48      A    C  
ATOM    638  SD  MET   117      33.916 -15.018   5.390  1.00 66.12      A   SE  
ATOM    639  CE  MET   117      35.602 -15.886   5.817  1.00 66.17      A    C  
ATOM    640  C   MET   117      33.716 -19.269   3.064  1.00 58.29      A    C  
ATOM    641  O   MET   117      34.464 -20.014   3.688  1.00 59.06      A    O  
ATOM    642  N   LEU   118      33.946 -18.901   1.812  1.00 57.12      A    N  
ATOM    643  CA  LEU   118      35.039 -19.463   1.034  1.00 56.29      A    C  
ATOM    644  CB  LEU   118      34.557 -20.698   0.265  1.00 56.76      A    C  
ATOM    645  CG  LEU   118      33.252 -20.615  -0.531  1.00 57.64      A    C  
ATOM    646  CD1 LEU   118      33.420 -19.891  -1.874  1.00 59.59      A    C  
ATOM    647  CD2 LEU   118      32.730 -22.021  -0.747  1.00 60.22      A    C  
ATOM    648  C   LEU   118      35.646 -18.452   0.064  1.00 56.96      A    C  
ATOM    649  O   LEU   118      35.047 -17.412  -0.233  1.00 57.12      A    O  
ATOM    650  N   ASN   119      36.832 -18.789  -0.438  1.00 56.86      A    N  
ATOM    651  CA  ASN   119      37.591 -17.907  -1.306  1.00 57.26      A    C  
ATOM    652  CB  ASN   119      39.094 -18.065  -1.047  1.00 58.13      A    C  
ATOM    653  CG  ASN   119      39.881 -16.825  -1.412  1.00 59.37      A    C  
ATOM    654  OD1 ASN   119      40.059 -16.510  -2.592  1.00 52.64      A    O  
ATOM    655  ND2 ASN   119      40.346 -16.097  -0.389  1.00 56.44      A    N  
ATOM    656  C   ASN   119      37.264 -18.177  -2.756  1.00 58.04      A    C  
ATOM    657  O   ASN   119      37.354 -19.312  -3.229  1.00 59.26      A    O  
ATOM    658  N   TYR   120      36.866 -17.127  -3.459  1.00 58.92      A    N  
ATOM    659  CA  TYR   120      36.514 -17.235  -4.856  1.00 58.75      A    C  
ATOM    660  CB  TYR   120      35.028 -17.595  -4.993  1.00 60.08      A    C  
ATOM    661  CG  TYR   120      34.561 -17.864  -6.416  1.00 63.34      A    C  
ATOM    662  CD1 TYR   120      35.007 -18.984  -7.126  1.00 65.99      A    C  
ATOM    663  CE1 TYR   120      34.575 -19.233  -8.437  1.00 67.83      A    C  
ATOM    664  CZ  TYR   120      33.681 -18.356  -9.046  1.00 74.16      A    C  
ATOM    665  OH  TYR   120      33.240 -18.592 -10.343  1.00 80.05      A    O  
ATOM    666  CE2 TYR   120      33.219 -17.243  -8.356  1.00 72.18      A    C  
ATOM    667  CD2 TYR   120      33.662 -17.003  -7.047  1.00 68.44      A    C  
ATOM    668  C   TYR   120      36.837 -15.934  -5.568  1.00 61.83      A    C  
ATOM    669  O   TYR   120      36.938 -14.887  -4.938  1.00 58.65      A    O  
ATOM    670  N   ASN   121      36.987 -16.005  -6.894  1.00 66.19      A    N  
ATOM    671  CA  ASN   121      37.288 -14.834  -7.695  1.00 69.65      A    C  
ATOM    672  CB  ASN   121      38.759 -14.832  -8.091  1.00 71.49      A    C  
ATOM    673  CG  ASN   121      39.213 -13.497  -8.646  1.00 78.45      A    C  
ATOM    674  OD1 ASN   121      38.577 -12.918  -9.538  1.00 85.52      A    O  
ATOM    675  ND2 ASN   121      40.341 -13.013  -8.144  1.00 77.55      A    N  
ATOM    676  C   ASN   121      36.384 -14.766  -8.924  1.00 77.49      A    C  
ATOM    677  O   ASN   121      36.703 -15.335  -9.972  1.00 78.65      A    O  
ATOM    678  N   PRO   122      35.246 -14.063  -8.791  1.00 80.08      A    N  
ATOM    679  CA  PRO   122      34.210 -13.957  -9.812  1.00 86.20      A    C  
ATOM    680  CB  PRO   122      33.292 -12.865  -9.259  1.00 86.42      A    C  
ATOM    681  CG  PRO   122      33.448 -12.974  -7.791  1.00 82.10      A    C  
ATOM    682  CD  PRO   122      34.890 -13.316  -7.567  1.00 76.62      A    C  
ATOM    683  C   PRO   122      34.740 -13.582 -11.205  1.00 95.34      A    C  
ATOM    684  O   PRO   122      34.304 -14.165 -12.200  1.00 98.08      A    O  
ATOM    685  N   ASP   123      35.680 -12.637 -11.255  1.00 98.70      A    N  
ATOM    686  CA  ASP   123      36.210 -12.096 -12.512  1.00107.79      A    C  
ATOM    687  CB  ASP   123      36.952 -10.783 -12.250  1.00110.01      A    C  
ATOM    688  CG  ASP   123      36.012  -9.599 -12.080  1.00113.62      A    C  
ATOM    689  OD1 ASP   123      35.072  -9.457 -12.894  1.00118.87      A    O  
ATOM    690  OD2 ASP   123      36.223  -8.800 -11.140  1.00109.85      A    O  
ATOM    691  C   ASP   123      37.124 -13.073 -13.247  1.00110.22      A    C  
ATOM    692  O   ASP   123      37.163 -13.092 -14.484  1.00119.05      A    O  
ATOM    693  N   ASN   124      37.868 -13.860 -12.472  1.00104.22      A    N  
ATOM    694  CA  ASN   124      38.691 -14.958 -12.984  1.00106.51      A    C  
ATOM    695  CB  ASN   124      40.090 -14.477 -13.400  1.00111.43      A    C  
ATOM    696  CG  ASN   124      40.625 -13.375 -12.508  1.00109.34      A    C  
ATOM    697  OD1 ASN   124      40.850 -12.255 -12.961  1.00114.42      A    O  
ATOM    698  ND2 ASN   124      40.823 -13.685 -11.229  1.00102.69      A    N  
ATOM    699  C   ASN   124      38.754 -16.096 -11.960  1.00 99.63      A    C  
ATOM    700  O   ASN   124      39.585 -16.073 -11.036  1.00 94.87      A    O  
ATOM    701  N   PRO   125      37.834 -17.072 -12.096  1.00 98.76      A    N  
ATOM    702  CA  PRO   125      37.609 -18.161 -11.135  1.00 93.07      A    C  
ATOM    703  CB  PRO   125      36.475 -18.965 -11.787  1.00 95.03      A    C  
ATOM    704  CG  PRO   125      35.763 -17.960 -12.623  1.00100.37      A    C  
ATOM    705  CD  PRO   125      36.874 -17.146 -13.209  1.00104.85      A    C  
ATOM    706  C   PRO   125      38.812 -19.059 -10.845  1.00 92.16      A    C  
ATOM    707  O   PRO   125      38.794 -19.805  -9.862  1.00 88.10      A    O  
ATOM    708  N   LYS   126      39.842 -18.980 -11.681  1.00 97.48      A    N  
ATOM    709  CA  LYS   126      41.031 -19.804 -11.512  1.00 97.83      A    C  
ATOM    710  CB  LYS   126      41.771 -19.925 -12.846  1.00106.86      A    C  
ATOM    711  CG  LYS   126      42.246 -21.332 -13.163  1.00110.33      A    C  
ATOM    712  CD  LYS   126      42.605 -21.471 -14.634  1.00120.99      A    C  
ATOM    715  C   LYS   126      41.958 -19.245 -10.424  1.00 93.86      A    C  
ATOM    716  O   LYS   126      42.812 -19.961  -9.895  1.00 93.82      A    O  
ATOM    717  N   GLU   127      41.772 -17.973 -10.080  1.00 90.96      A    N  
ATOM    718  CA  GLU   127      42.707 -17.271  -9.204  1.00 89.03      A    C  
ATOM    719  CB  GLU   127      43.092 -15.909  -9.803  1.00 93.54      A    C  
ATOM    720  CG  GLU   127      43.371 -15.901 -11.315  1.00103.30      A    C  
ATOM    721  CD  GLU   127      44.637 -16.650 -11.711  1.00110.07      A    C  
ATOM    722  OE1 GLU   127      45.603 -16.662 -10.911  1.00107.71      A    O  
ATOM    723  OE2 GLU   127      44.666 -17.215 -12.835  1.00117.64      A    O  
ATOM    724  C   GLU   127      42.157 -17.070  -7.795  1.00 81.22      A    C  
ATOM    725  O   GLU   127      40.973 -17.283  -7.540  1.00 77.05      A    O  
ATOM    726  N   ARG   128      43.042 -16.663  -6.890  1.00 79.99      A    N  
ATOM    727  CA  ARG   128      42.665 -16.219  -5.550  1.00 75.18      A    C  
ATOM    728  CB  ARG   128      43.931 -15.974  -4.728  1.00 76.60      A    C  
ATOM    729  CG  ARG   128      43.724 -15.886  -3.242  1.00 73.49      A    C  
ATOM    730  CD  ARG   128      44.193 -17.147  -2.542  1.00 75.64      A    C  
ATOM    731  NE  ARG   128      43.646 -17.232  -1.188  1.00 72.47      A    N  
ATOM    732  CZ  ARG   128      43.729 -18.300  -0.402  1.00 70.66      A    C  
ATOM    733  NH1 ARG   128      44.344 -19.402  -0.816  1.00 72.28      A    N  
ATOM    734  NH2 ARG   128      43.187 -18.265   0.806  1.00 68.19      A    N  
ATOM    735  C   ARG   128      41.853 -14.923  -5.645  1.00 73.74      A    C  
ATOM    736  O   ARG   128      42.171 -14.051  -6.458  1.00 78.40      A    O  
ATOM    737  N   GLY   129      40.801 -14.816  -4.832  1.00 68.65      A    N  
ATOM    738  CA  GLY   129      39.968 -13.607  -4.753  1.00 67.08      A    C  
ATOM    739  C   GLY   129      39.572 -13.235  -3.324  1.00 63.44      A    C  
ATOM    740  O   GLY   129      40.431 -13.034  -2.461  1.00 62.31      A    O  
ATOM    741  N   PHE   130      38.265 -13.163  -3.078  1.00 61.38      A    N  
ATOM    742  CA  PHE   130      37.728 -12.673  -1.812  1.00 59.66      A    C  
ATOM    743  CB  PHE   130      36.996 -11.352  -2.025  1.00 63.17      A    C  
ATOM    744  CG  PHE   130      37.902 -10.225  -2.408  1.00 68.02      A    C  
ATOM    745  CD1 PHE   130      38.714  -9.614  -1.451  1.00 66.81      A    C  
ATOM    746  CE1 PHE   130      39.567  -8.575  -1.803  1.00 70.40      A    C  
ATOM    747  CZ  PHE   130      39.615  -8.142  -3.122  1.00 73.35      A    C  
ATOM    748  CE2 PHE   130      38.814  -8.750  -4.085  1.00 74.05      A    C  
ATOM    749  CD2 PHE   130      37.966  -9.788  -3.726  1.00 69.66      A    C  
ATOM    750  C   PHE   130      36.801 -13.666  -1.143  1.00 57.34      A    C  
ATOM    751  O   PHE   130      36.334 -14.608  -1.796  1.00 55.77      A    O  
ATOM    752  N   TRP   131      36.561 -13.442   0.159  1.00 49.70      A    N  
ATOM    753  CA  TRP   131      35.706 -14.272   0.989  1.00 51.23      A    C  
ATOM    754  CB  TRP   131      36.162 -14.149   2.445  1.00 50.95      A    C  
ATOM    755  CG  TRP   131      37.572 -14.545   2.508  1.00 47.90      A    C  
ATOM    756  CD1 TRP   131      38.665 -13.738   2.335  1.00 46.38      A    C  
ATOM    757  NE1 TRP   131      39.818 -14.490   2.399  1.00 43.72      A    N  
ATOM    758  CE2 TRP   131      39.480 -15.811   2.579  1.00 43.47      A    C  
ATOM    759  CD2 TRP   131      38.070 -15.884   2.632  1.00 47.54      A    C  
ATOM    760  CE3 TRP   131      37.460 -17.139   2.809  1.00 50.34      A    C  
ATOM    761  CZ3 TRP   131      38.272 -18.267   2.948  1.00 49.31      A    C  
ATOM    762  CH2 TRP   131      39.676 -18.159   2.898  1.00 47.35      A    C  
ATOM    763  CZ2 TRP   131      40.296 -16.946   2.703  1.00 45.25      A    C  
ATOM    764  C   TRP   131      34.214 -13.976   0.855  1.00 56.74      A    C  
ATOM    765  O   TRP   131      33.694 -13.045   1.493  1.00 58.95      A    O  
ATOM    766  N   TYR   132      33.546 -14.787   0.027  1.00 57.70      A    N  
ATOM    767  CA  TYR   132      32.093 -14.756  -0.155  1.00 62.06      A    C  
ATOM    768  CB  TYR   132      31.738 -14.902  -1.640  1.00 64.36      A    C  
ATOM    769  CG  TYR   132      32.346 -13.845  -2.512  1.00 66.16      A    C  
ATOM    770  CD1 TYR   132      31.693 -12.636  -2.724  1.00 69.59      A    C  
ATOM    771  CE1 TYR   132      32.252 -11.656  -3.516  1.00 70.75      A    C  
ATOM    772  CZ  TYR   132      33.480 -11.880  -4.109  1.00 68.34      A    C  
ATOM    773  OH  TYR   132      34.038 -10.905  -4.903  1.00 72.83      A    O  
ATOM    774  CE2 TYR   132      34.149 -13.073  -3.917  1.00 64.55      A    C  
ATOM    775  CD2 TYR   132      33.579 -14.048  -3.122  1.00 64.03      A    C  
ATOM    776  C   TYR   132      31.413 -15.900   0.577  1.00 61.98      A    C  
ATOM    777  O   TYR   132      32.010 -16.959   0.773  1.00 60.18      A    O  
ATOM    778  N   ASP   133      30.155 -15.686   0.959  1.00 64.85      A    N  
ATOM    779  CA  ASP   133      29.273 -16.783   1.352  1.00 65.55      A    C  
ATOM    780  CB  ASP   133      28.057 -16.258   2.099  1.00 68.42      A    C  
ATOM    781  CG  ASP   133      28.402 -15.750   3.477  1.00 69.42      A    C  
ATOM    782  OD1 ASP   133      29.599 -15.713   3.823  1.00 64.53      A    O  
ATOM    783  OD2 ASP   133      27.468 -15.378   4.215  1.00 76.31      A    O  
ATOM    784  C   ASP   133      28.823 -17.591   0.136  1.00 66.63      A    C  
ATOM    785  O   ASP   133      28.615 -17.038  -0.950  1.00 67.26      A    O  
ATOM    786  N   ALA   134      28.668 -18.897   0.333  1.00 65.82      A    N  
ATOM    787  CA  ALA   134      28.311 -19.804  -0.745  1.00 67.57      A    C  
ATOM    788  CB  ALA   134      29.558 -20.239  -1.510  1.00 64.02      A    C  
ATOM    789  C   ALA   134      27.558 -21.022  -0.232  1.00 69.20      A    C  
ATOM    790  O   ALA   134      27.790 -21.492   0.884  1.00 68.34      A    O  
ATOM    791  N   GLU   135      26.655 -21.525  -1.066  1.00 72.04      A    N  
ATOM    792  CA  GLU   135      25.925 -22.744  -0.785  1.00 72.93      A    C  
ATOM    793  CB  GLU   135      24.484 -22.591  -1.263  1.00 77.11      A    C  
ATOM    794  CG  GLU   135      23.524 -23.682  -0.821  1.00 78.37      A    C  
ATOM    795  CD  GLU   135      22.088 -23.368  -1.212  1.00 84.76      A    C  
ATOM    796  OE1 GLU   135      21.844 -23.039  -2.399  1.00 85.93      A    O  
ATOM    797  OE2 GLU   135      21.203 -23.447  -0.328  1.00 88.15      A    O  
ATOM    798  C   GLU   135      26.616 -23.878  -1.529  1.00 71.76      A    C  
ATOM    799  O   GLU   135      26.707 -23.854  -2.758  1.00 73.06      A    O  
ATOM    800  N   ILE   136      27.121 -24.862  -0.792  1.00 69.88      A    N  
ATOM    801  CA  ILE   136      27.764 -26.015  -1.425  1.00 68.91      A    C  
ATOM    802  CB  ILE   136      28.472 -26.926  -0.400  1.00 67.43      A    C  
ATOM    803  CG1 ILE   136      29.694 -26.201   0.170  1.00 62.29      A    C  
ATOM    804  CD1 ILE   136      29.976 -26.548   1.601  1.00 63.43      A    C  
ATOM    805  CG2 ILE   136      28.913 -28.244  -1.043  1.00 67.94      A    C  
ATOM    806  C   ILE   136      26.741 -26.759  -2.275  1.00 72.33      A    C  
ATOM    807  O   ILE   136      25.671 -27.145  -1.795  1.00 74.69      A    O  
ATOM    808  N   SER   137      27.080 -26.921  -3.548  1.00 72.39      A    N  
ATOM    809  CA  SER   137      26.134 -27.344  -4.560  1.00 76.27      A    C  
ATOM    810  CB  SER   137      26.209 -26.382  -5.745  1.00 76.90      A    C  
ATOM    811  OG  SER   137      25.221 -26.684  -6.705  1.00 82.68      A    O  
ATOM    812  C   SER   137      26.401 -28.785  -5.001  1.00 77.57      A    C  
ATOM    813  O   SER   137      25.517 -29.638  -4.931  1.00 79.63      A    O  
ATOM    814  N   ARG   138      27.628 -29.038  -5.451  1.00 76.31      A    N  
ATOM    815  CA  ARG   138      28.067 -30.361  -5.869  1.00 77.35      A    C  
ATOM    816  CB  ARG   138      28.178 -30.448  -7.393  1.00 79.55      A    C  
ATOM    817  CG  ARG   138      26.877 -30.215  -8.119  1.00 85.11      A    C  
ATOM    818  CD  ARG   138      26.947 -30.659  -9.564  1.00 89.42      A    C  
ATOM    819  NE  ARG   138      27.580 -29.666 -10.429  1.00 89.97      A    N  
ATOM    820  CZ  ARG   138      28.649 -29.898 -11.183  1.00 89.04      A    C  
ATOM    821  NH1 ARG   138      29.145 -28.930 -11.941  1.00 88.78      A    N  
ATOM    822  NH2 ARG   138      29.218 -31.098 -11.191  1.00 89.11      A    N  
ATOM    823  C   ARG   138      29.419 -30.657  -5.251  1.00 74.79      A    C  
ATOM    824  O   ARG   138      30.264 -29.765  -5.126  1.00 71.88      A    O  
ATOM    825  N   LYS   139      29.613 -31.914  -4.866  1.00 75.98      A    N  
ATOM    826  CA  LYS   139      30.874 -32.372  -4.306  1.00 74.86      A    C  
ATOM    827  CB  LYS   139      30.779 -32.469  -2.782  1.00 73.48      A    C  
ATOM    828  CG  LYS   139      32.087 -32.834  -2.115  1.00 71.58      A    C  
ATOM    829  CD  LYS   139      31.904 -32.996  -0.626  1.00 72.19      A    C  
ATOM    830  CE  LYS   139      33.155 -33.579  -0.006  1.00 72.78      A    C  
ATOM    831  NZ  LYS   139      32.987 -33.821   1.453  1.00 73.28      A    N  
ATOM    832  C   LYS   139      31.272 -33.712  -4.933  1.00 77.81      A    C  
ATOM    833  O   LYS   139      30.529 -34.697  -4.856  1.00 79.78      A    O  
ATOM    834  N   ARG   140      32.446 -33.724  -5.561  1.00 77.81      A    N  
ATOM    835  CA  ARG   140      32.943 -34.878  -6.310  1.00 80.86      A    C  
ATOM    836  CB  ARG   140      32.831 -34.614  -7.815  1.00 83.30      A    C  
ATOM    837  CG  ARG   140      31.731 -35.391  -8.524  1.00 91.05      A    C  
ATOM    838  CD  ARG   140      32.212 -36.778  -8.943  1.00 96.65      A    C  
ATOM    839  NE  ARG   140      33.416 -36.699  -9.771  1.00 98.96      A    N  
ATOM    840  CZ  ARG   140      33.469 -36.995 -11.067  1.00103.38      A    C  
ATOM    841  NH1 ARG   140      32.384 -37.411 -11.709  1.00108.22      A    N  
ATOM    842  NH2 ARG   140      34.617 -36.887 -11.723  1.00103.90      A    N  
ATOM    843  C   ARG   140      34.393 -35.183  -5.967  1.00 79.17      A    C  
ATOM    844  O   ARG   140      35.221 -34.279  -5.877  1.00 76.53      A    O  
ATOM    845  N   GLU   141      34.702 -36.461  -5.784  1.00 80.97      A    N  
ATOM    846  CA  GLU   141      36.079 -36.872  -5.552  1.00 80.09      A    C  
ATOM    847  CB  GLU   141      36.318 -37.213  -4.081  1.00 78.65      A    C  
ATOM    848  CG  GLU   141      37.779 -37.137  -3.680  1.00 78.55      A    C  
ATOM    849  CD  GLU   141      38.015 -37.247  -2.182  1.00 77.93      A    C  
ATOM    850  OE1 GLU   141      37.038 -37.196  -1.405  1.00 78.44      A    O  
ATOM    851  OE2 GLU   141      39.194 -37.383  -1.781  1.00 77.29      A    O  
ATOM    852  C   GLU   141      36.508 -38.020  -6.465  1.00 83.79      A    C  
ATOM    853  O   GLU   141      35.761 -38.959  -6.720  1.00 86.12      A    O  
ATOM    854  N   THR   142      37.732 -37.899  -6.956  1.00 63.92      A    N  
ATOM    855  CA  THR   142      38.372 -38.851  -7.848  1.00 63.74      A    C  
ATOM    856  CB  THR   142      38.654 -38.156  -9.215  1.00 66.30      A    C  
ATOM    857  OG1 THR   142      37.666 -38.567 -10.168  1.00 66.73      A    O  
ATOM    858  CG2 THR   142      40.026 -38.473  -9.776  1.00 71.31      A    C  
ATOM    859  C   THR   142      39.630 -39.330  -7.117  1.00 63.29      A    C  
ATOM    860  O   THR   142      39.944 -38.823  -6.025  1.00 64.51      A    O  
ATOM    861  N   ARG   143      40.326 -40.317  -7.675  1.00 63.14      A    N  
ATOM    862  CA  ARG   143      41.597 -40.770  -7.109  1.00 63.64      A    C  
ATOM    863  CB  ARG   143      42.221 -41.858  -7.977  1.00 64.32      A    C  
ATOM    864  CG  ARG   143      41.596 -43.245  -7.869  1.00 64.07      A    C  
ATOM    865  CD  ARG   143      42.347 -44.211  -8.831  1.00 64.06      A    C  
ATOM    866  NE  ARG   143      41.787 -45.568  -8.930  1.00 62.34      A    N  
ATOM    867  CZ  ARG   143      41.671 -46.437  -7.915  1.00 62.98      A    C  
ATOM    868  NH1 ARG   143      42.045 -46.114  -6.669  1.00 52.94      A    N  
ATOM    869  NH2 ARG   143      41.163 -47.643  -8.148  1.00 61.64      A    N  
ATOM    870  C   ARG   143      42.601 -39.619  -6.916  1.00 65.93      A    C  
ATOM    871  O   ARG   143      43.346 -39.596  -5.929  1.00 67.55      A    O  
ATOM    872  N   THR   144      42.601 -38.666  -7.848  1.00 67.27      A    N  
ATOM    873  CA  THR   144      43.565 -37.562  -7.855  1.00 71.21      A    C  
ATOM    874  CB  THR   144      44.425 -37.591  -9.130  1.00 74.46      A    C  
ATOM    875  OG1 THR   144      43.566 -37.704 -10.270  1.00 74.50      A    O  
ATOM    876  CG2 THR   144      45.397 -38.767  -9.108  1.00 73.69      A    C  
ATOM    877  C   THR   144      42.938 -36.165  -7.756  1.00 73.03      A    C  
ATOM    878  O   THR   144      43.651 -35.186  -7.568  1.00 77.46      A    O  
ATOM    879  N   ALA   145      41.617 -36.073  -7.882  1.00 71.51      A    N  
ATOM    880  CA  ALA   145      40.935 -34.776  -7.947  1.00 73.21      A    C  
ATOM    881  CB  ALA   145      40.374 -34.544  -9.350  1.00 74.63      A    C  
ATOM    882  C   ALA   145      39.825 -34.619  -6.906  1.00 70.73      A    C  
ATOM    883  O   ALA   145      39.049 -35.544  -6.667  1.00 68.81      A    O  
ATOM    884  N   ARG   146      39.765 -33.441  -6.291  1.00 72.52      A    N  
ATOM    885  CA  ARG   146      38.660 -33.067  -5.401  1.00 71.12      A    C  
ATOM    886  CB  ARG   146      39.164 -32.716  -4.001  1.00 70.21      A    C  
ATOM    887  CG  ARG   146      39.659 -33.912  -3.215  1.00 70.44      A    C  
ATOM    888  CD  ARG   146      40.246 -33.502  -1.882  1.00 72.19      A    C  
ATOM    889  NE  ARG   146      41.331 -32.537  -2.043  1.00 76.34      A    N  
ATOM    890  CZ  ARG   146      41.717 -31.677  -1.105  1.00 79.37      A    C  
ATOM    891  NH1 ARG   146      41.109 -31.647   0.073  1.00 79.76      A    N  
ATOM    892  NH2 ARG   146      42.708 -30.834  -1.349  1.00 84.02      A    N  
ATOM    893  C   ARG   146      37.908 -31.892  -6.008  1.00 72.38      A    C  
ATOM    894  O   ARG   146      38.483 -30.830  -6.257  1.00 76.52      A    O  
ATOM    895  N   GLU   147      36.620 -32.088  -6.255  1.00 70.89      A    N  
ATOM    896  CA  GLU   147      35.828 -31.092  -6.962  1.00 72.27      A    C  
ATOM    897  CB  GLU   147      35.261 -31.688  -8.251  1.00 73.83      A    C  
ATOM    898  CG  GLU   147      36.336 -32.129  -9.238  1.00 78.97      A    C  
ATOM    899  CD  GLU   147      35.844 -33.164 -10.233  1.00 82.68      A    C  
ATOM    900  OE1 GLU   147      34.708 -33.023 -10.738  1.00 85.63      A    O  
ATOM    901  OE2 GLU   147      36.602 -34.121 -10.510  1.00 83.65      A    O  
ATOM    902  C   GLU   147      34.718 -30.537  -6.081  1.00 69.40      A    C  
ATOM    903  O   GLU   147      33.914 -31.289  -5.531  1.00 67.18      A    O  
ATOM    904  N   LEU   148      34.692 -29.215  -5.949  1.00 69.74      A    N  
ATOM    905  CA  LEU   148      33.662 -28.544  -5.175  1.00 67.30      A    C  
ATOM    906  CB  LEU   148      34.243 -27.963  -3.884  1.00 66.54      A    C  
ATOM    907  CG  LEU   148      33.276 -27.429  -2.823  1.00 64.58      A    C  
ATOM    908  CD1 LEU   148      32.415 -28.550  -2.267  1.00 59.27      A    C  
ATOM    909  CD2 LEU   148      34.048 -26.727  -1.710  1.00 63.81      A    C  
ATOM    910  C   LEU   148      32.982 -27.463  -6.002  1.00 70.05      A    C  
ATOM    911  O   LEU   148      33.641 -26.629  -6.631  1.00 72.97      A    O  
ATOM    912  N   TYR   149      31.654 -27.507  -6.004  1.00 69.71      A    N  
ATOM    913  CA  TYR   149      30.842 -26.527  -6.707  1.00 71.79      A    C  
ATOM    914  CB  TYR   149      30.053 -27.187  -7.847  1.00 74.98      A    C  
ATOM    915  CG  TYR   149      30.963 -27.719  -8.929  1.00 78.32      A    C  
ATOM    916  CD1 TYR   149      31.505 -29.004  -8.844  1.00 76.82      A    C  
ATOM    917  CE1 TYR   149      32.363 -29.492  -9.827  1.00 79.06      A    C  
ATOM    918  CZ  TYR   149      32.694 -28.685 -10.903  1.00 84.35      A    C  
ATOM    919  OH  TYR   149      33.544 -29.160 -11.878  1.00 88.75      A    O  
ATOM    920  CE2 TYR   149      32.173 -27.404 -11.008  1.00 86.90      A    C  
ATOM    921  CD2 TYR   149      31.317 -26.926 -10.020  1.00 83.14      A    C  
ATOM    922  C   TYR   149      29.935 -25.839  -5.704  1.00 69.60      A    C  
ATOM    923  O   TYR   149      29.459 -26.466  -4.757  1.00 67.80      A    O  
ATOM    924  N   ALA   150      29.723 -24.543  -5.896  1.00 70.24      A    N  
ATOM    925  CA  ALA   150      28.964 -23.765  -4.941  1.00 68.76      A    C  
ATOM    926  CB  ALA   150      29.885 -23.235  -3.834  1.00 67.20      A    C  
ATOM    927  C   ALA   150      28.202 -22.625  -5.596  1.00 72.22      A    C  
ATOM    928  O   ALA   150      28.631 -22.069  -6.612  1.00 74.74      A    O  
ATOM    929  N   ASN   151      27.055 -22.303  -5.003  1.00 72.44      A    N  
ATOM    930  CA  ASN   151      26.300 -21.119  -5.350  1.00 76.20      A    C  
ATOM    931  CB  ASN   151      24.810 -21.330  -5.072  1.00 76.85      A    C  
ATOM    932  CG  ASN   151      24.247 -22.554  -5.770  1.00 79.45      A    C  
ATOM    933  OD1 ASN   151      24.580 -22.845  -6.918  1.00 79.71      A    O  
ATOM    934  ND2 ASN   151      23.380 -23.276  -5.073  1.00 80.94      A    N  
ATOM    935  C   ASN   151      26.839 -19.979  -4.507  1.00 76.24      A    C  
ATOM    936  O   ASN   151      26.602 -19.927  -3.295  1.00 75.45      A    O  
ATOM    937  N   VAL   152      27.584 -19.081  -5.143  1.00 79.41      A    N  
ATOM    938  CA  VAL   152      28.259 -17.990  -4.444  1.00 79.50      A    C  
ATOM    939  CB  VAL   152      29.614 -17.661  -5.119  1.00 82.99      A    C  
ATOM    940  CG1 VAL   152      30.288 -16.454  -4.472  1.00 83.32      A    C  
ATOM    941  CG2 VAL   152      30.527 -18.868  -5.071  1.00 80.21      A    C  
ATOM    942  C   VAL   152      27.350 -16.759  -4.391  1.00 82.04      A    C  
ATOM    943  O   VAL   152      26.821 -16.325  -5.418  1.00 85.53      A    O  
ATOM    944  N   VAL   153      27.170 -16.213  -3.190  1.00 80.24      A    N  
ATOM    945  CA  VAL   153      26.318 -15.043  -2.970  1.00 81.79      A    C  
ATOM    946  CB  VAL   153      25.723 -15.040  -1.539  1.00 78.70      A    C  
ATOM    947  CG1 VAL   153      24.841 -13.821  -1.319  1.00 78.84      A    C  
ATOM    948  CG2 VAL   153      24.932 -16.323  -1.290  1.00 76.38      A    C  
ATOM    949  C   VAL   153      27.097 -13.751  -3.232  1.00 86.30      A    C  
ATOM    950  O   VAL   153      28.098 -13.467  -2.562  1.00 86.64      A    O  
ATOM    951  N   LEU   154      26.615 -12.970  -4.199  1.00 90.89      A    N  
ATOM    952  CA  LEU   154      27.335 -11.803  -4.699  1.00 96.61      A    C  
ATOM    953  CB  LEU   154      27.674 -12.010  -6.177  1.00102.18      A    C  
ATOM    954  CG  LEU   154      29.126 -11.829  -6.622  1.00107.79      A    C  
ATOM    955  CD1 LEU   154      29.946 -13.084  -6.325  1.00104.39      A    C  
ATOM    956  CD2 LEU   154      29.195 -11.476  -8.100  1.00115.33      A    C  
ATOM    957  C   LEU   154      26.523 -10.521  -4.528  1.00 98.73      A    C  
ATOM    958  O   LEU   154      26.057 -10.203  -3.430  1.00 95.85      A    O  
ATOM    959  N   ASP   156      20.327  -9.075  -2.880  1.00154.49      A    N  
ATOM    960  CA  ASP   156      21.569  -9.607  -3.441  1.00145.75      A    C  
ATOM    961  CB  ASP   156      22.488 -10.157  -2.331  1.00135.92      A    C  
ATOM    962  CG  ASP   156      21.872 -11.329  -1.568  1.00134.46      A    C  
ATOM    963  OD1 ASP   156      21.793 -12.447  -2.127  1.00132.68      A    O  
ATOM    964  OD2 ASP   156      21.490 -11.137  -0.394  1.00135.89      A    O  
ATOM    965  C   ASP   156      21.316 -10.670  -4.512  1.00145.37      A    C  
ATOM    966  O   ASP   156      20.268 -11.319  -4.518  1.00150.14      A    O  
ATOM    967  N   ASP   157      22.283 -10.837  -5.413  1.00140.52      A    N  
ATOM    968  CA  ASP   157      22.213 -11.861  -6.458  1.00139.58      A    C  
ATOM    969  CB  ASP   157      22.328 -11.238  -7.860  1.00145.97      A    C  
ATOM    970  CG  ASP   157      23.279 -10.046  -7.904  1.00145.70      A    C  
ATOM    971  OD1 ASP   157      22.852  -8.926  -7.545  1.00151.65      A    O  
ATOM    972  OD2 ASP   157      24.446 -10.224  -8.314  1.00140.51      A    O  
ATOM    973  C   ASP   157      23.284 -12.932  -6.249  1.00128.46      A    C  
ATOM    974  O   ASP   157      24.418 -12.619  -5.887  1.00122.38      A    O  
ATOM    975  N   SER   158      22.914 -14.192  -6.468  1.00126.34      A    N  
ATOM    976  CA  SER   158      23.850 -15.305  -6.310  1.00116.90      A    C  
ATOM    977  CB  SER   158      23.222 -16.443  -5.500  1.00115.95      A    C  
ATOM    978  OG  SER   158      22.159 -17.046  -6.211  1.00124.65      A    O  
ATOM    979  C   SER   158      24.386 -15.823  -7.647  1.00115.72      A    C  
ATOM    980  O   SER   158      23.766 -15.637  -8.693  1.00122.87      A    O  
ATOM    981  N   LEU   159      25.543 -16.475  -7.587  1.00107.30      A    N  
ATOM    982  CA  LEU   159      26.252 -16.962  -8.762  1.00105.78      A    C  
ATOM    983  CB  LEU   159      27.643 -16.324  -8.812  1.00100.96      A    C  
ATOM    984  CG  LEU   159      28.366 -16.132 -10.145  1.00104.00      A    C  
ATOM    985  CD2 LEU   159      27.532 -15.316 -11.129  1.00112.58      A    C  
ATOM    987  C   LEU   159      26.341 -18.490  -8.703  1.00102.25      A    C  
ATOM    988  O   LEU   159      27.136 -19.049  -7.948  1.00 95.25      A    O  
ATOM    989  N   ASN   160      25.514 -19.156  -9.504  1.00107.82      A    N  
ATOM    990  CA  ASN   160      25.321 -20.604  -9.394  1.00107.03      A    C  
ATOM    991  CB  ASN   160      23.945 -21.006  -9.941  1.00115.89      A    C  
ATOM    992  CG  ASN   160      22.789 -20.368  -9.174  1.00119.98      A    C  
ATOM    993  OD1 ASN   160      21.844 -19.859  -9.777  1.00128.07      A    O  
ATOM    994  ND2 ASN   160      22.859 -20.395  -7.844  1.00115.38      A    N  
ATOM    995  C   ASN   160      26.406 -21.460 -10.044  1.00103.95      A    C  
ATOM    996  O   ASN   160      26.986 -21.079 -11.064  1.00105.22      A    O  
ATOM    997  N   ASP   161      26.665 -22.614  -9.424  1.00100.72      A    N  
ATOM    998  CA  ASP   161      27.538 -23.670  -9.958  1.00 99.67      A    C  
ATOM    999  CB  ASP   161      26.903 -24.310 -11.206  1.00108.04      A    C  
ATOM   1000  CG  ASP   161      27.456 -25.693 -11.506  1.00109.23      A    C  
ATOM   1001  OD1 ASP   161      27.756 -26.442 -10.547  1.00105.93      A    O  
ATOM   1002  OD2 ASP   161      27.577 -26.033 -12.705  1.00114.11      A    O  
ATOM   1003  C   ASP   161      28.976 -23.220 -10.238  1.00 94.88      A    C  
ATOM   1004  O   ASP   161      29.499 -23.410 -11.340  1.00 97.52      A    O  
ATOM   1005  N   CYS   162      29.608 -22.634  -9.226  1.00 88.51      A    N  
ATOM   1006  CA  CYS   162      30.981 -22.149  -9.332  1.00 85.07      A    C  
ATOM   1007  CB  CYS   162      31.178 -20.924  -8.431  1.00 81.92      A    C  
ATOM   1008  SG  CYS   162      30.225 -19.464  -8.900  1.00 88.32      A    S  
ATOM   1009  C   CYS   162      31.993 -23.225  -8.942  1.00 81.26      A    C  
ATOM   1010  O   CYS   162      31.833 -23.883  -7.913  1.00 79.50      A    O  
ATOM   1011  N   ARG   163      33.041 -23.388  -9.748  1.00 80.96      A    N  
ATOM   1012  CA  ARG   163      34.135 -24.297  -9.403  1.00 78.45      A    C  
ATOM   1013  CB  ARG   163      34.936 -24.699 -10.649  1.00 82.87      A    C  
ATOM   1014  CG  ARG   163      36.139 -25.619 -10.389  1.00 83.57      A    C  
ATOM   1015  CD  ARG   163      35.735 -26.950  -9.752  1.00 86.25      A    C  
ATOM   1016  NE  ARG   163      36.895 -27.771  -9.402  1.00 86.46      A    N  
ATOM   1017  CZ  ARG   163      37.383 -28.758 -10.151  1.00 91.21      A    C  
ATOM   1018  NH1 ARG   163      36.813 -29.077 -11.312  1.00 95.37      A    N  
ATOM   1019  NH2 ARG   163      38.444 -29.439  -9.732  1.00 90.22      A    N  
ATOM   1020  C   ARG   163      35.044 -23.655  -8.359  1.00 73.09      A    C  
ATOM   1021  O   ARG   163      35.798 -22.727  -8.665  1.00 73.28      A    O  
ATOM   1022  N   ILE   164      34.963 -24.155  -7.129  1.00 68.86      A    N  
ATOM   1023  CA  ILE   164      35.743 -23.620  -6.011  1.00 63.46      A    C  
ATOM   1024  CB  ILE   164      34.998 -23.798  -4.656  1.00 61.55      A    C  
ATOM   1025  CG1 ILE   164      33.573 -23.218  -4.724  1.00 60.30      A    C  
ATOM   1026  CD1 ILE   164      33.499 -21.745  -5.097  1.00 60.78      A    C  
ATOM   1027  CG2 ILE   164      35.823 -23.220  -3.477  1.00 57.88      A    C  
ATOM   1028  C   ILE   164      37.130 -24.257  -5.942  1.00 63.17      A    C  
ATOM   1029  O   ILE   164      37.258 -25.473  -5.803  1.00 63.90      A    O  
ATOM   1030  N   ILE   165      38.160 -23.419  -6.033  1.00 63.23      A    N  
ATOM   1031  CA  ILE   165      39.553 -23.873  -6.071  1.00 64.54      A    C  
ATOM   1032  CB  ILE   165      40.486 -22.816  -6.735  1.00 65.87      A    C  
ATOM   1033  CG1 ILE   165      40.033 -22.474  -8.161  1.00 68.67      A    C  
ATOM   1034  CD1 ILE   165      39.820 -23.676  -9.066  1.00 70.55      A    C  
ATOM   1035  CG2 ILE   165      41.943 -23.279  -6.718  1.00 68.94      A    C  
ATOM   1036  C   ILE   165      40.090 -24.196  -4.681  1.00 63.36      A    C  
ATOM   1037  O   ILE   165      40.739 -25.220  -4.487  1.00 65.13      A    O  
ATOM   1038  N   PHE   166      39.808 -23.316  -3.724  1.00 60.96      A    N  
ATOM   1039  CA  PHE   166      40.423 -23.363  -2.391  1.00 61.51      A    C  
ATOM   1040  CB  PHE   166      40.778 -21.947  -1.921  1.00 59.92      A    C  
ATOM   1041  CG  PHE   166      41.515 -21.179  -2.976  1.00 63.59      A    C  
ATOM   1042  CD1 PHE   166      40.831 -20.338  -3.851  1.00 63.67      A    C  
ATOM   1043  CE1 PHE   166      41.500 -19.672  -4.874  1.00 65.74      A    C  
ATOM   1044  CZ  PHE   166      42.863 -19.866  -5.048  1.00 69.84      A    C  
ATOM   1045  CE2 PHE   166      43.555 -20.726  -4.199  1.00 71.18      A    C  
ATOM   1046  CD2 PHE   166      42.875 -21.391  -3.179  1.00 67.07      A    C  
ATOM   1047  C   PHE   166      39.555 -24.164  -1.448  1.00 60.34      A    C  
ATOM   1048  O   PHE   166      38.857 -23.654  -0.577  1.00 59.81      A    O  
ATOM   1049  N   VAL   167      39.639 -25.461  -1.683  1.00 61.90      A    N  
ATOM   1050  CA  VAL   167      38.760 -26.465  -1.138  1.00 62.51      A    C  
ATOM   1051  CB  VAL   167      38.817 -27.678  -2.085  1.00 66.35      A    C  
ATOM   1052  CG1 VAL   167      38.694 -29.004  -1.355  1.00 71.14      A    C  
ATOM   1053  CG2 VAL   167      37.789 -27.517  -3.209  1.00 67.21      A    C  
ATOM   1054  C   VAL   167      39.147 -26.822   0.296  1.00 62.61      A    C  
ATOM   1055  O   VAL   167      38.380 -27.472   1.015  1.00 61.76      A    O  
ATOM   1056  N   ASP   168      40.332 -26.369   0.706  1.00 63.36      A    N  
ATOM   1057  CA  ASP   168      40.879 -26.668   2.024  1.00 65.08      A    C  
ATOM   1058  CB  ASP   168      42.323 -27.177   1.907  1.00 68.67      A    C  
ATOM   1059  CG  ASP   168      42.404 -28.597   1.360  1.00 73.05      A    C  
ATOM   1060  OD1 ASP   168      41.677 -29.482   1.868  1.00 73.62      A    O  
ATOM   1061  OD2 ASP   168      43.199 -28.833   0.422  1.00 74.94      A    O  
ATOM   1062  C   ASP   168      40.810 -25.459   2.946  1.00 63.54      A    C  
ATOM   1063  O   ASP   168      41.340 -25.489   4.062  1.00 66.02      A    O  
ATOM   1064  N   GLU   169      40.141 -24.405   2.482  1.00 60.46      A    N  
ATOM   1065  CA  GLU   169      40.110 -23.134   3.207  1.00 59.46      A    C  
ATOM   1066  CB  GLU   169      40.988 -22.107   2.487  1.00 60.15      A    C  
ATOM   1067  CG  GLU   169      42.468 -22.435   2.516  1.00 60.33      A    C  
ATOM   1068  CD  GLU   169      43.285 -21.528   1.627  1.00 63.26      A    C  
ATOM   1069  OE1 GLU   169      43.919 -20.597   2.166  1.00 63.21      A    O  
ATOM   1070  OE2 GLU   169      43.296 -21.742   0.389  1.00 63.55      A    O  
ATOM   1071  C   GLU   169      38.691 -22.593   3.412  1.00 57.50      A    C  
ATOM   1072  O   GLU   169      38.475 -21.378   3.494  1.00 56.14      A    O  
ATOM   1073  N   VAL   170      37.735 -23.511   3.511  1.00 57.46      A    N  
ATOM   1074  CA  VAL   170      36.325 -23.175   3.636  1.00 56.44      A    C  
ATOM   1075  CB  VAL   170      35.449 -24.277   2.987  1.00 56.48      A    C  
ATOM   1076  CG1 VAL   170      33.980 -24.001   3.212  1.00 55.51      A    C  
ATOM   1077  CG2 VAL   170      35.751 -24.397   1.489  1.00 54.79      A    C  
ATOM   1078  C   VAL   170      35.952 -22.981   5.112  1.00 59.01      A    C  
ATOM   1079  O   VAL   170      36.236 -23.839   5.957  1.00 61.69      A    O  
ATOM   1080  N   PHE   171      35.312 -21.855   5.412  1.00 58.99      A    N  
ATOM   1081  CA  PHE   171      34.969 -21.499   6.783  1.00 61.65      A    C  
ATOM   1082  CB  PHE   171      35.233 -20.014   7.044  1.00 60.78      A    C  
ATOM   1083  CG  PHE   171      36.670 -19.678   7.281  1.00 60.82      A    C  
ATOM   1084  CD1 PHE   171      37.210 -19.739   8.562  1.00 60.71      A    C  
ATOM   1085  CE1 PHE   171      38.544 -19.413   8.789  1.00 60.33      A    C  
ATOM   1086  CZ  PHE   171      39.352 -19.009   7.736  1.00 61.60      A    C  
ATOM   1087  CE2 PHE   171      38.825 -18.946   6.441  1.00 61.24      A    C  
ATOM   1088  CD2 PHE   171      37.487 -19.275   6.224  1.00 60.28      A    C  
ATOM   1089  C   PHE   171      33.524 -21.794   7.147  1.00 64.12      A    C  
ATOM   1090  O   PHE   171      32.615 -21.693   6.314  1.00 64.50      A    O  
ATOM   1091  N   LYS   172      33.339 -22.152   8.413  1.00 77.04      A    N  
ATOM   1092  CA  LYS   172      32.037 -22.227   9.050  1.00 79.53      A    C  
ATOM   1093  CB  LYS   172      32.164 -23.050  10.337  1.00 88.91      A    C  
ATOM   1094  CG  LYS   172      30.940 -23.105  11.231  1.00 93.59      A    C  
ATOM   1095  CD  LYS   172      31.219 -24.011  12.426  1.00105.42      A    C  
ATOM   1096  CE  LYS   172      30.081 -24.008  13.435  1.00111.71      A    C  
ATOM   1097  NZ  LYS   172      30.086 -22.782  14.282  1.00110.49      A    N  
ATOM   1098  C   LYS   172      31.600 -20.804   9.366  1.00 77.33      A    C  
ATOM   1099  O   LYS   172      32.382 -20.015   9.907  1.00 79.81      A    O  
ATOM   1100  N   ILE   173      30.364 -20.468   9.018  1.00 76.02      A    N  
ATOM   1101  CA  ILE   173      29.820 -19.163   9.362  1.00 76.65      A    C  
ATOM   1102  CB  ILE   173      28.692 -18.719   8.397  1.00 76.78      A    C  
ATOM   1103  CG1 ILE   173      29.263 -18.449   7.002  1.00 70.61      A    C  
ATOM   1104  CD1 ILE   173      28.220 -18.403   5.902  1.00 71.51      A    C  
ATOM   1105  CG2 ILE   173      27.983 -17.471   8.924  1.00 81.49      A    C  
ATOM   1106  C   ILE   173      29.330 -19.219  10.805  1.00 83.32      A    C  
ATOM   1107  O   ILE   173      28.477 -20.038  11.153  1.00 87.13      A    O  
ATOM   1108  N   GLU   174      29.896 -18.353  11.639  1.00 86.51      A    N  
ATOM   1109  CA  GLU   174      29.536 -18.283  13.050  1.00 93.69      A    C  
ATOM   1110  CB  GLU   174      30.549 -17.437  13.835  1.00 97.60      A    C  
ATOM   1111  CG  GLU   174      32.024 -17.729  13.538  1.00 98.58      A    C  
ATOM   1112  CD  GLU   174      32.480 -19.103  14.005  1.00103.15      A    C  
ATOM   1113  OE1 GLU   174      32.267 -19.434  15.190  1.00110.24      A    O  
ATOM   1114  OE2 GLU   174      33.069 -19.847  13.186  1.00102.50      A    O  
ATOM   1115  C   GLU   174      28.128 -17.711  13.215  1.00 97.65      A    C  
ATOM   1116  O   GLU   174      27.849 -16.589  12.779  1.00 98.79      A    O  
ATOM   1117  N   ARG   175      27.250 -18.506  13.826  1.00102.48      A    N  
ATOM   1118  CA  ARG   175      25.891 -18.080  14.174  1.00109.50      A    C  
ATOM   1119  CB  ARG   175      24.881 -19.185  13.842  1.00114.39      A    C  
ATOM   1120  CG  ARG   175      24.124 -18.977  12.535  1.00116.97      A    C  
ATOM   1121  CD  ARG   175      24.920 -19.414  11.313  1.00109.78      A    C  
ATOM   1122  NE  ARG   175      24.355 -18.861  10.080  1.00112.40      A    N  
ATOM   1123  CZ  ARG   175      24.629 -19.298   8.851  1.00109.33      A    C  
ATOM   1124  NH1 ARG   175      25.462 -20.318   8.661  1.00103.11      A    N  
ATOM   1125  NH2 ARG   175      24.058 -18.714   7.803  1.00112.61      A    N  
ATOM   1126  C   ARG   175      25.781 -17.680  15.653  1.00114.90      A    C  
ATOM   1127  O   ARG   175      26.443 -18.279  16.504  1.00115.25      A    O  
ATOM   1128  N   PRO   176      24.947 -16.661  15.961  1.00121.13      A    N  
ATOM   1129  CA  PRO   176      24.769 -16.177  17.338  1.00127.15      A    C  
ATOM   1130  CB  PRO   176      23.739 -15.054  17.186  1.00135.40      A    C  
ATOM   1131  CG  PRO   176      23.825 -14.640  15.761  1.00132.78      A    C  
ATOM   1132  CD  PRO   176      24.125 -15.891  15.009  1.00124.80      A    C  
ATOM   1133  C   PRO   176      24.226 -17.248  18.281  1.00131.43      A    C  
ATOM   1134  O   PRO   176      24.738 -17.408  19.389  1.00133.23      A    O  
END
