
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   90 (  689),  selected   90 , name 2hqx_A
# Molecule2: number of CA atoms   59 (  475),  selected   59 , name T0429_22_99.pdb
# PARAMETERS: 2hqx_A.T0429_22_99.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     8_A      E      22           -
LGA    Q     9_A      T      23           -
LGA    F    10_A      E      24           -
LGA    Q    11_A      L      25           -
LGA    K    12_A      -       -           -
LGA    L    13_A      -       -           -
LGA    M    14_A      -       -           -
LGA    E    15_A      -       -           -
LGA    N    16_A      -       -           -
LGA    M    17_A      -       -           -
LGA    R    18_A      -       -           -
LGA    N    19_A      -       -           -
LGA    D    20_A      -       -           -
LGA    I    21_A      -       -           -
LGA    A    22_A      -       -           -
LGA    S    23_A      -       -           -
LGA    H    24_A      -       -           -
LGA    P    25_A      -       -           -
LGA    P    26_A      -       -           -
LGA    V    27_A      -       -           -
LGA    E    28_A      -       -           -
LGA    G    29_A      -       -           -
LGA    S    30_A      -       -           -
LGA    Y    31_A      -       -           -
LGA    A    32_A      L      27          2.121
LGA    P    33_A      Y      28          1.515
LGA    R    34_A      K      29          0.727
LGA    R    35_A      V      30          0.474
LGA    G    36_A      N      31          0.463
LGA    E    37_A      E      32          0.450
LGA    F    38_A      Y      33          0.117
LGA    C    39_A      V      34          0.277
LGA    I    40_A      D      35          0.124
LGA    A    41_A      A      36          0.317
LGA    K    42_A      R      37          0.226
LGA    F    43_A      D      38          0.826
LGA    V    44_A      T      39          2.298
LGA    D    45_A      N      40          2.730
LGA    -       -      M      41           -
LGA    G    46_A      G      42          0.805
LGA    E    47_A      A      43          0.726
LGA    W    48_A      W      44          0.397
LGA    Y    49_A      F      45          0.327
LGA    R    50_A      E      46          0.406
LGA    A    51_A      A      47          0.388
LGA    R    52_A      Q      48          0.255
LGA    V    53_A      V      49          0.172
LGA    E    54_A      V      50          0.337
LGA    K    55_A      R      51          0.378
LGA    V    56_A      V      52          0.421
LGA    E    57_A      T      53          0.734
LGA    S    58_A      R      54          1.819
LGA    -       -      E      73           -
LGA    P    59_A      D      74          3.516
LGA    A    60_A      V      75          3.380
LGA    K    61_A      I      76          1.413
LGA    I    62_A      Y      77          0.742
LGA    H    63_A      H      78          0.285
LGA    V    64_A      V      79          0.218
LGA    F    65_A      K      80          0.220
LGA    Y    66_A      Y      81          0.781
LGA    I    67_A      D      82          0.882
LGA    D    68_A      D      83          0.904
LGA    Y    69_A      Y      84          0.610
LGA    G    70_A      P      85          0.923
LGA    -       -      E      86           -
LGA    N    71_A      N      87          1.957
LGA    R    72_A      G      88          3.478
LGA    -       -      V      89           -
LGA    E    73_A      V      90          0.885
LGA    V    74_A      Q      91          0.242
LGA    L    75_A      M      92          0.977
LGA    P    76_A      N      93          1.214
LGA    S    77_A      S      94          1.037
LGA    T    78_A      R      95          0.593
LGA    R    79_A      D      96          0.536
LGA    L    80_A      V      97          0.595
LGA    G    81_A      R      98          1.026
LGA    T    82_A      A      99          0.909
LGA    L    83_A      -       -           -
LGA    S    84_A      -       -           -
LGA    P    85_A      -       -           -
LGA    A    86_A      -       -           -
LGA    F    87_A      -       -           -
LGA    S    88_A      -       -           -
LGA    T    89_A      -       -           -
LGA    R    90_A      -       -           -
LGA    V    91_A      -       -           -
LGA    L    92_A      -       -           -
LGA    P    93_A      -       -           -
LGA    A    94_A      -       -           -
LGA    Q    95_A      -       -           -
LGA    A    96_A      -       -           -
LGA    T    97_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   90   59    5.0     51    1.26    27.45     83.043     3.753

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.040134 * X  +   0.831960 * Y  +   0.553382 * Z  +  34.459858
  Y_new =   0.639592 * X  +  -0.404108 * Y  +   0.653926 * Z  +  -7.066798
  Z_new =   0.767666 * X  +   0.380183 * Y  +  -0.515896 * Z  +   9.315872 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.506504   -0.635089  [ DEG:   143.6121    -36.3879 ]
  Theta =  -0.875192   -2.266401  [ DEG:   -50.1448   -129.8552 ]
  Phi   =   1.633463   -1.508129  [ DEG:    93.5906    -86.4094 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hqx_A                                        
REMARK     2: T0429_22_99.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hqx_A.T0429_22_99.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   90   59   5.0   51   1.26   27.45  83.043
REMARK  ---------------------------------------------------------- 
MOLECULE 2hqx_A
HEADER    TRANSCRIPTION                           19-JUL-06   2HQX              
TITLE     CRYSTAL STRUCTURE OF HUMAN P100 TUDOR DOMAIN CONSERVED                
TITLE    2 REGION                                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: P100 CO-ACTIVATOR TUDOR DOMAIN;                            
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: CONSERVED REGION;                                          
COMPND   5 SYNONYM: P100 CO-ACTIVATOR, 100 KDA COACTIVATOR, EBNA2               
COMPND   6 COACTIVATOR P100;                                                    
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: SND1;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    HUMAN P100 TUDOR DOMAIN, PROTEOLYTIC FRAGMENT, PSI,                   
KEYWDS   2 STRUCTURAL GENOMICS, SOUTHEAST COLLABORATORY FOR STRUCTURAL          
KEYWDS   3 GENOMICS, PROTEIN STRUCTURE INITIATIVE, SECSG                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.ZHAO,Z.J.LIU,H.XU,J.YANG,O.SILVENNOINEN,B.C.WANG,                   
AUTHOR   2 SOUTHEAST COLLABORATORY FOR STRUCTURAL GENOMICS (SECSG)              
REVDAT   1   10-OCT-06 2HQX    0                                                
JRNL        AUTH   M.ZHAO,Z.J.LIU,H.XU,J.YANG,O.SILVENNOINEN,B.C.WANG           
JRNL        TITL   CRYSTAL STRUCTURE OF HUMAN P100 TUDOR DOMAIN                 
JRNL        TITL 2 CONSERVED REGION                                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.42 ANGSTROMS.                                          
DBREF  2HQX A  -32   213  UNP    Q7KZF4   SND1_HUMAN     665    910             
DBREF  2HQX B  -32   213  UNP    Q7KZF4   SND1_HUMAN     665    910             
SEQRES   1 A  246  PRO VAL GLU GLU VAL MET PRO VAL LEU GLU GLU LYS GLU          
SEQRES   2 A  246  ARG SER ALA SER TYR LYS PRO VAL PHE VAL THR GLU ILE          
SEQRES   3 A  246  THR ASP ASP LEU HIS PHE TYR VAL GLN ASP VAL GLU THR          
SEQRES   4 A  246  GLY THR GLN PHE GLN LYS LEU MET GLU ASN MET ARG ASN          
SEQRES   5 A  246  ASP ILE ALA SER HIS PRO PRO VAL GLU GLY SER TYR ALA          
SEQRES   6 A  246  PRO ARG ARG GLY GLU PHE CYS ILE ALA LYS PHE VAL ASP          
SEQRES   7 A  246  GLY GLU TRP TYR ARG ALA ARG VAL GLU LYS VAL GLU SER          
SEQRES   8 A  246  PRO ALA LYS ILE HIS VAL PHE TYR ILE ASP TYR GLY ASN          
SEQRES   9 A  246  ARG GLU VAL LEU PRO SER THR ARG LEU GLY THR LEU SER          
SEQRES  10 A  246  PRO ALA PHE SER THR ARG VAL LEU PRO ALA GLN ALA THR          
SEQRES  11 A  246  GLU TYR ALA PHE ALA PHE ILE GLN VAL PRO GLN ASP ASP          
SEQRES  12 A  246  ASP ALA ARG THR ASP ALA VAL ASP SER VAL VAL ARG ASP          
SEQRES  13 A  246  ILE GLN ASN THR GLN CYS LEU LEU ASN VAL GLU HIS LEU          
SEQRES  14 A  246  SER ALA GLY CYS PRO HIS VAL THR LEU GLN PHE ALA ASP          
SEQRES  15 A  246  SER LYS GLY ASP VAL GLY LEU GLY LEU VAL LYS GLU GLY          
SEQRES  16 A  246  LEU VAL MET VAL GLU VAL ARG LYS GLU LYS GLN PHE GLN          
SEQRES  17 A  246  LYS VAL ILE THR GLU TYR LEU ASN ALA GLN GLU SER ALA          
SEQRES  18 A  246  LYS SER ALA ARG LEU ASN LEU TRP ARG TYR GLY ASP PHE          
SEQRES  19 A  246  ARG ALA ASP ASP ALA ASP GLU PHE GLY TYR SER ARG              
SEQRES   1 B  246  PRO VAL GLU GLU VAL MET PRO VAL LEU GLU GLU LYS GLU          
SEQRES   2 B  246  ARG SER ALA SER TYR LYS PRO VAL PHE VAL THR GLU ILE          
SEQRES   3 B  246  THR ASP ASP LEU HIS PHE TYR VAL GLN ASP VAL GLU THR          
SEQRES   4 B  246  GLY THR GLN PHE GLN LYS LEU MET GLU ASN MET ARG ASN          
SEQRES   5 B  246  ASP ILE ALA SER HIS PRO PRO VAL GLU GLY SER TYR ALA          
SEQRES   6 B  246  PRO ARG ARG GLY GLU PHE CYS ILE ALA LYS PHE VAL ASP          
SEQRES   7 B  246  GLY GLU TRP TYR ARG ALA ARG VAL GLU LYS VAL GLU SER          
SEQRES   8 B  246  PRO ALA LYS ILE HIS VAL PHE TYR ILE ASP TYR GLY ASN          
SEQRES   9 B  246  ARG GLU VAL LEU PRO SER THR ARG LEU GLY THR LEU SER          
SEQRES  10 B  246  PRO ALA PHE SER THR ARG VAL LEU PRO ALA GLN ALA THR          
SEQRES  11 B  246  GLU TYR ALA PHE ALA PHE ILE GLN VAL PRO GLN ASP ASP          
SEQRES  12 B  246  ASP ALA ARG THR ASP ALA VAL ASP SER VAL VAL ARG ASP          
SEQRES  13 B  246  ILE GLN ASN THR GLN CYS LEU LEU ASN VAL GLU HIS LEU          
SEQRES  14 B  246  SER ALA GLY CYS PRO HIS VAL THR LEU GLN PHE ALA ASP          
SEQRES  15 B  246  SER LYS GLY ASP VAL GLY LEU GLY LEU VAL LYS GLU GLY          
SEQRES  16 B  246  LEU VAL MET VAL GLU VAL ARG LYS GLU LYS GLN PHE GLN          
SEQRES  17 B  246  LYS VAL ILE THR GLU TYR LEU ASN ALA GLN GLU SER ALA          
SEQRES  18 B  246  LYS SER ALA ARG LEU ASN LEU TRP ARG TYR GLY ASP PHE          
SEQRES  19 B  246  ARG ALA ASP ASP ALA ASP GLU PHE GLY TYR SER ARG              
FORMUL   3  HOH   *238(H2 O)                                                    
CRYST1   30.777   37.684   40.202  90.03 105.32  99.72 P 1           2          
ATOM      1  N   THR A   8      50.160 -11.995  -1.645  1.00 16.75           N  
ATOM      2  CA  THR A   8      50.447 -11.120  -0.492  1.00 16.10           C  
ATOM      3  C   THR A   8      49.814 -11.802   0.763  1.00 14.88           C  
ATOM      4  O   THR A   8      48.853 -12.571   0.633  1.00 14.71           O  
ATOM      5  CB  THR A   8      49.877  -9.728  -0.839  1.00 17.47           C  
ATOM      6  OG1 THR A   8      50.908  -8.734  -0.956  1.00 19.52           O  
ATOM      7  CG2 THR A   8      48.769  -9.314   0.061  1.00 15.31           C  
ATOM      8  N   GLN A   9      50.358 -11.575   1.959  1.00 13.80           N  
ATOM      9  CA  GLN A   9      49.775 -12.159   3.184  1.00 13.61           C  
ATOM     10  C   GLN A   9      48.305 -11.790   3.342  1.00 12.48           C  
ATOM     11  O   GLN A   9      47.471 -12.625   3.688  1.00 11.58           O  
ATOM     12  CB  GLN A   9      50.548 -11.716   4.422  1.00 13.92           C  
ATOM     13  CG  GLN A   9      51.878 -12.406   4.551  1.00 15.09           C  
ATOM     14  CD  GLN A   9      52.638 -11.946   5.764  1.00 19.09           C  
ATOM     15  OE1 GLN A   9      52.446 -12.472   6.862  1.00 20.50           O  
ATOM     16  NE2 GLN A   9      53.511 -10.969   5.578  1.00 19.89           N  
ATOM     17  N   PHE A  10      48.001 -10.526   3.077  1.00 11.78           N  
ATOM     18  CA  PHE A  10      46.633 -10.038   3.108  1.00 12.54           C  
ATOM     19  C   PHE A  10      45.768 -10.800   2.098  1.00 12.65           C  
ATOM     20  O   PHE A  10      44.682 -11.276   2.433  1.00 11.53           O  
ATOM     21  CB  PHE A  10      46.661  -8.557   2.779  1.00 13.20           C  
ATOM     22  CG  PHE A  10      45.364  -7.846   2.976  1.00 15.30           C  
ATOM     23  CD1 PHE A  10      44.303  -8.434   3.657  1.00 18.59           C  
ATOM     24  CD2 PHE A  10      45.258  -6.521   2.565  1.00 16.10           C  
ATOM     25  CE1 PHE A  10      43.138  -7.752   3.832  1.00 22.43           C  
ATOM     26  CE2 PHE A  10      44.105  -5.825   2.752  1.00 20.68           C  
ATOM     27  CZ  PHE A  10      43.039  -6.439   3.378  1.00 21.20           C  
ATOM     28  N   GLN A  11      46.238 -10.924   0.861  1.00 12.37           N  
ATOM     29  CA  GLN A  11      45.475 -11.607  -0.189  1.00 12.83           C  
ATOM     30  C   GLN A  11      45.179 -13.047   0.178  1.00 12.37           C  
ATOM     31  O   GLN A  11      44.068 -13.522  -0.021  1.00 12.13           O  
ATOM     32  CB  GLN A  11      46.199 -11.529  -1.538  1.00 12.82           C  
ATOM     33  CG  GLN A  11      46.100 -10.149  -2.204  1.00 14.23           C  
ATOM     34  CD  GLN A  11      46.962 -10.030  -3.466  1.00 15.49           C  
ATOM     35  OE1 GLN A  11      48.036 -10.633  -3.561  1.00 17.16           O  
ATOM     36  NE2 GLN A  11      46.477  -9.272  -4.445  1.00 20.39           N  
ATOM     37  N   LYS A  12      46.177 -13.736   0.723  1.00 12.00           N  
ATOM     38  CA  LYS A  12      46.043 -15.128   1.118  1.00 12.13           C  
ATOM     39  C   LYS A  12      45.060 -15.266   2.273  1.00 11.57           C  
ATOM     40  O   LYS A  12      44.241 -16.176   2.278  1.00 11.16           O  
ATOM     41  CB  LYS A  12      47.392 -15.743   1.503  1.00 11.93           C  
ATOM     42  CG  LYS A  12      48.389 -15.889   0.349  1.00 14.52           C  
ATOM     43  CD  LYS A  12      49.720 -16.477   0.826  1.00 14.51           C  
ATOM     44  CE  LYS A  12      50.628 -16.833  -0.356  1.00 19.55           C  
ATOM     45  NZ  LYS A  12      50.975 -15.640  -1.176  1.00 24.55           N  
ATOM     46  N   LEU A  13      45.148 -14.373   3.265  1.00 10.51           N  
ATOM     47  CA  LEU A  13      44.208 -14.442   4.395  1.00 10.73           C  
ATOM     48  C   LEU A  13      42.775 -14.202   3.924  1.00 10.21           C  
ATOM     49  O   LEU A  13      41.866 -14.885   4.376  1.00 10.01           O  
ATOM     50  CB  LEU A  13      44.578 -13.461   5.526  1.00 11.42           C  
ATOM     51  CG  LEU A  13      43.704 -13.507   6.801  1.00 11.17           C  
ATOM     52  CD1 LEU A  13      44.073 -14.687   7.697  1.00 16.37           C  
ATOM     53  CD2 LEU A  13      43.795 -12.213   7.603  1.00 11.27           C  
ATOM     54  N   MET A  14      42.569 -13.256   3.011  1.00 10.36           N  
ATOM     55  CA  MET A  14      41.209 -12.949   2.552  1.00 10.20           C  
ATOM     56  C   MET A  14      40.600 -14.109   1.817  1.00 10.43           C  
ATOM     57  O   MET A  14      39.424 -14.407   1.983  1.00  9.31           O  
ATOM     58  CB  MET A  14      41.154 -11.677   1.699  1.00 11.05           C  
ATOM     59  CG  MET A  14      41.395 -10.442   2.503  1.00 11.11           C  
ATOM     60  SD  MET A  14      40.122 -10.144   3.747  1.00  9.40           S  
ATOM     61  CE  MET A  14      39.436  -8.688   3.005  1.00 17.93           C  
ATOM     62  N   GLU A  15      41.405 -14.768   0.990  1.00 10.81           N  
ATOM     63  CA  GLU A  15      40.941 -15.950   0.284  1.00 12.10           C  
ATOM     64  C   GLU A  15      40.547 -17.040   1.267  1.00 10.89           C  
ATOM     65  O   GLU A  15      39.461 -17.605   1.170  1.00 11.54           O  
ATOM     66  CB  GLU A  15      42.017 -16.466  -0.671  1.00 12.70           C  
ATOM     67  CG  GLU A  15      41.575 -17.614  -1.543  1.00 17.88           C  
ATOM     68  CD  GLU A  15      42.502 -17.839  -2.722  1.00 23.93           C  
ATOM     69  OE1 GLU A  15      43.726 -17.992  -2.503  1.00 27.87           O  
ATOM     70  OE2 GLU A  15      42.005 -17.867  -3.874  1.00 26.43           O  
ATOM     71  N   ASN A  16      41.425 -17.322   2.222  1.00 10.07           N  
ATOM     72  CA  ASN A  16      41.152 -18.394   3.174  1.00 10.59           C  
ATOM     73  C   ASN A  16      39.934 -18.030   4.034  1.00  9.32           C  
ATOM     74  O   ASN A  16      39.053 -18.841   4.226  1.00  9.80           O  
ATOM     75  CB  ASN A  16      42.379 -18.695   4.036  1.00 11.24           C  
ATOM     76  CG  ASN A  16      43.486 -19.386   3.257  1.00 15.04           C  
ATOM     77  OD1 ASN A  16      43.218 -20.279   2.448  1.00 20.56           O  
ATOM     78  ND2 ASN A  16      44.739 -19.003   3.520  1.00 17.70           N  
ATOM     79  N   MET A  17      39.877 -16.778   4.506  1.00  7.97           N  
ATOM     80  CA  MET A  17      38.761 -16.324   5.333  1.00  7.30           C  
ATOM     81  C   MET A  17      37.437 -16.417   4.584  1.00  8.02           C  
ATOM     82  O   MET A  17      36.455 -16.929   5.104  1.00  8.57           O  
ATOM     83  CB  MET A  17      39.003 -14.886   5.831  1.00  7.38           C  
ATOM     84  CG  MET A  17      37.909 -14.386   6.748  1.00  6.92           C  
ATOM     85  SD  MET A  17      38.156 -12.687   7.301  1.00  6.16           S  
ATOM     86  CE  MET A  17      37.473 -11.818   5.884  1.00 10.56           C  
ATOM     87  N   ARG A  18      37.400 -15.904   3.355  1.00  7.24           N  
ATOM     88  CA  ARG A  18      36.179 -15.928   2.546  1.00  7.54           C  
ATOM     89  C   ARG A  18      35.735 -17.340   2.184  1.00  7.83           C  
ATOM     90  O   ARG A  18      34.528 -17.622   2.163  1.00  7.75           O  
ATOM     91  CB  ARG A  18      36.311 -15.044   1.291  1.00  6.41           C  
ATOM     92  CG  ARG A  18      36.432 -13.564   1.684  1.00  5.70           C  
ATOM     93  CD  ARG A  18      36.739 -12.639   0.545  1.00  7.84           C  
ATOM     94  NE  ARG A  18      36.741 -11.261   1.033  1.00  8.77           N  
ATOM     95  CZ  ARG A  18      37.532 -10.311   0.565  1.00 11.57           C  
ATOM     96  NH1 ARG A  18      37.459  -9.096   1.089  1.00 11.75           N  
ATOM     97  NH2 ARG A  18      38.415 -10.586  -0.392  1.00 13.32           N  
ATOM     98  N   ASN A  19      36.692 -18.236   1.957  1.00  7.94           N  
ATOM     99  CA  ASN A  19      36.324 -19.639   1.711  1.00  9.63           C  
ATOM    100  C   ASN A  19      35.710 -20.263   2.951  1.00  9.80           C  
ATOM    101  O   ASN A  19      34.744 -21.027   2.871  1.00 10.63           O  
ATOM    102  CB  ASN A  19      37.517 -20.440   1.210  1.00  9.99           C  
ATOM    103  CG  ASN A  19      37.925 -20.051  -0.188  1.00 10.90           C  
ATOM    104  OD1 ASN A  19      37.162 -19.434  -0.936  1.00 13.73           O  
ATOM    105  ND2 ASN A  19      39.156 -20.403  -0.553  1.00 14.33           N  
ATOM    106  N   ASP A  20      36.250 -19.906   4.121  1.00 10.18           N  
ATOM    107  CA  ASP A  20      35.698 -20.399   5.381  1.00 10.64           C  
ATOM    108  C   ASP A  20      34.314 -19.806   5.662  1.00  9.95           C  
ATOM    109  O   ASP A  20      33.401 -20.507   6.098  1.00 10.82           O  
ATOM    110  CB  ASP A  20      36.619 -20.085   6.548  1.00 11.83           C  
ATOM    111  CG  ASP A  20      36.171 -20.785   7.811  1.00 14.49           C  
ATOM    112  OD1 ASP A  20      35.618 -20.114   8.708  1.00 16.19           O  
ATOM    113  OD2 ASP A  20      36.310 -22.029   7.879  1.00 17.87           O  
ATOM    114  N   ILE A  21      34.152 -18.504   5.429  1.00  8.95           N  
ATOM    115  CA  ILE A  21      32.844 -17.867   5.639  1.00 10.19           C  
ATOM    116  C   ILE A  21      31.805 -18.538   4.739  1.00 11.00           C  
ATOM    117  O   ILE A  21      30.705 -18.819   5.175  1.00 11.76           O  
ATOM    118  CB  ILE A  21      32.879 -16.339   5.389  1.00 10.21           C  
ATOM    119  CG1 ILE A  21      33.771 -15.661   6.441  1.00  9.69           C  
ATOM    120  CG2 ILE A  21      31.476 -15.718   5.415  1.00 11.20           C  
ATOM    121  CD1 ILE A  21      34.279 -14.299   6.052  1.00  9.96           C  
ATOM    122  N   ALA A  22      32.164 -18.818   3.491  1.00 12.28           N  
ATOM    123  CA  ALA A  22      31.239 -19.460   2.562  1.00 14.08           C  
ATOM    124  C   ALA A  22      30.843 -20.863   3.045  1.00 15.06           C  
ATOM    125  O   ALA A  22      29.696 -21.277   2.844  1.00 16.83           O  
ATOM    126  CB  ALA A  22      31.857 -19.502   1.175  1.00 13.99           C  
ATOM    127  N   SER A  23      31.758 -21.567   3.717  1.00 15.85           N  
ATOM    128  CA  SER A  23      31.472 -22.895   4.295  1.00 17.23           C  
ATOM    129  C   SER A  23      30.548 -22.832   5.515  1.00 17.27           C  
ATOM    130  O   SER A  23      29.899 -23.821   5.851  1.00 17.49           O  
ATOM    131  CB  SER A  23      32.753 -23.605   4.743  1.00 17.43           C  
ATOM    132  OG  SER A  23      33.813 -23.479   3.808  1.00 22.52           O  
ATOM    133  N   HIS A  24      30.524 -21.682   6.189  1.00 16.17           N  
ATOM    134  CA  HIS A  24      29.774 -21.499   7.434  1.00 16.68           C  
ATOM    135  C   HIS A  24      29.281 -20.051   7.540  1.00 16.31           C  
ATOM    136  O   HIS A  24      29.757 -19.267   8.369  1.00 16.05           O  
ATOM    137  CB  HIS A  24      30.661 -21.875   8.654  1.00 16.85           C  
ATOM    138  N   PRO A  25      28.321 -19.707   6.690  1.00 16.86           N  
ATOM    139  CA  PRO A  25      27.827 -18.338   6.575  1.00 16.33           C  
ATOM    140  C   PRO A  25      27.313 -17.831   7.923  1.00 16.33           C  
ATOM    141  O   PRO A  25      26.693 -18.596   8.668  1.00 16.20           O  
ATOM    142  CB  PRO A  25      26.720 -18.274   5.523  1.00 16.95           C  
ATOM    143  N   PRO A  26      27.569 -16.547   8.256  1.00 15.96           N  
ATOM    144  CA  PRO A  26      27.060 -16.053   9.537  1.00 15.73           C  
ATOM    145  C   PRO A  26      25.559 -16.276   9.677  1.00 15.54           C  
ATOM    146  O   PRO A  26      24.814 -16.104   8.701  1.00 15.34           O  
ATOM    147  CB  PRO A  26      27.345 -14.548   9.470  1.00 16.16           C  
ATOM    148  CG  PRO A  26      28.517 -14.438   8.572  1.00 15.87           C  
ATOM    149  CD  PRO A  26      28.335 -15.511   7.535  1.00 16.27           C  
ATOM    150  N   VAL A  27      25.138 -16.634  10.890  1.00 15.82           N  
ATOM    151  CA  VAL A  27      23.724 -16.870  11.188  1.00 16.24           C  
ATOM    152  C   VAL A  27      23.116 -15.628  11.815  1.00 16.84           C  
ATOM    153  O   VAL A  27      23.645 -15.107  12.790  1.00 16.47           O  
ATOM    154  CB  VAL A  27      23.580 -18.040  12.118  1.00 16.32           C  
ATOM    155  N   GLU A  28      21.997 -15.161  11.262  1.00 17.35           N  
ATOM    156  CA  GLU A  28      21.353 -13.954  11.766  1.00 17.90           C  
ATOM    157  C   GLU A  28      21.049 -14.106  13.253  1.00 18.07           C  
ATOM    158  O   GLU A  28      20.488 -15.116  13.683  1.00 18.38           O  
ATOM    159  CB  GLU A  28      20.091 -13.635  10.962  1.00 18.46           C  
ATOM    160  N   GLY A  29      21.514 -13.132  14.036  1.00 18.18           N  
ATOM    161  CA  GLY A  29      21.274 -13.047  15.477  1.00 18.38           C  
ATOM    162  C   GLY A  29      22.377 -13.651  16.346  1.00 18.05           C  
ATOM    163  O   GLY A  29      22.449 -13.372  17.542  1.00 18.58           O  
ATOM    164  N   SER A  30      23.239 -14.457  15.741  1.00 17.44           N  
ATOM    165  CA  SER A  30      24.288 -15.108  16.491  1.00 16.41           C  
ATOM    166  C   SER A  30      25.374 -14.105  16.945  1.00 16.16           C  
ATOM    167  O   SER A  30      25.749 -14.092  18.120  1.00 16.83           O  
ATOM    168  CB  SER A  30      24.870 -16.239  15.681  1.00 16.65           C  
ATOM    169  N   TYR A  31      25.866 -13.263  16.034  1.00 14.74           N  
ATOM    170  CA  TYR A  31      26.856 -12.247  16.409  1.00 14.07           C  
ATOM    171  C   TYR A  31      26.203 -10.949  16.883  1.00 13.73           C  
ATOM    172  O   TYR A  31      25.381 -10.382  16.170  1.00 14.48           O  
ATOM    173  CB  TYR A  31      27.844 -11.932  15.269  1.00 13.89           C  
ATOM    174  CG  TYR A  31      28.806 -10.833  15.675  1.00 12.59           C  
ATOM    175  CD1 TYR A  31      29.814 -11.079  16.606  1.00 14.24           C  
ATOM    176  CD2 TYR A  31      28.671  -9.545  15.184  1.00 11.84           C  
ATOM    177  CE1 TYR A  31      30.679 -10.068  17.027  1.00 14.96           C  
ATOM    178  CE2 TYR A  31      29.547  -8.510  15.584  1.00 11.87           C  
ATOM    179  CZ  TYR A  31      30.533  -8.785  16.522  1.00 13.26           C  
ATOM    180  OH  TYR A  31      31.399  -7.808  16.958  1.00 14.31           O  
ATOM    181  N   ALA A  32      26.592 -10.486  18.070  1.00 13.28           N  
ATOM    182  CA  ALA A  32      26.100  -9.228  18.632  1.00 13.65           C  
ATOM    183  C   ALA A  32      27.259  -8.232  18.687  1.00 13.02           C  
ATOM    184  O   ALA A  32      28.296  -8.521  19.278  1.00 14.27           O  
ATOM    185  CB  ALA A  32      25.525  -9.459  20.023  1.00 14.64           C  
ATOM    186  N   PRO A  33      27.073  -7.067  18.072  1.00 13.08           N  
ATOM    187  CA  PRO A  33      28.137  -6.064  17.977  1.00 13.26           C  
ATOM    188  C   PRO A  33      28.375  -5.377  19.314  1.00 13.46           C  
ATOM    189  O   PRO A  33      27.423  -4.975  19.997  1.00 13.90           O  
ATOM    190  CB  PRO A  33      27.795  -5.032  16.911  1.00 13.84           C  
ATOM    191  N   ARG A  34      29.637  -5.259  19.704  1.00 12.70           N  
ATOM    192  CA  ARG A  34      29.996  -4.454  20.864  1.00 12.98           C  
ATOM    193  C   ARG A  34      31.237  -3.634  20.549  1.00 12.57           C  
ATOM    194  O   ARG A  34      32.139  -4.097  19.843  1.00 11.54           O  
ATOM    195  CB  ARG A  34      30.228  -5.336  22.086  1.00 14.13           C  
ATOM    196  N   ARG A  35      31.259  -2.405  21.065  1.00 11.58           N  
ATOM    197  CA  ARG A  35      32.334  -1.474  20.792  1.00 10.64           C  
ATOM    198  C   ARG A  35      33.682  -2.093  21.105  1.00 10.06           C  
ATOM    199  O   ARG A  35      33.880  -2.689  22.173  1.00 10.34           O  
ATOM    200  CB  ARG A  35      32.139  -0.163  21.570  1.00 10.80           C  
ATOM    201  CG  ARG A  35      33.104   0.916  21.166  1.00 10.90           C  
ATOM    202  CD  ARG A  35      33.086   2.076  22.156  1.00 14.85           C  
ATOM    203  NE  ARG A  35      32.048   3.060  21.883  1.00 19.14           N  
ATOM    204  CZ  ARG A  35      32.260   4.346  21.582  1.00 18.83           C  
ATOM    205  NH1 ARG A  35      33.490   4.850  21.494  1.00 19.19           N  
ATOM    206  NH2 ARG A  35      31.220   5.134  21.365  1.00 19.76           N  
ATOM    207  N   GLY A  36      34.594  -1.966  20.138  1.00  9.39           N  
ATOM    208  CA  GLY A  36      35.965  -2.414  20.292  1.00 10.24           C  
ATOM    209  C   GLY A  36      36.225  -3.853  19.874  1.00  9.55           C  
ATOM    210  O   GLY A  36      37.396  -4.270  19.762  1.00 11.29           O  
ATOM    211  N   GLU A  37      35.154  -4.610  19.633  1.00 10.51           N  
ATOM    212  CA  GLU A  37      35.275  -6.008  19.198  1.00 10.26           C  
ATOM    213  C   GLU A  37      35.568  -6.072  17.717  1.00 10.03           C  
ATOM    214  O   GLU A  37      35.115  -5.221  16.948  1.00  9.59           O  
ATOM    215  CB  GLU A  37      34.003  -6.793  19.503  1.00 10.87           C  
ATOM    216  N   PHE A  38      36.333  -7.092  17.334  1.00  9.32           N  
ATOM    217  CA  PHE A  38      36.530  -7.417  15.921  1.00  9.33           C  
ATOM    218  C   PHE A  38      35.394  -8.311  15.418  1.00 10.00           C  
ATOM    219  O   PHE A  38      34.751  -9.049  16.175  1.00 11.29           O  
ATOM    220  CB  PHE A  38      37.884  -8.107  15.721  1.00  9.49           C  
ATOM    221  CG  PHE A  38      39.065  -7.235  16.053  1.00  9.71           C  
ATOM    222  CD1 PHE A  38      39.668  -7.283  17.312  1.00 10.29           C  
ATOM    223  CD2 PHE A  38      39.572  -6.357  15.106  1.00 10.46           C  
ATOM    224  CE1 PHE A  38      40.762  -6.460  17.595  1.00 12.80           C  
ATOM    225  CE2 PHE A  38      40.647  -5.544  15.389  1.00 10.65           C  
ATOM    226  CZ  PHE A  38      41.242  -5.593  16.635  1.00 12.32           C  
ATOM    227  N   CYS A  39      35.125  -8.203  14.125  1.00  8.76           N  
ATOM    228  CA  CYS A  39      34.074  -8.960  13.485  1.00  8.92           C  
ATOM    229  C   CYS A  39      34.375  -9.057  12.013  1.00  9.07           C  
ATOM    230  O   CYS A  39      35.402  -8.573  11.555  1.00  7.04           O  
ATOM    231  CB  CYS A  39      32.726  -8.271  13.717  1.00  9.88           C  
ATOM    232  SG  CYS A  39      32.623  -6.626  13.002  1.00 11.93           S  
ATOM    233  N   ILE A  40      33.485  -9.691  11.259  1.00  7.30           N  
ATOM    234  CA  ILE A  40      33.532  -9.546   9.814  1.00  7.17           C  
ATOM    235  C   ILE A  40      32.354  -8.664   9.397  1.00  6.57           C  
ATOM    236  O   ILE A  40      31.311  -8.659  10.057  1.00  7.57           O  
ATOM    237  CB  ILE A  40      33.537 -10.904   9.061  1.00  7.18           C  
ATOM    238  CG1 ILE A  40      32.351 -11.791   9.467  1.00  7.23           C  
ATOM    239  CG2 ILE A  40      34.859 -11.603   9.278  1.00  8.07           C  
ATOM    240  CD1 ILE A  40      32.145 -13.078   8.655  1.00  6.16           C  
ATOM    241  N   ALA A  41      32.537  -7.907   8.324  1.00  6.55           N  
ATOM    242  CA  ALA A  41      31.535  -6.975   7.831  1.00  7.00           C  
ATOM    243  C   ALA A  41      31.391  -7.147   6.331  1.00  6.77           C  
ATOM    244  O   ALA A  41      32.412  -7.266   5.626  1.00  7.27           O  
ATOM    245  CB  ALA A  41      31.938  -5.536   8.177  1.00  8.18           C  
ATOM    246  N   LYS A  42      30.144  -7.170   5.862  1.00  7.93           N  
ATOM    247  CA  LYS A  42      29.868  -7.356   4.456  1.00  7.59           C  
ATOM    248  C   LYS A  42      29.760  -6.016   3.757  1.00  8.24           C  
ATOM    249  O   LYS A  42      28.808  -5.282   3.972  1.00  9.17           O  
ATOM    250  CB  LYS A  42      28.579  -8.160   4.281  1.00  8.67           C  
ATOM    251  CG  LYS A  42      28.543  -8.883   2.964  1.00 10.02           C  
ATOM    252  CD  LYS A  42      27.311  -9.780   2.880  1.00 13.40           C  
ATOM    253  CE  LYS A  42      27.305 -10.629   1.621  1.00 17.13           C  
ATOM    254  NZ  LYS A  42      26.070 -11.466   1.509  1.00 20.07           N  
ATOM    255  N   PHE A  43      30.760  -5.700   2.932  1.00  8.28           N  
ATOM    256  CA  PHE A  43      30.879  -4.389   2.294  1.00  9.61           C  
ATOM    257  C   PHE A  43      29.897  -4.293   1.120  1.00 10.38           C  
ATOM    258  O   PHE A  43      29.207  -5.268   0.790  1.00 10.99           O  
ATOM    259  CB  PHE A  43      32.329  -4.216   1.842  1.00  9.52           C  
ATOM    260  CG  PHE A  43      32.676  -2.855   1.320  1.00  9.45           C  
ATOM    261  CD1 PHE A  43      32.367  -1.700   2.042  1.00 10.26           C  
ATOM    262  CD2 PHE A  43      33.367  -2.734   0.128  1.00  9.98           C  
ATOM    263  CE1 PHE A  43      32.710  -0.416   1.557  1.00 11.32           C  
ATOM    264  CE2 PHE A  43      33.712  -1.456  -0.368  1.00 12.02           C  
ATOM    265  CZ  PHE A  43      33.371  -0.307   0.345  1.00 11.39           C  
ATOM    266  N   VAL A  44      29.856  -3.137   0.461  1.00 10.56           N  
ATOM    267  CA  VAL A  44      28.890  -2.895  -0.613  1.00 12.17           C  
ATOM    268  C   VAL A  44      29.138  -3.743  -1.868  1.00 12.29           C  
ATOM    269  O   VAL A  44      28.283  -3.805  -2.772  1.00 13.89           O  
ATOM    270  CB  VAL A  44      28.838  -1.397  -1.005  1.00 12.04           C  
ATOM    271  CG1 VAL A  44      28.504  -0.522   0.202  1.00 12.53           C  
ATOM    272  CG2 VAL A  44      30.133  -0.972  -1.712  1.00 14.43           C  
ATOM    273  N   ASP A  45      30.297  -4.388  -1.945  1.00 11.75           N  
ATOM    274  CA  ASP A  45      30.617  -5.282  -3.066  1.00 11.56           C  
ATOM    275  C   ASP A  45      30.117  -6.720  -2.844  1.00 11.69           C  
ATOM    276  O   ASP A  45      30.337  -7.609  -3.678  1.00 12.71           O  
ATOM    277  CB  ASP A  45      32.123  -5.262  -3.369  1.00 12.03           C  
ATOM    278  CG  ASP A  45      32.985  -5.662  -2.168  1.00 12.79           C  
ATOM    279  OD1 ASP A  45      32.437  -5.879  -1.068  1.00 13.95           O  
ATOM    280  OD2 ASP A  45      34.224  -5.760  -2.346  1.00 13.84           O  
ATOM    281  N   GLY A  46      29.436  -6.925  -1.721  1.00 12.07           N  
ATOM    282  CA  GLY A  46      28.923  -8.232  -1.354  1.00 11.77           C  
ATOM    283  C   GLY A  46      30.000  -9.161  -0.813  1.00 11.72           C  
ATOM    284  O   GLY A  46      29.752 -10.351  -0.614  1.00 12.53           O  
ATOM    285  N   GLU A  47      31.195  -8.618  -0.562  1.00 11.04           N  
ATOM    286  CA  GLU A  47      32.302  -9.394   0.016  1.00 10.73           C  
ATOM    287  C   GLU A  47      32.504  -9.102   1.508  1.00  9.61           C  
ATOM    288  O   GLU A  47      32.213  -7.993   1.982  1.00  8.04           O  
ATOM    289  CB  GLU A  47      33.616  -9.156  -0.749  1.00 11.61           C  
ATOM    290  CG  GLU A  47      33.621  -9.610  -2.231  1.00 13.87           C  
ATOM    291  CD  GLU A  47      33.512 -11.128  -2.435  1.00 19.30           C  
ATOM    292  OE1 GLU A  47      33.872 -11.909  -1.534  1.00 19.25           O  
ATOM    293  OE2 GLU A  47      33.077 -11.541  -3.533  1.00 22.42           O  
ATOM    294  N   TRP A  48      33.025 -10.102   2.231  1.00  7.80           N  
ATOM    295  CA  TRP A  48      33.273  -9.995   3.669  1.00  7.49           C  
ATOM    296  C   TRP A  48      34.707  -9.510   3.905  1.00  6.22           C  
ATOM    297  O   TRP A  48      35.653  -9.903   3.200  1.00  8.16           O  
ATOM    298  CB  TRP A  48      33.081 -11.335   4.382  1.00  7.64           C  
ATOM    299  CG  TRP A  48      31.646 -11.799   4.454  1.00  8.14           C  
ATOM    300  CD1 TRP A  48      31.038 -12.658   3.579  1.00  9.85           C  
ATOM    301  CD2 TRP A  48      30.634 -11.425   5.418  1.00  7.56           C  
ATOM    302  NE1 TRP A  48      29.714 -12.854   3.945  1.00  9.76           N  
ATOM    303  CE2 TRP A  48      29.440 -12.098   5.058  1.00  8.96           C  
ATOM    304  CE3 TRP A  48      30.616 -10.579   6.540  1.00  8.13           C  
ATOM    305  CZ2 TRP A  48      28.257 -11.968   5.789  1.00  9.76           C  
ATOM    306  CZ3 TRP A  48      29.445 -10.457   7.265  1.00  8.12           C  
ATOM    307  CH2 TRP A  48      28.277 -11.143   6.887  1.00  8.47           C  
ATOM    308  N   TYR A  49      34.832  -8.648   4.911  1.00  6.59           N  
ATOM    309  CA  TYR A  49      36.100  -8.029   5.302  1.00  5.81           C  
ATOM    310  C   TYR A  49      36.258  -8.051   6.809  1.00  6.55           C  
ATOM    311  O   TYR A  49      35.260  -8.083   7.529  1.00  6.22           O  
ATOM    312  CB  TYR A  49      36.164  -6.556   4.836  1.00  6.84           C  
ATOM    313  CG  TYR A  49      36.225  -6.351   3.332  1.00  4.42           C  
ATOM    314  CD1 TYR A  49      37.424  -6.051   2.696  1.00  6.47           C  
ATOM    315  CD2 TYR A  49      35.066  -6.417   2.570  1.00  6.71           C  
ATOM    316  CE1 TYR A  49      37.478  -5.856   1.318  1.00  8.18           C  
ATOM    317  CE2 TYR A  49      35.108  -6.209   1.199  1.00  6.74           C  
ATOM    318  CZ  TYR A  49      36.319  -5.939   0.580  1.00  7.87           C  
ATOM    319  OH  TYR A  49      36.363  -5.729  -0.787  1.00  8.51           O  
ATOM    320  N   ARG A  50      37.493  -8.011   7.299  1.00  5.91           N  
ATOM    321  CA  ARG A  50      37.713  -7.880   8.741  1.00  6.00           C  
ATOM    322  C   ARG A  50      37.393  -6.443   9.188  1.00  6.57           C  
ATOM    323  O   ARG A  50      37.708  -5.448   8.511  1.00  6.30           O  
ATOM    324  CB  ARG A  50      39.150  -8.255   9.147  1.00  6.85           C  
ATOM    325  CG  ARG A  50      39.595  -9.606   8.625  1.00  6.36           C  
ATOM    326  CD  ARG A  50      40.866 -10.106   9.322  1.00  6.42           C  
ATOM    327  NE  ARG A  50      42.016  -9.252   9.072  1.00  8.38           N  
ATOM    328  CZ  ARG A  50      43.163  -9.358   9.729  1.00  8.14           C  
ATOM    329  NH1 ARG A  50      43.327 -10.324  10.638  1.00  5.80           N  
ATOM    330  NH2 ARG A  50      44.165  -8.534   9.445  1.00  7.81           N  
ATOM    331  N   ALA A  51      36.762  -6.332  10.354  1.00  6.13           N  
ATOM    332  CA  ALA A  51      36.360  -5.026  10.835  1.00  6.66           C  
ATOM    333  C   ALA A  51      36.386  -4.951  12.346  1.00  7.06           C  
ATOM    334  O   ALA A  51      36.523  -5.950  13.049  1.00  7.33           O  
ATOM    335  CB  ALA A  51      34.960  -4.653  10.293  1.00  7.24           C  
ATOM    336  N   ARG A  52      36.312  -3.720  12.834  1.00  6.95           N  
ATOM    337  CA  ARG A  52      36.202  -3.464  14.266  1.00  8.40           C  
ATOM    338  C   ARG A  52      35.026  -2.525  14.525  1.00  7.82           C  
ATOM    339  O   ARG A  52      34.812  -1.559  13.795  1.00  7.57           O  
ATOM    340  CB  ARG A  52      37.492  -2.857  14.820  1.00  9.34           C  
ATOM    341  CG  ARG A  52      37.667  -3.115  16.304  1.00 14.05           C  
ATOM    342  CD  ARG A  52      38.642  -2.154  16.963  1.00 21.67           C  
ATOM    343  NE  ARG A  52      40.036  -2.506  16.738  1.00 27.25           N  
ATOM    344  CZ  ARG A  52      41.051  -2.131  17.523  1.00 30.14           C  
ATOM    345  NH1 ARG A  52      40.833  -1.390  18.606  1.00 31.61           N  
ATOM    346  NH2 ARG A  52      42.290  -2.499  17.227  1.00 31.46           N  
ATOM    347  N   VAL A  53      34.255  -2.831  15.569  1.00  7.72           N  
ATOM    348  CA  VAL A  53      33.085  -2.019  15.897  1.00  7.95           C  
ATOM    349  C   VAL A  53      33.543  -0.744  16.634  1.00  7.94           C  
ATOM    350  O   VAL A  53      34.257  -0.826  17.643  1.00  8.14           O  
ATOM    351  CB  VAL A  53      32.052  -2.827  16.740  1.00  7.49           C  
ATOM    352  CG1 VAL A  53      30.893  -1.939  17.155  1.00  8.67           C  
ATOM    353  CG2 VAL A  53      31.479  -4.061  15.954  1.00  9.36           C  
ATOM    354  N   GLU A  54      33.143   0.421  16.113  1.00  8.91           N  
ATOM    355  CA  GLU A  54      33.490   1.710  16.717  1.00 10.14           C  
ATOM    356  C   GLU A  54      32.363   2.375  17.523  1.00 10.92           C  
ATOM    357  O   GLU A  54      32.650   3.165  18.446  1.00 11.78           O  
ATOM    358  CB  GLU A  54      34.027   2.667  15.654  1.00 11.42           C  
ATOM    359  CG  GLU A  54      35.384   2.209  15.135  1.00 12.99           C  
ATOM    360  CD  GLU A  54      36.104   3.252  14.314  1.00 15.12           C  
ATOM    361  OE1 GLU A  54      35.435   3.984  13.551  1.00 17.54           O  
ATOM    362  OE2 GLU A  54      37.346   3.321  14.427  1.00 18.66           O  
ATOM    363  N   LYS A  55      31.107   2.070  17.179  1.00 10.13           N  
ATOM    364  CA  LYS A  55      29.957   2.661  17.870  1.00 11.57           C  
ATOM    365  C   LYS A  55      28.695   1.929  17.461  1.00 11.31           C  
ATOM    366  O   LYS A  55      28.488   1.623  16.282  1.00 11.70           O  
ATOM    367  CB  LYS A  55      29.839   4.147  17.541  1.00 11.44           C  
ATOM    368  CG  LYS A  55      28.638   4.862  18.153  1.00 14.80           C  
ATOM    369  CD  LYS A  55      28.688   6.337  17.803  1.00 18.11           C  
ATOM    370  CE  LYS A  55      27.290   6.863  17.499  1.00 22.97           C  
ATOM    371  NZ  LYS A  55      27.303   8.251  16.915  1.00 25.41           N  
ATOM    372  N   VAL A  56      27.834   1.685  18.445  1.00 11.94           N  
ATOM    373  CA  VAL A  56      26.541   1.089  18.207  1.00 13.37           C  
ATOM    374  C   VAL A  56      25.473   2.165  18.354  1.00 14.42           C  
ATOM    375  O   VAL A  56      25.208   2.654  19.469  1.00 15.27           O  
ATOM    376  CB  VAL A  56      26.268  -0.091  19.166  1.00 12.94           C  
ATOM    377  CG1 VAL A  56      24.883  -0.627  18.926  1.00 13.48           C  
ATOM    378  CG2 VAL A  56      27.285  -1.191  18.968  1.00 13.45           C  
ATOM    379  N   GLU A  57      24.867   2.520  17.225  1.00 14.85           N  
ATOM    380  CA  GLU A  57      23.829   3.554  17.178  1.00 17.44           C  
ATOM    381  C   GLU A  57      22.438   2.930  17.361  1.00 16.69           C  
ATOM    382  O   GLU A  57      21.619   3.418  18.164  1.00 17.75           O  
ATOM    383  CB  GLU A  57      23.946   4.333  15.857  1.00 17.03           C  
ATOM    384  CG  GLU A  57      22.961   5.504  15.672  1.00 19.50           C  
ATOM    385  CD  GLU A  57      23.081   6.203  14.311  1.00 20.48           C  
ATOM    386  OE1 GLU A  57      22.130   6.929  13.941  1.00 22.98           O  
ATOM    387  OE2 GLU A  57      24.105   6.050  13.606  1.00 23.49           O  
ATOM    388  N   SER A  58      22.181   1.852  16.628  1.00 16.72           N  
ATOM    389  CA  SER A  58      20.942   1.079  16.721  1.00 15.59           C  
ATOM    390  C   SER A  58      21.161  -0.291  16.078  1.00 15.52           C  
ATOM    391  O   SER A  58      22.218  -0.522  15.498  1.00 15.12           O  
ATOM    392  CB  SER A  58      19.798   1.848  16.042  1.00 15.52           C  
ATOM    393  OG  SER A  58      19.906   1.841  14.630  1.00 16.88           O  
ATOM    394  N   PRO A  59      20.199  -1.224  16.193  1.00 14.52           N  
ATOM    395  CA  PRO A  59      20.370  -2.499  15.501  1.00 14.85           C  
ATOM    396  C   PRO A  59      20.646  -2.409  14.000  1.00 14.65           C  
ATOM    397  O   PRO A  59      21.278  -3.317  13.437  1.00 14.96           O  
ATOM    398  CB  PRO A  59      19.037  -3.185  15.760  1.00 14.79           C  
ATOM    399  CG  PRO A  59      18.648  -2.672  17.099  1.00 14.11           C  
ATOM    400  CD  PRO A  59      18.957  -1.229  16.995  1.00 14.37           C  
ATOM    401  N   ALA A  60      20.194  -1.321  13.365  1.00 14.00           N  
ATOM    402  CA  ALA A  60      20.359  -1.141  11.927  1.00 14.09           C  
ATOM    403  C   ALA A  60      21.565  -0.262  11.623  1.00 13.95           C  
ATOM    404  O   ALA A  60      21.919  -0.103  10.464  1.00 14.68           O  
ATOM    405  CB  ALA A  60      19.099  -0.540  11.305  1.00 14.66           C  
ATOM    406  N   LYS A  61      22.178   0.316  12.657  1.00 13.50           N  
ATOM    407  CA  LYS A  61      23.262   1.276  12.444  1.00 13.26           C  
ATOM    408  C   LYS A  61      24.481   1.062  13.345  1.00 12.70           C  
ATOM    409  O   LYS A  61      24.592   1.624  14.437  1.00 12.88           O  
ATOM    410  CB  LYS A  61      22.751   2.727  12.503  1.00 14.17           C  
ATOM    411  CG  LYS A  61      21.894   3.082  11.283  1.00 14.50           C  
ATOM    412  CD  LYS A  61      21.367   4.515  11.334  1.00 14.60           C  
ATOM    413  CE  LYS A  61      20.294   4.741  10.279  1.00 18.45           C  
ATOM    414  NZ  LYS A  61      19.814   6.158  10.301  1.00 20.20           N  
ATOM    415  N   ILE A  62      25.395   0.231  12.856  1.00 10.99           N  
ATOM    416  CA  ILE A  62      26.617  -0.097  13.571  1.00 10.38           C  
ATOM    417  C   ILE A  62      27.786   0.507  12.814  1.00  9.57           C  
ATOM    418  O   ILE A  62      27.951   0.242  11.625  1.00  9.85           O  
ATOM    419  CB  ILE A  62      26.794  -1.626  13.706  1.00 10.81           C  
ATOM    420  CG1 ILE A  62      25.507  -2.235  14.264  1.00 13.60           C  
ATOM    421  CG2 ILE A  62      28.004  -1.954  14.574  1.00 10.34           C  
ATOM    422  CD1 ILE A  62      25.483  -3.715  14.409  1.00 19.47           C  
ATOM    423  N   HIS A  63      28.562   1.347  13.501  1.00  8.72           N  
ATOM    424  CA  HIS A  63      29.712   2.024  12.905  1.00  9.01           C  
ATOM    425  C   HIS A  63      30.892   1.083  12.991  1.00  8.69           C  
ATOM    426  O   HIS A  63      31.275   0.684  14.078  1.00  8.99           O  
ATOM    427  CB  HIS A  63      30.044   3.332  13.637  1.00 10.21           C  
ATOM    428  CG  HIS A  63      28.952   4.361  13.583  1.00 11.62           C  
ATOM    429  ND1 HIS A  63      27.642   4.083  13.913  1.00 15.19           N  
ATOM    430  CD2 HIS A  63      28.995   5.681  13.292  1.00 14.31           C  
ATOM    431  CE1 HIS A  63      26.916   5.179  13.782  1.00 15.96           C  
ATOM    432  NE2 HIS A  63      27.716   6.168  13.428  1.00 14.96           N  
ATOM    433  N   VAL A  64      31.449   0.722  11.837  1.00  7.77           N  
ATOM    434  CA  VAL A  64      32.637  -0.136  11.800  1.00  8.19           C  
ATOM    435  C   VAL A  64      33.807   0.475  11.043  1.00  8.74           C  
ATOM    436  O   VAL A  64      33.644   1.389  10.223  1.00  8.21           O  
ATOM    437  CB  VAL A  64      32.340  -1.534  11.187  1.00  8.10           C  
ATOM    438  CG1 VAL A  64      31.206  -2.221  11.962  1.00  9.03           C  
ATOM    439  CG2 VAL A  64      32.059  -1.445   9.662  1.00  7.74           C  
ATOM    440  N   PHE A  65      34.979  -0.067  11.325  1.00  7.92           N  
ATOM    441  CA  PHE A  65      36.238   0.325  10.705  1.00  7.55           C  
ATOM    442  C   PHE A  65      36.784  -0.934  10.055  1.00  6.71           C  
ATOM    443  O   PHE A  65      36.957  -1.951  10.721  1.00  6.44           O  
ATOM    444  CB  PHE A  65      37.195   0.829  11.793  1.00  8.39           C  
ATOM    445  CG  PHE A  65      38.599   1.113  11.323  1.00  8.22           C  
ATOM    446  CD1 PHE A  65      38.866   2.266  10.614  1.00 11.38           C  
ATOM    447  CD2 PHE A  65      39.667   0.277  11.680  1.00 11.16           C  
ATOM    448  CE1 PHE A  65      40.187   2.565  10.197  1.00 12.53           C  
ATOM    449  CE2 PHE A  65      40.974   0.561  11.265  1.00 11.65           C  
ATOM    450  CZ  PHE A  65      41.225   1.715  10.526  1.00 11.67           C  
ATOM    451  N   TYR A  66      37.007  -0.863   8.742  1.00  7.49           N  
ATOM    452  CA  TYR A  66      37.582  -1.975   8.003  1.00  7.11           C  
ATOM    453  C   TYR A  66      39.090  -1.999   8.269  1.00  6.88           C  
ATOM    454  O   TYR A  66      39.838  -1.161   7.736  1.00  6.36           O  
ATOM    455  CB  TYR A  66      37.278  -1.835   6.509  1.00  7.67           C  
ATOM    456  CG  TYR A  66      35.845  -2.097   6.175  1.00  8.49           C  
ATOM    457  CD1 TYR A  66      35.374  -3.391   6.030  1.00  8.17           C  
ATOM    458  CD2 TYR A  66      34.955  -1.048   6.000  1.00 10.47           C  
ATOM    459  CE1 TYR A  66      34.035  -3.637   5.724  1.00  9.97           C  
ATOM    460  CE2 TYR A  66      33.603  -1.289   5.672  1.00 12.04           C  
ATOM    461  CZ  TYR A  66      33.167  -2.579   5.542  1.00 11.25           C  
ATOM    462  OH  TYR A  66      31.848  -2.839   5.227  1.00 11.44           O  
ATOM    463  N   ILE A  67      39.541  -2.957   9.080  1.00  7.14           N  
ATOM    464  CA  ILE A  67      40.874  -2.875   9.642  1.00  7.34           C  
ATOM    465  C   ILE A  67      41.993  -3.093   8.649  1.00  7.59           C  
ATOM    466  O   ILE A  67      43.125  -2.734   8.931  1.00  8.49           O  
ATOM    467  CB  ILE A  67      41.080  -3.833  10.863  1.00  7.60           C  
ATOM    468  CG1 ILE A  67      41.032  -5.313  10.441  1.00  7.26           C  
ATOM    469  CG2 ILE A  67      40.064  -3.513  11.954  1.00  7.87           C  
ATOM    470  CD1 ILE A  67      41.478  -6.328  11.537  1.00  7.54           C  
ATOM    471  N   ASP A  68      41.666  -3.665   7.497  1.00  6.63           N  
ATOM    472  CA  ASP A  68      42.687  -3.916   6.476  1.00  7.05           C  
ATOM    473  C   ASP A  68      42.713  -2.882   5.369  1.00  9.18           C  
ATOM    474  O   ASP A  68      43.597  -2.933   4.501  1.00  7.85           O  
ATOM    475  CB  ASP A  68      42.526  -5.331   5.907  1.00  7.68           C  
ATOM    476  CG  ASP A  68      42.705  -6.408   6.961  1.00  6.89           C  
ATOM    477  OD1 ASP A  68      43.664  -6.286   7.761  1.00  7.64           O  
ATOM    478  OD2 ASP A  68      41.899  -7.379   6.982  1.00  6.50           O  
ATOM    479  N   TYR A  69      41.779  -1.933   5.422  1.00  9.32           N  
ATOM    480  CA  TYR A  69      41.587  -0.949   4.354  1.00 11.47           C  
ATOM    481  C   TYR A  69      41.492   0.504   4.828  1.00 12.87           C  
ATOM    482  O   TYR A  69      41.762   1.417   4.047  1.00 15.01           O  
ATOM    483  CB  TYR A  69      40.383  -1.364   3.485  1.00 12.57           C  
ATOM    484  CG  TYR A  69      40.673  -2.625   2.703  1.00 13.30           C  
ATOM    485  CD1 TYR A  69      41.282  -2.548   1.449  1.00 14.89           C  
ATOM    486  CD2 TYR A  69      40.397  -3.899   3.228  1.00 13.30           C  
ATOM    487  CE1 TYR A  69      41.590  -3.679   0.743  1.00 15.28           C  
ATOM    488  CE2 TYR A  69      40.700  -5.054   2.506  1.00 14.23           C  
ATOM    489  CZ  TYR A  69      41.298  -4.929   1.253  1.00 15.88           C  
ATOM    490  OH  TYR A  69      41.625  -6.066   0.531  1.00 18.62           O  
ATOM    491  N   GLY A  70      41.097   0.737   6.080  1.00 12.41           N  
ATOM    492  CA  GLY A  70      41.165   2.092   6.660  1.00 12.77           C  
ATOM    493  C   GLY A  70      39.949   2.991   6.525  1.00 13.80           C  
ATOM    494  O   GLY A  70      39.967   4.162   6.938  1.00 15.56           O  
ATOM    495  N   ASN A  71      38.871   2.445   5.979  1.00 11.91           N  
ATOM    496  CA  ASN A  71      37.626   3.188   5.806  1.00 12.06           C  
ATOM    497  C   ASN A  71      36.593   2.750   6.816  1.00 11.00           C  
ATOM    498  O   ASN A  71      36.721   1.700   7.444  1.00  9.86           O  
ATOM    499  CB  ASN A  71      37.048   2.964   4.416  1.00 13.54           C  
ATOM    500  CG  ASN A  71      36.574   1.552   4.220  1.00 15.80           C  
ATOM    501  OD1 ASN A  71      37.324   0.616   4.479  1.00 17.84           O  
ATOM    502  ND2 ASN A  71      35.328   1.379   3.754  1.00 20.38           N  
ATOM    503  N   ARG A  72      35.547   3.553   6.919  1.00 10.26           N  
ATOM    504  CA  ARG A  72      34.450   3.295   7.830  1.00 10.82           C  
ATOM    505  C   ARG A  72      33.132   3.133   7.091  1.00 11.23           C  
ATOM    506  O   ARG A  72      32.965   3.607   5.955  1.00 12.12           O  
ATOM    507  CB  ARG A  72      34.368   4.422   8.855  1.00 10.82           C  
ATOM    508  CG  ARG A  72      35.568   4.469   9.744  1.00 11.43           C  
ATOM    509  CD  ARG A  72      35.614   5.633  10.687  1.00 16.64           C  
ATOM    510  NE  ARG A  72      36.617   5.367  11.715  1.00 20.12           N  
ATOM    511  CZ  ARG A  72      37.931   5.520  11.568  1.00 22.27           C  
ATOM    512  NH1 ARG A  72      38.446   5.968  10.423  1.00 21.85           N  
ATOM    513  NH2 ARG A  72      38.739   5.227  12.580  1.00 24.71           N  
ATOM    514  N   GLU A  73      32.202   2.432   7.728  1.00 10.61           N  
ATOM    515  CA  GLU A  73      30.864   2.283   7.190  1.00 11.24           C  
ATOM    516  C   GLU A  73      29.904   2.127   8.337  1.00 11.43           C  
ATOM    517  O   GLU A  73      30.279   1.620   9.391  1.00 10.84           O  
ATOM    518  CB  GLU A  73      30.764   1.061   6.257  1.00 10.72           C  
ATOM    519  CG  GLU A  73      29.446   0.994   5.479  1.00 11.40           C  
ATOM    520  CD  GLU A  73      29.344  -0.208   4.536  1.00 12.76           C  
ATOM    521  OE1 GLU A  73      28.318  -0.338   3.847  1.00 14.44           O  
ATOM    522  OE2 GLU A  73      30.274  -1.033   4.478  1.00 14.95           O  
ATOM    523  N   VAL A  74      28.665   2.571   8.121  1.00 11.98           N  
ATOM    524  CA  VAL A  74      27.572   2.339   9.047  1.00 12.92           C  
ATOM    525  C   VAL A  74      26.679   1.299   8.408  1.00 13.54           C  
ATOM    526  O   VAL A  74      26.146   1.507   7.307  1.00 14.80           O  
ATOM    527  CB  VAL A  74      26.758   3.618   9.298  1.00 12.80           C  
ATOM    528  CG1 VAL A  74      25.603   3.311  10.240  1.00 13.58           C  
ATOM    529  CG2 VAL A  74      27.652   4.708   9.895  1.00 12.51           C  
ATOM    530  N   LEU A  75      26.521   0.163   9.079  1.00 13.44           N  
ATOM    531  CA  LEU A  75      25.750  -0.932   8.497  1.00 14.25           C  
ATOM    532  C   LEU A  75      24.892  -1.670   9.514  1.00 13.22           C  
ATOM    533  O   LEU A  75      25.113  -1.559  10.716  1.00 12.25           O  
ATOM    534  CB  LEU A  75      26.643  -1.900   7.704  1.00 15.99           C  
ATOM    535  CG  LEU A  75      28.119  -2.088   8.021  1.00 17.07           C  
ATOM    536  CD1 LEU A  75      28.329  -2.425   9.501  1.00 20.86           C  
ATOM    537  CD2 LEU A  75      28.738  -3.135   7.120  1.00 15.99           C  
ATOM    538  N   PRO A  76      23.895  -2.422   9.031  1.00 12.74           N  
ATOM    539  CA  PRO A  76      23.026  -3.122   9.959  1.00 12.92           C  
ATOM    540  C   PRO A  76      23.716  -4.362  10.547  1.00 13.41           C  
ATOM    541  O   PRO A  76      24.677  -4.865   9.960  1.00 12.87           O  
ATOM    542  CB  PRO A  76      21.832  -3.511   9.084  1.00 12.86           C  
ATOM    543  CG  PRO A  76      22.405  -3.697   7.725  1.00 14.03           C  
ATOM    544  CD  PRO A  76      23.522  -2.666   7.622  1.00 13.02           C  
ATOM    545  N   SER A  77      23.230  -4.832  11.696  1.00 14.51           N  
ATOM    546  CA  SER A  77      23.744  -6.042  12.341  1.00 15.00           C  
ATOM    547  C   SER A  77      23.726  -7.266  11.427  1.00 14.09           C  
ATOM    548  O   SER A  77      24.519  -8.199  11.602  1.00 13.74           O  
ATOM    549  CB  SER A  77      22.960  -6.343  13.634  1.00 16.06           C  
ATOM    550  OG  SER A  77      23.226  -7.667  14.068  1.00 22.19           O  
ATOM    551  N   THR A  78      22.807  -7.272  10.460  1.00 13.92           N  
ATOM    552  CA  THR A  78      22.642  -8.408   9.557  1.00 14.96           C  
ATOM    553  C   THR A  78      23.884  -8.592   8.675  1.00 13.76           C  
ATOM    554  O   THR A  78      24.165  -9.699   8.226  1.00 14.77           O  
ATOM    555  CB  THR A  78      21.378  -8.283   8.672  1.00 15.98           C  
ATOM    556  OG1 THR A  78      20.251  -7.902   9.472  1.00 19.42           O  
ATOM    557  CG2 THR A  78      21.057  -9.612   8.019  1.00 17.39           C  
ATOM    558  N   ARG A  79      24.637  -7.510   8.468  1.00 11.80           N  
ATOM    559  CA  ARG A  79      25.817  -7.564   7.618  1.00 11.23           C  
ATOM    560  C   ARG A  79      27.102  -7.668   8.437  1.00  9.42           C  
ATOM    561  O   ARG A  79      28.192  -7.348   7.948  1.00 10.11           O  
ATOM    562  CB  ARG A  79      25.859  -6.353   6.698  1.00 10.10           C  
ATOM    563  CG  ARG A  79      24.707  -6.353   5.704  1.00 12.61           C  
ATOM    564  CD  ARG A  79      24.775  -5.176   4.771  1.00 15.74           C  
ATOM    565  NE  ARG A  79      25.761  -5.384   3.710  1.00 17.57           N  
ATOM    566  CZ  ARG A  79      25.531  -6.051   2.582  1.00 17.11           C  
ATOM    567  NH1 ARG A  79      24.344  -6.616   2.358  1.00 17.10           N  
ATOM    568  NH2 ARG A  79      26.501  -6.170   1.677  1.00 16.38           N  
ATOM    569  N   LEU A  80      26.972  -8.116   9.672  1.00  8.73           N  
ATOM    570  CA  LEU A  80      28.129  -8.356  10.529  1.00  8.38           C  
ATOM    571  C   LEU A  80      28.120  -9.808  10.973  1.00  8.09           C  
ATOM    572  O   LEU A  80      27.083 -10.413  11.137  1.00  9.50           O  
ATOM    573  CB  LEU A  80      28.136  -7.431  11.753  1.00  8.40           C  
ATOM    574  CG  LEU A  80      28.086  -5.928  11.489  1.00  8.76           C  
ATOM    575  CD1 LEU A  80      28.000  -5.215  12.803  1.00 11.21           C  
ATOM    576  CD2 LEU A  80      29.307  -5.431  10.731  1.00 10.32           C  
ATOM    577  N   GLY A  81      29.295 -10.367  11.202  1.00  6.58           N  
ATOM    578  CA  GLY A  81      29.405 -11.729  11.688  1.00  7.37           C  
ATOM    579  C   GLY A  81      30.609 -11.912  12.596  1.00  7.23           C  
ATOM    580  O   GLY A  81      31.429 -11.014  12.738  1.00  8.53           O  
ATOM    581  N   THR A  82      30.715 -13.096  13.202  1.00  7.85           N  
ATOM    582  CA  THR A  82      31.846 -13.415  14.050  1.00  8.67           C  
ATOM    583  C   THR A  82      33.112 -13.532  13.214  1.00  8.64           C  
ATOM    584  O   THR A  82      33.113 -14.166  12.155  1.00  9.11           O  
ATOM    585  CB  THR A  82      31.606 -14.748  14.798  1.00  8.03           C  
ATOM    586  OG1 THR A  82      30.466 -14.594  15.662  1.00 10.15           O  
ATOM    587  CG2 THR A  82      32.802 -15.142  15.654  1.00  9.85           C  
ATOM    588  N   LEU A  83      34.201 -12.948  13.712  1.00  8.23           N  
ATOM    589  CA  LEU A  83      35.519 -13.152  13.121  1.00  9.11           C  
ATOM    590  C   LEU A  83      36.133 -14.407  13.726  1.00  9.64           C  
ATOM    591  O   LEU A  83      36.452 -14.443  14.906  1.00 11.99           O  
ATOM    592  CB  LEU A  83      36.435 -11.949  13.379  1.00  8.12           C  
ATOM    593  CG  LEU A  83      37.860 -12.018  12.823  1.00  9.31           C  
ATOM    594  CD1 LEU A  83      37.815 -12.182  11.304  1.00  7.70           C  
ATOM    595  CD2 LEU A  83      38.612 -10.751  13.194  1.00  9.48           C  
ATOM    596  N   SER A  84      36.265 -15.454  12.926  1.00 11.22           N  
ATOM    597  CA  SER A  84      36.839 -16.697  13.446  1.00 11.88           C  
ATOM    598  C   SER A  84      38.274 -16.502  13.875  1.00 12.27           C  
ATOM    599  O   SER A  84      38.992 -15.704  13.275  1.00 10.46           O  
ATOM    600  CB  SER A  84      36.728 -17.823  12.435  1.00 13.17           C  
ATOM    601  OG  SER A  84      36.997 -17.368  11.136  1.00 19.63           O  
ATOM    602  N   PRO A  85      38.674 -17.175  14.970  1.00 12.42           N  
ATOM    603  CA  PRO A  85      40.033 -17.070  15.494  1.00 12.91           C  
ATOM    604  C   PRO A  85      41.134 -17.297  14.441  1.00 12.58           C  
ATOM    605  O   PRO A  85      42.194 -16.686  14.549  1.00 13.12           O  
ATOM    606  CB  PRO A  85      40.076 -18.165  16.566  1.00 13.18           C  
ATOM    607  CG  PRO A  85      38.661 -18.289  17.024  1.00 13.97           C  
ATOM    608  CD  PRO A  85      37.806 -18.018  15.823  1.00 12.73           C  
ATOM    609  N   ALA A  86      40.876 -18.145  13.444  1.00 12.52           N  
ATOM    610  CA  ALA A  86      41.849 -18.460  12.384  1.00 12.25           C  
ATOM    611  C   ALA A  86      42.230 -17.257  11.526  1.00 11.58           C  
ATOM    612  O   ALA A  86      43.244 -17.293  10.829  1.00 12.16           O  
ATOM    613  CB  ALA A  86      41.334 -19.597  11.503  1.00 12.44           C  
ATOM    614  N   PHE A  87      41.415 -16.201  11.583  1.00 10.45           N  
ATOM    615  CA  PHE A  87      41.618 -14.999  10.763  1.00  9.91           C  
ATOM    616  C   PHE A  87      41.702 -13.731  11.588  1.00  9.11           C  
ATOM    617  O   PHE A  87      41.528 -12.622  11.069  1.00  8.99           O  
ATOM    618  CB  PHE A  87      40.503 -14.895   9.719  1.00  9.75           C  
ATOM    619  CG  PHE A  87      40.240 -16.198   9.032  1.00 10.67           C  
ATOM    620  CD1 PHE A  87      41.211 -16.786   8.219  1.00 12.63           C  
ATOM    621  CD2 PHE A  87      39.067 -16.881   9.274  1.00 11.81           C  
ATOM    622  CE1 PHE A  87      40.987 -18.033   7.630  1.00 13.02           C  
ATOM    623  CE2 PHE A  87      38.839 -18.123   8.679  1.00 13.06           C  
ATOM    624  CZ  PHE A  87      39.803 -18.685   7.857  1.00 13.42           C  
ATOM    625  N   SER A  88      41.986 -13.913  12.877  1.00  9.50           N  
ATOM    626  CA  SER A  88      42.070 -12.814  13.833  1.00  9.78           C  
ATOM    627  C   SER A  88      43.366 -12.000  13.659  1.00  9.08           C  
ATOM    628  O   SER A  88      44.253 -12.345  12.857  1.00  8.46           O  
ATOM    629  CB  SER A  88      42.019 -13.372  15.247  1.00 10.33           C  
ATOM    630  OG  SER A  88      43.221 -14.033  15.575  1.00 12.56           O  
ATOM    631  N   THR A  89      43.467 -10.914  14.423  1.00  9.54           N  
ATOM    632  CA  THR A  89      44.659 -10.079  14.408  1.00 10.48           C  
ATOM    633  C   THR A  89      45.847 -10.728  15.106  1.00 11.01           C  
ATOM    634  O   THR A  89      46.971 -10.235  15.001  1.00 11.02           O  
ATOM    635  CB  THR A  89      44.408  -8.680  15.003  1.00 10.45           C  
ATOM    636  OG1 THR A  89      43.828  -8.801  16.308  1.00 13.43           O  
ATOM    637  CG2 THR A  89      43.482  -7.867  14.103  1.00 11.31           C  
ATOM    638  N   ARG A  90      45.598 -11.829  15.811  1.00 10.98           N  
ATOM    639  CA  ARG A  90      46.688 -12.664  16.319  1.00 11.79           C  
ATOM    640  C   ARG A  90      47.377 -13.385  15.163  1.00 12.16           C  
ATOM    641  O   ARG A  90      48.555 -13.708  15.244  1.00 14.09           O  
ATOM    642  CB  ARG A  90      46.152 -13.683  17.348  1.00 12.18           C  
ATOM    643  N   VAL A  91      46.628 -13.647  14.090  1.00 12.40           N  
ATOM    644  CA  VAL A  91      47.155 -14.349  12.910  1.00 11.61           C  
ATOM    645  C   VAL A  91      47.820 -13.385  11.914  1.00 11.55           C  
ATOM    646  O   VAL A  91      48.946 -13.630  11.445  1.00 11.34           O  
ATOM    647  CB  VAL A  91      46.052 -15.195  12.228  1.00 12.01           C  
ATOM    648  CG1 VAL A  91      46.567 -15.836  10.939  1.00 11.38           C  
ATOM    649  CG2 VAL A  91      45.535 -16.274  13.189  1.00 13.46           C  
ATOM    650  N   LEU A  92      47.126 -12.304  11.575  1.00 10.49           N  
ATOM    651  CA  LEU A  92      47.707 -11.250  10.755  1.00 10.13           C  
ATOM    652  C   LEU A  92      47.218  -9.920  11.294  1.00 10.20           C  
ATOM    653  O   LEU A  92      46.013  -9.716  11.382  1.00 10.43           O  
ATOM    654  CB  LEU A  92      47.299 -11.391   9.281  1.00 10.47           C  
ATOM    655  CG  LEU A  92      47.867 -10.373   8.285  1.00 10.62           C  
ATOM    656  CD1 LEU A  92      49.358 -10.625   8.045  1.00 12.68           C  
ATOM    657  CD2 LEU A  92      47.069 -10.444   7.001  1.00 12.44           C  
ATOM    658  N   PRO A  93      48.141  -9.008  11.664  1.00 10.99           N  
ATOM    659  CA  PRO A  93      47.745  -7.697  12.178  1.00 10.94           C  
ATOM    660  C   PRO A  93      46.900  -6.892  11.164  1.00 10.31           C  
ATOM    661  O   PRO A  93      46.893  -7.222   9.955  1.00 10.05           O  
ATOM    662  CB  PRO A  93      49.102  -6.992  12.428  1.00 11.38           C  
ATOM    663  CG  PRO A  93      50.079  -8.115  12.586  1.00 12.85           C  
ATOM    664  CD  PRO A  93      49.608  -9.154  11.611  1.00 11.33           C  
ATOM    665  N   ALA A  94      46.186  -5.878  11.661  1.00 10.77           N  
ATOM    666  CA  ALA A  94      45.424  -4.937  10.810  1.00 10.61           C  
ATOM    667  C   ALA A  94      46.321  -4.365   9.710  1.00 11.01           C  
ATOM    668  O   ALA A  94      47.414  -3.859  10.006  1.00 11.18           O  
ATOM    669  CB  ALA A  94      44.850  -3.806  11.650  1.00 10.59           C  
ATOM    670  N   GLN A  95      45.846  -4.420   8.464  1.00 11.03           N  
ATOM    671  CA  GLN A  95      46.671  -4.051   7.307  1.00 11.79           C  
ATOM    672  C   GLN A  95      46.373  -2.659   6.742  1.00 12.79           C  
ATOM    673  O   GLN A  95      46.888  -2.315   5.671  1.00 12.98           O  
ATOM    674  CB  GLN A  95      46.571  -5.124   6.204  1.00 12.29           C  
ATOM    675  CG  GLN A  95      47.044  -6.518   6.640  1.00 13.45           C  
ATOM    676  CD  GLN A  95      48.565  -6.610   6.841  1.00 13.31           C  
ATOM    677  OE1 GLN A  95      49.059  -6.872   7.956  1.00 14.52           O  
ATOM    678  NE2 GLN A  95      49.314  -6.364   5.770  1.00 13.82           N  
ATOM    679  N   ALA A  96      45.563  -1.849   7.429  1.00 13.37           N  
ATOM    680  CA  ALA A  96      45.214  -0.528   6.881  1.00 14.24           C  
ATOM    681  C   ALA A  96      46.507   0.219   6.579  1.00 15.32           C  
ATOM    682  O   ALA A  96      47.437   0.180   7.384  1.00 16.13           O  
ATOM    683  CB  ALA A  96      44.322   0.254   7.832  1.00 14.07           C  
ATOM    684  N   THR A  97      46.565   0.846   5.397  1.00 16.22           N  
ATOM    685  CA  THR A  97      47.773   1.543   4.914  1.00 16.79           C  
ATOM    686  C   THR A  97      47.853   2.974   5.428  1.00 17.26           C  
ATOM    687  CB  THR A  97      47.889   1.570   3.352  1.00 17.23           C  
ATOM    688  OG1 THR A  97      46.954   2.504   2.774  1.00 19.66           O  
ATOM    689  CG2 THR A  97      47.663   0.189   2.760  1.00 17.25           C  
TER     690      THR A  97                                                      
END
MOLECULE T0429_22_99.pdb
ATOM      1  N   GLU    22      23.143   8.727  21.130  1.00172.90      A    N  
ATOM      2  CA  GLU    22      22.374   7.758  20.286  1.00169.34      A    C  
ATOM      3  CB  GLU    22      22.276   8.259  18.835  1.00168.54      A    C  
ATOM      4  CG  GLU    22      23.616   8.393  18.103  1.00158.10      A    C  
ATOM      5  CD  GLU    22      23.457   8.575  16.601  1.00157.25      A    C  
ATOM      6  OE1 GLU    22      24.348   8.113  15.852  1.00147.23      A    O  
ATOM      7  OE2 GLU    22      22.446   9.173  16.165  1.00167.76      A    O  
ATOM      8  C   GLU    22      22.931   6.322  20.338  1.00157.48      A    C  
ATOM      9  O   GLU    22      22.498   5.455  19.576  1.00152.96      A    O  
ATOM     10  N   THR    23      23.876   6.088  21.250  1.00154.10      A    N  
ATOM     11  CA  THR    23      24.505   4.776  21.452  1.00145.40      A    C  
ATOM     12  CB  THR    23      25.730   4.896  22.405  1.00143.94      A    C  
ATOM     13  OG1 THR    23      26.652   5.863  21.883  1.00141.32      A    O  
ATOM     14  CG2 THR    23      26.454   3.563  22.562  1.00136.43      A    C  
ATOM     15  C   THR    23      23.503   3.729  21.972  1.00150.21      A    C  
ATOM     16  O   THR    23      22.570   4.068  22.704  1.00162.36      A    O  
ATOM     17  N   GLU    24      23.706   2.466  21.590  1.00143.04      A    N  
ATOM     18  CA  GLU    24      22.756   1.383  21.886  1.00147.93      A    C  
ATOM     19  CB  GLU    24      22.210   0.789  20.580  1.00144.01      A    C  
ATOM     24  C   GLU    24      23.290   0.256  22.791  1.00146.91      A    C  
ATOM     25  O   GLU    24      22.482  -0.568  23.303  1.00154.53      A    O  
ATOM     26  N   LEU    25      24.636   0.215  22.968  1.00139.01      A    N  
ATOM     27  CA  LEU    25      25.295  -0.776  23.847  1.00138.87      A    C  
ATOM     28  CB  LEU    25      25.029  -0.457  25.346  1.00151.41      A    C  
ATOM     29  CG  LEU    25      26.098  -0.729  26.420  1.00153.60      A    C  
ATOM     30  CD1 LEU    25      25.557  -0.342  27.808  1.00166.65      A    C  
ATOM     31  CD2 LEU    25      26.620  -2.188  26.419  1.00150.16      A    C  
ATOM     32  C   LEU    25      24.901  -2.238  23.511  1.00137.26      A    C  
ATOM     33  O   LEU    25      24.248  -2.938  24.308  1.00144.91      A    O  
ATOM     34  N   LEU    27      24.229  -6.765  19.987  1.00124.47      A    N  
ATOM     35  CA  LEU    27      24.721  -8.135  19.817  1.00123.94      A    C  
ATOM     36  CB  LEU    27      24.018  -8.864  18.654  1.00124.12      A    C  
ATOM     37  CG  LEU    27      23.652  -8.221  17.310  1.00118.98      A    C  
ATOM     38  CD1 LEU    27      23.488  -9.322  16.264  1.00118.08      A    C  
ATOM     38  CD2 LEU    27      22.365  -7.397  17.414  1.00128.31      A    C  
ATOM     40  C   LEU    27      26.247  -8.245  19.696  1.00114.60      A    C  
ATOM     41  O   LEU    27      26.853  -9.156  20.263  1.00117.26      A    O  
ATOM     42  N   TYR    28      26.862  -7.335  18.947  1.00105.66      A    N  
ATOM     43  CA  TYR    28      28.319  -7.200  18.963  1.00 99.30      A    C  
ATOM     44  CB  TYR    28      28.923  -7.286  17.548  1.00 89.68      A    C  
ATOM     45  CG  TYR    28      28.406  -8.478  16.772  1.00 88.71      A    C  
ATOM     46  CD1 TYR    28      28.819  -9.774  17.087  1.00 90.89      A    C  
ATOM     47  CE1 TYR    28      28.325 -10.875  16.393  1.00 93.27      A    C  
ATOM     48  CZ  TYR    28      27.402 -10.683  15.376  1.00 92.44      A    C  
ATOM     49  OH  TYR    28      26.907 -11.765  14.685  1.00 96.36      A    O  
ATOM     50  CE2 TYR    28      26.974  -9.408  15.047  1.00 89.46      A    C  
ATOM     51  CD2 TYR    28      27.475  -8.315  15.748  1.00 87.20      A    C  
ATOM     52  C   TYR    28      28.651  -5.890  19.660  1.00100.94      A    C  
ATOM     53  O   TYR    28      28.114  -4.836  19.311  1.00100.23      A    O  
ATOM     54  N   LYS    29      29.505  -5.973  20.675  1.00104.98      A    N  
ATOM     55  CA  LYS    29      29.862  -4.813  21.481  1.00108.51      A    C  
ATOM     56  CB  LYS    29      30.333  -5.254  22.871  1.00116.86      A    C  
ATOM     61  C   LYS    29      30.923  -3.949  20.793  1.00102.56      A    C  
ATOM     62  O   LYS    29      31.688  -4.428  19.957  1.00 96.86      A    O  
ATOM     63  N   VAL    30      30.941  -2.667  21.147  1.00106.01      A    N  
ATOM     64  CA  VAL    30      31.946  -1.717  20.668  1.00103.19      A    C  
ATOM     65  CB  VAL    30      31.691  -0.300  21.261  1.00109.00      A    C  
ATOM     66  CG1 VAL    30      31.681  -0.327  22.793  1.00117.99      A    C  
ATOM     67  CG2 VAL    30      32.698   0.704  20.741  1.00108.94      A    C  
ATOM     68  C   VAL    30      33.374  -2.211  20.960  1.00103.89      A    C  
ATOM     69  O   VAL    30      33.667  -2.667  22.065  1.00110.81      A    O  
ATOM     70  N   ASN    31      34.238  -2.134  19.948  1.00 98.81      A    N  
ATOM     71  CA  ASN    31      35.638  -2.589  20.016  1.00 99.77      A    C  
ATOM     72  CB  ASN    31      36.312  -2.208  21.337  1.00108.53      A    C  
ATOM     73  CG  ASN    31      36.624  -0.747  21.416  1.00112.78      A    C  
ATOM     74  OD1 ASN    31      35.766   0.061  21.763  1.00116.34      A    O  
ATOM     75  ND2 ASN    31      37.861  -0.390  21.095  1.00116.64      A    N  
ATOM     76  C   ASN    31      35.858  -4.066  19.726  1.00 96.91      A    C  
ATOM     77  O   ASN    31      37.000  -4.499  19.568  1.00 98.59      A    O  
ATOM     78  N   GLU    32      34.779  -4.839  19.660  1.00 94.41      A    N  
ATOM     79  CA  GLU    32      34.889  -6.234  19.254  1.00 93.05      A    C  
ATOM     80  CB  GLU    32      33.592  -6.998  19.533  1.00 94.24      A    C  
ATOM     81  CG  GLU    32      33.730  -8.518  19.443  1.00 96.69      A    C  
ATOM     82  CD  GLU    32      32.437  -9.259  19.760  1.00101.02      A    C  
ATOM     83  OE1 GLU    32      31.677  -8.814  20.653  1.00104.59      A    O  
ATOM     84  OE2 GLU    32      32.191 -10.304  19.112  1.00101.68      A    O  
ATOM     85  C   GLU    32      35.248  -6.293  17.770  1.00 85.89      A    C  
ATOM     86  O   GLU    32      34.742  -5.503  16.970  1.00 81.52      A    O  
ATOM     87  N   TYR    33      36.146  -7.212  17.424  1.00 86.41      A    N  
ATOM     88  CA  TYR    33      36.514  -7.452  16.032  1.00 80.84      A    C  
ATOM     89  CB  TYR    33      37.902  -8.087  15.933  1.00 84.64      A    C  
ATOM     90  CG  TYR    33      39.026  -7.173  16.361  1.00 88.89      A    C  
ATOM     91  CD1 TYR    33      39.565  -6.233  15.478  1.00 87.72      A    C  
ATOM     92  CE1 TYR    33      40.604  -5.390  15.869  1.00 93.77      A    C  
ATOM     93  CZ  TYR    33      41.113  -5.488  17.158  1.00102.17      A    C  
ATOM     94  OH  TYR    33      42.137  -4.665  17.562  1.00109.70      A    O  
ATOM     95  CE2 TYR    33      40.595  -6.415  18.049  1.00103.06      A    C  
ATOM     96  CD2 TYR    33      39.558  -7.251  17.645  1.00 96.63      A    C  
ATOM     97  C   TYR    33      35.481  -8.343  15.365  1.00 77.13      A    C  
ATOM     98  O   TYR    33      34.999  -9.304  15.962  1.00 80.54      A    O  
ATOM     99  N   VAL    34      35.150  -8.015  14.121  1.00 71.92      A    N  
ATOM    100  CA  VAL    34      34.093  -8.702  13.387  1.00 68.82      A    C  
ATOM    101  CB  VAL    34      32.747  -7.920  13.464  1.00 68.44      A    C  
ATOM    102  CG1 VAL    34      32.177  -7.925  14.884  1.00 71.47      A    C  
ATOM    103  CG2 VAL    34      32.898  -6.493  12.926  1.00 64.40      A    C  
ATOM    104  C   VAL    34      34.460  -8.908  11.914  1.00 66.21      A    C  
ATOM    105  O   VAL    34      35.567  -8.577  11.481  1.00 66.29      A    O  
ATOM    106  N   ASP    35      33.522  -9.472  11.162  1.00 64.66      A    N  
ATOM    107  CA  ASP    35      33.597  -9.509   9.715  1.00 63.00      A    C  
ATOM    108  CB  ASP    35      33.407 -10.939   9.202  1.00 63.65      A    C  
ATOM    109  CG  ASP    35      34.686 -11.759   9.244  1.00 64.32      A    C  
ATOM    110  OD1 ASP    35      35.783 -11.188   9.069  1.00 62.56      A    O  
ATOM    111  OD2 ASP    35      34.591 -12.990   9.434  1.00 66.48      A    O  
ATOM    112  C   ASP    35      32.473  -8.627   9.199  1.00 63.11      A    C  
ATOM    113  O   ASP    35      31.344  -8.719   9.686  1.00 65.91      A    O  
ATOM    114  N   ALA    36      32.775  -7.773   8.221  1.00 62.20      A    N  
ATOM    115  CA  ALA    36      31.779  -6.853   7.670  1.00 62.48      A    C  
ATOM    116  CB  ALA    36      32.182  -5.415   7.934  1.00 63.64      A    C  
ATOM    117  C   ALA    36      31.607  -7.080   6.186  1.00 63.86      A    C  
ATOM    118  O   ALA    36      32.589  -7.191   5.452  1.00 65.27      A    O  
ATOM    119  N   ARG    37      30.358  -7.138   5.744  1.00 66.32      A    N  
ATOM    120  CA  ARG    37      30.057  -7.410   4.344  1.00 70.06      A    C  
ATOM    121  CB  ARG    37      28.720  -8.159   4.199  1.00 73.46      A    C  
ATOM    122  CG  ARG    37      28.518  -8.813   2.829  1.00 77.70      A    C  
ATOM    123  CD  ARG    37      27.182  -9.543   2.729  1.00 83.79      A    C  
ATOM    124  NE  ARG    37      26.063  -8.613   2.586  1.00 92.01      A    N  
ATOM    125  CZ  ARG    37      25.427  -8.344   1.445  1.00 99.69      A    C  
ATOM    126  NH1 ARG    37      25.775  -8.943   0.309  1.00101.62      A    N  
ATOM    127  NH2 ARG    37      24.425  -7.472   1.444  1.00105.62      A    N  
ATOM    128  C   ARG    37      30.043  -6.122   3.535  1.00 72.97      A    C  
ATOM    129  O   ARG    37      29.183  -5.267   3.734  1.00 76.28      A    O  
ATOM    130  N   ASP    38      31.015  -5.980   2.640  1.00 74.45      A    N  
ATOM    131  CA  ASP    38      30.995  -4.906   1.661  1.00 81.28      A    C  
ATOM    132  CB  ASP    38      32.279  -4.924   0.825  1.00 83.16      A    C  
ATOM    133  CG  ASP    38      32.369  -3.768  -0.157  1.00 91.41      A    C  
ATOM    134  OD1 ASP    38      31.439  -3.583  -0.965  1.00 98.91      A    O  
ATOM    135  OD2 ASP    38      33.394  -3.058  -0.145  1.00 93.84      A    O  
ATOM    136  C   ASP    38      29.768  -5.148   0.794  1.00 87.58      A    C  
ATOM    137  O   ASP    38      29.730  -6.094   0.011  1.00 90.08      A    O  
ATOM    138  N   THR    39      28.754  -4.307   0.961  1.00 92.61      A    N  
ATOM    139  CA  THR    39      27.483  -4.487   0.262  1.00101.09      A    C  
ATOM    140  CB  THR    39      26.377  -3.589   0.863  1.00105.79      A    C  
ATOM    141  OG1 THR    39      26.310  -3.809   2.276  1.00100.08      A    O  
ATOM    142  CG2 THR    39      25.014  -3.910   0.258  1.00115.77      A    C  
ATOM    143  C   THR    39      27.621  -4.263  -1.246  1.00109.30      A    C  
ATOM    144  O   THR    39      26.849  -4.811  -2.034  1.00116.02      A    O  
ATOM    145  N   ASN    40      28.617  -3.475  -1.640  1.00111.13      A    N  
ATOM    146  CA  ASN    40      28.866  -3.188  -3.050  1.00121.02      A    C  
ATOM    147  CB  ASN    40      29.891  -2.057  -3.191  1.00124.44      A    C  
ATOM    148  CG  ASN    40      30.409  -1.907  -4.609  1.00135.60      A    C  
ATOM    149  OD1 ASN    40      31.550  -2.269  -4.903  1.00135.88      A    O  
ATOM    150  ND2 ASN    40      29.567  -1.391  -5.502  1.00147.42      A    N  
ATOM    151  C   ASN    40      29.296  -4.418  -3.857  1.00120.57      A    C  
ATOM    152  O   ASN    40      28.922  -4.560  -5.022  1.00129.57      A    O  
ATOM    153  N   MET    41      30.064  -5.308  -3.234  1.00111.84      A    N  
ATOM    154  CA  MET    41      30.606  -6.478  -3.933  1.00112.47      A    C  
ATOM    155  CB  MET    41      32.122  -6.373  -4.048  1.00111.40      A    C  
ATOM    156  CG  MET    41      32.807  -6.077  -2.737  1.00103.73      A    C  
ATOM    157  SD  MET    41      34.733  -6.073  -2.908  1.00108.38      A   SE  
ATOM    158  CE  MET    41      34.947  -4.830  -4.410  1.00120.35      A    C  
ATOM    159  C   MET    41      30.224  -7.818  -3.307  1.00105.36      A    C  
ATOM    160  O   MET    41      30.327  -8.863  -3.955  1.00106.85      A    O  
ATOM    161  N   GLY    42      29.804  -7.780  -2.047  1.00 83.71      A    N  
ATOM    162  CA  GLY    42      29.269  -8.959  -1.367  1.00 83.07      A    C  
ATOM    163  C   GLY    42      30.262  -9.792  -0.578  1.00 77.08      A    C  
ATOM    164  O   GLY    42      29.914 -10.867  -0.090  1.00 77.31      A    O  
ATOM    165  N   ALA    43      31.490  -9.300  -0.446  1.00 72.89      A    N  
ATOM    166  CA  ALA    43      32.548 -10.041   0.234  1.00 69.07      A    C  
ATOM    167  CB  ALA    43      33.865  -9.848  -0.491  1.00 68.37      A    C  
ATOM    168  C   ALA    43      32.669  -9.636   1.703  1.00 65.34      A    C  
ATOM    169  O   ALA    43      32.300  -8.525   2.077  1.00 65.78      A    O  
ATOM    170  N   TRP    44      33.183 -10.537   2.535  1.00 64.28      A    N  
ATOM    171  CA  TRP    44      33.399 -10.241   3.953  1.00 61.58      A    C  
ATOM    172  CB  TRP    44      32.987 -11.425   4.830  1.00 63.28      A    C  
ATOM    173  CG  TRP    44      31.522 -11.742   4.770  1.00 66.96      A    C  
ATOM    174  CD1 TRP    44      30.893 -12.523   3.846  1.00 71.29      A    C  
ATOM    175  NE1 TRP    44      29.547 -12.583   4.112  1.00 75.54      A    N  
ATOM    176  CE2 TRP    44      29.278 -11.826   5.222  1.00 74.38      A    C  
ATOM    177  CD2 TRP    44      30.503 -11.280   5.667  1.00 69.18      A    C  
ATOM    178  CE3 TRP    44      30.505 -10.458   6.805  1.00 68.75      A    C  
ATOM    179  CZ3 TRP    44      29.298 -10.209   7.452  1.00 70.28      A    C  
ATOM    180  CH2 TRP    44      28.096 -10.769   6.986  1.00 75.60      A    C  
ATOM    181  CZ2 TRP    44      28.063 -11.578   5.876  1.00 76.96      A    C  
ATOM    182  C   TRP    44      34.850  -9.851   4.236  1.00 60.04      A    C  
ATOM    183  O   TRP    44      35.789 -10.497   3.740  1.00 59.62      A    O  
ATOM    184  N   PHE    45      35.017  -8.797   5.038  1.00 57.06      A    N  
ATOM    185  CA  PHE    45      36.331  -8.252   5.361  1.00 55.38      A    C  
ATOM    186  CB  PHE    45      36.541  -6.899   4.673  1.00 54.74      A    C  
ATOM    187  CG  PHE    45      36.523  -6.953   3.157  1.00 58.74      A    C  
ATOM    188  CD1 PHE    45      37.701  -7.144   2.439  1.00 58.08      A    C  
ATOM    189  CE1 PHE    45      37.695  -7.170   1.046  1.00 62.77      A    C  
ATOM    190  CZ  PHE    45      36.501  -7.000   0.344  1.00 63.52      A    C  
ATOM    191  CE2 PHE    45      35.321  -6.799   1.049  1.00 65.02      A    C  
ATOM    192  CD2 PHE    45      35.334  -6.773   2.448  1.00 58.18      A    C  
ATOM    193  C   PHE    45      36.481  -8.089   6.879  1.00 55.58      A    C  
ATOM    194  O   PHE    45      35.519  -7.741   7.578  1.00 55.09      A    O  
ATOM    195  N   GLU    46      37.686  -8.344   7.381  1.00 56.08      A    N  
ATOM    196  CA  GLU    46      37.969  -8.188   8.805  1.00 57.83      A    C  
ATOM    197  CB  GLU    46      39.401  -8.620   9.155  1.00 59.91      A    C  
ATOM    198  CG  GLU    46      39.750 -10.086   8.880  1.00 61.88      A    C  
ATOM    199  CD  GLU    46      40.313 -10.306   7.470  1.00 65.85      A    C  
ATOM    200  OE1 GLU    46      39.935  -9.574   6.516  1.00 60.16      A    O  
ATOM    201  OE2 GLU    46      41.147 -11.223   7.320  1.00 72.28      A    O  
ATOM    202  C   GLU    46      37.762  -6.724   9.155  1.00 57.63      A    C  
ATOM    203  O   GLU    46      38.320  -5.836   8.509  1.00 58.66      A    O  
ATOM    204  N   ALA    47      36.924  -6.478  10.150  1.00 57.65      A    N  
ATOM    205  CA  ALA    47      36.649  -5.120  10.594  1.00 58.18      A    C  
ATOM    206  CB  ALA    47      35.406  -4.582   9.895  1.00 56.70      A    C  
ATOM    207  C   ALA    47      36.505  -5.054  12.117  1.00 60.50      A    C  
ATOM    208  O   ALA    47      36.526  -6.082  12.792  1.00 61.81      A    O  
ATOM    209  N   GLN    48      36.390  -3.842  12.652  1.00 63.44      A    N  
ATOM    210  CA  GLN    48      36.171  -3.640  14.084  1.00 67.12      A    C  
ATOM    211  CB  GLN    48      37.456  -3.160  14.766  1.00 71.03      A    C  
ATOM    212  CG  GLN    48      37.367  -3.069  16.297  1.00 75.40      A    C  
ATOM    213  CD  GLN    48      38.641  -2.565  16.949  1.00 80.70      A    C  
ATOM    214  OE1 GLN    48      39.520  -2.019  16.287  1.00 80.17      A    O  
ATOM    215  NE2 GLN    48      38.742  -2.741  18.266  1.00 86.01      A    N  
ATOM    216  C   GLN    48      35.030  -2.652  14.331  1.00 69.25      A    C  
ATOM    217  O   GLN    48      34.873  -1.667  13.598  1.00 67.51      A    O  
ATOM    218  N   VAL    49      34.243  -2.927  15.369  1.00 72.79      A    N  
ATOM    219  CA  VAL    49      33.117  -2.082  15.740  1.00 76.25      A    C  
ATOM    220  CB  VAL    49      32.072  -2.853  16.579  1.00 80.46      A    C  
ATOM    221  CG1 VAL    49      30.933  -1.925  17.006  1.00 82.55      A    C  
ATOM    222  CG2 VAL    49      31.539  -4.055  15.802  1.00 75.52      A    C  
ATOM    223  C   VAL    49      33.586  -0.852  16.516  1.00 81.59      A    C  
ATOM    224  O   VAL    49      34.141  -0.962  17.614  1.00 86.04      A    O  
ATOM    225  N   VAL    50      33.342   0.318  15.936  1.00 81.58      A    N  
ATOM    226  CA  VAL    50      33.742   1.586  16.532  1.00 85.85      A    C  
ATOM    227  CB  VAL    50      34.190   2.582  15.439  1.00 82.87      A    C  
ATOM    228  CG1 VAL    50      34.390   3.946  16.021  1.00 90.16      A    C  
ATOM    229  CG2 VAL    50      35.466   2.109  14.799  1.00 79.12      A    C  
ATOM    230  C   VAL    50      32.618   2.185  17.389  1.00 91.85      A    C  
ATOM    231  O   VAL    50      32.866   2.721  18.476  1.00 97.97      A    O  
ATOM    232  N   ARG    51      31.391   2.106  16.883  1.00 91.35      A    N  
ATOM    233  CA  ARG    51      30.213   2.553  17.613  1.00 98.00      A    C  
ATOM    234  CB  ARG    51      29.917   4.032  17.340  1.00100.80      A    C  
ATOM    235  CG  ARG    51      30.506   4.983  18.377  1.00107.46      A    C  
ATOM    236  CD  ARG    51      30.332   6.443  17.985  1.00110.40      A    C  
ATOM    237  NE  ARG    51      28.942   6.883  18.103  1.00118.29      A    N  
ATOM    238  CZ  ARG    51      28.426   7.482  19.175  1.00129.05      A    C  
ATOM    239  NH1 ARG    51      29.181   7.730  20.240  1.00134.40      A    N  
ATOM    240  NH2 ARG    51      27.146   7.840  19.187  1.00134.91      A    N  
ATOM    241  C   ARG    51      29.012   1.691  17.255  1.00 97.71      A    C  
ATOM    242  O   ARG    51      28.957   1.107  16.169  1.00 92.82      A    O  
ATOM    243  N   VAL    52      28.066   1.598  18.186  1.00104.09      A    N  
ATOM    244  CA  VAL    52      26.811   0.891  17.951  1.00105.53      A    C  
ATOM    245  CB  VAL    52      26.746  -0.447  18.749  1.00107.07      A    C  
ATOM    246  CG1 VAL    52      26.856  -0.214  20.262  1.00116.59      A    C  
ATOM    247  CG2 VAL    52      25.491  -1.224  18.406  1.00109.24      A    C  
ATOM    248  C   VAL    52      25.618   1.825  18.217  1.00112.85      A    C  
ATOM    249  O   VAL    52      25.528   2.453  19.276  1.00118.62      A    O  
ATOM    250  N   THR    53      24.724   1.920  17.235  1.00113.10      A    N  
ATOM    251  CA  THR    53      23.602   2.862  17.269  1.00121.51      A    C  
ATOM    252  CB  THR    53      23.697   3.858  16.086  1.00119.01      A    C  
ATOM    253  OG1 THR    53      25.050   4.292  15.937  1.00114.19      A    O  
ATOM    254  CG2 THR    53      22.815   5.078  16.309  1.00129.22      A    C  
ATOM    255  C   THR    53      22.252   2.129  17.233  1.00126.92      A    C  
ATOM    256  O   THR    53      22.201   0.930  16.948  1.00124.34      A    O  
ATOM    257  N   ARG    54      21.171   2.851  17.529  1.00135.79      A    N  
ATOM    258  CA  ARG    54      19.816   2.299  17.465  1.00143.10      A    C  
ATOM    259  CB  ARG    54      19.136   2.367  18.841  1.00152.93      A    C  
ATOM    266  C   ARG    54      18.965   3.026  16.419  1.00146.96      A    C  
ATOM    267  O   ARG    54      18.946   2.629  15.229  1.00142.84      A    O  
ATOM    268  N   GLU    73      20.100  -6.332  15.059  1.00123.32      A    N  
ATOM    269  CA  GLU    73      18.671  -6.470  14.844  1.00132.67      A    C  
ATOM    270  CB  GLU    73      18.053  -7.343  15.943  1.00141.48      A    C  
ATOM    271  CG  GLU    73      18.457  -6.965  17.377  1.00145.34      A    C  
ATOM    272  CD  GLU    73      17.406  -7.360  18.407  1.00159.33      A    C  
ATOM    273  OE1 GLU    73      16.940  -8.524  18.379  1.00163.38      A    O  
ATOM    274  OE2 GLU    73      17.047  -6.503  19.249  1.00167.09      A    O  
ATOM    275  C   GLU    73      18.000  -5.098  14.802  1.00137.46      A    C  
ATOM    276  O   GLU    73      17.488  -4.614  15.820  1.00144.45      A    O  
ATOM    277  N   ASP    74      18.001  -4.475  13.621  1.00134.20      A    N  
ATOM    278  CA  ASP    74      17.565  -3.076  13.462  1.00137.77      A    C  
ATOM    279  CB  ASP    74      16.132  -2.870  13.992  1.00150.47      A    C  
ATOM    280  CG  ASP    74      15.447  -1.638  13.404  1.00157.01      A    C  
ATOM    281  OD1 ASP    74      16.084  -0.904  12.614  1.00151.95      A    O  
ATOM    282  OD2 ASP    74      14.261  -1.406  13.738  1.00166.48      A    O  
ATOM    283  C   ASP    74      18.571  -2.133  14.150  1.00132.38      A    C  
ATOM    284  O   ASP    74      18.362  -0.917  14.243  1.00135.67      A    O  
ATOM    285  N   VAL    75      19.658  -2.731  14.633  1.00124.52      A    N  
ATOM    286  CA  VAL    75      20.823  -2.029  15.155  1.00117.47      A    C  
ATOM    287  CB  VAL    75      21.627  -2.956  16.115  1.00114.64      A    C  
ATOM    288  CG1 VAL    75      23.095  -2.588  16.171  1.00105.73      A    C  
ATOM    289  CG2 VAL    75      21.012  -2.949  17.511  1.00123.12      A    C  
ATOM    290  C   VAL    75      21.679  -1.621  13.962  1.00108.96      A    C  
ATOM    291  O   VAL    75      21.740  -2.351  12.968  1.00104.98      A    O  
ATOM    292  N   ILE    76      22.315  -0.453  14.052  1.00106.20      A    N  
ATOM    293  CA  ILE    76      23.261  -0.013  13.023  1.00 99.14      A    C  
ATOM    294  CB  ILE    76      22.765   1.254  12.255  1.00102.73      A    C  
ATOM    295  CG1 ILE    76      23.853   1.796  11.319  1.00 96.23      A    C  
ATOM    296  CD1 ILE    76      23.310   2.429  10.045  1.00 99.72      A    C  
ATOM    297  CG2 ILE    76      22.252   2.323  13.216  1.00110.67      A    C  
ATOM    298  C   ILE    76      24.690   0.120  13.573  1.00 92.90      A    C  
ATOM    299  O   ILE    76      24.945   0.887  14.499  1.00 95.46      A    O  
ATOM    300  N   TYR    77      25.607  -0.649  12.990  1.00 93.66      A    N  
ATOM    301  CA  TYR    77      26.991  -0.728  13.458  1.00 88.85      A    C  
ATOM    302  CB  TYR    77      27.533  -2.147  13.273  1.00 85.70      A    C  
ATOM    303  CG  TYR    77      26.943  -3.158  14.228  1.00 89.17      A    C  
ATOM    304  CD1 TYR    77      27.333  -3.187  15.566  1.00 90.70      A    C  
ATOM    305  CE1 TYR    77      26.796  -4.113  16.452  1.00 95.37      A    C  
ATOM    306  CZ  TYR    77      25.860  -5.028  16.005  1.00 96.78      A    C  
ATOM    307  OH  TYR    77      25.339  -5.937  16.890  1.00100.18      A    O  
ATOM    308  CE2 TYR    77      25.456  -5.027  14.677  1.00 95.16      A    C  
ATOM    309  CD2 TYR    77      26.000  -4.091  13.797  1.00 90.70      A    C  
ATOM    310  C   TYR    77      27.916   0.258  12.760  1.00 85.38      A    C  
ATOM    311  O   TYR    77      27.856   0.421  11.542  1.00 84.45      A    O  
ATOM    312  N   HIS    78      28.773   0.910  13.541  1.00 83.71      A    N  
ATOM    313  CA  HIS    78      29.810   1.770  12.989  1.00 81.14      A    C  
ATOM    314  CB  HIS    78      29.910   3.077  13.762  1.00 83.22      A    C  
ATOM    315  CG  HIS    78      28.703   3.945  13.615  1.00 87.89      A    C  
ATOM    316  ND1 HIS    78      28.769   5.234  13.134  1.00 90.48      A    N  
ATOM    317  CE1 HIS    78      27.554   5.752  13.107  1.00 94.69      A    C  
ATOM    318  NE2 HIS    78      26.702   4.840  13.539  1.00 96.87      A    N  
ATOM    319  CD2 HIS    78      27.395   3.699  13.861  1.00 91.50      A    C  
ATOM    320  C   HIS    78      31.117   1.019  13.031  1.00 77.65      A    C  
ATOM    321  O   HIS    78      31.556   0.572  14.093  1.00 78.47      A    O  
ATOM    322  N   VAL    79      31.736   0.895  11.864  1.00 73.81      A    N  
ATOM    323  CA  VAL    79      32.790  -0.070  11.660  1.00 70.60      A    C  
ATOM    324  CB  VAL    79      32.193  -1.323  10.934  1.00 70.59      A    C  
ATOM    325  CG1 VAL    79      33.109  -1.881   9.858  1.00 64.14      A    C  
ATOM    326  CG2 VAL    79      31.785  -2.385  11.956  1.00 70.14      A    C  
ATOM    327  C   VAL    79      33.993   0.529  10.929  1.00 69.42      A    C  
ATOM    328  O   VAL    79      33.844   1.379  10.051  1.00 69.22      A    O  
ATOM    329  N   LYS    80      35.186   0.100  11.328  1.00 69.05      A    N  
ATOM    330  CA  LYS    80      36.402   0.409  10.586  1.00 69.09      A    C  
ATOM    331  CB  LYS    80      37.372   1.251  11.422  1.00 70.54      A    C  
ATOM    332  CG  LYS    80      38.019   0.522  12.589  1.00 71.11      A    C  
ATOM    333  CD  LYS    80      38.951   1.430  13.346  1.00 72.80      A    C  
ATOM    334  CE  LYS    80      39.612   0.680  14.484  1.00 77.21      A    C  
ATOM    335  NZ  LYS    80      40.206   1.598  15.499  1.00 80.41      A    N  
ATOM    336  C   LYS    80      37.069  -0.878  10.094  1.00 68.73      A    C  
ATOM    337  O   LYS    80      37.050  -1.904  10.783  1.00 67.58      A    O  
ATOM    338  N   TYR    81      37.642  -0.809   8.895  1.00 69.17      A    N  
ATOM    339  CA  TYR    81      38.314  -1.942   8.276  1.00 69.65      A    C  
ATOM    340  CB  TYR    81      38.192  -1.871   6.756  1.00 71.26      A    C  
ATOM    341  CG  TYR    81      36.782  -2.058   6.257  1.00 73.36      A    C  
ATOM    342  CD1 TYR    81      35.942  -0.962   6.046  1.00 76.49      A    C  
ATOM    343  CE1 TYR    81      34.632  -1.135   5.589  1.00 78.01      A    C  
ATOM    344  CZ  TYR    81      34.160  -2.417   5.342  1.00 77.56      A    C  
ATOM    345  OH  TYR    81      32.871  -2.611   4.885  1.00 80.19      A    O  
ATOM    346  CE2 TYR    81      34.981  -3.517   5.552  1.00 75.57      A    C  
ATOM    347  CD2 TYR    81      36.279  -3.333   6.010  1.00 72.40      A    C  
ATOM    348  C   TYR    81      39.777  -2.026   8.675  1.00 70.89      A    C  
ATOM    349  O   TYR    81      40.533  -1.050   8.563  1.00 71.51      A    O  
ATOM    350  N   ASP    82      40.164  -3.215   9.130  1.00 71.89      A    N  
ATOM    351  CA  ASP    82      41.516  -3.480   9.609  1.00 73.79      A    C  
ATOM    352  CB  ASP    82      41.648  -4.954  10.017  1.00 74.15      A    C  
ATOM    353  CG  ASP    82      40.868  -5.285  11.286  1.00 76.59      A    C  
ATOM    354  OD1 ASP    82      40.138  -4.405  11.803  1.00 78.41      A    O  
ATOM    355  OD2 ASP    82      40.989  -6.432  11.775  1.00 78.61      A    O  
ATOM    356  C   ASP    82      42.576  -3.103   8.576  1.00 74.38      A    C  
ATOM    357  O   ASP    82      43.536  -2.406   8.898  1.00 77.23      A    O  
ATOM    358  N   ASP    83      42.376  -3.540   7.336  1.00 72.34      A    N  
ATOM    359  CA  ASP    83      43.368  -3.352   6.288  1.00 72.89      A    C  
ATOM    360  CB  ASP    83      43.600  -4.675   5.546  1.00 73.65      A    C  
ATOM    361  CG  ASP    83      44.090  -5.780   6.467  1.00 75.64      A    C  
ATOM    362  OD1 ASP    83      45.026  -5.529   7.263  1.00 79.90      A    O  
ATOM    363  OD2 ASP    83      43.535  -6.899   6.399  1.00 75.47      A    O  
ATOM    364  C   ASP    83      43.012  -2.238   5.307  1.00 72.04      A    C  
ATOM    365  O   ASP    83      43.717  -2.037   4.311  1.00 73.88      A    O  
ATOM    366  N   TYR    84      41.927  -1.517   5.582  1.00 69.13      A    N  
ATOM    367  CA  TYR    84      41.477  -0.450   4.687  1.00 69.06      A    C  
ATOM    368  CB  TYR    84      40.293  -0.925   3.838  1.00 67.58      A    C  
ATOM    369  CG  TYR    84      40.560  -2.187   3.072  1.00 66.36      A    C  
ATOM    370  CD1 TYR    84      41.057  -2.140   1.773  1.00 68.00      A    C  
ATOM    371  CE1 TYR    84      41.312  -3.305   1.067  1.00 69.12      A    C  
ATOM    372  CZ  TYR    84      41.063  -4.533   1.656  1.00 66.52      A    C  
ATOM    373  OH  TYR    84      41.309  -5.690   0.957  1.00 68.36      A    O  
ATOM    374  CE2 TYR    84      40.569  -4.603   2.945  1.00 65.02      A    C  
ATOM    375  CD2 TYR    84      40.318  -3.433   3.644  1.00 63.68      A    C  
ATOM    376  C   TYR    84      41.094   0.836   5.421  1.00 69.64      A    C  
ATOM    377  O   TYR    84      39.916   1.207   5.433  1.00 69.47      A    O  
ATOM    378  N   PRO    85      42.084   1.534   6.020  1.00 70.58      A    N  
ATOM    379  CA  PRO    85      41.773   2.784   6.721  1.00 70.66      A    C  
ATOM    380  CB  PRO    85      43.114   3.175   7.348  1.00 72.50      A    C  
ATOM    381  CG  PRO    85      44.141   2.518   6.489  1.00 73.96      A    C  
ATOM    382  CD  PRO    85      43.525   1.219   6.080  1.00 72.47      A    C  
ATOM    383  C   PRO    85      41.266   3.886   5.780  1.00 71.62      A    C  
ATOM    384  O   PRO    85      40.622   4.830   6.230  1.00 71.33      A    O  
ATOM    385  N   GLU    86      41.546   3.751   4.485  1.00 73.37      A    N  
ATOM    386  CA  GLU    86      41.039   4.679   3.476  1.00 75.64      A    C  
ATOM    387  CB  GLU    86      41.735   4.463   2.122  1.00 78.50      A    C  
ATOM    388  CG  GLU    86      41.443   3.121   1.422  1.00 78.65      A    C  
ATOM    389  CD  GLU    86      42.359   1.979   1.859  1.00 76.94      A    C  
ATOM    390  OE1 GLU    86      42.547   1.037   1.060  1.00 77.72      A    O  
ATOM    391  OE2 GLU    86      42.890   2.012   2.992  1.00 76.80      A    O  
ATOM    392  C   GLU    86      39.514   4.604   3.332  1.00 75.93      A    C  
ATOM    393  O   GLU    86      38.896   5.510   2.775  1.00 79.57      A    O  
ATOM    394  N   ASN    87      38.915   3.529   3.843  1.00 74.12      A    N  
ATOM    395  CA  ASN    87      37.456   3.377   3.865  1.00 73.88      A    C  
ATOM    396  CB  ASN    87      37.066   1.910   4.057  1.00 72.05      A    C  
ATOM    397  CG  ASN    87      37.319   1.066   2.821  1.00 73.77      A    C  
ATOM    398  OD1 ASN    87      37.855   1.542   1.815  1.00 75.97      A    O  
ATOM    399  ND2 ASN    87      36.926  -0.201   2.891  1.00 74.00      A    N  
ATOM    400  C   ASN    87      36.762   4.227   4.928  1.00 73.27      A    C  
ATOM    401  O   ASN    87      35.550   4.423   4.874  1.00 75.05      A    O  
ATOM    402  N   GLY    88      37.531   4.721   5.894  1.00 71.73      A    N  
ATOM    403  CA  GLY    88      36.985   5.521   6.984  1.00 70.82      A    C  
ATOM    404  C   GLY    88      36.114   4.688   7.898  1.00 69.49      A    C  
ATOM    405  O   GLY    88      36.270   3.471   7.961  1.00 68.16      A    O  
ATOM    406  N   VAL    89      35.206   5.350   8.612  1.00 70.56      A    N  
ATOM    407  CA  VAL    89      34.196   4.670   9.414  1.00 71.17      A    C  
ATOM    408  CB  VAL    89      33.888   5.413  10.748  1.00 72.80      A    C  
ATOM    409  CG1 VAL    89      32.826   4.671  11.550  1.00 73.51      A    C  
ATOM    410  CG2 VAL    89      35.142   5.548  11.580  1.00 71.42      A    C  
ATOM    411  C   VAL    89      32.928   4.502   8.570  1.00 73.41      A    C  
ATOM    412  O   VAL    89      32.409   5.472   8.000  1.00 74.86      A    O  
ATOM    413  N   VAL    90      32.453   3.258   8.493  1.00 73.03      A    N  
ATOM    414  CA  VAL    90      31.321   2.886   7.650  1.00 75.55      A    C  
ATOM    415  CB  VAL    90      31.726   1.802   6.610  1.00 73.49      A    C  
ATOM    416  CG1 VAL    90      30.564   1.471   5.676  1.00 76.90      A    C  
ATOM    417  CG2 VAL    90      32.935   2.247   5.802  1.00 72.13      A    C  
ATOM    418  C   VAL    90      30.170   2.361   8.509  1.00 78.45      A    C  
ATOM    419  O   VAL    90      30.374   1.542   9.411  1.00 77.22      A    O  
ATOM    420  N   GLN    91      28.965   2.843   8.218  1.00 83.52      A    N  
ATOM    421  CA  GLN    91      27.755   2.390   8.897  1.00 87.88      A    C  
ATOM    422  CB  GLN    91      26.682   3.467   8.832  1.00 92.88      A    C  
ATOM    423  CG  GLN    91      27.037   4.717   9.618  1.00 93.91      A    C  
ATOM    424  CD  GLN    91      25.943   5.755   9.589  1.00 99.60      A    C  
ATOM    425  OE1 GLN    91      26.208   6.939   9.389  1.00101.46      A    O  
ATOM    426  NE2 GLN    91      24.703   5.322   9.788  1.00105.50      A    N  
ATOM    427  C   GLN    91      27.243   1.090   8.293  1.00 88.99      A    C  
ATOM    428  O   GLN    91      27.083   0.980   7.079  1.00 90.22      A    O  
ATOM    429  N   MET    92      26.981   0.113   9.156  1.00 90.02      A    N  
ATOM    430  CA  MET    92      26.645  -1.241   8.737  1.00 90.94      A    C  
ATOM    431  CB  MET    92      27.692  -2.221   9.268  1.00 88.07      A    C  
ATOM    432  CG  MET    92      29.111  -1.959   8.803  1.00 88.61      A    C  
ATOM    433  SD  MET    92      29.351  -2.318   6.905  1.00 98.62      A   SE  
ATOM    434  CE  MET    92      28.929  -4.197   6.883  1.00 91.66      A    C  
ATOM    435  C   MET    92      25.273  -1.687   9.236  1.00 95.56      A    C  
ATOM    436  O   MET    92      24.911  -1.435  10.385  1.00 97.05      A    O  
ATOM    437  N   ASN    93      24.522  -2.361   8.368  1.00 97.87      A    N  
ATOM    438  CA  ASN    93      23.301  -3.045   8.779  1.00102.77      A    C  
ATOM    439  CB  ASN    93      22.460  -3.441   7.563  1.00106.54      A    C  
ATOM    440  CG  ASN    93      21.019  -3.772   7.928  1.00114.89      A    C  
ATOM    441  OD1 ASN    93      20.744  -4.745   8.638  1.00116.51      A    O  
ATOM    442  ND2 ASN    93      20.090  -2.967   7.431  1.00121.11      A    N  
ATOM    443  C   ASN    93      23.673  -4.280   9.590  1.00100.09      A    C  
ATOM    444  O   ASN    93      24.659  -4.952   9.284  1.00 94.90      A    O  
ATOM    445  N   SER    94      22.877  -4.571  10.617  1.00103.84      A    N  
ATOM    446  CA  SER    94      23.168  -5.647  11.574  1.00102.37      A    C  
ATOM    447  CB  SER    94      22.088  -5.692  12.660  1.00109.16      A    C  
ATOM    448  OG  SER    94      22.463  -6.552  13.726  1.00109.46      A    O  
ATOM    449  C   SER    94      23.328  -7.033  10.943  1.00 99.33      A    C  
ATOM    450  O   SER    94      23.924  -7.923  11.548  1.00 96.67      A    O  
ATOM    451  N   ARG    95      22.787  -7.207   9.738  1.00100.12      A    N  
ATOM    452  CA  ARG    95      22.866  -8.476   9.012  1.00 98.31      A    C  
ATOM    453  CB  ARG    95      21.658  -8.642   8.083  1.00103.51      A    C  
ATOM    454  CG  ARG    95      21.541  -7.572   7.000  1.00105.74      A    C  
ATOM    455  CD  ARG    95      20.258  -7.724   6.207  1.00112.78      A    C  
ATOM    456  NE  ARG    95      20.009  -6.556   5.366  1.00118.15      A    N  
ATOM    460  C   ARG    95      24.162  -8.567   8.214  1.00 91.56      A    C  
ATOM    461  O   ARG    95      24.609  -9.665   7.850  1.00 88.39      A    O  
ATOM    462  N   ASP    96      24.750  -7.399   7.951  1.00 89.10      A    N  
ATOM    463  CA  ASP    96      25.999  -7.276   7.205  1.00 82.96      A    C  
ATOM    464  CB  ASP    96      25.998  -5.988   6.373  1.00 83.81      A    C  
ATOM    465  CG  ASP    96      25.193  -6.112   5.088  1.00 87.00      A    C  
ATOM    466  OD1 ASP    96      24.933  -7.246   4.636  1.00 87.12      A    O  
ATOM    467  OD2 ASP    96      24.829  -5.063   4.519  1.00 89.68      A    O  
ATOM    468  C   ASP    96      27.236  -7.329   8.109  1.00 78.81      A    C  
ATOM    469  O   ASP    96      28.366  -7.175   7.633  1.00 75.79      A    O  
ATOM    470  N   VAL    97      27.025  -7.546   9.406  1.00 79.24      A    N  
ATOM    471  CA  VAL    97      28.137  -7.792  10.337  1.00 76.33      A    C  
ATOM    472  CB  VAL    97      28.549  -6.514  11.163  1.00 76.33      A    C  
ATOM    473  CG1 VAL    97      27.457  -5.473  11.146  1.00 81.16      A    C  
ATOM    474  CG2 VAL    97      28.977  -6.853  12.599  1.00 76.18      A    C  
ATOM    475  C   VAL    97      27.883  -9.017  11.216  1.00 77.38      A    C  
ATOM    476  O   VAL    97      26.768  -9.236  11.698  1.00 81.25      A    O  
ATOM    477  N   ARG    98      28.926  -9.823  11.394  1.00 73.62      A    N  
ATOM    478  CA  ARG    98      28.844 -11.037  12.197  1.00 74.98      A    C  
ATOM    479  CB  ARG    98      28.402 -12.230  11.333  1.00 74.25      A    C  
ATOM    480  CG  ARG    98      29.415 -12.653  10.279  1.00 69.79      A    C  
ATOM    481  CD  ARG    98      28.820 -13.641   9.295  1.00 70.18      A    C  
ATOM    482  NE  ARG    98      29.792 -14.010   8.269  1.00 67.23      A    N  
ATOM    483  CZ  ARG    98      29.480 -14.503   7.072  1.00 66.25      A    C  
ATOM    484  NH1 ARG    98      28.214 -14.686   6.730  1.00 69.46      A    N  
ATOM    485  NH2 ARG    98      30.438 -14.808   6.209  1.00 62.39      A    N  
ATOM    486  C   ARG    98      30.189 -11.316  12.861  1.00 73.07      A    C  
ATOM    487  O   ARG    98      31.182 -10.655  12.555  1.00 70.00      A    O  
ATOM    488  N   ALA    99      30.215 -12.295  13.763  1.00 75.78      A    N  
ATOM    489  CA  ALA    99      31.446 -12.698  14.440  1.00 76.68      A    C  
ATOM    490  CB  ALA    99      31.164 -13.801  15.444  1.00 79.68      A    C  
ATOM    491  C   ALA    99      32.484 -13.157  13.423  1.00 73.07      A    C  
ATOM    492  O   ALA    99      32.138 -13.801  12.434  1.00 72.70      A    O  
END
