
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  235 ( 1873),  selected  235 , name 5pgm_F
# Molecule2: number of CA atoms  235 ( 1836),  selected  235 , name T0428.pdb
# PARAMETERS: 5pgm_F.T0428.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      P      16           -
LGA    -       -      R      17           -
LGA    -       -      G      18           -
LGA    -       -      S      19           -
LGA    -       -      T      20           -
LGA    P     1_F      Y      21          1.564
LGA    K     2_F      K      22          1.137
LGA    L     3_F      L      23          0.750
LGA    V     4_F      T      24          0.743
LGA    L     5_F      L      25          0.632
LGA    V     6_F      I      26          0.710
LGA    R     7_F      R      27          0.474
LGA    H     8_F      H      28          0.396
LGA    G     9_F      G      29          0.718
LGA    Q    10_F      E      30          1.257
LGA    S    11_F      S      31          0.891
LGA    E    12_F      E      32          0.767
LGA    W    13_F      W      33          1.191
LGA    N    14_F      N      34          1.347
LGA    E    15_F      K      35          0.849
LGA    K    16_F      E      36          1.052
LGA    N    17_F      N      37          1.772
LGA    L    18_F      R      38          1.595
LGA    F    19_F      F      39          1.237
LGA    T    20_F      T      40          0.914
LGA    G    21_F      G      41          0.901
LGA    W    22_F      W      42          0.678
LGA    V    23_F      T      43          0.894
LGA    D    24_F      D      44          0.557
LGA    V    25_F      V      45          0.417
LGA    K    26_F      S      46          0.628
LGA    L    27_F      L      47          0.671
LGA    S    28_F      S      48          0.577
LGA    A    29_F      E      49          0.708
LGA    K    30_F      Q      50          0.670
LGA    G    31_F      G      51          0.584
LGA    Q    32_F      V      52          0.447
LGA    Q    33_F      S      53          0.616
LGA    E    34_F      E      54          0.670
LGA    A    35_F      A      55          0.610
LGA    A    36_F      I      56          0.505
LGA    R    37_F      E      57          0.806
LGA    A    38_F      A      58          0.972
LGA    G    39_F      G      59          0.473
LGA    E    40_F      R      60          0.684
LGA    L    41_F      M      61          1.030
LGA    L    42_F      L      62          0.764
LGA    K    43_F      L      63          0.584
LGA    E    44_F      E      64          0.864
LGA    K    45_F      K      65          1.198
LGA    K    46_F      G      66          1.557
LGA    V    47_F      F      67          2.248
LGA    Y    48_F      K      68          1.899
LGA    P    49_F      F      69          1.751
LGA    D    50_F      D      70          1.417
LGA    V    51_F      V      71          0.598
LGA    L    52_F      V      72          0.335
LGA    Y    53_F      Y      73          0.300
LGA    T    54_F      T      74          0.339
LGA    S    55_F      S      75          0.422
LGA    K    56_F      V      76          0.364
LGA    L    57_F      L      77          0.142
LGA    S    58_F      K      78          0.136
LGA    R    59_F      R      79          0.301
LGA    A    60_F      A      80          0.328
LGA    I    61_F      I      81          0.291
LGA    Q    62_F      M      82          0.207
LGA    T    63_F      T      83          0.289
LGA    A    64_F      T      84          0.543
LGA    N    65_F      W      85          0.432
LGA    I    66_F      T      86          0.330
LGA    A    67_F      V      87          0.653
LGA    L    68_F      L      88          0.837
LGA    E    69_F      K      89          0.532
LGA    K    70_F      E      90          0.450
LGA    A    71_F      L      91          0.708
LGA    D    72_F      G      92          0.743
LGA    R    73_F      N      93          0.602
LGA    L    74_F      I      94          0.965
LGA    W    75_F      N      95          0.483
LGA    I    76_F      C      96          0.861
LGA    P    77_F      P      97          1.146
LGA    V    78_F      I      98          1.206
LGA    N    79_F      I      99          0.838
LGA    R    80_F      N     100          1.082
LGA    S    81_F      H     101          0.790
LGA    W    82_F      W     102          0.555
LGA    R    83_F      R     103          0.335
LGA    L    84_F      L     104          0.343
LGA    N    85_F      N     105          0.345
LGA    E    86_F      E     106          0.383
LGA    R    87_F      R     107          0.735
LGA    H    88_F      H     108          0.979
LGA    Y    89_F      Y     109          1.017
LGA    G    90_F      G     110          0.872
LGA    D    91_F      A     111          0.664
LGA    L    92_F      L     112          0.806
LGA    Q    93_F      Q     113          0.989
LGA    G    94_F      G     114          1.032
LGA    K    95_F      L     115          1.268
LGA    D    96_F      N     116          1.302
LGA    K    97_F      K     117          2.916
LGA    A    98_F      S     118          3.828
LGA    E    99_F      E     119          3.009
LGA    T   100_F      T     120          1.720
LGA    L   101_F      A     121          4.061
LGA    K   102_F      S     122          5.436
LGA    K   103_F      K     123          4.505
LGA    F   104_F      F     124          3.859
LGA    G   105_F      G     125          4.149
LGA    E   106_F      E     126          3.786
LGA    E   107_F      D     127          2.993
LGA    K   108_F      Q     128          1.631
LGA    F   109_F      V     129          1.212
LGA    N   110_F      K     130          1.261
LGA    T   111_F      I     131          0.709
LGA    Y   112_F      W     132          0.765
LGA    R   113_F      R     133          0.718
LGA    R   114_F      R     134          1.282
LGA    S   115_F      S     135          0.542
LGA    F   116_F      F     136          0.329
LGA    D   117_F      D     137          0.707
LGA    V   118_F      V     138          0.846
LGA    P   119_F      P     139          0.825
LGA    P   120_F      P     140          0.804
LGA    P   121_F      P     141          0.864
LGA    P   122_F      V     142          1.044
LGA    I   123_F      L     143          1.118
LGA    D   124_F      E     144          1.896
LGA    A   125_F      K     145          2.041
LGA    S   126_F      S     146          2.553
LGA    S   127_F      D     147          2.110
LGA    P   128_F      P     148          2.766
LGA    F   129_F      R     149          2.045
LGA    S   130_F      W     150          2.118
LGA    Q   131_F      P     151          1.816
LGA    K   132_F      G     152          1.359
LGA    G   133_F      N     153          3.342
LGA    D   134_F      E     154          1.810
LGA    E   135_F      L     155          1.746
LGA    R   136_F      I     156          1.405
LGA    Y   137_F      Y     157          1.392
LGA    K   138_F      K     158          1.797
LGA    Y   139_F      G     159          2.125
LGA    V   140_F      I     160          1.519
LGA    D   141_F      C     161          0.748
LGA    P   142_F      P     162          1.161
LGA    N   143_F      S     163          2.015
LGA    V   144_F      C     164          2.252
LGA    L   145_F      L     165          1.311
LGA    P   146_F      P     166          0.735
LGA    E   147_F      T     167          0.989
LGA    T   148_F      T     168          0.744
LGA    E   149_F      E     169          0.615
LGA    S   150_F      C     170          0.701
LGA    L   151_F      L     171          0.589
LGA    A   152_F      K     172          0.222
LGA    L   153_F      D     173          0.295
LGA    V   154_F      T     174          0.500
LGA    I   155_F      V     175          0.619
LGA    D   156_F      E     176          0.411
LGA    R   157_F      R     177          0.626
LGA    L   158_F      V     178          0.725
LGA    L   159_F      K     179          0.551
LGA    P   160_F      P     180          0.444
LGA    Y   161_F      Y     181          0.750
LGA    W   162_F      F     182          0.406
LGA    Q   163_F      E     183          0.158
LGA    D   164_F      D     184          0.719
LGA    V   165_F      V     185          0.422
LGA    I   166_F      I     186          0.374
LGA    A   167_F      A     187          0.460
LGA    K   168_F      P     188          0.633
LGA    D   169_F      S     189          0.606
LGA    L   170_F      I     190          0.269
LGA    L   171_F      M     191          0.331
LGA    S   172_F      S     192          0.612
LGA    G   173_F      G     193          0.900
LGA    K   174_F      K     194          0.950
LGA    T   175_F      S     195          1.440
LGA    V   176_F      V     196          0.796
LGA    M   177_F      L     197          0.296
LGA    I   178_F      V     198          0.607
LGA    A   179_F      S     199          0.588
LGA    A   180_F      A     200          0.429
LGA    H   181_F      H     201          0.501
LGA    G   182_F      G     202          0.875
LGA    N   183_F      N     203          0.657
LGA    S   184_F      S     204          0.607
LGA    L   185_F      L     205          0.512
LGA    R   186_F      R     206          0.702
LGA    G   187_F      A     207          0.773
LGA    L   188_F      L     208          0.565
LGA    V   189_F      L     209          0.747
LGA    K   190_F      Y     210          1.150
LGA    H   191_F      L     211          1.194
LGA    L   192_F      L     212          1.379
LGA    E   193_F      E     213          1.397
LGA    G   194_F      G     214          1.893
LGA    I   195_F      M     215          1.918
LGA    S   196_F      T     216          0.875
LGA    D   197_F      P     217          0.682
LGA    A   198_F      E     218          1.523
LGA    D   199_F      Q     219          2.416
LGA    I   200_F      I     220          1.745
LGA    A   201_F      L     221          1.558
LGA    K   202_F      E     222          1.001
LGA    L   203_F      V     223          0.655
LGA    N   204_F      N     224          0.335
LGA    I   205_F      I     225          0.285
LGA    P   206_F      P     226          0.420
LGA    T   207_F      T     227          0.303
LGA    G   208_F      A     228          0.628
LGA    I   209_F      C     229          0.555
LGA    P   210_F      P     230          0.379
LGA    L   211_F      L     231          0.336
LGA    V   212_F      V     232          0.449
LGA    F   213_F      L     233          0.418
LGA    E   214_F      E     234          1.216
LGA    L   215_F      L     235          0.995
LGA    D   216_F      D     236          1.964
LGA    E   217_F      D     237          1.615
LGA    N   218_F      Y     238          0.917
LGA    L   219_F      L     239          0.511
LGA    K   220_F      K     240          1.146
LGA    P   221_F      V     241          1.641
LGA    S   222_F      T     242          2.556
LGA    K   223_F      K     243          2.318
LGA    P   224_F      -       -           -
LGA    S   225_F      K     244          0.640
LGA    Y   226_F      Y     245          0.633
LGA    Y   227_F      Y     246          0.550
LGA    L   228_F      L     247          0.660
LGA    D   229_F      I     248          0.279
LGA    P   230_F      E     249          3.422
LGA    E   231_F      E     250          2.041
LGA    A   232_F      -       -           -
LGA    A   233_F      -       -           -
LGA    A   234_F      -       -           -
LGA    A   235_F      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  235  235    5.0    230    1.36    50.87     93.582    15.766

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.017492 * X  +   0.971956 * Y  +  -0.234510 * Z  +  74.792427
  Y_new =   0.610444 * X  +   0.196139 * Y  +   0.767390 * Z  + -15.083479
  Z_new =   0.791866 * X  +  -0.129732 * Y  +  -0.596756 * Z  + -47.033680 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.927528    0.214065  [ DEG:  -167.7350     12.2650 ]
  Theta =  -0.913859   -2.227734  [ DEG:   -52.3603   -127.6397 ]
  Phi   =   1.599444   -1.542149  [ DEG:    91.6414    -88.3586 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 5pgm_F                                        
REMARK     2: T0428.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 5pgm_F.T0428.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  235  235   5.0  230   1.36   50.87  93.582
REMARK  ---------------------------------------------------------- 
MOLECULE 5pgm_F
HEADER    ISOMERASE                               19-AUG-98   5PGM              
TITLE     SACCHAROMYCES CEREVISIAE PHOSPHOGLYCERATE MUTASE                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHOSPHOGLYCERATE MUTASE 1;                                 
COMPND   3 CHAIN: D, C, A, B, E, F, G, H;                                       
COMPND   4 SYNONYM: PHOSPHOGLYCEROMUTASE;                                       
COMPND   5 EC: 5.4.2.1                                                          
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE   3 ORGANISM_COMMON: BAKER'S YEAST;                                      
SOURCE   4 STRAIN: S150-GPM\:\:HIS3;                                            
SOURCE   5 CELLULAR_LOCATION: CYTOPLASM                                         
KEYWDS    ISOMERASE, TRANSFERASE (PHOSPHORYL), GLYCOLYTIC ENZYME                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    D.J.RIGDEN,S.E.V.PHILLIPS,L.A.FOTHERGILL-GILMORE                      
REVDAT   1   16-FEB-99 5PGM    0                                                
JRNL        AUTH   D.J.RIGDEN,R.A.WALTER,S.E.PHILLIPS,                          
JRNL        AUTH 2 L.A.FOTHERGILL-GILMORE                                       
JRNL        TITL   SULPHATE IONS OBSERVED IN THE 2.12 A STRUCTURE OF            
JRNL        TITL 2 A NEW CRYSTAL FORM OF S. CEREVISIAE                          
JRNL        TITL 3 PHOSPHOGLYCERATE MUTASE PROVIDE INSIGHTS INTO                
JRNL        TITL 4 UNDERSTANDING THE CATALYTIC MECHANISM.                       
JRNL        REF    J.MOL.BIOL.                   V. 286  1507 1999              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.12 ANGSTROMS.                                          
DBREF  5PGM D    1   246  UNP    P00950   PMG1_YEAST       1    246             
DBREF  5PGM C    1   246  UNP    P00950   PMG1_YEAST       1    246             
DBREF  5PGM A    1   246  UNP    P00950   PMG1_YEAST       1    246             
DBREF  5PGM B    1   246  UNP    P00950   PMG1_YEAST       1    246             
DBREF  5PGM E    1   246  UNP    P00950   PMG1_YEAST       1    246             
DBREF  5PGM F    1   246  UNP    P00950   PMG1_YEAST       1    246             
DBREF  5PGM G    1   246  UNP    P00950   PMG1_YEAST       1    246             
DBREF  5PGM H    1   246  UNP    P00950   PMG1_YEAST       1    246             
SEQRES   1 D  246  PRO LYS LEU VAL LEU VAL ARG HIS GLY GLN SER GLU TRP          
SEQRES   2 D  246  ASN GLU LYS ASN LEU PHE THR GLY TRP VAL ASP VAL LYS          
SEQRES   3 D  246  LEU SER ALA LYS GLY GLN GLN GLU ALA ALA ARG ALA GLY          
SEQRES   4 D  246  GLU LEU LEU LYS GLU LYS LYS VAL TYR PRO ASP VAL LEU          
SEQRES   5 D  246  TYR THR SER LYS LEU SER ARG ALA ILE GLN THR ALA ASN          
SEQRES   6 D  246  ILE ALA LEU GLU LYS ALA ASP ARG LEU TRP ILE PRO VAL          
SEQRES   7 D  246  ASN ARG SER TRP ARG LEU ASN GLU ARG HIS TYR GLY ASP          
SEQRES   8 D  246  LEU GLN GLY LYS ASP LYS ALA GLU THR LEU LYS LYS PHE          
SEQRES   9 D  246  GLY GLU GLU LYS PHE ASN THR TYR ARG ARG SER PHE ASP          
SEQRES  10 D  246  VAL PRO PRO PRO PRO ILE ASP ALA SER SER PRO PHE SER          
SEQRES  11 D  246  GLN LYS GLY ASP GLU ARG TYR LYS TYR VAL ASP PRO ASN          
SEQRES  12 D  246  VAL LEU PRO GLU THR GLU SER LEU ALA LEU VAL ILE ASP          
SEQRES  13 D  246  ARG LEU LEU PRO TYR TRP GLN ASP VAL ILE ALA LYS ASP          
SEQRES  14 D  246  LEU LEU SER GLY LYS THR VAL MET ILE ALA ALA HIS GLY          
SEQRES  15 D  246  ASN SER LEU ARG GLY LEU VAL LYS HIS LEU GLU GLY ILE          
SEQRES  16 D  246  SER ASP ALA ASP ILE ALA LYS LEU ASN ILE PRO THR GLY          
SEQRES  17 D  246  ILE PRO LEU VAL PHE GLU LEU ASP GLU ASN LEU LYS PRO          
SEQRES  18 D  246  SER LYS PRO SER TYR TYR LEU ASP PRO GLU ALA ALA ALA          
SEQRES  19 D  246  ALA GLY ALA ALA ALA VAL ALA ASN GLN GLY LYS LYS              
SEQRES   1 C  246  PRO LYS LEU VAL LEU VAL ARG HIS GLY GLN SER GLU TRP          
SEQRES   2 C  246  ASN GLU LYS ASN LEU PHE THR GLY TRP VAL ASP VAL LYS          
SEQRES   3 C  246  LEU SER ALA LYS GLY GLN GLN GLU ALA ALA ARG ALA GLY          
SEQRES   4 C  246  GLU LEU LEU LYS GLU LYS LYS VAL TYR PRO ASP VAL LEU          
SEQRES   5 C  246  TYR THR SER LYS LEU SER ARG ALA ILE GLN THR ALA ASN          
SEQRES   6 C  246  ILE ALA LEU GLU LYS ALA ASP ARG LEU TRP ILE PRO VAL          
SEQRES   7 C  246  ASN ARG SER TRP ARG LEU ASN GLU ARG HIS TYR GLY ASP          
SEQRES   8 C  246  LEU GLN GLY LYS ASP LYS ALA GLU THR LEU LYS LYS PHE          
SEQRES   9 C  246  GLY GLU GLU LYS PHE ASN THR TYR ARG ARG SER PHE ASP          
SEQRES  10 C  246  VAL PRO PRO PRO PRO ILE ASP ALA SER SER PRO PHE SER          
SEQRES  11 C  246  GLN LYS GLY ASP GLU ARG TYR LYS TYR VAL ASP PRO ASN          
SEQRES  12 C  246  VAL LEU PRO GLU THR GLU SER LEU ALA LEU VAL ILE ASP          
SEQRES  13 C  246  ARG LEU LEU PRO TYR TRP GLN ASP VAL ILE ALA LYS ASP          
SEQRES  14 C  246  LEU LEU SER GLY LYS THR VAL MET ILE ALA ALA HIS GLY          
SEQRES  15 C  246  ASN SER LEU ARG GLY LEU VAL LYS HIS LEU GLU GLY ILE          
SEQRES  16 C  246  SER ASP ALA ASP ILE ALA LYS LEU ASN ILE PRO THR GLY          
SEQRES  17 C  246  ILE PRO LEU VAL PHE GLU LEU ASP GLU ASN LEU LYS PRO          
SEQRES  18 C  246  SER LYS PRO SER TYR TYR LEU ASP PRO GLU ALA ALA ALA          
SEQRES  19 C  246  ALA GLY ALA ALA ALA VAL ALA ASN GLN GLY LYS LYS              
SEQRES   1 A  246  PRO LYS LEU VAL LEU VAL ARG HIS GLY GLN SER GLU TRP          
SEQRES   2 A  246  ASN GLU LYS ASN LEU PHE THR GLY TRP VAL ASP VAL LYS          
SEQRES   3 A  246  LEU SER ALA LYS GLY GLN GLN GLU ALA ALA ARG ALA GLY          
SEQRES   4 A  246  GLU LEU LEU LYS GLU LYS LYS VAL TYR PRO ASP VAL LEU          
SEQRES   5 A  246  TYR THR SER LYS LEU SER ARG ALA ILE GLN THR ALA ASN          
SEQRES   6 A  246  ILE ALA LEU GLU LYS ALA ASP ARG LEU TRP ILE PRO VAL          
SEQRES   7 A  246  ASN ARG SER TRP ARG LEU ASN GLU ARG HIS TYR GLY ASP          
SEQRES   8 A  246  LEU GLN GLY LYS ASP LYS ALA GLU THR LEU LYS LYS PHE          
SEQRES   9 A  246  GLY GLU GLU LYS PHE ASN THR TYR ARG ARG SER PHE ASP          
SEQRES  10 A  246  VAL PRO PRO PRO PRO ILE ASP ALA SER SER PRO PHE SER          
SEQRES  11 A  246  GLN LYS GLY ASP GLU ARG TYR LYS TYR VAL ASP PRO ASN          
SEQRES  12 A  246  VAL LEU PRO GLU THR GLU SER LEU ALA LEU VAL ILE ASP          
SEQRES  13 A  246  ARG LEU LEU PRO TYR TRP GLN ASP VAL ILE ALA LYS ASP          
SEQRES  14 A  246  LEU LEU SER GLY LYS THR VAL MET ILE ALA ALA HIS GLY          
SEQRES  15 A  246  ASN SER LEU ARG GLY LEU VAL LYS HIS LEU GLU GLY ILE          
SEQRES  16 A  246  SER ASP ALA ASP ILE ALA LYS LEU ASN ILE PRO THR GLY          
SEQRES  17 A  246  ILE PRO LEU VAL PHE GLU LEU ASP GLU ASN LEU LYS PRO          
SEQRES  18 A  246  SER LYS PRO SER TYR TYR LEU ASP PRO GLU ALA ALA ALA          
SEQRES  19 A  246  ALA GLY ALA ALA ALA VAL ALA ASN GLN GLY LYS LYS              
SEQRES   1 B  246  PRO LYS LEU VAL LEU VAL ARG HIS GLY GLN SER GLU TRP          
SEQRES   2 B  246  ASN GLU LYS ASN LEU PHE THR GLY TRP VAL ASP VAL LYS          
SEQRES   3 B  246  LEU SER ALA LYS GLY GLN GLN GLU ALA ALA ARG ALA GLY          
SEQRES   4 B  246  GLU LEU LEU LYS GLU LYS LYS VAL TYR PRO ASP VAL LEU          
SEQRES   5 B  246  TYR THR SER LYS LEU SER ARG ALA ILE GLN THR ALA ASN          
SEQRES   6 B  246  ILE ALA LEU GLU LYS ALA ASP ARG LEU TRP ILE PRO VAL          
SEQRES   7 B  246  ASN ARG SER TRP ARG LEU ASN GLU ARG HIS TYR GLY ASP          
SEQRES   8 B  246  LEU GLN GLY LYS ASP LYS ALA GLU THR LEU LYS LYS PHE          
SEQRES   9 B  246  GLY GLU GLU LYS PHE ASN THR TYR ARG ARG SER PHE ASP          
SEQRES  10 B  246  VAL PRO PRO PRO PRO ILE ASP ALA SER SER PRO PHE SER          
SEQRES  11 B  246  GLN LYS GLY ASP GLU ARG TYR LYS TYR VAL ASP PRO ASN          
SEQRES  12 B  246  VAL LEU PRO GLU THR GLU SER LEU ALA LEU VAL ILE ASP          
SEQRES  13 B  246  ARG LEU LEU PRO TYR TRP GLN ASP VAL ILE ALA LYS ASP          
SEQRES  14 B  246  LEU LEU SER GLY LYS THR VAL MET ILE ALA ALA HIS GLY          
SEQRES  15 B  246  ASN SER LEU ARG GLY LEU VAL LYS HIS LEU GLU GLY ILE          
SEQRES  16 B  246  SER ASP ALA ASP ILE ALA LYS LEU ASN ILE PRO THR GLY          
SEQRES  17 B  246  ILE PRO LEU VAL PHE GLU LEU ASP GLU ASN LEU LYS PRO          
SEQRES  18 B  246  SER LYS PRO SER TYR TYR LEU ASP PRO GLU ALA ALA ALA          
SEQRES  19 B  246  ALA GLY ALA ALA ALA VAL ALA ASN GLN GLY LYS LYS              
SEQRES   1 E  246  PRO LYS LEU VAL LEU VAL ARG HIS GLY GLN SER GLU TRP          
SEQRES   2 E  246  ASN GLU LYS ASN LEU PHE THR GLY TRP VAL ASP VAL LYS          
SEQRES   3 E  246  LEU SER ALA LYS GLY GLN GLN GLU ALA ALA ARG ALA GLY          
SEQRES   4 E  246  GLU LEU LEU LYS GLU LYS LYS VAL TYR PRO ASP VAL LEU          
SEQRES   5 E  246  TYR THR SER LYS LEU SER ARG ALA ILE GLN THR ALA ASN          
SEQRES   6 E  246  ILE ALA LEU GLU LYS ALA ASP ARG LEU TRP ILE PRO VAL          
SEQRES   7 E  246  ASN ARG SER TRP ARG LEU ASN GLU ARG HIS TYR GLY ASP          
SEQRES   8 E  246  LEU GLN GLY LYS ASP LYS ALA GLU THR LEU LYS LYS PHE          
SEQRES   9 E  246  GLY GLU GLU LYS PHE ASN THR TYR ARG ARG SER PHE ASP          
SEQRES  10 E  246  VAL PRO PRO PRO PRO ILE ASP ALA SER SER PRO PHE SER          
SEQRES  11 E  246  GLN LYS GLY ASP GLU ARG TYR LYS TYR VAL ASP PRO ASN          
SEQRES  12 E  246  VAL LEU PRO GLU THR GLU SER LEU ALA LEU VAL ILE ASP          
SEQRES  13 E  246  ARG LEU LEU PRO TYR TRP GLN ASP VAL ILE ALA LYS ASP          
SEQRES  14 E  246  LEU LEU SER GLY LYS THR VAL MET ILE ALA ALA HIS GLY          
SEQRES  15 E  246  ASN SER LEU ARG GLY LEU VAL LYS HIS LEU GLU GLY ILE          
SEQRES  16 E  246  SER ASP ALA ASP ILE ALA LYS LEU ASN ILE PRO THR GLY          
SEQRES  17 E  246  ILE PRO LEU VAL PHE GLU LEU ASP GLU ASN LEU LYS PRO          
SEQRES  18 E  246  SER LYS PRO SER TYR TYR LEU ASP PRO GLU ALA ALA ALA          
SEQRES  19 E  246  ALA GLY ALA ALA ALA VAL ALA ASN GLN GLY LYS LYS              
SEQRES   1 F  246  PRO LYS LEU VAL LEU VAL ARG HIS GLY GLN SER GLU TRP          
SEQRES   2 F  246  ASN GLU LYS ASN LEU PHE THR GLY TRP VAL ASP VAL LYS          
SEQRES   3 F  246  LEU SER ALA LYS GLY GLN GLN GLU ALA ALA ARG ALA GLY          
SEQRES   4 F  246  GLU LEU LEU LYS GLU LYS LYS VAL TYR PRO ASP VAL LEU          
SEQRES   5 F  246  TYR THR SER LYS LEU SER ARG ALA ILE GLN THR ALA ASN          
SEQRES   6 F  246  ILE ALA LEU GLU LYS ALA ASP ARG LEU TRP ILE PRO VAL          
SEQRES   7 F  246  ASN ARG SER TRP ARG LEU ASN GLU ARG HIS TYR GLY ASP          
SEQRES   8 F  246  LEU GLN GLY LYS ASP LYS ALA GLU THR LEU LYS LYS PHE          
SEQRES   9 F  246  GLY GLU GLU LYS PHE ASN THR TYR ARG ARG SER PHE ASP          
SEQRES  10 F  246  VAL PRO PRO PRO PRO ILE ASP ALA SER SER PRO PHE SER          
SEQRES  11 F  246  GLN LYS GLY ASP GLU ARG TYR LYS TYR VAL ASP PRO ASN          
SEQRES  12 F  246  VAL LEU PRO GLU THR GLU SER LEU ALA LEU VAL ILE ASP          
SEQRES  13 F  246  ARG LEU LEU PRO TYR TRP GLN ASP VAL ILE ALA LYS ASP          
SEQRES  14 F  246  LEU LEU SER GLY LYS THR VAL MET ILE ALA ALA HIS GLY          
SEQRES  15 F  246  ASN SER LEU ARG GLY LEU VAL LYS HIS LEU GLU GLY ILE          
SEQRES  16 F  246  SER ASP ALA ASP ILE ALA LYS LEU ASN ILE PRO THR GLY          
SEQRES  17 F  246  ILE PRO LEU VAL PHE GLU LEU ASP GLU ASN LEU LYS PRO          
SEQRES  18 F  246  SER LYS PRO SER TYR TYR LEU ASP PRO GLU ALA ALA ALA          
SEQRES  19 F  246  ALA GLY ALA ALA ALA VAL ALA ASN GLN GLY LYS LYS              
SEQRES   1 G  246  PRO LYS LEU VAL LEU VAL ARG HIS GLY GLN SER GLU TRP          
SEQRES   2 G  246  ASN GLU LYS ASN LEU PHE THR GLY TRP VAL ASP VAL LYS          
SEQRES   3 G  246  LEU SER ALA LYS GLY GLN GLN GLU ALA ALA ARG ALA GLY          
SEQRES   4 G  246  GLU LEU LEU LYS GLU LYS LYS VAL TYR PRO ASP VAL LEU          
SEQRES   5 G  246  TYR THR SER LYS LEU SER ARG ALA ILE GLN THR ALA ASN          
SEQRES   6 G  246  ILE ALA LEU GLU LYS ALA ASP ARG LEU TRP ILE PRO VAL          
SEQRES   7 G  246  ASN ARG SER TRP ARG LEU ASN GLU ARG HIS TYR GLY ASP          
SEQRES   8 G  246  LEU GLN GLY LYS ASP LYS ALA GLU THR LEU LYS LYS PHE          
SEQRES   9 G  246  GLY GLU GLU LYS PHE ASN THR TYR ARG ARG SER PHE ASP          
SEQRES  10 G  246  VAL PRO PRO PRO PRO ILE ASP ALA SER SER PRO PHE SER          
SEQRES  11 G  246  GLN LYS GLY ASP GLU ARG TYR LYS TYR VAL ASP PRO ASN          
SEQRES  12 G  246  VAL LEU PRO GLU THR GLU SER LEU ALA LEU VAL ILE ASP          
SEQRES  13 G  246  ARG LEU LEU PRO TYR TRP GLN ASP VAL ILE ALA LYS ASP          
SEQRES  14 G  246  LEU LEU SER GLY LYS THR VAL MET ILE ALA ALA HIS GLY          
SEQRES  15 G  246  ASN SER LEU ARG GLY LEU VAL LYS HIS LEU GLU GLY ILE          
SEQRES  16 G  246  SER ASP ALA ASP ILE ALA LYS LEU ASN ILE PRO THR GLY          
SEQRES  17 G  246  ILE PRO LEU VAL PHE GLU LEU ASP GLU ASN LEU LYS PRO          
SEQRES  18 G  246  SER LYS PRO SER TYR TYR LEU ASP PRO GLU ALA ALA ALA          
SEQRES  19 G  246  ALA GLY ALA ALA ALA VAL ALA ASN GLN GLY LYS LYS              
SEQRES   1 H  246  PRO LYS LEU VAL LEU VAL ARG HIS GLY GLN SER GLU TRP          
SEQRES   2 H  246  ASN GLU LYS ASN LEU PHE THR GLY TRP VAL ASP VAL LYS          
SEQRES   3 H  246  LEU SER ALA LYS GLY GLN GLN GLU ALA ALA ARG ALA GLY          
SEQRES   4 H  246  GLU LEU LEU LYS GLU LYS LYS VAL TYR PRO ASP VAL LEU          
SEQRES   5 H  246  TYR THR SER LYS LEU SER ARG ALA ILE GLN THR ALA ASN          
SEQRES   6 H  246  ILE ALA LEU GLU LYS ALA ASP ARG LEU TRP ILE PRO VAL          
SEQRES   7 H  246  ASN ARG SER TRP ARG LEU ASN GLU ARG HIS TYR GLY ASP          
SEQRES   8 H  246  LEU GLN GLY LYS ASP LYS ALA GLU THR LEU LYS LYS PHE          
SEQRES   9 H  246  GLY GLU GLU LYS PHE ASN THR TYR ARG ARG SER PHE ASP          
SEQRES  10 H  246  VAL PRO PRO PRO PRO ILE ASP ALA SER SER PRO PHE SER          
SEQRES  11 H  246  GLN LYS GLY ASP GLU ARG TYR LYS TYR VAL ASP PRO ASN          
SEQRES  12 H  246  VAL LEU PRO GLU THR GLU SER LEU ALA LEU VAL ILE ASP          
SEQRES  13 H  246  ARG LEU LEU PRO TYR TRP GLN ASP VAL ILE ALA LYS ASP          
SEQRES  14 H  246  LEU LEU SER GLY LYS THR VAL MET ILE ALA ALA HIS GLY          
SEQRES  15 H  246  ASN SER LEU ARG GLY LEU VAL LYS HIS LEU GLU GLY ILE          
SEQRES  16 H  246  SER ASP ALA ASP ILE ALA LYS LEU ASN ILE PRO THR GLY          
SEQRES  17 H  246  ILE PRO LEU VAL PHE GLU LEU ASP GLU ASN LEU LYS PRO          
SEQRES  18 H  246  SER LYS PRO SER TYR TYR LEU ASP PRO GLU ALA ALA ALA          
SEQRES  19 H  246  ALA GLY ALA ALA ALA VAL ALA ASN GLN GLY LYS LYS              
HET    SO4  D 300       5                                                       
HET    SO4  D 301       5                                                       
HET    SO4  C 300       5                                                       
HET    SO4  C 301       5                                                       
HET    SO4  A 300       5                                                       
HET    SO4  A 301       5                                                       
HET    SO4  B 300       5                                                       
HET    SO4  B 301       5                                                       
HET    SO4  E 300       5                                                       
HET    SO4  E 301       5                                                       
HET    SO4  F 300       5                                                       
HET    SO4  F 301       5                                                       
HET    SO4  G 300       5                                                       
HET    SO4  G 301       5                                                       
HET    SO4  H 300       5                                                       
HET    SO4  H 301       5                                                       
HET    ALA  E 235       5                                                       
HETNAM     SO4 SULFATE ION                                                      
HETNAM     ALA ALANINE                                                          
FORMUL   9  SO4    16(O4 S 2-)                                                  
FORMUL  25  ALA    C3 H7 N O2                                                   
FORMUL  26  HOH   *1638(H2 O)                                                   
CRYST1   82.497   93.262  147.329  90.00  90.15  90.00 P 1 21 1     16          
ATOM   9361  N   PRO F   1       5.644   1.063 -29.031  1.00 23.29           N  
ATOM   9362  CA  PRO F   1       6.928   0.810 -28.343  1.00 23.21           C  
ATOM   9363  C   PRO F   1       7.040   1.553 -26.997  1.00 22.71           C  
ATOM   9364  O   PRO F   1       6.572   2.704 -26.856  1.00 20.66           O  
ATOM   9365  CB  PRO F   1       8.059   1.167 -29.310  1.00 17.83           C  
ATOM   9366  CG  PRO F   1       7.326   1.841 -30.460  1.00 20.76           C  
ATOM   9367  CD  PRO F   1       5.890   1.303 -30.458  1.00 21.76           C  
ATOM   9368  N   LYS F   2       7.638   0.875 -26.014  1.00 17.65           N  
ATOM   9369  CA  LYS F   2       7.774   1.381 -24.649  1.00 16.31           C  
ATOM   9370  C   LYS F   2       9.217   1.487 -24.201  1.00 15.87           C  
ATOM   9371  O   LYS F   2       9.942   0.488 -24.208  1.00 23.27           O  
ATOM   9372  CB  LYS F   2       7.005   0.453 -23.685  1.00 21.51           C  
ATOM   9373  CG  LYS F   2       6.855   0.999 -22.277  1.00 25.59           C  
ATOM   9374  CD  LYS F   2       6.167   0.026 -21.309  1.00 27.61           C  
ATOM   9375  CE  LYS F   2       4.671  -0.081 -21.471  1.00 34.26           C  
ATOM   9376  NZ  LYS F   2       4.150  -1.003 -20.417  1.00 40.32           N  
ATOM   9377  N   LEU F   3       9.608   2.675 -23.734  1.00 19.12           N  
ATOM   9378  CA  LEU F   3      10.957   2.933 -23.276  1.00 16.72           C  
ATOM   9379  C   LEU F   3      11.036   3.301 -21.790  1.00 18.03           C  
ATOM   9380  O   LEU F   3      10.221   4.093 -21.303  1.00 25.52           O  
ATOM   9381  CB  LEU F   3      11.536   4.062 -24.131  1.00 14.22           C  
ATOM   9382  CG  LEU F   3      12.900   4.639 -23.857  1.00 13.28           C  
ATOM   9383  CD1 LEU F   3      13.982   3.699 -24.282  1.00 12.13           C  
ATOM   9384  CD2 LEU F   3      12.993   5.873 -24.681  1.00 15.47           C  
ATOM   9385  N   VAL F   4      12.019   2.751 -21.063  1.00 23.12           N  
ATOM   9386  CA  VAL F   4      12.180   3.085 -19.640  1.00 17.60           C  
ATOM   9387  C   VAL F   4      13.570   3.595 -19.404  1.00 16.51           C  
ATOM   9388  O   VAL F   4      14.526   2.876 -19.644  1.00 16.68           O  
ATOM   9389  CB  VAL F   4      12.023   1.885 -18.609  1.00 22.17           C  
ATOM   9390  CG1 VAL F   4      11.182   2.320 -17.455  1.00 21.54           C  
ATOM   9391  CG2 VAL F   4      11.453   0.637 -19.224  1.00 24.84           C  
ATOM   9392  N   LEU F   5      13.667   4.820 -18.879  1.00 14.38           N  
ATOM   9393  CA  LEU F   5      14.945   5.437 -18.550  1.00 12.52           C  
ATOM   9394  C   LEU F   5      15.142   5.381 -17.018  1.00 13.37           C  
ATOM   9395  O   LEU F   5      14.213   5.590 -16.252  1.00 16.14           O  
ATOM   9396  CB  LEU F   5      14.950   6.904 -19.003  1.00 15.38           C  
ATOM   9397  CG  LEU F   5      14.449   7.202 -20.405  1.00 20.64           C  
ATOM   9398  CD1 LEU F   5      14.581   8.715 -20.674  1.00 11.03           C  
ATOM   9399  CD2 LEU F   5      15.281   6.396 -21.397  1.00 16.49           C  
ATOM   9400  N   VAL F   6      16.365   5.104 -16.600  1.00 18.33           N  
ATOM   9401  CA  VAL F   6      16.694   5.024 -15.198  1.00 19.36           C  
ATOM   9402  C   VAL F   6      18.003   5.726 -14.957  1.00 19.23           C  
ATOM   9403  O   VAL F   6      19.066   5.282 -15.423  1.00 13.74           O  
ATOM   9404  CB  VAL F   6      16.820   3.552 -14.701  1.00 13.99           C  
ATOM   9405  CG1 VAL F   6      17.239   3.521 -13.243  1.00 12.88           C  
ATOM   9406  CG2 VAL F   6      15.478   2.838 -14.898  1.00 10.96           C  
ATOM   9407  N   ARG F   7      17.902   6.828 -14.208  1.00 16.82           N  
ATOM   9408  CA  ARG F   7      19.049   7.623 -13.861  1.00 15.23           C  
ATOM   9409  C   ARG F   7      19.632   7.061 -12.591  1.00 15.37           C  
ATOM   9410  O   ARG F   7      18.915   6.856 -11.604  1.00 21.05           O  
ATOM   9411  CB  ARG F   7      18.648   9.077 -13.641  1.00 21.74           C  
ATOM   9412  CG  ARG F   7      19.883   9.930 -13.464  1.00 21.09           C  
ATOM   9413  CD  ARG F   7      19.536  11.360 -13.151  1.00 18.71           C  
ATOM   9414  NE  ARG F   7      20.753  12.092 -12.810  1.00 21.40           N  
ATOM   9415  CZ  ARG F   7      20.851  13.417 -12.853  1.00 28.22           C  
ATOM   9416  NH1 ARG F   7      19.788  14.143 -13.219  1.00 26.24           N  
ATOM   9417  NH2 ARG F   7      22.016  14.004 -12.589  1.00 29.79           N  
ATOM   9418  N   HIS F   8      20.932   6.811 -12.589  1.00 10.77           N  
ATOM   9419  CA  HIS F   8      21.513   6.228 -11.401  1.00 14.50           C  
ATOM   9420  C   HIS F   8      21.475   7.175 -10.226  1.00 13.21           C  
ATOM   9421  O   HIS F   8      21.361   8.370 -10.421  1.00 22.89           O  
ATOM   9422  CB  HIS F   8      22.929   5.738 -11.655  1.00 22.30           C  
ATOM   9423  CG  HIS F   8      23.880   6.810 -12.050  1.00 27.19           C  
ATOM   9424  ND1 HIS F   8      24.466   7.648 -11.133  1.00 23.46           N  
ATOM   9425  CD2 HIS F   8      24.361   7.180 -13.260  1.00 24.25           C  
ATOM   9426  CE1 HIS F   8      25.260   8.493 -11.764  1.00 21.40           C  
ATOM   9427  NE2 HIS F   8      25.219   8.229 -13.056  1.00 25.88           N  
ATOM   9428  N   GLY F   9      21.479   6.618  -9.015  1.00 29.31           N  
ATOM   9429  CA  GLY F   9      21.518   7.411  -7.796  1.00 28.78           C  
ATOM   9430  C   GLY F   9      22.917   7.970  -7.652  1.00 32.53           C  
ATOM   9431  O   GLY F   9      23.785   7.724  -8.490  1.00 27.77           O  
ATOM   9432  N   GLN F  10      23.211   8.625  -6.545  1.00 11.77           N  
ATOM   9433  CA  GLN F  10      24.536   9.230  -6.441  1.00 13.68           C  
ATOM   9434  C   GLN F  10      25.728   8.301  -6.310  1.00  9.25           C  
ATOM   9435  O   GLN F  10      25.621   7.180  -5.848  1.00 37.71           O  
ATOM   9436  CB  GLN F  10      24.567  10.308  -5.346  1.00 43.95           C  
ATOM   9437  CG  GLN F  10      24.346   9.777  -3.951  1.00 52.15           C  
ATOM   9438  CD  GLN F  10      24.305  10.866  -2.897  1.00 56.47           C  
ATOM   9439  OE1 GLN F  10      23.992  12.048  -3.192  1.00 50.36           O  
ATOM   9440  NE2 GLN F  10      24.613  10.480  -1.649  1.00 56.74           N  
ATOM   9441  N   SER F  11      26.870   8.808  -6.769  1.00 15.41           N  
ATOM   9442  CA  SER F  11      28.124   8.111  -6.708  1.00 15.67           C  
ATOM   9443  C   SER F  11      28.922   8.597  -5.485  1.00 17.73           C  
ATOM   9444  O   SER F  11      28.507   9.490  -4.752  1.00 27.41           O  
ATOM   9445  CB  SER F  11      28.928   8.366  -7.982  1.00 24.39           C  
ATOM   9446  OG  SER F  11      29.256   9.733  -8.116  1.00 22.30           O  
ATOM   9447  N   GLU F  12      30.066   7.971  -5.278  1.00 16.85           N  
ATOM   9448  CA  GLU F  12      30.945   8.293  -4.191  1.00 17.84           C  
ATOM   9449  C   GLU F  12      31.507   9.682  -4.341  1.00 21.03           C  
ATOM   9450  O   GLU F  12      31.952  10.278  -3.353  1.00 27.21           O  
ATOM   9451  CB  GLU F  12      32.088   7.281  -4.158  1.00 27.24           C  
ATOM   9452  CG  GLU F  12      31.610   5.853  -3.928  1.00 26.31           C  
ATOM   9453  CD  GLU F  12      32.724   4.939  -3.511  1.00 36.49           C  
ATOM   9454  OE1 GLU F  12      33.906   5.269  -3.721  1.00 37.25           O  
ATOM   9455  OE2 GLU F  12      32.415   3.887  -2.930  1.00 39.47           O  
ATOM   9456  N   TRP F  13      31.572  10.157  -5.586  1.00 21.75           N  
ATOM   9457  CA  TRP F  13      32.074  11.487  -5.900  1.00 16.27           C  
ATOM   9458  C   TRP F  13      30.948  12.517  -5.743  1.00 14.20           C  
ATOM   9459  O   TRP F  13      31.194  13.644  -5.345  1.00 16.44           O  
ATOM   9460  CB  TRP F  13      32.689  11.528  -7.312  1.00 11.47           C  
ATOM   9461  CG  TRP F  13      34.159  11.151  -7.328  1.00  8.40           C  
ATOM   9462  CD1 TRP F  13      34.800  10.378  -6.418  1.00 11.39           C  
ATOM   9463  CD2 TRP F  13      35.170  11.555  -8.296  1.00  9.63           C  
ATOM   9464  NE1 TRP F  13      36.137  10.278  -6.745  1.00 11.50           N  
ATOM   9465  CE2 TRP F  13      36.386  10.988  -7.889  1.00  8.44           C  
ATOM   9466  CE3 TRP F  13      35.150  12.341  -9.466  1.00  7.97           C  
ATOM   9467  CZ2 TRP F  13      37.578  11.175  -8.595  1.00  9.61           C  
ATOM   9468  CZ3 TRP F  13      36.324  12.524 -10.168  1.00 17.16           C  
ATOM   9469  CH2 TRP F  13      37.517  11.949  -9.734  1.00 17.06           C  
ATOM   9470  N   ASN F  14      29.709  12.164  -6.053  1.00 12.34           N  
ATOM   9471  CA  ASN F  14      28.657  13.132  -5.867  1.00 18.88           C  
ATOM   9472  C   ASN F  14      28.610  13.446  -4.355  1.00 24.62           C  
ATOM   9473  O   ASN F  14      28.492  14.622  -3.966  1.00 32.66           O  
ATOM   9474  CB  ASN F  14      27.325  12.591  -6.344  1.00 25.40           C  
ATOM   9475  CG  ASN F  14      26.192  13.575  -6.122  1.00 28.83           C  
ATOM   9476  OD1 ASN F  14      25.724  13.771  -4.995  1.00 36.93           O  
ATOM   9477  ND2 ASN F  14      25.751  14.213  -7.194  1.00 32.68           N  
ATOM   9478  N   GLU F  15      28.756  12.399  -3.522  1.00 22.92           N  
ATOM   9479  CA  GLU F  15      28.742  12.502  -2.051  1.00 24.71           C  
ATOM   9480  C   GLU F  15      29.803  13.451  -1.484  1.00 24.53           C  
ATOM   9481  O   GLU F  15      29.594  14.103  -0.471  1.00 31.29           O  
ATOM   9482  CB  GLU F  15      28.998  11.138  -1.420  1.00 26.20           C  
ATOM   9483  CG  GLU F  15      27.762  10.383  -1.033  1.00 24.95           C  
ATOM   9484  CD  GLU F  15      28.077   9.200  -0.113  1.00 25.76           C  
ATOM   9485  OE1 GLU F  15      29.143   8.539  -0.243  1.00 25.42           O  
ATOM   9486  OE2 GLU F  15      27.249   8.947   0.767  1.00 32.65           O  
ATOM   9487  N   LYS F  16      30.974  13.420  -2.097  1.00 16.95           N  
ATOM   9488  CA  LYS F  16      32.093  14.237  -1.708  1.00 12.35           C  
ATOM   9489  C   LYS F  16      32.173  15.573  -2.480  1.00 11.63           C  
ATOM   9490  O   LYS F  16      33.238  16.187  -2.460  1.00 11.24           O  
ATOM   9491  CB  LYS F  16      33.406  13.531  -2.029  1.00 15.36           C  
ATOM   9492  CG  LYS F  16      33.715  12.239  -1.390  1.00 19.72           C  
ATOM   9493  CD  LYS F  16      34.905  11.700  -2.158  1.00 25.00           C  
ATOM   9494  CE  LYS F  16      35.530  10.483  -1.538  1.00 32.70           C  
ATOM   9495  NZ  LYS F  16      36.938  10.437  -2.053  1.00 40.48           N  
ATOM   9496  N   ASN F  17      31.135  15.956  -3.226  1.00 19.47           N  
ATOM   9497  CA  ASN F  17      31.150  17.205  -4.025  1.00 24.10           C  
ATOM   9498  C   ASN F  17      32.272  17.321  -5.116  1.00 23.28           C  
ATOM   9499  O   ASN F  17      32.971  18.361  -5.193  1.00 23.79           O  
ATOM   9500  CB  ASN F  17      31.187  18.431  -3.077  1.00 22.87           C  
ATOM   9501  CG  ASN F  17      30.346  19.601  -3.574  1.00 21.61           C  
ATOM   9502  OD1 ASN F  17      30.753  20.761  -3.448  1.00 27.48           O  
ATOM   9503  ND2 ASN F  17      29.172  19.314  -4.124  1.00 20.25           N  
ATOM   9504  N   LEU F  18      32.489  16.244  -5.903  1.00 13.75           N  
ATOM   9505  CA  LEU F  18      33.497  16.247  -6.988  1.00 13.54           C  
ATOM   9506  C   LEU F  18      32.838  16.044  -8.352  1.00 15.10           C  
ATOM   9507  O   LEU F  18      31.862  15.289  -8.465  1.00 17.91           O  
ATOM   9508  CB  LEU F  18      34.550  15.160  -6.792  1.00 15.77           C  
ATOM   9509  CG  LEU F  18      35.330  15.202  -5.480  1.00 15.90           C  
ATOM   9510  CD1 LEU F  18      36.449  14.160  -5.512  1.00 12.48           C  
ATOM   9511  CD2 LEU F  18      35.940  16.588  -5.229  1.00 12.19           C  
ATOM   9512  N   PHE F  19      33.288  16.782  -9.369  1.00 17.75           N  
ATOM   9513  CA  PHE F  19      32.732  16.649 -10.734  1.00 16.46           C  
ATOM   9514  C   PHE F  19      33.200  15.284 -11.283  1.00 14.02           C  
ATOM   9515  O   PHE F  19      34.409  14.992 -11.269  1.00 13.36           O  
ATOM   9516  CB  PHE F  19      33.240  17.796 -11.627  1.00 16.86           C  
ATOM   9517  CG  PHE F  19      32.513  19.076 -11.414  1.00 13.77           C  
ATOM   9518  CD1 PHE F  19      31.123  19.099 -11.473  1.00 10.83           C  
ATOM   9519  CD2 PHE F  19      33.196  20.231 -11.131  1.00 12.08           C  
ATOM   9520  CE1 PHE F  19      30.411  20.287 -11.251  1.00 18.66           C  
ATOM   9521  CE2 PHE F  19      32.500  21.426 -10.909  1.00 12.15           C  
ATOM   9522  CZ  PHE F  19      31.110  21.452 -10.969  1.00 17.47           C  
ATOM   9523  N   THR F  20      32.253  14.456 -11.719  1.00 21.48           N  
ATOM   9524  CA  THR F  20      32.593  13.113 -12.197  1.00 24.28           C  
ATOM   9525  C   THR F  20      32.869  12.968 -13.695  1.00 23.29           C  
ATOM   9526  O   THR F  20      33.995  12.660 -14.112  1.00 18.20           O  
ATOM   9527  CB  THR F  20      31.508  12.072 -11.798  1.00 17.81           C  
ATOM   9528  OG1 THR F  20      31.218  12.208 -10.400  1.00 19.75           O  
ATOM   9529  CG2 THR F  20      32.032  10.655 -12.039  1.00 15.82           C  
ATOM   9530  N   GLY F  21      31.848  13.227 -14.497  1.00 11.35           N  
ATOM   9531  CA  GLY F  21      32.017  13.072 -15.928  1.00 15.16           C  
ATOM   9532  C   GLY F  21      32.236  11.609 -16.297  1.00 14.63           C  
ATOM   9533  O   GLY F  21      31.510  10.705 -15.851  1.00  8.97           O  
ATOM   9534  N   TRP F  22      33.332  11.380 -16.993  1.00 19.23           N  
ATOM   9535  CA  TRP F  22      33.673  10.057 -17.465  1.00 19.22           C  
ATOM   9536  C   TRP F  22      34.482   9.283 -16.470  1.00 17.63           C  
ATOM   9537  O   TRP F  22      34.797   8.118 -16.737  1.00 12.74           O  
ATOM   9538  CB  TRP F  22      34.428  10.110 -18.814  1.00 15.13           C  
ATOM   9539  CG  TRP F  22      33.561  10.255 -20.033  1.00 10.27           C  
ATOM   9540  CD1 TRP F  22      32.359  10.919 -20.137  1.00 11.55           C  
ATOM   9541  CD2 TRP F  22      33.826   9.701 -21.327  1.00  8.94           C  
ATOM   9542  NE1 TRP F  22      31.867  10.815 -21.429  1.00  6.56           N  
ATOM   9543  CE2 TRP F  22      32.746  10.063 -22.171  1.00  8.60           C  
ATOM   9544  CE3 TRP F  22      34.862   8.912 -21.854  1.00  8.00           C  
ATOM   9545  CZ2 TRP F  22      32.674   9.656 -23.520  1.00 12.96           C  
ATOM   9546  CZ3 TRP F  22      34.790   8.509 -23.186  1.00 10.08           C  
ATOM   9547  CH2 TRP F  22      33.702   8.880 -24.005  1.00 10.22           C  
ATOM   9548  N   VAL F  23      34.842   9.895 -15.340  1.00 15.64           N  
ATOM   9549  CA  VAL F  23      35.600   9.132 -14.324  1.00 15.58           C  
ATOM   9550  C   VAL F  23      34.710   7.987 -13.866  1.00 13.01           C  
ATOM   9551  O   VAL F  23      33.510   8.178 -13.649  1.00  9.98           O  
ATOM   9552  CB  VAL F  23      36.087   9.959 -13.154  1.00 15.71           C  
ATOM   9553  CG1 VAL F  23      36.931   9.042 -12.209  1.00 11.99           C  
ATOM   9554  CG2 VAL F  23      36.986  11.087 -13.702  1.00  4.84           C  
ATOM   9555  N   ASP F  24      35.259   6.772 -13.873  1.00 13.67           N  
ATOM   9556  CA  ASP F  24      34.432   5.606 -13.561  1.00 20.30           C  
ATOM   9557  C   ASP F  24      34.282   5.414 -12.056  1.00 20.78           C  
ATOM   9558  O   ASP F  24      34.818   4.473 -11.478  1.00 17.93           O  
ATOM   9559  CB  ASP F  24      35.010   4.340 -14.235  1.00 17.72           C  
ATOM   9560  CG  ASP F  24      34.066   3.145 -14.154  1.00 13.82           C  
ATOM   9561  OD1 ASP F  24      32.819   3.362 -14.214  1.00 10.44           O  
ATOM   9562  OD2 ASP F  24      34.576   2.004 -14.000  1.00 16.60           O  
ATOM   9563  N   VAL F  25      33.550   6.332 -11.443  1.00 25.16           N  
ATOM   9564  CA  VAL F  25      33.335   6.337 -10.004  1.00 24.23           C  
ATOM   9565  C   VAL F  25      32.234   5.357  -9.571  1.00 25.73           C  
ATOM   9566  O   VAL F  25      31.197   5.221 -10.216  1.00 18.62           O  
ATOM   9567  CB  VAL F  25      33.055   7.797  -9.516  1.00 17.04           C  
ATOM   9568  CG1 VAL F  25      32.713   7.816  -8.058  1.00 24.01           C  
ATOM   9569  CG2 VAL F  25      34.275   8.656  -9.758  1.00 16.81           C  
ATOM   9570  N   LYS F  26      32.500   4.665  -8.464  1.00 20.72           N  
ATOM   9571  CA  LYS F  26      31.589   3.699  -7.908  1.00 20.08           C  
ATOM   9572  C   LYS F  26      30.332   4.355  -7.321  1.00 19.06           C  
ATOM   9573  O   LYS F  26      30.335   5.468  -6.823  1.00 22.28           O  
ATOM   9574  CB  LYS F  26      32.337   2.877  -6.853  1.00 30.84           C  
ATOM   9575  CG  LYS F  26      31.462   1.942  -6.024  1.00 44.18           C  
ATOM   9576  CD  LYS F  26      32.240   0.989  -5.047  1.00 55.45           C  
ATOM   9577  CE  LYS F  26      31.252   0.010  -4.331  1.00 57.96           C  
ATOM   9578  NZ  LYS F  26      31.765  -1.308  -3.834  1.00 65.40           N  
ATOM   9579  N   LEU F  27      29.214   3.706  -7.526  1.00 11.41           N  
ATOM   9580  CA  LEU F  27      27.966   4.145  -6.965  1.00 12.54           C  
ATOM   9581  C   LEU F  27      28.103   4.157  -5.387  1.00 13.15           C  
ATOM   9582  O   LEU F  27      28.888   3.394  -4.796  1.00 20.58           O  
ATOM   9583  CB  LEU F  27      26.959   3.131  -7.428  1.00 15.37           C  
ATOM   9584  CG  LEU F  27      25.484   3.255  -7.220  1.00 15.67           C  
ATOM   9585  CD1 LEU F  27      24.924   4.465  -7.973  1.00 14.59           C  
ATOM   9586  CD2 LEU F  27      24.881   1.958  -7.744  1.00 10.57           C  
ATOM   9587  N   SER F  28      27.413   5.078  -4.716  1.00 34.08           N  
ATOM   9588  CA  SER F  28      27.488   5.152  -3.254  1.00 35.35           C  
ATOM   9589  C   SER F  28      26.487   4.182  -2.678  1.00 37.01           C  
ATOM   9590  O   SER F  28      25.606   3.685  -3.397  1.00 16.59           O  
ATOM   9591  CB  SER F  28      27.127   6.553  -2.735  1.00 15.92           C  
ATOM   9592  OG  SER F  28      25.715   6.787  -2.809  1.00 16.59           O  
ATOM   9593  N   ALA F  29      26.586   3.967  -1.368  1.00 15.99           N  
ATOM   9594  CA  ALA F  29      25.676   3.070  -0.656  1.00 12.01           C  
ATOM   9595  C   ALA F  29      24.254   3.576  -0.767  1.00 11.47           C  
ATOM   9596  O   ALA F  29      23.320   2.779  -0.918  1.00 24.62           O  
ATOM   9597  CB  ALA F  29      26.108   2.896   0.823  1.00 23.56           C  
ATOM   9598  N   LYS F  30      24.060   4.901  -0.749  1.00 16.83           N  
ATOM   9599  CA  LYS F  30      22.691   5.401  -0.905  1.00 19.01           C  
ATOM   9600  C   LYS F  30      22.295   5.188  -2.370  1.00 19.57           C  
ATOM   9601  O   LYS F  30      21.108   4.982  -2.679  1.00 25.60           O  
ATOM   9602  CB  LYS F  30      22.570   6.878  -0.455  1.00 32.18           C  
ATOM   9603  CG  LYS F  30      22.036   7.865  -1.514  1.00 41.05           C  
ATOM   9604  CD  LYS F  30      21.134   8.954  -0.914  1.00 51.61           C  
ATOM   9605  CE  LYS F  30      19.776   8.372  -0.489  1.00 55.94           C  
ATOM   9606  NZ  LYS F  30      18.950   7.895  -1.636  1.00 54.71           N  
ATOM   9607  N   GLY F  31      23.297   5.246  -3.259  1.00 24.89           N  
ATOM   9608  CA  GLY F  31      23.069   5.033  -4.688  1.00 21.40           C  
ATOM   9609  C   GLY F  31      22.607   3.596  -4.964  1.00 19.58           C  
ATOM   9610  O   GLY F  31      21.725   3.361  -5.779  1.00 15.18           O  
ATOM   9611  N   GLN F  32      23.187   2.629  -4.252  1.00 11.09           N  
ATOM   9612  CA  GLN F  32      22.767   1.224  -4.385  1.00 11.17           C  
ATOM   9613  C   GLN F  32      21.337   1.010  -3.914  1.00 13.85           C  
ATOM   9614  O   GLN F  32      20.633   0.210  -4.484  1.00 16.16           O  
ATOM   9615  CB  GLN F  32      23.683   0.334  -3.592  1.00 15.81           C  
ATOM   9616  CG  GLN F  32      25.124   0.421  -3.978  1.00 16.75           C  
ATOM   9617  CD  GLN F  32      25.924  -0.455  -3.079  1.00 25.41           C  
ATOM   9618  OE1 GLN F  32      25.381  -1.387  -2.485  1.00 36.13           O  
ATOM   9619  NE2 GLN F  32      27.209  -0.158  -2.936  1.00 21.32           N  
ATOM   9620  N   GLN F  33      20.899   1.737  -2.884  1.00 19.41           N  
ATOM   9621  CA  GLN F  33      19.525   1.639  -2.366  1.00 22.44           C  
ATOM   9622  C   GLN F  33      18.532   2.200  -3.367  1.00 20.35           C  
ATOM   9623  O   GLN F  33      17.378   1.732  -3.463  1.00 25.41           O  
ATOM   9624  CB  GLN F  33      19.342   2.472  -1.079  1.00 33.88           C  
ATOM   9625  CG  GLN F  33      20.125   2.063   0.158  1.00 44.48           C  
ATOM   9626  CD  GLN F  33      20.203   3.209   1.216  1.00 56.03           C  
ATOM   9627  OE1 GLN F  33      21.190   3.299   1.981  1.00 56.34           O  
ATOM   9628  NE2 GLN F  33      19.174   4.093   1.244  1.00 54.11           N  
ATOM   9629  N   GLU F  34      18.934   3.289  -4.034  1.00 14.11           N  
ATOM   9630  CA  GLU F  34      18.056   3.925  -5.015  1.00 13.88           C  
ATOM   9631  C   GLU F  34      17.823   2.952  -6.182  1.00 12.33           C  
ATOM   9632  O   GLU F  34      16.690   2.800  -6.636  1.00 24.23           O  
ATOM   9633  CB  GLU F  34      18.636   5.271  -5.472  1.00 31.57           C  
ATOM   9634  CG  GLU F  34      18.715   6.336  -4.365  1.00 38.17           C  
ATOM   9635  CD  GLU F  34      19.028   7.746  -4.906  1.00 43.49           C  
ATOM   9636  OE1 GLU F  34      18.246   8.212  -5.758  1.00 42.75           O  
ATOM   9637  OE2 GLU F  34      20.034   8.379  -4.486  1.00 45.48           O  
ATOM   9638  N   ALA F  35      18.902   2.257  -6.586  1.00 16.85           N  
ATOM   9639  CA  ALA F  35      18.929   1.191  -7.634  1.00 16.49           C  
ATOM   9640  C   ALA F  35      17.894   0.116  -7.289  1.00 16.09           C  
ATOM   9641  O   ALA F  35      16.995  -0.194  -8.071  1.00 15.77           O  
ATOM   9642  CB  ALA F  35      20.351   0.563  -7.671  1.00 14.25           C  
ATOM   9643  N   ALA F  36      17.970  -0.383  -6.057  1.00 15.95           N  
ATOM   9644  CA  ALA F  36      17.042  -1.400  -5.557  1.00 16.72           C  
ATOM   9645  C   ALA F  36      15.642  -0.879  -5.631  1.00 18.79           C  
ATOM   9646  O   ALA F  36      14.749  -1.549  -6.142  1.00 24.82           O  
ATOM   9647  CB  ALA F  36      17.388  -1.767  -4.123  1.00 15.77           C  
ATOM   9648  N   ARG F  37      15.456   0.349  -5.163  1.00 25.05           N  
ATOM   9649  CA  ARG F  37      14.148   0.988  -5.200  1.00 26.18           C  
ATOM   9650  C   ARG F  37      13.667   1.140  -6.668  1.00 24.88           C  
ATOM   9651  O   ARG F  37      12.492   0.913  -6.961  1.00 24.96           O  
ATOM   9652  CB  ARG F  37      14.216   2.329  -4.452  1.00 27.67           C  
ATOM   9653  CG  ARG F  37      12.924   3.186  -4.489  1.00 38.47           C  
ATOM   9654  CD  ARG F  37      11.707   2.493  -3.881  1.00 45.32           C  
ATOM   9655  NE  ARG F  37      10.484   3.290  -4.030  1.00 49.88           N  
ATOM   9656  CZ  ARG F  37       9.251   2.781  -4.111  1.00 51.65           C  
ATOM   9657  NH1 ARG F  37       9.061   1.457  -4.057  1.00 50.37           N  
ATOM   9658  NH2 ARG F  37       8.203   3.600  -4.277  1.00 51.98           N  
ATOM   9659  N   ALA F  38      14.573   1.483  -7.595  1.00 20.11           N  
ATOM   9660  CA  ALA F  38      14.191   1.587  -9.017  1.00 18.31           C  
ATOM   9661  C   ALA F  38      13.631   0.233  -9.479  1.00 17.76           C  
ATOM   9662  O   ALA F  38      12.581   0.177 -10.132  1.00 19.43           O  
ATOM   9663  CB  ALA F  38      15.400   1.967  -9.875  1.00 19.90           C  
ATOM   9664  N   GLY F  39      14.314  -0.848  -9.094  1.00 19.58           N  
ATOM   9665  CA  GLY F  39      13.876  -2.195  -9.459  1.00 23.94           C  
ATOM   9666  C   GLY F  39      12.526  -2.635  -8.884  1.00 27.13           C  
ATOM   9667  O   GLY F  39      11.718  -3.268  -9.582  1.00 24.12           O  
ATOM   9668  N   GLU F  40      12.288  -2.325  -7.605  1.00 23.65           N  
ATOM   9669  CA  GLU F  40      11.014  -2.654  -6.953  1.00 26.56           C  
ATOM   9670  C   GLU F  40       9.846  -1.931  -7.663  1.00 23.41           C  
ATOM   9671  O   GLU F  40       8.747  -2.463  -7.791  1.00 36.44           O  
ATOM   9672  CB  GLU F  40      11.059  -2.244  -5.478  1.00 42.80           C  
ATOM   9673  CG  GLU F  40      12.225  -2.841  -4.670  1.00 56.24           C  
ATOM   9674  CD  GLU F  40      12.134  -4.373  -4.435  1.00 69.98           C  
ATOM   9675  OE1 GLU F  40      11.230  -5.057  -5.001  1.00 75.00           O  
ATOM   9676  OE2 GLU F  40      12.984  -4.890  -3.657  1.00 74.53           O  
ATOM   9677  N   LEU F  41      10.137  -0.740  -8.177  1.00 23.70           N  
ATOM   9678  CA  LEU F  41       9.154   0.096  -8.880  1.00 24.34           C  
ATOM   9679  C   LEU F  41       8.787  -0.532 -10.235  1.00 24.19           C  
ATOM   9680  O   LEU F  41       7.595  -0.586 -10.616  1.00 19.95           O  
ATOM   9681  CB  LEU F  41       9.742   1.506  -9.047  1.00 23.59           C  
ATOM   9682  CG  LEU F  41       9.180   2.824  -8.468  1.00 27.01           C  
ATOM   9683  CD1 LEU F  41       8.140   2.666  -7.380  1.00 21.50           C  
ATOM   9684  CD2 LEU F  41      10.350   3.687  -8.018  1.00 20.18           C  
ATOM   9685  N   LEU F  42       9.804  -1.027 -10.949  1.00 22.88           N  
ATOM   9686  CA  LEU F  42       9.592  -1.709 -12.254  1.00 26.14           C  
ATOM   9687  C   LEU F  42       8.652  -2.894 -12.034  1.00 24.96           C  
ATOM   9688  O   LEU F  42       7.612  -3.015 -12.671  1.00 25.58           O  
ATOM   9689  CB  LEU F  42      10.932  -2.211 -12.836  1.00 25.38           C  
ATOM   9690  CG  LEU F  42      11.923  -1.205 -13.415  1.00 24.33           C  
ATOM   9691  CD1 LEU F  42      13.293  -1.811 -13.630  1.00 15.18           C  
ATOM   9692  CD2 LEU F  42      11.360  -0.696 -14.692  1.00 13.30           C  
ATOM   9693  N   LYS F  43       8.994  -3.712 -11.050  1.00 29.00           N  
ATOM   9694  CA  LYS F  43       8.223  -4.898 -10.710  1.00 32.36           C  
ATOM   9695  C   LYS F  43       6.806  -4.555 -10.300  1.00 35.93           C  
ATOM   9696  O   LYS F  43       5.827  -5.046 -10.874  1.00 36.22           O  
ATOM   9697  CB  LYS F  43       8.923  -5.655  -9.572  1.00 29.42           C  
ATOM   9698  CG  LYS F  43       8.232  -6.934  -9.144  1.00 32.73           C  
ATOM   9699  CD  LYS F  43       9.090  -7.644  -8.154  1.00 38.18           C  
ATOM   9700  CE  LYS F  43       8.481  -8.985  -7.777  1.00 45.41           C  
ATOM   9701  NZ  LYS F  43       9.339  -9.719  -6.787  1.00 48.27           N  
ATOM   9702  N   GLU F  44       6.730  -3.693  -9.294  1.00 31.09           N  
ATOM   9703  CA  GLU F  44       5.474  -3.239  -8.736  1.00 32.05           C  
ATOM   9704  C   GLU F  44       4.558  -2.640  -9.802  1.00 31.78           C  
ATOM   9705  O   GLU F  44       3.367  -2.950  -9.844  1.00 46.48           O  
ATOM   9706  CB  GLU F  44       5.773  -2.216  -7.647  1.00 49.90           C  
ATOM   9707  CG  GLU F  44       4.590  -1.754  -6.821  1.00 58.26           C  
ATOM   9708  CD  GLU F  44       4.845  -0.390  -6.195  1.00 61.11           C  
ATOM   9709  OE1 GLU F  44       5.897  -0.224  -5.511  1.00 60.70           O  
ATOM   9710  OE2 GLU F  44       4.004   0.517  -6.420  1.00 63.02           O  
ATOM   9711  N   LYS F  45       5.121  -1.837 -10.704  1.00 42.22           N  
ATOM   9712  CA  LYS F  45       4.300  -1.200 -11.739  1.00 41.95           C  
ATOM   9713  C   LYS F  45       4.097  -1.992 -13.050  1.00 41.68           C  
ATOM   9714  O   LYS F  45       3.404  -1.547 -13.976  1.00 36.00           O  
ATOM   9715  CB  LYS F  45       4.774   0.241 -11.977  1.00 30.24           C  
ATOM   9716  CG  LYS F  45       4.651   1.127 -10.719  1.00 41.01           C  
ATOM   9717  CD  LYS F  45       3.173   1.422 -10.340  1.00 46.06           C  
ATOM   9718  CE  LYS F  45       3.029   2.416  -9.159  1.00 52.68           C  
ATOM   9719  NZ  LYS F  45       1.617   2.931  -9.004  1.00 58.00           N  
ATOM   9720  N   LYS F  46       4.659  -3.194 -13.092  1.00 32.39           N  
ATOM   9721  CA  LYS F  46       4.513  -4.089 -14.246  1.00 34.85           C  
ATOM   9722  C   LYS F  46       5.110  -3.538 -15.545  1.00 29.15           C  
ATOM   9723  O   LYS F  46       4.455  -3.450 -16.580  1.00 27.35           O  
ATOM   9724  CB  LYS F  46       3.036  -4.515 -14.411  1.00 40.68           C  
ATOM   9725  CG  LYS F  46       2.465  -5.294 -13.211  1.00 49.23           C  
ATOM   9726  CD  LYS F  46       0.965  -5.574 -13.368  1.00 55.97           C  
ATOM   9727  CE  LYS F  46       0.365  -6.237 -12.112  1.00 60.89           C  
ATOM   9728  NZ  LYS F  46      -1.137  -6.397 -12.192  1.00 61.84           N  
ATOM   9729  N   VAL F  47       6.375  -3.157 -15.449  1.00 22.44           N  
ATOM   9730  CA  VAL F  47       7.113  -2.634 -16.565  1.00 21.92           C  
ATOM   9731  C   VAL F  47       8.234  -3.630 -16.689  1.00 23.62           C  
ATOM   9732  O   VAL F  47       9.136  -3.671 -15.876  1.00 24.28           O  
ATOM   9733  CB  VAL F  47       7.615  -1.211 -16.282  1.00 21.00           C  
ATOM   9734  CG1 VAL F  47       8.633  -0.771 -17.351  1.00 17.89           C  
ATOM   9735  CG2 VAL F  47       6.416  -0.265 -16.262  1.00 18.74           C  
ATOM   9736  N   TYR F  48       8.116  -4.459 -17.713  1.00 21.73           N  
ATOM   9737  CA  TYR F  48       9.032  -5.554 -17.981  1.00 22.93           C  
ATOM   9738  C   TYR F  48       9.985  -5.340 -19.141  1.00 21.53           C  
ATOM   9739  O   TYR F  48       9.688  -5.707 -20.279  1.00 29.99           O  
ATOM   9740  CB  TYR F  48       8.196  -6.824 -18.242  1.00 34.36           C  
ATOM   9741  CG  TYR F  48       7.226  -7.132 -17.127  1.00 40.10           C  
ATOM   9742  CD1 TYR F  48       7.673  -7.325 -15.823  1.00 41.65           C  
ATOM   9743  CD2 TYR F  48       5.852  -7.110 -17.355  1.00 46.66           C  
ATOM   9744  CE1 TYR F  48       6.787  -7.468 -14.769  1.00 45.86           C  
ATOM   9745  CE2 TYR F  48       4.944  -7.251 -16.298  1.00 50.56           C  
ATOM   9746  CZ  TYR F  48       5.425  -7.423 -15.012  1.00 48.34           C  
ATOM   9747  OH  TYR F  48       4.538  -7.480 -13.963  1.00 52.18           O  
ATOM   9748  N   PRO F  49      11.177  -4.816 -18.853  1.00 24.21           N  
ATOM   9749  CA  PRO F  49      12.146  -4.587 -19.932  1.00 22.65           C  
ATOM   9750  C   PRO F  49      12.531  -5.922 -20.610  1.00 20.90           C  
ATOM   9751  O   PRO F  49      12.741  -6.940 -19.927  1.00 19.07           O  
ATOM   9752  CB  PRO F  49      13.354  -3.983 -19.202  1.00 17.73           C  
ATOM   9753  CG  PRO F  49      12.777  -3.472 -17.868  1.00 18.57           C  
ATOM   9754  CD  PRO F  49      11.740  -4.496 -17.522  1.00 18.52           C  
ATOM   9755  N   ASP F  50      12.650  -5.910 -21.941  1.00 15.75           N  
ATOM   9756  CA  ASP F  50      13.036  -7.104 -22.714  1.00 15.96           C  
ATOM   9757  C   ASP F  50      14.513  -7.081 -23.038  1.00 15.34           C  
ATOM   9758  O   ASP F  50      15.103  -8.098 -23.375  1.00 23.07           O  
ATOM   9759  CB  ASP F  50      12.266  -7.133 -24.012  1.00 23.60           C  
ATOM   9760  CG  ASP F  50      10.802  -7.312 -23.801  1.00 25.88           C  
ATOM   9761  OD1 ASP F  50      10.451  -8.075 -22.910  1.00 25.91           O  
ATOM   9762  OD2 ASP F  50       9.987  -6.699 -24.516  1.00 22.42           O  
ATOM   9763  N   VAL F  51      15.096  -5.886 -22.984  1.00 13.20           N  
ATOM   9764  CA  VAL F  51      16.500  -5.681 -23.288  1.00 13.10           C  
ATOM   9765  C   VAL F  51      16.996  -4.453 -22.519  1.00 13.57           C  
ATOM   9766  O   VAL F  51      16.222  -3.561 -22.182  1.00 13.76           O  
ATOM   9767  CB  VAL F  51      16.752  -5.551 -24.848  1.00 14.28           C  
ATOM   9768  CG1 VAL F  51      15.880  -4.458 -25.453  1.00 15.70           C  
ATOM   9769  CG2 VAL F  51      18.220  -5.248 -25.144  1.00 22.94           C  
ATOM   9770  N   LEU F  52      18.270  -4.474 -22.166  1.00 14.71           N  
ATOM   9771  CA  LEU F  52      18.867  -3.392 -21.434  1.00 14.07           C  
ATOM   9772  C   LEU F  52      20.027  -2.789 -22.215  1.00 16.82           C  
ATOM   9773  O   LEU F  52      20.846  -3.525 -22.835  1.00 17.54           O  
ATOM   9774  CB  LEU F  52      19.451  -3.912 -20.111  1.00 13.92           C  
ATOM   9775  CG  LEU F  52      20.401  -2.973 -19.364  1.00 10.95           C  
ATOM   9776  CD1 LEU F  52      19.559  -1.807 -18.733  1.00 11.05           C  
ATOM   9777  CD2 LEU F  52      21.226  -3.721 -18.302  1.00 10.61           C  
ATOM   9778  N   TYR F  53      20.094  -1.454 -22.142  1.00 17.02           N  
ATOM   9779  CA  TYR F  53      21.173  -0.671 -22.724  1.00 14.86           C  
ATOM   9780  C   TYR F  53      21.791   0.150 -21.611  1.00 14.00           C  
ATOM   9781  O   TYR F  53      21.074   0.724 -20.796  1.00 15.33           O  
ATOM   9782  CB  TYR F  53      20.629   0.284 -23.772  1.00 10.97           C  
ATOM   9783  CG  TYR F  53      20.361  -0.381 -25.092  1.00  9.26           C  
ATOM   9784  CD1 TYR F  53      21.408  -0.635 -25.996  1.00 10.26           C  
ATOM   9785  CD2 TYR F  53      19.073  -0.790 -25.423  1.00 10.11           C  
ATOM   9786  CE1 TYR F  53      21.173  -1.304 -27.218  1.00 13.23           C  
ATOM   9787  CE2 TYR F  53      18.813  -1.435 -26.631  1.00 14.83           C  
ATOM   9788  CZ  TYR F  53      19.865  -1.704 -27.521  1.00 16.57           C  
ATOM   9789  OH  TYR F  53      19.597  -2.427 -28.667  1.00 17.39           O  
ATOM   9790  N   THR F  54      23.116   0.187 -21.556  1.00 14.71           N  
ATOM   9791  CA  THR F  54      23.785   1.008 -20.560  1.00 14.51           C  
ATOM   9792  C   THR F  54      25.002   1.739 -21.164  1.00 19.02           C  
ATOM   9793  O   THR F  54      25.379   1.507 -22.315  1.00 15.87           O  
ATOM   9794  CB  THR F  54      24.322   0.201 -19.351  1.00 13.24           C  
ATOM   9795  OG1 THR F  54      25.535  -0.455 -19.705  1.00  8.21           O  
ATOM   9796  CG2 THR F  54      23.330  -0.758 -18.836  1.00 10.40           C  
ATOM   9797  N   SER F  55      25.584   2.651 -20.395  1.00  9.39           N  
ATOM   9798  CA  SER F  55      26.818   3.342 -20.785  1.00  5.60           C  
ATOM   9799  C   SER F  55      27.949   2.343 -20.454  1.00  6.06           C  
ATOM   9800  O   SER F  55      27.676   1.197 -20.147  1.00 12.45           O  
ATOM   9801  CB  SER F  55      27.010   4.588 -19.909  1.00 11.64           C  
ATOM   9802  OG  SER F  55      27.061   4.217 -18.526  1.00 11.78           O  
ATOM   9803  N   LYS F  56      29.205   2.801 -20.509  1.00  3.54           N  
ATOM   9804  CA  LYS F  56      30.367   2.000 -20.148  1.00  4.31           C  
ATOM   9805  C   LYS F  56      30.837   2.409 -18.707  1.00  2.98           C  
ATOM   9806  O   LYS F  56      31.999   2.185 -18.320  1.00 18.98           O  
ATOM   9807  CB  LYS F  56      31.502   2.272 -21.130  1.00 20.84           C  
ATOM   9808  CG  LYS F  56      31.263   1.708 -22.550  1.00 19.70           C  
ATOM   9809  CD  LYS F  56      31.783   0.299 -22.708  1.00 25.92           C  
ATOM   9810  CE  LYS F  56      31.942  -0.106 -24.179  1.00 24.58           C  
ATOM   9811  NZ  LYS F  56      33.044  -1.117 -24.386  1.00 29.85           N  
ATOM   9812  N   LEU F  57      29.933   3.010 -17.930  1.00  6.64           N  
ATOM   9813  CA  LEU F  57      30.288   3.486 -16.581  1.00  8.05           C  
ATOM   9814  C   LEU F  57      29.591   2.663 -15.524  1.00  7.10           C  
ATOM   9815  O   LEU F  57      28.354   2.427 -15.584  1.00 12.41           O  
ATOM   9816  CB  LEU F  57      29.988   4.998 -16.441  1.00 11.96           C  
ATOM   9817  CG  LEU F  57      30.658   5.877 -17.529  1.00 13.85           C  
ATOM   9818  CD1 LEU F  57      30.051   7.315 -17.555  1.00 12.20           C  
ATOM   9819  CD2 LEU F  57      32.165   5.893 -17.344  1.00 11.44           C  
ATOM   9820  N   SER F  58      30.437   2.139 -14.620  1.00  9.57           N  
ATOM   9821  CA  SER F  58      30.025   1.254 -13.517  1.00  9.57           C  
ATOM   9822  C   SER F  58      28.826   1.694 -12.729  1.00 11.95           C  
ATOM   9823  O   SER F  58      27.957   0.870 -12.428  1.00 16.53           O  
ATOM   9824  CB  SER F  58      31.185   1.037 -12.566  1.00  6.61           C  
ATOM   9825  OG  SER F  58      32.364   0.734 -13.286  1.00 14.83           O  
ATOM   9826  N   ARG F  59      28.750   2.999 -12.407  1.00 15.21           N  
ATOM   9827  CA  ARG F  59      27.639   3.524 -11.608  1.00 11.14           C  
ATOM   9828  C   ARG F  59      26.307   3.243 -12.278  1.00 11.99           C  
ATOM   9829  O   ARG F  59      25.317   2.904 -11.604  1.00 17.72           O  
ATOM   9830  CB  ARG F  59      27.849   5.039 -11.280  1.00 15.93           C  
ATOM   9831  CG  ARG F  59      27.623   5.967 -12.440  1.00 11.87           C  
ATOM   9832  CD  ARG F  59      27.963   7.441 -12.191  1.00 17.32           C  
ATOM   9833  NE  ARG F  59      29.331   7.634 -12.560  1.00 22.97           N  
ATOM   9834  CZ  ARG F  59      29.785   8.525 -13.427  1.00 13.07           C  
ATOM   9835  NH1 ARG F  59      28.987   9.365 -14.039  1.00 19.67           N  
ATOM   9836  NH2 ARG F  59      31.072   8.504 -13.708  1.00 18.17           N  
ATOM   9837  N   ALA F  60      26.258   3.406 -13.611  1.00 10.99           N  
ATOM   9838  CA  ALA F  60      25.035   3.105 -14.372  1.00  8.85           C  
ATOM   9839  C   ALA F  60      24.893   1.562 -14.556  1.00 10.43           C  
ATOM   9840  O   ALA F  60      23.775   1.014 -14.532  1.00 12.00           O  
ATOM   9841  CB  ALA F  60      25.093   3.776 -15.717  1.00  9.98           C  
ATOM   9842  N   ILE F  61      26.016   0.859 -14.729  1.00 10.78           N  
ATOM   9843  CA  ILE F  61      25.915  -0.583 -14.913  1.00 13.83           C  
ATOM   9844  C   ILE F  61      25.464  -1.264 -13.597  1.00 14.87           C  
ATOM   9845  O   ILE F  61      24.551  -2.086 -13.610  1.00 14.76           O  
ATOM   9846  CB  ILE F  61      27.222  -1.207 -15.461  1.00 15.74           C  
ATOM   9847  CG1 ILE F  61      27.583  -0.584 -16.845  1.00 11.45           C  
ATOM   9848  CG2 ILE F  61      27.028  -2.739 -15.580  1.00 11.33           C  
ATOM   9849  CD1 ILE F  61      29.034  -0.786 -17.257  1.00  7.27           C  
ATOM   9850  N   GLN F  62      26.046  -0.875 -12.453  1.00 14.24           N  
ATOM   9851  CA  GLN F  62      25.629  -1.473 -11.205  1.00 12.90           C  
ATOM   9852  C   GLN F  62      24.168  -1.149 -10.939  1.00 12.42           C  
ATOM   9853  O   GLN F  62      23.431  -1.998 -10.451  1.00 21.39           O  
ATOM   9854  CB  GLN F  62      26.510  -1.033 -10.051  1.00 19.17           C  
ATOM   9855  CG  GLN F  62      26.244  -1.844  -8.794  1.00 25.83           C  
ATOM   9856  CD  GLN F  62      27.275  -1.595  -7.721  1.00 31.14           C  
ATOM   9857  OE1 GLN F  62      27.795  -0.491  -7.606  1.00 32.55           O  
ATOM   9858  NE2 GLN F  62      27.620  -2.654  -6.949  1.00 19.80           N  
ATOM   9859  N   THR F  63      23.718   0.039 -11.318  1.00 12.22           N  
ATOM   9860  CA  THR F  63      22.311   0.409 -11.135  1.00 11.23           C  
ATOM   9861  C   THR F  63      21.364  -0.566 -11.853  1.00 13.94           C  
ATOM   9862  O   THR F  63      20.310  -0.986 -11.305  1.00 16.57           O  
ATOM   9863  CB  THR F  63      22.080   1.882 -11.632  1.00 11.30           C  
ATOM   9864  OG1 THR F  63      22.869   2.738 -10.830  1.00  9.76           O  
ATOM   9865  CG2 THR F  63      20.598   2.333 -11.565  1.00  5.02           C  
ATOM   9866  N   ALA F  64      21.689  -0.855 -13.119  1.00  9.28           N  
ATOM   9867  CA  ALA F  64      20.866  -1.771 -13.921  1.00  6.69           C  
ATOM   9868  C   ALA F  64      20.847  -3.201 -13.289  1.00  3.78           C  
ATOM   9869  O   ALA F  64      19.775  -3.798 -13.147  1.00 13.41           O  
ATOM   9870  CB  ALA F  64      21.373  -1.806 -15.350  1.00 11.00           C  
ATOM   9871  N   ASN F  65      22.016  -3.694 -12.895  1.00 10.77           N  
ATOM   9872  CA  ASN F  65      22.174  -5.011 -12.267  1.00 13.06           C  
ATOM   9873  C   ASN F  65      21.324  -5.121 -10.969  1.00 17.03           C  
ATOM   9874  O   ASN F  65      20.529  -6.066 -10.818  1.00 12.48           O  
ATOM   9875  CB  ASN F  65      23.666  -5.271 -11.958  1.00  7.91           C  
ATOM   9876  CG  ASN F  65      24.493  -5.440 -13.212  1.00 14.01           C  
ATOM   9877  OD1 ASN F  65      25.726  -5.446 -13.205  1.00 10.04           O  
ATOM   9878  ND2 ASN F  65      23.798  -5.567 -14.312  1.00  2.43           N  
ATOM   9879  N   ILE F  66      21.436  -4.138 -10.067  1.00 14.23           N  
ATOM   9880  CA  ILE F  66      20.660  -4.179  -8.835  1.00 12.85           C  
ATOM   9881  C   ILE F  66      19.167  -4.029  -9.136  1.00 15.79           C  
ATOM   9882  O   ILE F  66      18.333  -4.745  -8.576  1.00 16.92           O  
ATOM   9883  CB  ILE F  66      21.138  -3.094  -7.820  1.00 12.78           C  
ATOM   9884  CG1 ILE F  66      22.590  -3.319  -7.447  1.00 10.27           C  
ATOM   9885  CG2 ILE F  66      20.321  -3.152  -6.536  1.00 11.86           C  
ATOM   9886  CD1 ILE F  66      23.257  -2.066  -6.937  1.00 12.81           C  
ATOM   9887  N   ALA F  67      18.812  -3.122 -10.043  1.00  9.46           N  
ATOM   9888  CA  ALA F  67      17.416  -2.926 -10.374  1.00 10.52           C  
ATOM   9889  C   ALA F  67      16.773  -4.165 -11.010  1.00 12.78           C  
ATOM   9890  O   ALA F  67      15.634  -4.524 -10.709  1.00 18.87           O  
ATOM   9891  CB  ALA F  67      17.281  -1.719 -11.299  1.00 13.48           C  
ATOM   9892  N   LEU F  68      17.479  -4.769 -11.962  1.00 24.93           N  
ATOM   9893  CA  LEU F  68      16.968  -5.954 -12.649  1.00 22.79           C  
ATOM   9894  C   LEU F  68      16.893  -7.173 -11.738  1.00 21.09           C  
ATOM   9895  O   LEU F  68      16.106  -8.068 -12.011  1.00 17.45           O  
ATOM   9896  CB  LEU F  68      17.818  -6.288 -13.893  1.00 13.82           C  
ATOM   9897  CG  LEU F  68      17.647  -5.290 -15.031  1.00 15.83           C  
ATOM   9898  CD1 LEU F  68      18.709  -5.498 -16.061  1.00 16.06           C  
ATOM   9899  CD2 LEU F  68      16.261  -5.394 -15.576  1.00  8.42           C  
ATOM   9900  N   GLU F  69      17.750  -7.230 -10.707  1.00 15.49           N  
ATOM   9901  CA  GLU F  69      17.712  -8.341  -9.756  1.00 18.50           C  
ATOM   9902  C   GLU F  69      16.377  -8.256  -9.000  1.00 20.11           C  
ATOM   9903  O   GLU F  69      15.614  -9.248  -8.923  1.00 21.34           O  
ATOM   9904  CB  GLU F  69      18.928  -8.295  -8.827  1.00 17.83           C  
ATOM   9905  CG  GLU F  69      19.118  -9.549  -7.934  1.00 25.50           C  
ATOM   9906  CD  GLU F  69      18.161  -9.561  -6.730  1.00 27.70           C  
ATOM   9907  OE1 GLU F  69      18.167  -8.548  -5.998  1.00 31.39           O  
ATOM   9908  OE2 GLU F  69      17.416 -10.555  -6.509  1.00 27.97           O  
ATOM   9909  N   LYS F  70      16.043  -7.022  -8.583  1.00 23.69           N  
ATOM   9910  CA  LYS F  70      14.794  -6.717  -7.877  1.00 24.23           C  
ATOM   9911  C   LYS F  70      13.595  -6.918  -8.784  1.00 23.06           C  
ATOM   9912  O   LYS F  70      12.490  -7.237  -8.334  1.00 20.48           O  
ATOM   9913  CB  LYS F  70      14.807  -5.267  -7.349  1.00 17.72           C  
ATOM   9914  CG  LYS F  70      15.915  -5.023  -6.337  1.00 21.62           C  
ATOM   9915  CD  LYS F  70      15.713  -5.921  -5.109  1.00 27.13           C  
ATOM   9916  CE  LYS F  70      16.904  -5.928  -4.163  1.00 27.45           C  
ATOM   9917  NZ  LYS F  70      16.548  -6.754  -2.974  1.00 31.28           N  
ATOM   9918  N   ALA F  71      13.809  -6.714 -10.075  1.00 26.05           N  
ATOM   9919  CA  ALA F  71      12.727  -6.900 -11.036  1.00 26.87           C  
ATOM   9920  C   ALA F  71      12.576  -8.352 -11.522  1.00 26.00           C  
ATOM   9921  O   ALA F  71      11.585  -8.659 -12.172  1.00 24.98           O  
ATOM   9922  CB  ALA F  71      12.905  -5.965 -12.214  1.00 20.05           C  
ATOM   9923  N   ASP F  72      13.520  -9.239 -11.166  1.00 23.05           N  
ATOM   9924  CA  ASP F  72      13.515 -10.666 -11.574  1.00 26.59           C  
ATOM   9925  C   ASP F  72      13.670 -10.819 -13.091  1.00 28.35           C  
ATOM   9926  O   ASP F  72      13.063 -11.699 -13.728  1.00 45.25           O  
ATOM   9927  CB  ASP F  72      12.245 -11.412 -11.114  1.00 42.47           C  
ATOM   9928  CG  ASP F  72      12.071 -11.407  -9.623  1.00 50.70           C  
ATOM   9929  OD1 ASP F  72      13.053 -11.712  -8.902  1.00 51.17           O  
ATOM   9930  OD2 ASP F  72      10.952 -11.078  -9.166  1.00 53.02           O  
ATOM   9931  N   ARG F  73      14.508  -9.957 -13.657  1.00 20.69           N  
ATOM   9932  CA  ARG F  73      14.750  -9.960 -15.084  1.00 16.56           C  
ATOM   9933  C   ARG F  73      16.207  -9.835 -15.380  1.00 15.66           C  
ATOM   9934  O   ARG F  73      16.598  -9.075 -16.276  1.00 14.61           O  
ATOM   9935  CB  ARG F  73      14.012  -8.801 -15.742  1.00 23.01           C  
ATOM   9936  CG  ARG F  73      12.514  -8.910 -15.666  1.00 19.41           C  
ATOM   9937  CD  ARG F  73      11.939  -8.338 -16.936  1.00 22.52           C  
ATOM   9938  NE  ARG F  73      10.829  -9.175 -17.319  1.00 31.03           N  
ATOM   9939  CZ  ARG F  73      10.497  -9.501 -18.557  1.00 25.31           C  
ATOM   9940  NH1 ARG F  73      11.176  -9.075 -19.621  1.00 25.07           N  
ATOM   9941  NH2 ARG F  73       9.450 -10.279 -18.704  1.00 34.27           N  
ATOM   9942  N   LEU F  74      17.015 -10.541 -14.603  1.00 15.10           N  
ATOM   9943  CA  LEU F  74      18.440 -10.467 -14.800  1.00 15.26           C  
ATOM   9944  C   LEU F  74      18.856 -11.085 -16.095  1.00 16.50           C  
ATOM   9945  O   LEU F  74      19.878 -10.709 -16.646  1.00 20.06           O  
ATOM   9946  CB  LEU F  74      19.192 -11.155 -13.676  1.00 14.86           C  
ATOM   9947  CG  LEU F  74      19.453 -10.390 -12.372  1.00 16.54           C  
ATOM   9948  CD1 LEU F  74      20.091 -11.364 -11.332  1.00 14.87           C  
ATOM   9949  CD2 LEU F  74      20.364  -9.173 -12.608  1.00 16.84           C  
ATOM   9950  N   TRP F  75      18.054 -12.014 -16.591  1.00 19.47           N  
ATOM   9951  CA  TRP F  75      18.395 -12.742 -17.804  1.00 21.92           C  
ATOM   9952  C   TRP F  75      18.395 -12.016 -19.168  1.00 21.46           C  
ATOM   9953  O   TRP F  75      18.919 -12.569 -20.131  1.00 15.87           O  
ATOM   9954  CB  TRP F  75      17.487 -13.952 -17.898  1.00 16.72           C  
ATOM   9955  CG  TRP F  75      16.037 -13.566 -17.957  1.00 16.15           C  
ATOM   9956  CD1 TRP F  75      15.157 -13.525 -16.918  1.00 14.45           C  
ATOM   9957  CD2 TRP F  75      15.295 -13.204 -19.128  1.00 17.60           C  
ATOM   9958  NE1 TRP F  75      13.911 -13.173 -17.366  1.00 18.11           N  
ATOM   9959  CE2 TRP F  75      13.969 -12.976 -18.723  1.00 14.38           C  
ATOM   9960  CE3 TRP F  75      15.629 -13.068 -20.492  1.00 16.65           C  
ATOM   9961  CZ2 TRP F  75      12.966 -12.622 -19.620  1.00 17.19           C  
ATOM   9962  CZ3 TRP F  75      14.645 -12.726 -21.387  1.00 13.95           C  
ATOM   9963  CH2 TRP F  75      13.319 -12.504 -20.951  1.00 13.69           C  
ATOM   9964  N   ILE F  76      17.820 -10.804 -19.237  1.00 13.26           N  
ATOM   9965  CA  ILE F  76      17.702 -10.046 -20.481  1.00  7.55           C  
ATOM   9966  C   ILE F  76      18.989  -9.640 -21.099  1.00  8.21           C  
ATOM   9967  O   ILE F  76      19.982  -9.500 -20.407  1.00 13.99           O  
ATOM   9968  CB  ILE F  76      16.749  -8.861 -20.375  1.00 12.19           C  
ATOM   9969  CG1 ILE F  76      17.314  -7.743 -19.499  1.00 12.66           C  
ATOM   9970  CG2 ILE F  76      15.475  -9.314 -19.791  1.00  9.03           C  
ATOM   9971  CD1 ILE F  76      16.398  -6.589 -19.428  1.00  8.93           C  
ATOM   9972  N   PRO F  77      19.027  -9.612 -22.456  1.00 13.11           N  
ATOM   9973  CA  PRO F  77      20.213  -9.240 -23.236  1.00 13.79           C  
ATOM   9974  C   PRO F  77      20.716  -7.876 -22.746  1.00 14.31           C  
ATOM   9975  O   PRO F  77      19.926  -7.009 -22.385  1.00  9.52           O  
ATOM   9976  CB  PRO F  77      19.661  -9.075 -24.669  1.00 10.59           C  
ATOM   9977  CG  PRO F  77      18.369  -9.841 -24.696  1.00 12.59           C  
ATOM   9978  CD  PRO F  77      17.813  -9.754 -23.309  1.00  8.87           C  
ATOM   9979  N   VAL F  78      22.008  -7.636 -22.808  1.00 16.25           N  
ATOM   9980  CA  VAL F  78      22.481  -6.336 -22.409  1.00 17.69           C  
ATOM   9981  C   VAL F  78      23.518  -5.833 -23.392  1.00 17.04           C  
ATOM   9982  O   VAL F  78      24.370  -6.594 -23.847  1.00 15.19           O  
ATOM   9983  CB  VAL F  78      22.957  -6.268 -20.876  1.00 20.16           C  
ATOM   9984  CG1 VAL F  78      22.813  -7.597 -20.179  1.00 23.32           C  
ATOM   9985  CG2 VAL F  78      24.379  -5.764 -20.740  1.00 18.16           C  
ATOM   9986  N   ASN F  79      23.412  -4.545 -23.742  1.00 17.71           N  
ATOM   9987  CA  ASN F  79      24.382  -3.885 -24.655  1.00 18.47           C  
ATOM   9988  C   ASN F  79      24.826  -2.600 -24.002  1.00 14.29           C  
ATOM   9989  O   ASN F  79      24.041  -1.963 -23.350  1.00 10.99           O  
ATOM   9990  CB  ASN F  79      23.723  -3.570 -25.999  1.00 19.78           C  
ATOM   9991  CG  ASN F  79      23.078  -4.789 -26.606  1.00 25.81           C  
ATOM   9992  OD1 ASN F  79      21.841  -4.979 -26.513  1.00 29.00           O  
ATOM   9993  ND2 ASN F  79      23.930  -5.705 -27.093  1.00 21.74           N  
ATOM   9994  N   ARG F  80      26.094  -2.270 -24.157  1.00 11.48           N  
ATOM   9995  CA  ARG F  80      26.703  -1.074 -23.585  1.00 11.52           C  
ATOM   9996  C   ARG F  80      27.313  -0.231 -24.691  1.00 11.85           C  
ATOM   9997  O   ARG F  80      27.865  -0.760 -25.655  1.00 19.16           O  
ATOM   9998  CB  ARG F  80      27.843  -1.456 -22.600  1.00 20.77           C  
ATOM   9999  CG  ARG F  80      27.720  -2.858 -21.997  1.00 23.07           C  
ATOM  10000  CD  ARG F  80      28.370  -3.048 -20.619  1.00 25.02           C  
ATOM  10001  NE  ARG F  80      27.286  -3.263 -19.669  1.00 32.06           N  
ATOM  10002  CZ  ARG F  80      27.127  -4.343 -18.927  1.00 23.13           C  
ATOM  10003  NH1 ARG F  80      27.989  -5.336 -18.981  1.00 31.12           N  
ATOM  10004  NH2 ARG F  80      26.050  -4.480 -18.187  1.00 35.95           N  
ATOM  10005  N   SER F  81      27.320   1.083 -24.496  1.00 14.97           N  
ATOM  10006  CA  SER F  81      27.879   2.011 -25.471  1.00 13.98           C  
ATOM  10007  C   SER F  81      28.426   3.249 -24.818  1.00 15.81           C  
ATOM  10008  O   SER F  81      27.784   3.831 -23.962  1.00  9.45           O  
ATOM  10009  CB  SER F  81      26.801   2.470 -26.467  1.00  5.46           C  
ATOM  10010  OG  SER F  81      27.395   3.397 -27.382  1.00  5.72           O  
ATOM  10011  N   TRP F  82      29.590   3.676 -25.265  1.00 12.40           N  
ATOM  10012  CA  TRP F  82      30.174   4.911 -24.783  1.00 12.37           C  
ATOM  10013  C   TRP F  82      29.216   6.102 -25.108  1.00 14.81           C  
ATOM  10014  O   TRP F  82      29.284   7.149 -24.471  1.00 19.65           O  
ATOM  10015  CB  TRP F  82      31.521   5.155 -25.462  1.00 18.89           C  
ATOM  10016  CG  TRP F  82      31.431   5.645 -26.932  1.00 19.45           C  
ATOM  10017  CD1 TRP F  82      31.427   4.864 -28.089  1.00 15.00           C  
ATOM  10018  CD2 TRP F  82      31.424   7.013 -27.383  1.00 17.32           C  
ATOM  10019  NE1 TRP F  82      31.428   5.666 -29.201  1.00 14.59           N  
ATOM  10020  CE2 TRP F  82      31.433   6.981 -28.811  1.00 14.66           C  
ATOM  10021  CE3 TRP F  82      31.421   8.255 -26.722  1.00 18.25           C  
ATOM  10022  CZ2 TRP F  82      31.447   8.164 -29.592  1.00 13.18           C  
ATOM  10023  CZ3 TRP F  82      31.432   9.428 -27.492  1.00 17.24           C  
ATOM  10024  CH2 TRP F  82      31.448   9.374 -28.913  1.00 15.39           C  
ATOM  10025  N   ARG F  83      28.336   5.936 -26.103  1.00 15.36           N  
ATOM  10026  CA  ARG F  83      27.435   6.997 -26.518  1.00 14.49           C  
ATOM  10027  C   ARG F  83      26.352   7.298 -25.535  1.00 16.63           C  
ATOM  10028  O   ARG F  83      25.649   8.291 -25.680  1.00 13.53           O  
ATOM  10029  CB  ARG F  83      26.873   6.722 -27.919  1.00 11.23           C  
ATOM  10030  CG  ARG F  83      28.001   6.636 -28.960  1.00 11.26           C  
ATOM  10031  CD  ARG F  83      27.522   6.334 -30.409  1.00 10.83           C  
ATOM  10032  NE  ARG F  83      28.675   6.354 -31.306  1.00 15.80           N  
ATOM  10033  CZ  ARG F  83      29.085   7.413 -32.008  1.00 10.89           C  
ATOM  10034  NH1 ARG F  83      28.418   8.557 -31.932  1.00 15.04           N  
ATOM  10035  NH2 ARG F  83      30.227   7.369 -32.713  1.00 12.02           N  
ATOM  10036  N   LEU F  84      26.177   6.436 -24.543  1.00  9.20           N  
ATOM  10037  CA  LEU F  84      25.172   6.692 -23.510  1.00  9.22           C  
ATOM  10038  C   LEU F  84      25.848   7.208 -22.235  1.00  8.68           C  
ATOM  10039  O   LEU F  84      25.207   7.400 -21.236  1.00 10.13           O  
ATOM  10040  CB  LEU F  84      24.357   5.450 -23.181  1.00  9.56           C  
ATOM  10041  CG  LEU F  84      23.418   4.913 -24.203  1.00  7.78           C  
ATOM  10042  CD1 LEU F  84      22.915   3.514 -23.739  1.00  2.07           C  
ATOM  10043  CD2 LEU F  84      22.302   5.919 -24.387  1.00  6.31           C  
ATOM  10044  N   ASN F  85      27.151   7.421 -22.305  1.00  7.20           N  
ATOM  10045  CA  ASN F  85      27.931   7.915 -21.204  1.00  9.45           C  
ATOM  10046  C   ASN F  85      27.479   9.320 -20.723  1.00 13.44           C  
ATOM  10047  O   ASN F  85      26.802  10.091 -21.439  1.00 14.93           O  
ATOM  10048  CB  ASN F  85      29.410   8.003 -21.611  1.00  5.64           C  
ATOM  10049  CG  ASN F  85      30.171   6.714 -21.370  1.00  9.34           C  
ATOM  10050  OD1 ASN F  85      29.575   5.685 -21.096  1.00 10.63           O  
ATOM  10051  ND2 ASN F  85      31.496   6.775 -21.456  1.00  6.96           N  
ATOM  10052  N   GLU F  86      27.822   9.629 -19.483  1.00 16.34           N  
ATOM  10053  CA  GLU F  86      27.546  10.947 -18.960  1.00 14.87           C  
ATOM  10054  C   GLU F  86      28.427  11.908 -19.780  1.00 15.99           C  
ATOM  10055  O   GLU F  86      29.442  11.521 -20.396  1.00 13.66           O  
ATOM  10056  CB  GLU F  86      28.030  11.049 -17.496  1.00 10.10           C  
ATOM  10057  CG  GLU F  86      27.908  12.462 -16.851  1.00  8.27           C  
ATOM  10058  CD  GLU F  86      26.482  12.907 -16.701  1.00 11.36           C  
ATOM  10059  OE1 GLU F  86      25.857  13.411 -17.660  1.00 17.36           O  
ATOM  10060  OE2 GLU F  86      25.927  12.726 -15.614  1.00 19.05           O  
ATOM  10061  N   ARG F  87      28.047  13.168 -19.754  1.00 16.03           N  
ATOM  10062  CA  ARG F  87      28.823  14.213 -20.386  1.00 13.04           C  
ATOM  10063  C   ARG F  87      30.222  14.285 -19.777  1.00 13.59           C  
ATOM  10064  O   ARG F  87      30.389  14.205 -18.562  1.00 22.36           O  
ATOM  10065  CB  ARG F  87      28.085  15.533 -20.205  1.00 20.42           C  
ATOM  10066  CG  ARG F  87      28.730  16.671 -20.909  1.00 26.15           C  
ATOM  10067  CD  ARG F  87      29.465  17.447 -19.917  1.00 35.09           C  
ATOM  10068  NE  ARG F  87      28.515  18.080 -19.004  1.00 35.56           N  
ATOM  10069  CZ  ARG F  87      28.597  19.344 -18.661  1.00 34.78           C  
ATOM  10070  NH1 ARG F  87      29.578  20.072 -19.159  1.00 38.76           N  
ATOM  10071  NH2 ARG F  87      27.711  19.864 -17.837  1.00 29.21           N  
ATOM  10072  N   HIS F  88      31.236  14.309 -20.634  1.00 15.60           N  
ATOM  10073  CA  HIS F  88      32.621  14.395 -20.210  1.00 15.84           C  
ATOM  10074  C   HIS F  88      32.789  15.801 -19.626  1.00 17.35           C  
ATOM  10075  O   HIS F  88      32.471  16.779 -20.275  1.00 12.10           O  
ATOM  10076  CB  HIS F  88      33.518  14.217 -21.420  1.00  7.41           C  
ATOM  10077  CG  HIS F  88      34.955  14.007 -21.094  1.00  6.95           C  
ATOM  10078  ND1 HIS F  88      35.749  14.996 -20.592  1.00  8.00           N  
ATOM  10079  CD2 HIS F  88      35.738  12.922 -21.226  1.00  7.37           C  
ATOM  10080  CE1 HIS F  88      36.979  14.539 -20.417  1.00  6.62           C  
ATOM  10081  NE2 HIS F  88      36.995  13.277 -20.801  1.00  6.78           N  
ATOM  10082  N   TYR F  89      33.348  15.908 -18.428  1.00 22.58           N  
ATOM  10083  CA  TYR F  89      33.482  17.206 -17.796  1.00 21.95           C  
ATOM  10084  C   TYR F  89      34.780  17.935 -18.028  1.00 24.34           C  
ATOM  10085  O   TYR F  89      35.038  18.978 -17.434  1.00 26.23           O  
ATOM  10086  CB  TYR F  89      33.189  17.085 -16.315  1.00 21.01           C  
ATOM  10087  CG  TYR F  89      31.941  17.812 -15.942  1.00 27.02           C  
ATOM  10088  CD1 TYR F  89      31.895  19.225 -15.981  1.00 31.35           C  
ATOM  10089  CD2 TYR F  89      30.828  17.136 -15.486  1.00 28.03           C  
ATOM  10090  CE1 TYR F  89      30.769  19.918 -15.558  1.00 33.59           C  
ATOM  10091  CE2 TYR F  89      29.694  17.831 -15.057  1.00 32.16           C  
ATOM  10092  CZ  TYR F  89      29.676  19.208 -15.101  1.00 36.32           C  
ATOM  10093  OH  TYR F  89      28.549  19.879 -14.701  1.00 38.51           O  
ATOM  10094  N   GLY F  90      35.592  17.399 -18.915  1.00 18.80           N  
ATOM  10095  CA  GLY F  90      36.857  18.035 -19.215  1.00 17.60           C  
ATOM  10096  C   GLY F  90      37.730  18.280 -18.018  1.00 20.26           C  
ATOM  10097  O   GLY F  90      37.915  17.380 -17.220  1.00 23.82           O  
ATOM  10098  N   ASP F  91      38.253  19.499 -17.889  1.00 15.64           N  
ATOM  10099  CA  ASP F  91      39.138  19.879 -16.769  1.00 14.93           C  
ATOM  10100  C   ASP F  91      38.442  19.932 -15.428  1.00 14.63           C  
ATOM  10101  O   ASP F  91      39.094  19.976 -14.397  1.00 28.10           O  
ATOM  10102  CB  ASP F  91      39.802  21.245 -17.008  1.00 37.22           C  
ATOM  10103  CG  ASP F  91      41.270  21.245 -16.619  1.00 45.14           C  
ATOM  10104  OD1 ASP F  91      41.868  20.147 -16.538  1.00 50.98           O  
ATOM  10105  OD2 ASP F  91      41.841  22.334 -16.411  1.00 53.78           O  
ATOM  10106  N   LEU F  92      37.124  19.960 -15.454  1.00 10.23           N  
ATOM  10107  CA  LEU F  92      36.330  19.986 -14.255  1.00 10.82           C  
ATOM  10108  C   LEU F  92      36.267  18.619 -13.562  1.00 14.36           C  
ATOM  10109  O   LEU F  92      35.957  18.559 -12.374  1.00 20.58           O  
ATOM  10110  CB  LEU F  92      34.923  20.535 -14.553  1.00 10.22           C  
ATOM  10111  CG  LEU F  92      34.874  22.049 -14.383  1.00 18.27           C  
ATOM  10112  CD1 LEU F  92      36.135  22.689 -14.911  1.00 15.93           C  
ATOM  10113  CD2 LEU F  92      33.678  22.616 -15.068  1.00 11.19           C  
ATOM  10114  N   GLN F  93      36.563  17.539 -14.306  1.00 15.09           N  
ATOM  10115  CA  GLN F  93      36.575  16.164 -13.768  1.00 15.04           C  
ATOM  10116  C   GLN F  93      37.560  16.010 -12.607  1.00 17.22           C  
ATOM  10117  O   GLN F  93      38.770  16.275 -12.749  1.00 18.46           O  
ATOM  10118  CB  GLN F  93      36.902  15.104 -14.866  1.00 10.82           C  
ATOM  10119  CG  GLN F  93      35.848  15.045 -15.952  1.00  8.19           C  
ATOM  10120  CD  GLN F  93      35.966  13.843 -16.905  1.00  6.55           C  
ATOM  10121  OE1 GLN F  93      34.961  13.394 -17.418  1.00  9.58           O  
ATOM  10122  NE2 GLN F  93      37.181  13.355 -17.153  1.00  4.89           N  
ATOM  10123  N   GLY F  94      36.993  15.617 -11.458  1.00 17.03           N  
ATOM  10124  CA  GLY F  94      37.763  15.396 -10.243  1.00 18.35           C  
ATOM  10125  C   GLY F  94      38.042  16.625  -9.403  1.00 18.43           C  
ATOM  10126  O   GLY F  94      38.884  16.565  -8.494  1.00 23.34           O  
ATOM  10127  N   LYS F  95      37.359  17.732  -9.723  1.00 16.50           N  
ATOM  10128  CA  LYS F  95      37.535  19.012  -9.047  1.00 20.60           C  
ATOM  10129  C   LYS F  95      36.359  19.196  -8.094  1.00 21.57           C  
ATOM  10130  O   LYS F  95      35.261  18.761  -8.380  1.00 18.15           O  
ATOM  10131  CB  LYS F  95      37.548  20.209 -10.052  1.00 14.32           C  
ATOM  10132  CG  LYS F  95      38.655  20.251 -11.130  1.00 19.16           C  
ATOM  10133  CD  LYS F  95      39.976  20.812 -10.660  1.00 27.66           C  
ATOM  10134  CE  LYS F  95      40.841  21.313 -11.868  1.00 30.90           C  
ATOM  10135  NZ  LYS F  95      40.217  22.478 -12.691  1.00 26.73           N  
ATOM  10136  N   ASP F  96      36.580  19.947  -7.017  1.00 15.57           N  
ATOM  10137  CA  ASP F  96      35.555  20.215  -6.010  1.00 12.07           C  
ATOM  10138  C   ASP F  96      34.555  21.177  -6.622  1.00 10.44           C  
ATOM  10139  O   ASP F  96      34.962  22.188  -7.174  1.00 21.25           O  
ATOM  10140  CB  ASP F  96      36.271  20.817  -4.773  1.00 22.92           C  
ATOM  10141  CG  ASP F  96      35.334  21.095  -3.591  1.00 25.28           C  
ATOM  10142  OD1 ASP F  96      34.582  22.091  -3.678  1.00 26.35           O  
ATOM  10143  OD2 ASP F  96      35.368  20.343  -2.588  1.00 27.16           O  
ATOM  10144  N   LYS F  97      33.260  20.876  -6.553  1.00 15.27           N  
ATOM  10145  CA  LYS F  97      32.264  21.780  -7.132  1.00 18.07           C  
ATOM  10146  C   LYS F  97      32.204  23.160  -6.451  1.00 24.45           C  
ATOM  10147  O   LYS F  97      32.087  24.182  -7.127  1.00 25.42           O  
ATOM  10148  CB  LYS F  97      30.866  21.159  -7.114  1.00 17.63           C  
ATOM  10149  CG  LYS F  97      30.818  19.789  -7.774  1.00 18.18           C  
ATOM  10150  CD  LYS F  97      29.396  19.260  -7.816  1.00 18.70           C  
ATOM  10151  CE  LYS F  97      29.374  17.844  -8.409  1.00 20.37           C  
ATOM  10152  NZ  LYS F  97      27.998  17.309  -8.420  1.00 23.05           N  
ATOM  10153  N   ALA F  98      32.203  23.205  -5.116  1.00 30.19           N  
ATOM  10154  CA  ALA F  98      32.163  24.499  -4.435  1.00 31.94           C  
ATOM  10155  C   ALA F  98      33.441  25.313  -4.718  1.00 31.66           C  
ATOM  10156  O   ALA F  98      33.365  26.515  -4.977  1.00 32.82           O  
ATOM  10157  CB  ALA F  98      31.913  24.321  -2.951  1.00 31.26           C  
ATOM  10158  N   GLU F  99      34.602  24.649  -4.759  1.00 22.56           N  
ATOM  10159  CA  GLU F  99      35.877  25.326  -5.061  1.00 24.06           C  
ATOM  10160  C   GLU F  99      35.876  25.934  -6.472  1.00 27.02           C  
ATOM  10161  O   GLU F  99      36.692  26.817  -6.789  1.00 48.88           O  
ATOM  10162  CB  GLU F  99      37.053  24.356  -4.955  1.00 45.16           C  
ATOM  10163  CG  GLU F  99      37.455  24.021  -3.545  1.00 54.98           C  
ATOM  10164  CD  GLU F  99      38.831  23.381  -3.476  1.00 61.27           C  
ATOM  10165  OE1 GLU F  99      39.665  23.673  -4.373  1.00 59.97           O  
ATOM  10166  OE2 GLU F  99      39.079  22.598  -2.519  1.00 64.05           O  
ATOM  10167  N   THR F 100      35.043  25.338  -7.336  1.00 43.99           N  
ATOM  10168  CA  THR F 100      34.875  25.736  -8.736  1.00 41.31           C  
ATOM  10169  C   THR F 100      33.899  26.939  -8.786  1.00 40.80           C  
ATOM  10170  O   THR F 100      34.092  27.854  -9.589  1.00 32.73           O  
ATOM  10171  CB  THR F 100      34.394  24.508  -9.650  1.00 30.81           C  
ATOM  10172  OG1 THR F 100      35.457  23.547  -9.841  1.00 23.10           O  
ATOM  10173  CG2 THR F 100      33.944  25.000 -10.997  1.00 24.49           C  
ATOM  10174  N   LEU F 101      32.896  26.976  -7.898  1.00 29.08           N  
ATOM  10175  CA  LEU F 101      31.964  28.110  -7.852  1.00 31.82           C  
ATOM  10176  C   LEU F 101      32.748  29.390  -7.527  1.00 36.45           C  
ATOM  10177  O   LEU F 101      32.410  30.471  -7.993  1.00 43.38           O  
ATOM  10178  CB  LEU F 101      30.848  27.873  -6.821  1.00 30.92           C  
ATOM  10179  CG  LEU F 101      29.796  28.966  -6.556  1.00 30.13           C  
ATOM  10180  CD1 LEU F 101      29.160  29.507  -7.792  1.00 28.80           C  
ATOM  10181  CD2 LEU F 101      28.707  28.407  -5.667  1.00 29.06           C  
ATOM  10182  N   LYS F 102      33.839  29.240  -6.781  1.00 45.96           N  
ATOM  10183  CA  LYS F 102      34.690  30.370  -6.416  1.00 47.87           C  
ATOM  10184  C   LYS F 102      35.665  30.725  -7.544  1.00 47.87           C  
ATOM  10185  O   LYS F 102      35.658  31.852  -8.034  1.00 58.82           O  
ATOM  10186  CB  LYS F 102      35.470  30.076  -5.126  1.00 58.76           C  
ATOM  10187  CG  LYS F 102      34.610  29.706  -3.936  1.00 61.43           C  
ATOM  10188  CD  LYS F 102      35.481  29.278  -2.781  1.00 69.27           C  
ATOM  10189  CE  LYS F 102      34.654  28.726  -1.645  1.00 70.30           C  
ATOM  10190  NZ  LYS F 102      35.529  28.376  -0.494  1.00 69.98           N  
ATOM  10191  N   LYS F 103      36.481  29.756  -7.964  1.00 42.33           N  
ATOM  10192  CA  LYS F 103      37.477  29.954  -9.019  1.00 44.82           C  
ATOM  10193  C   LYS F 103      36.921  30.467 -10.369  1.00 48.27           C  
ATOM  10194  O   LYS F 103      37.704  30.819 -11.252  1.00 74.11           O  
ATOM  10195  CB  LYS F 103      38.296  28.669  -9.220  1.00 62.58           C  
ATOM  10196  CG  LYS F 103      39.332  28.742 -10.336  1.00 59.53           C  
ATOM  10197  CD  LYS F 103      39.968  27.381 -10.610  1.00 59.71           C  
ATOM  10198  CE  LYS F 103      40.856  27.409 -11.864  1.00 59.80           C  
ATOM  10199  NZ  LYS F 103      41.619  26.142 -12.082  1.00 61.78           N  
ATOM  10200  N   PHE F 104      35.592  30.567 -10.500  1.00 51.95           N  
ATOM  10201  CA  PHE F 104      34.956  31.040 -11.742  1.00 50.04           C  
ATOM  10202  C   PHE F 104      33.847  32.090 -11.542  1.00 50.48           C  
ATOM  10203  O   PHE F 104      33.608  32.928 -12.420  1.00 78.39           O  
ATOM  10204  CB  PHE F 104      34.397  29.866 -12.593  1.00 73.52           C  
ATOM  10205  CG  PHE F 104      35.462  29.009 -13.277  1.00 73.34           C  
ATOM  10206  CD1 PHE F 104      36.625  29.572 -13.797  1.00 74.35           C  
ATOM  10207  CD2 PHE F 104      35.312  27.631 -13.367  1.00 71.78           C  
ATOM  10208  CE1 PHE F 104      37.629  28.770 -14.392  1.00 76.64           C  
ATOM  10209  CE2 PHE F 104      36.311  26.827 -13.959  1.00 74.05           C  
ATOM  10210  CZ  PHE F 104      37.467  27.398 -14.469  1.00 73.14           C  
ATOM  10211  N   GLY F 105      33.167  32.043 -10.402  1.00 34.50           N  
ATOM  10212  CA  GLY F 105      32.086  32.989 -10.150  1.00 37.05           C  
ATOM  10213  C   GLY F 105      30.742  32.426 -10.574  1.00 38.75           C  
ATOM  10214  O   GLY F 105      30.670  31.694 -11.558  1.00 73.48           O  
ATOM  10215  N   GLU F 106      29.670  32.818  -9.895  1.00 56.54           N  
ATOM  10216  CA  GLU F 106      28.335  32.303 -10.202  1.00 59.70           C  
ATOM  10217  C   GLU F 106      27.889  32.196 -11.667  1.00 61.22           C  
ATOM  10218  O   GLU F 106      27.080  31.321 -12.009  1.00 80.26           O  
ATOM  10219  CB  GLU F 106      27.280  33.066  -9.424  1.00 80.91           C  
ATOM  10220  CG  GLU F 106      25.963  32.333  -9.370  1.00 85.54           C  
ATOM  10221  CD  GLU F 106      25.349  32.363  -7.986  1.00 91.01           C  
ATOM  10222  OE1 GLU F 106      26.109  32.424  -6.990  1.00 92.95           O  
ATOM  10223  OE2 GLU F 106      24.106  32.330  -7.887  1.00 94.91           O  
ATOM  10224  N   GLU F 107      28.409  33.070 -12.531  1.00 68.81           N  
ATOM  10225  CA  GLU F 107      28.021  33.040 -13.927  1.00 66.71           C  
ATOM  10226  C   GLU F 107      28.907  32.266 -14.900  1.00 62.27           C  
ATOM  10227  O   GLU F 107      28.421  31.837 -15.946  1.00 82.27           O  
ATOM  10228  CB  GLU F 107      27.710  34.450 -14.445  1.00 93.42           C  
ATOM  10229  CG  GLU F 107      26.315  34.980 -14.031  1.00100.00           C  
ATOM  10230  CD  GLU F 107      25.143  34.284 -14.760  1.00100.00           C  
ATOM  10231  OE1 GLU F 107      24.659  33.233 -14.269  1.00100.00           O  
ATOM  10232  OE2 GLU F 107      24.691  34.801 -15.813  1.00100.00           O  
ATOM  10233  N   LYS F 108      30.193  32.097 -14.613  1.00 67.72           N  
ATOM  10234  CA  LYS F 108      31.024  31.309 -15.538  1.00 65.20           C  
ATOM  10235  C   LYS F 108      30.868  29.821 -15.223  1.00 63.57           C  
ATOM  10236  O   LYS F 108      30.979  28.966 -16.114  1.00 50.09           O  
ATOM  10237  CB  LYS F 108      32.501  31.681 -15.452  1.00 51.92           C  
ATOM  10238  CG  LYS F 108      33.363  30.896 -16.428  1.00 56.16           C  
ATOM  10239  CD  LYS F 108      34.773  31.443 -16.453  1.00 62.88           C  
ATOM  10240  CE  LYS F 108      35.563  30.915 -17.647  1.00 68.28           C  
ATOM  10241  NZ  LYS F 108      36.979  31.382 -17.638  1.00 72.88           N  
ATOM  10242  N   PHE F 109      30.645  29.551 -13.932  1.00 68.61           N  
ATOM  10243  CA  PHE F 109      30.453  28.214 -13.353  1.00 64.67           C  
ATOM  10244  C   PHE F 109      29.137  27.691 -13.880  1.00 66.66           C  
ATOM  10245  O   PHE F 109      29.048  26.534 -14.310  1.00 45.75           O  
ATOM  10246  CB  PHE F 109      30.435  28.319 -11.805  1.00 39.62           C  
ATOM  10247  CG  PHE F 109      29.901  27.086 -11.071  1.00 33.48           C  
ATOM  10248  CD1 PHE F 109      28.531  26.961 -10.777  1.00 34.23           C  
ATOM  10249  CD2 PHE F 109      30.776  26.091 -10.617  1.00 31.75           C  
ATOM  10250  CE1 PHE F 109      28.048  25.864 -10.046  1.00 33.79           C  
ATOM  10251  CE2 PHE F 109      30.297  24.984  -9.876  1.00 32.04           C  
ATOM  10252  CZ  PHE F 109      28.939  24.872  -9.592  1.00 35.04           C  
ATOM  10253  N   ASN F 110      28.115  28.540 -13.834  1.00 52.32           N  
ATOM  10254  CA  ASN F 110      26.826  28.146 -14.348  1.00 55.77           C  
ATOM  10255  C   ASN F 110      26.912  27.798 -15.870  1.00 55.90           C  
ATOM  10256  O   ASN F 110      26.230  26.876 -16.346  1.00 64.67           O  
ATOM  10257  CB  ASN F 110      25.788  29.220 -14.077  1.00 64.80           C  
ATOM  10258  CG  ASN F 110      24.497  28.941 -14.795  1.00 70.78           C  
ATOM  10259  OD1 ASN F 110      23.755  28.030 -14.429  1.00 75.39           O  
ATOM  10260  ND2 ASN F 110      24.265  29.657 -15.885  1.00 74.62           N  
ATOM  10261  N   THR F 111      27.759  28.505 -16.619  1.00 44.74           N  
ATOM  10262  CA  THR F 111      27.930  28.211 -18.037  1.00 44.12           C  
ATOM  10263  C   THR F 111      28.438  26.771 -18.186  1.00 43.98           C  
ATOM  10264  O   THR F 111      27.751  25.942 -18.785  1.00 46.44           O  
ATOM  10265  CB  THR F 111      28.922  29.201 -18.760  1.00 47.21           C  
ATOM  10266  OG1 THR F 111      28.227  30.404 -19.100  1.00 48.46           O  
ATOM  10267  CG2 THR F 111      29.490  28.605 -20.056  1.00 42.78           C  
ATOM  10268  N   TYR F 112      29.607  26.458 -17.622  1.00 58.84           N  
ATOM  10269  CA  TYR F 112      30.157  25.100 -17.740  1.00 58.59           C  
ATOM  10270  C   TYR F 112      29.191  24.022 -17.258  1.00 58.73           C  
ATOM  10271  O   TYR F 112      29.186  22.933 -17.797  1.00 43.58           O  
ATOM  10272  CB  TYR F 112      31.474  24.943 -16.982  1.00 44.38           C  
ATOM  10273  CG  TYR F 112      32.637  25.759 -17.500  1.00 40.80           C  
ATOM  10274  CD1 TYR F 112      32.672  26.232 -18.823  1.00 42.22           C  
ATOM  10275  CD2 TYR F 112      33.720  26.044 -16.670  1.00 41.48           C  
ATOM  10276  CE1 TYR F 112      33.779  26.974 -19.299  1.00 47.04           C  
ATOM  10277  CE2 TYR F 112      34.825  26.778 -17.127  1.00 45.54           C  
ATOM  10278  CZ  TYR F 112      34.852  27.239 -18.436  1.00 49.04           C  
ATOM  10279  OH  TYR F 112      35.960  27.941 -18.865  1.00 49.45           O  
ATOM  10280  N   ARG F 113      28.360  24.337 -16.270  1.00 54.35           N  
ATOM  10281  CA  ARG F 113      27.401  23.373 -15.740  1.00 53.91           C  
ATOM  10282  C   ARG F 113      26.071  23.237 -16.479  1.00 53.32           C  
ATOM  10283  O   ARG F 113      25.634  22.110 -16.755  1.00 40.21           O  
ATOM  10284  CB  ARG F 113      27.117  23.657 -14.264  1.00 46.74           C  
ATOM  10285  CG  ARG F 113      28.028  22.894 -13.296  1.00 50.17           C  
ATOM  10286  CD  ARG F 113      27.307  22.535 -11.987  1.00 54.81           C  
ATOM  10287  NE  ARG F 113      26.078  21.771 -12.206  1.00 65.64           N  
ATOM  10288  CZ  ARG F 113      24.843  22.268 -12.111  1.00 72.45           C  
ATOM  10289  NH1 ARG F 113      24.636  23.545 -11.808  1.00 74.08           N  
ATOM  10290  NH2 ARG F 113      23.802  21.468 -12.289  1.00 72.07           N  
ATOM  10291  N   ARG F 114      25.436  24.369 -16.804  1.00 39.86           N  
ATOM  10292  CA  ARG F 114      24.134  24.339 -17.471  1.00 40.83           C  
ATOM  10293  C   ARG F 114      23.907  25.054 -18.832  1.00 39.10           C  
ATOM  10294  O   ARG F 114      22.766  25.292 -19.241  1.00 46.29           O  
ATOM  10295  CB  ARG F 114      23.029  24.707 -16.466  1.00 52.55           C  
ATOM  10296  CG  ARG F 114      22.649  23.567 -15.481  1.00 63.06           C  
ATOM  10297  CD  ARG F 114      21.810  22.462 -16.160  1.00 72.35           C  
ATOM  10298  NE  ARG F 114      21.709  21.231 -15.369  1.00 83.78           N  
ATOM  10299  CZ  ARG F 114      22.601  20.241 -15.398  1.00 90.35           C  
ATOM  10300  NH1 ARG F 114      23.671  20.321 -16.180  1.00 91.73           N  
ATOM  10301  NH2 ARG F 114      22.438  19.169 -14.626  1.00 94.55           N  
ATOM  10302  N   SER F 115      24.974  25.372 -19.556  1.00 41.42           N  
ATOM  10303  CA  SER F 115      24.807  26.005 -20.863  1.00 35.94           C  
ATOM  10304  C   SER F 115      24.649  24.891 -21.888  1.00 39.58           C  
ATOM  10305  O   SER F 115      25.147  23.786 -21.684  1.00 37.22           O  
ATOM  10306  CB  SER F 115      26.008  26.873 -21.212  1.00 30.03           C  
ATOM  10307  OG  SER F 115      26.912  26.214 -22.060  1.00 26.83           O  
ATOM  10308  N   PHE F 116      23.961  25.177 -22.988  1.00 29.54           N  
ATOM  10309  CA  PHE F 116      23.755  24.160 -24.001  1.00 27.01           C  
ATOM  10310  C   PHE F 116      24.944  23.765 -24.848  1.00 26.02           C  
ATOM  10311  O   PHE F 116      25.250  22.579 -24.932  1.00 31.39           O  
ATOM  10312  CB  PHE F 116      22.603  24.516 -24.923  1.00 29.79           C  
ATOM  10313  CG  PHE F 116      22.236  23.416 -25.862  1.00 26.67           C  
ATOM  10314  CD1 PHE F 116      21.593  22.272 -25.388  1.00 23.31           C  
ATOM  10315  CD2 PHE F 116      22.518  23.513 -27.215  1.00 21.81           C  
ATOM  10316  CE1 PHE F 116      21.230  21.220 -26.257  1.00 17.44           C  
ATOM  10317  CE2 PHE F 116      22.163  22.473 -28.106  1.00 20.35           C  
ATOM  10318  CZ  PHE F 116      21.518  21.322 -27.632  1.00 18.12           C  
ATOM  10319  N   ASP F 117      25.663  24.753 -25.390  1.00 17.74           N  
ATOM  10320  CA  ASP F 117      26.775  24.507 -26.317  1.00 16.84           C  
ATOM  10321  C   ASP F 117      28.184  24.924 -25.991  1.00 19.47           C  
ATOM  10322  O   ASP F 117      29.060  24.788 -26.834  1.00 34.61           O  
ATOM  10323  CB  ASP F 117      26.426  25.084 -27.690  1.00 39.86           C  
ATOM  10324  CG  ASP F 117      25.740  26.454 -27.613  1.00 43.08           C  
ATOM  10325  OD1 ASP F 117      25.778  27.105 -26.551  1.00 43.59           O  
ATOM  10326  OD2 ASP F 117      25.144  26.862 -28.632  1.00 44.24           O  
ATOM  10327  N   VAL F 118      28.420  25.446 -24.797  1.00 19.23           N  
ATOM  10328  CA  VAL F 118      29.779  25.838 -24.449  1.00 18.90           C  
ATOM  10329  C   VAL F 118      30.322  24.784 -23.500  1.00 16.77           C  
ATOM  10330  O   VAL F 118      29.823  24.614 -22.389  1.00 22.67           O  
ATOM  10331  CB  VAL F 118      29.841  27.201 -23.740  1.00 24.93           C  
ATOM  10332  CG1 VAL F 118      31.292  27.651 -23.608  1.00 21.87           C  
ATOM  10333  CG2 VAL F 118      28.991  28.223 -24.472  1.00 22.67           C  
ATOM  10334  N   PRO F 119      31.322  24.031 -23.956  1.00 27.52           N  
ATOM  10335  CA  PRO F 119      31.934  22.982 -23.149  1.00 25.39           C  
ATOM  10336  C   PRO F 119      32.989  23.487 -22.191  1.00 27.73           C  
ATOM  10337  O   PRO F 119      33.428  24.625 -22.306  1.00 28.13           O  
ATOM  10338  CB  PRO F 119      32.556  22.072 -24.224  1.00 20.68           C  
ATOM  10339  CG  PRO F 119      32.956  23.072 -25.311  1.00 17.94           C  
ATOM  10340  CD  PRO F 119      31.710  23.902 -25.375  1.00 20.66           C  
ATOM  10341  N   PRO F 120      33.317  22.686 -21.158  1.00 24.80           N  
ATOM  10342  CA  PRO F 120      34.336  23.018 -20.158  1.00 24.16           C  
ATOM  10343  C   PRO F 120      35.694  22.956 -20.879  1.00 25.14           C  
ATOM  10344  O   PRO F 120      35.762  22.468 -22.001  1.00 23.24           O  
ATOM  10345  CB  PRO F 120      34.229  21.852 -19.167  1.00 19.85           C  
ATOM  10346  CG  PRO F 120      32.819  21.539 -19.172  1.00 20.50           C  
ATOM  10347  CD  PRO F 120      32.493  21.560 -20.668  1.00 21.90           C  
ATOM  10348  N   PRO F 121      36.771  23.499 -20.280  1.00 33.90           N  
ATOM  10349  CA  PRO F 121      38.051  23.399 -21.006  1.00 33.32           C  
ATOM  10350  C   PRO F 121      38.409  21.892 -21.062  1.00 33.73           C  
ATOM  10351  O   PRO F 121      37.990  21.137 -20.194  1.00 26.69           O  
ATOM  10352  CB  PRO F 121      39.022  24.180 -20.106  1.00 30.32           C  
ATOM  10353  CG  PRO F 121      38.092  25.133 -19.300  1.00 28.42           C  
ATOM  10354  CD  PRO F 121      36.920  24.249 -19.014  1.00 29.71           C  
ATOM  10355  N   PRO F 122      39.170  21.440 -22.072  1.00 28.11           N  
ATOM  10356  CA  PRO F 122      39.508  20.007 -22.137  1.00 28.85           C  
ATOM  10357  C   PRO F 122      40.461  19.568 -21.051  1.00 31.42           C  
ATOM  10358  O   PRO F 122      41.166  20.399 -20.476  1.00 31.28           O  
ATOM  10359  CB  PRO F 122      40.136  19.859 -23.525  1.00 27.46           C  
ATOM  10360  CG  PRO F 122      40.794  21.219 -23.732  1.00 27.19           C  
ATOM  10361  CD  PRO F 122      39.710  22.167 -23.237  1.00 26.98           C  
ATOM  10362  N   ILE F 123      40.467  18.264 -20.759  1.00 26.64           N  
ATOM  10363  CA  ILE F 123      41.354  17.738 -19.732  1.00 28.94           C  
ATOM  10364  C   ILE F 123      42.619  17.284 -20.430  1.00 33.68           C  
ATOM  10365  O   ILE F 123      42.548  16.853 -21.580  1.00 35.94           O  
ATOM  10366  CB  ILE F 123      40.675  16.607 -18.928  1.00 29.94           C  
ATOM  10367  CG1 ILE F 123      41.577  16.120 -17.808  1.00 27.75           C  
ATOM  10368  CG2 ILE F 123      40.328  15.445 -19.785  1.00 32.25           C  
ATOM  10369  CD1 ILE F 123      40.787  15.485 -16.682  1.00 28.69           C  
ATOM  10370  N   ASP F 124      43.780  17.509 -19.808  1.00 24.16           N  
ATOM  10371  CA  ASP F 124      45.040  17.092 -20.414  1.00 27.77           C  
ATOM  10372  C   ASP F 124      45.148  15.567 -20.346  1.00 28.36           C  
ATOM  10373  O   ASP F 124      44.748  14.954 -19.362  1.00 38.33           O  
ATOM  10374  CB  ASP F 124      46.264  17.750 -19.755  1.00 40.78           C  
ATOM  10375  CG  ASP F 124      47.601  17.123 -20.238  1.00 47.41           C  
ATOM  10376  OD1 ASP F 124      47.988  17.268 -21.424  1.00 52.63           O  
ATOM  10377  OD2 ASP F 124      48.260  16.435 -19.435  1.00 49.09           O  
ATOM  10378  N   ALA F 125      45.679  14.979 -21.415  1.00 47.51           N  
ATOM  10379  CA  ALA F 125      45.843  13.535 -21.543  1.00 47.78           C  
ATOM  10380  C   ALA F 125      46.451  12.845 -20.320  1.00 49.05           C  
ATOM  10381  O   ALA F 125      45.946  11.814 -19.870  1.00 58.00           O  
ATOM  10382  CB  ALA F 125      46.679  13.228 -22.784  1.00 56.46           C  
ATOM  10383  N   SER F 126      47.507  13.447 -19.776  1.00 39.70           N  
ATOM  10384  CA  SER F 126      48.229  12.918 -18.629  1.00 40.21           C  
ATOM  10385  C   SER F 126      47.644  13.273 -17.254  1.00 38.25           C  
ATOM  10386  O   SER F 126      48.300  13.089 -16.231  1.00 56.17           O  
ATOM  10387  CB  SER F 126      49.691  13.351 -18.698  1.00 57.72           C  
ATOM  10388  OG  SER F 126      49.819  14.668 -18.184  1.00 58.23           O  
ATOM  10389  N   SER F 127      46.443  13.838 -17.233  1.00 40.12           N  
ATOM  10390  CA  SER F 127      45.786  14.136 -15.974  1.00 36.23           C  
ATOM  10391  C   SER F 127      45.265  12.807 -15.415  1.00 37.08           C  
ATOM  10392  O   SER F 127      44.854  11.921 -16.168  1.00 38.63           O  
ATOM  10393  CB  SER F 127      44.591  15.068 -16.189  1.00 36.78           C  
ATOM  10394  OG  SER F 127      43.671  15.023 -15.095  1.00 37.09           O  
ATOM  10395  N   PRO F 128      45.297  12.639 -14.084  1.00 36.45           N  
ATOM  10396  CA  PRO F 128      44.809  11.409 -13.465  1.00 30.57           C  
ATOM  10397  C   PRO F 128      43.361  11.169 -13.810  1.00 28.31           C  
ATOM  10398  O   PRO F 128      42.902  10.048 -13.755  1.00 28.46           O  
ATOM  10399  CB  PRO F 128      44.936  11.723 -11.971  1.00 28.46           C  
ATOM  10400  CG  PRO F 128      46.144  12.531 -11.928  1.00 32.54           C  
ATOM  10401  CD  PRO F 128      45.965  13.486 -13.080  1.00 36.53           C  
ATOM  10402  N   PHE F 129      42.641  12.232 -14.160  1.00 15.16           N  
ATOM  10403  CA  PHE F 129      41.204  12.145 -14.456  1.00 13.83           C  
ATOM  10404  C   PHE F 129      40.799  12.141 -15.938  1.00 13.41           C  
ATOM  10405  O   PHE F 129      39.645  12.429 -16.282  1.00 15.90           O  
ATOM  10406  CB  PHE F 129      40.423  13.249 -13.710  1.00 22.23           C  
ATOM  10407  CG  PHE F 129      40.818  13.395 -12.265  1.00 30.47           C  
ATOM  10408  CD1 PHE F 129      40.601  12.356 -11.364  1.00 32.60           C  
ATOM  10409  CD2 PHE F 129      41.506  14.529 -11.833  1.00 34.01           C  
ATOM  10410  CE1 PHE F 129      41.077  12.439 -10.071  1.00 34.50           C  
ATOM  10411  CE2 PHE F 129      41.984  14.612 -10.538  1.00 36.95           C  
ATOM  10412  CZ  PHE F 129      41.769  13.566  -9.663  1.00 34.69           C  
ATOM  10413  N   SER F 130      41.771  11.843 -16.786  1.00 20.55           N  
ATOM  10414  CA  SER F 130      41.549  11.717 -18.224  1.00 24.36           C  
ATOM  10415  C   SER F 130      41.200  10.262 -18.528  1.00 23.30           C  
ATOM  10416  O   SER F 130      41.784   9.345 -17.926  1.00 23.00           O  
ATOM  10417  CB  SER F 130      42.846  12.057 -18.972  1.00 26.21           C  
ATOM  10418  OG  SER F 130      42.763  11.713 -20.340  1.00 22.33           O  
ATOM  10419  N   GLN F 131      40.258  10.034 -19.442  1.00 15.22           N  
ATOM  10420  CA  GLN F 131      39.935   8.652 -19.841  1.00 15.08           C  
ATOM  10421  C   GLN F 131      40.643   8.301 -21.160  1.00 17.35           C  
ATOM  10422  O   GLN F 131      40.266   7.347 -21.826  1.00 19.66           O  
ATOM  10423  CB  GLN F 131      38.440   8.452 -20.014  1.00 15.51           C  
ATOM  10424  CG  GLN F 131      37.678   8.503 -18.735  1.00 15.29           C  
ATOM  10425  CD  GLN F 131      37.841   9.838 -18.056  1.00 15.08           C  
ATOM  10426  OE1 GLN F 131      37.586  10.854 -18.656  1.00 14.35           O  
ATOM  10427  NE2 GLN F 131      38.390   9.833 -16.843  1.00 12.37           N  
ATOM  10428  N   LYS F 132      41.662   9.065 -21.540  1.00 21.46           N  
ATOM  10429  CA  LYS F 132      42.358   8.810 -22.792  1.00 23.63           C  
ATOM  10430  C   LYS F 132      43.173   7.507 -22.788  1.00 22.91           C  
ATOM  10431  O   LYS F 132      44.113   7.356 -22.005  1.00 31.80           O  
ATOM  10432  CB  LYS F 132      43.249  10.006 -23.137  1.00 30.92           C  
ATOM  10433  CG  LYS F 132      43.477  10.226 -24.632  1.00 40.37           C  
ATOM  10434  CD  LYS F 132      44.796   9.654 -25.123  1.00 44.42           C  
ATOM  10435  CE  LYS F 132      44.995   9.932 -26.630  1.00 47.41           C  
ATOM  10436  NZ  LYS F 132      43.942   9.317 -27.536  1.00 46.31           N  
ATOM  10437  N   GLY F 133      42.840   6.574 -23.677  1.00 15.23           N  
ATOM  10438  CA  GLY F 133      43.621   5.340 -23.702  1.00 12.90           C  
ATOM  10439  C   GLY F 133      43.060   4.228 -22.817  1.00 13.67           C  
ATOM  10440  O   GLY F 133      43.688   3.162 -22.690  1.00 14.51           O  
ATOM  10441  N   ASP F 134      41.881   4.466 -22.221  1.00 24.49           N  
ATOM  10442  CA  ASP F 134      41.244   3.473 -21.359  1.00 27.61           C  
ATOM  10443  C   ASP F 134      40.753   2.261 -22.169  1.00 25.34           C  
ATOM  10444  O   ASP F 134      40.178   2.380 -23.275  1.00  7.16           O  
ATOM  10445  CB  ASP F 134      40.108   4.081 -20.528  1.00 20.48           C  
ATOM  10446  CG  ASP F 134      40.624   4.917 -19.276  1.00 38.44           C  
ATOM  10447  OD1 ASP F 134      41.848   5.198 -19.078  1.00 41.45           O  
ATOM  10448  OD2 ASP F 134      39.760   5.309 -18.466  1.00 45.71           O  
ATOM  10449  N   GLU F 135      40.971   1.094 -21.580  1.00 15.73           N  
ATOM  10450  CA  GLU F 135      40.663  -0.192 -22.172  1.00 15.93           C  
ATOM  10451  C   GLU F 135      39.230  -0.358 -22.608  1.00 13.00           C  
ATOM  10452  O   GLU F 135      38.943  -1.017 -23.606  1.00 16.21           O  
ATOM  10453  CB  GLU F 135      41.043  -1.285 -21.167  1.00 16.55           C  
ATOM  10454  CG  GLU F 135      41.209  -2.713 -21.720  1.00 21.78           C  
ATOM  10455  CD  GLU F 135      41.053  -3.792 -20.635  1.00 25.33           C  
ATOM  10456  OE1 GLU F 135      41.146  -3.440 -19.450  1.00 25.22           O  
ATOM  10457  OE2 GLU F 135      40.822  -4.974 -20.969  1.00 33.03           O  
ATOM  10458  N   ARG F 136      38.302   0.237 -21.901  1.00  8.41           N  
ATOM  10459  CA  ARG F 136      36.918   0.027 -22.321  1.00  7.73           C  
ATOM  10460  C   ARG F 136      36.533   0.770 -23.587  1.00 11.16           C  
ATOM  10461  O   ARG F 136      35.407   0.630 -24.052  1.00 13.81           O  
ATOM  10462  CB  ARG F 136      35.927   0.373 -21.205  1.00 10.01           C  
ATOM  10463  CG  ARG F 136      35.671   1.848 -20.926  1.00 13.34           C  
ATOM  10464  CD  ARG F 136      34.944   1.992 -19.608  1.00 10.51           C  
ATOM  10465  NE  ARG F 136      35.909   1.840 -18.517  1.00 12.47           N  
ATOM  10466  CZ  ARG F 136      35.571   1.649 -17.242  1.00 11.83           C  
ATOM  10467  NH1 ARG F 136      34.283   1.623 -16.872  1.00  8.68           N  
ATOM  10468  NH2 ARG F 136      36.515   1.295 -16.382  1.00  9.99           N  
ATOM  10469  N   TYR F 137      37.445   1.590 -24.105  1.00 18.30           N  
ATOM  10470  CA  TYR F 137      37.168   2.364 -25.310  1.00 18.41           C  
ATOM  10471  C   TYR F 137      38.205   2.049 -26.405  1.00 19.60           C  
ATOM  10472  O   TYR F 137      38.245   2.758 -27.406  1.00 15.41           O  
ATOM  10473  CB  TYR F 137      37.166   3.886 -25.030  1.00  8.12           C  
ATOM  10474  CG  TYR F 137      36.283   4.378 -23.884  1.00  7.09           C  
ATOM  10475  CD1 TYR F 137      34.896   4.210 -23.924  1.00 10.19           C  
ATOM  10476  CD2 TYR F 137      36.857   4.951 -22.720  1.00  8.81           C  
ATOM  10477  CE1 TYR F 137      34.075   4.582 -22.830  1.00 11.87           C  
ATOM  10478  CE2 TYR F 137      36.044   5.328 -21.616  1.00  7.28           C  
ATOM  10479  CZ  TYR F 137      34.667   5.140 -21.690  1.00 11.83           C  
ATOM  10480  OH  TYR F 137      33.840   5.532 -20.673  1.00 13.11           O  
ATOM  10481  N   LYS F 138      38.994   0.978 -26.233  1.00 13.53           N  
ATOM  10482  CA  LYS F 138      40.045   0.592 -27.182  1.00 14.02           C  
ATOM  10483  C   LYS F 138      39.591   0.158 -28.596  1.00 16.31           C  
ATOM  10484  O   LYS F 138      40.420   0.086 -29.511  1.00 15.32           O  
ATOM  10485  CB  LYS F 138      40.994  -0.476 -26.590  1.00 18.20           C  
ATOM  10486  CG  LYS F 138      40.392  -1.901 -26.406  1.00 20.76           C  
ATOM  10487  CD  LYS F 138      41.517  -2.858 -26.005  1.00 22.76           C  
ATOM  10488  CE  LYS F 138      41.148  -4.359 -26.177  1.00 29.44           C  
ATOM  10489  NZ  LYS F 138      42.335  -5.188 -26.710  1.00 35.85           N  
ATOM  10490  N   TYR F 139      38.298  -0.124 -28.755  1.00 20.01           N  
ATOM  10491  CA  TYR F 139      37.767  -0.549 -30.059  1.00 20.89           C  
ATOM  10492  C   TYR F 139      36.935   0.567 -30.739  1.00 23.06           C  
ATOM  10493  O   TYR F 139      36.229   0.320 -31.726  1.00 12.82           O  
ATOM  10494  CB  TYR F 139      36.951  -1.851 -29.920  1.00 16.77           C  
ATOM  10495  CG  TYR F 139      37.774  -3.104 -29.597  1.00 19.41           C  
ATOM  10496  CD1 TYR F 139      38.913  -3.433 -30.342  1.00 19.15           C  
ATOM  10497  CD2 TYR F 139      37.413  -3.957 -28.543  1.00 23.33           C  
ATOM  10498  CE1 TYR F 139      39.670  -4.569 -30.061  1.00 26.58           C  
ATOM  10499  CE2 TYR F 139      38.169  -5.109 -28.249  1.00 25.29           C  
ATOM  10500  CZ  TYR F 139      39.296  -5.404 -29.016  1.00 30.56           C  
ATOM  10501  OH  TYR F 139      40.025  -6.549 -28.778  1.00 34.52           O  
ATOM  10502  N   VAL F 140      36.939   1.756 -30.128  1.00 14.88           N  
ATOM  10503  CA  VAL F 140      36.242   2.923 -30.656  1.00 15.08           C  
ATOM  10504  C   VAL F 140      37.308   3.746 -31.404  1.00 14.10           C  
ATOM  10505  O   VAL F 140      38.491   3.664 -31.097  1.00 12.77           O  
ATOM  10506  CB  VAL F 140      35.613   3.777 -29.528  1.00 13.66           C  
ATOM  10507  CG1 VAL F 140      34.872   5.012 -30.135  1.00 10.08           C  
ATOM  10508  CG2 VAL F 140      34.629   2.948 -28.728  1.00 12.82           C  
ATOM  10509  N   ASP F 141      36.910   4.456 -32.452  1.00 10.64           N  
ATOM  10510  CA  ASP F 141      37.857   5.274 -33.198  1.00  9.93           C  
ATOM  10511  C   ASP F 141      38.417   6.252 -32.159  1.00 12.85           C  
ATOM  10512  O   ASP F 141      37.674   6.992 -31.521  1.00 11.13           O  
ATOM  10513  CB  ASP F 141      37.074   6.012 -34.303  1.00  8.01           C  
ATOM  10514  CG  ASP F 141      37.862   7.119 -34.960  1.00 10.49           C  
ATOM  10515  OD1 ASP F 141      39.106   7.205 -34.899  1.00 12.69           O  
ATOM  10516  OD2 ASP F 141      37.202   7.952 -35.554  1.00 15.91           O  
ATOM  10517  N   PRO F 142      39.731   6.239 -31.949  1.00 16.27           N  
ATOM  10518  CA  PRO F 142      40.309   7.152 -30.969  1.00 14.19           C  
ATOM  10519  C   PRO F 142      39.958   8.621 -31.193  1.00 17.32           C  
ATOM  10520  O   PRO F 142      39.903   9.388 -30.244  1.00 15.86           O  
ATOM  10521  CB  PRO F 142      41.811   6.974 -31.171  1.00 10.54           C  
ATOM  10522  CG  PRO F 142      41.936   5.566 -31.692  1.00  5.97           C  
ATOM  10523  CD  PRO F 142      40.773   5.450 -32.634  1.00 12.02           C  
ATOM  10524  N   ASN F 143      39.734   9.004 -32.457  1.00 18.98           N  
ATOM  10525  CA  ASN F 143      39.501  10.412 -32.811  1.00 19.88           C  
ATOM  10526  C   ASN F 143      38.195  11.023 -32.353  1.00 19.18           C  
ATOM  10527  O   ASN F 143      38.136  12.224 -32.145  1.00 18.71           O  
ATOM  10528  CB  ASN F 143      39.647  10.619 -34.330  1.00 22.25           C  
ATOM  10529  CG  ASN F 143      40.968  10.126 -34.858  1.00 24.26           C  
ATOM  10530  OD1 ASN F 143      41.969  10.828 -34.770  1.00 25.29           O  
ATOM  10531  ND2 ASN F 143      40.992   8.887 -35.385  1.00 18.46           N  
ATOM  10532  N   VAL F 144      37.165  10.190 -32.196  1.00  9.88           N  
ATOM  10533  CA  VAL F 144      35.855  10.676 -31.792  1.00  7.70           C  
ATOM  10534  C   VAL F 144      35.677  10.834 -30.292  1.00 10.00           C  
ATOM  10535  O   VAL F 144      34.760  11.536 -29.834  1.00 16.29           O  
ATOM  10536  CB  VAL F 144      34.770   9.755 -32.269  1.00 12.31           C  
ATOM  10537  CG1 VAL F 144      34.812   8.453 -31.537  1.00  8.57           C  
ATOM  10538  CG2 VAL F 144      33.456  10.360 -32.046  1.00 13.37           C  
ATOM  10539  N   LEU F 145      36.513  10.133 -29.537  1.00 15.43           N  
ATOM  10540  CA  LEU F 145      36.420  10.151 -28.082  1.00 14.84           C  
ATOM  10541  C   LEU F 145      36.737  11.559 -27.555  1.00 13.53           C  
ATOM  10542  O   LEU F 145      37.857  12.041 -27.683  1.00 12.42           O  
ATOM  10543  CB  LEU F 145      37.333   9.064 -27.510  1.00  9.96           C  
ATOM  10544  CG  LEU F 145      36.864   7.658 -27.125  1.00 11.15           C  
ATOM  10545  CD1 LEU F 145      35.461   7.332 -27.438  1.00  5.22           C  
ATOM  10546  CD2 LEU F 145      37.864   6.664 -27.640  1.00  3.95           C  
ATOM  10547  N   PRO F 146      35.786  12.162 -26.837  1.00 14.19           N  
ATOM  10548  CA  PRO F 146      35.888  13.513 -26.278  1.00 16.61           C  
ATOM  10549  C   PRO F 146      36.806  13.756 -25.105  1.00 16.42           C  
ATOM  10550  O   PRO F 146      36.939  12.893 -24.265  1.00 22.25           O  
ATOM  10551  CB  PRO F 146      34.451  13.803 -25.894  1.00 19.06           C  
ATOM  10552  CG  PRO F 146      34.009  12.495 -25.351  1.00 16.87           C  
ATOM  10553  CD  PRO F 146      34.526  11.526 -26.402  1.00 13.58           C  
ATOM  10554  N   GLU F 147      37.397  14.958 -25.037  1.00 10.70           N  
ATOM  10555  CA  GLU F 147      38.265  15.368 -23.938  1.00 12.01           C  
ATOM  10556  C   GLU F 147      37.599  16.459 -23.105  1.00 13.65           C  
ATOM  10557  O   GLU F 147      38.145  16.974 -22.132  1.00 20.40           O  
ATOM  10558  CB  GLU F 147      39.631  15.729 -24.440  1.00 24.80           C  
ATOM  10559  CG  GLU F 147      40.310  14.460 -24.842  1.00 42.96           C  
ATOM  10560  CD  GLU F 147      41.772  14.645 -25.173  1.00 55.40           C  
ATOM  10561  OE1 GLU F 147      42.067  14.988 -26.352  1.00 59.82           O  
ATOM  10562  OE2 GLU F 147      42.631  14.431 -24.272  1.00 60.68           O  
ATOM  10563  N   THR F 148      36.344  16.691 -23.469  1.00 12.44           N  
ATOM  10564  CA  THR F 148      35.414  17.590 -22.841  1.00  9.12           C  
ATOM  10565  C   THR F 148      34.119  17.604 -23.659  1.00  8.22           C  
ATOM  10566  O   THR F 148      34.125  17.301 -24.848  1.00 22.23           O  
ATOM  10567  CB  THR F 148      35.956  19.024 -22.689  1.00 22.19           C  
ATOM  10568  OG1 THR F 148      34.896  19.816 -22.155  1.00 21.73           O  
ATOM  10569  CG2 THR F 148      36.420  19.626 -24.018  1.00 20.69           C  
ATOM  10570  N   GLU F 149      32.999  17.932 -23.045  1.00  9.32           N  
ATOM  10571  CA  GLU F 149      31.757  17.986 -23.807  1.00  9.82           C  
ATOM  10572  C   GLU F 149      30.737  18.940 -23.248  1.00 12.26           C  
ATOM  10573  O   GLU F 149      30.704  19.216 -22.053  1.00 19.84           O  
ATOM  10574  CB  GLU F 149      31.048  16.620 -23.831  1.00 19.47           C  
ATOM  10575  CG  GLU F 149      31.650  15.484 -24.691  1.00 18.28           C  
ATOM  10576  CD  GLU F 149      30.806  14.241 -24.576  1.00 23.71           C  
ATOM  10577  OE1 GLU F 149      30.451  13.881 -23.432  1.00 15.91           O  
ATOM  10578  OE2 GLU F 149      30.430  13.659 -25.623  1.00 19.86           O  
ATOM  10579  N   SER F 150      29.811  19.323 -24.118  1.00 14.73           N  
ATOM  10580  CA  SER F 150      28.679  20.176 -23.776  1.00 16.46           C  
ATOM  10581  C   SER F 150      27.492  19.244 -23.974  1.00 14.35           C  
ATOM  10582  O   SER F 150      27.651  18.148 -24.518  1.00 27.06           O  
ATOM  10583  CB  SER F 150      28.573  21.360 -24.746  1.00 21.65           C  
ATOM  10584  OG  SER F 150      28.334  20.928 -26.072  1.00 23.93           O  
ATOM  10585  N   LEU F 151      26.306  19.649 -23.543  1.00 18.73           N  
ATOM  10586  CA  LEU F 151      25.138  18.793 -23.713  1.00 20.07           C  
ATOM  10587  C   LEU F 151      24.843  18.651 -25.215  1.00 23.05           C  
ATOM  10588  O   LEU F 151      24.334  17.628 -25.687  1.00 21.69           O  
ATOM  10589  CB  LEU F 151      23.932  19.422 -23.028  1.00 15.95           C  
ATOM  10590  CG  LEU F 151      22.729  18.629 -22.513  1.00 22.02           C  
ATOM  10591  CD1 LEU F 151      21.517  19.457 -22.741  1.00 18.40           C  
ATOM  10592  CD2 LEU F 151      22.552  17.248 -23.107  1.00 16.75           C  
ATOM  10593  N   ALA F 152      25.099  19.725 -25.956  1.00 23.59           N  
ATOM  10594  CA  ALA F 152      24.860  19.760 -27.399  1.00 22.33           C  
ATOM  10595  C   ALA F 152      25.662  18.638 -28.068  1.00 21.67           C  
ATOM  10596  O   ALA F 152      25.132  17.876 -28.863  1.00 11.64           O  
ATOM  10597  CB  ALA F 152      25.255  21.138 -27.962  1.00  9.47           C  
ATOM  10598  N   LEU F 153      26.919  18.536 -27.671  1.00 15.25           N  
ATOM  10599  CA  LEU F 153      27.852  17.534 -28.147  1.00 16.56           C  
ATOM  10600  C   LEU F 153      27.459  16.095 -27.677  1.00 20.56           C  
ATOM  10601  O   LEU F 153      27.603  15.133 -28.436  1.00 14.53           O  
ATOM  10602  CB  LEU F 153      29.213  17.935 -27.633  1.00 12.05           C  
ATOM  10603  CG  LEU F 153      30.342  18.342 -28.572  1.00 18.43           C  
ATOM  10604  CD1 LEU F 153      29.824  18.781 -29.906  1.00 18.93           C  
ATOM  10605  CD2 LEU F 153      31.191  19.375 -27.929  1.00 10.01           C  
ATOM  10606  N   VAL F 154      26.952  15.951 -26.446  1.00 18.96           N  
ATOM  10607  CA  VAL F 154      26.519  14.648 -25.915  1.00 16.89           C  
ATOM  10608  C   VAL F 154      25.435  14.126 -26.817  1.00 19.89           C  
ATOM  10609  O   VAL F 154      25.481  13.001 -27.264  1.00 18.06           O  
ATOM  10610  CB  VAL F 154      25.957  14.751 -24.463  1.00 15.81           C  
ATOM  10611  CG1 VAL F 154      25.046  13.561 -24.088  1.00 10.36           C  
ATOM  10612  CG2 VAL F 154      27.108  14.815 -23.490  1.00  8.89           C  
ATOM  10613  N   ILE F 155      24.458  14.969 -27.088  1.00 22.92           N  
ATOM  10614  CA  ILE F 155      23.329  14.621 -27.931  1.00 25.45           C  
ATOM  10615  C   ILE F 155      23.816  14.211 -29.330  1.00 26.03           C  
ATOM  10616  O   ILE F 155      23.301  13.255 -29.905  1.00 21.11           O  
ATOM  10617  CB  ILE F 155      22.356  15.834 -28.037  1.00 20.29           C  
ATOM  10618  CG1 ILE F 155      21.866  16.230 -26.630  1.00 22.33           C  
ATOM  10619  CG2 ILE F 155      21.162  15.496 -28.959  1.00 19.57           C  
ATOM  10620  CD1 ILE F 155      20.834  17.284 -26.624  1.00 15.52           C  
ATOM  10621  N   ASP F 156      24.838  14.902 -29.843  1.00 20.72           N  
ATOM  10622  CA  ASP F 156      25.376  14.598 -31.169  1.00 22.05           C  
ATOM  10623  C   ASP F 156      25.996  13.178 -31.247  1.00 19.72           C  
ATOM  10624  O   ASP F 156      25.856  12.499 -32.282  1.00 11.84           O  
ATOM  10625  CB  ASP F 156      26.429  15.634 -31.627  1.00 12.26           C  
ATOM  10626  CG  ASP F 156      25.831  16.974 -32.113  1.00 20.06           C  
ATOM  10627  OD1 ASP F 156      24.593  17.158 -32.280  1.00 21.72           O  
ATOM  10628  OD2 ASP F 156      26.669  17.873 -32.336  1.00 22.65           O  
ATOM  10629  N   ARG F 157      26.670  12.723 -30.189  1.00 13.07           N  
ATOM  10630  CA  ARG F 157      27.276  11.395 -30.222  1.00 12.77           C  
ATOM  10631  C   ARG F 157      26.330  10.301 -29.745  1.00 12.37           C  
ATOM  10632  O   ARG F 157      26.495   9.143 -30.108  1.00 12.29           O  
ATOM  10633  CB  ARG F 157      28.648  11.359 -29.585  1.00  8.52           C  
ATOM  10634  CG  ARG F 157      28.773  11.916 -28.195  1.00 15.92           C  
ATOM  10635  CD  ARG F 157      28.161  11.017 -27.115  1.00 16.24           C  
ATOM  10636  NE  ARG F 157      28.714  11.420 -25.844  1.00 16.55           N  
ATOM  10637  CZ  ARG F 157      28.266  11.073 -24.642  1.00 13.67           C  
ATOM  10638  NH1 ARG F 157      27.200  10.285 -24.496  1.00  8.49           N  
ATOM  10639  NH2 ARG F 157      28.903  11.518 -23.587  1.00  9.50           N  
ATOM  10640  N   LEU F 158      25.256  10.708 -29.077  1.00 12.22           N  
ATOM  10641  CA  LEU F 158      24.253   9.788 -28.592  1.00 12.12           C  
ATOM  10642  C   LEU F 158      23.258   9.413 -29.664  1.00 13.77           C  
ATOM  10643  O   LEU F 158      22.908   8.244 -29.816  1.00 13.53           O  
ATOM  10644  CB  LEU F 158      23.448  10.414 -27.441  1.00  9.72           C  
ATOM  10645  CG  LEU F 158      22.440   9.497 -26.725  1.00 14.65           C  
ATOM  10646  CD1 LEU F 158      22.445   9.735 -25.226  1.00 18.99           C  
ATOM  10647  CD2 LEU F 158      21.072   9.719 -27.221  1.00 15.14           C  
ATOM  10648  N   LEU F 159      22.734  10.414 -30.370  1.00 12.15           N  
ATOM  10649  CA  LEU F 159      21.708  10.137 -31.384  1.00 15.17           C  
ATOM  10650  C   LEU F 159      21.927   8.968 -32.381  1.00 12.71           C  
ATOM  10651  O   LEU F 159      20.982   8.284 -32.695  1.00 17.12           O  
ATOM  10652  CB  LEU F 159      21.285  11.431 -32.116  1.00 16.96           C  
ATOM  10653  CG  LEU F 159      20.498  12.396 -31.243  1.00 13.89           C  
ATOM  10654  CD1 LEU F 159      20.212  13.662 -32.023  1.00 14.74           C  
ATOM  10655  CD2 LEU F 159      19.205  11.748 -30.850  1.00 12.38           C  
ATOM  10656  N   PRO F 160      23.124   8.811 -32.958  1.00 13.02           N  
ATOM  10657  CA  PRO F 160      23.364   7.704 -33.901  1.00 14.34           C  
ATOM  10658  C   PRO F 160      23.066   6.312 -33.291  1.00 14.36           C  
ATOM  10659  O   PRO F 160      22.485   5.451 -33.961  1.00 12.90           O  
ATOM  10660  CB  PRO F 160      24.847   7.826 -34.190  1.00 10.87           C  
ATOM  10661  CG  PRO F 160      25.073   9.249 -34.140  1.00 10.49           C  
ATOM  10662  CD  PRO F 160      24.277   9.724 -32.956  1.00 10.05           C  
ATOM  10663  N   TYR F 161      23.434   6.120 -32.015  1.00 10.74           N  
ATOM  10664  CA  TYR F 161      23.211   4.861 -31.330  1.00  7.28           C  
ATOM  10665  C   TYR F 161      21.732   4.621 -31.136  1.00  8.35           C  
ATOM  10666  O   TYR F 161      21.223   3.506 -31.280  1.00 17.00           O  
ATOM  10667  CB  TYR F 161      23.976   4.875 -29.991  1.00 10.33           C  
ATOM  10668  CG  TYR F 161      24.070   3.533 -29.318  1.00 14.22           C  
ATOM  10669  CD1 TYR F 161      24.972   2.558 -29.756  1.00 11.74           C  
ATOM  10670  CD2 TYR F 161      23.231   3.220 -28.269  1.00 12.13           C  
ATOM  10671  CE1 TYR F 161      25.010   1.307 -29.132  1.00 13.46           C  
ATOM  10672  CE2 TYR F 161      23.255   2.000 -27.666  1.00 13.95           C  
ATOM  10673  CZ  TYR F 161      24.144   1.044 -28.086  1.00 14.75           C  
ATOM  10674  OH  TYR F 161      24.184  -0.156 -27.409  1.00 18.59           O  
ATOM  10675  N   TRP F 162      21.034   5.695 -30.808  1.00  8.39           N  
ATOM  10676  CA  TRP F 162      19.605   5.646 -30.599  1.00  6.59           C  
ATOM  10677  C   TRP F 162      18.928   5.324 -31.945  1.00  9.74           C  
ATOM  10678  O   TRP F 162      18.002   4.518 -32.033  1.00 14.58           O  
ATOM  10679  CB  TRP F 162      19.126   7.049 -30.057  1.00 10.56           C  
ATOM  10680  CG  TRP F 162      17.630   7.319 -30.179  1.00 13.11           C  
ATOM  10681  CD1 TRP F 162      17.005   8.042 -31.177  1.00 10.85           C  
ATOM  10682  CD2 TRP F 162      16.570   6.775 -29.368  1.00 10.66           C  
ATOM  10683  NE1 TRP F 162      15.650   7.945 -31.054  1.00 12.80           N  
ATOM  10684  CE2 TRP F 162      15.350   7.191 -29.946  1.00 12.49           C  
ATOM  10685  CE3 TRP F 162      16.537   5.989 -28.215  1.00  8.56           C  
ATOM  10686  CZ2 TRP F 162      14.106   6.850 -29.408  1.00 13.32           C  
ATOM  10687  CZ3 TRP F 162      15.290   5.641 -27.670  1.00  9.32           C  
ATOM  10688  CH2 TRP F 162      14.091   6.076 -28.274  1.00 12.04           C  
ATOM  10689  N   GLN F 163      19.392   5.996 -32.987  1.00 11.94           N  
ATOM  10690  CA  GLN F 163      18.793   5.883 -34.310  1.00 12.09           C  
ATOM  10691  C   GLN F 163      18.866   4.511 -34.943  1.00 12.44           C  
ATOM  10692  O   GLN F 163      17.877   4.033 -35.532  1.00 18.83           O  
ATOM  10693  CB  GLN F 163      19.407   6.969 -35.249  1.00 12.75           C  
ATOM  10694  CG  GLN F 163      18.891   8.408 -35.001  1.00 14.76           C  
ATOM  10695  CD  GLN F 163      19.834   9.534 -35.484  1.00 13.86           C  
ATOM  10696  OE1 GLN F 163      21.002   9.305 -35.804  1.00 13.07           O  
ATOM  10697  NE2 GLN F 163      19.330  10.761 -35.476  1.00 14.17           N  
ATOM  10698  N   ASP F 164      20.021   3.879 -34.805  1.00 16.28           N  
ATOM  10699  CA  ASP F 164      20.258   2.563 -35.410  1.00 14.97           C  
ATOM  10700  C   ASP F 164      20.113   1.388 -34.455  1.00 14.70           C  
ATOM  10701  O   ASP F 164      19.481   0.397 -34.793  1.00 19.09           O  
ATOM  10702  CB  ASP F 164      21.674   2.474 -35.985  1.00  8.64           C  
ATOM  10703  CG  ASP F 164      21.893   3.361 -37.196  1.00  9.32           C  
ATOM  10704  OD1 ASP F 164      20.960   4.101 -37.626  1.00 11.97           O  
ATOM  10705  OD2 ASP F 164      23.031   3.302 -37.722  1.00 12.91           O  
ATOM  10706  N   VAL F 165      20.762   1.476 -33.296  1.00 12.84           N  
ATOM  10707  CA  VAL F 165      20.738   0.371 -32.373  1.00 10.40           C  
ATOM  10708  C   VAL F 165      19.524   0.254 -31.499  1.00 10.25           C  
ATOM  10709  O   VAL F 165      18.788  -0.715 -31.603  1.00 11.77           O  
ATOM  10710  CB  VAL F 165      22.050   0.301 -31.579  1.00 13.35           C  
ATOM  10711  CG1 VAL F 165      22.088  -0.941 -30.691  1.00 11.68           C  
ATOM  10712  CG2 VAL F 165      23.257   0.353 -32.553  1.00  3.27           C  
ATOM  10713  N   ILE F 166      19.248   1.265 -30.684  1.00  7.83           N  
ATOM  10714  CA  ILE F 166      18.111   1.210 -29.791  1.00  8.84           C  
ATOM  10715  C   ILE F 166      16.799   1.195 -30.525  1.00 11.13           C  
ATOM  10716  O   ILE F 166      15.876   0.484 -30.135  1.00 13.38           O  
ATOM  10717  CB  ILE F 166      18.188   2.400 -28.743  1.00 11.44           C  
ATOM  10718  CG1 ILE F 166      19.505   2.310 -27.981  1.00  9.61           C  
ATOM  10719  CG2 ILE F 166      16.994   2.373 -27.786  1.00  9.14           C  
ATOM  10720  CD1 ILE F 166      19.724   3.428 -26.968  1.00  7.40           C  
ATOM  10721  N   ALA F 167      16.707   1.990 -31.592  1.00 15.74           N  
ATOM  10722  CA  ALA F 167      15.480   2.051 -32.419  1.00 16.39           C  
ATOM  10723  C   ALA F 167      15.061   0.674 -32.964  1.00 15.85           C  
ATOM  10724  O   ALA F 167      13.875   0.343 -33.037  1.00 11.78           O  
ATOM  10725  CB  ALA F 167      15.684   2.989 -33.579  1.00 13.79           C  
ATOM  10726  N   LYS F 168      16.044  -0.125 -33.346  1.00  7.67           N  
ATOM  10727  CA  LYS F 168      15.761  -1.452 -33.897  1.00 12.99           C  
ATOM  10728  C   LYS F 168      14.978  -2.286 -32.932  1.00 12.71           C  
ATOM  10729  O   LYS F 168      13.983  -2.865 -33.346  1.00 14.46           O  
ATOM  10730  CB  LYS F 168      17.049  -2.190 -34.320  1.00 16.54           C  
ATOM  10731  CG  LYS F 168      16.794  -3.541 -35.009  1.00 19.79           C  
ATOM  10732  CD  LYS F 168      18.098  -4.194 -35.542  1.00 25.74           C  
ATOM  10733  CE  LYS F 168      17.876  -5.708 -35.889  1.00 33.80           C  
ATOM  10734  NZ  LYS F 168      19.057  -6.424 -36.457  1.00 43.75           N  
ATOM  10735  N   ASP F 169      15.403  -2.327 -31.652  1.00 13.62           N  
ATOM  10736  CA  ASP F 169      14.686  -3.104 -30.598  1.00 13.70           C  
ATOM  10737  C   ASP F 169      13.281  -2.560 -30.345  1.00 14.14           C  
ATOM  10738  O   ASP F 169      12.347  -3.328 -30.280  1.00 18.02           O  
ATOM  10739  CB  ASP F 169      15.470  -3.174 -29.268  1.00 14.73           C  
ATOM  10740  CG  ASP F 169      16.626  -4.170 -29.320  1.00 18.40           C  
ATOM  10741  OD1 ASP F 169      16.538  -5.118 -30.117  1.00 24.94           O  
ATOM  10742  OD2 ASP F 169      17.618  -4.003 -28.585  1.00 17.32           O  
ATOM  10743  N   LEU F 170      13.145  -1.238 -30.200  1.00 18.74           N  
ATOM  10744  CA  LEU F 170      11.848  -0.581 -30.012  1.00 18.29           C  
ATOM  10745  C   LEU F 170      10.927  -0.926 -31.176  1.00 18.67           C  
ATOM  10746  O   LEU F 170       9.752  -1.323 -30.998  1.00 23.35           O  
ATOM  10747  CB  LEU F 170      12.047   0.932 -30.060  1.00 20.73           C  
ATOM  10748  CG  LEU F 170      12.064   1.814 -28.825  1.00 19.47           C  
ATOM  10749  CD1 LEU F 170      11.997   0.978 -27.634  1.00 11.77           C  
ATOM  10750  CD2 LEU F 170      13.296   2.659 -28.797  1.00 15.94           C  
ATOM  10751  N   LEU F 171      11.443  -0.670 -32.383  1.00 19.35           N  
ATOM  10752  CA  LEU F 171      10.704  -0.934 -33.618  1.00 19.95           C  
ATOM  10753  C   LEU F 171      10.396  -2.422 -33.849  1.00 21.05           C  
ATOM  10754  O   LEU F 171       9.591  -2.747 -34.705  1.00 21.10           O  
ATOM  10755  CB  LEU F 171      11.411  -0.295 -34.818  1.00 18.13           C  
ATOM  10756  CG  LEU F 171      11.268   1.233 -34.894  1.00 20.74           C  
ATOM  10757  CD1 LEU F 171      12.245   1.863 -35.892  1.00 14.13           C  
ATOM  10758  CD2 LEU F 171       9.792   1.603 -35.220  1.00 18.36           C  
ATOM  10759  N   SER F 172      11.046  -3.324 -33.114  1.00 30.01           N  
ATOM  10760  CA  SER F 172      10.738  -4.756 -33.219  1.00 29.00           C  
ATOM  10761  C   SER F 172       9.754  -5.110 -32.115  1.00 29.84           C  
ATOM  10762  O   SER F 172       9.604  -6.280 -31.807  1.00 21.02           O  
ATOM  10763  CB  SER F 172      11.949  -5.655 -32.978  1.00 16.15           C  
ATOM  10764  OG  SER F 172      13.014  -5.423 -33.869  1.00 16.44           O  
ATOM  10765  N   GLY F 173       9.168  -4.108 -31.455  1.00 30.37           N  
ATOM  10766  CA  GLY F 173       8.220  -4.379 -30.377  1.00 31.45           C  
ATOM  10767  C   GLY F 173       8.777  -4.748 -28.990  1.00 30.51           C  
ATOM  10768  O   GLY F 173       8.025  -5.168 -28.092  1.00 29.48           O  
ATOM  10769  N   LYS F 174      10.076  -4.567 -28.775  1.00 23.06           N  
ATOM  10770  CA  LYS F 174      10.652  -4.893 -27.479  1.00 22.73           C  
ATOM  10771  C   LYS F 174      10.701  -3.698 -26.507  1.00 20.44           C  
ATOM  10772  O   LYS F 174      11.084  -2.592 -26.898  1.00 23.67           O  
ATOM  10773  CB  LYS F 174      12.055  -5.480 -27.689  1.00 26.25           C  
ATOM  10774  CG  LYS F 174      12.032  -6.831 -28.405  1.00 30.62           C  
ATOM  10775  CD  LYS F 174      13.425  -7.244 -28.862  1.00 37.43           C  
ATOM  10776  CE  LYS F 174      13.394  -8.420 -29.840  1.00 35.90           C  
ATOM  10777  NZ  LYS F 174      14.630  -8.342 -30.670  1.00 41.92           N  
ATOM  10778  N   THR F 175      10.309  -3.902 -25.250  1.00 27.15           N  
ATOM  10779  CA  THR F 175      10.378  -2.834 -24.227  1.00 25.24           C  
ATOM  10780  C   THR F 175      11.860  -2.592 -23.873  1.00 25.34           C  
ATOM  10781  O   THR F 175      12.580  -3.537 -23.489  1.00 13.19           O  
ATOM  10782  CB  THR F 175       9.615  -3.258 -22.996  1.00 13.83           C  
ATOM  10783  OG1 THR F 175       8.239  -3.391 -23.345  1.00 17.20           O  
ATOM  10784  CG2 THR F 175       9.784  -2.256 -21.861  1.00 14.63           C  
ATOM  10785  N   VAL F 176      12.334  -1.355 -24.042  1.00 17.93           N  
ATOM  10786  CA  VAL F 176      13.741  -1.054 -23.804  1.00 18.28           C  
ATOM  10787  C   VAL F 176      13.992  -0.281 -22.512  1.00 18.24           C  
ATOM  10788  O   VAL F 176      13.267   0.660 -22.178  1.00 15.49           O  
ATOM  10789  CB  VAL F 176      14.365  -0.232 -25.028  1.00 20.40           C  
ATOM  10790  CG1 VAL F 176      15.854   0.066 -24.844  1.00 15.21           C  
ATOM  10791  CG2 VAL F 176      14.154  -0.964 -26.338  1.00 13.47           C  
ATOM  10792  N   MET F 177      14.996  -0.723 -21.767  1.00 16.75           N  
ATOM  10793  CA  MET F 177      15.398  -0.037 -20.579  1.00 17.06           C  
ATOM  10794  C   MET F 177      16.799   0.549 -20.806  1.00 18.07           C  
ATOM  10795  O   MET F 177      17.748  -0.173 -21.207  1.00 15.07           O  
ATOM  10796  CB  MET F 177      15.483  -0.990 -19.394  1.00 12.69           C  
ATOM  10797  CG  MET F 177      16.131  -0.338 -18.144  1.00 13.30           C  
ATOM  10798  SD  MET F 177      16.083  -1.325 -16.653  1.00 17.12           S  
ATOM  10799  CE  MET F 177      17.659  -0.986 -15.884  1.00 10.66           C  
ATOM  10800  N   ILE F 178      16.945   1.845 -20.535  1.00 12.93           N  
ATOM  10801  CA  ILE F 178      18.256   2.453 -20.635  1.00 12.09           C  
ATOM  10802  C   ILE F 178      18.668   2.888 -19.227  1.00 12.03           C  
ATOM  10803  O   ILE F 178      17.906   3.552 -18.556  1.00 15.29           O  
ATOM  10804  CB  ILE F 178      18.268   3.708 -21.549  1.00 14.38           C  
ATOM  10805  CG1 ILE F 178      17.829   3.333 -22.971  1.00 16.67           C  
ATOM  10806  CG2 ILE F 178      19.665   4.315 -21.552  1.00 15.14           C  
ATOM  10807  CD1 ILE F 178      17.793   4.513 -23.965  1.00 14.46           C  
ATOM  10808  N   ALA F 179      19.837   2.472 -18.766  1.00 20.08           N  
ATOM  10809  CA  ALA F 179      20.288   2.912 -17.468  1.00 20.94           C  
ATOM  10810  C   ALA F 179      21.455   3.774 -17.857  1.00 21.73           C  
ATOM  10811  O   ALA F 179      22.465   3.256 -18.337  1.00 11.13           O  
ATOM  10812  CB  ALA F 179      20.747   1.758 -16.645  1.00  5.17           C  
ATOM  10813  N   ALA F 180      21.312   5.096 -17.693  1.00 21.05           N  
ATOM  10814  CA  ALA F 180      22.383   6.000 -18.079  1.00 19.10           C  
ATOM  10815  C   ALA F 180      22.674   7.125 -17.097  1.00 19.67           C  
ATOM  10816  O   ALA F 180      22.718   6.909 -15.906  1.00 22.29           O  
ATOM  10817  CB  ALA F 180      22.130   6.557 -19.498  1.00 21.84           C  
ATOM  10818  N   HIS F 181      22.823   8.344 -17.596  1.00 13.19           N  
ATOM  10819  CA  HIS F 181      23.200   9.464 -16.736  1.00 12.21           C  
ATOM  10820  C   HIS F 181      22.426  10.750 -16.935  1.00 15.17           C  
ATOM  10821  O   HIS F 181      21.587  10.886 -17.840  1.00 16.59           O  
ATOM  10822  CB  HIS F 181      24.702   9.740 -16.901  1.00  9.73           C  
ATOM  10823  CG  HIS F 181      25.551   8.503 -16.907  1.00 11.08           C  
ATOM  10824  ND1 HIS F 181      26.265   8.081 -15.804  1.00  8.56           N  
ATOM  10825  CD2 HIS F 181      25.778   7.581 -17.876  1.00 12.06           C  
ATOM  10826  CE1 HIS F 181      26.888   6.946 -16.085  1.00 11.05           C  
ATOM  10827  NE2 HIS F 181      26.608   6.621 -17.333  1.00 13.84           N  
ATOM  10828  N   GLY F 182      22.738  11.723 -16.093  1.00 22.70           N  
ATOM  10829  CA  GLY F 182      22.056  13.015 -16.157  1.00 17.68           C  
ATOM  10830  C   GLY F 182      21.982  13.659 -17.527  1.00 15.00           C  
ATOM  10831  O   GLY F 182      20.896  13.805 -18.084  1.00 24.80           O  
ATOM  10832  N   ASN F 183      23.135  14.009 -18.086  1.00 15.74           N  
ATOM  10833  CA  ASN F 183      23.185  14.654 -19.406  1.00 18.95           C  
ATOM  10834  C   ASN F 183      22.724  13.764 -20.586  1.00 17.76           C  
ATOM  10835  O   ASN F 183      21.940  14.194 -21.421  1.00 22.86           O  
ATOM  10836  CB  ASN F 183      24.586  15.214 -19.663  1.00 25.34           C  
ATOM  10837  CG  ASN F 183      24.895  16.409 -18.789  1.00 27.24           C  
ATOM  10838  OD1 ASN F 183      24.254  17.449 -18.894  1.00 34.34           O  
ATOM  10839  ND2 ASN F 183      25.869  16.265 -17.920  1.00 24.69           N  
ATOM  10840  N   SER F 184      23.154  12.501 -20.614  1.00 21.70           N  
ATOM  10841  CA  SER F 184      22.743  11.619 -21.703  1.00 18.18           C  
ATOM  10842  C   SER F 184      21.250  11.358 -21.663  1.00 15.50           C  
ATOM  10843  O   SER F 184      20.602  11.420 -22.682  1.00 17.52           O  
ATOM  10844  CB  SER F 184      23.590  10.339 -21.740  1.00 15.82           C  
ATOM  10845  OG  SER F 184      23.582   9.638 -20.531  1.00 16.19           O  
ATOM  10846  N   LEU F 185      20.644  11.225 -20.489  1.00 12.14           N  
ATOM  10847  CA  LEU F 185      19.190  11.005 -20.502  1.00 13.12           C  
ATOM  10848  C   LEU F 185      18.417  12.311 -20.757  1.00 15.24           C  
ATOM  10849  O   LEU F 185      17.371  12.306 -21.401  1.00 22.57           O  
ATOM  10850  CB  LEU F 185      18.715  10.284 -19.230  1.00 15.86           C  
ATOM  10851  CG  LEU F 185      19.139   8.807 -18.974  1.00 17.39           C  
ATOM  10852  CD1 LEU F 185      18.493   8.319 -17.657  1.00 11.98           C  
ATOM  10853  CD2 LEU F 185      18.702   7.870 -20.097  1.00 15.19           C  
ATOM  10854  N   ARG F 186      18.929  13.443 -20.251  1.00 15.99           N  
ATOM  10855  CA  ARG F 186      18.257  14.706 -20.517  1.00 19.40           C  
ATOM  10856  C   ARG F 186      18.335  14.924 -22.034  1.00 17.60           C  
ATOM  10857  O   ARG F 186      17.330  15.277 -22.681  1.00 24.52           O  
ATOM  10858  CB  ARG F 186      18.894  15.862 -19.729  1.00 28.01           C  
ATOM  10859  CG  ARG F 186      18.557  15.798 -18.205  1.00 33.81           C  
ATOM  10860  CD  ARG F 186      18.814  17.125 -17.488  1.00 34.17           C  
ATOM  10861  NE  ARG F 186      20.182  17.559 -17.726  1.00 38.72           N  
ATOM  10862  CZ  ARG F 186      20.510  18.647 -18.412  1.00 35.07           C  
ATOM  10863  NH1 ARG F 186      19.559  19.419 -18.912  1.00 38.74           N  
ATOM  10864  NH2 ARG F 186      21.798  18.947 -18.627  1.00 38.33           N  
ATOM  10865  N   GLY F 187      19.512  14.627 -22.593  1.00 23.83           N  
ATOM  10866  CA  GLY F 187      19.731  14.725 -24.025  1.00 23.66           C  
ATOM  10867  C   GLY F 187      18.701  13.888 -24.784  1.00 23.37           C  
ATOM  10868  O   GLY F 187      18.077  14.388 -25.721  1.00 18.47           O  
ATOM  10869  N   LEU F 188      18.489  12.631 -24.378  1.00 10.00           N  
ATOM  10870  CA  LEU F 188      17.513  11.818 -25.072  1.00  7.04           C  
ATOM  10871  C   LEU F 188      16.116  12.415 -24.899  1.00 11.47           C  
ATOM  10872  O   LEU F 188      15.318  12.423 -25.850  1.00 24.74           O  
ATOM  10873  CB  LEU F 188      17.548  10.364 -24.568  1.00 15.30           C  
ATOM  10874  CG  LEU F 188      16.607   9.368 -25.266  1.00 17.02           C  
ATOM  10875  CD1 LEU F 188      16.875   9.354 -26.751  1.00 12.80           C  
ATOM  10876  CD2 LEU F 188      16.806   7.993 -24.722  1.00 16.33           C  
ATOM  10877  N   VAL F 189      15.806  12.904 -23.697  1.00 23.62           N  
ATOM  10878  CA  VAL F 189      14.488  13.501 -23.463  1.00 22.20           C  
ATOM  10879  C   VAL F 189      14.294  14.802 -24.254  1.00 24.27           C  
ATOM  10880  O   VAL F 189      13.192  15.058 -24.764  1.00 22.85           O  
ATOM  10881  CB  VAL F 189      14.167  13.645 -21.970  1.00 22.29           C  
ATOM  10882  CG1 VAL F 189      12.817  14.301 -21.787  1.00 19.34           C  
ATOM  10883  CG2 VAL F 189      14.104  12.254 -21.361  1.00 19.13           C  
ATOM  10884  N   LYS F 190      15.368  15.592 -24.402  1.00 21.16           N  
ATOM  10885  CA  LYS F 190      15.318  16.824 -25.229  1.00 20.73           C  
ATOM  10886  C   LYS F 190      14.902  16.417 -26.656  1.00 21.53           C  
ATOM  10887  O   LYS F 190      14.035  17.024 -27.266  1.00 22.90           O  
ATOM  10888  CB  LYS F 190      16.680  17.524 -25.311  1.00 13.25           C  
ATOM  10889  CG  LYS F 190      16.542  18.946 -25.947  1.00 18.43           C  
ATOM  10890  CD  LYS F 190      17.861  19.584 -26.294  1.00 22.73           C  
ATOM  10891  CE  LYS F 190      17.640  20.903 -27.009  1.00 24.42           C  
ATOM  10892  NZ  LYS F 190      16.959  20.698 -28.301  1.00 29.05           N  
ATOM  10893  N   HIS F 191      15.507  15.349 -27.162  1.00 24.74           N  
ATOM  10894  CA  HIS F 191      15.163  14.818 -28.483  1.00 26.34           C  
ATOM  10895  C   HIS F 191      13.730  14.256 -28.541  1.00 24.90           C  
ATOM  10896  O   HIS F 191      12.943  14.601 -29.429  1.00 23.77           O  
ATOM  10897  CB  HIS F 191      16.155  13.714 -28.908  1.00 20.01           C  
ATOM  10898  CG  HIS F 191      15.800  13.061 -30.214  1.00 25.13           C  
ATOM  10899  ND1 HIS F 191      16.455  13.351 -31.386  1.00 24.44           N  
ATOM  10900  CD2 HIS F 191      14.782  12.225 -30.551  1.00 25.60           C  
ATOM  10901  CE1 HIS F 191      15.854  12.741 -32.386  1.00 20.21           C  
ATOM  10902  NE2 HIS F 191      14.833  12.049 -31.907  1.00 23.93           N  
ATOM  10903  N   LEU F 192      13.382  13.375 -27.615  1.00 23.03           N  
ATOM  10904  CA  LEU F 192      12.039  12.785 -27.652  1.00 20.10           C  
ATOM  10905  C   LEU F 192      10.869  13.785 -27.622  1.00 22.82           C  
ATOM  10906  O   LEU F 192       9.897  13.622 -28.349  1.00 22.41           O  
ATOM  10907  CB  LEU F 192      11.889  11.757 -26.517  1.00 18.04           C  
ATOM  10908  CG  LEU F 192      12.769  10.519 -26.630  1.00 16.64           C  
ATOM  10909  CD1 LEU F 192      12.855   9.740 -25.315  1.00 14.58           C  
ATOM  10910  CD2 LEU F 192      12.191   9.653 -27.689  1.00 17.51           C  
ATOM  10911  N   GLU F 193      10.997  14.824 -26.803  1.00 24.26           N  
ATOM  10912  CA  GLU F 193       9.927  15.802 -26.610  1.00 23.42           C  
ATOM  10913  C   GLU F 193      10.011  17.102 -27.421  1.00 25.65           C  
ATOM  10914  O   GLU F 193       9.049  17.871 -27.486  1.00 36.72           O  
ATOM  10915  CB  GLU F 193       9.746  16.062 -25.096  1.00 33.80           C  
ATOM  10916  CG  GLU F 193       9.176  14.845 -24.310  1.00 34.25           C  
ATOM  10917  CD  GLU F 193       9.217  15.001 -22.775  1.00 39.00           C  
ATOM  10918  OE1 GLU F 193       9.837  15.975 -22.287  1.00 39.10           O  
ATOM  10919  OE2 GLU F 193       8.628  14.154 -22.050  1.00 38.50           O  
ATOM  10920  N   GLY F 194      11.140  17.298 -28.098  1.00 28.32           N  
ATOM  10921  CA  GLY F 194      11.313  18.484 -28.915  1.00 29.21           C  
ATOM  10922  C   GLY F 194      11.486  19.745 -28.096  1.00 30.87           C  
ATOM  10923  O   GLY F 194      11.022  20.808 -28.498  1.00 30.00           O  
ATOM  10924  N   ILE F 195      12.117  19.603 -26.933  1.00 30.42           N  
ATOM  10925  CA  ILE F 195      12.399  20.714 -26.038  1.00 30.55           C  
ATOM  10926  C   ILE F 195      13.453  21.566 -26.757  1.00 32.11           C  
ATOM  10927  O   ILE F 195      14.353  21.025 -27.404  1.00 31.08           O  
ATOM  10928  CB  ILE F 195      12.925  20.169 -24.680  1.00 28.25           C  
ATOM  10929  CG1 ILE F 195      11.808  19.392 -23.991  1.00 26.36           C  
ATOM  10930  CG2 ILE F 195      13.380  21.295 -23.775  1.00 26.46           C  
ATOM  10931  CD1 ILE F 195      12.258  18.677 -22.790  1.00 26.55           C  
ATOM  10932  N   SER F 196      13.320  22.892 -26.697  1.00 32.14           N  
ATOM  10933  CA  SER F 196      14.265  23.766 -27.381  1.00 32.41           C  
ATOM  10934  C   SER F 196      15.586  23.864 -26.634  1.00 31.48           C  
ATOM  10935  O   SER F 196      15.663  23.578 -25.428  1.00 34.03           O  
ATOM  10936  CB  SER F 196      13.664  25.153 -27.568  1.00 45.78           C  
ATOM  10937  OG  SER F 196      13.339  25.709 -26.303  1.00 43.50           O  
ATOM  10938  N   ASP F 197      16.623  24.279 -27.358  1.00 29.71           N  
ATOM  10939  CA  ASP F 197      17.956  24.419 -26.776  1.00 30.15           C  
ATOM  10940  C   ASP F 197      17.931  25.302 -25.553  1.00 30.63           C  
ATOM  10941  O   ASP F 197      18.779  25.155 -24.672  1.00 32.29           O  
ATOM  10942  CB  ASP F 197      18.942  25.079 -27.752  1.00 32.10           C  
ATOM  10943  CG  ASP F 197      19.123  24.306 -29.026  1.00 33.65           C  
ATOM  10944  OD1 ASP F 197      18.397  23.302 -29.196  1.00 29.47           O  
ATOM  10945  OD2 ASP F 197      19.996  24.715 -29.845  1.00 32.02           O  
ATOM  10946  N   ALA F 198      17.024  26.281 -25.574  1.00 44.48           N  
ATOM  10947  CA  ALA F 198      16.864  27.284 -24.519  1.00 45.17           C  
ATOM  10948  C   ALA F 198      16.232  26.776 -23.212  1.00 45.67           C  
ATOM  10949  O   ALA F 198      16.670  27.134 -22.096  1.00 35.34           O  
ATOM  10950  CB  ALA F 198      16.064  28.466 -25.083  1.00 38.35           C  
ATOM  10951  N   ASP F 199      15.219  25.926 -23.372  1.00 33.68           N  
ATOM  10952  CA  ASP F 199      14.481  25.333 -22.258  1.00 34.64           C  
ATOM  10953  C   ASP F 199      15.057  24.033 -21.685  1.00 35.04           C  
ATOM  10954  O   ASP F 199      14.531  23.525 -20.697  1.00 36.53           O  
ATOM  10955  CB  ASP F 199      13.032  25.068 -22.692  1.00 40.65           C  
ATOM  10956  CG  ASP F 199      12.249  26.351 -22.967  1.00 41.97           C  
ATOM  10957  OD1 ASP F 199      12.876  27.426 -22.984  1.00 40.69           O  
ATOM  10958  OD2 ASP F 199      11.010  26.285 -23.160  1.00 42.08           O  
ATOM  10959  N   ILE F 200      16.126  23.496 -22.276  1.00 38.37           N  
ATOM  10960  CA  ILE F 200      16.691  22.221 -21.802  1.00 33.36           C  
ATOM  10961  C   ILE F 200      17.363  22.273 -20.448  1.00 33.09           C  
ATOM  10962  O   ILE F 200      17.290  21.316 -19.698  1.00 30.84           O  
ATOM  10963  CB  ILE F 200      17.634  21.491 -22.871  1.00 28.39           C  
ATOM  10964  CG1 ILE F 200      17.824  20.009 -22.509  1.00 22.02           C  
ATOM  10965  CG2 ILE F 200      19.038  22.130 -22.938  1.00 23.35           C  
ATOM  10966  CD1 ILE F 200      16.509  19.220 -22.347  1.00 16.18           C  
ATOM  10967  N   ALA F 201      17.992  23.392 -20.118  1.00 38.46           N  
ATOM  10968  CA  ALA F 201      18.665  23.519 -18.829  1.00 41.55           C  
ATOM  10969  C   ALA F 201      17.683  23.358 -17.657  1.00 44.61           C  
ATOM  10970  O   ALA F 201      18.031  22.856 -16.574  1.00 32.62           O  
ATOM  10971  CB  ALA F 201      19.374  24.853 -18.759  1.00 27.67           C  
ATOM  10972  N   LYS F 202      16.433  23.717 -17.916  1.00 49.15           N  
ATOM  10973  CA  LYS F 202      15.377  23.651 -16.911  1.00 54.94           C  
ATOM  10974  C   LYS F 202      14.914  22.237 -16.543  1.00 53.61           C  
ATOM  10975  O   LYS F 202      14.311  22.033 -15.487  1.00 56.36           O  
ATOM  10976  CB  LYS F 202      14.167  24.504 -17.350  1.00 64.90           C  
ATOM  10977  CG  LYS F 202      14.326  26.025 -17.190  1.00 72.66           C  
ATOM  10978  CD  LYS F 202      15.210  26.668 -18.269  1.00 76.49           C  
ATOM  10979  CE  LYS F 202      16.507  27.243 -17.687  1.00 80.52           C  
ATOM  10980  NZ  LYS F 202      17.392  27.856 -18.731  1.00 79.04           N  
ATOM  10981  N   LEU F 203      15.178  21.269 -17.415  1.00 47.37           N  
ATOM  10982  CA  LEU F 203      14.751  19.902 -17.144  1.00 43.35           C  
ATOM  10983  C   LEU F 203      15.635  19.144 -16.177  1.00 42.25           C  
ATOM  10984  O   LEU F 203      16.879  19.209 -16.229  1.00 30.09           O  
ATOM  10985  CB  LEU F 203      14.612  19.069 -18.421  1.00 34.24           C  
ATOM  10986  CG  LEU F 203      14.425  17.572 -18.101  1.00 29.03           C  
ATOM  10987  CD1 LEU F 203      12.981  17.282 -17.662  1.00 30.47           C  
ATOM  10988  CD2 LEU F 203      14.847  16.736 -19.304  1.00 25.37           C  
ATOM  10989  N   ASN F 204      14.961  18.432 -15.287  1.00 33.69           N  
ATOM  10990  CA  ASN F 204      15.646  17.598 -14.326  1.00 37.15           C  
ATOM  10991  C   ASN F 204      15.059  16.195 -14.339  1.00 31.21           C  
ATOM  10992  O   ASN F 204      13.839  15.992 -14.511  1.00 37.93           O  
ATOM  10993  CB  ASN F 204      15.554  18.161 -12.915  1.00 50.03           C  
ATOM  10994  CG  ASN F 204      16.399  17.366 -11.935  1.00 57.19           C  
ATOM  10995  OD1 ASN F 204      17.635  17.350 -12.043  1.00 59.06           O  
ATOM  10996  ND2 ASN F 204      15.739  16.657 -11.012  1.00 57.24           N  
ATOM  10997  N   ILE F 205      15.956  15.221 -14.237  1.00 26.89           N  
ATOM  10998  CA  ILE F 205      15.521  13.842 -14.194  1.00 24.80           C  
ATOM  10999  C   ILE F 205      16.009  13.335 -12.862  1.00 22.71           C  
ATOM  11000  O   ILE F 205      17.219  13.280 -12.594  1.00 24.98           O  
ATOM  11001  CB  ILE F 205      16.034  12.993 -15.397  1.00 30.18           C  
ATOM  11002  CG1 ILE F 205      15.408  13.527 -16.705  1.00 27.43           C  
ATOM  11003  CG2 ILE F 205      15.611  11.517 -15.219  1.00 28.61           C  
ATOM  11004  CD1 ILE F 205      15.849  12.846 -17.977  1.00 31.49           C  
ATOM  11005  N   PRO F 206      15.054  13.035 -11.971  1.00 20.58           N  
ATOM  11006  CA  PRO F 206      15.351  12.538 -10.625  1.00 22.53           C  
ATOM  11007  C   PRO F 206      16.005  11.156 -10.669  1.00 21.95           C  
ATOM  11008  O   PRO F 206      15.711  10.339 -11.550  1.00 28.37           O  
ATOM  11009  CB  PRO F 206      13.976  12.531  -9.959  1.00 25.04           C  
ATOM  11010  CG  PRO F 206      13.046  12.217 -11.111  1.00 26.11           C  
ATOM  11011  CD  PRO F 206      13.599  13.069 -12.232  1.00 24.52           C  
ATOM  11012  N   THR F 207      16.952  10.940  -9.765  1.00 27.96           N  
ATOM  11013  CA  THR F 207      17.661   9.678  -9.674  1.00 27.07           C  
ATOM  11014  C   THR F 207      16.773   8.562  -9.127  1.00 29.86           C  
ATOM  11015  O   THR F 207      15.780   8.822  -8.453  1.00 30.08           O  
ATOM  11016  CB  THR F 207      18.867   9.779  -8.740  1.00 25.88           C  
ATOM  11017  OG1 THR F 207      18.418  10.136  -7.434  1.00 28.26           O  
ATOM  11018  CG2 THR F 207      19.869  10.784  -9.222  1.00 27.96           C  
ATOM  11019  N   GLY F 208      17.097   7.327  -9.527  1.00 23.04           N  
ATOM  11020  CA  GLY F 208      16.412   6.133  -9.060  1.00 20.14           C  
ATOM  11021  C   GLY F 208      14.935   5.984  -9.215  1.00 21.03           C  
ATOM  11022  O   GLY F 208      14.330   5.318  -8.389  1.00 28.07           O  
ATOM  11023  N   ILE F 209      14.335   6.630 -10.206  1.00 25.83           N  
ATOM  11024  CA  ILE F 209      12.896   6.505 -10.466  1.00 27.20           C  
ATOM  11025  C   ILE F 209      12.706   6.350 -11.977  1.00 28.08           C  
ATOM  11026  O   ILE F 209      12.912   7.298 -12.742  1.00 27.86           O  
ATOM  11027  CB  ILE F 209      12.077   7.738 -10.031  1.00 24.31           C  
ATOM  11028  CG1 ILE F 209      12.387   8.090  -8.603  1.00 20.48           C  
ATOM  11029  CG2 ILE F 209      10.600   7.442 -10.108  1.00 20.22           C  
ATOM  11030  CD1 ILE F 209      11.772   9.411  -8.201  1.00 19.21           C  
ATOM  11031  N   PRO F 210      12.305   5.144 -12.416  1.00 25.44           N  
ATOM  11032  CA  PRO F 210      12.088   4.858 -13.833  1.00 23.77           C  
ATOM  11033  C   PRO F 210      11.105   5.820 -14.463  1.00 24.84           C  
ATOM  11034  O   PRO F 210      10.037   6.080 -13.919  1.00 24.79           O  
ATOM  11035  CB  PRO F 210      11.529   3.417 -13.827  1.00 20.75           C  
ATOM  11036  CG  PRO F 210      12.146   2.804 -12.605  1.00 21.63           C  
ATOM  11037  CD  PRO F 210      12.051   3.937 -11.589  1.00 18.44           C  
ATOM  11038  N   LEU F 211      11.498   6.320 -15.635  1.00 22.67           N  
ATOM  11039  CA  LEU F 211      10.708   7.255 -16.418  1.00 19.40           C  
ATOM  11040  C   LEU F 211      10.302   6.483 -17.669  1.00 21.39           C  
ATOM  11041  O   LEU F 211      11.146   6.103 -18.470  1.00 23.63           O  
ATOM  11042  CB  LEU F 211      11.582   8.451 -16.791  1.00 20.27           C  
ATOM  11043  CG  LEU F 211      10.888   9.763 -17.144  1.00 24.58           C  
ATOM  11044  CD1 LEU F 211      11.774  10.521 -18.109  1.00 18.07           C  
ATOM  11045  CD2 LEU F 211       9.504   9.562 -17.674  1.00 23.85           C  
ATOM  11046  N   VAL F 212       9.008   6.308 -17.848  1.00 20.88           N  
ATOM  11047  CA  VAL F 212       8.468   5.548 -18.953  1.00 19.60           C  
ATOM  11048  C   VAL F 212       7.812   6.381 -20.055  1.00 22.74           C  
ATOM  11049  O   VAL F 212       6.876   7.143 -19.794  1.00 32.12           O  
ATOM  11050  CB  VAL F 212       7.372   4.570 -18.419  1.00 27.43           C  
ATOM  11051  CG1 VAL F 212       6.699   3.824 -19.558  1.00 25.21           C  
ATOM  11052  CG2 VAL F 212       7.949   3.621 -17.368  1.00 28.04           C  
ATOM  11053  N   PHE F 213       8.258   6.160 -21.297  1.00 26.56           N  
ATOM  11054  CA  PHE F 213       7.702   6.817 -22.488  1.00 29.51           C  
ATOM  11055  C   PHE F 213       7.022   5.742 -23.295  1.00 29.97           C  
ATOM  11056  O   PHE F 213       7.551   4.647 -23.442  1.00 24.38           O  
ATOM  11057  CB  PHE F 213       8.786   7.377 -23.404  1.00 23.51           C  
ATOM  11058  CG  PHE F 213       9.459   8.608 -22.893  1.00 22.39           C  
ATOM  11059  CD1 PHE F 213      10.535   8.523 -22.033  1.00 21.53           C  
ATOM  11060  CD2 PHE F 213       9.047   9.863 -23.328  1.00 24.51           C  
ATOM  11061  CE1 PHE F 213      11.202   9.681 -21.607  1.00 24.81           C  
ATOM  11062  CE2 PHE F 213       9.712  11.014 -22.906  1.00 27.27           C  
ATOM  11063  CZ  PHE F 213      10.788  10.928 -22.050  1.00 23.81           C  
ATOM  11064  N   GLU F 214       5.798   6.016 -23.703  1.00 24.84           N  
ATOM  11065  CA  GLU F 214       5.061   5.124 -24.563  1.00 25.19           C  
ATOM  11066  C   GLU F 214       5.213   5.888 -25.876  1.00 27.08           C  
ATOM  11067  O   GLU F 214       4.858   7.068 -25.960  1.00 36.22           O  
ATOM  11068  CB  GLU F 214       3.602   5.030 -24.152  1.00 36.81           C  
ATOM  11069  CG  GLU F 214       3.407   4.550 -22.739  1.00 43.14           C  
ATOM  11070  CD  GLU F 214       2.025   3.956 -22.488  1.00 47.07           C  
ATOM  11071  OE1 GLU F 214       1.091   4.181 -23.302  1.00 49.54           O  
ATOM  11072  OE2 GLU F 214       1.880   3.241 -21.464  1.00 48.82           O  
ATOM  11073  N   LEU F 215       5.837   5.235 -26.854  1.00 27.65           N  
ATOM  11074  CA  LEU F 215       6.105   5.830 -28.158  1.00 23.74           C  
ATOM  11075  C   LEU F 215       5.222   5.286 -29.262  1.00 23.89           C  
ATOM  11076  O   LEU F 215       4.550   4.275 -29.076  1.00 25.34           O  
ATOM  11077  CB  LEU F 215       7.565   5.583 -28.512  1.00 20.52           C  
ATOM  11078  CG  LEU F 215       8.600   6.005 -27.471  1.00 26.10           C  
ATOM  11079  CD1 LEU F 215       9.951   5.469 -27.824  1.00 19.51           C  
ATOM  11080  CD2 LEU F 215       8.621   7.537 -27.332  1.00 27.59           C  
ATOM  11081  N   ASP F 216       5.138   6.012 -30.375  1.00 27.40           N  
ATOM  11082  CA  ASP F 216       4.357   5.539 -31.513  1.00 27.70           C  
ATOM  11083  C   ASP F 216       5.342   4.898 -32.483  1.00 27.97           C  
ATOM  11084  O   ASP F 216       6.515   4.714 -32.134  1.00 22.62           O  
ATOM  11085  CB  ASP F 216       3.508   6.661 -32.180  1.00 23.41           C  
ATOM  11086  CG  ASP F 216       4.329   7.815 -32.749  1.00 24.84           C  
ATOM  11087  OD1 ASP F 216       5.557   7.715 -32.937  1.00 27.55           O  
ATOM  11088  OD2 ASP F 216       3.704   8.867 -33.016  1.00 29.06           O  
ATOM  11089  N   GLU F 217       4.865   4.573 -33.685  1.00 22.83           N  
ATOM  11090  CA  GLU F 217       5.677   3.960 -34.729  1.00 23.72           C  
ATOM  11091  C   GLU F 217       6.766   4.906 -35.276  1.00 25.95           C  
ATOM  11092  O   GLU F 217       7.716   4.471 -35.955  1.00 31.41           O  
ATOM  11093  CB  GLU F 217       4.774   3.406 -35.847  1.00 34.21           C  
ATOM  11094  CG  GLU F 217       3.952   4.447 -36.661  1.00 43.79           C  
ATOM  11095  CD  GLU F 217       2.782   5.117 -35.887  1.00 50.65           C  
ATOM  11096  OE1 GLU F 217       2.298   4.541 -34.874  1.00 51.98           O  
ATOM  11097  OE2 GLU F 217       2.337   6.220 -36.317  1.00 55.96           O  
ATOM  11098  N   ASN F 218       6.625   6.199 -34.964  1.00 31.15           N  
ATOM  11099  CA  ASN F 218       7.592   7.225 -35.365  1.00 31.13           C  
ATOM  11100  C   ASN F 218       8.545   7.544 -34.234  1.00 29.14           C  
ATOM  11101  O   ASN F 218       9.385   8.443 -34.374  1.00 26.06           O  
ATOM  11102  CB  ASN F 218       6.921   8.512 -35.855  1.00 28.95           C  
ATOM  11103  CG  ASN F 218       6.508   8.447 -37.337  1.00 34.72           C  
ATOM  11104  OD1 ASN F 218       7.337   8.157 -38.222  1.00 38.90           O  
ATOM  11105  ND2 ASN F 218       5.224   8.717 -37.610  1.00 27.10           N  
ATOM  11106  N   LEU F 219       8.442   6.775 -33.139  1.00 24.91           N  
ATOM  11107  CA  LEU F 219       9.306   6.935 -31.967  1.00 23.10           C  
ATOM  11108  C   LEU F 219       9.154   8.307 -31.262  1.00 25.22           C  
ATOM  11109  O   LEU F 219      10.136   8.881 -30.762  1.00 18.44           O  
ATOM  11110  CB  LEU F 219      10.773   6.665 -32.356  1.00 19.67           C  
ATOM  11111  CG  LEU F 219      11.308   5.228 -32.210  1.00 22.38           C  
ATOM  11112  CD1 LEU F 219      10.246   4.192 -32.427  1.00 19.33           C  
ATOM  11113  CD2 LEU F 219      12.501   4.975 -33.114  1.00 17.34           C  
ATOM  11114  N   LYS F 220       7.922   8.825 -31.277  1.00 23.98           N  
ATOM  11115  CA  LYS F 220       7.567  10.095 -30.657  1.00 26.97           C  
ATOM  11116  C   LYS F 220       6.550   9.729 -29.593  1.00 26.03           C  
ATOM  11117  O   LYS F 220       5.716   8.850 -29.810  1.00 21.45           O  
ATOM  11118  CB  LYS F 220       6.882  11.048 -31.661  1.00 25.09           C  
ATOM  11119  CG  LYS F 220       7.786  11.701 -32.747  1.00 35.12           C  
ATOM  11120  CD  LYS F 220       9.051  12.296 -32.127  1.00 43.51           C  
ATOM  11121  CE  LYS F 220       9.794  13.227 -33.060  1.00 48.17           C  
ATOM  11122  NZ  LYS F 220      11.150  13.363 -32.475  1.00 45.31           N  
ATOM  11123  N   PRO F 221       6.574  10.427 -28.446  1.00 28.46           N  
ATOM  11124  CA  PRO F 221       5.632  10.148 -27.359  1.00 30.81           C  
ATOM  11125  C   PRO F 221       4.198  10.142 -27.854  1.00 34.99           C  
ATOM  11126  O   PRO F 221       3.793  11.033 -28.596  1.00 33.99           O  
ATOM  11127  CB  PRO F 221       5.903  11.283 -26.381  1.00 32.30           C  
ATOM  11128  CG  PRO F 221       7.367  11.497 -26.542  1.00 30.18           C  
ATOM  11129  CD  PRO F 221       7.518  11.482 -28.054  1.00 26.10           C  
ATOM  11130  N   SER F 222       3.475   9.070 -27.533  1.00 39.76           N  
ATOM  11131  CA  SER F 222       2.082   8.928 -27.943  1.00 40.73           C  
ATOM  11132  C   SER F 222       1.177   9.439 -26.818  1.00 42.64           C  
ATOM  11133  O   SER F 222      -0.050   9.511 -26.954  1.00 32.65           O  
ATOM  11134  CB  SER F 222       1.785   7.470 -28.282  1.00 32.20           C  
ATOM  11135  OG  SER F 222       2.204   6.639 -27.217  1.00 41.94           O  
ATOM  11136  N   LYS F 223       1.819   9.759 -25.700  1.00 47.04           N  
ATOM  11137  CA  LYS F 223       1.172  10.309 -24.523  1.00 47.67           C  
ATOM  11138  C   LYS F 223       2.302  10.787 -23.620  1.00 48.10           C  
ATOM  11139  O   LYS F 223       3.442  10.327 -23.758  1.00 51.66           O  
ATOM  11140  CB  LYS F 223       0.281   9.273 -23.816  1.00 50.11           C  
ATOM  11141  CG  LYS F 223       0.982   8.154 -23.068  1.00 50.40           C  
ATOM  11142  CD  LYS F 223      -0.027   7.412 -22.198  1.00 58.02           C  
ATOM  11143  CE  LYS F 223      -1.265   7.010 -23.016  1.00 62.67           C  
ATOM  11144  NZ  LYS F 223      -2.457   6.646 -22.180  1.00 67.09           N  
ATOM  11145  N   PRO F 224       2.022  11.761 -22.728  1.00 56.95           N  
ATOM  11146  CA  PRO F 224       3.036  12.293 -21.811  1.00 54.04           C  
ATOM  11147  C   PRO F 224       3.845  11.230 -21.053  1.00 51.20           C  
ATOM  11148  O   PRO F 224       3.302  10.234 -20.549  1.00 37.39           O  
ATOM  11149  CB  PRO F 224       2.207  13.170 -20.863  1.00 41.89           C  
ATOM  11150  CG  PRO F 224       0.794  12.579 -20.962  1.00 44.92           C  
ATOM  11151  CD  PRO F 224       0.705  12.360 -22.434  1.00 44.07           C  
ATOM  11152  N   SER F 225       5.155  11.431 -20.985  1.00 48.11           N  
ATOM  11153  CA  SER F 225       6.003  10.485 -20.278  1.00 45.01           C  
ATOM  11154  C   SER F 225       5.544  10.438 -18.825  1.00 46.59           C  
ATOM  11155  O   SER F 225       4.778  11.303 -18.386  1.00 36.92           O  
ATOM  11156  CB  SER F 225       7.465  10.917 -20.352  1.00 31.48           C  
ATOM  11157  OG  SER F 225       7.689  12.093 -19.595  1.00 31.82           O  
ATOM  11158  N   TYR F 226       5.963   9.406 -18.096  1.00 34.42           N  
ATOM  11159  CA  TYR F 226       5.590   9.294 -16.704  1.00 33.52           C  
ATOM  11160  C   TYR F 226       6.552   8.505 -15.851  1.00 33.33           C  
ATOM  11161  O   TYR F 226       7.136   7.516 -16.289  1.00 35.02           O  
ATOM  11162  CB  TYR F 226       4.190   8.714 -16.557  1.00 30.57           C  
ATOM  11163  CG  TYR F 226       3.987   7.355 -17.168  1.00 30.33           C  
ATOM  11164  CD1 TYR F 226       4.188   6.196 -16.431  1.00 28.26           C  
ATOM  11165  CD2 TYR F 226       3.545   7.230 -18.472  1.00 31.41           C  
ATOM  11166  CE1 TYR F 226       3.952   4.950 -16.980  1.00 26.83           C  
ATOM  11167  CE2 TYR F 226       3.307   5.977 -19.043  1.00 31.26           C  
ATOM  11168  CZ  TYR F 226       3.515   4.850 -18.294  1.00 28.62           C  
ATOM  11169  OH  TYR F 226       3.337   3.633 -18.888  1.00 31.09           O  
ATOM  11170  N   TYR F 227       6.740   8.985 -14.627  1.00 24.41           N  
ATOM  11171  CA  TYR F 227       7.591   8.314 -13.665  1.00 24.13           C  
ATOM  11172  C   TYR F 227       6.796   7.187 -12.995  1.00 25.68           C  
ATOM  11173  O   TYR F 227       5.570   7.175 -13.031  1.00 31.70           O  
ATOM  11174  CB  TYR F 227       8.086   9.318 -12.633  1.00 30.11           C  
ATOM  11175  CG  TYR F 227       9.087  10.287 -13.206  1.00 27.02           C  
ATOM  11176  CD1 TYR F 227      10.444   9.973 -13.229  1.00 26.96           C  
ATOM  11177  CD2 TYR F 227       8.680  11.516 -13.733  1.00 26.31           C  
ATOM  11178  CE1 TYR F 227      11.379  10.845 -13.773  1.00 29.96           C  
ATOM  11179  CE2 TYR F 227       9.617  12.411 -14.288  1.00 27.18           C  
ATOM  11180  CZ  TYR F 227      10.965  12.064 -14.300  1.00 27.12           C  
ATOM  11181  OH  TYR F 227      11.895  12.908 -14.869  1.00 30.29           O  
ATOM  11182  N   LEU F 228       7.487   6.201 -12.438  1.00 41.74           N  
ATOM  11183  CA  LEU F 228       6.770   5.122 -11.781  1.00 44.73           C  
ATOM  11184  C   LEU F 228       6.430   5.484 -10.327  1.00 48.53           C  
ATOM  11185  O   LEU F 228       5.693   4.773  -9.634  1.00 32.80           O  
ATOM  11186  CB  LEU F 228       7.505   3.788 -11.942  1.00 22.87           C  
ATOM  11187  CG  LEU F 228       7.514   3.240 -13.391  1.00 23.90           C  
ATOM  11188  CD1 LEU F 228       8.135   1.829 -13.415  1.00 21.39           C  
ATOM  11189  CD2 LEU F 228       6.075   3.224 -14.007  1.00 21.57           C  
ATOM  11190  N   ASP F 229       6.930   6.639  -9.900  1.00 39.81           N  
ATOM  11191  CA  ASP F 229       6.648   7.202  -8.582  1.00 42.21           C  
ATOM  11192  C   ASP F 229       6.432   8.704  -8.843  1.00 42.96           C  
ATOM  11193  O   ASP F 229       7.306   9.530  -8.561  1.00 36.54           O  
ATOM  11194  CB  ASP F 229       7.813   6.985  -7.602  1.00 38.00           C  
ATOM  11195  CG  ASP F 229       7.419   7.272  -6.146  1.00 42.27           C  
ATOM  11196  OD1 ASP F 229       6.296   7.805  -5.914  1.00 35.31           O  
ATOM  11197  OD2 ASP F 229       8.230   6.955  -5.240  1.00 43.21           O  
ATOM  11198  N   PRO F 230       5.256   9.067  -9.395  1.00 38.45           N  
ATOM  11199  CA  PRO F 230       4.908  10.459  -9.713  1.00 40.47           C  
ATOM  11200  C   PRO F 230       5.207  11.491  -8.611  1.00 45.28           C  
ATOM  11201  O   PRO F 230       5.895  12.492  -8.856  1.00 60.53           O  
ATOM  11202  CB  PRO F 230       3.418  10.361 -10.054  1.00 50.39           C  
ATOM  11203  CG  PRO F 230       3.323   8.988 -10.705  1.00 48.26           C  
ATOM  11204  CD  PRO F 230       4.140   8.158  -9.739  1.00 49.61           C  
ATOM  11205  N   GLU F 231       4.717  11.225  -7.400  1.00 55.86           N  
ATOM  11206  CA  GLU F 231       4.927  12.114  -6.271  1.00 57.38           C  
ATOM  11207  C   GLU F 231       6.407  12.361  -5.959  1.00 55.90           C  
ATOM  11208  O   GLU F 231       6.842  13.519  -5.913  1.00 67.61           O  
ATOM  11209  CB  GLU F 231       4.201  11.596  -5.019  1.00 75.90           C  
ATOM  11210  CG  GLU F 231       3.662  10.167  -5.114  1.00 88.13           C  
ATOM  11211  CD  GLU F 231       2.203  10.103  -5.546  1.00 95.53           C  
ATOM  11212  OE1 GLU F 231       1.404  10.946  -5.080  1.00 99.98           O  
ATOM  11213  OE2 GLU F 231       1.855   9.197  -6.338  1.00 99.98           O  
ATOM  11214  N   ALA F 232       7.178  11.281  -5.782  1.00 48.66           N  
ATOM  11215  CA  ALA F 232       8.610  11.371  -5.453  1.00 47.16           C  
ATOM  11216  C   ALA F 232       9.487  12.016  -6.532  1.00 47.00           C  
ATOM  11217  O   ALA F 232      10.519  12.640  -6.237  1.00 38.18           O  
ATOM  11218  CB  ALA F 232       9.150  10.001  -5.092  1.00 39.48           C  
ATOM  11219  N   ALA F 233       9.095  11.828  -7.785  1.00 55.06           N  
ATOM  11220  CA  ALA F 233       9.829  12.398  -8.899  1.00 58.47           C  
ATOM  11221  C   ALA F 233       9.615  13.910  -8.979  1.00 62.32           C  
ATOM  11222  O   ALA F 233      10.545  14.664  -9.294  1.00 39.02           O  
ATOM  11223  CB  ALA F 233       9.389  11.744 -10.178  1.00 35.28           C  
ATOM  11224  N   ALA F 234       8.377  14.334  -8.715  1.00 62.36           N  
ATOM  11225  CA  ALA F 234       8.007  15.748  -8.755  1.00 66.27           C  
ATOM  11226  C   ALA F 234       8.312  16.490  -7.446  1.00 67.47           C  
ATOM  11227  O   ALA F 234       8.353  17.722  -7.416  1.00 70.10           O  
ATOM  11228  CB  ALA F 234       6.526  15.913  -9.147  1.00 70.48           C  
ATOM  11229  N   ALA F 235       8.536  15.742  -6.368  1.00 67.06           N  
ATOM  11230  CA  ALA F 235       8.856  16.354  -5.085  1.00 69.32           C  
ATOM  11231  C   ALA F 235      10.372  16.464  -4.929  1.00 70.88           C  
ATOM  11232  O   ALA F 235      11.075  16.870  -5.861  1.00 57.33           O  
ATOM  11233  CB  ALA F 235       8.250  15.546  -3.936  1.00 54.85           C  
TER   11234      ALA F 235                                                      
END
MOLECULE T0428.pdb
ATOM      1  N   PRO    16      -1.620   2.377 -25.877  1.00 42.51           N
ATOM      2  CA  PRO    16      -2.969   2.886 -26.124  1.00 42.51           C
ATOM      3  CB  PRO    16      -3.200   3.850 -24.957  1.00 42.57           C
ATOM      4  CG  PRO    16      -1.842   4.317 -24.569  1.00 42.36           C
ATOM      5  CD  PRO    16      -0.845   3.257 -24.984  1.00 42.69           C
ATOM      6  C   PRO    16      -3.069   3.625 -27.457  1.00 42.45           C
ATOM      7  O   PRO    16      -2.049   3.845 -28.117  1.00 42.55           O
ATOM      8  N   ARG    17      -4.289   3.997 -27.838  1.00 42.35           N
ATOM      9  CA  ARG    17      -4.562   4.653 -29.116  1.00 42.30           C
ATOM     10  CB  ARG    17      -6.068   4.917 -29.244  1.00 42.22           C
ATOM     11  CG  ARG    17      -6.617   4.781 -30.645  1.00 41.88           C
ATOM     12  CD  ARG    17      -8.137   4.648 -30.630  1.00 41.53           C
ATOM     17  C   ARG    17      -3.767   5.957 -29.254  1.00 42.44           C
ATOM     18  O   ARG    17      -3.841   6.830 -28.386  1.00 42.48           O
ATOM     19  N   GLY    18      -2.991   6.069 -30.332  1.00 42.52           N
ATOM     20  CA  GLY    18      -2.203   7.279 -30.601  1.00 42.55           C
ATOM     21  C   GLY    18      -0.703   7.104 -30.457  1.00 42.60           C
ATOM     22  O   GLY    18       0.076   7.810 -31.101  1.00 42.85           O
ATOM     23  N   SER    19      -0.307   6.181 -29.585  1.00 42.31           N
ATOM     24  CA  SER    19       1.072   5.726 -29.489  1.00 42.39           C
ATOM     25  CB  SER    19       1.619   5.896 -28.064  1.00 42.36           C
ATOM     26  OG  SER    19       0.587   5.887 -27.093  1.00 42.96           O
ATOM     27  C   SER    19       1.163   4.271 -29.941  1.00 42.11           C
ATOM     28  O   SER    19       0.137   3.601 -30.090  1.00 41.98           O
ATOM     29  N   THR    20       2.383   3.795 -30.184  1.00 41.82           N
ATOM     30  CA  THR    20       2.589   2.409 -30.621  1.00 41.73           C
ATOM     31  CB  THR    20       2.782   2.281 -32.169  1.00 42.00           C
ATOM     32  OG1 THR    20       3.527   3.396 -32.676  1.00 43.01           O
ATOM     33  CG2 THR    20       1.436   2.230 -32.869  1.00 42.35           C
ATOM     34  C   THR    20       3.695   1.665 -29.868  1.00 41.10           C
ATOM     35  O   THR    20       3.697   0.433 -29.827  1.00 40.61           O
ATOM     36  N   TYR    21       4.618   2.409 -29.262  1.00 40.69           N
ATOM     37  CA  TYR    21       5.727   1.797 -28.522  1.00 40.62           C
ATOM     38  CB  TYR    21       7.054   1.991 -29.266  1.00 40.68           C
ATOM     39  CG  TYR    21       7.066   1.498 -30.703  1.00 41.20           C
ATOM     40  CD1 TYR    21       7.174   0.139 -30.999  1.00 41.51           C
ATOM     41  CE1 TYR    21       7.197  -0.310 -32.319  1.00 41.33           C
ATOM     42  CZ  TYR    21       7.127   0.606 -33.353  1.00 41.22           C
ATOM     43  OH  TYR    21       7.151   0.170 -34.664  1.00 41.87           O
ATOM     44  CE2 TYR    21       7.029   1.959 -33.082  1.00 40.53           C
ATOM     45  CD2 TYR    21       6.999   2.396 -31.765  1.00 40.72           C
ATOM     46  C   TYR    21       5.850   2.334 -27.093  1.00 40.34           C
ATOM     47  O   TYR    21       5.313   3.394 -26.773  1.00 40.03           O
ATOM     48  N   LYS    22       6.563   1.591 -26.246  1.00 40.34           N
ATOM     49  CA  LYS    22       6.869   2.030 -24.881  1.00 40.51           C
ATOM     50  CB  LYS    22       6.048   1.233 -23.863  1.00 41.02           C
ATOM     51  CG  LYS    22       6.058   1.805 -22.457  1.00 42.74           C
ATOM     52  CD  LYS    22       4.996   1.139 -21.596  1.00 46.09           C
ATOM     53  CE  LYS    22       5.533  -0.108 -20.888  1.00 47.70           C
ATOM     54  NZ  LYS    22       4.496  -0.659 -19.953  1.00 49.57           N
ATOM     55  C   LYS    22       8.359   1.889 -24.601  1.00 39.98           C
ATOM     56  O   LYS    22       8.948   0.836 -24.856  1.00 40.70           O
ATOM     57  N   LEU    23       8.974   2.959 -24.102  1.00 38.77           N
ATOM     58  CA  LEU    23      10.398   2.948 -23.776  1.00 37.50           C
ATOM     59  CB  LEU    23      11.189   3.817 -24.762  1.00 37.19           C
ATOM     60  CG  LEU    23      12.679   4.071 -24.516  1.00 36.95           C
ATOM     61  CD1 LEU    23      13.503   2.784 -24.661  1.00 37.76           C
ATOM     62  CD2 LEU    23      13.221   5.178 -25.427  1.00 37.04           C
ATOM     63  C   LEU    23      10.584   3.440 -22.335  1.00 37.27           C
ATOM     64  O   LEU    23       9.962   4.424 -21.925  1.00 36.33           O
ATOM     65  N   THR    24      11.423   2.739 -21.576  1.00 36.79           N
ATOM     66  CA  THR    24      11.666   3.090 -20.176  1.00 36.78           C
ATOM     67  CB  THR    24      11.398   1.892 -19.230  1.00 36.75           C
ATOM     68  OG1 THR    24      10.121   1.320 -19.539  1.00 36.82           O
ATOM     69  CG2 THR    24      11.385   2.343 -17.761  1.00 36.57           C
ATOM     70  C   THR    24      13.077   3.632 -19.966  1.00 36.94           C
ATOM     71  O   THR    24      14.058   3.066 -20.453  1.00 36.88           O
ATOM     72  N   LEU    25      13.161   4.739 -19.239  1.00 36.81           N
ATOM     73  CA  LEU    25      14.436   5.357 -18.915  1.00 36.43           C
ATOM     74  CB  LEU    25      14.515   6.786 -19.476  1.00 36.25           C
ATOM     75  CG  LEU    25      14.017   7.091 -20.903  1.00 36.29           C
ATOM     76  CD1 LEU    25      14.221   8.553 -21.254  1.00 35.89           C
ATOM     77  CD2 LEU    25      14.674   6.198 -21.954  1.00 35.43           C
ATOM     78  C   LEU    25      14.624   5.386 -17.398  1.00 36.56           C
ATOM     79  O   LEU    25      13.661   5.571 -16.644  1.00 36.67           O
ATOM     80  N   ILE    26      15.863   5.208 -16.962  1.00 36.38           N
ATOM     81  CA  ILE    26      16.215   5.408 -15.554  1.00 36.63           C
ATOM     82  CB  ILE    26      16.056   4.094 -14.724  1.00 36.69           C
ATOM     83  CG1 ILE    26      16.110   4.390 -13.214  1.00 37.79           C
ATOM     84  CD1 ILE    26      15.721   3.203 -12.332  1.00 36.73           C
ATOM     85  CG2 ILE    26      17.088   3.044 -15.150  1.00 36.59           C
ATOM     86  C   ILE    26      17.633   5.961 -15.440  1.00 36.08           C
ATOM     87  O   ILE    26      18.536   5.488 -16.118  1.00 36.28           O
ATOM     88  N   ARG    27      17.819   6.993 -14.621  1.00 35.36           N
ATOM     89  CA  ARG    27      19.173   7.414 -14.269  1.00 34.90           C
ATOM     90  CB  ARG    27      19.331   8.943 -14.262  1.00 35.09           C
ATOM     91  CG  ARG    27      18.849   9.623 -13.002  1.00 35.28           C
ATOM     92  CD  ARG    27      18.829  11.134 -13.122  1.00 35.63           C
ATOM     93  NE  ARG    27      20.147  11.750 -12.945  1.00 36.67           N
ATOM     94  CZ  ARG    27      20.347  13.060 -12.799  1.00 37.84           C
ATOM     95  NH1 ARG    27      21.576  13.540 -12.663  1.00 39.23           N
ATOM     96  NH2 ARG    27      19.318  13.896 -12.779  1.00 37.07           N
ATOM     97  C   ARG    27      19.510   6.805 -12.904  1.00 34.45           C
ATOM     98  O   ARG    27      18.614   6.527 -12.097  1.00 34.16           O
ATOM     99  N   HIS    28      20.796   6.596 -12.659  1.00 33.55           N
ATOM    100  CA  HIS    28      21.233   5.950 -11.428  1.00 33.94           C
ATOM    101  CB  HIS    28      22.705   5.537 -11.534  1.00 33.32           C
ATOM    102  CG  HIS    28      23.628   6.674 -11.824  1.00 34.33           C
ATOM    103  ND1 HIS    28      24.062   7.548 -10.848  1.00 33.63           N
ATOM    104  CE1 HIS    28      24.862   8.448 -11.394  1.00 34.48           C
ATOM    105  NE2 HIS    28      24.956   8.193 -12.687  1.00 35.33           N
ATOM    106  CD2 HIS    28      24.194   7.090 -12.982  1.00 33.24           C
ATOM    107  C   HIS    28      21.002   6.843 -10.207  1.00 33.48           C
ATOM    108  O   HIS    28      20.785   8.060 -10.331  1.00 33.41           O
ATOM    109  N   GLY    29      21.049   6.228  -9.030  1.00 34.05           N
ATOM    110  CA  GLY    29      20.954   6.967  -7.779  1.00 33.99           C
ATOM    111  C   GLY    29      22.311   7.524  -7.381  1.00 34.35           C
ATOM    112  O   GLY    29      23.238   7.576  -8.200  1.00 33.97           O
ATOM    113  N   GLU    30      22.456   7.915  -6.116  1.00 34.09           N
ATOM    114  CA  GLU    30      23.649   8.666  -5.752  1.00 34.45           C
ATOM    115  CB  GLU    30      23.509   9.422  -4.420  1.00 35.03           C
ATOM    116  CG  GLU    30      23.434   8.602  -3.185  1.00 37.41           C
ATOM    117  CD  GLU    30      24.046   9.322  -1.964  1.00 38.48           C
ATOM    118  OE1 GLU    30      23.689  10.492  -1.677  1.00 38.05           O
ATOM    119  OE2 GLU    30      24.889   8.699  -1.292  1.00 37.65           O
ATOM    120  C   GLU    30      24.942   7.872  -5.839  1.00 33.56           C
ATOM    121  O   GLU    30      25.030   6.725  -5.396  1.00 33.95           O
ATOM    122  N   SER    31      25.939   8.503  -6.436  1.00 32.59           N
ATOM    123  CA  SER    31      27.275   7.956  -6.487  1.00 31.99           C
ATOM    124  CB  SER    31      27.933   8.315  -7.821  1.00 32.21           C
ATOM    125  OG  SER    31      28.391   9.657  -7.786  1.00 31.17           O
ATOM    126  C   SER    31      28.095   8.545  -5.353  1.00 32.05           C
ATOM    127  O   SER    31      27.630   9.456  -4.649  1.00 30.99           O
ATOM    128  N   GLU    32      29.322   8.048  -5.200  1.00 32.37           N
ATOM    129  CA  GLU    32      30.228   8.564  -4.170  0.50 32.76           C
ATOM    131  CB  GLU    32      31.501   7.716  -4.074  0.50 32.69           C
ATOM    133  CG  GLU    32      31.276   6.324  -3.502  0.50 31.96           C
ATOM    135  CD  GLU    32      30.802   6.318  -2.044  0.50 31.88           C
ATOM    137  OE1 GLU    32      30.660   7.394  -1.420  0.50 32.35           O
ATOM    139  OE2 GLU    32      30.579   5.215  -1.518  0.50 30.81           O
ATOM    141  C   GLU    32      30.589  10.027  -4.386  1.00 33.33           C
ATOM    142  O   GLU    32      30.845  10.765  -3.428  1.00 32.84           O
ATOM    143  N   TRP    33      30.589  10.461  -5.639  1.00 33.20           N
ATOM    144  CA  TRP    33      30.939  11.848  -5.915  1.00 33.81           C
ATOM    145  CB  TRP    33      31.669  11.964  -7.256  1.00 33.88           C
ATOM    146  CG  TRP    33      33.140  11.658  -7.117  1.00 34.34           C
ATOM    147  CD1 TRP    33      33.751  10.999  -6.081  1.00 34.45           C
ATOM    148  NE1 TRP    33      35.101  10.910  -6.307  1.00 34.61           N
ATOM    149  CE2 TRP    33      35.391  11.512  -7.504  1.00 34.97           C
ATOM    150  CD2 TRP    33      34.176  11.996  -8.042  1.00 34.55           C
ATOM    151  CE3 TRP    33      34.197  12.665  -9.275  1.00 35.60           C
ATOM    152  CZ3 TRP    33      35.424  12.824  -9.929  1.00 35.20           C
ATOM    153  CH2 TRP    33      36.617  12.326  -9.362  1.00 34.76           C
ATOM    154  CZ2 TRP    33      36.618  11.670  -8.156  1.00 34.57           C
ATOM    155  C   TRP    33      29.760  12.809  -5.785  1.00 33.50           C
ATOM    156  O   TRP    33      29.960  13.984  -5.542  1.00 33.62           O
ATOM    157  N   ASN    34      28.540  12.301  -5.931  1.00 34.16           N
ATOM    158  CA  ASN    34      27.348  13.064  -5.558  1.00 35.06           C
ATOM    159  CB  ASN    34      26.067  12.258  -5.822  1.00 35.17           C
ATOM    160  CG  ASN    34      25.760  12.093  -7.298  1.00 37.36           C
ATOM    161  OD1 ASN    34      25.185  11.077  -7.709  1.00 37.98           O
ATOM    162  ND2 ASN    34      26.140  13.089  -8.113  1.00 37.86           N
ATOM    163  C   ASN    34      27.430  13.454  -4.073  1.00 34.65           C
ATOM    164  O   ASN    34      27.258  14.624  -3.710  1.00 34.80           O
ATOM    165  N   LYS    35      27.734  12.461  -3.234  1.00 34.86           N
ATOM    166  CA  LYS    35      27.946  12.635  -1.786  1.00 35.08           C
ATOM    167  CB  LYS    35      28.348  11.287  -1.183  1.00 35.53           C
ATOM    168  CG  LYS    35      27.896  11.070   0.228  1.00 38.14           C
ATOM    169  CD  LYS    35      27.703   9.582   0.486  1.00 41.47           C
ATOM    170  CE  LYS    35      27.231   9.329   1.902  1.00 42.70           C
ATOM    171  NZ  LYS    35      28.249   8.621   2.736  1.00 45.67           N
ATOM    172  C   LYS    35      29.014  13.691  -1.474  1.00 34.07           C
ATOM    173  O   LYS    35      28.845  14.519  -0.570  1.00 34.23           O
ATOM    174  N   GLU    36      30.104  13.660  -2.241  1.00 33.21           N
ATOM    175  CA  GLU    36      31.202  14.616  -2.117  1.00 32.64           C
ATOM    176  CB  GLU    36      32.522  13.979  -2.567  1.00 32.58           C
ATOM    177  CG  GLU    36      32.840  12.660  -1.886  1.00 33.69           C
ATOM    178  CD  GLU    36      34.191  12.101  -2.281  1.00 33.18           C
ATOM    179  OE1 GLU    36      35.053  12.866  -2.737  1.00 32.12           O
ATOM    180  OE2 GLU    36      34.390  10.882  -2.118  1.00 36.73           O
ATOM    181  C   GLU    36      30.954  15.889  -2.932  1.00 32.00           C
ATOM    182  O   GLU    36      31.815  16.761  -2.994  1.00 30.89           O
ATOM    183  N   ASN    37      29.786  15.976  -3.570  1.00 31.78           N
ATOM    184  CA  ASN    37      29.403  17.172  -4.319  1.00 32.40           C
ATOM    185  CB  ASN    37      29.089  18.320  -3.346  1.00 33.04           C
ATOM    186  CG  ASN    37      28.158  19.362  -3.934  1.00 34.80           C
ATOM    187  OD1 ASN    37      27.409  19.083  -4.867  1.00 38.32           O
ATOM    188  ND2 ASN    37      28.194  20.574  -3.377  1.00 36.05           N
ATOM    189  C   ASN    37      30.503  17.562  -5.319  1.00 31.93           C
ATOM    190  O   ASN    37      30.921  18.709  -5.380  1.00 31.46           O
ATOM    191  N   ARG    38      30.991  16.574  -6.067  1.00 31.97           N
ATOM    192  CA  ARG    38      32.009  16.809  -7.101  1.00 32.32           C
ATOM    193  CB  ARG    38      33.195  15.866  -6.934  1.00 32.10           C
ATOM    194  CG  ARG    38      33.924  16.038  -5.641  1.00 32.97           C
ATOM    195  CD  ARG    38      34.934  14.943  -5.435  1.00 33.01           C
ATOM    196  NE  ARG    38      35.534  15.068  -4.108  1.00 33.41           N
ATOM    197  CZ  ARG    38      36.581  15.834  -3.820  1.00 33.39           C
ATOM    198  NH1 ARG    38      37.162  16.558  -4.769  1.00 32.89           N
ATOM    199  NH2 ARG    38      37.046  15.882  -2.576  1.00 32.54           N
ATOM    200  C   ARG    38      31.438  16.610  -8.490  1.00 32.20           C
ATOM    201  O   ARG    38      30.568  15.758  -8.690  1.00 31.73           O
ATOM    202  N   PHE    39      31.946  17.385  -9.451  1.00 32.42           N
ATOM    203  CA  PHE    39      31.617  17.167 -10.867  1.00 32.57           C
ATOM    204  CB  PHE    39      32.142  18.302 -11.740  1.00 32.39           C
ATOM    205  CG  PHE    39      31.552  19.649 -11.421  1.00 33.02           C
ATOM    206  CD1 PHE    39      30.258  19.970 -11.826  1.00 33.44           C
ATOM    207  CE1 PHE    39      29.712  21.223 -11.553  1.00 33.55           C
ATOM    208  CZ  PHE    39      30.470  22.178 -10.872  1.00 33.10           C
ATOM    209  CE2 PHE    39      31.769  21.869 -10.471  1.00 33.11           C
ATOM    210  CD2 PHE    39      32.301  20.607 -10.746  1.00 32.76           C
ATOM    211  C   PHE    39      32.229  15.843 -11.316  1.00 32.75           C
ATOM    212  O   PHE    39      33.418  15.614 -11.131  1.00 33.37           O
ATOM    213  N   THR    40      31.407  14.972 -11.884  1.00 33.17           N
ATOM    214  CA  THR    40      31.829  13.613 -12.236  1.00 34.16           C
ATOM    215  CB  THR    40      30.786  12.572 -11.740  1.00 34.53           C
ATOM    216  OG1 THR    40      30.500  12.808 -10.353  1.00 35.47           O
ATOM    217  CG2 THR    40      31.299  11.138 -11.922  1.00 34.77           C
ATOM    218  C   THR    40      32.091  13.422 -13.751  1.00 34.08           C
ATOM    219  O   THR    40      33.203  13.068 -14.163  1.00 33.66           O
ATOM    220  N   GLY    41      31.067  13.650 -14.568  1.00 34.52           N
ATOM    221  CA  GLY    41      31.182  13.398 -16.023  1.00 34.46           C
ATOM    222  C   GLY    41      31.556  11.957 -16.317  1.00 34.79           C
ATOM    223  O   GLY    41      30.870  11.038 -15.869  1.00 34.95           O
ATOM    224  N   TRP    42      32.666  11.751 -17.032  1.00 35.31           N
ATOM    225  CA  TRP    42      33.088  10.395 -17.410  1.00 35.67           C
ATOM    226  CB  TRP    42      33.867  10.380 -18.735  1.00 36.24           C
ATOM    227  CG  TRP    42      33.018  10.515 -19.970  1.00 36.19           C
ATOM    228  CD1 TRP    42      31.896  11.274 -20.114  1.00 36.55           C
ATOM    229  NE1 TRP    42      31.418  11.179 -21.397  1.00 35.69           N
ATOM    230  CE2 TRP    42      32.252  10.371 -22.126  1.00 36.43           C
ATOM    231  CD2 TRP    42      33.276   9.933 -21.262  1.00 37.18           C
ATOM    232  CE3 TRP    42      34.265   9.077 -21.764  1.00 36.96           C
ATOM    233  CZ3 TRP    42      34.197   8.682 -23.103  1.00 37.15           C
ATOM    234  CH2 TRP    42      33.156   9.122 -23.935  1.00 36.07           C
ATOM    235  CZ2 TRP    42      32.174   9.960 -23.470  1.00 37.10           C
ATOM    236  C   TRP    42      33.898   9.667 -16.348  1.00 35.61           C
ATOM    237  O   TRP    42      34.220   8.485 -16.526  1.00 35.71           O
ATOM    238  N   THR    43      34.223  10.351 -15.252  1.00 35.17           N
ATOM    239  CA  THR    43      34.933   9.703 -14.158  1.00 34.66           C
ATOM    240  CB  THR    43      35.150  10.637 -12.946  1.00 34.84           C
ATOM    241  OG1 THR    43      35.472  11.958 -13.407  1.00 35.01           O
ATOM    242  CG2 THR    43      36.291  10.110 -12.083  1.00 35.20           C
ATOM    243  C   THR    43      34.146   8.472 -13.752  1.00 33.88           C
ATOM    244  O   THR    43      32.933   8.529 -13.538  1.00 34.02           O
ATOM    245  N   ASP    44      34.840   7.349 -13.674  1.00 33.41           N
ATOM    246  CA  ASP    44      34.172   6.087 -13.455  1.00 33.62           C
ATOM    247  CB  ASP    44      34.938   4.971 -14.158  1.00 33.45           C
ATOM    248  CG  ASP    44      34.109   3.732 -14.341  1.00 33.89           C
ATOM    249  OD1 ASP    44      32.866   3.811 -14.277  1.00 33.89           O
ATOM    250  OD2 ASP    44      34.711   2.669 -14.558  1.00 36.82           O
ATOM    251  C   ASP    44      34.024   5.797 -11.955  1.00 33.82           C
ATOM    252  O   ASP    44      34.673   4.901 -11.428  1.00 33.58           O
ATOM    253  N   VAL    45      33.154   6.554 -11.288  1.00 33.77           N
ATOM    254  CA  VAL    45      32.963   6.417  -9.833  1.00 33.86           C
ATOM    255  CB  VAL    45      32.709   7.787  -9.138  1.00 33.79           C
ATOM    256  CG1 VAL    45      33.816   8.771  -9.480  1.00 33.72           C
ATOM    257  CG2 VAL    45      31.339   8.351  -9.512  1.00 33.81           C
ATOM    258  C   VAL    45      31.884   5.400  -9.453  1.00 33.66           C
ATOM    259  O   VAL    45      30.982   5.074 -10.250  1.00 32.93           O
ATOM    260  N   SER    46      31.975   4.901  -8.222  1.00 33.11           N
ATOM    261  CA  SER    46      31.026   3.917  -7.732  1.00 33.29           C
ATOM    262  CB  SER    46      31.633   3.132  -6.567  1.00 33.85           C
ATOM    263  OG  SER    46      32.803   2.456  -6.984  1.00 36.09           O
ATOM    264  C   SER    46      29.751   4.596  -7.277  1.00 32.81           C
ATOM    265  O   SER    46      29.764   5.767  -6.912  1.00 33.26           O
ATOM    266  N   LEU    47      28.650   3.855  -7.306  1.00 32.54           N
ATOM    267  CA  LEU    47      27.468   4.193  -6.518  1.00 32.49           C
ATOM    268  CB  LEU    47      26.377   3.138  -6.714  1.00 32.93           C
ATOM    269  CG  LEU    47      25.667   3.028  -8.064  1.00 32.58           C
ATOM    270  CD1 LEU    47      24.764   1.816  -8.009  1.00 32.69           C
ATOM    271  CD2 LEU    47      24.870   4.294  -8.356  1.00 32.75           C
ATOM    272  C   LEU    47      27.829   4.188  -5.032  1.00 32.30           C
ATOM    273  O   LEU    47      28.713   3.436  -4.610  1.00 31.27           O
ATOM    274  N   SER    48      27.145   5.015  -4.245  1.00 31.96           N
ATOM    275  CA  SER    48      27.243   4.910  -2.790  1.00 31.91           C
ATOM    276  CB  SER    48      26.810   6.208  -2.124  1.00 31.87           C
ATOM    277  OG  SER    48      25.451   6.467  -2.431  1.00 32.49           O
ATOM    278  C   SER    48      26.319   3.772  -2.378  1.00 32.21           C
ATOM    279  O   SER    48      25.594   3.210  -3.225  1.00 31.75           O
ATOM    280  N   GLU    49      26.332   3.419  -1.091  1.00 31.18           N
ATOM    281  CA  GLU    49      25.379   2.430  -0.598  1.00 32.12           C
ATOM    282  CB  GLU    49      25.655   2.029   0.860  0.50 31.57           C
ATOM    283  CG  GLU    49      27.002   1.378   1.083  0.50 31.74           C
ATOM    284  CD  GLU    49      27.957   2.292   1.798  0.50 32.54           C
ATOM    285  OE1 GLU    49      28.748   2.980   1.110  0.50 33.75           O
ATOM    286  OE2 GLU    49      27.899   2.336   3.050  0.50 31.43           O
ATOM    287  C   GLU    49      23.948   2.920  -0.724  1.00 32.23           C
ATOM    288  O   GLU    49      23.030   2.120  -0.948  1.00 32.56           O
ATOM    289  N   GLN    50      23.751   4.225  -0.575  1.00 32.52           N
ATOM    290  CA  GLN    50      22.431   4.796  -0.779  1.00 33.73           C
ATOM    291  CB  GLN    50      22.380   6.273  -0.379  1.00 33.81           C
ATOM    292  CG  GLN    50      20.985   6.904  -0.541  1.00 35.48           C
ATOM    293  CD  GLN    50      20.975   8.396  -0.260  1.00 35.57           C
ATOM    294  OE1 GLN    50      21.376   8.841   0.816  1.00 36.86           O
ATOM    295  NE2 GLN    50      20.512   9.181  -1.234  1.00 37.60           N
ATOM    296  C   GLN    50      21.986   4.605  -2.236  1.00 33.04           C
ATOM    297  O   GLN    50      20.845   4.245  -2.488  1.00 33.49           O
ATOM    298  N   GLY    51      22.900   4.832  -3.177  1.00 32.97           N
ATOM    299  CA  GLY    51      22.615   4.675  -4.608  1.00 32.35           C
ATOM    300  C   GLY    51      22.246   3.250  -4.989  1.00 32.09           C
ATOM    301  O   GLY    51      21.375   3.039  -5.841  1.00 31.69           O
ATOM    302  N   VAL    52      22.914   2.276  -4.369  1.00 31.78           N
ATOM    303  CA  VAL    52      22.532   0.861  -4.500  1.00 31.95           C
ATOM    304  CB  VAL    52      23.518  -0.099  -3.781  1.00 32.25           C
ATOM    305  CG1 VAL    52      23.039  -1.543  -3.938  1.00 32.09           C
ATOM    306  CG2 VAL    52      24.947   0.063  -4.329  1.00 31.78           C
ATOM    307  C   VAL    52      21.125   0.617  -3.965  1.00 32.14           C
ATOM    308  O   VAL    52      20.308  -0.076  -4.594  1.00 32.12           O
ATOM    309  N   SER    53      20.843   1.181  -2.788  1.00 32.59           N
ATOM    310  CA  SER    53      19.529   1.049  -2.191  1.00 32.38           C
ATOM    311  CB  SER    53      19.486   1.665  -0.791  1.00 32.24           C
ATOM    312  OG  SER    53      18.252   1.342  -0.187  1.00 32.93           O
ATOM    313  C   SER    53      18.440   1.659  -3.081  1.00 32.20           C
ATOM    314  O   SER    53      17.351   1.096  -3.198  1.00 31.94           O
ATOM    315  N   GLU    54      18.740   2.805  -3.685  1.00 32.34           N
ATOM    316  CA  GLU    54      17.799   3.484  -4.581  1.00 33.40           C
ATOM    317  CB  GLU    54      18.311   4.878  -4.958  1.00 32.96           C
ATOM    318  CG  GLU    54      18.227   5.872  -3.799  1.00 34.07           C
ATOM    319  CD  GLU    54      19.065   7.135  -4.004  1.00 34.86           C
ATOM    320  OE1 GLU    54      20.038   7.126  -4.804  1.00 33.51           O
ATOM    321  OE2 GLU    54      18.741   8.148  -3.337  1.00 37.18           O
ATOM    322  C   GLU    54      17.496   2.630  -5.824  1.00 33.25           C
ATOM    323  O   GLU    54      16.343   2.552  -6.256  1.00 33.98           O
ATOM    324  N   ALA    55      18.527   1.972  -6.351  1.00 33.44           N
ATOM    325  CA  ALA    55      18.387   0.991  -7.439  1.00 34.05           C
ATOM    326  CB  ALA    55      19.754   0.469  -7.843  1.00 33.84           C
ATOM    327  C   ALA    55      17.466  -0.167  -7.036  1.00 34.33           C
ATOM    328  O   ALA    55      16.620  -0.594  -7.818  1.00 34.67           O
ATOM    329  N   ILE    56      17.628  -0.654  -5.803  1.00 34.35           N
ATOM    330  CA  ILE    56      16.794  -1.731  -5.266  1.00 34.06           C
ATOM    331  CB  ILE    56      17.291  -2.201  -3.867  1.00 33.62           C
ATOM    332  CG1 ILE    56      18.619  -2.962  -4.001  1.00 33.63           C
ATOM    333  CD1 ILE    56      19.406  -3.169  -2.680  1.00 33.87           C
ATOM    334  CG2 ILE    56      16.234  -3.066  -3.161  1.00 33.71           C
ATOM    335  C   ILE    56      15.321  -1.301  -5.233  1.00 34.31           C
ATOM    336  O   ILE    56      14.435  -2.058  -5.647  1.00 35.03           O
ATOM    337  N   GLU    57      15.073  -0.085  -4.752  1.00 33.72           N
ATOM    338  CA  GLU    57      13.736   0.507  -4.700  0.50 33.72           C
ATOM    340  CB  GLU    57      13.844   1.896  -4.060  0.50 33.73           C
ATOM    342  CG  GLU    57      12.596   2.421  -3.386  0.50 33.68           C
ATOM    344  CD  GLU    57      12.866   3.673  -2.552  0.50 33.53           C
ATOM    346  OE1 GLU    57      14.036   3.918  -2.173  0.50 32.94           O
ATOM    348  OE2 GLU    57      11.903   4.414  -2.270  0.50 32.34           O
ATOM    350  C   GLU    57      13.119   0.606  -6.105  1.00 33.66           C
ATOM    351  O   GLU    57      11.951   0.282  -6.322  1.00 33.27           O
ATOM    352  N   ALA    58      13.926   1.074  -7.059  1.00 33.72           N
ATOM    353  CA  ALA    58      13.496   1.193  -8.463  1.00 33.59           C
ATOM    354  CB  ALA    58      14.605   1.792  -9.305  1.00 33.90           C
ATOM    355  C   ALA    58      13.076  -0.157  -9.039  1.00 33.56           C
ATOM    356  O   ALA    58      12.035  -0.266  -9.677  1.00 33.69           O
ATOM    357  N   GLY    59      13.903  -1.175  -8.818  1.00 33.67           N
ATOM    358  CA  GLY    59      13.615  -2.533  -9.256  1.00 34.08           C
ATOM    359  C   GLY    59      12.293  -3.034  -8.701  1.00 34.39           C
ATOM    360  O   GLY    59      11.438  -3.524  -9.447  1.00 34.00           O
ATOM    361  N   ARG    60      12.123  -2.893  -7.388  1.00 34.72           N
ATOM    362  CA  ARG    60      10.879  -3.279  -6.711  1.00 35.21           C
ATOM    363  CB  ARG    60      11.007  -3.059  -5.207  1.00 35.36           C
ATOM    364  CG  ARG    60      11.960  -4.032  -4.578  1.00 37.55           C
ATOM    365  CD  ARG    60      12.089  -3.810  -3.091  1.00 41.47           C
ATOM    366  NE  ARG    60      12.937  -4.841  -2.506  1.00 44.39           N
ATOM    367  CZ  ARG    60      13.493  -4.763  -1.303  1.00 46.09           C
ATOM    368  NH1 ARG    60      14.244  -5.763  -0.864  1.00 47.23           N
ATOM    369  NH2 ARG    60      13.305  -3.688  -0.546  1.00 46.23           N
ATOM    370  C   ARG    60       9.646  -2.556  -7.248  1.00 35.40           C
ATOM    371  O   ARG    60       8.576  -3.162  -7.385  1.00 35.18           O
ATOM    372  N   MET    61       9.798  -1.269  -7.556  1.00 35.75           N
ATOM    373  CA  MET    61       8.717  -0.482  -8.148  1.00 36.44           C
ATOM    374  CB  MET    61       9.143   0.985  -8.281  1.00 36.93           C
ATOM    375  CG  MET    61       8.278   1.821  -9.220  1.00 38.99           C
ATOM    376  SD  MET    61       6.860   2.631  -8.463  1.00 44.69           S
ATOM    377  CE  MET    61       5.738   1.283  -8.083  1.00 43.18           C
ATOM    378  C   MET    61       8.319  -1.064  -9.514  1.00 36.30           C
ATOM    379  O   MET    61       7.135  -1.307  -9.784  1.00 36.10           O
ATOM    380  N   LEU    62       9.326  -1.301 -10.351  1.00 36.02           N
ATOM    381  CA  LEU    62       9.137  -1.900 -11.670  1.00 36.05           C
ATOM    382  CB  LEU    62      10.474  -1.988 -12.421  1.00 35.86           C
ATOM    383  CG  LEU    62      11.058  -0.677 -12.977  1.00 35.78           C
ATOM    384  CD1 LEU    62      12.555  -0.775 -13.218  1.00 33.76           C
ATOM    385  CD2 LEU    62      10.341  -0.221 -14.252  1.00 35.60           C
ATOM    386  C   LEU    62       8.458  -3.268 -11.587  1.00 36.18           C
ATOM    387  O   LEU    62       7.562  -3.567 -12.380  1.00 35.96           O
ATOM    388  N   LEU    63       8.870  -4.086 -10.619  1.00 36.40           N
ATOM    389  CA  LEU    63       8.260  -5.401 -10.415  1.00 36.78           C
ATOM    390  CB  LEU    63       9.028  -6.210  -9.363  1.00 36.97           C
ATOM    391  CG  LEU    63       8.452  -7.587  -8.996  1.00 36.90           C
ATOM    392  CD1 LEU    63       8.666  -8.591 -10.128  1.00 37.12           C
ATOM    393  CD2 LEU    63       9.049  -8.099  -7.694  1.00 36.80           C
ATOM    394  C   LEU    63       6.791  -5.286 -10.020  1.00 37.20           C
ATOM    395  O   LEU    63       5.954  -6.069 -10.473  1.00 36.89           O
ATOM    396  N   GLU    64       6.493  -4.305  -9.173  1.00 37.73           N
ATOM    397  CA  GLU    64       5.124  -4.029  -8.745  1.00 38.53           C
ATOM    398  CB  GLU    64       5.120  -2.946  -7.665  1.00 38.29           C
ATOM    399  CG  GLU    64       3.784  -2.768  -6.954  1.00 39.11           C
ATOM    400  CD  GLU    64       3.798  -1.636  -5.936  1.00 39.17           C
ATOM    401  OE1 GLU    64       4.897  -1.146  -5.584  1.00 40.25           O
ATOM    402  OE2 GLU    64       2.703  -1.236  -5.483  1.00 40.81           O
ATOM    403  C   GLU    64       4.254  -3.597  -9.932  1.00 38.68           C
ATOM    404  O   GLU    64       3.073  -3.929  -9.993  1.00 38.64           O
ATOM    405  N   LYS    65       4.856  -2.866 -10.870  1.00 39.17           N
ATOM    406  CA  LYS    65       4.136  -2.349 -12.034  1.00 39.60           C
ATOM    407  CB  LYS    65       4.727  -0.999 -12.475  1.00 39.72           C
ATOM    408  CG  LYS    65       4.554   0.151 -11.467  1.00 39.83           C
ATOM    409  CD  LYS    65       3.087   0.481 -11.208  1.00 40.71           C
ATOM    410  CE  LYS    65       2.925   1.634 -10.227  1.00 40.26           C
ATOM    411  NZ  LYS    65       1.499   1.872  -9.893  1.00 41.55           N
ATOM    412  C   LYS    65       4.078  -3.348 -13.207  1.00 39.72           C
ATOM    413  O   LYS    65       3.492  -3.055 -14.253  1.00 39.71           O
ATOM    414  N   GLY    66       4.684  -4.521 -13.021  1.00 39.85           N
ATOM    415  CA  GLY    66       4.591  -5.622 -13.984  1.00 39.84           C
ATOM    416  C   GLY    66       5.527  -5.507 -15.174  1.00 39.91           C
ATOM    417  O   GLY    66       5.189  -5.935 -16.285  1.00 39.63           O
ATOM    418  N   PHE    67       6.705  -4.936 -14.938  1.00 39.71           N
ATOM    419  CA  PHE    67       7.687  -4.731 -15.993  1.00 39.94           C
ATOM    420  CB  PHE    67       8.503  -3.458 -15.746  1.00 40.02           C
ATOM    421  CG  PHE    67       7.802  -2.194 -16.162  1.00 40.18           C
ATOM    422  CD1 PHE    67       6.776  -1.662 -15.390  1.00 39.86           C
ATOM    423  CE1 PHE    67       6.129  -0.487 -15.777  1.00 40.89           C
ATOM    424  CZ  PHE    67       6.513   0.168 -16.945  1.00 40.65           C
ATOM    425  CE2 PHE    67       7.547  -0.353 -17.717  1.00 41.16           C
ATOM    426  CD2 PHE    67       8.183  -1.528 -17.322  1.00 40.79           C
ATOM    427  C   PHE    67       8.625  -5.917 -16.147  1.00 40.17           C
ATOM    428  O   PHE    67       9.028  -6.549 -15.161  1.00 40.07           O
ATOM    429  N   LYS    68       8.960  -6.200 -17.404  1.00 39.98           N
ATOM    430  CA  LYS    68       9.930  -7.214 -17.773  1.00 39.93           C
ATOM    431  CB  LYS    68       9.219  -8.543 -18.052  1.00 40.62           C
ATOM    432  CG  LYS    68      10.136  -9.769 -18.087  1.00 42.75           C
ATOM    433  CD  LYS    68      10.342 -10.354 -16.693  1.00 45.92           C
ATOM    434  CE  LYS    68      10.955 -11.752 -16.754  1.00 47.15           C
ATOM    435  NZ  LYS    68      11.238 -12.289 -15.391  1.00 48.04           N
ATOM    436  C   LYS    68      10.627  -6.702 -19.031  1.00 39.37           C
ATOM    437  O   LYS    68       9.970  -6.226 -19.956  1.00 39.65           O
ATOM    438  N   PHE    69      11.952  -6.768 -19.061  1.00 38.43           N
ATOM    439  CA  PHE    69      12.696  -6.229 -20.195  1.00 37.91           C
ATOM    440  CB  PHE    69      13.732  -5.196 -19.738  1.00 37.62           C
ATOM    441  CG  PHE    69      13.120  -4.019 -19.051  1.00 36.48           C
ATOM    442  CD1 PHE    69      13.329  -3.806 -17.688  1.00 37.05           C
ATOM    443  CE1 PHE    69      12.732  -2.727 -17.035  1.00 34.85           C
ATOM    444  CZ  PHE    69      11.907  -1.855 -17.747  1.00 35.91           C
ATOM    445  CE2 PHE    69      11.677  -2.071 -19.107  1.00 35.98           C
ATOM    446  CD2 PHE    69      12.277  -3.155 -19.748  1.00 36.35           C
ATOM    447  C   PHE    69      13.323  -7.315 -21.040  1.00 37.88           C
ATOM    448  O   PHE    69      13.679  -8.378 -20.536  1.00 37.72           O
ATOM    449  N   ASP    70      13.429  -7.035 -22.337  1.00 38.15           N
ATOM    450  CA  ASP    70      13.995  -7.966 -23.302  1.00 38.06           C
ATOM    451  CB  ASP    70      13.194  -7.917 -24.609  1.00 38.07           C
ATOM    452  CG  ASP    70      11.793  -8.472 -24.462  1.00 38.79           C
ATOM    453  OD1 ASP    70      11.642  -9.574 -23.887  1.00 40.55           O
ATOM    454  OD2 ASP    70      10.836  -7.819 -24.944  1.00 38.71           O
ATOM    455  C   ASP    70      15.433  -7.579 -23.558  1.00 37.78           C
ATOM    456  O   ASP    70      16.255  -8.403 -23.969  1.00 37.90           O
ATOM    457  N   VAL    71      15.725  -6.303 -23.324  1.00 37.30           N
ATOM    458  CA  VAL    71      17.070  -5.771 -23.445  1.00 36.24           C
ATOM    459  CB  VAL    71      17.466  -5.479 -24.932  1.00 36.55           C
ATOM    460  CG1 VAL    71      16.560  -4.412 -25.558  1.00 35.47           C
ATOM    461  CG2 VAL    71      18.931  -5.075 -25.031  1.00 35.54           C
ATOM    462  C   VAL    71      17.196  -4.505 -22.603  1.00 36.08           C
ATOM    463  O   VAL    71      16.223  -3.759 -22.432  1.00 35.77           O
ATOM    464  N   VAL    72      18.397  -4.305 -22.066  1.00 35.43           N
ATOM    465  CA  VAL    72      18.774  -3.072 -21.396  1.00 35.43           C
ATOM    466  CB  VAL    72      19.109  -3.292 -19.871  1.00 35.12           C
ATOM    467  CG1 VAL    72      19.429  -1.958 -19.188  1.00 34.48           C
ATOM    468  CG2 VAL    72      17.944  -3.984 -19.144  1.00 35.05           C
ATOM    469  C   VAL    72      19.984  -2.476 -22.112  1.00 35.07           C
ATOM    470  O   VAL    72      20.966  -3.174 -22.370  1.00 35.12           O
ATOM    471  N   TYR    73      19.891  -1.192 -22.448  1.00 34.95           N
ATOM    472  CA  TYR    73      21.064  -0.430 -22.865  1.00 35.07           C
ATOM    473  CB  TYR    73      20.773   0.433 -24.096  1.00 35.00           C
ATOM    474  CG  TYR    73      20.390  -0.405 -25.298  1.00 33.94           C
ATOM    475  CD1 TYR    73      19.058  -0.669 -25.584  1.00 33.44           C
ATOM    476  CE1 TYR    73      18.701  -1.454 -26.684  1.00 33.90           C
ATOM    477  CZ  TYR    73      19.698  -1.982 -27.492  1.00 33.88           C
ATOM    478  OH  TYR    73      19.364  -2.764 -28.588  1.00 35.31           O
ATOM    479  CE2 TYR    73      21.022  -1.742 -27.217  1.00 32.49           C
ATOM    480  CD2 TYR    73      21.369  -0.960 -26.122  1.00 32.81           C
ATOM    481  C   TYR    73      21.566   0.438 -21.733  1.00 35.94           C
ATOM    482  O   TYR    73      20.809   1.199 -21.113  1.00 36.29           O
ATOM    483  N   THR    74      22.860   0.330 -21.484  1.00 36.24           N
ATOM    484  CA  THR    74      23.479   1.099 -20.445  1.00 36.43           C
ATOM    485  CB  THR    74      23.655   0.235 -19.141  1.00 36.82           C
ATOM    486  OG1 THR    74      23.996   1.087 -18.038  1.00 35.67           O
ATOM    487  CG2 THR    74      24.707  -0.830 -19.302  1.00 35.45           C
ATOM    488  C   THR    74      24.786   1.687 -20.969  1.00 36.50           C
ATOM    489  O   THR    74      25.174   1.427 -22.104  1.00 36.31           O
ATOM    490  N   SER    75      25.461   2.472 -20.138  1.00 36.37           N
ATOM    491  CA  SER    75      26.745   3.052 -20.487  1.00 36.03           C
ATOM    492  CB  SER    75      26.922   4.405 -19.773  1.00 35.97           C
ATOM    493  OG  SER    75      27.168   4.244 -18.388  1.00 36.59           O
ATOM    494  C   SER    75      27.884   2.093 -20.155  1.00 35.59           C
ATOM    495  O   SER    75      27.652   0.935 -19.784  1.00 36.44           O
ATOM    496  N   VAL    76      29.116   2.562 -20.300  1.00 34.97           N
ATOM    497  CA  VAL    76      30.276   1.780 -19.872  1.00 35.09           C
ATOM    498  CB  VAL    76      31.451   1.855 -20.879  1.00 34.60           C
ATOM    499  CG1 VAL    76      31.048   1.259 -22.259  1.00 34.40           C
ATOM    500  CG2 VAL    76      31.953   3.281 -21.023  1.00 35.44           C
ATOM    501  C   VAL    76      30.742   2.174 -18.449  1.00 34.85           C
ATOM    502  O   VAL    76      31.792   1.743 -17.982  1.00 34.70           O
ATOM    503  N   LEU    77      29.950   2.996 -17.776  1.00 35.33           N
ATOM    504  CA  LEU    77      30.332   3.509 -16.449  1.00 35.55           C
ATOM    505  CB  LEU    77      29.913   4.979 -16.289  1.00 35.24           C
ATOM    506  CG  LEU    77      30.505   5.943 -17.327  1.00 35.95           C
ATOM    507  CD1 LEU    77      29.858   7.308 -17.265  1.00 34.26           C
ATOM    508  CD2 LEU    77      31.985   6.070 -17.126  1.00 36.02           C
ATOM    509  C   LEU    77      29.719   2.652 -15.356  1.00 35.07           C
ATOM    510  O   LEU    77      28.514   2.451 -15.323  1.00 34.68           O
ATOM    511  N   LYS    78      30.561   2.171 -14.450  1.00 35.71           N
ATOM    512  CA  LYS    78      30.129   1.195 -13.454  1.00 35.54           C
ATOM    513  CB  LYS    78      31.308   0.729 -12.591  1.00 36.31           C
ATOM    514  CG  LYS    78      31.994   1.765 -11.729  1.00 37.98           C
ATOM    515  CD  LYS    78      33.208   1.110 -11.076  1.00 40.55           C
ATOM    516  CE  LYS    78      34.071   2.087 -10.336  1.00 42.72           C
ATOM    517  NZ  LYS    78      35.227   1.394  -9.707  1.00 45.27           N
ATOM    518  C   LYS    78      28.895   1.554 -12.606  1.00 35.52           C
ATOM    519  O   LYS    78      28.148   0.652 -12.219  1.00 35.11           O
ATOM    520  N   ARG    79      28.666   2.846 -12.338  1.00 34.98           N
ATOM    521  CA  ARG    79      27.480   3.273 -11.564  1.00 34.97           C
ATOM    522  CB  ARG    79      27.563   4.753 -11.156  1.00 34.85           C
ATOM    523  CG  ARG    79      27.520   5.779 -12.319  1.00 35.52           C
ATOM    524  CD  ARG    79      28.117   7.093 -11.826  1.00 33.99           C
ATOM    525  NE  ARG    79      28.049   8.212 -12.770  1.00 32.72           N
ATOM    526  CZ  ARG    79      29.080   8.676 -13.485  1.00 32.92           C
ATOM    527  NH1 ARG    79      28.919   9.745 -14.275  1.00 31.75           N
ATOM    528  NH2 ARG    79      30.269   8.078 -13.423  1.00 31.25           N
ATOM    529  C   ARG    79      26.148   2.988 -12.264  1.00 34.57           C
ATOM    530  O   ARG    79      25.148   2.661 -11.616  1.00 34.43           O
ATOM    531  N   ALA    80      26.137   3.120 -13.589  1.00 34.19           N
ATOM    532  CA  ALA    80      24.957   2.786 -14.373  1.00 34.07           C
ATOM    533  CB  ALA    80      24.971   3.515 -15.726  1.00 33.71           C
ATOM    534  C   ALA    80      24.847   1.276 -14.574  1.00 33.71           C
ATOM    535  O   ALA    80      23.754   0.737 -14.523  1.00 34.30           O
ATOM    536  N   ILE    81      25.974   0.609 -14.819  1.00 34.07           N
ATOM    537  CA  ILE    81      26.002  -0.850 -14.987  1.00 34.43           C
ATOM    538  CB  ILE    81      27.419  -1.358 -15.433  1.00 35.00           C
ATOM    539  CG1 ILE    81      27.808  -0.784 -16.814  1.00 34.76           C
ATOM    540  CD1 ILE    81      29.295  -0.946 -17.152  1.00 33.63           C
ATOM    541  CG2 ILE    81      27.474  -2.886 -15.485  1.00 34.04           C
ATOM    542  C   ILE    81      25.574  -1.558 -13.681  1.00 34.84           C
ATOM    543  O   ILE    81      24.774  -2.503 -13.710  1.00 35.11           O
ATOM    544  N   MET    82      26.116  -1.108 -12.544  1.00 34.54           N
ATOM    545  CA  MET    82      25.709  -1.659 -11.249  1.00 34.31           C
ATOM    546  CB  MET    82      26.660  -1.222 -10.116  1.00 33.79           C
ATOM    547  CG  MET    82      26.356  -1.830  -8.730  1.00 36.90           C
ATOM    548  SD  MET    82      26.326  -3.648  -8.693  1.00 40.17           S
ATOM    549  CE  MET    82      28.058  -3.978  -9.049  1.00 39.78           C
ATOM    550  C   MET    82      24.232  -1.357 -10.949  1.00 33.67           C
ATOM    551  O   MET    82      23.532  -2.204 -10.400  1.00 34.01           O
ATOM    552  N   THR    83      23.748  -0.181 -11.343  1.00 33.49           N
ATOM    553  CA  THR    83      22.326   0.129 -11.207  1.00 33.75           C
ATOM    554  CB  THR    83      21.991   1.569 -11.666  1.00 33.49           C
ATOM    555  OG1 THR    83      22.584   2.518 -10.782  1.00 33.55           O
ATOM    556  CG2 THR    83      20.490   1.809 -11.685  1.00 34.45           C
ATOM    557  C   THR    83      21.501  -0.881 -11.999  1.00 33.69           C
ATOM    558  O   THR    83      20.495  -1.404 -11.510  1.00 33.83           O
ATOM    559  N   THR    84      21.939  -1.160 -13.225  1.00 34.31           N
ATOM    560  CA  THR    84      21.246  -2.114 -14.102  1.00 34.56           C
ATOM    561  CB  THR    84      21.935  -2.200 -15.511  1.00 35.17           C
ATOM    562  OG1 THR    84      21.937  -0.905 -16.127  1.00 35.13           O
ATOM    563  CG2 THR    84      21.205  -3.197 -16.409  1.00 35.68           C
ATOM    564  C   THR    84      21.157  -3.520 -13.474  1.00 33.82           C
ATOM    565  O   THR    84      20.086  -4.127 -13.439  1.00 34.51           O
ATOM    566  N   TRP    85      22.283  -4.021 -12.983  1.00 33.70           N
ATOM    567  CA  TRP    85      22.360  -5.370 -12.419  1.00 32.63           C
ATOM    568  CB  TRP    85      23.799  -5.683 -12.036  1.00 32.82           C
ATOM    569  CG  TRP    85      24.754  -5.869 -13.170  1.00 32.19           C
ATOM    570  CD1 TRP    85      24.492  -5.745 -14.511  1.00 33.02           C
ATOM    571  NE1 TRP    85      25.633  -5.992 -15.239  1.00 32.74           N
ATOM    572  CE2 TRP    85      26.659  -6.265 -14.374  1.00 32.12           C
ATOM    573  CD2 TRP    85      26.141  -6.185 -13.062  1.00 31.40           C
ATOM    574  CE3 TRP    85      26.996  -6.448 -11.982  1.00 32.56           C
ATOM    575  CZ3 TRP    85      28.316  -6.751 -12.237  1.00 32.66           C
ATOM    576  CH2 TRP    85      28.804  -6.814 -13.553  1.00 32.43           C
ATOM    577  CZ2 TRP    85      27.991  -6.577 -14.630  1.00 32.52           C
ATOM    578  C   TRP    85      21.477  -5.469 -11.177  1.00 32.75           C
ATOM    579  O   TRP    85      20.766  -6.467 -10.976  1.00 32.13           O
ATOM    580  N   THR    86      21.531  -4.422 -10.353  1.00 32.57           N
ATOM    581  CA  THR    86      20.724  -4.328  -9.122  1.00 32.40           C
ATOM    582  CB  THR    86      21.116  -3.086  -8.273  1.00 32.13           C
ATOM    583  OG1 THR    86      22.523  -3.108  -8.013  1.00 31.00           O
ATOM    584  CG2 THR    86      20.371  -3.057  -6.928  1.00 32.13           C
ATOM    585  C   THR    86      19.231  -4.317  -9.451  1.00 32.55           C
ATOM    586  O   THR    86      18.481  -5.101  -8.881  1.00 32.14           O
ATOM    587  N   VAL    87      18.815  -3.458 -10.393  1.00 32.87           N
ATOM    588  CA  VAL    87      17.409  -3.394 -10.830  1.00 32.92           C
ATOM    589  CB  VAL    87      17.179  -2.277 -11.914  1.00 33.05           C
ATOM    590  CG1 VAL    87      15.882  -2.509 -12.704  1.00 33.33           C
ATOM    591  CG2 VAL    87      17.187  -0.879 -11.282  1.00 33.21           C
ATOM    592  C   VAL    87      16.923  -4.750 -11.352  1.00 33.05           C
ATOM    593  O   VAL    87      15.821  -5.199 -11.017  1.00 33.33           O
ATOM    594  N   LEU    88      17.750  -5.405 -12.165  1.00 33.67           N
ATOM    595  CA  LEU    88      17.369  -6.670 -12.818  1.00 33.87           C
ATOM    596  CB  LEU    88      18.360  -7.051 -13.923  1.00 33.95           C
ATOM    597  CG  LEU    88      18.378  -6.308 -15.265  1.00 34.34           C
ATOM    598  CD1 LEU    88      19.386  -7.020 -16.160  1.00 35.73           C
ATOM    599  CD2 LEU    88      16.999  -6.252 -15.943  1.00 33.81           C
ATOM    600  C   LEU    88      17.224  -7.819 -11.829  1.00 33.73           C
ATOM    601  O   LEU    88      16.337  -8.659 -11.971  1.00 33.22           O
ATOM    602  N   LYS    89      18.123  -7.859 -10.851  1.00 34.64           N
ATOM    603  CA  LYS    89      18.014  -8.778  -9.721  1.00 35.01           C
ATOM    604  CB  LYS    89      19.216  -8.612  -8.791  1.00 34.97           C
ATOM    605  CG  LYS    89      19.116  -9.397  -7.470  1.00 37.70           C
ATOM    606  CD  LYS    89      20.459 -10.038  -7.098  1.00 40.01           C
ATOM    607  CE  LYS    89      21.388  -9.100  -6.331  1.00 42.00           C
ATOM    608  NZ  LYS    89      21.493  -9.500  -4.888  1.00 43.40           N
ATOM    609  C   LYS    89      16.681  -8.594  -8.981  1.00 34.87           C
ATOM    610  O   LYS    89      15.963  -9.564  -8.744  1.00 35.08           O
ATOM    611  N   GLU    90      16.333  -7.352  -8.656  1.00 35.08           N
ATOM    612  CA  GLU    90      15.062  -7.065  -7.973  1.00 35.20           C
ATOM    613  CB  GLU    90      14.996  -5.609  -7.501  1.00 35.40           C
ATOM    614  CG  GLU    90      15.906  -5.301  -6.332  1.00 35.79           C
ATOM    615  CD  GLU    90      15.786  -6.327  -5.214  1.00 35.40           C
ATOM    616  OE1 GLU    90      16.832  -6.919  -4.844  1.00 35.45           O
ATOM    617  OE2 GLU    90      14.650  -6.560  -4.738  1.00 34.77           O
ATOM    618  C   GLU    90      13.846  -7.380  -8.829  1.00 35.48           C
ATOM    619  O   GLU    90      12.796  -7.741  -8.306  1.00 34.31           O
ATOM    620  N   LEU    91      14.002  -7.255 -10.149  1.00 35.61           N
ATOM    621  CA  LEU    91      12.930  -7.576 -11.100  1.00 36.21           C
ATOM    622  CB  LEU    91      13.165  -6.860 -12.447  1.00 36.08           C
ATOM    623  CG  LEU    91      12.413  -5.560 -12.774  1.00 36.88           C
ATOM    624  CD1 LEU    91      12.791  -5.040 -14.170  1.00 37.08           C
ATOM    625  CD2 LEU    91      10.910  -5.741 -12.672  1.00 35.47           C
ATOM    626  C   LEU    91      12.755  -9.070 -11.359  1.00 36.48           C
ATOM    627  O   LEU    91      11.797  -9.471 -12.028  1.00 37.25           O
ATOM    628  N   GLY    92      13.669  -9.894 -10.846  1.00 36.66           N
ATOM    629  CA  GLY    92      13.747 -11.299 -11.261  1.00 36.96           C
ATOM    630  C   GLY    92      13.918 -11.426 -12.777  1.00 37.06           C
ATOM    631  O   GLY    92      13.269 -12.257 -13.414  1.00 37.47           O
ATOM    632  N   ASN    93      14.808 -10.605 -13.335  1.00 37.08           N
ATOM    633  CA  ASN    93      14.990 -10.425 -14.787  1.00 37.13           C
ATOM    634  CB  ASN    93      14.371  -9.073 -15.181  1.00 37.35           C
ATOM    635  CG  ASN    93      14.047  -8.932 -16.687  1.00 39.40           C
ATOM    636  OD1 ASN    93      13.687  -7.831 -17.120  1.00 40.96           O
ATOM    637  ND2 ASN    93      14.142 -10.024 -17.469  1.00 38.09           N
ATOM    638  C   ASN    93      16.486 -10.446 -15.120  1.00 36.47           C
ATOM    639  O   ASN    93      16.943  -9.806 -16.065  1.00 36.23           O
ATOM    640  N   ILE    94      17.241 -11.200 -14.324  1.00 36.22           N
ATOM    641  CA  ILE    94      18.699 -11.325 -14.441  1.00 35.87           C
ATOM    642  CB  ILE    94      19.239 -12.270 -13.330  1.00 36.21           C
ATOM    643  CG1 ILE    94      19.065 -11.620 -11.943  1.00 35.88           C
ATOM    644  CD1 ILE    94      18.949 -12.626 -10.772  1.00 36.42           C
ATOM    645  CG2 ILE    94      20.693 -12.651 -13.581  1.00 34.85           C
ATOM    646  C   ILE    94      19.149 -11.830 -15.821  1.00 35.89           C
ATOM    647  O   ILE    94      20.253 -11.521 -16.288  1.00 35.54           O
ATOM    648  N   ASN    95      18.271 -12.588 -16.467  1.00 35.84           N
ATOM    649  CA  ASN    95      18.540 -13.200 -17.761  1.00 36.09           C
ATOM    650  CB  ASN    95      17.523 -14.320 -18.022  1.00 36.21           C
ATOM    651  CG  ASN    95      17.140 -15.073 -16.752  1.00 37.13           C
ATOM    652  OD1 ASN    95      16.441 -14.540 -15.884  1.00 37.87           O
ATOM    653  ND2 ASN    95      17.583 -16.323 -16.647  1.00 37.08           N
ATOM    654  C   ASN    95      18.538 -12.191 -18.912  1.00 35.76           C
ATOM    655  O   ASN    95      19.004 -12.496 -20.011  1.00 35.86           O
ATOM    656  N   CYS    96      18.026 -10.991 -18.650  1.00 35.48           N
ATOM    657  CA  CYS    96      17.931  -9.937 -19.658  1.00 35.41           C
ATOM    658  CB  CYS    96      17.189  -8.720 -19.090  1.00 35.30           C
ATOM    659  SG  CYS    96      16.852  -7.461 -20.326  1.00 36.18           S
ATOM    660  C   CYS    96      19.288  -9.509 -20.234  1.00 35.07           C
ATOM    661  O   CYS    96      20.181  -9.092 -19.485  1.00 35.28           O
ATOM    662  N   PRO    97      19.450  -9.602 -21.572  1.00 34.93           N
ATOM    663  CA  PRO    97      20.683  -9.119 -22.198  1.00 34.71           C
ATOM    664  CB  PRO    97      20.419  -9.288 -23.700  1.00 34.84           C
ATOM    665  CG  PRO    97      19.331 -10.300 -23.793  1.00 34.99           C
ATOM    666  CD  PRO    97      18.501 -10.159 -22.560  1.00 34.76           C
ATOM    667  C   PRO    97      20.977  -7.653 -21.867  1.00 34.44           C
ATOM    668  O   PRO    97      20.080  -6.807 -21.876  1.00 34.40           O
ATOM    669  N   ILE    98      22.231  -7.372 -21.550  1.00 34.40           N
ATOM    670  CA  ILE    98      22.647  -6.017 -21.258  1.00 34.58           C
ATOM    671  CB  ILE    98      23.244  -5.857 -19.836  1.00 34.30           C
ATOM    672  CG1 ILE    98      22.253  -6.321 -18.753  1.00 34.74           C
ATOM    673  CD1 ILE    98      22.945  -6.730 -17.457  1.00 33.77           C
ATOM    674  CG2 ILE    98      23.636  -4.395 -19.595  1.00 34.14           C
ATOM    675  C   ILE    98      23.709  -5.625 -22.252  1.00 34.35           C
ATOM    676  O   ILE    98      24.695  -6.338 -22.442  1.00 35.13           O
ATOM    677  N   ILE    99      23.507  -4.472 -22.870  1.00 34.48           N
ATOM    678  CA  ILE    99      24.459  -3.950 -23.823  1.00 34.62           C
ATOM    679  CB  ILE    99      23.788  -3.748 -25.234  1.00 34.47           C
ATOM    680  CG1 ILE    99      23.319  -5.100 -25.787  1.00 33.37           C
ATOM    681  CD1 ILE    99      22.539  -5.027 -27.092  1.00 35.76           C
ATOM    682  CG2 ILE    99      24.750  -3.030 -26.194  1.00 33.70           C
ATOM    683  C   ILE    99      24.981  -2.631 -23.285  1.00 34.19           C
ATOM    684  O   ILE    99      24.199  -1.700 -23.111  1.00 34.12           O
ATOM    685  N   ASN   100      26.287  -2.585 -23.009  1.00 34.13           N
ATOM    686  CA  ASN   100      26.987  -1.371 -22.584  1.00 34.64           C
ATOM    687  CB  ASN   100      28.231  -1.699 -21.732  1.00 34.53           C
ATOM    688  CG  ASN   100      27.976  -2.735 -20.621  1.00 34.30           C
ATOM    689  OD1 ASN   100      26.837  -3.071 -20.293  1.00 35.10           O
ATOM    690  ND2 ASN   100      29.059  -3.228 -20.036  1.00 34.14           N
ATOM    691  C   ASN   100      27.503  -0.596 -23.804  1.00 35.03           C
ATOM    692  O   ASN   100      28.061  -1.206 -24.712  1.00 35.47           O
ATOM    693  N   HIS   101      27.370   0.730 -23.800  1.00 35.06           N
ATOM    694  CA  HIS   101      28.013   1.571 -24.829  1.00 35.24           C
ATOM    695  CB  HIS   101      27.119   1.706 -26.062  1.00 34.65           C
ATOM    696  CG  HIS   101      27.874   2.021 -27.314  1.00 36.15           C
ATOM    697  ND1 HIS   101      28.213   3.306 -27.675  1.00 35.07           N
ATOM    698  CE1 HIS   101      28.901   3.277 -28.802  1.00 36.66           C
ATOM    699  NE2 HIS   101      29.019   2.020 -29.189  1.00 36.97           N
ATOM    700  CD2 HIS   101      28.386   1.213 -28.275  1.00 36.84           C
ATOM    701  C   HIS   101      28.385   2.958 -24.311  1.00 34.82           C
ATOM    702  O   HIS   101      27.597   3.589 -23.622  1.00 35.05           O
ATOM    703  N   TRP   102      29.574   3.438 -24.670  1.00 34.70           N
ATOM    704  CA  TRP   102      30.016   4.771 -24.270  1.00 34.72           C
ATOM    705  CB  TRP   102      31.447   5.055 -24.756  1.00 34.77           C
ATOM    706  CG  TRP   102      31.535   5.252 -26.270  1.00 34.87           C
ATOM    707  CD1 TRP   102      31.810   4.300 -27.208  1.00 35.16           C
ATOM    708  NE1 TRP   102      31.800   4.859 -28.471  1.00 36.19           N
ATOM    709  CE2 TRP   102      31.525   6.198 -28.360  1.00 36.20           C
ATOM    710  CD2 TRP   102      31.348   6.480 -26.983  1.00 34.31           C
ATOM    711  CE3 TRP   102      31.052   7.795 -26.593  1.00 36.58           C
ATOM    712  CZ3 TRP   102      30.930   8.785 -27.585  1.00 36.38           C
ATOM    713  CH2 TRP   102      31.099   8.465 -28.954  1.00 35.37           C
ATOM    714  CZ2 TRP   102      31.390   7.182 -29.355  1.00 35.00           C
ATOM    715  C   TRP   102      29.064   5.903 -24.690  1.00 34.79           C
ATOM    716  O   TRP   102      29.026   6.928 -24.034  1.00 34.34           O
ATOM    717  N   ARG   103      28.303   5.723 -25.774  1.00 34.58           N
ATOM    718  CA  ARG   103      27.413   6.786 -26.259  1.00 34.86           C
ATOM    719  CB  ARG   103      26.822   6.451 -27.639  1.00 34.58           C
ATOM    720  CG  ARG   103      27.808   6.652 -28.774  1.00 33.52           C
ATOM    721  CD  ARG   103      27.227   6.335 -30.178  1.00 33.61           C
ATOM    722  NE  ARG   103      28.309   6.291 -31.169  1.00 32.79           N
ATOM    723  CZ  ARG   103      28.859   7.361 -31.749  1.00 33.13           C
ATOM    724  NH1 ARG   103      29.848   7.213 -32.629  1.00 32.20           N
ATOM    725  NH2 ARG   103      28.421   8.582 -31.463  1.00 32.82           N
ATOM    726  C   ARG   103      26.308   7.155 -25.258  1.00 35.40           C
ATOM    727  O   ARG   103      25.705   8.220 -25.368  1.00 35.62           O
ATOM    728  N   LEU   104      26.060   6.274 -24.288  1.00 35.76           N
ATOM    729  CA  LEU   104      25.105   6.543 -23.208  1.00 35.93           C
ATOM    730  CB  LEU   104      24.282   5.284 -22.892  1.00 35.74           C
ATOM    731  CG  LEU   104      23.259   4.858 -23.946  1.00 36.04           C
ATOM    732  CD1 LEU   104      22.546   3.610 -23.461  1.00 34.85           C
ATOM    733  CD2 LEU   104      22.252   5.983 -24.254  1.00 36.11           C
ATOM    734  C   LEU   104      25.756   7.117 -21.926  1.00 36.14           C
ATOM    735  O   LEU   104      25.071   7.359 -20.924  1.00 36.13           O
ATOM    736  N   ASN   105      27.068   7.324 -21.972  1.00 35.87           N
ATOM    737  CA  ASN   105      27.818   7.930 -20.878  1.00 36.07           C
ATOM    738  CB  ASN   105      29.289   8.120 -21.260  1.00 35.26           C
ATOM    739  CG  ASN   105      30.120   6.856 -21.080  1.00 34.85           C
ATOM    740  OD1 ASN   105      29.595   5.789 -20.776  1.00 35.87           O
ATOM    741  ND2 ASN   105      31.429   6.978 -21.258  1.00 33.55           N
ATOM    742  C   ASN   105      27.248   9.278 -20.483  1.00 36.45           C
ATOM    743  O   ASN   105      26.623   9.970 -21.307  1.00 36.60           O
ATOM    744  N   GLU   106      27.487   9.654 -19.224  1.00 36.22           N
ATOM    745  CA  GLU   106      27.231  11.006 -18.750  1.00 35.73           C
ATOM    746  CB  GLU   106      27.705  11.159 -17.289  1.00 35.68           C
ATOM    747  CG  GLU   106      27.476  12.540 -16.663  1.00 36.58           C
ATOM    748  CD  GLU   106      25.998  12.909 -16.528  1.00 38.80           C
ATOM    749  OE1 GLU   106      25.324  13.161 -17.537  1.00 38.01           O
ATOM    750  OE2 GLU   106      25.492  12.949 -15.398  1.00 42.44           O
ATOM    751  C   GLU   106      27.960  12.010 -19.645  1.00 35.54           C
ATOM    752  O   GLU   106      28.996  11.691 -20.238  1.00 35.49           O
ATOM    753  N   ARG   107      27.407  13.215 -19.751  1.00 35.22           N
ATOM    754  CA  ARG   107      28.096  14.317 -20.411  1.00 35.48           C
ATOM    755  CB  ARG   107      27.290  15.596 -20.248  1.00 35.26           C
ATOM    756  CG  ARG   107      28.065  16.855 -20.513  1.00 36.84           C
ATOM    757  CD  ARG   107      27.171  18.039 -20.376  1.00 39.17           C
ATOM    758  NE  ARG   107      27.835  19.103 -19.643  1.00 42.35           N
ATOM    759  CZ  ARG   107      27.195  20.065 -18.993  1.00 43.57           C
ATOM    760  NH1 ARG   107      27.887  20.990 -18.356  1.00 44.42           N
ATOM    761  NH2 ARG   107      25.864  20.092 -18.970  1.00 44.51           N
ATOM    762  C   ARG   107      29.487  14.483 -19.796  1.00 35.51           C
ATOM    763  O   ARG   107      29.653  14.382 -18.573  1.00 35.48           O
ATOM    764  N   HIS   108      30.488  14.699 -20.639  1.00 34.71           N
ATOM    765  CA  HIS   108      31.825  14.963 -20.148  1.00 34.40           C
ATOM    766  CB  HIS   108      32.828  14.770 -21.275  1.00 33.99           C
ATOM    767  CG  HIS   108      34.211  14.483 -20.803  1.00 33.23           C
ATOM    768  ND1 HIS   108      35.061  15.468 -20.349  1.00 33.05           N
ATOM    769  CE1 HIS   108      36.213  14.926 -20.004  1.00 32.28           C
ATOM    770  NE2 HIS   108      36.144  13.627 -20.229  1.00 32.95           N
ATOM    771  CD2 HIS   108      34.901  13.324 -20.725  1.00 33.08           C
ATOM    772  C   HIS   108      31.907  16.380 -19.567  1.00 34.47           C
ATOM    773  O   HIS   108      31.388  17.334 -20.159  1.00 34.18           O
ATOM    774  N   TYR   109      32.546  16.511 -18.401  1.00 34.61           N
ATOM    775  CA  TYR   109      32.661  17.802 -17.714  1.00 34.80           C
ATOM    776  CB  TYR   109      32.204  17.700 -16.246  1.00 35.91           C
ATOM    777  CG  TYR   109      30.711  17.881 -16.074  1.00 37.45           C
ATOM    778  CD1 TYR   109      30.184  19.079 -15.581  1.00 39.42           C
ATOM    779  CE1 TYR   109      28.805  19.254 -15.430  1.00 40.10           C
ATOM    780  CZ  TYR   109      27.945  18.220 -15.799  1.00 39.89           C
ATOM    781  OH  TYR   109      26.578  18.372 -15.670  1.00 40.41           O
ATOM    782  CE2 TYR   109      28.447  17.025 -16.309  1.00 39.93           C
ATOM    783  CD2 TYR   109      29.821  16.867 -16.448  1.00 39.22           C
ATOM    784  C   TYR   109      34.039  18.468 -17.818  1.00 34.29           C
ATOM    785  O   TYR   109      34.303  19.464 -17.146  1.00 33.29           O
ATOM    786  N   GLY   110      34.897  17.925 -18.679  1.00 33.86           N
ATOM    787  CA  GLY   110      36.188  18.542 -18.980  1.00 33.71           C
ATOM    788  C   GLY   110      37.079  18.686 -17.765  1.00 33.74           C
ATOM    789  O   GLY   110      37.191  17.758 -16.961  1.00 33.51           O
ATOM    790  N   ALA   111      37.695  19.859 -17.627  1.00 33.76           N
ATOM    791  CA  ALA   111      38.592  20.150 -16.506  1.00 34.08           C
ATOM    792  CB  ALA   111      39.466  21.357 -16.826  1.00 34.01           C
ATOM    793  C   ALA   111      37.881  20.346 -15.154  1.00 33.85           C
ATOM    794  O   ALA   111      38.542  20.491 -14.127  1.00 33.97           O
ATOM    795  N   LEU   112      36.547  20.364 -15.163  1.00 33.91           N
ATOM    796  CA  LEU   112      35.746  20.434 -13.926  1.00 34.23           C
ATOM    797  CB  LEU   112      34.341  20.984 -14.215  1.00 34.42           C
ATOM    798  CG  LEU   112      34.114  22.423 -14.672  1.00 34.35           C
ATOM    799  CD1 LEU   112      32.625  22.708 -14.732  1.00 34.49           C
ATOM    800  CD2 LEU   112      34.782  23.386 -13.738  1.00 33.52           C
ATOM    801  C   LEU   112      35.601  19.066 -13.248  1.00 34.18           C
ATOM    802  O   LEU   112      35.244  18.982 -12.072  1.00 34.06           O
ATOM    803  N   GLN   113      35.861  17.999 -13.998  1.00 33.87           N
ATOM    804  CA  GLN   113      35.773  16.652 -13.457  1.00 34.13           C
ATOM    805  CB  GLN   113      36.101  15.611 -14.524  1.00 34.17           C
ATOM    806  CG  GLN   113      35.132  15.614 -15.718  1.00 34.24           C
ATOM    807  CD  GLN   113      35.165  14.339 -16.542  1.00 34.13           C
ATOM    808  OE1 GLN   113      34.259  14.088 -17.333  1.00 35.38           O
ATOM    809  NE2 GLN   113      36.204  13.527 -16.363  1.00 34.89           N
ATOM    810  C   GLN   113      36.686  16.503 -12.240  1.00 34.46           C
ATOM    811  O   GLN   113      37.873  16.844 -12.297  1.00 34.40           O
ATOM    812  N   GLY   114      36.113  16.036 -11.130  1.00 34.76           N
ATOM    813  CA  GLY   114      36.872  15.794  -9.905  1.00 34.76           C
ATOM    814  C   GLY   114      36.841  16.902  -8.874  1.00 34.98           C
ATOM    815  O   GLY   114      37.219  16.687  -7.716  1.00 35.18           O
ATOM    816  N   LEU   115      36.372  18.077  -9.280  1.00 34.67           N
ATOM    817  CA  LEU   115      36.449  19.262  -8.441  1.00 34.93           C
ATOM    818  CB  LEU   115      36.782  20.493  -9.298  1.00 35.01           C
ATOM    819  CG  LEU   115      38.197  20.763  -9.845  1.00 34.77           C
ATOM    820  CD1 LEU   115      38.824  19.571 -10.550  1.00 34.42           C
ATOM    821  CD2 LEU   115      38.165  21.950 -10.792  1.00 34.76           C
ATOM    822  C   LEU   115      35.197  19.514  -7.580  1.00 35.01           C
ATOM    823  O   LEU   115      34.065  19.279  -8.021  1.00 34.28           O
ATOM    824  N   ASN   116      35.444  19.978  -6.351  1.00 34.96           N
ATOM    825  CA  ASN   116      34.429  20.459  -5.404  1.00 35.72           C
ATOM    826  CB  ASN   116      35.073  20.707  -4.016  1.00 36.09           C
ATOM    827  CG  ASN   116      35.343  19.434  -3.245  1.00 36.95           C
ATOM    828  OD1 ASN   116      34.710  18.408  -3.478  1.00 39.61           O
ATOM    829  ND2 ASN   116      36.293  19.497  -2.317  1.00 35.72           N
ATOM    830  C   ASN   116      33.836  21.801  -5.816  1.00 35.76           C
ATOM    831  O   ASN   116      34.093  22.307  -6.902  1.00 35.70           O
ATOM    832  N   LYS   117      33.078  22.404  -4.903  1.00 35.96           N
ATOM    833  CA  LYS   117      32.681  23.800  -5.071  1.00 35.80           C
ATOM    834  CB  LYS   117      31.227  24.033  -4.642  1.00 35.92           C
ATOM    835  CG  LYS   117      30.211  23.823  -5.792  1.00 35.42           C
ATOM    836  CD  LYS   117      30.474  22.533  -6.590  1.00 34.56           C
ATOM    837  CE  LYS   117      29.213  21.963  -7.182  1.00 33.77           C
ATOM    838  NZ  LYS   117      29.489  20.695  -7.929  1.00 35.28           N
ATOM    839  C   LYS   117      33.664  24.752  -4.393  1.00 35.44           C
ATOM    840  O   LYS   117      33.615  25.962  -4.613  1.00 35.32           O
ATOM    841  N   SER   118      34.564  24.189  -3.588  1.00 35.37           N
ATOM    842  CA  SER   118      35.707  24.928  -3.054  1.00 35.27           C
ATOM    843  CB  SER   118      36.078  24.461  -1.631  1.00 35.40           C
ATOM    844  OG  SER   118      36.145  23.043  -1.523  1.00 35.60           O
ATOM    845  C   SER   118      36.897  24.811  -4.011  1.00 35.12           C
ATOM    846  O   SER   118      37.639  25.770  -4.210  1.00 35.05           O
ATOM    847  N   GLU   119      37.066  23.633  -4.604  1.00 34.99           N
ATOM    848  CA  GLU   119      38.128  23.399  -5.585  1.00 35.03           C
ATOM    849  CB  GLU   119      38.349  21.899  -5.817  1.00 35.04           C
ATOM    850  CG  GLU   119      39.305  21.273  -4.786  1.00 35.15           C
ATOM    851  CD  GLU   119      39.272  19.745  -4.746  1.00 34.89           C
ATOM    852  OE1 GLU   119      38.509  19.122  -5.512  1.00 34.12           O
ATOM    853  OE2 GLU   119      40.020  19.166  -3.929  1.00 34.95           O
ATOM    854  C   GLU   119      37.915  24.153  -6.908  1.00 35.08           C
ATOM    855  O   GLU   119      38.867  24.726  -7.449  1.00 34.85           O
ATOM    856  N   THR   120      36.677  24.175  -7.407  1.00 35.10           N
ATOM    857  CA  THR   120      36.358  24.867  -8.668  1.00 35.73           C
ATOM    858  CB  THR   120      34.963  24.488  -9.240  1.00 35.66           C
ATOM    859  OG1 THR   120      33.962  24.663  -8.232  1.00 37.40           O
ATOM    860  CG2 THR   120      34.939  23.059  -9.684  1.00 35.95           C
ATOM    861  C   THR   120      36.428  26.385  -8.545  1.00 35.68           C
ATOM    862  O   THR   120      36.907  27.056  -9.458  1.00 35.78           O
ATOM    863  N   ALA   121      35.936  26.914  -7.425  1.00 35.87           N
ATOM    864  CA  ALA   121      35.955  28.353  -7.146  1.00 36.01           C
ATOM    865  CB  ALA   121      35.167  28.656  -5.884  1.00 36.00           C
ATOM    866  C   ALA   121      37.383  28.900  -7.038  1.00 36.12           C
ATOM    867  O   ALA   121      37.628  30.069  -7.334  1.00 36.08           O
ATOM    868  N   SER   122      38.306  28.036  -6.610  1.00 36.22           N
ATOM    869  CA  SER   122      39.734  28.347  -6.532  1.00 36.23           C
ATOM    870  CB  SER   122      40.426  27.371  -5.575  1.00 36.20           C
ATOM    871  OG  SER   122      41.828  27.581  -5.552  1.00 36.60           O
ATOM    872  C   SER   122      40.430  28.310  -7.901  1.00 36.12           C
ATOM    873  O   SER   122      41.206  29.207  -8.232  1.00 36.14           O
ATOM    874  N   LYS   123      40.159  27.259  -8.672  1.00 35.93           N
ATOM    875  CA  LYS   123      40.782  27.048  -9.980  1.00 36.00           C
ATOM    876  CB  LYS   123      40.611  25.587 -10.423  1.00 35.91           C
ATOM    881  C   LYS   123      40.221  27.984 -11.054  1.00 36.02           C
ATOM    882  O   LYS   123      40.966  28.488 -11.901  1.00 35.96           O
ATOM    883  N   PHE   124      38.910  28.211 -11.007  1.00 36.02           N
ATOM    884  CA  PHE   124      38.208  28.982 -12.035  1.00 36.13           C
ATOM    885  CB  PHE   124      37.233  28.075 -12.801  1.00 36.15           C
ATOM    886  CG  PHE   124      37.882  26.859 -13.418  1.00 36.13           C
ATOM    887  CD1 PHE   124      38.707  26.980 -14.538  1.00 36.19           C
ATOM    888  CE1 PHE   124      39.311  25.861 -15.111  1.00 35.67           C
ATOM    889  CZ  PHE   124      39.087  24.603 -14.572  1.00 35.84           C
ATOM    890  CE2 PHE   124      38.261  24.464 -13.454  1.00 36.10           C
ATOM    891  CD2 PHE   124      37.664  25.593 -12.884  1.00 36.25           C
ATOM    892  C   PHE   124      37.474  30.187 -11.436  1.00 36.25           C
ATOM    893  O   PHE   124      37.754  30.595 -10.301  1.00 36.11           O
ATOM    894  N   GLY   125      36.544  30.751 -12.206  1.00 36.28           N
ATOM    895  CA  GLY   125      35.750  31.899 -11.761  1.00 36.36           C
ATOM    896  C   GLY   125      34.266  31.590 -11.753  1.00 36.45           C
ATOM    897  O   GLY   125      33.815  30.704 -12.479  1.00 36.04           O
ATOM    898  N   GLU   126      33.510  32.335 -10.944  1.00 36.63           N
ATOM    899  CA  GLU   126      32.073  32.084 -10.758  1.00 36.96           C
ATOM    900  CB  GLU   126      31.535  32.784  -9.500  1.00 36.83           C
ATOM    901  CG  GLU   126      31.606  34.308  -9.516  1.00 37.58           C
ATOM    902  CD  GLU   126      31.500  34.932  -8.125  1.00 37.36           C
ATOM    903  OE1 GLU   126      31.031  34.251  -7.185  1.00 37.95           O
ATOM    904  OE2 GLU   126      31.891  36.112  -7.976  1.00 37.69           O
ATOM    905  C   GLU   126      31.203  32.395 -11.988  1.00 36.92           C
ATOM    906  O   GLU   126      30.151  31.775 -12.173  1.00 36.85           O
ATOM    907  N   ASP   127      31.641  33.340 -12.821  1.00 36.78           N
ATOM    908  CA  ASP   127      30.950  33.633 -14.081  1.00 36.73           C
ATOM    909  CB  ASP   127      31.564  34.859 -14.767  1.00 36.82           C
ATOM    913  C   ASP   127      30.946  32.421 -15.032  1.00 36.66           C
ATOM    914  O   ASP   127      29.882  31.881 -15.358  1.00 36.49           O
ATOM    915  N   GLN   128      32.143  31.996 -15.439  1.00 36.56           N
ATOM    916  CA  GLN   128      32.344  30.907 -16.407  1.00 36.57           C
ATOM    917  CB  GLN   128      33.831  30.814 -16.795  1.00 36.56           C
ATOM    918  CG  GLN   128      34.772  30.531 -15.608  1.00 37.04           C
ATOM    919  CD  GLN   128      36.261  30.683 -15.921  1.00 37.09           C
ATOM    920  OE1 GLN   128      37.094  30.678 -15.006  1.00 37.78           O
ATOM    921  NE2 GLN   128      36.602  30.814 -17.202  1.00 37.60           N
ATOM    922  C   GLN   128      31.834  29.543 -15.922  1.00 36.34           C
ATOM    923  O   GLN   128      31.372  28.727 -16.728  1.00 35.91           O
ATOM    924  N   VAL   129      31.923  29.303 -14.612  1.00 36.07           N
ATOM    925  CA  VAL   129      31.459  28.052 -14.009  1.00 35.91           C
ATOM    926  CB  VAL   129      31.853  27.954 -12.510  1.00 36.03           C
ATOM    929  C   VAL   129      29.945  27.873 -14.152  1.00 35.76           C
ATOM    930  O   VAL   129      29.470  26.776 -14.466  1.00 35.66           O
ATOM    931  N   LYS   130      29.201  28.957 -13.924  1.00 35.47           N
ATOM    932  CA  LYS   130      27.743  28.954 -14.039  1.00 35.37           C
ATOM    933  CB  LYS   130      27.175  30.327 -13.664  1.00 35.39           C
ATOM    934  CG  LYS   130      25.650  30.419 -13.722  1.00 35.55           C
ATOM    935  CD  LYS   130      25.137  31.798 -13.328  1.00 35.47           C
ATOM    936  CE  LYS   130      25.507  32.864 -14.354  1.00 36.11           C
ATOM    937  NZ  LYS   130      24.964  32.586 -15.714  1.00 35.38           N
ATOM    938  C   LYS   130      27.295  28.549 -15.448  1.00 35.24           C
ATOM    939  O   LYS   130      26.393  27.722 -15.605  1.00 35.27           O
ATOM    940  N   ILE   131      27.943  29.132 -16.456  1.00 34.91           N
ATOM    941  CA  ILE   131      27.660  28.843 -17.863  1.00 34.69           C
ATOM    942  CB  ILE   131      28.407  29.834 -18.802  1.00 34.62           C
ATOM    943  CG1 ILE   131      28.017  31.281 -18.477  1.00 34.69           C
ATOM    944  CD1 ILE   131      28.929  32.334 -19.089  1.00 34.54           C
ATOM    945  CG2 ILE   131      28.109  29.528 -20.269  1.00 34.80           C
ATOM    946  C   ILE   131      27.999  27.385 -18.213  1.00 34.40           C
ATOM    947  O   ILE   131      27.212  26.698 -18.876  1.00 34.41           O
ATOM    948  N   TRP   132      29.156  26.913 -17.747  1.00 34.04           N
ATOM    949  CA  TRP   132      29.585  25.536 -18.001  1.00 33.87           C
ATOM    950  CB  TRP   132      30.951  25.255 -17.378  1.00 33.74           C
ATOM    951  CG  TRP   132      32.065  26.086 -17.914  1.00 33.45           C
ATOM    952  CD1 TRP   132      32.147  26.658 -19.149  1.00 33.44           C
ATOM    953  NE1 TRP   132      33.329  27.343 -19.279  1.00 33.05           N
ATOM    954  CE2 TRP   132      34.042  27.222 -18.115  1.00 33.79           C
ATOM    955  CD2 TRP   132      33.277  26.431 -17.231  1.00 33.95           C
ATOM    956  CE3 TRP   132      33.785  26.160 -15.951  1.00 33.94           C
ATOM    957  CZ3 TRP   132      35.028  26.674 -15.602  1.00 33.70           C
ATOM    958  CH2 TRP   132      35.769  27.453 -16.507  1.00 33.74           C
ATOM    959  CZ2 TRP   132      35.293  27.740 -17.763  1.00 33.91           C
ATOM    960  C   TRP   132      28.593  24.502 -17.496  1.00 33.86           C
ATOM    961  O   TRP   132      28.503  23.405 -18.046  1.00 34.03           O
ATOM    962  N   ARG   133      27.865  24.842 -16.437  1.00 33.92           N
ATOM    963  CA  ARG   133      26.929  23.909 -15.812  1.00 33.83           C
ATOM    964  CB  ARG   133      26.854  24.159 -14.301  1.00 33.82           C
ATOM    971  C   ARG   133      25.541  24.017 -16.427  1.00 33.81           C
ATOM    972  O   ARG   133      24.826  23.020 -16.540  1.00 33.79           O
ATOM    973  N   ARG   134      25.186  25.228 -16.852  1.00 33.88           N
ATOM    974  CA  ARG   134      23.810  25.556 -17.231  1.00 33.98           C
ATOM    975  CB  ARG   134      23.358  26.848 -16.532  1.00 33.83           C
ATOM    976  CG  ARG   134      23.296  26.739 -15.013  1.00 34.35           C
ATOM    977  CD  ARG   134      22.672  27.966 -14.376  1.00 34.05           C
ATOM    978  NE  ARG   134      22.523  27.799 -12.933  1.00 34.84           N
ATOM    982  C   ARG   134      23.537  25.651 -18.736  1.00 33.85           C
ATOM    983  O   ARG   134      22.422  25.370 -19.170  1.00 33.82           O
ATOM    984  N   SER   135      24.541  26.046 -19.518  1.00 33.84           N
ATOM    985  CA  SER   135      24.359  26.294 -20.961  1.00 34.05           C
ATOM    986  CB  SER   135      25.541  27.089 -21.519  1.00 34.00           C
ATOM    987  OG  SER   135      26.676  26.249 -21.655  1.00 34.06           O
ATOM    988  C   SER   135      24.165  25.031 -21.806  1.00 34.14           C
ATOM    989  O   SER   135      24.506  23.919 -21.385  1.00 34.51           O
ATOM    990  N   PHE   136      23.628  25.220 -23.008  1.00 34.13           N
ATOM    991  CA  PHE   136      23.429  24.131 -23.963  1.00 34.14           C
ATOM    992  CB  PHE   136      22.177  24.392 -24.816  1.00 34.11           C
ATOM    993  CG  PHE   136      21.856  23.286 -25.795  1.00 34.53           C
ATOM    994  CD1 PHE   136      21.247  22.109 -25.364  1.00 34.77           C
ATOM    995  CE1 PHE   136      20.945  21.088 -26.262  1.00 34.80           C
ATOM    996  CZ  PHE   136      21.251  21.238 -27.612  1.00 34.70           C
ATOM    997  CE2 PHE   136      21.853  22.410 -28.058  1.00 35.19           C
ATOM    998  CD2 PHE   136      22.153  23.428 -27.150  1.00 34.89           C
ATOM    999  C   PHE   136      24.648  23.928 -24.867  1.00 33.97           C
ATOM   1000  O   PHE   136      25.038  22.794 -25.154  1.00 34.03           O
ATOM   1001  N   ASP   137      25.248  25.035 -25.297  1.00 33.76           N
ATOM   1002  CA  ASP   137      26.283  25.014 -26.329  1.00 33.45           C
ATOM   1003  CB  ASP   137      25.792  25.763 -27.580  1.00 33.67           C
ATOM   1004  CG  ASP   137      25.342  27.188 -27.284  1.00 34.66           C
ATOM   1005  OD1 ASP   137      25.401  27.628 -26.110  1.00 35.85           O
ATOM   1006  OD2 ASP   137      24.926  27.881 -28.239  1.00 35.67           O
ATOM   1007  C   ASP   137      27.665  25.529 -25.899  1.00 32.96           C
ATOM   1008  O   ASP   137      28.554  25.681 -26.741  1.00 32.69           O
ATOM   1009  N   VAL   138      27.848  25.803 -24.606  1.00 32.47           N
ATOM   1010  CA  VAL   138      29.146  26.281 -24.104  1.00 32.16           C
ATOM   1011  CB  VAL   138      29.060  27.684 -23.431  1.00 32.10           C
ATOM   1012  CG1 VAL   138      30.451  28.172 -23.039  1.00 31.47           C
ATOM   1013  CG2 VAL   138      28.379  28.702 -24.349  1.00 32.67           C
ATOM   1014  C   VAL   138      29.765  25.255 -23.142  1.00 32.09           C
ATOM   1015  O   VAL   138      29.233  25.022 -22.047  1.00 32.02           O
ATOM   1016  N   PRO   139      30.884  24.623 -23.557  1.00 31.92           N
ATOM   1017  CA  PRO   139      31.475  23.544 -22.757  1.00 31.60           C
ATOM   1018  CB  PRO   139      32.238  22.723 -23.802  1.00 31.55           C
ATOM   1019  CG  PRO   139      32.639  23.730 -24.848  1.00 31.68           C
ATOM   1020  CD  PRO   139      31.646  24.873 -24.799  1.00 31.70           C
ATOM   1021  C   PRO   139      32.439  24.041 -21.675  1.00 31.46           C
ATOM   1022  O   PRO   139      32.930  25.166 -21.763  1.00 31.25           O
ATOM   1023  N   PRO   140      32.691  23.211 -20.643  1.00 31.42           N
ATOM   1024  CA  PRO   140      33.802  23.402 -19.695  1.00 31.41           C
ATOM   1025  CB  PRO   140      33.664  22.202 -18.753  1.00 31.16           C
ATOM   1026  CG  PRO   140      32.263  21.758 -18.885  1.00 31.69           C
ATOM   1027  CD  PRO   140      31.869  22.038 -20.295  1.00 31.23           C
ATOM   1028  C   PRO   140      35.159  23.342 -20.402  1.00 31.48           C
ATOM   1029  O   PRO   140      35.227  22.852 -21.541  1.00 31.59           O
ATOM   1030  N   PRO   141      36.239  23.836 -19.754  1.00 31.70           N
ATOM   1031  CA  PRO   141      37.528  23.798 -20.446  1.00 31.84           C
ATOM   1032  CB  PRO   141      38.489  24.499 -19.470  1.00 31.74           C
ATOM   1033  CG  PRO   141      37.623  25.273 -18.569  1.00 31.68           C
ATOM   1034  CD  PRO   141      36.372  24.452 -18.424  1.00 31.77           C
ATOM   1035  C   PRO   141      38.002  22.378 -20.727  1.00 32.23           C
ATOM   1036  O   PRO   141      37.607  21.423 -20.045  1.00 31.65           O
ATOM   1037  N   VAL   142      38.858  22.276 -21.731  1.00 32.67           N
ATOM   1038  CA  VAL   142      39.335  21.025 -22.291  1.00 33.53           C
ATOM   1039  CB  VAL   142      39.914  21.317 -23.699  1.00 33.82           C
ATOM   1040  CG1 VAL   142      40.977  20.314 -24.123  1.00 34.95           C
ATOM   1041  CG2 VAL   142      38.785  21.418 -24.720  1.00 34.67           C
ATOM   1042  C   VAL   142      40.378  20.338 -21.405  1.00 33.55           C
ATOM   1043  O   VAL   142      41.252  20.996 -20.832  1.00 33.74           O
ATOM   1044  N   LEU   143      40.273  19.016 -21.286  1.00 33.47           N
ATOM   1045  CA  LEU   143      41.367  18.220 -20.740  1.00 33.47           C
ATOM   1046  CB  LEU   143      40.891  16.811 -20.389  1.00 33.30           C
ATOM   1047  CG  LEU   143      39.850  16.624 -19.281  1.00 32.63           C
ATOM   1048  CD1 LEU   143      39.528  15.158 -19.149  1.00 32.32           C
ATOM   1049  CD2 LEU   143      40.354  17.173 -17.961  1.00 32.03           C
ATOM   1050  C   LEU   143      42.526  18.131 -21.740  1.00 33.76           C
ATOM   1051  O   LEU   143      42.313  17.895 -22.929  1.00 33.57           O
ATOM   1052  N   GLU   144      43.748  18.326 -21.258  1.00 34.25           N
ATOM   1053  CA  GLU   144      44.931  18.027 -22.060  1.00 34.84           C
ATOM   1054  CB  GLU   144      46.177  18.686 -21.464  1.00 34.72           C
ATOM   1059  C   GLU   144      45.082  16.510 -22.080  1.00 35.20           C
ATOM   1060  O   GLU   144      44.739  15.844 -21.096  1.00 35.32           O
ATOM   1061  N   LYS   145      45.577  15.962 -23.191  1.00 35.53           N
ATOM   1062  CA  LYS   145      45.719  14.505 -23.335  1.00 35.89           C
ATOM   1063  CB  LYS   145      46.179  14.130 -24.748  1.00 35.85           C
ATOM   1068  C   LYS   145      46.654  13.901 -22.279  1.00 36.08           C
ATOM   1069  O   LYS   145      46.487  12.741 -21.886  1.00 36.47           O
ATOM   1070  N   SER   146      47.610  14.703 -21.810  1.00 35.99           N
ATOM   1071  CA  SER   146      48.544  14.307 -20.748  1.00 36.01           C
ATOM   1072  CB  SER   146      49.734  15.272 -20.696  1.00 36.04           C
ATOM   1073  OG  SER   146      49.308  16.612 -20.500  1.00 36.16           O
ATOM   1074  C   SER   146      47.888  14.201 -19.363  1.00 35.92           C
ATOM   1075  O   SER   146      48.390  13.486 -18.489  1.00 35.88           O
ATOM   1076  N   ASP   147      46.780  14.919 -19.175  1.00 35.77           N
ATOM   1077  CA  ASP   147      46.004  14.893 -17.932  1.00 35.48           C
ATOM   1078  CB  ASP   147      44.822  15.869 -18.038  1.00 35.39           C
ATOM   1079  CG  ASP   147      44.239  16.255 -16.686  1.00 35.05           C
ATOM   1080  OD1 ASP   147      43.708  15.378 -15.977  1.00 33.88           O
ATOM   1081  OD2 ASP   147      44.293  17.455 -16.341  1.00 35.12           O
ATOM   1082  C   ASP   147      45.502  13.466 -17.689  1.00 35.60           C
ATOM   1083  O   ASP   147      44.904  12.863 -18.586  1.00 35.56           O
ATOM   1084  N   PRO   148      45.751  12.915 -16.483  1.00 35.58           N
ATOM   1085  CA  PRO   148      45.307  11.546 -16.182  1.00 35.66           C
ATOM   1086  CB  PRO   148      45.720  11.345 -14.713  1.00 35.69           C
ATOM   1087  CG  PRO   148      45.982  12.715 -14.178  1.00 35.66           C
ATOM   1088  CD  PRO   148      46.465  13.521 -15.344  1.00 35.66           C
ATOM   1089  C   PRO   148      43.798  11.339 -16.364  1.00 35.61           C
ATOM   1090  O   PRO   148      43.353  10.206 -16.568  1.00 35.84           O
ATOM   1091  N   ARG   149      43.035  12.431 -16.321  1.00 35.56           N
ATOM   1092  CA  ARG   149      41.572  12.384 -16.454  1.00 35.44           C
ATOM   1093  CB  ARG   149      40.932  13.673 -15.919  1.00 35.39           C
ATOM   1094  CG  ARG   149      41.095  13.903 -14.411  1.00 34.79           C
ATOM   1095  CD  ARG   149      40.587  15.285 -14.002  1.00 34.31           C
ATOM   1096  NE  ARG   149      41.324  16.369 -14.653  1.00 31.56           N
ATOM   1097  CZ  ARG   149      40.993  17.657 -14.584  1.00 31.07           C
ATOM   1098  NH1 ARG   149      39.925  18.038 -13.894  1.00 30.21           N
ATOM   1099  NH2 ARG   149      41.731  18.568 -15.209  1.00 29.72           N
ATOM   1100  C   ARG   149      41.088  12.119 -17.886  1.00 35.81           C
ATOM   1101  O   ARG   149      39.937  11.722 -18.085  1.00 36.03           O
ATOM   1102  N   TRP   150      41.961  12.344 -18.868  1.00 36.17           N
ATOM   1103  CA  TRP   150      41.628  12.164 -20.293  1.00 36.54           C
ATOM   1104  CB  TRP   150      42.794  12.667 -21.164  1.00 37.16           C
ATOM   1105  CG  TRP   150      43.081  11.993 -22.502  1.00 38.14           C
ATOM   1106  CD1 TRP   150      44.122  11.146 -22.774  1.00 39.06           C
ATOM   1107  NE1 TRP   150      44.103  10.769 -24.098  1.00 39.26           N
ATOM   1108  CE2 TRP   150      43.048  11.381 -24.721  1.00 39.17           C
ATOM   1109  CD2 TRP   150      42.383  12.174 -23.749  1.00 38.88           C
ATOM   1110  CE3 TRP   150      41.257  12.915 -24.138  1.00 38.74           C
ATOM   1111  CZ3 TRP   150      40.827  12.834 -25.471  1.00 38.80           C
ATOM   1112  CH2 TRP   150      41.513  12.037 -26.412  1.00 38.81           C
ATOM   1113  CZ2 TRP   150      42.623  11.307 -26.058  1.00 38.82           C
ATOM   1114  C   TRP   150      41.211  10.719 -20.593  1.00 36.22           C
ATOM   1115  O   TRP   150      41.937   9.785 -20.237  1.00 36.04           O
ATOM   1116  N   PRO   151      40.020  10.538 -21.211  1.00 35.99           N
ATOM   1117  CA  PRO   151      39.430   9.216 -21.491  1.00 35.96           C
ATOM   1118  CB  PRO   151      38.157   9.557 -22.274  1.00 35.80           C
ATOM   1119  CG  PRO   151      37.822  10.935 -21.868  1.00 35.74           C
ATOM   1120  CD  PRO   151      39.135  11.627 -21.666  1.00 35.69           C
ATOM   1121  C   PRO   151      40.322   8.257 -22.295  1.00 36.09           C
ATOM   1122  O   PRO   151      40.191   7.041 -22.157  1.00 36.21           O
ATOM   1123  N   GLY   152      41.220   8.797 -23.112  1.00 36.24           N
ATOM   1124  CA  GLY   152      42.182   7.985 -23.858  1.00 36.57           C
ATOM   1125  C   GLY   152      43.137   7.180 -22.990  1.00 36.66           C
ATOM   1126  O   GLY   152      43.840   6.302 -23.491  1.00 36.72           O
ATOM   1127  N   ASN   153      43.154   7.481 -21.690  1.00 36.71           N
ATOM   1128  CA  ASN   153      44.002   6.789 -20.715  1.00 36.57           C
ATOM   1129  CB  ASN   153      44.336   7.719 -19.542  1.00 36.73           C
ATOM   1130  CG  ASN   153      45.299   8.833 -19.926  1.00 37.24           C
ATOM   1131  OD1 ASN   153      45.736   8.937 -21.076  1.00 37.39           O
ATOM   1132  ND2 ASN   153      45.639   9.674 -18.954  1.00 37.93           N
ATOM   1133  C   ASN   153      43.413   5.483 -20.173  1.00 36.36           C
ATOM   1134  O   ASN   153      44.153   4.633 -19.658  1.00 36.39           O
ATOM   1135  N   GLU   154      42.094   5.331 -20.293  1.00 35.86           N
ATOM   1136  CA  GLU   154      41.371   4.197 -19.704  1.00 35.58           C
ATOM   1137  CB  GLU   154      39.974   4.639 -19.253  1.00 35.61           C
ATOM   1138  CG  GLU   154      39.958   5.435 -17.960  1.00 35.95           C
ATOM   1139  CD  GLU   154      38.736   6.328 -17.838  1.00 37.07           C
ATOM   1140  OE1 GLU   154      38.807   7.492 -18.302  1.00 37.56           O
ATOM   1141  OE2 GLU   154      37.710   5.871 -17.275  1.00 36.08           O
ATOM   1142  C   GLU   154      41.269   2.985 -20.632  1.00 35.35           C
ATOM   1143  O   GLU   154      40.960   3.124 -21.819  1.00 35.07           O
ATOM   1144  N   LEU   155      41.509   1.799 -20.069  1.00 35.17           N
ATOM   1145  CA  LEU   155      41.489   0.532 -20.814  1.00 35.16           C
ATOM   1146  CB  LEU   155      41.981  -0.628 -19.934  1.00 35.28           C
ATOM   1147  CG  LEU   155      43.465  -0.742 -19.562  1.00 35.44           C
ATOM   1148  CD1 LEU   155      43.670  -1.903 -18.597  1.00 35.45           C
ATOM   1149  CD2 LEU   155      44.357  -0.905 -20.793  1.00 35.57           C
ATOM   1150  C   LEU   155      40.121   0.175 -21.392  1.00 35.05           C
ATOM   1151  O   LEU   155      40.024  -0.615 -22.336  1.00 35.16           O
ATOM   1152  N   ILE   156      39.071   0.754 -20.817  1.00 34.79           N
ATOM   1153  CA  ILE   156      37.701   0.500 -21.255  1.00 34.82           C
ATOM   1154  CB  ILE   156      36.663   1.013 -20.216  1.00 34.85           C
ATOM   1155  CG1 ILE   156      36.837   0.292 -18.864  1.00 35.36           C
ATOM   1156  CD1 ILE   156      37.877   0.903 -17.914  1.00 34.91           C
ATOM   1157  CG2 ILE   156      35.230   0.788 -20.713  1.00 35.59           C
ATOM   1158  C   ILE   156      37.440   1.080 -22.660  1.00 34.49           C
ATOM   1159  O   ILE   156      36.590   0.577 -23.398  1.00 34.54           O
ATOM   1160  N   TYR   157      38.204   2.108 -23.027  1.00 34.07           N
ATOM   1161  CA  TYR   157      38.073   2.764 -24.331  1.00 34.38           C
ATOM   1162  CB  TYR   157      38.093   4.286 -24.148  1.00 33.70           C
ATOM   1163  CG  TYR   157      37.031   4.764 -23.195  1.00 33.19           C
ATOM   1164  CD1 TYR   157      37.368   5.392 -21.996  1.00 31.86           C
ATOM   1165  CE1 TYR   157      36.389   5.806 -21.118  1.00 32.23           C
ATOM   1166  CZ  TYR   157      35.064   5.571 -21.422  1.00 31.76           C
ATOM   1167  OH  TYR   157      34.062   5.964 -20.582  1.00 32.51           O
ATOM   1168  CE2 TYR   157      34.709   4.945 -22.602  1.00 32.14           C
ATOM   1169  CD2 TYR   157      35.692   4.535 -23.466  1.00 32.04           C
ATOM   1170  C   TYR   157      39.146   2.341 -25.341  1.00 34.92           C
ATOM   1171  O   TYR   157      39.252   2.940 -26.414  1.00 34.95           O
ATOM   1172  N   LYS   158      39.929   1.314 -24.995  1.00 35.28           N
ATOM   1173  CA  LYS   158      41.113   0.924 -25.775  1.00 36.11           C
ATOM   1174  CB  LYS   158      41.709  -0.412 -25.278  1.00 35.98           C
ATOM   1175  CG  LYS   158      40.809  -1.645 -25.463  1.00 36.92           C
ATOM   1176  CD  LYS   158      41.303  -2.851 -24.664  1.00 37.09           C
ATOM   1177  CE  LYS   158      42.504  -3.525 -25.298  1.00 38.65           C
ATOM   1178  NZ  LYS   158      42.854  -4.795 -24.599  1.00 38.95           N
ATOM   1179  C   LYS   158      40.894   0.910 -27.299  1.00 35.91           C
ATOM   1180  O   LYS   158      41.626   1.576 -28.045  1.00 35.95           O
ATOM   1181  N   GLY   159      39.885   0.164 -27.741  1.00 36.04           N
ATOM   1182  CA  GLY   159      39.627  -0.041 -29.165  1.00 35.98           C
ATOM   1183  C   GLY   159      38.577   0.870 -29.773  1.00 36.06           C
ATOM   1184  O   GLY   159      38.058   0.587 -30.851  1.00 35.88           O
ATOM   1185  N   ILE   160      38.263   1.963 -29.083  1.00 36.02           N
ATOM   1186  CA  ILE   160      37.325   2.956 -29.591  1.00 36.25           C
ATOM   1187  CB  ILE   160      36.544   3.648 -28.447  1.00 36.84           C
ATOM   1188  CG1 ILE   160      35.483   2.697 -27.891  1.00 38.41           C
ATOM   1189  CD1 ILE   160      35.001   3.094 -26.532  1.00 41.30           C
ATOM   1190  CG2 ILE   160      35.837   4.911 -28.927  1.00 36.58           C
ATOM   1191  C   ILE   160      38.054   3.988 -30.449  1.00 36.06           C
ATOM   1192  O   ILE   160      39.137   4.465 -30.094  1.00 35.48           O
ATOM   1193  N   CYS   161      37.450   4.305 -31.590  1.00 35.55           N
ATOM   1194  CA  CYS   161      37.917   5.369 -32.458  1.00 35.59           C
ATOM   1195  CB  CYS   161      36.856   5.643 -33.522  1.00 35.26           C
ATOM   1196  SG  CYS   161      37.359   6.815 -34.753  1.00 35.66           S
ATOM   1197  C   CYS   161      38.229   6.649 -31.663  1.00 35.60           C
ATOM   1198  O   CYS   161      37.341   7.215 -31.027  1.00 35.31           O
ATOM   1199  N   PRO   162      39.498   7.104 -31.694  1.00 36.14           N
ATOM   1200  CA  PRO   162      39.946   8.251 -30.885  1.00 36.45           C
ATOM   1201  CB  PRO   162      41.345   8.532 -31.428  1.00 36.51           C
ATOM   1202  CG  PRO   162      41.813   7.195 -31.898  1.00 36.69           C
ATOM   1203  CD  PRO   162      40.605   6.527 -32.478  1.00 35.85           C
ATOM   1204  C   PRO   162      39.063   9.507 -30.949  1.00 36.77           C
ATOM   1205  O   PRO   162      38.890  10.167 -29.928  1.00 36.69           O
ATOM   1206  N   SER   163      38.505   9.820 -32.119  1.00 37.00           N
ATOM   1207  CA  SER   163      37.648  11.004 -32.285  1.00 37.19           C
ATOM   1208  CB  SER   163      37.242  11.210 -33.760  1.00 37.13           C
ATOM   1209  OG  SER   163      36.358  10.201 -34.228  1.00 35.79           O
ATOM   1210  C   SER   163      36.405  10.973 -31.396  1.00 37.56           C
ATOM   1211  O   SER   163      35.808  12.013 -31.126  1.00 37.90           O
ATOM   1212  N   CYS   164      36.027   9.779 -30.948  1.00 37.99           N
ATOM   1213  CA  CYS   164      34.864   9.596 -30.083  1.00 38.22           C
ATOM   1214  CB  CYS   164      34.498   8.121 -29.999  1.00 38.43           C
ATOM   1215  SG  CYS   164      34.083   7.365 -31.558  1.00 39.46           S
ATOM   1216  C   CYS   164      35.095  10.102 -28.660  1.00 38.26           C
ATOM   1217  O   CYS   164      34.141  10.488 -27.980  1.00 38.44           O
ATOM   1218  N   LEU   165      36.353  10.083 -28.218  1.00 37.77           N
ATOM   1219  CA  LEU   165      36.708  10.376 -26.823  1.00 37.54           C
ATOM   1220  CB  LEU   165      37.989   9.623 -26.431  1.00 37.33           C
ATOM   1221  CG  LEU   165      38.001   8.113 -26.712  1.00 37.64           C
ATOM   1222  CD1 LEU   165      39.317   7.486 -26.289  1.00 37.14           C
ATOM   1223  CD2 LEU   165      36.812   7.389 -26.059  1.00 36.16           C
ATOM   1224  C   LEU   165      36.868  11.878 -26.560  1.00 37.18           C
ATOM   1225  O   LEU   165      37.864  12.462 -26.960  1.00 36.69           O
ATOM   1226  N   PRO   166      35.888  12.498 -25.867  1.00 37.06           N
ATOM   1227  CA  PRO   166      35.902  13.949 -25.686  1.00 37.07           C
ATOM   1228  CB  PRO   166      34.453  14.270 -25.293  1.00 36.99           C
ATOM   1229  CG  PRO   166      33.926  13.041 -24.700  1.00 37.02           C
ATOM   1230  CD  PRO   166      34.728  11.874 -25.204  1.00 37.22           C
ATOM   1231  C   PRO   166      36.878  14.440 -24.610  1.00 36.70           C
ATOM   1232  O   PRO   166      37.186  13.715 -23.660  1.00 36.35           O
ATOM   1233  N   THR   167      37.362  15.665 -24.792  1.00 36.59           N
ATOM   1234  CA  THR   167      38.188  16.345 -23.803  1.00 36.62           C
ATOM   1235  CB  THR   167      39.287  17.187 -24.474  1.00 36.50           C
ATOM   1236  OG1 THR   167      38.694  18.071 -25.433  1.00 36.63           O
ATOM   1237  CG2 THR   167      40.312  16.303 -25.165  1.00 36.03           C
ATOM   1238  C   THR   167      37.292  17.261 -22.971  1.00 36.73           C
ATOM   1239  O   THR   167      37.721  17.827 -21.954  1.00 37.17           O
ATOM   1240  N   THR   168      36.046  17.395 -23.433  1.00 36.48           N
ATOM   1241  CA  THR   168      35.006  18.211 -22.802  1.00 35.79           C
ATOM   1242  CB  THR   168      35.408  19.714 -22.701  1.00 35.50           C
ATOM   1243  OG1 THR   168      34.562  20.377 -21.756  1.00 33.36           O
ATOM   1244  CG2 THR   168      35.310  20.432 -24.062  1.00 36.00           C
ATOM   1245  C   THR   168      33.714  18.069 -23.607  1.00 35.54           C
ATOM   1246  O   THR   168      33.757  17.683 -24.780  1.00 35.67           O
ATOM   1247  N   GLU   169      32.578  18.368 -22.973  1.00 34.98           N
ATOM   1248  CA  GLU   169      31.280  18.340 -23.646  0.50 34.66           C
ATOM   1250  CB  GLU   169      30.622  16.971 -23.511  0.50 34.61           C
ATOM   1252  CG  GLU   169      31.106  15.916 -24.487  0.50 34.30           C
ATOM   1254  CD  GLU   169      30.224  14.689 -24.491  0.50 33.89           C
ATOM   1256  OE1 GLU   169      29.322  14.600 -23.628  0.50 34.47           O
ATOM   1258  OE2 GLU   169      30.434  13.802 -25.350  0.50 33.39           O
ATOM   1260  C   GLU   169      30.329  19.377 -23.078  1.00 34.66           C
ATOM   1261  O   GLU   169      30.278  19.591 -21.865  1.00 34.67           O
ATOM   1262  N   CYS   170      29.575  20.015 -23.965  1.00 34.24           N
ATOM   1263  CA  CYS   170      28.418  20.791 -23.561  1.00 34.01           C
ATOM   1264  CB  CYS   170      28.291  22.076 -24.390  1.00 34.26           C
ATOM   1265  SG  CYS   170      28.277  21.825 -26.186  1.00 34.21           S
ATOM   1266  C   CYS   170      27.262  19.827 -23.815  1.00 33.72           C
ATOM   1267  O   CYS   170      27.482  18.733 -24.341  1.00 33.63           O
ATOM   1268  N   LEU   171      26.043  20.203 -23.446  1.00 33.65           N
ATOM   1269  CA  LEU   171      24.895  19.329 -23.689  1.00 33.95           C
ATOM   1270  CB  LEU   171      23.622  19.879 -23.036  1.00 33.94           C
ATOM   1271  CG  LEU   171      22.386  18.967 -23.029  1.00 34.64           C
ATOM   1272  CD1 LEU   171      22.639  17.638 -22.305  1.00 35.63           C
ATOM   1273  CD2 LEU   171      21.192  19.685 -22.426  1.00 34.36           C
ATOM   1274  C   LEU   171      24.670  19.075 -25.183  1.00 34.17           C
ATOM   1275  O   LEU   171      24.297  17.969 -25.561  1.00 34.57           O
ATOM   1276  N   LYS   172      24.904  20.096 -26.014  1.00 34.23           N
ATOM   1277  CA  LYS   172      24.820  19.963 -27.478  1.00 34.44           C
ATOM   1278  CB  LYS   172      25.256  21.261 -28.162  1.00 34.62           C
ATOM   1279  CG  LYS   172      24.944  21.334 -29.652  1.00 35.23           C
ATOM   1280  CD  LYS   172      25.566  22.573 -30.276  1.00 37.37           C
ATOM   1281  CE  LYS   172      26.971  22.286 -30.811  1.00 39.25           C
ATOM   1282  NZ  LYS   172      26.959  21.649 -32.172  1.00 37.97           N
ATOM   1283  C   LYS   172      25.653  18.783 -27.973  1.00 34.39           C
ATOM   1284  O   LYS   172      25.129  17.895 -28.645  1.00 34.06           O
ATOM   1285  N   ASP   173      26.937  18.767 -27.609  1.00 34.69           N
ATOM   1286  CA  ASP   173      27.838  17.628 -27.868  1.00 35.17           C
ATOM   1287  CB  ASP   173      29.173  17.820 -27.144  1.00 35.11           C
ATOM   1288  CG  ASP   173      29.948  19.017 -27.636  1.00 36.04           C
ATOM   1289  OD1 ASP   173      29.942  19.304 -28.861  1.00 35.21           O
ATOM   1290  OD2 ASP   173      30.581  19.674 -26.779  1.00 36.42           O
ATOM   1291  C   ASP   173      27.274  16.260 -27.464  1.00 35.43           C
ATOM   1292  O   ASP   173      27.392  15.290 -28.214  1.00 35.89           O
ATOM   1293  N   THR   174      26.705  16.174 -26.261  1.00 35.60           N
ATOM   1294  CA  THR   174      26.137  14.928 -25.755  1.00 35.60           C
ATOM   1295  CB  THR   174      25.644  15.077 -24.289  1.00 35.65           C
ATOM   1296  OG1 THR   174      26.715  15.568 -23.475  1.00 35.92           O
ATOM   1297  CG2 THR   174      25.172  13.739 -23.734  1.00 36.00           C
ATOM   1298  C   THR   174      24.992  14.460 -26.647  1.00 35.27           C
ATOM   1299  O   THR   174      24.940  13.285 -27.030  1.00 35.45           O
ATOM   1300  N   VAL   175      24.090  15.388 -26.979  1.00 35.32           N
ATOM   1301  CA  VAL   175      22.961  15.116 -27.877  1.00 35.55           C
ATOM   1302  CB  VAL   175      22.120  16.402 -28.131  1.00 35.70           C
ATOM   1303  CG1 VAL   175      21.191  16.237 -29.341  1.00 35.64           C
ATOM   1304  CG2 VAL   175      21.330  16.785 -26.890  1.00 35.98           C
ATOM   1305  C   VAL   175      23.464  14.532 -29.208  1.00 35.60           C
ATOM   1306  O   VAL   175      22.967  13.501 -29.676  1.00 35.27           O
ATOM   1307  N   GLU   176      24.477  15.179 -29.780  1.00 35.59           N
ATOM   1308  CA  GLU   176      25.021  14.785 -31.082  1.00 36.16           C
ATOM   1309  CB  GLU   176      25.977  15.862 -31.612  1.00 35.82           C
ATOM   1310  CG  GLU   176      25.277  17.223 -31.767  1.00 37.11           C
ATOM   1311  CD  GLU   176      26.082  18.277 -32.529  1.00 37.92           C
ATOM   1312  OE1 GLU   176      27.234  17.997 -32.943  1.00 42.16           O
ATOM   1313  OE2 GLU   176      25.545  19.389 -32.727  1.00 37.56           O
ATOM   1314  C   GLU   176      25.644  13.377 -31.084  1.00 35.52           C
ATOM   1315  O   GLU   176      25.551  12.655 -32.076  1.00 35.32           O
ATOM   1316  N   ARG   177      26.245  12.968 -29.972  1.00 35.16           N
ATOM   1317  CA  ARG   177      26.779  11.600 -29.901  1.00 34.66           C
ATOM   1318  CB  ARG   177      28.134  11.535 -29.193  1.00 34.80           C
ATOM   1319  CG  ARG   177      28.181  12.128 -27.786  1.00 33.09           C
ATOM   1320  CD  ARG   177      27.858  11.120 -26.711  1.00 31.63           C
ATOM   1321  NE  ARG   177      28.358  11.614 -25.425  1.00 31.72           N
ATOM   1322  CZ  ARG   177      27.969  11.189 -24.228  1.00 30.91           C
ATOM   1323  NH1 ARG   177      28.507  11.745 -23.149  1.00 31.05           N
ATOM   1324  NH2 ARG   177      27.054  10.226 -24.100  1.00 30.44           N
ATOM   1325  C   ARG   177      25.789  10.550 -29.396  1.00 34.59           C
ATOM   1326  O   ARG   177      25.965   9.367 -29.666  1.00 34.76           O
ATOM   1327  N   VAL   178      24.731  10.983 -28.709  1.00 34.71           N
ATOM   1328  CA  VAL   178      23.652  10.073 -28.305  1.00 34.64           C
ATOM   1329  CB  VAL   178      22.790  10.629 -27.117  1.00 35.17           C
ATOM   1330  CG1 VAL   178      21.477   9.850 -26.974  1.00 34.83           C
ATOM   1331  CG2 VAL   178      23.567  10.571 -25.784  1.00 34.59           C
ATOM   1332  C   VAL   178      22.742   9.742 -29.495  1.00 34.57           C
ATOM   1333  O   VAL   178      22.316   8.601 -29.647  1.00 34.28           O
ATOM   1334  N   LYS   179      22.442  10.756 -30.309  1.00 34.58           N
ATOM   1335  CA  LYS   179      21.507  10.646 -31.453  1.00 34.29           C
ATOM   1336  CB  LYS   179      21.507  11.948 -32.268  1.00 34.27           C
ATOM   1337  CG  LYS   179      20.580  11.963 -33.468  1.00 33.94           C
ATOM   1338  CD  LYS   179      20.415  13.376 -33.998  1.00 36.39           C
ATOM   1339  CE  LYS   179      20.099  13.397 -35.485  1.00 35.83           C
ATOM   1340  NZ  LYS   179      19.572  14.730 -35.881  1.00 37.98           N
ATOM   1341  C   LYS   179      21.685   9.397 -32.363  1.00 34.25           C
ATOM   1342  O   LYS   179      20.740   8.631 -32.529  1.00 34.16           O
ATOM   1343  N   PRO   180      22.883   9.194 -32.948  1.00 34.28           N
ATOM   1344  CA  PRO   180      23.067   8.019 -33.806  1.00 34.24           C
ATOM   1345  CB  PRO   180      24.481   8.209 -34.352  1.00 34.29           C
ATOM   1346  CG  PRO   180      25.173   9.075 -33.321  1.00 34.09           C
ATOM   1347  CD  PRO   180      24.106  10.021 -32.894  1.00 33.99           C
ATOM   1348  C   PRO   180      22.970   6.686 -33.058  1.00 34.82           C
ATOM   1349  O   PRO   180      22.667   5.665 -33.675  1.00 34.60           O
ATOM   1350  N   TYR   181      23.219   6.696 -31.742  1.00 34.93           N
ATOM   1351  CA  TYR   181      23.048   5.485 -30.949  1.00 34.77           C
ATOM   1352  CB  TYR   181      23.742   5.572 -29.581  1.00 35.03           C
ATOM   1353  CG  TYR   181      23.914   4.200 -28.956  1.00 34.88           C
ATOM   1354  CD1 TYR   181      24.794   3.269 -29.510  1.00 34.72           C
ATOM   1355  CE1 TYR   181      24.944   1.998 -28.952  1.00 35.45           C
ATOM   1356  CZ  TYR   181      24.193   1.648 -27.847  1.00 34.47           C
ATOM   1357  OH  TYR   181      24.347   0.402 -27.304  1.00 35.24           O
ATOM   1358  CE2 TYR   181      23.302   2.541 -27.285  1.00 34.01           C
ATOM   1359  CD2 TYR   181      23.170   3.817 -27.836  1.00 34.67           C
ATOM   1360  C   TYR   181      21.570   5.127 -30.798  1.00 34.44           C
ATOM   1361  O   TYR   181      21.199   3.968 -30.958  1.00 34.39           O
ATOM   1362  N   PHE   182      20.724   6.118 -30.530  1.00 34.50           N
ATOM   1363  CA  PHE   182      19.274   5.881 -30.603  1.00 34.90           C
ATOM   1364  CB  PHE   182      18.432   7.085 -30.162  1.00 34.43           C
ATOM   1365  CG  PHE   182      16.952   6.819 -30.252  1.00 36.26           C
ATOM   1366  CD1 PHE   182      16.299   6.124 -29.238  1.00 36.24           C
ATOM   1367  CE1 PHE   182      14.941   5.830 -29.334  1.00 36.88           C
ATOM   1368  CZ  PHE   182      14.219   6.217 -30.463  1.00 36.23           C
ATOM   1369  CE2 PHE   182      14.864   6.899 -31.494  1.00 37.33           C
ATOM   1370  CD2 PHE   182      16.223   7.189 -31.388  1.00 35.96           C
ATOM   1371  C   PHE   182      18.844   5.460 -32.015  1.00 34.62           C
ATOM   1372  O   PHE   182      18.100   4.488 -32.188  1.00 34.37           O
ATOM   1373  N   GLU   183      19.300   6.209 -33.017  1.00 34.61           N
ATOM   1374  CA  GLU   183      18.904   5.950 -34.401  1.00 33.87           C
ATOM   1375  CB  GLU   183      19.554   6.974 -35.334  1.00 34.00           C
ATOM   1376  CG  GLU   183      18.907   8.350 -35.211  1.00 34.21           C
ATOM   1377  CD  GLU   183      19.552   9.421 -36.066  1.00 34.47           C
ATOM   1378  OE1 GLU   183      20.778   9.367 -36.311  1.00 35.44           O
ATOM   1379  OE2 GLU   183      18.817  10.336 -36.471  1.00 35.33           O
ATOM   1380  C   GLU   183      19.205   4.522 -34.858  1.00 33.67           C
ATOM   1381  O   GLU   183      18.308   3.829 -35.350  1.00 33.58           O
ATOM   1382  N   ASP   184      20.448   4.071 -34.658  1.00 33.61           N
ATOM   1383  CA  ASP   184      20.916   2.813 -35.261  1.00 33.59           C
ATOM   1384  CB  ASP   184      22.330   2.986 -35.824  1.00 33.65           C
ATOM   1385  CG  ASP   184      22.371   3.912 -37.049  1.00 33.72           C
ATOM   1386  OD1 ASP   184      21.351   4.559 -37.349  1.00 31.54           O
ATOM   1387  OD2 ASP   184      23.435   3.997 -37.702  1.00 34.32           O
ATOM   1388  C   ASP   184      20.870   1.577 -34.365  1.00 33.87           C
ATOM   1389  O   ASP   184      20.951   0.442 -34.863  1.00 33.48           O
ATOM   1390  N   VAL   185      20.740   1.786 -33.055  1.00 33.83           N
ATOM   1391  CA  VAL   185      20.799   0.679 -32.091  1.00 33.71           C
ATOM   1392  CB  VAL   185      22.048   0.766 -31.173  1.00 33.87           C
ATOM   1393  CG1 VAL   185      22.048  -0.374 -30.169  1.00 33.19           C
ATOM   1394  CG2 VAL   185      23.310   0.745 -32.005  1.00 32.65           C
ATOM   1395  C   VAL   185      19.526   0.531 -31.265  1.00 34.22           C
ATOM   1396  O   VAL   185      18.901  -0.537 -31.281  1.00 34.02           O
ATOM   1397  N   ILE   186      19.138   1.593 -30.549  1.00 34.24           N
ATOM   1398  CA  ILE   186      17.965   1.536 -29.681  1.00 34.27           C
ATOM   1399  CB  ILE   186      17.948   2.692 -28.621  1.00 34.32           C
ATOM   1400  CG1 ILE   186      19.253   2.700 -27.815  1.00 34.25           C
ATOM   1401  CD1 ILE   186      19.376   3.833 -26.764  1.00 34.52           C
ATOM   1402  CG2 ILE   186      16.706   2.578 -27.741  1.00 33.53           C
ATOM   1403  C   ILE   186      16.654   1.550 -30.478  1.00 34.47           C
ATOM   1404  O   ILE   186      15.719   0.792 -30.177  1.00 34.09           O
ATOM   1405  N   ALA   187      16.574   2.417 -31.489  1.00 34.49           N
ATOM   1406  CA  ALA   187      15.371   2.486 -32.318  1.00 34.46           C
ATOM   1407  CB  ALA   187      15.494   3.586 -33.386  1.00 34.51           C
ATOM   1408  C   ALA   187      14.944   1.138 -32.936  1.00 34.61           C
ATOM   1409  O   ALA   187      13.762   0.773 -32.836  1.00 34.83           O
ATOM   1410  N   PRO   188      15.882   0.409 -33.590  1.00 34.93           N
ATOM   1411  CA  PRO   188      15.556  -0.914 -34.160  1.00 35.15           C
ATOM   1412  CB  PRO   188      16.886  -1.386 -34.752  1.00 35.11           C
ATOM   1413  CG  PRO   188      17.667  -0.160 -34.959  1.00 35.38           C
ATOM   1414  CD  PRO   188      17.267   0.800 -33.906  1.00 34.42           C
ATOM   1415  C   PRO   188      15.050  -1.934 -33.142  1.00 35.20           C
ATOM   1416  O   PRO   188      14.152  -2.716 -33.463  1.00 34.39           O
ATOM   1417  N   SER   189      15.623  -1.926 -31.934  1.00 34.89           N
ATOM   1418  CA  SER   189      15.134  -2.787 -30.855  1.00 35.23           C
ATOM   1419  CB  SER   189      15.989  -2.635 -29.599  1.00 34.99           C
ATOM   1420  OG  SER   189      17.290  -3.141 -29.836  1.00 36.61           O
ATOM   1421  C   SER   189      13.688  -2.495 -30.517  1.00 34.97           C
ATOM   1422  O   SER   189      12.886  -3.412 -30.375  1.00 35.00           O
ATOM   1423  N   ILE   190      13.367  -1.213 -30.376  1.00 35.44           N
ATOM   1424  CA  ILE   190      11.996  -0.767 -30.138  1.00 35.94           C
ATOM   1425  CB  ILE   190      11.924   0.777 -29.961  1.00 36.21           C
ATOM   1426  CG1 ILE   190      12.680   1.221 -28.696  1.00 35.70           C
ATOM   1427  CD1 ILE   190      12.930   2.713 -28.639  1.00 35.64           C
ATOM   1428  CG2 ILE   190      10.474   1.250 -29.906  1.00 35.30           C
ATOM   1429  C   ILE   190      11.055  -1.199 -31.268  1.00 36.90           C
ATOM   1430  O   ILE   190       9.986  -1.768 -31.018  1.00 36.84           O
ATOM   1431  N   MET   191      11.456  -0.928 -32.507  1.00 37.76           N
ATOM   1432  CA  MET   191      10.618  -1.250 -33.665  1.00 38.72           C
ATOM   1433  CB  MET   191      11.179  -0.601 -34.938  1.00 38.82           C
ATOM   1434  CG  MET   191      11.169   0.930 -34.922  1.00 39.13           C
ATOM   1435  SD  MET   191      11.746   1.696 -36.462  1.00 40.72           S
ATOM   1436  CE  MET   191      13.504   1.621 -36.237  1.00 37.75           C
ATOM   1437  C   MET   191      10.431  -2.764 -33.832  1.00 38.75           C
ATOM   1438  O   MET   191       9.444  -3.201 -34.406  1.00 39.01           O
ATOM   1439  N   SER   192      11.370  -3.555 -33.304  1.00 39.30           N
ATOM   1440  CA  SER   192      11.280  -5.028 -33.302  1.00 39.60           C
ATOM   1441  CB  SER   192      12.609  -5.639 -32.846  1.00 40.23           C
ATOM   1442  OG  SER   192      13.692  -5.162 -33.619  1.00 43.38           O
ATOM   1443  C   SER   192      10.192  -5.574 -32.376  1.00 39.06           C
ATOM   1444  O   SER   192       9.867  -6.762 -32.430  1.00 38.68           O
ATOM   1445  N   GLY   193       9.665  -4.715 -31.506  1.00 38.52           N
ATOM   1446  CA  GLY   193       8.717  -5.123 -30.475  1.00 38.31           C
ATOM   1447  C   GLY   193       9.349  -5.468 -29.131  1.00 38.26           C
ATOM   1448  O   GLY   193       8.661  -5.944 -28.232  1.00 38.25           O
ATOM   1449  N   LYS   194      10.655  -5.244 -28.989  1.00 38.02           N
ATOM   1450  CA  LYS   194      11.329  -5.515 -27.719  1.00 38.23           C
ATOM   1451  CB  LYS   194      12.853  -5.531 -27.880  1.00 38.03           C
ATOM   1452  CG  LYS   194      13.382  -6.738 -28.656  1.00 38.48           C
ATOM   1453  CD  LYS   194      14.907  -6.738 -28.701  1.00 39.28           C
ATOM   1454  CE  LYS   194      15.452  -7.944 -29.456  1.00 41.32           C
ATOM   1455  NZ  LYS   194      15.349  -7.819 -30.947  1.00 43.74           N
ATOM   1456  C   LYS   194      10.906  -4.544 -26.612  1.00 37.89           C
ATOM   1457  O   LYS   194      10.557  -3.385 -26.873  1.00 37.49           O
ATOM   1458  N   SER   195      10.912  -5.050 -25.381  1.00 37.71           N
ATOM   1459  CA  SER   195      10.724  -4.232 -24.193  1.00 37.14           C
ATOM   1460  CB  SER   195      10.005  -5.042 -23.103  1.00 37.51           C
ATOM   1461  OG  SER   195       9.676  -4.226 -22.000  1.00 38.00           O
ATOM   1462  C   SER   195      12.092  -3.734 -23.736  1.00 36.26           C
ATOM   1463  O   SER   195      12.937  -4.509 -23.290  1.00 35.40           O
ATOM   1464  N   VAL   196      12.306  -2.429 -23.869  1.00 35.47           N
ATOM   1465  CA  VAL   196      13.631  -1.839 -23.733  1.00 35.07           C
ATOM   1466  CB  VAL   196      14.015  -1.013 -24.994  1.00 35.02           C
ATOM   1467  CG1 VAL   196      15.395  -0.376 -24.827  1.00 34.79           C
ATOM   1468  CG2 VAL   196      13.971  -1.889 -26.262  1.00 35.28           C
ATOM   1469  C   VAL   196      13.740  -0.917 -22.516  1.00 35.05           C
ATOM   1470  O   VAL   196      12.893  -0.054 -22.300  1.00 35.40           O
ATOM   1471  N   LEU   197      14.793  -1.113 -21.737  1.00 35.35           N
ATOM   1472  CA  LEU   197      15.151  -0.171 -20.673  1.00 35.02           C
ATOM   1473  CB  LEU   197      15.358  -0.914 -19.339  1.00 35.01           C
ATOM   1474  CG  LEU   197      15.835  -0.120 -18.115  1.00 34.65           C
ATOM   1475  CD1 LEU   197      14.739   0.831 -17.654  1.00 33.73           C
ATOM   1476  CD2 LEU   197      16.254  -1.072 -16.979  1.00 35.06           C
ATOM   1477  C   LEU   197      16.431   0.523 -21.080  1.00 34.74           C
ATOM   1478  O   LEU   197      17.354  -0.119 -21.565  1.00 35.19           O
ATOM   1479  N   VAL   198      16.487   1.835 -20.893  1.00 35.01           N
ATOM   1480  CA  VAL   198      17.758   2.546 -20.970  1.00 34.75           C
ATOM   1481  CB  VAL   198      17.685   3.788 -21.883  1.00 34.85           C
ATOM   1482  CG1 VAL   198      19.031   4.500 -21.905  1.00 34.41           C
ATOM   1483  CG2 VAL   198      17.260   3.400 -23.317  1.00 34.76           C
ATOM   1484  C   VAL   198      18.174   2.988 -19.561  1.00 35.18           C
ATOM   1485  O   VAL   198      17.485   3.799 -18.933  1.00 34.93           O
ATOM   1486  N   SER   199      19.298   2.452 -19.087  1.00 35.57           N
ATOM   1487  CA  SER   199      19.803   2.730 -17.745  1.00 35.87           C
ATOM   1488  CB  SER   199      20.044   1.426 -16.982  1.00 36.11           C
ATOM   1489  OG  SER   199      20.576   1.674 -15.686  1.00 37.01           O
ATOM   1490  C   SER   199      21.086   3.527 -17.887  1.00 35.37           C
ATOM   1491  O   SER   199      22.113   2.995 -18.282  1.00 35.77           O
ATOM   1492  N   ALA   200      21.016   4.820 -17.584  1.00 35.35           N
ATOM   1493  CA  ALA   200      22.127   5.717 -17.882  1.00 34.85           C
ATOM   1494  CB  ALA   200      22.039   6.229 -19.348  1.00 34.83           C
ATOM   1495  C   ALA   200      22.210   6.872 -16.888  1.00 34.69           C
ATOM   1496  O   ALA   200      22.139   6.648 -15.676  1.00 34.47           O
ATOM   1497  N   HIS   201      22.384   8.092 -17.402  1.00 34.26           N
ATOM   1498  CA  HIS   201      22.778   9.245 -16.579  1.00 33.76           C
ATOM   1499  CB  HIS   201      24.246   9.585 -16.824  1.00 33.06           C
ATOM   1500  CG  HIS   201      25.160   8.401 -16.757  1.00 32.72           C
ATOM   1501  ND1 HIS   201      25.745   7.977 -15.583  1.00 30.29           N
ATOM   1502  CE1 HIS   201      26.495   6.916 -15.825  1.00 31.77           C
ATOM   1503  NE2 HIS   201      26.406   6.627 -17.115  1.00 31.86           N
ATOM   1504  CD2 HIS   201      25.578   7.543 -17.719  1.00 31.51           C
ATOM   1505  C   HIS   201      21.922  10.464 -16.886  1.00 34.07           C
ATOM   1506  O   HIS   201      21.240  10.501 -17.919  1.00 33.95           O
ATOM   1507  N   GLY   202      21.996  11.467 -16.011  1.00 33.60           N
ATOM   1508  CA  GLY   202      21.238  12.705 -16.150  1.00 33.93           C
ATOM   1509  C   GLY   202      21.284  13.331 -17.536  1.00 34.20           C
ATOM   1510  O   GLY   202      20.244  13.531 -18.157  1.00 34.07           O
ATOM   1511  N   ASN   203      22.487  13.617 -18.026  1.00 34.06           N
ATOM   1512  CA  ASN   203      22.638  14.303 -19.307  1.00 34.51           C
ATOM   1513  CB  ASN   203      23.978  15.042 -19.370  1.00 34.68           C
ATOM   1514  CG  ASN   203      24.032  16.239 -18.418  1.00 35.97           C
ATOM   1515  OD1 ASN   203      23.297  17.219 -18.583  1.00 37.34           O
ATOM   1516  ND2 ASN   203      24.912  16.166 -17.426  1.00 36.74           N
ATOM   1517  C   ASN   203      22.405  13.429 -20.546  1.00 34.49           C
ATOM   1518  O   ASN   203      21.887  13.920 -21.549  1.00 34.84           O
ATOM   1519  N   SER   204      22.783  12.150 -20.467  1.00 34.47           N
ATOM   1520  CA  SER   204      22.453  11.133 -21.482  1.00 34.75           C
ATOM   1521  CB  SER   204      22.956   9.755 -21.032  1.00 35.10           C
ATOM   1522  OG  SER   204      24.355   9.705 -21.019  1.00 38.13           O
ATOM   1523  C   SER   204      20.955  10.992 -21.696  1.00 34.55           C
ATOM   1524  O   SER   204      20.476  10.935 -22.835  1.00 34.21           O
ATOM   1525  N   LEU   205      20.222  10.886 -20.594  1.00 34.47           N
ATOM   1526  CA  LEU   205      18.766  10.766 -20.661  1.00 34.97           C
ATOM   1527  CB  LEU   205      18.189  10.280 -19.324  1.00 35.60           C
ATOM   1528  CG  LEU   205      18.486   8.848 -18.854  1.00 37.35           C
ATOM   1529  CD1 LEU   205      17.616   8.564 -17.639  1.00 38.43           C
ATOM   1530  CD2 LEU   205      18.248   7.782 -19.939  1.00 37.36           C
ATOM   1531  C   LEU   205      18.076  12.061 -21.118  1.00 34.82           C
ATOM   1532  O   LEU   205      17.091  12.006 -21.856  1.00 34.96           O
ATOM   1533  N   ARG   206      18.581  13.215 -20.679  1.00 34.94           N
ATOM   1534  CA  ARG   206      18.072  14.511 -21.166  1.00 35.22           C
ATOM   1535  CB  ARG   206      18.652  15.685 -20.370  1.00 35.02           C
ATOM   1536  CG  ARG   206      18.000  15.866 -18.989  1.00 35.64           C
ATOM   1537  CD  ARG   206      18.790  16.801 -18.078  1.00 35.37           C
ATOM   1538  NE  ARG   206      18.639  18.207 -18.435  1.00 35.54           N
ATOM   1539  CZ  ARG   206      19.644  19.070 -18.587  1.00 35.70           C
ATOM   1540  NH1 ARG   206      19.383  20.327 -18.915  1.00 34.85           N
ATOM   1541  NH2 ARG   206      20.905  18.690 -18.406  1.00 35.58           N
ATOM   1542  C   ARG   206      18.315  14.693 -22.672  1.00 34.98           C
ATOM   1543  O   ARG   206      17.448  15.201 -23.382  1.00 34.97           O
ATOM   1544  N   ALA   207      19.489  14.268 -23.141  1.00 35.10           N
ATOM   1545  CA  ALA   207      19.788  14.189 -24.579  1.00 35.28           C
ATOM   1546  CB  ALA   207      21.185  13.598 -24.814  1.00 35.14           C
ATOM   1547  C   ALA   207      18.721  13.378 -25.332  1.00 35.40           C
ATOM   1548  O   ALA   207      18.219  13.819 -26.368  1.00 35.03           O
ATOM   1549  N   LEU   208      18.372  12.208 -24.798  1.00 35.23           N
ATOM   1550  CA  LEU   208      17.307  11.391 -25.379  1.00 35.58           C
ATOM   1551  CB  LEU   208      17.215  10.026 -24.692  1.00 35.71           C
ATOM   1552  CG  LEU   208      18.206   8.966 -25.155  1.00 37.39           C
ATOM   1553  CD1 LEU   208      18.132   7.751 -24.230  1.00 38.38           C
ATOM   1554  CD2 LEU   208      17.957   8.554 -26.626  1.00 37.00           C
ATOM   1555  C   LEU   208      15.947  12.076 -25.378  1.00 35.09           C
ATOM   1556  O   LEU   208      15.220  11.994 -26.368  1.00 35.60           O
ATOM   1557  N   LEU   209      15.610  12.759 -24.284  1.00 34.50           N
ATOM   1558  CA  LEU   209      14.362  13.525 -24.199  1.00 33.84           C
ATOM   1559  CB  LEU   209      14.113  14.034 -22.776  1.00 33.79           C
ATOM   1560  CG  LEU   209      13.777  13.057 -21.644  1.00 33.78           C
ATOM   1561  CD1 LEU   209      13.421  13.852 -20.390  1.00 34.24           C
ATOM   1562  CD2 LEU   209      12.635  12.100 -22.012  1.00 32.69           C
ATOM   1563  C   LEU   209      14.329  14.706 -25.164  1.00 33.42           C
ATOM   1564  O   LEU   209      13.285  15.022 -25.726  1.00 32.91           O
ATOM   1565  N   TYR   210      15.474  15.364 -25.323  1.00 33.15           N
ATOM   1566  CA  TYR   210      15.626  16.451 -26.273  1.00 33.18           C
ATOM   1567  CB  TYR   210      17.047  17.011 -26.187  1.00 33.14           C
ATOM   1568  CG  TYR   210      17.392  18.016 -27.261  1.00 33.37           C
ATOM   1569  CD1 TYR   210      17.112  19.371 -27.091  1.00 32.43           C
ATOM   1570  CE1 TYR   210      17.433  20.299 -28.074  1.00 33.84           C
ATOM   1571  CZ  TYR   210      18.037  19.874 -29.243  1.00 33.13           C
ATOM   1572  OH  TYR   210      18.357  20.789 -30.211  1.00 33.37           O
ATOM   1573  CE2 TYR   210      18.327  18.537 -29.439  1.00 33.80           C
ATOM   1574  CD2 TYR   210      18.005  17.612 -28.446  1.00 34.10           C
ATOM   1575  C   TYR   210      15.308  15.962 -27.700  1.00 33.31           C
ATOM   1576  O   TYR   210      14.544  16.588 -28.417  1.00 33.00           O
ATOM   1577  N   LEU   211      15.880  14.823 -28.076  1.00 33.46           N
ATOM   1578  CA  LEU   211      15.662  14.237 -29.399  1.00 33.80           C
ATOM   1579  CB  LEU   211      16.684  13.131 -29.662  1.00 33.30           C
ATOM   1580  CG  LEU   211      18.129  13.634 -29.741  1.00 33.08           C
ATOM   1581  CD1 LEU   211      19.104  12.513 -29.452  1.00 30.73           C
ATOM   1582  CD2 LEU   211      18.414  14.317 -31.096  1.00 31.01           C
ATOM   1583  C   LEU   211      14.242  13.720 -29.599  1.00 34.25           C
ATOM   1584  O   LEU   211      13.582  14.088 -30.576  1.00 34.77           O
ATOM   1585  N   LEU   212      13.772  12.887 -28.671  1.00 34.73           N
ATOM   1586  CA  LEU   212      12.481  12.193 -28.816  1.00 35.32           C
ATOM   1587  CB  LEU   212      12.404  10.979 -27.876  1.00 34.85           C
ATOM   1588  CG  LEU   212      13.527   9.937 -27.989  1.00 36.03           C
ATOM   1589  CD1 LEU   212      13.236   8.713 -27.116  1.00 36.30           C
ATOM   1590  CD2 LEU   212      13.812   9.526 -29.435  1.00 36.07           C
ATOM   1591  C   LEU   212      11.244  13.076 -28.638  1.00 35.49           C
ATOM   1592  O   LEU   212      10.157  12.716 -29.083  1.00 35.67           O
ATOM   1593  N   GLU   213      11.407  14.215 -27.972  1.00 36.08           N
ATOM   1594  CA  GLU   213      10.305  15.155 -27.790  1.00 36.68           C
ATOM   1595  CB  GLU   213      10.229  15.656 -26.343  1.00 36.55           C
ATOM   1596  CG  GLU   213       9.936  14.565 -25.314  1.00 37.50           C
ATOM   1597  CD  GLU   213       9.700  15.104 -23.907  1.00 37.57           C
ATOM   1598  OE1 GLU   213      10.425  14.677 -22.986  1.00 39.99           O
ATOM   1599  OE2 GLU   213       8.797  15.946 -23.717  1.00 38.79           O
ATOM   1600  C   GLU   213      10.426  16.330 -28.750  1.00 36.71           C
ATOM   1601  O   GLU   213       9.522  17.167 -28.832  1.00 36.73           O
ATOM   1602  N   GLY   214      11.540  16.381 -29.480  1.00 36.93           N
ATOM   1603  CA  GLY   214      11.808  17.462 -30.429  1.00 37.18           C
ATOM   1604  C   GLY   214      11.854  18.814 -29.743  1.00 37.39           C
ATOM   1605  O   GLY   214      11.227  19.778 -30.191  1.00 37.28           O
ATOM   1606  N   MET   215      12.597  18.880 -28.644  1.00 37.54           N
ATOM   1607  CA  MET   215      12.656  20.089 -27.833  1.00 37.85           C
ATOM   1608  CB  MET   215      13.142  19.761 -26.426  1.00 37.87           C
ATOM   1609  CG  MET   215      12.143  19.035 -25.569  1.00 38.16           C
ATOM   1610  SD  MET   215      12.834  18.881 -23.919  1.00 38.43           S
ATOM   1611  CE  MET   215      12.183  17.296 -23.427  1.00 37.36           C
ATOM   1612  C   MET   215      13.573  21.149 -28.418  1.00 37.79           C
ATOM   1613  O   MET   215      14.454  20.852 -29.234  1.00 37.84           O
ATOM   1614  N   THR   216      13.352  22.386 -27.981  1.00 37.85           N
ATOM   1615  CA  THR   216      14.295  23.473 -28.205  1.00 38.00           C
ATOM   1616  CB  THR   216      13.615  24.865 -28.083  1.00 37.91           C
ATOM   1617  OG1 THR   216      12.971  24.991 -26.807  1.00 37.80           O
ATOM   1618  CG2 THR   216      12.589  25.070 -29.197  1.00 37.93           C
ATOM   1619  C   THR   216      15.428  23.325 -27.181  1.00 38.19           C
ATOM   1620  O   THR   216      15.238  22.678 -26.145  1.00 38.02           O
ATOM   1621  N   PRO   217      16.618  23.889 -27.475  1.00 38.55           N
ATOM   1622  CA  PRO   217      17.707  23.850 -26.495  1.00 38.91           C
ATOM   1623  CB  PRO   217      18.835  24.617 -27.195  1.00 38.98           C
ATOM   1624  CG  PRO   217      18.524  24.505 -28.643  1.00 38.86           C
ATOM   1625  CD  PRO   217      17.034  24.571 -28.716  1.00 38.62           C
ATOM   1626  C   PRO   217      17.336  24.528 -25.170  1.00 39.22           C
ATOM   1627  O   PRO   217      17.848  24.135 -24.120  1.00 39.24           O
ATOM   1628  N   GLU   218      16.447  25.522 -25.231  1.00 39.47           N
ATOM   1629  CA  GLU   218      15.910  26.196 -24.043  1.00 39.91           C
ATOM   1630  CB  GLU   218      15.145  27.462 -24.454  1.00 39.94           C
ATOM   1631  CG  GLU   218      14.841  28.435 -23.316  1.00 40.09           C
ATOM   1635  C   GLU   218      15.005  25.260 -23.224  1.00 40.20           C
ATOM   1636  O   GLU   218      15.093  25.221 -21.993  1.00 40.31           O
ATOM   1637  N   GLN   219      14.158  24.502 -23.921  1.00 40.37           N
ATOM   1638  CA  GLN   219      13.184  23.586 -23.308  1.00 40.37           C
ATOM   1639  CB  GLN   219      12.352  22.914 -24.406  1.00 40.50           C
ATOM   1640  CG  GLN   219      10.859  22.791 -24.121  1.00 41.04           C
ATOM   1641  CD  GLN   219      10.025  22.751 -25.402  1.00 41.76           C
ATOM   1642  OE1 GLN   219      10.427  22.157 -26.405  1.00 41.66           O
ATOM   1643  NE2 GLN   219       8.861  23.391 -25.369  1.00 41.86           N
ATOM   1644  C   GLN   219      13.832  22.514 -22.431  1.00 40.19           C
ATOM   1645  O   GLN   219      13.314  22.180 -21.362  1.00 40.26           O
ATOM   1646  N   ILE   220      14.962  21.981 -22.892  1.00 39.95           N
ATOM   1647  CA  ILE   220      15.647  20.882 -22.204  1.00 39.71           C
ATOM   1648  CB  ILE   220      16.434  19.965 -23.198  1.00 39.34           C
ATOM   1649  CG1 ILE   220      16.899  18.667 -22.522  1.00 39.07           C
ATOM   1650  CD1 ILE   220      15.777  17.738 -22.099  1.00 38.42           C
ATOM   1651  CG2 ILE   220      17.619  20.697 -23.808  1.00 39.27           C
ATOM   1652  C   ILE   220      16.557  21.374 -21.075  1.00 39.64           C
ATOM   1653  O   ILE   220      16.875  20.619 -20.159  1.00 39.42           O
ATOM   1654  N   LEU   221      16.963  22.642 -21.138  1.00 39.75           N
ATOM   1655  CA  LEU   221      17.784  23.218 -20.078  1.00 39.89           C
ATOM   1656  CB  LEU   221      18.406  24.556 -20.504  1.00 39.81           C
ATOM   1657  CG  LEU   221      19.518  24.534 -21.564  1.00 39.61           C
ATOM   1658  CD1 LEU   221      19.951  25.953 -21.933  1.00 40.11           C
ATOM   1659  CD2 LEU   221      20.721  23.693 -21.135  1.00 39.37           C
ATOM   1660  C   LEU   221      17.001  23.357 -18.768  1.00 40.03           C
ATOM   1661  O   LEU   221      17.599  23.372 -17.694  1.00 40.17           O
ATOM   1662  N   GLU   222      15.671  23.434 -18.871  1.00 40.06           N
ATOM   1663  CA  GLU   222      14.784  23.505 -17.704  1.00 40.13           C
ATOM   1664  CB  GLU   222      13.568  24.387 -18.009  1.00 40.29           C
ATOM   1669  C   GLU   222      14.323  22.130 -17.191  1.00 40.27           C
ATOM   1670  O   GLU   222      13.636  22.041 -16.168  1.00 40.36           O
ATOM   1671  N   VAL   223      14.711  21.067 -17.892  1.00 40.19           N
ATOM   1672  CA  VAL   223      14.278  19.706 -17.552  1.00 40.26           C
ATOM   1673  CB  VAL   223      14.089  18.823 -18.823  1.00 40.31           C
ATOM   1674  CG1 VAL   223      13.976  17.332 -18.465  1.00 40.59           C
ATOM   1675  CG2 VAL   223      12.872  19.273 -19.612  1.00 40.30           C
ATOM   1676  C   VAL   223      15.226  19.031 -16.556  1.00 40.17           C
ATOM   1677  O   VAL   223      16.440  18.957 -16.778  1.00 40.18           O
ATOM   1678  N   ASN   224      14.657  18.556 -15.452  1.00 39.91           N
ATOM   1679  CA  ASN   224      15.398  17.766 -14.477  1.00 39.70           C
ATOM   1680  CB  ASN   224      15.416  18.474 -13.118  1.00 39.65           C
ATOM   1684  C   ASN   224      14.806  16.363 -14.351  1.00 39.40           C
ATOM   1685  O   ASN   224      13.587  16.202 -14.225  1.00 39.84           O
ATOM   1686  N   ILE   225      15.671  15.355 -14.412  1.00 38.90           N
ATOM   1687  CA  ILE   225      15.270  13.959 -14.260  1.00 38.26           C
ATOM   1688  CB  ILE   225      15.937  13.048 -15.320  1.00 38.22           C
ATOM   1689  CG1 ILE   225      15.493  13.444 -16.731  1.00 38.89           C
ATOM   1691  CG2 ILE   225      15.590  11.582 -15.080  1.00 37.74           C
ATOM   1692  C   ILE   225      15.650  13.490 -12.850  1.00 37.78           C
ATOM   1693  O   ILE   225      16.824  13.560 -12.469  1.00 37.42           O
ATOM   1694  N   PRO   226      14.655  13.036 -12.063  1.00 37.33           N
ATOM   1695  CA  PRO   226      14.941  12.553 -10.714  1.00 37.14           C
ATOM   1696  CB  PRO   226      13.550  12.345 -10.110  1.00 37.20           C
ATOM   1697  CG  PRO   226      12.653  12.131 -11.285  1.00 38.16           C
ATOM   1698  CD  PRO   226      13.218  12.970 -12.385  1.00 37.54           C
ATOM   1699  C   PRO   226      15.714  11.239 -10.778  1.00 36.87           C
ATOM   1700  O   PRO   226      15.564  10.474 -11.743  1.00 36.44           O
ATOM   1701  N   THR   227      16.544  10.999  -9.768  1.00 36.22           N
ATOM   1702  CA  THR   227      17.397   9.813  -9.733  1.00 36.38           C
ATOM   1703  CB  THR   227      18.549   9.971  -8.721  1.00 35.87           C
ATOM   1704  OG1 THR   227      17.999  10.147  -7.415  1.00 36.51           O
ATOM   1705  CG2 THR   227      19.431  11.168  -9.070  1.00 35.08           C
ATOM   1706  C   THR   227      16.599   8.561  -9.380  1.00 36.37           C
ATOM   1707  O   THR   227      15.648   8.622  -8.594  1.00 36.20           O
ATOM   1708  N   ALA   228      16.994   7.439  -9.978  1.00 36.90           N
ATOM   1709  CA  ALA   228      16.431   6.108  -9.687  1.00 37.44           C
ATOM   1710  CB  ALA   228      17.027   5.531  -8.389  1.00 37.36           C
ATOM   1711  C   ALA   228      14.907   6.087  -9.668  1.00 37.69           C
ATOM   1712  O   ALA   228      14.284   5.474  -8.792  1.00 38.12           O
ATOM   1713  N   CYS   229      14.326   6.772 -10.655  1.00 37.89           N
ATOM   1714  CA  CYS   229      12.892   6.961 -10.782  1.00 38.15           C
ATOM   1715  CB  CYS   229      12.529   8.410 -10.436  1.00 37.85           C
ATOM   1716  SG  CYS   229      10.773   8.779 -10.314  1.00 38.89           S
ATOM   1717  C   CYS   229      12.551   6.650 -12.243  1.00 38.31           C
ATOM   1718  O   CYS   229      12.822   7.472 -13.130  1.00 37.99           O
ATOM   1719  N   PRO   230      11.986   5.452 -12.505  1.00 38.41           N
ATOM   1720  CA  PRO   230      11.756   5.033 -13.888  1.00 38.53           C
ATOM   1721  CB  PRO   230      11.098   3.653 -13.733  1.00 38.79           C
ATOM   1722  CG  PRO   230      11.575   3.171 -12.381  1.00 39.31           C
ATOM   1723  CD  PRO   230      11.534   4.422 -11.550  1.00 38.60           C
ATOM   1724  C   PRO   230      10.830   6.001 -14.612  1.00 38.26           C
ATOM   1725  O   PRO   230       9.785   6.373 -14.078  1.00 38.26           O
ATOM   1726  N   LEU   231      11.248   6.428 -15.800  1.00 37.91           N
ATOM   1727  CA  LEU   231      10.462   7.332 -16.634  1.00 37.81           C
ATOM   1728  CB  LEU   231      11.293   8.565 -17.020  1.00 37.83           C
ATOM   1729  CG  LEU   231      10.785   9.524 -18.111  1.00 38.49           C
ATOM   1730  CD1 LEU   231       9.460  10.185 -17.728  1.00 36.89           C
ATOM   1731  CD2 LEU   231      11.853  10.570 -18.437  1.00 37.95           C
ATOM   1732  C   LEU   231       9.996   6.574 -17.879  1.00 37.56           C
ATOM   1733  O   LEU   231      10.813   6.113 -18.672  1.00 37.12           O
ATOM   1734  N   VAL   232       8.684   6.431 -18.010  1.00 37.25           N
ATOM   1735  CA  VAL   232       8.071   5.689 -19.108  1.00 37.35           C
ATOM   1736  CB  VAL   232       6.804   4.918 -18.624  1.00 37.52           C
ATOM   1737  CG1 VAL   232       5.984   4.411 -19.804  1.00 37.34           C
ATOM   1738  CG2 VAL   232       7.190   3.756 -17.714  1.00 36.85           C
ATOM   1739  C   VAL   232       7.683   6.659 -20.223  1.00 37.24           C
ATOM   1740  O   VAL   232       6.932   7.605 -19.988  1.00 36.86           O
ATOM   1741  N   LEU   233       8.209   6.420 -21.425  1.00 37.09           N
ATOM   1742  CA  LEU   233       7.838   7.193 -22.610  1.00 37.21           C
ATOM   1743  CB  LEU   233       9.079   7.640 -23.396  1.00 37.10           C
ATOM   1744  CG  LEU   233      10.264   8.362 -22.748  1.00 36.88           C
ATOM   1745  CD1 LEU   233      11.249   8.784 -23.817  1.00 36.91           C
ATOM   1746  CD2 LEU   233       9.818   9.578 -21.946  1.00 37.21           C
ATOM   1747  C   LEU   233       6.972   6.337 -23.519  1.00 37.48           C
ATOM   1748  O   LEU   233       7.367   5.223 -23.877  1.00 37.34           O
ATOM   1749  N   GLU   234       5.793   6.846 -23.875  1.00 37.58           N
ATOM   1750  CA  GLU   234       5.007   6.270 -24.965  1.00 38.31           C
ATOM   1751  CB  GLU   234       3.503   6.387 -24.701  1.00 38.21           C
ATOM   1752  CG  GLU   234       3.043   5.616 -23.466  1.00 38.40           C
ATOM   1753  CD  GLU   234       1.556   5.730 -23.192  1.00 39.63           C
ATOM   1754  OE1 GLU   234       0.818   6.359 -23.994  1.00 41.58           O
ATOM   1755  OE2 GLU   234       1.117   5.176 -22.163  1.00 41.95           O
ATOM   1756  C   GLU   234       5.398   6.991 -26.249  1.00 38.33           C
ATOM   1757  O   GLU   234       5.527   8.222 -26.258  1.00 38.48           O
ATOM   1758  N   LEU   235       5.595   6.219 -27.320  1.00 38.37           N
ATOM   1759  CA  LEU   235       6.156   6.732 -28.576  1.00 37.97           C
ATOM   1760  CB  LEU   235       7.532   6.102 -28.840  1.00 38.06           C
ATOM   1761  CG  LEU   235       8.657   6.284 -27.815  1.00 36.61           C
ATOM   1762  CD1 LEU   235       9.852   5.459 -28.231  1.00 38.53           C
ATOM   1763  CD2 LEU   235       9.058   7.742 -27.634  1.00 34.94           C
ATOM   1764  C   LEU   235       5.254   6.526 -29.798  1.00 37.93           C
ATOM   1765  O   LEU   235       4.474   5.576 -29.847  1.00 38.17           O
ATOM   1766  N   ASP   236       5.384   7.436 -30.768  1.00 37.62           N
ATOM   1767  CA  ASP   236       4.714   7.384 -32.082  1.00 37.34           C
ATOM   1768  CB  ASP   236       5.094   8.635 -32.880  1.00 37.26           C
ATOM   1769  CG  ASP   236       4.154   9.763 -32.680  1.00 38.10           C
ATOM   1770  OD1 ASP   236       2.933   9.519 -32.563  0.80 40.45           O
ATOM   1771  OD2 ASP   236       4.637  10.912 -32.670  0.80 40.05           O
ATOM   1772  C   ASP   236       5.154   6.217 -32.952  1.00 36.78           C
ATOM   1773  O   ASP   236       6.056   5.461 -32.587  1.00 36.49           O
ATOM   1774  N   ASP   237       4.534   6.116 -34.131  1.00 36.47           N
ATOM   1775  CA  ASP   237       5.097   5.370 -35.262  1.00 36.09           C
ATOM   1776  CB  ASP   237       4.137   5.407 -36.461  1.00 36.50           C
ATOM   1777  CG  ASP   237       3.116   4.276 -36.441  1.00 36.50           C
ATOM   1778  OD1 ASP   237       3.119   3.467 -35.491  1.00 37.20           O
ATOM   1779  OD2 ASP   237       2.307   4.193 -37.391  1.00 38.35           O
ATOM   1780  C   ASP   237       6.449   5.975 -35.665  1.00 35.98           C
ATOM   1781  O   ASP   237       7.322   5.277 -36.183  1.00 35.74           O
ATOM   1782  N   TYR   238       6.611   7.272 -35.393  1.00 35.77           N
ATOM   1783  CA  TYR   238       7.812   8.037 -35.730  1.00 35.74           C
ATOM   1784  CB  TYR   238       7.429   9.479 -36.092  1.00 35.93           C
ATOM   1785  CG  TYR   238       6.504   9.589 -37.291  1.00 36.26           C
ATOM   1786  CD1 TYR   238       6.998   9.473 -38.592  1.00 36.17           C
ATOM   1787  CE1 TYR   238       6.153   9.576 -39.698  1.00 36.04           C
ATOM   1788  CZ  TYR   238       4.798   9.797 -39.506  1.00 36.19           C
ATOM   1789  OH  TYR   238       3.964   9.899 -40.598  1.00 36.05           O
ATOM   1790  CE2 TYR   238       4.280   9.916 -38.225  1.00 36.73           C
ATOM   1791  CD2 TYR   238       5.133   9.811 -37.124  1.00 36.65           C
ATOM   1792  C   TYR   238       8.845   8.043 -34.607  1.00 35.94           C
ATOM   1793  O   TYR   238       9.923   8.642 -34.739  1.00 35.76           O
ATOM   1794  N   LEU   239       8.518   7.363 -33.508  1.00 36.13           N
ATOM   1795  CA  LEU   239       9.385   7.294 -32.322  1.00 36.25           C
ATOM   1796  CB  LEU   239      10.736   6.636 -32.649  1.00 36.22           C
ATOM   1797  CG  LEU   239      10.724   5.275 -33.354  1.00 37.06           C
ATOM   1798  CD1 LEU   239      12.127   4.737 -33.470  1.00 35.41           C
ATOM   1799  CD2 LEU   239       9.823   4.269 -32.647  1.00 37.47           C
ATOM   1800  C   LEU   239       9.567   8.674 -31.687  1.00 36.39           C
ATOM   1801  O   LEU   239      10.628   9.008 -31.154  1.00 36.36           O
ATOM   1802  N   LYS   240       8.514   9.482 -31.777  1.00 36.53           N
ATOM   1803  CA  LYS   240       8.437  10.731 -31.049  1.00 36.79           C
ATOM   1804  CB  LYS   240       7.976  11.882 -31.957  1.00 36.81           C
ATOM   1805  CG  LYS   240       8.999  12.306 -33.024  1.00 37.00           C
ATOM   1806  CD  LYS   240      10.264  12.934 -32.427  1.00 36.35           C
ATOM   1809  C   LYS   240       7.475  10.536 -29.884  1.00 36.95           C
ATOM   1810  O   LYS   240       6.507   9.774 -29.984  1.00 37.11           O
ATOM   1811  N   VAL   241       7.755  11.221 -28.782  1.00 36.90           N
ATOM   1812  CA  VAL   241       6.945  11.110 -27.569  1.00 37.00           C
ATOM   1813  CB  VAL   241       7.653  11.790 -26.355  1.00 36.99           C
ATOM   1814  CG1 VAL   241       6.725  11.904 -25.149  1.00 37.19           C
ATOM   1815  CG2 VAL   241       8.918  11.019 -25.979  1.00 37.46           C
ATOM   1816  C   VAL   241       5.520  11.644 -27.753  1.00 36.71           C
ATOM   1817  O   VAL   241       5.311  12.791 -28.162  1.00 36.46           O
ATOM   1818  N   THR   242       4.550  10.783 -27.459  1.00 36.79           N
ATOM   1819  CA  THR   242       3.146  11.177 -27.355  1.00 36.61           C
ATOM   1820  CB  THR   242       2.198  10.034 -27.759  1.00 36.86           C
ATOM   1821  OG1 THR   242       2.585   8.834 -27.081  1.00 37.06           O
ATOM   1822  CG2 THR   242       2.230   9.803 -29.275  1.00 37.02           C
ATOM   1823  C   THR   242       2.822  11.600 -25.919  1.00 36.49           C
ATOM   1824  O   THR   242       2.202  12.644 -25.699  1.00 36.21           O
ATOM   1825  N   LYS   243       3.244  10.775 -24.955  1.00 36.57           N
ATOM   1826  CA  LYS   243       3.116  11.087 -23.530  1.00 36.30           C
ATOM   1827  CB  LYS   243       1.703  10.763 -23.009  1.00 36.57           C
ATOM   1828  CG  LYS   243       1.465   9.328 -22.540  1.00 36.76           C
ATOM   1829  CD  LYS   243       0.063   9.206 -21.951  1.00 36.66           C
ATOM   1830  CE  LYS   243      -0.051   8.072 -20.944  1.00 37.10           C
ATOM   1831  NZ  LYS   243      -1.390   8.056 -20.269  1.00 37.92           N
ATOM   1832  C   LYS   243       4.201  10.425 -22.666  1.00 36.09           C
ATOM   1833  O   LYS   243       4.835   9.432 -23.069  1.00 35.98           O
ATOM   1834  N   LYS   244       4.417  10.987 -21.479  1.00 35.59           N
ATOM   1835  CA  LYS   244       5.427  10.472 -20.557  1.00 35.25           C
ATOM   1836  CB  LYS   244       6.769  11.191 -20.753  1.00 35.20           C
ATOM   1837  CG  LYS   244       6.743  12.701 -20.485  1.00 35.70           C
ATOM   1838  CD  LYS   244       8.152  13.269 -20.374  1.00 35.47           C
ATOM   1839  CE  LYS   244       8.137  14.789 -20.479  1.00 36.35           C
ATOM   1840  NZ  LYS   244       9.516  15.363 -20.502  1.00 36.26           N
ATOM   1841  C   LYS   244       4.965  10.576 -19.106  1.00 34.96           C
ATOM   1842  O   LYS   244       4.259  11.510 -18.737  1.00 34.71           O
ATOM   1843  N   TYR   245       5.375   9.604 -18.294  1.00 34.62           N
ATOM   1844  CA  TYR   245       5.046   9.571 -16.870  1.00 34.14           C
ATOM   1845  CB  TYR   245       3.636   9.014 -16.644  1.00 34.39           C
ATOM   1846  CG  TYR   245       3.377   7.690 -17.326  1.00 34.96           C
ATOM   1847  CD1 TYR   245       3.734   6.484 -16.721  1.00 34.54           C
ATOM   1848  CE1 TYR   245       3.487   5.268 -17.346  1.00 34.91           C
ATOM   1849  CZ  TYR   245       2.882   5.253 -18.592  1.00 35.45           C
ATOM   1850  OH  TYR   245       2.629   4.059 -19.237  1.00 35.72           O
ATOM   1851  CE2 TYR   245       2.519   6.437 -19.208  1.00 36.02           C
ATOM   1852  CD2 TYR   245       2.766   7.644 -18.577  1.00 35.26           C
ATOM   1853  C   TYR   245       6.064   8.769 -16.061  1.00 33.73           C
ATOM   1854  O   TYR   245       6.639   7.785 -16.542  1.00 33.52           O
ATOM   1855  N   TYR   246       6.278   9.207 -14.827  1.00 33.40           N
ATOM   1856  CA  TYR   246       7.112   8.488 -13.872  1.00 33.08           C
ATOM   1857  CB  TYR   246       7.745   9.466 -12.886  1.00 32.65           C
ATOM   1858  CG  TYR   246       8.773  10.364 -13.520  1.00 32.33           C
ATOM   1859  CD1 TYR   246       8.432  11.637 -13.971  1.00 31.67           C
ATOM   1860  CE1 TYR   246       9.383  12.468 -14.562  1.00 32.40           C
ATOM   1861  CZ  TYR   246      10.689  12.016 -14.708  1.00 32.33           C
ATOM   1862  OH  TYR   246      11.639  12.826 -15.283  1.00 32.39           O
ATOM   1863  CE2 TYR   246      11.046  10.754 -14.268  1.00 32.24           C
ATOM   1864  CD2 TYR   246      10.091   9.935 -13.684  1.00 31.98           C
ATOM   1865  C   TYR   246       6.271   7.458 -13.135  1.00 33.16           C
ATOM   1866  O   TYR   246       5.048   7.574 -13.081  1.00 33.21           O
ATOM   1867  N   LEU   247       6.920   6.445 -12.571  1.00 33.32           N
ATOM   1868  CA  LEU   247       6.180   5.409 -11.854  1.00 33.55           C
ATOM   1869  CB  LEU   247       6.930   4.070 -11.890  1.00 33.57           C
ATOM   1870  CG  LEU   247       6.971   3.308 -13.224  1.00 33.46           C
ATOM   1871  CD1 LEU   247       7.616   1.955 -13.007  1.00 34.13           C
ATOM   1872  CD2 LEU   247       5.576   3.127 -13.829  1.00 33.14           C
ATOM   1873  C   LEU   247       5.796   5.816 -10.427  1.00 33.71           C
ATOM   1874  O   LEU   247       4.761   5.377  -9.910  1.00 33.80           O
ATOM   1875  N   ILE   248       6.621   6.672  -9.818  1.00 33.76           N
ATOM   1876  CA  ILE   248       6.392   7.216  -8.471  1.00 33.59           C
ATOM   1877  CB  ILE   248       7.173   8.525  -8.253  1.00 33.55           C
ATOM   1881  C   ILE   248       4.924   7.476  -8.159  1.00 33.59           C
ATOM   1882  O   ILE   248       4.312   6.744  -7.382  1.00 33.57           O
ATOM   1883  N   GLU   249       2.822  10.069  -7.131  1.00 50.51           N
ATOM   1884  CA  GLU   249       3.133  11.486  -6.973  1.00 50.59           C
ATOM   1885  CB  GLU   249       1.843  12.307  -6.882  1.00 50.59           C
ATOM   1886  CG  GLU   249       2.031  13.804  -7.102  1.00 50.57           C
ATOM   1887  CD  GLU   249       0.738  14.592  -6.957  1.00 50.57           C
ATOM   1888  OE1 GLU   249      -0.168  14.145  -6.219  1.00 50.29           O
ATOM   1889  OE2 GLU   249       0.630  15.669  -7.582  1.00 50.58           O
ATOM   1890  C   GLU   249       4.020  11.711  -5.745  1.00 50.65           C
ATOM   1891  O   GLU   249       3.538  12.063  -4.662  1.00 50.61           O
ATOM   1892  N   GLU   250       5.322  11.494  -5.930  1.00 50.71           N
ATOM   1893  CA  GLU   250       6.305  11.607  -4.854  1.00 50.71           C
ATOM   1894  CB  GLU   250       6.648  10.221  -4.296  1.00 50.73           C
ATOM   1895  CG  GLU   250       5.547   9.589  -3.442  1.00 50.79           C
ATOM   1896  CD  GLU   250       5.644   8.072  -3.364  1.00 50.85           C
ATOM   1897  OE1 GLU   250       4.731   7.451  -2.779  1.00 50.86           O
ATOM   1898  OE2 GLU   250       6.625   7.496  -3.886  1.00 51.03           O
ATOM   1899  C   GLU   250       7.572  12.304  -5.348  1.00 50.68           C
ATOM   1900  O   GLU   250       8.396  12.760  -4.554  1.00 50.62           O
END
