
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   98 (  781),  selected   98 , name 2fnj_B
# Molecule2: number of CA atoms   84 (  623),  selected   84 , name T0424_94_177.pdb
# PARAMETERS: 2fnj_B.T0424_94_177.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_B      L      94           -
LGA    D     2_B      -       -           -
LGA    V     3_B      -       -           -
LGA    F     4_B      -       -           -
LGA    L     5_B      -       -           -
LGA    M     6_B      -       -           -
LGA    I     7_B      -       -           -
LGA    R     8_B      A      95           #
LGA    R     9_B      G      96          5.287
LGA    H    10_B      F      97           #
LGA    -       -      L      98           -
LGA    K    11_B      V      99          3.388
LGA    T    12_B      D     100          2.135
LGA    T    13_B      C     101          3.298
LGA    I    14_B      S     102          3.003
LGA    F    15_B      A     103          1.875
LGA    T    16_B      P     104          1.813
LGA    -       -      Q     105           -
LGA    D    17_B      L     106          0.929
LGA    A    18_B      N     107          2.325
LGA    K    19_B      V     108          3.326
LGA    E    20_B      K     109          1.352
LGA    S    21_B      G     110          1.100
LGA    S    22_B      M     111          0.870
LGA    T    23_B      T     112          1.282
LGA    V    24_B      V     113          0.839
LGA    F    25_B      L     114          0.605
LGA    E    26_B      D     115          0.489
LGA    L    27_B      A     116          1.443
LGA    K    28_B      A     117          2.112
LGA    R    29_B      K     118          1.681
LGA    I    30_B      K     119          1.009
LGA    V    31_B      L     120          2.917
LGA    E    32_B      A     121          3.664
LGA    G    33_B      A     122          1.881
LGA    I    34_B      P     123          1.074
LGA    L    35_B      W     124          1.392
LGA    K    36_B      P     125          1.687
LGA    -       -      Q     126           -
LGA    R    37_B      I     127          1.490
LGA    -       -      K     128           -
LGA    P    38_B      A     129          1.011
LGA    P    39_B      V     130          0.543
LGA    E    40_B      V     131          2.501
LGA    E    41_B      -       -           -
LGA    Q    42_B      L     132           #
LGA    R    43_B      -       -           -
LGA    L    44_B      -       -           -
LGA    Y    45_B      -       -           -
LGA    K    46_B      -       -           -
LGA    D    47_B      -       -           -
LGA    D    48_B      -       -           -
LGA    Q    49_B      -       -           -
LGA    L    50_B      -       -           -
LGA    L    51_B      -       -           -
LGA    D    52_B      K     133           #
LGA    D    53_B      A     134           #
LGA    -       -      E     135           -
LGA    -       -      N     136           -
LGA    G    54_B      N     137          0.922
LGA    K    55_B      P     138          0.998
LGA    T    56_B      A     139          1.914
LGA    L    57_B      L     140          2.123
LGA    G    58_B      G     141          0.621
LGA    E    59_B      -       -           -
LGA    C    60_B      -       -           -
LGA    G    61_B      -       -           -
LGA    F    62_B      -       -           -
LGA    T    63_B      K     142          2.002
LGA    S    64_B      -       -           -
LGA    Q    65_B      -       -           -
LGA    T    66_B      I     143           #
LGA    A    67_B      D     144          0.846
LGA    R    68_B      -       -           -
LGA    P    69_B      -       -           -
LGA    Q    70_B      -       -           -
LGA    A    71_B      -       -           -
LGA    P    72_B      I     145          1.952
LGA    A    73_B      E     146          5.236
LGA    -       -      P     147           -
LGA    -       -      G     148           -
LGA    -       -      E     149           -
LGA    -       -      T     150           -
LGA    -       -      V     151           -
LGA    -       -      W     152           -
LGA    T    74_B      Q     153          3.557
LGA    V    75_B      A     154          2.645
LGA    G    76_B      L     155          3.963
LGA    -       -      T     156           -
LGA    -       -      X     157           -
LGA    -       -      I     158           -
LGA    -       -      A     159           -
LGA    -       -      N     160           -
LGA    -       -      S     161           -
LGA    -       -      V     162           -
LGA    -       -      G     163           -
LGA    -       -      L     164           -
LGA    -       -      X     165           -
LGA    L    77_B      P     166          4.036
LGA    A    78_B      W     167          2.262
LGA    F    79_B      L     168          1.407
LGA    R    80_B      E     169          1.251
LGA    A    81_B      P     170          1.694
LGA    D    82_B      D     171          3.169
LGA    D    83_B      G     172           -
LGA    T    84_B      -       -           -
LGA    F    85_B      T     173           #
LGA    E    86_B      L     174           -
LGA    A    87_B      V     175           -
LGA    L    88_B      V     176           -
LGA    R    89_B      G     177           -
LGA    I    90_B      -       -           -
LGA    E    91_B      -       -           -
LGA    P    92_B      -       -           -
LGA    F    93_B      -       -           -
LGA    S    94_B      -       -           -
LGA    S    95_B      -       -           -
LGA    P    96_B      -       -           -
LGA    P    97_B      -       -           -
LGA    E    98_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   98   84    5.0     49    2.33    10.20     42.243     2.017

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.117048 * X  +  -0.101064 * Y  +  -0.987971 * Z  + -40.458984
  Y_new =  -0.209335 * X  +   0.974969 * Y  +  -0.074934 * Z  +  63.230782
  Z_new =   0.970813 * X  +   0.198046 * Y  +  -0.135275 * Z  + 135.296387 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.170053   -0.971539  [ DEG:   124.3349    -55.6651 ]
  Theta =  -1.328599   -1.812993  [ DEG:   -76.1231   -103.8769 ]
  Phi   =  -2.080632    1.060961  [ DEG:  -119.2114     60.7886 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fnj_B                                        
REMARK     2: T0424_94_177.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fnj_B.T0424_94_177.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   98   84   5.0   49   2.33   10.20  42.243
REMARK  ---------------------------------------------------------- 
MOLECULE 2fnj_B
HEADER    PROTEIN TRANSPORT/SIGNALING PROTEIN     11-JAN-06   2FNJ              
TITLE     CRYSTAL STRUCTURE OF A B30.2/SPRY DOMAIN-CONTAINING PROTEIN           
TITLE    2 GUSTAVUS IN COMPLEX WITH ELONGIN B AND ELONGIN C                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CG2944-PF, ISOFORM F;                                      
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 28-253;                                           
COMPND   5 SYNONYM: GUSTAVUS;                                                   
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MOL_ID: 2;                                                           
COMPND   8 MOLECULE: TRANSCRIPTION ELONGATION FACTOR B POLYPEPTIDE 2;           
COMPND   9 CHAIN: B;                                                            
COMPND  10 SYNONYM: RNA POLYMERASE II TRANSCRIPTION FACTOR SIII                 
COMPND  11 SUBUNIT B, SIII P18, ELONGIN B, ELOB, ELONGIN 18 KDA                 
COMPND  12 SUBUNIT;                                                             
COMPND  13 ENGINEERED: YES;                                                     
COMPND  14 MOL_ID: 3;                                                           
COMPND  15 MOLECULE: TRANSCRIPTION ELONGATION FACTOR B POLYPEPTIDE 1;           
COMPND  16 CHAIN: C;                                                            
COMPND  17 FRAGMENT: RESIDUES 17-112;                                           
COMPND  18 SYNONYM: RNA POLYMERASE II TRANSCRIPTION FACTOR SIII                 
COMPND  19 SUBUNIT C, SIII P15, ELONGIN C, ELOC, ELONGIN 15 KDA                 
COMPND  20 SUBUNIT, STROMAL MEMBRANE-ASSOCIATED PROTEIN SMAP1B                  
COMPND  21 HOMOLOG;                                                             
COMPND  22 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: DROSOPHILA MELANOGASTER;                        
SOURCE   3 ORGANISM_COMMON: FRUIT FLY;                                          
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 MOL_ID: 2;                                                           
SOURCE   7 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   8 ORGANISM_COMMON: MOUSE;                                              
SOURCE   9 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  10 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE  11 MOL_ID: 3;                                                           
SOURCE  12 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE  13 ORGANISM_COMMON: MOUSE;                                              
SOURCE  14 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  15 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    BETA-SANDWICH, LECTIN-LIKE, B30.2, SPRY                               
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.S.WOO,B.H.OH                                                        
REVDAT   2   04-APR-06 2FNJ    1       JRNL                                     
REVDAT   1   21-MAR-06 2FNJ    0                                                
JRNL        AUTH   J.S.WOO,J.H.IMM,C.K.MIN,K.J.KIM,S.S.CHA,B.H.OH               
JRNL        TITL   STRUCTURAL AND FUNCTIONAL INSIGHTS INTO THE                  
JRNL        TITL 2 B30.2/SPRY DOMAIN                                            
JRNL        REF    EMBO J.                       V.  25  1353 2006              
JRNL        REFN   ASTM EMJODG  UK ISSN 0261-4189                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2FNJ A   29   253  UNP    Q7KRQ1   Q7KRQ1_DROME    29    253             
DBREF  2FNJ B    1   118  UNP    P62869   ELOB_MOUSE       1    118             
DBREF  2FNJ C   17   112  UNP    P83940   ELOC_MOUSE      17    112             
SEQRES   1 A  226  MET ARG GLU LEU GLN ALA ASP PHE VAL LYS PRO ALA ARG          
SEQRES   2 A  226  ILE ASP ILE LEU LEU ASP MET PRO PRO ALA SER ARG ASP          
SEQRES   3 A  226  LEU GLN LEU LYS HIS SER TRP ASN SER GLU ASP ARG SER          
SEQRES   4 A  226  LEU ASN ILE PHE VAL LYS GLU ASP ASP LYS LEU THR PHE          
SEQRES   5 A  226  HIS ARG HIS PRO VAL ALA GLN SER THR ASP CYS ILE ARG          
SEQRES   6 A  226  GLY LYS VAL GLY LEU THR LYS GLY LEU HIS ILE TRP GLU          
SEQRES   7 A  226  ILE TYR TRP PRO THR ARG GLN ARG GLY THR HIS ALA VAL          
SEQRES   8 A  226  VAL GLY VAL CYS THR ALA ASP ALA PRO LEU HIS SER VAL          
SEQRES   9 A  226  GLY TYR GLN SER LEU VAL GLY SER THR GLU GLN SER TRP          
SEQRES  10 A  226  GLY TRP ASP LEU GLY ARG ASN LYS LEU TYR HIS ASP SER          
SEQRES  11 A  226  LYS ASN CYS ALA GLY VAL THR TYR PRO ALA ILE LEU LYS          
SEQRES  12 A  226  ASN ASP GLU ALA PHE LEU VAL PRO ASP LYS PHE LEU VAL          
SEQRES  13 A  226  ALA LEU ASP MET ASP GLU GLY THR LEU SER PHE ILE VAL          
SEQRES  14 A  226  ASP GLN GLN TYR LEU GLY ILE ALA PHE ARG GLY LEU ARG          
SEQRES  15 A  226  GLY LYS LYS LEU TYR PRO ILE VAL SER ALA VAL TRP GLY          
SEQRES  16 A  226  HIS CYS GLU ILE THR MET ARG TYR ILE GLY GLY LEU ASP          
SEQRES  17 A  226  PRO GLU PRO LEU PRO LEU MET ASP LEU CYS ARG ARG THR          
SEQRES  18 A  226  ILE ARG GLN LYS ILE                                          
SEQRES   1 B  118  MET ASP VAL PHE LEU MET ILE ARG ARG HIS LYS THR THR          
SEQRES   2 B  118  ILE PHE THR ASP ALA LYS GLU SER SER THR VAL PHE GLU          
SEQRES   3 B  118  LEU LYS ARG ILE VAL GLU GLY ILE LEU LYS ARG PRO PRO          
SEQRES   4 B  118  GLU GLU GLN ARG LEU TYR LYS ASP ASP GLN LEU LEU ASP          
SEQRES   5 B  118  ASP GLY LYS THR LEU GLY GLU CYS GLY PHE THR SER GLN          
SEQRES   6 B  118  THR ALA ARG PRO GLN ALA PRO ALA THR VAL GLY LEU ALA          
SEQRES   7 B  118  PHE ARG ALA ASP ASP THR PHE GLU ALA LEU ARG ILE GLU          
SEQRES   8 B  118  PRO PHE SER SER PRO PRO GLU LEU PRO ASP VAL MET LYS          
SEQRES   9 B  118  PRO GLN ASP SER GLY GLY SER ALA ASN GLU GLN ALA VAL          
SEQRES  10 B  118  GLN                                                          
SEQRES   1 C   96  MET TYR VAL LYS LEU ILE SER SER ASP GLY HIS GLU PHE          
SEQRES   2 C   96  ILE VAL LYS ARG GLU HIS ALA LEU THR SER GLY THR ILE          
SEQRES   3 C   96  LYS ALA MET LEU SER GLY PRO GLY GLN PHE ALA GLU ASN          
SEQRES   4 C   96  GLU THR ASN GLU VAL ASN PHE ARG GLU ILE PRO SER HIS          
SEQRES   5 C   96  VAL LEU SER LYS VAL CYS MET TYR PHE THR TYR LYS VAL          
SEQRES   6 C   96  ARG TYR THR ASN SER SER THR GLU ILE PRO GLU PHE PRO          
SEQRES   7 C   96  ILE ALA PRO GLU ILE ALA LEU GLU LEU LEU MET ALA ALA          
SEQRES   8 C   96  ASN PHE LEU ASP CYS                                          
FORMUL   4  HOH   *298(H2 O)                                                    
CRYST1   50.308   82.489  118.966  90.00  90.00  90.00 P 21 21 21    4          
ATOM   1733  N   MET B   1     -51.062  87.053 136.860  1.00 46.21           N  
ATOM   1734  CA  MET B   1     -49.595  87.273 136.715  1.00 44.70           C  
ATOM   1735  C   MET B   1     -48.823  85.955 136.632  1.00 41.56           C  
ATOM   1736  O   MET B   1     -47.777  85.893 135.994  1.00 40.96           O  
ATOM   1737  CB  MET B   1     -49.071  88.116 137.885  1.00 48.19           C  
ATOM   1738  CG  MET B   1     -47.575  88.401 137.817  1.00 53.17           C  
ATOM   1739  SD  MET B   1     -46.954  89.496 139.129  1.00 58.30           S  
ATOM   1740  CE  MET B   1     -45.558  90.302 138.276  1.00 53.96           C  
ATOM   1741  N   ASP B   2     -49.335  84.904 137.270  1.00 39.63           N  
ATOM   1742  CA  ASP B   2     -48.667  83.599 137.242  1.00 36.28           C  
ATOM   1743  C   ASP B   2     -49.192  82.686 136.144  1.00 32.80           C  
ATOM   1744  O   ASP B   2     -50.378  82.693 135.830  1.00 32.24           O  
ATOM   1745  CB  ASP B   2     -48.846  82.843 138.565  1.00 37.84           C  
ATOM   1746  CG  ASP B   2     -48.142  83.503 139.729  1.00 38.37           C  
ATOM   1747  OD1 ASP B   2     -46.940  83.822 139.610  1.00 36.78           O  
ATOM   1748  OD2 ASP B   2     -48.797  83.682 140.775  1.00 40.13           O  
ATOM   1749  N   VAL B   3     -48.292  81.903 135.560  1.00 29.64           N  
ATOM   1750  CA  VAL B   3     -48.677  80.927 134.552  1.00 26.50           C  
ATOM   1751  C   VAL B   3     -48.183  79.601 135.115  1.00 25.70           C  
ATOM   1752  O   VAL B   3     -47.123  79.540 135.736  1.00 24.90           O  
ATOM   1753  CB  VAL B   3     -48.024  81.195 133.168  1.00 26.88           C  
ATOM   1754  CG1 VAL B   3     -48.554  82.500 132.601  1.00 29.32           C  
ATOM   1755  CG2 VAL B   3     -46.497  81.236 133.285  1.00 24.06           C  
ATOM   1756  N   PHE B   4     -48.966  78.546 134.935  1.00 26.18           N  
ATOM   1757  CA  PHE B   4     -48.585  77.240 135.448  1.00 23.82           C  
ATOM   1758  C   PHE B   4     -48.230  76.348 134.277  1.00 23.16           C  
ATOM   1759  O   PHE B   4     -48.975  76.243 133.304  1.00 24.28           O  
ATOM   1760  CB  PHE B   4     -49.716  76.688 136.314  1.00 23.66           C  
ATOM   1761  CG  PHE B   4     -49.985  77.531 137.533  1.00 25.59           C  
ATOM   1762  CD1 PHE B   4     -50.717  78.713 137.431  1.00 27.87           C  
ATOM   1763  CD2 PHE B   4     -49.449  77.181 138.773  1.00 24.19           C  
ATOM   1764  CE1 PHE B   4     -50.911  79.535 138.544  1.00 27.67           C  
ATOM   1765  CE2 PHE B   4     -49.635  77.994 139.889  1.00 25.41           C  
ATOM   1766  CZ  PHE B   4     -50.367  79.174 139.777  1.00 25.74           C  
ATOM   1767  N   LEU B   5     -47.073  75.709 134.372  1.00 21.20           N  
ATOM   1768  CA  LEU B   5     -46.582  74.913 133.270  1.00 22.15           C  
ATOM   1769  C   LEU B   5     -46.085  73.520 133.607  1.00 22.12           C  
ATOM   1770  O   LEU B   5     -45.963  73.130 134.767  1.00 22.49           O  
ATOM   1771  CB  LEU B   5     -45.421  75.665 132.604  1.00 22.24           C  
ATOM   1772  CG  LEU B   5     -45.463  77.203 132.531  1.00 24.12           C  
ATOM   1773  CD1 LEU B   5     -44.044  77.745 132.503  1.00 22.77           C  
ATOM   1774  CD2 LEU B   5     -46.239  77.660 131.315  1.00 22.76           C  
ATOM   1775  N   MET B   6     -45.809  72.788 132.538  1.00 21.52           N  
ATOM   1776  CA  MET B   6     -45.230  71.461 132.589  1.00 21.81           C  
ATOM   1777  C   MET B   6     -44.109  71.620 131.569  1.00 20.06           C  
ATOM   1778  O   MET B   6     -44.374  71.894 130.403  1.00 21.19           O  
ATOM   1779  CB  MET B   6     -46.205  70.386 132.096  1.00 20.76           C  
ATOM   1780  CG  MET B   6     -47.330  70.040 133.060  1.00 21.56           C  
ATOM   1781  SD  MET B   6     -48.195  68.551 132.509  1.00 24.45           S  
ATOM   1782  CE  MET B   6     -48.970  69.118 131.006  1.00 22.87           C  
ATOM   1783  N   ILE B   7     -42.866  71.501 132.007  1.00 20.71           N  
ATOM   1784  CA  ILE B   7     -41.742  71.619 131.087  1.00 20.21           C  
ATOM   1785  C   ILE B   7     -41.392  70.184 130.760  1.00 20.40           C  
ATOM   1786  O   ILE B   7     -40.978  69.428 131.634  1.00 20.92           O  
ATOM   1787  CB  ILE B   7     -40.568  72.332 131.752  1.00 20.83           C  
ATOM   1788  CG1 ILE B   7     -41.019  73.737 132.171  1.00 21.03           C  
ATOM   1789  CG2 ILE B   7     -39.372  72.383 130.796  1.00 21.55           C  
ATOM   1790  CD1 ILE B   7     -40.011  74.508 132.983  1.00 19.72           C  
ATOM   1791  N   ARG B   8     -41.544  69.805 129.499  1.00 20.95           N  
ATOM   1792  CA  ARG B   8     -41.321  68.416 129.134  1.00 22.48           C  
ATOM   1793  C   ARG B   8     -40.270  68.058 128.084  1.00 21.98           C  
ATOM   1794  O   ARG B   8     -40.120  68.735 127.066  1.00 22.74           O  
ATOM   1795  CB  ARG B   8     -42.671  67.825 128.730  1.00 21.36           C  
ATOM   1796  CG  ARG B   8     -43.815  68.211 129.672  1.00 22.31           C  
ATOM   1797  CD  ARG B   8     -45.064  67.444 129.309  1.00 22.17           C  
ATOM   1798  NE  ARG B   8     -44.750  66.026 129.250  1.00 21.32           N  
ATOM   1799  CZ  ARG B   8     -45.422  65.122 128.548  1.00 20.86           C  
ATOM   1800  NH1 ARG B   8     -46.478  65.472 127.826  1.00 18.94           N  
ATOM   1801  NH2 ARG B   8     -45.008  63.865 128.552  1.00 21.45           N  
ATOM   1802  N   ARG B   9     -39.552  66.971 128.359  1.00 23.89           N  
ATOM   1803  CA  ARG B   9     -38.522  66.421 127.473  1.00 24.50           C  
ATOM   1804  C   ARG B   9     -38.499  64.907 127.668  1.00 23.27           C  
ATOM   1805  O   ARG B   9     -38.386  64.432 128.799  1.00 22.94           O  
ATOM   1806  CB  ARG B   9     -37.135  66.975 127.805  1.00 24.67           C  
ATOM   1807  CG  ARG B   9     -36.011  66.135 127.208  1.00 25.68           C  
ATOM   1808  CD  ARG B   9     -34.654  66.791 127.358  1.00 28.75           C  
ATOM   1809  NE  ARG B   9     -33.602  66.025 126.692  1.00 31.04           N  
ATOM   1810  CZ  ARG B   9     -32.909  65.037 127.253  1.00 32.06           C  
ATOM   1811  NH1 ARG B   9     -33.145  64.678 128.510  1.00 27.50           N  
ATOM   1812  NH2 ARG B   9     -31.969  64.411 126.554  1.00 33.45           N  
ATOM   1813  N   HIS B  10     -38.599  64.155 126.574  1.00 22.79           N  
ATOM   1814  CA  HIS B  10     -38.591  62.694 126.640  1.00 22.98           C  
ATOM   1815  C   HIS B  10     -39.657  62.209 127.636  1.00 22.31           C  
ATOM   1816  O   HIS B  10     -40.848  62.386 127.395  1.00 24.33           O  
ATOM   1817  CB  HIS B  10     -37.196  62.198 127.045  1.00 25.34           C  
ATOM   1818  CG  HIS B  10     -36.129  62.496 126.033  1.00 28.44           C  
ATOM   1819  ND1 HIS B  10     -34.817  62.103 126.196  1.00 30.69           N  
ATOM   1820  CD2 HIS B  10     -36.186  63.118 124.831  1.00 29.54           C  
ATOM   1821  CE1 HIS B  10     -34.114  62.466 125.137  1.00 29.96           C  
ATOM   1822  NE2 HIS B  10     -34.922  63.083 124.292  1.00 32.03           N  
ATOM   1823  N   LYS B  11     -39.235  61.594 128.739  1.00 22.35           N  
ATOM   1824  CA  LYS B  11     -40.182  61.123 129.754  1.00 23.42           C  
ATOM   1825  C   LYS B  11     -40.044  61.896 131.060  1.00 24.29           C  
ATOM   1826  O   LYS B  11     -40.358  61.386 132.139  1.00 26.50           O  
ATOM   1827  CB  LYS B  11     -40.006  59.622 130.019  1.00 25.66           C  
ATOM   1828  CG  LYS B  11     -40.703  58.743 128.976  1.00 27.37           C  
ATOM   1829  CD  LYS B  11     -40.748  57.285 129.405  1.00 28.01           C  
ATOM   1830  CE  LYS B  11     -41.737  56.500 128.560  1.00 28.64           C  
ATOM   1831  NZ  LYS B  11     -41.800  55.060 128.971  1.00 29.82           N  
ATOM   1832  N   THR B  12     -39.572  63.131 130.947  1.00 22.62           N  
ATOM   1833  CA  THR B  12     -39.399  64.009 132.092  1.00 23.17           C  
ATOM   1834  C   THR B  12     -40.430  65.132 131.999  1.00 23.43           C  
ATOM   1835  O   THR B  12     -40.623  65.728 130.935  1.00 22.72           O  
ATOM   1836  CB  THR B  12     -37.990  64.640 132.104  1.00 25.24           C  
ATOM   1837  OG1 THR B  12     -37.004  63.608 132.229  1.00 26.54           O  
ATOM   1838  CG2 THR B  12     -37.854  65.622 133.265  1.00 25.52           C  
ATOM   1839  N   THR B  13     -41.106  65.405 133.106  1.00 21.65           N  
ATOM   1840  CA  THR B  13     -42.098  66.472 133.143  1.00 22.02           C  
ATOM   1841  C   THR B  13     -41.918  67.249 134.441  1.00 21.80           C  
ATOM   1842  O   THR B  13     -42.063  66.693 135.532  1.00 21.08           O  
ATOM   1843  CB  THR B  13     -43.551  65.930 133.086  1.00 21.54           C  
ATOM   1844  OG1 THR B  13     -43.784  65.268 131.833  1.00 20.81           O  
ATOM   1845  CG2 THR B  13     -44.548  67.078 133.221  1.00 19.00           C  
ATOM   1846  N   ILE B  14     -41.591  68.530 134.315  1.00 20.47           N  
ATOM   1847  CA  ILE B  14     -41.401  69.397 135.471  1.00 20.46           C  
ATOM   1848  C   ILE B  14     -42.633  70.266 135.670  1.00 21.65           C  
ATOM   1849  O   ILE B  14     -43.052  70.960 134.746  1.00 23.63           O  
ATOM   1850  CB  ILE B  14     -40.225  70.366 135.275  1.00 21.37           C  
ATOM   1851  CG1 ILE B  14     -38.910  69.597 135.113  1.00 22.15           C  
ATOM   1852  CG2 ILE B  14     -40.150  71.322 136.458  1.00 21.93           C  
ATOM   1853  CD1 ILE B  14     -37.743  70.480 134.697  1.00 20.81           C  
ATOM   1854  N   PHE B  15     -43.218  70.224 136.861  1.00 20.42           N  
ATOM   1855  CA  PHE B  15     -44.368  71.069 137.160  1.00 21.17           C  
ATOM   1856  C   PHE B  15     -43.864  72.323 137.864  1.00 22.19           C  
ATOM   1857  O   PHE B  15     -43.243  72.251 138.927  1.00 21.18           O  
ATOM   1858  CB  PHE B  15     -45.366  70.357 138.072  1.00 19.71           C  
ATOM   1859  CG  PHE B  15     -46.332  69.470 137.340  1.00 23.58           C  
ATOM   1860  CD1 PHE B  15     -45.933  68.224 136.865  1.00 23.63           C  
ATOM   1861  CD2 PHE B  15     -47.645  69.883 137.121  1.00 24.30           C  
ATOM   1862  CE1 PHE B  15     -46.831  67.398 136.181  1.00 24.10           C  
ATOM   1863  CE2 PHE B  15     -48.551  69.064 136.437  1.00 23.04           C  
ATOM   1864  CZ  PHE B  15     -48.137  67.820 135.968  1.00 23.29           C  
ATOM   1865  N   THR B  16     -44.122  73.480 137.275  1.00 22.63           N  
ATOM   1866  CA  THR B  16     -43.678  74.699 137.905  1.00 24.11           C  
ATOM   1867  C   THR B  16     -44.489  75.882 137.406  1.00 24.73           C  
ATOM   1868  O   THR B  16     -45.265  75.757 136.457  1.00 23.27           O  
ATOM   1869  CB  THR B  16     -42.162  74.920 137.652  1.00 25.63           C  
ATOM   1870  OG1 THR B  16     -41.672  75.908 138.562  1.00 28.87           O  
ATOM   1871  CG2 THR B  16     -41.904  75.383 136.218  1.00 24.39           C  
ATOM   1872  N   ASP B  17     -44.343  77.020 138.076  1.00 25.70           N  
ATOM   1873  CA  ASP B  17     -45.048  78.226 137.667  1.00 26.69           C  
ATOM   1874  C   ASP B  17     -44.033  79.344 137.448  1.00 27.26           C  
ATOM   1875  O   ASP B  17     -42.914  79.289 137.961  1.00 28.56           O  
ATOM   1876  CB  ASP B  17     -46.077  78.653 138.724  1.00 28.13           C  
ATOM   1877  CG  ASP B  17     -45.446  78.972 140.067  1.00 30.85           C  
ATOM   1878  OD1 ASP B  17     -45.541  78.136 140.986  1.00 33.44           O  
ATOM   1879  OD2 ASP B  17     -44.849  80.056 140.205  1.00 34.48           O  
ATOM   1880  N   ALA B  18     -44.429  80.349 136.674  1.00 27.90           N  
ATOM   1881  CA  ALA B  18     -43.566  81.489 136.386  1.00 28.02           C  
ATOM   1882  C   ALA B  18     -44.454  82.699 136.132  1.00 29.24           C  
ATOM   1883  O   ALA B  18     -45.628  82.549 135.791  1.00 27.95           O  
ATOM   1884  CB  ALA B  18     -42.711  81.208 135.149  1.00 27.46           C  
ATOM   1885  N   LYS B  19     -43.900  83.896 136.294  1.00 28.51           N  
ATOM   1886  CA  LYS B  19     -44.677  85.100 136.044  1.00 29.25           C  
ATOM   1887  C   LYS B  19     -44.835  85.219 134.539  1.00 29.21           C  
ATOM   1888  O   LYS B  19     -43.929  84.869 133.783  1.00 28.48           O  
ATOM   1889  CB  LYS B  19     -43.958  86.337 136.590  1.00 30.30           C  
ATOM   1890  CG  LYS B  19     -43.761  86.336 138.099  1.00 31.99           C  
ATOM   1891  CD  LYS B  19     -45.088  86.310 138.840  1.00 32.78           C  
ATOM   1892  CE  LYS B  19     -44.874  86.209 140.343  1.00 35.24           C  
ATOM   1893  NZ  LYS B  19     -46.159  86.103 141.083  1.00 36.88           N  
ATOM   1894  N   GLU B  20     -45.988  85.710 134.105  1.00 30.68           N  
ATOM   1895  CA  GLU B  20     -46.248  85.879 132.687  1.00 31.29           C  
ATOM   1896  C   GLU B  20     -45.240  86.857 132.088  1.00 32.26           C  
ATOM   1897  O   GLU B  20     -44.913  86.783 130.902  1.00 31.03           O  
ATOM   1898  CB  GLU B  20     -47.670  86.403 132.485  1.00 34.92           C  
ATOM   1899  CG  GLU B  20     -48.119  86.430 131.038  1.00 36.62           C  
ATOM   1900  CD  GLU B  20     -49.560  86.872 130.891  1.00 37.74           C  
ATOM   1901  OE1 GLU B  20     -50.426  86.317 131.597  1.00 37.80           O  
ATOM   1902  OE2 GLU B  20     -49.825  87.769 130.060  1.00 40.94           O  
ATOM   1903  N   SER B  21     -44.740  87.766 132.922  1.00 30.50           N  
ATOM   1904  CA  SER B  21     -43.782  88.763 132.472  1.00 31.94           C  
ATOM   1905  C   SER B  21     -42.340  88.254 132.444  1.00 31.52           C  
ATOM   1906  O   SER B  21     -41.470  88.901 131.857  1.00 30.91           O  
ATOM   1907  CB  SER B  21     -43.871  90.017 133.357  1.00 32.92           C  
ATOM   1908  OG  SER B  21     -43.518  89.736 134.703  1.00 33.98           O  
ATOM   1909  N   SER B  22     -42.085  87.102 133.065  1.00 29.76           N  
ATOM   1910  CA  SER B  22     -40.735  86.540 133.088  1.00 29.31           C  
ATOM   1911  C   SER B  22     -40.341  86.111 131.677  1.00 29.19           C  
ATOM   1912  O   SER B  22     -41.197  85.919 130.814  1.00 28.90           O  
ATOM   1913  CB  SER B  22     -40.649  85.348 134.054  1.00 28.35           C  
ATOM   1914  OG  SER B  22     -41.441  84.262 133.620  1.00 25.84           O  
ATOM   1915  N   THR B  23     -39.043  85.951 131.447  1.00 28.34           N  
ATOM   1916  CA  THR B  23     -38.557  85.601 130.123  1.00 28.04           C  
ATOM   1917  C   THR B  23     -38.218  84.138 129.876  1.00 27.73           C  
ATOM   1918  O   THR B  23     -38.023  83.357 130.806  1.00 26.89           O  
ATOM   1919  CB  THR B  23     -37.305  86.422 129.778  1.00 27.80           C  
ATOM   1920  OG1 THR B  23     -36.250  86.077 130.685  1.00 27.04           O  
ATOM   1921  CG2 THR B  23     -37.599  87.908 129.888  1.00 28.78           C  
ATOM   1922  N   VAL B  24     -38.152  83.789 128.594  1.00 28.04           N  
ATOM   1923  CA  VAL B  24     -37.808  82.443 128.159  1.00 27.73           C  
ATOM   1924  C   VAL B  24     -36.451  82.089 128.745  1.00 28.72           C  
ATOM   1925  O   VAL B  24     -36.227  80.963 129.194  1.00 29.86           O  
ATOM   1926  CB  VAL B  24     -37.709  82.366 126.618  1.00 27.29           C  
ATOM   1927  CG1 VAL B  24     -37.051  81.059 126.195  1.00 28.48           C  
ATOM   1928  CG2 VAL B  24     -39.088  82.479 126.008  1.00 26.35           C  
ATOM   1929  N   PHE B  25     -35.540  83.058 128.748  1.00 26.52           N  
ATOM   1930  CA  PHE B  25     -34.217  82.805 129.288  1.00 26.74           C  
ATOM   1931  C   PHE B  25     -34.285  82.538 130.787  1.00 27.49           C  
ATOM   1932  O   PHE B  25     -33.584  81.668 131.300  1.00 26.18           O  
ATOM   1933  CB  PHE B  25     -33.281  83.986 129.035  1.00 28.75           C  
ATOM   1934  CG  PHE B  25     -31.866  83.716 129.446  1.00 28.82           C  
ATOM   1935  CD1 PHE B  25     -31.047  82.908 128.660  1.00 29.61           C  
ATOM   1936  CD2 PHE B  25     -31.361  84.233 130.638  1.00 30.80           C  
ATOM   1937  CE1 PHE B  25     -29.745  82.618 129.056  1.00 30.60           C  
ATOM   1938  CE2 PHE B  25     -30.056  83.947 131.044  1.00 31.64           C  
ATOM   1939  CZ  PHE B  25     -29.248  83.139 130.249  1.00 31.60           C  
ATOM   1940  N   GLU B  26     -35.125  83.290 131.492  1.00 28.14           N  
ATOM   1941  CA  GLU B  26     -35.261  83.107 132.931  1.00 27.92           C  
ATOM   1942  C   GLU B  26     -35.803  81.718 133.238  1.00 27.98           C  
ATOM   1943  O   GLU B  26     -35.436  81.112 134.246  1.00 27.55           O  
ATOM   1944  CB  GLU B  26     -36.181  84.180 133.527  1.00 28.86           C  
ATOM   1945  CG  GLU B  26     -35.579  85.576 133.484  1.00 30.87           C  
ATOM   1946  CD  GLU B  26     -36.505  86.645 134.037  1.00 33.30           C  
ATOM   1947  OE1 GLU B  26     -37.698  86.654 133.668  1.00 31.69           O  
ATOM   1948  OE2 GLU B  26     -36.034  87.488 134.833  1.00 37.45           O  
ATOM   1949  N   LEU B  27     -36.670  81.209 132.369  1.00 26.74           N  
ATOM   1950  CA  LEU B  27     -37.228  79.880 132.583  1.00 25.94           C  
ATOM   1951  C   LEU B  27     -36.117  78.845 132.408  1.00 27.39           C  
ATOM   1952  O   LEU B  27     -36.068  77.853 133.135  1.00 27.64           O  
ATOM   1953  CB  LEU B  27     -38.371  79.603 131.600  1.00 25.08           C  
ATOM   1954  CG  LEU B  27     -39.217  78.365 131.927  1.00 24.79           C  
ATOM   1955  CD1 LEU B  27     -39.838  78.516 133.312  1.00 24.31           C  
ATOM   1956  CD2 LEU B  27     -40.306  78.198 130.876  1.00 22.97           C  
ATOM   1957  N   LYS B  28     -35.223  79.077 131.446  1.00 25.84           N  
ATOM   1958  CA  LYS B  28     -34.113  78.159 131.218  1.00 26.20           C  
ATOM   1959  C   LYS B  28     -33.259  78.080 132.475  1.00 26.27           C  
ATOM   1960  O   LYS B  28     -32.712  77.026 132.787  1.00 26.96           O  
ATOM   1961  CB  LYS B  28     -33.252  78.613 130.033  1.00 26.05           C  
ATOM   1962  CG  LYS B  28     -33.937  78.467 128.683  1.00 24.96           C  
ATOM   1963  CD  LYS B  28     -33.023  78.860 127.530  1.00 25.90           C  
ATOM   1964  CE  LYS B  28     -33.730  78.637 126.191  1.00 26.46           C  
ATOM   1965  NZ  LYS B  28     -32.893  79.021 125.025  1.00 26.67           N  
ATOM   1966  N   ARG B  29     -33.147  79.195 133.197  1.00 27.01           N  
ATOM   1967  CA  ARG B  29     -32.369  79.211 134.433  1.00 27.12           C  
ATOM   1968  C   ARG B  29     -33.079  78.356 135.474  1.00 27.86           C  
ATOM   1969  O   ARG B  29     -32.435  77.729 136.316  1.00 27.58           O  
ATOM   1970  CB  ARG B  29     -32.198  80.643 134.961  1.00 27.49           C  
ATOM   1971  CG  ARG B  29     -31.134  81.479 134.244  1.00 29.87           C  
ATOM   1972  CD  ARG B  29     -29.715  80.917 134.437  1.00 33.09           C  
ATOM   1973  NE  ARG B  29     -28.699  81.780 133.832  1.00 34.92           N  
ATOM   1974  CZ  ARG B  29     -27.436  81.425 133.604  1.00 35.05           C  
ATOM   1975  NH1 ARG B  29     -27.005  80.209 133.926  1.00 31.66           N  
ATOM   1976  NH2 ARG B  29     -26.598  82.289 133.046  1.00 33.62           N  
ATOM   1977  N   ILE B  30     -34.408  78.336 135.420  1.00 28.49           N  
ATOM   1978  CA  ILE B  30     -35.182  77.524 136.357  1.00 29.89           C  
ATOM   1979  C   ILE B  30     -34.895  76.059 136.059  1.00 29.58           C  
ATOM   1980  O   ILE B  30     -34.638  75.276 136.967  1.00 29.48           O  
ATOM   1981  CB  ILE B  30     -36.700  77.777 136.217  1.00 31.49           C  
ATOM   1982  CG1 ILE B  30     -37.043  79.188 136.708  1.00 30.06           C  
ATOM   1983  CG2 ILE B  30     -37.481  76.731 137.005  1.00 32.38           C  
ATOM   1984  CD1 ILE B  30     -36.678  79.444 138.166  1.00 31.58           C  
ATOM   1985  N   VAL B  31     -34.930  75.703 134.776  1.00 30.11           N  
ATOM   1986  CA  VAL B  31     -34.660  74.336 134.339  1.00 29.62           C  
ATOM   1987  C   VAL B  31     -33.220  73.952 134.694  1.00 31.31           C  
ATOM   1988  O   VAL B  31     -32.940  72.793 135.003  1.00 28.20           O  
ATOM   1989  CB  VAL B  31     -34.857  74.188 132.808  1.00 30.13           C  
ATOM   1990  CG1 VAL B  31     -34.483  72.785 132.364  1.00 31.08           C  
ATOM   1991  CG2 VAL B  31     -36.308  74.483 132.431  1.00 28.62           C  
ATOM   1992  N   GLU B  32     -32.310  74.925 134.650  1.00 31.59           N  
ATOM   1993  CA  GLU B  32     -30.913  74.661 134.981  1.00 32.24           C  
ATOM   1994  C   GLU B  32     -30.773  74.250 136.440  1.00 32.86           C  
ATOM   1995  O   GLU B  32     -30.038  73.319 136.762  1.00 33.35           O  
ATOM   1996  CB  GLU B  32     -30.036  75.892 134.712  1.00 33.09           C  
ATOM   1997  CG  GLU B  32     -28.601  75.748 135.236  1.00 32.89           C  
ATOM   1998  CD  GLU B  32     -27.700  76.919 134.862  1.00 34.77           C  
ATOM   1999  OE1 GLU B  32     -28.078  78.078 135.134  1.00 35.06           O  
ATOM   2000  OE2 GLU B  32     -26.611  76.680 134.303  1.00 34.34           O  
ATOM   2001  N   GLY B  33     -31.480  74.947 137.322  1.00 32.08           N  
ATOM   2002  CA  GLY B  33     -31.407  74.623 138.732  1.00 32.07           C  
ATOM   2003  C   GLY B  33     -32.010  73.266 139.046  1.00 32.23           C  
ATOM   2004  O   GLY B  33     -31.672  72.651 140.056  1.00 32.15           O  
ATOM   2005  N   ILE B  34     -32.897  72.794 138.177  1.00 31.41           N  
ATOM   2006  CA  ILE B  34     -33.557  71.503 138.378  1.00 31.30           C  
ATOM   2007  C   ILE B  34     -32.865  70.334 137.682  1.00 31.20           C  
ATOM   2008  O   ILE B  34     -32.574  69.315 138.305  1.00 32.00           O  
ATOM   2009  CB  ILE B  34     -35.019  71.550 137.888  1.00 30.31           C  
ATOM   2010  CG1 ILE B  34     -35.781  72.644 138.635  1.00 30.30           C  
ATOM   2011  CG2 ILE B  34     -35.689  70.201 138.113  1.00 32.23           C  
ATOM   2012  CD1 ILE B  34     -37.215  72.819 138.179  1.00 29.07           C  
ATOM   2013  N   LEU B  35     -32.598  70.484 136.390  1.00 31.97           N  
ATOM   2014  CA  LEU B  35     -31.975  69.425 135.613  1.00 31.57           C  
ATOM   2015  C   LEU B  35     -30.460  69.557 135.438  1.00 32.42           C  
ATOM   2016  O   LEU B  35     -29.829  68.700 134.816  1.00 32.96           O  
ATOM   2017  CB  LEU B  35     -32.659  69.323 134.248  1.00 32.00           C  
ATOM   2018  CG  LEU B  35     -34.151  68.971 134.287  1.00 33.73           C  
ATOM   2019  CD1 LEU B  35     -34.691  68.862 132.868  1.00 32.70           C  
ATOM   2020  CD2 LEU B  35     -34.354  67.657 135.032  1.00 33.83           C  
ATOM   2021  N   LYS B  36     -29.888  70.631 135.975  1.00 31.44           N  
ATOM   2022  CA  LYS B  36     -28.449  70.872 135.919  1.00 31.88           C  
ATOM   2023  C   LYS B  36     -27.807  70.944 134.531  1.00 32.74           C  
ATOM   2024  O   LYS B  36     -26.756  70.354 134.295  1.00 34.60           O  
ATOM   2025  CB  LYS B  36     -27.728  69.816 136.763  1.00 32.93           C  
ATOM   2026  CG  LYS B  36     -28.199  69.787 138.208  1.00 35.36           C  
ATOM   2027  CD  LYS B  36     -27.907  71.112 138.904  1.00 38.76           C  
ATOM   2028  CE  LYS B  36     -28.863  71.361 140.064  1.00 40.23           C  
ATOM   2029  NZ  LYS B  36     -28.943  70.204 140.990  1.00 39.99           N  
ATOM   2030  N   ARG B  37     -28.449  71.666 133.619  1.00 33.08           N  
ATOM   2031  CA  ARG B  37     -27.940  71.864 132.269  1.00 33.21           C  
ATOM   2032  C   ARG B  37     -28.073  73.371 132.017  1.00 34.52           C  
ATOM   2033  O   ARG B  37     -29.134  73.952 132.256  1.00 34.19           O  
ATOM   2034  CB  ARG B  37     -28.766  71.077 131.243  1.00 33.02           C  
ATOM   2035  CG  ARG B  37     -28.757  69.549 131.432  1.00 34.23           C  
ATOM   2036  CD  ARG B  37     -27.352  68.956 131.284  1.00 33.73           C  
ATOM   2037  NE  ARG B  37     -26.805  69.146 129.939  1.00 34.70           N  
ATOM   2038  CZ  ARG B  37     -27.191  68.465 128.862  1.00 36.68           C  
ATOM   2039  NH1 ARG B  37     -28.129  67.534 128.963  1.00 37.98           N  
ATOM   2040  NH2 ARG B  37     -26.647  68.723 127.677  1.00 36.73           N  
ATOM   2041  N   PRO B  38     -26.996  74.025 131.543  1.00 34.17           N  
ATOM   2042  CA  PRO B  38     -26.987  75.467 131.266  1.00 34.22           C  
ATOM   2043  C   PRO B  38     -27.946  75.905 130.158  1.00 32.50           C  
ATOM   2044  O   PRO B  38     -28.251  75.138 129.240  1.00 31.58           O  
ATOM   2045  CB  PRO B  38     -25.527  75.742 130.899  1.00 35.15           C  
ATOM   2046  CG  PRO B  38     -24.779  74.657 131.603  1.00 38.37           C  
ATOM   2047  CD  PRO B  38     -25.652  73.460 131.352  1.00 36.34           C  
ATOM   2048  N   PRO B  39     -28.422  77.161 130.222  1.00 31.70           N  
ATOM   2049  CA  PRO B  39     -29.349  77.702 129.223  1.00 30.82           C  
ATOM   2050  C   PRO B  39     -28.899  77.506 127.778  1.00 32.35           C  
ATOM   2051  O   PRO B  39     -29.714  77.223 126.895  1.00 32.43           O  
ATOM   2052  CB  PRO B  39     -29.443  79.171 129.611  1.00 30.72           C  
ATOM   2053  CG  PRO B  39     -29.366  79.101 131.108  1.00 30.60           C  
ATOM   2054  CD  PRO B  39     -28.242  78.111 131.338  1.00 30.38           C  
ATOM   2055  N   GLU B  40     -27.599  77.661 127.534  1.00 33.91           N  
ATOM   2056  CA  GLU B  40     -27.060  77.495 126.182  1.00 35.09           C  
ATOM   2057  C   GLU B  40     -27.215  76.058 125.660  1.00 35.02           C  
ATOM   2058  O   GLU B  40     -27.164  75.821 124.449  1.00 36.17           O  
ATOM   2059  CB  GLU B  40     -25.579  77.887 126.138  1.00 37.31           C  
ATOM   2060  CG  GLU B  40     -24.642  77.031 126.990  1.00 37.71           C  
ATOM   2061  CD  GLU B  40     -24.419  77.599 128.378  1.00 40.08           C  
ATOM   2062  OE1 GLU B  40     -25.322  78.297 128.894  1.00 39.38           O  
ATOM   2063  OE2 GLU B  40     -23.340  77.343 128.973  1.00 42.11           O  
ATOM   2064  N   GLU B  41     -27.388  75.106 126.577  1.00 34.96           N  
ATOM   2065  CA  GLU B  41     -27.565  73.706 126.207  1.00 34.46           C  
ATOM   2066  C   GLU B  41     -29.061  73.387 126.188  1.00 33.92           C  
ATOM   2067  O   GLU B  41     -29.461  72.221 126.172  1.00 32.67           O  
ATOM   2068  CB  GLU B  41     -26.848  72.805 127.213  1.00 36.42           C  
ATOM   2069  CG  GLU B  41     -25.389  73.136 127.400  1.00 39.00           C  
ATOM   2070  CD  GLU B  41     -24.604  71.968 127.957  1.00 41.67           C  
ATOM   2071  OE1 GLU B  41     -24.999  71.419 129.008  1.00 42.65           O  
ATOM   2072  OE2 GLU B  41     -23.585  71.601 127.338  1.00 44.95           O  
ATOM   2073  N   GLN B  42     -29.881  74.435 126.186  1.00 30.95           N  
ATOM   2074  CA  GLN B  42     -31.332  74.275 126.187  1.00 29.93           C  
ATOM   2075  C   GLN B  42     -32.053  74.979 125.048  1.00 31.32           C  
ATOM   2076  O   GLN B  42     -31.621  76.021 124.562  1.00 33.04           O  
ATOM   2077  CB  GLN B  42     -31.937  74.827 127.473  1.00 27.65           C  
ATOM   2078  CG  GLN B  42     -31.578  74.130 128.759  1.00 24.10           C  
ATOM   2079  CD  GLN B  42     -32.272  74.796 129.926  1.00 24.40           C  
ATOM   2080  OE1 GLN B  42     -33.438  75.187 129.818  1.00 24.94           O  
ATOM   2081  NE2 GLN B  42     -31.572  74.932 131.043  1.00 22.77           N  
ATOM   2082  N   ARG B  43     -33.173  74.396 124.644  1.00 31.85           N  
ATOM   2083  CA  ARG B  43     -34.036  74.965 123.626  1.00 31.27           C  
ATOM   2084  C   ARG B  43     -35.421  74.732 124.194  1.00 31.11           C  
ATOM   2085  O   ARG B  43     -35.716  73.636 124.667  1.00 29.79           O  
ATOM   2086  CB  ARG B  43     -33.874  74.247 122.286  1.00 35.04           C  
ATOM   2087  CG  ARG B  43     -32.835  74.890 121.386  1.00 38.61           C  
ATOM   2088  CD  ARG B  43     -32.670  74.143 120.080  1.00 44.03           C  
ATOM   2089  NE  ARG B  43     -31.776  74.857 119.174  1.00 46.12           N  
ATOM   2090  CZ  ARG B  43     -31.401  74.408 117.982  1.00 48.73           C  
ATOM   2091  NH1 ARG B  43     -31.839  73.235 117.543  1.00 50.13           N  
ATOM   2092  NH2 ARG B  43     -30.597  75.138 117.223  1.00 50.02           N  
ATOM   2093  N   LEU B  44     -36.250  75.770 124.192  1.00 29.51           N  
ATOM   2094  CA  LEU B  44     -37.606  75.664 124.709  1.00 28.13           C  
ATOM   2095  C   LEU B  44     -38.584  75.953 123.584  1.00 29.37           C  
ATOM   2096  O   LEU B  44     -38.336  76.819 122.742  1.00 30.35           O  
ATOM   2097  CB  LEU B  44     -37.816  76.645 125.866  1.00 27.27           C  
ATOM   2098  CG  LEU B  44     -36.942  76.403 127.106  1.00 28.12           C  
ATOM   2099  CD1 LEU B  44     -37.291  77.409 128.189  1.00 24.58           C  
ATOM   2100  CD2 LEU B  44     -37.157  74.986 127.622  1.00 27.76           C  
ATOM   2101  N   TYR B  45     -39.693  75.223 123.566  1.00 28.97           N  
ATOM   2102  CA  TYR B  45     -40.694  75.388 122.523  1.00 29.96           C  
ATOM   2103  C   TYR B  45     -42.107  75.492 123.065  1.00 32.30           C  
ATOM   2104  O   TYR B  45     -42.393  75.094 124.195  1.00 31.85           O  
ATOM   2105  CB  TYR B  45     -40.693  74.187 121.568  1.00 28.96           C  
ATOM   2106  CG  TYR B  45     -39.361  73.794 120.967  1.00 30.85           C  
ATOM   2107  CD1 TYR B  45     -38.351  73.235 121.751  1.00 29.32           C  
ATOM   2108  CD2 TYR B  45     -39.121  73.953 119.603  1.00 29.58           C  
ATOM   2109  CE1 TYR B  45     -37.139  72.843 121.190  1.00 30.84           C  
ATOM   2110  CE2 TYR B  45     -37.917  73.564 119.033  1.00 30.14           C  
ATOM   2111  CZ  TYR B  45     -36.931  73.010 119.830  1.00 31.60           C  
ATOM   2112  OH  TYR B  45     -35.736  72.622 119.266  1.00 35.29           O  
ATOM   2113  N   LYS B  46     -42.983  76.058 122.246  1.00 34.04           N  
ATOM   2114  CA  LYS B  46     -44.399  76.119 122.561  1.00 37.37           C  
ATOM   2115  C   LYS B  46     -44.874  75.388 121.323  1.00 38.63           C  
ATOM   2116  O   LYS B  46     -44.942  75.969 120.237  1.00 40.01           O  
ATOM   2117  CB  LYS B  46     -44.959  77.537 122.571  1.00 36.60           C  
ATOM   2118  CG  LYS B  46     -46.415  77.529 123.014  1.00 38.13           C  
ATOM   2119  CD  LYS B  46     -47.090  78.871 122.914  1.00 42.26           C  
ATOM   2120  CE  LYS B  46     -48.524  78.761 123.400  1.00 43.28           C  
ATOM   2121  NZ  LYS B  46     -49.292  80.014 123.181  1.00 48.83           N  
ATOM   2122  N   ASP B  47     -45.163  74.102 121.487  1.00 40.48           N  
ATOM   2123  CA  ASP B  47     -45.555  73.250 120.374  1.00 42.72           C  
ATOM   2124  C   ASP B  47     -44.312  73.084 119.505  1.00 43.35           C  
ATOM   2125  O   ASP B  47     -43.285  72.605 119.984  1.00 43.75           O  
ATOM   2126  CB  ASP B  47     -46.709  73.868 119.582  1.00 43.17           C  
ATOM   2127  CG  ASP B  47     -48.012  73.835 120.352  1.00 45.60           C  
ATOM   2128  OD1 ASP B  47     -48.332  72.760 120.900  1.00 46.42           O  
ATOM   2129  OD2 ASP B  47     -48.714  74.867 120.413  1.00 47.32           O  
ATOM   2130  N   ASP B  48     -44.381  73.489 118.243  1.00 44.73           N  
ATOM   2131  CA  ASP B  48     -43.219  73.356 117.374  1.00 45.98           C  
ATOM   2132  C   ASP B  48     -42.432  74.651 117.242  1.00 44.79           C  
ATOM   2133  O   ASP B  48     -41.383  74.689 116.602  1.00 44.66           O  
ATOM   2134  CB  ASP B  48     -43.647  72.860 115.991  1.00 49.37           C  
ATOM   2135  CG  ASP B  48     -43.836  71.355 115.950  1.00 52.92           C  
ATOM   2136  OD1 ASP B  48     -44.655  70.835 116.739  1.00 55.50           O  
ATOM   2137  OD2 ASP B  48     -43.162  70.692 115.131  1.00 55.54           O  
ATOM   2138  N   GLN B  49     -42.931  75.709 117.866  1.00 43.67           N  
ATOM   2139  CA  GLN B  49     -42.270  77.003 117.794  1.00 42.89           C  
ATOM   2140  C   GLN B  49     -41.164  77.171 118.825  1.00 41.76           C  
ATOM   2141  O   GLN B  49     -41.410  77.119 120.031  1.00 41.31           O  
ATOM   2142  CB  GLN B  49     -43.294  78.125 117.966  1.00 44.49           C  
ATOM   2143  CG  GLN B  49     -42.685  79.517 117.959  1.00 47.71           C  
ATOM   2144  CD  GLN B  49     -42.031  79.859 116.635  1.00 49.09           C  
ATOM   2145  OE1 GLN B  49     -42.698  79.922 115.599  1.00 50.14           O  
ATOM   2146  NE2 GLN B  49     -40.721  80.077 116.657  1.00 49.26           N  
ATOM   2147  N   LEU B  50     -39.944  77.372 118.339  1.00 40.10           N  
ATOM   2148  CA  LEU B  50     -38.792  77.588 119.206  1.00 38.69           C  
ATOM   2149  C   LEU B  50     -38.971  78.955 119.866  1.00 38.10           C  
ATOM   2150  O   LEU B  50     -39.332  79.925 119.198  1.00 37.67           O  
ATOM   2151  CB  LEU B  50     -37.508  77.583 118.383  1.00 37.45           C  
ATOM   2152  CG  LEU B  50     -36.228  77.916 119.146  1.00 39.33           C  
ATOM   2153  CD1 LEU B  50     -35.887  76.774 120.088  1.00 37.67           C  
ATOM   2154  CD2 LEU B  50     -35.092  78.156 118.158  1.00 39.16           C  
ATOM   2155  N   LEU B  51     -38.718  79.034 121.169  1.00 36.58           N  
ATOM   2156  CA  LEU B  51     -38.877  80.290 121.898  1.00 36.02           C  
ATOM   2157  C   LEU B  51     -37.573  81.080 122.004  1.00 35.70           C  
ATOM   2158  O   LEU B  51     -36.516  80.507 122.262  1.00 36.59           O  
ATOM   2159  CB  LEU B  51     -39.429  80.008 123.301  1.00 36.09           C  
ATOM   2160  CG  LEU B  51     -40.718  79.179 123.353  1.00 35.68           C  
ATOM   2161  CD1 LEU B  51     -41.133  78.980 124.802  1.00 35.57           C  
ATOM   2162  CD2 LEU B  51     -41.826  79.877 122.572  1.00 35.32           C  
ATOM   2163  N   ASP B  52     -37.655  82.395 121.802  1.00 35.14           N  
ATOM   2164  CA  ASP B  52     -36.478  83.264 121.883  1.00 35.54           C  
ATOM   2165  C   ASP B  52     -36.233  83.706 123.321  1.00 33.14           C  
ATOM   2166  O   ASP B  52     -37.165  84.098 124.023  1.00 33.92           O  
ATOM   2167  CB  ASP B  52     -36.649  84.499 120.989  1.00 35.08           C  
ATOM   2168  CG  ASP B  52     -36.858  84.137 119.530  1.00 38.56           C  
ATOM   2169  OD1 ASP B  52     -36.138  83.244 119.030  1.00 39.88           O  
ATOM   2170  OD2 ASP B  52     -37.731  84.752 118.879  1.00 38.27           O  
ATOM   2171  N   ASP B  53     -34.973  83.653 123.741  1.00 33.48           N  
ATOM   2172  CA  ASP B  53     -34.574  84.016 125.100  1.00 32.59           C  
ATOM   2173  C   ASP B  53     -35.049  85.361 125.649  1.00 32.29           C  
ATOM   2174  O   ASP B  53     -35.381  85.461 126.826  1.00 29.63           O  
ATOM   2175  CB  ASP B  53     -33.046  83.959 125.233  1.00 34.05           C  
ATOM   2176  CG  ASP B  53     -32.503  82.543 125.166  1.00 35.95           C  
ATOM   2177  OD1 ASP B  53     -33.096  81.654 125.810  1.00 36.08           O  
ATOM   2178  OD2 ASP B  53     -31.481  82.321 124.479  1.00 35.05           O  
ATOM   2179  N   GLY B  54     -35.077  86.392 124.809  1.00 32.13           N  
ATOM   2180  CA  GLY B  54     -35.477  87.710 125.280  1.00 33.81           C  
ATOM   2181  C   GLY B  54     -36.962  87.985 125.434  1.00 34.34           C  
ATOM   2182  O   GLY B  54     -37.348  88.983 126.040  1.00 35.06           O  
ATOM   2183  N   LYS B  55     -37.797  87.112 124.885  1.00 34.54           N  
ATOM   2184  CA  LYS B  55     -39.241  87.288 124.971  1.00 33.91           C  
ATOM   2185  C   LYS B  55     -39.791  86.887 126.338  1.00 33.48           C  
ATOM   2186  O   LYS B  55     -39.211  86.054 127.035  1.00 33.09           O  
ATOM   2187  CB  LYS B  55     -39.933  86.458 123.886  1.00 36.35           C  
ATOM   2188  CG  LYS B  55     -39.529  86.811 122.461  1.00 40.59           C  
ATOM   2189  CD  LYS B  55     -39.822  88.268 122.139  1.00 45.26           C  
ATOM   2190  CE  LYS B  55     -39.467  88.596 120.695  1.00 48.23           C  
ATOM   2191  NZ  LYS B  55     -39.588  90.052 120.411  1.00 50.44           N  
ATOM   2192  N   THR B  56     -40.907  87.492 126.727  1.00 33.53           N  
ATOM   2193  CA  THR B  56     -41.541  87.157 127.997  1.00 33.38           C  
ATOM   2194  C   THR B  56     -42.416  85.947 127.705  1.00 32.18           C  
ATOM   2195  O   THR B  56     -42.748  85.687 126.549  1.00 32.31           O  
ATOM   2196  CB  THR B  56     -42.446  88.287 128.493  1.00 32.81           C  
ATOM   2197  OG1 THR B  56     -43.525  88.470 127.568  1.00 33.24           O  
ATOM   2198  CG2 THR B  56     -41.664  89.581 128.614  1.00 34.71           C  
ATOM   2199  N   LEU B  57     -42.792  85.198 128.734  1.00 32.92           N  
ATOM   2200  CA  LEU B  57     -43.638  84.035 128.504  1.00 32.13           C  
ATOM   2201  C   LEU B  57     -44.947  84.505 127.890  1.00 32.90           C  
ATOM   2202  O   LEU B  57     -45.497  83.854 127.005  1.00 31.16           O  
ATOM   2203  CB  LEU B  57     -43.902  83.288 129.815  1.00 31.06           C  
ATOM   2204  CG  LEU B  57     -42.652  82.694 130.467  1.00 28.12           C  
ATOM   2205  CD1 LEU B  57     -43.051  81.841 131.664  1.00 27.26           C  
ATOM   2206  CD2 LEU B  57     -41.893  81.865 129.441  1.00 27.06           C  
ATOM   2207  N   GLY B  58     -45.437  85.648 128.363  1.00 34.97           N  
ATOM   2208  CA  GLY B  58     -46.675  86.189 127.834  1.00 37.29           C  
ATOM   2209  C   GLY B  58     -46.591  86.368 126.330  1.00 38.57           C  
ATOM   2210  O   GLY B  58     -47.499  85.977 125.601  1.00 39.07           O  
ATOM   2211  N   GLU B  59     -45.493  86.956 125.863  1.00 40.87           N  
ATOM   2212  CA  GLU B  59     -45.292  87.174 124.435  1.00 42.97           C  
ATOM   2213  C   GLU B  59     -45.266  85.857 123.672  1.00 44.02           C  
ATOM   2214  O   GLU B  59     -45.565  85.820 122.477  1.00 44.58           O  
ATOM   2215  CB  GLU B  59     -43.978  87.915 124.184  1.00 44.74           C  
ATOM   2216  CG  GLU B  59     -43.971  89.362 124.626  1.00 48.53           C  
ATOM   2217  CD  GLU B  59     -42.635  90.029 124.376  1.00 49.18           C  
ATOM   2218  OE1 GLU B  59     -41.626  89.569 124.947  1.00 50.51           O  
ATOM   2219  OE2 GLU B  59     -42.594  91.010 123.607  1.00 52.30           O  
ATOM   2220  N   CYS B  60     -44.899  84.778 124.362  1.00 43.00           N  
ATOM   2221  CA  CYS B  60     -44.827  83.461 123.741  1.00 42.22           C  
ATOM   2222  C   CYS B  60     -46.199  82.796 123.652  1.00 41.72           C  
ATOM   2223  O   CYS B  60     -46.388  81.844 122.898  1.00 43.00           O  
ATOM   2224  CB  CYS B  60     -43.857  82.563 124.517  1.00 42.94           C  
ATOM   2225  SG  CYS B  60     -42.126  83.099 124.455  1.00 41.29           S  
ATOM   2226  N   GLY B  61     -47.155  83.302 124.424  1.00 40.74           N  
ATOM   2227  CA  GLY B  61     -48.492  82.741 124.391  1.00 39.54           C  
ATOM   2228  C   GLY B  61     -48.906  82.043 125.668  1.00 39.76           C  
ATOM   2229  O   GLY B  61     -49.945  81.381 125.710  1.00 40.71           O  
ATOM   2230  N   PHE B  62     -48.097  82.178 126.712  1.00 37.88           N  
ATOM   2231  CA  PHE B  62     -48.407  81.550 127.991  1.00 37.87           C  
ATOM   2232  C   PHE B  62     -49.062  82.556 128.929  1.00 38.56           C  
ATOM   2233  O   PHE B  62     -48.385  83.233 129.708  1.00 40.80           O  
ATOM   2234  CB  PHE B  62     -47.132  80.983 128.620  1.00 35.34           C  
ATOM   2235  CG  PHE B  62     -46.488  79.899 127.802  1.00 33.39           C  
ATOM   2236  CD1 PHE B  62     -47.107  78.659 127.654  1.00 31.05           C  
ATOM   2237  CD2 PHE B  62     -45.272  80.120 127.165  1.00 30.88           C  
ATOM   2238  CE1 PHE B  62     -46.525  77.660 126.883  1.00 32.07           C  
ATOM   2239  CE2 PHE B  62     -44.682  79.128 126.392  1.00 31.57           C  
ATOM   2240  CZ  PHE B  62     -45.309  77.895 126.251  1.00 31.82           C  
ATOM   2241  N   THR B  63     -50.386  82.646 128.849  1.00 38.36           N  
ATOM   2242  CA  THR B  63     -51.151  83.575 129.675  1.00 38.06           C  
ATOM   2243  C   THR B  63     -51.804  82.854 130.840  1.00 38.38           C  
ATOM   2244  O   THR B  63     -52.053  81.651 130.774  1.00 38.46           O  
ATOM   2245  CB  THR B  63     -52.268  84.250 128.864  1.00 37.03           C  
ATOM   2246  OG1 THR B  63     -53.270  83.278 128.534  1.00 36.15           O  
ATOM   2247  CG2 THR B  63     -51.706  84.848 127.584  1.00 36.75           C  
ATOM   2248  N   SER B  64     -52.097  83.600 131.899  1.00 38.54           N  
ATOM   2249  CA  SER B  64     -52.726  83.038 133.085  1.00 41.14           C  
ATOM   2250  C   SER B  64     -54.045  82.346 132.767  1.00 42.04           C  
ATOM   2251  O   SER B  64     -54.486  81.465 133.505  1.00 42.80           O  
ATOM   2252  CB  SER B  64     -52.971  84.136 134.120  1.00 41.80           C  
ATOM   2253  OG  SER B  64     -51.751  84.735 134.508  1.00 46.43           O  
ATOM   2254  N   GLN B  65     -54.673  82.747 131.666  1.00 43.06           N  
ATOM   2255  CA  GLN B  65     -55.952  82.168 131.267  1.00 43.85           C  
ATOM   2256  C   GLN B  65     -55.786  80.843 130.536  1.00 42.89           C  
ATOM   2257  O   GLN B  65     -56.702  80.022 130.514  1.00 43.76           O  
ATOM   2258  CB  GLN B  65     -56.720  83.143 130.364  1.00 46.68           C  
ATOM   2259  CG  GLN B  65     -57.114  84.448 131.031  1.00 47.74           C  
ATOM   2260  CD  GLN B  65     -55.916  85.253 131.498  1.00 50.75           C  
ATOM   2261  OE1 GLN B  65     -55.037  85.603 130.706  1.00 48.32           O  
ATOM   2262  NE2 GLN B  65     -55.876  85.552 132.792  1.00 51.87           N  
ATOM   2263  N   THR B  66     -54.617  80.637 129.944  1.00 41.07           N  
ATOM   2264  CA  THR B  66     -54.352  79.414 129.195  1.00 39.07           C  
ATOM   2265  C   THR B  66     -53.309  78.517 129.855  1.00 36.49           C  
ATOM   2266  O   THR B  66     -52.858  77.543 129.257  1.00 35.72           O  
ATOM   2267  CB  THR B  66     -53.873  79.743 127.784  1.00 39.95           C  
ATOM   2268  OG1 THR B  66     -52.671  80.518 127.863  1.00 41.23           O  
ATOM   2269  CG2 THR B  66     -54.939  80.539 127.039  1.00 41.35           C  
ATOM   2270  N   ALA B  67     -52.926  78.857 131.080  1.00 33.31           N  
ATOM   2271  CA  ALA B  67     -51.941  78.077 131.821  1.00 31.34           C  
ATOM   2272  C   ALA B  67     -52.324  78.089 133.295  1.00 30.58           C  
ATOM   2273  O   ALA B  67     -51.654  78.708 134.120  1.00 29.75           O  
ATOM   2274  CB  ALA B  67     -50.541  78.668 131.618  1.00 27.71           C  
ATOM   2275  N   ARG B  68     -53.412  77.390 133.612  1.00 32.28           N  
ATOM   2276  CA  ARG B  68     -53.945  77.306 134.973  1.00 32.69           C  
ATOM   2277  C   ARG B  68     -53.363  76.142 135.776  1.00 32.65           C  
ATOM   2278  O   ARG B  68     -52.878  75.163 135.205  1.00 30.45           O  
ATOM   2279  CB  ARG B  68     -55.461  77.154 134.905  1.00 37.30           C  
ATOM   2280  CG  ARG B  68     -56.128  78.129 133.950  1.00 42.45           C  
ATOM   2281  CD  ARG B  68     -57.552  77.705 133.655  1.00 47.97           C  
ATOM   2282  NE  ARG B  68     -58.217  78.624 132.737  1.00 54.30           N  
ATOM   2283  CZ  ARG B  68     -59.454  78.457 132.278  1.00 56.22           C  
ATOM   2284  NH1 ARG B  68     -60.162  77.399 132.654  1.00 55.84           N  
ATOM   2285  NH2 ARG B  68     -59.986  79.349 131.449  1.00 57.38           N  
ATOM   2286  N   PRO B  69     -53.423  76.228 137.118  1.00 31.88           N  
ATOM   2287  CA  PRO B  69     -52.898  75.179 137.998  1.00 31.89           C  
ATOM   2288  C   PRO B  69     -53.462  73.796 137.681  1.00 30.20           C  
ATOM   2289  O   PRO B  69     -52.725  72.813 137.635  1.00 30.23           O  
ATOM   2290  CB  PRO B  69     -53.318  75.651 139.391  1.00 32.01           C  
ATOM   2291  CG  PRO B  69     -53.334  77.137 139.252  1.00 32.98           C  
ATOM   2292  CD  PRO B  69     -53.997  77.330 137.911  1.00 32.46           C  
ATOM   2293  N   GLN B  70     -54.770  73.741 137.461  1.00 28.27           N  
ATOM   2294  CA  GLN B  70     -55.471  72.495 137.168  1.00 28.26           C  
ATOM   2295  C   GLN B  70     -55.312  72.019 135.729  1.00 27.59           C  
ATOM   2296  O   GLN B  70     -55.744  70.917 135.387  1.00 26.67           O  
ATOM   2297  CB  GLN B  70     -56.966  72.650 137.475  1.00 29.11           C  
ATOM   2298  CG  GLN B  70     -57.661  73.711 136.624  1.00 30.17           C  
ATOM   2299  CD  GLN B  70     -57.573  75.112 137.210  1.00 29.87           C  
ATOM   2300  OE1 GLN B  70     -56.630  75.451 137.931  1.00 30.61           O  
ATOM   2301  NE2 GLN B  70     -58.558  75.942 136.888  1.00 32.39           N  
ATOM   2302  N   ALA B  71     -54.706  72.849 134.886  1.00 27.93           N  
ATOM   2303  CA  ALA B  71     -54.496  72.505 133.478  1.00 28.47           C  
ATOM   2304  C   ALA B  71     -53.323  73.322 132.944  1.00 28.08           C  
ATOM   2305  O   ALA B  71     -53.490  74.182 132.082  1.00 26.88           O  
ATOM   2306  CB  ALA B  71     -55.747  72.809 132.674  1.00 29.16           C  
ATOM   2307  N   PRO B  72     -52.111  73.045 133.445  1.00 27.98           N  
ATOM   2308  CA  PRO B  72     -50.901  73.756 133.032  1.00 25.96           C  
ATOM   2309  C   PRO B  72     -50.580  73.669 131.550  1.00 25.88           C  
ATOM   2310  O   PRO B  72     -50.896  72.676 130.890  1.00 22.62           O  
ATOM   2311  CB  PRO B  72     -49.823  73.126 133.905  1.00 26.01           C  
ATOM   2312  CG  PRO B  72     -50.317  71.707 134.058  1.00 24.50           C  
ATOM   2313  CD  PRO B  72     -51.778  71.924 134.346  1.00 26.26           C  
ATOM   2314  N   ALA B  73     -49.958  74.729 131.034  1.00 25.27           N  
ATOM   2315  CA  ALA B  73     -49.564  74.790 129.633  1.00 24.78           C  
ATOM   2316  C   ALA B  73     -48.250  74.033 129.500  1.00 24.98           C  
ATOM   2317  O   ALA B  73     -47.469  73.970 130.445  1.00 25.16           O  
ATOM   2318  CB  ALA B  73     -49.382  76.235 129.202  1.00 26.22           C  
ATOM   2319  N   THR B  74     -47.998  73.468 128.327  1.00 26.32           N  
ATOM   2320  CA  THR B  74     -46.784  72.691 128.109  1.00 24.66           C  
ATOM   2321  C   THR B  74     -45.661  73.411 127.370  1.00 24.44           C  
ATOM   2322  O   THR B  74     -45.881  74.043 126.342  1.00 24.04           O  
ATOM   2323  CB  THR B  74     -47.103  71.383 127.342  1.00 27.02           C  
ATOM   2324  OG1 THR B  74     -47.929  70.543 128.157  1.00 27.73           O  
ATOM   2325  CG2 THR B  74     -45.827  70.631 126.994  1.00 24.90           C  
ATOM   2326  N   VAL B  75     -44.455  73.303 127.913  1.00 22.77           N  
ATOM   2327  CA  VAL B  75     -43.274  73.891 127.296  1.00 24.68           C  
ATOM   2328  C   VAL B  75     -42.333  72.745 126.934  1.00 24.92           C  
ATOM   2329  O   VAL B  75     -41.895  71.999 127.810  1.00 23.87           O  
ATOM   2330  CB  VAL B  75     -42.530  74.833 128.256  1.00 23.94           C  
ATOM   2331  CG1 VAL B  75     -41.266  75.358 127.584  1.00 26.74           C  
ATOM   2332  CG2 VAL B  75     -43.433  75.976 128.664  1.00 25.02           C  
ATOM   2333  N   GLY B  76     -42.036  72.601 125.646  1.00 25.79           N  
ATOM   2334  CA  GLY B  76     -41.143  71.546 125.201  1.00 24.38           C  
ATOM   2335  C   GLY B  76     -39.696  71.901 125.476  1.00 25.82           C  
ATOM   2336  O   GLY B  76     -39.326  73.075 125.491  1.00 28.92           O  
ATOM   2337  N   LEU B  77     -38.868  70.888 125.688  1.00 24.40           N  
ATOM   2338  CA  LEU B  77     -37.461  71.111 125.979  1.00 25.46           C  
ATOM   2339  C   LEU B  77     -36.563  70.123 125.236  1.00 27.18           C  
ATOM   2340  O   LEU B  77     -36.877  68.934 125.128  1.00 26.65           O  
ATOM   2341  CB  LEU B  77     -37.232  70.995 127.491  1.00 24.21           C  
ATOM   2342  CG  LEU B  77     -35.803  70.906 128.028  1.00 25.78           C  
ATOM   2343  CD1 LEU B  77     -35.059  72.222 127.786  1.00 26.69           C  
ATOM   2344  CD2 LEU B  77     -35.858  70.583 129.514  1.00 20.72           C  
ATOM   2345  N   ALA B  78     -35.447  70.626 124.718  1.00 27.08           N  
ATOM   2346  CA  ALA B  78     -34.484  69.801 124.005  1.00 29.19           C  
ATOM   2347  C   ALA B  78     -33.095  70.173 124.493  1.00 30.61           C  
ATOM   2348  O   ALA B  78     -32.784  71.351 124.632  1.00 30.64           O  
ATOM   2349  CB  ALA B  78     -34.593  70.038 122.506  1.00 30.82           C  
ATOM   2350  N   PHE B  79     -32.269  69.170 124.770  1.00 32.72           N  
ATOM   2351  CA  PHE B  79     -30.916  69.417 125.243  1.00 35.65           C  
ATOM   2352  C   PHE B  79     -29.888  69.314 124.129  1.00 39.52           C  
ATOM   2353  O   PHE B  79     -30.127  68.699 123.086  1.00 39.22           O  
ATOM   2354  CB  PHE B  79     -30.527  68.433 126.350  1.00 35.35           C  
ATOM   2355  CG  PHE B  79     -31.146  68.734 127.686  1.00 35.77           C  
ATOM   2356  CD1 PHE B  79     -31.321  70.047 128.111  1.00 35.61           C  
ATOM   2357  CD2 PHE B  79     -31.509  67.702 128.543  1.00 33.66           C  
ATOM   2358  CE1 PHE B  79     -31.846  70.325 129.373  1.00 34.24           C  
ATOM   2359  CE2 PHE B  79     -32.033  67.971 129.803  1.00 34.21           C  
ATOM   2360  CZ  PHE B  79     -32.200  69.286 130.218  1.00 32.90           C  
ATOM   2361  N   ARG B  80     -28.732  69.917 124.363  1.00 42.91           N  
ATOM   2362  CA  ARG B  80     -27.660  69.878 123.388  1.00 47.62           C  
ATOM   2363  C   ARG B  80     -26.464  69.148 123.981  1.00 50.20           C  
ATOM   2364  O   ARG B  80     -25.999  69.477 125.074  1.00 50.78           O  
ATOM   2365  CB  ARG B  80     -27.268  71.300 122.972  1.00 47.74           C  
ATOM   2366  CG  ARG B  80     -26.173  71.354 121.923  1.00 49.33           C  
ATOM   2367  CD  ARG B  80     -24.871  71.843 122.524  1.00 51.01           C  
ATOM   2368  NE  ARG B  80     -24.872  73.289 122.729  1.00 50.28           N  
ATOM   2369  CZ  ARG B  80     -23.991  73.933 123.487  1.00 51.32           C  
ATOM   2370  NH1 ARG B  80     -23.037  73.261 124.115  1.00 52.05           N  
ATOM   2371  NH2 ARG B  80     -24.062  75.251 123.617  1.00 52.17           N  
ATOM   2372  N   ALA B  81     -25.988  68.140 123.262  1.00 53.74           N  
ATOM   2373  CA  ALA B  81     -24.833  67.366 123.695  1.00 57.18           C  
ATOM   2374  C   ALA B  81     -23.705  67.626 122.707  1.00 59.12           C  
ATOM   2375  O   ALA B  81     -23.655  67.019 121.638  1.00 59.76           O  
ATOM   2376  CB  ALA B  81     -25.174  65.881 123.728  1.00 57.01           C  
ATOM   2377  N   ASP B  82     -22.813  68.546 123.063  1.00 62.01           N  
ATOM   2378  CA  ASP B  82     -21.679  68.902 122.214  1.00 64.19           C  
ATOM   2379  C   ASP B  82     -22.086  69.644 120.941  1.00 64.91           C  
ATOM   2380  O   ASP B  82     -22.175  69.056 119.863  1.00 65.12           O  
ATOM   2381  CB  ASP B  82     -20.878  67.648 121.853  1.00 65.75           C  
ATOM   2382  CG  ASP B  82     -20.173  67.042 123.054  1.00 67.62           C  
ATOM   2383  OD1 ASP B  82     -19.280  67.711 123.618  1.00 68.58           O  
ATOM   2384  OD2 ASP B  82     -20.513  65.901 123.436  1.00 67.85           O  
ATOM   2385  N   ASP B  83     -22.323  70.945 121.084  1.00 66.02           N  
ATOM   2386  CA  ASP B  83     -22.708  71.819 119.977  1.00 65.94           C  
ATOM   2387  C   ASP B  83     -23.591  71.174 118.909  1.00 64.85           C  
ATOM   2388  O   ASP B  83     -23.346  71.322 117.711  1.00 65.65           O  
ATOM   2389  CB  ASP B  83     -21.452  72.412 119.327  1.00 68.12           C  
ATOM   2390  CG  ASP B  83     -20.724  73.383 120.245  1.00 69.65           C  
ATOM   2391  OD1 ASP B  83     -21.294  74.452 120.555  1.00 69.35           O  
ATOM   2392  OD2 ASP B  83     -19.585  73.075 120.661  1.00 70.96           O  
ATOM   2393  N   THR B  84     -24.624  70.466 119.355  1.00 62.56           N  
ATOM   2394  CA  THR B  84     -25.572  69.815 118.460  1.00 59.12           C  
ATOM   2395  C   THR B  84     -26.829  69.438 119.247  1.00 56.37           C  
ATOM   2396  O   THR B  84     -26.813  68.529 120.080  1.00 55.85           O  
ATOM   2397  CB  THR B  84     -24.959  68.553 117.803  1.00 60.03           C  
ATOM   2398  OG1 THR B  84     -25.920  67.963 116.919  1.00 60.10           O  
ATOM   2399  CG2 THR B  84     -24.544  67.536 118.858  1.00 60.44           C  
ATOM   2400  N   PHE B  85     -27.914  70.159 118.988  1.00 52.76           N  
ATOM   2401  CA  PHE B  85     -29.172  69.919 119.682  1.00 48.81           C  
ATOM   2402  C   PHE B  85     -29.957  68.720 119.179  1.00 47.09           C  
ATOM   2403  O   PHE B  85     -30.117  68.521 117.974  1.00 46.51           O  
ATOM   2404  CB  PHE B  85     -30.078  71.151 119.600  1.00 48.38           C  
ATOM   2405  CG  PHE B  85     -29.790  72.184 120.643  1.00 48.92           C  
ATOM   2406  CD1 PHE B  85     -28.787  73.127 120.453  1.00 48.97           C  
ATOM   2407  CD2 PHE B  85     -30.511  72.203 121.833  1.00 48.50           C  
ATOM   2408  CE1 PHE B  85     -28.508  74.075 121.434  1.00 48.31           C  
ATOM   2409  CE2 PHE B  85     -30.239  73.145 122.820  1.00 48.13           C  
ATOM   2410  CZ  PHE B  85     -29.235  74.082 122.620  1.00 47.78           C  
ATOM   2411  N   GLU B  86     -30.446  67.919 120.120  1.00 43.27           N  
ATOM   2412  CA  GLU B  86     -31.260  66.760 119.789  1.00 39.30           C  
ATOM   2413  C   GLU B  86     -32.544  67.364 119.240  1.00 36.73           C  
ATOM   2414  O   GLU B  86     -32.836  68.528 119.500  1.00 35.92           O  
ATOM   2415  CB  GLU B  86     -31.584  65.973 121.061  1.00 39.03           C  
ATOM   2416  CG  GLU B  86     -32.189  66.850 122.159  1.00 39.55           C  
ATOM   2417  CD  GLU B  86     -32.520  66.092 123.429  1.00 38.85           C  
ATOM   2418  OE1 GLU B  86     -31.744  65.193 123.818  1.00 37.58           O  
ATOM   2419  OE2 GLU B  86     -33.553  66.412 124.052  1.00 41.25           O  
ATOM   2420  N   ALA B  87     -33.299  66.592 118.473  1.00 34.43           N  
ATOM   2421  CA  ALA B  87     -34.565  67.087 117.961  1.00 33.94           C  
ATOM   2422  C   ALA B  87     -35.502  67.109 119.174  1.00 32.30           C  
ATOM   2423  O   ALA B  87     -35.244  66.420 120.165  1.00 31.79           O  
ATOM   2424  CB  ALA B  87     -35.098  66.145 116.892  1.00 35.43           C  
ATOM   2425  N   LEU B  88     -36.567  67.903 119.121  1.00 30.80           N  
ATOM   2426  CA  LEU B  88     -37.499  67.950 120.248  1.00 30.28           C  
ATOM   2427  C   LEU B  88     -38.280  66.639 120.308  1.00 29.89           C  
ATOM   2428  O   LEU B  88     -38.941  66.270 119.338  1.00 30.72           O  
ATOM   2429  CB  LEU B  88     -38.478  69.120 120.085  1.00 28.80           C  
ATOM   2430  CG  LEU B  88     -39.663  69.180 121.053  1.00 27.07           C  
ATOM   2431  CD1 LEU B  88     -39.176  69.296 122.485  1.00 24.49           C  
ATOM   2432  CD2 LEU B  88     -40.551  70.361 120.688  1.00 25.78           C  
ATOM   2433  N   ARG B  89     -38.183  65.920 121.427  1.00 28.16           N  
ATOM   2434  CA  ARG B  89     -38.931  64.671 121.587  1.00 28.23           C  
ATOM   2435  C   ARG B  89     -39.606  64.576 122.956  1.00 28.06           C  
ATOM   2436  O   ARG B  89     -38.937  64.537 123.979  1.00 26.99           O  
ATOM   2437  CB  ARG B  89     -38.033  63.444 121.399  1.00 29.48           C  
ATOM   2438  CG  ARG B  89     -38.771  62.111 121.619  1.00 30.25           C  
ATOM   2439  CD  ARG B  89     -37.956  60.908 121.152  1.00 31.75           C  
ATOM   2440  NE  ARG B  89     -36.722  60.730 121.919  1.00 32.54           N  
ATOM   2441  CZ  ARG B  89     -36.662  60.229 123.152  1.00 33.38           C  
ATOM   2442  NH1 ARG B  89     -37.769  59.844 123.773  1.00 34.05           N  
ATOM   2443  NH2 ARG B  89     -35.495  60.109 123.770  1.00 34.01           N  
ATOM   2444  N   ILE B  90     -40.934  64.538 122.960  1.00 27.34           N  
ATOM   2445  CA  ILE B  90     -41.697  64.415 124.199  1.00 27.45           C  
ATOM   2446  C   ILE B  90     -42.534  63.141 124.101  1.00 26.04           C  
ATOM   2447  O   ILE B  90     -43.379  63.024 123.214  1.00 26.73           O  
ATOM   2448  CB  ILE B  90     -42.680  65.591 124.392  1.00 27.55           C  
ATOM   2449  CG1 ILE B  90     -41.920  66.918 124.441  1.00 28.05           C  
ATOM   2450  CG2 ILE B  90     -43.483  65.382 125.678  1.00 26.04           C  
ATOM   2451  CD1 ILE B  90     -42.830  68.136 124.367  1.00 27.82           C  
ATOM   2452  N   GLU B  91     -42.319  62.195 125.009  1.00 25.79           N  
ATOM   2453  CA  GLU B  91     -43.093  60.960 124.976  1.00 25.28           C  
ATOM   2454  C   GLU B  91     -44.477  61.223 125.549  1.00 25.96           C  
ATOM   2455  O   GLU B  91     -44.623  61.951 126.528  1.00 25.58           O  
ATOM   2456  CB  GLU B  91     -42.399  59.864 125.781  1.00 26.68           C  
ATOM   2457  CG  GLU B  91     -41.082  59.402 125.192  1.00 28.64           C  
ATOM   2458  CD  GLU B  91     -41.209  58.982 123.739  1.00 31.14           C  
ATOM   2459  OE1 GLU B  91     -42.171  58.255 123.402  1.00 31.52           O  
ATOM   2460  OE2 GLU B  91     -40.340  59.375 122.932  1.00 32.10           O  
ATOM   2461  N   PRO B  92     -45.520  60.648 124.936  1.00 24.58           N  
ATOM   2462  CA  PRO B  92     -46.874  60.867 125.444  1.00 24.63           C  
ATOM   2463  C   PRO B  92     -47.135  60.063 126.709  1.00 23.58           C  
ATOM   2464  O   PRO B  92     -46.436  59.097 126.998  1.00 24.45           O  
ATOM   2465  CB  PRO B  92     -47.750  60.395 124.294  1.00 23.69           C  
ATOM   2466  CG  PRO B  92     -46.951  59.230 123.768  1.00 25.77           C  
ATOM   2467  CD  PRO B  92     -45.544  59.802 123.730  1.00 24.66           C  
ATOM   2468  N   PHE B  93     -48.142  60.480 127.464  1.00 23.67           N  
ATOM   2469  CA  PHE B  93     -48.506  59.769 128.670  1.00 23.41           C  
ATOM   2470  C   PHE B  93     -49.319  58.569 128.207  1.00 25.21           C  
ATOM   2471  O   PHE B  93     -49.765  58.513 127.060  1.00 23.91           O  
ATOM   2472  CB  PHE B  93     -49.369  60.652 129.575  1.00 21.83           C  
ATOM   2473  CG  PHE B  93     -48.672  61.887 130.075  1.00 21.05           C  
ATOM   2474  CD1 PHE B  93     -47.372  61.823 130.563  1.00 21.14           C  
ATOM   2475  CD2 PHE B  93     -49.338  63.108 130.105  1.00 23.05           C  
ATOM   2476  CE1 PHE B  93     -46.747  62.958 131.077  1.00 20.43           C  
ATOM   2477  CE2 PHE B  93     -48.722  64.248 130.619  1.00 20.56           C  
ATOM   2478  CZ  PHE B  93     -47.423  64.167 131.106  1.00 21.54           C  
ATOM   2479  N   SER B  94     -49.505  57.602 129.093  1.00 26.49           N  
ATOM   2480  CA  SER B  94     -50.286  56.421 128.762  1.00 28.30           C  
ATOM   2481  C   SER B  94     -51.708  56.887 128.463  1.00 31.19           C  
ATOM   2482  O   SER B  94     -52.006  58.077 128.546  1.00 32.19           O  
ATOM   2483  CB  SER B  94     -50.278  55.456 129.949  1.00 26.46           C  
ATOM   2484  OG  SER B  94     -50.589  56.152 131.147  1.00 22.10           O  
ATOM   2485  N   SER B  95     -52.589  55.958 128.127  1.00 37.41           N  
ATOM   2486  CA  SER B  95     -53.970  56.316 127.821  1.00 41.15           C  
ATOM   2487  C   SER B  95     -54.968  55.480 128.616  1.00 43.92           C  
ATOM   2488  O   SER B  95     -54.670  54.349 128.998  1.00 42.70           O  
ATOM   2489  CB  SER B  95     -54.221  56.158 126.323  1.00 41.39           C  
ATOM   2490  OG  SER B  95     -53.622  54.967 125.847  1.00 44.16           O  
ATOM   2491  N   PRO B  96     -56.166  56.036 128.879  1.00 48.03           N  
ATOM   2492  CA  PRO B  96     -57.240  55.375 129.630  1.00 51.27           C  
ATOM   2493  C   PRO B  96     -57.685  54.051 129.016  1.00 54.82           C  
ATOM   2494  O   PRO B  96     -57.499  53.818 127.823  1.00 55.16           O  
ATOM   2495  CB  PRO B  96     -58.349  56.425 129.647  1.00 50.90           C  
ATOM   2496  CG  PRO B  96     -58.111  57.189 128.382  1.00 51.27           C  
ATOM   2497  CD  PRO B  96     -56.614  57.352 128.389  1.00 49.41           C  
ATOM   2498  N   PRO B  97     -58.299  53.175 129.833  1.00 58.12           N  
ATOM   2499  CA  PRO B  97     -58.800  51.845 129.466  1.00 60.41           C  
ATOM   2500  C   PRO B  97     -59.802  51.746 128.319  1.00 62.26           C  
ATOM   2501  O   PRO B  97     -60.051  50.647 127.816  1.00 63.14           O  
ATOM   2502  CB  PRO B  97     -59.384  51.329 130.780  1.00 60.08           C  
ATOM   2503  CG  PRO B  97     -59.887  52.575 131.420  1.00 59.06           C  
ATOM   2504  CD  PRO B  97     -58.724  53.515 131.203  1.00 59.00           C  
ATOM   2505  N   GLU B  98     -60.376  52.878 127.913  1.00 63.91           N  
ATOM   2506  CA  GLU B  98     -61.360  52.905 126.825  1.00 65.98           C  
ATOM   2507  C   GLU B  98     -62.760  52.538 127.328  1.00 66.09           C  
ATOM   2508  O   GLU B  98     -63.595  53.457 127.485  1.00 65.37           O  
ATOM   2509  CB  GLU B  98     -60.937  51.931 125.712  1.00 67.11           C  
ATOM   2510  CG  GLU B  98     -61.983  51.671 124.641  1.00 69.15           C  
ATOM   2511  CD  GLU B  98     -62.226  52.874 123.757  1.00 70.28           C  
ATOM   2512  OE1 GLU B  98     -61.239  53.416 123.214  1.00 70.71           O  
ATOM   2513  OE2 GLU B  98     -63.400  53.271 123.598  1.00 71.24           O  
TER    2514      GLU B  98                                                      
END
MOLECULE T0424_94_177.pdb
ATOM    631  N   LEU    94     -30.472  64.408 127.901  1.00 31.32          
ATOM    632  CA  LEU    94     -30.886  64.905 129.205  1.00 32.87          
ATOM    633  C   LEU    94     -32.322  65.427 129.206  1.00 33.92          
ATOM    634  O   LEU    94     -32.903  65.626 130.272  1.00 35.10          
ATOM    635  CB  LEU    94     -29.910  65.974 129.722  1.00 33.73          
ATOM    636  CG  LEU    94     -28.424  65.627 129.839  1.00 32.67          
ATOM    637  CD1 LEU    94     -27.614  66.889 130.295  1.00 35.22          
ATOM    638  CD2 LEU    94     -28.201  64.465 130.777  1.00 36.22          
ATOM    639  N   ALA    95     -32.898  65.651 128.017  1.00 34.10          
ATOM    640  CA  ALA    95     -34.322  65.969 127.907  1.00 33.68          
ATOM    641  C   ALA    95     -35.155  64.865 128.454  1.00 33.59          
ATOM    642  O   ALA    95     -36.242  65.114 128.802  1.00 34.14          
ATOM    643  CB  ALA    95     -34.719  66.234 126.452  1.00 33.56          
ATOM    644  N   GLY    96     -34.670  63.617 128.470  1.00 34.66          
ATOM    645  CA  GLY    96     -35.368  62.512 129.122  1.00 34.70          
ATOM    646  C   GLY    96     -35.872  62.796 130.538  1.00 35.90          
ATOM    647  O   GLY    96     -36.962  62.417 130.865  1.00 34.43          
ATOM    648  N   PHE    97     -35.065  63.447 131.378  1.00 36.84          
ATOM    649  CA  PHE    97     -35.525  63.962 132.659  1.00 38.40          
ATOM    650  C   PHE    97     -36.748  64.897 132.567  1.00 39.55          
ATOM    651  O   PHE    97     -37.732  64.733 133.280  1.00 39.69          
ATOM    652  CB  PHE    97     -34.412  64.763 133.346  1.00 39.36          
ATOM    653  CG  PHE    97     -33.257  63.921 133.826  1.00 40.36          
ATOM    654  CD1 PHE    97     -33.431  63.017 134.884  1.00 39.09          
ATOM    655  CD2 PHE    97     -31.987  64.059 133.235  1.00 40.34          
ATOM    656  CE1 PHE    97     -32.368  62.255 135.343  1.00 39.78          
ATOM    657  CE2 PHE    97     -30.914  63.298 133.678  1.00 40.54          
ATOM    658  CZ  PHE    97     -31.100  62.395 134.751  1.00 40.74          
ATOM    659  N   LEU    98     -36.672  65.894 131.694  1.00 40.37          
ATOM    660  CA  LEU    98     -37.772  66.857 131.533  1.00 40.15          
ATOM    661  C   LEU    98     -39.030  66.214 130.937  1.00 39.84          
ATOM    662  O   LEU    98     -40.129  66.541 131.332  1.00 39.74          
ATOM    663  CB  LEU    98     -37.295  68.022 130.673  1.00 40.91          
ATOM    664  CG  LEU    98     -35.984  68.692 131.136  1.00 43.39          
ATOM    665  CD1 LEU    98     -35.953  70.177 130.823  1.00 43.56          
ATOM    666  CD2 LEU    98     -35.758  68.472 132.615  1.00 42.31          
ATOM    667  N   VAL    99     -38.852  65.269 130.009  1.00 39.53          
ATOM    668  CA  VAL    99     -39.957  64.488 129.435  1.00 39.36          
ATOM    669  C   VAL    99     -40.648  63.600 130.446  1.00 40.07          
ATOM    670  O   VAL    99     -41.878  63.367 130.373  1.00 39.79          
ATOM    671  CB  VAL    99     -39.471  63.564 128.251  1.00 39.09          
ATOM    672  CG1 VAL    99     -40.508  62.518 127.940  1.00 36.51          
ATOM    673  CG2 VAL    99     -39.104  64.394 127.002  1.00 36.11          
ATOM    674  N   ASP   100     -39.857  63.064 131.370  1.00 40.79          
ATOM    675  CA  ASP   100     -40.359  62.121 132.363  1.00 41.66          
ATOM    676  C   ASP   100     -40.960  62.854 133.571  1.00 42.67          
ATOM    677  O   ASP   100     -41.981  62.449 134.085  1.00 41.73          
ATOM    678  CB  ASP   100     -39.246  61.232 132.919  1.00 41.09          
ATOM    679  CG  ASP   100     -38.685  60.220 131.916  1.00 41.20          
ATOM    680  OD1 ASP   100     -39.215  59.974 130.789  1.00 38.12          
ATOM    681  OD2 ASP   100     -37.632  59.673 132.300  1.00 41.45          
ATOM    682  N   CYS   101     -40.278  63.902 134.029  1.00 44.72          
ATOM    683  CA  CYS   101     -40.550  64.551 135.332  1.00 46.08          
ATOM    684  C   CYS   101     -41.570  65.680 135.232  1.00 46.69          
ATOM    685  O   CYS   101     -41.947  66.110 134.135  1.00 47.06          
ATOM    686  CB  CYS   101     -39.250  65.098 135.940  1.00 46.62          
ATOM    687  SG  CYS   101     -37.867  63.848 136.081  1.00 50.78          
ATOM    688  N   SER   102     -42.043  66.144 136.372  1.00 46.92          
ATOM    689  CA  SER   102     -43.159  67.124 136.343  1.00 48.06          
ATOM    690  C   SER   102     -42.742  68.584 136.408  1.00 48.09          
ATOM    691  O   SER   102     -41.796  68.941 137.112  1.00 47.53          
ATOM    692  CB  SER   102     -44.225  66.827 137.396  1.00 47.32          
ATOM    693  OG  SER   102     -45.338  66.314 136.694  1.00 49.89          
ATOM    694  N   ALA   103     -43.453  69.415 135.642  1.00 48.78          
ATOM    695  CA  ALA   103     -43.223  70.842 135.693  1.00 50.33          
ATOM    696  C   ALA   103     -43.653  71.293 137.097  1.00 50.76          
ATOM    697  O   ALA   103     -44.521  70.648 137.704  1.00 50.85          
ATOM    698  CB  ALA   103     -44.022  71.585 134.574  1.00 50.30          
ATOM    699  N   PRO   104     -42.977  72.317 137.648  1.00 52.08          
ATOM    700  CA  PRO   104     -43.571  73.101 138.756  1.00 52.25          
ATOM    701  C   PRO   104     -44.711  73.997 138.257  1.00 52.65          
ATOM    702  O   PRO   104     -44.948  74.092 137.031  1.00 51.65          
ATOM    703  CB  PRO   104     -42.397  73.979 139.259  1.00 52.72          
ATOM    704  CG  PRO   104     -41.134  73.462 138.542  1.00 52.36          
ATOM    705  CD  PRO   104     -41.623  72.800 137.286  1.00 52.44          
ATOM    706  N   GLN   105     -45.404  74.682 139.177  1.00 53.39          
ATOM    707  CA  GLN   105     -46.384  75.662 138.729  1.00 53.36          
ATOM    708  C   GLN   105     -45.828  77.097 138.835  1.00 53.55          
ATOM    709  O   GLN   105     -46.276  77.958 139.619  1.00 54.37          
ATOM    710  CB  GLN   105     -47.743  75.426 139.387  1.00 54.93          
ATOM    711  CG  GLN   105     -48.659  74.561 138.496  1.00 56.49          
ATOM    712  CD  GLN   105     -48.902  75.173 137.103  1.00 59.08          
ATOM    713  OE1 GLN   105     -48.718  76.391 136.890  1.00 61.74          
ATOM    714  NE2 GLN   105     -49.322  74.326 136.150  1.00 57.67          
ATOM    715  N   LEU   106     -44.809  77.298 138.010  1.00 52.41          
ATOM    716  CA  LEU   106     -44.190  78.576 137.734  1.00 51.29          
ATOM    717  C   LEU   106     -45.162  79.445 136.912  1.00 50.32          
ATOM    718  O   LEU   106     -45.873  78.933 136.044  1.00 50.83          
ATOM    719  CB  LEU   106     -42.886  78.300 136.954  1.00 51.27          
ATOM    720  CG  LEU   106     -41.997  79.408 136.379  1.00 52.24          
ATOM    721  CD1 LEU   106     -41.282  80.194 137.495  1.00 53.40          
ATOM    722  CD2 LEU   106     -40.970  78.808 135.358  1.00 50.96          
ATOM    723  N   ASN   107     -45.214  80.739 137.221  1.00 48.24          
ATOM    724  CA  ASN   107     -45.879  81.725 136.403  1.00 47.41          
ATOM    725  C   ASN   107     -44.772  82.501 135.657  1.00 46.64          
ATOM    726  O   ASN   107     -43.835  82.973 136.303  1.00 46.31          
ATOM    727  CB  ASN   107     -46.645  82.650 137.358  1.00 48.25          
ATOM    728  CG  ASN   107     -47.477  83.705 136.649  1.00 47.27          
ATOM    729  OD1 ASN   107     -47.103  84.183 135.586  1.00 50.28          
ATOM    730  ND2 ASN   107     -48.607  84.053 137.227  1.00 38.82          
ATOM    731  N   VAL   108     -44.863  82.670 134.334  1.00 45.26          
ATOM    732  CA  VAL   108     -43.685  83.142 133.544  1.00 45.06          
ATOM    733  C   VAL   108     -43.683  84.642 133.065  1.00 44.11          
ATOM    734  O   VAL   108     -42.734  85.179 132.496  1.00 43.95          
ATOM    735  CB  VAL   108     -43.426  82.114 132.377  1.00 45.46          
ATOM    736  CG1 VAL   108     -44.108  82.505 131.042  1.00 44.93          
ATOM    737  CG2 VAL   108     -41.952  81.773 132.261  1.00 45.52          
ATOM    738  N   LYS   109     -44.726  85.329 133.426  1.00 43.87          
ATOM    739  CA  LYS   109     -45.102  86.585 132.812  1.00 42.70          
ATOM    740  C   LYS   109     -44.436  87.708 133.590  1.00 43.86          
ATOM    741  O   LYS   109     -44.481  87.722 134.863  1.00 44.65          
ATOM    742  CB  LYS   109     -46.620  86.697 132.913  1.00 42.23          
ATOM    743  CG  LYS   109     -47.374  85.326 133.160  1.00 38.08          
ATOM    744  CD  LYS   109     -48.900  85.477 133.340  1.00 39.19          
ATOM    745  CE  LYS   109     -49.295  86.274 134.621  1.00 29.34          
ATOM    746  NZ  LYS   109     -50.691  86.169 134.931  1.00 18.04          
ATOM    747  N   GLY   110     -43.756  88.655 132.948  1.00 44.07          
ATOM    748  CA  GLY   110     -42.920  88.525 131.831  1.00 43.27          
ATOM    749  C   GLY   110     -41.511  88.520 132.435  1.00 43.32          
ATOM    750  O   GLY   110     -40.797  89.554 132.525  1.00 41.80          
ATOM    751  N   MET   111     -41.210  87.329 132.954  1.00 43.59          
ATOM    752  CA  MET   111     -39.920  86.671 132.815  1.00 43.57          
ATOM    753  C   MET   111     -39.646  86.503 131.313  1.00 42.73          
ATOM    754  O   MET   111     -40.509  86.070 130.556  1.00 41.71          
ATOM    755  CB  MET   111     -39.927  85.248 133.412  1.00 44.40          
ATOM    756  CG  MET   111     -40.241  85.083 134.939  1.00 45.70          
ATOM    757  SD  MET   111     -40.165  83.323 135.375  1.00 45.54          
ATOM    758  CE  MET   111     -38.430  83.087 135.002  1.00 48.04          
ATOM    759  N   THR   112     -38.459  86.936 130.921  1.00 41.67          
ATOM    760  CA  THR   112     -37.744  86.516 129.741  1.00 41.00          
ATOM    761  C   THR   112     -37.883  84.995 129.458  1.00 40.91          
ATOM    762  O   THR   112     -38.128  84.184 130.395  1.00 39.90          
ATOM    763  CB  THR   112     -36.287  87.018 129.973  1.00 41.99          
ATOM    764  OG1 THR   112     -36.238  88.466 129.743  1.00 42.94          
ATOM    765  CG2 THR   112     -35.313  86.350 129.194  1.00 39.55          
ATOM    766  N   VAL   113     -37.794  84.613 128.171  1.00 39.19          
ATOM    767  CA  VAL   113     -37.938  83.192 127.803  1.00 38.99          
ATOM    768  C   VAL   113     -36.696  82.465 128.351  1.00 37.74          
ATOM    769  O   VAL   113     -36.825  81.404 128.904  1.00 35.89          
ATOM    770  CB  VAL   113     -38.263  82.983 126.259  1.00 38.81          
ATOM    771  CG1 VAL   113     -37.023  83.105 125.436  1.00 40.05          
ATOM    772  CG2 VAL   113     -38.950  81.625 125.988  1.00 39.74          
ATOM    773  N   LEU   114     -35.522  83.107 128.305  1.00 37.73          
ATOM    774  CA  LEU   114     -34.285  82.497 128.772  1.00 37.80          
ATOM    775  C   LEU   114     -34.320  82.209 130.247  1.00 38.39          
ATOM    776  O   LEU   114     -33.726  81.240 130.660  1.00 37.46          
ATOM    777  CB  LEU   114     -33.065  83.369 128.446  1.00 37.76          
ATOM    778  CG  LEU   114     -31.664  82.862 128.828  1.00 38.09          
ATOM    779  CD1 LEU   114     -31.431  81.365 128.458  1.00 42.92          
ATOM    780  CD2 LEU   114     -30.550  83.742 128.229  1.00 39.46          
ATOM    781  N   ASP   115     -34.982  83.090 131.036  1.00 38.71          
ATOM    782  CA  ASP   115     -35.118  82.929 132.498  1.00 38.65          
ATOM    783  C   ASP   115     -36.194  81.944 132.901  1.00 37.85          
ATOM    784  O   ASP   115     -35.982  81.173 133.823  1.00 38.57          
ATOM    785  CB  ASP   115     -35.376  84.286 133.206  1.00 39.19          
ATOM    786  CG  ASP   115     -34.157  85.156 133.233  1.00 43.54          
ATOM    787  OD1 ASP   115     -33.033  84.688 132.846  1.00 46.56          
ATOM    788  OD2 ASP   115     -34.319  86.335 133.651  1.00 51.72          
ATOM    789  N   ALA   116     -37.332  81.925 132.230  1.00 37.36          
ATOM    790  CA  ALA   116     -38.301  80.835 132.454  1.00 38.07          
ATOM    791  C   ALA   116     -37.730  79.423 132.036  1.00 38.99          
ATOM    792  O   ALA   116     -38.122  78.383 132.623  1.00 38.98          
ATOM    793  CB  ALA   116     -39.587  81.122 131.734  1.00 37.10          
ATOM    794  N   ALA   117     -36.798  79.383 131.076  1.00 38.86          
ATOM    795  CA  ALA   117     -36.160  78.084 130.707  1.00 39.89          
ATOM    796  C   ALA   117     -35.150  77.668 131.782  1.00 40.38          
ATOM    797  O   ALA   117     -35.124  76.492 132.188  1.00 40.63          
ATOM    798  CB  ALA   117     -35.469  78.156 129.324  1.00 38.98          
ATOM    799  N   LYS   118     -34.321  78.639 132.208  1.00 41.01          
ATOM    800  CA  LYS   118     -33.322  78.457 133.271  1.00 42.11          
ATOM    801  C   LYS   118     -34.018  77.916 134.505  1.00 43.02          
ATOM    802  O   LYS   118     -33.518  76.974 135.151  1.00 43.96          
ATOM    803  CB  LYS   118     -32.580  79.785 133.617  1.00 42.13          
ATOM    804  CG  LYS   118     -31.428  80.134 132.659  1.00 41.02          
ATOM    805  CD  LYS   118     -30.839  81.500 132.877  1.00 42.50          
ATOM    806  CE  LYS   118     -29.590  81.723 131.995  1.00 43.19          
ATOM    807  NZ  LYS   118     -29.103  83.173 132.155  1.00 41.67          
ATOM    808  N   LYS   119     -35.181  78.480 134.803  1.00 43.80          
ATOM    809  CA  LYS   119     -35.934  78.090 135.995  1.00 44.10          
ATOM    810  C   LYS   119     -36.285  76.642 135.900  1.00 43.70          
ATOM    811  O   LYS   119     -35.894  75.869 136.747  1.00 43.50          
ATOM    812  CB  LYS   119     -37.205  78.943 136.201  1.00 45.44          
ATOM    813  CG  LYS   119     -38.055  78.533 137.433  1.00 46.50          
ATOM    814  CD  LYS   119     -37.393  79.020 138.778  1.00 52.06          
ATOM    815  CE  LYS   119     -37.514  77.994 139.967  1.00 52.67          
ATOM    816  NZ  LYS   119     -38.758  78.151 140.813  1.00 52.88          
ATOM    817  N   LEU   120     -36.977  76.276 134.837  1.00 44.23          
ATOM    818  CA  LEU   120     -37.508  74.896 134.634  1.00 43.33          
ATOM    819  C   LEU   120     -36.463  73.796 134.554  1.00 42.75          
ATOM    820  O   LEU   120     -36.755  72.643 134.856  1.00 43.41          
ATOM    821  CB  LEU   120     -38.373  74.844 133.382  1.00 43.67          
ATOM    822  CG  LEU   120     -39.670  75.648 133.318  1.00 44.94          
ATOM    823  CD1 LEU   120     -40.015  75.948 131.830  1.00 43.41          
ATOM    824  CD2 LEU   120     -40.793  74.895 134.015  1.00 45.47          
ATOM    825  N   ALA   121     -35.259  74.138 134.105  1.00 42.53          
ATOM    826  CA  ALA   121     -34.130  73.190 134.025  1.00 42.11          
ATOM    827  C   ALA   121     -33.273  73.156 135.319  1.00 41.97          
ATOM    828  O   ALA   121     -32.373  72.329 135.447  1.00 40.35          
ATOM    829  CB  ALA   121     -33.250  73.562 132.857  1.00 41.60          
ATOM    830  N   ALA   122     -33.510  74.120 136.217  1.00 40.98          
ATOM    831  CA  ALA   122     -32.759  74.256 137.477  1.00 41.87          
ATOM    832  C   ALA   122     -32.574  72.959 138.288  1.00 41.61          
ATOM    833  O   ALA   122     -31.434  72.664 138.670  1.00 41.78          
ATOM    834  CB  ALA   122     -33.387  75.391 138.400  1.00 40.34          
ATOM    835  N   PRO   123     -33.672  72.192 138.545  1.00 42.01          
ATOM    836  CA  PRO   123     -33.565  70.900 139.267  1.00 42.75          
ATOM    837  C   PRO   123     -32.626  69.842 138.666  1.00 43.38          
ATOM    838  O   PRO   123     -32.307  68.854 139.327  1.00 44.75          
ATOM    839  CB  PRO   123     -35.008  70.356 139.251  1.00 43.04          
ATOM    840  CG  PRO   123     -35.880  71.511 138.977  1.00 40.40          
ATOM    841  CD  PRO   123     -35.068  72.462 138.141  1.00 41.52          
ATOM    842  N   TRP   124     -32.187  70.020 137.422  1.00 43.74          
ATOM    843  CA  TRP   124     -31.322  69.083 136.794  1.00 43.10          
ATOM    844  C   TRP   124     -29.997  69.711 136.519  1.00 44.01          
ATOM    845  O   TRP   124     -29.716  70.114 135.393  1.00 42.99          
ATOM    846  CB  TRP   124     -31.978  68.471 135.551  1.00 42.86          
ATOM    847  CG  TRP   124     -33.145  67.675 135.984  1.00 40.78          
ATOM    848  CD1 TRP   124     -33.137  66.395 136.468  1.00 41.48          
ATOM    849  CD2 TRP   124     -34.483  68.110 136.021  1.00 39.28          
ATOM    850  NE1 TRP   124     -34.413  66.012 136.797  1.00 40.34          
ATOM    851  CE2 TRP   124     -35.260  67.047 136.517  1.00 39.98          
ATOM    852  CE3 TRP   124     -35.124  69.293 135.637  1.00 40.65          
ATOM    853  CZ2 TRP   124     -36.648  67.140 136.680  1.00 41.02          
ATOM    854  CZ3 TRP   124     -36.499  69.381 135.806  1.00 41.19          
ATOM    855  CH2 TRP   124     -37.244  68.307 136.313  1.00 40.55          
ATOM    856  N   PRO   125     -29.139  69.762 137.570  1.00 45.64          
ATOM    857  CA  PRO   125     -27.870  70.448 137.445  1.00 45.93          
ATOM    858  C   PRO   125     -26.997  69.785 136.445  1.00 46.37          
ATOM    859  O   PRO   125     -26.049  70.413 135.948  1.00 46.58          
ATOM    860  CB  PRO   125     -27.278  70.399 138.869  1.00 46.66          
ATOM    861  CG  PRO   125     -27.981  69.307 139.540  1.00 46.96          
ATOM    862  CD  PRO   125     -29.340  69.236 138.933  1.00 45.91          
ATOM    863  N   GLN   126     -27.334  68.521 136.160  1.00 47.12          
ATOM    864  CA  GLN   126     -26.809  67.771 135.035  1.00 47.00          
ATOM    865  C   GLN   126     -26.909  68.582 133.696  1.00 47.32          
ATOM    866  O   GLN   126     -26.002  68.547 132.840  1.00 46.71          
ATOM    867  CB  GLN   126     -27.448  66.327 135.010  1.00 47.77          
ATOM    868  CG  GLN   126     -28.985  66.168 135.505  1.00 48.57          
ATOM    869  CD  GLN   126     -29.302  65.663 137.009  1.00 44.32          
ATOM    870  OE1 GLN   126     -28.717  66.048 137.940  1.00 46.03          
ATOM    871  NE2 GLN   126     -30.297  64.872 137.148  1.00 44.90          
ATOM    872  N   ILE   127     -27.979  69.366 133.549  1.00 47.63          
ATOM    873  CA  ILE   127     -28.061  70.396 132.492  1.00 47.76          
ATOM    874  C   ILE   127     -27.288  71.635 133.009  1.00 48.07          
ATOM    875  O   ILE   127     -27.789  72.407 133.818  1.00 47.78          
ATOM    876  CB  ILE   127     -29.560  70.743 132.119  1.00 47.78          
ATOM    877  CG1 ILE   127     -30.325  69.480 131.695  1.00 47.09          
ATOM    878  CG2 ILE   127     -29.624  71.797 131.003  1.00 46.93          
ATOM    879  CD  ILE   127     -31.862  69.582 131.763  1.00 47.45          
ATOM    880  N   LYS   128     -26.065  71.812 132.521  1.00 48.75          
ATOM    881  CA  LYS   128     -25.120  72.760 133.100  1.00 48.87          
ATOM    882  C   LYS   128     -25.129  74.162 132.479  1.00 48.31          
ATOM    883  O   LYS   128     -24.464  75.052 133.012  1.00 49.33          
ATOM    884  CB  LYS   128     -23.703  72.199 133.023  1.00 50.03          
ATOM    885  CG  LYS   128     -23.388  71.080 133.994  1.00 51.17          
ATOM    886  CD  LYS   128     -22.050  70.447 133.658  1.00 51.13          
ATOM    887  CE  LYS   128     -21.696  69.316 134.648  1.00 53.76          
ATOM    888  NZ  LYS   128     -20.685  68.320 134.094  1.00 53.98          
ATOM    889  N   ALA   129     -25.850  74.367 131.371  1.00 47.27          
ATOM    890  CA  ALA   129     -26.104  75.716 130.840  1.00 46.07          
ATOM    891  C   ALA   129     -27.409  75.745 130.084  1.00 45.68          
ATOM    892  O   ALA   129     -27.808  74.742 129.469  1.00 43.86          
ATOM    893  CB  ALA   129     -24.981  76.192 129.933  1.00 46.37          
ATOM    894  N   VAL   130     -28.086  76.896 130.157  1.00 44.12          
ATOM    895  CA  VAL   130     -29.263  77.178 129.340  1.00 44.02          
ATOM    896  C   VAL   130     -28.959  78.423 128.478  1.00 44.72          
ATOM    897  O   VAL   130     -28.543  79.460 128.989  1.00 45.08          
ATOM    898  CB  VAL   130     -30.505  77.382 130.206  1.00 43.13          
ATOM    899  CG1 VAL   130     -31.764  77.440 129.356  1.00 39.96          
ATOM    900  CG2 VAL   130     -30.582  76.277 131.252  1.00 40.18          
ATOM    901  N   VAL   131     -29.192  78.306 127.183  1.00 44.93          
ATOM    902  CA  VAL   131     -28.793  79.298 126.205  1.00 45.42          
ATOM    903  C   VAL   131     -30.030  79.632 125.369  1.00 45.75          
ATOM    904  O   VAL   131     -30.989  78.822 125.278  1.00 44.30          
ATOM    905  CB  VAL   131     -27.585  78.752 125.369  1.00 46.08          
ATOM    906  CG1 VAL   131     -27.494  79.360 123.963  1.00 48.27          
ATOM    907  CG2 VAL   131     -26.264  78.982 126.129  1.00 45.62          
ATOM    908  N   LEU   132     -30.048  80.858 124.832  1.00 46.00          
ATOM    909  CA  LEU   132     -31.140  81.319 123.968  1.00 46.49          
ATOM    910  C   LEU   132     -30.516  81.350 122.590  1.00 47.11          
ATOM    911  O   LEU   132     -29.404  81.861 122.391  1.00 47.20          
ATOM    912  CB  LEU   132     -31.750  82.672 124.411  1.00 46.61          
ATOM    913  CG  LEU   132     -32.940  83.301 123.642  1.00 44.73          
ATOM    914  CD1 LEU   132     -34.275  82.678 123.969  1.00 39.44          
ATOM    915  CD2 LEU   132     -33.014  84.840 123.863  1.00 46.67          
ATOM    916  N   LYS   133     -31.198  80.708 121.652  1.00 47.95          
ATOM    917  CA  LYS   133     -30.695  80.612 120.283  1.00 48.56          
ATOM    918  C   LYS   133     -31.656  81.439 119.411  1.00 48.77          
ATOM    919  O   LYS   133     -32.410  80.929 118.563  1.00 48.35          
ATOM    920  CB  LYS   133     -30.589  79.130 119.885  1.00 48.79          
ATOM    921  CG  LYS   133     -29.248  78.707 119.355  1.00 49.90          
ATOM    922  CD  LYS   133     -28.164  78.764 120.403  1.00 51.28          
ATOM    923  CE  LYS   133     -26.824  78.442 119.797  1.00 52.13          
ATOM    924  NZ  LYS   133     -26.748  76.998 119.425  1.00 52.63          
ATOM    925  N   ALA   134     -31.628  82.749 119.668  1.00 49.39          
ATOM    926  CA  ALA   134     -32.589  83.690 119.085  1.00 49.87          
ATOM    927  C   ALA   134     -32.058  85.143 119.188  1.00 50.83          
ATOM    928  O   ALA   134     -31.184  85.445 120.015  1.00 50.97          
ATOM    929  CB  ALA   134     -33.952  83.531 119.758  1.00 48.85          
ATOM    930  N   GLU   135     -32.554  86.030 118.329  1.00 51.95          
ATOM    931  CA  GLU   135     -32.065  87.403 118.300  1.00 53.09          
ATOM    932  C   GLU   135     -32.486  88.131 119.583  1.00 53.81          
ATOM    933  O   GLU   135     -31.697  88.862 120.217  1.00 53.87          
ATOM    934  CB  GLU   135     -32.619  88.146 117.080  1.00 53.66          
ATOM    935  CG  GLU   135     -31.982  87.753 115.720  1.00 56.72          
ATOM    936  CD  GLU   135     -30.635  88.448 115.438  1.00 59.74          
ATOM    937  OE1 GLU   135     -30.557  89.681 115.664  1.00 61.44          
ATOM    938  OE2 GLU   135     -29.671  87.759 114.974  1.00 60.19          
ATOM    939  N   ASN   136     -33.745  87.905 119.944  1.00 54.10          
ATOM    940  CA  ASN   136     -34.395  88.606 121.006  1.00 54.11          
ATOM    941  C   ASN   136     -34.900  87.657 122.071  1.00 53.84          
ATOM    942  O   ASN   136     -35.187  86.495 121.820  1.00 54.30          
ATOM    943  CB  ASN   136     -35.506  89.429 120.393  1.00 54.65          
ATOM    944  CG  ASN   136     -34.957  90.464 119.392  1.00 57.00          
ATOM    945  OD1 ASN   136     -34.323  91.464 119.794  1.00 58.44          
ATOM    946  ND2 ASN   136     -35.164  90.210 118.089  1.00 57.01          
ATOM    947  N   ASN   137     -34.994  88.174 123.280  1.00 53.24          
ATOM    948  CA  ASN   137     -35.226  87.376 124.458  1.00 52.32          
ATOM    949  C   ASN   137     -36.498  87.872 125.119  1.00 52.82          
ATOM    950  O   ASN   137     -36.456  88.587 126.164  1.00 52.03          
ATOM    951  CB  ASN   137     -34.020  87.533 125.363  1.00 52.07          
ATOM    952  CG  ASN   137     -34.135  86.738 126.615  1.00 50.83          
ATOM    953  OD1 ASN   137     -35.141  86.039 126.849  1.00 47.05          
ATOM    954  ND2 ASN   137     -33.106  86.841 127.454  1.00 49.01          
ATOM    955  N   PRO   138     -37.642  87.534 124.497  1.00 52.42          
ATOM    956  CA  PRO   138     -38.893  88.211 124.821  1.00 52.30          
ATOM    957  C   PRO   138     -39.328  87.955 126.241  1.00 51.98          
ATOM    958  O   PRO   138     -39.159  86.836 126.744  1.00 51.56          
ATOM    959  CB  PRO   138     -39.903  87.561 123.863  1.00 52.52          
ATOM    960  CG  PRO   138     -39.343  86.244 123.610  1.00 52.20          
ATOM    961  CD  PRO   138     -37.863  86.505 123.478  1.00 52.66          
ATOM    962  N   ALA   139     -39.870  89.007 126.861  1.00 51.66          
ATOM    963  CA  ALA   139     -40.711  88.881 128.047  1.00 50.96          
ATOM    964  C   ALA   139     -41.902  88.036 127.631  1.00 50.06          
ATOM    965  O   ALA   139     -42.499  88.273 126.601  1.00 50.30          
ATOM    966  CB  ALA   139     -41.163  90.267 128.569  1.00 50.90          
ATOM    967  N   LEU   140     -42.207  87.026 128.424  1.00 49.66          
ATOM    968  CA  LEU   140     -43.278  86.094 128.128  1.00 49.15          
ATOM    969  C   LEU   140     -44.588  86.691 128.508  1.00 49.75          
ATOM    970  O   LEU   140     -44.653  87.538 129.423  1.00 49.81          
ATOM    971  CB  LEU   140     -43.097  84.804 128.937  1.00 48.86          
ATOM    972  CG  LEU   140     -42.199  83.637 128.448  1.00 46.34          
ATOM    973  CD1 LEU   140     -42.354  83.399 126.920  1.00 42.72          
ATOM    974  CD2 LEU   140     -40.747  83.767 128.864  1.00 41.96          
ATOM    975  N   GLY   141     -45.636  86.243 127.831  1.00 50.37          
ATOM    976  CA  GLY   141     -47.001  86.615 128.146  1.00 51.04          
ATOM    977  C   GLY   141     -47.554  85.726 129.236  1.00 51.33          
ATOM    978  O   GLY   141     -46.819  85.243 130.074  1.00 51.56          
ATOM    979  N   LYS   142     -48.859  85.513 129.219  1.00 52.49          
ATOM    980  CA  LYS   142     -49.526  84.634 130.170  1.00 53.66          
ATOM    981  C   LYS   142     -49.550  83.203 129.663  1.00 54.43          
ATOM    982  O   LYS   142     -50.239  82.904 128.697  1.00 55.46          
ATOM    983  CB  LYS   142     -50.961  85.133 130.408  1.00 53.71          
ATOM    984  CG  LYS   142     -51.928  84.155 131.108  1.00 53.61          
ATOM    985  CD  LYS   142     -53.238  84.909 131.445  1.00 54.28          
ATOM    986  CE  LYS   142     -54.079  84.236 132.548  1.00 55.34          
ATOM    987  NZ  LYS   142     -55.125  85.190 133.141  1.00 53.75          
ATOM    988  N   ILE   143     -48.808  82.312 130.304  1.00 55.53          
ATOM    989  CA  ILE   143     -48.804  80.903 129.878  1.00 56.18          
ATOM    990  C   ILE   143     -49.408  80.027 130.984  1.00 57.50          
ATOM    991  O   ILE   143     -48.841  79.899 132.076  1.00 58.04          
ATOM    992  CB  ILE   143     -47.410  80.408 129.456  1.00 56.47          
ATOM    993  CG1 ILE   143     -46.854  81.252 128.300  1.00 55.69          
ATOM    994  CG2 ILE   143     -47.477  78.950 128.992  1.00 54.86          
ATOM    995  CD  ILE   143     -47.407  80.885 126.971  1.00 56.04          
ATOM    996  N   ASP   144     -50.589  79.477 130.681  1.00 58.48          
ATOM    997  CA  ASP   144     -51.377  78.666 131.595  1.00 58.74          
ATOM    998  C   ASP   144     -51.047  77.219 131.288  1.00 59.75          
ATOM    999  O   ASP   144     -51.443  76.702 130.236  1.00 60.47          
ATOM   1000  CB  ASP   144     -52.886  78.902 131.368  1.00 58.87          
ATOM   1001  CG  ASP   144     -53.512  79.842 132.385  1.00 59.00          
ATOM   1002  OD1 ASP   144     -53.044  79.876 133.545  1.00 60.52          
ATOM   1003  OD2 ASP   144     -54.501  80.531 132.031  1.00 57.39          
ATOM   1004  N   ILE   145     -50.322  76.576 132.200  1.00 60.31          
ATOM   1005  CA  ILE   145     -49.944  75.166 132.080  1.00 60.43          
ATOM   1006  C   ILE   145     -50.761  74.286 133.054  1.00 60.93          
ATOM   1007  O   ILE   145     -51.069  74.715 134.175  1.00 61.93          
ATOM   1008  CB  ILE   145     -48.407  74.969 132.305  1.00 60.88          
ATOM   1009  CG1 ILE   145     -47.846  75.996 133.290  1.00 59.56          
ATOM   1010  CG2 ILE   145     -47.643  75.040 130.930  1.00 61.16          
ATOM   1011  CD  ILE   145     -46.384  75.809 133.636  1.00 59.89          
ATOM   1012  N   GLU   146     -51.122  73.072 132.641  1.00 60.81          
ATOM   1013  CA  GLU   146     -51.909  72.166 133.510  1.00 60.96          
ATOM   1014  C   GLU   146     -51.009  71.194 134.329  1.00 60.57          
ATOM   1015  O   GLU   146     -49.988  70.737 133.827  1.00 60.80          
ATOM   1016  CB  GLU   146     -53.006  71.441 132.716  1.00 61.11          
ATOM   1017  CG  GLU   146     -52.580  70.916 131.336  1.00 62.49          
ATOM   1018  CD  GLU   146     -53.711  70.205 130.578  1.00 63.25          
ATOM   1019  OE1 GLU   146     -53.412  69.211 129.852  1.00 65.14          
ATOM   1020  OE2 GLU   146     -54.889  70.656 130.699  1.00 65.30          
ATOM   1021  N   PRO   147     -51.401  70.865 135.587  1.00 60.04          
ATOM   1022  CA  PRO   147     -50.441  70.366 136.631  1.00 59.24          
ATOM   1023  C   PRO   147     -49.634  69.080 136.336  1.00 58.69          
ATOM   1024  O   PRO   147     -48.431  68.991 136.689  1.00 59.18          
ATOM   1025  CB  PRO   147     -51.328  70.185 137.880  1.00 59.35          
ATOM   1026  CG  PRO   147     -52.592  71.023 137.596  1.00 59.88          
ATOM   1027  CD  PRO   147     -52.788  70.926 136.105  1.00 59.93          
ATOM   1028  N   GLY   148     -50.256  68.095 135.692  1.00 57.37          
ATOM   1029  CA  GLY   148     -49.506  66.911 135.222  1.00 55.91          
ATOM   1030  C   GLY   148     -48.594  67.148 134.010  1.00 54.75          
ATOM   1031  O   GLY   148     -48.077  66.200 133.424  1.00 53.38          
ATOM   1032  N   GLU   149     -48.408  68.407 133.607  1.00 53.32          
ATOM   1033  CA  GLU   149     -47.500  68.703 132.489  1.00 52.60          
ATOM   1034  C   GLU   149     -46.070  68.408 132.907  1.00 49.31          
ATOM   1035  O   GLU   149     -45.677  68.566 134.111  1.00 49.20          
ATOM   1036  CB  GLU   149     -47.660  70.139 131.915  1.00 52.19          
ATOM   1037  CG  GLU   149     -48.786  70.201 130.852  1.00 54.72          
ATOM   1038  CD  GLU   149     -48.742  71.407 129.903  1.00 55.39          
ATOM   1039  OE1 GLU   149     -48.753  72.582 130.353  1.00 58.89          
ATOM   1040  OE2 GLU   149     -48.757  71.155 128.680  1.00 60.76          
ATOM   1041  N   THR   150     -45.321  67.958 131.902  1.00 45.19          
ATOM   1042  CA  THR   150     -43.992  67.565 132.084  1.00 42.07          
ATOM   1043  C   THR   150     -43.217  68.842 131.964  1.00 41.31          
ATOM   1044  O   THR   150     -43.680  69.807 131.390  1.00 39.74          
ATOM   1045  CB  THR   150     -43.559  66.539 130.959  1.00 42.90          
ATOM   1046  OG1 THR   150     -43.569  67.170 129.657  1.00 40.69          
ATOM   1047  CG2 THR   150     -44.472  65.290 130.952  1.00 39.70          
ATOM   1048  N   VAL   151     -42.010  68.854 132.475  1.00 40.18          
ATOM   1049  CA  VAL   151     -41.131  70.005 132.249  1.00 39.70          
ATOM   1050  C   VAL   151     -41.011  70.330 130.727  1.00 38.66          
ATOM   1051  O   VAL   151     -41.045  71.521 130.319  1.00 37.43          
ATOM   1052  CB  VAL   151     -39.750  69.784 132.910  1.00 39.49          
ATOM   1053  CG1 VAL   151     -38.908  71.052 132.844  1.00 40.08          
ATOM   1054  CG2 VAL   151     -39.912  69.333 134.369  1.00 40.15          
ATOM   1055  N   TRP   152     -40.861  69.265 129.917  1.00 37.91          
ATOM   1056  CA  TRP   152     -40.750  69.360 128.466  1.00 36.89          
ATOM   1057  C   TRP   152     -41.972  70.007 127.810  1.00 35.94          
ATOM   1058  O   TRP   152     -41.827  70.971 127.094  1.00 35.39          
ATOM   1059  CB  TRP   152     -40.441  68.006 127.787  1.00 34.74          
ATOM   1060  CG  TRP   152     -39.829  68.290 126.487  1.00 32.36          
ATOM   1061  CD1 TRP   152     -40.449  68.267 125.250  1.00 31.54          
ATOM   1062  CD2 TRP   152     -38.534  68.813 126.272  1.00 32.04          
ATOM   1063  NE1 TRP   152     -39.592  68.724 124.291  1.00 31.01          
ATOM   1064  CE2 TRP   152     -38.401  69.044 124.871  1.00 29.15          
ATOM   1065  CE3 TRP   152     -37.432  69.042 127.108  1.00 29.95          
ATOM   1066  CZ2 TRP   152     -37.226  69.496 124.298  1.00 31.01          
ATOM   1067  CZ3 TRP   152     -36.276  69.504 126.548  1.00 31.50          
ATOM   1068  CH2 TRP   152     -36.158  69.715 125.152  1.00 30.71          
ATOM   1069  N   GLN   153     -43.150  69.464 128.044  1.00 36.92          
ATOM   1070  CA  GLN   153     -44.406  70.094 127.600  1.00 38.21          
ATOM   1071  C   GLN   153     -44.504  71.549 127.954  1.00 38.85          
ATOM   1072  O   GLN   153     -44.873  72.368 127.106  1.00 39.73          
ATOM   1073  CB  GLN   153     -45.597  69.403 128.220  1.00 38.30          
ATOM   1074  CG  GLN   153     -45.938  68.131 127.540  1.00 38.80          
ATOM   1075  CD  GLN   153     -46.993  67.336 128.295  1.00 39.06          
ATOM   1076  OE1 GLN   153     -47.016  67.343 129.521  1.00 41.00          
ATOM   1077  NE2 GLN   153     -47.842  66.611 127.563  1.00 38.45          
ATOM   1078  N   ALA   154     -44.140  71.878 129.197  1.00 38.88          
ATOM   1079  CA  ALA   154     -44.220  73.226 129.675  1.00 38.65          
ATOM   1080  C   ALA   154     -43.212  74.091 128.955  1.00 38.64          
ATOM   1081  O   ALA   154     -43.469  75.255 128.619  1.00 37.52          
ATOM   1082  CB  ALA   154     -43.956  73.277 131.230  1.00 39.17          
ATOM   1083  N   LEU   155     -42.042  73.526 128.732  1.00 37.76          
ATOM   1084  CA  LEU   155     -41.000  74.261 128.085  1.00 38.20          
ATOM   1085  C   LEU   155     -41.363  74.537 126.589  1.00 37.62          
ATOM   1086  O   LEU   155     -41.023  75.599 126.038  1.00 35.67          
ATOM   1087  CB  LEU   155     -39.726  73.433 128.181  1.00 38.96          
ATOM   1088  CG  LEU   155     -38.340  74.005 128.050  1.00 38.74          
ATOM   1089  CD1 LEU   155     -38.154  75.179 128.954  1.00 38.22          
ATOM   1090  CD2 LEU   155     -37.448  72.854 128.455  1.00 38.79          
ATOM   1091  N   THR   156     -42.049  73.579 125.978  1.00 37.91          
ATOM   1092  CA  THR   156     -42.426  73.649 124.570  1.00 39.28          
ATOM   1093  C   THR   156     -43.489  74.754 124.396  1.00 39.91          
ATOM   1094  O   THR   156     -43.328  75.671 123.582  1.00 39.56          
ATOM   1095  CB  THR   156     -42.943  72.275 124.075  1.00 39.40          
ATOM   1096  OG1 THR   156     -41.913  71.276 124.222  1.00 40.32          
ATOM   1097  CG2 THR   156     -43.414  72.344 122.597  1.00 37.44          
ATOM   1098  N   HSD   157     -44.506  74.700 125.253  1.00 41.29          
ATOM   1099  CA  HSD   157     -45.563  75.742 125.389  1.00 40.52          
ATOM   1100  C   HSD   157     -44.960  77.148 125.489  1.00 40.40          
ATOM   1101  O   HSD   157     -45.144  78.009 124.630  1.00 40.47          
ATOM   1102  CB  HSD   157     -46.370  75.403 126.629  1.00 42.29          
ATOM   1103  CG  HSD   157     -47.824  75.773 126.555  1.00 46.21          
ATOM   1104  ND1 HSD   157     -48.795  74.896 126.108  1.00 49.77          
ATOM   1105  CD2 HSD   157     -48.474  76.912 126.900  1.00 46.73          
ATOM   1106  CE1 HSD   157     -49.978  75.493 126.168  1.00 51.70          
ATOM   1107  NE2 HSD   157     -49.812  76.717 126.654  1.00 48.91          
ATOM   1108  N   ILE   158     -44.174  77.364 126.520  1.00 39.54          
ATOM   1109  CA  ILE   158     -43.512  78.617 126.731  1.00 38.46          
ATOM   1110  C   ILE   158     -42.707  79.077 125.507  1.00 37.00          
ATOM   1111  O   ILE   158     -42.830  80.226 125.019  1.00 35.33          
ATOM   1112  CB  ILE   158     -42.575  78.495 127.969  1.00 38.55          
ATOM   1113  CG1 ILE   158     -43.399  78.372 129.259  1.00 39.19          
ATOM   1114  CG2 ILE   158     -41.672  79.670 128.051  1.00 39.72          
ATOM   1115  CD  ILE   158     -42.637  77.673 130.405  1.00 39.44          
ATOM   1116  N   ALA   159     -41.855  78.178 125.038  1.00 35.87          
ATOM   1117  CA  ALA   159     -40.969  78.441 123.908  1.00 36.02          
ATOM   1118  C   ALA   159     -41.790  78.802 122.666  1.00 34.45          
ATOM   1119  O   ALA   159     -41.479  79.781 121.981  1.00 33.92          
ATOM   1120  CB  ALA   159     -40.046  77.145 123.618  1.00 35.86          
ATOM   1121  N   ASN   160     -42.849  78.034 122.438  1.00 34.51          
ATOM   1122  CA  ASN   160     -43.613  78.102 121.219  1.00 35.17          
ATOM   1123  C   ASN   160     -44.446  79.389 121.199  1.00 36.44          
ATOM   1124  O   ASN   160     -44.602  80.017 120.125  1.00 35.86          
ATOM   1125  CB  ASN   160     -44.474  76.837 121.014  1.00 35.63          
ATOM   1126  CG  ASN   160     -43.655  75.604 120.495  1.00 36.13          
ATOM   1127  OD1 ASN   160     -42.459  75.699 120.157  1.00 39.58          
ATOM   1128  ND2 ASN   160     -44.304  74.453 120.455  1.00 33.50          
ATOM   1129  N   SER   161     -44.866  79.845 122.405  1.00 36.15          
ATOM   1130  CA  SER   161     -45.554  81.128 122.601  1.00 35.46          
ATOM   1131  C   SER   161     -44.818  82.297 121.978  1.00 36.28          
ATOM   1132  O   SER   161     -45.426  83.324 121.646  1.00 37.39          
ATOM   1133  CB  SER   161     -45.710  81.447 124.122  1.00 35.38          
ATOM   1134  OG  SER   161     -44.568  82.200 124.583  1.00 32.69          
ATOM   1135  N   VAL   162     -43.504  82.202 121.922  1.00 36.46          
ATOM   1136  CA  VAL   162     -42.673  83.279 121.406  1.00 36.60          
ATOM   1137  C   VAL   162     -42.010  82.827 120.125  1.00 36.85          
ATOM   1138  O   VAL   162     -40.958  83.366 119.759  1.00 38.04          
ATOM   1139  CB  VAL   162     -41.593  83.742 122.399  1.00 36.81          
ATOM   1140  CG1 VAL   162     -42.120  84.930 123.261  1.00 36.35          
ATOM   1141  CG2 VAL   162     -41.109  82.571 123.273  1.00 36.48          
ATOM   1142  N   GLY   163     -42.637  81.866 119.448  1.00 36.83          
ATOM   1143  CA  GLY   163     -42.131  81.340 118.161  1.00 37.06          
ATOM   1144  C   GLY   163     -40.766  80.660 118.283  1.00 37.55          
ATOM   1145  O   GLY   163     -39.929  80.738 117.358  1.00 39.28          
ATOM   1146  N   LEU   164     -40.529  80.019 119.428  1.00 36.30          
ATOM   1147  CA  LEU   164     -39.276  79.301 119.664  1.00 34.93          
ATOM   1148  C   LEU   164     -39.552  77.827 119.978  1.00 33.23          
ATOM   1149  O   LEU   164     -40.697  77.377 119.979  1.00 32.15          
ATOM   1150  CB  LEU   164     -38.430  80.004 120.741  1.00 35.47          
ATOM   1151  CG  LEU   164     -38.075  81.498 120.526  1.00 36.01          
ATOM   1152  CD1 LEU   164     -37.096  82.084 121.621  1.00 32.99          
ATOM   1153  CD2 LEU   164     -37.478  81.714 119.146  1.00 35.69          
ATOM   1154  N   HSD   165     -38.482  77.056 120.178  1.00 32.10          
ATOM   1155  CA  HSD   165     -38.619  75.656 120.526  1.00 31.62          
ATOM   1156  C   HSD   165     -37.429  75.231 121.376  1.00 30.28          
ATOM   1157  O   HSD   165     -36.324  75.719 121.153  1.00 29.79          
ATOM   1158  CB  HSD   165     -38.681  74.807 119.202  1.00 30.88          
ATOM   1159  CG  HSD   165     -39.192  73.426 119.405  1.00 30.41          
ATOM   1160  ND1 HSD   165     -40.535  73.131 119.449  1.00 29.82          
ATOM   1161  CD2 HSD   165     -38.545  72.250 119.587  1.00 31.56          
ATOM   1162  CE1 HSD   165     -40.701  71.845 119.687  1.00 29.33          
ATOM   1163  NE2 HSD   165     -39.505  71.281 119.757  1.00 30.96          
ATOM   1164  N   PRO   166     -37.625  74.280 122.312  1.00 30.00          
ATOM   1165  CA  PRO   166     -36.509  73.764 123.090  1.00 30.28          
ATOM   1166  C   PRO   166     -35.787  72.569 122.455  1.00 30.15          
ATOM   1167  O   PRO   166     -36.433  71.732 121.835  1.00 27.70          
ATOM   1168  CB  PRO   166     -37.182  73.285 124.373  1.00 29.87          
ATOM   1169  CG  PRO   166     -38.484  72.805 123.934  1.00 30.07          
ATOM   1170  CD  PRO   166     -38.887  73.653 122.728  1.00 30.73          
ATOM   1171  N   TRP   167     -34.466  72.493 122.639  1.00 30.72          
ATOM   1172  CA  TRP   167     -33.748  71.235 122.417  1.00 31.72          
ATOM   1173  C   TRP   167     -32.515  71.189 123.247  1.00 32.15          
ATOM   1174  O   TRP   167     -32.037  72.226 123.675  1.00 29.50          
ATOM   1175  CB  TRP   167     -33.379  71.044 120.941  1.00 31.26          
ATOM   1176  CG  TRP   167     -32.440  72.074 120.371  1.00 31.67          
ATOM   1177  CD1 TRP   167     -31.100  71.991 120.304  1.00 31.39          
ATOM   1178  CD2 TRP   167     -32.792  73.329 119.752  1.00 31.95          
ATOM   1179  NE1 TRP   167     -30.578  73.119 119.711  1.00 32.32          
ATOM   1180  CE2 TRP   167     -31.604  73.939 119.349  1.00 29.37          
ATOM   1181  CE3 TRP   167     -34.003  73.982 119.512  1.00 29.78          
ATOM   1182  CZ2 TRP   167     -31.585  75.138 118.684  1.00 32.42          
ATOM   1183  CZ3 TRP   167     -33.997  75.130 118.860  1.00 30.03          
ATOM   1184  CH2 TRP   167     -32.812  75.727 118.453  1.00 31.64          
ATOM   1185  N   LEU   168     -31.985  69.977 123.414  1.00 31.88          
ATOM   1186  CA  LEU   168     -30.630  69.763 123.909  1.00 32.07          
ATOM   1187  C   LEU   168     -29.591  69.720 122.814  1.00 32.16          
ATOM   1188  O   LEU   168     -29.769  69.077 121.778  1.00 31.77          
ATOM   1189  CB  LEU   168     -30.531  68.448 124.728  1.00 33.02          
ATOM   1190  CG  LEU   168     -31.072  68.455 126.145  1.00 32.11          
ATOM   1191  CD1 LEU   168     -30.187  69.333 127.075  1.00 31.71          
ATOM   1192  CD2 LEU   168     -32.495  68.955 126.096  1.00 33.18          
ATOM   1193  N   GLU   169     -28.480  70.392 123.095  1.00 33.09          
ATOM   1194  CA  GLU   169     -27.297  70.352 122.289  1.00 34.11          
ATOM   1195  C   GLU   169     -26.418  69.195 122.690  1.00 32.63          
ATOM   1196  O   GLU   169     -26.570  68.632 123.762  1.00 32.76          
ATOM   1197  CB  GLU   169     -26.506  71.654 122.435  1.00 35.73          
ATOM   1198  CG  GLU   169     -27.307  72.852 122.012  1.00 41.78          
ATOM   1199  CD  GLU   169     -26.585  73.743 121.024  1.00 49.95          
ATOM   1200  OE1 GLU   169     -25.838  74.666 121.452  1.00 53.88          
ATOM   1201  OE2 GLU   169     -26.810  73.547 119.807  1.00 57.45          
ATOM   1202  N   PRO   170     -25.519  68.817 121.810  1.00 31.65          
ATOM   1203  CA  PRO   170     -24.605  67.724 122.055  1.00 32.58          
ATOM   1204  C   PRO   170     -23.891  67.695 123.425  1.00 32.35          
ATOM   1205  O   PRO   170     -23.740  66.614 124.027  1.00 32.03          
ATOM   1206  CB  PRO   170     -23.635  67.841 120.881  1.00 31.62          
ATOM   1207  CG  PRO   170     -24.494  68.300 119.782  1.00 30.98          
ATOM   1208  CD  PRO   170     -25.387  69.323 120.426  1.00 32.12          
ATOM   1209  N   ASP   171     -23.421  68.837 123.894  1.00 32.06          
ATOM   1210  CA  ASP   171     -22.757  68.891 125.194  1.00 32.67          
ATOM   1211  C   ASP   171     -23.691  68.959 126.392  1.00 31.95          
ATOM   1212  O   ASP   171     -23.216  69.175 127.470  1.00 32.48          
ATOM   1213  CB  ASP   171     -21.724  70.048 125.276  1.00 34.02          
ATOM   1214  CG  ASP   171     -22.351  71.432 125.304  1.00 35.15          
ATOM   1215  OD1 ASP   171     -23.597  71.583 125.243  1.00 37.32          
ATOM   1216  OD2 ASP   171     -21.534  72.389 125.320  1.00 43.55          
ATOM   1217  N   GLY   172     -25.004  68.818 126.209  1.00 31.43          
ATOM   1218  CA  GLY   172     -25.924  68.798 127.335  1.00 31.63          
ATOM   1219  C   GLY   172     -26.556  70.158 127.700  1.00 31.89          
ATOM   1220  O   GLY   172     -27.315  70.227 128.662  1.00 30.08          
ATOM   1221  N   THR   173     -26.247  71.214 126.936  1.00 32.65          
ATOM   1222  CA  THR   173     -26.887  72.551 127.114  1.00 33.39          
ATOM   1223  C   THR   173     -28.309  72.510 126.579  1.00 33.70          
ATOM   1224  O   THR   173     -28.561  71.994 125.487  1.00 32.21          
ATOM   1225  CB  THR   173     -26.106  73.635 126.323  1.00 33.52          
ATOM   1226  OG1 THR   173     -24.736  73.609 126.693  1.00 36.35          
ATOM   1227  CG2 THR   173     -26.641  75.020 126.525  1.00 34.69          
ATOM   1228  N   LEU   174     -29.248  73.034 127.373  1.00 33.64          
ATOM   1229  CA  LEU   174     -30.600  73.225 126.936  1.00 34.20          
ATOM   1230  C   LEU   174     -30.659  74.558 126.120  1.00 35.02          
ATOM   1231  O   LEU   174     -30.139  75.597 126.570  1.00 34.35          
ATOM   1232  CB  LEU   174     -31.513  73.252 128.148  1.00 33.97          
ATOM   1233  CG  LEU   174     -32.999  73.531 127.922  1.00 35.80          
ATOM   1234  CD1 LEU   174     -33.683  72.475 127.025  1.00 32.98          
ATOM   1235  CD2 LEU   174     -33.686  73.668 129.299  1.00 33.70          
ATOM   1236  N   VAL   175     -31.250  74.505 124.924  1.00 34.48          
ATOM   1237  CA  VAL   175     -31.397  75.678 124.085  1.00 34.67          
ATOM   1238  C   VAL   175     -32.884  75.926 123.990  1.00 35.50          
ATOM   1239  O   VAL   175     -33.639  74.974 123.968  1.00 35.14          
ATOM   1240  CB  VAL   175     -30.773  75.497 122.729  1.00 33.55          
ATOM   1241  CG1 VAL   175     -31.181  76.628 121.773  1.00 33.55          
ATOM   1242  CG2 VAL   175     -29.270  75.425 122.841  1.00 33.74          
ATOM   1243  N   VAL   176     -33.312  77.197 124.100  1.00 37.14          
ATOM   1244  CA  VAL   176     -34.637  77.626 123.579  1.00 37.35          
ATOM   1245  C   VAL   176     -34.275  78.560 122.464  1.00 37.18          
ATOM   1246  O   VAL   176     -33.380  79.418 122.604  1.00 38.43          
ATOM   1247  CB  VAL   176     -35.612  78.244 124.598  1.00 38.40          
ATOM   1248  CG1 VAL   176     -36.820  78.818 123.876  1.00 40.93          
ATOM   1249  CG2 VAL   176     -36.132  77.184 125.554  1.00 39.70          
ATOM   1250  N   GLY   177     -34.885  78.329 121.311  1.00 36.41          
ATOM   1251  CA  GLY   177     -34.430  78.992 120.109  1.00 36.42          
ATOM   1252  C   GLY   177     -35.118  78.567 118.833  1.00 36.01          
ATOM   1253  O   GLY   177     -36.227  78.056 118.836  1.00 35.78          
END
