
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   82 ( 1232),  selected   82 , name 2a02_A
# Molecule2: number of CA atoms   84 (  623),  selected   84 , name T0424_94_177.pdb
# PARAMETERS: 2a02_A.T0424_94_177.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     1_A      L      94           -
LGA    -       -      A      95           -
LGA    -       -      G      96           -
LGA    -       -      F      97           -
LGA    -       -      L      98           -
LGA    Q     2_A      V      99          5.661
LGA    E     3_A      D     100          2.899
LGA    W     4_A      C     101          2.616
LGA    -       -      S     102           -
LGA    T     5_A      A     103          3.952
LGA    L     6_A      P     104          1.860
LGA    D     7_A      Q     105          2.957
LGA    I     8_A      L     106          2.038
LGA    P     9_A      N     107          2.247
LGA    A    10_A      V     108          2.363
LGA    Q    11_A      K     109          1.721
LGA    S    12_A      G     110          2.262
LGA    -       -      M     111           -
LGA    -       -      T     112           -
LGA    M    13_A      V     113          3.020
LGA    N    14_A      L     114          3.972
LGA    S    15_A      D     115          3.381
LGA    A    16_A      A     116          1.673
LGA    L    17_A      A     117          1.644
LGA    Q    18_A      K     118          2.061
LGA    A    19_A      K     119          1.282
LGA    L    20_A      L     120          0.654
LGA    A    21_A      A     121          2.004
LGA    K    22_A      A     122          0.846
LGA    Q    23_A      P     123          2.933
LGA    T    24_A      W     124          4.066
LGA    D    25_A      P     125          3.749
LGA    -       -      Q     126           -
LGA    T    26_A      I     127          3.179
LGA    -       -      K     128           -
LGA    Q    27_A      A     129          3.353
LGA    L    28_A      V     130          2.008
LGA    L    29_A      V     131          0.965
LGA    Y    30_A      L     132          1.832
LGA    -       -      K     133           -
LGA    S    31_A      A     134           #
LGA    P    32_A      -       -           -
LGA    E    33_A      E     135           #
LGA    D    34_A      N     136          1.568
LGA    I    35_A      N     137          1.900
LGA    G    36_A      P     138          3.372
LGA    G    37_A      A     139          2.221
LGA    L    38_A      L     140          2.931
LGA    R    39_A      G     141          2.813
LGA    S    40_A      K     142           #
LGA    S    41_A      I     143          2.036
LGA    A    42_A      D     144          4.716
LGA    L    43_A      I     145          3.029
LGA    K    44_A      E     146          6.010
LGA    G    45_A      P     147          2.359
LGA    R    46_A      G     148          2.563
LGA    H    47_A      E     149          2.823
LGA    D    48_A      T     150          3.039
LGA    L    49_A      V     151          3.587
LGA    Q    50_A      W     152          3.019
LGA    S    51_A      Q     153          2.623
LGA    S    52_A      A     154          2.527
LGA    L    53_A      L     155          2.059
LGA    R    54_A      T     156          1.685
LGA    I    55_A      X     157          2.034
LGA    L    56_A      I     158          2.045
LGA    L    57_A      A     159          1.601
LGA    Q    58_A      N     160          1.818
LGA    G    59_A      S     161          2.307
LGA    T    60_A      V     162          1.485
LGA    G    61_A      G     163          1.453
LGA    L    62_A      L     164          1.572
LGA    R    63_A      X     165          3.015
LGA    Y    64_A      P     166          2.197
LGA    Q    65_A      W     167          1.913
LGA    I    66_A      L     168          2.588
LGA    D    67_A      -       -           -
LGA    G    68_A      E     169           #
LGA    -       -      P     170           -
LGA    -       -      D     171           -
LGA    N    69_A      G     172          3.958
LGA    T    70_A      T     173          2.315
LGA    V    71_A      L     174          1.459
LGA    T    72_A      V     175          0.905
LGA    V    73_A      V     176          1.607
LGA    T    74_A      G     177          1.988
LGA    A    75_A      -       -           -
LGA    S    76_A      -       -           -
LGA    A    77_A      -       -           -
LGA    A    78_A      -       -           -
LGA    A    79_A      -       -           -
LGA    K    80_A      -       -           -
LGA    D    81_A      -       -           -
LGA    G    82_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   82   84    5.0     67    2.69    13.43     51.626     2.406

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.488802 * X  +   0.251006 * Y  +  -0.835505 * Z  + -41.980778
  Y_new =   0.803584 * X  +   0.243261 * Y  +   0.543209 * Z  +  71.324402
  Z_new =   0.339595 * X  +  -0.936920 * Y  +  -0.082798 * Z  + 129.398239 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.658940    1.482653  [ DEG:   -95.0503     84.9497 ]
  Theta =  -0.346486   -2.795106  [ DEG:   -19.8522   -160.1478 ]
  Phi   =   1.024313   -2.117280  [ DEG:    58.6888   -121.3112 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2a02_A                                        
REMARK     2: T0424_94_177.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2a02_A.T0424_94_177.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   82   84   5.0   67   2.69   13.43  51.626
REMARK  ---------------------------------------------------------- 
MOLECULE 2a02_A
HEADER    MEMBRANE PROTEIN, METAL TRANSPORT       15-JUN-05   2A02              
TITLE     SOLUTION NMR STRUCTURE OF THE PERIPLASMIC SIGNALING DOMAIN            
TITLE    2 OF THE OUTER MEMBRANE IRON TRANSPORTER PUPA FROM                     
TITLE    3 PSEUDOMONAS PUTIDA.                                                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: FERRIC-PSEUDOBACTIN 358 RECEPTOR;                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: N-TERMINAL RESIDUES;                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS PUTIDA;                             
SOURCE   3 GENE: PUPA;                                                          
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21-DE3                                   
KEYWDS    MEMBRANE PROTEIN, METAL TRANSPORT, PROTEIN NMR                        
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    A.D.FERGUSON,C.A.AMEZCUA,Y.CHELLIAH,M.K.ROSEN,J.DEISENHOFER           
REVDAT   2   16-JAN-07 2A02    1       JRNL                                     
REVDAT   1   26-SEP-06 2A02    0                                                
JRNL        AUTH   A.D.FERGUSON,C.A.AMEZCUA,N.M.HALABI,Y.CHELLIAH,              
JRNL        AUTH 2 M.K.ROSEN,R.RANGANATHAN,J.DEISENHOFER                        
JRNL        TITL   SIGNAL TRANSDUCTION PATHWAY OF TONB-DEPENDENT                
JRNL        TITL 2 TRANSPORTERS.                                                
JRNL        REF    PROC.NATL.ACAD.SCI.USA        V.   2   513 2006              
JRNL        REFN   ASTM PNASA6  US ISSN 0027-8424                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2A02 A    2    82  UNP    P25184   PUPA_PSEPU      48    128             
SEQRES   1 A   82  SER GLN GLU TRP THR LEU ASP ILE PRO ALA GLN SER MET          
SEQRES   2 A   82  ASN SER ALA LEU GLN ALA LEU ALA LYS GLN THR ASP THR          
SEQRES   3 A   82  GLN LEU LEU TYR SER PRO GLU ASP ILE GLY GLY LEU ARG          
SEQRES   4 A   82  SER SER ALA LEU LYS GLY ARG HIS ASP LEU GLN SER SER          
SEQRES   5 A   82  LEU ARG ILE LEU LEU GLN GLY THR GLY LEU ARG TYR GLN          
SEQRES   6 A   82  ILE ASP GLY ASN THR VAL THR VAL THR ALA SER ALA ALA          
SEQRES   7 A   82  ALA LYS ASP GLY                                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   SER A   1     -42.914  57.144 133.285  1.00  2.75           N  
ATOM      2  CA  SER A   1     -43.292  58.244 134.199  1.00  2.38           C  
ATOM      3  C   SER A   1     -42.151  59.243 134.369  1.00  1.65           C  
ATOM      4  O   SER A   1     -41.978  59.820 135.441  1.00  1.91           O  
ATOM      5  CB  SER A   1     -43.697  57.668 135.556  1.00  2.96           C  
ATOM      6  OG  SER A   1     -44.745  56.722 135.409  1.00  3.75           O  
ATOM      7  H2  SER A   1     -42.089  56.632 133.656  1.00  3.11           H  
ATOM      8  HA  SER A   1     -44.138  58.762 133.772  1.00  2.90           H  
ATOM      9  HB2 SER A   1     -42.846  57.176 136.004  1.00  3.14           H  
ATOM     10  HB3 SER A   1     -44.036  58.465 136.201  1.00  3.26           H  
ATOM     11  HG  SER A   1     -45.348  56.793 136.162  1.00  4.16           H  
ATOM     12  H1  SER A   1     -43.704  56.481 133.190  1.00  3.11           H  
ATOM     13  H3  SER A   1     -42.679  57.524 132.343  1.00  3.03           H  
ATOM     14  N   GLN A   2     -41.383  59.458 133.305  1.00  1.37           N  
ATOM     15  CA  GLN A   2     -40.280  60.405 133.344  1.00  0.95           C  
ATOM     16  C   GLN A   2     -40.799  61.824 133.148  1.00  0.75           C  
ATOM     17  O   GLN A   2     -40.462  62.504 132.177  1.00  0.86           O  
ATOM     18  CB  GLN A   2     -39.220  60.078 132.286  1.00  1.47           C  
ATOM     19  CG  GLN A   2     -38.439  58.799 132.559  1.00  2.07           C  
ATOM     20  CD  GLN A   2     -39.096  57.552 131.994  1.00  2.71           C  
ATOM     21  OE1 GLN A   2     -40.319  57.467 131.876  1.00  3.23           O  
ATOM     22  NE2 GLN A   2     -38.284  56.574 131.641  1.00  3.34           N  
ATOM     23  H   GLN A   2     -41.568  58.974 132.469  1.00  1.92           H  
ATOM     24  HA  GLN A   2     -39.827  60.338 134.323  1.00  1.00           H  
ATOM     25  HB2 GLN A   2     -39.709  59.974 131.328  1.00  1.90           H  
ATOM     26  HB3 GLN A   2     -38.519  60.897 132.234  1.00  1.94           H  
ATOM     27  HG2 GLN A   2     -37.456  58.892 132.118  1.00  2.57           H  
ATOM     28  HG3 GLN A   2     -38.337  58.679 133.628  1.00  2.46           H  
ATOM     29 HE21 GLN A   2     -37.319  56.705 131.762  1.00  3.46           H  
ATOM     30 HE22 GLN A   2     -38.680  55.751 131.271  1.00  3.98           H  
ATOM     31  N   GLU A   3     -41.634  62.253 134.076  1.00  0.57           N  
ATOM     32  CA  GLU A   3     -42.218  63.577 134.045  1.00  0.47           C  
ATOM     33  C   GLU A   3     -42.048  64.218 135.411  1.00  0.42           C  
ATOM     34  O   GLU A   3     -41.739  63.534 136.389  1.00  0.50           O  
ATOM     35  CB  GLU A   3     -43.696  63.506 133.656  1.00  0.58           C  
ATOM     36  CG  GLU A   3     -43.928  62.929 132.268  1.00  0.70           C  
ATOM     37  CD  GLU A   3     -45.389  62.900 131.876  1.00  1.26           C  
ATOM     38  OE1 GLU A   3     -46.091  61.936 132.251  1.00  1.35           O  
ATOM     39  OE2 GLU A   3     -45.843  63.849 131.201  1.00  1.99           O  
ATOM     40  H   GLU A   3     -41.852  61.656 134.826  1.00  0.59           H  
ATOM     41  HA  GLU A   3     -41.681  64.164 133.314  1.00  0.51           H  
ATOM     42  HB2 GLU A   3     -44.217  62.889 134.374  1.00  0.67           H  
ATOM     43  HB3 GLU A   3     -44.112  64.502 133.683  1.00  0.63           H  
ATOM     44  HG2 GLU A   3     -43.392  63.529 131.548  1.00  0.94           H  
ATOM     45  HG3 GLU A   3     -43.546  61.917 132.244  1.00  0.91           H  
ATOM     46  N   TRP A   4     -42.269  65.513 135.493  1.00  0.36           N  
ATOM     47  CA  TRP A   4     -41.984  66.247 136.714  1.00  0.38           C  
ATOM     48  C   TRP A   4     -43.147  67.150 137.067  1.00  0.34           C  
ATOM     49  O   TRP A   4     -43.982  67.457 136.216  1.00  0.34           O  
ATOM     50  CB  TRP A   4     -40.706  67.076 136.554  1.00  0.45           C  
ATOM     51  CG  TRP A   4     -39.473  66.247 136.351  1.00  0.57           C  
ATOM     52  CD1 TRP A   4     -38.669  65.721 137.322  1.00  1.00           C  
ATOM     53  CD2 TRP A   4     -38.908  65.841 135.099  1.00  0.51           C  
ATOM     54  NE1 TRP A   4     -37.639  65.016 136.750  1.00  1.17           N  
ATOM     55  CE2 TRP A   4     -37.764  65.075 135.388  1.00  0.84           C  
ATOM     56  CE3 TRP A   4     -39.259  66.051 133.762  1.00  0.53           C  
ATOM     57  CZ2 TRP A   4     -36.970  64.520 134.389  1.00  0.89           C  
ATOM     58  CZ3 TRP A   4     -38.468  65.498 132.772  1.00  0.60           C  
ATOM     59  CH2 TRP A   4     -37.336  64.739 133.089  1.00  0.65           C  
ATOM     60  H   TRP A   4     -42.688  65.981 134.733  1.00  0.36           H  
ATOM     61  HA  TRP A   4     -41.845  65.529 137.508  1.00  0.47           H  
ATOM     62  HB2 TRP A   4     -40.814  67.726 135.699  1.00  0.55           H  
ATOM     63  HB3 TRP A   4     -40.563  67.677 137.441  1.00  0.63           H  
ATOM     64  HD1 TRP A   4     -38.831  65.848 138.383  1.00  1.21           H  
ATOM     65  HE1 TRP A   4     -36.927  64.542 137.239  1.00  1.52           H  
ATOM     66  HE3 TRP A   4     -40.129  66.634 133.497  1.00  0.73           H  
ATOM     67  HZ2 TRP A   4     -36.092  63.933 134.617  1.00  1.20           H  
ATOM     68  HZ3 TRP A   4     -38.722  65.649 131.734  1.00  0.83           H  
ATOM     69  HH2 TRP A   4     -36.750  64.330 132.283  1.00  0.73           H  
ATOM     70  N   THR A   5     -43.198  67.567 138.323  1.00  0.37           N  
ATOM     71  CA  THR A   5     -44.183  68.535 138.754  1.00  0.39           C  
ATOM     72  C   THR A   5     -43.542  69.919 138.725  1.00  0.35           C  
ATOM     73  O   THR A   5     -42.772  70.299 139.613  1.00  0.44           O  
ATOM     74  CB  THR A   5     -44.759  68.197 140.156  1.00  0.55           C  
ATOM     75  OG1 THR A   5     -45.651  69.231 140.588  1.00  1.13           O  
ATOM     76  CG2 THR A   5     -43.658  67.996 141.189  1.00  1.11           C  
ATOM     77  H   THR A   5     -42.533  67.241 138.963  1.00  0.40           H  
ATOM     78  HA  THR A   5     -44.994  68.516 138.038  1.00  0.39           H  
ATOM     79  HB  THR A   5     -45.320  67.275 140.076  1.00  0.80           H  
ATOM     80  HG1 THR A   5     -46.567  68.907 140.548  1.00  1.56           H  
ATOM     81 HG21 THR A   5     -43.081  68.905 141.279  1.00  1.58           H  
ATOM     82 HG22 THR A   5     -43.014  67.188 140.874  1.00  1.82           H  
ATOM     83 HG23 THR A   5     -44.101  67.754 142.144  1.00  1.51           H  
ATOM     84  N   LEU A   6     -43.831  70.654 137.668  1.00  0.30           N  
ATOM     85  CA  LEU A   6     -43.145  71.903 137.400  1.00  0.34           C  
ATOM     86  C   LEU A   6     -43.795  73.069 138.117  1.00  0.42           C  
ATOM     87  O   LEU A   6     -44.989  73.044 138.426  1.00  0.75           O  
ATOM     88  CB  LEU A   6     -43.110  72.178 135.897  1.00  0.42           C  
ATOM     89  CG  LEU A   6     -42.455  71.087 135.053  1.00  0.47           C  
ATOM     90  CD1 LEU A   6     -42.446  71.490 133.590  1.00  0.66           C  
ATOM     91  CD2 LEU A   6     -41.040  70.811 135.539  1.00  0.53           C  
ATOM     92  H   LEU A   6     -44.531  70.347 137.049  1.00  0.32           H  
ATOM     93  HA  LEU A   6     -42.130  71.802 137.755  1.00  0.38           H  
ATOM     94  HB2 LEU A   6     -44.126  72.310 135.555  1.00  0.48           H  
ATOM     95  HB3 LEU A   6     -42.571  73.100 135.733  1.00  0.50           H  
ATOM     96  HG  LEU A   6     -43.025  70.175 135.146  1.00  0.45           H  
ATOM     97 HD11 LEU A   6     -43.460  71.638 133.251  1.00  1.26           H  
ATOM     98 HD12 LEU A   6     -41.981  70.711 133.006  1.00  1.08           H  
ATOM     99 HD13 LEU A   6     -41.888  72.408 133.473  1.00  1.28           H  
ATOM    100 HD21 LEU A   6     -40.447  71.712 135.452  1.00  1.17           H  
ATOM    101 HD22 LEU A   6     -40.596  70.032 134.940  1.00  1.15           H  
ATOM    102 HD23 LEU A   6     -41.066  70.500 136.573  1.00  1.14           H  
ATOM    103  N   ASP A   7     -42.984  74.073 138.386  1.00  0.38           N  
ATOM    104  CA  ASP A   7     -43.450  75.343 138.915  1.00  0.44           C  
ATOM    105  C   ASP A   7     -42.848  76.453 138.070  1.00  0.39           C  
ATOM    106  O   ASP A   7     -41.683  76.811 138.242  1.00  0.46           O  
ATOM    107  CB  ASP A   7     -43.032  75.501 140.376  1.00  0.58           C  
ATOM    108  CG  ASP A   7     -43.468  76.826 140.969  1.00  1.30           C  
ATOM    109  OD1 ASP A   7     -44.660  76.965 141.315  1.00  1.67           O  
ATOM    110  OD2 ASP A   7     -42.628  77.745 141.065  1.00  2.12           O  
ATOM    111  H   ASP A   7     -42.026  73.952 138.239  1.00  0.56           H  
ATOM    112  HA  ASP A   7     -44.528  75.374 138.836  1.00  0.47           H  
ATOM    113  HB2 ASP A   7     -43.471  74.706 140.959  1.00  1.11           H  
ATOM    114  HB3 ASP A   7     -41.956  75.439 140.442  1.00  1.09           H  
ATOM    115  N   ILE A   8     -43.627  76.950 137.125  1.00  0.35           N  
ATOM    116  CA  ILE A   8     -43.128  77.894 136.134  1.00  0.32           C  
ATOM    117  C   ILE A   8     -43.848  79.233 136.244  1.00  0.30           C  
ATOM    118  O   ILE A   8     -45.080  79.282 136.224  1.00  0.35           O  
ATOM    119  CB  ILE A   8     -43.307  77.329 134.705  1.00  0.37           C  
ATOM    120  CG1 ILE A   8     -42.518  76.026 134.542  1.00  0.52           C  
ATOM    121  CG2 ILE A   8     -42.872  78.345 133.660  1.00  0.44           C  
ATOM    122  CD1 ILE A   8     -41.030  76.174 134.791  1.00  0.91           C  
ATOM    123  H   ILE A   8     -44.569  76.688 137.090  1.00  0.40           H  
ATOM    124  HA  ILE A   8     -42.072  78.042 136.311  1.00  0.32           H  
ATOM    125  HB  ILE A   8     -44.355  77.125 134.553  1.00  0.40           H  
ATOM    126 HG12 ILE A   8     -42.897  75.296 135.240  1.00  1.38           H  
ATOM    127 HG13 ILE A   8     -42.650  75.656 133.536  1.00  1.18           H  
ATOM    128 HG21 ILE A   8     -43.470  79.238 133.758  1.00  1.07           H  
ATOM    129 HG22 ILE A   8     -43.005  77.925 132.674  1.00  1.10           H  
ATOM    130 HG23 ILE A   8     -41.833  78.590 133.812  1.00  1.18           H  
ATOM    131 HD11 ILE A   8     -40.620  76.900 134.102  1.00  1.56           H  
ATOM    132 HD12 ILE A   8     -40.543  75.221 134.640  1.00  1.57           H  
ATOM    133 HD13 ILE A   8     -40.866  76.506 135.805  1.00  1.54           H  
ATOM    134  N   PRO A   9     -43.082  80.329 136.388  1.00  0.26           N  
ATOM    135  CA  PRO A   9     -43.632  81.686 136.418  1.00  0.26           C  
ATOM    136  C   PRO A   9     -44.286  82.081 135.094  1.00  0.27           C  
ATOM    137  O   PRO A   9     -43.916  81.590 134.026  1.00  0.32           O  
ATOM    138  CB  PRO A   9     -42.406  82.573 136.690  1.00  0.29           C  
ATOM    139  CG  PRO A   9     -41.369  81.651 137.224  1.00  0.35           C  
ATOM    140  CD  PRO A   9     -41.622  80.332 136.560  1.00  0.29           C  
ATOM    141  HA  PRO A   9     -44.348  81.805 137.219  1.00  0.29           H  
ATOM    142  HB2 PRO A   9     -42.083  83.039 135.769  1.00  0.30           H  
ATOM    143  HB3 PRO A   9     -42.663  83.335 137.411  1.00  0.34           H  
ATOM    144  HG2 PRO A   9     -40.384  82.015 136.970  1.00  0.46           H  
ATOM    145  HG3 PRO A   9     -41.472  81.558 138.296  1.00  0.46           H  
ATOM    146  HD2 PRO A   9     -41.117  80.289 135.607  1.00  0.37           H  
ATOM    147  HD3 PRO A   9     -41.304  79.520 137.197  1.00  0.36           H  
ATOM    148  N   ALA A  10     -45.242  82.990 135.179  1.00  0.30           N  
ATOM    149  CA  ALA A  10     -45.979  83.465 134.013  1.00  0.33           C  
ATOM    150  C   ALA A  10     -45.591  84.900 133.711  1.00  0.35           C  
ATOM    151  O   ALA A  10     -46.318  85.645 133.047  1.00  0.43           O  
ATOM    152  CB  ALA A  10     -47.478  83.354 134.250  1.00  0.41           C  
ATOM    153  H   ALA A  10     -45.452  83.368 136.061  1.00  0.37           H  
ATOM    154  HA  ALA A  10     -45.719  82.844 133.169  1.00  0.35           H  
ATOM    155  HB1 ALA A  10     -47.753  83.968 135.095  1.00  0.99           H  
ATOM    156  HB2 ALA A  10     -47.736  82.325 134.452  1.00  1.11           H  
ATOM    157  HB3 ALA A  10     -48.007  83.691 133.371  1.00  1.19           H  
ATOM    158  N   GLN A  11     -44.433  85.274 134.219  1.00  0.34           N  
ATOM    159  CA  GLN A  11     -43.895  86.606 134.039  1.00  0.40           C  
ATOM    160  C   GLN A  11     -42.911  86.597 132.873  1.00  0.35           C  
ATOM    161  O   GLN A  11     -43.075  85.814 131.937  1.00  0.37           O  
ATOM    162  CB  GLN A  11     -43.228  87.060 135.341  1.00  0.53           C  
ATOM    163  CG  GLN A  11     -42.158  86.101 135.842  1.00  0.96           C  
ATOM    164  CD  GLN A  11     -41.727  86.384 137.269  1.00  0.90           C  
ATOM    165  OE1 GLN A  11     -42.512  86.862 138.091  1.00  1.61           O  
ATOM    166  NE2 GLN A  11     -40.474  86.089 137.569  1.00  0.90           N  
ATOM    167  H   GLN A  11     -43.904  84.618 134.717  1.00  0.34           H  
ATOM    168  HA  GLN A  11     -44.714  87.269 133.804  1.00  0.50           H  
ATOM    169  HB2 GLN A  11     -42.770  88.026 135.182  1.00  1.16           H  
ATOM    170  HB3 GLN A  11     -43.985  87.152 136.108  1.00  1.02           H  
ATOM    171  HG2 GLN A  11     -42.545  85.095 135.796  1.00  1.53           H  
ATOM    172  HG3 GLN A  11     -41.293  86.183 135.201  1.00  1.66           H  
ATOM    173 HE21 GLN A  11     -39.904  85.719 136.863  1.00  1.35           H  
ATOM    174 HE22 GLN A  11     -40.165  86.236 138.494  1.00  1.03           H  
ATOM    175  N   SER A  12     -41.911  87.463 132.921  1.00  0.38           N  
ATOM    176  CA  SER A  12     -40.895  87.518 131.880  1.00  0.40           C  
ATOM    177  C   SER A  12     -40.262  86.138 131.643  1.00  0.36           C  
ATOM    178  O   SER A  12     -39.876  85.427 132.579  1.00  0.34           O  
ATOM    179  CB  SER A  12     -39.832  88.542 132.268  1.00  0.50           C  
ATOM    180  OG  SER A  12     -40.423  89.802 132.559  1.00  1.30           O  
ATOM    181  H   SER A  12     -41.855  88.090 133.675  1.00  0.43           H  
ATOM    182  HA  SER A  12     -41.376  87.842 130.970  1.00  0.46           H  
ATOM    183  HB2 SER A  12     -39.301  88.199 133.143  1.00  1.00           H  
ATOM    184  HB3 SER A  12     -39.137  88.667 131.450  1.00  1.13           H  
ATOM    185  HG  SER A  12     -40.217  90.427 131.846  1.00  1.65           H  
ATOM    186  N   MET A  13     -40.199  85.776 130.360  1.00  0.42           N  
ATOM    187  CA  MET A  13     -39.699  84.481 129.891  1.00  0.46           C  
ATOM    188  C   MET A  13     -38.346  84.122 130.495  1.00  0.42           C  
ATOM    189  O   MET A  13     -38.066  82.948 130.750  1.00  0.45           O  
ATOM    190  CB  MET A  13     -39.588  84.510 128.361  1.00  0.61           C  
ATOM    191  CG  MET A  13     -39.169  83.185 127.742  1.00  0.68           C  
ATOM    192  SD  MET A  13     -40.494  81.966 127.744  1.00  1.29           S  
ATOM    193  CE  MET A  13     -41.653  82.723 126.609  1.00  1.00           C  
ATOM    194  H   MET A  13     -40.532  86.413 129.684  1.00  0.47           H  
ATOM    195  HA  MET A  13     -40.418  83.727 130.171  1.00  0.47           H  
ATOM    196  HB2 MET A  13     -40.548  84.784 127.951  1.00  1.02           H  
ATOM    197  HB3 MET A  13     -38.862  85.258 128.081  1.00  0.95           H  
ATOM    198  HG2 MET A  13     -38.865  83.362 126.723  1.00  1.20           H  
ATOM    199  HG3 MET A  13     -38.334  82.789 128.302  1.00  1.38           H  
ATOM    200  HE1 MET A  13     -42.517  82.087 126.497  1.00  1.45           H  
ATOM    201  HE2 MET A  13     -41.178  82.856 125.648  1.00  1.50           H  
ATOM    202  HE3 MET A  13     -41.959  83.686 126.993  1.00  1.38           H  
ATOM    203  N   ASN A  14     -37.510  85.134 130.719  1.00  0.41           N  
ATOM    204  CA  ASN A  14     -36.174  84.928 131.281  1.00  0.45           C  
ATOM    205  C   ASN A  14     -36.246  84.215 132.628  1.00  0.41           C  
ATOM    206  O   ASN A  14     -35.366  83.426 132.970  1.00  0.47           O  
ATOM    207  CB  ASN A  14     -35.426  86.260 131.442  1.00  0.52           C  
ATOM    208  CG  ASN A  14     -36.033  87.186 132.485  1.00  1.32           C  
ATOM    209  OD1 ASN A  14     -37.236  87.152 132.748  1.00  2.26           O  
ATOM    210  ND2 ASN A  14     -35.204  88.024 133.085  1.00  1.85           N  
ATOM    211  H   ASN A  14     -37.801  86.044 130.502  1.00  0.42           H  
ATOM    212  HA  ASN A  14     -35.624  84.303 130.595  1.00  0.51           H  
ATOM    213  HB2 ASN A  14     -34.414  86.047 131.741  1.00  1.19           H  
ATOM    214  HB3 ASN A  14     -35.414  86.776 130.492  1.00  1.14           H  
ATOM    215 HD21 ASN A  14     -34.249  88.009 132.824  1.00  1.96           H  
ATOM    216 HD22 ASN A  14     -35.567  88.624 133.769  1.00  2.56           H  
ATOM    217  N   SER A  15     -37.307  84.488 133.372  1.00  0.36           N  
ATOM    218  CA  SER A  15     -37.491  83.916 134.695  1.00  0.36           C  
ATOM    219  C   SER A  15     -37.977  82.476 134.595  1.00  0.32           C  
ATOM    220  O   SER A  15     -37.473  81.596 135.285  1.00  0.32           O  
ATOM    221  CB  SER A  15     -38.500  84.741 135.491  1.00  0.38           C  
ATOM    222  OG  SER A  15     -38.214  86.128 135.383  1.00  1.20           O  
ATOM    223  H   SER A  15     -38.000  85.088 133.017  1.00  0.36           H  
ATOM    224  HA  SER A  15     -36.538  83.933 135.204  1.00  0.41           H  
ATOM    225  HB2 SER A  15     -39.502  84.558 135.115  1.00  0.82           H  
ATOM    226  HB3 SER A  15     -38.450  84.459 136.533  1.00  0.96           H  
ATOM    227  HG  SER A  15     -37.752  86.294 134.549  1.00  1.41           H  
ATOM    228  N   ALA A  16     -38.950  82.250 133.718  1.00  0.31           N  
ATOM    229  CA  ALA A  16     -39.550  80.930 133.563  1.00  0.32           C  
ATOM    230  C   ALA A  16     -38.518  79.893 133.138  1.00  0.30           C  
ATOM    231  O   ALA A  16     -38.453  78.803 133.704  1.00  0.29           O  
ATOM    232  CB  ALA A  16     -40.679  80.979 132.550  1.00  0.38           C  
ATOM    233  H   ALA A  16     -39.280  82.994 133.166  1.00  0.32           H  
ATOM    234  HA  ALA A  16     -39.966  80.639 134.514  1.00  0.34           H  
ATOM    235  HB1 ALA A  16     -41.390  81.739 132.838  1.00  1.09           H  
ATOM    236  HB2 ALA A  16     -41.172  80.019 132.518  1.00  1.04           H  
ATOM    237  HB3 ALA A  16     -40.279  81.211 131.577  1.00  1.13           H  
ATOM    238  N   LEU A  17     -37.707  80.247 132.149  1.00  0.31           N  
ATOM    239  CA  LEU A  17     -36.696  79.334 131.632  1.00  0.33           C  
ATOM    240  C   LEU A  17     -35.634  79.039 132.689  1.00  0.32           C  
ATOM    241  O   LEU A  17     -35.235  77.890 132.875  1.00  0.35           O  
ATOM    242  CB  LEU A  17     -36.049  79.911 130.370  1.00  0.38           C  
ATOM    243  CG  LEU A  17     -37.009  80.154 129.203  1.00  0.46           C  
ATOM    244  CD1 LEU A  17     -36.257  80.702 128.001  1.00  0.92           C  
ATOM    245  CD2 LEU A  17     -37.737  78.869 128.830  1.00  0.73           C  
ATOM    246  H   LEU A  17     -37.793  81.140 131.754  1.00  0.33           H  
ATOM    247  HA  LEU A  17     -37.189  78.407 131.375  1.00  0.36           H  
ATOM    248  HB2 LEU A  17     -35.583  80.853 130.629  1.00  0.39           H  
ATOM    249  HB3 LEU A  17     -35.282  79.229 130.041  1.00  0.41           H  
ATOM    250  HG  LEU A  17     -37.746  80.884 129.498  1.00  0.81           H  
ATOM    251 HD11 LEU A  17     -35.514  79.986 127.686  1.00  1.43           H  
ATOM    252 HD12 LEU A  17     -35.776  81.628 128.272  1.00  1.45           H  
ATOM    253 HD13 LEU A  17     -36.952  80.881 127.191  1.00  1.52           H  
ATOM    254 HD21 LEU A  17     -38.402  79.060 128.001  1.00  1.27           H  
ATOM    255 HD22 LEU A  17     -38.310  78.523 129.678  1.00  1.38           H  
ATOM    256 HD23 LEU A  17     -37.016  78.116 128.549  1.00  1.34           H  
ATOM    257  N   GLN A  18     -35.194  80.076 133.392  1.00  0.34           N  
ATOM    258  CA  GLN A  18     -34.189  79.917 134.439  1.00  0.39           C  
ATOM    259  C   GLN A  18     -34.733  79.082 135.601  1.00  0.33           C  
ATOM    260  O   GLN A  18     -34.013  78.273 136.192  1.00  0.34           O  
ATOM    261  CB  GLN A  18     -33.731  81.285 134.943  1.00  0.49           C  
ATOM    262  CG  GLN A  18     -32.577  81.216 135.929  1.00  1.07           C  
ATOM    263  CD  GLN A  18     -32.112  82.586 136.373  1.00  1.51           C  
ATOM    264  OE1 GLN A  18     -32.598  83.129 137.366  1.00  2.06           O  
ATOM    265  NE2 GLN A  18     -31.163  83.152 135.644  1.00  2.19           N  
ATOM    266  H   GLN A  18     -35.530  80.973 133.181  1.00  0.34           H  
ATOM    267  HA  GLN A  18     -33.342  79.400 134.010  1.00  0.45           H  
ATOM    268  HB2 GLN A  18     -33.420  81.883 134.099  1.00  0.93           H  
ATOM    269  HB3 GLN A  18     -34.562  81.774 135.430  1.00  0.97           H  
ATOM    270  HG2 GLN A  18     -32.896  80.661 136.797  1.00  1.70           H  
ATOM    271  HG3 GLN A  18     -31.751  80.706 135.458  1.00  1.61           H  
ATOM    272 HE21 GLN A  18     -30.817  82.658 134.871  1.00  2.53           H  
ATOM    273 HE22 GLN A  18     -30.847  84.049 135.904  1.00  2.67           H  
ATOM    274  N   ALA A  19     -36.007  79.278 135.914  1.00  0.29           N  
ATOM    275  CA  ALA A  19     -36.662  78.508 136.964  1.00  0.28           C  
ATOM    276  C   ALA A  19     -36.749  77.039 136.570  1.00  0.26           C  
ATOM    277  O   ALA A  19     -36.513  76.152 137.387  1.00  0.28           O  
ATOM    278  CB  ALA A  19     -38.048  79.066 137.254  1.00  0.31           C  
ATOM    279  H   ALA A  19     -36.516  79.964 135.431  1.00  0.30           H  
ATOM    280  HA  ALA A  19     -36.068  78.594 137.861  1.00  0.32           H  
ATOM    281  HB1 ALA A  19     -38.493  78.517 138.071  1.00  1.06           H  
ATOM    282  HB2 ALA A  19     -38.668  78.968 136.375  1.00  1.04           H  
ATOM    283  HB3 ALA A  19     -37.970  80.109 137.526  1.00  1.07           H  
ATOM    284  N   LEU A  20     -37.052  76.794 135.301  1.00  0.27           N  
ATOM    285  CA  LEU A  20     -37.175  75.436 134.792  1.00  0.32           C  
ATOM    286  C   LEU A  20     -35.826  74.735 134.836  1.00  0.33           C  
ATOM    287  O   LEU A  20     -35.740  73.537 135.112  1.00  0.36           O  
ATOM    288  CB  LEU A  20     -37.710  75.453 133.358  1.00  0.38           C  
ATOM    289  CG  LEU A  20     -37.924  74.074 132.726  1.00  0.58           C  
ATOM    290  CD1 LEU A  20     -38.964  73.284 133.504  1.00  1.03           C  
ATOM    291  CD2 LEU A  20     -38.347  74.219 131.278  1.00  0.95           C  
ATOM    292  H   LEU A  20     -37.124  77.540 134.671  1.00  0.27           H  
ATOM    293  HA  LEU A  20     -37.871  74.904 135.424  1.00  0.34           H  
ATOM    294  HB2 LEU A  20     -38.652  75.977 133.354  1.00  0.59           H  
ATOM    295  HB3 LEU A  20     -37.010  76.000 132.741  1.00  0.56           H  
ATOM    296  HG  LEU A  20     -36.994  73.522 132.753  1.00  1.19           H  
ATOM    297 HD11 LEU A  20     -38.622  73.134 134.517  1.00  1.64           H  
ATOM    298 HD12 LEU A  20     -39.117  72.326 133.031  1.00  1.57           H  
ATOM    299 HD13 LEU A  20     -39.893  73.833 133.516  1.00  1.54           H  
ATOM    300 HD21 LEU A  20     -38.514  73.241 130.853  1.00  1.60           H  
ATOM    301 HD22 LEU A  20     -37.572  74.727 130.725  1.00  1.40           H  
ATOM    302 HD23 LEU A  20     -39.261  74.794 131.228  1.00  1.55           H  
ATOM    303  N   ALA A  21     -34.775  75.516 134.600  1.00  0.33           N  
ATOM    304  CA  ALA A  21     -33.417  74.997 134.518  1.00  0.39           C  
ATOM    305  C   ALA A  21     -33.015  74.338 135.829  1.00  0.38           C  
ATOM    306  O   ALA A  21     -32.672  73.158 135.872  1.00  0.44           O  
ATOM    307  CB  ALA A  21     -32.448  76.119 134.167  1.00  0.44           C  
ATOM    308  H   ALA A  21     -34.922  76.484 134.543  1.00  0.33           H  
ATOM    309  HA  ALA A  21     -33.384  74.261 133.728  1.00  0.43           H  
ATOM    310  HB1 ALA A  21     -31.451  75.716 134.063  1.00  1.01           H  
ATOM    311  HB2 ALA A  21     -32.455  76.861 134.953  1.00  1.17           H  
ATOM    312  HB3 ALA A  21     -32.749  76.577 133.236  1.00  1.08           H  
ATOM    313  N   LYS A  22     -33.095  75.114 136.903  1.00  0.36           N  
ATOM    314  CA  LYS A  22     -32.722  74.641 138.229  1.00  0.42           C  
ATOM    315  C   LYS A  22     -33.620  73.496 138.683  1.00  0.37           C  
ATOM    316  O   LYS A  22     -33.162  72.552 139.324  1.00  0.47           O  
ATOM    317  CB  LYS A  22     -32.812  75.791 139.235  1.00  0.53           C  
ATOM    318  CG  LYS A  22     -31.866  76.945 138.943  1.00  1.22           C  
ATOM    319  CD  LYS A  22     -32.153  78.137 139.844  1.00  1.84           C  
ATOM    320  CE  LYS A  22     -32.068  77.771 141.320  1.00  2.65           C  
ATOM    321  NZ  LYS A  22     -32.436  78.914 142.195  1.00  3.41           N  
ATOM    322  H   LYS A  22     -33.411  76.038 136.796  1.00  0.36           H  
ATOM    323  HA  LYS A  22     -31.703  74.292 138.184  1.00  0.50           H  
ATOM    324  HB2 LYS A  22     -33.820  76.175 139.235  1.00  0.98           H  
ATOM    325  HB3 LYS A  22     -32.583  75.409 140.219  1.00  1.13           H  
ATOM    326  HG2 LYS A  22     -30.852  76.616 139.110  1.00  1.83           H  
ATOM    327  HG3 LYS A  22     -31.986  77.244 137.913  1.00  1.79           H  
ATOM    328  HD2 LYS A  22     -31.431  78.914 139.635  1.00  2.35           H  
ATOM    329  HD3 LYS A  22     -33.146  78.505 139.631  1.00  2.18           H  
ATOM    330  HE2 LYS A  22     -32.743  76.951 141.513  1.00  3.07           H  
ATOM    331  HE3 LYS A  22     -31.057  77.465 141.543  1.00  3.02           H  
ATOM    332  HZ1 LYS A  22     -33.399  79.244 141.968  1.00  3.81           H  
ATOM    333  HZ2 LYS A  22     -31.767  79.703 142.057  1.00  3.72           H  
ATOM    334  HZ3 LYS A  22     -32.408  78.623 143.198  1.00  3.81           H  
ATOM    335  N   GLN A  23     -34.894  73.575 138.327  1.00  0.33           N  
ATOM    336  CA  GLN A  23     -35.886  72.642 138.844  1.00  0.39           C  
ATOM    337  C   GLN A  23     -35.878  71.300 138.115  1.00  0.40           C  
ATOM    338  O   GLN A  23     -36.403  70.314 138.634  1.00  0.49           O  
ATOM    339  CB  GLN A  23     -37.276  73.277 138.790  1.00  0.52           C  
ATOM    340  CG  GLN A  23     -37.445  74.405 139.797  1.00  0.76           C  
ATOM    341  CD  GLN A  23     -38.716  75.210 139.598  1.00  0.78           C  
ATOM    342  OE1 GLN A  23     -38.754  76.403 139.898  1.00  1.52           O  
ATOM    343  NE2 GLN A  23     -39.772  74.572 139.124  1.00  1.29           N  
ATOM    344  H   GLN A  23     -35.174  74.279 137.700  1.00  0.33           H  
ATOM    345  HA  GLN A  23     -35.640  72.462 139.880  1.00  0.47           H  
ATOM    346  HB2 GLN A  23     -37.444  73.674 137.800  1.00  0.65           H  
ATOM    347  HB3 GLN A  23     -38.018  72.520 138.997  1.00  0.89           H  
ATOM    348  HG2 GLN A  23     -37.462  73.980 140.789  1.00  1.33           H  
ATOM    349  HG3 GLN A  23     -36.598  75.070 139.710  1.00  1.33           H  
ATOM    350 HE21 GLN A  23     -39.692  73.610 138.930  1.00  1.76           H  
ATOM    351 HE22 GLN A  23     -40.591  75.092 138.982  1.00  1.65           H  
ATOM    352  N   THR A  24     -35.297  71.245 136.919  1.00  0.38           N  
ATOM    353  CA  THR A  24     -35.238  69.986 136.177  1.00  0.47           C  
ATOM    354  C   THR A  24     -33.801  69.561 135.886  1.00  0.48           C  
ATOM    355  O   THR A  24     -33.569  68.615 135.128  1.00  0.76           O  
ATOM    356  CB  THR A  24     -36.026  70.061 134.857  1.00  0.54           C  
ATOM    357  OG1 THR A  24     -35.553  71.150 134.054  1.00  0.62           O  
ATOM    358  CG2 THR A  24     -37.512  70.227 135.125  1.00  0.62           C  
ATOM    359  H   THR A  24     -34.921  72.058 136.520  1.00  0.36           H  
ATOM    360  HA  THR A  24     -35.698  69.227 136.794  1.00  0.55           H  
ATOM    361  HB  THR A  24     -35.878  69.137 134.314  1.00  0.64           H  
ATOM    362  HG1 THR A  24     -35.794  71.991 134.471  1.00  0.83           H  
ATOM    363 HG21 THR A  24     -38.048  70.264 134.189  1.00  1.15           H  
ATOM    364 HG22 THR A  24     -37.680  71.143 135.671  1.00  1.20           H  
ATOM    365 HG23 THR A  24     -37.868  69.390 135.709  1.00  1.26           H  
ATOM    366  N   ASP A  25     -32.848  70.264 136.498  1.00  0.41           N  
ATOM    367  CA  ASP A  25     -31.420  69.958 136.346  1.00  0.49           C  
ATOM    368  C   ASP A  25     -30.986  70.082 134.888  1.00  0.49           C  
ATOM    369  O   ASP A  25     -30.303  69.204 134.350  1.00  0.72           O  
ATOM    370  CB  ASP A  25     -31.098  68.549 136.869  1.00  0.68           C  
ATOM    371  CG  ASP A  25     -31.388  68.389 138.344  1.00  1.29           C  
ATOM    372  OD1 ASP A  25     -30.556  68.819 139.171  1.00  1.57           O  
ATOM    373  OD2 ASP A  25     -32.458  67.835 138.684  1.00  2.11           O  
ATOM    374  H   ASP A  25     -33.109  71.012 137.074  1.00  0.53           H  
ATOM    375  HA  ASP A  25     -30.869  70.679 136.931  1.00  0.49           H  
ATOM    376  HB2 ASP A  25     -31.689  67.826 136.326  1.00  1.16           H  
ATOM    377  HB3 ASP A  25     -30.050  68.343 136.704  1.00  1.17           H  
ATOM    378  N   THR A  26     -31.375  71.177 134.249  1.00  0.34           N  
ATOM    379  CA  THR A  26     -31.060  71.388 132.850  1.00  0.40           C  
ATOM    380  C   THR A  26     -30.414  72.752 132.622  1.00  0.38           C  
ATOM    381  O   THR A  26     -30.602  73.682 133.408  1.00  0.40           O  
ATOM    382  CB  THR A  26     -32.330  71.268 131.981  1.00  0.46           C  
ATOM    383  OG1 THR A  26     -33.395  72.029 132.563  1.00  0.76           O  
ATOM    384  CG2 THR A  26     -32.760  69.815 131.838  1.00  0.72           C  
ATOM    385  H   THR A  26     -31.885  71.866 134.731  1.00  0.31           H  
ATOM    386  HA  THR A  26     -30.368  70.616 132.543  1.00  0.48           H  
ATOM    387  HB  THR A  26     -32.114  71.662 130.998  1.00  0.60           H  
ATOM    388  HG1 THR A  26     -34.023  71.435 132.998  1.00  1.07           H  
ATOM    389 HG21 THR A  26     -33.648  69.762 131.227  1.00  1.14           H  
ATOM    390 HG22 THR A  26     -32.969  69.405 132.814  1.00  1.35           H  
ATOM    391 HG23 THR A  26     -31.968  69.250 131.368  1.00  1.32           H  
ATOM    392  N   GLN A  27     -29.637  72.853 131.557  1.00  0.41           N  
ATOM    393  CA  GLN A  27     -29.030  74.108 131.155  1.00  0.44           C  
ATOM    394  C   GLN A  27     -29.787  74.682 129.971  1.00  0.46           C  
ATOM    395  O   GLN A  27     -29.868  74.050 128.917  1.00  0.47           O  
ATOM    396  CB  GLN A  27     -27.560  73.903 130.778  1.00  0.50           C  
ATOM    397  CG  GLN A  27     -26.632  73.734 131.969  1.00  1.05           C  
ATOM    398  CD  GLN A  27     -26.538  74.993 132.808  1.00  1.67           C  
ATOM    399  OE1 GLN A  27     -27.289  75.182 133.763  1.00  2.39           O  
ATOM    400  NE2 GLN A  27     -25.628  75.879 132.436  1.00  2.31           N  
ATOM    401  H   GLN A  27     -29.471  72.051 131.010  1.00  0.45           H  
ATOM    402  HA  GLN A  27     -29.094  74.795 131.986  1.00  0.45           H  
ATOM    403  HB2 GLN A  27     -27.482  73.020 130.161  1.00  0.84           H  
ATOM    404  HB3 GLN A  27     -27.228  74.758 130.210  1.00  0.95           H  
ATOM    405  HG2 GLN A  27     -27.003  72.930 132.592  1.00  1.73           H  
ATOM    406  HG3 GLN A  27     -25.645  73.482 131.610  1.00  1.59           H  
ATOM    407 HE21 GLN A  27     -25.073  75.674 131.648  1.00  2.50           H  
ATOM    408 HE22 GLN A  27     -25.545  76.709 132.958  1.00  2.97           H  
ATOM    409  N   LEU A  28     -30.332  75.874 130.137  1.00  0.51           N  
ATOM    410  CA  LEU A  28     -31.135  76.493 129.097  1.00  0.55           C  
ATOM    411  C   LEU A  28     -30.422  77.720 128.554  1.00  0.58           C  
ATOM    412  O   LEU A  28     -30.031  78.610 129.309  1.00  0.71           O  
ATOM    413  CB  LEU A  28     -32.530  76.874 129.613  1.00  0.69           C  
ATOM    414  CG  LEU A  28     -33.536  75.720 129.727  1.00  0.78           C  
ATOM    415  CD1 LEU A  28     -33.141  74.742 130.822  1.00  1.51           C  
ATOM    416  CD2 LEU A  28     -34.935  76.258 129.976  1.00  1.30           C  
ATOM    417  H   LEU A  28     -30.151  76.374 130.961  1.00  0.54           H  
ATOM    418  HA  LEU A  28     -31.242  75.776 128.297  1.00  0.52           H  
ATOM    419  HB2 LEU A  28     -32.417  77.320 130.592  1.00  0.89           H  
ATOM    420  HB3 LEU A  28     -32.944  77.617 128.946  1.00  0.88           H  
ATOM    421  HG  LEU A  28     -33.552  75.177 128.792  1.00  1.58           H  
ATOM    422 HD11 LEU A  28     -32.175  74.317 130.592  1.00  2.06           H  
ATOM    423 HD12 LEU A  28     -33.876  73.952 130.885  1.00  2.15           H  
ATOM    424 HD13 LEU A  28     -33.090  75.261 131.768  1.00  1.96           H  
ATOM    425 HD21 LEU A  28     -35.628  75.434 130.061  1.00  1.83           H  
ATOM    426 HD22 LEU A  28     -35.226  76.892 129.155  1.00  1.84           H  
ATOM    427 HD23 LEU A  28     -34.941  76.828 130.894  1.00  1.86           H  
ATOM    428  N   LEU A  29     -30.241  77.751 127.246  1.00  0.53           N  
ATOM    429  CA  LEU A  29     -29.554  78.848 126.592  1.00  0.60           C  
ATOM    430  C   LEU A  29     -30.551  79.723 125.847  1.00  0.63           C  
ATOM    431  O   LEU A  29     -31.271  79.255 124.962  1.00  0.66           O  
ATOM    432  CB  LEU A  29     -28.483  78.328 125.627  1.00  0.65           C  
ATOM    433  CG  LEU A  29     -27.222  77.737 126.277  1.00  1.17           C  
ATOM    434  CD1 LEU A  29     -26.643  78.698 127.305  1.00  1.90           C  
ATOM    435  CD2 LEU A  29     -27.511  76.381 126.910  1.00  2.03           C  
ATOM    436  H   LEU A  29     -30.589  77.012 126.696  1.00  0.50           H  
ATOM    437  HA  LEU A  29     -29.078  79.444 127.358  1.00  0.65           H  
ATOM    438  HB2 LEU A  29     -28.930  77.564 125.008  1.00  0.91           H  
ATOM    439  HB3 LEU A  29     -28.181  79.145 124.991  1.00  1.11           H  
ATOM    440  HG  LEU A  29     -26.474  77.591 125.512  1.00  1.65           H  
ATOM    441 HD11 LEU A  29     -27.367  78.867 128.088  1.00  2.44           H  
ATOM    442 HD12 LEU A  29     -26.405  79.634 126.826  1.00  2.28           H  
ATOM    443 HD13 LEU A  29     -25.747  78.271 127.730  1.00  2.40           H  
ATOM    444 HD21 LEU A  29     -28.300  76.485 127.640  1.00  2.42           H  
ATOM    445 HD22 LEU A  29     -26.618  76.014 127.397  1.00  2.49           H  
ATOM    446 HD23 LEU A  29     -27.817  75.683 126.144  1.00  2.63           H  
ATOM    447  N   TYR A  30     -30.587  80.988 126.227  1.00  0.65           N  
ATOM    448  CA  TYR A  30     -31.510  81.948 125.648  1.00  0.72           C  
ATOM    449  C   TYR A  30     -30.963  83.355 125.824  1.00  0.77           C  
ATOM    450  O   TYR A  30     -30.129  83.598 126.695  1.00  0.82           O  
ATOM    451  CB  TYR A  30     -32.892  81.830 126.308  1.00  0.72           C  
ATOM    452  CG  TYR A  30     -32.877  82.007 127.815  1.00  0.69           C  
ATOM    453  CD1 TYR A  30     -32.597  80.939 128.658  1.00  0.65           C  
ATOM    454  CD2 TYR A  30     -33.154  83.241 128.393  1.00  0.80           C  
ATOM    455  CE1 TYR A  30     -32.584  81.097 130.032  1.00  0.71           C  
ATOM    456  CE2 TYR A  30     -33.143  83.406 129.767  1.00  0.88           C  
ATOM    457  CZ  TYR A  30     -32.858  82.329 130.582  1.00  0.83           C  
ATOM    458  OH  TYR A  30     -32.847  82.485 131.950  1.00  0.96           O  
ATOM    459  H   TYR A  30     -29.959  81.296 126.917  1.00  0.66           H  
ATOM    460  HA  TYR A  30     -31.599  81.733 124.593  1.00  0.81           H  
ATOM    461  HB2 TYR A  30     -33.545  82.584 125.894  1.00  0.79           H  
ATOM    462  HB3 TYR A  30     -33.301  80.852 126.093  1.00  0.73           H  
ATOM    463  HD1 TYR A  30     -32.376  79.975 128.226  1.00  0.64           H  
ATOM    464  HD2 TYR A  30     -33.377  84.083 127.754  1.00  0.87           H  
ATOM    465  HE1 TYR A  30     -32.362  80.254 130.667  1.00  0.72           H  
ATOM    466  HE2 TYR A  30     -33.357  84.373 130.195  1.00  1.01           H  
ATOM    467  HH  TYR A  30     -33.652  82.936 132.230  1.00  1.29           H  
ATOM    468  N   SER A  31     -31.418  84.271 124.991  1.00  0.85           N  
ATOM    469  CA  SER A  31     -30.993  85.653 125.093  1.00  0.97           C  
ATOM    470  C   SER A  31     -32.081  86.494 125.752  1.00  0.88           C  
ATOM    471  O   SER A  31     -33.171  86.662 125.201  1.00  0.85           O  
ATOM    472  CB  SER A  31     -30.653  86.205 123.706  1.00  1.20           C  
ATOM    473  OG  SER A  31     -30.193  87.540 123.796  1.00  1.78           O  
ATOM    474  H   SER A  31     -32.044  84.013 124.285  1.00  0.88           H  
ATOM    475  HA  SER A  31     -30.108  85.683 125.710  1.00  1.05           H  
ATOM    476  HB2 SER A  31     -29.879  85.598 123.258  1.00  1.60           H  
ATOM    477  HB3 SER A  31     -31.535  86.181 123.084  1.00  1.51           H  
ATOM    478  HG  SER A  31     -29.468  87.672 123.165  1.00  2.08           H  
ATOM    479  N   PRO A  32     -31.800  87.022 126.957  1.00  0.96           N  
ATOM    480  CA  PRO A  32     -32.760  87.834 127.720  1.00  0.99           C  
ATOM    481  C   PRO A  32     -33.142  89.127 126.997  1.00  1.01           C  
ATOM    482  O   PRO A  32     -34.250  89.638 127.155  1.00  1.05           O  
ATOM    483  CB  PRO A  32     -32.013  88.152 129.021  1.00  1.23           C  
ATOM    484  CG  PRO A  32     -30.570  87.955 128.702  1.00  1.37           C  
ATOM    485  CD  PRO A  32     -30.522  86.863 127.673  1.00  1.12           C  
ATOM    486  HA  PRO A  32     -33.656  87.275 127.944  1.00  0.97           H  
ATOM    487  HB2 PRO A  32     -32.213  89.172 129.313  1.00  1.35           H  
ATOM    488  HB3 PRO A  32     -32.338  87.480 129.801  1.00  1.36           H  
ATOM    489  HG2 PRO A  32     -30.155  88.867 128.302  1.00  1.65           H  
ATOM    490  HG3 PRO A  32     -30.036  87.657 129.592  1.00  1.66           H  
ATOM    491  HD2 PRO A  32     -29.684  87.010 127.007  1.00  1.19           H  
ATOM    492  HD3 PRO A  32     -30.464  85.896 128.150  1.00  1.21           H  
ATOM    493  N   GLU A  33     -32.214  89.649 126.209  1.00  1.09           N  
ATOM    494  CA  GLU A  33     -32.448  90.871 125.453  1.00  1.26           C  
ATOM    495  C   GLU A  33     -33.318  90.598 124.223  1.00  1.23           C  
ATOM    496  O   GLU A  33     -34.117  91.439 123.812  1.00  1.39           O  
ATOM    497  CB  GLU A  33     -31.111  91.483 125.033  1.00  1.48           C  
ATOM    498  CG  GLU A  33     -30.306  90.597 124.096  1.00  1.99           C  
ATOM    499  CD  GLU A  33     -28.870  91.037 123.952  1.00  2.43           C  
ATOM    500  OE1 GLU A  33     -28.628  92.164 123.481  1.00  2.96           O  
ATOM    501  OE2 GLU A  33     -27.966  90.247 124.301  1.00  2.83           O  
ATOM    502  H   GLU A  33     -31.352  89.191 126.124  1.00  1.10           H  
ATOM    503  HA  GLU A  33     -32.966  91.565 126.098  1.00  1.36           H  
ATOM    504  HB2 GLU A  33     -31.299  92.421 124.534  1.00  2.01           H  
ATOM    505  HB3 GLU A  33     -30.520  91.667 125.917  1.00  1.75           H  
ATOM    506  HG2 GLU A  33     -30.319  89.586 124.478  1.00  2.40           H  
ATOM    507  HG3 GLU A  33     -30.771  90.615 123.123  1.00  2.61           H  
ATOM    508  N   ASP A  34     -33.174  89.401 123.662  1.00  1.12           N  
ATOM    509  CA  ASP A  34     -33.794  89.064 122.380  1.00  1.23           C  
ATOM    510  C   ASP A  34     -35.237  88.597 122.555  1.00  1.17           C  
ATOM    511  O   ASP A  34     -35.975  88.447 121.583  1.00  1.38           O  
ATOM    512  CB  ASP A  34     -32.971  87.982 121.672  1.00  1.33           C  
ATOM    513  CG  ASP A  34     -33.444  87.711 120.256  1.00  1.71           C  
ATOM    514  OD1 ASP A  34     -33.200  88.561 119.373  1.00  2.22           O  
ATOM    515  OD2 ASP A  34     -34.049  86.646 120.020  1.00  2.14           O  
ATOM    516  H   ASP A  34     -32.630  88.725 124.116  1.00  1.03           H  
ATOM    517  HA  ASP A  34     -33.793  89.954 121.769  1.00  1.41           H  
ATOM    518  HB2 ASP A  34     -31.938  88.294 121.631  1.00  1.47           H  
ATOM    519  HB3 ASP A  34     -33.041  87.063 122.237  1.00  1.64           H  
ATOM    520  N   ILE A  35     -35.654  88.407 123.795  1.00  0.97           N  
ATOM    521  CA  ILE A  35     -37.003  87.923 124.067  1.00  0.97           C  
ATOM    522  C   ILE A  35     -37.947  89.078 124.384  1.00  1.02           C  
ATOM    523  O   ILE A  35     -39.130  88.864 124.647  1.00  1.09           O  
ATOM    524  CB  ILE A  35     -37.024  86.912 125.233  1.00  0.88           C  
ATOM    525  CG1 ILE A  35     -36.382  87.524 126.482  1.00  0.78           C  
ATOM    526  CG2 ILE A  35     -36.313  85.626 124.833  1.00  0.95           C  
ATOM    527  CD1 ILE A  35     -36.377  86.602 127.683  1.00  0.82           C  
ATOM    528  H   ILE A  35     -35.043  88.576 124.542  1.00  0.91           H  
ATOM    529  HA  ILE A  35     -37.358  87.422 123.179  1.00  1.12           H  
ATOM    530  HB  ILE A  35     -38.052  86.667 125.451  1.00  0.97           H  
ATOM    531 HG12 ILE A  35     -35.358  87.782 126.263  1.00  0.77           H  
ATOM    532 HG13 ILE A  35     -36.924  88.419 126.753  1.00  0.84           H  
ATOM    533 HG21 ILE A  35     -36.345  84.926 125.654  1.00  1.35           H  
ATOM    534 HG22 ILE A  35     -35.284  85.846 124.588  1.00  1.38           H  
ATOM    535 HG23 ILE A  35     -36.804  85.198 123.974  1.00  1.49           H  
ATOM    536 HD11 ILE A  35     -35.925  85.659 127.409  1.00  1.29           H  
ATOM    537 HD12 ILE A  35     -37.391  86.434 128.010  1.00  1.34           H  
ATOM    538 HD13 ILE A  35     -35.810  87.054 128.482  1.00  1.31           H  
ATOM    539  N   GLY A  36     -37.404  90.296 124.384  1.00  1.08           N  
ATOM    540  CA  GLY A  36     -38.215  91.501 124.524  1.00  1.25           C  
ATOM    541  C   GLY A  36     -39.033  91.559 125.805  1.00  1.17           C  
ATOM    542  O   GLY A  36     -39.969  92.353 125.911  1.00  1.40           O  
ATOM    543  H   GLY A  36     -36.433  90.381 124.275  1.00  1.10           H  
ATOM    544  HA2 GLY A  36     -37.560  92.356 124.502  1.00  1.38           H  
ATOM    545  HA3 GLY A  36     -38.888  91.560 123.680  1.00  1.38           H  
ATOM    546  N   GLY A  37     -38.676  90.737 126.783  1.00  0.97           N  
ATOM    547  CA  GLY A  37     -39.424  90.691 128.021  1.00  0.96           C  
ATOM    548  C   GLY A  37     -40.825  90.139 127.835  1.00  0.88           C  
ATOM    549  O   GLY A  37     -41.782  90.635 128.433  1.00  1.05           O  
ATOM    550  H   GLY A  37     -37.896  90.161 126.662  1.00  0.94           H  
ATOM    551  HA2 GLY A  37     -38.894  90.065 128.726  1.00  0.94           H  
ATOM    552  HA3 GLY A  37     -39.493  91.692 128.427  1.00  1.10           H  
ATOM    553  N   LEU A  38     -40.942  89.108 127.010  1.00  0.77           N  
ATOM    554  CA  LEU A  38     -42.227  88.465 126.762  1.00  0.83           C  
ATOM    555  C   LEU A  38     -42.634  87.620 127.959  1.00  0.66           C  
ATOM    556  O   LEU A  38     -41.785  87.029 128.622  1.00  0.67           O  
ATOM    557  CB  LEU A  38     -42.154  87.579 125.514  1.00  1.06           C  
ATOM    558  CG  LEU A  38     -42.157  88.322 124.176  1.00  1.05           C  
ATOM    559  CD1 LEU A  38     -41.929  87.353 123.027  1.00  1.72           C  
ATOM    560  CD2 LEU A  38     -43.476  89.057 123.993  1.00  1.20           C  
ATOM    561  H   LEU A  38     -40.139  88.751 126.576  1.00  0.78           H  
ATOM    562  HA  LEU A  38     -42.967  89.237 126.607  1.00  1.00           H  
ATOM    563  HB2 LEU A  38     -41.251  86.989 125.572  1.00  1.68           H  
ATOM    564  HB3 LEU A  38     -43.000  86.907 125.528  1.00  1.56           H  
ATOM    565  HG  LEU A  38     -41.361  89.050 124.170  1.00  1.24           H  
ATOM    566 HD11 LEU A  38     -40.995  86.832 123.178  1.00  2.13           H  
ATOM    567 HD12 LEU A  38     -41.889  87.902 122.098  1.00  2.12           H  
ATOM    568 HD13 LEU A  38     -42.739  86.641 122.990  1.00  2.20           H  
ATOM    569 HD21 LEU A  38     -44.288  88.345 124.008  1.00  1.57           H  
ATOM    570 HD22 LEU A  38     -43.469  89.575 123.048  1.00  1.79           H  
ATOM    571 HD23 LEU A  38     -43.606  89.769 124.796  1.00  1.62           H  
ATOM    572  N   ARG A  39     -43.930  87.577 128.239  1.00  0.68           N  
ATOM    573  CA  ARG A  39     -44.445  86.742 129.314  1.00  0.59           C  
ATOM    574  C   ARG A  39     -44.543  85.294 128.855  1.00  0.52           C  
ATOM    575  O   ARG A  39     -44.995  85.008 127.746  1.00  0.62           O  
ATOM    576  CB  ARG A  39     -45.815  87.230 129.790  1.00  0.66           C  
ATOM    577  CG  ARG A  39     -46.823  87.427 128.670  1.00  0.76           C  
ATOM    578  CD  ARG A  39     -48.205  87.744 129.218  1.00  1.12           C  
ATOM    579  NE  ARG A  39     -48.822  86.575 129.848  1.00  2.00           N  
ATOM    580  CZ  ARG A  39     -49.782  86.636 130.769  1.00  2.70           C  
ATOM    581  NH1 ARG A  39     -50.197  87.807 131.241  1.00  2.71           N  
ATOM    582  NH2 ARG A  39     -50.309  85.515 131.234  1.00  3.77           N  
ATOM    583  H   ARG A  39     -44.552  88.112 127.705  1.00  0.82           H  
ATOM    584  HA  ARG A  39     -43.747  86.798 130.135  1.00  0.60           H  
ATOM    585  HB2 ARG A  39     -46.219  86.502 130.479  1.00  0.66           H  
ATOM    586  HB3 ARG A  39     -45.692  88.167 130.307  1.00  0.76           H  
ATOM    587  HG2 ARG A  39     -46.497  88.244 128.047  1.00  0.96           H  
ATOM    588  HG3 ARG A  39     -46.875  86.521 128.086  1.00  0.97           H  
ATOM    589  HD2 ARG A  39     -48.117  88.533 129.950  1.00  1.64           H  
ATOM    590  HD3 ARG A  39     -48.834  88.075 128.406  1.00  1.48           H  
ATOM    591  HE  ARG A  39     -48.516  85.690 129.547  1.00  2.49           H  
ATOM    592 HH11 ARG A  39     -49.787  88.663 130.907  1.00  2.43           H  
ATOM    593 HH12 ARG A  39     -50.920  87.847 131.940  1.00  3.37           H  
ATOM    594 HH21 ARG A  39     -49.979  84.626 130.890  1.00  4.20           H  
ATOM    595 HH22 ARG A  39     -51.047  85.543 131.926  1.00  4.32           H  
ATOM    596  N   SER A  40     -44.109  84.394 129.710  1.00  0.45           N  
ATOM    597  CA  SER A  40     -44.105  82.981 129.395  1.00  0.50           C  
ATOM    598  C   SER A  40     -45.459  82.337 129.667  1.00  0.49           C  
ATOM    599  O   SER A  40     -46.258  82.839 130.463  1.00  0.48           O  
ATOM    600  CB  SER A  40     -43.019  82.295 130.220  1.00  0.56           C  
ATOM    601  OG  SER A  40     -43.043  82.761 131.561  1.00  0.50           O  
ATOM    602  H   SER A  40     -43.746  84.694 130.576  1.00  0.42           H  
ATOM    603  HA  SER A  40     -43.872  82.878 128.348  1.00  0.61           H  
ATOM    604  HB2 SER A  40     -43.184  81.228 130.214  1.00  0.63           H  
ATOM    605  HB3 SER A  40     -42.051  82.513 129.791  1.00  0.66           H  
ATOM    606  HG  SER A  40     -43.476  82.108 132.125  1.00  0.53           H  
ATOM    607  N   SER A  41     -45.715  81.229 128.990  1.00  0.59           N  
ATOM    608  CA  SER A  41     -46.931  80.472 129.207  1.00  0.68           C  
ATOM    609  C   SER A  41     -46.695  79.474 130.336  1.00  0.65           C  
ATOM    610  O   SER A  41     -46.145  78.393 130.119  1.00  0.66           O  
ATOM    611  CB  SER A  41     -47.336  79.752 127.913  1.00  0.85           C  
ATOM    612  OG  SER A  41     -48.624  79.164 128.020  1.00  1.54           O  
ATOM    613  H   SER A  41     -45.074  80.921 128.317  1.00  0.66           H  
ATOM    614  HA  SER A  41     -47.712  81.159 129.497  1.00  0.68           H  
ATOM    615  HB2 SER A  41     -47.345  80.459 127.099  1.00  1.26           H  
ATOM    616  HB3 SER A  41     -46.616  78.973 127.703  1.00  1.17           H  
ATOM    617  HG  SER A  41     -48.636  78.346 127.511  1.00  1.91           H  
ATOM    618  N   ALA A  42     -47.085  79.873 131.541  1.00  0.69           N  
ATOM    619  CA  ALA A  42     -46.823  79.097 132.744  1.00  0.72           C  
ATOM    620  C   ALA A  42     -47.415  77.697 132.658  1.00  0.63           C  
ATOM    621  O   ALA A  42     -48.632  77.528 132.589  1.00  0.66           O  
ATOM    622  CB  ALA A  42     -47.374  79.820 133.962  1.00  0.84           C  
ATOM    623  H   ALA A  42     -47.596  80.704 131.625  1.00  0.74           H  
ATOM    624  HA  ALA A  42     -45.753  79.016 132.863  1.00  0.78           H  
ATOM    625  HB1 ALA A  42     -46.951  80.812 134.014  1.00  1.29           H  
ATOM    626  HB2 ALA A  42     -47.117  79.269 134.854  1.00  1.30           H  
ATOM    627  HB3 ALA A  42     -48.449  79.890 133.880  1.00  1.41           H  
ATOM    628  N   LEU A  43     -46.547  76.703 132.661  1.00  0.59           N  
ATOM    629  CA  LEU A  43     -46.983  75.325 132.701  1.00  0.54           C  
ATOM    630  C   LEU A  43     -46.545  74.692 134.015  1.00  0.45           C  
ATOM    631  O   LEU A  43     -45.503  74.045 134.094  1.00  0.51           O  
ATOM    632  CB  LEU A  43     -46.415  74.541 131.513  1.00  0.65           C  
ATOM    633  CG  LEU A  43     -46.924  73.105 131.375  1.00  0.83           C  
ATOM    634  CD1 LEU A  43     -48.429  73.088 131.158  1.00  1.42           C  
ATOM    635  CD2 LEU A  43     -46.214  72.392 130.236  1.00  1.42           C  
ATOM    636  H   LEU A  43     -45.591  76.901 132.626  1.00  0.63           H  
ATOM    637  HA  LEU A  43     -48.063  75.310 132.650  1.00  0.57           H  
ATOM    638  HB2 LEU A  43     -46.659  75.078 130.610  1.00  0.85           H  
ATOM    639  HB3 LEU A  43     -45.340  74.509 131.614  1.00  0.74           H  
ATOM    640  HG  LEU A  43     -46.715  72.566 132.288  1.00  1.62           H  
ATOM    641 HD11 LEU A  43     -48.670  73.649 130.265  1.00  1.97           H  
ATOM    642 HD12 LEU A  43     -48.919  73.537 132.009  1.00  1.91           H  
ATOM    643 HD13 LEU A  43     -48.766  72.070 131.043  1.00  1.97           H  
ATOM    644 HD21 LEU A  43     -46.569  71.374 130.173  1.00  1.85           H  
ATOM    645 HD22 LEU A  43     -45.149  72.392 130.419  1.00  2.06           H  
ATOM    646 HD23 LEU A  43     -46.420  72.904 129.306  1.00  1.96           H  
ATOM    647  N   LYS A  44     -47.340  74.904 135.047  1.00  0.43           N  
ATOM    648  CA  LYS A  44     -47.063  74.315 136.341  1.00  0.43           C  
ATOM    649  C   LYS A  44     -47.962  73.110 136.568  1.00  0.41           C  
ATOM    650  O   LYS A  44     -49.155  73.240 136.852  1.00  0.50           O  
ATOM    651  CB  LYS A  44     -47.201  75.350 137.467  1.00  0.61           C  
ATOM    652  CG  LYS A  44     -48.458  76.204 137.400  1.00  0.88           C  
ATOM    653  CD  LYS A  44     -48.483  77.210 138.541  1.00  1.15           C  
ATOM    654  CE  LYS A  44     -49.690  78.128 138.457  1.00  1.77           C  
ATOM    655  NZ  LYS A  44     -49.737  79.089 139.589  1.00  2.43           N  
ATOM    656  H   LYS A  44     -48.136  75.462 134.934  1.00  0.52           H  
ATOM    657  HA  LYS A  44     -46.039  73.967 136.317  1.00  0.44           H  
ATOM    658  HB2 LYS A  44     -47.205  74.830 138.413  1.00  1.11           H  
ATOM    659  HB3 LYS A  44     -46.346  76.008 137.437  1.00  1.20           H  
ATOM    660  HG2 LYS A  44     -48.477  76.734 136.460  1.00  1.46           H  
ATOM    661  HG3 LYS A  44     -49.324  75.565 137.476  1.00  1.32           H  
ATOM    662  HD2 LYS A  44     -48.516  76.675 139.479  1.00  1.34           H  
ATOM    663  HD3 LYS A  44     -47.584  77.808 138.499  1.00  1.67           H  
ATOM    664  HE2 LYS A  44     -49.641  78.680 137.530  1.00  2.19           H  
ATOM    665  HE3 LYS A  44     -50.585  77.524 138.470  1.00  2.23           H  
ATOM    666  HZ1 LYS A  44     -50.573  79.706 139.502  1.00  2.75           H  
ATOM    667  HZ2 LYS A  44     -48.877  79.684 139.594  1.00  2.84           H  
ATOM    668  HZ3 LYS A  44     -49.789  78.575 140.494  1.00  2.89           H  
ATOM    669  N   GLY A  45     -47.372  71.938 136.418  1.00  0.37           N  
ATOM    670  CA  GLY A  45     -48.110  70.704 136.489  1.00  0.37           C  
ATOM    671  C   GLY A  45     -47.204  69.532 136.199  1.00  0.33           C  
ATOM    672  O   GLY A  45     -45.983  69.676 136.245  1.00  0.34           O  
ATOM    673  H   GLY A  45     -46.404  71.908 136.272  1.00  0.38           H  
ATOM    674  HA2 GLY A  45     -48.533  70.594 137.478  1.00  0.43           H  
ATOM    675  HA3 GLY A  45     -48.906  70.721 135.759  1.00  0.40           H  
ATOM    676  N   ARG A  46     -47.782  68.386 135.888  1.00  0.35           N  
ATOM    677  CA  ARG A  46     -46.988  67.199 135.607  1.00  0.36           C  
ATOM    678  C   ARG A  46     -46.834  66.996 134.106  1.00  0.34           C  
ATOM    679  O   ARG A  46     -47.804  66.715 133.401  1.00  0.48           O  
ATOM    680  CB  ARG A  46     -47.612  65.962 136.258  1.00  0.49           C  
ATOM    681  CG  ARG A  46     -46.933  64.658 135.858  1.00  0.97           C  
ATOM    682  CD  ARG A  46     -47.270  63.533 136.821  1.00  1.13           C  
ATOM    683  NE  ARG A  46     -46.622  63.727 138.117  1.00  1.77           N  
ATOM    684  CZ  ARG A  46     -47.278  63.936 139.256  1.00  2.26           C  
ATOM    685  NH1 ARG A  46     -48.606  63.985 139.269  1.00  2.15           N  
ATOM    686  NH2 ARG A  46     -46.604  64.109 140.385  1.00  3.27           N  
ATOM    687  H   ARG A  46     -48.757  68.345 135.796  1.00  0.39           H  
ATOM    688  HA  ARG A  46     -46.010  67.358 136.032  1.00  0.40           H  
ATOM    689  HB2 ARG A  46     -47.548  66.064 137.333  1.00  0.83           H  
ATOM    690  HB3 ARG A  46     -48.650  65.904 135.972  1.00  0.89           H  
ATOM    691  HG2 ARG A  46     -47.263  64.380 134.869  1.00  1.41           H  
ATOM    692  HG3 ARG A  46     -45.863  64.807 135.855  1.00  1.30           H  
ATOM    693  HD2 ARG A  46     -48.340  63.501 136.965  1.00  1.38           H  
ATOM    694  HD3 ARG A  46     -46.935  62.598 136.398  1.00  1.63           H  
ATOM    695  HE  ARG A  46     -45.630  63.703 138.133  1.00  2.28           H  
ATOM    696 HH11 ARG A  46     -49.127  63.864 138.415  1.00  1.92           H  
ATOM    697 HH12 ARG A  46     -49.096  64.159 140.127  1.00  2.69           H  
ATOM    698 HH21 ARG A  46     -45.596  64.086 140.386  1.00  3.73           H  
ATOM    699 HH22 ARG A  46     -47.095  64.267 141.248  1.00  3.71           H  
ATOM    700  N   HIS A  47     -45.611  67.168 133.628  1.00  0.32           N  
ATOM    701  CA  HIS A  47     -45.289  66.968 132.220  1.00  0.45           C  
ATOM    702  C   HIS A  47     -43.814  66.641 132.047  1.00  0.43           C  
ATOM    703  O   HIS A  47     -43.002  66.876 132.945  1.00  0.46           O  
ATOM    704  CB  HIS A  47     -45.639  68.204 131.387  1.00  0.68           C  
ATOM    705  CG  HIS A  47     -47.006  68.162 130.772  1.00  1.01           C  
ATOM    706  ND1 HIS A  47     -47.367  67.248 129.808  1.00  1.79           N  
ATOM    707  CD2 HIS A  47     -48.101  68.928 130.987  1.00  1.21           C  
ATOM    708  CE1 HIS A  47     -48.619  67.460 129.447  1.00  1.98           C  
ATOM    709  NE2 HIS A  47     -49.090  68.473 130.151  1.00  1.57           N  
ATOM    710  H   HIS A  47     -44.892  67.434 134.245  1.00  0.34           H  
ATOM    711  HA  HIS A  47     -45.875  66.133 131.868  1.00  0.56           H  
ATOM    712  HB2 HIS A  47     -45.588  69.079 132.018  1.00  0.79           H  
ATOM    713  HB3 HIS A  47     -44.920  68.302 130.588  1.00  0.81           H  
ATOM    714  HD1 HIS A  47     -46.789  66.530 129.447  1.00  2.32           H  
ATOM    715  HD2 HIS A  47     -48.183  69.744 131.692  1.00  1.60           H  
ATOM    716  HE1 HIS A  47     -49.168  66.894 128.710  1.00  2.60           H  
ATOM    717  HE2 HIS A  47     -49.923  68.963 129.936  1.00  1.82           H  
ATOM    718  N   ASP A  48     -43.489  66.077 130.893  1.00  0.47           N  
ATOM    719  CA  ASP A  48     -42.113  65.748 130.533  1.00  0.55           C  
ATOM    720  C   ASP A  48     -41.367  66.990 130.050  1.00  0.48           C  
ATOM    721  O   ASP A  48     -41.994  67.948 129.601  1.00  0.44           O  
ATOM    722  CB  ASP A  48     -42.112  64.652 129.457  1.00  0.70           C  
ATOM    723  CG  ASP A  48     -40.986  64.792 128.449  1.00  1.20           C  
ATOM    724  OD1 ASP A  48     -39.853  64.363 128.764  1.00  1.80           O  
ATOM    725  OD2 ASP A  48     -41.227  65.319 127.344  1.00  1.86           O  
ATOM    726  H   ASP A  48     -44.205  65.868 130.252  1.00  0.51           H  
ATOM    727  HA  ASP A  48     -41.622  65.371 131.419  1.00  0.64           H  
ATOM    728  HB2 ASP A  48     -42.011  63.692 129.938  1.00  1.31           H  
ATOM    729  HB3 ASP A  48     -43.052  64.683 128.925  1.00  1.39           H  
ATOM    730  N   LEU A  49     -40.042  66.972 130.135  1.00  0.50           N  
ATOM    731  CA  LEU A  49     -39.230  68.147 129.841  1.00  0.51           C  
ATOM    732  C   LEU A  49     -39.493  68.659 128.420  1.00  0.42           C  
ATOM    733  O   LEU A  49     -39.915  69.806 128.237  1.00  0.43           O  
ATOM    734  CB  LEU A  49     -37.744  67.801 130.028  1.00  0.61           C  
ATOM    735  CG  LEU A  49     -36.801  68.977 130.339  1.00  0.73           C  
ATOM    736  CD1 LEU A  49     -36.599  69.864 129.130  1.00  1.16           C  
ATOM    737  CD2 LEU A  49     -37.335  69.786 131.508  1.00  1.18           C  
ATOM    738  H   LEU A  49     -39.593  66.133 130.374  1.00  0.56           H  
ATOM    739  HA  LEU A  49     -39.499  68.920 130.544  1.00  0.56           H  
ATOM    740  HB2 LEU A  49     -37.667  67.091 130.838  1.00  0.73           H  
ATOM    741  HB3 LEU A  49     -37.395  67.323 129.125  1.00  0.73           H  
ATOM    742  HG  LEU A  49     -35.834  68.590 130.618  1.00  1.12           H  
ATOM    743 HD11 LEU A  49     -36.186  69.282 128.319  1.00  1.74           H  
ATOM    744 HD12 LEU A  49     -35.922  70.668 129.379  1.00  1.58           H  
ATOM    745 HD13 LEU A  49     -37.552  70.278 128.827  1.00  1.65           H  
ATOM    746 HD21 LEU A  49     -36.678  70.624 131.698  1.00  1.64           H  
ATOM    747 HD22 LEU A  49     -37.382  69.161 132.387  1.00  1.71           H  
ATOM    748 HD23 LEU A  49     -38.323  70.151 131.271  1.00  1.71           H  
ATOM    749  N   GLN A  50     -39.273  67.798 127.423  1.00  0.41           N  
ATOM    750  CA  GLN A  50     -39.446  68.167 126.018  1.00  0.42           C  
ATOM    751  C   GLN A  50     -40.875  68.620 125.746  1.00  0.39           C  
ATOM    752  O   GLN A  50     -41.107  69.590 125.019  1.00  0.41           O  
ATOM    753  CB  GLN A  50     -39.095  66.986 125.105  1.00  0.52           C  
ATOM    754  CG  GLN A  50     -39.317  67.269 123.626  1.00  1.21           C  
ATOM    755  CD  GLN A  50     -38.949  66.096 122.733  1.00  1.67           C  
ATOM    756  OE1 GLN A  50     -39.545  65.898 121.675  1.00  2.15           O  
ATOM    757  NE2 GLN A  50     -37.958  65.322 123.144  1.00  2.39           N  
ATOM    758  H   GLN A  50     -38.991  66.881 127.643  1.00  0.44           H  
ATOM    759  HA  GLN A  50     -38.775  68.987 125.804  1.00  0.45           H  
ATOM    760  HB2 GLN A  50     -38.057  66.730 125.250  1.00  1.12           H  
ATOM    761  HB3 GLN A  50     -39.706  66.139 125.382  1.00  1.00           H  
ATOM    762  HG2 GLN A  50     -40.359  67.502 123.471  1.00  1.83           H  
ATOM    763  HG3 GLN A  50     -38.714  68.118 123.345  1.00  1.78           H  
ATOM    764 HE21 GLN A  50     -37.518  65.538 123.993  1.00  2.71           H  
ATOM    765 HE22 GLN A  50     -37.697  64.563 122.576  1.00  2.89           H  
ATOM    766  N   SER A  51     -41.823  67.907 126.329  1.00  0.41           N  
ATOM    767  CA  SER A  51     -43.230  68.235 126.172  1.00  0.46           C  
ATOM    768  C   SER A  51     -43.540  69.612 126.758  1.00  0.41           C  
ATOM    769  O   SER A  51     -44.225  70.420 126.132  1.00  0.43           O  
ATOM    770  CB  SER A  51     -44.089  67.172 126.847  1.00  0.57           C  
ATOM    771  OG  SER A  51     -43.707  65.874 126.424  1.00  1.33           O  
ATOM    772  H   SER A  51     -41.568  67.123 126.869  1.00  0.44           H  
ATOM    773  HA  SER A  51     -43.452  68.247 125.116  1.00  0.52           H  
ATOM    774  HB2 SER A  51     -43.967  67.240 127.917  1.00  0.94           H  
ATOM    775  HB3 SER A  51     -45.125  67.333 126.587  1.00  1.23           H  
ATOM    776  HG  SER A  51     -42.811  65.681 126.748  1.00  1.62           H  
ATOM    777  N   SER A  52     -43.028  69.871 127.955  1.00  0.40           N  
ATOM    778  CA  SER A  52     -43.235  71.151 128.621  1.00  0.43           C  
ATOM    779  C   SER A  52     -42.634  72.290 127.806  1.00  0.41           C  
ATOM    780  O   SER A  52     -43.252  73.346 127.649  1.00  0.45           O  
ATOM    781  CB  SER A  52     -42.622  71.116 130.021  1.00  0.49           C  
ATOM    782  OG  SER A  52     -43.154  70.038 130.774  1.00  1.21           O  
ATOM    783  H   SER A  52     -42.489  69.181 128.406  1.00  0.41           H  
ATOM    784  HA  SER A  52     -44.300  71.310 128.709  1.00  0.47           H  
ATOM    785  HB2 SER A  52     -41.551  70.991 129.943  1.00  1.13           H  
ATOM    786  HB3 SER A  52     -42.839  72.043 130.535  1.00  1.10           H  
ATOM    787  HG  SER A  52     -42.652  69.237 130.583  1.00  1.66           H  
ATOM    788  N   LEU A  53     -41.433  72.062 127.276  1.00  0.39           N  
ATOM    789  CA  LEU A  53     -40.765  73.048 126.438  1.00  0.41           C  
ATOM    790  C   LEU A  53     -41.640  73.405 125.247  1.00  0.40           C  
ATOM    791  O   LEU A  53     -41.827  74.575 124.932  1.00  0.46           O  
ATOM    792  CB  LEU A  53     -39.420  72.515 125.937  1.00  0.44           C  
ATOM    793  CG  LEU A  53     -38.368  72.261 127.015  1.00  0.51           C  
ATOM    794  CD1 LEU A  53     -37.130  71.625 126.404  1.00  0.70           C  
ATOM    795  CD2 LEU A  53     -38.000  73.556 127.718  1.00  0.56           C  
ATOM    796  H   LEU A  53     -40.984  71.204 127.462  1.00  0.39           H  
ATOM    797  HA  LEU A  53     -40.598  73.934 127.030  1.00  0.47           H  
ATOM    798  HB2 LEU A  53     -39.597  71.586 125.415  1.00  0.43           H  
ATOM    799  HB3 LEU A  53     -39.015  73.228 125.235  1.00  0.46           H  
ATOM    800  HG  LEU A  53     -38.768  71.579 127.750  1.00  0.66           H  
ATOM    801 HD11 LEU A  53     -37.402  70.693 125.932  1.00  1.30           H  
ATOM    802 HD12 LEU A  53     -36.403  71.434 127.184  1.00  1.26           H  
ATOM    803 HD13 LEU A  53     -36.707  72.293 125.669  1.00  1.24           H  
ATOM    804 HD21 LEU A  53     -37.259  73.353 128.478  1.00  1.07           H  
ATOM    805 HD22 LEU A  53     -38.880  73.979 128.179  1.00  1.19           H  
ATOM    806 HD23 LEU A  53     -37.597  74.256 126.999  1.00  1.26           H  
ATOM    807  N   ARG A  54     -42.189  72.383 124.611  1.00  0.38           N  
ATOM    808  CA  ARG A  54     -43.012  72.561 123.424  1.00  0.43           C  
ATOM    809  C   ARG A  54     -44.249  73.397 123.731  1.00  0.42           C  
ATOM    810  O   ARG A  54     -44.586  74.313 122.986  1.00  0.48           O  
ATOM    811  CB  ARG A  54     -43.409  71.193 122.869  1.00  0.51           C  
ATOM    812  CG  ARG A  54     -44.200  71.254 121.571  1.00  1.10           C  
ATOM    813  CD  ARG A  54     -44.421  69.862 121.000  1.00  1.31           C  
ATOM    814  NE  ARG A  54     -45.122  68.992 121.942  1.00  1.87           N  
ATOM    815  CZ  ARG A  54     -44.621  67.850 122.418  1.00  2.48           C  
ATOM    816  NH1 ARG A  54     -43.422  67.430 122.030  1.00  2.70           N  
ATOM    817  NH2 ARG A  54     -45.324  67.126 123.279  1.00  3.38           N  
ATOM    818  H   ARG A  54     -42.042  71.475 124.953  1.00  0.38           H  
ATOM    819  HA  ARG A  54     -42.418  73.078 122.684  1.00  0.50           H  
ATOM    820  HB2 ARG A  54     -42.513  70.618 122.690  1.00  1.00           H  
ATOM    821  HB3 ARG A  54     -44.010  70.681 123.606  1.00  0.96           H  
ATOM    822  HG2 ARG A  54     -45.161  71.708 121.764  1.00  1.79           H  
ATOM    823  HG3 ARG A  54     -43.654  71.847 120.853  1.00  1.63           H  
ATOM    824  HD2 ARG A  54     -45.005  69.944 120.096  1.00  1.80           H  
ATOM    825  HD3 ARG A  54     -43.461  69.425 120.769  1.00  1.77           H  
ATOM    826  HE  ARG A  54     -46.019  69.277 122.236  1.00  2.33           H  
ATOM    827 HH11 ARG A  54     -42.885  67.967 121.372  1.00  2.57           H  
ATOM    828 HH12 ARG A  54     -43.041  66.570 122.401  1.00  3.36           H  
ATOM    829 HH21 ARG A  54     -46.238  67.439 123.577  1.00  3.75           H  
ATOM    830 HH22 ARG A  54     -44.952  66.266 123.635  1.00  3.91           H  
ATOM    831  N   ILE A  55     -44.911  73.088 124.837  1.00  0.42           N  
ATOM    832  CA  ILE A  55     -46.130  73.796 125.224  1.00  0.47           C  
ATOM    833  C   ILE A  55     -45.838  75.247 125.606  1.00  0.49           C  
ATOM    834  O   ILE A  55     -46.567  76.161 125.222  1.00  0.59           O  
ATOM    835  CB  ILE A  55     -46.839  73.085 126.399  1.00  0.56           C  
ATOM    836  CG1 ILE A  55     -47.207  71.651 126.005  1.00  0.59           C  
ATOM    837  CG2 ILE A  55     -48.082  73.858 126.823  1.00  0.66           C  
ATOM    838  CD1 ILE A  55     -47.822  70.845 127.129  1.00  1.24           C  
ATOM    839  H   ILE A  55     -44.576  72.364 125.412  1.00  0.42           H  
ATOM    840  HA  ILE A  55     -46.796  73.790 124.373  1.00  0.51           H  
ATOM    841  HB  ILE A  55     -46.159  73.058 127.238  1.00  0.58           H  
ATOM    842 HG12 ILE A  55     -47.918  71.678 125.193  1.00  0.98           H  
ATOM    843 HG13 ILE A  55     -46.316  71.137 125.678  1.00  0.81           H  
ATOM    844 HG21 ILE A  55     -47.801  74.862 127.107  1.00  1.28           H  
ATOM    845 HG22 ILE A  55     -48.543  73.363 127.663  1.00  1.31           H  
ATOM    846 HG23 ILE A  55     -48.780  73.900 125.999  1.00  1.05           H  
ATOM    847 HD11 ILE A  55     -48.739  71.316 127.450  1.00  1.72           H  
ATOM    848 HD12 ILE A  55     -47.133  70.797 127.959  1.00  1.64           H  
ATOM    849 HD13 ILE A  55     -48.035  69.844 126.780  1.00  1.86           H  
ATOM    850  N   LEU A  56     -44.762  75.452 126.353  1.00  0.45           N  
ATOM    851  CA  LEU A  56     -44.400  76.778 126.834  1.00  0.52           C  
ATOM    852  C   LEU A  56     -43.876  77.647 125.690  1.00  0.53           C  
ATOM    853  O   LEU A  56     -44.211  78.828 125.588  1.00  0.65           O  
ATOM    854  CB  LEU A  56     -43.346  76.645 127.947  1.00  0.57           C  
ATOM    855  CG  LEU A  56     -43.024  77.917 128.744  1.00  0.75           C  
ATOM    856  CD1 LEU A  56     -42.427  77.549 130.093  1.00  1.04           C  
ATOM    857  CD2 LEU A  56     -42.054  78.812 127.987  1.00  1.63           C  
ATOM    858  H   LEU A  56     -44.194  74.687 126.592  1.00  0.43           H  
ATOM    859  HA  LEU A  56     -45.286  77.237 127.244  1.00  0.58           H  
ATOM    860  HB2 LEU A  56     -43.690  75.895 128.644  1.00  0.80           H  
ATOM    861  HB3 LEU A  56     -42.429  76.292 127.496  1.00  0.91           H  
ATOM    862  HG  LEU A  56     -43.935  78.472 128.916  1.00  1.49           H  
ATOM    863 HD11 LEU A  56     -41.520  76.979 129.942  1.00  1.54           H  
ATOM    864 HD12 LEU A  56     -43.136  76.957 130.653  1.00  1.58           H  
ATOM    865 HD13 LEU A  56     -42.196  78.450 130.641  1.00  1.71           H  
ATOM    866 HD21 LEU A  56     -41.127  78.283 127.828  1.00  2.07           H  
ATOM    867 HD22 LEU A  56     -41.866  79.707 128.565  1.00  2.18           H  
ATOM    868 HD23 LEU A  56     -42.483  79.081 127.034  1.00  2.18           H  
ATOM    869  N   LEU A  57     -43.063  77.049 124.830  1.00  0.51           N  
ATOM    870  CA  LEU A  57     -42.412  77.768 123.744  1.00  0.63           C  
ATOM    871  C   LEU A  57     -43.422  78.138 122.656  1.00  0.72           C  
ATOM    872  O   LEU A  57     -43.406  79.264 122.144  1.00  1.16           O  
ATOM    873  CB  LEU A  57     -41.283  76.889 123.178  1.00  0.80           C  
ATOM    874  CG  LEU A  57     -40.277  77.552 122.227  1.00  1.29           C  
ATOM    875  CD1 LEU A  57     -40.896  77.836 120.870  1.00  1.68           C  
ATOM    876  CD2 LEU A  57     -39.718  78.825 122.844  1.00  2.17           C  
ATOM    877  H   LEU A  57     -42.887  76.088 124.930  1.00  0.50           H  
ATOM    878  HA  LEU A  57     -41.986  78.674 124.151  1.00  0.78           H  
ATOM    879  HB2 LEU A  57     -40.728  76.486 124.013  1.00  0.76           H  
ATOM    880  HB3 LEU A  57     -41.742  76.063 122.655  1.00  1.22           H  
ATOM    881  HG  LEU A  57     -39.451  76.874 122.072  1.00  1.88           H  
ATOM    882 HD11 LEU A  57     -40.161  78.304 120.228  1.00  2.05           H  
ATOM    883 HD12 LEU A  57     -41.741  78.499 120.991  1.00  2.10           H  
ATOM    884 HD13 LEU A  57     -41.227  76.911 120.422  1.00  2.29           H  
ATOM    885 HD21 LEU A  57     -38.993  79.260 122.174  1.00  2.62           H  
ATOM    886 HD22 LEU A  57     -39.244  78.592 123.786  1.00  2.62           H  
ATOM    887 HD23 LEU A  57     -40.522  79.528 123.010  1.00  2.71           H  
ATOM    888  N   GLN A  58     -44.277  77.176 122.299  1.00  0.61           N  
ATOM    889  CA  GLN A  58     -45.269  77.352 121.234  1.00  0.79           C  
ATOM    890  C   GLN A  58     -46.012  78.681 121.371  1.00  1.05           C  
ATOM    891  O   GLN A  58     -46.778  78.890 122.317  1.00  2.03           O  
ATOM    892  CB  GLN A  58     -46.263  76.191 121.248  1.00  0.90           C  
ATOM    893  CG  GLN A  58     -47.199  76.164 120.050  1.00  1.29           C  
ATOM    894  CD  GLN A  58     -48.115  74.955 120.057  1.00  1.60           C  
ATOM    895  OE1 GLN A  58     -48.503  74.447 119.005  1.00  2.30           O  
ATOM    896  NE2 GLN A  58     -48.470  74.489 121.243  1.00  1.85           N  
ATOM    897  H   GLN A  58     -44.233  76.309 122.758  1.00  0.72           H  
ATOM    898  HA  GLN A  58     -44.743  77.347 120.292  1.00  1.13           H  
ATOM    899  HB2 GLN A  58     -45.710  75.263 121.268  1.00  1.42           H  
ATOM    900  HB3 GLN A  58     -46.864  76.259 122.143  1.00  1.26           H  
ATOM    901  HG2 GLN A  58     -47.806  77.055 120.064  1.00  1.74           H  
ATOM    902  HG3 GLN A  58     -46.606  76.144 119.147  1.00  1.78           H  
ATOM    903 HE21 GLN A  58     -48.127  74.943 122.041  1.00  2.17           H  
ATOM    904 HE22 GLN A  58     -49.060  73.701 121.275  1.00  2.16           H  
ATOM    905  N   GLY A  59     -45.775  79.570 120.418  1.00  0.97           N  
ATOM    906  CA  GLY A  59     -46.376  80.888 120.459  1.00  1.28           C  
ATOM    907  C   GLY A  59     -45.352  81.984 120.240  1.00  1.13           C  
ATOM    908  O   GLY A  59     -45.708  83.137 120.013  1.00  1.42           O  
ATOM    909  H   GLY A  59     -45.188  79.329 119.672  1.00  1.43           H  
ATOM    910  HA2 GLY A  59     -47.129  80.954 119.688  1.00  1.61           H  
ATOM    911  HA3 GLY A  59     -46.843  81.029 121.421  1.00  1.62           H  
ATOM    912  N   THR A  60     -44.077  81.627 120.330  1.00  0.95           N  
ATOM    913  CA  THR A  60     -42.999  82.589 120.132  1.00  0.99           C  
ATOM    914  C   THR A  60     -42.280  82.381 118.794  1.00  1.06           C  
ATOM    915  O   THR A  60     -41.323  83.092 118.478  1.00  1.25           O  
ATOM    916  CB  THR A  60     -41.972  82.507 121.275  1.00  1.04           C  
ATOM    917  OG1 THR A  60     -41.546  81.149 121.440  1.00  0.99           O  
ATOM    918  CG2 THR A  60     -42.562  83.023 122.581  1.00  1.21           C  
ATOM    919  H   THR A  60     -43.855  80.702 120.571  1.00  1.05           H  
ATOM    920  HA  THR A  60     -43.433  83.578 120.141  1.00  1.14           H  
ATOM    921  HB  THR A  60     -41.117  83.116 121.018  1.00  1.18           H  
ATOM    922  HG1 THR A  60     -42.195  80.668 121.970  1.00  1.18           H  
ATOM    923 HG21 THR A  60     -41.831  82.922 123.369  1.00  1.76           H  
ATOM    924 HG22 THR A  60     -43.441  82.451 122.830  1.00  1.56           H  
ATOM    925 HG23 THR A  60     -42.831  84.065 122.469  1.00  1.56           H  
ATOM    926  N   GLY A  61     -42.765  81.426 118.001  1.00  1.08           N  
ATOM    927  CA  GLY A  61     -42.130  81.099 116.728  1.00  1.32           C  
ATOM    928  C   GLY A  61     -40.665  80.701 116.847  1.00  1.26           C  
ATOM    929  O   GLY A  61     -39.902  80.832 115.888  1.00  1.35           O  
ATOM    930  H   GLY A  61     -43.605  80.982 118.240  1.00  1.05           H  
ATOM    931  HA2 GLY A  61     -42.669  80.279 116.275  1.00  1.48           H  
ATOM    932  HA3 GLY A  61     -42.202  81.957 116.077  1.00  1.50           H  
ATOM    933  N   LEU A  62     -40.267  80.200 118.008  1.00  1.16           N  
ATOM    934  CA  LEU A  62     -38.879  79.820 118.234  1.00  1.11           C  
ATOM    935  C   LEU A  62     -38.710  78.308 118.094  1.00  1.07           C  
ATOM    936  O   LEU A  62     -39.691  77.572 117.994  1.00  1.14           O  
ATOM    937  CB  LEU A  62     -38.426  80.272 119.626  1.00  1.10           C  
ATOM    938  CG  LEU A  62     -38.570  81.772 119.902  1.00  1.19           C  
ATOM    939  CD1 LEU A  62     -38.124  82.095 121.317  1.00  1.23           C  
ATOM    940  CD2 LEU A  62     -37.769  82.582 118.895  1.00  1.28           C  
ATOM    941  H   LEU A  62     -40.915  80.073 118.728  1.00  1.16           H  
ATOM    942  HA  LEU A  62     -38.273  80.309 117.489  1.00  1.15           H  
ATOM    943  HB2 LEU A  62     -39.004  79.737 120.362  1.00  1.07           H  
ATOM    944  HB3 LEU A  62     -37.386  80.009 119.747  1.00  1.10           H  
ATOM    945  HG  LEU A  62     -39.610  82.051 119.807  1.00  1.20           H  
ATOM    946 HD11 LEU A  62     -37.090  81.815 121.442  1.00  1.61           H  
ATOM    947 HD12 LEU A  62     -38.734  81.545 122.020  1.00  1.60           H  
ATOM    948 HD13 LEU A  62     -38.234  83.154 121.495  1.00  1.56           H  
ATOM    949 HD21 LEU A  62     -38.115  82.361 117.898  1.00  1.77           H  
ATOM    950 HD22 LEU A  62     -36.723  82.324 118.979  1.00  1.69           H  
ATOM    951 HD23 LEU A  62     -37.898  83.635 119.095  1.00  1.48           H  
ATOM    952  N   ARG A  63     -37.469  77.853 118.059  1.00  1.01           N  
ATOM    953  CA  ARG A  63     -37.182  76.429 117.991  1.00  1.03           C  
ATOM    954  C   ARG A  63     -36.326  76.014 119.181  1.00  0.92           C  
ATOM    955  O   ARG A  63     -35.275  76.606 119.440  1.00  0.87           O  
ATOM    956  CB  ARG A  63     -36.468  76.064 116.682  1.00  1.15           C  
ATOM    957  CG  ARG A  63     -37.402  75.787 115.507  1.00  1.51           C  
ATOM    958  CD  ARG A  63     -38.168  77.023 115.070  1.00  1.78           C  
ATOM    959  NE  ARG A  63     -39.052  76.746 113.937  1.00  2.51           N  
ATOM    960  CZ  ARG A  63     -39.780  77.667 113.311  1.00  3.28           C  
ATOM    961  NH1 ARG A  63     -39.769  78.923 113.734  1.00  3.53           N  
ATOM    962  NH2 ARG A  63     -40.540  77.323 112.278  1.00  4.21           N  
ATOM    963  H   ARG A  63     -36.719  78.492 118.092  1.00  0.98           H  
ATOM    964  HA  ARG A  63     -38.121  75.898 118.039  1.00  1.10           H  
ATOM    965  HB2 ARG A  63     -35.819  76.881 116.406  1.00  1.37           H  
ATOM    966  HB3 ARG A  63     -35.868  75.183 116.850  1.00  1.62           H  
ATOM    967  HG2 ARG A  63     -36.815  75.429 114.676  1.00  2.06           H  
ATOM    968  HG3 ARG A  63     -38.109  75.024 115.801  1.00  2.12           H  
ATOM    969  HD2 ARG A  63     -38.763  77.373 115.899  1.00  2.18           H  
ATOM    970  HD3 ARG A  63     -37.463  77.790 114.784  1.00  2.07           H  
ATOM    971  HE  ARG A  63     -39.100  75.804 113.620  1.00  2.84           H  
ATOM    972 HH11 ARG A  63     -39.218  79.185 114.526  1.00  3.28           H  
ATOM    973 HH12 ARG A  63     -40.314  79.627 113.258  1.00  4.26           H  
ATOM    974 HH21 ARG A  63     -40.569  76.360 111.970  1.00  4.48           H  
ATOM    975 HH22 ARG A  63     -41.085  78.018 111.792  1.00  4.83           H  
ATOM    976  N   TYR A  64     -36.784  75.009 119.910  1.00  0.96           N  
ATOM    977  CA  TYR A  64     -36.064  74.536 121.082  1.00  0.91           C  
ATOM    978  C   TYR A  64     -35.268  73.275 120.759  1.00  0.89           C  
ATOM    979  O   TYR A  64     -35.806  72.299 120.237  1.00  0.94           O  
ATOM    980  CB  TYR A  64     -37.018  74.292 122.264  1.00  0.92           C  
ATOM    981  CG  TYR A  64     -37.994  73.148 122.075  1.00  0.97           C  
ATOM    982  CD1 TYR A  64     -39.146  73.299 121.313  1.00  1.02           C  
ATOM    983  CD2 TYR A  64     -37.764  71.916 122.674  1.00  1.06           C  
ATOM    984  CE1 TYR A  64     -40.039  72.257 121.153  1.00  1.14           C  
ATOM    985  CE2 TYR A  64     -38.649  70.868 122.517  1.00  1.18           C  
ATOM    986  CZ  TYR A  64     -39.787  71.042 121.758  1.00  1.20           C  
ATOM    987  OH  TYR A  64     -40.673  70.002 121.609  1.00  1.37           O  
ATOM    988  H   TYR A  64     -37.617  74.572 119.637  1.00  1.06           H  
ATOM    989  HA  TYR A  64     -35.362  75.312 121.361  1.00  0.93           H  
ATOM    990  HB2 TYR A  64     -36.433  74.077 123.145  1.00  0.93           H  
ATOM    991  HB3 TYR A  64     -37.593  75.191 122.437  1.00  0.97           H  
ATOM    992  HD1 TYR A  64     -39.340  74.253 120.838  1.00  1.03           H  
ATOM    993  HD2 TYR A  64     -36.872  71.782 123.268  1.00  1.10           H  
ATOM    994  HE1 TYR A  64     -40.927  72.395 120.555  1.00  1.23           H  
ATOM    995  HE2 TYR A  64     -38.449  69.918 122.990  1.00  1.29           H  
ATOM    996  HH  TYR A  64     -40.801  69.574 122.462  1.00  1.93           H  
ATOM    997  N   GLN A  65     -33.979  73.320 121.039  1.00  0.90           N  
ATOM    998  CA  GLN A  65     -33.113  72.164 120.870  1.00  0.93           C  
ATOM    999  C   GLN A  65     -32.856  71.512 122.219  1.00  0.87           C  
ATOM   1000  O   GLN A  65     -32.176  72.087 123.070  1.00  0.86           O  
ATOM   1001  CB  GLN A  65     -31.779  72.582 120.249  1.00  1.03           C  
ATOM   1002  CG  GLN A  65     -31.899  73.172 118.855  1.00  1.59           C  
ATOM   1003  CD  GLN A  65     -30.575  73.698 118.343  1.00  2.07           C  
ATOM   1004  OE1 GLN A  65     -29.798  72.973 117.721  1.00  2.64           O  
ATOM   1005  NE2 GLN A  65     -30.301  74.966 118.613  1.00  2.63           N  
ATOM   1006  H   GLN A  65     -33.588  74.166 121.354  1.00  0.94           H  
ATOM   1007  HA  GLN A  65     -33.608  71.461 120.219  1.00  0.96           H  
ATOM   1008  HB2 GLN A  65     -31.315  73.319 120.887  1.00  1.44           H  
ATOM   1009  HB3 GLN A  65     -31.136  71.714 120.196  1.00  1.30           H  
ATOM   1010  HG2 GLN A  65     -32.249  72.404 118.180  1.00  2.12           H  
ATOM   1011  HG3 GLN A  65     -32.610  73.985 118.879  1.00  2.11           H  
ATOM   1012 HE21 GLN A  65     -30.961  75.481 119.120  1.00  2.85           H  
ATOM   1013 HE22 GLN A  65     -29.449  75.339 118.291  1.00  3.17           H  
ATOM   1014  N   ILE A  66     -33.408  70.329 122.424  1.00  0.88           N  
ATOM   1015  CA  ILE A  66     -33.203  69.612 123.673  1.00  0.86           C  
ATOM   1016  C   ILE A  66     -32.219  68.461 123.472  1.00  0.98           C  
ATOM   1017  O   ILE A  66     -32.481  67.518 122.724  1.00  1.11           O  
ATOM   1018  CB  ILE A  66     -34.535  69.096 124.275  1.00  0.92           C  
ATOM   1019  CG1 ILE A  66     -34.259  68.220 125.504  1.00  1.02           C  
ATOM   1020  CG2 ILE A  66     -35.352  68.342 123.231  1.00  1.28           C  
ATOM   1021  CD1 ILE A  66     -35.506  67.720 126.192  1.00  1.13           C  
ATOM   1022  H   ILE A  66     -33.945  69.917 121.712  1.00  0.94           H  
ATOM   1023  HA  ILE A  66     -32.769  70.310 124.377  1.00  0.82           H  
ATOM   1024  HB  ILE A  66     -35.114  69.956 124.584  1.00  1.05           H  
ATOM   1025 HG12 ILE A  66     -33.683  67.360 125.202  1.00  1.25           H  
ATOM   1026 HG13 ILE A  66     -33.690  68.792 126.223  1.00  1.16           H  
ATOM   1027 HG21 ILE A  66     -34.767  67.523 122.839  1.00  1.56           H  
ATOM   1028 HG22 ILE A  66     -35.617  69.013 122.428  1.00  1.77           H  
ATOM   1029 HG23 ILE A  66     -36.252  67.955 123.689  1.00  1.84           H  
ATOM   1030 HD11 ILE A  66     -36.103  68.562 126.513  1.00  1.52           H  
ATOM   1031 HD12 ILE A  66     -35.229  67.126 127.053  1.00  1.71           H  
ATOM   1032 HD13 ILE A  66     -36.078  67.114 125.505  1.00  1.37           H  
ATOM   1033  N   ASP A  67     -31.072  68.562 124.122  1.00  1.04           N  
ATOM   1034  CA  ASP A  67     -30.027  67.557 124.001  1.00  1.25           C  
ATOM   1035  C   ASP A  67     -29.452  67.223 125.371  1.00  1.20           C  
ATOM   1036  O   ASP A  67     -28.640  67.975 125.908  1.00  1.13           O  
ATOM   1037  CB  ASP A  67     -28.912  68.061 123.077  1.00  1.45           C  
ATOM   1038  CG  ASP A  67     -27.841  67.018 122.840  1.00  1.82           C  
ATOM   1039  OD1 ASP A  67     -28.051  66.117 122.001  1.00  2.29           O  
ATOM   1040  OD2 ASP A  67     -26.780  67.097 123.500  1.00  2.28           O  
ATOM   1041  H   ASP A  67     -30.918  69.345 124.702  1.00  1.00           H  
ATOM   1042  HA  ASP A  67     -30.464  66.668 123.575  1.00  1.40           H  
ATOM   1043  HB2 ASP A  67     -29.340  68.333 122.125  1.00  1.77           H  
ATOM   1044  HB3 ASP A  67     -28.451  68.933 123.522  1.00  1.65           H  
ATOM   1045  N   GLY A  68     -29.882  66.099 125.930  1.00  1.28           N  
ATOM   1046  CA  GLY A  68     -29.421  65.692 127.247  1.00  1.30           C  
ATOM   1047  C   GLY A  68     -29.776  66.691 128.332  1.00  1.14           C  
ATOM   1048  O   GLY A  68     -30.933  66.788 128.745  1.00  1.18           O  
ATOM   1049  H   GLY A  68     -30.506  65.522 125.436  1.00  1.39           H  
ATOM   1050  HA2 GLY A  68     -29.863  64.737 127.494  1.00  1.45           H  
ATOM   1051  HA3 GLY A  68     -28.347  65.579 127.218  1.00  1.33           H  
ATOM   1052  N   ASN A  69     -28.782  67.443 128.783  1.00  1.03           N  
ATOM   1053  CA  ASN A  69     -28.994  68.458 129.810  1.00  0.94           C  
ATOM   1054  C   ASN A  69     -28.928  69.847 129.198  1.00  0.75           C  
ATOM   1055  O   ASN A  69     -28.933  70.849 129.906  1.00  0.69           O  
ATOM   1056  CB  ASN A  69     -27.944  68.353 130.921  1.00  1.06           C  
ATOM   1057  CG  ASN A  69     -28.062  67.088 131.749  1.00  1.67           C  
ATOM   1058  OD1 ASN A  69     -27.467  66.060 131.421  1.00  2.35           O  
ATOM   1059  ND2 ASN A  69     -28.811  67.156 132.839  1.00  2.29           N  
ATOM   1060  H   ASN A  69     -27.881  67.317 128.409  1.00  1.05           H  
ATOM   1061  HA  ASN A  69     -29.975  68.305 130.234  1.00  0.99           H  
ATOM   1062  HB2 ASN A  69     -26.960  68.371 130.477  1.00  1.47           H  
ATOM   1063  HB3 ASN A  69     -28.047  69.201 131.581  1.00  1.50           H  
ATOM   1064 HD21 ASN A  69     -29.246  68.011 133.054  1.00  2.39           H  
ATOM   1065 HD22 ASN A  69     -28.895  66.350 133.397  1.00  2.97           H  
ATOM   1066  N   THR A  70     -28.861  69.905 127.879  1.00  0.74           N  
ATOM   1067  CA  THR A  70     -28.744  71.170 127.180  1.00  0.68           C  
ATOM   1068  C   THR A  70     -30.035  71.508 126.442  1.00  0.63           C  
ATOM   1069  O   THR A  70     -30.550  70.703 125.667  1.00  0.71           O  
ATOM   1070  CB  THR A  70     -27.577  71.139 126.175  1.00  0.85           C  
ATOM   1071  OG1 THR A  70     -26.389  70.671 126.829  1.00  0.97           O  
ATOM   1072  CG2 THR A  70     -27.324  72.520 125.585  1.00  0.89           C  
ATOM   1073  H   THR A  70     -28.888  69.071 127.359  1.00  0.84           H  
ATOM   1074  HA  THR A  70     -28.545  71.942 127.910  1.00  0.63           H  
ATOM   1075  HB  THR A  70     -27.829  70.460 125.372  1.00  0.94           H  
ATOM   1076  HG1 THR A  70     -26.453  70.851 127.772  1.00  1.37           H  
ATOM   1077 HG21 THR A  70     -27.060  73.207 126.377  1.00  1.31           H  
ATOM   1078 HG22 THR A  70     -28.216  72.868 125.091  1.00  1.27           H  
ATOM   1079 HG23 THR A  70     -26.515  72.463 124.870  1.00  1.38           H  
ATOM   1080  N   VAL A  71     -30.562  72.690 126.711  1.00  0.56           N  
ATOM   1081  CA  VAL A  71     -31.727  73.193 126.010  1.00  0.58           C  
ATOM   1082  C   VAL A  71     -31.384  74.521 125.349  1.00  0.57           C  
ATOM   1083  O   VAL A  71     -31.153  75.521 126.025  1.00  0.57           O  
ATOM   1084  CB  VAL A  71     -32.932  73.387 126.957  1.00  0.60           C  
ATOM   1085  CG1 VAL A  71     -34.144  73.896 126.194  1.00  0.68           C  
ATOM   1086  CG2 VAL A  71     -33.267  72.089 127.681  1.00  0.65           C  
ATOM   1087  H   VAL A  71     -30.151  73.250 127.409  1.00  0.53           H  
ATOM   1088  HA  VAL A  71     -31.997  72.476 125.247  1.00  0.64           H  
ATOM   1089  HB  VAL A  71     -32.665  74.128 127.695  1.00  0.57           H  
ATOM   1090 HG11 VAL A  71     -34.980  73.988 126.869  1.00  1.27           H  
ATOM   1091 HG12 VAL A  71     -34.392  73.199 125.405  1.00  1.15           H  
ATOM   1092 HG13 VAL A  71     -33.921  74.863 125.764  1.00  1.25           H  
ATOM   1093 HG21 VAL A  71     -34.136  72.240 128.305  1.00  1.33           H  
ATOM   1094 HG22 VAL A  71     -32.429  71.796 128.296  1.00  1.07           H  
ATOM   1095 HG23 VAL A  71     -33.471  71.315 126.957  1.00  1.22           H  
ATOM   1096  N   THR A  72     -31.341  74.526 124.030  1.00  0.63           N  
ATOM   1097  CA  THR A  72     -30.962  75.716 123.292  1.00  0.66           C  
ATOM   1098  C   THR A  72     -32.164  76.291 122.551  1.00  0.70           C  
ATOM   1099  O   THR A  72     -32.687  75.676 121.621  1.00  0.78           O  
ATOM   1100  CB  THR A  72     -29.842  75.403 122.279  1.00  0.75           C  
ATOM   1101  OG1 THR A  72     -28.783  74.679 122.927  1.00  0.76           O  
ATOM   1102  CG2 THR A  72     -29.291  76.681 121.668  1.00  0.80           C  
ATOM   1103  H   THR A  72     -31.579  73.710 123.537  1.00  0.67           H  
ATOM   1104  HA  THR A  72     -30.595  76.449 123.995  1.00  0.63           H  
ATOM   1105  HB  THR A  72     -30.254  74.790 121.488  1.00  0.81           H  
ATOM   1106  HG1 THR A  72     -28.170  75.302 123.345  1.00  0.91           H  
ATOM   1107 HG21 THR A  72     -30.086  77.209 121.162  1.00  1.36           H  
ATOM   1108 HG22 THR A  72     -28.515  76.433 120.957  1.00  1.22           H  
ATOM   1109 HG23 THR A  72     -28.881  77.306 122.445  1.00  1.34           H  
ATOM   1110  N   VAL A  73     -32.608  77.464 122.974  1.00  0.70           N  
ATOM   1111  CA  VAL A  73     -33.737  78.122 122.343  1.00  0.76           C  
ATOM   1112  C   VAL A  73     -33.242  79.082 121.269  1.00  0.90           C  
ATOM   1113  O   VAL A  73     -32.716  80.153 121.571  1.00  1.01           O  
ATOM   1114  CB  VAL A  73     -34.595  78.890 123.369  1.00  0.79           C  
ATOM   1115  CG1 VAL A  73     -35.831  79.476 122.704  1.00  0.89           C  
ATOM   1116  CG2 VAL A  73     -34.988  77.981 124.527  1.00  0.75           C  
ATOM   1117  H   VAL A  73     -32.155  77.907 123.728  1.00  0.69           H  
ATOM   1118  HA  VAL A  73     -34.355  77.361 121.881  1.00  0.76           H  
ATOM   1119  HB  VAL A  73     -34.004  79.703 123.764  1.00  0.85           H  
ATOM   1120 HG11 VAL A  73     -36.426  79.991 123.441  1.00  1.41           H  
ATOM   1121 HG12 VAL A  73     -36.411  78.680 122.262  1.00  1.42           H  
ATOM   1122 HG13 VAL A  73     -35.529  80.171 121.933  1.00  1.24           H  
ATOM   1123 HG21 VAL A  73     -35.592  78.534 125.230  1.00  1.29           H  
ATOM   1124 HG22 VAL A  73     -34.098  77.621 125.018  1.00  1.18           H  
ATOM   1125 HG23 VAL A  73     -35.553  77.143 124.145  1.00  1.24           H  
ATOM   1126  N   THR A  74     -33.390  78.685 120.016  1.00  0.97           N  
ATOM   1127  CA  THR A  74     -32.930  79.493 118.904  1.00  1.15           C  
ATOM   1128  C   THR A  74     -34.116  79.998 118.088  1.00  1.11           C  
ATOM   1129  O   THR A  74     -35.196  79.401 118.107  1.00  0.99           O  
ATOM   1130  CB  THR A  74     -31.959  78.701 117.995  1.00  1.38           C  
ATOM   1131  OG1 THR A  74     -31.477  79.540 116.938  1.00  1.87           O  
ATOM   1132  CG2 THR A  74     -32.639  77.473 117.400  1.00  1.47           C  
ATOM   1133  H   THR A  74     -33.839  77.829 119.834  1.00  0.94           H  
ATOM   1134  HA  THR A  74     -32.397  80.342 119.309  1.00  1.28           H  
ATOM   1135  HB  THR A  74     -31.121  78.374 118.592  1.00  1.80           H  
ATOM   1136  HG1 THR A  74     -30.706  79.132 116.526  1.00  2.29           H  
ATOM   1137 HG21 THR A  74     -32.970  76.826 118.199  1.00  1.89           H  
ATOM   1138 HG22 THR A  74     -31.938  76.942 116.772  1.00  1.88           H  
ATOM   1139 HG23 THR A  74     -33.490  77.781 116.811  1.00  1.86           H  
ATOM   1140  N   ALA A  75     -33.918  81.102 117.384  1.00  1.29           N  
ATOM   1141  CA  ALA A  75     -34.954  81.668 116.549  1.00  1.36           C  
ATOM   1142  C   ALA A  75     -34.701  81.324 115.090  1.00  1.48           C  
ATOM   1143  O   ALA A  75     -33.772  81.848 114.475  1.00  1.72           O  
ATOM   1144  CB  ALA A  75     -35.018  83.174 116.737  1.00  1.56           C  
ATOM   1145  H   ALA A  75     -33.046  81.538 117.415  1.00  1.44           H  
ATOM   1146  HA  ALA A  75     -35.892  81.245 116.857  1.00  1.31           H  
ATOM   1147  HB1 ALA A  75     -35.194  83.398 117.778  1.00  2.10           H  
ATOM   1148  HB2 ALA A  75     -35.826  83.578 116.141  1.00  1.94           H  
ATOM   1149  HB3 ALA A  75     -34.084  83.616 116.424  1.00  1.65           H  
ATOM   1150  N   SER A  76     -35.515  80.437 114.545  1.00  1.52           N  
ATOM   1151  CA  SER A  76     -35.376  80.027 113.157  1.00  1.75           C  
ATOM   1152  C   SER A  76     -36.423  80.720 112.293  1.00  2.24           C  
ATOM   1153  O   SER A  76     -37.596  80.348 112.307  1.00  2.81           O  
ATOM   1154  CB  SER A  76     -35.520  78.510 113.043  1.00  2.10           C  
ATOM   1155  OG  SER A  76     -34.628  77.849 113.928  1.00  2.68           O  
ATOM   1156  H   SER A  76     -36.228  80.046 115.089  1.00  1.53           H  
ATOM   1157  HA  SER A  76     -34.392  80.317 112.819  1.00  2.01           H  
ATOM   1158  HB2 SER A  76     -36.531  78.224 113.290  1.00  2.33           H  
ATOM   1159  HB3 SER A  76     -35.295  78.202 112.033  1.00  2.58           H  
ATOM   1160  HG  SER A  76     -33.721  78.128 113.732  1.00  3.10           H  
ATOM   1161  N   ALA A  77     -35.995  81.730 111.550  1.00  2.71           N  
ATOM   1162  CA  ALA A  77     -36.897  82.493 110.694  1.00  3.56           C  
ATOM   1163  C   ALA A  77     -37.130  81.779 109.366  1.00  4.02           C  
ATOM   1164  O   ALA A  77     -36.962  82.359 108.292  1.00  4.62           O  
ATOM   1165  CB  ALA A  77     -36.342  83.891 110.462  1.00  4.29           C  
ATOM   1166  H   ALA A  77     -35.038  81.971 111.573  1.00  2.83           H  
ATOM   1167  HA  ALA A  77     -37.841  82.588 111.209  1.00  3.84           H  
ATOM   1168  HB1 ALA A  77     -37.033  84.455 109.854  1.00  4.81           H  
ATOM   1169  HB2 ALA A  77     -35.390  83.822 109.954  1.00  4.57           H  
ATOM   1170  HB3 ALA A  77     -36.207  84.390 111.409  1.00  4.49           H  
ATOM   1171  N   ALA A  78     -37.522  80.518 109.443  1.00  4.20           N  
ATOM   1172  CA  ALA A  78     -37.773  79.723 108.255  1.00  5.03           C  
ATOM   1173  C   ALA A  78     -38.983  78.824 108.458  1.00  5.55           C  
ATOM   1174  O   ALA A  78     -39.024  78.031 109.399  1.00  5.99           O  
ATOM   1175  CB  ALA A  78     -36.549  78.890 107.906  1.00  5.72           C  
ATOM   1176  H   ALA A  78     -37.651  80.110 110.327  1.00  4.08           H  
ATOM   1177  HA  ALA A  78     -37.969  80.398 107.433  1.00  5.18           H  
ATOM   1178  HB1 ALA A  78     -36.743  78.325 107.008  1.00  5.90           H  
ATOM   1179  HB2 ALA A  78     -36.334  78.210 108.719  1.00  6.13           H  
ATOM   1180  HB3 ALA A  78     -35.702  79.541 107.748  1.00  6.02           H  
ATOM   1181  N   ALA A  79     -39.971  78.961 107.584  1.00  5.86           N  
ATOM   1182  CA  ALA A  79     -41.155  78.109 107.624  1.00  6.63           C  
ATOM   1183  C   ALA A  79     -40.847  76.741 107.020  1.00  7.15           C  
ATOM   1184  O   ALA A  79     -41.441  76.337 106.016  1.00  7.46           O  
ATOM   1185  CB  ALA A  79     -42.312  78.777 106.897  1.00  6.90           C  
ATOM   1186  H   ALA A  79     -39.908  79.657 106.894  1.00  5.79           H  
ATOM   1187  HA  ALA A  79     -41.436  77.976 108.660  1.00  6.98           H  
ATOM   1188  HB1 ALA A  79     -42.058  78.902 105.855  1.00  6.78           H  
ATOM   1189  HB2 ALA A  79     -42.505  79.744 107.340  1.00  7.23           H  
ATOM   1190  HB3 ALA A  79     -43.195  78.161 106.980  1.00  7.19           H  
ATOM   1191  N   LYS A  80     -39.909  76.042 107.640  1.00  7.55           N  
ATOM   1192  CA  LYS A  80     -39.459  74.747 107.165  1.00  8.34           C  
ATOM   1193  C   LYS A  80     -38.822  73.983 108.323  1.00  8.95           C  
ATOM   1194  O   LYS A  80     -37.600  73.987 108.482  1.00  9.25           O  
ATOM   1195  CB  LYS A  80     -38.435  74.931 106.040  1.00  8.77           C  
ATOM   1196  CG  LYS A  80     -38.147  73.666 105.248  1.00  9.05           C  
ATOM   1197  CD  LYS A  80     -36.893  73.827 104.400  1.00  9.51           C  
ATOM   1198  CE  LYS A  80     -36.722  72.684 103.408  1.00 10.08           C  
ATOM   1199  NZ  LYS A  80     -37.737  72.732 102.321  1.00 10.73           N  
ATOM   1200  H   LYS A  80     -39.499  76.417 108.455  1.00  7.51           H  
ATOM   1201  HA  LYS A  80     -40.313  74.198 106.795  1.00  8.49           H  
ATOM   1202  HB2 LYS A  80     -38.804  75.679 105.356  1.00  8.79           H  
ATOM   1203  HB3 LYS A  80     -37.509  75.279 106.472  1.00  9.15           H  
ATOM   1204  HG2 LYS A  80     -38.004  72.845 105.933  1.00  9.07           H  
ATOM   1205  HG3 LYS A  80     -38.983  73.459 104.601  1.00  9.19           H  
ATOM   1206  HD2 LYS A  80     -36.959  74.754 103.854  1.00  9.69           H  
ATOM   1207  HD3 LYS A  80     -36.033  73.854 105.054  1.00  9.51           H  
ATOM   1208  HE2 LYS A  80     -35.738  72.750 102.973  1.00 10.22           H  
ATOM   1209  HE3 LYS A  80     -36.820  71.749 103.940  1.00 10.11           H  
ATOM   1210  HZ1 LYS A  80     -37.767  73.690 101.903  1.00 11.03           H  
ATOM   1211  HZ2 LYS A  80     -38.683  72.494 102.690  1.00 10.82           H  
ATOM   1212  HZ3 LYS A  80     -37.491  72.053 101.571  1.00 11.03           H  
ATOM   1213  N   ASP A  81     -39.652  73.347 109.137  1.00  9.36           N  
ATOM   1214  CA  ASP A  81     -39.165  72.640 110.315  1.00 10.16           C  
ATOM   1215  C   ASP A  81     -38.793  71.204 109.976  1.00 10.60           C  
ATOM   1216  O   ASP A  81     -39.432  70.564 109.138  1.00 11.03           O  
ATOM   1217  CB  ASP A  81     -40.213  72.645 111.432  1.00 10.60           C  
ATOM   1218  CG  ASP A  81     -40.352  73.992 112.115  1.00 11.07           C  
ATOM   1219  OD1 ASP A  81     -39.531  74.308 113.003  1.00 11.19           O  
ATOM   1220  OD2 ASP A  81     -41.267  74.758 111.748  1.00 11.50           O  
ATOM   1221  H   ASP A  81     -40.617  73.346 108.939  1.00  9.27           H  
ATOM   1222  HA  ASP A  81     -38.281  73.152 110.664  1.00 10.37           H  
ATOM   1223  HB2 ASP A  81     -41.172  72.380 111.011  1.00 10.52           H  
ATOM   1224  HB3 ASP A  81     -39.938  71.911 112.174  1.00 10.92           H  
ATOM   1225  N   GLY A  82     -37.759  70.706 110.635  1.00 10.72           N  
ATOM   1226  CA  GLY A  82     -37.309  69.352 110.405  1.00 11.37           C  
ATOM   1227  C   GLY A  82     -36.620  68.785 111.626  1.00 11.77           C  
ATOM   1228  O   GLY A  82     -36.656  67.554 111.819  1.00 12.00           O  
ATOM   1229  OXT GLY A  82     -36.047  69.575 112.405  1.00 12.03           O  
ATOM   1230  H   GLY A  82     -37.295  71.263 111.298  1.00 10.51           H  
ATOM   1231  HA2 GLY A  82     -38.160  68.735 110.162  1.00 11.67           H  
ATOM   1232  HA3 GLY A  82     -36.619  69.347 109.576  1.00 11.51           H  
TER    1233      GLY A  82                                                      
END
MOLECULE T0424_94_177.pdb
ATOM    631  N   LEU    94     -30.472  64.408 127.901  1.00 31.32          
ATOM    632  CA  LEU    94     -30.886  64.905 129.205  1.00 32.87          
ATOM    633  C   LEU    94     -32.322  65.427 129.206  1.00 33.92          
ATOM    634  O   LEU    94     -32.903  65.626 130.272  1.00 35.10          
ATOM    635  CB  LEU    94     -29.910  65.974 129.722  1.00 33.73          
ATOM    636  CG  LEU    94     -28.424  65.627 129.839  1.00 32.67          
ATOM    637  CD1 LEU    94     -27.614  66.889 130.295  1.00 35.22          
ATOM    638  CD2 LEU    94     -28.201  64.465 130.777  1.00 36.22          
ATOM    639  N   ALA    95     -32.898  65.651 128.017  1.00 34.10          
ATOM    640  CA  ALA    95     -34.322  65.969 127.907  1.00 33.68          
ATOM    641  C   ALA    95     -35.155  64.865 128.454  1.00 33.59          
ATOM    642  O   ALA    95     -36.242  65.114 128.802  1.00 34.14          
ATOM    643  CB  ALA    95     -34.719  66.234 126.452  1.00 33.56          
ATOM    644  N   GLY    96     -34.670  63.617 128.470  1.00 34.66          
ATOM    645  CA  GLY    96     -35.368  62.512 129.122  1.00 34.70          
ATOM    646  C   GLY    96     -35.872  62.796 130.538  1.00 35.90          
ATOM    647  O   GLY    96     -36.962  62.417 130.865  1.00 34.43          
ATOM    648  N   PHE    97     -35.065  63.447 131.378  1.00 36.84          
ATOM    649  CA  PHE    97     -35.525  63.962 132.659  1.00 38.40          
ATOM    650  C   PHE    97     -36.748  64.897 132.567  1.00 39.55          
ATOM    651  O   PHE    97     -37.732  64.733 133.280  1.00 39.69          
ATOM    652  CB  PHE    97     -34.412  64.763 133.346  1.00 39.36          
ATOM    653  CG  PHE    97     -33.257  63.921 133.826  1.00 40.36          
ATOM    654  CD1 PHE    97     -33.431  63.017 134.884  1.00 39.09          
ATOM    655  CD2 PHE    97     -31.987  64.059 133.235  1.00 40.34          
ATOM    656  CE1 PHE    97     -32.368  62.255 135.343  1.00 39.78          
ATOM    657  CE2 PHE    97     -30.914  63.298 133.678  1.00 40.54          
ATOM    658  CZ  PHE    97     -31.100  62.395 134.751  1.00 40.74          
ATOM    659  N   LEU    98     -36.672  65.894 131.694  1.00 40.37          
ATOM    660  CA  LEU    98     -37.772  66.857 131.533  1.00 40.15          
ATOM    661  C   LEU    98     -39.030  66.214 130.937  1.00 39.84          
ATOM    662  O   LEU    98     -40.129  66.541 131.332  1.00 39.74          
ATOM    663  CB  LEU    98     -37.295  68.022 130.673  1.00 40.91          
ATOM    664  CG  LEU    98     -35.984  68.692 131.136  1.00 43.39          
ATOM    665  CD1 LEU    98     -35.953  70.177 130.823  1.00 43.56          
ATOM    666  CD2 LEU    98     -35.758  68.472 132.615  1.00 42.31          
ATOM    667  N   VAL    99     -38.852  65.269 130.009  1.00 39.53          
ATOM    668  CA  VAL    99     -39.957  64.488 129.435  1.00 39.36          
ATOM    669  C   VAL    99     -40.648  63.600 130.446  1.00 40.07          
ATOM    670  O   VAL    99     -41.878  63.367 130.373  1.00 39.79          
ATOM    671  CB  VAL    99     -39.471  63.564 128.251  1.00 39.09          
ATOM    672  CG1 VAL    99     -40.508  62.518 127.940  1.00 36.51          
ATOM    673  CG2 VAL    99     -39.104  64.394 127.002  1.00 36.11          
ATOM    674  N   ASP   100     -39.857  63.064 131.370  1.00 40.79          
ATOM    675  CA  ASP   100     -40.359  62.121 132.363  1.00 41.66          
ATOM    676  C   ASP   100     -40.960  62.854 133.571  1.00 42.67          
ATOM    677  O   ASP   100     -41.981  62.449 134.085  1.00 41.73          
ATOM    678  CB  ASP   100     -39.246  61.232 132.919  1.00 41.09          
ATOM    679  CG  ASP   100     -38.685  60.220 131.916  1.00 41.20          
ATOM    680  OD1 ASP   100     -39.215  59.974 130.789  1.00 38.12          
ATOM    681  OD2 ASP   100     -37.632  59.673 132.300  1.00 41.45          
ATOM    682  N   CYS   101     -40.278  63.902 134.029  1.00 44.72          
ATOM    683  CA  CYS   101     -40.550  64.551 135.332  1.00 46.08          
ATOM    684  C   CYS   101     -41.570  65.680 135.232  1.00 46.69          
ATOM    685  O   CYS   101     -41.947  66.110 134.135  1.00 47.06          
ATOM    686  CB  CYS   101     -39.250  65.098 135.940  1.00 46.62          
ATOM    687  SG  CYS   101     -37.867  63.848 136.081  1.00 50.78          
ATOM    688  N   SER   102     -42.043  66.144 136.372  1.00 46.92          
ATOM    689  CA  SER   102     -43.159  67.124 136.343  1.00 48.06          
ATOM    690  C   SER   102     -42.742  68.584 136.408  1.00 48.09          
ATOM    691  O   SER   102     -41.796  68.941 137.112  1.00 47.53          
ATOM    692  CB  SER   102     -44.225  66.827 137.396  1.00 47.32          
ATOM    693  OG  SER   102     -45.338  66.314 136.694  1.00 49.89          
ATOM    694  N   ALA   103     -43.453  69.415 135.642  1.00 48.78          
ATOM    695  CA  ALA   103     -43.223  70.842 135.693  1.00 50.33          
ATOM    696  C   ALA   103     -43.653  71.293 137.097  1.00 50.76          
ATOM    697  O   ALA   103     -44.521  70.648 137.704  1.00 50.85          
ATOM    698  CB  ALA   103     -44.022  71.585 134.574  1.00 50.30          
ATOM    699  N   PRO   104     -42.977  72.317 137.648  1.00 52.08          
ATOM    700  CA  PRO   104     -43.571  73.101 138.756  1.00 52.25          
ATOM    701  C   PRO   104     -44.711  73.997 138.257  1.00 52.65          
ATOM    702  O   PRO   104     -44.948  74.092 137.031  1.00 51.65          
ATOM    703  CB  PRO   104     -42.397  73.979 139.259  1.00 52.72          
ATOM    704  CG  PRO   104     -41.134  73.462 138.542  1.00 52.36          
ATOM    705  CD  PRO   104     -41.623  72.800 137.286  1.00 52.44          
ATOM    706  N   GLN   105     -45.404  74.682 139.177  1.00 53.39          
ATOM    707  CA  GLN   105     -46.384  75.662 138.729  1.00 53.36          
ATOM    708  C   GLN   105     -45.828  77.097 138.835  1.00 53.55          
ATOM    709  O   GLN   105     -46.276  77.958 139.619  1.00 54.37          
ATOM    710  CB  GLN   105     -47.743  75.426 139.387  1.00 54.93          
ATOM    711  CG  GLN   105     -48.659  74.561 138.496  1.00 56.49          
ATOM    712  CD  GLN   105     -48.902  75.173 137.103  1.00 59.08          
ATOM    713  OE1 GLN   105     -48.718  76.391 136.890  1.00 61.74          
ATOM    714  NE2 GLN   105     -49.322  74.326 136.150  1.00 57.67          
ATOM    715  N   LEU   106     -44.809  77.298 138.010  1.00 52.41          
ATOM    716  CA  LEU   106     -44.190  78.576 137.734  1.00 51.29          
ATOM    717  C   LEU   106     -45.162  79.445 136.912  1.00 50.32          
ATOM    718  O   LEU   106     -45.873  78.933 136.044  1.00 50.83          
ATOM    719  CB  LEU   106     -42.886  78.300 136.954  1.00 51.27          
ATOM    720  CG  LEU   106     -41.997  79.408 136.379  1.00 52.24          
ATOM    721  CD1 LEU   106     -41.282  80.194 137.495  1.00 53.40          
ATOM    722  CD2 LEU   106     -40.970  78.808 135.358  1.00 50.96          
ATOM    723  N   ASN   107     -45.214  80.739 137.221  1.00 48.24          
ATOM    724  CA  ASN   107     -45.879  81.725 136.403  1.00 47.41          
ATOM    725  C   ASN   107     -44.772  82.501 135.657  1.00 46.64          
ATOM    726  O   ASN   107     -43.835  82.973 136.303  1.00 46.31          
ATOM    727  CB  ASN   107     -46.645  82.650 137.358  1.00 48.25          
ATOM    728  CG  ASN   107     -47.477  83.705 136.649  1.00 47.27          
ATOM    729  OD1 ASN   107     -47.103  84.183 135.586  1.00 50.28          
ATOM    730  ND2 ASN   107     -48.607  84.053 137.227  1.00 38.82          
ATOM    731  N   VAL   108     -44.863  82.670 134.334  1.00 45.26          
ATOM    732  CA  VAL   108     -43.685  83.142 133.544  1.00 45.06          
ATOM    733  C   VAL   108     -43.683  84.642 133.065  1.00 44.11          
ATOM    734  O   VAL   108     -42.734  85.179 132.496  1.00 43.95          
ATOM    735  CB  VAL   108     -43.426  82.114 132.377  1.00 45.46          
ATOM    736  CG1 VAL   108     -44.108  82.505 131.042  1.00 44.93          
ATOM    737  CG2 VAL   108     -41.952  81.773 132.261  1.00 45.52          
ATOM    738  N   LYS   109     -44.726  85.329 133.426  1.00 43.87          
ATOM    739  CA  LYS   109     -45.102  86.585 132.812  1.00 42.70          
ATOM    740  C   LYS   109     -44.436  87.708 133.590  1.00 43.86          
ATOM    741  O   LYS   109     -44.481  87.722 134.863  1.00 44.65          
ATOM    742  CB  LYS   109     -46.620  86.697 132.913  1.00 42.23          
ATOM    743  CG  LYS   109     -47.374  85.326 133.160  1.00 38.08          
ATOM    744  CD  LYS   109     -48.900  85.477 133.340  1.00 39.19          
ATOM    745  CE  LYS   109     -49.295  86.274 134.621  1.00 29.34          
ATOM    746  NZ  LYS   109     -50.691  86.169 134.931  1.00 18.04          
ATOM    747  N   GLY   110     -43.756  88.655 132.948  1.00 44.07          
ATOM    748  CA  GLY   110     -42.920  88.525 131.831  1.00 43.27          
ATOM    749  C   GLY   110     -41.511  88.520 132.435  1.00 43.32          
ATOM    750  O   GLY   110     -40.797  89.554 132.525  1.00 41.80          
ATOM    751  N   MET   111     -41.210  87.329 132.954  1.00 43.59          
ATOM    752  CA  MET   111     -39.920  86.671 132.815  1.00 43.57          
ATOM    753  C   MET   111     -39.646  86.503 131.313  1.00 42.73          
ATOM    754  O   MET   111     -40.509  86.070 130.556  1.00 41.71          
ATOM    755  CB  MET   111     -39.927  85.248 133.412  1.00 44.40          
ATOM    756  CG  MET   111     -40.241  85.083 134.939  1.00 45.70          
ATOM    757  SD  MET   111     -40.165  83.323 135.375  1.00 45.54          
ATOM    758  CE  MET   111     -38.430  83.087 135.002  1.00 48.04          
ATOM    759  N   THR   112     -38.459  86.936 130.921  1.00 41.67          
ATOM    760  CA  THR   112     -37.744  86.516 129.741  1.00 41.00          
ATOM    761  C   THR   112     -37.883  84.995 129.458  1.00 40.91          
ATOM    762  O   THR   112     -38.128  84.184 130.395  1.00 39.90          
ATOM    763  CB  THR   112     -36.287  87.018 129.973  1.00 41.99          
ATOM    764  OG1 THR   112     -36.238  88.466 129.743  1.00 42.94          
ATOM    765  CG2 THR   112     -35.313  86.350 129.194  1.00 39.55          
ATOM    766  N   VAL   113     -37.794  84.613 128.171  1.00 39.19          
ATOM    767  CA  VAL   113     -37.938  83.192 127.803  1.00 38.99          
ATOM    768  C   VAL   113     -36.696  82.465 128.351  1.00 37.74          
ATOM    769  O   VAL   113     -36.825  81.404 128.904  1.00 35.89          
ATOM    770  CB  VAL   113     -38.263  82.983 126.259  1.00 38.81          
ATOM    771  CG1 VAL   113     -37.023  83.105 125.436  1.00 40.05          
ATOM    772  CG2 VAL   113     -38.950  81.625 125.988  1.00 39.74          
ATOM    773  N   LEU   114     -35.522  83.107 128.305  1.00 37.73          
ATOM    774  CA  LEU   114     -34.285  82.497 128.772  1.00 37.80          
ATOM    775  C   LEU   114     -34.320  82.209 130.247  1.00 38.39          
ATOM    776  O   LEU   114     -33.726  81.240 130.660  1.00 37.46          
ATOM    777  CB  LEU   114     -33.065  83.369 128.446  1.00 37.76          
ATOM    778  CG  LEU   114     -31.664  82.862 128.828  1.00 38.09          
ATOM    779  CD1 LEU   114     -31.431  81.365 128.458  1.00 42.92          
ATOM    780  CD2 LEU   114     -30.550  83.742 128.229  1.00 39.46          
ATOM    781  N   ASP   115     -34.982  83.090 131.036  1.00 38.71          
ATOM    782  CA  ASP   115     -35.118  82.929 132.498  1.00 38.65          
ATOM    783  C   ASP   115     -36.194  81.944 132.901  1.00 37.85          
ATOM    784  O   ASP   115     -35.982  81.173 133.823  1.00 38.57          
ATOM    785  CB  ASP   115     -35.376  84.286 133.206  1.00 39.19          
ATOM    786  CG  ASP   115     -34.157  85.156 133.233  1.00 43.54          
ATOM    787  OD1 ASP   115     -33.033  84.688 132.846  1.00 46.56          
ATOM    788  OD2 ASP   115     -34.319  86.335 133.651  1.00 51.72          
ATOM    789  N   ALA   116     -37.332  81.925 132.230  1.00 37.36          
ATOM    790  CA  ALA   116     -38.301  80.835 132.454  1.00 38.07          
ATOM    791  C   ALA   116     -37.730  79.423 132.036  1.00 38.99          
ATOM    792  O   ALA   116     -38.122  78.383 132.623  1.00 38.98          
ATOM    793  CB  ALA   116     -39.587  81.122 131.734  1.00 37.10          
ATOM    794  N   ALA   117     -36.798  79.383 131.076  1.00 38.86          
ATOM    795  CA  ALA   117     -36.160  78.084 130.707  1.00 39.89          
ATOM    796  C   ALA   117     -35.150  77.668 131.782  1.00 40.38          
ATOM    797  O   ALA   117     -35.124  76.492 132.188  1.00 40.63          
ATOM    798  CB  ALA   117     -35.469  78.156 129.324  1.00 38.98          
ATOM    799  N   LYS   118     -34.321  78.639 132.208  1.00 41.01          
ATOM    800  CA  LYS   118     -33.322  78.457 133.271  1.00 42.11          
ATOM    801  C   LYS   118     -34.018  77.916 134.505  1.00 43.02          
ATOM    802  O   LYS   118     -33.518  76.974 135.151  1.00 43.96          
ATOM    803  CB  LYS   118     -32.580  79.785 133.617  1.00 42.13          
ATOM    804  CG  LYS   118     -31.428  80.134 132.659  1.00 41.02          
ATOM    805  CD  LYS   118     -30.839  81.500 132.877  1.00 42.50          
ATOM    806  CE  LYS   118     -29.590  81.723 131.995  1.00 43.19          
ATOM    807  NZ  LYS   118     -29.103  83.173 132.155  1.00 41.67          
ATOM    808  N   LYS   119     -35.181  78.480 134.803  1.00 43.80          
ATOM    809  CA  LYS   119     -35.934  78.090 135.995  1.00 44.10          
ATOM    810  C   LYS   119     -36.285  76.642 135.900  1.00 43.70          
ATOM    811  O   LYS   119     -35.894  75.869 136.747  1.00 43.50          
ATOM    812  CB  LYS   119     -37.205  78.943 136.201  1.00 45.44          
ATOM    813  CG  LYS   119     -38.055  78.533 137.433  1.00 46.50          
ATOM    814  CD  LYS   119     -37.393  79.020 138.778  1.00 52.06          
ATOM    815  CE  LYS   119     -37.514  77.994 139.967  1.00 52.67          
ATOM    816  NZ  LYS   119     -38.758  78.151 140.813  1.00 52.88          
ATOM    817  N   LEU   120     -36.977  76.276 134.837  1.00 44.23          
ATOM    818  CA  LEU   120     -37.508  74.896 134.634  1.00 43.33          
ATOM    819  C   LEU   120     -36.463  73.796 134.554  1.00 42.75          
ATOM    820  O   LEU   120     -36.755  72.643 134.856  1.00 43.41          
ATOM    821  CB  LEU   120     -38.373  74.844 133.382  1.00 43.67          
ATOM    822  CG  LEU   120     -39.670  75.648 133.318  1.00 44.94          
ATOM    823  CD1 LEU   120     -40.015  75.948 131.830  1.00 43.41          
ATOM    824  CD2 LEU   120     -40.793  74.895 134.015  1.00 45.47          
ATOM    825  N   ALA   121     -35.259  74.138 134.105  1.00 42.53          
ATOM    826  CA  ALA   121     -34.130  73.190 134.025  1.00 42.11          
ATOM    827  C   ALA   121     -33.273  73.156 135.319  1.00 41.97          
ATOM    828  O   ALA   121     -32.373  72.329 135.447  1.00 40.35          
ATOM    829  CB  ALA   121     -33.250  73.562 132.857  1.00 41.60          
ATOM    830  N   ALA   122     -33.510  74.120 136.217  1.00 40.98          
ATOM    831  CA  ALA   122     -32.759  74.256 137.477  1.00 41.87          
ATOM    832  C   ALA   122     -32.574  72.959 138.288  1.00 41.61          
ATOM    833  O   ALA   122     -31.434  72.664 138.670  1.00 41.78          
ATOM    834  CB  ALA   122     -33.387  75.391 138.400  1.00 40.34          
ATOM    835  N   PRO   123     -33.672  72.192 138.545  1.00 42.01          
ATOM    836  CA  PRO   123     -33.565  70.900 139.267  1.00 42.75          
ATOM    837  C   PRO   123     -32.626  69.842 138.666  1.00 43.38          
ATOM    838  O   PRO   123     -32.307  68.854 139.327  1.00 44.75          
ATOM    839  CB  PRO   123     -35.008  70.356 139.251  1.00 43.04          
ATOM    840  CG  PRO   123     -35.880  71.511 138.977  1.00 40.40          
ATOM    841  CD  PRO   123     -35.068  72.462 138.141  1.00 41.52          
ATOM    842  N   TRP   124     -32.187  70.020 137.422  1.00 43.74          
ATOM    843  CA  TRP   124     -31.322  69.083 136.794  1.00 43.10          
ATOM    844  C   TRP   124     -29.997  69.711 136.519  1.00 44.01          
ATOM    845  O   TRP   124     -29.716  70.114 135.393  1.00 42.99          
ATOM    846  CB  TRP   124     -31.978  68.471 135.551  1.00 42.86          
ATOM    847  CG  TRP   124     -33.145  67.675 135.984  1.00 40.78          
ATOM    848  CD1 TRP   124     -33.137  66.395 136.468  1.00 41.48          
ATOM    849  CD2 TRP   124     -34.483  68.110 136.021  1.00 39.28          
ATOM    850  NE1 TRP   124     -34.413  66.012 136.797  1.00 40.34          
ATOM    851  CE2 TRP   124     -35.260  67.047 136.517  1.00 39.98          
ATOM    852  CE3 TRP   124     -35.124  69.293 135.637  1.00 40.65          
ATOM    853  CZ2 TRP   124     -36.648  67.140 136.680  1.00 41.02          
ATOM    854  CZ3 TRP   124     -36.499  69.381 135.806  1.00 41.19          
ATOM    855  CH2 TRP   124     -37.244  68.307 136.313  1.00 40.55          
ATOM    856  N   PRO   125     -29.139  69.762 137.570  1.00 45.64          
ATOM    857  CA  PRO   125     -27.870  70.448 137.445  1.00 45.93          
ATOM    858  C   PRO   125     -26.997  69.785 136.445  1.00 46.37          
ATOM    859  O   PRO   125     -26.049  70.413 135.948  1.00 46.58          
ATOM    860  CB  PRO   125     -27.278  70.399 138.869  1.00 46.66          
ATOM    861  CG  PRO   125     -27.981  69.307 139.540  1.00 46.96          
ATOM    862  CD  PRO   125     -29.340  69.236 138.933  1.00 45.91          
ATOM    863  N   GLN   126     -27.334  68.521 136.160  1.00 47.12          
ATOM    864  CA  GLN   126     -26.809  67.771 135.035  1.00 47.00          
ATOM    865  C   GLN   126     -26.909  68.582 133.696  1.00 47.32          
ATOM    866  O   GLN   126     -26.002  68.547 132.840  1.00 46.71          
ATOM    867  CB  GLN   126     -27.448  66.327 135.010  1.00 47.77          
ATOM    868  CG  GLN   126     -28.985  66.168 135.505  1.00 48.57          
ATOM    869  CD  GLN   126     -29.302  65.663 137.009  1.00 44.32          
ATOM    870  OE1 GLN   126     -28.717  66.048 137.940  1.00 46.03          
ATOM    871  NE2 GLN   126     -30.297  64.872 137.148  1.00 44.90          
ATOM    872  N   ILE   127     -27.979  69.366 133.549  1.00 47.63          
ATOM    873  CA  ILE   127     -28.061  70.396 132.492  1.00 47.76          
ATOM    874  C   ILE   127     -27.288  71.635 133.009  1.00 48.07          
ATOM    875  O   ILE   127     -27.789  72.407 133.818  1.00 47.78          
ATOM    876  CB  ILE   127     -29.560  70.743 132.119  1.00 47.78          
ATOM    877  CG1 ILE   127     -30.325  69.480 131.695  1.00 47.09          
ATOM    878  CG2 ILE   127     -29.624  71.797 131.003  1.00 46.93          
ATOM    879  CD  ILE   127     -31.862  69.582 131.763  1.00 47.45          
ATOM    880  N   LYS   128     -26.065  71.812 132.521  1.00 48.75          
ATOM    881  CA  LYS   128     -25.120  72.760 133.100  1.00 48.87          
ATOM    882  C   LYS   128     -25.129  74.162 132.479  1.00 48.31          
ATOM    883  O   LYS   128     -24.464  75.052 133.012  1.00 49.33          
ATOM    884  CB  LYS   128     -23.703  72.199 133.023  1.00 50.03          
ATOM    885  CG  LYS   128     -23.388  71.080 133.994  1.00 51.17          
ATOM    886  CD  LYS   128     -22.050  70.447 133.658  1.00 51.13          
ATOM    887  CE  LYS   128     -21.696  69.316 134.648  1.00 53.76          
ATOM    888  NZ  LYS   128     -20.685  68.320 134.094  1.00 53.98          
ATOM    889  N   ALA   129     -25.850  74.367 131.371  1.00 47.27          
ATOM    890  CA  ALA   129     -26.104  75.716 130.840  1.00 46.07          
ATOM    891  C   ALA   129     -27.409  75.745 130.084  1.00 45.68          
ATOM    892  O   ALA   129     -27.808  74.742 129.469  1.00 43.86          
ATOM    893  CB  ALA   129     -24.981  76.192 129.933  1.00 46.37          
ATOM    894  N   VAL   130     -28.086  76.896 130.157  1.00 44.12          
ATOM    895  CA  VAL   130     -29.263  77.178 129.340  1.00 44.02          
ATOM    896  C   VAL   130     -28.959  78.423 128.478  1.00 44.72          
ATOM    897  O   VAL   130     -28.543  79.460 128.989  1.00 45.08          
ATOM    898  CB  VAL   130     -30.505  77.382 130.206  1.00 43.13          
ATOM    899  CG1 VAL   130     -31.764  77.440 129.356  1.00 39.96          
ATOM    900  CG2 VAL   130     -30.582  76.277 131.252  1.00 40.18          
ATOM    901  N   VAL   131     -29.192  78.306 127.183  1.00 44.93          
ATOM    902  CA  VAL   131     -28.793  79.298 126.205  1.00 45.42          
ATOM    903  C   VAL   131     -30.030  79.632 125.369  1.00 45.75          
ATOM    904  O   VAL   131     -30.989  78.822 125.278  1.00 44.30          
ATOM    905  CB  VAL   131     -27.585  78.752 125.369  1.00 46.08          
ATOM    906  CG1 VAL   131     -27.494  79.360 123.963  1.00 48.27          
ATOM    907  CG2 VAL   131     -26.264  78.982 126.129  1.00 45.62          
ATOM    908  N   LEU   132     -30.048  80.858 124.832  1.00 46.00          
ATOM    909  CA  LEU   132     -31.140  81.319 123.968  1.00 46.49          
ATOM    910  C   LEU   132     -30.516  81.350 122.590  1.00 47.11          
ATOM    911  O   LEU   132     -29.404  81.861 122.391  1.00 47.20          
ATOM    912  CB  LEU   132     -31.750  82.672 124.411  1.00 46.61          
ATOM    913  CG  LEU   132     -32.940  83.301 123.642  1.00 44.73          
ATOM    914  CD1 LEU   132     -34.275  82.678 123.969  1.00 39.44          
ATOM    915  CD2 LEU   132     -33.014  84.840 123.863  1.00 46.67          
ATOM    916  N   LYS   133     -31.198  80.708 121.652  1.00 47.95          
ATOM    917  CA  LYS   133     -30.695  80.612 120.283  1.00 48.56          
ATOM    918  C   LYS   133     -31.656  81.439 119.411  1.00 48.77          
ATOM    919  O   LYS   133     -32.410  80.929 118.563  1.00 48.35          
ATOM    920  CB  LYS   133     -30.589  79.130 119.885  1.00 48.79          
ATOM    921  CG  LYS   133     -29.248  78.707 119.355  1.00 49.90          
ATOM    922  CD  LYS   133     -28.164  78.764 120.403  1.00 51.28          
ATOM    923  CE  LYS   133     -26.824  78.442 119.797  1.00 52.13          
ATOM    924  NZ  LYS   133     -26.748  76.998 119.425  1.00 52.63          
ATOM    925  N   ALA   134     -31.628  82.749 119.668  1.00 49.39          
ATOM    926  CA  ALA   134     -32.589  83.690 119.085  1.00 49.87          
ATOM    927  C   ALA   134     -32.058  85.143 119.188  1.00 50.83          
ATOM    928  O   ALA   134     -31.184  85.445 120.015  1.00 50.97          
ATOM    929  CB  ALA   134     -33.952  83.531 119.758  1.00 48.85          
ATOM    930  N   GLU   135     -32.554  86.030 118.329  1.00 51.95          
ATOM    931  CA  GLU   135     -32.065  87.403 118.300  1.00 53.09          
ATOM    932  C   GLU   135     -32.486  88.131 119.583  1.00 53.81          
ATOM    933  O   GLU   135     -31.697  88.862 120.217  1.00 53.87          
ATOM    934  CB  GLU   135     -32.619  88.146 117.080  1.00 53.66          
ATOM    935  CG  GLU   135     -31.982  87.753 115.720  1.00 56.72          
ATOM    936  CD  GLU   135     -30.635  88.448 115.438  1.00 59.74          
ATOM    937  OE1 GLU   135     -30.557  89.681 115.664  1.00 61.44          
ATOM    938  OE2 GLU   135     -29.671  87.759 114.974  1.00 60.19          
ATOM    939  N   ASN   136     -33.745  87.905 119.944  1.00 54.10          
ATOM    940  CA  ASN   136     -34.395  88.606 121.006  1.00 54.11          
ATOM    941  C   ASN   136     -34.900  87.657 122.071  1.00 53.84          
ATOM    942  O   ASN   136     -35.187  86.495 121.820  1.00 54.30          
ATOM    943  CB  ASN   136     -35.506  89.429 120.393  1.00 54.65          
ATOM    944  CG  ASN   136     -34.957  90.464 119.392  1.00 57.00          
ATOM    945  OD1 ASN   136     -34.323  91.464 119.794  1.00 58.44          
ATOM    946  ND2 ASN   136     -35.164  90.210 118.089  1.00 57.01          
ATOM    947  N   ASN   137     -34.994  88.174 123.280  1.00 53.24          
ATOM    948  CA  ASN   137     -35.226  87.376 124.458  1.00 52.32          
ATOM    949  C   ASN   137     -36.498  87.872 125.119  1.00 52.82          
ATOM    950  O   ASN   137     -36.456  88.587 126.164  1.00 52.03          
ATOM    951  CB  ASN   137     -34.020  87.533 125.363  1.00 52.07          
ATOM    952  CG  ASN   137     -34.135  86.738 126.615  1.00 50.83          
ATOM    953  OD1 ASN   137     -35.141  86.039 126.849  1.00 47.05          
ATOM    954  ND2 ASN   137     -33.106  86.841 127.454  1.00 49.01          
ATOM    955  N   PRO   138     -37.642  87.534 124.497  1.00 52.42          
ATOM    956  CA  PRO   138     -38.893  88.211 124.821  1.00 52.30          
ATOM    957  C   PRO   138     -39.328  87.955 126.241  1.00 51.98          
ATOM    958  O   PRO   138     -39.159  86.836 126.744  1.00 51.56          
ATOM    959  CB  PRO   138     -39.903  87.561 123.863  1.00 52.52          
ATOM    960  CG  PRO   138     -39.343  86.244 123.610  1.00 52.20          
ATOM    961  CD  PRO   138     -37.863  86.505 123.478  1.00 52.66          
ATOM    962  N   ALA   139     -39.870  89.007 126.861  1.00 51.66          
ATOM    963  CA  ALA   139     -40.711  88.881 128.047  1.00 50.96          
ATOM    964  C   ALA   139     -41.902  88.036 127.631  1.00 50.06          
ATOM    965  O   ALA   139     -42.499  88.273 126.601  1.00 50.30          
ATOM    966  CB  ALA   139     -41.163  90.267 128.569  1.00 50.90          
ATOM    967  N   LEU   140     -42.207  87.026 128.424  1.00 49.66          
ATOM    968  CA  LEU   140     -43.278  86.094 128.128  1.00 49.15          
ATOM    969  C   LEU   140     -44.588  86.691 128.508  1.00 49.75          
ATOM    970  O   LEU   140     -44.653  87.538 129.423  1.00 49.81          
ATOM    971  CB  LEU   140     -43.097  84.804 128.937  1.00 48.86          
ATOM    972  CG  LEU   140     -42.199  83.637 128.448  1.00 46.34          
ATOM    973  CD1 LEU   140     -42.354  83.399 126.920  1.00 42.72          
ATOM    974  CD2 LEU   140     -40.747  83.767 128.864  1.00 41.96          
ATOM    975  N   GLY   141     -45.636  86.243 127.831  1.00 50.37          
ATOM    976  CA  GLY   141     -47.001  86.615 128.146  1.00 51.04          
ATOM    977  C   GLY   141     -47.554  85.726 129.236  1.00 51.33          
ATOM    978  O   GLY   141     -46.819  85.243 130.074  1.00 51.56          
ATOM    979  N   LYS   142     -48.859  85.513 129.219  1.00 52.49          
ATOM    980  CA  LYS   142     -49.526  84.634 130.170  1.00 53.66          
ATOM    981  C   LYS   142     -49.550  83.203 129.663  1.00 54.43          
ATOM    982  O   LYS   142     -50.239  82.904 128.697  1.00 55.46          
ATOM    983  CB  LYS   142     -50.961  85.133 130.408  1.00 53.71          
ATOM    984  CG  LYS   142     -51.928  84.155 131.108  1.00 53.61          
ATOM    985  CD  LYS   142     -53.238  84.909 131.445  1.00 54.28          
ATOM    986  CE  LYS   142     -54.079  84.236 132.548  1.00 55.34          
ATOM    987  NZ  LYS   142     -55.125  85.190 133.141  1.00 53.75          
ATOM    988  N   ILE   143     -48.808  82.312 130.304  1.00 55.53          
ATOM    989  CA  ILE   143     -48.804  80.903 129.878  1.00 56.18          
ATOM    990  C   ILE   143     -49.408  80.027 130.984  1.00 57.50          
ATOM    991  O   ILE   143     -48.841  79.899 132.076  1.00 58.04          
ATOM    992  CB  ILE   143     -47.410  80.408 129.456  1.00 56.47          
ATOM    993  CG1 ILE   143     -46.854  81.252 128.300  1.00 55.69          
ATOM    994  CG2 ILE   143     -47.477  78.950 128.992  1.00 54.86          
ATOM    995  CD  ILE   143     -47.407  80.885 126.971  1.00 56.04          
ATOM    996  N   ASP   144     -50.589  79.477 130.681  1.00 58.48          
ATOM    997  CA  ASP   144     -51.377  78.666 131.595  1.00 58.74          
ATOM    998  C   ASP   144     -51.047  77.219 131.288  1.00 59.75          
ATOM    999  O   ASP   144     -51.443  76.702 130.236  1.00 60.47          
ATOM   1000  CB  ASP   144     -52.886  78.902 131.368  1.00 58.87          
ATOM   1001  CG  ASP   144     -53.512  79.842 132.385  1.00 59.00          
ATOM   1002  OD1 ASP   144     -53.044  79.876 133.545  1.00 60.52          
ATOM   1003  OD2 ASP   144     -54.501  80.531 132.031  1.00 57.39          
ATOM   1004  N   ILE   145     -50.322  76.576 132.200  1.00 60.31          
ATOM   1005  CA  ILE   145     -49.944  75.166 132.080  1.00 60.43          
ATOM   1006  C   ILE   145     -50.761  74.286 133.054  1.00 60.93          
ATOM   1007  O   ILE   145     -51.069  74.715 134.175  1.00 61.93          
ATOM   1008  CB  ILE   145     -48.407  74.969 132.305  1.00 60.88          
ATOM   1009  CG1 ILE   145     -47.846  75.996 133.290  1.00 59.56          
ATOM   1010  CG2 ILE   145     -47.643  75.040 130.930  1.00 61.16          
ATOM   1011  CD  ILE   145     -46.384  75.809 133.636  1.00 59.89          
ATOM   1012  N   GLU   146     -51.122  73.072 132.641  1.00 60.81          
ATOM   1013  CA  GLU   146     -51.909  72.166 133.510  1.00 60.96          
ATOM   1014  C   GLU   146     -51.009  71.194 134.329  1.00 60.57          
ATOM   1015  O   GLU   146     -49.988  70.737 133.827  1.00 60.80          
ATOM   1016  CB  GLU   146     -53.006  71.441 132.716  1.00 61.11          
ATOM   1017  CG  GLU   146     -52.580  70.916 131.336  1.00 62.49          
ATOM   1018  CD  GLU   146     -53.711  70.205 130.578  1.00 63.25          
ATOM   1019  OE1 GLU   146     -53.412  69.211 129.852  1.00 65.14          
ATOM   1020  OE2 GLU   146     -54.889  70.656 130.699  1.00 65.30          
ATOM   1021  N   PRO   147     -51.401  70.865 135.587  1.00 60.04          
ATOM   1022  CA  PRO   147     -50.441  70.366 136.631  1.00 59.24          
ATOM   1023  C   PRO   147     -49.634  69.080 136.336  1.00 58.69          
ATOM   1024  O   PRO   147     -48.431  68.991 136.689  1.00 59.18          
ATOM   1025  CB  PRO   147     -51.328  70.185 137.880  1.00 59.35          
ATOM   1026  CG  PRO   147     -52.592  71.023 137.596  1.00 59.88          
ATOM   1027  CD  PRO   147     -52.788  70.926 136.105  1.00 59.93          
ATOM   1028  N   GLY   148     -50.256  68.095 135.692  1.00 57.37          
ATOM   1029  CA  GLY   148     -49.506  66.911 135.222  1.00 55.91          
ATOM   1030  C   GLY   148     -48.594  67.148 134.010  1.00 54.75          
ATOM   1031  O   GLY   148     -48.077  66.200 133.424  1.00 53.38          
ATOM   1032  N   GLU   149     -48.408  68.407 133.607  1.00 53.32          
ATOM   1033  CA  GLU   149     -47.500  68.703 132.489  1.00 52.60          
ATOM   1034  C   GLU   149     -46.070  68.408 132.907  1.00 49.31          
ATOM   1035  O   GLU   149     -45.677  68.566 134.111  1.00 49.20          
ATOM   1036  CB  GLU   149     -47.660  70.139 131.915  1.00 52.19          
ATOM   1037  CG  GLU   149     -48.786  70.201 130.852  1.00 54.72          
ATOM   1038  CD  GLU   149     -48.742  71.407 129.903  1.00 55.39          
ATOM   1039  OE1 GLU   149     -48.753  72.582 130.353  1.00 58.89          
ATOM   1040  OE2 GLU   149     -48.757  71.155 128.680  1.00 60.76          
ATOM   1041  N   THR   150     -45.321  67.958 131.902  1.00 45.19          
ATOM   1042  CA  THR   150     -43.992  67.565 132.084  1.00 42.07          
ATOM   1043  C   THR   150     -43.217  68.842 131.964  1.00 41.31          
ATOM   1044  O   THR   150     -43.680  69.807 131.390  1.00 39.74          
ATOM   1045  CB  THR   150     -43.559  66.539 130.959  1.00 42.90          
ATOM   1046  OG1 THR   150     -43.569  67.170 129.657  1.00 40.69          
ATOM   1047  CG2 THR   150     -44.472  65.290 130.952  1.00 39.70          
ATOM   1048  N   VAL   151     -42.010  68.854 132.475  1.00 40.18          
ATOM   1049  CA  VAL   151     -41.131  70.005 132.249  1.00 39.70          
ATOM   1050  C   VAL   151     -41.011  70.330 130.727  1.00 38.66          
ATOM   1051  O   VAL   151     -41.045  71.521 130.319  1.00 37.43          
ATOM   1052  CB  VAL   151     -39.750  69.784 132.910  1.00 39.49          
ATOM   1053  CG1 VAL   151     -38.908  71.052 132.844  1.00 40.08          
ATOM   1054  CG2 VAL   151     -39.912  69.333 134.369  1.00 40.15          
ATOM   1055  N   TRP   152     -40.861  69.265 129.917  1.00 37.91          
ATOM   1056  CA  TRP   152     -40.750  69.360 128.466  1.00 36.89          
ATOM   1057  C   TRP   152     -41.972  70.007 127.810  1.00 35.94          
ATOM   1058  O   TRP   152     -41.827  70.971 127.094  1.00 35.39          
ATOM   1059  CB  TRP   152     -40.441  68.006 127.787  1.00 34.74          
ATOM   1060  CG  TRP   152     -39.829  68.290 126.487  1.00 32.36          
ATOM   1061  CD1 TRP   152     -40.449  68.267 125.250  1.00 31.54          
ATOM   1062  CD2 TRP   152     -38.534  68.813 126.272  1.00 32.04          
ATOM   1063  NE1 TRP   152     -39.592  68.724 124.291  1.00 31.01          
ATOM   1064  CE2 TRP   152     -38.401  69.044 124.871  1.00 29.15          
ATOM   1065  CE3 TRP   152     -37.432  69.042 127.108  1.00 29.95          
ATOM   1066  CZ2 TRP   152     -37.226  69.496 124.298  1.00 31.01          
ATOM   1067  CZ3 TRP   152     -36.276  69.504 126.548  1.00 31.50          
ATOM   1068  CH2 TRP   152     -36.158  69.715 125.152  1.00 30.71          
ATOM   1069  N   GLN   153     -43.150  69.464 128.044  1.00 36.92          
ATOM   1070  CA  GLN   153     -44.406  70.094 127.600  1.00 38.21          
ATOM   1071  C   GLN   153     -44.504  71.549 127.954  1.00 38.85          
ATOM   1072  O   GLN   153     -44.873  72.368 127.106  1.00 39.73          
ATOM   1073  CB  GLN   153     -45.597  69.403 128.220  1.00 38.30          
ATOM   1074  CG  GLN   153     -45.938  68.131 127.540  1.00 38.80          
ATOM   1075  CD  GLN   153     -46.993  67.336 128.295  1.00 39.06          
ATOM   1076  OE1 GLN   153     -47.016  67.343 129.521  1.00 41.00          
ATOM   1077  NE2 GLN   153     -47.842  66.611 127.563  1.00 38.45          
ATOM   1078  N   ALA   154     -44.140  71.878 129.197  1.00 38.88          
ATOM   1079  CA  ALA   154     -44.220  73.226 129.675  1.00 38.65          
ATOM   1080  C   ALA   154     -43.212  74.091 128.955  1.00 38.64          
ATOM   1081  O   ALA   154     -43.469  75.255 128.619  1.00 37.52          
ATOM   1082  CB  ALA   154     -43.956  73.277 131.230  1.00 39.17          
ATOM   1083  N   LEU   155     -42.042  73.526 128.732  1.00 37.76          
ATOM   1084  CA  LEU   155     -41.000  74.261 128.085  1.00 38.20          
ATOM   1085  C   LEU   155     -41.363  74.537 126.589  1.00 37.62          
ATOM   1086  O   LEU   155     -41.023  75.599 126.038  1.00 35.67          
ATOM   1087  CB  LEU   155     -39.726  73.433 128.181  1.00 38.96          
ATOM   1088  CG  LEU   155     -38.340  74.005 128.050  1.00 38.74          
ATOM   1089  CD1 LEU   155     -38.154  75.179 128.954  1.00 38.22          
ATOM   1090  CD2 LEU   155     -37.448  72.854 128.455  1.00 38.79          
ATOM   1091  N   THR   156     -42.049  73.579 125.978  1.00 37.91          
ATOM   1092  CA  THR   156     -42.426  73.649 124.570  1.00 39.28          
ATOM   1093  C   THR   156     -43.489  74.754 124.396  1.00 39.91          
ATOM   1094  O   THR   156     -43.328  75.671 123.582  1.00 39.56          
ATOM   1095  CB  THR   156     -42.943  72.275 124.075  1.00 39.40          
ATOM   1096  OG1 THR   156     -41.913  71.276 124.222  1.00 40.32          
ATOM   1097  CG2 THR   156     -43.414  72.344 122.597  1.00 37.44          
ATOM   1098  N   HSD   157     -44.506  74.700 125.253  1.00 41.29          
ATOM   1099  CA  HSD   157     -45.563  75.742 125.389  1.00 40.52          
ATOM   1100  C   HSD   157     -44.960  77.148 125.489  1.00 40.40          
ATOM   1101  O   HSD   157     -45.144  78.009 124.630  1.00 40.47          
ATOM   1102  CB  HSD   157     -46.370  75.403 126.629  1.00 42.29          
ATOM   1103  CG  HSD   157     -47.824  75.773 126.555  1.00 46.21          
ATOM   1104  ND1 HSD   157     -48.795  74.896 126.108  1.00 49.77          
ATOM   1105  CD2 HSD   157     -48.474  76.912 126.900  1.00 46.73          
ATOM   1106  CE1 HSD   157     -49.978  75.493 126.168  1.00 51.70          
ATOM   1107  NE2 HSD   157     -49.812  76.717 126.654  1.00 48.91          
ATOM   1108  N   ILE   158     -44.174  77.364 126.520  1.00 39.54          
ATOM   1109  CA  ILE   158     -43.512  78.617 126.731  1.00 38.46          
ATOM   1110  C   ILE   158     -42.707  79.077 125.507  1.00 37.00          
ATOM   1111  O   ILE   158     -42.830  80.226 125.019  1.00 35.33          
ATOM   1112  CB  ILE   158     -42.575  78.495 127.969  1.00 38.55          
ATOM   1113  CG1 ILE   158     -43.399  78.372 129.259  1.00 39.19          
ATOM   1114  CG2 ILE   158     -41.672  79.670 128.051  1.00 39.72          
ATOM   1115  CD  ILE   158     -42.637  77.673 130.405  1.00 39.44          
ATOM   1116  N   ALA   159     -41.855  78.178 125.038  1.00 35.87          
ATOM   1117  CA  ALA   159     -40.969  78.441 123.908  1.00 36.02          
ATOM   1118  C   ALA   159     -41.790  78.802 122.666  1.00 34.45          
ATOM   1119  O   ALA   159     -41.479  79.781 121.981  1.00 33.92          
ATOM   1120  CB  ALA   159     -40.046  77.145 123.618  1.00 35.86          
ATOM   1121  N   ASN   160     -42.849  78.034 122.438  1.00 34.51          
ATOM   1122  CA  ASN   160     -43.613  78.102 121.219  1.00 35.17          
ATOM   1123  C   ASN   160     -44.446  79.389 121.199  1.00 36.44          
ATOM   1124  O   ASN   160     -44.602  80.017 120.125  1.00 35.86          
ATOM   1125  CB  ASN   160     -44.474  76.837 121.014  1.00 35.63          
ATOM   1126  CG  ASN   160     -43.655  75.604 120.495  1.00 36.13          
ATOM   1127  OD1 ASN   160     -42.459  75.699 120.157  1.00 39.58          
ATOM   1128  ND2 ASN   160     -44.304  74.453 120.455  1.00 33.50          
ATOM   1129  N   SER   161     -44.866  79.845 122.405  1.00 36.15          
ATOM   1130  CA  SER   161     -45.554  81.128 122.601  1.00 35.46          
ATOM   1131  C   SER   161     -44.818  82.297 121.978  1.00 36.28          
ATOM   1132  O   SER   161     -45.426  83.324 121.646  1.00 37.39          
ATOM   1133  CB  SER   161     -45.710  81.447 124.122  1.00 35.38          
ATOM   1134  OG  SER   161     -44.568  82.200 124.583  1.00 32.69          
ATOM   1135  N   VAL   162     -43.504  82.202 121.922  1.00 36.46          
ATOM   1136  CA  VAL   162     -42.673  83.279 121.406  1.00 36.60          
ATOM   1137  C   VAL   162     -42.010  82.827 120.125  1.00 36.85          
ATOM   1138  O   VAL   162     -40.958  83.366 119.759  1.00 38.04          
ATOM   1139  CB  VAL   162     -41.593  83.742 122.399  1.00 36.81          
ATOM   1140  CG1 VAL   162     -42.120  84.930 123.261  1.00 36.35          
ATOM   1141  CG2 VAL   162     -41.109  82.571 123.273  1.00 36.48          
ATOM   1142  N   GLY   163     -42.637  81.866 119.448  1.00 36.83          
ATOM   1143  CA  GLY   163     -42.131  81.340 118.161  1.00 37.06          
ATOM   1144  C   GLY   163     -40.766  80.660 118.283  1.00 37.55          
ATOM   1145  O   GLY   163     -39.929  80.738 117.358  1.00 39.28          
ATOM   1146  N   LEU   164     -40.529  80.019 119.428  1.00 36.30          
ATOM   1147  CA  LEU   164     -39.276  79.301 119.664  1.00 34.93          
ATOM   1148  C   LEU   164     -39.552  77.827 119.978  1.00 33.23          
ATOM   1149  O   LEU   164     -40.697  77.377 119.979  1.00 32.15          
ATOM   1150  CB  LEU   164     -38.430  80.004 120.741  1.00 35.47          
ATOM   1151  CG  LEU   164     -38.075  81.498 120.526  1.00 36.01          
ATOM   1152  CD1 LEU   164     -37.096  82.084 121.621  1.00 32.99          
ATOM   1153  CD2 LEU   164     -37.478  81.714 119.146  1.00 35.69          
ATOM   1154  N   HSD   165     -38.482  77.056 120.178  1.00 32.10          
ATOM   1155  CA  HSD   165     -38.619  75.656 120.526  1.00 31.62          
ATOM   1156  C   HSD   165     -37.429  75.231 121.376  1.00 30.28          
ATOM   1157  O   HSD   165     -36.324  75.719 121.153  1.00 29.79          
ATOM   1158  CB  HSD   165     -38.681  74.807 119.202  1.00 30.88          
ATOM   1159  CG  HSD   165     -39.192  73.426 119.405  1.00 30.41          
ATOM   1160  ND1 HSD   165     -40.535  73.131 119.449  1.00 29.82          
ATOM   1161  CD2 HSD   165     -38.545  72.250 119.587  1.00 31.56          
ATOM   1162  CE1 HSD   165     -40.701  71.845 119.687  1.00 29.33          
ATOM   1163  NE2 HSD   165     -39.505  71.281 119.757  1.00 30.96          
ATOM   1164  N   PRO   166     -37.625  74.280 122.312  1.00 30.00          
ATOM   1165  CA  PRO   166     -36.509  73.764 123.090  1.00 30.28          
ATOM   1166  C   PRO   166     -35.787  72.569 122.455  1.00 30.15          
ATOM   1167  O   PRO   166     -36.433  71.732 121.835  1.00 27.70          
ATOM   1168  CB  PRO   166     -37.182  73.285 124.373  1.00 29.87          
ATOM   1169  CG  PRO   166     -38.484  72.805 123.934  1.00 30.07          
ATOM   1170  CD  PRO   166     -38.887  73.653 122.728  1.00 30.73          
ATOM   1171  N   TRP   167     -34.466  72.493 122.639  1.00 30.72          
ATOM   1172  CA  TRP   167     -33.748  71.235 122.417  1.00 31.72          
ATOM   1173  C   TRP   167     -32.515  71.189 123.247  1.00 32.15          
ATOM   1174  O   TRP   167     -32.037  72.226 123.675  1.00 29.50          
ATOM   1175  CB  TRP   167     -33.379  71.044 120.941  1.00 31.26          
ATOM   1176  CG  TRP   167     -32.440  72.074 120.371  1.00 31.67          
ATOM   1177  CD1 TRP   167     -31.100  71.991 120.304  1.00 31.39          
ATOM   1178  CD2 TRP   167     -32.792  73.329 119.752  1.00 31.95          
ATOM   1179  NE1 TRP   167     -30.578  73.119 119.711  1.00 32.32          
ATOM   1180  CE2 TRP   167     -31.604  73.939 119.349  1.00 29.37          
ATOM   1181  CE3 TRP   167     -34.003  73.982 119.512  1.00 29.78          
ATOM   1182  CZ2 TRP   167     -31.585  75.138 118.684  1.00 32.42          
ATOM   1183  CZ3 TRP   167     -33.997  75.130 118.860  1.00 30.03          
ATOM   1184  CH2 TRP   167     -32.812  75.727 118.453  1.00 31.64          
ATOM   1185  N   LEU   168     -31.985  69.977 123.414  1.00 31.88          
ATOM   1186  CA  LEU   168     -30.630  69.763 123.909  1.00 32.07          
ATOM   1187  C   LEU   168     -29.591  69.720 122.814  1.00 32.16          
ATOM   1188  O   LEU   168     -29.769  69.077 121.778  1.00 31.77          
ATOM   1189  CB  LEU   168     -30.531  68.448 124.728  1.00 33.02          
ATOM   1190  CG  LEU   168     -31.072  68.455 126.145  1.00 32.11          
ATOM   1191  CD1 LEU   168     -30.187  69.333 127.075  1.00 31.71          
ATOM   1192  CD2 LEU   168     -32.495  68.955 126.096  1.00 33.18          
ATOM   1193  N   GLU   169     -28.480  70.392 123.095  1.00 33.09          
ATOM   1194  CA  GLU   169     -27.297  70.352 122.289  1.00 34.11          
ATOM   1195  C   GLU   169     -26.418  69.195 122.690  1.00 32.63          
ATOM   1196  O   GLU   169     -26.570  68.632 123.762  1.00 32.76          
ATOM   1197  CB  GLU   169     -26.506  71.654 122.435  1.00 35.73          
ATOM   1198  CG  GLU   169     -27.307  72.852 122.012  1.00 41.78          
ATOM   1199  CD  GLU   169     -26.585  73.743 121.024  1.00 49.95          
ATOM   1200  OE1 GLU   169     -25.838  74.666 121.452  1.00 53.88          
ATOM   1201  OE2 GLU   169     -26.810  73.547 119.807  1.00 57.45          
ATOM   1202  N   PRO   170     -25.519  68.817 121.810  1.00 31.65          
ATOM   1203  CA  PRO   170     -24.605  67.724 122.055  1.00 32.58          
ATOM   1204  C   PRO   170     -23.891  67.695 123.425  1.00 32.35          
ATOM   1205  O   PRO   170     -23.740  66.614 124.027  1.00 32.03          
ATOM   1206  CB  PRO   170     -23.635  67.841 120.881  1.00 31.62          
ATOM   1207  CG  PRO   170     -24.494  68.300 119.782  1.00 30.98          
ATOM   1208  CD  PRO   170     -25.387  69.323 120.426  1.00 32.12          
ATOM   1209  N   ASP   171     -23.421  68.837 123.894  1.00 32.06          
ATOM   1210  CA  ASP   171     -22.757  68.891 125.194  1.00 32.67          
ATOM   1211  C   ASP   171     -23.691  68.959 126.392  1.00 31.95          
ATOM   1212  O   ASP   171     -23.216  69.175 127.470  1.00 32.48          
ATOM   1213  CB  ASP   171     -21.724  70.048 125.276  1.00 34.02          
ATOM   1214  CG  ASP   171     -22.351  71.432 125.304  1.00 35.15          
ATOM   1215  OD1 ASP   171     -23.597  71.583 125.243  1.00 37.32          
ATOM   1216  OD2 ASP   171     -21.534  72.389 125.320  1.00 43.55          
ATOM   1217  N   GLY   172     -25.004  68.818 126.209  1.00 31.43          
ATOM   1218  CA  GLY   172     -25.924  68.798 127.335  1.00 31.63          
ATOM   1219  C   GLY   172     -26.556  70.158 127.700  1.00 31.89          
ATOM   1220  O   GLY   172     -27.315  70.227 128.662  1.00 30.08          
ATOM   1221  N   THR   173     -26.247  71.214 126.936  1.00 32.65          
ATOM   1222  CA  THR   173     -26.887  72.551 127.114  1.00 33.39          
ATOM   1223  C   THR   173     -28.309  72.510 126.579  1.00 33.70          
ATOM   1224  O   THR   173     -28.561  71.994 125.487  1.00 32.21          
ATOM   1225  CB  THR   173     -26.106  73.635 126.323  1.00 33.52          
ATOM   1226  OG1 THR   173     -24.736  73.609 126.693  1.00 36.35          
ATOM   1227  CG2 THR   173     -26.641  75.020 126.525  1.00 34.69          
ATOM   1228  N   LEU   174     -29.248  73.034 127.373  1.00 33.64          
ATOM   1229  CA  LEU   174     -30.600  73.225 126.936  1.00 34.20          
ATOM   1230  C   LEU   174     -30.659  74.558 126.120  1.00 35.02          
ATOM   1231  O   LEU   174     -30.139  75.597 126.570  1.00 34.35          
ATOM   1232  CB  LEU   174     -31.513  73.252 128.148  1.00 33.97          
ATOM   1233  CG  LEU   174     -32.999  73.531 127.922  1.00 35.80          
ATOM   1234  CD1 LEU   174     -33.683  72.475 127.025  1.00 32.98          
ATOM   1235  CD2 LEU   174     -33.686  73.668 129.299  1.00 33.70          
ATOM   1236  N   VAL   175     -31.250  74.505 124.924  1.00 34.48          
ATOM   1237  CA  VAL   175     -31.397  75.678 124.085  1.00 34.67          
ATOM   1238  C   VAL   175     -32.884  75.926 123.990  1.00 35.50          
ATOM   1239  O   VAL   175     -33.639  74.974 123.968  1.00 35.14          
ATOM   1240  CB  VAL   175     -30.773  75.497 122.729  1.00 33.55          
ATOM   1241  CG1 VAL   175     -31.181  76.628 121.773  1.00 33.55          
ATOM   1242  CG2 VAL   175     -29.270  75.425 122.841  1.00 33.74          
ATOM   1243  N   VAL   176     -33.312  77.197 124.100  1.00 37.14          
ATOM   1244  CA  VAL   176     -34.637  77.626 123.579  1.00 37.35          
ATOM   1245  C   VAL   176     -34.275  78.560 122.464  1.00 37.18          
ATOM   1246  O   VAL   176     -33.380  79.418 122.604  1.00 38.43          
ATOM   1247  CB  VAL   176     -35.612  78.244 124.598  1.00 38.40          
ATOM   1248  CG1 VAL   176     -36.820  78.818 123.876  1.00 40.93          
ATOM   1249  CG2 VAL   176     -36.132  77.184 125.554  1.00 39.70          
ATOM   1250  N   GLY   177     -34.885  78.329 121.311  1.00 36.41          
ATOM   1251  CA  GLY   177     -34.430  78.992 120.109  1.00 36.42          
ATOM   1252  C   GLY   177     -35.118  78.567 118.833  1.00 36.01          
ATOM   1253  O   GLY   177     -36.227  78.056 118.836  1.00 35.78          
END
