
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  128 (  966),  selected  128 , name 2uyp_B
# Molecule2: number of CA atoms  152 ( 1118),  selected  152 , name T0423.pdb
# PARAMETERS: 2uyp_B.T0423.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_B      M       1           -
LGA    K     2_B      S       2           -
LGA    K     3_B      D       3           -
LGA    I     4_B      V       4           -
LGA    I     5_B      I       5           -
LGA    E     6_B      E       6           -
LGA    T     7_B      G       7           -
LGA    -       -      R       8           -
LGA    -       -      L       9           -
LGA    -       -      K      10           -
LGA    -       -      E      11           -
LGA    -       -      L      12           -
LGA    -       -      G      13           -
LGA    -       -      F      14           -
LGA    -       -      T      15           -
LGA    -       -      L      16           -
LGA    Q     8_B      P      17           #
LGA    R     9_B      V      18          2.192
LGA    A    10_B      -       -           -
LGA    P    11_B      -       -           -
LGA    G    12_B      -       -           -
LGA    A    13_B      -       -           -
LGA    I    14_B      A      23           #
LGA    G    15_B      A      24          4.224
LGA    P    16_B      N      25          2.750
LGA    Y    17_B      Y      26          1.035
LGA    V    18_B      V      27          0.780
LGA    Q    19_B      P      28          0.725
LGA    G    20_B      F      29          0.626
LGA    V    21_B      T      30          1.148
LGA    D    22_B      I      31          2.146
LGA    L    23_B      S      32          2.653
LGA    G    24_B      G      33          3.445
LGA    S    25_B      N      34          1.562
LGA    M    26_B      L      35          1.288
LGA    V    27_B      L      36          0.813
LGA    F    28_B      Y      37          0.693
LGA    T    29_B      V      38          1.006
LGA    S    30_B      S      39          0.888
LGA    G    31_B      G      40          0.770
LGA    Q    32_B      Q      41          0.670
LGA    I    33_B      L      42          0.902
LGA    P    34_B      P      43          0.851
LGA    V    35_B      M      44          1.854
LGA    X    36_B      E      45          2.107
LGA    P    37_B      -       -           -
LGA    Q    38_B      -       -           -
LGA    T    39_B      S      46          2.430
LGA    G    40_B      G      47          1.908
LGA    E    41_B      K      48          1.497
LGA    I    42_B      I      49          1.879
LGA    P    43_B      A      50          1.896
LGA    A    44_B      V      51          2.958
LGA    -       -      T      52           -
LGA    -       -      G      53           -
LGA    -       -      L      54           -
LGA    -       -      V      55           -
LGA    -       -      G      56           -
LGA    -       -      R      57           -
LGA    -       -      D      58           -
LGA    -       -      V      59           -
LGA    -       -      D      60           -
LGA    -       -      V      61           -
LGA    -       -      A      62           -
LGA    D    45_B      S      63          2.632
LGA    V    46_B      A      64          1.298
LGA    Q    47_B      Q      65          2.248
LGA    D    48_B      R      66          2.054
LGA    Q    49_B      A      67          0.938
LGA    A    50_B      A      68          0.712
LGA    R    51_B      E      69          0.670
LGA    L    52_B      L      70          0.699
LGA    S    53_B      C      71          0.320
LGA    L    54_B      A      72          0.248
LGA    E    55_B      V      73          0.533
LGA    N    56_B      N      74          0.589
LGA    V    57_B      I      75          0.581
LGA    K    58_B      L      76          0.771
LGA    A    59_B      A      77          1.010
LGA    I    60_B      Q      78          1.186
LGA    V    61_B      V      79          1.360
LGA    V    62_B      K      80          1.901
LGA    A    63_B      A      81          1.833
LGA    A    64_B      A      82          2.096
LGA    G    65_B      L      83          2.018
LGA    -       -      N      84           -
LGA    -       -      G      85           -
LGA    -       -      D      86           -
LGA    -       -      L      87           -
LGA    -       -      S      88           -
LGA    L    66_B      K      89          3.317
LGA    S    67_B      I      90          2.902
LGA    V    68_B      -       -           -
LGA    G    69_B      R      91          5.156
LGA    D    70_B      R      92          2.264
LGA    I    71_B      V      93          1.557
LGA    I    72_B      I      94          0.488
LGA    K    73_B      K      95          1.311
LGA    M    74_B      L      96          1.456
LGA    T    75_B      N      97          1.025
LGA    V    76_B      G      98          1.015
LGA    F    77_B      F      99          1.200
LGA    I    78_B      V     100          1.206
LGA    T    79_B      A     101          1.357
LGA    D    80_B      S     102          2.019
LGA    -       -      V     103           -
LGA    -       -      P     104           -
LGA    -       -      E     105           -
LGA    L    81_B      F     106          4.258
LGA    N    82_B      V     107          3.997
LGA    D    83_B      E     108          4.670
LGA    F    84_B      Q     109          2.149
LGA    A    85_B      H     110          4.641
LGA    T    86_B      L     111          3.511
LGA    I    87_B      V     112          1.654
LGA    N    88_B      I     113          3.738
LGA    E    89_B      N     114          3.284
LGA    V    90_B      G     115          1.568
LGA    Y    91_B      A     116          2.596
LGA    K    92_B      S     117          3.484
LGA    Q    93_B      N     118          2.134
LGA    F    94_B      L     119          0.967
LGA    F    95_B      I     120          2.921
LGA    D    96_B      A     121          2.950
LGA    E    97_B      T     122          1.215
LGA    H    98_B      V     123          2.308
LGA    -       -      L     124           -
LGA    Q    99_B      G     125          0.463
LGA    A   100_B      E     126          3.030
LGA    T   101_B      P     127          4.261
LGA    -       -      G     128           -
LGA    Y   102_B      R     129          1.927
LGA    P   103_B      H     130          1.318
LGA    T   104_B      A     131          1.324
LGA    R   105_B      R     132          1.356
LGA    S   106_B      A     133          1.704
LGA    C   107_B      A     134          1.870
LGA    V   108_B      V     135          1.634
LGA    Q   109_B      G     136          1.147
LGA    V   110_B      M     137          1.655
LGA    A   111_B      A     138          1.175
LGA    R   112_B      S     139          1.225
LGA    L   113_B      L     140          0.595
LGA    P   114_B      P     141          0.258
LGA    K   115_B      F     142          0.705
LGA    D   116_B      N     143          0.842
LGA    V   117_B      A     144          0.783
LGA    K   118_B      S     145          1.190
LGA    L   119_B      V     146          1.263
LGA    E   120_B      E     147          0.956
LGA    I   121_B      I     148          0.801
LGA    E   122_B      D     149          0.847
LGA    A   123_B      A     150          0.678
LGA    I   124_B      I     151          0.841
LGA    A   125_B      V     152          1.171
LGA    V   126_B      E     153          1.529
LGA    R   127_B      I     154          2.057
LGA    S   128_B      D     155          4.396
LGA    -       -      V     156           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  128  152    5.0    112    2.06    25.89     64.560     5.190

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.583195 * X  +  -0.405911 * Y  +  -0.703647 * Z  + 100.561234
  Y_new =   0.086166 * X  +  -0.892230 * Y  +   0.443283 * Z  +  57.635914
  Z_new =  -0.807749 * X  +   0.197891 * Y  +   0.555320 * Z  +  24.954283 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.342324   -2.799269  [ DEG:    19.6137   -160.3863 ]
  Theta =   0.940324    2.201269  [ DEG:    53.8766    126.1234 ]
  Phi   =   2.994906   -0.146687  [ DEG:   171.5955     -8.4045 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2uyp_B                                        
REMARK     2: T0423.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2uyp_B.T0423.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  128  152   5.0  112   2.06   25.89  64.560
REMARK  ---------------------------------------------------------- 
MOLECULE 2uyp_B
HEADER    UNKNOWN FUNCTION                        11-APR-07   2UYP              
TITLE     CRYSTAL STRUCTURE OF E. COLI TDCF WITH BOUND PROPIONATE               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN TDCF;                                              
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 SYNONYM: TDCF;                                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 STRAIN: MC4100;                                                      
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21-DE3 GOLD;                             
SOURCE   6 EXPRESSION_SYSTEM_VECTOR: PET28A;                                    
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PETHF1                                    
KEYWDS    YJGF/YER057C/UK114 FAMILY, 2-KETOBUTYRATE, UNKNOWN FUNCTION,          
KEYWDS   2 PROPIONATE, TDCF PROTEIN, LIGAND BINDING                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.D.BURMAN,C.E.M.STEVENSON,R.G.SAWERS,D.M.LAWSON                      
REVDAT   1   29-MAY-07 2UYP    0                                                
JRNL        AUTH   J.D.BURMAN,C.E.M.STEVENSON,R.G.SAWERS,D.M.LAWSON             
JRNL        TITL   THE CRYSTAL STRUCTURE OF ESCHERICHIA COLI TDCF, A            
JRNL        TITL 2 MEMBER OF THE HIGHLY CONSERVED YJGF/YER057C/UK114            
JRNL        TITL 3 FAMILY.                                                      
JRNL        REF    BMC STRUCT.BIOL.              V.   7    30 2007              
JRNL        REFN                UK ESSN 1472-6807                               
REMARK   2 RESOLUTION. 2.44 ANGSTROMS.                                          
DBREF  2UYP A    1   129  UNP    P0AGL2   TDCF_ECOLI       1    129             
DBREF  2UYP B    1   129  UNP    P0AGL2   TDCF_ECOLI       1    129             
DBREF  2UYP C    1   129  UNP    P0AGL2   TDCF_ECOLI       1    129             
SEQRES   1 A  129  MET LYS LYS ILE ILE GLU THR GLN ARG ALA PRO GLY ALA          
SEQRES   2 A  129  ILE GLY PRO TYR VAL GLN GLY VAL ASP LEU GLY SER MET          
SEQRES   3 A  129  VAL PHE THR SER GLY GLN ILE PRO VAL OCS PRO GLN THR          
SEQRES   4 A  129  GLY GLU ILE PRO ALA ASP VAL GLN ASP GLN ALA ARG LEU          
SEQRES   5 A  129  SER LEU GLU ASN VAL LYS ALA ILE VAL VAL ALA ALA GLY          
SEQRES   6 A  129  LEU SER VAL GLY ASP ILE ILE LYS MET THR VAL PHE ILE          
SEQRES   7 A  129  THR ASP LEU ASN ASP PHE ALA THR ILE ASN GLU VAL TYR          
SEQRES   8 A  129  LYS GLN PHE PHE ASP GLU HIS GLN ALA THR TYR PRO THR          
SEQRES   9 A  129  ARG SER CYS VAL GLN VAL ALA ARG LEU PRO LYS ASP VAL          
SEQRES  10 A  129  LYS LEU GLU ILE GLU ALA ILE ALA VAL ARG SER ALA              
SEQRES   1 B  129  MET LYS LYS ILE ILE GLU THR GLN ARG ALA PRO GLY ALA          
SEQRES   2 B  129  ILE GLY PRO TYR VAL GLN GLY VAL ASP LEU GLY SER MET          
SEQRES   3 B  129  VAL PHE THR SER GLY GLN ILE PRO VAL OCS PRO GLN THR          
SEQRES   4 B  129  GLY GLU ILE PRO ALA ASP VAL GLN ASP GLN ALA ARG LEU          
SEQRES   5 B  129  SER LEU GLU ASN VAL LYS ALA ILE VAL VAL ALA ALA GLY          
SEQRES   6 B  129  LEU SER VAL GLY ASP ILE ILE LYS MET THR VAL PHE ILE          
SEQRES   7 B  129  THR ASP LEU ASN ASP PHE ALA THR ILE ASN GLU VAL TYR          
SEQRES   8 B  129  LYS GLN PHE PHE ASP GLU HIS GLN ALA THR TYR PRO THR          
SEQRES   9 B  129  ARG SER CYS VAL GLN VAL ALA ARG LEU PRO LYS ASP VAL          
SEQRES  10 B  129  LYS LEU GLU ILE GLU ALA ILE ALA VAL ARG SER ALA              
SEQRES   1 C  129  MET LYS LYS ILE ILE GLU THR GLN ARG ALA PRO GLY ALA          
SEQRES   2 C  129  ILE GLY PRO TYR VAL GLN GLY VAL ASP LEU GLY SER MET          
SEQRES   3 C  129  VAL PHE THR SER GLY GLN ILE PRO VAL OCS PRO GLN THR          
SEQRES   4 C  129  GLY GLU ILE PRO ALA ASP VAL GLN ASP GLN ALA ARG LEU          
SEQRES   5 C  129  SER LEU GLU ASN VAL LYS ALA ILE VAL VAL ALA ALA GLY          
SEQRES   6 C  129  LEU SER VAL GLY ASP ILE ILE LYS MET THR VAL PHE ILE          
SEQRES   7 C  129  THR ASP LEU ASN ASP PHE ALA THR ILE ASN GLU VAL TYR          
SEQRES   8 C  129  LYS GLN PHE PHE ASP GLU HIS GLN ALA THR TYR PRO THR          
SEQRES   9 C  129  ARG SER CYS VAL GLN VAL ALA ARG LEU PRO LYS ASP VAL          
SEQRES  10 C  129  LYS LEU GLU ILE GLU ALA ILE ALA VAL ARG SER ALA              
HET    OCS  A  36       9                                                       
HET    OCS  B  36       9                                                       
HET    OCS  C  36       9                                                       
HET    PPI  B1129       5                                                       
HET    PPI  C1129       5                                                       
HETNAM     OCS CYSTEINESULFONIC ACID                                            
HETNAM     PPI PROPANOIC ACID                                                   
FORMUL   1  OCS    3(C3 H7 N O5 S)                                              
FORMUL   4  PPI    2(C3 H6 O2)                                                  
FORMUL   6  HOH   *195(H2 O)                                                    
CRYST1   72.435   85.744   62.512  90.00  90.00  90.00 P 21 21 2    12          
ATOM    955  N   MET B   1      56.307  41.813  31.064  1.00 50.44           N  
ATOM    956  CA  MET B   1      56.883  41.372  32.384  1.00 50.43           C  
ATOM    957  C   MET B   1      57.276  42.545  33.306  1.00 49.12           C  
ATOM    958  O   MET B   1      56.681  42.703  34.397  1.00 50.07           O  
ATOM    959  CB  MET B   1      58.069  40.428  32.140  1.00 50.38           C  
ATOM    960  CG  MET B   1      58.464  39.478  33.266  1.00 50.29           C  
ATOM    961  SD  MET B   1      59.247  38.015  32.513  1.00 54.02           S  
ATOM    962  CE  MET B   1      59.520  36.842  33.882  1.00 51.89           C  
ATOM    963  N   LYS B   2      58.249  43.373  32.879  1.00 47.22           N  
ATOM    964  CA  LYS B   2      58.849  44.425  33.732  1.00 44.92           C  
ATOM    965  C   LYS B   2      58.997  43.973  35.211  1.00 43.49           C  
ATOM    966  O   LYS B   2      58.682  44.696  36.148  1.00 44.55           O  
ATOM    967  CB  LYS B   2      58.077  45.757  33.638  1.00 44.83           C  
ATOM    968  CG  LYS B   2      58.776  46.831  32.805  1.00 44.42           C  
ATOM    969  CD  LYS B   2      58.693  48.262  33.414  1.00 40.50           C  
ATOM    970  CE  LYS B   2      57.512  49.078  32.876  1.00 41.10           C  
ATOM    971  NZ  LYS B   2      57.421  49.284  31.347  1.00 41.39           N  
ATOM    972  N   LYS B   3      59.491  42.770  35.412  1.00 40.56           N  
ATOM    973  CA  LYS B   3      59.619  42.213  36.740  1.00 37.82           C  
ATOM    974  C   LYS B   3      60.977  42.691  37.296  1.00 36.11           C  
ATOM    975  O   LYS B   3      62.040  42.466  36.688  1.00 35.18           O  
ATOM    976  CB  LYS B   3      59.529  40.667  36.622  1.00 37.55           C  
ATOM    977  CG  LYS B   3      59.083  39.872  37.832  1.00 37.75           C  
ATOM    978  N   ILE B   4      60.921  43.376  38.429  1.00 34.45           N  
ATOM    979  CA  ILE B   4      62.085  43.657  39.278  1.00 32.98           C  
ATOM    980  C   ILE B   4      62.718  42.357  39.814  1.00 32.04           C  
ATOM    981  O   ILE B   4      62.002  41.444  40.221  1.00 31.99           O  
ATOM    982  CB  ILE B   4      61.656  44.577  40.429  1.00 33.35           C  
ATOM    983  CG1 ILE B   4      61.513  46.005  39.925  1.00 33.70           C  
ATOM    984  CG2 ILE B   4      62.625  44.560  41.587  1.00 32.31           C  
ATOM    985  CD1 ILE B   4      60.765  46.876  40.936  1.00 37.46           C  
ATOM    986  N   ILE B   5      64.046  42.264  39.762  1.00 30.29           N  
ATOM    987  CA  ILE B   5      64.787  41.183  40.422  1.00 29.74           C  
ATOM    988  C   ILE B   5      65.358  41.583  41.783  1.00 29.02           C  
ATOM    989  O   ILE B   5      65.944  42.659  41.977  1.00 27.14           O  
ATOM    990  CB  ILE B   5      65.903  40.607  39.557  1.00 30.38           C  
ATOM    991  CG1 ILE B   5      65.333  40.102  38.215  1.00 30.92           C  
ATOM    992  CG2 ILE B   5      66.595  39.475  40.282  1.00 29.31           C  
ATOM    993  CD1 ILE B   5      66.398  39.629  37.299  1.00 30.38           C  
ATOM    994  N   GLU B   6      65.120  40.700  42.738  1.00 29.17           N  
ATOM    995  CA  GLU B   6      65.531  40.920  44.110  1.00 29.74           C  
ATOM    996  C   GLU B   6      66.137  39.653  44.689  1.00 28.57           C  
ATOM    997  O   GLU B   6      65.531  38.575  44.634  1.00 29.25           O  
ATOM    998  CB  GLU B   6      64.352  41.341  44.947  1.00 29.70           C  
ATOM    999  CG  GLU B   6      64.748  42.195  46.093  1.00 34.85           C  
ATOM   1000  CD  GLU B   6      63.569  42.478  46.981  1.00 43.93           C  
ATOM   1001  OE1 GLU B   6      62.467  42.847  46.450  1.00 44.76           O  
ATOM   1002  OE2 GLU B   6      63.756  42.314  48.212  1.00 46.66           O  
ATOM   1003  N   THR B   7      67.337  39.783  45.234  1.00 26.81           N  
ATOM   1004  CA  THR B   7      68.062  38.632  45.775  1.00 24.70           C  
ATOM   1005  C   THR B   7      68.900  39.106  46.947  1.00 25.05           C  
ATOM   1006  O   THR B   7      69.379  40.229  46.959  1.00 24.91           O  
ATOM   1007  CB  THR B   7      68.917  37.939  44.685  1.00 23.69           C  
ATOM   1008  OG1 THR B   7      69.641  36.853  45.250  1.00 24.51           O  
ATOM   1009  CG2 THR B   7      69.911  38.902  44.025  1.00 23.44           C  
ATOM   1010  N   GLN B   8      69.074  38.240  47.935  1.00 26.11           N  
ATOM   1011  CA  GLN B   8      69.958  38.512  49.072  1.00 26.27           C  
ATOM   1012  C   GLN B   8      71.373  38.002  48.799  1.00 25.91           C  
ATOM   1013  O   GLN B   8      72.317  38.367  49.477  1.00 26.90           O  
ATOM   1014  CB  GLN B   8      69.364  37.864  50.325  1.00 27.50           C  
ATOM   1015  N   ARG B   9      71.539  37.176  47.774  1.00 25.76           N  
ATOM   1016  CA  ARG B   9      72.865  36.708  47.372  1.00 25.22           C  
ATOM   1017  C   ARG B   9      73.710  37.763  46.607  1.00 24.05           C  
ATOM   1018  O   ARG B   9      74.860  37.502  46.216  1.00 23.27           O  
ATOM   1019  CB  ARG B   9      72.711  35.412  46.555  1.00 26.25           C  
ATOM   1020  CG  ARG B   9      72.136  34.215  47.371  1.00 30.12           C  
ATOM   1021  CD  ARG B   9      72.720  32.847  46.888  1.00 37.07           C  
ATOM   1022  N   ALA B  10      73.136  38.938  46.355  1.00 22.91           N  
ATOM   1023  CA  ALA B  10      73.916  40.106  45.897  1.00 22.72           C  
ATOM   1024  C   ALA B  10      73.622  41.214  46.877  1.00 23.05           C  
ATOM   1025  O   ALA B  10      72.597  41.148  47.573  1.00 21.96           O  
ATOM   1026  CB  ALA B  10      73.568  40.526  44.420  1.00 21.31           C  
ATOM   1027  N   PRO B  11      74.513  42.234  46.963  1.00 24.17           N  
ATOM   1028  CA  PRO B  11      74.233  43.332  47.883  1.00 25.24           C  
ATOM   1029  C   PRO B  11      72.943  44.070  47.476  1.00 26.21           C  
ATOM   1030  O   PRO B  11      72.638  44.209  46.280  1.00 25.12           O  
ATOM   1031  CB  PRO B  11      75.462  44.238  47.754  1.00 25.31           C  
ATOM   1032  CG  PRO B  11      76.473  43.448  47.123  1.00 24.51           C  
ATOM   1033  CD  PRO B  11      75.766  42.467  46.240  1.00 24.28           C  
ATOM   1034  N   GLY B  12      72.189  44.509  48.482  1.00 28.03           N  
ATOM   1035  CA  GLY B  12      70.845  45.035  48.269  1.00 29.14           C  
ATOM   1036  C   GLY B  12      71.039  46.403  47.684  1.00 31.00           C  
ATOM   1037  O   GLY B  12      72.109  47.007  47.860  1.00 30.50           O  
ATOM   1038  N   ALA B  13      70.025  46.883  46.976  1.00 32.91           N  
ATOM   1039  CA  ALA B  13      69.987  48.275  46.515  1.00 35.44           C  
ATOM   1040  C   ALA B  13      69.636  49.219  47.671  1.00 36.76           C  
ATOM   1041  O   ALA B  13      68.513  49.177  48.191  1.00 38.17           O  
ATOM   1042  CB  ALA B  13      68.931  48.418  45.398  1.00 35.78           C  
ATOM   1043  N   ILE B  14      70.573  50.073  48.073  1.00 38.00           N  
ATOM   1044  CA  ILE B  14      70.291  51.137  49.050  1.00 38.23           C  
ATOM   1045  C   ILE B  14      70.473  52.445  48.262  1.00 38.26           C  
ATOM   1046  O   ILE B  14      71.616  52.889  47.994  1.00 39.09           O  
ATOM   1047  CB  ILE B  14      71.216  51.074  50.301  1.00 38.85           C  
ATOM   1048  CG1 ILE B  14      71.537  49.611  50.726  1.00 39.68           C  
ATOM   1049  CG2 ILE B  14      70.637  51.947  51.484  1.00 39.86           C  
ATOM   1050  CD1 ILE B  14      70.395  48.867  51.456  1.00 41.42           C  
ATOM   1051  N   GLY B  15      69.349  53.021  47.826  1.00 36.81           N  
ATOM   1052  CA  GLY B  15      69.389  53.924  46.647  1.00 35.06           C  
ATOM   1053  C   GLY B  15      68.247  53.724  45.638  1.00 33.29           C  
ATOM   1054  O   GLY B  15      67.375  52.806  45.832  1.00 33.47           O  
ATOM   1055  N   PRO B  16      68.168  54.632  44.613  1.00 30.92           N  
ATOM   1056  CA  PRO B  16      67.081  54.622  43.626  1.00 28.54           C  
ATOM   1057  C   PRO B  16      67.403  53.801  42.339  1.00 26.30           C  
ATOM   1058  O   PRO B  16      67.374  54.312  41.222  1.00 25.36           O  
ATOM   1059  CB  PRO B  16      66.859  56.119  43.364  1.00 28.21           C  
ATOM   1060  CG  PRO B  16      68.200  56.738  43.560  1.00 28.13           C  
ATOM   1061  CD  PRO B  16      69.040  55.802  44.406  1.00 30.44           C  
ATOM   1062  N   TYR B  17      67.700  52.512  42.529  1.00 24.51           N  
ATOM   1063  CA  TYR B  17      67.840  51.576  41.435  1.00 20.95           C  
ATOM   1064  C   TYR B  17      67.369  50.236  42.002  1.00 18.60           C  
ATOM   1065  O   TYR B  17      67.184  50.109  43.195  1.00 17.95           O  
ATOM   1066  CB  TYR B  17      69.307  51.554  40.985  1.00 22.54           C  
ATOM   1067  CG  TYR B  17      70.216  51.165  42.109  1.00 21.95           C  
ATOM   1068  CD1 TYR B  17      70.561  52.075  43.092  1.00 23.33           C  
ATOM   1069  CD2 TYR B  17      70.643  49.857  42.239  1.00 21.22           C  
ATOM   1070  CE1 TYR B  17      71.337  51.693  44.170  1.00 25.88           C  
ATOM   1071  CE2 TYR B  17      71.391  49.465  43.288  1.00 23.47           C  
ATOM   1072  CZ  TYR B  17      71.763  50.373  44.255  1.00 25.04           C  
ATOM   1073  OH  TYR B  17      72.575  49.947  45.302  1.00 27.18           O  
ATOM   1074  N   VAL B  18      67.195  49.237  41.144  1.00 16.32           N  
ATOM   1075  CA  VAL B  18      66.915  47.848  41.556  1.00 14.26           C  
ATOM   1076  C   VAL B  18      68.063  46.983  41.057  1.00 14.58           C  
ATOM   1077  O   VAL B  18      68.739  47.383  40.136  1.00 16.53           O  
ATOM   1078  CB  VAL B  18      65.569  47.328  40.986  1.00 13.67           C  
ATOM   1079  CG1 VAL B  18      64.379  48.164  41.572  1.00 11.50           C  
ATOM   1080  CG2 VAL B  18      65.551  47.326  39.426  1.00  8.73           C  
ATOM   1081  N   GLN B  19      68.317  45.839  41.676  1.00 14.48           N  
ATOM   1082  CA  GLN B  19      69.354  44.892  41.232  1.00 14.75           C  
ATOM   1083  C   GLN B  19      69.310  44.450  39.762  1.00 15.19           C  
ATOM   1084  O   GLN B  19      70.355  44.390  39.066  1.00 15.16           O  
ATOM   1085  CB  GLN B  19      69.335  43.655  42.132  1.00 14.52           C  
ATOM   1086  CG  GLN B  19      69.896  43.872  43.519  1.00 14.87           C  
ATOM   1087  CD  GLN B  19      69.592  42.697  44.429  1.00 19.38           C  
ATOM   1088  OE1 GLN B  19      68.607  41.992  44.227  1.00 21.13           O  
ATOM   1089  NE2 GLN B  19      70.443  42.465  45.434  1.00 20.91           N  
ATOM   1090  N   GLY B  20      68.117  44.067  39.313  1.00 15.01           N  
ATOM   1091  CA  GLY B  20      67.903  43.683  37.954  1.00 14.92           C  
ATOM   1092  C   GLY B  20      66.461  43.831  37.533  1.00 16.37           C  
ATOM   1093  O   GLY B  20      65.574  44.025  38.341  1.00 15.71           O  
ATOM   1094  N   VAL B  21      66.253  43.794  36.229  1.00 18.47           N  
ATOM   1095  CA  VAL B  21      64.946  43.794  35.649  1.00 21.34           C  
ATOM   1096  C   VAL B  21      64.884  42.627  34.656  1.00 22.38           C  
ATOM   1097  O   VAL B  21      65.759  42.426  33.827  1.00 22.68           O  
ATOM   1098  CB  VAL B  21      64.563  45.198  34.997  1.00 21.24           C  
ATOM   1099  CG1 VAL B  21      63.331  45.062  34.139  1.00 22.67           C  
ATOM   1100  CG2 VAL B  21      64.267  46.242  36.082  1.00 22.31           C  
ATOM   1101  N   ASP B  22      63.824  41.850  34.775  1.00 24.93           N  
ATOM   1102  CA  ASP B  22      63.482  40.771  33.840  1.00 25.97           C  
ATOM   1103  C   ASP B  22      62.330  41.238  32.922  1.00 27.12           C  
ATOM   1104  O   ASP B  22      61.267  41.688  33.395  1.00 27.57           O  
ATOM   1105  CB  ASP B  22      63.000  39.616  34.687  1.00 26.42           C  
ATOM   1106  CG  ASP B  22      62.809  38.362  33.908  1.00 26.17           C  
ATOM   1107  OD1 ASP B  22      62.737  38.430  32.647  1.00 22.95           O  
ATOM   1108  OD2 ASP B  22      62.709  37.320  34.608  1.00 26.26           O  
ATOM   1109  N   LEU B  23      62.549  41.159  31.627  1.00 27.88           N  
ATOM   1110  CA  LEU B  23      61.626  41.729  30.660  1.00 28.98           C  
ATOM   1111  C   LEU B  23      60.903  40.627  29.880  1.00 29.79           C  
ATOM   1112  O   LEU B  23      60.062  40.919  29.029  1.00 31.12           O  
ATOM   1113  CB  LEU B  23      62.394  42.605  29.651  1.00 28.90           C  
ATOM   1114  CG  LEU B  23      63.194  43.820  30.108  1.00 28.75           C  
ATOM   1115  CD1 LEU B  23      63.877  44.375  28.885  1.00 27.64           C  
ATOM   1116  CD2 LEU B  23      62.274  44.855  30.749  1.00 25.66           C  
ATOM   1117  N   GLY B  24      61.250  39.368  30.139  1.00 29.96           N  
ATOM   1118  CA  GLY B  24      60.671  38.252  29.406  1.00 29.30           C  
ATOM   1119  C   GLY B  24      61.783  37.605  28.635  1.00 29.13           C  
ATOM   1120  O   GLY B  24      62.330  36.610  29.067  1.00 29.61           O  
ATOM   1121  N   SER B  25      62.130  38.232  27.519  1.00 28.86           N  
ATOM   1122  CA  SER B  25      63.184  37.819  26.604  1.00 29.84           C  
ATOM   1123  C   SER B  25      64.618  38.126  27.121  1.00 29.69           C  
ATOM   1124  O   SER B  25      65.569  37.465  26.694  1.00 28.93           O  
ATOM   1125  CB  SER B  25      63.017  38.596  25.275  1.00 30.17           C  
ATOM   1126  OG  SER B  25      62.852  39.996  25.521  1.00 31.15           O  
ATOM   1127  N   MET B  26      64.749  39.184  27.945  1.00 28.55           N  
ATOM   1128  CA  MET B  26      66.041  39.663  28.441  1.00 28.38           C  
ATOM   1129  C   MET B  26      66.036  40.139  29.882  1.00 24.57           C  
ATOM   1130  O   MET B  26      65.041  40.621  30.366  1.00 23.04           O  
ATOM   1131  CB  MET B  26      66.770  40.666  27.512  1.00 28.27           C  
ATOM   1132  CG  MET B  26      65.948  41.513  26.547  1.00 30.33           C  
ATOM   1133  SD  MET B  26      66.989  42.486  25.342  1.00 34.54           S  
ATOM   1134  CE  MET B  26      68.549  41.616  25.295  1.00 31.10           C  
ATOM   1135  N   VAL B  27      67.173  39.927  30.539  1.00 22.29           N  
ATOM   1136  CA  VAL B  27      67.489  40.430  31.882  1.00 20.95           C  
ATOM   1137  C   VAL B  27      68.651  41.437  31.838  1.00 19.58           C  
ATOM   1138  O   VAL B  27      69.688  41.205  31.236  1.00 18.76           O  
ATOM   1139  CB  VAL B  27      67.831  39.264  32.839  1.00 21.47           C  
ATOM   1140  CG1 VAL B  27      68.435  39.775  34.160  1.00 19.90           C  
ATOM   1141  CG2 VAL B  27      66.586  38.394  33.077  1.00 21.64           C  
ATOM   1142  N   PHE B  28      68.421  42.588  32.427  1.00 19.05           N  
ATOM   1143  CA  PHE B  28      69.431  43.613  32.608  1.00 18.18           C  
ATOM   1144  C   PHE B  28      69.728  43.646  34.117  1.00 17.18           C  
ATOM   1145  O   PHE B  28      68.794  43.608  34.929  1.00 15.91           O  
ATOM   1146  CB  PHE B  28      68.881  45.001  32.177  1.00 18.86           C  
ATOM   1147  CG  PHE B  28      68.786  45.217  30.668  1.00 20.24           C  
ATOM   1148  CD1 PHE B  28      67.672  44.745  29.935  1.00 19.72           C  
ATOM   1149  CD2 PHE B  28      69.796  45.932  29.980  1.00 19.66           C  
ATOM   1150  CE1 PHE B  28      67.565  45.001  28.531  1.00 19.64           C  
ATOM   1151  CE2 PHE B  28      69.698  46.180  28.596  1.00 18.56           C  
ATOM   1152  CZ  PHE B  28      68.560  45.704  27.869  1.00 18.59           C  
ATOM   1153  N   THR B  29      71.017  43.713  34.481  1.00 16.06           N  
ATOM   1154  CA  THR B  29      71.441  43.994  35.865  1.00 14.69           C  
ATOM   1155  C   THR B  29      71.909  45.438  36.011  1.00 14.26           C  
ATOM   1156  O   THR B  29      72.326  46.055  35.040  1.00 13.96           O  
ATOM   1157  CB  THR B  29      72.577  43.017  36.361  1.00 14.83           C  
ATOM   1158  OG1 THR B  29      73.884  43.486  35.967  1.00 14.94           O  
ATOM   1159  CG2 THR B  29      72.337  41.574  35.897  1.00  9.94           C  
ATOM   1160  N   SER B  30      71.810  45.983  37.212  1.00 13.51           N  
ATOM   1161  CA  SER B  30      72.610  47.164  37.586  1.00 12.97           C  
ATOM   1162  C   SER B  30      74.098  46.824  37.559  1.00 12.42           C  
ATOM   1163  O   SER B  30      74.462  45.652  37.656  1.00 12.21           O  
ATOM   1164  CB  SER B  30      72.249  47.613  39.014  1.00 12.37           C  
ATOM   1165  OG  SER B  30      70.963  48.197  39.064  1.00 14.13           O  
ATOM   1166  N   GLY B  31      74.940  47.854  37.486  1.00 12.16           N  
ATOM   1167  CA  GLY B  31      76.375  47.718  37.584  1.00 12.20           C  
ATOM   1168  C   GLY B  31      76.744  47.127  38.923  1.00 13.08           C  
ATOM   1169  O   GLY B  31      76.352  47.653  39.981  1.00 12.83           O  
ATOM   1170  N   GLN B  32      77.483  46.019  38.915  1.00 13.39           N  
ATOM   1171  CA  GLN B  32      77.830  45.352  40.177  1.00 13.05           C  
ATOM   1172  C   GLN B  32      79.253  45.641  40.611  1.00 13.89           C  
ATOM   1173  O   GLN B  32      80.233  45.421  39.853  1.00 15.61           O  
ATOM   1174  CB  GLN B  32      77.580  43.844  40.091  1.00 13.58           C  
ATOM   1175  CG  GLN B  32      76.142  43.428  39.763  1.00 13.15           C  
ATOM   1176  CD  GLN B  32      75.175  43.916  40.802  1.00 16.68           C  
ATOM   1177  OE1 GLN B  32      75.310  43.618  41.999  1.00 18.23           O  
ATOM   1178  NE2 GLN B  32      74.230  44.739  40.374  1.00 16.65           N  
ATOM   1179  N   ILE B  33      79.374  46.121  41.841  1.00 14.67           N  
ATOM   1180  CA  ILE B  33      80.663  46.396  42.496  1.00 14.84           C  
ATOM   1181  C   ILE B  33      81.071  45.270  43.477  1.00 15.68           C  
ATOM   1182  O   ILE B  33      80.222  44.492  43.929  1.00 17.05           O  
ATOM   1183  CB  ILE B  33      80.656  47.781  43.194  1.00 15.06           C  
ATOM   1184  CG1 ILE B  33      79.640  47.808  44.344  1.00 14.31           C  
ATOM   1185  CG2 ILE B  33      80.350  48.878  42.178  1.00 12.80           C  
ATOM   1186  CD1 ILE B  33      79.659  49.054  45.104  1.00 10.11           C  
ATOM   1187  N   PRO B  34      82.393  45.124  43.758  1.00 16.24           N  
ATOM   1188  CA  PRO B  34      82.838  44.026  44.624  1.00 15.10           C  
ATOM   1189  C   PRO B  34      82.585  44.286  46.091  1.00 16.76           C  
ATOM   1190  O   PRO B  34      83.527  44.500  46.853  1.00 18.73           O  
ATOM   1191  CB  PRO B  34      84.307  43.943  44.323  1.00 14.63           C  
ATOM   1192  CG  PRO B  34      84.681  45.319  43.806  1.00 15.03           C  
ATOM   1193  CD  PRO B  34      83.511  45.955  43.237  1.00 14.22           C  
ATOM   1194  N   VAL B  35      81.310  44.358  46.471  1.00 18.08           N  
ATOM   1195  CA  VAL B  35      80.890  44.504  47.853  1.00 18.54           C  
ATOM   1196  C   VAL B  35      80.361  43.111  48.224  1.00 20.59           C  
ATOM   1197  O   VAL B  35      79.554  42.538  47.485  1.00 21.35           O  
ATOM   1198  CB  VAL B  35      79.804  45.641  48.050  1.00 19.02           C  
ATOM   1199  CG1 VAL B  35      79.002  45.484  49.384  1.00 16.52           C  
ATOM   1200  CG2 VAL B  35      80.388  47.059  47.943  1.00 13.96           C  
HETATM 1201  N   OCS B  36      80.860  42.547  49.320  1.00 21.84           N  
HETATM 1202  CA  OCS B  36      80.468  41.221  49.731  1.00 22.85           C  
HETATM 1203  CB  OCS B  36      81.488  40.671  50.713  1.00 23.55           C  
HETATM 1204  SG  OCS B  36      81.373  38.884  51.003  1.00 24.95           S  
HETATM 1205  C   OCS B  36      79.088  41.263  50.389  1.00 23.99           C  
HETATM 1206  O   OCS B  36      78.890  41.999  51.339  1.00 24.57           O  
HETATM 1207  OD1 OCS B  36      82.642  38.391  51.374  1.00 26.23           O  
HETATM 1208  OD2 OCS B  36      80.466  38.664  52.083  1.00 29.36           O  
HETATM 1209  OD3 OCS B  36      80.917  38.214  49.848  1.00 25.00           O  
ATOM   1210  N   PRO B  37      78.124  40.474  49.894  1.00 24.54           N  
ATOM   1211  CA  PRO B  37      76.778  40.561  50.503  1.00 25.42           C  
ATOM   1212  C   PRO B  37      76.617  40.176  52.001  1.00 25.51           C  
ATOM   1213  O   PRO B  37      75.705  40.683  52.612  1.00 24.73           O  
ATOM   1214  CB  PRO B  37      75.922  39.646  49.605  1.00 24.98           C  
ATOM   1215  CG  PRO B  37      76.870  38.830  48.843  1.00 23.35           C  
ATOM   1216  CD  PRO B  37      78.181  39.505  48.778  1.00 24.22           C  
ATOM   1217  N   GLN B  38      77.460  39.291  52.554  1.00 26.77           N  
ATOM   1218  CA  GLN B  38      77.408  38.916  53.989  1.00 28.09           C  
ATOM   1219  C   GLN B  38      78.169  39.886  54.926  1.00 29.58           C  
ATOM   1220  O   GLN B  38      77.724  40.167  56.072  1.00 30.39           O  
ATOM   1221  CB  GLN B  38      77.923  37.489  54.232  1.00 28.30           C  
ATOM   1222  CG  GLN B  38      77.396  36.415  53.252  1.00 31.38           C  
ATOM   1223  N   THR B  39      79.295  40.419  54.447  1.00 29.75           N  
ATOM   1224  CA  THR B  39      80.178  41.209  55.305  1.00 29.91           C  
ATOM   1225  C   THR B  39      80.063  42.686  55.006  1.00 29.89           C  
ATOM   1226  O   THR B  39      80.339  43.504  55.862  1.00 31.35           O  
ATOM   1227  CB  THR B  39      81.638  40.737  55.192  1.00 30.09           C  
ATOM   1228  OG1 THR B  39      82.215  41.214  53.967  1.00 31.49           O  
ATOM   1229  CG2 THR B  39      81.697  39.174  55.225  1.00 29.71           C  
ATOM   1230  N   GLY B  40      79.644  43.037  53.790  1.00 29.56           N  
ATOM   1231  CA  GLY B  40      79.418  44.441  53.401  1.00 27.71           C  
ATOM   1232  C   GLY B  40      80.726  45.170  53.142  1.00 26.93           C  
ATOM   1233  O   GLY B  40      80.738  46.411  52.983  1.00 27.05           O  
ATOM   1234  N   GLU B  41      81.813  44.385  53.147  1.00 25.31           N  
ATOM   1235  CA  GLU B  41      83.182  44.806  52.852  1.00 24.46           C  
ATOM   1236  C   GLU B  41      83.587  44.635  51.357  1.00 23.67           C  
ATOM   1237  O   GLU B  41      83.033  43.808  50.576  1.00 22.68           O  
ATOM   1238  CB  GLU B  41      84.228  44.016  53.670  1.00 24.26           C  
ATOM   1239  CG  GLU B  41      83.983  43.760  55.154  1.00 26.28           C  
ATOM   1240  CD  GLU B  41      84.021  45.031  55.971  1.00 29.21           C  
ATOM   1241  OE1 GLU B  41      84.638  46.021  55.514  1.00 33.33           O  
ATOM   1242  OE2 GLU B  41      83.443  45.053  57.062  1.00 25.13           O  
ATOM   1243  N   ILE B  42      84.623  45.389  51.015  1.00 22.12           N  
ATOM   1244  CA  ILE B  42      85.260  45.318  49.734  1.00 21.19           C  
ATOM   1245  C   ILE B  42      86.642  44.653  49.879  1.00 21.26           C  
ATOM   1246  O   ILE B  42      87.495  45.160  50.607  1.00 22.24           O  
ATOM   1247  CB  ILE B  42      85.337  46.729  49.135  1.00 21.10           C  
ATOM   1248  CG1 ILE B  42      83.878  47.238  48.902  1.00 20.74           C  
ATOM   1249  CG2 ILE B  42      86.234  46.739  47.875  1.00 19.55           C  
ATOM   1250  CD1 ILE B  42      83.692  48.777  48.819  1.00 20.27           C  
ATOM   1251  N   PRO B  43      86.867  43.502  49.206  1.00 20.79           N  
ATOM   1252  CA  PRO B  43      88.224  42.962  49.303  1.00 20.88           C  
ATOM   1253  C   PRO B  43      89.307  43.861  48.626  1.00 21.82           C  
ATOM   1254  O   PRO B  43      89.050  44.554  47.631  1.00 21.59           O  
ATOM   1255  CB  PRO B  43      88.103  41.549  48.699  1.00 20.70           C  
ATOM   1256  CG  PRO B  43      86.916  41.629  47.799  1.00 22.10           C  
ATOM   1257  CD  PRO B  43      85.968  42.663  48.391  1.00 19.87           C  
ATOM   1258  N   ALA B  44      90.503  43.890  49.195  1.00 21.80           N  
ATOM   1259  CA  ALA B  44      91.476  44.828  48.708  1.00 22.30           C  
ATOM   1260  C   ALA B  44      92.051  44.408  47.331  1.00 22.52           C  
ATOM   1261  O   ALA B  44      92.328  45.261  46.491  1.00 22.85           O  
ATOM   1262  CB  ALA B  44      92.553  45.001  49.711  1.00 22.53           C  
ATOM   1263  N   ASP B  45      92.186  43.099  47.122  1.00 21.85           N  
ATOM   1264  CA  ASP B  45      92.861  42.503  45.952  1.00 20.89           C  
ATOM   1265  C   ASP B  45      91.954  42.443  44.701  1.00 19.89           C  
ATOM   1266  O   ASP B  45      90.820  41.949  44.772  1.00 19.58           O  
ATOM   1267  CB  ASP B  45      93.300  41.073  46.344  1.00 20.93           C  
ATOM   1268  CG  ASP B  45      94.248  40.455  45.347  1.00 21.99           C  
ATOM   1269  OD1 ASP B  45      93.798  39.968  44.292  1.00 25.03           O  
ATOM   1270  OD2 ASP B  45      95.453  40.461  45.620  1.00 21.86           O  
ATOM   1271  N   VAL B  46      92.477  42.882  43.563  1.00 19.05           N  
ATOM   1272  CA  VAL B  46      91.691  43.005  42.328  1.00 19.11           C  
ATOM   1273  C   VAL B  46      91.135  41.664  41.831  1.00 19.19           C  
ATOM   1274  O   VAL B  46      90.054  41.659  41.240  1.00 19.02           O  
ATOM   1275  CB  VAL B  46      92.498  43.751  41.197  1.00 19.64           C  
ATOM   1276  CG1 VAL B  46      93.620  42.864  40.658  1.00 20.80           C  
ATOM   1277  CG2 VAL B  46      91.597  44.258  40.078  1.00 18.36           C  
ATOM   1278  N   GLN B  47      91.820  40.537  42.095  1.00 19.38           N  
ATOM   1279  CA  GLN B  47      91.275  39.206  41.700  1.00 21.05           C  
ATOM   1280  C   GLN B  47      90.021  38.873  42.498  1.00 20.71           C  
ATOM   1281  O   GLN B  47      89.030  38.393  41.935  1.00 22.38           O  
ATOM   1282  CB  GLN B  47      92.247  38.029  41.900  1.00 21.16           C  
ATOM   1283  CG  GLN B  47      93.652  38.119  41.335  1.00 22.84           C  
ATOM   1284  CD  GLN B  47      94.519  36.931  41.753  1.00 23.23           C  
ATOM   1285  OE1 GLN B  47      94.062  35.797  41.745  1.00 28.20           O  
ATOM   1286  NE2 GLN B  47      95.776  37.190  42.098  1.00 23.83           N  
ATOM   1287  N   ASP B  48      90.096  39.073  43.816  1.00 19.77           N  
ATOM   1288  CA  ASP B  48      88.948  38.995  44.702  1.00 17.37           C  
ATOM   1289  C   ASP B  48      87.833  39.929  44.303  1.00 15.54           C  
ATOM   1290  O   ASP B  48      86.731  39.478  44.169  1.00 15.78           O  
ATOM   1291  CB  ASP B  48      89.377  39.304  46.130  1.00 18.85           C  
ATOM   1292  CG  ASP B  48      90.204  38.202  46.771  1.00 19.69           C  
ATOM   1293  OD1 ASP B  48      90.050  37.010  46.431  1.00 20.59           O  
ATOM   1294  OD2 ASP B  48      91.013  38.553  47.661  1.00 24.71           O  
ATOM   1295  N   GLN B  49      88.108  41.217  44.121  1.00 14.73           N  
ATOM   1296  CA  GLN B  49      87.150  42.192  43.518  1.00 14.59           C  
ATOM   1297  C   GLN B  49      86.498  41.742  42.199  1.00 13.93           C  
ATOM   1298  O   GLN B  49      85.270  41.769  42.048  1.00 14.27           O  
ATOM   1299  CB  GLN B  49      87.786  43.568  43.334  1.00 14.61           C  
ATOM   1300  CG  GLN B  49      88.119  44.255  44.687  1.00 16.22           C  
ATOM   1301  CD  GLN B  49      88.325  45.752  44.581  1.00 19.04           C  
ATOM   1302  OE1 GLN B  49      87.808  46.382  43.659  1.00 27.49           O  
ATOM   1303  NE2 GLN B  49      89.067  46.341  45.524  1.00 15.59           N  
ATOM   1304  N   ALA B  50      87.310  41.267  41.278  1.00 13.38           N  
ATOM   1305  CA  ALA B  50      86.818  40.752  40.002  1.00 13.71           C  
ATOM   1306  C   ALA B  50      85.897  39.545  40.181  1.00 13.89           C  
ATOM   1307  O   ALA B  50      84.769  39.581  39.716  1.00 14.24           O  
ATOM   1308  CB  ALA B  50      88.026  40.479  38.965  1.00 11.44           C  
ATOM   1309  N   ARG B  51      86.363  38.511  40.873  1.00 15.23           N  
ATOM   1310  CA  ARG B  51      85.538  37.349  41.192  1.00 17.37           C  
ATOM   1311  C   ARG B  51      84.165  37.667  41.850  1.00 17.80           C  
ATOM   1312  O   ARG B  51      83.111  37.166  41.428  1.00 19.38           O  
ATOM   1313  CB  ARG B  51      86.354  36.339  42.057  1.00 18.14           C  
ATOM   1314  CG  ARG B  51      85.610  35.023  42.456  1.00 18.12           C  
ATOM   1315  CD  ARG B  51      84.930  34.402  41.237  1.00 27.13           C  
ATOM   1316  NE  ARG B  51      84.176  33.185  41.569  1.00 34.31           N  
ATOM   1317  CZ  ARG B  51      84.328  31.999  40.952  1.00 37.81           C  
ATOM   1318  NH1 ARG B  51      85.211  31.833  39.946  1.00 37.51           N  
ATOM   1319  NH2 ARG B  51      83.568  30.972  41.324  1.00 36.30           N  
ATOM   1320  N   LEU B  52      84.197  38.529  42.847  1.00 17.44           N  
ATOM   1321  CA  LEU B  52      83.015  39.024  43.550  1.00 17.42           C  
ATOM   1322  C   LEU B  52      81.982  39.813  42.727  1.00 17.12           C  
ATOM   1323  O   LEU B  52      80.797  39.556  42.840  1.00 17.17           O  
ATOM   1324  CB  LEU B  52      83.472  39.859  44.773  1.00 16.48           C  
ATOM   1325  CG  LEU B  52      82.463  40.282  45.829  1.00 15.85           C  
ATOM   1326  CD1 LEU B  52      81.363  39.241  46.122  1.00 11.82           C  
ATOM   1327  CD2 LEU B  52      83.266  40.602  47.081  1.00 12.95           C  
ATOM   1328  N   SER B  53      82.420  40.832  41.989  1.00 17.22           N  
ATOM   1329  CA  SER B  53      81.601  41.443  40.950  1.00 16.96           C  
ATOM   1330  C   SER B  53      80.899  40.385  40.084  1.00 16.37           C  
ATOM   1331  O   SER B  53      79.710  40.470  39.860  1.00 16.85           O  
ATOM   1332  CB  SER B  53      82.490  42.282  40.033  1.00 17.11           C  
ATOM   1333  OG  SER B  53      82.280  43.649  40.222  1.00 22.32           O  
ATOM   1334  N   LEU B  54      81.653  39.418  39.560  1.00 15.44           N  
ATOM   1335  CA  LEU B  54      81.079  38.348  38.773  1.00 15.71           C  
ATOM   1336  C   LEU B  54      80.031  37.486  39.546  1.00 16.27           C  
ATOM   1337  O   LEU B  54      78.953  37.238  39.041  1.00 15.51           O  
ATOM   1338  CB  LEU B  54      82.202  37.484  38.133  1.00 14.49           C  
ATOM   1339  CG  LEU B  54      82.877  38.253  36.999  1.00 12.07           C  
ATOM   1340  CD1 LEU B  54      84.169  37.659  36.580  1.00  9.11           C  
ATOM   1341  CD2 LEU B  54      81.951  38.425  35.813  1.00  9.62           C  
ATOM   1342  N   GLU B  55      80.378  37.030  40.755  1.00 17.39           N  
ATOM   1343  CA  GLU B  55      79.415  36.400  41.694  1.00 17.54           C  
ATOM   1344  C   GLU B  55      78.137  37.223  41.855  1.00 17.75           C  
ATOM   1345  O   GLU B  55      76.992  36.689  41.691  1.00 19.29           O  
ATOM   1346  CB  GLU B  55      80.079  36.146  43.057  1.00 16.63           C  
ATOM   1347  CG  GLU B  55      81.044  34.935  43.042  1.00 20.35           C  
ATOM   1348  CD  GLU B  55      80.293  33.595  42.694  1.00 27.95           C  
ATOM   1349  OE1 GLU B  55      79.101  33.404  43.105  1.00 29.48           O  
ATOM   1350  OE2 GLU B  55      80.873  32.731  42.010  1.00 29.27           O  
ATOM   1351  N   ASN B  56      78.310  38.507  42.172  1.00 17.01           N  
ATOM   1352  CA  ASN B  56      77.179  39.419  42.350  1.00 17.09           C  
ATOM   1353  C   ASN B  56      76.289  39.513  41.101  1.00 16.57           C  
ATOM   1354  O   ASN B  56      75.077  39.668  41.222  1.00 16.17           O  
ATOM   1355  CB  ASN B  56      77.653  40.832  42.770  1.00 17.53           C  
ATOM   1356  CG  ASN B  56      78.055  40.923  44.242  1.00 17.55           C  
ATOM   1357  OD1 ASN B  56      77.825  40.005  45.016  1.00 18.70           O  
ATOM   1358  ND2 ASN B  56      78.673  42.046  44.622  1.00 18.69           N  
ATOM   1359  N   VAL B  57      76.902  39.432  39.913  1.00 16.76           N  
ATOM   1360  CA  VAL B  57      76.184  39.395  38.628  1.00 16.63           C  
ATOM   1361  C   VAL B  57      75.359  38.091  38.491  1.00 17.43           C  
ATOM   1362  O   VAL B  57      74.190  38.116  38.080  1.00 17.45           O  
ATOM   1363  CB  VAL B  57      77.141  39.621  37.398  1.00 15.76           C  
ATOM   1364  CG1 VAL B  57      76.544  39.094  36.079  1.00 13.77           C  
ATOM   1365  CG2 VAL B  57      77.453  41.099  37.214  1.00 16.78           C  
ATOM   1366  N   LYS B  58      76.000  36.986  38.849  1.00 18.15           N  
ATOM   1367  CA  LYS B  58      75.486  35.647  38.774  1.00 19.39           C  
ATOM   1368  C   LYS B  58      74.284  35.486  39.678  1.00 20.53           C  
ATOM   1369  O   LYS B  58      73.261  34.933  39.249  1.00 21.16           O  
ATOM   1370  CB  LYS B  58      76.583  34.698  39.225  1.00 20.55           C  
ATOM   1371  CG  LYS B  58      76.313  33.212  38.927  1.00 22.25           C  
ATOM   1372  CD  LYS B  58      77.409  32.321  39.464  1.00 17.92           C  
ATOM   1373  CE  LYS B  58      76.733  31.180  40.184  1.00 23.16           C  
ATOM   1374  NZ  LYS B  58      77.300  29.800  40.013  1.00 22.33           N  
ATOM   1375  N   ALA B  59      74.400  35.973  40.922  1.00 21.09           N  
ATOM   1376  CA  ALA B  59      73.282  35.963  41.893  1.00 20.25           C  
ATOM   1377  C   ALA B  59      71.966  36.516  41.301  1.00 20.08           C  
ATOM   1378  O   ALA B  59      70.915  35.851  41.369  1.00 21.69           O  
ATOM   1379  CB  ALA B  59      73.667  36.697  43.120  1.00 19.15           C  
ATOM   1380  N   ILE B  60      72.035  37.683  40.670  1.00 18.48           N  
ATOM   1381  CA  ILE B  60      70.875  38.372  40.069  1.00 16.11           C  
ATOM   1382  C   ILE B  60      70.362  37.680  38.799  1.00 17.83           C  
ATOM   1383  O   ILE B  60      69.168  37.572  38.583  1.00 18.07           O  
ATOM   1384  CB  ILE B  60      71.234  39.845  39.747  1.00 15.94           C  
ATOM   1385  CG1 ILE B  60      71.771  40.549  41.011  1.00 12.80           C  
ATOM   1386  CG2 ILE B  60      70.084  40.601  38.973  1.00 11.55           C  
ATOM   1387  CD1 ILE B  60      72.584  41.824  40.702  1.00 13.83           C  
ATOM   1388  N   VAL B  61      71.251  37.226  37.932  1.00 18.63           N  
ATOM   1389  CA  VAL B  61      70.806  36.521  36.737  1.00 19.66           C  
ATOM   1390  C   VAL B  61      70.138  35.223  37.151  1.00 21.05           C  
ATOM   1391  O   VAL B  61      69.121  34.823  36.578  1.00 22.31           O  
ATOM   1392  CB  VAL B  61      71.982  36.339  35.724  1.00 19.87           C  
ATOM   1393  CG1 VAL B  61      71.651  35.316  34.633  1.00 18.67           C  
ATOM   1394  CG2 VAL B  61      72.357  37.725  35.117  1.00 18.33           C  
ATOM   1395  N   VAL B  62      70.718  34.569  38.152  1.00 21.85           N  
ATOM   1396  CA  VAL B  62      70.217  33.293  38.651  1.00 21.86           C  
ATOM   1397  C   VAL B  62      68.879  33.469  39.387  1.00 22.72           C  
ATOM   1398  O   VAL B  62      68.007  32.621  39.267  1.00 23.21           O  
ATOM   1399  CB  VAL B  62      71.323  32.548  39.490  1.00 21.58           C  
ATOM   1400  CG1 VAL B  62      70.735  31.560  40.468  1.00 19.49           C  
ATOM   1401  CG2 VAL B  62      72.311  31.865  38.537  1.00 20.59           C  
ATOM   1402  N   ALA B  63      68.705  34.586  40.099  1.00 23.02           N  
ATOM   1403  CA  ALA B  63      67.404  34.933  40.694  1.00 23.05           C  
ATOM   1404  C   ALA B  63      66.298  35.113  39.636  1.00 23.06           C  
ATOM   1405  O   ALA B  63      65.114  34.927  39.932  1.00 24.01           O  
ATOM   1406  CB  ALA B  63      67.521  36.211  41.549  1.00 22.81           C  
ATOM   1407  N   ALA B  64      66.681  35.529  38.435  1.00 22.50           N  
ATOM   1408  CA  ALA B  64      65.781  35.625  37.296  1.00 22.80           C  
ATOM   1409  C   ALA B  64      65.400  34.269  36.675  1.00 24.04           C  
ATOM   1410  O   ALA B  64      64.581  34.236  35.742  1.00 24.30           O  
ATOM   1411  CB  ALA B  64      66.391  36.493  36.236  1.00 22.01           C  
ATOM   1412  N   GLY B  65      65.985  33.174  37.193  1.00 24.85           N  
ATOM   1413  CA  GLY B  65      65.879  31.841  36.619  1.00 25.60           C  
ATOM   1414  C   GLY B  65      66.822  31.558  35.444  1.00 26.60           C  
ATOM   1415  O   GLY B  65      66.610  30.629  34.664  1.00 27.61           O  
ATOM   1416  N   LEU B  66      67.875  32.339  35.287  1.00 25.90           N  
ATOM   1417  CA  LEU B  66      68.738  32.096  34.171  1.00 24.93           C  
ATOM   1418  C   LEU B  66      70.045  31.599  34.720  1.00 25.42           C  
ATOM   1419  O   LEU B  66      70.198  31.397  35.940  1.00 25.61           O  
ATOM   1420  CB  LEU B  66      68.899  33.357  33.307  1.00 25.15           C  
ATOM   1421  CG  LEU B  66      67.642  33.952  32.648  1.00 25.16           C  
ATOM   1422  CD1 LEU B  66      68.032  35.192  31.953  1.00 23.90           C  
ATOM   1423  CD2 LEU B  66      66.996  32.958  31.663  1.00 24.34           C  
ATOM   1424  N   SER B  67      70.989  31.377  33.824  1.00 25.17           N  
ATOM   1425  CA  SER B  67      72.290  30.914  34.234  1.00 26.01           C  
ATOM   1426  C   SER B  67      73.371  31.837  33.624  1.00 24.83           C  
ATOM   1427  O   SER B  67      73.065  32.726  32.839  1.00 25.77           O  
ATOM   1428  CB  SER B  67      72.441  29.417  33.857  1.00 26.61           C  
ATOM   1429  OG  SER B  67      72.474  29.245  32.436  1.00 27.75           O  
ATOM   1430  N   VAL B  68      74.612  31.655  34.035  1.00 23.60           N  
ATOM   1431  CA  VAL B  68      75.770  32.371  33.477  1.00 21.81           C  
ATOM   1432  C   VAL B  68      75.887  32.258  31.964  1.00 21.66           C  
ATOM   1433  O   VAL B  68      76.257  33.232  31.290  1.00 21.44           O  
ATOM   1434  CB  VAL B  68      77.070  31.842  34.139  1.00 20.96           C  
ATOM   1435  CG1 VAL B  68      78.338  32.289  33.409  1.00 19.22           C  
ATOM   1436  CG2 VAL B  68      77.072  32.247  35.556  1.00 19.49           C  
ATOM   1437  N   GLY B  69      75.630  31.047  31.446  1.00 21.88           N  
ATOM   1438  CA  GLY B  69      75.638  30.775  29.989  1.00 20.42           C  
ATOM   1439  C   GLY B  69      74.606  31.605  29.228  1.00 19.51           C  
ATOM   1440  O   GLY B  69      74.636  31.672  28.015  1.00 20.59           O  
ATOM   1441  N   ASP B  70      73.716  32.284  29.931  1.00 17.98           N  
ATOM   1442  CA  ASP B  70      72.743  33.134  29.244  1.00 18.13           C  
ATOM   1443  C   ASP B  70      73.168  34.603  29.162  1.00 16.61           C  
ATOM   1444  O   ASP B  70      72.426  35.434  28.616  1.00 15.50           O  
ATOM   1445  CB  ASP B  70      71.351  33.019  29.900  1.00 18.46           C  
ATOM   1446  CG  ASP B  70      70.826  31.598  29.894  1.00 20.43           C  
ATOM   1447  OD1 ASP B  70      70.764  31.007  28.811  1.00 25.27           O  
ATOM   1448  OD2 ASP B  70      70.496  31.057  30.965  1.00 23.96           O  
ATOM   1449  N   ILE B  71      74.317  34.927  29.771  1.00 15.86           N  
ATOM   1450  CA  ILE B  71      74.800  36.291  29.786  1.00 14.96           C  
ATOM   1451  C   ILE B  71      75.379  36.598  28.413  1.00 14.52           C  
ATOM   1452  O   ILE B  71      76.274  35.902  27.934  1.00 14.32           O  
ATOM   1453  CB  ILE B  71      75.846  36.573  30.905  1.00 15.86           C  
ATOM   1454  CG1 ILE B  71      75.209  36.524  32.311  1.00 15.27           C  
ATOM   1455  CG2 ILE B  71      76.520  37.944  30.635  1.00 13.91           C  
ATOM   1456  CD1 ILE B  71      76.193  36.201  33.433  1.00 13.31           C  
ATOM   1457  N   ILE B  72      74.872  37.639  27.772  1.00 15.18           N  
ATOM   1458  CA  ILE B  72      75.244  37.899  26.355  1.00 15.47           C  
ATOM   1459  C   ILE B  72      76.051  39.135  26.117  1.00 14.92           C  
ATOM   1460  O   ILE B  72      76.672  39.242  25.086  1.00 16.61           O  
ATOM   1461  CB  ILE B  72      74.014  37.800  25.350  1.00 16.10           C  
ATOM   1462  CG1 ILE B  72      72.903  38.813  25.653  1.00 16.42           C  
ATOM   1463  CG2 ILE B  72      73.463  36.398  25.329  1.00 17.32           C  
ATOM   1464  CD1 ILE B  72      73.187  40.226  25.073  1.00 16.64           C  
ATOM   1465  N   LYS B  73      76.061  40.056  27.073  1.00 14.76           N  
ATOM   1466  CA  LYS B  73      76.820  41.295  27.017  1.00 14.54           C  
ATOM   1467  C   LYS B  73      77.231  41.704  28.421  1.00 15.65           C  
ATOM   1468  O   LYS B  73      76.403  41.685  29.340  1.00 15.23           O  
ATOM   1469  CB  LYS B  73      76.048  42.437  26.287  1.00 15.42           C  
ATOM   1470  CG  LYS B  73      76.614  43.878  26.416  1.00 14.17           C  
ATOM   1471  CD  LYS B  73      77.778  44.089  25.492  1.00 18.03           C  
ATOM   1472  CE  LYS B  73      78.550  45.407  25.703  1.00 18.48           C  
ATOM   1473  NZ  LYS B  73      77.625  46.516  25.356  1.00 24.67           N  
ATOM   1474  N   MET B  74      78.529  42.049  28.571  1.00 16.22           N  
ATOM   1475  CA  MET B  74      79.024  42.758  29.726  1.00 16.96           C  
ATOM   1476  C   MET B  74      79.782  44.030  29.389  1.00 16.56           C  
ATOM   1477  O   MET B  74      80.464  44.118  28.372  1.00 18.24           O  
ATOM   1478  CB  MET B  74      79.912  41.829  30.574  1.00 17.01           C  
ATOM   1479  CG  MET B  74      79.064  40.725  31.206  1.00 19.18           C  
ATOM   1480  SD  MET B  74      79.898  39.602  32.262  1.00 19.73           S  
ATOM   1481  CE  MET B  74      78.843  39.896  33.658  1.00 20.77           C  
ATOM   1482  N   THR B  75      79.691  44.998  30.281  1.00 15.61           N  
ATOM   1483  CA  THR B  75      80.570  46.116  30.280  1.00 15.07           C  
ATOM   1484  C   THR B  75      81.297  46.094  31.616  1.00 14.85           C  
ATOM   1485  O   THR B  75      80.692  46.006  32.669  1.00 13.29           O  
ATOM   1486  CB  THR B  75      79.830  47.470  30.076  1.00 15.97           C  
ATOM   1487  OG1 THR B  75      78.935  47.351  28.962  1.00 16.95           O  
ATOM   1488  CG2 THR B  75      80.837  48.638  29.849  1.00 12.54           C  
ATOM   1489  N   VAL B  76      82.619  46.163  31.509  1.00 14.23           N  
ATOM   1490  CA  VAL B  76      83.529  46.156  32.622  1.00 13.87           C  
ATOM   1491  C   VAL B  76      84.194  47.518  32.711  1.00 13.20           C  
ATOM   1492  O   VAL B  76      85.040  47.873  31.881  1.00 13.17           O  
ATOM   1493  CB  VAL B  76      84.572  45.022  32.400  1.00 13.67           C  
ATOM   1494  CG1 VAL B  76      85.419  44.877  33.584  1.00 14.00           C  
ATOM   1495  CG2 VAL B  76      83.852  43.716  32.172  1.00 13.82           C  
ATOM   1496  N   PHE B  77      83.751  48.306  33.677  1.00 12.76           N  
ATOM   1497  CA  PHE B  77      84.394  49.559  34.011  1.00 12.61           C  
ATOM   1498  C   PHE B  77      85.501  49.318  35.036  1.00 12.79           C  
ATOM   1499  O   PHE B  77      85.287  48.716  36.097  1.00 11.46           O  
ATOM   1500  CB  PHE B  77      83.406  50.503  34.635  1.00 12.87           C  
ATOM   1501  CG  PHE B  77      82.169  50.730  33.822  1.00 14.45           C  
ATOM   1502  CD1 PHE B  77      82.180  51.638  32.760  1.00 13.30           C  
ATOM   1503  CD2 PHE B  77      80.966  50.088  34.179  1.00 12.64           C  
ATOM   1504  CE1 PHE B  77      81.002  51.878  32.043  1.00 18.11           C  
ATOM   1505  CE2 PHE B  77      79.816  50.329  33.494  1.00 13.97           C  
ATOM   1506  CZ  PHE B  77      79.820  51.223  32.410  1.00 14.61           C  
ATOM   1507  N   ILE B  78      86.703  49.765  34.721  1.00 13.23           N  
ATOM   1508  CA  ILE B  78      87.786  49.525  35.646  1.00 14.01           C  
ATOM   1509  C   ILE B  78      88.446  50.879  35.965  1.00 14.47           C  
ATOM   1510  O   ILE B  78      88.258  51.825  35.236  1.00 14.66           O  
ATOM   1511  CB  ILE B  78      88.761  48.459  35.100  1.00 13.34           C  
ATOM   1512  CG1 ILE B  78      89.643  49.042  33.983  1.00 13.95           C  
ATOM   1513  CG2 ILE B  78      88.020  47.190  34.644  1.00 12.11           C  
ATOM   1514  CD1 ILE B  78      90.698  48.051  33.401  1.00 14.45           C  
ATOM   1515  N   THR B  79      89.201  50.971  37.052  1.00 15.63           N  
ATOM   1516  CA  THR B  79      89.967  52.194  37.321  1.00 15.73           C  
ATOM   1517  C   THR B  79      91.472  52.145  36.937  1.00 16.50           C  
ATOM   1518  O   THR B  79      92.143  53.159  36.976  1.00 16.62           O  
ATOM   1519  CB  THR B  79      89.771  52.685  38.806  1.00 16.05           C  
ATOM   1520  OG1 THR B  79      90.175  51.653  39.713  1.00 16.34           O  
ATOM   1521  CG2 THR B  79      88.334  53.096  39.066  1.00 11.37           C  
ATOM   1522  N   ASP B  80      91.990  50.989  36.532  1.00 17.57           N  
ATOM   1523  CA  ASP B  80      93.394  50.855  36.174  1.00 18.46           C  
ATOM   1524  C   ASP B  80      93.664  49.721  35.168  1.00 19.14           C  
ATOM   1525  O   ASP B  80      93.623  48.555  35.527  1.00 20.31           O  
ATOM   1526  CB  ASP B  80      94.216  50.613  37.456  1.00 18.69           C  
ATOM   1527  CG  ASP B  80      95.701  50.897  37.266  1.00 21.34           C  
ATOM   1528  OD1 ASP B  80      96.135  51.069  36.083  1.00 21.93           O  
ATOM   1529  OD2 ASP B  80      96.427  50.967  38.297  1.00 19.49           O  
ATOM   1530  N   LEU B  81      93.990  50.046  33.928  1.00 19.79           N  
ATOM   1531  CA  LEU B  81      94.228  49.021  32.925  1.00 20.23           C  
ATOM   1532  C   LEU B  81      95.374  48.087  33.217  1.00 21.10           C  
ATOM   1533  O   LEU B  81      95.488  46.996  32.590  1.00 22.05           O  
ATOM   1534  CB  LEU B  81      94.412  49.638  31.526  1.00 21.04           C  
ATOM   1535  CG  LEU B  81      93.043  49.947  30.887  1.00 21.53           C  
ATOM   1536  CD1 LEU B  81      93.126  51.139  30.017  1.00 20.17           C  
ATOM   1537  CD2 LEU B  81      92.506  48.726  30.138  1.00 17.81           C  
ATOM   1538  N   ASN B  82      96.237  48.525  34.119  1.00 20.32           N  
ATOM   1539  CA  ASN B  82      97.289  47.708  34.659  1.00 20.80           C  
ATOM   1540  C   ASN B  82      96.786  46.429  35.370  1.00 21.13           C  
ATOM   1541  O   ASN B  82      97.503  45.373  35.406  1.00 22.18           O  
ATOM   1542  CB  ASN B  82      98.235  48.592  35.498  1.00 20.74           C  
ATOM   1543  CG  ASN B  82      99.069  49.540  34.590  1.00 23.31           C  
ATOM   1544  OD1 ASN B  82      99.265  49.270  33.390  1.00 27.34           O  
ATOM   1545  ND2 ASN B  82      99.485  50.651  35.118  1.00 21.08           N  
ATOM   1546  N   ASP B  83      95.552  46.504  35.870  1.00 20.13           N  
ATOM   1547  CA  ASP B  83      94.825  45.386  36.423  1.00 20.38           C  
ATOM   1548  C   ASP B  83      94.203  44.479  35.373  1.00 19.80           C  
ATOM   1549  O   ASP B  83      93.696  43.433  35.678  1.00 20.87           O  
ATOM   1550  CB  ASP B  83      93.694  45.892  37.325  1.00 20.14           C  
ATOM   1551  CG  ASP B  83      94.206  46.553  38.602  1.00 22.79           C  
ATOM   1552  OD1 ASP B  83      95.340  46.162  39.016  1.00 19.15           O  
ATOM   1553  OD2 ASP B  83      93.460  47.443  39.181  1.00 20.37           O  
ATOM   1554  N   PHE B  84      94.215  44.884  34.135  1.00 20.14           N  
ATOM   1555  CA  PHE B  84      93.408  44.234  33.085  1.00 20.48           C  
ATOM   1556  C   PHE B  84      93.775  42.773  32.787  1.00 19.79           C  
ATOM   1557  O   PHE B  84      92.889  41.922  32.619  1.00 19.07           O  
ATOM   1558  CB  PHE B  84      93.596  45.079  31.832  1.00 21.75           C  
ATOM   1559  CG  PHE B  84      92.740  44.704  30.691  1.00 22.95           C  
ATOM   1560  CD1 PHE B  84      91.382  44.534  30.850  1.00 24.13           C  
ATOM   1561  CD2 PHE B  84      93.292  44.612  29.438  1.00 26.55           C  
ATOM   1562  CE1 PHE B  84      90.599  44.224  29.790  1.00 25.10           C  
ATOM   1563  CE2 PHE B  84      92.501  44.319  28.347  1.00 30.62           C  
ATOM   1564  CZ  PHE B  84      91.149  44.132  28.528  1.00 27.54           C  
ATOM   1565  N   ALA B  85      95.069  42.466  32.676  1.00 18.73           N  
ATOM   1566  CA  ALA B  85      95.399  41.072  32.390  1.00 18.55           C  
ATOM   1567  C   ALA B  85      94.876  40.154  33.523  1.00 16.95           C  
ATOM   1568  O   ALA B  85      94.366  39.036  33.269  1.00 16.24           O  
ATOM   1569  CB  ALA B  85      96.914  40.882  32.130  1.00 18.81           C  
ATOM   1570  N   THR B  86      94.981  40.660  34.754  1.00 14.78           N  
ATOM   1571  CA  THR B  86      94.538  39.943  35.963  1.00 13.93           C  
ATOM   1572  C   THR B  86      93.011  39.763  35.995  1.00 13.36           C  
ATOM   1573  O   THR B  86      92.517  38.659  36.236  1.00 14.44           O  
ATOM   1574  CB  THR B  86      95.041  40.727  37.242  1.00 14.19           C  
ATOM   1575  OG1 THR B  86      96.462  40.757  37.199  1.00 11.63           O  
ATOM   1576  CG2 THR B  86      94.621  40.070  38.528  1.00 13.25           C  
ATOM   1577  N   ILE B  87      92.277  40.853  35.742  1.00 11.86           N  
ATOM   1578  CA  ILE B  87      90.840  40.821  35.670  1.00 11.34           C  
ATOM   1579  C   ILE B  87      90.386  39.836  34.579  1.00 13.64           C  
ATOM   1580  O   ILE B  87      89.477  38.988  34.833  1.00 14.78           O  
ATOM   1581  CB  ILE B  87      90.271  42.236  35.447  1.00 10.10           C  
ATOM   1582  CG1 ILE B  87      90.531  43.111  36.657  1.00  7.76           C  
ATOM   1583  CG2 ILE B  87      88.761  42.204  35.193  1.00 10.99           C  
ATOM   1584  CD1 ILE B  87      90.113  44.609  36.396  1.00 10.47           C  
ATOM   1585  N   ASN B  88      90.999  39.921  33.377  1.00 14.24           N  
ATOM   1586  CA  ASN B  88      90.741  38.954  32.304  1.00 14.24           C  
ATOM   1587  C   ASN B  88      90.896  37.508  32.682  1.00 14.41           C  
ATOM   1588  O   ASN B  88      90.107  36.666  32.278  1.00 14.67           O  
ATOM   1589  CB  ASN B  88      91.656  39.216  31.151  1.00 15.45           C  
ATOM   1590  CG  ASN B  88      91.089  40.187  30.182  1.00 14.41           C  
ATOM   1591  OD1 ASN B  88      89.934  40.558  30.266  1.00 16.63           O  
ATOM   1592  ND2 ASN B  88      91.898  40.607  29.258  1.00 13.64           N  
ATOM   1593  N   GLU B  89      91.932  37.212  33.450  1.00 14.98           N  
ATOM   1594  CA  GLU B  89      92.168  35.854  33.894  1.00 15.91           C  
ATOM   1595  C   GLU B  89      91.015  35.334  34.807  1.00 15.48           C  
ATOM   1596  O   GLU B  89      90.392  34.266  34.576  1.00 13.69           O  
ATOM   1597  CB  GLU B  89      93.546  35.767  34.566  1.00 17.03           C  
ATOM   1598  CG  GLU B  89      94.242  34.502  34.225  1.00 23.08           C  
ATOM   1599  CD  GLU B  89      94.396  34.334  32.676  1.00 33.72           C  
ATOM   1600  OE1 GLU B  89      95.243  35.046  32.034  1.00 37.85           O  
ATOM   1601  OE2 GLU B  89      93.671  33.477  32.105  1.00 36.10           O  
ATOM   1602  N   VAL B  90      90.682  36.153  35.792  1.00 15.58           N  
ATOM   1603  CA  VAL B  90      89.621  35.820  36.689  1.00 16.08           C  
ATOM   1604  C   VAL B  90      88.303  35.667  35.917  1.00 16.78           C  
ATOM   1605  O   VAL B  90      87.562  34.705  36.136  1.00 18.23           O  
ATOM   1606  CB  VAL B  90      89.554  36.836  37.884  1.00 16.81           C  
ATOM   1607  CG1 VAL B  90      88.277  36.607  38.742  1.00 16.80           C  
ATOM   1608  CG2 VAL B  90      90.836  36.742  38.744  1.00 11.47           C  
ATOM   1609  N   TYR B  91      88.043  36.584  34.999  1.00 16.84           N  
ATOM   1610  CA  TYR B  91      86.797  36.632  34.183  1.00 16.43           C  
ATOM   1611  C   TYR B  91      86.673  35.398  33.268  1.00 17.57           C  
ATOM   1612  O   TYR B  91      85.604  34.782  33.170  1.00 17.91           O  
ATOM   1613  CB  TYR B  91      86.842  37.958  33.361  1.00 15.01           C  
ATOM   1614  CG  TYR B  91      85.671  38.364  32.517  1.00 12.05           C  
ATOM   1615  CD1 TYR B  91      85.341  37.648  31.381  1.00 13.56           C  
ATOM   1616  CD2 TYR B  91      84.904  39.505  32.836  1.00 13.49           C  
ATOM   1617  CE1 TYR B  91      84.270  38.032  30.555  1.00 15.12           C  
ATOM   1618  CE2 TYR B  91      83.774  39.891  32.043  1.00 15.33           C  
ATOM   1619  CZ  TYR B  91      83.485  39.150  30.884  1.00 14.20           C  
ATOM   1620  OH  TYR B  91      82.460  39.477  30.039  1.00 10.50           O  
ATOM   1621  N   LYS B  92      87.758  35.075  32.557  1.00 18.85           N  
ATOM   1622  CA  LYS B  92      87.883  33.812  31.804  1.00 19.46           C  
ATOM   1623  C   LYS B  92      87.588  32.568  32.660  1.00 19.32           C  
ATOM   1624  O   LYS B  92      86.704  31.777  32.312  1.00 19.52           O  
ATOM   1625  CB  LYS B  92      89.274  33.720  31.164  1.00 20.24           C  
ATOM   1626  CG  LYS B  92      89.323  32.724  30.032  1.00 22.52           C  
ATOM   1627  CD  LYS B  92      90.717  32.405  29.534  1.00 22.85           C  
ATOM   1628  CE  LYS B  92      90.667  31.907  28.070  1.00 28.43           C  
ATOM   1629  NZ  LYS B  92      90.545  33.068  27.016  1.00 30.97           N  
ATOM   1630  N   GLN B  93      88.278  32.402  33.792  1.00 20.14           N  
ATOM   1631  CA  GLN B  93      88.022  31.213  34.658  1.00 20.12           C  
ATOM   1632  C   GLN B  93      86.564  31.155  35.146  1.00 20.07           C  
ATOM   1633  O   GLN B  93      85.919  30.087  35.121  1.00 21.28           O  
ATOM   1634  CB  GLN B  93      89.036  31.094  35.816  1.00 21.08           C  
ATOM   1635  CG  GLN B  93      89.300  29.627  36.338  1.00 22.07           C  
ATOM   1636  CD  GLN B  93      89.546  28.585  35.175  1.00 28.48           C  
ATOM   1637  OE1 GLN B  93      90.131  28.904  34.099  1.00 31.73           O  
ATOM   1638  NE2 GLN B  93      89.086  27.344  35.397  1.00 27.15           N  
ATOM   1639  N   PHE B  94      86.015  32.298  35.528  1.00 17.88           N  
ATOM   1640  CA  PHE B  94      84.618  32.359  35.824  1.00 17.11           C  
ATOM   1641  C   PHE B  94      83.700  31.825  34.708  1.00 17.28           C  
ATOM   1642  O   PHE B  94      82.758  31.069  34.994  1.00 16.65           O  
ATOM   1643  CB  PHE B  94      84.214  33.796  36.235  1.00 17.15           C  
ATOM   1644  CG  PHE B  94      82.791  33.908  36.677  1.00 15.82           C  
ATOM   1645  CD1 PHE B  94      82.447  33.658  38.018  1.00 13.86           C  
ATOM   1646  CD2 PHE B  94      81.781  34.244  35.749  1.00 14.97           C  
ATOM   1647  CE1 PHE B  94      81.108  33.777  38.431  1.00 14.08           C  
ATOM   1648  CE2 PHE B  94      80.421  34.358  36.142  1.00 13.61           C  
ATOM   1649  CZ  PHE B  94      80.094  34.122  37.485  1.00 14.82           C  
ATOM   1650  N   PHE B  95      83.925  32.228  33.447  1.00 17.53           N  
ATOM   1651  CA  PHE B  95      83.082  31.660  32.345  1.00 17.40           C  
ATOM   1652  C   PHE B  95      83.368  30.185  32.041  1.00 18.26           C  
ATOM   1653  O   PHE B  95      82.456  29.434  31.878  1.00 17.55           O  
ATOM   1654  CB  PHE B  95      83.002  32.550  31.092  1.00 16.21           C  
ATOM   1655  CG  PHE B  95      82.119  33.727  31.296  1.00 14.66           C  
ATOM   1656  CD1 PHE B  95      80.740  33.627  31.055  1.00 15.40           C  
ATOM   1657  CD2 PHE B  95      82.632  34.903  31.853  1.00  9.71           C  
ATOM   1658  CE1 PHE B  95      79.880  34.719  31.327  1.00 14.35           C  
ATOM   1659  CE2 PHE B  95      81.828  35.966  32.131  1.00 11.01           C  
ATOM   1660  CZ  PHE B  95      80.429  35.902  31.864  1.00 16.05           C  
ATOM   1661  N   ASP B  96      84.639  29.800  32.052  1.00 19.49           N  
ATOM   1662  CA  ASP B  96      85.075  28.433  31.841  1.00 21.29           C  
ATOM   1663  C   ASP B  96      84.516  27.459  32.872  1.00 23.25           C  
ATOM   1664  O   ASP B  96      84.101  26.345  32.515  1.00 24.84           O  
ATOM   1665  CB  ASP B  96      86.606  28.353  31.859  1.00 20.60           C  
ATOM   1666  CG  ASP B  96      87.254  29.079  30.697  1.00 19.90           C  
ATOM   1667  OD1 ASP B  96      86.543  29.477  29.751  1.00 20.45           O  
ATOM   1668  OD2 ASP B  96      88.494  29.209  30.690  1.00 20.15           O  
ATOM   1669  N   GLU B  97      84.503  27.847  34.143  1.00 24.32           N  
ATOM   1670  CA  GLU B  97      83.916  27.014  35.185  1.00 25.46           C  
ATOM   1671  C   GLU B  97      82.424  26.784  35.067  1.00 25.57           C  
ATOM   1672  O   GLU B  97      81.899  25.868  35.727  1.00 25.90           O  
ATOM   1673  CB  GLU B  97      84.108  27.670  36.556  1.00 26.67           C  
ATOM   1674  CG  GLU B  97      85.515  27.686  37.080  1.00 31.55           C  
ATOM   1675  CD  GLU B  97      85.536  28.319  38.451  1.00 41.84           C  
ATOM   1676  OE1 GLU B  97      84.422  28.737  38.925  1.00 41.46           O  
ATOM   1677  OE2 GLU B  97      86.655  28.378  39.040  1.00 44.38           O  
ATOM   1678  N   HIS B  98      81.720  27.671  34.359  1.00 25.19           N  
ATOM   1679  CA  HIS B  98      80.272  27.544  34.181  1.00 25.18           C  
ATOM   1680  C   HIS B  98      79.972  26.911  32.847  1.00 25.87           C  
ATOM   1681  O   HIS B  98      78.816  26.736  32.481  1.00 27.99           O  
ATOM   1682  CB  HIS B  98      79.523  28.872  34.384  1.00 23.66           C  
ATOM   1683  CG  HIS B  98      79.533  29.352  35.808  1.00 23.09           C  
ATOM   1684  ND1 HIS B  98      80.559  30.119  36.336  1.00 21.10           N  
ATOM   1685  CD2 HIS B  98      78.657  29.159  36.822  1.00 20.00           C  
ATOM   1686  CE1 HIS B  98      80.319  30.367  37.610  1.00 18.17           C  
ATOM   1687  NE2 HIS B  98      79.164  29.807  37.926  1.00 21.45           N  
ATOM   1688  N   GLN B  99      81.017  26.492  32.167  1.00 26.32           N  
ATOM   1689  CA  GLN B  99      80.954  26.015  30.787  1.00 29.40           C  
ATOM   1690  C   GLN B  99      80.188  27.001  29.890  1.00 28.07           C  
ATOM   1691  O   GLN B  99      79.297  26.623  29.107  1.00 28.43           O  
ATOM   1692  CB  GLN B  99      80.410  24.575  30.666  1.00 28.81           C  
ATOM   1693  CG  GLN B  99      80.781  23.587  31.804  1.00 32.68           C  
ATOM   1694  CD  GLN B  99      80.447  22.153  31.391  1.00 35.50           C  
ATOM   1695  OE1 GLN B  99      79.377  21.593  31.749  1.00 40.64           O  
ATOM   1696  NE2 GLN B  99      81.344  21.560  30.575  1.00 40.59           N  
ATOM   1697  N   ALA B 100      80.544  28.273  29.994  1.00 26.48           N  
ATOM   1698  CA  ALA B 100      79.807  29.257  29.263  1.00 25.40           C  
ATOM   1699  C   ALA B 100      80.655  29.822  28.135  1.00 24.86           C  
ATOM   1700  O   ALA B 100      81.881  29.949  28.230  1.00 24.46           O  
ATOM   1701  CB  ALA B 100      79.266  30.365  30.208  1.00 25.40           C  
ATOM   1702  N   THR B 101      79.968  30.121  27.050  1.00 24.53           N  
ATOM   1703  CA  THR B 101      80.514  30.882  25.945  1.00 24.96           C  
ATOM   1704  C   THR B 101      80.738  32.295  26.523  1.00 23.56           C  
ATOM   1705  O   THR B 101      79.945  32.717  27.392  1.00 23.09           O  
ATOM   1706  CB  THR B 101      79.495  30.850  24.762  1.00 25.15           C  
ATOM   1707  OG1 THR B 101      79.667  29.630  24.057  1.00 28.37           O  
ATOM   1708  CG2 THR B 101      79.721  31.948  23.796  1.00 26.29           C  
ATOM   1709  N   TYR B 102      81.809  32.978  26.084  1.00 21.53           N  
ATOM   1710  CA  TYR B 102      82.060  34.371  26.499  1.00 20.01           C  
ATOM   1711  C   TYR B 102      81.078  35.366  25.888  1.00 18.96           C  
ATOM   1712  O   TYR B 102      80.806  35.327  24.707  1.00 18.37           O  
ATOM   1713  CB  TYR B 102      83.498  34.830  26.212  1.00 19.13           C  
ATOM   1714  CG  TYR B 102      84.567  33.853  26.638  1.00 19.19           C  
ATOM   1715  CD1 TYR B 102      84.611  33.352  27.967  1.00 17.26           C  
ATOM   1716  CD2 TYR B 102      85.550  33.443  25.733  1.00 16.73           C  
ATOM   1717  CE1 TYR B 102      85.579  32.442  28.358  1.00 17.09           C  
ATOM   1718  CE2 TYR B 102      86.520  32.548  26.107  1.00 18.12           C  
ATOM   1719  CZ  TYR B 102      86.525  32.037  27.419  1.00 18.71           C  
ATOM   1720  OH  TYR B 102      87.486  31.162  27.771  1.00 18.10           O  
ATOM   1721  N   PRO B 103      80.557  36.296  26.709  1.00 18.32           N  
ATOM   1722  CA  PRO B 103      79.630  37.248  26.142  1.00 17.32           C  
ATOM   1723  C   PRO B 103      80.371  38.253  25.326  1.00 16.14           C  
ATOM   1724  O   PRO B 103      81.600  38.242  25.316  1.00 16.73           O  
ATOM   1725  CB  PRO B 103      79.077  37.965  27.391  1.00 17.41           C  
ATOM   1726  CG  PRO B 103      79.501  37.238  28.504  1.00 16.69           C  
ATOM   1727  CD  PRO B 103      80.751  36.547  28.144  1.00 17.40           C  
ATOM   1728  N   THR B 104      79.641  39.178  24.730  1.00 15.14           N  
ATOM   1729  CA  THR B 104      80.276  40.350  24.173  1.00 14.45           C  
ATOM   1730  C   THR B 104      80.682  41.262  25.335  1.00 14.93           C  
ATOM   1731  O   THR B 104      80.155  41.136  26.461  1.00 14.67           O  
ATOM   1732  CB  THR B 104      79.425  41.058  23.037  1.00 13.62           C  
ATOM   1733  OG1 THR B 104      78.163  41.472  23.541  1.00 15.50           O  
ATOM   1734  CG2 THR B 104      79.180  40.126  21.889  1.00 10.31           C  
ATOM   1735  N   ARG B 105      81.649  42.157  25.091  1.00 15.68           N  
ATOM   1736  CA  ARG B 105      82.191  42.970  26.191  1.00 14.75           C  
ATOM   1737  C   ARG B 105      82.718  44.300  25.715  1.00 14.64           C  
ATOM   1738  O   ARG B 105      83.179  44.427  24.611  1.00 13.98           O  
ATOM   1739  CB  ARG B 105      83.297  42.203  26.922  1.00 15.36           C  
ATOM   1740  CG  ARG B 105      83.599  42.600  28.366  1.00 13.79           C  
ATOM   1741  CD  ARG B 105      84.606  41.596  28.979  1.00 14.38           C  
ATOM   1742  NE  ARG B 105      85.934  41.905  28.465  1.00 16.18           N  
ATOM   1743  CZ  ARG B 105      87.104  41.441  28.921  1.00 17.90           C  
ATOM   1744  NH1 ARG B 105      87.176  40.512  29.881  1.00 18.31           N  
ATOM   1745  NH2 ARG B 105      88.227  41.879  28.352  1.00 18.14           N  
ATOM   1746  N   SER B 106      82.623  45.279  26.599  1.00 14.42           N  
ATOM   1747  CA  SER B 106      83.320  46.531  26.478  1.00 15.06           C  
ATOM   1748  C   SER B 106      84.048  46.724  27.810  1.00 14.58           C  
ATOM   1749  O   SER B 106      83.531  46.368  28.850  1.00 14.87           O  
ATOM   1750  CB  SER B 106      82.340  47.666  26.193  1.00 14.23           C  
ATOM   1751  OG  SER B 106      81.779  47.430  24.922  1.00 14.90           O  
ATOM   1752  N   CYS B 107      85.271  47.207  27.747  1.00 15.64           N  
ATOM   1753  CA  CYS B 107      86.118  47.441  28.909  1.00 15.32           C  
ATOM   1754  C   CYS B 107      86.780  48.810  28.778  1.00 14.39           C  
ATOM   1755  O   CYS B 107      87.434  49.094  27.779  1.00 15.04           O  
ATOM   1756  CB  CYS B 107      87.187  46.388  28.973  1.00 15.93           C  
ATOM   1757  SG  CYS B 107      88.185  46.511  30.464  1.00 20.29           S  
ATOM   1758  N   VAL B 108      86.538  49.689  29.741  1.00 13.03           N  
ATOM   1759  CA  VAL B 108      87.138  51.009  29.733  1.00 11.19           C  
ATOM   1760  C   VAL B 108      87.665  51.333  31.127  1.00 11.01           C  
ATOM   1761  O   VAL B 108      87.164  50.829  32.143  1.00 11.35           O  
ATOM   1762  CB  VAL B 108      86.155  52.137  29.159  1.00 10.88           C  
ATOM   1763  CG1 VAL B 108      85.633  51.769  27.813  1.00  7.14           C  
ATOM   1764  CG2 VAL B 108      85.035  52.422  30.067  1.00 10.09           C  
ATOM   1765  N   GLN B 109      88.677  52.178  31.181  1.00 10.51           N  
ATOM   1766  CA  GLN B 109      89.132  52.692  32.426  1.00  9.62           C  
ATOM   1767  C   GLN B 109      88.509  54.024  32.627  1.00  9.39           C  
ATOM   1768  O   GLN B 109      88.823  54.979  31.931  1.00  9.16           O  
ATOM   1769  CB  GLN B 109      90.644  52.890  32.392  1.00 10.41           C  
ATOM   1770  CG  GLN B 109      91.221  53.187  33.742  1.00 10.48           C  
ATOM   1771  CD  GLN B 109      92.616  53.696  33.635  1.00 11.78           C  
ATOM   1772  OE1 GLN B 109      93.507  52.994  33.157  1.00 16.26           O  
ATOM   1773  NE2 GLN B 109      92.829  54.912  34.095  1.00 10.74           N  
ATOM   1774  N   VAL B 110      87.664  54.098  33.638  1.00 10.03           N  
ATOM   1775  CA  VAL B 110      87.047  55.354  34.099  1.00 10.25           C  
ATOM   1776  C   VAL B 110      87.927  56.047  35.143  1.00 10.37           C  
ATOM   1777  O   VAL B 110      88.931  55.511  35.531  1.00 10.61           O  
ATOM   1778  CB  VAL B 110      85.639  55.066  34.639  1.00 10.71           C  
ATOM   1779  CG1 VAL B 110      84.833  54.458  33.520  1.00  8.01           C  
ATOM   1780  CG2 VAL B 110      85.710  54.115  35.845  1.00  9.66           C  
ATOM   1781  N   ALA B 111      87.569  57.256  35.552  1.00 11.51           N  
ATOM   1782  CA  ALA B 111      88.300  58.003  36.581  1.00 11.54           C  
ATOM   1783  C   ALA B 111      88.089  57.413  37.953  1.00 12.41           C  
ATOM   1784  O   ALA B 111      89.029  57.342  38.757  1.00 13.84           O  
ATOM   1785  CB  ALA B 111      87.891  59.496  36.575  1.00 10.46           C  
ATOM   1786  N   ARG B 112      86.851  57.003  38.253  1.00 12.68           N  
ATOM   1787  CA  ARG B 112      86.528  56.542  39.602  1.00 12.15           C  
ATOM   1788  C   ARG B 112      85.195  55.807  39.625  1.00 12.55           C  
ATOM   1789  O   ARG B 112      84.303  56.123  38.827  1.00 10.83           O  
ATOM   1790  CB  ARG B 112      86.463  57.744  40.547  1.00 12.09           C  
ATOM   1791  CG  ARG B 112      86.606  57.471  42.011  1.00 11.98           C  
ATOM   1792  CD  ARG B 112      86.365  58.741  42.836  1.00 10.99           C  
ATOM   1793  NE  ARG B 112      86.560  58.453  44.244  1.00 14.00           N  
ATOM   1794  CZ  ARG B 112      86.314  59.290  45.262  1.00 15.96           C  
ATOM   1795  NH1 ARG B 112      85.822  60.496  45.056  1.00 16.19           N  
ATOM   1796  NH2 ARG B 112      86.543  58.890  46.501  1.00 15.31           N  
ATOM   1797  N   LEU B 113      85.067  54.888  40.598  1.00 13.06           N  
ATOM   1798  CA  LEU B 113      83.836  54.124  40.835  1.00 14.03           C  
ATOM   1799  C   LEU B 113      83.298  54.252  42.218  1.00 14.49           C  
ATOM   1800  O   LEU B 113      84.030  54.558  43.133  1.00 14.89           O  
ATOM   1801  CB  LEU B 113      84.044  52.613  40.546  1.00 14.03           C  
ATOM   1802  CG  LEU B 113      84.512  52.366  39.130  1.00 13.06           C  
ATOM   1803  CD1 LEU B 113      85.230  51.052  39.024  1.00 11.30           C  
ATOM   1804  CD2 LEU B 113      83.345  52.617  38.113  1.00  7.29           C  
ATOM   1805  N   PRO B 114      82.004  53.931  42.398  1.00 15.94           N  
ATOM   1806  CA  PRO B 114      81.458  53.927  43.760  1.00 15.91           C  
ATOM   1807  C   PRO B 114      82.348  53.135  44.762  1.00 17.80           C  
ATOM   1808  O   PRO B 114      82.791  52.006  44.479  1.00 18.62           O  
ATOM   1809  CB  PRO B 114      80.097  53.238  43.569  1.00 16.35           C  
ATOM   1810  CG  PRO B 114      79.670  53.639  42.136  1.00 14.93           C  
ATOM   1811  CD  PRO B 114      80.987  53.538  41.381  1.00 15.46           C  
ATOM   1812  N   LYS B 115      82.607  53.748  45.912  1.00 18.80           N  
ATOM   1813  CA  LYS B 115      83.315  53.172  47.052  1.00 18.46           C  
ATOM   1814  C   LYS B 115      84.782  52.880  46.760  1.00 18.48           C  
ATOM   1815  O   LYS B 115      85.452  52.143  47.515  1.00 18.57           O  
ATOM   1816  CB  LYS B 115      82.586  51.946  47.534  1.00 19.33           C  
ATOM   1817  CG  LYS B 115      81.201  52.267  48.015  1.00 22.92           C  
ATOM   1818  CD  LYS B 115      80.639  51.120  48.816  1.00 28.61           C  
ATOM   1819  CE  LYS B 115      79.158  51.134  48.709  1.00 33.32           C  
ATOM   1820  NZ  LYS B 115      78.668  51.255  50.097  1.00 37.94           N  
ATOM   1821  N   ASP B 116      85.286  53.501  45.688  1.00 17.24           N  
ATOM   1822  CA  ASP B 116      86.664  53.370  45.263  1.00 16.21           C  
ATOM   1823  C   ASP B 116      87.009  51.927  44.943  1.00 15.25           C  
ATOM   1824  O   ASP B 116      88.141  51.497  45.097  1.00 15.40           O  
ATOM   1825  CB  ASP B 116      87.637  53.993  46.276  1.00 17.02           C  
ATOM   1826  CG  ASP B 116      87.516  55.512  46.343  1.00 20.24           C  
ATOM   1827  OD1 ASP B 116      87.719  56.220  45.334  1.00 25.50           O  
ATOM   1828  OD2 ASP B 116      87.201  56.013  47.416  1.00 25.86           O  
ATOM   1829  N   VAL B 117      86.025  51.172  44.493  1.00 13.74           N  
ATOM   1830  CA  VAL B 117      86.289  49.852  44.029  1.00 13.21           C  
ATOM   1831  C   VAL B 117      87.095  49.959  42.734  1.00 14.08           C  
ATOM   1832  O   VAL B 117      87.129  51.026  42.098  1.00 13.63           O  
ATOM   1833  CB  VAL B 117      84.993  49.026  43.808  1.00 13.58           C  
ATOM   1834  CG1 VAL B 117      84.235  48.853  45.122  1.00 11.92           C  
ATOM   1835  CG2 VAL B 117      84.094  49.591  42.650  1.00 10.99           C  
ATOM   1836  N   LYS B 118      87.744  48.848  42.380  1.00 13.80           N  
ATOM   1837  CA  LYS B 118      88.534  48.733  41.186  1.00 13.84           C  
ATOM   1838  C   LYS B 118      87.801  48.366  39.859  1.00 14.89           C  
ATOM   1839  O   LYS B 118      88.364  48.547  38.781  1.00 16.18           O  
ATOM   1840  CB  LYS B 118      89.646  47.753  41.452  1.00 14.02           C  
ATOM   1841  CG  LYS B 118      90.738  48.268  42.340  1.00 12.55           C  
ATOM   1842  CD  LYS B 118      91.509  47.098  42.834  1.00 19.37           C  
ATOM   1843  CE  LYS B 118      92.923  47.528  43.358  1.00 27.87           C  
ATOM   1844  NZ  LYS B 118      92.826  47.998  44.753  1.00 27.73           N  
ATOM   1845  N   LEU B 119      86.578  47.854  39.926  1.00 14.92           N  
ATOM   1846  CA  LEU B 119      85.807  47.550  38.743  1.00 15.64           C  
ATOM   1847  C   LEU B 119      84.315  47.552  39.048  1.00 15.77           C  
ATOM   1848  O   LEU B 119      83.926  47.320  40.184  1.00 16.86           O  
ATOM   1849  CB  LEU B 119      86.218  46.200  38.105  1.00 15.70           C  
ATOM   1850  CG  LEU B 119      85.935  44.849  38.769  1.00 16.64           C  
ATOM   1851  CD1 LEU B 119      86.259  43.742  37.798  1.00 15.35           C  
ATOM   1852  CD2 LEU B 119      86.801  44.730  39.957  1.00 10.86           C  
ATOM   1853  N   GLU B 120      83.493  47.823  38.031  1.00 15.36           N  
ATOM   1854  CA  GLU B 120      82.039  47.665  38.119  1.00 14.51           C  
ATOM   1855  C   GLU B 120      81.619  46.923  36.864  1.00 13.23           C  
ATOM   1856  O   GLU B 120      82.123  47.210  35.812  1.00 13.16           O  
ATOM   1857  CB  GLU B 120      81.357  49.029  38.248  1.00 13.52           C  
ATOM   1858  CG  GLU B 120      79.892  48.990  38.366  1.00 13.83           C  
ATOM   1859  CD  GLU B 120      79.257  50.398  38.436  1.00 17.70           C  
ATOM   1860  OE1 GLU B 120      79.945  51.365  38.916  1.00 14.95           O  
ATOM   1861  OE2 GLU B 120      78.036  50.502  38.049  1.00 20.85           O  
ATOM   1862  N   ILE B 121      80.746  45.937  36.995  1.00 12.75           N  
ATOM   1863  CA  ILE B 121      80.372  45.096  35.871  1.00 12.79           C  
ATOM   1864  C   ILE B 121      78.842  45.048  35.792  1.00 13.73           C  
ATOM   1865  O   ILE B 121      78.185  44.646  36.757  1.00 14.08           O  
ATOM   1866  CB  ILE B 121      80.868  43.636  36.052  1.00 12.37           C  
ATOM   1867  CG1 ILE B 121      82.377  43.576  36.399  1.00 12.05           C  
ATOM   1868  CG2 ILE B 121      80.509  42.783  34.841  1.00 11.47           C  
ATOM   1869  CD1 ILE B 121      83.085  42.162  36.202  1.00 11.67           C  
ATOM   1870  N   GLU B 122      78.295  45.483  34.667  1.00 12.81           N  
ATOM   1871  CA  GLU B 122      76.886  45.232  34.302  1.00 13.90           C  
ATOM   1872  C   GLU B 122      76.690  44.121  33.221  1.00 13.78           C  
ATOM   1873  O   GLU B 122      77.598  43.795  32.439  1.00 14.96           O  
ATOM   1874  CB  GLU B 122      76.239  46.516  33.851  1.00 12.52           C  
ATOM   1875  CG  GLU B 122      76.961  47.076  32.667  1.00 15.67           C  
ATOM   1876  CD  GLU B 122      76.268  48.293  32.123  1.00 15.71           C  
ATOM   1877  OE1 GLU B 122      76.003  49.201  32.887  1.00 20.70           O  
ATOM   1878  OE2 GLU B 122      75.979  48.352  30.939  1.00 19.14           O  
ATOM   1879  N   ALA B 123      75.514  43.511  33.205  1.00 13.45           N  
ATOM   1880  CA  ALA B 123      75.318  42.330  32.392  1.00 13.64           C  
ATOM   1881  C   ALA B 123      73.989  42.464  31.664  1.00 13.52           C  
ATOM   1882  O   ALA B 123      73.094  43.087  32.171  1.00 12.60           O  
ATOM   1883  CB  ALA B 123      75.348  41.038  33.270  1.00 12.31           C  
ATOM   1884  N   ILE B 124      73.906  41.891  30.463  1.00 14.61           N  
ATOM   1885  CA  ILE B 124      72.625  41.645  29.783  1.00 14.43           C  
ATOM   1886  C   ILE B 124      72.589  40.157  29.479  1.00 16.04           C  
ATOM   1887  O   ILE B 124      73.564  39.602  28.962  1.00 14.19           O  
ATOM   1888  CB  ILE B 124      72.480  42.459  28.503  1.00 13.86           C  
ATOM   1889  CG1 ILE B 124      72.609  43.941  28.810  1.00 12.17           C  
ATOM   1890  CG2 ILE B 124      71.124  42.163  27.795  1.00 13.18           C  
ATOM   1891  CD1 ILE B 124      72.823  44.763  27.568  1.00 15.18           C  
ATOM   1892  N   ALA B 125      71.470  39.525  29.847  1.00 18.21           N  
ATOM   1893  CA  ALA B 125      71.240  38.097  29.632  1.00 20.83           C  
ATOM   1894  C   ALA B 125      69.948  37.900  28.849  1.00 23.01           C  
ATOM   1895  O   ALA B 125      69.006  38.687  29.016  1.00 22.81           O  
ATOM   1896  CB  ALA B 125      71.189  37.361  30.978  1.00 20.76           C  
ATOM   1897  N   VAL B 126      69.905  36.892  27.965  1.00 25.97           N  
ATOM   1898  CA  VAL B 126      68.631  36.488  27.274  1.00 28.61           C  
ATOM   1899  C   VAL B 126      68.072  35.200  27.864  1.00 30.89           C  
ATOM   1900  O   VAL B 126      68.845  34.339  28.294  1.00 30.51           O  
ATOM   1901  CB  VAL B 126      68.773  36.257  25.738  1.00 28.43           C  
ATOM   1902  CG1 VAL B 126      68.982  37.551  25.033  1.00 29.10           C  
ATOM   1903  CG2 VAL B 126      69.910  35.205  25.400  1.00 28.35           C  
ATOM   1904  N   ARG B 127      66.739  35.061  27.834  1.00 34.96           N  
ATOM   1905  CA  ARG B 127      66.030  33.909  28.424  1.00 37.52           C  
ATOM   1906  C   ARG B 127      66.316  32.668  27.594  1.00 40.82           C  
ATOM   1907  O   ARG B 127      66.800  31.653  28.168  1.00 42.26           O  
ATOM   1908  CB  ARG B 127      64.526  34.155  28.587  1.00 37.07           C  
ATOM   1909  CG  ARG B 127      63.647  32.930  28.997  1.00 35.69           C  
ATOM   1910  CD  ARG B 127      63.317  32.899  30.486  1.00 34.89           C  
ATOM   1911  NE  ARG B 127      63.136  34.261  30.907  1.00 34.12           N  
ATOM   1912  CZ  ARG B 127      63.406  34.767  32.097  1.00 32.73           C  
ATOM   1913  NH1 ARG B 127      63.822  34.038  33.097  1.00 31.50           N  
ATOM   1914  NH2 ARG B 127      63.221  36.054  32.270  1.00 36.52           N  
ATOM   1915  N   SER B 128      66.072  32.702  26.276  1.00 43.02           N  
ATOM   1916  CA  SER B 128      66.450  31.488  25.485  1.00 45.93           C  
ATOM   1917  C   SER B 128      67.543  31.682  24.396  1.00 47.09           C  
ATOM   1918  O   SER B 128      67.785  30.790  23.550  1.00 48.48           O  
ATOM   1919  CB  SER B 128      65.211  30.712  24.942  1.00 46.69           C  
ATOM   1920  OG  SER B 128      64.707  29.786  25.907  1.00 47.16           O  
TER    1921      SER B 128                                                      
END
MOLECULE T0423.pdb
ATOM  12910  N   MET     1      70.981  21.031  37.362  1.00 36.76           N  
ATOM  12911  CA  MET     1      71.905  21.930  36.664  1.00 38.87           C  
ATOM  12912  C   MET     1      72.311  23.119  37.519  1.00 35.58           C  
ATOM  12913  O   MET     1      73.455  23.538  37.475  1.00 34.69           O  
ATOM  12914  CB  MET     1      71.283  22.461  35.383  1.00 39.21           C  
ATOM  12915  CG  MET     1      71.504  21.613  34.171  1.00 44.40           C  
ATOM  12916  SD  MET     1      70.806  22.501  32.558  1.00 57.84          SE  
ATOM  12917  CE  MET     1      71.792  24.214  32.666  1.00 53.65           C  
ATOM  12918  N   SER     2      71.368  23.671  38.275  1.00 34.19           N  
ATOM  12919  CA  SER     2      71.660  24.824  39.146  1.00 33.25           C  
ATOM  12920  C   SER     2      72.590  24.410  40.267  1.00 32.21           C  
ATOM  12921  O   SER     2      73.492  25.167  40.644  1.00 30.89           O  
ATOM  12922  CB  SER     2      70.389  25.426  39.738  1.00 32.90           C  
ATOM  12923  OG  SER     2      69.633  26.060  38.749  1.00 33.07           O  
ATOM  12924  N   ASP     3      72.374  23.203  40.811  1.00 30.62           N  
ATOM  12925  CA  ASP     3      73.242  22.687  41.862  1.00 30.33           C  
ATOM  12926  C   ASP     3      74.682  22.556  41.347  1.00 28.94           C  
ATOM  12927  O   ASP     3      75.638  22.825  42.091  1.00 29.92           O  
ATOM  12928  CB  ASP     3      72.774  21.291  42.370  1.00 30.67           C  
ATOM  12929  CG  ASP     3      71.492  21.328  43.198  1.00 32.38           C  
ATOM  12930  OD1 ASP     3      71.019  22.402  43.615  1.00 35.40           O  
ATOM  12931  OD2 ASP     3      70.942  20.230  43.448  1.00 35.26           O  
ATOM  12932  N   VAL     4      74.823  22.096  40.101  1.00 27.71           N  
ATOM  12933  CA  VAL     4      76.127  21.864  39.482  1.00 27.34           C  
ATOM  12934  C   VAL     4      76.846  23.203  39.304  1.00 26.70           C  
ATOM  12935  O   VAL     4      78.035  23.311  39.582  1.00 25.89           O  
ATOM  12936  CB  VAL     4      75.994  21.175  38.115  1.00 27.32           C  
ATOM  12937  CG1 VAL     4      77.261  21.282  37.304  1.00 28.31           C  
ATOM  12938  CG2 VAL     4      75.606  19.678  38.300  1.00 27.74           C  
ATOM  12939  N   ILE     5      76.114  24.200  38.836  1.00 26.35           N  
ATOM  12940  CA  ILE     5      76.694  25.575  38.675  1.00 26.66           C  
ATOM  12941  C   ILE     5      77.167  26.134  40.031  1.00 26.86           C  
ATOM  12942  O   ILE     5      78.302  26.546  40.179  1.00 27.38           O  
ATOM  12943  CB  ILE     5      75.680  26.562  37.999  1.00 26.48           C  
ATOM  12944  CG1 ILE     5      75.346  26.128  36.566  1.00 24.54           C  
ATOM  12945  CG2 ILE     5      76.257  28.001  37.934  1.00 26.07           C  
ATOM  12946  CD1 ILE     5      74.048  26.748  35.988  1.00 26.63           C  
ATOM  12947  N   GLU     6      76.308  26.117  41.034  1.00 27.87           N  
ATOM  12948  CA  GLU     6      76.688  26.606  42.353  1.00 28.66           C  
ATOM  12949  C   GLU     6      77.785  25.768  43.000  1.00 28.15           C  
ATOM  12950  O   GLU     6      78.644  26.303  43.709  1.00 27.19           O  
ATOM  12951  CB  GLU     6      75.481  26.702  43.272  1.00 29.19           C  
ATOM  12952  CG  GLU     6      74.484  27.740  42.832  1.00 31.30           C  
ATOM  12953  CD  GLU     6      73.485  28.113  43.911  1.00 31.61           C  
ATOM  12954  OE1 GLU     6      73.885  28.327  45.083  1.00 38.52           O  
ATOM  12955  OE2 GLU     6      72.296  28.217  43.572  1.00 35.07           O  
ATOM  12956  N   GLY     7      77.769  24.454  42.764  1.00 27.55           N  
ATOM  12957  CA  GLY     7      78.825  23.599  43.252  1.00 27.47           C  
ATOM  12958  C   GLY     7      80.172  23.924  42.647  1.00 27.46           C  
ATOM  12959  O   GLY     7      81.190  23.916  43.348  1.00 28.04           O  
ATOM  12960  N   ARG     8      80.193  24.198  41.351  1.00 27.39           N  
ATOM  12961  CA  ARG     8      81.428  24.591  40.683  1.00 28.18           C  
ATOM  12962  C   ARG     8      81.977  25.901  41.263  1.00 27.87           C  
ATOM  12963  O   ARG     8      83.187  26.055  41.439  1.00 28.10           O  
ATOM  12964  CB  ARG     8      81.219  24.776  39.185  1.00 27.91           C  
ATOM  12965  CG  ARG     8      81.010  23.509  38.405  1.00 28.72           C  
ATOM  12966  CD  ARG     8      80.440  23.881  37.071  1.00 31.46           C  
ATOM  12967  NE  ARG     8      80.192  22.738  36.217  1.00 33.09           N  
ATOM  12968  CZ  ARG     8      79.413  22.752  35.140  1.00 35.77           C  
ATOM  12969  NH1 ARG     8      78.767  23.854  34.762  1.00 36.28           N  
ATOM  12970  NH2 ARG     8      79.267  21.629  34.439  1.00 38.50           N  
ATOM  12971  N   LEU     9      81.077  26.830  41.554  1.00 28.09           N  
ATOM  12972  CA  LEU     9      81.479  28.113  42.139  1.00 28.34           C  
ATOM  12973  C   LEU     9      82.103  27.873  43.539  1.00 28.63           C  
ATOM  12974  O   LEU     9      83.145  28.457  43.874  1.00 27.85           O  
ATOM  12975  CB  LEU     9      80.271  29.044  42.209  1.00 28.43           C  
ATOM  12976  CG  LEU     9      80.543  30.479  42.669  1.00 28.95           C  
ATOM  12977  CD1 LEU     9      81.644  31.110  41.771  1.00 29.20           C  
ATOM  12978  CD2 LEU     9      79.251  31.302  42.651  1.00 29.10           C  
ATOM  12979  N   LYS    10      81.487  26.998  44.343  1.00 28.27           N  
ATOM  12980  CA  LYS    10      82.090  26.586  45.618  1.00 29.09           C  
ATOM  12981  C   LYS    10      83.477  25.946  45.467  1.00 29.33           C  
ATOM  12982  O   LYS    10      84.380  26.178  46.296  1.00 30.06           O  
ATOM  12983  CB  LYS    10      81.155  25.648  46.379  1.00 29.06           C  
ATOM  12984  CG  LYS    10      79.869  26.277  46.842  1.00 29.74           C  
ATOM  12985  CD  LYS    10      79.055  25.300  47.652  1.00 30.41           C  
ATOM  12986  CE  LYS    10      77.739  25.887  48.034  1.00 30.84           C  
ATOM  12987  NZ  LYS    10      76.878  24.856  48.677  1.00 32.89           N  
ATOM  12988  N   GLU    11      83.673  25.166  44.413  1.00 29.53           N  
ATOM  12989  CA  GLU    11      84.977  24.594  44.114  1.00 30.47           C  
ATOM  12990  C   GLU    11      86.011  25.667  43.795  1.00 30.79           C  
ATOM  12991  O   GLU    11      87.190  25.452  44.020  1.00 32.10           O  
ATOM  12992  CB  GLU    11      84.889  23.624  42.946  1.00 30.41           C  
ATOM  12993  CG  GLU    11      84.195  22.304  43.287  1.00 31.53           C  
ATOM  12994  CD  GLU    11      83.980  21.440  42.072  1.00 33.05           C  
ATOM  12995  OE1 GLU    11      83.483  21.935  41.044  1.00 37.69           O  
ATOM  12996  OE2 GLU    11      84.275  20.239  42.144  1.00 40.32           O  
ATOM  12997  N   LEU    12      85.573  26.810  43.266  1.00 30.96           N  
ATOM  12998  CA  LEU    12      86.458  27.982  43.080  1.00 30.36           C  
ATOM  12999  C   LEU    12      86.672  28.813  44.349  1.00 30.69           C  
ATOM  13000  O   LEU    12      87.510  29.730  44.358  1.00 31.30           O  
ATOM  13001  CB  LEU    12      85.912  28.883  41.982  1.00 29.65           C  
ATOM  13002  CG  LEU    12      85.889  28.253  40.603  1.00 29.14           C  
ATOM  13003  CD1 LEU    12      85.193  29.190  39.650  1.00 28.44           C  
ATOM  13004  CD2 LEU    12      87.318  27.916  40.123  1.00 30.62           C  
ATOM  13005  N   GLY    13      85.906  28.530  45.398  1.00 30.88           N  
ATOM  13006  CA  GLY    13      86.097  29.154  46.694  1.00 30.87           C  
ATOM  13007  C   GLY    13      85.047  30.177  47.062  1.00 30.89           C  
ATOM  13008  O   GLY    13      85.157  30.816  48.099  1.00 31.94           O  
ATOM  13009  N   PHE    14      84.004  30.303  46.254  1.00 30.40           N  
ATOM  13010  CA  PHE    14      82.959  31.278  46.509  1.00 30.42           C  
ATOM  13011  C   PHE    14      81.595  30.647  46.801  1.00 31.05           C  
ATOM  13012  O   PHE    14      81.170  29.691  46.147  1.00 30.75           O  
ATOM  13013  CB  PHE    14      82.829  32.227  45.312  1.00 29.97           C  
ATOM  13014  CG  PHE    14      84.106  32.886  44.930  1.00 28.80           C  
ATOM  13015  CD1 PHE    14      84.494  34.057  45.537  1.00 29.32           C  
ATOM  13016  CD2 PHE    14      84.924  32.336  43.954  1.00 28.91           C  
ATOM  13017  CE1 PHE    14      85.688  34.670  45.177  1.00 27.83           C  
ATOM  13018  CE2 PHE    14      86.114  32.938  43.594  1.00 28.84           C  
ATOM  13019  CZ  PHE    14      86.494  34.108  44.214  1.00 28.76           C  
ATOM  13020  N   THR    15      80.906  31.228  47.769  1.00 31.89           N  
ATOM  13021  CA  THR    15      79.480  31.011  47.934  1.00 33.07           C  
ATOM  13022  C   THR    15      78.738  32.270  47.471  1.00 33.07           C  
ATOM  13023  O   THR    15      79.306  33.390  47.471  1.00 32.98           O  
ATOM  13024  CB  THR    15      79.142  30.676  49.406  1.00 33.77           C  
ATOM  13025  OG1 THR    15      79.407  31.816  50.239  1.00 37.27           O  
ATOM  13026  CG2 THR    15      79.988  29.500  49.902  1.00 32.51           C  
ATOM  13027  N   LEU    16      77.488  32.100  47.043  1.00 32.88           N  
ATOM  13028  CA  LEU    16      76.696  33.230  46.573  1.00 32.59           C  
ATOM  13029  C   LEU    16      76.163  34.007  47.767  1.00 33.08           C  
ATOM  13030  O   LEU    16      75.580  33.413  48.678  1.00 32.54           O  
ATOM  13031  CB  LEU    16      75.513  32.781  45.706  1.00 32.47           C  
ATOM  13032  CG  LEU    16      75.834  32.190  44.332  1.00 31.50           C  
ATOM  13033  CD1 LEU    16      74.534  31.595  43.670  1.00 29.77           C  
ATOM  13034  CD2 LEU    16      76.521  33.215  43.434  1.00 28.44           C  
ATOM  13035  N   PRO    17      76.338  35.334  47.771  1.00 33.26           N  
ATOM  13036  CA  PRO    17      75.694  36.103  48.823  1.00 33.95           C  
ATOM  13037  C   PRO    17      74.202  36.176  48.577  1.00 35.74           C  
ATOM  13038  O   PRO    17      73.743  35.890  47.461  1.00 35.40           O  
ATOM  13039  CB  PRO    17      76.304  37.492  48.650  1.00 33.84           C  
ATOM  13040  CG  PRO    17      76.630  37.570  47.219  1.00 33.42           C  
ATOM  13041  CD  PRO    17      77.081  36.198  46.835  1.00 32.52           C  
ATOM  13042  N   VAL    18      73.449  36.584  49.596  1.00 37.90           N  
ATOM  13043  CA  VAL    18      72.045  36.963  49.389  1.00 39.41           C  
ATOM  13044  C   VAL    18      71.995  38.269  48.568  1.00 40.41           C  
ATOM  13045  O   VAL    18      71.230  38.389  47.586  1.00 42.23           O  
ATOM  13046  CB  VAL    18      71.308  37.200  50.710  1.00 39.67           C  
ATOM  13047  CG1 VAL    18      71.505  36.006  51.656  1.00 40.20           C  
ATOM  13048  CG2 VAL    18      71.762  38.513  51.345  1.00 39.98           C  
ATOM  13049  N   ALA    23      66.158  48.786  48.809  1.00 42.30           N  
ATOM  13050  CA  ALA    23      64.939  49.472  48.343  1.00 41.72           C  
ATOM  13051  C   ALA    23      65.286  50.838  47.711  1.00 41.82           C  
ATOM  13052  O   ALA    23      65.606  51.804  48.439  1.00 42.33           O  
ATOM  13053  CB  ALA    23      63.942  49.647  49.513  1.00 42.49           C  
ATOM  13054  N   ALA    24      65.243  50.926  46.370  1.00 40.52           N  
ATOM  13055  CA  ALA    24      65.678  52.154  45.678  1.00 38.94           C  
ATOM  13056  C   ALA    24      64.979  52.405  44.337  1.00 37.86           C  
ATOM  13057  O   ALA    24      64.258  51.549  43.818  1.00 37.65           O  
ATOM  13058  CB  ALA    24      67.220  52.130  45.485  1.00 39.16           C  
ATOM  13059  N   ASN    25      65.207  53.597  43.784  1.00 35.84           N  
ATOM  13060  CA  ASN    25      64.676  53.977  42.458  1.00 34.71           C  
ATOM  13061  C   ASN    25      65.420  53.350  41.277  1.00 32.01           C  
ATOM  13062  O   ASN    25      64.955  53.404  40.128  1.00 30.65           O  
ATOM  13063  CB  ASN    25      64.628  55.506  42.327  1.00 34.31           C  
ATOM  13064  CG  ASN    25      63.556  56.116  43.221  1.00 34.82           C  
ATOM  13065  OD1 ASN    25      63.757  57.167  43.838  1.00 36.03           O  
ATOM  13066  ND2 ASN    25      62.419  55.419  43.327  1.00 31.59           N  
ATOM  13067  N   TYR    26      66.570  52.763  41.572  1.00 30.18           N  
ATOM  13068  CA  TYR    26      67.208  51.824  40.653  1.00 28.61           C  
ATOM  13069  C   TYR    26      67.192  50.433  41.287  1.00 26.27           C  
ATOM  13070  O   TYR    26      67.222  50.261  42.514  1.00 25.81           O  
ATOM  13071  CB  TYR    26      68.625  52.246  40.221  1.00 28.83           C  
ATOM  13072  CG  TYR    26      69.621  52.398  41.339  1.00 30.60           C  
ATOM  13073  CD1 TYR    26      70.670  51.493  41.495  1.00 30.95           C  
ATOM  13074  CD2 TYR    26      69.522  53.456  42.230  1.00 30.60           C  
ATOM  13075  CE1 TYR    26      71.582  51.635  42.510  1.00 30.87           C  
ATOM  13076  CE2 TYR    26      70.411  53.597  43.267  1.00 32.36           C  
ATOM  13077  CZ  TYR    26      71.447  52.689  43.404  1.00 32.75           C  
ATOM  13078  OH  TYR    26      72.352  52.852  44.448  1.00 34.31           O  
ATOM  13079  N   VAL    27      67.135  49.446  40.418  1.00 24.17           N  
ATOM  13080  CA  VAL    27      67.030  48.071  40.817  1.00 22.92           C  
ATOM  13081  C   VAL    27      68.271  47.271  40.393  1.00 22.47           C  
ATOM  13082  O   VAL    27      68.985  47.662  39.463  1.00 20.80           O  
ATOM  13083  CB  VAL    27      65.757  47.458  40.209  1.00 22.53           C  
ATOM  13084  CG1 VAL    27      64.536  48.064  40.881  1.00 24.05           C  
ATOM  13085  CG2 VAL    27      65.709  47.685  38.675  1.00 20.19           C  
ATOM  13086  N   PRO    28      68.514  46.135  41.065  1.00 22.19           N  
ATOM  13087  CA  PRO    28      69.643  45.282  40.693  1.00 22.05           C  
ATOM  13088  C   PRO    28      69.576  44.646  39.313  1.00 21.32           C  
ATOM  13089  O   PRO    28      70.620  44.298  38.758  1.00 19.41           O  
ATOM  13090  CB  PRO    28      69.645  44.208  41.765  1.00 23.32           C  
ATOM  13091  CG  PRO    28      68.744  44.705  42.839  1.00 24.78           C  
ATOM  13092  CD  PRO    28      67.767  45.580  42.209  1.00 22.87           C  
ATOM  13093  N   PHE    29      68.366  44.511  38.760  1.00 20.74           N  
ATOM  13094  CA  PHE    29      68.186  43.931  37.454  1.00 21.35           C  
ATOM  13095  C   PHE    29      66.815  44.278  36.885  1.00 20.78           C  
ATOM  13096  O   PHE    29      65.876  44.597  37.615  1.00 20.82           O  
ATOM  13097  CB  PHE    29      68.410  42.392  37.475  1.00 21.85           C  
ATOM  13098  CG  PHE    29      67.437  41.650  38.360  1.00 22.44           C  
ATOM  13099  CD1 PHE    29      66.175  41.334  37.907  1.00 24.23           C  
ATOM  13100  CD2 PHE    29      67.776  41.337  39.664  1.00 24.23           C  
ATOM  13101  CE1 PHE    29      65.265  40.664  38.746  1.00 23.72           C  
ATOM  13102  CE2 PHE    29      66.883  40.698  40.489  1.00 26.07           C  
ATOM  13103  CZ  PHE    29      65.623  40.381  40.031  1.00 24.55           C  
ATOM  13104  N   THR    30      66.753  44.281  35.568  1.00 21.11           N  
ATOM  13105  CA  THR    30      65.491  44.370  34.819  1.00 22.00           C  
ATOM  13106  C   THR    30      65.480  43.293  33.752  1.00 22.35           C  
ATOM  13107  O   THR    30      66.525  42.798  33.356  1.00 21.01           O  
ATOM  13108  CB  THR    30      65.298  45.735  34.132  1.00 22.63           C  
ATOM  13109  OG1 THR    30      66.405  46.020  33.266  1.00 22.53           O  
ATOM  13110  CG2 THR    30      65.139  46.846  35.164  1.00 21.28           C  
ATOM  13111  N   ILE    31      64.276  42.943  33.280  1.00 23.19           N  
ATOM  13112  CA  ILE    31      64.104  41.993  32.189  1.00 23.67           C  
ATOM  13113  C   ILE    31      63.288  42.634  31.087  1.00 23.56           C  
ATOM  13114  O   ILE    31      62.269  43.294  31.331  1.00 24.21           O  
ATOM  13115  CB  ILE    31      63.424  40.684  32.664  1.00 23.86           C  
ATOM  13116  CG1 ILE    31      64.303  39.977  33.687  1.00 23.74           C  
ATOM  13117  CG2 ILE    31      63.169  39.723  31.486  1.00 24.39           C  
ATOM  13118  CD1 ILE    31      63.577  38.878  34.465  1.00 25.28           C  
ATOM  13119  N   SER    32      63.757  42.461  29.874  1.00 24.00           N  
ATOM  13120  CA  SER    32      63.011  42.846  28.692  1.00 25.73           C  
ATOM  13121  C   SER    32      63.058  41.677  27.730  1.00 25.64           C  
ATOM  13122  O   SER    32      64.122  41.331  27.246  1.00 25.50           O  
ATOM  13123  CB  SER    32      63.598  44.073  28.021  1.00 25.81           C  
ATOM  13124  OG  SER    32      62.809  44.432  26.913  1.00 27.19           O  
ATOM  13125  N   GLY    33      61.903  41.083  27.430  1.00 26.33           N  
ATOM  13126  CA  GLY    33      61.899  39.878  26.629  1.00 26.22           C  
ATOM  13127  C   GLY    33      62.655  38.771  27.314  1.00 25.36           C  
ATOM  13128  O   GLY    33      62.370  38.424  28.457  1.00 26.34           O  
ATOM  13129  N   ASN    34      63.633  38.209  26.622  1.00 24.98           N  
ATOM  13130  CA  ASN    34      64.458  37.178  27.241  1.00 25.51           C  
ATOM  13131  C   ASN    34      65.858  37.705  27.552  1.00 24.78           C  
ATOM  13132  O   ASN    34      66.804  36.930  27.584  1.00 24.18           O  
ATOM  13133  CB  ASN    34      64.528  35.934  26.371  1.00 27.08           C  
ATOM  13134  CG  ASN    34      65.282  36.158  25.091  1.00 30.55           C  
ATOM  13135  OD1 ASN    34      65.607  37.305  24.738  1.00 35.31           O  
ATOM  13136  ND2 ASN    34      65.586  35.057  24.371  1.00 35.76           N  
ATOM  13137  N   LEU    35      65.983  39.022  27.699  1.00 24.55           N  
ATOM  13138  CA  LEU    35      67.277  39.637  28.078  1.00 24.12           C  
ATOM  13139  C   LEU    35      67.189  40.157  29.496  1.00 23.03           C  
ATOM  13140  O   LEU    35      66.268  40.868  29.847  1.00 23.05           O  
ATOM  13141  CB  LEU    35      67.702  40.736  27.096  1.00 24.76           C  
ATOM  13142  CG  LEU    35      68.282  40.199  25.764  1.00 26.16           C  
ATOM  13143  CD1 LEU    35      68.633  41.334  24.793  1.00 28.97           C  
ATOM  13144  CD2 LEU    35      69.489  39.249  25.947  1.00 28.49           C  
ATOM  13145  N   LEU    36      68.148  39.763  30.315  1.00 21.64           N  
ATOM  13146  CA  LEU    36      68.250  40.214  31.693  1.00 20.97           C  
ATOM  13147  C   LEU    36      69.421  41.199  31.776  1.00 20.61           C  
ATOM  13148  O   LEU    36      70.562  40.854  31.376  1.00 21.20           O  
ATOM  13149  CB  LEU    36      68.532  39.046  32.613  1.00 21.41           C  
ATOM  13150  CG  LEU    36      68.789  39.264  34.102  1.00 21.35           C  
ATOM  13151  CD1 LEU    36      67.603  39.957  34.807  1.00 23.14           C  
ATOM  13152  CD2 LEU    36      69.179  37.943  34.804  1.00 22.93           C  
ATOM  13153  N   TYR    37      69.112  42.393  32.255  1.00 19.52           N  
ATOM  13154  CA  TYR    37      70.093  43.483  32.452  1.00 19.94           C  
ATOM  13155  C   TYR    37      70.430  43.581  33.906  1.00 19.30           C  
ATOM  13156  O   TYR    37      69.576  43.954  34.684  1.00 18.49           O  
ATOM  13157  CB  TYR    37      69.527  44.816  32.021  1.00 21.62           C  
ATOM  13158  CG  TYR    37      69.633  45.044  30.561  1.00 24.97           C  
ATOM  13159  CD1 TYR    37      70.608  45.901  30.041  1.00 26.99           C  
ATOM  13160  CD2 TYR    37      68.798  44.384  29.690  1.00 26.43           C  
ATOM  13161  CE1 TYR    37      70.711  46.099  28.690  1.00 28.18           C  
ATOM  13162  CE2 TYR    37      68.902  44.583  28.309  1.00 27.61           C  
ATOM  13163  CZ  TYR    37      69.839  45.424  27.829  1.00 26.70           C  
ATOM  13164  OH  TYR    37      69.928  45.651  26.474  1.00 28.34           O  
ATOM  13165  N   VAL    38      71.680  43.277  34.255  1.00 18.12           N  
ATOM  13166  CA  VAL    38      72.116  43.284  35.635  1.00 17.38           C  
ATOM  13167  C   VAL    38      72.897  44.591  35.852  1.00 17.03           C  
ATOM  13168  O   VAL    38      73.783  44.948  35.040  1.00 16.35           O  
ATOM  13169  CB  VAL    38      72.994  42.065  35.962  1.00 17.22           C  
ATOM  13170  CG1 VAL    38      73.488  42.113  37.378  1.00 16.68           C  
ATOM  13171  CG2 VAL    38      72.228  40.778  35.704  1.00 19.02           C  
ATOM  13172  N   SER    39      72.542  45.277  36.935  1.00 16.21           N  
ATOM  13173  CA  SER    39      73.190  46.537  37.340  1.00 16.77           C  
ATOM  13174  C   SER    39      74.675  46.307  37.694  1.00 16.42           C  
ATOM  13175  O   SER    39      75.066  45.194  38.084  1.00 16.79           O  
ATOM  13176  CB  SER    39      72.491  47.130  38.559  1.00 16.39           C  
ATOM  13177  OG  SER    39      71.232  47.673  38.217  1.00 16.94           O  
ATOM  13178  N   GLY    40      75.498  47.355  37.547  1.00 16.71           N  
ATOM  13179  CA  GLY    40      76.913  47.251  37.877  1.00 16.17           C  
ATOM  13180  C   GLY    40      77.093  46.701  39.267  1.00 16.82           C  
ATOM  13181  O   GLY    40      76.479  47.191  40.216  1.00 16.75           O  
ATOM  13182  N   GLN    41      77.848  45.617  39.375  1.00 16.68           N  
ATOM  13183  CA  GLN    41      78.114  44.996  40.668  1.00 17.30           C  
ATOM  13184  C   GLN    41      79.538  45.360  41.116  1.00 16.88           C  
ATOM  13185  O   GLN    41      80.451  45.399  40.295  1.00 17.16           O  
ATOM  13186  CB  GLN    41      77.943  43.460  40.588  1.00 17.03           C  
ATOM  13187  CG  GLN    41      76.522  42.993  40.194  1.00 18.15           C  
ATOM  13188  CD  GLN    41      75.491  43.430  41.175  1.00 18.41           C  
ATOM  13189  OE1 GLN    41      75.559  43.081  42.360  1.00 18.42           O  
ATOM  13190  NE2 GLN    41      74.513  44.191  40.705  1.00 18.08           N  
ATOM  13191  N   LEU    42      79.675  45.523  42.425  1.00 18.51           N  
ATOM  13192  CA  LEU    42      80.922  45.823  43.142  1.00 19.27           C  
ATOM  13193  C   LEU    42      81.505  44.544  43.800  1.00 20.59           C  
ATOM  13194  O   LEU    42      80.809  43.508  43.933  1.00 20.90           O  
ATOM  13195  CB  LEU    42      80.648  46.893  44.195  1.00 19.83           C  
ATOM  13196  CG  LEU    42      80.007  48.193  43.701  1.00 20.09           C  
ATOM  13197  CD1 LEU    42      79.893  49.256  44.830  1.00 24.19           C  
ATOM  13198  CD2 LEU    42      80.773  48.751  42.474  1.00 20.92           C  
ATOM  13199  N   PRO    43      82.784  44.590  44.204  1.00 20.99           N  
ATOM  13200  CA  PRO    43      83.390  43.388  44.739  1.00 22.23           C  
ATOM  13201  C   PRO    43      82.987  43.165  46.205  1.00 23.30           C  
ATOM  13202  O   PRO    43      83.833  43.267  47.123  1.00 23.87           O  
ATOM  13203  CB  PRO    43      84.886  43.654  44.574  1.00 22.24           C  
ATOM  13204  CG  PRO    43      85.021  45.107  44.597  1.00 22.74           C  
ATOM  13205  CD  PRO    43      83.747  45.711  44.125  1.00 20.90           C  
ATOM  13206  N   MET    44      81.695  42.863  46.396  1.00 24.94           N  
ATOM  13207  CA  MET    44      81.111  42.668  47.725  1.00 26.76           C  
ATOM  13208  C   MET    44      81.416  41.303  48.250  1.00 27.78           C  
ATOM  13209  O   MET    44      81.216  40.309  47.554  1.00 26.94           O  
ATOM  13210  CB  MET    44      79.606  42.768  47.701  1.00 28.72           C  
ATOM  13211  CG  MET    44      79.087  44.003  47.142  1.00 34.04           C  
ATOM  13212  SD  MET    44      79.675  45.517  48.177  1.00 52.29          SE  
ATOM  13213  CE  MET    44      78.069  46.599  47.655  1.00 42.80           C  
ATOM  13214  N   GLU    45      81.866  41.277  49.503  1.00 28.96           N  
ATOM  13215  CA  GLU    45      82.155  40.050  50.199  1.00 30.57           C  
ATOM  13216  C   GLU    45      81.806  40.268  51.663  1.00 30.94           C  
ATOM  13217  O   GLU    45      82.239  41.230  52.276  1.00 29.35           O  
ATOM  13218  CB  GLU    45      83.615  39.704  50.030  1.00 31.01           C  
ATOM  13219  CG  GLU    45      83.899  38.254  50.285  1.00 32.83           C  
ATOM  13220  CD  GLU    45      85.369  37.906  50.169  1.00 34.03           C  
ATOM  13221  OE1 GLU    45      86.236  38.800  50.290  1.00 40.50           O  
ATOM  13222  OE2 GLU    45      85.665  36.719  49.956  1.00 39.11           O  
ATOM  13223  N   SER    46      80.980  39.381  52.208  1.00 32.41           N  
ATOM  13224  CA  SER    46      80.473  39.546  53.558  1.00 33.11           C  
ATOM  13225  C   SER    46      79.902  40.921  53.829  1.00 32.96           C  
ATOM  13226  O   SER    46      80.092  41.474  54.907  1.00 33.73           O  
ATOM  13227  CB  SER    46      81.576  39.245  54.550  1.00 33.85           C  
ATOM  13228  OG  SER    46      82.071  37.929  54.341  1.00 36.10           O  
ATOM  13229  N   GLY    47      79.201  41.482  52.851  1.00 32.72           N  
ATOM  13230  CA  GLY    47      78.556  42.782  53.023  1.00 32.20           C  
ATOM  13231  C   GLY    47      79.457  44.008  52.954  1.00 31.89           C  
ATOM  13232  O   GLY    47      78.988  45.134  53.165  1.00 32.53           O  
ATOM  13233  N   LYS    48      80.735  43.805  52.632  1.00 31.36           N  
ATOM  13234  CA  LYS    48      81.710  44.889  52.589  1.00 31.00           C  
ATOM  13235  C   LYS    48      82.340  44.938  51.204  1.00 29.19           C  
ATOM  13236  O   LYS    48      82.428  43.919  50.525  1.00 27.85           O  
ATOM  13237  CB  LYS    48      82.812  44.643  53.628  1.00 32.10           C  
ATOM  13238  CG  LYS    48      82.320  44.278  55.056  1.00 33.77           C  
ATOM  13239  CD  LYS    48      83.517  44.073  55.997  1.00 34.85           C  
ATOM  13240  CE  LYS    48      83.212  43.172  57.223  1.00 38.54           C  
ATOM  13241  NZ  LYS    48      82.691  41.784  56.927  1.00 41.89           N  
ATOM  13242  N   ILE    49      82.793  46.114  50.786  1.00 27.46           N  
ATOM  13243  CA  ILE    49      83.609  46.197  49.556  1.00 27.51           C  
ATOM  13244  C   ILE    49      84.994  45.615  49.890  1.00 26.44           C  
ATOM  13245  O   ILE    49      85.717  46.162  50.719  1.00 27.76           O  
ATOM  13246  CB  ILE    49      83.727  47.641  48.999  1.00 27.35           C  
ATOM  13247  CG1 ILE    49      82.339  48.250  48.725  1.00 28.61           C  
ATOM  13248  CG2 ILE    49      84.568  47.654  47.687  1.00 25.90           C  
ATOM  13249  CD1 ILE    49      81.640  47.702  47.484  1.00 29.88           C  
ATOM  13250  N   ALA    50      85.329  44.473  49.299  1.00 24.66           N  
ATOM  13251  CA  ALA    50      86.524  43.716  49.675  1.00 23.88           C  
ATOM  13252  C   ALA    50      87.844  44.216  49.077  1.00 22.88           C  
ATOM  13253  O   ALA    50      88.926  43.916  49.616  1.00 23.36           O  
ATOM  13254  CB  ALA    50      86.342  42.241  49.306  1.00 24.42           C  
ATOM  13255  N   VAL    51      87.773  44.926  47.958  1.00 20.81           N  
ATOM  13256  CA  VAL    51      88.968  45.381  47.241  1.00 19.75           C  
ATOM  13257  C   VAL    51      88.716  46.833  46.772  1.00 19.50           C  
ATOM  13258  O   VAL    51      87.820  47.092  45.950  1.00 18.36           O  
ATOM  13259  CB  VAL    51      89.299  44.506  46.034  1.00 19.25           C  
ATOM  13260  CG1 VAL    51      90.619  44.969  45.369  1.00 17.95           C  
ATOM  13261  CG2 VAL    51      89.337  42.997  46.410  1.00 19.82           C  
ATOM  13262  N   THR    52      89.518  47.761  47.290  1.00 18.83           N  
ATOM  13263  CA  THR    52      89.331  49.192  47.048  1.00 18.76           C  
ATOM  13264  C   THR    52      90.623  49.886  46.577  1.00 17.15           C  
ATOM  13265  O   THR    52      91.752  49.426  46.833  1.00 18.57           O  
ATOM  13266  CB  THR    52      88.801  49.933  48.274  1.00 19.87           C  
ATOM  13267  OG1 THR    52      89.751  49.836  49.341  1.00 20.52           O  
ATOM  13268  CG2 THR    52      87.440  49.358  48.732  1.00 20.18           C  
ATOM  13269  N   GLY    53      90.427  50.980  45.853  1.00 16.63           N  
ATOM  13270  CA  GLY    53      91.523  51.794  45.378  1.00 15.81           C  
ATOM  13271  C   GLY    53      91.866  51.490  43.935  1.00 16.34           C  
ATOM  13272  O   GLY    53      91.220  50.657  43.238  1.00 16.41           O  
ATOM  13273  N   LEU    54      92.852  52.232  43.462  1.00 14.89           N  
ATOM  13274  CA  LEU    54      93.241  52.192  42.046  1.00 15.09           C  
ATOM  13275  C   LEU    54      94.198  51.052  41.691  1.00 14.82           C  
ATOM  13276  O   LEU    54      95.217  50.830  42.343  1.00 15.74           O  
ATOM  13277  CB  LEU    54      93.870  53.539  41.641  1.00 14.99           C  
ATOM  13278  CG  LEU    54      93.016  54.794  41.893  1.00 16.43           C  
ATOM  13279  CD1 LEU    54      93.853  56.129  41.629  1.00 14.43           C  
ATOM  13280  CD2 LEU    54      91.711  54.771  41.099  1.00 18.58           C  
ATOM  13281  N   VAL    55      93.881  50.333  40.618  1.00 15.10           N  
ATOM  13282  CA  VAL    55      94.798  49.303  40.117  1.00 15.22           C  
ATOM  13283  C   VAL    55      96.009  50.038  39.509  1.00 15.52           C  
ATOM  13284  O   VAL    55      95.867  51.023  38.743  1.00 15.49           O  
ATOM  13285  CB  VAL    55      94.147  48.295  39.122  1.00 15.34           C  
ATOM  13286  CG1 VAL    55      95.143  47.202  38.776  1.00 16.34           C  
ATOM  13287  CG2 VAL    55      92.798  47.747  39.668  1.00 14.16           C  
ATOM  13288  N   GLY    56      97.188  49.598  39.915  1.00 15.44           N  
ATOM  13289  CA  GLY    56      98.449  50.244  39.536  1.00 16.28           C  
ATOM  13290  C   GLY    56      98.942  51.219  40.587  1.00 16.32           C  
ATOM  13291  O   GLY    56     100.026  51.780  40.450  1.00 16.29           O  
ATOM  13292  N   ARG    57      98.166  51.390  41.665  1.00 16.32           N  
ATOM  13293  CA  ARG    57      98.571  52.249  42.778  1.00 16.70           C  
ATOM  13294  C   ARG    57      98.304  51.594  44.106  1.00 16.10           C  
ATOM  13295  O   ARG    57      99.218  51.357  44.886  1.00 17.03           O  
ATOM  13296  CB  ARG    57      97.873  53.603  42.715  1.00 15.72           C  
ATOM  13297  CG  ARG    57      98.244  54.497  43.885  1.00 16.84           C  
ATOM  13298  CD  ARG    57      97.659  55.894  43.877  1.00 15.89           C  
ATOM  13299  NE  ARG    57      98.101  56.563  45.097  1.00 15.63           N  
ATOM  13300  CZ  ARG    57      99.287  57.153  45.256  1.00 16.91           C  
ATOM  13301  NH1 ARG    57     100.160  57.249  44.259  1.00 13.83           N  
ATOM  13302  NH2 ARG    57      99.613  57.651  46.435  1.00 15.00           N  
ATOM  13303  N   ASP    58      97.051  51.278  44.341  1.00 16.23           N  
ATOM  13304  CA  ASP    58      96.620  50.693  45.608  1.00 16.54           C  
ATOM  13305  C   ASP    58      96.524  49.169  45.557  1.00 16.62           C  
ATOM  13306  O   ASP    58      96.664  48.506  46.600  1.00 16.58           O  
ATOM  13307  CB  ASP    58      95.275  51.259  45.998  1.00 16.42           C  
ATOM  13308  CG  ASP    58      95.312  52.769  46.142  1.00 17.20           C  
ATOM  13309  OD1 ASP    58      96.112  53.243  46.982  1.00 19.65           O  
ATOM  13310  OD2 ASP    58      94.531  53.456  45.451  1.00 18.16           O  
ATOM  13311  N   VAL    59      96.242  48.632  44.377  1.00 16.45           N  
ATOM  13312  CA  VAL    59      96.058  47.197  44.212  1.00 17.77           C  
ATOM  13313  C   VAL    59      96.785  46.737  42.956  1.00 17.83           C  
ATOM  13314  O   VAL    59      96.926  47.493  41.987  1.00 17.33           O  
ATOM  13315  CB  VAL    59      94.554  46.767  44.189  1.00 18.87           C  
ATOM  13316  CG1 VAL    59      93.778  47.334  45.449  1.00 21.82           C  
ATOM  13317  CG2 VAL    59      93.896  47.197  42.965  1.00 21.44           C  
ATOM  13318  N   ASP    60      97.285  45.515  43.025  1.00 18.74           N  
ATOM  13319  CA  ASP    60      97.964  44.879  41.909  1.00 19.34           C  
ATOM  13320  C   ASP    60      96.992  44.080  41.043  1.00 19.48           C  
ATOM  13321  O   ASP    60      95.805  44.037  41.332  1.00 19.40           O  
ATOM  13322  CB  ASP    60      99.147  44.040  42.405  1.00 20.89           C  
ATOM  13323  CG  ASP    60      98.757  42.848  43.254  1.00 21.21           C  
ATOM  13324  OD1 ASP    60      97.589  42.484  43.394  1.00 22.81           O  
ATOM  13325  OD2 ASP    60      99.713  42.231  43.792  1.00 30.25           O  
ATOM  13326  N   VAL    61      97.486  43.487  39.967  1.00 18.59           N  
ATOM  13327  CA  VAL    61      96.614  42.760  39.045  1.00 19.30           C  
ATOM  13328  C   VAL    61      95.938  41.568  39.757  1.00 18.76           C  
ATOM  13329  O   VAL    61      94.732  41.355  39.623  1.00 19.22           O  
ATOM  13330  CB  VAL    61      97.352  42.330  37.761  1.00 19.44           C  
ATOM  13331  CG1 VAL    61      96.504  41.337  36.953  1.00 20.46           C  
ATOM  13332  CG2 VAL    61      97.699  43.573  36.911  1.00 19.62           C  
ATOM  13333  N   ALA    62      96.695  40.801  40.523  1.00 18.89           N  
ATOM  13334  CA  ALA    62      96.120  39.649  41.215  1.00 19.10           C  
ATOM  13335  C   ALA    62      94.973  40.048  42.139  1.00 19.10           C  
ATOM  13336  O   ALA    62      93.905  39.417  42.132  1.00 18.61           O  
ATOM  13337  CB  ALA    62      97.209  38.899  42.012  1.00 19.82           C  
ATOM  13338  N   SER    63      95.178  41.088  42.960  1.00 18.52           N  
ATOM  13339  CA  SER    63      94.126  41.541  43.854  1.00 19.00           C  
ATOM  13340  C   SER    63      92.917  42.037  43.057  1.00 18.56           C  
ATOM  13341  O   SER    63      91.790  41.803  43.432  1.00 18.58           O  
ATOM  13342  CB  SER    63      94.622  42.645  44.745  1.00 19.24           C  
ATOM  13343  OG  SER    63      95.617  42.148  45.586  1.00 20.64           O  
ATOM  13344  N   ALA    64      93.164  42.778  41.983  1.00 18.32           N  
ATOM  13345  CA  ALA    64      92.088  43.282  41.124  1.00 18.22           C  
ATOM  13346  C   ALA    64      91.295  42.123  40.447  1.00 17.22           C  
ATOM  13347  O   ALA    64      90.093  42.203  40.247  1.00 15.74           O  
ATOM  13348  CB  ALA    64      92.667  44.231  40.071  1.00 18.00           C  
ATOM  13349  N   GLN    65      92.005  41.065  40.095  1.00 18.13           N  
ATOM  13350  CA  GLN    65      91.374  39.867  39.554  1.00 19.19           C  
ATOM  13351  C   GLN    65      90.392  39.274  40.566  1.00 19.55           C  
ATOM  13352  O   GLN    65      89.268  38.896  40.194  1.00 19.43           O  
ATOM  13353  CB  GLN    65      92.424  38.845  39.097  1.00 18.99           C  
ATOM  13354  CG  GLN    65      93.078  39.208  37.762  1.00 19.83           C  
ATOM  13355  CD  GLN    65      94.275  38.344  37.421  1.00 19.98           C  
ATOM  13356  OE1 GLN    65      94.942  37.792  38.312  1.00 23.49           O  
ATOM  13357  NE2 GLN    65      94.541  38.184  36.114  1.00 20.84           N  
ATOM  13358  N   ARG    66      90.789  39.194  41.835  1.00 20.27           N  
ATOM  13359  CA  ARG    66      89.877  38.774  42.884  1.00 19.80           C  
ATOM  13360  C   ARG    66      88.688  39.723  43.034  1.00 19.12           C  
ATOM  13361  O   ARG    66      87.559  39.289  43.213  1.00 18.72           O  
ATOM  13362  CB  ARG    66      90.597  38.676  44.215  1.00 21.46           C  
ATOM  13363  CG  ARG    66      89.674  38.205  45.361  1.00 25.65           C  
ATOM  13364  CD  ARG    66      89.298  36.727  45.200  1.00 36.25           C  
ATOM  13365  NE  ARG    66      90.392  35.890  45.691  1.00 41.73           N  
ATOM  13366  CZ  ARG    66      90.704  34.644  45.300  1.00 44.24           C  
ATOM  13367  NH1 ARG    66      90.018  33.988  44.357  1.00 45.76           N  
ATOM  13368  NH2 ARG    66      91.746  34.039  45.876  1.00 45.36           N  
ATOM  13369  N   ALA    67      88.915  41.023  42.911  1.00 18.19           N  
ATOM  13370  CA  ALA    67      87.776  41.975  42.854  1.00 17.76           C  
ATOM  13371  C   ALA    67      86.826  41.622  41.708  1.00 17.38           C  
ATOM  13372  O   ALA    67      85.599  41.617  41.892  1.00 17.68           O  
ATOM  13373  CB  ALA    67      88.270  43.434  42.700  1.00 18.27           C  
ATOM  13374  N   ALA    68      87.399  41.298  40.541  1.00 16.79           N  
ATOM  13375  CA  ALA    68      86.601  40.982  39.365  1.00 17.36           C  
ATOM  13376  C   ALA    68      85.816  39.681  39.613  1.00 17.31           C  
ATOM  13377  O   ALA    68      84.630  39.612  39.301  1.00 17.42           O  
ATOM  13378  CB  ALA    68      87.459  40.881  38.124  1.00 16.52           C  
ATOM  13379  N   GLU    69      86.469  38.683  40.196  1.00 17.93           N  
ATOM  13380  CA  GLU    69      85.784  37.441  40.576  1.00 18.71           C  
ATOM  13381  C   GLU    69      84.583  37.751  41.484  1.00 18.93           C  
ATOM  13382  O   GLU    69      83.471  37.242  41.241  1.00 18.31           O  
ATOM  13383  CB  GLU    69      86.757  36.477  41.251  1.00 19.08           C  
ATOM  13384  CG  GLU    69      87.806  35.902  40.322  1.00 21.15           C  
ATOM  13385  CD  GLU    69      88.858  35.066  41.051  1.00 22.14           C  
ATOM  13386  OE1 GLU    69      89.114  35.313  42.248  1.00 26.87           O  
ATOM  13387  OE2 GLU    69      89.424  34.144  40.439  1.00 27.07           O  
ATOM  13388  N   LEU    70      84.785  38.602  42.502  1.00 18.58           N  
ATOM  13389  CA  LEU    70      83.696  38.968  43.407  1.00 18.83           C  
ATOM  13390  C   LEU    70      82.568  39.708  42.680  1.00 19.23           C  
ATOM  13391  O   LEU    70      81.381  39.501  42.991  1.00 19.11           O  
ATOM  13392  CB  LEU    70      84.211  39.780  44.620  1.00 19.41           C  
ATOM  13393  CG  LEU    70      85.076  39.021  45.631  1.00 19.00           C  
ATOM  13394  CD1 LEU    70      85.801  39.978  46.576  1.00 19.47           C  
ATOM  13395  CD2 LEU    70      84.185  37.995  46.377  1.00 21.35           C  
ATOM  13396  N   CYS    71      82.915  40.595  41.740  1.00 18.39           N  
ATOM  13397  CA  CYS    71      81.884  41.296  40.973  1.00 18.21           C  
ATOM  13398  C   CYS    71      81.020  40.255  40.259  1.00 18.12           C  
ATOM  13399  O   CYS    71      79.783  40.380  40.219  1.00 18.48           O  
ATOM  13400  CB  CYS    71      82.523  42.263  39.959  1.00 18.28           C  
ATOM  13401  SG  CYS    71      83.354  43.707  40.748  1.00 17.98           S  
ATOM  13402  N   ALA    72      81.702  39.258  39.697  1.00 18.14           N  
ATOM  13403  CA  ALA    72      81.087  38.152  38.925  1.00 18.89           C  
ATOM  13404  C   ALA    72      80.191  37.309  39.820  1.00 19.05           C  
ATOM  13405  O   ALA    72      79.114  36.921  39.394  1.00 18.95           O  
ATOM  13406  CB  ALA    72      82.163  37.286  38.228  1.00 19.28           C  
ATOM  13407  N   VAL    73      80.632  37.045  41.048  1.00 19.61           N  
ATOM  13408  CA  VAL    73      79.815  36.298  42.031  1.00 20.01           C  
ATOM  13409  C   VAL    73      78.521  37.045  42.369  1.00 20.13           C  
ATOM  13410  O   VAL    73      77.428  36.449  42.460  1.00 20.48           O  
ATOM  13411  CB  VAL    73      80.633  36.004  43.330  1.00 20.82           C  
ATOM  13412  CG1 VAL    73      79.714  35.513  44.502  1.00 21.02           C  
ATOM  13413  CG2 VAL    73      81.772  35.052  43.029  1.00 19.80           C  
ATOM  13414  N   ASN    74      78.651  38.353  42.525  1.00 20.11           N  
ATOM  13415  CA  ASN    74      77.538  39.245  42.782  1.00 19.82           C  
ATOM  13416  C   ASN    74      76.578  39.319  41.600  1.00 19.58           C  
ATOM  13417  O   ASN    74      75.340  39.315  41.782  1.00 19.11           O  
ATOM  13418  CB  ASN    74      78.047  40.618  43.245  1.00 21.09           C  
ATOM  13419  CG  ASN    74      78.475  40.618  44.708  1.00 20.96           C  
ATOM  13420  OD1 ASN    74      79.667  40.497  45.044  1.00 25.84           O  
ATOM  13421  ND2 ASN    74      77.513  40.757  45.583  1.00 21.36           N  
ATOM  13422  N   ILE    75      77.117  39.332  40.385  1.00 19.22           N  
ATOM  13423  CA  ILE    75      76.266  39.262  39.188  1.00 19.73           C  
ATOM  13424  C   ILE    75      75.449  37.952  39.240  1.00 19.91           C  
ATOM  13425  O   ILE    75      74.232  37.959  39.042  1.00 21.28           O  
ATOM  13426  CB  ILE    75      77.082  39.318  37.856  1.00 20.26           C  
ATOM  13427  CG1 ILE    75      77.721  40.707  37.642  1.00 20.27           C  
ATOM  13428  CG2 ILE    75      76.193  38.957  36.665  1.00 18.77           C  
ATOM  13429  CD1 ILE    75      78.803  40.768  36.489  1.00 19.64           C  
ATOM  13430  N   LEU    76      76.126  36.852  39.510  1.00 20.16           N  
ATOM  13431  CA  LEU    76      75.459  35.515  39.533  1.00 20.33           C  
ATOM  13432  C   LEU    76      74.366  35.460  40.615  1.00 20.78           C  
ATOM  13433  O   LEU    76      73.297  34.907  40.379  1.00 21.42           O  
ATOM  13434  CB  LEU    76      76.486  34.394  39.689  1.00 20.53           C  
ATOM  13435  CG  LEU    76      77.372  34.118  38.484  1.00 20.87           C  
ATOM  13436  CD1 LEU    76      78.458  33.098  38.825  1.00 22.97           C  
ATOM  13437  CD2 LEU    76      76.544  33.679  37.260  1.00 23.02           C  
ATOM  13438  N   ALA    77      74.614  36.063  41.784  1.00 21.14           N  
ATOM  13439  CA  ALA    77      73.597  36.165  42.832  1.00 21.04           C  
ATOM  13440  C   ALA    77      72.361  36.891  42.300  1.00 21.95           C  
ATOM  13441  O   ALA    77      71.217  36.466  42.522  1.00 21.90           O  
ATOM  13442  CB  ALA    77      74.162  36.883  44.086  1.00 20.99           C  
ATOM  13443  N   GLN    78      72.587  37.993  41.581  1.00 21.45           N  
ATOM  13444  CA  GLN    78      71.473  38.745  41.023  1.00 22.10           C  
ATOM  13445  C   GLN    78      70.713  37.927  39.965  1.00 21.79           C  
ATOM  13446  O   GLN    78      69.486  37.929  39.936  1.00 22.55           O  
ATOM  13447  CB  GLN    78      71.950  40.077  40.422  1.00 22.09           C  
ATOM  13448  CG  GLN    78      72.508  41.105  41.436  1.00 24.22           C  
ATOM  13449  CD  GLN    78      71.567  41.457  42.585  1.00 27.40           C  
ATOM  13450  OE1 GLN    78      70.352  41.227  42.543  1.00 31.81           O  
ATOM  13451  NE2 GLN    78      72.141  42.054  43.621  1.00 33.24           N  
ATOM  13452  N   VAL    79      71.444  37.235  39.103  1.00 22.19           N  
ATOM  13453  CA  VAL    79      70.817  36.392  38.091  1.00 22.65           C  
ATOM  13454  C   VAL    79      69.980  35.285  38.732  1.00 23.28           C  
ATOM  13455  O   VAL    79      68.872  35.003  38.273  1.00 23.03           O  
ATOM  13456  CB  VAL    79      71.835  35.795  37.119  1.00 23.12           C  
ATOM  13457  CG1 VAL    79      71.136  34.895  36.134  1.00 23.37           C  
ATOM  13458  CG2 VAL    79      72.623  36.932  36.374  1.00 22.03           C  
ATOM  13459  N   LYS    80      70.507  34.673  39.779  1.00 23.69           N  
ATOM  13460  CA  LYS    80      69.799  33.611  40.478  1.00 24.34           C  
ATOM  13461  C   LYS    80      68.501  34.164  41.053  1.00 25.02           C  
ATOM  13462  O   LYS    80      67.442  33.517  40.935  1.00 25.88           O  
ATOM  13463  CB  LYS    80      70.672  33.018  41.576  1.00 24.54           C  
ATOM  13464  CG  LYS    80      69.980  31.893  42.358  1.00 24.65           C  
ATOM  13465  CD  LYS    80      70.809  31.421  43.510  1.00 25.01           C  
ATOM  13466  CE  LYS    80      69.995  30.487  44.426  1.00 26.39           C  
ATOM  13467  NZ  LYS    80      70.884  29.674  45.302  1.00 27.82           N  
ATOM  13468  N   ALA    81      68.564  35.351  41.664  1.00 25.16           N  
ATOM  13469  CA  ALA    81      67.346  36.048  42.148  1.00 25.31           C  
ATOM  13470  C   ALA    81      66.342  36.341  41.017  1.00 25.95           C  
ATOM  13471  O   ALA    81      65.141  36.042  41.158  1.00 25.62           O  
ATOM  13472  CB  ALA    81      67.697  37.329  42.899  1.00 25.25           C  
ATOM  13473  N   ALA    82      66.827  36.906  39.908  1.00 25.86           N  
ATOM  13474  CA  ALA    82      66.008  37.146  38.720  1.00 26.45           C  
ATOM  13475  C   ALA    82      65.358  35.846  38.201  1.00 26.96           C  
ATOM  13476  O   ALA    82      64.253  35.900  37.645  1.00 27.66           O  
ATOM  13477  CB  ALA    82      66.813  37.773  37.611  1.00 25.68           C  
ATOM  13478  N   LEU    83      66.034  34.712  38.370  1.00 27.25           N  
ATOM  13479  CA  LEU    83      65.568  33.458  37.785  1.00 28.53           C  
ATOM  13480  C   LEU    83      64.892  32.546  38.810  1.00 29.77           C  
ATOM  13481  O   LEU    83      64.768  31.322  38.610  1.00 29.23           O  
ATOM  13482  CB  LEU    83      66.721  32.761  37.070  1.00 28.68           C  
ATOM  13483  CG  LEU    83      67.336  33.509  35.875  1.00 27.34           C  
ATOM  13484  CD1 LEU    83      68.442  32.677  35.265  1.00 27.66           C  
ATOM  13485  CD2 LEU    83      66.303  33.910  34.809  1.00 26.22           C  
ATOM  13486  N   ASN    84      64.439  33.159  39.895  1.00 30.56           N  
ATOM  13487  CA  ASN    84      63.729  32.463  40.972  1.00 32.17           C  
ATOM  13488  C   ASN    84      64.473  31.244  41.527  1.00 32.90           C  
ATOM  13489  O   ASN    84      63.869  30.207  41.867  1.00 33.06           O  
ATOM  13490  CB  ASN    84      62.309  32.124  40.501  1.00 32.69           C  
ATOM  13491  CG  ASN    84      61.490  33.372  40.221  1.00 35.55           C  
ATOM  13492  OD1 ASN    84      60.912  33.525  39.134  1.00 41.64           O  
ATOM  13493  ND2 ASN    84      61.455  34.290  41.192  1.00 39.24           N  
ATOM  13494  N   GLY    85      65.789  31.382  41.634  1.00 33.09           N  
ATOM  13495  CA  GLY    85      66.645  30.371  42.227  1.00 33.47           C  
ATOM  13496  C   GLY    85      67.306  29.487  41.196  1.00 34.39           C  
ATOM  13497  O   GLY    85      68.029  28.555  41.537  1.00 35.05           O  
ATOM  13498  N   ASP    86      67.097  29.793  39.927  1.00 35.62           N  
ATOM  13499  CA  ASP    86      67.425  28.850  38.869  1.00 36.87           C  
ATOM  13500  C   ASP    86      68.531  29.305  37.873  1.00 36.44           C  
ATOM  13501  O   ASP    86      68.241  29.668  36.744  1.00 36.29           O  
ATOM  13502  CB  ASP    86      66.107  28.532  38.145  1.00 37.68           C  
ATOM  13503  CG  ASP    86      66.135  27.208  37.412  1.00 40.66           C  
ATOM  13504  OD1 ASP    86      67.157  26.494  37.471  1.00 44.08           O  
ATOM  13505  OD2 ASP    86      65.116  26.881  36.763  1.00 45.09           O  
ATOM  13506  N   LEU    87      69.796  29.225  38.285  1.00 36.56           N  
ATOM  13507  CA  LEU    87      70.940  29.570  37.412  1.00 36.56           C  
ATOM  13508  C   LEU    87      71.040  28.748  36.105  1.00 36.34           C  
ATOM  13509  O   LEU    87      71.796  29.096  35.196  1.00 35.79           O  
ATOM  13510  CB  LEU    87      72.272  29.500  38.182  1.00 36.86           C  
ATOM  13511  CG  LEU    87      72.623  30.693  39.091  1.00 36.88           C  
ATOM  13512  CD1 LEU    87      73.967  30.459  39.777  1.00 36.37           C  
ATOM  13513  CD2 LEU    87      72.640  32.048  38.326  1.00 36.15           C  
ATOM  13514  N   SER    88      70.275  27.665  36.024  1.00 36.37           N  
ATOM  13515  CA  SER    88      70.251  26.801  34.847  1.00 35.94           C  
ATOM  13516  C   SER    88      69.374  27.362  33.727  1.00 35.17           C  
ATOM  13517  O   SER    88      69.432  26.891  32.595  1.00 35.24           O  
ATOM  13518  CB  SER    88      69.754  25.418  35.260  1.00 36.16           C  
ATOM  13519  OG  SER    88      68.473  25.510  35.846  1.00 37.19           O  
ATOM  13520  N   LYS    89      68.583  28.382  34.056  1.00 34.43           N  
ATOM  13521  CA  LYS    89      67.792  29.109  33.080  1.00 33.77           C  
ATOM  13522  C   LYS    89      68.571  30.213  32.358  1.00 32.24           C  
ATOM  13523  O   LYS    89      67.994  30.935  31.545  1.00 32.12           O  
ATOM  13524  CB  LYS    89      66.543  29.690  33.739  1.00 34.20           C  
ATOM  13525  CG  LYS    89      65.489  28.606  34.078  1.00 35.37           C  
ATOM  13526  CD  LYS    89      64.197  29.224  34.590  1.00 36.03           C  
ATOM  13527  CE  LYS    89      63.040  28.177  34.705  1.00 37.98           C  
ATOM  13528  NZ  LYS    89      62.891  27.610  36.082  1.00 39.34           N  
ATOM  13529  N   ILE    90      69.865  30.341  32.642  1.00 30.91           N  
ATOM  13530  CA  ILE    90      70.740  31.151  31.793  1.00 30.51           C  
ATOM  13531  C   ILE    90      70.915  30.437  30.434  1.00 30.01           C  
ATOM  13532  O   ILE    90      71.329  29.275  30.387  1.00 31.25           O  
ATOM  13533  CB  ILE    90      72.141  31.392  32.445  1.00 30.19           C  
ATOM  13534  CG1 ILE    90      72.004  32.133  33.787  1.00 29.03           C  
ATOM  13535  CG2 ILE    90      73.086  32.137  31.461  1.00 29.03           C  
ATOM  13536  CD1 ILE    90      73.322  32.266  34.564  1.00 30.48           C  
ATOM  13537  N   ARG    91      70.602  31.114  29.336  1.00 28.51           N  
ATOM  13538  CA  ARG    91      70.882  30.563  28.010  1.00 29.50           C  
ATOM  13539  C   ARG    91      72.270  30.959  27.522  1.00 27.41           C  
ATOM  13540  O   ARG    91      73.007  30.149  26.963  1.00 25.76           O  
ATOM  13541  CB  ARG    91      69.802  30.984  27.021  1.00 29.42           C  
ATOM  13542  CG  ARG    91      68.469  30.319  27.356  1.00 33.12           C  
ATOM  13543  CD  ARG    91      67.261  30.999  26.705  1.00 35.92           C  
ATOM  13544  NE  ARG    91      67.355  31.013  25.251  1.00 43.12           N  
ATOM  13545  CZ  ARG    91      67.218  29.942  24.465  1.00 46.08           C  
ATOM  13546  NH1 ARG    91      66.945  28.734  24.973  1.00 47.97           N  
ATOM  13547  NH2 ARG    91      67.346  30.092  23.143  1.00 46.98           N  
ATOM  13548  N   ARG    92      72.634  32.203  27.780  1.00 25.79           N  
ATOM  13549  CA  ARG    92      73.916  32.748  27.347  1.00 25.72           C  
ATOM  13550  C   ARG    92      74.201  34.042  28.094  1.00 23.76           C  
ATOM  13551  O   ARG    92      73.289  34.873  28.245  1.00 22.58           O  
ATOM  13552  CB  ARG    92      73.835  33.054  25.862  1.00 26.82           C  
ATOM  13553  CG  ARG    92      74.885  33.989  25.316  1.00 31.69           C  
ATOM  13554  CD  ARG    92      75.607  33.399  24.154  1.00 37.13           C  
ATOM  13555  NE  ARG    92      76.890  32.858  24.594  1.00 40.03           N  
ATOM  13556  CZ  ARG    92      77.376  31.648  24.306  1.00 42.08           C  
ATOM  13557  NH1 ARG    92      76.702  30.777  23.546  1.00 43.85           N  
ATOM  13558  NH2 ARG    92      78.569  31.303  24.771  1.00 40.04           N  
ATOM  13559  N   VAL    93      75.433  34.184  28.586  1.00 21.68           N  
ATOM  13560  CA  VAL    93      75.905  35.473  29.055  1.00 20.41           C  
ATOM  13561  C   VAL    93      76.303  36.221  27.782  1.00 20.28           C  
ATOM  13562  O   VAL    93      77.259  35.856  27.069  1.00 21.18           O  
ATOM  13563  CB  VAL    93      77.080  35.374  30.075  1.00 20.10           C  
ATOM  13564  CG1 VAL    93      77.543  36.778  30.511  1.00 20.34           C  
ATOM  13565  CG2 VAL    93      76.685  34.513  31.307  1.00 20.35           C  
ATOM  13566  N   ILE    94      75.543  37.252  27.472  1.00 19.62           N  
ATOM  13567  CA  ILE    94      75.707  37.970  26.218  1.00 19.82           C  
ATOM  13568  C   ILE    94      76.892  38.962  26.232  1.00 19.77           C  
ATOM  13569  O   ILE    94      77.686  39.016  25.272  1.00 19.63           O  
ATOM  13570  CB  ILE    94      74.405  38.688  25.859  1.00 20.18           C  
ATOM  13571  CG1 ILE    94      73.341  37.638  25.511  1.00 21.26           C  
ATOM  13572  CG2 ILE    94      74.574  39.644  24.658  1.00 20.74           C  
ATOM  13573  CD1 ILE    94      73.669  36.882  24.212  1.00 25.02           C  
ATOM  13574  N   LYS    95      77.009  39.701  27.338  1.00 19.20           N  
ATOM  13575  CA  LYS    95      77.963  40.817  27.444  1.00 18.28           C  
ATOM  13576  C   LYS    95      78.268  41.140  28.913  1.00 18.11           C  
ATOM  13577  O   LYS    95      77.377  41.166  29.740  1.00 17.68           O  
ATOM  13578  CB  LYS    95      77.362  42.031  26.756  1.00 18.02           C  
ATOM  13579  CG  LYS    95      78.180  43.334  26.821  1.00 18.92           C  
ATOM  13580  CD  LYS    95      79.388  43.233  25.899  1.00 17.97           C  
ATOM  13581  CE  LYS    95      80.246  44.514  25.891  1.00 19.41           C  
ATOM  13582  NZ  LYS    95      79.470  45.692  25.394  1.00 20.19           N  
ATOM  13583  N   LEU    96      79.537  41.389  29.220  1.00 18.19           N  
ATOM  13584  CA  LEU    96      79.951  41.957  30.513  1.00 17.80           C  
ATOM  13585  C   LEU    96      80.658  43.271  30.202  1.00 17.10           C  
ATOM  13586  O   LEU    96      81.468  43.325  29.258  1.00 17.15           O  
ATOM  13587  CB  LEU    96      80.942  41.045  31.244  1.00 18.83           C  
ATOM  13588  CG  LEU    96      80.585  39.667  31.800  1.00 20.85           C  
ATOM  13589  CD1 LEU    96      81.711  39.277  32.729  1.00 22.50           C  
ATOM  13590  CD2 LEU    96      79.206  39.674  32.520  1.00 21.93           C  
ATOM  13591  N   ASN    97      80.329  44.321  30.946  1.00 16.61           N  
ATOM  13592  CA  ASN    97      81.130  45.529  30.906  1.00 16.14           C  
ATOM  13593  C   ASN    97      81.933  45.623  32.183  1.00 15.02           C  
ATOM  13594  O   ASN    97      81.375  45.796  33.268  1.00 14.66           O  
ATOM  13595  CB  ASN    97      80.289  46.767  30.662  1.00 16.88           C  
ATOM  13596  CG  ASN    97      79.486  46.689  29.385  1.00 18.53           C  
ATOM  13597  OD1 ASN    97      78.257  46.535  29.404  1.00 23.42           O  
ATOM  13598  ND2 ASN    97      80.171  46.786  28.273  1.00 15.75           N  
ATOM  13599  N   GLY    98      83.256  45.563  32.012  1.00 14.82           N  
ATOM  13600  CA  GLY    98      84.185  45.561  33.119  1.00 15.02           C  
ATOM  13601  C   GLY    98      84.852  46.915  33.285  1.00 15.44           C  
ATOM  13602  O   GLY    98      85.617  47.349  32.412  1.00 16.65           O  
ATOM  13603  N   PHE    99      84.542  47.593  34.386  1.00 15.14           N  
ATOM  13604  CA  PHE    99      85.102  48.870  34.692  1.00 14.44           C  
ATOM  13605  C   PHE    99      86.167  48.697  35.768  1.00 14.30           C  
ATOM  13606  O   PHE    99      85.866  48.199  36.872  1.00 14.95           O  
ATOM  13607  CB  PHE    99      83.973  49.765  35.171  1.00 15.41           C  
ATOM  13608  CG  PHE    99      82.790  49.765  34.262  1.00 16.64           C  
ATOM  13609  CD1 PHE    99      82.914  50.201  32.953  1.00 22.14           C  
ATOM  13610  CD2 PHE    99      81.554  49.354  34.715  1.00 19.51           C  
ATOM  13611  CE1 PHE    99      81.807  50.224  32.110  1.00 22.73           C  
ATOM  13612  CE2 PHE    99      80.456  49.391  33.888  1.00 20.40           C  
ATOM  13613  CZ  PHE    99      80.577  49.822  32.604  1.00 19.17           C  
ATOM  13614  N   VAL   100      87.401  49.093  35.463  1.00 12.97           N  
ATOM  13615  CA  VAL   100      88.533  48.945  36.395  1.00 13.47           C  
ATOM  13616  C   VAL   100      89.113  50.315  36.797  1.00 13.53           C  
ATOM  13617  O   VAL   100      89.639  51.033  35.962  1.00 13.48           O  
ATOM  13618  CB  VAL   100      89.674  48.129  35.768  1.00 12.63           C  
ATOM  13619  CG1 VAL   100      90.810  47.914  36.819  1.00 13.13           C  
ATOM  13620  CG2 VAL   100      89.172  46.827  35.121  1.00 14.55           C  
ATOM  13621  N   ALA   101      89.018  50.651  38.073  1.00 13.61           N  
ATOM  13622  CA  ALA   101      89.573  51.922  38.591  1.00 13.39           C  
ATOM  13623  C   ALA   101      91.080  51.820  38.411  1.00 13.93           C  
ATOM  13624  O   ALA   101      91.703  50.866  38.925  1.00 12.78           O  
ATOM  13625  CB  ALA   101      89.195  52.132  40.064  1.00 13.54           C  
ATOM  13626  N   SER   102      91.652  52.751  37.644  1.00 13.96           N  
ATOM  13627  CA  SER   102      93.014  52.597  37.122  1.00 13.76           C  
ATOM  13628  C   SER   102      93.783  53.879  37.237  1.00 13.85           C  
ATOM  13629  O   SER   102      93.239  54.942  37.020  1.00 13.85           O  
ATOM  13630  CB  SER   102      92.952  52.234  35.615  1.00 13.46           C  
ATOM  13631  OG  SER   102      92.318  50.995  35.346  1.00 15.64           O  
ATOM  13632  N   VAL   103      95.081  53.795  37.542  1.00 14.08           N  
ATOM  13633  CA  VAL   103      95.940  54.957  37.235  1.00 13.49           C  
ATOM  13634  C   VAL   103      96.211  54.943  35.728  1.00 14.32           C  
ATOM  13635  O   VAL   103      96.076  53.907  35.086  1.00 14.13           O  
ATOM  13636  CB  VAL   103      97.260  54.995  38.049  1.00 13.45           C  
ATOM  13637  CG1 VAL   103      96.964  55.212  39.528  1.00 13.30           C  
ATOM  13638  CG2 VAL   103      98.085  53.757  37.857  1.00 14.31           C  
ATOM  13639  N   PRO   104      96.528  56.120  35.158  1.00 14.49           N  
ATOM  13640  CA  PRO   104      96.705  56.218  33.710  1.00 15.18           C  
ATOM  13641  C   PRO   104      97.820  55.375  33.100  1.00 15.45           C  
ATOM  13642  O   PRO   104      97.786  55.109  31.890  1.00 17.16           O  
ATOM  13643  CB  PRO   104      96.935  57.712  33.487  1.00 15.35           C  
ATOM  13644  CG  PRO   104      96.279  58.366  34.685  1.00 16.48           C  
ATOM  13645  CD  PRO   104      96.631  57.440  35.786  1.00 15.15           C  
ATOM  13646  N   GLU   105      98.781  54.941  33.908  1.00 15.63           N  
ATOM  13647  CA  GLU   105      99.839  54.061  33.433  1.00 14.99           C  
ATOM  13648  C   GLU   105      99.426  52.591  33.472  1.00 15.57           C  
ATOM  13649  O   GLU   105     100.143  51.745  32.983  1.00 15.51           O  
ATOM  13650  CB  GLU   105     101.129  54.233  34.247  1.00 15.82           C  
ATOM  13651  CG  GLU   105     101.751  55.606  34.111  1.00 14.48           C  
ATOM  13652  CD  GLU   105     100.908  56.711  34.727  1.00 14.59           C  
ATOM  13653  OE1 GLU   105     100.406  56.563  35.871  1.00 15.16           O  
ATOM  13654  OE2 GLU   105     100.751  57.745  34.035  1.00 15.78           O  
ATOM  13655  N   PHE   106      98.296  52.297  34.120  1.00 15.66           N  
ATOM  13656  CA  PHE   106      97.815  50.921  34.211  1.00 15.19           C  
ATOM  13657  C   PHE   106      97.034  50.567  32.952  1.00 15.21           C  
ATOM  13658  O   PHE   106      96.053  51.238  32.616  1.00 15.33           O  
ATOM  13659  CB  PHE   106      96.970  50.643  35.451  1.00 15.12           C  
ATOM  13660  CG  PHE   106      96.527  49.222  35.524  1.00 14.69           C  
ATOM  13661  CD1 PHE   106      97.460  48.191  35.776  1.00 13.97           C  
ATOM  13662  CD2 PHE   106      95.195  48.878  35.251  1.00 14.24           C  
ATOM  13663  CE1 PHE   106      97.055  46.849  35.796  1.00 16.21           C  
ATOM  13664  CE2 PHE   106      94.808  47.554  35.251  1.00 16.36           C  
ATOM  13665  CZ  PHE   106      95.711  46.545  35.530  1.00 15.69           C  
ATOM  13666  N   VAL   107      97.492  49.515  32.274  1.00 15.49           N  
ATOM  13667  CA  VAL   107      96.959  49.139  30.942  1.00 15.51           C  
ATOM  13668  C   VAL   107      96.660  47.626  30.810  1.00 16.14           C  
ATOM  13669  O   VAL   107      96.676  47.065  29.678  1.00 17.46           O  
ATOM  13670  CB  VAL   107      97.875  49.636  29.813  1.00 15.35           C  
ATOM  13671  CG1 VAL   107      97.910  51.181  29.745  1.00 16.15           C  
ATOM  13672  CG2 VAL   107      99.308  49.001  29.940  1.00 17.34           C  
ATOM  13673  N   GLU   108      96.342  46.976  31.937  1.00 15.75           N  
ATOM  13674  CA  GLU   108      96.023  45.560  31.913  1.00 16.38           C  
ATOM  13675  C   GLU   108      94.628  45.285  32.422  1.00 15.43           C  
ATOM  13676  O   GLU   108      94.352  44.262  33.088  1.00 16.13           O  
ATOM  13677  CB  GLU   108      97.076  44.777  32.693  1.00 16.44           C  
ATOM  13678  CG  GLU   108      98.436  44.788  32.033  1.00 19.85           C  
ATOM  13679  CD  GLU   108      99.523  44.263  32.973  1.00 20.58           C  
ATOM  13680  OE1 GLU   108      99.742  44.801  34.079  1.00 29.71           O  
ATOM  13681  OE2 GLU   108     100.165  43.306  32.588  1.00 28.76           O  
ATOM  13682  N   GLN   109      93.705  46.167  32.065  1.00 15.62           N  
ATOM  13683  CA  GLN   109      92.320  45.982  32.468  1.00 15.33           C  
ATOM  13684  C   GLN   109      91.738  44.684  31.902  1.00 15.79           C  
ATOM  13685  O   GLN   109      90.865  44.105  32.513  1.00 16.28           O  
ATOM  13686  CB  GLN   109      91.473  47.148  32.024  1.00 15.81           C  
ATOM  13687  CG  GLN   109      91.813  48.476  32.661  1.00 14.14           C  
ATOM  13688  CD  GLN   109      92.960  49.238  31.952  1.00 15.09           C  
ATOM  13689  OE1 GLN   109      93.533  48.780  30.938  1.00 14.45           O  
ATOM  13690  NE2 GLN   109      93.277  50.409  32.470  1.00 14.52           N  
ATOM  13691  N   HIS   110      92.217  44.249  30.747  1.00 15.52           N  
ATOM  13692  CA  HIS   110      91.773  42.945  30.180  1.00 15.97           C  
ATOM  13693  C   HIS   110      92.129  41.795  31.114  1.00 15.78           C  
ATOM  13694  O   HIS   110      91.333  40.912  31.357  1.00 16.32           O  
ATOM  13695  CB  HIS   110      92.311  42.739  28.739  1.00 16.72           C  
ATOM  13696  CG  HIS   110      93.809  42.789  28.627  1.00 17.04           C  
ATOM  13697  ND1 HIS   110      94.550  43.909  28.945  1.00 19.60           N  
ATOM  13698  CD2 HIS   110      94.705  41.843  28.259  1.00 22.76           C  
ATOM  13699  CE1 HIS   110      95.839  43.643  28.780  1.00 20.17           C  
ATOM  13700  NE2 HIS   110      95.958  42.394  28.373  1.00 21.32           N  
ATOM  13701  N   LEU   111      93.330  41.821  31.669  1.00 16.38           N  
ATOM  13702  CA  LEU   111      93.763  40.836  32.657  1.00 16.96           C  
ATOM  13703  C   LEU   111      92.924  40.851  33.932  1.00 17.46           C  
ATOM  13704  O   LEU   111      92.575  39.786  34.492  1.00 19.02           O  
ATOM  13705  CB  LEU   111      95.239  41.050  32.982  1.00 17.06           C  
ATOM  13706  CG  LEU   111      96.187  40.875  31.779  1.00 17.72           C  
ATOM  13707  CD1 LEU   111      97.635  40.909  32.274  1.00 21.15           C  
ATOM  13708  CD2 LEU   111      95.918  39.613  30.974  1.00 21.14           C  
ATOM  13709  N   VAL   112      92.592  42.051  34.377  1.00 16.80           N  
ATOM  13710  CA  VAL   112      91.777  42.181  35.584  1.00 16.34           C  
ATOM  13711  C   VAL   112      90.397  41.535  35.335  1.00 16.45           C  
ATOM  13712  O   VAL   112      89.895  40.762  36.156  1.00 17.06           O  
ATOM  13713  CB  VAL   112      91.648  43.658  36.010  1.00 16.03           C  
ATOM  13714  CG1 VAL   112      90.570  43.824  37.097  1.00 14.54           C  
ATOM  13715  CG2 VAL   112      93.046  44.189  36.451  1.00 14.52           C  
ATOM  13716  N   ILE   113      89.783  41.862  34.211  1.00 16.33           N  
ATOM  13717  CA  ILE   113      88.418  41.383  33.939  1.00 16.57           C  
ATOM  13718  C   ILE   113      88.426  39.871  33.602  1.00 17.38           C  
ATOM  13719  O   ILE   113      87.418  39.207  33.835  1.00 17.79           O  
ATOM  13720  CB  ILE   113      87.684  42.255  32.877  1.00 16.97           C  
ATOM  13721  CG1 ILE   113      87.591  43.715  33.353  1.00 16.42           C  
ATOM  13722  CG2 ILE   113      86.275  41.686  32.506  1.00 16.23           C  
ATOM  13723  CD1 ILE   113      86.973  43.943  34.754  1.00 15.38           C  
ATOM  13724  N   ASN   114      89.573  39.326  33.152  1.00 17.62           N  
ATOM  13725  CA  ASN   114      89.721  37.861  33.017  1.00 18.16           C  
ATOM  13726  C   ASN   114      89.370  37.165  34.320  1.00 18.57           C  
ATOM  13727  O   ASN   114      88.867  36.056  34.301  1.00 19.99           O  
ATOM  13728  CB  ASN   114      91.130  37.469  32.547  1.00 18.52           C  
ATOM  13729  CG  ASN   114      91.406  37.829  31.083  1.00 20.10           C  
ATOM  13730  OD1 ASN   114      90.494  38.167  30.316  1.00 22.14           O  
ATOM  13731  ND2 ASN   114      92.665  37.744  30.689  1.00 20.05           N  
ATOM  13732  N   GLY   115      89.585  37.808  35.469  1.00 18.91           N  
ATOM  13733  CA  GLY   115      89.088  37.293  36.757  1.00 19.18           C  
ATOM  13734  C   GLY   115      87.609  36.931  36.679  1.00 19.79           C  
ATOM  13735  O   GLY   115      87.233  35.782  36.939  1.00 21.14           O  
ATOM  13736  N   ALA   116      86.771  37.891  36.267  1.00 19.18           N  
ATOM  13737  CA  ALA   116      85.331  37.638  36.074  1.00 18.73           C  
ATOM  13738  C   ALA   116      85.078  36.648  34.944  1.00 18.77           C  
ATOM  13739  O   ALA   116      84.318  35.704  35.117  1.00 18.13           O  
ATOM  13740  CB  ALA   116      84.563  38.940  35.818  1.00 17.60           C  
ATOM  13741  N   SER   117      85.690  36.872  33.792  1.00 19.29           N  
ATOM  13742  CA  SER   117      85.366  36.092  32.582  1.00 20.10           C  
ATOM  13743  C   SER   117      85.670  34.595  32.784  1.00 20.77           C  
ATOM  13744  O   SER   117      84.865  33.722  32.435  1.00 21.97           O  
ATOM  13745  CB  SER   117      86.103  36.640  31.358  1.00 19.41           C  
ATOM  13746  OG  SER   117      85.662  37.947  31.006  1.00 19.65           O  
ATOM  13747  N   ASN   118      86.810  34.313  33.389  1.00 21.80           N  
ATOM  13748  CA  ASN   118      87.247  32.938  33.669  1.00 21.92           C  
ATOM  13749  C   ASN   118      86.341  32.220  34.666  1.00 22.29           C  
ATOM  13750  O   ASN   118      86.014  31.026  34.477  1.00 23.85           O  
ATOM  13751  CB  ASN   118      88.672  32.936  34.193  1.00 22.14           C  
ATOM  13752  CG  ASN   118      89.692  33.319  33.143  1.00 23.36           C  
ATOM  13753  OD1 ASN   118      89.434  33.295  31.932  1.00 27.40           O  
ATOM  13754  ND2 ASN   118      90.877  33.671  33.606  1.00 27.49           N  
ATOM  13755  N   LEU   119      85.917  32.940  35.707  1.00 22.44           N  
ATOM  13756  CA  LEU   119      85.007  32.396  36.709  1.00 22.17           C  
ATOM  13757  C   LEU   119      83.654  32.058  36.071  1.00 22.24           C  
ATOM  13758  O   LEU   119      83.123  30.945  36.218  1.00 21.77           O  
ATOM  13759  CB  LEU   119      84.863  33.385  37.882  1.00 21.87           C  
ATOM  13760  CG  LEU   119      83.954  32.950  39.040  1.00 21.57           C  
ATOM  13761  CD1 LEU   119      84.343  33.550  40.394  1.00 22.43           C  
ATOM  13762  CD2 LEU   119      82.466  33.213  38.687  1.00 19.84           C  
ATOM  13763  N   ILE   120      83.100  33.014  35.340  1.00 22.68           N  
ATOM  13764  CA  ILE   120      81.797  32.834  34.691  1.00 23.03           C  
ATOM  13765  C   ILE   120      81.822  31.671  33.672  1.00 22.73           C  
ATOM  13766  O   ILE   120      80.921  30.827  33.672  1.00 22.74           O  
ATOM  13767  CB  ILE   120      81.304  34.189  34.057  1.00 22.50           C  
ATOM  13768  CG1 ILE   120      80.907  35.152  35.199  1.00 23.42           C  
ATOM  13769  CG2 ILE   120      80.119  33.969  33.092  1.00 23.23           C  
ATOM  13770  CD1 ILE   120      80.713  36.598  34.811  1.00 24.45           C  
ATOM  13771  N   ALA   121      82.859  31.598  32.846  1.00 22.93           N  
ATOM  13772  CA  ALA   121      82.995  30.525  31.867  1.00 23.71           C  
ATOM  13773  C   ALA   121      83.172  29.164  32.552  1.00 24.46           C  
ATOM  13774  O   ALA   121      82.589  28.167  32.118  1.00 24.40           O  
ATOM  13775  CB  ALA   121      84.153  30.806  30.923  1.00 24.16           C  
ATOM  13776  N   THR   122      83.934  29.146  33.646  1.00 25.07           N  
ATOM  13777  CA  THR   122      84.155  27.929  34.423  1.00 25.52           C  
ATOM  13778  C   THR   122      82.873  27.370  35.045  1.00 25.94           C  
ATOM  13779  O   THR   122      82.621  26.176  34.942  1.00 27.29           O  
ATOM  13780  CB  THR   122      85.229  28.151  35.493  1.00 25.67           C  
ATOM  13781  OG1 THR   122      86.465  28.470  34.828  1.00 25.67           O  
ATOM  13782  CG2 THR   122      85.404  26.905  36.403  1.00 25.84           C  
ATOM  13783  N   VAL   123      82.070  28.205  35.692  1.00 25.64           N  
ATOM  13784  CA  VAL   123      80.892  27.707  36.398  1.00 25.47           C  
ATOM  13785  C   VAL   123      79.727  27.416  35.437  1.00 25.14           C  
ATOM  13786  O   VAL   123      78.923  26.530  35.706  1.00 25.86           O  
ATOM  13787  CB  VAL   123      80.457  28.640  37.539  1.00 25.42           C  
ATOM  13788  CG1 VAL   123      81.594  28.801  38.558  1.00 25.65           C  
ATOM  13789  CG2 VAL   123      79.991  29.985  37.025  1.00 25.96           C  
ATOM  13790  N   LEU   124      79.648  28.132  34.316  1.00 25.53           N  
ATOM  13791  CA  LEU   124      78.543  27.974  33.358  1.00 25.86           C  
ATOM  13792  C   LEU   124      78.893  27.133  32.121  1.00 26.58           C  
ATOM  13793  O   LEU   124      77.992  26.702  31.399  1.00 27.85           O  
ATOM  13794  CB  LEU   124      78.016  29.354  32.906  1.00 25.67           C  
ATOM  13795  CG  LEU   124      77.392  30.242  34.005  1.00 25.75           C  
ATOM  13796  CD1 LEU   124      76.923  31.620  33.473  1.00 24.79           C  
ATOM  13797  CD2 LEU   124      76.239  29.529  34.730  1.00 24.67           C  
ATOM  13798  N   GLY   125      80.171  26.905  31.855  1.00 26.92           N  
ATOM  13799  CA  GLY   125      80.601  26.262  30.617  1.00 27.47           C  
ATOM  13800  C   GLY   125      80.400  27.153  29.401  1.00 28.59           C  
ATOM  13801  O   GLY   125      80.450  28.395  29.501  1.00 27.96           O  
ATOM  13802  N   GLU   126      80.145  26.533  28.247  1.00 29.57           N  
ATOM  13803  CA  GLU   126      80.046  27.272  26.987  1.00 29.15           C  
ATOM  13804  C   GLU   126      79.064  28.438  27.036  1.00 28.94           C  
ATOM  13805  O   GLU   126      79.378  29.497  26.491  1.00 29.44           O  
ATOM  13806  CB  GLU   126      79.695  26.340  25.813  1.00 31.00           C  
ATOM  13807  CG  GLU   126      79.198  27.036  24.521  1.00 32.78           C  
ATOM  13808  CD  GLU   126      80.275  27.849  23.846  1.00 39.95           C  
ATOM  13809  OE1 GLU   126      81.484  27.537  24.067  1.00 43.72           O  
ATOM  13810  OE2 GLU   126      79.914  28.797  23.096  1.00 44.33           O  
ATOM  13811  N   PRO   127      77.872  28.252  27.641  1.00 28.35           N  
ATOM  13812  CA  PRO   127      76.944  29.395  27.735  1.00 27.52           C  
ATOM  13813  C   PRO   127      77.493  30.606  28.480  1.00 26.17           C  
ATOM  13814  O   PRO   127      76.951  31.708  28.316  1.00 25.23           O  
ATOM  13815  CB  PRO   127      75.769  28.854  28.541  1.00 27.48           C  
ATOM  13816  CG  PRO   127      75.825  27.360  28.369  1.00 28.37           C  
ATOM  13817  CD  PRO   127      77.274  27.013  28.195  1.00 29.33           C  
ATOM  13818  N   GLY   128      78.509  30.381  29.316  1.00 24.90           N  
ATOM  13819  CA  GLY   128      79.160  31.456  30.029  1.00 24.87           C  
ATOM  13820  C   GLY   128      80.076  32.338  29.192  1.00 24.95           C  
ATOM  13821  O   GLY   128      80.490  33.405  29.683  1.00 25.60           O  
ATOM  13822  N   ARG   129      80.434  31.920  27.974  1.00 24.08           N  
ATOM  13823  CA  ARG   129      81.368  32.698  27.159  1.00 24.96           C  
ATOM  13824  C   ARG   129      80.614  33.880  26.582  1.00 23.19           C  
ATOM  13825  O   ARG   129      79.509  33.733  26.062  1.00 23.19           O  
ATOM  13826  CB  ARG   129      81.996  31.866  26.065  1.00 25.42           C  
ATOM  13827  CG  ARG   129      82.821  30.711  26.608  1.00 27.86           C  
ATOM  13828  CD  ARG   129      83.309  29.877  25.472  1.00 29.98           C  
ATOM  13829  NE  ARG   129      84.510  30.430  24.867  1.00 34.49           N  
ATOM  13830  CZ  ARG   129      84.825  30.292  23.581  1.00 36.05           C  
ATOM  13831  NH1 ARG   129      84.003  29.656  22.751  1.00 39.31           N  
ATOM  13832  NH2 ARG   129      85.952  30.809  23.108  1.00 35.44           N  
ATOM  13833  N   HIS   130      81.207  35.062  26.690  1.00 21.17           N  
ATOM  13834  CA  HIS   130      80.479  36.305  26.497  1.00 19.81           C  
ATOM  13835  C   HIS   130      81.292  37.340  25.734  1.00 18.95           C  
ATOM  13836  O   HIS   130      82.515  37.310  25.762  1.00 19.32           O  
ATOM  13837  CB  HIS   130      80.174  36.874  27.875  1.00 19.15           C  
ATOM  13838  CG  HIS   130      81.373  36.896  28.779  1.00 19.27           C  
ATOM  13839  ND1 HIS   130      81.715  35.823  29.575  1.00 18.83           N  
ATOM  13840  CD2 HIS   130      82.352  37.826  28.960  1.00 18.82           C  
ATOM  13841  CE1 HIS   130      82.841  36.093  30.215  1.00 19.50           C  
ATOM  13842  NE2 HIS   130      83.245  37.304  29.863  1.00 18.38           N  
ATOM  13843  N   ALA   131      80.591  38.238  25.056  1.00 18.23           N  
ATOM  13844  CA  ALA   131      81.198  39.483  24.562  1.00 17.93           C  
ATOM  13845  C   ALA   131      81.615  40.331  25.788  1.00 17.63           C  
ATOM  13846  O   ALA   131      81.145  40.128  26.900  1.00 18.26           O  
ATOM  13847  CB  ALA   131      80.243  40.256  23.664  1.00 17.85           C  
ATOM  13848  N   ARG   132      82.489  41.306  25.575  1.00 18.24           N  
ATOM  13849  CA  ARG   132      83.035  42.036  26.695  1.00 18.04           C  
ATOM  13850  C   ARG   132      83.617  43.385  26.284  1.00 17.43           C  
ATOM  13851  O   ARG   132      84.088  43.565  25.163  1.00 16.62           O  
ATOM  13852  CB  ARG   132      84.181  41.242  27.282  1.00 17.74           C  
ATOM  13853  CG  ARG   132      84.379  41.473  28.719  1.00 21.52           C  
ATOM  13854  CD  ARG   132      85.559  40.622  29.271  1.00 20.37           C  
ATOM  13855  NE  ARG   132      86.903  41.031  28.837  1.00 22.76           N  
ATOM  13856  CZ  ARG   132      88.019  40.471  29.328  1.00 21.32           C  
ATOM  13857  NH1 ARG   132      87.918  39.544  30.236  1.00 20.78           N  
ATOM  13858  NH2 ARG   132      89.223  40.856  28.939  1.00 22.78           N  
ATOM  13859  N   ALA   133      83.650  44.285  27.244  1.00 16.82           N  
ATOM  13860  CA  ALA   133      84.489  45.509  27.180  1.00 17.17           C  
ATOM  13861  C   ALA   133      85.251  45.582  28.508  1.00 16.48           C  
ATOM  13862  O   ALA   133      84.736  45.177  29.538  1.00 16.92           O  
ATOM  13863  CB  ALA   133      83.642  46.745  26.979  1.00 17.02           C  
ATOM  13864  N   ALA   134      86.494  46.049  28.468  1.00 16.84           N  
ATOM  13865  CA  ALA   134      87.303  46.207  29.665  1.00 16.59           C  
ATOM  13866  C   ALA   134      87.964  47.583  29.548  1.00 16.64           C  
ATOM  13867  O   ALA   134      88.695  47.845  28.578  1.00 17.05           O  
ATOM  13868  CB  ALA   134      88.348  45.119  29.805  1.00 17.16           C  
ATOM  13869  N   VAL   135      87.689  48.463  30.496  1.00 16.16           N  
ATOM  13870  CA  VAL   135      88.099  49.863  30.393  1.00 15.33           C  
ATOM  13871  C   VAL   135      88.602  50.422  31.715  1.00 15.04           C  
ATOM  13872  O   VAL   135      88.202  49.980  32.779  1.00 16.55           O  
ATOM  13873  CB  VAL   135      86.942  50.718  29.835  1.00 15.27           C  
ATOM  13874  CG1 VAL   135      86.621  50.279  28.369  1.00 15.28           C  
ATOM  13875  CG2 VAL   135      85.715  50.631  30.750  1.00 18.02           C  
ATOM  13876  N   GLY   136      89.451  51.440  31.644  1.00 14.42           N  
ATOM  13877  CA  GLY   136      90.007  52.072  32.833  1.00 14.05           C  
ATOM  13878  C   GLY   136      89.283  53.347  33.238  1.00 14.66           C  
ATOM  13879  O   GLY   136      89.192  54.307  32.461  1.00 16.32           O  
ATOM  13880  N   MET   137      88.838  53.366  34.492  1.00 15.74           N  
ATOM  13881  CA  MET   137      88.019  54.428  35.067  1.00 15.53           C  
ATOM  13882  C   MET   137      88.883  55.286  36.016  1.00 14.55           C  
ATOM  13883  O   MET   137      89.870  54.808  36.569  1.00 14.21           O  
ATOM  13884  CB  MET   137      86.856  53.860  35.881  1.00 17.67           C  
ATOM  13885  CG  MET   137      86.263  52.643  35.390  1.00 23.71           C  
ATOM  13886  SD  MET   137      85.665  52.752  33.523  1.00 32.58          SE  
ATOM  13887  CE  MET   137      84.716  54.461  33.938  1.00 19.25           C  
ATOM  13888  N   ALA   138      88.476  56.527  36.234  1.00 13.88           N  
ATOM  13889  CA  ALA   138      89.141  57.440  37.178  1.00 14.06           C  
ATOM  13890  C   ALA   138      88.955  56.936  38.616  1.00 14.04           C  
ATOM  13891  O   ALA   138      89.862  57.017  39.449  1.00 13.62           O  
ATOM  13892  CB  ALA   138      88.610  58.875  37.047  1.00 13.96           C  
ATOM  13893  N   SER   139      87.774  56.379  38.876  1.00 14.58           N  
ATOM  13894  CA  SER   139      87.388  55.917  40.210  1.00 15.14           C  
ATOM  13895  C   SER   139      85.992  55.291  40.117  1.00 14.88           C  
ATOM  13896  O   SER   139      85.324  55.457  39.108  1.00 14.48           O  
ATOM  13897  CB  SER   139      87.394  57.083  41.230  1.00 15.80           C  
ATOM  13898  OG  SER   139      86.720  58.247  40.755  1.00 16.73           O  
ATOM  13899  N   LEU   140      85.553  54.651  41.200  1.00 15.44           N  
ATOM  13900  CA  LEU   140      84.237  53.954  41.240  1.00 15.36           C  
ATOM  13901  C   LEU   140      83.547  54.180  42.597  1.00 15.58           C  
ATOM  13902  O   LEU   140      84.208  54.523  43.587  1.00 15.56           O  
ATOM  13903  CB  LEU   140      84.409  52.450  40.962  1.00 15.93           C  
ATOM  13904  CG  LEU   140      84.909  52.035  39.582  1.00 15.60           C  
ATOM  13905  CD1 LEU   140      85.286  50.549  39.605  1.00 15.22           C  
ATOM  13906  CD2 LEU   140      83.852  52.382  38.482  1.00 15.08           C  
ATOM  13907  N   PRO   141      82.211  54.021  42.644  1.00 15.44           N  
ATOM  13908  CA  PRO   141      81.453  54.136  43.911  1.00 16.14           C  
ATOM  13909  C   PRO   141      82.110  53.334  45.044  1.00 15.92           C  
ATOM  13910  O   PRO   141      82.581  52.199  44.826  1.00 16.30           O  
ATOM  13911  CB  PRO   141      80.075  53.575  43.548  1.00 15.94           C  
ATOM  13912  CG  PRO   141      79.935  53.831  42.101  1.00 15.45           C  
ATOM  13913  CD  PRO   141      81.316  53.727  41.508  1.00 15.64           C  
ATOM  13914  N   PHE   142      82.170  53.939  46.230  1.00 16.28           N  
ATOM  13915  CA  PHE   142      82.733  53.297  47.430  1.00 17.01           C  
ATOM  13916  C   PHE   142      84.216  52.930  47.312  1.00 17.24           C  
ATOM  13917  O   PHE   142      84.742  52.110  48.073  1.00 17.44           O  
ATOM  13918  CB  PHE   142      81.928  52.059  47.803  1.00 18.58           C  
ATOM  13919  CG  PHE   142      80.466  52.336  47.998  1.00 18.46           C  
ATOM  13920  CD1 PHE   142      80.015  52.864  49.180  1.00 21.60           C  
ATOM  13921  CD2 PHE   142      79.559  52.097  46.970  1.00 21.58           C  
ATOM  13922  CE1 PHE   142      78.682  53.137  49.358  1.00 21.61           C  
ATOM  13923  CE2 PHE   142      78.215  52.370  47.137  1.00 22.90           C  
ATOM  13924  CZ  PHE   142      77.776  52.887  48.332  1.00 22.64           C  
ATOM  13925  N   ASN   143      84.878  53.560  46.330  1.00 16.87           N  
ATOM  13926  CA  ASN   143      86.266  53.270  45.999  1.00 15.70           C  
ATOM  13927  C   ASN   143      86.510  51.824  45.587  1.00 15.55           C  
ATOM  13928  O   ASN   143      87.609  51.322  45.736  1.00 16.70           O  
ATOM  13929  CB  ASN   143      87.154  53.677  47.176  1.00 16.04           C  
ATOM  13930  CG  ASN   143      88.588  53.911  46.779  1.00 14.10           C  
ATOM  13931  OD1 ASN   143      88.914  54.151  45.608  1.00 17.82           O  
ATOM  13932  ND2 ASN   143      89.478  53.852  47.779  1.00 17.12           N  
ATOM  13933  N   ALA   144      85.488  51.161  45.023  1.00 15.75           N  
ATOM  13934  CA  ALA   144      85.636  49.826  44.460  1.00 15.29           C  
ATOM  13935  C   ALA   144      86.735  49.841  43.411  1.00 15.28           C  
ATOM  13936  O   ALA   144      86.847  50.796  42.624  1.00 14.89           O  
ATOM  13937  CB  ALA   144      84.350  49.361  43.831  1.00 15.92           C  
ATOM  13938  N   SER   145      87.538  48.785  43.403  1.00 15.49           N  
ATOM  13939  CA  SER   145      88.570  48.650  42.372  1.00 15.37           C  
ATOM  13940  C   SER   145      87.975  48.256  41.005  1.00 15.28           C  
ATOM  13941  O   SER   145      88.503  48.615  39.973  1.00 14.24           O  
ATOM  13942  CB  SER   145      89.687  47.688  42.825  1.00 16.67           C  
ATOM  13943  OG  SER   145      90.313  48.168  44.001  1.00 16.25           O  
ATOM  13944  N   VAL   146      86.877  47.516  41.017  1.00 14.87           N  
ATOM  13945  CA  VAL   146      86.230  47.021  39.809  1.00 15.23           C  
ATOM  13946  C   VAL   146      84.712  47.079  40.031  1.00 15.41           C  
ATOM  13947  O   VAL   146      84.210  46.874  41.153  1.00 15.54           O  
ATOM  13948  CB  VAL   146      86.670  45.536  39.456  1.00 15.05           C  
ATOM  13949  CG1 VAL   146      86.085  45.052  38.089  1.00 15.94           C  
ATOM  13950  CG2 VAL   146      88.232  45.354  39.571  1.00 14.96           C  
ATOM  13951  N   GLU   147      84.007  47.398  38.957  1.00 15.93           N  
ATOM  13952  CA  GLU   147      82.535  47.312  38.856  1.00 15.92           C  
ATOM  13953  C   GLU   147      82.252  46.607  37.524  1.00 15.93           C  
ATOM  13954  O   GLU   147      82.884  46.924  36.508  1.00 15.74           O  
ATOM  13955  CB  GLU   147      81.892  48.684  38.856  1.00 16.26           C  
ATOM  13956  CG  GLU   147      80.408  48.720  38.569  1.00 16.79           C  
ATOM  13957  CD  GLU   147      79.814  50.141  38.566  1.00 17.90           C  
ATOM  13958  OE1 GLU   147      80.472  51.032  39.106  1.00 16.37           O  
ATOM  13959  OE2 GLU   147      78.691  50.362  38.032  1.00 21.33           O  
ATOM  13960  N   ILE   148      81.306  45.667  37.535  1.00 16.14           N  
ATOM  13961  CA  ILE   148      80.988  44.895  36.342  1.00 15.98           C  
ATOM  13962  C   ILE   148      79.476  44.740  36.189  1.00 16.11           C  
ATOM  13963  O   ILE   148      78.794  44.315  37.129  1.00 16.86           O  
ATOM  13964  CB  ILE   148      81.601  43.456  36.330  1.00 16.86           C  
ATOM  13965  CG1 ILE   148      83.118  43.455  36.615  1.00 15.12           C  
ATOM  13966  CG2 ILE   148      81.313  42.831  34.929  1.00 17.11           C  
ATOM  13967  CD1 ILE   148      83.783  42.069  36.538  1.00 16.31           C  
ATOM  13968  N   ASP   149      78.974  45.086  35.011  1.00 15.24           N  
ATOM  13969  CA  ASP   149      77.541  44.879  34.705  1.00 16.84           C  
ATOM  13970  C   ASP   149      77.406  43.805  33.638  1.00 16.71           C  
ATOM  13971  O   ASP   149      78.409  43.329  33.087  1.00 19.31           O  
ATOM  13972  CB  ASP   149      76.857  46.181  34.332  1.00 17.25           C  
ATOM  13973  CG  ASP   149      77.178  46.666  32.924  1.00 18.92           C  
ATOM  13974  OD1 ASP   149      77.717  45.917  32.076  1.00 21.61           O  
ATOM  13975  OD2 ASP   149      76.901  47.857  32.671  1.00 23.19           O  
ATOM  13976  N   ALA   150      76.170  43.403  33.348  1.00 17.03           N  
ATOM  13977  CA  ALA   150      75.979  42.220  32.491  1.00 17.32           C  
ATOM  13978  C   ALA   150      74.653  42.251  31.760  1.00 17.32           C  
ATOM  13979  O   ALA   150      73.681  42.805  32.264  1.00 17.16           O  
ATOM  13980  CB  ALA   150      76.071  40.922  33.290  1.00 16.29           C  
ATOM  13981  N   ILE   151      74.636  41.600  30.597  1.00 17.86           N  
ATOM  13982  CA  ILE   151      73.385  41.298  29.877  1.00 18.64           C  
ATOM  13983  C   ILE   151      73.400  39.782  29.684  1.00 18.58           C  
ATOM  13984  O   ILE   151      74.408  39.216  29.252  1.00 16.46           O  
ATOM  13985  CB  ILE   151      73.295  41.986  28.517  1.00 18.12           C  
ATOM  13986  CG1 ILE   151      73.401  43.521  28.639  1.00 18.70           C  
ATOM  13987  CG2 ILE   151      72.005  41.638  27.832  1.00 18.34           C  
ATOM  13988  CD1 ILE   151      73.738  44.160  27.326  1.00 21.12           C  
ATOM  13989  N   VAL   152      72.296  39.127  30.014  1.00 19.65           N  
ATOM  13990  CA  VAL   152      72.245  37.677  30.062  1.00 20.85           C  
ATOM  13991  C   VAL   152      70.965  37.236  29.312  1.00 21.79           C  
ATOM  13992  O   VAL   152      69.875  37.732  29.595  1.00 23.25           O  
ATOM  13993  CB  VAL   152      72.234  37.157  31.530  1.00 20.51           C  
ATOM  13994  CG1 VAL   152      72.116  35.632  31.552  1.00 20.98           C  
ATOM  13995  CG2 VAL   152      73.472  37.627  32.314  1.00 19.78           C  
ATOM  13996  N   GLU   153      71.111  36.364  28.337  1.00 22.65           N  
ATOM  13997  CA  GLU   153      69.931  35.789  27.677  1.00 23.65           C  
ATOM  13998  C   GLU   153      69.416  34.643  28.566  1.00 23.87           C  
ATOM  13999  O   GLU   153      70.189  33.746  28.945  1.00 23.66           O  
ATOM  14000  CB  GLU   153      70.264  35.289  26.289  1.00 23.38           C  
ATOM  14001  CG  GLU   153      69.041  34.729  25.582  1.00 23.77           C  
ATOM  14002  CD  GLU   153      69.403  34.097  24.286  1.00 25.44           C  
ATOM  14003  OE1 GLU   153      69.856  34.818  23.377  1.00 28.66           O  
ATOM  14004  OE2 GLU   153      69.232  32.859  24.181  1.00 33.72           O  
ATOM  14005  N   ILE   154      68.116  34.683  28.885  1.00 25.68           N  
ATOM  14006  CA  ILE   154      67.500  33.757  29.854  1.00 26.78           C  
ATOM  14007  C   ILE   154      66.314  33.035  29.242  1.00 30.18           C  
ATOM  14008  O   ILE   154      65.740  33.496  28.257  1.00 29.70           O  
ATOM  14009  CB  ILE   154      67.039  34.458  31.150  1.00 26.75           C  
ATOM  14010  CG1 ILE   154      66.053  35.594  30.860  1.00 26.10           C  
ATOM  14011  CG2 ILE   154      68.259  34.960  31.966  1.00 25.49           C  
ATOM  14012  CD1 ILE   154      65.428  36.242  32.107  1.00 26.67           C  
ATOM  14013  N   ASP   155      65.987  31.894  29.838  1.00 34.08           N  
ATOM  14014  CA  ASP   155      64.750  31.169  29.526  1.00 38.39           C  
ATOM  14015  C   ASP   155      63.533  31.867  30.087  1.00 39.81           C  
ATOM  14016  O   ASP   155      63.331  31.884  31.303  1.00 41.42           O  
ATOM  14017  CB  ASP   155      64.825  29.774  30.112  1.00 38.89           C  
ATOM  14018  CG  ASP   155      65.674  28.876  29.280  1.00 42.84           C  
ATOM  14019  OD1 ASP   155      65.266  28.669  28.107  1.00 47.96           O  
ATOM  14020  OD2 ASP   155      66.738  28.398  29.774  1.00 48.12           O  
ATOM  14021  N   VAL   156      62.721  32.426  29.191  1.00 42.19           N  
ATOM  14022  CA  VAL   156      61.502  33.142  29.551  1.00 42.99           C  
ATOM  14023  C   VAL   156      60.299  32.349  29.037  1.00 44.31           C  
ATOM  14024  O   VAL   156      60.430  31.553  28.090  1.00 45.98           O  
ATOM  14025  CB  VAL   156      61.529  34.588  28.958  1.00 43.73           C  
ATOM  14026  CG1 VAL   156      60.139  35.038  28.439  1.00 44.09           C  
ATOM  14027  CG2 VAL   156      62.095  35.575  29.986  1.00 43.38           C  
END
