
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  128 (  961),  selected  128 , name 2uyj_A
# Molecule2: number of CA atoms  152 ( 1118),  selected  152 , name T0423.pdb
# PARAMETERS: 2uyj_A.T0423.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      M       1           -
LGA    K     2_A      S       2           -
LGA    K     3_A      D       3           -
LGA    I     4_A      V       4           -
LGA    I     5_A      I       5           -
LGA    E     6_A      E       6           -
LGA    T     7_A      G       7           -
LGA    -       -      R       8           -
LGA    -       -      L       9           -
LGA    -       -      K      10           -
LGA    -       -      E      11           -
LGA    -       -      L      12           -
LGA    -       -      G      13           -
LGA    -       -      F      14           -
LGA    -       -      T      15           -
LGA    -       -      L      16           -
LGA    Q     8_A      P      17          5.936
LGA    R     9_A      V      18          2.154
LGA    A    10_A      -       -           -
LGA    P    11_A      -       -           -
LGA    G    12_A      -       -           -
LGA    A    13_A      -       -           -
LGA    I    14_A      A      23           #
LGA    G    15_A      A      24           #
LGA    P    16_A      N      25          3.598
LGA    Y    17_A      Y      26          1.671
LGA    V    18_A      V      27          1.060
LGA    Q    19_A      P      28          0.804
LGA    G    20_A      F      29          0.952
LGA    V    21_A      T      30          1.502
LGA    D    22_A      I      31          2.436
LGA    L    23_A      S      32          2.887
LGA    G    24_A      G      33          4.030
LGA    S    25_A      N      34          1.394
LGA    M    26_A      L      35          1.409
LGA    V    27_A      L      36          0.886
LGA    F    28_A      Y      37          0.764
LGA    T    29_A      V      38          0.853
LGA    S    30_A      S      39          0.877
LGA    G    31_A      G      40          0.649
LGA    Q    32_A      Q      41          0.582
LGA    I    33_A      L      42          1.022
LGA    P    34_A      P      43          0.885
LGA    V    35_A      M      44          2.009
LGA    X    36_A      E      45          2.191
LGA    P    37_A      S      46          5.225
LGA    Q    38_A      G      47          3.709
LGA    T    39_A      -       -           -
LGA    G    40_A      -       -           -
LGA    E    41_A      K      48          1.871
LGA    I    42_A      I      49          2.094
LGA    P    43_A      A      50          2.094
LGA    A    44_A      V      51          3.182
LGA    -       -      T      52           -
LGA    -       -      G      53           -
LGA    -       -      L      54           -
LGA    -       -      V      55           -
LGA    -       -      G      56           -
LGA    -       -      R      57           -
LGA    -       -      D      58           -
LGA    -       -      V      59           -
LGA    -       -      D      60           -
LGA    -       -      V      61           -
LGA    -       -      A      62           -
LGA    D    45_A      S      63          2.504
LGA    V    46_A      A      64          1.186
LGA    Q    47_A      Q      65          2.429
LGA    D    48_A      R      66          1.922
LGA    Q    49_A      A      67          0.740
LGA    A    50_A      A      68          0.915
LGA    R    51_A      E      69          0.824
LGA    L    52_A      L      70          0.460
LGA    S    53_A      C      71          0.271
LGA    L    54_A      A      72          0.558
LGA    E    55_A      V      73          0.467
LGA    N    56_A      N      74          0.468
LGA    V    57_A      I      75          0.621
LGA    K    58_A      L      76          0.803
LGA    A    59_A      A      77          0.822
LGA    I    60_A      Q      78          0.784
LGA    V    61_A      V      79          1.180
LGA    V    62_A      K      80          1.706
LGA    A    63_A      A      81          1.560
LGA    A    64_A      A      82          1.808
LGA    G    65_A      L      83          1.865
LGA    -       -      N      84           -
LGA    -       -      G      85           -
LGA    -       -      D      86           -
LGA    -       -      L      87           -
LGA    -       -      S      88           -
LGA    L    66_A      K      89          3.551
LGA    S    67_A      I      90          3.403
LGA    V    68_A      R      91           -
LGA    G    69_A      -       -           -
LGA    D    70_A      R      92          2.364
LGA    I    71_A      V      93          1.463
LGA    I    72_A      I      94          0.425
LGA    K    73_A      K      95          1.314
LGA    M    74_A      L      96          1.473
LGA    T    75_A      N      97          1.129
LGA    V    76_A      G      98          1.028
LGA    F    77_A      F      99          1.353
LGA    I    78_A      V     100          1.293
LGA    T    79_A      A     101          1.594
LGA    D    80_A      S     102          2.291
LGA    -       -      V     103           -
LGA    -       -      P     104           -
LGA    -       -      E     105           -
LGA    L    81_A      F     106          4.339
LGA    N    82_A      V     107          3.660
LGA    D    83_A      E     108          4.519
LGA    F    84_A      Q     109          2.352
LGA    A    85_A      H     110          5.073
LGA    T    86_A      L     111          3.795
LGA    I    87_A      V     112          1.616
LGA    N    88_A      I     113          3.742
LGA    E    89_A      N     114          3.447
LGA    V    90_A      G     115          1.598
LGA    Y    91_A      A     116          2.722
LGA    K    92_A      S     117          3.579
LGA    Q    93_A      N     118          2.070
LGA    F    94_A      L     119          1.137
LGA    F    95_A      I     120          2.902
LGA    D    96_A      A     121          2.930
LGA    E    97_A      T     122          1.202
LGA    H    98_A      V     123          2.120
LGA    -       -      L     124           -
LGA    Q    99_A      G     125          0.533
LGA    A   100_A      E     126          3.235
LGA    T   101_A      P     127          4.045
LGA    -       -      G     128           -
LGA    Y   102_A      R     129          1.836
LGA    P   103_A      H     130          1.278
LGA    T   104_A      A     131          1.298
LGA    R   105_A      R     132          1.226
LGA    S   106_A      A     133          1.583
LGA    C   107_A      A     134          1.818
LGA    V   108_A      V     135          1.675
LGA    Q   109_A      G     136          1.131
LGA    V   110_A      M     137          1.638
LGA    A   111_A      A     138          1.163
LGA    R   112_A      S     139          1.002
LGA    L   113_A      L     140          0.640
LGA    P   114_A      P     141          0.270
LGA    K   115_A      F     142          0.682
LGA    D   116_A      N     143          0.854
LGA    V   117_A      A     144          0.974
LGA    K   118_A      S     145          1.489
LGA    L   119_A      V     146          1.345
LGA    E   120_A      E     147          1.011
LGA    I   121_A      I     148          0.781
LGA    E   122_A      D     149          0.914
LGA    A   123_A      A     150          0.665
LGA    I   124_A      I     151          0.843
LGA    A   125_A      V     152          1.051
LGA    V   126_A      E     153          1.442
LGA    R   127_A      I     154          1.868
LGA    S   128_A      D     155          4.648
LGA    -       -      V     156           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  128  152    5.0    111    2.18    25.23     58.562     4.878

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.897272 * X  +  -0.272491 * Y  +   0.347349 * Z  +  85.494171
  Y_new =  -0.237906 * X  +  -0.364328 * Y  +  -0.900370 * Z  +  73.686989
  Z_new =   0.371892 * X  +  -0.890513 * Y  +   0.262074 * Z  +  34.519566 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.284581    1.857012  [ DEG:   -73.6011    106.3989 ]
  Theta =  -0.381046   -2.760546  [ DEG:   -21.8324   -158.1676 ]
  Phi   =  -2.882412    0.259180  [ DEG:  -165.1501     14.8499 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2uyj_A                                        
REMARK     2: T0423.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2uyj_A.T0423.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  128  152   5.0  111   2.18   25.23  58.562
REMARK  ---------------------------------------------------------- 
MOLECULE 2uyj_A
HEADER    UNKNOWN FUNCTION                        10-APR-07   2UYJ              
TITLE     CRYSTAL STRUCTURE OF E. COLI TDCF WITH BOUND ETHYLENE GLYCOL          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN TDCF;                                              
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 SYNONYM: TDCF;                                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 STRAIN: MC4100;                                                      
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21-DE3 GOLD;                             
SOURCE   6 EXPRESSION_SYSTEM_VECTOR: PET28A;                                    
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PETHF1                                    
KEYWDS    YJGF/YER057C/UK114 FAMILY, ETHYLENE GLYCOL, UNKNOWN                   
KEYWDS   2 FUNCTION, TDCF PROTEIN, LIGAND BINDING, 2-KETOBUTYRATE               
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.D.BURMAN,C.E.M.STEVENSON,R.G.SAWERS,D.M.LAWSON                      
REVDAT   1   29-MAY-07 2UYJ    0                                                
JRNL        AUTH   J.D.BURMAN,C.E.M.STEVENSON,R.G.SAWERS,D.M.LAWSON             
JRNL        TITL   THE CRYSTAL STRUCTURE OF ESCHERICHIA COLI TDCF, A            
JRNL        TITL 2 MEMBER OF THE HIGHLY CONSERVED YJGF/YER057C/UK114            
JRNL        TITL 3 FAMILY.                                                      
JRNL        REF    BMC STRUCT.BIOL.              V.   7    30 2007              
JRNL        REFN                UK ESSN 1472-6807                               
REMARK   2 RESOLUTION. 2.35 ANGSTROMS.                                          
DBREF  2UYJ A    1   129  UNP    P0AGL2   TDCF_ECOLI       1    129             
DBREF  2UYJ B    1   129  UNP    P0AGL2   TDCF_ECOLI       1    129             
DBREF  2UYJ C    1   129  UNP    P0AGL2   TDCF_ECOLI       1    129             
SEQRES   1 A  129  MET LYS LYS ILE ILE GLU THR GLN ARG ALA PRO GLY ALA          
SEQRES   2 A  129  ILE GLY PRO TYR VAL GLN GLY VAL ASP LEU GLY SER MET          
SEQRES   3 A  129  VAL PHE THR SER GLY GLN ILE PRO VAL OCS PRO GLN THR          
SEQRES   4 A  129  GLY GLU ILE PRO ALA ASP VAL GLN ASP GLN ALA ARG LEU          
SEQRES   5 A  129  SER LEU GLU ASN VAL LYS ALA ILE VAL VAL ALA ALA GLY          
SEQRES   6 A  129  LEU SER VAL GLY ASP ILE ILE LYS MET THR VAL PHE ILE          
SEQRES   7 A  129  THR ASP LEU ASN ASP PHE ALA THR ILE ASN GLU VAL TYR          
SEQRES   8 A  129  LYS GLN PHE PHE ASP GLU HIS GLN ALA THR TYR PRO THR          
SEQRES   9 A  129  ARG SER CYS VAL GLN VAL ALA ARG LEU PRO LYS ASP VAL          
SEQRES  10 A  129  LYS LEU GLU ILE GLU ALA ILE ALA VAL ARG SER ALA              
SEQRES   1 B  129  MET LYS LYS ILE ILE GLU THR GLN ARG ALA PRO GLY ALA          
SEQRES   2 B  129  ILE GLY PRO TYR VAL GLN GLY VAL ASP LEU GLY SER MET          
SEQRES   3 B  129  VAL PHE THR SER GLY GLN ILE PRO VAL OCS PRO GLN THR          
SEQRES   4 B  129  GLY GLU ILE PRO ALA ASP VAL GLN ASP GLN ALA ARG LEU          
SEQRES   5 B  129  SER LEU GLU ASN VAL LYS ALA ILE VAL VAL ALA ALA GLY          
SEQRES   6 B  129  LEU SER VAL GLY ASP ILE ILE LYS MET THR VAL PHE ILE          
SEQRES   7 B  129  THR ASP LEU ASN ASP PHE ALA THR ILE ASN GLU VAL TYR          
SEQRES   8 B  129  LYS GLN PHE PHE ASP GLU HIS GLN ALA THR TYR PRO THR          
SEQRES   9 B  129  ARG SER CYS VAL GLN VAL ALA ARG LEU PRO LYS ASP VAL          
SEQRES  10 B  129  LYS LEU GLU ILE GLU ALA ILE ALA VAL ARG SER ALA              
SEQRES   1 C  129  MET LYS LYS ILE ILE GLU THR GLN ARG ALA PRO GLY ALA          
SEQRES   2 C  129  ILE GLY PRO TYR VAL GLN GLY VAL ASP LEU GLY SER MET          
SEQRES   3 C  129  VAL PHE THR SER GLY GLN ILE PRO VAL OCS PRO GLN THR          
SEQRES   4 C  129  GLY GLU ILE PRO ALA ASP VAL GLN ASP GLN ALA ARG LEU          
SEQRES   5 C  129  SER LEU GLU ASN VAL LYS ALA ILE VAL VAL ALA ALA GLY          
SEQRES   6 C  129  LEU SER VAL GLY ASP ILE ILE LYS MET THR VAL PHE ILE          
SEQRES   7 C  129  THR ASP LEU ASN ASP PHE ALA THR ILE ASN GLU VAL TYR          
SEQRES   8 C  129  LYS GLN PHE PHE ASP GLU HIS GLN ALA THR TYR PRO THR          
SEQRES   9 C  129  ARG SER CYS VAL GLN VAL ALA ARG LEU PRO LYS ASP VAL          
SEQRES  10 C  129  LYS LEU GLU ILE GLU ALA ILE ALA VAL ARG SER ALA              
HET    OCS  A  36       9                                                       
HET    OCS  B  36       9                                                       
HET    OCS  C  36       9                                                       
HET    EDO  B1129       4                                                       
HET    EDO  C1129       4                                                       
HETNAM     OCS CYSTEINESULFONIC ACID                                            
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  OCS    3(C3 H7 N O5 S)                                              
FORMUL   4  EDO    2(C2 H6 O2)                                                  
FORMUL   6  HOH   *205(H2 O)                                                    
CRYST1   72.671   86.224   62.617  90.00  90.00  90.00 P 21 21 2    12          
ATOM      1  N   MET A   1      58.202  42.714  30.228  1.00 40.09           N  
ATOM      2  CA  MET A   1      57.316  42.059  31.239  1.00 40.85           C  
ATOM      3  C   MET A   1      57.431  42.702  32.629  1.00 39.73           C  
ATOM      4  O   MET A   1      56.543  42.528  33.479  1.00 40.44           O  
ATOM      5  CB  MET A   1      57.629  40.555  31.341  1.00 41.01           C  
ATOM      6  CG  MET A   1      57.507  40.005  32.782  1.00 42.22           C  
ATOM      7  SD  MET A   1      58.633  38.663  33.292  1.00 41.97           S  
ATOM      8  CE  MET A   1      58.226  38.633  35.044  1.00 41.59           C  
ATOM      9  N   LYS A   2      58.531  43.429  32.832  1.00 38.14           N  
ATOM     10  CA  LYS A   2      58.956  44.036  34.122  1.00 35.94           C  
ATOM     11  C   LYS A   2      58.730  43.257  35.447  1.00 34.28           C  
ATOM     12  O   LYS A   2      57.627  43.221  36.014  1.00 35.09           O  
ATOM     13  CB  LYS A   2      58.453  45.476  34.220  1.00 36.75           C  
ATOM     14  CG  LYS A   2      59.524  46.538  34.058  1.00 36.38           C  
ATOM     15  CD  LYS A   2      58.962  47.793  33.320  1.00 36.34           C  
ATOM     16  CE  LYS A   2      58.323  48.789  34.252  1.00 33.38           C  
ATOM     17  NZ  LYS A   2      57.569  48.134  35.325  1.00 33.39           N  
ATOM     18  N   LYS A   3      59.788  42.624  35.931  1.00 30.85           N  
ATOM     19  CA  LYS A   3      59.792  42.060  37.263  1.00 26.86           C  
ATOM     20  C   LYS A   3      61.127  42.516  37.886  1.00 24.83           C  
ATOM     21  O   LYS A   3      62.211  42.335  37.302  1.00 23.81           O  
ATOM     22  CB  LYS A   3      59.676  40.533  37.189  1.00 26.85           C  
ATOM     23  CG  LYS A   3      59.666  39.776  38.526  1.00 27.72           C  
ATOM     24  N   ILE A   4      61.028  43.137  39.055  1.00 22.07           N  
ATOM     25  CA  ILE A   4      62.177  43.490  39.868  1.00 19.34           C  
ATOM     26  C   ILE A   4      62.881  42.249  40.438  1.00 20.25           C  
ATOM     27  O   ILE A   4      62.220  41.397  41.060  1.00 19.85           O  
ATOM     28  CB  ILE A   4      61.789  44.432  41.015  1.00 18.18           C  
ATOM     29  CG1 ILE A   4      61.264  45.747  40.432  1.00 17.68           C  
ATOM     30  CG2 ILE A   4      62.966  44.632  41.950  1.00 13.90           C  
ATOM     31  CD1 ILE A   4      60.925  46.858  41.455  1.00 17.46           C  
ATOM     32  N   ILE A   5      64.201  42.168  40.218  1.00 19.44           N  
ATOM     33  CA  ILE A   5      65.024  41.120  40.791  1.00 20.52           C  
ATOM     34  C   ILE A   5      65.661  41.599  42.101  1.00 21.42           C  
ATOM     35  O   ILE A   5      66.268  42.661  42.163  1.00 21.29           O  
ATOM     36  CB  ILE A   5      66.076  40.568  39.790  1.00 19.70           C  
ATOM     37  CG1 ILE A   5      65.398  39.973  38.552  1.00 21.02           C  
ATOM     38  CG2 ILE A   5      66.923  39.508  40.414  1.00 18.47           C  
ATOM     39  CD1 ILE A   5      66.367  39.899  37.311  1.00 20.96           C  
ATOM     40  N   GLU A   6      65.453  40.813  43.147  1.00 22.78           N  
ATOM     41  CA  GLU A   6      65.882  41.126  44.502  1.00 25.39           C  
ATOM     42  C   GLU A   6      66.556  39.875  45.101  1.00 25.94           C  
ATOM     43  O   GLU A   6      65.964  38.778  45.088  1.00 26.38           O  
ATOM     44  CB  GLU A   6      64.679  41.529  45.356  1.00 25.47           C  
ATOM     45  CG  GLU A   6      65.068  42.246  46.641  1.00 29.65           C  
ATOM     46  CD  GLU A   6      63.932  43.038  47.283  1.00 35.51           C  
ATOM     47  OE1 GLU A   6      62.821  43.181  46.668  1.00 38.67           O  
ATOM     48  OE2 GLU A   6      64.171  43.529  48.413  1.00 36.69           O  
ATOM     49  N   THR A   7      67.794  40.022  45.566  1.00 25.88           N  
ATOM     50  CA  THR A   7      68.500  38.883  46.172  1.00 27.16           C  
ATOM     51  C   THR A   7      69.462  39.253  47.324  1.00 27.96           C  
ATOM     52  O   THR A   7      70.087  40.328  47.327  1.00 28.28           O  
ATOM     53  CB  THR A   7      69.166  37.877  45.127  1.00 26.84           C  
ATOM     54  OG1 THR A   7      69.642  36.735  45.829  1.00 28.45           O  
ATOM     55  CG2 THR A   7      70.320  38.454  44.354  1.00 25.09           C  
ATOM     56  N   GLN A   8      69.520  38.358  48.314  1.00 28.03           N  
ATOM     57  CA  GLN A   8      70.322  38.529  49.522  1.00 27.86           C  
ATOM     58  C   GLN A   8      71.754  38.096  49.176  1.00 27.44           C  
ATOM     59  O   GLN A   8      72.708  38.475  49.871  1.00 27.48           O  
ATOM     60  CB  GLN A   8      69.710  37.722  50.696  1.00 27.65           C  
ATOM     61  N   ARG A   9      71.866  37.364  48.066  1.00 26.62           N  
ATOM     62  CA  ARG A   9      73.123  36.842  47.528  1.00 27.36           C  
ATOM     63  C   ARG A   9      73.977  37.851  46.728  1.00 26.83           C  
ATOM     64  O   ARG A   9      75.106  37.539  46.314  1.00 26.70           O  
ATOM     65  CB  ARG A   9      72.834  35.612  46.646  1.00 28.40           C  
ATOM     66  CG  ARG A   9      72.737  34.274  47.391  1.00 31.96           C  
ATOM     67  CD  ARG A   9      71.470  33.532  46.967  1.00 39.29           C  
ATOM     68  NE  ARG A   9      71.351  32.223  47.624  1.00 43.83           N  
ATOM     69  CZ  ARG A   9      70.503  31.262  47.259  1.00 44.73           C  
ATOM     70  NH1 ARG A   9      69.678  31.450  46.221  1.00 43.00           N  
ATOM     71  NH2 ARG A   9      70.485  30.109  47.944  1.00 45.08           N  
ATOM     72  N   ALA A  10      73.422  39.032  46.485  1.00 25.75           N  
ATOM     73  CA  ALA A  10      74.186  40.160  45.980  1.00 26.18           C  
ATOM     74  C   ALA A  10      74.000  41.334  46.970  1.00 26.28           C  
ATOM     75  O   ALA A  10      73.091  41.298  47.823  1.00 25.73           O  
ATOM     76  CB  ALA A  10      73.762  40.520  44.539  1.00 24.79           C  
ATOM     77  N   PRO A  11      74.887  42.341  46.904  1.00 26.38           N  
ATOM     78  CA  PRO A  11      74.848  43.463  47.882  1.00 27.16           C  
ATOM     79  C   PRO A  11      73.578  44.311  47.751  1.00 28.05           C  
ATOM     80  O   PRO A  11      73.097  44.576  46.624  1.00 28.43           O  
ATOM     81  CB  PRO A  11      76.090  44.309  47.546  1.00 26.41           C  
ATOM     82  CG  PRO A  11      76.896  43.489  46.588  1.00 26.52           C  
ATOM     83  CD  PRO A  11      75.976  42.481  45.931  1.00 26.45           C  
ATOM     84  N   GLY A  12      73.042  44.745  48.891  1.00 28.68           N  
ATOM     85  CA  GLY A  12      71.740  45.409  48.884  1.00 29.27           C  
ATOM     86  C   GLY A  12      71.785  46.720  48.133  1.00 29.69           C  
ATOM     87  O   GLY A  12      72.714  47.519  48.294  1.00 28.53           O  
ATOM     88  N   ALA A  13      70.771  46.919  47.298  1.00 31.57           N  
ATOM     89  CA  ALA A  13      70.598  48.170  46.568  1.00 33.53           C  
ATOM     90  C   ALA A  13      70.707  49.291  47.597  1.00 34.37           C  
ATOM     91  O   ALA A  13      69.823  49.472  48.429  1.00 35.80           O  
ATOM     92  CB  ALA A  13      69.248  48.188  45.830  1.00 33.36           C  
ATOM     93  N   ILE A  14      71.844  49.981  47.585  1.00 35.28           N  
ATOM     94  CA  ILE A  14      72.120  51.040  48.559  1.00 34.82           C  
ATOM     95  C   ILE A  14      71.254  52.295  48.207  1.00 34.15           C  
ATOM     96  O   ILE A  14      70.306  52.623  48.944  1.00 34.15           O  
ATOM     97  CB  ILE A  14      73.734  51.229  48.758  1.00 35.97           C  
ATOM     98  CG1 ILE A  14      74.141  51.131  50.236  1.00 36.50           C  
ATOM     99  CG2 ILE A  14      74.360  52.455  48.026  1.00 36.73           C  
ATOM    100  CD1 ILE A  14      75.660  51.281  50.463  1.00 36.69           C  
ATOM    101  N   GLY A  15      71.519  52.926  47.052  1.00 32.43           N  
ATOM    102  CA  GLY A  15      70.723  54.086  46.563  1.00 29.97           C  
ATOM    103  C   GLY A  15      69.508  53.748  45.702  1.00 25.49           C  
ATOM    104  O   GLY A  15      68.973  52.651  45.794  1.00 24.75           O  
ATOM    105  N   PRO A  16      69.074  54.705  44.859  1.00 22.68           N  
ATOM    106  CA  PRO A  16      67.823  54.565  44.102  1.00 21.36           C  
ATOM    107  C   PRO A  16      67.965  53.682  42.831  1.00 19.71           C  
ATOM    108  O   PRO A  16      67.918  54.196  41.691  1.00 18.65           O  
ATOM    109  CB  PRO A  16      67.453  56.023  43.763  1.00 20.96           C  
ATOM    110  CG  PRO A  16      68.749  56.741  43.763  1.00 21.16           C  
ATOM    111  CD  PRO A  16      69.746  55.975  44.565  1.00 21.67           C  
ATOM    112  N   TYR A  17      68.144  52.382  43.049  1.00 17.19           N  
ATOM    113  CA  TYR A  17      68.151  51.401  41.966  1.00 16.96           C  
ATOM    114  C   TYR A  17      67.687  50.018  42.450  1.00 15.98           C  
ATOM    115  O   TYR A  17      67.646  49.742  43.654  1.00 16.50           O  
ATOM    116  CB  TYR A  17      69.538  51.304  41.269  1.00 17.11           C  
ATOM    117  CG  TYR A  17      70.643  50.988  42.242  1.00 17.96           C  
ATOM    118  CD1 TYR A  17      70.968  49.676  42.567  1.00 16.77           C  
ATOM    119  CD2 TYR A  17      71.331  52.024  42.894  1.00 18.12           C  
ATOM    120  CE1 TYR A  17      71.962  49.410  43.498  1.00 16.39           C  
ATOM    121  CE2 TYR A  17      72.299  51.769  43.812  1.00 16.79           C  
ATOM    122  CZ  TYR A  17      72.620  50.464  44.107  1.00 18.14           C  
ATOM    123  OH  TYR A  17      73.625  50.247  45.043  1.00 23.87           O  
ATOM    124  N   VAL A  18      67.367  49.141  41.503  1.00 14.64           N  
ATOM    125  CA  VAL A  18      67.115  47.754  41.825  1.00 13.52           C  
ATOM    126  C   VAL A  18      68.302  46.980  41.316  1.00 13.74           C  
ATOM    127  O   VAL A  18      68.971  47.426  40.388  1.00 14.03           O  
ATOM    128  CB  VAL A  18      65.691  47.263  41.278  1.00 13.88           C  
ATOM    129  CG1 VAL A  18      64.552  48.164  41.882  1.00 12.13           C  
ATOM    130  CG2 VAL A  18      65.579  47.301  39.721  1.00 11.83           C  
ATOM    131  N   GLN A  19      68.572  45.806  41.890  1.00 13.87           N  
ATOM    132  CA  GLN A  19      69.682  44.978  41.437  1.00 13.42           C  
ATOM    133  C   GLN A  19      69.553  44.462  40.007  1.00 12.53           C  
ATOM    134  O   GLN A  19      70.538  44.356  39.296  1.00 13.19           O  
ATOM    135  CB  GLN A  19      69.882  43.799  42.380  1.00 13.97           C  
ATOM    136  CG  GLN A  19      70.263  44.152  43.811  1.00 15.53           C  
ATOM    137  CD  GLN A  19      70.120  42.956  44.767  1.00 15.73           C  
ATOM    138  OE1 GLN A  19      69.152  42.168  44.670  1.00 19.43           O  
ATOM    139  NE2 GLN A  19      71.094  42.794  45.666  1.00 11.67           N  
ATOM    140  N   GLY A  20      68.353  44.074  39.597  1.00 12.53           N  
ATOM    141  CA  GLY A  20      68.131  43.476  38.289  1.00 10.69           C  
ATOM    142  C   GLY A  20      66.692  43.709  37.907  1.00 11.70           C  
ATOM    143  O   GLY A  20      65.858  43.973  38.777  1.00 10.71           O  
ATOM    144  N   VAL A  21      66.422  43.648  36.600  1.00 12.68           N  
ATOM    145  CA  VAL A  21      65.072  43.611  36.045  1.00 14.68           C  
ATOM    146  C   VAL A  21      64.987  42.523  34.992  1.00 15.71           C  
ATOM    147  O   VAL A  21      65.904  42.300  34.183  1.00 16.11           O  
ATOM    148  CB  VAL A  21      64.584  44.922  35.344  1.00 15.03           C  
ATOM    149  CG1 VAL A  21      63.080  45.039  35.501  1.00 13.41           C  
ATOM    150  CG2 VAL A  21      65.175  46.112  35.983  1.00 17.13           C  
ATOM    151  N   ASP A  22      63.843  41.864  35.010  1.00 16.88           N  
ATOM    152  CA  ASP A  22      63.572  40.714  34.192  1.00 17.43           C  
ATOM    153  C   ASP A  22      62.400  41.167  33.308  1.00 18.07           C  
ATOM    154  O   ASP A  22      61.310  41.540  33.790  1.00 18.42           O  
ATOM    155  CB  ASP A  22      63.278  39.528  35.129  1.00 16.53           C  
ATOM    156  CG  ASP A  22      62.984  38.229  34.397  1.00 18.03           C  
ATOM    157  OD1 ASP A  22      62.868  38.204  33.167  1.00 18.82           O  
ATOM    158  OD2 ASP A  22      62.827  37.196  35.086  1.00 20.76           O  
ATOM    159  N   LEU A  23      62.683  41.222  32.015  1.00 19.51           N  
ATOM    160  CA  LEU A  23      61.745  41.658  30.999  1.00 20.35           C  
ATOM    161  C   LEU A  23      61.162  40.469  30.261  1.00 21.05           C  
ATOM    162  O   LEU A  23      60.582  40.655  29.220  1.00 22.38           O  
ATOM    163  CB  LEU A  23      62.459  42.536  29.971  1.00 20.61           C  
ATOM    164  CG  LEU A  23      63.323  43.747  30.384  1.00 21.44           C  
ATOM    165  CD1 LEU A  23      63.853  44.400  29.105  1.00 21.38           C  
ATOM    166  CD2 LEU A  23      62.488  44.729  31.171  1.00 22.29           C  
ATOM    167  N   GLY A  24      61.325  39.254  30.778  1.00 21.37           N  
ATOM    168  CA  GLY A  24      60.899  38.046  30.076  1.00 22.34           C  
ATOM    169  C   GLY A  24      61.956  37.451  29.139  1.00 23.21           C  
ATOM    170  O   GLY A  24      62.584  36.447  29.444  1.00 23.74           O  
ATOM    171  N   SER A  25      62.141  38.067  27.986  1.00 23.15           N  
ATOM    172  CA  SER A  25      63.171  37.668  27.027  1.00 23.64           C  
ATOM    173  C   SER A  25      64.607  38.063  27.473  1.00 23.30           C  
ATOM    174  O   SER A  25      65.564  37.374  27.139  1.00 23.34           O  
ATOM    175  CB  SER A  25      62.870  38.385  25.707  1.00 24.11           C  
ATOM    176  OG  SER A  25      62.752  39.786  25.961  1.00 26.14           O  
ATOM    177  N   MET A  26      64.727  39.200  28.177  1.00 22.42           N  
ATOM    178  CA  MET A  26      65.979  39.791  28.604  1.00 22.33           C  
ATOM    179  C   MET A  26      66.033  40.115  30.085  1.00 20.07           C  
ATOM    180  O   MET A  26      65.049  40.515  30.670  1.00 18.93           O  
ATOM    181  CB  MET A  26      66.215  41.102  27.862  1.00 22.46           C  
ATOM    182  CG  MET A  26      66.249  40.986  26.361  1.00 25.34           C  
ATOM    183  SD  MET A  26      66.791  42.540  25.593  1.00 26.45           S  
ATOM    184  CE  MET A  26      68.423  42.708  26.271  1.00 20.49           C  
ATOM    185  N   VAL A  27      67.220  39.983  30.679  1.00 19.45           N  
ATOM    186  CA  VAL A  27      67.485  40.476  32.055  1.00 17.17           C  
ATOM    187  C   VAL A  27      68.636  41.508  32.043  1.00 16.19           C  
ATOM    188  O   VAL A  27      69.654  41.265  31.402  1.00 16.36           O  
ATOM    189  CB  VAL A  27      67.770  39.267  33.020  1.00 17.55           C  
ATOM    190  CG1 VAL A  27      68.412  39.675  34.357  1.00 14.47           C  
ATOM    191  CG2 VAL A  27      66.511  38.420  33.230  1.00 15.52           C  
ATOM    192  N   PHE A  28      68.470  42.636  32.753  1.00 14.51           N  
ATOM    193  CA  PHE A  28      69.527  43.649  32.938  1.00 12.59           C  
ATOM    194  C   PHE A  28      69.915  43.680  34.392  1.00 11.55           C  
ATOM    195  O   PHE A  28      69.047  43.721  35.226  1.00 10.70           O  
ATOM    196  CB  PHE A  28      69.034  45.048  32.575  1.00 12.33           C  
ATOM    197  CG  PHE A  28      68.827  45.261  31.103  1.00 15.17           C  
ATOM    198  CD1 PHE A  28      67.692  44.713  30.440  1.00 14.33           C  
ATOM    199  CD2 PHE A  28      69.738  46.032  30.373  1.00 12.07           C  
ATOM    200  CE1 PHE A  28      67.503  44.915  29.059  1.00 12.19           C  
ATOM    201  CE2 PHE A  28      69.543  46.238  29.023  1.00 13.73           C  
ATOM    202  CZ  PHE A  28      68.412  45.675  28.362  1.00 11.32           C  
ATOM    203  N   THR A  29      71.212  43.655  34.693  1.00 11.09           N  
ATOM    204  CA  THR A  29      71.684  43.873  36.076  1.00 11.26           C  
ATOM    205  C   THR A  29      72.108  45.350  36.232  1.00 10.94           C  
ATOM    206  O   THR A  29      72.539  45.974  35.239  1.00 11.57           O  
ATOM    207  CB  THR A  29      72.913  42.992  36.465  1.00 10.81           C  
ATOM    208  OG1 THR A  29      74.089  43.525  35.845  1.00 10.36           O  
ATOM    209  CG2 THR A  29      72.730  41.513  36.110  1.00  9.65           C  
ATOM    210  N   SER A  30      71.950  45.915  37.434  1.00 10.51           N  
ATOM    211  CA  SER A  30      72.736  47.109  37.826  1.00 11.27           C  
ATOM    212  C   SER A  30      74.270  46.820  37.701  1.00 11.10           C  
ATOM    213  O   SER A  30      74.679  45.644  37.666  1.00 12.27           O  
ATOM    214  CB  SER A  30      72.353  47.591  39.230  1.00 10.79           C  
ATOM    215  OG  SER A  30      71.171  48.401  39.187  1.00 12.98           O  
ATOM    216  N   GLY A  31      75.093  47.863  37.577  1.00 10.00           N  
ATOM    217  CA  GLY A  31      76.537  47.713  37.620  1.00 10.20           C  
ATOM    218  C   GLY A  31      76.953  47.176  38.960  1.00 10.48           C  
ATOM    219  O   GLY A  31      76.653  47.787  39.989  1.00 11.72           O  
ATOM    220  N   GLN A  32      77.619  46.020  38.963  1.00 11.35           N  
ATOM    221  CA  GLN A  32      78.017  45.320  40.194  1.00 11.64           C  
ATOM    222  C   GLN A  32      79.450  45.679  40.582  1.00 12.58           C  
ATOM    223  O   GLN A  32      80.364  45.569  39.776  1.00 12.65           O  
ATOM    224  CB  GLN A  32      77.896  43.794  40.010  1.00 12.63           C  
ATOM    225  CG  GLN A  32      76.461  43.270  39.917  1.00 10.88           C  
ATOM    226  CD  GLN A  32      75.565  43.935  40.920  1.00 13.23           C  
ATOM    227  OE1 GLN A  32      75.760  43.815  42.146  1.00 13.81           O  
ATOM    228  NE2 GLN A  32      74.565  44.648  40.419  1.00  9.77           N  
ATOM    229  N   ILE A  33      79.621  46.165  41.813  1.00 13.30           N  
ATOM    230  CA  ILE A  33      80.924  46.479  42.359  1.00 12.34           C  
ATOM    231  C   ILE A  33      81.340  45.362  43.353  1.00 13.87           C  
ATOM    232  O   ILE A  33      80.487  44.561  43.783  1.00 14.83           O  
ATOM    233  CB  ILE A  33      80.961  47.920  42.929  1.00 11.79           C  
ATOM    234  CG1 ILE A  33      79.976  48.114  44.075  1.00 12.67           C  
ATOM    235  CG2 ILE A  33      80.625  48.927  41.819  1.00 11.24           C  
ATOM    236  CD1 ILE A  33      80.095  49.425  44.783  1.00 10.40           C  
ATOM    237  N   PRO A  34      82.660  45.227  43.638  1.00 14.63           N  
ATOM    238  CA  PRO A  34      83.114  44.220  44.619  1.00 15.13           C  
ATOM    239  C   PRO A  34      82.743  44.527  46.074  1.00 17.30           C  
ATOM    240  O   PRO A  34      83.639  44.818  46.898  1.00 17.54           O  
ATOM    241  CB  PRO A  34      84.638  44.247  44.451  1.00 15.45           C  
ATOM    242  CG  PRO A  34      84.940  45.614  43.861  1.00 13.38           C  
ATOM    243  CD  PRO A  34      83.794  45.914  42.973  1.00 13.25           C  
ATOM    244  N   VAL A  35      81.447  44.505  46.395  1.00 18.95           N  
ATOM    245  CA  VAL A  35      81.004  44.673  47.782  1.00 20.69           C  
ATOM    246  C   VAL A  35      80.491  43.330  48.284  1.00 21.78           C  
ATOM    247  O   VAL A  35      79.726  42.673  47.621  1.00 21.39           O  
ATOM    248  CB  VAL A  35      79.962  45.800  47.984  1.00 21.47           C  
ATOM    249  CG1 VAL A  35      79.448  45.767  49.450  1.00 20.77           C  
ATOM    250  CG2 VAL A  35      80.577  47.199  47.682  1.00 18.79           C  
HETATM  251  N   OCS A  36      80.988  42.879  49.421  1.00 24.28           N  
HETATM  252  CA  OCS A  36      80.606  41.566  49.875  1.00 24.71           C  
HETATM  253  CB  OCS A  36      81.603  41.037  50.915  1.00 26.14           C  
HETATM  254  SG  OCS A  36      81.341  39.286  51.395  1.00 29.11           S  
HETATM  255  C   OCS A  36      79.143  41.599  50.341  1.00 24.81           C  
HETATM  256  O   OCS A  36      78.784  42.409  51.197  1.00 24.51           O  
HETATM  257  OD1 OCS A  36      82.359  38.897  52.312  1.00 35.47           O  
HETATM  258  OD2 OCS A  36      80.058  39.194  52.079  1.00 30.82           O  
HETATM  259  OD3 OCS A  36      81.430  38.395  50.233  1.00 31.67           O  
ATOM    260  N   PRO A  37      78.279  40.749  49.739  1.00 25.22           N  
ATOM    261  CA  PRO A  37      76.829  40.790  50.026  1.00 26.32           C  
ATOM    262  C   PRO A  37      76.504  40.657  51.524  1.00 28.00           C  
ATOM    263  O   PRO A  37      75.716  41.454  52.048  1.00 27.84           O  
ATOM    264  CB  PRO A  37      76.245  39.616  49.235  1.00 25.52           C  
ATOM    265  CG  PRO A  37      77.387  38.859  48.712  1.00 26.07           C  
ATOM    266  CD  PRO A  37      78.636  39.693  48.775  1.00 24.68           C  
ATOM    267  N   GLN A  38      77.145  39.697  52.200  1.00 29.93           N  
ATOM    268  CA  GLN A  38      76.975  39.487  53.656  1.00 31.70           C  
ATOM    269  C   GLN A  38      77.666  40.526  54.610  1.00 31.49           C  
ATOM    270  O   GLN A  38      77.100  40.897  55.654  1.00 31.88           O  
ATOM    271  CB  GLN A  38      77.363  38.037  54.062  1.00 31.98           C  
ATOM    272  CG  GLN A  38      76.748  36.878  53.255  1.00 36.05           C  
ATOM    273  CD  GLN A  38      75.241  37.032  52.912  1.00 41.26           C  
ATOM    274  OE1 GLN A  38      74.448  37.594  53.700  1.00 43.31           O  
ATOM    275  NE2 GLN A  38      74.843  36.502  51.729  1.00 40.23           N  
ATOM    276  N   THR A  39      78.873  40.988  54.286  1.00 30.66           N  
ATOM    277  CA  THR A  39      79.594  41.874  55.229  1.00 30.04           C  
ATOM    278  C   THR A  39      79.749  43.360  54.830  1.00 29.71           C  
ATOM    279  O   THR A  39      80.134  44.191  55.663  1.00 30.29           O  
ATOM    280  CB  THR A  39      80.958  41.298  55.581  1.00 29.63           C  
ATOM    281  OG1 THR A  39      81.863  41.528  54.499  1.00 30.53           O  
ATOM    282  CG2 THR A  39      80.837  39.797  55.779  1.00 29.59           C  
ATOM    283  N   GLY A  40      79.443  43.705  53.576  1.00 28.51           N  
ATOM    284  CA  GLY A  40      79.714  45.061  53.067  1.00 26.26           C  
ATOM    285  C   GLY A  40      81.189  45.401  52.824  1.00 25.68           C  
ATOM    286  O   GLY A  40      81.480  46.516  52.441  1.00 25.54           O  
ATOM    287  N   GLU A  41      82.117  44.448  53.024  1.00 24.51           N  
ATOM    288  CA  GLU A  41      83.556  44.702  52.830  1.00 23.31           C  
ATOM    289  C   GLU A  41      83.980  44.748  51.366  1.00 22.60           C  
ATOM    290  O   GLU A  41      83.427  44.023  50.526  1.00 22.72           O  
ATOM    291  CB  GLU A  41      84.427  43.663  53.566  1.00 23.67           C  
ATOM    292  N   ILE A  42      84.969  45.597  51.061  1.00 20.97           N  
ATOM    293  CA  ILE A  42      85.602  45.579  49.739  1.00 19.69           C  
ATOM    294  C   ILE A  42      86.958  44.849  49.819  1.00 19.30           C  
ATOM    295  O   ILE A  42      87.864  45.280  50.567  1.00 19.17           O  
ATOM    296  CB  ILE A  42      85.720  47.035  49.140  1.00 19.94           C  
ATOM    297  CG1 ILE A  42      84.306  47.584  48.828  1.00 18.96           C  
ATOM    298  CG2 ILE A  42      86.708  47.105  47.924  1.00 17.95           C  
ATOM    299  CD1 ILE A  42      84.138  49.067  49.073  1.00 13.58           C  
ATOM    300  N   PRO A  43      87.111  43.724  49.088  1.00 18.90           N  
ATOM    301  CA  PRO A  43      88.463  43.104  49.173  1.00 18.09           C  
ATOM    302  C   PRO A  43      89.510  44.023  48.552  1.00 18.40           C  
ATOM    303  O   PRO A  43      89.218  44.771  47.609  1.00 18.24           O  
ATOM    304  CB  PRO A  43      88.317  41.792  48.389  1.00 18.01           C  
ATOM    305  CG  PRO A  43      87.055  41.926  47.563  1.00 17.00           C  
ATOM    306  CD  PRO A  43      86.179  42.974  48.221  1.00 17.98           C  
ATOM    307  N   ALA A  44      90.715  44.001  49.102  1.00 18.82           N  
ATOM    308  CA  ALA A  44      91.770  44.914  48.675  1.00 18.32           C  
ATOM    309  C   ALA A  44      92.418  44.529  47.352  1.00 18.32           C  
ATOM    310  O   ALA A  44      92.674  45.415  46.546  1.00 18.03           O  
ATOM    311  CB  ALA A  44      92.814  45.102  49.786  1.00 18.28           C  
ATOM    312  N   ASP A  45      92.658  43.229  47.114  1.00 18.67           N  
ATOM    313  CA  ASP A  45      93.343  42.754  45.900  1.00 19.13           C  
ATOM    314  C   ASP A  45      92.434  42.790  44.693  1.00 18.02           C  
ATOM    315  O   ASP A  45      91.251  42.408  44.796  1.00 17.30           O  
ATOM    316  CB  ASP A  45      93.805  41.281  46.031  1.00 20.59           C  
ATOM    317  CG  ASP A  45      95.027  41.096  46.936  1.00 27.58           C  
ATOM    318  OD1 ASP A  45      95.476  42.058  47.668  1.00 30.56           O  
ATOM    319  OD2 ASP A  45      95.536  39.930  46.915  1.00 33.77           O  
ATOM    320  N   VAL A  46      92.993  43.182  43.548  1.00 16.95           N  
ATOM    321  CA  VAL A  46      92.237  43.218  42.299  1.00 16.89           C  
ATOM    322  C   VAL A  46      91.681  41.857  41.835  1.00 17.41           C  
ATOM    323  O   VAL A  46      90.600  41.812  41.192  1.00 19.01           O  
ATOM    324  CB  VAL A  46      92.992  43.978  41.145  1.00 17.57           C  
ATOM    325  CG1 VAL A  46      94.106  43.118  40.467  1.00 14.51           C  
ATOM    326  CG2 VAL A  46      91.992  44.503  40.130  1.00 17.17           C  
ATOM    327  N   GLN A  47      92.373  40.768  42.162  1.00 16.17           N  
ATOM    328  CA  GLN A  47      91.896  39.384  41.876  1.00 16.34           C  
ATOM    329  C   GLN A  47      90.577  39.067  42.608  1.00 15.65           C  
ATOM    330  O   GLN A  47      89.591  38.624  42.040  1.00 14.33           O  
ATOM    331  CB  GLN A  47      92.976  38.339  42.261  1.00 15.67           C  
ATOM    332  N   ASP A  48      90.590  39.320  43.902  1.00 15.95           N  
ATOM    333  CA  ASP A  48      89.400  39.159  44.705  1.00 15.99           C  
ATOM    334  C   ASP A  48      88.274  40.156  44.325  1.00 15.33           C  
ATOM    335  O   ASP A  48      87.104  39.775  44.337  1.00 15.23           O  
ATOM    336  CB  ASP A  48      89.754  39.206  46.193  1.00 15.97           C  
ATOM    337  CG  ASP A  48      90.808  38.182  46.583  1.00 17.69           C  
ATOM    338  OD1 ASP A  48      90.804  37.018  46.083  1.00 16.80           O  
ATOM    339  OD2 ASP A  48      91.654  38.557  47.428  1.00 22.34           O  
ATOM    340  N   GLN A  49      88.626  41.396  43.979  1.00 14.68           N  
ATOM    341  CA  GLN A  49      87.643  42.352  43.477  1.00 14.61           C  
ATOM    342  C   GLN A  49      86.979  41.903  42.190  1.00 14.59           C  
ATOM    343  O   GLN A  49      85.763  42.020  42.060  1.00 14.80           O  
ATOM    344  CB  GLN A  49      88.245  43.743  43.271  1.00 14.45           C  
ATOM    345  CG  GLN A  49      88.540  44.457  44.580  1.00 15.73           C  
ATOM    346  CD  GLN A  49      88.556  45.958  44.453  1.00 17.35           C  
ATOM    347  OE1 GLN A  49      88.017  46.537  43.497  1.00 20.04           O  
ATOM    348  NE2 GLN A  49      89.158  46.608  45.423  1.00 15.14           N  
ATOM    349  N   ALA A  50      87.786  41.446  41.233  1.00 14.73           N  
ATOM    350  CA  ALA A  50      87.295  40.922  39.958  1.00 15.25           C  
ATOM    351  C   ALA A  50      86.340  39.722  40.153  1.00 15.56           C  
ATOM    352  O   ALA A  50      85.259  39.666  39.557  1.00 15.92           O  
ATOM    353  CB  ALA A  50      88.457  40.540  39.071  1.00 14.25           C  
ATOM    354  N   ARG A  51      86.783  38.772  40.967  1.00 16.24           N  
ATOM    355  CA  ARG A  51      86.033  37.608  41.344  1.00 16.80           C  
ATOM    356  C   ARG A  51      84.743  37.970  42.050  1.00 16.11           C  
ATOM    357  O   ARG A  51      83.699  37.382  41.756  1.00 18.02           O  
ATOM    358  CB  ARG A  51      86.883  36.654  42.213  1.00 17.28           C  
ATOM    359  CG  ARG A  51      86.086  35.351  42.536  1.00 22.40           C  
ATOM    360  CD  ARG A  51      86.320  34.332  41.427  1.00 31.78           C  
ATOM    361  NE  ARG A  51      85.192  33.471  41.077  1.00 35.38           N  
ATOM    362  CZ  ARG A  51      85.269  32.523  40.137  1.00 39.56           C  
ATOM    363  NH1 ARG A  51      86.421  32.313  39.462  1.00 38.73           N  
ATOM    364  NH2 ARG A  51      84.201  31.780  39.859  1.00 40.42           N  
ATOM    365  N   LEU A  52      84.790  38.925  42.963  1.00 14.90           N  
ATOM    366  CA  LEU A  52      83.588  39.314  43.690  1.00 14.14           C  
ATOM    367  C   LEU A  52      82.529  40.029  42.830  1.00 13.94           C  
ATOM    368  O   LEU A  52      81.352  39.737  43.003  1.00 14.12           O  
ATOM    369  CB  LEU A  52      83.903  40.058  45.012  1.00 14.18           C  
ATOM    370  CG  LEU A  52      82.743  40.544  45.904  1.00 15.01           C  
ATOM    371  CD1 LEU A  52      81.704  39.416  46.347  1.00 13.73           C  
ATOM    372  CD2 LEU A  52      83.265  41.249  47.128  1.00 12.21           C  
ATOM    373  N   SER A  53      82.904  40.923  41.908  1.00 13.70           N  
ATOM    374  CA  SER A  53      81.875  41.551  41.064  1.00 13.41           C  
ATOM    375  C   SER A  53      81.218  40.551  40.215  1.00 12.48           C  
ATOM    376  O   SER A  53      80.043  40.611  40.068  1.00 14.02           O  
ATOM    377  CB  SER A  53      82.368  42.622  40.091  1.00 13.59           C  
ATOM    378  OG  SER A  53      83.457  43.239  40.607  1.00 17.90           O  
ATOM    379  N   LEU A  54      81.990  39.664  39.597  1.00 12.97           N  
ATOM    380  CA  LEU A  54      81.427  38.571  38.783  1.00 12.34           C  
ATOM    381  C   LEU A  54      80.430  37.694  39.533  1.00 12.66           C  
ATOM    382  O   LEU A  54      79.406  37.333  38.965  1.00 15.09           O  
ATOM    383  CB  LEU A  54      82.524  37.742  38.170  1.00 11.77           C  
ATOM    384  CG  LEU A  54      83.277  38.449  37.053  1.00  9.19           C  
ATOM    385  CD1 LEU A  54      84.592  37.724  36.733  1.00  7.94           C  
ATOM    386  CD2 LEU A  54      82.405  38.615  35.818  1.00  6.66           C  
ATOM    387  N   GLU A  55      80.696  37.416  40.801  1.00 13.03           N  
ATOM    388  CA  GLU A  55      79.830  36.633  41.706  1.00 13.89           C  
ATOM    389  C   GLU A  55      78.557  37.358  42.029  1.00 13.99           C  
ATOM    390  O   GLU A  55      77.497  36.745  42.160  1.00 14.36           O  
ATOM    391  CB  GLU A  55      80.546  36.313  43.042  1.00 13.79           C  
ATOM    392  CG  GLU A  55      81.575  35.160  42.993  1.00 16.81           C  
ATOM    393  CD  GLU A  55      80.941  33.878  42.426  1.00 24.38           C  
ATOM    394  OE1 GLU A  55      80.058  33.289  43.122  1.00 28.05           O  
ATOM    395  OE2 GLU A  55      81.275  33.491  41.278  1.00 25.53           O  
ATOM    396  N   ASN A  56      78.664  38.674  42.196  1.00 14.43           N  
ATOM    397  CA  ASN A  56      77.508  39.515  42.400  1.00 13.27           C  
ATOM    398  C   ASN A  56      76.636  39.566  41.172  1.00 13.73           C  
ATOM    399  O   ASN A  56      75.416  39.568  41.304  1.00 13.79           O  
ATOM    400  CB  ASN A  56      77.951  40.912  42.763  1.00 14.13           C  
ATOM    401  CG  ASN A  56      78.349  41.021  44.157  1.00 11.95           C  
ATOM    402  OD1 ASN A  56      78.005  40.164  44.972  1.00 17.42           O  
ATOM    403  ND2 ASN A  56      79.091  42.074  44.481  1.00 10.17           N  
ATOM    404  N   VAL A  57      77.246  39.608  39.983  1.00 13.41           N  
ATOM    405  CA  VAL A  57      76.482  39.574  38.696  1.00 13.51           C  
ATOM    406  C   VAL A  57      75.692  38.231  38.586  1.00 14.35           C  
ATOM    407  O   VAL A  57      74.474  38.218  38.267  1.00 14.50           O  
ATOM    408  CB  VAL A  57      77.422  39.754  37.430  1.00 13.07           C  
ATOM    409  CG1 VAL A  57      76.697  39.359  36.178  1.00 11.42           C  
ATOM    410  CG2 VAL A  57      77.959  41.201  37.281  1.00 12.49           C  
ATOM    411  N   LYS A  58      76.429  37.132  38.830  1.00 13.73           N  
ATOM    412  CA  LYS A  58      75.933  35.761  38.934  1.00 13.59           C  
ATOM    413  C   LYS A  58      74.716  35.668  39.835  1.00 13.14           C  
ATOM    414  O   LYS A  58      73.717  35.110  39.438  1.00 14.42           O  
ATOM    415  CB  LYS A  58      77.032  34.821  39.500  1.00 12.91           C  
ATOM    416  CG  LYS A  58      76.631  33.327  39.388  1.00 15.61           C  
ATOM    417  CD  LYS A  58      77.508  32.350  40.184  1.00 14.59           C  
ATOM    418  CE  LYS A  58      76.978  32.212  41.600  1.00 17.93           C  
ATOM    419  NZ  LYS A  58      78.027  31.674  42.526  1.00 14.90           N  
ATOM    420  N   ALA A  59      74.808  36.195  41.054  1.00 13.21           N  
ATOM    421  CA  ALA A  59      73.727  36.097  42.024  1.00 13.50           C  
ATOM    422  C   ALA A  59      72.418  36.691  41.484  1.00 13.97           C  
ATOM    423  O   ALA A  59      71.344  36.107  41.674  1.00 15.01           O  
ATOM    424  CB  ALA A  59      74.109  36.799  43.310  1.00 13.94           C  
ATOM    425  N   ILE A  60      72.498  37.859  40.852  1.00 12.84           N  
ATOM    426  CA  ILE A  60      71.313  38.501  40.295  1.00 12.25           C  
ATOM    427  C   ILE A  60      70.742  37.756  39.078  1.00 12.98           C  
ATOM    428  O   ILE A  60      69.542  37.669  38.931  1.00 13.33           O  
ATOM    429  CB  ILE A  60      71.605  39.963  39.946  1.00 12.16           C  
ATOM    430  CG1 ILE A  60      72.031  40.727  41.216  1.00 11.38           C  
ATOM    431  CG2 ILE A  60      70.382  40.614  39.264  1.00 10.85           C  
ATOM    432  CD1 ILE A  60      72.795  41.977  40.940  1.00  8.12           C  
ATOM    433  N   VAL A  61      71.618  37.249  38.213  1.00 13.77           N  
ATOM    434  CA  VAL A  61      71.233  36.551  36.999  1.00 15.16           C  
ATOM    435  C   VAL A  61      70.528  35.197  37.353  1.00 16.60           C  
ATOM    436  O   VAL A  61      69.502  34.860  36.753  1.00 18.23           O  
ATOM    437  CB  VAL A  61      72.446  36.374  36.075  1.00 14.32           C  
ATOM    438  CG1 VAL A  61      72.163  35.390  34.930  1.00 16.27           C  
ATOM    439  CG2 VAL A  61      72.863  37.699  35.518  1.00 14.52           C  
ATOM    440  N   VAL A  62      71.085  34.482  38.335  1.00 16.46           N  
ATOM    441  CA  VAL A  62      70.499  33.299  38.954  1.00 16.25           C  
ATOM    442  C   VAL A  62      69.189  33.566  39.705  1.00 16.21           C  
ATOM    443  O   VAL A  62      68.278  32.766  39.627  1.00 17.48           O  
ATOM    444  CB  VAL A  62      71.519  32.636  39.914  1.00 16.59           C  
ATOM    445  CG1 VAL A  62      70.857  31.536  40.786  1.00 16.01           C  
ATOM    446  CG2 VAL A  62      72.721  32.100  39.148  1.00 13.61           C  
ATOM    447  N   ALA A  63      69.075  34.655  40.450  1.00 15.98           N  
ATOM    448  CA  ALA A  63      67.801  34.974  41.112  1.00 16.30           C  
ATOM    449  C   ALA A  63      66.635  35.139  40.094  1.00 17.05           C  
ATOM    450  O   ALA A  63      65.484  34.947  40.468  1.00 17.96           O  
ATOM    451  CB  ALA A  63      67.932  36.202  42.006  1.00 14.84           C  
ATOM    452  N   ALA A  64      66.953  35.500  38.838  1.00 17.04           N  
ATOM    453  CA  ALA A  64      65.984  35.622  37.747  1.00 17.46           C  
ATOM    454  C   ALA A  64      65.584  34.307  37.066  1.00 17.61           C  
ATOM    455  O   ALA A  64      64.746  34.315  36.136  1.00 17.43           O  
ATOM    456  CB  ALA A  64      66.496  36.575  36.689  1.00 17.56           C  
ATOM    457  N   GLY A  65      66.198  33.198  37.482  1.00 17.15           N  
ATOM    458  CA  GLY A  65      65.953  31.911  36.818  1.00 16.99           C  
ATOM    459  C   GLY A  65      66.919  31.601  35.695  1.00 17.50           C  
ATOM    460  O   GLY A  65      66.682  30.687  34.900  1.00 17.87           O  
ATOM    461  N   LEU A  66      68.040  32.329  35.632  1.00 17.41           N  
ATOM    462  CA  LEU A  66      68.979  32.121  34.538  1.00 16.27           C  
ATOM    463  C   LEU A  66      70.292  31.601  35.076  1.00 17.12           C  
ATOM    464  O   LEU A  66      70.395  31.245  36.253  1.00 16.46           O  
ATOM    465  CB  LEU A  66      69.135  33.392  33.702  1.00 15.16           C  
ATOM    466  CG  LEU A  66      67.873  33.882  32.985  1.00 15.05           C  
ATOM    467  CD1 LEU A  66      68.192  35.075  32.132  1.00 13.56           C  
ATOM    468  CD2 LEU A  66      67.211  32.785  32.132  1.00 14.72           C  
ATOM    469  N   SER A  67      71.296  31.547  34.207  1.00 17.60           N  
ATOM    470  CA  SER A  67      72.624  31.170  34.627  1.00 18.48           C  
ATOM    471  C   SER A  67      73.654  32.057  33.894  1.00 18.53           C  
ATOM    472  O   SER A  67      73.295  32.793  32.981  1.00 19.30           O  
ATOM    473  CB  SER A  67      72.848  29.664  34.346  1.00 18.70           C  
ATOM    474  OG  SER A  67      72.753  29.364  32.965  1.00 16.92           O  
ATOM    475  N   VAL A  68      74.920  31.968  34.312  1.00 18.08           N  
ATOM    476  CA  VAL A  68      76.044  32.654  33.688  1.00 17.71           C  
ATOM    477  C   VAL A  68      76.159  32.404  32.189  1.00 17.57           C  
ATOM    478  O   VAL A  68      76.584  33.295  31.455  1.00 18.43           O  
ATOM    479  CB  VAL A  68      77.361  32.219  34.320  1.00 17.23           C  
ATOM    480  CG1 VAL A  68      78.529  32.643  33.450  1.00 18.26           C  
ATOM    481  CG2 VAL A  68      77.477  32.798  35.677  1.00 17.20           C  
ATOM    482  N   GLY A  69      75.779  31.211  31.739  1.00 16.49           N  
ATOM    483  CA  GLY A  69      75.806  30.892  30.326  1.00 16.17           C  
ATOM    484  C   GLY A  69      74.763  31.610  29.477  1.00 15.73           C  
ATOM    485  O   GLY A  69      74.802  31.515  28.258  1.00 16.85           O  
ATOM    486  N   ASP A  70      73.835  32.309  30.117  1.00 14.28           N  
ATOM    487  CA  ASP A  70      72.851  33.119  29.425  1.00 14.00           C  
ATOM    488  C   ASP A  70      73.272  34.578  29.239  1.00 14.03           C  
ATOM    489  O   ASP A  70      72.513  35.347  28.583  1.00 13.40           O  
ATOM    490  CB  ASP A  70      71.567  33.131  30.239  1.00 14.03           C  
ATOM    491  CG  ASP A  70      70.923  31.819  30.263  1.00 14.56           C  
ATOM    492  OD1 ASP A  70      70.977  31.127  29.216  1.00 15.66           O  
ATOM    493  OD2 ASP A  70      70.397  31.458  31.326  1.00 18.56           O  
ATOM    494  N   ILE A  71      74.416  34.957  29.864  1.00 12.29           N  
ATOM    495  CA  ILE A  71      74.942  36.314  29.767  1.00 11.59           C  
ATOM    496  C   ILE A  71      75.499  36.568  28.348  1.00 11.69           C  
ATOM    497  O   ILE A  71      76.421  35.901  27.901  1.00 11.52           O  
ATOM    498  CB  ILE A  71      76.022  36.602  30.850  1.00 11.62           C  
ATOM    499  CG1 ILE A  71      75.420  36.530  32.276  1.00 11.50           C  
ATOM    500  CG2 ILE A  71      76.652  37.928  30.608  1.00  8.84           C  
ATOM    501  CD1 ILE A  71      76.508  36.627  33.402  1.00 10.58           C  
ATOM    502  N   ILE A  72      74.934  37.550  27.654  1.00 12.82           N  
ATOM    503  CA  ILE A  72      75.307  37.833  26.260  1.00 12.95           C  
ATOM    504  C   ILE A  72      76.154  39.132  26.108  1.00 13.68           C  
ATOM    505  O   ILE A  72      76.832  39.320  25.089  1.00 12.98           O  
ATOM    506  CB  ILE A  72      74.056  37.834  25.326  1.00 12.44           C  
ATOM    507  CG1 ILE A  72      73.056  38.935  25.717  1.00 13.05           C  
ATOM    508  CG2 ILE A  72      73.384  36.496  25.347  1.00 12.15           C  
ATOM    509  CD1 ILE A  72      73.234  40.229  24.913  1.00 12.63           C  
ATOM    510  N   LYS A  73      76.098  40.008  27.114  1.00 13.71           N  
ATOM    511  CA  LYS A  73      76.796  41.288  27.065  1.00 14.10           C  
ATOM    512  C   LYS A  73      77.257  41.736  28.458  1.00 14.93           C  
ATOM    513  O   LYS A  73      76.495  41.612  29.433  1.00 13.24           O  
ATOM    514  CB  LYS A  73      75.975  42.384  26.347  1.00 15.44           C  
ATOM    515  CG  LYS A  73      76.666  43.823  26.190  1.00 13.87           C  
ATOM    516  CD  LYS A  73      78.102  43.772  25.727  1.00 19.35           C  
ATOM    517  CE  LYS A  73      78.664  45.115  25.192  1.00 22.35           C  
ATOM    518  NZ  LYS A  73      78.291  46.217  26.127  1.00 23.05           N  
ATOM    519  N   MET A  74      78.538  42.165  28.548  1.00 14.41           N  
ATOM    520  CA  MET A  74      79.040  42.830  29.754  1.00 15.36           C  
ATOM    521  C   MET A  74      79.818  44.110  29.466  1.00 14.45           C  
ATOM    522  O   MET A  74      80.557  44.184  28.486  1.00 13.88           O  
ATOM    523  CB  MET A  74      79.904  41.880  30.564  1.00 15.30           C  
ATOM    524  CG  MET A  74      79.095  40.736  31.107  1.00 16.75           C  
ATOM    525  SD  MET A  74      79.915  39.826  32.328  1.00 19.72           S  
ATOM    526  CE  MET A  74      78.576  39.741  33.435  1.00 16.57           C  
ATOM    527  N   THR A  75      79.646  45.122  30.313  1.00 13.34           N  
ATOM    528  CA  THR A  75      80.555  46.266  30.273  1.00 13.72           C  
ATOM    529  C   THR A  75      81.384  46.278  31.559  1.00 13.24           C  
ATOM    530  O   THR A  75      80.830  46.181  32.606  1.00 12.51           O  
ATOM    531  CB  THR A  75      79.831  47.608  30.006  1.00 13.80           C  
ATOM    532  OG1 THR A  75      79.121  47.520  28.760  1.00 13.24           O  
ATOM    533  CG2 THR A  75      80.833  48.749  29.940  1.00 12.58           C  
ATOM    534  N   VAL A  76      82.713  46.322  31.439  1.00 13.54           N  
ATOM    535  CA  VAL A  76      83.599  46.216  32.586  1.00 13.05           C  
ATOM    536  C   VAL A  76      84.301  47.579  32.702  1.00 12.91           C  
ATOM    537  O   VAL A  76      85.258  47.827  32.002  1.00 14.03           O  
ATOM    538  CB  VAL A  76      84.637  45.023  32.428  1.00 13.67           C  
ATOM    539  CG1 VAL A  76      85.499  44.801  33.733  1.00 13.49           C  
ATOM    540  CG2 VAL A  76      83.934  43.686  31.948  1.00 12.55           C  
ATOM    541  N   PHE A  77      83.787  48.467  33.563  1.00 12.26           N  
ATOM    542  CA  PHE A  77      84.437  49.727  33.882  1.00 11.05           C  
ATOM    543  C   PHE A  77      85.503  49.450  34.943  1.00 11.05           C  
ATOM    544  O   PHE A  77      85.206  48.879  36.002  1.00  9.69           O  
ATOM    545  CB  PHE A  77      83.439  50.743  34.443  1.00 10.70           C  
ATOM    546  CG  PHE A  77      82.186  50.924  33.622  1.00 11.61           C  
ATOM    547  CD1 PHE A  77      82.170  51.782  32.537  1.00 12.03           C  
ATOM    548  CD2 PHE A  77      81.012  50.240  33.946  1.00 12.19           C  
ATOM    549  CE1 PHE A  77      81.009  51.975  31.795  1.00 12.62           C  
ATOM    550  CE2 PHE A  77      79.834  50.450  33.214  1.00 13.54           C  
ATOM    551  CZ  PHE A  77      79.832  51.326  32.144  1.00 10.20           C  
ATOM    552  N   ILE A  78      86.744  49.849  34.638  1.00 10.78           N  
ATOM    553  CA  ILE A  78      87.855  49.614  35.520  1.00  9.47           C  
ATOM    554  C   ILE A  78      88.621  50.901  35.801  1.00 10.31           C  
ATOM    555  O   ILE A  78      88.458  51.866  35.082  1.00 10.55           O  
ATOM    556  CB  ILE A  78      88.814  48.493  34.989  1.00 10.22           C  
ATOM    557  CG1 ILE A  78      89.781  48.980  33.872  1.00  8.98           C  
ATOM    558  CG2 ILE A  78      88.048  47.187  34.754  1.00  8.09           C  
ATOM    559  CD1 ILE A  78      90.690  47.856  33.280  1.00  5.33           C  
ATOM    560  N   THR A  79      89.444  50.922  36.847  1.00 10.38           N  
ATOM    561  CA  THR A  79      90.218  52.153  37.152  1.00 10.76           C  
ATOM    562  C   THR A  79      91.692  52.057  36.754  1.00 10.65           C  
ATOM    563  O   THR A  79      92.390  53.054  36.755  1.00 11.01           O  
ATOM    564  CB  THR A  79      90.107  52.623  38.664  1.00 10.57           C  
ATOM    565  OG1 THR A  79      90.623  51.624  39.530  1.00 10.95           O  
ATOM    566  CG2 THR A  79      88.662  52.930  39.069  1.00  9.73           C  
ATOM    567  N   ASP A  80      92.159  50.854  36.423  1.00 11.29           N  
ATOM    568  CA  ASP A  80      93.527  50.673  35.988  1.00 10.99           C  
ATOM    569  C   ASP A  80      93.643  49.580  34.929  1.00 10.96           C  
ATOM    570  O   ASP A  80      93.466  48.394  35.206  1.00  9.91           O  
ATOM    571  CB  ASP A  80      94.457  50.399  37.187  1.00 10.00           C  
ATOM    572  CG  ASP A  80      95.943  50.510  36.816  1.00 11.63           C  
ATOM    573  OD1 ASP A  80      96.276  50.642  35.603  1.00  9.05           O  
ATOM    574  OD2 ASP A  80      96.779  50.492  37.736  1.00  8.02           O  
ATOM    575  N   LEU A  81      93.955  49.992  33.701  1.00 11.54           N  
ATOM    576  CA  LEU A  81      94.251  49.002  32.648  1.00 12.37           C  
ATOM    577  C   LEU A  81      95.427  48.046  32.897  1.00 12.27           C  
ATOM    578  O   LEU A  81      95.442  46.942  32.358  1.00 13.43           O  
ATOM    579  CB  LEU A  81      94.420  49.652  31.276  1.00 12.65           C  
ATOM    580  CG  LEU A  81      93.048  49.747  30.607  1.00 13.11           C  
ATOM    581  CD1 LEU A  81      93.104  50.885  29.640  1.00  8.79           C  
ATOM    582  CD2 LEU A  81      92.631  48.414  29.922  1.00  8.60           C  
ATOM    583  N   ASN A  82      96.401  48.452  33.696  1.00 12.03           N  
ATOM    584  CA  ASN A  82      97.442  47.540  34.198  1.00 12.62           C  
ATOM    585  C   ASN A  82      96.929  46.388  35.035  1.00 12.81           C  
ATOM    586  O   ASN A  82      97.617  45.400  35.157  1.00 13.36           O  
ATOM    587  CB  ASN A  82      98.538  48.350  34.922  1.00 13.22           C  
ATOM    588  CG  ASN A  82      99.238  49.335  33.943  1.00 15.27           C  
ATOM    589  OD1 ASN A  82      99.361  49.002  32.768  1.00 17.08           O  
ATOM    590  ND2 ASN A  82      99.628  50.538  34.400  1.00 12.07           N  
ATOM    591  N   ASP A  83      95.712  46.502  35.576  1.00 13.75           N  
ATOM    592  CA  ASP A  83      95.027  45.397  36.318  1.00 14.82           C  
ATOM    593  C   ASP A  83      94.400  44.447  35.328  1.00 15.08           C  
ATOM    594  O   ASP A  83      93.794  43.467  35.732  1.00 16.08           O  
ATOM    595  CB  ASP A  83      93.845  45.898  37.234  1.00 14.28           C  
ATOM    596  CG  ASP A  83      94.296  46.843  38.322  1.00 14.34           C  
ATOM    597  OD1 ASP A  83      95.487  46.730  38.685  1.00 13.37           O  
ATOM    598  OD2 ASP A  83      93.480  47.689  38.779  1.00  9.07           O  
ATOM    599  N   PHE A  84      94.486  44.773  34.052  1.00 16.07           N  
ATOM    600  CA  PHE A  84      93.634  44.126  33.068  1.00 18.49           C  
ATOM    601  C   PHE A  84      93.927  42.633  32.837  1.00 17.60           C  
ATOM    602  O   PHE A  84      92.993  41.858  32.744  1.00 16.04           O  
ATOM    603  CB  PHE A  84      93.620  44.886  31.731  1.00 20.09           C  
ATOM    604  CG  PHE A  84      92.657  44.310  30.756  1.00 24.47           C  
ATOM    605  CD1 PHE A  84      91.286  44.480  30.944  1.00 28.23           C  
ATOM    606  CD2 PHE A  84      93.102  43.538  29.694  1.00 28.65           C  
ATOM    607  CE1 PHE A  84      90.366  43.931  30.063  1.00 31.33           C  
ATOM    608  CE2 PHE A  84      92.177  42.964  28.804  1.00 31.38           C  
ATOM    609  CZ  PHE A  84      90.813  43.179  28.979  1.00 29.35           C  
ATOM    610  N   ALA A  85      95.212  42.257  32.781  1.00 17.87           N  
ATOM    611  CA  ALA A  85      95.642  40.840  32.697  1.00 18.19           C  
ATOM    612  C   ALA A  85      95.074  39.952  33.800  1.00 17.81           C  
ATOM    613  O   ALA A  85      94.616  38.888  33.517  1.00 19.81           O  
ATOM    614  CB  ALA A  85      97.182  40.711  32.641  1.00 17.50           C  
ATOM    615  N   THR A  86      95.079  40.421  35.043  1.00 17.84           N  
ATOM    616  CA  THR A  86      94.511  39.738  36.213  1.00 16.68           C  
ATOM    617  C   THR A  86      92.994  39.698  36.183  1.00 16.98           C  
ATOM    618  O   THR A  86      92.407  38.653  36.449  1.00 17.57           O  
ATOM    619  CB  THR A  86      94.990  40.449  37.484  1.00 16.24           C  
ATOM    620  OG1 THR A  86      96.367  40.198  37.613  1.00 14.22           O  
ATOM    621  CG2 THR A  86      94.338  39.946  38.737  1.00 16.80           C  
ATOM    622  N   ILE A  87      92.350  40.817  35.861  1.00 16.47           N  
ATOM    623  CA  ILE A  87      90.892  40.835  35.713  1.00 16.39           C  
ATOM    624  C   ILE A  87      90.430  39.816  34.645  1.00 16.77           C  
ATOM    625  O   ILE A  87      89.470  39.064  34.822  1.00 17.13           O  
ATOM    626  CB  ILE A  87      90.344  42.268  35.388  1.00 16.21           C  
ATOM    627  CG1 ILE A  87      90.483  43.178  36.637  1.00 17.12           C  
ATOM    628  CG2 ILE A  87      88.902  42.162  34.817  1.00 14.80           C  
ATOM    629  CD1 ILE A  87      90.342  44.758  36.428  1.00 15.14           C  
ATOM    630  N   ASN A  88      91.146  39.798  33.538  1.00 17.39           N  
ATOM    631  CA  ASN A  88      90.834  38.972  32.405  1.00 17.73           C  
ATOM    632  C   ASN A  88      91.048  37.471  32.712  1.00 18.09           C  
ATOM    633  O   ASN A  88      90.343  36.616  32.160  1.00 18.52           O  
ATOM    634  CB  ASN A  88      91.753  39.424  31.258  1.00 17.96           C  
ATOM    635  CG  ASN A  88      91.027  39.635  29.983  1.00 19.74           C  
ATOM    636  OD1 ASN A  88      89.895  40.080  29.965  1.00 27.60           O  
ATOM    637  ND2 ASN A  88      91.661  39.288  28.894  1.00 27.04           N  
ATOM    638  N   GLU A  89      92.059  37.153  33.534  1.00 17.59           N  
ATOM    639  CA  GLU A  89      92.315  35.787  33.940  1.00 17.55           C  
ATOM    640  C   GLU A  89      91.185  35.304  34.841  1.00 17.72           C  
ATOM    641  O   GLU A  89      90.624  34.230  34.600  1.00 19.06           O  
ATOM    642  CB  GLU A  89      93.680  35.633  34.631  1.00 17.66           C  
ATOM    643  N   VAL A  90      90.829  36.098  35.850  1.00 17.36           N  
ATOM    644  CA  VAL A  90      89.679  35.809  36.703  1.00 16.79           C  
ATOM    645  C   VAL A  90      88.413  35.646  35.884  1.00 16.89           C  
ATOM    646  O   VAL A  90      87.655  34.714  36.072  1.00 17.52           O  
ATOM    647  CB  VAL A  90      89.460  36.933  37.721  1.00 16.92           C  
ATOM    648  CG1 VAL A  90      88.150  36.723  38.516  1.00 15.51           C  
ATOM    649  CG2 VAL A  90      90.626  36.990  38.634  1.00 16.56           C  
ATOM    650  N   TYR A  91      88.214  36.555  34.948  1.00 17.66           N  
ATOM    651  CA  TYR A  91      86.974  36.654  34.140  1.00 17.52           C  
ATOM    652  C   TYR A  91      86.836  35.469  33.169  1.00 17.91           C  
ATOM    653  O   TYR A  91      85.705  34.974  32.966  1.00 18.53           O  
ATOM    654  CB  TYR A  91      86.957  38.024  33.423  1.00 15.97           C  
ATOM    655  CG  TYR A  91      85.812  38.344  32.475  1.00 15.77           C  
ATOM    656  CD1 TYR A  91      85.592  37.585  31.320  1.00 15.68           C  
ATOM    657  CD2 TYR A  91      84.988  39.457  32.696  1.00 12.95           C  
ATOM    658  CE1 TYR A  91      84.564  37.922  30.427  1.00 16.92           C  
ATOM    659  CE2 TYR A  91      83.957  39.792  31.801  1.00 12.71           C  
ATOM    660  CZ  TYR A  91      83.741  39.030  30.695  1.00 15.09           C  
ATOM    661  OH  TYR A  91      82.732  39.364  29.792  1.00 15.53           O  
ATOM    662  N   LYS A  92      87.960  35.023  32.580  1.00 17.57           N  
ATOM    663  CA  LYS A  92      87.993  33.813  31.737  1.00 17.76           C  
ATOM    664  C   LYS A  92      87.664  32.560  32.539  1.00 18.32           C  
ATOM    665  O   LYS A  92      86.872  31.752  32.119  1.00 16.44           O  
ATOM    666  CB  LYS A  92      89.373  33.629  31.121  1.00 18.73           C  
ATOM    667  CG  LYS A  92      89.490  32.446  30.114  1.00 18.27           C  
ATOM    668  CD  LYS A  92      90.878  32.386  29.516  1.00 18.73           C  
ATOM    669  CE  LYS A  92      91.271  30.946  29.113  1.00 22.65           C  
ATOM    670  NZ  LYS A  92      90.315  30.338  28.157  1.00 21.86           N  
ATOM    671  N   GLN A  93      88.325  32.433  33.700  1.00 20.23           N  
ATOM    672  CA  GLN A  93      88.131  31.343  34.651  1.00 22.12           C  
ATOM    673  C   GLN A  93      86.678  31.185  35.092  1.00 19.96           C  
ATOM    674  O   GLN A  93      86.195  30.064  35.152  1.00 20.41           O  
ATOM    675  CB  GLN A  93      89.105  31.461  35.851  1.00 21.55           C  
ATOM    676  CG  GLN A  93      90.529  30.977  35.483  1.00 25.74           C  
ATOM    677  CD  GLN A  93      91.513  30.980  36.672  1.00 28.94           C  
ATOM    678  OE1 GLN A  93      92.754  31.110  36.487  1.00 33.31           O  
ATOM    679  NE2 GLN A  93      90.966  30.828  37.905  1.00 34.03           N  
ATOM    680  N   PHE A  94      85.994  32.305  35.331  1.00 18.57           N  
ATOM    681  CA  PHE A  94      84.548  32.380  35.668  1.00 17.21           C  
ATOM    682  C   PHE A  94      83.586  31.808  34.585  1.00 17.32           C  
ATOM    683  O   PHE A  94      82.647  31.054  34.895  1.00 16.67           O  
ATOM    684  CB  PHE A  94      84.193  33.855  35.963  1.00 15.69           C  
ATOM    685  CG  PHE A  94      82.803  34.069  36.458  1.00 14.97           C  
ATOM    686  CD1 PHE A  94      82.451  33.765  37.786  1.00 14.46           C  
ATOM    687  CD2 PHE A  94      81.837  34.629  35.624  1.00 12.75           C  
ATOM    688  CE1 PHE A  94      81.125  33.992  38.264  1.00  9.17           C  
ATOM    689  CE2 PHE A  94      80.536  34.856  36.094  1.00 13.35           C  
ATOM    690  CZ  PHE A  94      80.184  34.523  37.436  1.00  8.72           C  
ATOM    691  N   PHE A  95      83.783  32.196  33.325  1.00 16.73           N  
ATOM    692  CA  PHE A  95      82.953  31.654  32.305  1.00 17.54           C  
ATOM    693  C   PHE A  95      83.295  30.170  32.078  1.00 19.60           C  
ATOM    694  O   PHE A  95      82.385  29.333  32.084  1.00 19.61           O  
ATOM    695  CB  PHE A  95      82.954  32.530  31.046  1.00 17.10           C  
ATOM    696  CG  PHE A  95      82.178  33.784  31.231  1.00 15.61           C  
ATOM    697  CD1 PHE A  95      80.789  33.788  31.073  1.00 18.74           C  
ATOM    698  CD2 PHE A  95      82.802  34.950  31.667  1.00 15.39           C  
ATOM    699  CE1 PHE A  95      80.038  34.972  31.293  1.00 15.74           C  
ATOM    700  CE2 PHE A  95      82.061  36.125  31.915  1.00 12.07           C  
ATOM    701  CZ  PHE A  95      80.700  36.130  31.718  1.00 12.39           C  
ATOM    702  N   ASP A  96      84.594  29.854  31.965  1.00 20.54           N  
ATOM    703  CA  ASP A  96      85.079  28.465  31.898  1.00 21.97           C  
ATOM    704  C   ASP A  96      84.503  27.591  32.986  1.00 23.63           C  
ATOM    705  O   ASP A  96      83.905  26.571  32.647  1.00 24.51           O  
ATOM    706  CB  ASP A  96      86.621  28.371  31.866  1.00 21.29           C  
ATOM    707  CG  ASP A  96      87.226  28.998  30.589  1.00 19.58           C  
ATOM    708  OD1 ASP A  96      86.503  29.468  29.683  1.00 16.61           O  
ATOM    709  OD2 ASP A  96      88.440  29.058  30.497  1.00 20.51           O  
ATOM    710  N   GLU A  97      84.653  27.980  34.262  1.00 25.20           N  
ATOM    711  CA  GLU A  97      84.089  27.231  35.400  1.00 27.64           C  
ATOM    712  C   GLU A  97      82.635  26.808  35.179  1.00 26.76           C  
ATOM    713  O   GLU A  97      82.193  25.762  35.672  1.00 26.38           O  
ATOM    714  CB  GLU A  97      84.062  28.098  36.653  1.00 28.11           C  
ATOM    715  CG  GLU A  97      85.346  28.160  37.448  1.00 32.71           C  
ATOM    716  CD  GLU A  97      85.154  28.774  38.839  1.00 33.27           C  
ATOM    717  OE1 GLU A  97      83.985  29.113  39.226  1.00 37.29           O  
ATOM    718  OE2 GLU A  97      86.196  28.891  39.544  1.00 40.72           O  
ATOM    719  N   HIS A  98      81.891  27.670  34.484  1.00 26.61           N  
ATOM    720  CA  HIS A  98      80.446  27.564  34.330  1.00 25.48           C  
ATOM    721  C   HIS A  98      80.095  27.025  32.985  1.00 26.85           C  
ATOM    722  O   HIS A  98      78.918  26.971  32.635  1.00 26.53           O  
ATOM    723  CB  HIS A  98      79.785  28.936  34.533  1.00 25.19           C  
ATOM    724  CG  HIS A  98      79.707  29.337  35.969  1.00 19.41           C  
ATOM    725  ND1 HIS A  98      80.622  30.173  36.553  1.00 16.60           N  
ATOM    726  CD2 HIS A  98      78.881  28.933  36.956  1.00 14.68           C  
ATOM    727  CE1 HIS A  98      80.338  30.303  37.835  1.00 14.14           C  
ATOM    728  NE2 HIS A  98      79.299  29.535  38.106  1.00 15.40           N  
ATOM    729  N   GLN A  99      81.127  26.603  32.247  1.00 27.85           N  
ATOM    730  CA  GLN A  99      80.970  26.008  30.905  1.00 29.51           C  
ATOM    731  C   GLN A  99      80.143  26.943  30.024  1.00 28.52           C  
ATOM    732  O   GLN A  99      79.221  26.534  29.312  1.00 28.86           O  
ATOM    733  CB  GLN A  99      80.417  24.568  30.994  1.00 29.24           C  
ATOM    734  CG  GLN A  99      81.412  23.612  31.753  1.00 31.94           C  
ATOM    735  CD  GLN A  99      81.036  22.136  31.643  1.00 33.63           C  
ATOM    736  OE1 GLN A  99      81.662  21.365  30.886  1.00 39.89           O  
ATOM    737  NE2 GLN A  99      80.004  21.732  32.378  1.00 35.93           N  
ATOM    738  N   ALA A 100      80.520  28.222  30.070  1.00 27.64           N  
ATOM    739  CA  ALA A 100      79.732  29.300  29.487  1.00 26.39           C  
ATOM    740  C   ALA A 100      80.467  29.924  28.297  1.00 25.23           C  
ATOM    741  O   ALA A 100      81.661  30.161  28.361  1.00 26.58           O  
ATOM    742  CB  ALA A 100      79.436  30.318  30.565  1.00 25.67           C  
ATOM    743  N   THR A 101      79.772  30.128  27.192  1.00 24.15           N  
ATOM    744  CA  THR A 101      80.306  30.903  26.067  1.00 23.70           C  
ATOM    745  C   THR A 101      80.604  32.313  26.589  1.00 21.68           C  
ATOM    746  O   THR A 101      79.822  32.858  27.394  1.00 20.28           O  
ATOM    747  CB  THR A 101      79.224  31.095  24.977  1.00 24.21           C  
ATOM    748  OG1 THR A 101      78.776  29.832  24.496  1.00 28.81           O  
ATOM    749  CG2 THR A 101      79.738  31.914  23.804  1.00 27.29           C  
ATOM    750  N   TYR A 102      81.697  32.901  26.101  1.00 19.56           N  
ATOM    751  CA  TYR A 102      82.082  34.241  26.467  1.00 18.37           C  
ATOM    752  C   TYR A 102      81.100  35.285  25.869  1.00 17.58           C  
ATOM    753  O   TYR A 102      80.735  35.180  24.713  1.00 18.29           O  
ATOM    754  CB  TYR A 102      83.515  34.543  26.038  1.00 18.31           C  
ATOM    755  CG  TYR A 102      84.571  33.570  26.498  1.00 18.05           C  
ATOM    756  CD1 TYR A 102      84.622  33.121  27.814  1.00 19.11           C  
ATOM    757  CD2 TYR A 102      85.516  33.100  25.615  1.00 18.30           C  
ATOM    758  CE1 TYR A 102      85.571  32.230  28.223  1.00 17.10           C  
ATOM    759  CE2 TYR A 102      86.486  32.197  26.010  1.00 17.60           C  
ATOM    760  CZ  TYR A 102      86.498  31.755  27.317  1.00 19.29           C  
ATOM    761  OH  TYR A 102      87.466  30.842  27.724  1.00 19.91           O  
ATOM    762  N   PRO A 103      80.631  36.261  26.680  1.00 16.44           N  
ATOM    763  CA  PRO A 103      79.720  37.241  26.072  1.00 15.76           C  
ATOM    764  C   PRO A 103      80.504  38.269  25.230  1.00 15.51           C  
ATOM    765  O   PRO A 103      81.770  38.264  25.196  1.00 16.48           O  
ATOM    766  CB  PRO A 103      79.071  37.943  27.294  1.00 15.04           C  
ATOM    767  CG  PRO A 103      79.700  37.379  28.533  1.00 13.68           C  
ATOM    768  CD  PRO A 103      80.879  36.538  28.117  1.00 15.62           C  
ATOM    769  N   THR A 104      79.774  39.144  24.564  1.00 14.20           N  
ATOM    770  CA  THR A 104      80.367  40.368  24.102  1.00 14.27           C  
ATOM    771  C   THR A 104      80.765  41.241  25.325  1.00 14.30           C  
ATOM    772  O   THR A 104      80.227  41.084  26.422  1.00 14.26           O  
ATOM    773  CB  THR A 104      79.469  41.126  23.118  1.00 14.31           C  
ATOM    774  OG1 THR A 104      78.222  41.421  23.731  1.00 16.05           O  
ATOM    775  CG2 THR A 104      79.215  40.326  21.879  1.00 12.40           C  
ATOM    776  N   ARG A 105      81.728  42.129  25.112  1.00 13.60           N  
ATOM    777  CA  ARG A 105      82.309  42.880  26.183  1.00 13.98           C  
ATOM    778  C   ARG A 105      82.789  44.278  25.723  1.00 13.68           C  
ATOM    779  O   ARG A 105      83.172  44.470  24.591  1.00 12.68           O  
ATOM    780  CB  ARG A 105      83.488  42.090  26.761  1.00 13.32           C  
ATOM    781  CG  ARG A 105      83.830  42.520  28.135  1.00 14.53           C  
ATOM    782  CD  ARG A 105      84.869  41.632  28.742  1.00 18.67           C  
ATOM    783  NE  ARG A 105      86.180  41.646  28.095  1.00 17.02           N  
ATOM    784  CZ  ARG A 105      87.211  40.891  28.489  1.00 19.97           C  
ATOM    785  NH1 ARG A 105      87.106  40.065  29.533  1.00 17.76           N  
ATOM    786  NH2 ARG A 105      88.379  40.981  27.855  1.00 23.15           N  
ATOM    787  N   SER A 106      82.735  45.245  26.620  1.00 14.38           N  
ATOM    788  CA  SER A 106      83.483  46.494  26.455  1.00 14.87           C  
ATOM    789  C   SER A 106      84.225  46.700  27.768  1.00 14.54           C  
ATOM    790  O   SER A 106      83.704  46.395  28.861  1.00 13.85           O  
ATOM    791  CB  SER A 106      82.569  47.672  26.184  1.00 15.24           C  
ATOM    792  OG  SER A 106      82.020  47.638  24.858  1.00 15.98           O  
ATOM    793  N   CYS A 107      85.453  47.171  27.666  1.00 14.85           N  
ATOM    794  CA  CYS A 107      86.218  47.424  28.862  1.00 15.30           C  
ATOM    795  C   CYS A 107      86.906  48.789  28.718  1.00 14.88           C  
ATOM    796  O   CYS A 107      87.627  49.048  27.750  1.00 14.94           O  
ATOM    797  CB  CYS A 107      87.186  46.246  29.155  1.00 15.26           C  
ATOM    798  SG  CYS A 107      88.353  46.520  30.554  1.00 18.50           S  
ATOM    799  N   VAL A 108      86.624  49.691  29.658  1.00 13.80           N  
ATOM    800  CA  VAL A 108      87.198  51.021  29.585  1.00 11.84           C  
ATOM    801  C   VAL A 108      87.797  51.403  30.923  1.00 11.96           C  
ATOM    802  O   VAL A 108      87.286  50.954  31.967  1.00 12.94           O  
ATOM    803  CB  VAL A 108      86.167  52.073  29.105  1.00 11.85           C  
ATOM    804  CG1 VAL A 108      85.668  51.725  27.716  1.00  9.31           C  
ATOM    805  CG2 VAL A 108      85.006  52.229  30.098  1.00  9.80           C  
ATOM    806  N   GLN A 109      88.857  52.226  30.910  1.00 10.44           N  
ATOM    807  CA  GLN A 109      89.392  52.750  32.168  1.00  9.61           C  
ATOM    808  C   GLN A 109      88.785  54.115  32.490  1.00 10.37           C  
ATOM    809  O   GLN A 109      89.048  55.085  31.824  1.00 10.48           O  
ATOM    810  CB  GLN A 109      90.927  52.827  32.177  1.00  9.31           C  
ATOM    811  CG  GLN A 109      91.511  53.341  33.489  1.00  4.58           C  
ATOM    812  CD  GLN A 109      92.982  53.642  33.411  1.00  8.65           C  
ATOM    813  OE1 GLN A 109      93.782  52.819  32.923  1.00  8.04           O  
ATOM    814  NE2 GLN A 109      93.381  54.819  33.934  1.00  6.56           N  
ATOM    815  N   VAL A 110      87.969  54.164  33.527  1.00 10.18           N  
ATOM    816  CA  VAL A 110      87.305  55.397  33.957  1.00  9.69           C  
ATOM    817  C   VAL A 110      88.160  56.125  35.000  1.00  9.32           C  
ATOM    818  O   VAL A 110      89.255  55.646  35.373  1.00 10.73           O  
ATOM    819  CB  VAL A 110      85.832  55.097  34.428  1.00  9.74           C  
ATOM    820  CG1 VAL A 110      85.107  54.407  33.301  1.00  8.19           C  
ATOM    821  CG2 VAL A 110      85.817  54.192  35.682  1.00  8.03           C  
ATOM    822  N   ALA A 111      87.697  57.278  35.447  1.00  8.06           N  
ATOM    823  CA  ALA A 111      88.404  58.030  36.499  1.00  8.89           C  
ATOM    824  C   ALA A 111      88.306  57.405  37.899  1.00  8.81           C  
ATOM    825  O   ALA A 111      89.314  57.335  38.609  1.00 10.11           O  
ATOM    826  CB  ALA A 111      87.993  59.522  36.520  1.00  7.33           C  
ATOM    827  N   ARG A 112      87.128  56.916  38.267  1.00  8.79           N  
ATOM    828  CA  ARG A 112      86.822  56.538  39.663  1.00 10.11           C  
ATOM    829  C   ARG A 112      85.444  55.886  39.682  1.00 10.69           C  
ATOM    830  O   ARG A 112      84.664  56.059  38.739  1.00 11.36           O  
ATOM    831  CB  ARG A 112      86.884  57.765  40.580  1.00  9.61           C  
ATOM    832  CG  ARG A 112      86.993  57.487  42.046  1.00  9.82           C  
ATOM    833  CD  ARG A 112      87.284  58.793  42.794  1.00 11.54           C  
ATOM    834  NE  ARG A 112      87.365  58.539  44.218  1.00 11.67           N  
ATOM    835  CZ  ARG A 112      87.289  59.448  45.186  1.00 10.41           C  
ATOM    836  NH1 ARG A 112      87.135  60.723  44.920  1.00  4.71           N  
ATOM    837  NH2 ARG A 112      87.357  59.042  46.449  1.00 11.79           N  
ATOM    838  N   LEU A 113      85.175  55.087  40.711  1.00 11.11           N  
ATOM    839  CA  LEU A 113      83.945  54.284  40.776  1.00 11.58           C  
ATOM    840  C   LEU A 113      83.371  54.433  42.162  1.00 11.85           C  
ATOM    841  O   LEU A 113      84.092  54.798  43.042  1.00 12.26           O  
ATOM    842  CB  LEU A 113      84.180  52.781  40.441  1.00  9.99           C  
ATOM    843  CG  LEU A 113      84.567  52.506  38.976  1.00 10.65           C  
ATOM    844  CD1 LEU A 113      85.243  51.160  38.863  1.00  5.06           C  
ATOM    845  CD2 LEU A 113      83.392  52.696  37.927  1.00  2.48           C  
ATOM    846  N   PRO A 114      82.065  54.160  42.343  1.00 12.49           N  
ATOM    847  CA  PRO A 114      81.442  54.216  43.654  1.00 13.24           C  
ATOM    848  C   PRO A 114      82.222  53.437  44.669  1.00 13.78           C  
ATOM    849  O   PRO A 114      82.584  52.304  44.404  1.00 14.77           O  
ATOM    850  CB  PRO A 114      80.063  53.548  43.409  1.00 13.81           C  
ATOM    851  CG  PRO A 114      79.751  53.929  41.973  1.00 12.84           C  
ATOM    852  CD  PRO A 114      81.095  53.787  41.287  1.00 12.20           C  
ATOM    853  N   LYS A 115      82.471  54.042  45.823  1.00 14.64           N  
ATOM    854  CA  LYS A 115      83.206  53.404  46.950  1.00 14.87           C  
ATOM    855  C   LYS A 115      84.627  53.018  46.615  1.00 14.53           C  
ATOM    856  O   LYS A 115      85.169  52.113  47.242  1.00 14.35           O  
ATOM    857  CB  LYS A 115      82.493  52.167  47.477  1.00 15.62           C  
ATOM    858  CG  LYS A 115      81.039  52.396  47.736  1.00 19.14           C  
ATOM    859  CD  LYS A 115      80.636  51.971  49.083  1.00 25.59           C  
ATOM    860  CE  LYS A 115      79.820  50.712  49.000  1.00 28.24           C  
ATOM    861  NZ  LYS A 115      79.018  50.573  50.274  1.00 34.49           N  
ATOM    862  N   ASP A 116      85.212  53.680  45.624  1.00 13.04           N  
ATOM    863  CA  ASP A 116      86.629  53.478  45.254  1.00 13.26           C  
ATOM    864  C   ASP A 116      87.030  52.035  44.916  1.00 11.99           C  
ATOM    865  O   ASP A 116      88.191  51.612  45.185  1.00 10.85           O  
ATOM    866  CB  ASP A 116      87.568  54.083  46.327  1.00 14.82           C  
ATOM    867  CG  ASP A 116      87.639  55.595  46.251  1.00 14.77           C  
ATOM    868  OD1 ASP A 116      88.320  56.082  45.340  1.00 19.62           O  
ATOM    869  OD2 ASP A 116      87.036  56.288  47.095  1.00 16.25           O  
ATOM    870  N   VAL A 117      86.069  51.300  44.330  1.00 10.09           N  
ATOM    871  CA  VAL A 117      86.301  49.967  43.763  1.00  9.44           C  
ATOM    872  C   VAL A 117      87.106  50.092  42.478  1.00  9.10           C  
ATOM    873  O   VAL A 117      87.104  51.152  41.875  1.00 10.03           O  
ATOM    874  CB  VAL A 117      85.007  49.147  43.580  1.00  8.73           C  
ATOM    875  CG1 VAL A 117      84.289  49.018  44.944  1.00  8.48           C  
ATOM    876  CG2 VAL A 117      84.088  49.734  42.544  1.00  7.19           C  
ATOM    877  N   LYS A 118      87.829  49.040  42.113  1.00  9.26           N  
ATOM    878  CA  LYS A 118      88.683  49.000  40.929  1.00  9.36           C  
ATOM    879  C   LYS A 118      87.938  48.602  39.634  1.00 10.92           C  
ATOM    880  O   LYS A 118      88.482  48.765  38.504  1.00 11.94           O  
ATOM    881  CB  LYS A 118      89.805  48.018  41.148  1.00  8.60           C  
ATOM    882  CG  LYS A 118      90.699  48.362  42.328  1.00  7.62           C  
ATOM    883  CD  LYS A 118      91.830  47.327  42.429  1.00  5.37           C  
ATOM    884  CE  LYS A 118      92.556  47.462  43.753  1.00  7.70           C  
ATOM    885  NZ  LYS A 118      93.478  48.617  43.641  1.00  7.98           N  
ATOM    886  N   LEU A 119      86.739  48.037  39.795  1.00 11.35           N  
ATOM    887  CA  LEU A 119      85.892  47.660  38.675  1.00 12.66           C  
ATOM    888  C   LEU A 119      84.440  47.697  39.054  1.00 12.59           C  
ATOM    889  O   LEU A 119      84.062  47.438  40.199  1.00 13.05           O  
ATOM    890  CB  LEU A 119      86.273  46.273  38.088  1.00 12.96           C  
ATOM    891  CG  LEU A 119      85.888  44.956  38.775  1.00 15.57           C  
ATOM    892  CD1 LEU A 119      86.364  43.801  37.917  1.00 17.67           C  
ATOM    893  CD2 LEU A 119      86.468  44.800  40.180  1.00 14.99           C  
ATOM    894  N   GLU A 120      83.639  48.032  38.058  1.00 12.32           N  
ATOM    895  CA  GLU A 120      82.195  47.874  38.087  1.00 11.80           C  
ATOM    896  C   GLU A 120      81.759  47.096  36.815  1.00 11.06           C  
ATOM    897  O   GLU A 120      82.207  47.420  35.697  1.00  9.82           O  
ATOM    898  CB  GLU A 120      81.552  49.267  38.129  1.00 11.71           C  
ATOM    899  CG  GLU A 120      80.056  49.223  38.231  1.00 11.91           C  
ATOM    900  CD  GLU A 120      79.437  50.580  38.253  1.00 14.03           C  
ATOM    901  OE1 GLU A 120      80.043  51.518  38.807  1.00 11.77           O  
ATOM    902  OE2 GLU A 120      78.341  50.702  37.702  1.00 15.59           O  
ATOM    903  N   ILE A 121      80.918  46.071  36.987  1.00 11.13           N  
ATOM    904  CA  ILE A 121      80.450  45.192  35.859  1.00 11.27           C  
ATOM    905  C   ILE A 121      78.917  45.152  35.708  1.00 12.40           C  
ATOM    906  O   ILE A 121      78.225  44.693  36.592  1.00 12.48           O  
ATOM    907  CB  ILE A 121      80.976  43.736  35.966  1.00 10.85           C  
ATOM    908  CG1 ILE A 121      82.512  43.721  36.093  1.00 10.52           C  
ATOM    909  CG2 ILE A 121      80.517  42.885  34.767  1.00 11.16           C  
ATOM    910  CD1 ILE A 121      83.162  42.312  36.263  1.00 10.49           C  
ATOM    911  N   GLU A 122      78.405  45.657  34.593  1.00 12.57           N  
ATOM    912  CA  GLU A 122      77.016  45.475  34.252  1.00 12.59           C  
ATOM    913  C   GLU A 122      76.816  44.388  33.171  1.00 12.56           C  
ATOM    914  O   GLU A 122      77.665  44.199  32.326  1.00 12.57           O  
ATOM    915  CB  GLU A 122      76.419  46.809  33.801  1.00 12.10           C  
ATOM    916  CG  GLU A 122      76.951  47.257  32.492  1.00 12.57           C  
ATOM    917  CD  GLU A 122      76.352  48.540  32.023  1.00 12.78           C  
ATOM    918  OE1 GLU A 122      75.905  49.355  32.832  1.00 11.18           O  
ATOM    919  OE2 GLU A 122      76.317  48.743  30.812  1.00 19.17           O  
ATOM    920  N   ALA A 123      75.664  43.710  33.190  1.00 13.01           N  
ATOM    921  CA  ALA A 123      75.405  42.523  32.346  1.00 12.74           C  
ATOM    922  C   ALA A 123      73.989  42.542  31.767  1.00 13.20           C  
ATOM    923  O   ALA A 123      73.040  43.119  32.342  1.00 12.35           O  
ATOM    924  CB  ALA A 123      75.618  41.230  33.177  1.00 12.90           C  
ATOM    925  N   ILE A 124      73.873  41.897  30.615  1.00 13.89           N  
ATOM    926  CA  ILE A 124      72.618  41.643  29.944  1.00 14.54           C  
ATOM    927  C   ILE A 124      72.569  40.140  29.654  1.00 15.10           C  
ATOM    928  O   ILE A 124      73.490  39.587  29.041  1.00 14.83           O  
ATOM    929  CB  ILE A 124      72.470  42.452  28.627  1.00 14.37           C  
ATOM    930  CG1 ILE A 124      72.628  43.951  28.903  1.00 14.57           C  
ATOM    931  CG2 ILE A 124      71.098  42.178  28.036  1.00 13.87           C  
ATOM    932  CD1 ILE A 124      72.795  44.841  27.652  1.00 16.01           C  
ATOM    933  N   ALA A 125      71.517  39.492  30.154  1.00 16.06           N  
ATOM    934  CA  ALA A 125      71.265  38.043  29.964  1.00 17.48           C  
ATOM    935  C   ALA A 125      69.955  37.850  29.159  1.00 18.71           C  
ATOM    936  O   ALA A 125      69.012  38.655  29.283  1.00 18.80           O  
ATOM    937  CB  ALA A 125      71.203  37.310  31.332  1.00 15.54           C  
ATOM    938  N   VAL A 126      69.908  36.821  28.318  1.00 20.91           N  
ATOM    939  CA  VAL A 126      68.678  36.492  27.563  1.00 22.93           C  
ATOM    940  C   VAL A 126      68.197  35.084  27.963  1.00 25.09           C  
ATOM    941  O   VAL A 126      69.003  34.248  28.340  1.00 25.14           O  
ATOM    942  CB  VAL A 126      68.859  36.654  26.029  1.00 21.84           C  
ATOM    943  CG1 VAL A 126      69.442  38.020  25.741  1.00 22.67           C  
ATOM    944  CG2 VAL A 126      69.812  35.608  25.494  1.00 22.00           C  
ATOM    945  N   ARG A 127      66.890  34.836  27.887  1.00 27.78           N  
ATOM    946  CA  ARG A 127      66.324  33.609  28.411  1.00 30.49           C  
ATOM    947  C   ARG A 127      66.544  32.381  27.532  1.00 33.21           C  
ATOM    948  O   ARG A 127      66.984  31.316  28.037  1.00 34.16           O  
ATOM    949  CB  ARG A 127      64.865  33.810  28.818  1.00 30.30           C  
ATOM    950  CG  ARG A 127      64.394  32.833  29.868  1.00 30.05           C  
ATOM    951  CD  ARG A 127      63.075  33.250  30.476  1.00 30.72           C  
ATOM    952  NE  ARG A 127      63.218  34.451  31.301  1.00 30.74           N  
ATOM    953  CZ  ARG A 127      63.573  34.441  32.576  1.00 31.07           C  
ATOM    954  NH1 ARG A 127      63.826  33.296  33.204  1.00 30.89           N  
ATOM    955  NH2 ARG A 127      63.674  35.587  33.223  1.00 31.86           N  
ATOM    956  N   SER A 128      66.290  32.491  26.227  1.00 36.10           N  
ATOM    957  CA  SER A 128      66.706  31.377  25.315  1.00 38.53           C  
ATOM    958  C   SER A 128      67.489  31.876  24.067  1.00 39.95           C  
ATOM    959  O   SER A 128      68.743  31.815  24.013  1.00 41.03           O  
ATOM    960  CB  SER A 128      65.501  30.472  24.916  1.00 39.22           C  
ATOM    961  OG  SER A 128      64.868  29.871  26.060  1.00 39.89           O  
TER     962      SER A 128                                                      
END
MOLECULE T0423.pdb
ATOM  12910  N   MET     1      70.981  21.031  37.362  1.00 36.76           N  
ATOM  12911  CA  MET     1      71.905  21.930  36.664  1.00 38.87           C  
ATOM  12912  C   MET     1      72.311  23.119  37.519  1.00 35.58           C  
ATOM  12913  O   MET     1      73.455  23.538  37.475  1.00 34.69           O  
ATOM  12914  CB  MET     1      71.283  22.461  35.383  1.00 39.21           C  
ATOM  12915  CG  MET     1      71.504  21.613  34.171  1.00 44.40           C  
ATOM  12916  SD  MET     1      70.806  22.501  32.558  1.00 57.84          SE  
ATOM  12917  CE  MET     1      71.792  24.214  32.666  1.00 53.65           C  
ATOM  12918  N   SER     2      71.368  23.671  38.275  1.00 34.19           N  
ATOM  12919  CA  SER     2      71.660  24.824  39.146  1.00 33.25           C  
ATOM  12920  C   SER     2      72.590  24.410  40.267  1.00 32.21           C  
ATOM  12921  O   SER     2      73.492  25.167  40.644  1.00 30.89           O  
ATOM  12922  CB  SER     2      70.389  25.426  39.738  1.00 32.90           C  
ATOM  12923  OG  SER     2      69.633  26.060  38.749  1.00 33.07           O  
ATOM  12924  N   ASP     3      72.374  23.203  40.811  1.00 30.62           N  
ATOM  12925  CA  ASP     3      73.242  22.687  41.862  1.00 30.33           C  
ATOM  12926  C   ASP     3      74.682  22.556  41.347  1.00 28.94           C  
ATOM  12927  O   ASP     3      75.638  22.825  42.091  1.00 29.92           O  
ATOM  12928  CB  ASP     3      72.774  21.291  42.370  1.00 30.67           C  
ATOM  12929  CG  ASP     3      71.492  21.328  43.198  1.00 32.38           C  
ATOM  12930  OD1 ASP     3      71.019  22.402  43.615  1.00 35.40           O  
ATOM  12931  OD2 ASP     3      70.942  20.230  43.448  1.00 35.26           O  
ATOM  12932  N   VAL     4      74.823  22.096  40.101  1.00 27.71           N  
ATOM  12933  CA  VAL     4      76.127  21.864  39.482  1.00 27.34           C  
ATOM  12934  C   VAL     4      76.846  23.203  39.304  1.00 26.70           C  
ATOM  12935  O   VAL     4      78.035  23.311  39.582  1.00 25.89           O  
ATOM  12936  CB  VAL     4      75.994  21.175  38.115  1.00 27.32           C  
ATOM  12937  CG1 VAL     4      77.261  21.282  37.304  1.00 28.31           C  
ATOM  12938  CG2 VAL     4      75.606  19.678  38.300  1.00 27.74           C  
ATOM  12939  N   ILE     5      76.114  24.200  38.836  1.00 26.35           N  
ATOM  12940  CA  ILE     5      76.694  25.575  38.675  1.00 26.66           C  
ATOM  12941  C   ILE     5      77.167  26.134  40.031  1.00 26.86           C  
ATOM  12942  O   ILE     5      78.302  26.546  40.179  1.00 27.38           O  
ATOM  12943  CB  ILE     5      75.680  26.562  37.999  1.00 26.48           C  
ATOM  12944  CG1 ILE     5      75.346  26.128  36.566  1.00 24.54           C  
ATOM  12945  CG2 ILE     5      76.257  28.001  37.934  1.00 26.07           C  
ATOM  12946  CD1 ILE     5      74.048  26.748  35.988  1.00 26.63           C  
ATOM  12947  N   GLU     6      76.308  26.117  41.034  1.00 27.87           N  
ATOM  12948  CA  GLU     6      76.688  26.606  42.353  1.00 28.66           C  
ATOM  12949  C   GLU     6      77.785  25.768  43.000  1.00 28.15           C  
ATOM  12950  O   GLU     6      78.644  26.303  43.709  1.00 27.19           O  
ATOM  12951  CB  GLU     6      75.481  26.702  43.272  1.00 29.19           C  
ATOM  12952  CG  GLU     6      74.484  27.740  42.832  1.00 31.30           C  
ATOM  12953  CD  GLU     6      73.485  28.113  43.911  1.00 31.61           C  
ATOM  12954  OE1 GLU     6      73.885  28.327  45.083  1.00 38.52           O  
ATOM  12955  OE2 GLU     6      72.296  28.217  43.572  1.00 35.07           O  
ATOM  12956  N   GLY     7      77.769  24.454  42.764  1.00 27.55           N  
ATOM  12957  CA  GLY     7      78.825  23.599  43.252  1.00 27.47           C  
ATOM  12958  C   GLY     7      80.172  23.924  42.647  1.00 27.46           C  
ATOM  12959  O   GLY     7      81.190  23.916  43.348  1.00 28.04           O  
ATOM  12960  N   ARG     8      80.193  24.198  41.351  1.00 27.39           N  
ATOM  12961  CA  ARG     8      81.428  24.591  40.683  1.00 28.18           C  
ATOM  12962  C   ARG     8      81.977  25.901  41.263  1.00 27.87           C  
ATOM  12963  O   ARG     8      83.187  26.055  41.439  1.00 28.10           O  
ATOM  12964  CB  ARG     8      81.219  24.776  39.185  1.00 27.91           C  
ATOM  12965  CG  ARG     8      81.010  23.509  38.405  1.00 28.72           C  
ATOM  12966  CD  ARG     8      80.440  23.881  37.071  1.00 31.46           C  
ATOM  12967  NE  ARG     8      80.192  22.738  36.217  1.00 33.09           N  
ATOM  12968  CZ  ARG     8      79.413  22.752  35.140  1.00 35.77           C  
ATOM  12969  NH1 ARG     8      78.767  23.854  34.762  1.00 36.28           N  
ATOM  12970  NH2 ARG     8      79.267  21.629  34.439  1.00 38.50           N  
ATOM  12971  N   LEU     9      81.077  26.830  41.554  1.00 28.09           N  
ATOM  12972  CA  LEU     9      81.479  28.113  42.139  1.00 28.34           C  
ATOM  12973  C   LEU     9      82.103  27.873  43.539  1.00 28.63           C  
ATOM  12974  O   LEU     9      83.145  28.457  43.874  1.00 27.85           O  
ATOM  12975  CB  LEU     9      80.271  29.044  42.209  1.00 28.43           C  
ATOM  12976  CG  LEU     9      80.543  30.479  42.669  1.00 28.95           C  
ATOM  12977  CD1 LEU     9      81.644  31.110  41.771  1.00 29.20           C  
ATOM  12978  CD2 LEU     9      79.251  31.302  42.651  1.00 29.10           C  
ATOM  12979  N   LYS    10      81.487  26.998  44.343  1.00 28.27           N  
ATOM  12980  CA  LYS    10      82.090  26.586  45.618  1.00 29.09           C  
ATOM  12981  C   LYS    10      83.477  25.946  45.467  1.00 29.33           C  
ATOM  12982  O   LYS    10      84.380  26.178  46.296  1.00 30.06           O  
ATOM  12983  CB  LYS    10      81.155  25.648  46.379  1.00 29.06           C  
ATOM  12984  CG  LYS    10      79.869  26.277  46.842  1.00 29.74           C  
ATOM  12985  CD  LYS    10      79.055  25.300  47.652  1.00 30.41           C  
ATOM  12986  CE  LYS    10      77.739  25.887  48.034  1.00 30.84           C  
ATOM  12987  NZ  LYS    10      76.878  24.856  48.677  1.00 32.89           N  
ATOM  12988  N   GLU    11      83.673  25.166  44.413  1.00 29.53           N  
ATOM  12989  CA  GLU    11      84.977  24.594  44.114  1.00 30.47           C  
ATOM  12990  C   GLU    11      86.011  25.667  43.795  1.00 30.79           C  
ATOM  12991  O   GLU    11      87.190  25.452  44.020  1.00 32.10           O  
ATOM  12992  CB  GLU    11      84.889  23.624  42.946  1.00 30.41           C  
ATOM  12993  CG  GLU    11      84.195  22.304  43.287  1.00 31.53           C  
ATOM  12994  CD  GLU    11      83.980  21.440  42.072  1.00 33.05           C  
ATOM  12995  OE1 GLU    11      83.483  21.935  41.044  1.00 37.69           O  
ATOM  12996  OE2 GLU    11      84.275  20.239  42.144  1.00 40.32           O  
ATOM  12997  N   LEU    12      85.573  26.810  43.266  1.00 30.96           N  
ATOM  12998  CA  LEU    12      86.458  27.982  43.080  1.00 30.36           C  
ATOM  12999  C   LEU    12      86.672  28.813  44.349  1.00 30.69           C  
ATOM  13000  O   LEU    12      87.510  29.730  44.358  1.00 31.30           O  
ATOM  13001  CB  LEU    12      85.912  28.883  41.982  1.00 29.65           C  
ATOM  13002  CG  LEU    12      85.889  28.253  40.603  1.00 29.14           C  
ATOM  13003  CD1 LEU    12      85.193  29.190  39.650  1.00 28.44           C  
ATOM  13004  CD2 LEU    12      87.318  27.916  40.123  1.00 30.62           C  
ATOM  13005  N   GLY    13      85.906  28.530  45.398  1.00 30.88           N  
ATOM  13006  CA  GLY    13      86.097  29.154  46.694  1.00 30.87           C  
ATOM  13007  C   GLY    13      85.047  30.177  47.062  1.00 30.89           C  
ATOM  13008  O   GLY    13      85.157  30.816  48.099  1.00 31.94           O  
ATOM  13009  N   PHE    14      84.004  30.303  46.254  1.00 30.40           N  
ATOM  13010  CA  PHE    14      82.959  31.278  46.509  1.00 30.42           C  
ATOM  13011  C   PHE    14      81.595  30.647  46.801  1.00 31.05           C  
ATOM  13012  O   PHE    14      81.170  29.691  46.147  1.00 30.75           O  
ATOM  13013  CB  PHE    14      82.829  32.227  45.312  1.00 29.97           C  
ATOM  13014  CG  PHE    14      84.106  32.886  44.930  1.00 28.80           C  
ATOM  13015  CD1 PHE    14      84.494  34.057  45.537  1.00 29.32           C  
ATOM  13016  CD2 PHE    14      84.924  32.336  43.954  1.00 28.91           C  
ATOM  13017  CE1 PHE    14      85.688  34.670  45.177  1.00 27.83           C  
ATOM  13018  CE2 PHE    14      86.114  32.938  43.594  1.00 28.84           C  
ATOM  13019  CZ  PHE    14      86.494  34.108  44.214  1.00 28.76           C  
ATOM  13020  N   THR    15      80.906  31.228  47.769  1.00 31.89           N  
ATOM  13021  CA  THR    15      79.480  31.011  47.934  1.00 33.07           C  
ATOM  13022  C   THR    15      78.738  32.270  47.471  1.00 33.07           C  
ATOM  13023  O   THR    15      79.306  33.390  47.471  1.00 32.98           O  
ATOM  13024  CB  THR    15      79.142  30.676  49.406  1.00 33.77           C  
ATOM  13025  OG1 THR    15      79.407  31.816  50.239  1.00 37.27           O  
ATOM  13026  CG2 THR    15      79.988  29.500  49.902  1.00 32.51           C  
ATOM  13027  N   LEU    16      77.488  32.100  47.043  1.00 32.88           N  
ATOM  13028  CA  LEU    16      76.696  33.230  46.573  1.00 32.59           C  
ATOM  13029  C   LEU    16      76.163  34.007  47.767  1.00 33.08           C  
ATOM  13030  O   LEU    16      75.580  33.413  48.678  1.00 32.54           O  
ATOM  13031  CB  LEU    16      75.513  32.781  45.706  1.00 32.47           C  
ATOM  13032  CG  LEU    16      75.834  32.190  44.332  1.00 31.50           C  
ATOM  13033  CD1 LEU    16      74.534  31.595  43.670  1.00 29.77           C  
ATOM  13034  CD2 LEU    16      76.521  33.215  43.434  1.00 28.44           C  
ATOM  13035  N   PRO    17      76.338  35.334  47.771  1.00 33.26           N  
ATOM  13036  CA  PRO    17      75.694  36.103  48.823  1.00 33.95           C  
ATOM  13037  C   PRO    17      74.202  36.176  48.577  1.00 35.74           C  
ATOM  13038  O   PRO    17      73.743  35.890  47.461  1.00 35.40           O  
ATOM  13039  CB  PRO    17      76.304  37.492  48.650  1.00 33.84           C  
ATOM  13040  CG  PRO    17      76.630  37.570  47.219  1.00 33.42           C  
ATOM  13041  CD  PRO    17      77.081  36.198  46.835  1.00 32.52           C  
ATOM  13042  N   VAL    18      73.449  36.584  49.596  1.00 37.90           N  
ATOM  13043  CA  VAL    18      72.045  36.963  49.389  1.00 39.41           C  
ATOM  13044  C   VAL    18      71.995  38.269  48.568  1.00 40.41           C  
ATOM  13045  O   VAL    18      71.230  38.389  47.586  1.00 42.23           O  
ATOM  13046  CB  VAL    18      71.308  37.200  50.710  1.00 39.67           C  
ATOM  13047  CG1 VAL    18      71.505  36.006  51.656  1.00 40.20           C  
ATOM  13048  CG2 VAL    18      71.762  38.513  51.345  1.00 39.98           C  
ATOM  13049  N   ALA    23      66.158  48.786  48.809  1.00 42.30           N  
ATOM  13050  CA  ALA    23      64.939  49.472  48.343  1.00 41.72           C  
ATOM  13051  C   ALA    23      65.286  50.838  47.711  1.00 41.82           C  
ATOM  13052  O   ALA    23      65.606  51.804  48.439  1.00 42.33           O  
ATOM  13053  CB  ALA    23      63.942  49.647  49.513  1.00 42.49           C  
ATOM  13054  N   ALA    24      65.243  50.926  46.370  1.00 40.52           N  
ATOM  13055  CA  ALA    24      65.678  52.154  45.678  1.00 38.94           C  
ATOM  13056  C   ALA    24      64.979  52.405  44.337  1.00 37.86           C  
ATOM  13057  O   ALA    24      64.258  51.549  43.818  1.00 37.65           O  
ATOM  13058  CB  ALA    24      67.220  52.130  45.485  1.00 39.16           C  
ATOM  13059  N   ASN    25      65.207  53.597  43.784  1.00 35.84           N  
ATOM  13060  CA  ASN    25      64.676  53.977  42.458  1.00 34.71           C  
ATOM  13061  C   ASN    25      65.420  53.350  41.277  1.00 32.01           C  
ATOM  13062  O   ASN    25      64.955  53.404  40.128  1.00 30.65           O  
ATOM  13063  CB  ASN    25      64.628  55.506  42.327  1.00 34.31           C  
ATOM  13064  CG  ASN    25      63.556  56.116  43.221  1.00 34.82           C  
ATOM  13065  OD1 ASN    25      63.757  57.167  43.838  1.00 36.03           O  
ATOM  13066  ND2 ASN    25      62.419  55.419  43.327  1.00 31.59           N  
ATOM  13067  N   TYR    26      66.570  52.763  41.572  1.00 30.18           N  
ATOM  13068  CA  TYR    26      67.208  51.824  40.653  1.00 28.61           C  
ATOM  13069  C   TYR    26      67.192  50.433  41.287  1.00 26.27           C  
ATOM  13070  O   TYR    26      67.222  50.261  42.514  1.00 25.81           O  
ATOM  13071  CB  TYR    26      68.625  52.246  40.221  1.00 28.83           C  
ATOM  13072  CG  TYR    26      69.621  52.398  41.339  1.00 30.60           C  
ATOM  13073  CD1 TYR    26      70.670  51.493  41.495  1.00 30.95           C  
ATOM  13074  CD2 TYR    26      69.522  53.456  42.230  1.00 30.60           C  
ATOM  13075  CE1 TYR    26      71.582  51.635  42.510  1.00 30.87           C  
ATOM  13076  CE2 TYR    26      70.411  53.597  43.267  1.00 32.36           C  
ATOM  13077  CZ  TYR    26      71.447  52.689  43.404  1.00 32.75           C  
ATOM  13078  OH  TYR    26      72.352  52.852  44.448  1.00 34.31           O  
ATOM  13079  N   VAL    27      67.135  49.446  40.418  1.00 24.17           N  
ATOM  13080  CA  VAL    27      67.030  48.071  40.817  1.00 22.92           C  
ATOM  13081  C   VAL    27      68.271  47.271  40.393  1.00 22.47           C  
ATOM  13082  O   VAL    27      68.985  47.662  39.463  1.00 20.80           O  
ATOM  13083  CB  VAL    27      65.757  47.458  40.209  1.00 22.53           C  
ATOM  13084  CG1 VAL    27      64.536  48.064  40.881  1.00 24.05           C  
ATOM  13085  CG2 VAL    27      65.709  47.685  38.675  1.00 20.19           C  
ATOM  13086  N   PRO    28      68.514  46.135  41.065  1.00 22.19           N  
ATOM  13087  CA  PRO    28      69.643  45.282  40.693  1.00 22.05           C  
ATOM  13088  C   PRO    28      69.576  44.646  39.313  1.00 21.32           C  
ATOM  13089  O   PRO    28      70.620  44.298  38.758  1.00 19.41           O  
ATOM  13090  CB  PRO    28      69.645  44.208  41.765  1.00 23.32           C  
ATOM  13091  CG  PRO    28      68.744  44.705  42.839  1.00 24.78           C  
ATOM  13092  CD  PRO    28      67.767  45.580  42.209  1.00 22.87           C  
ATOM  13093  N   PHE    29      68.366  44.511  38.760  1.00 20.74           N  
ATOM  13094  CA  PHE    29      68.186  43.931  37.454  1.00 21.35           C  
ATOM  13095  C   PHE    29      66.815  44.278  36.885  1.00 20.78           C  
ATOM  13096  O   PHE    29      65.876  44.597  37.615  1.00 20.82           O  
ATOM  13097  CB  PHE    29      68.410  42.392  37.475  1.00 21.85           C  
ATOM  13098  CG  PHE    29      67.437  41.650  38.360  1.00 22.44           C  
ATOM  13099  CD1 PHE    29      66.175  41.334  37.907  1.00 24.23           C  
ATOM  13100  CD2 PHE    29      67.776  41.337  39.664  1.00 24.23           C  
ATOM  13101  CE1 PHE    29      65.265  40.664  38.746  1.00 23.72           C  
ATOM  13102  CE2 PHE    29      66.883  40.698  40.489  1.00 26.07           C  
ATOM  13103  CZ  PHE    29      65.623  40.381  40.031  1.00 24.55           C  
ATOM  13104  N   THR    30      66.753  44.281  35.568  1.00 21.11           N  
ATOM  13105  CA  THR    30      65.491  44.370  34.819  1.00 22.00           C  
ATOM  13106  C   THR    30      65.480  43.293  33.752  1.00 22.35           C  
ATOM  13107  O   THR    30      66.525  42.798  33.356  1.00 21.01           O  
ATOM  13108  CB  THR    30      65.298  45.735  34.132  1.00 22.63           C  
ATOM  13109  OG1 THR    30      66.405  46.020  33.266  1.00 22.53           O  
ATOM  13110  CG2 THR    30      65.139  46.846  35.164  1.00 21.28           C  
ATOM  13111  N   ILE    31      64.276  42.943  33.280  1.00 23.19           N  
ATOM  13112  CA  ILE    31      64.104  41.993  32.189  1.00 23.67           C  
ATOM  13113  C   ILE    31      63.288  42.634  31.087  1.00 23.56           C  
ATOM  13114  O   ILE    31      62.269  43.294  31.331  1.00 24.21           O  
ATOM  13115  CB  ILE    31      63.424  40.684  32.664  1.00 23.86           C  
ATOM  13116  CG1 ILE    31      64.303  39.977  33.687  1.00 23.74           C  
ATOM  13117  CG2 ILE    31      63.169  39.723  31.486  1.00 24.39           C  
ATOM  13118  CD1 ILE    31      63.577  38.878  34.465  1.00 25.28           C  
ATOM  13119  N   SER    32      63.757  42.461  29.874  1.00 24.00           N  
ATOM  13120  CA  SER    32      63.011  42.846  28.692  1.00 25.73           C  
ATOM  13121  C   SER    32      63.058  41.677  27.730  1.00 25.64           C  
ATOM  13122  O   SER    32      64.122  41.331  27.246  1.00 25.50           O  
ATOM  13123  CB  SER    32      63.598  44.073  28.021  1.00 25.81           C  
ATOM  13124  OG  SER    32      62.809  44.432  26.913  1.00 27.19           O  
ATOM  13125  N   GLY    33      61.903  41.083  27.430  1.00 26.33           N  
ATOM  13126  CA  GLY    33      61.899  39.878  26.629  1.00 26.22           C  
ATOM  13127  C   GLY    33      62.655  38.771  27.314  1.00 25.36           C  
ATOM  13128  O   GLY    33      62.370  38.424  28.457  1.00 26.34           O  
ATOM  13129  N   ASN    34      63.633  38.209  26.622  1.00 24.98           N  
ATOM  13130  CA  ASN    34      64.458  37.178  27.241  1.00 25.51           C  
ATOM  13131  C   ASN    34      65.858  37.705  27.552  1.00 24.78           C  
ATOM  13132  O   ASN    34      66.804  36.930  27.584  1.00 24.18           O  
ATOM  13133  CB  ASN    34      64.528  35.934  26.371  1.00 27.08           C  
ATOM  13134  CG  ASN    34      65.282  36.158  25.091  1.00 30.55           C  
ATOM  13135  OD1 ASN    34      65.607  37.305  24.738  1.00 35.31           O  
ATOM  13136  ND2 ASN    34      65.586  35.057  24.371  1.00 35.76           N  
ATOM  13137  N   LEU    35      65.983  39.022  27.699  1.00 24.55           N  
ATOM  13138  CA  LEU    35      67.277  39.637  28.078  1.00 24.12           C  
ATOM  13139  C   LEU    35      67.189  40.157  29.496  1.00 23.03           C  
ATOM  13140  O   LEU    35      66.268  40.868  29.847  1.00 23.05           O  
ATOM  13141  CB  LEU    35      67.702  40.736  27.096  1.00 24.76           C  
ATOM  13142  CG  LEU    35      68.282  40.199  25.764  1.00 26.16           C  
ATOM  13143  CD1 LEU    35      68.633  41.334  24.793  1.00 28.97           C  
ATOM  13144  CD2 LEU    35      69.489  39.249  25.947  1.00 28.49           C  
ATOM  13145  N   LEU    36      68.148  39.763  30.315  1.00 21.64           N  
ATOM  13146  CA  LEU    36      68.250  40.214  31.693  1.00 20.97           C  
ATOM  13147  C   LEU    36      69.421  41.199  31.776  1.00 20.61           C  
ATOM  13148  O   LEU    36      70.562  40.854  31.376  1.00 21.20           O  
ATOM  13149  CB  LEU    36      68.532  39.046  32.613  1.00 21.41           C  
ATOM  13150  CG  LEU    36      68.789  39.264  34.102  1.00 21.35           C  
ATOM  13151  CD1 LEU    36      67.603  39.957  34.807  1.00 23.14           C  
ATOM  13152  CD2 LEU    36      69.179  37.943  34.804  1.00 22.93           C  
ATOM  13153  N   TYR    37      69.112  42.393  32.255  1.00 19.52           N  
ATOM  13154  CA  TYR    37      70.093  43.483  32.452  1.00 19.94           C  
ATOM  13155  C   TYR    37      70.430  43.581  33.906  1.00 19.30           C  
ATOM  13156  O   TYR    37      69.576  43.954  34.684  1.00 18.49           O  
ATOM  13157  CB  TYR    37      69.527  44.816  32.021  1.00 21.62           C  
ATOM  13158  CG  TYR    37      69.633  45.044  30.561  1.00 24.97           C  
ATOM  13159  CD1 TYR    37      70.608  45.901  30.041  1.00 26.99           C  
ATOM  13160  CD2 TYR    37      68.798  44.384  29.690  1.00 26.43           C  
ATOM  13161  CE1 TYR    37      70.711  46.099  28.690  1.00 28.18           C  
ATOM  13162  CE2 TYR    37      68.902  44.583  28.309  1.00 27.61           C  
ATOM  13163  CZ  TYR    37      69.839  45.424  27.829  1.00 26.70           C  
ATOM  13164  OH  TYR    37      69.928  45.651  26.474  1.00 28.34           O  
ATOM  13165  N   VAL    38      71.680  43.277  34.255  1.00 18.12           N  
ATOM  13166  CA  VAL    38      72.116  43.284  35.635  1.00 17.38           C  
ATOM  13167  C   VAL    38      72.897  44.591  35.852  1.00 17.03           C  
ATOM  13168  O   VAL    38      73.783  44.948  35.040  1.00 16.35           O  
ATOM  13169  CB  VAL    38      72.994  42.065  35.962  1.00 17.22           C  
ATOM  13170  CG1 VAL    38      73.488  42.113  37.378  1.00 16.68           C  
ATOM  13171  CG2 VAL    38      72.228  40.778  35.704  1.00 19.02           C  
ATOM  13172  N   SER    39      72.542  45.277  36.935  1.00 16.21           N  
ATOM  13173  CA  SER    39      73.190  46.537  37.340  1.00 16.77           C  
ATOM  13174  C   SER    39      74.675  46.307  37.694  1.00 16.42           C  
ATOM  13175  O   SER    39      75.066  45.194  38.084  1.00 16.79           O  
ATOM  13176  CB  SER    39      72.491  47.130  38.559  1.00 16.39           C  
ATOM  13177  OG  SER    39      71.232  47.673  38.217  1.00 16.94           O  
ATOM  13178  N   GLY    40      75.498  47.355  37.547  1.00 16.71           N  
ATOM  13179  CA  GLY    40      76.913  47.251  37.877  1.00 16.17           C  
ATOM  13180  C   GLY    40      77.093  46.701  39.267  1.00 16.82           C  
ATOM  13181  O   GLY    40      76.479  47.191  40.216  1.00 16.75           O  
ATOM  13182  N   GLN    41      77.848  45.617  39.375  1.00 16.68           N  
ATOM  13183  CA  GLN    41      78.114  44.996  40.668  1.00 17.30           C  
ATOM  13184  C   GLN    41      79.538  45.360  41.116  1.00 16.88           C  
ATOM  13185  O   GLN    41      80.451  45.399  40.295  1.00 17.16           O  
ATOM  13186  CB  GLN    41      77.943  43.460  40.588  1.00 17.03           C  
ATOM  13187  CG  GLN    41      76.522  42.993  40.194  1.00 18.15           C  
ATOM  13188  CD  GLN    41      75.491  43.430  41.175  1.00 18.41           C  
ATOM  13189  OE1 GLN    41      75.559  43.081  42.360  1.00 18.42           O  
ATOM  13190  NE2 GLN    41      74.513  44.191  40.705  1.00 18.08           N  
ATOM  13191  N   LEU    42      79.675  45.523  42.425  1.00 18.51           N  
ATOM  13192  CA  LEU    42      80.922  45.823  43.142  1.00 19.27           C  
ATOM  13193  C   LEU    42      81.505  44.544  43.800  1.00 20.59           C  
ATOM  13194  O   LEU    42      80.809  43.508  43.933  1.00 20.90           O  
ATOM  13195  CB  LEU    42      80.648  46.893  44.195  1.00 19.83           C  
ATOM  13196  CG  LEU    42      80.007  48.193  43.701  1.00 20.09           C  
ATOM  13197  CD1 LEU    42      79.893  49.256  44.830  1.00 24.19           C  
ATOM  13198  CD2 LEU    42      80.773  48.751  42.474  1.00 20.92           C  
ATOM  13199  N   PRO    43      82.784  44.590  44.204  1.00 20.99           N  
ATOM  13200  CA  PRO    43      83.390  43.388  44.739  1.00 22.23           C  
ATOM  13201  C   PRO    43      82.987  43.165  46.205  1.00 23.30           C  
ATOM  13202  O   PRO    43      83.833  43.267  47.123  1.00 23.87           O  
ATOM  13203  CB  PRO    43      84.886  43.654  44.574  1.00 22.24           C  
ATOM  13204  CG  PRO    43      85.021  45.107  44.597  1.00 22.74           C  
ATOM  13205  CD  PRO    43      83.747  45.711  44.125  1.00 20.90           C  
ATOM  13206  N   MET    44      81.695  42.863  46.396  1.00 24.94           N  
ATOM  13207  CA  MET    44      81.111  42.668  47.725  1.00 26.76           C  
ATOM  13208  C   MET    44      81.416  41.303  48.250  1.00 27.78           C  
ATOM  13209  O   MET    44      81.216  40.309  47.554  1.00 26.94           O  
ATOM  13210  CB  MET    44      79.606  42.768  47.701  1.00 28.72           C  
ATOM  13211  CG  MET    44      79.087  44.003  47.142  1.00 34.04           C  
ATOM  13212  SD  MET    44      79.675  45.517  48.177  1.00 52.29          SE  
ATOM  13213  CE  MET    44      78.069  46.599  47.655  1.00 42.80           C  
ATOM  13214  N   GLU    45      81.866  41.277  49.503  1.00 28.96           N  
ATOM  13215  CA  GLU    45      82.155  40.050  50.199  1.00 30.57           C  
ATOM  13216  C   GLU    45      81.806  40.268  51.663  1.00 30.94           C  
ATOM  13217  O   GLU    45      82.239  41.230  52.276  1.00 29.35           O  
ATOM  13218  CB  GLU    45      83.615  39.704  50.030  1.00 31.01           C  
ATOM  13219  CG  GLU    45      83.899  38.254  50.285  1.00 32.83           C  
ATOM  13220  CD  GLU    45      85.369  37.906  50.169  1.00 34.03           C  
ATOM  13221  OE1 GLU    45      86.236  38.800  50.290  1.00 40.50           O  
ATOM  13222  OE2 GLU    45      85.665  36.719  49.956  1.00 39.11           O  
ATOM  13223  N   SER    46      80.980  39.381  52.208  1.00 32.41           N  
ATOM  13224  CA  SER    46      80.473  39.546  53.558  1.00 33.11           C  
ATOM  13225  C   SER    46      79.902  40.921  53.829  1.00 32.96           C  
ATOM  13226  O   SER    46      80.092  41.474  54.907  1.00 33.73           O  
ATOM  13227  CB  SER    46      81.576  39.245  54.550  1.00 33.85           C  
ATOM  13228  OG  SER    46      82.071  37.929  54.341  1.00 36.10           O  
ATOM  13229  N   GLY    47      79.201  41.482  52.851  1.00 32.72           N  
ATOM  13230  CA  GLY    47      78.556  42.782  53.023  1.00 32.20           C  
ATOM  13231  C   GLY    47      79.457  44.008  52.954  1.00 31.89           C  
ATOM  13232  O   GLY    47      78.988  45.134  53.165  1.00 32.53           O  
ATOM  13233  N   LYS    48      80.735  43.805  52.632  1.00 31.36           N  
ATOM  13234  CA  LYS    48      81.710  44.889  52.589  1.00 31.00           C  
ATOM  13235  C   LYS    48      82.340  44.938  51.204  1.00 29.19           C  
ATOM  13236  O   LYS    48      82.428  43.919  50.525  1.00 27.85           O  
ATOM  13237  CB  LYS    48      82.812  44.643  53.628  1.00 32.10           C  
ATOM  13238  CG  LYS    48      82.320  44.278  55.056  1.00 33.77           C  
ATOM  13239  CD  LYS    48      83.517  44.073  55.997  1.00 34.85           C  
ATOM  13240  CE  LYS    48      83.212  43.172  57.223  1.00 38.54           C  
ATOM  13241  NZ  LYS    48      82.691  41.784  56.927  1.00 41.89           N  
ATOM  13242  N   ILE    49      82.793  46.114  50.786  1.00 27.46           N  
ATOM  13243  CA  ILE    49      83.609  46.197  49.556  1.00 27.51           C  
ATOM  13244  C   ILE    49      84.994  45.615  49.890  1.00 26.44           C  
ATOM  13245  O   ILE    49      85.717  46.162  50.719  1.00 27.76           O  
ATOM  13246  CB  ILE    49      83.727  47.641  48.999  1.00 27.35           C  
ATOM  13247  CG1 ILE    49      82.339  48.250  48.725  1.00 28.61           C  
ATOM  13248  CG2 ILE    49      84.568  47.654  47.687  1.00 25.90           C  
ATOM  13249  CD1 ILE    49      81.640  47.702  47.484  1.00 29.88           C  
ATOM  13250  N   ALA    50      85.329  44.473  49.299  1.00 24.66           N  
ATOM  13251  CA  ALA    50      86.524  43.716  49.675  1.00 23.88           C  
ATOM  13252  C   ALA    50      87.844  44.216  49.077  1.00 22.88           C  
ATOM  13253  O   ALA    50      88.926  43.916  49.616  1.00 23.36           O  
ATOM  13254  CB  ALA    50      86.342  42.241  49.306  1.00 24.42           C  
ATOM  13255  N   VAL    51      87.773  44.926  47.958  1.00 20.81           N  
ATOM  13256  CA  VAL    51      88.968  45.381  47.241  1.00 19.75           C  
ATOM  13257  C   VAL    51      88.716  46.833  46.772  1.00 19.50           C  
ATOM  13258  O   VAL    51      87.820  47.092  45.950  1.00 18.36           O  
ATOM  13259  CB  VAL    51      89.299  44.506  46.034  1.00 19.25           C  
ATOM  13260  CG1 VAL    51      90.619  44.969  45.369  1.00 17.95           C  
ATOM  13261  CG2 VAL    51      89.337  42.997  46.410  1.00 19.82           C  
ATOM  13262  N   THR    52      89.518  47.761  47.290  1.00 18.83           N  
ATOM  13263  CA  THR    52      89.331  49.192  47.048  1.00 18.76           C  
ATOM  13264  C   THR    52      90.623  49.886  46.577  1.00 17.15           C  
ATOM  13265  O   THR    52      91.752  49.426  46.833  1.00 18.57           O  
ATOM  13266  CB  THR    52      88.801  49.933  48.274  1.00 19.87           C  
ATOM  13267  OG1 THR    52      89.751  49.836  49.341  1.00 20.52           O  
ATOM  13268  CG2 THR    52      87.440  49.358  48.732  1.00 20.18           C  
ATOM  13269  N   GLY    53      90.427  50.980  45.853  1.00 16.63           N  
ATOM  13270  CA  GLY    53      91.523  51.794  45.378  1.00 15.81           C  
ATOM  13271  C   GLY    53      91.866  51.490  43.935  1.00 16.34           C  
ATOM  13272  O   GLY    53      91.220  50.657  43.238  1.00 16.41           O  
ATOM  13273  N   LEU    54      92.852  52.232  43.462  1.00 14.89           N  
ATOM  13274  CA  LEU    54      93.241  52.192  42.046  1.00 15.09           C  
ATOM  13275  C   LEU    54      94.198  51.052  41.691  1.00 14.82           C  
ATOM  13276  O   LEU    54      95.217  50.830  42.343  1.00 15.74           O  
ATOM  13277  CB  LEU    54      93.870  53.539  41.641  1.00 14.99           C  
ATOM  13278  CG  LEU    54      93.016  54.794  41.893  1.00 16.43           C  
ATOM  13279  CD1 LEU    54      93.853  56.129  41.629  1.00 14.43           C  
ATOM  13280  CD2 LEU    54      91.711  54.771  41.099  1.00 18.58           C  
ATOM  13281  N   VAL    55      93.881  50.333  40.618  1.00 15.10           N  
ATOM  13282  CA  VAL    55      94.798  49.303  40.117  1.00 15.22           C  
ATOM  13283  C   VAL    55      96.009  50.038  39.509  1.00 15.52           C  
ATOM  13284  O   VAL    55      95.867  51.023  38.743  1.00 15.49           O  
ATOM  13285  CB  VAL    55      94.147  48.295  39.122  1.00 15.34           C  
ATOM  13286  CG1 VAL    55      95.143  47.202  38.776  1.00 16.34           C  
ATOM  13287  CG2 VAL    55      92.798  47.747  39.668  1.00 14.16           C  
ATOM  13288  N   GLY    56      97.188  49.598  39.915  1.00 15.44           N  
ATOM  13289  CA  GLY    56      98.449  50.244  39.536  1.00 16.28           C  
ATOM  13290  C   GLY    56      98.942  51.219  40.587  1.00 16.32           C  
ATOM  13291  O   GLY    56     100.026  51.780  40.450  1.00 16.29           O  
ATOM  13292  N   ARG    57      98.166  51.390  41.665  1.00 16.32           N  
ATOM  13293  CA  ARG    57      98.571  52.249  42.778  1.00 16.70           C  
ATOM  13294  C   ARG    57      98.304  51.594  44.106  1.00 16.10           C  
ATOM  13295  O   ARG    57      99.218  51.357  44.886  1.00 17.03           O  
ATOM  13296  CB  ARG    57      97.873  53.603  42.715  1.00 15.72           C  
ATOM  13297  CG  ARG    57      98.244  54.497  43.885  1.00 16.84           C  
ATOM  13298  CD  ARG    57      97.659  55.894  43.877  1.00 15.89           C  
ATOM  13299  NE  ARG    57      98.101  56.563  45.097  1.00 15.63           N  
ATOM  13300  CZ  ARG    57      99.287  57.153  45.256  1.00 16.91           C  
ATOM  13301  NH1 ARG    57     100.160  57.249  44.259  1.00 13.83           N  
ATOM  13302  NH2 ARG    57      99.613  57.651  46.435  1.00 15.00           N  
ATOM  13303  N   ASP    58      97.051  51.278  44.341  1.00 16.23           N  
ATOM  13304  CA  ASP    58      96.620  50.693  45.608  1.00 16.54           C  
ATOM  13305  C   ASP    58      96.524  49.169  45.557  1.00 16.62           C  
ATOM  13306  O   ASP    58      96.664  48.506  46.600  1.00 16.58           O  
ATOM  13307  CB  ASP    58      95.275  51.259  45.998  1.00 16.42           C  
ATOM  13308  CG  ASP    58      95.312  52.769  46.142  1.00 17.20           C  
ATOM  13309  OD1 ASP    58      96.112  53.243  46.982  1.00 19.65           O  
ATOM  13310  OD2 ASP    58      94.531  53.456  45.451  1.00 18.16           O  
ATOM  13311  N   VAL    59      96.242  48.632  44.377  1.00 16.45           N  
ATOM  13312  CA  VAL    59      96.058  47.197  44.212  1.00 17.77           C  
ATOM  13313  C   VAL    59      96.785  46.737  42.956  1.00 17.83           C  
ATOM  13314  O   VAL    59      96.926  47.493  41.987  1.00 17.33           O  
ATOM  13315  CB  VAL    59      94.554  46.767  44.189  1.00 18.87           C  
ATOM  13316  CG1 VAL    59      93.778  47.334  45.449  1.00 21.82           C  
ATOM  13317  CG2 VAL    59      93.896  47.197  42.965  1.00 21.44           C  
ATOM  13318  N   ASP    60      97.285  45.515  43.025  1.00 18.74           N  
ATOM  13319  CA  ASP    60      97.964  44.879  41.909  1.00 19.34           C  
ATOM  13320  C   ASP    60      96.992  44.080  41.043  1.00 19.48           C  
ATOM  13321  O   ASP    60      95.805  44.037  41.332  1.00 19.40           O  
ATOM  13322  CB  ASP    60      99.147  44.040  42.405  1.00 20.89           C  
ATOM  13323  CG  ASP    60      98.757  42.848  43.254  1.00 21.21           C  
ATOM  13324  OD1 ASP    60      97.589  42.484  43.394  1.00 22.81           O  
ATOM  13325  OD2 ASP    60      99.713  42.231  43.792  1.00 30.25           O  
ATOM  13326  N   VAL    61      97.486  43.487  39.967  1.00 18.59           N  
ATOM  13327  CA  VAL    61      96.614  42.760  39.045  1.00 19.30           C  
ATOM  13328  C   VAL    61      95.938  41.568  39.757  1.00 18.76           C  
ATOM  13329  O   VAL    61      94.732  41.355  39.623  1.00 19.22           O  
ATOM  13330  CB  VAL    61      97.352  42.330  37.761  1.00 19.44           C  
ATOM  13331  CG1 VAL    61      96.504  41.337  36.953  1.00 20.46           C  
ATOM  13332  CG2 VAL    61      97.699  43.573  36.911  1.00 19.62           C  
ATOM  13333  N   ALA    62      96.695  40.801  40.523  1.00 18.89           N  
ATOM  13334  CA  ALA    62      96.120  39.649  41.215  1.00 19.10           C  
ATOM  13335  C   ALA    62      94.973  40.048  42.139  1.00 19.10           C  
ATOM  13336  O   ALA    62      93.905  39.417  42.132  1.00 18.61           O  
ATOM  13337  CB  ALA    62      97.209  38.899  42.012  1.00 19.82           C  
ATOM  13338  N   SER    63      95.178  41.088  42.960  1.00 18.52           N  
ATOM  13339  CA  SER    63      94.126  41.541  43.854  1.00 19.00           C  
ATOM  13340  C   SER    63      92.917  42.037  43.057  1.00 18.56           C  
ATOM  13341  O   SER    63      91.790  41.803  43.432  1.00 18.58           O  
ATOM  13342  CB  SER    63      94.622  42.645  44.745  1.00 19.24           C  
ATOM  13343  OG  SER    63      95.617  42.148  45.586  1.00 20.64           O  
ATOM  13344  N   ALA    64      93.164  42.778  41.983  1.00 18.32           N  
ATOM  13345  CA  ALA    64      92.088  43.282  41.124  1.00 18.22           C  
ATOM  13346  C   ALA    64      91.295  42.123  40.447  1.00 17.22           C  
ATOM  13347  O   ALA    64      90.093  42.203  40.247  1.00 15.74           O  
ATOM  13348  CB  ALA    64      92.667  44.231  40.071  1.00 18.00           C  
ATOM  13349  N   GLN    65      92.005  41.065  40.095  1.00 18.13           N  
ATOM  13350  CA  GLN    65      91.374  39.867  39.554  1.00 19.19           C  
ATOM  13351  C   GLN    65      90.392  39.274  40.566  1.00 19.55           C  
ATOM  13352  O   GLN    65      89.268  38.896  40.194  1.00 19.43           O  
ATOM  13353  CB  GLN    65      92.424  38.845  39.097  1.00 18.99           C  
ATOM  13354  CG  GLN    65      93.078  39.208  37.762  1.00 19.83           C  
ATOM  13355  CD  GLN    65      94.275  38.344  37.421  1.00 19.98           C  
ATOM  13356  OE1 GLN    65      94.942  37.792  38.312  1.00 23.49           O  
ATOM  13357  NE2 GLN    65      94.541  38.184  36.114  1.00 20.84           N  
ATOM  13358  N   ARG    66      90.789  39.194  41.835  1.00 20.27           N  
ATOM  13359  CA  ARG    66      89.877  38.774  42.884  1.00 19.80           C  
ATOM  13360  C   ARG    66      88.688  39.723  43.034  1.00 19.12           C  
ATOM  13361  O   ARG    66      87.559  39.289  43.213  1.00 18.72           O  
ATOM  13362  CB  ARG    66      90.597  38.676  44.215  1.00 21.46           C  
ATOM  13363  CG  ARG    66      89.674  38.205  45.361  1.00 25.65           C  
ATOM  13364  CD  ARG    66      89.298  36.727  45.200  1.00 36.25           C  
ATOM  13365  NE  ARG    66      90.392  35.890  45.691  1.00 41.73           N  
ATOM  13366  CZ  ARG    66      90.704  34.644  45.300  1.00 44.24           C  
ATOM  13367  NH1 ARG    66      90.018  33.988  44.357  1.00 45.76           N  
ATOM  13368  NH2 ARG    66      91.746  34.039  45.876  1.00 45.36           N  
ATOM  13369  N   ALA    67      88.915  41.023  42.911  1.00 18.19           N  
ATOM  13370  CA  ALA    67      87.776  41.975  42.854  1.00 17.76           C  
ATOM  13371  C   ALA    67      86.826  41.622  41.708  1.00 17.38           C  
ATOM  13372  O   ALA    67      85.599  41.617  41.892  1.00 17.68           O  
ATOM  13373  CB  ALA    67      88.270  43.434  42.700  1.00 18.27           C  
ATOM  13374  N   ALA    68      87.399  41.298  40.541  1.00 16.79           N  
ATOM  13375  CA  ALA    68      86.601  40.982  39.365  1.00 17.36           C  
ATOM  13376  C   ALA    68      85.816  39.681  39.613  1.00 17.31           C  
ATOM  13377  O   ALA    68      84.630  39.612  39.301  1.00 17.42           O  
ATOM  13378  CB  ALA    68      87.459  40.881  38.124  1.00 16.52           C  
ATOM  13379  N   GLU    69      86.469  38.683  40.196  1.00 17.93           N  
ATOM  13380  CA  GLU    69      85.784  37.441  40.576  1.00 18.71           C  
ATOM  13381  C   GLU    69      84.583  37.751  41.484  1.00 18.93           C  
ATOM  13382  O   GLU    69      83.471  37.242  41.241  1.00 18.31           O  
ATOM  13383  CB  GLU    69      86.757  36.477  41.251  1.00 19.08           C  
ATOM  13384  CG  GLU    69      87.806  35.902  40.322  1.00 21.15           C  
ATOM  13385  CD  GLU    69      88.858  35.066  41.051  1.00 22.14           C  
ATOM  13386  OE1 GLU    69      89.114  35.313  42.248  1.00 26.87           O  
ATOM  13387  OE2 GLU    69      89.424  34.144  40.439  1.00 27.07           O  
ATOM  13388  N   LEU    70      84.785  38.602  42.502  1.00 18.58           N  
ATOM  13389  CA  LEU    70      83.696  38.968  43.407  1.00 18.83           C  
ATOM  13390  C   LEU    70      82.568  39.708  42.680  1.00 19.23           C  
ATOM  13391  O   LEU    70      81.381  39.501  42.991  1.00 19.11           O  
ATOM  13392  CB  LEU    70      84.211  39.780  44.620  1.00 19.41           C  
ATOM  13393  CG  LEU    70      85.076  39.021  45.631  1.00 19.00           C  
ATOM  13394  CD1 LEU    70      85.801  39.978  46.576  1.00 19.47           C  
ATOM  13395  CD2 LEU    70      84.185  37.995  46.377  1.00 21.35           C  
ATOM  13396  N   CYS    71      82.915  40.595  41.740  1.00 18.39           N  
ATOM  13397  CA  CYS    71      81.884  41.296  40.973  1.00 18.21           C  
ATOM  13398  C   CYS    71      81.020  40.255  40.259  1.00 18.12           C  
ATOM  13399  O   CYS    71      79.783  40.380  40.219  1.00 18.48           O  
ATOM  13400  CB  CYS    71      82.523  42.263  39.959  1.00 18.28           C  
ATOM  13401  SG  CYS    71      83.354  43.707  40.748  1.00 17.98           S  
ATOM  13402  N   ALA    72      81.702  39.258  39.697  1.00 18.14           N  
ATOM  13403  CA  ALA    72      81.087  38.152  38.925  1.00 18.89           C  
ATOM  13404  C   ALA    72      80.191  37.309  39.820  1.00 19.05           C  
ATOM  13405  O   ALA    72      79.114  36.921  39.394  1.00 18.95           O  
ATOM  13406  CB  ALA    72      82.163  37.286  38.228  1.00 19.28           C  
ATOM  13407  N   VAL    73      80.632  37.045  41.048  1.00 19.61           N  
ATOM  13408  CA  VAL    73      79.815  36.298  42.031  1.00 20.01           C  
ATOM  13409  C   VAL    73      78.521  37.045  42.369  1.00 20.13           C  
ATOM  13410  O   VAL    73      77.428  36.449  42.460  1.00 20.48           O  
ATOM  13411  CB  VAL    73      80.633  36.004  43.330  1.00 20.82           C  
ATOM  13412  CG1 VAL    73      79.714  35.513  44.502  1.00 21.02           C  
ATOM  13413  CG2 VAL    73      81.772  35.052  43.029  1.00 19.80           C  
ATOM  13414  N   ASN    74      78.651  38.353  42.525  1.00 20.11           N  
ATOM  13415  CA  ASN    74      77.538  39.245  42.782  1.00 19.82           C  
ATOM  13416  C   ASN    74      76.578  39.319  41.600  1.00 19.58           C  
ATOM  13417  O   ASN    74      75.340  39.315  41.782  1.00 19.11           O  
ATOM  13418  CB  ASN    74      78.047  40.618  43.245  1.00 21.09           C  
ATOM  13419  CG  ASN    74      78.475  40.618  44.708  1.00 20.96           C  
ATOM  13420  OD1 ASN    74      79.667  40.497  45.044  1.00 25.84           O  
ATOM  13421  ND2 ASN    74      77.513  40.757  45.583  1.00 21.36           N  
ATOM  13422  N   ILE    75      77.117  39.332  40.385  1.00 19.22           N  
ATOM  13423  CA  ILE    75      76.266  39.262  39.188  1.00 19.73           C  
ATOM  13424  C   ILE    75      75.449  37.952  39.240  1.00 19.91           C  
ATOM  13425  O   ILE    75      74.232  37.959  39.042  1.00 21.28           O  
ATOM  13426  CB  ILE    75      77.082  39.318  37.856  1.00 20.26           C  
ATOM  13427  CG1 ILE    75      77.721  40.707  37.642  1.00 20.27           C  
ATOM  13428  CG2 ILE    75      76.193  38.957  36.665  1.00 18.77           C  
ATOM  13429  CD1 ILE    75      78.803  40.768  36.489  1.00 19.64           C  
ATOM  13430  N   LEU    76      76.126  36.852  39.510  1.00 20.16           N  
ATOM  13431  CA  LEU    76      75.459  35.515  39.533  1.00 20.33           C  
ATOM  13432  C   LEU    76      74.366  35.460  40.615  1.00 20.78           C  
ATOM  13433  O   LEU    76      73.297  34.907  40.379  1.00 21.42           O  
ATOM  13434  CB  LEU    76      76.486  34.394  39.689  1.00 20.53           C  
ATOM  13435  CG  LEU    76      77.372  34.118  38.484  1.00 20.87           C  
ATOM  13436  CD1 LEU    76      78.458  33.098  38.825  1.00 22.97           C  
ATOM  13437  CD2 LEU    76      76.544  33.679  37.260  1.00 23.02           C  
ATOM  13438  N   ALA    77      74.614  36.063  41.784  1.00 21.14           N  
ATOM  13439  CA  ALA    77      73.597  36.165  42.832  1.00 21.04           C  
ATOM  13440  C   ALA    77      72.361  36.891  42.300  1.00 21.95           C  
ATOM  13441  O   ALA    77      71.217  36.466  42.522  1.00 21.90           O  
ATOM  13442  CB  ALA    77      74.162  36.883  44.086  1.00 20.99           C  
ATOM  13443  N   GLN    78      72.587  37.993  41.581  1.00 21.45           N  
ATOM  13444  CA  GLN    78      71.473  38.745  41.023  1.00 22.10           C  
ATOM  13445  C   GLN    78      70.713  37.927  39.965  1.00 21.79           C  
ATOM  13446  O   GLN    78      69.486  37.929  39.936  1.00 22.55           O  
ATOM  13447  CB  GLN    78      71.950  40.077  40.422  1.00 22.09           C  
ATOM  13448  CG  GLN    78      72.508  41.105  41.436  1.00 24.22           C  
ATOM  13449  CD  GLN    78      71.567  41.457  42.585  1.00 27.40           C  
ATOM  13450  OE1 GLN    78      70.352  41.227  42.543  1.00 31.81           O  
ATOM  13451  NE2 GLN    78      72.141  42.054  43.621  1.00 33.24           N  
ATOM  13452  N   VAL    79      71.444  37.235  39.103  1.00 22.19           N  
ATOM  13453  CA  VAL    79      70.817  36.392  38.091  1.00 22.65           C  
ATOM  13454  C   VAL    79      69.980  35.285  38.732  1.00 23.28           C  
ATOM  13455  O   VAL    79      68.872  35.003  38.273  1.00 23.03           O  
ATOM  13456  CB  VAL    79      71.835  35.795  37.119  1.00 23.12           C  
ATOM  13457  CG1 VAL    79      71.136  34.895  36.134  1.00 23.37           C  
ATOM  13458  CG2 VAL    79      72.623  36.932  36.374  1.00 22.03           C  
ATOM  13459  N   LYS    80      70.507  34.673  39.779  1.00 23.69           N  
ATOM  13460  CA  LYS    80      69.799  33.611  40.478  1.00 24.34           C  
ATOM  13461  C   LYS    80      68.501  34.164  41.053  1.00 25.02           C  
ATOM  13462  O   LYS    80      67.442  33.517  40.935  1.00 25.88           O  
ATOM  13463  CB  LYS    80      70.672  33.018  41.576  1.00 24.54           C  
ATOM  13464  CG  LYS    80      69.980  31.893  42.358  1.00 24.65           C  
ATOM  13465  CD  LYS    80      70.809  31.421  43.510  1.00 25.01           C  
ATOM  13466  CE  LYS    80      69.995  30.487  44.426  1.00 26.39           C  
ATOM  13467  NZ  LYS    80      70.884  29.674  45.302  1.00 27.82           N  
ATOM  13468  N   ALA    81      68.564  35.351  41.664  1.00 25.16           N  
ATOM  13469  CA  ALA    81      67.346  36.048  42.148  1.00 25.31           C  
ATOM  13470  C   ALA    81      66.342  36.341  41.017  1.00 25.95           C  
ATOM  13471  O   ALA    81      65.141  36.042  41.158  1.00 25.62           O  
ATOM  13472  CB  ALA    81      67.697  37.329  42.899  1.00 25.25           C  
ATOM  13473  N   ALA    82      66.827  36.906  39.908  1.00 25.86           N  
ATOM  13474  CA  ALA    82      66.008  37.146  38.720  1.00 26.45           C  
ATOM  13475  C   ALA    82      65.358  35.846  38.201  1.00 26.96           C  
ATOM  13476  O   ALA    82      64.253  35.900  37.645  1.00 27.66           O  
ATOM  13477  CB  ALA    82      66.813  37.773  37.611  1.00 25.68           C  
ATOM  13478  N   LEU    83      66.034  34.712  38.370  1.00 27.25           N  
ATOM  13479  CA  LEU    83      65.568  33.458  37.785  1.00 28.53           C  
ATOM  13480  C   LEU    83      64.892  32.546  38.810  1.00 29.77           C  
ATOM  13481  O   LEU    83      64.768  31.322  38.610  1.00 29.23           O  
ATOM  13482  CB  LEU    83      66.721  32.761  37.070  1.00 28.68           C  
ATOM  13483  CG  LEU    83      67.336  33.509  35.875  1.00 27.34           C  
ATOM  13484  CD1 LEU    83      68.442  32.677  35.265  1.00 27.66           C  
ATOM  13485  CD2 LEU    83      66.303  33.910  34.809  1.00 26.22           C  
ATOM  13486  N   ASN    84      64.439  33.159  39.895  1.00 30.56           N  
ATOM  13487  CA  ASN    84      63.729  32.463  40.972  1.00 32.17           C  
ATOM  13488  C   ASN    84      64.473  31.244  41.527  1.00 32.90           C  
ATOM  13489  O   ASN    84      63.869  30.207  41.867  1.00 33.06           O  
ATOM  13490  CB  ASN    84      62.309  32.124  40.501  1.00 32.69           C  
ATOM  13491  CG  ASN    84      61.490  33.372  40.221  1.00 35.55           C  
ATOM  13492  OD1 ASN    84      60.912  33.525  39.134  1.00 41.64           O  
ATOM  13493  ND2 ASN    84      61.455  34.290  41.192  1.00 39.24           N  
ATOM  13494  N   GLY    85      65.789  31.382  41.634  1.00 33.09           N  
ATOM  13495  CA  GLY    85      66.645  30.371  42.227  1.00 33.47           C  
ATOM  13496  C   GLY    85      67.306  29.487  41.196  1.00 34.39           C  
ATOM  13497  O   GLY    85      68.029  28.555  41.537  1.00 35.05           O  
ATOM  13498  N   ASP    86      67.097  29.793  39.927  1.00 35.62           N  
ATOM  13499  CA  ASP    86      67.425  28.850  38.869  1.00 36.87           C  
ATOM  13500  C   ASP    86      68.531  29.305  37.873  1.00 36.44           C  
ATOM  13501  O   ASP    86      68.241  29.668  36.744  1.00 36.29           O  
ATOM  13502  CB  ASP    86      66.107  28.532  38.145  1.00 37.68           C  
ATOM  13503  CG  ASP    86      66.135  27.208  37.412  1.00 40.66           C  
ATOM  13504  OD1 ASP    86      67.157  26.494  37.471  1.00 44.08           O  
ATOM  13505  OD2 ASP    86      65.116  26.881  36.763  1.00 45.09           O  
ATOM  13506  N   LEU    87      69.796  29.225  38.285  1.00 36.56           N  
ATOM  13507  CA  LEU    87      70.940  29.570  37.412  1.00 36.56           C  
ATOM  13508  C   LEU    87      71.040  28.748  36.105  1.00 36.34           C  
ATOM  13509  O   LEU    87      71.796  29.096  35.196  1.00 35.79           O  
ATOM  13510  CB  LEU    87      72.272  29.500  38.182  1.00 36.86           C  
ATOM  13511  CG  LEU    87      72.623  30.693  39.091  1.00 36.88           C  
ATOM  13512  CD1 LEU    87      73.967  30.459  39.777  1.00 36.37           C  
ATOM  13513  CD2 LEU    87      72.640  32.048  38.326  1.00 36.15           C  
ATOM  13514  N   SER    88      70.275  27.665  36.024  1.00 36.37           N  
ATOM  13515  CA  SER    88      70.251  26.801  34.847  1.00 35.94           C  
ATOM  13516  C   SER    88      69.374  27.362  33.727  1.00 35.17           C  
ATOM  13517  O   SER    88      69.432  26.891  32.595  1.00 35.24           O  
ATOM  13518  CB  SER    88      69.754  25.418  35.260  1.00 36.16           C  
ATOM  13519  OG  SER    88      68.473  25.510  35.846  1.00 37.19           O  
ATOM  13520  N   LYS    89      68.583  28.382  34.056  1.00 34.43           N  
ATOM  13521  CA  LYS    89      67.792  29.109  33.080  1.00 33.77           C  
ATOM  13522  C   LYS    89      68.571  30.213  32.358  1.00 32.24           C  
ATOM  13523  O   LYS    89      67.994  30.935  31.545  1.00 32.12           O  
ATOM  13524  CB  LYS    89      66.543  29.690  33.739  1.00 34.20           C  
ATOM  13525  CG  LYS    89      65.489  28.606  34.078  1.00 35.37           C  
ATOM  13526  CD  LYS    89      64.197  29.224  34.590  1.00 36.03           C  
ATOM  13527  CE  LYS    89      63.040  28.177  34.705  1.00 37.98           C  
ATOM  13528  NZ  LYS    89      62.891  27.610  36.082  1.00 39.34           N  
ATOM  13529  N   ILE    90      69.865  30.341  32.642  1.00 30.91           N  
ATOM  13530  CA  ILE    90      70.740  31.151  31.793  1.00 30.51           C  
ATOM  13531  C   ILE    90      70.915  30.437  30.434  1.00 30.01           C  
ATOM  13532  O   ILE    90      71.329  29.275  30.387  1.00 31.25           O  
ATOM  13533  CB  ILE    90      72.141  31.392  32.445  1.00 30.19           C  
ATOM  13534  CG1 ILE    90      72.004  32.133  33.787  1.00 29.03           C  
ATOM  13535  CG2 ILE    90      73.086  32.137  31.461  1.00 29.03           C  
ATOM  13536  CD1 ILE    90      73.322  32.266  34.564  1.00 30.48           C  
ATOM  13537  N   ARG    91      70.602  31.114  29.336  1.00 28.51           N  
ATOM  13538  CA  ARG    91      70.882  30.563  28.010  1.00 29.50           C  
ATOM  13539  C   ARG    91      72.270  30.959  27.522  1.00 27.41           C  
ATOM  13540  O   ARG    91      73.007  30.149  26.963  1.00 25.76           O  
ATOM  13541  CB  ARG    91      69.802  30.984  27.021  1.00 29.42           C  
ATOM  13542  CG  ARG    91      68.469  30.319  27.356  1.00 33.12           C  
ATOM  13543  CD  ARG    91      67.261  30.999  26.705  1.00 35.92           C  
ATOM  13544  NE  ARG    91      67.355  31.013  25.251  1.00 43.12           N  
ATOM  13545  CZ  ARG    91      67.218  29.942  24.465  1.00 46.08           C  
ATOM  13546  NH1 ARG    91      66.945  28.734  24.973  1.00 47.97           N  
ATOM  13547  NH2 ARG    91      67.346  30.092  23.143  1.00 46.98           N  
ATOM  13548  N   ARG    92      72.634  32.203  27.780  1.00 25.79           N  
ATOM  13549  CA  ARG    92      73.916  32.748  27.347  1.00 25.72           C  
ATOM  13550  C   ARG    92      74.201  34.042  28.094  1.00 23.76           C  
ATOM  13551  O   ARG    92      73.289  34.873  28.245  1.00 22.58           O  
ATOM  13552  CB  ARG    92      73.835  33.054  25.862  1.00 26.82           C  
ATOM  13553  CG  ARG    92      74.885  33.989  25.316  1.00 31.69           C  
ATOM  13554  CD  ARG    92      75.607  33.399  24.154  1.00 37.13           C  
ATOM  13555  NE  ARG    92      76.890  32.858  24.594  1.00 40.03           N  
ATOM  13556  CZ  ARG    92      77.376  31.648  24.306  1.00 42.08           C  
ATOM  13557  NH1 ARG    92      76.702  30.777  23.546  1.00 43.85           N  
ATOM  13558  NH2 ARG    92      78.569  31.303  24.771  1.00 40.04           N  
ATOM  13559  N   VAL    93      75.433  34.184  28.586  1.00 21.68           N  
ATOM  13560  CA  VAL    93      75.905  35.473  29.055  1.00 20.41           C  
ATOM  13561  C   VAL    93      76.303  36.221  27.782  1.00 20.28           C  
ATOM  13562  O   VAL    93      77.259  35.856  27.069  1.00 21.18           O  
ATOM  13563  CB  VAL    93      77.080  35.374  30.075  1.00 20.10           C  
ATOM  13564  CG1 VAL    93      77.543  36.778  30.511  1.00 20.34           C  
ATOM  13565  CG2 VAL    93      76.685  34.513  31.307  1.00 20.35           C  
ATOM  13566  N   ILE    94      75.543  37.252  27.472  1.00 19.62           N  
ATOM  13567  CA  ILE    94      75.707  37.970  26.218  1.00 19.82           C  
ATOM  13568  C   ILE    94      76.892  38.962  26.232  1.00 19.77           C  
ATOM  13569  O   ILE    94      77.686  39.016  25.272  1.00 19.63           O  
ATOM  13570  CB  ILE    94      74.405  38.688  25.859  1.00 20.18           C  
ATOM  13571  CG1 ILE    94      73.341  37.638  25.511  1.00 21.26           C  
ATOM  13572  CG2 ILE    94      74.574  39.644  24.658  1.00 20.74           C  
ATOM  13573  CD1 ILE    94      73.669  36.882  24.212  1.00 25.02           C  
ATOM  13574  N   LYS    95      77.009  39.701  27.338  1.00 19.20           N  
ATOM  13575  CA  LYS    95      77.963  40.817  27.444  1.00 18.28           C  
ATOM  13576  C   LYS    95      78.268  41.140  28.913  1.00 18.11           C  
ATOM  13577  O   LYS    95      77.377  41.166  29.740  1.00 17.68           O  
ATOM  13578  CB  LYS    95      77.362  42.031  26.756  1.00 18.02           C  
ATOM  13579  CG  LYS    95      78.180  43.334  26.821  1.00 18.92           C  
ATOM  13580  CD  LYS    95      79.388  43.233  25.899  1.00 17.97           C  
ATOM  13581  CE  LYS    95      80.246  44.514  25.891  1.00 19.41           C  
ATOM  13582  NZ  LYS    95      79.470  45.692  25.394  1.00 20.19           N  
ATOM  13583  N   LEU    96      79.537  41.389  29.220  1.00 18.19           N  
ATOM  13584  CA  LEU    96      79.951  41.957  30.513  1.00 17.80           C  
ATOM  13585  C   LEU    96      80.658  43.271  30.202  1.00 17.10           C  
ATOM  13586  O   LEU    96      81.468  43.325  29.258  1.00 17.15           O  
ATOM  13587  CB  LEU    96      80.942  41.045  31.244  1.00 18.83           C  
ATOM  13588  CG  LEU    96      80.585  39.667  31.800  1.00 20.85           C  
ATOM  13589  CD1 LEU    96      81.711  39.277  32.729  1.00 22.50           C  
ATOM  13590  CD2 LEU    96      79.206  39.674  32.520  1.00 21.93           C  
ATOM  13591  N   ASN    97      80.329  44.321  30.946  1.00 16.61           N  
ATOM  13592  CA  ASN    97      81.130  45.529  30.906  1.00 16.14           C  
ATOM  13593  C   ASN    97      81.933  45.623  32.183  1.00 15.02           C  
ATOM  13594  O   ASN    97      81.375  45.796  33.268  1.00 14.66           O  
ATOM  13595  CB  ASN    97      80.289  46.767  30.662  1.00 16.88           C  
ATOM  13596  CG  ASN    97      79.486  46.689  29.385  1.00 18.53           C  
ATOM  13597  OD1 ASN    97      78.257  46.535  29.404  1.00 23.42           O  
ATOM  13598  ND2 ASN    97      80.171  46.786  28.273  1.00 15.75           N  
ATOM  13599  N   GLY    98      83.256  45.563  32.012  1.00 14.82           N  
ATOM  13600  CA  GLY    98      84.185  45.561  33.119  1.00 15.02           C  
ATOM  13601  C   GLY    98      84.852  46.915  33.285  1.00 15.44           C  
ATOM  13602  O   GLY    98      85.617  47.349  32.412  1.00 16.65           O  
ATOM  13603  N   PHE    99      84.542  47.593  34.386  1.00 15.14           N  
ATOM  13604  CA  PHE    99      85.102  48.870  34.692  1.00 14.44           C  
ATOM  13605  C   PHE    99      86.167  48.697  35.768  1.00 14.30           C  
ATOM  13606  O   PHE    99      85.866  48.199  36.872  1.00 14.95           O  
ATOM  13607  CB  PHE    99      83.973  49.765  35.171  1.00 15.41           C  
ATOM  13608  CG  PHE    99      82.790  49.765  34.262  1.00 16.64           C  
ATOM  13609  CD1 PHE    99      82.914  50.201  32.953  1.00 22.14           C  
ATOM  13610  CD2 PHE    99      81.554  49.354  34.715  1.00 19.51           C  
ATOM  13611  CE1 PHE    99      81.807  50.224  32.110  1.00 22.73           C  
ATOM  13612  CE2 PHE    99      80.456  49.391  33.888  1.00 20.40           C  
ATOM  13613  CZ  PHE    99      80.577  49.822  32.604  1.00 19.17           C  
ATOM  13614  N   VAL   100      87.401  49.093  35.463  1.00 12.97           N  
ATOM  13615  CA  VAL   100      88.533  48.945  36.395  1.00 13.47           C  
ATOM  13616  C   VAL   100      89.113  50.315  36.797  1.00 13.53           C  
ATOM  13617  O   VAL   100      89.639  51.033  35.962  1.00 13.48           O  
ATOM  13618  CB  VAL   100      89.674  48.129  35.768  1.00 12.63           C  
ATOM  13619  CG1 VAL   100      90.810  47.914  36.819  1.00 13.13           C  
ATOM  13620  CG2 VAL   100      89.172  46.827  35.121  1.00 14.55           C  
ATOM  13621  N   ALA   101      89.018  50.651  38.073  1.00 13.61           N  
ATOM  13622  CA  ALA   101      89.573  51.922  38.591  1.00 13.39           C  
ATOM  13623  C   ALA   101      91.080  51.820  38.411  1.00 13.93           C  
ATOM  13624  O   ALA   101      91.703  50.866  38.925  1.00 12.78           O  
ATOM  13625  CB  ALA   101      89.195  52.132  40.064  1.00 13.54           C  
ATOM  13626  N   SER   102      91.652  52.751  37.644  1.00 13.96           N  
ATOM  13627  CA  SER   102      93.014  52.597  37.122  1.00 13.76           C  
ATOM  13628  C   SER   102      93.783  53.879  37.237  1.00 13.85           C  
ATOM  13629  O   SER   102      93.239  54.942  37.020  1.00 13.85           O  
ATOM  13630  CB  SER   102      92.952  52.234  35.615  1.00 13.46           C  
ATOM  13631  OG  SER   102      92.318  50.995  35.346  1.00 15.64           O  
ATOM  13632  N   VAL   103      95.081  53.795  37.542  1.00 14.08           N  
ATOM  13633  CA  VAL   103      95.940  54.957  37.235  1.00 13.49           C  
ATOM  13634  C   VAL   103      96.211  54.943  35.728  1.00 14.32           C  
ATOM  13635  O   VAL   103      96.076  53.907  35.086  1.00 14.13           O  
ATOM  13636  CB  VAL   103      97.260  54.995  38.049  1.00 13.45           C  
ATOM  13637  CG1 VAL   103      96.964  55.212  39.528  1.00 13.30           C  
ATOM  13638  CG2 VAL   103      98.085  53.757  37.857  1.00 14.31           C  
ATOM  13639  N   PRO   104      96.528  56.120  35.158  1.00 14.49           N  
ATOM  13640  CA  PRO   104      96.705  56.218  33.710  1.00 15.18           C  
ATOM  13641  C   PRO   104      97.820  55.375  33.100  1.00 15.45           C  
ATOM  13642  O   PRO   104      97.786  55.109  31.890  1.00 17.16           O  
ATOM  13643  CB  PRO   104      96.935  57.712  33.487  1.00 15.35           C  
ATOM  13644  CG  PRO   104      96.279  58.366  34.685  1.00 16.48           C  
ATOM  13645  CD  PRO   104      96.631  57.440  35.786  1.00 15.15           C  
ATOM  13646  N   GLU   105      98.781  54.941  33.908  1.00 15.63           N  
ATOM  13647  CA  GLU   105      99.839  54.061  33.433  1.00 14.99           C  
ATOM  13648  C   GLU   105      99.426  52.591  33.472  1.00 15.57           C  
ATOM  13649  O   GLU   105     100.143  51.745  32.983  1.00 15.51           O  
ATOM  13650  CB  GLU   105     101.129  54.233  34.247  1.00 15.82           C  
ATOM  13651  CG  GLU   105     101.751  55.606  34.111  1.00 14.48           C  
ATOM  13652  CD  GLU   105     100.908  56.711  34.727  1.00 14.59           C  
ATOM  13653  OE1 GLU   105     100.406  56.563  35.871  1.00 15.16           O  
ATOM  13654  OE2 GLU   105     100.751  57.745  34.035  1.00 15.78           O  
ATOM  13655  N   PHE   106      98.296  52.297  34.120  1.00 15.66           N  
ATOM  13656  CA  PHE   106      97.815  50.921  34.211  1.00 15.19           C  
ATOM  13657  C   PHE   106      97.034  50.567  32.952  1.00 15.21           C  
ATOM  13658  O   PHE   106      96.053  51.238  32.616  1.00 15.33           O  
ATOM  13659  CB  PHE   106      96.970  50.643  35.451  1.00 15.12           C  
ATOM  13660  CG  PHE   106      96.527  49.222  35.524  1.00 14.69           C  
ATOM  13661  CD1 PHE   106      97.460  48.191  35.776  1.00 13.97           C  
ATOM  13662  CD2 PHE   106      95.195  48.878  35.251  1.00 14.24           C  
ATOM  13663  CE1 PHE   106      97.055  46.849  35.796  1.00 16.21           C  
ATOM  13664  CE2 PHE   106      94.808  47.554  35.251  1.00 16.36           C  
ATOM  13665  CZ  PHE   106      95.711  46.545  35.530  1.00 15.69           C  
ATOM  13666  N   VAL   107      97.492  49.515  32.274  1.00 15.49           N  
ATOM  13667  CA  VAL   107      96.959  49.139  30.942  1.00 15.51           C  
ATOM  13668  C   VAL   107      96.660  47.626  30.810  1.00 16.14           C  
ATOM  13669  O   VAL   107      96.676  47.065  29.678  1.00 17.46           O  
ATOM  13670  CB  VAL   107      97.875  49.636  29.813  1.00 15.35           C  
ATOM  13671  CG1 VAL   107      97.910  51.181  29.745  1.00 16.15           C  
ATOM  13672  CG2 VAL   107      99.308  49.001  29.940  1.00 17.34           C  
ATOM  13673  N   GLU   108      96.342  46.976  31.937  1.00 15.75           N  
ATOM  13674  CA  GLU   108      96.023  45.560  31.913  1.00 16.38           C  
ATOM  13675  C   GLU   108      94.628  45.285  32.422  1.00 15.43           C  
ATOM  13676  O   GLU   108      94.352  44.262  33.088  1.00 16.13           O  
ATOM  13677  CB  GLU   108      97.076  44.777  32.693  1.00 16.44           C  
ATOM  13678  CG  GLU   108      98.436  44.788  32.033  1.00 19.85           C  
ATOM  13679  CD  GLU   108      99.523  44.263  32.973  1.00 20.58           C  
ATOM  13680  OE1 GLU   108      99.742  44.801  34.079  1.00 29.71           O  
ATOM  13681  OE2 GLU   108     100.165  43.306  32.588  1.00 28.76           O  
ATOM  13682  N   GLN   109      93.705  46.167  32.065  1.00 15.62           N  
ATOM  13683  CA  GLN   109      92.320  45.982  32.468  1.00 15.33           C  
ATOM  13684  C   GLN   109      91.738  44.684  31.902  1.00 15.79           C  
ATOM  13685  O   GLN   109      90.865  44.105  32.513  1.00 16.28           O  
ATOM  13686  CB  GLN   109      91.473  47.148  32.024  1.00 15.81           C  
ATOM  13687  CG  GLN   109      91.813  48.476  32.661  1.00 14.14           C  
ATOM  13688  CD  GLN   109      92.960  49.238  31.952  1.00 15.09           C  
ATOM  13689  OE1 GLN   109      93.533  48.780  30.938  1.00 14.45           O  
ATOM  13690  NE2 GLN   109      93.277  50.409  32.470  1.00 14.52           N  
ATOM  13691  N   HIS   110      92.217  44.249  30.747  1.00 15.52           N  
ATOM  13692  CA  HIS   110      91.773  42.945  30.180  1.00 15.97           C  
ATOM  13693  C   HIS   110      92.129  41.795  31.114  1.00 15.78           C  
ATOM  13694  O   HIS   110      91.333  40.912  31.357  1.00 16.32           O  
ATOM  13695  CB  HIS   110      92.311  42.739  28.739  1.00 16.72           C  
ATOM  13696  CG  HIS   110      93.809  42.789  28.627  1.00 17.04           C  
ATOM  13697  ND1 HIS   110      94.550  43.909  28.945  1.00 19.60           N  
ATOM  13698  CD2 HIS   110      94.705  41.843  28.259  1.00 22.76           C  
ATOM  13699  CE1 HIS   110      95.839  43.643  28.780  1.00 20.17           C  
ATOM  13700  NE2 HIS   110      95.958  42.394  28.373  1.00 21.32           N  
ATOM  13701  N   LEU   111      93.330  41.821  31.669  1.00 16.38           N  
ATOM  13702  CA  LEU   111      93.763  40.836  32.657  1.00 16.96           C  
ATOM  13703  C   LEU   111      92.924  40.851  33.932  1.00 17.46           C  
ATOM  13704  O   LEU   111      92.575  39.786  34.492  1.00 19.02           O  
ATOM  13705  CB  LEU   111      95.239  41.050  32.982  1.00 17.06           C  
ATOM  13706  CG  LEU   111      96.187  40.875  31.779  1.00 17.72           C  
ATOM  13707  CD1 LEU   111      97.635  40.909  32.274  1.00 21.15           C  
ATOM  13708  CD2 LEU   111      95.918  39.613  30.974  1.00 21.14           C  
ATOM  13709  N   VAL   112      92.592  42.051  34.377  1.00 16.80           N  
ATOM  13710  CA  VAL   112      91.777  42.181  35.584  1.00 16.34           C  
ATOM  13711  C   VAL   112      90.397  41.535  35.335  1.00 16.45           C  
ATOM  13712  O   VAL   112      89.895  40.762  36.156  1.00 17.06           O  
ATOM  13713  CB  VAL   112      91.648  43.658  36.010  1.00 16.03           C  
ATOM  13714  CG1 VAL   112      90.570  43.824  37.097  1.00 14.54           C  
ATOM  13715  CG2 VAL   112      93.046  44.189  36.451  1.00 14.52           C  
ATOM  13716  N   ILE   113      89.783  41.862  34.211  1.00 16.33           N  
ATOM  13717  CA  ILE   113      88.418  41.383  33.939  1.00 16.57           C  
ATOM  13718  C   ILE   113      88.426  39.871  33.602  1.00 17.38           C  
ATOM  13719  O   ILE   113      87.418  39.207  33.835  1.00 17.79           O  
ATOM  13720  CB  ILE   113      87.684  42.255  32.877  1.00 16.97           C  
ATOM  13721  CG1 ILE   113      87.591  43.715  33.353  1.00 16.42           C  
ATOM  13722  CG2 ILE   113      86.275  41.686  32.506  1.00 16.23           C  
ATOM  13723  CD1 ILE   113      86.973  43.943  34.754  1.00 15.38           C  
ATOM  13724  N   ASN   114      89.573  39.326  33.152  1.00 17.62           N  
ATOM  13725  CA  ASN   114      89.721  37.861  33.017  1.00 18.16           C  
ATOM  13726  C   ASN   114      89.370  37.165  34.320  1.00 18.57           C  
ATOM  13727  O   ASN   114      88.867  36.056  34.301  1.00 19.99           O  
ATOM  13728  CB  ASN   114      91.130  37.469  32.547  1.00 18.52           C  
ATOM  13729  CG  ASN   114      91.406  37.829  31.083  1.00 20.10           C  
ATOM  13730  OD1 ASN   114      90.494  38.167  30.316  1.00 22.14           O  
ATOM  13731  ND2 ASN   114      92.665  37.744  30.689  1.00 20.05           N  
ATOM  13732  N   GLY   115      89.585  37.808  35.469  1.00 18.91           N  
ATOM  13733  CA  GLY   115      89.088  37.293  36.757  1.00 19.18           C  
ATOM  13734  C   GLY   115      87.609  36.931  36.679  1.00 19.79           C  
ATOM  13735  O   GLY   115      87.233  35.782  36.939  1.00 21.14           O  
ATOM  13736  N   ALA   116      86.771  37.891  36.267  1.00 19.18           N  
ATOM  13737  CA  ALA   116      85.331  37.638  36.074  1.00 18.73           C  
ATOM  13738  C   ALA   116      85.078  36.648  34.944  1.00 18.77           C  
ATOM  13739  O   ALA   116      84.318  35.704  35.117  1.00 18.13           O  
ATOM  13740  CB  ALA   116      84.563  38.940  35.818  1.00 17.60           C  
ATOM  13741  N   SER   117      85.690  36.872  33.792  1.00 19.29           N  
ATOM  13742  CA  SER   117      85.366  36.092  32.582  1.00 20.10           C  
ATOM  13743  C   SER   117      85.670  34.595  32.784  1.00 20.77           C  
ATOM  13744  O   SER   117      84.865  33.722  32.435  1.00 21.97           O  
ATOM  13745  CB  SER   117      86.103  36.640  31.358  1.00 19.41           C  
ATOM  13746  OG  SER   117      85.662  37.947  31.006  1.00 19.65           O  
ATOM  13747  N   ASN   118      86.810  34.313  33.389  1.00 21.80           N  
ATOM  13748  CA  ASN   118      87.247  32.938  33.669  1.00 21.92           C  
ATOM  13749  C   ASN   118      86.341  32.220  34.666  1.00 22.29           C  
ATOM  13750  O   ASN   118      86.014  31.026  34.477  1.00 23.85           O  
ATOM  13751  CB  ASN   118      88.672  32.936  34.193  1.00 22.14           C  
ATOM  13752  CG  ASN   118      89.692  33.319  33.143  1.00 23.36           C  
ATOM  13753  OD1 ASN   118      89.434  33.295  31.932  1.00 27.40           O  
ATOM  13754  ND2 ASN   118      90.877  33.671  33.606  1.00 27.49           N  
ATOM  13755  N   LEU   119      85.917  32.940  35.707  1.00 22.44           N  
ATOM  13756  CA  LEU   119      85.007  32.396  36.709  1.00 22.17           C  
ATOM  13757  C   LEU   119      83.654  32.058  36.071  1.00 22.24           C  
ATOM  13758  O   LEU   119      83.123  30.945  36.218  1.00 21.77           O  
ATOM  13759  CB  LEU   119      84.863  33.385  37.882  1.00 21.87           C  
ATOM  13760  CG  LEU   119      83.954  32.950  39.040  1.00 21.57           C  
ATOM  13761  CD1 LEU   119      84.343  33.550  40.394  1.00 22.43           C  
ATOM  13762  CD2 LEU   119      82.466  33.213  38.687  1.00 19.84           C  
ATOM  13763  N   ILE   120      83.100  33.014  35.340  1.00 22.68           N  
ATOM  13764  CA  ILE   120      81.797  32.834  34.691  1.00 23.03           C  
ATOM  13765  C   ILE   120      81.822  31.671  33.672  1.00 22.73           C  
ATOM  13766  O   ILE   120      80.921  30.827  33.672  1.00 22.74           O  
ATOM  13767  CB  ILE   120      81.304  34.189  34.057  1.00 22.50           C  
ATOM  13768  CG1 ILE   120      80.907  35.152  35.199  1.00 23.42           C  
ATOM  13769  CG2 ILE   120      80.119  33.969  33.092  1.00 23.23           C  
ATOM  13770  CD1 ILE   120      80.713  36.598  34.811  1.00 24.45           C  
ATOM  13771  N   ALA   121      82.859  31.598  32.846  1.00 22.93           N  
ATOM  13772  CA  ALA   121      82.995  30.525  31.867  1.00 23.71           C  
ATOM  13773  C   ALA   121      83.172  29.164  32.552  1.00 24.46           C  
ATOM  13774  O   ALA   121      82.589  28.167  32.118  1.00 24.40           O  
ATOM  13775  CB  ALA   121      84.153  30.806  30.923  1.00 24.16           C  
ATOM  13776  N   THR   122      83.934  29.146  33.646  1.00 25.07           N  
ATOM  13777  CA  THR   122      84.155  27.929  34.423  1.00 25.52           C  
ATOM  13778  C   THR   122      82.873  27.370  35.045  1.00 25.94           C  
ATOM  13779  O   THR   122      82.621  26.176  34.942  1.00 27.29           O  
ATOM  13780  CB  THR   122      85.229  28.151  35.493  1.00 25.67           C  
ATOM  13781  OG1 THR   122      86.465  28.470  34.828  1.00 25.67           O  
ATOM  13782  CG2 THR   122      85.404  26.905  36.403  1.00 25.84           C  
ATOM  13783  N   VAL   123      82.070  28.205  35.692  1.00 25.64           N  
ATOM  13784  CA  VAL   123      80.892  27.707  36.398  1.00 25.47           C  
ATOM  13785  C   VAL   123      79.727  27.416  35.437  1.00 25.14           C  
ATOM  13786  O   VAL   123      78.923  26.530  35.706  1.00 25.86           O  
ATOM  13787  CB  VAL   123      80.457  28.640  37.539  1.00 25.42           C  
ATOM  13788  CG1 VAL   123      81.594  28.801  38.558  1.00 25.65           C  
ATOM  13789  CG2 VAL   123      79.991  29.985  37.025  1.00 25.96           C  
ATOM  13790  N   LEU   124      79.648  28.132  34.316  1.00 25.53           N  
ATOM  13791  CA  LEU   124      78.543  27.974  33.358  1.00 25.86           C  
ATOM  13792  C   LEU   124      78.893  27.133  32.121  1.00 26.58           C  
ATOM  13793  O   LEU   124      77.992  26.702  31.399  1.00 27.85           O  
ATOM  13794  CB  LEU   124      78.016  29.354  32.906  1.00 25.67           C  
ATOM  13795  CG  LEU   124      77.392  30.242  34.005  1.00 25.75           C  
ATOM  13796  CD1 LEU   124      76.923  31.620  33.473  1.00 24.79           C  
ATOM  13797  CD2 LEU   124      76.239  29.529  34.730  1.00 24.67           C  
ATOM  13798  N   GLY   125      80.171  26.905  31.855  1.00 26.92           N  
ATOM  13799  CA  GLY   125      80.601  26.262  30.617  1.00 27.47           C  
ATOM  13800  C   GLY   125      80.400  27.153  29.401  1.00 28.59           C  
ATOM  13801  O   GLY   125      80.450  28.395  29.501  1.00 27.96           O  
ATOM  13802  N   GLU   126      80.145  26.533  28.247  1.00 29.57           N  
ATOM  13803  CA  GLU   126      80.046  27.272  26.987  1.00 29.15           C  
ATOM  13804  C   GLU   126      79.064  28.438  27.036  1.00 28.94           C  
ATOM  13805  O   GLU   126      79.378  29.497  26.491  1.00 29.44           O  
ATOM  13806  CB  GLU   126      79.695  26.340  25.813  1.00 31.00           C  
ATOM  13807  CG  GLU   126      79.198  27.036  24.521  1.00 32.78           C  
ATOM  13808  CD  GLU   126      80.275  27.849  23.846  1.00 39.95           C  
ATOM  13809  OE1 GLU   126      81.484  27.537  24.067  1.00 43.72           O  
ATOM  13810  OE2 GLU   126      79.914  28.797  23.096  1.00 44.33           O  
ATOM  13811  N   PRO   127      77.872  28.252  27.641  1.00 28.35           N  
ATOM  13812  CA  PRO   127      76.944  29.395  27.735  1.00 27.52           C  
ATOM  13813  C   PRO   127      77.493  30.606  28.480  1.00 26.17           C  
ATOM  13814  O   PRO   127      76.951  31.708  28.316  1.00 25.23           O  
ATOM  13815  CB  PRO   127      75.769  28.854  28.541  1.00 27.48           C  
ATOM  13816  CG  PRO   127      75.825  27.360  28.369  1.00 28.37           C  
ATOM  13817  CD  PRO   127      77.274  27.013  28.195  1.00 29.33           C  
ATOM  13818  N   GLY   128      78.509  30.381  29.316  1.00 24.90           N  
ATOM  13819  CA  GLY   128      79.160  31.456  30.029  1.00 24.87           C  
ATOM  13820  C   GLY   128      80.076  32.338  29.192  1.00 24.95           C  
ATOM  13821  O   GLY   128      80.490  33.405  29.683  1.00 25.60           O  
ATOM  13822  N   ARG   129      80.434  31.920  27.974  1.00 24.08           N  
ATOM  13823  CA  ARG   129      81.368  32.698  27.159  1.00 24.96           C  
ATOM  13824  C   ARG   129      80.614  33.880  26.582  1.00 23.19           C  
ATOM  13825  O   ARG   129      79.509  33.733  26.062  1.00 23.19           O  
ATOM  13826  CB  ARG   129      81.996  31.866  26.065  1.00 25.42           C  
ATOM  13827  CG  ARG   129      82.821  30.711  26.608  1.00 27.86           C  
ATOM  13828  CD  ARG   129      83.309  29.877  25.472  1.00 29.98           C  
ATOM  13829  NE  ARG   129      84.510  30.430  24.867  1.00 34.49           N  
ATOM  13830  CZ  ARG   129      84.825  30.292  23.581  1.00 36.05           C  
ATOM  13831  NH1 ARG   129      84.003  29.656  22.751  1.00 39.31           N  
ATOM  13832  NH2 ARG   129      85.952  30.809  23.108  1.00 35.44           N  
ATOM  13833  N   HIS   130      81.207  35.062  26.690  1.00 21.17           N  
ATOM  13834  CA  HIS   130      80.479  36.305  26.497  1.00 19.81           C  
ATOM  13835  C   HIS   130      81.292  37.340  25.734  1.00 18.95           C  
ATOM  13836  O   HIS   130      82.515  37.310  25.762  1.00 19.32           O  
ATOM  13837  CB  HIS   130      80.174  36.874  27.875  1.00 19.15           C  
ATOM  13838  CG  HIS   130      81.373  36.896  28.779  1.00 19.27           C  
ATOM  13839  ND1 HIS   130      81.715  35.823  29.575  1.00 18.83           N  
ATOM  13840  CD2 HIS   130      82.352  37.826  28.960  1.00 18.82           C  
ATOM  13841  CE1 HIS   130      82.841  36.093  30.215  1.00 19.50           C  
ATOM  13842  NE2 HIS   130      83.245  37.304  29.863  1.00 18.38           N  
ATOM  13843  N   ALA   131      80.591  38.238  25.056  1.00 18.23           N  
ATOM  13844  CA  ALA   131      81.198  39.483  24.562  1.00 17.93           C  
ATOM  13845  C   ALA   131      81.615  40.331  25.788  1.00 17.63           C  
ATOM  13846  O   ALA   131      81.145  40.128  26.900  1.00 18.26           O  
ATOM  13847  CB  ALA   131      80.243  40.256  23.664  1.00 17.85           C  
ATOM  13848  N   ARG   132      82.489  41.306  25.575  1.00 18.24           N  
ATOM  13849  CA  ARG   132      83.035  42.036  26.695  1.00 18.04           C  
ATOM  13850  C   ARG   132      83.617  43.385  26.284  1.00 17.43           C  
ATOM  13851  O   ARG   132      84.088  43.565  25.163  1.00 16.62           O  
ATOM  13852  CB  ARG   132      84.181  41.242  27.282  1.00 17.74           C  
ATOM  13853  CG  ARG   132      84.379  41.473  28.719  1.00 21.52           C  
ATOM  13854  CD  ARG   132      85.559  40.622  29.271  1.00 20.37           C  
ATOM  13855  NE  ARG   132      86.903  41.031  28.837  1.00 22.76           N  
ATOM  13856  CZ  ARG   132      88.019  40.471  29.328  1.00 21.32           C  
ATOM  13857  NH1 ARG   132      87.918  39.544  30.236  1.00 20.78           N  
ATOM  13858  NH2 ARG   132      89.223  40.856  28.939  1.00 22.78           N  
ATOM  13859  N   ALA   133      83.650  44.285  27.244  1.00 16.82           N  
ATOM  13860  CA  ALA   133      84.489  45.509  27.180  1.00 17.17           C  
ATOM  13861  C   ALA   133      85.251  45.582  28.508  1.00 16.48           C  
ATOM  13862  O   ALA   133      84.736  45.177  29.538  1.00 16.92           O  
ATOM  13863  CB  ALA   133      83.642  46.745  26.979  1.00 17.02           C  
ATOM  13864  N   ALA   134      86.494  46.049  28.468  1.00 16.84           N  
ATOM  13865  CA  ALA   134      87.303  46.207  29.665  1.00 16.59           C  
ATOM  13866  C   ALA   134      87.964  47.583  29.548  1.00 16.64           C  
ATOM  13867  O   ALA   134      88.695  47.845  28.578  1.00 17.05           O  
ATOM  13868  CB  ALA   134      88.348  45.119  29.805  1.00 17.16           C  
ATOM  13869  N   VAL   135      87.689  48.463  30.496  1.00 16.16           N  
ATOM  13870  CA  VAL   135      88.099  49.863  30.393  1.00 15.33           C  
ATOM  13871  C   VAL   135      88.602  50.422  31.715  1.00 15.04           C  
ATOM  13872  O   VAL   135      88.202  49.980  32.779  1.00 16.55           O  
ATOM  13873  CB  VAL   135      86.942  50.718  29.835  1.00 15.27           C  
ATOM  13874  CG1 VAL   135      86.621  50.279  28.369  1.00 15.28           C  
ATOM  13875  CG2 VAL   135      85.715  50.631  30.750  1.00 18.02           C  
ATOM  13876  N   GLY   136      89.451  51.440  31.644  1.00 14.42           N  
ATOM  13877  CA  GLY   136      90.007  52.072  32.833  1.00 14.05           C  
ATOM  13878  C   GLY   136      89.283  53.347  33.238  1.00 14.66           C  
ATOM  13879  O   GLY   136      89.192  54.307  32.461  1.00 16.32           O  
ATOM  13880  N   MET   137      88.838  53.366  34.492  1.00 15.74           N  
ATOM  13881  CA  MET   137      88.019  54.428  35.067  1.00 15.53           C  
ATOM  13882  C   MET   137      88.883  55.286  36.016  1.00 14.55           C  
ATOM  13883  O   MET   137      89.870  54.808  36.569  1.00 14.21           O  
ATOM  13884  CB  MET   137      86.856  53.860  35.881  1.00 17.67           C  
ATOM  13885  CG  MET   137      86.263  52.643  35.390  1.00 23.71           C  
ATOM  13886  SD  MET   137      85.665  52.752  33.523  1.00 32.58          SE  
ATOM  13887  CE  MET   137      84.716  54.461  33.938  1.00 19.25           C  
ATOM  13888  N   ALA   138      88.476  56.527  36.234  1.00 13.88           N  
ATOM  13889  CA  ALA   138      89.141  57.440  37.178  1.00 14.06           C  
ATOM  13890  C   ALA   138      88.955  56.936  38.616  1.00 14.04           C  
ATOM  13891  O   ALA   138      89.862  57.017  39.449  1.00 13.62           O  
ATOM  13892  CB  ALA   138      88.610  58.875  37.047  1.00 13.96           C  
ATOM  13893  N   SER   139      87.774  56.379  38.876  1.00 14.58           N  
ATOM  13894  CA  SER   139      87.388  55.917  40.210  1.00 15.14           C  
ATOM  13895  C   SER   139      85.992  55.291  40.117  1.00 14.88           C  
ATOM  13896  O   SER   139      85.324  55.457  39.108  1.00 14.48           O  
ATOM  13897  CB  SER   139      87.394  57.083  41.230  1.00 15.80           C  
ATOM  13898  OG  SER   139      86.720  58.247  40.755  1.00 16.73           O  
ATOM  13899  N   LEU   140      85.553  54.651  41.200  1.00 15.44           N  
ATOM  13900  CA  LEU   140      84.237  53.954  41.240  1.00 15.36           C  
ATOM  13901  C   LEU   140      83.547  54.180  42.597  1.00 15.58           C  
ATOM  13902  O   LEU   140      84.208  54.523  43.587  1.00 15.56           O  
ATOM  13903  CB  LEU   140      84.409  52.450  40.962  1.00 15.93           C  
ATOM  13904  CG  LEU   140      84.909  52.035  39.582  1.00 15.60           C  
ATOM  13905  CD1 LEU   140      85.286  50.549  39.605  1.00 15.22           C  
ATOM  13906  CD2 LEU   140      83.852  52.382  38.482  1.00 15.08           C  
ATOM  13907  N   PRO   141      82.211  54.021  42.644  1.00 15.44           N  
ATOM  13908  CA  PRO   141      81.453  54.136  43.911  1.00 16.14           C  
ATOM  13909  C   PRO   141      82.110  53.334  45.044  1.00 15.92           C  
ATOM  13910  O   PRO   141      82.581  52.199  44.826  1.00 16.30           O  
ATOM  13911  CB  PRO   141      80.075  53.575  43.548  1.00 15.94           C  
ATOM  13912  CG  PRO   141      79.935  53.831  42.101  1.00 15.45           C  
ATOM  13913  CD  PRO   141      81.316  53.727  41.508  1.00 15.64           C  
ATOM  13914  N   PHE   142      82.170  53.939  46.230  1.00 16.28           N  
ATOM  13915  CA  PHE   142      82.733  53.297  47.430  1.00 17.01           C  
ATOM  13916  C   PHE   142      84.216  52.930  47.312  1.00 17.24           C  
ATOM  13917  O   PHE   142      84.742  52.110  48.073  1.00 17.44           O  
ATOM  13918  CB  PHE   142      81.928  52.059  47.803  1.00 18.58           C  
ATOM  13919  CG  PHE   142      80.466  52.336  47.998  1.00 18.46           C  
ATOM  13920  CD1 PHE   142      80.015  52.864  49.180  1.00 21.60           C  
ATOM  13921  CD2 PHE   142      79.559  52.097  46.970  1.00 21.58           C  
ATOM  13922  CE1 PHE   142      78.682  53.137  49.358  1.00 21.61           C  
ATOM  13923  CE2 PHE   142      78.215  52.370  47.137  1.00 22.90           C  
ATOM  13924  CZ  PHE   142      77.776  52.887  48.332  1.00 22.64           C  
ATOM  13925  N   ASN   143      84.878  53.560  46.330  1.00 16.87           N  
ATOM  13926  CA  ASN   143      86.266  53.270  45.999  1.00 15.70           C  
ATOM  13927  C   ASN   143      86.510  51.824  45.587  1.00 15.55           C  
ATOM  13928  O   ASN   143      87.609  51.322  45.736  1.00 16.70           O  
ATOM  13929  CB  ASN   143      87.154  53.677  47.176  1.00 16.04           C  
ATOM  13930  CG  ASN   143      88.588  53.911  46.779  1.00 14.10           C  
ATOM  13931  OD1 ASN   143      88.914  54.151  45.608  1.00 17.82           O  
ATOM  13932  ND2 ASN   143      89.478  53.852  47.779  1.00 17.12           N  
ATOM  13933  N   ALA   144      85.488  51.161  45.023  1.00 15.75           N  
ATOM  13934  CA  ALA   144      85.636  49.826  44.460  1.00 15.29           C  
ATOM  13935  C   ALA   144      86.735  49.841  43.411  1.00 15.28           C  
ATOM  13936  O   ALA   144      86.847  50.796  42.624  1.00 14.89           O  
ATOM  13937  CB  ALA   144      84.350  49.361  43.831  1.00 15.92           C  
ATOM  13938  N   SER   145      87.538  48.785  43.403  1.00 15.49           N  
ATOM  13939  CA  SER   145      88.570  48.650  42.372  1.00 15.37           C  
ATOM  13940  C   SER   145      87.975  48.256  41.005  1.00 15.28           C  
ATOM  13941  O   SER   145      88.503  48.615  39.973  1.00 14.24           O  
ATOM  13942  CB  SER   145      89.687  47.688  42.825  1.00 16.67           C  
ATOM  13943  OG  SER   145      90.313  48.168  44.001  1.00 16.25           O  
ATOM  13944  N   VAL   146      86.877  47.516  41.017  1.00 14.87           N  
ATOM  13945  CA  VAL   146      86.230  47.021  39.809  1.00 15.23           C  
ATOM  13946  C   VAL   146      84.712  47.079  40.031  1.00 15.41           C  
ATOM  13947  O   VAL   146      84.210  46.874  41.153  1.00 15.54           O  
ATOM  13948  CB  VAL   146      86.670  45.536  39.456  1.00 15.05           C  
ATOM  13949  CG1 VAL   146      86.085  45.052  38.089  1.00 15.94           C  
ATOM  13950  CG2 VAL   146      88.232  45.354  39.571  1.00 14.96           C  
ATOM  13951  N   GLU   147      84.007  47.398  38.957  1.00 15.93           N  
ATOM  13952  CA  GLU   147      82.535  47.312  38.856  1.00 15.92           C  
ATOM  13953  C   GLU   147      82.252  46.607  37.524  1.00 15.93           C  
ATOM  13954  O   GLU   147      82.884  46.924  36.508  1.00 15.74           O  
ATOM  13955  CB  GLU   147      81.892  48.684  38.856  1.00 16.26           C  
ATOM  13956  CG  GLU   147      80.408  48.720  38.569  1.00 16.79           C  
ATOM  13957  CD  GLU   147      79.814  50.141  38.566  1.00 17.90           C  
ATOM  13958  OE1 GLU   147      80.472  51.032  39.106  1.00 16.37           O  
ATOM  13959  OE2 GLU   147      78.691  50.362  38.032  1.00 21.33           O  
ATOM  13960  N   ILE   148      81.306  45.667  37.535  1.00 16.14           N  
ATOM  13961  CA  ILE   148      80.988  44.895  36.342  1.00 15.98           C  
ATOM  13962  C   ILE   148      79.476  44.740  36.189  1.00 16.11           C  
ATOM  13963  O   ILE   148      78.794  44.315  37.129  1.00 16.86           O  
ATOM  13964  CB  ILE   148      81.601  43.456  36.330  1.00 16.86           C  
ATOM  13965  CG1 ILE   148      83.118  43.455  36.615  1.00 15.12           C  
ATOM  13966  CG2 ILE   148      81.313  42.831  34.929  1.00 17.11           C  
ATOM  13967  CD1 ILE   148      83.783  42.069  36.538  1.00 16.31           C  
ATOM  13968  N   ASP   149      78.974  45.086  35.011  1.00 15.24           N  
ATOM  13969  CA  ASP   149      77.541  44.879  34.705  1.00 16.84           C  
ATOM  13970  C   ASP   149      77.406  43.805  33.638  1.00 16.71           C  
ATOM  13971  O   ASP   149      78.409  43.329  33.087  1.00 19.31           O  
ATOM  13972  CB  ASP   149      76.857  46.181  34.332  1.00 17.25           C  
ATOM  13973  CG  ASP   149      77.178  46.666  32.924  1.00 18.92           C  
ATOM  13974  OD1 ASP   149      77.717  45.917  32.076  1.00 21.61           O  
ATOM  13975  OD2 ASP   149      76.901  47.857  32.671  1.00 23.19           O  
ATOM  13976  N   ALA   150      76.170  43.403  33.348  1.00 17.03           N  
ATOM  13977  CA  ALA   150      75.979  42.220  32.491  1.00 17.32           C  
ATOM  13978  C   ALA   150      74.653  42.251  31.760  1.00 17.32           C  
ATOM  13979  O   ALA   150      73.681  42.805  32.264  1.00 17.16           O  
ATOM  13980  CB  ALA   150      76.071  40.922  33.290  1.00 16.29           C  
ATOM  13981  N   ILE   151      74.636  41.600  30.597  1.00 17.86           N  
ATOM  13982  CA  ILE   151      73.385  41.298  29.877  1.00 18.64           C  
ATOM  13983  C   ILE   151      73.400  39.782  29.684  1.00 18.58           C  
ATOM  13984  O   ILE   151      74.408  39.216  29.252  1.00 16.46           O  
ATOM  13985  CB  ILE   151      73.295  41.986  28.517  1.00 18.12           C  
ATOM  13986  CG1 ILE   151      73.401  43.521  28.639  1.00 18.70           C  
ATOM  13987  CG2 ILE   151      72.005  41.638  27.832  1.00 18.34           C  
ATOM  13988  CD1 ILE   151      73.738  44.160  27.326  1.00 21.12           C  
ATOM  13989  N   VAL   152      72.296  39.127  30.014  1.00 19.65           N  
ATOM  13990  CA  VAL   152      72.245  37.677  30.062  1.00 20.85           C  
ATOM  13991  C   VAL   152      70.965  37.236  29.312  1.00 21.79           C  
ATOM  13992  O   VAL   152      69.875  37.732  29.595  1.00 23.25           O  
ATOM  13993  CB  VAL   152      72.234  37.157  31.530  1.00 20.51           C  
ATOM  13994  CG1 VAL   152      72.116  35.632  31.552  1.00 20.98           C  
ATOM  13995  CG2 VAL   152      73.472  37.627  32.314  1.00 19.78           C  
ATOM  13996  N   GLU   153      71.111  36.364  28.337  1.00 22.65           N  
ATOM  13997  CA  GLU   153      69.931  35.789  27.677  1.00 23.65           C  
ATOM  13998  C   GLU   153      69.416  34.643  28.566  1.00 23.87           C  
ATOM  13999  O   GLU   153      70.189  33.746  28.945  1.00 23.66           O  
ATOM  14000  CB  GLU   153      70.264  35.289  26.289  1.00 23.38           C  
ATOM  14001  CG  GLU   153      69.041  34.729  25.582  1.00 23.77           C  
ATOM  14002  CD  GLU   153      69.403  34.097  24.286  1.00 25.44           C  
ATOM  14003  OE1 GLU   153      69.856  34.818  23.377  1.00 28.66           O  
ATOM  14004  OE2 GLU   153      69.232  32.859  24.181  1.00 33.72           O  
ATOM  14005  N   ILE   154      68.116  34.683  28.885  1.00 25.68           N  
ATOM  14006  CA  ILE   154      67.500  33.757  29.854  1.00 26.78           C  
ATOM  14007  C   ILE   154      66.314  33.035  29.242  1.00 30.18           C  
ATOM  14008  O   ILE   154      65.740  33.496  28.257  1.00 29.70           O  
ATOM  14009  CB  ILE   154      67.039  34.458  31.150  1.00 26.75           C  
ATOM  14010  CG1 ILE   154      66.053  35.594  30.860  1.00 26.10           C  
ATOM  14011  CG2 ILE   154      68.259  34.960  31.966  1.00 25.49           C  
ATOM  14012  CD1 ILE   154      65.428  36.242  32.107  1.00 26.67           C  
ATOM  14013  N   ASP   155      65.987  31.894  29.838  1.00 34.08           N  
ATOM  14014  CA  ASP   155      64.750  31.169  29.526  1.00 38.39           C  
ATOM  14015  C   ASP   155      63.533  31.867  30.087  1.00 39.81           C  
ATOM  14016  O   ASP   155      63.331  31.884  31.303  1.00 41.42           O  
ATOM  14017  CB  ASP   155      64.825  29.774  30.112  1.00 38.89           C  
ATOM  14018  CG  ASP   155      65.674  28.876  29.280  1.00 42.84           C  
ATOM  14019  OD1 ASP   155      65.266  28.669  28.107  1.00 47.96           O  
ATOM  14020  OD2 ASP   155      66.738  28.398  29.774  1.00 48.12           O  
ATOM  14021  N   VAL   156      62.721  32.426  29.191  1.00 42.19           N  
ATOM  14022  CA  VAL   156      61.502  33.142  29.551  1.00 42.99           C  
ATOM  14023  C   VAL   156      60.299  32.349  29.037  1.00 44.31           C  
ATOM  14024  O   VAL   156      60.430  31.553  28.090  1.00 45.98           O  
ATOM  14025  CB  VAL   156      61.529  34.588  28.958  1.00 43.73           C  
ATOM  14026  CG1 VAL   156      60.139  35.038  28.439  1.00 44.09           C  
ATOM  14027  CG2 VAL   156      62.095  35.575  29.986  1.00 43.38           C  
END
