
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  124 (  924),  selected  124 , name 2csl_E
# Molecule2: number of CA atoms  152 ( 1118),  selected  152 , name T0423.pdb
# PARAMETERS: 2csl_E.T0423.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_E      M       1           -
LGA    E     2_E      S       2           -
LGA    A     3_E      D       3           -
LGA    V     4_E      V       4           -
LGA    K     5_E      I       5           -
LGA    T     6_E      E       6           -
LGA    D     7_E      G       7           -
LGA    -       -      R       8           -
LGA    -       -      L       9           -
LGA    -       -      K      10           -
LGA    -       -      E      11           -
LGA    -       -      L      12           -
LGA    -       -      G      13           -
LGA    -       -      F      14           -
LGA    -       -      T      15           -
LGA    -       -      L      16           -
LGA    R     8_E      P      17          2.972
LGA    A     9_E      V      18          4.356
LGA    P    10_E      -       -           -
LGA    A    11_E      -       -           -
LGA    A    12_E      -       -           -
LGA    I    13_E      A      23          4.783
LGA    G    14_E      A      24          3.014
LGA    P    15_E      N      25          1.821
LGA    Y    16_E      Y      26          1.299
LGA    A    17_E      V      27          1.155
LGA    Q    18_E      P      28          1.108
LGA    A    19_E      F      29          0.825
LGA    V    20_E      T      30          1.285
LGA    K    21_E      I      31          2.116
LGA    A    22_E      S      32          2.320
LGA    G    23_E      G      33          1.544
LGA    G    24_E      N      34          1.587
LGA    F    25_E      L      35          1.339
LGA    V    26_E      L      36          0.811
LGA    F    27_E      Y      37          0.754
LGA    V    28_E      V      38          0.353
LGA    S    29_E      S      39          0.454
LGA    G    30_E      G      40          0.356
LGA    Q    31_E      Q      41          0.319
LGA    I    32_E      L      42          0.525
LGA    P    33_E      P      43          0.894
LGA    L    34_E      M      44          1.555
LGA    A    35_E      E      45          2.687
LGA    P    36_E      S      46          5.492
LGA    D    37_E      -       -           -
LGA    G    38_E      G      47          2.912
LGA    S    39_E      K      48          1.337
LGA    L    40_E      I      49          1.655
LGA    V    41_E      A      50          0.658
LGA    E    42_E      V      51          2.308
LGA    G    43_E      T      52           #
LGA    -       -      G      53           -
LGA    -       -      L      54           -
LGA    -       -      V      55           -
LGA    -       -      G      56           -
LGA    -       -      R      57           -
LGA    -       -      D      58           -
LGA    -       -      V      59           -
LGA    -       -      D      60           -
LGA    -       -      V      61           -
LGA    -       -      A      62           -
LGA    D    44_E      S      63          1.647
LGA    I    45_E      A      64          0.717
LGA    R    46_E      Q      65          2.236
LGA    V    47_E      R      66          2.140
LGA    Q    48_E      A      67          1.153
LGA    T    49_E      A      68          1.304
LGA    E    50_E      E      69          1.733
LGA    R    51_E      L      70          1.151
LGA    V    52_E      C      71          0.744
LGA    X    53_E      A      72          1.157
LGA    E    54_E      V      73          0.842
LGA    N    55_E      N      74          0.626
LGA    L    56_E      I      75          0.933
LGA    K    57_E      L      76          1.083
LGA    A    58_E      A      77          1.026
LGA    V    59_E      Q      78          0.939
LGA    L    60_E      V      79          0.893
LGA    E    61_E      K      80          1.440
LGA    A    62_E      A      81          1.683
LGA    A    63_E      A      82          1.519
LGA    G    64_E      L      83          1.556
LGA    -       -      N      84           -
LGA    -       -      G      85           -
LGA    -       -      D      86           -
LGA    S    65_E      L      87          4.647
LGA    -       -      S      88           -
LGA    -       -      K      89           -
LGA    G    66_E      I      90          3.857
LGA    L    67_E      R      91           -
LGA    S    68_E      -       -           -
LGA    R    69_E      R      92          2.331
LGA    V    70_E      V      93          1.272
LGA    V    71_E      I      94          0.807
LGA    Q    72_E      K      95          1.215
LGA    T    73_E      L      96          1.314
LGA    T    74_E      N      97          1.239
LGA    C    75_E      G      98          1.225
LGA    F    76_E      F      99          0.886
LGA    L    77_E      V     100          0.944
LGA    A    78_E      A     101          1.209
LGA    D    79_E      S     102          2.221
LGA    -       -      V     103           -
LGA    -       -      P     104           -
LGA    -       -      E     105           -
LGA    -       -      F     106           -
LGA    X    80_E      V     107          3.430
LGA    E    81_E      E     108          3.279
LGA    D    82_E      Q     109          4.560
LGA    F    83_E      H     110          3.315
LGA    P    84_E      L     111          1.685
LGA    G    85_E      V     112          3.689
LGA    F    86_E      I     113          3.016
LGA    N    87_E      N     114          1.002
LGA    E    88_E      G     115          3.989
LGA    V    89_E      A     116          4.460
LGA    Y    90_E      S     117          2.273
LGA    A    91_E      N     118          1.333
LGA    R    92_E      L     119          2.372
LGA    Y    93_E      I     120          1.463
LGA    F    94_E      A     121          2.001
LGA    -       -      T     122           -
LGA    -       -      V     123           -
LGA    -       -      L     124           -
LGA    T    95_E      G     125          3.537
LGA    P    96_E      E     126          2.647
LGA    P    97_E      P     127          4.953
LGA    -       -      G     128           -
LGA    Y    98_E      R     129          1.654
LGA    P    99_E      H     130          1.213
LGA    A   100_E      A     131          1.297
LGA    R   101_E      R     132          1.151
LGA    A   102_E      A     133          1.507
LGA    T   103_E      A     134          1.591
LGA    V   104_E      V     135          1.079
LGA    A   105_E      G     136          0.887
LGA    V   106_E      M     137          1.471
LGA    K   107_E      A     138          1.311
LGA    A   108_E      S     139          1.248
LGA    L   109_E      L     140          0.926
LGA    P   110_E      P     141          0.966
LGA    R   111_E      F     142          1.022
LGA    G   112_E      N     143          1.137
LGA    V   113_E      A     144          1.155
LGA    R   114_E      S     145          1.412
LGA    V   115_E      V     146          0.842
LGA    E   116_E      E     147          0.791
LGA    V   117_E      I     148          0.738
LGA    A   118_E      D     149          0.611
LGA    C   119_E      A     150          0.753
LGA    V   120_E      I     151          0.839
LGA    A   121_E      V     152          0.847
LGA    L   122_E      E     153          1.370
LGA    A   123_E      I     154          2.324
LGA    E   124_E      D     155          0.834
LGA    -       -      V     156           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  124  152    5.0    110    2.05    25.45     58.972     5.117

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.836838 * X  +  -0.544797 * Y  +   0.053840 * Z  +  62.970432
  Y_new =  -0.358095 * X  +  -0.619123 * Y  +  -0.698896 * Z  + 106.749916
  Z_new =   0.414090 * X  +   0.565582 * Y  +  -0.713194 * Z  + -25.995237 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.471118   -0.670475  [ DEG:   141.5846    -38.4154 ]
  Theta =  -0.426942   -2.714650  [ DEG:   -24.4620   -155.5380 ]
  Phi   =  -0.404336    2.737256  [ DEG:   -23.1668    156.8332 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2csl_E                                        
REMARK     2: T0423.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2csl_E.T0423.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  124  152   5.0  110   2.05   25.45  58.972
REMARK  ---------------------------------------------------------- 
MOLECULE 2csl_E
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   22-MAY-05   2CSL              
TITLE     CRYSTAL STRUCTURE OF TTHA0137 FROM THERMUS THERMOPHILUS HB8           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN TRANSLATION INTIATION INHIBITOR;                   
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: HB8;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    STRUCTURAL GENOMICS, UNKNOWN FUNCTION, NPPSFA, NATIONAL               
KEYWDS   2 PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES,               
KEYWDS   3 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    H.WANG,K.MURAYAMA,T.TERADA,L.CHEN,Z.JIN,J.CHRZAS,Z.J.LIU,             
AUTHOR   2 B.C.WANG,M.SHIROUZU,S.KURAMITSU,S.YOKOYAMA,RIKEN STRUCTURAL          
AUTHOR   3 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   22-NOV-05 2CSL    0                                                
JRNL        AUTH   H.WANG,K.MURAYAMA,T.TERADA,L.CHEN,Z.JIN,J.CHRZAS,            
JRNL        AUTH 2 Z.J.LIU,B.C.WANG,M.SHIROUZU,S.KURAMITSU,S.YOKOYAMA           
JRNL        TITL   CRYSTAL STRUCTURE OF TTHA0137 FROM THERMUS                   
JRNL        TITL 2 THERMOPHILUS HB8                                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  2CSL A    1   124  UNP    Q5SM06   Q5SM06_THET8     1    124             
DBREF  2CSL B    1   124  UNP    Q5SM06   Q5SM06_THET8     1    124             
DBREF  2CSL C    1   124  UNP    Q5SM06   Q5SM06_THET8     1    124             
DBREF  2CSL D    1   124  UNP    Q5SM06   Q5SM06_THET8     1    124             
DBREF  2CSL E    1   124  UNP    Q5SM06   Q5SM06_THET8     1    124             
DBREF  2CSL F    1   124  UNP    Q5SM06   Q5SM06_THET8     1    124             
SEQRES   1 A  124  MSE GLU ALA VAL LYS THR ASP ARG ALA PRO ALA ALA ILE          
SEQRES   2 A  124  GLY PRO TYR ALA GLN ALA VAL LYS ALA GLY GLY PHE VAL          
SEQRES   3 A  124  PHE VAL SER GLY GLN ILE PRO LEU ALA PRO ASP GLY SER          
SEQRES   4 A  124  LEU VAL GLU GLY ASP ILE ARG VAL GLN THR GLU ARG VAL          
SEQRES   5 A  124  MSE GLU ASN LEU LYS ALA VAL LEU GLU ALA ALA GLY SER          
SEQRES   6 A  124  GLY LEU SER ARG VAL VAL GLN THR THR CYS PHE LEU ALA          
SEQRES   7 A  124  ASP MSE GLU ASP PHE PRO GLY PHE ASN GLU VAL TYR ALA          
SEQRES   8 A  124  ARG TYR PHE THR PRO PRO TYR PRO ALA ARG ALA THR VAL          
SEQRES   9 A  124  ALA VAL LYS ALA LEU PRO ARG GLY VAL ARG VAL GLU VAL          
SEQRES  10 A  124  ALA CYS VAL ALA LEU ALA GLU                                  
SEQRES   1 B  124  MSE GLU ALA VAL LYS THR ASP ARG ALA PRO ALA ALA ILE          
SEQRES   2 B  124  GLY PRO TYR ALA GLN ALA VAL LYS ALA GLY GLY PHE VAL          
SEQRES   3 B  124  PHE VAL SER GLY GLN ILE PRO LEU ALA PRO ASP GLY SER          
SEQRES   4 B  124  LEU VAL GLU GLY ASP ILE ARG VAL GLN THR GLU ARG VAL          
SEQRES   5 B  124  MSE GLU ASN LEU LYS ALA VAL LEU GLU ALA ALA GLY SER          
SEQRES   6 B  124  GLY LEU SER ARG VAL VAL GLN THR THR CYS PHE LEU ALA          
SEQRES   7 B  124  ASP MSE GLU ASP PHE PRO GLY PHE ASN GLU VAL TYR ALA          
SEQRES   8 B  124  ARG TYR PHE THR PRO PRO TYR PRO ALA ARG ALA THR VAL          
SEQRES   9 B  124  ALA VAL LYS ALA LEU PRO ARG GLY VAL ARG VAL GLU VAL          
SEQRES  10 B  124  ALA CYS VAL ALA LEU ALA GLU                                  
SEQRES   1 C  124  MSE GLU ALA VAL LYS THR ASP ARG ALA PRO ALA ALA ILE          
SEQRES   2 C  124  GLY PRO TYR ALA GLN ALA VAL LYS ALA GLY GLY PHE VAL          
SEQRES   3 C  124  PHE VAL SER GLY GLN ILE PRO LEU ALA PRO ASP GLY SER          
SEQRES   4 C  124  LEU VAL GLU GLY ASP ILE ARG VAL GLN THR GLU ARG VAL          
SEQRES   5 C  124  MSE GLU ASN LEU LYS ALA VAL LEU GLU ALA ALA GLY SER          
SEQRES   6 C  124  GLY LEU SER ARG VAL VAL GLN THR THR CYS PHE LEU ALA          
SEQRES   7 C  124  ASP MSE GLU ASP PHE PRO GLY PHE ASN GLU VAL TYR ALA          
SEQRES   8 C  124  ARG TYR PHE THR PRO PRO TYR PRO ALA ARG ALA THR VAL          
SEQRES   9 C  124  ALA VAL LYS ALA LEU PRO ARG GLY VAL ARG VAL GLU VAL          
SEQRES  10 C  124  ALA CYS VAL ALA LEU ALA GLU                                  
SEQRES   1 D  124  MSE GLU ALA VAL LYS THR ASP ARG ALA PRO ALA ALA ILE          
SEQRES   2 D  124  GLY PRO TYR ALA GLN ALA VAL LYS ALA GLY GLY PHE VAL          
SEQRES   3 D  124  PHE VAL SER GLY GLN ILE PRO LEU ALA PRO ASP GLY SER          
SEQRES   4 D  124  LEU VAL GLU GLY ASP ILE ARG VAL GLN THR GLU ARG VAL          
SEQRES   5 D  124  MSE GLU ASN LEU LYS ALA VAL LEU GLU ALA ALA GLY SER          
SEQRES   6 D  124  GLY LEU SER ARG VAL VAL GLN THR THR CYS PHE LEU ALA          
SEQRES   7 D  124  ASP MSE GLU ASP PHE PRO GLY PHE ASN GLU VAL TYR ALA          
SEQRES   8 D  124  ARG TYR PHE THR PRO PRO TYR PRO ALA ARG ALA THR VAL          
SEQRES   9 D  124  ALA VAL LYS ALA LEU PRO ARG GLY VAL ARG VAL GLU VAL          
SEQRES  10 D  124  ALA CYS VAL ALA LEU ALA GLU                                  
SEQRES   1 E  124  MSE GLU ALA VAL LYS THR ASP ARG ALA PRO ALA ALA ILE          
SEQRES   2 E  124  GLY PRO TYR ALA GLN ALA VAL LYS ALA GLY GLY PHE VAL          
SEQRES   3 E  124  PHE VAL SER GLY GLN ILE PRO LEU ALA PRO ASP GLY SER          
SEQRES   4 E  124  LEU VAL GLU GLY ASP ILE ARG VAL GLN THR GLU ARG VAL          
SEQRES   5 E  124  MSE GLU ASN LEU LYS ALA VAL LEU GLU ALA ALA GLY SER          
SEQRES   6 E  124  GLY LEU SER ARG VAL VAL GLN THR THR CYS PHE LEU ALA          
SEQRES   7 E  124  ASP MSE GLU ASP PHE PRO GLY PHE ASN GLU VAL TYR ALA          
SEQRES   8 E  124  ARG TYR PHE THR PRO PRO TYR PRO ALA ARG ALA THR VAL          
SEQRES   9 E  124  ALA VAL LYS ALA LEU PRO ARG GLY VAL ARG VAL GLU VAL          
SEQRES  10 E  124  ALA CYS VAL ALA LEU ALA GLU                                  
SEQRES   1 F  124  MSE GLU ALA VAL LYS THR ASP ARG ALA PRO ALA ALA ILE          
SEQRES   2 F  124  GLY PRO TYR ALA GLN ALA VAL LYS ALA GLY GLY PHE VAL          
SEQRES   3 F  124  PHE VAL SER GLY GLN ILE PRO LEU ALA PRO ASP GLY SER          
SEQRES   4 F  124  LEU VAL GLU GLY ASP ILE ARG VAL GLN THR GLU ARG VAL          
SEQRES   5 F  124  MSE GLU ASN LEU LYS ALA VAL LEU GLU ALA ALA GLY SER          
SEQRES   6 F  124  GLY LEU SER ARG VAL VAL GLN THR THR CYS PHE LEU ALA          
SEQRES   7 F  124  ASP MSE GLU ASP PHE PRO GLY PHE ASN GLU VAL TYR ALA          
SEQRES   8 F  124  ARG TYR PHE THR PRO PRO TYR PRO ALA ARG ALA THR VAL          
SEQRES   9 F  124  ALA VAL LYS ALA LEU PRO ARG GLY VAL ARG VAL GLU VAL          
SEQRES  10 F  124  ALA CYS VAL ALA LEU ALA GLU                                  
HET    MSE  A   1       8                                                       
HET    MSE  A  53       8                                                       
HET    MSE  A  80       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  53       8                                                       
HET    MSE  B  80       8                                                       
HET    MSE  C   1       8                                                       
HET    MSE  C  53       8                                                       
HET    MSE  C  80       8                                                       
HET    MSE  D   1       8                                                       
HET    MSE  D  53       8                                                       
HET    MSE  D  80       8                                                       
HET    MSE  E   1       8                                                       
HET    MSE  E  53       8                                                       
HET    MSE  E  80       8                                                       
HET    MSE  F   1       8                                                       
HET    MSE  F  53       8                                                       
HET    MSE  F  80       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    18(C5 H11 N O2 SE)                                           
FORMUL   7  HOH   *159(H2 O)                                                    
CRYST1  111.850  111.990  111.750  90.00  90.00  90.00 P 21 21 21   24          
HETATM 3701  N   MSE E   1      57.727  43.009  32.956  1.00 61.61           N  
HETATM 3702  CA  MSE E   1      58.817  43.748  33.661  1.00 71.03           C  
HETATM 3703  C   MSE E   1      58.779  43.437  35.150  1.00 62.78           C  
HETATM 3704  O   MSE E   1      57.782  43.692  35.819  1.00 61.90           O  
HETATM 3705  CB  MSE E   1      58.651  45.248  33.451  1.00 77.08           C  
HETATM 3706  CG  MSE E   1      59.853  46.059  33.865  1.00 70.23           C  
HETATM 3707 SE   MSE E   1      59.505  47.930  33.632  1.00 95.21          SE  
HETATM 3708  CE  MSE E   1      60.681  48.624  35.011  1.00 67.72           C  
ATOM   3709  N   GLU E   2      59.879  42.913  35.674  1.00 61.55           N  
ATOM   3710  CA  GLU E   2      59.926  42.546  37.076  1.00 61.13           C  
ATOM   3711  C   GLU E   2      61.328  42.642  37.659  1.00 59.72           C  
ATOM   3712  O   GLU E   2      62.284  42.140  37.078  1.00 65.84           O  
ATOM   3713  CB  GLU E   2      59.396  41.124  37.214  1.00 64.91           C  
ATOM   3714  CG  GLU E   2      59.590  40.483  38.558  1.00 78.10           C  
ATOM   3715  CD  GLU E   2      59.363  38.989  38.491  1.00 88.11           C  
ATOM   3716  OE1 GLU E   2      59.044  38.493  37.388  1.00 93.17           O  
ATOM   3717  OE2 GLU E   2      59.505  38.313  39.532  1.00 88.54           O  
ATOM   3718  N   ALA E   3      61.441  43.286  38.815  1.00 53.94           N  
ATOM   3719  CA  ALA E   3      62.727  43.442  39.483  1.00 45.36           C  
ATOM   3720  C   ALA E   3      63.152  42.135  40.130  1.00 49.04           C  
ATOM   3721  O   ALA E   3      62.316  41.304  40.469  1.00 59.01           O  
ATOM   3722  CB  ALA E   3      62.636  44.530  40.540  1.00 39.72           C  
ATOM   3723  N   VAL E   4      64.458  41.964  40.306  1.00 48.23           N  
ATOM   3724  CA  VAL E   4      65.002  40.762  40.924  1.00 42.71           C  
ATOM   3725  C   VAL E   4      65.585  41.103  42.286  1.00 49.42           C  
ATOM   3726  O   VAL E   4      66.420  41.998  42.396  1.00 54.07           O  
ATOM   3727  CB  VAL E   4      66.117  40.158  40.067  1.00 41.16           C  
ATOM   3728  CG1 VAL E   4      66.671  38.916  40.739  1.00 36.29           C  
ATOM   3729  CG2 VAL E   4      65.583  39.830  38.688  1.00 38.12           C  
ATOM   3730  N   LYS E   5      65.150  40.393  43.325  1.00 53.53           N  
ATOM   3731  CA  LYS E   5      65.649  40.647  44.676  1.00 54.80           C  
ATOM   3732  C   LYS E   5      66.312  39.414  45.277  1.00 52.58           C  
ATOM   3733  O   LYS E   5      65.698  38.350  45.365  1.00 60.45           O  
ATOM   3734  CB  LYS E   5      64.509  41.110  45.593  1.00 47.07           C  
ATOM   3735  CG  LYS E   5      64.637  42.549  46.084  1.00 55.31           C  
ATOM   3736  CD  LYS E   5      63.504  42.950  47.040  1.00 63.07           C  
ATOM   3737  CE  LYS E   5      63.838  42.638  48.502  1.00 68.49           C  
ATOM   3738  NZ  LYS E   5      62.745  43.053  49.432  1.00 73.87           N  
ATOM   3739  N   THR E   6      67.564  39.561  45.694  1.00 48.55           N  
ATOM   3740  CA  THR E   6      68.292  38.451  46.289  1.00 45.34           C  
ATOM   3741  C   THR E   6      69.025  38.823  47.564  1.00 56.28           C  
ATOM   3742  O   THR E   6      69.596  39.905  47.684  1.00 49.88           O  
ATOM   3743  CB  THR E   6      69.337  37.880  45.333  1.00 50.42           C  
ATOM   3744  OG1 THR E   6      68.706  37.497  44.109  1.00 78.09           O  
ATOM   3745  CG2 THR E   6      70.010  36.660  45.961  1.00 38.20           C  
ATOM   3746  N   ASP E   7      69.020  37.887  48.501  1.00 62.95           N  
ATOM   3747  CA  ASP E   7      69.675  38.052  49.782  1.00 64.00           C  
ATOM   3748  C   ASP E   7      71.138  37.621  49.637  1.00 60.58           C  
ATOM   3749  O   ASP E   7      71.971  37.911  50.498  1.00 56.69           O  
ATOM   3750  CB  ASP E   7      68.944  37.192  50.823  1.00 79.62           C  
ATOM   3751  CG  ASP E   7      69.468  37.396  52.227  1.00 97.04           C  
ATOM   3752  OD1 ASP E   7      69.768  38.555  52.584  1.00110.92           O  
ATOM   3753  OD2 ASP E   7      69.563  36.398  52.974  1.00102.10           O  
ATOM   3754  N   ARG E   8      71.444  36.945  48.528  1.00 56.81           N  
ATOM   3755  CA  ARG E   8      72.797  36.455  48.258  1.00 64.55           C  
ATOM   3756  C   ARG E   8      73.730  37.441  47.552  1.00 60.44           C  
ATOM   3757  O   ARG E   8      74.875  37.107  47.247  1.00 59.36           O  
ATOM   3758  CB  ARG E   8      72.739  35.151  47.447  1.00 70.59           C  
ATOM   3759  CG  ARG E   8      72.580  33.883  48.278  1.00 73.88           C  
ATOM   3760  CD  ARG E   8      72.446  32.647  47.386  1.00 82.20           C  
ATOM   3761  NE  ARG E   8      73.667  32.330  46.642  1.00 86.72           N  
ATOM   3762  CZ  ARG E   8      73.685  31.925  45.372  1.00 86.27           C  
ATOM   3763  NH1 ARG E   8      72.547  31.794  44.702  1.00 83.46           N  
ATOM   3764  NH2 ARG E   8      74.836  31.640  44.771  1.00 72.91           N  
ATOM   3765  N   ALA E   9      73.239  38.645  47.283  1.00 61.25           N  
ATOM   3766  CA  ALA E   9      74.042  39.675  46.625  1.00 60.70           C  
ATOM   3767  C   ALA E   9      73.688  41.027  47.242  1.00 58.16           C  
ATOM   3768  O   ALA E   9      72.558  41.230  47.683  1.00 55.07           O  
ATOM   3769  CB  ALA E   9      73.766  39.681  45.122  1.00 45.74           C  
ATOM   3770  N   PRO E  10      74.646  41.971  47.274  1.00 57.66           N  
ATOM   3771  CA  PRO E  10      74.384  43.294  47.854  1.00 48.37           C  
ATOM   3772  C   PRO E  10      72.991  43.801  47.513  1.00 50.84           C  
ATOM   3773  O   PRO E  10      72.573  43.778  46.355  1.00 51.89           O  
ATOM   3774  CB  PRO E  10      75.483  44.154  47.249  1.00 52.44           C  
ATOM   3775  CG  PRO E  10      76.625  43.192  47.134  1.00 55.83           C  
ATOM   3776  CD  PRO E  10      75.939  41.961  46.567  1.00 61.89           C  
ATOM   3777  N   ALA E  11      72.272  44.241  48.537  1.00 54.64           N  
ATOM   3778  CA  ALA E  11      70.918  44.746  48.361  1.00 53.28           C  
ATOM   3779  C   ALA E  11      70.966  46.085  47.647  1.00 51.21           C  
ATOM   3780  O   ALA E  11      71.845  46.903  47.903  1.00 52.85           O  
ATOM   3781  CB  ALA E  11      70.238  44.901  49.714  1.00 51.46           C  
ATOM   3782  N   ALA E  12      70.023  46.296  46.740  1.00 50.92           N  
ATOM   3783  CA  ALA E  12      69.961  47.540  45.992  1.00 47.80           C  
ATOM   3784  C   ALA E  12      69.302  48.599  46.856  1.00 48.58           C  
ATOM   3785  O   ALA E  12      68.079  48.653  46.972  1.00 50.16           O  
ATOM   3786  CB  ALA E  12      69.165  47.345  44.710  1.00 32.44           C  
ATOM   3787  N   ILE E  13      70.123  49.434  47.477  1.00 51.77           N  
ATOM   3788  CA  ILE E  13      69.609  50.505  48.311  1.00 55.84           C  
ATOM   3789  C   ILE E  13      69.651  51.765  47.452  1.00 56.84           C  
ATOM   3790  O   ILE E  13      70.714  52.347  47.238  1.00 59.25           O  
ATOM   3791  CB  ILE E  13      70.478  50.692  49.561  1.00 56.36           C  
ATOM   3792  CG1 ILE E  13      70.873  49.322  50.127  1.00 63.65           C  
ATOM   3793  CG2 ILE E  13      69.697  51.459  50.608  1.00 51.03           C  
ATOM   3794  CD1 ILE E  13      71.889  49.369  51.261  1.00 66.62           C  
ATOM   3795  N   GLY E  14      68.490  52.165  46.944  1.00 48.31           N  
ATOM   3796  CA  GLY E  14      68.422  53.332  46.091  1.00 39.35           C  
ATOM   3797  C   GLY E  14      67.434  53.117  44.957  1.00 41.01           C  
ATOM   3798  O   GLY E  14      66.737  52.104  44.923  1.00 36.25           O  
ATOM   3799  N   PRO E  15      67.369  54.048  43.993  1.00 43.48           N  
ATOM   3800  CA  PRO E  15      66.455  53.974  42.845  1.00 41.63           C  
ATOM   3801  C   PRO E  15      66.847  52.941  41.788  1.00 43.71           C  
ATOM   3802  O   PRO E  15      66.789  53.227  40.593  1.00 39.69           O  
ATOM   3803  CB  PRO E  15      66.496  55.394  42.264  1.00 44.36           C  
ATOM   3804  CG  PRO E  15      67.325  56.219  43.268  1.00 46.36           C  
ATOM   3805  CD  PRO E  15      68.245  55.222  43.881  1.00 30.23           C  
ATOM   3806  N   TYR E  16      67.247  51.748  42.205  1.00 38.32           N  
ATOM   3807  CA  TYR E  16      67.630  50.739  41.229  1.00 47.83           C  
ATOM   3808  C   TYR E  16      67.372  49.342  41.761  1.00 45.80           C  
ATOM   3809  O   TYR E  16      67.273  49.147  42.966  1.00 48.12           O  
ATOM   3810  CB  TYR E  16      69.108  50.895  40.862  1.00 31.90           C  
ATOM   3811  CG  TYR E  16      70.061  50.502  41.966  1.00 31.63           C  
ATOM   3812  CD1 TYR E  16      70.713  49.267  41.952  1.00 34.01           C  
ATOM   3813  CD2 TYR E  16      70.286  51.351  43.045  1.00 35.80           C  
ATOM   3814  CE1 TYR E  16      71.563  48.887  42.995  1.00 30.46           C  
ATOM   3815  CE2 TYR E  16      71.132  50.983  44.093  1.00 31.17           C  
ATOM   3816  CZ  TYR E  16      71.763  49.753  44.063  1.00 44.41           C  
ATOM   3817  OH  TYR E  16      72.569  49.394  45.121  1.00 46.98           O  
ATOM   3818  N   ALA E  17      67.245  48.382  40.850  1.00 43.51           N  
ATOM   3819  CA  ALA E  17      67.026  46.986  41.214  1.00 40.90           C  
ATOM   3820  C   ALA E  17      68.311  46.247  40.886  1.00 41.72           C  
ATOM   3821  O   ALA E  17      69.078  46.701  40.035  1.00 40.03           O  
ATOM   3822  CB  ALA E  17      65.876  46.406  40.408  1.00 27.25           C  
ATOM   3823  N   GLN E  18      68.563  45.124  41.558  1.00 41.17           N  
ATOM   3824  CA  GLN E  18      69.771  44.350  41.278  1.00 39.71           C  
ATOM   3825  C   GLN E  18      69.726  43.896  39.821  1.00 42.98           C  
ATOM   3826  O   GLN E  18      70.771  43.756  39.175  1.00 46.81           O  
ATOM   3827  CB  GLN E  18      69.864  43.134  42.198  1.00 38.25           C  
ATOM   3828  CG  GLN E  18      69.978  43.476  43.678  1.00 40.62           C  
ATOM   3829  CD  GLN E  18      69.898  42.237  44.552  1.00 48.44           C  
ATOM   3830  OE1 GLN E  18      69.028  41.383  44.355  1.00 38.45           O  
ATOM   3831  NE2 GLN E  18      70.800  42.134  45.528  1.00 39.22           N  
ATOM   3832  N   ALA E  19      68.512  43.676  39.312  1.00 31.69           N  
ATOM   3833  CA  ALA E  19      68.305  43.265  37.925  1.00 35.80           C  
ATOM   3834  C   ALA E  19      66.827  43.364  37.548  1.00 38.57           C  
ATOM   3835  O   ALA E  19      65.957  43.386  38.419  1.00 42.64           O  
ATOM   3836  CB  ALA E  19      68.811  41.841  37.713  1.00 36.30           C  
ATOM   3837  N   VAL E  20      66.550  43.428  36.249  1.00 41.27           N  
ATOM   3838  CA  VAL E  20      65.183  43.528  35.740  1.00 38.82           C  
ATOM   3839  C   VAL E  20      64.900  42.504  34.639  1.00 43.68           C  
ATOM   3840  O   VAL E  20      65.650  42.395  33.675  1.00 49.76           O  
ATOM   3841  CB  VAL E  20      64.900  44.937  35.146  1.00 40.87           C  
ATOM   3842  CG1 VAL E  20      63.584  44.935  34.390  1.00 35.61           C  
ATOM   3843  CG2 VAL E  20      64.855  45.974  36.244  1.00 37.01           C  
ATOM   3844  N   LYS E  21      63.817  41.751  34.790  1.00 48.66           N  
ATOM   3845  CA  LYS E  21      63.422  40.776  33.780  1.00 43.14           C  
ATOM   3846  C   LYS E  21      62.454  41.498  32.848  1.00 45.10           C  
ATOM   3847  O   LYS E  21      61.478  42.094  33.306  1.00 48.47           O  
ATOM   3848  CB  LYS E  21      62.734  39.563  34.424  1.00 44.16           C  
ATOM   3849  CG  LYS E  21      63.692  38.612  35.141  1.00 45.36           C  
ATOM   3850  CD  LYS E  21      63.206  37.163  35.103  1.00 57.76           C  
ATOM   3851  CE  LYS E  21      62.236  36.839  36.226  1.00 65.38           C  
ATOM   3852  NZ  LYS E  21      61.746  35.433  36.140  1.00 72.53           N  
ATOM   3853  N   ALA E  22      62.735  41.476  31.547  1.00 40.67           N  
ATOM   3854  CA  ALA E  22      61.866  42.146  30.584  1.00 40.10           C  
ATOM   3855  C   ALA E  22      62.182  41.770  29.142  1.00 43.60           C  
ATOM   3856  O   ALA E  22      63.347  41.626  28.776  1.00 46.13           O  
ATOM   3857  CB  ALA E  22      61.970  43.646  30.755  1.00 44.26           C  
ATOM   3858  N   GLY E  23      61.133  41.608  28.340  1.00 30.24           N  
ATOM   3859  CA  GLY E  23      61.290  41.263  26.936  1.00 37.04           C  
ATOM   3860  C   GLY E  23      62.128  40.045  26.586  1.00 41.22           C  
ATOM   3861  O   GLY E  23      62.636  39.942  25.469  1.00 47.56           O  
ATOM   3862  N   GLY E  24      62.274  39.115  27.523  1.00 45.09           N  
ATOM   3863  CA  GLY E  24      63.059  37.927  27.255  1.00 34.57           C  
ATOM   3864  C   GLY E  24      64.487  38.035  27.769  1.00 49.41           C  
ATOM   3865  O   GLY E  24      65.261  37.078  27.674  1.00 40.57           O  
ATOM   3866  N   PHE E  25      64.846  39.191  28.325  1.00 39.16           N  
ATOM   3867  CA  PHE E  25      66.199  39.380  28.831  1.00 39.91           C  
ATOM   3868  C   PHE E  25      66.253  39.736  30.307  1.00 40.81           C  
ATOM   3869  O   PHE E  25      65.251  40.063  30.927  1.00 45.30           O  
ATOM   3870  CB  PHE E  25      66.924  40.486  28.061  1.00 33.60           C  
ATOM   3871  CG  PHE E  25      67.175  40.175  26.618  1.00 44.65           C  
ATOM   3872  CD1 PHE E  25      66.264  40.564  25.638  1.00 49.24           C  
ATOM   3873  CD2 PHE E  25      68.336  39.522  26.230  1.00 49.22           C  
ATOM   3874  CE1 PHE E  25      66.512  40.311  24.290  1.00 45.88           C  
ATOM   3875  CE2 PHE E  25      68.595  39.263  24.883  1.00 51.71           C  
ATOM   3876  CZ  PHE E  25      67.683  39.659  23.913  1.00 55.70           C  
ATOM   3877  N   VAL E  26      67.455  39.662  30.856  1.00 41.44           N  
ATOM   3878  CA  VAL E  26      67.687  40.015  32.242  1.00 44.86           C  
ATOM   3879  C   VAL E  26      68.768  41.081  32.192  1.00 39.77           C  
ATOM   3880  O   VAL E  26      69.844  40.846  31.641  1.00 40.66           O  
ATOM   3881  CB  VAL E  26      68.212  38.831  33.069  1.00 32.51           C  
ATOM   3882  CG1 VAL E  26      68.411  39.265  34.502  1.00 21.05           C  
ATOM   3883  CG2 VAL E  26      67.242  37.677  33.001  1.00 36.58           C  
ATOM   3884  N   PHE E  27      68.468  42.251  32.743  1.00 35.48           N  
ATOM   3885  CA  PHE E  27      69.421  43.351  32.768  1.00 36.97           C  
ATOM   3886  C   PHE E  27      69.961  43.447  34.188  1.00 34.81           C  
ATOM   3887  O   PHE E  27      69.262  43.871  35.098  1.00 42.36           O  
ATOM   3888  CB  PHE E  27      68.722  44.644  32.361  1.00 35.65           C  
ATOM   3889  CG  PHE E  27      68.162  44.617  30.958  1.00 38.99           C  
ATOM   3890  CD1 PHE E  27      68.899  45.115  29.888  1.00 36.51           C  
ATOM   3891  CD2 PHE E  27      66.900  44.090  30.711  1.00 35.23           C  
ATOM   3892  CE1 PHE E  27      68.386  45.089  28.594  1.00 33.97           C  
ATOM   3893  CE2 PHE E  27      66.377  44.061  29.418  1.00 39.60           C  
ATOM   3894  CZ  PHE E  27      67.122  44.564  28.358  1.00 34.98           C  
ATOM   3895  N   VAL E  28      71.212  43.037  34.361  1.00 34.81           N  
ATOM   3896  CA  VAL E  28      71.870  43.032  35.660  1.00 34.02           C  
ATOM   3897  C   VAL E  28      72.613  44.331  35.950  1.00 36.88           C  
ATOM   3898  O   VAL E  28      73.395  44.794  35.131  1.00 37.02           O  
ATOM   3899  CB  VAL E  28      72.875  41.867  35.735  1.00 30.13           C  
ATOM   3900  CG1 VAL E  28      73.506  41.798  37.120  1.00 35.27           C  
ATOM   3901  CG2 VAL E  28      72.168  40.570  35.396  1.00 31.14           C  
ATOM   3902  N   SER E  29      72.372  44.906  37.126  1.00 34.85           N  
ATOM   3903  CA  SER E  29      73.024  46.154  37.518  1.00 34.98           C  
ATOM   3904  C   SER E  29      74.522  45.974  37.676  1.00 33.00           C  
ATOM   3905  O   SER E  29      74.995  44.863  37.911  1.00 42.74           O  
ATOM   3906  CB  SER E  29      72.444  46.676  38.839  1.00 29.72           C  
ATOM   3907  OG  SER E  29      71.163  47.254  38.652  1.00 41.25           O  
ATOM   3908  N   GLY E  30      75.265  47.073  37.547  1.00 34.38           N  
ATOM   3909  CA  GLY E  30      76.709  47.019  37.700  1.00 31.01           C  
ATOM   3910  C   GLY E  30      77.059  46.490  39.076  1.00 35.19           C  
ATOM   3911  O   GLY E  30      76.617  47.033  40.086  1.00 42.40           O  
ATOM   3912  N   GLN E  31      77.851  45.428  39.129  1.00 40.16           N  
ATOM   3913  CA  GLN E  31      78.220  44.840  40.411  1.00 44.53           C  
ATOM   3914  C   GLN E  31      79.627  45.245  40.827  1.00 45.21           C  
ATOM   3915  O   GLN E  31      80.523  45.342  39.994  1.00 41.66           O  
ATOM   3916  CB  GLN E  31      78.121  43.307  40.335  1.00 37.68           C  
ATOM   3917  CG  GLN E  31      76.747  42.790  39.934  1.00 38.70           C  
ATOM   3918  CD  GLN E  31      75.682  43.138  40.948  1.00 47.70           C  
ATOM   3919  OE1 GLN E  31      74.558  43.485  40.591  1.00 53.61           O  
ATOM   3920  NE2 GLN E  31      76.026  43.039  42.222  1.00 47.53           N  
ATOM   3921  N   ILE E  32      79.812  45.492  42.122  1.00 53.39           N  
ATOM   3922  CA  ILE E  32      81.118  45.869  42.657  1.00 42.17           C  
ATOM   3923  C   ILE E  32      81.524  44.888  43.756  1.00 41.60           C  
ATOM   3924  O   ILE E  32      80.725  44.048  44.167  1.00 43.50           O  
ATOM   3925  CB  ILE E  32      81.131  47.340  43.195  1.00 44.88           C  
ATOM   3926  CG1 ILE E  32      79.999  47.584  44.201  1.00 45.18           C  
ATOM   3927  CG2 ILE E  32      81.038  48.300  42.028  1.00 51.43           C  
ATOM   3928  CD1 ILE E  32      78.627  47.610  43.592  1.00 72.62           C  
ATOM   3929  N   PRO E  33      82.778  44.972  44.231  1.00 33.53           N  
ATOM   3930  CA  PRO E  33      83.315  44.098  45.276  1.00 32.42           C  
ATOM   3931  C   PRO E  33      82.676  44.242  46.656  1.00 44.46           C  
ATOM   3932  O   PRO E  33      83.365  44.536  47.633  1.00 55.04           O  
ATOM   3933  CB  PRO E  33      84.804  44.466  45.310  1.00 31.46           C  
ATOM   3934  CG  PRO E  33      85.066  45.108  43.997  1.00 32.83           C  
ATOM   3935  CD  PRO E  33      83.819  45.900  43.756  1.00 37.29           C  
ATOM   3936  N   LEU E  34      81.368  44.038  46.746  1.00 46.08           N  
ATOM   3937  CA  LEU E  34      80.683  44.132  48.028  1.00 43.84           C  
ATOM   3938  C   LEU E  34      80.058  42.795  48.381  1.00 50.27           C  
ATOM   3939  O   LEU E  34      79.391  42.182  47.547  1.00 52.14           O  
ATOM   3940  CB  LEU E  34      79.567  45.172  47.984  1.00 51.96           C  
ATOM   3941  CG  LEU E  34      79.877  46.648  47.777  1.00 57.46           C  
ATOM   3942  CD1 LEU E  34      78.619  47.429  48.111  1.00 52.92           C  
ATOM   3943  CD2 LEU E  34      81.018  47.095  48.675  1.00 56.87           C  
ATOM   3944  N   ALA E  35      80.271  42.338  49.613  1.00 53.49           N  
ATOM   3945  CA  ALA E  35      79.678  41.081  50.061  1.00 53.29           C  
ATOM   3946  C   ALA E  35      78.200  41.362  50.333  1.00 55.43           C  
ATOM   3947  O   ALA E  35      77.803  42.512  50.510  1.00 57.89           O  
ATOM   3948  CB  ALA E  35      80.362  40.592  51.323  1.00 48.37           C  
ATOM   3949  N   PRO E  36      77.365  40.317  50.369  1.00 57.79           N  
ATOM   3950  CA  PRO E  36      75.929  40.484  50.619  1.00 52.49           C  
ATOM   3951  C   PRO E  36      75.530  41.423  51.764  1.00 61.56           C  
ATOM   3952  O   PRO E  36      74.592  42.213  51.620  1.00 61.68           O  
ATOM   3953  CB  PRO E  36      75.462  39.053  50.843  1.00 52.04           C  
ATOM   3954  CG  PRO E  36      76.326  38.292  49.860  1.00 46.29           C  
ATOM   3955  CD  PRO E  36      77.694  38.903  50.105  1.00 53.32           C  
ATOM   3956  N   ASP E  37      76.233  41.343  52.893  1.00 68.58           N  
ATOM   3957  CA  ASP E  37      75.919  42.192  54.045  1.00 73.58           C  
ATOM   3958  C   ASP E  37      76.211  43.671  53.811  1.00 70.91           C  
ATOM   3959  O   ASP E  37      75.727  44.527  54.551  1.00 75.72           O  
ATOM   3960  CB  ASP E  37      76.675  41.717  55.286  1.00 79.47           C  
ATOM   3961  CG  ASP E  37      78.143  41.492  55.021  1.00 91.36           C  
ATOM   3962  OD1 ASP E  37      78.463  40.587  54.221  1.00106.77           O  
ATOM   3963  OD2 ASP E  37      78.973  42.217  55.604  1.00 87.43           O  
ATOM   3964  N   GLY E  38      77.004  43.972  52.789  1.00 67.98           N  
ATOM   3965  CA  GLY E  38      77.309  45.358  52.490  1.00 57.92           C  
ATOM   3966  C   GLY E  38      78.763  45.733  52.687  1.00 59.88           C  
ATOM   3967  O   GLY E  38      79.208  46.778  52.209  1.00 62.68           O  
ATOM   3968  N   SER E  39      79.513  44.888  53.385  1.00 64.36           N  
ATOM   3969  CA  SER E  39      80.922  45.168  53.633  1.00 70.85           C  
ATOM   3970  C   SER E  39      81.728  45.210  52.332  1.00 70.37           C  
ATOM   3971  O   SER E  39      81.386  44.557  51.344  1.00 70.37           O  
ATOM   3972  CB  SER E  39      81.518  44.119  54.576  1.00 73.91           C  
ATOM   3973  OG  SER E  39      81.709  42.882  53.913  1.00 73.69           O  
ATOM   3974  N   LEU E  40      82.808  45.983  52.356  1.00 68.80           N  
ATOM   3975  CA  LEU E  40      83.687  46.159  51.208  1.00 60.81           C  
ATOM   3976  C   LEU E  40      84.802  45.119  51.222  1.00 65.99           C  
ATOM   3977  O   LEU E  40      85.487  44.951  52.231  1.00 67.31           O  
ATOM   3978  CB  LEU E  40      84.281  47.573  51.254  1.00 66.10           C  
ATOM   3979  CG  LEU E  40      84.996  48.215  50.058  1.00 75.38           C  
ATOM   3980  CD1 LEU E  40      86.292  47.482  49.756  1.00 72.44           C  
ATOM   3981  CD2 LEU E  40      84.070  48.216  48.852  1.00 65.36           C  
ATOM   3982  N   VAL E  41      84.974  44.418  50.104  1.00 66.43           N  
ATOM   3983  CA  VAL E  41      86.026  43.410  49.979  1.00 64.41           C  
ATOM   3984  C   VAL E  41      87.210  44.059  49.278  1.00 69.52           C  
ATOM   3985  O   VAL E  41      87.146  44.349  48.084  1.00 71.99           O  
ATOM   3986  CB  VAL E  41      85.565  42.205  49.140  1.00 59.29           C  
ATOM   3987  CG1 VAL E  41      86.725  41.241  48.932  1.00 44.95           C  
ATOM   3988  CG2 VAL E  41      84.400  41.507  49.828  1.00 55.03           C  
ATOM   3989  N   GLU E  42      88.288  44.290  50.019  1.00 71.43           N  
ATOM   3990  CA  GLU E  42      89.467  44.929  49.449  1.00 73.03           C  
ATOM   3991  C   GLU E  42      90.511  43.911  49.004  1.00 71.23           C  
ATOM   3992  O   GLU E  42      90.427  42.729  49.342  1.00 66.74           O  
ATOM   3993  CB  GLU E  42      90.096  45.883  50.467  1.00 82.55           C  
ATOM   3994  CG  GLU E  42      89.099  46.651  51.317  1.00 92.28           C  
ATOM   3995  CD  GLU E  42      89.294  46.385  52.799  1.00105.24           C  
ATOM   3996  OE1 GLU E  42      90.414  46.623  53.301  1.00 98.46           O  
ATOM   3997  OE2 GLU E  42      88.332  45.936  53.461  1.00108.32           O  
ATOM   3998  N   GLY E  43      91.500  44.390  48.253  1.00 68.86           N  
ATOM   3999  CA  GLY E  43      92.560  43.529  47.760  1.00 58.36           C  
ATOM   4000  C   GLY E  43      92.826  43.777  46.288  1.00 54.88           C  
ATOM   4001  O   GLY E  43      92.241  44.685  45.691  1.00 53.60           O  
ATOM   4002  N   ASP E  44      93.712  42.982  45.698  1.00 44.08           N  
ATOM   4003  CA  ASP E  44      94.028  43.128  44.283  1.00 50.97           C  
ATOM   4004  C   ASP E  44      92.787  42.765  43.460  1.00 49.30           C  
ATOM   4005  O   ASP E  44      91.794  42.279  44.012  1.00 49.51           O  
ATOM   4006  CB  ASP E  44      95.211  42.220  43.898  1.00 57.75           C  
ATOM   4007  CG  ASP E  44      94.837  40.746  43.845  1.00 61.00           C  
ATOM   4008  OD1 ASP E  44      95.621  39.961  43.273  1.00 74.66           O  
ATOM   4009  OD2 ASP E  44      93.769  40.369  44.369  1.00 76.87           O  
ATOM   4010  N   ILE E  45      92.843  42.991  42.148  1.00 47.97           N  
ATOM   4011  CA  ILE E  45      91.708  42.694  41.276  1.00 48.14           C  
ATOM   4012  C   ILE E  45      91.183  41.276  41.356  1.00 43.56           C  
ATOM   4013  O   ILE E  45      89.977  41.068  41.303  1.00 47.43           O  
ATOM   4014  CB  ILE E  45      92.017  42.978  39.796  1.00 47.63           C  
ATOM   4015  CG1 ILE E  45      93.526  43.138  39.593  1.00 49.44           C  
ATOM   4016  CG2 ILE E  45      91.206  44.171  39.323  1.00 38.61           C  
ATOM   4017  CD1 ILE E  45      94.282  41.827  39.572  1.00 59.00           C  
ATOM   4018  N   ARG E  46      92.075  40.299  41.473  1.00 43.37           N  
ATOM   4019  CA  ARG E  46      91.633  38.912  41.559  1.00 51.69           C  
ATOM   4020  C   ARG E  46      90.602  38.713  42.666  1.00 53.27           C  
ATOM   4021  O   ARG E  46      89.556  38.100  42.441  1.00 53.13           O  
ATOM   4022  CB  ARG E  46      92.827  37.983  41.786  1.00 48.74           C  
ATOM   4023  CG  ARG E  46      93.700  37.812  40.561  1.00 50.56           C  
ATOM   4024  CD  ARG E  46      94.864  36.870  40.815  1.00 53.13           C  
ATOM   4025  NE  ARG E  46      95.493  36.486  39.553  1.00 55.11           N  
ATOM   4026  CZ  ARG E  46      96.197  37.306  38.778  1.00 58.11           C  
ATOM   4027  NH1 ARG E  46      96.386  38.575  39.131  1.00 55.36           N  
ATOM   4028  NH2 ARG E  46      96.685  36.862  37.625  1.00 43.35           N  
ATOM   4029  N   VAL E  47      90.897  39.240  43.851  1.00 49.51           N  
ATOM   4030  CA  VAL E  47      90.004  39.114  44.993  1.00 48.69           C  
ATOM   4031  C   VAL E  47      88.711  39.884  44.755  1.00 52.06           C  
ATOM   4032  O   VAL E  47      87.610  39.377  45.012  1.00 47.18           O  
ATOM   4033  CB  VAL E  47      90.674  39.649  46.287  1.00 54.09           C  
ATOM   4034  CG1 VAL E  47      89.660  39.713  47.425  1.00 55.70           C  
ATOM   4035  CG2 VAL E  47      91.830  38.748  46.679  1.00 47.16           C  
ATOM   4036  N   GLN E  48      88.843  41.107  44.254  1.00 40.78           N  
ATOM   4037  CA  GLN E  48      87.669  41.927  44.001  1.00 45.79           C  
ATOM   4038  C   GLN E  48      86.848  41.407  42.828  1.00 47.03           C  
ATOM   4039  O   GLN E  48      85.615  41.318  42.908  1.00 44.62           O  
ATOM   4040  CB  GLN E  48      88.074  43.388  43.774  1.00 45.72           C  
ATOM   4041  CG  GLN E  48      88.478  44.101  45.059  1.00 61.36           C  
ATOM   4042  CD  GLN E  48      88.754  45.583  44.865  1.00 67.40           C  
ATOM   4043  OE1 GLN E  48      87.933  46.316  44.314  1.00 48.18           O  
ATOM   4044  NE2 GLN E  48      89.915  46.033  45.333  1.00 71.85           N  
ATOM   4045  N   THR E  49      87.529  41.057  41.743  1.00 43.91           N  
ATOM   4046  CA  THR E  49      86.850  40.540  40.567  1.00 40.39           C  
ATOM   4047  C   THR E  49      86.056  39.305  40.965  1.00 42.27           C  
ATOM   4048  O   THR E  49      84.938  39.096  40.491  1.00 44.43           O  
ATOM   4049  CB  THR E  49      87.854  40.164  39.450  1.00 38.90           C  
ATOM   4050  OG1 THR E  49      88.521  41.347  38.992  1.00 40.25           O  
ATOM   4051  CG2 THR E  49      87.136  39.513  38.274  1.00 35.84           C  
ATOM   4052  N   GLU E  50      86.629  38.497  41.852  1.00 45.41           N  
ATOM   4053  CA  GLU E  50      85.962  37.278  42.292  1.00 51.03           C  
ATOM   4054  C   GLU E  50      84.646  37.589  42.977  1.00 50.75           C  
ATOM   4055  O   GLU E  50      83.643  36.910  42.746  1.00 52.49           O  
ATOM   4056  CB  GLU E  50      86.853  36.481  43.247  1.00 52.11           C  
ATOM   4057  CG  GLU E  50      86.174  35.234  43.797  1.00 62.91           C  
ATOM   4058  CD  GLU E  50      87.095  34.389  44.645  1.00 74.10           C  
ATOM   4059  OE1 GLU E  50      87.595  34.897  45.673  1.00 78.52           O  
ATOM   4060  OE2 GLU E  50      87.321  33.215  44.281  1.00 76.29           O  
ATOM   4061  N   ARG E  51      84.650  38.611  43.826  1.00 47.33           N  
ATOM   4062  CA  ARG E  51      83.433  38.990  44.528  1.00 45.64           C  
ATOM   4063  C   ARG E  51      82.399  39.483  43.517  1.00 34.18           C  
ATOM   4064  O   ARG E  51      81.239  39.072  43.567  1.00 38.70           O  
ATOM   4065  CB  ARG E  51      83.746  40.047  45.598  1.00 41.11           C  
ATOM   4066  CG  ARG E  51      82.541  40.731  46.240  1.00 53.58           C  
ATOM   4067  CD  ARG E  51      81.297  39.842  46.336  1.00 62.63           C  
ATOM   4068  NE  ARG E  51      81.474  38.649  47.153  1.00 49.36           N  
ATOM   4069  CZ  ARG E  51      80.532  37.726  47.322  1.00 63.12           C  
ATOM   4070  NH1 ARG E  51      79.352  37.859  46.730  1.00 61.96           N  
ATOM   4071  NH2 ARG E  51      80.762  36.670  48.088  1.00 73.09           N  
ATOM   4072  N   VAL E  52      82.818  40.342  42.593  1.00 30.62           N  
ATOM   4073  CA  VAL E  52      81.911  40.842  41.562  1.00 34.48           C  
ATOM   4074  C   VAL E  52      81.289  39.664  40.810  1.00 40.90           C  
ATOM   4075  O   VAL E  52      80.082  39.646  40.567  1.00 43.12           O  
ATOM   4076  CB  VAL E  52      82.644  41.743  40.536  1.00 45.49           C  
ATOM   4077  CG1 VAL E  52      81.712  42.076  39.373  1.00 25.99           C  
ATOM   4078  CG2 VAL E  52      83.126  43.031  41.212  1.00 34.09           C  
HETATM 4079  N   MSE E  53      82.107  38.678  40.450  1.00 33.04           N  
HETATM 4080  CA  MSE E  53      81.597  37.506  39.739  1.00 38.71           C  
HETATM 4081  C   MSE E  53      80.533  36.772  40.550  1.00 41.46           C  
HETATM 4082  O   MSE E  53      79.439  36.502  40.050  1.00 40.94           O  
HETATM 4083  CB  MSE E  53      82.732  36.539  39.398  1.00 39.45           C  
HETATM 4084  CG  MSE E  53      83.714  37.071  38.353  1.00 43.03           C  
HETATM 4085 SE   MSE E  53      82.873  37.452  36.642  1.00 65.01          SE  
HETATM 4086  CE  MSE E  53      82.990  39.383  36.663  1.00 49.47           C  
ATOM   4087  N   GLU E  54      80.848  36.456  41.805  1.00 44.42           N  
ATOM   4088  CA  GLU E  54      79.902  35.754  42.668  1.00 40.61           C  
ATOM   4089  C   GLU E  54      78.581  36.515  42.775  1.00 45.94           C  
ATOM   4090  O   GLU E  54      77.509  35.902  42.787  1.00 38.80           O  
ATOM   4091  CB  GLU E  54      80.502  35.540  44.059  1.00 49.09           C  
ATOM   4092  CG  GLU E  54      81.604  34.479  44.124  1.00 57.64           C  
ATOM   4093  CD  GLU E  54      81.114  33.084  43.742  1.00 74.88           C  
ATOM   4094  OE1 GLU E  54      80.013  32.692  44.188  1.00 77.07           O  
ATOM   4095  OE2 GLU E  54      81.836  32.374  43.004  1.00 73.81           O  
ATOM   4096  N   ASN E  55      78.648  37.846  42.840  1.00 49.51           N  
ATOM   4097  CA  ASN E  55      77.429  38.644  42.921  1.00 50.67           C  
ATOM   4098  C   ASN E  55      76.597  38.474  41.648  1.00 54.87           C  
ATOM   4099  O   ASN E  55      75.380  38.274  41.717  1.00 55.94           O  
ATOM   4100  CB  ASN E  55      77.746  40.129  43.146  1.00 49.79           C  
ATOM   4101  CG  ASN E  55      78.253  40.415  44.551  1.00 56.77           C  
ATOM   4102  OD1 ASN E  55      77.914  39.710  45.505  1.00 50.43           O  
ATOM   4103  ND2 ASN E  55      79.055  41.467  44.687  1.00 47.96           N  
ATOM   4104  N   LEU E  56      77.251  38.551  40.490  1.00 41.42           N  
ATOM   4105  CA  LEU E  56      76.548  38.374  39.221  1.00 47.47           C  
ATOM   4106  C   LEU E  56      75.847  37.017  39.217  1.00 42.99           C  
ATOM   4107  O   LEU E  56      74.667  36.908  38.870  1.00 36.40           O  
ATOM   4108  CB  LEU E  56      77.527  38.436  38.045  1.00 49.23           C  
ATOM   4109  CG  LEU E  56      78.099  39.794  37.642  1.00 48.26           C  
ATOM   4110  CD1 LEU E  56      79.163  39.599  36.580  1.00 41.14           C  
ATOM   4111  CD2 LEU E  56      76.980  40.686  37.130  1.00 39.02           C  
ATOM   4112  N   LYS E  57      76.589  35.988  39.609  1.00 40.59           N  
ATOM   4113  CA  LYS E  57      76.065  34.628  39.665  1.00 41.67           C  
ATOM   4114  C   LYS E  57      74.773  34.585  40.483  1.00 42.14           C  
ATOM   4115  O   LYS E  57      73.750  34.090  40.011  1.00 43.12           O  
ATOM   4116  CB  LYS E  57      77.115  33.697  40.281  1.00 40.62           C  
ATOM   4117  CG  LYS E  57      76.704  32.243  40.342  1.00 40.94           C  
ATOM   4118  CD  LYS E  57      77.853  31.380  40.821  1.00 48.50           C  
ATOM   4119  CE  LYS E  57      77.457  29.914  40.848  1.00 48.27           C  
ATOM   4120  NZ  LYS E  57      78.622  29.040  41.135  1.00 70.59           N  
ATOM   4121  N   ALA E  58      74.830  35.121  41.704  1.00 40.07           N  
ATOM   4122  CA  ALA E  58      73.676  35.167  42.605  1.00 43.67           C  
ATOM   4123  C   ALA E  58      72.455  35.842  41.960  1.00 46.98           C  
ATOM   4124  O   ALA E  58      71.371  35.254  41.892  1.00 52.25           O  
ATOM   4125  CB  ALA E  58      74.058  35.904  43.893  1.00 40.93           C  
ATOM   4126  N   VAL E  59      72.636  37.077  41.503  1.00 33.75           N  
ATOM   4127  CA  VAL E  59      71.566  37.825  40.859  1.00 36.43           C  
ATOM   4128  C   VAL E  59      70.982  37.047  39.677  1.00 42.19           C  
ATOM   4129  O   VAL E  59      69.777  36.811  39.606  1.00 47.52           O  
ATOM   4130  CB  VAL E  59      72.084  39.195  40.347  1.00 40.63           C  
ATOM   4131  CG1 VAL E  59      71.000  39.915  39.579  1.00 37.38           C  
ATOM   4132  CG2 VAL E  59      72.545  40.049  41.513  1.00 37.74           C  
ATOM   4133  N   LEU E  60      71.837  36.649  38.745  1.00 43.93           N  
ATOM   4134  CA  LEU E  60      71.371  35.918  37.576  1.00 43.15           C  
ATOM   4135  C   LEU E  60      70.539  34.709  37.988  1.00 45.26           C  
ATOM   4136  O   LEU E  60      69.458  34.470  37.442  1.00 47.54           O  
ATOM   4137  CB  LEU E  60      72.563  35.479  36.718  1.00 46.99           C  
ATOM   4138  CG  LEU E  60      73.271  36.576  35.913  1.00 46.14           C  
ATOM   4139  CD1 LEU E  60      74.609  36.053  35.399  1.00 46.07           C  
ATOM   4140  CD2 LEU E  60      72.380  37.028  34.749  1.00 32.10           C  
ATOM   4141  N   GLU E  61      71.041  33.946  38.954  1.00 41.17           N  
ATOM   4142  CA  GLU E  61      70.318  32.775  39.426  1.00 47.63           C  
ATOM   4143  C   GLU E  61      68.928  33.133  39.960  1.00 54.01           C  
ATOM   4144  O   GLU E  61      67.933  32.502  39.579  1.00 59.94           O  
ATOM   4145  CB  GLU E  61      71.152  32.039  40.478  1.00 46.66           C  
ATOM   4146  CG  GLU E  61      72.191  31.119  39.842  1.00 65.78           C  
ATOM   4147  CD  GLU E  61      73.190  30.541  40.828  1.00 74.83           C  
ATOM   4148  OE1 GLU E  61      73.932  29.610  40.435  1.00 70.63           O  
ATOM   4149  OE2 GLU E  61      73.240  31.022  41.983  1.00 78.03           O  
ATOM   4150  N   ALA E  62      68.849  34.148  40.819  1.00 42.16           N  
ATOM   4151  CA  ALA E  62      67.559  34.576  41.359  1.00 45.57           C  
ATOM   4152  C   ALA E  62      66.618  35.047  40.245  1.00 46.02           C  
ATOM   4153  O   ALA E  62      65.400  35.094  40.423  1.00 46.60           O  
ATOM   4154  CB  ALA E  62      67.753  35.688  42.358  1.00 35.60           C  
ATOM   4155  N   ALA E  63      67.179  35.409  39.099  1.00 40.49           N  
ATOM   4156  CA  ALA E  63      66.361  35.864  37.987  1.00 39.89           C  
ATOM   4157  C   ALA E  63      65.890  34.680  37.153  1.00 49.19           C  
ATOM   4158  O   ALA E  63      65.172  34.858  36.163  1.00 48.25           O  
ATOM   4159  CB  ALA E  63      67.151  36.823  37.117  1.00 42.22           C  
ATOM   4160  N   GLY E  64      66.277  33.471  37.560  1.00 39.35           N  
ATOM   4161  CA  GLY E  64      65.894  32.300  36.799  1.00 41.03           C  
ATOM   4162  C   GLY E  64      66.742  32.202  35.541  1.00 46.55           C  
ATOM   4163  O   GLY E  64      66.281  31.754  34.497  1.00 44.63           O  
ATOM   4164  N   SER E  65      67.993  32.640  35.648  1.00 46.40           N  
ATOM   4165  CA  SER E  65      68.930  32.614  34.534  1.00 38.62           C  
ATOM   4166  C   SER E  65      70.261  32.111  35.093  1.00 44.60           C  
ATOM   4167  O   SER E  65      70.273  31.339  36.053  1.00 47.18           O  
ATOM   4168  CB  SER E  65      69.082  34.030  33.960  1.00 37.29           C  
ATOM   4169  OG  SER E  65      69.881  34.050  32.791  1.00 46.93           O  
ATOM   4170  N   GLY E  66      71.373  32.551  34.506  1.00 45.07           N  
ATOM   4171  CA  GLY E  66      72.684  32.129  34.977  1.00 30.13           C  
ATOM   4172  C   GLY E  66      73.833  32.703  34.165  1.00 39.84           C  
ATOM   4173  O   GLY E  66      73.617  33.428  33.190  1.00 38.97           O  
ATOM   4174  N   LEU E  67      75.061  32.381  34.562  1.00 37.24           N  
ATOM   4175  CA  LEU E  67      76.246  32.868  33.861  1.00 36.55           C  
ATOM   4176  C   LEU E  67      76.306  32.337  32.434  1.00 40.47           C  
ATOM   4177  O   LEU E  67      76.683  33.060  31.511  1.00 41.25           O  
ATOM   4178  CB  LEU E  67      77.516  32.454  34.610  1.00 24.00           C  
ATOM   4179  CG  LEU E  67      77.626  33.034  36.022  1.00 37.54           C  
ATOM   4180  CD1 LEU E  67      78.738  32.345  36.790  1.00 31.84           C  
ATOM   4181  CD2 LEU E  67      77.860  34.537  35.933  1.00 18.09           C  
ATOM   4182  N   SER E  68      75.924  31.076  32.255  1.00 39.96           N  
ATOM   4183  CA  SER E  68      75.961  30.461  30.934  1.00 40.62           C  
ATOM   4184  C   SER E  68      75.026  31.133  29.936  1.00 33.09           C  
ATOM   4185  O   SER E  68      75.197  30.987  28.735  1.00 36.89           O  
ATOM   4186  CB  SER E  68      75.626  28.969  31.023  1.00 28.99           C  
ATOM   4187  OG  SER E  68      74.294  28.756  31.463  1.00 38.27           O  
ATOM   4188  N   ARG E  69      74.046  31.878  30.426  1.00 31.74           N  
ATOM   4189  CA  ARG E  69      73.114  32.544  29.526  1.00 36.80           C  
ATOM   4190  C   ARG E  69      73.366  34.042  29.366  1.00 38.32           C  
ATOM   4191  O   ARG E  69      72.520  34.770  28.846  1.00 36.97           O  
ATOM   4192  CB  ARG E  69      71.680  32.295  29.984  1.00 43.27           C  
ATOM   4193  CG  ARG E  69      71.360  30.817  30.179  1.00 42.21           C  
ATOM   4194  CD  ARG E  69      70.195  30.383  29.313  1.00 53.48           C  
ATOM   4195  NE  ARG E  69      70.602  29.984  27.971  1.00 67.57           N  
ATOM   4196  CZ  ARG E  69      69.762  29.874  26.946  1.00 81.15           C  
ATOM   4197  NH1 ARG E  69      68.471  30.143  27.119  1.00 79.06           N  
ATOM   4198  NH2 ARG E  69      70.207  29.486  25.755  1.00 79.92           N  
ATOM   4199  N   VAL E  70      74.535  34.500  29.804  1.00 35.39           N  
ATOM   4200  CA  VAL E  70      74.883  35.902  29.679  1.00 37.04           C  
ATOM   4201  C   VAL E  70      75.302  36.152  28.235  1.00 40.69           C  
ATOM   4202  O   VAL E  70      76.121  35.418  27.695  1.00 37.41           O  
ATOM   4203  CB  VAL E  70      76.037  36.270  30.631  1.00 47.09           C  
ATOM   4204  CG1 VAL E  70      76.566  37.672  30.301  1.00 34.77           C  
ATOM   4205  CG2 VAL E  70      75.543  36.218  32.073  1.00 27.71           C  
ATOM   4206  N   VAL E  71      74.741  37.185  27.610  1.00 34.46           N  
ATOM   4207  CA  VAL E  71      75.063  37.484  26.223  1.00 29.77           C  
ATOM   4208  C   VAL E  71      75.929  38.725  26.053  1.00 34.80           C  
ATOM   4209  O   VAL E  71      76.511  38.944  24.994  1.00 38.11           O  
ATOM   4210  CB  VAL E  71      73.772  37.640  25.389  1.00 31.30           C  
ATOM   4211  CG1 VAL E  71      73.039  36.313  25.347  1.00 39.35           C  
ATOM   4212  CG2 VAL E  71      72.864  38.704  25.998  1.00 38.38           C  
ATOM   4213  N   GLN E  72      76.044  39.524  27.106  1.00 30.73           N  
ATOM   4214  CA  GLN E  72      76.829  40.740  27.015  1.00 37.01           C  
ATOM   4215  C   GLN E  72      77.268  41.242  28.384  1.00 43.32           C  
ATOM   4216  O   GLN E  72      76.529  41.142  29.359  1.00 46.38           O  
ATOM   4217  CB  GLN E  72      75.996  41.813  26.315  1.00 27.02           C  
ATOM   4218  CG  GLN E  72      76.655  43.160  26.179  1.00 42.03           C  
ATOM   4219  CD  GLN E  72      75.640  44.287  26.033  1.00 48.97           C  
ATOM   4220  OE1 GLN E  72      74.868  44.561  26.953  1.00 52.16           O  
ATOM   4221  NE2 GLN E  72      75.629  44.939  24.874  1.00 37.11           N  
ATOM   4222  N   THR E  73      78.476  41.783  28.449  1.00 36.24           N  
ATOM   4223  CA  THR E  73      78.997  42.330  29.689  1.00 25.46           C  
ATOM   4224  C   THR E  73      79.725  43.626  29.370  1.00 39.49           C  
ATOM   4225  O   THR E  73      80.394  43.742  28.336  1.00 35.74           O  
ATOM   4226  CB  THR E  73      80.023  41.396  30.383  1.00 28.52           C  
ATOM   4227  OG1 THR E  73      81.136  41.183  29.510  1.00 27.72           O  
ATOM   4228  CG2 THR E  73      79.395  40.058  30.776  1.00 21.75           C  
ATOM   4229  N   THR E  74      79.574  44.604  30.256  1.00 32.94           N  
ATOM   4230  CA  THR E  74      80.250  45.880  30.108  1.00 34.80           C  
ATOM   4231  C   THR E  74      81.187  45.898  31.321  1.00 30.99           C  
ATOM   4232  O   THR E  74      80.742  45.959  32.465  1.00 40.34           O  
ATOM   4233  CB  THR E  74      79.233  47.053  30.146  1.00 43.76           C  
ATOM   4234  OG1 THR E  74      78.214  46.820  29.169  1.00 41.92           O  
ATOM   4235  CG2 THR E  74      79.908  48.377  29.802  1.00 41.45           C  
ATOM   4236  N   CYS E  75      82.486  45.810  31.071  1.00 34.65           N  
ATOM   4237  CA  CYS E  75      83.459  45.760  32.153  1.00 35.49           C  
ATOM   4238  C   CYS E  75      84.241  47.062  32.348  1.00 38.28           C  
ATOM   4239  O   CYS E  75      84.925  47.539  31.441  1.00 40.51           O  
ATOM   4240  CB  CYS E  75      84.406  44.587  31.902  1.00 35.11           C  
ATOM   4241  SG  CYS E  75      83.534  43.006  31.607  1.00 43.57           S  
ATOM   4242  N   PHE E  76      84.127  47.635  33.539  1.00 33.47           N  
ATOM   4243  CA  PHE E  76      84.814  48.880  33.854  1.00 38.75           C  
ATOM   4244  C   PHE E  76      85.900  48.640  34.910  1.00 43.95           C  
ATOM   4245  O   PHE E  76      85.626  48.125  35.997  1.00 49.49           O  
ATOM   4246  CB  PHE E  76      83.823  49.929  34.380  1.00 31.41           C  
ATOM   4247  CG  PHE E  76      82.640  50.181  33.472  1.00 38.57           C  
ATOM   4248  CD1 PHE E  76      81.432  49.513  33.672  1.00 36.50           C  
ATOM   4249  CD2 PHE E  76      82.727  51.104  32.436  1.00 36.68           C  
ATOM   4250  CE1 PHE E  76      80.326  49.765  32.857  1.00 38.29           C  
ATOM   4251  CE2 PHE E  76      81.627  51.368  31.607  1.00 43.61           C  
ATOM   4252  CZ  PHE E  76      80.426  50.698  31.818  1.00 43.24           C  
ATOM   4253  N   LEU E  77      87.130  49.021  34.583  1.00 39.99           N  
ATOM   4254  CA  LEU E  77      88.250  48.860  35.498  1.00 33.21           C  
ATOM   4255  C   LEU E  77      88.745  50.250  35.886  1.00 46.89           C  
ATOM   4256  O   LEU E  77      88.521  51.220  35.156  1.00 53.31           O  
ATOM   4257  CB  LEU E  77      89.385  48.093  34.814  1.00 30.24           C  
ATOM   4258  CG  LEU E  77      89.098  46.680  34.294  1.00 40.95           C  
ATOM   4259  CD1 LEU E  77      90.262  46.198  33.448  1.00 40.66           C  
ATOM   4260  CD2 LEU E  77      88.849  45.733  35.468  1.00 31.22           C  
ATOM   4261  N   ALA E  78      89.410  50.349  37.032  1.00 40.47           N  
ATOM   4262  CA  ALA E  78      89.941  51.632  37.476  1.00 46.25           C  
ATOM   4263  C   ALA E  78      91.367  51.814  36.971  1.00 42.51           C  
ATOM   4264  O   ALA E  78      91.979  52.854  37.197  1.00 51.54           O  
ATOM   4265  CB  ALA E  78      89.909  51.718  39.004  1.00 36.20           C  
ATOM   4266  N   ASP E  79      91.886  50.809  36.273  1.00 45.41           N  
ATOM   4267  CA  ASP E  79      93.253  50.858  35.761  1.00 51.40           C  
ATOM   4268  C   ASP E  79      93.497  49.648  34.856  1.00 52.21           C  
ATOM   4269  O   ASP E  79      93.432  48.503  35.320  1.00 51.97           O  
ATOM   4270  CB  ASP E  79      94.223  50.858  36.953  1.00 57.89           C  
ATOM   4271  CG  ASP E  79      95.687  50.868  36.538  1.00 74.08           C  
ATOM   4272  OD1 ASP E  79      95.990  51.166  35.360  1.00 71.85           O  
ATOM   4273  OD2 ASP E  79      96.540  50.588  37.411  1.00 81.95           O  
HETATM 4274  N   MSE E  80      93.773  49.890  33.573  1.00 36.80           N  
HETATM 4275  CA  MSE E  80      94.000  48.781  32.638  1.00 44.68           C  
HETATM 4276  C   MSE E  80      95.106  47.809  33.056  1.00 48.81           C  
HETATM 4277  O   MSE E  80      95.213  46.711  32.509  1.00 53.61           O  
HETATM 4278  CB  MSE E  80      94.305  49.303  31.233  1.00 35.93           C  
HETATM 4279  CG  MSE E  80      93.091  49.816  30.454  1.00 54.11           C  
HETATM 4280 SE   MSE E  80      91.788  48.448  29.932  0.77 67.12          SE  
HETATM 4281  CE  MSE E  80      92.975  47.029  29.419  0.77 51.37           C  
ATOM   4282  N   GLU E  81      95.931  48.206  34.016  1.00 53.92           N  
ATOM   4283  CA  GLU E  81      97.004  47.336  34.488  1.00 61.17           C  
ATOM   4284  C   GLU E  81      96.430  46.081  35.130  1.00 58.38           C  
ATOM   4285  O   GLU E  81      97.063  45.027  35.136  1.00 59.64           O  
ATOM   4286  CB  GLU E  81      97.876  48.062  35.515  1.00 61.49           C  
ATOM   4287  CG  GLU E  81      99.187  48.592  34.970  1.00 71.71           C  
ATOM   4288  CD  GLU E  81     100.091  49.100  36.077  1.00 93.19           C  
ATOM   4289  OE1 GLU E  81      99.853  50.221  36.579  1.00 89.17           O  
ATOM   4290  OE2 GLU E  81     101.031  48.365  36.455  1.00100.08           O  
ATOM   4291  N   ASP E  82      95.227  46.202  35.675  1.00 56.89           N  
ATOM   4292  CA  ASP E  82      94.575  45.079  36.328  1.00 50.84           C  
ATOM   4293  C   ASP E  82      93.892  44.123  35.366  1.00 47.06           C  
ATOM   4294  O   ASP E  82      93.380  43.092  35.803  1.00 46.58           O  
ATOM   4295  CB  ASP E  82      93.528  45.572  37.329  1.00 54.17           C  
ATOM   4296  CG  ASP E  82      94.128  46.393  38.438  1.00 55.24           C  
ATOM   4297  OD1 ASP E  82      95.333  46.213  38.705  1.00 65.32           O  
ATOM   4298  OD2 ASP E  82      93.400  47.203  39.053  1.00 54.80           O  
ATOM   4299  N   PHE E  83      93.886  44.442  34.070  1.00 45.71           N  
ATOM   4300  CA  PHE E  83      93.207  43.584  33.100  1.00 42.16           C  
ATOM   4301  C   PHE E  83      93.565  42.102  33.156  1.00 45.36           C  
ATOM   4302  O   PHE E  83      92.677  41.250  33.157  1.00 52.79           O  
ATOM   4303  CB  PHE E  83      93.413  44.070  31.666  1.00 41.30           C  
ATOM   4304  CG  PHE E  83      92.596  43.304  30.670  1.00 45.97           C  
ATOM   4305  CD1 PHE E  83      91.234  43.552  30.537  1.00 51.48           C  
ATOM   4306  CD2 PHE E  83      93.162  42.260  29.938  1.00 51.54           C  
ATOM   4307  CE1 PHE E  83      90.441  42.766  29.696  1.00 51.26           C  
ATOM   4308  CE2 PHE E  83      92.380  41.464  29.093  1.00 44.85           C  
ATOM   4309  CZ  PHE E  83      91.016  41.719  28.974  1.00 60.56           C  
ATOM   4310  N   PRO E  84      94.867  41.770  33.182  1.00 48.05           N  
ATOM   4311  CA  PRO E  84      95.272  40.361  33.236  1.00 45.76           C  
ATOM   4312  C   PRO E  84      94.595  39.604  34.366  1.00 44.64           C  
ATOM   4313  O   PRO E  84      94.013  38.547  34.147  1.00 45.26           O  
ATOM   4314  CB  PRO E  84      96.780  40.446  33.422  1.00 43.19           C  
ATOM   4315  CG  PRO E  84      97.127  41.682  32.637  1.00 47.20           C  
ATOM   4316  CD  PRO E  84      96.046  42.648  33.070  1.00 41.78           C  
ATOM   4317  N   GLY E  85      94.671  40.155  35.573  1.00 48.68           N  
ATOM   4318  CA  GLY E  85      94.057  39.516  36.726  1.00 50.75           C  
ATOM   4319  C   GLY E  85      92.548  39.471  36.618  1.00 51.42           C  
ATOM   4320  O   GLY E  85      91.907  38.481  36.987  1.00 49.81           O  
ATOM   4321  N   PHE E  86      91.971  40.556  36.121  1.00 43.10           N  
ATOM   4322  CA  PHE E  86      90.532  40.617  35.948  1.00 44.11           C  
ATOM   4323  C   PHE E  86      90.099  39.523  34.968  1.00 46.28           C  
ATOM   4324  O   PHE E  86      89.206  38.722  35.264  1.00 42.02           O  
ATOM   4325  CB  PHE E  86      90.124  41.994  35.409  1.00 40.82           C  
ATOM   4326  CG  PHE E  86      88.709  42.052  34.898  1.00 35.12           C  
ATOM   4327  CD1 PHE E  86      88.451  42.071  33.530  1.00 31.71           C  
ATOM   4328  CD2 PHE E  86      87.636  42.070  35.783  1.00 31.51           C  
ATOM   4329  CE1 PHE E  86      87.142  42.109  33.053  1.00 37.26           C  
ATOM   4330  CE2 PHE E  86      86.323  42.107  35.312  1.00 39.08           C  
ATOM   4331  CZ  PHE E  86      86.079  42.126  33.945  1.00 37.48           C  
ATOM   4332  N   ASN E  87      90.751  39.489  33.809  1.00 39.85           N  
ATOM   4333  CA  ASN E  87      90.431  38.523  32.770  1.00 41.80           C  
ATOM   4334  C   ASN E  87      90.594  37.080  33.248  1.00 44.61           C  
ATOM   4335  O   ASN E  87      89.787  36.216  32.910  1.00 47.96           O  
ATOM   4336  CB  ASN E  87      91.306  38.789  31.539  1.00 39.21           C  
ATOM   4337  CG  ASN E  87      90.691  38.258  30.255  1.00 40.99           C  
ATOM   4338  OD1 ASN E  87      89.492  38.404  30.021  1.00 49.67           O  
ATOM   4339  ND2 ASN E  87      91.515  37.657  29.408  1.00 46.96           N  
ATOM   4340  N   GLU E  88      91.631  36.824  34.041  1.00 39.37           N  
ATOM   4341  CA  GLU E  88      91.887  35.487  34.562  1.00 43.72           C  
ATOM   4342  C   GLU E  88      90.711  34.982  35.397  1.00 40.94           C  
ATOM   4343  O   GLU E  88      90.276  33.841  35.245  1.00 47.49           O  
ATOM   4344  CB  GLU E  88      93.162  35.480  35.417  1.00 48.02           C  
ATOM   4345  CG  GLU E  88      93.489  34.120  36.031  1.00 52.06           C  
ATOM   4346  CD  GLU E  88      94.647  34.171  37.021  1.00 66.71           C  
ATOM   4347  OE1 GLU E  88      95.795  34.444  36.601  1.00 48.38           O  
ATOM   4348  OE2 GLU E  88      94.405  33.936  38.225  1.00 70.71           O  
ATOM   4349  N   VAL E  89      90.197  35.834  36.276  1.00 33.15           N  
ATOM   4350  CA  VAL E  89      89.076  35.458  37.128  1.00 43.41           C  
ATOM   4351  C   VAL E  89      87.805  35.380  36.286  1.00 47.23           C  
ATOM   4352  O   VAL E  89      87.035  34.426  36.394  1.00 45.89           O  
ATOM   4353  CB  VAL E  89      88.894  36.477  38.297  1.00 41.86           C  
ATOM   4354  CG1 VAL E  89      87.667  36.139  39.121  1.00 32.06           C  
ATOM   4355  CG2 VAL E  89      90.118  36.452  39.194  1.00 40.97           C  
ATOM   4356  N   TYR E  90      87.612  36.380  35.434  1.00 50.56           N  
ATOM   4357  CA  TYR E  90      86.449  36.453  34.547  1.00 48.08           C  
ATOM   4358  C   TYR E  90      86.245  35.152  33.765  1.00 42.97           C  
ATOM   4359  O   TYR E  90      85.130  34.636  33.685  1.00 38.99           O  
ATOM   4360  CB  TYR E  90      86.637  37.606  33.562  1.00 49.81           C  
ATOM   4361  CG  TYR E  90      85.465  37.882  32.649  1.00 47.64           C  
ATOM   4362  CD1 TYR E  90      84.511  38.844  32.980  1.00 39.56           C  
ATOM   4363  CD2 TYR E  90      85.342  37.226  31.424  1.00 43.27           C  
ATOM   4364  CE1 TYR E  90      83.475  39.156  32.111  1.00 42.98           C  
ATOM   4365  CE2 TYR E  90      84.307  37.531  30.547  1.00 40.17           C  
ATOM   4366  CZ  TYR E  90      83.381  38.498  30.897  1.00 42.51           C  
ATOM   4367  OH  TYR E  90      82.371  38.827  30.029  1.00 45.23           O  
ATOM   4368  N   ALA E  91      87.325  34.630  33.193  1.00 29.35           N  
ATOM   4369  CA  ALA E  91      87.261  33.391  32.415  1.00 35.38           C  
ATOM   4370  C   ALA E  91      86.772  32.187  33.213  1.00 32.87           C  
ATOM   4371  O   ALA E  91      86.281  31.222  32.634  1.00 45.51           O  
ATOM   4372  CB  ALA E  91      88.622  33.075  31.824  1.00 29.33           C  
ATOM   4373  N   ARG E  92      86.898  32.230  34.535  1.00 33.67           N  
ATOM   4374  CA  ARG E  92      86.463  31.102  35.355  1.00 33.28           C  
ATOM   4375  C   ARG E  92      84.959  30.924  35.339  1.00 39.36           C  
ATOM   4376  O   ARG E  92      84.466  29.795  35.309  1.00 45.94           O  
ATOM   4377  CB  ARG E  92      86.898  31.273  36.816  1.00 38.36           C  
ATOM   4378  CG  ARG E  92      88.395  31.346  37.060  1.00 53.15           C  
ATOM   4379  CD  ARG E  92      88.669  31.616  38.539  1.00 49.66           C  
ATOM   4380  NE  ARG E  92      90.051  32.023  38.791  1.00 54.15           N  
ATOM   4381  CZ  ARG E  92      90.467  32.567  39.931  1.00 55.30           C  
ATOM   4382  NH1 ARG E  92      89.604  32.766  40.922  1.00 40.79           N  
ATOM   4383  NH2 ARG E  92      91.737  32.924  40.079  1.00 47.06           N  
ATOM   4384  N   TYR E  93      84.236  32.042  35.351  1.00 36.67           N  
ATOM   4385  CA  TYR E  93      82.781  32.021  35.405  1.00 32.45           C  
ATOM   4386  C   TYR E  93      81.990  31.964  34.113  1.00 32.79           C  
ATOM   4387  O   TYR E  93      80.799  31.673  34.136  1.00 35.75           O  
ATOM   4388  CB  TYR E  93      82.293  33.200  36.243  1.00 36.70           C  
ATOM   4389  CG  TYR E  93      82.862  33.183  37.634  1.00 40.53           C  
ATOM   4390  CD1 TYR E  93      84.150  33.656  37.885  1.00 37.36           C  
ATOM   4391  CD2 TYR E  93      82.137  32.641  38.697  1.00 38.39           C  
ATOM   4392  CE1 TYR E  93      84.711  33.588  39.161  1.00 46.64           C  
ATOM   4393  CE2 TYR E  93      82.687  32.567  39.982  1.00 42.67           C  
ATOM   4394  CZ  TYR E  93      83.976  33.044  40.203  1.00 51.15           C  
ATOM   4395  OH  TYR E  93      84.539  32.975  41.454  1.00 43.53           O  
ATOM   4396  N   PHE E  94      82.623  32.232  32.985  1.00 35.65           N  
ATOM   4397  CA  PHE E  94      81.881  32.183  31.740  1.00 35.89           C  
ATOM   4398  C   PHE E  94      82.234  30.964  30.893  1.00 40.49           C  
ATOM   4399  O   PHE E  94      83.330  30.405  31.011  1.00 42.46           O  
ATOM   4400  CB  PHE E  94      82.070  33.500  30.991  1.00 30.42           C  
ATOM   4401  CG  PHE E  94      81.510  34.674  31.737  1.00 45.75           C  
ATOM   4402  CD1 PHE E  94      82.333  35.465  32.529  1.00 51.09           C  
ATOM   4403  CD2 PHE E  94      80.144  34.954  31.700  1.00 34.93           C  
ATOM   4404  CE1 PHE E  94      81.812  36.514  33.272  1.00 45.34           C  
ATOM   4405  CE2 PHE E  94      79.613  35.999  32.439  1.00 31.21           C  
ATOM   4406  CZ  PHE E  94      80.449  36.781  33.227  1.00 41.22           C  
ATOM   4407  N   THR E  95      81.291  30.559  30.045  1.00 43.40           N  
ATOM   4408  CA  THR E  95      81.445  29.388  29.195  1.00 42.35           C  
ATOM   4409  C   THR E  95      81.034  29.620  27.729  1.00 47.24           C  
ATOM   4410  O   THR E  95      80.231  30.504  27.426  1.00 57.34           O  
ATOM   4411  CB  THR E  95      80.613  28.242  29.782  1.00 41.97           C  
ATOM   4412  OG1 THR E  95      81.235  27.798  30.988  1.00 60.13           O  
ATOM   4413  CG2 THR E  95      80.509  27.074  28.812  1.00 71.72           C  
ATOM   4414  N   PRO E  96      81.606  28.839  26.799  1.00 40.87           N  
ATOM   4415  CA  PRO E  96      81.278  28.970  25.373  1.00 44.21           C  
ATOM   4416  C   PRO E  96      79.799  28.643  25.124  1.00 50.44           C  
ATOM   4417  O   PRO E  96      79.298  27.624  25.604  1.00 58.07           O  
ATOM   4418  CB  PRO E  96      82.214  27.959  24.716  1.00 47.62           C  
ATOM   4419  CG  PRO E  96      83.423  27.992  25.615  1.00 48.15           C  
ATOM   4420  CD  PRO E  96      82.798  27.991  26.993  1.00 41.62           C  
ATOM   4421  N   PRO E  97      79.081  29.492  24.365  1.00 45.67           N  
ATOM   4422  CA  PRO E  97      79.505  30.739  23.715  1.00 42.87           C  
ATOM   4423  C   PRO E  97      79.703  31.850  24.738  1.00 44.15           C  
ATOM   4424  O   PRO E  97      78.778  32.186  25.479  1.00 38.99           O  
ATOM   4425  CB  PRO E  97      78.345  31.053  22.769  1.00 48.75           C  
ATOM   4426  CG  PRO E  97      77.582  29.750  22.667  1.00 49.52           C  
ATOM   4427  CD  PRO E  97      77.678  29.204  24.042  1.00 42.91           C  
ATOM   4428  N   TYR E  98      80.909  32.408  24.771  1.00 44.05           N  
ATOM   4429  CA  TYR E  98      81.245  33.471  25.702  1.00 43.28           C  
ATOM   4430  C   TYR E  98      80.430  34.715  25.396  1.00 44.21           C  
ATOM   4431  O   TYR E  98      80.033  34.935  24.259  1.00 50.84           O  
ATOM   4432  CB  TYR E  98      82.731  33.811  25.619  1.00 33.71           C  
ATOM   4433  CG  TYR E  98      83.648  32.746  26.165  1.00 46.52           C  
ATOM   4434  CD1 TYR E  98      84.585  32.131  25.335  1.00 38.89           C  
ATOM   4435  CD2 TYR E  98      83.594  32.361  27.513  1.00 45.61           C  
ATOM   4436  CE1 TYR E  98      85.450  31.162  25.821  1.00 38.14           C  
ATOM   4437  CE2 TYR E  98      84.456  31.384  28.015  1.00 30.34           C  
ATOM   4438  CZ  TYR E  98      85.384  30.794  27.156  1.00 45.78           C  
ATOM   4439  OH  TYR E  98      86.268  29.855  27.622  1.00 50.20           O  
ATOM   4440  N   PRO E  99      80.171  35.548  26.415  1.00 35.82           N  
ATOM   4441  CA  PRO E  99      79.395  36.770  26.215  1.00 27.28           C  
ATOM   4442  C   PRO E  99      80.152  37.735  25.315  1.00 29.48           C  
ATOM   4443  O   PRO E  99      81.360  37.622  25.166  1.00 33.45           O  
ATOM   4444  CB  PRO E  99      79.263  37.329  27.629  1.00 34.63           C  
ATOM   4445  CG  PRO E  99      79.408  36.120  28.512  1.00 34.51           C  
ATOM   4446  CD  PRO E  99      80.532  35.396  27.835  1.00 36.44           C  
ATOM   4447  N   ALA E 100      79.439  38.658  24.681  1.00 29.38           N  
ATOM   4448  CA  ALA E 100      80.113  39.654  23.873  1.00 34.75           C  
ATOM   4449  C   ALA E 100      80.676  40.525  24.988  1.00 34.14           C  
ATOM   4450  O   ALA E 100      80.149  40.499  26.097  1.00 40.09           O  
ATOM   4451  CB  ALA E 100      79.115  40.420  23.034  1.00 28.43           C  
ATOM   4452  N   ARG E 101      81.729  41.286  24.734  1.00 35.23           N  
ATOM   4453  CA  ARG E 101      82.287  42.076  25.821  1.00 29.78           C  
ATOM   4454  C   ARG E 101      82.909  43.399  25.412  1.00 36.36           C  
ATOM   4455  O   ARG E 101      83.435  43.536  24.308  1.00 37.11           O  
ATOM   4456  CB  ARG E 101      83.334  41.238  26.568  1.00 29.94           C  
ATOM   4457  CG  ARG E 101      83.917  41.896  27.803  1.00 33.68           C  
ATOM   4458  CD  ARG E 101      84.897  40.986  28.537  1.00 32.37           C  
ATOM   4459  NE  ARG E 101      86.146  40.781  27.805  1.00 44.14           N  
ATOM   4460  CZ  ARG E 101      87.134  39.986  28.214  1.00 47.01           C  
ATOM   4461  NH1 ARG E 101      87.023  39.314  29.351  1.00 41.39           N  
ATOM   4462  NH2 ARG E 101      88.237  39.862  27.490  1.00 52.81           N  
ATOM   4463  N   ALA E 102      82.821  44.366  26.324  1.00 29.02           N  
ATOM   4464  CA  ALA E 102      83.400  45.693  26.154  1.00 31.26           C  
ATOM   4465  C   ALA E 102      84.154  45.989  27.461  1.00 36.00           C  
ATOM   4466  O   ALA E 102      83.583  45.923  28.550  1.00 37.64           O  
ATOM   4467  CB  ALA E 102      82.311  46.736  25.920  1.00 32.68           C  
ATOM   4468  N   THR E 103      85.441  46.301  27.353  1.00 43.43           N  
ATOM   4469  CA  THR E 103      86.252  46.580  28.531  1.00 33.92           C  
ATOM   4470  C   THR E 103      86.903  47.946  28.405  1.00 35.68           C  
ATOM   4471  O   THR E 103      87.400  48.302  27.338  1.00 35.55           O  
ATOM   4472  CB  THR E 103      87.362  45.508  28.704  1.00 48.93           C  
ATOM   4473  OG1 THR E 103      86.771  44.202  28.685  1.00 51.35           O  
ATOM   4474  CG2 THR E 103      88.104  45.699  30.025  1.00 29.29           C  
ATOM   4475  N   VAL E 104      86.903  48.706  29.497  1.00 33.12           N  
ATOM   4476  CA  VAL E 104      87.508  50.035  29.507  1.00 38.81           C  
ATOM   4477  C   VAL E 104      87.948  50.429  30.915  1.00 42.44           C  
ATOM   4478  O   VAL E 104      87.457  49.887  31.911  1.00 35.37           O  
ATOM   4479  CB  VAL E 104      86.520  51.128  29.009  1.00 40.28           C  
ATOM   4480  CG1 VAL E 104      85.968  50.768  27.645  1.00 54.44           C  
ATOM   4481  CG2 VAL E 104      85.388  51.304  30.011  1.00 45.30           C  
ATOM   4482  N   ALA E 105      88.878  51.375  30.991  1.00 39.02           N  
ATOM   4483  CA  ALA E 105      89.346  51.870  32.277  1.00 37.19           C  
ATOM   4484  C   ALA E 105      88.743  53.258  32.410  1.00 33.66           C  
ATOM   4485  O   ALA E 105      88.851  54.082  31.509  1.00 50.16           O  
ATOM   4486  CB  ALA E 105      90.863  51.947  32.309  1.00 36.28           C  
ATOM   4487  N   VAL E 106      88.087  53.510  33.530  1.00 45.01           N  
ATOM   4488  CA  VAL E 106      87.462  54.801  33.758  1.00 39.05           C  
ATOM   4489  C   VAL E 106      88.217  55.564  34.838  1.00 40.18           C  
ATOM   4490  O   VAL E 106      89.170  55.046  35.417  1.00 39.95           O  
ATOM   4491  CB  VAL E 106      86.006  54.612  34.186  1.00 39.59           C  
ATOM   4492  CG1 VAL E 106      85.258  53.872  33.104  1.00 38.13           C  
ATOM   4493  CG2 VAL E 106      85.940  53.823  35.492  1.00 28.81           C  
ATOM   4494  N   LYS E 107      87.784  56.793  35.103  1.00 42.61           N  
ATOM   4495  CA  LYS E 107      88.412  57.642  36.107  1.00 44.21           C  
ATOM   4496  C   LYS E 107      88.248  57.058  37.501  1.00 44.53           C  
ATOM   4497  O   LYS E 107      89.224  56.854  38.210  1.00 51.38           O  
ATOM   4498  CB  LYS E 107      87.793  59.037  36.067  1.00 52.83           C  
ATOM   4499  CG  LYS E 107      88.555  60.084  36.864  1.00 47.92           C  
ATOM   4500  CD  LYS E 107      87.880  61.435  36.719  1.00 58.35           C  
ATOM   4501  CE  LYS E 107      88.760  62.572  37.207  1.00 59.38           C  
ATOM   4502  NZ  LYS E 107      88.064  63.874  37.007  1.00 57.11           N  
ATOM   4503  N   ALA E 108      87.006  56.790  37.889  1.00 44.82           N  
ATOM   4504  CA  ALA E 108      86.723  56.222  39.200  1.00 44.87           C  
ATOM   4505  C   ALA E 108      85.439  55.390  39.210  1.00 44.16           C  
ATOM   4506  O   ALA E 108      84.574  55.530  38.343  1.00 39.18           O  
ATOM   4507  CB  ALA E 108      86.624  57.329  40.232  1.00 26.96           C  
ATOM   4508  N   LEU E 109      85.325  54.527  40.212  1.00 47.26           N  
ATOM   4509  CA  LEU E 109      84.162  53.668  40.362  1.00 45.35           C  
ATOM   4510  C   LEU E 109      83.497  53.878  41.711  1.00 49.61           C  
ATOM   4511  O   LEU E 109      84.101  54.444  42.628  1.00 46.46           O  
ATOM   4512  CB  LEU E 109      84.587  52.213  40.233  1.00 33.32           C  
ATOM   4513  CG  LEU E 109      85.030  51.859  38.826  1.00 34.43           C  
ATOM   4514  CD1 LEU E 109      85.612  50.465  38.818  1.00 25.31           C  
ATOM   4515  CD2 LEU E 109      83.831  51.978  37.889  1.00 32.72           C  
ATOM   4516  N   PRO E 110      82.236  53.433  41.848  1.00 51.27           N  
ATOM   4517  CA  PRO E 110      81.522  53.591  43.116  1.00 48.65           C  
ATOM   4518  C   PRO E 110      82.396  53.141  44.273  1.00 47.68           C  
ATOM   4519  O   PRO E 110      83.113  52.150  44.168  1.00 49.99           O  
ATOM   4520  CB  PRO E 110      80.291  52.715  42.921  1.00 48.37           C  
ATOM   4521  CG  PRO E 110      79.982  52.938  41.480  1.00 46.58           C  
ATOM   4522  CD  PRO E 110      81.355  52.837  40.826  1.00 49.02           C  
ATOM   4523  N   ARG E 111      82.357  53.897  45.360  1.00 51.03           N  
ATOM   4524  CA  ARG E 111      83.147  53.595  46.544  1.00 53.89           C  
ATOM   4525  C   ARG E 111      84.598  53.190  46.291  1.00 49.73           C  
ATOM   4526  O   ARG E 111      85.143  52.350  46.998  1.00 55.32           O  
ATOM   4527  CB  ARG E 111      82.434  52.533  47.384  1.00 58.25           C  
ATOM   4528  CG  ARG E 111      81.115  53.037  47.966  1.00 70.55           C  
ATOM   4529  CD  ARG E 111      80.460  51.994  48.840  1.00 70.84           C  
ATOM   4530  NE  ARG E 111      81.394  51.493  49.842  1.00 79.90           N  
ATOM   4531  CZ  ARG E 111      81.097  50.557  50.737  1.00 84.92           C  
ATOM   4532  NH1 ARG E 111      79.883  50.022  50.758  1.00 84.25           N  
ATOM   4533  NH2 ARG E 111      82.021  50.143  51.595  1.00 76.15           N  
ATOM   4534  N   GLY E 112      85.206  53.792  45.273  1.00 47.51           N  
ATOM   4535  CA  GLY E 112      86.603  53.542  44.948  1.00 41.89           C  
ATOM   4536  C   GLY E 112      87.111  52.157  44.574  1.00 51.44           C  
ATOM   4537  O   GLY E 112      88.330  51.948  44.539  1.00 41.36           O  
ATOM   4538  N   VAL E 113      86.217  51.212  44.290  1.00 44.91           N  
ATOM   4539  CA  VAL E 113      86.659  49.869  43.926  1.00 40.64           C  
ATOM   4540  C   VAL E 113      87.367  49.871  42.571  1.00 39.54           C  
ATOM   4541  O   VAL E 113      87.302  50.846  41.833  1.00 45.90           O  
ATOM   4542  CB  VAL E 113      85.480  48.902  43.876  1.00 40.00           C  
ATOM   4543  CG1 VAL E 113      84.775  48.896  45.229  1.00 26.54           C  
ATOM   4544  CG2 VAL E 113      84.528  49.306  42.753  1.00 24.33           C  
ATOM   4545  N   ARG E 114      88.034  48.775  42.239  1.00 33.43           N  
ATOM   4546  CA  ARG E 114      88.766  48.691  40.974  1.00 48.41           C  
ATOM   4547  C   ARG E 114      88.049  48.006  39.815  1.00 42.92           C  
ATOM   4548  O   ARG E 114      88.556  47.990  38.698  1.00 43.62           O  
ATOM   4549  CB  ARG E 114      90.113  48.004  41.205  1.00 46.26           C  
ATOM   4550  CG  ARG E 114      90.085  47.029  42.353  1.00 56.80           C  
ATOM   4551  CD  ARG E 114      91.467  46.499  42.664  1.00 68.90           C  
ATOM   4552  NE  ARG E 114      92.503  47.504  42.450  1.00 69.30           N  
ATOM   4553  CZ  ARG E 114      93.721  47.431  42.968  1.00 68.70           C  
ATOM   4554  NH1 ARG E 114      94.050  46.404  43.740  1.00 68.39           N  
ATOM   4555  NH2 ARG E 114      94.615  48.371  42.695  1.00 66.45           N  
ATOM   4556  N   VAL E 115      86.875  47.444  40.070  1.00 44.33           N  
ATOM   4557  CA  VAL E 115      86.144  46.771  39.009  1.00 38.54           C  
ATOM   4558  C   VAL E 115      84.641  46.800  39.222  1.00 37.09           C  
ATOM   4559  O   VAL E 115      84.162  46.672  40.341  1.00 45.63           O  
ATOM   4560  CB  VAL E 115      86.593  45.294  38.883  1.00 37.23           C  
ATOM   4561  CG1 VAL E 115      86.366  44.563  40.208  1.00 34.66           C  
ATOM   4562  CG2 VAL E 115      85.831  44.608  37.762  1.00 45.21           C  
ATOM   4563  N   GLU E 116      83.908  46.977  38.128  1.00 41.25           N  
ATOM   4564  CA  GLU E 116      82.450  46.988  38.139  1.00 31.54           C  
ATOM   4565  C   GLU E 116      82.018  46.328  36.840  1.00 39.58           C  
ATOM   4566  O   GLU E 116      82.524  46.678  35.770  1.00 42.08           O  
ATOM   4567  CB  GLU E 116      81.906  48.410  38.171  1.00 33.34           C  
ATOM   4568  CG  GLU E 116      80.384  48.474  38.145  1.00 40.73           C  
ATOM   4569  CD  GLU E 116      79.861  49.886  37.975  1.00 44.19           C  
ATOM   4570  OE1 GLU E 116      80.651  50.833  38.160  1.00 52.66           O  
ATOM   4571  OE2 GLU E 116      78.663  50.056  37.666  1.00 46.25           O  
ATOM   4572  N   VAL E 117      81.098  45.376  36.925  1.00 34.74           N  
ATOM   4573  CA  VAL E 117      80.631  44.691  35.729  1.00 32.13           C  
ATOM   4574  C   VAL E 117      79.117  44.611  35.651  1.00 35.68           C  
ATOM   4575  O   VAL E 117      78.453  44.219  36.609  1.00 38.77           O  
ATOM   4576  CB  VAL E 117      81.195  43.249  35.635  1.00 34.61           C  
ATOM   4577  CG1 VAL E 117      80.598  42.530  34.429  1.00 29.60           C  
ATOM   4578  CG2 VAL E 117      82.705  43.287  35.516  1.00 26.60           C  
ATOM   4579  N   ALA E 118      78.583  44.998  34.498  1.00 35.04           N  
ATOM   4580  CA  ALA E 118      77.149  44.945  34.241  1.00 36.48           C  
ATOM   4581  C   ALA E 118      76.972  43.933  33.114  1.00 38.92           C  
ATOM   4582  O   ALA E 118      77.927  43.633  32.389  1.00 36.66           O  
ATOM   4583  CB  ALA E 118      76.632  46.315  33.808  1.00 29.92           C  
ATOM   4584  N   CYS E 119      75.772  43.387  32.967  1.00 33.83           N  
ATOM   4585  CA  CYS E 119      75.555  42.423  31.902  1.00 40.37           C  
ATOM   4586  C   CYS E 119      74.099  42.252  31.528  1.00 38.57           C  
ATOM   4587  O   CYS E 119      73.203  42.787  32.178  1.00 40.35           O  
ATOM   4588  CB  CYS E 119      76.142  41.058  32.286  1.00 44.30           C  
ATOM   4589  SG  CYS E 119      75.180  40.131  33.486  1.00 46.97           S  
ATOM   4590  N   VAL E 120      73.885  41.499  30.457  1.00 42.47           N  
ATOM   4591  CA  VAL E 120      72.555  41.200  29.948  1.00 39.88           C  
ATOM   4592  C   VAL E 120      72.549  39.710  29.659  1.00 48.09           C  
ATOM   4593  O   VAL E 120      73.482  39.193  29.038  1.00 55.66           O  
ATOM   4594  CB  VAL E 120      72.274  41.963  28.651  1.00 35.58           C  
ATOM   4595  CG1 VAL E 120      70.957  41.512  28.053  1.00 37.51           C  
ATOM   4596  CG2 VAL E 120      72.255  43.447  28.929  1.00 31.82           C  
ATOM   4597  N   ALA E 121      71.512  39.016  30.121  1.00 46.94           N  
ATOM   4598  CA  ALA E 121      71.420  37.577  29.897  1.00 43.41           C  
ATOM   4599  C   ALA E 121      70.054  37.181  29.371  1.00 42.43           C  
ATOM   4600  O   ALA E 121      69.091  37.938  29.509  1.00 42.84           O  
ATOM   4601  CB  ALA E 121      71.713  36.825  31.189  1.00 38.37           C  
ATOM   4602  N   LEU E 122      69.981  36.001  28.752  1.00 40.00           N  
ATOM   4603  CA  LEU E 122      68.720  35.485  28.241  1.00 43.47           C  
ATOM   4604  C   LEU E 122      67.857  35.080  29.427  1.00 46.73           C  
ATOM   4605  O   LEU E 122      68.366  34.584  30.431  1.00 40.11           O  
ATOM   4606  CB  LEU E 122      68.959  34.281  27.334  1.00 45.70           C  
ATOM   4607  CG  LEU E 122      69.258  34.620  25.877  1.00 46.37           C  
ATOM   4608  CD1 LEU E 122      69.741  33.383  25.135  1.00 42.52           C  
ATOM   4609  CD2 LEU E 122      67.995  35.180  25.240  1.00 38.96           C  
ATOM   4610  N   ALA E 123      66.552  35.295  29.297  1.00 55.33           N  
ATOM   4611  CA  ALA E 123      65.592  34.988  30.349  1.00 70.04           C  
ATOM   4612  C   ALA E 123      65.581  33.523  30.773  1.00 75.68           C  
ATOM   4613  O   ALA E 123      65.748  33.214  31.951  1.00 80.54           O  
ATOM   4614  CB  ALA E 123      64.194  35.407  29.907  1.00 70.74           C  
ATOM   4615  N   GLU E 124      65.370  32.624  29.816  1.00 81.29           N  
ATOM   4616  CA  GLU E 124      65.335  31.198  30.119  1.00 94.27           C  
ATOM   4617  C   GLU E 124      66.751  30.647  30.252  1.00 96.95           C  
ATOM   4618  O   GLU E 124      67.663  31.256  29.656  1.00 91.35           O  
ATOM   4619  CB  GLU E 124      64.593  30.442  29.012  1.00 97.56           C  
ATOM   4620  CG  GLU E 124      63.205  30.982  28.721  1.00106.95           C  
ATOM   4621  CD  GLU E 124      62.311  30.954  29.940  1.00109.88           C  
ATOM   4622  OE1 GLU E 124      62.044  29.848  30.454  1.00112.91           O  
ATOM   4623  OE2 GLU E 124      61.877  32.038  30.383  1.00113.94           O  
ATOM   4624  OXT GLU E 124      66.928  29.608  30.929  1.00 97.10           O  
TER    4625      GLU E 124                                                      
END
MOLECULE T0423.pdb
ATOM  12910  N   MET     1      70.981  21.031  37.362  1.00 36.76           N  
ATOM  12911  CA  MET     1      71.905  21.930  36.664  1.00 38.87           C  
ATOM  12912  C   MET     1      72.311  23.119  37.519  1.00 35.58           C  
ATOM  12913  O   MET     1      73.455  23.538  37.475  1.00 34.69           O  
ATOM  12914  CB  MET     1      71.283  22.461  35.383  1.00 39.21           C  
ATOM  12915  CG  MET     1      71.504  21.613  34.171  1.00 44.40           C  
ATOM  12916  SD  MET     1      70.806  22.501  32.558  1.00 57.84          SE  
ATOM  12917  CE  MET     1      71.792  24.214  32.666  1.00 53.65           C  
ATOM  12918  N   SER     2      71.368  23.671  38.275  1.00 34.19           N  
ATOM  12919  CA  SER     2      71.660  24.824  39.146  1.00 33.25           C  
ATOM  12920  C   SER     2      72.590  24.410  40.267  1.00 32.21           C  
ATOM  12921  O   SER     2      73.492  25.167  40.644  1.00 30.89           O  
ATOM  12922  CB  SER     2      70.389  25.426  39.738  1.00 32.90           C  
ATOM  12923  OG  SER     2      69.633  26.060  38.749  1.00 33.07           O  
ATOM  12924  N   ASP     3      72.374  23.203  40.811  1.00 30.62           N  
ATOM  12925  CA  ASP     3      73.242  22.687  41.862  1.00 30.33           C  
ATOM  12926  C   ASP     3      74.682  22.556  41.347  1.00 28.94           C  
ATOM  12927  O   ASP     3      75.638  22.825  42.091  1.00 29.92           O  
ATOM  12928  CB  ASP     3      72.774  21.291  42.370  1.00 30.67           C  
ATOM  12929  CG  ASP     3      71.492  21.328  43.198  1.00 32.38           C  
ATOM  12930  OD1 ASP     3      71.019  22.402  43.615  1.00 35.40           O  
ATOM  12931  OD2 ASP     3      70.942  20.230  43.448  1.00 35.26           O  
ATOM  12932  N   VAL     4      74.823  22.096  40.101  1.00 27.71           N  
ATOM  12933  CA  VAL     4      76.127  21.864  39.482  1.00 27.34           C  
ATOM  12934  C   VAL     4      76.846  23.203  39.304  1.00 26.70           C  
ATOM  12935  O   VAL     4      78.035  23.311  39.582  1.00 25.89           O  
ATOM  12936  CB  VAL     4      75.994  21.175  38.115  1.00 27.32           C  
ATOM  12937  CG1 VAL     4      77.261  21.282  37.304  1.00 28.31           C  
ATOM  12938  CG2 VAL     4      75.606  19.678  38.300  1.00 27.74           C  
ATOM  12939  N   ILE     5      76.114  24.200  38.836  1.00 26.35           N  
ATOM  12940  CA  ILE     5      76.694  25.575  38.675  1.00 26.66           C  
ATOM  12941  C   ILE     5      77.167  26.134  40.031  1.00 26.86           C  
ATOM  12942  O   ILE     5      78.302  26.546  40.179  1.00 27.38           O  
ATOM  12943  CB  ILE     5      75.680  26.562  37.999  1.00 26.48           C  
ATOM  12944  CG1 ILE     5      75.346  26.128  36.566  1.00 24.54           C  
ATOM  12945  CG2 ILE     5      76.257  28.001  37.934  1.00 26.07           C  
ATOM  12946  CD1 ILE     5      74.048  26.748  35.988  1.00 26.63           C  
ATOM  12947  N   GLU     6      76.308  26.117  41.034  1.00 27.87           N  
ATOM  12948  CA  GLU     6      76.688  26.606  42.353  1.00 28.66           C  
ATOM  12949  C   GLU     6      77.785  25.768  43.000  1.00 28.15           C  
ATOM  12950  O   GLU     6      78.644  26.303  43.709  1.00 27.19           O  
ATOM  12951  CB  GLU     6      75.481  26.702  43.272  1.00 29.19           C  
ATOM  12952  CG  GLU     6      74.484  27.740  42.832  1.00 31.30           C  
ATOM  12953  CD  GLU     6      73.485  28.113  43.911  1.00 31.61           C  
ATOM  12954  OE1 GLU     6      73.885  28.327  45.083  1.00 38.52           O  
ATOM  12955  OE2 GLU     6      72.296  28.217  43.572  1.00 35.07           O  
ATOM  12956  N   GLY     7      77.769  24.454  42.764  1.00 27.55           N  
ATOM  12957  CA  GLY     7      78.825  23.599  43.252  1.00 27.47           C  
ATOM  12958  C   GLY     7      80.172  23.924  42.647  1.00 27.46           C  
ATOM  12959  O   GLY     7      81.190  23.916  43.348  1.00 28.04           O  
ATOM  12960  N   ARG     8      80.193  24.198  41.351  1.00 27.39           N  
ATOM  12961  CA  ARG     8      81.428  24.591  40.683  1.00 28.18           C  
ATOM  12962  C   ARG     8      81.977  25.901  41.263  1.00 27.87           C  
ATOM  12963  O   ARG     8      83.187  26.055  41.439  1.00 28.10           O  
ATOM  12964  CB  ARG     8      81.219  24.776  39.185  1.00 27.91           C  
ATOM  12965  CG  ARG     8      81.010  23.509  38.405  1.00 28.72           C  
ATOM  12966  CD  ARG     8      80.440  23.881  37.071  1.00 31.46           C  
ATOM  12967  NE  ARG     8      80.192  22.738  36.217  1.00 33.09           N  
ATOM  12968  CZ  ARG     8      79.413  22.752  35.140  1.00 35.77           C  
ATOM  12969  NH1 ARG     8      78.767  23.854  34.762  1.00 36.28           N  
ATOM  12970  NH2 ARG     8      79.267  21.629  34.439  1.00 38.50           N  
ATOM  12971  N   LEU     9      81.077  26.830  41.554  1.00 28.09           N  
ATOM  12972  CA  LEU     9      81.479  28.113  42.139  1.00 28.34           C  
ATOM  12973  C   LEU     9      82.103  27.873  43.539  1.00 28.63           C  
ATOM  12974  O   LEU     9      83.145  28.457  43.874  1.00 27.85           O  
ATOM  12975  CB  LEU     9      80.271  29.044  42.209  1.00 28.43           C  
ATOM  12976  CG  LEU     9      80.543  30.479  42.669  1.00 28.95           C  
ATOM  12977  CD1 LEU     9      81.644  31.110  41.771  1.00 29.20           C  
ATOM  12978  CD2 LEU     9      79.251  31.302  42.651  1.00 29.10           C  
ATOM  12979  N   LYS    10      81.487  26.998  44.343  1.00 28.27           N  
ATOM  12980  CA  LYS    10      82.090  26.586  45.618  1.00 29.09           C  
ATOM  12981  C   LYS    10      83.477  25.946  45.467  1.00 29.33           C  
ATOM  12982  O   LYS    10      84.380  26.178  46.296  1.00 30.06           O  
ATOM  12983  CB  LYS    10      81.155  25.648  46.379  1.00 29.06           C  
ATOM  12984  CG  LYS    10      79.869  26.277  46.842  1.00 29.74           C  
ATOM  12985  CD  LYS    10      79.055  25.300  47.652  1.00 30.41           C  
ATOM  12986  CE  LYS    10      77.739  25.887  48.034  1.00 30.84           C  
ATOM  12987  NZ  LYS    10      76.878  24.856  48.677  1.00 32.89           N  
ATOM  12988  N   GLU    11      83.673  25.166  44.413  1.00 29.53           N  
ATOM  12989  CA  GLU    11      84.977  24.594  44.114  1.00 30.47           C  
ATOM  12990  C   GLU    11      86.011  25.667  43.795  1.00 30.79           C  
ATOM  12991  O   GLU    11      87.190  25.452  44.020  1.00 32.10           O  
ATOM  12992  CB  GLU    11      84.889  23.624  42.946  1.00 30.41           C  
ATOM  12993  CG  GLU    11      84.195  22.304  43.287  1.00 31.53           C  
ATOM  12994  CD  GLU    11      83.980  21.440  42.072  1.00 33.05           C  
ATOM  12995  OE1 GLU    11      83.483  21.935  41.044  1.00 37.69           O  
ATOM  12996  OE2 GLU    11      84.275  20.239  42.144  1.00 40.32           O  
ATOM  12997  N   LEU    12      85.573  26.810  43.266  1.00 30.96           N  
ATOM  12998  CA  LEU    12      86.458  27.982  43.080  1.00 30.36           C  
ATOM  12999  C   LEU    12      86.672  28.813  44.349  1.00 30.69           C  
ATOM  13000  O   LEU    12      87.510  29.730  44.358  1.00 31.30           O  
ATOM  13001  CB  LEU    12      85.912  28.883  41.982  1.00 29.65           C  
ATOM  13002  CG  LEU    12      85.889  28.253  40.603  1.00 29.14           C  
ATOM  13003  CD1 LEU    12      85.193  29.190  39.650  1.00 28.44           C  
ATOM  13004  CD2 LEU    12      87.318  27.916  40.123  1.00 30.62           C  
ATOM  13005  N   GLY    13      85.906  28.530  45.398  1.00 30.88           N  
ATOM  13006  CA  GLY    13      86.097  29.154  46.694  1.00 30.87           C  
ATOM  13007  C   GLY    13      85.047  30.177  47.062  1.00 30.89           C  
ATOM  13008  O   GLY    13      85.157  30.816  48.099  1.00 31.94           O  
ATOM  13009  N   PHE    14      84.004  30.303  46.254  1.00 30.40           N  
ATOM  13010  CA  PHE    14      82.959  31.278  46.509  1.00 30.42           C  
ATOM  13011  C   PHE    14      81.595  30.647  46.801  1.00 31.05           C  
ATOM  13012  O   PHE    14      81.170  29.691  46.147  1.00 30.75           O  
ATOM  13013  CB  PHE    14      82.829  32.227  45.312  1.00 29.97           C  
ATOM  13014  CG  PHE    14      84.106  32.886  44.930  1.00 28.80           C  
ATOM  13015  CD1 PHE    14      84.494  34.057  45.537  1.00 29.32           C  
ATOM  13016  CD2 PHE    14      84.924  32.336  43.954  1.00 28.91           C  
ATOM  13017  CE1 PHE    14      85.688  34.670  45.177  1.00 27.83           C  
ATOM  13018  CE2 PHE    14      86.114  32.938  43.594  1.00 28.84           C  
ATOM  13019  CZ  PHE    14      86.494  34.108  44.214  1.00 28.76           C  
ATOM  13020  N   THR    15      80.906  31.228  47.769  1.00 31.89           N  
ATOM  13021  CA  THR    15      79.480  31.011  47.934  1.00 33.07           C  
ATOM  13022  C   THR    15      78.738  32.270  47.471  1.00 33.07           C  
ATOM  13023  O   THR    15      79.306  33.390  47.471  1.00 32.98           O  
ATOM  13024  CB  THR    15      79.142  30.676  49.406  1.00 33.77           C  
ATOM  13025  OG1 THR    15      79.407  31.816  50.239  1.00 37.27           O  
ATOM  13026  CG2 THR    15      79.988  29.500  49.902  1.00 32.51           C  
ATOM  13027  N   LEU    16      77.488  32.100  47.043  1.00 32.88           N  
ATOM  13028  CA  LEU    16      76.696  33.230  46.573  1.00 32.59           C  
ATOM  13029  C   LEU    16      76.163  34.007  47.767  1.00 33.08           C  
ATOM  13030  O   LEU    16      75.580  33.413  48.678  1.00 32.54           O  
ATOM  13031  CB  LEU    16      75.513  32.781  45.706  1.00 32.47           C  
ATOM  13032  CG  LEU    16      75.834  32.190  44.332  1.00 31.50           C  
ATOM  13033  CD1 LEU    16      74.534  31.595  43.670  1.00 29.77           C  
ATOM  13034  CD2 LEU    16      76.521  33.215  43.434  1.00 28.44           C  
ATOM  13035  N   PRO    17      76.338  35.334  47.771  1.00 33.26           N  
ATOM  13036  CA  PRO    17      75.694  36.103  48.823  1.00 33.95           C  
ATOM  13037  C   PRO    17      74.202  36.176  48.577  1.00 35.74           C  
ATOM  13038  O   PRO    17      73.743  35.890  47.461  1.00 35.40           O  
ATOM  13039  CB  PRO    17      76.304  37.492  48.650  1.00 33.84           C  
ATOM  13040  CG  PRO    17      76.630  37.570  47.219  1.00 33.42           C  
ATOM  13041  CD  PRO    17      77.081  36.198  46.835  1.00 32.52           C  
ATOM  13042  N   VAL    18      73.449  36.584  49.596  1.00 37.90           N  
ATOM  13043  CA  VAL    18      72.045  36.963  49.389  1.00 39.41           C  
ATOM  13044  C   VAL    18      71.995  38.269  48.568  1.00 40.41           C  
ATOM  13045  O   VAL    18      71.230  38.389  47.586  1.00 42.23           O  
ATOM  13046  CB  VAL    18      71.308  37.200  50.710  1.00 39.67           C  
ATOM  13047  CG1 VAL    18      71.505  36.006  51.656  1.00 40.20           C  
ATOM  13048  CG2 VAL    18      71.762  38.513  51.345  1.00 39.98           C  
ATOM  13049  N   ALA    23      66.158  48.786  48.809  1.00 42.30           N  
ATOM  13050  CA  ALA    23      64.939  49.472  48.343  1.00 41.72           C  
ATOM  13051  C   ALA    23      65.286  50.838  47.711  1.00 41.82           C  
ATOM  13052  O   ALA    23      65.606  51.804  48.439  1.00 42.33           O  
ATOM  13053  CB  ALA    23      63.942  49.647  49.513  1.00 42.49           C  
ATOM  13054  N   ALA    24      65.243  50.926  46.370  1.00 40.52           N  
ATOM  13055  CA  ALA    24      65.678  52.154  45.678  1.00 38.94           C  
ATOM  13056  C   ALA    24      64.979  52.405  44.337  1.00 37.86           C  
ATOM  13057  O   ALA    24      64.258  51.549  43.818  1.00 37.65           O  
ATOM  13058  CB  ALA    24      67.220  52.130  45.485  1.00 39.16           C  
ATOM  13059  N   ASN    25      65.207  53.597  43.784  1.00 35.84           N  
ATOM  13060  CA  ASN    25      64.676  53.977  42.458  1.00 34.71           C  
ATOM  13061  C   ASN    25      65.420  53.350  41.277  1.00 32.01           C  
ATOM  13062  O   ASN    25      64.955  53.404  40.128  1.00 30.65           O  
ATOM  13063  CB  ASN    25      64.628  55.506  42.327  1.00 34.31           C  
ATOM  13064  CG  ASN    25      63.556  56.116  43.221  1.00 34.82           C  
ATOM  13065  OD1 ASN    25      63.757  57.167  43.838  1.00 36.03           O  
ATOM  13066  ND2 ASN    25      62.419  55.419  43.327  1.00 31.59           N  
ATOM  13067  N   TYR    26      66.570  52.763  41.572  1.00 30.18           N  
ATOM  13068  CA  TYR    26      67.208  51.824  40.653  1.00 28.61           C  
ATOM  13069  C   TYR    26      67.192  50.433  41.287  1.00 26.27           C  
ATOM  13070  O   TYR    26      67.222  50.261  42.514  1.00 25.81           O  
ATOM  13071  CB  TYR    26      68.625  52.246  40.221  1.00 28.83           C  
ATOM  13072  CG  TYR    26      69.621  52.398  41.339  1.00 30.60           C  
ATOM  13073  CD1 TYR    26      70.670  51.493  41.495  1.00 30.95           C  
ATOM  13074  CD2 TYR    26      69.522  53.456  42.230  1.00 30.60           C  
ATOM  13075  CE1 TYR    26      71.582  51.635  42.510  1.00 30.87           C  
ATOM  13076  CE2 TYR    26      70.411  53.597  43.267  1.00 32.36           C  
ATOM  13077  CZ  TYR    26      71.447  52.689  43.404  1.00 32.75           C  
ATOM  13078  OH  TYR    26      72.352  52.852  44.448  1.00 34.31           O  
ATOM  13079  N   VAL    27      67.135  49.446  40.418  1.00 24.17           N  
ATOM  13080  CA  VAL    27      67.030  48.071  40.817  1.00 22.92           C  
ATOM  13081  C   VAL    27      68.271  47.271  40.393  1.00 22.47           C  
ATOM  13082  O   VAL    27      68.985  47.662  39.463  1.00 20.80           O  
ATOM  13083  CB  VAL    27      65.757  47.458  40.209  1.00 22.53           C  
ATOM  13084  CG1 VAL    27      64.536  48.064  40.881  1.00 24.05           C  
ATOM  13085  CG2 VAL    27      65.709  47.685  38.675  1.00 20.19           C  
ATOM  13086  N   PRO    28      68.514  46.135  41.065  1.00 22.19           N  
ATOM  13087  CA  PRO    28      69.643  45.282  40.693  1.00 22.05           C  
ATOM  13088  C   PRO    28      69.576  44.646  39.313  1.00 21.32           C  
ATOM  13089  O   PRO    28      70.620  44.298  38.758  1.00 19.41           O  
ATOM  13090  CB  PRO    28      69.645  44.208  41.765  1.00 23.32           C  
ATOM  13091  CG  PRO    28      68.744  44.705  42.839  1.00 24.78           C  
ATOM  13092  CD  PRO    28      67.767  45.580  42.209  1.00 22.87           C  
ATOM  13093  N   PHE    29      68.366  44.511  38.760  1.00 20.74           N  
ATOM  13094  CA  PHE    29      68.186  43.931  37.454  1.00 21.35           C  
ATOM  13095  C   PHE    29      66.815  44.278  36.885  1.00 20.78           C  
ATOM  13096  O   PHE    29      65.876  44.597  37.615  1.00 20.82           O  
ATOM  13097  CB  PHE    29      68.410  42.392  37.475  1.00 21.85           C  
ATOM  13098  CG  PHE    29      67.437  41.650  38.360  1.00 22.44           C  
ATOM  13099  CD1 PHE    29      66.175  41.334  37.907  1.00 24.23           C  
ATOM  13100  CD2 PHE    29      67.776  41.337  39.664  1.00 24.23           C  
ATOM  13101  CE1 PHE    29      65.265  40.664  38.746  1.00 23.72           C  
ATOM  13102  CE2 PHE    29      66.883  40.698  40.489  1.00 26.07           C  
ATOM  13103  CZ  PHE    29      65.623  40.381  40.031  1.00 24.55           C  
ATOM  13104  N   THR    30      66.753  44.281  35.568  1.00 21.11           N  
ATOM  13105  CA  THR    30      65.491  44.370  34.819  1.00 22.00           C  
ATOM  13106  C   THR    30      65.480  43.293  33.752  1.00 22.35           C  
ATOM  13107  O   THR    30      66.525  42.798  33.356  1.00 21.01           O  
ATOM  13108  CB  THR    30      65.298  45.735  34.132  1.00 22.63           C  
ATOM  13109  OG1 THR    30      66.405  46.020  33.266  1.00 22.53           O  
ATOM  13110  CG2 THR    30      65.139  46.846  35.164  1.00 21.28           C  
ATOM  13111  N   ILE    31      64.276  42.943  33.280  1.00 23.19           N  
ATOM  13112  CA  ILE    31      64.104  41.993  32.189  1.00 23.67           C  
ATOM  13113  C   ILE    31      63.288  42.634  31.087  1.00 23.56           C  
ATOM  13114  O   ILE    31      62.269  43.294  31.331  1.00 24.21           O  
ATOM  13115  CB  ILE    31      63.424  40.684  32.664  1.00 23.86           C  
ATOM  13116  CG1 ILE    31      64.303  39.977  33.687  1.00 23.74           C  
ATOM  13117  CG2 ILE    31      63.169  39.723  31.486  1.00 24.39           C  
ATOM  13118  CD1 ILE    31      63.577  38.878  34.465  1.00 25.28           C  
ATOM  13119  N   SER    32      63.757  42.461  29.874  1.00 24.00           N  
ATOM  13120  CA  SER    32      63.011  42.846  28.692  1.00 25.73           C  
ATOM  13121  C   SER    32      63.058  41.677  27.730  1.00 25.64           C  
ATOM  13122  O   SER    32      64.122  41.331  27.246  1.00 25.50           O  
ATOM  13123  CB  SER    32      63.598  44.073  28.021  1.00 25.81           C  
ATOM  13124  OG  SER    32      62.809  44.432  26.913  1.00 27.19           O  
ATOM  13125  N   GLY    33      61.903  41.083  27.430  1.00 26.33           N  
ATOM  13126  CA  GLY    33      61.899  39.878  26.629  1.00 26.22           C  
ATOM  13127  C   GLY    33      62.655  38.771  27.314  1.00 25.36           C  
ATOM  13128  O   GLY    33      62.370  38.424  28.457  1.00 26.34           O  
ATOM  13129  N   ASN    34      63.633  38.209  26.622  1.00 24.98           N  
ATOM  13130  CA  ASN    34      64.458  37.178  27.241  1.00 25.51           C  
ATOM  13131  C   ASN    34      65.858  37.705  27.552  1.00 24.78           C  
ATOM  13132  O   ASN    34      66.804  36.930  27.584  1.00 24.18           O  
ATOM  13133  CB  ASN    34      64.528  35.934  26.371  1.00 27.08           C  
ATOM  13134  CG  ASN    34      65.282  36.158  25.091  1.00 30.55           C  
ATOM  13135  OD1 ASN    34      65.607  37.305  24.738  1.00 35.31           O  
ATOM  13136  ND2 ASN    34      65.586  35.057  24.371  1.00 35.76           N  
ATOM  13137  N   LEU    35      65.983  39.022  27.699  1.00 24.55           N  
ATOM  13138  CA  LEU    35      67.277  39.637  28.078  1.00 24.12           C  
ATOM  13139  C   LEU    35      67.189  40.157  29.496  1.00 23.03           C  
ATOM  13140  O   LEU    35      66.268  40.868  29.847  1.00 23.05           O  
ATOM  13141  CB  LEU    35      67.702  40.736  27.096  1.00 24.76           C  
ATOM  13142  CG  LEU    35      68.282  40.199  25.764  1.00 26.16           C  
ATOM  13143  CD1 LEU    35      68.633  41.334  24.793  1.00 28.97           C  
ATOM  13144  CD2 LEU    35      69.489  39.249  25.947  1.00 28.49           C  
ATOM  13145  N   LEU    36      68.148  39.763  30.315  1.00 21.64           N  
ATOM  13146  CA  LEU    36      68.250  40.214  31.693  1.00 20.97           C  
ATOM  13147  C   LEU    36      69.421  41.199  31.776  1.00 20.61           C  
ATOM  13148  O   LEU    36      70.562  40.854  31.376  1.00 21.20           O  
ATOM  13149  CB  LEU    36      68.532  39.046  32.613  1.00 21.41           C  
ATOM  13150  CG  LEU    36      68.789  39.264  34.102  1.00 21.35           C  
ATOM  13151  CD1 LEU    36      67.603  39.957  34.807  1.00 23.14           C  
ATOM  13152  CD2 LEU    36      69.179  37.943  34.804  1.00 22.93           C  
ATOM  13153  N   TYR    37      69.112  42.393  32.255  1.00 19.52           N  
ATOM  13154  CA  TYR    37      70.093  43.483  32.452  1.00 19.94           C  
ATOM  13155  C   TYR    37      70.430  43.581  33.906  1.00 19.30           C  
ATOM  13156  O   TYR    37      69.576  43.954  34.684  1.00 18.49           O  
ATOM  13157  CB  TYR    37      69.527  44.816  32.021  1.00 21.62           C  
ATOM  13158  CG  TYR    37      69.633  45.044  30.561  1.00 24.97           C  
ATOM  13159  CD1 TYR    37      70.608  45.901  30.041  1.00 26.99           C  
ATOM  13160  CD2 TYR    37      68.798  44.384  29.690  1.00 26.43           C  
ATOM  13161  CE1 TYR    37      70.711  46.099  28.690  1.00 28.18           C  
ATOM  13162  CE2 TYR    37      68.902  44.583  28.309  1.00 27.61           C  
ATOM  13163  CZ  TYR    37      69.839  45.424  27.829  1.00 26.70           C  
ATOM  13164  OH  TYR    37      69.928  45.651  26.474  1.00 28.34           O  
ATOM  13165  N   VAL    38      71.680  43.277  34.255  1.00 18.12           N  
ATOM  13166  CA  VAL    38      72.116  43.284  35.635  1.00 17.38           C  
ATOM  13167  C   VAL    38      72.897  44.591  35.852  1.00 17.03           C  
ATOM  13168  O   VAL    38      73.783  44.948  35.040  1.00 16.35           O  
ATOM  13169  CB  VAL    38      72.994  42.065  35.962  1.00 17.22           C  
ATOM  13170  CG1 VAL    38      73.488  42.113  37.378  1.00 16.68           C  
ATOM  13171  CG2 VAL    38      72.228  40.778  35.704  1.00 19.02           C  
ATOM  13172  N   SER    39      72.542  45.277  36.935  1.00 16.21           N  
ATOM  13173  CA  SER    39      73.190  46.537  37.340  1.00 16.77           C  
ATOM  13174  C   SER    39      74.675  46.307  37.694  1.00 16.42           C  
ATOM  13175  O   SER    39      75.066  45.194  38.084  1.00 16.79           O  
ATOM  13176  CB  SER    39      72.491  47.130  38.559  1.00 16.39           C  
ATOM  13177  OG  SER    39      71.232  47.673  38.217  1.00 16.94           O  
ATOM  13178  N   GLY    40      75.498  47.355  37.547  1.00 16.71           N  
ATOM  13179  CA  GLY    40      76.913  47.251  37.877  1.00 16.17           C  
ATOM  13180  C   GLY    40      77.093  46.701  39.267  1.00 16.82           C  
ATOM  13181  O   GLY    40      76.479  47.191  40.216  1.00 16.75           O  
ATOM  13182  N   GLN    41      77.848  45.617  39.375  1.00 16.68           N  
ATOM  13183  CA  GLN    41      78.114  44.996  40.668  1.00 17.30           C  
ATOM  13184  C   GLN    41      79.538  45.360  41.116  1.00 16.88           C  
ATOM  13185  O   GLN    41      80.451  45.399  40.295  1.00 17.16           O  
ATOM  13186  CB  GLN    41      77.943  43.460  40.588  1.00 17.03           C  
ATOM  13187  CG  GLN    41      76.522  42.993  40.194  1.00 18.15           C  
ATOM  13188  CD  GLN    41      75.491  43.430  41.175  1.00 18.41           C  
ATOM  13189  OE1 GLN    41      75.559  43.081  42.360  1.00 18.42           O  
ATOM  13190  NE2 GLN    41      74.513  44.191  40.705  1.00 18.08           N  
ATOM  13191  N   LEU    42      79.675  45.523  42.425  1.00 18.51           N  
ATOM  13192  CA  LEU    42      80.922  45.823  43.142  1.00 19.27           C  
ATOM  13193  C   LEU    42      81.505  44.544  43.800  1.00 20.59           C  
ATOM  13194  O   LEU    42      80.809  43.508  43.933  1.00 20.90           O  
ATOM  13195  CB  LEU    42      80.648  46.893  44.195  1.00 19.83           C  
ATOM  13196  CG  LEU    42      80.007  48.193  43.701  1.00 20.09           C  
ATOM  13197  CD1 LEU    42      79.893  49.256  44.830  1.00 24.19           C  
ATOM  13198  CD2 LEU    42      80.773  48.751  42.474  1.00 20.92           C  
ATOM  13199  N   PRO    43      82.784  44.590  44.204  1.00 20.99           N  
ATOM  13200  CA  PRO    43      83.390  43.388  44.739  1.00 22.23           C  
ATOM  13201  C   PRO    43      82.987  43.165  46.205  1.00 23.30           C  
ATOM  13202  O   PRO    43      83.833  43.267  47.123  1.00 23.87           O  
ATOM  13203  CB  PRO    43      84.886  43.654  44.574  1.00 22.24           C  
ATOM  13204  CG  PRO    43      85.021  45.107  44.597  1.00 22.74           C  
ATOM  13205  CD  PRO    43      83.747  45.711  44.125  1.00 20.90           C  
ATOM  13206  N   MET    44      81.695  42.863  46.396  1.00 24.94           N  
ATOM  13207  CA  MET    44      81.111  42.668  47.725  1.00 26.76           C  
ATOM  13208  C   MET    44      81.416  41.303  48.250  1.00 27.78           C  
ATOM  13209  O   MET    44      81.216  40.309  47.554  1.00 26.94           O  
ATOM  13210  CB  MET    44      79.606  42.768  47.701  1.00 28.72           C  
ATOM  13211  CG  MET    44      79.087  44.003  47.142  1.00 34.04           C  
ATOM  13212  SD  MET    44      79.675  45.517  48.177  1.00 52.29          SE  
ATOM  13213  CE  MET    44      78.069  46.599  47.655  1.00 42.80           C  
ATOM  13214  N   GLU    45      81.866  41.277  49.503  1.00 28.96           N  
ATOM  13215  CA  GLU    45      82.155  40.050  50.199  1.00 30.57           C  
ATOM  13216  C   GLU    45      81.806  40.268  51.663  1.00 30.94           C  
ATOM  13217  O   GLU    45      82.239  41.230  52.276  1.00 29.35           O  
ATOM  13218  CB  GLU    45      83.615  39.704  50.030  1.00 31.01           C  
ATOM  13219  CG  GLU    45      83.899  38.254  50.285  1.00 32.83           C  
ATOM  13220  CD  GLU    45      85.369  37.906  50.169  1.00 34.03           C  
ATOM  13221  OE1 GLU    45      86.236  38.800  50.290  1.00 40.50           O  
ATOM  13222  OE2 GLU    45      85.665  36.719  49.956  1.00 39.11           O  
ATOM  13223  N   SER    46      80.980  39.381  52.208  1.00 32.41           N  
ATOM  13224  CA  SER    46      80.473  39.546  53.558  1.00 33.11           C  
ATOM  13225  C   SER    46      79.902  40.921  53.829  1.00 32.96           C  
ATOM  13226  O   SER    46      80.092  41.474  54.907  1.00 33.73           O  
ATOM  13227  CB  SER    46      81.576  39.245  54.550  1.00 33.85           C  
ATOM  13228  OG  SER    46      82.071  37.929  54.341  1.00 36.10           O  
ATOM  13229  N   GLY    47      79.201  41.482  52.851  1.00 32.72           N  
ATOM  13230  CA  GLY    47      78.556  42.782  53.023  1.00 32.20           C  
ATOM  13231  C   GLY    47      79.457  44.008  52.954  1.00 31.89           C  
ATOM  13232  O   GLY    47      78.988  45.134  53.165  1.00 32.53           O  
ATOM  13233  N   LYS    48      80.735  43.805  52.632  1.00 31.36           N  
ATOM  13234  CA  LYS    48      81.710  44.889  52.589  1.00 31.00           C  
ATOM  13235  C   LYS    48      82.340  44.938  51.204  1.00 29.19           C  
ATOM  13236  O   LYS    48      82.428  43.919  50.525  1.00 27.85           O  
ATOM  13237  CB  LYS    48      82.812  44.643  53.628  1.00 32.10           C  
ATOM  13238  CG  LYS    48      82.320  44.278  55.056  1.00 33.77           C  
ATOM  13239  CD  LYS    48      83.517  44.073  55.997  1.00 34.85           C  
ATOM  13240  CE  LYS    48      83.212  43.172  57.223  1.00 38.54           C  
ATOM  13241  NZ  LYS    48      82.691  41.784  56.927  1.00 41.89           N  
ATOM  13242  N   ILE    49      82.793  46.114  50.786  1.00 27.46           N  
ATOM  13243  CA  ILE    49      83.609  46.197  49.556  1.00 27.51           C  
ATOM  13244  C   ILE    49      84.994  45.615  49.890  1.00 26.44           C  
ATOM  13245  O   ILE    49      85.717  46.162  50.719  1.00 27.76           O  
ATOM  13246  CB  ILE    49      83.727  47.641  48.999  1.00 27.35           C  
ATOM  13247  CG1 ILE    49      82.339  48.250  48.725  1.00 28.61           C  
ATOM  13248  CG2 ILE    49      84.568  47.654  47.687  1.00 25.90           C  
ATOM  13249  CD1 ILE    49      81.640  47.702  47.484  1.00 29.88           C  
ATOM  13250  N   ALA    50      85.329  44.473  49.299  1.00 24.66           N  
ATOM  13251  CA  ALA    50      86.524  43.716  49.675  1.00 23.88           C  
ATOM  13252  C   ALA    50      87.844  44.216  49.077  1.00 22.88           C  
ATOM  13253  O   ALA    50      88.926  43.916  49.616  1.00 23.36           O  
ATOM  13254  CB  ALA    50      86.342  42.241  49.306  1.00 24.42           C  
ATOM  13255  N   VAL    51      87.773  44.926  47.958  1.00 20.81           N  
ATOM  13256  CA  VAL    51      88.968  45.381  47.241  1.00 19.75           C  
ATOM  13257  C   VAL    51      88.716  46.833  46.772  1.00 19.50           C  
ATOM  13258  O   VAL    51      87.820  47.092  45.950  1.00 18.36           O  
ATOM  13259  CB  VAL    51      89.299  44.506  46.034  1.00 19.25           C  
ATOM  13260  CG1 VAL    51      90.619  44.969  45.369  1.00 17.95           C  
ATOM  13261  CG2 VAL    51      89.337  42.997  46.410  1.00 19.82           C  
ATOM  13262  N   THR    52      89.518  47.761  47.290  1.00 18.83           N  
ATOM  13263  CA  THR    52      89.331  49.192  47.048  1.00 18.76           C  
ATOM  13264  C   THR    52      90.623  49.886  46.577  1.00 17.15           C  
ATOM  13265  O   THR    52      91.752  49.426  46.833  1.00 18.57           O  
ATOM  13266  CB  THR    52      88.801  49.933  48.274  1.00 19.87           C  
ATOM  13267  OG1 THR    52      89.751  49.836  49.341  1.00 20.52           O  
ATOM  13268  CG2 THR    52      87.440  49.358  48.732  1.00 20.18           C  
ATOM  13269  N   GLY    53      90.427  50.980  45.853  1.00 16.63           N  
ATOM  13270  CA  GLY    53      91.523  51.794  45.378  1.00 15.81           C  
ATOM  13271  C   GLY    53      91.866  51.490  43.935  1.00 16.34           C  
ATOM  13272  O   GLY    53      91.220  50.657  43.238  1.00 16.41           O  
ATOM  13273  N   LEU    54      92.852  52.232  43.462  1.00 14.89           N  
ATOM  13274  CA  LEU    54      93.241  52.192  42.046  1.00 15.09           C  
ATOM  13275  C   LEU    54      94.198  51.052  41.691  1.00 14.82           C  
ATOM  13276  O   LEU    54      95.217  50.830  42.343  1.00 15.74           O  
ATOM  13277  CB  LEU    54      93.870  53.539  41.641  1.00 14.99           C  
ATOM  13278  CG  LEU    54      93.016  54.794  41.893  1.00 16.43           C  
ATOM  13279  CD1 LEU    54      93.853  56.129  41.629  1.00 14.43           C  
ATOM  13280  CD2 LEU    54      91.711  54.771  41.099  1.00 18.58           C  
ATOM  13281  N   VAL    55      93.881  50.333  40.618  1.00 15.10           N  
ATOM  13282  CA  VAL    55      94.798  49.303  40.117  1.00 15.22           C  
ATOM  13283  C   VAL    55      96.009  50.038  39.509  1.00 15.52           C  
ATOM  13284  O   VAL    55      95.867  51.023  38.743  1.00 15.49           O  
ATOM  13285  CB  VAL    55      94.147  48.295  39.122  1.00 15.34           C  
ATOM  13286  CG1 VAL    55      95.143  47.202  38.776  1.00 16.34           C  
ATOM  13287  CG2 VAL    55      92.798  47.747  39.668  1.00 14.16           C  
ATOM  13288  N   GLY    56      97.188  49.598  39.915  1.00 15.44           N  
ATOM  13289  CA  GLY    56      98.449  50.244  39.536  1.00 16.28           C  
ATOM  13290  C   GLY    56      98.942  51.219  40.587  1.00 16.32           C  
ATOM  13291  O   GLY    56     100.026  51.780  40.450  1.00 16.29           O  
ATOM  13292  N   ARG    57      98.166  51.390  41.665  1.00 16.32           N  
ATOM  13293  CA  ARG    57      98.571  52.249  42.778  1.00 16.70           C  
ATOM  13294  C   ARG    57      98.304  51.594  44.106  1.00 16.10           C  
ATOM  13295  O   ARG    57      99.218  51.357  44.886  1.00 17.03           O  
ATOM  13296  CB  ARG    57      97.873  53.603  42.715  1.00 15.72           C  
ATOM  13297  CG  ARG    57      98.244  54.497  43.885  1.00 16.84           C  
ATOM  13298  CD  ARG    57      97.659  55.894  43.877  1.00 15.89           C  
ATOM  13299  NE  ARG    57      98.101  56.563  45.097  1.00 15.63           N  
ATOM  13300  CZ  ARG    57      99.287  57.153  45.256  1.00 16.91           C  
ATOM  13301  NH1 ARG    57     100.160  57.249  44.259  1.00 13.83           N  
ATOM  13302  NH2 ARG    57      99.613  57.651  46.435  1.00 15.00           N  
ATOM  13303  N   ASP    58      97.051  51.278  44.341  1.00 16.23           N  
ATOM  13304  CA  ASP    58      96.620  50.693  45.608  1.00 16.54           C  
ATOM  13305  C   ASP    58      96.524  49.169  45.557  1.00 16.62           C  
ATOM  13306  O   ASP    58      96.664  48.506  46.600  1.00 16.58           O  
ATOM  13307  CB  ASP    58      95.275  51.259  45.998  1.00 16.42           C  
ATOM  13308  CG  ASP    58      95.312  52.769  46.142  1.00 17.20           C  
ATOM  13309  OD1 ASP    58      96.112  53.243  46.982  1.00 19.65           O  
ATOM  13310  OD2 ASP    58      94.531  53.456  45.451  1.00 18.16           O  
ATOM  13311  N   VAL    59      96.242  48.632  44.377  1.00 16.45           N  
ATOM  13312  CA  VAL    59      96.058  47.197  44.212  1.00 17.77           C  
ATOM  13313  C   VAL    59      96.785  46.737  42.956  1.00 17.83           C  
ATOM  13314  O   VAL    59      96.926  47.493  41.987  1.00 17.33           O  
ATOM  13315  CB  VAL    59      94.554  46.767  44.189  1.00 18.87           C  
ATOM  13316  CG1 VAL    59      93.778  47.334  45.449  1.00 21.82           C  
ATOM  13317  CG2 VAL    59      93.896  47.197  42.965  1.00 21.44           C  
ATOM  13318  N   ASP    60      97.285  45.515  43.025  1.00 18.74           N  
ATOM  13319  CA  ASP    60      97.964  44.879  41.909  1.00 19.34           C  
ATOM  13320  C   ASP    60      96.992  44.080  41.043  1.00 19.48           C  
ATOM  13321  O   ASP    60      95.805  44.037  41.332  1.00 19.40           O  
ATOM  13322  CB  ASP    60      99.147  44.040  42.405  1.00 20.89           C  
ATOM  13323  CG  ASP    60      98.757  42.848  43.254  1.00 21.21           C  
ATOM  13324  OD1 ASP    60      97.589  42.484  43.394  1.00 22.81           O  
ATOM  13325  OD2 ASP    60      99.713  42.231  43.792  1.00 30.25           O  
ATOM  13326  N   VAL    61      97.486  43.487  39.967  1.00 18.59           N  
ATOM  13327  CA  VAL    61      96.614  42.760  39.045  1.00 19.30           C  
ATOM  13328  C   VAL    61      95.938  41.568  39.757  1.00 18.76           C  
ATOM  13329  O   VAL    61      94.732  41.355  39.623  1.00 19.22           O  
ATOM  13330  CB  VAL    61      97.352  42.330  37.761  1.00 19.44           C  
ATOM  13331  CG1 VAL    61      96.504  41.337  36.953  1.00 20.46           C  
ATOM  13332  CG2 VAL    61      97.699  43.573  36.911  1.00 19.62           C  
ATOM  13333  N   ALA    62      96.695  40.801  40.523  1.00 18.89           N  
ATOM  13334  CA  ALA    62      96.120  39.649  41.215  1.00 19.10           C  
ATOM  13335  C   ALA    62      94.973  40.048  42.139  1.00 19.10           C  
ATOM  13336  O   ALA    62      93.905  39.417  42.132  1.00 18.61           O  
ATOM  13337  CB  ALA    62      97.209  38.899  42.012  1.00 19.82           C  
ATOM  13338  N   SER    63      95.178  41.088  42.960  1.00 18.52           N  
ATOM  13339  CA  SER    63      94.126  41.541  43.854  1.00 19.00           C  
ATOM  13340  C   SER    63      92.917  42.037  43.057  1.00 18.56           C  
ATOM  13341  O   SER    63      91.790  41.803  43.432  1.00 18.58           O  
ATOM  13342  CB  SER    63      94.622  42.645  44.745  1.00 19.24           C  
ATOM  13343  OG  SER    63      95.617  42.148  45.586  1.00 20.64           O  
ATOM  13344  N   ALA    64      93.164  42.778  41.983  1.00 18.32           N  
ATOM  13345  CA  ALA    64      92.088  43.282  41.124  1.00 18.22           C  
ATOM  13346  C   ALA    64      91.295  42.123  40.447  1.00 17.22           C  
ATOM  13347  O   ALA    64      90.093  42.203  40.247  1.00 15.74           O  
ATOM  13348  CB  ALA    64      92.667  44.231  40.071  1.00 18.00           C  
ATOM  13349  N   GLN    65      92.005  41.065  40.095  1.00 18.13           N  
ATOM  13350  CA  GLN    65      91.374  39.867  39.554  1.00 19.19           C  
ATOM  13351  C   GLN    65      90.392  39.274  40.566  1.00 19.55           C  
ATOM  13352  O   GLN    65      89.268  38.896  40.194  1.00 19.43           O  
ATOM  13353  CB  GLN    65      92.424  38.845  39.097  1.00 18.99           C  
ATOM  13354  CG  GLN    65      93.078  39.208  37.762  1.00 19.83           C  
ATOM  13355  CD  GLN    65      94.275  38.344  37.421  1.00 19.98           C  
ATOM  13356  OE1 GLN    65      94.942  37.792  38.312  1.00 23.49           O  
ATOM  13357  NE2 GLN    65      94.541  38.184  36.114  1.00 20.84           N  
ATOM  13358  N   ARG    66      90.789  39.194  41.835  1.00 20.27           N  
ATOM  13359  CA  ARG    66      89.877  38.774  42.884  1.00 19.80           C  
ATOM  13360  C   ARG    66      88.688  39.723  43.034  1.00 19.12           C  
ATOM  13361  O   ARG    66      87.559  39.289  43.213  1.00 18.72           O  
ATOM  13362  CB  ARG    66      90.597  38.676  44.215  1.00 21.46           C  
ATOM  13363  CG  ARG    66      89.674  38.205  45.361  1.00 25.65           C  
ATOM  13364  CD  ARG    66      89.298  36.727  45.200  1.00 36.25           C  
ATOM  13365  NE  ARG    66      90.392  35.890  45.691  1.00 41.73           N  
ATOM  13366  CZ  ARG    66      90.704  34.644  45.300  1.00 44.24           C  
ATOM  13367  NH1 ARG    66      90.018  33.988  44.357  1.00 45.76           N  
ATOM  13368  NH2 ARG    66      91.746  34.039  45.876  1.00 45.36           N  
ATOM  13369  N   ALA    67      88.915  41.023  42.911  1.00 18.19           N  
ATOM  13370  CA  ALA    67      87.776  41.975  42.854  1.00 17.76           C  
ATOM  13371  C   ALA    67      86.826  41.622  41.708  1.00 17.38           C  
ATOM  13372  O   ALA    67      85.599  41.617  41.892  1.00 17.68           O  
ATOM  13373  CB  ALA    67      88.270  43.434  42.700  1.00 18.27           C  
ATOM  13374  N   ALA    68      87.399  41.298  40.541  1.00 16.79           N  
ATOM  13375  CA  ALA    68      86.601  40.982  39.365  1.00 17.36           C  
ATOM  13376  C   ALA    68      85.816  39.681  39.613  1.00 17.31           C  
ATOM  13377  O   ALA    68      84.630  39.612  39.301  1.00 17.42           O  
ATOM  13378  CB  ALA    68      87.459  40.881  38.124  1.00 16.52           C  
ATOM  13379  N   GLU    69      86.469  38.683  40.196  1.00 17.93           N  
ATOM  13380  CA  GLU    69      85.784  37.441  40.576  1.00 18.71           C  
ATOM  13381  C   GLU    69      84.583  37.751  41.484  1.00 18.93           C  
ATOM  13382  O   GLU    69      83.471  37.242  41.241  1.00 18.31           O  
ATOM  13383  CB  GLU    69      86.757  36.477  41.251  1.00 19.08           C  
ATOM  13384  CG  GLU    69      87.806  35.902  40.322  1.00 21.15           C  
ATOM  13385  CD  GLU    69      88.858  35.066  41.051  1.00 22.14           C  
ATOM  13386  OE1 GLU    69      89.114  35.313  42.248  1.00 26.87           O  
ATOM  13387  OE2 GLU    69      89.424  34.144  40.439  1.00 27.07           O  
ATOM  13388  N   LEU    70      84.785  38.602  42.502  1.00 18.58           N  
ATOM  13389  CA  LEU    70      83.696  38.968  43.407  1.00 18.83           C  
ATOM  13390  C   LEU    70      82.568  39.708  42.680  1.00 19.23           C  
ATOM  13391  O   LEU    70      81.381  39.501  42.991  1.00 19.11           O  
ATOM  13392  CB  LEU    70      84.211  39.780  44.620  1.00 19.41           C  
ATOM  13393  CG  LEU    70      85.076  39.021  45.631  1.00 19.00           C  
ATOM  13394  CD1 LEU    70      85.801  39.978  46.576  1.00 19.47           C  
ATOM  13395  CD2 LEU    70      84.185  37.995  46.377  1.00 21.35           C  
ATOM  13396  N   CYS    71      82.915  40.595  41.740  1.00 18.39           N  
ATOM  13397  CA  CYS    71      81.884  41.296  40.973  1.00 18.21           C  
ATOM  13398  C   CYS    71      81.020  40.255  40.259  1.00 18.12           C  
ATOM  13399  O   CYS    71      79.783  40.380  40.219  1.00 18.48           O  
ATOM  13400  CB  CYS    71      82.523  42.263  39.959  1.00 18.28           C  
ATOM  13401  SG  CYS    71      83.354  43.707  40.748  1.00 17.98           S  
ATOM  13402  N   ALA    72      81.702  39.258  39.697  1.00 18.14           N  
ATOM  13403  CA  ALA    72      81.087  38.152  38.925  1.00 18.89           C  
ATOM  13404  C   ALA    72      80.191  37.309  39.820  1.00 19.05           C  
ATOM  13405  O   ALA    72      79.114  36.921  39.394  1.00 18.95           O  
ATOM  13406  CB  ALA    72      82.163  37.286  38.228  1.00 19.28           C  
ATOM  13407  N   VAL    73      80.632  37.045  41.048  1.00 19.61           N  
ATOM  13408  CA  VAL    73      79.815  36.298  42.031  1.00 20.01           C  
ATOM  13409  C   VAL    73      78.521  37.045  42.369  1.00 20.13           C  
ATOM  13410  O   VAL    73      77.428  36.449  42.460  1.00 20.48           O  
ATOM  13411  CB  VAL    73      80.633  36.004  43.330  1.00 20.82           C  
ATOM  13412  CG1 VAL    73      79.714  35.513  44.502  1.00 21.02           C  
ATOM  13413  CG2 VAL    73      81.772  35.052  43.029  1.00 19.80           C  
ATOM  13414  N   ASN    74      78.651  38.353  42.525  1.00 20.11           N  
ATOM  13415  CA  ASN    74      77.538  39.245  42.782  1.00 19.82           C  
ATOM  13416  C   ASN    74      76.578  39.319  41.600  1.00 19.58           C  
ATOM  13417  O   ASN    74      75.340  39.315  41.782  1.00 19.11           O  
ATOM  13418  CB  ASN    74      78.047  40.618  43.245  1.00 21.09           C  
ATOM  13419  CG  ASN    74      78.475  40.618  44.708  1.00 20.96           C  
ATOM  13420  OD1 ASN    74      79.667  40.497  45.044  1.00 25.84           O  
ATOM  13421  ND2 ASN    74      77.513  40.757  45.583  1.00 21.36           N  
ATOM  13422  N   ILE    75      77.117  39.332  40.385  1.00 19.22           N  
ATOM  13423  CA  ILE    75      76.266  39.262  39.188  1.00 19.73           C  
ATOM  13424  C   ILE    75      75.449  37.952  39.240  1.00 19.91           C  
ATOM  13425  O   ILE    75      74.232  37.959  39.042  1.00 21.28           O  
ATOM  13426  CB  ILE    75      77.082  39.318  37.856  1.00 20.26           C  
ATOM  13427  CG1 ILE    75      77.721  40.707  37.642  1.00 20.27           C  
ATOM  13428  CG2 ILE    75      76.193  38.957  36.665  1.00 18.77           C  
ATOM  13429  CD1 ILE    75      78.803  40.768  36.489  1.00 19.64           C  
ATOM  13430  N   LEU    76      76.126  36.852  39.510  1.00 20.16           N  
ATOM  13431  CA  LEU    76      75.459  35.515  39.533  1.00 20.33           C  
ATOM  13432  C   LEU    76      74.366  35.460  40.615  1.00 20.78           C  
ATOM  13433  O   LEU    76      73.297  34.907  40.379  1.00 21.42           O  
ATOM  13434  CB  LEU    76      76.486  34.394  39.689  1.00 20.53           C  
ATOM  13435  CG  LEU    76      77.372  34.118  38.484  1.00 20.87           C  
ATOM  13436  CD1 LEU    76      78.458  33.098  38.825  1.00 22.97           C  
ATOM  13437  CD2 LEU    76      76.544  33.679  37.260  1.00 23.02           C  
ATOM  13438  N   ALA    77      74.614  36.063  41.784  1.00 21.14           N  
ATOM  13439  CA  ALA    77      73.597  36.165  42.832  1.00 21.04           C  
ATOM  13440  C   ALA    77      72.361  36.891  42.300  1.00 21.95           C  
ATOM  13441  O   ALA    77      71.217  36.466  42.522  1.00 21.90           O  
ATOM  13442  CB  ALA    77      74.162  36.883  44.086  1.00 20.99           C  
ATOM  13443  N   GLN    78      72.587  37.993  41.581  1.00 21.45           N  
ATOM  13444  CA  GLN    78      71.473  38.745  41.023  1.00 22.10           C  
ATOM  13445  C   GLN    78      70.713  37.927  39.965  1.00 21.79           C  
ATOM  13446  O   GLN    78      69.486  37.929  39.936  1.00 22.55           O  
ATOM  13447  CB  GLN    78      71.950  40.077  40.422  1.00 22.09           C  
ATOM  13448  CG  GLN    78      72.508  41.105  41.436  1.00 24.22           C  
ATOM  13449  CD  GLN    78      71.567  41.457  42.585  1.00 27.40           C  
ATOM  13450  OE1 GLN    78      70.352  41.227  42.543  1.00 31.81           O  
ATOM  13451  NE2 GLN    78      72.141  42.054  43.621  1.00 33.24           N  
ATOM  13452  N   VAL    79      71.444  37.235  39.103  1.00 22.19           N  
ATOM  13453  CA  VAL    79      70.817  36.392  38.091  1.00 22.65           C  
ATOM  13454  C   VAL    79      69.980  35.285  38.732  1.00 23.28           C  
ATOM  13455  O   VAL    79      68.872  35.003  38.273  1.00 23.03           O  
ATOM  13456  CB  VAL    79      71.835  35.795  37.119  1.00 23.12           C  
ATOM  13457  CG1 VAL    79      71.136  34.895  36.134  1.00 23.37           C  
ATOM  13458  CG2 VAL    79      72.623  36.932  36.374  1.00 22.03           C  
ATOM  13459  N   LYS    80      70.507  34.673  39.779  1.00 23.69           N  
ATOM  13460  CA  LYS    80      69.799  33.611  40.478  1.00 24.34           C  
ATOM  13461  C   LYS    80      68.501  34.164  41.053  1.00 25.02           C  
ATOM  13462  O   LYS    80      67.442  33.517  40.935  1.00 25.88           O  
ATOM  13463  CB  LYS    80      70.672  33.018  41.576  1.00 24.54           C  
ATOM  13464  CG  LYS    80      69.980  31.893  42.358  1.00 24.65           C  
ATOM  13465  CD  LYS    80      70.809  31.421  43.510  1.00 25.01           C  
ATOM  13466  CE  LYS    80      69.995  30.487  44.426  1.00 26.39           C  
ATOM  13467  NZ  LYS    80      70.884  29.674  45.302  1.00 27.82           N  
ATOM  13468  N   ALA    81      68.564  35.351  41.664  1.00 25.16           N  
ATOM  13469  CA  ALA    81      67.346  36.048  42.148  1.00 25.31           C  
ATOM  13470  C   ALA    81      66.342  36.341  41.017  1.00 25.95           C  
ATOM  13471  O   ALA    81      65.141  36.042  41.158  1.00 25.62           O  
ATOM  13472  CB  ALA    81      67.697  37.329  42.899  1.00 25.25           C  
ATOM  13473  N   ALA    82      66.827  36.906  39.908  1.00 25.86           N  
ATOM  13474  CA  ALA    82      66.008  37.146  38.720  1.00 26.45           C  
ATOM  13475  C   ALA    82      65.358  35.846  38.201  1.00 26.96           C  
ATOM  13476  O   ALA    82      64.253  35.900  37.645  1.00 27.66           O  
ATOM  13477  CB  ALA    82      66.813  37.773  37.611  1.00 25.68           C  
ATOM  13478  N   LEU    83      66.034  34.712  38.370  1.00 27.25           N  
ATOM  13479  CA  LEU    83      65.568  33.458  37.785  1.00 28.53           C  
ATOM  13480  C   LEU    83      64.892  32.546  38.810  1.00 29.77           C  
ATOM  13481  O   LEU    83      64.768  31.322  38.610  1.00 29.23           O  
ATOM  13482  CB  LEU    83      66.721  32.761  37.070  1.00 28.68           C  
ATOM  13483  CG  LEU    83      67.336  33.509  35.875  1.00 27.34           C  
ATOM  13484  CD1 LEU    83      68.442  32.677  35.265  1.00 27.66           C  
ATOM  13485  CD2 LEU    83      66.303  33.910  34.809  1.00 26.22           C  
ATOM  13486  N   ASN    84      64.439  33.159  39.895  1.00 30.56           N  
ATOM  13487  CA  ASN    84      63.729  32.463  40.972  1.00 32.17           C  
ATOM  13488  C   ASN    84      64.473  31.244  41.527  1.00 32.90           C  
ATOM  13489  O   ASN    84      63.869  30.207  41.867  1.00 33.06           O  
ATOM  13490  CB  ASN    84      62.309  32.124  40.501  1.00 32.69           C  
ATOM  13491  CG  ASN    84      61.490  33.372  40.221  1.00 35.55           C  
ATOM  13492  OD1 ASN    84      60.912  33.525  39.134  1.00 41.64           O  
ATOM  13493  ND2 ASN    84      61.455  34.290  41.192  1.00 39.24           N  
ATOM  13494  N   GLY    85      65.789  31.382  41.634  1.00 33.09           N  
ATOM  13495  CA  GLY    85      66.645  30.371  42.227  1.00 33.47           C  
ATOM  13496  C   GLY    85      67.306  29.487  41.196  1.00 34.39           C  
ATOM  13497  O   GLY    85      68.029  28.555  41.537  1.00 35.05           O  
ATOM  13498  N   ASP    86      67.097  29.793  39.927  1.00 35.62           N  
ATOM  13499  CA  ASP    86      67.425  28.850  38.869  1.00 36.87           C  
ATOM  13500  C   ASP    86      68.531  29.305  37.873  1.00 36.44           C  
ATOM  13501  O   ASP    86      68.241  29.668  36.744  1.00 36.29           O  
ATOM  13502  CB  ASP    86      66.107  28.532  38.145  1.00 37.68           C  
ATOM  13503  CG  ASP    86      66.135  27.208  37.412  1.00 40.66           C  
ATOM  13504  OD1 ASP    86      67.157  26.494  37.471  1.00 44.08           O  
ATOM  13505  OD2 ASP    86      65.116  26.881  36.763  1.00 45.09           O  
ATOM  13506  N   LEU    87      69.796  29.225  38.285  1.00 36.56           N  
ATOM  13507  CA  LEU    87      70.940  29.570  37.412  1.00 36.56           C  
ATOM  13508  C   LEU    87      71.040  28.748  36.105  1.00 36.34           C  
ATOM  13509  O   LEU    87      71.796  29.096  35.196  1.00 35.79           O  
ATOM  13510  CB  LEU    87      72.272  29.500  38.182  1.00 36.86           C  
ATOM  13511  CG  LEU    87      72.623  30.693  39.091  1.00 36.88           C  
ATOM  13512  CD1 LEU    87      73.967  30.459  39.777  1.00 36.37           C  
ATOM  13513  CD2 LEU    87      72.640  32.048  38.326  1.00 36.15           C  
ATOM  13514  N   SER    88      70.275  27.665  36.024  1.00 36.37           N  
ATOM  13515  CA  SER    88      70.251  26.801  34.847  1.00 35.94           C  
ATOM  13516  C   SER    88      69.374  27.362  33.727  1.00 35.17           C  
ATOM  13517  O   SER    88      69.432  26.891  32.595  1.00 35.24           O  
ATOM  13518  CB  SER    88      69.754  25.418  35.260  1.00 36.16           C  
ATOM  13519  OG  SER    88      68.473  25.510  35.846  1.00 37.19           O  
ATOM  13520  N   LYS    89      68.583  28.382  34.056  1.00 34.43           N  
ATOM  13521  CA  LYS    89      67.792  29.109  33.080  1.00 33.77           C  
ATOM  13522  C   LYS    89      68.571  30.213  32.358  1.00 32.24           C  
ATOM  13523  O   LYS    89      67.994  30.935  31.545  1.00 32.12           O  
ATOM  13524  CB  LYS    89      66.543  29.690  33.739  1.00 34.20           C  
ATOM  13525  CG  LYS    89      65.489  28.606  34.078  1.00 35.37           C  
ATOM  13526  CD  LYS    89      64.197  29.224  34.590  1.00 36.03           C  
ATOM  13527  CE  LYS    89      63.040  28.177  34.705  1.00 37.98           C  
ATOM  13528  NZ  LYS    89      62.891  27.610  36.082  1.00 39.34           N  
ATOM  13529  N   ILE    90      69.865  30.341  32.642  1.00 30.91           N  
ATOM  13530  CA  ILE    90      70.740  31.151  31.793  1.00 30.51           C  
ATOM  13531  C   ILE    90      70.915  30.437  30.434  1.00 30.01           C  
ATOM  13532  O   ILE    90      71.329  29.275  30.387  1.00 31.25           O  
ATOM  13533  CB  ILE    90      72.141  31.392  32.445  1.00 30.19           C  
ATOM  13534  CG1 ILE    90      72.004  32.133  33.787  1.00 29.03           C  
ATOM  13535  CG2 ILE    90      73.086  32.137  31.461  1.00 29.03           C  
ATOM  13536  CD1 ILE    90      73.322  32.266  34.564  1.00 30.48           C  
ATOM  13537  N   ARG    91      70.602  31.114  29.336  1.00 28.51           N  
ATOM  13538  CA  ARG    91      70.882  30.563  28.010  1.00 29.50           C  
ATOM  13539  C   ARG    91      72.270  30.959  27.522  1.00 27.41           C  
ATOM  13540  O   ARG    91      73.007  30.149  26.963  1.00 25.76           O  
ATOM  13541  CB  ARG    91      69.802  30.984  27.021  1.00 29.42           C  
ATOM  13542  CG  ARG    91      68.469  30.319  27.356  1.00 33.12           C  
ATOM  13543  CD  ARG    91      67.261  30.999  26.705  1.00 35.92           C  
ATOM  13544  NE  ARG    91      67.355  31.013  25.251  1.00 43.12           N  
ATOM  13545  CZ  ARG    91      67.218  29.942  24.465  1.00 46.08           C  
ATOM  13546  NH1 ARG    91      66.945  28.734  24.973  1.00 47.97           N  
ATOM  13547  NH2 ARG    91      67.346  30.092  23.143  1.00 46.98           N  
ATOM  13548  N   ARG    92      72.634  32.203  27.780  1.00 25.79           N  
ATOM  13549  CA  ARG    92      73.916  32.748  27.347  1.00 25.72           C  
ATOM  13550  C   ARG    92      74.201  34.042  28.094  1.00 23.76           C  
ATOM  13551  O   ARG    92      73.289  34.873  28.245  1.00 22.58           O  
ATOM  13552  CB  ARG    92      73.835  33.054  25.862  1.00 26.82           C  
ATOM  13553  CG  ARG    92      74.885  33.989  25.316  1.00 31.69           C  
ATOM  13554  CD  ARG    92      75.607  33.399  24.154  1.00 37.13           C  
ATOM  13555  NE  ARG    92      76.890  32.858  24.594  1.00 40.03           N  
ATOM  13556  CZ  ARG    92      77.376  31.648  24.306  1.00 42.08           C  
ATOM  13557  NH1 ARG    92      76.702  30.777  23.546  1.00 43.85           N  
ATOM  13558  NH2 ARG    92      78.569  31.303  24.771  1.00 40.04           N  
ATOM  13559  N   VAL    93      75.433  34.184  28.586  1.00 21.68           N  
ATOM  13560  CA  VAL    93      75.905  35.473  29.055  1.00 20.41           C  
ATOM  13561  C   VAL    93      76.303  36.221  27.782  1.00 20.28           C  
ATOM  13562  O   VAL    93      77.259  35.856  27.069  1.00 21.18           O  
ATOM  13563  CB  VAL    93      77.080  35.374  30.075  1.00 20.10           C  
ATOM  13564  CG1 VAL    93      77.543  36.778  30.511  1.00 20.34           C  
ATOM  13565  CG2 VAL    93      76.685  34.513  31.307  1.00 20.35           C  
ATOM  13566  N   ILE    94      75.543  37.252  27.472  1.00 19.62           N  
ATOM  13567  CA  ILE    94      75.707  37.970  26.218  1.00 19.82           C  
ATOM  13568  C   ILE    94      76.892  38.962  26.232  1.00 19.77           C  
ATOM  13569  O   ILE    94      77.686  39.016  25.272  1.00 19.63           O  
ATOM  13570  CB  ILE    94      74.405  38.688  25.859  1.00 20.18           C  
ATOM  13571  CG1 ILE    94      73.341  37.638  25.511  1.00 21.26           C  
ATOM  13572  CG2 ILE    94      74.574  39.644  24.658  1.00 20.74           C  
ATOM  13573  CD1 ILE    94      73.669  36.882  24.212  1.00 25.02           C  
ATOM  13574  N   LYS    95      77.009  39.701  27.338  1.00 19.20           N  
ATOM  13575  CA  LYS    95      77.963  40.817  27.444  1.00 18.28           C  
ATOM  13576  C   LYS    95      78.268  41.140  28.913  1.00 18.11           C  
ATOM  13577  O   LYS    95      77.377  41.166  29.740  1.00 17.68           O  
ATOM  13578  CB  LYS    95      77.362  42.031  26.756  1.00 18.02           C  
ATOM  13579  CG  LYS    95      78.180  43.334  26.821  1.00 18.92           C  
ATOM  13580  CD  LYS    95      79.388  43.233  25.899  1.00 17.97           C  
ATOM  13581  CE  LYS    95      80.246  44.514  25.891  1.00 19.41           C  
ATOM  13582  NZ  LYS    95      79.470  45.692  25.394  1.00 20.19           N  
ATOM  13583  N   LEU    96      79.537  41.389  29.220  1.00 18.19           N  
ATOM  13584  CA  LEU    96      79.951  41.957  30.513  1.00 17.80           C  
ATOM  13585  C   LEU    96      80.658  43.271  30.202  1.00 17.10           C  
ATOM  13586  O   LEU    96      81.468  43.325  29.258  1.00 17.15           O  
ATOM  13587  CB  LEU    96      80.942  41.045  31.244  1.00 18.83           C  
ATOM  13588  CG  LEU    96      80.585  39.667  31.800  1.00 20.85           C  
ATOM  13589  CD1 LEU    96      81.711  39.277  32.729  1.00 22.50           C  
ATOM  13590  CD2 LEU    96      79.206  39.674  32.520  1.00 21.93           C  
ATOM  13591  N   ASN    97      80.329  44.321  30.946  1.00 16.61           N  
ATOM  13592  CA  ASN    97      81.130  45.529  30.906  1.00 16.14           C  
ATOM  13593  C   ASN    97      81.933  45.623  32.183  1.00 15.02           C  
ATOM  13594  O   ASN    97      81.375  45.796  33.268  1.00 14.66           O  
ATOM  13595  CB  ASN    97      80.289  46.767  30.662  1.00 16.88           C  
ATOM  13596  CG  ASN    97      79.486  46.689  29.385  1.00 18.53           C  
ATOM  13597  OD1 ASN    97      78.257  46.535  29.404  1.00 23.42           O  
ATOM  13598  ND2 ASN    97      80.171  46.786  28.273  1.00 15.75           N  
ATOM  13599  N   GLY    98      83.256  45.563  32.012  1.00 14.82           N  
ATOM  13600  CA  GLY    98      84.185  45.561  33.119  1.00 15.02           C  
ATOM  13601  C   GLY    98      84.852  46.915  33.285  1.00 15.44           C  
ATOM  13602  O   GLY    98      85.617  47.349  32.412  1.00 16.65           O  
ATOM  13603  N   PHE    99      84.542  47.593  34.386  1.00 15.14           N  
ATOM  13604  CA  PHE    99      85.102  48.870  34.692  1.00 14.44           C  
ATOM  13605  C   PHE    99      86.167  48.697  35.768  1.00 14.30           C  
ATOM  13606  O   PHE    99      85.866  48.199  36.872  1.00 14.95           O  
ATOM  13607  CB  PHE    99      83.973  49.765  35.171  1.00 15.41           C  
ATOM  13608  CG  PHE    99      82.790  49.765  34.262  1.00 16.64           C  
ATOM  13609  CD1 PHE    99      82.914  50.201  32.953  1.00 22.14           C  
ATOM  13610  CD2 PHE    99      81.554  49.354  34.715  1.00 19.51           C  
ATOM  13611  CE1 PHE    99      81.807  50.224  32.110  1.00 22.73           C  
ATOM  13612  CE2 PHE    99      80.456  49.391  33.888  1.00 20.40           C  
ATOM  13613  CZ  PHE    99      80.577  49.822  32.604  1.00 19.17           C  
ATOM  13614  N   VAL   100      87.401  49.093  35.463  1.00 12.97           N  
ATOM  13615  CA  VAL   100      88.533  48.945  36.395  1.00 13.47           C  
ATOM  13616  C   VAL   100      89.113  50.315  36.797  1.00 13.53           C  
ATOM  13617  O   VAL   100      89.639  51.033  35.962  1.00 13.48           O  
ATOM  13618  CB  VAL   100      89.674  48.129  35.768  1.00 12.63           C  
ATOM  13619  CG1 VAL   100      90.810  47.914  36.819  1.00 13.13           C  
ATOM  13620  CG2 VAL   100      89.172  46.827  35.121  1.00 14.55           C  
ATOM  13621  N   ALA   101      89.018  50.651  38.073  1.00 13.61           N  
ATOM  13622  CA  ALA   101      89.573  51.922  38.591  1.00 13.39           C  
ATOM  13623  C   ALA   101      91.080  51.820  38.411  1.00 13.93           C  
ATOM  13624  O   ALA   101      91.703  50.866  38.925  1.00 12.78           O  
ATOM  13625  CB  ALA   101      89.195  52.132  40.064  1.00 13.54           C  
ATOM  13626  N   SER   102      91.652  52.751  37.644  1.00 13.96           N  
ATOM  13627  CA  SER   102      93.014  52.597  37.122  1.00 13.76           C  
ATOM  13628  C   SER   102      93.783  53.879  37.237  1.00 13.85           C  
ATOM  13629  O   SER   102      93.239  54.942  37.020  1.00 13.85           O  
ATOM  13630  CB  SER   102      92.952  52.234  35.615  1.00 13.46           C  
ATOM  13631  OG  SER   102      92.318  50.995  35.346  1.00 15.64           O  
ATOM  13632  N   VAL   103      95.081  53.795  37.542  1.00 14.08           N  
ATOM  13633  CA  VAL   103      95.940  54.957  37.235  1.00 13.49           C  
ATOM  13634  C   VAL   103      96.211  54.943  35.728  1.00 14.32           C  
ATOM  13635  O   VAL   103      96.076  53.907  35.086  1.00 14.13           O  
ATOM  13636  CB  VAL   103      97.260  54.995  38.049  1.00 13.45           C  
ATOM  13637  CG1 VAL   103      96.964  55.212  39.528  1.00 13.30           C  
ATOM  13638  CG2 VAL   103      98.085  53.757  37.857  1.00 14.31           C  
ATOM  13639  N   PRO   104      96.528  56.120  35.158  1.00 14.49           N  
ATOM  13640  CA  PRO   104      96.705  56.218  33.710  1.00 15.18           C  
ATOM  13641  C   PRO   104      97.820  55.375  33.100  1.00 15.45           C  
ATOM  13642  O   PRO   104      97.786  55.109  31.890  1.00 17.16           O  
ATOM  13643  CB  PRO   104      96.935  57.712  33.487  1.00 15.35           C  
ATOM  13644  CG  PRO   104      96.279  58.366  34.685  1.00 16.48           C  
ATOM  13645  CD  PRO   104      96.631  57.440  35.786  1.00 15.15           C  
ATOM  13646  N   GLU   105      98.781  54.941  33.908  1.00 15.63           N  
ATOM  13647  CA  GLU   105      99.839  54.061  33.433  1.00 14.99           C  
ATOM  13648  C   GLU   105      99.426  52.591  33.472  1.00 15.57           C  
ATOM  13649  O   GLU   105     100.143  51.745  32.983  1.00 15.51           O  
ATOM  13650  CB  GLU   105     101.129  54.233  34.247  1.00 15.82           C  
ATOM  13651  CG  GLU   105     101.751  55.606  34.111  1.00 14.48           C  
ATOM  13652  CD  GLU   105     100.908  56.711  34.727  1.00 14.59           C  
ATOM  13653  OE1 GLU   105     100.406  56.563  35.871  1.00 15.16           O  
ATOM  13654  OE2 GLU   105     100.751  57.745  34.035  1.00 15.78           O  
ATOM  13655  N   PHE   106      98.296  52.297  34.120  1.00 15.66           N  
ATOM  13656  CA  PHE   106      97.815  50.921  34.211  1.00 15.19           C  
ATOM  13657  C   PHE   106      97.034  50.567  32.952  1.00 15.21           C  
ATOM  13658  O   PHE   106      96.053  51.238  32.616  1.00 15.33           O  
ATOM  13659  CB  PHE   106      96.970  50.643  35.451  1.00 15.12           C  
ATOM  13660  CG  PHE   106      96.527  49.222  35.524  1.00 14.69           C  
ATOM  13661  CD1 PHE   106      97.460  48.191  35.776  1.00 13.97           C  
ATOM  13662  CD2 PHE   106      95.195  48.878  35.251  1.00 14.24           C  
ATOM  13663  CE1 PHE   106      97.055  46.849  35.796  1.00 16.21           C  
ATOM  13664  CE2 PHE   106      94.808  47.554  35.251  1.00 16.36           C  
ATOM  13665  CZ  PHE   106      95.711  46.545  35.530  1.00 15.69           C  
ATOM  13666  N   VAL   107      97.492  49.515  32.274  1.00 15.49           N  
ATOM  13667  CA  VAL   107      96.959  49.139  30.942  1.00 15.51           C  
ATOM  13668  C   VAL   107      96.660  47.626  30.810  1.00 16.14           C  
ATOM  13669  O   VAL   107      96.676  47.065  29.678  1.00 17.46           O  
ATOM  13670  CB  VAL   107      97.875  49.636  29.813  1.00 15.35           C  
ATOM  13671  CG1 VAL   107      97.910  51.181  29.745  1.00 16.15           C  
ATOM  13672  CG2 VAL   107      99.308  49.001  29.940  1.00 17.34           C  
ATOM  13673  N   GLU   108      96.342  46.976  31.937  1.00 15.75           N  
ATOM  13674  CA  GLU   108      96.023  45.560  31.913  1.00 16.38           C  
ATOM  13675  C   GLU   108      94.628  45.285  32.422  1.00 15.43           C  
ATOM  13676  O   GLU   108      94.352  44.262  33.088  1.00 16.13           O  
ATOM  13677  CB  GLU   108      97.076  44.777  32.693  1.00 16.44           C  
ATOM  13678  CG  GLU   108      98.436  44.788  32.033  1.00 19.85           C  
ATOM  13679  CD  GLU   108      99.523  44.263  32.973  1.00 20.58           C  
ATOM  13680  OE1 GLU   108      99.742  44.801  34.079  1.00 29.71           O  
ATOM  13681  OE2 GLU   108     100.165  43.306  32.588  1.00 28.76           O  
ATOM  13682  N   GLN   109      93.705  46.167  32.065  1.00 15.62           N  
ATOM  13683  CA  GLN   109      92.320  45.982  32.468  1.00 15.33           C  
ATOM  13684  C   GLN   109      91.738  44.684  31.902  1.00 15.79           C  
ATOM  13685  O   GLN   109      90.865  44.105  32.513  1.00 16.28           O  
ATOM  13686  CB  GLN   109      91.473  47.148  32.024  1.00 15.81           C  
ATOM  13687  CG  GLN   109      91.813  48.476  32.661  1.00 14.14           C  
ATOM  13688  CD  GLN   109      92.960  49.238  31.952  1.00 15.09           C  
ATOM  13689  OE1 GLN   109      93.533  48.780  30.938  1.00 14.45           O  
ATOM  13690  NE2 GLN   109      93.277  50.409  32.470  1.00 14.52           N  
ATOM  13691  N   HIS   110      92.217  44.249  30.747  1.00 15.52           N  
ATOM  13692  CA  HIS   110      91.773  42.945  30.180  1.00 15.97           C  
ATOM  13693  C   HIS   110      92.129  41.795  31.114  1.00 15.78           C  
ATOM  13694  O   HIS   110      91.333  40.912  31.357  1.00 16.32           O  
ATOM  13695  CB  HIS   110      92.311  42.739  28.739  1.00 16.72           C  
ATOM  13696  CG  HIS   110      93.809  42.789  28.627  1.00 17.04           C  
ATOM  13697  ND1 HIS   110      94.550  43.909  28.945  1.00 19.60           N  
ATOM  13698  CD2 HIS   110      94.705  41.843  28.259  1.00 22.76           C  
ATOM  13699  CE1 HIS   110      95.839  43.643  28.780  1.00 20.17           C  
ATOM  13700  NE2 HIS   110      95.958  42.394  28.373  1.00 21.32           N  
ATOM  13701  N   LEU   111      93.330  41.821  31.669  1.00 16.38           N  
ATOM  13702  CA  LEU   111      93.763  40.836  32.657  1.00 16.96           C  
ATOM  13703  C   LEU   111      92.924  40.851  33.932  1.00 17.46           C  
ATOM  13704  O   LEU   111      92.575  39.786  34.492  1.00 19.02           O  
ATOM  13705  CB  LEU   111      95.239  41.050  32.982  1.00 17.06           C  
ATOM  13706  CG  LEU   111      96.187  40.875  31.779  1.00 17.72           C  
ATOM  13707  CD1 LEU   111      97.635  40.909  32.274  1.00 21.15           C  
ATOM  13708  CD2 LEU   111      95.918  39.613  30.974  1.00 21.14           C  
ATOM  13709  N   VAL   112      92.592  42.051  34.377  1.00 16.80           N  
ATOM  13710  CA  VAL   112      91.777  42.181  35.584  1.00 16.34           C  
ATOM  13711  C   VAL   112      90.397  41.535  35.335  1.00 16.45           C  
ATOM  13712  O   VAL   112      89.895  40.762  36.156  1.00 17.06           O  
ATOM  13713  CB  VAL   112      91.648  43.658  36.010  1.00 16.03           C  
ATOM  13714  CG1 VAL   112      90.570  43.824  37.097  1.00 14.54           C  
ATOM  13715  CG2 VAL   112      93.046  44.189  36.451  1.00 14.52           C  
ATOM  13716  N   ILE   113      89.783  41.862  34.211  1.00 16.33           N  
ATOM  13717  CA  ILE   113      88.418  41.383  33.939  1.00 16.57           C  
ATOM  13718  C   ILE   113      88.426  39.871  33.602  1.00 17.38           C  
ATOM  13719  O   ILE   113      87.418  39.207  33.835  1.00 17.79           O  
ATOM  13720  CB  ILE   113      87.684  42.255  32.877  1.00 16.97           C  
ATOM  13721  CG1 ILE   113      87.591  43.715  33.353  1.00 16.42           C  
ATOM  13722  CG2 ILE   113      86.275  41.686  32.506  1.00 16.23           C  
ATOM  13723  CD1 ILE   113      86.973  43.943  34.754  1.00 15.38           C  
ATOM  13724  N   ASN   114      89.573  39.326  33.152  1.00 17.62           N  
ATOM  13725  CA  ASN   114      89.721  37.861  33.017  1.00 18.16           C  
ATOM  13726  C   ASN   114      89.370  37.165  34.320  1.00 18.57           C  
ATOM  13727  O   ASN   114      88.867  36.056  34.301  1.00 19.99           O  
ATOM  13728  CB  ASN   114      91.130  37.469  32.547  1.00 18.52           C  
ATOM  13729  CG  ASN   114      91.406  37.829  31.083  1.00 20.10           C  
ATOM  13730  OD1 ASN   114      90.494  38.167  30.316  1.00 22.14           O  
ATOM  13731  ND2 ASN   114      92.665  37.744  30.689  1.00 20.05           N  
ATOM  13732  N   GLY   115      89.585  37.808  35.469  1.00 18.91           N  
ATOM  13733  CA  GLY   115      89.088  37.293  36.757  1.00 19.18           C  
ATOM  13734  C   GLY   115      87.609  36.931  36.679  1.00 19.79           C  
ATOM  13735  O   GLY   115      87.233  35.782  36.939  1.00 21.14           O  
ATOM  13736  N   ALA   116      86.771  37.891  36.267  1.00 19.18           N  
ATOM  13737  CA  ALA   116      85.331  37.638  36.074  1.00 18.73           C  
ATOM  13738  C   ALA   116      85.078  36.648  34.944  1.00 18.77           C  
ATOM  13739  O   ALA   116      84.318  35.704  35.117  1.00 18.13           O  
ATOM  13740  CB  ALA   116      84.563  38.940  35.818  1.00 17.60           C  
ATOM  13741  N   SER   117      85.690  36.872  33.792  1.00 19.29           N  
ATOM  13742  CA  SER   117      85.366  36.092  32.582  1.00 20.10           C  
ATOM  13743  C   SER   117      85.670  34.595  32.784  1.00 20.77           C  
ATOM  13744  O   SER   117      84.865  33.722  32.435  1.00 21.97           O  
ATOM  13745  CB  SER   117      86.103  36.640  31.358  1.00 19.41           C  
ATOM  13746  OG  SER   117      85.662  37.947  31.006  1.00 19.65           O  
ATOM  13747  N   ASN   118      86.810  34.313  33.389  1.00 21.80           N  
ATOM  13748  CA  ASN   118      87.247  32.938  33.669  1.00 21.92           C  
ATOM  13749  C   ASN   118      86.341  32.220  34.666  1.00 22.29           C  
ATOM  13750  O   ASN   118      86.014  31.026  34.477  1.00 23.85           O  
ATOM  13751  CB  ASN   118      88.672  32.936  34.193  1.00 22.14           C  
ATOM  13752  CG  ASN   118      89.692  33.319  33.143  1.00 23.36           C  
ATOM  13753  OD1 ASN   118      89.434  33.295  31.932  1.00 27.40           O  
ATOM  13754  ND2 ASN   118      90.877  33.671  33.606  1.00 27.49           N  
ATOM  13755  N   LEU   119      85.917  32.940  35.707  1.00 22.44           N  
ATOM  13756  CA  LEU   119      85.007  32.396  36.709  1.00 22.17           C  
ATOM  13757  C   LEU   119      83.654  32.058  36.071  1.00 22.24           C  
ATOM  13758  O   LEU   119      83.123  30.945  36.218  1.00 21.77           O  
ATOM  13759  CB  LEU   119      84.863  33.385  37.882  1.00 21.87           C  
ATOM  13760  CG  LEU   119      83.954  32.950  39.040  1.00 21.57           C  
ATOM  13761  CD1 LEU   119      84.343  33.550  40.394  1.00 22.43           C  
ATOM  13762  CD2 LEU   119      82.466  33.213  38.687  1.00 19.84           C  
ATOM  13763  N   ILE   120      83.100  33.014  35.340  1.00 22.68           N  
ATOM  13764  CA  ILE   120      81.797  32.834  34.691  1.00 23.03           C  
ATOM  13765  C   ILE   120      81.822  31.671  33.672  1.00 22.73           C  
ATOM  13766  O   ILE   120      80.921  30.827  33.672  1.00 22.74           O  
ATOM  13767  CB  ILE   120      81.304  34.189  34.057  1.00 22.50           C  
ATOM  13768  CG1 ILE   120      80.907  35.152  35.199  1.00 23.42           C  
ATOM  13769  CG2 ILE   120      80.119  33.969  33.092  1.00 23.23           C  
ATOM  13770  CD1 ILE   120      80.713  36.598  34.811  1.00 24.45           C  
ATOM  13771  N   ALA   121      82.859  31.598  32.846  1.00 22.93           N  
ATOM  13772  CA  ALA   121      82.995  30.525  31.867  1.00 23.71           C  
ATOM  13773  C   ALA   121      83.172  29.164  32.552  1.00 24.46           C  
ATOM  13774  O   ALA   121      82.589  28.167  32.118  1.00 24.40           O  
ATOM  13775  CB  ALA   121      84.153  30.806  30.923  1.00 24.16           C  
ATOM  13776  N   THR   122      83.934  29.146  33.646  1.00 25.07           N  
ATOM  13777  CA  THR   122      84.155  27.929  34.423  1.00 25.52           C  
ATOM  13778  C   THR   122      82.873  27.370  35.045  1.00 25.94           C  
ATOM  13779  O   THR   122      82.621  26.176  34.942  1.00 27.29           O  
ATOM  13780  CB  THR   122      85.229  28.151  35.493  1.00 25.67           C  
ATOM  13781  OG1 THR   122      86.465  28.470  34.828  1.00 25.67           O  
ATOM  13782  CG2 THR   122      85.404  26.905  36.403  1.00 25.84           C  
ATOM  13783  N   VAL   123      82.070  28.205  35.692  1.00 25.64           N  
ATOM  13784  CA  VAL   123      80.892  27.707  36.398  1.00 25.47           C  
ATOM  13785  C   VAL   123      79.727  27.416  35.437  1.00 25.14           C  
ATOM  13786  O   VAL   123      78.923  26.530  35.706  1.00 25.86           O  
ATOM  13787  CB  VAL   123      80.457  28.640  37.539  1.00 25.42           C  
ATOM  13788  CG1 VAL   123      81.594  28.801  38.558  1.00 25.65           C  
ATOM  13789  CG2 VAL   123      79.991  29.985  37.025  1.00 25.96           C  
ATOM  13790  N   LEU   124      79.648  28.132  34.316  1.00 25.53           N  
ATOM  13791  CA  LEU   124      78.543  27.974  33.358  1.00 25.86           C  
ATOM  13792  C   LEU   124      78.893  27.133  32.121  1.00 26.58           C  
ATOM  13793  O   LEU   124      77.992  26.702  31.399  1.00 27.85           O  
ATOM  13794  CB  LEU   124      78.016  29.354  32.906  1.00 25.67           C  
ATOM  13795  CG  LEU   124      77.392  30.242  34.005  1.00 25.75           C  
ATOM  13796  CD1 LEU   124      76.923  31.620  33.473  1.00 24.79           C  
ATOM  13797  CD2 LEU   124      76.239  29.529  34.730  1.00 24.67           C  
ATOM  13798  N   GLY   125      80.171  26.905  31.855  1.00 26.92           N  
ATOM  13799  CA  GLY   125      80.601  26.262  30.617  1.00 27.47           C  
ATOM  13800  C   GLY   125      80.400  27.153  29.401  1.00 28.59           C  
ATOM  13801  O   GLY   125      80.450  28.395  29.501  1.00 27.96           O  
ATOM  13802  N   GLU   126      80.145  26.533  28.247  1.00 29.57           N  
ATOM  13803  CA  GLU   126      80.046  27.272  26.987  1.00 29.15           C  
ATOM  13804  C   GLU   126      79.064  28.438  27.036  1.00 28.94           C  
ATOM  13805  O   GLU   126      79.378  29.497  26.491  1.00 29.44           O  
ATOM  13806  CB  GLU   126      79.695  26.340  25.813  1.00 31.00           C  
ATOM  13807  CG  GLU   126      79.198  27.036  24.521  1.00 32.78           C  
ATOM  13808  CD  GLU   126      80.275  27.849  23.846  1.00 39.95           C  
ATOM  13809  OE1 GLU   126      81.484  27.537  24.067  1.00 43.72           O  
ATOM  13810  OE2 GLU   126      79.914  28.797  23.096  1.00 44.33           O  
ATOM  13811  N   PRO   127      77.872  28.252  27.641  1.00 28.35           N  
ATOM  13812  CA  PRO   127      76.944  29.395  27.735  1.00 27.52           C  
ATOM  13813  C   PRO   127      77.493  30.606  28.480  1.00 26.17           C  
ATOM  13814  O   PRO   127      76.951  31.708  28.316  1.00 25.23           O  
ATOM  13815  CB  PRO   127      75.769  28.854  28.541  1.00 27.48           C  
ATOM  13816  CG  PRO   127      75.825  27.360  28.369  1.00 28.37           C  
ATOM  13817  CD  PRO   127      77.274  27.013  28.195  1.00 29.33           C  
ATOM  13818  N   GLY   128      78.509  30.381  29.316  1.00 24.90           N  
ATOM  13819  CA  GLY   128      79.160  31.456  30.029  1.00 24.87           C  
ATOM  13820  C   GLY   128      80.076  32.338  29.192  1.00 24.95           C  
ATOM  13821  O   GLY   128      80.490  33.405  29.683  1.00 25.60           O  
ATOM  13822  N   ARG   129      80.434  31.920  27.974  1.00 24.08           N  
ATOM  13823  CA  ARG   129      81.368  32.698  27.159  1.00 24.96           C  
ATOM  13824  C   ARG   129      80.614  33.880  26.582  1.00 23.19           C  
ATOM  13825  O   ARG   129      79.509  33.733  26.062  1.00 23.19           O  
ATOM  13826  CB  ARG   129      81.996  31.866  26.065  1.00 25.42           C  
ATOM  13827  CG  ARG   129      82.821  30.711  26.608  1.00 27.86           C  
ATOM  13828  CD  ARG   129      83.309  29.877  25.472  1.00 29.98           C  
ATOM  13829  NE  ARG   129      84.510  30.430  24.867  1.00 34.49           N  
ATOM  13830  CZ  ARG   129      84.825  30.292  23.581  1.00 36.05           C  
ATOM  13831  NH1 ARG   129      84.003  29.656  22.751  1.00 39.31           N  
ATOM  13832  NH2 ARG   129      85.952  30.809  23.108  1.00 35.44           N  
ATOM  13833  N   HIS   130      81.207  35.062  26.690  1.00 21.17           N  
ATOM  13834  CA  HIS   130      80.479  36.305  26.497  1.00 19.81           C  
ATOM  13835  C   HIS   130      81.292  37.340  25.734  1.00 18.95           C  
ATOM  13836  O   HIS   130      82.515  37.310  25.762  1.00 19.32           O  
ATOM  13837  CB  HIS   130      80.174  36.874  27.875  1.00 19.15           C  
ATOM  13838  CG  HIS   130      81.373  36.896  28.779  1.00 19.27           C  
ATOM  13839  ND1 HIS   130      81.715  35.823  29.575  1.00 18.83           N  
ATOM  13840  CD2 HIS   130      82.352  37.826  28.960  1.00 18.82           C  
ATOM  13841  CE1 HIS   130      82.841  36.093  30.215  1.00 19.50           C  
ATOM  13842  NE2 HIS   130      83.245  37.304  29.863  1.00 18.38           N  
ATOM  13843  N   ALA   131      80.591  38.238  25.056  1.00 18.23           N  
ATOM  13844  CA  ALA   131      81.198  39.483  24.562  1.00 17.93           C  
ATOM  13845  C   ALA   131      81.615  40.331  25.788  1.00 17.63           C  
ATOM  13846  O   ALA   131      81.145  40.128  26.900  1.00 18.26           O  
ATOM  13847  CB  ALA   131      80.243  40.256  23.664  1.00 17.85           C  
ATOM  13848  N   ARG   132      82.489  41.306  25.575  1.00 18.24           N  
ATOM  13849  CA  ARG   132      83.035  42.036  26.695  1.00 18.04           C  
ATOM  13850  C   ARG   132      83.617  43.385  26.284  1.00 17.43           C  
ATOM  13851  O   ARG   132      84.088  43.565  25.163  1.00 16.62           O  
ATOM  13852  CB  ARG   132      84.181  41.242  27.282  1.00 17.74           C  
ATOM  13853  CG  ARG   132      84.379  41.473  28.719  1.00 21.52           C  
ATOM  13854  CD  ARG   132      85.559  40.622  29.271  1.00 20.37           C  
ATOM  13855  NE  ARG   132      86.903  41.031  28.837  1.00 22.76           N  
ATOM  13856  CZ  ARG   132      88.019  40.471  29.328  1.00 21.32           C  
ATOM  13857  NH1 ARG   132      87.918  39.544  30.236  1.00 20.78           N  
ATOM  13858  NH2 ARG   132      89.223  40.856  28.939  1.00 22.78           N  
ATOM  13859  N   ALA   133      83.650  44.285  27.244  1.00 16.82           N  
ATOM  13860  CA  ALA   133      84.489  45.509  27.180  1.00 17.17           C  
ATOM  13861  C   ALA   133      85.251  45.582  28.508  1.00 16.48           C  
ATOM  13862  O   ALA   133      84.736  45.177  29.538  1.00 16.92           O  
ATOM  13863  CB  ALA   133      83.642  46.745  26.979  1.00 17.02           C  
ATOM  13864  N   ALA   134      86.494  46.049  28.468  1.00 16.84           N  
ATOM  13865  CA  ALA   134      87.303  46.207  29.665  1.00 16.59           C  
ATOM  13866  C   ALA   134      87.964  47.583  29.548  1.00 16.64           C  
ATOM  13867  O   ALA   134      88.695  47.845  28.578  1.00 17.05           O  
ATOM  13868  CB  ALA   134      88.348  45.119  29.805  1.00 17.16           C  
ATOM  13869  N   VAL   135      87.689  48.463  30.496  1.00 16.16           N  
ATOM  13870  CA  VAL   135      88.099  49.863  30.393  1.00 15.33           C  
ATOM  13871  C   VAL   135      88.602  50.422  31.715  1.00 15.04           C  
ATOM  13872  O   VAL   135      88.202  49.980  32.779  1.00 16.55           O  
ATOM  13873  CB  VAL   135      86.942  50.718  29.835  1.00 15.27           C  
ATOM  13874  CG1 VAL   135      86.621  50.279  28.369  1.00 15.28           C  
ATOM  13875  CG2 VAL   135      85.715  50.631  30.750  1.00 18.02           C  
ATOM  13876  N   GLY   136      89.451  51.440  31.644  1.00 14.42           N  
ATOM  13877  CA  GLY   136      90.007  52.072  32.833  1.00 14.05           C  
ATOM  13878  C   GLY   136      89.283  53.347  33.238  1.00 14.66           C  
ATOM  13879  O   GLY   136      89.192  54.307  32.461  1.00 16.32           O  
ATOM  13880  N   MET   137      88.838  53.366  34.492  1.00 15.74           N  
ATOM  13881  CA  MET   137      88.019  54.428  35.067  1.00 15.53           C  
ATOM  13882  C   MET   137      88.883  55.286  36.016  1.00 14.55           C  
ATOM  13883  O   MET   137      89.870  54.808  36.569  1.00 14.21           O  
ATOM  13884  CB  MET   137      86.856  53.860  35.881  1.00 17.67           C  
ATOM  13885  CG  MET   137      86.263  52.643  35.390  1.00 23.71           C  
ATOM  13886  SD  MET   137      85.665  52.752  33.523  1.00 32.58          SE  
ATOM  13887  CE  MET   137      84.716  54.461  33.938  1.00 19.25           C  
ATOM  13888  N   ALA   138      88.476  56.527  36.234  1.00 13.88           N  
ATOM  13889  CA  ALA   138      89.141  57.440  37.178  1.00 14.06           C  
ATOM  13890  C   ALA   138      88.955  56.936  38.616  1.00 14.04           C  
ATOM  13891  O   ALA   138      89.862  57.017  39.449  1.00 13.62           O  
ATOM  13892  CB  ALA   138      88.610  58.875  37.047  1.00 13.96           C  
ATOM  13893  N   SER   139      87.774  56.379  38.876  1.00 14.58           N  
ATOM  13894  CA  SER   139      87.388  55.917  40.210  1.00 15.14           C  
ATOM  13895  C   SER   139      85.992  55.291  40.117  1.00 14.88           C  
ATOM  13896  O   SER   139      85.324  55.457  39.108  1.00 14.48           O  
ATOM  13897  CB  SER   139      87.394  57.083  41.230  1.00 15.80           C  
ATOM  13898  OG  SER   139      86.720  58.247  40.755  1.00 16.73           O  
ATOM  13899  N   LEU   140      85.553  54.651  41.200  1.00 15.44           N  
ATOM  13900  CA  LEU   140      84.237  53.954  41.240  1.00 15.36           C  
ATOM  13901  C   LEU   140      83.547  54.180  42.597  1.00 15.58           C  
ATOM  13902  O   LEU   140      84.208  54.523  43.587  1.00 15.56           O  
ATOM  13903  CB  LEU   140      84.409  52.450  40.962  1.00 15.93           C  
ATOM  13904  CG  LEU   140      84.909  52.035  39.582  1.00 15.60           C  
ATOM  13905  CD1 LEU   140      85.286  50.549  39.605  1.00 15.22           C  
ATOM  13906  CD2 LEU   140      83.852  52.382  38.482  1.00 15.08           C  
ATOM  13907  N   PRO   141      82.211  54.021  42.644  1.00 15.44           N  
ATOM  13908  CA  PRO   141      81.453  54.136  43.911  1.00 16.14           C  
ATOM  13909  C   PRO   141      82.110  53.334  45.044  1.00 15.92           C  
ATOM  13910  O   PRO   141      82.581  52.199  44.826  1.00 16.30           O  
ATOM  13911  CB  PRO   141      80.075  53.575  43.548  1.00 15.94           C  
ATOM  13912  CG  PRO   141      79.935  53.831  42.101  1.00 15.45           C  
ATOM  13913  CD  PRO   141      81.316  53.727  41.508  1.00 15.64           C  
ATOM  13914  N   PHE   142      82.170  53.939  46.230  1.00 16.28           N  
ATOM  13915  CA  PHE   142      82.733  53.297  47.430  1.00 17.01           C  
ATOM  13916  C   PHE   142      84.216  52.930  47.312  1.00 17.24           C  
ATOM  13917  O   PHE   142      84.742  52.110  48.073  1.00 17.44           O  
ATOM  13918  CB  PHE   142      81.928  52.059  47.803  1.00 18.58           C  
ATOM  13919  CG  PHE   142      80.466  52.336  47.998  1.00 18.46           C  
ATOM  13920  CD1 PHE   142      80.015  52.864  49.180  1.00 21.60           C  
ATOM  13921  CD2 PHE   142      79.559  52.097  46.970  1.00 21.58           C  
ATOM  13922  CE1 PHE   142      78.682  53.137  49.358  1.00 21.61           C  
ATOM  13923  CE2 PHE   142      78.215  52.370  47.137  1.00 22.90           C  
ATOM  13924  CZ  PHE   142      77.776  52.887  48.332  1.00 22.64           C  
ATOM  13925  N   ASN   143      84.878  53.560  46.330  1.00 16.87           N  
ATOM  13926  CA  ASN   143      86.266  53.270  45.999  1.00 15.70           C  
ATOM  13927  C   ASN   143      86.510  51.824  45.587  1.00 15.55           C  
ATOM  13928  O   ASN   143      87.609  51.322  45.736  1.00 16.70           O  
ATOM  13929  CB  ASN   143      87.154  53.677  47.176  1.00 16.04           C  
ATOM  13930  CG  ASN   143      88.588  53.911  46.779  1.00 14.10           C  
ATOM  13931  OD1 ASN   143      88.914  54.151  45.608  1.00 17.82           O  
ATOM  13932  ND2 ASN   143      89.478  53.852  47.779  1.00 17.12           N  
ATOM  13933  N   ALA   144      85.488  51.161  45.023  1.00 15.75           N  
ATOM  13934  CA  ALA   144      85.636  49.826  44.460  1.00 15.29           C  
ATOM  13935  C   ALA   144      86.735  49.841  43.411  1.00 15.28           C  
ATOM  13936  O   ALA   144      86.847  50.796  42.624  1.00 14.89           O  
ATOM  13937  CB  ALA   144      84.350  49.361  43.831  1.00 15.92           C  
ATOM  13938  N   SER   145      87.538  48.785  43.403  1.00 15.49           N  
ATOM  13939  CA  SER   145      88.570  48.650  42.372  1.00 15.37           C  
ATOM  13940  C   SER   145      87.975  48.256  41.005  1.00 15.28           C  
ATOM  13941  O   SER   145      88.503  48.615  39.973  1.00 14.24           O  
ATOM  13942  CB  SER   145      89.687  47.688  42.825  1.00 16.67           C  
ATOM  13943  OG  SER   145      90.313  48.168  44.001  1.00 16.25           O  
ATOM  13944  N   VAL   146      86.877  47.516  41.017  1.00 14.87           N  
ATOM  13945  CA  VAL   146      86.230  47.021  39.809  1.00 15.23           C  
ATOM  13946  C   VAL   146      84.712  47.079  40.031  1.00 15.41           C  
ATOM  13947  O   VAL   146      84.210  46.874  41.153  1.00 15.54           O  
ATOM  13948  CB  VAL   146      86.670  45.536  39.456  1.00 15.05           C  
ATOM  13949  CG1 VAL   146      86.085  45.052  38.089  1.00 15.94           C  
ATOM  13950  CG2 VAL   146      88.232  45.354  39.571  1.00 14.96           C  
ATOM  13951  N   GLU   147      84.007  47.398  38.957  1.00 15.93           N  
ATOM  13952  CA  GLU   147      82.535  47.312  38.856  1.00 15.92           C  
ATOM  13953  C   GLU   147      82.252  46.607  37.524  1.00 15.93           C  
ATOM  13954  O   GLU   147      82.884  46.924  36.508  1.00 15.74           O  
ATOM  13955  CB  GLU   147      81.892  48.684  38.856  1.00 16.26           C  
ATOM  13956  CG  GLU   147      80.408  48.720  38.569  1.00 16.79           C  
ATOM  13957  CD  GLU   147      79.814  50.141  38.566  1.00 17.90           C  
ATOM  13958  OE1 GLU   147      80.472  51.032  39.106  1.00 16.37           O  
ATOM  13959  OE2 GLU   147      78.691  50.362  38.032  1.00 21.33           O  
ATOM  13960  N   ILE   148      81.306  45.667  37.535  1.00 16.14           N  
ATOM  13961  CA  ILE   148      80.988  44.895  36.342  1.00 15.98           C  
ATOM  13962  C   ILE   148      79.476  44.740  36.189  1.00 16.11           C  
ATOM  13963  O   ILE   148      78.794  44.315  37.129  1.00 16.86           O  
ATOM  13964  CB  ILE   148      81.601  43.456  36.330  1.00 16.86           C  
ATOM  13965  CG1 ILE   148      83.118  43.455  36.615  1.00 15.12           C  
ATOM  13966  CG2 ILE   148      81.313  42.831  34.929  1.00 17.11           C  
ATOM  13967  CD1 ILE   148      83.783  42.069  36.538  1.00 16.31           C  
ATOM  13968  N   ASP   149      78.974  45.086  35.011  1.00 15.24           N  
ATOM  13969  CA  ASP   149      77.541  44.879  34.705  1.00 16.84           C  
ATOM  13970  C   ASP   149      77.406  43.805  33.638  1.00 16.71           C  
ATOM  13971  O   ASP   149      78.409  43.329  33.087  1.00 19.31           O  
ATOM  13972  CB  ASP   149      76.857  46.181  34.332  1.00 17.25           C  
ATOM  13973  CG  ASP   149      77.178  46.666  32.924  1.00 18.92           C  
ATOM  13974  OD1 ASP   149      77.717  45.917  32.076  1.00 21.61           O  
ATOM  13975  OD2 ASP   149      76.901  47.857  32.671  1.00 23.19           O  
ATOM  13976  N   ALA   150      76.170  43.403  33.348  1.00 17.03           N  
ATOM  13977  CA  ALA   150      75.979  42.220  32.491  1.00 17.32           C  
ATOM  13978  C   ALA   150      74.653  42.251  31.760  1.00 17.32           C  
ATOM  13979  O   ALA   150      73.681  42.805  32.264  1.00 17.16           O  
ATOM  13980  CB  ALA   150      76.071  40.922  33.290  1.00 16.29           C  
ATOM  13981  N   ILE   151      74.636  41.600  30.597  1.00 17.86           N  
ATOM  13982  CA  ILE   151      73.385  41.298  29.877  1.00 18.64           C  
ATOM  13983  C   ILE   151      73.400  39.782  29.684  1.00 18.58           C  
ATOM  13984  O   ILE   151      74.408  39.216  29.252  1.00 16.46           O  
ATOM  13985  CB  ILE   151      73.295  41.986  28.517  1.00 18.12           C  
ATOM  13986  CG1 ILE   151      73.401  43.521  28.639  1.00 18.70           C  
ATOM  13987  CG2 ILE   151      72.005  41.638  27.832  1.00 18.34           C  
ATOM  13988  CD1 ILE   151      73.738  44.160  27.326  1.00 21.12           C  
ATOM  13989  N   VAL   152      72.296  39.127  30.014  1.00 19.65           N  
ATOM  13990  CA  VAL   152      72.245  37.677  30.062  1.00 20.85           C  
ATOM  13991  C   VAL   152      70.965  37.236  29.312  1.00 21.79           C  
ATOM  13992  O   VAL   152      69.875  37.732  29.595  1.00 23.25           O  
ATOM  13993  CB  VAL   152      72.234  37.157  31.530  1.00 20.51           C  
ATOM  13994  CG1 VAL   152      72.116  35.632  31.552  1.00 20.98           C  
ATOM  13995  CG2 VAL   152      73.472  37.627  32.314  1.00 19.78           C  
ATOM  13996  N   GLU   153      71.111  36.364  28.337  1.00 22.65           N  
ATOM  13997  CA  GLU   153      69.931  35.789  27.677  1.00 23.65           C  
ATOM  13998  C   GLU   153      69.416  34.643  28.566  1.00 23.87           C  
ATOM  13999  O   GLU   153      70.189  33.746  28.945  1.00 23.66           O  
ATOM  14000  CB  GLU   153      70.264  35.289  26.289  1.00 23.38           C  
ATOM  14001  CG  GLU   153      69.041  34.729  25.582  1.00 23.77           C  
ATOM  14002  CD  GLU   153      69.403  34.097  24.286  1.00 25.44           C  
ATOM  14003  OE1 GLU   153      69.856  34.818  23.377  1.00 28.66           O  
ATOM  14004  OE2 GLU   153      69.232  32.859  24.181  1.00 33.72           O  
ATOM  14005  N   ILE   154      68.116  34.683  28.885  1.00 25.68           N  
ATOM  14006  CA  ILE   154      67.500  33.757  29.854  1.00 26.78           C  
ATOM  14007  C   ILE   154      66.314  33.035  29.242  1.00 30.18           C  
ATOM  14008  O   ILE   154      65.740  33.496  28.257  1.00 29.70           O  
ATOM  14009  CB  ILE   154      67.039  34.458  31.150  1.00 26.75           C  
ATOM  14010  CG1 ILE   154      66.053  35.594  30.860  1.00 26.10           C  
ATOM  14011  CG2 ILE   154      68.259  34.960  31.966  1.00 25.49           C  
ATOM  14012  CD1 ILE   154      65.428  36.242  32.107  1.00 26.67           C  
ATOM  14013  N   ASP   155      65.987  31.894  29.838  1.00 34.08           N  
ATOM  14014  CA  ASP   155      64.750  31.169  29.526  1.00 38.39           C  
ATOM  14015  C   ASP   155      63.533  31.867  30.087  1.00 39.81           C  
ATOM  14016  O   ASP   155      63.331  31.884  31.303  1.00 41.42           O  
ATOM  14017  CB  ASP   155      64.825  29.774  30.112  1.00 38.89           C  
ATOM  14018  CG  ASP   155      65.674  28.876  29.280  1.00 42.84           C  
ATOM  14019  OD1 ASP   155      65.266  28.669  28.107  1.00 47.96           O  
ATOM  14020  OD2 ASP   155      66.738  28.398  29.774  1.00 48.12           O  
ATOM  14021  N   VAL   156      62.721  32.426  29.191  1.00 42.19           N  
ATOM  14022  CA  VAL   156      61.502  33.142  29.551  1.00 42.99           C  
ATOM  14023  C   VAL   156      60.299  32.349  29.037  1.00 44.31           C  
ATOM  14024  O   VAL   156      60.430  31.553  28.090  1.00 45.98           O  
ATOM  14025  CB  VAL   156      61.529  34.588  28.958  1.00 43.73           C  
ATOM  14026  CG1 VAL   156      60.139  35.038  28.439  1.00 44.09           C  
ATOM  14027  CG2 VAL   156      62.095  35.575  29.986  1.00 43.38           C  
END
