
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  124 (  924),  selected  124 , name 2csl_C
# Molecule2: number of CA atoms  152 ( 1118),  selected  152 , name T0423.pdb
# PARAMETERS: 2csl_C.T0423.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_C      M       1           -
LGA    E     2_C      S       2           -
LGA    A     3_C      D       3           -
LGA    V     4_C      V       4           -
LGA    K     5_C      I       5           -
LGA    T     6_C      E       6           -
LGA    D     7_C      G       7           -
LGA    -       -      R       8           -
LGA    -       -      L       9           -
LGA    -       -      K      10           -
LGA    -       -      E      11           -
LGA    -       -      L      12           -
LGA    -       -      G      13           -
LGA    -       -      F      14           -
LGA    -       -      T      15           -
LGA    -       -      L      16           -
LGA    R     8_C      P      17          3.235
LGA    A     9_C      V      18          4.323
LGA    P    10_C      -       -           -
LGA    A    11_C      -       -           -
LGA    A    12_C      -       -           -
LGA    I    13_C      A      23          4.633
LGA    G    14_C      A      24          2.942
LGA    P    15_C      N      25          1.865
LGA    Y    16_C      Y      26          1.140
LGA    A    17_C      V      27          1.055
LGA    Q    18_C      P      28          0.938
LGA    A    19_C      F      29          0.557
LGA    V    20_C      T      30          1.395
LGA    K    21_C      I      31          1.935
LGA    A    22_C      S      32          2.095
LGA    G    23_C      G      33          1.579
LGA    G    24_C      N      34          1.669
LGA    F    25_C      L      35          1.288
LGA    V    26_C      L      36          0.725
LGA    F    27_C      Y      37          0.757
LGA    V    28_C      V      38          0.394
LGA    S    29_C      S      39          0.329
LGA    G    30_C      G      40          0.464
LGA    Q    31_C      Q      41          0.380
LGA    I    32_C      L      42          0.556
LGA    P    33_C      P      43          0.931
LGA    L    34_C      M      44          1.480
LGA    A    35_C      E      45          2.854
LGA    P    36_C      S      46           #
LGA    D    37_C      -       -           -
LGA    G    38_C      G      47          3.120
LGA    S    39_C      K      48          1.364
LGA    L    40_C      I      49          1.578
LGA    V    41_C      A      50          0.839
LGA    E    42_C      V      51          2.333
LGA    G    43_C      T      52           #
LGA    -       -      G      53           -
LGA    -       -      L      54           -
LGA    -       -      V      55           -
LGA    -       -      G      56           -
LGA    -       -      R      57           -
LGA    -       -      D      58           -
LGA    -       -      V      59           -
LGA    -       -      D      60           -
LGA    -       -      V      61           -
LGA    -       -      A      62           -
LGA    D    44_C      S      63          1.596
LGA    I    45_C      A      64          0.764
LGA    R    46_C      Q      65          2.307
LGA    V    47_C      R      66          2.184
LGA    Q    48_C      A      67          1.176
LGA    T    49_C      A      68          1.344
LGA    E    50_C      E      69          1.734
LGA    R    51_C      L      70          1.162
LGA    V    52_C      C      71          0.733
LGA    X    53_C      A      72          1.110
LGA    E    54_C      V      73          0.764
LGA    N    55_C      N      74          0.585
LGA    L    56_C      I      75          0.903
LGA    K    57_C      L      76          1.007
LGA    A    58_C      A      77          0.987
LGA    V    59_C      Q      78          0.861
LGA    L    60_C      V      79          0.918
LGA    E    61_C      K      80          1.563
LGA    A    62_C      A      81          1.688
LGA    A    63_C      A      82          1.527
LGA    G    64_C      L      83          1.537
LGA    -       -      N      84           -
LGA    -       -      G      85           -
LGA    -       -      D      86           -
LGA    -       -      L      87           -
LGA    -       -      S      88           -
LGA    S    65_C      K      89          3.913
LGA    G    66_C      I      90          3.614
LGA    L    67_C      R      91           -
LGA    S    68_C      -       -           -
LGA    R    69_C      R      92          2.264
LGA    V    70_C      V      93          1.178
LGA    V    71_C      I      94          0.765
LGA    Q    72_C      K      95          1.270
LGA    T    73_C      L      96          1.425
LGA    T    74_C      N      97          1.303
LGA    C    75_C      G      98          1.292
LGA    F    76_C      F      99          0.916
LGA    L    77_C      V     100          0.922
LGA    A    78_C      A     101          1.091
LGA    D    79_C      S     102          2.202
LGA    -       -      V     103           -
LGA    -       -      P     104           -
LGA    -       -      E     105           -
LGA    -       -      F     106           -
LGA    X    80_C      V     107          3.487
LGA    E    81_C      E     108          3.272
LGA    D    82_C      Q     109          4.455
LGA    F    83_C      H     110          3.275
LGA    P    84_C      L     111          1.744
LGA    G    85_C      V     112          3.696
LGA    F    86_C      I     113          2.997
LGA    N    87_C      N     114          0.928
LGA    E    88_C      G     115          3.894
LGA    V    89_C      A     116          4.454
LGA    Y    90_C      S     117          2.253
LGA    A    91_C      N     118          1.367
LGA    R    92_C      L     119          2.384
LGA    Y    93_C      I     120          1.422
LGA    F    94_C      A     121          2.015
LGA    -       -      T     122           -
LGA    -       -      V     123           -
LGA    -       -      L     124           -
LGA    T    95_C      G     125          3.610
LGA    P    96_C      E     126          2.736
LGA    P    97_C      P     127          5.066
LGA    -       -      G     128           -
LGA    Y    98_C      R     129          1.748
LGA    P    99_C      H     130          1.231
LGA    A   100_C      A     131          1.295
LGA    R   101_C      R     132          1.140
LGA    A   102_C      A     133          1.521
LGA    T   103_C      A     134          1.580
LGA    V   104_C      V     135          1.061
LGA    A   105_C      G     136          0.857
LGA    V   106_C      M     137          1.384
LGA    K   107_C      A     138          1.371
LGA    A   108_C      S     139          1.360
LGA    L   109_C      L     140          1.047
LGA    P   110_C      P     141          1.022
LGA    R   111_C      F     142          0.943
LGA    G   112_C      N     143          0.895
LGA    V   113_C      A     144          0.793
LGA    R   114_C      S     145          1.250
LGA    V   115_C      V     146          0.865
LGA    E   116_C      E     147          0.908
LGA    V   117_C      I     148          0.858
LGA    A   118_C      D     149          0.701
LGA    C   119_C      A     150          0.786
LGA    V   120_C      I     151          0.744
LGA    A   121_C      V     152          0.805
LGA    L   122_C      E     153          1.310
LGA    A   123_C      I     154          2.154
LGA    E   124_C      D     155          0.838
LGA    -       -      V     156           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  124  152    5.0    109    1.97    25.69     59.194     5.270

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.061545 * X  +  -0.557463 * Y  +  -0.827917 * Z  + 116.306450
  Y_new =  -0.694719 * X  +  -0.619504 * Y  +   0.365488 * Z  +  78.666962
  Z_new =  -0.716644 * X  +   0.552676 * Y  +  -0.425407 * Z  +  45.301559 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.226802   -0.914791  [ DEG:   127.5863    -52.4137 ]
  Theta =   0.798978    2.342615  [ DEG:    45.7781    134.2219 ]
  Phi   =  -1.482437    1.659156  [ DEG:   -84.9374     95.0626 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2csl_C                                        
REMARK     2: T0423.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2csl_C.T0423.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  124  152   5.0  109   1.97   25.69  59.194
REMARK  ---------------------------------------------------------- 
MOLECULE 2csl_C
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   22-MAY-05   2CSL              
TITLE     CRYSTAL STRUCTURE OF TTHA0137 FROM THERMUS THERMOPHILUS HB8           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN TRANSLATION INTIATION INHIBITOR;                   
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: HB8;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    STRUCTURAL GENOMICS, UNKNOWN FUNCTION, NPPSFA, NATIONAL               
KEYWDS   2 PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES,               
KEYWDS   3 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    H.WANG,K.MURAYAMA,T.TERADA,L.CHEN,Z.JIN,J.CHRZAS,Z.J.LIU,             
AUTHOR   2 B.C.WANG,M.SHIROUZU,S.KURAMITSU,S.YOKOYAMA,RIKEN STRUCTURAL          
AUTHOR   3 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   22-NOV-05 2CSL    0                                                
JRNL        AUTH   H.WANG,K.MURAYAMA,T.TERADA,L.CHEN,Z.JIN,J.CHRZAS,            
JRNL        AUTH 2 Z.J.LIU,B.C.WANG,M.SHIROUZU,S.KURAMITSU,S.YOKOYAMA           
JRNL        TITL   CRYSTAL STRUCTURE OF TTHA0137 FROM THERMUS                   
JRNL        TITL 2 THERMOPHILUS HB8                                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  2CSL A    1   124  UNP    Q5SM06   Q5SM06_THET8     1    124             
DBREF  2CSL B    1   124  UNP    Q5SM06   Q5SM06_THET8     1    124             
DBREF  2CSL C    1   124  UNP    Q5SM06   Q5SM06_THET8     1    124             
DBREF  2CSL D    1   124  UNP    Q5SM06   Q5SM06_THET8     1    124             
DBREF  2CSL E    1   124  UNP    Q5SM06   Q5SM06_THET8     1    124             
DBREF  2CSL F    1   124  UNP    Q5SM06   Q5SM06_THET8     1    124             
SEQRES   1 A  124  MSE GLU ALA VAL LYS THR ASP ARG ALA PRO ALA ALA ILE          
SEQRES   2 A  124  GLY PRO TYR ALA GLN ALA VAL LYS ALA GLY GLY PHE VAL          
SEQRES   3 A  124  PHE VAL SER GLY GLN ILE PRO LEU ALA PRO ASP GLY SER          
SEQRES   4 A  124  LEU VAL GLU GLY ASP ILE ARG VAL GLN THR GLU ARG VAL          
SEQRES   5 A  124  MSE GLU ASN LEU LYS ALA VAL LEU GLU ALA ALA GLY SER          
SEQRES   6 A  124  GLY LEU SER ARG VAL VAL GLN THR THR CYS PHE LEU ALA          
SEQRES   7 A  124  ASP MSE GLU ASP PHE PRO GLY PHE ASN GLU VAL TYR ALA          
SEQRES   8 A  124  ARG TYR PHE THR PRO PRO TYR PRO ALA ARG ALA THR VAL          
SEQRES   9 A  124  ALA VAL LYS ALA LEU PRO ARG GLY VAL ARG VAL GLU VAL          
SEQRES  10 A  124  ALA CYS VAL ALA LEU ALA GLU                                  
SEQRES   1 B  124  MSE GLU ALA VAL LYS THR ASP ARG ALA PRO ALA ALA ILE          
SEQRES   2 B  124  GLY PRO TYR ALA GLN ALA VAL LYS ALA GLY GLY PHE VAL          
SEQRES   3 B  124  PHE VAL SER GLY GLN ILE PRO LEU ALA PRO ASP GLY SER          
SEQRES   4 B  124  LEU VAL GLU GLY ASP ILE ARG VAL GLN THR GLU ARG VAL          
SEQRES   5 B  124  MSE GLU ASN LEU LYS ALA VAL LEU GLU ALA ALA GLY SER          
SEQRES   6 B  124  GLY LEU SER ARG VAL VAL GLN THR THR CYS PHE LEU ALA          
SEQRES   7 B  124  ASP MSE GLU ASP PHE PRO GLY PHE ASN GLU VAL TYR ALA          
SEQRES   8 B  124  ARG TYR PHE THR PRO PRO TYR PRO ALA ARG ALA THR VAL          
SEQRES   9 B  124  ALA VAL LYS ALA LEU PRO ARG GLY VAL ARG VAL GLU VAL          
SEQRES  10 B  124  ALA CYS VAL ALA LEU ALA GLU                                  
SEQRES   1 C  124  MSE GLU ALA VAL LYS THR ASP ARG ALA PRO ALA ALA ILE          
SEQRES   2 C  124  GLY PRO TYR ALA GLN ALA VAL LYS ALA GLY GLY PHE VAL          
SEQRES   3 C  124  PHE VAL SER GLY GLN ILE PRO LEU ALA PRO ASP GLY SER          
SEQRES   4 C  124  LEU VAL GLU GLY ASP ILE ARG VAL GLN THR GLU ARG VAL          
SEQRES   5 C  124  MSE GLU ASN LEU LYS ALA VAL LEU GLU ALA ALA GLY SER          
SEQRES   6 C  124  GLY LEU SER ARG VAL VAL GLN THR THR CYS PHE LEU ALA          
SEQRES   7 C  124  ASP MSE GLU ASP PHE PRO GLY PHE ASN GLU VAL TYR ALA          
SEQRES   8 C  124  ARG TYR PHE THR PRO PRO TYR PRO ALA ARG ALA THR VAL          
SEQRES   9 C  124  ALA VAL LYS ALA LEU PRO ARG GLY VAL ARG VAL GLU VAL          
SEQRES  10 C  124  ALA CYS VAL ALA LEU ALA GLU                                  
SEQRES   1 D  124  MSE GLU ALA VAL LYS THR ASP ARG ALA PRO ALA ALA ILE          
SEQRES   2 D  124  GLY PRO TYR ALA GLN ALA VAL LYS ALA GLY GLY PHE VAL          
SEQRES   3 D  124  PHE VAL SER GLY GLN ILE PRO LEU ALA PRO ASP GLY SER          
SEQRES   4 D  124  LEU VAL GLU GLY ASP ILE ARG VAL GLN THR GLU ARG VAL          
SEQRES   5 D  124  MSE GLU ASN LEU LYS ALA VAL LEU GLU ALA ALA GLY SER          
SEQRES   6 D  124  GLY LEU SER ARG VAL VAL GLN THR THR CYS PHE LEU ALA          
SEQRES   7 D  124  ASP MSE GLU ASP PHE PRO GLY PHE ASN GLU VAL TYR ALA          
SEQRES   8 D  124  ARG TYR PHE THR PRO PRO TYR PRO ALA ARG ALA THR VAL          
SEQRES   9 D  124  ALA VAL LYS ALA LEU PRO ARG GLY VAL ARG VAL GLU VAL          
SEQRES  10 D  124  ALA CYS VAL ALA LEU ALA GLU                                  
SEQRES   1 E  124  MSE GLU ALA VAL LYS THR ASP ARG ALA PRO ALA ALA ILE          
SEQRES   2 E  124  GLY PRO TYR ALA GLN ALA VAL LYS ALA GLY GLY PHE VAL          
SEQRES   3 E  124  PHE VAL SER GLY GLN ILE PRO LEU ALA PRO ASP GLY SER          
SEQRES   4 E  124  LEU VAL GLU GLY ASP ILE ARG VAL GLN THR GLU ARG VAL          
SEQRES   5 E  124  MSE GLU ASN LEU LYS ALA VAL LEU GLU ALA ALA GLY SER          
SEQRES   6 E  124  GLY LEU SER ARG VAL VAL GLN THR THR CYS PHE LEU ALA          
SEQRES   7 E  124  ASP MSE GLU ASP PHE PRO GLY PHE ASN GLU VAL TYR ALA          
SEQRES   8 E  124  ARG TYR PHE THR PRO PRO TYR PRO ALA ARG ALA THR VAL          
SEQRES   9 E  124  ALA VAL LYS ALA LEU PRO ARG GLY VAL ARG VAL GLU VAL          
SEQRES  10 E  124  ALA CYS VAL ALA LEU ALA GLU                                  
SEQRES   1 F  124  MSE GLU ALA VAL LYS THR ASP ARG ALA PRO ALA ALA ILE          
SEQRES   2 F  124  GLY PRO TYR ALA GLN ALA VAL LYS ALA GLY GLY PHE VAL          
SEQRES   3 F  124  PHE VAL SER GLY GLN ILE PRO LEU ALA PRO ASP GLY SER          
SEQRES   4 F  124  LEU VAL GLU GLY ASP ILE ARG VAL GLN THR GLU ARG VAL          
SEQRES   5 F  124  MSE GLU ASN LEU LYS ALA VAL LEU GLU ALA ALA GLY SER          
SEQRES   6 F  124  GLY LEU SER ARG VAL VAL GLN THR THR CYS PHE LEU ALA          
SEQRES   7 F  124  ASP MSE GLU ASP PHE PRO GLY PHE ASN GLU VAL TYR ALA          
SEQRES   8 F  124  ARG TYR PHE THR PRO PRO TYR PRO ALA ARG ALA THR VAL          
SEQRES   9 F  124  ALA VAL LYS ALA LEU PRO ARG GLY VAL ARG VAL GLU VAL          
SEQRES  10 F  124  ALA CYS VAL ALA LEU ALA GLU                                  
HET    MSE  A   1       8                                                       
HET    MSE  A  53       8                                                       
HET    MSE  A  80       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  53       8                                                       
HET    MSE  B  80       8                                                       
HET    MSE  C   1       8                                                       
HET    MSE  C  53       8                                                       
HET    MSE  C  80       8                                                       
HET    MSE  D   1       8                                                       
HET    MSE  D  53       8                                                       
HET    MSE  D  80       8                                                       
HET    MSE  E   1       8                                                       
HET    MSE  E  53       8                                                       
HET    MSE  E  80       8                                                       
HET    MSE  F   1       8                                                       
HET    MSE  F  53       8                                                       
HET    MSE  F  80       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    18(C5 H11 N O2 SE)                                           
FORMUL   7  HOH   *159(H2 O)                                                    
CRYST1  111.850  111.990  111.750  90.00  90.00  90.00 P 21 21 21   24          
HETATM 1851  N   MSE C   1      57.794  43.531  32.739  1.00 71.04           N  
HETATM 1852  CA  MSE C   1      58.858  44.014  33.671  1.00 74.68           C  
HETATM 1853  C   MSE C   1      58.765  43.400  35.051  1.00 67.81           C  
HETATM 1854  O   MSE C   1      57.679  43.231  35.597  1.00 72.02           O  
HETATM 1855  CB  MSE C   1      58.790  45.527  33.836  1.00 77.56           C  
HETATM 1856  CG  MSE C   1      59.501  46.311  32.776  1.00 77.40           C  
HETATM 1857 SE   MSE C   1      59.447  48.149  33.290  1.00 92.52          SE  
HETATM 1858  CE  MSE C   1      60.907  48.138  34.569  1.00 67.21           C  
ATOM   1859  N   GLU C   2      59.920  43.098  35.626  1.00 59.24           N  
ATOM   1860  CA  GLU C   2      59.959  42.512  36.947  1.00 59.04           C  
ATOM   1861  C   GLU C   2      61.336  42.718  37.551  1.00 55.62           C  
ATOM   1862  O   GLU C   2      62.345  42.361  36.949  1.00 57.86           O  
ATOM   1863  CB  GLU C   2      59.656  41.022  36.859  1.00 63.50           C  
ATOM   1864  CG  GLU C   2      59.053  40.447  38.116  1.00 78.18           C  
ATOM   1865  CD  GLU C   2      59.033  38.935  38.101  1.00 86.81           C  
ATOM   1866  OE1 GLU C   2      58.752  38.355  37.028  1.00 88.92           O  
ATOM   1867  OE2 GLU C   2      59.292  38.327  39.163  1.00 88.25           O  
ATOM   1868  N   ALA C   3      61.379  43.301  38.739  1.00 47.97           N  
ATOM   1869  CA  ALA C   3      62.648  43.526  39.402  1.00 46.85           C  
ATOM   1870  C   ALA C   3      63.068  42.224  40.050  1.00 46.07           C  
ATOM   1871  O   ALA C   3      62.228  41.452  40.510  1.00 49.35           O  
ATOM   1872  CB  ALA C   3      62.510  44.618  40.461  1.00 45.54           C  
ATOM   1873  N   VAL C   4      64.368  41.974  40.072  1.00 43.36           N  
ATOM   1874  CA  VAL C   4      64.892  40.767  40.678  1.00 42.29           C  
ATOM   1875  C   VAL C   4      65.426  41.156  42.037  1.00 50.06           C  
ATOM   1876  O   VAL C   4      66.165  42.133  42.170  1.00 49.26           O  
ATOM   1877  CB  VAL C   4      66.014  40.167  39.828  1.00 42.76           C  
ATOM   1878  CG1 VAL C   4      66.625  38.975  40.526  1.00 37.93           C  
ATOM   1879  CG2 VAL C   4      65.459  39.767  38.475  1.00 42.53           C  
ATOM   1880  N   LYS C   5      65.048  40.389  43.051  1.00 55.16           N  
ATOM   1881  CA  LYS C   5      65.477  40.697  44.401  1.00 57.19           C  
ATOM   1882  C   LYS C   5      65.996  39.445  45.098  1.00 55.13           C  
ATOM   1883  O   LYS C   5      65.247  38.503  45.352  1.00 64.36           O  
ATOM   1884  CB  LYS C   5      64.296  41.302  45.163  1.00 47.57           C  
ATOM   1885  CG  LYS C   5      64.665  42.284  46.254  1.00 59.69           C  
ATOM   1886  CD  LYS C   5      63.405  42.892  46.854  1.00 68.00           C  
ATOM   1887  CE  LYS C   5      63.595  43.227  48.324  1.00 69.38           C  
ATOM   1888  NZ  LYS C   5      62.305  43.587  48.975  1.00 77.78           N  
ATOM   1889  N   THR C   6      67.290  39.438  45.390  1.00 50.08           N  
ATOM   1890  CA  THR C   6      67.933  38.315  46.062  1.00 45.44           C  
ATOM   1891  C   THR C   6      68.758  38.846  47.225  1.00 47.20           C  
ATOM   1892  O   THR C   6      69.284  39.951  47.155  1.00 46.79           O  
ATOM   1893  CB  THR C   6      68.883  37.554  45.109  1.00 43.93           C  
ATOM   1894  OG1 THR C   6      69.750  36.709  45.874  1.00 52.11           O  
ATOM   1895  CG2 THR C   6      69.736  38.529  44.304  1.00 51.49           C  
ATOM   1896  N   ASP C   7      68.875  38.069  48.297  1.00 53.74           N  
ATOM   1897  CA  ASP C   7      69.664  38.519  49.432  1.00 58.61           C  
ATOM   1898  C   ASP C   7      71.032  37.847  49.389  1.00 60.66           C  
ATOM   1899  O   ASP C   7      71.851  38.002  50.301  1.00 57.68           O  
ATOM   1900  CB  ASP C   7      68.937  38.220  50.748  1.00 69.91           C  
ATOM   1901  CG  ASP C   7      68.928  36.753  51.093  1.00 81.01           C  
ATOM   1902  OD1 ASP C   7      69.877  36.298  51.762  1.00 93.85           O  
ATOM   1903  OD2 ASP C   7      67.974  36.057  50.689  1.00 90.74           O  
ATOM   1904  N   ARG C   8      71.276  37.106  48.309  1.00 58.14           N  
ATOM   1905  CA  ARG C   8      72.554  36.431  48.117  1.00 63.43           C  
ATOM   1906  C   ARG C   8      73.534  37.343  47.382  1.00 56.71           C  
ATOM   1907  O   ARG C   8      74.614  36.920  46.979  1.00 55.61           O  
ATOM   1908  CB  ARG C   8      72.364  35.134  47.330  1.00 68.73           C  
ATOM   1909  CG  ARG C   8      72.054  33.922  48.186  1.00 76.18           C  
ATOM   1910  CD  ARG C   8      71.875  32.690  47.314  1.00 84.12           C  
ATOM   1911  NE  ARG C   8      73.077  32.382  46.542  1.00 93.77           N  
ATOM   1912  CZ  ARG C   8      73.069  32.029  45.259  1.00 94.68           C  
ATOM   1913  NH1 ARG C   8      71.919  31.944  44.603  1.00 93.88           N  
ATOM   1914  NH2 ARG C   8      74.204  31.754  44.628  1.00 84.89           N  
ATOM   1915  N   ALA C   9      73.127  38.595  47.206  1.00 57.03           N  
ATOM   1916  CA  ALA C   9      73.937  39.613  46.546  1.00 55.70           C  
ATOM   1917  C   ALA C   9      73.580  40.965  47.182  1.00 55.60           C  
ATOM   1918  O   ALA C   9      72.503  41.120  47.760  1.00 51.12           O  
ATOM   1919  CB  ALA C   9      73.649  39.627  45.046  1.00 41.97           C  
ATOM   1920  N   PRO C  10      74.475  41.960  47.079  1.00 56.15           N  
ATOM   1921  CA  PRO C  10      74.214  43.284  47.663  1.00 50.85           C  
ATOM   1922  C   PRO C  10      72.805  43.781  47.344  1.00 50.44           C  
ATOM   1923  O   PRO C  10      72.397  43.797  46.186  1.00 49.25           O  
ATOM   1924  CB  PRO C  10      75.294  44.156  47.025  1.00 52.69           C  
ATOM   1925  CG  PRO C  10      76.425  43.196  46.802  1.00 53.39           C  
ATOM   1926  CD  PRO C  10      75.700  41.982  46.258  1.00 57.59           C  
ATOM   1927  N   ALA C  11      72.061  44.178  48.368  1.00 50.32           N  
ATOM   1928  CA  ALA C  11      70.700  44.668  48.158  1.00 46.51           C  
ATOM   1929  C   ALA C  11      70.775  45.993  47.430  1.00 49.99           C  
ATOM   1930  O   ALA C  11      71.680  46.794  47.674  1.00 44.01           O  
ATOM   1931  CB  ALA C  11      69.982  44.850  49.491  1.00 47.95           C  
ATOM   1932  N   ALA C  12      69.829  46.215  46.523  1.00 51.87           N  
ATOM   1933  CA  ALA C  12      69.782  47.451  45.759  1.00 49.37           C  
ATOM   1934  C   ALA C  12      69.134  48.528  46.620  1.00 49.51           C  
ATOM   1935  O   ALA C  12      67.907  48.648  46.672  1.00 54.03           O  
ATOM   1936  CB  ALA C  12      68.984  47.245  44.474  1.00 35.70           C  
ATOM   1937  N   ILE C  13      69.967  49.299  47.308  1.00 54.91           N  
ATOM   1938  CA  ILE C  13      69.480  50.374  48.164  1.00 53.54           C  
ATOM   1939  C   ILE C  13      69.563  51.669  47.360  1.00 56.25           C  
ATOM   1940  O   ILE C  13      70.637  52.259  47.216  1.00 54.87           O  
ATOM   1941  CB  ILE C  13      70.333  50.504  49.444  1.00 58.97           C  
ATOM   1942  CG1 ILE C  13      70.626  49.117  50.027  1.00 58.58           C  
ATOM   1943  CG2 ILE C  13      69.585  51.322  50.474  1.00 55.40           C  
ATOM   1944  CD1 ILE C  13      69.390  48.321  50.348  1.00 75.38           C  
ATOM   1945  N   GLY C  14      68.417  52.096  46.831  1.00 48.16           N  
ATOM   1946  CA  GLY C  14      68.367  53.297  46.023  1.00 37.72           C  
ATOM   1947  C   GLY C  14      67.374  53.165  44.877  1.00 46.42           C  
ATOM   1948  O   GLY C  14      66.571  52.230  44.844  1.00 43.71           O  
ATOM   1949  N   PRO C  15      67.424  54.073  43.893  1.00 43.24           N  
ATOM   1950  CA  PRO C  15      66.517  54.065  42.738  1.00 45.07           C  
ATOM   1951  C   PRO C  15      66.847  53.038  41.657  1.00 45.04           C  
ATOM   1952  O   PRO C  15      66.824  53.371  40.473  1.00 38.85           O  
ATOM   1953  CB  PRO C  15      66.637  55.492  42.190  1.00 45.51           C  
ATOM   1954  CG  PRO C  15      67.522  56.245  43.216  1.00 48.67           C  
ATOM   1955  CD  PRO C  15      68.387  55.172  43.776  1.00 32.40           C  
ATOM   1956  N   TYR C  16      67.146  51.801  42.040  1.00 39.59           N  
ATOM   1957  CA  TYR C  16      67.475  50.786  41.043  1.00 45.40           C  
ATOM   1958  C   TYR C  16      67.192  49.382  41.550  1.00 44.73           C  
ATOM   1959  O   TYR C  16      66.971  49.177  42.738  1.00 48.06           O  
ATOM   1960  CB  TYR C  16      68.954  50.893  40.638  1.00 34.36           C  
ATOM   1961  CG  TYR C  16      69.922  50.529  41.742  1.00 33.82           C  
ATOM   1962  CD1 TYR C  16      70.684  49.357  41.678  1.00 35.89           C  
ATOM   1963  CD2 TYR C  16      70.049  51.333  42.871  1.00 35.01           C  
ATOM   1964  CE1 TYR C  16      71.544  48.996  42.722  1.00 33.91           C  
ATOM   1965  CE2 TYR C  16      70.903  50.982  43.920  1.00 35.20           C  
ATOM   1966  CZ  TYR C  16      71.641  49.816  43.842  1.00 48.75           C  
ATOM   1967  OH  TYR C  16      72.445  49.466  44.904  1.00 54.19           O  
ATOM   1968  N   ALA C  17      67.191  48.426  40.630  1.00 42.99           N  
ATOM   1969  CA  ALA C  17      66.970  47.028  40.965  1.00 40.70           C  
ATOM   1970  C   ALA C  17      68.247  46.286  40.616  1.00 40.62           C  
ATOM   1971  O   ALA C  17      68.937  46.673  39.675  1.00 39.57           O  
ATOM   1972  CB  ALA C  17      65.815  46.471  40.149  1.00 40.09           C  
ATOM   1973  N   GLN C  18      68.565  45.232  41.367  1.00 36.71           N  
ATOM   1974  CA  GLN C  18      69.759  44.438  41.085  1.00 37.98           C  
ATOM   1975  C   GLN C  18      69.705  44.012  39.617  1.00 35.22           C  
ATOM   1976  O   GLN C  18      70.736  43.871  38.961  1.00 44.43           O  
ATOM   1977  CB  GLN C  18      69.815  43.208  41.995  1.00 38.81           C  
ATOM   1978  CG  GLN C  18      69.846  43.552  43.485  1.00 40.30           C  
ATOM   1979  CD  GLN C  18      69.677  42.330  44.379  1.00 47.86           C  
ATOM   1980  OE1 GLN C  18      68.845  41.456  44.107  1.00 39.38           O  
ATOM   1981  NE2 GLN C  18      70.451  42.275  45.466  1.00 37.37           N  
ATOM   1982  N   ALA C  19      68.489  43.818  39.112  1.00 34.90           N  
ATOM   1983  CA  ALA C  19      68.262  43.445  37.716  1.00 38.41           C  
ATOM   1984  C   ALA C  19      66.765  43.428  37.425  1.00 38.34           C  
ATOM   1985  O   ALA C  19      65.960  43.338  38.352  1.00 45.56           O  
ATOM   1986  CB  ALA C  19      68.868  42.070  37.426  1.00 30.29           C  
ATOM   1987  N   VAL C  20      66.390  43.539  36.149  1.00 33.81           N  
ATOM   1988  CA  VAL C  20      64.978  43.481  35.764  1.00 40.21           C  
ATOM   1989  C   VAL C  20      64.785  42.551  34.565  1.00 39.56           C  
ATOM   1990  O   VAL C  20      65.564  42.583  33.617  1.00 48.20           O  
ATOM   1991  CB  VAL C  20      64.363  44.901  35.425  1.00 33.50           C  
ATOM   1992  CG1 VAL C  20      65.320  46.009  35.801  1.00 40.64           C  
ATOM   1993  CG2 VAL C  20      63.960  44.983  33.960  1.00 37.32           C  
ATOM   1994  N   LYS C  21      63.756  41.710  34.629  1.00 45.22           N  
ATOM   1995  CA  LYS C  21      63.432  40.785  33.543  1.00 42.38           C  
ATOM   1996  C   LYS C  21      62.474  41.510  32.597  1.00 43.64           C  
ATOM   1997  O   LYS C  21      61.481  42.091  33.039  1.00 49.59           O  
ATOM   1998  CB  LYS C  21      62.762  39.521  34.099  1.00 38.76           C  
ATOM   1999  CG  LYS C  21      63.612  38.789  35.134  1.00 52.67           C  
ATOM   2000  CD  LYS C  21      63.199  37.336  35.353  1.00 61.36           C  
ATOM   2001  CE  LYS C  21      61.927  37.203  36.168  1.00 71.83           C  
ATOM   2002  NZ  LYS C  21      61.762  35.807  36.671  1.00 73.43           N  
ATOM   2003  N   ALA C  22      62.770  41.497  31.303  1.00 39.85           N  
ATOM   2004  CA  ALA C  22      61.906  42.176  30.341  1.00 46.50           C  
ATOM   2005  C   ALA C  22      62.238  41.802  28.905  1.00 50.20           C  
ATOM   2006  O   ALA C  22      63.402  41.600  28.564  1.00 53.33           O  
ATOM   2007  CB  ALA C  22      62.022  43.681  30.522  1.00 52.11           C  
ATOM   2008  N   GLY C  23      61.202  41.708  28.073  1.00 43.59           N  
ATOM   2009  CA  GLY C  23      61.384  41.370  26.672  1.00 44.21           C  
ATOM   2010  C   GLY C  23      62.218  40.136  26.365  1.00 42.08           C  
ATOM   2011  O   GLY C  23      62.840  40.051  25.306  1.00 48.98           O  
ATOM   2012  N   GLY C  24      62.235  39.178  27.284  1.00 48.27           N  
ATOM   2013  CA  GLY C  24      62.996  37.964  27.065  1.00 33.59           C  
ATOM   2014  C   GLY C  24      64.419  38.058  27.583  1.00 47.20           C  
ATOM   2015  O   GLY C  24      65.168  37.086  27.511  1.00 46.07           O  
ATOM   2016  N   PHE C  25      64.793  39.217  28.122  1.00 38.48           N  
ATOM   2017  CA  PHE C  25      66.143  39.403  28.642  1.00 40.63           C  
ATOM   2018  C   PHE C  25      66.192  39.774  30.113  1.00 41.69           C  
ATOM   2019  O   PHE C  25      65.185  40.107  30.733  1.00 51.49           O  
ATOM   2020  CB  PHE C  25      66.885  40.503  27.884  1.00 32.32           C  
ATOM   2021  CG  PHE C  25      67.177  40.181  26.449  1.00 39.98           C  
ATOM   2022  CD1 PHE C  25      66.238  40.436  25.454  1.00 45.52           C  
ATOM   2023  CD2 PHE C  25      68.412  39.669  26.085  1.00 43.95           C  
ATOM   2024  CE1 PHE C  25      66.527  40.190  24.118  1.00 40.83           C  
ATOM   2025  CE2 PHE C  25      68.714  39.417  24.748  1.00 48.47           C  
ATOM   2026  CZ  PHE C  25      67.772  39.680  23.763  1.00 48.40           C  
ATOM   2027  N   VAL C  26      67.397  39.718  30.661  1.00 44.96           N  
ATOM   2028  CA  VAL C  26      67.628  40.088  32.045  1.00 45.74           C  
ATOM   2029  C   VAL C  26      68.695  41.165  31.968  1.00 37.67           C  
ATOM   2030  O   VAL C  26      69.757  40.955  31.383  1.00 48.74           O  
ATOM   2031  CB  VAL C  26      68.166  38.913  32.883  1.00 36.76           C  
ATOM   2032  CG1 VAL C  26      68.185  39.296  34.350  1.00 25.94           C  
ATOM   2033  CG2 VAL C  26      67.309  37.693  32.676  1.00 37.50           C  
ATOM   2034  N   PHE C  27      68.399  42.325  32.532  1.00 36.79           N  
ATOM   2035  CA  PHE C  27      69.342  43.433  32.530  1.00 32.88           C  
ATOM   2036  C   PHE C  27      69.892  43.526  33.944  1.00 40.22           C  
ATOM   2037  O   PHE C  27      69.173  43.888  34.873  1.00 44.54           O  
ATOM   2038  CB  PHE C  27      68.615  44.718  32.140  1.00 38.71           C  
ATOM   2039  CG  PHE C  27      68.090  44.711  30.729  1.00 36.64           C  
ATOM   2040  CD1 PHE C  27      68.881  45.158  29.675  1.00 35.52           C  
ATOM   2041  CD2 PHE C  27      66.818  44.225  30.446  1.00 37.49           C  
ATOM   2042  CE1 PHE C  27      68.414  45.122  28.363  1.00 31.11           C  
ATOM   2043  CE2 PHE C  27      66.342  44.185  29.135  1.00 33.75           C  
ATOM   2044  CZ  PHE C  27      67.144  44.634  28.092  1.00 32.98           C  
ATOM   2045  N   VAL C  28      71.167  43.188  34.103  1.00 40.24           N  
ATOM   2046  CA  VAL C  28      71.798  43.201  35.417  1.00 39.41           C  
ATOM   2047  C   VAL C  28      72.556  44.487  35.726  1.00 36.87           C  
ATOM   2048  O   VAL C  28      73.345  44.952  34.919  1.00 39.59           O  
ATOM   2049  CB  VAL C  28      72.755  42.011  35.552  1.00 35.37           C  
ATOM   2050  CG1 VAL C  28      73.440  42.029  36.913  1.00 36.26           C  
ATOM   2051  CG2 VAL C  28      71.981  40.726  35.365  1.00 30.45           C  
ATOM   2052  N   SER C  29      72.309  45.054  36.905  1.00 32.70           N  
ATOM   2053  CA  SER C  29      72.982  46.283  37.314  1.00 40.61           C  
ATOM   2054  C   SER C  29      74.474  46.046  37.518  1.00 40.49           C  
ATOM   2055  O   SER C  29      74.894  44.923  37.793  1.00 42.83           O  
ATOM   2056  CB  SER C  29      72.374  46.821  38.614  1.00 31.15           C  
ATOM   2057  OG  SER C  29      71.083  47.359  38.388  1.00 42.98           O  
ATOM   2058  N   GLY C  30      75.267  47.105  37.372  1.00 35.57           N  
ATOM   2059  CA  GLY C  30      76.701  46.984  37.561  1.00 37.54           C  
ATOM   2060  C   GLY C  30      76.987  46.465  38.960  1.00 41.23           C  
ATOM   2061  O   GLY C  30      76.525  47.029  39.947  1.00 50.14           O  
ATOM   2062  N   GLN C  31      77.740  45.382  39.052  1.00 40.96           N  
ATOM   2063  CA  GLN C  31      78.048  44.802  40.348  1.00 42.36           C  
ATOM   2064  C   GLN C  31      79.456  45.179  40.764  1.00 40.77           C  
ATOM   2065  O   GLN C  31      80.353  45.252  39.930  1.00 35.05           O  
ATOM   2066  CB  GLN C  31      77.907  43.276  40.287  1.00 31.20           C  
ATOM   2067  CG  GLN C  31      76.538  42.822  39.841  1.00 40.67           C  
ATOM   2068  CD  GLN C  31      75.461  43.236  40.814  1.00 48.90           C  
ATOM   2069  OE1 GLN C  31      74.357  43.591  40.416  1.00 55.83           O  
ATOM   2070  NE2 GLN C  31      75.775  43.183  42.099  1.00 45.60           N  
ATOM   2071  N   ILE C  32      79.641  45.427  42.056  1.00 43.45           N  
ATOM   2072  CA  ILE C  32      80.947  45.793  42.588  1.00 37.68           C  
ATOM   2073  C   ILE C  32      81.348  44.859  43.730  1.00 40.70           C  
ATOM   2074  O   ILE C  32      80.530  44.066  44.192  1.00 46.47           O  
ATOM   2075  CB  ILE C  32      80.959  47.275  43.046  1.00 36.44           C  
ATOM   2076  CG1 ILE C  32      79.646  47.669  43.734  1.00 49.79           C  
ATOM   2077  CG2 ILE C  32      81.129  48.166  41.819  1.00 45.85           C  
ATOM   2078  CD1 ILE C  32      79.110  46.674  44.735  1.00 82.00           C  
ATOM   2079  N   PRO C  33      82.608  44.936  44.194  1.00 42.43           N  
ATOM   2080  CA  PRO C  33      83.141  44.104  45.280  1.00 38.40           C  
ATOM   2081  C   PRO C  33      82.492  44.287  46.650  1.00 45.60           C  
ATOM   2082  O   PRO C  33      83.132  44.787  47.573  1.00 54.37           O  
ATOM   2083  CB  PRO C  33      84.619  44.487  45.325  1.00 38.18           C  
ATOM   2084  CG  PRO C  33      84.914  44.943  43.963  1.00 37.90           C  
ATOM   2085  CD  PRO C  33      83.685  45.746  43.603  1.00 40.22           C  
ATOM   2086  N   LEU C  34      81.233  43.886  46.790  1.00 51.15           N  
ATOM   2087  CA  LEU C  34      80.547  43.992  48.072  1.00 45.56           C  
ATOM   2088  C   LEU C  34      79.894  42.661  48.398  1.00 51.11           C  
ATOM   2089  O   LEU C  34      79.250  42.056  47.536  1.00 50.88           O  
ATOM   2090  CB  LEU C  34      79.452  45.059  48.037  1.00 51.62           C  
ATOM   2091  CG  LEU C  34      79.730  46.531  47.741  1.00 53.54           C  
ATOM   2092  CD1 LEU C  34      78.478  47.308  48.126  1.00 42.85           C  
ATOM   2093  CD2 LEU C  34      80.938  47.053  48.507  1.00 44.74           C  
ATOM   2094  N   ALA C  35      80.068  42.197  49.633  1.00 56.34           N  
ATOM   2095  CA  ALA C  35      79.449  40.947  50.063  1.00 54.88           C  
ATOM   2096  C   ALA C  35      77.970  41.264  50.254  1.00 55.28           C  
ATOM   2097  O   ALA C  35      77.593  42.423  50.399  1.00 59.15           O  
ATOM   2098  CB  ALA C  35      80.061  40.464  51.368  1.00 57.96           C  
ATOM   2099  N   PRO C  36      77.109  40.242  50.251  1.00 55.80           N  
ATOM   2100  CA  PRO C  36      75.674  40.483  50.423  1.00 55.55           C  
ATOM   2101  C   PRO C  36      75.257  41.370  51.600  1.00 61.55           C  
ATOM   2102  O   PRO C  36      74.214  42.024  51.537  1.00 65.71           O  
ATOM   2103  CB  PRO C  36      75.104  39.073  50.516  1.00 56.39           C  
ATOM   2104  CG  PRO C  36      76.001  38.315  49.570  1.00 54.09           C  
ATOM   2105  CD  PRO C  36      77.375  38.821  49.961  1.00 53.68           C  
ATOM   2106  N   ASP C  37      76.058  41.401  52.663  1.00 65.68           N  
ATOM   2107  CA  ASP C  37      75.731  42.220  53.832  1.00 69.55           C  
ATOM   2108  C   ASP C  37      76.000  43.707  53.586  1.00 72.86           C  
ATOM   2109  O   ASP C  37      75.518  44.566  54.329  1.00 74.46           O  
ATOM   2110  CB  ASP C  37      76.509  41.731  55.060  1.00 71.74           C  
ATOM   2111  CG  ASP C  37      78.007  41.840  54.888  1.00 81.68           C  
ATOM   2112  OD1 ASP C  37      78.516  41.449  53.819  1.00 93.17           O  
ATOM   2113  OD2 ASP C  37      78.681  42.303  55.830  1.00 80.94           O  
ATOM   2114  N   GLY C  38      76.763  44.006  52.540  1.00 67.53           N  
ATOM   2115  CA  GLY C  38      77.047  45.389  52.211  1.00 59.09           C  
ATOM   2116  C   GLY C  38      78.487  45.806  52.416  1.00 64.93           C  
ATOM   2117  O   GLY C  38      78.902  46.877  51.963  1.00 64.17           O  
ATOM   2118  N   SER C  39      79.256  44.960  53.089  1.00 68.77           N  
ATOM   2119  CA  SER C  39      80.654  45.265  53.367  1.00 75.59           C  
ATOM   2120  C   SER C  39      81.585  45.210  52.155  1.00 72.85           C  
ATOM   2121  O   SER C  39      81.416  44.401  51.241  1.00 74.20           O  
ATOM   2122  CB  SER C  39      81.181  44.342  54.468  1.00 73.39           C  
ATOM   2123  OG  SER C  39      80.987  42.981  54.128  1.00 68.33           O  
ATOM   2124  N   LEU C  40      82.576  46.093  52.182  1.00 69.12           N  
ATOM   2125  CA  LEU C  40      83.573  46.228  51.134  1.00 66.91           C  
ATOM   2126  C   LEU C  40      84.567  45.071  51.214  1.00 71.87           C  
ATOM   2127  O   LEU C  40      85.035  44.719  52.298  1.00 74.98           O  
ATOM   2128  CB  LEU C  40      84.299  47.568  51.325  1.00 73.94           C  
ATOM   2129  CG  LEU C  40      84.932  48.337  50.163  1.00 72.16           C  
ATOM   2130  CD1 LEU C  40      86.201  47.651  49.698  1.00 73.12           C  
ATOM   2131  CD2 LEU C  40      83.918  48.464  49.034  1.00 70.35           C  
ATOM   2132  N   VAL C  41      84.867  44.471  50.066  1.00 69.78           N  
ATOM   2133  CA  VAL C  41      85.827  43.375  49.993  1.00 65.77           C  
ATOM   2134  C   VAL C  41      87.042  43.940  49.284  1.00 68.67           C  
ATOM   2135  O   VAL C  41      87.031  44.118  48.067  1.00 73.75           O  
ATOM   2136  CB  VAL C  41      85.279  42.187  49.176  1.00 65.21           C  
ATOM   2137  CG1 VAL C  41      86.389  41.175  48.913  1.00 45.67           C  
ATOM   2138  CG2 VAL C  41      84.125  41.534  49.926  1.00 59.38           C  
ATOM   2139  N   GLU C  42      88.086  44.239  50.047  1.00 68.92           N  
ATOM   2140  CA  GLU C  42      89.295  44.816  49.480  1.00 65.39           C  
ATOM   2141  C   GLU C  42      90.277  43.745  49.041  1.00 63.42           C  
ATOM   2142  O   GLU C  42      90.114  42.569  49.360  1.00 57.41           O  
ATOM   2143  CB  GLU C  42      89.969  45.734  50.500  1.00 80.27           C  
ATOM   2144  CG  GLU C  42      89.029  46.698  51.198  1.00 88.03           C  
ATOM   2145  CD  GLU C  42      89.150  46.609  52.705  1.00103.25           C  
ATOM   2146  OE1 GLU C  42      90.266  46.829  53.224  1.00100.64           O  
ATOM   2147  OE2 GLU C  42      88.135  46.315  53.370  1.00115.72           O  
ATOM   2148  N   GLY C  43      91.304  44.175  48.315  1.00 65.90           N  
ATOM   2149  CA  GLY C  43      92.317  43.262  47.820  1.00 58.44           C  
ATOM   2150  C   GLY C  43      92.610  43.559  46.365  1.00 54.47           C  
ATOM   2151  O   GLY C  43      91.986  44.439  45.772  1.00 58.42           O  
ATOM   2152  N   ASP C  44      93.558  42.833  45.785  1.00 50.23           N  
ATOM   2153  CA  ASP C  44      93.911  43.030  44.386  1.00 52.44           C  
ATOM   2154  C   ASP C  44      92.705  42.662  43.508  1.00 50.41           C  
ATOM   2155  O   ASP C  44      91.699  42.160  44.017  1.00 51.24           O  
ATOM   2156  CB  ASP C  44      95.133  42.166  44.031  1.00 47.35           C  
ATOM   2157  CG  ASP C  44      94.768  40.724  43.714  1.00 63.09           C  
ATOM   2158  OD1 ASP C  44      94.101  40.069  44.544  1.00 56.96           O  
ATOM   2159  OD2 ASP C  44      95.157  40.247  42.624  1.00 75.50           O  
ATOM   2160  N   ILE C  45      92.812  42.912  42.203  1.00 46.80           N  
ATOM   2161  CA  ILE C  45      91.733  42.618  41.255  1.00 53.00           C  
ATOM   2162  C   ILE C  45      91.132  41.234  41.409  1.00 57.16           C  
ATOM   2163  O   ILE C  45      89.911  41.085  41.445  1.00 61.11           O  
ATOM   2164  CB  ILE C  45      92.186  42.730  39.778  1.00 55.59           C  
ATOM   2165  CG1 ILE C  45      93.651  43.155  39.694  1.00 59.94           C  
ATOM   2166  CG2 ILE C  45      91.271  43.683  39.031  1.00 57.86           C  
ATOM   2167  CD1 ILE C  45      94.633  42.033  39.986  1.00 78.94           C  
ATOM   2168  N   ARG C  46      91.986  40.218  41.483  1.00 54.76           N  
ATOM   2169  CA  ARG C  46      91.510  38.848  41.619  1.00 57.63           C  
ATOM   2170  C   ARG C  46      90.473  38.687  42.730  1.00 56.90           C  
ATOM   2171  O   ARG C  46      89.379  38.167  42.497  1.00 65.61           O  
ATOM   2172  CB  ARG C  46      92.692  37.902  41.853  1.00 53.37           C  
ATOM   2173  CG  ARG C  46      93.605  37.776  40.645  1.00 50.62           C  
ATOM   2174  CD  ARG C  46      94.781  36.862  40.913  1.00 48.81           C  
ATOM   2175  NE  ARG C  46      95.483  36.540  39.672  1.00 52.49           N  
ATOM   2176  CZ  ARG C  46      96.180  37.410  38.942  1.00 62.99           C  
ATOM   2177  NH1 ARG C  46      96.288  38.680  39.321  1.00 50.97           N  
ATOM   2178  NH2 ARG C  46      96.761  37.011  37.817  1.00 54.66           N  
ATOM   2179  N   VAL C  47      90.804  39.144  43.930  1.00 54.84           N  
ATOM   2180  CA  VAL C  47      89.885  39.028  45.053  1.00 51.24           C  
ATOM   2181  C   VAL C  47      88.600  39.804  44.817  1.00 46.37           C  
ATOM   2182  O   VAL C  47      87.510  39.314  45.117  1.00 38.68           O  
ATOM   2183  CB  VAL C  47      90.540  39.523  46.354  1.00 55.98           C  
ATOM   2184  CG1 VAL C  47      89.501  39.644  47.455  1.00 56.40           C  
ATOM   2185  CG2 VAL C  47      91.629  38.556  46.773  1.00 48.70           C  
ATOM   2186  N   GLN C  48      88.731  41.013  44.280  1.00 40.93           N  
ATOM   2187  CA  GLN C  48      87.568  41.855  44.005  1.00 47.71           C  
ATOM   2188  C   GLN C  48      86.754  41.340  42.820  1.00 52.40           C  
ATOM   2189  O   GLN C  48      85.518  41.305  42.873  1.00 54.23           O  
ATOM   2190  CB  GLN C  48      87.996  43.308  43.749  1.00 42.77           C  
ATOM   2191  CG  GLN C  48      88.269  44.098  45.018  1.00 52.63           C  
ATOM   2192  CD  GLN C  48      88.515  45.582  44.765  1.00 56.10           C  
ATOM   2193  OE1 GLN C  48      87.784  46.231  44.012  1.00 47.14           O  
ATOM   2194  NE2 GLN C  48      89.543  46.129  45.410  1.00 64.20           N  
ATOM   2195  N   THR C  49      87.438  40.940  41.753  1.00 41.74           N  
ATOM   2196  CA  THR C  49      86.740  40.431  40.583  1.00 40.08           C  
ATOM   2197  C   THR C  49      85.960  39.172  40.949  1.00 45.45           C  
ATOM   2198  O   THR C  49      84.878  38.928  40.404  1.00 42.95           O  
ATOM   2199  CB  THR C  49      87.709  40.097  39.438  1.00 41.56           C  
ATOM   2200  OG1 THR C  49      88.370  41.292  39.007  1.00 46.53           O  
ATOM   2201  CG2 THR C  49      86.951  39.498  38.266  1.00 41.70           C  
ATOM   2202  N   GLU C  50      86.500  38.380  41.877  1.00 40.28           N  
ATOM   2203  CA  GLU C  50      85.817  37.161  42.287  1.00 46.76           C  
ATOM   2204  C   GLU C  50      84.507  37.488  42.992  1.00 47.84           C  
ATOM   2205  O   GLU C  50      83.513  36.780  42.819  1.00 50.19           O  
ATOM   2206  CB  GLU C  50      86.695  36.307  43.211  1.00 47.23           C  
ATOM   2207  CG  GLU C  50      86.002  35.015  43.657  1.00 51.01           C  
ATOM   2208  CD  GLU C  50      86.872  34.124  44.525  1.00 66.71           C  
ATOM   2209  OE1 GLU C  50      87.278  34.566  45.622  1.00 74.38           O  
ATOM   2210  OE2 GLU C  50      87.144  32.976  44.109  1.00 66.28           O  
ATOM   2211  N   ARG C  51      84.506  38.553  43.790  1.00 50.23           N  
ATOM   2212  CA  ARG C  51      83.293  38.948  44.497  1.00 49.64           C  
ATOM   2213  C   ARG C  51      82.265  39.432  43.476  1.00 44.00           C  
ATOM   2214  O   ARG C  51      81.105  39.024  43.512  1.00 40.42           O  
ATOM   2215  CB  ARG C  51      83.593  40.050  45.516  1.00 49.25           C  
ATOM   2216  CG  ARG C  51      82.396  40.468  46.374  1.00 51.52           C  
ATOM   2217  CD  ARG C  51      81.840  39.310  47.203  1.00 48.80           C  
ATOM   2218  NE  ARG C  51      80.637  38.729  46.611  1.00 58.42           N  
ATOM   2219  CZ  ARG C  51      79.948  37.725  47.145  1.00 56.18           C  
ATOM   2220  NH1 ARG C  51      80.341  37.185  48.289  1.00 64.36           N  
ATOM   2221  NH2 ARG C  51      78.869  37.257  46.532  1.00 59.04           N  
ATOM   2222  N   VAL C  52      82.699  40.297  42.564  1.00 38.93           N  
ATOM   2223  CA  VAL C  52      81.817  40.813  41.521  1.00 42.18           C  
ATOM   2224  C   VAL C  52      81.205  39.640  40.751  1.00 45.72           C  
ATOM   2225  O   VAL C  52      80.000  39.627  40.483  1.00 47.98           O  
ATOM   2226  CB  VAL C  52      82.582  41.714  40.520  1.00 44.93           C  
ATOM   2227  CG1 VAL C  52      81.675  42.088  39.348  1.00 33.18           C  
ATOM   2228  CG2 VAL C  52      83.082  42.970  41.228  1.00 34.41           C  
HETATM 2229  N   MSE C  53      82.035  38.659  40.404  1.00 38.36           N  
HETATM 2230  CA  MSE C  53      81.550  37.485  39.682  1.00 43.61           C  
HETATM 2231  C   MSE C  53      80.470  36.756  40.478  1.00 47.87           C  
HETATM 2232  O   MSE C  53      79.392  36.453  39.952  1.00 47.30           O  
HETATM 2233  CB  MSE C  53      82.700  36.522  39.384  1.00 45.54           C  
HETATM 2234  CG  MSE C  53      83.661  37.012  38.314  1.00 47.37           C  
HETATM 2235 SE   MSE C  53      82.745  37.380  36.641  1.00 70.69          SE  
HETATM 2236  CE  MSE C  53      83.091  39.279  36.514  1.00 64.89           C  
ATOM   2237  N   GLU C  54      80.756  36.477  41.748  1.00 47.87           N  
ATOM   2238  CA  GLU C  54      79.794  35.789  42.600  1.00 44.91           C  
ATOM   2239  C   GLU C  54      78.472  36.550  42.660  1.00 46.85           C  
ATOM   2240  O   GLU C  54      77.397  35.943  42.619  1.00 36.62           O  
ATOM   2241  CB  GLU C  54      80.361  35.607  44.006  1.00 51.42           C  
ATOM   2242  CG  GLU C  54      81.440  34.529  44.119  1.00 63.42           C  
ATOM   2243  CD  GLU C  54      80.933  33.139  43.746  1.00 82.18           C  
ATOM   2244  OE1 GLU C  54      79.879  32.721  44.277  1.00 85.42           O  
ATOM   2245  OE2 GLU C  54      81.595  32.466  42.923  1.00 81.74           O  
ATOM   2246  N   ASN C  55      78.549  37.876  42.751  1.00 48.74           N  
ATOM   2247  CA  ASN C  55      77.341  38.694  42.794  1.00 40.53           C  
ATOM   2248  C   ASN C  55      76.533  38.522  41.503  1.00 45.93           C  
ATOM   2249  O   ASN C  55      75.318  38.330  41.547  1.00 47.55           O  
ATOM   2250  CB  ASN C  55      77.688  40.176  43.011  1.00 46.47           C  
ATOM   2251  CG  ASN C  55      78.124  40.478  44.450  1.00 60.03           C  
ATOM   2252  OD1 ASN C  55      77.809  39.731  45.384  1.00 51.21           O  
ATOM   2253  ND2 ASN C  55      78.838  41.587  44.631  1.00 45.05           N  
ATOM   2254  N   LEU C  56      77.202  38.580  40.355  1.00 35.84           N  
ATOM   2255  CA  LEU C  56      76.509  38.399  39.085  1.00 43.93           C  
ATOM   2256  C   LEU C  56      75.812  37.047  39.096  1.00 41.60           C  
ATOM   2257  O   LEU C  56      74.636  36.939  38.744  1.00 39.76           O  
ATOM   2258  CB  LEU C  56      77.491  38.453  37.911  1.00 40.39           C  
ATOM   2259  CG  LEU C  56      77.977  39.835  37.473  1.00 47.22           C  
ATOM   2260  CD1 LEU C  56      79.081  39.693  36.437  1.00 46.23           C  
ATOM   2261  CD2 LEU C  56      76.806  40.631  36.911  1.00 31.23           C  
ATOM   2262  N   LYS C  57      76.545  36.018  39.513  1.00 41.49           N  
ATOM   2263  CA  LYS C  57      76.002  34.667  39.566  1.00 40.35           C  
ATOM   2264  C   LYS C  57      74.712  34.613  40.382  1.00 40.94           C  
ATOM   2265  O   LYS C  57      73.716  34.035  39.944  1.00 43.71           O  
ATOM   2266  CB  LYS C  57      77.039  33.706  40.165  1.00 40.12           C  
ATOM   2267  CG  LYS C  57      76.566  32.259  40.246  1.00 48.03           C  
ATOM   2268  CD  LYS C  57      77.659  31.330  40.756  1.00 57.41           C  
ATOM   2269  CE  LYS C  57      77.136  29.906  40.943  1.00 46.79           C  
ATOM   2270  NZ  LYS C  57      78.094  29.067  41.720  1.00 57.55           N  
ATOM   2271  N   ALA C  58      74.738  35.225  41.565  1.00 37.02           N  
ATOM   2272  CA  ALA C  58      73.588  35.248  42.467  1.00 46.25           C  
ATOM   2273  C   ALA C  58      72.378  35.977  41.871  1.00 48.23           C  
ATOM   2274  O   ALA C  58      71.254  35.475  41.917  1.00 55.22           O  
ATOM   2275  CB  ALA C  58      73.993  35.890  43.804  1.00 31.35           C  
ATOM   2276  N   VAL C  59      72.614  37.162  41.320  1.00 45.66           N  
ATOM   2277  CA  VAL C  59      71.554  37.950  40.705  1.00 42.28           C  
ATOM   2278  C   VAL C  59      70.948  37.210  39.511  1.00 47.08           C  
ATOM   2279  O   VAL C  59      69.731  37.049  39.417  1.00 46.57           O  
ATOM   2280  CB  VAL C  59      72.096  39.320  40.229  1.00 47.06           C  
ATOM   2281  CG1 VAL C  59      71.024  40.079  39.466  1.00 31.38           C  
ATOM   2282  CG2 VAL C  59      72.559  40.129  41.423  1.00 37.36           C  
ATOM   2283  N   LEU C  60      71.803  36.757  38.601  1.00 39.95           N  
ATOM   2284  CA  LEU C  60      71.335  36.041  37.420  1.00 49.63           C  
ATOM   2285  C   LEU C  60      70.502  34.817  37.800  1.00 52.22           C  
ATOM   2286  O   LEU C  60      69.431  34.576  37.233  1.00 50.52           O  
ATOM   2287  CB  LEU C  60      72.525  35.606  36.559  1.00 49.18           C  
ATOM   2288  CG  LEU C  60      73.236  36.706  35.769  1.00 49.73           C  
ATOM   2289  CD1 LEU C  60      74.570  36.182  35.239  1.00 36.97           C  
ATOM   2290  CD2 LEU C  60      72.328  37.177  34.634  1.00 39.23           C  
ATOM   2291  N   GLU C  61      70.995  34.042  38.761  1.00 44.69           N  
ATOM   2292  CA  GLU C  61      70.274  32.857  39.194  1.00 47.09           C  
ATOM   2293  C   GLU C  61      68.894  33.238  39.727  1.00 51.19           C  
ATOM   2294  O   GLU C  61      67.892  32.630  39.344  1.00 52.84           O  
ATOM   2295  CB  GLU C  61      71.102  32.096  40.236  1.00 51.59           C  
ATOM   2296  CG  GLU C  61      72.213  31.249  39.591  1.00 72.85           C  
ATOM   2297  CD  GLU C  61      73.240  30.702  40.579  1.00 81.62           C  
ATOM   2298  OE1 GLU C  61      73.968  29.752  40.209  1.00 82.39           O  
ATOM   2299  OE2 GLU C  61      73.329  31.229  41.711  1.00 86.56           O  
ATOM   2300  N   ALA C  62      68.836  34.261  40.578  1.00 39.39           N  
ATOM   2301  CA  ALA C  62      67.563  34.712  41.140  1.00 50.06           C  
ATOM   2302  C   ALA C  62      66.576  35.118  40.043  1.00 51.58           C  
ATOM   2303  O   ALA C  62      65.362  35.062  40.233  1.00 45.94           O  
ATOM   2304  CB  ALA C  62      67.788  35.888  42.088  1.00 46.80           C  
ATOM   2305  N   ALA C  63      67.100  35.535  38.897  1.00 50.70           N  
ATOM   2306  CA  ALA C  63      66.244  35.952  37.796  1.00 49.29           C  
ATOM   2307  C   ALA C  63      65.787  34.756  36.980  1.00 49.59           C  
ATOM   2308  O   ALA C  63      65.130  34.916  35.946  1.00 58.55           O  
ATOM   2309  CB  ALA C  63      66.980  36.940  36.905  1.00 45.63           C  
ATOM   2310  N   GLY C  64      66.124  33.559  37.450  1.00 45.15           N  
ATOM   2311  CA  GLY C  64      65.745  32.361  36.724  1.00 42.82           C  
ATOM   2312  C   GLY C  64      66.585  32.201  35.468  1.00 51.85           C  
ATOM   2313  O   GLY C  64      66.148  31.604  34.483  1.00 52.66           O  
ATOM   2314  N   SER C  65      67.797  32.748  35.509  1.00 49.48           N  
ATOM   2315  CA  SER C  65      68.720  32.679  34.387  1.00 44.67           C  
ATOM   2316  C   SER C  65      70.036  32.079  34.882  1.00 49.94           C  
ATOM   2317  O   SER C  65      70.025  31.144  35.683  1.00 56.81           O  
ATOM   2318  CB  SER C  65      68.948  34.083  33.811  1.00 46.66           C  
ATOM   2319  OG  SER C  65      69.824  34.065  32.695  1.00 50.58           O  
ATOM   2320  N   GLY C  66      71.163  32.615  34.416  1.00 46.56           N  
ATOM   2321  CA  GLY C  66      72.457  32.099  34.829  1.00 37.79           C  
ATOM   2322  C   GLY C  66      73.617  32.703  34.054  1.00 44.33           C  
ATOM   2323  O   GLY C  66      73.406  33.487  33.125  1.00 51.16           O  
ATOM   2324  N   LEU C  67      74.837  32.336  34.441  1.00 47.11           N  
ATOM   2325  CA  LEU C  67      76.060  32.831  33.802  1.00 42.62           C  
ATOM   2326  C   LEU C  67      76.246  32.291  32.385  1.00 46.54           C  
ATOM   2327  O   LEU C  67      76.820  32.959  31.521  1.00 40.87           O  
ATOM   2328  CB  LEU C  67      77.286  32.449  34.638  1.00 41.20           C  
ATOM   2329  CG  LEU C  67      77.435  33.091  36.016  1.00 48.60           C  
ATOM   2330  CD1 LEU C  67      78.519  32.374  36.816  1.00 44.35           C  
ATOM   2331  CD2 LEU C  67      77.766  34.561  35.849  1.00 36.00           C  
ATOM   2332  N   SER C  68      75.766  31.079  32.146  1.00 46.15           N  
ATOM   2333  CA  SER C  68      75.899  30.481  30.825  1.00 44.13           C  
ATOM   2334  C   SER C  68      74.963  31.147  29.822  1.00 42.84           C  
ATOM   2335  O   SER C  68      75.101  30.960  28.622  1.00 38.05           O  
ATOM   2336  CB  SER C  68      75.596  28.985  30.887  1.00 41.56           C  
ATOM   2337  OG  SER C  68      74.232  28.744  31.191  1.00 36.04           O  
ATOM   2338  N   ARG C  69      74.022  31.941  30.316  1.00 41.75           N  
ATOM   2339  CA  ARG C  69      73.068  32.609  29.442  1.00 37.71           C  
ATOM   2340  C   ARG C  69      73.350  34.097  29.227  1.00 38.49           C  
ATOM   2341  O   ARG C  69      72.524  34.828  28.680  1.00 41.51           O  
ATOM   2342  CB  ARG C  69      71.666  32.410  29.997  1.00 44.34           C  
ATOM   2343  CG  ARG C  69      71.305  30.944  30.190  1.00 42.48           C  
ATOM   2344  CD  ARG C  69      70.203  30.519  29.236  1.00 55.54           C  
ATOM   2345  NE  ARG C  69      70.698  30.034  27.953  1.00 67.35           N  
ATOM   2346  CZ  ARG C  69      69.960  29.987  26.847  1.00 73.67           C  
ATOM   2347  NH1 ARG C  69      68.698  30.406  26.875  1.00 61.94           N  
ATOM   2348  NH2 ARG C  69      70.478  29.512  25.718  1.00 64.12           N  
ATOM   2349  N   VAL C  70      74.525  34.542  29.654  1.00 40.45           N  
ATOM   2350  CA  VAL C  70      74.912  35.932  29.493  1.00 36.83           C  
ATOM   2351  C   VAL C  70      75.359  36.176  28.051  1.00 41.64           C  
ATOM   2352  O   VAL C  70      76.208  35.455  27.536  1.00 35.87           O  
ATOM   2353  CB  VAL C  70      76.056  36.279  30.461  1.00 46.19           C  
ATOM   2354  CG1 VAL C  70      76.630  37.668  30.139  1.00 31.65           C  
ATOM   2355  CG2 VAL C  70      75.532  36.219  31.892  1.00 30.11           C  
ATOM   2356  N   VAL C  71      74.784  37.188  27.401  1.00 39.26           N  
ATOM   2357  CA  VAL C  71      75.139  37.497  26.020  1.00 36.38           C  
ATOM   2358  C   VAL C  71      76.019  38.737  25.880  1.00 37.59           C  
ATOM   2359  O   VAL C  71      76.678  38.927  24.860  1.00 42.18           O  
ATOM   2360  CB  VAL C  71      73.878  37.684  25.154  1.00 37.83           C  
ATOM   2361  CG1 VAL C  71      73.059  36.415  25.174  1.00 38.08           C  
ATOM   2362  CG2 VAL C  71      73.046  38.859  25.666  1.00 48.88           C  
ATOM   2363  N   GLN C  72      76.045  39.572  26.910  1.00 39.74           N  
ATOM   2364  CA  GLN C  72      76.840  40.793  26.851  1.00 38.62           C  
ATOM   2365  C   GLN C  72      77.246  41.321  28.225  1.00 37.13           C  
ATOM   2366  O   GLN C  72      76.464  41.293  29.171  1.00 37.97           O  
ATOM   2367  CB  GLN C  72      76.042  41.872  26.119  1.00 34.63           C  
ATOM   2368  CG  GLN C  72      76.679  43.236  26.096  1.00 36.72           C  
ATOM   2369  CD  GLN C  72      75.648  44.346  25.993  1.00 50.86           C  
ATOM   2370  OE1 GLN C  72      74.937  44.639  26.956  1.00 53.54           O  
ATOM   2371  NE2 GLN C  72      75.555  44.964  24.822  1.00 35.50           N  
ATOM   2372  N   THR C  73      78.477  41.802  28.323  1.00 27.97           N  
ATOM   2373  CA  THR C  73      78.972  42.371  29.564  1.00 29.44           C  
ATOM   2374  C   THR C  73      79.690  43.671  29.258  1.00 38.42           C  
ATOM   2375  O   THR C  73      80.340  43.814  28.213  1.00 34.67           O  
ATOM   2376  CB  THR C  73      79.994  41.471  30.288  1.00 28.04           C  
ATOM   2377  OG1 THR C  73      81.171  41.359  29.485  1.00 22.67           O  
ATOM   2378  CG2 THR C  73      79.414  40.096  30.588  1.00 22.99           C  
ATOM   2379  N   THR C  74      79.562  44.615  30.181  1.00 31.79           N  
ATOM   2380  CA  THR C  74      80.214  45.907  30.061  1.00 37.24           C  
ATOM   2381  C   THR C  74      81.142  45.942  31.275  1.00 33.97           C  
ATOM   2382  O   THR C  74      80.692  46.018  32.421  1.00 39.56           O  
ATOM   2383  CB  THR C  74      79.156  47.040  30.088  1.00 44.74           C  
ATOM   2384  OG1 THR C  74      78.270  46.878  28.972  1.00 37.78           O  
ATOM   2385  CG2 THR C  74      79.803  48.398  29.983  1.00 43.45           C  
ATOM   2386  N   CYS C  75      82.440  45.846  31.027  1.00 32.56           N  
ATOM   2387  CA  CYS C  75      83.400  45.808  32.123  1.00 39.75           C  
ATOM   2388  C   CYS C  75      84.191  47.088  32.315  1.00 35.27           C  
ATOM   2389  O   CYS C  75      84.892  47.545  31.410  1.00 40.12           O  
ATOM   2390  CB  CYS C  75      84.352  44.630  31.915  1.00 36.39           C  
ATOM   2391  SG  CYS C  75      83.483  43.096  31.534  1.00 49.40           S  
ATOM   2392  N   PHE C  76      84.072  47.662  33.505  1.00 33.83           N  
ATOM   2393  CA  PHE C  76      84.778  48.891  33.835  1.00 39.55           C  
ATOM   2394  C   PHE C  76      85.858  48.619  34.887  1.00 41.84           C  
ATOM   2395  O   PHE C  76      85.578  48.038  35.937  1.00 41.29           O  
ATOM   2396  CB  PHE C  76      83.799  49.938  34.381  1.00 39.91           C  
ATOM   2397  CG  PHE C  76      82.621  50.210  33.482  1.00 42.72           C  
ATOM   2398  CD1 PHE C  76      81.373  49.668  33.766  1.00 32.74           C  
ATOM   2399  CD2 PHE C  76      82.752  51.036  32.370  1.00 33.55           C  
ATOM   2400  CE1 PHE C  76      80.272  49.950  32.958  1.00 40.31           C  
ATOM   2401  CE2 PHE C  76      81.653  51.325  31.555  1.00 37.84           C  
ATOM   2402  CZ  PHE C  76      80.413  50.784  31.851  1.00 32.98           C  
ATOM   2403  N   LEU C  77      87.088  49.037  34.603  1.00 43.60           N  
ATOM   2404  CA  LEU C  77      88.201  48.860  35.539  1.00 42.42           C  
ATOM   2405  C   LEU C  77      88.743  50.236  35.928  1.00 48.61           C  
ATOM   2406  O   LEU C  77      88.649  51.183  35.144  1.00 49.18           O  
ATOM   2407  CB  LEU C  77      89.327  48.048  34.892  1.00 34.75           C  
ATOM   2408  CG  LEU C  77      89.040  46.612  34.449  1.00 44.16           C  
ATOM   2409  CD1 LEU C  77      90.209  46.087  33.631  1.00 35.73           C  
ATOM   2410  CD2 LEU C  77      88.788  45.741  35.668  1.00 36.93           C  
ATOM   2411  N   ALA C  78      89.308  50.348  37.129  1.00 47.46           N  
ATOM   2412  CA  ALA C  78      89.869  51.620  37.585  1.00 47.13           C  
ATOM   2413  C   ALA C  78      91.301  51.771  37.079  1.00 48.33           C  
ATOM   2414  O   ALA C  78      91.912  52.833  37.224  1.00 47.76           O  
ATOM   2415  CB  ALA C  78      89.847  51.695  39.120  1.00 40.10           C  
ATOM   2416  N   ASP C  79      91.833  50.709  36.483  1.00 45.02           N  
ATOM   2417  CA  ASP C  79      93.201  50.727  35.974  1.00 47.31           C  
ATOM   2418  C   ASP C  79      93.449  49.541  35.043  1.00 46.16           C  
ATOM   2419  O   ASP C  79      93.340  48.380  35.448  1.00 49.42           O  
ATOM   2420  CB  ASP C  79      94.180  50.703  37.150  1.00 46.79           C  
ATOM   2421  CG  ASP C  79      95.622  50.527  36.712  1.00 69.97           C  
ATOM   2422  OD1 ASP C  79      95.994  51.048  35.636  1.00 74.06           O  
ATOM   2423  OD2 ASP C  79      96.387  49.879  37.458  1.00 81.07           O  
HETATM 2424  N   MSE C  80      93.790  49.839  33.796  1.00 38.74           N  
HETATM 2425  CA  MSE C  80      94.025  48.798  32.795  1.00 46.54           C  
HETATM 2426  C   MSE C  80      95.118  47.787  33.171  1.00 46.12           C  
HETATM 2427  O   MSE C  80      95.114  46.658  32.685  1.00 46.41           O  
HETATM 2428  CB  MSE C  80      94.352  49.452  31.450  1.00 40.81           C  
HETATM 2429  CG  MSE C  80      93.865  48.688  30.211  1.00 59.69           C  
HETATM 2430 SE   MSE C  80      91.920  48.549  29.984  0.77 67.75          SE  
HETATM 2431  CE  MSE C  80      91.782  46.637  29.920  0.77 58.73           C  
ATOM   2432  N   GLU C  81      96.048  48.186  34.038  1.00 55.42           N  
ATOM   2433  CA  GLU C  81      97.123  47.289  34.464  1.00 59.99           C  
ATOM   2434  C   GLU C  81      96.498  46.085  35.159  1.00 57.11           C  
ATOM   2435  O   GLU C  81      97.141  45.051  35.331  1.00 58.46           O  
ATOM   2436  CB  GLU C  81      98.074  47.992  35.451  1.00 66.72           C  
ATOM   2437  CG  GLU C  81      98.612  49.351  34.997  1.00 80.94           C  
ATOM   2438  CD  GLU C  81      99.504  49.274  33.765  1.00 90.64           C  
ATOM   2439  OE1 GLU C  81     100.614  48.705  33.857  1.00 97.21           O  
ATOM   2440  OE2 GLU C  81      99.095  49.789  32.703  1.00 96.85           O  
ATOM   2441  N   ASP C  82      95.238  46.230  35.561  1.00 58.77           N  
ATOM   2442  CA  ASP C  82      94.531  45.159  36.247  1.00 47.64           C  
ATOM   2443  C   ASP C  82      93.809  44.179  35.338  1.00 46.43           C  
ATOM   2444  O   ASP C  82      93.225  43.218  35.835  1.00 41.24           O  
ATOM   2445  CB  ASP C  82      93.511  45.732  37.232  1.00 55.63           C  
ATOM   2446  CG  ASP C  82      94.150  46.247  38.501  1.00 63.73           C  
ATOM   2447  OD1 ASP C  82      95.135  45.635  38.958  1.00 76.74           O  
ATOM   2448  OD2 ASP C  82      93.658  47.252  39.051  1.00 70.63           O  
ATOM   2449  N   PHE C  83      93.845  44.404  34.023  1.00 42.52           N  
ATOM   2450  CA  PHE C  83      93.153  43.510  33.096  1.00 44.03           C  
ATOM   2451  C   PHE C  83      93.533  42.032  33.237  1.00 46.79           C  
ATOM   2452  O   PHE C  83      92.654  41.174  33.359  1.00 51.77           O  
ATOM   2453  CB  PHE C  83      93.367  43.940  31.643  1.00 38.93           C  
ATOM   2454  CG  PHE C  83      92.540  43.155  30.666  1.00 44.43           C  
ATOM   2455  CD1 PHE C  83      91.174  43.378  30.555  1.00 41.95           C  
ATOM   2456  CD2 PHE C  83      93.121  42.149  29.891  1.00 53.88           C  
ATOM   2457  CE1 PHE C  83      90.393  42.608  29.689  1.00 52.12           C  
ATOM   2458  CE2 PHE C  83      92.351  41.372  29.022  1.00 36.18           C  
ATOM   2459  CZ  PHE C  83      90.982  41.603  28.920  1.00 55.85           C  
ATOM   2460  N   PRO C  84      94.842  41.710  33.218  1.00 47.31           N  
ATOM   2461  CA  PRO C  84      95.277  40.313  33.348  1.00 43.09           C  
ATOM   2462  C   PRO C  84      94.564  39.579  34.475  1.00 37.21           C  
ATOM   2463  O   PRO C  84      93.939  38.545  34.250  1.00 46.54           O  
ATOM   2464  CB  PRO C  84      96.772  40.447  33.599  1.00 41.92           C  
ATOM   2465  CG  PRO C  84      97.125  41.636  32.773  1.00 36.43           C  
ATOM   2466  CD  PRO C  84      96.009  42.603  33.105  1.00 34.54           C  
ATOM   2467  N   GLY C  85      94.655  40.128  35.682  1.00 45.66           N  
ATOM   2468  CA  GLY C  85      94.013  39.517  36.835  1.00 42.68           C  
ATOM   2469  C   GLY C  85      92.507  39.445  36.679  1.00 46.07           C  
ATOM   2470  O   GLY C  85      91.875  38.440  37.015  1.00 49.77           O  
ATOM   2471  N   PHE C  86      91.931  40.527  36.173  1.00 43.68           N  
ATOM   2472  CA  PHE C  86      90.498  40.592  35.946  1.00 43.61           C  
ATOM   2473  C   PHE C  86      90.060  39.488  34.984  1.00 47.76           C  
ATOM   2474  O   PHE C  86      89.182  38.678  35.302  1.00 44.31           O  
ATOM   2475  CB  PHE C  86      90.114  41.955  35.359  1.00 34.86           C  
ATOM   2476  CG  PHE C  86      88.712  42.003  34.822  1.00 35.55           C  
ATOM   2477  CD1 PHE C  86      88.478  42.069  33.450  1.00 24.36           C  
ATOM   2478  CD2 PHE C  86      87.624  41.948  35.686  1.00 25.70           C  
ATOM   2479  CE1 PHE C  86      87.176  42.075  32.947  1.00 34.67           C  
ATOM   2480  CE2 PHE C  86      86.320  41.953  35.189  1.00 38.31           C  
ATOM   2481  CZ  PHE C  86      86.097  42.017  33.819  1.00 28.15           C  
ATOM   2482  N   ASN C  87      90.681  39.466  33.808  1.00 44.92           N  
ATOM   2483  CA  ASN C  87      90.359  38.490  32.775  1.00 40.85           C  
ATOM   2484  C   ASN C  87      90.469  37.049  33.289  1.00 47.94           C  
ATOM   2485  O   ASN C  87      89.602  36.219  33.011  1.00 55.76           O  
ATOM   2486  CB  ASN C  87      91.282  38.722  31.574  1.00 34.57           C  
ATOM   2487  CG  ASN C  87      90.695  38.208  30.269  1.00 44.91           C  
ATOM   2488  OD1 ASN C  87      89.485  38.260  30.055  1.00 43.48           O  
ATOM   2489  ND2 ASN C  87      91.557  37.734  29.378  1.00 46.72           N  
ATOM   2490  N   GLU C  88      91.522  36.761  34.052  1.00 46.46           N  
ATOM   2491  CA  GLU C  88      91.734  35.423  34.598  1.00 43.67           C  
ATOM   2492  C   GLU C  88      90.527  34.938  35.394  1.00 42.88           C  
ATOM   2493  O   GLU C  88      89.975  33.872  35.125  1.00 50.10           O  
ATOM   2494  CB  GLU C  88      92.970  35.405  35.498  1.00 48.81           C  
ATOM   2495  CG  GLU C  88      93.270  34.032  36.102  1.00 50.15           C  
ATOM   2496  CD  GLU C  88      94.403  34.059  37.128  1.00 69.16           C  
ATOM   2497  OE1 GLU C  88      95.529  34.490  36.780  1.00 56.38           O  
ATOM   2498  OE2 GLU C  88      94.161  33.642  38.284  1.00 65.90           O  
ATOM   2499  N   VAL C  89      90.117  35.720  36.381  1.00 40.70           N  
ATOM   2500  CA  VAL C  89      88.978  35.344  37.203  1.00 42.50           C  
ATOM   2501  C   VAL C  89      87.737  35.277  36.324  1.00 39.29           C  
ATOM   2502  O   VAL C  89      86.950  34.338  36.419  1.00 46.60           O  
ATOM   2503  CB  VAL C  89      88.756  36.367  38.348  1.00 44.16           C  
ATOM   2504  CG1 VAL C  89      87.680  35.874  39.297  1.00 30.80           C  
ATOM   2505  CG2 VAL C  89      90.051  36.589  39.103  1.00 45.57           C  
ATOM   2506  N   TYR C  90      87.585  36.276  35.459  1.00 46.75           N  
ATOM   2507  CA  TYR C  90      86.449  36.376  34.537  1.00 43.73           C  
ATOM   2508  C   TYR C  90      86.247  35.090  33.722  1.00 40.92           C  
ATOM   2509  O   TYR C  90      85.129  34.582  33.602  1.00 41.93           O  
ATOM   2510  CB  TYR C  90      86.673  37.560  33.592  1.00 44.22           C  
ATOM   2511  CG  TYR C  90      85.522  37.878  32.661  1.00 52.34           C  
ATOM   2512  CD1 TYR C  90      84.538  38.800  33.024  1.00 46.87           C  
ATOM   2513  CD2 TYR C  90      85.434  37.280  31.403  1.00 42.70           C  
ATOM   2514  CE1 TYR C  90      83.499  39.122  32.152  1.00 41.20           C  
ATOM   2515  CE2 TYR C  90      84.404  37.593  30.530  1.00 42.17           C  
ATOM   2516  CZ  TYR C  90      83.442  38.515  30.909  1.00 45.72           C  
ATOM   2517  OH  TYR C  90      82.429  38.832  30.042  1.00 33.66           O  
ATOM   2518  N   ALA C  91      87.333  34.575  33.162  1.00 26.48           N  
ATOM   2519  CA  ALA C  91      87.278  33.348  32.365  1.00 39.80           C  
ATOM   2520  C   ALA C  91      86.768  32.140  33.148  1.00 34.52           C  
ATOM   2521  O   ALA C  91      86.318  31.167  32.561  1.00 45.20           O  
ATOM   2522  CB  ALA C  91      88.659  33.035  31.788  1.00 28.93           C  
ATOM   2523  N   ARG C  92      86.839  32.193  34.470  1.00 37.73           N  
ATOM   2524  CA  ARG C  92      86.378  31.069  35.279  1.00 41.59           C  
ATOM   2525  C   ARG C  92      84.879  30.877  35.223  1.00 41.00           C  
ATOM   2526  O   ARG C  92      84.401  29.753  35.096  1.00 48.03           O  
ATOM   2527  CB  ARG C  92      86.779  31.247  36.748  1.00 31.69           C  
ATOM   2528  CG  ARG C  92      88.274  31.208  37.002  1.00 53.59           C  
ATOM   2529  CD  ARG C  92      88.586  31.539  38.455  1.00 53.89           C  
ATOM   2530  NE  ARG C  92      89.988  31.904  38.623  1.00 62.53           N  
ATOM   2531  CZ  ARG C  92      90.489  32.465  39.717  1.00 58.00           C  
ATOM   2532  NH1 ARG C  92      89.701  32.725  40.750  1.00 49.14           N  
ATOM   2533  NH2 ARG C  92      91.773  32.785  39.768  1.00 60.48           N  
ATOM   2534  N   TYR C  93      84.141  31.981  35.316  1.00 47.72           N  
ATOM   2535  CA  TYR C  93      82.684  31.937  35.347  1.00 40.15           C  
ATOM   2536  C   TYR C  93      81.937  31.905  34.026  1.00 43.92           C  
ATOM   2537  O   TYR C  93      80.743  31.595  34.000  1.00 36.70           O  
ATOM   2538  CB  TYR C  93      82.162  33.101  36.187  1.00 36.85           C  
ATOM   2539  CG  TYR C  93      82.748  33.119  37.572  1.00 34.52           C  
ATOM   2540  CD1 TYR C  93      83.997  33.685  37.815  1.00 35.04           C  
ATOM   2541  CD2 TYR C  93      82.088  32.499  38.629  1.00 37.28           C  
ATOM   2542  CE1 TYR C  93      84.581  33.625  39.088  1.00 44.93           C  
ATOM   2543  CE2 TYR C  93      82.659  32.432  39.901  1.00 37.77           C  
ATOM   2544  CZ  TYR C  93      83.903  32.992  40.123  1.00 42.01           C  
ATOM   2545  OH  TYR C  93      84.473  32.894  41.372  1.00 52.60           O  
ATOM   2546  N   PHE C  94      82.604  32.219  32.923  1.00 42.21           N  
ATOM   2547  CA  PHE C  94      81.889  32.197  31.665  1.00 40.28           C  
ATOM   2548  C   PHE C  94      82.177  30.972  30.804  1.00 42.38           C  
ATOM   2549  O   PHE C  94      83.216  30.336  30.929  1.00 49.62           O  
ATOM   2550  CB  PHE C  94      82.118  33.515  30.933  1.00 38.56           C  
ATOM   2551  CG  PHE C  94      81.507  34.695  31.651  1.00 49.43           C  
ATOM   2552  CD1 PHE C  94      82.290  35.551  32.419  1.00 62.08           C  
ATOM   2553  CD2 PHE C  94      80.131  34.902  31.619  1.00 40.37           C  
ATOM   2554  CE1 PHE C  94      81.706  36.591  33.145  1.00 54.04           C  
ATOM   2555  CE2 PHE C  94      79.545  35.930  32.338  1.00 38.24           C  
ATOM   2556  CZ  PHE C  94      80.328  36.777  33.102  1.00 46.06           C  
ATOM   2557  N   THR C  95      81.223  30.638  29.943  1.00 51.55           N  
ATOM   2558  CA  THR C  95      81.309  29.458  29.096  1.00 48.10           C  
ATOM   2559  C   THR C  95      81.002  29.681  27.609  1.00 53.26           C  
ATOM   2560  O   THR C  95      80.256  30.586  27.242  1.00 61.00           O  
ATOM   2561  CB  THR C  95      80.334  28.406  29.639  1.00 46.56           C  
ATOM   2562  OG1 THR C  95      80.879  27.831  30.831  1.00 67.66           O  
ATOM   2563  CG2 THR C  95      80.051  27.313  28.607  1.00 72.08           C  
ATOM   2564  N   PRO C  96      81.590  28.857  26.731  1.00 43.77           N  
ATOM   2565  CA  PRO C  96      81.329  28.998  25.296  1.00 42.63           C  
ATOM   2566  C   PRO C  96      79.849  28.653  25.043  1.00 51.36           C  
ATOM   2567  O   PRO C  96      79.347  27.646  25.553  1.00 50.35           O  
ATOM   2568  CB  PRO C  96      82.269  27.968  24.670  1.00 48.56           C  
ATOM   2569  CG  PRO C  96      83.411  27.912  25.646  1.00 52.17           C  
ATOM   2570  CD  PRO C  96      82.700  27.917  26.974  1.00 49.86           C  
ATOM   2571  N   PRO C  97      79.130  29.481  24.266  1.00 49.69           N  
ATOM   2572  CA  PRO C  97      79.548  30.720  23.597  1.00 51.45           C  
ATOM   2573  C   PRO C  97      79.761  31.827  24.628  1.00 48.11           C  
ATOM   2574  O   PRO C  97      78.858  32.139  25.403  1.00 45.33           O  
ATOM   2575  CB  PRO C  97      78.370  31.041  22.671  1.00 56.03           C  
ATOM   2576  CG  PRO C  97      77.486  29.792  22.704  1.00 59.14           C  
ATOM   2577  CD  PRO C  97      77.688  29.262  24.083  1.00 42.53           C  
ATOM   2578  N   TYR C  98      80.948  32.417  24.641  1.00 51.64           N  
ATOM   2579  CA  TYR C  98      81.244  33.470  25.596  1.00 42.65           C  
ATOM   2580  C   TYR C  98      80.428  34.713  25.291  1.00 44.41           C  
ATOM   2581  O   TYR C  98      80.022  34.930  24.153  1.00 49.96           O  
ATOM   2582  CB  TYR C  98      82.730  33.812  25.566  1.00 38.83           C  
ATOM   2583  CG  TYR C  98      83.626  32.727  26.116  1.00 48.17           C  
ATOM   2584  CD1 TYR C  98      84.566  32.096  25.303  1.00 43.34           C  
ATOM   2585  CD2 TYR C  98      83.548  32.345  27.459  1.00 52.79           C  
ATOM   2586  CE1 TYR C  98      85.412  31.115  25.809  1.00 42.23           C  
ATOM   2587  CE2 TYR C  98      84.386  31.360  27.975  1.00 46.01           C  
ATOM   2588  CZ  TYR C  98      85.318  30.755  27.145  1.00 54.55           C  
ATOM   2589  OH  TYR C  98      86.167  29.807  27.655  1.00 48.57           O  
ATOM   2590  N   PRO C  99      80.182  35.552  26.310  1.00 38.95           N  
ATOM   2591  CA  PRO C  99      79.408  36.775  26.113  1.00 35.51           C  
ATOM   2592  C   PRO C  99      80.193  37.745  25.248  1.00 32.21           C  
ATOM   2593  O   PRO C  99      81.408  37.622  25.124  1.00 36.89           O  
ATOM   2594  CB  PRO C  99      79.234  37.308  27.537  1.00 34.95           C  
ATOM   2595  CG  PRO C  99      79.336  36.073  28.393  1.00 33.78           C  
ATOM   2596  CD  PRO C  99      80.488  35.364  27.738  1.00 37.30           C  
ATOM   2597  N   ALA C 100      79.492  38.684  24.621  1.00 36.32           N  
ATOM   2598  CA  ALA C 100      80.157  39.704  23.824  1.00 39.27           C  
ATOM   2599  C   ALA C 100      80.698  40.595  24.933  1.00 36.93           C  
ATOM   2600  O   ALA C 100      80.100  40.667  26.003  1.00 36.28           O  
ATOM   2601  CB  ALA C 100      79.146  40.459  22.971  1.00 33.98           C  
ATOM   2602  N   ARG C 101      81.811  41.277  24.709  1.00 37.39           N  
ATOM   2603  CA  ARG C 101      82.349  42.089  25.786  1.00 29.26           C  
ATOM   2604  C   ARG C 101      82.971  43.399  25.354  1.00 33.60           C  
ATOM   2605  O   ARG C 101      83.496  43.512  24.246  1.00 36.58           O  
ATOM   2606  CB  ARG C 101      83.390  41.271  26.561  1.00 37.04           C  
ATOM   2607  CG  ARG C 101      83.824  41.881  27.887  1.00 42.72           C  
ATOM   2608  CD  ARG C 101      84.816  40.989  28.619  1.00 35.95           C  
ATOM   2609  NE  ARG C 101      86.058  40.834  27.865  1.00 46.99           N  
ATOM   2610  CZ  ARG C 101      87.068  40.055  28.236  1.00 46.27           C  
ATOM   2611  NH1 ARG C 101      86.988  39.352  29.357  1.00 42.60           N  
ATOM   2612  NH2 ARG C 101      88.162  39.978  27.488  1.00 51.64           N  
ATOM   2613  N   ALA C 102      82.885  44.382  26.249  1.00 29.10           N  
ATOM   2614  CA  ALA C 102      83.477  45.707  26.062  1.00 33.40           C  
ATOM   2615  C   ALA C 102      84.166  45.978  27.397  1.00 37.37           C  
ATOM   2616  O   ALA C 102      83.540  45.884  28.456  1.00 42.02           O  
ATOM   2617  CB  ALA C 102      82.412  46.765  25.795  1.00 35.47           C  
ATOM   2618  N   THR C 103      85.457  46.283  27.347  1.00 42.80           N  
ATOM   2619  CA  THR C 103      86.233  46.544  28.552  1.00 37.39           C  
ATOM   2620  C   THR C 103      86.865  47.916  28.443  1.00 38.62           C  
ATOM   2621  O   THR C 103      87.352  48.293  27.377  1.00 33.89           O  
ATOM   2622  CB  THR C 103      87.350  45.488  28.737  1.00 43.69           C  
ATOM   2623  OG1 THR C 103      86.764  44.181  28.809  1.00 57.85           O  
ATOM   2624  CG2 THR C 103      88.131  45.752  30.016  1.00 41.89           C  
ATOM   2625  N   VAL C 104      86.871  48.648  29.552  1.00 33.01           N  
ATOM   2626  CA  VAL C 104      87.428  49.994  29.582  1.00 30.81           C  
ATOM   2627  C   VAL C 104      87.947  50.371  30.975  1.00 40.91           C  
ATOM   2628  O   VAL C 104      87.529  49.810  31.996  1.00 35.49           O  
ATOM   2629  CB  VAL C 104      86.347  51.039  29.165  1.00 39.82           C  
ATOM   2630  CG1 VAL C 104      86.860  52.435  29.380  1.00 56.64           C  
ATOM   2631  CG2 VAL C 104      85.965  50.864  27.708  1.00 43.80           C  
ATOM   2632  N   ALA C 105      88.869  51.329  31.000  1.00 42.35           N  
ATOM   2633  CA  ALA C 105      89.431  51.843  32.241  1.00 37.35           C  
ATOM   2634  C   ALA C 105      88.760  53.201  32.424  1.00 38.82           C  
ATOM   2635  O   ALA C 105      88.783  54.040  31.526  1.00 47.56           O  
ATOM   2636  CB  ALA C 105      90.936  52.016  32.107  1.00 36.59           C  
ATOM   2637  N   VAL C 106      88.140  53.415  33.576  1.00 46.11           N  
ATOM   2638  CA  VAL C 106      87.469  54.682  33.823  1.00 41.54           C  
ATOM   2639  C   VAL C 106      88.165  55.470  34.918  1.00 43.32           C  
ATOM   2640  O   VAL C 106      89.046  54.954  35.597  1.00 42.05           O  
ATOM   2641  CB  VAL C 106      86.000  54.462  34.212  1.00 41.36           C  
ATOM   2642  CG1 VAL C 106      85.239  53.917  33.025  1.00 35.23           C  
ATOM   2643  CG2 VAL C 106      85.907  53.494  35.388  1.00 32.31           C  
ATOM   2644  N   LYS C 107      87.756  56.723  35.081  1.00 49.45           N  
ATOM   2645  CA  LYS C 107      88.334  57.608  36.083  1.00 48.87           C  
ATOM   2646  C   LYS C 107      88.132  57.082  37.502  1.00 44.82           C  
ATOM   2647  O   LYS C 107      89.078  57.009  38.278  1.00 42.27           O  
ATOM   2648  CB  LYS C 107      87.716  59.003  35.945  1.00 55.08           C  
ATOM   2649  CG  LYS C 107      88.374  60.075  36.803  1.00 53.53           C  
ATOM   2650  CD  LYS C 107      87.779  61.449  36.521  1.00 60.73           C  
ATOM   2651  CE  LYS C 107      88.481  62.541  37.315  1.00 57.46           C  
ATOM   2652  NZ  LYS C 107      87.905  63.876  37.006  1.00 61.53           N  
ATOM   2653  N   ALA C 108      86.899  56.708  37.829  1.00 41.83           N  
ATOM   2654  CA  ALA C 108      86.572  56.195  39.158  1.00 42.52           C  
ATOM   2655  C   ALA C 108      85.305  55.353  39.156  1.00 39.51           C  
ATOM   2656  O   ALA C 108      84.420  55.527  38.315  1.00 37.98           O  
ATOM   2657  CB  ALA C 108      86.404  57.351  40.145  1.00 24.22           C  
ATOM   2658  N   LEU C 109      85.224  54.450  40.126  1.00 46.08           N  
ATOM   2659  CA  LEU C 109      84.072  53.578  40.276  1.00 47.95           C  
ATOM   2660  C   LEU C 109      83.427  53.823  41.627  1.00 52.93           C  
ATOM   2661  O   LEU C 109      84.046  54.404  42.524  1.00 51.11           O  
ATOM   2662  CB  LEU C 109      84.498  52.117  40.179  1.00 43.39           C  
ATOM   2663  CG  LEU C 109      85.106  51.713  38.842  1.00 45.11           C  
ATOM   2664  CD1 LEU C 109      85.377  50.220  38.858  1.00 42.46           C  
ATOM   2665  CD2 LEU C 109      84.147  52.085  37.713  1.00 37.04           C  
ATOM   2666  N   PRO C 110      82.167  53.391  41.788  1.00 56.92           N  
ATOM   2667  CA  PRO C 110      81.462  53.576  43.056  1.00 52.59           C  
ATOM   2668  C   PRO C 110      82.316  53.080  44.204  1.00 51.69           C  
ATOM   2669  O   PRO C 110      83.054  52.107  44.064  1.00 52.58           O  
ATOM   2670  CB  PRO C 110      80.202  52.743  42.866  1.00 53.05           C  
ATOM   2671  CG  PRO C 110      79.912  52.947  41.413  1.00 51.11           C  
ATOM   2672  CD  PRO C 110      81.278  52.793  40.775  1.00 46.40           C  
ATOM   2673  N   ARG C 111      82.231  53.779  45.328  1.00 54.67           N  
ATOM   2674  CA  ARG C 111      82.975  53.423  46.527  1.00 51.57           C  
ATOM   2675  C   ARG C 111      84.452  53.076  46.348  1.00 52.29           C  
ATOM   2676  O   ARG C 111      84.973  52.187  47.021  1.00 54.43           O  
ATOM   2677  CB  ARG C 111      82.253  52.289  47.244  1.00 50.56           C  
ATOM   2678  CG  ARG C 111      80.874  52.691  47.744  1.00 68.20           C  
ATOM   2679  CD  ARG C 111      80.335  51.614  48.636  1.00 71.39           C  
ATOM   2680  NE  ARG C 111      81.301  51.365  49.695  1.00 82.90           N  
ATOM   2681  CZ  ARG C 111      81.111  50.548  50.722  1.00 84.72           C  
ATOM   2682  NH1 ARG C 111      79.972  49.879  50.850  1.00 84.67           N  
ATOM   2683  NH2 ARG C 111      82.071  50.399  51.624  1.00 86.71           N  
ATOM   2684  N   GLY C 112      85.119  53.788  45.443  1.00 52.54           N  
ATOM   2685  CA  GLY C 112      86.541  53.584  45.207  1.00 50.25           C  
ATOM   2686  C   GLY C 112      86.963  52.199  44.753  1.00 58.10           C  
ATOM   2687  O   GLY C 112      88.160  51.887  44.700  1.00 49.89           O  
ATOM   2688  N   VAL C 113      85.981  51.369  44.422  1.00 54.73           N  
ATOM   2689  CA  VAL C 113      86.231  50.014  43.970  1.00 42.46           C  
ATOM   2690  C   VAL C 113      87.059  50.001  42.679  1.00 50.64           C  
ATOM   2691  O   VAL C 113      87.169  51.022  42.002  1.00 54.60           O  
ATOM   2692  CB  VAL C 113      84.881  49.305  43.809  1.00 50.18           C  
ATOM   2693  CG1 VAL C 113      84.790  48.582  42.484  1.00 43.77           C  
ATOM   2694  CG2 VAL C 113      84.684  48.372  44.981  1.00 44.40           C  
ATOM   2695  N   ARG C 114      87.649  48.858  42.338  1.00 42.46           N  
ATOM   2696  CA  ARG C 114      88.477  48.780  41.132  1.00 46.40           C  
ATOM   2697  C   ARG C 114      87.889  48.038  39.930  1.00 46.15           C  
ATOM   2698  O   ARG C 114      88.502  47.992  38.859  1.00 40.28           O  
ATOM   2699  CB  ARG C 114      89.840  48.181  41.480  1.00 45.13           C  
ATOM   2700  CG  ARG C 114      89.806  46.739  41.915  1.00 57.39           C  
ATOM   2701  CD  ARG C 114      91.012  46.426  42.785  1.00 65.73           C  
ATOM   2702  NE  ARG C 114      92.172  47.225  42.406  1.00 64.49           N  
ATOM   2703  CZ  ARG C 114      93.354  47.150  43.003  1.00 62.86           C  
ATOM   2704  NH1 ARG C 114      93.528  46.303  44.009  1.00 55.87           N  
ATOM   2705  NH2 ARG C 114      94.355  47.922  42.595  1.00 56.01           N  
ATOM   2706  N   VAL C 115      86.707  47.459  40.099  1.00 42.18           N  
ATOM   2707  CA  VAL C 115      86.058  46.751  39.006  1.00 35.63           C  
ATOM   2708  C   VAL C 115      84.545  46.777  39.159  1.00 39.04           C  
ATOM   2709  O   VAL C 115      84.020  46.607  40.261  1.00 36.19           O  
ATOM   2710  CB  VAL C 115      86.508  45.272  38.936  1.00 37.64           C  
ATOM   2711  CG1 VAL C 115      86.205  44.569  40.255  1.00 38.27           C  
ATOM   2712  CG2 VAL C 115      85.792  44.560  37.798  1.00 39.56           C  
ATOM   2713  N   GLU C 116      83.856  46.992  38.044  1.00 32.63           N  
ATOM   2714  CA  GLU C 116      82.401  47.008  38.011  1.00 34.32           C  
ATOM   2715  C   GLU C 116      82.013  46.299  36.724  1.00 39.78           C  
ATOM   2716  O   GLU C 116      82.607  46.559  35.675  1.00 40.61           O  
ATOM   2717  CB  GLU C 116      81.860  48.433  37.966  1.00 32.53           C  
ATOM   2718  CG  GLU C 116      80.345  48.507  38.076  1.00 35.78           C  
ATOM   2719  CD  GLU C 116      79.805  49.917  37.889  1.00 45.04           C  
ATOM   2720  OE1 GLU C 116      80.515  50.875  38.254  1.00 38.54           O  
ATOM   2721  OE2 GLU C 116      78.664  50.069  37.390  1.00 45.23           O  
ATOM   2722  N   VAL C 117      81.034  45.402  36.796  1.00 33.76           N  
ATOM   2723  CA  VAL C 117      80.592  44.684  35.611  1.00 33.47           C  
ATOM   2724  C   VAL C 117      79.078  44.592  35.544  1.00 36.27           C  
ATOM   2725  O   VAL C 117      78.423  44.149  36.485  1.00 33.73           O  
ATOM   2726  CB  VAL C 117      81.169  43.251  35.543  1.00 35.21           C  
ATOM   2727  CG1 VAL C 117      80.693  42.564  34.272  1.00 22.80           C  
ATOM   2728  CG2 VAL C 117      82.690  43.291  35.566  1.00 26.79           C  
ATOM   2729  N   ALA C 118      78.533  45.044  34.421  1.00 34.64           N  
ATOM   2730  CA  ALA C 118      77.102  45.000  34.172  1.00 42.19           C  
ATOM   2731  C   ALA C 118      76.943  44.019  33.023  1.00 42.98           C  
ATOM   2732  O   ALA C 118      77.873  43.831  32.232  1.00 39.62           O  
ATOM   2733  CB  ALA C 118      76.582  46.380  33.767  1.00 39.88           C  
ATOM   2734  N   CYS C 119      75.783  43.385  32.922  1.00 36.79           N  
ATOM   2735  CA  CYS C 119      75.590  42.435  31.842  1.00 38.58           C  
ATOM   2736  C   CYS C 119      74.145  42.251  31.447  1.00 39.06           C  
ATOM   2737  O   CYS C 119      73.220  42.667  32.156  1.00 34.83           O  
ATOM   2738  CB  CYS C 119      76.167  41.067  32.220  1.00 44.58           C  
ATOM   2739  SG  CYS C 119      75.140  40.127  33.375  1.00 46.32           S  
ATOM   2740  N   VAL C 120      73.966  41.610  30.300  1.00 31.99           N  
ATOM   2741  CA  VAL C 120      72.647  41.315  29.779  1.00 38.18           C  
ATOM   2742  C   VAL C 120      72.636  39.831  29.452  1.00 39.56           C  
ATOM   2743  O   VAL C 120      73.533  39.331  28.767  1.00 42.34           O  
ATOM   2744  CB  VAL C 120      72.354  42.133  28.512  1.00 29.00           C  
ATOM   2745  CG1 VAL C 120      71.061  41.659  27.873  1.00 25.08           C  
ATOM   2746  CG2 VAL C 120      72.255  43.606  28.870  1.00 29.21           C  
ATOM   2747  N   ALA C 121      71.634  39.122  29.959  1.00 42.75           N  
ATOM   2748  CA  ALA C 121      71.522  37.688  29.709  1.00 43.03           C  
ATOM   2749  C   ALA C 121      70.132  37.341  29.216  1.00 40.77           C  
ATOM   2750  O   ALA C 121      69.206  38.144  29.344  1.00 39.55           O  
ATOM   2751  CB  ALA C 121      71.822  36.909  30.973  1.00 34.18           C  
ATOM   2752  N   LEU C 122      70.000  36.149  28.636  1.00 40.47           N  
ATOM   2753  CA  LEU C 122      68.714  35.670  28.146  1.00 46.63           C  
ATOM   2754  C   LEU C 122      67.904  35.111  29.304  1.00 49.39           C  
ATOM   2755  O   LEU C 122      68.444  34.436  30.183  1.00 47.15           O  
ATOM   2756  CB  LEU C 122      68.905  34.554  27.114  1.00 43.12           C  
ATOM   2757  CG  LEU C 122      69.299  34.931  25.688  1.00 53.41           C  
ATOM   2758  CD1 LEU C 122      69.607  33.670  24.884  1.00 42.93           C  
ATOM   2759  CD2 LEU C 122      68.160  35.713  25.044  1.00 41.79           C  
ATOM   2760  N   ALA C 123      66.610  35.403  29.306  1.00 53.52           N  
ATOM   2761  CA  ALA C 123      65.724  34.878  30.328  1.00 64.70           C  
ATOM   2762  C   ALA C 123      65.464  33.454  29.866  1.00 74.67           C  
ATOM   2763  O   ALA C 123      65.735  33.132  28.708  1.00 78.74           O  
ATOM   2764  CB  ALA C 123      64.429  35.671  30.356  1.00 62.03           C  
ATOM   2765  N   GLU C 124      64.952  32.600  30.747  1.00 86.72           N  
ATOM   2766  CA  GLU C 124      64.680  31.219  30.359  1.00 96.09           C  
ATOM   2767  C   GLU C 124      63.195  30.918  30.207  1.00 99.92           C  
ATOM   2768  O   GLU C 124      62.720  29.951  30.839  1.00103.74           O  
ATOM   2769  CB  GLU C 124      65.308  30.250  31.366  1.00 98.07           C  
ATOM   2770  CG  GLU C 124      66.817  30.138  31.235  1.00102.83           C  
ATOM   2771  CD  GLU C 124      67.251  29.957  29.790  1.00106.72           C  
ATOM   2772  OE1 GLU C 124      67.341  30.968  29.057  1.00 96.52           O  
ATOM   2773  OE2 GLU C 124      67.488  28.800  29.383  1.00111.95           O  
ATOM   2774  OXT GLU C 124      62.528  31.645  29.439  1.00102.49           O  
TER    2775      GLU C 124                                                      
END
MOLECULE T0423.pdb
ATOM  12910  N   MET     1      70.981  21.031  37.362  1.00 36.76           N  
ATOM  12911  CA  MET     1      71.905  21.930  36.664  1.00 38.87           C  
ATOM  12912  C   MET     1      72.311  23.119  37.519  1.00 35.58           C  
ATOM  12913  O   MET     1      73.455  23.538  37.475  1.00 34.69           O  
ATOM  12914  CB  MET     1      71.283  22.461  35.383  1.00 39.21           C  
ATOM  12915  CG  MET     1      71.504  21.613  34.171  1.00 44.40           C  
ATOM  12916  SD  MET     1      70.806  22.501  32.558  1.00 57.84          SE  
ATOM  12917  CE  MET     1      71.792  24.214  32.666  1.00 53.65           C  
ATOM  12918  N   SER     2      71.368  23.671  38.275  1.00 34.19           N  
ATOM  12919  CA  SER     2      71.660  24.824  39.146  1.00 33.25           C  
ATOM  12920  C   SER     2      72.590  24.410  40.267  1.00 32.21           C  
ATOM  12921  O   SER     2      73.492  25.167  40.644  1.00 30.89           O  
ATOM  12922  CB  SER     2      70.389  25.426  39.738  1.00 32.90           C  
ATOM  12923  OG  SER     2      69.633  26.060  38.749  1.00 33.07           O  
ATOM  12924  N   ASP     3      72.374  23.203  40.811  1.00 30.62           N  
ATOM  12925  CA  ASP     3      73.242  22.687  41.862  1.00 30.33           C  
ATOM  12926  C   ASP     3      74.682  22.556  41.347  1.00 28.94           C  
ATOM  12927  O   ASP     3      75.638  22.825  42.091  1.00 29.92           O  
ATOM  12928  CB  ASP     3      72.774  21.291  42.370  1.00 30.67           C  
ATOM  12929  CG  ASP     3      71.492  21.328  43.198  1.00 32.38           C  
ATOM  12930  OD1 ASP     3      71.019  22.402  43.615  1.00 35.40           O  
ATOM  12931  OD2 ASP     3      70.942  20.230  43.448  1.00 35.26           O  
ATOM  12932  N   VAL     4      74.823  22.096  40.101  1.00 27.71           N  
ATOM  12933  CA  VAL     4      76.127  21.864  39.482  1.00 27.34           C  
ATOM  12934  C   VAL     4      76.846  23.203  39.304  1.00 26.70           C  
ATOM  12935  O   VAL     4      78.035  23.311  39.582  1.00 25.89           O  
ATOM  12936  CB  VAL     4      75.994  21.175  38.115  1.00 27.32           C  
ATOM  12937  CG1 VAL     4      77.261  21.282  37.304  1.00 28.31           C  
ATOM  12938  CG2 VAL     4      75.606  19.678  38.300  1.00 27.74           C  
ATOM  12939  N   ILE     5      76.114  24.200  38.836  1.00 26.35           N  
ATOM  12940  CA  ILE     5      76.694  25.575  38.675  1.00 26.66           C  
ATOM  12941  C   ILE     5      77.167  26.134  40.031  1.00 26.86           C  
ATOM  12942  O   ILE     5      78.302  26.546  40.179  1.00 27.38           O  
ATOM  12943  CB  ILE     5      75.680  26.562  37.999  1.00 26.48           C  
ATOM  12944  CG1 ILE     5      75.346  26.128  36.566  1.00 24.54           C  
ATOM  12945  CG2 ILE     5      76.257  28.001  37.934  1.00 26.07           C  
ATOM  12946  CD1 ILE     5      74.048  26.748  35.988  1.00 26.63           C  
ATOM  12947  N   GLU     6      76.308  26.117  41.034  1.00 27.87           N  
ATOM  12948  CA  GLU     6      76.688  26.606  42.353  1.00 28.66           C  
ATOM  12949  C   GLU     6      77.785  25.768  43.000  1.00 28.15           C  
ATOM  12950  O   GLU     6      78.644  26.303  43.709  1.00 27.19           O  
ATOM  12951  CB  GLU     6      75.481  26.702  43.272  1.00 29.19           C  
ATOM  12952  CG  GLU     6      74.484  27.740  42.832  1.00 31.30           C  
ATOM  12953  CD  GLU     6      73.485  28.113  43.911  1.00 31.61           C  
ATOM  12954  OE1 GLU     6      73.885  28.327  45.083  1.00 38.52           O  
ATOM  12955  OE2 GLU     6      72.296  28.217  43.572  1.00 35.07           O  
ATOM  12956  N   GLY     7      77.769  24.454  42.764  1.00 27.55           N  
ATOM  12957  CA  GLY     7      78.825  23.599  43.252  1.00 27.47           C  
ATOM  12958  C   GLY     7      80.172  23.924  42.647  1.00 27.46           C  
ATOM  12959  O   GLY     7      81.190  23.916  43.348  1.00 28.04           O  
ATOM  12960  N   ARG     8      80.193  24.198  41.351  1.00 27.39           N  
ATOM  12961  CA  ARG     8      81.428  24.591  40.683  1.00 28.18           C  
ATOM  12962  C   ARG     8      81.977  25.901  41.263  1.00 27.87           C  
ATOM  12963  O   ARG     8      83.187  26.055  41.439  1.00 28.10           O  
ATOM  12964  CB  ARG     8      81.219  24.776  39.185  1.00 27.91           C  
ATOM  12965  CG  ARG     8      81.010  23.509  38.405  1.00 28.72           C  
ATOM  12966  CD  ARG     8      80.440  23.881  37.071  1.00 31.46           C  
ATOM  12967  NE  ARG     8      80.192  22.738  36.217  1.00 33.09           N  
ATOM  12968  CZ  ARG     8      79.413  22.752  35.140  1.00 35.77           C  
ATOM  12969  NH1 ARG     8      78.767  23.854  34.762  1.00 36.28           N  
ATOM  12970  NH2 ARG     8      79.267  21.629  34.439  1.00 38.50           N  
ATOM  12971  N   LEU     9      81.077  26.830  41.554  1.00 28.09           N  
ATOM  12972  CA  LEU     9      81.479  28.113  42.139  1.00 28.34           C  
ATOM  12973  C   LEU     9      82.103  27.873  43.539  1.00 28.63           C  
ATOM  12974  O   LEU     9      83.145  28.457  43.874  1.00 27.85           O  
ATOM  12975  CB  LEU     9      80.271  29.044  42.209  1.00 28.43           C  
ATOM  12976  CG  LEU     9      80.543  30.479  42.669  1.00 28.95           C  
ATOM  12977  CD1 LEU     9      81.644  31.110  41.771  1.00 29.20           C  
ATOM  12978  CD2 LEU     9      79.251  31.302  42.651  1.00 29.10           C  
ATOM  12979  N   LYS    10      81.487  26.998  44.343  1.00 28.27           N  
ATOM  12980  CA  LYS    10      82.090  26.586  45.618  1.00 29.09           C  
ATOM  12981  C   LYS    10      83.477  25.946  45.467  1.00 29.33           C  
ATOM  12982  O   LYS    10      84.380  26.178  46.296  1.00 30.06           O  
ATOM  12983  CB  LYS    10      81.155  25.648  46.379  1.00 29.06           C  
ATOM  12984  CG  LYS    10      79.869  26.277  46.842  1.00 29.74           C  
ATOM  12985  CD  LYS    10      79.055  25.300  47.652  1.00 30.41           C  
ATOM  12986  CE  LYS    10      77.739  25.887  48.034  1.00 30.84           C  
ATOM  12987  NZ  LYS    10      76.878  24.856  48.677  1.00 32.89           N  
ATOM  12988  N   GLU    11      83.673  25.166  44.413  1.00 29.53           N  
ATOM  12989  CA  GLU    11      84.977  24.594  44.114  1.00 30.47           C  
ATOM  12990  C   GLU    11      86.011  25.667  43.795  1.00 30.79           C  
ATOM  12991  O   GLU    11      87.190  25.452  44.020  1.00 32.10           O  
ATOM  12992  CB  GLU    11      84.889  23.624  42.946  1.00 30.41           C  
ATOM  12993  CG  GLU    11      84.195  22.304  43.287  1.00 31.53           C  
ATOM  12994  CD  GLU    11      83.980  21.440  42.072  1.00 33.05           C  
ATOM  12995  OE1 GLU    11      83.483  21.935  41.044  1.00 37.69           O  
ATOM  12996  OE2 GLU    11      84.275  20.239  42.144  1.00 40.32           O  
ATOM  12997  N   LEU    12      85.573  26.810  43.266  1.00 30.96           N  
ATOM  12998  CA  LEU    12      86.458  27.982  43.080  1.00 30.36           C  
ATOM  12999  C   LEU    12      86.672  28.813  44.349  1.00 30.69           C  
ATOM  13000  O   LEU    12      87.510  29.730  44.358  1.00 31.30           O  
ATOM  13001  CB  LEU    12      85.912  28.883  41.982  1.00 29.65           C  
ATOM  13002  CG  LEU    12      85.889  28.253  40.603  1.00 29.14           C  
ATOM  13003  CD1 LEU    12      85.193  29.190  39.650  1.00 28.44           C  
ATOM  13004  CD2 LEU    12      87.318  27.916  40.123  1.00 30.62           C  
ATOM  13005  N   GLY    13      85.906  28.530  45.398  1.00 30.88           N  
ATOM  13006  CA  GLY    13      86.097  29.154  46.694  1.00 30.87           C  
ATOM  13007  C   GLY    13      85.047  30.177  47.062  1.00 30.89           C  
ATOM  13008  O   GLY    13      85.157  30.816  48.099  1.00 31.94           O  
ATOM  13009  N   PHE    14      84.004  30.303  46.254  1.00 30.40           N  
ATOM  13010  CA  PHE    14      82.959  31.278  46.509  1.00 30.42           C  
ATOM  13011  C   PHE    14      81.595  30.647  46.801  1.00 31.05           C  
ATOM  13012  O   PHE    14      81.170  29.691  46.147  1.00 30.75           O  
ATOM  13013  CB  PHE    14      82.829  32.227  45.312  1.00 29.97           C  
ATOM  13014  CG  PHE    14      84.106  32.886  44.930  1.00 28.80           C  
ATOM  13015  CD1 PHE    14      84.494  34.057  45.537  1.00 29.32           C  
ATOM  13016  CD2 PHE    14      84.924  32.336  43.954  1.00 28.91           C  
ATOM  13017  CE1 PHE    14      85.688  34.670  45.177  1.00 27.83           C  
ATOM  13018  CE2 PHE    14      86.114  32.938  43.594  1.00 28.84           C  
ATOM  13019  CZ  PHE    14      86.494  34.108  44.214  1.00 28.76           C  
ATOM  13020  N   THR    15      80.906  31.228  47.769  1.00 31.89           N  
ATOM  13021  CA  THR    15      79.480  31.011  47.934  1.00 33.07           C  
ATOM  13022  C   THR    15      78.738  32.270  47.471  1.00 33.07           C  
ATOM  13023  O   THR    15      79.306  33.390  47.471  1.00 32.98           O  
ATOM  13024  CB  THR    15      79.142  30.676  49.406  1.00 33.77           C  
ATOM  13025  OG1 THR    15      79.407  31.816  50.239  1.00 37.27           O  
ATOM  13026  CG2 THR    15      79.988  29.500  49.902  1.00 32.51           C  
ATOM  13027  N   LEU    16      77.488  32.100  47.043  1.00 32.88           N  
ATOM  13028  CA  LEU    16      76.696  33.230  46.573  1.00 32.59           C  
ATOM  13029  C   LEU    16      76.163  34.007  47.767  1.00 33.08           C  
ATOM  13030  O   LEU    16      75.580  33.413  48.678  1.00 32.54           O  
ATOM  13031  CB  LEU    16      75.513  32.781  45.706  1.00 32.47           C  
ATOM  13032  CG  LEU    16      75.834  32.190  44.332  1.00 31.50           C  
ATOM  13033  CD1 LEU    16      74.534  31.595  43.670  1.00 29.77           C  
ATOM  13034  CD2 LEU    16      76.521  33.215  43.434  1.00 28.44           C  
ATOM  13035  N   PRO    17      76.338  35.334  47.771  1.00 33.26           N  
ATOM  13036  CA  PRO    17      75.694  36.103  48.823  1.00 33.95           C  
ATOM  13037  C   PRO    17      74.202  36.176  48.577  1.00 35.74           C  
ATOM  13038  O   PRO    17      73.743  35.890  47.461  1.00 35.40           O  
ATOM  13039  CB  PRO    17      76.304  37.492  48.650  1.00 33.84           C  
ATOM  13040  CG  PRO    17      76.630  37.570  47.219  1.00 33.42           C  
ATOM  13041  CD  PRO    17      77.081  36.198  46.835  1.00 32.52           C  
ATOM  13042  N   VAL    18      73.449  36.584  49.596  1.00 37.90           N  
ATOM  13043  CA  VAL    18      72.045  36.963  49.389  1.00 39.41           C  
ATOM  13044  C   VAL    18      71.995  38.269  48.568  1.00 40.41           C  
ATOM  13045  O   VAL    18      71.230  38.389  47.586  1.00 42.23           O  
ATOM  13046  CB  VAL    18      71.308  37.200  50.710  1.00 39.67           C  
ATOM  13047  CG1 VAL    18      71.505  36.006  51.656  1.00 40.20           C  
ATOM  13048  CG2 VAL    18      71.762  38.513  51.345  1.00 39.98           C  
ATOM  13049  N   ALA    23      66.158  48.786  48.809  1.00 42.30           N  
ATOM  13050  CA  ALA    23      64.939  49.472  48.343  1.00 41.72           C  
ATOM  13051  C   ALA    23      65.286  50.838  47.711  1.00 41.82           C  
ATOM  13052  O   ALA    23      65.606  51.804  48.439  1.00 42.33           O  
ATOM  13053  CB  ALA    23      63.942  49.647  49.513  1.00 42.49           C  
ATOM  13054  N   ALA    24      65.243  50.926  46.370  1.00 40.52           N  
ATOM  13055  CA  ALA    24      65.678  52.154  45.678  1.00 38.94           C  
ATOM  13056  C   ALA    24      64.979  52.405  44.337  1.00 37.86           C  
ATOM  13057  O   ALA    24      64.258  51.549  43.818  1.00 37.65           O  
ATOM  13058  CB  ALA    24      67.220  52.130  45.485  1.00 39.16           C  
ATOM  13059  N   ASN    25      65.207  53.597  43.784  1.00 35.84           N  
ATOM  13060  CA  ASN    25      64.676  53.977  42.458  1.00 34.71           C  
ATOM  13061  C   ASN    25      65.420  53.350  41.277  1.00 32.01           C  
ATOM  13062  O   ASN    25      64.955  53.404  40.128  1.00 30.65           O  
ATOM  13063  CB  ASN    25      64.628  55.506  42.327  1.00 34.31           C  
ATOM  13064  CG  ASN    25      63.556  56.116  43.221  1.00 34.82           C  
ATOM  13065  OD1 ASN    25      63.757  57.167  43.838  1.00 36.03           O  
ATOM  13066  ND2 ASN    25      62.419  55.419  43.327  1.00 31.59           N  
ATOM  13067  N   TYR    26      66.570  52.763  41.572  1.00 30.18           N  
ATOM  13068  CA  TYR    26      67.208  51.824  40.653  1.00 28.61           C  
ATOM  13069  C   TYR    26      67.192  50.433  41.287  1.00 26.27           C  
ATOM  13070  O   TYR    26      67.222  50.261  42.514  1.00 25.81           O  
ATOM  13071  CB  TYR    26      68.625  52.246  40.221  1.00 28.83           C  
ATOM  13072  CG  TYR    26      69.621  52.398  41.339  1.00 30.60           C  
ATOM  13073  CD1 TYR    26      70.670  51.493  41.495  1.00 30.95           C  
ATOM  13074  CD2 TYR    26      69.522  53.456  42.230  1.00 30.60           C  
ATOM  13075  CE1 TYR    26      71.582  51.635  42.510  1.00 30.87           C  
ATOM  13076  CE2 TYR    26      70.411  53.597  43.267  1.00 32.36           C  
ATOM  13077  CZ  TYR    26      71.447  52.689  43.404  1.00 32.75           C  
ATOM  13078  OH  TYR    26      72.352  52.852  44.448  1.00 34.31           O  
ATOM  13079  N   VAL    27      67.135  49.446  40.418  1.00 24.17           N  
ATOM  13080  CA  VAL    27      67.030  48.071  40.817  1.00 22.92           C  
ATOM  13081  C   VAL    27      68.271  47.271  40.393  1.00 22.47           C  
ATOM  13082  O   VAL    27      68.985  47.662  39.463  1.00 20.80           O  
ATOM  13083  CB  VAL    27      65.757  47.458  40.209  1.00 22.53           C  
ATOM  13084  CG1 VAL    27      64.536  48.064  40.881  1.00 24.05           C  
ATOM  13085  CG2 VAL    27      65.709  47.685  38.675  1.00 20.19           C  
ATOM  13086  N   PRO    28      68.514  46.135  41.065  1.00 22.19           N  
ATOM  13087  CA  PRO    28      69.643  45.282  40.693  1.00 22.05           C  
ATOM  13088  C   PRO    28      69.576  44.646  39.313  1.00 21.32           C  
ATOM  13089  O   PRO    28      70.620  44.298  38.758  1.00 19.41           O  
ATOM  13090  CB  PRO    28      69.645  44.208  41.765  1.00 23.32           C  
ATOM  13091  CG  PRO    28      68.744  44.705  42.839  1.00 24.78           C  
ATOM  13092  CD  PRO    28      67.767  45.580  42.209  1.00 22.87           C  
ATOM  13093  N   PHE    29      68.366  44.511  38.760  1.00 20.74           N  
ATOM  13094  CA  PHE    29      68.186  43.931  37.454  1.00 21.35           C  
ATOM  13095  C   PHE    29      66.815  44.278  36.885  1.00 20.78           C  
ATOM  13096  O   PHE    29      65.876  44.597  37.615  1.00 20.82           O  
ATOM  13097  CB  PHE    29      68.410  42.392  37.475  1.00 21.85           C  
ATOM  13098  CG  PHE    29      67.437  41.650  38.360  1.00 22.44           C  
ATOM  13099  CD1 PHE    29      66.175  41.334  37.907  1.00 24.23           C  
ATOM  13100  CD2 PHE    29      67.776  41.337  39.664  1.00 24.23           C  
ATOM  13101  CE1 PHE    29      65.265  40.664  38.746  1.00 23.72           C  
ATOM  13102  CE2 PHE    29      66.883  40.698  40.489  1.00 26.07           C  
ATOM  13103  CZ  PHE    29      65.623  40.381  40.031  1.00 24.55           C  
ATOM  13104  N   THR    30      66.753  44.281  35.568  1.00 21.11           N  
ATOM  13105  CA  THR    30      65.491  44.370  34.819  1.00 22.00           C  
ATOM  13106  C   THR    30      65.480  43.293  33.752  1.00 22.35           C  
ATOM  13107  O   THR    30      66.525  42.798  33.356  1.00 21.01           O  
ATOM  13108  CB  THR    30      65.298  45.735  34.132  1.00 22.63           C  
ATOM  13109  OG1 THR    30      66.405  46.020  33.266  1.00 22.53           O  
ATOM  13110  CG2 THR    30      65.139  46.846  35.164  1.00 21.28           C  
ATOM  13111  N   ILE    31      64.276  42.943  33.280  1.00 23.19           N  
ATOM  13112  CA  ILE    31      64.104  41.993  32.189  1.00 23.67           C  
ATOM  13113  C   ILE    31      63.288  42.634  31.087  1.00 23.56           C  
ATOM  13114  O   ILE    31      62.269  43.294  31.331  1.00 24.21           O  
ATOM  13115  CB  ILE    31      63.424  40.684  32.664  1.00 23.86           C  
ATOM  13116  CG1 ILE    31      64.303  39.977  33.687  1.00 23.74           C  
ATOM  13117  CG2 ILE    31      63.169  39.723  31.486  1.00 24.39           C  
ATOM  13118  CD1 ILE    31      63.577  38.878  34.465  1.00 25.28           C  
ATOM  13119  N   SER    32      63.757  42.461  29.874  1.00 24.00           N  
ATOM  13120  CA  SER    32      63.011  42.846  28.692  1.00 25.73           C  
ATOM  13121  C   SER    32      63.058  41.677  27.730  1.00 25.64           C  
ATOM  13122  O   SER    32      64.122  41.331  27.246  1.00 25.50           O  
ATOM  13123  CB  SER    32      63.598  44.073  28.021  1.00 25.81           C  
ATOM  13124  OG  SER    32      62.809  44.432  26.913  1.00 27.19           O  
ATOM  13125  N   GLY    33      61.903  41.083  27.430  1.00 26.33           N  
ATOM  13126  CA  GLY    33      61.899  39.878  26.629  1.00 26.22           C  
ATOM  13127  C   GLY    33      62.655  38.771  27.314  1.00 25.36           C  
ATOM  13128  O   GLY    33      62.370  38.424  28.457  1.00 26.34           O  
ATOM  13129  N   ASN    34      63.633  38.209  26.622  1.00 24.98           N  
ATOM  13130  CA  ASN    34      64.458  37.178  27.241  1.00 25.51           C  
ATOM  13131  C   ASN    34      65.858  37.705  27.552  1.00 24.78           C  
ATOM  13132  O   ASN    34      66.804  36.930  27.584  1.00 24.18           O  
ATOM  13133  CB  ASN    34      64.528  35.934  26.371  1.00 27.08           C  
ATOM  13134  CG  ASN    34      65.282  36.158  25.091  1.00 30.55           C  
ATOM  13135  OD1 ASN    34      65.607  37.305  24.738  1.00 35.31           O  
ATOM  13136  ND2 ASN    34      65.586  35.057  24.371  1.00 35.76           N  
ATOM  13137  N   LEU    35      65.983  39.022  27.699  1.00 24.55           N  
ATOM  13138  CA  LEU    35      67.277  39.637  28.078  1.00 24.12           C  
ATOM  13139  C   LEU    35      67.189  40.157  29.496  1.00 23.03           C  
ATOM  13140  O   LEU    35      66.268  40.868  29.847  1.00 23.05           O  
ATOM  13141  CB  LEU    35      67.702  40.736  27.096  1.00 24.76           C  
ATOM  13142  CG  LEU    35      68.282  40.199  25.764  1.00 26.16           C  
ATOM  13143  CD1 LEU    35      68.633  41.334  24.793  1.00 28.97           C  
ATOM  13144  CD2 LEU    35      69.489  39.249  25.947  1.00 28.49           C  
ATOM  13145  N   LEU    36      68.148  39.763  30.315  1.00 21.64           N  
ATOM  13146  CA  LEU    36      68.250  40.214  31.693  1.00 20.97           C  
ATOM  13147  C   LEU    36      69.421  41.199  31.776  1.00 20.61           C  
ATOM  13148  O   LEU    36      70.562  40.854  31.376  1.00 21.20           O  
ATOM  13149  CB  LEU    36      68.532  39.046  32.613  1.00 21.41           C  
ATOM  13150  CG  LEU    36      68.789  39.264  34.102  1.00 21.35           C  
ATOM  13151  CD1 LEU    36      67.603  39.957  34.807  1.00 23.14           C  
ATOM  13152  CD2 LEU    36      69.179  37.943  34.804  1.00 22.93           C  
ATOM  13153  N   TYR    37      69.112  42.393  32.255  1.00 19.52           N  
ATOM  13154  CA  TYR    37      70.093  43.483  32.452  1.00 19.94           C  
ATOM  13155  C   TYR    37      70.430  43.581  33.906  1.00 19.30           C  
ATOM  13156  O   TYR    37      69.576  43.954  34.684  1.00 18.49           O  
ATOM  13157  CB  TYR    37      69.527  44.816  32.021  1.00 21.62           C  
ATOM  13158  CG  TYR    37      69.633  45.044  30.561  1.00 24.97           C  
ATOM  13159  CD1 TYR    37      70.608  45.901  30.041  1.00 26.99           C  
ATOM  13160  CD2 TYR    37      68.798  44.384  29.690  1.00 26.43           C  
ATOM  13161  CE1 TYR    37      70.711  46.099  28.690  1.00 28.18           C  
ATOM  13162  CE2 TYR    37      68.902  44.583  28.309  1.00 27.61           C  
ATOM  13163  CZ  TYR    37      69.839  45.424  27.829  1.00 26.70           C  
ATOM  13164  OH  TYR    37      69.928  45.651  26.474  1.00 28.34           O  
ATOM  13165  N   VAL    38      71.680  43.277  34.255  1.00 18.12           N  
ATOM  13166  CA  VAL    38      72.116  43.284  35.635  1.00 17.38           C  
ATOM  13167  C   VAL    38      72.897  44.591  35.852  1.00 17.03           C  
ATOM  13168  O   VAL    38      73.783  44.948  35.040  1.00 16.35           O  
ATOM  13169  CB  VAL    38      72.994  42.065  35.962  1.00 17.22           C  
ATOM  13170  CG1 VAL    38      73.488  42.113  37.378  1.00 16.68           C  
ATOM  13171  CG2 VAL    38      72.228  40.778  35.704  1.00 19.02           C  
ATOM  13172  N   SER    39      72.542  45.277  36.935  1.00 16.21           N  
ATOM  13173  CA  SER    39      73.190  46.537  37.340  1.00 16.77           C  
ATOM  13174  C   SER    39      74.675  46.307  37.694  1.00 16.42           C  
ATOM  13175  O   SER    39      75.066  45.194  38.084  1.00 16.79           O  
ATOM  13176  CB  SER    39      72.491  47.130  38.559  1.00 16.39           C  
ATOM  13177  OG  SER    39      71.232  47.673  38.217  1.00 16.94           O  
ATOM  13178  N   GLY    40      75.498  47.355  37.547  1.00 16.71           N  
ATOM  13179  CA  GLY    40      76.913  47.251  37.877  1.00 16.17           C  
ATOM  13180  C   GLY    40      77.093  46.701  39.267  1.00 16.82           C  
ATOM  13181  O   GLY    40      76.479  47.191  40.216  1.00 16.75           O  
ATOM  13182  N   GLN    41      77.848  45.617  39.375  1.00 16.68           N  
ATOM  13183  CA  GLN    41      78.114  44.996  40.668  1.00 17.30           C  
ATOM  13184  C   GLN    41      79.538  45.360  41.116  1.00 16.88           C  
ATOM  13185  O   GLN    41      80.451  45.399  40.295  1.00 17.16           O  
ATOM  13186  CB  GLN    41      77.943  43.460  40.588  1.00 17.03           C  
ATOM  13187  CG  GLN    41      76.522  42.993  40.194  1.00 18.15           C  
ATOM  13188  CD  GLN    41      75.491  43.430  41.175  1.00 18.41           C  
ATOM  13189  OE1 GLN    41      75.559  43.081  42.360  1.00 18.42           O  
ATOM  13190  NE2 GLN    41      74.513  44.191  40.705  1.00 18.08           N  
ATOM  13191  N   LEU    42      79.675  45.523  42.425  1.00 18.51           N  
ATOM  13192  CA  LEU    42      80.922  45.823  43.142  1.00 19.27           C  
ATOM  13193  C   LEU    42      81.505  44.544  43.800  1.00 20.59           C  
ATOM  13194  O   LEU    42      80.809  43.508  43.933  1.00 20.90           O  
ATOM  13195  CB  LEU    42      80.648  46.893  44.195  1.00 19.83           C  
ATOM  13196  CG  LEU    42      80.007  48.193  43.701  1.00 20.09           C  
ATOM  13197  CD1 LEU    42      79.893  49.256  44.830  1.00 24.19           C  
ATOM  13198  CD2 LEU    42      80.773  48.751  42.474  1.00 20.92           C  
ATOM  13199  N   PRO    43      82.784  44.590  44.204  1.00 20.99           N  
ATOM  13200  CA  PRO    43      83.390  43.388  44.739  1.00 22.23           C  
ATOM  13201  C   PRO    43      82.987  43.165  46.205  1.00 23.30           C  
ATOM  13202  O   PRO    43      83.833  43.267  47.123  1.00 23.87           O  
ATOM  13203  CB  PRO    43      84.886  43.654  44.574  1.00 22.24           C  
ATOM  13204  CG  PRO    43      85.021  45.107  44.597  1.00 22.74           C  
ATOM  13205  CD  PRO    43      83.747  45.711  44.125  1.00 20.90           C  
ATOM  13206  N   MET    44      81.695  42.863  46.396  1.00 24.94           N  
ATOM  13207  CA  MET    44      81.111  42.668  47.725  1.00 26.76           C  
ATOM  13208  C   MET    44      81.416  41.303  48.250  1.00 27.78           C  
ATOM  13209  O   MET    44      81.216  40.309  47.554  1.00 26.94           O  
ATOM  13210  CB  MET    44      79.606  42.768  47.701  1.00 28.72           C  
ATOM  13211  CG  MET    44      79.087  44.003  47.142  1.00 34.04           C  
ATOM  13212  SD  MET    44      79.675  45.517  48.177  1.00 52.29          SE  
ATOM  13213  CE  MET    44      78.069  46.599  47.655  1.00 42.80           C  
ATOM  13214  N   GLU    45      81.866  41.277  49.503  1.00 28.96           N  
ATOM  13215  CA  GLU    45      82.155  40.050  50.199  1.00 30.57           C  
ATOM  13216  C   GLU    45      81.806  40.268  51.663  1.00 30.94           C  
ATOM  13217  O   GLU    45      82.239  41.230  52.276  1.00 29.35           O  
ATOM  13218  CB  GLU    45      83.615  39.704  50.030  1.00 31.01           C  
ATOM  13219  CG  GLU    45      83.899  38.254  50.285  1.00 32.83           C  
ATOM  13220  CD  GLU    45      85.369  37.906  50.169  1.00 34.03           C  
ATOM  13221  OE1 GLU    45      86.236  38.800  50.290  1.00 40.50           O  
ATOM  13222  OE2 GLU    45      85.665  36.719  49.956  1.00 39.11           O  
ATOM  13223  N   SER    46      80.980  39.381  52.208  1.00 32.41           N  
ATOM  13224  CA  SER    46      80.473  39.546  53.558  1.00 33.11           C  
ATOM  13225  C   SER    46      79.902  40.921  53.829  1.00 32.96           C  
ATOM  13226  O   SER    46      80.092  41.474  54.907  1.00 33.73           O  
ATOM  13227  CB  SER    46      81.576  39.245  54.550  1.00 33.85           C  
ATOM  13228  OG  SER    46      82.071  37.929  54.341  1.00 36.10           O  
ATOM  13229  N   GLY    47      79.201  41.482  52.851  1.00 32.72           N  
ATOM  13230  CA  GLY    47      78.556  42.782  53.023  1.00 32.20           C  
ATOM  13231  C   GLY    47      79.457  44.008  52.954  1.00 31.89           C  
ATOM  13232  O   GLY    47      78.988  45.134  53.165  1.00 32.53           O  
ATOM  13233  N   LYS    48      80.735  43.805  52.632  1.00 31.36           N  
ATOM  13234  CA  LYS    48      81.710  44.889  52.589  1.00 31.00           C  
ATOM  13235  C   LYS    48      82.340  44.938  51.204  1.00 29.19           C  
ATOM  13236  O   LYS    48      82.428  43.919  50.525  1.00 27.85           O  
ATOM  13237  CB  LYS    48      82.812  44.643  53.628  1.00 32.10           C  
ATOM  13238  CG  LYS    48      82.320  44.278  55.056  1.00 33.77           C  
ATOM  13239  CD  LYS    48      83.517  44.073  55.997  1.00 34.85           C  
ATOM  13240  CE  LYS    48      83.212  43.172  57.223  1.00 38.54           C  
ATOM  13241  NZ  LYS    48      82.691  41.784  56.927  1.00 41.89           N  
ATOM  13242  N   ILE    49      82.793  46.114  50.786  1.00 27.46           N  
ATOM  13243  CA  ILE    49      83.609  46.197  49.556  1.00 27.51           C  
ATOM  13244  C   ILE    49      84.994  45.615  49.890  1.00 26.44           C  
ATOM  13245  O   ILE    49      85.717  46.162  50.719  1.00 27.76           O  
ATOM  13246  CB  ILE    49      83.727  47.641  48.999  1.00 27.35           C  
ATOM  13247  CG1 ILE    49      82.339  48.250  48.725  1.00 28.61           C  
ATOM  13248  CG2 ILE    49      84.568  47.654  47.687  1.00 25.90           C  
ATOM  13249  CD1 ILE    49      81.640  47.702  47.484  1.00 29.88           C  
ATOM  13250  N   ALA    50      85.329  44.473  49.299  1.00 24.66           N  
ATOM  13251  CA  ALA    50      86.524  43.716  49.675  1.00 23.88           C  
ATOM  13252  C   ALA    50      87.844  44.216  49.077  1.00 22.88           C  
ATOM  13253  O   ALA    50      88.926  43.916  49.616  1.00 23.36           O  
ATOM  13254  CB  ALA    50      86.342  42.241  49.306  1.00 24.42           C  
ATOM  13255  N   VAL    51      87.773  44.926  47.958  1.00 20.81           N  
ATOM  13256  CA  VAL    51      88.968  45.381  47.241  1.00 19.75           C  
ATOM  13257  C   VAL    51      88.716  46.833  46.772  1.00 19.50           C  
ATOM  13258  O   VAL    51      87.820  47.092  45.950  1.00 18.36           O  
ATOM  13259  CB  VAL    51      89.299  44.506  46.034  1.00 19.25           C  
ATOM  13260  CG1 VAL    51      90.619  44.969  45.369  1.00 17.95           C  
ATOM  13261  CG2 VAL    51      89.337  42.997  46.410  1.00 19.82           C  
ATOM  13262  N   THR    52      89.518  47.761  47.290  1.00 18.83           N  
ATOM  13263  CA  THR    52      89.331  49.192  47.048  1.00 18.76           C  
ATOM  13264  C   THR    52      90.623  49.886  46.577  1.00 17.15           C  
ATOM  13265  O   THR    52      91.752  49.426  46.833  1.00 18.57           O  
ATOM  13266  CB  THR    52      88.801  49.933  48.274  1.00 19.87           C  
ATOM  13267  OG1 THR    52      89.751  49.836  49.341  1.00 20.52           O  
ATOM  13268  CG2 THR    52      87.440  49.358  48.732  1.00 20.18           C  
ATOM  13269  N   GLY    53      90.427  50.980  45.853  1.00 16.63           N  
ATOM  13270  CA  GLY    53      91.523  51.794  45.378  1.00 15.81           C  
ATOM  13271  C   GLY    53      91.866  51.490  43.935  1.00 16.34           C  
ATOM  13272  O   GLY    53      91.220  50.657  43.238  1.00 16.41           O  
ATOM  13273  N   LEU    54      92.852  52.232  43.462  1.00 14.89           N  
ATOM  13274  CA  LEU    54      93.241  52.192  42.046  1.00 15.09           C  
ATOM  13275  C   LEU    54      94.198  51.052  41.691  1.00 14.82           C  
ATOM  13276  O   LEU    54      95.217  50.830  42.343  1.00 15.74           O  
ATOM  13277  CB  LEU    54      93.870  53.539  41.641  1.00 14.99           C  
ATOM  13278  CG  LEU    54      93.016  54.794  41.893  1.00 16.43           C  
ATOM  13279  CD1 LEU    54      93.853  56.129  41.629  1.00 14.43           C  
ATOM  13280  CD2 LEU    54      91.711  54.771  41.099  1.00 18.58           C  
ATOM  13281  N   VAL    55      93.881  50.333  40.618  1.00 15.10           N  
ATOM  13282  CA  VAL    55      94.798  49.303  40.117  1.00 15.22           C  
ATOM  13283  C   VAL    55      96.009  50.038  39.509  1.00 15.52           C  
ATOM  13284  O   VAL    55      95.867  51.023  38.743  1.00 15.49           O  
ATOM  13285  CB  VAL    55      94.147  48.295  39.122  1.00 15.34           C  
ATOM  13286  CG1 VAL    55      95.143  47.202  38.776  1.00 16.34           C  
ATOM  13287  CG2 VAL    55      92.798  47.747  39.668  1.00 14.16           C  
ATOM  13288  N   GLY    56      97.188  49.598  39.915  1.00 15.44           N  
ATOM  13289  CA  GLY    56      98.449  50.244  39.536  1.00 16.28           C  
ATOM  13290  C   GLY    56      98.942  51.219  40.587  1.00 16.32           C  
ATOM  13291  O   GLY    56     100.026  51.780  40.450  1.00 16.29           O  
ATOM  13292  N   ARG    57      98.166  51.390  41.665  1.00 16.32           N  
ATOM  13293  CA  ARG    57      98.571  52.249  42.778  1.00 16.70           C  
ATOM  13294  C   ARG    57      98.304  51.594  44.106  1.00 16.10           C  
ATOM  13295  O   ARG    57      99.218  51.357  44.886  1.00 17.03           O  
ATOM  13296  CB  ARG    57      97.873  53.603  42.715  1.00 15.72           C  
ATOM  13297  CG  ARG    57      98.244  54.497  43.885  1.00 16.84           C  
ATOM  13298  CD  ARG    57      97.659  55.894  43.877  1.00 15.89           C  
ATOM  13299  NE  ARG    57      98.101  56.563  45.097  1.00 15.63           N  
ATOM  13300  CZ  ARG    57      99.287  57.153  45.256  1.00 16.91           C  
ATOM  13301  NH1 ARG    57     100.160  57.249  44.259  1.00 13.83           N  
ATOM  13302  NH2 ARG    57      99.613  57.651  46.435  1.00 15.00           N  
ATOM  13303  N   ASP    58      97.051  51.278  44.341  1.00 16.23           N  
ATOM  13304  CA  ASP    58      96.620  50.693  45.608  1.00 16.54           C  
ATOM  13305  C   ASP    58      96.524  49.169  45.557  1.00 16.62           C  
ATOM  13306  O   ASP    58      96.664  48.506  46.600  1.00 16.58           O  
ATOM  13307  CB  ASP    58      95.275  51.259  45.998  1.00 16.42           C  
ATOM  13308  CG  ASP    58      95.312  52.769  46.142  1.00 17.20           C  
ATOM  13309  OD1 ASP    58      96.112  53.243  46.982  1.00 19.65           O  
ATOM  13310  OD2 ASP    58      94.531  53.456  45.451  1.00 18.16           O  
ATOM  13311  N   VAL    59      96.242  48.632  44.377  1.00 16.45           N  
ATOM  13312  CA  VAL    59      96.058  47.197  44.212  1.00 17.77           C  
ATOM  13313  C   VAL    59      96.785  46.737  42.956  1.00 17.83           C  
ATOM  13314  O   VAL    59      96.926  47.493  41.987  1.00 17.33           O  
ATOM  13315  CB  VAL    59      94.554  46.767  44.189  1.00 18.87           C  
ATOM  13316  CG1 VAL    59      93.778  47.334  45.449  1.00 21.82           C  
ATOM  13317  CG2 VAL    59      93.896  47.197  42.965  1.00 21.44           C  
ATOM  13318  N   ASP    60      97.285  45.515  43.025  1.00 18.74           N  
ATOM  13319  CA  ASP    60      97.964  44.879  41.909  1.00 19.34           C  
ATOM  13320  C   ASP    60      96.992  44.080  41.043  1.00 19.48           C  
ATOM  13321  O   ASP    60      95.805  44.037  41.332  1.00 19.40           O  
ATOM  13322  CB  ASP    60      99.147  44.040  42.405  1.00 20.89           C  
ATOM  13323  CG  ASP    60      98.757  42.848  43.254  1.00 21.21           C  
ATOM  13324  OD1 ASP    60      97.589  42.484  43.394  1.00 22.81           O  
ATOM  13325  OD2 ASP    60      99.713  42.231  43.792  1.00 30.25           O  
ATOM  13326  N   VAL    61      97.486  43.487  39.967  1.00 18.59           N  
ATOM  13327  CA  VAL    61      96.614  42.760  39.045  1.00 19.30           C  
ATOM  13328  C   VAL    61      95.938  41.568  39.757  1.00 18.76           C  
ATOM  13329  O   VAL    61      94.732  41.355  39.623  1.00 19.22           O  
ATOM  13330  CB  VAL    61      97.352  42.330  37.761  1.00 19.44           C  
ATOM  13331  CG1 VAL    61      96.504  41.337  36.953  1.00 20.46           C  
ATOM  13332  CG2 VAL    61      97.699  43.573  36.911  1.00 19.62           C  
ATOM  13333  N   ALA    62      96.695  40.801  40.523  1.00 18.89           N  
ATOM  13334  CA  ALA    62      96.120  39.649  41.215  1.00 19.10           C  
ATOM  13335  C   ALA    62      94.973  40.048  42.139  1.00 19.10           C  
ATOM  13336  O   ALA    62      93.905  39.417  42.132  1.00 18.61           O  
ATOM  13337  CB  ALA    62      97.209  38.899  42.012  1.00 19.82           C  
ATOM  13338  N   SER    63      95.178  41.088  42.960  1.00 18.52           N  
ATOM  13339  CA  SER    63      94.126  41.541  43.854  1.00 19.00           C  
ATOM  13340  C   SER    63      92.917  42.037  43.057  1.00 18.56           C  
ATOM  13341  O   SER    63      91.790  41.803  43.432  1.00 18.58           O  
ATOM  13342  CB  SER    63      94.622  42.645  44.745  1.00 19.24           C  
ATOM  13343  OG  SER    63      95.617  42.148  45.586  1.00 20.64           O  
ATOM  13344  N   ALA    64      93.164  42.778  41.983  1.00 18.32           N  
ATOM  13345  CA  ALA    64      92.088  43.282  41.124  1.00 18.22           C  
ATOM  13346  C   ALA    64      91.295  42.123  40.447  1.00 17.22           C  
ATOM  13347  O   ALA    64      90.093  42.203  40.247  1.00 15.74           O  
ATOM  13348  CB  ALA    64      92.667  44.231  40.071  1.00 18.00           C  
ATOM  13349  N   GLN    65      92.005  41.065  40.095  1.00 18.13           N  
ATOM  13350  CA  GLN    65      91.374  39.867  39.554  1.00 19.19           C  
ATOM  13351  C   GLN    65      90.392  39.274  40.566  1.00 19.55           C  
ATOM  13352  O   GLN    65      89.268  38.896  40.194  1.00 19.43           O  
ATOM  13353  CB  GLN    65      92.424  38.845  39.097  1.00 18.99           C  
ATOM  13354  CG  GLN    65      93.078  39.208  37.762  1.00 19.83           C  
ATOM  13355  CD  GLN    65      94.275  38.344  37.421  1.00 19.98           C  
ATOM  13356  OE1 GLN    65      94.942  37.792  38.312  1.00 23.49           O  
ATOM  13357  NE2 GLN    65      94.541  38.184  36.114  1.00 20.84           N  
ATOM  13358  N   ARG    66      90.789  39.194  41.835  1.00 20.27           N  
ATOM  13359  CA  ARG    66      89.877  38.774  42.884  1.00 19.80           C  
ATOM  13360  C   ARG    66      88.688  39.723  43.034  1.00 19.12           C  
ATOM  13361  O   ARG    66      87.559  39.289  43.213  1.00 18.72           O  
ATOM  13362  CB  ARG    66      90.597  38.676  44.215  1.00 21.46           C  
ATOM  13363  CG  ARG    66      89.674  38.205  45.361  1.00 25.65           C  
ATOM  13364  CD  ARG    66      89.298  36.727  45.200  1.00 36.25           C  
ATOM  13365  NE  ARG    66      90.392  35.890  45.691  1.00 41.73           N  
ATOM  13366  CZ  ARG    66      90.704  34.644  45.300  1.00 44.24           C  
ATOM  13367  NH1 ARG    66      90.018  33.988  44.357  1.00 45.76           N  
ATOM  13368  NH2 ARG    66      91.746  34.039  45.876  1.00 45.36           N  
ATOM  13369  N   ALA    67      88.915  41.023  42.911  1.00 18.19           N  
ATOM  13370  CA  ALA    67      87.776  41.975  42.854  1.00 17.76           C  
ATOM  13371  C   ALA    67      86.826  41.622  41.708  1.00 17.38           C  
ATOM  13372  O   ALA    67      85.599  41.617  41.892  1.00 17.68           O  
ATOM  13373  CB  ALA    67      88.270  43.434  42.700  1.00 18.27           C  
ATOM  13374  N   ALA    68      87.399  41.298  40.541  1.00 16.79           N  
ATOM  13375  CA  ALA    68      86.601  40.982  39.365  1.00 17.36           C  
ATOM  13376  C   ALA    68      85.816  39.681  39.613  1.00 17.31           C  
ATOM  13377  O   ALA    68      84.630  39.612  39.301  1.00 17.42           O  
ATOM  13378  CB  ALA    68      87.459  40.881  38.124  1.00 16.52           C  
ATOM  13379  N   GLU    69      86.469  38.683  40.196  1.00 17.93           N  
ATOM  13380  CA  GLU    69      85.784  37.441  40.576  1.00 18.71           C  
ATOM  13381  C   GLU    69      84.583  37.751  41.484  1.00 18.93           C  
ATOM  13382  O   GLU    69      83.471  37.242  41.241  1.00 18.31           O  
ATOM  13383  CB  GLU    69      86.757  36.477  41.251  1.00 19.08           C  
ATOM  13384  CG  GLU    69      87.806  35.902  40.322  1.00 21.15           C  
ATOM  13385  CD  GLU    69      88.858  35.066  41.051  1.00 22.14           C  
ATOM  13386  OE1 GLU    69      89.114  35.313  42.248  1.00 26.87           O  
ATOM  13387  OE2 GLU    69      89.424  34.144  40.439  1.00 27.07           O  
ATOM  13388  N   LEU    70      84.785  38.602  42.502  1.00 18.58           N  
ATOM  13389  CA  LEU    70      83.696  38.968  43.407  1.00 18.83           C  
ATOM  13390  C   LEU    70      82.568  39.708  42.680  1.00 19.23           C  
ATOM  13391  O   LEU    70      81.381  39.501  42.991  1.00 19.11           O  
ATOM  13392  CB  LEU    70      84.211  39.780  44.620  1.00 19.41           C  
ATOM  13393  CG  LEU    70      85.076  39.021  45.631  1.00 19.00           C  
ATOM  13394  CD1 LEU    70      85.801  39.978  46.576  1.00 19.47           C  
ATOM  13395  CD2 LEU    70      84.185  37.995  46.377  1.00 21.35           C  
ATOM  13396  N   CYS    71      82.915  40.595  41.740  1.00 18.39           N  
ATOM  13397  CA  CYS    71      81.884  41.296  40.973  1.00 18.21           C  
ATOM  13398  C   CYS    71      81.020  40.255  40.259  1.00 18.12           C  
ATOM  13399  O   CYS    71      79.783  40.380  40.219  1.00 18.48           O  
ATOM  13400  CB  CYS    71      82.523  42.263  39.959  1.00 18.28           C  
ATOM  13401  SG  CYS    71      83.354  43.707  40.748  1.00 17.98           S  
ATOM  13402  N   ALA    72      81.702  39.258  39.697  1.00 18.14           N  
ATOM  13403  CA  ALA    72      81.087  38.152  38.925  1.00 18.89           C  
ATOM  13404  C   ALA    72      80.191  37.309  39.820  1.00 19.05           C  
ATOM  13405  O   ALA    72      79.114  36.921  39.394  1.00 18.95           O  
ATOM  13406  CB  ALA    72      82.163  37.286  38.228  1.00 19.28           C  
ATOM  13407  N   VAL    73      80.632  37.045  41.048  1.00 19.61           N  
ATOM  13408  CA  VAL    73      79.815  36.298  42.031  1.00 20.01           C  
ATOM  13409  C   VAL    73      78.521  37.045  42.369  1.00 20.13           C  
ATOM  13410  O   VAL    73      77.428  36.449  42.460  1.00 20.48           O  
ATOM  13411  CB  VAL    73      80.633  36.004  43.330  1.00 20.82           C  
ATOM  13412  CG1 VAL    73      79.714  35.513  44.502  1.00 21.02           C  
ATOM  13413  CG2 VAL    73      81.772  35.052  43.029  1.00 19.80           C  
ATOM  13414  N   ASN    74      78.651  38.353  42.525  1.00 20.11           N  
ATOM  13415  CA  ASN    74      77.538  39.245  42.782  1.00 19.82           C  
ATOM  13416  C   ASN    74      76.578  39.319  41.600  1.00 19.58           C  
ATOM  13417  O   ASN    74      75.340  39.315  41.782  1.00 19.11           O  
ATOM  13418  CB  ASN    74      78.047  40.618  43.245  1.00 21.09           C  
ATOM  13419  CG  ASN    74      78.475  40.618  44.708  1.00 20.96           C  
ATOM  13420  OD1 ASN    74      79.667  40.497  45.044  1.00 25.84           O  
ATOM  13421  ND2 ASN    74      77.513  40.757  45.583  1.00 21.36           N  
ATOM  13422  N   ILE    75      77.117  39.332  40.385  1.00 19.22           N  
ATOM  13423  CA  ILE    75      76.266  39.262  39.188  1.00 19.73           C  
ATOM  13424  C   ILE    75      75.449  37.952  39.240  1.00 19.91           C  
ATOM  13425  O   ILE    75      74.232  37.959  39.042  1.00 21.28           O  
ATOM  13426  CB  ILE    75      77.082  39.318  37.856  1.00 20.26           C  
ATOM  13427  CG1 ILE    75      77.721  40.707  37.642  1.00 20.27           C  
ATOM  13428  CG2 ILE    75      76.193  38.957  36.665  1.00 18.77           C  
ATOM  13429  CD1 ILE    75      78.803  40.768  36.489  1.00 19.64           C  
ATOM  13430  N   LEU    76      76.126  36.852  39.510  1.00 20.16           N  
ATOM  13431  CA  LEU    76      75.459  35.515  39.533  1.00 20.33           C  
ATOM  13432  C   LEU    76      74.366  35.460  40.615  1.00 20.78           C  
ATOM  13433  O   LEU    76      73.297  34.907  40.379  1.00 21.42           O  
ATOM  13434  CB  LEU    76      76.486  34.394  39.689  1.00 20.53           C  
ATOM  13435  CG  LEU    76      77.372  34.118  38.484  1.00 20.87           C  
ATOM  13436  CD1 LEU    76      78.458  33.098  38.825  1.00 22.97           C  
ATOM  13437  CD2 LEU    76      76.544  33.679  37.260  1.00 23.02           C  
ATOM  13438  N   ALA    77      74.614  36.063  41.784  1.00 21.14           N  
ATOM  13439  CA  ALA    77      73.597  36.165  42.832  1.00 21.04           C  
ATOM  13440  C   ALA    77      72.361  36.891  42.300  1.00 21.95           C  
ATOM  13441  O   ALA    77      71.217  36.466  42.522  1.00 21.90           O  
ATOM  13442  CB  ALA    77      74.162  36.883  44.086  1.00 20.99           C  
ATOM  13443  N   GLN    78      72.587  37.993  41.581  1.00 21.45           N  
ATOM  13444  CA  GLN    78      71.473  38.745  41.023  1.00 22.10           C  
ATOM  13445  C   GLN    78      70.713  37.927  39.965  1.00 21.79           C  
ATOM  13446  O   GLN    78      69.486  37.929  39.936  1.00 22.55           O  
ATOM  13447  CB  GLN    78      71.950  40.077  40.422  1.00 22.09           C  
ATOM  13448  CG  GLN    78      72.508  41.105  41.436  1.00 24.22           C  
ATOM  13449  CD  GLN    78      71.567  41.457  42.585  1.00 27.40           C  
ATOM  13450  OE1 GLN    78      70.352  41.227  42.543  1.00 31.81           O  
ATOM  13451  NE2 GLN    78      72.141  42.054  43.621  1.00 33.24           N  
ATOM  13452  N   VAL    79      71.444  37.235  39.103  1.00 22.19           N  
ATOM  13453  CA  VAL    79      70.817  36.392  38.091  1.00 22.65           C  
ATOM  13454  C   VAL    79      69.980  35.285  38.732  1.00 23.28           C  
ATOM  13455  O   VAL    79      68.872  35.003  38.273  1.00 23.03           O  
ATOM  13456  CB  VAL    79      71.835  35.795  37.119  1.00 23.12           C  
ATOM  13457  CG1 VAL    79      71.136  34.895  36.134  1.00 23.37           C  
ATOM  13458  CG2 VAL    79      72.623  36.932  36.374  1.00 22.03           C  
ATOM  13459  N   LYS    80      70.507  34.673  39.779  1.00 23.69           N  
ATOM  13460  CA  LYS    80      69.799  33.611  40.478  1.00 24.34           C  
ATOM  13461  C   LYS    80      68.501  34.164  41.053  1.00 25.02           C  
ATOM  13462  O   LYS    80      67.442  33.517  40.935  1.00 25.88           O  
ATOM  13463  CB  LYS    80      70.672  33.018  41.576  1.00 24.54           C  
ATOM  13464  CG  LYS    80      69.980  31.893  42.358  1.00 24.65           C  
ATOM  13465  CD  LYS    80      70.809  31.421  43.510  1.00 25.01           C  
ATOM  13466  CE  LYS    80      69.995  30.487  44.426  1.00 26.39           C  
ATOM  13467  NZ  LYS    80      70.884  29.674  45.302  1.00 27.82           N  
ATOM  13468  N   ALA    81      68.564  35.351  41.664  1.00 25.16           N  
ATOM  13469  CA  ALA    81      67.346  36.048  42.148  1.00 25.31           C  
ATOM  13470  C   ALA    81      66.342  36.341  41.017  1.00 25.95           C  
ATOM  13471  O   ALA    81      65.141  36.042  41.158  1.00 25.62           O  
ATOM  13472  CB  ALA    81      67.697  37.329  42.899  1.00 25.25           C  
ATOM  13473  N   ALA    82      66.827  36.906  39.908  1.00 25.86           N  
ATOM  13474  CA  ALA    82      66.008  37.146  38.720  1.00 26.45           C  
ATOM  13475  C   ALA    82      65.358  35.846  38.201  1.00 26.96           C  
ATOM  13476  O   ALA    82      64.253  35.900  37.645  1.00 27.66           O  
ATOM  13477  CB  ALA    82      66.813  37.773  37.611  1.00 25.68           C  
ATOM  13478  N   LEU    83      66.034  34.712  38.370  1.00 27.25           N  
ATOM  13479  CA  LEU    83      65.568  33.458  37.785  1.00 28.53           C  
ATOM  13480  C   LEU    83      64.892  32.546  38.810  1.00 29.77           C  
ATOM  13481  O   LEU    83      64.768  31.322  38.610  1.00 29.23           O  
ATOM  13482  CB  LEU    83      66.721  32.761  37.070  1.00 28.68           C  
ATOM  13483  CG  LEU    83      67.336  33.509  35.875  1.00 27.34           C  
ATOM  13484  CD1 LEU    83      68.442  32.677  35.265  1.00 27.66           C  
ATOM  13485  CD2 LEU    83      66.303  33.910  34.809  1.00 26.22           C  
ATOM  13486  N   ASN    84      64.439  33.159  39.895  1.00 30.56           N  
ATOM  13487  CA  ASN    84      63.729  32.463  40.972  1.00 32.17           C  
ATOM  13488  C   ASN    84      64.473  31.244  41.527  1.00 32.90           C  
ATOM  13489  O   ASN    84      63.869  30.207  41.867  1.00 33.06           O  
ATOM  13490  CB  ASN    84      62.309  32.124  40.501  1.00 32.69           C  
ATOM  13491  CG  ASN    84      61.490  33.372  40.221  1.00 35.55           C  
ATOM  13492  OD1 ASN    84      60.912  33.525  39.134  1.00 41.64           O  
ATOM  13493  ND2 ASN    84      61.455  34.290  41.192  1.00 39.24           N  
ATOM  13494  N   GLY    85      65.789  31.382  41.634  1.00 33.09           N  
ATOM  13495  CA  GLY    85      66.645  30.371  42.227  1.00 33.47           C  
ATOM  13496  C   GLY    85      67.306  29.487  41.196  1.00 34.39           C  
ATOM  13497  O   GLY    85      68.029  28.555  41.537  1.00 35.05           O  
ATOM  13498  N   ASP    86      67.097  29.793  39.927  1.00 35.62           N  
ATOM  13499  CA  ASP    86      67.425  28.850  38.869  1.00 36.87           C  
ATOM  13500  C   ASP    86      68.531  29.305  37.873  1.00 36.44           C  
ATOM  13501  O   ASP    86      68.241  29.668  36.744  1.00 36.29           O  
ATOM  13502  CB  ASP    86      66.107  28.532  38.145  1.00 37.68           C  
ATOM  13503  CG  ASP    86      66.135  27.208  37.412  1.00 40.66           C  
ATOM  13504  OD1 ASP    86      67.157  26.494  37.471  1.00 44.08           O  
ATOM  13505  OD2 ASP    86      65.116  26.881  36.763  1.00 45.09           O  
ATOM  13506  N   LEU    87      69.796  29.225  38.285  1.00 36.56           N  
ATOM  13507  CA  LEU    87      70.940  29.570  37.412  1.00 36.56           C  
ATOM  13508  C   LEU    87      71.040  28.748  36.105  1.00 36.34           C  
ATOM  13509  O   LEU    87      71.796  29.096  35.196  1.00 35.79           O  
ATOM  13510  CB  LEU    87      72.272  29.500  38.182  1.00 36.86           C  
ATOM  13511  CG  LEU    87      72.623  30.693  39.091  1.00 36.88           C  
ATOM  13512  CD1 LEU    87      73.967  30.459  39.777  1.00 36.37           C  
ATOM  13513  CD2 LEU    87      72.640  32.048  38.326  1.00 36.15           C  
ATOM  13514  N   SER    88      70.275  27.665  36.024  1.00 36.37           N  
ATOM  13515  CA  SER    88      70.251  26.801  34.847  1.00 35.94           C  
ATOM  13516  C   SER    88      69.374  27.362  33.727  1.00 35.17           C  
ATOM  13517  O   SER    88      69.432  26.891  32.595  1.00 35.24           O  
ATOM  13518  CB  SER    88      69.754  25.418  35.260  1.00 36.16           C  
ATOM  13519  OG  SER    88      68.473  25.510  35.846  1.00 37.19           O  
ATOM  13520  N   LYS    89      68.583  28.382  34.056  1.00 34.43           N  
ATOM  13521  CA  LYS    89      67.792  29.109  33.080  1.00 33.77           C  
ATOM  13522  C   LYS    89      68.571  30.213  32.358  1.00 32.24           C  
ATOM  13523  O   LYS    89      67.994  30.935  31.545  1.00 32.12           O  
ATOM  13524  CB  LYS    89      66.543  29.690  33.739  1.00 34.20           C  
ATOM  13525  CG  LYS    89      65.489  28.606  34.078  1.00 35.37           C  
ATOM  13526  CD  LYS    89      64.197  29.224  34.590  1.00 36.03           C  
ATOM  13527  CE  LYS    89      63.040  28.177  34.705  1.00 37.98           C  
ATOM  13528  NZ  LYS    89      62.891  27.610  36.082  1.00 39.34           N  
ATOM  13529  N   ILE    90      69.865  30.341  32.642  1.00 30.91           N  
ATOM  13530  CA  ILE    90      70.740  31.151  31.793  1.00 30.51           C  
ATOM  13531  C   ILE    90      70.915  30.437  30.434  1.00 30.01           C  
ATOM  13532  O   ILE    90      71.329  29.275  30.387  1.00 31.25           O  
ATOM  13533  CB  ILE    90      72.141  31.392  32.445  1.00 30.19           C  
ATOM  13534  CG1 ILE    90      72.004  32.133  33.787  1.00 29.03           C  
ATOM  13535  CG2 ILE    90      73.086  32.137  31.461  1.00 29.03           C  
ATOM  13536  CD1 ILE    90      73.322  32.266  34.564  1.00 30.48           C  
ATOM  13537  N   ARG    91      70.602  31.114  29.336  1.00 28.51           N  
ATOM  13538  CA  ARG    91      70.882  30.563  28.010  1.00 29.50           C  
ATOM  13539  C   ARG    91      72.270  30.959  27.522  1.00 27.41           C  
ATOM  13540  O   ARG    91      73.007  30.149  26.963  1.00 25.76           O  
ATOM  13541  CB  ARG    91      69.802  30.984  27.021  1.00 29.42           C  
ATOM  13542  CG  ARG    91      68.469  30.319  27.356  1.00 33.12           C  
ATOM  13543  CD  ARG    91      67.261  30.999  26.705  1.00 35.92           C  
ATOM  13544  NE  ARG    91      67.355  31.013  25.251  1.00 43.12           N  
ATOM  13545  CZ  ARG    91      67.218  29.942  24.465  1.00 46.08           C  
ATOM  13546  NH1 ARG    91      66.945  28.734  24.973  1.00 47.97           N  
ATOM  13547  NH2 ARG    91      67.346  30.092  23.143  1.00 46.98           N  
ATOM  13548  N   ARG    92      72.634  32.203  27.780  1.00 25.79           N  
ATOM  13549  CA  ARG    92      73.916  32.748  27.347  1.00 25.72           C  
ATOM  13550  C   ARG    92      74.201  34.042  28.094  1.00 23.76           C  
ATOM  13551  O   ARG    92      73.289  34.873  28.245  1.00 22.58           O  
ATOM  13552  CB  ARG    92      73.835  33.054  25.862  1.00 26.82           C  
ATOM  13553  CG  ARG    92      74.885  33.989  25.316  1.00 31.69           C  
ATOM  13554  CD  ARG    92      75.607  33.399  24.154  1.00 37.13           C  
ATOM  13555  NE  ARG    92      76.890  32.858  24.594  1.00 40.03           N  
ATOM  13556  CZ  ARG    92      77.376  31.648  24.306  1.00 42.08           C  
ATOM  13557  NH1 ARG    92      76.702  30.777  23.546  1.00 43.85           N  
ATOM  13558  NH2 ARG    92      78.569  31.303  24.771  1.00 40.04           N  
ATOM  13559  N   VAL    93      75.433  34.184  28.586  1.00 21.68           N  
ATOM  13560  CA  VAL    93      75.905  35.473  29.055  1.00 20.41           C  
ATOM  13561  C   VAL    93      76.303  36.221  27.782  1.00 20.28           C  
ATOM  13562  O   VAL    93      77.259  35.856  27.069  1.00 21.18           O  
ATOM  13563  CB  VAL    93      77.080  35.374  30.075  1.00 20.10           C  
ATOM  13564  CG1 VAL    93      77.543  36.778  30.511  1.00 20.34           C  
ATOM  13565  CG2 VAL    93      76.685  34.513  31.307  1.00 20.35           C  
ATOM  13566  N   ILE    94      75.543  37.252  27.472  1.00 19.62           N  
ATOM  13567  CA  ILE    94      75.707  37.970  26.218  1.00 19.82           C  
ATOM  13568  C   ILE    94      76.892  38.962  26.232  1.00 19.77           C  
ATOM  13569  O   ILE    94      77.686  39.016  25.272  1.00 19.63           O  
ATOM  13570  CB  ILE    94      74.405  38.688  25.859  1.00 20.18           C  
ATOM  13571  CG1 ILE    94      73.341  37.638  25.511  1.00 21.26           C  
ATOM  13572  CG2 ILE    94      74.574  39.644  24.658  1.00 20.74           C  
ATOM  13573  CD1 ILE    94      73.669  36.882  24.212  1.00 25.02           C  
ATOM  13574  N   LYS    95      77.009  39.701  27.338  1.00 19.20           N  
ATOM  13575  CA  LYS    95      77.963  40.817  27.444  1.00 18.28           C  
ATOM  13576  C   LYS    95      78.268  41.140  28.913  1.00 18.11           C  
ATOM  13577  O   LYS    95      77.377  41.166  29.740  1.00 17.68           O  
ATOM  13578  CB  LYS    95      77.362  42.031  26.756  1.00 18.02           C  
ATOM  13579  CG  LYS    95      78.180  43.334  26.821  1.00 18.92           C  
ATOM  13580  CD  LYS    95      79.388  43.233  25.899  1.00 17.97           C  
ATOM  13581  CE  LYS    95      80.246  44.514  25.891  1.00 19.41           C  
ATOM  13582  NZ  LYS    95      79.470  45.692  25.394  1.00 20.19           N  
ATOM  13583  N   LEU    96      79.537  41.389  29.220  1.00 18.19           N  
ATOM  13584  CA  LEU    96      79.951  41.957  30.513  1.00 17.80           C  
ATOM  13585  C   LEU    96      80.658  43.271  30.202  1.00 17.10           C  
ATOM  13586  O   LEU    96      81.468  43.325  29.258  1.00 17.15           O  
ATOM  13587  CB  LEU    96      80.942  41.045  31.244  1.00 18.83           C  
ATOM  13588  CG  LEU    96      80.585  39.667  31.800  1.00 20.85           C  
ATOM  13589  CD1 LEU    96      81.711  39.277  32.729  1.00 22.50           C  
ATOM  13590  CD2 LEU    96      79.206  39.674  32.520  1.00 21.93           C  
ATOM  13591  N   ASN    97      80.329  44.321  30.946  1.00 16.61           N  
ATOM  13592  CA  ASN    97      81.130  45.529  30.906  1.00 16.14           C  
ATOM  13593  C   ASN    97      81.933  45.623  32.183  1.00 15.02           C  
ATOM  13594  O   ASN    97      81.375  45.796  33.268  1.00 14.66           O  
ATOM  13595  CB  ASN    97      80.289  46.767  30.662  1.00 16.88           C  
ATOM  13596  CG  ASN    97      79.486  46.689  29.385  1.00 18.53           C  
ATOM  13597  OD1 ASN    97      78.257  46.535  29.404  1.00 23.42           O  
ATOM  13598  ND2 ASN    97      80.171  46.786  28.273  1.00 15.75           N  
ATOM  13599  N   GLY    98      83.256  45.563  32.012  1.00 14.82           N  
ATOM  13600  CA  GLY    98      84.185  45.561  33.119  1.00 15.02           C  
ATOM  13601  C   GLY    98      84.852  46.915  33.285  1.00 15.44           C  
ATOM  13602  O   GLY    98      85.617  47.349  32.412  1.00 16.65           O  
ATOM  13603  N   PHE    99      84.542  47.593  34.386  1.00 15.14           N  
ATOM  13604  CA  PHE    99      85.102  48.870  34.692  1.00 14.44           C  
ATOM  13605  C   PHE    99      86.167  48.697  35.768  1.00 14.30           C  
ATOM  13606  O   PHE    99      85.866  48.199  36.872  1.00 14.95           O  
ATOM  13607  CB  PHE    99      83.973  49.765  35.171  1.00 15.41           C  
ATOM  13608  CG  PHE    99      82.790  49.765  34.262  1.00 16.64           C  
ATOM  13609  CD1 PHE    99      82.914  50.201  32.953  1.00 22.14           C  
ATOM  13610  CD2 PHE    99      81.554  49.354  34.715  1.00 19.51           C  
ATOM  13611  CE1 PHE    99      81.807  50.224  32.110  1.00 22.73           C  
ATOM  13612  CE2 PHE    99      80.456  49.391  33.888  1.00 20.40           C  
ATOM  13613  CZ  PHE    99      80.577  49.822  32.604  1.00 19.17           C  
ATOM  13614  N   VAL   100      87.401  49.093  35.463  1.00 12.97           N  
ATOM  13615  CA  VAL   100      88.533  48.945  36.395  1.00 13.47           C  
ATOM  13616  C   VAL   100      89.113  50.315  36.797  1.00 13.53           C  
ATOM  13617  O   VAL   100      89.639  51.033  35.962  1.00 13.48           O  
ATOM  13618  CB  VAL   100      89.674  48.129  35.768  1.00 12.63           C  
ATOM  13619  CG1 VAL   100      90.810  47.914  36.819  1.00 13.13           C  
ATOM  13620  CG2 VAL   100      89.172  46.827  35.121  1.00 14.55           C  
ATOM  13621  N   ALA   101      89.018  50.651  38.073  1.00 13.61           N  
ATOM  13622  CA  ALA   101      89.573  51.922  38.591  1.00 13.39           C  
ATOM  13623  C   ALA   101      91.080  51.820  38.411  1.00 13.93           C  
ATOM  13624  O   ALA   101      91.703  50.866  38.925  1.00 12.78           O  
ATOM  13625  CB  ALA   101      89.195  52.132  40.064  1.00 13.54           C  
ATOM  13626  N   SER   102      91.652  52.751  37.644  1.00 13.96           N  
ATOM  13627  CA  SER   102      93.014  52.597  37.122  1.00 13.76           C  
ATOM  13628  C   SER   102      93.783  53.879  37.237  1.00 13.85           C  
ATOM  13629  O   SER   102      93.239  54.942  37.020  1.00 13.85           O  
ATOM  13630  CB  SER   102      92.952  52.234  35.615  1.00 13.46           C  
ATOM  13631  OG  SER   102      92.318  50.995  35.346  1.00 15.64           O  
ATOM  13632  N   VAL   103      95.081  53.795  37.542  1.00 14.08           N  
ATOM  13633  CA  VAL   103      95.940  54.957  37.235  1.00 13.49           C  
ATOM  13634  C   VAL   103      96.211  54.943  35.728  1.00 14.32           C  
ATOM  13635  O   VAL   103      96.076  53.907  35.086  1.00 14.13           O  
ATOM  13636  CB  VAL   103      97.260  54.995  38.049  1.00 13.45           C  
ATOM  13637  CG1 VAL   103      96.964  55.212  39.528  1.00 13.30           C  
ATOM  13638  CG2 VAL   103      98.085  53.757  37.857  1.00 14.31           C  
ATOM  13639  N   PRO   104      96.528  56.120  35.158  1.00 14.49           N  
ATOM  13640  CA  PRO   104      96.705  56.218  33.710  1.00 15.18           C  
ATOM  13641  C   PRO   104      97.820  55.375  33.100  1.00 15.45           C  
ATOM  13642  O   PRO   104      97.786  55.109  31.890  1.00 17.16           O  
ATOM  13643  CB  PRO   104      96.935  57.712  33.487  1.00 15.35           C  
ATOM  13644  CG  PRO   104      96.279  58.366  34.685  1.00 16.48           C  
ATOM  13645  CD  PRO   104      96.631  57.440  35.786  1.00 15.15           C  
ATOM  13646  N   GLU   105      98.781  54.941  33.908  1.00 15.63           N  
ATOM  13647  CA  GLU   105      99.839  54.061  33.433  1.00 14.99           C  
ATOM  13648  C   GLU   105      99.426  52.591  33.472  1.00 15.57           C  
ATOM  13649  O   GLU   105     100.143  51.745  32.983  1.00 15.51           O  
ATOM  13650  CB  GLU   105     101.129  54.233  34.247  1.00 15.82           C  
ATOM  13651  CG  GLU   105     101.751  55.606  34.111  1.00 14.48           C  
ATOM  13652  CD  GLU   105     100.908  56.711  34.727  1.00 14.59           C  
ATOM  13653  OE1 GLU   105     100.406  56.563  35.871  1.00 15.16           O  
ATOM  13654  OE2 GLU   105     100.751  57.745  34.035  1.00 15.78           O  
ATOM  13655  N   PHE   106      98.296  52.297  34.120  1.00 15.66           N  
ATOM  13656  CA  PHE   106      97.815  50.921  34.211  1.00 15.19           C  
ATOM  13657  C   PHE   106      97.034  50.567  32.952  1.00 15.21           C  
ATOM  13658  O   PHE   106      96.053  51.238  32.616  1.00 15.33           O  
ATOM  13659  CB  PHE   106      96.970  50.643  35.451  1.00 15.12           C  
ATOM  13660  CG  PHE   106      96.527  49.222  35.524  1.00 14.69           C  
ATOM  13661  CD1 PHE   106      97.460  48.191  35.776  1.00 13.97           C  
ATOM  13662  CD2 PHE   106      95.195  48.878  35.251  1.00 14.24           C  
ATOM  13663  CE1 PHE   106      97.055  46.849  35.796  1.00 16.21           C  
ATOM  13664  CE2 PHE   106      94.808  47.554  35.251  1.00 16.36           C  
ATOM  13665  CZ  PHE   106      95.711  46.545  35.530  1.00 15.69           C  
ATOM  13666  N   VAL   107      97.492  49.515  32.274  1.00 15.49           N  
ATOM  13667  CA  VAL   107      96.959  49.139  30.942  1.00 15.51           C  
ATOM  13668  C   VAL   107      96.660  47.626  30.810  1.00 16.14           C  
ATOM  13669  O   VAL   107      96.676  47.065  29.678  1.00 17.46           O  
ATOM  13670  CB  VAL   107      97.875  49.636  29.813  1.00 15.35           C  
ATOM  13671  CG1 VAL   107      97.910  51.181  29.745  1.00 16.15           C  
ATOM  13672  CG2 VAL   107      99.308  49.001  29.940  1.00 17.34           C  
ATOM  13673  N   GLU   108      96.342  46.976  31.937  1.00 15.75           N  
ATOM  13674  CA  GLU   108      96.023  45.560  31.913  1.00 16.38           C  
ATOM  13675  C   GLU   108      94.628  45.285  32.422  1.00 15.43           C  
ATOM  13676  O   GLU   108      94.352  44.262  33.088  1.00 16.13           O  
ATOM  13677  CB  GLU   108      97.076  44.777  32.693  1.00 16.44           C  
ATOM  13678  CG  GLU   108      98.436  44.788  32.033  1.00 19.85           C  
ATOM  13679  CD  GLU   108      99.523  44.263  32.973  1.00 20.58           C  
ATOM  13680  OE1 GLU   108      99.742  44.801  34.079  1.00 29.71           O  
ATOM  13681  OE2 GLU   108     100.165  43.306  32.588  1.00 28.76           O  
ATOM  13682  N   GLN   109      93.705  46.167  32.065  1.00 15.62           N  
ATOM  13683  CA  GLN   109      92.320  45.982  32.468  1.00 15.33           C  
ATOM  13684  C   GLN   109      91.738  44.684  31.902  1.00 15.79           C  
ATOM  13685  O   GLN   109      90.865  44.105  32.513  1.00 16.28           O  
ATOM  13686  CB  GLN   109      91.473  47.148  32.024  1.00 15.81           C  
ATOM  13687  CG  GLN   109      91.813  48.476  32.661  1.00 14.14           C  
ATOM  13688  CD  GLN   109      92.960  49.238  31.952  1.00 15.09           C  
ATOM  13689  OE1 GLN   109      93.533  48.780  30.938  1.00 14.45           O  
ATOM  13690  NE2 GLN   109      93.277  50.409  32.470  1.00 14.52           N  
ATOM  13691  N   HIS   110      92.217  44.249  30.747  1.00 15.52           N  
ATOM  13692  CA  HIS   110      91.773  42.945  30.180  1.00 15.97           C  
ATOM  13693  C   HIS   110      92.129  41.795  31.114  1.00 15.78           C  
ATOM  13694  O   HIS   110      91.333  40.912  31.357  1.00 16.32           O  
ATOM  13695  CB  HIS   110      92.311  42.739  28.739  1.00 16.72           C  
ATOM  13696  CG  HIS   110      93.809  42.789  28.627  1.00 17.04           C  
ATOM  13697  ND1 HIS   110      94.550  43.909  28.945  1.00 19.60           N  
ATOM  13698  CD2 HIS   110      94.705  41.843  28.259  1.00 22.76           C  
ATOM  13699  CE1 HIS   110      95.839  43.643  28.780  1.00 20.17           C  
ATOM  13700  NE2 HIS   110      95.958  42.394  28.373  1.00 21.32           N  
ATOM  13701  N   LEU   111      93.330  41.821  31.669  1.00 16.38           N  
ATOM  13702  CA  LEU   111      93.763  40.836  32.657  1.00 16.96           C  
ATOM  13703  C   LEU   111      92.924  40.851  33.932  1.00 17.46           C  
ATOM  13704  O   LEU   111      92.575  39.786  34.492  1.00 19.02           O  
ATOM  13705  CB  LEU   111      95.239  41.050  32.982  1.00 17.06           C  
ATOM  13706  CG  LEU   111      96.187  40.875  31.779  1.00 17.72           C  
ATOM  13707  CD1 LEU   111      97.635  40.909  32.274  1.00 21.15           C  
ATOM  13708  CD2 LEU   111      95.918  39.613  30.974  1.00 21.14           C  
ATOM  13709  N   VAL   112      92.592  42.051  34.377  1.00 16.80           N  
ATOM  13710  CA  VAL   112      91.777  42.181  35.584  1.00 16.34           C  
ATOM  13711  C   VAL   112      90.397  41.535  35.335  1.00 16.45           C  
ATOM  13712  O   VAL   112      89.895  40.762  36.156  1.00 17.06           O  
ATOM  13713  CB  VAL   112      91.648  43.658  36.010  1.00 16.03           C  
ATOM  13714  CG1 VAL   112      90.570  43.824  37.097  1.00 14.54           C  
ATOM  13715  CG2 VAL   112      93.046  44.189  36.451  1.00 14.52           C  
ATOM  13716  N   ILE   113      89.783  41.862  34.211  1.00 16.33           N  
ATOM  13717  CA  ILE   113      88.418  41.383  33.939  1.00 16.57           C  
ATOM  13718  C   ILE   113      88.426  39.871  33.602  1.00 17.38           C  
ATOM  13719  O   ILE   113      87.418  39.207  33.835  1.00 17.79           O  
ATOM  13720  CB  ILE   113      87.684  42.255  32.877  1.00 16.97           C  
ATOM  13721  CG1 ILE   113      87.591  43.715  33.353  1.00 16.42           C  
ATOM  13722  CG2 ILE   113      86.275  41.686  32.506  1.00 16.23           C  
ATOM  13723  CD1 ILE   113      86.973  43.943  34.754  1.00 15.38           C  
ATOM  13724  N   ASN   114      89.573  39.326  33.152  1.00 17.62           N  
ATOM  13725  CA  ASN   114      89.721  37.861  33.017  1.00 18.16           C  
ATOM  13726  C   ASN   114      89.370  37.165  34.320  1.00 18.57           C  
ATOM  13727  O   ASN   114      88.867  36.056  34.301  1.00 19.99           O  
ATOM  13728  CB  ASN   114      91.130  37.469  32.547  1.00 18.52           C  
ATOM  13729  CG  ASN   114      91.406  37.829  31.083  1.00 20.10           C  
ATOM  13730  OD1 ASN   114      90.494  38.167  30.316  1.00 22.14           O  
ATOM  13731  ND2 ASN   114      92.665  37.744  30.689  1.00 20.05           N  
ATOM  13732  N   GLY   115      89.585  37.808  35.469  1.00 18.91           N  
ATOM  13733  CA  GLY   115      89.088  37.293  36.757  1.00 19.18           C  
ATOM  13734  C   GLY   115      87.609  36.931  36.679  1.00 19.79           C  
ATOM  13735  O   GLY   115      87.233  35.782  36.939  1.00 21.14           O  
ATOM  13736  N   ALA   116      86.771  37.891  36.267  1.00 19.18           N  
ATOM  13737  CA  ALA   116      85.331  37.638  36.074  1.00 18.73           C  
ATOM  13738  C   ALA   116      85.078  36.648  34.944  1.00 18.77           C  
ATOM  13739  O   ALA   116      84.318  35.704  35.117  1.00 18.13           O  
ATOM  13740  CB  ALA   116      84.563  38.940  35.818  1.00 17.60           C  
ATOM  13741  N   SER   117      85.690  36.872  33.792  1.00 19.29           N  
ATOM  13742  CA  SER   117      85.366  36.092  32.582  1.00 20.10           C  
ATOM  13743  C   SER   117      85.670  34.595  32.784  1.00 20.77           C  
ATOM  13744  O   SER   117      84.865  33.722  32.435  1.00 21.97           O  
ATOM  13745  CB  SER   117      86.103  36.640  31.358  1.00 19.41           C  
ATOM  13746  OG  SER   117      85.662  37.947  31.006  1.00 19.65           O  
ATOM  13747  N   ASN   118      86.810  34.313  33.389  1.00 21.80           N  
ATOM  13748  CA  ASN   118      87.247  32.938  33.669  1.00 21.92           C  
ATOM  13749  C   ASN   118      86.341  32.220  34.666  1.00 22.29           C  
ATOM  13750  O   ASN   118      86.014  31.026  34.477  1.00 23.85           O  
ATOM  13751  CB  ASN   118      88.672  32.936  34.193  1.00 22.14           C  
ATOM  13752  CG  ASN   118      89.692  33.319  33.143  1.00 23.36           C  
ATOM  13753  OD1 ASN   118      89.434  33.295  31.932  1.00 27.40           O  
ATOM  13754  ND2 ASN   118      90.877  33.671  33.606  1.00 27.49           N  
ATOM  13755  N   LEU   119      85.917  32.940  35.707  1.00 22.44           N  
ATOM  13756  CA  LEU   119      85.007  32.396  36.709  1.00 22.17           C  
ATOM  13757  C   LEU   119      83.654  32.058  36.071  1.00 22.24           C  
ATOM  13758  O   LEU   119      83.123  30.945  36.218  1.00 21.77           O  
ATOM  13759  CB  LEU   119      84.863  33.385  37.882  1.00 21.87           C  
ATOM  13760  CG  LEU   119      83.954  32.950  39.040  1.00 21.57           C  
ATOM  13761  CD1 LEU   119      84.343  33.550  40.394  1.00 22.43           C  
ATOM  13762  CD2 LEU   119      82.466  33.213  38.687  1.00 19.84           C  
ATOM  13763  N   ILE   120      83.100  33.014  35.340  1.00 22.68           N  
ATOM  13764  CA  ILE   120      81.797  32.834  34.691  1.00 23.03           C  
ATOM  13765  C   ILE   120      81.822  31.671  33.672  1.00 22.73           C  
ATOM  13766  O   ILE   120      80.921  30.827  33.672  1.00 22.74           O  
ATOM  13767  CB  ILE   120      81.304  34.189  34.057  1.00 22.50           C  
ATOM  13768  CG1 ILE   120      80.907  35.152  35.199  1.00 23.42           C  
ATOM  13769  CG2 ILE   120      80.119  33.969  33.092  1.00 23.23           C  
ATOM  13770  CD1 ILE   120      80.713  36.598  34.811  1.00 24.45           C  
ATOM  13771  N   ALA   121      82.859  31.598  32.846  1.00 22.93           N  
ATOM  13772  CA  ALA   121      82.995  30.525  31.867  1.00 23.71           C  
ATOM  13773  C   ALA   121      83.172  29.164  32.552  1.00 24.46           C  
ATOM  13774  O   ALA   121      82.589  28.167  32.118  1.00 24.40           O  
ATOM  13775  CB  ALA   121      84.153  30.806  30.923  1.00 24.16           C  
ATOM  13776  N   THR   122      83.934  29.146  33.646  1.00 25.07           N  
ATOM  13777  CA  THR   122      84.155  27.929  34.423  1.00 25.52           C  
ATOM  13778  C   THR   122      82.873  27.370  35.045  1.00 25.94           C  
ATOM  13779  O   THR   122      82.621  26.176  34.942  1.00 27.29           O  
ATOM  13780  CB  THR   122      85.229  28.151  35.493  1.00 25.67           C  
ATOM  13781  OG1 THR   122      86.465  28.470  34.828  1.00 25.67           O  
ATOM  13782  CG2 THR   122      85.404  26.905  36.403  1.00 25.84           C  
ATOM  13783  N   VAL   123      82.070  28.205  35.692  1.00 25.64           N  
ATOM  13784  CA  VAL   123      80.892  27.707  36.398  1.00 25.47           C  
ATOM  13785  C   VAL   123      79.727  27.416  35.437  1.00 25.14           C  
ATOM  13786  O   VAL   123      78.923  26.530  35.706  1.00 25.86           O  
ATOM  13787  CB  VAL   123      80.457  28.640  37.539  1.00 25.42           C  
ATOM  13788  CG1 VAL   123      81.594  28.801  38.558  1.00 25.65           C  
ATOM  13789  CG2 VAL   123      79.991  29.985  37.025  1.00 25.96           C  
ATOM  13790  N   LEU   124      79.648  28.132  34.316  1.00 25.53           N  
ATOM  13791  CA  LEU   124      78.543  27.974  33.358  1.00 25.86           C  
ATOM  13792  C   LEU   124      78.893  27.133  32.121  1.00 26.58           C  
ATOM  13793  O   LEU   124      77.992  26.702  31.399  1.00 27.85           O  
ATOM  13794  CB  LEU   124      78.016  29.354  32.906  1.00 25.67           C  
ATOM  13795  CG  LEU   124      77.392  30.242  34.005  1.00 25.75           C  
ATOM  13796  CD1 LEU   124      76.923  31.620  33.473  1.00 24.79           C  
ATOM  13797  CD2 LEU   124      76.239  29.529  34.730  1.00 24.67           C  
ATOM  13798  N   GLY   125      80.171  26.905  31.855  1.00 26.92           N  
ATOM  13799  CA  GLY   125      80.601  26.262  30.617  1.00 27.47           C  
ATOM  13800  C   GLY   125      80.400  27.153  29.401  1.00 28.59           C  
ATOM  13801  O   GLY   125      80.450  28.395  29.501  1.00 27.96           O  
ATOM  13802  N   GLU   126      80.145  26.533  28.247  1.00 29.57           N  
ATOM  13803  CA  GLU   126      80.046  27.272  26.987  1.00 29.15           C  
ATOM  13804  C   GLU   126      79.064  28.438  27.036  1.00 28.94           C  
ATOM  13805  O   GLU   126      79.378  29.497  26.491  1.00 29.44           O  
ATOM  13806  CB  GLU   126      79.695  26.340  25.813  1.00 31.00           C  
ATOM  13807  CG  GLU   126      79.198  27.036  24.521  1.00 32.78           C  
ATOM  13808  CD  GLU   126      80.275  27.849  23.846  1.00 39.95           C  
ATOM  13809  OE1 GLU   126      81.484  27.537  24.067  1.00 43.72           O  
ATOM  13810  OE2 GLU   126      79.914  28.797  23.096  1.00 44.33           O  
ATOM  13811  N   PRO   127      77.872  28.252  27.641  1.00 28.35           N  
ATOM  13812  CA  PRO   127      76.944  29.395  27.735  1.00 27.52           C  
ATOM  13813  C   PRO   127      77.493  30.606  28.480  1.00 26.17           C  
ATOM  13814  O   PRO   127      76.951  31.708  28.316  1.00 25.23           O  
ATOM  13815  CB  PRO   127      75.769  28.854  28.541  1.00 27.48           C  
ATOM  13816  CG  PRO   127      75.825  27.360  28.369  1.00 28.37           C  
ATOM  13817  CD  PRO   127      77.274  27.013  28.195  1.00 29.33           C  
ATOM  13818  N   GLY   128      78.509  30.381  29.316  1.00 24.90           N  
ATOM  13819  CA  GLY   128      79.160  31.456  30.029  1.00 24.87           C  
ATOM  13820  C   GLY   128      80.076  32.338  29.192  1.00 24.95           C  
ATOM  13821  O   GLY   128      80.490  33.405  29.683  1.00 25.60           O  
ATOM  13822  N   ARG   129      80.434  31.920  27.974  1.00 24.08           N  
ATOM  13823  CA  ARG   129      81.368  32.698  27.159  1.00 24.96           C  
ATOM  13824  C   ARG   129      80.614  33.880  26.582  1.00 23.19           C  
ATOM  13825  O   ARG   129      79.509  33.733  26.062  1.00 23.19           O  
ATOM  13826  CB  ARG   129      81.996  31.866  26.065  1.00 25.42           C  
ATOM  13827  CG  ARG   129      82.821  30.711  26.608  1.00 27.86           C  
ATOM  13828  CD  ARG   129      83.309  29.877  25.472  1.00 29.98           C  
ATOM  13829  NE  ARG   129      84.510  30.430  24.867  1.00 34.49           N  
ATOM  13830  CZ  ARG   129      84.825  30.292  23.581  1.00 36.05           C  
ATOM  13831  NH1 ARG   129      84.003  29.656  22.751  1.00 39.31           N  
ATOM  13832  NH2 ARG   129      85.952  30.809  23.108  1.00 35.44           N  
ATOM  13833  N   HIS   130      81.207  35.062  26.690  1.00 21.17           N  
ATOM  13834  CA  HIS   130      80.479  36.305  26.497  1.00 19.81           C  
ATOM  13835  C   HIS   130      81.292  37.340  25.734  1.00 18.95           C  
ATOM  13836  O   HIS   130      82.515  37.310  25.762  1.00 19.32           O  
ATOM  13837  CB  HIS   130      80.174  36.874  27.875  1.00 19.15           C  
ATOM  13838  CG  HIS   130      81.373  36.896  28.779  1.00 19.27           C  
ATOM  13839  ND1 HIS   130      81.715  35.823  29.575  1.00 18.83           N  
ATOM  13840  CD2 HIS   130      82.352  37.826  28.960  1.00 18.82           C  
ATOM  13841  CE1 HIS   130      82.841  36.093  30.215  1.00 19.50           C  
ATOM  13842  NE2 HIS   130      83.245  37.304  29.863  1.00 18.38           N  
ATOM  13843  N   ALA   131      80.591  38.238  25.056  1.00 18.23           N  
ATOM  13844  CA  ALA   131      81.198  39.483  24.562  1.00 17.93           C  
ATOM  13845  C   ALA   131      81.615  40.331  25.788  1.00 17.63           C  
ATOM  13846  O   ALA   131      81.145  40.128  26.900  1.00 18.26           O  
ATOM  13847  CB  ALA   131      80.243  40.256  23.664  1.00 17.85           C  
ATOM  13848  N   ARG   132      82.489  41.306  25.575  1.00 18.24           N  
ATOM  13849  CA  ARG   132      83.035  42.036  26.695  1.00 18.04           C  
ATOM  13850  C   ARG   132      83.617  43.385  26.284  1.00 17.43           C  
ATOM  13851  O   ARG   132      84.088  43.565  25.163  1.00 16.62           O  
ATOM  13852  CB  ARG   132      84.181  41.242  27.282  1.00 17.74           C  
ATOM  13853  CG  ARG   132      84.379  41.473  28.719  1.00 21.52           C  
ATOM  13854  CD  ARG   132      85.559  40.622  29.271  1.00 20.37           C  
ATOM  13855  NE  ARG   132      86.903  41.031  28.837  1.00 22.76           N  
ATOM  13856  CZ  ARG   132      88.019  40.471  29.328  1.00 21.32           C  
ATOM  13857  NH1 ARG   132      87.918  39.544  30.236  1.00 20.78           N  
ATOM  13858  NH2 ARG   132      89.223  40.856  28.939  1.00 22.78           N  
ATOM  13859  N   ALA   133      83.650  44.285  27.244  1.00 16.82           N  
ATOM  13860  CA  ALA   133      84.489  45.509  27.180  1.00 17.17           C  
ATOM  13861  C   ALA   133      85.251  45.582  28.508  1.00 16.48           C  
ATOM  13862  O   ALA   133      84.736  45.177  29.538  1.00 16.92           O  
ATOM  13863  CB  ALA   133      83.642  46.745  26.979  1.00 17.02           C  
ATOM  13864  N   ALA   134      86.494  46.049  28.468  1.00 16.84           N  
ATOM  13865  CA  ALA   134      87.303  46.207  29.665  1.00 16.59           C  
ATOM  13866  C   ALA   134      87.964  47.583  29.548  1.00 16.64           C  
ATOM  13867  O   ALA   134      88.695  47.845  28.578  1.00 17.05           O  
ATOM  13868  CB  ALA   134      88.348  45.119  29.805  1.00 17.16           C  
ATOM  13869  N   VAL   135      87.689  48.463  30.496  1.00 16.16           N  
ATOM  13870  CA  VAL   135      88.099  49.863  30.393  1.00 15.33           C  
ATOM  13871  C   VAL   135      88.602  50.422  31.715  1.00 15.04           C  
ATOM  13872  O   VAL   135      88.202  49.980  32.779  1.00 16.55           O  
ATOM  13873  CB  VAL   135      86.942  50.718  29.835  1.00 15.27           C  
ATOM  13874  CG1 VAL   135      86.621  50.279  28.369  1.00 15.28           C  
ATOM  13875  CG2 VAL   135      85.715  50.631  30.750  1.00 18.02           C  
ATOM  13876  N   GLY   136      89.451  51.440  31.644  1.00 14.42           N  
ATOM  13877  CA  GLY   136      90.007  52.072  32.833  1.00 14.05           C  
ATOM  13878  C   GLY   136      89.283  53.347  33.238  1.00 14.66           C  
ATOM  13879  O   GLY   136      89.192  54.307  32.461  1.00 16.32           O  
ATOM  13880  N   MET   137      88.838  53.366  34.492  1.00 15.74           N  
ATOM  13881  CA  MET   137      88.019  54.428  35.067  1.00 15.53           C  
ATOM  13882  C   MET   137      88.883  55.286  36.016  1.00 14.55           C  
ATOM  13883  O   MET   137      89.870  54.808  36.569  1.00 14.21           O  
ATOM  13884  CB  MET   137      86.856  53.860  35.881  1.00 17.67           C  
ATOM  13885  CG  MET   137      86.263  52.643  35.390  1.00 23.71           C  
ATOM  13886  SD  MET   137      85.665  52.752  33.523  1.00 32.58          SE  
ATOM  13887  CE  MET   137      84.716  54.461  33.938  1.00 19.25           C  
ATOM  13888  N   ALA   138      88.476  56.527  36.234  1.00 13.88           N  
ATOM  13889  CA  ALA   138      89.141  57.440  37.178  1.00 14.06           C  
ATOM  13890  C   ALA   138      88.955  56.936  38.616  1.00 14.04           C  
ATOM  13891  O   ALA   138      89.862  57.017  39.449  1.00 13.62           O  
ATOM  13892  CB  ALA   138      88.610  58.875  37.047  1.00 13.96           C  
ATOM  13893  N   SER   139      87.774  56.379  38.876  1.00 14.58           N  
ATOM  13894  CA  SER   139      87.388  55.917  40.210  1.00 15.14           C  
ATOM  13895  C   SER   139      85.992  55.291  40.117  1.00 14.88           C  
ATOM  13896  O   SER   139      85.324  55.457  39.108  1.00 14.48           O  
ATOM  13897  CB  SER   139      87.394  57.083  41.230  1.00 15.80           C  
ATOM  13898  OG  SER   139      86.720  58.247  40.755  1.00 16.73           O  
ATOM  13899  N   LEU   140      85.553  54.651  41.200  1.00 15.44           N  
ATOM  13900  CA  LEU   140      84.237  53.954  41.240  1.00 15.36           C  
ATOM  13901  C   LEU   140      83.547  54.180  42.597  1.00 15.58           C  
ATOM  13902  O   LEU   140      84.208  54.523  43.587  1.00 15.56           O  
ATOM  13903  CB  LEU   140      84.409  52.450  40.962  1.00 15.93           C  
ATOM  13904  CG  LEU   140      84.909  52.035  39.582  1.00 15.60           C  
ATOM  13905  CD1 LEU   140      85.286  50.549  39.605  1.00 15.22           C  
ATOM  13906  CD2 LEU   140      83.852  52.382  38.482  1.00 15.08           C  
ATOM  13907  N   PRO   141      82.211  54.021  42.644  1.00 15.44           N  
ATOM  13908  CA  PRO   141      81.453  54.136  43.911  1.00 16.14           C  
ATOM  13909  C   PRO   141      82.110  53.334  45.044  1.00 15.92           C  
ATOM  13910  O   PRO   141      82.581  52.199  44.826  1.00 16.30           O  
ATOM  13911  CB  PRO   141      80.075  53.575  43.548  1.00 15.94           C  
ATOM  13912  CG  PRO   141      79.935  53.831  42.101  1.00 15.45           C  
ATOM  13913  CD  PRO   141      81.316  53.727  41.508  1.00 15.64           C  
ATOM  13914  N   PHE   142      82.170  53.939  46.230  1.00 16.28           N  
ATOM  13915  CA  PHE   142      82.733  53.297  47.430  1.00 17.01           C  
ATOM  13916  C   PHE   142      84.216  52.930  47.312  1.00 17.24           C  
ATOM  13917  O   PHE   142      84.742  52.110  48.073  1.00 17.44           O  
ATOM  13918  CB  PHE   142      81.928  52.059  47.803  1.00 18.58           C  
ATOM  13919  CG  PHE   142      80.466  52.336  47.998  1.00 18.46           C  
ATOM  13920  CD1 PHE   142      80.015  52.864  49.180  1.00 21.60           C  
ATOM  13921  CD2 PHE   142      79.559  52.097  46.970  1.00 21.58           C  
ATOM  13922  CE1 PHE   142      78.682  53.137  49.358  1.00 21.61           C  
ATOM  13923  CE2 PHE   142      78.215  52.370  47.137  1.00 22.90           C  
ATOM  13924  CZ  PHE   142      77.776  52.887  48.332  1.00 22.64           C  
ATOM  13925  N   ASN   143      84.878  53.560  46.330  1.00 16.87           N  
ATOM  13926  CA  ASN   143      86.266  53.270  45.999  1.00 15.70           C  
ATOM  13927  C   ASN   143      86.510  51.824  45.587  1.00 15.55           C  
ATOM  13928  O   ASN   143      87.609  51.322  45.736  1.00 16.70           O  
ATOM  13929  CB  ASN   143      87.154  53.677  47.176  1.00 16.04           C  
ATOM  13930  CG  ASN   143      88.588  53.911  46.779  1.00 14.10           C  
ATOM  13931  OD1 ASN   143      88.914  54.151  45.608  1.00 17.82           O  
ATOM  13932  ND2 ASN   143      89.478  53.852  47.779  1.00 17.12           N  
ATOM  13933  N   ALA   144      85.488  51.161  45.023  1.00 15.75           N  
ATOM  13934  CA  ALA   144      85.636  49.826  44.460  1.00 15.29           C  
ATOM  13935  C   ALA   144      86.735  49.841  43.411  1.00 15.28           C  
ATOM  13936  O   ALA   144      86.847  50.796  42.624  1.00 14.89           O  
ATOM  13937  CB  ALA   144      84.350  49.361  43.831  1.00 15.92           C  
ATOM  13938  N   SER   145      87.538  48.785  43.403  1.00 15.49           N  
ATOM  13939  CA  SER   145      88.570  48.650  42.372  1.00 15.37           C  
ATOM  13940  C   SER   145      87.975  48.256  41.005  1.00 15.28           C  
ATOM  13941  O   SER   145      88.503  48.615  39.973  1.00 14.24           O  
ATOM  13942  CB  SER   145      89.687  47.688  42.825  1.00 16.67           C  
ATOM  13943  OG  SER   145      90.313  48.168  44.001  1.00 16.25           O  
ATOM  13944  N   VAL   146      86.877  47.516  41.017  1.00 14.87           N  
ATOM  13945  CA  VAL   146      86.230  47.021  39.809  1.00 15.23           C  
ATOM  13946  C   VAL   146      84.712  47.079  40.031  1.00 15.41           C  
ATOM  13947  O   VAL   146      84.210  46.874  41.153  1.00 15.54           O  
ATOM  13948  CB  VAL   146      86.670  45.536  39.456  1.00 15.05           C  
ATOM  13949  CG1 VAL   146      86.085  45.052  38.089  1.00 15.94           C  
ATOM  13950  CG2 VAL   146      88.232  45.354  39.571  1.00 14.96           C  
ATOM  13951  N   GLU   147      84.007  47.398  38.957  1.00 15.93           N  
ATOM  13952  CA  GLU   147      82.535  47.312  38.856  1.00 15.92           C  
ATOM  13953  C   GLU   147      82.252  46.607  37.524  1.00 15.93           C  
ATOM  13954  O   GLU   147      82.884  46.924  36.508  1.00 15.74           O  
ATOM  13955  CB  GLU   147      81.892  48.684  38.856  1.00 16.26           C  
ATOM  13956  CG  GLU   147      80.408  48.720  38.569  1.00 16.79           C  
ATOM  13957  CD  GLU   147      79.814  50.141  38.566  1.00 17.90           C  
ATOM  13958  OE1 GLU   147      80.472  51.032  39.106  1.00 16.37           O  
ATOM  13959  OE2 GLU   147      78.691  50.362  38.032  1.00 21.33           O  
ATOM  13960  N   ILE   148      81.306  45.667  37.535  1.00 16.14           N  
ATOM  13961  CA  ILE   148      80.988  44.895  36.342  1.00 15.98           C  
ATOM  13962  C   ILE   148      79.476  44.740  36.189  1.00 16.11           C  
ATOM  13963  O   ILE   148      78.794  44.315  37.129  1.00 16.86           O  
ATOM  13964  CB  ILE   148      81.601  43.456  36.330  1.00 16.86           C  
ATOM  13965  CG1 ILE   148      83.118  43.455  36.615  1.00 15.12           C  
ATOM  13966  CG2 ILE   148      81.313  42.831  34.929  1.00 17.11           C  
ATOM  13967  CD1 ILE   148      83.783  42.069  36.538  1.00 16.31           C  
ATOM  13968  N   ASP   149      78.974  45.086  35.011  1.00 15.24           N  
ATOM  13969  CA  ASP   149      77.541  44.879  34.705  1.00 16.84           C  
ATOM  13970  C   ASP   149      77.406  43.805  33.638  1.00 16.71           C  
ATOM  13971  O   ASP   149      78.409  43.329  33.087  1.00 19.31           O  
ATOM  13972  CB  ASP   149      76.857  46.181  34.332  1.00 17.25           C  
ATOM  13973  CG  ASP   149      77.178  46.666  32.924  1.00 18.92           C  
ATOM  13974  OD1 ASP   149      77.717  45.917  32.076  1.00 21.61           O  
ATOM  13975  OD2 ASP   149      76.901  47.857  32.671  1.00 23.19           O  
ATOM  13976  N   ALA   150      76.170  43.403  33.348  1.00 17.03           N  
ATOM  13977  CA  ALA   150      75.979  42.220  32.491  1.00 17.32           C  
ATOM  13978  C   ALA   150      74.653  42.251  31.760  1.00 17.32           C  
ATOM  13979  O   ALA   150      73.681  42.805  32.264  1.00 17.16           O  
ATOM  13980  CB  ALA   150      76.071  40.922  33.290  1.00 16.29           C  
ATOM  13981  N   ILE   151      74.636  41.600  30.597  1.00 17.86           N  
ATOM  13982  CA  ILE   151      73.385  41.298  29.877  1.00 18.64           C  
ATOM  13983  C   ILE   151      73.400  39.782  29.684  1.00 18.58           C  
ATOM  13984  O   ILE   151      74.408  39.216  29.252  1.00 16.46           O  
ATOM  13985  CB  ILE   151      73.295  41.986  28.517  1.00 18.12           C  
ATOM  13986  CG1 ILE   151      73.401  43.521  28.639  1.00 18.70           C  
ATOM  13987  CG2 ILE   151      72.005  41.638  27.832  1.00 18.34           C  
ATOM  13988  CD1 ILE   151      73.738  44.160  27.326  1.00 21.12           C  
ATOM  13989  N   VAL   152      72.296  39.127  30.014  1.00 19.65           N  
ATOM  13990  CA  VAL   152      72.245  37.677  30.062  1.00 20.85           C  
ATOM  13991  C   VAL   152      70.965  37.236  29.312  1.00 21.79           C  
ATOM  13992  O   VAL   152      69.875  37.732  29.595  1.00 23.25           O  
ATOM  13993  CB  VAL   152      72.234  37.157  31.530  1.00 20.51           C  
ATOM  13994  CG1 VAL   152      72.116  35.632  31.552  1.00 20.98           C  
ATOM  13995  CG2 VAL   152      73.472  37.627  32.314  1.00 19.78           C  
ATOM  13996  N   GLU   153      71.111  36.364  28.337  1.00 22.65           N  
ATOM  13997  CA  GLU   153      69.931  35.789  27.677  1.00 23.65           C  
ATOM  13998  C   GLU   153      69.416  34.643  28.566  1.00 23.87           C  
ATOM  13999  O   GLU   153      70.189  33.746  28.945  1.00 23.66           O  
ATOM  14000  CB  GLU   153      70.264  35.289  26.289  1.00 23.38           C  
ATOM  14001  CG  GLU   153      69.041  34.729  25.582  1.00 23.77           C  
ATOM  14002  CD  GLU   153      69.403  34.097  24.286  1.00 25.44           C  
ATOM  14003  OE1 GLU   153      69.856  34.818  23.377  1.00 28.66           O  
ATOM  14004  OE2 GLU   153      69.232  32.859  24.181  1.00 33.72           O  
ATOM  14005  N   ILE   154      68.116  34.683  28.885  1.00 25.68           N  
ATOM  14006  CA  ILE   154      67.500  33.757  29.854  1.00 26.78           C  
ATOM  14007  C   ILE   154      66.314  33.035  29.242  1.00 30.18           C  
ATOM  14008  O   ILE   154      65.740  33.496  28.257  1.00 29.70           O  
ATOM  14009  CB  ILE   154      67.039  34.458  31.150  1.00 26.75           C  
ATOM  14010  CG1 ILE   154      66.053  35.594  30.860  1.00 26.10           C  
ATOM  14011  CG2 ILE   154      68.259  34.960  31.966  1.00 25.49           C  
ATOM  14012  CD1 ILE   154      65.428  36.242  32.107  1.00 26.67           C  
ATOM  14013  N   ASP   155      65.987  31.894  29.838  1.00 34.08           N  
ATOM  14014  CA  ASP   155      64.750  31.169  29.526  1.00 38.39           C  
ATOM  14015  C   ASP   155      63.533  31.867  30.087  1.00 39.81           C  
ATOM  14016  O   ASP   155      63.331  31.884  31.303  1.00 41.42           O  
ATOM  14017  CB  ASP   155      64.825  29.774  30.112  1.00 38.89           C  
ATOM  14018  CG  ASP   155      65.674  28.876  29.280  1.00 42.84           C  
ATOM  14019  OD1 ASP   155      65.266  28.669  28.107  1.00 47.96           O  
ATOM  14020  OD2 ASP   155      66.738  28.398  29.774  1.00 48.12           O  
ATOM  14021  N   VAL   156      62.721  32.426  29.191  1.00 42.19           N  
ATOM  14022  CA  VAL   156      61.502  33.142  29.551  1.00 42.99           C  
ATOM  14023  C   VAL   156      60.299  32.349  29.037  1.00 44.31           C  
ATOM  14024  O   VAL   156      60.430  31.553  28.090  1.00 45.98           O  
ATOM  14025  CB  VAL   156      61.529  34.588  28.958  1.00 43.73           C  
ATOM  14026  CG1 VAL   156      60.139  35.038  28.439  1.00 44.09           C  
ATOM  14027  CG2 VAL   156      62.095  35.575  29.986  1.00 43.38           C  
END
