
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  127 (  953),  selected  127 , name 2uyp_A
# Molecule2: number of CA atoms  152 ( 1118),  selected  152 , name T0423.pdb
# PARAMETERS: 2uyp_A.T0423.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     2_A      M       1           -
LGA    K     3_A      S       2           -
LGA    I     4_A      D       3           -
LGA    I     5_A      V       4           -
LGA    E     6_A      I       5           -
LGA    T     7_A      E       6           -
LGA    -       -      G       7           -
LGA    -       -      R       8           -
LGA    -       -      L       9           -
LGA    -       -      K      10           -
LGA    -       -      E      11           -
LGA    -       -      L      12           -
LGA    -       -      G      13           -
LGA    -       -      F      14           -
LGA    -       -      T      15           -
LGA    -       -      L      16           -
LGA    Q     8_A      P      17          5.993
LGA    R     9_A      V      18          2.212
LGA    A    10_A      -       -           -
LGA    P    11_A      -       -           -
LGA    G    12_A      A      23           #
LGA    A    13_A      A      24           #
LGA    I    14_A      -       -           -
LGA    G    15_A      -       -           -
LGA    P    16_A      N      25          3.625
LGA    Y    17_A      Y      26          1.586
LGA    V    18_A      V      27          1.034
LGA    Q    19_A      P      28          0.685
LGA    G    20_A      F      29          0.802
LGA    V    21_A      T      30          1.265
LGA    D    22_A      I      31          2.227
LGA    L    23_A      S      32          2.709
LGA    G    24_A      G      33          4.016
LGA    S    25_A      N      34          1.714
LGA    M    26_A      L      35          1.265
LGA    V    27_A      L      36          0.868
LGA    F    28_A      Y      37          0.695
LGA    T    29_A      V      38          0.722
LGA    S    30_A      S      39          0.609
LGA    G    31_A      G      40          0.451
LGA    Q    32_A      Q      41          0.529
LGA    I    33_A      L      42          0.952
LGA    P    34_A      P      43          0.783
LGA    V    35_A      M      44          1.976
LGA    X    36_A      E      45          2.365
LGA    P    37_A      -       -           -
LGA    Q    38_A      -       -           -
LGA    T    39_A      S      46          2.992
LGA    G    40_A      G      47          2.456
LGA    E    41_A      K      48          1.719
LGA    I    42_A      I      49          1.986
LGA    P    43_A      A      50          1.987
LGA    A    44_A      V      51          3.295
LGA    -       -      T      52           -
LGA    -       -      G      53           -
LGA    -       -      L      54           -
LGA    -       -      V      55           -
LGA    -       -      G      56           -
LGA    -       -      R      57           -
LGA    -       -      D      58           -
LGA    -       -      V      59           -
LGA    -       -      D      60           -
LGA    -       -      V      61           -
LGA    -       -      A      62           -
LGA    D    45_A      S      63          2.538
LGA    V    46_A      A      64          1.352
LGA    Q    47_A      Q      65          2.546
LGA    D    48_A      R      66          2.044
LGA    Q    49_A      A      67          0.856
LGA    A    50_A      A      68          0.936
LGA    R    51_A      E      69          0.788
LGA    L    52_A      L      70          0.369
LGA    S    53_A      C      71          0.103
LGA    L    54_A      A      72          0.283
LGA    E    55_A      V      73          0.340
LGA    N    56_A      N      74          0.511
LGA    V    57_A      I      75          0.612
LGA    K    58_A      L      76          0.810
LGA    A    59_A      A      77          0.933
LGA    I    60_A      Q      78          0.929
LGA    V    61_A      V      79          1.184
LGA    V    62_A      K      80          1.794
LGA    A    63_A      A      81          1.762
LGA    A    64_A      A      82          1.836
LGA    G    65_A      L      83          1.883
LGA    -       -      N      84           -
LGA    -       -      G      85           -
LGA    -       -      D      86           -
LGA    -       -      L      87           -
LGA    -       -      S      88           -
LGA    -       -      K      89           -
LGA    L    66_A      I      90          3.391
LGA    S    67_A      R      91           #
LGA    V    68_A      -       -           -
LGA    G    69_A      -       -           -
LGA    D    70_A      R      92          2.347
LGA    I    71_A      V      93          1.458
LGA    I    72_A      I      94          0.417
LGA    K    73_A      K      95          1.232
LGA    M    74_A      L      96          1.298
LGA    T    75_A      N      97          1.001
LGA    V    76_A      G      98          0.932
LGA    F    77_A      F      99          1.143
LGA    I    78_A      V     100          1.040
LGA    T    79_A      A     101          1.427
LGA    D    80_A      S     102          2.475
LGA    -       -      V     103           -
LGA    -       -      P     104           -
LGA    -       -      E     105           -
LGA    -       -      F     106           -
LGA    L    81_A      V     107          3.169
LGA    N    82_A      E     108          3.280
LGA    D    83_A      Q     109          4.864
LGA    F    84_A      H     110          3.604
LGA    A    85_A      L     111          1.815
LGA    T    86_A      V     112          3.991
LGA    I    87_A      I     113          3.166
LGA    N    88_A      N     114          1.548
LGA    E    89_A      -       -           -
LGA    V    90_A      G     115          1.844
LGA    Y    91_A      A     116          2.708
LGA    K    92_A      S     117          3.682
LGA    Q    93_A      N     118          2.304
LGA    F    94_A      L     119          1.080
LGA    F    95_A      I     120          2.841
LGA    D    96_A      A     121          2.895
LGA    E    97_A      T     122          1.283
LGA    H    98_A      V     123          2.333
LGA    -       -      L     124           -
LGA    Q    99_A      G     125          0.595
LGA    A   100_A      E     126          3.081
LGA    T   101_A      P     127          4.119
LGA    -       -      G     128           -
LGA    Y   102_A      R     129          1.668
LGA    P   103_A      H     130          1.199
LGA    T   104_A      A     131          1.258
LGA    R   105_A      R     132          1.000
LGA    S   106_A      A     133          1.425
LGA    C   107_A      A     134          1.581
LGA    V   108_A      V     135          1.375
LGA    Q   109_A      G     136          0.901
LGA    V   110_A      M     137          1.418
LGA    A   111_A      A     138          0.921
LGA    R   112_A      S     139          0.853
LGA    L   113_A      L     140          0.528
LGA    P   114_A      P     141          0.358
LGA    K   115_A      F     142          0.639
LGA    D   116_A      N     143          0.630
LGA    V   117_A      A     144          0.851
LGA    K   118_A      S     145          1.287
LGA    L   119_A      V     146          1.161
LGA    E   120_A      E     147          0.933
LGA    I   121_A      I     148          0.826
LGA    E   122_A      D     149          0.871
LGA    A   123_A      A     150          0.512
LGA    I   124_A      I     151          0.715
LGA    A   125_A      V     152          1.206
LGA    V   126_A      E     153          1.583
LGA    R   127_A      I     154          2.194
LGA    S   128_A      D     155          4.249
LGA    -       -      V     156           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  127  152    5.0    109    2.01    28.44     63.406     5.166

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.902094 * X  +  -0.273588 * Y  +   0.333732 * Z  +  85.797401
  Y_new =  -0.221726 * X  +  -0.369616 * Y  +  -0.902342 * Z  +  73.437187
  Z_new =   0.370223 * X  +  -0.887994 * Y  +   0.272767 * Z  +  34.307064 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.272773    1.868819  [ DEG:   -72.9245    107.0755 ]
  Theta =  -0.379249   -2.762344  [ DEG:   -21.7293   -158.2707 ]
  Phi   =  -2.900580    0.241013  [ DEG:  -166.1910     13.8090 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2uyp_A                                        
REMARK     2: T0423.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2uyp_A.T0423.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  127  152   5.0  109   2.01   28.44  63.406
REMARK  ---------------------------------------------------------- 
MOLECULE 2uyp_A
HEADER    UNKNOWN FUNCTION                        11-APR-07   2UYP              
TITLE     CRYSTAL STRUCTURE OF E. COLI TDCF WITH BOUND PROPIONATE               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN TDCF;                                              
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 SYNONYM: TDCF;                                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 STRAIN: MC4100;                                                      
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21-DE3 GOLD;                             
SOURCE   6 EXPRESSION_SYSTEM_VECTOR: PET28A;                                    
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PETHF1                                    
KEYWDS    YJGF/YER057C/UK114 FAMILY, 2-KETOBUTYRATE, UNKNOWN FUNCTION,          
KEYWDS   2 PROPIONATE, TDCF PROTEIN, LIGAND BINDING                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.D.BURMAN,C.E.M.STEVENSON,R.G.SAWERS,D.M.LAWSON                      
REVDAT   1   29-MAY-07 2UYP    0                                                
JRNL        AUTH   J.D.BURMAN,C.E.M.STEVENSON,R.G.SAWERS,D.M.LAWSON             
JRNL        TITL   THE CRYSTAL STRUCTURE OF ESCHERICHIA COLI TDCF, A            
JRNL        TITL 2 MEMBER OF THE HIGHLY CONSERVED YJGF/YER057C/UK114            
JRNL        TITL 3 FAMILY.                                                      
JRNL        REF    BMC STRUCT.BIOL.              V.   7    30 2007              
JRNL        REFN                UK ESSN 1472-6807                               
REMARK   2 RESOLUTION. 2.44 ANGSTROMS.                                          
DBREF  2UYP A    1   129  UNP    P0AGL2   TDCF_ECOLI       1    129             
DBREF  2UYP B    1   129  UNP    P0AGL2   TDCF_ECOLI       1    129             
DBREF  2UYP C    1   129  UNP    P0AGL2   TDCF_ECOLI       1    129             
SEQRES   1 A  129  MET LYS LYS ILE ILE GLU THR GLN ARG ALA PRO GLY ALA          
SEQRES   2 A  129  ILE GLY PRO TYR VAL GLN GLY VAL ASP LEU GLY SER MET          
SEQRES   3 A  129  VAL PHE THR SER GLY GLN ILE PRO VAL OCS PRO GLN THR          
SEQRES   4 A  129  GLY GLU ILE PRO ALA ASP VAL GLN ASP GLN ALA ARG LEU          
SEQRES   5 A  129  SER LEU GLU ASN VAL LYS ALA ILE VAL VAL ALA ALA GLY          
SEQRES   6 A  129  LEU SER VAL GLY ASP ILE ILE LYS MET THR VAL PHE ILE          
SEQRES   7 A  129  THR ASP LEU ASN ASP PHE ALA THR ILE ASN GLU VAL TYR          
SEQRES   8 A  129  LYS GLN PHE PHE ASP GLU HIS GLN ALA THR TYR PRO THR          
SEQRES   9 A  129  ARG SER CYS VAL GLN VAL ALA ARG LEU PRO LYS ASP VAL          
SEQRES  10 A  129  LYS LEU GLU ILE GLU ALA ILE ALA VAL ARG SER ALA              
SEQRES   1 B  129  MET LYS LYS ILE ILE GLU THR GLN ARG ALA PRO GLY ALA          
SEQRES   2 B  129  ILE GLY PRO TYR VAL GLN GLY VAL ASP LEU GLY SER MET          
SEQRES   3 B  129  VAL PHE THR SER GLY GLN ILE PRO VAL OCS PRO GLN THR          
SEQRES   4 B  129  GLY GLU ILE PRO ALA ASP VAL GLN ASP GLN ALA ARG LEU          
SEQRES   5 B  129  SER LEU GLU ASN VAL LYS ALA ILE VAL VAL ALA ALA GLY          
SEQRES   6 B  129  LEU SER VAL GLY ASP ILE ILE LYS MET THR VAL PHE ILE          
SEQRES   7 B  129  THR ASP LEU ASN ASP PHE ALA THR ILE ASN GLU VAL TYR          
SEQRES   8 B  129  LYS GLN PHE PHE ASP GLU HIS GLN ALA THR TYR PRO THR          
SEQRES   9 B  129  ARG SER CYS VAL GLN VAL ALA ARG LEU PRO LYS ASP VAL          
SEQRES  10 B  129  LYS LEU GLU ILE GLU ALA ILE ALA VAL ARG SER ALA              
SEQRES   1 C  129  MET LYS LYS ILE ILE GLU THR GLN ARG ALA PRO GLY ALA          
SEQRES   2 C  129  ILE GLY PRO TYR VAL GLN GLY VAL ASP LEU GLY SER MET          
SEQRES   3 C  129  VAL PHE THR SER GLY GLN ILE PRO VAL OCS PRO GLN THR          
SEQRES   4 C  129  GLY GLU ILE PRO ALA ASP VAL GLN ASP GLN ALA ARG LEU          
SEQRES   5 C  129  SER LEU GLU ASN VAL LYS ALA ILE VAL VAL ALA ALA GLY          
SEQRES   6 C  129  LEU SER VAL GLY ASP ILE ILE LYS MET THR VAL PHE ILE          
SEQRES   7 C  129  THR ASP LEU ASN ASP PHE ALA THR ILE ASN GLU VAL TYR          
SEQRES   8 C  129  LYS GLN PHE PHE ASP GLU HIS GLN ALA THR TYR PRO THR          
SEQRES   9 C  129  ARG SER CYS VAL GLN VAL ALA ARG LEU PRO LYS ASP VAL          
SEQRES  10 C  129  LYS LEU GLU ILE GLU ALA ILE ALA VAL ARG SER ALA              
HET    OCS  A  36       9                                                       
HET    OCS  B  36       9                                                       
HET    OCS  C  36       9                                                       
HET    PPI  B1129       5                                                       
HET    PPI  C1129       5                                                       
HETNAM     OCS CYSTEINESULFONIC ACID                                            
HETNAM     PPI PROPANOIC ACID                                                   
FORMUL   1  OCS    3(C3 H7 N O5 S)                                              
FORMUL   4  PPI    2(C3 H6 O2)                                                  
FORMUL   6  HOH   *195(H2 O)                                                    
CRYST1   72.435   85.744   62.512  90.00  90.00  90.00 P 21 21 2    12          
ATOM      1  N   LYS A   2      57.550  43.718  32.993  1.00 39.42           N  
ATOM      2  CA  LYS A   2      58.703  44.125  33.872  1.00 39.24           C  
ATOM      3  C   LYS A   2      58.583  43.537  35.306  1.00 37.76           C  
ATOM      4  O   LYS A   2      57.640  43.815  36.043  1.00 38.61           O  
ATOM      5  CB  LYS A   2      58.898  45.670  33.877  1.00 39.51           C  
ATOM      6  CG  LYS A   2      59.847  46.216  34.991  1.00 39.80           C  
ATOM      7  CD  LYS A   2      59.615  47.700  35.340  1.00 40.15           C  
ATOM      8  CE  LYS A   2      60.644  48.162  36.395  1.00 41.29           C  
ATOM      9  NZ  LYS A   2      61.788  49.011  35.818  1.00 37.41           N  
ATOM     10  N   LYS A   3      59.546  42.711  35.675  1.00 36.08           N  
ATOM     11  CA  LYS A   3      59.606  42.130  36.998  1.00 34.38           C  
ATOM     12  C   LYS A   3      60.974  42.562  37.573  1.00 33.11           C  
ATOM     13  O   LYS A   3      62.004  42.323  36.958  1.00 33.06           O  
ATOM     14  CB  LYS A   3      59.428  40.611  36.870  1.00 33.81           C  
ATOM     15  CG  LYS A   3      59.726  39.771  38.097  1.00 35.80           C  
ATOM     16  N   ILE A   4      60.967  43.231  38.725  1.00 31.50           N  
ATOM     17  CA  ILE A   4      62.164  43.588  39.495  1.00 30.60           C  
ATOM     18  C   ILE A   4      62.844  42.350  40.067  1.00 30.23           C  
ATOM     19  O   ILE A   4      62.160  41.452  40.556  1.00 31.86           O  
ATOM     20  CB  ILE A   4      61.765  44.545  40.671  1.00 31.05           C  
ATOM     21  CG1 ILE A   4      61.383  45.920  40.131  1.00 30.49           C  
ATOM     22  CG2 ILE A   4      62.844  44.648  41.785  1.00 29.17           C  
ATOM     23  CD1 ILE A   4      60.879  46.871  41.256  1.00 32.07           C  
ATOM     24  N   ILE A   5      64.171  42.289  40.022  1.00 28.95           N  
ATOM     25  CA  ILE A   5      64.914  41.178  40.625  1.00 28.18           C  
ATOM     26  C   ILE A   5      65.510  41.597  41.972  1.00 29.20           C  
ATOM     27  O   ILE A   5      66.145  42.632  42.090  1.00 28.71           O  
ATOM     28  CB  ILE A   5      65.978  40.569  39.644  1.00 28.10           C  
ATOM     29  CG1 ILE A   5      65.269  39.874  38.476  1.00 27.33           C  
ATOM     30  CG2 ILE A   5      66.955  39.626  40.348  1.00 23.63           C  
ATOM     31  CD1 ILE A   5      66.076  39.782  37.170  1.00 27.13           C  
ATOM     32  N   GLU A   6      65.247  40.798  42.998  1.00 30.14           N  
ATOM     33  CA  GLU A   6      65.707  41.088  44.336  1.00 32.47           C  
ATOM     34  C   GLU A   6      66.318  39.803  44.906  1.00 32.12           C  
ATOM     35  O   GLU A   6      65.675  38.764  44.900  1.00 32.31           O  
ATOM     36  CB  GLU A   6      64.558  41.619  45.213  1.00 31.54           C  
ATOM     37  CG  GLU A   6      65.059  42.178  46.570  1.00 35.87           C  
ATOM     38  CD  GLU A   6      64.191  43.308  47.202  1.00 37.84           C  
ATOM     39  OE1 GLU A   6      63.380  43.979  46.475  1.00 43.10           O  
ATOM     40  OE2 GLU A   6      64.337  43.517  48.444  1.00 42.69           O  
ATOM     41  N   THR A   7      67.575  39.865  45.349  1.00 32.10           N  
ATOM     42  CA  THR A   7      68.220  38.723  46.008  1.00 31.31           C  
ATOM     43  C   THR A   7      69.190  39.195  47.083  1.00 31.73           C  
ATOM     44  O   THR A   7      69.771  40.293  46.982  1.00 31.48           O  
ATOM     45  CB  THR A   7      68.925  37.729  44.994  1.00 31.39           C  
ATOM     46  OG1 THR A   7      69.509  36.628  45.696  1.00 28.21           O  
ATOM     47  CG2 THR A   7      70.015  38.411  44.149  1.00 30.80           C  
ATOM     48  N   GLN A   8      69.337  38.359  48.117  1.00 31.95           N  
ATOM     49  CA  GLN A   8      70.258  38.590  49.237  1.00 31.35           C  
ATOM     50  C   GLN A   8      71.621  37.950  48.969  1.00 31.14           C  
ATOM     51  O   GLN A   8      72.569  38.172  49.722  1.00 31.51           O  
ATOM     52  CB  GLN A   8      69.651  38.064  50.540  1.00 32.37           C  
ATOM     53  N   ARG A   9      71.723  37.191  47.879  1.00 30.69           N  
ATOM     54  CA  ARG A   9      72.994  36.630  47.419  1.00 31.18           C  
ATOM     55  C   ARG A   9      73.805  37.664  46.595  1.00 30.16           C  
ATOM     56  O   ARG A   9      74.951  37.379  46.131  1.00 28.52           O  
ATOM     57  CB  ARG A   9      72.791  35.302  46.663  1.00 30.95           C  
ATOM     58  CG  ARG A   9      72.022  34.244  47.457  1.00 33.09           C  
ATOM     59  CD  ARG A   9      71.883  32.909  46.712  1.00 35.43           C  
ATOM     60  NE  ARG A   9      70.672  32.194  47.150  1.00 44.03           N  
ATOM     61  CZ  ARG A   9      69.517  32.109  46.467  1.00 46.91           C  
ATOM     62  NH1 ARG A   9      69.361  32.638  45.247  1.00 49.24           N  
ATOM     63  NH2 ARG A   9      68.502  31.449  46.997  1.00 49.27           N  
ATOM     64  N   ALA A  10      73.217  38.863  46.444  1.00 28.98           N  
ATOM     65  CA  ALA A  10      73.937  40.024  45.926  1.00 28.45           C  
ATOM     66  C   ALA A  10      73.731  41.204  46.876  1.00 28.67           C  
ATOM     67  O   ALA A  10      72.806  41.167  47.693  1.00 28.43           O  
ATOM     68  CB  ALA A  10      73.515  40.349  44.536  1.00 27.46           C  
ATOM     69  N   PRO A  11      74.635  42.213  46.839  1.00 28.72           N  
ATOM     70  CA  PRO A  11      74.462  43.327  47.746  1.00 29.43           C  
ATOM     71  C   PRO A  11      73.195  44.184  47.500  1.00 31.14           C  
ATOM     72  O   PRO A  11      72.803  44.429  46.361  1.00 30.58           O  
ATOM     73  CB  PRO A  11      75.744  44.143  47.585  1.00 28.94           C  
ATOM     74  CG  PRO A  11      76.440  43.635  46.463  1.00 28.51           C  
ATOM     75  CD  PRO A  11      75.862  42.337  46.029  1.00 28.97           C  
ATOM     76  N   GLY A  12      72.558  44.605  48.598  1.00 33.16           N  
ATOM     77  CA  GLY A  12      71.399  45.491  48.554  1.00 34.70           C  
ATOM     78  C   GLY A  12      71.846  46.801  47.982  1.00 35.57           C  
ATOM     79  O   GLY A  12      72.940  47.246  48.237  1.00 35.99           O  
ATOM     80  N   ALA A  13      71.001  47.392  47.159  1.00 37.52           N  
ATOM     81  CA  ALA A  13      71.292  48.668  46.496  1.00 38.35           C  
ATOM     82  C   ALA A  13      71.733  49.737  47.515  1.00 38.76           C  
ATOM     83  O   ALA A  13      71.103  49.881  48.586  1.00 38.91           O  
ATOM     84  CB  ALA A  13      70.056  49.125  45.719  1.00 38.05           C  
ATOM     85  N   ILE A  14      72.832  50.442  47.194  1.00 38.35           N  
ATOM     86  CA  ILE A  14      73.318  51.582  48.027  1.00 38.35           C  
ATOM     87  C   ILE A  14      72.774  52.941  47.521  1.00 37.00           C  
ATOM     88  O   ILE A  14      73.286  54.019  47.903  1.00 37.22           O  
ATOM     89  CB  ILE A  14      74.913  51.608  48.252  1.00 38.25           C  
ATOM     90  CG1 ILE A  14      75.681  51.549  46.925  1.00 39.30           C  
ATOM     91  CG2 ILE A  14      75.342  50.411  49.105  1.00 40.16           C  
ATOM     92  CD1 ILE A  14      76.993  52.337  46.879  1.00 38.85           C  
ATOM     93  N   GLY A  15      71.722  52.873  46.679  1.00 34.78           N  
ATOM     94  CA  GLY A  15      71.123  54.057  46.026  1.00 30.60           C  
ATOM     95  C   GLY A  15      69.862  53.710  45.278  1.00 27.62           C  
ATOM     96  O   GLY A  15      69.403  52.573  45.356  1.00 27.49           O  
ATOM     97  N   PRO A  16      69.290  54.686  44.528  1.00 25.63           N  
ATOM     98  CA  PRO A  16      67.955  54.507  43.910  1.00 24.04           C  
ATOM     99  C   PRO A  16      67.985  53.608  42.659  1.00 22.55           C  
ATOM    100  O   PRO A  16      67.843  54.097  41.531  1.00 22.37           O  
ATOM    101  CB  PRO A  16      67.556  55.951  43.572  1.00 23.48           C  
ATOM    102  CG  PRO A  16      68.852  56.593  43.280  1.00 24.16           C  
ATOM    103  CD  PRO A  16      69.853  56.006  44.200  1.00 24.73           C  
ATOM    104  N   TYR A  17      68.205  52.319  42.868  1.00 20.63           N  
ATOM    105  CA  TYR A  17      68.211  51.361  41.792  1.00 20.84           C  
ATOM    106  C   TYR A  17      67.758  49.965  42.313  1.00 20.33           C  
ATOM    107  O   TYR A  17      67.603  49.752  43.519  1.00 21.25           O  
ATOM    108  CB  TYR A  17      69.580  51.331  41.046  1.00 21.89           C  
ATOM    109  CG  TYR A  17      70.749  50.995  41.964  1.00 22.25           C  
ATOM    110  CD1 TYR A  17      71.083  49.669  42.243  1.00 21.36           C  
ATOM    111  CD2 TYR A  17      71.490  52.023  42.597  1.00 20.96           C  
ATOM    112  CE1 TYR A  17      72.127  49.367  43.128  1.00 21.39           C  
ATOM    113  CE2 TYR A  17      72.521  51.745  43.459  1.00 18.85           C  
ATOM    114  CZ  TYR A  17      72.843  50.417  43.735  1.00 23.35           C  
ATOM    115  OH  TYR A  17      73.899  50.141  44.623  1.00 27.02           O  
ATOM    116  N   VAL A  18      67.501  49.043  41.404  1.00 18.92           N  
ATOM    117  CA  VAL A  18      67.215  47.682  41.757  1.00 18.38           C  
ATOM    118  C   VAL A  18      68.378  46.892  41.197  1.00 19.53           C  
ATOM    119  O   VAL A  18      69.104  47.360  40.290  1.00 20.61           O  
ATOM    120  CB  VAL A  18      65.823  47.227  41.196  1.00 19.24           C  
ATOM    121  CG1 VAL A  18      64.646  48.145  41.811  1.00 19.12           C  
ATOM    122  CG2 VAL A  18      65.781  47.251  39.647  1.00 16.51           C  
ATOM    123  N   GLN A  19      68.592  45.688  41.710  1.00 19.29           N  
ATOM    124  CA  GLN A  19      69.748  44.904  41.254  1.00 17.94           C  
ATOM    125  C   GLN A  19      69.585  44.387  39.832  1.00 17.62           C  
ATOM    126  O   GLN A  19      70.569  44.222  39.117  1.00 17.43           O  
ATOM    127  CB  GLN A  19      70.001  43.755  42.202  1.00 18.06           C  
ATOM    128  CG  GLN A  19      70.178  44.174  43.672  1.00 18.14           C  
ATOM    129  CD  GLN A  19      70.001  42.975  44.651  1.00 18.04           C  
ATOM    130  OE1 GLN A  19      69.195  42.068  44.418  1.00 20.21           O  
ATOM    131  NE2 GLN A  19      70.767  42.980  45.737  1.00 18.60           N  
ATOM    132  N   GLY A  20      68.342  44.106  39.442  1.00 17.15           N  
ATOM    133  CA  GLY A  20      68.049  43.574  38.159  1.00 16.78           C  
ATOM    134  C   GLY A  20      66.610  43.821  37.741  1.00 18.19           C  
ATOM    135  O   GLY A  20      65.734  44.081  38.585  1.00 17.90           O  
ATOM    136  N   VAL A  21      66.384  43.779  36.427  1.00 18.78           N  
ATOM    137  CA  VAL A  21      65.043  43.765  35.836  1.00 20.10           C  
ATOM    138  C   VAL A  21      64.916  42.664  34.796  1.00 19.53           C  
ATOM    139  O   VAL A  21      65.792  42.466  33.967  1.00 20.31           O  
ATOM    140  CB  VAL A  21      64.624  45.128  35.200  1.00 19.66           C  
ATOM    141  CG1 VAL A  21      63.251  44.996  34.599  1.00 20.90           C  
ATOM    142  CG2 VAL A  21      64.504  46.155  36.273  1.00 20.70           C  
ATOM    143  N   ASP A  22      63.826  41.933  34.877  1.00 19.98           N  
ATOM    144  CA  ASP A  22      63.558  40.817  33.999  1.00 20.39           C  
ATOM    145  C   ASP A  22      62.385  41.185  33.052  1.00 21.65           C  
ATOM    146  O   ASP A  22      61.260  41.451  33.498  1.00 21.60           O  
ATOM    147  CB  ASP A  22      63.240  39.602  34.856  1.00 19.56           C  
ATOM    148  CG  ASP A  22      62.990  38.356  34.048  1.00 18.83           C  
ATOM    149  OD1 ASP A  22      62.717  38.422  32.847  1.00 23.36           O  
ATOM    150  OD2 ASP A  22      63.081  37.264  34.606  1.00 18.79           O  
ATOM    151  N   LEU A  23      62.673  41.200  31.751  1.00 22.61           N  
ATOM    152  CA  LEU A  23      61.726  41.631  30.744  1.00 23.66           C  
ATOM    153  C   LEU A  23      61.073  40.425  30.080  1.00 24.64           C  
ATOM    154  O   LEU A  23      60.418  40.576  29.072  1.00 26.69           O  
ATOM    155  CB  LEU A  23      62.427  42.481  29.653  1.00 23.42           C  
ATOM    156  CG  LEU A  23      63.338  43.656  30.069  1.00 22.48           C  
ATOM    157  CD1 LEU A  23      63.811  44.386  28.821  1.00 20.82           C  
ATOM    158  CD2 LEU A  23      62.595  44.584  30.955  1.00 19.88           C  
ATOM    159  N   GLY A  24      61.264  39.229  30.614  1.00 24.93           N  
ATOM    160  CA  GLY A  24      60.722  38.019  29.988  1.00 25.47           C  
ATOM    161  C   GLY A  24      61.780  37.488  29.057  1.00 26.02           C  
ATOM    162  O   GLY A  24      62.368  36.426  29.242  1.00 26.39           O  
ATOM    163  N   SER A  25      62.065  38.314  28.094  1.00 26.13           N  
ATOM    164  CA  SER A  25      62.989  38.039  27.039  1.00 27.37           C  
ATOM    165  C   SER A  25      64.478  38.239  27.392  1.00 26.95           C  
ATOM    166  O   SER A  25      65.347  37.463  26.946  1.00 27.33           O  
ATOM    167  CB  SER A  25      62.646  39.021  25.920  1.00 27.47           C  
ATOM    168  OG  SER A  25      63.271  38.527  24.776  1.00 32.66           O  
ATOM    169  N   MET A  26      64.751  39.336  28.104  1.00 25.31           N  
ATOM    170  CA  MET A  26      66.071  39.786  28.429  1.00 25.35           C  
ATOM    171  C   MET A  26      66.057  40.121  29.896  1.00 22.83           C  
ATOM    172  O   MET A  26      65.027  40.525  30.423  1.00 22.02           O  
ATOM    173  CB  MET A  26      66.437  41.076  27.690  1.00 25.46           C  
ATOM    174  CG  MET A  26      66.352  41.066  26.189  1.00 29.04           C  
ATOM    175  SD  MET A  26      67.089  42.601  25.543  1.00 30.56           S  
ATOM    176  CE  MET A  26      68.792  42.178  25.854  1.00 28.24           C  
ATOM    177  N   VAL A  27      67.213  39.960  30.538  1.00 21.59           N  
ATOM    178  CA  VAL A  27      67.436  40.416  31.915  1.00 20.43           C  
ATOM    179  C   VAL A  27      68.606  41.414  31.859  1.00 19.53           C  
ATOM    180  O   VAL A  27      69.618  41.153  31.167  1.00 19.72           O  
ATOM    181  CB  VAL A  27      67.748  39.214  32.846  1.00 21.27           C  
ATOM    182  CG1 VAL A  27      68.296  39.673  34.244  1.00 21.53           C  
ATOM    183  CG2 VAL A  27      66.520  38.292  32.993  1.00 19.24           C  
ATOM    184  N   PHE A  28      68.430  42.561  32.526  1.00 17.50           N  
ATOM    185  CA  PHE A  28      69.469  43.615  32.728  1.00 15.23           C  
ATOM    186  C   PHE A  28      69.862  43.596  34.188  1.00 14.58           C  
ATOM    187  O   PHE A  28      68.972  43.479  35.047  1.00 13.02           O  
ATOM    188  CB  PHE A  28      68.946  45.025  32.351  1.00 15.09           C  
ATOM    189  CG  PHE A  28      68.824  45.256  30.843  1.00 15.52           C  
ATOM    190  CD1 PHE A  28      67.715  44.780  30.126  1.00 16.37           C  
ATOM    191  CD2 PHE A  28      69.830  45.912  30.152  1.00 13.22           C  
ATOM    192  CE1 PHE A  28      67.613  44.968  28.743  1.00 16.96           C  
ATOM    193  CE2 PHE A  28      69.741  46.104  28.791  1.00 15.18           C  
ATOM    194  CZ  PHE A  28      68.635  45.620  28.064  1.00 13.54           C  
ATOM    195  N   THR A  29      71.175  43.628  34.461  1.00 13.42           N  
ATOM    196  CA  THR A  29      71.702  43.843  35.828  1.00 13.42           C  
ATOM    197  C   THR A  29      72.153  45.312  35.990  1.00 13.91           C  
ATOM    198  O   THR A  29      72.524  45.997  35.003  1.00 14.16           O  
ATOM    199  CB  THR A  29      72.878  42.848  36.299  1.00 13.00           C  
ATOM    200  OG1 THR A  29      74.140  43.279  35.803  1.00 12.74           O  
ATOM    201  CG2 THR A  29      72.659  41.377  35.894  1.00 13.43           C  
ATOM    202  N   SER A  30      72.069  45.816  37.223  1.00 13.26           N  
ATOM    203  CA  SER A  30      72.856  46.982  37.589  1.00 13.07           C  
ATOM    204  C   SER A  30      74.381  46.693  37.486  1.00 12.34           C  
ATOM    205  O   SER A  30      74.809  45.558  37.390  1.00 13.15           O  
ATOM    206  CB  SER A  30      72.456  47.482  38.998  1.00 12.40           C  
ATOM    207  OG  SER A  30      71.202  48.121  38.924  1.00 12.92           O  
ATOM    208  N   GLY A  31      75.207  47.718  37.549  1.00 12.05           N  
ATOM    209  CA  GLY A  31      76.636  47.494  37.618  1.00 11.81           C  
ATOM    210  C   GLY A  31      77.031  47.006  38.972  1.00 11.56           C  
ATOM    211  O   GLY A  31      76.833  47.697  39.996  1.00 12.57           O  
ATOM    212  N   GLN A  32      77.561  45.802  38.975  1.00 11.46           N  
ATOM    213  CA  GLN A  32      77.960  45.077  40.168  1.00 11.82           C  
ATOM    214  C   GLN A  32      79.405  45.440  40.504  1.00 12.58           C  
ATOM    215  O   GLN A  32      80.315  45.262  39.678  1.00 13.51           O  
ATOM    216  CB  GLN A  32      77.859  43.548  39.916  1.00 12.52           C  
ATOM    217  CG  GLN A  32      76.438  43.030  39.731  1.00 12.97           C  
ATOM    218  CD  GLN A  32      75.537  43.680  40.717  1.00 13.73           C  
ATOM    219  OE1 GLN A  32      75.751  43.505  41.904  1.00 13.77           O  
ATOM    220  NE2 GLN A  32      74.551  44.487  40.249  1.00 12.34           N  
ATOM    221  N   ILE A  33      79.582  45.960  41.712  1.00 13.16           N  
ATOM    222  CA  ILE A  33      80.859  46.300  42.320  1.00 12.40           C  
ATOM    223  C   ILE A  33      81.220  45.182  43.344  1.00 14.30           C  
ATOM    224  O   ILE A  33      80.333  44.412  43.751  1.00 16.14           O  
ATOM    225  CB  ILE A  33      80.808  47.727  42.925  1.00 11.39           C  
ATOM    226  CG1 ILE A  33      79.699  47.877  43.946  1.00 11.88           C  
ATOM    227  CG2 ILE A  33      80.584  48.798  41.827  1.00 12.01           C  
ATOM    228  CD1 ILE A  33      79.752  49.167  44.746  1.00  9.24           C  
ATOM    229  N   PRO A  34      82.526  45.005  43.682  1.00 14.81           N  
ATOM    230  CA  PRO A  34      82.901  43.994  44.664  1.00 14.51           C  
ATOM    231  C   PRO A  34      82.562  44.371  46.099  1.00 16.53           C  
ATOM    232  O   PRO A  34      83.472  44.517  46.918  1.00 16.49           O  
ATOM    233  CB  PRO A  34      84.403  43.900  44.493  1.00 15.10           C  
ATOM    234  CG  PRO A  34      84.834  45.236  43.883  1.00 12.91           C  
ATOM    235  CD  PRO A  34      83.704  45.653  43.055  1.00 14.60           C  
ATOM    236  N   VAL A  35      81.264  44.548  46.394  1.00 17.76           N  
ATOM    237  CA  VAL A  35      80.777  44.615  47.755  1.00 18.43           C  
ATOM    238  C   VAL A  35      80.293  43.234  48.202  1.00 20.85           C  
ATOM    239  O   VAL A  35      79.614  42.520  47.461  1.00 20.60           O  
ATOM    240  CB  VAL A  35      79.689  45.662  47.978  1.00 17.33           C  
ATOM    241  CG1 VAL A  35      79.113  45.443  49.352  1.00 16.83           C  
ATOM    242  CG2 VAL A  35      80.255  47.081  47.850  1.00 14.04           C  
HETATM  243  N   OCS A  36      80.683  42.840  49.408  1.00 24.18           N  
HETATM  244  CA  OCS A  36      80.324  41.513  49.879  1.00 25.29           C  
HETATM  245  CB  OCS A  36      81.318  41.041  50.940  1.00 25.56           C  
HETATM  246  SG  OCS A  36      81.214  39.297  51.414  1.00 29.20           S  
HETATM  247  C   OCS A  36      78.876  41.583  50.360  1.00 25.80           C  
HETATM  248  O   OCS A  36      78.525  42.467  51.153  1.00 26.09           O  
HETATM  249  OD1 OCS A  36      82.368  38.922  52.171  1.00 31.38           O  
HETATM  250  OD2 OCS A  36      80.026  39.189  52.211  1.00 32.73           O  
HETATM  251  OD3 OCS A  36      81.174  38.370  50.279  1.00 29.75           O  
ATOM    252  N   PRO A  37      78.004  40.714  49.816  1.00 26.88           N  
ATOM    253  CA  PRO A  37      76.586  40.740  50.230  1.00 28.03           C  
ATOM    254  C   PRO A  37      76.425  40.351  51.728  1.00 29.90           C  
ATOM    255  O   PRO A  37      75.578  40.910  52.448  1.00 29.96           O  
ATOM    256  CB  PRO A  37      75.933  39.693  49.321  1.00 27.94           C  
ATOM    257  CG  PRO A  37      77.104  38.738  48.898  1.00 26.65           C  
ATOM    258  CD  PRO A  37      78.297  39.647  48.819  1.00 26.71           C  
ATOM    259  N   GLN A  38      77.239  39.430  52.224  1.00 31.53           N  
ATOM    260  CA  GLN A  38      77.130  39.145  53.658  1.00 34.37           C  
ATOM    261  C   GLN A  38      77.665  40.292  54.600  1.00 34.44           C  
ATOM    262  O   GLN A  38      76.975  40.694  55.546  1.00 35.07           O  
ATOM    263  CB  GLN A  38      77.585  37.714  53.992  1.00 33.79           C  
ATOM    264  CG  GLN A  38      76.418  36.671  53.933  1.00 39.90           C  
ATOM    265  CD  GLN A  38      75.251  37.010  52.911  1.00 46.30           C  
ATOM    266  OE1 GLN A  38      74.328  37.787  53.238  1.00 48.96           O  
ATOM    267  NE2 GLN A  38      75.291  36.400  51.690  1.00 46.17           N  
ATOM    268  N   THR A  39      78.835  40.863  54.306  1.00 33.75           N  
ATOM    269  CA  THR A  39      79.460  41.808  55.235  1.00 32.74           C  
ATOM    270  C   THR A  39      79.439  43.311  54.869  1.00 32.17           C  
ATOM    271  O   THR A  39      79.572  44.178  55.751  1.00 31.76           O  
ATOM    272  CB  THR A  39      80.883  41.379  55.487  1.00 32.54           C  
ATOM    273  OG1 THR A  39      81.657  41.592  54.304  1.00 33.24           O  
ATOM    274  CG2 THR A  39      80.871  39.909  55.781  1.00 32.68           C  
ATOM    275  N   GLY A  40      79.294  43.633  53.586  1.00 30.76           N  
ATOM    276  CA  GLY A  40      79.561  45.019  53.151  1.00 28.94           C  
ATOM    277  C   GLY A  40      81.025  45.319  52.834  1.00 28.02           C  
ATOM    278  O   GLY A  40      81.320  46.414  52.372  1.00 27.68           O  
ATOM    279  N   GLU A  41      81.937  44.347  53.056  1.00 26.94           N  
ATOM    280  CA  GLU A  41      83.377  44.543  52.825  1.00 25.63           C  
ATOM    281  C   GLU A  41      83.743  44.578  51.364  1.00 24.77           C  
ATOM    282  O   GLU A  41      83.115  43.885  50.553  1.00 25.41           O  
ATOM    283  CB  GLU A  41      84.236  43.469  53.522  1.00 26.33           C  
ATOM    284  N   ILE A  42      84.771  45.379  51.042  1.00 23.20           N  
ATOM    285  CA  ILE A  42      85.408  45.372  49.717  1.00 21.07           C  
ATOM    286  C   ILE A  42      86.792  44.702  49.814  1.00 21.01           C  
ATOM    287  O   ILE A  42      87.703  45.223  50.493  1.00 20.43           O  
ATOM    288  CB  ILE A  42      85.560  46.814  49.164  1.00 20.80           C  
ATOM    289  CG1 ILE A  42      84.162  47.412  48.832  1.00 19.02           C  
ATOM    290  CG2 ILE A  42      86.534  46.855  47.957  1.00 18.54           C  
ATOM    291  CD1 ILE A  42      84.119  48.937  48.814  1.00 12.69           C  
ATOM    292  N   PRO A  43      86.966  43.549  49.152  1.00 20.05           N  
ATOM    293  CA  PRO A  43      88.286  42.902  49.252  1.00 19.37           C  
ATOM    294  C   PRO A  43      89.387  43.781  48.645  1.00 19.75           C  
ATOM    295  O   PRO A  43      89.104  44.610  47.741  1.00 19.62           O  
ATOM    296  CB  PRO A  43      88.115  41.581  48.478  1.00 19.13           C  
ATOM    297  CG  PRO A  43      86.814  41.717  47.696  1.00 17.68           C  
ATOM    298  CD  PRO A  43      85.998  42.793  48.326  1.00 19.63           C  
ATOM    299  N   ALA A  44      90.614  43.611  49.144  1.00 19.64           N  
ATOM    300  CA  ALA A  44      91.716  44.541  48.853  1.00 20.72           C  
ATOM    301  C   ALA A  44      92.301  44.258  47.496  1.00 20.65           C  
ATOM    302  O   ALA A  44      92.477  45.197  46.707  1.00 20.56           O  
ATOM    303  CB  ALA A  44      92.836  44.467  49.933  1.00 20.45           C  
ATOM    304  N   ASP A  45      92.568  42.974  47.233  1.00 20.77           N  
ATOM    305  CA  ASP A  45      93.216  42.511  46.016  1.00 22.11           C  
ATOM    306  C   ASP A  45      92.277  42.545  44.818  1.00 21.04           C  
ATOM    307  O   ASP A  45      91.090  42.229  44.941  1.00 20.79           O  
ATOM    308  CB  ASP A  45      93.748  41.067  46.159  1.00 23.69           C  
ATOM    309  CG  ASP A  45      94.939  40.947  47.118  1.00 31.04           C  
ATOM    310  OD1 ASP A  45      95.261  41.923  47.885  1.00 37.15           O  
ATOM    311  OD2 ASP A  45      95.569  39.848  47.106  1.00 36.39           O  
ATOM    312  N   VAL A  46      92.846  42.886  43.660  1.00 20.16           N  
ATOM    313  CA  VAL A  46      92.120  42.945  42.433  1.00 19.80           C  
ATOM    314  C   VAL A  46      91.529  41.617  41.985  1.00 20.88           C  
ATOM    315  O   VAL A  46      90.425  41.644  41.352  1.00 21.68           O  
ATOM    316  CB  VAL A  46      92.900  43.683  41.295  1.00 19.71           C  
ATOM    317  CG1 VAL A  46      94.103  42.919  40.794  1.00 17.99           C  
ATOM    318  CG2 VAL A  46      91.955  44.010  40.181  1.00 19.68           C  
ATOM    319  N   GLN A  47      92.197  40.484  42.319  1.00 19.71           N  
ATOM    320  CA  GLN A  47      91.704  39.119  41.965  1.00 20.13           C  
ATOM    321  C   GLN A  47      90.366  38.782  42.672  1.00 19.37           C  
ATOM    322  O   GLN A  47      89.388  38.358  42.086  1.00 19.57           O  
ATOM    323  CB  GLN A  47      92.743  38.038  42.315  1.00 20.26           C  
ATOM    324  N   ASP A  48      90.375  39.007  43.965  1.00 19.26           N  
ATOM    325  CA  ASP A  48      89.230  38.910  44.818  1.00 18.33           C  
ATOM    326  C   ASP A  48      88.120  39.891  44.418  1.00 17.74           C  
ATOM    327  O   ASP A  48      86.965  39.502  44.418  1.00 17.50           O  
ATOM    328  CB  ASP A  48      89.705  39.137  46.247  1.00 17.43           C  
ATOM    329  CG  ASP A  48      90.629  38.046  46.701  1.00 20.81           C  
ATOM    330  OD1 ASP A  48      90.504  36.938  46.120  1.00 17.41           O  
ATOM    331  OD2 ASP A  48      91.458  38.280  47.643  1.00 23.97           O  
ATOM    332  N   GLN A  49      88.462  41.144  44.106  1.00 16.30           N  
ATOM    333  CA  GLN A  49      87.443  42.075  43.636  1.00 16.30           C  
ATOM    334  C   GLN A  49      86.820  41.636  42.313  1.00 16.17           C  
ATOM    335  O   GLN A  49      85.606  41.680  42.157  1.00 15.86           O  
ATOM    336  CB  GLN A  49      88.002  43.474  43.472  1.00 15.77           C  
ATOM    337  CG  GLN A  49      88.364  44.175  44.773  1.00 14.37           C  
ATOM    338  CD  GLN A  49      88.420  45.652  44.575  1.00 14.39           C  
ATOM    339  OE1 GLN A  49      87.942  46.150  43.559  1.00 15.07           O  
ATOM    340  NE2 GLN A  49      88.981  46.382  45.539  1.00 14.19           N  
ATOM    341  N   ALA A  50      87.658  41.224  41.362  1.00 16.10           N  
ATOM    342  CA  ALA A  50      87.159  40.735  40.075  1.00 15.90           C  
ATOM    343  C   ALA A  50      86.240  39.495  40.287  1.00 16.18           C  
ATOM    344  O   ALA A  50      85.081  39.450  39.799  1.00 15.83           O  
ATOM    345  CB  ALA A  50      88.304  40.416  39.141  1.00 14.78           C  
ATOM    346  N   ARG A  51      86.753  38.505  41.005  1.00 15.87           N  
ATOM    347  CA  ARG A  51      85.950  37.353  41.342  1.00 17.34           C  
ATOM    348  C   ARG A  51      84.610  37.736  41.962  1.00 16.68           C  
ATOM    349  O   ARG A  51      83.576  37.161  41.597  1.00 18.28           O  
ATOM    350  CB  ARG A  51      86.699  36.405  42.294  1.00 18.16           C  
ATOM    351  CG  ARG A  51      85.888  35.152  42.600  1.00 21.83           C  
ATOM    352  CD  ARG A  51      86.015  34.257  41.376  1.00 28.34           C  
ATOM    353  NE  ARG A  51      85.007  33.236  41.195  1.00 30.10           N  
ATOM    354  CZ  ARG A  51      85.165  32.248  40.323  1.00 34.56           C  
ATOM    355  NH1 ARG A  51      86.313  32.181  39.610  1.00 33.08           N  
ATOM    356  NH2 ARG A  51      84.198  31.329  40.175  1.00 32.87           N  
ATOM    357  N   LEU A  52      84.640  38.682  42.899  1.00 15.79           N  
ATOM    358  CA  LEU A  52      83.458  39.145  43.627  1.00 14.92           C  
ATOM    359  C   LEU A  52      82.439  39.930  42.804  1.00 14.96           C  
ATOM    360  O   LEU A  52      81.254  39.701  43.000  1.00 15.19           O  
ATOM    361  CB  LEU A  52      83.834  39.876  44.927  1.00 15.17           C  
ATOM    362  CG  LEU A  52      82.701  40.216  45.918  1.00 17.63           C  
ATOM    363  CD1 LEU A  52      81.608  39.018  46.260  1.00 12.18           C  
ATOM    364  CD2 LEU A  52      83.284  40.867  47.191  1.00 13.65           C  
ATOM    365  N   SER A  53      82.841  40.788  41.851  1.00 14.25           N  
ATOM    366  CA  SER A  53      81.822  41.373  41.003  1.00 14.68           C  
ATOM    367  C   SER A  53      81.100  40.338  40.221  1.00 14.78           C  
ATOM    368  O   SER A  53      79.903  40.450  40.043  1.00 16.62           O  
ATOM    369  CB  SER A  53      82.343  42.353  39.983  1.00 14.75           C  
ATOM    370  OG  SER A  53      82.911  43.391  40.632  1.00 17.35           O  
ATOM    371  N   LEU A  54      81.841  39.373  39.689  1.00 14.83           N  
ATOM    372  CA  LEU A  54      81.288  38.334  38.844  1.00 14.44           C  
ATOM    373  C   LEU A  54      80.309  37.414  39.620  1.00 13.68           C  
ATOM    374  O   LEU A  54      79.314  37.028  39.071  1.00 13.86           O  
ATOM    375  CB  LEU A  54      82.408  37.511  38.207  1.00 14.40           C  
ATOM    376  CG  LEU A  54      83.247  38.233  37.167  1.00 14.61           C  
ATOM    377  CD1 LEU A  54      84.552  37.483  36.929  1.00 12.23           C  
ATOM    378  CD2 LEU A  54      82.449  38.462  35.854  1.00 15.93           C  
ATOM    379  N   GLU A  55      80.579  37.133  40.882  1.00 13.47           N  
ATOM    380  CA  GLU A  55      79.657  36.396  41.747  1.00 15.65           C  
ATOM    381  C   GLU A  55      78.373  37.153  42.041  1.00 15.95           C  
ATOM    382  O   GLU A  55      77.286  36.542  42.101  1.00 17.21           O  
ATOM    383  CB  GLU A  55      80.314  35.919  43.082  1.00 16.10           C  
ATOM    384  CG  GLU A  55      81.493  34.932  42.924  1.00 18.70           C  
ATOM    385  CD  GLU A  55      81.118  33.658  42.175  1.00 27.00           C  
ATOM    386  OE1 GLU A  55      79.945  33.258  42.205  1.00 30.01           O  
ATOM    387  OE2 GLU A  55      81.993  33.006  41.558  1.00 34.85           O  
ATOM    388  N   ASN A  56      78.488  38.467  42.198  1.00 16.23           N  
ATOM    389  CA  ASN A  56      77.346  39.387  42.330  1.00 15.75           C  
ATOM    390  C   ASN A  56      76.495  39.428  41.058  1.00 16.17           C  
ATOM    391  O   ASN A  56      75.259  39.424  41.125  1.00 15.63           O  
ATOM    392  CB  ASN A  56      77.871  40.784  42.609  1.00 15.82           C  
ATOM    393  CG  ASN A  56      78.235  40.975  44.027  1.00 15.85           C  
ATOM    394  OD1 ASN A  56      77.864  40.163  44.856  1.00 19.88           O  
ATOM    395  ND2 ASN A  56      78.949  42.069  44.347  1.00 13.88           N  
ATOM    396  N   VAL A  57      77.152  39.455  39.896  1.00 16.16           N  
ATOM    397  CA  VAL A  57      76.434  39.365  38.609  1.00 16.54           C  
ATOM    398  C   VAL A  57      75.684  38.007  38.517  1.00 17.49           C  
ATOM    399  O   VAL A  57      74.476  37.983  38.281  1.00 18.32           O  
ATOM    400  CB  VAL A  57      77.389  39.549  37.386  1.00 15.94           C  
ATOM    401  CG1 VAL A  57      76.667  39.185  36.091  1.00 17.13           C  
ATOM    402  CG2 VAL A  57      77.951  40.973  37.288  1.00 14.18           C  
ATOM    403  N   LYS A  58      76.402  36.894  38.703  1.00 17.97           N  
ATOM    404  CA  LYS A  58      75.820  35.540  38.808  1.00 18.42           C  
ATOM    405  C   LYS A  58      74.590  35.509  39.724  1.00 18.60           C  
ATOM    406  O   LYS A  58      73.542  34.952  39.381  1.00 19.38           O  
ATOM    407  CB  LYS A  58      76.867  34.540  39.347  1.00 17.69           C  
ATOM    408  CG  LYS A  58      76.377  33.079  39.487  1.00 17.81           C  
ATOM    409  CD  LYS A  58      77.366  32.132  40.283  1.00 18.26           C  
ATOM    410  CE  LYS A  58      77.044  32.169  41.788  1.00 22.60           C  
ATOM    411  NZ  LYS A  58      78.080  31.612  42.818  1.00 23.43           N  
ATOM    412  N   ALA A  59      74.742  36.093  40.903  1.00 18.41           N  
ATOM    413  CA  ALA A  59      73.723  36.022  41.918  1.00 18.41           C  
ATOM    414  C   ALA A  59      72.422  36.623  41.411  1.00 18.53           C  
ATOM    415  O   ALA A  59      71.366  36.043  41.627  1.00 20.10           O  
ATOM    416  CB  ALA A  59      74.189  36.730  43.179  1.00 17.82           C  
ATOM    417  N   ILE A  60      72.483  37.756  40.716  1.00 18.25           N  
ATOM    418  CA  ILE A  60      71.281  38.392  40.185  1.00 17.78           C  
ATOM    419  C   ILE A  60      70.676  37.637  38.992  1.00 18.11           C  
ATOM    420  O   ILE A  60      69.464  37.575  38.839  1.00 18.15           O  
ATOM    421  CB  ILE A  60      71.557  39.877  39.885  1.00 18.39           C  
ATOM    422  CG1 ILE A  60      71.874  40.663  41.177  1.00 15.52           C  
ATOM    423  CG2 ILE A  60      70.425  40.576  39.039  1.00 18.11           C  
ATOM    424  CD1 ILE A  60      72.683  41.931  40.831  1.00  9.84           C  
ATOM    425  N   VAL A  61      71.528  37.088  38.144  1.00 18.41           N  
ATOM    426  CA  VAL A  61      71.097  36.358  36.941  1.00 19.18           C  
ATOM    427  C   VAL A  61      70.471  34.967  37.322  1.00 20.13           C  
ATOM    428  O   VAL A  61      69.521  34.481  36.676  1.00 20.36           O  
ATOM    429  CB  VAL A  61      72.324  36.189  35.993  1.00 19.01           C  
ATOM    430  CG1 VAL A  61      72.067  35.201  34.866  1.00 19.37           C  
ATOM    431  CG2 VAL A  61      72.798  37.525  35.483  1.00 17.73           C  
ATOM    432  N   VAL A  62      71.028  34.331  38.349  1.00 19.88           N  
ATOM    433  CA  VAL A  62      70.450  33.110  38.883  1.00 20.79           C  
ATOM    434  C   VAL A  62      69.087  33.403  39.513  1.00 20.88           C  
ATOM    435  O   VAL A  62      68.167  32.634  39.342  1.00 22.09           O  
ATOM    436  CB  VAL A  62      71.399  32.436  39.906  1.00 21.75           C  
ATOM    437  CG1 VAL A  62      70.707  31.274  40.640  1.00 22.15           C  
ATOM    438  CG2 VAL A  62      72.740  31.983  39.245  1.00 17.89           C  
ATOM    439  N   ALA A  63      68.940  34.516  40.223  1.00 21.12           N  
ATOM    440  CA  ALA A  63      67.679  34.844  40.905  1.00 20.90           C  
ATOM    441  C   ALA A  63      66.496  35.081  39.933  1.00 21.77           C  
ATOM    442  O   ALA A  63      65.304  34.874  40.280  1.00 22.06           O  
ATOM    443  CB  ALA A  63      67.877  36.024  41.807  1.00 20.34           C  
ATOM    444  N   ALA A  64      66.834  35.550  38.737  1.00 21.92           N  
ATOM    445  CA  ALA A  64      65.910  35.667  37.637  1.00 22.29           C  
ATOM    446  C   ALA A  64      65.518  34.307  36.978  1.00 23.39           C  
ATOM    447  O   ALA A  64      64.605  34.275  36.103  1.00 24.99           O  
ATOM    448  CB  ALA A  64      66.498  36.575  36.593  1.00 22.14           C  
ATOM    449  N   GLY A  65      66.180  33.206  37.355  1.00 22.35           N  
ATOM    450  CA  GLY A  65      65.852  31.884  36.791  1.00 21.99           C  
ATOM    451  C   GLY A  65      66.775  31.467  35.665  1.00 22.35           C  
ATOM    452  O   GLY A  65      66.553  30.452  34.979  1.00 22.16           O  
ATOM    453  N   LEU A  66      67.849  32.239  35.496  1.00 22.00           N  
ATOM    454  CA  LEU A  66      68.739  32.079  34.368  1.00 20.63           C  
ATOM    455  C   LEU A  66      70.054  31.541  34.892  1.00 21.28           C  
ATOM    456  O   LEU A  66      70.167  31.199  36.094  1.00 21.43           O  
ATOM    457  CB  LEU A  66      68.889  33.429  33.660  1.00 19.56           C  
ATOM    458  CG  LEU A  66      67.714  33.905  32.799  1.00 19.08           C  
ATOM    459  CD1 LEU A  66      68.083  35.052  31.878  1.00 17.49           C  
ATOM    460  CD2 LEU A  66      67.190  32.774  31.931  1.00 20.86           C  
ATOM    461  N   SER A  67      71.055  31.462  34.018  1.00 20.83           N  
ATOM    462  CA  SER A  67      72.383  31.079  34.458  1.00 21.55           C  
ATOM    463  C   SER A  67      73.445  31.918  33.748  1.00 21.31           C  
ATOM    464  O   SER A  67      73.122  32.747  32.908  1.00 22.12           O  
ATOM    465  CB  SER A  67      72.605  29.569  34.263  1.00 21.90           C  
ATOM    466  OG  SER A  67      72.629  29.239  32.884  1.00 23.10           O  
ATOM    467  N   VAL A  68      74.705  31.728  34.130  1.00 21.21           N  
ATOM    468  CA  VAL A  68      75.866  32.472  33.576  1.00 20.77           C  
ATOM    469  C   VAL A  68      76.051  32.308  32.074  1.00 20.78           C  
ATOM    470  O   VAL A  68      76.417  33.259  31.405  1.00 21.27           O  
ATOM    471  CB  VAL A  68      77.158  32.064  34.296  1.00 20.21           C  
ATOM    472  CG1 VAL A  68      78.361  32.455  33.469  1.00 18.72           C  
ATOM    473  CG2 VAL A  68      77.169  32.728  35.671  1.00 19.54           C  
ATOM    474  N   GLY A  69      75.794  31.104  31.552  1.00 20.53           N  
ATOM    475  CA  GLY A  69      75.843  30.850  30.098  1.00 20.34           C  
ATOM    476  C   GLY A  69      74.727  31.511  29.284  1.00 20.12           C  
ATOM    477  O   GLY A  69      74.731  31.396  28.032  1.00 20.85           O  
ATOM    478  N   ASP A  70      73.803  32.207  29.981  1.00 18.35           N  
ATOM    479  CA  ASP A  70      72.772  33.072  29.371  1.00 16.88           C  
ATOM    480  C   ASP A  70      73.172  34.541  29.156  1.00 17.00           C  
ATOM    481  O   ASP A  70      72.379  35.326  28.513  1.00 16.58           O  
ATOM    482  CB  ASP A  70      71.490  33.074  30.209  1.00 16.14           C  
ATOM    483  CG  ASP A  70      70.805  31.742  30.234  1.00 18.67           C  
ATOM    484  OD1 ASP A  70      70.716  31.024  29.212  1.00 24.00           O  
ATOM    485  OD2 ASP A  70      70.344  31.375  31.312  1.00 24.56           O  
ATOM    486  N   ILE A  71      74.335  34.930  29.727  1.00 15.63           N  
ATOM    487  CA  ILE A  71      74.833  36.273  29.635  1.00 14.87           C  
ATOM    488  C   ILE A  71      75.401  36.460  28.232  1.00 15.24           C  
ATOM    489  O   ILE A  71      76.178  35.658  27.766  1.00 14.66           O  
ATOM    490  CB  ILE A  71      75.894  36.591  30.724  1.00 15.87           C  
ATOM    491  CG1 ILE A  71      75.281  36.546  32.130  1.00 13.05           C  
ATOM    492  CG2 ILE A  71      76.567  37.959  30.455  1.00 13.64           C  
ATOM    493  CD1 ILE A  71      76.328  36.317  33.195  1.00 12.31           C  
ATOM    494  N   ILE A  72      74.982  37.522  27.550  1.00 16.57           N  
ATOM    495  CA  ILE A  72      75.355  37.765  26.128  1.00 16.94           C  
ATOM    496  C   ILE A  72      76.232  39.035  25.970  1.00 17.68           C  
ATOM    497  O   ILE A  72      76.976  39.187  24.964  1.00 17.32           O  
ATOM    498  CB  ILE A  72      74.076  37.886  25.229  1.00 16.87           C  
ATOM    499  CG1 ILE A  72      73.127  38.929  25.788  1.00 17.18           C  
ATOM    500  CG2 ILE A  72      73.315  36.577  25.166  1.00 18.06           C  
ATOM    501  CD1 ILE A  72      73.070  40.204  24.937  1.00 17.89           C  
ATOM    502  N   LYS A  73      76.139  39.925  26.969  1.00 16.55           N  
ATOM    503  CA  LYS A  73      76.876  41.139  26.961  1.00 17.83           C  
ATOM    504  C   LYS A  73      77.341  41.491  28.378  1.00 18.19           C  
ATOM    505  O   LYS A  73      76.557  41.426  29.319  1.00 19.11           O  
ATOM    506  CB  LYS A  73      75.999  42.249  26.384  1.00 18.46           C  
ATOM    507  CG  LYS A  73      76.652  43.333  25.578  1.00 19.43           C  
ATOM    508  CD  LYS A  73      77.522  44.227  26.357  1.00 24.71           C  
ATOM    509  CE  LYS A  73      77.906  45.492  25.484  1.00 30.98           C  
ATOM    510  NZ  LYS A  73      79.305  46.026  25.751  1.00 29.28           N  
ATOM    511  N   MET A  74      78.615  41.865  28.525  1.00 17.63           N  
ATOM    512  CA  MET A  74      79.080  42.523  29.735  1.00 17.76           C  
ATOM    513  C   MET A  74      79.864  43.793  29.424  1.00 16.47           C  
ATOM    514  O   MET A  74      80.558  43.874  28.428  1.00 16.94           O  
ATOM    515  CB  MET A  74      79.946  41.573  30.508  1.00 18.58           C  
ATOM    516  CG  MET A  74      79.198  40.325  30.959  1.00 20.68           C  
ATOM    517  SD  MET A  74      79.900  39.652  32.412  1.00 22.18           S  
ATOM    518  CE  MET A  74      78.452  39.768  33.297  1.00 20.77           C  
ATOM    519  N   THR A  75      79.699  44.812  30.249  1.00 15.88           N  
ATOM    520  CA  THR A  75      80.554  45.976  30.220  1.00 15.23           C  
ATOM    521  C   THR A  75      81.380  45.990  31.523  1.00 15.38           C  
ATOM    522  O   THR A  75      80.817  45.914  32.597  1.00 14.90           O  
ATOM    523  CB  THR A  75      79.764  47.300  29.972  1.00 15.28           C  
ATOM    524  OG1 THR A  75      78.900  47.163  28.832  1.00 14.35           O  
ATOM    525  CG2 THR A  75      80.713  48.466  29.733  1.00 15.19           C  
ATOM    526  N   VAL A  76      82.711  46.051  31.404  1.00 15.21           N  
ATOM    527  CA  VAL A  76      83.600  46.017  32.556  1.00 15.50           C  
ATOM    528  C   VAL A  76      84.282  47.393  32.682  1.00 15.78           C  
ATOM    529  O   VAL A  76      85.178  47.723  31.879  1.00 17.63           O  
ATOM    530  CB  VAL A  76      84.661  44.845  32.446  1.00 16.08           C  
ATOM    531  CG1 VAL A  76      85.475  44.692  33.749  1.00 15.93           C  
ATOM    532  CG2 VAL A  76      83.974  43.449  32.102  1.00 14.45           C  
ATOM    533  N   PHE A  77      83.831  48.214  33.633  1.00 14.28           N  
ATOM    534  CA  PHE A  77      84.483  49.473  33.945  1.00 12.37           C  
ATOM    535  C   PHE A  77      85.538  49.219  35.051  1.00 13.02           C  
ATOM    536  O   PHE A  77      85.198  48.699  36.133  1.00 11.74           O  
ATOM    537  CB  PHE A  77      83.482  50.497  34.450  1.00 11.70           C  
ATOM    538  CG  PHE A  77      82.254  50.699  33.565  1.00 11.57           C  
ATOM    539  CD1 PHE A  77      82.299  51.555  32.460  1.00  8.01           C  
ATOM    540  CD2 PHE A  77      81.044  50.027  33.849  1.00 10.91           C  
ATOM    541  CE1 PHE A  77      81.175  51.774  31.667  1.00  9.37           C  
ATOM    542  CE2 PHE A  77      79.899  50.253  33.064  1.00 13.26           C  
ATOM    543  CZ  PHE A  77      79.963  51.145  31.963  1.00 10.57           C  
ATOM    544  N   ILE A  78      86.799  49.612  34.776  1.00 12.17           N  
ATOM    545  CA  ILE A  78      87.922  49.400  35.687  1.00 11.72           C  
ATOM    546  C   ILE A  78      88.713  50.663  35.965  1.00 11.72           C  
ATOM    547  O   ILE A  78      88.584  51.630  35.278  1.00 12.41           O  
ATOM    548  CB  ILE A  78      88.846  48.254  35.179  1.00 12.35           C  
ATOM    549  CG1 ILE A  78      89.817  48.733  34.034  1.00 12.43           C  
ATOM    550  CG2 ILE A  78      87.952  47.058  34.784  1.00  9.74           C  
ATOM    551  CD1 ILE A  78      90.833  47.661  33.490  1.00 12.39           C  
ATOM    552  N   THR A  79      89.503  50.674  37.014  1.00 13.03           N  
ATOM    553  CA  THR A  79      90.292  51.872  37.359  1.00 13.33           C  
ATOM    554  C   THR A  79      91.756  51.781  36.893  1.00 13.88           C  
ATOM    555  O   THR A  79      92.462  52.776  36.862  1.00 15.28           O  
ATOM    556  CB  THR A  79      90.178  52.255  38.874  1.00 12.58           C  
ATOM    557  OG1 THR A  79      90.468  51.115  39.690  1.00 16.28           O  
ATOM    558  CG2 THR A  79      88.780  52.734  39.218  1.00 11.70           C  
ATOM    559  N   ASP A  80      92.195  50.607  36.467  1.00 14.45           N  
ATOM    560  CA  ASP A  80      93.575  50.430  36.068  1.00 14.80           C  
ATOM    561  C   ASP A  80      93.772  49.242  35.104  1.00 14.66           C  
ATOM    562  O   ASP A  80      93.573  48.081  35.479  1.00 14.95           O  
ATOM    563  CB  ASP A  80      94.421  50.316  37.332  1.00 14.26           C  
ATOM    564  CG  ASP A  80      95.880  50.370  37.071  1.00 14.99           C  
ATOM    565  OD1 ASP A  80      96.275  50.489  35.872  1.00 12.58           O  
ATOM    566  OD2 ASP A  80      96.623  50.260  38.090  1.00  8.84           O  
ATOM    567  N   LEU A  81      94.125  49.568  33.847  1.00 15.78           N  
ATOM    568  CA  LEU A  81      94.434  48.552  32.766  1.00 15.56           C  
ATOM    569  C   LEU A  81      95.566  47.597  33.048  1.00 16.00           C  
ATOM    570  O   LEU A  81      95.565  46.471  32.560  1.00 17.13           O  
ATOM    571  CB  LEU A  81      94.579  49.162  31.370  1.00 14.48           C  
ATOM    572  CG  LEU A  81      93.188  49.426  30.741  1.00 15.03           C  
ATOM    573  CD1 LEU A  81      93.226  50.600  29.839  1.00 11.77           C  
ATOM    574  CD2 LEU A  81      92.560  48.202  30.009  1.00  9.99           C  
ATOM    575  N   ASN A  82      96.493  48.010  33.889  1.00 16.54           N  
ATOM    576  CA  ASN A  82      97.505  47.097  34.404  1.00 18.16           C  
ATOM    577  C   ASN A  82      96.922  45.965  35.224  1.00 17.61           C  
ATOM    578  O   ASN A  82      97.575  44.953  35.385  1.00 18.53           O  
ATOM    579  CB  ASN A  82      98.583  47.894  35.182  1.00 18.71           C  
ATOM    580  CG  ASN A  82      99.335  48.891  34.252  1.00 23.20           C  
ATOM    581  OD1 ASN A  82      99.592  48.571  33.076  1.00 27.46           O  
ATOM    582  ND2 ASN A  82      99.637  50.097  34.747  1.00 21.70           N  
ATOM    583  N   ASP A  83      95.697  46.122  35.735  1.00 18.59           N  
ATOM    584  CA  ASP A  83      94.987  45.026  36.422  1.00 19.19           C  
ATOM    585  C   ASP A  83      94.334  44.106  35.391  1.00 19.88           C  
ATOM    586  O   ASP A  83      93.734  43.135  35.743  1.00 20.70           O  
ATOM    587  CB  ASP A  83      93.876  45.529  37.334  1.00 18.66           C  
ATOM    588  CG  ASP A  83      94.373  46.413  38.434  1.00 19.39           C  
ATOM    589  OD1 ASP A  83      95.594  46.310  38.790  1.00 16.24           O  
ATOM    590  OD2 ASP A  83      93.515  47.205  38.918  1.00 13.34           O  
ATOM    591  N   PHE A  84      94.460  44.413  34.119  1.00 20.59           N  
ATOM    592  CA  PHE A  84      93.661  43.736  33.147  1.00 22.94           C  
ATOM    593  C   PHE A  84      93.871  42.237  32.986  1.00 21.77           C  
ATOM    594  O   PHE A  84      92.918  41.506  32.808  1.00 20.87           O  
ATOM    595  CB  PHE A  84      93.824  44.407  31.797  1.00 24.68           C  
ATOM    596  CG  PHE A  84      92.746  44.080  30.857  1.00 28.82           C  
ATOM    597  CD1 PHE A  84      91.412  44.222  31.243  1.00 32.72           C  
ATOM    598  CD2 PHE A  84      93.038  43.634  29.570  1.00 35.16           C  
ATOM    599  CE1 PHE A  84      90.378  43.949  30.358  1.00 34.31           C  
ATOM    600  CE2 PHE A  84      91.987  43.358  28.671  1.00 36.53           C  
ATOM    601  CZ  PHE A  84      90.661  43.527  29.075  1.00 33.64           C  
ATOM    602  N   ALA A  85      95.132  41.822  32.989  1.00 21.62           N  
ATOM    603  CA  ALA A  85      95.528  40.434  32.795  1.00 20.48           C  
ATOM    604  C   ALA A  85      95.050  39.531  33.961  1.00 20.09           C  
ATOM    605  O   ALA A  85      94.586  38.409  33.710  1.00 19.14           O  
ATOM    606  CB  ALA A  85      97.062  40.347  32.586  1.00 19.64           C  
ATOM    607  N   THR A  86      95.201  40.016  35.206  1.00 19.63           N  
ATOM    608  CA  THR A  86      94.551  39.430  36.399  1.00 20.20           C  
ATOM    609  C   THR A  86      93.018  39.428  36.280  1.00 20.55           C  
ATOM    610  O   THR A  86      92.413  38.427  36.554  1.00 21.95           O  
ATOM    611  CB  THR A  86      94.959  40.171  37.709  1.00 20.38           C  
ATOM    612  OG1 THR A  86      96.368  40.137  37.842  1.00 22.53           O  
ATOM    613  CG2 THR A  86      94.408  39.521  38.955  1.00 20.20           C  
ATOM    614  N   ILE A  87      92.377  40.526  35.892  1.00 21.05           N  
ATOM    615  CA  ILE A  87      90.913  40.520  35.688  1.00 22.04           C  
ATOM    616  C   ILE A  87      90.499  39.505  34.589  1.00 22.49           C  
ATOM    617  O   ILE A  87      89.578  38.715  34.772  1.00 22.32           O  
ATOM    618  CB  ILE A  87      90.341  41.938  35.398  1.00 22.03           C  
ATOM    619  CG1 ILE A  87      90.460  42.801  36.646  1.00 22.62           C  
ATOM    620  CG2 ILE A  87      88.842  41.883  34.983  1.00 21.73           C  
ATOM    621  CD1 ILE A  87      90.429  44.263  36.353  1.00 23.35           C  
ATOM    622  N   ASN A  88      91.209  39.517  33.465  1.00 23.25           N  
ATOM    623  CA  ASN A  88      90.943  38.578  32.393  1.00 23.46           C  
ATOM    624  C   ASN A  88      90.999  37.100  32.838  1.00 22.83           C  
ATOM    625  O   ASN A  88      90.181  36.330  32.410  1.00 23.61           O  
ATOM    626  CB  ASN A  88      91.855  38.856  31.178  1.00 23.27           C  
ATOM    627  CG  ASN A  88      91.132  39.584  30.042  1.00 25.17           C  
ATOM    628  OD1 ASN A  88      90.122  39.135  29.555  1.00 29.90           O  
ATOM    629  ND2 ASN A  88      91.673  40.705  29.603  1.00 31.19           N  
ATOM    630  N   GLU A  89      91.975  36.737  33.685  1.00 23.00           N  
ATOM    631  CA  GLU A  89      92.179  35.400  34.203  1.00 22.90           C  
ATOM    632  C   GLU A  89      91.004  34.917  35.091  1.00 22.88           C  
ATOM    633  O   GLU A  89      90.464  33.821  34.922  1.00 23.42           O  
ATOM    634  CB  GLU A  89      93.518  35.322  34.936  1.00 23.26           C  
ATOM    635  N   VAL A  90      90.570  35.773  35.990  1.00 22.34           N  
ATOM    636  CA  VAL A  90      89.445  35.486  36.827  1.00 21.59           C  
ATOM    637  C   VAL A  90      88.156  35.296  36.014  1.00 22.17           C  
ATOM    638  O   VAL A  90      87.366  34.375  36.272  1.00 21.91           O  
ATOM    639  CB  VAL A  90      89.283  36.624  37.795  1.00 21.25           C  
ATOM    640  CG1 VAL A  90      88.002  36.452  38.647  1.00 21.62           C  
ATOM    641  CG2 VAL A  90      90.535  36.711  38.665  1.00 20.97           C  
ATOM    642  N   TYR A  91      87.977  36.198  35.046  1.00 22.21           N  
ATOM    643  CA  TYR A  91      86.788  36.336  34.199  1.00 21.36           C  
ATOM    644  C   TYR A  91      86.700  35.164  33.222  1.00 21.52           C  
ATOM    645  O   TYR A  91      85.597  34.614  33.003  1.00 20.58           O  
ATOM    646  CB  TYR A  91      86.877  37.687  33.467  1.00 20.31           C  
ATOM    647  CG  TYR A  91      85.777  38.052  32.515  1.00 18.54           C  
ATOM    648  CD1 TYR A  91      85.580  37.345  31.317  1.00 20.34           C  
ATOM    649  CD2 TYR A  91      84.971  39.178  32.764  1.00 17.90           C  
ATOM    650  CE1 TYR A  91      84.550  37.717  30.404  1.00 20.67           C  
ATOM    651  CE2 TYR A  91      83.964  39.572  31.871  1.00 17.64           C  
ATOM    652  CZ  TYR A  91      83.744  38.836  30.707  1.00 21.19           C  
ATOM    653  OH  TYR A  91      82.754  39.243  29.834  1.00 20.77           O  
ATOM    654  N   LYS A  92      87.852  34.799  32.630  1.00 21.06           N  
ATOM    655  CA  LYS A  92      87.950  33.577  31.837  1.00 21.61           C  
ATOM    656  C   LYS A  92      87.606  32.319  32.650  1.00 22.09           C  
ATOM    657  O   LYS A  92      86.783  31.544  32.214  1.00 21.78           O  
ATOM    658  CB  LYS A  92      89.314  33.454  31.177  1.00 21.89           C  
ATOM    659  CG  LYS A  92      89.431  32.224  30.273  1.00 23.14           C  
ATOM    660  CD  LYS A  92      90.656  32.270  29.388  1.00 25.27           C  
ATOM    661  CE  LYS A  92      91.302  30.911  29.330  1.00 30.01           C  
ATOM    662  NZ  LYS A  92      90.429  29.896  28.663  1.00 34.55           N  
ATOM    663  N   GLN A  93      88.222  32.148  33.829  1.00 23.46           N  
ATOM    664  CA  GLN A  93      87.937  31.022  34.746  1.00 26.41           C  
ATOM    665  C   GLN A  93      86.444  30.957  35.129  1.00 23.77           C  
ATOM    666  O   GLN A  93      85.850  29.886  35.115  1.00 24.87           O  
ATOM    667  CB  GLN A  93      88.795  31.077  36.042  1.00 25.79           C  
ATOM    668  CG  GLN A  93      90.203  30.499  35.963  1.00 31.73           C  
ATOM    669  CD  GLN A  93      91.002  30.583  37.342  1.00 34.82           C  
ATOM    670  OE1 GLN A  93      92.064  31.275  37.442  1.00 40.95           O  
ATOM    671  NE2 GLN A  93      90.477  29.879  38.397  1.00 39.46           N  
ATOM    672  N   PHE A  94      85.863  32.096  35.464  1.00 21.97           N  
ATOM    673  CA  PHE A  94      84.442  32.233  35.803  1.00 20.68           C  
ATOM    674  C   PHE A  94      83.493  31.628  34.768  1.00 20.83           C  
ATOM    675  O   PHE A  94      82.595  30.836  35.138  1.00 21.07           O  
ATOM    676  CB  PHE A  94      84.107  33.713  36.055  1.00 19.34           C  
ATOM    677  CG  PHE A  94      82.692  33.967  36.403  1.00 18.59           C  
ATOM    678  CD1 PHE A  94      82.234  33.726  37.712  1.00 21.45           C  
ATOM    679  CD2 PHE A  94      81.810  34.482  35.456  1.00 17.92           C  
ATOM    680  CE1 PHE A  94      80.920  33.966  38.083  1.00 18.99           C  
ATOM    681  CE2 PHE A  94      80.467  34.719  35.791  1.00 21.74           C  
ATOM    682  CZ  PHE A  94      80.022  34.446  37.134  1.00 22.45           C  
ATOM    683  N   PHE A  95      83.668  32.025  33.496  1.00 20.45           N  
ATOM    684  CA  PHE A  95      82.863  31.542  32.397  1.00 20.28           C  
ATOM    685  C   PHE A  95      83.196  30.108  32.068  1.00 21.90           C  
ATOM    686  O   PHE A  95      82.283  29.321  31.799  1.00 22.17           O  
ATOM    687  CB  PHE A  95      82.966  32.440  31.151  1.00 19.76           C  
ATOM    688  CG  PHE A  95      82.140  33.676  31.263  1.00 19.49           C  
ATOM    689  CD1 PHE A  95      80.767  33.624  31.044  1.00 19.56           C  
ATOM    690  CD2 PHE A  95      82.702  34.861  31.707  1.00 18.10           C  
ATOM    691  CE1 PHE A  95      79.958  34.761  31.202  1.00 19.16           C  
ATOM    692  CE2 PHE A  95      81.926  35.976  31.881  1.00 21.11           C  
ATOM    693  CZ  PHE A  95      80.535  35.930  31.624  1.00 19.21           C  
ATOM    694  N   ASP A  96      84.494  29.774  32.083  1.00 23.63           N  
ATOM    695  CA  ASP A  96      84.957  28.397  31.853  1.00 25.08           C  
ATOM    696  C   ASP A  96      84.384  27.425  32.881  1.00 25.68           C  
ATOM    697  O   ASP A  96      84.031  26.297  32.488  1.00 26.51           O  
ATOM    698  CB  ASP A  96      86.504  28.268  31.842  1.00 25.09           C  
ATOM    699  CG  ASP A  96      87.144  28.794  30.553  1.00 24.19           C  
ATOM    700  OD1 ASP A  96      86.452  29.266  29.655  1.00 22.13           O  
ATOM    701  OD2 ASP A  96      88.366  28.752  30.445  1.00 25.87           O  
ATOM    702  N   GLU A  97      84.322  27.842  34.156  1.00 25.12           N  
ATOM    703  CA  GLU A  97      83.728  27.034  35.237  1.00 26.52           C  
ATOM    704  C   GLU A  97      82.282  26.642  35.015  1.00 26.88           C  
ATOM    705  O   GLU A  97      81.827  25.660  35.593  1.00 27.58           O  
ATOM    706  CB  GLU A  97      83.621  27.855  36.495  1.00 27.32           C  
ATOM    707  CG  GLU A  97      84.542  27.497  37.593  1.00 32.83           C  
ATOM    708  CD  GLU A  97      84.520  28.548  38.685  1.00 37.32           C  
ATOM    709  OE1 GLU A  97      83.422  28.859  39.193  1.00 39.06           O  
ATOM    710  OE2 GLU A  97      85.607  29.070  39.014  1.00 39.79           O  
ATOM    711  N   HIS A  98      81.531  27.469  34.292  1.00 26.15           N  
ATOM    712  CA  HIS A  98      80.094  27.333  34.237  1.00 26.78           C  
ATOM    713  C   HIS A  98      79.818  26.850  32.875  1.00 28.11           C  
ATOM    714  O   HIS A  98      78.702  27.021  32.364  1.00 28.93           O  
ATOM    715  CB  HIS A  98      79.375  28.682  34.458  1.00 27.34           C  
ATOM    716  CG  HIS A  98      79.432  29.157  35.872  1.00 24.86           C  
ATOM    717  ND1 HIS A  98      80.439  29.969  36.337  1.00 27.06           N  
ATOM    718  CD2 HIS A  98      78.675  28.840  36.946  1.00 24.51           C  
ATOM    719  CE1 HIS A  98      80.267  30.176  37.636  1.00 30.22           C  
ATOM    720  NE2 HIS A  98      79.201  29.498  38.027  1.00 28.07           N  
ATOM    721  N   GLN A  99      80.872  26.302  32.279  1.00 28.16           N  
ATOM    722  CA  GLN A  99      80.877  25.831  30.921  1.00 29.76           C  
ATOM    723  C   GLN A  99      80.131  26.800  29.999  1.00 28.66           C  
ATOM    724  O   GLN A  99      79.324  26.388  29.166  1.00 29.94           O  
ATOM    725  CB  GLN A  99      80.360  24.382  30.866  1.00 29.34           C  
ATOM    726  CG  GLN A  99      81.251  23.355  31.689  1.00 32.79           C  
ATOM    727  CD  GLN A  99      80.842  21.890  31.436  1.00 33.96           C  
ATOM    728  OE1 GLN A  99      79.673  21.511  31.615  1.00 38.74           O  
ATOM    729  NE2 GLN A  99      81.792  21.078  30.966  1.00 37.76           N  
ATOM    730  N   ALA A 100      80.426  28.095  30.148  1.00 28.24           N  
ATOM    731  CA  ALA A 100      79.783  29.179  29.392  1.00 26.13           C  
ATOM    732  C   ALA A 100      80.623  29.740  28.245  1.00 25.67           C  
ATOM    733  O   ALA A 100      81.823  30.042  28.377  1.00 26.13           O  
ATOM    734  CB  ALA A 100      79.370  30.276  30.336  1.00 25.29           C  
ATOM    735  N   THR A 101      79.978  29.854  27.098  1.00 25.40           N  
ATOM    736  CA  THR A 101      80.437  30.667  25.961  1.00 24.44           C  
ATOM    737  C   THR A 101      80.612  32.105  26.432  1.00 23.24           C  
ATOM    738  O   THR A 101      79.721  32.674  27.128  1.00 22.83           O  
ATOM    739  CB  THR A 101      79.299  30.680  24.896  1.00 25.41           C  
ATOM    740  OG1 THR A 101      79.065  29.344  24.452  1.00 28.05           O  
ATOM    741  CG2 THR A 101      79.629  31.570  23.687  1.00 24.78           C  
ATOM    742  N   TYR A 102      81.733  32.715  26.034  1.00 21.35           N  
ATOM    743  CA  TYR A 102      82.026  34.065  26.465  1.00 18.67           C  
ATOM    744  C   TYR A 102      81.081  35.036  25.771  1.00 17.68           C  
ATOM    745  O   TYR A 102      80.749  34.829  24.600  1.00 18.41           O  
ATOM    746  CB  TYR A 102      83.470  34.435  26.198  1.00 18.66           C  
ATOM    747  CG  TYR A 102      84.487  33.415  26.626  1.00 17.99           C  
ATOM    748  CD1 TYR A 102      84.618  33.039  27.949  1.00 18.32           C  
ATOM    749  CD2 TYR A 102      85.352  32.846  25.699  1.00 19.55           C  
ATOM    750  CE1 TYR A 102      85.562  32.114  28.339  1.00 16.21           C  
ATOM    751  CE2 TYR A 102      86.300  31.910  26.079  1.00 16.19           C  
ATOM    752  CZ  TYR A 102      86.377  31.537  27.386  1.00 17.01           C  
ATOM    753  OH  TYR A 102      87.299  30.592  27.759  1.00 18.10           O  
ATOM    754  N   PRO A 103      80.601  36.058  26.507  1.00 15.89           N  
ATOM    755  CA  PRO A 103      79.789  37.075  25.891  1.00 14.30           C  
ATOM    756  C   PRO A 103      80.579  38.157  25.122  1.00 13.98           C  
ATOM    757  O   PRO A 103      81.814  38.231  25.187  1.00 13.43           O  
ATOM    758  CB  PRO A 103      79.036  37.713  27.099  1.00 13.92           C  
ATOM    759  CG  PRO A 103      79.745  37.259  28.359  1.00 14.31           C  
ATOM    760  CD  PRO A 103      80.812  36.290  27.963  1.00 15.52           C  
ATOM    761  N   THR A 104      79.843  39.042  24.443  1.00 14.45           N  
ATOM    762  CA  THR A 104      80.447  40.251  23.908  1.00 14.62           C  
ATOM    763  C   THR A 104      80.830  41.022  25.166  1.00 14.58           C  
ATOM    764  O   THR A 104      80.191  40.848  26.222  1.00 15.16           O  
ATOM    765  CB  THR A 104      79.476  41.078  23.020  1.00 14.73           C  
ATOM    766  OG1 THR A 104      78.324  41.404  23.787  1.00 16.40           O  
ATOM    767  CG2 THR A 104      78.993  40.292  21.829  1.00 12.63           C  
ATOM    768  N   ARG A 105      81.868  41.848  25.067  1.00 13.58           N  
ATOM    769  CA  ARG A 105      82.362  42.583  26.196  1.00 14.07           C  
ATOM    770  C   ARG A 105      82.950  43.939  25.717  1.00 14.61           C  
ATOM    771  O   ARG A 105      83.521  44.010  24.641  1.00 14.38           O  
ATOM    772  CB  ARG A 105      83.428  41.758  26.911  1.00 13.39           C  
ATOM    773  CG  ARG A 105      83.781  42.351  28.231  1.00 16.74           C  
ATOM    774  CD  ARG A 105      84.916  41.709  28.937  1.00 19.54           C  
ATOM    775  NE  ARG A 105      86.207  41.597  28.272  1.00 21.23           N  
ATOM    776  CZ  ARG A 105      87.204  40.804  28.746  1.00 26.67           C  
ATOM    777  NH1 ARG A 105      87.041  40.084  29.870  1.00 23.30           N  
ATOM    778  NH2 ARG A 105      88.383  40.711  28.116  1.00 25.79           N  
ATOM    779  N   SER A 106      82.780  44.988  26.520  1.00 14.83           N  
ATOM    780  CA  SER A 106      83.540  46.248  26.415  1.00 15.77           C  
ATOM    781  C   SER A 106      84.278  46.458  27.736  1.00 16.32           C  
ATOM    782  O   SER A 106      83.721  46.227  28.817  1.00 16.59           O  
ATOM    783  CB  SER A 106      82.598  47.454  26.179  1.00 15.16           C  
ATOM    784  OG  SER A 106      82.126  47.498  24.843  1.00 15.95           O  
ATOM    785  N   CYS A 107      85.516  46.905  27.638  1.00 18.02           N  
ATOM    786  CA  CYS A 107      86.388  47.155  28.791  1.00 18.14           C  
ATOM    787  C   CYS A 107      87.114  48.506  28.633  1.00 17.68           C  
ATOM    788  O   CYS A 107      87.833  48.767  27.647  1.00 16.68           O  
ATOM    789  CB  CYS A 107      87.399  46.008  29.007  1.00 18.27           C  
ATOM    790  SG  CYS A 107      88.341  46.154  30.616  1.00 23.06           S  
ATOM    791  N   VAL A 108      86.876  49.384  29.604  1.00 16.83           N  
ATOM    792  CA  VAL A 108      87.423  50.720  29.557  1.00 14.76           C  
ATOM    793  C   VAL A 108      87.906  51.107  30.906  1.00 14.16           C  
ATOM    794  O   VAL A 108      87.294  50.721  31.925  1.00 15.03           O  
ATOM    795  CB  VAL A 108      86.362  51.788  29.080  1.00 15.06           C  
ATOM    796  CG1 VAL A 108      85.799  51.394  27.743  1.00 13.21           C  
ATOM    797  CG2 VAL A 108      85.270  52.018  30.138  1.00 10.35           C  
ATOM    798  N   GLN A 109      88.979  51.900  30.933  1.00 12.95           N  
ATOM    799  CA  GLN A 109      89.464  52.433  32.212  1.00 11.63           C  
ATOM    800  C   GLN A 109      88.841  53.780  32.531  1.00 11.50           C  
ATOM    801  O   GLN A 109      89.054  54.766  31.829  1.00 12.88           O  
ATOM    802  CB  GLN A 109      90.989  52.497  32.261  1.00 10.67           C  
ATOM    803  CG  GLN A 109      91.558  53.012  33.580  1.00  7.41           C  
ATOM    804  CD  GLN A 109      93.023  53.337  33.497  1.00  8.68           C  
ATOM    805  OE1 GLN A 109      93.847  52.509  33.044  1.00 11.67           O  
ATOM    806  NE2 GLN A 109      93.382  54.528  33.961  1.00  8.63           N  
ATOM    807  N   VAL A 110      88.101  53.848  33.617  1.00 11.58           N  
ATOM    808  CA  VAL A 110      87.405  55.105  33.983  1.00 11.60           C  
ATOM    809  C   VAL A 110      88.272  55.820  35.008  1.00 12.02           C  
ATOM    810  O   VAL A 110      89.329  55.288  35.381  1.00 13.41           O  
ATOM    811  CB  VAL A 110      85.943  54.834  34.503  1.00 10.80           C  
ATOM    812  CG1 VAL A 110      85.123  54.208  33.441  1.00  8.78           C  
ATOM    813  CG2 VAL A 110      85.975  53.922  35.687  1.00  9.59           C  
ATOM    814  N   ALA A 111      87.836  56.978  35.489  1.00 12.08           N  
ATOM    815  CA  ALA A 111      88.571  57.729  36.514  1.00 12.52           C  
ATOM    816  C   ALA A 111      88.442  57.147  37.940  1.00 13.65           C  
ATOM    817  O   ALA A 111      89.442  57.065  38.705  1.00 14.14           O  
ATOM    818  CB  ALA A 111      88.210  59.270  36.464  1.00 11.73           C  
ATOM    819  N   ARG A 112      87.232  56.685  38.271  1.00 13.64           N  
ATOM    820  CA  ARG A 112      86.889  56.325  39.652  1.00 12.54           C  
ATOM    821  C   ARG A 112      85.499  55.669  39.685  1.00 12.52           C  
ATOM    822  O   ARG A 112      84.691  55.939  38.824  1.00 13.62           O  
ATOM    823  CB  ARG A 112      86.972  57.565  40.512  1.00 10.88           C  
ATOM    824  CG  ARG A 112      86.882  57.333  41.980  1.00 13.05           C  
ATOM    825  CD  ARG A 112      87.359  58.589  42.709  1.00 15.23           C  
ATOM    826  NE  ARG A 112      87.475  58.352  44.144  1.00 15.67           N  
ATOM    827  CZ  ARG A 112      87.282  59.277  45.076  1.00 15.39           C  
ATOM    828  NH1 ARG A 112      86.935  60.522  44.737  1.00 12.17           N  
ATOM    829  NH2 ARG A 112      87.406  58.931  46.353  1.00 14.35           N  
ATOM    830  N   LEU A 113      85.246  54.809  40.674  1.00 12.56           N  
ATOM    831  CA  LEU A 113      84.009  54.056  40.774  1.00 13.15           C  
ATOM    832  C   LEU A 113      83.362  54.304  42.141  1.00 14.02           C  
ATOM    833  O   LEU A 113      84.028  54.764  43.036  1.00 13.49           O  
ATOM    834  CB  LEU A 113      84.232  52.545  40.533  1.00 12.53           C  
ATOM    835  CG  LEU A 113      84.647  52.211  39.104  1.00 11.45           C  
ATOM    836  CD1 LEU A 113      85.209  50.868  39.058  1.00  8.35           C  
ATOM    837  CD2 LEU A 113      83.502  52.413  38.090  1.00  9.60           C  
ATOM    838  N   PRO A 114      82.028  54.085  42.257  1.00 14.37           N  
ATOM    839  CA  PRO A 114      81.390  54.143  43.559  1.00 14.82           C  
ATOM    840  C   PRO A 114      82.077  53.238  44.553  1.00 14.93           C  
ATOM    841  O   PRO A 114      82.333  52.071  44.244  1.00 16.44           O  
ATOM    842  CB  PRO A 114      79.931  53.645  43.260  1.00 15.61           C  
ATOM    843  CG  PRO A 114      79.698  54.127  41.877  1.00 15.07           C  
ATOM    844  CD  PRO A 114      81.034  53.903  41.174  1.00 13.37           C  
ATOM    845  N   LYS A 115      82.344  53.780  45.734  1.00 14.56           N  
ATOM    846  CA  LYS A 115      82.927  53.070  46.865  1.00 14.47           C  
ATOM    847  C   LYS A 115      84.412  52.753  46.664  1.00 14.35           C  
ATOM    848  O   LYS A 115      84.995  51.896  47.383  1.00 14.61           O  
ATOM    849  CB  LYS A 115      82.126  51.810  47.233  1.00 14.80           C  
ATOM    850  CG  LYS A 115      80.662  52.005  47.591  1.00 17.94           C  
ATOM    851  CD  LYS A 115      80.391  51.785  49.066  1.00 25.94           C  
ATOM    852  CE  LYS A 115      79.903  50.338  49.272  1.00 28.76           C  
ATOM    853  NZ  LYS A 115      79.215  50.000  50.600  1.00 32.82           N  
ATOM    854  N   ASP A 116      85.026  53.446  45.709  1.00 12.74           N  
ATOM    855  CA  ASP A 116      86.467  53.289  45.403  1.00 12.88           C  
ATOM    856  C   ASP A 116      86.891  51.865  45.047  1.00 11.88           C  
ATOM    857  O   ASP A 116      88.010  51.438  45.319  1.00 10.86           O  
ATOM    858  CB  ASP A 116      87.369  53.947  46.466  1.00 13.82           C  
ATOM    859  CG  ASP A 116      87.454  55.486  46.299  1.00 15.11           C  
ATOM    860  OD1 ASP A 116      88.123  55.949  45.358  1.00 17.12           O  
ATOM    861  OD2 ASP A 116      86.799  56.232  47.056  1.00 14.57           O  
ATOM    862  N   VAL A 117      85.985  51.149  44.367  1.00 11.91           N  
ATOM    863  CA  VAL A 117      86.261  49.792  43.884  1.00 11.94           C  
ATOM    864  C   VAL A 117      87.024  49.807  42.571  1.00 11.88           C  
ATOM    865  O   VAL A 117      87.005  50.794  41.859  1.00 13.50           O  
ATOM    866  CB  VAL A 117      84.954  48.970  43.758  1.00 12.52           C  
ATOM    867  CG1 VAL A 117      84.295  48.755  45.187  1.00 11.73           C  
ATOM    868  CG2 VAL A 117      84.018  49.600  42.792  1.00 10.57           C  
ATOM    869  N   LYS A 118      87.683  48.716  42.236  1.00 12.34           N  
ATOM    870  CA  LYS A 118      88.563  48.661  41.085  1.00 12.52           C  
ATOM    871  C   LYS A 118      87.871  48.285  39.774  1.00 13.73           C  
ATOM    872  O   LYS A 118      88.392  48.552  38.678  1.00 13.94           O  
ATOM    873  CB  LYS A 118      89.706  47.697  41.343  1.00 12.42           C  
ATOM    874  CG  LYS A 118      90.617  48.143  42.473  1.00  9.35           C  
ATOM    875  CD  LYS A 118      91.669  47.049  42.678  1.00  8.41           C  
ATOM    876  CE  LYS A 118      92.437  47.219  43.936  1.00  7.07           C  
ATOM    877  NZ  LYS A 118      93.393  48.288  43.650  1.00  8.20           N  
ATOM    878  N   LEU A 119      86.719  47.645  39.892  1.00 14.78           N  
ATOM    879  CA  LEU A 119      85.901  47.342  38.743  1.00 15.43           C  
ATOM    880  C   LEU A 119      84.406  47.399  39.067  1.00 15.62           C  
ATOM    881  O   LEU A 119      83.975  47.306  40.218  1.00 15.61           O  
ATOM    882  CB  LEU A 119      86.308  45.982  38.141  1.00 16.01           C  
ATOM    883  CG  LEU A 119      85.870  44.634  38.738  1.00 16.73           C  
ATOM    884  CD1 LEU A 119      86.440  43.567  37.870  1.00 14.07           C  
ATOM    885  CD2 LEU A 119      86.377  44.487  40.149  1.00 14.60           C  
ATOM    886  N   GLU A 120      83.627  47.586  38.014  1.00 16.78           N  
ATOM    887  CA  GLU A 120      82.137  47.585  38.057  1.00 16.91           C  
ATOM    888  C   GLU A 120      81.666  46.907  36.773  1.00 16.52           C  
ATOM    889  O   GLU A 120      82.023  47.367  35.690  1.00 17.23           O  
ATOM    890  CB  GLU A 120      81.560  49.020  38.141  1.00 15.11           C  
ATOM    891  CG  GLU A 120      80.056  48.999  38.137  1.00 15.73           C  
ATOM    892  CD  GLU A 120      79.446  50.353  38.206  1.00 17.34           C  
ATOM    893  OE1 GLU A 120      80.115  51.245  38.810  1.00 19.12           O  
ATOM    894  OE2 GLU A 120      78.327  50.534  37.635  1.00 14.57           O  
ATOM    895  N   ILE A 121      80.857  45.849  36.905  1.00 16.94           N  
ATOM    896  CA  ILE A 121      80.403  44.988  35.767  1.00 15.88           C  
ATOM    897  C   ILE A 121      78.898  44.974  35.556  1.00 16.41           C  
ATOM    898  O   ILE A 121      78.187  44.510  36.415  1.00 17.96           O  
ATOM    899  CB  ILE A 121      80.854  43.498  35.947  1.00 15.30           C  
ATOM    900  CG1 ILE A 121      82.395  43.417  36.103  1.00 13.99           C  
ATOM    901  CG2 ILE A 121      80.412  42.665  34.755  1.00 15.50           C  
ATOM    902  CD1 ILE A 121      82.992  42.005  36.387  1.00 15.06           C  
ATOM    903  N   GLU A 122      78.400  45.441  34.418  1.00 16.31           N  
ATOM    904  CA  GLU A 122      77.032  45.159  34.056  1.00 15.80           C  
ATOM    905  C   GLU A 122      76.868  44.056  33.022  1.00 15.71           C  
ATOM    906  O   GLU A 122      77.620  43.996  32.064  1.00 15.43           O  
ATOM    907  CB  GLU A 122      76.344  46.416  33.567  1.00 16.26           C  
ATOM    908  CG  GLU A 122      77.122  47.153  32.522  1.00 18.92           C  
ATOM    909  CD  GLU A 122      76.317  48.270  31.899  1.00 19.76           C  
ATOM    910  OE1 GLU A 122      75.829  49.147  32.607  1.00 18.58           O  
ATOM    911  OE2 GLU A 122      76.184  48.276  30.685  1.00 24.56           O  
ATOM    912  N   ALA A 123      75.815  43.237  33.192  1.00 15.60           N  
ATOM    913  CA  ALA A 123      75.505  42.110  32.331  1.00 15.12           C  
ATOM    914  C   ALA A 123      74.126  42.257  31.679  1.00 16.11           C  
ATOM    915  O   ALA A 123      73.226  42.935  32.215  1.00 15.15           O  
ATOM    916  CB  ALA A 123      75.589  40.814  33.132  1.00 15.26           C  
ATOM    917  N   ILE A 124      73.995  41.680  30.485  1.00 16.37           N  
ATOM    918  CA  ILE A 124      72.699  41.494  29.837  1.00 16.67           C  
ATOM    919  C   ILE A 124      72.621  39.999  29.507  1.00 17.86           C  
ATOM    920  O   ILE A 124      73.592  39.414  29.012  1.00 17.71           O  
ATOM    921  CB  ILE A 124      72.530  42.343  28.553  1.00 17.40           C  
ATOM    922  CG1 ILE A 124      72.770  43.850  28.818  1.00 18.86           C  
ATOM    923  CG2 ILE A 124      71.136  42.192  27.978  1.00 14.84           C  
ATOM    924  CD1 ILE A 124      73.098  44.708  27.548  1.00 13.85           C  
ATOM    925  N   ALA A 125      71.492  39.382  29.861  1.00 19.31           N  
ATOM    926  CA  ALA A 125      71.180  37.965  29.575  1.00 20.54           C  
ATOM    927  C   ALA A 125      69.857  37.823  28.766  1.00 22.36           C  
ATOM    928  O   ALA A 125      68.943  38.654  28.883  1.00 21.58           O  
ATOM    929  CB  ALA A 125      71.138  37.131  30.876  1.00 18.32           C  
ATOM    930  N   VAL A 126      69.781  36.779  27.938  1.00 25.51           N  
ATOM    931  CA  VAL A 126      68.520  36.395  27.290  1.00 28.44           C  
ATOM    932  C   VAL A 126      67.986  35.073  27.852  1.00 30.03           C  
ATOM    933  O   VAL A 126      68.762  34.230  28.306  1.00 30.08           O  
ATOM    934  CB  VAL A 126      68.677  36.295  25.771  1.00 27.91           C  
ATOM    935  CG1 VAL A 126      68.610  37.686  25.167  1.00 29.33           C  
ATOM    936  CG2 VAL A 126      69.997  35.603  25.444  1.00 28.18           C  
ATOM    937  N   ARG A 127      66.666  34.907  27.809  1.00 33.29           N  
ATOM    938  CA  ARG A 127      65.988  33.679  28.266  1.00 35.63           C  
ATOM    939  C   ARG A 127      66.334  32.420  27.437  1.00 38.21           C  
ATOM    940  O   ARG A 127      66.952  31.478  27.989  1.00 39.34           O  
ATOM    941  CB  ARG A 127      64.481  33.917  28.379  1.00 35.93           C  
ATOM    942  CG  ARG A 127      63.621  32.826  29.088  1.00 34.41           C  
ATOM    943  CD  ARG A 127      63.615  32.928  30.594  1.00 34.19           C  
ATOM    944  NE  ARG A 127      63.240  34.257  31.033  1.00 35.21           N  
ATOM    945  CZ  ARG A 127      63.393  34.722  32.265  1.00 35.71           C  
ATOM    946  NH1 ARG A 127      63.909  33.967  33.218  1.00 35.06           N  
ATOM    947  NH2 ARG A 127      63.032  35.966  32.533  1.00 37.74           N  
ATOM    948  N   SER A 128      66.013  32.348  26.140  1.00 39.91           N  
ATOM    949  CA  SER A 128      66.151  30.989  25.519  1.00 42.14           C  
ATOM    950  C   SER A 128      67.578  30.501  25.234  1.00 42.86           C  
ATOM    951  O   SER A 128      68.511  31.305  25.118  1.00 44.89           O  
ATOM    952  CB  SER A 128      65.239  30.786  24.290  1.00 42.92           C  
ATOM    953  OG  SER A 128      64.072  30.068  24.656  1.00 43.54           O  
TER     954      SER A 128                                                      
END
MOLECULE T0423.pdb
ATOM  12910  N   MET     1      70.981  21.031  37.362  1.00 36.76           N  
ATOM  12911  CA  MET     1      71.905  21.930  36.664  1.00 38.87           C  
ATOM  12912  C   MET     1      72.311  23.119  37.519  1.00 35.58           C  
ATOM  12913  O   MET     1      73.455  23.538  37.475  1.00 34.69           O  
ATOM  12914  CB  MET     1      71.283  22.461  35.383  1.00 39.21           C  
ATOM  12915  CG  MET     1      71.504  21.613  34.171  1.00 44.40           C  
ATOM  12916  SD  MET     1      70.806  22.501  32.558  1.00 57.84          SE  
ATOM  12917  CE  MET     1      71.792  24.214  32.666  1.00 53.65           C  
ATOM  12918  N   SER     2      71.368  23.671  38.275  1.00 34.19           N  
ATOM  12919  CA  SER     2      71.660  24.824  39.146  1.00 33.25           C  
ATOM  12920  C   SER     2      72.590  24.410  40.267  1.00 32.21           C  
ATOM  12921  O   SER     2      73.492  25.167  40.644  1.00 30.89           O  
ATOM  12922  CB  SER     2      70.389  25.426  39.738  1.00 32.90           C  
ATOM  12923  OG  SER     2      69.633  26.060  38.749  1.00 33.07           O  
ATOM  12924  N   ASP     3      72.374  23.203  40.811  1.00 30.62           N  
ATOM  12925  CA  ASP     3      73.242  22.687  41.862  1.00 30.33           C  
ATOM  12926  C   ASP     3      74.682  22.556  41.347  1.00 28.94           C  
ATOM  12927  O   ASP     3      75.638  22.825  42.091  1.00 29.92           O  
ATOM  12928  CB  ASP     3      72.774  21.291  42.370  1.00 30.67           C  
ATOM  12929  CG  ASP     3      71.492  21.328  43.198  1.00 32.38           C  
ATOM  12930  OD1 ASP     3      71.019  22.402  43.615  1.00 35.40           O  
ATOM  12931  OD2 ASP     3      70.942  20.230  43.448  1.00 35.26           O  
ATOM  12932  N   VAL     4      74.823  22.096  40.101  1.00 27.71           N  
ATOM  12933  CA  VAL     4      76.127  21.864  39.482  1.00 27.34           C  
ATOM  12934  C   VAL     4      76.846  23.203  39.304  1.00 26.70           C  
ATOM  12935  O   VAL     4      78.035  23.311  39.582  1.00 25.89           O  
ATOM  12936  CB  VAL     4      75.994  21.175  38.115  1.00 27.32           C  
ATOM  12937  CG1 VAL     4      77.261  21.282  37.304  1.00 28.31           C  
ATOM  12938  CG2 VAL     4      75.606  19.678  38.300  1.00 27.74           C  
ATOM  12939  N   ILE     5      76.114  24.200  38.836  1.00 26.35           N  
ATOM  12940  CA  ILE     5      76.694  25.575  38.675  1.00 26.66           C  
ATOM  12941  C   ILE     5      77.167  26.134  40.031  1.00 26.86           C  
ATOM  12942  O   ILE     5      78.302  26.546  40.179  1.00 27.38           O  
ATOM  12943  CB  ILE     5      75.680  26.562  37.999  1.00 26.48           C  
ATOM  12944  CG1 ILE     5      75.346  26.128  36.566  1.00 24.54           C  
ATOM  12945  CG2 ILE     5      76.257  28.001  37.934  1.00 26.07           C  
ATOM  12946  CD1 ILE     5      74.048  26.748  35.988  1.00 26.63           C  
ATOM  12947  N   GLU     6      76.308  26.117  41.034  1.00 27.87           N  
ATOM  12948  CA  GLU     6      76.688  26.606  42.353  1.00 28.66           C  
ATOM  12949  C   GLU     6      77.785  25.768  43.000  1.00 28.15           C  
ATOM  12950  O   GLU     6      78.644  26.303  43.709  1.00 27.19           O  
ATOM  12951  CB  GLU     6      75.481  26.702  43.272  1.00 29.19           C  
ATOM  12952  CG  GLU     6      74.484  27.740  42.832  1.00 31.30           C  
ATOM  12953  CD  GLU     6      73.485  28.113  43.911  1.00 31.61           C  
ATOM  12954  OE1 GLU     6      73.885  28.327  45.083  1.00 38.52           O  
ATOM  12955  OE2 GLU     6      72.296  28.217  43.572  1.00 35.07           O  
ATOM  12956  N   GLY     7      77.769  24.454  42.764  1.00 27.55           N  
ATOM  12957  CA  GLY     7      78.825  23.599  43.252  1.00 27.47           C  
ATOM  12958  C   GLY     7      80.172  23.924  42.647  1.00 27.46           C  
ATOM  12959  O   GLY     7      81.190  23.916  43.348  1.00 28.04           O  
ATOM  12960  N   ARG     8      80.193  24.198  41.351  1.00 27.39           N  
ATOM  12961  CA  ARG     8      81.428  24.591  40.683  1.00 28.18           C  
ATOM  12962  C   ARG     8      81.977  25.901  41.263  1.00 27.87           C  
ATOM  12963  O   ARG     8      83.187  26.055  41.439  1.00 28.10           O  
ATOM  12964  CB  ARG     8      81.219  24.776  39.185  1.00 27.91           C  
ATOM  12965  CG  ARG     8      81.010  23.509  38.405  1.00 28.72           C  
ATOM  12966  CD  ARG     8      80.440  23.881  37.071  1.00 31.46           C  
ATOM  12967  NE  ARG     8      80.192  22.738  36.217  1.00 33.09           N  
ATOM  12968  CZ  ARG     8      79.413  22.752  35.140  1.00 35.77           C  
ATOM  12969  NH1 ARG     8      78.767  23.854  34.762  1.00 36.28           N  
ATOM  12970  NH2 ARG     8      79.267  21.629  34.439  1.00 38.50           N  
ATOM  12971  N   LEU     9      81.077  26.830  41.554  1.00 28.09           N  
ATOM  12972  CA  LEU     9      81.479  28.113  42.139  1.00 28.34           C  
ATOM  12973  C   LEU     9      82.103  27.873  43.539  1.00 28.63           C  
ATOM  12974  O   LEU     9      83.145  28.457  43.874  1.00 27.85           O  
ATOM  12975  CB  LEU     9      80.271  29.044  42.209  1.00 28.43           C  
ATOM  12976  CG  LEU     9      80.543  30.479  42.669  1.00 28.95           C  
ATOM  12977  CD1 LEU     9      81.644  31.110  41.771  1.00 29.20           C  
ATOM  12978  CD2 LEU     9      79.251  31.302  42.651  1.00 29.10           C  
ATOM  12979  N   LYS    10      81.487  26.998  44.343  1.00 28.27           N  
ATOM  12980  CA  LYS    10      82.090  26.586  45.618  1.00 29.09           C  
ATOM  12981  C   LYS    10      83.477  25.946  45.467  1.00 29.33           C  
ATOM  12982  O   LYS    10      84.380  26.178  46.296  1.00 30.06           O  
ATOM  12983  CB  LYS    10      81.155  25.648  46.379  1.00 29.06           C  
ATOM  12984  CG  LYS    10      79.869  26.277  46.842  1.00 29.74           C  
ATOM  12985  CD  LYS    10      79.055  25.300  47.652  1.00 30.41           C  
ATOM  12986  CE  LYS    10      77.739  25.887  48.034  1.00 30.84           C  
ATOM  12987  NZ  LYS    10      76.878  24.856  48.677  1.00 32.89           N  
ATOM  12988  N   GLU    11      83.673  25.166  44.413  1.00 29.53           N  
ATOM  12989  CA  GLU    11      84.977  24.594  44.114  1.00 30.47           C  
ATOM  12990  C   GLU    11      86.011  25.667  43.795  1.00 30.79           C  
ATOM  12991  O   GLU    11      87.190  25.452  44.020  1.00 32.10           O  
ATOM  12992  CB  GLU    11      84.889  23.624  42.946  1.00 30.41           C  
ATOM  12993  CG  GLU    11      84.195  22.304  43.287  1.00 31.53           C  
ATOM  12994  CD  GLU    11      83.980  21.440  42.072  1.00 33.05           C  
ATOM  12995  OE1 GLU    11      83.483  21.935  41.044  1.00 37.69           O  
ATOM  12996  OE2 GLU    11      84.275  20.239  42.144  1.00 40.32           O  
ATOM  12997  N   LEU    12      85.573  26.810  43.266  1.00 30.96           N  
ATOM  12998  CA  LEU    12      86.458  27.982  43.080  1.00 30.36           C  
ATOM  12999  C   LEU    12      86.672  28.813  44.349  1.00 30.69           C  
ATOM  13000  O   LEU    12      87.510  29.730  44.358  1.00 31.30           O  
ATOM  13001  CB  LEU    12      85.912  28.883  41.982  1.00 29.65           C  
ATOM  13002  CG  LEU    12      85.889  28.253  40.603  1.00 29.14           C  
ATOM  13003  CD1 LEU    12      85.193  29.190  39.650  1.00 28.44           C  
ATOM  13004  CD2 LEU    12      87.318  27.916  40.123  1.00 30.62           C  
ATOM  13005  N   GLY    13      85.906  28.530  45.398  1.00 30.88           N  
ATOM  13006  CA  GLY    13      86.097  29.154  46.694  1.00 30.87           C  
ATOM  13007  C   GLY    13      85.047  30.177  47.062  1.00 30.89           C  
ATOM  13008  O   GLY    13      85.157  30.816  48.099  1.00 31.94           O  
ATOM  13009  N   PHE    14      84.004  30.303  46.254  1.00 30.40           N  
ATOM  13010  CA  PHE    14      82.959  31.278  46.509  1.00 30.42           C  
ATOM  13011  C   PHE    14      81.595  30.647  46.801  1.00 31.05           C  
ATOM  13012  O   PHE    14      81.170  29.691  46.147  1.00 30.75           O  
ATOM  13013  CB  PHE    14      82.829  32.227  45.312  1.00 29.97           C  
ATOM  13014  CG  PHE    14      84.106  32.886  44.930  1.00 28.80           C  
ATOM  13015  CD1 PHE    14      84.494  34.057  45.537  1.00 29.32           C  
ATOM  13016  CD2 PHE    14      84.924  32.336  43.954  1.00 28.91           C  
ATOM  13017  CE1 PHE    14      85.688  34.670  45.177  1.00 27.83           C  
ATOM  13018  CE2 PHE    14      86.114  32.938  43.594  1.00 28.84           C  
ATOM  13019  CZ  PHE    14      86.494  34.108  44.214  1.00 28.76           C  
ATOM  13020  N   THR    15      80.906  31.228  47.769  1.00 31.89           N  
ATOM  13021  CA  THR    15      79.480  31.011  47.934  1.00 33.07           C  
ATOM  13022  C   THR    15      78.738  32.270  47.471  1.00 33.07           C  
ATOM  13023  O   THR    15      79.306  33.390  47.471  1.00 32.98           O  
ATOM  13024  CB  THR    15      79.142  30.676  49.406  1.00 33.77           C  
ATOM  13025  OG1 THR    15      79.407  31.816  50.239  1.00 37.27           O  
ATOM  13026  CG2 THR    15      79.988  29.500  49.902  1.00 32.51           C  
ATOM  13027  N   LEU    16      77.488  32.100  47.043  1.00 32.88           N  
ATOM  13028  CA  LEU    16      76.696  33.230  46.573  1.00 32.59           C  
ATOM  13029  C   LEU    16      76.163  34.007  47.767  1.00 33.08           C  
ATOM  13030  O   LEU    16      75.580  33.413  48.678  1.00 32.54           O  
ATOM  13031  CB  LEU    16      75.513  32.781  45.706  1.00 32.47           C  
ATOM  13032  CG  LEU    16      75.834  32.190  44.332  1.00 31.50           C  
ATOM  13033  CD1 LEU    16      74.534  31.595  43.670  1.00 29.77           C  
ATOM  13034  CD2 LEU    16      76.521  33.215  43.434  1.00 28.44           C  
ATOM  13035  N   PRO    17      76.338  35.334  47.771  1.00 33.26           N  
ATOM  13036  CA  PRO    17      75.694  36.103  48.823  1.00 33.95           C  
ATOM  13037  C   PRO    17      74.202  36.176  48.577  1.00 35.74           C  
ATOM  13038  O   PRO    17      73.743  35.890  47.461  1.00 35.40           O  
ATOM  13039  CB  PRO    17      76.304  37.492  48.650  1.00 33.84           C  
ATOM  13040  CG  PRO    17      76.630  37.570  47.219  1.00 33.42           C  
ATOM  13041  CD  PRO    17      77.081  36.198  46.835  1.00 32.52           C  
ATOM  13042  N   VAL    18      73.449  36.584  49.596  1.00 37.90           N  
ATOM  13043  CA  VAL    18      72.045  36.963  49.389  1.00 39.41           C  
ATOM  13044  C   VAL    18      71.995  38.269  48.568  1.00 40.41           C  
ATOM  13045  O   VAL    18      71.230  38.389  47.586  1.00 42.23           O  
ATOM  13046  CB  VAL    18      71.308  37.200  50.710  1.00 39.67           C  
ATOM  13047  CG1 VAL    18      71.505  36.006  51.656  1.00 40.20           C  
ATOM  13048  CG2 VAL    18      71.762  38.513  51.345  1.00 39.98           C  
ATOM  13049  N   ALA    23      66.158  48.786  48.809  1.00 42.30           N  
ATOM  13050  CA  ALA    23      64.939  49.472  48.343  1.00 41.72           C  
ATOM  13051  C   ALA    23      65.286  50.838  47.711  1.00 41.82           C  
ATOM  13052  O   ALA    23      65.606  51.804  48.439  1.00 42.33           O  
ATOM  13053  CB  ALA    23      63.942  49.647  49.513  1.00 42.49           C  
ATOM  13054  N   ALA    24      65.243  50.926  46.370  1.00 40.52           N  
ATOM  13055  CA  ALA    24      65.678  52.154  45.678  1.00 38.94           C  
ATOM  13056  C   ALA    24      64.979  52.405  44.337  1.00 37.86           C  
ATOM  13057  O   ALA    24      64.258  51.549  43.818  1.00 37.65           O  
ATOM  13058  CB  ALA    24      67.220  52.130  45.485  1.00 39.16           C  
ATOM  13059  N   ASN    25      65.207  53.597  43.784  1.00 35.84           N  
ATOM  13060  CA  ASN    25      64.676  53.977  42.458  1.00 34.71           C  
ATOM  13061  C   ASN    25      65.420  53.350  41.277  1.00 32.01           C  
ATOM  13062  O   ASN    25      64.955  53.404  40.128  1.00 30.65           O  
ATOM  13063  CB  ASN    25      64.628  55.506  42.327  1.00 34.31           C  
ATOM  13064  CG  ASN    25      63.556  56.116  43.221  1.00 34.82           C  
ATOM  13065  OD1 ASN    25      63.757  57.167  43.838  1.00 36.03           O  
ATOM  13066  ND2 ASN    25      62.419  55.419  43.327  1.00 31.59           N  
ATOM  13067  N   TYR    26      66.570  52.763  41.572  1.00 30.18           N  
ATOM  13068  CA  TYR    26      67.208  51.824  40.653  1.00 28.61           C  
ATOM  13069  C   TYR    26      67.192  50.433  41.287  1.00 26.27           C  
ATOM  13070  O   TYR    26      67.222  50.261  42.514  1.00 25.81           O  
ATOM  13071  CB  TYR    26      68.625  52.246  40.221  1.00 28.83           C  
ATOM  13072  CG  TYR    26      69.621  52.398  41.339  1.00 30.60           C  
ATOM  13073  CD1 TYR    26      70.670  51.493  41.495  1.00 30.95           C  
ATOM  13074  CD2 TYR    26      69.522  53.456  42.230  1.00 30.60           C  
ATOM  13075  CE1 TYR    26      71.582  51.635  42.510  1.00 30.87           C  
ATOM  13076  CE2 TYR    26      70.411  53.597  43.267  1.00 32.36           C  
ATOM  13077  CZ  TYR    26      71.447  52.689  43.404  1.00 32.75           C  
ATOM  13078  OH  TYR    26      72.352  52.852  44.448  1.00 34.31           O  
ATOM  13079  N   VAL    27      67.135  49.446  40.418  1.00 24.17           N  
ATOM  13080  CA  VAL    27      67.030  48.071  40.817  1.00 22.92           C  
ATOM  13081  C   VAL    27      68.271  47.271  40.393  1.00 22.47           C  
ATOM  13082  O   VAL    27      68.985  47.662  39.463  1.00 20.80           O  
ATOM  13083  CB  VAL    27      65.757  47.458  40.209  1.00 22.53           C  
ATOM  13084  CG1 VAL    27      64.536  48.064  40.881  1.00 24.05           C  
ATOM  13085  CG2 VAL    27      65.709  47.685  38.675  1.00 20.19           C  
ATOM  13086  N   PRO    28      68.514  46.135  41.065  1.00 22.19           N  
ATOM  13087  CA  PRO    28      69.643  45.282  40.693  1.00 22.05           C  
ATOM  13088  C   PRO    28      69.576  44.646  39.313  1.00 21.32           C  
ATOM  13089  O   PRO    28      70.620  44.298  38.758  1.00 19.41           O  
ATOM  13090  CB  PRO    28      69.645  44.208  41.765  1.00 23.32           C  
ATOM  13091  CG  PRO    28      68.744  44.705  42.839  1.00 24.78           C  
ATOM  13092  CD  PRO    28      67.767  45.580  42.209  1.00 22.87           C  
ATOM  13093  N   PHE    29      68.366  44.511  38.760  1.00 20.74           N  
ATOM  13094  CA  PHE    29      68.186  43.931  37.454  1.00 21.35           C  
ATOM  13095  C   PHE    29      66.815  44.278  36.885  1.00 20.78           C  
ATOM  13096  O   PHE    29      65.876  44.597  37.615  1.00 20.82           O  
ATOM  13097  CB  PHE    29      68.410  42.392  37.475  1.00 21.85           C  
ATOM  13098  CG  PHE    29      67.437  41.650  38.360  1.00 22.44           C  
ATOM  13099  CD1 PHE    29      66.175  41.334  37.907  1.00 24.23           C  
ATOM  13100  CD2 PHE    29      67.776  41.337  39.664  1.00 24.23           C  
ATOM  13101  CE1 PHE    29      65.265  40.664  38.746  1.00 23.72           C  
ATOM  13102  CE2 PHE    29      66.883  40.698  40.489  1.00 26.07           C  
ATOM  13103  CZ  PHE    29      65.623  40.381  40.031  1.00 24.55           C  
ATOM  13104  N   THR    30      66.753  44.281  35.568  1.00 21.11           N  
ATOM  13105  CA  THR    30      65.491  44.370  34.819  1.00 22.00           C  
ATOM  13106  C   THR    30      65.480  43.293  33.752  1.00 22.35           C  
ATOM  13107  O   THR    30      66.525  42.798  33.356  1.00 21.01           O  
ATOM  13108  CB  THR    30      65.298  45.735  34.132  1.00 22.63           C  
ATOM  13109  OG1 THR    30      66.405  46.020  33.266  1.00 22.53           O  
ATOM  13110  CG2 THR    30      65.139  46.846  35.164  1.00 21.28           C  
ATOM  13111  N   ILE    31      64.276  42.943  33.280  1.00 23.19           N  
ATOM  13112  CA  ILE    31      64.104  41.993  32.189  1.00 23.67           C  
ATOM  13113  C   ILE    31      63.288  42.634  31.087  1.00 23.56           C  
ATOM  13114  O   ILE    31      62.269  43.294  31.331  1.00 24.21           O  
ATOM  13115  CB  ILE    31      63.424  40.684  32.664  1.00 23.86           C  
ATOM  13116  CG1 ILE    31      64.303  39.977  33.687  1.00 23.74           C  
ATOM  13117  CG2 ILE    31      63.169  39.723  31.486  1.00 24.39           C  
ATOM  13118  CD1 ILE    31      63.577  38.878  34.465  1.00 25.28           C  
ATOM  13119  N   SER    32      63.757  42.461  29.874  1.00 24.00           N  
ATOM  13120  CA  SER    32      63.011  42.846  28.692  1.00 25.73           C  
ATOM  13121  C   SER    32      63.058  41.677  27.730  1.00 25.64           C  
ATOM  13122  O   SER    32      64.122  41.331  27.246  1.00 25.50           O  
ATOM  13123  CB  SER    32      63.598  44.073  28.021  1.00 25.81           C  
ATOM  13124  OG  SER    32      62.809  44.432  26.913  1.00 27.19           O  
ATOM  13125  N   GLY    33      61.903  41.083  27.430  1.00 26.33           N  
ATOM  13126  CA  GLY    33      61.899  39.878  26.629  1.00 26.22           C  
ATOM  13127  C   GLY    33      62.655  38.771  27.314  1.00 25.36           C  
ATOM  13128  O   GLY    33      62.370  38.424  28.457  1.00 26.34           O  
ATOM  13129  N   ASN    34      63.633  38.209  26.622  1.00 24.98           N  
ATOM  13130  CA  ASN    34      64.458  37.178  27.241  1.00 25.51           C  
ATOM  13131  C   ASN    34      65.858  37.705  27.552  1.00 24.78           C  
ATOM  13132  O   ASN    34      66.804  36.930  27.584  1.00 24.18           O  
ATOM  13133  CB  ASN    34      64.528  35.934  26.371  1.00 27.08           C  
ATOM  13134  CG  ASN    34      65.282  36.158  25.091  1.00 30.55           C  
ATOM  13135  OD1 ASN    34      65.607  37.305  24.738  1.00 35.31           O  
ATOM  13136  ND2 ASN    34      65.586  35.057  24.371  1.00 35.76           N  
ATOM  13137  N   LEU    35      65.983  39.022  27.699  1.00 24.55           N  
ATOM  13138  CA  LEU    35      67.277  39.637  28.078  1.00 24.12           C  
ATOM  13139  C   LEU    35      67.189  40.157  29.496  1.00 23.03           C  
ATOM  13140  O   LEU    35      66.268  40.868  29.847  1.00 23.05           O  
ATOM  13141  CB  LEU    35      67.702  40.736  27.096  1.00 24.76           C  
ATOM  13142  CG  LEU    35      68.282  40.199  25.764  1.00 26.16           C  
ATOM  13143  CD1 LEU    35      68.633  41.334  24.793  1.00 28.97           C  
ATOM  13144  CD2 LEU    35      69.489  39.249  25.947  1.00 28.49           C  
ATOM  13145  N   LEU    36      68.148  39.763  30.315  1.00 21.64           N  
ATOM  13146  CA  LEU    36      68.250  40.214  31.693  1.00 20.97           C  
ATOM  13147  C   LEU    36      69.421  41.199  31.776  1.00 20.61           C  
ATOM  13148  O   LEU    36      70.562  40.854  31.376  1.00 21.20           O  
ATOM  13149  CB  LEU    36      68.532  39.046  32.613  1.00 21.41           C  
ATOM  13150  CG  LEU    36      68.789  39.264  34.102  1.00 21.35           C  
ATOM  13151  CD1 LEU    36      67.603  39.957  34.807  1.00 23.14           C  
ATOM  13152  CD2 LEU    36      69.179  37.943  34.804  1.00 22.93           C  
ATOM  13153  N   TYR    37      69.112  42.393  32.255  1.00 19.52           N  
ATOM  13154  CA  TYR    37      70.093  43.483  32.452  1.00 19.94           C  
ATOM  13155  C   TYR    37      70.430  43.581  33.906  1.00 19.30           C  
ATOM  13156  O   TYR    37      69.576  43.954  34.684  1.00 18.49           O  
ATOM  13157  CB  TYR    37      69.527  44.816  32.021  1.00 21.62           C  
ATOM  13158  CG  TYR    37      69.633  45.044  30.561  1.00 24.97           C  
ATOM  13159  CD1 TYR    37      70.608  45.901  30.041  1.00 26.99           C  
ATOM  13160  CD2 TYR    37      68.798  44.384  29.690  1.00 26.43           C  
ATOM  13161  CE1 TYR    37      70.711  46.099  28.690  1.00 28.18           C  
ATOM  13162  CE2 TYR    37      68.902  44.583  28.309  1.00 27.61           C  
ATOM  13163  CZ  TYR    37      69.839  45.424  27.829  1.00 26.70           C  
ATOM  13164  OH  TYR    37      69.928  45.651  26.474  1.00 28.34           O  
ATOM  13165  N   VAL    38      71.680  43.277  34.255  1.00 18.12           N  
ATOM  13166  CA  VAL    38      72.116  43.284  35.635  1.00 17.38           C  
ATOM  13167  C   VAL    38      72.897  44.591  35.852  1.00 17.03           C  
ATOM  13168  O   VAL    38      73.783  44.948  35.040  1.00 16.35           O  
ATOM  13169  CB  VAL    38      72.994  42.065  35.962  1.00 17.22           C  
ATOM  13170  CG1 VAL    38      73.488  42.113  37.378  1.00 16.68           C  
ATOM  13171  CG2 VAL    38      72.228  40.778  35.704  1.00 19.02           C  
ATOM  13172  N   SER    39      72.542  45.277  36.935  1.00 16.21           N  
ATOM  13173  CA  SER    39      73.190  46.537  37.340  1.00 16.77           C  
ATOM  13174  C   SER    39      74.675  46.307  37.694  1.00 16.42           C  
ATOM  13175  O   SER    39      75.066  45.194  38.084  1.00 16.79           O  
ATOM  13176  CB  SER    39      72.491  47.130  38.559  1.00 16.39           C  
ATOM  13177  OG  SER    39      71.232  47.673  38.217  1.00 16.94           O  
ATOM  13178  N   GLY    40      75.498  47.355  37.547  1.00 16.71           N  
ATOM  13179  CA  GLY    40      76.913  47.251  37.877  1.00 16.17           C  
ATOM  13180  C   GLY    40      77.093  46.701  39.267  1.00 16.82           C  
ATOM  13181  O   GLY    40      76.479  47.191  40.216  1.00 16.75           O  
ATOM  13182  N   GLN    41      77.848  45.617  39.375  1.00 16.68           N  
ATOM  13183  CA  GLN    41      78.114  44.996  40.668  1.00 17.30           C  
ATOM  13184  C   GLN    41      79.538  45.360  41.116  1.00 16.88           C  
ATOM  13185  O   GLN    41      80.451  45.399  40.295  1.00 17.16           O  
ATOM  13186  CB  GLN    41      77.943  43.460  40.588  1.00 17.03           C  
ATOM  13187  CG  GLN    41      76.522  42.993  40.194  1.00 18.15           C  
ATOM  13188  CD  GLN    41      75.491  43.430  41.175  1.00 18.41           C  
ATOM  13189  OE1 GLN    41      75.559  43.081  42.360  1.00 18.42           O  
ATOM  13190  NE2 GLN    41      74.513  44.191  40.705  1.00 18.08           N  
ATOM  13191  N   LEU    42      79.675  45.523  42.425  1.00 18.51           N  
ATOM  13192  CA  LEU    42      80.922  45.823  43.142  1.00 19.27           C  
ATOM  13193  C   LEU    42      81.505  44.544  43.800  1.00 20.59           C  
ATOM  13194  O   LEU    42      80.809  43.508  43.933  1.00 20.90           O  
ATOM  13195  CB  LEU    42      80.648  46.893  44.195  1.00 19.83           C  
ATOM  13196  CG  LEU    42      80.007  48.193  43.701  1.00 20.09           C  
ATOM  13197  CD1 LEU    42      79.893  49.256  44.830  1.00 24.19           C  
ATOM  13198  CD2 LEU    42      80.773  48.751  42.474  1.00 20.92           C  
ATOM  13199  N   PRO    43      82.784  44.590  44.204  1.00 20.99           N  
ATOM  13200  CA  PRO    43      83.390  43.388  44.739  1.00 22.23           C  
ATOM  13201  C   PRO    43      82.987  43.165  46.205  1.00 23.30           C  
ATOM  13202  O   PRO    43      83.833  43.267  47.123  1.00 23.87           O  
ATOM  13203  CB  PRO    43      84.886  43.654  44.574  1.00 22.24           C  
ATOM  13204  CG  PRO    43      85.021  45.107  44.597  1.00 22.74           C  
ATOM  13205  CD  PRO    43      83.747  45.711  44.125  1.00 20.90           C  
ATOM  13206  N   MET    44      81.695  42.863  46.396  1.00 24.94           N  
ATOM  13207  CA  MET    44      81.111  42.668  47.725  1.00 26.76           C  
ATOM  13208  C   MET    44      81.416  41.303  48.250  1.00 27.78           C  
ATOM  13209  O   MET    44      81.216  40.309  47.554  1.00 26.94           O  
ATOM  13210  CB  MET    44      79.606  42.768  47.701  1.00 28.72           C  
ATOM  13211  CG  MET    44      79.087  44.003  47.142  1.00 34.04           C  
ATOM  13212  SD  MET    44      79.675  45.517  48.177  1.00 52.29          SE  
ATOM  13213  CE  MET    44      78.069  46.599  47.655  1.00 42.80           C  
ATOM  13214  N   GLU    45      81.866  41.277  49.503  1.00 28.96           N  
ATOM  13215  CA  GLU    45      82.155  40.050  50.199  1.00 30.57           C  
ATOM  13216  C   GLU    45      81.806  40.268  51.663  1.00 30.94           C  
ATOM  13217  O   GLU    45      82.239  41.230  52.276  1.00 29.35           O  
ATOM  13218  CB  GLU    45      83.615  39.704  50.030  1.00 31.01           C  
ATOM  13219  CG  GLU    45      83.899  38.254  50.285  1.00 32.83           C  
ATOM  13220  CD  GLU    45      85.369  37.906  50.169  1.00 34.03           C  
ATOM  13221  OE1 GLU    45      86.236  38.800  50.290  1.00 40.50           O  
ATOM  13222  OE2 GLU    45      85.665  36.719  49.956  1.00 39.11           O  
ATOM  13223  N   SER    46      80.980  39.381  52.208  1.00 32.41           N  
ATOM  13224  CA  SER    46      80.473  39.546  53.558  1.00 33.11           C  
ATOM  13225  C   SER    46      79.902  40.921  53.829  1.00 32.96           C  
ATOM  13226  O   SER    46      80.092  41.474  54.907  1.00 33.73           O  
ATOM  13227  CB  SER    46      81.576  39.245  54.550  1.00 33.85           C  
ATOM  13228  OG  SER    46      82.071  37.929  54.341  1.00 36.10           O  
ATOM  13229  N   GLY    47      79.201  41.482  52.851  1.00 32.72           N  
ATOM  13230  CA  GLY    47      78.556  42.782  53.023  1.00 32.20           C  
ATOM  13231  C   GLY    47      79.457  44.008  52.954  1.00 31.89           C  
ATOM  13232  O   GLY    47      78.988  45.134  53.165  1.00 32.53           O  
ATOM  13233  N   LYS    48      80.735  43.805  52.632  1.00 31.36           N  
ATOM  13234  CA  LYS    48      81.710  44.889  52.589  1.00 31.00           C  
ATOM  13235  C   LYS    48      82.340  44.938  51.204  1.00 29.19           C  
ATOM  13236  O   LYS    48      82.428  43.919  50.525  1.00 27.85           O  
ATOM  13237  CB  LYS    48      82.812  44.643  53.628  1.00 32.10           C  
ATOM  13238  CG  LYS    48      82.320  44.278  55.056  1.00 33.77           C  
ATOM  13239  CD  LYS    48      83.517  44.073  55.997  1.00 34.85           C  
ATOM  13240  CE  LYS    48      83.212  43.172  57.223  1.00 38.54           C  
ATOM  13241  NZ  LYS    48      82.691  41.784  56.927  1.00 41.89           N  
ATOM  13242  N   ILE    49      82.793  46.114  50.786  1.00 27.46           N  
ATOM  13243  CA  ILE    49      83.609  46.197  49.556  1.00 27.51           C  
ATOM  13244  C   ILE    49      84.994  45.615  49.890  1.00 26.44           C  
ATOM  13245  O   ILE    49      85.717  46.162  50.719  1.00 27.76           O  
ATOM  13246  CB  ILE    49      83.727  47.641  48.999  1.00 27.35           C  
ATOM  13247  CG1 ILE    49      82.339  48.250  48.725  1.00 28.61           C  
ATOM  13248  CG2 ILE    49      84.568  47.654  47.687  1.00 25.90           C  
ATOM  13249  CD1 ILE    49      81.640  47.702  47.484  1.00 29.88           C  
ATOM  13250  N   ALA    50      85.329  44.473  49.299  1.00 24.66           N  
ATOM  13251  CA  ALA    50      86.524  43.716  49.675  1.00 23.88           C  
ATOM  13252  C   ALA    50      87.844  44.216  49.077  1.00 22.88           C  
ATOM  13253  O   ALA    50      88.926  43.916  49.616  1.00 23.36           O  
ATOM  13254  CB  ALA    50      86.342  42.241  49.306  1.00 24.42           C  
ATOM  13255  N   VAL    51      87.773  44.926  47.958  1.00 20.81           N  
ATOM  13256  CA  VAL    51      88.968  45.381  47.241  1.00 19.75           C  
ATOM  13257  C   VAL    51      88.716  46.833  46.772  1.00 19.50           C  
ATOM  13258  O   VAL    51      87.820  47.092  45.950  1.00 18.36           O  
ATOM  13259  CB  VAL    51      89.299  44.506  46.034  1.00 19.25           C  
ATOM  13260  CG1 VAL    51      90.619  44.969  45.369  1.00 17.95           C  
ATOM  13261  CG2 VAL    51      89.337  42.997  46.410  1.00 19.82           C  
ATOM  13262  N   THR    52      89.518  47.761  47.290  1.00 18.83           N  
ATOM  13263  CA  THR    52      89.331  49.192  47.048  1.00 18.76           C  
ATOM  13264  C   THR    52      90.623  49.886  46.577  1.00 17.15           C  
ATOM  13265  O   THR    52      91.752  49.426  46.833  1.00 18.57           O  
ATOM  13266  CB  THR    52      88.801  49.933  48.274  1.00 19.87           C  
ATOM  13267  OG1 THR    52      89.751  49.836  49.341  1.00 20.52           O  
ATOM  13268  CG2 THR    52      87.440  49.358  48.732  1.00 20.18           C  
ATOM  13269  N   GLY    53      90.427  50.980  45.853  1.00 16.63           N  
ATOM  13270  CA  GLY    53      91.523  51.794  45.378  1.00 15.81           C  
ATOM  13271  C   GLY    53      91.866  51.490  43.935  1.00 16.34           C  
ATOM  13272  O   GLY    53      91.220  50.657  43.238  1.00 16.41           O  
ATOM  13273  N   LEU    54      92.852  52.232  43.462  1.00 14.89           N  
ATOM  13274  CA  LEU    54      93.241  52.192  42.046  1.00 15.09           C  
ATOM  13275  C   LEU    54      94.198  51.052  41.691  1.00 14.82           C  
ATOM  13276  O   LEU    54      95.217  50.830  42.343  1.00 15.74           O  
ATOM  13277  CB  LEU    54      93.870  53.539  41.641  1.00 14.99           C  
ATOM  13278  CG  LEU    54      93.016  54.794  41.893  1.00 16.43           C  
ATOM  13279  CD1 LEU    54      93.853  56.129  41.629  1.00 14.43           C  
ATOM  13280  CD2 LEU    54      91.711  54.771  41.099  1.00 18.58           C  
ATOM  13281  N   VAL    55      93.881  50.333  40.618  1.00 15.10           N  
ATOM  13282  CA  VAL    55      94.798  49.303  40.117  1.00 15.22           C  
ATOM  13283  C   VAL    55      96.009  50.038  39.509  1.00 15.52           C  
ATOM  13284  O   VAL    55      95.867  51.023  38.743  1.00 15.49           O  
ATOM  13285  CB  VAL    55      94.147  48.295  39.122  1.00 15.34           C  
ATOM  13286  CG1 VAL    55      95.143  47.202  38.776  1.00 16.34           C  
ATOM  13287  CG2 VAL    55      92.798  47.747  39.668  1.00 14.16           C  
ATOM  13288  N   GLY    56      97.188  49.598  39.915  1.00 15.44           N  
ATOM  13289  CA  GLY    56      98.449  50.244  39.536  1.00 16.28           C  
ATOM  13290  C   GLY    56      98.942  51.219  40.587  1.00 16.32           C  
ATOM  13291  O   GLY    56     100.026  51.780  40.450  1.00 16.29           O  
ATOM  13292  N   ARG    57      98.166  51.390  41.665  1.00 16.32           N  
ATOM  13293  CA  ARG    57      98.571  52.249  42.778  1.00 16.70           C  
ATOM  13294  C   ARG    57      98.304  51.594  44.106  1.00 16.10           C  
ATOM  13295  O   ARG    57      99.218  51.357  44.886  1.00 17.03           O  
ATOM  13296  CB  ARG    57      97.873  53.603  42.715  1.00 15.72           C  
ATOM  13297  CG  ARG    57      98.244  54.497  43.885  1.00 16.84           C  
ATOM  13298  CD  ARG    57      97.659  55.894  43.877  1.00 15.89           C  
ATOM  13299  NE  ARG    57      98.101  56.563  45.097  1.00 15.63           N  
ATOM  13300  CZ  ARG    57      99.287  57.153  45.256  1.00 16.91           C  
ATOM  13301  NH1 ARG    57     100.160  57.249  44.259  1.00 13.83           N  
ATOM  13302  NH2 ARG    57      99.613  57.651  46.435  1.00 15.00           N  
ATOM  13303  N   ASP    58      97.051  51.278  44.341  1.00 16.23           N  
ATOM  13304  CA  ASP    58      96.620  50.693  45.608  1.00 16.54           C  
ATOM  13305  C   ASP    58      96.524  49.169  45.557  1.00 16.62           C  
ATOM  13306  O   ASP    58      96.664  48.506  46.600  1.00 16.58           O  
ATOM  13307  CB  ASP    58      95.275  51.259  45.998  1.00 16.42           C  
ATOM  13308  CG  ASP    58      95.312  52.769  46.142  1.00 17.20           C  
ATOM  13309  OD1 ASP    58      96.112  53.243  46.982  1.00 19.65           O  
ATOM  13310  OD2 ASP    58      94.531  53.456  45.451  1.00 18.16           O  
ATOM  13311  N   VAL    59      96.242  48.632  44.377  1.00 16.45           N  
ATOM  13312  CA  VAL    59      96.058  47.197  44.212  1.00 17.77           C  
ATOM  13313  C   VAL    59      96.785  46.737  42.956  1.00 17.83           C  
ATOM  13314  O   VAL    59      96.926  47.493  41.987  1.00 17.33           O  
ATOM  13315  CB  VAL    59      94.554  46.767  44.189  1.00 18.87           C  
ATOM  13316  CG1 VAL    59      93.778  47.334  45.449  1.00 21.82           C  
ATOM  13317  CG2 VAL    59      93.896  47.197  42.965  1.00 21.44           C  
ATOM  13318  N   ASP    60      97.285  45.515  43.025  1.00 18.74           N  
ATOM  13319  CA  ASP    60      97.964  44.879  41.909  1.00 19.34           C  
ATOM  13320  C   ASP    60      96.992  44.080  41.043  1.00 19.48           C  
ATOM  13321  O   ASP    60      95.805  44.037  41.332  1.00 19.40           O  
ATOM  13322  CB  ASP    60      99.147  44.040  42.405  1.00 20.89           C  
ATOM  13323  CG  ASP    60      98.757  42.848  43.254  1.00 21.21           C  
ATOM  13324  OD1 ASP    60      97.589  42.484  43.394  1.00 22.81           O  
ATOM  13325  OD2 ASP    60      99.713  42.231  43.792  1.00 30.25           O  
ATOM  13326  N   VAL    61      97.486  43.487  39.967  1.00 18.59           N  
ATOM  13327  CA  VAL    61      96.614  42.760  39.045  1.00 19.30           C  
ATOM  13328  C   VAL    61      95.938  41.568  39.757  1.00 18.76           C  
ATOM  13329  O   VAL    61      94.732  41.355  39.623  1.00 19.22           O  
ATOM  13330  CB  VAL    61      97.352  42.330  37.761  1.00 19.44           C  
ATOM  13331  CG1 VAL    61      96.504  41.337  36.953  1.00 20.46           C  
ATOM  13332  CG2 VAL    61      97.699  43.573  36.911  1.00 19.62           C  
ATOM  13333  N   ALA    62      96.695  40.801  40.523  1.00 18.89           N  
ATOM  13334  CA  ALA    62      96.120  39.649  41.215  1.00 19.10           C  
ATOM  13335  C   ALA    62      94.973  40.048  42.139  1.00 19.10           C  
ATOM  13336  O   ALA    62      93.905  39.417  42.132  1.00 18.61           O  
ATOM  13337  CB  ALA    62      97.209  38.899  42.012  1.00 19.82           C  
ATOM  13338  N   SER    63      95.178  41.088  42.960  1.00 18.52           N  
ATOM  13339  CA  SER    63      94.126  41.541  43.854  1.00 19.00           C  
ATOM  13340  C   SER    63      92.917  42.037  43.057  1.00 18.56           C  
ATOM  13341  O   SER    63      91.790  41.803  43.432  1.00 18.58           O  
ATOM  13342  CB  SER    63      94.622  42.645  44.745  1.00 19.24           C  
ATOM  13343  OG  SER    63      95.617  42.148  45.586  1.00 20.64           O  
ATOM  13344  N   ALA    64      93.164  42.778  41.983  1.00 18.32           N  
ATOM  13345  CA  ALA    64      92.088  43.282  41.124  1.00 18.22           C  
ATOM  13346  C   ALA    64      91.295  42.123  40.447  1.00 17.22           C  
ATOM  13347  O   ALA    64      90.093  42.203  40.247  1.00 15.74           O  
ATOM  13348  CB  ALA    64      92.667  44.231  40.071  1.00 18.00           C  
ATOM  13349  N   GLN    65      92.005  41.065  40.095  1.00 18.13           N  
ATOM  13350  CA  GLN    65      91.374  39.867  39.554  1.00 19.19           C  
ATOM  13351  C   GLN    65      90.392  39.274  40.566  1.00 19.55           C  
ATOM  13352  O   GLN    65      89.268  38.896  40.194  1.00 19.43           O  
ATOM  13353  CB  GLN    65      92.424  38.845  39.097  1.00 18.99           C  
ATOM  13354  CG  GLN    65      93.078  39.208  37.762  1.00 19.83           C  
ATOM  13355  CD  GLN    65      94.275  38.344  37.421  1.00 19.98           C  
ATOM  13356  OE1 GLN    65      94.942  37.792  38.312  1.00 23.49           O  
ATOM  13357  NE2 GLN    65      94.541  38.184  36.114  1.00 20.84           N  
ATOM  13358  N   ARG    66      90.789  39.194  41.835  1.00 20.27           N  
ATOM  13359  CA  ARG    66      89.877  38.774  42.884  1.00 19.80           C  
ATOM  13360  C   ARG    66      88.688  39.723  43.034  1.00 19.12           C  
ATOM  13361  O   ARG    66      87.559  39.289  43.213  1.00 18.72           O  
ATOM  13362  CB  ARG    66      90.597  38.676  44.215  1.00 21.46           C  
ATOM  13363  CG  ARG    66      89.674  38.205  45.361  1.00 25.65           C  
ATOM  13364  CD  ARG    66      89.298  36.727  45.200  1.00 36.25           C  
ATOM  13365  NE  ARG    66      90.392  35.890  45.691  1.00 41.73           N  
ATOM  13366  CZ  ARG    66      90.704  34.644  45.300  1.00 44.24           C  
ATOM  13367  NH1 ARG    66      90.018  33.988  44.357  1.00 45.76           N  
ATOM  13368  NH2 ARG    66      91.746  34.039  45.876  1.00 45.36           N  
ATOM  13369  N   ALA    67      88.915  41.023  42.911  1.00 18.19           N  
ATOM  13370  CA  ALA    67      87.776  41.975  42.854  1.00 17.76           C  
ATOM  13371  C   ALA    67      86.826  41.622  41.708  1.00 17.38           C  
ATOM  13372  O   ALA    67      85.599  41.617  41.892  1.00 17.68           O  
ATOM  13373  CB  ALA    67      88.270  43.434  42.700  1.00 18.27           C  
ATOM  13374  N   ALA    68      87.399  41.298  40.541  1.00 16.79           N  
ATOM  13375  CA  ALA    68      86.601  40.982  39.365  1.00 17.36           C  
ATOM  13376  C   ALA    68      85.816  39.681  39.613  1.00 17.31           C  
ATOM  13377  O   ALA    68      84.630  39.612  39.301  1.00 17.42           O  
ATOM  13378  CB  ALA    68      87.459  40.881  38.124  1.00 16.52           C  
ATOM  13379  N   GLU    69      86.469  38.683  40.196  1.00 17.93           N  
ATOM  13380  CA  GLU    69      85.784  37.441  40.576  1.00 18.71           C  
ATOM  13381  C   GLU    69      84.583  37.751  41.484  1.00 18.93           C  
ATOM  13382  O   GLU    69      83.471  37.242  41.241  1.00 18.31           O  
ATOM  13383  CB  GLU    69      86.757  36.477  41.251  1.00 19.08           C  
ATOM  13384  CG  GLU    69      87.806  35.902  40.322  1.00 21.15           C  
ATOM  13385  CD  GLU    69      88.858  35.066  41.051  1.00 22.14           C  
ATOM  13386  OE1 GLU    69      89.114  35.313  42.248  1.00 26.87           O  
ATOM  13387  OE2 GLU    69      89.424  34.144  40.439  1.00 27.07           O  
ATOM  13388  N   LEU    70      84.785  38.602  42.502  1.00 18.58           N  
ATOM  13389  CA  LEU    70      83.696  38.968  43.407  1.00 18.83           C  
ATOM  13390  C   LEU    70      82.568  39.708  42.680  1.00 19.23           C  
ATOM  13391  O   LEU    70      81.381  39.501  42.991  1.00 19.11           O  
ATOM  13392  CB  LEU    70      84.211  39.780  44.620  1.00 19.41           C  
ATOM  13393  CG  LEU    70      85.076  39.021  45.631  1.00 19.00           C  
ATOM  13394  CD1 LEU    70      85.801  39.978  46.576  1.00 19.47           C  
ATOM  13395  CD2 LEU    70      84.185  37.995  46.377  1.00 21.35           C  
ATOM  13396  N   CYS    71      82.915  40.595  41.740  1.00 18.39           N  
ATOM  13397  CA  CYS    71      81.884  41.296  40.973  1.00 18.21           C  
ATOM  13398  C   CYS    71      81.020  40.255  40.259  1.00 18.12           C  
ATOM  13399  O   CYS    71      79.783  40.380  40.219  1.00 18.48           O  
ATOM  13400  CB  CYS    71      82.523  42.263  39.959  1.00 18.28           C  
ATOM  13401  SG  CYS    71      83.354  43.707  40.748  1.00 17.98           S  
ATOM  13402  N   ALA    72      81.702  39.258  39.697  1.00 18.14           N  
ATOM  13403  CA  ALA    72      81.087  38.152  38.925  1.00 18.89           C  
ATOM  13404  C   ALA    72      80.191  37.309  39.820  1.00 19.05           C  
ATOM  13405  O   ALA    72      79.114  36.921  39.394  1.00 18.95           O  
ATOM  13406  CB  ALA    72      82.163  37.286  38.228  1.00 19.28           C  
ATOM  13407  N   VAL    73      80.632  37.045  41.048  1.00 19.61           N  
ATOM  13408  CA  VAL    73      79.815  36.298  42.031  1.00 20.01           C  
ATOM  13409  C   VAL    73      78.521  37.045  42.369  1.00 20.13           C  
ATOM  13410  O   VAL    73      77.428  36.449  42.460  1.00 20.48           O  
ATOM  13411  CB  VAL    73      80.633  36.004  43.330  1.00 20.82           C  
ATOM  13412  CG1 VAL    73      79.714  35.513  44.502  1.00 21.02           C  
ATOM  13413  CG2 VAL    73      81.772  35.052  43.029  1.00 19.80           C  
ATOM  13414  N   ASN    74      78.651  38.353  42.525  1.00 20.11           N  
ATOM  13415  CA  ASN    74      77.538  39.245  42.782  1.00 19.82           C  
ATOM  13416  C   ASN    74      76.578  39.319  41.600  1.00 19.58           C  
ATOM  13417  O   ASN    74      75.340  39.315  41.782  1.00 19.11           O  
ATOM  13418  CB  ASN    74      78.047  40.618  43.245  1.00 21.09           C  
ATOM  13419  CG  ASN    74      78.475  40.618  44.708  1.00 20.96           C  
ATOM  13420  OD1 ASN    74      79.667  40.497  45.044  1.00 25.84           O  
ATOM  13421  ND2 ASN    74      77.513  40.757  45.583  1.00 21.36           N  
ATOM  13422  N   ILE    75      77.117  39.332  40.385  1.00 19.22           N  
ATOM  13423  CA  ILE    75      76.266  39.262  39.188  1.00 19.73           C  
ATOM  13424  C   ILE    75      75.449  37.952  39.240  1.00 19.91           C  
ATOM  13425  O   ILE    75      74.232  37.959  39.042  1.00 21.28           O  
ATOM  13426  CB  ILE    75      77.082  39.318  37.856  1.00 20.26           C  
ATOM  13427  CG1 ILE    75      77.721  40.707  37.642  1.00 20.27           C  
ATOM  13428  CG2 ILE    75      76.193  38.957  36.665  1.00 18.77           C  
ATOM  13429  CD1 ILE    75      78.803  40.768  36.489  1.00 19.64           C  
ATOM  13430  N   LEU    76      76.126  36.852  39.510  1.00 20.16           N  
ATOM  13431  CA  LEU    76      75.459  35.515  39.533  1.00 20.33           C  
ATOM  13432  C   LEU    76      74.366  35.460  40.615  1.00 20.78           C  
ATOM  13433  O   LEU    76      73.297  34.907  40.379  1.00 21.42           O  
ATOM  13434  CB  LEU    76      76.486  34.394  39.689  1.00 20.53           C  
ATOM  13435  CG  LEU    76      77.372  34.118  38.484  1.00 20.87           C  
ATOM  13436  CD1 LEU    76      78.458  33.098  38.825  1.00 22.97           C  
ATOM  13437  CD2 LEU    76      76.544  33.679  37.260  1.00 23.02           C  
ATOM  13438  N   ALA    77      74.614  36.063  41.784  1.00 21.14           N  
ATOM  13439  CA  ALA    77      73.597  36.165  42.832  1.00 21.04           C  
ATOM  13440  C   ALA    77      72.361  36.891  42.300  1.00 21.95           C  
ATOM  13441  O   ALA    77      71.217  36.466  42.522  1.00 21.90           O  
ATOM  13442  CB  ALA    77      74.162  36.883  44.086  1.00 20.99           C  
ATOM  13443  N   GLN    78      72.587  37.993  41.581  1.00 21.45           N  
ATOM  13444  CA  GLN    78      71.473  38.745  41.023  1.00 22.10           C  
ATOM  13445  C   GLN    78      70.713  37.927  39.965  1.00 21.79           C  
ATOM  13446  O   GLN    78      69.486  37.929  39.936  1.00 22.55           O  
ATOM  13447  CB  GLN    78      71.950  40.077  40.422  1.00 22.09           C  
ATOM  13448  CG  GLN    78      72.508  41.105  41.436  1.00 24.22           C  
ATOM  13449  CD  GLN    78      71.567  41.457  42.585  1.00 27.40           C  
ATOM  13450  OE1 GLN    78      70.352  41.227  42.543  1.00 31.81           O  
ATOM  13451  NE2 GLN    78      72.141  42.054  43.621  1.00 33.24           N  
ATOM  13452  N   VAL    79      71.444  37.235  39.103  1.00 22.19           N  
ATOM  13453  CA  VAL    79      70.817  36.392  38.091  1.00 22.65           C  
ATOM  13454  C   VAL    79      69.980  35.285  38.732  1.00 23.28           C  
ATOM  13455  O   VAL    79      68.872  35.003  38.273  1.00 23.03           O  
ATOM  13456  CB  VAL    79      71.835  35.795  37.119  1.00 23.12           C  
ATOM  13457  CG1 VAL    79      71.136  34.895  36.134  1.00 23.37           C  
ATOM  13458  CG2 VAL    79      72.623  36.932  36.374  1.00 22.03           C  
ATOM  13459  N   LYS    80      70.507  34.673  39.779  1.00 23.69           N  
ATOM  13460  CA  LYS    80      69.799  33.611  40.478  1.00 24.34           C  
ATOM  13461  C   LYS    80      68.501  34.164  41.053  1.00 25.02           C  
ATOM  13462  O   LYS    80      67.442  33.517  40.935  1.00 25.88           O  
ATOM  13463  CB  LYS    80      70.672  33.018  41.576  1.00 24.54           C  
ATOM  13464  CG  LYS    80      69.980  31.893  42.358  1.00 24.65           C  
ATOM  13465  CD  LYS    80      70.809  31.421  43.510  1.00 25.01           C  
ATOM  13466  CE  LYS    80      69.995  30.487  44.426  1.00 26.39           C  
ATOM  13467  NZ  LYS    80      70.884  29.674  45.302  1.00 27.82           N  
ATOM  13468  N   ALA    81      68.564  35.351  41.664  1.00 25.16           N  
ATOM  13469  CA  ALA    81      67.346  36.048  42.148  1.00 25.31           C  
ATOM  13470  C   ALA    81      66.342  36.341  41.017  1.00 25.95           C  
ATOM  13471  O   ALA    81      65.141  36.042  41.158  1.00 25.62           O  
ATOM  13472  CB  ALA    81      67.697  37.329  42.899  1.00 25.25           C  
ATOM  13473  N   ALA    82      66.827  36.906  39.908  1.00 25.86           N  
ATOM  13474  CA  ALA    82      66.008  37.146  38.720  1.00 26.45           C  
ATOM  13475  C   ALA    82      65.358  35.846  38.201  1.00 26.96           C  
ATOM  13476  O   ALA    82      64.253  35.900  37.645  1.00 27.66           O  
ATOM  13477  CB  ALA    82      66.813  37.773  37.611  1.00 25.68           C  
ATOM  13478  N   LEU    83      66.034  34.712  38.370  1.00 27.25           N  
ATOM  13479  CA  LEU    83      65.568  33.458  37.785  1.00 28.53           C  
ATOM  13480  C   LEU    83      64.892  32.546  38.810  1.00 29.77           C  
ATOM  13481  O   LEU    83      64.768  31.322  38.610  1.00 29.23           O  
ATOM  13482  CB  LEU    83      66.721  32.761  37.070  1.00 28.68           C  
ATOM  13483  CG  LEU    83      67.336  33.509  35.875  1.00 27.34           C  
ATOM  13484  CD1 LEU    83      68.442  32.677  35.265  1.00 27.66           C  
ATOM  13485  CD2 LEU    83      66.303  33.910  34.809  1.00 26.22           C  
ATOM  13486  N   ASN    84      64.439  33.159  39.895  1.00 30.56           N  
ATOM  13487  CA  ASN    84      63.729  32.463  40.972  1.00 32.17           C  
ATOM  13488  C   ASN    84      64.473  31.244  41.527  1.00 32.90           C  
ATOM  13489  O   ASN    84      63.869  30.207  41.867  1.00 33.06           O  
ATOM  13490  CB  ASN    84      62.309  32.124  40.501  1.00 32.69           C  
ATOM  13491  CG  ASN    84      61.490  33.372  40.221  1.00 35.55           C  
ATOM  13492  OD1 ASN    84      60.912  33.525  39.134  1.00 41.64           O  
ATOM  13493  ND2 ASN    84      61.455  34.290  41.192  1.00 39.24           N  
ATOM  13494  N   GLY    85      65.789  31.382  41.634  1.00 33.09           N  
ATOM  13495  CA  GLY    85      66.645  30.371  42.227  1.00 33.47           C  
ATOM  13496  C   GLY    85      67.306  29.487  41.196  1.00 34.39           C  
ATOM  13497  O   GLY    85      68.029  28.555  41.537  1.00 35.05           O  
ATOM  13498  N   ASP    86      67.097  29.793  39.927  1.00 35.62           N  
ATOM  13499  CA  ASP    86      67.425  28.850  38.869  1.00 36.87           C  
ATOM  13500  C   ASP    86      68.531  29.305  37.873  1.00 36.44           C  
ATOM  13501  O   ASP    86      68.241  29.668  36.744  1.00 36.29           O  
ATOM  13502  CB  ASP    86      66.107  28.532  38.145  1.00 37.68           C  
ATOM  13503  CG  ASP    86      66.135  27.208  37.412  1.00 40.66           C  
ATOM  13504  OD1 ASP    86      67.157  26.494  37.471  1.00 44.08           O  
ATOM  13505  OD2 ASP    86      65.116  26.881  36.763  1.00 45.09           O  
ATOM  13506  N   LEU    87      69.796  29.225  38.285  1.00 36.56           N  
ATOM  13507  CA  LEU    87      70.940  29.570  37.412  1.00 36.56           C  
ATOM  13508  C   LEU    87      71.040  28.748  36.105  1.00 36.34           C  
ATOM  13509  O   LEU    87      71.796  29.096  35.196  1.00 35.79           O  
ATOM  13510  CB  LEU    87      72.272  29.500  38.182  1.00 36.86           C  
ATOM  13511  CG  LEU    87      72.623  30.693  39.091  1.00 36.88           C  
ATOM  13512  CD1 LEU    87      73.967  30.459  39.777  1.00 36.37           C  
ATOM  13513  CD2 LEU    87      72.640  32.048  38.326  1.00 36.15           C  
ATOM  13514  N   SER    88      70.275  27.665  36.024  1.00 36.37           N  
ATOM  13515  CA  SER    88      70.251  26.801  34.847  1.00 35.94           C  
ATOM  13516  C   SER    88      69.374  27.362  33.727  1.00 35.17           C  
ATOM  13517  O   SER    88      69.432  26.891  32.595  1.00 35.24           O  
ATOM  13518  CB  SER    88      69.754  25.418  35.260  1.00 36.16           C  
ATOM  13519  OG  SER    88      68.473  25.510  35.846  1.00 37.19           O  
ATOM  13520  N   LYS    89      68.583  28.382  34.056  1.00 34.43           N  
ATOM  13521  CA  LYS    89      67.792  29.109  33.080  1.00 33.77           C  
ATOM  13522  C   LYS    89      68.571  30.213  32.358  1.00 32.24           C  
ATOM  13523  O   LYS    89      67.994  30.935  31.545  1.00 32.12           O  
ATOM  13524  CB  LYS    89      66.543  29.690  33.739  1.00 34.20           C  
ATOM  13525  CG  LYS    89      65.489  28.606  34.078  1.00 35.37           C  
ATOM  13526  CD  LYS    89      64.197  29.224  34.590  1.00 36.03           C  
ATOM  13527  CE  LYS    89      63.040  28.177  34.705  1.00 37.98           C  
ATOM  13528  NZ  LYS    89      62.891  27.610  36.082  1.00 39.34           N  
ATOM  13529  N   ILE    90      69.865  30.341  32.642  1.00 30.91           N  
ATOM  13530  CA  ILE    90      70.740  31.151  31.793  1.00 30.51           C  
ATOM  13531  C   ILE    90      70.915  30.437  30.434  1.00 30.01           C  
ATOM  13532  O   ILE    90      71.329  29.275  30.387  1.00 31.25           O  
ATOM  13533  CB  ILE    90      72.141  31.392  32.445  1.00 30.19           C  
ATOM  13534  CG1 ILE    90      72.004  32.133  33.787  1.00 29.03           C  
ATOM  13535  CG2 ILE    90      73.086  32.137  31.461  1.00 29.03           C  
ATOM  13536  CD1 ILE    90      73.322  32.266  34.564  1.00 30.48           C  
ATOM  13537  N   ARG    91      70.602  31.114  29.336  1.00 28.51           N  
ATOM  13538  CA  ARG    91      70.882  30.563  28.010  1.00 29.50           C  
ATOM  13539  C   ARG    91      72.270  30.959  27.522  1.00 27.41           C  
ATOM  13540  O   ARG    91      73.007  30.149  26.963  1.00 25.76           O  
ATOM  13541  CB  ARG    91      69.802  30.984  27.021  1.00 29.42           C  
ATOM  13542  CG  ARG    91      68.469  30.319  27.356  1.00 33.12           C  
ATOM  13543  CD  ARG    91      67.261  30.999  26.705  1.00 35.92           C  
ATOM  13544  NE  ARG    91      67.355  31.013  25.251  1.00 43.12           N  
ATOM  13545  CZ  ARG    91      67.218  29.942  24.465  1.00 46.08           C  
ATOM  13546  NH1 ARG    91      66.945  28.734  24.973  1.00 47.97           N  
ATOM  13547  NH2 ARG    91      67.346  30.092  23.143  1.00 46.98           N  
ATOM  13548  N   ARG    92      72.634  32.203  27.780  1.00 25.79           N  
ATOM  13549  CA  ARG    92      73.916  32.748  27.347  1.00 25.72           C  
ATOM  13550  C   ARG    92      74.201  34.042  28.094  1.00 23.76           C  
ATOM  13551  O   ARG    92      73.289  34.873  28.245  1.00 22.58           O  
ATOM  13552  CB  ARG    92      73.835  33.054  25.862  1.00 26.82           C  
ATOM  13553  CG  ARG    92      74.885  33.989  25.316  1.00 31.69           C  
ATOM  13554  CD  ARG    92      75.607  33.399  24.154  1.00 37.13           C  
ATOM  13555  NE  ARG    92      76.890  32.858  24.594  1.00 40.03           N  
ATOM  13556  CZ  ARG    92      77.376  31.648  24.306  1.00 42.08           C  
ATOM  13557  NH1 ARG    92      76.702  30.777  23.546  1.00 43.85           N  
ATOM  13558  NH2 ARG    92      78.569  31.303  24.771  1.00 40.04           N  
ATOM  13559  N   VAL    93      75.433  34.184  28.586  1.00 21.68           N  
ATOM  13560  CA  VAL    93      75.905  35.473  29.055  1.00 20.41           C  
ATOM  13561  C   VAL    93      76.303  36.221  27.782  1.00 20.28           C  
ATOM  13562  O   VAL    93      77.259  35.856  27.069  1.00 21.18           O  
ATOM  13563  CB  VAL    93      77.080  35.374  30.075  1.00 20.10           C  
ATOM  13564  CG1 VAL    93      77.543  36.778  30.511  1.00 20.34           C  
ATOM  13565  CG2 VAL    93      76.685  34.513  31.307  1.00 20.35           C  
ATOM  13566  N   ILE    94      75.543  37.252  27.472  1.00 19.62           N  
ATOM  13567  CA  ILE    94      75.707  37.970  26.218  1.00 19.82           C  
ATOM  13568  C   ILE    94      76.892  38.962  26.232  1.00 19.77           C  
ATOM  13569  O   ILE    94      77.686  39.016  25.272  1.00 19.63           O  
ATOM  13570  CB  ILE    94      74.405  38.688  25.859  1.00 20.18           C  
ATOM  13571  CG1 ILE    94      73.341  37.638  25.511  1.00 21.26           C  
ATOM  13572  CG2 ILE    94      74.574  39.644  24.658  1.00 20.74           C  
ATOM  13573  CD1 ILE    94      73.669  36.882  24.212  1.00 25.02           C  
ATOM  13574  N   LYS    95      77.009  39.701  27.338  1.00 19.20           N  
ATOM  13575  CA  LYS    95      77.963  40.817  27.444  1.00 18.28           C  
ATOM  13576  C   LYS    95      78.268  41.140  28.913  1.00 18.11           C  
ATOM  13577  O   LYS    95      77.377  41.166  29.740  1.00 17.68           O  
ATOM  13578  CB  LYS    95      77.362  42.031  26.756  1.00 18.02           C  
ATOM  13579  CG  LYS    95      78.180  43.334  26.821  1.00 18.92           C  
ATOM  13580  CD  LYS    95      79.388  43.233  25.899  1.00 17.97           C  
ATOM  13581  CE  LYS    95      80.246  44.514  25.891  1.00 19.41           C  
ATOM  13582  NZ  LYS    95      79.470  45.692  25.394  1.00 20.19           N  
ATOM  13583  N   LEU    96      79.537  41.389  29.220  1.00 18.19           N  
ATOM  13584  CA  LEU    96      79.951  41.957  30.513  1.00 17.80           C  
ATOM  13585  C   LEU    96      80.658  43.271  30.202  1.00 17.10           C  
ATOM  13586  O   LEU    96      81.468  43.325  29.258  1.00 17.15           O  
ATOM  13587  CB  LEU    96      80.942  41.045  31.244  1.00 18.83           C  
ATOM  13588  CG  LEU    96      80.585  39.667  31.800  1.00 20.85           C  
ATOM  13589  CD1 LEU    96      81.711  39.277  32.729  1.00 22.50           C  
ATOM  13590  CD2 LEU    96      79.206  39.674  32.520  1.00 21.93           C  
ATOM  13591  N   ASN    97      80.329  44.321  30.946  1.00 16.61           N  
ATOM  13592  CA  ASN    97      81.130  45.529  30.906  1.00 16.14           C  
ATOM  13593  C   ASN    97      81.933  45.623  32.183  1.00 15.02           C  
ATOM  13594  O   ASN    97      81.375  45.796  33.268  1.00 14.66           O  
ATOM  13595  CB  ASN    97      80.289  46.767  30.662  1.00 16.88           C  
ATOM  13596  CG  ASN    97      79.486  46.689  29.385  1.00 18.53           C  
ATOM  13597  OD1 ASN    97      78.257  46.535  29.404  1.00 23.42           O  
ATOM  13598  ND2 ASN    97      80.171  46.786  28.273  1.00 15.75           N  
ATOM  13599  N   GLY    98      83.256  45.563  32.012  1.00 14.82           N  
ATOM  13600  CA  GLY    98      84.185  45.561  33.119  1.00 15.02           C  
ATOM  13601  C   GLY    98      84.852  46.915  33.285  1.00 15.44           C  
ATOM  13602  O   GLY    98      85.617  47.349  32.412  1.00 16.65           O  
ATOM  13603  N   PHE    99      84.542  47.593  34.386  1.00 15.14           N  
ATOM  13604  CA  PHE    99      85.102  48.870  34.692  1.00 14.44           C  
ATOM  13605  C   PHE    99      86.167  48.697  35.768  1.00 14.30           C  
ATOM  13606  O   PHE    99      85.866  48.199  36.872  1.00 14.95           O  
ATOM  13607  CB  PHE    99      83.973  49.765  35.171  1.00 15.41           C  
ATOM  13608  CG  PHE    99      82.790  49.765  34.262  1.00 16.64           C  
ATOM  13609  CD1 PHE    99      82.914  50.201  32.953  1.00 22.14           C  
ATOM  13610  CD2 PHE    99      81.554  49.354  34.715  1.00 19.51           C  
ATOM  13611  CE1 PHE    99      81.807  50.224  32.110  1.00 22.73           C  
ATOM  13612  CE2 PHE    99      80.456  49.391  33.888  1.00 20.40           C  
ATOM  13613  CZ  PHE    99      80.577  49.822  32.604  1.00 19.17           C  
ATOM  13614  N   VAL   100      87.401  49.093  35.463  1.00 12.97           N  
ATOM  13615  CA  VAL   100      88.533  48.945  36.395  1.00 13.47           C  
ATOM  13616  C   VAL   100      89.113  50.315  36.797  1.00 13.53           C  
ATOM  13617  O   VAL   100      89.639  51.033  35.962  1.00 13.48           O  
ATOM  13618  CB  VAL   100      89.674  48.129  35.768  1.00 12.63           C  
ATOM  13619  CG1 VAL   100      90.810  47.914  36.819  1.00 13.13           C  
ATOM  13620  CG2 VAL   100      89.172  46.827  35.121  1.00 14.55           C  
ATOM  13621  N   ALA   101      89.018  50.651  38.073  1.00 13.61           N  
ATOM  13622  CA  ALA   101      89.573  51.922  38.591  1.00 13.39           C  
ATOM  13623  C   ALA   101      91.080  51.820  38.411  1.00 13.93           C  
ATOM  13624  O   ALA   101      91.703  50.866  38.925  1.00 12.78           O  
ATOM  13625  CB  ALA   101      89.195  52.132  40.064  1.00 13.54           C  
ATOM  13626  N   SER   102      91.652  52.751  37.644  1.00 13.96           N  
ATOM  13627  CA  SER   102      93.014  52.597  37.122  1.00 13.76           C  
ATOM  13628  C   SER   102      93.783  53.879  37.237  1.00 13.85           C  
ATOM  13629  O   SER   102      93.239  54.942  37.020  1.00 13.85           O  
ATOM  13630  CB  SER   102      92.952  52.234  35.615  1.00 13.46           C  
ATOM  13631  OG  SER   102      92.318  50.995  35.346  1.00 15.64           O  
ATOM  13632  N   VAL   103      95.081  53.795  37.542  1.00 14.08           N  
ATOM  13633  CA  VAL   103      95.940  54.957  37.235  1.00 13.49           C  
ATOM  13634  C   VAL   103      96.211  54.943  35.728  1.00 14.32           C  
ATOM  13635  O   VAL   103      96.076  53.907  35.086  1.00 14.13           O  
ATOM  13636  CB  VAL   103      97.260  54.995  38.049  1.00 13.45           C  
ATOM  13637  CG1 VAL   103      96.964  55.212  39.528  1.00 13.30           C  
ATOM  13638  CG2 VAL   103      98.085  53.757  37.857  1.00 14.31           C  
ATOM  13639  N   PRO   104      96.528  56.120  35.158  1.00 14.49           N  
ATOM  13640  CA  PRO   104      96.705  56.218  33.710  1.00 15.18           C  
ATOM  13641  C   PRO   104      97.820  55.375  33.100  1.00 15.45           C  
ATOM  13642  O   PRO   104      97.786  55.109  31.890  1.00 17.16           O  
ATOM  13643  CB  PRO   104      96.935  57.712  33.487  1.00 15.35           C  
ATOM  13644  CG  PRO   104      96.279  58.366  34.685  1.00 16.48           C  
ATOM  13645  CD  PRO   104      96.631  57.440  35.786  1.00 15.15           C  
ATOM  13646  N   GLU   105      98.781  54.941  33.908  1.00 15.63           N  
ATOM  13647  CA  GLU   105      99.839  54.061  33.433  1.00 14.99           C  
ATOM  13648  C   GLU   105      99.426  52.591  33.472  1.00 15.57           C  
ATOM  13649  O   GLU   105     100.143  51.745  32.983  1.00 15.51           O  
ATOM  13650  CB  GLU   105     101.129  54.233  34.247  1.00 15.82           C  
ATOM  13651  CG  GLU   105     101.751  55.606  34.111  1.00 14.48           C  
ATOM  13652  CD  GLU   105     100.908  56.711  34.727  1.00 14.59           C  
ATOM  13653  OE1 GLU   105     100.406  56.563  35.871  1.00 15.16           O  
ATOM  13654  OE2 GLU   105     100.751  57.745  34.035  1.00 15.78           O  
ATOM  13655  N   PHE   106      98.296  52.297  34.120  1.00 15.66           N  
ATOM  13656  CA  PHE   106      97.815  50.921  34.211  1.00 15.19           C  
ATOM  13657  C   PHE   106      97.034  50.567  32.952  1.00 15.21           C  
ATOM  13658  O   PHE   106      96.053  51.238  32.616  1.00 15.33           O  
ATOM  13659  CB  PHE   106      96.970  50.643  35.451  1.00 15.12           C  
ATOM  13660  CG  PHE   106      96.527  49.222  35.524  1.00 14.69           C  
ATOM  13661  CD1 PHE   106      97.460  48.191  35.776  1.00 13.97           C  
ATOM  13662  CD2 PHE   106      95.195  48.878  35.251  1.00 14.24           C  
ATOM  13663  CE1 PHE   106      97.055  46.849  35.796  1.00 16.21           C  
ATOM  13664  CE2 PHE   106      94.808  47.554  35.251  1.00 16.36           C  
ATOM  13665  CZ  PHE   106      95.711  46.545  35.530  1.00 15.69           C  
ATOM  13666  N   VAL   107      97.492  49.515  32.274  1.00 15.49           N  
ATOM  13667  CA  VAL   107      96.959  49.139  30.942  1.00 15.51           C  
ATOM  13668  C   VAL   107      96.660  47.626  30.810  1.00 16.14           C  
ATOM  13669  O   VAL   107      96.676  47.065  29.678  1.00 17.46           O  
ATOM  13670  CB  VAL   107      97.875  49.636  29.813  1.00 15.35           C  
ATOM  13671  CG1 VAL   107      97.910  51.181  29.745  1.00 16.15           C  
ATOM  13672  CG2 VAL   107      99.308  49.001  29.940  1.00 17.34           C  
ATOM  13673  N   GLU   108      96.342  46.976  31.937  1.00 15.75           N  
ATOM  13674  CA  GLU   108      96.023  45.560  31.913  1.00 16.38           C  
ATOM  13675  C   GLU   108      94.628  45.285  32.422  1.00 15.43           C  
ATOM  13676  O   GLU   108      94.352  44.262  33.088  1.00 16.13           O  
ATOM  13677  CB  GLU   108      97.076  44.777  32.693  1.00 16.44           C  
ATOM  13678  CG  GLU   108      98.436  44.788  32.033  1.00 19.85           C  
ATOM  13679  CD  GLU   108      99.523  44.263  32.973  1.00 20.58           C  
ATOM  13680  OE1 GLU   108      99.742  44.801  34.079  1.00 29.71           O  
ATOM  13681  OE2 GLU   108     100.165  43.306  32.588  1.00 28.76           O  
ATOM  13682  N   GLN   109      93.705  46.167  32.065  1.00 15.62           N  
ATOM  13683  CA  GLN   109      92.320  45.982  32.468  1.00 15.33           C  
ATOM  13684  C   GLN   109      91.738  44.684  31.902  1.00 15.79           C  
ATOM  13685  O   GLN   109      90.865  44.105  32.513  1.00 16.28           O  
ATOM  13686  CB  GLN   109      91.473  47.148  32.024  1.00 15.81           C  
ATOM  13687  CG  GLN   109      91.813  48.476  32.661  1.00 14.14           C  
ATOM  13688  CD  GLN   109      92.960  49.238  31.952  1.00 15.09           C  
ATOM  13689  OE1 GLN   109      93.533  48.780  30.938  1.00 14.45           O  
ATOM  13690  NE2 GLN   109      93.277  50.409  32.470  1.00 14.52           N  
ATOM  13691  N   HIS   110      92.217  44.249  30.747  1.00 15.52           N  
ATOM  13692  CA  HIS   110      91.773  42.945  30.180  1.00 15.97           C  
ATOM  13693  C   HIS   110      92.129  41.795  31.114  1.00 15.78           C  
ATOM  13694  O   HIS   110      91.333  40.912  31.357  1.00 16.32           O  
ATOM  13695  CB  HIS   110      92.311  42.739  28.739  1.00 16.72           C  
ATOM  13696  CG  HIS   110      93.809  42.789  28.627  1.00 17.04           C  
ATOM  13697  ND1 HIS   110      94.550  43.909  28.945  1.00 19.60           N  
ATOM  13698  CD2 HIS   110      94.705  41.843  28.259  1.00 22.76           C  
ATOM  13699  CE1 HIS   110      95.839  43.643  28.780  1.00 20.17           C  
ATOM  13700  NE2 HIS   110      95.958  42.394  28.373  1.00 21.32           N  
ATOM  13701  N   LEU   111      93.330  41.821  31.669  1.00 16.38           N  
ATOM  13702  CA  LEU   111      93.763  40.836  32.657  1.00 16.96           C  
ATOM  13703  C   LEU   111      92.924  40.851  33.932  1.00 17.46           C  
ATOM  13704  O   LEU   111      92.575  39.786  34.492  1.00 19.02           O  
ATOM  13705  CB  LEU   111      95.239  41.050  32.982  1.00 17.06           C  
ATOM  13706  CG  LEU   111      96.187  40.875  31.779  1.00 17.72           C  
ATOM  13707  CD1 LEU   111      97.635  40.909  32.274  1.00 21.15           C  
ATOM  13708  CD2 LEU   111      95.918  39.613  30.974  1.00 21.14           C  
ATOM  13709  N   VAL   112      92.592  42.051  34.377  1.00 16.80           N  
ATOM  13710  CA  VAL   112      91.777  42.181  35.584  1.00 16.34           C  
ATOM  13711  C   VAL   112      90.397  41.535  35.335  1.00 16.45           C  
ATOM  13712  O   VAL   112      89.895  40.762  36.156  1.00 17.06           O  
ATOM  13713  CB  VAL   112      91.648  43.658  36.010  1.00 16.03           C  
ATOM  13714  CG1 VAL   112      90.570  43.824  37.097  1.00 14.54           C  
ATOM  13715  CG2 VAL   112      93.046  44.189  36.451  1.00 14.52           C  
ATOM  13716  N   ILE   113      89.783  41.862  34.211  1.00 16.33           N  
ATOM  13717  CA  ILE   113      88.418  41.383  33.939  1.00 16.57           C  
ATOM  13718  C   ILE   113      88.426  39.871  33.602  1.00 17.38           C  
ATOM  13719  O   ILE   113      87.418  39.207  33.835  1.00 17.79           O  
ATOM  13720  CB  ILE   113      87.684  42.255  32.877  1.00 16.97           C  
ATOM  13721  CG1 ILE   113      87.591  43.715  33.353  1.00 16.42           C  
ATOM  13722  CG2 ILE   113      86.275  41.686  32.506  1.00 16.23           C  
ATOM  13723  CD1 ILE   113      86.973  43.943  34.754  1.00 15.38           C  
ATOM  13724  N   ASN   114      89.573  39.326  33.152  1.00 17.62           N  
ATOM  13725  CA  ASN   114      89.721  37.861  33.017  1.00 18.16           C  
ATOM  13726  C   ASN   114      89.370  37.165  34.320  1.00 18.57           C  
ATOM  13727  O   ASN   114      88.867  36.056  34.301  1.00 19.99           O  
ATOM  13728  CB  ASN   114      91.130  37.469  32.547  1.00 18.52           C  
ATOM  13729  CG  ASN   114      91.406  37.829  31.083  1.00 20.10           C  
ATOM  13730  OD1 ASN   114      90.494  38.167  30.316  1.00 22.14           O  
ATOM  13731  ND2 ASN   114      92.665  37.744  30.689  1.00 20.05           N  
ATOM  13732  N   GLY   115      89.585  37.808  35.469  1.00 18.91           N  
ATOM  13733  CA  GLY   115      89.088  37.293  36.757  1.00 19.18           C  
ATOM  13734  C   GLY   115      87.609  36.931  36.679  1.00 19.79           C  
ATOM  13735  O   GLY   115      87.233  35.782  36.939  1.00 21.14           O  
ATOM  13736  N   ALA   116      86.771  37.891  36.267  1.00 19.18           N  
ATOM  13737  CA  ALA   116      85.331  37.638  36.074  1.00 18.73           C  
ATOM  13738  C   ALA   116      85.078  36.648  34.944  1.00 18.77           C  
ATOM  13739  O   ALA   116      84.318  35.704  35.117  1.00 18.13           O  
ATOM  13740  CB  ALA   116      84.563  38.940  35.818  1.00 17.60           C  
ATOM  13741  N   SER   117      85.690  36.872  33.792  1.00 19.29           N  
ATOM  13742  CA  SER   117      85.366  36.092  32.582  1.00 20.10           C  
ATOM  13743  C   SER   117      85.670  34.595  32.784  1.00 20.77           C  
ATOM  13744  O   SER   117      84.865  33.722  32.435  1.00 21.97           O  
ATOM  13745  CB  SER   117      86.103  36.640  31.358  1.00 19.41           C  
ATOM  13746  OG  SER   117      85.662  37.947  31.006  1.00 19.65           O  
ATOM  13747  N   ASN   118      86.810  34.313  33.389  1.00 21.80           N  
ATOM  13748  CA  ASN   118      87.247  32.938  33.669  1.00 21.92           C  
ATOM  13749  C   ASN   118      86.341  32.220  34.666  1.00 22.29           C  
ATOM  13750  O   ASN   118      86.014  31.026  34.477  1.00 23.85           O  
ATOM  13751  CB  ASN   118      88.672  32.936  34.193  1.00 22.14           C  
ATOM  13752  CG  ASN   118      89.692  33.319  33.143  1.00 23.36           C  
ATOM  13753  OD1 ASN   118      89.434  33.295  31.932  1.00 27.40           O  
ATOM  13754  ND2 ASN   118      90.877  33.671  33.606  1.00 27.49           N  
ATOM  13755  N   LEU   119      85.917  32.940  35.707  1.00 22.44           N  
ATOM  13756  CA  LEU   119      85.007  32.396  36.709  1.00 22.17           C  
ATOM  13757  C   LEU   119      83.654  32.058  36.071  1.00 22.24           C  
ATOM  13758  O   LEU   119      83.123  30.945  36.218  1.00 21.77           O  
ATOM  13759  CB  LEU   119      84.863  33.385  37.882  1.00 21.87           C  
ATOM  13760  CG  LEU   119      83.954  32.950  39.040  1.00 21.57           C  
ATOM  13761  CD1 LEU   119      84.343  33.550  40.394  1.00 22.43           C  
ATOM  13762  CD2 LEU   119      82.466  33.213  38.687  1.00 19.84           C  
ATOM  13763  N   ILE   120      83.100  33.014  35.340  1.00 22.68           N  
ATOM  13764  CA  ILE   120      81.797  32.834  34.691  1.00 23.03           C  
ATOM  13765  C   ILE   120      81.822  31.671  33.672  1.00 22.73           C  
ATOM  13766  O   ILE   120      80.921  30.827  33.672  1.00 22.74           O  
ATOM  13767  CB  ILE   120      81.304  34.189  34.057  1.00 22.50           C  
ATOM  13768  CG1 ILE   120      80.907  35.152  35.199  1.00 23.42           C  
ATOM  13769  CG2 ILE   120      80.119  33.969  33.092  1.00 23.23           C  
ATOM  13770  CD1 ILE   120      80.713  36.598  34.811  1.00 24.45           C  
ATOM  13771  N   ALA   121      82.859  31.598  32.846  1.00 22.93           N  
ATOM  13772  CA  ALA   121      82.995  30.525  31.867  1.00 23.71           C  
ATOM  13773  C   ALA   121      83.172  29.164  32.552  1.00 24.46           C  
ATOM  13774  O   ALA   121      82.589  28.167  32.118  1.00 24.40           O  
ATOM  13775  CB  ALA   121      84.153  30.806  30.923  1.00 24.16           C  
ATOM  13776  N   THR   122      83.934  29.146  33.646  1.00 25.07           N  
ATOM  13777  CA  THR   122      84.155  27.929  34.423  1.00 25.52           C  
ATOM  13778  C   THR   122      82.873  27.370  35.045  1.00 25.94           C  
ATOM  13779  O   THR   122      82.621  26.176  34.942  1.00 27.29           O  
ATOM  13780  CB  THR   122      85.229  28.151  35.493  1.00 25.67           C  
ATOM  13781  OG1 THR   122      86.465  28.470  34.828  1.00 25.67           O  
ATOM  13782  CG2 THR   122      85.404  26.905  36.403  1.00 25.84           C  
ATOM  13783  N   VAL   123      82.070  28.205  35.692  1.00 25.64           N  
ATOM  13784  CA  VAL   123      80.892  27.707  36.398  1.00 25.47           C  
ATOM  13785  C   VAL   123      79.727  27.416  35.437  1.00 25.14           C  
ATOM  13786  O   VAL   123      78.923  26.530  35.706  1.00 25.86           O  
ATOM  13787  CB  VAL   123      80.457  28.640  37.539  1.00 25.42           C  
ATOM  13788  CG1 VAL   123      81.594  28.801  38.558  1.00 25.65           C  
ATOM  13789  CG2 VAL   123      79.991  29.985  37.025  1.00 25.96           C  
ATOM  13790  N   LEU   124      79.648  28.132  34.316  1.00 25.53           N  
ATOM  13791  CA  LEU   124      78.543  27.974  33.358  1.00 25.86           C  
ATOM  13792  C   LEU   124      78.893  27.133  32.121  1.00 26.58           C  
ATOM  13793  O   LEU   124      77.992  26.702  31.399  1.00 27.85           O  
ATOM  13794  CB  LEU   124      78.016  29.354  32.906  1.00 25.67           C  
ATOM  13795  CG  LEU   124      77.392  30.242  34.005  1.00 25.75           C  
ATOM  13796  CD1 LEU   124      76.923  31.620  33.473  1.00 24.79           C  
ATOM  13797  CD2 LEU   124      76.239  29.529  34.730  1.00 24.67           C  
ATOM  13798  N   GLY   125      80.171  26.905  31.855  1.00 26.92           N  
ATOM  13799  CA  GLY   125      80.601  26.262  30.617  1.00 27.47           C  
ATOM  13800  C   GLY   125      80.400  27.153  29.401  1.00 28.59           C  
ATOM  13801  O   GLY   125      80.450  28.395  29.501  1.00 27.96           O  
ATOM  13802  N   GLU   126      80.145  26.533  28.247  1.00 29.57           N  
ATOM  13803  CA  GLU   126      80.046  27.272  26.987  1.00 29.15           C  
ATOM  13804  C   GLU   126      79.064  28.438  27.036  1.00 28.94           C  
ATOM  13805  O   GLU   126      79.378  29.497  26.491  1.00 29.44           O  
ATOM  13806  CB  GLU   126      79.695  26.340  25.813  1.00 31.00           C  
ATOM  13807  CG  GLU   126      79.198  27.036  24.521  1.00 32.78           C  
ATOM  13808  CD  GLU   126      80.275  27.849  23.846  1.00 39.95           C  
ATOM  13809  OE1 GLU   126      81.484  27.537  24.067  1.00 43.72           O  
ATOM  13810  OE2 GLU   126      79.914  28.797  23.096  1.00 44.33           O  
ATOM  13811  N   PRO   127      77.872  28.252  27.641  1.00 28.35           N  
ATOM  13812  CA  PRO   127      76.944  29.395  27.735  1.00 27.52           C  
ATOM  13813  C   PRO   127      77.493  30.606  28.480  1.00 26.17           C  
ATOM  13814  O   PRO   127      76.951  31.708  28.316  1.00 25.23           O  
ATOM  13815  CB  PRO   127      75.769  28.854  28.541  1.00 27.48           C  
ATOM  13816  CG  PRO   127      75.825  27.360  28.369  1.00 28.37           C  
ATOM  13817  CD  PRO   127      77.274  27.013  28.195  1.00 29.33           C  
ATOM  13818  N   GLY   128      78.509  30.381  29.316  1.00 24.90           N  
ATOM  13819  CA  GLY   128      79.160  31.456  30.029  1.00 24.87           C  
ATOM  13820  C   GLY   128      80.076  32.338  29.192  1.00 24.95           C  
ATOM  13821  O   GLY   128      80.490  33.405  29.683  1.00 25.60           O  
ATOM  13822  N   ARG   129      80.434  31.920  27.974  1.00 24.08           N  
ATOM  13823  CA  ARG   129      81.368  32.698  27.159  1.00 24.96           C  
ATOM  13824  C   ARG   129      80.614  33.880  26.582  1.00 23.19           C  
ATOM  13825  O   ARG   129      79.509  33.733  26.062  1.00 23.19           O  
ATOM  13826  CB  ARG   129      81.996  31.866  26.065  1.00 25.42           C  
ATOM  13827  CG  ARG   129      82.821  30.711  26.608  1.00 27.86           C  
ATOM  13828  CD  ARG   129      83.309  29.877  25.472  1.00 29.98           C  
ATOM  13829  NE  ARG   129      84.510  30.430  24.867  1.00 34.49           N  
ATOM  13830  CZ  ARG   129      84.825  30.292  23.581  1.00 36.05           C  
ATOM  13831  NH1 ARG   129      84.003  29.656  22.751  1.00 39.31           N  
ATOM  13832  NH2 ARG   129      85.952  30.809  23.108  1.00 35.44           N  
ATOM  13833  N   HIS   130      81.207  35.062  26.690  1.00 21.17           N  
ATOM  13834  CA  HIS   130      80.479  36.305  26.497  1.00 19.81           C  
ATOM  13835  C   HIS   130      81.292  37.340  25.734  1.00 18.95           C  
ATOM  13836  O   HIS   130      82.515  37.310  25.762  1.00 19.32           O  
ATOM  13837  CB  HIS   130      80.174  36.874  27.875  1.00 19.15           C  
ATOM  13838  CG  HIS   130      81.373  36.896  28.779  1.00 19.27           C  
ATOM  13839  ND1 HIS   130      81.715  35.823  29.575  1.00 18.83           N  
ATOM  13840  CD2 HIS   130      82.352  37.826  28.960  1.00 18.82           C  
ATOM  13841  CE1 HIS   130      82.841  36.093  30.215  1.00 19.50           C  
ATOM  13842  NE2 HIS   130      83.245  37.304  29.863  1.00 18.38           N  
ATOM  13843  N   ALA   131      80.591  38.238  25.056  1.00 18.23           N  
ATOM  13844  CA  ALA   131      81.198  39.483  24.562  1.00 17.93           C  
ATOM  13845  C   ALA   131      81.615  40.331  25.788  1.00 17.63           C  
ATOM  13846  O   ALA   131      81.145  40.128  26.900  1.00 18.26           O  
ATOM  13847  CB  ALA   131      80.243  40.256  23.664  1.00 17.85           C  
ATOM  13848  N   ARG   132      82.489  41.306  25.575  1.00 18.24           N  
ATOM  13849  CA  ARG   132      83.035  42.036  26.695  1.00 18.04           C  
ATOM  13850  C   ARG   132      83.617  43.385  26.284  1.00 17.43           C  
ATOM  13851  O   ARG   132      84.088  43.565  25.163  1.00 16.62           O  
ATOM  13852  CB  ARG   132      84.181  41.242  27.282  1.00 17.74           C  
ATOM  13853  CG  ARG   132      84.379  41.473  28.719  1.00 21.52           C  
ATOM  13854  CD  ARG   132      85.559  40.622  29.271  1.00 20.37           C  
ATOM  13855  NE  ARG   132      86.903  41.031  28.837  1.00 22.76           N  
ATOM  13856  CZ  ARG   132      88.019  40.471  29.328  1.00 21.32           C  
ATOM  13857  NH1 ARG   132      87.918  39.544  30.236  1.00 20.78           N  
ATOM  13858  NH2 ARG   132      89.223  40.856  28.939  1.00 22.78           N  
ATOM  13859  N   ALA   133      83.650  44.285  27.244  1.00 16.82           N  
ATOM  13860  CA  ALA   133      84.489  45.509  27.180  1.00 17.17           C  
ATOM  13861  C   ALA   133      85.251  45.582  28.508  1.00 16.48           C  
ATOM  13862  O   ALA   133      84.736  45.177  29.538  1.00 16.92           O  
ATOM  13863  CB  ALA   133      83.642  46.745  26.979  1.00 17.02           C  
ATOM  13864  N   ALA   134      86.494  46.049  28.468  1.00 16.84           N  
ATOM  13865  CA  ALA   134      87.303  46.207  29.665  1.00 16.59           C  
ATOM  13866  C   ALA   134      87.964  47.583  29.548  1.00 16.64           C  
ATOM  13867  O   ALA   134      88.695  47.845  28.578  1.00 17.05           O  
ATOM  13868  CB  ALA   134      88.348  45.119  29.805  1.00 17.16           C  
ATOM  13869  N   VAL   135      87.689  48.463  30.496  1.00 16.16           N  
ATOM  13870  CA  VAL   135      88.099  49.863  30.393  1.00 15.33           C  
ATOM  13871  C   VAL   135      88.602  50.422  31.715  1.00 15.04           C  
ATOM  13872  O   VAL   135      88.202  49.980  32.779  1.00 16.55           O  
ATOM  13873  CB  VAL   135      86.942  50.718  29.835  1.00 15.27           C  
ATOM  13874  CG1 VAL   135      86.621  50.279  28.369  1.00 15.28           C  
ATOM  13875  CG2 VAL   135      85.715  50.631  30.750  1.00 18.02           C  
ATOM  13876  N   GLY   136      89.451  51.440  31.644  1.00 14.42           N  
ATOM  13877  CA  GLY   136      90.007  52.072  32.833  1.00 14.05           C  
ATOM  13878  C   GLY   136      89.283  53.347  33.238  1.00 14.66           C  
ATOM  13879  O   GLY   136      89.192  54.307  32.461  1.00 16.32           O  
ATOM  13880  N   MET   137      88.838  53.366  34.492  1.00 15.74           N  
ATOM  13881  CA  MET   137      88.019  54.428  35.067  1.00 15.53           C  
ATOM  13882  C   MET   137      88.883  55.286  36.016  1.00 14.55           C  
ATOM  13883  O   MET   137      89.870  54.808  36.569  1.00 14.21           O  
ATOM  13884  CB  MET   137      86.856  53.860  35.881  1.00 17.67           C  
ATOM  13885  CG  MET   137      86.263  52.643  35.390  1.00 23.71           C  
ATOM  13886  SD  MET   137      85.665  52.752  33.523  1.00 32.58          SE  
ATOM  13887  CE  MET   137      84.716  54.461  33.938  1.00 19.25           C  
ATOM  13888  N   ALA   138      88.476  56.527  36.234  1.00 13.88           N  
ATOM  13889  CA  ALA   138      89.141  57.440  37.178  1.00 14.06           C  
ATOM  13890  C   ALA   138      88.955  56.936  38.616  1.00 14.04           C  
ATOM  13891  O   ALA   138      89.862  57.017  39.449  1.00 13.62           O  
ATOM  13892  CB  ALA   138      88.610  58.875  37.047  1.00 13.96           C  
ATOM  13893  N   SER   139      87.774  56.379  38.876  1.00 14.58           N  
ATOM  13894  CA  SER   139      87.388  55.917  40.210  1.00 15.14           C  
ATOM  13895  C   SER   139      85.992  55.291  40.117  1.00 14.88           C  
ATOM  13896  O   SER   139      85.324  55.457  39.108  1.00 14.48           O  
ATOM  13897  CB  SER   139      87.394  57.083  41.230  1.00 15.80           C  
ATOM  13898  OG  SER   139      86.720  58.247  40.755  1.00 16.73           O  
ATOM  13899  N   LEU   140      85.553  54.651  41.200  1.00 15.44           N  
ATOM  13900  CA  LEU   140      84.237  53.954  41.240  1.00 15.36           C  
ATOM  13901  C   LEU   140      83.547  54.180  42.597  1.00 15.58           C  
ATOM  13902  O   LEU   140      84.208  54.523  43.587  1.00 15.56           O  
ATOM  13903  CB  LEU   140      84.409  52.450  40.962  1.00 15.93           C  
ATOM  13904  CG  LEU   140      84.909  52.035  39.582  1.00 15.60           C  
ATOM  13905  CD1 LEU   140      85.286  50.549  39.605  1.00 15.22           C  
ATOM  13906  CD2 LEU   140      83.852  52.382  38.482  1.00 15.08           C  
ATOM  13907  N   PRO   141      82.211  54.021  42.644  1.00 15.44           N  
ATOM  13908  CA  PRO   141      81.453  54.136  43.911  1.00 16.14           C  
ATOM  13909  C   PRO   141      82.110  53.334  45.044  1.00 15.92           C  
ATOM  13910  O   PRO   141      82.581  52.199  44.826  1.00 16.30           O  
ATOM  13911  CB  PRO   141      80.075  53.575  43.548  1.00 15.94           C  
ATOM  13912  CG  PRO   141      79.935  53.831  42.101  1.00 15.45           C  
ATOM  13913  CD  PRO   141      81.316  53.727  41.508  1.00 15.64           C  
ATOM  13914  N   PHE   142      82.170  53.939  46.230  1.00 16.28           N  
ATOM  13915  CA  PHE   142      82.733  53.297  47.430  1.00 17.01           C  
ATOM  13916  C   PHE   142      84.216  52.930  47.312  1.00 17.24           C  
ATOM  13917  O   PHE   142      84.742  52.110  48.073  1.00 17.44           O  
ATOM  13918  CB  PHE   142      81.928  52.059  47.803  1.00 18.58           C  
ATOM  13919  CG  PHE   142      80.466  52.336  47.998  1.00 18.46           C  
ATOM  13920  CD1 PHE   142      80.015  52.864  49.180  1.00 21.60           C  
ATOM  13921  CD2 PHE   142      79.559  52.097  46.970  1.00 21.58           C  
ATOM  13922  CE1 PHE   142      78.682  53.137  49.358  1.00 21.61           C  
ATOM  13923  CE2 PHE   142      78.215  52.370  47.137  1.00 22.90           C  
ATOM  13924  CZ  PHE   142      77.776  52.887  48.332  1.00 22.64           C  
ATOM  13925  N   ASN   143      84.878  53.560  46.330  1.00 16.87           N  
ATOM  13926  CA  ASN   143      86.266  53.270  45.999  1.00 15.70           C  
ATOM  13927  C   ASN   143      86.510  51.824  45.587  1.00 15.55           C  
ATOM  13928  O   ASN   143      87.609  51.322  45.736  1.00 16.70           O  
ATOM  13929  CB  ASN   143      87.154  53.677  47.176  1.00 16.04           C  
ATOM  13930  CG  ASN   143      88.588  53.911  46.779  1.00 14.10           C  
ATOM  13931  OD1 ASN   143      88.914  54.151  45.608  1.00 17.82           O  
ATOM  13932  ND2 ASN   143      89.478  53.852  47.779  1.00 17.12           N  
ATOM  13933  N   ALA   144      85.488  51.161  45.023  1.00 15.75           N  
ATOM  13934  CA  ALA   144      85.636  49.826  44.460  1.00 15.29           C  
ATOM  13935  C   ALA   144      86.735  49.841  43.411  1.00 15.28           C  
ATOM  13936  O   ALA   144      86.847  50.796  42.624  1.00 14.89           O  
ATOM  13937  CB  ALA   144      84.350  49.361  43.831  1.00 15.92           C  
ATOM  13938  N   SER   145      87.538  48.785  43.403  1.00 15.49           N  
ATOM  13939  CA  SER   145      88.570  48.650  42.372  1.00 15.37           C  
ATOM  13940  C   SER   145      87.975  48.256  41.005  1.00 15.28           C  
ATOM  13941  O   SER   145      88.503  48.615  39.973  1.00 14.24           O  
ATOM  13942  CB  SER   145      89.687  47.688  42.825  1.00 16.67           C  
ATOM  13943  OG  SER   145      90.313  48.168  44.001  1.00 16.25           O  
ATOM  13944  N   VAL   146      86.877  47.516  41.017  1.00 14.87           N  
ATOM  13945  CA  VAL   146      86.230  47.021  39.809  1.00 15.23           C  
ATOM  13946  C   VAL   146      84.712  47.079  40.031  1.00 15.41           C  
ATOM  13947  O   VAL   146      84.210  46.874  41.153  1.00 15.54           O  
ATOM  13948  CB  VAL   146      86.670  45.536  39.456  1.00 15.05           C  
ATOM  13949  CG1 VAL   146      86.085  45.052  38.089  1.00 15.94           C  
ATOM  13950  CG2 VAL   146      88.232  45.354  39.571  1.00 14.96           C  
ATOM  13951  N   GLU   147      84.007  47.398  38.957  1.00 15.93           N  
ATOM  13952  CA  GLU   147      82.535  47.312  38.856  1.00 15.92           C  
ATOM  13953  C   GLU   147      82.252  46.607  37.524  1.00 15.93           C  
ATOM  13954  O   GLU   147      82.884  46.924  36.508  1.00 15.74           O  
ATOM  13955  CB  GLU   147      81.892  48.684  38.856  1.00 16.26           C  
ATOM  13956  CG  GLU   147      80.408  48.720  38.569  1.00 16.79           C  
ATOM  13957  CD  GLU   147      79.814  50.141  38.566  1.00 17.90           C  
ATOM  13958  OE1 GLU   147      80.472  51.032  39.106  1.00 16.37           O  
ATOM  13959  OE2 GLU   147      78.691  50.362  38.032  1.00 21.33           O  
ATOM  13960  N   ILE   148      81.306  45.667  37.535  1.00 16.14           N  
ATOM  13961  CA  ILE   148      80.988  44.895  36.342  1.00 15.98           C  
ATOM  13962  C   ILE   148      79.476  44.740  36.189  1.00 16.11           C  
ATOM  13963  O   ILE   148      78.794  44.315  37.129  1.00 16.86           O  
ATOM  13964  CB  ILE   148      81.601  43.456  36.330  1.00 16.86           C  
ATOM  13965  CG1 ILE   148      83.118  43.455  36.615  1.00 15.12           C  
ATOM  13966  CG2 ILE   148      81.313  42.831  34.929  1.00 17.11           C  
ATOM  13967  CD1 ILE   148      83.783  42.069  36.538  1.00 16.31           C  
ATOM  13968  N   ASP   149      78.974  45.086  35.011  1.00 15.24           N  
ATOM  13969  CA  ASP   149      77.541  44.879  34.705  1.00 16.84           C  
ATOM  13970  C   ASP   149      77.406  43.805  33.638  1.00 16.71           C  
ATOM  13971  O   ASP   149      78.409  43.329  33.087  1.00 19.31           O  
ATOM  13972  CB  ASP   149      76.857  46.181  34.332  1.00 17.25           C  
ATOM  13973  CG  ASP   149      77.178  46.666  32.924  1.00 18.92           C  
ATOM  13974  OD1 ASP   149      77.717  45.917  32.076  1.00 21.61           O  
ATOM  13975  OD2 ASP   149      76.901  47.857  32.671  1.00 23.19           O  
ATOM  13976  N   ALA   150      76.170  43.403  33.348  1.00 17.03           N  
ATOM  13977  CA  ALA   150      75.979  42.220  32.491  1.00 17.32           C  
ATOM  13978  C   ALA   150      74.653  42.251  31.760  1.00 17.32           C  
ATOM  13979  O   ALA   150      73.681  42.805  32.264  1.00 17.16           O  
ATOM  13980  CB  ALA   150      76.071  40.922  33.290  1.00 16.29           C  
ATOM  13981  N   ILE   151      74.636  41.600  30.597  1.00 17.86           N  
ATOM  13982  CA  ILE   151      73.385  41.298  29.877  1.00 18.64           C  
ATOM  13983  C   ILE   151      73.400  39.782  29.684  1.00 18.58           C  
ATOM  13984  O   ILE   151      74.408  39.216  29.252  1.00 16.46           O  
ATOM  13985  CB  ILE   151      73.295  41.986  28.517  1.00 18.12           C  
ATOM  13986  CG1 ILE   151      73.401  43.521  28.639  1.00 18.70           C  
ATOM  13987  CG2 ILE   151      72.005  41.638  27.832  1.00 18.34           C  
ATOM  13988  CD1 ILE   151      73.738  44.160  27.326  1.00 21.12           C  
ATOM  13989  N   VAL   152      72.296  39.127  30.014  1.00 19.65           N  
ATOM  13990  CA  VAL   152      72.245  37.677  30.062  1.00 20.85           C  
ATOM  13991  C   VAL   152      70.965  37.236  29.312  1.00 21.79           C  
ATOM  13992  O   VAL   152      69.875  37.732  29.595  1.00 23.25           O  
ATOM  13993  CB  VAL   152      72.234  37.157  31.530  1.00 20.51           C  
ATOM  13994  CG1 VAL   152      72.116  35.632  31.552  1.00 20.98           C  
ATOM  13995  CG2 VAL   152      73.472  37.627  32.314  1.00 19.78           C  
ATOM  13996  N   GLU   153      71.111  36.364  28.337  1.00 22.65           N  
ATOM  13997  CA  GLU   153      69.931  35.789  27.677  1.00 23.65           C  
ATOM  13998  C   GLU   153      69.416  34.643  28.566  1.00 23.87           C  
ATOM  13999  O   GLU   153      70.189  33.746  28.945  1.00 23.66           O  
ATOM  14000  CB  GLU   153      70.264  35.289  26.289  1.00 23.38           C  
ATOM  14001  CG  GLU   153      69.041  34.729  25.582  1.00 23.77           C  
ATOM  14002  CD  GLU   153      69.403  34.097  24.286  1.00 25.44           C  
ATOM  14003  OE1 GLU   153      69.856  34.818  23.377  1.00 28.66           O  
ATOM  14004  OE2 GLU   153      69.232  32.859  24.181  1.00 33.72           O  
ATOM  14005  N   ILE   154      68.116  34.683  28.885  1.00 25.68           N  
ATOM  14006  CA  ILE   154      67.500  33.757  29.854  1.00 26.78           C  
ATOM  14007  C   ILE   154      66.314  33.035  29.242  1.00 30.18           C  
ATOM  14008  O   ILE   154      65.740  33.496  28.257  1.00 29.70           O  
ATOM  14009  CB  ILE   154      67.039  34.458  31.150  1.00 26.75           C  
ATOM  14010  CG1 ILE   154      66.053  35.594  30.860  1.00 26.10           C  
ATOM  14011  CG2 ILE   154      68.259  34.960  31.966  1.00 25.49           C  
ATOM  14012  CD1 ILE   154      65.428  36.242  32.107  1.00 26.67           C  
ATOM  14013  N   ASP   155      65.987  31.894  29.838  1.00 34.08           N  
ATOM  14014  CA  ASP   155      64.750  31.169  29.526  1.00 38.39           C  
ATOM  14015  C   ASP   155      63.533  31.867  30.087  1.00 39.81           C  
ATOM  14016  O   ASP   155      63.331  31.884  31.303  1.00 41.42           O  
ATOM  14017  CB  ASP   155      64.825  29.774  30.112  1.00 38.89           C  
ATOM  14018  CG  ASP   155      65.674  28.876  29.280  1.00 42.84           C  
ATOM  14019  OD1 ASP   155      65.266  28.669  28.107  1.00 47.96           O  
ATOM  14020  OD2 ASP   155      66.738  28.398  29.774  1.00 48.12           O  
ATOM  14021  N   VAL   156      62.721  32.426  29.191  1.00 42.19           N  
ATOM  14022  CA  VAL   156      61.502  33.142  29.551  1.00 42.99           C  
ATOM  14023  C   VAL   156      60.299  32.349  29.037  1.00 44.31           C  
ATOM  14024  O   VAL   156      60.430  31.553  28.090  1.00 45.98           O  
ATOM  14025  CB  VAL   156      61.529  34.588  28.958  1.00 43.73           C  
ATOM  14026  CG1 VAL   156      60.139  35.038  28.439  1.00 44.09           C  
ATOM  14027  CG2 VAL   156      62.095  35.575  29.986  1.00 43.38           C  
END
