
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  127 (  948),  selected  127 , name 2uyk_C
# Molecule2: number of CA atoms  152 ( 1118),  selected  152 , name T0423.pdb
# PARAMETERS: 2uyk_C.T0423.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     2_C      M       1           -
LGA    K     3_C      S       2           -
LGA    I     4_C      D       3           -
LGA    I     5_C      V       4           -
LGA    E     6_C      I       5           -
LGA    T     7_C      E       6           -
LGA    -       -      G       7           -
LGA    -       -      R       8           -
LGA    -       -      L       9           -
LGA    -       -      K      10           -
LGA    -       -      E      11           -
LGA    -       -      L      12           -
LGA    -       -      G      13           -
LGA    -       -      F      14           -
LGA    -       -      T      15           -
LGA    -       -      L      16           -
LGA    Q     8_C      P      17          5.866
LGA    R     9_C      V      18          2.428
LGA    A    10_C      -       -           -
LGA    P    11_C      -       -           -
LGA    G    12_C      -       -           -
LGA    A    13_C      -       -           -
LGA    I    14_C      -       -           -
LGA    G    15_C      A      23           #
LGA    P    16_C      A      24          3.551
LGA    -       -      N      25           -
LGA    Y    17_C      Y      26          1.491
LGA    V    18_C      V      27          0.991
LGA    Q    19_C      P      28          0.784
LGA    G    20_C      F      29          0.867
LGA    V    21_C      T      30          1.432
LGA    D    22_C      I      31          2.358
LGA    L    23_C      S      32          2.863
LGA    G    24_C      G      33          3.946
LGA    S    25_C      N      34          1.875
LGA    M    26_C      L      35          1.533
LGA    V    27_C      L      36          1.088
LGA    F    28_C      Y      37          0.857
LGA    T    29_C      V      38          0.919
LGA    S    30_C      S      39          0.756
LGA    G    31_C      G      40          0.553
LGA    Q    32_C      Q      41          0.483
LGA    I    33_C      L      42          0.786
LGA    P    34_C      P      43          0.640
LGA    V    35_C      M      44          1.674
LGA    X    36_C      E      45          2.115
LGA    P    37_C      -       -           -
LGA    Q    38_C      -       -           -
LGA    T    39_C      S      46          2.774
LGA    G    40_C      G      47          2.160
LGA    E    41_C      K      48          1.797
LGA    I    42_C      I      49          2.208
LGA    P    43_C      A      50          2.206
LGA    A    44_C      V      51          3.459
LGA    -       -      T      52           -
LGA    -       -      G      53           -
LGA    -       -      L      54           -
LGA    -       -      V      55           -
LGA    -       -      G      56           -
LGA    -       -      R      57           -
LGA    -       -      D      58           -
LGA    -       -      V      59           -
LGA    -       -      D      60           -
LGA    -       -      V      61           -
LGA    -       -      A      62           -
LGA    D    45_C      S      63          2.344
LGA    V    46_C      A      64          1.443
LGA    Q    47_C      Q      65          2.370
LGA    D    48_C      R      66          1.861
LGA    Q    49_C      A      67          0.845
LGA    A    50_C      A      68          0.846
LGA    R    51_C      E      69          0.768
LGA    L    52_C      L      70          0.645
LGA    S    53_C      C      71          0.169
LGA    L    54_C      A      72          0.224
LGA    E    55_C      V      73          0.562
LGA    N    56_C      N      74          0.571
LGA    V    57_C      I      75          0.605
LGA    K    58_C      L      76          0.883
LGA    A    59_C      A      77          1.057
LGA    I    60_C      Q      78          1.132
LGA    V    61_C      V      79          1.300
LGA    V    62_C      K      80          1.857
LGA    A    63_C      A      81          1.705
LGA    A    64_C      A      82          1.900
LGA    G    65_C      L      83          1.883
LGA    -       -      N      84           -
LGA    -       -      G      85           -
LGA    -       -      D      86           -
LGA    -       -      L      87           -
LGA    -       -      S      88           -
LGA    L    66_C      K      89          3.385
LGA    S    67_C      I      90          2.629
LGA    V    68_C      -       -           -
LGA    G    69_C      R      91          4.945
LGA    D    70_C      R      92          2.389
LGA    I    71_C      V      93          1.641
LGA    I    72_C      I      94          0.658
LGA    K    73_C      K      95          1.399
LGA    M    74_C      L      96          1.515
LGA    T    75_C      N      97          0.922
LGA    V    76_C      G      98          0.864
LGA    F    77_C      F      99          1.060
LGA    I    78_C      V     100          1.014
LGA    T    79_C      A     101          1.496
LGA    D    80_C      S     102          2.417
LGA    -       -      V     103           -
LGA    -       -      P     104           -
LGA    -       -      E     105           -
LGA    -       -      F     106           -
LGA    L    81_C      V     107          3.159
LGA    N    82_C      E     108          3.687
LGA    D    83_C      Q     109          4.877
LGA    F    84_C      H     110          3.473
LGA    A    85_C      L     111          1.595
LGA    T    86_C      V     112          3.820
LGA    I    87_C      I     113          3.039
LGA    N    88_C      N     114          1.389
LGA    E    89_C      -       -           -
LGA    V    90_C      G     115          1.880
LGA    Y    91_C      A     116          2.690
LGA    K    92_C      S     117          3.515
LGA    Q    93_C      N     118          2.183
LGA    F    94_C      L     119          1.227
LGA    F    95_C      I     120          2.836
LGA    D    96_C      A     121          2.799
LGA    -       -      T     122           -
LGA    E    97_C      V     123          2.904
LGA    H    98_C      L     124          1.680
LGA    Q    99_C      G     125          0.511
LGA    A   100_C      E     126          3.051
LGA    T   101_C      P     127          3.954
LGA    -       -      G     128           -
LGA    Y   102_C      R     129          1.649
LGA    P   103_C      H     130          1.344
LGA    T   104_C      A     131          1.424
LGA    R   105_C      R     132          1.387
LGA    S   106_C      A     133          1.752
LGA    C   107_C      A     134          1.927
LGA    V   108_C      V     135          1.516
LGA    Q   109_C      G     136          0.970
LGA    V   110_C      M     137          1.421
LGA    A   111_C      A     138          0.978
LGA    R   112_C      S     139          0.879
LGA    L   113_C      L     140          0.516
LGA    P   114_C      P     141          0.419
LGA    K   115_C      F     142          0.813
LGA    D   116_C      N     143          0.896
LGA    V   117_C      A     144          1.005
LGA    K   118_C      S     145          1.296
LGA    L   119_C      V     146          1.122
LGA    E   120_C      E     147          0.820
LGA    I   121_C      I     148          0.745
LGA    E   122_C      D     149          0.767
LGA    A   123_C      A     150          0.765
LGA    I   124_C      I     151          1.053
LGA    A   125_C      V     152          1.259
LGA    V   126_C      E     153          1.617
LGA    R   127_C      I     154          2.427
LGA    S   128_C      D     155          4.392
LGA    -       -      V     156           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  127  152    5.0    111    2.08    27.93     63.817     5.088

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.128346 * X  +  -0.988170 * Y  +   0.083950 * Z  +  92.730255
  Y_new =  -0.949009 * X  +   0.146954 * Y  +   0.278902 * Z  +  54.417683
  Z_new =  -0.287939 * X  +  -0.043874 * Y  +  -0.956643 * Z  +  46.988956 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -3.095763    0.045830  [ DEG:  -177.3741      2.6259 ]
  Theta =   0.292074    2.849519  [ DEG:    16.7346    163.2654 ]
  Phi   =  -1.705223    1.436369  [ DEG:   -97.7021     82.2979 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2uyk_C                                        
REMARK     2: T0423.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2uyk_C.T0423.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  127  152   5.0  111   2.08   27.93  63.817
REMARK  ---------------------------------------------------------- 
MOLECULE 2uyk_C
HEADER    UNKNOWN FUNCTION                        10-APR-07   2UYK              
TITLE     CRYSTAL STRUCTURE OF E. COLI TDCF WITH BOUND SERINE                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN TDCF;                                              
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 SYNONYM: TDCF;                                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 STRAIN: MC4100;                                                      
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21-DE3 GOLD;                             
SOURCE   6 EXPRESSION_SYSTEM_VECTOR: PET28A;                                    
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PETHF1                                    
KEYWDS    UNKNOWN FUNCTION, YJGF/YER057C/UK114 FAMILY, SERINE, TDCF             
KEYWDS   2 PROTEIN, LIGAND BINDING, 2-KETOBUTYRATE                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.D.BURMAN,C.E.M.STEVENSON,R.G.SAWERS,D.M.LAWSON                      
REVDAT   1   29-MAY-07 2UYK    0                                                
JRNL        AUTH   J.D.BURMAN,C.E.M.STEVENSON,R.G.SAWERS,D.M.LAWSON             
JRNL        TITL   THE CRYSTAL STRUCTURE OF ESCHERICHIA COLI TDCF, A            
JRNL        TITL 2 MEMBER OF THE HIGHLY CONSERVED YJGF/YER057C/UK114            
JRNL        TITL 3 FAMILY.                                                      
JRNL        REF    BMC STRUCT.BIOL.              V.   7    30 2007              
JRNL        REFN                UK ESSN 1472-6807                               
REMARK   2 RESOLUTION. 1.60 ANGSTROMS.                                          
DBREF  2UYK A    1   129  UNP    P0AGL2   TDCF_ECOLI       1    129             
DBREF  2UYK B    1   129  UNP    P0AGL2   TDCF_ECOLI       1    129             
DBREF  2UYK C    1   129  UNP    P0AGL2   TDCF_ECOLI       1    129             
SEQRES   1 A  129  MET LYS LYS ILE ILE GLU THR GLN ARG ALA PRO GLY ALA          
SEQRES   2 A  129  ILE GLY PRO TYR VAL GLN GLY VAL ASP LEU GLY SER MET          
SEQRES   3 A  129  VAL PHE THR SER GLY GLN ILE PRO VAL OCS PRO GLN THR          
SEQRES   4 A  129  GLY GLU ILE PRO ALA ASP VAL GLN ASP GLN ALA ARG LEU          
SEQRES   5 A  129  SER LEU GLU ASN VAL LYS ALA ILE VAL VAL ALA ALA GLY          
SEQRES   6 A  129  LEU SER VAL GLY ASP ILE ILE LYS MET THR VAL PHE ILE          
SEQRES   7 A  129  THR ASP LEU ASN ASP PHE ALA THR ILE ASN GLU VAL TYR          
SEQRES   8 A  129  LYS GLN PHE PHE ASP GLU HIS GLN ALA THR TYR PRO THR          
SEQRES   9 A  129  ARG SER CYS VAL GLN VAL ALA ARG LEU PRO LYS ASP VAL          
SEQRES  10 A  129  LYS LEU GLU ILE GLU ALA ILE ALA VAL ARG SER ALA              
SEQRES   1 B  129  MET LYS LYS ILE ILE GLU THR GLN ARG ALA PRO GLY ALA          
SEQRES   2 B  129  ILE GLY PRO TYR VAL GLN GLY VAL ASP LEU GLY SER MET          
SEQRES   3 B  129  VAL PHE THR SER GLY GLN ILE PRO VAL OCS PRO GLN THR          
SEQRES   4 B  129  GLY GLU ILE PRO ALA ASP VAL GLN ASP GLN ALA ARG LEU          
SEQRES   5 B  129  SER LEU GLU ASN VAL LYS ALA ILE VAL VAL ALA ALA GLY          
SEQRES   6 B  129  LEU SER VAL GLY ASP ILE ILE LYS MET THR VAL PHE ILE          
SEQRES   7 B  129  THR ASP LEU ASN ASP PHE ALA THR ILE ASN GLU VAL TYR          
SEQRES   8 B  129  LYS GLN PHE PHE ASP GLU HIS GLN ALA THR TYR PRO THR          
SEQRES   9 B  129  ARG SER CYS VAL GLN VAL ALA ARG LEU PRO LYS ASP VAL          
SEQRES  10 B  129  LYS LEU GLU ILE GLU ALA ILE ALA VAL ARG SER ALA              
SEQRES   1 C  129  MET LYS LYS ILE ILE GLU THR GLN ARG ALA PRO GLY ALA          
SEQRES   2 C  129  ILE GLY PRO TYR VAL GLN GLY VAL ASP LEU GLY SER MET          
SEQRES   3 C  129  VAL PHE THR SER GLY GLN ILE PRO VAL OCS PRO GLN THR          
SEQRES   4 C  129  GLY GLU ILE PRO ALA ASP VAL GLN ASP GLN ALA ARG LEU          
SEQRES   5 C  129  SER LEU GLU ASN VAL LYS ALA ILE VAL VAL ALA ALA GLY          
SEQRES   6 C  129  LEU SER VAL GLY ASP ILE ILE LYS MET THR VAL PHE ILE          
SEQRES   7 C  129  THR ASP LEU ASN ASP PHE ALA THR ILE ASN GLU VAL TYR          
SEQRES   8 C  129  LYS GLN PHE PHE ASP GLU HIS GLN ALA THR TYR PRO THR          
SEQRES   9 C  129  ARG SER CYS VAL GLN VAL ALA ARG LEU PRO LYS ASP VAL          
SEQRES  10 C  129  LYS LEU GLU ILE GLU ALA ILE ALA VAL ARG SER ALA              
HET    OCS  A  36       9                                                       
HET    OCS  B  36       9                                                       
HET    OCS  C  36       9                                                       
HET    SER  C1129       9                                                       
HETNAM     OCS CYSTEINESULFONIC ACID                                            
HETNAM     SER SERINE                                                           
FORMUL   1  OCS    3(C3 H7 N O5 S)                                              
FORMUL   4  SER    C3 H7 N O3                                                   
FORMUL   5  HOH   *457(H2 O)                                                    
CRYST1   72.685   86.351   62.598  90.00  90.00  90.00 P 21 21 2    12          
ATOM   1941  N   LYS C   2      57.994  43.229  33.499  1.00 24.58           N  
ATOM   1942  CA  LYS C   2      58.815  44.320  34.129  1.00 23.57           C  
ATOM   1943  C   LYS C   2      59.074  43.973  35.620  1.00 22.67           C  
ATOM   1944  O   LYS C   2      58.962  44.836  36.523  1.00 25.59           O  
ATOM   1945  CB  LYS C   2      58.119  45.668  33.962  1.00 24.30           C  
ATOM   1946  CG  LYS C   2      58.987  46.931  34.075  1.00 24.89           C  
ATOM   1947  CD  LYS C   2      59.690  47.099  35.432  1.00 28.34           C  
ATOM   1948  N   LYS C   3      59.475  42.722  35.860  1.00 20.59           N  
ATOM   1949  CA  LYS C   3      59.601  42.198  37.188  1.00 19.02           C  
ATOM   1950  C   LYS C   3      60.934  42.619  37.802  1.00 17.47           C  
ATOM   1951  O   LYS C   3      61.978  42.462  37.168  1.00 18.31           O  
ATOM   1952  CB  LYS C   3      59.518  40.674  37.146  1.00 19.47           C  
ATOM   1953  CG  LYS C   3      59.556  40.027  38.482  1.00 22.21           C  
ATOM   1954  N   ILE C   4      60.898  43.135  39.020  1.00 16.99           N  
ATOM   1955  CA  ILE C   4      62.112  43.464  39.748  1.00 16.82           C  
ATOM   1956  C   ILE C   4      62.770  42.199  40.274  1.00 15.60           C  
ATOM   1957  O   ILE C   4      62.104  41.295  40.792  1.00 17.57           O  
ATOM   1958  CB  ILE C   4      61.831  44.424  40.920  1.00 17.81           C  
ATOM   1959  CG1 ILE C   4      61.308  45.765  40.367  1.00 19.53           C  
ATOM   1960  CG2 ILE C   4      63.068  44.603  41.777  1.00 20.09           C  
ATOM   1961  CD1 ILE C   4      60.445  46.498  41.352  1.00 23.89           C  
ATOM   1962  N   ILE C   5      64.086  42.158  40.199  1.00 13.60           N  
ATOM   1963  CA  ILE C   5      64.857  41.042  40.757  1.00 13.56           C  
ATOM   1964  C   ILE C   5      65.464  41.522  42.057  1.00 14.60           C  
ATOM   1965  O   ILE C   5      66.069  42.617  42.123  1.00 13.84           O  
ATOM   1966  CB  ILE C   5      65.976  40.569  39.772  1.00 12.96           C  
ATOM   1967  CG1 ILE C   5      65.391  40.272  38.403  1.00 13.04           C  
ATOM   1968  CG2 ILE C   5      66.720  39.347  40.323  1.00 13.74           C  
ATOM   1969  CD1 ILE C   5      66.424  40.022  37.337  1.00 15.86           C  
ATOM   1970  N   GLU C   6      65.271  40.721  43.108  1.00 15.90           N  
ATOM   1971  CA  GLU C   6      65.798  41.023  44.420  1.00 16.74           C  
ATOM   1972  C   GLU C   6      66.364  39.722  45.005  1.00 16.04           C  
ATOM   1973  O   GLU C   6      65.653  38.712  45.096  1.00 18.23           O  
ATOM   1974  CB  GLU C   6      64.677  41.628  45.300  1.00 17.72           C  
ATOM   1975  CG  GLU C   6      65.106  42.325  46.606  1.00 20.25           C  
ATOM   1976  CD  GLU C   6      64.049  43.341  47.118  1.00 23.52           C  
ATOM   1977  OE1 GLU C   6      62.875  43.347  46.630  1.00 30.33           O  
ATOM   1978  OE2 GLU C   6      64.416  44.177  47.973  1.00 32.84           O  
ATOM   1979  N   THR C   7      67.642  39.740  45.371  1.00 14.22           N  
ATOM   1980  CA  THR C   7      68.327  38.581  45.941  1.00 13.93           C  
ATOM   1981  C   THR C   7      69.254  39.007  47.074  1.00 13.68           C  
ATOM   1982  O   THR C   7      69.887  40.063  47.000  1.00 13.50           O  
ATOM   1983  CB  THR C   7      69.135  37.780  44.893  1.00 14.06           C  
ATOM   1984  OG1 THR C   7      69.879  36.738  45.538  1.00 15.35           O  
ATOM   1985  CG2 THR C   7      70.106  38.676  44.171  1.00 13.76           C  
ATOM   1986  N   GLN C   8      69.352  38.175  48.112  1.00 13.88           N  
ATOM   1987  CA  GLN C   8      70.306  38.394  49.188  1.00 14.66           C  
ATOM   1988  C   GLN C   8      71.728  37.959  48.851  1.00 14.19           C  
ATOM   1989  O   GLN C   8      72.656  38.193  49.626  1.00 15.54           O  
ATOM   1990  CB  GLN C   8      69.839  37.683  50.474  1.00 15.67           C  
ATOM   1991  CG  GLN C   8      68.511  38.195  50.971  1.00 19.72           C  
ATOM   1992  CD  GLN C   8      68.535  38.593  52.431  1.00 25.46           C  
ATOM   1993  OE1 GLN C   8      69.560  39.067  52.943  1.00 30.88           O  
ATOM   1994  NE2 GLN C   8      67.403  38.419  53.115  1.00 27.90           N  
ATOM   1995  N   ARG C   9      71.906  37.302  47.706  1.00 14.01           N  
ATOM   1996  CA  ARG C   9      73.221  36.823  47.269  1.00 14.88           C  
ATOM   1997  C   ARG C   9      74.017  37.857  46.444  1.00 14.49           C  
ATOM   1998  O   ARG C   9      75.108  37.544  45.941  1.00 15.14           O  
ATOM   1999  CB  ARG C   9      73.071  35.521  46.461  1.00 15.69           C  
ATOM   2000  CG  ARG C   9      72.909  34.250  47.275  1.00 18.92           C  
ATOM   2001  CD  ARG C   9      73.506  32.990  46.540  1.00 18.59           C  
ATOM   2002  N   ALA C  10      73.435  39.046  46.270  1.00 14.36           N  
ATOM   2003  CA  ALA C  10      74.149  40.244  45.808  1.00 13.73           C  
ATOM   2004  C   ALA C  10      73.857  41.384  46.790  1.00 13.21           C  
ATOM   2005  O   ALA C  10      72.825  41.365  47.478  1.00 12.51           O  
ATOM   2006  CB  ALA C  10      73.679  40.633  44.397  1.00 14.35           C  
ATOM   2007  N   PRO C  11      74.763  42.370  46.894  1.00 13.93           N  
ATOM   2008  CA  PRO C  11      74.565  43.443  47.851  1.00 14.02           C  
ATOM   2009  C   PRO C  11      73.233  44.128  47.660  1.00 14.83           C  
ATOM   2010  O   PRO C  11      72.814  44.364  46.514  1.00 14.70           O  
ATOM   2011  CB  PRO C  11      75.668  44.443  47.509  1.00 14.66           C  
ATOM   2012  CG  PRO C  11      76.676  43.685  46.774  1.00 15.21           C  
ATOM   2013  CD  PRO C  11      76.049  42.473  46.188  1.00 13.60           C  
ATOM   2014  N   GLY C  12      72.546  44.428  48.750  1.00 16.46           N  
ATOM   2015  CA  GLY C  12      71.284  45.158  48.667  1.00 17.93           C  
ATOM   2016  C   GLY C  12      71.522  46.529  48.037  1.00 18.88           C  
ATOM   2017  O   GLY C  12      72.602  47.074  48.145  1.00 20.30           O  
ATOM   2018  N   ALA C  13      70.525  47.080  47.349  1.00 21.69           N  
ATOM   2019  CA  ALA C  13      70.708  48.395  46.711  1.00 22.34           C  
ATOM   2020  C   ALA C  13      71.004  49.526  47.715  1.00 23.32           C  
ATOM   2021  O   ALA C  13      70.191  49.824  48.577  1.00 26.21           O  
ATOM   2022  CB  ALA C  13      69.476  48.757  45.899  1.00 22.72           C  
ATOM   2023  N   ILE C  14      72.171  50.152  47.580  1.00 23.90           N  
ATOM   2024  CA  ILE C  14      72.472  51.386  48.295  1.00 24.18           C  
ATOM   2025  C   ILE C  14      71.444  52.411  47.751  1.00 23.74           C  
ATOM   2026  O   ILE C  14      70.292  52.444  48.214  1.00 26.67           O  
ATOM   2027  CB  ILE C  14      74.023  51.763  48.216  1.00 24.69           C  
ATOM   2028  CG1 ILE C  14      74.652  51.463  46.842  1.00 25.77           C  
ATOM   2029  CG2 ILE C  14      74.791  50.932  49.220  1.00 27.38           C  
ATOM   2030  CD1 ILE C  14      76.004  52.095  46.540  1.00 26.15           C  
ATOM   2031  N   GLY C  15      71.796  53.145  46.709  1.00 23.08           N  
ATOM   2032  CA  GLY C  15      70.911  54.187  46.174  1.00 21.03           C  
ATOM   2033  C   GLY C  15      69.615  53.738  45.439  1.00 20.22           C  
ATOM   2034  O   GLY C  15      69.184  52.586  45.555  1.00 21.65           O  
ATOM   2035  N   PRO C  16      68.969  54.677  44.682  1.00 18.60           N  
ATOM   2036  CA  PRO C  16      67.662  54.572  43.996  1.00 16.05           C  
ATOM   2037  C   PRO C  16      67.764  53.729  42.698  1.00 14.73           C  
ATOM   2038  O   PRO C  16      67.759  54.267  41.604  1.00 12.80           O  
ATOM   2039  CB  PRO C  16      67.345  56.027  43.683  1.00 15.12           C  
ATOM   2040  CG  PRO C  16      68.679  56.643  43.482  1.00 16.59           C  
ATOM   2041  CD  PRO C  16      69.590  55.995  44.441  1.00 18.74           C  
ATOM   2042  N   TYR C  17      67.942  52.431  42.891  1.00 13.28           N  
ATOM   2043  CA  TYR C  17      68.081  51.465  41.806  1.00 12.41           C  
ATOM   2044  C   TYR C  17      67.640  50.111  42.323  1.00 11.79           C  
ATOM   2045  O   TYR C  17      67.583  49.896  43.537  1.00 14.17           O  
ATOM   2046  CB  TYR C  17      69.517  51.403  41.254  1.00 13.32           C  
ATOM   2047  CG  TYR C  17      70.547  50.977  42.250  1.00 15.87           C  
ATOM   2048  CD1 TYR C  17      71.270  51.924  42.977  1.00 20.39           C  
ATOM   2049  CD2 TYR C  17      70.795  49.632  42.492  1.00 14.94           C  
ATOM   2050  CE1 TYR C  17      72.200  51.527  43.927  1.00 21.18           C  
ATOM   2051  CE2 TYR C  17      71.735  49.217  43.434  1.00 16.26           C  
ATOM   2052  CZ  TYR C  17      72.418  50.160  44.155  1.00 19.77           C  
ATOM   2053  OH  TYR C  17      73.350  49.741  45.079  1.00 23.31           O  
ATOM   2054  N   VAL C  18      67.306  49.205  41.401  1.00 10.68           N  
ATOM   2055  CA  VAL C  18      67.069  47.803  41.770  1.00 10.10           C  
ATOM   2056  C   VAL C  18      68.224  46.965  41.211  1.00 10.12           C  
ATOM   2057  O   VAL C  18      68.899  47.343  40.267  1.00  9.67           O  
ATOM   2058  CB  VAL C  18      65.694  47.294  41.278  1.00 11.19           C  
ATOM   2059  CG1 VAL C  18      64.558  48.171  41.872  1.00 12.48           C  
ATOM   2060  CG2 VAL C  18      65.609  47.289  39.742  1.00 11.12           C  
ATOM   2061  N   GLN C  19      68.432  45.794  41.795  1.00  9.18           N  
ATOM   2062  CA  GLN C  19      69.537  44.928  41.384  1.00  9.38           C  
ATOM   2063  C   GLN C  19      69.402  44.431  39.931  1.00  9.59           C  
ATOM   2064  O   GLN C  19      70.385  44.319  39.194  1.00  9.42           O  
ATOM   2065  CB  GLN C  19      69.615  43.721  42.298  1.00 10.08           C  
ATOM   2066  CG  GLN C  19      70.001  44.029  43.744  1.00  9.44           C  
ATOM   2067  CD  GLN C  19      69.820  42.784  44.603  1.00 10.63           C  
ATOM   2068  OE1 GLN C  19      68.929  41.977  44.317  1.00 14.46           O  
ATOM   2069  NE2 GLN C  19      70.681  42.581  45.582  1.00 13.89           N  
ATOM   2070  N   GLY C  20      68.196  44.078  39.542  1.00 10.04           N  
ATOM   2071  CA  GLY C  20      67.928  43.582  38.205  1.00 10.14           C  
ATOM   2072  C   GLY C  20      66.479  43.804  37.820  1.00 10.55           C  
ATOM   2073  O   GLY C  20      65.637  44.063  38.686  1.00 10.05           O  
ATOM   2074  N   VAL C  21      66.206  43.742  36.512  1.00 11.78           N  
ATOM   2075  CA  VAL C  21      64.854  43.807  35.971  1.00 11.72           C  
ATOM   2076  C   VAL C  21      64.727  42.713  34.939  1.00 12.26           C  
ATOM   2077  O   VAL C  21      65.618  42.534  34.106  1.00 11.47           O  
ATOM   2078  CB  VAL C  21      64.486  45.198  35.360  1.00 13.08           C  
ATOM   2079  CG1 VAL C  21      65.430  45.565  34.278  1.00 15.16           C  
ATOM   2080  CG2 VAL C  21      63.056  45.189  34.786  1.00 14.79           C  
ATOM   2081  N   ASP C  22      63.608  41.968  35.009  1.00 12.80           N  
ATOM   2082  CA  ASP C  22      63.308  40.872  34.104  1.00 12.96           C  
ATOM   2083  C   ASP C  22      62.152  41.282  33.218  1.00 13.88           C  
ATOM   2084  O   ASP C  22      61.025  41.480  33.702  1.00 13.96           O  
ATOM   2085  CB  ASP C  22      62.950  39.628  34.937  1.00 14.00           C  
ATOM   2086  CG  ASP C  22      62.718  38.393  34.112  1.00 14.39           C  
ATOM   2087  OD1 ASP C  22      62.670  38.458  32.860  1.00 15.54           O  
ATOM   2088  OD2 ASP C  22      62.590  37.329  34.761  1.00 17.39           O  
ATOM   2089  N   LEU C  23      62.460  41.438  31.936  1.00 13.53           N  
ATOM   2090  CA  LEU C  23      61.509  41.860  30.921  1.00 15.48           C  
ATOM   2091  C   LEU C  23      60.869  40.676  30.204  1.00 15.93           C  
ATOM   2092  O   LEU C  23      60.104  40.900  29.246  1.00 18.40           O  
ATOM   2093  CB  LEU C  23      62.204  42.751  29.882  1.00 15.61           C  
ATOM   2094  CG  LEU C  23      63.042  43.921  30.424  1.00 18.02           C  
ATOM   2095  CD1 LEU C  23      63.655  44.723  29.295  1.00 19.78           C  
ATOM   2096  CD2 LEU C  23      62.196  44.799  31.316  1.00 20.09           C  
ATOM   2097  N   GLY C  24      61.203  39.444  30.623  1.00 16.21           N  
ATOM   2098  CA  GLY C  24      60.675  38.222  29.995  1.00 16.70           C  
ATOM   2099  C   GLY C  24      61.596  37.664  28.930  1.00 16.94           C  
ATOM   2100  O   GLY C  24      62.065  36.556  29.050  1.00 20.25           O  
ATOM   2101  N   SER C  25      61.895  38.440  27.900  1.00 17.44           N  
ATOM   2102  CA  SER C  25      62.838  38.039  26.856  1.00 17.60           C  
ATOM   2103  C   SER C  25      64.291  38.283  27.301  1.00 17.00           C  
ATOM   2104  O   SER C  25      65.231  37.673  26.800  1.00 18.16           O  
ATOM   2105  CB  SER C  25      62.619  38.867  25.587  1.00 18.48           C  
ATOM   2106  OG  SER C  25      62.764  40.249  25.839  1.00 22.62           O  
ATOM   2107  N   MET C  26      64.465  39.203  28.221  1.00 16.04           N  
ATOM   2108  CA  MET C  26      65.833  39.597  28.591  1.00 17.20           C  
ATOM   2109  C   MET C  26      65.862  40.199  29.976  1.00 13.97           C  
ATOM   2110  O   MET C  26      64.862  40.710  30.445  1.00 13.34           O  
ATOM   2111  CB  MET C  26      66.464  40.520  27.551  1.00 19.07           C  
ATOM   2112  CG  MET C  26      65.677  41.690  27.198  1.00 20.01           C  
ATOM   2113  SD  MET C  26      66.250  42.611  25.733  1.00 27.21           S  
ATOM   2114  CE  MET C  26      67.840  42.837  26.209  1.00 12.99           C  
ATOM   2115  N   VAL C  27      67.017  40.073  30.612  1.00 11.51           N  
ATOM   2116  CA  VAL C  27      67.245  40.518  31.977  1.00 10.49           C  
ATOM   2117  C   VAL C  27      68.411  41.520  31.974  1.00 10.25           C  
ATOM   2118  O   VAL C  27      69.416  41.246  31.359  1.00 10.80           O  
ATOM   2119  CB  VAL C  27      67.626  39.310  32.857  1.00 10.70           C  
ATOM   2120  CG1 VAL C  27      68.176  39.789  34.209  1.00 11.98           C  
ATOM   2121  CG2 VAL C  27      66.404  38.389  33.031  1.00 11.86           C  
ATOM   2122  N   PHE C  28      68.242  42.678  32.619  1.00 10.00           N  
ATOM   2123  CA  PHE C  28      69.328  43.634  32.807  1.00  9.71           C  
ATOM   2124  C   PHE C  28      69.743  43.629  34.258  1.00  9.96           C  
ATOM   2125  O   PHE C  28      68.885  43.616  35.149  1.00  9.84           O  
ATOM   2126  CB  PHE C  28      68.851  45.044  32.477  1.00 10.84           C  
ATOM   2127  CG  PHE C  28      68.661  45.301  31.023  1.00 11.32           C  
ATOM   2128  CD1 PHE C  28      67.550  44.816  30.335  1.00 12.93           C  
ATOM   2129  CD2 PHE C  28      69.600  46.042  30.331  1.00 11.95           C  
ATOM   2130  CE1 PHE C  28      67.397  45.103  28.980  1.00 13.78           C  
ATOM   2131  CE2 PHE C  28      69.442  46.313  28.981  1.00 14.38           C  
ATOM   2132  CZ  PHE C  28      68.337  45.836  28.316  1.00 13.43           C  
ATOM   2133  N   THR C  29      71.053  43.671  34.518  1.00  9.20           N  
ATOM   2134  CA  THR C  29      71.509  43.917  35.910  1.00  8.68           C  
ATOM   2135  C   THR C  29      72.007  45.366  36.079  1.00  9.06           C  
ATOM   2136  O   THR C  29      72.454  46.030  35.113  1.00  8.34           O  
ATOM   2137  CB  THR C  29      72.621  42.948  36.369  1.00  8.58           C  
ATOM   2138  OG1 THR C  29      73.889  43.393  35.889  1.00  6.98           O  
ATOM   2139  CG2 THR C  29      72.373  41.490  35.887  1.00  9.67           C  
ATOM   2140  N   SER C  30      71.978  45.842  37.321  1.00  8.46           N  
ATOM   2141  CA  SER C  30      72.726  47.036  37.668  1.00  8.99           C  
ATOM   2142  C   SER C  30      74.202  46.689  37.619  1.00  8.90           C  
ATOM   2143  O   SER C  30      74.578  45.508  37.642  1.00  8.77           O  
ATOM   2144  CB  SER C  30      72.336  47.558  39.038  1.00  9.66           C  
ATOM   2145  OG  SER C  30      71.057  48.178  38.953  1.00  8.81           O  
ATOM   2146  N   GLY C  31      75.042  47.716  37.571  1.00  7.59           N  
ATOM   2147  CA  GLY C  31      76.508  47.507  37.602  1.00  8.03           C  
ATOM   2148  C   GLY C  31      76.899  47.017  38.982  1.00  9.21           C  
ATOM   2149  O   GLY C  31      76.557  47.642  39.993  1.00 10.89           O  
ATOM   2150  N   GLN C  32      77.540  45.855  39.047  1.00  9.42           N  
ATOM   2151  CA  GLN C  32      77.917  45.256  40.313  1.00  9.78           C  
ATOM   2152  C   GLN C  32      79.353  45.543  40.671  1.00 10.25           C  
ATOM   2153  O   GLN C  32      80.277  45.344  39.872  1.00 10.14           O  
ATOM   2154  CB  GLN C  32      77.756  43.743  40.255  1.00 10.88           C  
ATOM   2155  CG  GLN C  32      76.355  43.297  39.984  1.00 10.73           C  
ATOM   2156  CD  GLN C  32      75.382  43.830  41.005  1.00 11.33           C  
ATOM   2157  OE1 GLN C  32      75.532  43.591  42.219  1.00 12.14           O  
ATOM   2158  NE2 GLN C  32      74.414  44.612  40.541  1.00 10.06           N  
ATOM   2159  N   ILE C  33      79.520  45.955  41.908  1.00 10.01           N  
ATOM   2160  CA  ILE C  33      80.822  46.215  42.467  1.00 11.14           C  
ATOM   2161  C   ILE C  33      81.209  45.096  43.454  1.00 11.28           C  
ATOM   2162  O   ILE C  33      80.334  44.355  43.943  1.00 11.80           O  
ATOM   2163  CB  ILE C  33      80.869  47.589  43.141  1.00 11.08           C  
ATOM   2164  CG1 ILE C  33      79.797  47.785  44.202  1.00 12.20           C  
ATOM   2165  CG2 ILE C  33      80.761  48.694  42.046  1.00 11.97           C  
ATOM   2166  CD1 ILE C  33      79.976  49.079  45.033  1.00 13.02           C  
ATOM   2167  N   PRO C  34      82.507  44.962  43.725  1.00 11.38           N  
ATOM   2168  CA  PRO C  34      83.015  43.891  44.612  1.00 11.99           C  
ATOM   2169  C   PRO C  34      82.762  44.160  46.113  1.00 13.10           C  
ATOM   2170  O   PRO C  34      83.714  44.361  46.896  1.00 14.58           O  
ATOM   2171  CB  PRO C  34      84.485  43.837  44.251  1.00 12.62           C  
ATOM   2172  CG  PRO C  34      84.794  45.255  43.924  1.00 11.09           C  
ATOM   2173  CD  PRO C  34      83.622  45.725  43.119  1.00 10.76           C  
ATOM   2174  N   VAL C  35      81.492  44.192  46.480  1.00 13.23           N  
ATOM   2175  CA  VAL C  35      81.048  44.335  47.868  1.00 13.97           C  
ATOM   2176  C   VAL C  35      80.426  42.994  48.266  1.00 14.94           C  
ATOM   2177  O   VAL C  35      79.564  42.463  47.562  1.00 14.44           O  
ATOM   2178  CB  VAL C  35      80.008  45.474  48.007  1.00 13.76           C  
ATOM   2179  CG1 VAL C  35      79.288  45.424  49.387  1.00 15.25           C  
ATOM   2180  CG2 VAL C  35      80.669  46.834  47.722  1.00 15.12           C  
HETATM 2181  N   OCS C  36      80.861  42.461  49.405  1.00 16.54           N  
HETATM 2182  CA  OCS C  36      80.390  41.169  49.877  1.00 17.54           C  
HETATM 2183  CB  OCS C  36      81.341  40.694  50.970  1.00 18.00           C  
HETATM 2184  SG  OCS C  36      81.128  39.006  51.461  1.00 22.85           S  
HETATM 2185  C   OCS C  36      78.975  41.332  50.402  1.00 17.09           C  
HETATM 2186  O   OCS C  36      78.712  42.232  51.205  1.00 17.59           O  
HETATM 2187  OD1 OCS C  36      82.234  38.646  52.310  1.00 28.34           O  
HETATM 2188  OD2 OCS C  36      79.892  38.998  52.154  1.00 20.75           O  
HETATM 2189  OD3 OCS C  36      81.124  38.169  50.290  1.00 22.82           O  
ATOM   2190  N   PRO C  37      78.020  40.535  49.876  1.00 17.59           N  
ATOM   2191  CA  PRO C  37      76.605  40.704  50.201  1.00 19.46           C  
ATOM   2192  C   PRO C  37      76.268  40.479  51.676  1.00 20.74           C  
ATOM   2193  O   PRO C  37      75.320  41.089  52.169  1.00 22.09           O  
ATOM   2194  CB  PRO C  37      75.898  39.658  49.320  1.00 19.60           C  
ATOM   2195  CG  PRO C  37      76.909  38.855  48.718  1.00 19.63           C  
ATOM   2196  CD  PRO C  37      78.250  39.461  48.906  1.00 18.07           C  
ATOM   2197  N   GLN C  38      77.038  39.617  52.330  1.00 21.44           N  
ATOM   2198  CA  GLN C  38      76.901  39.299  53.766  1.00 21.69           C  
ATOM   2199  C   GLN C  38      77.526  40.354  54.680  1.00 22.82           C  
ATOM   2200  O   GLN C  38      76.866  40.875  55.597  1.00 24.47           O  
ATOM   2201  CB  GLN C  38      77.559  37.945  54.046  1.00 22.80           C  
ATOM   2202  N   THR C  39      78.796  40.673  54.423  1.00 22.71           N  
ATOM   2203  CA  THR C  39      79.613  41.497  55.334  1.00 22.46           C  
ATOM   2204  C   THR C  39      79.754  42.974  54.932  1.00 21.90           C  
ATOM   2205  O   THR C  39      80.182  43.801  55.747  1.00 23.50           O  
ATOM   2206  CB  THR C  39      81.032  40.938  55.446  1.00 23.01           C  
ATOM   2207  OG1 THR C  39      81.726  41.155  54.209  1.00 23.33           O  
ATOM   2208  CG2 THR C  39      81.014  39.420  55.762  1.00 23.63           C  
ATOM   2209  N   GLY C  40      79.454  43.303  53.672  1.00 20.72           N  
ATOM   2210  CA  GLY C  40      79.613  44.659  53.175  1.00 20.03           C  
ATOM   2211  C   GLY C  40      81.062  45.003  52.881  1.00 19.77           C  
ATOM   2212  O   GLY C  40      81.376  46.123  52.465  1.00 21.91           O  
ATOM   2213  N   GLU C  41      81.961  44.050  53.087  1.00 19.64           N  
ATOM   2214  CA  GLU C  41      83.374  44.309  52.944  1.00 20.36           C  
ATOM   2215  C   GLU C  41      83.801  44.201  51.484  1.00 19.16           C  
ATOM   2216  O   GLU C  41      83.236  43.421  50.704  1.00 18.20           O  
ATOM   2217  CB  GLU C  41      84.193  43.362  53.799  1.00 21.20           C  
ATOM   2218  CG  GLU C  41      83.804  43.388  55.274  1.00 23.66           C  
ATOM   2219  CD  GLU C  41      84.642  42.465  56.185  1.00 26.00           C  
ATOM   2220  OE1 GLU C  41      85.505  41.675  55.695  1.00 33.21           O  
ATOM   2221  OE2 GLU C  41      84.410  42.533  57.427  1.00 33.63           O  
ATOM   2222  N   ILE C  42      84.820  44.979  51.147  1.00 18.62           N  
ATOM   2223  CA  ILE C  42      85.425  44.972  49.828  1.00 17.31           C  
ATOM   2224  C   ILE C  42      86.797  44.295  49.932  1.00 17.50           C  
ATOM   2225  O   ILE C  42      87.680  44.805  50.659  1.00 18.53           O  
ATOM   2226  CB  ILE C  42      85.621  46.425  49.317  1.00 16.72           C  
ATOM   2227  CG1 ILE C  42      84.278  47.105  49.155  1.00 16.70           C  
ATOM   2228  CG2 ILE C  42      86.443  46.453  47.997  1.00 16.96           C  
ATOM   2229  CD1 ILE C  42      84.377  48.592  49.054  1.00 17.06           C  
ATOM   2230  N   PRO C  43      87.001  43.159  49.240  1.00 16.94           N  
ATOM   2231  CA  PRO C  43      88.325  42.506  49.276  1.00 17.39           C  
ATOM   2232  C   PRO C  43      89.457  43.369  48.679  1.00 17.91           C  
ATOM   2233  O   PRO C  43      89.229  44.163  47.756  1.00 18.00           O  
ATOM   2234  CB  PRO C  43      88.133  41.198  48.498  1.00 18.13           C  
ATOM   2235  CG  PRO C  43      86.829  41.303  47.843  1.00 18.31           C  
ATOM   2236  CD  PRO C  43      86.047  42.432  48.378  1.00 17.62           C  
ATOM   2237  N   ALA C  44      90.661  43.216  49.219  1.00 18.53           N  
ATOM   2238  CA  ALA C  44      91.755  44.103  48.843  1.00 19.05           C  
ATOM   2239  C   ALA C  44      92.379  43.781  47.497  1.00 19.26           C  
ATOM   2240  O   ALA C  44      92.784  44.710  46.777  1.00 20.87           O  
ATOM   2241  CB  ALA C  44      92.832  44.134  49.935  1.00 19.42           C  
ATOM   2242  N   ASP C  45      92.479  42.496  47.149  1.00 18.49           N  
ATOM   2243  CA  ASP C  45      93.165  42.068  45.926  1.00 18.30           C  
ATOM   2244  C   ASP C  45      92.207  42.095  44.725  1.00 16.69           C  
ATOM   2245  O   ASP C  45      91.051  41.689  44.840  1.00 16.05           O  
ATOM   2246  CB  ASP C  45      93.734  40.663  46.089  1.00 19.52           C  
ATOM   2247  CG  ASP C  45      94.753  40.307  45.010  1.00 25.19           C  
ATOM   2248  OD1 ASP C  45      95.980  40.305  45.330  1.00 34.39           O  
ATOM   2249  OD2 ASP C  45      94.369  40.033  43.839  1.00 31.19           O  
ATOM   2250  N   VAL C  46      92.721  42.514  43.568  1.00 16.46           N  
ATOM   2251  CA  VAL C  46      91.869  42.663  42.409  1.00 15.40           C  
ATOM   2252  C   VAL C  46      91.350  41.328  41.891  1.00 15.61           C  
ATOM   2253  O   VAL C  46      90.240  41.290  41.335  1.00 14.97           O  
ATOM   2254  CB  VAL C  46      92.538  43.468  41.266  1.00 15.64           C  
ATOM   2255  CG1 VAL C  46      93.624  42.667  40.566  1.00 16.20           C  
ATOM   2256  CG2 VAL C  46      91.460  43.939  40.264  1.00 14.26           C  
ATOM   2257  N   GLN C  47      92.104  40.242  42.087  1.00 15.98           N  
ATOM   2258  CA  GLN C  47      91.637  38.891  41.697  1.00 15.87           C  
ATOM   2259  C   GLN C  47      90.315  38.560  42.429  1.00 15.96           C  
ATOM   2260  O   GLN C  47      89.353  38.052  41.820  1.00 16.95           O  
ATOM   2261  CB  GLN C  47      92.708  37.806  42.010  1.00 17.09           C  
ATOM   2262  N   ASP C  48      90.278  38.877  43.717  1.00 15.39           N  
ATOM   2263  CA  ASP C  48      89.143  38.658  44.590  1.00 15.79           C  
ATOM   2264  C   ASP C  48      88.016  39.609  44.265  1.00 14.09           C  
ATOM   2265  O   ASP C  48      86.864  39.217  44.266  1.00 14.58           O  
ATOM   2266  CB  ASP C  48      89.567  38.803  46.053  1.00 16.42           C  
ATOM   2267  CG  ASP C  48      90.562  37.714  46.481  1.00 20.72           C  
ATOM   2268  OD1 ASP C  48      90.617  36.631  45.856  1.00 24.06           O  
ATOM   2269  OD2 ASP C  48      91.310  37.985  47.439  1.00 25.37           O  
ATOM   2270  N   GLN C  49      88.341  40.864  43.962  1.00 13.43           N  
ATOM   2271  CA  GLN C  49      87.298  41.815  43.532  1.00 12.66           C  
ATOM   2272  C   GLN C  49      86.631  41.369  42.229  1.00 11.71           C  
ATOM   2273  O   GLN C  49      85.385  41.432  42.096  1.00 12.15           O  
ATOM   2274  CB  GLN C  49      87.902  43.211  43.344  1.00 12.94           C  
ATOM   2275  CG  GLN C  49      88.261  43.894  44.637  1.00 13.11           C  
ATOM   2276  CD  GLN C  49      88.470  45.392  44.523  1.00 13.88           C  
ATOM   2277  OE1 GLN C  49      88.015  46.015  43.570  1.00 14.15           O  
ATOM   2278  NE2 GLN C  49      89.156  45.990  45.531  1.00 16.00           N  
ATOM   2279  N   ALA C  50      87.433  40.910  41.271  1.00 10.88           N  
ATOM   2280  CA  ALA C  50      86.899  40.480  39.978  1.00 11.31           C  
ATOM   2281  C   ALA C  50      85.954  39.294  40.196  1.00 11.89           C  
ATOM   2282  O   ALA C  50      84.831  39.283  39.695  1.00 11.31           O  
ATOM   2283  CB  ALA C  50      88.022  40.121  39.016  1.00 11.93           C  
ATOM   2284  N   ARG C  51      86.391  38.321  40.989  1.00 12.73           N  
ATOM   2285  CA  ARG C  51      85.529  37.153  41.241  1.00 13.45           C  
ATOM   2286  C   ARG C  51      84.215  37.576  41.928  1.00 12.58           C  
ATOM   2287  O   ARG C  51      83.150  37.137  41.529  1.00 12.89           O  
ATOM   2288  CB  ARG C  51      86.255  36.135  42.085  1.00 14.70           C  
ATOM   2289  CG  ARG C  51      85.414  34.910  42.379  1.00 17.61           C  
ATOM   2290  CD  ARG C  51      85.161  34.093  41.156  1.00 21.65           C  
ATOM   2291  NE  ARG C  51      84.256  32.976  41.460  1.00 24.40           N  
ATOM   2292  CZ  ARG C  51      84.219  31.836  40.777  1.00 25.26           C  
ATOM   2293  NH1 ARG C  51      85.043  31.633  39.750  1.00 25.36           N  
ATOM   2294  NH2 ARG C  51      83.370  30.875  41.151  1.00 25.14           N  
ATOM   2295  N   LEU C  52      84.291  38.432  42.941  1.00 11.80           N  
ATOM   2296  CA  LEU C  52      83.124  38.861  43.687  1.00 12.59           C  
ATOM   2297  C   LEU C  52      82.126  39.675  42.829  1.00 11.87           C  
ATOM   2298  O   LEU C  52      80.918  39.464  42.899  1.00 10.99           O  
ATOM   2299  CB  LEU C  52      83.568  39.637  44.924  1.00 12.75           C  
ATOM   2300  CG  LEU C  52      82.513  40.142  45.870  1.00 13.83           C  
ATOM   2301  CD1 LEU C  52      81.554  38.985  46.317  1.00 14.75           C  
ATOM   2302  CD2 LEU C  52      83.211  40.836  47.045  1.00 14.26           C  
ATOM   2303  N   SER C  53      82.641  40.566  41.979  1.00 11.52           N  
ATOM   2304  CA  SER C  53      81.754  41.304  41.081  1.00 11.77           C  
ATOM   2305  C   SER C  53      81.007  40.320  40.181  1.00 10.93           C  
ATOM   2306  O   SER C  53      79.808  40.466  39.947  1.00 10.21           O  
ATOM   2307  CB  SER C  53      82.513  42.319  40.216  1.00 12.45           C  
ATOM   2308  OG  SER C  53      83.203  43.254  40.995  1.00 19.43           O  
ATOM   2309  N   LEU C  54      81.721  39.343  39.644  1.00 11.61           N  
ATOM   2310  CA  LEU C  54      81.097  38.333  38.794  1.00 11.25           C  
ATOM   2311  C   LEU C  54      80.074  37.484  39.593  1.00 11.06           C  
ATOM   2312  O   LEU C  54      78.988  37.197  39.092  1.00 11.13           O  
ATOM   2313  CB  LEU C  54      82.160  37.451  38.139  1.00 10.76           C  
ATOM   2314  CG  LEU C  54      82.961  38.159  37.025  1.00 10.20           C  
ATOM   2315  CD1 LEU C  54      84.247  37.406  36.714  1.00 12.15           C  
ATOM   2316  CD2 LEU C  54      82.096  38.314  35.777  1.00 13.28           C  
ATOM   2317  N   GLU C  55      80.394  37.106  40.828  1.00 11.98           N  
ATOM   2318  CA  GLU C  55      79.411  36.359  41.645  1.00 12.45           C  
ATOM   2319  C   GLU C  55      78.160  37.179  41.919  1.00 11.79           C  
ATOM   2320  O   GLU C  55      77.056  36.648  41.919  1.00 11.70           O  
ATOM   2321  CB  GLU C  55      80.029  35.929  42.960  1.00 13.38           C  
ATOM   2322  CG  GLU C  55      81.052  34.903  42.837  1.00 15.54           C  
ATOM   2323  CD  GLU C  55      80.502  33.541  42.450  1.00 20.26           C  
ATOM   2324  OE1 GLU C  55      79.320  33.246  42.705  1.00 24.36           O  
ATOM   2325  OE2 GLU C  55      81.274  32.752  41.880  1.00 26.78           O  
ATOM   2326  N   ASN C  56      78.333  38.479  42.147  1.00 10.34           N  
ATOM   2327  CA  ASN C  56      77.219  39.388  42.330  1.00 10.24           C  
ATOM   2328  C   ASN C  56      76.316  39.468  41.085  1.00 10.41           C  
ATOM   2329  O   ASN C  56      75.082  39.425  41.186  1.00 10.10           O  
ATOM   2330  CB  ASN C  56      77.746  40.773  42.752  1.00 11.41           C  
ATOM   2331  CG  ASN C  56      78.246  40.818  44.213  1.00 11.98           C  
ATOM   2332  OD1 ASN C  56      77.923  39.943  45.028  1.00 12.61           O  
ATOM   2333  ND2 ASN C  56      78.988  41.866  44.555  1.00 10.61           N  
ATOM   2334  N   VAL C  57      76.935  39.554  39.899  1.00  9.21           N  
ATOM   2335  CA  VAL C  57      76.167  39.508  38.644  1.00  9.20           C  
ATOM   2336  C   VAL C  57      75.419  38.175  38.567  1.00  9.74           C  
ATOM   2337  O   VAL C  57      74.226  38.140  38.306  1.00 10.29           O  
ATOM   2338  CB  VAL C  57      77.071  39.649  37.429  1.00  9.49           C  
ATOM   2339  CG1 VAL C  57      76.311  39.307  36.168  1.00  9.74           C  
ATOM   2340  CG2 VAL C  57      77.635  41.081  37.374  1.00 10.31           C  
ATOM   2341  N   LYS C  58      76.149  37.084  38.760  1.00 10.48           N  
ATOM   2342  CA  LYS C  58      75.569  35.736  38.685  1.00 11.30           C  
ATOM   2343  C   LYS C  58      74.357  35.622  39.605  1.00 11.27           C  
ATOM   2344  O   LYS C  58      73.326  35.059  39.196  1.00 11.48           O  
ATOM   2345  CB  LYS C  58      76.613  34.701  39.071  1.00 10.90           C  
ATOM   2346  CG  LYS C  58      76.033  33.272  39.190  1.00 11.68           C  
ATOM   2347  CD  LYS C  58      77.067  32.288  39.527  1.00 13.57           C  
ATOM   2348  CE  LYS C  58      76.427  30.979  39.915  1.00 17.49           C  
ATOM   2349  NZ  LYS C  58      77.409  29.952  40.329  1.00 20.45           N  
ATOM   2350  N   ALA C  59      74.482  36.105  40.845  1.00 11.33           N  
ATOM   2351  CA  ALA C  59      73.372  35.992  41.813  1.00 11.05           C  
ATOM   2352  C   ALA C  59      72.078  36.569  41.247  1.00 10.32           C  
ATOM   2353  O   ALA C  59      70.990  36.036  41.448  1.00 10.25           O  
ATOM   2354  CB  ALA C  59      73.705  36.692  43.161  1.00 11.25           C  
ATOM   2355  N   ILE C  60      72.186  37.705  40.567  1.00  9.15           N  
ATOM   2356  CA  ILE C  60      71.015  38.404  40.045  1.00  9.32           C  
ATOM   2357  C   ILE C  60      70.440  37.643  38.853  1.00  9.98           C  
ATOM   2358  O   ILE C  60      69.232  37.489  38.731  1.00  8.90           O  
ATOM   2359  CB  ILE C  60      71.356  39.889  39.678  1.00  9.16           C  
ATOM   2360  CG1 ILE C  60      71.791  40.655  40.924  1.00  9.95           C  
ATOM   2361  CG2 ILE C  60      70.212  40.571  38.992  1.00 10.48           C  
ATOM   2362  CD1 ILE C  60      72.566  41.921  40.638  1.00  8.73           C  
ATOM   2363  N   VAL C  61      71.318  37.190  37.966  1.00  9.06           N  
ATOM   2364  CA  VAL C  61      70.916  36.403  36.794  1.00  9.79           C  
ATOM   2365  C   VAL C  61      70.223  35.101  37.251  1.00  9.70           C  
ATOM   2366  O   VAL C  61      69.171  34.793  36.763  1.00 10.66           O  
ATOM   2367  CB  VAL C  61      72.128  36.142  35.884  1.00  9.43           C  
ATOM   2368  CG1 VAL C  61      71.793  35.213  34.684  1.00 10.55           C  
ATOM   2369  CG2 VAL C  61      72.648  37.472  35.339  1.00  8.90           C  
ATOM   2370  N   VAL C  62      70.809  34.398  38.210  1.00 10.59           N  
ATOM   2371  CA  VAL C  62      70.250  33.149  38.737  1.00 10.51           C  
ATOM   2372  C   VAL C  62      68.933  33.437  39.483  1.00 10.10           C  
ATOM   2373  O   VAL C  62      67.983  32.634  39.390  1.00 10.49           O  
ATOM   2374  CB  VAL C  62      71.282  32.403  39.590  1.00 10.94           C  
ATOM   2375  CG1 VAL C  62      70.615  31.281  40.451  1.00 12.27           C  
ATOM   2376  CG2 VAL C  62      72.432  31.903  38.723  1.00 12.91           C  
ATOM   2377  N   ALA C  63      68.847  34.581  40.177  1.00 10.27           N  
ATOM   2378  CA  ALA C  63      67.599  34.973  40.849  1.00 10.56           C  
ATOM   2379  C   ALA C  63      66.455  35.127  39.867  1.00 11.15           C  
ATOM   2380  O   ALA C  63      65.294  34.904  40.238  1.00 12.33           O  
ATOM   2381  CB  ALA C  63      67.780  36.256  41.681  1.00 11.01           C  
ATOM   2382  N   ALA C  64      66.772  35.536  38.620  1.00 10.92           N  
ATOM   2383  CA  ALA C  64      65.771  35.663  37.556  1.00 12.39           C  
ATOM   2384  C   ALA C  64      65.432  34.331  36.905  1.00 13.24           C  
ATOM   2385  O   ALA C  64      64.553  34.273  36.054  1.00 15.36           O  
ATOM   2386  CB  ALA C  64      66.262  36.633  36.478  1.00 11.89           C  
ATOM   2387  N   GLY C  65      66.121  33.264  37.300  1.00 12.61           N  
ATOM   2388  CA  GLY C  65      65.885  31.952  36.700  1.00 12.24           C  
ATOM   2389  C   GLY C  65      66.702  31.648  35.476  1.00 12.95           C  
ATOM   2390  O   GLY C  65      66.356  30.775  34.686  1.00 13.67           O  
ATOM   2391  N   LEU C  66      67.794  32.382  35.306  1.00 12.59           N  
ATOM   2392  CA  LEU C  66      68.678  32.188  34.172  1.00 12.56           C  
ATOM   2393  C   LEU C  66      70.044  31.683  34.636  1.00 13.08           C  
ATOM   2394  O   LEU C  66      70.316  31.571  35.831  1.00 12.81           O  
ATOM   2395  CB  LEU C  66      68.782  33.501  33.384  1.00 12.56           C  
ATOM   2396  CG  LEU C  66      67.517  33.939  32.644  1.00 13.64           C  
ATOM   2397  CD1 LEU C  66      67.792  35.268  31.966  1.00 15.16           C  
ATOM   2398  CD2 LEU C  66      66.999  32.875  31.651  1.00 16.22           C  
ATOM   2399  N   SER C  67      70.874  31.309  33.669  1.00 13.17           N  
ATOM   2400  CA  SER C  67      72.197  30.781  33.950  1.00 14.08           C  
ATOM   2401  C   SER C  67      73.296  31.712  33.472  1.00 12.60           C  
ATOM   2402  O   SER C  67      73.051  32.640  32.692  1.00 11.79           O  
ATOM   2403  CB  SER C  67      72.353  29.413  33.297  1.00 15.18           C  
ATOM   2404  OG  SER C  67      72.693  29.485  31.955  1.00 19.90           O  
ATOM   2405  N   VAL C  68      74.509  31.466  33.939  1.00 12.64           N  
ATOM   2406  CA  VAL C  68      75.668  32.248  33.463  1.00 12.74           C  
ATOM   2407  C   VAL C  68      75.739  32.208  31.917  1.00 12.24           C  
ATOM   2408  O   VAL C  68      76.059  33.199  31.271  1.00 12.42           O  
ATOM   2409  CB  VAL C  68      76.972  31.791  34.166  1.00 13.30           C  
ATOM   2410  CG1 VAL C  68      78.240  32.368  33.477  1.00 15.18           C  
ATOM   2411  CG2 VAL C  68      76.919  32.137  35.651  1.00 14.89           C  
ATOM   2412  N   GLY C  69      75.412  31.067  31.318  1.00 12.42           N  
ATOM   2413  CA  GLY C  69      75.450  30.900  29.875  1.00 13.19           C  
ATOM   2414  C   GLY C  69      74.407  31.665  29.108  1.00 13.37           C  
ATOM   2415  O   GLY C  69      74.433  31.690  27.880  1.00 15.71           O  
ATOM   2416  N   ASP C  70      73.463  32.275  29.815  1.00 12.49           N  
ATOM   2417  CA  ASP C  70      72.463  33.129  29.205  1.00 11.74           C  
ATOM   2418  C   ASP C  70      72.917  34.594  29.142  1.00 11.36           C  
ATOM   2419  O   ASP C  70      72.236  35.427  28.544  1.00 10.12           O  
ATOM   2420  CB  ASP C  70      71.173  33.031  30.000  1.00 11.88           C  
ATOM   2421  CG  ASP C  70      70.561  31.649  29.935  1.00 12.75           C  
ATOM   2422  OD1 ASP C  70      70.601  31.017  28.853  1.00 13.27           O  
ATOM   2423  OD2 ASP C  70      70.028  31.186  30.974  1.00 16.46           O  
ATOM   2424  N   ILE C  71      74.058  34.892  29.758  1.00 11.40           N  
ATOM   2425  CA  ILE C  71      74.600  36.239  29.690  1.00 11.24           C  
ATOM   2426  C   ILE C  71      75.135  36.467  28.276  1.00 10.94           C  
ATOM   2427  O   ILE C  71      75.976  35.676  27.785  1.00 12.03           O  
ATOM   2428  CB  ILE C  71      75.694  36.486  30.723  1.00 11.13           C  
ATOM   2429  CG1 ILE C  71      75.145  36.338  32.155  1.00 11.15           C  
ATOM   2430  CG2 ILE C  71      76.304  37.887  30.484  1.00 10.20           C  
ATOM   2431  CD1 ILE C  71      76.226  36.219  33.250  1.00 11.87           C  
ATOM   2432  N   ILE C  72      74.672  37.535  27.630  1.00  9.75           N  
ATOM   2433  CA  ILE C  72      75.074  37.795  26.248  1.00 11.03           C  
ATOM   2434  C   ILE C  72      75.879  39.079  26.060  1.00 10.51           C  
ATOM   2435  O   ILE C  72      76.514  39.224  25.049  1.00 10.26           O  
ATOM   2436  CB  ILE C  72      73.904  37.713  25.259  1.00 12.29           C  
ATOM   2437  CG1 ILE C  72      72.747  38.626  25.631  1.00 12.98           C  
ATOM   2438  CG2 ILE C  72      73.399  36.232  25.189  1.00 15.82           C  
ATOM   2439  CD1 ILE C  72      72.862  40.021  25.202  1.00 16.48           C  
ATOM   2440  N   LYS C  73      75.900  39.947  27.066  1.00  9.97           N  
ATOM   2441  CA  LYS C  73      76.697  41.194  26.983  1.00  9.30           C  
ATOM   2442  C   LYS C  73      77.097  41.592  28.391  1.00  9.61           C  
ATOM   2443  O   LYS C  73      76.271  41.563  29.304  1.00 10.25           O  
ATOM   2444  CB  LYS C  73      75.886  42.304  26.322  1.00 10.31           C  
ATOM   2445  CG  LYS C  73      76.507  43.731  26.332  1.00 11.47           C  
ATOM   2446  CD  LYS C  73      77.718  43.827  25.525  1.00 15.17           C  
ATOM   2447  CE  LYS C  73      78.223  45.255  25.326  1.00 15.87           C  
ATOM   2448  NZ  LYS C  73      78.605  45.910  26.539  1.00 14.51           N  
ATOM   2449  N   MET C  74      78.346  41.999  28.550  1.00  9.47           N  
ATOM   2450  CA  MET C  74      78.797  42.616  29.787  1.00 10.53           C  
ATOM   2451  C   MET C  74      79.539  43.892  29.455  1.00  8.89           C  
ATOM   2452  O   MET C  74      80.105  44.001  28.394  1.00  9.39           O  
ATOM   2453  CB  MET C  74      79.760  41.704  30.563  1.00 10.75           C  
ATOM   2454  CG  MET C  74      79.340  40.284  30.700  1.00 13.74           C  
ATOM   2455  SD  MET C  74      80.064  39.465  32.153  1.00 16.50           S  
ATOM   2456  CE  MET C  74      78.698  39.848  33.026  1.00 10.85           C  
ATOM   2457  N   THR C  75      79.572  44.825  30.383  1.00  8.23           N  
ATOM   2458  CA  THR C  75      80.528  45.923  30.329  1.00  9.20           C  
ATOM   2459  C   THR C  75      81.345  45.859  31.601  1.00  8.72           C  
ATOM   2460  O   THR C  75      80.773  45.748  32.694  1.00  8.23           O  
ATOM   2461  CB  THR C  75      79.836  47.299  30.193  1.00 10.12           C  
ATOM   2462  OG1 THR C  75      78.949  47.274  29.068  1.00 12.22           O  
ATOM   2463  CG2 THR C  75      80.894  48.415  29.993  1.00  9.26           C  
ATOM   2464  N   VAL C  76      82.669  45.919  31.459  1.00  7.83           N  
ATOM   2465  CA  VAL C  76      83.602  45.879  32.566  1.00  8.63           C  
ATOM   2466  C   VAL C  76      84.290  47.236  32.613  1.00  8.34           C  
ATOM   2467  O   VAL C  76      85.041  47.589  31.717  1.00  8.76           O  
ATOM   2468  CB  VAL C  76      84.612  44.734  32.393  1.00  9.03           C  
ATOM   2469  CG1 VAL C  76      85.569  44.713  33.574  1.00  9.61           C  
ATOM   2470  CG2 VAL C  76      83.867  43.366  32.236  1.00 10.46           C  
ATOM   2471  N   PHE C  77      83.959  48.008  33.638  1.00  7.60           N  
ATOM   2472  CA  PHE C  77      84.568  49.317  33.893  1.00  8.04           C  
ATOM   2473  C   PHE C  77      85.648  49.049  34.946  1.00  9.12           C  
ATOM   2474  O   PHE C  77      85.349  48.467  35.994  1.00  8.92           O  
ATOM   2475  CB  PHE C  77      83.564  50.301  34.472  1.00  8.60           C  
ATOM   2476  CG  PHE C  77      82.336  50.518  33.625  1.00  7.51           C  
ATOM   2477  CD1 PHE C  77      82.359  51.419  32.583  1.00  9.07           C  
ATOM   2478  CD2 PHE C  77      81.121  49.900  33.944  1.00  8.94           C  
ATOM   2479  CE1 PHE C  77      81.213  51.700  31.828  1.00 10.05           C  
ATOM   2480  CE2 PHE C  77      79.959  50.178  33.185  1.00 10.23           C  
ATOM   2481  CZ  PHE C  77      80.021  51.072  32.125  1.00  8.83           C  
ATOM   2482  N   ILE C  78      86.880  49.454  34.671  1.00  8.96           N  
ATOM   2483  CA  ILE C  78      88.003  49.238  35.582  1.00  9.74           C  
ATOM   2484  C   ILE C  78      88.705  50.574  35.847  1.00  9.43           C  
ATOM   2485  O   ILE C  78      88.512  51.538  35.108  1.00  8.28           O  
ATOM   2486  CB  ILE C  78      89.001  48.173  34.999  1.00  9.50           C  
ATOM   2487  CG1 ILE C  78      89.778  48.720  33.801  1.00 10.26           C  
ATOM   2488  CG2 ILE C  78      88.276  46.908  34.590  1.00  8.94           C  
ATOM   2489  CD1 ILE C  78      90.888  47.775  33.296  1.00 12.30           C  
ATOM   2490  N   THR C  79      89.478  50.639  36.934  1.00  9.87           N  
ATOM   2491  CA  THR C  79      90.240  51.870  37.253  1.00 10.56           C  
ATOM   2492  C   THR C  79      91.743  51.806  36.886  1.00 10.69           C  
ATOM   2493  O   THR C  79      92.451  52.845  36.907  1.00 10.71           O  
ATOM   2494  CB  THR C  79      90.059  52.252  38.727  1.00 11.52           C  
ATOM   2495  OG1 THR C  79      90.437  51.151  39.551  1.00 12.48           O  
ATOM   2496  CG2 THR C  79      88.596  52.630  39.028  1.00 12.29           C  
ATOM   2497  N   ASP C  80      92.237  50.627  36.518  1.00 10.72           N  
ATOM   2498  CA  ASP C  80      93.657  50.440  36.241  1.00 11.57           C  
ATOM   2499  C   ASP C  80      93.921  49.303  35.254  1.00 12.09           C  
ATOM   2500  O   ASP C  80      93.780  48.129  35.595  1.00 11.49           O  
ATOM   2501  CB  ASP C  80      94.357  50.192  37.581  1.00 12.37           C  
ATOM   2502  CG  ASP C  80      95.850  50.171  37.480  1.00 15.02           C  
ATOM   2503  OD1 ASP C  80      96.405  50.229  36.358  1.00 15.91           O  
ATOM   2504  OD2 ASP C  80      96.463  50.082  38.580  1.00 19.53           O  
ATOM   2505  N   LEU C  81      94.321  49.658  34.039  1.00 13.01           N  
ATOM   2506  CA  LEU C  81      94.624  48.669  33.017  1.00 13.72           C  
ATOM   2507  C   LEU C  81      95.758  47.724  33.378  1.00 13.14           C  
ATOM   2508  O   LEU C  81      95.831  46.632  32.795  1.00 14.26           O  
ATOM   2509  CB  LEU C  81      94.822  49.329  31.639  1.00 13.87           C  
ATOM   2510  CG  LEU C  81      93.476  49.453  30.874  1.00 16.42           C  
ATOM   2511  CD1 LEU C  81      93.495  50.531  29.882  1.00 17.22           C  
ATOM   2512  CD2 LEU C  81      93.078  48.137  30.145  1.00 16.96           C  
ATOM   2513  N   ASN C  82      96.603  48.077  34.354  1.00 13.01           N  
ATOM   2514  CA  ASN C  82      97.578  47.107  34.877  1.00 13.21           C  
ATOM   2515  C   ASN C  82      96.910  45.876  35.494  1.00 13.90           C  
ATOM   2516  O   ASN C  82      97.567  44.827  35.633  1.00 15.17           O  
ATOM   2517  CB  ASN C  82      98.482  47.718  35.941  1.00 12.88           C  
ATOM   2518  CG  ASN C  82      99.580  48.619  35.354  1.00 13.88           C  
ATOM   2519  OD1 ASN C  82      99.910  48.541  34.162  1.00 16.27           O  
ATOM   2520  ND2 ASN C  82     100.148  49.453  36.201  1.00 12.42           N  
ATOM   2521  N   ASP C  83      95.643  46.029  35.907  1.00 13.44           N  
ATOM   2522  CA  ASP C  83      94.844  44.918  36.502  1.00 14.23           C  
ATOM   2523  C   ASP C  83      94.171  44.031  35.452  1.00 14.75           C  
ATOM   2524  O   ASP C  83      93.557  43.013  35.826  1.00 15.58           O  
ATOM   2525  CB  ASP C  83      93.703  45.468  37.364  1.00 14.17           C  
ATOM   2526  CG  ASP C  83      94.144  46.131  38.638  1.00 16.08           C  
ATOM   2527  OD1 ASP C  83      95.232  45.777  39.173  1.00 19.02           O  
ATOM   2528  OD2 ASP C  83      93.362  46.999  39.128  1.00 14.70           O  
ATOM   2529  N   PHE C  84      94.245  44.418  34.181  1.00 14.35           N  
ATOM   2530  CA  PHE C  84      93.424  43.827  33.106  1.00 15.31           C  
ATOM   2531  C   PHE C  84      93.729  42.357  32.897  1.00 14.91           C  
ATOM   2532  O   PHE C  84      92.811  41.560  32.698  1.00 15.46           O  
ATOM   2533  CB  PHE C  84      93.577  44.616  31.801  1.00 16.91           C  
ATOM   2534  CG  PHE C  84      92.483  44.385  30.790  1.00 19.05           C  
ATOM   2535  CD1 PHE C  84      91.162  44.162  31.181  1.00 20.49           C  
ATOM   2536  CD2 PHE C  84      92.765  44.467  29.447  1.00 20.33           C  
ATOM   2537  CE1 PHE C  84      90.162  43.976  30.218  1.00 21.49           C  
ATOM   2538  CE2 PHE C  84      91.742  44.285  28.478  1.00 21.58           C  
ATOM   2539  CZ  PHE C  84      90.462  44.070  28.875  1.00 20.57           C  
ATOM   2540  N   ALA C  85      95.003  41.973  32.901  1.00 14.62           N  
ATOM   2541  CA  ALA C  85      95.332  40.551  32.687  1.00 14.59           C  
ATOM   2542  C   ALA C  85      94.758  39.676  33.800  1.00 14.77           C  
ATOM   2543  O   ALA C  85      94.205  38.596  33.539  1.00 14.34           O  
ATOM   2544  CB  ALA C  85      96.873  40.374  32.560  1.00 15.09           C  
ATOM   2545  N   THR C  86      94.869  40.142  35.037  1.00 14.42           N  
ATOM   2546  CA  THR C  86      94.348  39.422  36.190  1.00 15.55           C  
ATOM   2547  C   THR C  86      92.841  39.322  36.126  1.00 14.43           C  
ATOM   2548  O   THR C  86      92.270  38.244  36.315  1.00 15.01           O  
ATOM   2549  CB  THR C  86      94.792  40.089  37.503  1.00 16.65           C  
ATOM   2550  OG1 THR C  86      96.223  39.991  37.611  1.00 18.67           O  
ATOM   2551  CG2 THR C  86      94.137  39.446  38.722  1.00 16.92           C  
ATOM   2552  N   ILE C  87      92.186  40.451  35.848  1.00 13.25           N  
ATOM   2553  CA  ILE C  87      90.727  40.443  35.677  1.00 12.28           C  
ATOM   2554  C   ILE C  87      90.267  39.488  34.566  1.00 12.10           C  
ATOM   2555  O   ILE C  87      89.298  38.723  34.760  1.00 12.64           O  
ATOM   2556  CB  ILE C  87      90.195  41.871  35.391  1.00 12.02           C  
ATOM   2557  CG1 ILE C  87      90.379  42.768  36.618  1.00 12.23           C  
ATOM   2558  CG2 ILE C  87      88.689  41.835  35.002  1.00 12.29           C  
ATOM   2559  CD1 ILE C  87      90.189  44.295  36.343  1.00 11.75           C  
ATOM   2560  N   ASN C  88      90.947  39.514  33.420  1.00 12.42           N  
ATOM   2561  CA  ASN C  88      90.610  38.635  32.282  1.00 13.39           C  
ATOM   2562  C   ASN C  88      90.750  37.182  32.652  1.00 13.63           C  
ATOM   2563  O   ASN C  88      89.906  36.374  32.256  1.00 13.91           O  
ATOM   2564  CB  ASN C  88      91.457  38.923  31.056  1.00 14.36           C  
ATOM   2565  CG  ASN C  88      90.950  40.073  30.248  1.00 17.31           C  
ATOM   2566  OD1 ASN C  88      89.738  40.227  30.084  1.00 21.16           O  
ATOM   2567  ND2 ASN C  88      91.865  40.873  29.693  1.00 19.48           N  
ATOM   2568  N   GLU C  89      91.795  36.853  33.409  1.00 14.00           N  
ATOM   2569  CA  GLU C  89      92.009  35.466  33.896  1.00 14.78           C  
ATOM   2570  C   GLU C  89      90.829  34.979  34.738  1.00 14.97           C  
ATOM   2571  O   GLU C  89      90.291  33.891  34.520  1.00 15.30           O  
ATOM   2572  CB  GLU C  89      93.339  35.373  34.691  1.00 15.55           C  
ATOM   2573  N   VAL C  90      90.413  35.793  35.694  1.00 13.70           N  
ATOM   2574  CA  VAL C  90      89.318  35.433  36.602  1.00 13.41           C  
ATOM   2575  C   VAL C  90      88.035  35.289  35.781  1.00 12.71           C  
ATOM   2576  O   VAL C  90      87.235  34.362  35.963  1.00 12.60           O  
ATOM   2577  CB  VAL C  90      89.160  36.496  37.705  1.00 13.85           C  
ATOM   2578  CG1 VAL C  90      87.874  36.298  38.536  1.00 15.05           C  
ATOM   2579  CG2 VAL C  90      90.410  36.538  38.605  1.00 15.88           C  
ATOM   2580  N   TYR C  91      87.835  36.252  34.895  1.00 11.85           N  
ATOM   2581  CA  TYR C  91      86.605  36.337  34.093  1.00 11.22           C  
ATOM   2582  C   TYR C  91      86.509  35.096  33.207  1.00 12.27           C  
ATOM   2583  O   TYR C  91      85.455  34.435  33.138  1.00 12.22           O  
ATOM   2584  CB  TYR C  91      86.666  37.626  33.256  1.00 11.37           C  
ATOM   2585  CG  TYR C  91      85.485  38.019  32.417  1.00 10.96           C  
ATOM   2586  CD1 TYR C  91      85.170  37.345  31.229  1.00 11.01           C  
ATOM   2587  CD2 TYR C  91      84.740  39.161  32.745  1.00  9.57           C  
ATOM   2588  CE1 TYR C  91      84.120  37.753  30.424  1.00  9.34           C  
ATOM   2589  CE2 TYR C  91      83.694  39.575  31.947  1.00  9.65           C  
ATOM   2590  CZ  TYR C  91      83.390  38.882  30.784  1.00  9.49           C  
ATOM   2591  OH  TYR C  91      82.379  39.313  29.966  1.00 10.00           O  
ATOM   2592  N   LYS C  92      87.607  34.787  32.532  1.00 12.35           N  
ATOM   2593  CA  LYS C  92      87.657  33.587  31.670  1.00 14.27           C  
ATOM   2594  C   LYS C  92      87.341  32.337  32.502  1.00 14.19           C  
ATOM   2595  O   LYS C  92      86.487  31.517  32.122  1.00 14.76           O  
ATOM   2596  CB  LYS C  92      89.023  33.445  30.985  1.00 14.35           C  
ATOM   2597  CG  LYS C  92      89.154  32.166  30.144  1.00 15.65           C  
ATOM   2598  CD  LYS C  92      90.509  32.007  29.514  1.00 16.43           C  
ATOM   2599  CE  LYS C  92      90.520  30.837  28.552  1.00 19.82           C  
ATOM   2600  NZ  LYS C  92      89.841  31.192  27.275  1.00 24.47           N  
ATOM   2601  N   GLN C  93      88.003  32.184  33.646  1.00 14.92           N  
ATOM   2602  CA  GLN C  93      87.772  30.984  34.488  1.00 15.77           C  
ATOM   2603  C   GLN C  93      86.314  30.875  34.947  1.00 15.00           C  
ATOM   2604  O   GLN C  93      85.749  29.763  35.028  1.00 15.61           O  
ATOM   2605  CB  GLN C  93      88.686  30.949  35.708  1.00 16.38           C  
ATOM   2606  CG  GLN C  93      90.174  30.938  35.398  1.00 21.01           C  
ATOM   2607  N   PHE C  94      85.713  32.025  35.248  1.00 14.45           N  
ATOM   2608  CA  PHE C  94      84.328  32.101  35.730  1.00 14.25           C  
ATOM   2609  C   PHE C  94      83.391  31.521  34.662  1.00 14.38           C  
ATOM   2610  O   PHE C  94      82.528  30.650  34.950  1.00 15.85           O  
ATOM   2611  CB  PHE C  94      83.973  33.549  36.091  1.00 15.15           C  
ATOM   2612  CG  PHE C  94      82.519  33.772  36.427  1.00 15.99           C  
ATOM   2613  CD1 PHE C  94      82.029  33.524  37.693  1.00 18.21           C  
ATOM   2614  CD2 PHE C  94      81.647  34.254  35.459  1.00 15.89           C  
ATOM   2615  CE1 PHE C  94      80.687  33.755  37.986  1.00 17.16           C  
ATOM   2616  CE2 PHE C  94      80.306  34.500  35.760  1.00 18.60           C  
ATOM   2617  CZ  PHE C  94      79.845  34.223  37.012  1.00 17.07           C  
ATOM   2618  N   PHE C  95      83.546  31.972  33.429  1.00 13.45           N  
ATOM   2619  CA  PHE C  95      82.668  31.461  32.368  1.00 12.87           C  
ATOM   2620  C   PHE C  95      82.950  30.011  32.096  1.00 14.12           C  
ATOM   2621  O   PHE C  95      82.004  29.225  31.920  1.00 14.45           O  
ATOM   2622  CB  PHE C  95      82.756  32.329  31.094  1.00 13.02           C  
ATOM   2623  CG  PHE C  95      81.907  33.546  31.206  1.00 12.00           C  
ATOM   2624  CD1 PHE C  95      80.531  33.485  30.947  1.00 10.80           C  
ATOM   2625  CD2 PHE C  95      82.424  34.737  31.745  1.00 13.55           C  
ATOM   2626  CE1 PHE C  95      79.704  34.624  31.156  1.00 11.74           C  
ATOM   2627  CE2 PHE C  95      81.606  35.840  31.957  1.00 12.22           C  
ATOM   2628  CZ  PHE C  95      80.246  35.781  31.647  1.00 12.50           C  
ATOM   2629  N   ASP C  96      84.235  29.651  32.098  1.00 14.21           N  
ATOM   2630  CA  ASP C  96      84.616  28.244  31.874  1.00 15.65           C  
ATOM   2631  C   ASP C  96      84.021  27.334  32.956  1.00 15.68           C  
ATOM   2632  O   ASP C  96      83.578  26.228  32.647  1.00 17.26           O  
ATOM   2633  CB  ASP C  96      86.127  28.066  31.806  1.00 15.16           C  
ATOM   2634  CG  ASP C  96      86.774  28.747  30.598  1.00 15.86           C  
ATOM   2635  OD1 ASP C  96      86.048  29.221  29.684  1.00 17.27           O  
ATOM   2636  OD2 ASP C  96      88.040  28.843  30.582  1.00 17.63           O  
ATOM   2637  N   GLU C  97      84.005  27.775  34.210  1.00 16.40           N  
ATOM   2638  CA  GLU C  97      83.475  26.935  35.318  1.00 17.73           C  
ATOM   2639  C   GLU C  97      81.977  26.642  35.198  1.00 17.84           C  
ATOM   2640  O   GLU C  97      81.455  25.693  35.821  1.00 18.31           O  
ATOM   2641  CB  GLU C  97      83.719  27.611  36.662  1.00 18.79           C  
ATOM   2642  CG  GLU C  97      85.125  27.520  37.115  1.00 21.56           C  
ATOM   2643  CD  GLU C  97      85.425  28.356  38.347  1.00 23.08           C  
ATOM   2644  OE1 GLU C  97      84.487  28.940  38.918  1.00 29.69           O  
ATOM   2645  OE2 GLU C  97      86.615  28.369  38.769  1.00 30.85           O  
ATOM   2646  N   HIS C  98      81.291  27.478  34.433  1.00 17.01           N  
ATOM   2647  CA  HIS C  98      79.858  27.381  34.219  1.00 17.14           C  
ATOM   2648  C   HIS C  98      79.551  26.810  32.845  1.00 17.33           C  
ATOM   2649  O   HIS C  98      78.385  26.792  32.410  1.00 18.78           O  
ATOM   2650  CB  HIS C  98      79.217  28.752  34.426  1.00 17.11           C  
ATOM   2651  CG  HIS C  98      79.196  29.194  35.851  1.00 16.44           C  
ATOM   2652  ND1 HIS C  98      80.234  29.884  36.430  1.00 16.84           N  
ATOM   2653  CD2 HIS C  98      78.286  29.000  36.833  1.00 17.99           C  
ATOM   2654  CE1 HIS C  98      79.967  30.105  37.702  1.00 18.41           C  
ATOM   2655  NE2 HIS C  98      78.791  29.579  37.974  1.00 19.08           N  
ATOM   2656  N   GLN C  99      80.588  26.332  32.167  1.00 17.37           N  
ATOM   2657  CA  GLN C  99      80.496  25.800  30.810  1.00 18.83           C  
ATOM   2658  C   GLN C  99      79.733  26.718  29.860  1.00 18.00           C  
ATOM   2659  O   GLN C  99      78.922  26.284  29.022  1.00 19.17           O  
ATOM   2660  CB  GLN C  99      79.915  24.366  30.841  1.00 19.26           C  
ATOM   2661  CG  GLN C  99      80.678  23.464  31.784  1.00 21.96           C  
ATOM   2662  CD  GLN C  99      80.181  22.049  31.723  1.00 23.81           C  
ATOM   2663  OE1 GLN C  99      79.497  21.578  32.647  1.00 31.22           O  
ATOM   2664  NE2 GLN C  99      80.496  21.359  30.620  1.00 28.97           N  
ATOM   2665  N   ALA C 100      80.042  28.016  30.000  1.00 16.58           N  
ATOM   2666  CA  ALA C 100      79.349  29.102  29.326  1.00 16.32           C  
ATOM   2667  C   ALA C 100      80.231  29.708  28.248  1.00 16.18           C  
ATOM   2668  O   ALA C 100      81.364  30.041  28.524  1.00 16.20           O  
ATOM   2669  CB  ALA C 100      78.977  30.156  30.315  1.00 16.42           C  
ATOM   2670  N   THR C 101      79.678  29.857  27.045  1.00 16.25           N  
ATOM   2671  CA  THR C 101      80.245  30.653  25.958  1.00 16.78           C  
ATOM   2672  C   THR C 101      80.478  32.091  26.444  1.00 14.71           C  
ATOM   2673  O   THR C 101      79.657  32.617  27.221  1.00 15.31           O  
ATOM   2674  CB  THR C 101      79.181  30.740  24.788  1.00 16.88           C  
ATOM   2675  OG1 THR C 101      78.859  29.429  24.312  1.00 24.27           O  
ATOM   2676  CG2 THR C 101      79.685  31.574  23.658  1.00 21.34           C  
ATOM   2677  N   TYR C 102      81.569  32.729  26.007  1.00 13.89           N  
ATOM   2678  CA  TYR C 102      81.828  34.116  26.453  1.00 13.20           C  
ATOM   2679  C   TYR C 102      80.836  35.090  25.845  1.00 12.42           C  
ATOM   2680  O   TYR C 102      80.519  35.003  24.678  1.00 13.68           O  
ATOM   2681  CB  TYR C 102      83.253  34.605  26.165  1.00 13.19           C  
ATOM   2682  CG  TYR C 102      84.301  33.604  26.604  1.00 13.67           C  
ATOM   2683  CD1 TYR C 102      84.307  33.094  27.907  1.00 14.11           C  
ATOM   2684  CD2 TYR C 102      85.278  33.146  25.717  1.00 16.62           C  
ATOM   2685  CE1 TYR C 102      85.249  32.121  28.306  1.00 13.03           C  
ATOM   2686  CE2 TYR C 102      86.217  32.215  26.113  1.00 16.07           C  
ATOM   2687  CZ  TYR C 102      86.194  31.698  27.392  1.00 14.34           C  
ATOM   2688  OH  TYR C 102      87.113  30.736  27.757  1.00 16.87           O  
ATOM   2689  N   PRO C 103      80.331  36.019  26.649  1.00 12.07           N  
ATOM   2690  CA  PRO C 103      79.450  37.050  26.059  1.00 12.00           C  
ATOM   2691  C   PRO C 103      80.193  38.065  25.241  1.00 10.79           C  
ATOM   2692  O   PRO C 103      81.426  38.056  25.209  1.00 10.77           O  
ATOM   2693  CB  PRO C 103      78.798  37.727  27.281  1.00 12.96           C  
ATOM   2694  CG  PRO C 103      79.538  37.315  28.457  1.00 13.44           C  
ATOM   2695  CD  PRO C 103      80.444  36.144  28.105  1.00 12.43           C  
ATOM   2696  N   THR C 104      79.452  38.937  24.553  1.00  8.52           N  
ATOM   2697  CA  THR C 104      80.061  40.167  24.046  1.00  8.93           C  
ATOM   2698  C   THR C 104      80.456  41.024  25.244  1.00  9.38           C  
ATOM   2699  O   THR C 104      79.926  40.877  26.338  1.00  9.32           O  
ATOM   2700  CB  THR C 104      79.143  40.948  23.114  1.00  8.75           C  
ATOM   2701  OG1 THR C 104      77.991  41.402  23.821  1.00 10.53           O  
ATOM   2702  CG2 THR C 104      78.715  40.091  21.908  1.00  9.33           C  
ATOM   2703  N   ARG C 105      81.407  41.927  25.029  1.00  9.25           N  
ATOM   2704  CA  ARG C 105      81.952  42.689  26.126  1.00 10.17           C  
ATOM   2705  C   ARG C 105      82.498  44.008  25.593  1.00 10.25           C  
ATOM   2706  O   ARG C 105      83.016  44.082  24.480  1.00  9.93           O  
ATOM   2707  CB  ARG C 105      83.099  41.942  26.802  1.00 11.21           C  
ATOM   2708  CG  ARG C 105      83.439  42.423  28.160  1.00 12.21           C  
ATOM   2709  CD  ARG C 105      84.488  41.555  28.838  1.00 13.57           C  
ATOM   2710  NE  ARG C 105      85.808  41.814  28.302  1.00 14.87           N  
ATOM   2711  CZ  ARG C 105      86.920  41.236  28.764  1.00 16.30           C  
ATOM   2712  NH1 ARG C 105      86.860  40.360  29.758  1.00 15.87           N  
ATOM   2713  NH2 ARG C 105      88.086  41.558  28.232  1.00 18.53           N  
ATOM   2714  N   SER C 106      82.396  45.017  26.442  1.00  9.68           N  
ATOM   2715  CA  SER C 106      83.160  46.270  26.329  1.00  9.81           C  
ATOM   2716  C   SER C 106      83.950  46.430  27.603  1.00  9.78           C  
ATOM   2717  O   SER C 106      83.498  46.011  28.659  1.00  9.02           O  
ATOM   2718  CB  SER C 106      82.255  47.468  26.126  1.00 11.14           C  
ATOM   2719  OG  SER C 106      81.578  47.346  24.895  1.00 16.36           O  
ATOM   2720  N   CYS C 107      85.134  47.017  27.504  1.00 10.87           N  
ATOM   2721  CA  CYS C 107      86.010  47.237  28.675  1.00 10.57           C  
ATOM   2722  C   CYS C 107      86.715  48.573  28.538  1.00  9.40           C  
ATOM   2723  O   CYS C 107      87.295  48.857  27.509  1.00  8.46           O  
ATOM   2724  CB  CYS C 107      87.058  46.169  28.788  1.00 11.88           C  
ATOM   2725  SG  CYS C 107      88.098  46.356  30.292  1.00 18.95           S  
ATOM   2726  N   VAL C 108      86.604  49.403  29.559  1.00  8.35           N  
ATOM   2727  CA  VAL C 108      87.187  50.714  29.532  1.00  8.09           C  
ATOM   2728  C   VAL C 108      87.771  51.028  30.892  1.00  7.77           C  
ATOM   2729  O   VAL C 108      87.248  50.538  31.892  1.00  7.34           O  
ATOM   2730  CB  VAL C 108      86.143  51.797  29.157  1.00  8.73           C  
ATOM   2731  CG1 VAL C 108      85.461  51.439  27.792  1.00  8.98           C  
ATOM   2732  CG2 VAL C 108      85.064  51.991  30.231  1.00  9.61           C  
ATOM   2733  N   GLN C 109      88.814  51.858  30.931  1.00  7.53           N  
ATOM   2734  CA  GLN C 109      89.339  52.351  32.187  1.00  7.82           C  
ATOM   2735  C   GLN C 109      88.696  53.705  32.475  1.00  8.59           C  
ATOM   2736  O   GLN C 109      88.928  54.700  31.739  1.00  7.13           O  
ATOM   2737  CB  GLN C 109      90.863  52.534  32.156  1.00  8.39           C  
ATOM   2738  CG  GLN C 109      91.428  52.882  33.503  1.00  9.22           C  
ATOM   2739  CD  GLN C 109      92.911  53.181  33.445  1.00  9.45           C  
ATOM   2740  OE1 GLN C 109      93.680  52.349  32.965  1.00 12.90           O  
ATOM   2741  NE2 GLN C 109      93.329  54.351  33.993  1.00 10.89           N  
ATOM   2742  N   VAL C 110      87.885  53.747  33.529  1.00  9.60           N  
ATOM   2743  CA  VAL C 110      87.270  55.002  34.005  1.00 10.24           C  
ATOM   2744  C   VAL C 110      88.174  55.672  35.008  1.00 11.12           C  
ATOM   2745  O   VAL C 110      89.210  55.141  35.380  1.00 11.73           O  
ATOM   2746  CB  VAL C 110      85.873  54.750  34.588  1.00  9.51           C  
ATOM   2747  CG1 VAL C 110      84.990  54.151  33.482  1.00 10.33           C  
ATOM   2748  CG2 VAL C 110      85.955  53.820  35.809  1.00  9.43           C  
ATOM   2749  N   ALA C 111      87.815  56.890  35.405  1.00 10.89           N  
ATOM   2750  CA  ALA C 111      88.576  57.602  36.397  1.00 12.21           C  
ATOM   2751  C   ALA C 111      88.442  57.049  37.828  1.00 12.57           C  
ATOM   2752  O   ALA C 111      89.435  56.885  38.544  1.00 14.94           O  
ATOM   2753  CB  ALA C 111      88.172  59.061  36.351  1.00 12.05           C  
ATOM   2754  N   ARG C 112      87.212  56.759  38.244  1.00 11.41           N  
ATOM   2755  CA  ARG C 112      86.898  56.328  39.607  1.00 12.27           C  
ATOM   2756  C   ARG C 112      85.551  55.594  39.593  1.00 11.17           C  
ATOM   2757  O   ARG C 112      84.704  55.822  38.701  1.00  9.87           O  
ATOM   2758  CB  ARG C 112      86.812  57.556  40.524  1.00 12.10           C  
ATOM   2759  CG  ARG C 112      86.869  57.268  42.031  1.00 14.12           C  
ATOM   2760  CD  ARG C 112      86.989  58.599  42.866  1.00 16.24           C  
ATOM   2761  NE  ARG C 112      86.903  58.353  44.317  1.00 19.38           N  
ATOM   2762  CZ  ARG C 112      86.429  59.195  45.238  1.00 20.68           C  
ATOM   2763  NH1 ARG C 112      85.929  60.392  44.941  1.00 22.51           N  
ATOM   2764  NH2 ARG C 112      86.440  58.818  46.511  1.00 23.52           N  
ATOM   2765  N   LEU C 113      85.373  54.701  40.566  1.00 10.53           N  
ATOM   2766  CA  LEU C 113      84.148  53.939  40.732  1.00 10.92           C  
ATOM   2767  C   LEU C 113      83.588  54.090  42.146  1.00 11.75           C  
ATOM   2768  O   LEU C 113      84.323  54.466  43.071  1.00 12.20           O  
ATOM   2769  CB  LEU C 113      84.412  52.449  40.462  1.00 10.13           C  
ATOM   2770  CG  LEU C 113      84.737  52.137  39.014  1.00  8.80           C  
ATOM   2771  CD1 LEU C 113      85.381  50.755  38.874  1.00  8.19           C  
ATOM   2772  CD2 LEU C 113      83.482  52.338  38.087  1.00  8.99           C  
ATOM   2773  N   PRO C 114      82.280  53.825  42.315  1.00 12.83           N  
ATOM   2774  CA  PRO C 114      81.694  53.893  43.670  1.00 13.65           C  
ATOM   2775  C   PRO C 114      82.511  53.110  44.692  1.00 13.86           C  
ATOM   2776  O   PRO C 114      83.028  52.024  44.404  1.00 13.94           O  
ATOM   2777  CB  PRO C 114      80.296  53.298  43.487  1.00 14.41           C  
ATOM   2778  CG  PRO C 114      79.945  53.581  42.041  1.00 14.34           C  
ATOM   2779  CD  PRO C 114      81.276  53.456  41.295  1.00 13.17           C  
ATOM   2780  N   LYS C 115      82.659  53.693  45.888  1.00 15.11           N  
ATOM   2781  CA  LYS C 115      83.372  53.044  46.997  1.00 16.72           C  
ATOM   2782  C   LYS C 115      84.838  52.733  46.698  1.00 15.96           C  
ATOM   2783  O   LYS C 115      85.494  51.920  47.390  1.00 16.96           O  
ATOM   2784  CB  LYS C 115      82.609  51.786  47.476  1.00 17.20           C  
ATOM   2785  CG  LYS C 115      81.253  52.090  48.114  1.00 18.84           C  
ATOM   2786  CD  LYS C 115      80.668  50.822  48.700  1.00 19.68           C  
ATOM   2787  CE  LYS C 115      79.316  51.022  49.345  1.00 22.60           C  
ATOM   2788  NZ  LYS C 115      78.777  49.757  50.009  1.00 24.50           N  
ATOM   2789  N   ASP C 116      85.367  53.399  45.659  1.00 15.26           N  
ATOM   2790  CA  ASP C 116      86.749  53.277  45.245  1.00 15.56           C  
ATOM   2791  C   ASP C 116      87.189  51.846  44.869  1.00 14.57           C  
ATOM   2792  O   ASP C 116      88.383  51.486  44.934  1.00 15.89           O  
ATOM   2793  CB  ASP C 116      87.668  53.883  46.315  1.00 16.55           C  
ATOM   2794  CG  ASP C 116      87.653  55.394  46.295  1.00 20.78           C  
ATOM   2795  OD1 ASP C 116      87.876  55.974  45.224  1.00 24.32           O  
ATOM   2796  OD2 ASP C 116      87.413  55.983  47.360  1.00 28.88           O  
ATOM   2797  N   VAL C 117      86.215  51.051  44.407  1.00 13.19           N  
ATOM   2798  CA  VAL C 117      86.493  49.681  43.957  1.00 12.38           C  
ATOM   2799  C   VAL C 117      87.294  49.697  42.648  1.00 11.97           C  
ATOM   2800  O   VAL C 117      87.395  50.754  41.986  1.00 11.54           O  
ATOM   2801  CB  VAL C 117      85.187  48.895  43.765  1.00 12.47           C  
ATOM   2802  CG1 VAL C 117      84.425  48.797  45.106  1.00 11.88           C  
ATOM   2803  CG2 VAL C 117      84.313  49.523  42.640  1.00 11.61           C  
ATOM   2804  N   LYS C 118      87.872  48.549  42.280  1.00 10.45           N  
ATOM   2805  CA  LYS C 118      88.742  48.484  41.098  1.00 11.54           C  
ATOM   2806  C   LYS C 118      87.986  48.137  39.808  1.00 10.46           C  
ATOM   2807  O   LYS C 118      88.520  48.268  38.705  1.00 10.40           O  
ATOM   2808  CB  LYS C 118      89.848  47.476  41.331  1.00 11.94           C  
ATOM   2809  CG  LYS C 118      90.744  47.843  42.543  1.00 14.27           C  
ATOM   2810  CD  LYS C 118      91.805  46.771  42.754  1.00 14.17           C  
ATOM   2811  CE  LYS C 118      92.712  47.040  43.981  1.00 17.12           C  
ATOM   2812  NZ  LYS C 118      93.625  48.172  43.816  1.00 20.26           N  
ATOM   2813  N   LEU C 119      86.750  47.683  39.952  1.00  9.80           N  
ATOM   2814  CA  LEU C 119      85.930  47.357  38.781  1.00  9.19           C  
ATOM   2815  C   LEU C 119      84.446  47.356  39.111  1.00  9.31           C  
ATOM   2816  O   LEU C 119      84.034  47.194  40.272  1.00  9.61           O  
ATOM   2817  CB  LEU C 119      86.366  46.045  38.098  1.00  9.08           C  
ATOM   2818  CG  LEU C 119      85.855  44.734  38.715  1.00 11.15           C  
ATOM   2819  CD1 LEU C 119      86.259  43.566  37.826  1.00 12.25           C  
ATOM   2820  CD2 LEU C 119      86.347  44.543  40.159  1.00 12.25           C  
ATOM   2821  N   GLU C 120      83.653  47.509  38.060  1.00  8.29           N  
ATOM   2822  CA  GLU C 120      82.191  47.442  38.123  1.00  9.21           C  
ATOM   2823  C   GLU C 120      81.747  46.710  36.866  1.00  8.88           C  
ATOM   2824  O   GLU C 120      82.227  47.031  35.788  1.00  7.90           O  
ATOM   2825  CB  GLU C 120      81.559  48.837  38.199  1.00  9.68           C  
ATOM   2826  CG  GLU C 120      80.042  48.876  38.130  1.00  9.49           C  
ATOM   2827  CD  GLU C 120      79.485  50.305  38.184  1.00 10.53           C  
ATOM   2828  OE1 GLU C 120      80.164  51.209  38.745  1.00 10.94           O  
ATOM   2829  OE2 GLU C 120      78.355  50.542  37.668  1.00 11.91           O  
ATOM   2830  N   ILE C 121      80.836  45.746  37.003  1.00  7.87           N  
ATOM   2831  CA  ILE C 121      80.422  44.903  35.858  1.00  8.04           C  
ATOM   2832  C   ILE C 121      78.909  44.877  35.738  1.00  7.91           C  
ATOM   2833  O   ILE C 121      78.232  44.557  36.703  1.00  8.27           O  
ATOM   2834  CB  ILE C 121      80.909  43.442  35.991  1.00  8.47           C  
ATOM   2835  CG1 ILE C 121      82.430  43.356  36.125  1.00  9.25           C  
ATOM   2836  CG2 ILE C 121      80.416  42.605  34.773  1.00  9.79           C  
ATOM   2837  CD1 ILE C 121      82.949  41.916  36.305  1.00 11.18           C  
ATOM   2838  N   GLU C 122      78.384  45.264  34.577  1.00  7.68           N  
ATOM   2839  CA  GLU C 122      76.942  45.135  34.300  1.00  8.58           C  
ATOM   2840  C   GLU C 122      76.730  44.057  33.264  1.00  9.04           C  
ATOM   2841  O   GLU C 122      77.626  43.752  32.501  1.00  9.06           O  
ATOM   2842  CB  GLU C 122      76.363  46.440  33.797  1.00  9.53           C  
ATOM   2843  CG  GLU C 122      77.034  46.922  32.521  1.00 10.47           C  
ATOM   2844  CD  GLU C 122      76.333  48.070  31.827  1.00 12.64           C  
ATOM   2845  OE1 GLU C 122      75.623  48.825  32.519  1.00 14.84           O  
ATOM   2846  OE2 GLU C 122      76.536  48.226  30.587  1.00 17.16           O  
ATOM   2847  N   ALA C 123      75.552  43.447  33.284  1.00  8.54           N  
ATOM   2848  CA  ALA C 123      75.239  42.365  32.363  1.00  9.30           C  
ATOM   2849  C   ALA C 123      73.850  42.484  31.768  1.00  8.82           C  
ATOM   2850  O   ALA C 123      72.959  43.086  32.355  1.00  8.37           O  
ATOM   2851  CB  ALA C 123      75.340  41.038  33.075  1.00  9.33           C  
ATOM   2852  N   ILE C 124      73.692  41.849  30.614  1.00  8.73           N  
ATOM   2853  CA  ILE C 124      72.398  41.656  29.964  1.00  9.59           C  
ATOM   2854  C   ILE C 124      72.350  40.155  29.642  1.00  9.55           C  
ATOM   2855  O   ILE C 124      73.303  39.612  29.105  1.00  8.54           O  
ATOM   2856  CB  ILE C 124      72.249  42.472  28.641  1.00 10.32           C  
ATOM   2857  CG1 ILE C 124      72.475  43.948  28.883  1.00 11.67           C  
ATOM   2858  CG2 ILE C 124      70.841  42.252  28.069  1.00 10.21           C  
ATOM   2859  CD1 ILE C 124      72.519  44.766  27.583  1.00 10.81           C  
ATOM   2860  N   ALA C 125      71.262  39.492  30.009  1.00 10.33           N  
ATOM   2861  CA  ALA C 125      71.095  38.070  29.731  1.00 10.50           C  
ATOM   2862  C   ALA C 125      69.785  37.902  28.986  1.00 11.50           C  
ATOM   2863  O   ALA C 125      68.899  38.752  29.061  1.00 10.57           O  
ATOM   2864  CB  ALA C 125      71.068  37.259  31.031  1.00 11.16           C  
ATOM   2865  N   VAL C 126      69.683  36.794  28.248  1.00 11.94           N  
ATOM   2866  CA  VAL C 126      68.491  36.493  27.466  1.00 13.66           C  
ATOM   2867  C   VAL C 126      67.888  35.179  27.892  1.00 14.60           C  
ATOM   2868  O   VAL C 126      68.600  34.236  28.244  1.00 14.71           O  
ATOM   2869  CB  VAL C 126      68.796  36.464  25.952  1.00 14.69           C  
ATOM   2870  CG1 VAL C 126      69.135  37.877  25.508  1.00 17.81           C  
ATOM   2871  CG2 VAL C 126      69.846  35.440  25.626  1.00 17.75           C  
ATOM   2872  N   ARG C 127      66.558  35.165  27.892  1.00 15.98           N  
ATOM   2873  CA  ARG C 127      65.810  33.947  28.122  1.00 17.82           C  
ATOM   2874  C   ARG C 127      65.363  33.475  26.752  1.00 19.42           C  
ATOM   2875  O   ARG C 127      64.652  34.202  26.027  1.00 20.97           O  
ATOM   2876  CB  ARG C 127      64.611  34.218  29.025  1.00 17.35           C  
ATOM   2877  CG  ARG C 127      63.863  32.983  29.457  1.00 18.49           C  
ATOM   2878  CD  ARG C 127      62.745  33.322  30.370  1.00 17.71           C  
ATOM   2879  NE  ARG C 127      63.228  33.608  31.707  1.00 17.98           N  
ATOM   2880  CZ  ARG C 127      63.197  34.791  32.305  1.00 18.53           C  
ATOM   2881  NH1 ARG C 127      62.713  35.857  31.717  1.00 18.92           N  
ATOM   2882  NH2 ARG C 127      63.660  34.894  33.530  1.00 19.68           N  
ATOM   2883  N   SER C 128      65.816  32.282  26.392  1.00 22.07           N  
ATOM   2884  CA  SER C 128      65.310  31.578  25.189  1.00 24.19           C  
ATOM   2885  C   SER C 128      64.095  30.708  25.564  1.00 25.66           C  
ATOM   2886  O   SER C 128      64.043  30.101  26.669  1.00 28.32           O  
ATOM   2887  CB  SER C 128      66.420  30.730  24.537  1.00 24.92           C  
ATOM   2888  OG  SER C 128      67.736  31.304  24.711  1.00 29.60           O  
TER    2889      SER C 128                                                      
END
MOLECULE T0423.pdb
ATOM  12910  N   MET     1      70.981  21.031  37.362  1.00 36.76           N  
ATOM  12911  CA  MET     1      71.905  21.930  36.664  1.00 38.87           C  
ATOM  12912  C   MET     1      72.311  23.119  37.519  1.00 35.58           C  
ATOM  12913  O   MET     1      73.455  23.538  37.475  1.00 34.69           O  
ATOM  12914  CB  MET     1      71.283  22.461  35.383  1.00 39.21           C  
ATOM  12915  CG  MET     1      71.504  21.613  34.171  1.00 44.40           C  
ATOM  12916  SD  MET     1      70.806  22.501  32.558  1.00 57.84          SE  
ATOM  12917  CE  MET     1      71.792  24.214  32.666  1.00 53.65           C  
ATOM  12918  N   SER     2      71.368  23.671  38.275  1.00 34.19           N  
ATOM  12919  CA  SER     2      71.660  24.824  39.146  1.00 33.25           C  
ATOM  12920  C   SER     2      72.590  24.410  40.267  1.00 32.21           C  
ATOM  12921  O   SER     2      73.492  25.167  40.644  1.00 30.89           O  
ATOM  12922  CB  SER     2      70.389  25.426  39.738  1.00 32.90           C  
ATOM  12923  OG  SER     2      69.633  26.060  38.749  1.00 33.07           O  
ATOM  12924  N   ASP     3      72.374  23.203  40.811  1.00 30.62           N  
ATOM  12925  CA  ASP     3      73.242  22.687  41.862  1.00 30.33           C  
ATOM  12926  C   ASP     3      74.682  22.556  41.347  1.00 28.94           C  
ATOM  12927  O   ASP     3      75.638  22.825  42.091  1.00 29.92           O  
ATOM  12928  CB  ASP     3      72.774  21.291  42.370  1.00 30.67           C  
ATOM  12929  CG  ASP     3      71.492  21.328  43.198  1.00 32.38           C  
ATOM  12930  OD1 ASP     3      71.019  22.402  43.615  1.00 35.40           O  
ATOM  12931  OD2 ASP     3      70.942  20.230  43.448  1.00 35.26           O  
ATOM  12932  N   VAL     4      74.823  22.096  40.101  1.00 27.71           N  
ATOM  12933  CA  VAL     4      76.127  21.864  39.482  1.00 27.34           C  
ATOM  12934  C   VAL     4      76.846  23.203  39.304  1.00 26.70           C  
ATOM  12935  O   VAL     4      78.035  23.311  39.582  1.00 25.89           O  
ATOM  12936  CB  VAL     4      75.994  21.175  38.115  1.00 27.32           C  
ATOM  12937  CG1 VAL     4      77.261  21.282  37.304  1.00 28.31           C  
ATOM  12938  CG2 VAL     4      75.606  19.678  38.300  1.00 27.74           C  
ATOM  12939  N   ILE     5      76.114  24.200  38.836  1.00 26.35           N  
ATOM  12940  CA  ILE     5      76.694  25.575  38.675  1.00 26.66           C  
ATOM  12941  C   ILE     5      77.167  26.134  40.031  1.00 26.86           C  
ATOM  12942  O   ILE     5      78.302  26.546  40.179  1.00 27.38           O  
ATOM  12943  CB  ILE     5      75.680  26.562  37.999  1.00 26.48           C  
ATOM  12944  CG1 ILE     5      75.346  26.128  36.566  1.00 24.54           C  
ATOM  12945  CG2 ILE     5      76.257  28.001  37.934  1.00 26.07           C  
ATOM  12946  CD1 ILE     5      74.048  26.748  35.988  1.00 26.63           C  
ATOM  12947  N   GLU     6      76.308  26.117  41.034  1.00 27.87           N  
ATOM  12948  CA  GLU     6      76.688  26.606  42.353  1.00 28.66           C  
ATOM  12949  C   GLU     6      77.785  25.768  43.000  1.00 28.15           C  
ATOM  12950  O   GLU     6      78.644  26.303  43.709  1.00 27.19           O  
ATOM  12951  CB  GLU     6      75.481  26.702  43.272  1.00 29.19           C  
ATOM  12952  CG  GLU     6      74.484  27.740  42.832  1.00 31.30           C  
ATOM  12953  CD  GLU     6      73.485  28.113  43.911  1.00 31.61           C  
ATOM  12954  OE1 GLU     6      73.885  28.327  45.083  1.00 38.52           O  
ATOM  12955  OE2 GLU     6      72.296  28.217  43.572  1.00 35.07           O  
ATOM  12956  N   GLY     7      77.769  24.454  42.764  1.00 27.55           N  
ATOM  12957  CA  GLY     7      78.825  23.599  43.252  1.00 27.47           C  
ATOM  12958  C   GLY     7      80.172  23.924  42.647  1.00 27.46           C  
ATOM  12959  O   GLY     7      81.190  23.916  43.348  1.00 28.04           O  
ATOM  12960  N   ARG     8      80.193  24.198  41.351  1.00 27.39           N  
ATOM  12961  CA  ARG     8      81.428  24.591  40.683  1.00 28.18           C  
ATOM  12962  C   ARG     8      81.977  25.901  41.263  1.00 27.87           C  
ATOM  12963  O   ARG     8      83.187  26.055  41.439  1.00 28.10           O  
ATOM  12964  CB  ARG     8      81.219  24.776  39.185  1.00 27.91           C  
ATOM  12965  CG  ARG     8      81.010  23.509  38.405  1.00 28.72           C  
ATOM  12966  CD  ARG     8      80.440  23.881  37.071  1.00 31.46           C  
ATOM  12967  NE  ARG     8      80.192  22.738  36.217  1.00 33.09           N  
ATOM  12968  CZ  ARG     8      79.413  22.752  35.140  1.00 35.77           C  
ATOM  12969  NH1 ARG     8      78.767  23.854  34.762  1.00 36.28           N  
ATOM  12970  NH2 ARG     8      79.267  21.629  34.439  1.00 38.50           N  
ATOM  12971  N   LEU     9      81.077  26.830  41.554  1.00 28.09           N  
ATOM  12972  CA  LEU     9      81.479  28.113  42.139  1.00 28.34           C  
ATOM  12973  C   LEU     9      82.103  27.873  43.539  1.00 28.63           C  
ATOM  12974  O   LEU     9      83.145  28.457  43.874  1.00 27.85           O  
ATOM  12975  CB  LEU     9      80.271  29.044  42.209  1.00 28.43           C  
ATOM  12976  CG  LEU     9      80.543  30.479  42.669  1.00 28.95           C  
ATOM  12977  CD1 LEU     9      81.644  31.110  41.771  1.00 29.20           C  
ATOM  12978  CD2 LEU     9      79.251  31.302  42.651  1.00 29.10           C  
ATOM  12979  N   LYS    10      81.487  26.998  44.343  1.00 28.27           N  
ATOM  12980  CA  LYS    10      82.090  26.586  45.618  1.00 29.09           C  
ATOM  12981  C   LYS    10      83.477  25.946  45.467  1.00 29.33           C  
ATOM  12982  O   LYS    10      84.380  26.178  46.296  1.00 30.06           O  
ATOM  12983  CB  LYS    10      81.155  25.648  46.379  1.00 29.06           C  
ATOM  12984  CG  LYS    10      79.869  26.277  46.842  1.00 29.74           C  
ATOM  12985  CD  LYS    10      79.055  25.300  47.652  1.00 30.41           C  
ATOM  12986  CE  LYS    10      77.739  25.887  48.034  1.00 30.84           C  
ATOM  12987  NZ  LYS    10      76.878  24.856  48.677  1.00 32.89           N  
ATOM  12988  N   GLU    11      83.673  25.166  44.413  1.00 29.53           N  
ATOM  12989  CA  GLU    11      84.977  24.594  44.114  1.00 30.47           C  
ATOM  12990  C   GLU    11      86.011  25.667  43.795  1.00 30.79           C  
ATOM  12991  O   GLU    11      87.190  25.452  44.020  1.00 32.10           O  
ATOM  12992  CB  GLU    11      84.889  23.624  42.946  1.00 30.41           C  
ATOM  12993  CG  GLU    11      84.195  22.304  43.287  1.00 31.53           C  
ATOM  12994  CD  GLU    11      83.980  21.440  42.072  1.00 33.05           C  
ATOM  12995  OE1 GLU    11      83.483  21.935  41.044  1.00 37.69           O  
ATOM  12996  OE2 GLU    11      84.275  20.239  42.144  1.00 40.32           O  
ATOM  12997  N   LEU    12      85.573  26.810  43.266  1.00 30.96           N  
ATOM  12998  CA  LEU    12      86.458  27.982  43.080  1.00 30.36           C  
ATOM  12999  C   LEU    12      86.672  28.813  44.349  1.00 30.69           C  
ATOM  13000  O   LEU    12      87.510  29.730  44.358  1.00 31.30           O  
ATOM  13001  CB  LEU    12      85.912  28.883  41.982  1.00 29.65           C  
ATOM  13002  CG  LEU    12      85.889  28.253  40.603  1.00 29.14           C  
ATOM  13003  CD1 LEU    12      85.193  29.190  39.650  1.00 28.44           C  
ATOM  13004  CD2 LEU    12      87.318  27.916  40.123  1.00 30.62           C  
ATOM  13005  N   GLY    13      85.906  28.530  45.398  1.00 30.88           N  
ATOM  13006  CA  GLY    13      86.097  29.154  46.694  1.00 30.87           C  
ATOM  13007  C   GLY    13      85.047  30.177  47.062  1.00 30.89           C  
ATOM  13008  O   GLY    13      85.157  30.816  48.099  1.00 31.94           O  
ATOM  13009  N   PHE    14      84.004  30.303  46.254  1.00 30.40           N  
ATOM  13010  CA  PHE    14      82.959  31.278  46.509  1.00 30.42           C  
ATOM  13011  C   PHE    14      81.595  30.647  46.801  1.00 31.05           C  
ATOM  13012  O   PHE    14      81.170  29.691  46.147  1.00 30.75           O  
ATOM  13013  CB  PHE    14      82.829  32.227  45.312  1.00 29.97           C  
ATOM  13014  CG  PHE    14      84.106  32.886  44.930  1.00 28.80           C  
ATOM  13015  CD1 PHE    14      84.494  34.057  45.537  1.00 29.32           C  
ATOM  13016  CD2 PHE    14      84.924  32.336  43.954  1.00 28.91           C  
ATOM  13017  CE1 PHE    14      85.688  34.670  45.177  1.00 27.83           C  
ATOM  13018  CE2 PHE    14      86.114  32.938  43.594  1.00 28.84           C  
ATOM  13019  CZ  PHE    14      86.494  34.108  44.214  1.00 28.76           C  
ATOM  13020  N   THR    15      80.906  31.228  47.769  1.00 31.89           N  
ATOM  13021  CA  THR    15      79.480  31.011  47.934  1.00 33.07           C  
ATOM  13022  C   THR    15      78.738  32.270  47.471  1.00 33.07           C  
ATOM  13023  O   THR    15      79.306  33.390  47.471  1.00 32.98           O  
ATOM  13024  CB  THR    15      79.142  30.676  49.406  1.00 33.77           C  
ATOM  13025  OG1 THR    15      79.407  31.816  50.239  1.00 37.27           O  
ATOM  13026  CG2 THR    15      79.988  29.500  49.902  1.00 32.51           C  
ATOM  13027  N   LEU    16      77.488  32.100  47.043  1.00 32.88           N  
ATOM  13028  CA  LEU    16      76.696  33.230  46.573  1.00 32.59           C  
ATOM  13029  C   LEU    16      76.163  34.007  47.767  1.00 33.08           C  
ATOM  13030  O   LEU    16      75.580  33.413  48.678  1.00 32.54           O  
ATOM  13031  CB  LEU    16      75.513  32.781  45.706  1.00 32.47           C  
ATOM  13032  CG  LEU    16      75.834  32.190  44.332  1.00 31.50           C  
ATOM  13033  CD1 LEU    16      74.534  31.595  43.670  1.00 29.77           C  
ATOM  13034  CD2 LEU    16      76.521  33.215  43.434  1.00 28.44           C  
ATOM  13035  N   PRO    17      76.338  35.334  47.771  1.00 33.26           N  
ATOM  13036  CA  PRO    17      75.694  36.103  48.823  1.00 33.95           C  
ATOM  13037  C   PRO    17      74.202  36.176  48.577  1.00 35.74           C  
ATOM  13038  O   PRO    17      73.743  35.890  47.461  1.00 35.40           O  
ATOM  13039  CB  PRO    17      76.304  37.492  48.650  1.00 33.84           C  
ATOM  13040  CG  PRO    17      76.630  37.570  47.219  1.00 33.42           C  
ATOM  13041  CD  PRO    17      77.081  36.198  46.835  1.00 32.52           C  
ATOM  13042  N   VAL    18      73.449  36.584  49.596  1.00 37.90           N  
ATOM  13043  CA  VAL    18      72.045  36.963  49.389  1.00 39.41           C  
ATOM  13044  C   VAL    18      71.995  38.269  48.568  1.00 40.41           C  
ATOM  13045  O   VAL    18      71.230  38.389  47.586  1.00 42.23           O  
ATOM  13046  CB  VAL    18      71.308  37.200  50.710  1.00 39.67           C  
ATOM  13047  CG1 VAL    18      71.505  36.006  51.656  1.00 40.20           C  
ATOM  13048  CG2 VAL    18      71.762  38.513  51.345  1.00 39.98           C  
ATOM  13049  N   ALA    23      66.158  48.786  48.809  1.00 42.30           N  
ATOM  13050  CA  ALA    23      64.939  49.472  48.343  1.00 41.72           C  
ATOM  13051  C   ALA    23      65.286  50.838  47.711  1.00 41.82           C  
ATOM  13052  O   ALA    23      65.606  51.804  48.439  1.00 42.33           O  
ATOM  13053  CB  ALA    23      63.942  49.647  49.513  1.00 42.49           C  
ATOM  13054  N   ALA    24      65.243  50.926  46.370  1.00 40.52           N  
ATOM  13055  CA  ALA    24      65.678  52.154  45.678  1.00 38.94           C  
ATOM  13056  C   ALA    24      64.979  52.405  44.337  1.00 37.86           C  
ATOM  13057  O   ALA    24      64.258  51.549  43.818  1.00 37.65           O  
ATOM  13058  CB  ALA    24      67.220  52.130  45.485  1.00 39.16           C  
ATOM  13059  N   ASN    25      65.207  53.597  43.784  1.00 35.84           N  
ATOM  13060  CA  ASN    25      64.676  53.977  42.458  1.00 34.71           C  
ATOM  13061  C   ASN    25      65.420  53.350  41.277  1.00 32.01           C  
ATOM  13062  O   ASN    25      64.955  53.404  40.128  1.00 30.65           O  
ATOM  13063  CB  ASN    25      64.628  55.506  42.327  1.00 34.31           C  
ATOM  13064  CG  ASN    25      63.556  56.116  43.221  1.00 34.82           C  
ATOM  13065  OD1 ASN    25      63.757  57.167  43.838  1.00 36.03           O  
ATOM  13066  ND2 ASN    25      62.419  55.419  43.327  1.00 31.59           N  
ATOM  13067  N   TYR    26      66.570  52.763  41.572  1.00 30.18           N  
ATOM  13068  CA  TYR    26      67.208  51.824  40.653  1.00 28.61           C  
ATOM  13069  C   TYR    26      67.192  50.433  41.287  1.00 26.27           C  
ATOM  13070  O   TYR    26      67.222  50.261  42.514  1.00 25.81           O  
ATOM  13071  CB  TYR    26      68.625  52.246  40.221  1.00 28.83           C  
ATOM  13072  CG  TYR    26      69.621  52.398  41.339  1.00 30.60           C  
ATOM  13073  CD1 TYR    26      70.670  51.493  41.495  1.00 30.95           C  
ATOM  13074  CD2 TYR    26      69.522  53.456  42.230  1.00 30.60           C  
ATOM  13075  CE1 TYR    26      71.582  51.635  42.510  1.00 30.87           C  
ATOM  13076  CE2 TYR    26      70.411  53.597  43.267  1.00 32.36           C  
ATOM  13077  CZ  TYR    26      71.447  52.689  43.404  1.00 32.75           C  
ATOM  13078  OH  TYR    26      72.352  52.852  44.448  1.00 34.31           O  
ATOM  13079  N   VAL    27      67.135  49.446  40.418  1.00 24.17           N  
ATOM  13080  CA  VAL    27      67.030  48.071  40.817  1.00 22.92           C  
ATOM  13081  C   VAL    27      68.271  47.271  40.393  1.00 22.47           C  
ATOM  13082  O   VAL    27      68.985  47.662  39.463  1.00 20.80           O  
ATOM  13083  CB  VAL    27      65.757  47.458  40.209  1.00 22.53           C  
ATOM  13084  CG1 VAL    27      64.536  48.064  40.881  1.00 24.05           C  
ATOM  13085  CG2 VAL    27      65.709  47.685  38.675  1.00 20.19           C  
ATOM  13086  N   PRO    28      68.514  46.135  41.065  1.00 22.19           N  
ATOM  13087  CA  PRO    28      69.643  45.282  40.693  1.00 22.05           C  
ATOM  13088  C   PRO    28      69.576  44.646  39.313  1.00 21.32           C  
ATOM  13089  O   PRO    28      70.620  44.298  38.758  1.00 19.41           O  
ATOM  13090  CB  PRO    28      69.645  44.208  41.765  1.00 23.32           C  
ATOM  13091  CG  PRO    28      68.744  44.705  42.839  1.00 24.78           C  
ATOM  13092  CD  PRO    28      67.767  45.580  42.209  1.00 22.87           C  
ATOM  13093  N   PHE    29      68.366  44.511  38.760  1.00 20.74           N  
ATOM  13094  CA  PHE    29      68.186  43.931  37.454  1.00 21.35           C  
ATOM  13095  C   PHE    29      66.815  44.278  36.885  1.00 20.78           C  
ATOM  13096  O   PHE    29      65.876  44.597  37.615  1.00 20.82           O  
ATOM  13097  CB  PHE    29      68.410  42.392  37.475  1.00 21.85           C  
ATOM  13098  CG  PHE    29      67.437  41.650  38.360  1.00 22.44           C  
ATOM  13099  CD1 PHE    29      66.175  41.334  37.907  1.00 24.23           C  
ATOM  13100  CD2 PHE    29      67.776  41.337  39.664  1.00 24.23           C  
ATOM  13101  CE1 PHE    29      65.265  40.664  38.746  1.00 23.72           C  
ATOM  13102  CE2 PHE    29      66.883  40.698  40.489  1.00 26.07           C  
ATOM  13103  CZ  PHE    29      65.623  40.381  40.031  1.00 24.55           C  
ATOM  13104  N   THR    30      66.753  44.281  35.568  1.00 21.11           N  
ATOM  13105  CA  THR    30      65.491  44.370  34.819  1.00 22.00           C  
ATOM  13106  C   THR    30      65.480  43.293  33.752  1.00 22.35           C  
ATOM  13107  O   THR    30      66.525  42.798  33.356  1.00 21.01           O  
ATOM  13108  CB  THR    30      65.298  45.735  34.132  1.00 22.63           C  
ATOM  13109  OG1 THR    30      66.405  46.020  33.266  1.00 22.53           O  
ATOM  13110  CG2 THR    30      65.139  46.846  35.164  1.00 21.28           C  
ATOM  13111  N   ILE    31      64.276  42.943  33.280  1.00 23.19           N  
ATOM  13112  CA  ILE    31      64.104  41.993  32.189  1.00 23.67           C  
ATOM  13113  C   ILE    31      63.288  42.634  31.087  1.00 23.56           C  
ATOM  13114  O   ILE    31      62.269  43.294  31.331  1.00 24.21           O  
ATOM  13115  CB  ILE    31      63.424  40.684  32.664  1.00 23.86           C  
ATOM  13116  CG1 ILE    31      64.303  39.977  33.687  1.00 23.74           C  
ATOM  13117  CG2 ILE    31      63.169  39.723  31.486  1.00 24.39           C  
ATOM  13118  CD1 ILE    31      63.577  38.878  34.465  1.00 25.28           C  
ATOM  13119  N   SER    32      63.757  42.461  29.874  1.00 24.00           N  
ATOM  13120  CA  SER    32      63.011  42.846  28.692  1.00 25.73           C  
ATOM  13121  C   SER    32      63.058  41.677  27.730  1.00 25.64           C  
ATOM  13122  O   SER    32      64.122  41.331  27.246  1.00 25.50           O  
ATOM  13123  CB  SER    32      63.598  44.073  28.021  1.00 25.81           C  
ATOM  13124  OG  SER    32      62.809  44.432  26.913  1.00 27.19           O  
ATOM  13125  N   GLY    33      61.903  41.083  27.430  1.00 26.33           N  
ATOM  13126  CA  GLY    33      61.899  39.878  26.629  1.00 26.22           C  
ATOM  13127  C   GLY    33      62.655  38.771  27.314  1.00 25.36           C  
ATOM  13128  O   GLY    33      62.370  38.424  28.457  1.00 26.34           O  
ATOM  13129  N   ASN    34      63.633  38.209  26.622  1.00 24.98           N  
ATOM  13130  CA  ASN    34      64.458  37.178  27.241  1.00 25.51           C  
ATOM  13131  C   ASN    34      65.858  37.705  27.552  1.00 24.78           C  
ATOM  13132  O   ASN    34      66.804  36.930  27.584  1.00 24.18           O  
ATOM  13133  CB  ASN    34      64.528  35.934  26.371  1.00 27.08           C  
ATOM  13134  CG  ASN    34      65.282  36.158  25.091  1.00 30.55           C  
ATOM  13135  OD1 ASN    34      65.607  37.305  24.738  1.00 35.31           O  
ATOM  13136  ND2 ASN    34      65.586  35.057  24.371  1.00 35.76           N  
ATOM  13137  N   LEU    35      65.983  39.022  27.699  1.00 24.55           N  
ATOM  13138  CA  LEU    35      67.277  39.637  28.078  1.00 24.12           C  
ATOM  13139  C   LEU    35      67.189  40.157  29.496  1.00 23.03           C  
ATOM  13140  O   LEU    35      66.268  40.868  29.847  1.00 23.05           O  
ATOM  13141  CB  LEU    35      67.702  40.736  27.096  1.00 24.76           C  
ATOM  13142  CG  LEU    35      68.282  40.199  25.764  1.00 26.16           C  
ATOM  13143  CD1 LEU    35      68.633  41.334  24.793  1.00 28.97           C  
ATOM  13144  CD2 LEU    35      69.489  39.249  25.947  1.00 28.49           C  
ATOM  13145  N   LEU    36      68.148  39.763  30.315  1.00 21.64           N  
ATOM  13146  CA  LEU    36      68.250  40.214  31.693  1.00 20.97           C  
ATOM  13147  C   LEU    36      69.421  41.199  31.776  1.00 20.61           C  
ATOM  13148  O   LEU    36      70.562  40.854  31.376  1.00 21.20           O  
ATOM  13149  CB  LEU    36      68.532  39.046  32.613  1.00 21.41           C  
ATOM  13150  CG  LEU    36      68.789  39.264  34.102  1.00 21.35           C  
ATOM  13151  CD1 LEU    36      67.603  39.957  34.807  1.00 23.14           C  
ATOM  13152  CD2 LEU    36      69.179  37.943  34.804  1.00 22.93           C  
ATOM  13153  N   TYR    37      69.112  42.393  32.255  1.00 19.52           N  
ATOM  13154  CA  TYR    37      70.093  43.483  32.452  1.00 19.94           C  
ATOM  13155  C   TYR    37      70.430  43.581  33.906  1.00 19.30           C  
ATOM  13156  O   TYR    37      69.576  43.954  34.684  1.00 18.49           O  
ATOM  13157  CB  TYR    37      69.527  44.816  32.021  1.00 21.62           C  
ATOM  13158  CG  TYR    37      69.633  45.044  30.561  1.00 24.97           C  
ATOM  13159  CD1 TYR    37      70.608  45.901  30.041  1.00 26.99           C  
ATOM  13160  CD2 TYR    37      68.798  44.384  29.690  1.00 26.43           C  
ATOM  13161  CE1 TYR    37      70.711  46.099  28.690  1.00 28.18           C  
ATOM  13162  CE2 TYR    37      68.902  44.583  28.309  1.00 27.61           C  
ATOM  13163  CZ  TYR    37      69.839  45.424  27.829  1.00 26.70           C  
ATOM  13164  OH  TYR    37      69.928  45.651  26.474  1.00 28.34           O  
ATOM  13165  N   VAL    38      71.680  43.277  34.255  1.00 18.12           N  
ATOM  13166  CA  VAL    38      72.116  43.284  35.635  1.00 17.38           C  
ATOM  13167  C   VAL    38      72.897  44.591  35.852  1.00 17.03           C  
ATOM  13168  O   VAL    38      73.783  44.948  35.040  1.00 16.35           O  
ATOM  13169  CB  VAL    38      72.994  42.065  35.962  1.00 17.22           C  
ATOM  13170  CG1 VAL    38      73.488  42.113  37.378  1.00 16.68           C  
ATOM  13171  CG2 VAL    38      72.228  40.778  35.704  1.00 19.02           C  
ATOM  13172  N   SER    39      72.542  45.277  36.935  1.00 16.21           N  
ATOM  13173  CA  SER    39      73.190  46.537  37.340  1.00 16.77           C  
ATOM  13174  C   SER    39      74.675  46.307  37.694  1.00 16.42           C  
ATOM  13175  O   SER    39      75.066  45.194  38.084  1.00 16.79           O  
ATOM  13176  CB  SER    39      72.491  47.130  38.559  1.00 16.39           C  
ATOM  13177  OG  SER    39      71.232  47.673  38.217  1.00 16.94           O  
ATOM  13178  N   GLY    40      75.498  47.355  37.547  1.00 16.71           N  
ATOM  13179  CA  GLY    40      76.913  47.251  37.877  1.00 16.17           C  
ATOM  13180  C   GLY    40      77.093  46.701  39.267  1.00 16.82           C  
ATOM  13181  O   GLY    40      76.479  47.191  40.216  1.00 16.75           O  
ATOM  13182  N   GLN    41      77.848  45.617  39.375  1.00 16.68           N  
ATOM  13183  CA  GLN    41      78.114  44.996  40.668  1.00 17.30           C  
ATOM  13184  C   GLN    41      79.538  45.360  41.116  1.00 16.88           C  
ATOM  13185  O   GLN    41      80.451  45.399  40.295  1.00 17.16           O  
ATOM  13186  CB  GLN    41      77.943  43.460  40.588  1.00 17.03           C  
ATOM  13187  CG  GLN    41      76.522  42.993  40.194  1.00 18.15           C  
ATOM  13188  CD  GLN    41      75.491  43.430  41.175  1.00 18.41           C  
ATOM  13189  OE1 GLN    41      75.559  43.081  42.360  1.00 18.42           O  
ATOM  13190  NE2 GLN    41      74.513  44.191  40.705  1.00 18.08           N  
ATOM  13191  N   LEU    42      79.675  45.523  42.425  1.00 18.51           N  
ATOM  13192  CA  LEU    42      80.922  45.823  43.142  1.00 19.27           C  
ATOM  13193  C   LEU    42      81.505  44.544  43.800  1.00 20.59           C  
ATOM  13194  O   LEU    42      80.809  43.508  43.933  1.00 20.90           O  
ATOM  13195  CB  LEU    42      80.648  46.893  44.195  1.00 19.83           C  
ATOM  13196  CG  LEU    42      80.007  48.193  43.701  1.00 20.09           C  
ATOM  13197  CD1 LEU    42      79.893  49.256  44.830  1.00 24.19           C  
ATOM  13198  CD2 LEU    42      80.773  48.751  42.474  1.00 20.92           C  
ATOM  13199  N   PRO    43      82.784  44.590  44.204  1.00 20.99           N  
ATOM  13200  CA  PRO    43      83.390  43.388  44.739  1.00 22.23           C  
ATOM  13201  C   PRO    43      82.987  43.165  46.205  1.00 23.30           C  
ATOM  13202  O   PRO    43      83.833  43.267  47.123  1.00 23.87           O  
ATOM  13203  CB  PRO    43      84.886  43.654  44.574  1.00 22.24           C  
ATOM  13204  CG  PRO    43      85.021  45.107  44.597  1.00 22.74           C  
ATOM  13205  CD  PRO    43      83.747  45.711  44.125  1.00 20.90           C  
ATOM  13206  N   MET    44      81.695  42.863  46.396  1.00 24.94           N  
ATOM  13207  CA  MET    44      81.111  42.668  47.725  1.00 26.76           C  
ATOM  13208  C   MET    44      81.416  41.303  48.250  1.00 27.78           C  
ATOM  13209  O   MET    44      81.216  40.309  47.554  1.00 26.94           O  
ATOM  13210  CB  MET    44      79.606  42.768  47.701  1.00 28.72           C  
ATOM  13211  CG  MET    44      79.087  44.003  47.142  1.00 34.04           C  
ATOM  13212  SD  MET    44      79.675  45.517  48.177  1.00 52.29          SE  
ATOM  13213  CE  MET    44      78.069  46.599  47.655  1.00 42.80           C  
ATOM  13214  N   GLU    45      81.866  41.277  49.503  1.00 28.96           N  
ATOM  13215  CA  GLU    45      82.155  40.050  50.199  1.00 30.57           C  
ATOM  13216  C   GLU    45      81.806  40.268  51.663  1.00 30.94           C  
ATOM  13217  O   GLU    45      82.239  41.230  52.276  1.00 29.35           O  
ATOM  13218  CB  GLU    45      83.615  39.704  50.030  1.00 31.01           C  
ATOM  13219  CG  GLU    45      83.899  38.254  50.285  1.00 32.83           C  
ATOM  13220  CD  GLU    45      85.369  37.906  50.169  1.00 34.03           C  
ATOM  13221  OE1 GLU    45      86.236  38.800  50.290  1.00 40.50           O  
ATOM  13222  OE2 GLU    45      85.665  36.719  49.956  1.00 39.11           O  
ATOM  13223  N   SER    46      80.980  39.381  52.208  1.00 32.41           N  
ATOM  13224  CA  SER    46      80.473  39.546  53.558  1.00 33.11           C  
ATOM  13225  C   SER    46      79.902  40.921  53.829  1.00 32.96           C  
ATOM  13226  O   SER    46      80.092  41.474  54.907  1.00 33.73           O  
ATOM  13227  CB  SER    46      81.576  39.245  54.550  1.00 33.85           C  
ATOM  13228  OG  SER    46      82.071  37.929  54.341  1.00 36.10           O  
ATOM  13229  N   GLY    47      79.201  41.482  52.851  1.00 32.72           N  
ATOM  13230  CA  GLY    47      78.556  42.782  53.023  1.00 32.20           C  
ATOM  13231  C   GLY    47      79.457  44.008  52.954  1.00 31.89           C  
ATOM  13232  O   GLY    47      78.988  45.134  53.165  1.00 32.53           O  
ATOM  13233  N   LYS    48      80.735  43.805  52.632  1.00 31.36           N  
ATOM  13234  CA  LYS    48      81.710  44.889  52.589  1.00 31.00           C  
ATOM  13235  C   LYS    48      82.340  44.938  51.204  1.00 29.19           C  
ATOM  13236  O   LYS    48      82.428  43.919  50.525  1.00 27.85           O  
ATOM  13237  CB  LYS    48      82.812  44.643  53.628  1.00 32.10           C  
ATOM  13238  CG  LYS    48      82.320  44.278  55.056  1.00 33.77           C  
ATOM  13239  CD  LYS    48      83.517  44.073  55.997  1.00 34.85           C  
ATOM  13240  CE  LYS    48      83.212  43.172  57.223  1.00 38.54           C  
ATOM  13241  NZ  LYS    48      82.691  41.784  56.927  1.00 41.89           N  
ATOM  13242  N   ILE    49      82.793  46.114  50.786  1.00 27.46           N  
ATOM  13243  CA  ILE    49      83.609  46.197  49.556  1.00 27.51           C  
ATOM  13244  C   ILE    49      84.994  45.615  49.890  1.00 26.44           C  
ATOM  13245  O   ILE    49      85.717  46.162  50.719  1.00 27.76           O  
ATOM  13246  CB  ILE    49      83.727  47.641  48.999  1.00 27.35           C  
ATOM  13247  CG1 ILE    49      82.339  48.250  48.725  1.00 28.61           C  
ATOM  13248  CG2 ILE    49      84.568  47.654  47.687  1.00 25.90           C  
ATOM  13249  CD1 ILE    49      81.640  47.702  47.484  1.00 29.88           C  
ATOM  13250  N   ALA    50      85.329  44.473  49.299  1.00 24.66           N  
ATOM  13251  CA  ALA    50      86.524  43.716  49.675  1.00 23.88           C  
ATOM  13252  C   ALA    50      87.844  44.216  49.077  1.00 22.88           C  
ATOM  13253  O   ALA    50      88.926  43.916  49.616  1.00 23.36           O  
ATOM  13254  CB  ALA    50      86.342  42.241  49.306  1.00 24.42           C  
ATOM  13255  N   VAL    51      87.773  44.926  47.958  1.00 20.81           N  
ATOM  13256  CA  VAL    51      88.968  45.381  47.241  1.00 19.75           C  
ATOM  13257  C   VAL    51      88.716  46.833  46.772  1.00 19.50           C  
ATOM  13258  O   VAL    51      87.820  47.092  45.950  1.00 18.36           O  
ATOM  13259  CB  VAL    51      89.299  44.506  46.034  1.00 19.25           C  
ATOM  13260  CG1 VAL    51      90.619  44.969  45.369  1.00 17.95           C  
ATOM  13261  CG2 VAL    51      89.337  42.997  46.410  1.00 19.82           C  
ATOM  13262  N   THR    52      89.518  47.761  47.290  1.00 18.83           N  
ATOM  13263  CA  THR    52      89.331  49.192  47.048  1.00 18.76           C  
ATOM  13264  C   THR    52      90.623  49.886  46.577  1.00 17.15           C  
ATOM  13265  O   THR    52      91.752  49.426  46.833  1.00 18.57           O  
ATOM  13266  CB  THR    52      88.801  49.933  48.274  1.00 19.87           C  
ATOM  13267  OG1 THR    52      89.751  49.836  49.341  1.00 20.52           O  
ATOM  13268  CG2 THR    52      87.440  49.358  48.732  1.00 20.18           C  
ATOM  13269  N   GLY    53      90.427  50.980  45.853  1.00 16.63           N  
ATOM  13270  CA  GLY    53      91.523  51.794  45.378  1.00 15.81           C  
ATOM  13271  C   GLY    53      91.866  51.490  43.935  1.00 16.34           C  
ATOM  13272  O   GLY    53      91.220  50.657  43.238  1.00 16.41           O  
ATOM  13273  N   LEU    54      92.852  52.232  43.462  1.00 14.89           N  
ATOM  13274  CA  LEU    54      93.241  52.192  42.046  1.00 15.09           C  
ATOM  13275  C   LEU    54      94.198  51.052  41.691  1.00 14.82           C  
ATOM  13276  O   LEU    54      95.217  50.830  42.343  1.00 15.74           O  
ATOM  13277  CB  LEU    54      93.870  53.539  41.641  1.00 14.99           C  
ATOM  13278  CG  LEU    54      93.016  54.794  41.893  1.00 16.43           C  
ATOM  13279  CD1 LEU    54      93.853  56.129  41.629  1.00 14.43           C  
ATOM  13280  CD2 LEU    54      91.711  54.771  41.099  1.00 18.58           C  
ATOM  13281  N   VAL    55      93.881  50.333  40.618  1.00 15.10           N  
ATOM  13282  CA  VAL    55      94.798  49.303  40.117  1.00 15.22           C  
ATOM  13283  C   VAL    55      96.009  50.038  39.509  1.00 15.52           C  
ATOM  13284  O   VAL    55      95.867  51.023  38.743  1.00 15.49           O  
ATOM  13285  CB  VAL    55      94.147  48.295  39.122  1.00 15.34           C  
ATOM  13286  CG1 VAL    55      95.143  47.202  38.776  1.00 16.34           C  
ATOM  13287  CG2 VAL    55      92.798  47.747  39.668  1.00 14.16           C  
ATOM  13288  N   GLY    56      97.188  49.598  39.915  1.00 15.44           N  
ATOM  13289  CA  GLY    56      98.449  50.244  39.536  1.00 16.28           C  
ATOM  13290  C   GLY    56      98.942  51.219  40.587  1.00 16.32           C  
ATOM  13291  O   GLY    56     100.026  51.780  40.450  1.00 16.29           O  
ATOM  13292  N   ARG    57      98.166  51.390  41.665  1.00 16.32           N  
ATOM  13293  CA  ARG    57      98.571  52.249  42.778  1.00 16.70           C  
ATOM  13294  C   ARG    57      98.304  51.594  44.106  1.00 16.10           C  
ATOM  13295  O   ARG    57      99.218  51.357  44.886  1.00 17.03           O  
ATOM  13296  CB  ARG    57      97.873  53.603  42.715  1.00 15.72           C  
ATOM  13297  CG  ARG    57      98.244  54.497  43.885  1.00 16.84           C  
ATOM  13298  CD  ARG    57      97.659  55.894  43.877  1.00 15.89           C  
ATOM  13299  NE  ARG    57      98.101  56.563  45.097  1.00 15.63           N  
ATOM  13300  CZ  ARG    57      99.287  57.153  45.256  1.00 16.91           C  
ATOM  13301  NH1 ARG    57     100.160  57.249  44.259  1.00 13.83           N  
ATOM  13302  NH2 ARG    57      99.613  57.651  46.435  1.00 15.00           N  
ATOM  13303  N   ASP    58      97.051  51.278  44.341  1.00 16.23           N  
ATOM  13304  CA  ASP    58      96.620  50.693  45.608  1.00 16.54           C  
ATOM  13305  C   ASP    58      96.524  49.169  45.557  1.00 16.62           C  
ATOM  13306  O   ASP    58      96.664  48.506  46.600  1.00 16.58           O  
ATOM  13307  CB  ASP    58      95.275  51.259  45.998  1.00 16.42           C  
ATOM  13308  CG  ASP    58      95.312  52.769  46.142  1.00 17.20           C  
ATOM  13309  OD1 ASP    58      96.112  53.243  46.982  1.00 19.65           O  
ATOM  13310  OD2 ASP    58      94.531  53.456  45.451  1.00 18.16           O  
ATOM  13311  N   VAL    59      96.242  48.632  44.377  1.00 16.45           N  
ATOM  13312  CA  VAL    59      96.058  47.197  44.212  1.00 17.77           C  
ATOM  13313  C   VAL    59      96.785  46.737  42.956  1.00 17.83           C  
ATOM  13314  O   VAL    59      96.926  47.493  41.987  1.00 17.33           O  
ATOM  13315  CB  VAL    59      94.554  46.767  44.189  1.00 18.87           C  
ATOM  13316  CG1 VAL    59      93.778  47.334  45.449  1.00 21.82           C  
ATOM  13317  CG2 VAL    59      93.896  47.197  42.965  1.00 21.44           C  
ATOM  13318  N   ASP    60      97.285  45.515  43.025  1.00 18.74           N  
ATOM  13319  CA  ASP    60      97.964  44.879  41.909  1.00 19.34           C  
ATOM  13320  C   ASP    60      96.992  44.080  41.043  1.00 19.48           C  
ATOM  13321  O   ASP    60      95.805  44.037  41.332  1.00 19.40           O  
ATOM  13322  CB  ASP    60      99.147  44.040  42.405  1.00 20.89           C  
ATOM  13323  CG  ASP    60      98.757  42.848  43.254  1.00 21.21           C  
ATOM  13324  OD1 ASP    60      97.589  42.484  43.394  1.00 22.81           O  
ATOM  13325  OD2 ASP    60      99.713  42.231  43.792  1.00 30.25           O  
ATOM  13326  N   VAL    61      97.486  43.487  39.967  1.00 18.59           N  
ATOM  13327  CA  VAL    61      96.614  42.760  39.045  1.00 19.30           C  
ATOM  13328  C   VAL    61      95.938  41.568  39.757  1.00 18.76           C  
ATOM  13329  O   VAL    61      94.732  41.355  39.623  1.00 19.22           O  
ATOM  13330  CB  VAL    61      97.352  42.330  37.761  1.00 19.44           C  
ATOM  13331  CG1 VAL    61      96.504  41.337  36.953  1.00 20.46           C  
ATOM  13332  CG2 VAL    61      97.699  43.573  36.911  1.00 19.62           C  
ATOM  13333  N   ALA    62      96.695  40.801  40.523  1.00 18.89           N  
ATOM  13334  CA  ALA    62      96.120  39.649  41.215  1.00 19.10           C  
ATOM  13335  C   ALA    62      94.973  40.048  42.139  1.00 19.10           C  
ATOM  13336  O   ALA    62      93.905  39.417  42.132  1.00 18.61           O  
ATOM  13337  CB  ALA    62      97.209  38.899  42.012  1.00 19.82           C  
ATOM  13338  N   SER    63      95.178  41.088  42.960  1.00 18.52           N  
ATOM  13339  CA  SER    63      94.126  41.541  43.854  1.00 19.00           C  
ATOM  13340  C   SER    63      92.917  42.037  43.057  1.00 18.56           C  
ATOM  13341  O   SER    63      91.790  41.803  43.432  1.00 18.58           O  
ATOM  13342  CB  SER    63      94.622  42.645  44.745  1.00 19.24           C  
ATOM  13343  OG  SER    63      95.617  42.148  45.586  1.00 20.64           O  
ATOM  13344  N   ALA    64      93.164  42.778  41.983  1.00 18.32           N  
ATOM  13345  CA  ALA    64      92.088  43.282  41.124  1.00 18.22           C  
ATOM  13346  C   ALA    64      91.295  42.123  40.447  1.00 17.22           C  
ATOM  13347  O   ALA    64      90.093  42.203  40.247  1.00 15.74           O  
ATOM  13348  CB  ALA    64      92.667  44.231  40.071  1.00 18.00           C  
ATOM  13349  N   GLN    65      92.005  41.065  40.095  1.00 18.13           N  
ATOM  13350  CA  GLN    65      91.374  39.867  39.554  1.00 19.19           C  
ATOM  13351  C   GLN    65      90.392  39.274  40.566  1.00 19.55           C  
ATOM  13352  O   GLN    65      89.268  38.896  40.194  1.00 19.43           O  
ATOM  13353  CB  GLN    65      92.424  38.845  39.097  1.00 18.99           C  
ATOM  13354  CG  GLN    65      93.078  39.208  37.762  1.00 19.83           C  
ATOM  13355  CD  GLN    65      94.275  38.344  37.421  1.00 19.98           C  
ATOM  13356  OE1 GLN    65      94.942  37.792  38.312  1.00 23.49           O  
ATOM  13357  NE2 GLN    65      94.541  38.184  36.114  1.00 20.84           N  
ATOM  13358  N   ARG    66      90.789  39.194  41.835  1.00 20.27           N  
ATOM  13359  CA  ARG    66      89.877  38.774  42.884  1.00 19.80           C  
ATOM  13360  C   ARG    66      88.688  39.723  43.034  1.00 19.12           C  
ATOM  13361  O   ARG    66      87.559  39.289  43.213  1.00 18.72           O  
ATOM  13362  CB  ARG    66      90.597  38.676  44.215  1.00 21.46           C  
ATOM  13363  CG  ARG    66      89.674  38.205  45.361  1.00 25.65           C  
ATOM  13364  CD  ARG    66      89.298  36.727  45.200  1.00 36.25           C  
ATOM  13365  NE  ARG    66      90.392  35.890  45.691  1.00 41.73           N  
ATOM  13366  CZ  ARG    66      90.704  34.644  45.300  1.00 44.24           C  
ATOM  13367  NH1 ARG    66      90.018  33.988  44.357  1.00 45.76           N  
ATOM  13368  NH2 ARG    66      91.746  34.039  45.876  1.00 45.36           N  
ATOM  13369  N   ALA    67      88.915  41.023  42.911  1.00 18.19           N  
ATOM  13370  CA  ALA    67      87.776  41.975  42.854  1.00 17.76           C  
ATOM  13371  C   ALA    67      86.826  41.622  41.708  1.00 17.38           C  
ATOM  13372  O   ALA    67      85.599  41.617  41.892  1.00 17.68           O  
ATOM  13373  CB  ALA    67      88.270  43.434  42.700  1.00 18.27           C  
ATOM  13374  N   ALA    68      87.399  41.298  40.541  1.00 16.79           N  
ATOM  13375  CA  ALA    68      86.601  40.982  39.365  1.00 17.36           C  
ATOM  13376  C   ALA    68      85.816  39.681  39.613  1.00 17.31           C  
ATOM  13377  O   ALA    68      84.630  39.612  39.301  1.00 17.42           O  
ATOM  13378  CB  ALA    68      87.459  40.881  38.124  1.00 16.52           C  
ATOM  13379  N   GLU    69      86.469  38.683  40.196  1.00 17.93           N  
ATOM  13380  CA  GLU    69      85.784  37.441  40.576  1.00 18.71           C  
ATOM  13381  C   GLU    69      84.583  37.751  41.484  1.00 18.93           C  
ATOM  13382  O   GLU    69      83.471  37.242  41.241  1.00 18.31           O  
ATOM  13383  CB  GLU    69      86.757  36.477  41.251  1.00 19.08           C  
ATOM  13384  CG  GLU    69      87.806  35.902  40.322  1.00 21.15           C  
ATOM  13385  CD  GLU    69      88.858  35.066  41.051  1.00 22.14           C  
ATOM  13386  OE1 GLU    69      89.114  35.313  42.248  1.00 26.87           O  
ATOM  13387  OE2 GLU    69      89.424  34.144  40.439  1.00 27.07           O  
ATOM  13388  N   LEU    70      84.785  38.602  42.502  1.00 18.58           N  
ATOM  13389  CA  LEU    70      83.696  38.968  43.407  1.00 18.83           C  
ATOM  13390  C   LEU    70      82.568  39.708  42.680  1.00 19.23           C  
ATOM  13391  O   LEU    70      81.381  39.501  42.991  1.00 19.11           O  
ATOM  13392  CB  LEU    70      84.211  39.780  44.620  1.00 19.41           C  
ATOM  13393  CG  LEU    70      85.076  39.021  45.631  1.00 19.00           C  
ATOM  13394  CD1 LEU    70      85.801  39.978  46.576  1.00 19.47           C  
ATOM  13395  CD2 LEU    70      84.185  37.995  46.377  1.00 21.35           C  
ATOM  13396  N   CYS    71      82.915  40.595  41.740  1.00 18.39           N  
ATOM  13397  CA  CYS    71      81.884  41.296  40.973  1.00 18.21           C  
ATOM  13398  C   CYS    71      81.020  40.255  40.259  1.00 18.12           C  
ATOM  13399  O   CYS    71      79.783  40.380  40.219  1.00 18.48           O  
ATOM  13400  CB  CYS    71      82.523  42.263  39.959  1.00 18.28           C  
ATOM  13401  SG  CYS    71      83.354  43.707  40.748  1.00 17.98           S  
ATOM  13402  N   ALA    72      81.702  39.258  39.697  1.00 18.14           N  
ATOM  13403  CA  ALA    72      81.087  38.152  38.925  1.00 18.89           C  
ATOM  13404  C   ALA    72      80.191  37.309  39.820  1.00 19.05           C  
ATOM  13405  O   ALA    72      79.114  36.921  39.394  1.00 18.95           O  
ATOM  13406  CB  ALA    72      82.163  37.286  38.228  1.00 19.28           C  
ATOM  13407  N   VAL    73      80.632  37.045  41.048  1.00 19.61           N  
ATOM  13408  CA  VAL    73      79.815  36.298  42.031  1.00 20.01           C  
ATOM  13409  C   VAL    73      78.521  37.045  42.369  1.00 20.13           C  
ATOM  13410  O   VAL    73      77.428  36.449  42.460  1.00 20.48           O  
ATOM  13411  CB  VAL    73      80.633  36.004  43.330  1.00 20.82           C  
ATOM  13412  CG1 VAL    73      79.714  35.513  44.502  1.00 21.02           C  
ATOM  13413  CG2 VAL    73      81.772  35.052  43.029  1.00 19.80           C  
ATOM  13414  N   ASN    74      78.651  38.353  42.525  1.00 20.11           N  
ATOM  13415  CA  ASN    74      77.538  39.245  42.782  1.00 19.82           C  
ATOM  13416  C   ASN    74      76.578  39.319  41.600  1.00 19.58           C  
ATOM  13417  O   ASN    74      75.340  39.315  41.782  1.00 19.11           O  
ATOM  13418  CB  ASN    74      78.047  40.618  43.245  1.00 21.09           C  
ATOM  13419  CG  ASN    74      78.475  40.618  44.708  1.00 20.96           C  
ATOM  13420  OD1 ASN    74      79.667  40.497  45.044  1.00 25.84           O  
ATOM  13421  ND2 ASN    74      77.513  40.757  45.583  1.00 21.36           N  
ATOM  13422  N   ILE    75      77.117  39.332  40.385  1.00 19.22           N  
ATOM  13423  CA  ILE    75      76.266  39.262  39.188  1.00 19.73           C  
ATOM  13424  C   ILE    75      75.449  37.952  39.240  1.00 19.91           C  
ATOM  13425  O   ILE    75      74.232  37.959  39.042  1.00 21.28           O  
ATOM  13426  CB  ILE    75      77.082  39.318  37.856  1.00 20.26           C  
ATOM  13427  CG1 ILE    75      77.721  40.707  37.642  1.00 20.27           C  
ATOM  13428  CG2 ILE    75      76.193  38.957  36.665  1.00 18.77           C  
ATOM  13429  CD1 ILE    75      78.803  40.768  36.489  1.00 19.64           C  
ATOM  13430  N   LEU    76      76.126  36.852  39.510  1.00 20.16           N  
ATOM  13431  CA  LEU    76      75.459  35.515  39.533  1.00 20.33           C  
ATOM  13432  C   LEU    76      74.366  35.460  40.615  1.00 20.78           C  
ATOM  13433  O   LEU    76      73.297  34.907  40.379  1.00 21.42           O  
ATOM  13434  CB  LEU    76      76.486  34.394  39.689  1.00 20.53           C  
ATOM  13435  CG  LEU    76      77.372  34.118  38.484  1.00 20.87           C  
ATOM  13436  CD1 LEU    76      78.458  33.098  38.825  1.00 22.97           C  
ATOM  13437  CD2 LEU    76      76.544  33.679  37.260  1.00 23.02           C  
ATOM  13438  N   ALA    77      74.614  36.063  41.784  1.00 21.14           N  
ATOM  13439  CA  ALA    77      73.597  36.165  42.832  1.00 21.04           C  
ATOM  13440  C   ALA    77      72.361  36.891  42.300  1.00 21.95           C  
ATOM  13441  O   ALA    77      71.217  36.466  42.522  1.00 21.90           O  
ATOM  13442  CB  ALA    77      74.162  36.883  44.086  1.00 20.99           C  
ATOM  13443  N   GLN    78      72.587  37.993  41.581  1.00 21.45           N  
ATOM  13444  CA  GLN    78      71.473  38.745  41.023  1.00 22.10           C  
ATOM  13445  C   GLN    78      70.713  37.927  39.965  1.00 21.79           C  
ATOM  13446  O   GLN    78      69.486  37.929  39.936  1.00 22.55           O  
ATOM  13447  CB  GLN    78      71.950  40.077  40.422  1.00 22.09           C  
ATOM  13448  CG  GLN    78      72.508  41.105  41.436  1.00 24.22           C  
ATOM  13449  CD  GLN    78      71.567  41.457  42.585  1.00 27.40           C  
ATOM  13450  OE1 GLN    78      70.352  41.227  42.543  1.00 31.81           O  
ATOM  13451  NE2 GLN    78      72.141  42.054  43.621  1.00 33.24           N  
ATOM  13452  N   VAL    79      71.444  37.235  39.103  1.00 22.19           N  
ATOM  13453  CA  VAL    79      70.817  36.392  38.091  1.00 22.65           C  
ATOM  13454  C   VAL    79      69.980  35.285  38.732  1.00 23.28           C  
ATOM  13455  O   VAL    79      68.872  35.003  38.273  1.00 23.03           O  
ATOM  13456  CB  VAL    79      71.835  35.795  37.119  1.00 23.12           C  
ATOM  13457  CG1 VAL    79      71.136  34.895  36.134  1.00 23.37           C  
ATOM  13458  CG2 VAL    79      72.623  36.932  36.374  1.00 22.03           C  
ATOM  13459  N   LYS    80      70.507  34.673  39.779  1.00 23.69           N  
ATOM  13460  CA  LYS    80      69.799  33.611  40.478  1.00 24.34           C  
ATOM  13461  C   LYS    80      68.501  34.164  41.053  1.00 25.02           C  
ATOM  13462  O   LYS    80      67.442  33.517  40.935  1.00 25.88           O  
ATOM  13463  CB  LYS    80      70.672  33.018  41.576  1.00 24.54           C  
ATOM  13464  CG  LYS    80      69.980  31.893  42.358  1.00 24.65           C  
ATOM  13465  CD  LYS    80      70.809  31.421  43.510  1.00 25.01           C  
ATOM  13466  CE  LYS    80      69.995  30.487  44.426  1.00 26.39           C  
ATOM  13467  NZ  LYS    80      70.884  29.674  45.302  1.00 27.82           N  
ATOM  13468  N   ALA    81      68.564  35.351  41.664  1.00 25.16           N  
ATOM  13469  CA  ALA    81      67.346  36.048  42.148  1.00 25.31           C  
ATOM  13470  C   ALA    81      66.342  36.341  41.017  1.00 25.95           C  
ATOM  13471  O   ALA    81      65.141  36.042  41.158  1.00 25.62           O  
ATOM  13472  CB  ALA    81      67.697  37.329  42.899  1.00 25.25           C  
ATOM  13473  N   ALA    82      66.827  36.906  39.908  1.00 25.86           N  
ATOM  13474  CA  ALA    82      66.008  37.146  38.720  1.00 26.45           C  
ATOM  13475  C   ALA    82      65.358  35.846  38.201  1.00 26.96           C  
ATOM  13476  O   ALA    82      64.253  35.900  37.645  1.00 27.66           O  
ATOM  13477  CB  ALA    82      66.813  37.773  37.611  1.00 25.68           C  
ATOM  13478  N   LEU    83      66.034  34.712  38.370  1.00 27.25           N  
ATOM  13479  CA  LEU    83      65.568  33.458  37.785  1.00 28.53           C  
ATOM  13480  C   LEU    83      64.892  32.546  38.810  1.00 29.77           C  
ATOM  13481  O   LEU    83      64.768  31.322  38.610  1.00 29.23           O  
ATOM  13482  CB  LEU    83      66.721  32.761  37.070  1.00 28.68           C  
ATOM  13483  CG  LEU    83      67.336  33.509  35.875  1.00 27.34           C  
ATOM  13484  CD1 LEU    83      68.442  32.677  35.265  1.00 27.66           C  
ATOM  13485  CD2 LEU    83      66.303  33.910  34.809  1.00 26.22           C  
ATOM  13486  N   ASN    84      64.439  33.159  39.895  1.00 30.56           N  
ATOM  13487  CA  ASN    84      63.729  32.463  40.972  1.00 32.17           C  
ATOM  13488  C   ASN    84      64.473  31.244  41.527  1.00 32.90           C  
ATOM  13489  O   ASN    84      63.869  30.207  41.867  1.00 33.06           O  
ATOM  13490  CB  ASN    84      62.309  32.124  40.501  1.00 32.69           C  
ATOM  13491  CG  ASN    84      61.490  33.372  40.221  1.00 35.55           C  
ATOM  13492  OD1 ASN    84      60.912  33.525  39.134  1.00 41.64           O  
ATOM  13493  ND2 ASN    84      61.455  34.290  41.192  1.00 39.24           N  
ATOM  13494  N   GLY    85      65.789  31.382  41.634  1.00 33.09           N  
ATOM  13495  CA  GLY    85      66.645  30.371  42.227  1.00 33.47           C  
ATOM  13496  C   GLY    85      67.306  29.487  41.196  1.00 34.39           C  
ATOM  13497  O   GLY    85      68.029  28.555  41.537  1.00 35.05           O  
ATOM  13498  N   ASP    86      67.097  29.793  39.927  1.00 35.62           N  
ATOM  13499  CA  ASP    86      67.425  28.850  38.869  1.00 36.87           C  
ATOM  13500  C   ASP    86      68.531  29.305  37.873  1.00 36.44           C  
ATOM  13501  O   ASP    86      68.241  29.668  36.744  1.00 36.29           O  
ATOM  13502  CB  ASP    86      66.107  28.532  38.145  1.00 37.68           C  
ATOM  13503  CG  ASP    86      66.135  27.208  37.412  1.00 40.66           C  
ATOM  13504  OD1 ASP    86      67.157  26.494  37.471  1.00 44.08           O  
ATOM  13505  OD2 ASP    86      65.116  26.881  36.763  1.00 45.09           O  
ATOM  13506  N   LEU    87      69.796  29.225  38.285  1.00 36.56           N  
ATOM  13507  CA  LEU    87      70.940  29.570  37.412  1.00 36.56           C  
ATOM  13508  C   LEU    87      71.040  28.748  36.105  1.00 36.34           C  
ATOM  13509  O   LEU    87      71.796  29.096  35.196  1.00 35.79           O  
ATOM  13510  CB  LEU    87      72.272  29.500  38.182  1.00 36.86           C  
ATOM  13511  CG  LEU    87      72.623  30.693  39.091  1.00 36.88           C  
ATOM  13512  CD1 LEU    87      73.967  30.459  39.777  1.00 36.37           C  
ATOM  13513  CD2 LEU    87      72.640  32.048  38.326  1.00 36.15           C  
ATOM  13514  N   SER    88      70.275  27.665  36.024  1.00 36.37           N  
ATOM  13515  CA  SER    88      70.251  26.801  34.847  1.00 35.94           C  
ATOM  13516  C   SER    88      69.374  27.362  33.727  1.00 35.17           C  
ATOM  13517  O   SER    88      69.432  26.891  32.595  1.00 35.24           O  
ATOM  13518  CB  SER    88      69.754  25.418  35.260  1.00 36.16           C  
ATOM  13519  OG  SER    88      68.473  25.510  35.846  1.00 37.19           O  
ATOM  13520  N   LYS    89      68.583  28.382  34.056  1.00 34.43           N  
ATOM  13521  CA  LYS    89      67.792  29.109  33.080  1.00 33.77           C  
ATOM  13522  C   LYS    89      68.571  30.213  32.358  1.00 32.24           C  
ATOM  13523  O   LYS    89      67.994  30.935  31.545  1.00 32.12           O  
ATOM  13524  CB  LYS    89      66.543  29.690  33.739  1.00 34.20           C  
ATOM  13525  CG  LYS    89      65.489  28.606  34.078  1.00 35.37           C  
ATOM  13526  CD  LYS    89      64.197  29.224  34.590  1.00 36.03           C  
ATOM  13527  CE  LYS    89      63.040  28.177  34.705  1.00 37.98           C  
ATOM  13528  NZ  LYS    89      62.891  27.610  36.082  1.00 39.34           N  
ATOM  13529  N   ILE    90      69.865  30.341  32.642  1.00 30.91           N  
ATOM  13530  CA  ILE    90      70.740  31.151  31.793  1.00 30.51           C  
ATOM  13531  C   ILE    90      70.915  30.437  30.434  1.00 30.01           C  
ATOM  13532  O   ILE    90      71.329  29.275  30.387  1.00 31.25           O  
ATOM  13533  CB  ILE    90      72.141  31.392  32.445  1.00 30.19           C  
ATOM  13534  CG1 ILE    90      72.004  32.133  33.787  1.00 29.03           C  
ATOM  13535  CG2 ILE    90      73.086  32.137  31.461  1.00 29.03           C  
ATOM  13536  CD1 ILE    90      73.322  32.266  34.564  1.00 30.48           C  
ATOM  13537  N   ARG    91      70.602  31.114  29.336  1.00 28.51           N  
ATOM  13538  CA  ARG    91      70.882  30.563  28.010  1.00 29.50           C  
ATOM  13539  C   ARG    91      72.270  30.959  27.522  1.00 27.41           C  
ATOM  13540  O   ARG    91      73.007  30.149  26.963  1.00 25.76           O  
ATOM  13541  CB  ARG    91      69.802  30.984  27.021  1.00 29.42           C  
ATOM  13542  CG  ARG    91      68.469  30.319  27.356  1.00 33.12           C  
ATOM  13543  CD  ARG    91      67.261  30.999  26.705  1.00 35.92           C  
ATOM  13544  NE  ARG    91      67.355  31.013  25.251  1.00 43.12           N  
ATOM  13545  CZ  ARG    91      67.218  29.942  24.465  1.00 46.08           C  
ATOM  13546  NH1 ARG    91      66.945  28.734  24.973  1.00 47.97           N  
ATOM  13547  NH2 ARG    91      67.346  30.092  23.143  1.00 46.98           N  
ATOM  13548  N   ARG    92      72.634  32.203  27.780  1.00 25.79           N  
ATOM  13549  CA  ARG    92      73.916  32.748  27.347  1.00 25.72           C  
ATOM  13550  C   ARG    92      74.201  34.042  28.094  1.00 23.76           C  
ATOM  13551  O   ARG    92      73.289  34.873  28.245  1.00 22.58           O  
ATOM  13552  CB  ARG    92      73.835  33.054  25.862  1.00 26.82           C  
ATOM  13553  CG  ARG    92      74.885  33.989  25.316  1.00 31.69           C  
ATOM  13554  CD  ARG    92      75.607  33.399  24.154  1.00 37.13           C  
ATOM  13555  NE  ARG    92      76.890  32.858  24.594  1.00 40.03           N  
ATOM  13556  CZ  ARG    92      77.376  31.648  24.306  1.00 42.08           C  
ATOM  13557  NH1 ARG    92      76.702  30.777  23.546  1.00 43.85           N  
ATOM  13558  NH2 ARG    92      78.569  31.303  24.771  1.00 40.04           N  
ATOM  13559  N   VAL    93      75.433  34.184  28.586  1.00 21.68           N  
ATOM  13560  CA  VAL    93      75.905  35.473  29.055  1.00 20.41           C  
ATOM  13561  C   VAL    93      76.303  36.221  27.782  1.00 20.28           C  
ATOM  13562  O   VAL    93      77.259  35.856  27.069  1.00 21.18           O  
ATOM  13563  CB  VAL    93      77.080  35.374  30.075  1.00 20.10           C  
ATOM  13564  CG1 VAL    93      77.543  36.778  30.511  1.00 20.34           C  
ATOM  13565  CG2 VAL    93      76.685  34.513  31.307  1.00 20.35           C  
ATOM  13566  N   ILE    94      75.543  37.252  27.472  1.00 19.62           N  
ATOM  13567  CA  ILE    94      75.707  37.970  26.218  1.00 19.82           C  
ATOM  13568  C   ILE    94      76.892  38.962  26.232  1.00 19.77           C  
ATOM  13569  O   ILE    94      77.686  39.016  25.272  1.00 19.63           O  
ATOM  13570  CB  ILE    94      74.405  38.688  25.859  1.00 20.18           C  
ATOM  13571  CG1 ILE    94      73.341  37.638  25.511  1.00 21.26           C  
ATOM  13572  CG2 ILE    94      74.574  39.644  24.658  1.00 20.74           C  
ATOM  13573  CD1 ILE    94      73.669  36.882  24.212  1.00 25.02           C  
ATOM  13574  N   LYS    95      77.009  39.701  27.338  1.00 19.20           N  
ATOM  13575  CA  LYS    95      77.963  40.817  27.444  1.00 18.28           C  
ATOM  13576  C   LYS    95      78.268  41.140  28.913  1.00 18.11           C  
ATOM  13577  O   LYS    95      77.377  41.166  29.740  1.00 17.68           O  
ATOM  13578  CB  LYS    95      77.362  42.031  26.756  1.00 18.02           C  
ATOM  13579  CG  LYS    95      78.180  43.334  26.821  1.00 18.92           C  
ATOM  13580  CD  LYS    95      79.388  43.233  25.899  1.00 17.97           C  
ATOM  13581  CE  LYS    95      80.246  44.514  25.891  1.00 19.41           C  
ATOM  13582  NZ  LYS    95      79.470  45.692  25.394  1.00 20.19           N  
ATOM  13583  N   LEU    96      79.537  41.389  29.220  1.00 18.19           N  
ATOM  13584  CA  LEU    96      79.951  41.957  30.513  1.00 17.80           C  
ATOM  13585  C   LEU    96      80.658  43.271  30.202  1.00 17.10           C  
ATOM  13586  O   LEU    96      81.468  43.325  29.258  1.00 17.15           O  
ATOM  13587  CB  LEU    96      80.942  41.045  31.244  1.00 18.83           C  
ATOM  13588  CG  LEU    96      80.585  39.667  31.800  1.00 20.85           C  
ATOM  13589  CD1 LEU    96      81.711  39.277  32.729  1.00 22.50           C  
ATOM  13590  CD2 LEU    96      79.206  39.674  32.520  1.00 21.93           C  
ATOM  13591  N   ASN    97      80.329  44.321  30.946  1.00 16.61           N  
ATOM  13592  CA  ASN    97      81.130  45.529  30.906  1.00 16.14           C  
ATOM  13593  C   ASN    97      81.933  45.623  32.183  1.00 15.02           C  
ATOM  13594  O   ASN    97      81.375  45.796  33.268  1.00 14.66           O  
ATOM  13595  CB  ASN    97      80.289  46.767  30.662  1.00 16.88           C  
ATOM  13596  CG  ASN    97      79.486  46.689  29.385  1.00 18.53           C  
ATOM  13597  OD1 ASN    97      78.257  46.535  29.404  1.00 23.42           O  
ATOM  13598  ND2 ASN    97      80.171  46.786  28.273  1.00 15.75           N  
ATOM  13599  N   GLY    98      83.256  45.563  32.012  1.00 14.82           N  
ATOM  13600  CA  GLY    98      84.185  45.561  33.119  1.00 15.02           C  
ATOM  13601  C   GLY    98      84.852  46.915  33.285  1.00 15.44           C  
ATOM  13602  O   GLY    98      85.617  47.349  32.412  1.00 16.65           O  
ATOM  13603  N   PHE    99      84.542  47.593  34.386  1.00 15.14           N  
ATOM  13604  CA  PHE    99      85.102  48.870  34.692  1.00 14.44           C  
ATOM  13605  C   PHE    99      86.167  48.697  35.768  1.00 14.30           C  
ATOM  13606  O   PHE    99      85.866  48.199  36.872  1.00 14.95           O  
ATOM  13607  CB  PHE    99      83.973  49.765  35.171  1.00 15.41           C  
ATOM  13608  CG  PHE    99      82.790  49.765  34.262  1.00 16.64           C  
ATOM  13609  CD1 PHE    99      82.914  50.201  32.953  1.00 22.14           C  
ATOM  13610  CD2 PHE    99      81.554  49.354  34.715  1.00 19.51           C  
ATOM  13611  CE1 PHE    99      81.807  50.224  32.110  1.00 22.73           C  
ATOM  13612  CE2 PHE    99      80.456  49.391  33.888  1.00 20.40           C  
ATOM  13613  CZ  PHE    99      80.577  49.822  32.604  1.00 19.17           C  
ATOM  13614  N   VAL   100      87.401  49.093  35.463  1.00 12.97           N  
ATOM  13615  CA  VAL   100      88.533  48.945  36.395  1.00 13.47           C  
ATOM  13616  C   VAL   100      89.113  50.315  36.797  1.00 13.53           C  
ATOM  13617  O   VAL   100      89.639  51.033  35.962  1.00 13.48           O  
ATOM  13618  CB  VAL   100      89.674  48.129  35.768  1.00 12.63           C  
ATOM  13619  CG1 VAL   100      90.810  47.914  36.819  1.00 13.13           C  
ATOM  13620  CG2 VAL   100      89.172  46.827  35.121  1.00 14.55           C  
ATOM  13621  N   ALA   101      89.018  50.651  38.073  1.00 13.61           N  
ATOM  13622  CA  ALA   101      89.573  51.922  38.591  1.00 13.39           C  
ATOM  13623  C   ALA   101      91.080  51.820  38.411  1.00 13.93           C  
ATOM  13624  O   ALA   101      91.703  50.866  38.925  1.00 12.78           O  
ATOM  13625  CB  ALA   101      89.195  52.132  40.064  1.00 13.54           C  
ATOM  13626  N   SER   102      91.652  52.751  37.644  1.00 13.96           N  
ATOM  13627  CA  SER   102      93.014  52.597  37.122  1.00 13.76           C  
ATOM  13628  C   SER   102      93.783  53.879  37.237  1.00 13.85           C  
ATOM  13629  O   SER   102      93.239  54.942  37.020  1.00 13.85           O  
ATOM  13630  CB  SER   102      92.952  52.234  35.615  1.00 13.46           C  
ATOM  13631  OG  SER   102      92.318  50.995  35.346  1.00 15.64           O  
ATOM  13632  N   VAL   103      95.081  53.795  37.542  1.00 14.08           N  
ATOM  13633  CA  VAL   103      95.940  54.957  37.235  1.00 13.49           C  
ATOM  13634  C   VAL   103      96.211  54.943  35.728  1.00 14.32           C  
ATOM  13635  O   VAL   103      96.076  53.907  35.086  1.00 14.13           O  
ATOM  13636  CB  VAL   103      97.260  54.995  38.049  1.00 13.45           C  
ATOM  13637  CG1 VAL   103      96.964  55.212  39.528  1.00 13.30           C  
ATOM  13638  CG2 VAL   103      98.085  53.757  37.857  1.00 14.31           C  
ATOM  13639  N   PRO   104      96.528  56.120  35.158  1.00 14.49           N  
ATOM  13640  CA  PRO   104      96.705  56.218  33.710  1.00 15.18           C  
ATOM  13641  C   PRO   104      97.820  55.375  33.100  1.00 15.45           C  
ATOM  13642  O   PRO   104      97.786  55.109  31.890  1.00 17.16           O  
ATOM  13643  CB  PRO   104      96.935  57.712  33.487  1.00 15.35           C  
ATOM  13644  CG  PRO   104      96.279  58.366  34.685  1.00 16.48           C  
ATOM  13645  CD  PRO   104      96.631  57.440  35.786  1.00 15.15           C  
ATOM  13646  N   GLU   105      98.781  54.941  33.908  1.00 15.63           N  
ATOM  13647  CA  GLU   105      99.839  54.061  33.433  1.00 14.99           C  
ATOM  13648  C   GLU   105      99.426  52.591  33.472  1.00 15.57           C  
ATOM  13649  O   GLU   105     100.143  51.745  32.983  1.00 15.51           O  
ATOM  13650  CB  GLU   105     101.129  54.233  34.247  1.00 15.82           C  
ATOM  13651  CG  GLU   105     101.751  55.606  34.111  1.00 14.48           C  
ATOM  13652  CD  GLU   105     100.908  56.711  34.727  1.00 14.59           C  
ATOM  13653  OE1 GLU   105     100.406  56.563  35.871  1.00 15.16           O  
ATOM  13654  OE2 GLU   105     100.751  57.745  34.035  1.00 15.78           O  
ATOM  13655  N   PHE   106      98.296  52.297  34.120  1.00 15.66           N  
ATOM  13656  CA  PHE   106      97.815  50.921  34.211  1.00 15.19           C  
ATOM  13657  C   PHE   106      97.034  50.567  32.952  1.00 15.21           C  
ATOM  13658  O   PHE   106      96.053  51.238  32.616  1.00 15.33           O  
ATOM  13659  CB  PHE   106      96.970  50.643  35.451  1.00 15.12           C  
ATOM  13660  CG  PHE   106      96.527  49.222  35.524  1.00 14.69           C  
ATOM  13661  CD1 PHE   106      97.460  48.191  35.776  1.00 13.97           C  
ATOM  13662  CD2 PHE   106      95.195  48.878  35.251  1.00 14.24           C  
ATOM  13663  CE1 PHE   106      97.055  46.849  35.796  1.00 16.21           C  
ATOM  13664  CE2 PHE   106      94.808  47.554  35.251  1.00 16.36           C  
ATOM  13665  CZ  PHE   106      95.711  46.545  35.530  1.00 15.69           C  
ATOM  13666  N   VAL   107      97.492  49.515  32.274  1.00 15.49           N  
ATOM  13667  CA  VAL   107      96.959  49.139  30.942  1.00 15.51           C  
ATOM  13668  C   VAL   107      96.660  47.626  30.810  1.00 16.14           C  
ATOM  13669  O   VAL   107      96.676  47.065  29.678  1.00 17.46           O  
ATOM  13670  CB  VAL   107      97.875  49.636  29.813  1.00 15.35           C  
ATOM  13671  CG1 VAL   107      97.910  51.181  29.745  1.00 16.15           C  
ATOM  13672  CG2 VAL   107      99.308  49.001  29.940  1.00 17.34           C  
ATOM  13673  N   GLU   108      96.342  46.976  31.937  1.00 15.75           N  
ATOM  13674  CA  GLU   108      96.023  45.560  31.913  1.00 16.38           C  
ATOM  13675  C   GLU   108      94.628  45.285  32.422  1.00 15.43           C  
ATOM  13676  O   GLU   108      94.352  44.262  33.088  1.00 16.13           O  
ATOM  13677  CB  GLU   108      97.076  44.777  32.693  1.00 16.44           C  
ATOM  13678  CG  GLU   108      98.436  44.788  32.033  1.00 19.85           C  
ATOM  13679  CD  GLU   108      99.523  44.263  32.973  1.00 20.58           C  
ATOM  13680  OE1 GLU   108      99.742  44.801  34.079  1.00 29.71           O  
ATOM  13681  OE2 GLU   108     100.165  43.306  32.588  1.00 28.76           O  
ATOM  13682  N   GLN   109      93.705  46.167  32.065  1.00 15.62           N  
ATOM  13683  CA  GLN   109      92.320  45.982  32.468  1.00 15.33           C  
ATOM  13684  C   GLN   109      91.738  44.684  31.902  1.00 15.79           C  
ATOM  13685  O   GLN   109      90.865  44.105  32.513  1.00 16.28           O  
ATOM  13686  CB  GLN   109      91.473  47.148  32.024  1.00 15.81           C  
ATOM  13687  CG  GLN   109      91.813  48.476  32.661  1.00 14.14           C  
ATOM  13688  CD  GLN   109      92.960  49.238  31.952  1.00 15.09           C  
ATOM  13689  OE1 GLN   109      93.533  48.780  30.938  1.00 14.45           O  
ATOM  13690  NE2 GLN   109      93.277  50.409  32.470  1.00 14.52           N  
ATOM  13691  N   HIS   110      92.217  44.249  30.747  1.00 15.52           N  
ATOM  13692  CA  HIS   110      91.773  42.945  30.180  1.00 15.97           C  
ATOM  13693  C   HIS   110      92.129  41.795  31.114  1.00 15.78           C  
ATOM  13694  O   HIS   110      91.333  40.912  31.357  1.00 16.32           O  
ATOM  13695  CB  HIS   110      92.311  42.739  28.739  1.00 16.72           C  
ATOM  13696  CG  HIS   110      93.809  42.789  28.627  1.00 17.04           C  
ATOM  13697  ND1 HIS   110      94.550  43.909  28.945  1.00 19.60           N  
ATOM  13698  CD2 HIS   110      94.705  41.843  28.259  1.00 22.76           C  
ATOM  13699  CE1 HIS   110      95.839  43.643  28.780  1.00 20.17           C  
ATOM  13700  NE2 HIS   110      95.958  42.394  28.373  1.00 21.32           N  
ATOM  13701  N   LEU   111      93.330  41.821  31.669  1.00 16.38           N  
ATOM  13702  CA  LEU   111      93.763  40.836  32.657  1.00 16.96           C  
ATOM  13703  C   LEU   111      92.924  40.851  33.932  1.00 17.46           C  
ATOM  13704  O   LEU   111      92.575  39.786  34.492  1.00 19.02           O  
ATOM  13705  CB  LEU   111      95.239  41.050  32.982  1.00 17.06           C  
ATOM  13706  CG  LEU   111      96.187  40.875  31.779  1.00 17.72           C  
ATOM  13707  CD1 LEU   111      97.635  40.909  32.274  1.00 21.15           C  
ATOM  13708  CD2 LEU   111      95.918  39.613  30.974  1.00 21.14           C  
ATOM  13709  N   VAL   112      92.592  42.051  34.377  1.00 16.80           N  
ATOM  13710  CA  VAL   112      91.777  42.181  35.584  1.00 16.34           C  
ATOM  13711  C   VAL   112      90.397  41.535  35.335  1.00 16.45           C  
ATOM  13712  O   VAL   112      89.895  40.762  36.156  1.00 17.06           O  
ATOM  13713  CB  VAL   112      91.648  43.658  36.010  1.00 16.03           C  
ATOM  13714  CG1 VAL   112      90.570  43.824  37.097  1.00 14.54           C  
ATOM  13715  CG2 VAL   112      93.046  44.189  36.451  1.00 14.52           C  
ATOM  13716  N   ILE   113      89.783  41.862  34.211  1.00 16.33           N  
ATOM  13717  CA  ILE   113      88.418  41.383  33.939  1.00 16.57           C  
ATOM  13718  C   ILE   113      88.426  39.871  33.602  1.00 17.38           C  
ATOM  13719  O   ILE   113      87.418  39.207  33.835  1.00 17.79           O  
ATOM  13720  CB  ILE   113      87.684  42.255  32.877  1.00 16.97           C  
ATOM  13721  CG1 ILE   113      87.591  43.715  33.353  1.00 16.42           C  
ATOM  13722  CG2 ILE   113      86.275  41.686  32.506  1.00 16.23           C  
ATOM  13723  CD1 ILE   113      86.973  43.943  34.754  1.00 15.38           C  
ATOM  13724  N   ASN   114      89.573  39.326  33.152  1.00 17.62           N  
ATOM  13725  CA  ASN   114      89.721  37.861  33.017  1.00 18.16           C  
ATOM  13726  C   ASN   114      89.370  37.165  34.320  1.00 18.57           C  
ATOM  13727  O   ASN   114      88.867  36.056  34.301  1.00 19.99           O  
ATOM  13728  CB  ASN   114      91.130  37.469  32.547  1.00 18.52           C  
ATOM  13729  CG  ASN   114      91.406  37.829  31.083  1.00 20.10           C  
ATOM  13730  OD1 ASN   114      90.494  38.167  30.316  1.00 22.14           O  
ATOM  13731  ND2 ASN   114      92.665  37.744  30.689  1.00 20.05           N  
ATOM  13732  N   GLY   115      89.585  37.808  35.469  1.00 18.91           N  
ATOM  13733  CA  GLY   115      89.088  37.293  36.757  1.00 19.18           C  
ATOM  13734  C   GLY   115      87.609  36.931  36.679  1.00 19.79           C  
ATOM  13735  O   GLY   115      87.233  35.782  36.939  1.00 21.14           O  
ATOM  13736  N   ALA   116      86.771  37.891  36.267  1.00 19.18           N  
ATOM  13737  CA  ALA   116      85.331  37.638  36.074  1.00 18.73           C  
ATOM  13738  C   ALA   116      85.078  36.648  34.944  1.00 18.77           C  
ATOM  13739  O   ALA   116      84.318  35.704  35.117  1.00 18.13           O  
ATOM  13740  CB  ALA   116      84.563  38.940  35.818  1.00 17.60           C  
ATOM  13741  N   SER   117      85.690  36.872  33.792  1.00 19.29           N  
ATOM  13742  CA  SER   117      85.366  36.092  32.582  1.00 20.10           C  
ATOM  13743  C   SER   117      85.670  34.595  32.784  1.00 20.77           C  
ATOM  13744  O   SER   117      84.865  33.722  32.435  1.00 21.97           O  
ATOM  13745  CB  SER   117      86.103  36.640  31.358  1.00 19.41           C  
ATOM  13746  OG  SER   117      85.662  37.947  31.006  1.00 19.65           O  
ATOM  13747  N   ASN   118      86.810  34.313  33.389  1.00 21.80           N  
ATOM  13748  CA  ASN   118      87.247  32.938  33.669  1.00 21.92           C  
ATOM  13749  C   ASN   118      86.341  32.220  34.666  1.00 22.29           C  
ATOM  13750  O   ASN   118      86.014  31.026  34.477  1.00 23.85           O  
ATOM  13751  CB  ASN   118      88.672  32.936  34.193  1.00 22.14           C  
ATOM  13752  CG  ASN   118      89.692  33.319  33.143  1.00 23.36           C  
ATOM  13753  OD1 ASN   118      89.434  33.295  31.932  1.00 27.40           O  
ATOM  13754  ND2 ASN   118      90.877  33.671  33.606  1.00 27.49           N  
ATOM  13755  N   LEU   119      85.917  32.940  35.707  1.00 22.44           N  
ATOM  13756  CA  LEU   119      85.007  32.396  36.709  1.00 22.17           C  
ATOM  13757  C   LEU   119      83.654  32.058  36.071  1.00 22.24           C  
ATOM  13758  O   LEU   119      83.123  30.945  36.218  1.00 21.77           O  
ATOM  13759  CB  LEU   119      84.863  33.385  37.882  1.00 21.87           C  
ATOM  13760  CG  LEU   119      83.954  32.950  39.040  1.00 21.57           C  
ATOM  13761  CD1 LEU   119      84.343  33.550  40.394  1.00 22.43           C  
ATOM  13762  CD2 LEU   119      82.466  33.213  38.687  1.00 19.84           C  
ATOM  13763  N   ILE   120      83.100  33.014  35.340  1.00 22.68           N  
ATOM  13764  CA  ILE   120      81.797  32.834  34.691  1.00 23.03           C  
ATOM  13765  C   ILE   120      81.822  31.671  33.672  1.00 22.73           C  
ATOM  13766  O   ILE   120      80.921  30.827  33.672  1.00 22.74           O  
ATOM  13767  CB  ILE   120      81.304  34.189  34.057  1.00 22.50           C  
ATOM  13768  CG1 ILE   120      80.907  35.152  35.199  1.00 23.42           C  
ATOM  13769  CG2 ILE   120      80.119  33.969  33.092  1.00 23.23           C  
ATOM  13770  CD1 ILE   120      80.713  36.598  34.811  1.00 24.45           C  
ATOM  13771  N   ALA   121      82.859  31.598  32.846  1.00 22.93           N  
ATOM  13772  CA  ALA   121      82.995  30.525  31.867  1.00 23.71           C  
ATOM  13773  C   ALA   121      83.172  29.164  32.552  1.00 24.46           C  
ATOM  13774  O   ALA   121      82.589  28.167  32.118  1.00 24.40           O  
ATOM  13775  CB  ALA   121      84.153  30.806  30.923  1.00 24.16           C  
ATOM  13776  N   THR   122      83.934  29.146  33.646  1.00 25.07           N  
ATOM  13777  CA  THR   122      84.155  27.929  34.423  1.00 25.52           C  
ATOM  13778  C   THR   122      82.873  27.370  35.045  1.00 25.94           C  
ATOM  13779  O   THR   122      82.621  26.176  34.942  1.00 27.29           O  
ATOM  13780  CB  THR   122      85.229  28.151  35.493  1.00 25.67           C  
ATOM  13781  OG1 THR   122      86.465  28.470  34.828  1.00 25.67           O  
ATOM  13782  CG2 THR   122      85.404  26.905  36.403  1.00 25.84           C  
ATOM  13783  N   VAL   123      82.070  28.205  35.692  1.00 25.64           N  
ATOM  13784  CA  VAL   123      80.892  27.707  36.398  1.00 25.47           C  
ATOM  13785  C   VAL   123      79.727  27.416  35.437  1.00 25.14           C  
ATOM  13786  O   VAL   123      78.923  26.530  35.706  1.00 25.86           O  
ATOM  13787  CB  VAL   123      80.457  28.640  37.539  1.00 25.42           C  
ATOM  13788  CG1 VAL   123      81.594  28.801  38.558  1.00 25.65           C  
ATOM  13789  CG2 VAL   123      79.991  29.985  37.025  1.00 25.96           C  
ATOM  13790  N   LEU   124      79.648  28.132  34.316  1.00 25.53           N  
ATOM  13791  CA  LEU   124      78.543  27.974  33.358  1.00 25.86           C  
ATOM  13792  C   LEU   124      78.893  27.133  32.121  1.00 26.58           C  
ATOM  13793  O   LEU   124      77.992  26.702  31.399  1.00 27.85           O  
ATOM  13794  CB  LEU   124      78.016  29.354  32.906  1.00 25.67           C  
ATOM  13795  CG  LEU   124      77.392  30.242  34.005  1.00 25.75           C  
ATOM  13796  CD1 LEU   124      76.923  31.620  33.473  1.00 24.79           C  
ATOM  13797  CD2 LEU   124      76.239  29.529  34.730  1.00 24.67           C  
ATOM  13798  N   GLY   125      80.171  26.905  31.855  1.00 26.92           N  
ATOM  13799  CA  GLY   125      80.601  26.262  30.617  1.00 27.47           C  
ATOM  13800  C   GLY   125      80.400  27.153  29.401  1.00 28.59           C  
ATOM  13801  O   GLY   125      80.450  28.395  29.501  1.00 27.96           O  
ATOM  13802  N   GLU   126      80.145  26.533  28.247  1.00 29.57           N  
ATOM  13803  CA  GLU   126      80.046  27.272  26.987  1.00 29.15           C  
ATOM  13804  C   GLU   126      79.064  28.438  27.036  1.00 28.94           C  
ATOM  13805  O   GLU   126      79.378  29.497  26.491  1.00 29.44           O  
ATOM  13806  CB  GLU   126      79.695  26.340  25.813  1.00 31.00           C  
ATOM  13807  CG  GLU   126      79.198  27.036  24.521  1.00 32.78           C  
ATOM  13808  CD  GLU   126      80.275  27.849  23.846  1.00 39.95           C  
ATOM  13809  OE1 GLU   126      81.484  27.537  24.067  1.00 43.72           O  
ATOM  13810  OE2 GLU   126      79.914  28.797  23.096  1.00 44.33           O  
ATOM  13811  N   PRO   127      77.872  28.252  27.641  1.00 28.35           N  
ATOM  13812  CA  PRO   127      76.944  29.395  27.735  1.00 27.52           C  
ATOM  13813  C   PRO   127      77.493  30.606  28.480  1.00 26.17           C  
ATOM  13814  O   PRO   127      76.951  31.708  28.316  1.00 25.23           O  
ATOM  13815  CB  PRO   127      75.769  28.854  28.541  1.00 27.48           C  
ATOM  13816  CG  PRO   127      75.825  27.360  28.369  1.00 28.37           C  
ATOM  13817  CD  PRO   127      77.274  27.013  28.195  1.00 29.33           C  
ATOM  13818  N   GLY   128      78.509  30.381  29.316  1.00 24.90           N  
ATOM  13819  CA  GLY   128      79.160  31.456  30.029  1.00 24.87           C  
ATOM  13820  C   GLY   128      80.076  32.338  29.192  1.00 24.95           C  
ATOM  13821  O   GLY   128      80.490  33.405  29.683  1.00 25.60           O  
ATOM  13822  N   ARG   129      80.434  31.920  27.974  1.00 24.08           N  
ATOM  13823  CA  ARG   129      81.368  32.698  27.159  1.00 24.96           C  
ATOM  13824  C   ARG   129      80.614  33.880  26.582  1.00 23.19           C  
ATOM  13825  O   ARG   129      79.509  33.733  26.062  1.00 23.19           O  
ATOM  13826  CB  ARG   129      81.996  31.866  26.065  1.00 25.42           C  
ATOM  13827  CG  ARG   129      82.821  30.711  26.608  1.00 27.86           C  
ATOM  13828  CD  ARG   129      83.309  29.877  25.472  1.00 29.98           C  
ATOM  13829  NE  ARG   129      84.510  30.430  24.867  1.00 34.49           N  
ATOM  13830  CZ  ARG   129      84.825  30.292  23.581  1.00 36.05           C  
ATOM  13831  NH1 ARG   129      84.003  29.656  22.751  1.00 39.31           N  
ATOM  13832  NH2 ARG   129      85.952  30.809  23.108  1.00 35.44           N  
ATOM  13833  N   HIS   130      81.207  35.062  26.690  1.00 21.17           N  
ATOM  13834  CA  HIS   130      80.479  36.305  26.497  1.00 19.81           C  
ATOM  13835  C   HIS   130      81.292  37.340  25.734  1.00 18.95           C  
ATOM  13836  O   HIS   130      82.515  37.310  25.762  1.00 19.32           O  
ATOM  13837  CB  HIS   130      80.174  36.874  27.875  1.00 19.15           C  
ATOM  13838  CG  HIS   130      81.373  36.896  28.779  1.00 19.27           C  
ATOM  13839  ND1 HIS   130      81.715  35.823  29.575  1.00 18.83           N  
ATOM  13840  CD2 HIS   130      82.352  37.826  28.960  1.00 18.82           C  
ATOM  13841  CE1 HIS   130      82.841  36.093  30.215  1.00 19.50           C  
ATOM  13842  NE2 HIS   130      83.245  37.304  29.863  1.00 18.38           N  
ATOM  13843  N   ALA   131      80.591  38.238  25.056  1.00 18.23           N  
ATOM  13844  CA  ALA   131      81.198  39.483  24.562  1.00 17.93           C  
ATOM  13845  C   ALA   131      81.615  40.331  25.788  1.00 17.63           C  
ATOM  13846  O   ALA   131      81.145  40.128  26.900  1.00 18.26           O  
ATOM  13847  CB  ALA   131      80.243  40.256  23.664  1.00 17.85           C  
ATOM  13848  N   ARG   132      82.489  41.306  25.575  1.00 18.24           N  
ATOM  13849  CA  ARG   132      83.035  42.036  26.695  1.00 18.04           C  
ATOM  13850  C   ARG   132      83.617  43.385  26.284  1.00 17.43           C  
ATOM  13851  O   ARG   132      84.088  43.565  25.163  1.00 16.62           O  
ATOM  13852  CB  ARG   132      84.181  41.242  27.282  1.00 17.74           C  
ATOM  13853  CG  ARG   132      84.379  41.473  28.719  1.00 21.52           C  
ATOM  13854  CD  ARG   132      85.559  40.622  29.271  1.00 20.37           C  
ATOM  13855  NE  ARG   132      86.903  41.031  28.837  1.00 22.76           N  
ATOM  13856  CZ  ARG   132      88.019  40.471  29.328  1.00 21.32           C  
ATOM  13857  NH1 ARG   132      87.918  39.544  30.236  1.00 20.78           N  
ATOM  13858  NH2 ARG   132      89.223  40.856  28.939  1.00 22.78           N  
ATOM  13859  N   ALA   133      83.650  44.285  27.244  1.00 16.82           N  
ATOM  13860  CA  ALA   133      84.489  45.509  27.180  1.00 17.17           C  
ATOM  13861  C   ALA   133      85.251  45.582  28.508  1.00 16.48           C  
ATOM  13862  O   ALA   133      84.736  45.177  29.538  1.00 16.92           O  
ATOM  13863  CB  ALA   133      83.642  46.745  26.979  1.00 17.02           C  
ATOM  13864  N   ALA   134      86.494  46.049  28.468  1.00 16.84           N  
ATOM  13865  CA  ALA   134      87.303  46.207  29.665  1.00 16.59           C  
ATOM  13866  C   ALA   134      87.964  47.583  29.548  1.00 16.64           C  
ATOM  13867  O   ALA   134      88.695  47.845  28.578  1.00 17.05           O  
ATOM  13868  CB  ALA   134      88.348  45.119  29.805  1.00 17.16           C  
ATOM  13869  N   VAL   135      87.689  48.463  30.496  1.00 16.16           N  
ATOM  13870  CA  VAL   135      88.099  49.863  30.393  1.00 15.33           C  
ATOM  13871  C   VAL   135      88.602  50.422  31.715  1.00 15.04           C  
ATOM  13872  O   VAL   135      88.202  49.980  32.779  1.00 16.55           O  
ATOM  13873  CB  VAL   135      86.942  50.718  29.835  1.00 15.27           C  
ATOM  13874  CG1 VAL   135      86.621  50.279  28.369  1.00 15.28           C  
ATOM  13875  CG2 VAL   135      85.715  50.631  30.750  1.00 18.02           C  
ATOM  13876  N   GLY   136      89.451  51.440  31.644  1.00 14.42           N  
ATOM  13877  CA  GLY   136      90.007  52.072  32.833  1.00 14.05           C  
ATOM  13878  C   GLY   136      89.283  53.347  33.238  1.00 14.66           C  
ATOM  13879  O   GLY   136      89.192  54.307  32.461  1.00 16.32           O  
ATOM  13880  N   MET   137      88.838  53.366  34.492  1.00 15.74           N  
ATOM  13881  CA  MET   137      88.019  54.428  35.067  1.00 15.53           C  
ATOM  13882  C   MET   137      88.883  55.286  36.016  1.00 14.55           C  
ATOM  13883  O   MET   137      89.870  54.808  36.569  1.00 14.21           O  
ATOM  13884  CB  MET   137      86.856  53.860  35.881  1.00 17.67           C  
ATOM  13885  CG  MET   137      86.263  52.643  35.390  1.00 23.71           C  
ATOM  13886  SD  MET   137      85.665  52.752  33.523  1.00 32.58          SE  
ATOM  13887  CE  MET   137      84.716  54.461  33.938  1.00 19.25           C  
ATOM  13888  N   ALA   138      88.476  56.527  36.234  1.00 13.88           N  
ATOM  13889  CA  ALA   138      89.141  57.440  37.178  1.00 14.06           C  
ATOM  13890  C   ALA   138      88.955  56.936  38.616  1.00 14.04           C  
ATOM  13891  O   ALA   138      89.862  57.017  39.449  1.00 13.62           O  
ATOM  13892  CB  ALA   138      88.610  58.875  37.047  1.00 13.96           C  
ATOM  13893  N   SER   139      87.774  56.379  38.876  1.00 14.58           N  
ATOM  13894  CA  SER   139      87.388  55.917  40.210  1.00 15.14           C  
ATOM  13895  C   SER   139      85.992  55.291  40.117  1.00 14.88           C  
ATOM  13896  O   SER   139      85.324  55.457  39.108  1.00 14.48           O  
ATOM  13897  CB  SER   139      87.394  57.083  41.230  1.00 15.80           C  
ATOM  13898  OG  SER   139      86.720  58.247  40.755  1.00 16.73           O  
ATOM  13899  N   LEU   140      85.553  54.651  41.200  1.00 15.44           N  
ATOM  13900  CA  LEU   140      84.237  53.954  41.240  1.00 15.36           C  
ATOM  13901  C   LEU   140      83.547  54.180  42.597  1.00 15.58           C  
ATOM  13902  O   LEU   140      84.208  54.523  43.587  1.00 15.56           O  
ATOM  13903  CB  LEU   140      84.409  52.450  40.962  1.00 15.93           C  
ATOM  13904  CG  LEU   140      84.909  52.035  39.582  1.00 15.60           C  
ATOM  13905  CD1 LEU   140      85.286  50.549  39.605  1.00 15.22           C  
ATOM  13906  CD2 LEU   140      83.852  52.382  38.482  1.00 15.08           C  
ATOM  13907  N   PRO   141      82.211  54.021  42.644  1.00 15.44           N  
ATOM  13908  CA  PRO   141      81.453  54.136  43.911  1.00 16.14           C  
ATOM  13909  C   PRO   141      82.110  53.334  45.044  1.00 15.92           C  
ATOM  13910  O   PRO   141      82.581  52.199  44.826  1.00 16.30           O  
ATOM  13911  CB  PRO   141      80.075  53.575  43.548  1.00 15.94           C  
ATOM  13912  CG  PRO   141      79.935  53.831  42.101  1.00 15.45           C  
ATOM  13913  CD  PRO   141      81.316  53.727  41.508  1.00 15.64           C  
ATOM  13914  N   PHE   142      82.170  53.939  46.230  1.00 16.28           N  
ATOM  13915  CA  PHE   142      82.733  53.297  47.430  1.00 17.01           C  
ATOM  13916  C   PHE   142      84.216  52.930  47.312  1.00 17.24           C  
ATOM  13917  O   PHE   142      84.742  52.110  48.073  1.00 17.44           O  
ATOM  13918  CB  PHE   142      81.928  52.059  47.803  1.00 18.58           C  
ATOM  13919  CG  PHE   142      80.466  52.336  47.998  1.00 18.46           C  
ATOM  13920  CD1 PHE   142      80.015  52.864  49.180  1.00 21.60           C  
ATOM  13921  CD2 PHE   142      79.559  52.097  46.970  1.00 21.58           C  
ATOM  13922  CE1 PHE   142      78.682  53.137  49.358  1.00 21.61           C  
ATOM  13923  CE2 PHE   142      78.215  52.370  47.137  1.00 22.90           C  
ATOM  13924  CZ  PHE   142      77.776  52.887  48.332  1.00 22.64           C  
ATOM  13925  N   ASN   143      84.878  53.560  46.330  1.00 16.87           N  
ATOM  13926  CA  ASN   143      86.266  53.270  45.999  1.00 15.70           C  
ATOM  13927  C   ASN   143      86.510  51.824  45.587  1.00 15.55           C  
ATOM  13928  O   ASN   143      87.609  51.322  45.736  1.00 16.70           O  
ATOM  13929  CB  ASN   143      87.154  53.677  47.176  1.00 16.04           C  
ATOM  13930  CG  ASN   143      88.588  53.911  46.779  1.00 14.10           C  
ATOM  13931  OD1 ASN   143      88.914  54.151  45.608  1.00 17.82           O  
ATOM  13932  ND2 ASN   143      89.478  53.852  47.779  1.00 17.12           N  
ATOM  13933  N   ALA   144      85.488  51.161  45.023  1.00 15.75           N  
ATOM  13934  CA  ALA   144      85.636  49.826  44.460  1.00 15.29           C  
ATOM  13935  C   ALA   144      86.735  49.841  43.411  1.00 15.28           C  
ATOM  13936  O   ALA   144      86.847  50.796  42.624  1.00 14.89           O  
ATOM  13937  CB  ALA   144      84.350  49.361  43.831  1.00 15.92           C  
ATOM  13938  N   SER   145      87.538  48.785  43.403  1.00 15.49           N  
ATOM  13939  CA  SER   145      88.570  48.650  42.372  1.00 15.37           C  
ATOM  13940  C   SER   145      87.975  48.256  41.005  1.00 15.28           C  
ATOM  13941  O   SER   145      88.503  48.615  39.973  1.00 14.24           O  
ATOM  13942  CB  SER   145      89.687  47.688  42.825  1.00 16.67           C  
ATOM  13943  OG  SER   145      90.313  48.168  44.001  1.00 16.25           O  
ATOM  13944  N   VAL   146      86.877  47.516  41.017  1.00 14.87           N  
ATOM  13945  CA  VAL   146      86.230  47.021  39.809  1.00 15.23           C  
ATOM  13946  C   VAL   146      84.712  47.079  40.031  1.00 15.41           C  
ATOM  13947  O   VAL   146      84.210  46.874  41.153  1.00 15.54           O  
ATOM  13948  CB  VAL   146      86.670  45.536  39.456  1.00 15.05           C  
ATOM  13949  CG1 VAL   146      86.085  45.052  38.089  1.00 15.94           C  
ATOM  13950  CG2 VAL   146      88.232  45.354  39.571  1.00 14.96           C  
ATOM  13951  N   GLU   147      84.007  47.398  38.957  1.00 15.93           N  
ATOM  13952  CA  GLU   147      82.535  47.312  38.856  1.00 15.92           C  
ATOM  13953  C   GLU   147      82.252  46.607  37.524  1.00 15.93           C  
ATOM  13954  O   GLU   147      82.884  46.924  36.508  1.00 15.74           O  
ATOM  13955  CB  GLU   147      81.892  48.684  38.856  1.00 16.26           C  
ATOM  13956  CG  GLU   147      80.408  48.720  38.569  1.00 16.79           C  
ATOM  13957  CD  GLU   147      79.814  50.141  38.566  1.00 17.90           C  
ATOM  13958  OE1 GLU   147      80.472  51.032  39.106  1.00 16.37           O  
ATOM  13959  OE2 GLU   147      78.691  50.362  38.032  1.00 21.33           O  
ATOM  13960  N   ILE   148      81.306  45.667  37.535  1.00 16.14           N  
ATOM  13961  CA  ILE   148      80.988  44.895  36.342  1.00 15.98           C  
ATOM  13962  C   ILE   148      79.476  44.740  36.189  1.00 16.11           C  
ATOM  13963  O   ILE   148      78.794  44.315  37.129  1.00 16.86           O  
ATOM  13964  CB  ILE   148      81.601  43.456  36.330  1.00 16.86           C  
ATOM  13965  CG1 ILE   148      83.118  43.455  36.615  1.00 15.12           C  
ATOM  13966  CG2 ILE   148      81.313  42.831  34.929  1.00 17.11           C  
ATOM  13967  CD1 ILE   148      83.783  42.069  36.538  1.00 16.31           C  
ATOM  13968  N   ASP   149      78.974  45.086  35.011  1.00 15.24           N  
ATOM  13969  CA  ASP   149      77.541  44.879  34.705  1.00 16.84           C  
ATOM  13970  C   ASP   149      77.406  43.805  33.638  1.00 16.71           C  
ATOM  13971  O   ASP   149      78.409  43.329  33.087  1.00 19.31           O  
ATOM  13972  CB  ASP   149      76.857  46.181  34.332  1.00 17.25           C  
ATOM  13973  CG  ASP   149      77.178  46.666  32.924  1.00 18.92           C  
ATOM  13974  OD1 ASP   149      77.717  45.917  32.076  1.00 21.61           O  
ATOM  13975  OD2 ASP   149      76.901  47.857  32.671  1.00 23.19           O  
ATOM  13976  N   ALA   150      76.170  43.403  33.348  1.00 17.03           N  
ATOM  13977  CA  ALA   150      75.979  42.220  32.491  1.00 17.32           C  
ATOM  13978  C   ALA   150      74.653  42.251  31.760  1.00 17.32           C  
ATOM  13979  O   ALA   150      73.681  42.805  32.264  1.00 17.16           O  
ATOM  13980  CB  ALA   150      76.071  40.922  33.290  1.00 16.29           C  
ATOM  13981  N   ILE   151      74.636  41.600  30.597  1.00 17.86           N  
ATOM  13982  CA  ILE   151      73.385  41.298  29.877  1.00 18.64           C  
ATOM  13983  C   ILE   151      73.400  39.782  29.684  1.00 18.58           C  
ATOM  13984  O   ILE   151      74.408  39.216  29.252  1.00 16.46           O  
ATOM  13985  CB  ILE   151      73.295  41.986  28.517  1.00 18.12           C  
ATOM  13986  CG1 ILE   151      73.401  43.521  28.639  1.00 18.70           C  
ATOM  13987  CG2 ILE   151      72.005  41.638  27.832  1.00 18.34           C  
ATOM  13988  CD1 ILE   151      73.738  44.160  27.326  1.00 21.12           C  
ATOM  13989  N   VAL   152      72.296  39.127  30.014  1.00 19.65           N  
ATOM  13990  CA  VAL   152      72.245  37.677  30.062  1.00 20.85           C  
ATOM  13991  C   VAL   152      70.965  37.236  29.312  1.00 21.79           C  
ATOM  13992  O   VAL   152      69.875  37.732  29.595  1.00 23.25           O  
ATOM  13993  CB  VAL   152      72.234  37.157  31.530  1.00 20.51           C  
ATOM  13994  CG1 VAL   152      72.116  35.632  31.552  1.00 20.98           C  
ATOM  13995  CG2 VAL   152      73.472  37.627  32.314  1.00 19.78           C  
ATOM  13996  N   GLU   153      71.111  36.364  28.337  1.00 22.65           N  
ATOM  13997  CA  GLU   153      69.931  35.789  27.677  1.00 23.65           C  
ATOM  13998  C   GLU   153      69.416  34.643  28.566  1.00 23.87           C  
ATOM  13999  O   GLU   153      70.189  33.746  28.945  1.00 23.66           O  
ATOM  14000  CB  GLU   153      70.264  35.289  26.289  1.00 23.38           C  
ATOM  14001  CG  GLU   153      69.041  34.729  25.582  1.00 23.77           C  
ATOM  14002  CD  GLU   153      69.403  34.097  24.286  1.00 25.44           C  
ATOM  14003  OE1 GLU   153      69.856  34.818  23.377  1.00 28.66           O  
ATOM  14004  OE2 GLU   153      69.232  32.859  24.181  1.00 33.72           O  
ATOM  14005  N   ILE   154      68.116  34.683  28.885  1.00 25.68           N  
ATOM  14006  CA  ILE   154      67.500  33.757  29.854  1.00 26.78           C  
ATOM  14007  C   ILE   154      66.314  33.035  29.242  1.00 30.18           C  
ATOM  14008  O   ILE   154      65.740  33.496  28.257  1.00 29.70           O  
ATOM  14009  CB  ILE   154      67.039  34.458  31.150  1.00 26.75           C  
ATOM  14010  CG1 ILE   154      66.053  35.594  30.860  1.00 26.10           C  
ATOM  14011  CG2 ILE   154      68.259  34.960  31.966  1.00 25.49           C  
ATOM  14012  CD1 ILE   154      65.428  36.242  32.107  1.00 26.67           C  
ATOM  14013  N   ASP   155      65.987  31.894  29.838  1.00 34.08           N  
ATOM  14014  CA  ASP   155      64.750  31.169  29.526  1.00 38.39           C  
ATOM  14015  C   ASP   155      63.533  31.867  30.087  1.00 39.81           C  
ATOM  14016  O   ASP   155      63.331  31.884  31.303  1.00 41.42           O  
ATOM  14017  CB  ASP   155      64.825  29.774  30.112  1.00 38.89           C  
ATOM  14018  CG  ASP   155      65.674  28.876  29.280  1.00 42.84           C  
ATOM  14019  OD1 ASP   155      65.266  28.669  28.107  1.00 47.96           O  
ATOM  14020  OD2 ASP   155      66.738  28.398  29.774  1.00 48.12           O  
ATOM  14021  N   VAL   156      62.721  32.426  29.191  1.00 42.19           N  
ATOM  14022  CA  VAL   156      61.502  33.142  29.551  1.00 42.99           C  
ATOM  14023  C   VAL   156      60.299  32.349  29.037  1.00 44.31           C  
ATOM  14024  O   VAL   156      60.430  31.553  28.090  1.00 45.98           O  
ATOM  14025  CB  VAL   156      61.529  34.588  28.958  1.00 43.73           C  
ATOM  14026  CG1 VAL   156      60.139  35.038  28.439  1.00 44.09           C  
ATOM  14027  CG2 VAL   156      62.095  35.575  29.986  1.00 43.38           C  
END
