
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  119 (  920),  selected  119 , name 2dyy_L
# Molecule2: number of CA atoms  152 ( 1118),  selected  152 , name T0423.pdb
# PARAMETERS: 2dyy_L.T0423.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_L      M       1           -
LGA    K     2_L      S       2           -
LGA    E     3_L      D       3           -
LGA    V     4_L      V       4           -
LGA    I     5_L      I       5           -
LGA    F     6_L      E       6           -
LGA    T     7_L      G       7           -
LGA    E     8_L      R       8           -
LGA    -       -      L       9           -
LGA    -       -      K      10           -
LGA    -       -      E      11           -
LGA    -       -      L      12           -
LGA    -       -      G      13           -
LGA    -       -      F      14           -
LGA    -       -      T      15           -
LGA    -       -      L      16           -
LGA    N     9_L      P      17          3.169
LGA    A    10_L      V      18          4.795
LGA    P    11_L      -       -           -
LGA    K    12_L      -       -           -
LGA    P    13_L      -       -           -
LGA    I    14_L      A      23           #
LGA    G    15_L      A      24          3.986
LGA    P    16_L      N      25          2.161
LGA    Y    17_L      Y      26          1.200
LGA    S    18_L      V      27          0.859
LGA    Q    19_L      P      28          0.758
LGA    A    20_L      F      29          0.464
LGA    I    21_L      T      30          1.146
LGA    K    22_L      I      31          1.505
LGA    A    23_L      S      32          1.938
LGA    G    24_L      G      33          1.901
LGA    N    25_L      N      34          1.242
LGA    F    26_L      L      35          1.263
LGA    L    27_L      L      36          0.660
LGA    F    28_L      Y      37          0.874
LGA    I    29_L      V      38          0.518
LGA    A    30_L      S      39          0.414
LGA    G    31_L      G      40          0.474
LGA    Q    32_L      Q      41          0.346
LGA    I    33_L      L      42          0.521
LGA    P    34_L      P      43          0.762
LGA    I    35_L      M      44          1.509
LGA    D    36_L      E      45          2.420
LGA    P    37_L      -       -           -
LGA    K    38_L      -       -           -
LGA    T    39_L      S      46          3.421
LGA    G    40_L      G      47          2.060
LGA    E    41_L      K      48          1.056
LGA    I    42_L      I      49          1.012
LGA    V    43_L      A      50          1.048
LGA    K    44_L      V      51          3.921
LGA    -       -      T      52           -
LGA    -       -      G      53           -
LGA    -       -      L      54           -
LGA    -       -      V      55           -
LGA    -       -      G      56           -
LGA    -       -      R      57           -
LGA    G    45_L      D      58           #
LGA    -       -      V      59           -
LGA    -       -      D      60           -
LGA    -       -      V      61           -
LGA    -       -      A      62           -
LGA    D    46_L      S      63          2.843
LGA    I    47_L      A      64          1.074
LGA    K    48_L      Q      65          2.630
LGA    D    49_L      R      66          2.282
LGA    Q    50_L      A      67          1.288
LGA    T    51_L      A      68          1.210
LGA    R    52_L      E      69          1.481
LGA    Q    53_L      L      70          1.069
LGA    V    54_L      C      71          0.679
LGA    L    55_L      A      72          0.616
LGA    E    56_L      V      73          0.481
LGA    N    57_L      N      74          0.528
LGA    I    58_L      I      75          0.547
LGA    K    59_L      L      76          0.786
LGA    A    60_L      A      77          1.022
LGA    I    61_L      Q      78          1.233
LGA    L    62_L      V      79          1.290
LGA    E    63_L      K      80          1.586
LGA    A    64_L      A      81          1.826
LGA    A    65_L      A      82          1.802
LGA    G    66_L      L      83          1.859
LGA    -       -      N      84           -
LGA    -       -      G      85           -
LGA    -       -      D      86           -
LGA    -       -      L      87           -
LGA    -       -      S      88           -
LGA    Y    67_L      K      89          3.856
LGA    S    68_L      I      90          3.021
LGA    L    69_L      -       -           -
LGA    N    70_L      R      91          5.038
LGA    D    71_L      R      92          2.247
LGA    V    72_L      V      93          1.318
LGA    I    73_L      I      94          0.620
LGA    K    74_L      K      95          1.043
LGA    V    75_L      L      96          0.967
LGA    T    76_L      N      97          0.846
LGA    V    77_L      G      98          0.890
LGA    Y    78_L      F      99          0.705
LGA    L    79_L      V     100          0.882
LGA    K    80_L      A     101          1.587
LGA    D    81_L      S     102          2.038
LGA    -       -      V     103           -
LGA    -       -      P     104           -
LGA    -       -      E     105           -
LGA    -       -      F     106           -
LGA    -       -      V     107           -
LGA    -       -      E     108           -
LGA    -       -      Q     109           -
LGA    -       -      H     110           -
LGA    -       -      L     111           -
LGA    -       -      V     112           -
LGA    N    89_L      I     113          5.378
LGA    E    90_L      N     114          4.766
LGA    V    91_L      G     115          2.812
LGA    Y    92_L      A     116          3.059
LGA    -       -      S     117           -
LGA    A    93_L      N     118          1.592
LGA    E    94_L      L     119          2.622
LGA    Y    95_L      I     120          0.820
LGA    F    96_L      A     121          2.621
LGA    -       -      T     122           -
LGA    -       -      V     123           -
LGA    -       -      L     124           -
LGA    G    97_L      G     125          4.952
LGA    E    98_L      E     126          1.631
LGA    S    99_L      P     127          3.099
LGA    -       -      G     128           -
LGA    K   100_L      R     129          1.796
LGA    P   101_L      H     130          1.364
LGA    A   102_L      A     131          1.420
LGA    R   103_L      R     132          0.920
LGA    V   104_L      A     133          1.482
LGA    A   105_L      A     134          1.882
LGA    V   106_L      V     135          1.233
LGA    E   107_L      G     136          0.744
LGA    V   108_L      M     137          0.877
LGA    S   109_L      A     138          0.270
LGA    R   110_L      S     139          0.583
LGA    L   111_L      L     140          0.569
LGA    P   112_L      P     141          0.669
LGA    K   113_L      F     142          1.088
LGA    D   114_L      N     143          1.400
LGA    V   115_L      A     144          1.057
LGA    L   116_L      S     145          0.815
LGA    I   117_L      V     146          0.484
LGA    E   118_L      E     147          0.499
LGA    I   119_L      I     148          0.376
LGA    E   120_L      D     149          0.854
LGA    A   121_L      A     150          0.524
LGA    I   122_L      I     151          0.599
LGA    A   123_L      V     152          0.987
LGA    Y   124_L      E     153          1.116
LGA    K   125_L      I     154          1.853
LGA    E   126_L      D     155          4.198
LGA    -       -      V     156           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  119  152    5.0    103    1.97    28.16     60.581     4.965

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.524983 * X  +   0.817682 * Y  +  -0.236197 * Z  +  86.137665
  Y_new =   0.677390 * X  +   0.569437 * Y  +   0.465709 * Z  +  10.671662
  Z_new =   0.515301 * X  +   0.084492 * Y  +  -0.852834 * Z  +  27.014982 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   3.042843   -0.098750  [ DEG:   174.3421     -5.6579 ]
  Theta =  -0.541359   -2.600233  [ DEG:   -31.0176   -148.9824 ]
  Phi   =   2.230112   -0.911480  [ DEG:   127.7760    -52.2240 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2dyy_L                                        
REMARK     2: T0423.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2dyy_L.T0423.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  119  152   5.0  103   1.97   28.16  60.581
REMARK  ---------------------------------------------------------- 
MOLECULE 2dyy_L
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   19-SEP-06   2DYY              
TITLE     CRYSTAL STRUCTURE OF PUTATIVE TRANSLATION INITIATION                  
TITLE    2 INHIBITOR PH0854 FROM PYROCOCCUS HORIKOSHII                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UPF0076 PROTEIN PH0854;                                    
COMPND   3 CHAIN: A, B, C, D, E, F, G, H, I, J, K, L;                           
COMPND   4 SYNONYM: PUTATIVE TRANSLATION INITIATION INHIBITOR;                  
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS HORIKOSHII;                          
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21-CODONPLUS (DE3)-RIL;                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    PUTATIVE TRANSLATION INITIATION INHIBITOR, PYROCOCCUS                 
KEYWDS   2 HORIKOSHII, TRIMER, STRUCTURAL GENOMICS, NPPSFA, NATIONAL            
KEYWDS   3 PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES,               
KEYWDS   4 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    IHSANAWATI,S.KISHISHITA,K.MURAYAMA,L.CHEN,Z.J.LIU,B.C.WANG,           
AUTHOR   2 M.SHIROUZU,Y.BESSHO,S.YOKOYAMA,RIKEN STRUCTURAL                      
AUTHOR   3 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   2   04-SEP-07 2DYY    1       AUTHOR                                   
REVDAT   1   19-MAR-07 2DYY    0                                                
JRNL        AUTH   IHSANAWATI,S.KISHISHITA,K.MURAYAMA,L.CHEN,Z.J.LIU,           
JRNL        AUTH 2 B.C.WANG,M.SHIROUZU,Y.BESSHO,S.YOKOYAMA                      
JRNL        TITL   CRYSTAL STRUCTURE OF PUTATIVE TRANSLATION                    
JRNL        TITL 2 INITIATION INHIBITOR PH0854 FROM PYROCOCCUS                  
JRNL        TITL 3 HORIKOSHII                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.60 ANGSTROMS.                                          
DBREF  2DYY A    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY B    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY C    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY D    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY E    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY F    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY G    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY H    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY I    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY J    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY K    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY L    1   126  UNP    O58584   Y854_PYRHO       1    126             
SEQRES   1 A  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 A  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 A  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 A  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 A  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 A  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 A  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 A  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 A  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 A  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 B  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 B  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 B  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 B  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 B  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 B  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 B  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 B  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 B  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 B  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 C  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 C  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 C  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 C  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 C  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 C  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 C  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 C  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 C  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 C  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 D  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 D  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 D  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 D  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 D  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 D  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 D  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 D  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 D  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 D  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 E  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 E  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 E  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 E  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 E  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 E  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 E  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 E  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 E  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 E  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 F  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 F  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 F  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 F  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 F  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 F  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 F  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 F  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 F  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 F  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 G  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 G  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 G  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 G  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 G  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 G  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 G  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 G  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 G  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 G  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 H  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 H  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 H  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 H  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 H  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 H  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 H  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 H  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 H  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 H  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 I  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 I  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 I  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 I  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 I  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 I  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 I  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 I  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 I  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 I  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 J  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 J  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 J  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 J  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 J  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 J  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 J  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 J  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 J  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 J  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 K  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 K  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 K  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 K  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 K  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 K  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 K  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 K  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 K  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 K  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 L  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 L  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 L  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 L  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 L  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 L  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 L  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 L  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 L  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 L  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
FORMUL  13  HOH   *233(H2 O)                                                    
CRYST1   92.490   43.090  170.210  90.00  91.51  90.00 P 1 2 1      24          
ATOM  10320  N   MET L   1      57.298  41.036  30.152  1.00 74.19           N  
ATOM  10321  CA  MET L   1      56.790  41.099  31.553  1.00 74.24           C  
ATOM  10322  C   MET L   1      57.858  41.728  32.460  1.00 73.00           C  
ATOM  10323  O   MET L   1      58.541  41.025  33.212  1.00 73.93           O  
ATOM  10324  CB  MET L   1      56.450  39.687  32.041  1.00 76.17           C  
ATOM  10325  CG  MET L   1      55.707  38.842  31.009  1.00 79.35           C  
ATOM  10326  SD  MET L   1      55.457  37.115  31.513  1.00 82.21           S  
ATOM  10327  CE  MET L   1      57.129  36.453  31.331  1.00 81.28           C  
ATOM  10328  N   LYS L   2      57.999  43.052  32.377  1.00 69.66           N  
ATOM  10329  CA  LYS L   2      58.980  43.793  33.174  1.00 65.86           C  
ATOM  10330  C   LYS L   2      58.887  43.422  34.643  1.00 61.82           C  
ATOM  10331  O   LYS L   2      57.978  43.866  35.329  1.00 61.80           O  
ATOM  10332  CB  LYS L   2      58.756  45.301  33.022  1.00 66.99           C  
ATOM  10333  CG  LYS L   2      59.684  46.153  33.874  1.00 68.01           C  
ATOM  10334  CD  LYS L   2      59.329  47.631  33.784  1.00 68.29           C  
ATOM  10335  CE  LYS L   2      60.320  48.487  34.569  1.00 68.14           C  
ATOM  10336  NZ  LYS L   2      60.356  48.147  36.020  1.00 67.05           N  
ATOM  10337  N   GLU L   3      59.833  42.628  35.133  1.00 58.29           N  
ATOM  10338  CA  GLU L   3      59.804  42.206  36.529  1.00 55.18           C  
ATOM  10339  C   GLU L   3      61.075  42.559  37.311  1.00 51.36           C  
ATOM  10340  O   GLU L   3      62.182  42.485  36.785  1.00 50.25           O  
ATOM  10341  CB  GLU L   3      59.553  40.700  36.597  1.00 58.08           C  
ATOM  10342  CG  GLU L   3      59.066  40.212  37.948  1.00 62.86           C  
ATOM  10343  CD  GLU L   3      58.722  38.731  37.942  1.00 65.55           C  
ATOM  10344  OE1 GLU L   3      57.975  38.292  37.038  1.00 65.44           O  
ATOM  10345  OE2 GLU L   3      59.197  38.010  38.847  1.00 67.10           O  
ATOM  10346  N   VAL L   4      60.903  42.933  38.576  1.00 47.23           N  
ATOM  10347  CA  VAL L   4      62.030  43.302  39.426  1.00 43.56           C  
ATOM  10348  C   VAL L   4      62.656  42.108  40.139  1.00 41.86           C  
ATOM  10349  O   VAL L   4      62.015  41.424  40.926  1.00 42.25           O  
ATOM  10350  CB  VAL L   4      61.619  44.350  40.494  1.00 41.57           C  
ATOM  10351  CG1 VAL L   4      62.782  44.616  41.432  1.00 37.71           C  
ATOM  10352  CG2 VAL L   4      61.188  45.646  39.817  1.00 39.43           C  
ATOM  10353  N   ILE L   5      63.928  41.876  39.866  1.00 39.94           N  
ATOM  10354  CA  ILE L   5      64.643  40.773  40.475  1.00 37.59           C  
ATOM  10355  C   ILE L   5      65.350  41.232  41.740  1.00 40.01           C  
ATOM  10356  O   ILE L   5      66.100  42.215  41.727  1.00 39.77           O  
ATOM  10357  CB  ILE L   5      65.689  40.180  39.489  1.00 34.54           C  
ATOM  10358  CG1 ILE L   5      65.011  39.193  38.541  1.00 31.41           C  
ATOM  10359  CG2 ILE L   5      66.819  39.500  40.253  1.00 32.72           C  
ATOM  10360  CD1 ILE L   5      63.841  39.755  37.799  1.00 32.31           C  
ATOM  10361  N   PHE L   6      65.093  40.529  42.839  1.00 40.93           N  
ATOM  10362  CA  PHE L   6      65.752  40.841  44.096  1.00 41.06           C  
ATOM  10363  C   PHE L   6      66.130  39.574  44.838  1.00 42.51           C  
ATOM  10364  O   PHE L   6      65.349  38.629  44.924  1.00 42.11           O  
ATOM  10365  CB  PHE L   6      64.885  41.699  45.016  1.00 39.90           C  
ATOM  10366  CG  PHE L   6      65.537  41.969  46.340  1.00 39.62           C  
ATOM  10367  CD1 PHE L   6      66.653  42.802  46.419  1.00 39.18           C  
ATOM  10368  CD2 PHE L   6      65.111  41.308  47.489  1.00 38.30           C  
ATOM  10369  CE1 PHE L   6      67.340  42.966  47.619  1.00 40.67           C  
ATOM  10370  CE2 PHE L   6      65.793  41.463  48.696  1.00 39.63           C  
ATOM  10371  CZ  PHE L   6      66.913  42.293  48.762  1.00 39.58           C  
ATOM  10372  N   THR L   7      67.338  39.570  45.381  1.00 43.89           N  
ATOM  10373  CA  THR L   7      67.834  38.427  46.122  1.00 46.77           C  
ATOM  10374  C   THR L   7      68.771  38.960  47.191  1.00 47.28           C  
ATOM  10375  O   THR L   7      69.255  40.083  47.085  1.00 47.43           O  
ATOM  10376  CB  THR L   7      68.609  37.457  45.197  1.00 48.31           C  
ATOM  10377  OG1 THR L   7      68.924  36.261  45.919  1.00 51.95           O  
ATOM  10378  CG2 THR L   7      69.907  38.098  44.698  1.00 47.15           C  
ATOM  10379  N   GLU L   8      69.029  38.168  48.221  1.00 48.46           N  
ATOM  10380  CA  GLU L   8      69.919  38.625  49.280  1.00 50.82           C  
ATOM  10381  C   GLU L   8      71.314  38.058  49.108  1.00 50.49           C  
ATOM  10382  O   GLU L   8      72.211  38.315  49.906  1.00 49.09           O  
ATOM  10383  CB  GLU L   8      69.347  38.251  50.647  1.00 52.25           C  
ATOM  10384  CG  GLU L   8      68.015  38.936  50.905  1.00 56.23           C  
ATOM  10385  CD  GLU L   8      67.633  38.959  52.364  1.00 58.21           C  
ATOM  10386  OE1 GLU L   8      66.615  39.612  52.692  1.00 59.41           O  
ATOM  10387  OE2 GLU L   8      68.345  38.328  53.180  1.00 60.11           O  
ATOM  10388  N   ASN L   9      71.487  37.291  48.042  1.00 50.84           N  
ATOM  10389  CA  ASN L   9      72.770  36.691  47.753  1.00 52.05           C  
ATOM  10390  C   ASN L   9      73.609  37.700  46.986  1.00 53.22           C  
ATOM  10391  O   ASN L   9      74.765  37.441  46.650  1.00 54.93           O  
ATOM  10392  CB  ASN L   9      72.572  35.422  46.931  1.00 52.97           C  
ATOM  10393  CG  ASN L   9      71.698  34.404  47.641  1.00 53.00           C  
ATOM  10394  OD1 ASN L   9      71.980  34.018  48.779  1.00 51.29           O  
ATOM  10395  ND2 ASN L   9      70.634  33.961  46.973  1.00 49.69           N  
ATOM  10396  N   ALA L  10      73.010  38.855  46.714  1.00 53.02           N  
ATOM  10397  CA  ALA L  10      73.690  39.929  45.999  1.00 52.50           C  
ATOM  10398  C   ALA L  10      73.600  41.203  46.831  1.00 51.14           C  
ATOM  10399  O   ALA L  10      72.716  41.335  47.677  1.00 49.77           O  
ATOM  10400  CB  ALA L  10      73.045  40.149  44.637  1.00 52.81           C  
ATOM  10401  N   PRO L  11      74.517  42.156  46.604  1.00 49.67           N  
ATOM  10402  CA  PRO L  11      74.485  43.405  47.370  1.00 49.73           C  
ATOM  10403  C   PRO L  11      73.131  44.103  47.235  1.00 48.85           C  
ATOM  10404  O   PRO L  11      72.617  44.273  46.131  1.00 48.85           O  
ATOM  10405  CB  PRO L  11      75.625  44.214  46.754  1.00 49.14           C  
ATOM  10406  CG  PRO L  11      76.584  43.147  46.312  1.00 49.14           C  
ATOM  10407  CD  PRO L  11      75.658  42.143  45.676  1.00 47.79           C  
ATOM  10408  N   LYS L  12      72.552  44.498  48.363  1.00 49.19           N  
ATOM  10409  CA  LYS L  12      71.261  45.173  48.344  1.00 50.46           C  
ATOM  10410  C   LYS L  12      71.414  46.616  47.892  1.00 50.48           C  
ATOM  10411  O   LYS L  12      72.248  47.352  48.411  1.00 50.35           O  
ATOM  10412  CB  LYS L  12      70.603  45.118  49.731  1.00 49.78           C  
ATOM  10413  CG  LYS L  12      69.976  43.763  50.059  1.00 48.08           C  
ATOM  10414  CD  LYS L  12      69.415  43.714  51.470  1.00 47.22           C  
ATOM  10415  CE  LYS L  12      70.516  43.868  52.500  1.00 47.14           C  
ATOM  10416  NZ  LYS L  12      70.000  43.728  53.884  1.00 47.59           N  
ATOM  10417  N   PRO L  13      70.604  47.040  46.911  1.00 51.21           N  
ATOM  10418  CA  PRO L  13      70.678  48.412  46.405  1.00 52.71           C  
ATOM  10419  C   PRO L  13      70.272  49.461  47.442  1.00 54.30           C  
ATOM  10420  O   PRO L  13      69.149  49.442  47.948  1.00 54.08           O  
ATOM  10421  CB  PRO L  13      69.734  48.382  45.207  1.00 51.41           C  
ATOM  10422  CG  PRO L  13      68.687  47.407  45.641  1.00 50.63           C  
ATOM  10423  CD  PRO L  13      69.505  46.299  46.263  1.00 51.23           C  
ATOM  10424  N   ILE L  14      71.192  50.364  47.770  1.00 55.63           N  
ATOM  10425  CA  ILE L  14      70.887  51.420  48.725  1.00 57.50           C  
ATOM  10426  C   ILE L  14      70.589  52.706  47.965  1.00 58.38           C  
ATOM  10427  O   ILE L  14      71.160  53.758  48.237  1.00 58.76           O  
ATOM  10428  CB  ILE L  14      72.051  51.662  49.725  1.00 58.54           C  
ATOM  10429  CG1 ILE L  14      73.375  51.846  48.979  1.00 60.33           C  
ATOM  10430  CG2 ILE L  14      72.126  50.511  50.716  1.00 57.89           C  
ATOM  10431  CD1 ILE L  14      74.573  52.063  49.904  1.00 60.60           C  
ATOM  10432  N   GLY L  15      69.685  52.596  46.999  1.00 59.00           N  
ATOM  10433  CA  GLY L  15      69.299  53.739  46.197  1.00 59.39           C  
ATOM  10434  C   GLY L  15      67.994  53.428  45.494  1.00 59.45           C  
ATOM  10435  O   GLY L  15      67.448  52.336  45.670  1.00 60.32           O  
ATOM  10436  N   PRO L  16      67.458  54.363  44.695  1.00 58.37           N  
ATOM  10437  CA  PRO L  16      66.199  54.124  43.984  1.00 56.91           C  
ATOM  10438  C   PRO L  16      66.362  53.234  42.741  1.00 56.09           C  
ATOM  10439  O   PRO L  16      65.705  53.458  41.719  1.00 55.94           O  
ATOM  10440  CB  PRO L  16      65.738  55.536  43.638  1.00 57.01           C  
ATOM  10441  CG  PRO L  16      67.038  56.239  43.368  1.00 57.99           C  
ATOM  10442  CD  PRO L  16      67.926  55.748  44.498  1.00 58.97           C  
ATOM  10443  N   TYR L  17      67.237  52.232  42.827  1.00 53.47           N  
ATOM  10444  CA  TYR L  17      67.461  51.314  41.710  1.00 51.14           C  
ATOM  10445  C   TYR L  17      67.285  49.851  42.136  1.00 47.20           C  
ATOM  10446  O   TYR L  17      67.097  49.557  43.313  1.00 45.88           O  
ATOM  10447  CB  TYR L  17      68.859  51.533  41.111  1.00 55.17           C  
ATOM  10448  CG  TYR L  17      70.003  51.147  42.023  1.00 59.14           C  
ATOM  10449  CD1 TYR L  17      70.665  49.924  41.870  1.00 60.25           C  
ATOM  10450  CD2 TYR L  17      70.414  51.996  43.052  1.00 60.81           C  
ATOM  10451  CE1 TYR L  17      71.712  49.555  42.725  1.00 61.65           C  
ATOM  10452  CE2 TYR L  17      71.457  51.636  43.912  1.00 62.79           C  
ATOM  10453  CZ  TYR L  17      72.099  50.417  43.743  1.00 62.69           C  
ATOM  10454  OH  TYR L  17      73.117  50.062  44.601  1.00 63.41           O  
ATOM  10455  N   SER L  18      67.335  48.938  41.171  1.00 43.74           N  
ATOM  10456  CA  SER L  18      67.168  47.515  41.457  1.00 39.98           C  
ATOM  10457  C   SER L  18      68.360  46.721  40.962  1.00 36.41           C  
ATOM  10458  O   SER L  18      69.020  47.130  40.012  1.00 36.58           O  
ATOM  10459  CB  SER L  18      65.903  46.986  40.782  1.00 40.72           C  
ATOM  10460  OG  SER L  18      64.771  47.724  41.194  1.00 43.11           O  
ATOM  10461  N   GLN L  19      68.628  45.584  41.601  1.00 32.44           N  
ATOM  10462  CA  GLN L  19      69.744  44.730  41.202  1.00 28.95           C  
ATOM  10463  C   GLN L  19      69.605  44.343  39.730  1.00 27.47           C  
ATOM  10464  O   GLN L  19      70.595  44.214  39.011  1.00 24.91           O  
ATOM  10465  CB  GLN L  19      69.797  43.456  42.058  1.00 28.01           C  
ATOM  10466  CG  GLN L  19      69.870  43.704  43.553  1.00 32.79           C  
ATOM  10467  CD  GLN L  19      69.856  42.429  44.378  1.00 34.20           C  
ATOM  10468  OE1 GLN L  19      69.035  41.536  44.153  1.00 35.79           O  
ATOM  10469  NE2 GLN L  19      70.757  42.348  45.352  1.00 35.18           N  
ATOM  10470  N   ALA L  20      68.370  44.155  39.279  1.00 26.86           N  
ATOM  10471  CA  ALA L  20      68.148  43.778  37.890  1.00 28.01           C  
ATOM  10472  C   ALA L  20      66.679  43.742  37.543  1.00 26.31           C  
ATOM  10473  O   ALA L  20      65.830  43.560  38.406  1.00 27.46           O  
ATOM  10474  CB  ALA L  20      68.786  42.412  37.603  1.00 27.54           C  
ATOM  10475  N   ILE L  21      66.395  43.925  36.264  1.00 25.27           N  
ATOM  10476  CA  ILE L  21      65.038  43.912  35.767  1.00 26.20           C  
ATOM  10477  C   ILE L  21      64.933  43.013  34.536  1.00 27.47           C  
ATOM  10478  O   ILE L  21      65.770  43.060  33.631  1.00 27.06           O  
ATOM  10479  CB  ILE L  21      64.573  45.357  35.431  1.00 27.40           C  
ATOM  10480  CG1 ILE L  21      64.396  46.135  36.734  1.00 30.10           C  
ATOM  10481  CG2 ILE L  21      63.277  45.343  34.638  1.00 25.45           C  
ATOM  10482  CD1 ILE L  21      63.726  47.474  36.568  1.00 35.30           C  
ATOM  10483  N   LYS L  22      63.907  42.175  34.529  1.00 29.64           N  
ATOM  10484  CA  LYS L  22      63.659  41.266  33.429  1.00 31.75           C  
ATOM  10485  C   LYS L  22      62.614  41.912  32.553  1.00 32.33           C  
ATOM  10486  O   LYS L  22      61.517  42.200  33.020  1.00 34.51           O  
ATOM  10487  CB  LYS L  22      63.142  39.937  33.966  1.00 34.21           C  
ATOM  10488  CG  LYS L  22      62.840  38.911  32.895  1.00 39.14           C  
ATOM  10489  CD  LYS L  22      62.503  37.575  33.535  1.00 43.31           C  
ATOM  10490  CE  LYS L  22      62.180  36.509  32.502  1.00 46.02           C  
ATOM  10491  NZ  LYS L  22      61.859  35.193  33.148  1.00 49.62           N  
ATOM  10492  N   ALA L  23      62.952  42.156  31.290  1.00 32.84           N  
ATOM  10493  CA  ALA L  23      62.018  42.784  30.355  1.00 31.95           C  
ATOM  10494  C   ALA L  23      61.873  41.897  29.143  1.00 32.45           C  
ATOM  10495  O   ALA L  23      62.652  41.997  28.198  1.00 33.42           O  
ATOM  10496  CB  ALA L  23      62.529  44.135  29.939  1.00 32.78           C  
ATOM  10497  N   GLY L  24      60.854  41.048  29.157  1.00 32.63           N  
ATOM  10498  CA  GLY L  24      60.672  40.122  28.060  1.00 32.51           C  
ATOM  10499  C   GLY L  24      61.586  38.951  28.379  1.00 32.62           C  
ATOM  10500  O   GLY L  24      61.595  38.456  29.502  1.00 33.67           O  
ATOM  10501  N   ASN L  25      62.374  38.520  27.406  1.00 32.64           N  
ATOM  10502  CA  ASN L  25      63.293  37.408  27.605  1.00 32.25           C  
ATOM  10503  C   ASN L  25      64.666  37.897  28.057  1.00 31.36           C  
ATOM  10504  O   ASN L  25      65.555  37.102  28.353  1.00 29.94           O  
ATOM  10505  CB  ASN L  25      63.436  36.629  26.298  1.00 35.69           C  
ATOM  10506  CG  ASN L  25      62.135  35.999  25.855  1.00 36.48           C  
ATOM  10507  OD1 ASN L  25      61.988  35.594  24.696  1.00 39.06           O  
ATOM  10508  ND2 ASN L  25      61.186  35.898  26.778  1.00 36.05           N  
ATOM  10509  N   PHE L  26      64.834  39.213  28.106  1.00 30.84           N  
ATOM  10510  CA  PHE L  26      66.101  39.801  28.507  1.00 30.20           C  
ATOM  10511  C   PHE L  26      66.179  40.115  29.990  1.00 29.95           C  
ATOM  10512  O   PHE L  26      65.171  40.395  30.649  1.00 30.31           O  
ATOM  10513  CB  PHE L  26      66.369  41.069  27.696  1.00 30.65           C  
ATOM  10514  CG  PHE L  26      66.793  40.803  26.276  1.00 30.61           C  
ATOM  10515  CD1 PHE L  26      68.117  40.498  25.977  1.00 30.18           C  
ATOM  10516  CD2 PHE L  26      65.867  40.863  25.240  1.00 29.64           C  
ATOM  10517  CE1 PHE L  26      68.515  40.262  24.664  1.00 33.32           C  
ATOM  10518  CE2 PHE L  26      66.248  40.626  23.929  1.00 30.45           C  
ATOM  10519  CZ  PHE L  26      67.577  40.327  23.634  1.00 32.89           C  
ATOM  10520  N   LEU L  27      67.396  40.042  30.514  1.00 28.34           N  
ATOM  10521  CA  LEU L  27      67.638  40.333  31.909  1.00 27.08           C  
ATOM  10522  C   LEU L  27      68.692  41.430  31.949  1.00 27.51           C  
ATOM  10523  O   LEU L  27      69.791  41.267  31.415  1.00 25.37           O  
ATOM  10524  CB  LEU L  27      68.150  39.089  32.645  1.00 24.78           C  
ATOM  10525  CG  LEU L  27      68.218  39.282  34.165  1.00 24.73           C  
ATOM  10526  CD1 LEU L  27      66.811  39.478  34.723  1.00 25.07           C  
ATOM  10527  CD2 LEU L  27      68.877  38.081  34.816  1.00 25.18           C  
ATOM  10528  N   PHE L  28      68.343  42.559  32.559  1.00 28.26           N  
ATOM  10529  CA  PHE L  28      69.270  43.682  32.670  1.00 26.50           C  
ATOM  10530  C   PHE L  28      69.780  43.783  34.107  1.00 25.97           C  
ATOM  10531  O   PHE L  28      69.047  44.095  35.038  1.00 25.64           O  
ATOM  10532  CB  PHE L  28      68.578  44.972  32.214  1.00 25.33           C  
ATOM  10533  CG  PHE L  28      68.289  45.000  30.745  1.00 23.88           C  
ATOM  10534  CD1 PHE L  28      69.215  45.530  29.853  1.00 23.92           C  
ATOM  10535  CD2 PHE L  28      67.124  44.425  30.242  1.00 24.52           C  
ATOM  10536  CE1 PHE L  28      68.989  45.486  28.471  1.00 23.21           C  
ATOM  10537  CE2 PHE L  28      66.888  44.373  28.865  1.00 23.93           C  
ATOM  10538  CZ  PHE L  28      67.824  44.906  27.979  1.00 22.65           C  
ATOM  10539  N   ILE L  29      71.053  43.485  34.276  1.00 27.04           N  
ATOM  10540  CA  ILE L  29      71.653  43.510  35.591  1.00 28.18           C  
ATOM  10541  C   ILE L  29      72.378  44.824  35.855  1.00 29.49           C  
ATOM  10542  O   ILE L  29      73.090  45.343  34.997  1.00 31.92           O  
ATOM  10543  CB  ILE L  29      72.612  42.309  35.742  1.00 25.92           C  
ATOM  10544  CG1 ILE L  29      71.822  41.012  35.519  1.00 24.58           C  
ATOM  10545  CG2 ILE L  29      73.250  42.309  37.111  1.00 23.77           C  
ATOM  10546  CD1 ILE L  29      72.637  39.736  35.676  1.00 25.66           C  
ATOM  10547  N   ALA L  30      72.175  45.361  37.050  1.00 30.14           N  
ATOM  10548  CA  ALA L  30      72.800  46.611  37.457  1.00 29.93           C  
ATOM  10549  C   ALA L  30      74.286  46.410  37.719  1.00 29.57           C  
ATOM  10550  O   ALA L  30      74.722  45.317  38.092  1.00 28.59           O  
ATOM  10551  CB  ALA L  30      72.121  47.150  38.720  1.00 28.09           C  
ATOM  10552  N   GLY L  31      75.053  47.479  37.533  1.00 29.85           N  
ATOM  10553  CA  GLY L  31      76.484  47.416  37.762  1.00 30.42           C  
ATOM  10554  C   GLY L  31      76.767  46.845  39.133  1.00 31.73           C  
ATOM  10555  O   GLY L  31      76.251  47.331  40.144  1.00 33.34           O  
ATOM  10556  N   GLN L  32      77.584  45.802  39.165  1.00 32.95           N  
ATOM  10557  CA  GLN L  32      77.942  45.140  40.405  1.00 33.56           C  
ATOM  10558  C   GLN L  32      79.368  45.465  40.819  1.00 35.99           C  
ATOM  10559  O   GLN L  32      80.281  45.473  39.984  1.00 34.83           O  
ATOM  10560  CB  GLN L  32      77.789  43.625  40.243  1.00 33.89           C  
ATOM  10561  CG  GLN L  32      76.349  43.164  40.067  1.00 32.67           C  
ATOM  10562  CD  GLN L  32      75.467  43.558  41.242  1.00 32.74           C  
ATOM  10563  OE1 GLN L  32      75.791  43.284  42.404  1.00 28.65           O  
ATOM  10564  NE2 GLN L  32      74.342  44.202  40.942  1.00 34.95           N  
ATOM  10565  N   ILE L  33      79.548  45.743  42.112  1.00 37.68           N  
ATOM  10566  CA  ILE L  33      80.861  46.042  42.673  1.00 39.30           C  
ATOM  10567  C   ILE L  33      81.171  45.016  43.761  1.00 39.98           C  
ATOM  10568  O   ILE L  33      80.266  44.379  44.284  1.00 40.12           O  
ATOM  10569  CB  ILE L  33      80.937  47.477  43.258  1.00 39.18           C  
ATOM  10570  CG1 ILE L  33      79.965  47.641  44.422  1.00 41.72           C  
ATOM  10571  CG2 ILE L  33      80.624  48.490  42.179  1.00 39.57           C  
ATOM  10572  CD1 ILE L  33      80.040  49.009  45.067  1.00 41.13           C  
ATOM  10573  N   PRO L  34      82.460  44.844  44.103  1.00 42.46           N  
ATOM  10574  CA  PRO L  34      82.976  43.908  45.112  1.00 45.45           C  
ATOM  10575  C   PRO L  34      82.528  44.107  46.567  1.00 47.72           C  
ATOM  10576  O   PRO L  34      83.335  44.415  47.450  1.00 47.59           O  
ATOM  10577  CB  PRO L  34      84.485  44.045  44.951  1.00 44.30           C  
ATOM  10578  CG  PRO L  34      84.638  45.478  44.562  1.00 42.81           C  
ATOM  10579  CD  PRO L  34      83.568  45.622  43.522  1.00 43.36           C  
ATOM  10580  N   ILE L  35      81.237  43.918  46.808  1.00 49.60           N  
ATOM  10581  CA  ILE L  35      80.675  44.051  48.141  1.00 50.30           C  
ATOM  10582  C   ILE L  35      80.106  42.700  48.522  1.00 51.24           C  
ATOM  10583  O   ILE L  35      79.395  42.077  47.731  1.00 51.01           O  
ATOM  10584  CB  ILE L  35      79.531  45.076  48.182  1.00 50.55           C  
ATOM  10585  CG1 ILE L  35      80.015  46.423  47.653  1.00 51.57           C  
ATOM  10586  CG2 ILE L  35      79.019  45.224  49.605  1.00 48.35           C  
ATOM  10587  CD1 ILE L  35      78.947  47.490  47.682  1.00 53.09           C  
ATOM  10588  N   ASP L  36      80.414  42.251  49.732  1.00 51.97           N  
ATOM  10589  CA  ASP L  36      79.916  40.969  50.206  1.00 53.22           C  
ATOM  10590  C   ASP L  36      78.576  41.166  50.907  1.00 52.19           C  
ATOM  10591  O   ASP L  36      78.503  41.817  51.945  1.00 52.37           O  
ATOM  10592  CB  ASP L  36      80.931  40.338  51.156  1.00 54.64           C  
ATOM  10593  CG  ASP L  36      80.438  39.045  51.745  1.00 57.41           C  
ATOM  10594  OD1 ASP L  36      79.885  38.216  50.982  1.00 58.79           O  
ATOM  10595  OD2 ASP L  36      80.610  38.858  52.969  1.00 58.75           O  
ATOM  10596  N   PRO L  37      77.495  40.600  50.342  1.00 51.93           N  
ATOM  10597  CA  PRO L  37      76.141  40.714  50.900  1.00 51.81           C  
ATOM  10598  C   PRO L  37      75.961  40.257  52.343  1.00 52.37           C  
ATOM  10599  O   PRO L  37      75.156  40.824  53.081  1.00 52.78           O  
ATOM  10600  CB  PRO L  37      75.289  39.905  49.920  1.00 51.49           C  
ATOM  10601  CG  PRO L  37      76.254  38.882  49.400  1.00 52.02           C  
ATOM  10602  CD  PRO L  37      77.501  39.703  49.173  1.00 51.00           C  
ATOM  10603  N   LYS L  38      76.713  39.244  52.756  1.00 53.91           N  
ATOM  10604  CA  LYS L  38      76.593  38.744  54.119  1.00 55.32           C  
ATOM  10605  C   LYS L  38      77.201  39.696  55.149  1.00 55.55           C  
ATOM  10606  O   LYS L  38      76.921  39.579  56.341  1.00 55.93           O  
ATOM  10607  CB  LYS L  38      77.243  37.359  54.240  1.00 56.85           C  
ATOM  10608  CG  LYS L  38      76.774  36.562  55.460  1.00 59.89           C  
ATOM  10609  CD  LYS L  38      75.249  36.399  55.459  1.00 60.37           C  
ATOM  10610  CE  LYS L  38      74.728  35.858  56.782  1.00 60.86           C  
ATOM  10611  NZ  LYS L  38      73.238  35.889  56.833  1.00 60.75           N  
ATOM  10612  N   THR L  39      78.018  40.643  54.691  1.00 56.06           N  
ATOM  10613  CA  THR L  39      78.652  41.608  55.592  1.00 56.77           C  
ATOM  10614  C   THR L  39      78.348  43.062  55.221  1.00 57.95           C  
ATOM  10615  O   THR L  39      78.333  43.941  56.090  1.00 57.26           O  
ATOM  10616  CB  THR L  39      80.193  41.433  55.621  1.00 56.24           C  
ATOM  10617  OG1 THR L  39      80.751  41.825  54.359  1.00 57.13           O  
ATOM  10618  CG2 THR L  39      80.561  39.986  55.903  1.00 54.55           C  
ATOM  10619  N   GLY L  40      78.110  43.308  53.936  1.00 58.51           N  
ATOM  10620  CA  GLY L  40      77.823  44.653  53.475  1.00 60.03           C  
ATOM  10621  C   GLY L  40      79.098  45.437  53.227  1.00 62.24           C  
ATOM  10622  O   GLY L  40      79.073  46.549  52.696  1.00 61.92           O  
ATOM  10623  N   GLU L  41      80.227  44.850  53.604  1.00 64.03           N  
ATOM  10624  CA  GLU L  41      81.516  45.505  53.424  1.00 66.71           C  
ATOM  10625  C   GLU L  41      82.162  45.138  52.087  1.00 66.53           C  
ATOM  10626  O   GLU L  41      81.799  44.142  51.458  1.00 66.43           O  
ATOM  10627  CB  GLU L  41      82.462  45.119  54.568  1.00 69.14           C  
ATOM  10628  CG  GLU L  41      81.908  45.371  55.966  1.00 73.40           C  
ATOM  10629  CD  GLU L  41      81.611  46.837  56.224  1.00 76.01           C  
ATOM  10630  OE1 GLU L  41      82.534  47.665  56.064  1.00 76.81           O  
ATOM  10631  OE2 GLU L  41      80.456  47.158  56.590  1.00 77.16           O  
ATOM  10632  N   ILE L  42      83.120  45.953  51.658  1.00 66.48           N  
ATOM  10633  CA  ILE L  42      83.834  45.707  50.413  1.00 66.97           C  
ATOM  10634  C   ILE L  42      84.978  44.733  50.680  1.00 67.82           C  
ATOM  10635  O   ILE L  42      85.695  44.869  51.669  1.00 67.66           O  
ATOM  10636  CB  ILE L  42      84.411  47.014  49.839  1.00 66.54           C  
ATOM  10637  CG1 ILE L  42      83.267  47.918  49.370  1.00 66.53           C  
ATOM  10638  CG2 ILE L  42      85.375  46.704  48.701  1.00 66.29           C  
ATOM  10639  CD1 ILE L  42      83.718  49.278  48.870  1.00 66.15           C  
ATOM  10640  N   VAL L  43      85.143  43.751  49.802  1.00 68.92           N  
ATOM  10641  CA  VAL L  43      86.199  42.760  49.955  1.00 70.34           C  
ATOM  10642  C   VAL L  43      87.570  43.438  49.964  1.00 71.43           C  
ATOM  10643  O   VAL L  43      87.674  44.640  49.713  1.00 70.86           O  
ATOM  10644  CB  VAL L  43      86.138  41.720  48.816  1.00 71.31           C  
ATOM  10645  CG1 VAL L  43      87.137  40.609  49.059  1.00 71.55           C  
ATOM  10646  CG2 VAL L  43      84.730  41.145  48.722  1.00 71.63           C  
ATOM  10647  N   LYS L  44      88.613  42.664  50.262  1.00 72.81           N  
ATOM  10648  CA  LYS L  44      89.981  43.174  50.320  1.00 74.02           C  
ATOM  10649  C   LYS L  44      90.326  44.061  49.131  1.00 74.79           C  
ATOM  10650  O   LYS L  44      89.745  43.925  48.054  1.00 75.49           O  
ATOM  10651  CB  LYS L  44      90.982  42.018  50.381  1.00 74.39           C  
ATOM  10652  CG  LYS L  44      90.768  41.059  51.542  1.00 75.06           C  
ATOM  10653  CD  LYS L  44      89.587  40.125  51.302  1.00 75.09           C  
ATOM  10654  CE  LYS L  44      89.834  39.215  50.106  1.00 74.80           C  
ATOM  10655  NZ  LYS L  44      88.769  38.183  49.948  1.00 74.11           N  
ATOM  10656  N   GLY L  45      91.284  44.961  49.331  1.00 75.53           N  
ATOM  10657  CA  GLY L  45      91.697  45.861  48.270  1.00 75.67           C  
ATOM  10658  C   GLY L  45      92.563  45.200  47.211  1.00 75.98           C  
ATOM  10659  O   GLY L  45      93.579  45.762  46.800  1.00 76.02           O  
ATOM  10660  N   ASP L  46      92.168  44.009  46.766  1.00 75.81           N  
ATOM  10661  CA  ASP L  46      92.920  43.292  45.741  1.00 75.02           C  
ATOM  10662  C   ASP L  46      92.054  42.875  44.550  1.00 73.63           C  
ATOM  10663  O   ASP L  46      91.066  42.156  44.706  1.00 73.38           O  
ATOM  10664  CB  ASP L  46      93.592  42.058  46.335  1.00 76.08           C  
ATOM  10665  CG  ASP L  46      94.438  41.320  45.319  1.00 77.58           C  
ATOM  10666  OD1 ASP L  46      93.863  40.695  44.400  1.00 77.03           O  
ATOM  10667  OD2 ASP L  46      95.683  41.376  45.432  1.00 78.98           O  
ATOM  10668  N   ILE L  47      92.457  43.319  43.362  1.00 71.30           N  
ATOM  10669  CA  ILE L  47      91.750  43.037  42.113  1.00 68.72           C  
ATOM  10670  C   ILE L  47      91.256  41.596  41.927  1.00 66.80           C  
ATOM  10671  O   ILE L  47      90.120  41.378  41.509  1.00 65.72           O  
ATOM  10672  CB  ILE L  47      92.631  43.422  40.890  1.00 68.53           C  
ATOM  10673  CG1 ILE L  47      91.838  43.241  39.595  1.00 68.63           C  
ATOM  10674  CG2 ILE L  47      93.897  42.572  40.859  1.00 67.68           C  
ATOM  10675  CD1 ILE L  47      90.647  44.169  39.465  1.00 67.68           C  
ATOM  10676  N   LYS L  48      92.105  40.619  42.231  1.00 65.11           N  
ATOM  10677  CA  LYS L  48      91.734  39.214  42.076  1.00 64.35           C  
ATOM  10678  C   LYS L  48      90.538  38.821  42.945  1.00 63.17           C  
ATOM  10679  O   LYS L  48      89.691  38.030  42.523  1.00 62.60           O  
ATOM  10680  CB  LYS L  48      92.935  38.316  42.402  1.00 65.64           C  
ATOM  10681  CG  LYS L  48      92.611  36.825  42.490  1.00 67.42           C  
ATOM  10682  CD  LYS L  48      93.857  35.993  42.806  1.00 67.82           C  
ATOM  10683  CE  LYS L  48      93.516  34.523  43.065  1.00 68.83           C  
ATOM  10684  NZ  LYS L  48      92.707  34.313  44.308  1.00 68.33           N  
ATOM  10685  N   ASP L  49      90.471  39.379  44.154  1.00 61.31           N  
ATOM  10686  CA  ASP L  49      89.382  39.089  45.089  1.00 58.57           C  
ATOM  10687  C   ASP L  49      88.099  39.825  44.706  1.00 56.55           C  
ATOM  10688  O   ASP L  49      87.008  39.255  44.748  1.00 56.29           O  
ATOM  10689  CB  ASP L  49      89.783  39.485  46.516  1.00 58.18           C  
ATOM  10690  CG  ASP L  49      91.017  38.745  47.005  1.00 57.39           C  
ATOM  10691  OD1 ASP L  49      90.979  37.500  47.084  1.00 57.33           O  
ATOM  10692  OD2 ASP L  49      92.026  39.414  47.313  1.00 57.72           O  
ATOM  10693  N   GLN L  50      88.241  41.092  44.333  1.00 53.42           N  
ATOM  10694  CA  GLN L  50      87.102  41.906  43.950  1.00 51.60           C  
ATOM  10695  C   GLN L  50      86.386  41.330  42.743  1.00 50.94           C  
ATOM  10696  O   GLN L  50      85.170  41.127  42.776  1.00 51.37           O  
ATOM  10697  CB  GLN L  50      87.555  43.332  43.667  1.00 50.87           C  
ATOM  10698  CG  GLN L  50      88.322  43.931  44.832  1.00 53.14           C  
ATOM  10699  CD  GLN L  50      88.081  45.411  44.998  1.00 54.07           C  
ATOM  10700  OE1 GLN L  50      88.240  46.185  44.053  1.00 56.52           O  
ATOM  10701  NE2 GLN L  50      87.698  45.818  46.207  1.00 51.97           N  
ATOM  10702  N   THR L  51      87.143  41.055  41.687  1.00 49.41           N  
ATOM  10703  CA  THR L  51      86.580  40.492  40.472  1.00 48.04           C  
ATOM  10704  C   THR L  51      85.765  39.255  40.808  1.00 47.29           C  
ATOM  10705  O   THR L  51      84.633  39.102  40.355  1.00 46.87           O  
ATOM  10706  CB  THR L  51      87.687  40.109  39.479  1.00 48.85           C  
ATOM  10707  OG1 THR L  51      88.477  41.267  39.183  1.00 50.55           O  
ATOM  10708  CG2 THR L  51      87.087  39.580  38.187  1.00 47.74           C  
ATOM  10709  N   ARG L  52      86.344  38.378  41.617  1.00 47.58           N  
ATOM  10710  CA  ARG L  52      85.666  37.151  42.024  1.00 48.63           C  
ATOM  10711  C   ARG L  52      84.351  37.465  42.740  1.00 47.58           C  
ATOM  10712  O   ARG L  52      83.333  36.804  42.514  1.00 46.49           O  
ATOM  10713  CB  ARG L  52      86.576  36.327  42.946  1.00 50.11           C  
ATOM  10714  CG  ARG L  52      85.984  34.999  43.413  1.00 53.07           C  
ATOM  10715  CD  ARG L  52      86.781  33.839  42.858  1.00 56.58           C  
ATOM  10716  NE  ARG L  52      88.200  34.005  43.159  1.00 59.33           N  
ATOM  10717  CZ  ARG L  52      89.180  33.396  42.498  1.00 61.14           C  
ATOM  10718  NH1 ARG L  52      90.445  33.611  42.847  1.00 60.86           N  
ATOM  10719  NH2 ARG L  52      88.896  32.580  41.485  1.00 60.57           N  
ATOM  10720  N   GLN L  53      84.376  38.475  43.606  1.00 46.04           N  
ATOM  10721  CA  GLN L  53      83.180  38.865  44.338  1.00 44.31           C  
ATOM  10722  C   GLN L  53      82.147  39.414  43.367  1.00 43.74           C  
ATOM  10723  O   GLN L  53      80.956  39.109  43.476  1.00 43.47           O  
ATOM  10724  CB  GLN L  53      83.514  39.932  45.379  1.00 45.34           C  
ATOM  10725  CG  GLN L  53      82.316  40.403  46.190  1.00 45.79           C  
ATOM  10726  CD  GLN L  53      81.725  39.305  47.058  1.00 46.42           C  
ATOM  10727  OE1 GLN L  53      82.398  38.764  47.937  1.00 47.23           O  
ATOM  10728  NE2 GLN L  53      80.457  38.972  46.816  1.00 45.08           N  
ATOM  10729  N   VAL L  54      82.609  40.225  42.416  1.00 41.93           N  
ATOM  10730  CA  VAL L  54      81.720  40.817  41.425  1.00 41.69           C  
ATOM  10731  C   VAL L  54      81.014  39.760  40.573  1.00 42.39           C  
ATOM  10732  O   VAL L  54      79.808  39.857  40.313  1.00 42.18           O  
ATOM  10733  CB  VAL L  54      82.480  41.783  40.495  1.00 41.04           C  
ATOM  10734  CG1 VAL L  54      81.575  42.228  39.355  1.00 40.43           C  
ATOM  10735  CG2 VAL L  54      82.941  43.000  41.279  1.00 41.38           C  
ATOM  10736  N   LEU L  55      81.762  38.752  40.136  1.00 41.22           N  
ATOM  10737  CA  LEU L  55      81.175  37.698  39.331  1.00 40.53           C  
ATOM  10738  C   LEU L  55      80.202  36.887  40.197  1.00 39.87           C  
ATOM  10739  O   LEU L  55      79.165  36.410  39.723  1.00 39.01           O  
ATOM  10740  CB  LEU L  55      82.286  36.824  38.735  1.00 40.35           C  
ATOM  10741  CG  LEU L  55      83.212  37.625  37.803  1.00 41.21           C  
ATOM  10742  CD1 LEU L  55      84.310  36.741  37.221  1.00 41.51           C  
ATOM  10743  CD2 LEU L  55      82.391  38.237  36.692  1.00 39.72           C  
ATOM  10744  N   GLU L  56      80.523  36.761  41.479  1.00 39.42           N  
ATOM  10745  CA  GLU L  56      79.659  36.037  42.404  1.00 39.60           C  
ATOM  10746  C   GLU L  56      78.319  36.753  42.530  1.00 36.67           C  
ATOM  10747  O   GLU L  56      77.256  36.124  42.495  1.00 35.45           O  
ATOM  10748  CB  GLU L  56      80.331  35.931  43.778  1.00 42.03           C  
ATOM  10749  CG  GLU L  56      81.464  34.911  43.824  1.00 47.80           C  
ATOM  10750  CD  GLU L  56      80.957  33.478  43.738  1.00 50.83           C  
ATOM  10751  OE1 GLU L  56      80.491  32.950  44.774  1.00 52.06           O  
ATOM  10752  OE2 GLU L  56      81.014  32.888  42.634  1.00 53.36           O  
ATOM  10753  N   ASN L  57      78.378  38.075  42.666  1.00 34.08           N  
ATOM  10754  CA  ASN L  57      77.166  38.870  42.799  1.00 33.37           C  
ATOM  10755  C   ASN L  57      76.332  38.772  41.537  1.00 32.50           C  
ATOM  10756  O   ASN L  57      75.115  38.631  41.594  1.00 31.72           O  
ATOM  10757  CB  ASN L  57      77.504  40.335  43.110  1.00 33.58           C  
ATOM  10758  CG  ASN L  57      78.161  40.510  44.479  1.00 33.06           C  
ATOM  10759  OD1 ASN L  57      78.038  39.653  45.358  1.00 28.59           O  
ATOM  10760  ND2 ASN L  57      78.848  41.635  44.666  1.00 35.82           N  
ATOM  10761  N   ILE L  58      76.984  38.840  40.385  1.00 33.34           N  
ATOM  10762  CA  ILE L  58      76.245  38.717  39.145  1.00 34.17           C  
ATOM  10763  C   ILE L  58      75.668  37.302  39.057  1.00 35.10           C  
ATOM  10764  O   ILE L  58      74.566  37.098  38.544  1.00 34.56           O  
ATOM  10765  CB  ILE L  58      77.146  38.984  37.925  1.00 33.29           C  
ATOM  10766  CG1 ILE L  58      77.631  40.439  37.955  1.00 35.43           C  
ATOM  10767  CG2 ILE L  58      76.378  38.710  36.636  1.00 31.44           C  
ATOM  10768  CD1 ILE L  58      78.414  40.869  36.714  1.00 33.94           C  
ATOM  10769  N   LYS L  59      76.416  36.332  39.574  1.00 35.90           N  
ATOM  10770  CA  LYS L  59      75.995  34.941  39.545  1.00 37.56           C  
ATOM  10771  C   LYS L  59      74.730  34.740  40.381  1.00 38.30           C  
ATOM  10772  O   LYS L  59      73.780  34.078  39.945  1.00 36.86           O  
ATOM  10773  CB  LYS L  59      77.134  34.050  40.058  1.00 40.73           C  
ATOM  10774  CG  LYS L  59      76.888  32.550  39.943  1.00 43.53           C  
ATOM  10775  CD  LYS L  59      78.133  31.766  40.358  1.00 47.73           C  
ATOM  10776  CE  LYS L  59      77.952  30.252  40.206  1.00 49.25           C  
ATOM  10777  NZ  LYS L  59      76.889  29.672  41.090  1.00 49.52           N  
ATOM  10778  N   ALA L  60      74.716  35.324  41.577  1.00 38.38           N  
ATOM  10779  CA  ALA L  60      73.562  35.211  42.466  1.00 37.46           C  
ATOM  10780  C   ALA L  60      72.304  35.831  41.851  1.00 36.78           C  
ATOM  10781  O   ALA L  60      71.201  35.314  42.014  1.00 38.78           O  
ATOM  10782  CB  ALA L  60      73.873  35.874  43.812  1.00 36.51           C  
ATOM  10783  N   ILE L  61      72.473  36.941  41.143  1.00 36.15           N  
ATOM  10784  CA  ILE L  61      71.346  37.629  40.514  1.00 34.51           C  
ATOM  10785  C   ILE L  61      70.827  36.831  39.321  1.00 34.55           C  
ATOM  10786  O   ILE L  61      69.617  36.753  39.083  1.00 35.58           O  
ATOM  10787  CB  ILE L  61      71.761  39.067  40.078  1.00 32.09           C  
ATOM  10788  CG1 ILE L  61      72.174  39.865  41.322  1.00 30.79           C  
ATOM  10789  CG2 ILE L  61      70.617  39.767  39.369  1.00 30.45           C  
ATOM  10790  CD1 ILE L  61      72.713  41.250  41.053  1.00 30.30           C  
ATOM  10791  N   LEU L  62      71.748  36.234  38.573  1.00 32.92           N  
ATOM  10792  CA  LEU L  62      71.362  35.431  37.426  1.00 33.55           C  
ATOM  10793  C   LEU L  62      70.457  34.310  37.895  1.00 35.29           C  
ATOM  10794  O   LEU L  62      69.366  34.117  37.373  1.00 37.25           O  
ATOM  10795  CB  LEU L  62      72.601  34.841  36.746  1.00 30.67           C  
ATOM  10796  CG  LEU L  62      73.367  35.762  35.800  1.00 26.19           C  
ATOM  10797  CD1 LEU L  62      74.672  35.117  35.384  1.00 25.14           C  
ATOM  10798  CD2 LEU L  62      72.487  36.060  34.597  1.00 23.46           C  
ATOM  10799  N   GLU L  63      70.922  33.580  38.900  1.00 37.95           N  
ATOM  10800  CA  GLU L  63      70.181  32.459  39.457  1.00 39.27           C  
ATOM  10801  C   GLU L  63      68.806  32.861  39.954  1.00 38.83           C  
ATOM  10802  O   GLU L  63      67.822  32.176  39.676  1.00 40.54           O  
ATOM  10803  CB  GLU L  63      70.972  31.832  40.604  1.00 41.82           C  
ATOM  10804  CG  GLU L  63      72.268  31.169  40.176  1.00 44.58           C  
ATOM  10805  CD  GLU L  63      73.129  30.819  41.370  1.00 49.41           C  
ATOM  10806  OE1 GLU L  63      72.604  30.923  42.505  1.00 49.49           O  
ATOM  10807  OE2 GLU L  63      74.316  30.445  41.178  1.00 48.48           O  
ATOM  10808  N   ALA L  64      68.745  33.969  40.689  1.00 37.29           N  
ATOM  10809  CA  ALA L  64      67.483  34.473  41.233  1.00 35.72           C  
ATOM  10810  C   ALA L  64      66.402  34.689  40.166  1.00 35.78           C  
ATOM  10811  O   ALA L  64      65.237  34.339  40.375  1.00 35.15           O  
ATOM  10812  CB  ALA L  64      67.727  35.776  41.990  1.00 34.39           C  
ATOM  10813  N   ALA L  65      66.785  35.269  39.029  1.00 34.76           N  
ATOM  10814  CA  ALA L  65      65.827  35.525  37.954  1.00 35.19           C  
ATOM  10815  C   ALA L  65      65.500  34.251  37.186  1.00 35.34           C  
ATOM  10816  O   ALA L  65      64.618  34.240  36.325  1.00 35.36           O  
ATOM  10817  CB  ALA L  65      66.373  36.584  36.998  1.00 34.79           C  
ATOM  10818  N   GLY L  66      66.216  33.178  37.506  1.00 34.80           N  
ATOM  10819  CA  GLY L  66      65.990  31.916  36.837  1.00 33.90           C  
ATOM  10820  C   GLY L  66      66.925  31.739  35.658  1.00 34.88           C  
ATOM  10821  O   GLY L  66      66.710  30.876  34.811  1.00 37.18           O  
ATOM  10822  N   TYR L  67      67.963  32.565  35.599  1.00 34.21           N  
ATOM  10823  CA  TYR L  67      68.943  32.495  34.521  1.00 32.44           C  
ATOM  10824  C   TYR L  67      70.222  31.787  34.981  1.00 32.44           C  
ATOM  10825  O   TYR L  67      70.414  31.525  36.165  1.00 33.05           O  
ATOM  10826  CB  TYR L  67      69.289  33.908  34.033  1.00 30.33           C  
ATOM  10827  CG  TYR L  67      68.212  34.601  33.217  1.00 28.93           C  
ATOM  10828  CD1 TYR L  67      68.470  35.028  31.908  1.00 28.04           C  
ATOM  10829  CD2 TYR L  67      66.956  34.872  33.758  1.00 28.11           C  
ATOM  10830  CE1 TYR L  67      67.509  35.705  31.162  1.00 24.74           C  
ATOM  10831  CE2 TYR L  67      65.985  35.554  33.020  1.00 25.78           C  
ATOM  10832  CZ  TYR L  67      66.272  35.966  31.725  1.00 27.66           C  
ATOM  10833  OH  TYR L  67      65.326  36.645  30.991  1.00 31.40           O  
ATOM  10834  N   SER L  68      71.091  31.472  34.029  1.00 33.58           N  
ATOM  10835  CA  SER L  68      72.362  30.824  34.320  1.00 33.19           C  
ATOM  10836  C   SER L  68      73.452  31.640  33.629  1.00 34.97           C  
ATOM  10837  O   SER L  68      73.151  32.529  32.833  1.00 35.65           O  
ATOM  10838  CB  SER L  68      72.355  29.405  33.770  1.00 31.86           C  
ATOM  10839  OG  SER L  68      72.034  29.426  32.394  1.00 32.74           O  
ATOM  10840  N   LEU L  69      74.713  31.340  33.923  1.00 35.91           N  
ATOM  10841  CA  LEU L  69      75.824  32.059  33.312  1.00 36.94           C  
ATOM  10842  C   LEU L  69      75.926  31.913  31.788  1.00 38.69           C  
ATOM  10843  O   LEU L  69      76.378  32.842  31.112  1.00 38.92           O  
ATOM  10844  CB  LEU L  69      77.141  31.618  33.939  1.00 35.10           C  
ATOM  10845  CG  LEU L  69      77.387  32.030  35.389  1.00 35.19           C  
ATOM  10846  CD1 LEU L  69      78.455  31.136  35.971  1.00 33.40           C  
ATOM  10847  CD2 LEU L  69      77.793  33.497  35.470  1.00 31.54           C  
ATOM  10848  N   ASN L  70      75.506  30.770  31.242  1.00 40.00           N  
ATOM  10849  CA  ASN L  70      75.593  30.551  29.795  1.00 40.95           C  
ATOM  10850  C   ASN L  70      74.528  31.334  29.030  1.00 39.69           C  
ATOM  10851  O   ASN L  70      74.444  31.269  27.800  1.00 40.25           O  
ATOM  10852  CB  ASN L  70      75.523  29.042  29.467  1.00 46.19           C  
ATOM  10853  CG  ASN L  70      74.099  28.522  29.317  1.00 51.22           C  
ATOM  10854  OD1 ASN L  70      73.433  28.778  28.305  1.00 55.23           O  
ATOM  10855  ND2 ASN L  70      73.624  27.784  30.322  1.00 51.89           N  
ATOM  10856  N   ASP L  71      73.732  32.093  29.776  1.00 37.76           N  
ATOM  10857  CA  ASP L  71      72.674  32.924  29.211  1.00 35.47           C  
ATOM  10858  C   ASP L  71      73.098  34.383  29.078  1.00 32.73           C  
ATOM  10859  O   ASP L  71      72.354  35.199  28.543  1.00 29.69           O  
ATOM  10860  CB  ASP L  71      71.433  32.856  30.089  1.00 39.87           C  
ATOM  10861  CG  ASP L  71      70.531  31.718  29.721  1.00 42.25           C  
ATOM  10862  OD1 ASP L  71      69.536  31.494  30.443  1.00 44.91           O  
ATOM  10863  OD2 ASP L  71      70.817  31.057  28.701  1.00 44.07           O  
ATOM  10864  N   VAL L  72      74.282  34.703  29.595  1.00 30.41           N  
ATOM  10865  CA  VAL L  72      74.823  36.055  29.531  1.00 29.14           C  
ATOM  10866  C   VAL L  72      75.296  36.317  28.099  1.00 28.91           C  
ATOM  10867  O   VAL L  72      76.117  35.566  27.567  1.00 29.77           O  
ATOM  10868  CB  VAL L  72      76.033  36.223  30.505  1.00 30.01           C  
ATOM  10869  CG1 VAL L  72      76.618  37.614  30.378  1.00 28.01           C  
ATOM  10870  CG2 VAL L  72      75.605  35.942  31.943  1.00 25.66           C  
ATOM  10871  N   ILE L  73      74.777  37.372  27.477  1.00 27.43           N  
ATOM  10872  CA  ILE L  73      75.157  37.706  26.104  1.00 28.68           C  
ATOM  10873  C   ILE L  73      76.100  38.915  25.957  1.00 30.22           C  
ATOM  10874  O   ILE L  73      76.737  39.085  24.913  1.00 29.74           O  
ATOM  10875  CB  ILE L  73      73.904  37.951  25.223  1.00 26.05           C  
ATOM  10876  CG1 ILE L  73      73.021  39.024  25.858  1.00 26.97           C  
ATOM  10877  CG2 ILE L  73      73.123  36.660  25.067  1.00 27.13           C  
ATOM  10878  CD1 ILE L  73      71.856  39.471  25.005  1.00 25.73           C  
ATOM  10879  N   LYS L  74      76.189  39.750  26.991  1.00 31.18           N  
ATOM  10880  CA  LYS L  74      77.059  40.916  26.932  1.00 32.56           C  
ATOM  10881  C   LYS L  74      77.508  41.429  28.299  1.00 30.31           C  
ATOM  10882  O   LYS L  74      76.695  41.717  29.166  1.00 31.27           O  
ATOM  10883  CB  LYS L  74      76.376  42.053  26.171  1.00 34.83           C  
ATOM  10884  CG  LYS L  74      77.353  43.131  25.726  1.00 39.62           C  
ATOM  10885  CD  LYS L  74      76.649  44.311  25.090  1.00 44.04           C  
ATOM  10886  CE  LYS L  74      75.788  45.055  26.098  1.00 46.52           C  
ATOM  10887  NZ  LYS L  74      75.214  46.298  25.501  1.00 50.24           N  
ATOM  10888  N   VAL L  75      78.817  41.539  28.470  1.00 29.08           N  
ATOM  10889  CA  VAL L  75      79.423  42.015  29.705  1.00 28.33           C  
ATOM  10890  C   VAL L  75      80.157  43.338  29.469  1.00 28.08           C  
ATOM  10891  O   VAL L  75      80.896  43.477  28.499  1.00 26.41           O  
ATOM  10892  CB  VAL L  75      80.441  40.983  30.243  1.00 28.56           C  
ATOM  10893  CG1 VAL L  75      81.334  41.626  31.293  1.00 29.32           C  
ATOM  10894  CG2 VAL L  75      79.710  39.799  30.840  1.00 28.82           C  
ATOM  10895  N   THR L  76      79.937  44.315  30.344  1.00 29.25           N  
ATOM  10896  CA  THR L  76      80.621  45.605  30.235  1.00 31.48           C  
ATOM  10897  C   THR L  76      81.476  45.754  31.483  1.00 31.60           C  
ATOM  10898  O   THR L  76      80.946  45.853  32.597  1.00 28.73           O  
ATOM  10899  CB  THR L  76      79.644  46.796  30.176  1.00 33.93           C  
ATOM  10900  OG1 THR L  76      78.875  46.732  28.970  1.00 39.67           O  
ATOM  10901  CG2 THR L  76      80.418  48.109  30.194  1.00 34.73           C  
ATOM  10902  N   VAL L  77      82.793  45.766  31.299  1.00 31.87           N  
ATOM  10903  CA  VAL L  77      83.696  45.866  32.441  1.00 33.77           C  
ATOM  10904  C   VAL L  77      84.312  47.252  32.613  1.00 34.07           C  
ATOM  10905  O   VAL L  77      84.868  47.823  31.676  1.00 32.93           O  
ATOM  10906  CB  VAL L  77      84.823  44.802  32.347  1.00 34.29           C  
ATOM  10907  CG1 VAL L  77      85.573  44.714  33.666  1.00 33.36           C  
ATOM  10908  CG2 VAL L  77      84.225  43.435  31.981  1.00 34.60           C  
ATOM  10909  N   TYR L  78      84.188  47.788  33.821  1.00 34.82           N  
ATOM  10910  CA  TYR L  78      84.728  49.102  34.141  1.00 37.98           C  
ATOM  10911  C   TYR L  78      85.879  48.929  35.130  1.00 40.60           C  
ATOM  10912  O   TYR L  78      85.674  48.465  36.252  1.00 39.71           O  
ATOM  10913  CB  TYR L  78      83.645  49.983  34.766  1.00 36.83           C  
ATOM  10914  CG  TYR L  78      82.496  50.332  33.848  1.00 36.03           C  
ATOM  10915  CD1 TYR L  78      81.253  49.677  33.947  1.00 35.52           C  
ATOM  10916  CD2 TYR L  78      82.634  51.342  32.903  1.00 33.88           C  
ATOM  10917  CE1 TYR L  78      80.178  50.038  33.117  1.00 33.69           C  
ATOM  10918  CE2 TYR L  78      81.577  51.713  32.079  1.00 33.23           C  
ATOM  10919  CZ  TYR L  78      80.355  51.065  32.184  1.00 35.05           C  
ATOM  10920  OH  TYR L  78      79.332  51.469  31.350  1.00 34.37           O  
ATOM  10921  N   LEU L  79      87.087  49.300  34.717  1.00 44.86           N  
ATOM  10922  CA  LEU L  79      88.260  49.151  35.582  1.00 48.73           C  
ATOM  10923  C   LEU L  79      88.888  50.454  36.068  1.00 51.35           C  
ATOM  10924  O   LEU L  79      88.494  51.553  35.666  1.00 50.42           O  
ATOM  10925  CB  LEU L  79      89.335  48.318  34.873  1.00 47.43           C  
ATOM  10926  CG  LEU L  79      89.125  46.802  34.814  1.00 49.57           C  
ATOM  10927  CD1 LEU L  79      90.212  46.136  33.970  1.00 48.50           C  
ATOM  10928  CD2 LEU L  79      89.141  46.246  36.236  1.00 50.10           C  
ATOM  10929  N   LYS L  80      89.871  50.302  36.951  1.00 56.04           N  
ATOM  10930  CA  LYS L  80      90.621  51.422  37.509  1.00 59.25           C  
ATOM  10931  C   LYS L  80      91.817  51.666  36.594  1.00 61.56           C  
ATOM  10932  O   LYS L  80      91.697  52.343  35.574  1.00 62.59           O  
ATOM  10933  CB  LYS L  80      91.100  51.083  38.922  1.00 58.32           C  
ATOM  10934  N   ASP L  81      92.958  51.090  36.956  1.00 64.68           N  
ATOM  10935  CA  ASP L  81      94.193  51.225  36.183  1.00 68.23           C  
ATOM  10936  C   ASP L  81      95.192  50.135  36.579  1.00 69.88           C  
ATOM  10937  O   ASP L  81      95.751  49.479  35.667  1.00 70.63           O  
ATOM  10938  CB  ASP L  81      94.835  52.607  36.406  1.00 69.83           C  
ATOM  10939  CG  ASP L  81      94.099  53.731  35.681  1.00 71.71           C  
ATOM  10940  OD1 ASP L  81      93.050  54.190  36.182  1.00 72.52           O  
ATOM  10941  OD2 ASP L  81      94.575  54.152  34.601  1.00 71.48           O  
ATOM  10942  N   ASN L  89      91.706  38.600  33.370  1.00 82.77           N  
ATOM  10943  CA  ASN L  89      92.229  37.612  34.360  1.00 82.88           C  
ATOM  10944  C   ASN L  89      91.616  36.231  34.129  1.00 82.16           C  
ATOM  10945  O   ASN L  89      90.697  36.067  33.324  1.00 81.49           O  
ATOM  10946  CB  ASN L  89      91.918  38.076  35.788  1.00 84.21           C  
ATOM  10947  CG  ASN L  89      92.344  39.513  36.044  1.00 84.65           C  
ATOM  10948  OD1 ASN L  89      93.519  39.860  35.912  1.00 84.50           O  
ATOM  10949  ND2 ASN L  89      91.385  40.357  36.412  1.00 84.61           N  
ATOM  10950  N   GLU L  90      92.133  35.242  34.851  1.00 81.32           N  
ATOM  10951  CA  GLU L  90      91.663  33.866  34.743  1.00 80.10           C  
ATOM  10952  C   GLU L  90      90.265  33.704  35.332  1.00 78.40           C  
ATOM  10953  O   GLU L  90      89.504  32.824  34.923  1.00 78.05           O  
ATOM  10954  CB  GLU L  90      92.642  32.935  35.464  1.00 81.60           C  
ATOM  10955  CG  GLU L  90      92.206  31.481  35.550  1.00 83.72           C  
ATOM  10956  CD  GLU L  90      93.203  30.629  36.317  1.00 85.15           C  
ATOM  10957  OE1 GLU L  90      94.354  30.495  35.847  1.00 86.09           O  
ATOM  10958  OE2 GLU L  90      92.837  30.100  37.389  1.00 85.34           O  
ATOM  10959  N   VAL L  91      89.936  34.563  36.292  1.00 75.77           N  
ATOM  10960  CA  VAL L  91      88.635  34.524  36.952  1.00 73.46           C  
ATOM  10961  C   VAL L  91      87.465  34.584  35.968  1.00 71.96           C  
ATOM  10962  O   VAL L  91      86.519  33.800  36.063  1.00 70.33           O  
ATOM  10963  CB  VAL L  91      88.504  35.681  37.948  1.00 72.65           C  
ATOM  10964  CG1 VAL L  91      89.444  35.459  39.121  1.00 72.68           C  
ATOM  10965  CG2 VAL L  91      88.829  36.988  37.256  1.00 73.03           C  
ATOM  10966  N   TYR L  92      87.541  35.518  35.026  1.00 70.26           N  
ATOM  10967  CA  TYR L  92      86.496  35.688  34.025  1.00 68.53           C  
ATOM  10968  C   TYR L  92      86.237  34.394  33.264  1.00 67.04           C  
ATOM  10969  O   TYR L  92      85.086  34.044  32.998  1.00 67.48           O  
ATOM  10970  CB  TYR L  92      86.895  36.771  33.027  1.00 69.41           C  
ATOM  10971  CG  TYR L  92      87.275  38.095  33.646  1.00 70.39           C  
ATOM  10972  CD1 TYR L  92      86.377  39.162  33.675  1.00 71.52           C  
ATOM  10973  CD2 TYR L  92      88.550  38.290  34.176  1.00 71.31           C  
ATOM  10974  CE1 TYR L  92      86.745  40.400  34.215  1.00 72.17           C  
ATOM  10975  CE2 TYR L  92      88.929  39.518  34.720  1.00 72.26           C  
ATOM  10976  CZ  TYR L  92      88.025  40.569  34.734  1.00 72.44           C  
ATOM  10977  OH  TYR L  92      88.412  41.782  35.262  1.00 72.10           O  
ATOM  10978  N   ALA L  93      87.308  33.687  32.914  1.00 64.80           N  
ATOM  10979  CA  ALA L  93      87.193  32.438  32.159  1.00 63.70           C  
ATOM  10980  C   ALA L  93      86.433  31.338  32.899  1.00 62.43           C  
ATOM  10981  O   ALA L  93      85.922  30.398  32.283  1.00 61.86           O  
ATOM  10982  CB  ALA L  93      88.582  31.937  31.770  1.00 62.76           C  
ATOM  10983  N   GLU L  94      86.360  31.462  34.220  1.00 61.86           N  
ATOM  10984  CA  GLU L  94      85.675  30.478  35.050  1.00 59.61           C  
ATOM  10985  C   GLU L  94      84.160  30.661  35.005  1.00 56.32           C  
ATOM  10986  O   GLU L  94      83.398  29.693  35.072  1.00 54.68           O  
ATOM  10987  CB  GLU L  94      86.172  30.588  36.494  1.00 63.38           C  
ATOM  10988  CG  GLU L  94      87.700  30.566  36.637  1.00 67.20           C  
ATOM  10989  CD  GLU L  94      88.161  30.510  38.093  1.00 70.63           C  
ATOM  10990  OE1 GLU L  94      89.377  30.685  38.340  1.00 71.83           O  
ATOM  10991  OE2 GLU L  94      87.309  30.285  38.989  1.00 71.46           O  
ATOM  10992  N   TYR L  95      83.729  31.907  34.879  1.00 53.01           N  
ATOM  10993  CA  TYR L  95      82.310  32.208  34.829  1.00 51.30           C  
ATOM  10994  C   TYR L  95      81.779  32.312  33.401  1.00 50.29           C  
ATOM  10995  O   TYR L  95      80.622  31.985  33.130  1.00 48.93           O  
ATOM  10996  CB  TYR L  95      82.032  33.507  35.591  1.00 50.96           C  
ATOM  10997  CG  TYR L  95      82.330  33.415  37.072  1.00 50.96           C  
ATOM  10998  CD1 TYR L  95      83.635  33.304  37.533  1.00 51.90           C  
ATOM  10999  CD2 TYR L  95      81.298  33.410  38.012  1.00 51.44           C  
ATOM  11000  CE1 TYR L  95      83.912  33.188  38.890  1.00 53.46           C  
ATOM  11001  CE2 TYR L  95      81.561  33.297  39.376  1.00 52.21           C  
ATOM  11002  CZ  TYR L  95      82.873  33.184  39.809  1.00 53.50           C  
ATOM  11003  OH  TYR L  95      83.153  33.063  41.153  1.00 51.63           O  
ATOM  11004  N   PHE L  96      82.629  32.742  32.479  1.00 49.33           N  
ATOM  11005  CA  PHE L  96      82.192  32.900  31.104  1.00 50.30           C  
ATOM  11006  C   PHE L  96      82.833  31.936  30.111  1.00 51.10           C  
ATOM  11007  O   PHE L  96      82.884  32.202  28.909  1.00 50.39           O  
ATOM  11008  CB  PHE L  96      82.432  34.345  30.676  1.00 49.39           C  
ATOM  11009  CG  PHE L  96      81.803  35.352  31.595  1.00 47.69           C  
ATOM  11010  CD1 PHE L  96      80.493  35.187  32.032  1.00 46.34           C  
ATOM  11011  CD2 PHE L  96      82.512  36.470  32.014  1.00 46.95           C  
ATOM  11012  CE1 PHE L  96      79.902  36.114  32.872  1.00 45.44           C  
ATOM  11013  CE2 PHE L  96      81.928  37.402  32.854  1.00 45.70           C  
ATOM  11014  CZ  PHE L  96      80.620  37.225  33.284  1.00 45.34           C  
ATOM  11015  N   GLY L  97      83.301  30.802  30.617  1.00 52.15           N  
ATOM  11016  CA  GLY L  97      83.936  29.820  29.760  1.00 52.94           C  
ATOM  11017  C   GLY L  97      83.110  29.408  28.557  1.00 52.79           C  
ATOM  11018  O   GLY L  97      83.444  29.751  27.431  1.00 54.10           O  
ATOM  11019  N   GLU L  98      82.029  28.675  28.792  1.00 53.07           N  
ATOM  11020  CA  GLU L  98      81.174  28.204  27.710  1.00 52.38           C  
ATOM  11021  C   GLU L  98      80.138  29.229  27.267  1.00 52.30           C  
ATOM  11022  O   GLU L  98      79.310  28.944  26.403  1.00 52.45           O  
ATOM  11023  CB  GLU L  98      80.476  26.912  28.128  1.00 54.12           C  
ATOM  11024  N   SER L  99      80.178  30.419  27.862  1.00 51.70           N  
ATOM  11025  CA  SER L  99      79.232  31.473  27.507  1.00 49.64           C  
ATOM  11026  C   SER L  99      79.808  32.395  26.426  1.00 48.25           C  
ATOM  11027  O   SER L  99      79.144  32.691  25.421  1.00 45.53           O  
ATOM  11028  CB  SER L  99      78.879  32.295  28.747  1.00 51.01           C  
ATOM  11029  OG  SER L  99      77.905  33.284  28.446  1.00 52.24           O  
ATOM  11030  N   LYS L 100      81.048  32.836  26.651  1.00 45.80           N  
ATOM  11031  CA  LYS L 100      81.756  33.734  25.744  1.00 44.60           C  
ATOM  11032  C   LYS L 100      80.862  34.845  25.204  1.00 41.79           C  
ATOM  11033  O   LYS L 100      80.551  34.881  24.019  1.00 40.45           O  
ATOM  11034  CB  LYS L 100      82.367  32.941  24.590  1.00 47.38           C  
ATOM  11035  CG  LYS L 100      83.556  32.088  25.019  1.00 53.35           C  
ATOM  11036  CD  LYS L 100      84.294  31.474  23.832  1.00 56.76           C  
ATOM  11037  CE  LYS L 100      85.577  30.783  24.283  1.00 57.68           C  
ATOM  11038  NZ  LYS L 100      86.412  30.301  23.138  1.00 60.67           N  
ATOM  11039  N   PRO L 101      80.443  35.776  26.076  1.00 40.32           N  
ATOM  11040  CA  PRO L 101      79.576  36.879  25.651  1.00 38.62           C  
ATOM  11041  C   PRO L 101      80.343  38.014  24.996  1.00 35.96           C  
ATOM  11042  O   PRO L 101      81.577  38.031  24.985  1.00 33.57           O  
ATOM  11043  CB  PRO L 101      78.916  37.346  26.958  1.00 39.68           C  
ATOM  11044  CG  PRO L 101      79.214  36.238  27.956  1.00 40.87           C  
ATOM  11045  CD  PRO L 101      80.580  35.774  27.541  1.00 40.28           C  
ATOM  11046  N   ALA L 102      79.588  38.957  24.450  1.00 33.71           N  
ATOM  11047  CA  ALA L 102      80.166  40.122  23.826  1.00 31.83           C  
ATOM  11048  C   ALA L 102      80.731  40.897  24.996  1.00 32.72           C  
ATOM  11049  O   ALA L 102      80.081  41.018  26.033  1.00 29.85           O  
ATOM  11050  CB  ALA L 102      79.097  40.924  23.135  1.00 30.13           C  
ATOM  11051  N   ARG L 103      81.946  41.407  24.835  1.00 34.10           N  
ATOM  11052  CA  ARG L 103      82.583  42.149  25.902  1.00 36.74           C  
ATOM  11053  C   ARG L 103      82.953  43.569  25.507  1.00 36.12           C  
ATOM  11054  O   ARG L 103      83.226  43.867  24.343  1.00 37.11           O  
ATOM  11055  CB  ARG L 103      83.847  41.418  26.376  1.00 39.68           C  
ATOM  11056  CG  ARG L 103      84.476  42.009  27.636  1.00 42.82           C  
ATOM  11057  CD  ARG L 103      85.881  41.477  27.888  1.00 46.57           C  
ATOM  11058  NE  ARG L 103      86.757  41.706  26.741  1.00 52.57           N  
ATOM  11059  CZ  ARG L 103      88.084  41.623  26.780  1.00 55.61           C  
ATOM  11060  NH1 ARG L 103      88.799  41.843  25.682  1.00 55.60           N  
ATOM  11061  NH2 ARG L 103      88.699  41.334  27.920  1.00 56.83           N  
ATOM  11062  N   VAL L 104      82.940  44.440  26.504  1.00 34.96           N  
ATOM  11063  CA  VAL L 104      83.306  45.831  26.347  1.00 33.41           C  
ATOM  11064  C   VAL L 104      84.070  46.155  27.621  1.00 35.11           C  
ATOM  11065  O   VAL L 104      83.626  45.814  28.727  1.00 33.16           O  
ATOM  11066  CB  VAL L 104      82.080  46.742  26.243  1.00 32.31           C  
ATOM  11067  CG1 VAL L 104      82.530  48.177  26.098  1.00 31.14           C  
ATOM  11068  CG2 VAL L 104      81.227  46.335  25.049  1.00 32.16           C  
ATOM  11069  N   ALA L 105      85.227  46.794  27.465  1.00 37.63           N  
ATOM  11070  CA  ALA L 105      86.063  47.150  28.610  1.00 38.46           C  
ATOM  11071  C   ALA L 105      86.767  48.503  28.471  1.00 39.26           C  
ATOM  11072  O   ALA L 105      87.282  48.861  27.405  1.00 36.43           O  
ATOM  11073  CB  ALA L 105      87.094  46.046  28.867  1.00 36.32           C  
ATOM  11074  N   VAL L 106      86.769  49.245  29.575  1.00 40.31           N  
ATOM  11075  CA  VAL L 106      87.396  50.554  29.652  1.00 40.71           C  
ATOM  11076  C   VAL L 106      87.845  50.783  31.086  1.00 43.39           C  
ATOM  11077  O   VAL L 106      87.337  50.164  32.021  1.00 40.76           O  
ATOM  11078  CB  VAL L 106      86.426  51.692  29.273  1.00 38.71           C  
ATOM  11079  CG1 VAL L 106      85.809  51.422  27.928  1.00 40.92           C  
ATOM  11080  CG2 VAL L 106      85.350  51.843  30.327  1.00 38.85           C  
ATOM  11081  N   GLU L 107      88.815  51.672  31.249  1.00 48.30           N  
ATOM  11082  CA  GLU L 107      89.315  52.011  32.567  1.00 53.40           C  
ATOM  11083  C   GLU L 107      88.816  53.420  32.831  1.00 54.54           C  
ATOM  11084  O   GLU L 107      88.779  54.255  31.927  1.00 54.20           O  
ATOM  11085  CB  GLU L 107      90.839  51.951  32.587  1.00 56.58           C  
ATOM  11086  CG  GLU L 107      91.380  50.656  31.991  1.00 62.08           C  
ATOM  11087  CD  GLU L 107      92.863  50.454  32.249  1.00 65.50           C  
ATOM  11088  OE1 GLU L 107      93.456  49.572  31.589  1.00 67.59           O  
ATOM  11089  OE2 GLU L 107      93.433  51.162  33.112  1.00 66.79           O  
ATOM  11090  N   VAL L 108      88.401  53.676  34.062  1.00 56.31           N  
ATOM  11091  CA  VAL L 108      87.891  54.988  34.404  1.00 58.33           C  
ATOM  11092  C   VAL L 108      88.637  55.559  35.596  1.00 60.46           C  
ATOM  11093  O   VAL L 108      89.392  54.853  36.263  1.00 60.24           O  
ATOM  11094  CB  VAL L 108      86.384  54.916  34.700  1.00 57.81           C  
ATOM  11095  CG1 VAL L 108      85.637  54.504  33.441  1.00 56.83           C  
ATOM  11096  CG2 VAL L 108      86.117  53.926  35.820  1.00 55.57           C  
ATOM  11097  N   SER L 109      88.422  56.847  35.848  1.00 63.04           N  
ATOM  11098  CA  SER L 109      89.074  57.556  36.944  1.00 65.31           C  
ATOM  11099  C   SER L 109      88.777  56.968  38.320  1.00 66.35           C  
ATOM  11100  O   SER L 109      89.697  56.604  39.059  1.00 66.33           O  
ATOM  11101  CB  SER L 109      88.658  59.025  36.914  1.00 66.31           C  
ATOM  11102  OG  SER L 109      87.247  59.143  36.924  1.00 67.49           O  
ATOM  11103  N   ARG L 110      87.494  56.887  38.664  1.00 67.16           N  
ATOM  11104  CA  ARG L 110      87.078  56.337  39.950  1.00 67.25           C  
ATOM  11105  C   ARG L 110      85.763  55.583  39.819  1.00 66.63           C  
ATOM  11106  O   ARG L 110      84.940  55.879  38.949  1.00 65.65           O  
ATOM  11107  CB  ARG L 110      86.916  57.458  40.992  1.00 69.91           C  
ATOM  11108  CG  ARG L 110      85.622  58.291  40.874  1.00 71.11           C  
ATOM  11109  CD  ARG L 110      84.451  57.689  41.665  1.00 72.97           C  
ATOM  11110  NE  ARG L 110      83.189  58.386  41.405  1.00 73.74           N  
ATOM  11111  CZ  ARG L 110      82.057  58.182  42.079  1.00 74.39           C  
ATOM  11112  NH1 ARG L 110      82.012  57.299  43.069  1.00 74.18           N  
ATOM  11113  NH2 ARG L 110      80.962  58.863  41.759  1.00 74.31           N  
ATOM  11114  N   LEU L 111      85.573  54.606  40.695  1.00 66.31           N  
ATOM  11115  CA  LEU L 111      84.350  53.819  40.699  1.00 66.11           C  
ATOM  11116  C   LEU L 111      83.619  54.031  42.019  1.00 65.32           C  
ATOM  11117  O   LEU L 111      84.203  54.518  42.988  1.00 64.89           O  
ATOM  11118  CB  LEU L 111      84.676  52.337  40.503  1.00 65.66           C  
ATOM  11119  CG  LEU L 111      85.092  51.969  39.077  1.00 65.72           C  
ATOM  11120  CD1 LEU L 111      85.553  50.522  39.022  1.00 64.64           C  
ATOM  11121  CD2 LEU L 111      83.915  52.204  38.136  1.00 64.41           C  
ATOM  11122  N   PRO L 112      82.320  53.694  42.067  1.00 64.71           N  
ATOM  11123  CA  PRO L 112      81.561  53.870  43.307  1.00 64.21           C  
ATOM  11124  C   PRO L 112      82.319  53.295  44.500  1.00 63.67           C  
ATOM  11125  O   PRO L 112      82.643  52.107  44.525  1.00 62.45           O  
ATOM  11126  CB  PRO L 112      80.260  53.136  43.008  1.00 64.87           C  
ATOM  11127  CG  PRO L 112      80.050  53.466  41.547  1.00 64.77           C  
ATOM  11128  CD  PRO L 112      81.440  53.259  40.965  1.00 64.40           C  
ATOM  11129  N   LYS L 113      82.609  54.160  45.473  1.00 63.58           N  
ATOM  11130  CA  LYS L 113      83.348  53.791  46.681  1.00 62.92           C  
ATOM  11131  C   LYS L 113      84.808  53.493  46.350  1.00 62.51           C  
ATOM  11132  O   LYS L 113      85.465  52.715  47.041  1.00 62.75           O  
ATOM  11133  CB  LYS L 113      82.704  52.580  47.354  1.00 63.32           C  
ATOM  11134  N   ASP L 114      85.303  54.121  45.288  1.00 61.76           N  
ATOM  11135  CA  ASP L 114      86.680  53.935  44.839  1.00 61.71           C  
ATOM  11136  C   ASP L 114      87.103  52.467  44.830  1.00 60.56           C  
ATOM  11137  O   ASP L 114      88.150  52.111  45.371  1.00 61.50           O  
ATOM  11138  CB  ASP L 114      87.651  54.752  45.712  1.00 63.09           C  
ATOM  11139  CG  ASP L 114      87.554  56.259  45.455  1.00 65.06           C  
ATOM  11140  OD1 ASP L 114      86.610  56.906  45.965  1.00 64.68           O  
ATOM  11141  OD2 ASP L 114      88.423  56.796  44.728  1.00 65.34           O  
ATOM  11142  N   VAL L 115      86.283  51.620  44.214  1.00 58.55           N  
ATOM  11143  CA  VAL L 115      86.570  50.187  44.120  1.00 55.60           C  
ATOM  11144  C   VAL L 115      87.481  49.941  42.917  1.00 53.06           C  
ATOM  11145  O   VAL L 115      87.725  50.852  42.129  1.00 52.51           O  
ATOM  11146  CB  VAL L 115      85.266  49.366  43.957  1.00 55.87           C  
ATOM  11147  CG1 VAL L 115      84.352  49.610  45.145  1.00 55.74           C  
ATOM  11148  CG2 VAL L 115      84.556  49.755  42.669  1.00 57.00           C  
ATOM  11149  N   LEU L 116      87.977  48.717  42.767  1.00 49.79           N  
ATOM  11150  CA  LEU L 116      88.871  48.416  41.651  1.00 48.67           C  
ATOM  11151  C   LEU L 116      88.165  47.999  40.374  1.00 47.97           C  
ATOM  11152  O   LEU L 116      88.718  48.138  39.281  1.00 47.75           O  
ATOM  11153  CB  LEU L 116      89.860  47.312  42.030  1.00 48.05           C  
ATOM  11154  CG  LEU L 116      90.799  47.567  43.208  1.00 49.49           C  
ATOM  11155  CD1 LEU L 116      91.745  46.380  43.348  1.00 49.47           C  
ATOM  11156  CD2 LEU L 116      91.575  48.864  42.992  1.00 48.18           C  
ATOM  11157  N   ILE L 117      86.946  47.490  40.500  1.00 46.54           N  
ATOM  11158  CA  ILE L 117      86.227  47.030  39.325  1.00 44.35           C  
ATOM  11159  C   ILE L 117      84.712  47.000  39.489  1.00 43.98           C  
ATOM  11160  O   ILE L 117      84.193  46.746  40.582  1.00 43.70           O  
ATOM  11161  CB  ILE L 117      86.715  45.625  38.946  1.00 43.62           C  
ATOM  11162  CG1 ILE L 117      85.962  45.111  37.722  1.00 42.13           C  
ATOM  11163  CG2 ILE L 117      86.553  44.694  40.142  1.00 43.79           C  
ATOM  11164  CD1 ILE L 117      86.370  43.718  37.305  1.00 41.31           C  
ATOM  11165  N   GLU L 118      84.015  47.276  38.388  1.00 42.02           N  
ATOM  11166  CA  GLU L 118      82.560  47.265  38.359  1.00 40.55           C  
ATOM  11167  C   GLU L 118      82.151  46.551  37.080  1.00 38.26           C  
ATOM  11168  O   GLU L 118      82.669  46.849  36.003  1.00 36.98           O  
ATOM  11169  CB  GLU L 118      81.989  48.686  38.351  1.00 42.75           C  
ATOM  11170  CG  GLU L 118      80.522  48.739  38.802  1.00 48.38           C  
ATOM  11171  CD  GLU L 118      79.854  50.084  38.553  1.00 50.93           C  
ATOM  11172  OE1 GLU L 118      80.511  51.131  38.741  1.00 53.87           O  
ATOM  11173  OE2 GLU L 118      78.661  50.096  38.178  1.00 51.13           O  
ATOM  11174  N   ILE L 119      81.225  45.610  37.196  1.00 35.76           N  
ATOM  11175  CA  ILE L 119      80.781  44.872  36.029  1.00 33.58           C  
ATOM  11176  C   ILE L 119      79.280  44.984  35.767  1.00 32.99           C  
ATOM  11177  O   ILE L 119      78.458  44.823  36.665  1.00 31.90           O  
ATOM  11178  CB  ILE L 119      81.199  43.397  36.142  1.00 33.13           C  
ATOM  11179  CG1 ILE L 119      82.728  43.302  36.133  1.00 33.85           C  
ATOM  11180  CG2 ILE L 119      80.627  42.600  34.989  1.00 35.12           C  
ATOM  11181  CD1 ILE L 119      83.270  41.891  36.203  1.00 32.36           C  
ATOM  11182  N   GLU L 120      78.948  45.273  34.514  1.00 33.05           N  
ATOM  11183  CA  GLU L 120      77.568  45.420  34.045  1.00 34.41           C  
ATOM  11184  C   GLU L 120      77.264  44.237  33.098  1.00 31.67           C  
ATOM  11185  O   GLU L 120      78.144  43.791  32.363  1.00 33.73           O  
ATOM  11186  CB  GLU L 120      77.460  46.771  33.313  1.00 36.38           C  
ATOM  11187  CG  GLU L 120      76.174  47.068  32.558  1.00 42.69           C  
ATOM  11188  CD  GLU L 120      76.318  48.292  31.628  1.00 48.25           C  
ATOM  11189  OE1 GLU L 120      75.480  48.450  30.705  1.00 50.75           O  
ATOM  11190  OE2 GLU L 120      77.268  49.094  31.820  1.00 48.60           O  
ATOM  11191  N   ALA L 121      76.040  43.717  33.109  1.00 28.93           N  
ATOM  11192  CA  ALA L 121      75.721  42.592  32.227  1.00 25.54           C  
ATOM  11193  C   ALA L 121      74.283  42.492  31.749  1.00 26.63           C  
ATOM  11194  O   ALA L 121      73.337  42.956  32.410  1.00 24.37           O  
ATOM  11195  CB  ALA L 121      76.109  41.288  32.893  1.00 22.76           C  
ATOM  11196  N   ILE L 122      74.149  41.861  30.585  1.00 27.28           N  
ATOM  11197  CA  ILE L 122      72.872  41.603  29.928  1.00 27.69           C  
ATOM  11198  C   ILE L 122      72.793  40.099  29.624  1.00 28.02           C  
ATOM  11199  O   ILE L 122      73.753  39.507  29.135  1.00 27.36           O  
ATOM  11200  CB  ILE L 122      72.749  42.403  28.596  1.00 28.80           C  
ATOM  11201  CG1 ILE L 122      72.683  43.906  28.892  1.00 29.73           C  
ATOM  11202  CG2 ILE L 122      71.495  41.965  27.815  1.00 28.11           C  
ATOM  11203  CD1 ILE L 122      72.521  44.781  27.650  1.00 28.74           C  
ATOM  11204  N   ALA L 123      71.644  39.493  29.926  1.00 29.15           N  
ATOM  11205  CA  ALA L 123      71.415  38.067  29.695  1.00 27.93           C  
ATOM  11206  C   ALA L 123      70.152  37.822  28.872  1.00 29.66           C  
ATOM  11207  O   ALA L 123      69.249  38.664  28.824  1.00 27.76           O  
ATOM  11208  CB  ALA L 123      71.316  37.337  31.017  1.00 25.94           C  
ATOM  11209  N   TYR L 124      70.099  36.657  28.230  1.00 31.94           N  
ATOM  11210  CA  TYR L 124      68.972  36.280  27.386  1.00 34.58           C  
ATOM  11211  C   TYR L 124      68.630  34.823  27.632  1.00 38.63           C  
ATOM  11212  O   TYR L 124      69.495  33.948  27.556  1.00 38.53           O  
ATOM  11213  CB  TYR L 124      69.334  36.468  25.917  1.00 34.54           C  
ATOM  11214  CG  TYR L 124      68.225  36.141  24.948  1.00 35.28           C  
ATOM  11215  CD1 TYR L 124      67.187  37.037  24.721  1.00 36.09           C  
ATOM  11216  CD2 TYR L 124      68.209  34.925  24.260  1.00 36.38           C  
ATOM  11217  CE1 TYR L 124      66.149  36.737  23.832  1.00 38.04           C  
ATOM  11218  CE2 TYR L 124      67.175  34.612  23.365  1.00 36.99           C  
ATOM  11219  CZ  TYR L 124      66.149  35.523  23.154  1.00 38.18           C  
ATOM  11220  OH  TYR L 124      65.132  35.235  22.263  1.00 38.38           O  
ATOM  11221  N   LYS L 125      67.363  34.564  27.923  1.00 43.00           N  
ATOM  11222  CA  LYS L 125      66.909  33.209  28.185  1.00 47.60           C  
ATOM  11223  C   LYS L 125      66.045  32.767  27.021  1.00 51.07           C  
ATOM  11224  O   LYS L 125      65.166  33.506  26.573  1.00 50.43           O  
ATOM  11225  CB  LYS L 125      66.105  33.161  29.486  1.00 48.75           C  
ATOM  11226  CG  LYS L 125      66.146  31.818  30.177  1.00 51.14           C  
ATOM  11227  CD  LYS L 125      65.330  31.817  31.461  1.00 54.82           C  
ATOM  11228  CE  LYS L 125      65.317  30.428  32.093  1.00 56.14           C  
ATOM  11229  NZ  LYS L 125      64.493  30.375  33.336  1.00 59.14           N  
ATOM  11230  N   GLU L 126      66.300  31.557  26.538  1.00 55.61           N  
ATOM  11231  CA  GLU L 126      65.559  31.000  25.411  1.00 59.36           C  
ATOM  11232  C   GLU L 126      64.077  30.818  25.729  1.00 60.22           C  
ATOM  11233  O   GLU L 126      63.697  30.879  26.921  1.00 61.54           O  
ATOM  11234  CB  GLU L 126      66.164  29.650  25.000  1.00 61.69           C  
ATOM  11235  CG  GLU L 126      67.680  29.676  24.753  1.00 64.69           C  
ATOM  11236  CD  GLU L 126      68.497  29.803  26.039  1.00 65.59           C  
ATOM  11237  OE1 GLU L 126      68.489  28.853  26.856  1.00 63.84           O  
ATOM  11238  OE2 GLU L 126      69.143  30.860  26.227  1.00 66.35           O  
ATOM  11239  OXT GLU L 126      63.308  30.600  24.771  1.00 61.17           O  
TER   11240      GLU L 126                                                      
END
MOLECULE T0423.pdb
ATOM  12910  N   MET     1      70.981  21.031  37.362  1.00 36.76           N  
ATOM  12911  CA  MET     1      71.905  21.930  36.664  1.00 38.87           C  
ATOM  12912  C   MET     1      72.311  23.119  37.519  1.00 35.58           C  
ATOM  12913  O   MET     1      73.455  23.538  37.475  1.00 34.69           O  
ATOM  12914  CB  MET     1      71.283  22.461  35.383  1.00 39.21           C  
ATOM  12915  CG  MET     1      71.504  21.613  34.171  1.00 44.40           C  
ATOM  12916  SD  MET     1      70.806  22.501  32.558  1.00 57.84          SE  
ATOM  12917  CE  MET     1      71.792  24.214  32.666  1.00 53.65           C  
ATOM  12918  N   SER     2      71.368  23.671  38.275  1.00 34.19           N  
ATOM  12919  CA  SER     2      71.660  24.824  39.146  1.00 33.25           C  
ATOM  12920  C   SER     2      72.590  24.410  40.267  1.00 32.21           C  
ATOM  12921  O   SER     2      73.492  25.167  40.644  1.00 30.89           O  
ATOM  12922  CB  SER     2      70.389  25.426  39.738  1.00 32.90           C  
ATOM  12923  OG  SER     2      69.633  26.060  38.749  1.00 33.07           O  
ATOM  12924  N   ASP     3      72.374  23.203  40.811  1.00 30.62           N  
ATOM  12925  CA  ASP     3      73.242  22.687  41.862  1.00 30.33           C  
ATOM  12926  C   ASP     3      74.682  22.556  41.347  1.00 28.94           C  
ATOM  12927  O   ASP     3      75.638  22.825  42.091  1.00 29.92           O  
ATOM  12928  CB  ASP     3      72.774  21.291  42.370  1.00 30.67           C  
ATOM  12929  CG  ASP     3      71.492  21.328  43.198  1.00 32.38           C  
ATOM  12930  OD1 ASP     3      71.019  22.402  43.615  1.00 35.40           O  
ATOM  12931  OD2 ASP     3      70.942  20.230  43.448  1.00 35.26           O  
ATOM  12932  N   VAL     4      74.823  22.096  40.101  1.00 27.71           N  
ATOM  12933  CA  VAL     4      76.127  21.864  39.482  1.00 27.34           C  
ATOM  12934  C   VAL     4      76.846  23.203  39.304  1.00 26.70           C  
ATOM  12935  O   VAL     4      78.035  23.311  39.582  1.00 25.89           O  
ATOM  12936  CB  VAL     4      75.994  21.175  38.115  1.00 27.32           C  
ATOM  12937  CG1 VAL     4      77.261  21.282  37.304  1.00 28.31           C  
ATOM  12938  CG2 VAL     4      75.606  19.678  38.300  1.00 27.74           C  
ATOM  12939  N   ILE     5      76.114  24.200  38.836  1.00 26.35           N  
ATOM  12940  CA  ILE     5      76.694  25.575  38.675  1.00 26.66           C  
ATOM  12941  C   ILE     5      77.167  26.134  40.031  1.00 26.86           C  
ATOM  12942  O   ILE     5      78.302  26.546  40.179  1.00 27.38           O  
ATOM  12943  CB  ILE     5      75.680  26.562  37.999  1.00 26.48           C  
ATOM  12944  CG1 ILE     5      75.346  26.128  36.566  1.00 24.54           C  
ATOM  12945  CG2 ILE     5      76.257  28.001  37.934  1.00 26.07           C  
ATOM  12946  CD1 ILE     5      74.048  26.748  35.988  1.00 26.63           C  
ATOM  12947  N   GLU     6      76.308  26.117  41.034  1.00 27.87           N  
ATOM  12948  CA  GLU     6      76.688  26.606  42.353  1.00 28.66           C  
ATOM  12949  C   GLU     6      77.785  25.768  43.000  1.00 28.15           C  
ATOM  12950  O   GLU     6      78.644  26.303  43.709  1.00 27.19           O  
ATOM  12951  CB  GLU     6      75.481  26.702  43.272  1.00 29.19           C  
ATOM  12952  CG  GLU     6      74.484  27.740  42.832  1.00 31.30           C  
ATOM  12953  CD  GLU     6      73.485  28.113  43.911  1.00 31.61           C  
ATOM  12954  OE1 GLU     6      73.885  28.327  45.083  1.00 38.52           O  
ATOM  12955  OE2 GLU     6      72.296  28.217  43.572  1.00 35.07           O  
ATOM  12956  N   GLY     7      77.769  24.454  42.764  1.00 27.55           N  
ATOM  12957  CA  GLY     7      78.825  23.599  43.252  1.00 27.47           C  
ATOM  12958  C   GLY     7      80.172  23.924  42.647  1.00 27.46           C  
ATOM  12959  O   GLY     7      81.190  23.916  43.348  1.00 28.04           O  
ATOM  12960  N   ARG     8      80.193  24.198  41.351  1.00 27.39           N  
ATOM  12961  CA  ARG     8      81.428  24.591  40.683  1.00 28.18           C  
ATOM  12962  C   ARG     8      81.977  25.901  41.263  1.00 27.87           C  
ATOM  12963  O   ARG     8      83.187  26.055  41.439  1.00 28.10           O  
ATOM  12964  CB  ARG     8      81.219  24.776  39.185  1.00 27.91           C  
ATOM  12965  CG  ARG     8      81.010  23.509  38.405  1.00 28.72           C  
ATOM  12966  CD  ARG     8      80.440  23.881  37.071  1.00 31.46           C  
ATOM  12967  NE  ARG     8      80.192  22.738  36.217  1.00 33.09           N  
ATOM  12968  CZ  ARG     8      79.413  22.752  35.140  1.00 35.77           C  
ATOM  12969  NH1 ARG     8      78.767  23.854  34.762  1.00 36.28           N  
ATOM  12970  NH2 ARG     8      79.267  21.629  34.439  1.00 38.50           N  
ATOM  12971  N   LEU     9      81.077  26.830  41.554  1.00 28.09           N  
ATOM  12972  CA  LEU     9      81.479  28.113  42.139  1.00 28.34           C  
ATOM  12973  C   LEU     9      82.103  27.873  43.539  1.00 28.63           C  
ATOM  12974  O   LEU     9      83.145  28.457  43.874  1.00 27.85           O  
ATOM  12975  CB  LEU     9      80.271  29.044  42.209  1.00 28.43           C  
ATOM  12976  CG  LEU     9      80.543  30.479  42.669  1.00 28.95           C  
ATOM  12977  CD1 LEU     9      81.644  31.110  41.771  1.00 29.20           C  
ATOM  12978  CD2 LEU     9      79.251  31.302  42.651  1.00 29.10           C  
ATOM  12979  N   LYS    10      81.487  26.998  44.343  1.00 28.27           N  
ATOM  12980  CA  LYS    10      82.090  26.586  45.618  1.00 29.09           C  
ATOM  12981  C   LYS    10      83.477  25.946  45.467  1.00 29.33           C  
ATOM  12982  O   LYS    10      84.380  26.178  46.296  1.00 30.06           O  
ATOM  12983  CB  LYS    10      81.155  25.648  46.379  1.00 29.06           C  
ATOM  12984  CG  LYS    10      79.869  26.277  46.842  1.00 29.74           C  
ATOM  12985  CD  LYS    10      79.055  25.300  47.652  1.00 30.41           C  
ATOM  12986  CE  LYS    10      77.739  25.887  48.034  1.00 30.84           C  
ATOM  12987  NZ  LYS    10      76.878  24.856  48.677  1.00 32.89           N  
ATOM  12988  N   GLU    11      83.673  25.166  44.413  1.00 29.53           N  
ATOM  12989  CA  GLU    11      84.977  24.594  44.114  1.00 30.47           C  
ATOM  12990  C   GLU    11      86.011  25.667  43.795  1.00 30.79           C  
ATOM  12991  O   GLU    11      87.190  25.452  44.020  1.00 32.10           O  
ATOM  12992  CB  GLU    11      84.889  23.624  42.946  1.00 30.41           C  
ATOM  12993  CG  GLU    11      84.195  22.304  43.287  1.00 31.53           C  
ATOM  12994  CD  GLU    11      83.980  21.440  42.072  1.00 33.05           C  
ATOM  12995  OE1 GLU    11      83.483  21.935  41.044  1.00 37.69           O  
ATOM  12996  OE2 GLU    11      84.275  20.239  42.144  1.00 40.32           O  
ATOM  12997  N   LEU    12      85.573  26.810  43.266  1.00 30.96           N  
ATOM  12998  CA  LEU    12      86.458  27.982  43.080  1.00 30.36           C  
ATOM  12999  C   LEU    12      86.672  28.813  44.349  1.00 30.69           C  
ATOM  13000  O   LEU    12      87.510  29.730  44.358  1.00 31.30           O  
ATOM  13001  CB  LEU    12      85.912  28.883  41.982  1.00 29.65           C  
ATOM  13002  CG  LEU    12      85.889  28.253  40.603  1.00 29.14           C  
ATOM  13003  CD1 LEU    12      85.193  29.190  39.650  1.00 28.44           C  
ATOM  13004  CD2 LEU    12      87.318  27.916  40.123  1.00 30.62           C  
ATOM  13005  N   GLY    13      85.906  28.530  45.398  1.00 30.88           N  
ATOM  13006  CA  GLY    13      86.097  29.154  46.694  1.00 30.87           C  
ATOM  13007  C   GLY    13      85.047  30.177  47.062  1.00 30.89           C  
ATOM  13008  O   GLY    13      85.157  30.816  48.099  1.00 31.94           O  
ATOM  13009  N   PHE    14      84.004  30.303  46.254  1.00 30.40           N  
ATOM  13010  CA  PHE    14      82.959  31.278  46.509  1.00 30.42           C  
ATOM  13011  C   PHE    14      81.595  30.647  46.801  1.00 31.05           C  
ATOM  13012  O   PHE    14      81.170  29.691  46.147  1.00 30.75           O  
ATOM  13013  CB  PHE    14      82.829  32.227  45.312  1.00 29.97           C  
ATOM  13014  CG  PHE    14      84.106  32.886  44.930  1.00 28.80           C  
ATOM  13015  CD1 PHE    14      84.494  34.057  45.537  1.00 29.32           C  
ATOM  13016  CD2 PHE    14      84.924  32.336  43.954  1.00 28.91           C  
ATOM  13017  CE1 PHE    14      85.688  34.670  45.177  1.00 27.83           C  
ATOM  13018  CE2 PHE    14      86.114  32.938  43.594  1.00 28.84           C  
ATOM  13019  CZ  PHE    14      86.494  34.108  44.214  1.00 28.76           C  
ATOM  13020  N   THR    15      80.906  31.228  47.769  1.00 31.89           N  
ATOM  13021  CA  THR    15      79.480  31.011  47.934  1.00 33.07           C  
ATOM  13022  C   THR    15      78.738  32.270  47.471  1.00 33.07           C  
ATOM  13023  O   THR    15      79.306  33.390  47.471  1.00 32.98           O  
ATOM  13024  CB  THR    15      79.142  30.676  49.406  1.00 33.77           C  
ATOM  13025  OG1 THR    15      79.407  31.816  50.239  1.00 37.27           O  
ATOM  13026  CG2 THR    15      79.988  29.500  49.902  1.00 32.51           C  
ATOM  13027  N   LEU    16      77.488  32.100  47.043  1.00 32.88           N  
ATOM  13028  CA  LEU    16      76.696  33.230  46.573  1.00 32.59           C  
ATOM  13029  C   LEU    16      76.163  34.007  47.767  1.00 33.08           C  
ATOM  13030  O   LEU    16      75.580  33.413  48.678  1.00 32.54           O  
ATOM  13031  CB  LEU    16      75.513  32.781  45.706  1.00 32.47           C  
ATOM  13032  CG  LEU    16      75.834  32.190  44.332  1.00 31.50           C  
ATOM  13033  CD1 LEU    16      74.534  31.595  43.670  1.00 29.77           C  
ATOM  13034  CD2 LEU    16      76.521  33.215  43.434  1.00 28.44           C  
ATOM  13035  N   PRO    17      76.338  35.334  47.771  1.00 33.26           N  
ATOM  13036  CA  PRO    17      75.694  36.103  48.823  1.00 33.95           C  
ATOM  13037  C   PRO    17      74.202  36.176  48.577  1.00 35.74           C  
ATOM  13038  O   PRO    17      73.743  35.890  47.461  1.00 35.40           O  
ATOM  13039  CB  PRO    17      76.304  37.492  48.650  1.00 33.84           C  
ATOM  13040  CG  PRO    17      76.630  37.570  47.219  1.00 33.42           C  
ATOM  13041  CD  PRO    17      77.081  36.198  46.835  1.00 32.52           C  
ATOM  13042  N   VAL    18      73.449  36.584  49.596  1.00 37.90           N  
ATOM  13043  CA  VAL    18      72.045  36.963  49.389  1.00 39.41           C  
ATOM  13044  C   VAL    18      71.995  38.269  48.568  1.00 40.41           C  
ATOM  13045  O   VAL    18      71.230  38.389  47.586  1.00 42.23           O  
ATOM  13046  CB  VAL    18      71.308  37.200  50.710  1.00 39.67           C  
ATOM  13047  CG1 VAL    18      71.505  36.006  51.656  1.00 40.20           C  
ATOM  13048  CG2 VAL    18      71.762  38.513  51.345  1.00 39.98           C  
ATOM  13049  N   ALA    23      66.158  48.786  48.809  1.00 42.30           N  
ATOM  13050  CA  ALA    23      64.939  49.472  48.343  1.00 41.72           C  
ATOM  13051  C   ALA    23      65.286  50.838  47.711  1.00 41.82           C  
ATOM  13052  O   ALA    23      65.606  51.804  48.439  1.00 42.33           O  
ATOM  13053  CB  ALA    23      63.942  49.647  49.513  1.00 42.49           C  
ATOM  13054  N   ALA    24      65.243  50.926  46.370  1.00 40.52           N  
ATOM  13055  CA  ALA    24      65.678  52.154  45.678  1.00 38.94           C  
ATOM  13056  C   ALA    24      64.979  52.405  44.337  1.00 37.86           C  
ATOM  13057  O   ALA    24      64.258  51.549  43.818  1.00 37.65           O  
ATOM  13058  CB  ALA    24      67.220  52.130  45.485  1.00 39.16           C  
ATOM  13059  N   ASN    25      65.207  53.597  43.784  1.00 35.84           N  
ATOM  13060  CA  ASN    25      64.676  53.977  42.458  1.00 34.71           C  
ATOM  13061  C   ASN    25      65.420  53.350  41.277  1.00 32.01           C  
ATOM  13062  O   ASN    25      64.955  53.404  40.128  1.00 30.65           O  
ATOM  13063  CB  ASN    25      64.628  55.506  42.327  1.00 34.31           C  
ATOM  13064  CG  ASN    25      63.556  56.116  43.221  1.00 34.82           C  
ATOM  13065  OD1 ASN    25      63.757  57.167  43.838  1.00 36.03           O  
ATOM  13066  ND2 ASN    25      62.419  55.419  43.327  1.00 31.59           N  
ATOM  13067  N   TYR    26      66.570  52.763  41.572  1.00 30.18           N  
ATOM  13068  CA  TYR    26      67.208  51.824  40.653  1.00 28.61           C  
ATOM  13069  C   TYR    26      67.192  50.433  41.287  1.00 26.27           C  
ATOM  13070  O   TYR    26      67.222  50.261  42.514  1.00 25.81           O  
ATOM  13071  CB  TYR    26      68.625  52.246  40.221  1.00 28.83           C  
ATOM  13072  CG  TYR    26      69.621  52.398  41.339  1.00 30.60           C  
ATOM  13073  CD1 TYR    26      70.670  51.493  41.495  1.00 30.95           C  
ATOM  13074  CD2 TYR    26      69.522  53.456  42.230  1.00 30.60           C  
ATOM  13075  CE1 TYR    26      71.582  51.635  42.510  1.00 30.87           C  
ATOM  13076  CE2 TYR    26      70.411  53.597  43.267  1.00 32.36           C  
ATOM  13077  CZ  TYR    26      71.447  52.689  43.404  1.00 32.75           C  
ATOM  13078  OH  TYR    26      72.352  52.852  44.448  1.00 34.31           O  
ATOM  13079  N   VAL    27      67.135  49.446  40.418  1.00 24.17           N  
ATOM  13080  CA  VAL    27      67.030  48.071  40.817  1.00 22.92           C  
ATOM  13081  C   VAL    27      68.271  47.271  40.393  1.00 22.47           C  
ATOM  13082  O   VAL    27      68.985  47.662  39.463  1.00 20.80           O  
ATOM  13083  CB  VAL    27      65.757  47.458  40.209  1.00 22.53           C  
ATOM  13084  CG1 VAL    27      64.536  48.064  40.881  1.00 24.05           C  
ATOM  13085  CG2 VAL    27      65.709  47.685  38.675  1.00 20.19           C  
ATOM  13086  N   PRO    28      68.514  46.135  41.065  1.00 22.19           N  
ATOM  13087  CA  PRO    28      69.643  45.282  40.693  1.00 22.05           C  
ATOM  13088  C   PRO    28      69.576  44.646  39.313  1.00 21.32           C  
ATOM  13089  O   PRO    28      70.620  44.298  38.758  1.00 19.41           O  
ATOM  13090  CB  PRO    28      69.645  44.208  41.765  1.00 23.32           C  
ATOM  13091  CG  PRO    28      68.744  44.705  42.839  1.00 24.78           C  
ATOM  13092  CD  PRO    28      67.767  45.580  42.209  1.00 22.87           C  
ATOM  13093  N   PHE    29      68.366  44.511  38.760  1.00 20.74           N  
ATOM  13094  CA  PHE    29      68.186  43.931  37.454  1.00 21.35           C  
ATOM  13095  C   PHE    29      66.815  44.278  36.885  1.00 20.78           C  
ATOM  13096  O   PHE    29      65.876  44.597  37.615  1.00 20.82           O  
ATOM  13097  CB  PHE    29      68.410  42.392  37.475  1.00 21.85           C  
ATOM  13098  CG  PHE    29      67.437  41.650  38.360  1.00 22.44           C  
ATOM  13099  CD1 PHE    29      66.175  41.334  37.907  1.00 24.23           C  
ATOM  13100  CD2 PHE    29      67.776  41.337  39.664  1.00 24.23           C  
ATOM  13101  CE1 PHE    29      65.265  40.664  38.746  1.00 23.72           C  
ATOM  13102  CE2 PHE    29      66.883  40.698  40.489  1.00 26.07           C  
ATOM  13103  CZ  PHE    29      65.623  40.381  40.031  1.00 24.55           C  
ATOM  13104  N   THR    30      66.753  44.281  35.568  1.00 21.11           N  
ATOM  13105  CA  THR    30      65.491  44.370  34.819  1.00 22.00           C  
ATOM  13106  C   THR    30      65.480  43.293  33.752  1.00 22.35           C  
ATOM  13107  O   THR    30      66.525  42.798  33.356  1.00 21.01           O  
ATOM  13108  CB  THR    30      65.298  45.735  34.132  1.00 22.63           C  
ATOM  13109  OG1 THR    30      66.405  46.020  33.266  1.00 22.53           O  
ATOM  13110  CG2 THR    30      65.139  46.846  35.164  1.00 21.28           C  
ATOM  13111  N   ILE    31      64.276  42.943  33.280  1.00 23.19           N  
ATOM  13112  CA  ILE    31      64.104  41.993  32.189  1.00 23.67           C  
ATOM  13113  C   ILE    31      63.288  42.634  31.087  1.00 23.56           C  
ATOM  13114  O   ILE    31      62.269  43.294  31.331  1.00 24.21           O  
ATOM  13115  CB  ILE    31      63.424  40.684  32.664  1.00 23.86           C  
ATOM  13116  CG1 ILE    31      64.303  39.977  33.687  1.00 23.74           C  
ATOM  13117  CG2 ILE    31      63.169  39.723  31.486  1.00 24.39           C  
ATOM  13118  CD1 ILE    31      63.577  38.878  34.465  1.00 25.28           C  
ATOM  13119  N   SER    32      63.757  42.461  29.874  1.00 24.00           N  
ATOM  13120  CA  SER    32      63.011  42.846  28.692  1.00 25.73           C  
ATOM  13121  C   SER    32      63.058  41.677  27.730  1.00 25.64           C  
ATOM  13122  O   SER    32      64.122  41.331  27.246  1.00 25.50           O  
ATOM  13123  CB  SER    32      63.598  44.073  28.021  1.00 25.81           C  
ATOM  13124  OG  SER    32      62.809  44.432  26.913  1.00 27.19           O  
ATOM  13125  N   GLY    33      61.903  41.083  27.430  1.00 26.33           N  
ATOM  13126  CA  GLY    33      61.899  39.878  26.629  1.00 26.22           C  
ATOM  13127  C   GLY    33      62.655  38.771  27.314  1.00 25.36           C  
ATOM  13128  O   GLY    33      62.370  38.424  28.457  1.00 26.34           O  
ATOM  13129  N   ASN    34      63.633  38.209  26.622  1.00 24.98           N  
ATOM  13130  CA  ASN    34      64.458  37.178  27.241  1.00 25.51           C  
ATOM  13131  C   ASN    34      65.858  37.705  27.552  1.00 24.78           C  
ATOM  13132  O   ASN    34      66.804  36.930  27.584  1.00 24.18           O  
ATOM  13133  CB  ASN    34      64.528  35.934  26.371  1.00 27.08           C  
ATOM  13134  CG  ASN    34      65.282  36.158  25.091  1.00 30.55           C  
ATOM  13135  OD1 ASN    34      65.607  37.305  24.738  1.00 35.31           O  
ATOM  13136  ND2 ASN    34      65.586  35.057  24.371  1.00 35.76           N  
ATOM  13137  N   LEU    35      65.983  39.022  27.699  1.00 24.55           N  
ATOM  13138  CA  LEU    35      67.277  39.637  28.078  1.00 24.12           C  
ATOM  13139  C   LEU    35      67.189  40.157  29.496  1.00 23.03           C  
ATOM  13140  O   LEU    35      66.268  40.868  29.847  1.00 23.05           O  
ATOM  13141  CB  LEU    35      67.702  40.736  27.096  1.00 24.76           C  
ATOM  13142  CG  LEU    35      68.282  40.199  25.764  1.00 26.16           C  
ATOM  13143  CD1 LEU    35      68.633  41.334  24.793  1.00 28.97           C  
ATOM  13144  CD2 LEU    35      69.489  39.249  25.947  1.00 28.49           C  
ATOM  13145  N   LEU    36      68.148  39.763  30.315  1.00 21.64           N  
ATOM  13146  CA  LEU    36      68.250  40.214  31.693  1.00 20.97           C  
ATOM  13147  C   LEU    36      69.421  41.199  31.776  1.00 20.61           C  
ATOM  13148  O   LEU    36      70.562  40.854  31.376  1.00 21.20           O  
ATOM  13149  CB  LEU    36      68.532  39.046  32.613  1.00 21.41           C  
ATOM  13150  CG  LEU    36      68.789  39.264  34.102  1.00 21.35           C  
ATOM  13151  CD1 LEU    36      67.603  39.957  34.807  1.00 23.14           C  
ATOM  13152  CD2 LEU    36      69.179  37.943  34.804  1.00 22.93           C  
ATOM  13153  N   TYR    37      69.112  42.393  32.255  1.00 19.52           N  
ATOM  13154  CA  TYR    37      70.093  43.483  32.452  1.00 19.94           C  
ATOM  13155  C   TYR    37      70.430  43.581  33.906  1.00 19.30           C  
ATOM  13156  O   TYR    37      69.576  43.954  34.684  1.00 18.49           O  
ATOM  13157  CB  TYR    37      69.527  44.816  32.021  1.00 21.62           C  
ATOM  13158  CG  TYR    37      69.633  45.044  30.561  1.00 24.97           C  
ATOM  13159  CD1 TYR    37      70.608  45.901  30.041  1.00 26.99           C  
ATOM  13160  CD2 TYR    37      68.798  44.384  29.690  1.00 26.43           C  
ATOM  13161  CE1 TYR    37      70.711  46.099  28.690  1.00 28.18           C  
ATOM  13162  CE2 TYR    37      68.902  44.583  28.309  1.00 27.61           C  
ATOM  13163  CZ  TYR    37      69.839  45.424  27.829  1.00 26.70           C  
ATOM  13164  OH  TYR    37      69.928  45.651  26.474  1.00 28.34           O  
ATOM  13165  N   VAL    38      71.680  43.277  34.255  1.00 18.12           N  
ATOM  13166  CA  VAL    38      72.116  43.284  35.635  1.00 17.38           C  
ATOM  13167  C   VAL    38      72.897  44.591  35.852  1.00 17.03           C  
ATOM  13168  O   VAL    38      73.783  44.948  35.040  1.00 16.35           O  
ATOM  13169  CB  VAL    38      72.994  42.065  35.962  1.00 17.22           C  
ATOM  13170  CG1 VAL    38      73.488  42.113  37.378  1.00 16.68           C  
ATOM  13171  CG2 VAL    38      72.228  40.778  35.704  1.00 19.02           C  
ATOM  13172  N   SER    39      72.542  45.277  36.935  1.00 16.21           N  
ATOM  13173  CA  SER    39      73.190  46.537  37.340  1.00 16.77           C  
ATOM  13174  C   SER    39      74.675  46.307  37.694  1.00 16.42           C  
ATOM  13175  O   SER    39      75.066  45.194  38.084  1.00 16.79           O  
ATOM  13176  CB  SER    39      72.491  47.130  38.559  1.00 16.39           C  
ATOM  13177  OG  SER    39      71.232  47.673  38.217  1.00 16.94           O  
ATOM  13178  N   GLY    40      75.498  47.355  37.547  1.00 16.71           N  
ATOM  13179  CA  GLY    40      76.913  47.251  37.877  1.00 16.17           C  
ATOM  13180  C   GLY    40      77.093  46.701  39.267  1.00 16.82           C  
ATOM  13181  O   GLY    40      76.479  47.191  40.216  1.00 16.75           O  
ATOM  13182  N   GLN    41      77.848  45.617  39.375  1.00 16.68           N  
ATOM  13183  CA  GLN    41      78.114  44.996  40.668  1.00 17.30           C  
ATOM  13184  C   GLN    41      79.538  45.360  41.116  1.00 16.88           C  
ATOM  13185  O   GLN    41      80.451  45.399  40.295  1.00 17.16           O  
ATOM  13186  CB  GLN    41      77.943  43.460  40.588  1.00 17.03           C  
ATOM  13187  CG  GLN    41      76.522  42.993  40.194  1.00 18.15           C  
ATOM  13188  CD  GLN    41      75.491  43.430  41.175  1.00 18.41           C  
ATOM  13189  OE1 GLN    41      75.559  43.081  42.360  1.00 18.42           O  
ATOM  13190  NE2 GLN    41      74.513  44.191  40.705  1.00 18.08           N  
ATOM  13191  N   LEU    42      79.675  45.523  42.425  1.00 18.51           N  
ATOM  13192  CA  LEU    42      80.922  45.823  43.142  1.00 19.27           C  
ATOM  13193  C   LEU    42      81.505  44.544  43.800  1.00 20.59           C  
ATOM  13194  O   LEU    42      80.809  43.508  43.933  1.00 20.90           O  
ATOM  13195  CB  LEU    42      80.648  46.893  44.195  1.00 19.83           C  
ATOM  13196  CG  LEU    42      80.007  48.193  43.701  1.00 20.09           C  
ATOM  13197  CD1 LEU    42      79.893  49.256  44.830  1.00 24.19           C  
ATOM  13198  CD2 LEU    42      80.773  48.751  42.474  1.00 20.92           C  
ATOM  13199  N   PRO    43      82.784  44.590  44.204  1.00 20.99           N  
ATOM  13200  CA  PRO    43      83.390  43.388  44.739  1.00 22.23           C  
ATOM  13201  C   PRO    43      82.987  43.165  46.205  1.00 23.30           C  
ATOM  13202  O   PRO    43      83.833  43.267  47.123  1.00 23.87           O  
ATOM  13203  CB  PRO    43      84.886  43.654  44.574  1.00 22.24           C  
ATOM  13204  CG  PRO    43      85.021  45.107  44.597  1.00 22.74           C  
ATOM  13205  CD  PRO    43      83.747  45.711  44.125  1.00 20.90           C  
ATOM  13206  N   MET    44      81.695  42.863  46.396  1.00 24.94           N  
ATOM  13207  CA  MET    44      81.111  42.668  47.725  1.00 26.76           C  
ATOM  13208  C   MET    44      81.416  41.303  48.250  1.00 27.78           C  
ATOM  13209  O   MET    44      81.216  40.309  47.554  1.00 26.94           O  
ATOM  13210  CB  MET    44      79.606  42.768  47.701  1.00 28.72           C  
ATOM  13211  CG  MET    44      79.087  44.003  47.142  1.00 34.04           C  
ATOM  13212  SD  MET    44      79.675  45.517  48.177  1.00 52.29          SE  
ATOM  13213  CE  MET    44      78.069  46.599  47.655  1.00 42.80           C  
ATOM  13214  N   GLU    45      81.866  41.277  49.503  1.00 28.96           N  
ATOM  13215  CA  GLU    45      82.155  40.050  50.199  1.00 30.57           C  
ATOM  13216  C   GLU    45      81.806  40.268  51.663  1.00 30.94           C  
ATOM  13217  O   GLU    45      82.239  41.230  52.276  1.00 29.35           O  
ATOM  13218  CB  GLU    45      83.615  39.704  50.030  1.00 31.01           C  
ATOM  13219  CG  GLU    45      83.899  38.254  50.285  1.00 32.83           C  
ATOM  13220  CD  GLU    45      85.369  37.906  50.169  1.00 34.03           C  
ATOM  13221  OE1 GLU    45      86.236  38.800  50.290  1.00 40.50           O  
ATOM  13222  OE2 GLU    45      85.665  36.719  49.956  1.00 39.11           O  
ATOM  13223  N   SER    46      80.980  39.381  52.208  1.00 32.41           N  
ATOM  13224  CA  SER    46      80.473  39.546  53.558  1.00 33.11           C  
ATOM  13225  C   SER    46      79.902  40.921  53.829  1.00 32.96           C  
ATOM  13226  O   SER    46      80.092  41.474  54.907  1.00 33.73           O  
ATOM  13227  CB  SER    46      81.576  39.245  54.550  1.00 33.85           C  
ATOM  13228  OG  SER    46      82.071  37.929  54.341  1.00 36.10           O  
ATOM  13229  N   GLY    47      79.201  41.482  52.851  1.00 32.72           N  
ATOM  13230  CA  GLY    47      78.556  42.782  53.023  1.00 32.20           C  
ATOM  13231  C   GLY    47      79.457  44.008  52.954  1.00 31.89           C  
ATOM  13232  O   GLY    47      78.988  45.134  53.165  1.00 32.53           O  
ATOM  13233  N   LYS    48      80.735  43.805  52.632  1.00 31.36           N  
ATOM  13234  CA  LYS    48      81.710  44.889  52.589  1.00 31.00           C  
ATOM  13235  C   LYS    48      82.340  44.938  51.204  1.00 29.19           C  
ATOM  13236  O   LYS    48      82.428  43.919  50.525  1.00 27.85           O  
ATOM  13237  CB  LYS    48      82.812  44.643  53.628  1.00 32.10           C  
ATOM  13238  CG  LYS    48      82.320  44.278  55.056  1.00 33.77           C  
ATOM  13239  CD  LYS    48      83.517  44.073  55.997  1.00 34.85           C  
ATOM  13240  CE  LYS    48      83.212  43.172  57.223  1.00 38.54           C  
ATOM  13241  NZ  LYS    48      82.691  41.784  56.927  1.00 41.89           N  
ATOM  13242  N   ILE    49      82.793  46.114  50.786  1.00 27.46           N  
ATOM  13243  CA  ILE    49      83.609  46.197  49.556  1.00 27.51           C  
ATOM  13244  C   ILE    49      84.994  45.615  49.890  1.00 26.44           C  
ATOM  13245  O   ILE    49      85.717  46.162  50.719  1.00 27.76           O  
ATOM  13246  CB  ILE    49      83.727  47.641  48.999  1.00 27.35           C  
ATOM  13247  CG1 ILE    49      82.339  48.250  48.725  1.00 28.61           C  
ATOM  13248  CG2 ILE    49      84.568  47.654  47.687  1.00 25.90           C  
ATOM  13249  CD1 ILE    49      81.640  47.702  47.484  1.00 29.88           C  
ATOM  13250  N   ALA    50      85.329  44.473  49.299  1.00 24.66           N  
ATOM  13251  CA  ALA    50      86.524  43.716  49.675  1.00 23.88           C  
ATOM  13252  C   ALA    50      87.844  44.216  49.077  1.00 22.88           C  
ATOM  13253  O   ALA    50      88.926  43.916  49.616  1.00 23.36           O  
ATOM  13254  CB  ALA    50      86.342  42.241  49.306  1.00 24.42           C  
ATOM  13255  N   VAL    51      87.773  44.926  47.958  1.00 20.81           N  
ATOM  13256  CA  VAL    51      88.968  45.381  47.241  1.00 19.75           C  
ATOM  13257  C   VAL    51      88.716  46.833  46.772  1.00 19.50           C  
ATOM  13258  O   VAL    51      87.820  47.092  45.950  1.00 18.36           O  
ATOM  13259  CB  VAL    51      89.299  44.506  46.034  1.00 19.25           C  
ATOM  13260  CG1 VAL    51      90.619  44.969  45.369  1.00 17.95           C  
ATOM  13261  CG2 VAL    51      89.337  42.997  46.410  1.00 19.82           C  
ATOM  13262  N   THR    52      89.518  47.761  47.290  1.00 18.83           N  
ATOM  13263  CA  THR    52      89.331  49.192  47.048  1.00 18.76           C  
ATOM  13264  C   THR    52      90.623  49.886  46.577  1.00 17.15           C  
ATOM  13265  O   THR    52      91.752  49.426  46.833  1.00 18.57           O  
ATOM  13266  CB  THR    52      88.801  49.933  48.274  1.00 19.87           C  
ATOM  13267  OG1 THR    52      89.751  49.836  49.341  1.00 20.52           O  
ATOM  13268  CG2 THR    52      87.440  49.358  48.732  1.00 20.18           C  
ATOM  13269  N   GLY    53      90.427  50.980  45.853  1.00 16.63           N  
ATOM  13270  CA  GLY    53      91.523  51.794  45.378  1.00 15.81           C  
ATOM  13271  C   GLY    53      91.866  51.490  43.935  1.00 16.34           C  
ATOM  13272  O   GLY    53      91.220  50.657  43.238  1.00 16.41           O  
ATOM  13273  N   LEU    54      92.852  52.232  43.462  1.00 14.89           N  
ATOM  13274  CA  LEU    54      93.241  52.192  42.046  1.00 15.09           C  
ATOM  13275  C   LEU    54      94.198  51.052  41.691  1.00 14.82           C  
ATOM  13276  O   LEU    54      95.217  50.830  42.343  1.00 15.74           O  
ATOM  13277  CB  LEU    54      93.870  53.539  41.641  1.00 14.99           C  
ATOM  13278  CG  LEU    54      93.016  54.794  41.893  1.00 16.43           C  
ATOM  13279  CD1 LEU    54      93.853  56.129  41.629  1.00 14.43           C  
ATOM  13280  CD2 LEU    54      91.711  54.771  41.099  1.00 18.58           C  
ATOM  13281  N   VAL    55      93.881  50.333  40.618  1.00 15.10           N  
ATOM  13282  CA  VAL    55      94.798  49.303  40.117  1.00 15.22           C  
ATOM  13283  C   VAL    55      96.009  50.038  39.509  1.00 15.52           C  
ATOM  13284  O   VAL    55      95.867  51.023  38.743  1.00 15.49           O  
ATOM  13285  CB  VAL    55      94.147  48.295  39.122  1.00 15.34           C  
ATOM  13286  CG1 VAL    55      95.143  47.202  38.776  1.00 16.34           C  
ATOM  13287  CG2 VAL    55      92.798  47.747  39.668  1.00 14.16           C  
ATOM  13288  N   GLY    56      97.188  49.598  39.915  1.00 15.44           N  
ATOM  13289  CA  GLY    56      98.449  50.244  39.536  1.00 16.28           C  
ATOM  13290  C   GLY    56      98.942  51.219  40.587  1.00 16.32           C  
ATOM  13291  O   GLY    56     100.026  51.780  40.450  1.00 16.29           O  
ATOM  13292  N   ARG    57      98.166  51.390  41.665  1.00 16.32           N  
ATOM  13293  CA  ARG    57      98.571  52.249  42.778  1.00 16.70           C  
ATOM  13294  C   ARG    57      98.304  51.594  44.106  1.00 16.10           C  
ATOM  13295  O   ARG    57      99.218  51.357  44.886  1.00 17.03           O  
ATOM  13296  CB  ARG    57      97.873  53.603  42.715  1.00 15.72           C  
ATOM  13297  CG  ARG    57      98.244  54.497  43.885  1.00 16.84           C  
ATOM  13298  CD  ARG    57      97.659  55.894  43.877  1.00 15.89           C  
ATOM  13299  NE  ARG    57      98.101  56.563  45.097  1.00 15.63           N  
ATOM  13300  CZ  ARG    57      99.287  57.153  45.256  1.00 16.91           C  
ATOM  13301  NH1 ARG    57     100.160  57.249  44.259  1.00 13.83           N  
ATOM  13302  NH2 ARG    57      99.613  57.651  46.435  1.00 15.00           N  
ATOM  13303  N   ASP    58      97.051  51.278  44.341  1.00 16.23           N  
ATOM  13304  CA  ASP    58      96.620  50.693  45.608  1.00 16.54           C  
ATOM  13305  C   ASP    58      96.524  49.169  45.557  1.00 16.62           C  
ATOM  13306  O   ASP    58      96.664  48.506  46.600  1.00 16.58           O  
ATOM  13307  CB  ASP    58      95.275  51.259  45.998  1.00 16.42           C  
ATOM  13308  CG  ASP    58      95.312  52.769  46.142  1.00 17.20           C  
ATOM  13309  OD1 ASP    58      96.112  53.243  46.982  1.00 19.65           O  
ATOM  13310  OD2 ASP    58      94.531  53.456  45.451  1.00 18.16           O  
ATOM  13311  N   VAL    59      96.242  48.632  44.377  1.00 16.45           N  
ATOM  13312  CA  VAL    59      96.058  47.197  44.212  1.00 17.77           C  
ATOM  13313  C   VAL    59      96.785  46.737  42.956  1.00 17.83           C  
ATOM  13314  O   VAL    59      96.926  47.493  41.987  1.00 17.33           O  
ATOM  13315  CB  VAL    59      94.554  46.767  44.189  1.00 18.87           C  
ATOM  13316  CG1 VAL    59      93.778  47.334  45.449  1.00 21.82           C  
ATOM  13317  CG2 VAL    59      93.896  47.197  42.965  1.00 21.44           C  
ATOM  13318  N   ASP    60      97.285  45.515  43.025  1.00 18.74           N  
ATOM  13319  CA  ASP    60      97.964  44.879  41.909  1.00 19.34           C  
ATOM  13320  C   ASP    60      96.992  44.080  41.043  1.00 19.48           C  
ATOM  13321  O   ASP    60      95.805  44.037  41.332  1.00 19.40           O  
ATOM  13322  CB  ASP    60      99.147  44.040  42.405  1.00 20.89           C  
ATOM  13323  CG  ASP    60      98.757  42.848  43.254  1.00 21.21           C  
ATOM  13324  OD1 ASP    60      97.589  42.484  43.394  1.00 22.81           O  
ATOM  13325  OD2 ASP    60      99.713  42.231  43.792  1.00 30.25           O  
ATOM  13326  N   VAL    61      97.486  43.487  39.967  1.00 18.59           N  
ATOM  13327  CA  VAL    61      96.614  42.760  39.045  1.00 19.30           C  
ATOM  13328  C   VAL    61      95.938  41.568  39.757  1.00 18.76           C  
ATOM  13329  O   VAL    61      94.732  41.355  39.623  1.00 19.22           O  
ATOM  13330  CB  VAL    61      97.352  42.330  37.761  1.00 19.44           C  
ATOM  13331  CG1 VAL    61      96.504  41.337  36.953  1.00 20.46           C  
ATOM  13332  CG2 VAL    61      97.699  43.573  36.911  1.00 19.62           C  
ATOM  13333  N   ALA    62      96.695  40.801  40.523  1.00 18.89           N  
ATOM  13334  CA  ALA    62      96.120  39.649  41.215  1.00 19.10           C  
ATOM  13335  C   ALA    62      94.973  40.048  42.139  1.00 19.10           C  
ATOM  13336  O   ALA    62      93.905  39.417  42.132  1.00 18.61           O  
ATOM  13337  CB  ALA    62      97.209  38.899  42.012  1.00 19.82           C  
ATOM  13338  N   SER    63      95.178  41.088  42.960  1.00 18.52           N  
ATOM  13339  CA  SER    63      94.126  41.541  43.854  1.00 19.00           C  
ATOM  13340  C   SER    63      92.917  42.037  43.057  1.00 18.56           C  
ATOM  13341  O   SER    63      91.790  41.803  43.432  1.00 18.58           O  
ATOM  13342  CB  SER    63      94.622  42.645  44.745  1.00 19.24           C  
ATOM  13343  OG  SER    63      95.617  42.148  45.586  1.00 20.64           O  
ATOM  13344  N   ALA    64      93.164  42.778  41.983  1.00 18.32           N  
ATOM  13345  CA  ALA    64      92.088  43.282  41.124  1.00 18.22           C  
ATOM  13346  C   ALA    64      91.295  42.123  40.447  1.00 17.22           C  
ATOM  13347  O   ALA    64      90.093  42.203  40.247  1.00 15.74           O  
ATOM  13348  CB  ALA    64      92.667  44.231  40.071  1.00 18.00           C  
ATOM  13349  N   GLN    65      92.005  41.065  40.095  1.00 18.13           N  
ATOM  13350  CA  GLN    65      91.374  39.867  39.554  1.00 19.19           C  
ATOM  13351  C   GLN    65      90.392  39.274  40.566  1.00 19.55           C  
ATOM  13352  O   GLN    65      89.268  38.896  40.194  1.00 19.43           O  
ATOM  13353  CB  GLN    65      92.424  38.845  39.097  1.00 18.99           C  
ATOM  13354  CG  GLN    65      93.078  39.208  37.762  1.00 19.83           C  
ATOM  13355  CD  GLN    65      94.275  38.344  37.421  1.00 19.98           C  
ATOM  13356  OE1 GLN    65      94.942  37.792  38.312  1.00 23.49           O  
ATOM  13357  NE2 GLN    65      94.541  38.184  36.114  1.00 20.84           N  
ATOM  13358  N   ARG    66      90.789  39.194  41.835  1.00 20.27           N  
ATOM  13359  CA  ARG    66      89.877  38.774  42.884  1.00 19.80           C  
ATOM  13360  C   ARG    66      88.688  39.723  43.034  1.00 19.12           C  
ATOM  13361  O   ARG    66      87.559  39.289  43.213  1.00 18.72           O  
ATOM  13362  CB  ARG    66      90.597  38.676  44.215  1.00 21.46           C  
ATOM  13363  CG  ARG    66      89.674  38.205  45.361  1.00 25.65           C  
ATOM  13364  CD  ARG    66      89.298  36.727  45.200  1.00 36.25           C  
ATOM  13365  NE  ARG    66      90.392  35.890  45.691  1.00 41.73           N  
ATOM  13366  CZ  ARG    66      90.704  34.644  45.300  1.00 44.24           C  
ATOM  13367  NH1 ARG    66      90.018  33.988  44.357  1.00 45.76           N  
ATOM  13368  NH2 ARG    66      91.746  34.039  45.876  1.00 45.36           N  
ATOM  13369  N   ALA    67      88.915  41.023  42.911  1.00 18.19           N  
ATOM  13370  CA  ALA    67      87.776  41.975  42.854  1.00 17.76           C  
ATOM  13371  C   ALA    67      86.826  41.622  41.708  1.00 17.38           C  
ATOM  13372  O   ALA    67      85.599  41.617  41.892  1.00 17.68           O  
ATOM  13373  CB  ALA    67      88.270  43.434  42.700  1.00 18.27           C  
ATOM  13374  N   ALA    68      87.399  41.298  40.541  1.00 16.79           N  
ATOM  13375  CA  ALA    68      86.601  40.982  39.365  1.00 17.36           C  
ATOM  13376  C   ALA    68      85.816  39.681  39.613  1.00 17.31           C  
ATOM  13377  O   ALA    68      84.630  39.612  39.301  1.00 17.42           O  
ATOM  13378  CB  ALA    68      87.459  40.881  38.124  1.00 16.52           C  
ATOM  13379  N   GLU    69      86.469  38.683  40.196  1.00 17.93           N  
ATOM  13380  CA  GLU    69      85.784  37.441  40.576  1.00 18.71           C  
ATOM  13381  C   GLU    69      84.583  37.751  41.484  1.00 18.93           C  
ATOM  13382  O   GLU    69      83.471  37.242  41.241  1.00 18.31           O  
ATOM  13383  CB  GLU    69      86.757  36.477  41.251  1.00 19.08           C  
ATOM  13384  CG  GLU    69      87.806  35.902  40.322  1.00 21.15           C  
ATOM  13385  CD  GLU    69      88.858  35.066  41.051  1.00 22.14           C  
ATOM  13386  OE1 GLU    69      89.114  35.313  42.248  1.00 26.87           O  
ATOM  13387  OE2 GLU    69      89.424  34.144  40.439  1.00 27.07           O  
ATOM  13388  N   LEU    70      84.785  38.602  42.502  1.00 18.58           N  
ATOM  13389  CA  LEU    70      83.696  38.968  43.407  1.00 18.83           C  
ATOM  13390  C   LEU    70      82.568  39.708  42.680  1.00 19.23           C  
ATOM  13391  O   LEU    70      81.381  39.501  42.991  1.00 19.11           O  
ATOM  13392  CB  LEU    70      84.211  39.780  44.620  1.00 19.41           C  
ATOM  13393  CG  LEU    70      85.076  39.021  45.631  1.00 19.00           C  
ATOM  13394  CD1 LEU    70      85.801  39.978  46.576  1.00 19.47           C  
ATOM  13395  CD2 LEU    70      84.185  37.995  46.377  1.00 21.35           C  
ATOM  13396  N   CYS    71      82.915  40.595  41.740  1.00 18.39           N  
ATOM  13397  CA  CYS    71      81.884  41.296  40.973  1.00 18.21           C  
ATOM  13398  C   CYS    71      81.020  40.255  40.259  1.00 18.12           C  
ATOM  13399  O   CYS    71      79.783  40.380  40.219  1.00 18.48           O  
ATOM  13400  CB  CYS    71      82.523  42.263  39.959  1.00 18.28           C  
ATOM  13401  SG  CYS    71      83.354  43.707  40.748  1.00 17.98           S  
ATOM  13402  N   ALA    72      81.702  39.258  39.697  1.00 18.14           N  
ATOM  13403  CA  ALA    72      81.087  38.152  38.925  1.00 18.89           C  
ATOM  13404  C   ALA    72      80.191  37.309  39.820  1.00 19.05           C  
ATOM  13405  O   ALA    72      79.114  36.921  39.394  1.00 18.95           O  
ATOM  13406  CB  ALA    72      82.163  37.286  38.228  1.00 19.28           C  
ATOM  13407  N   VAL    73      80.632  37.045  41.048  1.00 19.61           N  
ATOM  13408  CA  VAL    73      79.815  36.298  42.031  1.00 20.01           C  
ATOM  13409  C   VAL    73      78.521  37.045  42.369  1.00 20.13           C  
ATOM  13410  O   VAL    73      77.428  36.449  42.460  1.00 20.48           O  
ATOM  13411  CB  VAL    73      80.633  36.004  43.330  1.00 20.82           C  
ATOM  13412  CG1 VAL    73      79.714  35.513  44.502  1.00 21.02           C  
ATOM  13413  CG2 VAL    73      81.772  35.052  43.029  1.00 19.80           C  
ATOM  13414  N   ASN    74      78.651  38.353  42.525  1.00 20.11           N  
ATOM  13415  CA  ASN    74      77.538  39.245  42.782  1.00 19.82           C  
ATOM  13416  C   ASN    74      76.578  39.319  41.600  1.00 19.58           C  
ATOM  13417  O   ASN    74      75.340  39.315  41.782  1.00 19.11           O  
ATOM  13418  CB  ASN    74      78.047  40.618  43.245  1.00 21.09           C  
ATOM  13419  CG  ASN    74      78.475  40.618  44.708  1.00 20.96           C  
ATOM  13420  OD1 ASN    74      79.667  40.497  45.044  1.00 25.84           O  
ATOM  13421  ND2 ASN    74      77.513  40.757  45.583  1.00 21.36           N  
ATOM  13422  N   ILE    75      77.117  39.332  40.385  1.00 19.22           N  
ATOM  13423  CA  ILE    75      76.266  39.262  39.188  1.00 19.73           C  
ATOM  13424  C   ILE    75      75.449  37.952  39.240  1.00 19.91           C  
ATOM  13425  O   ILE    75      74.232  37.959  39.042  1.00 21.28           O  
ATOM  13426  CB  ILE    75      77.082  39.318  37.856  1.00 20.26           C  
ATOM  13427  CG1 ILE    75      77.721  40.707  37.642  1.00 20.27           C  
ATOM  13428  CG2 ILE    75      76.193  38.957  36.665  1.00 18.77           C  
ATOM  13429  CD1 ILE    75      78.803  40.768  36.489  1.00 19.64           C  
ATOM  13430  N   LEU    76      76.126  36.852  39.510  1.00 20.16           N  
ATOM  13431  CA  LEU    76      75.459  35.515  39.533  1.00 20.33           C  
ATOM  13432  C   LEU    76      74.366  35.460  40.615  1.00 20.78           C  
ATOM  13433  O   LEU    76      73.297  34.907  40.379  1.00 21.42           O  
ATOM  13434  CB  LEU    76      76.486  34.394  39.689  1.00 20.53           C  
ATOM  13435  CG  LEU    76      77.372  34.118  38.484  1.00 20.87           C  
ATOM  13436  CD1 LEU    76      78.458  33.098  38.825  1.00 22.97           C  
ATOM  13437  CD2 LEU    76      76.544  33.679  37.260  1.00 23.02           C  
ATOM  13438  N   ALA    77      74.614  36.063  41.784  1.00 21.14           N  
ATOM  13439  CA  ALA    77      73.597  36.165  42.832  1.00 21.04           C  
ATOM  13440  C   ALA    77      72.361  36.891  42.300  1.00 21.95           C  
ATOM  13441  O   ALA    77      71.217  36.466  42.522  1.00 21.90           O  
ATOM  13442  CB  ALA    77      74.162  36.883  44.086  1.00 20.99           C  
ATOM  13443  N   GLN    78      72.587  37.993  41.581  1.00 21.45           N  
ATOM  13444  CA  GLN    78      71.473  38.745  41.023  1.00 22.10           C  
ATOM  13445  C   GLN    78      70.713  37.927  39.965  1.00 21.79           C  
ATOM  13446  O   GLN    78      69.486  37.929  39.936  1.00 22.55           O  
ATOM  13447  CB  GLN    78      71.950  40.077  40.422  1.00 22.09           C  
ATOM  13448  CG  GLN    78      72.508  41.105  41.436  1.00 24.22           C  
ATOM  13449  CD  GLN    78      71.567  41.457  42.585  1.00 27.40           C  
ATOM  13450  OE1 GLN    78      70.352  41.227  42.543  1.00 31.81           O  
ATOM  13451  NE2 GLN    78      72.141  42.054  43.621  1.00 33.24           N  
ATOM  13452  N   VAL    79      71.444  37.235  39.103  1.00 22.19           N  
ATOM  13453  CA  VAL    79      70.817  36.392  38.091  1.00 22.65           C  
ATOM  13454  C   VAL    79      69.980  35.285  38.732  1.00 23.28           C  
ATOM  13455  O   VAL    79      68.872  35.003  38.273  1.00 23.03           O  
ATOM  13456  CB  VAL    79      71.835  35.795  37.119  1.00 23.12           C  
ATOM  13457  CG1 VAL    79      71.136  34.895  36.134  1.00 23.37           C  
ATOM  13458  CG2 VAL    79      72.623  36.932  36.374  1.00 22.03           C  
ATOM  13459  N   LYS    80      70.507  34.673  39.779  1.00 23.69           N  
ATOM  13460  CA  LYS    80      69.799  33.611  40.478  1.00 24.34           C  
ATOM  13461  C   LYS    80      68.501  34.164  41.053  1.00 25.02           C  
ATOM  13462  O   LYS    80      67.442  33.517  40.935  1.00 25.88           O  
ATOM  13463  CB  LYS    80      70.672  33.018  41.576  1.00 24.54           C  
ATOM  13464  CG  LYS    80      69.980  31.893  42.358  1.00 24.65           C  
ATOM  13465  CD  LYS    80      70.809  31.421  43.510  1.00 25.01           C  
ATOM  13466  CE  LYS    80      69.995  30.487  44.426  1.00 26.39           C  
ATOM  13467  NZ  LYS    80      70.884  29.674  45.302  1.00 27.82           N  
ATOM  13468  N   ALA    81      68.564  35.351  41.664  1.00 25.16           N  
ATOM  13469  CA  ALA    81      67.346  36.048  42.148  1.00 25.31           C  
ATOM  13470  C   ALA    81      66.342  36.341  41.017  1.00 25.95           C  
ATOM  13471  O   ALA    81      65.141  36.042  41.158  1.00 25.62           O  
ATOM  13472  CB  ALA    81      67.697  37.329  42.899  1.00 25.25           C  
ATOM  13473  N   ALA    82      66.827  36.906  39.908  1.00 25.86           N  
ATOM  13474  CA  ALA    82      66.008  37.146  38.720  1.00 26.45           C  
ATOM  13475  C   ALA    82      65.358  35.846  38.201  1.00 26.96           C  
ATOM  13476  O   ALA    82      64.253  35.900  37.645  1.00 27.66           O  
ATOM  13477  CB  ALA    82      66.813  37.773  37.611  1.00 25.68           C  
ATOM  13478  N   LEU    83      66.034  34.712  38.370  1.00 27.25           N  
ATOM  13479  CA  LEU    83      65.568  33.458  37.785  1.00 28.53           C  
ATOM  13480  C   LEU    83      64.892  32.546  38.810  1.00 29.77           C  
ATOM  13481  O   LEU    83      64.768  31.322  38.610  1.00 29.23           O  
ATOM  13482  CB  LEU    83      66.721  32.761  37.070  1.00 28.68           C  
ATOM  13483  CG  LEU    83      67.336  33.509  35.875  1.00 27.34           C  
ATOM  13484  CD1 LEU    83      68.442  32.677  35.265  1.00 27.66           C  
ATOM  13485  CD2 LEU    83      66.303  33.910  34.809  1.00 26.22           C  
ATOM  13486  N   ASN    84      64.439  33.159  39.895  1.00 30.56           N  
ATOM  13487  CA  ASN    84      63.729  32.463  40.972  1.00 32.17           C  
ATOM  13488  C   ASN    84      64.473  31.244  41.527  1.00 32.90           C  
ATOM  13489  O   ASN    84      63.869  30.207  41.867  1.00 33.06           O  
ATOM  13490  CB  ASN    84      62.309  32.124  40.501  1.00 32.69           C  
ATOM  13491  CG  ASN    84      61.490  33.372  40.221  1.00 35.55           C  
ATOM  13492  OD1 ASN    84      60.912  33.525  39.134  1.00 41.64           O  
ATOM  13493  ND2 ASN    84      61.455  34.290  41.192  1.00 39.24           N  
ATOM  13494  N   GLY    85      65.789  31.382  41.634  1.00 33.09           N  
ATOM  13495  CA  GLY    85      66.645  30.371  42.227  1.00 33.47           C  
ATOM  13496  C   GLY    85      67.306  29.487  41.196  1.00 34.39           C  
ATOM  13497  O   GLY    85      68.029  28.555  41.537  1.00 35.05           O  
ATOM  13498  N   ASP    86      67.097  29.793  39.927  1.00 35.62           N  
ATOM  13499  CA  ASP    86      67.425  28.850  38.869  1.00 36.87           C  
ATOM  13500  C   ASP    86      68.531  29.305  37.873  1.00 36.44           C  
ATOM  13501  O   ASP    86      68.241  29.668  36.744  1.00 36.29           O  
ATOM  13502  CB  ASP    86      66.107  28.532  38.145  1.00 37.68           C  
ATOM  13503  CG  ASP    86      66.135  27.208  37.412  1.00 40.66           C  
ATOM  13504  OD1 ASP    86      67.157  26.494  37.471  1.00 44.08           O  
ATOM  13505  OD2 ASP    86      65.116  26.881  36.763  1.00 45.09           O  
ATOM  13506  N   LEU    87      69.796  29.225  38.285  1.00 36.56           N  
ATOM  13507  CA  LEU    87      70.940  29.570  37.412  1.00 36.56           C  
ATOM  13508  C   LEU    87      71.040  28.748  36.105  1.00 36.34           C  
ATOM  13509  O   LEU    87      71.796  29.096  35.196  1.00 35.79           O  
ATOM  13510  CB  LEU    87      72.272  29.500  38.182  1.00 36.86           C  
ATOM  13511  CG  LEU    87      72.623  30.693  39.091  1.00 36.88           C  
ATOM  13512  CD1 LEU    87      73.967  30.459  39.777  1.00 36.37           C  
ATOM  13513  CD2 LEU    87      72.640  32.048  38.326  1.00 36.15           C  
ATOM  13514  N   SER    88      70.275  27.665  36.024  1.00 36.37           N  
ATOM  13515  CA  SER    88      70.251  26.801  34.847  1.00 35.94           C  
ATOM  13516  C   SER    88      69.374  27.362  33.727  1.00 35.17           C  
ATOM  13517  O   SER    88      69.432  26.891  32.595  1.00 35.24           O  
ATOM  13518  CB  SER    88      69.754  25.418  35.260  1.00 36.16           C  
ATOM  13519  OG  SER    88      68.473  25.510  35.846  1.00 37.19           O  
ATOM  13520  N   LYS    89      68.583  28.382  34.056  1.00 34.43           N  
ATOM  13521  CA  LYS    89      67.792  29.109  33.080  1.00 33.77           C  
ATOM  13522  C   LYS    89      68.571  30.213  32.358  1.00 32.24           C  
ATOM  13523  O   LYS    89      67.994  30.935  31.545  1.00 32.12           O  
ATOM  13524  CB  LYS    89      66.543  29.690  33.739  1.00 34.20           C  
ATOM  13525  CG  LYS    89      65.489  28.606  34.078  1.00 35.37           C  
ATOM  13526  CD  LYS    89      64.197  29.224  34.590  1.00 36.03           C  
ATOM  13527  CE  LYS    89      63.040  28.177  34.705  1.00 37.98           C  
ATOM  13528  NZ  LYS    89      62.891  27.610  36.082  1.00 39.34           N  
ATOM  13529  N   ILE    90      69.865  30.341  32.642  1.00 30.91           N  
ATOM  13530  CA  ILE    90      70.740  31.151  31.793  1.00 30.51           C  
ATOM  13531  C   ILE    90      70.915  30.437  30.434  1.00 30.01           C  
ATOM  13532  O   ILE    90      71.329  29.275  30.387  1.00 31.25           O  
ATOM  13533  CB  ILE    90      72.141  31.392  32.445  1.00 30.19           C  
ATOM  13534  CG1 ILE    90      72.004  32.133  33.787  1.00 29.03           C  
ATOM  13535  CG2 ILE    90      73.086  32.137  31.461  1.00 29.03           C  
ATOM  13536  CD1 ILE    90      73.322  32.266  34.564  1.00 30.48           C  
ATOM  13537  N   ARG    91      70.602  31.114  29.336  1.00 28.51           N  
ATOM  13538  CA  ARG    91      70.882  30.563  28.010  1.00 29.50           C  
ATOM  13539  C   ARG    91      72.270  30.959  27.522  1.00 27.41           C  
ATOM  13540  O   ARG    91      73.007  30.149  26.963  1.00 25.76           O  
ATOM  13541  CB  ARG    91      69.802  30.984  27.021  1.00 29.42           C  
ATOM  13542  CG  ARG    91      68.469  30.319  27.356  1.00 33.12           C  
ATOM  13543  CD  ARG    91      67.261  30.999  26.705  1.00 35.92           C  
ATOM  13544  NE  ARG    91      67.355  31.013  25.251  1.00 43.12           N  
ATOM  13545  CZ  ARG    91      67.218  29.942  24.465  1.00 46.08           C  
ATOM  13546  NH1 ARG    91      66.945  28.734  24.973  1.00 47.97           N  
ATOM  13547  NH2 ARG    91      67.346  30.092  23.143  1.00 46.98           N  
ATOM  13548  N   ARG    92      72.634  32.203  27.780  1.00 25.79           N  
ATOM  13549  CA  ARG    92      73.916  32.748  27.347  1.00 25.72           C  
ATOM  13550  C   ARG    92      74.201  34.042  28.094  1.00 23.76           C  
ATOM  13551  O   ARG    92      73.289  34.873  28.245  1.00 22.58           O  
ATOM  13552  CB  ARG    92      73.835  33.054  25.862  1.00 26.82           C  
ATOM  13553  CG  ARG    92      74.885  33.989  25.316  1.00 31.69           C  
ATOM  13554  CD  ARG    92      75.607  33.399  24.154  1.00 37.13           C  
ATOM  13555  NE  ARG    92      76.890  32.858  24.594  1.00 40.03           N  
ATOM  13556  CZ  ARG    92      77.376  31.648  24.306  1.00 42.08           C  
ATOM  13557  NH1 ARG    92      76.702  30.777  23.546  1.00 43.85           N  
ATOM  13558  NH2 ARG    92      78.569  31.303  24.771  1.00 40.04           N  
ATOM  13559  N   VAL    93      75.433  34.184  28.586  1.00 21.68           N  
ATOM  13560  CA  VAL    93      75.905  35.473  29.055  1.00 20.41           C  
ATOM  13561  C   VAL    93      76.303  36.221  27.782  1.00 20.28           C  
ATOM  13562  O   VAL    93      77.259  35.856  27.069  1.00 21.18           O  
ATOM  13563  CB  VAL    93      77.080  35.374  30.075  1.00 20.10           C  
ATOM  13564  CG1 VAL    93      77.543  36.778  30.511  1.00 20.34           C  
ATOM  13565  CG2 VAL    93      76.685  34.513  31.307  1.00 20.35           C  
ATOM  13566  N   ILE    94      75.543  37.252  27.472  1.00 19.62           N  
ATOM  13567  CA  ILE    94      75.707  37.970  26.218  1.00 19.82           C  
ATOM  13568  C   ILE    94      76.892  38.962  26.232  1.00 19.77           C  
ATOM  13569  O   ILE    94      77.686  39.016  25.272  1.00 19.63           O  
ATOM  13570  CB  ILE    94      74.405  38.688  25.859  1.00 20.18           C  
ATOM  13571  CG1 ILE    94      73.341  37.638  25.511  1.00 21.26           C  
ATOM  13572  CG2 ILE    94      74.574  39.644  24.658  1.00 20.74           C  
ATOM  13573  CD1 ILE    94      73.669  36.882  24.212  1.00 25.02           C  
ATOM  13574  N   LYS    95      77.009  39.701  27.338  1.00 19.20           N  
ATOM  13575  CA  LYS    95      77.963  40.817  27.444  1.00 18.28           C  
ATOM  13576  C   LYS    95      78.268  41.140  28.913  1.00 18.11           C  
ATOM  13577  O   LYS    95      77.377  41.166  29.740  1.00 17.68           O  
ATOM  13578  CB  LYS    95      77.362  42.031  26.756  1.00 18.02           C  
ATOM  13579  CG  LYS    95      78.180  43.334  26.821  1.00 18.92           C  
ATOM  13580  CD  LYS    95      79.388  43.233  25.899  1.00 17.97           C  
ATOM  13581  CE  LYS    95      80.246  44.514  25.891  1.00 19.41           C  
ATOM  13582  NZ  LYS    95      79.470  45.692  25.394  1.00 20.19           N  
ATOM  13583  N   LEU    96      79.537  41.389  29.220  1.00 18.19           N  
ATOM  13584  CA  LEU    96      79.951  41.957  30.513  1.00 17.80           C  
ATOM  13585  C   LEU    96      80.658  43.271  30.202  1.00 17.10           C  
ATOM  13586  O   LEU    96      81.468  43.325  29.258  1.00 17.15           O  
ATOM  13587  CB  LEU    96      80.942  41.045  31.244  1.00 18.83           C  
ATOM  13588  CG  LEU    96      80.585  39.667  31.800  1.00 20.85           C  
ATOM  13589  CD1 LEU    96      81.711  39.277  32.729  1.00 22.50           C  
ATOM  13590  CD2 LEU    96      79.206  39.674  32.520  1.00 21.93           C  
ATOM  13591  N   ASN    97      80.329  44.321  30.946  1.00 16.61           N  
ATOM  13592  CA  ASN    97      81.130  45.529  30.906  1.00 16.14           C  
ATOM  13593  C   ASN    97      81.933  45.623  32.183  1.00 15.02           C  
ATOM  13594  O   ASN    97      81.375  45.796  33.268  1.00 14.66           O  
ATOM  13595  CB  ASN    97      80.289  46.767  30.662  1.00 16.88           C  
ATOM  13596  CG  ASN    97      79.486  46.689  29.385  1.00 18.53           C  
ATOM  13597  OD1 ASN    97      78.257  46.535  29.404  1.00 23.42           O  
ATOM  13598  ND2 ASN    97      80.171  46.786  28.273  1.00 15.75           N  
ATOM  13599  N   GLY    98      83.256  45.563  32.012  1.00 14.82           N  
ATOM  13600  CA  GLY    98      84.185  45.561  33.119  1.00 15.02           C  
ATOM  13601  C   GLY    98      84.852  46.915  33.285  1.00 15.44           C  
ATOM  13602  O   GLY    98      85.617  47.349  32.412  1.00 16.65           O  
ATOM  13603  N   PHE    99      84.542  47.593  34.386  1.00 15.14           N  
ATOM  13604  CA  PHE    99      85.102  48.870  34.692  1.00 14.44           C  
ATOM  13605  C   PHE    99      86.167  48.697  35.768  1.00 14.30           C  
ATOM  13606  O   PHE    99      85.866  48.199  36.872  1.00 14.95           O  
ATOM  13607  CB  PHE    99      83.973  49.765  35.171  1.00 15.41           C  
ATOM  13608  CG  PHE    99      82.790  49.765  34.262  1.00 16.64           C  
ATOM  13609  CD1 PHE    99      82.914  50.201  32.953  1.00 22.14           C  
ATOM  13610  CD2 PHE    99      81.554  49.354  34.715  1.00 19.51           C  
ATOM  13611  CE1 PHE    99      81.807  50.224  32.110  1.00 22.73           C  
ATOM  13612  CE2 PHE    99      80.456  49.391  33.888  1.00 20.40           C  
ATOM  13613  CZ  PHE    99      80.577  49.822  32.604  1.00 19.17           C  
ATOM  13614  N   VAL   100      87.401  49.093  35.463  1.00 12.97           N  
ATOM  13615  CA  VAL   100      88.533  48.945  36.395  1.00 13.47           C  
ATOM  13616  C   VAL   100      89.113  50.315  36.797  1.00 13.53           C  
ATOM  13617  O   VAL   100      89.639  51.033  35.962  1.00 13.48           O  
ATOM  13618  CB  VAL   100      89.674  48.129  35.768  1.00 12.63           C  
ATOM  13619  CG1 VAL   100      90.810  47.914  36.819  1.00 13.13           C  
ATOM  13620  CG2 VAL   100      89.172  46.827  35.121  1.00 14.55           C  
ATOM  13621  N   ALA   101      89.018  50.651  38.073  1.00 13.61           N  
ATOM  13622  CA  ALA   101      89.573  51.922  38.591  1.00 13.39           C  
ATOM  13623  C   ALA   101      91.080  51.820  38.411  1.00 13.93           C  
ATOM  13624  O   ALA   101      91.703  50.866  38.925  1.00 12.78           O  
ATOM  13625  CB  ALA   101      89.195  52.132  40.064  1.00 13.54           C  
ATOM  13626  N   SER   102      91.652  52.751  37.644  1.00 13.96           N  
ATOM  13627  CA  SER   102      93.014  52.597  37.122  1.00 13.76           C  
ATOM  13628  C   SER   102      93.783  53.879  37.237  1.00 13.85           C  
ATOM  13629  O   SER   102      93.239  54.942  37.020  1.00 13.85           O  
ATOM  13630  CB  SER   102      92.952  52.234  35.615  1.00 13.46           C  
ATOM  13631  OG  SER   102      92.318  50.995  35.346  1.00 15.64           O  
ATOM  13632  N   VAL   103      95.081  53.795  37.542  1.00 14.08           N  
ATOM  13633  CA  VAL   103      95.940  54.957  37.235  1.00 13.49           C  
ATOM  13634  C   VAL   103      96.211  54.943  35.728  1.00 14.32           C  
ATOM  13635  O   VAL   103      96.076  53.907  35.086  1.00 14.13           O  
ATOM  13636  CB  VAL   103      97.260  54.995  38.049  1.00 13.45           C  
ATOM  13637  CG1 VAL   103      96.964  55.212  39.528  1.00 13.30           C  
ATOM  13638  CG2 VAL   103      98.085  53.757  37.857  1.00 14.31           C  
ATOM  13639  N   PRO   104      96.528  56.120  35.158  1.00 14.49           N  
ATOM  13640  CA  PRO   104      96.705  56.218  33.710  1.00 15.18           C  
ATOM  13641  C   PRO   104      97.820  55.375  33.100  1.00 15.45           C  
ATOM  13642  O   PRO   104      97.786  55.109  31.890  1.00 17.16           O  
ATOM  13643  CB  PRO   104      96.935  57.712  33.487  1.00 15.35           C  
ATOM  13644  CG  PRO   104      96.279  58.366  34.685  1.00 16.48           C  
ATOM  13645  CD  PRO   104      96.631  57.440  35.786  1.00 15.15           C  
ATOM  13646  N   GLU   105      98.781  54.941  33.908  1.00 15.63           N  
ATOM  13647  CA  GLU   105      99.839  54.061  33.433  1.00 14.99           C  
ATOM  13648  C   GLU   105      99.426  52.591  33.472  1.00 15.57           C  
ATOM  13649  O   GLU   105     100.143  51.745  32.983  1.00 15.51           O  
ATOM  13650  CB  GLU   105     101.129  54.233  34.247  1.00 15.82           C  
ATOM  13651  CG  GLU   105     101.751  55.606  34.111  1.00 14.48           C  
ATOM  13652  CD  GLU   105     100.908  56.711  34.727  1.00 14.59           C  
ATOM  13653  OE1 GLU   105     100.406  56.563  35.871  1.00 15.16           O  
ATOM  13654  OE2 GLU   105     100.751  57.745  34.035  1.00 15.78           O  
ATOM  13655  N   PHE   106      98.296  52.297  34.120  1.00 15.66           N  
ATOM  13656  CA  PHE   106      97.815  50.921  34.211  1.00 15.19           C  
ATOM  13657  C   PHE   106      97.034  50.567  32.952  1.00 15.21           C  
ATOM  13658  O   PHE   106      96.053  51.238  32.616  1.00 15.33           O  
ATOM  13659  CB  PHE   106      96.970  50.643  35.451  1.00 15.12           C  
ATOM  13660  CG  PHE   106      96.527  49.222  35.524  1.00 14.69           C  
ATOM  13661  CD1 PHE   106      97.460  48.191  35.776  1.00 13.97           C  
ATOM  13662  CD2 PHE   106      95.195  48.878  35.251  1.00 14.24           C  
ATOM  13663  CE1 PHE   106      97.055  46.849  35.796  1.00 16.21           C  
ATOM  13664  CE2 PHE   106      94.808  47.554  35.251  1.00 16.36           C  
ATOM  13665  CZ  PHE   106      95.711  46.545  35.530  1.00 15.69           C  
ATOM  13666  N   VAL   107      97.492  49.515  32.274  1.00 15.49           N  
ATOM  13667  CA  VAL   107      96.959  49.139  30.942  1.00 15.51           C  
ATOM  13668  C   VAL   107      96.660  47.626  30.810  1.00 16.14           C  
ATOM  13669  O   VAL   107      96.676  47.065  29.678  1.00 17.46           O  
ATOM  13670  CB  VAL   107      97.875  49.636  29.813  1.00 15.35           C  
ATOM  13671  CG1 VAL   107      97.910  51.181  29.745  1.00 16.15           C  
ATOM  13672  CG2 VAL   107      99.308  49.001  29.940  1.00 17.34           C  
ATOM  13673  N   GLU   108      96.342  46.976  31.937  1.00 15.75           N  
ATOM  13674  CA  GLU   108      96.023  45.560  31.913  1.00 16.38           C  
ATOM  13675  C   GLU   108      94.628  45.285  32.422  1.00 15.43           C  
ATOM  13676  O   GLU   108      94.352  44.262  33.088  1.00 16.13           O  
ATOM  13677  CB  GLU   108      97.076  44.777  32.693  1.00 16.44           C  
ATOM  13678  CG  GLU   108      98.436  44.788  32.033  1.00 19.85           C  
ATOM  13679  CD  GLU   108      99.523  44.263  32.973  1.00 20.58           C  
ATOM  13680  OE1 GLU   108      99.742  44.801  34.079  1.00 29.71           O  
ATOM  13681  OE2 GLU   108     100.165  43.306  32.588  1.00 28.76           O  
ATOM  13682  N   GLN   109      93.705  46.167  32.065  1.00 15.62           N  
ATOM  13683  CA  GLN   109      92.320  45.982  32.468  1.00 15.33           C  
ATOM  13684  C   GLN   109      91.738  44.684  31.902  1.00 15.79           C  
ATOM  13685  O   GLN   109      90.865  44.105  32.513  1.00 16.28           O  
ATOM  13686  CB  GLN   109      91.473  47.148  32.024  1.00 15.81           C  
ATOM  13687  CG  GLN   109      91.813  48.476  32.661  1.00 14.14           C  
ATOM  13688  CD  GLN   109      92.960  49.238  31.952  1.00 15.09           C  
ATOM  13689  OE1 GLN   109      93.533  48.780  30.938  1.00 14.45           O  
ATOM  13690  NE2 GLN   109      93.277  50.409  32.470  1.00 14.52           N  
ATOM  13691  N   HIS   110      92.217  44.249  30.747  1.00 15.52           N  
ATOM  13692  CA  HIS   110      91.773  42.945  30.180  1.00 15.97           C  
ATOM  13693  C   HIS   110      92.129  41.795  31.114  1.00 15.78           C  
ATOM  13694  O   HIS   110      91.333  40.912  31.357  1.00 16.32           O  
ATOM  13695  CB  HIS   110      92.311  42.739  28.739  1.00 16.72           C  
ATOM  13696  CG  HIS   110      93.809  42.789  28.627  1.00 17.04           C  
ATOM  13697  ND1 HIS   110      94.550  43.909  28.945  1.00 19.60           N  
ATOM  13698  CD2 HIS   110      94.705  41.843  28.259  1.00 22.76           C  
ATOM  13699  CE1 HIS   110      95.839  43.643  28.780  1.00 20.17           C  
ATOM  13700  NE2 HIS   110      95.958  42.394  28.373  1.00 21.32           N  
ATOM  13701  N   LEU   111      93.330  41.821  31.669  1.00 16.38           N  
ATOM  13702  CA  LEU   111      93.763  40.836  32.657  1.00 16.96           C  
ATOM  13703  C   LEU   111      92.924  40.851  33.932  1.00 17.46           C  
ATOM  13704  O   LEU   111      92.575  39.786  34.492  1.00 19.02           O  
ATOM  13705  CB  LEU   111      95.239  41.050  32.982  1.00 17.06           C  
ATOM  13706  CG  LEU   111      96.187  40.875  31.779  1.00 17.72           C  
ATOM  13707  CD1 LEU   111      97.635  40.909  32.274  1.00 21.15           C  
ATOM  13708  CD2 LEU   111      95.918  39.613  30.974  1.00 21.14           C  
ATOM  13709  N   VAL   112      92.592  42.051  34.377  1.00 16.80           N  
ATOM  13710  CA  VAL   112      91.777  42.181  35.584  1.00 16.34           C  
ATOM  13711  C   VAL   112      90.397  41.535  35.335  1.00 16.45           C  
ATOM  13712  O   VAL   112      89.895  40.762  36.156  1.00 17.06           O  
ATOM  13713  CB  VAL   112      91.648  43.658  36.010  1.00 16.03           C  
ATOM  13714  CG1 VAL   112      90.570  43.824  37.097  1.00 14.54           C  
ATOM  13715  CG2 VAL   112      93.046  44.189  36.451  1.00 14.52           C  
ATOM  13716  N   ILE   113      89.783  41.862  34.211  1.00 16.33           N  
ATOM  13717  CA  ILE   113      88.418  41.383  33.939  1.00 16.57           C  
ATOM  13718  C   ILE   113      88.426  39.871  33.602  1.00 17.38           C  
ATOM  13719  O   ILE   113      87.418  39.207  33.835  1.00 17.79           O  
ATOM  13720  CB  ILE   113      87.684  42.255  32.877  1.00 16.97           C  
ATOM  13721  CG1 ILE   113      87.591  43.715  33.353  1.00 16.42           C  
ATOM  13722  CG2 ILE   113      86.275  41.686  32.506  1.00 16.23           C  
ATOM  13723  CD1 ILE   113      86.973  43.943  34.754  1.00 15.38           C  
ATOM  13724  N   ASN   114      89.573  39.326  33.152  1.00 17.62           N  
ATOM  13725  CA  ASN   114      89.721  37.861  33.017  1.00 18.16           C  
ATOM  13726  C   ASN   114      89.370  37.165  34.320  1.00 18.57           C  
ATOM  13727  O   ASN   114      88.867  36.056  34.301  1.00 19.99           O  
ATOM  13728  CB  ASN   114      91.130  37.469  32.547  1.00 18.52           C  
ATOM  13729  CG  ASN   114      91.406  37.829  31.083  1.00 20.10           C  
ATOM  13730  OD1 ASN   114      90.494  38.167  30.316  1.00 22.14           O  
ATOM  13731  ND2 ASN   114      92.665  37.744  30.689  1.00 20.05           N  
ATOM  13732  N   GLY   115      89.585  37.808  35.469  1.00 18.91           N  
ATOM  13733  CA  GLY   115      89.088  37.293  36.757  1.00 19.18           C  
ATOM  13734  C   GLY   115      87.609  36.931  36.679  1.00 19.79           C  
ATOM  13735  O   GLY   115      87.233  35.782  36.939  1.00 21.14           O  
ATOM  13736  N   ALA   116      86.771  37.891  36.267  1.00 19.18           N  
ATOM  13737  CA  ALA   116      85.331  37.638  36.074  1.00 18.73           C  
ATOM  13738  C   ALA   116      85.078  36.648  34.944  1.00 18.77           C  
ATOM  13739  O   ALA   116      84.318  35.704  35.117  1.00 18.13           O  
ATOM  13740  CB  ALA   116      84.563  38.940  35.818  1.00 17.60           C  
ATOM  13741  N   SER   117      85.690  36.872  33.792  1.00 19.29           N  
ATOM  13742  CA  SER   117      85.366  36.092  32.582  1.00 20.10           C  
ATOM  13743  C   SER   117      85.670  34.595  32.784  1.00 20.77           C  
ATOM  13744  O   SER   117      84.865  33.722  32.435  1.00 21.97           O  
ATOM  13745  CB  SER   117      86.103  36.640  31.358  1.00 19.41           C  
ATOM  13746  OG  SER   117      85.662  37.947  31.006  1.00 19.65           O  
ATOM  13747  N   ASN   118      86.810  34.313  33.389  1.00 21.80           N  
ATOM  13748  CA  ASN   118      87.247  32.938  33.669  1.00 21.92           C  
ATOM  13749  C   ASN   118      86.341  32.220  34.666  1.00 22.29           C  
ATOM  13750  O   ASN   118      86.014  31.026  34.477  1.00 23.85           O  
ATOM  13751  CB  ASN   118      88.672  32.936  34.193  1.00 22.14           C  
ATOM  13752  CG  ASN   118      89.692  33.319  33.143  1.00 23.36           C  
ATOM  13753  OD1 ASN   118      89.434  33.295  31.932  1.00 27.40           O  
ATOM  13754  ND2 ASN   118      90.877  33.671  33.606  1.00 27.49           N  
ATOM  13755  N   LEU   119      85.917  32.940  35.707  1.00 22.44           N  
ATOM  13756  CA  LEU   119      85.007  32.396  36.709  1.00 22.17           C  
ATOM  13757  C   LEU   119      83.654  32.058  36.071  1.00 22.24           C  
ATOM  13758  O   LEU   119      83.123  30.945  36.218  1.00 21.77           O  
ATOM  13759  CB  LEU   119      84.863  33.385  37.882  1.00 21.87           C  
ATOM  13760  CG  LEU   119      83.954  32.950  39.040  1.00 21.57           C  
ATOM  13761  CD1 LEU   119      84.343  33.550  40.394  1.00 22.43           C  
ATOM  13762  CD2 LEU   119      82.466  33.213  38.687  1.00 19.84           C  
ATOM  13763  N   ILE   120      83.100  33.014  35.340  1.00 22.68           N  
ATOM  13764  CA  ILE   120      81.797  32.834  34.691  1.00 23.03           C  
ATOM  13765  C   ILE   120      81.822  31.671  33.672  1.00 22.73           C  
ATOM  13766  O   ILE   120      80.921  30.827  33.672  1.00 22.74           O  
ATOM  13767  CB  ILE   120      81.304  34.189  34.057  1.00 22.50           C  
ATOM  13768  CG1 ILE   120      80.907  35.152  35.199  1.00 23.42           C  
ATOM  13769  CG2 ILE   120      80.119  33.969  33.092  1.00 23.23           C  
ATOM  13770  CD1 ILE   120      80.713  36.598  34.811  1.00 24.45           C  
ATOM  13771  N   ALA   121      82.859  31.598  32.846  1.00 22.93           N  
ATOM  13772  CA  ALA   121      82.995  30.525  31.867  1.00 23.71           C  
ATOM  13773  C   ALA   121      83.172  29.164  32.552  1.00 24.46           C  
ATOM  13774  O   ALA   121      82.589  28.167  32.118  1.00 24.40           O  
ATOM  13775  CB  ALA   121      84.153  30.806  30.923  1.00 24.16           C  
ATOM  13776  N   THR   122      83.934  29.146  33.646  1.00 25.07           N  
ATOM  13777  CA  THR   122      84.155  27.929  34.423  1.00 25.52           C  
ATOM  13778  C   THR   122      82.873  27.370  35.045  1.00 25.94           C  
ATOM  13779  O   THR   122      82.621  26.176  34.942  1.00 27.29           O  
ATOM  13780  CB  THR   122      85.229  28.151  35.493  1.00 25.67           C  
ATOM  13781  OG1 THR   122      86.465  28.470  34.828  1.00 25.67           O  
ATOM  13782  CG2 THR   122      85.404  26.905  36.403  1.00 25.84           C  
ATOM  13783  N   VAL   123      82.070  28.205  35.692  1.00 25.64           N  
ATOM  13784  CA  VAL   123      80.892  27.707  36.398  1.00 25.47           C  
ATOM  13785  C   VAL   123      79.727  27.416  35.437  1.00 25.14           C  
ATOM  13786  O   VAL   123      78.923  26.530  35.706  1.00 25.86           O  
ATOM  13787  CB  VAL   123      80.457  28.640  37.539  1.00 25.42           C  
ATOM  13788  CG1 VAL   123      81.594  28.801  38.558  1.00 25.65           C  
ATOM  13789  CG2 VAL   123      79.991  29.985  37.025  1.00 25.96           C  
ATOM  13790  N   LEU   124      79.648  28.132  34.316  1.00 25.53           N  
ATOM  13791  CA  LEU   124      78.543  27.974  33.358  1.00 25.86           C  
ATOM  13792  C   LEU   124      78.893  27.133  32.121  1.00 26.58           C  
ATOM  13793  O   LEU   124      77.992  26.702  31.399  1.00 27.85           O  
ATOM  13794  CB  LEU   124      78.016  29.354  32.906  1.00 25.67           C  
ATOM  13795  CG  LEU   124      77.392  30.242  34.005  1.00 25.75           C  
ATOM  13796  CD1 LEU   124      76.923  31.620  33.473  1.00 24.79           C  
ATOM  13797  CD2 LEU   124      76.239  29.529  34.730  1.00 24.67           C  
ATOM  13798  N   GLY   125      80.171  26.905  31.855  1.00 26.92           N  
ATOM  13799  CA  GLY   125      80.601  26.262  30.617  1.00 27.47           C  
ATOM  13800  C   GLY   125      80.400  27.153  29.401  1.00 28.59           C  
ATOM  13801  O   GLY   125      80.450  28.395  29.501  1.00 27.96           O  
ATOM  13802  N   GLU   126      80.145  26.533  28.247  1.00 29.57           N  
ATOM  13803  CA  GLU   126      80.046  27.272  26.987  1.00 29.15           C  
ATOM  13804  C   GLU   126      79.064  28.438  27.036  1.00 28.94           C  
ATOM  13805  O   GLU   126      79.378  29.497  26.491  1.00 29.44           O  
ATOM  13806  CB  GLU   126      79.695  26.340  25.813  1.00 31.00           C  
ATOM  13807  CG  GLU   126      79.198  27.036  24.521  1.00 32.78           C  
ATOM  13808  CD  GLU   126      80.275  27.849  23.846  1.00 39.95           C  
ATOM  13809  OE1 GLU   126      81.484  27.537  24.067  1.00 43.72           O  
ATOM  13810  OE2 GLU   126      79.914  28.797  23.096  1.00 44.33           O  
ATOM  13811  N   PRO   127      77.872  28.252  27.641  1.00 28.35           N  
ATOM  13812  CA  PRO   127      76.944  29.395  27.735  1.00 27.52           C  
ATOM  13813  C   PRO   127      77.493  30.606  28.480  1.00 26.17           C  
ATOM  13814  O   PRO   127      76.951  31.708  28.316  1.00 25.23           O  
ATOM  13815  CB  PRO   127      75.769  28.854  28.541  1.00 27.48           C  
ATOM  13816  CG  PRO   127      75.825  27.360  28.369  1.00 28.37           C  
ATOM  13817  CD  PRO   127      77.274  27.013  28.195  1.00 29.33           C  
ATOM  13818  N   GLY   128      78.509  30.381  29.316  1.00 24.90           N  
ATOM  13819  CA  GLY   128      79.160  31.456  30.029  1.00 24.87           C  
ATOM  13820  C   GLY   128      80.076  32.338  29.192  1.00 24.95           C  
ATOM  13821  O   GLY   128      80.490  33.405  29.683  1.00 25.60           O  
ATOM  13822  N   ARG   129      80.434  31.920  27.974  1.00 24.08           N  
ATOM  13823  CA  ARG   129      81.368  32.698  27.159  1.00 24.96           C  
ATOM  13824  C   ARG   129      80.614  33.880  26.582  1.00 23.19           C  
ATOM  13825  O   ARG   129      79.509  33.733  26.062  1.00 23.19           O  
ATOM  13826  CB  ARG   129      81.996  31.866  26.065  1.00 25.42           C  
ATOM  13827  CG  ARG   129      82.821  30.711  26.608  1.00 27.86           C  
ATOM  13828  CD  ARG   129      83.309  29.877  25.472  1.00 29.98           C  
ATOM  13829  NE  ARG   129      84.510  30.430  24.867  1.00 34.49           N  
ATOM  13830  CZ  ARG   129      84.825  30.292  23.581  1.00 36.05           C  
ATOM  13831  NH1 ARG   129      84.003  29.656  22.751  1.00 39.31           N  
ATOM  13832  NH2 ARG   129      85.952  30.809  23.108  1.00 35.44           N  
ATOM  13833  N   HIS   130      81.207  35.062  26.690  1.00 21.17           N  
ATOM  13834  CA  HIS   130      80.479  36.305  26.497  1.00 19.81           C  
ATOM  13835  C   HIS   130      81.292  37.340  25.734  1.00 18.95           C  
ATOM  13836  O   HIS   130      82.515  37.310  25.762  1.00 19.32           O  
ATOM  13837  CB  HIS   130      80.174  36.874  27.875  1.00 19.15           C  
ATOM  13838  CG  HIS   130      81.373  36.896  28.779  1.00 19.27           C  
ATOM  13839  ND1 HIS   130      81.715  35.823  29.575  1.00 18.83           N  
ATOM  13840  CD2 HIS   130      82.352  37.826  28.960  1.00 18.82           C  
ATOM  13841  CE1 HIS   130      82.841  36.093  30.215  1.00 19.50           C  
ATOM  13842  NE2 HIS   130      83.245  37.304  29.863  1.00 18.38           N  
ATOM  13843  N   ALA   131      80.591  38.238  25.056  1.00 18.23           N  
ATOM  13844  CA  ALA   131      81.198  39.483  24.562  1.00 17.93           C  
ATOM  13845  C   ALA   131      81.615  40.331  25.788  1.00 17.63           C  
ATOM  13846  O   ALA   131      81.145  40.128  26.900  1.00 18.26           O  
ATOM  13847  CB  ALA   131      80.243  40.256  23.664  1.00 17.85           C  
ATOM  13848  N   ARG   132      82.489  41.306  25.575  1.00 18.24           N  
ATOM  13849  CA  ARG   132      83.035  42.036  26.695  1.00 18.04           C  
ATOM  13850  C   ARG   132      83.617  43.385  26.284  1.00 17.43           C  
ATOM  13851  O   ARG   132      84.088  43.565  25.163  1.00 16.62           O  
ATOM  13852  CB  ARG   132      84.181  41.242  27.282  1.00 17.74           C  
ATOM  13853  CG  ARG   132      84.379  41.473  28.719  1.00 21.52           C  
ATOM  13854  CD  ARG   132      85.559  40.622  29.271  1.00 20.37           C  
ATOM  13855  NE  ARG   132      86.903  41.031  28.837  1.00 22.76           N  
ATOM  13856  CZ  ARG   132      88.019  40.471  29.328  1.00 21.32           C  
ATOM  13857  NH1 ARG   132      87.918  39.544  30.236  1.00 20.78           N  
ATOM  13858  NH2 ARG   132      89.223  40.856  28.939  1.00 22.78           N  
ATOM  13859  N   ALA   133      83.650  44.285  27.244  1.00 16.82           N  
ATOM  13860  CA  ALA   133      84.489  45.509  27.180  1.00 17.17           C  
ATOM  13861  C   ALA   133      85.251  45.582  28.508  1.00 16.48           C  
ATOM  13862  O   ALA   133      84.736  45.177  29.538  1.00 16.92           O  
ATOM  13863  CB  ALA   133      83.642  46.745  26.979  1.00 17.02           C  
ATOM  13864  N   ALA   134      86.494  46.049  28.468  1.00 16.84           N  
ATOM  13865  CA  ALA   134      87.303  46.207  29.665  1.00 16.59           C  
ATOM  13866  C   ALA   134      87.964  47.583  29.548  1.00 16.64           C  
ATOM  13867  O   ALA   134      88.695  47.845  28.578  1.00 17.05           O  
ATOM  13868  CB  ALA   134      88.348  45.119  29.805  1.00 17.16           C  
ATOM  13869  N   VAL   135      87.689  48.463  30.496  1.00 16.16           N  
ATOM  13870  CA  VAL   135      88.099  49.863  30.393  1.00 15.33           C  
ATOM  13871  C   VAL   135      88.602  50.422  31.715  1.00 15.04           C  
ATOM  13872  O   VAL   135      88.202  49.980  32.779  1.00 16.55           O  
ATOM  13873  CB  VAL   135      86.942  50.718  29.835  1.00 15.27           C  
ATOM  13874  CG1 VAL   135      86.621  50.279  28.369  1.00 15.28           C  
ATOM  13875  CG2 VAL   135      85.715  50.631  30.750  1.00 18.02           C  
ATOM  13876  N   GLY   136      89.451  51.440  31.644  1.00 14.42           N  
ATOM  13877  CA  GLY   136      90.007  52.072  32.833  1.00 14.05           C  
ATOM  13878  C   GLY   136      89.283  53.347  33.238  1.00 14.66           C  
ATOM  13879  O   GLY   136      89.192  54.307  32.461  1.00 16.32           O  
ATOM  13880  N   MET   137      88.838  53.366  34.492  1.00 15.74           N  
ATOM  13881  CA  MET   137      88.019  54.428  35.067  1.00 15.53           C  
ATOM  13882  C   MET   137      88.883  55.286  36.016  1.00 14.55           C  
ATOM  13883  O   MET   137      89.870  54.808  36.569  1.00 14.21           O  
ATOM  13884  CB  MET   137      86.856  53.860  35.881  1.00 17.67           C  
ATOM  13885  CG  MET   137      86.263  52.643  35.390  1.00 23.71           C  
ATOM  13886  SD  MET   137      85.665  52.752  33.523  1.00 32.58          SE  
ATOM  13887  CE  MET   137      84.716  54.461  33.938  1.00 19.25           C  
ATOM  13888  N   ALA   138      88.476  56.527  36.234  1.00 13.88           N  
ATOM  13889  CA  ALA   138      89.141  57.440  37.178  1.00 14.06           C  
ATOM  13890  C   ALA   138      88.955  56.936  38.616  1.00 14.04           C  
ATOM  13891  O   ALA   138      89.862  57.017  39.449  1.00 13.62           O  
ATOM  13892  CB  ALA   138      88.610  58.875  37.047  1.00 13.96           C  
ATOM  13893  N   SER   139      87.774  56.379  38.876  1.00 14.58           N  
ATOM  13894  CA  SER   139      87.388  55.917  40.210  1.00 15.14           C  
ATOM  13895  C   SER   139      85.992  55.291  40.117  1.00 14.88           C  
ATOM  13896  O   SER   139      85.324  55.457  39.108  1.00 14.48           O  
ATOM  13897  CB  SER   139      87.394  57.083  41.230  1.00 15.80           C  
ATOM  13898  OG  SER   139      86.720  58.247  40.755  1.00 16.73           O  
ATOM  13899  N   LEU   140      85.553  54.651  41.200  1.00 15.44           N  
ATOM  13900  CA  LEU   140      84.237  53.954  41.240  1.00 15.36           C  
ATOM  13901  C   LEU   140      83.547  54.180  42.597  1.00 15.58           C  
ATOM  13902  O   LEU   140      84.208  54.523  43.587  1.00 15.56           O  
ATOM  13903  CB  LEU   140      84.409  52.450  40.962  1.00 15.93           C  
ATOM  13904  CG  LEU   140      84.909  52.035  39.582  1.00 15.60           C  
ATOM  13905  CD1 LEU   140      85.286  50.549  39.605  1.00 15.22           C  
ATOM  13906  CD2 LEU   140      83.852  52.382  38.482  1.00 15.08           C  
ATOM  13907  N   PRO   141      82.211  54.021  42.644  1.00 15.44           N  
ATOM  13908  CA  PRO   141      81.453  54.136  43.911  1.00 16.14           C  
ATOM  13909  C   PRO   141      82.110  53.334  45.044  1.00 15.92           C  
ATOM  13910  O   PRO   141      82.581  52.199  44.826  1.00 16.30           O  
ATOM  13911  CB  PRO   141      80.075  53.575  43.548  1.00 15.94           C  
ATOM  13912  CG  PRO   141      79.935  53.831  42.101  1.00 15.45           C  
ATOM  13913  CD  PRO   141      81.316  53.727  41.508  1.00 15.64           C  
ATOM  13914  N   PHE   142      82.170  53.939  46.230  1.00 16.28           N  
ATOM  13915  CA  PHE   142      82.733  53.297  47.430  1.00 17.01           C  
ATOM  13916  C   PHE   142      84.216  52.930  47.312  1.00 17.24           C  
ATOM  13917  O   PHE   142      84.742  52.110  48.073  1.00 17.44           O  
ATOM  13918  CB  PHE   142      81.928  52.059  47.803  1.00 18.58           C  
ATOM  13919  CG  PHE   142      80.466  52.336  47.998  1.00 18.46           C  
ATOM  13920  CD1 PHE   142      80.015  52.864  49.180  1.00 21.60           C  
ATOM  13921  CD2 PHE   142      79.559  52.097  46.970  1.00 21.58           C  
ATOM  13922  CE1 PHE   142      78.682  53.137  49.358  1.00 21.61           C  
ATOM  13923  CE2 PHE   142      78.215  52.370  47.137  1.00 22.90           C  
ATOM  13924  CZ  PHE   142      77.776  52.887  48.332  1.00 22.64           C  
ATOM  13925  N   ASN   143      84.878  53.560  46.330  1.00 16.87           N  
ATOM  13926  CA  ASN   143      86.266  53.270  45.999  1.00 15.70           C  
ATOM  13927  C   ASN   143      86.510  51.824  45.587  1.00 15.55           C  
ATOM  13928  O   ASN   143      87.609  51.322  45.736  1.00 16.70           O  
ATOM  13929  CB  ASN   143      87.154  53.677  47.176  1.00 16.04           C  
ATOM  13930  CG  ASN   143      88.588  53.911  46.779  1.00 14.10           C  
ATOM  13931  OD1 ASN   143      88.914  54.151  45.608  1.00 17.82           O  
ATOM  13932  ND2 ASN   143      89.478  53.852  47.779  1.00 17.12           N  
ATOM  13933  N   ALA   144      85.488  51.161  45.023  1.00 15.75           N  
ATOM  13934  CA  ALA   144      85.636  49.826  44.460  1.00 15.29           C  
ATOM  13935  C   ALA   144      86.735  49.841  43.411  1.00 15.28           C  
ATOM  13936  O   ALA   144      86.847  50.796  42.624  1.00 14.89           O  
ATOM  13937  CB  ALA   144      84.350  49.361  43.831  1.00 15.92           C  
ATOM  13938  N   SER   145      87.538  48.785  43.403  1.00 15.49           N  
ATOM  13939  CA  SER   145      88.570  48.650  42.372  1.00 15.37           C  
ATOM  13940  C   SER   145      87.975  48.256  41.005  1.00 15.28           C  
ATOM  13941  O   SER   145      88.503  48.615  39.973  1.00 14.24           O  
ATOM  13942  CB  SER   145      89.687  47.688  42.825  1.00 16.67           C  
ATOM  13943  OG  SER   145      90.313  48.168  44.001  1.00 16.25           O  
ATOM  13944  N   VAL   146      86.877  47.516  41.017  1.00 14.87           N  
ATOM  13945  CA  VAL   146      86.230  47.021  39.809  1.00 15.23           C  
ATOM  13946  C   VAL   146      84.712  47.079  40.031  1.00 15.41           C  
ATOM  13947  O   VAL   146      84.210  46.874  41.153  1.00 15.54           O  
ATOM  13948  CB  VAL   146      86.670  45.536  39.456  1.00 15.05           C  
ATOM  13949  CG1 VAL   146      86.085  45.052  38.089  1.00 15.94           C  
ATOM  13950  CG2 VAL   146      88.232  45.354  39.571  1.00 14.96           C  
ATOM  13951  N   GLU   147      84.007  47.398  38.957  1.00 15.93           N  
ATOM  13952  CA  GLU   147      82.535  47.312  38.856  1.00 15.92           C  
ATOM  13953  C   GLU   147      82.252  46.607  37.524  1.00 15.93           C  
ATOM  13954  O   GLU   147      82.884  46.924  36.508  1.00 15.74           O  
ATOM  13955  CB  GLU   147      81.892  48.684  38.856  1.00 16.26           C  
ATOM  13956  CG  GLU   147      80.408  48.720  38.569  1.00 16.79           C  
ATOM  13957  CD  GLU   147      79.814  50.141  38.566  1.00 17.90           C  
ATOM  13958  OE1 GLU   147      80.472  51.032  39.106  1.00 16.37           O  
ATOM  13959  OE2 GLU   147      78.691  50.362  38.032  1.00 21.33           O  
ATOM  13960  N   ILE   148      81.306  45.667  37.535  1.00 16.14           N  
ATOM  13961  CA  ILE   148      80.988  44.895  36.342  1.00 15.98           C  
ATOM  13962  C   ILE   148      79.476  44.740  36.189  1.00 16.11           C  
ATOM  13963  O   ILE   148      78.794  44.315  37.129  1.00 16.86           O  
ATOM  13964  CB  ILE   148      81.601  43.456  36.330  1.00 16.86           C  
ATOM  13965  CG1 ILE   148      83.118  43.455  36.615  1.00 15.12           C  
ATOM  13966  CG2 ILE   148      81.313  42.831  34.929  1.00 17.11           C  
ATOM  13967  CD1 ILE   148      83.783  42.069  36.538  1.00 16.31           C  
ATOM  13968  N   ASP   149      78.974  45.086  35.011  1.00 15.24           N  
ATOM  13969  CA  ASP   149      77.541  44.879  34.705  1.00 16.84           C  
ATOM  13970  C   ASP   149      77.406  43.805  33.638  1.00 16.71           C  
ATOM  13971  O   ASP   149      78.409  43.329  33.087  1.00 19.31           O  
ATOM  13972  CB  ASP   149      76.857  46.181  34.332  1.00 17.25           C  
ATOM  13973  CG  ASP   149      77.178  46.666  32.924  1.00 18.92           C  
ATOM  13974  OD1 ASP   149      77.717  45.917  32.076  1.00 21.61           O  
ATOM  13975  OD2 ASP   149      76.901  47.857  32.671  1.00 23.19           O  
ATOM  13976  N   ALA   150      76.170  43.403  33.348  1.00 17.03           N  
ATOM  13977  CA  ALA   150      75.979  42.220  32.491  1.00 17.32           C  
ATOM  13978  C   ALA   150      74.653  42.251  31.760  1.00 17.32           C  
ATOM  13979  O   ALA   150      73.681  42.805  32.264  1.00 17.16           O  
ATOM  13980  CB  ALA   150      76.071  40.922  33.290  1.00 16.29           C  
ATOM  13981  N   ILE   151      74.636  41.600  30.597  1.00 17.86           N  
ATOM  13982  CA  ILE   151      73.385  41.298  29.877  1.00 18.64           C  
ATOM  13983  C   ILE   151      73.400  39.782  29.684  1.00 18.58           C  
ATOM  13984  O   ILE   151      74.408  39.216  29.252  1.00 16.46           O  
ATOM  13985  CB  ILE   151      73.295  41.986  28.517  1.00 18.12           C  
ATOM  13986  CG1 ILE   151      73.401  43.521  28.639  1.00 18.70           C  
ATOM  13987  CG2 ILE   151      72.005  41.638  27.832  1.00 18.34           C  
ATOM  13988  CD1 ILE   151      73.738  44.160  27.326  1.00 21.12           C  
ATOM  13989  N   VAL   152      72.296  39.127  30.014  1.00 19.65           N  
ATOM  13990  CA  VAL   152      72.245  37.677  30.062  1.00 20.85           C  
ATOM  13991  C   VAL   152      70.965  37.236  29.312  1.00 21.79           C  
ATOM  13992  O   VAL   152      69.875  37.732  29.595  1.00 23.25           O  
ATOM  13993  CB  VAL   152      72.234  37.157  31.530  1.00 20.51           C  
ATOM  13994  CG1 VAL   152      72.116  35.632  31.552  1.00 20.98           C  
ATOM  13995  CG2 VAL   152      73.472  37.627  32.314  1.00 19.78           C  
ATOM  13996  N   GLU   153      71.111  36.364  28.337  1.00 22.65           N  
ATOM  13997  CA  GLU   153      69.931  35.789  27.677  1.00 23.65           C  
ATOM  13998  C   GLU   153      69.416  34.643  28.566  1.00 23.87           C  
ATOM  13999  O   GLU   153      70.189  33.746  28.945  1.00 23.66           O  
ATOM  14000  CB  GLU   153      70.264  35.289  26.289  1.00 23.38           C  
ATOM  14001  CG  GLU   153      69.041  34.729  25.582  1.00 23.77           C  
ATOM  14002  CD  GLU   153      69.403  34.097  24.286  1.00 25.44           C  
ATOM  14003  OE1 GLU   153      69.856  34.818  23.377  1.00 28.66           O  
ATOM  14004  OE2 GLU   153      69.232  32.859  24.181  1.00 33.72           O  
ATOM  14005  N   ILE   154      68.116  34.683  28.885  1.00 25.68           N  
ATOM  14006  CA  ILE   154      67.500  33.757  29.854  1.00 26.78           C  
ATOM  14007  C   ILE   154      66.314  33.035  29.242  1.00 30.18           C  
ATOM  14008  O   ILE   154      65.740  33.496  28.257  1.00 29.70           O  
ATOM  14009  CB  ILE   154      67.039  34.458  31.150  1.00 26.75           C  
ATOM  14010  CG1 ILE   154      66.053  35.594  30.860  1.00 26.10           C  
ATOM  14011  CG2 ILE   154      68.259  34.960  31.966  1.00 25.49           C  
ATOM  14012  CD1 ILE   154      65.428  36.242  32.107  1.00 26.67           C  
ATOM  14013  N   ASP   155      65.987  31.894  29.838  1.00 34.08           N  
ATOM  14014  CA  ASP   155      64.750  31.169  29.526  1.00 38.39           C  
ATOM  14015  C   ASP   155      63.533  31.867  30.087  1.00 39.81           C  
ATOM  14016  O   ASP   155      63.331  31.884  31.303  1.00 41.42           O  
ATOM  14017  CB  ASP   155      64.825  29.774  30.112  1.00 38.89           C  
ATOM  14018  CG  ASP   155      65.674  28.876  29.280  1.00 42.84           C  
ATOM  14019  OD1 ASP   155      65.266  28.669  28.107  1.00 47.96           O  
ATOM  14020  OD2 ASP   155      66.738  28.398  29.774  1.00 48.12           O  
ATOM  14021  N   VAL   156      62.721  32.426  29.191  1.00 42.19           N  
ATOM  14022  CA  VAL   156      61.502  33.142  29.551  1.00 42.99           C  
ATOM  14023  C   VAL   156      60.299  32.349  29.037  1.00 44.31           C  
ATOM  14024  O   VAL   156      60.430  31.553  28.090  1.00 45.98           O  
ATOM  14025  CB  VAL   156      61.529  34.588  28.958  1.00 43.73           C  
ATOM  14026  CG1 VAL   156      60.139  35.038  28.439  1.00 44.09           C  
ATOM  14027  CG2 VAL   156      62.095  35.575  29.986  1.00 43.38           C  
END
