
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  225 ( 1718),  selected  225 , name 1i52_A
# Molecule2: number of CA atoms  178 ( 1356),  selected  178 , name T0420.pdb
# PARAMETERS: 1i52_A.T0420.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H     5_A      -       -           -
LGA    L     6_A      M       1          0.954
LGA    D     7_A      N       2          2.775
LGA    V     8_A      I       3          1.439
LGA    C     9_A      G       4          0.776
LGA    A    10_A      V       5          0.194
LGA    V    11_A      I       6          0.374
LGA    V    12_A      I       7          1.022
LGA    P    13_A      L       8          0.942
LGA    A    14_A      A       9          0.448
LGA    A    15_A      A      10          0.568
LGA    G    16_A      G      11          1.498
LGA    -       -      E      12           -
LGA    -       -      G      13           -
LGA    -       -      K      14           -
LGA    F    17_A      R      15          5.302
LGA    G    18_A      F      16          2.716
LGA    R    19_A      -       -           -
LGA    R    20_A      -       -           -
LGA    M    21_A      -       -           -
LGA    Q    22_A      -       -           -
LGA    T    23_A      -       -           -
LGA    E    24_A      -       -           -
LGA    C    25_A      G      17           #
LGA    P    26_A      G      18          3.766
LGA    -       -      D      19           -
LGA    K    27_A      K      20          1.897
LGA    Q    28_A      L      21          1.684
LGA    Y    29_A      L      22          1.637
LGA    L    30_A      A      23          1.148
LGA    S    31_A      K      24          1.027
LGA    I    32_A      I      25          1.043
LGA    G    33_A      D      26          2.102
LGA    N    34_A      N      27          2.659
LGA    Q    35_A      T      28          1.894
LGA    T    36_A      P      29          1.299
LGA    I    37_A      I      30          1.041
LGA    L    38_A      I      31          0.983
LGA    E    39_A      M      32          1.130
LGA    H    40_A      R      33          1.101
LGA    S    41_A      T      34          1.022
LGA    V    42_A      I      35          0.883
LGA    H    43_A      R      36          0.966
LGA    A    44_A      I      37          0.352
LGA    L    45_A      Y      38          0.837
LGA    L    46_A      G      39          1.584
LGA    A    47_A      D      40          5.074
LGA    H    48_A      -       -           -
LGA    P    49_A      -       -           -
LGA    R    50_A      -       -           -
LGA    V    51_A      -       -           -
LGA    K    52_A      L      41          3.603
LGA    R    53_A      E      42          1.364
LGA    V    54_A      K      43          0.790
LGA    V    55_A      I      44          1.155
LGA    I    56_A      I      45          0.927
LGA    A    57_A      I      46          0.873
LGA    I    58_A      V      47          0.789
LGA    S    59_A      G      48          0.712
LGA    P    60_A      K      49          5.484
LGA    G    61_A      Y      50          5.391
LGA    D    62_A      V      51          1.690
LGA    S    63_A      N      52          0.213
LGA    R    64_A      E      53          1.663
LGA    F    65_A      M      54          2.069
LGA    A    66_A      L      55          1.752
LGA    Q    67_A      P      56          0.669
LGA    L    68_A      L      57          0.865
LGA    P    69_A      -       -           -
LGA    L    70_A      L      58          2.701
LGA    A    71_A      M      59          2.165
LGA    N    72_A      D      60          2.040
LGA    H    73_A      Q      61          3.668
LGA    P    74_A      -       -           -
LGA    Q    75_A      -       -           -
LGA    I    76_A      -       -           -
LGA    T    77_A      I      62          1.768
LGA    V    78_A      V      63          1.307
LGA    V    79_A      I      64          1.294
LGA    D    80_A      Y      65          2.419
LGA    G    81_A      N      66          3.305
LGA    -       -      P      67           -
LGA    -       -      F      68           -
LGA    G    82_A      W      69          2.035
LGA    D    83_A      N      70          2.956
LGA    -       -      E      71           -
LGA    E    84_A      G      72          1.788
LGA    R    85_A      I      73          1.972
LGA    A    86_A      S      74          2.214
LGA    D    87_A      T      75          1.861
LGA    S    88_A      S      76          1.322
LGA    V    89_A      L      77          1.228
LGA    L    90_A      K      78          1.263
LGA    A    91_A      L      79          1.100
LGA    G    92_A      G      80          1.144
LGA    L    93_A      L      81          0.829
LGA    K    94_A      R      82          1.432
LGA    A    95_A      F      83          1.929
LGA    A    96_A      F      84          2.352
LGA    G    97_A      K      85           #
LGA    D    98_A      D      86          3.573
LGA    A    99_A      Y      87          2.186
LGA    Q   100_A      D      88          1.619
LGA    W   101_A      A      89          1.403
LGA    V   102_A      V      90          0.666
LGA    L   103_A      L      91          0.397
LGA    V   104_A      V      92          0.535
LGA    H   105_A      A      93          0.789
LGA    D   106_A      L      94          0.831
LGA    A   107_A      G      95          0.687
LGA    A   108_A      D      96          0.988
LGA    R   109_A      M      97          0.962
LGA    P   110_A      P      98          0.460
LGA    C   111_A      F      99          1.123
LGA    L   112_A      V     100          1.478
LGA    H   113_A      T     101          1.576
LGA    Q   114_A      K     102          2.267
LGA    D   115_A      E     103          2.176
LGA    D   116_A      D     104          1.693
LGA    L   117_A      V     105          1.169
LGA    A   118_A      N     106          1.227
LGA    R   119_A      K     107          1.322
LGA    L   120_A      I     108          0.642
LGA    L   121_A      I     109          0.457
LGA    A   122_A      N     110          1.496
LGA    L   123_A      T     111          2.811
LGA    S   124_A      F     112          2.790
LGA    E   125_A      K     113          3.219
LGA    T   126_A      P     114          4.944
LGA    S   127_A      N     115          3.091
LGA    R   128_A      C     116          3.368
LGA    T   129_A      K     117          0.633
LGA    G   130_A      A     118          1.920
LGA    G   131_A      V     119          1.362
LGA    I   132_A      I     120          1.118
LGA    L   133_A      P     121          0.750
LGA    A   134_A      T     122          1.561
LGA    A   135_A      H     123          1.441
LGA    P   136_A      K     124          2.071
LGA    V   137_A      G     125          3.754
LGA    R   138_A      -       -           -
LGA    D   139_A      -       -           -
LGA    T   140_A      -       -           -
LGA    M   141_A      -       -           -
LGA    K   142_A      -       -           -
LGA    R   143_A      -       -           -
LGA    A   144_A      -       -           -
LGA    E   145_A      -       -           -
LGA    P   146_A      -       -           -
LGA    G   147_A      -       -           -
LGA    K   148_A      -       -           -
LGA    N   149_A      -       -           -
LGA    A   150_A      -       -           -
LGA    I   151_A      -       -           -
LGA    A   152_A      -       -           -
LGA    H   153_A      -       -           -
LGA    T   154_A      -       -           -
LGA    V   155_A      -       -           -
LGA    D   156_A      -       -           -
LGA    R   157_A      -       -           -
LGA    N   158_A      -       -           -
LGA    G   159_A      -       -           -
LGA    L   160_A      -       -           -
LGA    W   161_A      -       -           -
LGA    H   162_A      E     126          2.263
LGA    A   163_A      R     127          2.441
LGA    L   164_A      G     128          1.192
LGA    T   165_A      N     129          0.902
LGA    P   166_A      P     130          1.002
LGA    Q   167_A      V     131          0.476
LGA    F   168_A      L     132          0.499
LGA    F   169_A      I     133          1.695
LGA    P   170_A      S     134          1.419
LGA    R   171_A      K     135          3.466
LGA    E   172_A      -       -           -
LGA    L   173_A      S     136          2.850
LGA    L   174_A      L     137          3.304
LGA    H   175_A      F     138          2.586
LGA    D   176_A      N     139          1.322
LGA    C   177_A      E     140          1.263
LGA    L   178_A      I     141          1.667
LGA    T   179_A      E     142          2.335
LGA    R   180_A      K     143          2.543
LGA    A   181_A      L     144          4.030
LGA    L   182_A      R     145          2.945
LGA    N   183_A      G     146           #
LGA    E   184_A      D     147           -
LGA    G   185_A      -       -           -
LGA    A   186_A      -       -           -
LGA    T   187_A      -       -           -
LGA    I   188_A      V     148          3.834
LGA    T   189_A      G     149          4.645
LGA    D   190_A      -       -           -
LGA    E   191_A      A     150          2.402
LGA    A   192_A      R     151          3.865
LGA    S   193_A      V     152          2.654
LGA    A   194_A      I     153          1.386
LGA    L   195_A      L     154          3.553
LGA    E   196_A      N     155          3.207
LGA    Y   197_A      K     156          3.429
LGA    C   198_A      -       -           -
LGA    G   199_A      I     157          3.592
LGA    F   200_A      K     158          4.382
LGA    H   201_A      I     159          3.785
LGA    -       -      E     160           -
LGA    -       -      E     161           -
LGA    P   202_A      L     162          2.365
LGA    Q   203_A      C     163          1.984
LGA    L   204_A      F     164          2.018
LGA    V   205_A      I     165          1.590
LGA    E   206_A      E     166          1.435
LGA    G   207_A      C     167          1.516
LGA    R   208_A      S     168          1.257
LGA    A   209_A      E     169          1.530
LGA    D   210_A      G     170          3.588
LGA    N   211_A      V     171          3.571
LGA    -       -      L     172           -
LGA    I   212_A      I     173          1.237
LGA    K   213_A      D     174          0.609
LGA    V   214_A      I     175          0.771
LGA    T   215_A      D     176          1.528
LGA    R   216_A      K     177          5.989
LGA    P   217_A      -       -           -
LGA    E   218_A      -       -           -
LGA    D   219_A      K     178          2.478
LGA    L   220_A      -       -           -
LGA    A   221_A      -       -           -
LGA    L   222_A      -       -           -
LGA    A   223_A      -       -           -
LGA    E   224_A      -       -           -
LGA    F   225_A      -       -           -
LGA    Y   226_A      -       -           -
LGA    L   227_A      -       -           -
LGA    T   228_A      -       -           -
LGA    R   229_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  225  178    5.0    164    2.24    15.85     65.625     7.002

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.667102 * X  +  -0.533516 * Y  +   0.519938 * Z  +  35.201275
  Y_new =   0.681954 * X  +   0.156415 * Y  +  -0.714474 * Z  +  96.829460
  Z_new =   0.299857 * X  +   0.831201 * Y  +   0.468178 * Z  +  45.351768 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.057833   -2.083759  [ DEG:    60.6094   -119.3906 ]
  Theta =  -0.304543   -2.837050  [ DEG:   -17.4490   -162.5510 ]
  Phi   =   0.796407   -2.345186  [ DEG:    45.6308   -134.3692 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1i52_A                                        
REMARK     2: T0420.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1i52_A.T0420.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  225  178   5.0  164   2.24   15.85  65.625
REMARK  ---------------------------------------------------------- 
MOLECULE 1i52_A
HEADER    TRANSFERASE                             23-FEB-01   1I52              
TITLE     CRYSTAL STRUCTURE OF 4-DIPHOSPHOCYTIDYL-2-C-                          
TITLE    2 METHYLERYTHRITOL (CDP-ME) SYNTHASE (YGBP) INVOLVED IN                
TITLE    3 MEVALONATE INDEPENDENT ISOPRENOID BIOSYNTHESIS                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: 4-DIPHOSPHOCYTIDYL-2-C-METHYLERYTHRITOL SYNTHASE;          
COMPND   3 CHAIN: A;                                                            
COMPND   4 EC: 2.7.7.-;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: K12;                                                         
SOURCE   5 GENE: ISPD;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PHIS8                                     
KEYWDS    CYTIDYLYLTRANSFERASE, DEOXYXYLULOSE-5-PHOSPHATE PATHWAY               
KEYWDS   2 (DXP), ISOPRENOID BIOSYNTHESYS, MEP,                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.B.RICHARD,M.E.BOWMAN,W.KWIATKOWSKI,I.KANG,C.CHOW,M.LILLO,           
AUTHOR   2 D.E.CANE,J.P.NOEL                                                    
REVDAT   2   01-APR-03 1I52    1       JRNL                                     
REVDAT   1   11-JUL-01 1I52    0                                                
JRNL        AUTH   S.B.RICHARD,M.E.BOWMAN,W.KWIATKOWSKI,I.KANG,C.CHOW,          
JRNL        AUTH 2 A.M.LILLO,D.E.CANE,J.P.NOEL                                  
JRNL        TITL   STRUCTURE OF 4-DIPHOSPHOCYTIDYL-2-C-                         
JRNL        TITL 2 METHYLERYTHRITOL SYNTHETASE INVOLVED IN                      
JRNL        TITL 3 MEVALONATE- INDEPENDENT ISOPRENOID BIOSYNTHESIS.             
JRNL        REF    NAT.STRUCT.BIOL.              V.   8   641 2001              
JRNL        REFN   ASTM NSBIEW  US ISSN 1072-8368                               
REMARK   2 RESOLUTION. 1.50 ANGSTROMS.                                          
DBREF  1I52 A    1   236  UNP    Q46893   ISPD_ECOLI       1    236             
SEQRES   1 A  236  MET ALA THR THR HIS LEU ASP VAL CYS ALA VAL VAL PRO          
SEQRES   2 A  236  ALA ALA GLY PHE GLY ARG ARG MET GLN THR GLU CYS PRO          
SEQRES   3 A  236  LYS GLN TYR LEU SER ILE GLY ASN GLN THR ILE LEU GLU          
SEQRES   4 A  236  HIS SER VAL HIS ALA LEU LEU ALA HIS PRO ARG VAL LYS          
SEQRES   5 A  236  ARG VAL VAL ILE ALA ILE SER PRO GLY ASP SER ARG PHE          
SEQRES   6 A  236  ALA GLN LEU PRO LEU ALA ASN HIS PRO GLN ILE THR VAL          
SEQRES   7 A  236  VAL ASP GLY GLY ASP GLU ARG ALA ASP SER VAL LEU ALA          
SEQRES   8 A  236  GLY LEU LYS ALA ALA GLY ASP ALA GLN TRP VAL LEU VAL          
SEQRES   9 A  236  HIS ASP ALA ALA ARG PRO CYS LEU HIS GLN ASP ASP LEU          
SEQRES  10 A  236  ALA ARG LEU LEU ALA LEU SER GLU THR SER ARG THR GLY          
SEQRES  11 A  236  GLY ILE LEU ALA ALA PRO VAL ARG ASP THR MET LYS ARG          
SEQRES  12 A  236  ALA GLU PRO GLY LYS ASN ALA ILE ALA HIS THR VAL ASP          
SEQRES  13 A  236  ARG ASN GLY LEU TRP HIS ALA LEU THR PRO GLN PHE PHE          
SEQRES  14 A  236  PRO ARG GLU LEU LEU HIS ASP CYS LEU THR ARG ALA LEU          
SEQRES  15 A  236  ASN GLU GLY ALA THR ILE THR ASP GLU ALA SER ALA LEU          
SEQRES  16 A  236  GLU TYR CYS GLY PHE HIS PRO GLN LEU VAL GLU GLY ARG          
SEQRES  17 A  236  ALA ASP ASN ILE LYS VAL THR ARG PRO GLU ASP LEU ALA          
SEQRES  18 A  236  LEU ALA GLU PHE TYR LEU THR ARG THR ILE HIS GLN GLU          
SEQRES  19 A  236  ASN THR                                                      
HET     CA   2001       1                                                       
HET     MG   2002       1                                                       
HET    CTP   1001      29                                                       
HETNAM      CA CALCIUM ION                                                      
HETNAM      MG MAGNESIUM ION                                                    
HETNAM     CTP CYTIDINE-5'-TRIPHOSPHATE                                         
FORMUL   2   CA    CA 2+                                                        
FORMUL   3   MG    MG 2+                                                        
FORMUL   4  CTP    C9 H16 N3 O14 P3                                             
FORMUL   5  HOH   *328(H2 O)                                                    
CRYST1  130.564   47.074   38.105  90.00  93.78  90.00 C 1 2 1       4          
ATOM      1  N   HIS A   5      68.849 105.059  44.856  1.00 33.53           N  
ATOM      2  CA  HIS A   5      70.127 105.729  44.447  1.00 34.18           C  
ATOM      3  C   HIS A   5      70.742 106.613  45.544  1.00 32.68           C  
ATOM      4  O   HIS A   5      71.962 106.736  45.652  1.00 32.60           O  
ATOM      5  CB  HIS A   5      69.889 106.594  43.200  1.00 35.24           C  
ATOM      6  CG  HIS A   5      70.805 107.774  43.117  1.00 38.38           C  
ATOM      7  ND1 HIS A   5      72.175 107.644  43.018  1.00 38.89           N  
ATOM      8  CD2 HIS A   5      70.559 109.103  43.201  1.00 38.13           C  
ATOM      9  CE1 HIS A   5      72.731 108.841  43.049  1.00 38.97           C  
ATOM     10  NE2 HIS A   5      71.775 109.742  43.161  1.00 38.77           N  
ATOM     11  N   LEU A   6      69.885 107.222  46.350  1.00 30.43           N  
ATOM     12  CA  LEU A   6      70.321 108.133  47.396  1.00 27.00           C  
ATOM     13  C   LEU A   6      70.764 107.466  48.695  1.00 24.32           C  
ATOM     14  O   LEU A   6      71.161 108.143  49.634  1.00 21.45           O  
ATOM     15  CB  LEU A   6      69.206 109.150  47.677  1.00 29.48           C  
ATOM     16  CG  LEU A   6      68.818 110.093  46.524  1.00 30.28           C  
ATOM     17  CD1 LEU A   6      67.639 110.976  46.955  1.00 32.15           C  
ATOM     18  CD2 LEU A   6      69.999 110.965  46.144  1.00 31.38           C  
ATOM     19  N   ASP A   7      70.695 106.144  48.761  1.00 22.63           N  
ATOM     20  CA  ASP A   7      71.106 105.430  49.977  1.00 21.64           C  
ATOM     21  C   ASP A   7      72.633 105.486  50.110  1.00 21.19           C  
ATOM     22  O   ASP A   7      73.359 105.195  49.160  1.00 23.41           O  
ATOM     23  CB  ASP A   7      70.675 103.961  49.901  1.00 24.09           C  
ATOM     24  CG  ASP A   7      69.177 103.762  50.128  1.00 29.27           C  
ATOM     25  OD1 ASP A   7      68.397 104.717  49.969  1.00 28.00           O  
ATOM     26  OD2 ASP A   7      68.802 102.623  50.459  1.00 33.49           O  
ATOM     27  N   VAL A   8      73.108 105.877  51.286  1.00 16.96           N  
ATOM     28  CA  VAL A   8      74.546 105.966  51.563  1.00 14.86           C  
ATOM     29  C   VAL A   8      74.909 105.078  52.758  1.00 15.77           C  
ATOM     30  O   VAL A   8      74.137 104.978  53.727  1.00 15.00           O  
ATOM     31  CB  VAL A   8      74.929 107.423  51.969  1.00 13.47           C  
ATOM     32  CG1 VAL A   8      76.380 107.506  52.443  1.00 14.48           C  
ATOM     33  CG2 VAL A   8      74.715 108.330  50.780  1.00 15.37           C  
ATOM     34  N   CYS A   9      76.066 104.419  52.698  1.00 14.26           N  
ATOM     35  CA  CYS A   9      76.553 103.658  53.845  1.00 15.26           C  
ATOM     36  C   CYS A   9      77.805 104.404  54.340  1.00 16.26           C  
ATOM     37  O   CYS A   9      78.606 104.835  53.541  1.00 15.23           O  
ATOM     38  CB  CYS A   9      76.924 102.223  53.465  1.00 14.86           C  
ATOM     39  SG  CYS A   9      77.546 101.236  54.865  1.00 22.19           S  
ATOM     40  N   ALA A  10      77.939 104.586  55.643  1.00 14.22           N  
ATOM     41  CA  ALA A  10      79.133 105.239  56.189  1.00 13.55           C  
ATOM     42  C   ALA A  10      80.066 104.186  56.786  1.00 14.19           C  
ATOM     43  O   ALA A  10      79.611 103.138  57.266  1.00 15.23           O  
ATOM     44  CB  ALA A  10      78.750 106.214  57.239  1.00 14.73           C  
ATOM     45  N   VAL A  11      81.376 104.451  56.707  1.00 13.86           N  
ATOM     46  CA  VAL A  11      82.368 103.557  57.301  1.00 13.57           C  
ATOM     47  C   VAL A  11      83.200 104.448  58.233  1.00 12.82           C  
ATOM     48  O   VAL A  11      83.707 105.502  57.812  1.00 13.45           O  
ATOM     49  CB  VAL A  11      83.331 102.939  56.257  1.00 13.39           C  
ATOM     50  CG1 VAL A  11      84.458 102.185  56.998  1.00 15.35           C  
ATOM     51  CG2 VAL A  11      82.558 101.946  55.384  1.00 15.64           C  
ATOM     52  N   VAL A  12      83.329 104.030  59.487  1.00 12.09           N  
ATOM     53  CA  VAL A  12      84.081 104.776  60.492  1.00 13.11           C  
ATOM     54  C   VAL A  12      85.255 103.941  61.011  1.00 15.47           C  
ATOM     55  O   VAL A  12      85.046 102.982  61.758  1.00 16.01           O  
ATOM     56  CB  VAL A  12      83.149 105.141  61.695  1.00 14.52           C  
ATOM     57  CG1 VAL A  12      83.947 105.818  62.795  1.00 16.16           C  
ATOM     58  CG2 VAL A  12      82.034 106.093  61.225  1.00 15.33           C  
ATOM     59  N   PRO A  13      86.481 104.236  60.553  1.00 15.64           N  
ATOM     60  CA  PRO A  13      87.620 103.457  61.068  1.00 17.78           C  
ATOM     61  C   PRO A  13      87.837 103.905  62.522  1.00 18.27           C  
ATOM     62  O   PRO A  13      88.051 105.099  62.796  1.00 20.41           O  
ATOM     63  CB  PRO A  13      88.773 103.851  60.149  1.00 18.89           C  
ATOM     64  CG  PRO A  13      88.392 105.171  59.586  1.00 19.73           C  
ATOM     65  CD  PRO A  13      86.885 105.114  59.440  1.00 15.48           C  
ATOM     66  N   ALA A  14      87.751 102.953  63.449  1.00 17.96           N  
ATOM     67  CA  ALA A  14      87.876 103.239  64.870  1.00 17.87           C  
ATOM     68  C   ALA A  14      88.638 102.117  65.556  1.00 18.95           C  
ATOM     69  O   ALA A  14      88.326 101.743  66.685  1.00 17.54           O  
ATOM     70  CB  ALA A  14      86.483 103.365  65.489  1.00 19.46           C  
ATOM     71  N   ALA A  15      89.652 101.612  64.869  1.00 18.90           N  
ATOM     72  CA  ALA A  15      90.444 100.489  65.362  1.00 21.46           C  
ATOM     73  C   ALA A  15      91.813 100.899  65.884  1.00 24.88           C  
ATOM     74  O   ALA A  15      92.610 100.046  66.280  1.00 26.30           O  
ATOM     75  CB  ALA A  15      90.590  99.463  64.259  1.00 22.37           C  
ATOM     76  N   GLY A  16      92.071 102.204  65.915  1.00 24.57           N  
ATOM     77  CA  GLY A  16      93.342 102.697  66.417  1.00 26.82           C  
ATOM     78  C   GLY A  16      93.363 102.741  67.932  1.00 26.92           C  
ATOM     79  O   GLY A  16      92.332 102.547  68.590  1.00 26.82           O  
ATOM     80  N   PHE A  17      94.548 103.017  68.478  1.00 27.92           N  
ATOM     81  CA  PHE A  17      94.782 103.071  69.926  1.00 28.26           C  
ATOM     82  C   PHE A  17      95.046 104.500  70.463  1.00 28.45           C  
ATOM     83  O   PHE A  17      95.147 104.701  71.678  1.00 27.76           O  
ATOM     84  CB  PHE A  17      95.992 102.172  70.286  1.00 28.57           C  
ATOM     85  CG  PHE A  17      95.899 100.748  69.766  1.00 28.84           C  
ATOM     86  CD1 PHE A  17      97.061 100.023  69.499  1.00 30.02           C  
ATOM     87  CD2 PHE A  17      94.671 100.125  69.574  1.00 27.60           C  
ATOM     88  CE1 PHE A  17      97.001  98.708  69.043  1.00 27.84           C  
ATOM     89  CE2 PHE A  17      94.593  98.798  69.117  1.00 27.53           C  
ATOM     90  CZ  PHE A  17      95.756  98.095  68.852  1.00 28.39           C  
ATOM     91  N   GLY A  18      95.164 105.477  69.564  1.00 29.76           N  
ATOM     92  CA  GLY A  18      95.410 106.848  69.992  1.00 30.80           C  
ATOM     93  C   GLY A  18      96.583 106.946  70.950  1.00 31.72           C  
ATOM     94  O   GLY A  18      96.465 107.471  72.070  1.00 31.28           O  
ATOM     95  N   ARG A  19      97.725 106.438  70.502  1.00 31.50           N  
ATOM     96  CA  ARG A  19      98.936 106.447  71.324  1.00 33.14           C  
ATOM     97  C   ARG A  19      99.396 107.877  71.646  1.00 33.17           C  
ATOM     98  O   ARG A  19      99.964 108.123  72.705  1.00 34.41           O  
ATOM     99  CB  ARG A  19     100.043 105.683  70.601  1.00 31.93           C  
ATOM    100  CG  ARG A  19     101.362 105.573  71.358  1.00 33.93           C  
ATOM    101  CD  ARG A  19     102.528 105.696  70.376  1.00 33.30           C  
ATOM    102  NE  ARG A  19     102.059 105.389  69.017  1.00 32.92           N  
ATOM    103  CZ  ARG A  19     102.758 105.588  67.904  1.00 31.41           C  
ATOM    104  NH1 ARG A  19     103.990 106.099  67.945  1.00 33.61           N  
ATOM    105  NH2 ARG A  19     102.218 105.279  66.740  1.00 35.47           N  
ATOM    106  N   ARG A  20      99.147 108.817  70.736  1.00 33.64           N  
ATOM    107  CA  ARG A  20      99.537 110.207  70.965  1.00 33.74           C  
ATOM    108  C   ARG A  20      98.694 110.951  72.020  1.00 34.69           C  
ATOM    109  O   ARG A  20      98.931 112.140  72.279  1.00 34.86           O  
ATOM    110  CB  ARG A  20      99.517 110.985  69.646  1.00 33.91           C  
ATOM    111  CG  ARG A  20     100.618 110.572  68.663  1.00 33.26           C  
ATOM    112  CD  ARG A  20     100.478 111.300  67.321  1.00 34.42           C  
ATOM    113  NE  ARG A  20      99.558 110.625  66.394  1.00 34.36           N  
ATOM    114  CZ  ARG A  20      99.208 111.106  65.198  1.00 33.87           C  
ATOM    115  NH1 ARG A  20      99.693 112.269  64.772  1.00 33.42           N  
ATOM    116  NH2 ARG A  20      98.383 110.417  64.414  1.00 34.14           N  
ATOM    117  N   MET A  21      97.728 110.264  72.636  1.00 34.58           N  
ATOM    118  CA  MET A  21      96.883 110.895  73.659  1.00 34.52           C  
ATOM    119  C   MET A  21      97.340 110.666  75.098  1.00 36.06           C  
ATOM    120  O   MET A  21      96.846 111.328  76.003  1.00 37.71           O  
ATOM    121  CB  MET A  21      95.424 110.425  73.527  1.00 33.04           C  
ATOM    122  CG  MET A  21      94.683 110.961  72.311  1.00 30.18           C  
ATOM    123  SD  MET A  21      94.414 112.744  72.328  1.00 20.89           S  
ATOM    124  CE  MET A  21      93.624 112.987  73.865  1.00 25.24           C  
ATOM    125  N   GLN A  22      98.264 109.732  75.318  1.00 37.25           N  
ATOM    126  CA  GLN A  22      98.746 109.455  76.678  1.00 38.16           C  
ATOM    127  C   GLN A  22      97.796 108.596  77.494  1.00 38.76           C  
ATOM    128  O   GLN A  22      98.193 108.033  78.514  1.00 40.61           O  
ATOM    129  CB  GLN A  22      98.979 110.762  77.446  1.00 40.01           C  
ATOM    130  N   THR A  23      96.541 108.508  77.076  1.00 39.07           N  
ATOM    131  CA  THR A  23      95.578 107.716  77.827  1.00 38.85           C  
ATOM    132  C   THR A  23      95.634 106.244  77.426  1.00 38.90           C  
ATOM    133  O   THR A  23      95.876 105.898  76.258  1.00 39.42           O  
ATOM    134  CB  THR A  23      94.125 108.247  77.632  1.00 39.60           C  
ATOM    135  OG1 THR A  23      93.757 108.160  76.247  1.00 40.28           O  
ATOM    136  CG2 THR A  23      94.013 109.694  78.092  1.00 38.34           C  
ATOM    137  N   GLU A  24      95.461 105.372  78.408  1.00 38.47           N  
ATOM    138  CA  GLU A  24      95.458 103.953  78.119  1.00 37.89           C  
ATOM    139  C   GLU A  24      94.112 103.679  77.442  1.00 36.86           C  
ATOM    140  O   GLU A  24      93.948 102.691  76.734  1.00 38.04           O  
ATOM    141  CB  GLU A  24      95.611 103.147  79.409  1.00 39.63           C  
ATOM    142  CG  GLU A  24      95.328 101.659  79.248  1.00 41.48           C  
ATOM    143  CD  GLU A  24      95.889 100.826  80.393  1.00 43.64           C  
ATOM    144  OE1 GLU A  24      95.920 101.342  81.541  1.00 43.78           O  
ATOM    145  OE2 GLU A  24      96.286  99.655  80.143  1.00 43.95           O  
ATOM    146  N   CYS A  25      93.149 104.565  77.670  1.00 35.81           N  
ATOM    147  CA  CYS A  25      91.840 104.430  77.047  1.00 33.67           C  
ATOM    148  C   CYS A  25      91.949 104.985  75.624  1.00 32.82           C  
ATOM    149  O   CYS A  25      92.477 106.084  75.412  1.00 31.73           O  
ATOM    150  CB  CYS A  25      90.788 105.219  77.846  1.00 33.90           C  
ATOM    151  SG  CYS A  25      89.131 105.341  77.076  1.00 33.73           S  
ATOM    152  N   PRO A  26      91.494 104.213  74.619  1.00 30.03           N  
ATOM    153  CA  PRO A  26      91.570 104.709  73.241  1.00 29.64           C  
ATOM    154  C   PRO A  26      90.803 106.028  73.169  1.00 26.78           C  
ATOM    155  O   PRO A  26      89.698 106.146  73.704  1.00 27.09           O  
ATOM    156  CB  PRO A  26      90.916 103.591  72.432  1.00 29.40           C  
ATOM    157  CG  PRO A  26      91.285 102.369  73.219  1.00 31.10           C  
ATOM    158  CD  PRO A  26      91.037 102.811  74.648  1.00 30.64           C  
ATOM    159  N   LYS A  27      91.400 107.018  72.516  1.00 26.46           N  
ATOM    160  CA  LYS A  27      90.806 108.345  72.424  1.00 25.81           C  
ATOM    161  C   LYS A  27      89.368 108.381  71.944  1.00 26.03           C  
ATOM    162  O   LYS A  27      88.577 109.215  72.400  1.00 24.93           O  
ATOM    163  CB  LYS A  27      91.667 109.233  71.537  1.00 25.09           C  
ATOM    164  CG  LYS A  27      91.662 108.859  70.070  1.00 23.38           C  
ATOM    165  CD  LYS A  27      92.659 109.722  69.346  1.00 23.98           C  
ATOM    166  CE  LYS A  27      92.799 109.325  67.909  1.00 25.78           C  
ATOM    167  NZ  LYS A  27      93.693 110.295  67.212  1.00 25.05           N  
ATOM    168  N   GLN A  28      89.020 107.489  71.018  1.00 24.99           N  
ATOM    169  CA  GLN A  28      87.644 107.481  70.529  1.00 24.41           C  
ATOM    170  C   GLN A  28      86.677 107.131  71.655  1.00 25.00           C  
ATOM    171  O   GLN A  28      85.474 107.317  71.520  1.00 23.83           O  
ATOM    172  CB  GLN A  28      87.464 106.504  69.335  1.00 24.96           C  
ATOM    173  CG  GLN A  28      87.754 105.024  69.605  1.00 25.74           C  
ATOM    174  CD  GLN A  28      89.210 104.698  69.370  1.00 25.76           C  
ATOM    175  OE1 GLN A  28      90.073 105.475  69.748  1.00 25.82           O  
ATOM    176  NE2 GLN A  28      89.494 103.553  68.749  1.00 25.14           N  
ATOM    177  N   TYR A  29      87.198 106.633  72.778  1.00 24.08           N  
ATOM    178  CA  TYR A  29      86.326 106.280  73.883  1.00 24.24           C  
ATOM    179  C   TYR A  29      86.388 107.302  75.016  1.00 24.46           C  
ATOM    180  O   TYR A  29      85.785 107.102  76.075  1.00 25.56           O  
ATOM    181  CB  TYR A  29      86.633 104.858  74.395  1.00 25.58           C  
ATOM    182  CG  TYR A  29      86.270 103.770  73.394  1.00 24.76           C  
ATOM    183  CD1 TYR A  29      87.255 103.076  72.685  1.00 24.62           C  
ATOM    184  CD2 TYR A  29      84.945 103.488  73.105  1.00 24.82           C  
ATOM    185  CE1 TYR A  29      86.912 102.124  71.717  1.00 23.29           C  
ATOM    186  CE2 TYR A  29      84.597 102.550  72.131  1.00 24.94           C  
ATOM    187  CZ  TYR A  29      85.586 101.874  71.445  1.00 24.50           C  
ATOM    188  OH  TYR A  29      85.225 100.947  70.498  1.00 24.92           O  
ATOM    189  N   LEU A  30      87.119 108.389  74.791  1.00 24.77           N  
ATOM    190  CA  LEU A  30      87.180 109.462  75.767  1.00 25.78           C  
ATOM    191  C   LEU A  30      85.870 110.189  75.574  1.00 26.47           C  
ATOM    192  O   LEU A  30      85.262 110.137  74.493  1.00 23.38           O  
ATOM    193  CB  LEU A  30      88.342 110.412  75.496  1.00 25.26           C  
ATOM    194  CG  LEU A  30      89.723 109.813  75.715  1.00 28.66           C  
ATOM    195  CD1 LEU A  30      90.779 110.823  75.328  1.00 28.45           C  
ATOM    196  CD2 LEU A  30      89.879 109.387  77.184  1.00 28.85           C  
ATOM    197  N   SER A  31      85.420 110.874  76.613  1.00 27.01           N  
ATOM    198  CA  SER A  31      84.151 111.553  76.505  1.00 28.49           C  
ATOM    199  C   SER A  31      84.165 113.059  76.502  1.00 29.07           C  
ATOM    200  O   SER A  31      85.091 113.707  76.986  1.00 29.32           O  
ATOM    201  CB  SER A  31      83.223 111.077  77.619  1.00 29.67           C  
ATOM    202  OG  SER A  31      83.013 109.682  77.548  1.00 33.73           O  
ATOM    203  N   ILE A  32      83.105 113.595  75.908  1.00 28.59           N  
ATOM    204  CA  ILE A  32      82.850 115.015  75.865  1.00 29.21           C  
ATOM    205  C   ILE A  32      81.385 115.063  76.254  1.00 30.24           C  
ATOM    206  O   ILE A  32      80.501 114.585  75.532  1.00 25.70           O  
ATOM    207  CB  ILE A  32      83.062 115.622  74.494  1.00 29.72           C  
ATOM    208  CG1 ILE A  32      84.536 115.467  74.104  1.00 29.99           C  
ATOM    209  CG2 ILE A  32      82.682 117.105  74.536  1.00 31.11           C  
ATOM    210  CD1 ILE A  32      84.897 116.156  72.817  1.00 32.45           C  
ATOM    211  N   GLY A  33      81.133 115.625  77.431  1.00 31.83           N  
ATOM    212  CA  GLY A  33      79.781 115.662  77.940  1.00 34.53           C  
ATOM    213  C   GLY A  33      79.634 114.330  78.647  1.00 36.12           C  
ATOM    214  O   GLY A  33      80.186 114.128  79.738  1.00 40.04           O  
ATOM    215  N   ASN A  34      78.897 113.420  78.028  1.00 35.24           N  
ATOM    216  CA  ASN A  34      78.686 112.079  78.567  1.00 35.67           C  
ATOM    217  C   ASN A  34      78.498 111.161  77.384  1.00 35.42           C  
ATOM    218  O   ASN A  34      77.881 110.102  77.487  1.00 36.90           O  
ATOM    219  CB  ASN A  34      77.447 112.030  79.430  1.00 35.91           C  
ATOM    220  CG  ASN A  34      76.792 113.348  79.508  1.00 34.62           C  
ATOM    221  OD1 ASN A  34      77.061 114.131  80.430  1.00 37.66           O  
ATOM    222  ND2 ASN A  34      75.953 113.653  78.505  1.00 36.93           N  
ATOM    223  N   GLN A  35      79.004 111.611  76.247  1.00 32.91           N  
ATOM    224  CA  GLN A  35      78.971 110.822  75.033  1.00 30.24           C  
ATOM    225  C   GLN A  35      80.429 110.675  74.641  1.00 26.70           C  
ATOM    226  O   GLN A  35      81.206 111.601  74.843  1.00 24.42           O  
ATOM    227  CB  GLN A  35      78.234 111.563  73.937  1.00 34.03           C  
ATOM    228  CG  GLN A  35      77.297 110.684  73.176  1.00 37.11           C  
ATOM    229  CD  GLN A  35      76.422 111.463  72.224  1.00 39.43           C  
ATOM    230  OE1 GLN A  35      75.493 112.157  72.639  1.00 41.86           O  
ATOM    231  NE2 GLN A  35      76.735 111.382  70.939  1.00 41.09           N  
ATOM    232  N   THR A  36      80.807 109.518  74.096  1.00 22.95           N  
ATOM    233  CA  THR A  36      82.187 109.305  73.685  1.00 21.12           C  
ATOM    234  C   THR A  36      82.426 110.026  72.367  1.00 19.19           C  
ATOM    235  O   THR A  36      81.470 110.353  71.651  1.00 19.04           O  
ATOM    236  CB  THR A  36      82.488 107.813  73.446  1.00 21.30           C  
ATOM    237  OG1 THR A  36      81.593 107.295  72.455  1.00 20.16           O  
ATOM    238  CG2 THR A  36      82.324 107.008  74.728  1.00 22.95           C  
ATOM    239  N   ILE A  37      83.700 110.284  72.068  1.00 17.88           N  
ATOM    240  CA  ILE A  37      84.084 110.924  70.811  1.00 17.31           C  
ATOM    241  C   ILE A  37      83.496 110.084  69.662  1.00 15.74           C  
ATOM    242  O   ILE A  37      82.940 110.634  68.699  1.00 15.68           O  
ATOM    243  CB  ILE A  37      85.641 110.999  70.679  1.00 18.34           C  
ATOM    244  CG1 ILE A  37      86.207 111.999  71.699  1.00 21.72           C  
ATOM    245  CG2 ILE A  37      86.049 111.446  69.290  1.00 20.15           C  
ATOM    246  CD1 ILE A  37      85.530 113.308  71.665  1.00 25.88           C  
ATOM    247  N   LEU A  38      83.601 108.759  69.756  1.00 15.36           N  
ATOM    248  CA  LEU A  38      83.050 107.895  68.707  1.00 15.71           C  
ATOM    249  C   LEU A  38      81.532 108.159  68.540  1.00 15.27           C  
ATOM    250  O   LEU A  38      81.023 108.260  67.419  1.00 15.66           O  
ATOM    251  CB  LEU A  38      83.307 106.421  69.055  1.00 17.03           C  
ATOM    252  CG  LEU A  38      82.666 105.401  68.116  1.00 17.35           C  
ATOM    253  CD1 LEU A  38      83.199 105.596  66.691  1.00 18.09           C  
ATOM    254  CD2 LEU A  38      82.969 103.995  68.606  1.00 18.97           C  
ATOM    255  N   GLU A  39      80.800 108.300  69.644  1.00 15.84           N  
ATOM    256  CA  GLU A  39      79.365 108.550  69.538  1.00 17.12           C  
ATOM    257  C   GLU A  39      79.061 109.897  68.892  1.00 15.49           C  
ATOM    258  O   GLU A  39      78.181 109.989  68.017  1.00 18.11           O  
ATOM    259  CB  GLU A  39      78.694 108.439  70.911  1.00 18.12           C  
ATOM    260  CG  GLU A  39      78.556 106.979  71.337  1.00 20.52           C  
ATOM    261  CD  GLU A  39      78.253 106.812  72.805  1.00 23.49           C  
ATOM    262  OE1 GLU A  39      77.073 106.490  73.124  1.00 28.07           O  
ATOM    263  OE2 GLU A  39      79.182 107.005  73.625  1.00 22.05           O  
ATOM    264  N   HIS A  40      79.774 110.951  69.288  1.00 16.98           N  
ATOM    265  CA  HIS A  40      79.540 112.254  68.644  1.00 16.78           C  
ATOM    266  C   HIS A  40      79.730 112.122  67.127  1.00 15.86           C  
ATOM    267  O   HIS A  40      78.918 112.606  66.330  1.00 17.25           O  
ATOM    268  CB  HIS A  40      80.531 113.302  69.145  1.00 17.45           C  
ATOM    269  CG  HIS A  40      80.255 113.809  70.528  1.00 18.13           C  
ATOM    270  ND1 HIS A  40      79.230 114.687  70.813  1.00 21.59           N  
ATOM    271  CD2 HIS A  40      80.882 113.564  71.699  1.00 19.85           C  
ATOM    272  CE1 HIS A  40      79.238 114.959  72.108  1.00 21.66           C  
ATOM    273  NE2 HIS A  40      80.229 114.288  72.670  1.00 20.39           N  
ATOM    274  N   SER A  41      80.819 111.461  66.726  1.00 14.69           N  
ATOM    275  CA  SER A  41      81.101 111.275  65.323  1.00 15.51           C  
ATOM    276  C   SER A  41      80.025 110.496  64.577  1.00 16.29           C  
ATOM    277  O   SER A  41      79.545 110.917  63.518  1.00 15.23           O  
ATOM    278  CB  SER A  41      82.457 110.576  65.143  1.00 16.47           C  
ATOM    279  OG  SER A  41      83.467 111.385  65.664  1.00 20.12           O  
ATOM    280  N   VAL A  42      79.642 109.351  65.132  1.00 14.43           N  
ATOM    281  CA  VAL A  42      78.652 108.491  64.514  1.00 15.89           C  
ATOM    282  C   VAL A  42      77.302 109.168  64.433  1.00 15.15           C  
ATOM    283  O   VAL A  42      76.600 109.104  63.409  1.00 15.25           O  
ATOM    284  CB  VAL A  42      78.556 107.178  65.317  1.00 14.84           C  
ATOM    285  CG1 VAL A  42      77.358 106.357  64.886  1.00 16.14           C  
ATOM    286  CG2 VAL A  42      79.832 106.400  65.121  1.00 15.58           C  
ATOM    287  N   HIS A  43      76.923 109.839  65.509  1.00 15.78           N  
ATOM    288  CA  HIS A  43      75.629 110.492  65.476  1.00 17.67           C  
ATOM    289  C   HIS A  43      75.571 111.632  64.482  1.00 15.99           C  
ATOM    290  O   HIS A  43      74.494 111.919  63.932  1.00 16.74           O  
ATOM    291  CB  HIS A  43      75.229 110.904  66.890  1.00 20.50           C  
ATOM    292  CG  HIS A  43      74.861 109.731  67.754  1.00 25.02           C  
ATOM    293  ND1 HIS A  43      73.928 108.789  67.367  1.00 24.84           N  
ATOM    294  CD2 HIS A  43      75.289 109.352  68.982  1.00 26.28           C  
ATOM    295  CE1 HIS A  43      73.797 107.883  68.322  1.00 27.03           C  
ATOM    296  NE2 HIS A  43      74.610 108.202  69.314  1.00 26.50           N  
ATOM    297  N   ALA A  44      76.704 112.276  64.191  1.00 15.08           N  
ATOM    298  CA  ALA A  44      76.641 113.354  63.202  1.00 15.29           C  
ATOM    299  C   ALA A  44      76.338 112.747  61.816  1.00 14.72           C  
ATOM    300  O   ALA A  44      75.616 113.332  61.028  1.00 15.82           O  
ATOM    301  CB  ALA A  44      77.958 114.166  63.175  1.00 16.16           C  
ATOM    302  N   LEU A  45      76.879 111.566  61.523  1.00 13.24           N  
ATOM    303  CA  LEU A  45      76.597 110.922  60.254  1.00 14.59           C  
ATOM    304  C   LEU A  45      75.124 110.480  60.179  1.00 14.48           C  
ATOM    305  O   LEU A  45      74.487 110.655  59.147  1.00 14.66           O  
ATOM    306  CB  LEU A  45      77.493 109.687  60.086  1.00 14.15           C  
ATOM    307  CG  LEU A  45      78.996 109.986  60.197  1.00 13.48           C  
ATOM    308  CD1 LEU A  45      79.769 108.677  60.233  1.00 17.57           C  
ATOM    309  CD2 LEU A  45      79.441 110.855  59.055  1.00 15.66           C  
ATOM    310  N   LEU A  46      74.625 109.875  61.253  1.00 15.05           N  
ATOM    311  CA  LEU A  46      73.251 109.370  61.267  1.00 16.61           C  
ATOM    312  C   LEU A  46      72.209 110.471  61.213  1.00 18.03           C  
ATOM    313  O   LEU A  46      71.016 110.196  60.965  1.00 17.02           O  
ATOM    314  CB  LEU A  46      73.014 108.459  62.486  1.00 15.82           C  
ATOM    315  CG  LEU A  46      73.748 107.121  62.420  1.00 17.19           C  
ATOM    316  CD1 LEU A  46      73.580 106.333  63.709  1.00 18.98           C  
ATOM    317  CD2 LEU A  46      73.233 106.340  61.221  1.00 19.58           C  
ATOM    318  N   ALA A  47      72.626 111.713  61.452  1.00 17.22           N  
ATOM    319  CA  ALA A  47      71.666 112.814  61.404  1.00 16.88           C  
ATOM    320  C   ALA A  47      71.200 113.104  59.989  1.00 18.65           C  
ATOM    321  O   ALA A  47      70.091 113.602  59.792  1.00 20.28           O  
ATOM    322  CB  ALA A  47      72.261 114.083  62.030  1.00 16.55           C  
ATOM    323  N   HIS A  48      72.021 112.808  58.988  1.00 15.68           N  
ATOM    324  CA  HIS A  48      71.594 113.074  57.622  1.00 15.70           C  
ATOM    325  C   HIS A  48      70.717 111.916  57.142  1.00 16.76           C  
ATOM    326  O   HIS A  48      71.121 110.748  57.220  1.00 15.39           O  
ATOM    327  CB  HIS A  48      72.799 113.248  56.693  1.00 14.10           C  
ATOM    328  CG  HIS A  48      72.410 113.752  55.344  1.00 16.87           C  
ATOM    329  ND1 HIS A  48      71.602 113.026  54.501  1.00 15.31           N  
ATOM    330  CD2 HIS A  48      72.641 114.935  54.725  1.00 19.45           C  
ATOM    331  CE1 HIS A  48      71.345 113.737  53.416  1.00 18.71           C  
ATOM    332  NE2 HIS A  48      71.968 114.901  53.528  1.00 20.37           N  
ATOM    333  N   PRO A  49      69.500 112.204  56.629  1.00 17.67           N  
ATOM    334  CA  PRO A  49      68.622 111.115  56.177  1.00 17.78           C  
ATOM    335  C   PRO A  49      69.155 110.083  55.208  1.00 16.54           C  
ATOM    336  O   PRO A  49      68.689 108.960  55.205  1.00 17.78           O  
ATOM    337  CB  PRO A  49      67.419 111.854  55.562  1.00 18.29           C  
ATOM    338  CG  PRO A  49      67.360 113.091  56.319  1.00 20.43           C  
ATOM    339  CD  PRO A  49      68.840 113.511  56.422  1.00 19.98           C  
ATOM    340  N   ARG A  50      70.111 110.466  54.365  1.00 15.56           N  
ATOM    341  CA  ARG A  50      70.625 109.537  53.382  1.00 14.43           C  
ATOM    342  C   ARG A  50      71.531 108.465  53.994  1.00 15.47           C  
ATOM    343  O   ARG A  50      71.758 107.432  53.377  1.00 15.70           O  
ATOM    344  CB  ARG A  50      71.368 110.279  52.263  1.00 14.63           C  
ATOM    345  CG  ARG A  50      70.458 111.041  51.288  1.00 15.61           C  
ATOM    346  CD  ARG A  50      71.268 111.763  50.207  1.00 16.21           C  
ATOM    347  NE  ARG A  50      72.032 110.803  49.403  1.00 15.51           N  
ATOM    348  CZ  ARG A  50      72.988 111.138  48.549  1.00 15.45           C  
ATOM    349  NH1 ARG A  50      73.312 112.427  48.351  1.00 16.55           N  
ATOM    350  NH2 ARG A  50      73.654 110.176  47.916  1.00 16.86           N  
ATOM    351  N   VAL A  51      72.046 108.699  55.185  1.00 13.25           N  
ATOM    352  CA  VAL A  51      72.904 107.686  55.796  1.00 12.31           C  
ATOM    353  C   VAL A  51      72.038 106.583  56.416  1.00 14.41           C  
ATOM    354  O   VAL A  51      71.467 106.720  57.489  1.00 16.43           O  
ATOM    355  CB  VAL A  51      73.867 108.320  56.802  1.00 12.08           C  
ATOM    356  CG1 VAL A  51      74.782 107.221  57.366  1.00 15.22           C  
ATOM    357  CG2 VAL A  51      74.682 109.386  56.132  1.00 13.36           C  
ATOM    358  N   LYS A  52      71.971 105.467  55.712  1.00 14.42           N  
ATOM    359  CA  LYS A  52      71.130 104.344  56.137  1.00 15.22           C  
ATOM    360  C   LYS A  52      71.851 103.318  56.993  1.00 16.48           C  
ATOM    361  O   LYS A  52      71.222 102.477  57.651  1.00 18.81           O  
ATOM    362  CB  LYS A  52      70.580 103.592  54.913  1.00 16.38           C  
ATOM    363  CG  LYS A  52      70.023 104.488  53.799  1.00 16.50           C  
ATOM    364  CD  LYS A  52      68.943 105.439  54.327  1.00 16.15           C  
ATOM    365  CE  LYS A  52      68.261 106.177  53.196  1.00 18.87           C  
ATOM    366  NZ  LYS A  52      67.205 107.075  53.726  1.00 21.45           N  
ATOM    367  N   ARG A  53      73.162 103.368  56.951  1.00 15.55           N  
ATOM    368  CA  ARG A  53      73.952 102.398  57.680  1.00 17.43           C  
ATOM    369  C   ARG A  53      75.294 102.958  58.053  1.00 17.25           C  
ATOM    370  O   ARG A  53      75.827 103.828  57.373  1.00 16.08           O  
ATOM    371  CB  ARG A  53      74.200 101.198  56.790  1.00 21.65           C  
ATOM    372  CG  ARG A  53      74.897 100.054  57.475  1.00 29.71           C  
ATOM    373  CD  ARG A  53      75.167  98.971  56.458  1.00 34.53           C  
ATOM    374  NE  ARG A  53      75.394  97.685  57.092  1.00 38.10           N  
ATOM    375  CZ  ARG A  53      75.497  96.542  56.423  1.00 41.50           C  
ATOM    376  NH1 ARG A  53      75.394  96.541  55.098  1.00 41.66           N  
ATOM    377  NH2 ARG A  53      75.684  95.398  57.074  1.00 42.12           N  
ATOM    378  N   VAL A  54      75.844 102.464  59.154  1.00 15.73           N  
ATOM    379  CA  VAL A  54      77.192 102.880  59.518  1.00 13.89           C  
ATOM    380  C   VAL A  54      77.911 101.612  59.945  1.00 15.39           C  
ATOM    381  O   VAL A  54      77.413 100.854  60.772  1.00 19.32           O  
ATOM    382  CB  VAL A  54      77.235 103.849  60.688  1.00 14.14           C  
ATOM    383  CG1 VAL A  54      78.661 104.272  60.989  1.00 15.25           C  
ATOM    384  CG2 VAL A  54      76.429 105.083  60.325  1.00 13.74           C  
ATOM    385  N   VAL A  55      79.065 101.387  59.333  1.00 13.27           N  
ATOM    386  CA  VAL A  55      79.903 100.243  59.654  1.00 13.28           C  
ATOM    387  C   VAL A  55      81.101 100.811  60.415  1.00 13.02           C  
ATOM    388  O   VAL A  55      81.838 101.648  59.877  1.00 13.73           O  
ATOM    389  CB  VAL A  55      80.412  99.536  58.383  1.00 15.69           C  
ATOM    390  CG1 VAL A  55      81.265  98.340  58.803  1.00 16.45           C  
ATOM    391  CG2 VAL A  55      79.251  99.041  57.514  1.00 15.90           C  
ATOM    392  N   ILE A  56      81.303 100.354  61.649  1.00 13.07           N  
ATOM    393  CA  ILE A  56      82.407 100.811  62.495  1.00 14.22           C  
ATOM    394  C   ILE A  56      83.444  99.698  62.621  1.00 15.53           C  
ATOM    395  O   ILE A  56      83.103  98.591  63.018  1.00 16.65           O  
ATOM    396  CB  ILE A  56      81.891 101.183  63.877  1.00 15.05           C  
ATOM    397  CG1 ILE A  56      80.733 102.188  63.720  1.00 15.47           C  
ATOM    398  CG2 ILE A  56      83.007 101.751  64.715  1.00 16.15           C  
ATOM    399  CD1 ILE A  56      80.146 102.640  65.056  1.00 17.27           C  
ATOM    400  N   ALA A  57      84.692  99.985  62.263  1.00 14.26           N  
ATOM    401  CA  ALA A  57      85.741  98.966  62.341  1.00 16.43           C  
ATOM    402  C   ALA A  57      86.453  99.187  63.656  1.00 17.05           C  
ATOM    403  O   ALA A  57      86.935 100.293  63.902  1.00 18.07           O  
ATOM    404  CB  ALA A  57      86.724  99.139  61.190  1.00 14.65           C  
ATOM    405  N   ILE A  58      86.559  98.134  64.473  1.00 18.32           N  
ATOM    406  CA  ILE A  58      87.217  98.252  65.757  1.00 17.88           C  
ATOM    407  C   ILE A  58      88.359  97.236  65.845  1.00 18.36           C  
ATOM    408  O   ILE A  58      88.442  96.300  65.047  1.00 19.45           O  
ATOM    409  CB  ILE A  58      86.226  98.030  66.910  1.00 19.83           C  
ATOM    410  CG1 ILE A  58      85.570  96.652  66.810  1.00 18.39           C  
ATOM    411  CG2 ILE A  58      85.120  99.089  66.846  1.00 20.28           C  
ATOM    412  CD1 ILE A  58      84.720  96.297  68.036  1.00 21.01           C  
ATOM    413  N   SER A  59      89.249  97.434  66.804  1.00 20.13           N  
ATOM    414  CA  SER A  59      90.368  96.519  66.956  1.00 21.64           C  
ATOM    415  C   SER A  59      89.859  95.205  67.505  1.00 20.89           C  
ATOM    416  O   SER A  59      88.856  95.178  68.192  1.00 21.77           O  
ATOM    417  CB  SER A  59      91.374  97.102  67.949  1.00 21.07           C  
ATOM    418  OG  SER A  59      92.390  96.151  68.232  1.00 27.52           O  
ATOM    419  N   PRO A  60      90.509  94.079  67.161  1.00 22.27           N  
ATOM    420  CA  PRO A  60      89.994  92.837  67.745  1.00 24.60           C  
ATOM    421  C   PRO A  60      90.241  92.953  69.262  1.00 26.64           C  
ATOM    422  O   PRO A  60      91.194  93.594  69.690  1.00 27.66           O  
ATOM    423  CB  PRO A  60      90.845  91.739  67.083  1.00 26.64           C  
ATOM    424  CG  PRO A  60      91.958  92.449  66.397  1.00 26.24           C  
ATOM    425  CD  PRO A  60      91.430  93.816  66.046  1.00 24.68           C  
ATOM    426  N   GLY A  61      89.396  92.361  70.089  1.00 30.03           N  
ATOM    427  CA  GLY A  61      89.631  92.515  71.521  1.00 32.70           C  
ATOM    428  C   GLY A  61      89.031  93.779  72.149  1.00 33.85           C  
ATOM    429  O   GLY A  61      88.773  93.796  73.362  1.00 34.75           O  
ATOM    430  N   ASP A  62      88.840  94.837  71.348  1.00 32.92           N  
ATOM    431  CA  ASP A  62      88.216  96.090  71.811  1.00 32.28           C  
ATOM    432  C   ASP A  62      86.971  95.678  72.593  1.00 31.19           C  
ATOM    433  O   ASP A  62      85.972  95.267  71.998  1.00 33.06           O  
ATOM    434  CB  ASP A  62      87.790  96.952  70.598  1.00 31.16           C  
ATOM    435  CG  ASP A  62      87.022  98.223  70.997  1.00 31.64           C  
ATOM    436  OD1 ASP A  62      86.550  98.327  72.142  1.00 32.84           O  
ATOM    437  OD2 ASP A  62      86.877  99.120  70.151  1.00 28.18           O  
ATOM    438  N   SER A  63      87.033  95.781  73.921  1.00 32.10           N  
ATOM    439  CA  SER A  63      85.913  95.407  74.784  1.00 33.18           C  
ATOM    440  C   SER A  63      85.022  96.585  75.167  1.00 32.34           C  
ATOM    441  O   SER A  63      84.028  96.430  75.877  1.00 34.07           O  
ATOM    442  CB  SER A  63      86.439  94.752  76.067  1.00 34.48           C  
ATOM    443  OG  SER A  63      87.395  95.586  76.699  1.00 36.83           O  
ATOM    444  N   ARG A  64      85.371  97.770  74.704  1.00 30.77           N  
ATOM    445  CA  ARG A  64      84.587  98.946  75.049  1.00 29.45           C  
ATOM    446  C   ARG A  64      83.371  99.160  74.176  1.00 28.93           C  
ATOM    447  O   ARG A  64      82.292  99.479  74.678  1.00 26.51           O  
ATOM    448  CB  ARG A  64      85.466 100.194  74.985  1.00 31.09           C  
ATOM    449  CG  ARG A  64      86.543 100.242  76.064  1.00 33.76           C  
ATOM    450  CD  ARG A  64      87.309 101.552  76.006  1.00 34.77           C  
ATOM    451  NE  ARG A  64      88.308 101.680  77.066  1.00 37.91           N  
ATOM    452  CZ  ARG A  64      89.415 100.951  77.149  1.00 39.22           C  
ATOM    453  NH1 ARG A  64      89.673 100.029  76.236  1.00 40.28           N  
ATOM    454  NH2 ARG A  64      90.277 101.162  78.138  1.00 42.13           N  
ATOM    455  N   PHE A  65      83.542  98.996  72.871  1.00 26.49           N  
ATOM    456  CA  PHE A  65      82.436  99.216  71.957  1.00 27.10           C  
ATOM    457  C   PHE A  65      81.153  98.537  72.397  1.00 27.75           C  
ATOM    458  O   PHE A  65      80.087  99.148  72.396  1.00 27.22           O  
ATOM    459  CB  PHE A  65      82.780  98.717  70.555  1.00 25.64           C  
ATOM    460  CG  PHE A  65      81.718  99.020  69.535  1.00 25.17           C  
ATOM    461  CD1 PHE A  65      81.594 100.309  69.009  1.00 24.57           C  
ATOM    462  CD2 PHE A  65      80.841  98.030  69.109  1.00 24.60           C  
ATOM    463  CE1 PHE A  65      80.614 100.604  68.074  1.00 26.44           C  
ATOM    464  CE2 PHE A  65      79.851  98.310  68.169  1.00 26.16           C  
ATOM    465  CZ  PHE A  65      79.738  99.609  67.650  1.00 26.32           C  
ATOM    466  N   ALA A  66      81.255  97.262  72.763  1.00 27.71           N  
ATOM    467  CA  ALA A  66      80.084  96.500  73.150  1.00 29.32           C  
ATOM    468  C   ALA A  66      79.285  97.140  74.264  1.00 30.36           C  
ATOM    469  O   ALA A  66      78.088  96.885  74.380  1.00 30.49           O  
ATOM    470  CB  ALA A  66      80.485  95.080  73.540  1.00 29.88           C  
ATOM    471  N   GLN A  67      79.924  97.984  75.071  1.00 30.79           N  
ATOM    472  CA  GLN A  67      79.213  98.621  76.182  1.00 33.92           C  
ATOM    473  C   GLN A  67      78.512  99.946  75.843  1.00 33.99           C  
ATOM    474  O   GLN A  67      77.927 100.591  76.725  1.00 35.07           O  
ATOM    475  CB  GLN A  67      80.172  98.839  77.355  1.00 35.54           C  
ATOM    476  CG  GLN A  67      80.848  97.562  77.815  1.00 38.50           C  
ATOM    477  CD  GLN A  67      79.856  96.429  78.007  1.00 40.29           C  
ATOM    478  OE1 GLN A  67      78.879  96.562  78.751  1.00 42.43           O  
ATOM    479  NE2 GLN A  67      80.098  95.304  77.335  1.00 40.12           N  
ATOM    480  N   LEU A  68      78.567 100.348  74.575  1.00 33.08           N  
ATOM    481  CA  LEU A  68      77.928 101.590  74.141  1.00 31.89           C  
ATOM    482  C   LEU A  68      76.576 101.288  73.493  1.00 32.23           C  
ATOM    483  O   LEU A  68      76.335 100.171  73.045  1.00 32.25           O  
ATOM    484  CB  LEU A  68      78.809 102.312  73.112  1.00 30.38           C  
ATOM    485  CG  LEU A  68      80.247 102.662  73.486  1.00 30.19           C  
ATOM    486  CD1 LEU A  68      80.958 103.266  72.276  1.00 29.29           C  
ATOM    487  CD2 LEU A  68      80.250 103.630  74.662  1.00 31.05           C  
ATOM    488  N   PRO A  69      75.681 102.290  73.426  1.00 32.93           N  
ATOM    489  CA  PRO A  69      74.352 102.118  72.814  1.00 33.02           C  
ATOM    490  C   PRO A  69      74.473 101.774  71.321  1.00 33.17           C  
ATOM    491  O   PRO A  69      73.618 101.113  70.739  1.00 33.60           O  
ATOM    492  CB  PRO A  69      73.689 103.472  73.050  1.00 34.59           C  
ATOM    493  CG  PRO A  69      74.354 103.957  74.337  1.00 35.03           C  
ATOM    494  CD  PRO A  69      75.796 103.595  74.107  1.00 33.86           C  
ATOM    495  N   LEU A  70      75.548 102.227  70.700  1.00 32.08           N  
ATOM    496  CA  LEU A  70      75.762 101.953  69.285  1.00 31.71           C  
ATOM    497  C   LEU A  70      75.803 100.475  68.956  1.00 31.77           C  
ATOM    498  O   LEU A  70      75.535 100.074  67.824  1.00 32.24           O  
ATOM    499  CB  LEU A  70      77.078 102.557  68.840  1.00 30.70           C  
ATOM    500  CG  LEU A  70      77.291 104.044  69.070  1.00 30.13           C  
ATOM    501  CD1 LEU A  70      78.671 104.376  68.544  1.00 28.49           C  
ATOM    502  CD2 LEU A  70      76.220 104.862  68.368  1.00 28.61           C  
ATOM    503  N   ALA A  71      76.164  99.670  69.951  1.00 32.11           N  
ATOM    504  CA  ALA A  71      76.288  98.233  69.781  1.00 31.78           C  
ATOM    505  C   ALA A  71      74.974  97.548  69.425  1.00 30.80           C  
ATOM    506  O   ALA A  71      74.982  96.482  68.813  1.00 31.65           O  
ATOM    507  CB  ALA A  71      76.881  97.617  71.049  1.00 32.48           C  
ATOM    508  N   ASN A  72      73.852  98.159  69.793  1.00 28.24           N  
ATOM    509  CA  ASN A  72      72.543  97.565  69.515  1.00 27.87           C  
ATOM    510  C   ASN A  72      71.656  98.383  68.573  1.00 25.08           C  
ATOM    511  O   ASN A  72      70.457  98.112  68.425  1.00 24.82           O  
ATOM    512  CB  ASN A  72      71.810  97.321  70.836  1.00 31.94           C  
ATOM    513  CG  ASN A  72      72.513  96.292  71.707  1.00 34.77           C  
ATOM    514  OD1 ASN A  72      72.690  96.491  72.914  1.00 39.57           O  
ATOM    515  ND2 ASN A  72      72.901  95.175  71.102  1.00 35.57           N  
ATOM    516  N   HIS A  73      72.259  99.367  67.917  1.00 21.89           N  
ATOM    517  CA  HIS A  73      71.551 100.246  66.998  1.00 18.81           C  
ATOM    518  C   HIS A  73      71.256  99.500  65.702  1.00 17.14           C  
ATOM    519  O   HIS A  73      72.147  98.905  65.106  1.00 18.88           O  
ATOM    520  CB  HIS A  73      72.429 101.454  66.747  1.00 18.16           C  
ATOM    521  CG  HIS A  73      71.753 102.541  65.983  1.00 17.98           C  
ATOM    522  ND1 HIS A  73      71.569 103.815  66.483  1.00 18.87           N  
ATOM    523  CD2 HIS A  73      71.209 102.538  64.749  1.00 16.01           C  
ATOM    524  CE1 HIS A  73      70.931 104.544  65.584  1.00 15.12           C  
ATOM    525  NE2 HIS A  73      70.701 103.793  64.525  1.00 19.69           N  
ATOM    526  N   PRO A  74      70.003  99.566  65.215  1.00 16.26           N  
ATOM    527  CA  PRO A  74      69.653  98.849  63.992  1.00 16.15           C  
ATOM    528  C   PRO A  74      70.371  99.266  62.734  1.00 16.72           C  
ATOM    529  O   PRO A  74      70.447  98.484  61.771  1.00 18.62           O  
ATOM    530  CB  PRO A  74      68.118  99.004  63.913  1.00 16.41           C  
ATOM    531  CG  PRO A  74      67.851 100.290  64.596  1.00 15.94           C  
ATOM    532  CD  PRO A  74      68.862 100.336  65.740  1.00 17.16           C  
ATOM    533  N   GLN A  75      70.950 100.469  62.730  1.00 16.05           N  
ATOM    534  CA  GLN A  75      71.650 100.938  61.531  1.00 16.91           C  
ATOM    535  C   GLN A  75      73.166 100.803  61.639  1.00 17.79           C  
ATOM    536  O   GLN A  75      73.863 101.192  60.706  1.00 18.57           O  
ATOM    537  CB  GLN A  75      71.307 102.404  61.249  1.00 14.25           C  
ATOM    538  CG  GLN A  75      69.806 102.600  60.902  1.00 15.51           C  
ATOM    539  CD  GLN A  75      69.395 104.076  60.818  1.00 15.34           C  
ATOM    540  OE1 GLN A  75      69.463 104.826  61.798  1.00 19.22           O  
ATOM    541  NE2 GLN A  75      68.971 104.485  59.655  1.00 18.00           N  
ATOM    542  N   ILE A  76      73.667 100.220  62.735  1.00 17.19           N  
ATOM    543  CA  ILE A  76      75.100 100.096  62.932  1.00 17.89           C  
ATOM    544  C   ILE A  76      75.587  98.660  62.960  1.00 19.04           C  
ATOM    545  O   ILE A  76      75.032  97.827  63.663  1.00 20.25           O  
ATOM    546  CB  ILE A  76      75.507 100.801  64.228  1.00 17.15           C  
ATOM    547  CG1 ILE A  76      75.124 102.287  64.130  1.00 19.10           C  
ATOM    548  CG2 ILE A  76      77.023 100.702  64.431  1.00 19.69           C  
ATOM    549  CD1 ILE A  76      75.336 103.039  65.418  1.00 22.53           C  
ATOM    550  N   THR A  77      76.656  98.411  62.211  1.00 18.27           N  
ATOM    551  CA  THR A  77      77.270  97.095  62.080  1.00 18.64           C  
ATOM    552  C   THR A  77      78.731  97.267  62.471  1.00 18.91           C  
ATOM    553  O   THR A  77      79.359  98.236  62.080  1.00 18.41           O  
ATOM    554  CB  THR A  77      77.206  96.635  60.613  1.00 22.41           C  
ATOM    555  OG1 THR A  77      75.832  96.579  60.196  1.00 25.49           O  
ATOM    556  CG2 THR A  77      77.860  95.278  60.441  1.00 23.84           C  
ATOM    557  N   VAL A  78      79.277  96.342  63.245  1.00 19.31           N  
ATOM    558  CA  VAL A  78      80.671  96.458  63.640  1.00 19.80           C  
ATOM    559  C   VAL A  78      81.474  95.342  62.979  1.00 19.28           C  
ATOM    560  O   VAL A  78      80.957  94.251  62.760  1.00 20.41           O  
ATOM    561  CB  VAL A  78      80.801  96.342  65.174  1.00 23.66           C  
ATOM    562  CG1 VAL A  78      80.344  94.961  65.627  1.00 24.59           C  
ATOM    563  CG2 VAL A  78      82.227  96.592  65.612  1.00 25.78           C  
ATOM    564  N   VAL A  79      82.725  95.629  62.642  1.00 18.44           N  
ATOM    565  CA  VAL A  79      83.609  94.634  62.050  1.00 19.55           C  
ATOM    566  C   VAL A  79      84.979  94.861  62.654  1.00 18.50           C  
ATOM    567  O   VAL A  79      85.238  95.903  63.248  1.00 17.09           O  
ATOM    568  CB  VAL A  79      83.719  94.791  60.525  1.00 21.55           C  
ATOM    569  CG1 VAL A  79      82.324  94.704  59.896  1.00 20.81           C  
ATOM    570  CG2 VAL A  79      84.390  96.107  60.167  1.00 21.55           C  
ATOM    571  N   ASP A  80      85.866  93.883  62.517  1.00 20.81           N  
ATOM    572  CA  ASP A  80      87.204  94.056  63.042  1.00 21.78           C  
ATOM    573  C   ASP A  80      88.021  94.819  62.014  1.00 19.92           C  
ATOM    574  O   ASP A  80      87.979  94.521  60.816  1.00 21.72           O  
ATOM    575  CB  ASP A  80      87.901  92.706  63.308  1.00 24.52           C  
ATOM    576  CG  ASP A  80      87.436  92.031  64.588  1.00 28.29           C  
ATOM    577  OD1 ASP A  80      86.632  92.617  65.348  1.00 29.17           O  
ATOM    578  OD2 ASP A  80      87.882  90.885  64.851  1.00 30.48           O  
ATOM    579  N   GLY A  81      88.759  95.807  62.498  1.00 22.05           N  
ATOM    580  CA  GLY A  81      89.622  96.590  61.637  1.00 23.79           C  
ATOM    581  C   GLY A  81      90.964  95.876  61.475  1.00 27.76           C  
ATOM    582  O   GLY A  81      91.093  94.698  61.857  1.00 26.23           O  
ATOM    583  N   GLY A  82      91.955  96.583  60.933  1.00 28.89           N  
ATOM    584  CA  GLY A  82      93.269  95.993  60.687  1.00 31.93           C  
ATOM    585  C   GLY A  82      94.460  96.756  61.238  1.00 33.47           C  
ATOM    586  O   GLY A  82      94.300  97.644  62.070  1.00 32.75           O  
ATOM    587  N   ASP A  83      95.662  96.408  60.772  1.00 35.15           N  
ATOM    588  CA  ASP A  83      96.895  97.048  61.241  1.00 35.26           C  
ATOM    589  C   ASP A  83      96.988  98.554  60.992  1.00 33.44           C  
ATOM    590  O   ASP A  83      97.416  99.314  61.869  1.00 32.64           O  
ATOM    591  CB  ASP A  83      98.115  96.355  60.621  1.00 38.99           C  
ATOM    592  CG  ASP A  83      98.024  94.847  60.696  1.00 41.76           C  
ATOM    593  OD1 ASP A  83      97.618  94.329  61.762  1.00 44.20           O  
ATOM    594  OD2 ASP A  83      98.370  94.178  59.695  1.00 43.97           O  
ATOM    595  N   GLU A  84      96.608  98.972  59.790  1.00 33.08           N  
ATOM    596  CA  GLU A  84      96.633 100.380  59.417  1.00 32.54           C  
ATOM    597  C   GLU A  84      95.228 100.862  59.077  1.00 30.32           C  
ATOM    598  O   GLU A  84      94.318 100.059  58.841  1.00 29.20           O  
ATOM    599  CB  GLU A  84      97.558 100.599  58.222  1.00 35.27           C  
ATOM    600  CG  GLU A  84      99.009 100.351  58.549  1.00 39.73           C  
ATOM    601  CD  GLU A  84      99.912 100.839  57.456  1.00 42.66           C  
ATOM    602  OE1 GLU A  84      99.764 102.018  57.053  1.00 45.55           O  
ATOM    603  OE2 GLU A  84     100.772 100.052  57.003  1.00 45.48           O  
ATOM    604  N   ARG A  85      95.057 102.176  59.035  1.00 30.55           N  
ATOM    605  CA  ARG A  85      93.747 102.749  58.752  1.00 28.49           C  
ATOM    606  C   ARG A  85      93.130 102.226  57.452  1.00 27.30           C  
ATOM    607  O   ARG A  85      91.947 101.900  57.399  1.00 25.81           O  
ATOM    608  CB  ARG A  85      93.863 104.280  58.726  1.00 28.58           C  
ATOM    609  CG  ARG A  85      92.539 105.004  58.522  1.00 27.54           C  
ATOM    610  CD  ARG A  85      92.693 106.486  58.822  1.00 28.32           C  
ATOM    611  NE  ARG A  85      91.451 107.202  58.559  1.00 28.30           N  
ATOM    612  CZ  ARG A  85      90.925 107.321  57.348  1.00 28.59           C  
ATOM    613  NH1 ARG A  85      91.539 106.785  56.313  1.00 27.07           N  
ATOM    614  NH2 ARG A  85      89.780 107.957  57.177  1.00 27.40           N  
ATOM    615  N   ALA A  86      93.925 102.147  56.397  1.00 27.15           N  
ATOM    616  CA  ALA A  86      93.418 101.667  55.118  1.00 26.93           C  
ATOM    617  C   ALA A  86      92.860 100.247  55.209  1.00 27.26           C  
ATOM    618  O   ALA A  86      91.875  99.900  54.539  1.00 25.17           O  
ATOM    619  CB  ALA A  86      94.509 101.733  54.066  1.00 28.42           C  
ATOM    620  N   ASP A  87      93.489  99.417  56.037  1.00 27.93           N  
ATOM    621  CA  ASP A  87      93.022  98.052  56.205  1.00 26.89           C  
ATOM    622  C   ASP A  87      91.659  98.072  56.879  1.00 26.33           C  
ATOM    623  O   ASP A  87      90.752  97.316  56.525  1.00 24.30           O  
ATOM    624  CB  ASP A  87      94.011  97.263  57.052  1.00 30.05           C  
ATOM    625  CG  ASP A  87      95.390  97.177  56.403  1.00 32.68           C  
ATOM    626  OD1 ASP A  87      95.498  96.537  55.341  1.00 33.59           O  
ATOM    627  OD2 ASP A  87      96.345  97.762  56.949  1.00 34.56           O  
ATOM    628  N   SER A  88      91.513  98.957  57.853  1.00 24.04           N  
ATOM    629  CA  SER A  88      90.254  99.055  58.567  1.00 22.02           C  
ATOM    630  C   SER A  88      89.157  99.598  57.657  1.00 19.76           C  
ATOM    631  O   SER A  88      88.013  99.160  57.732  1.00 18.17           O  
ATOM    632  CB  SER A  88      90.421  99.927  59.810  1.00 20.51           C  
ATOM    633  OG  SER A  88      91.354  99.350  60.714  1.00 22.34           O  
ATOM    634  N   VAL A  89      89.494 100.546  56.795  1.00 20.51           N  
ATOM    635  CA  VAL A  89      88.475 101.070  55.898  1.00 20.81           C  
ATOM    636  C   VAL A  89      88.014  99.973  54.945  1.00 22.83           C  
ATOM    637  O   VAL A  89      86.819  99.826  54.693  1.00 23.17           O  
ATOM    638  CB  VAL A  89      88.988 102.290  55.101  1.00 22.05           C  
ATOM    639  CG1 VAL A  89      87.945 102.724  54.094  1.00 22.95           C  
ATOM    640  CG2 VAL A  89      89.319 103.417  56.079  1.00 22.35           C  
ATOM    641  N   LEU A  90      88.954  99.182  54.424  1.00 24.20           N  
ATOM    642  CA  LEU A  90      88.599  98.080  53.513  1.00 24.13           C  
ATOM    643  C   LEU A  90      87.669  97.079  54.172  1.00 24.23           C  
ATOM    644  O   LEU A  90      86.738  96.600  53.546  1.00 23.45           O  
ATOM    645  CB  LEU A  90      89.859  97.343  53.018  1.00 26.59           C  
ATOM    646  CG  LEU A  90      90.434  97.761  51.662  1.00 29.00           C  
ATOM    647  CD1 LEU A  90      91.717  96.969  51.384  1.00 29.09           C  
ATOM    648  CD2 LEU A  90      89.428  97.503  50.563  1.00 27.71           C  
ATOM    649  N   ALA A  91      87.941  96.750  55.433  1.00 22.10           N  
ATOM    650  CA  ALA A  91      87.122  95.812  56.179  1.00 22.85           C  
ATOM    651  C   ALA A  91      85.729  96.411  56.294  1.00 22.00           C  
ATOM    652  O   ALA A  91      84.748  95.712  56.180  1.00 22.77           O  
ATOM    653  CB  ALA A  91      87.707  95.575  57.564  1.00 22.23           C  
ATOM    654  N   GLY A  92      85.652  97.717  56.536  1.00 21.41           N  
ATOM    655  CA  GLY A  92      84.349  98.348  56.617  1.00 20.36           C  
ATOM    656  C   GLY A  92      83.650  98.321  55.265  1.00 21.02           C  
ATOM    657  O   GLY A  92      82.455  98.041  55.202  1.00 20.59           O  
ATOM    658  N   LEU A  93      84.381  98.601  54.182  1.00 21.70           N  
ATOM    659  CA  LEU A  93      83.781  98.593  52.844  1.00 24.23           C  
ATOM    660  C   LEU A  93      83.199  97.218  52.486  1.00 26.48           C  
ATOM    661  O   LEU A  93      82.216  97.125  51.740  1.00 27.87           O  
ATOM    662  CB  LEU A  93      84.807  99.023  51.788  1.00 24.57           C  
ATOM    663  CG  LEU A  93      85.297 100.472  51.889  1.00 27.44           C  
ATOM    664  CD1 LEU A  93      86.381 100.704  50.844  1.00 28.87           C  
ATOM    665  CD2 LEU A  93      84.132 101.447  51.639  1.00 28.08           C  
ATOM    666  N   LYS A  94      83.805  96.150  53.007  1.00 27.62           N  
ATOM    667  CA  LYS A  94      83.317  94.790  52.774  1.00 28.97           C  
ATOM    668  C   LYS A  94      81.931  94.562  53.374  1.00 29.27           C  
ATOM    669  O   LYS A  94      81.187  93.725  52.889  1.00 29.24           O  
ATOM    670  CB  LYS A  94      84.275  93.747  53.377  1.00 32.42           C  
ATOM    671  CG  LYS A  94      85.675  93.691  52.785  1.00 36.10           C  
ATOM    672  CD  LYS A  94      85.837  92.509  51.834  1.00 39.09           C  
ATOM    673  CE  LYS A  94      87.322  92.215  51.537  1.00 40.75           C  
ATOM    674  NZ  LYS A  94      88.089  93.375  50.947  1.00 41.51           N  
ATOM    675  N   ALA A  95      81.570  95.293  54.425  1.00 27.31           N  
ATOM    676  CA  ALA A  95      80.268  95.099  55.040  1.00 28.36           C  
ATOM    677  C   ALA A  95      79.270  96.197  54.707  1.00 28.37           C  
ATOM    678  O   ALA A  95      78.193  96.262  55.300  1.00 28.76           O  
ATOM    679  CB  ALA A  95      80.408  94.986  56.551  1.00 31.24           C  
ATOM    680  N   ALA A  96      79.623  97.025  53.731  1.00 28.44           N  
ATOM    681  CA  ALA A  96      78.797  98.152  53.310  1.00 28.98           C  
ATOM    682  C   ALA A  96      77.547  97.805  52.525  1.00 29.32           C  
ATOM    683  O   ALA A  96      76.824  98.700  52.081  1.00 30.22           O  
ATOM    684  CB  ALA A  96      79.642  99.127  52.498  1.00 27.13           C  
ATOM    685  N   GLY A  97      77.289  96.518  52.323  1.00 29.46           N  
ATOM    686  CA  GLY A  97      76.103  96.135  51.578  1.00 29.12           C  
ATOM    687  C   GLY A  97      76.152  96.526  50.110  1.00 28.83           C  
ATOM    688  O   GLY A  97      77.221  96.520  49.502  1.00 29.13           O  
ATOM    689  N   ASP A  98      75.000  96.888  49.541  1.00 27.64           N  
ATOM    690  CA  ASP A  98      74.936  97.263  48.129  1.00 27.67           C  
ATOM    691  C   ASP A  98      74.914  98.773  47.893  1.00 25.44           C  
ATOM    692  O   ASP A  98      74.632  99.246  46.793  1.00 23.97           O  
ATOM    693  CB  ASP A  98      73.712  96.621  47.465  1.00 31.46           C  
ATOM    694  CG  ASP A  98      72.431  96.834  48.250  1.00 35.39           C  
ATOM    695  OD1 ASP A  98      72.230  97.933  48.802  1.00 36.20           O  
ATOM    696  OD2 ASP A  98      71.605  95.893  48.308  1.00 38.03           O  
ATOM    697  N   ALA A  99      75.235  99.530  48.934  1.00 24.26           N  
ATOM    698  CA  ALA A  99      75.264 100.979  48.834  1.00 23.79           C  
ATOM    699  C   ALA A  99      76.073 101.430  47.622  1.00 20.93           C  
ATOM    700  O   ALA A  99      77.183 100.966  47.403  1.00 22.45           O  
ATOM    701  CB  ALA A  99      75.883 101.562  50.097  1.00 25.95           C  
ATOM    702  N   GLN A 100      75.539 102.346  46.835  1.00 19.02           N  
ATOM    703  CA  GLN A 100      76.307 102.804  45.678  1.00 18.40           C  
ATOM    704  C   GLN A 100      77.388 103.802  46.055  1.00 16.54           C  
ATOM    705  O   GLN A 100      78.412 103.897  45.370  1.00 15.40           O  
ATOM    706  CB  GLN A 100      75.386 103.452  44.649  1.00 20.41           C  
ATOM    707  CG  GLN A 100      74.511 102.449  43.899  1.00 25.47           C  
ATOM    708  CD  GLN A 100      73.384 103.123  43.158  1.00 25.22           C  
ATOM    709  OE1 GLN A 100      73.532 104.229  42.663  1.00 28.26           O  
ATOM    710  NE2 GLN A 100      72.247 102.446  43.069  1.00 29.48           N  
ATOM    711  N   TRP A 101      77.144 104.561  47.129  1.00 15.22           N  
ATOM    712  CA  TRP A 101      78.084 105.576  47.601  1.00 15.55           C  
ATOM    713  C   TRP A 101      78.434 105.346  49.069  1.00 15.08           C  
ATOM    714  O   TRP A 101      77.569 104.941  49.845  1.00 13.53           O  
ATOM    715  CB  TRP A 101      77.461 106.967  47.448  1.00 14.22           C  
ATOM    716  CG  TRP A 101      77.493 107.492  46.053  1.00 16.14           C  
ATOM    717  CD1 TRP A 101      76.655 107.170  45.009  1.00 15.32           C  
ATOM    718  CD2 TRP A 101      78.423 108.442  45.537  1.00 12.94           C  
ATOM    719  NE1 TRP A 101      77.016 107.876  43.883  1.00 15.83           N  
ATOM    720  CE2 TRP A 101      78.099 108.666  44.179  1.00 15.18           C  
ATOM    721  CE3 TRP A 101      79.498 109.138  46.096  1.00 13.60           C  
ATOM    722  CZ2 TRP A 101      78.834 109.551  43.375  1.00 15.10           C  
ATOM    723  CZ3 TRP A 101      80.217 110.022  45.301  1.00 14.19           C  
ATOM    724  CH2 TRP A 101      79.884 110.225  43.958  1.00 14.12           C  
ATOM    725  N   VAL A 102      79.694 105.598  49.432  1.00 13.55           N  
ATOM    726  CA  VAL A 102      80.139 105.415  50.812  1.00 13.94           C  
ATOM    727  C   VAL A 102      80.794 106.675  51.353  1.00 14.02           C  
ATOM    728  O   VAL A 102      81.490 107.385  50.642  1.00 11.85           O  
ATOM    729  CB  VAL A 102      81.141 104.242  50.910  1.00 15.04           C  
ATOM    730  CG1 VAL A 102      82.349 104.521  50.050  1.00 17.28           C  
ATOM    731  CG2 VAL A 102      81.524 104.019  52.334  1.00 18.18           C  
ATOM    732  N   LEU A 103      80.550 106.931  52.635  1.00 13.62           N  
ATOM    733  CA  LEU A 103      81.056 108.098  53.352  1.00 16.27           C  
ATOM    734  C   LEU A 103      82.057 107.565  54.359  1.00 15.78           C  
ATOM    735  O   LEU A 103      81.668 106.811  55.224  1.00 20.01           O  
ATOM    736  CB  LEU A 103      79.895 108.718  54.116  1.00 16.99           C  
ATOM    737  CG  LEU A 103      79.838 110.110  54.689  1.00 22.33           C  
ATOM    738  CD1 LEU A 103      79.959 111.136  53.550  1.00 17.74           C  
ATOM    739  CD2 LEU A 103      78.480 110.260  55.409  1.00 18.25           C  
ATOM    740  N   VAL A 104      83.332 107.937  54.273  1.00 14.23           N  
ATOM    741  CA  VAL A 104      84.306 107.435  55.246  1.00 14.27           C  
ATOM    742  C   VAL A 104      84.630 108.595  56.191  1.00 12.91           C  
ATOM    743  O   VAL A 104      85.028 109.670  55.739  1.00 13.59           O  
ATOM    744  CB  VAL A 104      85.606 106.957  54.570  1.00 15.22           C  
ATOM    745  CG1 VAL A 104      86.531 106.370  55.637  1.00 14.64           C  
ATOM    746  CG2 VAL A 104      85.280 105.907  53.506  1.00 16.23           C  
ATOM    747  N   HIS A 105      84.480 108.361  57.491  1.00 12.64           N  
ATOM    748  CA  HIS A 105      84.687 109.402  58.484  1.00 13.16           C  
ATOM    749  C   HIS A 105      85.497 108.939  59.683  1.00 13.68           C  
ATOM    750  O   HIS A 105      85.191 107.912  60.272  1.00 15.49           O  
ATOM    751  CB  HIS A 105      83.318 109.901  58.991  1.00 13.58           C  
ATOM    752  CG  HIS A 105      83.422 111.145  59.816  1.00 15.75           C  
ATOM    753  ND1 HIS A 105      82.894 111.268  61.084  1.00 19.86           N  
ATOM    754  CD2 HIS A 105      84.086 112.295  59.570  1.00 12.60           C  
ATOM    755  CE1 HIS A 105      83.238 112.444  61.585  1.00 14.72           C  
ATOM    756  NE2 HIS A 105      83.965 113.084  60.685  1.00 18.78           N  
ATOM    757  N   ASP A 106      86.507 109.722  60.065  1.00 15.08           N  
ATOM    758  CA  ASP A 106      87.337 109.368  61.224  1.00 17.92           C  
ATOM    759  C   ASP A 106      86.558 109.366  62.529  1.00 17.82           C  
ATOM    760  O   ASP A 106      85.814 110.288  62.804  1.00 17.90           O  
ATOM    761  CB  ASP A 106      88.484 110.348  61.402  1.00 21.63           C  
ATOM    762  CG  ASP A 106      89.606 110.109  60.437  1.00 27.48           C  
ATOM    763  OD1 ASP A 106      89.700 108.996  59.880  1.00 28.57           O  
ATOM    764  OD2 ASP A 106      90.394 111.050  60.269  1.00 31.28           O  
ATOM    765  N   ALA A 107      86.716 108.338  63.337  1.00 18.11           N  
ATOM    766  CA  ALA A 107      86.023 108.307  64.614  1.00 16.94           C  
ATOM    767  C   ALA A 107      86.477 109.522  65.460  1.00 19.33           C  
ATOM    768  O   ALA A 107      85.710 110.031  66.276  1.00 23.44           O  
ATOM    769  CB  ALA A 107      86.354 107.001  65.365  1.00 21.37           C  
ATOM    770  N   ALA A 108      87.695 110.005  65.221  1.00 18.10           N  
ATOM    771  CA  ALA A 108      88.268 111.090  66.000  1.00 19.23           C  
ATOM    772  C   ALA A 108      87.918 112.513  65.602  1.00 20.63           C  
ATOM    773  O   ALA A 108      88.573 113.470  66.075  1.00 19.92           O  
ATOM    774  CB  ALA A 108      89.783 110.924  66.038  1.00 22.52           C  
ATOM    775  N   ARG A 109      86.926 112.673  64.725  1.00 18.51           N  
ATOM    776  CA  ARG A 109      86.490 114.006  64.295  1.00 19.52           C  
ATOM    777  C   ARG A 109      85.037 114.163  64.738  1.00 19.19           C  
ATOM    778  O   ARG A 109      84.101 114.040  63.927  1.00 21.79           O  
ATOM    779  CB  ARG A 109      86.610 114.124  62.780  1.00 18.87           C  
ATOM    780  CG  ARG A 109      88.021 114.380  62.304  1.00 18.76           C  
ATOM    781  CD  ARG A 109      88.069 114.451  60.778  1.00 22.44           C  
ATOM    782  NE  ARG A 109      89.439 114.509  60.268  1.00 25.58           N  
ATOM    783  CZ  ARG A 109      90.215 115.592  60.282  1.00 25.16           C  
ATOM    784  NH1 ARG A 109      89.772 116.738  60.775  1.00 28.35           N  
ATOM    785  NH2 ARG A 109      91.453 115.535  59.798  1.00 28.08           N  
ATOM    786  N   PRO A 110      84.831 114.487  66.024  1.00 17.21           N  
ATOM    787  CA  PRO A 110      83.486 114.635  66.574  1.00 15.96           C  
ATOM    788  C   PRO A 110      82.768 115.940  66.330  1.00 16.82           C  
ATOM    789  O   PRO A 110      81.586 116.040  66.668  1.00 18.04           O  
ATOM    790  CB  PRO A 110      83.716 114.430  68.058  1.00 17.99           C  
ATOM    791  CG  PRO A 110      84.984 115.237  68.270  1.00 18.75           C  
ATOM    792  CD  PRO A 110      85.841 114.818  67.048  1.00 19.19           C  
ATOM    793  N   CYS A 111      83.440 116.904  65.714  1.00 14.80           N  
ATOM    794  CA  CYS A 111      82.862 118.226  65.541  1.00 16.56           C  
ATOM    795  C   CYS A 111      82.187 118.494  64.222  1.00 17.15           C  
ATOM    796  O   CYS A 111      81.843 119.638  63.934  1.00 18.96           O  
ATOM    797  CB  CYS A 111      83.941 119.285  65.801  1.00 18.11           C  
ATOM    798  SG  CYS A 111      84.610 119.138  67.458  1.00 21.50           S  
ATOM    799  N   LEU A 112      81.962 117.450  63.424  1.00 15.62           N  
ATOM    800  CA  LEU A 112      81.297 117.616  62.122  1.00 16.39           C  
ATOM    801  C   LEU A 112      79.928 118.289  62.164  1.00 15.37           C  
ATOM    802  O   LEU A 112      79.060 117.895  62.928  1.00 16.79           O  
ATOM    803  CB  LEU A 112      81.133 116.246  61.449  1.00 13.90           C  
ATOM    804  CG  LEU A 112      80.478 116.185  60.067  1.00 16.22           C  
ATOM    805  CD1 LEU A 112      81.308 116.949  59.035  1.00 15.91           C  
ATOM    806  CD2 LEU A 112      80.344 114.699  59.654  1.00 16.51           C  
ATOM    807  N   HIS A 113      79.746 119.289  61.310  1.00 16.51           N  
ATOM    808  CA  HIS A 113      78.483 120.012  61.207  1.00 19.86           C  
ATOM    809  C   HIS A 113      77.587 119.488  60.087  1.00 18.35           C  
ATOM    810  O   HIS A 113      78.050 119.028  59.053  1.00 17.24           O  
ATOM    811  CB  HIS A 113      78.732 121.491  60.961  1.00 19.85           C  
ATOM    812  CG  HIS A 113      79.133 122.241  62.190  1.00 28.14           C  
ATOM    813  ND1 HIS A 113      78.725 123.536  62.432  1.00 29.54           N  
ATOM    814  CD2 HIS A 113      79.904 121.884  63.239  1.00 29.26           C  
ATOM    815  CE1 HIS A 113      79.229 123.940  63.583  1.00 31.66           C  
ATOM    816  NE2 HIS A 113      79.949 122.957  64.095  1.00 31.31           N  
ATOM    817  N   GLN A 114      76.281 119.584  60.291  1.00 18.03           N  
ATOM    818  CA  GLN A 114      75.353 119.107  59.290  1.00 17.50           C  
ATOM    819  C   GLN A 114      75.394 119.827  57.961  1.00 17.21           C  
ATOM    820  O   GLN A 114      75.146 119.225  56.911  1.00 19.04           O  
ATOM    821  CB  GLN A 114      73.910 119.144  59.823  1.00 16.52           C  
ATOM    822  CG  GLN A 114      73.667 118.191  60.994  1.00 16.88           C  
ATOM    823  CD  GLN A 114      73.973 116.761  60.603  1.00 18.20           C  
ATOM    824  OE1 GLN A 114      73.325 116.197  59.715  1.00 18.96           O  
ATOM    825  NE2 GLN A 114      74.991 116.174  61.247  1.00 15.63           N  
ATOM    826  N   ASP A 115      75.679 121.122  57.964  1.00 18.20           N  
ATOM    827  CA  ASP A 115      75.705 121.825  56.692  1.00 19.07           C  
ATOM    828  C   ASP A 115      76.846 121.313  55.804  1.00 17.44           C  
ATOM    829  O   ASP A 115      76.666 121.103  54.594  1.00 18.85           O  
ATOM    830  CB  ASP A 115      75.789 123.348  56.919  1.00 23.02           C  
ATOM    831  CG  ASP A 115      77.028 123.762  57.684  1.00 30.18           C  
ATOM    832  OD1 ASP A 115      77.379 123.087  58.679  1.00 32.74           O  
ATOM    833  OD2 ASP A 115      77.645 124.784  57.302  1.00 36.87           O  
ATOM    834  N   ASP A 116      78.016 121.081  56.394  1.00 16.36           N  
ATOM    835  CA  ASP A 116      79.163 120.540  55.630  1.00 15.08           C  
ATOM    836  C   ASP A 116      78.824 119.134  55.113  1.00 13.47           C  
ATOM    837  O   ASP A 116      79.080 118.797  53.949  1.00 13.72           O  
ATOM    838  CB  ASP A 116      80.430 120.424  56.514  1.00 14.37           C  
ATOM    839  CG  ASP A 116      81.119 121.755  56.769  1.00 18.45           C  
ATOM    840  OD1 ASP A 116      80.764 122.787  56.138  1.00 19.59           O  
ATOM    841  OD2 ASP A 116      82.041 121.758  57.615  1.00 19.60           O  
ATOM    842  N   LEU A 117      78.244 118.315  55.985  1.00 13.04           N  
ATOM    843  CA  LEU A 117      77.902 116.948  55.612  1.00 12.90           C  
ATOM    844  C   LEU A 117      76.946 116.958  54.434  1.00 13.19           C  
ATOM    845  O   LEU A 117      77.130 116.231  53.447  1.00 13.10           O  
ATOM    846  CB  LEU A 117      77.285 116.194  56.787  1.00 14.28           C  
ATOM    847  CG  LEU A 117      76.822 114.771  56.468  1.00 14.77           C  
ATOM    848  CD1 LEU A 117      77.990 113.992  55.822  1.00 16.90           C  
ATOM    849  CD2 LEU A 117      76.358 114.050  57.759  1.00 16.28           C  
ATOM    850  N   ALA A 118      75.927 117.820  54.492  1.00 14.41           N  
ATOM    851  CA  ALA A 118      74.958 117.889  53.399  1.00 14.50           C  
ATOM    852  C   ALA A 118      75.559 118.370  52.084  1.00 15.04           C  
ATOM    853  O   ALA A 118      75.176 117.878  51.031  1.00 16.56           O  
ATOM    854  CB  ALA A 118      73.773 118.789  53.809  1.00 14.35           C  
ATOM    855  N   ARG A 119      76.500 119.318  52.137  1.00 14.91           N  
ATOM    856  CA  ARG A 119      77.117 119.809  50.914  1.00 15.41           C  
ATOM    857  C   ARG A 119      78.007 118.723  50.320  1.00 15.22           C  
ATOM    858  O   ARG A 119      78.115 118.607  49.106  1.00 16.22           O  
ATOM    859  CB  ARG A 119      77.903 121.073  51.208  1.00 15.22           C  
ATOM    860  CG  ARG A 119      76.928 122.256  51.376  1.00 19.79           C  
ATOM    861  CD  ARG A 119      77.582 123.561  51.809  1.00 21.56           C  
ATOM    862  NE  ARG A 119      78.828 123.762  51.115  1.00 24.56           N  
ATOM    863  CZ  ARG A 119      80.017 123.709  51.696  1.00 25.00           C  
ATOM    864  NH1 ARG A 119      80.116 123.481  53.005  1.00 22.49           N  
ATOM    865  NH2 ARG A 119      81.102 123.834  50.946  1.00 25.25           N  
ATOM    866  N   LEU A 120      78.634 117.930  51.189  1.00 15.02           N  
ATOM    867  CA  LEU A 120      79.480 116.843  50.703  1.00 14.85           C  
ATOM    868  C   LEU A 120      78.627 115.799  49.971  1.00 14.00           C  
ATOM    869  O   LEU A 120      78.994 115.326  48.880  1.00 14.15           O  
ATOM    870  CB  LEU A 120      80.214 116.168  51.869  1.00 13.10           C  
ATOM    871  CG  LEU A 120      81.120 115.019  51.396  1.00 13.83           C  
ATOM    872  CD1 LEU A 120      82.180 115.534  50.440  1.00 15.77           C  
ATOM    873  CD2 LEU A 120      81.745 114.339  52.610  1.00 13.68           C  
ATOM    874  N   LEU A 121      77.484 115.430  50.557  1.00 14.15           N  
ATOM    875  CA  LEU A 121      76.604 114.433  49.941  1.00 15.23           C  
ATOM    876  C   LEU A 121      76.041 114.863  48.586  1.00 14.35           C  
ATOM    877  O   LEU A 121      75.679 114.021  47.752  1.00 13.91           O  
ATOM    878  CB  LEU A 121      75.448 114.096  50.882  1.00 15.25           C  
ATOM    879  CG  LEU A 121      75.940 113.407  52.141  1.00 17.65           C  
ATOM    880  CD1 LEU A 121      74.780 113.038  53.057  1.00 20.86           C  
ATOM    881  CD2 LEU A 121      76.729 112.184  51.724  1.00 22.04           C  
ATOM    882  N   ALA A 122      75.921 116.156  48.365  1.00 17.52           N  
ATOM    883  CA  ALA A 122      75.406 116.614  47.081  1.00 18.62           C  
ATOM    884  C   ALA A 122      76.293 116.174  45.910  1.00 19.23           C  
ATOM    885  O   ALA A 122      75.856 116.173  44.767  1.00 18.10           O  
ATOM    886  CB  ALA A 122      75.237 118.139  47.097  1.00 18.96           C  
ATOM    887  N   LEU A 123      77.543 115.785  46.187  1.00 17.55           N  
ATOM    888  CA  LEU A 123      78.436 115.345  45.128  1.00 17.15           C  
ATOM    889  C   LEU A 123      77.915 114.157  44.336  1.00 17.78           C  
ATOM    890  O   LEU A 123      78.265 113.986  43.157  1.00 20.06           O  
ATOM    891  CB  LEU A 123      79.806 114.962  45.680  1.00 18.60           C  
ATOM    892  CG  LEU A 123      80.675 116.139  46.131  1.00 17.73           C  
ATOM    893  CD1 LEU A 123      81.992 115.572  46.663  1.00 20.56           C  
ATOM    894  CD2 LEU A 123      80.928 117.120  44.970  1.00 19.86           C  
ATOM    895  N   SER A 124      77.072 113.330  44.950  1.00 16.19           N  
ATOM    896  CA  SER A 124      76.591 112.172  44.202  1.00 18.19           C  
ATOM    897  C   SER A 124      75.687 112.549  43.028  1.00 20.62           C  
ATOM    898  O   SER A 124      75.448 111.729  42.139  1.00 22.27           O  
ATOM    899  CB  SER A 124      75.888 111.191  45.145  1.00 16.07           C  
ATOM    900  OG  SER A 124      74.700 111.714  45.688  1.00 18.80           O  
ATOM    901  N   GLU A 125      75.199 113.784  43.017  1.00 23.33           N  
ATOM    902  CA  GLU A 125      74.320 114.225  41.942  1.00 27.70           C  
ATOM    903  C   GLU A 125      75.089 114.983  40.862  1.00 30.97           C  
ATOM    904  O   GLU A 125      74.539 115.310  39.803  1.00 32.34           O  
ATOM    905  CB  GLU A 125      73.204 115.112  42.522  1.00 30.93           C  
ATOM    906  CG  GLU A 125      71.818 114.463  42.627  1.00 36.81           C  
ATOM    907  CD  GLU A 125      71.841 112.958  42.919  1.00 39.88           C  
ATOM    908  OE1 GLU A 125      72.483 112.497  43.904  1.00 39.30           O  
ATOM    909  OE2 GLU A 125      71.195 112.222  42.145  1.00 41.41           O  
ATOM    910  N   THR A 126      76.368 115.243  41.112  1.00 31.53           N  
ATOM    911  CA  THR A 126      77.158 116.019  40.163  1.00 33.82           C  
ATOM    912  C   THR A 126      78.566 115.511  39.878  1.00 32.92           C  
ATOM    913  O   THR A 126      79.315 116.171  39.158  1.00 34.95           O  
ATOM    914  CB  THR A 126      77.302 117.450  40.655  1.00 34.94           C  
ATOM    915  OG1 THR A 126      77.961 118.227  39.653  1.00 39.58           O  
ATOM    916  CG2 THR A 126      78.145 117.487  41.940  1.00 34.43           C  
ATOM    917  N   SER A 127      78.929 114.356  40.435  1.00 30.50           N  
ATOM    918  CA  SER A 127      80.266 113.795  40.245  1.00 29.11           C  
ATOM    919  C   SER A 127      80.259 112.280  40.108  1.00 29.32           C  
ATOM    920  O   SER A 127      79.377 111.618  40.640  1.00 29.11           O  
ATOM    921  CB  SER A 127      81.158 114.161  41.441  1.00 30.62           C  
ATOM    922  OG  SER A 127      82.369 113.409  41.435  1.00 30.46           O  
ATOM    923  N   ARG A 128      81.236 111.731  39.394  1.00 29.15           N  
ATOM    924  CA  ARG A 128      81.338 110.284  39.274  1.00 30.02           C  
ATOM    925  C   ARG A 128      82.586 109.834  39.994  1.00 29.84           C  
ATOM    926  O   ARG A 128      82.915 108.649  40.007  1.00 30.41           O  
ATOM    927  CB  ARG A 128      81.401 109.822  37.817  1.00 32.93           C  
ATOM    928  CG  ARG A 128      80.039 109.560  37.203  1.00 35.21           C  
ATOM    929  CD  ARG A 128      80.177 109.199  35.741  1.00 37.12           C  
ATOM    930  NE  ARG A 128      78.942 109.435  35.010  1.00 37.48           N  
ATOM    931  CZ  ARG A 128      77.850 108.688  35.120  1.00 37.40           C  
ATOM    932  NH1 ARG A 128      77.843 107.645  35.943  1.00 36.07           N  
ATOM    933  NH2 ARG A 128      76.771 108.974  34.392  1.00 36.47           N  
ATOM    934  N   THR A 129      83.292 110.788  40.597  1.00 28.15           N  
ATOM    935  CA  THR A 129      84.516 110.464  41.322  1.00 27.30           C  
ATOM    936  C   THR A 129      84.328 110.649  42.820  1.00 25.80           C  
ATOM    937  O   THR A 129      84.838 109.873  43.602  1.00 26.57           O  
ATOM    938  CB  THR A 129      85.703 111.348  40.850  1.00 29.02           C  
ATOM    939  OG1 THR A 129      85.909 111.141  39.447  1.00 31.54           O  
ATOM    940  CG2 THR A 129      86.990 110.984  41.604  1.00 30.78           C  
ATOM    941  N   GLY A 130      83.577 111.667  43.210  1.00 21.43           N  
ATOM    942  CA  GLY A 130      83.400 111.902  44.627  1.00 20.09           C  
ATOM    943  C   GLY A 130      84.286 113.038  45.095  1.00 17.89           C  
ATOM    944  O   GLY A 130      84.797 113.815  44.289  1.00 19.94           O  
ATOM    945  N   GLY A 131      84.461 113.144  46.407  1.00 15.47           N  
ATOM    946  CA  GLY A 131      85.286 114.214  46.939  1.00 14.19           C  
ATOM    947  C   GLY A 131      85.397 114.186  48.453  1.00 14.34           C  
ATOM    948  O   GLY A 131      84.992 113.236  49.092  1.00 14.21           O  
ATOM    949  N   ILE A 132      85.930 115.265  49.015  1.00 14.06           N  
ATOM    950  CA  ILE A 132      86.186 115.362  50.446  1.00 14.94           C  
ATOM    951  C   ILE A 132      85.911 116.745  50.995  1.00 14.38           C  
ATOM    952  O   ILE A 132      85.855 117.729  50.238  1.00 14.47           O  
ATOM    953  CB  ILE A 132      87.691 115.075  50.768  1.00 15.10           C  
ATOM    954  CG1 ILE A 132      88.594 116.180  50.221  1.00 14.67           C  
ATOM    955  CG2 ILE A 132      88.089 113.732  50.164  1.00 16.61           C  
ATOM    956  CD1 ILE A 132      90.058 116.059  50.678  1.00 16.62           C  
ATOM    957  N   LEU A 133      85.695 116.817  52.310  1.00 13.69           N  
ATOM    958  CA  LEU A 133      85.581 118.123  52.954  1.00 13.88           C  
ATOM    959  C   LEU A 133      87.052 118.539  53.118  1.00 15.59           C  
ATOM    960  O   LEU A 133      87.929 117.714  53.426  1.00 13.80           O  
ATOM    961  CB  LEU A 133      84.918 118.015  54.330  1.00 15.17           C  
ATOM    962  CG  LEU A 133      83.402 117.816  54.323  1.00 16.31           C  
ATOM    963  CD1 LEU A 133      82.919 117.679  55.763  1.00 17.90           C  
ATOM    964  CD2 LEU A 133      82.739 119.007  53.629  1.00 18.95           C  
ATOM    965  N   ALA A 134      87.291 119.822  52.932  1.00 14.43           N  
ATOM    966  CA  ALA A 134      88.636 120.358  53.047  1.00 14.67           C  
ATOM    967  C   ALA A 134      88.571 121.817  53.457  1.00 16.40           C  
ATOM    968  O   ALA A 134      87.578 122.505  53.176  1.00 17.44           O  
ATOM    969  CB  ALA A 134      89.368 120.212  51.716  1.00 14.75           C  
ATOM    970  N   ALA A 135      89.604 122.302  54.152  1.00 16.50           N  
ATOM    971  CA  ALA A 135      89.615 123.704  54.571  1.00 18.42           C  
ATOM    972  C   ALA A 135      90.819 124.359  53.925  1.00 18.65           C  
ATOM    973  O   ALA A 135      91.911 123.776  53.892  1.00 17.51           O  
ATOM    974  CB  ALA A 135      89.687 123.802  56.087  1.00 18.83           C  
ATOM    975  N   PRO A 136      90.630 125.573  53.382  1.00 21.20           N  
ATOM    976  CA  PRO A 136      91.734 126.271  52.733  1.00 21.24           C  
ATOM    977  C   PRO A 136      92.858 126.609  53.690  1.00 21.37           C  
ATOM    978  O   PRO A 136      92.637 126.921  54.860  1.00 22.04           O  
ATOM    979  CB  PRO A 136      91.083 127.537  52.179  1.00 22.83           C  
ATOM    980  CG  PRO A 136      89.659 127.206  52.049  1.00 25.42           C  
ATOM    981  CD  PRO A 136      89.380 126.339  53.266  1.00 22.83           C  
ATOM    982  N   VAL A 137      94.080 126.570  53.192  1.00 22.23           N  
ATOM    983  CA  VAL A 137      95.207 126.936  54.031  1.00 23.94           C  
ATOM    984  C   VAL A 137      95.193 128.441  54.264  1.00 24.50           C  
ATOM    985  O   VAL A 137      95.006 129.222  53.327  1.00 24.80           O  
ATOM    986  CB  VAL A 137      96.521 126.553  53.372  1.00 24.21           C  
ATOM    987  CG1 VAL A 137      97.681 127.210  54.132  1.00 24.80           C  
ATOM    988  CG2 VAL A 137      96.671 125.038  53.399  1.00 23.85           C  
ATOM    989  N   ARG A 138      95.387 128.834  55.522  1.00 26.40           N  
ATOM    990  CA  ARG A 138      95.408 130.241  55.913  1.00 28.86           C  
ATOM    991  C   ARG A 138      96.823 130.758  56.204  1.00 28.18           C  
ATOM    992  O   ARG A 138      97.172 131.852  55.795  1.00 30.38           O  
ATOM    993  CB  ARG A 138      94.546 130.461  57.162  1.00 31.47           C  
ATOM    994  CG  ARG A 138      93.090 130.047  57.012  1.00 33.50           C  
ATOM    995  CD  ARG A 138      92.467 130.651  55.760  1.00 35.94           C  
ATOM    996  NE  ARG A 138      91.016 130.452  55.709  1.00 39.01           N  
ATOM    997  CZ  ARG A 138      90.251 130.825  54.687  1.00 39.51           C  
ATOM    998  NH1 ARG A 138      90.803 131.408  53.629  1.00 40.74           N  
ATOM    999  NH2 ARG A 138      88.938 130.634  54.726  1.00 39.65           N  
ATOM   1000  N   ASP A 139      97.642 129.990  56.914  1.00 28.82           N  
ATOM   1001  CA  ASP A 139      98.990 130.469  57.234  1.00 27.40           C  
ATOM   1002  C   ASP A 139      99.968 130.451  56.053  1.00 24.86           C  
ATOM   1003  O   ASP A 139      99.784 129.717  55.088  1.00 24.34           O  
ATOM   1004  CB  ASP A 139      99.606 129.632  58.364  1.00 31.19           C  
ATOM   1005  CG  ASP A 139      99.056 129.994  59.743  1.00 35.03           C  
ATOM   1006  OD1 ASP A 139      98.964 131.200  60.055  1.00 35.75           O  
ATOM   1007  OD2 ASP A 139      98.745 129.065  60.518  1.00 35.95           O  
ATOM   1008  N   THR A 140     101.004 131.274  56.127  1.00 22.06           N  
ATOM   1009  CA  THR A 140     102.049 131.246  55.127  1.00 21.54           C  
ATOM   1010  C   THR A 140     102.744 129.917  55.456  1.00 20.39           C  
ATOM   1011  O   THR A 140     102.950 129.599  56.623  1.00 22.80           O  
ATOM   1012  CB  THR A 140     102.995 132.452  55.299  1.00 18.94           C  
ATOM   1013  OG1 THR A 140     102.316 133.639  54.847  1.00 22.86           O  
ATOM   1014  CG2 THR A 140     104.263 132.255  54.504  1.00 21.19           C  
ATOM   1015  N   MET A 141     103.051 129.109  54.449  1.00 20.54           N  
ATOM   1016  CA  MET A 141     103.689 127.822  54.673  1.00 18.82           C  
ATOM   1017  C   MET A 141     105.126 127.800  54.204  1.00 20.49           C  
ATOM   1018  O   MET A 141     105.469 128.405  53.177  1.00 20.81           O  
ATOM   1019  CB  MET A 141     102.911 126.713  53.956  1.00 21.79           C  
ATOM   1020  CG  MET A 141     101.440 126.717  54.231  1.00 22.56           C  
ATOM   1021  SD  MET A 141     101.122 126.369  55.992  1.00 19.72           S  
ATOM   1022  CE  MET A 141      99.818 124.970  55.856  1.00 29.29           C  
ATOM   1023  N   LYS A 142     105.965 127.121  54.980  1.00 18.18           N  
ATOM   1024  CA  LYS A 142     107.384 127.006  54.673  1.00 19.84           C  
ATOM   1025  C   LYS A 142     107.776 125.558  54.459  1.00 21.09           C  
ATOM   1026  O   LYS A 142     107.316 124.668  55.165  1.00 21.48           O  
ATOM   1027  CB  LYS A 142     108.249 127.528  55.832  1.00 19.44           C  
ATOM   1028  CG  LYS A 142     107.931 128.940  56.288  1.00 17.89           C  
ATOM   1029  CD  LYS A 142     108.175 129.972  55.188  1.00 18.39           C  
ATOM   1030  CE  LYS A 142     107.961 131.380  55.696  1.00 17.25           C  
ATOM   1031  NZ  LYS A 142     108.297 132.412  54.684  1.00 19.49           N  
ATOM   1032  N   ARG A 143     108.634 125.340  53.478  1.00 22.86           N  
ATOM   1033  CA  ARG A 143     109.176 124.023  53.215  1.00 23.73           C  
ATOM   1034  C   ARG A 143     110.578 124.081  53.801  1.00 24.30           C  
ATOM   1035  O   ARG A 143     111.321 125.038  53.542  1.00 24.65           O  
ATOM   1036  CB  ARG A 143     109.243 123.764  51.710  1.00 26.76           C  
ATOM   1037  CG  ARG A 143     109.932 122.465  51.312  1.00 29.36           C  
ATOM   1038  CD  ARG A 143     108.919 121.483  50.787  1.00 33.79           C  
ATOM   1039  NE  ARG A 143     108.476 120.565  51.814  1.00 35.20           N  
ATOM   1040  CZ  ARG A 143     107.293 119.954  51.821  1.00 31.03           C  
ATOM   1041  NH1 ARG A 143     106.400 120.156  50.853  1.00 30.90           N  
ATOM   1042  NH2 ARG A 143     107.012 119.134  52.806  1.00 31.94           N  
ATOM   1043  N   ALA A 144     110.938 123.072  54.590  1.00 24.40           N  
ATOM   1044  CA  ALA A 144     112.251 123.020  55.227  1.00 26.18           C  
ATOM   1045  C   ALA A 144     113.245 122.358  54.311  1.00 28.27           C  
ATOM   1046  O   ALA A 144     112.868 121.593  53.422  1.00 28.23           O  
ATOM   1047  CB  ALA A 144     112.171 122.229  56.523  1.00 26.12           C  
ATOM   1048  N   GLU A 145     114.522 122.658  54.523  1.00 29.79           N  
ATOM   1049  CA  GLU A 145     115.558 122.026  53.732  1.00 32.11           C  
ATOM   1050  C   GLU A 145     115.671 120.606  54.257  1.00 32.50           C  
ATOM   1051  O   GLU A 145     115.515 120.355  55.453  1.00 31.47           O  
ATOM   1052  CB  GLU A 145     116.891 122.757  53.884  1.00 33.29           C  
ATOM   1053  CG  GLU A 145     116.851 124.144  53.296  1.00 36.25           C  
ATOM   1054  CD  GLU A 145     118.194 124.837  53.297  1.00 40.15           C  
ATOM   1055  OE1 GLU A 145     118.873 124.840  54.344  1.00 41.86           O  
ATOM   1056  OE2 GLU A 145     118.568 125.395  52.247  1.00 42.54           O  
ATOM   1057  N   PRO A 146     115.917 119.648  53.357  1.00 33.14           N  
ATOM   1058  CA  PRO A 146     116.047 118.233  53.703  1.00 34.87           C  
ATOM   1059  C   PRO A 146     116.878 117.946  54.958  1.00 35.26           C  
ATOM   1060  O   PRO A 146     118.060 118.274  55.024  1.00 36.94           O  
ATOM   1061  CB  PRO A 146     116.665 117.632  52.440  1.00 34.76           C  
ATOM   1062  CG  PRO A 146     116.052 118.450  51.358  1.00 34.44           C  
ATOM   1063  CD  PRO A 146     116.116 119.863  51.914  1.00 33.97           C  
ATOM   1064  N   GLY A 147     116.232 117.346  55.951  1.00 35.93           N  
ATOM   1065  CA  GLY A 147     116.898 116.979  57.187  1.00 36.52           C  
ATOM   1066  C   GLY A 147     117.288 118.079  58.153  1.00 37.21           C  
ATOM   1067  O   GLY A 147     117.805 117.784  59.230  1.00 38.11           O  
ATOM   1068  N   LYS A 148     117.042 119.335  57.791  1.00 35.65           N  
ATOM   1069  CA  LYS A 148     117.396 120.454  58.658  1.00 36.58           C  
ATOM   1070  C   LYS A 148     116.218 121.365  58.951  1.00 35.76           C  
ATOM   1071  O   LYS A 148     115.289 121.458  58.152  1.00 36.06           O  
ATOM   1072  CB  LYS A 148     118.512 121.274  58.018  1.00 37.09           C  
ATOM   1073  CG  LYS A 148     119.843 120.555  57.997  1.00 40.26           C  
ATOM   1074  CD  LYS A 148     120.988 121.504  57.690  1.00 41.04           C  
ATOM   1075  CE  LYS A 148     120.960 122.759  58.573  1.00 43.30           C  
ATOM   1076  NZ  LYS A 148     120.125 123.863  57.990  1.00 44.57           N  
ATOM   1077  N   ASN A 149     116.264 122.050  60.092  1.00 35.90           N  
ATOM   1078  CA  ASN A 149     115.179 122.960  60.455  1.00 34.51           C  
ATOM   1079  C   ASN A 149     115.433 124.383  59.961  1.00 32.89           C  
ATOM   1080  O   ASN A 149     115.306 125.345  60.709  1.00 32.09           O  
ATOM   1081  CB  ASN A 149     114.959 122.934  61.975  1.00 36.32           C  
ATOM   1082  CG  ASN A 149     114.265 121.651  62.442  1.00 38.37           C  
ATOM   1083  OD1 ASN A 149     114.658 121.043  63.436  1.00 40.02           O  
ATOM   1084  ND2 ASN A 149     113.219 121.241  61.719  1.00 37.76           N  
ATOM   1085  N   ALA A 150     115.800 124.498  58.690  1.00 31.91           N  
ATOM   1086  CA  ALA A 150     116.054 125.781  58.050  1.00 29.84           C  
ATOM   1087  C   ALA A 150     115.092 125.878  56.869  1.00 28.56           C  
ATOM   1088  O   ALA A 150     114.809 124.877  56.215  1.00 26.22           O  
ATOM   1089  CB  ALA A 150     117.480 125.847  57.559  1.00 31.03           C  
ATOM   1090  N   ILE A 151     114.573 127.074  56.606  1.00 25.35           N  
ATOM   1091  CA  ILE A 151     113.638 127.265  55.503  1.00 24.89           C  
ATOM   1092  C   ILE A 151     114.273 127.161  54.124  1.00 25.39           C  
ATOM   1093  O   ILE A 151     115.239 127.849  53.839  1.00 23.83           O  
ATOM   1094  CB  ILE A 151     112.961 128.645  55.589  1.00 24.59           C  
ATOM   1095  CG1 ILE A 151     112.094 128.713  56.848  1.00 24.97           C  
ATOM   1096  CG2 ILE A 151     112.110 128.884  54.353  1.00 24.11           C  
ATOM   1097  CD1 ILE A 151     111.542 130.113  57.144  1.00 24.33           C  
ATOM   1098  N   ALA A 152     113.728 126.299  53.270  1.00 24.12           N  
ATOM   1099  CA  ALA A 152     114.216 126.178  51.902  1.00 25.92           C  
ATOM   1100  C   ALA A 152     113.519 127.279  51.118  1.00 25.62           C  
ATOM   1101  O   ALA A 152     114.155 128.066  50.432  1.00 26.48           O  
ATOM   1102  CB  ALA A 152     113.845 124.824  51.329  1.00 25.91           C  
ATOM   1103  N   HIS A 153     112.195 127.332  51.214  1.00 25.01           N  
ATOM   1104  CA  HIS A 153     111.434 128.361  50.518  1.00 24.55           C  
ATOM   1105  C   HIS A 153     110.003 128.349  51.041  1.00 22.29           C  
ATOM   1106  O   HIS A 153     109.627 127.470  51.812  1.00 23.20           O  
ATOM   1107  CB  HIS A 153     111.418 128.093  49.004  1.00 26.59           C  
ATOM   1108  CG  HIS A 153     110.785 126.788  48.639  1.00 28.65           C  
ATOM   1109  ND1 HIS A 153     111.506 125.620  48.505  1.00 30.04           N  
ATOM   1110  CD2 HIS A 153     109.487 126.452  48.449  1.00 30.30           C  
ATOM   1111  CE1 HIS A 153     110.677 124.621  48.252  1.00 30.97           C  
ATOM   1112  NE2 HIS A 153     109.445 125.100  48.214  1.00 30.71           N  
ATOM   1113  N   THR A 154     109.231 129.343  50.638  1.00 21.12           N  
ATOM   1114  CA  THR A 154     107.831 129.446  51.030  1.00 22.94           C  
ATOM   1115  C   THR A 154     107.018 128.657  50.010  1.00 23.93           C  
ATOM   1116  O   THR A 154     107.279 128.739  48.810  1.00 25.46           O  
ATOM   1117  CB  THR A 154     107.357 130.906  51.015  1.00 24.19           C  
ATOM   1118  OG1 THR A 154     108.031 131.631  52.051  1.00 23.21           O  
ATOM   1119  CG2 THR A 154     105.871 131.001  51.262  1.00 24.66           C  
ATOM   1120  N   VAL A 155     106.047 127.889  50.490  1.00 22.03           N  
ATOM   1121  CA  VAL A 155     105.180 127.098  49.609  1.00 24.40           C  
ATOM   1122  C   VAL A 155     103.900 127.901  49.326  1.00 25.21           C  
ATOM   1123  O   VAL A 155     103.217 128.311  50.255  1.00 26.11           O  
ATOM   1124  CB  VAL A 155     104.822 125.742  50.291  1.00 24.83           C  
ATOM   1125  CG1 VAL A 155     103.787 124.974  49.453  1.00 25.09           C  
ATOM   1126  CG2 VAL A 155     106.079 124.895  50.448  1.00 24.94           C  
ATOM   1127  N   ASP A 156     103.589 128.126  48.048  1.00 25.57           N  
ATOM   1128  CA  ASP A 156     102.399 128.884  47.645  1.00 26.92           C  
ATOM   1129  C   ASP A 156     101.178 128.238  48.286  1.00 26.54           C  
ATOM   1130  O   ASP A 156     100.891 127.068  48.010  1.00 24.75           O  
ATOM   1131  CB  ASP A 156     102.228 128.835  46.124  1.00 29.67           C  
ATOM   1132  CG  ASP A 156     101.199 129.843  45.601  1.00 33.33           C  
ATOM   1133  OD1 ASP A 156     100.343 130.322  46.367  1.00 33.65           O  
ATOM   1134  OD2 ASP A 156     101.256 130.151  44.398  1.00 37.09           O  
ATOM   1135  N   ARG A 157     100.454 128.984  49.116  1.00 26.65           N  
ATOM   1136  CA  ARG A 157      99.272 128.428  49.769  1.00 28.17           C  
ATOM   1137  C   ARG A 157      98.010 128.553  48.927  1.00 29.81           C  
ATOM   1138  O   ARG A 157      96.951 128.041  49.307  1.00 27.86           O  
ATOM   1139  CB  ARG A 157      99.051 129.087  51.133  1.00 29.15           C  
ATOM   1140  CG  ARG A 157      98.491 130.501  51.101  1.00 31.67           C  
ATOM   1141  CD  ARG A 157      98.385 131.055  52.518  1.00 33.16           C  
ATOM   1142  NE  ARG A 157      97.998 132.456  52.541  1.00 33.82           N  
ATOM   1143  CZ  ARG A 157      96.787 132.908  52.237  1.00 37.62           C  
ATOM   1144  NH1 ARG A 157      95.822 132.060  51.888  1.00 37.67           N  
ATOM   1145  NH2 ARG A 157      96.546 134.217  52.260  1.00 38.56           N  
ATOM   1146  N   ASN A 158      98.120 129.224  47.789  1.00 29.23           N  
ATOM   1147  CA  ASN A 158      96.990 129.396  46.889  1.00 31.05           C  
ATOM   1148  C   ASN A 158      96.670 128.035  46.260  1.00 28.97           C  
ATOM   1149  O   ASN A 158      97.511 127.432  45.592  1.00 28.82           O  
ATOM   1150  CB  ASN A 158      97.358 130.427  45.825  1.00 35.09           C  
ATOM   1151  CG  ASN A 158      96.317 130.556  44.753  1.00 38.50           C  
ATOM   1152  OD1 ASN A 158      95.164 130.913  45.019  1.00 41.84           O  
ATOM   1153  ND2 ASN A 158      96.712 130.263  43.519  1.00 40.36           N  
ATOM   1154  N   GLY A 159      95.454 127.547  46.493  1.00 26.54           N  
ATOM   1155  CA  GLY A 159      95.064 126.253  45.963  1.00 25.10           C  
ATOM   1156  C   GLY A 159      95.539 125.109  46.858  1.00 23.88           C  
ATOM   1157  O   GLY A 159      95.546 123.953  46.447  1.00 24.52           O  
ATOM   1158  N   LEU A 160      95.940 125.428  48.082  1.00 22.01           N  
ATOM   1159  CA  LEU A 160      96.412 124.408  49.007  1.00 21.11           C  
ATOM   1160  C   LEU A 160      95.325 124.209  50.052  1.00 20.88           C  
ATOM   1161  O   LEU A 160      94.783 125.178  50.590  1.00 19.19           O  
ATOM   1162  CB  LEU A 160      97.713 124.866  49.651  1.00 20.06           C  
ATOM   1163  CG  LEU A 160      98.440 123.821  50.486  1.00 20.38           C  
ATOM   1164  CD1 LEU A 160      98.984 122.693  49.569  1.00 19.80           C  
ATOM   1165  CD2 LEU A 160      99.570 124.527  51.227  1.00 20.99           C  
ATOM   1166  N   TRP A 161      95.025 122.949  50.368  1.00 18.53           N  
ATOM   1167  CA  TRP A 161      93.936 122.634  51.292  1.00 17.82           C  
ATOM   1168  C   TRP A 161      94.281 121.589  52.355  1.00 16.50           C  
ATOM   1169  O   TRP A 161      95.058 120.666  52.099  1.00 16.80           O  
ATOM   1170  CB  TRP A 161      92.745 122.076  50.491  1.00 17.98           C  
ATOM   1171  CG  TRP A 161      92.102 123.004  49.493  1.00 20.02           C  
ATOM   1172  CD1 TRP A 161      92.616 123.406  48.285  1.00 19.82           C  
ATOM   1173  CD2 TRP A 161      90.822 123.635  49.615  1.00 20.60           C  
ATOM   1174  NE1 TRP A 161      91.735 124.240  47.657  1.00 22.29           N  
ATOM   1175  CE2 TRP A 161      90.624 124.401  48.444  1.00 21.84           C  
ATOM   1176  CE3 TRP A 161      89.820 123.624  50.603  1.00 22.46           C  
ATOM   1177  CZ2 TRP A 161      89.459 125.154  48.227  1.00 24.22           C  
ATOM   1178  CZ3 TRP A 161      88.670 124.369  50.392  1.00 23.55           C  
ATOM   1179  CH2 TRP A 161      88.496 125.125  49.210  1.00 25.97           C  
ATOM   1180  N   HIS A 162      93.684 121.748  53.538  1.00 17.00           N  
ATOM   1181  CA  HIS A 162      93.806 120.756  54.609  1.00 16.90           C  
ATOM   1182  C   HIS A 162      92.719 119.689  54.305  1.00 17.14           C  
ATOM   1183  O   HIS A 162      91.554 120.042  54.232  1.00 17.38           O  
ATOM   1184  CB  HIS A 162      93.416 121.355  55.967  1.00 18.80           C  
ATOM   1185  CG  HIS A 162      94.417 122.288  56.559  1.00 22.09           C  
ATOM   1186  ND1 HIS A 162      94.446 123.639  56.277  1.00 25.18           N  
ATOM   1187  CD2 HIS A 162      95.372 122.074  57.491  1.00 20.98           C  
ATOM   1188  CE1 HIS A 162      95.377 124.216  57.017  1.00 21.57           C  
ATOM   1189  NE2 HIS A 162      95.952 123.288  57.764  1.00 25.33           N  
ATOM   1190  N   ALA A 163      93.092 118.432  54.112  1.00 15.32           N  
ATOM   1191  CA  ALA A 163      92.122 117.373  53.861  1.00 15.69           C  
ATOM   1192  C   ALA A 163      91.433 117.028  55.169  1.00 17.78           C  
ATOM   1193  O   ALA A 163      92.089 116.846  56.201  1.00 19.71           O  
ATOM   1194  CB  ALA A 163      92.824 116.153  53.310  1.00 16.62           C  
ATOM   1195  N   LEU A 164      90.102 116.966  55.158  1.00 14.50           N  
ATOM   1196  CA  LEU A 164      89.362 116.601  56.391  1.00 15.08           C  
ATOM   1197  C   LEU A 164      88.536 115.365  56.069  1.00 13.76           C  
ATOM   1198  O   LEU A 164      88.734 114.728  55.041  1.00 13.57           O  
ATOM   1199  CB  LEU A 164      88.411 117.732  56.789  1.00 15.35           C  
ATOM   1200  CG  LEU A 164      89.066 119.127  56.907  1.00 16.98           C  
ATOM   1201  CD1 LEU A 164      87.988 120.192  57.120  1.00 17.50           C  
ATOM   1202  CD2 LEU A 164      90.077 119.144  58.048  1.00 18.03           C  
ATOM   1203  N   THR A 165      87.640 114.958  56.970  1.00 15.00           N  
ATOM   1204  CA  THR A 165      86.719 113.879  56.636  1.00 15.19           C  
ATOM   1205  C   THR A 165      85.348 114.417  57.096  1.00 14.81           C  
ATOM   1206  O   THR A 165      85.278 115.339  57.923  1.00 14.65           O  
ATOM   1207  CB  THR A 165      87.060 112.487  57.295  1.00 17.00           C  
ATOM   1208  OG1 THR A 165      86.671 112.482  58.672  1.00 15.96           O  
ATOM   1209  CG2 THR A 165      88.581 112.165  57.147  1.00 18.21           C  
ATOM   1210  N   PRO A 166      84.251 113.822  56.626  1.00 12.88           N  
ATOM   1211  CA  PRO A 166      84.154 112.694  55.701  1.00 13.30           C  
ATOM   1212  C   PRO A 166      84.711 112.888  54.305  1.00 13.51           C  
ATOM   1213  O   PRO A 166      84.899 114.017  53.834  1.00 12.70           O  
ATOM   1214  CB  PRO A 166      82.650 112.421  55.621  1.00 13.34           C  
ATOM   1215  CG  PRO A 166      82.094 113.045  56.826  1.00 14.18           C  
ATOM   1216  CD  PRO A 166      82.909 114.297  56.989  1.00 14.04           C  
ATOM   1217  N   GLN A 167      84.898 111.738  53.666  1.00 12.12           N  
ATOM   1218  CA  GLN A 167      85.361 111.648  52.285  1.00 13.36           C  
ATOM   1219  C   GLN A 167      84.292 110.733  51.684  1.00 12.99           C  
ATOM   1220  O   GLN A 167      83.934 109.695  52.241  1.00 16.07           O  
ATOM   1221  CB  GLN A 167      86.774 111.081  52.248  1.00 14.05           C  
ATOM   1222  CG  GLN A 167      87.708 111.989  53.008  1.00 12.86           C  
ATOM   1223  CD  GLN A 167      89.145 111.901  52.573  1.00 14.93           C  
ATOM   1224  OE1 GLN A 167      89.533 110.996  51.811  1.00 16.25           O  
ATOM   1225  NE2 GLN A 167      89.958 112.842  53.060  1.00 14.77           N  
ATOM   1226  N   PHE A 168      83.749 111.175  50.553  1.00 11.26           N  
ATOM   1227  CA  PHE A 168      82.599 110.535  49.915  1.00 13.13           C  
ATOM   1228  C   PHE A 168      82.869 110.045  48.507  1.00 13.23           C  
ATOM   1229  O   PHE A 168      83.189 110.847  47.620  1.00 13.44           O  
ATOM   1230  CB  PHE A 168      81.517 111.614  49.910  1.00 13.25           C  
ATOM   1231  CG  PHE A 168      80.179 111.161  49.486  1.00 11.37           C  
ATOM   1232  CD1 PHE A 168      79.576 110.042  50.058  1.00 11.71           C  
ATOM   1233  CD2 PHE A 168      79.483 111.928  48.539  1.00 13.25           C  
ATOM   1234  CE1 PHE A 168      78.259 109.676  49.701  1.00 11.95           C  
ATOM   1235  CE2 PHE A 168      78.192 111.578  48.173  1.00 14.12           C  
ATOM   1236  CZ  PHE A 168      77.564 110.464  48.740  1.00 12.70           C  
ATOM   1237  N   PHE A 169      82.718 108.744  48.297  1.00 13.59           N  
ATOM   1238  CA  PHE A 169      83.035 108.188  46.968  1.00 13.39           C  
ATOM   1239  C   PHE A 169      82.147 107.050  46.566  1.00 14.13           C  
ATOM   1240  O   PHE A 169      81.487 106.447  47.399  1.00 13.84           O  
ATOM   1241  CB  PHE A 169      84.432 107.570  46.984  1.00 15.42           C  
ATOM   1242  CG  PHE A 169      85.499 108.500  47.400  1.00 14.61           C  
ATOM   1243  CD1 PHE A 169      85.979 108.496  48.701  1.00 18.69           C  
ATOM   1244  CD2 PHE A 169      86.036 109.374  46.483  1.00 16.77           C  
ATOM   1245  CE1 PHE A 169      86.992 109.365  49.083  1.00 18.22           C  
ATOM   1246  CE2 PHE A 169      87.049 110.244  46.850  1.00 19.94           C  
ATOM   1247  CZ  PHE A 169      87.514 110.226  48.162  1.00 17.31           C  
ATOM   1248  N   PRO A 170      82.093 106.748  45.249  1.00 14.14           N  
ATOM   1249  CA  PRO A 170      81.281 105.603  44.826  1.00 13.06           C  
ATOM   1250  C   PRO A 170      81.965 104.411  45.557  1.00 14.42           C  
ATOM   1251  O   PRO A 170      83.187 104.293  45.578  1.00 15.68           O  
ATOM   1252  CB  PRO A 170      81.522 105.549  43.314  1.00 14.35           C  
ATOM   1253  CG  PRO A 170      81.710 106.979  42.957  1.00 13.77           C  
ATOM   1254  CD  PRO A 170      82.525 107.560  44.100  1.00 14.67           C  
ATOM   1255  N   ARG A 171      81.166 103.540  46.144  1.00 14.63           N  
ATOM   1256  CA  ARG A 171      81.625 102.414  46.948  1.00 15.74           C  
ATOM   1257  C   ARG A 171      82.626 101.478  46.268  1.00 17.28           C  
ATOM   1258  O   ARG A 171      83.746 101.255  46.752  1.00 18.60           O  
ATOM   1259  CB  ARG A 171      80.407 101.602  47.387  1.00 18.56           C  
ATOM   1260  CG  ARG A 171      80.596 100.737  48.650  1.00 25.81           C  
ATOM   1261  CD  ARG A 171      80.370  99.257  48.407  1.00 31.74           C  
ATOM   1262  NE  ARG A 171      79.162  98.996  47.633  1.00 36.01           N  
ATOM   1263  CZ  ARG A 171      79.002  97.938  46.846  1.00 38.28           C  
ATOM   1264  NH1 ARG A 171      79.969  97.036  46.747  1.00 40.19           N  
ATOM   1265  NH2 ARG A 171      77.902  97.812  46.111  1.00 39.58           N  
ATOM   1266  N   GLU A 172      82.236 100.931  45.124  1.00 18.88           N  
ATOM   1267  CA  GLU A 172      83.139  99.980  44.476  1.00 16.00           C  
ATOM   1268  C   GLU A 172      84.403 100.645  43.910  1.00 14.89           C  
ATOM   1269  O   GLU A 172      85.507 100.056  43.938  1.00 15.66           O  
ATOM   1270  CB  GLU A 172      82.378  99.163  43.402  1.00 16.36           C  
ATOM   1271  CG  GLU A 172      81.195  98.356  43.965  1.00 15.44           C  
ATOM   1272  CD  GLU A 172      80.574  97.335  43.001  1.00 16.44           C  
ATOM   1273  OE1 GLU A 172      80.825  97.389  41.784  1.00 15.96           O  
ATOM   1274  OE2 GLU A 172      79.831  96.452  43.460  1.00 18.46           O  
ATOM   1275  N   LEU A 173      84.288 101.893  43.458  1.00 14.93           N  
ATOM   1276  CA  LEU A 173      85.479 102.585  42.949  1.00 14.26           C  
ATOM   1277  C   LEU A 173      86.463 102.755  44.122  1.00 16.49           C  
ATOM   1278  O   LEU A 173      87.642 102.516  43.964  1.00 17.22           O  
ATOM   1279  CB  LEU A 173      85.105 103.957  42.356  1.00 17.79           C  
ATOM   1280  CG  LEU A 173      86.264 104.822  41.860  1.00 19.85           C  
ATOM   1281  CD1 LEU A 173      87.040 104.073  40.794  1.00 22.91           C  
ATOM   1282  CD2 LEU A 173      85.751 106.152  41.285  1.00 22.31           C  
ATOM   1283  N   LEU A 174      85.964 103.142  45.300  1.00 16.30           N  
ATOM   1284  CA  LEU A 174      86.843 103.324  46.451  1.00 17.77           C  
ATOM   1285  C   LEU A 174      87.488 102.013  46.829  1.00 16.66           C  
ATOM   1286  O   LEU A 174      88.695 101.952  47.066  1.00 19.56           O  
ATOM   1287  CB  LEU A 174      86.092 103.831  47.679  1.00 17.37           C  
ATOM   1288  CG  LEU A 174      87.025 103.944  48.909  1.00 16.41           C  
ATOM   1289  CD1 LEU A 174      88.198 104.867  48.645  1.00 16.68           C  
ATOM   1290  CD2 LEU A 174      86.200 104.472  50.075  1.00 18.31           C  
ATOM   1291  N   HIS A 175      86.677 100.960  46.907  1.00 16.23           N  
ATOM   1292  CA  HIS A 175      87.186  99.645  47.256  1.00 17.84           C  
ATOM   1293  C   HIS A 175      88.317  99.253  46.282  1.00 18.52           C  
ATOM   1294  O   HIS A 175      89.406  98.814  46.695  1.00 21.60           O  
ATOM   1295  CB  HIS A 175      86.047  98.632  47.171  1.00 18.31           C  
ATOM   1296  CG  HIS A 175      86.493  97.215  47.282  1.00 24.14           C  
ATOM   1297  ND1 HIS A 175      87.104  96.548  46.240  1.00 22.60           N  
ATOM   1298  CD2 HIS A 175      86.454  96.349  48.320  1.00 24.60           C  
ATOM   1299  CE1 HIS A 175      87.430  95.330  46.639  1.00 24.60           C  
ATOM   1300  NE2 HIS A 175      87.047  95.185  47.897  1.00 25.81           N  
ATOM   1301  N   ASP A 176      88.077  99.414  44.986  1.00 20.23           N  
ATOM   1302  CA  ASP A 176      89.075  99.042  43.990  1.00 20.27           C  
ATOM   1303  C   ASP A 176      90.361  99.840  44.075  1.00 20.61           C  
ATOM   1304  O   ASP A 176      91.451  99.272  43.986  1.00 20.99           O  
ATOM   1305  CB  ASP A 176      88.504  99.149  42.574  1.00 19.45           C  
ATOM   1306  CG  ASP A 176      87.446  98.106  42.309  1.00 21.69           C  
ATOM   1307  OD1 ASP A 176      87.306  97.162  43.125  1.00 19.34           O  
ATOM   1308  OD2 ASP A 176      86.758  98.250  41.278  1.00 24.25           O  
ATOM   1309  N   CYS A 177      90.234 101.151  44.286  1.00 20.00           N  
ATOM   1310  CA  CYS A 177      91.408 102.031  44.367  1.00 20.79           C  
ATOM   1311  C   CYS A 177      92.246 101.747  45.623  1.00 21.68           C  
ATOM   1312  O   CYS A 177      93.483 101.747  45.538  1.00 22.09           O  
ATOM   1313  CB  CYS A 177      90.970 103.495  44.346  1.00 20.67           C  
ATOM   1314  SG  CYS A 177      90.348 104.023  42.762  1.00 22.45           S  
ATOM   1315  N   LEU A 178      91.587 101.486  46.759  1.00 21.23           N  
ATOM   1316  CA  LEU A 178      92.300 101.170  47.999  1.00 23.61           C  
ATOM   1317  C   LEU A 178      92.976  99.824  47.839  1.00 24.56           C  
ATOM   1318  O   LEU A 178      94.093  99.600  48.323  1.00 25.07           O  
ATOM   1319  CB  LEU A 178      91.337 101.080  49.171  1.00 25.67           C  
ATOM   1320  CG  LEU A 178      91.099 102.340  49.988  1.00 29.12           C  
ATOM   1321  CD1 LEU A 178      89.892 102.151  50.908  1.00 28.75           C  
ATOM   1322  CD2 LEU A 178      92.367 102.655  50.788  1.00 29.42           C  
ATOM   1323  N   THR A 179      92.293  98.920  47.157  1.00 22.87           N  
ATOM   1324  CA  THR A 179      92.848  97.593  46.975  1.00 24.60           C  
ATOM   1325  C   THR A 179      94.097  97.645  46.113  1.00 24.94           C  
ATOM   1326  O   THR A 179      95.097  97.013  46.445  1.00 26.57           O  
ATOM   1327  CB  THR A 179      91.819  96.642  46.352  1.00 23.37           C  
ATOM   1328  OG1 THR A 179      90.792  96.348  47.310  1.00 24.21           O  
ATOM   1329  CG2 THR A 179      92.492  95.332  45.938  1.00 25.29           C  
ATOM   1330  N   ARG A 180      94.051  98.411  45.031  1.00 25.93           N  
ATOM   1331  CA  ARG A 180      95.193  98.532  44.126  1.00 28.90           C  
ATOM   1332  C   ARG A 180      96.353  99.260  44.787  1.00 30.38           C  
ATOM   1333  O   ARG A 180      97.498  98.807  44.716  1.00 31.00           O  
ATOM   1334  CB  ARG A 180      94.807  99.280  42.846  1.00 31.19           C  
ATOM   1335  CG  ARG A 180      95.965  99.415  41.859  1.00 34.98           C  
ATOM   1336  CD  ARG A 180      95.577 100.124  40.561  1.00 38.03           C  
ATOM   1337  NE  ARG A 180      96.455  99.697  39.472  1.00 40.28           N  
ATOM   1338  CZ  ARG A 180      96.400 100.142  38.218  1.00 42.24           C  
ATOM   1339  NH1 ARG A 180      95.498 101.053  37.863  1.00 40.86           N  
ATOM   1340  NH2 ARG A 180      97.245  99.657  37.308  1.00 40.53           N  
ATOM   1341  N   ALA A 181      96.050 100.387  45.427  1.00 29.68           N  
ATOM   1342  CA  ALA A 181      97.074 101.188  46.089  1.00 31.12           C  
ATOM   1343  C   ALA A 181      97.845 100.345  47.097  1.00 32.12           C  
ATOM   1344  O   ALA A 181      99.075 100.361  47.109  1.00 32.87           O  
ATOM   1345  CB  ALA A 181      96.433 102.401  46.782  1.00 29.83           C  
ATOM   1346  N   LEU A 182      97.122  99.604  47.926  1.00 32.43           N  
ATOM   1347  CA  LEU A 182      97.741  98.755  48.931  1.00 34.85           C  
ATOM   1348  C   LEU A 182      98.573  97.634  48.318  1.00 36.76           C  
ATOM   1349  O   LEU A 182      99.678  97.358  48.784  1.00 38.03           O  
ATOM   1350  CB  LEU A 182      96.679  98.151  49.841  1.00 34.05           C  
ATOM   1351  CG  LEU A 182      96.133  99.040  50.967  1.00 35.31           C  
ATOM   1352  CD1 LEU A 182      94.936  98.363  51.636  1.00 34.47           C  
ATOM   1353  CD2 LEU A 182      97.243  99.292  51.991  1.00 36.48           C  
ATOM   1354  N   ASN A 183      98.042  96.989  47.280  1.00 38.69           N  
ATOM   1355  CA  ASN A 183      98.740  95.890  46.617  1.00 40.28           C  
ATOM   1356  C   ASN A 183     100.020  96.375  45.946  1.00 40.57           C  
ATOM   1357  O   ASN A 183     101.022  95.656  45.923  1.00 42.17           O  
ATOM   1358  CB  ASN A 183      97.806  95.210  45.596  1.00 41.11           C  
ATOM   1359  CG  ASN A 183      98.477  94.048  44.847  1.00 43.79           C  
ATOM   1360  OD1 ASN A 183      99.184  94.254  43.854  1.00 44.76           O  
ATOM   1361  ND2 ASN A 183      98.255  92.821  45.329  1.00 44.71           N  
ATOM   1362  N   GLU A 184     100.002  97.596  45.416  1.00 40.62           N  
ATOM   1363  CA  GLU A 184     101.188  98.148  44.761  1.00 40.70           C  
ATOM   1364  C   GLU A 184     102.114  98.874  45.736  1.00 40.35           C  
ATOM   1365  O   GLU A 184     103.040  99.569  45.319  1.00 39.90           O  
ATOM   1366  CB  GLU A 184     100.784  99.098  43.628  1.00 41.23           C  
ATOM   1367  CG  GLU A 184     100.206  98.390  42.416  1.00 42.11           C  
ATOM   1368  CD  GLU A 184     100.009  99.309  41.233  1.00 43.55           C  
ATOM   1369  OE1 GLU A 184     100.896 100.146  40.954  1.00 44.82           O  
ATOM   1370  OE2 GLU A 184      98.974  99.178  40.552  1.00 45.22           O  
ATOM   1371  N   GLY A 185     101.861  98.710  47.029  1.00 40.07           N  
ATOM   1372  CA  GLY A 185     102.689  99.357  48.036  1.00 40.26           C  
ATOM   1373  C   GLY A 185     102.754 100.877  47.947  1.00 40.16           C  
ATOM   1374  O   GLY A 185     103.790 101.486  48.225  1.00 40.65           O  
ATOM   1375  N   ALA A 186     101.652 101.510  47.571  1.00 38.96           N  
ATOM   1376  CA  ALA A 186     101.646 102.963  47.483  1.00 38.35           C  
ATOM   1377  C   ALA A 186     101.518 103.572  48.884  1.00 37.36           C  
ATOM   1378  O   ALA A 186     101.063 102.918  49.820  1.00 36.23           O  
ATOM   1379  CB  ALA A 186     100.494 103.436  46.595  1.00 39.08           C  
ATOM   1380  N   THR A 187     101.935 104.825  49.014  1.00 37.06           N  
ATOM   1381  CA  THR A 187     101.851 105.545  50.279  1.00 36.86           C  
ATOM   1382  C   THR A 187     100.449 106.127  50.392  1.00 34.66           C  
ATOM   1383  O   THR A 187     100.105 107.086  49.709  1.00 36.19           O  
ATOM   1384  CB  THR A 187     102.894 106.674  50.322  1.00 38.15           C  
ATOM   1385  OG1 THR A 187     104.200 106.095  50.402  1.00 40.14           O  
ATOM   1386  CG2 THR A 187     102.663 107.594  51.516  1.00 39.56           C  
ATOM   1387  N   ILE A 188      99.645 105.538  51.263  1.00 32.78           N  
ATOM   1388  CA  ILE A 188      98.268 105.975  51.452  1.00 30.56           C  
ATOM   1389  C   ILE A 188      98.099 106.806  52.709  1.00 28.51           C  
ATOM   1390  O   ILE A 188      98.562 106.409  53.783  1.00 29.64           O  
ATOM   1391  CB  ILE A 188      97.335 104.753  51.538  1.00 30.77           C  
ATOM   1392  CG1 ILE A 188      97.386 104.005  50.211  1.00 32.73           C  
ATOM   1393  CG2 ILE A 188      95.906 105.180  51.875  1.00 33.27           C  
ATOM   1394  CD1 ILE A 188      96.634 102.722  50.234  1.00 34.99           C  
ATOM   1395  N   THR A 189      97.467 107.968  52.568  1.00 24.30           N  
ATOM   1396  CA  THR A 189      97.180 108.829  53.711  1.00 23.45           C  
ATOM   1397  C   THR A 189      95.669 108.747  53.913  1.00 21.70           C  
ATOM   1398  O   THR A 189      95.219 107.975  54.756  1.00 23.46           O  
ATOM   1399  CB  THR A 189      97.642 110.282  53.466  1.00 21.65           C  
ATOM   1400  OG1 THR A 189      97.269 110.703  52.146  1.00 22.78           O  
ATOM   1401  CG2 THR A 189      99.178 110.374  53.620  1.00 24.35           C  
ATOM   1402  N   ASP A 190      94.884 109.477  53.116  1.00 20.37           N  
ATOM   1403  CA  ASP A 190      93.437 109.399  53.259  1.00 17.56           C  
ATOM   1404  C   ASP A 190      92.818 108.607  52.109  1.00 18.64           C  
ATOM   1405  O   ASP A 190      93.536 108.093  51.244  1.00 18.79           O  
ATOM   1406  CB  ASP A 190      92.804 110.805  53.345  1.00 18.74           C  
ATOM   1407  CG  ASP A 190      93.137 111.682  52.159  1.00 20.01           C  
ATOM   1408  OD1 ASP A 190      93.874 111.240  51.237  1.00 18.72           O  
ATOM   1409  OD2 ASP A 190      92.677 112.847  52.114  1.00 20.54           O  
ATOM   1410  N   GLU A 191      91.486 108.511  52.093  1.00 17.53           N  
ATOM   1411  CA  GLU A 191      90.829 107.778  51.018  1.00 18.13           C  
ATOM   1412  C   GLU A 191      91.065 108.456  49.682  1.00 17.16           C  
ATOM   1413  O   GLU A 191      91.238 107.784  48.660  1.00 17.62           O  
ATOM   1414  CB  GLU A 191      89.325 107.639  51.265  1.00 17.63           C  
ATOM   1415  CG  GLU A 191      88.953 106.609  52.344  1.00 20.09           C  
ATOM   1416  CD  GLU A 191      89.568 106.934  53.685  1.00 19.16           C  
ATOM   1417  OE1 GLU A 191      89.321 108.036  54.220  1.00 21.18           O  
ATOM   1418  OE2 GLU A 191      90.311 106.100  54.222  1.00 24.34           O  
ATOM   1419  N   ALA A 192      91.095 109.784  49.663  1.00 17.18           N  
ATOM   1420  CA  ALA A 192      91.325 110.479  48.415  1.00 14.48           C  
ATOM   1421  C   ALA A 192      92.678 110.116  47.827  1.00 18.40           C  
ATOM   1422  O   ALA A 192      92.798 109.996  46.611  1.00 18.30           O  
ATOM   1423  CB  ALA A 192      91.213 111.992  48.610  1.00 17.66           C  
ATOM   1424  N   SER A 193      93.692 109.905  48.669  1.00 19.07           N  
ATOM   1425  CA  SER A 193      95.014 109.573  48.131  1.00 18.06           C  
ATOM   1426  C   SER A 193      94.982 108.252  47.357  1.00 18.30           C  
ATOM   1427  O   SER A 193      95.801 108.061  46.457  1.00 20.80           O  
ATOM   1428  CB  SER A 193      96.086 109.517  49.230  1.00 17.73           C  
ATOM   1429  OG  SER A 193      95.961 108.420  50.077  1.00 20.26           O  
ATOM   1430  N   ALA A 194      94.067 107.355  47.695  1.00 16.97           N  
ATOM   1431  CA  ALA A 194      93.975 106.084  46.950  1.00 18.91           C  
ATOM   1432  C   ALA A 194      93.404 106.364  45.561  1.00 20.52           C  
ATOM   1433  O   ALA A 194      93.858 105.792  44.558  1.00 21.08           O  
ATOM   1434  CB  ALA A 194      93.117 105.076  47.691  1.00 19.39           C  
ATOM   1435  N   LEU A 195      92.383 107.214  45.481  1.00 19.79           N  
ATOM   1436  CA  LEU A 195      91.824 107.571  44.180  1.00 20.37           C  
ATOM   1437  C   LEU A 195      92.896 108.291  43.384  1.00 19.97           C  
ATOM   1438  O   LEU A 195      93.006 108.125  42.175  1.00 21.90           O  
ATOM   1439  CB  LEU A 195      90.633 108.526  44.314  1.00 20.78           C  
ATOM   1440  CG  LEU A 195      89.215 107.995  44.555  1.00 22.80           C  
ATOM   1441  CD1 LEU A 195      88.691 107.454  43.259  1.00 25.32           C  
ATOM   1442  CD2 LEU A 195      89.203 106.939  45.678  1.00 22.18           C  
ATOM   1443  N   GLU A 196      93.669 109.122  44.064  1.00 20.05           N  
ATOM   1444  CA  GLU A 196      94.707 109.876  43.386  1.00 20.99           C  
ATOM   1445  C   GLU A 196      95.716 108.955  42.772  1.00 21.35           C  
ATOM   1446  O   GLU A 196      96.123 109.161  41.634  1.00 23.58           O  
ATOM   1447  CB  GLU A 196      95.395 110.821  44.365  1.00 21.76           C  
ATOM   1448  CG  GLU A 196      94.502 111.985  44.765  1.00 20.76           C  
ATOM   1449  CD  GLU A 196      94.924 112.593  46.082  1.00 22.97           C  
ATOM   1450  OE1 GLU A 196      96.144 112.743  46.273  1.00 22.06           O  
ATOM   1451  OE2 GLU A 196      94.040 112.910  46.924  1.00 20.75           O  
ATOM   1452  N   TYR A 197      96.105 107.934  43.515  1.00 22.77           N  
ATOM   1453  CA  TYR A 197      97.100 107.000  43.019  1.00 24.72           C  
ATOM   1454  C   TYR A 197      96.648 106.340  41.721  1.00 26.56           C  
ATOM   1455  O   TYR A 197      97.468 106.053  40.853  1.00 27.97           O  
ATOM   1456  CB  TYR A 197      97.370 105.932  44.063  1.00 26.61           C  
ATOM   1457  CG  TYR A 197      98.385 104.911  43.631  1.00 30.85           C  
ATOM   1458  CD1 TYR A 197      99.748 105.205  43.632  1.00 34.32           C  
ATOM   1459  CD2 TYR A 197      97.984 103.646  43.222  1.00 32.27           C  
ATOM   1460  CE1 TYR A 197     100.687 104.249  43.242  1.00 36.65           C  
ATOM   1461  CE2 TYR A 197      98.915 102.684  42.826  1.00 35.18           C  
ATOM   1462  CZ  TYR A 197     100.263 102.992  42.844  1.00 36.89           C  
ATOM   1463  OH  TYR A 197     101.185 102.026  42.502  1.00 38.34           O  
ATOM   1464  N   CYS A 198      95.344 106.109  41.595  1.00 25.52           N  
ATOM   1465  CA  CYS A 198      94.765 105.456  40.413  1.00 26.30           C  
ATOM   1466  C   CYS A 198      94.390 106.402  39.257  1.00 27.39           C  
ATOM   1467  O   CYS A 198      93.713 106.010  38.285  1.00 28.52           O  
ATOM   1468  CB  CYS A 198      93.558 104.613  40.856  1.00 25.90           C  
ATOM   1469  SG  CYS A 198      94.010 103.317  42.035  1.00 25.20           S  
ATOM   1470  N   GLY A 199      94.832 107.651  39.360  1.00 25.42           N  
ATOM   1471  CA  GLY A 199      94.570 108.606  38.302  1.00 26.26           C  
ATOM   1472  C   GLY A 199      93.342 109.471  38.436  1.00 25.14           C  
ATOM   1473  O   GLY A 199      93.022 110.233  37.533  1.00 25.93           O  
ATOM   1474  N   PHE A 200      92.638 109.370  39.560  1.00 26.37           N  
ATOM   1475  CA  PHE A 200      91.461 110.199  39.737  1.00 25.04           C  
ATOM   1476  C   PHE A 200      91.775 111.500  40.447  1.00 26.89           C  
ATOM   1477  O   PHE A 200      92.836 111.649  41.083  1.00 26.50           O  
ATOM   1478  CB  PHE A 200      90.376 109.423  40.482  1.00 25.50           C  
ATOM   1479  CG  PHE A 200      89.896 108.224  39.727  1.00 24.59           C  
ATOM   1480  CD1 PHE A 200      90.410 106.968  39.993  1.00 25.24           C  
ATOM   1481  CD2 PHE A 200      88.971 108.361  38.707  1.00 25.79           C  
ATOM   1482  CE1 PHE A 200      90.014 105.856  39.250  1.00 26.77           C  
ATOM   1483  CE2 PHE A 200      88.564 107.244  37.948  1.00 24.86           C  
ATOM   1484  CZ  PHE A 200      89.093 106.003  38.230  1.00 25.84           C  
ATOM   1485  N   HIS A 201      90.844 112.441  40.323  1.00 25.22           N  
ATOM   1486  CA  HIS A 201      90.976 113.755  40.925  1.00 24.61           C  
ATOM   1487  C   HIS A 201      89.693 114.141  41.655  1.00 22.29           C  
ATOM   1488  O   HIS A 201      88.839 114.833  41.105  1.00 23.14           O  
ATOM   1489  CB  HIS A 201      91.315 114.772  39.836  1.00 25.35           C  
ATOM   1490  CG  HIS A 201      92.646 114.530  39.190  1.00 28.31           C  
ATOM   1491  ND1 HIS A 201      92.815 113.681  38.115  1.00 29.37           N  
ATOM   1492  CD2 HIS A 201      93.881 114.987  39.504  1.00 25.98           C  
ATOM   1493  CE1 HIS A 201      94.097 113.625  37.798  1.00 28.23           C  
ATOM   1494  NE2 HIS A 201      94.764 114.408  38.627  1.00 30.23           N  
ATOM   1495  N   PRO A 202      89.555 113.702  42.918  1.00 21.53           N  
ATOM   1496  CA  PRO A 202      88.378 113.982  43.750  1.00 20.85           C  
ATOM   1497  C   PRO A 202      88.122 115.469  43.978  1.00 18.95           C  
ATOM   1498  O   PRO A 202      89.037 116.300  43.945  1.00 18.94           O  
ATOM   1499  CB  PRO A 202      88.698 113.267  45.063  1.00 21.74           C  
ATOM   1500  CG  PRO A 202      89.637 112.179  44.657  1.00 22.71           C  
ATOM   1501  CD  PRO A 202      90.525 112.894  43.671  1.00 21.46           C  
ATOM   1502  N   GLN A 203      86.857 115.797  44.212  1.00 17.48           N  
ATOM   1503  CA  GLN A 203      86.470 117.174  44.443  1.00 19.90           C  
ATOM   1504  C   GLN A 203      86.757 117.637  45.868  1.00 18.65           C  
ATOM   1505  O   GLN A 203      86.731 116.842  46.815  1.00 19.99           O  
ATOM   1506  CB  GLN A 203      84.979 117.362  44.148  1.00 21.10           C  
ATOM   1507  CG  GLN A 203      84.621 117.317  42.677  1.00 28.08           C  
ATOM   1508  CD  GLN A 203      85.166 118.514  41.897  1.00 30.95           C  
ATOM   1509  OE1 GLN A 203      84.918 119.673  42.247  1.00 33.67           O  
ATOM   1510  NE2 GLN A 203      85.898 118.235  40.823  1.00 35.58           N  
ATOM   1511  N   LEU A 204      87.023 118.929  45.988  1.00 17.96           N  
ATOM   1512  CA  LEU A 204      87.274 119.569  47.273  1.00 17.73           C  
ATOM   1513  C   LEU A 204      85.997 120.344  47.604  1.00 18.40           C  
ATOM   1514  O   LEU A 204      85.573 121.214  46.851  1.00 21.14           O  
ATOM   1515  CB  LEU A 204      88.465 120.531  47.153  1.00 17.40           C  
ATOM   1516  CG  LEU A 204      89.813 119.820  46.983  1.00 17.51           C  
ATOM   1517  CD1 LEU A 204      90.861 120.716  46.298  1.00 20.87           C  
ATOM   1518  CD2 LEU A 204      90.296 119.394  48.360  1.00 19.40           C  
ATOM   1519  N   VAL A 205      85.360 120.005  48.718  1.00 18.93           N  
ATOM   1520  CA  VAL A 205      84.152 120.694  49.132  1.00 17.16           C  
ATOM   1521  C   VAL A 205      84.578 121.453  50.367  1.00 18.77           C  
ATOM   1522  O   VAL A 205      84.961 120.848  51.365  1.00 15.90           O  
ATOM   1523  CB  VAL A 205      83.052 119.673  49.468  1.00 16.58           C  
ATOM   1524  CG1 VAL A 205      81.876 120.355  50.116  1.00 19.58           C  
ATOM   1525  CG2 VAL A 205      82.606 118.982  48.193  1.00 16.27           C  
ATOM   1526  N   GLU A 206      84.537 122.775  50.317  1.00 16.64           N  
ATOM   1527  CA  GLU A 206      85.002 123.529  51.472  1.00 17.45           C  
ATOM   1528  C   GLU A 206      84.170 123.298  52.721  1.00 19.50           C  
ATOM   1529  O   GLU A 206      82.939 123.382  52.688  1.00 19.30           O  
ATOM   1530  CB  GLU A 206      85.053 125.028  51.156  1.00 18.08           C  
ATOM   1531  CG  GLU A 206      85.427 125.844  52.384  1.00 20.88           C  
ATOM   1532  CD  GLU A 206      85.855 127.272  52.072  1.00 24.68           C  
ATOM   1533  OE1 GLU A 206      85.724 127.696  50.911  1.00 28.96           O  
ATOM   1534  OE2 GLU A 206      86.324 127.955  53.006  1.00 27.44           O  
ATOM   1535  N   GLY A 207      84.857 123.009  53.822  1.00 18.41           N  
ATOM   1536  CA  GLY A 207      84.196 122.770  55.093  1.00 19.12           C  
ATOM   1537  C   GLY A 207      84.771 123.604  56.231  1.00 18.93           C  
ATOM   1538  O   GLY A 207      85.788 124.276  56.074  1.00 21.68           O  
ATOM   1539  N   ARG A 208      84.091 123.587  57.367  1.00 19.06           N  
ATOM   1540  CA  ARG A 208      84.520 124.364  58.531  1.00 19.78           C  
ATOM   1541  C   ARG A 208      85.850 123.888  59.085  1.00 21.23           C  
ATOM   1542  O   ARG A 208      86.098 122.682  59.223  1.00 20.18           O  
ATOM   1543  CB  ARG A 208      83.466 124.272  59.631  1.00 21.58           C  
ATOM   1544  CG  ARG A 208      82.096 124.733  59.230  1.00 21.81           C  
ATOM   1545  CD  ARG A 208      81.134 124.376  60.331  1.00 26.04           C  
ATOM   1546  NE  ARG A 208      81.533 124.993  61.583  1.00 29.61           N  
ATOM   1547  CZ  ARG A 208      81.118 126.194  61.972  1.00 32.91           C  
ATOM   1548  NH1 ARG A 208      80.283 126.882  61.201  1.00 33.66           N  
ATOM   1549  NH2 ARG A 208      81.566 126.715  63.104  1.00 33.40           N  
ATOM   1550  N   ALA A 209      86.693 124.842  59.464  1.00 20.19           N  
ATOM   1551  CA  ALA A 209      88.000 124.499  60.000  1.00 22.07           C  
ATOM   1552  C   ALA A 209      87.970 123.942  61.425  1.00 21.15           C  
ATOM   1553  O   ALA A 209      88.968 123.400  61.887  1.00 22.58           O  
ATOM   1554  CB  ALA A 209      88.921 125.713  59.930  1.00 22.61           C  
ATOM   1555  N   ASP A 210      86.831 124.060  62.109  1.00 21.12           N  
ATOM   1556  CA  ASP A 210      86.715 123.538  63.461  1.00 22.02           C  
ATOM   1557  C   ASP A 210      86.353 122.061  63.484  1.00 20.57           C  
ATOM   1558  O   ASP A 210      86.104 121.489  64.533  1.00 20.17           O  
ATOM   1559  CB  ASP A 210      85.717 124.333  64.318  1.00 23.44           C  
ATOM   1560  CG  ASP A 210      84.364 124.516  63.665  1.00 27.00           C  
ATOM   1561  OD1 ASP A 210      83.995 123.751  62.752  1.00 22.31           O  
ATOM   1562  OD2 ASP A 210      83.661 125.453  64.103  1.00 30.02           O  
ATOM   1563  N   ASN A 211      86.344 121.452  62.304  1.00 20.30           N  
ATOM   1564  CA  ASN A 211      86.088 120.015  62.173  1.00 18.86           C  
ATOM   1565  C   ASN A 211      87.474 119.402  62.457  1.00 19.59           C  
ATOM   1566  O   ASN A 211      88.155 118.943  61.539  1.00 22.78           O  
ATOM   1567  CB  ASN A 211      85.638 119.735  60.727  1.00 17.88           C  
ATOM   1568  CG  ASN A 211      85.376 118.272  60.461  1.00 17.20           C  
ATOM   1569  OD1 ASN A 211      85.359 117.458  61.376  1.00 17.84           O  
ATOM   1570  ND2 ASN A 211      85.168 117.935  59.196  1.00 14.69           N  
ATOM   1571  N   ILE A 212      87.905 119.407  63.718  1.00 18.63           N  
ATOM   1572  CA  ILE A 212      89.238 118.901  64.081  1.00 20.12           C  
ATOM   1573  C   ILE A 212      89.315 117.435  64.461  1.00 20.41           C  
ATOM   1574  O   ILE A 212      88.305 116.828  64.797  1.00 18.62           O  
ATOM   1575  CB  ILE A 212      89.822 119.709  65.281  1.00 21.81           C  
ATOM   1576  CG1 ILE A 212      88.922 119.530  66.520  1.00 21.05           C  
ATOM   1577  CG2 ILE A 212      89.972 121.174  64.892  1.00 23.96           C  
ATOM   1578  CD1 ILE A 212      89.596 119.953  67.844  1.00 25.88           C  
ATOM   1579  N   LYS A 213      90.532 116.875  64.408  1.00 20.62           N  
ATOM   1580  CA  LYS A 213      90.776 115.495  64.780  1.00 21.12           C  
ATOM   1581  C   LYS A 213      91.467 115.539  66.128  1.00 20.79           C  
ATOM   1582  O   LYS A 213      92.481 116.213  66.297  1.00 23.17           O  
ATOM   1583  CB  LYS A 213      91.690 114.793  63.778  1.00 21.49           C  
ATOM   1584  CG  LYS A 213      91.739 113.287  63.963  1.00 25.43           C  
ATOM   1585  CD  LYS A 213      92.383 112.611  62.768  1.00 27.37           C  
ATOM   1586  CE  LYS A 213      93.721 113.243  62.466  1.00 32.32           C  
ATOM   1587  NZ  LYS A 213      94.326 112.636  61.258  1.00 35.09           N  
ATOM   1588  N   VAL A 214      90.881 114.856  67.086  1.00 19.16           N  
ATOM   1589  CA  VAL A 214      91.436 114.802  68.423  1.00 21.54           C  
ATOM   1590  C   VAL A 214      92.615 113.851  68.303  1.00 21.03           C  
ATOM   1591  O   VAL A 214      92.438 112.672  67.997  1.00 23.65           O  
ATOM   1592  CB  VAL A 214      90.351 114.294  69.369  1.00 21.83           C  
ATOM   1593  CG1 VAL A 214      90.893 114.124  70.772  1.00 22.50           C  
ATOM   1594  CG2 VAL A 214      89.181 115.291  69.357  1.00 19.04           C  
ATOM   1595  N   THR A 215      93.823 114.363  68.524  1.00 23.05           N  
ATOM   1596  CA  THR A 215      95.036 113.569  68.370  1.00 24.43           C  
ATOM   1597  C   THR A 215      95.953 113.657  69.576  1.00 25.56           C  
ATOM   1598  O   THR A 215      96.595 112.669  69.945  1.00 25.59           O  
ATOM   1599  CB  THR A 215      95.837 114.044  67.136  1.00 25.14           C  
ATOM   1600  OG1 THR A 215      94.967 114.109  65.990  1.00 29.21           O  
ATOM   1601  CG2 THR A 215      96.984 113.076  66.843  1.00 28.62           C  
ATOM   1602  N   ARG A 216      96.027 114.853  70.163  1.00 26.72           N  
ATOM   1603  CA  ARG A 216      96.874 115.111  71.330  1.00 28.61           C  
ATOM   1604  C   ARG A 216      96.022 115.481  72.524  1.00 28.69           C  
ATOM   1605  O   ARG A 216      94.881 115.909  72.378  1.00 27.37           O  
ATOM   1606  CB  ARG A 216      97.858 116.260  71.074  1.00 31.85           C  
ATOM   1607  CG  ARG A 216      98.994 115.949  70.125  1.00 36.31           C  
ATOM   1608  CD  ARG A 216      98.602 116.206  68.687  1.00 41.00           C  
ATOM   1609  NE  ARG A 216      99.625 115.700  67.776  1.00 43.89           N  
ATOM   1610  CZ  ARG A 216      99.574 115.791  66.450  1.00 44.51           C  
ATOM   1611  NH1 ARG A 216      98.542 116.381  65.850  1.00 44.72           N  
ATOM   1612  NH2 ARG A 216     100.562 115.279  65.725  1.00 44.91           N  
ATOM   1613  N   PRO A 217      96.586 115.377  73.729  1.00 28.25           N  
ATOM   1614  CA  PRO A 217      95.826 115.706  74.933  1.00 29.94           C  
ATOM   1615  C   PRO A 217      95.033 117.005  74.905  1.00 28.98           C  
ATOM   1616  O   PRO A 217      93.866 117.024  75.277  1.00 31.72           O  
ATOM   1617  CB  PRO A 217      96.896 115.704  76.013  1.00 28.59           C  
ATOM   1618  CG  PRO A 217      97.793 114.607  75.548  1.00 29.48           C  
ATOM   1619  CD  PRO A 217      97.953 114.950  74.079  1.00 29.92           C  
ATOM   1620  N   GLU A 218      95.659 118.079  74.444  1.00 30.55           N  
ATOM   1621  CA  GLU A 218      95.008 119.377  74.403  1.00 30.39           C  
ATOM   1622  C   GLU A 218      93.802 119.425  73.479  1.00 29.04           C  
ATOM   1623  O   GLU A 218      92.905 120.262  73.652  1.00 26.94           O  
ATOM   1624  CB  GLU A 218      96.014 120.445  73.975  1.00 33.19           C  
ATOM   1625  CG  GLU A 218      96.634 120.164  72.613  1.00 38.82           C  
ATOM   1626  CD  GLU A 218      97.987 119.464  72.684  1.00 41.15           C  
ATOM   1627  OE1 GLU A 218      98.139 118.484  73.457  1.00 40.81           O  
ATOM   1628  OE2 GLU A 218      98.897 119.896  71.943  1.00 42.53           O  
ATOM   1629  N   ASP A 219      93.780 118.532  72.494  1.00 26.53           N  
ATOM   1630  CA  ASP A 219      92.678 118.491  71.541  1.00 25.89           C  
ATOM   1631  C   ASP A 219      91.343 118.157  72.175  1.00 25.17           C  
ATOM   1632  O   ASP A 219      90.320 118.565  71.671  1.00 22.47           O  
ATOM   1633  CB  ASP A 219      92.968 117.486  70.422  1.00 25.97           C  
ATOM   1634  CG  ASP A 219      94.160 117.877  69.582  1.00 26.43           C  
ATOM   1635  OD1 ASP A 219      94.505 119.071  69.560  1.00 31.75           O  
ATOM   1636  OD2 ASP A 219      94.751 117.004  68.917  1.00 27.22           O  
ATOM   1637  N   LEU A 220      91.341 117.422  73.278  1.00 25.18           N  
ATOM   1638  CA  LEU A 220      90.089 117.075  73.915  1.00 26.75           C  
ATOM   1639  C   LEU A 220      89.322 118.313  74.366  1.00 25.78           C  
ATOM   1640  O   LEU A 220      88.142 118.448  74.093  1.00 25.23           O  
ATOM   1641  CB  LEU A 220      90.335 116.172  75.115  1.00 28.74           C  
ATOM   1642  CG  LEU A 220      89.087 115.483  75.670  1.00 30.11           C  
ATOM   1643  CD1 LEU A 220      88.475 114.569  74.598  1.00 30.86           C  
ATOM   1644  CD2 LEU A 220      89.477 114.669  76.897  1.00 31.70           C  
ATOM   1645  N   ALA A 221      90.003 119.219  75.066  1.00 26.98           N  
ATOM   1646  CA  ALA A 221      89.350 120.422  75.547  1.00 25.47           C  
ATOM   1647  C   ALA A 221      88.965 121.340  74.393  1.00 23.17           C  
ATOM   1648  O   ALA A 221      87.948 122.012  74.454  1.00 24.54           O  
ATOM   1649  CB  ALA A 221      90.247 121.144  76.545  1.00 26.69           C  
ATOM   1650  N   LEU A 222      89.751 121.354  73.328  1.00 22.99           N  
ATOM   1651  CA  LEU A 222      89.415 122.188  72.176  1.00 23.21           C  
ATOM   1652  C   LEU A 222      88.172 121.635  71.490  1.00 23.44           C  
ATOM   1653  O   LEU A 222      87.289 122.398  71.096  1.00 21.73           O  
ATOM   1654  CB  LEU A 222      90.576 122.240  71.179  1.00 21.46           C  
ATOM   1655  CG  LEU A 222      90.369 123.058  69.900  1.00 23.40           C  
ATOM   1656  CD1 LEU A 222      90.129 124.533  70.238  1.00 23.50           C  
ATOM   1657  CD2 LEU A 222      91.607 122.937  69.033  1.00 24.82           C  
ATOM   1658  N   ALA A 223      88.106 120.313  71.340  1.00 23.26           N  
ATOM   1659  CA  ALA A 223      86.934 119.711  70.706  1.00 23.67           C  
ATOM   1660  C   ALA A 223      85.703 120.036  71.532  1.00 24.81           C  
ATOM   1661  O   ALA A 223      84.653 120.374  70.991  1.00 24.10           O  
ATOM   1662  CB  ALA A 223      87.113 118.211  70.585  1.00 24.40           C  
ATOM   1663  N   GLU A 224      85.843 119.955  72.854  1.00 26.38           N  
ATOM   1664  CA  GLU A 224      84.741 120.264  73.759  1.00 28.56           C  
ATOM   1665  C   GLU A 224      84.290 121.717  73.575  1.00 29.09           C  
ATOM   1666  O   GLU A 224      83.097 122.016  73.611  1.00 27.80           O  
ATOM   1667  CB  GLU A 224      85.175 120.023  75.204  1.00 31.27           C  
ATOM   1668  CG  GLU A 224      84.147 120.449  76.224  1.00 35.94           C  
ATOM   1669  CD  GLU A 224      84.631 120.240  77.653  1.00 37.31           C  
ATOM   1670  OE1 GLU A 224      85.805 120.545  77.953  1.00 40.49           O  
ATOM   1671  OE2 GLU A 224      83.826 119.783  78.476  1.00 39.48           O  
ATOM   1672  N   PHE A 225      85.252 122.613  73.362  1.00 28.62           N  
ATOM   1673  CA  PHE A 225      84.958 124.030  73.151  1.00 28.43           C  
ATOM   1674  C   PHE A 225      84.169 124.205  71.850  1.00 30.27           C  
ATOM   1675  O   PHE A 225      83.152 124.900  71.808  1.00 30.72           O  
ATOM   1676  CB  PHE A 225      86.269 124.831  73.072  1.00 28.48           C  
ATOM   1677  CG  PHE A 225      86.091 126.251  72.582  1.00 27.61           C  
ATOM   1678  CD1 PHE A 225      85.593 127.241  73.426  1.00 29.35           C  
ATOM   1679  CD2 PHE A 225      86.389 126.590  71.257  1.00 28.18           C  
ATOM   1680  CE1 PHE A 225      85.391 128.533  72.960  1.00 27.69           C  
ATOM   1681  CE2 PHE A 225      86.190 127.886  70.785  1.00 28.80           C  
ATOM   1682  CZ  PHE A 225      85.688 128.859  71.636  1.00 28.60           C  
ATOM   1683  N   TYR A 226      84.629 123.575  70.774  1.00 29.43           N  
ATOM   1684  CA  TYR A 226      83.937 123.706  69.494  1.00 30.63           C  
ATOM   1685  C   TYR A 226      82.502 123.166  69.529  1.00 31.92           C  
ATOM   1686  O   TYR A 226      81.595 123.774  68.948  1.00 32.39           O  
ATOM   1687  CB  TYR A 226      84.725 123.010  68.377  1.00 28.97           C  
ATOM   1688  CG  TYR A 226      85.965 123.757  67.937  1.00 27.43           C  
ATOM   1689  CD1 TYR A 226      87.110 123.064  67.582  1.00 28.03           C  
ATOM   1690  CD2 TYR A 226      85.980 125.153  67.823  1.00 29.06           C  
ATOM   1691  CE1 TYR A 226      88.241 123.717  67.126  1.00 29.09           C  
ATOM   1692  CE2 TYR A 226      87.118 125.821  67.364  1.00 28.39           C  
ATOM   1693  CZ  TYR A 226      88.239 125.101  67.017  1.00 29.75           C  
ATOM   1694  OH  TYR A 226      89.383 125.715  66.559  1.00 31.40           O  
ATOM   1695  N   LEU A 227      82.293 122.025  70.182  1.00 33.04           N  
ATOM   1696  CA  LEU A 227      80.942 121.466  70.262  1.00 35.75           C  
ATOM   1697  C   LEU A 227      80.017 122.512  70.911  1.00 38.19           C  
ATOM   1698  O   LEU A 227      78.877 122.709  70.469  1.00 38.74           O  
ATOM   1699  CB  LEU A 227      80.955 120.152  71.060  1.00 35.12           C  
ATOM   1700  CG  LEU A 227      81.557 118.962  70.297  1.00 34.29           C  
ATOM   1701  CD1 LEU A 227      81.871 117.818  71.246  1.00 36.48           C  
ATOM   1702  CD2 LEU A 227      80.591 118.516  69.220  1.00 31.74           C  
ATOM   1703  N   THR A 228      80.538 123.196  71.932  1.00 39.57           N  
ATOM   1704  CA  THR A 228      79.814 124.251  72.651  1.00 41.10           C  
ATOM   1705  C   THR A 228      80.395 124.493  74.042  1.00 41.77           C  
ATOM   1706  O   THR A 228      81.105 123.639  74.582  1.00 43.44           O  
ATOM   1707  CB  THR A 228      78.341 123.894  72.773  1.00 42.02           C  
ATOM   1708  N   ARG A 229      80.097 125.662  74.618  1.00 42.17           N  
ATOM   1709  CA  ARG A 229      80.564 126.017  75.970  1.00 42.71           C  
ATOM   1710  C   ARG A 229      79.891 127.280  76.529  1.00 43.51           C  
ATOM   1711  O   ARG A 229      80.491 127.887  77.457  1.00 44.20           O  
ATOM   1712  CB  ARG A 229      82.088 126.234  75.987  1.00 42.17           C  
ATOM   1713  CG  ARG A 229      82.566 127.493  75.238  1.00 41.11           C  
ATOM   1714  CD  ARG A 229      83.812 128.114  75.899  1.00 40.34           C  
ATOM   1715  NE  ARG A 229      83.509 128.895  77.109  1.00 41.48           N  
ATOM   1716  CZ  ARG A 229      84.426 129.534  77.844  1.00 40.50           C  
ATOM   1717  NH1 ARG A 229      85.714 129.483  77.494  1.00 39.81           N  
ATOM   1718  NH2 ARG A 229      84.057 130.240  78.917  1.00 38.50           N  
TER    1719      ARG A 229                                                      
END
MOLECULE T0420.pdb
ATOM      1  N   MET     1      71.619 109.167  47.132  1.00 90.29           N  
ATOM      2  CA  MET     1      71.053 107.807  46.878  1.00 90.45           C  
ATOM      3  C   MET     1      71.689 106.761  47.790  1.00 88.28           C  
ATOM      4  O   MET     1      71.664 106.906  49.016  1.00 88.91           O  
ATOM      5  CB  MET     1      71.260 107.411  45.415  1.00 91.73           C  
ATOM      6  CG  MET     1      71.941 108.488  44.584  1.00 97.36           C  
ATOM      7  SD  MET     1      73.841 108.693  44.978  1.00 99.73          SE  
ATOM      8  CE  MET     1      74.536 108.305  43.197  1.00 99.73           C  
ATOM      9  N   ASN     2      72.267 105.716  47.201  1.00 85.03           N  
ATOM     10  CA  ASN     2      72.888 104.659  47.995  1.00 81.84           C  
ATOM     11  C   ASN     2      74.252 104.994  48.583  1.00 79.10           C  
ATOM     12  O   ASN     2      75.284 104.814  47.940  1.00 78.70           O  
ATOM     13  CB  ASN     2      72.987 103.382  47.174  1.00 82.29           C  
ATOM     14  CG  ASN     2      71.873 102.422  47.485  1.00 83.43           C  
ATOM     15  OD1 ASN     2      70.725 102.827  47.659  1.00 85.52           O  
ATOM     16  ND2 ASN     2      72.199 101.137  47.553  1.00 86.02           N  
ATOM     17  N   ILE     3      74.248 105.472  49.821  1.00 75.30           N  
ATOM     18  CA  ILE     3      75.487 105.816  50.485  1.00 72.19           C  
ATOM     19  C   ILE     3      75.638 105.118  51.830  1.00 69.90           C  
ATOM     20  O   ILE     3      74.729 105.111  52.659  1.00 69.85           O  
ATOM     21  CB  ILE     3      75.600 107.327  50.711  1.00 72.15           C  
ATOM     22  CG1 ILE     3      75.446 108.067  49.383  1.00 72.99           C  
ATOM     23  CG2 ILE     3      76.953 107.658  51.291  1.00 70.73           C  
ATOM     24  CD1 ILE     3      75.531 109.580  49.521  1.00 74.41           C  
ATOM     25  N   GLY     4      76.799 104.515  52.034  1.00 66.94           N  
ATOM     26  CA  GLY     4      77.060 103.854  53.291  1.00 62.89           C  
ATOM     27  C   GLY     4      78.166 104.579  54.036  1.00 59.88           C  
ATOM     28  O   GLY     4      79.154 105.010  53.446  1.00 59.44           O  
ATOM     29  N   VAL     5      77.993 104.742  55.338  1.00 57.63           N  
ATOM     30  CA  VAL     5      79.015 105.385  56.139  1.00 55.30           C  
ATOM     31  C   VAL     5      79.820 104.305  56.867  1.00 54.83           C  
ATOM     32  O   VAL     5      79.258 103.415  57.519  1.00 55.29           O  
ATOM     33  CB  VAL     5      78.407 106.331  57.182  1.00 55.28           C  
ATOM     34  CG1 VAL     5      79.501 107.107  57.868  1.00 52.77           C  
ATOM     35  CG2 VAL     5      77.436 107.269  56.520  1.00 54.18           C  
ATOM     36  N   ILE     6      81.137 104.363  56.711  1.00 52.33           N  
ATOM     37  CA  ILE     6      82.026 103.430  57.382  1.00 49.91           C  
ATOM     38  C   ILE     6      82.772 104.247  58.432  1.00 49.12           C  
ATOM     39  O   ILE     6      83.618 105.076  58.104  1.00 48.62           O  
ATOM     40  CB  ILE     6      83.073 102.802  56.424  1.00 49.52           C  
ATOM     41  CG1 ILE     6      82.382 101.948  55.361  1.00 48.68           C  
ATOM     42  CG2 ILE     6      84.049 101.945  57.211  1.00 48.22           C  
ATOM     43  CD1 ILE     6      83.341 101.418  54.286  1.00 45.37           C  
ATOM     44  N   ILE     7      82.437 104.024  59.694  1.00 48.36           N  
ATOM     45  CA  ILE     7      83.100 104.722  60.774  1.00 47.98           C  
ATOM     46  C   ILE     7      84.274 103.877  61.245  1.00 48.52           C  
ATOM     47  O   ILE     7      84.083 102.855  61.902  1.00 49.70           O  
ATOM     48  CB  ILE     7      82.152 104.964  61.956  1.00 47.36           C  
ATOM     49  CG1 ILE     7      80.950 105.785  61.483  1.00 45.91           C  
ATOM     50  CG2 ILE     7      82.897 105.675  63.069  1.00 45.97           C  
ATOM     51  CD1 ILE     7      79.957 106.127  62.563  1.00 45.22           C  
ATOM     52  N   LEU     8      85.483 104.303  60.877  1.00 49.06           N  
ATOM     53  CA  LEU     8      86.714 103.622  61.268  1.00 49.60           C  
ATOM     54  C   LEU     8      87.006 104.013  62.709  1.00 50.81           C  
ATOM     55  O   LEU     8      87.061 105.197  63.029  1.00 51.50           O  
ATOM     56  CB  LEU     8      87.873 104.067  60.382  1.00 48.30           C  
ATOM     57  CG  LEU     8      87.724 103.786  58.888  1.00 46.60           C  
ATOM     58  CD1 LEU     8      88.961 104.291  58.149  1.00 42.20           C  
ATOM     59  CD2 LEU     8      87.531 102.280  58.665  1.00 43.49           C  
ATOM     60  N   ALA     9      87.171 103.020  63.575  1.00 52.52           N  
ATOM     61  CA  ALA     9      87.443 103.268  64.982  1.00 53.82           C  
ATOM     62  C   ALA     9      88.307 102.171  65.556  1.00 55.51           C  
ATOM     63  O   ALA     9      88.312 101.961  66.758  1.00 56.08           O  
ATOM     64  CB  ALA     9      86.139 103.372  65.772  1.00 52.59           C  
ATOM     65  N   ALA    10      89.020 101.455  64.693  1.00 59.12           N  
ATOM     66  CA  ALA    10      89.924 100.405  65.149  1.00 63.15           C  
ATOM     67  C   ALA    10      91.195 101.151  65.561  1.00 66.75           C  
ATOM     68  O   ALA    10      91.294 102.364  65.350  1.00 68.61           O  
ATOM     69  CB  ALA    10      90.206  99.433  64.026  1.00 62.44           C  
ATOM     70  N   GLY    11      92.175 100.469  66.134  1.00 70.21           N  
ATOM     71  CA  GLY    11      93.361 101.205  66.554  1.00 75.15           C  
ATOM     72  C   GLY    11      94.613 101.061  65.711  1.00 78.33           C  
ATOM     73  O   GLY    11      95.722 101.227  66.230  1.00 78.74           O  
ATOM     74  N   GLU    12      94.437 100.767  64.422  1.00 81.19           N  
ATOM     75  CA  GLU    12      95.550 100.577  63.494  1.00 83.59           C  
ATOM     76  C   GLU    12      96.612 101.665  63.553  1.00 85.71           C  
ATOM     77  O   GLU    12      96.314 102.831  63.835  1.00 85.98           O  
ATOM     78  CB  GLU    12      95.034 100.456  62.063  1.00 83.44           C  
ATOM     79  CG  GLU    12      94.041 101.527  61.667  1.00 82.74           C  
ATOM     80  CD  GLU    12      92.617 101.052  61.810  1.00 83.09           C  
ATOM     81  OE1 GLU    12      92.365  99.880  61.447  1.00 79.28           O  
ATOM     82  OE2 GLU    12      91.759 101.846  62.268  1.00 83.42           O  
ATOM     83  N   GLY    13      97.853 101.269  63.266  1.00 87.93           N  
ATOM     84  CA  GLY    13      98.965 102.201  63.319  1.00 90.43           C  
ATOM     85  C   GLY    13      99.062 102.724  64.740  1.00 92.14           C  
ATOM     86  O   GLY    13      98.707 102.020  65.697  1.00 91.86           O  
ATOM     87  N   LYS    14      99.551 103.951  64.888  1.00 93.73           N  
ATOM     88  CA  LYS    14      99.652 104.561  66.210  1.00 94.77           C  
ATOM     89  C   LYS    14      98.423 105.454  66.350  1.00 95.25           C  
ATOM     90  O   LYS    14      98.420 106.428  67.102  1.00 95.26           O  
ATOM     91  CB  LYS    14     100.936 105.384  66.328  1.00 94.77           C  
ATOM     92  N   ARG    15      97.380 105.105  65.601  1.00 95.97           N  
ATOM     93  CA  ARG    15      96.131 105.855  65.620  1.00 96.80           C  
ATOM     94  C   ARG    15      95.378 105.615  66.920  1.00 97.12           C  
ATOM     95  O   ARG    15      95.823 104.844  67.772  1.00 97.51           O  
ATOM     96  CB  ARG    15      95.254 105.445  64.439  1.00 96.58           C  
ATOM     97  CG  ARG    15      95.877 105.710  63.079  1.00 96.59           C  
ATOM     98  CD  ARG    15      94.898 105.384  61.960  1.00 96.12           C  
ATOM     99  NE  ARG    15      95.475 105.569  60.630  1.00 96.03           N  
ATOM    100  CZ  ARG    15      96.458 104.827  60.126  1.00 96.46           C  
ATOM    101  NH1 ARG    15      96.984 103.835  60.838  1.00 95.19           N  
ATOM    102  NH2 ARG    15      96.918 105.081  58.907  1.00 96.89           N  
ATOM    103  N   PHE    16      94.240 106.283  67.074  1.00 97.18           N  
ATOM    104  CA  PHE    16      93.436 106.119  68.275  1.00 97.49           C  
ATOM    105  C   PHE    16      92.698 104.794  68.262  1.00 97.80           C  
ATOM    106  O   PHE    16      92.768 104.042  67.287  1.00 98.44           O  
ATOM    107  CB  PHE    16      92.419 107.249  68.401  1.00 97.55           C  
ATOM    108  CG  PHE    16      92.908 108.410  69.205  1.00 98.14           C  
ATOM    109  CD1 PHE    16      92.008 109.219  69.890  1.00 98.54           C  
ATOM    110  CD2 PHE    16      94.269 108.692  69.288  1.00 98.99           C  
ATOM    111  CE1 PHE    16      92.454 110.286  70.657  1.00 99.73           C  
ATOM    112  CE2 PHE    16      94.730 109.756  70.052  1.00 99.73           C  
ATOM    113  CZ  PHE    16      93.821 110.559  70.737  1.00 99.73           C  
ATOM    114  N   GLY    17      91.990 104.498  69.346  1.00 97.56           N  
ATOM    115  CA  GLY    17      91.244 103.256  69.372  1.00 97.36           C  
ATOM    116  C   GLY    17      90.894 102.662  70.721  1.00 97.21           C  
ATOM    117  O   GLY    17      91.776 102.255  71.471  1.00 97.85           O  
ATOM    118  N   GLY    18      89.597 102.608  71.018  1.00 96.53           N  
ATOM    119  CA  GLY    18      89.120 102.023  72.260  1.00 94.80           C  
ATOM    120  C   GLY    18      89.396 102.785  73.541  1.00 93.58           C  
ATOM    121  O   GLY    18      88.477 103.303  74.183  1.00 93.59           O  
ATOM    122  N   ASP    19      90.660 102.835  73.938  1.00 91.98           N  
ATOM    123  CA  ASP    19      91.011 103.550  75.145  1.00 90.00           C  
ATOM    124  C   ASP    19      90.709 105.034  74.941  1.00 87.78           C  
ATOM    125  O   ASP    19      89.786 105.568  75.553  1.00 87.48           O  
ATOM    126  CB  ASP    19      92.493 103.309  75.509  1.00 91.01           C  
ATOM    127  CG  ASP    19      93.463 103.733  74.409  1.00 93.15           C  
ATOM    128  OD1 ASP    19      93.323 103.266  73.259  1.00 95.19           O  
ATOM    129  OD2 ASP    19      94.384 104.528  74.701  1.00 97.76           O  
ATOM    130  N   LYS    20      91.456 105.685  74.055  1.00 85.16           N  
ATOM    131  CA  LYS    20      91.273 107.110  73.786  1.00 82.92           C  
ATOM    132  C   LYS    20      89.816 107.477  73.458  1.00 80.52           C  
ATOM    133  O   LYS    20      89.253 108.420  74.027  1.00 80.56           O  
ATOM    134  CB  LYS    20      92.180 107.539  72.627  1.00 83.51           C  
ATOM    135  CG  LYS    20      93.671 107.243  72.823  1.00 86.11           C  
ATOM    136  CD  LYS    20      94.408 108.386  73.521  1.00 91.90           C  
ATOM    137  CE  LYS    20      95.905 108.087  73.660  1.00 92.28           C  
ATOM    138  NZ  LYS    20      96.592 107.877  72.350  1.00 91.97           N  
ATOM    139  N   LEU    21      89.210 106.721  72.546  1.00 77.43           N  
ATOM    140  CA  LEU    21      87.836 106.968  72.122  1.00 74.10           C  
ATOM    141  C   LEU    21      86.754 106.807  73.200  1.00 72.82           C  
ATOM    142  O   LEU    21      85.572 107.019  72.916  1.00 71.48           O  
ATOM    143  CB  LEU    21      87.507 106.089  70.906  1.00 73.69           C  
ATOM    144  CG  LEU    21      88.288 106.394  69.618  1.00 71.25           C  
ATOM    145  CD1 LEU    21      87.938 105.370  68.578  1.00 69.24           C  
ATOM    146  CD2 LEU    21      87.972 107.783  69.103  1.00 68.55           C  
ATOM    147  N   LEU    22      87.143 106.434  74.424  1.00 71.68           N  
ATOM    148  CA  LEU    22      86.172 106.290  75.512  1.00 70.37           C  
ATOM    149  C   LEU    22      86.095 107.557  76.356  1.00 69.76           C  
ATOM    150  O   LEU    22      85.162 107.730  77.144  1.00 69.42           O  
ATOM    151  CB  LEU    22      86.491 105.095  76.416  1.00 70.07           C  
ATOM    152  CG  LEU    22      86.082 103.676  75.982  1.00 71.01           C  
ATOM    153  CD1 LEU    22      85.902 102.800  77.220  1.00 68.76           C  
ATOM    154  CD2 LEU    22      84.773 103.705  75.206  1.00 72.70           C  
ATOM    155  N   ALA    23      87.078 108.441  76.174  1.00 69.46           N  
ATOM    156  CA  ALA    23      87.127 109.724  76.884  1.00 69.28           C  
ATOM    157  C   ALA    23      85.917 110.570  76.485  1.00 69.04           C  
ATOM    158  O   ALA    23      85.341 110.375  75.412  1.00 69.60           O  
ATOM    159  CB  ALA    23      88.409 110.460  76.543  1.00 69.01           C  
ATOM    160  N   LYS    24      85.549 111.522  77.337  1.00 68.45           N  
ATOM    161  CA  LYS    24      84.383 112.367  77.086  1.00 68.28           C  
ATOM    162  C   LYS    24      84.613 113.775  76.519  1.00 68.22           C  
ATOM    163  O   LYS    24      85.726 114.280  76.472  1.00 68.12           O  
ATOM    164  CB  LYS    24      83.569 112.483  78.376  1.00 67.78           C  
ATOM    165  CG  LYS    24      83.078 111.164  78.927  1.00 68.26           C  
ATOM    166  CD  LYS    24      82.344 111.376  80.231  1.00 66.88           C  
ATOM    167  CE  LYS    24      81.781 110.086  80.774  1.00 69.00           C  
ATOM    168  NZ  LYS    24      80.964 110.366  81.975  1.00 71.95           N  
ATOM    169  N   ILE    25      83.522 114.399  76.101  1.00 68.72           N  
ATOM    170  CA  ILE    25      83.525 115.746  75.553  1.00 69.60           C  
ATOM    171  C   ILE    25      82.113 116.231  75.805  1.00 70.70           C  
ATOM    172  O   ILE    25      81.199 115.924  75.039  1.00 70.98           O  
ATOM    173  CB  ILE    25      83.791 115.732  74.042  1.00 69.72           C  
ATOM    174  CG1 ILE    25      85.257 115.399  73.782  1.00 70.89           C  
ATOM    175  CG2 ILE    25      83.412 117.056  73.429  1.00 69.11           C  
ATOM    176  CD1 ILE    25      85.582 115.164  72.325  1.00 72.99           C  
ATOM    177  N   ASP    26      81.931 116.984  76.881  1.00 71.49           N  
ATOM    178  CA  ASP    26      80.604 117.463  77.233  1.00 72.41           C  
ATOM    179  C   ASP    26      79.866 116.270  77.805  1.00 71.27           C  
ATOM    180  O   ASP    26      78.696 116.051  77.478  1.00 71.67           O  
ATOM    181  CB  ASP    26      79.825 117.975  76.006  1.00 73.68           C  
ATOM    182  CG  ASP    26      80.186 119.402  75.626  1.00 79.66           C  
ATOM    183  OD1 ASP    26      80.133 120.280  76.516  1.00 86.88           O  
ATOM    184  OD2 ASP    26      80.510 119.650  74.441  1.00 84.59           O  
ATOM    185  N   ASN    27      80.559 115.481  78.628  1.00 68.93           N  
ATOM    186  CA  ASN    27      79.942 114.315  79.268  1.00 66.22           C  
ATOM    187  C   ASN    27      79.658 113.120  78.385  1.00 64.66           C  
ATOM    188  O   ASN    27      79.094 112.128  78.859  1.00 65.21           O  
ATOM    189  CB  ASN    27      78.612 114.688  79.922  1.00 65.54           C  
ATOM    190  CG  ASN    27      78.784 115.403  81.225  1.00 64.50           C  
ATOM    191  OD1 ASN    27      79.884 115.485  81.765  1.00 64.45           O  
ATOM    192  ND2 ASN    27      77.683 115.917  81.756  1.00 64.06           N  
ATOM    193  N   THR    28      80.000 113.196  77.108  1.00 62.05           N  
ATOM    194  CA  THR    28      79.717 112.060  76.257  1.00 59.69           C  
ATOM    195  C   THR    28      80.960 111.528  75.569  1.00 58.20           C  
ATOM    196  O   THR    28      81.777 112.288  75.050  1.00 57.50           O  
ATOM    197  CB  THR    28      78.640 112.384  75.191  1.00 59.45           C  
ATOM    198  OG1 THR    28      79.251 112.466  73.900  1.00 59.73           O  
ATOM    199  CG2 THR    28      77.942 113.690  75.508  1.00 57.57           C  
ATOM    200  N   PRO    29      81.119 110.198  75.579  1.00 56.76           N  
ATOM    201  CA  PRO    29      82.239 109.478  74.972  1.00 56.34           C  
ATOM    202  C   PRO    29      82.454 109.932  73.529  1.00 55.95           C  
ATOM    203  O   PRO    29      81.504 110.038  72.765  1.00 56.53           O  
ATOM    204  CB  PRO    29      81.788 108.027  75.065  1.00 56.52           C  
ATOM    205  CG  PRO    29      80.997 108.025  76.333  1.00 56.54           C  
ATOM    206  CD  PRO    29      80.176 109.262  76.213  1.00 55.49           C  
ATOM    207  N   ILE    30      83.700 110.192  73.157  1.00 55.38           N  
ATOM    208  CA  ILE    30      84.000 110.645  71.811  1.00 55.43           C  
ATOM    209  C   ILE    30      83.353 109.800  70.720  1.00 55.32           C  
ATOM    210  O   ILE    30      82.564 110.328  69.926  1.00 56.08           O  
ATOM    211  CB  ILE    30      85.522 110.709  71.577  1.00 55.57           C  
ATOM    212  CG1 ILE    30      86.136 111.685  72.580  1.00 58.50           C  
ATOM    213  CG2 ILE    30      85.833 111.166  70.152  1.00 55.90           C  
ATOM    214  CD1 ILE    30      87.631 111.558  72.699  1.00 61.89           C  
ATOM    215  N   ILE    31      83.672 108.504  70.676  1.00 54.45           N  
ATOM    216  CA  ILE    31      83.118 107.613  69.647  1.00 53.69           C  
ATOM    217  C   ILE    31      81.614 107.793  69.494  1.00 54.48           C  
ATOM    218  O   ILE    31      81.101 107.817  68.377  1.00 53.94           O  
ATOM    219  CB  ILE    31      83.430 106.091  69.930  1.00 53.14           C  
ATOM    220  CG1 ILE    31      82.977 105.234  68.744  1.00 52.34           C  
ATOM    221  CG2 ILE    31      82.709 105.612  71.178  1.00 49.66           C  
ATOM    222  CD1 ILE    31      83.529 105.698  67.414  1.00 48.24           C  
ATOM    223  N   MET    32      80.915 107.933  70.614  1.00 55.33           N  
ATOM    224  CA  MET    32      79.468 108.124  70.580  1.00 57.31           C  
ATOM    225  C   MET    32      79.075 109.453  69.925  1.00 57.61           C  
ATOM    226  O   MET    32      78.130 109.518  69.147  1.00 58.36           O  
ATOM    227  CB  MET    32      78.889 108.041  71.994  1.00 57.46           C  
ATOM    228  CG  MET    32      78.996 106.661  72.614  1.00 62.54           C  
ATOM    229  SD  MET    32      78.000 106.473  74.269  1.00 78.05          SE  
ATOM    230  CE  MET    32      76.220 106.221  73.530  1.00 73.81           C  
ATOM    231  N   ARG    33      79.804 110.515  70.236  1.00 57.73           N  
ATOM    232  CA  ARG    33      79.511 111.806  69.650  1.00 57.85           C  
ATOM    233  C   ARG    33      79.694 111.710  68.131  1.00 56.91           C  
ATOM    234  O   ARG    33      78.834 112.133  67.368  1.00 56.97           O  
ATOM    235  CB  ARG    33      80.455 112.857  70.228  1.00 58.89           C  
ATOM    236  CG  ARG    33      80.107 114.287  69.860  1.00 64.39           C  
ATOM    237  CD  ARG    33      81.310 115.202  70.074  1.00 73.49           C  
ATOM    238  NE  ARG    33      80.955 116.619  70.038  1.00 79.65           N  
ATOM    239  CZ  ARG    33      80.209 117.224  70.960  1.00 84.29           C  
ATOM    240  NH1 ARG    33      79.728 116.544  72.002  1.00 85.07           N  
ATOM    241  NH2 ARG    33      79.953 118.518  70.841  1.00 85.09           N  
ATOM    242  N   THR    34      80.818 111.141  67.710  1.00 55.65           N  
ATOM    243  CA  THR    34      81.154 110.977  66.299  1.00 55.20           C  
ATOM    244  C   THR    34      80.093 110.227  65.496  1.00 56.00           C  
ATOM    245  O   THR    34      79.744 110.616  64.383  1.00 57.09           O  
ATOM    246  CB  THR    34      82.487 110.233  66.153  1.00 54.71           C  
ATOM    247  OG1 THR    34      83.528 111.010  66.753  1.00 56.07           O  
ATOM    248  CG2 THR    34      82.817 109.991  64.698  1.00 53.23           C  
ATOM    249  N   ILE    35      79.595 109.135  66.050  1.00 55.81           N  
ATOM    250  CA  ILE    35      78.573 108.350  65.382  1.00 55.24           C  
ATOM    251  C   ILE    35      77.285 109.182  65.289  1.00 56.74           C  
ATOM    252  O   ILE    35      76.516 109.062  64.335  1.00 56.77           O  
ATOM    253  CB  ILE    35      78.314 107.055  66.181  1.00 54.53           C  
ATOM    254  CG1 ILE    35      79.523 106.122  66.057  1.00 52.33           C  
ATOM    255  CG2 ILE    35      77.025 106.392  65.721  1.00 54.33           C  
ATOM    256  CD1 ILE    35      79.511 104.992  67.061  1.00 52.36           C  
ATOM    257  N   ARG    36      77.063 110.034  66.285  1.00 58.78           N  
ATOM    258  CA  ARG    36      75.872 110.873  66.330  1.00 60.98           C  
ATOM    259  C   ARG    36      75.736 111.810  65.126  1.00 60.67           C  
ATOM    260  O   ARG    36      74.623 112.054  64.639  1.00 60.67           O  
ATOM    261  CB  ARG    36      75.856 111.709  67.617  1.00 62.08           C  
ATOM    262  CG  ARG    36      74.700 112.698  67.669  1.00 70.34           C  
ATOM    263  CD  ARG    36      74.838 113.806  68.723  1.00 81.85           C  
ATOM    264  NE  ARG    36      73.929 114.914  68.396  1.00 91.09           N  
ATOM    265  CZ  ARG    36      73.705 115.989  69.155  1.00 95.58           C  
ATOM    266  NH1 ARG    36      74.321 116.134  70.323  1.00 98.47           N  
ATOM    267  NH2 ARG    36      72.864 116.934  68.737  1.00 96.39           N  
ATOM    268  N   ILE    37      76.852 112.330  64.630  1.00 60.37           N  
ATOM    269  CA  ILE    37      76.760 113.262  63.520  1.00 60.38           C  
ATOM    270  C   ILE    37      76.210 112.662  62.239  1.00 59.58           C  
ATOM    271  O   ILE    37      75.575 113.366  61.461  1.00 60.82           O  
ATOM    272  CB  ILE    37      78.127 113.955  63.185  1.00 60.43           C  
ATOM    273  CG1 ILE    37      78.674 113.407  61.868  1.00 62.85           C  
ATOM    274  CG2 ILE    37      79.129 113.773  64.316  1.00 59.72           C  
ATOM    275  CD1 ILE    37      79.796 114.225  61.284  1.00 67.67           C  
ATOM    276  N   TYR    38      76.439 111.376  62.009  1.00 58.46           N  
ATOM    277  CA  TYR    38      75.958 110.767  60.772  1.00 58.42           C  
ATOM    278  C   TYR    38      74.512 110.287  60.843  1.00 59.45           C  
ATOM    279  O   TYR    38      74.027 109.572  59.957  1.00 59.42           O  
ATOM    280  CB  TYR    38      76.898 109.643  60.352  1.00 57.53           C  
ATOM    281  CG  TYR    38      78.318 110.140  60.220  1.00 57.36           C  
ATOM    282  CD1 TYR    38      79.162 110.183  61.328  1.00 55.51           C  
ATOM    283  CD2 TYR    38      78.800 110.631  59.012  1.00 55.63           C  
ATOM    284  CE1 TYR    38      80.441 110.698  61.244  1.00 49.86           C  
ATOM    285  CE2 TYR    38      80.086 111.152  58.916  1.00 54.10           C  
ATOM    286  CZ  TYR    38      80.901 111.178  60.041  1.00 51.45           C  
ATOM    287  OH  TYR    38      82.186 111.662  59.964  1.00 47.93           O  
ATOM    288  N   GLY    39      73.835 110.720  61.907  1.00 60.10           N  
ATOM    289  CA  GLY    39      72.436 110.407  62.143  1.00 60.00           C  
ATOM    290  C   GLY    39      71.855 109.148  61.549  1.00 60.55           C  
ATOM    291  O   GLY    39      72.378 108.058  61.752  1.00 61.52           O  
ATOM    292  N   ASP    40      70.771 109.296  60.796  1.00 60.94           N  
ATOM    293  CA  ASP    40      70.101 108.136  60.216  1.00 61.01           C  
ATOM    294  C   ASP    40      70.751 107.499  58.989  1.00 60.50           C  
ATOM    295  O   ASP    40      70.166 106.593  58.398  1.00 61.61           O  
ATOM    296  CB  ASP    40      68.633 108.467  59.925  1.00 61.37           C  
ATOM    297  N   LEU    41      71.943 107.952  58.601  1.00 59.40           N  
ATOM    298  CA  LEU    41      72.634 107.336  57.466  1.00 58.41           C  
ATOM    299  C   LEU    41      73.003 105.901  57.874  1.00 58.10           C  
ATOM    300  O   LEU    41      73.050 105.601  59.061  1.00 58.57           O  
ATOM    301  CB  LEU    41      73.916 108.105  57.132  1.00 57.99           C  
ATOM    302  CG  LEU    41      73.826 109.512  56.542  1.00 57.23           C  
ATOM    303  CD1 LEU    41      75.230 110.107  56.371  1.00 57.65           C  
ATOM    304  CD2 LEU    41      73.115 109.447  55.218  1.00 57.35           C  
ATOM    305  N   GLU    42      73.254 105.021  56.905  1.00 57.72           N  
ATOM    306  CA  GLU    42      73.638 103.638  57.205  1.00 58.18           C  
ATOM    307  C   GLU    42      75.083 103.558  57.672  1.00 57.58           C  
ATOM    308  O   GLU    42      76.007 103.563  56.865  1.00 58.58           O  
ATOM    309  CB  GLU    42      73.507 102.748  55.983  1.00 58.83           C  
ATOM    310  CG  GLU    42      72.111 102.537  55.499  1.00 63.58           C  
ATOM    311  CD  GLU    42      72.067 101.539  54.355  1.00 70.64           C  
ATOM    312  OE1 GLU    42      72.384 100.347  54.605  1.00 73.15           O  
ATOM    313  OE2 GLU    42      71.728 101.953  53.216  1.00 70.47           O  
ATOM    314  N   LYS    43      75.268 103.444  58.978  1.00 56.57           N  
ATOM    315  CA  LYS    43      76.589 103.388  59.574  1.00 54.94           C  
ATOM    316  C   LYS    43      77.058 101.962  59.729  1.00 53.93           C  
ATOM    317  O   LYS    43      76.296 101.025  59.586  1.00 54.99           O  
ATOM    318  CB  LYS    43      76.539 104.053  60.944  1.00 54.21           C  
ATOM    319  CG  LYS    43      76.089 105.493  60.873  1.00 56.44           C  
ATOM    320  CD  LYS    43      75.508 105.986  62.175  1.00 57.68           C  
ATOM    321  CE  LYS    43      74.133 105.422  62.382  1.00 62.41           C  
ATOM    322  NZ  LYS    43      73.639 105.759  63.752  1.00 70.06           N  
ATOM    323  N   ILE    44      78.336 101.815  60.023  1.00 53.03           N  
ATOM    324  CA  ILE    44      78.956 100.522  60.253  1.00 51.66           C  
ATOM    325  C   ILE    44      80.189 100.978  61.016  1.00 50.86           C  
ATOM    326  O   ILE    44      80.899 101.871  60.552  1.00 50.25           O  
ATOM    327  CB  ILE    44      79.325  99.798  58.892  1.00 51.74           C  
ATOM    328  CG1 ILE    44      78.773  98.381  58.892  1.00 53.42           C  
ATOM    329  CG2 ILE    44      80.828  99.652  58.706  1.00 51.40           C  
ATOM    330  CD1 ILE    44      77.286  98.305  59.143  1.00 58.76           C  
ATOM    331  N   ILE    45      80.414 100.441  62.209  1.00 49.37           N  
ATOM    332  CA  ILE    45      81.605 100.835  62.958  1.00 48.60           C  
ATOM    333  C   ILE    45      82.599  99.678  62.948  1.00 47.89           C  
ATOM    334  O   ILE    45      82.250  98.549  63.296  1.00 47.54           O  
ATOM    335  CB  ILE    45      81.288 101.224  64.429  1.00 48.70           C  
ATOM    336  CG1 ILE    45      80.526 102.551  64.500  1.00 51.62           C  
ATOM    337  CG2 ILE    45      82.577 101.466  65.175  1.00 48.08           C  
ATOM    338  CD1 ILE    45      79.121 102.524  64.017  1.00 50.63           C  
ATOM    339  N   ILE    46      83.832  99.957  62.530  1.00 47.84           N  
ATOM    340  CA  ILE    46      84.878  98.932  62.471  1.00 48.03           C  
ATOM    341  C   ILE    46      85.761  99.062  63.707  1.00 49.81           C  
ATOM    342  O   ILE    46      86.479 100.044  63.874  1.00 49.96           O  
ATOM    343  CB  ILE    46      85.750  99.079  61.206  1.00 47.88           C  
ATOM    344  CG1 ILE    46      84.863  99.339  59.981  1.00 46.63           C  
ATOM    345  CG2 ILE    46      86.567  97.822  61.007  1.00 45.07           C  
ATOM    346  CD1 ILE    46      83.919  98.205  59.659  1.00 46.69           C  
ATOM    347  N   VAL    47      85.713  98.050  64.563  1.00 51.65           N  
ATOM    348  CA  VAL    47      86.454  98.057  65.801  1.00 52.13           C  
ATOM    349  C   VAL    47      87.558  97.039  65.857  1.00 52.86           C  
ATOM    350  O   VAL    47      87.385  95.892  65.465  1.00 53.50           O  
ATOM    351  CB  VAL    47      85.489  97.786  66.997  1.00 52.29           C  
ATOM    352  CG1 VAL    47      86.271  97.710  68.308  1.00 58.76           C  
ATOM    353  CG2 VAL    47      84.434  98.880  67.086  1.00 49.63           C  
ATOM    354  N   GLY    48      88.700  97.489  66.340  1.00 53.86           N  
ATOM    355  CA  GLY    48      89.803  96.591  66.529  1.00 56.32           C  
ATOM    356  C   GLY    48      90.462  96.636  67.900  1.00 58.56           C  
ATOM    357  O   GLY    48      90.053  95.931  68.838  1.00 58.36           O  
ATOM    358  N   LYS    49      91.398  97.574  68.039  1.00 60.27           N  
ATOM    359  CA  LYS    49      92.245  97.618  69.209  1.00 61.92           C  
ATOM    360  C   LYS    49      91.645  97.359  70.559  1.00 62.63           C  
ATOM    361  O   LYS    49      92.151  96.541  71.335  1.00 63.40           O  
ATOM    362  CB  LYS    49      93.101  98.892  69.217  1.00 62.68           C  
ATOM    363  CG  LYS    49      94.220  98.881  70.262  1.00 65.72           C  
ATOM    364  CD  LYS    49      95.293  99.902  69.929  1.00 71.92           C  
ATOM    365  CE  LYS    49      96.442  99.825  70.923  1.00 74.57           C  
ATOM    366  NZ  LYS    49      97.419 100.945  70.723  1.00 77.45           N  
ATOM    367  N   TYR    50      90.541  98.024  70.825  1.00 61.98           N  
ATOM    368  CA  TYR    50      89.878  97.870  72.096  1.00 62.40           C  
ATOM    369  C   TYR    50      88.384  97.537  72.004  1.00 61.32           C  
ATOM    370  O   TYR    50      87.543  98.201  72.619  1.00 60.53           O  
ATOM    371  CB  TYR    50      90.093  99.142  72.913  1.00 64.35           C  
ATOM    372  CG  TYR    50      91.467  99.231  73.557  1.00 69.92           C  
ATOM    373  CD1 TYR    50      91.851  98.321  74.548  1.00 75.20           C  
ATOM    374  CD2 TYR    50      92.380 100.226  73.191  1.00 71.41           C  
ATOM    375  CE1 TYR    50      93.106  98.398  75.162  1.00 76.64           C  
ATOM    376  CE2 TYR    50      93.639 100.315  73.798  1.00 73.94           C  
ATOM    377  CZ  TYR    50      93.993  99.399  74.787  1.00 76.90           C  
ATOM    378  OH  TYR    50      95.211  99.503  75.430  1.00 78.80           O  
ATOM    379  N   VAL    51      88.073  96.495  71.237  1.00 59.63           N  
ATOM    380  CA  VAL    51      86.707  96.020  71.054  1.00 57.84           C  
ATOM    381  C   VAL    51      85.939  95.973  72.370  1.00 58.37           C  
ATOM    382  O   VAL    51      84.792  96.426  72.461  1.00 58.73           O  
ATOM    383  CB  VAL    51      86.667  94.573  70.482  1.00 58.21           C  
ATOM    384  CG1 VAL    51      85.824  94.537  69.223  1.00 57.69           C  
ATOM    385  CG2 VAL    51      88.069  94.054  70.218  1.00 57.30           C  
ATOM    386  N   ASN    52      86.588  95.412  73.385  1.00 58.63           N  
ATOM    387  CA  ASN    52      86.002  95.231  74.703  1.00 59.29           C  
ATOM    388  C   ASN    52      85.566  96.513  75.391  1.00 59.39           C  
ATOM    389  O   ASN    52      84.513  96.545  76.008  1.00 59.70           O  
ATOM    390  CB  ASN    52      86.986  94.443  75.559  1.00 60.17           C  
ATOM    391  CG  ASN    52      87.796  93.442  74.727  1.00 64.37           C  
ATOM    392  OD1 ASN    52      88.879  93.772  74.214  1.00 67.78           O  
ATOM    393  ND2 ASN    52      87.259  92.223  74.562  1.00 65.23           N  
ATOM    394  N   GLU    53      86.366  97.567  75.292  1.00 60.29           N  
ATOM    395  CA  GLU    53      86.020  98.851  75.889  1.00 60.62           C  
ATOM    396  C   GLU    53      84.865  99.468  75.113  1.00 60.18           C  
ATOM    397  O   GLU    53      83.879  99.925  75.678  1.00 60.82           O  
ATOM    398  CB  GLU    53      87.187  99.834  75.787  1.00 61.28           C  
ATOM    399  CG  GLU    53      88.107  99.932  76.968  1.00 65.75           C  
ATOM    400  CD  GLU    53      89.111  98.815  77.002  1.00 74.97           C  
ATOM    401  OE1 GLU    53      90.250  99.080  77.464  1.00 79.21           O  
ATOM    402  OE2 GLU    53      88.760  97.683  76.579  1.00 76.94           O  
ATOM    403  N   MET    54      85.035  99.481  73.800  1.00 59.89           N  
ATOM    404  CA  MET    54      84.103 100.063  72.844  1.00 60.56           C  
ATOM    405  C   MET    54      82.660  99.563  72.773  1.00 58.62           C  
ATOM    406  O   MET    54      81.708 100.349  72.841  1.00 58.00           O  
ATOM    407  CB  MET    54      84.697  99.924  71.449  1.00 62.14           C  
ATOM    408  CG  MET    54      86.053 100.549  71.282  1.00 69.52           C  
ATOM    409  SD  MET    54      85.886 102.012  70.073  1.00 90.15          SE  
ATOM    410  CE  MET    54      85.198 103.287  71.348  1.00 84.00           C  
ATOM    411  N   LEU    55      82.502  98.256  72.622  1.00 55.88           N  
ATOM    412  CA  LEU    55      81.184  97.676  72.459  1.00 54.39           C  
ATOM    413  C   LEU    55      80.040  98.066  73.373  1.00 53.04           C  
ATOM    414  O   LEU    55      78.959  98.398  72.897  1.00 53.20           O  
ATOM    415  CB  LEU    55      81.306  96.155  72.391  1.00 54.90           C  
ATOM    416  CG  LEU    55      81.307  95.787  70.903  1.00 56.33           C  
ATOM    417  CD1 LEU    55      82.157  94.570  70.662  1.00 61.30           C  
ATOM    418  CD2 LEU    55      79.872  95.590  70.432  1.00 52.82           C  
ATOM    419  N   PRO    56      80.249  98.046  74.694  1.00 51.29           N  
ATOM    420  CA  PRO    56      79.124  98.414  75.552  1.00 49.78           C  
ATOM    421  C   PRO    56      78.523  99.780  75.249  1.00 49.42           C  
ATOM    422  O   PRO    56      77.448 100.106  75.750  1.00 48.99           O  
ATOM    423  CB  PRO    56      79.719  98.312  76.948  1.00 49.07           C  
ATOM    424  CG  PRO    56      80.722  97.225  76.789  1.00 49.39           C  
ATOM    425  CD  PRO    56      81.395  97.595  75.498  1.00 49.72           C  
ATOM    426  N   LEU    57      79.216 100.574  74.436  1.00 49.11           N  
ATOM    427  CA  LEU    57      78.729 101.905  74.052  1.00 50.18           C  
ATOM    428  C   LEU    57      78.107 101.899  72.662  1.00 50.24           C  
ATOM    429  O   LEU    57      77.524 102.890  72.243  1.00 51.13           O  
ATOM    430  CB  LEU    57      79.862 102.932  74.024  1.00 50.39           C  
ATOM    431  CG  LEU    57      80.628 103.337  75.273  1.00 52.72           C  
ATOM    432  CD1 LEU    57      81.414 102.155  75.842  1.00 56.04           C  
ATOM    433  CD2 LEU    57      81.565 104.462  74.883  1.00 54.20           C  
ATOM    434  N   LEU    58      78.256 100.789  71.948  1.00 49.46           N  
ATOM    435  CA  LEU    58      77.741 100.660  70.593  1.00 48.48           C  
ATOM    436  C   LEU    58      76.717  99.532  70.493  1.00 49.44           C  
ATOM    437  O   LEU    58      76.510  98.994  69.411  1.00 50.42           O  
ATOM    438  CB  LEU    58      78.896 100.345  69.647  1.00 47.40           C  
ATOM    439  CG  LEU    58      80.166 101.180  69.771  1.00 44.88           C  
ATOM    440  CD1 LEU    58      81.278 100.576  68.929  1.00 42.95           C  
ATOM    441  CD2 LEU    58      79.876 102.572  69.324  1.00 44.85           C  
ATOM    442  N   MET    59      76.078  99.174  71.605  1.00 49.35           N  
ATOM    443  CA  MET    59      75.125  98.067  71.600  1.00 49.73           C  
ATOM    444  C   MET    59      73.985  98.168  70.591  1.00 49.30           C  
ATOM    445  O   MET    59      73.364  97.162  70.244  1.00 49.30           O  
ATOM    446  CB  MET    59      74.559  97.842  73.010  1.00 50.89           C  
ATOM    447  CG  MET    59      75.565  97.287  74.017  1.00 54.13           C  
ATOM    448  SD  MET    59      76.588  95.782  73.324  1.00 70.34          SE  
ATOM    449  CE  MET    59      75.361  94.347  73.753  1.00 58.89           C  
ATOM    450  N   ASP    60      73.708  99.374  70.110  1.00 47.86           N  
ATOM    451  CA  ASP    60      72.653  99.565  69.124  1.00 46.66           C  
ATOM    452  C   ASP    60      73.221  99.860  67.735  1.00 46.22           C  
ATOM    453  O   ASP    60      72.538 100.445  66.911  1.00 47.02           O  
ATOM    454  CB  ASP    60      71.777 100.727  69.535  1.00 46.17           C  
ATOM    455  CG  ASP    60      72.544 102.034  69.589  1.00 48.07           C  
ATOM    456  OD1 ASP    60      73.801 102.003  69.559  1.00 53.28           O  
ATOM    457  OD2 ASP    60      71.888 103.091  69.676  1.00 47.99           O  
ATOM    458  N   GLN    61      74.463  99.468  67.479  1.00 45.11           N  
ATOM    459  CA  GLN    61      75.091  99.721  66.192  1.00 45.51           C  
ATOM    460  C   GLN    61      75.570  98.418  65.558  1.00 45.51           C  
ATOM    461  O   GLN    61      75.632  97.396  66.234  1.00 47.80           O  
ATOM    462  CB  GLN    61      76.304 100.641  66.367  1.00 44.61           C  
ATOM    463  CG  GLN    61      76.029 101.970  67.031  1.00 47.76           C  
ATOM    464  CD  GLN    61      75.216 102.919  66.169  1.00 49.19           C  
ATOM    465  OE1 GLN    61      75.521 103.116  65.002  1.00 50.52           O  
ATOM    466  NE2 GLN    61      74.185 103.520  66.749  1.00 52.55           N  
ATOM    467  N   ILE    62      75.892  98.445  64.267  1.00 43.40           N  
ATOM    468  CA  ILE    62      76.422  97.260  63.623  1.00 42.80           C  
ATOM    469  C   ILE    62      77.933  97.417  63.754  1.00 43.20           C  
ATOM    470  O   ILE    62      78.536  98.329  63.179  1.00 43.46           O  
ATOM    471  CB  ILE    62      76.065  97.163  62.119  1.00 43.54           C  
ATOM    472  CG1 ILE    62      74.578  96.871  61.943  1.00 44.93           C  
ATOM    473  CG2 ILE    62      76.870  96.046  61.466  1.00 40.91           C  
ATOM    474  CD1 ILE    62      74.146  96.881  60.518  1.00 44.82           C  
ATOM    475  N   VAL    63      78.547  96.526  64.519  1.00 43.82           N  
ATOM    476  CA  VAL    63      79.975  96.594  64.738  1.00 42.60           C  
ATOM    477  C   VAL    63      80.726  95.410  64.165  1.00 43.60           C  
ATOM    478  O   VAL    63      80.362  94.255  64.412  1.00 44.70           O  
ATOM    479  CB  VAL    63      80.264  96.654  66.221  1.00 42.01           C  
ATOM    480  CG1 VAL    63      81.728  96.879  66.438  1.00 41.44           C  
ATOM    481  CG2 VAL    63      79.437  97.758  66.849  1.00 40.36           C  
ATOM    482  N   ILE    64      81.760  95.691  63.380  1.00 43.38           N  
ATOM    483  CA  ILE    64      82.579  94.618  62.834  1.00 43.76           C  
ATOM    484  C   ILE    64      83.935  94.756  63.513  1.00 43.62           C  
ATOM    485  O   ILE    64      84.577  95.801  63.455  1.00 43.62           O  
ATOM    486  CB  ILE    64      82.821  94.702  61.278  1.00 44.89           C  
ATOM    487  CG1 ILE    64      81.509  94.822  60.510  1.00 45.55           C  
ATOM    488  CG2 ILE    64      83.526  93.442  60.799  1.00 41.36           C  
ATOM    489  CD1 ILE    64      81.032  96.228  60.377  1.00 50.68           C  
ATOM    490  N   TYR    65      84.349  93.690  64.171  1.00 43.63           N  
ATOM    491  CA  TYR    65      85.625  93.649  64.829  1.00 43.37           C  
ATOM    492  C   TYR    65      86.648  93.145  63.818  1.00 44.75           C  
ATOM    493  O   TYR    65      86.500  92.057  63.249  1.00 43.95           O  
ATOM    494  CB  TYR    65      85.565  92.702  66.019  1.00 43.55           C  
ATOM    495  CG  TYR    65      86.918  92.251  66.487  1.00 41.43           C  
ATOM    496  CD1 TYR    65      87.852  93.164  66.972  1.00 38.27           C  
ATOM    497  CD2 TYR    65      87.280  90.912  66.418  1.00 41.59           C  
ATOM    498  CE1 TYR    65      89.120  92.749  67.377  1.00 40.70           C  
ATOM    499  CE2 TYR    65      88.550  90.489  66.822  1.00 45.09           C  
ATOM    500  CZ  TYR    65      89.460  91.409  67.299  1.00 42.17           C  
ATOM    501  OH  TYR    65      90.693  90.979  67.699  1.00 40.96           O  
ATOM    502  N   ASN    66      87.685  93.944  63.593  1.00 46.17           N  
ATOM    503  CA  ASN    66      88.737  93.574  62.660  1.00 47.65           C  
ATOM    504  C   ASN    66      89.911  92.902  63.383  1.00 49.38           C  
ATOM    505  O   ASN    66      90.732  93.568  63.999  1.00 50.31           O  
ATOM    506  CB  ASN    66      89.215  94.819  61.946  1.00 47.78           C  
ATOM    507  CG  ASN    66      90.256  94.527  60.923  1.00 47.90           C  
ATOM    508  OD1 ASN    66      90.794  95.442  60.318  1.00 49.13           O  
ATOM    509  ND2 ASN    66      90.552  93.247  60.710  1.00 45.03           N  
ATOM    510  N   PRO    67      90.018  91.566  63.301  1.00 50.88           N  
ATOM    511  CA  PRO    67      91.125  90.896  63.985  1.00 51.48           C  
ATOM    512  C   PRO    67      92.476  91.236  63.350  1.00 51.83           C  
ATOM    513  O   PRO    67      93.525  90.865  63.872  1.00 52.03           O  
ATOM    514  CB  PRO    67      90.772  89.428  63.819  1.00 50.88           C  
ATOM    515  CG  PRO    67      90.292  89.417  62.428  1.00 50.27           C  
ATOM    516  CD  PRO    67      89.335  90.615  62.409  1.00 51.26           C  
ATOM    517  N   PHE    68      92.447  91.941  62.226  1.00 51.67           N  
ATOM    518  CA  PHE    68      93.677  92.303  61.527  1.00 51.96           C  
ATOM    519  C   PHE    68      94.032  93.784  61.633  1.00 51.17           C  
ATOM    520  O   PHE    68      94.899  94.260  60.898  1.00 50.54           O  
ATOM    521  CB  PHE    68      93.555  91.945  60.047  1.00 52.16           C  
ATOM    522  CG  PHE    68      93.289  90.497  59.797  1.00 55.38           C  
ATOM    523  CD1 PHE    68      94.332  89.575  59.785  1.00 56.42           C  
ATOM    524  CD2 PHE    68      91.985  90.042  59.594  1.00 58.52           C  
ATOM    525  CE1 PHE    68      94.080  88.223  59.572  1.00 55.86           C  
ATOM    526  CE2 PHE    68      91.724  88.689  59.382  1.00 57.31           C  
ATOM    527  CZ  PHE    68      92.775  87.781  59.372  1.00 57.16           C  
ATOM    528  N   TRP    69      93.372  94.503  62.542  1.00 50.63           N  
ATOM    529  CA  TRP    69      93.603  95.940  62.694  1.00 50.90           C  
ATOM    530  C   TRP    69      95.071  96.320  62.846  1.00 51.38           C  
ATOM    531  O   TRP    69      95.521  97.326  62.316  1.00 50.73           O  
ATOM    532  CB  TRP    69      92.818  96.480  63.889  1.00 49.66           C  
ATOM    533  CG  TRP    69      93.264  95.906  65.183  1.00 49.78           C  
ATOM    534  CD1 TRP    69      92.800  94.774  65.775  1.00 47.87           C  
ATOM    535  CD2 TRP    69      94.302  96.408  66.032  1.00 49.42           C  
ATOM    536  NE1 TRP    69      93.478  94.536  66.941  1.00 49.11           N  
ATOM    537  CE2 TRP    69      94.411  95.524  67.126  1.00 49.69           C  
ATOM    538  CE3 TRP    69      95.154  97.522  65.977  1.00 49.81           C  
ATOM    539  CZ2 TRP    69      95.340  95.710  68.161  1.00 49.98           C  
ATOM    540  CZ3 TRP    69      96.077  97.709  67.006  1.00 48.86           C  
ATOM    541  CH2 TRP    69      96.160  96.806  68.082  1.00 50.99           C  
ATOM    542  N   ASN    70      95.801  95.490  63.574  1.00 52.70           N  
ATOM    543  CA  ASN    70      97.215  95.690  63.847  1.00 54.65           C  
ATOM    544  C   ASN    70      98.005  95.820  62.549  1.00 53.81           C  
ATOM    545  O   ASN    70      99.035  96.490  62.490  1.00 53.07           O  
ATOM    546  CB  ASN    70      97.723  94.499  64.672  1.00 56.29           C  
ATOM    547  CG  ASN    70      99.025  94.795  65.410  1.00 62.67           C  
ATOM    548  OD1 ASN    70      99.292  95.939  65.809  1.00 69.67           O  
ATOM    549  ND2 ASN    70      99.833  93.754  65.620  1.00 69.79           N  
ATOM    550  N   GLU    71      97.494  95.180  61.509  1.00 53.46           N  
ATOM    551  CA  GLU    71      98.120  95.181  60.202  1.00 53.66           C  
ATOM    552  C   GLU    71      98.038  96.539  59.483  1.00 53.22           C  
ATOM    553  O   GLU    71      98.893  96.854  58.649  1.00 53.15           O  
ATOM    554  CB  GLU    71      97.480  94.092  59.347  1.00 53.92           C  
ATOM    555  CG  GLU    71      98.156  93.870  58.026  1.00 58.69           C  
ATOM    556  CD  GLU    71      97.542  92.719  57.273  1.00 65.74           C  
ATOM    557  OE1 GLU    71      97.404  91.637  57.887  1.00 67.82           O  
ATOM    558  OE2 GLU    71      97.205  92.893  56.079  1.00 68.24           O  
ATOM    559  N   GLY    72      97.022  97.341  59.793  1.00 51.92           N  
ATOM    560  CA  GLY    72      96.920  98.636  59.147  1.00 50.61           C  
ATOM    561  C   GLY    72      95.502  99.049  58.821  1.00 49.73           C  
ATOM    562  O   GLY    72      94.600  98.212  58.787  1.00 50.44           O  
ATOM    563  N   ILE    73      95.305 100.336  58.544  1.00 47.95           N  
ATOM    564  CA  ILE    73      93.970 100.851  58.265  1.00 46.95           C  
ATOM    565  C   ILE    73      93.289 100.350  56.984  1.00 48.19           C  
ATOM    566  O   ILE    73      92.067 100.307  56.913  1.00 48.72           O  
ATOM    567  CB  ILE    73      93.965 102.408  58.279  1.00 45.94           C  
ATOM    568  CG1 ILE    73      92.529 102.910  58.439  1.00 44.83           C  
ATOM    569  CG2 ILE    73      94.575 102.956  57.005  1.00 43.64           C  
ATOM    570  CD1 ILE    73      92.435 104.343  58.871  1.00 42.31           C  
ATOM    571  N   SER    74      94.062  99.969  55.977  1.00 49.42           N  
ATOM    572  CA  SER    74      93.464  99.487  54.733  1.00 50.51           C  
ATOM    573  C   SER    74      92.662  98.231  55.036  1.00 51.13           C  
ATOM    574  O   SER    74      91.685  97.907  54.367  1.00 51.71           O  
ATOM    575  CB  SER    74      94.549  99.127  53.714  1.00 51.19           C  
ATOM    576  OG  SER    74      95.090  97.841  53.993  1.00 52.05           O  
ATOM    577  N   THR    75      93.106  97.528  56.064  1.00 51.38           N  
ATOM    578  CA  THR    75      92.490  96.288  56.472  1.00 51.08           C  
ATOM    579  C   THR    75      91.080  96.514  57.000  1.00 50.36           C  
ATOM    580  O   THR    75      90.183  95.709  56.767  1.00 50.15           O  
ATOM    581  CB  THR    75      93.368  95.617  57.536  1.00 51.62           C  
ATOM    582  OG1 THR    75      93.303  94.202  57.378  1.00 56.50           O  
ATOM    583  CG2 THR    75      92.908  95.984  58.939  1.00 50.68           C  
ATOM    584  N   SER    76      90.890  97.620  57.707  1.00 49.57           N  
ATOM    585  CA  SER    76      89.591  97.951  58.269  1.00 50.05           C  
ATOM    586  C   SER    76      88.694  98.509  57.170  1.00 50.81           C  
ATOM    587  O   SER    76      87.514  98.147  57.047  1.00 51.77           O  
ATOM    588  CB  SER    76      89.766  98.980  59.379  1.00 49.11           C  
ATOM    589  OG  SER    76      90.621  98.472  60.377  1.00 47.99           O  
ATOM    590  N   LEU    77      89.285  99.391  56.369  1.00 51.13           N  
ATOM    591  CA  LEU    77      88.623 100.039  55.248  1.00 51.45           C  
ATOM    592  C   LEU    77      88.006  99.002  54.297  1.00 51.62           C  
ATOM    593  O   LEU    77      86.872  99.147  53.844  1.00 51.07           O  
ATOM    594  CB  LEU    77      89.648 100.869  54.485  1.00 50.84           C  
ATOM    595  CG  LEU    77      89.208 102.173  53.837  1.00 52.69           C  
ATOM    596  CD1 LEU    77      90.141 102.457  52.676  1.00 53.42           C  
ATOM    597  CD2 LEU    77      87.781 102.084  53.355  1.00 53.75           C  
ATOM    598  N   LYS    78      88.761  97.957  53.991  1.00 52.16           N  
ATOM    599  CA  LYS    78      88.273  96.937  53.086  1.00 53.11           C  
ATOM    600  C   LYS    78      87.217  96.080  53.748  1.00 54.20           C  
ATOM    601  O   LYS    78      86.285  95.608  53.099  1.00 55.45           O  
ATOM    602  CB  LYS    78      89.437  96.079  52.584  1.00 52.56           C  
ATOM    603  CG  LYS    78      90.489  96.915  51.878  1.00 55.09           C  
ATOM    604  CD  LYS    78      91.324  96.128  50.892  1.00 58.22           C  
ATOM    605  CE  LYS    78      92.303  95.206  51.568  1.00 61.29           C  
ATOM    606  NZ  LYS    78      93.063  94.473  50.536  1.00 63.27           N  
ATOM    607  N   LEU    79      87.353  95.893  55.050  1.00 54.20           N  
ATOM    608  CA  LEU    79      86.397  95.088  55.777  1.00 53.58           C  
ATOM    609  C   LEU    79      85.031  95.748  55.653  1.00 53.51           C  
ATOM    610  O   LEU    79      84.059  95.111  55.263  1.00 53.13           O  
ATOM    611  CB  LEU    79      86.831  94.994  57.237  1.00 54.15           C  
ATOM    612  CG  LEU    79      86.457  93.736  58.017  1.00 55.50           C  
ATOM    613  CD1 LEU    79      86.571  92.523  57.124  1.00 57.45           C  
ATOM    614  CD2 LEU    79      87.383  93.600  59.221  1.00 55.73           C  
ATOM    615  N   GLY    80      84.972  97.039  55.959  1.00 53.82           N  
ATOM    616  CA  GLY    80      83.714  97.756  55.872  1.00 55.07           C  
ATOM    617  C   GLY    80      83.179  97.908  54.458  1.00 56.82           C  
ATOM    618  O   GLY    80      81.963  97.893  54.230  1.00 57.02           O  
ATOM    619  N   LEU    81      84.079  98.054  53.492  1.00 57.52           N  
ATOM    620  CA  LEU    81      83.648  98.220  52.116  1.00 57.35           C  
ATOM    621  C   LEU    81      82.893  97.011  51.573  1.00 57.82           C  
ATOM    622  O   LEU    81      82.142  97.142  50.619  1.00 58.82           O  
ATOM    623  CB  LEU    81      84.837  98.521  51.216  1.00 57.13           C  
ATOM    624  CG  LEU    81      84.401  99.039  49.844  1.00 56.54           C  
ATOM    625  CD1 LEU    81      83.556 100.301  50.013  1.00 58.60           C  
ATOM    626  CD2 LEU    81      85.625  99.330  48.999  1.00 55.16           C  
ATOM    627  N   ARG    82      83.091  95.837  52.163  1.00 58.01           N  
ATOM    628  CA  ARG    82      82.385  94.651  51.696  1.00 59.28           C  
ATOM    629  C   ARG    82      80.888  94.822  51.944  1.00 60.19           C  
ATOM    630  O   ARG    82      80.047  94.463  51.117  1.00 61.66           O  
ATOM    631  CB  ARG    82      82.862  93.400  52.440  1.00 58.88           C  
ATOM    632  CG  ARG    82      84.253  92.902  52.084  1.00 60.07           C  
ATOM    633  CD  ARG    82      84.664  91.815  53.061  1.00 64.01           C  
ATOM    634  NE  ARG    82      84.689  90.481  52.475  1.00 69.56           N  
ATOM    635  CZ  ARG    82      84.530  89.352  53.168  1.00 74.97           C  
ATOM    636  NH1 ARG    82      84.322  89.382  54.488  1.00 78.67           N  
ATOM    637  NH2 ARG    82      84.583  88.183  52.542  1.00 78.06           N  
ATOM    638  N   PHE    83      80.570  95.383  53.098  1.00 60.58           N  
ATOM    639  CA  PHE    83      79.201  95.589  53.510  1.00 61.91           C  
ATOM    640  C   PHE    83      78.471  96.590  52.596  1.00 62.30           C  
ATOM    641  O   PHE    83      77.239  96.590  52.521  1.00 62.65           O  
ATOM    642  CB  PHE    83      79.230  96.029  54.984  1.00 62.22           C  
ATOM    643  CG  PHE    83      77.879  96.200  55.616  1.00 66.17           C  
ATOM    644  CD1 PHE    83      77.191  97.415  55.517  1.00 71.26           C  
ATOM    645  CD2 PHE    83      77.296  95.162  56.333  1.00 69.17           C  
ATOM    646  CE1 PHE    83      75.936  97.597  56.129  1.00 71.89           C  
ATOM    647  CE2 PHE    83      76.044  95.337  56.947  1.00 72.59           C  
ATOM    648  CZ  PHE    83      75.363  96.561  56.841  1.00 71.44           C  
ATOM    649  N   PHE    84      79.223  97.416  51.874  1.00 62.51           N  
ATOM    650  CA  PHE    84      78.621  98.413  50.979  1.00 63.10           C  
ATOM    651  C   PHE    84      79.188  98.342  49.562  1.00 64.76           C  
ATOM    652  O   PHE    84      79.058  99.302  48.800  1.00 63.81           O  
ATOM    653  CB  PHE    84      78.899  99.832  51.485  1.00 62.18           C  
ATOM    654  CG  PHE    84      78.275 100.157  52.801  1.00 60.99           C  
ATOM    655  CD1 PHE    84      76.904 100.276  52.926  1.00 61.57           C  
ATOM    656  CD2 PHE    84      79.068 100.405  53.910  1.00 60.88           C  
ATOM    657  CE1 PHE    84      76.322 100.643  54.144  1.00 63.23           C  
ATOM    658  CE2 PHE    84      78.501 100.772  55.133  1.00 62.44           C  
ATOM    659  CZ  PHE    84      77.126 100.895  55.250  1.00 62.62           C  
ATOM    660  N   LYS    85      79.813  97.226  49.197  1.00 66.95           N  
ATOM    661  CA  LYS    85      80.441  97.130  47.882  1.00 69.13           C  
ATOM    662  C   LYS    85      79.574  97.522  46.688  1.00 70.31           C  
ATOM    663  O   LYS    85      80.069  98.143  45.749  1.00 71.72           O  
ATOM    664  CB  LYS    85      81.027  95.731  47.663  1.00 69.33           C  
ATOM    665  CG  LYS    85      80.041  94.693  47.173  1.00 72.38           C  
ATOM    666  CD  LYS    85      80.705  93.313  47.006  1.00 77.93           C  
ATOM    667  CE  LYS    85      81.890  93.326  46.034  1.00 79.05           C  
ATOM    668  NZ  LYS    85      82.423  91.957  45.746  1.00 80.80           N  
ATOM    669  N   ASP    86      78.290  97.185  46.710  1.00 70.75           N  
ATOM    670  CA  ASP    86      77.429  97.530  45.584  1.00 70.88           C  
ATOM    671  C   ASP    86      76.709  98.877  45.741  1.00 68.94           C  
ATOM    672  O   ASP    86      75.839  99.211  44.940  1.00 70.04           O  
ATOM    673  CB  ASP    86      76.405  96.415  45.354  1.00 72.35           C  
ATOM    674  CG  ASP    86      75.363  96.347  46.458  1.00 79.03           C  
ATOM    675  OD1 ASP    86      75.761  96.439  47.652  1.00 84.31           O  
ATOM    676  OD2 ASP    86      74.155  96.201  46.130  1.00 84.74           O  
ATOM    677  N   TYR    87      77.053  99.644  46.772  1.00 66.71           N  
ATOM    678  CA  TYR    87      76.431 100.956  46.985  1.00 64.20           C  
ATOM    679  C   TYR    87      77.049 101.957  46.031  1.00 64.05           C  
ATOM    680  O   TYR    87      78.094 101.699  45.440  1.00 64.34           O  
ATOM    681  CB  TYR    87      76.652 101.450  48.414  1.00 63.13           C  
ATOM    682  CG  TYR    87      75.656 100.939  49.422  1.00 59.15           C  
ATOM    683  CD1 TYR    87      75.514  99.576  49.662  1.00 54.93           C  
ATOM    684  CD2 TYR    87      74.858 101.828  50.142  1.00 56.10           C  
ATOM    685  CE1 TYR    87      74.593  99.106  50.605  1.00 53.69           C  
ATOM    686  CE2 TYR    87      73.935 101.380  51.080  1.00 54.90           C  
ATOM    687  CZ  TYR    87      73.805 100.017  51.311  1.00 55.64           C  
ATOM    688  OH  TYR    87      72.897  99.568  52.243  1.00 54.58           O  
ATOM    689  N   ASP    88      76.425 103.114  45.893  1.00 63.66           N  
ATOM    690  CA  ASP    88      76.956 104.114  44.983  1.00 64.27           C  
ATOM    691  C   ASP    88      78.246 104.726  45.519  1.00 63.88           C  
ATOM    692  O   ASP    88      79.174 105.003  44.759  1.00 64.49           O  
ATOM    693  CB  ASP    88      75.912 105.211  44.723  1.00 64.96           C  
ATOM    694  CG  ASP    88      74.598 104.650  44.172  1.00 66.85           C  
ATOM    695  OD1 ASP    88      74.657 103.802  43.253  1.00 66.84           O  
ATOM    696  OD2 ASP    88      73.515 105.060  44.654  1.00 69.17           O  
ATOM    697  N   ALA    89      78.302 104.927  46.831  1.00 62.91           N  
ATOM    698  CA  ALA    89      79.478 105.506  47.459  1.00 61.92           C  
ATOM    699  C   ALA    89      79.477 105.253  48.964  1.00 61.48           C  
ATOM    700  O   ALA    89      78.452 104.891  49.550  1.00 61.97           O  
ATOM    701  CB  ALA    89      79.522 107.005  47.184  1.00 61.21           C  
ATOM    702  N   VAL    90      80.636 105.432  49.588  1.00 60.01           N  
ATOM    703  CA  VAL    90      80.749 105.259  51.029  1.00 58.30           C  
ATOM    704  C   VAL    90      81.391 106.492  51.638  1.00 57.14           C  
ATOM    705  O   VAL    90      82.330 107.057  51.076  1.00 56.86           O  
ATOM    706  CB  VAL    90      81.620 104.030  51.415  1.00 58.42           C  
ATOM    707  CG1 VAL    90      80.921 102.750  51.026  1.00 59.19           C  
ATOM    708  CG2 VAL    90      82.986 104.127  50.750  1.00 56.69           C  
ATOM    709  N   LEU    91      80.869 106.918  52.779  1.00 55.61           N  
ATOM    710  CA  LEU    91      81.426 108.057  53.489  1.00 54.63           C  
ATOM    711  C   LEU    91      82.460 107.429  54.438  1.00 54.65           C  
ATOM    712  O   LEU    91      82.096 106.625  55.294  1.00 55.06           O  
ATOM    713  CB  LEU    91      80.334 108.748  54.298  1.00 53.78           C  
ATOM    714  CG  LEU    91      80.245 110.265  54.188  1.00 54.59           C  
ATOM    715  CD1 LEU    91      79.453 110.846  55.380  1.00 51.75           C  
ATOM    716  CD2 LEU    91      81.658 110.832  54.143  1.00 58.18           C  
ATOM    717  N   VAL    92      83.739 107.763  54.279  1.00 53.62           N  
ATOM    718  CA  VAL    92      84.768 107.187  55.140  1.00 52.79           C  
ATOM    719  C   VAL    92      85.057 108.091  56.320  1.00 52.56           C  
ATOM    720  O   VAL    92      85.872 109.001  56.217  1.00 53.69           O  
ATOM    721  CB  VAL    92      86.077 106.949  54.369  1.00 52.25           C  
ATOM    722  CG1 VAL    92      87.152 106.424  55.314  1.00 51.94           C  
ATOM    723  CG2 VAL    92      85.837 105.951  53.246  1.00 54.42           C  
ATOM    724  N   ALA    93      84.405 107.823  57.447  1.00 51.95           N  
ATOM    725  CA  ALA    93      84.571 108.639  58.646  1.00 51.84           C  
ATOM    726  C   ALA    93      85.574 108.062  59.635  1.00 52.15           C  
ATOM    727  O   ALA    93      85.803 106.856  59.683  1.00 52.28           O  
ATOM    728  CB  ALA    93      83.204 108.855  59.344  1.00 50.81           C  
ATOM    729  N   LEU    94      86.164 108.954  60.425  1.00 52.06           N  
ATOM    730  CA  LEU    94      87.140 108.589  61.436  1.00 52.16           C  
ATOM    731  C   LEU    94      86.519 108.758  62.808  1.00 52.91           C  
ATOM    732  O   LEU    94      85.943 109.803  63.096  1.00 52.88           O  
ATOM    733  CB  LEU    94      88.367 109.480  61.305  1.00 52.24           C  
ATOM    734  CG  LEU    94      89.047 109.292  59.954  1.00 51.55           C  
ATOM    735  CD1 LEU    94      89.981 110.437  59.677  1.00 52.65           C  
ATOM    736  CD2 LEU    94      89.772 107.968  59.958  1.00 50.12           C  
ATOM    737  N   GLY    95      86.645 107.719  63.639  1.00 52.92           N  
ATOM    738  CA  GLY    95      86.084 107.727  64.978  1.00 52.70           C  
ATOM    739  C   GLY    95      86.536 108.894  65.817  1.00 53.74           C  
ATOM    740  O   GLY    95      85.732 109.539  66.479  1.00 54.62           O  
ATOM    741  N   ASP    96      87.828 109.186  65.784  1.00 54.69           N  
ATOM    742  CA  ASP    96      88.369 110.287  66.567  1.00 55.37           C  
ATOM    743  C   ASP    96      88.098 111.692  66.000  1.00 56.11           C  
ATOM    744  O   ASP    96      88.752 112.658  66.391  1.00 57.21           O  
ATOM    745  CB  ASP    96      89.872 110.088  66.759  1.00 54.95           C  
ATOM    746  CG  ASP    96      90.627 110.138  65.458  1.00 58.10           C  
ATOM    747  OD1 ASP    96      89.983 110.169  64.388  1.00 60.60           O  
ATOM    748  OD2 ASP    96      91.872 110.139  65.500  1.00 63.56           O  
ATOM    749  N   MET    97      87.150 111.821  65.079  1.00 56.89           N  
ATOM    750  CA  MET    97      86.831 113.139  64.534  1.00 57.64           C  
ATOM    751  C   MET    97      85.379 113.487  64.838  1.00 57.73           C  
ATOM    752  O   MET    97      84.516 113.390  63.973  1.00 58.84           O  
ATOM    753  CB  MET    97      87.064 113.174  63.031  1.00 57.82           C  
ATOM    754  CG  MET    97      88.514 113.141  62.638  1.00 63.08           C  
ATOM    755  SD  MET    97      88.775 113.529  60.755  1.00 81.64          SE  
ATOM    756  CE  MET    97      90.719 113.549  60.713  1.00 79.03           C  
ATOM    757  N   PRO    98      85.097 113.909  66.080  1.00 57.33           N  
ATOM    758  CA  PRO    98      83.743 114.262  66.494  1.00 57.02           C  
ATOM    759  C   PRO    98      83.397 115.741  66.335  1.00 57.95           C  
ATOM    760  O   PRO    98      82.394 116.214  66.887  1.00 57.74           O  
ATOM    761  CB  PRO    98      83.740 113.840  67.950  1.00 56.71           C  
ATOM    762  CG  PRO    98      85.092 114.320  68.391  1.00 56.30           C  
ATOM    763  CD  PRO    98      86.005 113.905  67.244  1.00 57.38           C  
ATOM    764  N   PHE    99      84.215 116.484  65.596  1.00 58.99           N  
ATOM    765  CA  PHE    99      83.935 117.908  65.444  1.00 59.96           C  
ATOM    766  C   PHE    99      83.334 118.255  64.096  1.00 60.17           C  
ATOM    767  O   PHE    99      82.845 119.361  63.902  1.00 59.52           O  
ATOM    768  CB  PHE    99      85.192 118.738  65.731  1.00 60.42           C  
ATOM    769  CG  PHE    99      85.781 118.474  67.093  1.00 61.47           C  
ATOM    770  CD1 PHE    99      85.007 118.635  68.241  1.00 61.18           C  
ATOM    771  CD2 PHE    99      87.086 117.994  67.223  1.00 60.65           C  
ATOM    772  CE1 PHE    99      85.520 118.317  69.497  1.00 60.89           C  
ATOM    773  CE2 PHE    99      87.604 117.675  68.471  1.00 61.94           C  
ATOM    774  CZ  PHE    99      86.820 117.834  69.613  1.00 60.01           C  
ATOM    775  N   VAL   100      83.376 117.315  63.158  1.00 60.42           N  
ATOM    776  CA  VAL   100      82.751 117.542  61.868  1.00 59.65           C  
ATOM    777  C   VAL   100      81.269 117.660  62.251  1.00 59.60           C  
ATOM    778  O   VAL   100      80.797 116.968  63.151  1.00 58.98           O  
ATOM    779  CB  VAL   100      82.999 116.351  60.924  1.00 59.22           C  
ATOM    780  CG1 VAL   100      83.000 115.083  61.705  1.00 59.86           C  
ATOM    781  CG2 VAL   100      81.933 116.284  59.864  1.00 59.54           C  
ATOM    782  N   THR   101      80.538 118.551  61.594  1.00 60.41           N  
ATOM    783  CA  THR   101      79.130 118.766  61.923  1.00 60.04           C  
ATOM    784  C   THR   101      78.182 118.093  60.952  1.00 61.20           C  
ATOM    785  O   THR   101      78.576 117.754  59.839  1.00 61.16           O  
ATOM    786  CB  THR   101      78.803 120.244  61.913  1.00 59.27           C  
ATOM    787  OG1 THR   101      78.981 120.739  60.584  1.00 57.79           O  
ATOM    788  CG2 THR   101      79.711 120.997  62.861  1.00 56.24           C  
ATOM    789  N   LYS   102      76.933 117.903  61.376  1.00 62.74           N  
ATOM    790  CA  LYS   102      75.934 117.286  60.509  1.00 64.81           C  
ATOM    791  C   LYS   102      75.879 118.093  59.232  1.00 65.39           C  
ATOM    792  O   LYS   102      75.819 117.541  58.136  1.00 64.62           O  
ATOM    793  CB  LYS   102      74.548 117.289  61.156  1.00 65.69           C  
ATOM    794  CG  LYS   102      74.235 116.061  61.996  1.00 69.63           C  
ATOM    795  CD  LYS   102      72.739 115.824  62.059  1.00 74.55           C  
ATOM    796  CE  LYS   102      72.405 114.639  62.937  1.00 77.99           C  
ATOM    797  NZ  LYS   102      72.889 114.863  64.326  1.00 81.50           N  
ATOM    798  N   GLU   103      75.902 119.412  59.391  1.00 66.62           N  
ATOM    799  CA  GLU   103      75.878 120.323  58.257  1.00 68.07           C  
ATOM    800  C   GLU   103      76.974 119.993  57.244  1.00 67.62           C  
ATOM    801  O   GLU   103      76.724 119.985  56.037  1.00 67.46           O  
ATOM    802  CB  GLU   103      76.039 121.763  58.744  1.00 69.67           C  
ATOM    803  CG  GLU   103      74.842 122.277  59.505  1.00 75.46           C  
ATOM    804  CD  GLU   103      73.535 122.020  58.757  1.00 83.50           C  
ATOM    805  OE1 GLU   103      73.498 122.265  57.528  1.00 86.84           O  
ATOM    806  OE2 GLU   103      72.549 121.576  59.396  1.00 86.31           O  
ATOM    807  N   ASP   104      78.185 119.731  57.736  1.00 67.07           N  
ATOM    808  CA  ASP   104      79.305 119.393  56.867  1.00 66.63           C  
ATOM    809  C   ASP   104      78.984 118.133  56.083  1.00 66.12           C  
ATOM    810  O   ASP   104      79.264 118.044  54.886  1.00 65.91           O  
ATOM    811  CB  ASP   104      80.577 119.143  57.679  1.00 66.99           C  
ATOM    812  CG  ASP   104      81.038 120.362  58.440  1.00 68.35           C  
ATOM    813  OD1 ASP   104      80.997 121.463  57.863  1.00 72.59           O  
ATOM    814  OD2 ASP   104      81.458 120.220  59.608  1.00 65.48           O  
ATOM    815  N   VAL   105      78.405 117.150  56.761  1.00 65.88           N  
ATOM    816  CA  VAL   105      78.070 115.899  56.099  1.00 66.65           C  
ATOM    817  C   VAL   105      76.964 116.093  55.070  1.00 67.88           C  
ATOM    818  O   VAL   105      76.948 115.429  54.025  1.00 68.40           O  
ATOM    819  CB  VAL   105      77.632 114.819  57.111  1.00 66.21           C  
ATOM    820  CG1 VAL   105      77.236 113.530  56.369  1.00 63.28           C  
ATOM    821  CG2 VAL   105      78.767 114.554  58.092  1.00 64.83           C  
ATOM    822  N   ASN   106      76.046 117.006  55.372  1.00 68.52           N  
ATOM    823  CA  ASN   106      74.945 117.299  54.475  1.00 69.21           C  
ATOM    824  C   ASN   106      75.521 117.899  53.192  1.00 69.46           C  
ATOM    825  O   ASN   106      75.156 117.491  52.084  1.00 69.79           O  
ATOM    826  CB  ASN   106      73.980 118.278  55.146  1.00 70.36           C  
ATOM    827  CG  ASN   106      72.590 118.252  54.523  1.00 73.18           C  
ATOM    828  OD1 ASN   106      71.923 117.213  54.511  1.00 75.38           O  
ATOM    829  ND2 ASN   106      72.146 119.399  54.003  1.00 78.25           N  
ATOM    830  N   LYS   107      76.434 118.859  53.346  1.00 69.38           N  
ATOM    831  CA  LYS   107      77.072 119.498  52.198  1.00 69.64           C  
ATOM    832  C   LYS   107      77.833 118.484  51.361  1.00 69.90           C  
ATOM    833  O   LYS   107      77.671 118.426  50.147  1.00 70.92           O  
ATOM    834  CB  LYS   107      78.064 120.569  52.643  1.00 69.73           C  
ATOM    835  CG  LYS   107      77.466 121.815  53.240  1.00 70.89           C  
ATOM    836  CD  LYS   107      78.581 122.754  53.661  1.00 72.41           C  
ATOM    837  CE  LYS   107      78.020 123.994  54.287  1.00 75.34           C  
ATOM    838  NZ  LYS   107      77.084 123.633  55.384  1.00 78.79           N  
ATOM    839  N   ILE   108      78.674 117.694  52.018  1.00 69.99           N  
ATOM    840  CA  ILE   108      79.475 116.690  51.326  1.00 70.00           C  
ATOM    841  C   ILE   108      78.630 115.750  50.488  1.00 70.52           C  
ATOM    842  O   ILE   108      78.946 115.489  49.322  1.00 69.75           O  
ATOM    843  CB  ILE   108      80.301 115.837  52.323  1.00 69.97           C  
ATOM    844  CG1 ILE   108      81.223 116.744  53.141  1.00 68.99           C  
ATOM    845  CG2 ILE   108      81.121 114.792  51.562  1.00 67.40           C  
ATOM    846  CD1 ILE   108      82.050 116.021  54.165  1.00 68.64           C  
ATOM    847  N   ILE   109      77.559 115.235  51.084  1.00 71.82           N  
ATOM    848  CA  ILE   109      76.694 114.312  50.372  1.00 73.40           C  
ATOM    849  C   ILE   109      75.963 115.030  49.244  1.00 74.95           C  
ATOM    850  O   ILE   109      75.712 114.444  48.188  1.00 74.87           O  
ATOM    851  CB  ILE   109      75.669 113.648  51.317  1.00 72.92           C  
ATOM    852  CG1 ILE   109      76.396 112.902  52.438  1.00 72.32           C  
ATOM    853  CG2 ILE   109      74.815 112.658  50.543  1.00 73.00           C  
ATOM    854  CD1 ILE   109      75.471 112.152  53.374  1.00 72.12           C  
ATOM    855  N   ASN   110      75.640 116.304  49.454  1.00 76.62           N  
ATOM    856  CA  ASN   110      74.943 117.074  48.427  1.00 77.75           C  
ATOM    857  C   ASN   110      75.827 117.519  47.265  1.00 77.54           C  
ATOM    858  O   ASN   110      75.317 117.937  46.227  1.00 78.41           O  
ATOM    859  CB  ASN   110      74.271 118.306  49.037  1.00 78.60           C  
ATOM    860  CG  ASN   110      73.054 117.952  49.879  1.00 81.57           C  
ATOM    861  OD1 ASN   110      72.228 117.114  49.494  1.00 82.58           O  
ATOM    862  ND2 ASN   110      72.930 118.603  51.031  1.00 85.45           N  
ATOM    863  N   THR   111      77.142 117.424  47.427  1.00 76.50           N  
ATOM    864  CA  THR   111      78.069 117.836  46.379  1.00 75.76           C  
ATOM    865  C   THR   111      78.380 116.689  45.426  1.00 76.37           C  
ATOM    866  O   THR   111      78.986 116.884  44.377  1.00 76.43           O  
ATOM    867  CB  THR   111      79.388 118.337  46.994  1.00 75.39           C  
ATOM    868  OG1 THR   111      79.100 119.332  47.978  1.00 74.42           O  
ATOM    869  CG2 THR   111      80.290 118.936  45.937  1.00 75.41           C  
ATOM    870  N   PHE   112      77.945 115.491  45.788  1.00 77.34           N  
ATOM    871  CA  PHE   112      78.210 114.306  44.982  1.00 78.11           C  
ATOM    872  C   PHE   112      77.405 114.191  43.689  1.00 80.28           C  
ATOM    873  O   PHE   112      76.184 114.050  43.716  1.00 80.80           O  
ATOM    874  CB  PHE   112      77.994 113.060  45.836  1.00 76.72           C  
ATOM    875  CG  PHE   112      78.192 111.781  45.096  1.00 73.51           C  
ATOM    876  CD1 PHE   112      79.335 111.578  44.333  1.00 70.01           C  
ATOM    877  CD2 PHE   112      77.249 110.763  45.182  1.00 71.66           C  
ATOM    878  CE1 PHE   112      79.540 110.378  43.663  1.00 69.79           C  
ATOM    879  CE2 PHE   112      77.443 109.558  44.517  1.00 69.27           C  
ATOM    880  CZ  PHE   112      78.596 109.366  43.755  1.00 69.71           C  
ATOM    881  N   LYS   113      78.103 114.242  42.557  1.00 82.83           N  
ATOM    882  CA  LYS   113      77.463 114.128  41.250  1.00 85.02           C  
ATOM    883  C   LYS   113      78.089 112.966  40.486  1.00 86.49           C  
ATOM    884  O   LYS   113      79.163 112.479  40.850  1.00 86.93           O  
ATOM    885  CB  LYS   113      77.649 115.415  40.446  1.00 84.96           C  
ATOM    886  CG  LYS   113      77.320 116.675  41.213  1.00 85.92           C  
ATOM    887  CD  LYS   113      75.900 116.661  41.722  1.00 88.01           C  
ATOM    888  CE  LYS   113      75.673 117.838  42.646  1.00 90.37           C  
ATOM    889  NZ  LYS   113      74.331 117.785  43.276  1.00 92.40           N  
ATOM    890  N   PRO   114      77.430 112.511  39.406  1.00 87.82           N  
ATOM    891  CA  PRO   114      77.936 111.395  38.593  1.00 88.26           C  
ATOM    892  C   PRO   114      79.341 111.625  38.020  1.00 88.54           C  
ATOM    893  O   PRO   114      80.075 110.672  37.744  1.00 88.72           O  
ATOM    894  CB  PRO   114      76.876 111.262  37.495  1.00 88.45           C  
ATOM    895  CG  PRO   114      75.612 111.728  38.184  1.00 88.65           C  
ATOM    896  CD  PRO   114      76.107 112.954  38.921  1.00 87.87           C  
ATOM    897  N   ASN   115      79.708 112.891  37.838  1.00 88.27           N  
ATOM    898  CA  ASN   115      81.017 113.234  37.299  1.00 87.89           C  
ATOM    899  C   ASN   115      82.099 113.053  38.355  1.00 87.58           C  
ATOM    900  O   ASN   115      83.263 112.827  38.024  1.00 88.00           O  
ATOM    901  CB  ASN   115      81.011 114.676  36.803  1.00 87.90           C  
ATOM    902  N   CYS   116      81.701 113.145  39.623  1.00 86.76           N  
ATOM    903  CA  CYS   116      82.625 113.026  40.747  1.00 86.00           C  
ATOM    904  C   CYS   116      83.114 111.618  41.050  1.00 84.42           C  
ATOM    905  O   CYS   116      82.317 110.697  41.241  1.00 84.56           O  
ATOM    906  CB  CYS   116      81.992 113.593  42.023  1.00 86.32           C  
ATOM    907  SG  CYS   116      81.339 115.287  41.872  1.00 90.88           S  
ATOM    908  N   LYS   117      84.436 111.473  41.101  1.00 82.59           N  
ATOM    909  CA  LYS   117      85.085 110.208  41.429  1.00 80.48           C  
ATOM    910  C   LYS   117      85.085 110.109  42.955  1.00 78.41           C  
ATOM    911  O   LYS   117      84.997 109.026  43.536  1.00 77.64           O  
ATOM    912  CB  LYS   117      86.527 110.211  40.926  1.00 81.04           C  
ATOM    913  CG  LYS   117      86.693 109.859  39.469  1.00 83.13           C  
ATOM    914  CD  LYS   117      86.463 108.377  39.259  1.00 87.67           C  
ATOM    915  CE  LYS   117      86.861 107.948  37.863  1.00 91.25           C  
ATOM    916  NZ  LYS   117      86.017 108.607  36.834  1.00 94.86           N  
ATOM    917  N   ALA   118      85.181 111.268  43.592  1.00 75.75           N  
ATOM    918  CA  ALA   118      85.192 111.348  45.036  1.00 73.60           C  
ATOM    919  C   ALA   118      84.942 112.785  45.442  1.00 72.38           C  
ATOM    920  O   ALA   118      85.389 113.704  44.772  1.00 73.59           O  
ATOM    921  CB  ALA   118      86.529 110.890  45.564  1.00 74.01           C  
ATOM    922  N   VAL   119      84.210 112.976  46.530  1.00 70.08           N  
ATOM    923  CA  VAL   119      83.930 114.309  47.032  1.00 68.06           C  
ATOM    924  C   VAL   119      84.834 114.478  48.231  1.00 67.27           C  
ATOM    925  O   VAL   119      84.939 113.568  49.052  1.00 67.93           O  
ATOM    926  CB  VAL   119      82.487 114.445  47.513  1.00 68.04           C  
ATOM    927  CG1 VAL   119      82.307 115.773  48.190  1.00 66.10           C  
ATOM    928  CG2 VAL   119      81.532 114.315  46.355  1.00 68.91           C  
ATOM    929  N   ILE   120      85.481 115.632  48.348  1.00 65.82           N  
ATOM    930  CA  ILE   120      86.382 115.866  49.468  1.00 64.51           C  
ATOM    931  C   ILE   120      86.098 117.157  50.210  1.00 65.04           C  
ATOM    932  O   ILE   120      86.161 118.246  49.639  1.00 64.40           O  
ATOM    933  CB  ILE   120      87.863 115.901  49.012  1.00 63.92           C  
ATOM    934  CG1 ILE   120      88.264 114.544  48.425  1.00 63.65           C  
ATOM    935  CG2 ILE   120      88.763 116.263  50.187  1.00 61.60           C  
ATOM    936  CD1 ILE   120      89.684 114.494  47.896  1.00 60.61           C  
ATOM    937  N   PRO   121      85.773 117.059  51.505  1.00 65.27           N  
ATOM    938  CA  PRO   121      85.510 118.305  52.230  1.00 65.83           C  
ATOM    939  C   PRO   121      86.783 119.147  52.290  1.00 66.58           C  
ATOM    940  O   PRO   121      87.901 118.618  52.304  1.00 65.85           O  
ATOM    941  CB  PRO   121      85.050 117.820  53.605  1.00 65.49           C  
ATOM    942  CG  PRO   121      85.761 116.510  53.754  1.00 64.49           C  
ATOM    943  CD  PRO   121      85.607 115.889  52.382  1.00 64.85           C  
ATOM    944  N   THR   122      86.595 120.461  52.312  1.00 67.79           N  
ATOM    945  CA  THR   122      87.704 121.402  52.356  1.00 69.21           C  
ATOM    946  C   THR   122      87.402 122.530  53.319  1.00 69.43           C  
ATOM    947  O   THR   122      86.245 122.846  53.592  1.00 69.17           O  
ATOM    948  CB  THR   122      87.962 122.032  50.975  1.00 69.52           C  
ATOM    949  OG1 THR   122      88.161 121.001  50.000  1.00 71.78           O  
ATOM    950  CG2 THR   122      89.194 122.902  51.018  1.00 70.92           C  
ATOM    951  N   HIS   123      88.457 123.134  53.839  1.00 70.60           N  
ATOM    952  CA  HIS   123      88.293 124.250  54.742  1.00 72.73           C  
ATOM    953  C   HIS   123      89.555 125.079  54.795  1.00 74.60           C  
ATOM    954  O   HIS   123      90.575 124.650  55.336  1.00 75.01           O  
ATOM    955  CB  HIS   123      87.915 123.777  56.132  1.00 72.08           C  
ATOM    956  CG  HIS   123      87.799 124.884  57.127  1.00 72.75           C  
ATOM    957  ND1 HIS   123      88.891 125.434  57.756  1.00 74.49           N  
ATOM    958  CD2 HIS   123      86.715 125.527  57.625  1.00 73.58           C  
ATOM    959  CE1 HIS   123      88.487 126.361  58.608  1.00 74.84           C  
ATOM    960  NE2 HIS   123      87.170 126.436  58.547  1.00 73.86           N  
ATOM    961  N   LYS   124      89.463 126.272  54.207  1.00 76.62           N  
ATOM    962  CA  LYS   124      90.561 127.221  54.151  1.00 78.11           C  
ATOM    963  C   LYS   124      91.809 126.634  53.499  1.00 78.93           C  
ATOM    964  O   LYS   124      92.879 126.549  54.113  1.00 79.34           O  
ATOM    965  CB  LYS   124      90.867 127.743  55.553  1.00 78.57           C  
ATOM    966  CG  LYS   124      89.752 128.605  56.124  1.00 80.40           C  
ATOM    967  CD  LYS   124      90.060 129.065  57.544  1.00 83.67           C  
ATOM    968  CE  LYS   124      88.898 129.847  58.140  1.00 84.87           C  
ATOM    969  NZ  LYS   124      89.052 130.018  59.615  1.00 87.62           N  
ATOM    970  N   GLY   125      91.643 126.212  52.248  1.00 79.59           N  
ATOM    971  CA  GLY   125      92.753 125.675  51.485  1.00 80.41           C  
ATOM    972  C   GLY   125      93.002 124.184  51.559  1.00 81.19           C  
ATOM    973  O   GLY   125      93.167 123.532  50.525  1.00 81.94           O  
ATOM    974  N   GLU   126      93.037 123.637  52.771  1.00 81.23           N  
ATOM    975  CA  GLU   126      93.299 122.208  52.949  1.00 80.96           C  
ATOM    976  C   GLU   126      92.057 121.321  52.975  1.00 79.32           C  
ATOM    977  O   GLU   126      90.977 121.743  53.408  1.00 79.79           O  
ATOM    978  CB  GLU   126      94.115 121.994  54.225  1.00 81.55           C  
ATOM    979  CG  GLU   126      93.533 122.678  55.439  1.00 84.47           C  
ATOM    980  CD  GLU   126      94.508 122.726  56.598  1.00 89.37           C  
ATOM    981  OE1 GLU   126      94.954 121.646  57.051  1.00 90.89           O  
ATOM    982  OE2 GLU   126      94.831 123.845  57.058  1.00 91.20           O  
ATOM    983  N   ARG   127      92.225 120.093  52.489  1.00 76.70           N  
ATOM    984  CA  ARG   127      91.141 119.121  52.467  1.00 74.71           C  
ATOM    985  C   ARG   127      91.155 118.253  53.731  1.00 72.90           C  
ATOM    986  O   ARG   127      92.216 117.877  54.233  1.00 72.41           O  
ATOM    987  CB  ARG   127      91.232 118.245  51.211  1.00 74.97           C  
ATOM    988  CG  ARG   127      92.639 117.903  50.754  1.00 75.13           C  
ATOM    989  CD  ARG   127      92.898 118.419  49.339  1.00 76.10           C  
ATOM    990  NE  ARG   127      93.050 117.355  48.344  1.00 77.77           N  
ATOM    991  CZ  ARG   127      93.366 117.569  47.065  1.00 79.80           C  
ATOM    992  NH1 ARG   127      93.561 118.811  46.627  1.00 80.34           N  
ATOM    993  NH2 ARG   127      93.501 116.548  46.220  1.00 78.44           N  
ATOM    994  N   GLY   128      89.963 117.955  54.246  1.00 70.72           N  
ATOM    995  CA  GLY   128      89.845 117.150  55.450  1.00 66.93           C  
ATOM    996  C   GLY   128      88.973 115.917  55.308  1.00 64.25           C  
ATOM    997  O   GLY   128      88.916 115.298  54.250  1.00 64.67           O  
ATOM    998  N   ASN   129      88.294 115.559  56.390  1.00 61.56           N  
ATOM    999  CA  ASN   129      87.428 114.384  56.402  1.00 58.87           C  
ATOM   1000  C   ASN   129      86.078 114.722  57.020  1.00 57.79           C  
ATOM   1001  O   ASN   129      85.945 115.703  57.753  1.00 57.31           O  
ATOM   1002  CB  ASN   129      88.093 113.260  57.189  1.00 58.60           C  
ATOM   1003  CG  ASN   129      89.402 112.817  56.574  1.00 57.95           C  
ATOM   1004  OD1 ASN   129      89.422 112.151  55.537  1.00 56.78           O  
ATOM   1005  ND2 ASN   129      90.508 113.198  57.202  1.00 56.02           N  
ATOM   1006  N   PRO   130      85.071 113.869  56.797  1.00 57.42           N  
ATOM   1007  CA  PRO   130      85.104 112.632  56.014  1.00 56.93           C  
ATOM   1008  C   PRO   130      85.084 112.800  54.507  1.00 57.84           C  
ATOM   1009  O   PRO   130      84.498 113.745  53.983  1.00 58.47           O  
ATOM   1010  CB  PRO   130      83.875 111.898  56.512  1.00 56.26           C  
ATOM   1011  CG  PRO   130      82.909 113.030  56.684  1.00 57.24           C  
ATOM   1012  CD  PRO   130      83.743 114.066  57.403  1.00 56.49           C  
ATOM   1013  N   VAL   131      85.714 111.852  53.822  1.00 58.00           N  
ATOM   1014  CA  VAL   131      85.790 111.834  52.371  1.00 57.97           C  
ATOM   1015  C   VAL   131      84.782 110.849  51.776  1.00 58.42           C  
ATOM   1016  O   VAL   131      84.677 109.704  52.234  1.00 58.77           O  
ATOM   1017  CB  VAL   131      87.204 111.441  51.917  1.00 57.59           C  
ATOM   1018  CG1 VAL   131      87.198 111.014  50.476  1.00 59.19           C  
ATOM   1019  CG2 VAL   131      88.124 112.611  52.088  1.00 58.16           C  
ATOM   1020  N   LEU   132      84.055 111.293  50.750  1.00 58.08           N  
ATOM   1021  CA  LEU   132      83.058 110.449  50.092  1.00 57.65           C  
ATOM   1022  C   LEU   132      83.647 109.779  48.851  1.00 57.67           C  
ATOM   1023  O   LEU   132      83.900 110.443  47.856  1.00 59.54           O  
ATOM   1024  CB  LEU   132      81.833 111.293  49.717  1.00 57.41           C  
ATOM   1025  CG  LEU   132      80.631 110.589  49.074  1.00 58.34           C  
ATOM   1026  CD1 LEU   132      80.298 109.336  49.842  1.00 61.60           C  
ATOM   1027  CD2 LEU   132      79.430 111.512  49.063  1.00 55.91           C  
ATOM   1028  N   ILE   133      83.867 108.468  48.909  1.00 56.74           N  
ATOM   1029  CA  ILE   133      84.448 107.730  47.786  1.00 55.35           C  
ATOM   1030  C   ILE   133      83.375 106.967  47.010  1.00 55.07           C  
ATOM   1031  O   ILE   133      82.522 106.298  47.612  1.00 56.48           O  
ATOM   1032  CB  ILE   133      85.510 106.710  48.265  1.00 55.20           C  
ATOM   1033  CG1 ILE   133      86.601 107.417  49.071  1.00 56.29           C  
ATOM   1034  CG2 ILE   133      86.114 105.996  47.063  1.00 55.79           C  
ATOM   1035  CD1 ILE   133      87.725 106.513  49.499  1.00 57.86           C  
ATOM   1036  N   SER   134      83.443 107.040  45.679  1.00 52.85           N  
ATOM   1037  CA  SER   134      82.458 106.394  44.805  1.00 51.80           C  
ATOM   1038  C   SER   134      82.815 104.995  44.295  1.00 52.90           C  
ATOM   1039  O   SER   134      83.985 104.657  44.136  1.00 53.54           O  
ATOM   1040  CB  SER   134      82.181 107.294  43.602  1.00 51.85           C  
ATOM   1041  OG  SER   134      83.293 107.298  42.722  1.00 47.09           O  
ATOM   1042  N   LYS   135      81.789 104.200  44.007  1.00 55.28           N  
ATOM   1043  CA  LYS   135      81.978 102.836  43.526  1.00 57.82           C  
ATOM   1044  C   LYS   135      83.063 102.729  42.459  1.00 59.79           C  
ATOM   1045  O   LYS   135      83.720 101.689  42.340  1.00 60.63           O  
ATOM   1046  CB  LYS   135      80.648 102.266  42.992  1.00 56.16           C  
ATOM   1047  N   SER   136      83.259 103.791  41.681  1.00 62.28           N  
ATOM   1048  CA  SER   136      84.284 103.751  40.639  1.00 63.96           C  
ATOM   1049  C   SER   136      85.636 103.438  41.283  1.00 64.38           C  
ATOM   1050  O   SER   136      86.423 102.647  40.741  1.00 65.17           O  
ATOM   1051  CB  SER   136      84.355 105.083  39.887  1.00 64.03           C  
ATOM   1052  OG  SER   136      84.767 106.133  40.741  1.00 67.09           O  
ATOM   1053  N   LEU   137      85.880 104.042  42.448  1.00 64.20           N  
ATOM   1054  CA  LEU   137      87.118 103.840  43.199  1.00 64.30           C  
ATOM   1055  C   LEU   137      87.153 102.611  44.128  1.00 63.64           C  
ATOM   1056  O   LEU   137      88.192 102.327  44.717  1.00 63.46           O  
ATOM   1057  CB  LEU   137      87.443 105.078  44.042  1.00 64.99           C  
ATOM   1058  CG  LEU   137      87.910 106.363  43.359  1.00 67.10           C  
ATOM   1059  CD1 LEU   137      89.022 106.027  42.382  1.00 68.80           C  
ATOM   1060  CD2 LEU   137      86.754 107.025  42.647  1.00 70.31           C  
ATOM   1061  N   PHE   138      86.051 101.882  44.282  1.00 62.43           N  
ATOM   1062  CA  PHE   138      86.104 100.728  45.172  1.00 62.24           C  
ATOM   1063  C   PHE   138      87.174  99.736  44.722  1.00 63.75           C  
ATOM   1064  O   PHE   138      87.849  99.132  45.552  1.00 65.01           O  
ATOM   1065  CB  PHE   138      84.746 100.011  45.275  1.00 60.61           C  
ATOM   1066  CG  PHE   138      83.649 100.842  45.899  1.00 55.89           C  
ATOM   1067  CD1 PHE   138      83.911 102.108  46.424  1.00 52.20           C  
ATOM   1068  CD2 PHE   138      82.341 100.363  45.939  1.00 54.02           C  
ATOM   1069  CE1 PHE   138      82.884 102.891  46.974  1.00 50.00           C  
ATOM   1070  CE2 PHE   138      81.306 101.135  46.485  1.00 53.26           C  
ATOM   1071  CZ  PHE   138      81.580 102.401  47.005  1.00 52.41           C  
ATOM   1072  N   ASN   139      87.350  99.558  43.418  1.00 65.81           N  
ATOM   1073  CA  ASN   139      88.372  98.615  42.955  1.00 67.56           C  
ATOM   1074  C   ASN   139      89.744  99.043  43.470  1.00 68.24           C  
ATOM   1075  O   ASN   139      90.535  98.219  43.918  1.00 68.02           O  
ATOM   1076  CB  ASN   139      88.384  98.539  41.433  1.00 67.28           C  
ATOM   1077  N   GLU   140      90.012 100.342  43.413  1.00 69.37           N  
ATOM   1078  CA  GLU   140      91.285 100.880  43.863  1.00 70.51           C  
ATOM   1079  C   GLU   140      91.556 100.634  45.329  1.00 70.69           C  
ATOM   1080  O   GLU   140      92.644 100.196  45.703  1.00 71.04           O  
ATOM   1081  CB  GLU   140      91.342 102.380  43.597  1.00 71.48           C  
ATOM   1082  CG  GLU   140      91.568 102.719  42.147  1.00 74.90           C  
ATOM   1083  CD  GLU   140      92.902 102.195  41.651  1.00 79.72           C  
ATOM   1084  OE1 GLU   140      93.952 102.688  42.138  1.00 80.78           O  
ATOM   1085  OE2 GLU   140      92.894 101.287  40.783  1.00 81.31           O  
ATOM   1086  N   ILE   141      90.568 100.928  46.166  1.00 71.01           N  
ATOM   1087  CA  ILE   141      90.736 100.754  47.598  1.00 70.87           C  
ATOM   1088  C   ILE   141      91.025  99.294  47.941  1.00 70.05           C  
ATOM   1089  O   ILE   141      91.832  99.015  48.828  1.00 70.27           O  
ATOM   1090  CB  ILE   141      89.507 101.342  48.385  1.00 71.02           C  
ATOM   1091  CG1 ILE   141      89.560 100.931  49.851  1.00 72.11           C  
ATOM   1092  CG2 ILE   141      88.219 100.909  47.761  1.00 71.02           C  
ATOM   1093  CD1 ILE   141      88.892  99.606  50.139  1.00 75.02           C  
ATOM   1094  N   GLU   142      90.410  98.365  47.217  1.00 69.37           N  
ATOM   1095  CA  GLU   142      90.659  96.947  47.467  1.00 69.15           C  
ATOM   1096  C   GLU   142      92.147  96.636  47.267  1.00 68.76           C  
ATOM   1097  O   GLU   142      92.722  95.818  47.981  1.00 68.80           O  
ATOM   1098  CB  GLU   142      89.813  96.086  46.535  1.00 68.61           C  
ATOM   1099  N   LYS   143      92.766  97.308  46.299  1.00 68.67           N  
ATOM   1100  CA  LYS   143      94.184  97.113  45.980  1.00 68.20           C  
ATOM   1101  C   LYS   143      95.122  97.568  47.105  1.00 67.70           C  
ATOM   1102  O   LYS   143      96.254  97.090  47.225  1.00 68.14           O  
ATOM   1103  CB  LYS   143      94.525  97.850  44.676  1.00 68.56           C  
ATOM   1104  N   LEU   144      94.645  98.499  47.921  1.00 66.67           N  
ATOM   1105  CA  LEU   144      95.408  99.020  49.049  1.00 65.38           C  
ATOM   1106  C   LEU   144      96.016  97.900  49.921  1.00 64.92           C  
ATOM   1107  O   LEU   144      95.476  96.787  49.994  1.00 64.21           O  
ATOM   1108  CB  LEU   144      94.483  99.898  49.897  1.00 65.48           C  
ATOM   1109  CG  LEU   144      94.824 101.371  50.106  1.00 66.58           C  
ATOM   1110  CD1 LEU   144      95.439 101.960  48.858  1.00 67.08           C  
ATOM   1111  CD2 LEU   144      93.557 102.119  50.485  1.00 66.22           C  
ATOM   1112  N   ARG   145      97.138  98.207  50.578  1.00 64.60           N  
ATOM   1113  CA  ARG   145      97.823  97.256  51.465  1.00 64.15           C  
ATOM   1114  C   ARG   145      98.183  97.860  52.819  1.00 63.00           C  
ATOM   1115  O   ARG   145      98.368  99.075  52.951  1.00 62.62           O  
ATOM   1116  CB  ARG   145      99.101  96.724  50.813  1.00 64.74           C  
ATOM   1117  CG  ARG   145      98.853  95.634  49.791  1.00 69.68           C  
ATOM   1118  CD  ARG   145      99.825  95.721  48.615  1.00 76.97           C  
ATOM   1119  NE  ARG   145     101.228  95.680  49.025  1.00 79.89           N  
ATOM   1120  CZ  ARG   145     101.807  94.649  49.633  1.00 80.04           C  
ATOM   1121  NH1 ARG   145     101.106  93.557  49.911  1.00 77.46           N  
ATOM   1122  NH2 ARG   145     103.091  94.713  49.966  1.00 80.64           N  
ATOM   1123  N   GLY   146      98.270  96.987  53.819  1.00 61.83           N  
ATOM   1124  CA  GLY   146      98.634  97.387  55.168  1.00 59.45           C  
ATOM   1125  C   GLY   146      97.976  98.610  55.772  1.00 58.65           C  
ATOM   1126  O   GLY   146      96.751  98.673  55.929  1.00 57.38           O  
ATOM   1127  N   ASP   147      98.812  99.585  56.120  1.00 57.90           N  
ATOM   1128  CA  ASP   147      98.349 100.817  56.742  1.00 57.47           C  
ATOM   1129  C   ASP   147      98.253 101.992  55.776  1.00 57.66           C  
ATOM   1130  O   ASP   147      98.311 103.150  56.189  1.00 58.10           O  
ATOM   1131  CB  ASP   147      99.268 101.203  57.894  1.00 56.82           C  
ATOM   1132  CG  ASP   147      98.572 102.069  58.919  1.00 58.56           C  
ATOM   1133  OD1 ASP   147      99.230 102.956  59.494  1.00 60.43           O  
ATOM   1134  OD2 ASP   147      97.365 101.852  59.160  1.00 61.44           O  
ATOM   1135  N   VAL   148      98.118 101.695  54.491  1.00 57.82           N  
ATOM   1136  CA  VAL   148      97.990 102.741  53.491  1.00 57.65           C  
ATOM   1137  C   VAL   148      96.523 103.100  53.383  1.00 58.26           C  
ATOM   1138  O   VAL   148      95.702 102.241  53.075  1.00 57.77           O  
ATOM   1139  CB  VAL   148      98.470 102.259  52.130  1.00 57.60           C  
ATOM   1140  CG1 VAL   148      98.224 103.321  51.090  1.00 55.84           C  
ATOM   1141  CG2 VAL   148      99.929 101.907  52.207  1.00 57.70           C  
ATOM   1142  N   GLY   149      96.205 104.367  53.632  1.00 59.53           N  
ATOM   1143  CA  GLY   149      94.829 104.826  53.570  1.00 61.31           C  
ATOM   1144  C   GLY   149      94.349 105.192  52.182  1.00 63.72           C  
ATOM   1145  O   GLY   149      95.051 104.994  51.189  1.00 64.43           O  
ATOM   1146  N   ALA   150      93.147 105.746  52.110  1.00 65.36           N  
ATOM   1147  CA  ALA   150      92.564 106.128  50.831  1.00 67.42           C  
ATOM   1148  C   ALA   150      93.150 107.416  50.231  1.00 68.74           C  
ATOM   1149  O   ALA   150      93.027 107.648  49.025  1.00 68.20           O  
ATOM   1150  CB  ALA   150      91.052 106.251  50.975  1.00 67.32           C  
ATOM   1151  N   ARG   151      93.794 108.241  51.058  1.00 71.18           N  
ATOM   1152  CA  ARG   151      94.378 109.491  50.570  1.00 74.01           C  
ATOM   1153  C   ARG   151      95.388 109.269  49.453  1.00 75.14           C  
ATOM   1154  O   ARG   151      95.635 110.154  48.635  1.00 75.26           O  
ATOM   1155  CB  ARG   151      95.047 110.262  51.702  1.00 74.25           C  
ATOM   1156  CG  ARG   151      95.632 111.606  51.257  1.00 77.89           C  
ATOM   1157  CD  ARG   151      95.776 112.564  52.437  1.00 84.37           C  
ATOM   1158  NE  ARG   151      96.526 111.945  53.525  1.00 89.32           N  
ATOM   1159  CZ  ARG   151      97.811 111.612  53.452  1.00 91.28           C  
ATOM   1160  NH1 ARG   151      98.501 111.848  52.338  1.00 90.83           N  
ATOM   1161  NH2 ARG   151      98.400 111.020  54.487  1.00 92.52           N  
ATOM   1162  N   VAL   152      95.969 108.080  49.420  1.00 76.27           N  
ATOM   1163  CA  VAL   152      96.933 107.758  48.390  1.00 77.39           C  
ATOM   1164  C   VAL   152      96.218 107.653  47.055  1.00 77.89           C  
ATOM   1165  O   VAL   152      96.724 108.117  46.035  1.00 77.93           O  
ATOM   1166  CB  VAL   152      97.636 106.434  48.695  1.00 77.65           C  
ATOM   1167  CG1 VAL   152      98.684 106.155  47.643  1.00 76.78           C  
ATOM   1168  CG2 VAL   152      98.274 106.505  50.072  1.00 80.17           C  
ATOM   1169  N   ILE   153      95.033 107.050  47.069  1.00 78.94           N  
ATOM   1170  CA  ILE   153      94.243 106.886  45.852  1.00 79.79           C  
ATOM   1171  C   ILE   153      93.630 108.209  45.401  1.00 80.54           C  
ATOM   1172  O   ILE   153      93.329 108.391  44.220  1.00 80.78           O  
ATOM   1173  CB  ILE   153      93.086 105.892  46.051  1.00 79.53           C  
ATOM   1174  CG1 ILE   153      93.615 104.580  46.613  1.00 79.70           C  
ATOM   1175  CG2 ILE   153      92.392 105.624  44.723  1.00 78.74           C  
ATOM   1176  CD1 ILE   153      92.523 103.590  46.929  1.00 81.12           C  
ATOM   1177  N   LEU   154      93.443 109.130  46.344  1.00 81.43           N  
ATOM   1178  CA  LEU   154      92.851 110.427  46.027  1.00 81.93           C  
ATOM   1179  C   LEU   154      93.848 111.409  45.398  1.00 83.02           C  
ATOM   1180  O   LEU   154      93.465 112.300  44.639  1.00 83.08           O  
ATOM   1181  CB  LEU   154      92.225 111.044  47.288  1.00 81.24           C  
ATOM   1182  CG  LEU   154      91.005 110.341  47.899  1.00 79.35           C  
ATOM   1183  CD1 LEU   154      90.423 111.199  49.010  1.00 76.84           C  
ATOM   1184  CD2 LEU   154      89.957 110.092  46.833  1.00 78.09           C  
ATOM   1185  N   ASN   155      95.129 111.239  45.700  1.00 84.48           N  
ATOM   1186  CA  ASN   155      96.142 112.132  45.157  1.00 85.67           C  
ATOM   1187  C   ASN   155      96.621 111.689  43.787  1.00 86.38           C  
ATOM   1188  O   ASN   155      97.555 112.265  43.236  1.00 87.30           O  
ATOM   1189  CB  ASN   155      97.325 112.227  46.121  1.00 85.40           C  
ATOM   1190  CG  ASN   155      96.916 112.754  47.478  1.00 86.53           C  
ATOM   1191  OD1 ASN   155      96.189 113.743  47.572  1.00 89.43           O  
ATOM   1192  ND2 ASN   155      97.381 112.102  48.538  1.00 88.56           N  
ATOM   1193  N   LYS   156      95.978 110.669  43.234  1.00 86.65           N  
ATOM   1194  CA  LYS   156      96.355 110.163  41.924  1.00 87.07           C  
ATOM   1195  C   LYS   156      95.167 110.174  40.964  1.00 88.18           C  
ATOM   1196  O   LYS   156      95.101 109.362  40.039  1.00 88.52           O  
ATOM   1197  CB  LYS   156      96.917 108.754  42.049  1.00 86.22           C  
ATOM   1198  N   ILE   157      94.216 111.076  41.192  1.00 89.25           N  
ATOM   1199  CA  ILE   157      93.061 111.177  40.306  1.00 90.64           C  
ATOM   1200  C   ILE   157      92.924 112.613  39.819  1.00 91.38           C  
ATOM   1201  O   ILE   157      93.121 113.564  40.587  1.00 91.57           O  
ATOM   1202  CB  ILE   157      91.731 110.739  40.989  1.00 90.77           C  
ATOM   1203  CG1 ILE   157      91.471 111.576  42.236  1.00 91.50           C  
ATOM   1204  CG2 ILE   157      91.781 109.258  41.332  1.00 90.73           C  
ATOM   1205  CD1 ILE   157      90.091 111.361  42.823  1.00 92.69           C  
ATOM   1206  N   LYS   158      92.593 112.748  38.535  1.00 91.96           N  
ATOM   1207  CA  LYS   158      92.438 114.037  37.862  1.00 92.43           C  
ATOM   1208  C   LYS   158      91.547 115.037  38.592  1.00 92.49           C  
ATOM   1209  O   LYS   158      90.382 114.753  38.871  1.00 92.57           O  
ATOM   1210  CB  LYS   158      91.908 113.810  36.451  1.00 92.67           C  
ATOM   1211  N   ILE   159      92.100 116.215  38.877  1.00 92.42           N  
ATOM   1212  CA  ILE   159      91.364 117.269  39.573  1.00 93.01           C  
ATOM   1213  C   ILE   159      90.042 117.573  38.853  1.00 93.01           C  
ATOM   1214  O   ILE   159      89.114 118.143  39.440  1.00 93.13           O  
ATOM   1215  CB  ILE   159      92.188 118.581  39.649  1.00 93.16           C  
ATOM   1216  CG1 ILE   159      93.679 118.262  39.744  1.00 93.98           C  
ATOM   1217  CG2 ILE   159      91.762 119.392  40.874  1.00 92.59           C  
ATOM   1218  CD1 ILE   159      94.577 119.483  39.653  1.00 94.92           C  
ATOM   1219  N   GLU   160      89.963 117.196  37.579  1.00 92.43           N  
ATOM   1220  CA  GLU   160      88.762 117.430  36.794  1.00 91.90           C  
ATOM   1221  C   GLU   160      87.733 116.371  37.149  1.00 91.72           C  
ATOM   1222  O   GLU   160      86.686 116.271  36.510  1.00 91.47           O  
ATOM   1223  CB  GLU   160      89.089 117.375  35.303  1.00 91.77           C  
ATOM   1224  N   GLU   161      88.037 115.586  38.180  1.00 91.67           N  
ATOM   1225  CA  GLU   161      87.147 114.517  38.625  1.00 91.68           C  
ATOM   1226  C   GLU   161      86.845 114.537  40.126  1.00 90.79           C  
ATOM   1227  O   GLU   161      85.991 113.785  40.602  1.00 90.51           O  
ATOM   1228  CB  GLU   161      87.730 113.160  38.217  1.00 92.12           C  
ATOM   1229  CG  GLU   161      87.775 112.968  36.707  1.00 93.63           C  
ATOM   1230  CD  GLU   161      88.567 111.747  36.282  1.00 96.44           C  
ATOM   1231  OE1 GLU   161      89.811 111.760  36.419  1.00 95.88           O  
ATOM   1232  OE2 GLU   161      87.940 110.775  35.811  1.00 98.07           O  
ATOM   1233  N   LEU   162      87.548 115.385  40.871  1.00 89.70           N  
ATOM   1234  CA  LEU   162      87.294 115.503  42.300  1.00 89.10           C  
ATOM   1235  C   LEU   162      86.207 116.551  42.486  1.00 88.72           C  
ATOM   1236  O   LEU   162      85.885 117.288  41.560  1.00 89.15           O  
ATOM   1237  CB  LEU   162      88.553 115.929  43.061  1.00 89.13           C  
ATOM   1238  CG  LEU   162      89.606 114.852  43.310  1.00 89.45           C  
ATOM   1239  CD1 LEU   162      90.307 114.543  42.011  1.00 91.38           C  
ATOM   1240  CD2 LEU   162      90.605 115.324  44.347  1.00 88.04           C  
ATOM   1241  N   CYS   163      85.637 116.614  43.681  1.00 88.09           N  
ATOM   1242  CA  CYS   163      84.587 117.580  43.968  1.00 87.74           C  
ATOM   1243  C   CYS   163      84.738 118.035  45.410  1.00 86.55           C  
ATOM   1244  O   CYS   163      84.544 117.260  46.342  1.00 87.43           O  
ATOM   1245  CB  CYS   163      83.212 116.942  43.719  1.00 87.82           C  
ATOM   1246  SG  CYS   163      82.989 116.485  41.964  1.00 91.64           S  
ATOM   1247  N   PHE   164      85.096 119.298  45.590  1.00 84.52           N  
ATOM   1248  CA  PHE   164      85.305 119.839  46.919  1.00 83.15           C  
ATOM   1249  C   PHE   164      84.154 120.712  47.388  1.00 83.06           C  
ATOM   1250  O   PHE   164      83.250 121.019  46.622  1.00 83.89           O  
ATOM   1251  CB  PHE   164      86.589 120.658  46.921  1.00 82.45           C  
ATOM   1252  CG  PHE   164      87.750 119.951  46.296  1.00 82.05           C  
ATOM   1253  CD1 PHE   164      88.496 119.028  47.023  1.00 82.19           C  
ATOM   1254  CD2 PHE   164      88.092 120.191  44.975  1.00 81.98           C  
ATOM   1255  CE1 PHE   164      89.567 118.349  46.436  1.00 80.81           C  
ATOM   1256  CE2 PHE   164      89.158 119.517  44.382  1.00 82.43           C  
ATOM   1257  CZ  PHE   164      89.899 118.596  45.116  1.00 80.76           C  
ATOM   1258  N   ILE   165      84.194 121.082  48.665  1.00 82.73           N  
ATOM   1259  CA  ILE   165      83.211 121.965  49.289  1.00 82.62           C  
ATOM   1260  C   ILE   165      83.750 122.403  50.634  1.00 82.13           C  
ATOM   1261  O   ILE   165      84.364 121.619  51.355  1.00 82.40           O  
ATOM   1262  CB  ILE   165      81.819 121.317  49.546  1.00 82.92           C  
ATOM   1263  CG1 ILE   165      81.972 119.925  50.151  1.00 84.16           C  
ATOM   1264  CG2 ILE   165      81.006 121.307  48.272  1.00 84.02           C  
ATOM   1265  CD1 ILE   165      82.258 118.853  49.132  1.00 85.27           C  
ATOM   1266  N   GLU   166      83.519 123.664  50.965  1.00 81.04           N  
ATOM   1267  CA  GLU   166      83.980 124.201  52.224  1.00 80.04           C  
ATOM   1268  C   GLU   166      83.012 123.838  53.317  1.00 78.84           C  
ATOM   1269  O   GLU   166      81.819 124.131  53.224  1.00 79.05           O  
ATOM   1270  CB  GLU   166      84.098 125.715  52.143  1.00 80.39           C  
ATOM   1271  CG  GLU   166      85.356 126.183  51.475  1.00 81.73           C  
ATOM   1272  CD  GLU   166      86.570 126.002  52.358  1.00 84.18           C  
ATOM   1273  OE1 GLU   166      86.607 126.634  53.445  1.00 81.27           O  
ATOM   1274  OE2 GLU   166      87.480 125.233  51.962  1.00 87.18           O  
ATOM   1275  N   CYS   167      83.534 123.188  54.350  1.00 77.43           N  
ATOM   1276  CA  CYS   167      82.735 122.793  55.498  1.00 75.91           C  
ATOM   1277  C   CYS   167      83.425 123.449  56.682  1.00 75.37           C  
ATOM   1278  O   CYS   167      84.381 124.194  56.486  1.00 75.36           O  
ATOM   1279  CB  CYS   167      82.721 121.273  55.624  1.00 75.12           C  
ATOM   1280  SG  CYS   167      82.137 120.444  54.115  1.00 74.97           S  
ATOM   1281  N   SER   168      82.950 123.196  57.896  1.00 74.67           N  
ATOM   1282  CA  SER   168      83.546 123.796  59.087  1.00 74.46           C  
ATOM   1283  C   SER   168      84.979 123.341  59.315  1.00 74.78           C  
ATOM   1284  O   SER   168      85.503 122.490  58.590  1.00 74.75           O  
ATOM   1285  CB  SER   168      82.711 123.466  60.324  1.00 74.60           C  
ATOM   1286  OG  SER   168      82.611 122.068  60.524  1.00 75.49           O  
ATOM   1287  N   GLU   169      85.621 123.909  60.328  1.00 74.91           N  
ATOM   1288  CA  GLU   169      86.993 123.531  60.624  1.00 75.60           C  
ATOM   1289  C   GLU   169      87.033 122.111  61.208  1.00 75.03           C  
ATOM   1290  O   GLU   169      88.088 121.463  61.235  1.00 74.81           O  
ATOM   1291  CB  GLU   169      87.621 124.531  61.599  1.00 75.85           C  
ATOM   1292  CG  GLU   169      86.996 124.527  62.974  1.00 78.98           C  
ATOM   1293  CD  GLU   169      87.788 125.349  63.971  1.00 84.36           C  
ATOM   1294  OE1 GLU   169      89.031 125.397  63.838  1.00 85.45           O  
ATOM   1295  OE2 GLU   169      87.173 125.926  64.895  1.00 86.32           O  
ATOM   1296  N   GLY   170      85.872 121.634  61.661  1.00 74.49           N  
ATOM   1297  CA  GLY   170      85.775 120.301  62.230  1.00 73.18           C  
ATOM   1298  C   GLY   170      86.207 119.243  61.235  1.00 72.55           C  
ATOM   1299  O   GLY   170      86.525 118.121  61.612  1.00 73.48           O  
ATOM   1300  N   VAL   171      86.216 119.606  59.961  1.00 71.29           N  
ATOM   1301  CA  VAL   171      86.618 118.706  58.894  1.00 70.37           C  
ATOM   1302  C   VAL   171      88.126 118.515  58.897  1.00 69.66           C  
ATOM   1303  O   VAL   171      88.662 117.689  58.156  1.00 68.11           O  
ATOM   1304  CB  VAL   171      86.207 119.282  57.534  1.00 71.15           C  
ATOM   1305  CG1 VAL   171      86.843 118.491  56.404  1.00 72.17           C  
ATOM   1306  CG2 VAL   171      84.702 119.258  57.411  1.00 71.59           C  
ATOM   1307  N   LEU   172      88.808 119.284  59.740  1.00 70.43           N  
ATOM   1308  CA  LEU   172      90.262 119.220  59.819  1.00 71.06           C  
ATOM   1309  C   LEU   172      90.784 118.808  61.188  1.00 71.89           C  
ATOM   1310  O   LEU   172      91.947 118.422  61.330  1.00 72.18           O  
ATOM   1311  CB  LEU   172      90.859 120.579  59.460  1.00 70.49           C  
ATOM   1312  CG  LEU   172      90.604 121.171  58.072  1.00 71.03           C  
ATOM   1313  CD1 LEU   172      91.313 122.497  57.991  1.00 69.40           C  
ATOM   1314  CD2 LEU   172      91.105 120.243  56.971  1.00 72.40           C  
ATOM   1315  N   ILE   173      89.920 118.877  62.191  1.00 72.89           N  
ATOM   1316  CA  ILE   173      90.302 118.553  63.556  1.00 74.89           C  
ATOM   1317  C   ILE   173      89.966 117.147  64.029  1.00 75.88           C  
ATOM   1318  O   ILE   173      88.888 116.631  63.764  1.00 77.01           O  
ATOM   1319  CB  ILE   173      89.634 119.534  64.529  1.00 74.91           C  
ATOM   1320  CG1 ILE   173      89.966 120.971  64.114  1.00 75.25           C  
ATOM   1321  CG2 ILE   173      90.062 119.233  65.966  1.00 75.63           C  
ATOM   1322  CD1 ILE   173      89.124 122.017  64.825  1.00 77.55           C  
ATOM   1323  N   ASP   174      90.900 116.536  64.742  1.00 77.31           N  
ATOM   1324  CA  ASP   174      90.693 115.212  65.312  1.00 78.94           C  
ATOM   1325  C   ASP   174      91.163 115.357  66.754  1.00 79.67           C  
ATOM   1326  O   ASP   174      91.927 116.269  67.053  1.00 79.46           O  
ATOM   1327  CB  ASP   174      91.515 114.159  64.575  1.00 79.22           C  
ATOM   1328  CG  ASP   174      92.986 114.352  64.757  1.00 80.14           C  
ATOM   1329  OD1 ASP   174      93.473 114.155  65.890  1.00 84.16           O  
ATOM   1330  OD2 ASP   174      93.654 114.714  63.769  1.00 82.30           O  
ATOM   1331  N   ILE   175      90.709 114.474  67.640  1.00 80.72           N  
ATOM   1332  CA  ILE   175      91.065 114.561  69.055  1.00 81.80           C  
ATOM   1333  C   ILE   175      92.454 115.112  69.310  1.00 83.81           C  
ATOM   1334  O   ILE   175      92.608 116.069  70.067  1.00 84.37           O  
ATOM   1335  CB  ILE   175      90.933 113.211  69.766  1.00 81.18           C  
ATOM   1336  CG1 ILE   175      89.501 112.710  69.642  1.00 80.88           C  
ATOM   1337  CG2 ILE   175      91.239 113.373  71.235  1.00 78.89           C  
ATOM   1338  CD1 ILE   175      88.482 113.718  70.110  1.00 80.65           C  
ATOM   1339  N   ASP   176      93.462 114.527  68.675  1.00 85.66           N  
ATOM   1340  CA  ASP   176      94.826 115.003  68.853  1.00 87.67           C  
ATOM   1341  C   ASP   176      94.997 116.454  68.411  1.00 88.57           C  
ATOM   1342  O   ASP   176      95.491 117.284  69.176  1.00 88.51           O  
ATOM   1343  CB  ASP   176      95.794 114.119  68.078  1.00 88.25           C  
ATOM   1344  CG  ASP   176      95.807 112.694  68.588  1.00 91.14           C  
ATOM   1345  OD1 ASP   176      96.135 112.497  69.785  1.00 94.37           O  
ATOM   1346  OD2 ASP   176      95.487 111.777  67.793  1.00 93.54           O  
ATOM   1347  N   LYS   177      94.579 116.758  67.182  1.00 89.58           N  
ATOM   1348  CA  LYS   177      94.696 118.112  66.627  1.00 90.14           C  
ATOM   1349  C   LYS   177      94.159 119.185  67.567  1.00 90.65           C  
ATOM   1350  O   LYS   177      94.568 120.342  67.494  1.00 91.35           O  
ATOM   1351  CB  LYS   177      93.983 118.193  65.279  1.00 89.55           C  
ATOM   1352  N   LYS   178      93.238 118.801  68.444  1.00 90.82           N  
ATOM   1353  CA  LYS   178      92.670 119.738  69.400  1.00 91.07           C  
ATOM   1354  C   LYS   178      93.395 119.565  70.731  1.00 91.59           C  
ATOM   1355  O   LYS   178      92.770 119.099  71.711  1.00 92.20           O  
ATOM   1356  CB  LYS   178      91.170 119.489  69.564  1.00 90.86           C  
END
