
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  213 ( 1624),  selected  213 , name 1inj_A
# Molecule2: number of CA atoms  178 ( 1356),  selected  178 , name T0420.pdb
# PARAMETERS: 1inj_A.T0420.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H     5_A      -       -           -
LGA    L     6_A      M       1          0.805
LGA    D     7_A      N       2          2.586
LGA    V     8_A      I       3          1.417
LGA    C     9_A      G       4          0.772
LGA    A    10_A      V       5          0.279
LGA    V    11_A      I       6          0.418
LGA    V    12_A      I       7          1.248
LGA    P    13_A      L       8          1.194
LGA    A    14_A      A       9          0.698
LGA    A    15_A      A      10          0.745
LGA    -       -      G      11           -
LGA    -       -      E      12           -
LGA    -       -      G      13           -
LGA    -       -      K      14           -
LGA    -       -      R      15           -
LGA    -       -      F      16           -
LGA    -       -      G      17           -
LGA    -       -      G      18           -
LGA    -       -      D      19           -
LGA    K    27_A      K      20          2.726
LGA    Q    28_A      L      21          2.069
LGA    Y    29_A      L      22          1.928
LGA    L    30_A      A      23          1.333
LGA    S    31_A      K      24          0.868
LGA    I    32_A      I      25          1.064
LGA    G    33_A      D      26          2.229
LGA    N    34_A      N      27          2.552
LGA    Q    35_A      T      28          1.577
LGA    T    36_A      P      29          1.121
LGA    I    37_A      I      30          1.017
LGA    L    38_A      I      31          0.952
LGA    E    39_A      M      32          1.085
LGA    H    40_A      R      33          1.000
LGA    S    41_A      T      34          0.826
LGA    V    42_A      I      35          0.887
LGA    H    43_A      R      36          0.857
LGA    A    44_A      I      37          0.308
LGA    L    45_A      Y      38          0.881
LGA    L    46_A      G      39          1.653
LGA    A    47_A      D      40          5.123
LGA    H    48_A      -       -           -
LGA    P    49_A      -       -           -
LGA    R    50_A      -       -           -
LGA    V    51_A      -       -           -
LGA    K    52_A      L      41          3.593
LGA    R    53_A      E      42          1.349
LGA    V    54_A      K      43          0.789
LGA    V    55_A      I      44          1.139
LGA    I    56_A      I      45          0.887
LGA    A    57_A      I      46          0.804
LGA    I    58_A      V      47          0.714
LGA    S    59_A      G      48          0.640
LGA    P    60_A      K      49          5.509
LGA    G    61_A      Y      50          5.133
LGA    D    62_A      V      51          1.867
LGA    S    63_A      N      52          0.450
LGA    R    64_A      E      53          1.476
LGA    F    65_A      M      54          1.786
LGA    A    66_A      L      55          1.523
LGA    Q    67_A      P      56          0.828
LGA    L    68_A      L      57          0.573
LGA    P    69_A      -       -           -
LGA    L    70_A      L      58          2.576
LGA    A    71_A      M      59          2.195
LGA    N    72_A      D      60          1.942
LGA    H    73_A      Q      61          3.574
LGA    P    74_A      -       -           -
LGA    Q    75_A      -       -           -
LGA    I    76_A      -       -           -
LGA    T    77_A      I      62          1.695
LGA    V    78_A      V      63          1.078
LGA    V    79_A      I      64          1.055
LGA    D    80_A      Y      65          2.257
LGA    G    81_A      N      66          3.042
LGA    -       -      P      67           -
LGA    -       -      F      68           -
LGA    G    82_A      W      69          2.095
LGA    D    83_A      N      70          2.956
LGA    -       -      E      71           -
LGA    E    84_A      G      72          1.493
LGA    R    85_A      I      73          1.765
LGA    A    86_A      S      74          1.897
LGA    D    87_A      T      75          1.661
LGA    S    88_A      S      76          1.043
LGA    V    89_A      L      77          0.946
LGA    L    90_A      K      78          0.884
LGA    A    91_A      L      79          0.834
LGA    G    92_A      G      80          0.909
LGA    L    93_A      L      81          0.781
LGA    K    94_A      R      82          1.396
LGA    A    95_A      F      83          1.909
LGA    A    96_A      F      84          2.330
LGA    G    97_A      K      85           #
LGA    D    98_A      D      86          3.575
LGA    A    99_A      Y      87          2.148
LGA    Q   100_A      D      88          1.634
LGA    W   101_A      A      89          1.291
LGA    V   102_A      V      90          0.494
LGA    L   103_A      L      91          0.309
LGA    V   104_A      V      92          0.494
LGA    H   105_A      A      93          0.841
LGA    D   106_A      L      94          1.094
LGA    A   107_A      G      95          0.608
LGA    A   108_A      D      96          0.957
LGA    R   109_A      M      97          1.032
LGA    P   110_A      P      98          0.790
LGA    C   111_A      F      99          1.332
LGA    L   112_A      V     100          1.474
LGA    H   113_A      T     101          1.593
LGA    Q   114_A      K     102          2.288
LGA    D   115_A      E     103          2.217
LGA    D   116_A      D     104          1.774
LGA    L   117_A      V     105          1.262
LGA    A   118_A      N     106          1.269
LGA    R   119_A      K     107          1.364
LGA    L   120_A      I     108          0.643
LGA    L   121_A      I     109          0.433
LGA    A   122_A      N     110          1.556
LGA    L   123_A      T     111          2.848
LGA    S   124_A      F     112          2.768
LGA    E   125_A      K     113          3.007
LGA    T   126_A      P     114          4.886
LGA    S   127_A      N     115          3.113
LGA    R   128_A      C     116          3.341
LGA    T   129_A      K     117          0.453
LGA    G   130_A      A     118          1.837
LGA    G   131_A      V     119          1.304
LGA    I   132_A      I     120          1.206
LGA    L   133_A      P     121          0.901
LGA    A   134_A      T     122          1.569
LGA    A   135_A      H     123          1.336
LGA    P   136_A      K     124          1.932
LGA    V   137_A      G     125          3.765
LGA    R   138_A      -       -           -
LGA    D   139_A      -       -           -
LGA    T   140_A      -       -           -
LGA    M   141_A      -       -           -
LGA    K   142_A      -       -           -
LGA    R   143_A      -       -           -
LGA    A   144_A      -       -           -
LGA    E   145_A      -       -           -
LGA    P   146_A      -       -           -
LGA    G   147_A      -       -           -
LGA    K   148_A      -       -           -
LGA    N   149_A      -       -           -
LGA    A   150_A      -       -           -
LGA    I   151_A      -       -           -
LGA    A   152_A      -       -           -
LGA    H   153_A      -       -           -
LGA    T   154_A      -       -           -
LGA    V   155_A      -       -           -
LGA    D   156_A      -       -           -
LGA    R   157_A      -       -           -
LGA    N   158_A      -       -           -
LGA    G   159_A      -       -           -
LGA    L   160_A      -       -           -
LGA    W   161_A      -       -           -
LGA    H   162_A      E     126          2.174
LGA    A   163_A      R     127          2.425
LGA    L   164_A      G     128          1.194
LGA    T   165_A      N     129          0.881
LGA    P   166_A      P     130          1.009
LGA    Q   167_A      V     131          0.402
LGA    F   168_A      L     132          0.420
LGA    F   169_A      I     133          1.529
LGA    P   170_A      S     134          1.323
LGA    R   171_A      K     135          3.528
LGA    E   172_A      -       -           -
LGA    L   173_A      S     136          3.045
LGA    L   174_A      L     137          3.473
LGA    H   175_A      F     138          2.630
LGA    D   176_A      N     139          1.446
LGA    C   177_A      E     140          1.356
LGA    L   178_A      I     141          1.898
LGA    T   179_A      E     142          2.422
LGA    R   180_A      K     143          2.512
LGA    A   181_A      L     144          4.070
LGA    L   182_A      R     145          2.985
LGA    N   183_A      G     146           #
LGA    E   184_A      D     147           -
LGA    G   185_A      -       -           -
LGA    A   186_A      -       -           -
LGA    T   187_A      -       -           -
LGA    I   188_A      V     148          4.030
LGA    T   189_A      G     149          4.763
LGA    D   190_A      -       -           -
LGA    E   191_A      A     150          2.255
LGA    A   192_A      R     151          3.689
LGA    S   193_A      V     152          2.672
LGA    A   194_A      I     153          1.472
LGA    L   195_A      L     154          3.399
LGA    E   196_A      N     155          3.055
LGA    Y   197_A      K     156          3.381
LGA    C   198_A      -       -           -
LGA    G   199_A      I     157          3.568
LGA    F   200_A      K     158          4.445
LGA    H   201_A      I     159          3.852
LGA    -       -      E     160           -
LGA    -       -      E     161           -
LGA    P   202_A      L     162          2.434
LGA    Q   203_A      C     163          1.989
LGA    L   204_A      F     164          2.012
LGA    V   205_A      I     165          1.561
LGA    E   206_A      E     166          1.332
LGA    G   207_A      C     167          1.412
LGA    R   208_A      S     168          1.221
LGA    A   209_A      E     169          1.493
LGA    D   210_A      G     170          3.672
LGA    N   211_A      V     171          3.671
LGA    -       -      L     172           -
LGA    I   212_A      I     173          1.311
LGA    K   213_A      D     174          0.479
LGA    V   214_A      I     175          0.510
LGA    T   215_A      D     176          1.662
LGA    R   216_A      K     177          5.955
LGA    P   217_A      -       -           -
LGA    E   218_A      -       -           -
LGA    D   219_A      K     178          2.425
LGA    L   220_A      -       -           -
LGA    A   221_A      -       -           -
LGA    L   222_A      -       -           -
LGA    A   223_A      -       -           -
LGA    E   224_A      -       -           -
LGA    F   225_A      -       -           -
LGA    Y   226_A      -       -           -
LGA    L   227_A      -       -           -
LGA    T   228_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  213  178    5.0    160    2.18    15.62     70.088     7.005

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.663980 * X  +  -0.535630 * Y  +   0.521758 * Z  +  35.507160
  Y_new =   0.686227 * X  +   0.159320 * Y  +  -0.709725 * Z  +  96.806313
  Z_new =   0.297024 * X  +   0.829287 * Y  +   0.473349 * Z  +  45.430901 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.052131   -2.089461  [ DEG:    60.2827   -119.7173 ]
  Theta =  -0.301574   -2.840018  [ DEG:   -17.2789   -162.7211 ]
  Phi   =   0.801874   -2.339719  [ DEG:    45.9440   -134.0560 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1inj_A                                        
REMARK     2: T0420.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1inj_A.T0420.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  213  178   5.0  160   2.18   15.62  70.088
REMARK  ---------------------------------------------------------- 
MOLECULE 1inj_A
HEADER    TRANSFERASE                             14-MAY-01   1INJ              
TITLE     CRYSTAL STRUCTURE OF THE APO FORM OF 4-DIPHOSPHOCYTIDYL-2-C-          
TITLE    2 METHYLERYTHRITOL (CDP-ME) SYNTHETASE (YGBP) INVOLVED IN              
TITLE    3 MEVALONATE INDEPENDENT ISOPRENOID BIOSYNTHESIS                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: 4-DIPHOSPHOCYTIDYL-2-C-METHYLERYTHRITOL                    
COMPND   3 SYNTHETASE;                                                          
COMPND   4 CHAIN: A;                                                            
COMPND   5 EC: 2.7.7.-;                                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: K12;                                                         
SOURCE   5 GENE: ISPD;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PHIS8                                     
KEYWDS    YGBP, CYTIDYLYLTRANSFERASE, DEOXYXYLULOSE-5-PHOSPHATE                 
KEYWDS   2 PATHWAY (DXP), ISOPRENOID BIOSYNTHESIS, APO FORM                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.B.RICHARD,M.E.BOWMAN,W.KWIATKOWSKI,I.KANG,C.CHOW,A.LILLO,           
AUTHOR   2 D.E.CANE,J.P.NOEL                                                    
REVDAT   2   01-APR-03 1INJ    1       JRNL                                     
REVDAT   1   11-JUL-01 1INJ    0                                                
JRNL        AUTH   S.B.RICHARD,M.E.BOWMAN,W.KWIATKOWSKI,I.KANG,C.CHOW,          
JRNL        AUTH 2 A.M.LILLO,D.E.CANE,J.P.NOEL                                  
JRNL        TITL   STRUCTURE OF 4-DIPHOSPHOCYTIDYL-2-C-                         
JRNL        TITL 2 METHYLERYTHRITOL SYNTHETASE INVOLVED IN                      
JRNL        TITL 3 MEVALONATE- INDEPENDENT ISOPRENOID BIOSYNTHESIS.             
JRNL        REF    NAT.STRUCT.BIOL.              V.   8   641 2001              
JRNL        REFN   ASTM NSBIEW  US ISSN 1072-8368                               
REMARK   2 RESOLUTION. 1.55 ANGSTROMS.                                          
DBREF  1INJ A    1   236  UNP    Q46893   ISPD_ECOLI       1    236             
SEQRES   1 A  236  MET ALA THR THR HIS LEU ASP VAL CYS ALA VAL VAL PRO          
SEQRES   2 A  236  ALA ALA GLY PHE GLY ARG ARG MET GLN THR GLU CYS PRO          
SEQRES   3 A  236  LYS GLN TYR LEU SER ILE GLY ASN GLN THR ILE LEU GLU          
SEQRES   4 A  236  HIS SER VAL HIS ALA LEU LEU ALA HIS PRO ARG VAL LYS          
SEQRES   5 A  236  ARG VAL VAL ILE ALA ILE SER PRO GLY ASP SER ARG PHE          
SEQRES   6 A  236  ALA GLN LEU PRO LEU ALA ASN HIS PRO GLN ILE THR VAL          
SEQRES   7 A  236  VAL ASP GLY GLY ASP GLU ARG ALA ASP SER VAL LEU ALA          
SEQRES   8 A  236  GLY LEU LYS ALA ALA GLY ASP ALA GLN TRP VAL LEU VAL          
SEQRES   9 A  236  HIS ASP ALA ALA ARG PRO CYS LEU HIS GLN ASP ASP LEU          
SEQRES  10 A  236  ALA ARG LEU LEU ALA LEU SER GLU THR SER ARG THR GLY          
SEQRES  11 A  236  GLY ILE LEU ALA ALA PRO VAL ARG ASP THR MET LYS ARG          
SEQRES  12 A  236  ALA GLU PRO GLY LYS ASN ALA ILE ALA HIS THR VAL ASP          
SEQRES  13 A  236  ARG ASN GLY LEU TRP HIS ALA LEU THR PRO GLN PHE PHE          
SEQRES  14 A  236  PRO ARG GLU LEU LEU HIS ASP CYS LEU THR ARG ALA LEU          
SEQRES  15 A  236  ASN GLU GLY ALA THR ILE THR ASP GLU ALA SER ALA LEU          
SEQRES  16 A  236  GLU TYR CYS GLY PHE HIS PRO GLN LEU VAL GLU GLY ARG          
SEQRES  17 A  236  ALA ASP ASN ILE LYS VAL THR ARG PRO GLU ASP LEU ALA          
SEQRES  18 A  236  LEU ALA GLU PHE TYR LEU THR ARG THR ILE HIS GLN GLU          
SEQRES  19 A  236  ASN THR                                                      
HET     CA   1001       1                                                       
HETNAM      CA CALCIUM ION                                                      
FORMUL   2   CA    CA 2+                                                        
FORMUL   3  HOH   *370(H2 O)                                                    
CRYST1  130.297   47.328   38.146  90.00  94.18  90.00 C 1 2 1       4          
ATOM      1  N   HIS A   5      69.394 104.889  44.592  1.00 38.00           N  
ATOM      2  CA  HIS A   5      70.558 105.782  44.333  1.00 37.26           C  
ATOM      3  C   HIS A   5      71.053 106.563  45.554  1.00 35.46           C  
ATOM      4  O   HIS A   5      72.227 106.499  45.904  1.00 36.15           O  
ATOM      5  CB  HIS A   5      70.214 106.780  43.221  1.00 39.81           C  
ATOM      6  CG  HIS A   5      71.145 107.948  43.163  1.00 41.92           C  
ATOM      7  ND1 HIS A   5      72.505 107.807  43.002  1.00 43.42           N  
ATOM      8  CD2 HIS A   5      70.920 109.279  43.294  1.00 42.13           C  
ATOM      9  CE1 HIS A   5      73.081 108.995  43.038  1.00 42.94           C  
ATOM     10  NE2 HIS A   5      72.139 109.905  43.215  1.00 42.73           N  
ATOM     11  N   LEU A   6      70.150 107.304  46.189  1.00 33.17           N  
ATOM     12  CA  LEU A   6      70.482 108.138  47.339  1.00 30.30           C  
ATOM     13  C   LEU A   6      70.927 107.434  48.628  1.00 27.17           C  
ATOM     14  O   LEU A   6      71.327 108.103  49.578  1.00 23.34           O  
ATOM     15  CB  LEU A   6      69.297 109.065  47.653  1.00 31.68           C  
ATOM     16  CG  LEU A   6      68.838 110.031  46.553  1.00 33.44           C  
ATOM     17  CD1 LEU A   6      67.597 110.781  47.015  1.00 33.32           C  
ATOM     18  CD2 LEU A   6      69.953 111.011  46.215  1.00 33.94           C  
ATOM     19  N   ASP A   7      70.858 106.106  48.676  1.00 24.85           N  
ATOM     20  CA  ASP A   7      71.261 105.369  49.876  1.00 23.68           C  
ATOM     21  C   ASP A   7      72.778 105.425  50.090  1.00 20.08           C  
ATOM     22  O   ASP A   7      73.553 105.142  49.175  1.00 22.56           O  
ATOM     23  CB  ASP A   7      70.809 103.909  49.770  1.00 27.06           C  
ATOM     24  CG  ASP A   7      69.325 103.733  50.050  1.00 29.70           C  
ATOM     25  OD1 ASP A   7      68.574 104.725  49.970  1.00 29.25           O  
ATOM     26  OD2 ASP A   7      68.911 102.596  50.345  1.00 32.74           O  
ATOM     27  N   VAL A   8      73.198 105.774  51.303  1.00 15.78           N  
ATOM     28  CA  VAL A   8      74.627 105.880  51.610  1.00 12.94           C  
ATOM     29  C   VAL A   8      75.008 105.065  52.829  1.00 12.37           C  
ATOM     30  O   VAL A   8      74.263 105.041  53.808  1.00 13.26           O  
ATOM     31  CB  VAL A   8      75.018 107.349  51.917  1.00 12.73           C  
ATOM     32  CG1 VAL A   8      76.476 107.423  52.384  1.00 13.89           C  
ATOM     33  CG2 VAL A   8      74.813 108.211  50.689  1.00 11.74           C  
ATOM     34  N   CYS A   9      76.163 104.400  52.767  1.00 11.10           N  
ATOM     35  CA  CYS A   9      76.655 103.635  53.910  1.00 13.23           C  
ATOM     36  C   CYS A   9      77.909 104.347  54.388  1.00 11.56           C  
ATOM     37  O   CYS A   9      78.754 104.725  53.574  1.00 13.81           O  
ATOM     38  CB  CYS A   9      77.006 102.195  53.529  1.00 12.97           C  
ATOM     39  SG  CYS A   9      77.568 101.172  54.934  1.00 18.06           S  
ATOM     40  N   ALA A  10      78.030 104.533  55.697  1.00 10.97           N  
ATOM     41  CA  ALA A  10      79.200 105.210  56.252  1.00  9.25           C  
ATOM     42  C   ALA A  10      80.125 104.163  56.857  1.00 10.49           C  
ATOM     43  O   ALA A  10      79.674 103.107  57.307  1.00 11.80           O  
ATOM     44  CB  ALA A  10      78.771 106.239  57.314  1.00 12.71           C  
ATOM     45  N   VAL A  11      81.424 104.441  56.818  1.00 12.19           N  
ATOM     46  CA  VAL A  11      82.426 103.548  57.376  1.00 11.54           C  
ATOM     47  C   VAL A  11      83.289 104.382  58.304  1.00 10.54           C  
ATOM     48  O   VAL A  11      83.749 105.455  57.933  1.00 11.14           O  
ATOM     49  CB  VAL A  11      83.317 102.929  56.282  1.00  9.67           C  
ATOM     50  CG1 VAL A  11      84.468 102.143  56.919  1.00 13.24           C  
ATOM     51  CG2 VAL A  11      82.468 102.000  55.408  1.00 13.96           C  
ATOM     52  N   VAL A  12      83.492 103.905  59.520  1.00 10.61           N  
ATOM     53  CA  VAL A  12      84.306 104.639  60.463  1.00 11.99           C  
ATOM     54  C   VAL A  12      85.424 103.722  60.936  1.00 14.71           C  
ATOM     55  O   VAL A  12      85.176 102.741  61.634  1.00 14.42           O  
ATOM     56  CB  VAL A  12      83.464 105.105  61.675  1.00 10.04           C  
ATOM     57  CG1 VAL A  12      84.361 105.778  62.702  1.00 11.41           C  
ATOM     58  CG2 VAL A  12      82.379 106.077  61.206  1.00 13.22           C  
ATOM     59  N   PRO A  13      86.665 103.999  60.516  1.00 15.01           N  
ATOM     60  CA  PRO A  13      87.765 103.143  60.964  1.00 18.26           C  
ATOM     61  C   PRO A  13      88.119 103.543  62.396  1.00 18.56           C  
ATOM     62  O   PRO A  13      88.665 104.619  62.628  1.00 23.77           O  
ATOM     63  CB  PRO A  13      88.869 103.443  59.951  1.00 18.35           C  
ATOM     64  CG  PRO A  13      88.611 104.863  59.569  1.00 20.17           C  
ATOM     65  CD  PRO A  13      87.107 104.937  59.469  1.00 15.54           C  
ATOM     66  N   ALA A  14      87.784 102.683  63.354  1.00 22.05           N  
ATOM     67  CA  ALA A  14      88.035 102.969  64.764  1.00 21.48           C  
ATOM     68  C   ALA A  14      88.834 101.862  65.434  1.00 23.61           C  
ATOM     69  O   ALA A  14      88.583 101.517  66.591  1.00 22.32           O  
ATOM     70  CB  ALA A  14      86.710 103.176  65.490  1.00 22.91           C  
ATOM     71  N   ALA A  15      89.795 101.315  64.693  1.00 24.61           N  
ATOM     72  CA  ALA A  15      90.648 100.236  65.180  1.00 28.28           C  
ATOM     73  C   ALA A  15      92.082 100.724  65.361  1.00 30.09           C  
ATOM     74  O   ALA A  15      93.013 100.173  64.769  1.00 33.44           O  
ATOM     75  CB  ALA A  15      90.611  99.072  64.197  1.00 27.88           C  
ATOM     76  N   LYS A  27      91.681 107.762  72.015  1.00 33.30           N  
ATOM     77  CA  LYS A  27      91.125 109.106  71.934  1.00 31.86           C  
ATOM     78  C   LYS A  27      89.635 109.073  71.600  1.00 29.83           C  
ATOM     79  O   LYS A  27      88.851 109.867  72.119  1.00 27.80           O  
ATOM     80  CB  LYS A  27      91.885 109.909  70.878  1.00 33.83           C  
ATOM     81  CG  LYS A  27      92.089 109.143  69.584  1.00 34.73           C  
ATOM     82  CD  LYS A  27      93.259 109.676  68.784  1.00 35.71           C  
ATOM     83  CE  LYS A  27      93.812 108.596  67.864  1.00 36.03           C  
ATOM     84  NZ  LYS A  27      95.062 109.010  67.161  1.00 36.34           N  
ATOM     85  N   GLN A  28      89.249 108.141  70.735  1.00 28.26           N  
ATOM     86  CA  GLN A  28      87.858 107.999  70.329  1.00 27.21           C  
ATOM     87  C   GLN A  28      86.966 107.660  71.516  1.00 25.73           C  
ATOM     88  O   GLN A  28      85.755 107.897  71.490  1.00 22.26           O  
ATOM     89  CB  GLN A  28      87.737 106.897  69.277  1.00 28.74           C  
ATOM     90  CG  GLN A  28      88.245 105.550  69.765  1.00 30.99           C  
ATOM     91  CD  GLN A  28      88.339 104.512  68.671  1.00 31.89           C  
ATOM     92  OE1 GLN A  28      89.012 104.722  67.670  1.00 33.13           O  
ATOM     93  NE2 GLN A  28      87.646 103.388  68.850  1.00 32.06           N  
ATOM     94  N   TYR A  29      87.556 107.103  72.567  1.00 26.20           N  
ATOM     95  CA  TYR A  29      86.770 106.736  73.735  1.00 26.21           C  
ATOM     96  C   TYR A  29      86.763 107.770  74.849  1.00 27.62           C  
ATOM     97  O   TYR A  29      86.133 107.561  75.887  1.00 28.46           O  
ATOM     98  CB  TYR A  29      87.219 105.364  74.248  1.00 26.76           C  
ATOM     99  CG  TYR A  29      86.791 104.241  73.326  1.00 26.76           C  
ATOM    100  CD1 TYR A  29      87.721 103.361  72.781  1.00 26.46           C  
ATOM    101  CD2 TYR A  29      85.450 104.080  72.974  1.00 26.96           C  
ATOM    102  CE1 TYR A  29      87.328 102.353  71.902  1.00 26.38           C  
ATOM    103  CE2 TYR A  29      85.046 103.076  72.098  1.00 25.23           C  
ATOM    104  CZ  TYR A  29      85.992 102.215  71.567  1.00 25.96           C  
ATOM    105  OH  TYR A  29      85.589 101.226  70.701  1.00 24.69           O  
ATOM    106  N   LEU A  30      87.466 108.879  74.640  1.00 29.40           N  
ATOM    107  CA  LEU A  30      87.471 109.962  75.618  1.00 30.52           C  
ATOM    108  C   LEU A  30      86.063 110.535  75.502  1.00 31.20           C  
ATOM    109  O   LEU A  30      85.413 110.368  74.466  1.00 29.85           O  
ATOM    110  CB  LEU A  30      88.508 111.026  75.246  1.00 31.99           C  
ATOM    111  CG  LEU A  30      89.982 110.659  75.440  1.00 32.63           C  
ATOM    112  CD1 LEU A  30      90.869 111.780  74.915  1.00 33.74           C  
ATOM    113  CD2 LEU A  30      90.245 110.415  76.916  1.00 33.88           C  
ATOM    114  N   SER A  31      85.585 111.204  76.545  1.00 30.98           N  
ATOM    115  CA  SER A  31      84.238 111.747  76.496  1.00 31.94           C  
ATOM    116  C   SER A  31      84.124 113.260  76.575  1.00 32.49           C  
ATOM    117  O   SER A  31      84.991 113.946  77.120  1.00 31.78           O  
ATOM    118  CB  SER A  31      83.375 111.115  77.591  1.00 31.60           C  
ATOM    119  OG  SER A  31      83.163 109.740  77.335  1.00 33.33           O  
ATOM    120  N   ILE A  32      83.029 113.764  76.017  1.00 32.83           N  
ATOM    121  CA  ILE A  32      82.737 115.186  75.999  1.00 32.99           C  
ATOM    122  C   ILE A  32      81.243 115.342  76.261  1.00 33.97           C  
ATOM    123  O   ILE A  32      80.434 115.306  75.337  1.00 32.97           O  
ATOM    124  CB  ILE A  32      83.086 115.808  74.628  1.00 34.24           C  
ATOM    125  CG1 ILE A  32      84.571 115.587  74.322  1.00 34.63           C  
ATOM    126  CG2 ILE A  32      82.746 117.297  74.628  1.00 34.38           C  
ATOM    127  CD1 ILE A  32      85.004 116.100  72.964  1.00 35.73           C  
ATOM    128  N   GLY A  33      80.879 115.491  77.530  1.00 35.31           N  
ATOM    129  CA  GLY A  33      79.479 115.651  77.880  1.00 36.41           C  
ATOM    130  C   GLY A  33      78.707 114.359  78.069  1.00 37.99           C  
ATOM    131  O   GLY A  33      77.568 114.241  77.624  1.00 38.81           O  
ATOM    132  N   ASN A  34      79.328 113.392  78.735  1.00 37.87           N  
ATOM    133  CA  ASN A  34      78.703 112.099  79.009  1.00 38.40           C  
ATOM    134  C   ASN A  34      78.527 111.236  77.759  1.00 36.93           C  
ATOM    135  O   ASN A  34      77.925 110.167  77.809  1.00 38.03           O  
ATOM    136  CB  ASN A  34      77.356 112.306  79.727  1.00 38.38           C  
ATOM    137  CG  ASN A  34      76.160 111.896  78.881  1.00 38.51           C  
ATOM    138  OD1 ASN A  34      75.788 112.586  77.930  1.00 40.26           O  
ATOM    139  ND2 ASN A  34      75.552 110.761  79.226  1.00 38.81           N  
ATOM    140  N   GLN A  35      79.061 111.708  76.638  1.00 35.41           N  
ATOM    141  CA  GLN A  35      78.990 110.965  75.385  1.00 32.85           C  
ATOM    142  C   GLN A  35      80.416 110.859  74.851  1.00 28.46           C  
ATOM    143  O   GLN A  35      81.167 111.835  74.892  1.00 26.45           O  
ATOM    144  CB  GLN A  35      78.092 111.696  74.385  1.00 37.15           C  
ATOM    145  CG  GLN A  35      77.783 110.903  73.126  1.00 39.65           C  
ATOM    146  CD  GLN A  35      76.707 111.551  72.270  1.00 41.66           C  
ATOM    147  OE1 GLN A  35      75.583 111.763  72.722  1.00 43.26           O  
ATOM    148  NE2 GLN A  35      77.051 111.870  71.026  1.00 42.30           N  
ATOM    149  N   THR A  36      80.799 109.680  74.368  1.00 24.92           N  
ATOM    150  CA  THR A  36      82.152 109.484  73.855  1.00 21.32           C  
ATOM    151  C   THR A  36      82.349 110.172  72.508  1.00 19.31           C  
ATOM    152  O   THR A  36      81.383 110.436  71.791  1.00 17.75           O  
ATOM    153  CB  THR A  36      82.490 107.979  73.680  1.00 22.99           C  
ATOM    154  OG1 THR A  36      81.743 107.435  72.581  1.00 19.28           O  
ATOM    155  CG2 THR A  36      82.157 107.202  74.955  1.00 23.05           C  
ATOM    156  N   ILE A  37      83.603 110.472  72.182  1.00 18.31           N  
ATOM    157  CA  ILE A  37      83.931 111.123  70.916  1.00 17.74           C  
ATOM    158  C   ILE A  37      83.411 110.279  69.754  1.00 16.92           C  
ATOM    159  O   ILE A  37      82.852 110.806  68.789  1.00 15.19           O  
ATOM    160  CB  ILE A  37      85.455 111.331  70.772  1.00 19.98           C  
ATOM    161  CG1 ILE A  37      85.929 112.382  71.785  1.00 24.30           C  
ATOM    162  CG2 ILE A  37      85.799 111.779  69.359  1.00 21.23           C  
ATOM    163  CD1 ILE A  37      87.421 112.622  71.777  1.00 25.98           C  
ATOM    164  N   LEU A  38      83.575 108.966  69.855  1.00 16.13           N  
ATOM    165  CA  LEU A  38      83.093 108.069  68.811  1.00 14.53           C  
ATOM    166  C   LEU A  38      81.594 108.273  68.607  1.00 15.69           C  
ATOM    167  O   LEU A  38      81.128 108.355  67.473  1.00 14.56           O  
ATOM    168  CB  LEU A  38      83.374 106.606  69.184  1.00 16.30           C  
ATOM    169  CG  LEU A  38      82.834 105.537  68.219  1.00 18.07           C  
ATOM    170  CD1 LEU A  38      83.362 105.762  66.805  1.00 16.77           C  
ATOM    171  CD2 LEU A  38      83.241 104.163  68.720  1.00 19.42           C  
ATOM    172  N   GLU A  39      80.839 108.368  69.700  1.00 17.50           N  
ATOM    173  CA  GLU A  39      79.400 108.565  69.591  1.00 16.87           C  
ATOM    174  C   GLU A  39      79.063 109.915  68.964  1.00 15.96           C  
ATOM    175  O   GLU A  39      78.176 109.997  68.122  1.00 15.57           O  
ATOM    176  CB  GLU A  39      78.730 108.419  70.963  1.00 18.93           C  
ATOM    177  CG  GLU A  39      78.799 106.998  71.491  1.00 21.60           C  
ATOM    178  CD  GLU A  39      78.372 106.884  72.934  1.00 24.13           C  
ATOM    179  OE1 GLU A  39      77.171 106.662  73.193  1.00 27.18           O  
ATOM    180  OE2 GLU A  39      79.252 107.035  73.796  1.00 21.49           O  
ATOM    181  N   HIS A  40      79.772 110.971  69.358  1.00 16.86           N  
ATOM    182  CA  HIS A  40      79.514 112.291  68.775  1.00 16.19           C  
ATOM    183  C   HIS A  40      79.740 112.185  67.271  1.00 16.82           C  
ATOM    184  O   HIS A  40      78.981 112.711  66.459  1.00 16.58           O  
ATOM    185  CB  HIS A  40      80.477 113.336  69.339  1.00 18.89           C  
ATOM    186  CG  HIS A  40      80.137 113.802  70.720  1.00 17.77           C  
ATOM    187  ND1 HIS A  40      79.047 114.603  70.989  1.00 22.01           N  
ATOM    188  CD2 HIS A  40      80.749 113.588  71.907  1.00 20.28           C  
ATOM    189  CE1 HIS A  40      79.004 114.862  72.284  1.00 19.91           C  
ATOM    190  NE2 HIS A  40      80.025 114.260  72.864  1.00 18.59           N  
ATOM    191  N   SER A  41      80.819 111.500  66.922  1.00 15.12           N  
ATOM    192  CA  SER A  41      81.198 111.296  65.538  1.00 14.32           C  
ATOM    193  C   SER A  41      80.140 110.557  64.716  1.00 14.93           C  
ATOM    194  O   SER A  41      79.688 111.030  63.668  1.00 14.36           O  
ATOM    195  CB  SER A  41      82.509 110.529  65.502  1.00 17.24           C  
ATOM    196  OG  SER A  41      83.584 111.384  65.838  1.00 19.73           O  
ATOM    197  N   VAL A  42      79.747 109.392  65.209  1.00 14.45           N  
ATOM    198  CA  VAL A  42      78.767 108.552  64.540  1.00 15.04           C  
ATOM    199  C   VAL A  42      77.401 109.202  64.482  1.00 15.39           C  
ATOM    200  O   VAL A  42      76.706 109.116  63.469  1.00 13.23           O  
ATOM    201  CB  VAL A  42      78.680 107.184  65.248  1.00 15.33           C  
ATOM    202  CG1 VAL A  42      77.517 106.363  64.693  1.00 16.16           C  
ATOM    203  CG2 VAL A  42      79.996 106.438  65.062  1.00 17.36           C  
ATOM    204  N   HIS A  43      77.012 109.871  65.558  1.00 14.13           N  
ATOM    205  CA  HIS A  43      75.707 110.530  65.563  1.00 16.69           C  
ATOM    206  C   HIS A  43      75.631 111.659  64.529  1.00 14.63           C  
ATOM    207  O   HIS A  43      74.559 111.932  63.990  1.00 16.17           O  
ATOM    208  CB  HIS A  43      75.380 111.021  66.977  1.00 21.67           C  
ATOM    209  CG  HIS A  43      75.023 109.912  67.923  1.00 26.37           C  
ATOM    210  ND1 HIS A  43      74.077 108.953  67.623  1.00 27.70           N  
ATOM    211  CD2 HIS A  43      75.475 109.616  69.166  1.00 28.47           C  
ATOM    212  CE1 HIS A  43      73.962 108.115  68.639  1.00 29.87           C  
ATOM    213  NE2 HIS A  43      74.799 108.496  69.587  1.00 29.99           N  
ATOM    214  N   ALA A  44      76.761 112.299  64.233  1.00 13.33           N  
ATOM    215  CA  ALA A  44      76.755 113.361  63.228  1.00 13.14           C  
ATOM    216  C   ALA A  44      76.432 112.759  61.851  1.00 13.38           C  
ATOM    217  O   ALA A  44      75.733 113.369  61.049  1.00 14.38           O  
ATOM    218  CB  ALA A  44      78.105 114.072  63.190  1.00 13.65           C  
ATOM    219  N   LEU A  45      76.950 111.562  61.582  1.00 11.19           N  
ATOM    220  CA  LEU A  45      76.702 110.893  60.317  1.00 12.25           C  
ATOM    221  C   LEU A  45      75.245 110.452  60.220  1.00 13.59           C  
ATOM    222  O   LEU A  45      74.588 110.674  59.208  1.00 11.72           O  
ATOM    223  CB  LEU A  45      77.614 109.668  60.167  1.00 12.06           C  
ATOM    224  CG  LEU A  45      79.118 109.917  60.282  1.00 10.86           C  
ATOM    225  CD1 LEU A  45      79.876 108.602  60.209  1.00 14.34           C  
ATOM    226  CD2 LEU A  45      79.548 110.851  59.178  1.00 13.11           C  
ATOM    227  N   LEU A  46      74.736 109.840  61.285  1.00 13.83           N  
ATOM    228  CA  LEU A  46      73.366 109.341  61.287  1.00 12.60           C  
ATOM    229  C   LEU A  46      72.321 110.451  61.247  1.00 15.39           C  
ATOM    230  O   LEU A  46      71.144 110.182  60.993  1.00 13.96           O  
ATOM    231  CB  LEU A  46      73.135 108.445  62.512  1.00 14.00           C  
ATOM    232  CG  LEU A  46      73.815 107.068  62.491  1.00 17.09           C  
ATOM    233  CD1 LEU A  46      73.637 106.389  63.835  1.00 19.55           C  
ATOM    234  CD2 LEU A  46      73.217 106.221  61.379  1.00 16.82           C  
ATOM    235  N   ALA A  47      72.737 111.696  61.483  1.00 15.58           N  
ATOM    236  CA  ALA A  47      71.792 112.811  61.451  1.00 16.02           C  
ATOM    237  C   ALA A  47      71.273 113.066  60.045  1.00 17.72           C  
ATOM    238  O   ALA A  47      70.145 113.525  59.867  1.00 18.13           O  
ATOM    239  CB  ALA A  47      72.438 114.080  62.002  1.00 14.96           C  
ATOM    240  N   HIS A  48      72.095 112.780  59.042  1.00 15.25           N  
ATOM    241  CA  HIS A  48      71.657 112.990  57.666  1.00 15.41           C  
ATOM    242  C   HIS A  48      70.797 111.809  57.216  1.00 15.50           C  
ATOM    243  O   HIS A  48      71.198 110.652  57.350  1.00 13.59           O  
ATOM    244  CB  HIS A  48      72.854 113.157  56.733  1.00 15.64           C  
ATOM    245  CG  HIS A  48      72.492 113.743  55.405  1.00 18.50           C  
ATOM    246  ND1 HIS A  48      71.762 113.056  54.457  1.00 16.23           N  
ATOM    247  CD2 HIS A  48      72.730 114.969  54.879  1.00 21.88           C  
ATOM    248  CE1 HIS A  48      71.568 113.832  53.405  1.00 20.80           C  
ATOM    249  NE2 HIS A  48      72.145 114.997  53.636  1.00 22.37           N  
ATOM    250  N   PRO A  49      69.601 112.089  56.673  1.00 16.93           N  
ATOM    251  CA  PRO A  49      68.660 111.067  56.204  1.00 18.24           C  
ATOM    252  C   PRO A  49      69.219 110.028  55.241  1.00 16.02           C  
ATOM    253  O   PRO A  49      68.791 108.875  55.261  1.00 16.59           O  
ATOM    254  CB  PRO A  49      67.552 111.892  55.550  1.00 18.35           C  
ATOM    255  CG  PRO A  49      67.549 113.129  56.339  1.00 21.24           C  
ATOM    256  CD  PRO A  49      69.030 113.435  56.496  1.00 19.76           C  
ATOM    257  N   ARG A  50      70.159 110.433  54.390  1.00 12.62           N  
ATOM    258  CA  ARG A  50      70.722 109.517  53.407  1.00 12.41           C  
ATOM    259  C   ARG A  50      71.605 108.435  54.010  1.00 12.47           C  
ATOM    260  O   ARG A  50      71.787 107.386  53.400  1.00 13.52           O  
ATOM    261  CB  ARG A  50      71.504 110.287  52.343  1.00 13.75           C  
ATOM    262  CG  ARG A  50      70.615 111.015  51.339  1.00 12.33           C  
ATOM    263  CD  ARG A  50      71.443 111.702  50.258  1.00 13.49           C  
ATOM    264  NE  ARG A  50      72.213 110.742  49.459  1.00 13.68           N  
ATOM    265  CZ  ARG A  50      73.148 111.092  48.585  1.00 14.80           C  
ATOM    266  NH1 ARG A  50      73.428 112.375  48.397  1.00 14.91           N  
ATOM    267  NH2 ARG A  50      73.803 110.166  47.905  1.00 15.18           N  
ATOM    268  N   VAL A  51      72.159 108.677  55.193  1.00 11.10           N  
ATOM    269  CA  VAL A  51      73.007 107.669  55.819  1.00 10.94           C  
ATOM    270  C   VAL A  51      72.106 106.584  56.416  1.00 13.15           C  
ATOM    271  O   VAL A  51      71.493 106.778  57.459  1.00 15.97           O  
ATOM    272  CB  VAL A  51      73.905 108.307  56.902  1.00  9.58           C  
ATOM    273  CG1 VAL A  51      74.720 107.237  57.606  1.00 13.11           C  
ATOM    274  CG2 VAL A  51      74.828 109.331  56.263  1.00 12.65           C  
ATOM    275  N   LYS A  52      72.034 105.444  55.735  1.00 13.45           N  
ATOM    276  CA  LYS A  52      71.182 104.325  56.149  1.00 13.61           C  
ATOM    277  C   LYS A  52      71.927 103.322  57.012  1.00 14.33           C  
ATOM    278  O   LYS A  52      71.327 102.473  57.678  1.00 15.77           O  
ATOM    279  CB  LYS A  52      70.652 103.567  54.923  1.00 14.96           C  
ATOM    280  CG  LYS A  52      70.096 104.440  53.795  1.00 14.08           C  
ATOM    281  CD  LYS A  52      69.013 105.381  54.298  1.00 16.57           C  
ATOM    282  CE  LYS A  52      68.324 106.125  53.164  1.00 17.29           C  
ATOM    283  NZ  LYS A  52      67.312 107.070  53.715  1.00 17.26           N  
ATOM    284  N   ARG A  53      73.245 103.404  56.979  1.00 12.87           N  
ATOM    285  CA  ARG A  53      74.052 102.470  57.737  1.00 15.84           C  
ATOM    286  C   ARG A  53      75.433 103.006  58.057  1.00 15.78           C  
ATOM    287  O   ARG A  53      76.015 103.769  57.291  1.00 14.94           O  
ATOM    288  CB  ARG A  53      74.191 101.171  56.950  1.00 18.73           C  
ATOM    289  CG  ARG A  53      75.052 100.132  57.629  1.00 29.51           C  
ATOM    290  CD  ARG A  53      75.367  99.019  56.662  1.00 35.09           C  
ATOM    291  NE  ARG A  53      74.823  97.741  57.090  1.00 41.15           N  
ATOM    292  CZ  ARG A  53      74.783  96.662  56.318  1.00 44.08           C  
ATOM    293  NH1 ARG A  53      75.253  96.720  55.081  1.00 44.02           N  
ATOM    294  NH2 ARG A  53      74.281  95.523  56.781  1.00 45.75           N  
ATOM    295  N   VAL A  54      75.936 102.613  59.218  1.00 13.12           N  
ATOM    296  CA  VAL A  54      77.273 103.000  59.635  1.00 11.20           C  
ATOM    297  C   VAL A  54      77.988 101.724  60.051  1.00 11.83           C  
ATOM    298  O   VAL A  54      77.519 100.993  60.928  1.00 13.89           O  
ATOM    299  CB  VAL A  54      77.267 103.988  60.824  1.00 12.53           C  
ATOM    300  CG1 VAL A  54      78.707 104.339  61.223  1.00 14.34           C  
ATOM    301  CG2 VAL A  54      76.500 105.245  60.446  1.00 11.69           C  
ATOM    302  N   VAL A  55      79.107 101.449  59.391  1.00 10.75           N  
ATOM    303  CA  VAL A  55      79.923 100.279  59.701  1.00 12.50           C  
ATOM    304  C   VAL A  55      81.121 100.809  60.479  1.00 11.45           C  
ATOM    305  O   VAL A  55      81.875 101.644  59.985  1.00 11.54           O  
ATOM    306  CB  VAL A  55      80.428  99.560  58.427  1.00 12.22           C  
ATOM    307  CG1 VAL A  55      81.271  98.354  58.830  1.00 13.52           C  
ATOM    308  CG2 VAL A  55      79.245  99.092  57.566  1.00 16.25           C  
ATOM    309  N   ILE A  56      81.287 100.323  61.704  1.00 12.21           N  
ATOM    310  CA  ILE A  56      82.388 100.755  62.549  1.00  9.89           C  
ATOM    311  C   ILE A  56      83.373  99.603  62.656  1.00 13.11           C  
ATOM    312  O   ILE A  56      82.993  98.502  63.041  1.00 16.38           O  
ATOM    313  CB  ILE A  56      81.883 101.143  63.958  1.00 12.74           C  
ATOM    314  CG1 ILE A  56      80.819 102.239  63.846  1.00 12.47           C  
ATOM    315  CG2 ILE A  56      83.036 101.627  64.818  1.00 14.03           C  
ATOM    316  CD1 ILE A  56      80.233 102.656  65.172  1.00 16.08           C  
ATOM    317  N   ALA A  57      84.621  99.853  62.280  1.00 13.09           N  
ATOM    318  CA  ALA A  57      85.663  98.828  62.331  1.00 13.49           C  
ATOM    319  C   ALA A  57      86.439  99.028  63.622  1.00 15.11           C  
ATOM    320  O   ALA A  57      87.009 100.093  63.849  1.00 16.19           O  
ATOM    321  CB  ALA A  57      86.589  98.966  61.136  1.00 15.09           C  
ATOM    322  N   ILE A  58      86.450  98.014  64.477  1.00 16.65           N  
ATOM    323  CA  ILE A  58      87.162  98.126  65.734  1.00 19.31           C  
ATOM    324  C   ILE A  58      88.251  97.070  65.824  1.00 19.94           C  
ATOM    325  O   ILE A  58      88.184  96.033  65.161  1.00 19.53           O  
ATOM    326  CB  ILE A  58      86.216  97.966  66.934  1.00 21.17           C  
ATOM    327  CG1 ILE A  58      85.576  96.581  66.913  1.00 22.64           C  
ATOM    328  CG2 ILE A  58      85.150  99.052  66.900  1.00 20.98           C  
ATOM    329  CD1 ILE A  58      84.719  96.278  68.132  1.00 23.98           C  
ATOM    330  N   SER A  59      89.254  97.334  66.648  1.00 22.12           N  
ATOM    331  CA  SER A  59      90.340  96.382  66.807  1.00 24.93           C  
ATOM    332  C   SER A  59      89.845  95.160  67.567  1.00 25.99           C  
ATOM    333  O   SER A  59      88.974  95.268  68.424  1.00 26.05           O  
ATOM    334  CB  SER A  59      91.494  97.037  67.573  1.00 26.45           C  
ATOM    335  OG  SER A  59      92.482  96.077  67.911  1.00 29.74           O  
ATOM    336  N   PRO A  60      90.368  93.973  67.235  1.00 26.08           N  
ATOM    337  CA  PRO A  60      89.923  92.780  67.959  1.00 28.98           C  
ATOM    338  C   PRO A  60      90.400  92.937  69.401  1.00 29.20           C  
ATOM    339  O   PRO A  60      91.519  93.384  69.640  1.00 29.78           O  
ATOM    340  CB  PRO A  60      90.621  91.642  67.215  1.00 28.95           C  
ATOM    341  CG  PRO A  60      91.846  92.300  66.640  1.00 29.83           C  
ATOM    342  CD  PRO A  60      91.308  93.624  66.157  1.00 28.30           C  
ATOM    343  N   GLY A  61      89.551  92.594  70.359  1.00 30.96           N  
ATOM    344  CA  GLY A  61      89.942  92.749  71.749  1.00 34.51           C  
ATOM    345  C   GLY A  61      89.416  94.051  72.336  1.00 35.64           C  
ATOM    346  O   GLY A  61      89.455  94.263  73.552  1.00 36.43           O  
ATOM    347  N   ASP A  62      88.933  94.933  71.464  1.00 35.41           N  
ATOM    348  CA  ASP A  62      88.369  96.210  71.883  1.00 35.45           C  
ATOM    349  C   ASP A  62      87.090  95.893  72.653  1.00 35.68           C  
ATOM    350  O   ASP A  62      86.063  95.577  72.056  1.00 35.10           O  
ATOM    351  CB  ASP A  62      88.056  97.068  70.648  1.00 35.28           C  
ATOM    352  CG  ASP A  62      87.346  98.363  70.994  1.00 36.26           C  
ATOM    353  OD1 ASP A  62      87.276  98.710  72.192  1.00 36.04           O  
ATOM    354  OD2 ASP A  62      86.865  99.043  70.064  1.00 35.85           O  
ATOM    355  N   SER A  63      87.161  95.975  73.978  1.00 35.75           N  
ATOM    356  CA  SER A  63      86.018  95.663  74.828  1.00 36.28           C  
ATOM    357  C   SER A  63      85.194  96.867  75.283  1.00 35.77           C  
ATOM    358  O   SER A  63      84.268  96.718  76.080  1.00 36.82           O  
ATOM    359  CB  SER A  63      86.491  94.889  76.062  1.00 36.85           C  
ATOM    360  OG  SER A  63      87.434  95.646  76.804  1.00 38.43           O  
ATOM    361  N   ARG A  64      85.522  98.052  74.780  1.00 34.95           N  
ATOM    362  CA  ARG A  64      84.797  99.254  75.168  1.00 34.19           C  
ATOM    363  C   ARG A  64      83.560  99.496  74.308  1.00 32.38           C  
ATOM    364  O   ARG A  64      82.502  99.862  74.817  1.00 32.04           O  
ATOM    365  CB  ARG A  64      85.722 100.470  75.095  1.00 35.14           C  
ATOM    366  CG  ARG A  64      86.924 100.369  76.022  1.00 38.53           C  
ATOM    367  CD  ARG A  64      87.839 101.580  75.923  1.00 39.87           C  
ATOM    368  NE  ARG A  64      88.980 101.449  76.825  1.00 43.20           N  
ATOM    369  CZ  ARG A  64      89.983 102.317  76.899  1.00 44.84           C  
ATOM    370  NH1 ARG A  64      89.994 103.391  76.117  1.00 45.90           N  
ATOM    371  NH2 ARG A  64      90.977 102.110  77.752  1.00 44.90           N  
ATOM    372  N   PHE A  65      83.697  99.282  73.004  1.00 31.49           N  
ATOM    373  CA  PHE A  65      82.601  99.492  72.066  1.00 30.57           C  
ATOM    374  C   PHE A  65      81.297  98.802  72.463  1.00 30.65           C  
ATOM    375  O   PHE A  65      80.236  99.424  72.471  1.00 28.99           O  
ATOM    376  CB  PHE A  65      83.005  99.007  70.674  1.00 28.56           C  
ATOM    377  CG  PHE A  65      81.948  99.225  69.632  1.00 28.86           C  
ATOM    378  CD1 PHE A  65      81.774 100.478  69.053  1.00 28.01           C  
ATOM    379  CD2 PHE A  65      81.091  98.193  69.268  1.00 28.03           C  
ATOM    380  CE1 PHE A  65      80.766 100.697  68.120  1.00 28.64           C  
ATOM    381  CE2 PHE A  65      80.078  98.401  68.338  1.00 28.88           C  
ATOM    382  CZ  PHE A  65      79.913  99.658  67.767  1.00 28.06           C  
ATOM    383  N   ALA A  66      81.387  97.512  72.774  1.00 31.55           N  
ATOM    384  CA  ALA A  66      80.229  96.709  73.146  1.00 32.50           C  
ATOM    385  C   ALA A  66      79.438  97.288  74.307  1.00 33.36           C  
ATOM    386  O   ALA A  66      78.255  96.989  74.470  1.00 33.30           O  
ATOM    387  CB  ALA A  66      80.673  95.291  73.480  1.00 32.13           C  
ATOM    388  N   GLN A  67      80.087  98.117  75.116  1.00 33.70           N  
ATOM    389  CA  GLN A  67      79.419  98.725  76.261  1.00 35.56           C  
ATOM    390  C   GLN A  67      78.806 100.086  75.924  1.00 35.70           C  
ATOM    391  O   GLN A  67      78.357 100.808  76.817  1.00 35.51           O  
ATOM    392  CB  GLN A  67      80.399  98.858  77.429  1.00 37.86           C  
ATOM    393  CG  GLN A  67      81.020  97.536  77.869  1.00 41.61           C  
ATOM    394  CD  GLN A  67      79.984  96.473  78.209  1.00 44.27           C  
ATOM    395  OE1 GLN A  67      79.112  96.686  79.054  1.00 45.80           O  
ATOM    396  NE2 GLN A  67      80.070  95.323  77.542  1.00 45.39           N  
ATOM    397  N   LEU A  68      78.793 100.431  74.637  1.00 35.39           N  
ATOM    398  CA  LEU A  68      78.211 101.691  74.172  1.00 34.89           C  
ATOM    399  C   LEU A  68      76.843 101.411  73.554  1.00 34.94           C  
ATOM    400  O   LEU A  68      76.559 100.289  73.139  1.00 34.49           O  
ATOM    401  CB  LEU A  68      79.105 102.345  73.106  1.00 33.89           C  
ATOM    402  CG  LEU A  68      80.544 102.726  73.461  1.00 33.89           C  
ATOM    403  CD1 LEU A  68      81.228 103.320  72.235  1.00 33.02           C  
ATOM    404  CD2 LEU A  68      80.548 103.721  74.608  1.00 32.83           C  
ATOM    405  N   PRO A  69      75.972 102.431  73.490  1.00 36.18           N  
ATOM    406  CA  PRO A  69      74.637 102.256  72.906  1.00 36.07           C  
ATOM    407  C   PRO A  69      74.706 101.935  71.413  1.00 35.48           C  
ATOM    408  O   PRO A  69      73.788 101.343  70.849  1.00 36.03           O  
ATOM    409  CB  PRO A  69      73.965 103.601  73.175  1.00 37.28           C  
ATOM    410  CG  PRO A  69      74.640 104.070  74.434  1.00 37.42           C  
ATOM    411  CD  PRO A  69      76.084 103.741  74.153  1.00 36.21           C  
ATOM    412  N   LEU A  70      75.803 102.335  70.780  1.00 35.12           N  
ATOM    413  CA  LEU A  70      75.997 102.096  69.354  1.00 34.57           C  
ATOM    414  C   LEU A  70      76.014 100.603  69.038  1.00 34.16           C  
ATOM    415  O   LEU A  70      75.720 100.195  67.917  1.00 32.74           O  
ATOM    416  CB  LEU A  70      77.321 102.710  68.892  1.00 34.86           C  
ATOM    417  CG  LEU A  70      77.556 104.188  69.201  1.00 34.33           C  
ATOM    418  CD1 LEU A  70      78.954 104.566  68.764  1.00 32.87           C  
ATOM    419  CD2 LEU A  70      76.518 105.045  68.497  1.00 33.96           C  
ATOM    420  N   ALA A  71      76.360  99.796  70.036  1.00 33.30           N  
ATOM    421  CA  ALA A  71      76.446  98.352  69.870  1.00 33.44           C  
ATOM    422  C   ALA A  71      75.117  97.672  69.541  1.00 32.98           C  
ATOM    423  O   ALA A  71      75.105  96.591  68.956  1.00 33.54           O  
ATOM    424  CB  ALA A  71      77.053  97.725  71.120  1.00 33.80           C  
ATOM    425  N   ASN A  72      74.002  98.291  69.919  1.00 31.52           N  
ATOM    426  CA  ASN A  72      72.697  97.697  69.652  1.00 30.33           C  
ATOM    427  C   ASN A  72      71.815  98.541  68.739  1.00 28.48           C  
ATOM    428  O   ASN A  72      70.605  98.330  68.652  1.00 28.08           O  
ATOM    429  CB  ASN A  72      71.967  97.422  70.971  1.00 34.41           C  
ATOM    430  CG  ASN A  72      72.711  96.440  71.853  1.00 37.87           C  
ATOM    431  OD1 ASN A  72      73.628  96.816  72.584  1.00 41.01           O  
ATOM    432  ND2 ASN A  72      72.331  95.169  71.775  1.00 39.07           N  
ATOM    433  N   HIS A  73      72.429  99.495  68.053  1.00 23.89           N  
ATOM    434  CA  HIS A  73      71.707 100.372  67.140  1.00 18.43           C  
ATOM    435  C   HIS A  73      71.378  99.593  65.864  1.00 16.22           C  
ATOM    436  O   HIS A  73      72.242  98.939  65.282  1.00 16.51           O  
ATOM    437  CB  HIS A  73      72.568 101.589  66.825  1.00 18.10           C  
ATOM    438  CG  HIS A  73      71.828 102.696  66.142  1.00 17.88           C  
ATOM    439  ND1 HIS A  73      71.334 102.578  64.862  1.00 18.06           N  
ATOM    440  CD2 HIS A  73      71.503 103.944  66.558  1.00 18.32           C  
ATOM    441  CE1 HIS A  73      70.737 103.707  64.515  1.00 17.51           C  
ATOM    442  NE2 HIS A  73      70.826 104.551  65.528  1.00 15.98           N  
ATOM    443  N   PRO A  74      70.117  99.655  65.408  1.00 14.84           N  
ATOM    444  CA  PRO A  74      69.729  98.925  64.201  1.00 15.37           C  
ATOM    445  C   PRO A  74      70.443  99.331  62.920  1.00 14.36           C  
ATOM    446  O   PRO A  74      70.519  98.539  61.981  1.00 17.13           O  
ATOM    447  CB  PRO A  74      68.212  99.145  64.135  1.00 16.72           C  
ATOM    448  CG  PRO A  74      68.032 100.480  64.766  1.00 16.08           C  
ATOM    449  CD  PRO A  74      68.979 100.417  65.952  1.00 15.86           C  
ATOM    450  N   GLN A  75      70.984 100.548  62.879  1.00 14.91           N  
ATOM    451  CA  GLN A  75      71.665 101.018  61.672  1.00 14.21           C  
ATOM    452  C   GLN A  75      73.173 100.918  61.777  1.00 15.91           C  
ATOM    453  O   GLN A  75      73.876 101.356  60.873  1.00 18.05           O  
ATOM    454  CB  GLN A  75      71.283 102.470  61.367  1.00 13.89           C  
ATOM    455  CG  GLN A  75      69.807 102.671  61.007  1.00 14.29           C  
ATOM    456  CD  GLN A  75      69.439 104.135  60.905  1.00 15.46           C  
ATOM    457  OE1 GLN A  75      69.535 104.880  61.879  1.00 17.66           O  
ATOM    458  NE2 GLN A  75      68.988 104.549  59.737  1.00 17.34           N  
ATOM    459  N   ILE A  76      73.668 100.336  62.867  1.00 16.36           N  
ATOM    460  CA  ILE A  76      75.105 100.213  63.065  1.00 18.86           C  
ATOM    461  C   ILE A  76      75.567  98.766  63.035  1.00 19.05           C  
ATOM    462  O   ILE A  76      74.997  97.902  63.705  1.00 19.25           O  
ATOM    463  CB  ILE A  76      75.525 100.861  64.405  1.00 18.98           C  
ATOM    464  CG1 ILE A  76      75.109 102.341  64.405  1.00 20.17           C  
ATOM    465  CG2 ILE A  76      77.027 100.712  64.613  1.00 18.96           C  
ATOM    466  CD1 ILE A  76      75.450 103.086  65.685  1.00 22.13           C  
ATOM    467  N   THR A  77      76.600  98.514  62.240  1.00 19.00           N  
ATOM    468  CA  THR A  77      77.182  97.185  62.110  1.00 18.86           C  
ATOM    469  C   THR A  77      78.641  97.283  62.549  1.00 19.84           C  
ATOM    470  O   THR A  77      79.341  98.217  62.176  1.00 15.84           O  
ATOM    471  CB  THR A  77      77.121  96.691  60.644  1.00 22.80           C  
ATOM    472  OG1 THR A  77      75.753  96.618  60.217  1.00 22.90           O  
ATOM    473  CG2 THR A  77      77.764  95.313  60.516  1.00 22.36           C  
ATOM    474  N   VAL A  78      79.096  96.334  63.359  1.00 19.07           N  
ATOM    475  CA  VAL A  78      80.476  96.362  63.812  1.00 22.10           C  
ATOM    476  C   VAL A  78      81.268  95.231  63.168  1.00 21.33           C  
ATOM    477  O   VAL A  78      80.758  94.119  63.005  1.00 22.10           O  
ATOM    478  CB  VAL A  78      80.560  96.248  65.357  1.00 23.76           C  
ATOM    479  CG1 VAL A  78      79.975  94.916  65.808  1.00 25.18           C  
ATOM    480  CG2 VAL A  78      81.995  96.379  65.810  1.00 24.85           C  
ATOM    481  N   VAL A  79      82.506  95.531  62.780  1.00 21.43           N  
ATOM    482  CA  VAL A  79      83.383  94.544  62.155  1.00 21.89           C  
ATOM    483  C   VAL A  79      84.800  94.730  62.691  1.00 21.62           C  
ATOM    484  O   VAL A  79      85.136  95.794  63.216  1.00 18.16           O  
ATOM    485  CB  VAL A  79      83.403  94.694  60.606  1.00 22.88           C  
ATOM    486  CG1 VAL A  79      81.983  94.683  60.057  1.00 23.55           C  
ATOM    487  CG2 VAL A  79      84.121  95.976  60.201  1.00 23.06           C  
ATOM    488  N   ASP A  80      85.627  93.695  62.580  1.00 24.12           N  
ATOM    489  CA  ASP A  80      87.006  93.798  63.050  1.00 25.42           C  
ATOM    490  C   ASP A  80      87.836  94.577  62.040  1.00 24.08           C  
ATOM    491  O   ASP A  80      87.802  94.287  60.842  1.00 22.42           O  
ATOM    492  CB  ASP A  80      87.632  92.413  63.249  1.00 28.09           C  
ATOM    493  CG  ASP A  80      86.998  91.640  64.390  1.00 31.77           C  
ATOM    494  OD1 ASP A  80      86.675  92.259  65.432  1.00 32.05           O  
ATOM    495  OD2 ASP A  80      86.845  90.405  64.256  1.00 33.98           O  
ATOM    496  N   GLY A  81      88.578  95.563  62.533  1.00 25.71           N  
ATOM    497  CA  GLY A  81      89.418  96.370  61.671  1.00 28.54           C  
ATOM    498  C   GLY A  81      90.771  95.718  61.452  1.00 32.24           C  
ATOM    499  O   GLY A  81      90.949  94.542  61.767  1.00 32.03           O  
ATOM    500  N   GLY A  82      91.727  96.479  60.927  1.00 34.05           N  
ATOM    501  CA  GLY A  82      93.046  95.931  60.674  1.00 36.78           C  
ATOM    502  C   GLY A  82      94.184  96.696  61.317  1.00 38.15           C  
ATOM    503  O   GLY A  82      93.982  97.479  62.244  1.00 38.12           O  
ATOM    504  N   ASP A  83      95.393  96.462  60.811  1.00 40.43           N  
ATOM    505  CA  ASP A  83      96.595  97.113  61.332  1.00 40.80           C  
ATOM    506  C   ASP A  83      96.746  98.540  60.810  1.00 39.81           C  
ATOM    507  O   ASP A  83      97.178  99.436  61.537  1.00 39.80           O  
ATOM    508  CB  ASP A  83      97.834  96.295  60.951  1.00 43.77           C  
ATOM    509  CG  ASP A  83      97.598  94.801  61.065  1.00 46.01           C  
ATOM    510  OD1 ASP A  83      97.041  94.361  62.098  1.00 47.02           O  
ATOM    511  OD2 ASP A  83      97.978  94.066  60.130  1.00 46.76           O  
ATOM    512  N   GLU A  84      96.389  98.737  59.544  1.00 39.23           N  
ATOM    513  CA  GLU A  84      96.487 100.043  58.898  1.00 37.29           C  
ATOM    514  C   GLU A  84      95.091 100.632  58.685  1.00 35.12           C  
ATOM    515  O   GLU A  84      94.090  99.910  58.724  1.00 33.60           O  
ATOM    516  CB  GLU A  84      97.195  99.898  57.544  1.00 40.08           C  
ATOM    517  CG  GLU A  84      98.532  99.163  57.600  1.00 44.13           C  
ATOM    518  CD  GLU A  84      99.598  99.914  58.374  1.00 45.90           C  
ATOM    519  OE1 GLU A  84      99.384 100.199  59.570  1.00 47.61           O  
ATOM    520  OE2 GLU A  84     100.647 100.241  57.775  1.00 48.28           O  
ATOM    521  N   ARG A  85      95.026 101.938  58.444  1.00 32.57           N  
ATOM    522  CA  ARG A  85      93.744 102.601  58.227  1.00 31.35           C  
ATOM    523  C   ARG A  85      93.019 102.005  57.024  1.00 30.52           C  
ATOM    524  O   ARG A  85      91.848 101.637  57.114  1.00 27.38           O  
ATOM    525  CB  ARG A  85      93.937 104.106  58.010  1.00 31.24           C  
ATOM    526  CG  ARG A  85      92.623 104.876  57.918  1.00 32.08           C  
ATOM    527  CD  ARG A  85      92.819 106.296  57.412  1.00 33.61           C  
ATOM    528  NE  ARG A  85      91.534 106.937  57.136  1.00 32.47           N  
ATOM    529  CZ  ARG A  85      90.723 107.429  58.068  1.00 34.92           C  
ATOM    530  NH1 ARG A  85      91.063 107.366  59.348  1.00 34.10           N  
ATOM    531  NH2 ARG A  85      89.566 107.974  57.722  1.00 34.17           N  
ATOM    532  N   ALA A  86      93.728 101.903  55.902  1.00 28.59           N  
ATOM    533  CA  ALA A  86      93.148 101.357  54.678  1.00 27.75           C  
ATOM    534  C   ALA A  86      92.600  99.957  54.928  1.00 26.90           C  
ATOM    535  O   ALA A  86      91.598  99.556  54.336  1.00 23.80           O  
ATOM    536  CB  ALA A  86      94.196 101.321  53.572  1.00 28.32           C  
ATOM    537  N   ASP A  87      93.275  99.217  55.801  1.00 26.86           N  
ATOM    538  CA  ASP A  87      92.855  97.874  56.144  1.00 27.34           C  
ATOM    539  C   ASP A  87      91.478  97.889  56.801  1.00 24.71           C  
ATOM    540  O   ASP A  87      90.599  97.110  56.440  1.00 21.70           O  
ATOM    541  CB  ASP A  87      93.868  97.233  57.092  1.00 32.15           C  
ATOM    542  CG  ASP A  87      95.045  96.609  56.368  1.00 35.67           C  
ATOM    543  OD1 ASP A  87      95.981  96.146  57.056  1.00 38.16           O  
ATOM    544  OD2 ASP A  87      95.036  96.573  55.123  1.00 37.05           O  
ATOM    545  N   SER A  88      91.292  98.784  57.763  1.00 21.98           N  
ATOM    546  CA  SER A  88      90.018  98.883  58.462  1.00 20.17           C  
ATOM    547  C   SER A  88      88.909  99.383  57.542  1.00 18.54           C  
ATOM    548  O   SER A  88      87.757  98.966  57.661  1.00 18.15           O  
ATOM    549  CB  SER A  88      90.146  99.810  59.674  1.00 19.86           C  
ATOM    550  OG  SER A  88      91.058  99.280  60.622  1.00 21.29           O  
ATOM    551  N   VAL A  89      89.250 100.275  56.622  1.00 19.66           N  
ATOM    552  CA  VAL A  89      88.245 100.778  55.701  1.00 19.81           C  
ATOM    553  C   VAL A  89      87.798  99.680  54.744  1.00 21.31           C  
ATOM    554  O   VAL A  89      86.614  99.572  54.423  1.00 20.20           O  
ATOM    555  CB  VAL A  89      88.765 101.988  54.909  1.00 19.72           C  
ATOM    556  CG1 VAL A  89      87.755 102.391  53.844  1.00 20.40           C  
ATOM    557  CG2 VAL A  89      89.000 103.150  55.860  1.00 21.10           C  
ATOM    558  N   LEU A  90      88.737  98.855  54.293  1.00 20.62           N  
ATOM    559  CA  LEU A  90      88.389  97.758  53.393  1.00 21.53           C  
ATOM    560  C   LEU A  90      87.461  96.783  54.113  1.00 21.32           C  
ATOM    561  O   LEU A  90      86.503  96.280  53.528  1.00 21.03           O  
ATOM    562  CB  LEU A  90      89.655  97.028  52.919  1.00 23.79           C  
ATOM    563  CG  LEU A  90      90.439  97.733  51.797  1.00 26.64           C  
ATOM    564  CD1 LEU A  90      91.761  97.030  51.542  1.00 27.57           C  
ATOM    565  CD2 LEU A  90      89.594  97.753  50.532  1.00 27.75           C  
ATOM    566  N   ALA A  91      87.746  96.516  55.385  1.00 20.20           N  
ATOM    567  CA  ALA A  91      86.912  95.613  56.172  1.00 21.89           C  
ATOM    568  C   ALA A  91      85.504  96.197  56.279  1.00 23.25           C  
ATOM    569  O   ALA A  91      84.513  95.475  56.194  1.00 23.68           O  
ATOM    570  CB  ALA A  91      87.510  95.413  57.566  1.00 23.33           C  
ATOM    571  N   GLY A  92      85.426  97.511  56.468  1.00 23.27           N  
ATOM    572  CA  GLY A  92      84.130  98.164  56.569  1.00 22.87           C  
ATOM    573  C   GLY A  92      83.342  98.045  55.278  1.00 23.05           C  
ATOM    574  O   GLY A  92      82.140  97.791  55.300  1.00 20.61           O  
ATOM    575  N   LEU A  93      84.019  98.229  54.148  1.00 23.33           N  
ATOM    576  CA  LEU A  93      83.372  98.140  52.843  1.00 25.84           C  
ATOM    577  C   LEU A  93      82.740  96.774  52.570  1.00 28.71           C  
ATOM    578  O   LEU A  93      81.800  96.671  51.780  1.00 27.30           O  
ATOM    579  CB  LEU A  93      84.374  98.471  51.733  1.00 26.84           C  
ATOM    580  CG  LEU A  93      84.918  99.903  51.718  1.00 28.00           C  
ATOM    581  CD1 LEU A  93      85.959 100.047  50.611  1.00 27.96           C  
ATOM    582  CD2 LEU A  93      83.771 100.882  51.501  1.00 28.55           C  
ATOM    583  N   LYS A  94      83.255  95.730  53.216  1.00 29.93           N  
ATOM    584  CA  LYS A  94      82.716  94.385  53.026  1.00 31.48           C  
ATOM    585  C   LYS A  94      81.326  94.222  53.633  1.00 31.42           C  
ATOM    586  O   LYS A  94      80.559  93.353  53.218  1.00 31.43           O  
ATOM    587  CB  LYS A  94      83.670  93.341  53.616  1.00 34.77           C  
ATOM    588  CG  LYS A  94      84.909  93.085  52.768  1.00 38.59           C  
ATOM    589  CD  LYS A  94      85.812  92.021  53.388  1.00 42.82           C  
ATOM    590  CE  LYS A  94      85.033  90.742  53.703  1.00 44.10           C  
ATOM    591  NZ  LYS A  94      84.332  90.182  52.508  1.00 46.48           N  
ATOM    592  N   ALA A  95      81.000  95.057  54.613  1.00 29.38           N  
ATOM    593  CA  ALA A  95      79.691  94.985  55.254  1.00 30.96           C  
ATOM    594  C   ALA A  95      78.834  96.179  54.851  1.00 29.68           C  
ATOM    595  O   ALA A  95      77.835  96.479  55.497  1.00 29.61           O  
ATOM    596  CB  ALA A  95      79.852  94.944  56.766  1.00 31.38           C  
ATOM    597  N   ALA A  96      79.229  96.842  53.767  1.00 29.37           N  
ATOM    598  CA  ALA A  96      78.523  98.016  53.273  1.00 30.30           C  
ATOM    599  C   ALA A  96      77.331  97.668  52.392  1.00 31.04           C  
ATOM    600  O   ALA A  96      76.722  98.548  51.780  1.00 31.33           O  
ATOM    601  CB  ALA A  96      79.488  98.912  52.508  1.00 27.28           C  
ATOM    602  N   GLY A  97      76.993  96.386  52.329  1.00 30.85           N  
ATOM    603  CA  GLY A  97      75.866  95.967  51.516  1.00 30.91           C  
ATOM    604  C   GLY A  97      75.992  96.388  50.064  1.00 30.97           C  
ATOM    605  O   GLY A  97      77.081  96.383  49.496  1.00 29.42           O  
ATOM    606  N   ASP A  98      74.872  96.767  49.459  1.00 30.99           N  
ATOM    607  CA  ASP A  98      74.876  97.174  48.061  1.00 30.34           C  
ATOM    608  C   ASP A  98      74.909  98.689  47.881  1.00 27.70           C  
ATOM    609  O   ASP A  98      74.568  99.201  46.820  1.00 26.41           O  
ATOM    610  CB  ASP A  98      73.656  96.585  47.350  1.00 34.05           C  
ATOM    611  CG  ASP A  98      72.392  96.702  48.174  1.00 37.53           C  
ATOM    612  OD1 ASP A  98      72.031  97.837  48.554  1.00 39.94           O  
ATOM    613  OD2 ASP A  98      71.761  95.656  48.446  1.00 40.00           O  
ATOM    614  N   ALA A  99      75.324  99.400  48.924  1.00 25.11           N  
ATOM    615  CA  ALA A  99      75.409 100.854  48.872  1.00 24.35           C  
ATOM    616  C   ALA A  99      76.257 101.291  47.685  1.00 20.73           C  
ATOM    617  O   ALA A  99      77.344 100.761  47.455  1.00 22.14           O  
ATOM    618  CB  ALA A  99      76.004 101.389  50.163  1.00 24.23           C  
ATOM    619  N   GLN A 100      75.753 102.260  46.932  1.00 18.93           N  
ATOM    620  CA  GLN A 100      76.458 102.766  45.760  1.00 18.08           C  
ATOM    621  C   GLN A 100      77.508 103.809  46.110  1.00 14.29           C  
ATOM    622  O   GLN A 100      78.485 103.965  45.381  1.00 15.01           O  
ATOM    623  CB  GLN A 100      75.456 103.366  44.783  1.00 23.03           C  
ATOM    624  CG  GLN A 100      74.624 102.344  44.021  1.00 26.91           C  
ATOM    625  CD  GLN A 100      73.532 103.010  43.209  1.00 28.51           C  
ATOM    626  OE1 GLN A 100      73.742 104.075  42.630  1.00 28.87           O  
ATOM    627  NE2 GLN A 100      72.367 102.384  43.153  1.00 32.24           N  
ATOM    628  N   TRP A 101      77.287 104.520  47.213  1.00 14.93           N  
ATOM    629  CA  TRP A 101      78.207 105.554  47.676  1.00 13.47           C  
ATOM    630  C   TRP A 101      78.542 105.328  49.145  1.00 12.54           C  
ATOM    631  O   TRP A 101      77.665 104.985  49.938  1.00 11.88           O  
ATOM    632  CB  TRP A 101      77.579 106.934  47.511  1.00  9.32           C  
ATOM    633  CG  TRP A 101      77.617 107.460  46.109  1.00 13.10           C  
ATOM    634  CD1 TRP A 101      76.797 107.118  45.067  1.00  9.24           C  
ATOM    635  CD2 TRP A 101      78.542 108.417  45.596  1.00 11.19           C  
ATOM    636  NE1 TRP A 101      77.166 107.807  43.934  1.00 14.51           N  
ATOM    637  CE2 TRP A 101      78.237 108.604  44.230  1.00 12.35           C  
ATOM    638  CE3 TRP A 101      79.614 109.119  46.153  1.00 13.76           C  
ATOM    639  CZ2 TRP A 101      78.962 109.491  43.421  1.00 14.85           C  
ATOM    640  CZ3 TRP A 101      80.335 109.998  45.346  1.00 11.45           C  
ATOM    641  CH2 TRP A 101      80.009 110.170  43.994  1.00 13.38           C  
ATOM    642  N   VAL A 102      79.813 105.527  49.497  1.00 11.92           N  
ATOM    643  CA  VAL A 102      80.289 105.332  50.866  1.00 10.16           C  
ATOM    644  C   VAL A 102      80.900 106.610  51.431  1.00 11.29           C  
ATOM    645  O   VAL A 102      81.577 107.345  50.726  1.00  8.17           O  
ATOM    646  CB  VAL A 102      81.340 104.167  50.938  1.00 12.48           C  
ATOM    647  CG1 VAL A 102      82.509 104.448  49.999  1.00 15.09           C  
ATOM    648  CG2 VAL A 102      81.831 103.999  52.358  1.00 16.50           C  
ATOM    649  N   LEU A 103      80.641 106.865  52.709  1.00 11.02           N  
ATOM    650  CA  LEU A 103      81.127 108.046  53.411  1.00 12.59           C  
ATOM    651  C   LEU A 103      82.103 107.571  54.479  1.00 12.13           C  
ATOM    652  O   LEU A 103      81.692 106.922  55.435  1.00 17.83           O  
ATOM    653  CB  LEU A 103      79.939 108.740  54.080  1.00 15.77           C  
ATOM    654  CG  LEU A 103      80.086 110.142  54.661  1.00 20.11           C  
ATOM    655  CD1 LEU A 103      80.259 111.155  53.536  1.00 17.24           C  
ATOM    656  CD2 LEU A 103      78.846 110.479  55.477  1.00 18.73           C  
ATOM    657  N   VAL A 104      83.391 107.865  54.320  1.00 10.57           N  
ATOM    658  CA  VAL A 104      84.378 107.434  55.316  1.00 11.81           C  
ATOM    659  C   VAL A 104      84.672 108.610  56.248  1.00 11.00           C  
ATOM    660  O   VAL A 104      85.049 109.690  55.791  1.00 10.89           O  
ATOM    661  CB  VAL A 104      85.694 106.968  54.652  1.00 12.62           C  
ATOM    662  CG1 VAL A 104      86.601 106.310  55.693  1.00 11.66           C  
ATOM    663  CG2 VAL A 104      85.384 106.002  53.524  1.00 13.55           C  
ATOM    664  N   HIS A 105      84.495 108.401  57.551  1.00  8.91           N  
ATOM    665  CA  HIS A 105      84.711 109.460  58.532  1.00 11.46           C  
ATOM    666  C   HIS A 105      85.560 109.028  59.731  1.00 11.22           C  
ATOM    667  O   HIS A 105      85.390 107.931  60.250  1.00 13.84           O  
ATOM    668  CB  HIS A 105      83.353 109.977  59.030  1.00 13.03           C  
ATOM    669  CG  HIS A 105      83.456 111.198  59.887  1.00 12.32           C  
ATOM    670  ND1 HIS A 105      82.790 111.327  61.086  1.00 16.15           N  
ATOM    671  CD2 HIS A 105      84.173 112.335  59.730  1.00 10.41           C  
ATOM    672  CE1 HIS A 105      83.099 112.491  61.635  1.00 12.65           C  
ATOM    673  NE2 HIS A 105      83.938 113.119  60.832  1.00 15.63           N  
ATOM    674  N   ASP A 106      86.466 109.907  60.155  1.00 13.85           N  
ATOM    675  CA  ASP A 106      87.346 109.654  61.299  1.00 16.11           C  
ATOM    676  C   ASP A 106      86.575 109.448  62.600  1.00 17.05           C  
ATOM    677  O   ASP A 106      85.647 110.189  62.910  1.00 17.00           O  
ATOM    678  CB  ASP A 106      88.306 110.829  61.510  1.00 18.80           C  
ATOM    679  CG  ASP A 106      89.441 110.856  60.507  1.00 25.02           C  
ATOM    680  OD1 ASP A 106      90.227 111.823  60.541  1.00 26.63           O  
ATOM    681  OD2 ASP A 106      89.556 109.915  59.692  1.00 28.08           O  
ATOM    682  N   ALA A 107      86.988 108.455  63.376  1.00 18.30           N  
ATOM    683  CA  ALA A 107      86.341 108.164  64.643  1.00 15.94           C  
ATOM    684  C   ALA A 107      86.539 109.317  65.630  1.00 17.35           C  
ATOM    685  O   ALA A 107      85.699 109.544  66.500  1.00 18.38           O  
ATOM    686  CB  ALA A 107      86.912 106.877  65.227  1.00 17.39           C  
ATOM    687  N   ALA A 108      87.641 110.044  65.474  1.00 17.49           N  
ATOM    688  CA  ALA A 108      87.993 111.145  66.370  1.00 18.52           C  
ATOM    689  C   ALA A 108      87.671 112.556  65.885  1.00 18.26           C  
ATOM    690  O   ALA A 108      88.336 113.517  66.279  1.00 19.56           O  
ATOM    691  CB  ALA A 108      89.477 111.055  66.714  1.00 17.98           C  
ATOM    692  N   ARG A 109      86.664 112.686  65.032  1.00 17.05           N  
ATOM    693  CA  ARG A 109      86.247 113.990  64.530  1.00 17.52           C  
ATOM    694  C   ARG A 109      84.785 114.179  64.926  1.00 15.97           C  
ATOM    695  O   ARG A 109      83.881 113.984  64.112  1.00 17.81           O  
ATOM    696  CB  ARG A 109      86.398 114.046  63.010  1.00 18.79           C  
ATOM    697  CG  ARG A 109      87.816 114.276  62.526  1.00 19.26           C  
ATOM    698  CD  ARG A 109      87.842 114.431  61.015  1.00 23.03           C  
ATOM    699  NE  ARG A 109      89.199 114.431  60.483  1.00 23.45           N  
ATOM    700  CZ  ARG A 109      90.014 115.482  60.482  1.00 25.11           C  
ATOM    701  NH1 ARG A 109      89.621 116.644  60.982  1.00 25.86           N  
ATOM    702  NH2 ARG A 109      91.236 115.368  59.981  1.00 26.85           N  
ATOM    703  N   PRO A 110      84.540 114.574  66.187  1.00 16.44           N  
ATOM    704  CA  PRO A 110      83.202 114.786  66.731  1.00 15.57           C  
ATOM    705  C   PRO A 110      82.540 116.127  66.461  1.00 16.43           C  
ATOM    706  O   PRO A 110      81.379 116.307  66.819  1.00 18.71           O  
ATOM    707  CB  PRO A 110      83.420 114.567  68.217  1.00 16.72           C  
ATOM    708  CG  PRO A 110      84.745 115.261  68.434  1.00 17.98           C  
ATOM    709  CD  PRO A 110      85.565 114.768  67.234  1.00 18.30           C  
ATOM    710  N   CYS A 111      83.254 117.053  65.829  1.00 14.33           N  
ATOM    711  CA  CYS A 111      82.699 118.384  65.586  1.00 17.11           C  
ATOM    712  C   CYS A 111      82.072 118.629  64.220  1.00 15.12           C  
ATOM    713  O   CYS A 111      81.736 119.769  63.890  1.00 19.42           O  
ATOM    714  CB  CYS A 111      83.772 119.441  65.849  1.00 16.93           C  
ATOM    715  SG  CYS A 111      84.449 119.368  67.509  1.00 17.82           S  
ATOM    716  N   LEU A 112      81.900 117.564  63.440  1.00 15.60           N  
ATOM    717  CA  LEU A 112      81.301 117.656  62.108  1.00 15.50           C  
ATOM    718  C   LEU A 112      79.922 118.304  62.156  1.00 15.81           C  
ATOM    719  O   LEU A 112      79.089 117.939  62.988  1.00 17.30           O  
ATOM    720  CB  LEU A 112      81.182 116.256  61.486  1.00 12.00           C  
ATOM    721  CG  LEU A 112      80.446 116.129  60.144  1.00 15.92           C  
ATOM    722  CD1 LEU A 112      81.113 117.015  59.102  1.00 15.83           C  
ATOM    723  CD2 LEU A 112      80.436 114.670  59.689  1.00 13.96           C  
ATOM    724  N   HIS A 113      79.689 119.258  61.255  1.00 16.70           N  
ATOM    725  CA  HIS A 113      78.411 119.972  61.170  1.00 19.43           C  
ATOM    726  C   HIS A 113      77.560 119.474  60.010  1.00 18.70           C  
ATOM    727  O   HIS A 113      78.080 119.094  58.965  1.00 16.15           O  
ATOM    728  CB  HIS A 113      78.646 121.473  61.006  1.00 24.69           C  
ATOM    729  CG  HIS A 113      78.932 122.180  62.295  1.00 31.84           C  
ATOM    730  ND1 HIS A 113      79.023 123.551  62.388  1.00 34.76           N  
ATOM    731  CD2 HIS A 113      79.136 121.703  63.546  1.00 34.08           C  
ATOM    732  CE1 HIS A 113      79.270 123.890  63.642  1.00 35.91           C  
ATOM    733  NE2 HIS A 113      79.343 122.786  64.364  1.00 35.76           N  
ATOM    734  N   GLN A 114      76.245 119.506  60.200  1.00 18.31           N  
ATOM    735  CA  GLN A 114      75.294 119.051  59.202  1.00 17.77           C  
ATOM    736  C   GLN A 114      75.325 119.789  57.874  1.00 16.27           C  
ATOM    737  O   GLN A 114      75.074 119.185  56.831  1.00 16.95           O  
ATOM    738  CB  GLN A 114      73.883 119.102  59.786  1.00 18.49           C  
ATOM    739  CG  GLN A 114      73.686 118.120  60.921  1.00 18.36           C  
ATOM    740  CD  GLN A 114      74.036 116.703  60.498  1.00 20.13           C  
ATOM    741  OE1 GLN A 114      73.458 116.170  59.547  1.00 18.25           O  
ATOM    742  NE2 GLN A 114      74.993 116.089  61.194  1.00 18.44           N  
ATOM    743  N   ASP A 115      75.619 121.086  57.891  1.00 19.76           N  
ATOM    744  CA  ASP A 115      75.657 121.816  56.633  1.00 19.28           C  
ATOM    745  C   ASP A 115      76.808 121.324  55.760  1.00 17.27           C  
ATOM    746  O   ASP A 115      76.635 121.135  54.563  1.00 17.82           O  
ATOM    747  CB  ASP A 115      75.767 123.328  56.865  1.00 26.08           C  
ATOM    748  CG  ASP A 115      76.645 123.679  58.042  1.00 32.58           C  
ATOM    749  OD1 ASP A 115      77.629 122.953  58.294  1.00 35.46           O  
ATOM    750  OD2 ASP A 115      76.351 124.696  58.711  1.00 36.72           O  
ATOM    751  N   ASP A 116      77.980 121.118  56.359  1.00 16.50           N  
ATOM    752  CA  ASP A 116      79.126 120.621  55.599  1.00 12.77           C  
ATOM    753  C   ASP A 116      78.809 119.225  55.068  1.00 12.60           C  
ATOM    754  O   ASP A 116      79.042 118.910  53.889  1.00 13.20           O  
ATOM    755  CB  ASP A 116      80.390 120.541  56.468  1.00 15.05           C  
ATOM    756  CG  ASP A 116      80.982 121.904  56.770  1.00 17.59           C  
ATOM    757  OD1 ASP A 116      80.625 122.890  56.084  1.00 21.61           O  
ATOM    758  OD2 ASP A 116      81.832 121.980  57.680  1.00 20.84           O  
ATOM    759  N   LEU A 117      78.267 118.380  55.938  1.00 12.78           N  
ATOM    760  CA  LEU A 117      77.933 117.023  55.542  1.00 11.65           C  
ATOM    761  C   LEU A 117      76.967 117.023  54.367  1.00 11.46           C  
ATOM    762  O   LEU A 117      77.174 116.299  53.406  1.00 11.66           O  
ATOM    763  CB  LEU A 117      77.328 116.255  56.720  1.00 12.92           C  
ATOM    764  CG  LEU A 117      76.881 114.815  56.417  1.00 11.14           C  
ATOM    765  CD1 LEU A 117      78.030 114.049  55.757  1.00 14.79           C  
ATOM    766  CD2 LEU A 117      76.451 114.123  57.714  1.00 13.13           C  
ATOM    767  N   ALA A 118      75.928 117.855  54.439  1.00 12.94           N  
ATOM    768  CA  ALA A 118      74.946 117.921  53.369  1.00 10.75           C  
ATOM    769  C   ALA A 118      75.551 118.375  52.040  1.00 13.21           C  
ATOM    770  O   ALA A 118      75.192 117.859  50.978  1.00 14.22           O  
ATOM    771  CB  ALA A 118      73.792 118.849  53.778  1.00 12.17           C  
ATOM    772  N   ARG A 119      76.478 119.325  52.093  1.00 13.21           N  
ATOM    773  CA  ARG A 119      77.109 119.815  50.871  1.00 14.48           C  
ATOM    774  C   ARG A 119      78.034 118.750  50.292  1.00 13.96           C  
ATOM    775  O   ARG A 119      78.196 118.650  49.075  1.00 15.31           O  
ATOM    776  CB  ARG A 119      77.868 121.110  51.166  1.00 15.24           C  
ATOM    777  CG  ARG A 119      76.919 122.311  51.305  1.00 19.46           C  
ATOM    778  CD  ARG A 119      77.625 123.582  51.749  1.00 22.07           C  
ATOM    779  NE  ARG A 119      78.861 123.773  51.012  1.00 26.92           N  
ATOM    780  CZ  ARG A 119      80.071 123.689  51.553  1.00 27.19           C  
ATOM    781  NH1 ARG A 119      80.204 123.425  52.847  1.00 28.96           N  
ATOM    782  NH2 ARG A 119      81.145 123.846  50.792  1.00 26.64           N  
ATOM    783  N   LEU A 120      78.630 117.944  51.168  1.00 13.22           N  
ATOM    784  CA  LEU A 120      79.504 116.878  50.712  1.00 11.71           C  
ATOM    785  C   LEU A 120      78.682 115.822  49.975  1.00 14.01           C  
ATOM    786  O   LEU A 120      79.050 115.381  48.881  1.00  9.52           O  
ATOM    787  CB  LEU A 120      80.224 116.227  51.893  1.00 11.12           C  
ATOM    788  CG  LEU A 120      81.176 115.079  51.518  1.00  8.04           C  
ATOM    789  CD1 LEU A 120      82.309 115.607  50.645  1.00 12.61           C  
ATOM    790  CD2 LEU A 120      81.737 114.450  52.793  1.00  9.49           C  
ATOM    791  N   LEU A 121      77.557 115.426  50.564  1.00 13.01           N  
ATOM    792  CA  LEU A 121      76.706 114.410  49.950  1.00 12.81           C  
ATOM    793  C   LEU A 121      76.128 114.821  48.603  1.00 11.36           C  
ATOM    794  O   LEU A 121      75.760 113.963  47.800  1.00 11.89           O  
ATOM    795  CB  LEU A 121      75.573 114.011  50.903  1.00 13.63           C  
ATOM    796  CG  LEU A 121      76.085 113.345  52.183  1.00 16.75           C  
ATOM    797  CD1 LEU A 121      74.915 113.076  53.104  1.00 19.07           C  
ATOM    798  CD2 LEU A 121      76.830 112.061  51.854  1.00 20.98           C  
ATOM    799  N   ALA A 122      76.054 116.122  48.346  1.00 14.10           N  
ATOM    800  CA  ALA A 122      75.526 116.590  47.068  1.00 13.57           C  
ATOM    801  C   ALA A 122      76.399 116.126  45.898  1.00 14.83           C  
ATOM    802  O   ALA A 122      75.945 116.090  44.762  1.00 15.22           O  
ATOM    803  CB  ALA A 122      75.413 118.114  47.066  1.00 18.10           C  
ATOM    804  N   LEU A 123      77.653 115.771  46.179  1.00 12.91           N  
ATOM    805  CA  LEU A 123      78.554 115.321  45.132  1.00 13.76           C  
ATOM    806  C   LEU A 123      78.062 114.110  44.342  1.00 15.31           C  
ATOM    807  O   LEU A 123      78.446 113.942  43.190  1.00 17.13           O  
ATOM    808  CB  LEU A 123      79.936 115.014  45.713  1.00 14.48           C  
ATOM    809  CG  LEU A 123      80.749 116.196  46.236  1.00 16.36           C  
ATOM    810  CD1 LEU A 123      82.008 115.671  46.919  1.00 17.99           C  
ATOM    811  CD2 LEU A 123      81.114 117.134  45.092  1.00 17.57           C  
ATOM    812  N   SER A 124      77.218 113.266  44.931  1.00 13.70           N  
ATOM    813  CA  SER A 124      76.745 112.094  44.193  1.00 17.11           C  
ATOM    814  C   SER A 124      75.863 112.456  43.004  1.00 20.86           C  
ATOM    815  O   SER A 124      75.636 111.625  42.128  1.00 22.23           O  
ATOM    816  CB  SER A 124      76.012 111.107  45.126  1.00 15.73           C  
ATOM    817  OG  SER A 124      74.910 111.696  45.779  1.00 16.77           O  
ATOM    818  N   GLU A 125      75.383 113.695  42.956  1.00 24.77           N  
ATOM    819  CA  GLU A 125      74.519 114.127  41.859  1.00 29.54           C  
ATOM    820  C   GLU A 125      75.280 114.897  40.779  1.00 32.17           C  
ATOM    821  O   GLU A 125      74.737 115.172  39.705  1.00 33.31           O  
ATOM    822  CB  GLU A 125      73.392 115.009  42.400  1.00 32.84           C  
ATOM    823  CG  GLU A 125      72.795 114.507  43.706  1.00 38.24           C  
ATOM    824  CD  GLU A 125      72.140 113.146  43.572  1.00 41.66           C  
ATOM    825  OE1 GLU A 125      72.348 112.296  44.469  1.00 41.77           O  
ATOM    826  OE2 GLU A 125      71.411 112.928  42.578  1.00 42.02           O  
ATOM    827  N   THR A 126      76.535 115.245  41.060  1.00 33.19           N  
ATOM    828  CA  THR A 126      77.335 116.004  40.102  1.00 35.30           C  
ATOM    829  C   THR A 126      78.738 115.452  39.864  1.00 35.60           C  
ATOM    830  O   THR A 126      79.527 116.056  39.136  1.00 36.22           O  
ATOM    831  CB  THR A 126      77.488 117.465  40.552  1.00 36.45           C  
ATOM    832  OG1 THR A 126      78.162 117.512  41.816  1.00 37.22           O  
ATOM    833  CG2 THR A 126      76.130 118.126  40.684  1.00 38.60           C  
ATOM    834  N   SER A 127      79.055 114.313  40.469  1.00 32.62           N  
ATOM    835  CA  SER A 127      80.382 113.728  40.307  1.00 31.40           C  
ATOM    836  C   SER A 127      80.367 112.204  40.238  1.00 30.45           C  
ATOM    837  O   SER A 127      79.491 111.555  40.802  1.00 29.41           O  
ATOM    838  CB  SER A 127      81.284 114.172  41.462  1.00 31.32           C  
ATOM    839  OG  SER A 127      82.546 113.532  41.408  1.00 29.95           O  
ATOM    840  N   ARG A 128      81.342 111.639  39.535  1.00 31.06           N  
ATOM    841  CA  ARG A 128      81.457 110.190  39.423  1.00 31.72           C  
ATOM    842  C   ARG A 128      82.725 109.731  40.128  1.00 30.33           C  
ATOM    843  O   ARG A 128      83.061 108.552  40.107  1.00 29.60           O  
ATOM    844  CB  ARG A 128      81.506 109.753  37.955  1.00 35.07           C  
ATOM    845  CG  ARG A 128      80.170 109.788  37.231  1.00 38.06           C  
ATOM    846  CD  ARG A 128      80.331 109.342  35.786  1.00 40.58           C  
ATOM    847  NE  ARG A 128      79.086 109.441  35.029  1.00 41.72           N  
ATOM    848  CZ  ARG A 128      78.046 108.626  35.179  1.00 41.63           C  
ATOM    849  NH1 ARG A 128      78.094 107.636  36.062  1.00 40.05           N  
ATOM    850  NH2 ARG A 128      76.956 108.801  34.444  1.00 41.28           N  
ATOM    851  N   THR A 129      83.426 110.676  40.752  1.00 28.27           N  
ATOM    852  CA  THR A 129      84.663 110.369  41.460  1.00 26.86           C  
ATOM    853  C   THR A 129      84.499 110.580  42.962  1.00 24.42           C  
ATOM    854  O   THR A 129      85.114 109.878  43.763  1.00 24.47           O  
ATOM    855  CB  THR A 129      85.817 111.255  40.946  1.00 28.84           C  
ATOM    856  OG1 THR A 129      86.019 111.004  39.550  1.00 29.38           O  
ATOM    857  CG2 THR A 129      87.104 110.958  41.699  1.00 30.40           C  
ATOM    858  N   GLY A 130      83.659 111.541  43.335  1.00 19.67           N  
ATOM    859  CA  GLY A 130      83.443 111.828  44.745  1.00 18.76           C  
ATOM    860  C   GLY A 130      84.301 112.998  45.198  1.00 15.12           C  
ATOM    861  O   GLY A 130      84.842 113.721  44.371  1.00 16.78           O  
ATOM    862  N   GLY A 131      84.448 113.175  46.506  1.00 11.44           N  
ATOM    863  CA  GLY A 131      85.233 114.287  47.013  1.00 11.72           C  
ATOM    864  C   GLY A 131      85.373 114.258  48.523  1.00 11.46           C  
ATOM    865  O   GLY A 131      84.952 113.302  49.158  1.00  9.51           O  
ATOM    866  N   ILE A 132      85.960 115.299  49.100  1.00 11.88           N  
ATOM    867  CA  ILE A 132      86.172 115.351  50.538  1.00 12.66           C  
ATOM    868  C   ILE A 132      85.952 116.742  51.108  1.00 12.64           C  
ATOM    869  O   ILE A 132      85.932 117.741  50.376  1.00  9.96           O  
ATOM    870  CB  ILE A 132      87.609 114.945  50.907  1.00 12.69           C  
ATOM    871  CG1 ILE A 132      88.587 116.026  50.458  1.00 13.06           C  
ATOM    872  CG2 ILE A 132      87.959 113.635  50.232  1.00 13.28           C  
ATOM    873  CD1 ILE A 132      90.024 115.820  50.945  1.00 13.23           C  
ATOM    874  N   LEU A 133      85.766 116.802  52.421  1.00 10.86           N  
ATOM    875  CA  LEU A 133      85.641 118.088  53.095  1.00 10.31           C  
ATOM    876  C   LEU A 133      87.068 118.574  53.310  1.00 12.69           C  
ATOM    877  O   LEU A 133      87.959 117.795  53.647  1.00 11.74           O  
ATOM    878  CB  LEU A 133      84.933 117.935  54.442  1.00 13.50           C  
ATOM    879  CG  LEU A 133      83.401 117.834  54.383  1.00 11.40           C  
ATOM    880  CD1 LEU A 133      82.842 117.778  55.810  1.00 13.86           C  
ATOM    881  CD2 LEU A 133      82.825 119.047  53.630  1.00 13.48           C  
ATOM    882  N   ALA A 134      87.282 119.860  53.074  1.00 11.03           N  
ATOM    883  CA  ALA A 134      88.603 120.464  53.236  1.00 12.14           C  
ATOM    884  C   ALA A 134      88.488 121.929  53.628  1.00 15.15           C  
ATOM    885  O   ALA A 134      87.479 122.584  53.363  1.00 15.59           O  
ATOM    886  CB  ALA A 134      89.412 120.332  51.941  1.00 13.92           C  
ATOM    887  N   ALA A 135      89.534 122.436  54.266  1.00 14.72           N  
ATOM    888  CA  ALA A 135      89.558 123.823  54.697  1.00 17.58           C  
ATOM    889  C   ALA A 135      90.731 124.487  54.009  1.00 18.55           C  
ATOM    890  O   ALA A 135      91.823 123.927  53.960  1.00 16.59           O  
ATOM    891  CB  ALA A 135      89.708 123.897  56.204  1.00 17.39           C  
ATOM    892  N   PRO A 136      90.516 125.679  53.437  1.00 21.13           N  
ATOM    893  CA  PRO A 136      91.599 126.388  52.750  1.00 22.55           C  
ATOM    894  C   PRO A 136      92.724 126.801  53.701  1.00 22.84           C  
ATOM    895  O   PRO A 136      92.480 127.162  54.852  1.00 22.97           O  
ATOM    896  CB  PRO A 136      90.890 127.600  52.144  1.00 24.14           C  
ATOM    897  CG  PRO A 136      89.481 127.118  51.952  1.00 26.14           C  
ATOM    898  CD  PRO A 136      89.227 126.361  53.226  1.00 23.67           C  
ATOM    899  N   VAL A 137      93.961 126.740  53.223  1.00 23.01           N  
ATOM    900  CA  VAL A 137      95.098 127.130  54.046  1.00 25.41           C  
ATOM    901  C   VAL A 137      95.106 128.648  54.217  1.00 25.91           C  
ATOM    902  O   VAL A 137      94.962 129.395  53.247  1.00 24.88           O  
ATOM    903  CB  VAL A 137      96.430 126.685  53.405  1.00 25.02           C  
ATOM    904  CG1 VAL A 137      97.610 127.191  54.230  1.00 25.74           C  
ATOM    905  CG2 VAL A 137      96.467 125.176  53.310  1.00 25.73           C  
ATOM    906  N   ARG A 138      95.270 129.096  55.455  1.00 28.40           N  
ATOM    907  CA  ARG A 138      95.291 130.520  55.767  1.00 31.59           C  
ATOM    908  C   ARG A 138      96.717 131.012  56.013  1.00 31.31           C  
ATOM    909  O   ARG A 138      97.175 131.962  55.383  1.00 34.55           O  
ATOM    910  CB  ARG A 138      94.438 130.790  57.011  1.00 34.35           C  
ATOM    911  CG  ARG A 138      93.039 130.185  56.977  1.00 37.62           C  
ATOM    912  CD  ARG A 138      92.197 130.738  55.837  1.00 40.92           C  
ATOM    913  NE  ARG A 138      90.809 130.282  55.927  1.00 44.19           N  
ATOM    914  CZ  ARG A 138      89.836 130.663  55.104  1.00 44.83           C  
ATOM    915  NH1 ARG A 138      90.086 131.513  54.118  1.00 45.21           N  
ATOM    916  NH2 ARG A 138      88.606 130.197  55.274  1.00 45.54           N  
ATOM    917  N   ASP A 139      97.411 130.355  56.933  1.00 32.16           N  
ATOM    918  CA  ASP A 139      98.775 130.719  57.290  1.00 30.37           C  
ATOM    919  C   ASP A 139      99.760 130.622  56.132  1.00 27.21           C  
ATOM    920  O   ASP A 139      99.525 129.911  55.154  1.00 26.40           O  
ATOM    921  CB  ASP A 139      99.266 129.807  58.414  1.00 35.02           C  
ATOM    922  CG  ASP A 139      98.288 129.722  59.575  1.00 38.50           C  
ATOM    923  OD1 ASP A 139      98.215 130.682  60.369  1.00 40.51           O  
ATOM    924  OD2 ASP A 139      97.588 128.692  59.674  1.00 42.76           O  
ATOM    925  N   THR A 140     100.862 131.352  56.250  1.00 23.64           N  
ATOM    926  CA  THR A 140     101.910 131.304  55.250  1.00 20.48           C  
ATOM    927  C   THR A 140     102.623 129.993  55.548  1.00 21.07           C  
ATOM    928  O   THR A 140     102.913 129.685  56.706  1.00 17.76           O  
ATOM    929  CB  THR A 140     102.893 132.482  55.405  1.00 21.57           C  
ATOM    930  OG1 THR A 140     102.229 133.698  55.048  1.00 21.22           O  
ATOM    931  CG2 THR A 140     104.118 132.286  54.519  1.00 22.30           C  
ATOM    932  N   MET A 141     102.897 129.209  54.512  1.00 17.93           N  
ATOM    933  CA  MET A 141     103.552 127.919  54.697  1.00 19.30           C  
ATOM    934  C   MET A 141     105.006 127.936  54.269  1.00 18.44           C  
ATOM    935  O   MET A 141     105.366 128.593  53.295  1.00 17.44           O  
ATOM    936  CB  MET A 141     102.804 126.839  53.910  1.00 20.85           C  
ATOM    937  CG  MET A 141     101.312 126.755  54.224  1.00 24.75           C  
ATOM    938  SD  MET A 141     100.956 126.521  55.997  1.00 16.40           S  
ATOM    939  CE  MET A 141     101.422 124.873  56.186  1.00 27.33           C  
ATOM    940  N   LYS A 142     105.836 127.207  55.006  1.00 16.66           N  
ATOM    941  CA  LYS A 142     107.257 127.115  54.701  1.00 17.52           C  
ATOM    942  C   LYS A 142     107.669 125.658  54.502  1.00 17.96           C  
ATOM    943  O   LYS A 142     107.190 124.766  55.199  1.00 16.62           O  
ATOM    944  CB  LYS A 142     108.100 127.683  55.849  1.00 18.36           C  
ATOM    945  CG  LYS A 142     107.770 129.108  56.273  1.00 17.12           C  
ATOM    946  CD  LYS A 142     108.073 130.123  55.184  1.00 15.04           C  
ATOM    947  CE  LYS A 142     107.810 131.530  55.692  1.00 14.51           C  
ATOM    948  NZ  LYS A 142     108.149 132.577  54.691  1.00 14.93           N  
ATOM    949  N   ARG A 143     108.556 125.426  53.543  1.00 21.56           N  
ATOM    950  CA  ARG A 143     109.079 124.093  53.295  1.00 23.07           C  
ATOM    951  C   ARG A 143     110.475 124.127  53.892  1.00 23.67           C  
ATOM    952  O   ARG A 143     111.280 124.992  53.541  1.00 22.19           O  
ATOM    953  CB  ARG A 143     109.172 123.806  51.796  1.00 25.98           C  
ATOM    954  CG  ARG A 143     109.900 122.509  51.452  1.00 30.68           C  
ATOM    955  CD  ARG A 143     109.144 121.289  51.949  1.00 32.46           C  
ATOM    956  NE  ARG A 143     107.866 121.139  51.257  1.00 33.32           N  
ATOM    957  CZ  ARG A 143     106.940 120.244  51.581  1.00 34.61           C  
ATOM    958  NH1 ARG A 143     107.146 119.412  52.592  1.00 33.53           N  
ATOM    959  NH2 ARG A 143     105.808 120.182  50.892  1.00 34.66           N  
ATOM    960  N   ALA A 144     110.760 123.204  54.801  1.00 23.83           N  
ATOM    961  CA  ALA A 144     112.071 123.152  55.435  1.00 26.97           C  
ATOM    962  C   ALA A 144     113.058 122.447  54.524  1.00 29.55           C  
ATOM    963  O   ALA A 144     112.666 121.668  53.653  1.00 28.17           O  
ATOM    964  CB  ALA A 144     111.979 122.416  56.767  1.00 26.45           C  
ATOM    965  N   GLU A 145     114.338 122.733  54.714  1.00 31.76           N  
ATOM    966  CA  GLU A 145     115.360 122.087  53.912  1.00 34.49           C  
ATOM    967  C   GLU A 145     115.500 120.661  54.417  1.00 35.15           C  
ATOM    968  O   GLU A 145     115.396 120.405  55.617  1.00 34.57           O  
ATOM    969  CB  GLU A 145     116.684 122.836  54.033  1.00 35.92           C  
ATOM    970  CG  GLU A 145     116.593 124.256  53.518  1.00 39.58           C  
ATOM    971  CD  GLU A 145     117.945 124.912  53.357  1.00 43.13           C  
ATOM    972  OE1 GLU A 145     118.676 125.031  54.364  1.00 43.40           O  
ATOM    973  OE2 GLU A 145     118.277 125.301  52.216  1.00 45.01           O  
ATOM    974  N   PRO A 146     115.733 119.711  53.502  1.00 35.91           N  
ATOM    975  CA  PRO A 146     115.878 118.300  53.866  1.00 38.22           C  
ATOM    976  C   PRO A 146     116.903 118.011  54.956  1.00 38.28           C  
ATOM    977  O   PRO A 146     118.096 118.246  54.777  1.00 39.14           O  
ATOM    978  CB  PRO A 146     116.229 117.638  52.532  1.00 38.25           C  
ATOM    979  CG  PRO A 146     116.916 118.734  51.774  1.00 38.35           C  
ATOM    980  CD  PRO A 146     116.051 119.923  52.079  1.00 37.12           C  
ATOM    981  N   GLY A 147     116.419 117.515  56.090  1.00 38.84           N  
ATOM    982  CA  GLY A 147     117.304 117.173  57.186  1.00 39.97           C  
ATOM    983  C   GLY A 147     117.495 118.189  58.294  1.00 40.37           C  
ATOM    984  O   GLY A 147     118.129 117.874  59.303  1.00 40.58           O  
ATOM    985  N   LYS A 148     116.963 119.398  58.137  1.00 40.14           N  
ATOM    986  CA  LYS A 148     117.135 120.406  59.182  1.00 40.43           C  
ATOM    987  C   LYS A 148     116.027 121.446  59.280  1.00 39.20           C  
ATOM    988  O   LYS A 148     115.196 121.572  58.383  1.00 38.28           O  
ATOM    989  CB  LYS A 148     118.492 121.098  59.014  1.00 42.36           C  
ATOM    990  CG  LYS A 148     118.791 121.586  57.613  1.00 44.16           C  
ATOM    991  CD  LYS A 148     120.218 122.106  57.536  1.00 45.38           C  
ATOM    992  CE  LYS A 148     120.594 122.510  56.120  1.00 46.98           C  
ATOM    993  NZ  LYS A 148     122.021 122.943  56.043  1.00 48.14           N  
ATOM    994  N   ASN A 149     116.028 122.185  60.386  1.00 38.54           N  
ATOM    995  CA  ASN A 149     115.026 123.216  60.633  1.00 37.82           C  
ATOM    996  C   ASN A 149     115.355 124.574  60.019  1.00 35.90           C  
ATOM    997  O   ASN A 149     115.289 125.600  60.692  1.00 35.24           O  
ATOM    998  CB  ASN A 149     114.801 123.383  62.143  1.00 39.99           C  
ATOM    999  CG  ASN A 149     113.915 122.297  62.730  1.00 41.66           C  
ATOM   1000  OD1 ASN A 149     113.555 122.349  63.907  1.00 44.05           O  
ATOM   1001  ND2 ASN A 149     113.557 121.311  61.913  1.00 41.69           N  
ATOM   1002  N   ALA A 150     115.716 124.573  58.742  1.00 34.16           N  
ATOM   1003  CA  ALA A 150     116.021 125.809  58.033  1.00 30.56           C  
ATOM   1004  C   ALA A 150     115.003 125.922  56.903  1.00 29.50           C  
ATOM   1005  O   ALA A 150     114.639 124.919  56.287  1.00 25.96           O  
ATOM   1006  CB  ALA A 150     117.435 125.767  57.470  1.00 31.82           C  
ATOM   1007  N   ILE A 151     114.530 127.139  56.642  1.00 25.92           N  
ATOM   1008  CA  ILE A 151     113.545 127.367  55.592  1.00 24.75           C  
ATOM   1009  C   ILE A 151     114.148 127.291  54.194  1.00 25.19           C  
ATOM   1010  O   ILE A 151     115.047 128.059  53.852  1.00 21.41           O  
ATOM   1011  CB  ILE A 151     112.870 128.749  55.738  1.00 25.99           C  
ATOM   1012  CG1 ILE A 151     112.124 128.829  57.073  1.00 26.17           C  
ATOM   1013  CG2 ILE A 151     111.917 128.986  54.573  1.00 26.39           C  
ATOM   1014  CD1 ILE A 151     111.466 130.170  57.321  1.00 25.78           C  
ATOM   1015  N   ALA A 152     113.643 126.363  53.389  1.00 24.16           N  
ATOM   1016  CA  ALA A 152     114.108 126.215  52.017  1.00 24.95           C  
ATOM   1017  C   ALA A 152     113.437 127.303  51.180  1.00 23.80           C  
ATOM   1018  O   ALA A 152     114.091 128.027  50.432  1.00 23.19           O  
ATOM   1019  CB  ALA A 152     113.737 124.830  51.483  1.00 26.31           C  
ATOM   1020  N   HIS A 153     112.119 127.411  51.312  1.00 24.01           N  
ATOM   1021  CA  HIS A 153     111.357 128.410  50.581  1.00 24.02           C  
ATOM   1022  C   HIS A 153     109.928 128.426  51.103  1.00 23.29           C  
ATOM   1023  O   HIS A 153     109.549 127.584  51.920  1.00 21.93           O  
ATOM   1024  CB  HIS A 153     111.346 128.090  49.082  1.00 27.64           C  
ATOM   1025  CG  HIS A 153     110.778 126.744  48.756  1.00 29.21           C  
ATOM   1026  ND1 HIS A 153     111.534 125.591  48.775  1.00 30.41           N  
ATOM   1027  CD2 HIS A 153     109.519 126.364  48.430  1.00 31.04           C  
ATOM   1028  CE1 HIS A 153     110.765 124.559  48.474  1.00 32.03           C  
ATOM   1029  NE2 HIS A 153     109.538 125.002  48.261  1.00 31.26           N  
ATOM   1030  N   THR A 154     109.143 129.391  50.638  1.00 21.04           N  
ATOM   1031  CA  THR A 154     107.747 129.512  51.039  1.00 23.55           C  
ATOM   1032  C   THR A 154     106.887 128.735  50.050  1.00 23.65           C  
ATOM   1033  O   THR A 154     107.088 128.826  48.841  1.00 24.85           O  
ATOM   1034  CB  THR A 154     107.288 130.987  51.036  1.00 24.06           C  
ATOM   1035  OG1 THR A 154     108.012 131.716  52.035  1.00 21.13           O  
ATOM   1036  CG2 THR A 154     105.801 131.092  51.330  1.00 23.71           C  
ATOM   1037  N   VAL A 155     105.939 127.962  50.568  1.00 23.98           N  
ATOM   1038  CA  VAL A 155     105.042 127.182  49.723  1.00 26.23           C  
ATOM   1039  C   VAL A 155     103.778 127.991  49.454  1.00 26.73           C  
ATOM   1040  O   VAL A 155     103.086 128.389  50.387  1.00 27.37           O  
ATOM   1041  CB  VAL A 155     104.661 125.852  50.409  1.00 26.43           C  
ATOM   1042  CG1 VAL A 155     103.553 125.157  49.628  1.00 25.97           C  
ATOM   1043  CG2 VAL A 155     105.887 124.947  50.502  1.00 25.71           C  
ATOM   1044  N   ASP A 156     103.482 128.234  48.180  1.00 27.47           N  
ATOM   1045  CA  ASP A 156     102.302 128.998  47.797  1.00 29.83           C  
ATOM   1046  C   ASP A 156     101.070 128.371  48.442  1.00 29.67           C  
ATOM   1047  O   ASP A 156     100.735 127.223  48.153  1.00 28.17           O  
ATOM   1048  CB  ASP A 156     102.141 128.987  46.276  1.00 32.88           C  
ATOM   1049  CG  ASP A 156     101.292 130.138  45.771  1.00 36.31           C  
ATOM   1050  OD1 ASP A 156     100.207 130.375  46.335  1.00 36.31           O  
ATOM   1051  OD2 ASP A 156     101.710 130.803  44.804  1.00 39.68           O  
ATOM   1052  N   ARG A 157     100.397 129.119  49.310  1.00 29.41           N  
ATOM   1053  CA  ARG A 157      99.216 128.596  49.986  1.00 31.33           C  
ATOM   1054  C   ARG A 157      97.962 128.685  49.129  1.00 31.79           C  
ATOM   1055  O   ARG A 157      96.911 128.170  49.504  1.00 29.38           O  
ATOM   1056  CB  ARG A 157      98.984 129.325  51.312  1.00 31.58           C  
ATOM   1057  CG  ARG A 157      98.507 130.764  51.190  1.00 34.84           C  
ATOM   1058  CD  ARG A 157      98.339 131.383  52.571  1.00 36.17           C  
ATOM   1059  NE  ARG A 157      97.883 132.768  52.524  1.00 38.90           N  
ATOM   1060  CZ  ARG A 157      96.684 133.153  52.096  1.00 40.59           C  
ATOM   1061  NH1 ARG A 157      95.806 132.254  51.671  1.00 40.69           N  
ATOM   1062  NH2 ARG A 157      96.361 134.439  52.102  1.00 41.07           N  
ATOM   1063  N   ASN A 158      98.072 129.341  47.980  1.00 31.88           N  
ATOM   1064  CA  ASN A 158      96.939 129.474  47.077  1.00 33.05           C  
ATOM   1065  C   ASN A 158      96.667 128.123  46.419  1.00 30.55           C  
ATOM   1066  O   ASN A 158      97.524 127.573  45.728  1.00 29.44           O  
ATOM   1067  CB  ASN A 158      97.235 130.535  46.016  1.00 37.32           C  
ATOM   1068  CG  ASN A 158      96.122 130.664  44.993  1.00 40.76           C  
ATOM   1069  OD1 ASN A 158      94.962 130.898  45.341  1.00 42.95           O  
ATOM   1070  ND2 ASN A 158      96.473 130.522  43.719  1.00 42.48           N  
ATOM   1071  N   GLY A 159      95.469 127.592  46.638  1.00 27.78           N  
ATOM   1072  CA  GLY A 159      95.125 126.303  46.068  1.00 25.92           C  
ATOM   1073  C   GLY A 159      95.576 125.162  46.964  1.00 23.36           C  
ATOM   1074  O   GLY A 159      95.549 124.001  46.566  1.00 20.36           O  
ATOM   1075  N   LEU A 160      95.996 125.500  48.178  1.00 21.70           N  
ATOM   1076  CA  LEU A 160      96.447 124.504  49.144  1.00 21.05           C  
ATOM   1077  C   LEU A 160      95.318 124.331  50.151  1.00 19.95           C  
ATOM   1078  O   LEU A 160      94.771 125.313  50.658  1.00 20.16           O  
ATOM   1079  CB  LEU A 160      97.718 124.980  49.847  1.00 21.88           C  
ATOM   1080  CG  LEU A 160      98.494 123.929  50.642  1.00 22.77           C  
ATOM   1081  CD1 LEU A 160      99.025 122.852  49.704  1.00 22.12           C  
ATOM   1082  CD2 LEU A 160      99.647 124.603  51.379  1.00 22.62           C  
ATOM   1083  N   TRP A 161      94.977 123.081  50.442  1.00 18.78           N  
ATOM   1084  CA  TRP A 161      93.876 122.786  51.351  1.00 17.73           C  
ATOM   1085  C   TRP A 161      94.215 121.761  52.425  1.00 14.71           C  
ATOM   1086  O   TRP A 161      95.052 120.889  52.220  1.00 15.21           O  
ATOM   1087  CB  TRP A 161      92.674 122.246  50.556  1.00 17.92           C  
ATOM   1088  CG  TRP A 161      92.067 123.189  49.538  1.00 20.81           C  
ATOM   1089  CD1 TRP A 161      92.659 123.691  48.406  1.00 22.13           C  
ATOM   1090  CD2 TRP A 161      90.740 123.725  49.564  1.00 21.78           C  
ATOM   1091  NE1 TRP A 161      91.775 124.500  47.729  1.00 22.01           N  
ATOM   1092  CE2 TRP A 161      90.591 124.537  48.416  1.00 22.44           C  
ATOM   1093  CE3 TRP A 161      89.657 123.590  50.444  1.00 23.71           C  
ATOM   1094  CZ2 TRP A 161      89.402 125.224  48.132  1.00 25.34           C  
ATOM   1095  CZ3 TRP A 161      88.478 124.269  50.163  1.00 25.73           C  
ATOM   1096  CH2 TRP A 161      88.359 125.074  49.013  1.00 26.50           C  
ATOM   1097  N   HIS A 162      93.557 121.886  53.575  1.00 15.74           N  
ATOM   1098  CA  HIS A 162      93.703 120.944  54.670  1.00 16.47           C  
ATOM   1099  C   HIS A 162      92.661 119.854  54.394  1.00 14.60           C  
ATOM   1100  O   HIS A 162      91.472 120.154  54.326  1.00 17.00           O  
ATOM   1101  CB  HIS A 162      93.353 121.601  56.007  1.00 18.77           C  
ATOM   1102  CG  HIS A 162      94.422 122.490  56.551  1.00 23.52           C  
ATOM   1103  ND1 HIS A 162      94.595 123.793  56.136  1.00 26.68           N  
ATOM   1104  CD2 HIS A 162      95.366 122.264  57.492  1.00 22.98           C  
ATOM   1105  CE1 HIS A 162      95.601 124.331  56.803  1.00 25.37           C  
ATOM   1106  NE2 HIS A 162      96.085 123.425  57.632  1.00 26.69           N  
ATOM   1107  N   ALA A 163      93.092 118.607  54.231  1.00 13.31           N  
ATOM   1108  CA  ALA A 163      92.152 117.517  53.979  1.00 12.91           C  
ATOM   1109  C   ALA A 163      91.439 117.168  55.274  1.00 13.87           C  
ATOM   1110  O   ALA A 163      92.073 117.034  56.324  1.00 15.79           O  
ATOM   1111  CB  ALA A 163      92.889 116.302  53.454  1.00 13.91           C  
ATOM   1112  N   LEU A 164      90.115 117.057  55.229  1.00 12.48           N  
ATOM   1113  CA  LEU A 164      89.365 116.683  56.438  1.00 10.81           C  
ATOM   1114  C   LEU A 164      88.529 115.462  56.076  1.00 11.78           C  
ATOM   1115  O   LEU A 164      88.798 114.812  55.071  1.00 11.90           O  
ATOM   1116  CB  LEU A 164      88.451 117.833  56.880  1.00 12.43           C  
ATOM   1117  CG  LEU A 164      89.142 119.192  57.127  1.00 13.44           C  
ATOM   1118  CD1 LEU A 164      88.075 120.251  57.371  1.00 17.24           C  
ATOM   1119  CD2 LEU A 164      90.086 119.099  58.312  1.00 16.13           C  
ATOM   1120  N   THR A 165      87.570 115.099  56.919  1.00 12.12           N  
ATOM   1121  CA  THR A 165      86.674 113.984  56.620  1.00 10.86           C  
ATOM   1122  C   THR A 165      85.312 114.468  57.113  1.00 11.20           C  
ATOM   1123  O   THR A 165      85.232 115.382  57.938  1.00 11.71           O  
ATOM   1124  CB  THR A 165      87.079 112.644  57.329  1.00 11.05           C  
ATOM   1125  OG1 THR A 165      86.672 112.661  58.699  1.00 11.95           O  
ATOM   1126  CG2 THR A 165      88.580 112.443  57.276  1.00 14.19           C  
ATOM   1127  N   PRO A 166      84.224 113.851  56.641  1.00  9.53           N  
ATOM   1128  CA  PRO A 166      84.148 112.729  55.705  1.00  9.74           C  
ATOM   1129  C   PRO A 166      84.735 112.895  54.310  1.00 12.15           C  
ATOM   1130  O   PRO A 166      84.944 114.010  53.809  1.00 10.32           O  
ATOM   1131  CB  PRO A 166      82.647 112.452  55.620  1.00 11.72           C  
ATOM   1132  CG  PRO A 166      82.141 112.876  56.920  1.00 11.24           C  
ATOM   1133  CD  PRO A 166      82.875 114.185  57.127  1.00 11.15           C  
ATOM   1134  N   GLN A 167      84.966 111.732  53.706  1.00 10.72           N  
ATOM   1135  CA  GLN A 167      85.468 111.594  52.351  1.00  9.56           C  
ATOM   1136  C   GLN A 167      84.400 110.692  51.728  1.00 10.76           C  
ATOM   1137  O   GLN A 167      84.110 109.611  52.231  1.00 12.44           O  
ATOM   1138  CB  GLN A 167      86.870 110.985  52.381  1.00 10.66           C  
ATOM   1139  CG  GLN A 167      87.808 111.861  53.207  1.00 11.10           C  
ATOM   1140  CD  GLN A 167      89.251 111.840  52.744  1.00 12.42           C  
ATOM   1141  OE1 GLN A 167      89.664 110.977  51.965  1.00 14.05           O  
ATOM   1142  NE2 GLN A 167      90.032 112.795  53.238  1.00 12.60           N  
ATOM   1143  N   PHE A 168      83.812 111.180  50.642  1.00  9.72           N  
ATOM   1144  CA  PHE A 168      82.671 110.561  49.975  1.00  9.12           C  
ATOM   1145  C   PHE A 168      82.970 110.036  48.572  1.00  8.84           C  
ATOM   1146  O   PHE A 168      83.258 110.820  47.674  1.00 10.49           O  
ATOM   1147  CB  PHE A 168      81.589 111.651  49.931  1.00  8.98           C  
ATOM   1148  CG  PHE A 168      80.229 111.163  49.568  1.00  8.79           C  
ATOM   1149  CD1 PHE A 168      79.706 110.018  50.147  1.00  9.47           C  
ATOM   1150  CD2 PHE A 168      79.456 111.862  48.651  1.00 12.61           C  
ATOM   1151  CE1 PHE A 168      78.430 109.574  49.822  1.00 11.11           C  
ATOM   1152  CE2 PHE A 168      78.182 111.423  48.325  1.00 12.05           C  
ATOM   1153  CZ  PHE A 168      77.669 110.276  48.907  1.00 12.78           C  
ATOM   1154  N   PHE A 169      82.893 108.724  48.366  1.00 10.95           N  
ATOM   1155  CA  PHE A 169      83.196 108.186  47.035  1.00 10.43           C  
ATOM   1156  C   PHE A 169      82.304 107.016  46.634  1.00 10.35           C  
ATOM   1157  O   PHE A 169      81.633 106.420  47.462  1.00 11.47           O  
ATOM   1158  CB  PHE A 169      84.644 107.662  46.972  1.00 12.34           C  
ATOM   1159  CG  PHE A 169      85.672 108.567  47.598  1.00 14.91           C  
ATOM   1160  CD1 PHE A 169      86.115 108.335  48.891  1.00 15.81           C  
ATOM   1161  CD2 PHE A 169      86.247 109.601  46.869  1.00 17.88           C  
ATOM   1162  CE1 PHE A 169      87.114 109.116  49.450  1.00 17.55           C  
ATOM   1163  CE2 PHE A 169      87.252 110.393  47.420  1.00 17.55           C  
ATOM   1164  CZ  PHE A 169      87.688 110.142  48.712  1.00 15.60           C  
ATOM   1165  N   PRO A 170      82.266 106.694  45.332  1.00 12.42           N  
ATOM   1166  CA  PRO A 170      81.446 105.549  44.921  1.00 12.58           C  
ATOM   1167  C   PRO A 170      82.090 104.346  45.645  1.00 13.61           C  
ATOM   1168  O   PRO A 170      83.312 104.224  45.673  1.00 14.98           O  
ATOM   1169  CB  PRO A 170      81.659 105.501  43.411  1.00 12.45           C  
ATOM   1170  CG  PRO A 170      81.809 106.948  43.051  1.00 13.21           C  
ATOM   1171  CD  PRO A 170      82.702 107.489  44.172  1.00 13.30           C  
ATOM   1172  N   ARG A 171      81.268 103.483  46.230  1.00 14.72           N  
ATOM   1173  CA  ARG A 171      81.725 102.327  47.008  1.00 15.81           C  
ATOM   1174  C   ARG A 171      82.729 101.402  46.321  1.00 14.98           C  
ATOM   1175  O   ARG A 171      83.841 101.188  46.817  1.00 14.96           O  
ATOM   1176  CB  ARG A 171      80.499 101.517  47.454  1.00 18.92           C  
ATOM   1177  CG  ARG A 171      80.743 100.498  48.562  1.00 23.87           C  
ATOM   1178  CD  ARG A 171      80.990  99.089  48.030  1.00 31.62           C  
ATOM   1179  NE  ARG A 171      79.804  98.506  47.398  1.00 38.51           N  
ATOM   1180  CZ  ARG A 171      79.762  97.285  46.872  1.00 40.77           C  
ATOM   1181  NH1 ARG A 171      80.837  96.508  46.899  1.00 42.73           N  
ATOM   1182  NH2 ARG A 171      78.645  96.840  46.319  1.00 42.77           N  
ATOM   1183  N   GLU A 172      82.356 100.860  45.169  1.00 15.99           N  
ATOM   1184  CA  GLU A 172      83.263  99.945  44.500  1.00 14.72           C  
ATOM   1185  C   GLU A 172      84.547 100.615  44.028  1.00 14.64           C  
ATOM   1186  O   GLU A 172      85.627 100.022  44.113  1.00 14.37           O  
ATOM   1187  CB  GLU A 172      82.524  99.176  43.381  1.00 13.83           C  
ATOM   1188  CG  GLU A 172      81.789  97.961  43.979  1.00 16.96           C  
ATOM   1189  CD  GLU A 172      80.855  97.213  43.024  1.00 14.96           C  
ATOM   1190  OE1 GLU A 172      81.106  97.183  41.795  1.00 15.97           O  
ATOM   1191  OE2 GLU A 172      79.875  96.623  43.516  1.00 15.50           O  
ATOM   1192  N   LEU A 173      84.449 101.855  43.557  1.00 14.53           N  
ATOM   1193  CA  LEU A 173      85.639 102.579  43.101  1.00 14.88           C  
ATOM   1194  C   LEU A 173      86.607 102.751  44.269  1.00 15.64           C  
ATOM   1195  O   LEU A 173      87.815 102.568  44.109  1.00 16.09           O  
ATOM   1196  CB  LEU A 173      85.256 103.950  42.533  1.00 15.51           C  
ATOM   1197  CG  LEU A 173      86.400 104.841  42.054  1.00 18.73           C  
ATOM   1198  CD1 LEU A 173      87.132 104.179  40.891  1.00 22.30           C  
ATOM   1199  CD2 LEU A 173      85.840 106.196  41.634  1.00 21.10           C  
ATOM   1200  N   LEU A 174      86.079 103.102  45.441  1.00 15.14           N  
ATOM   1201  CA  LEU A 174      86.929 103.275  46.620  1.00 17.15           C  
ATOM   1202  C   LEU A 174      87.591 101.947  46.944  1.00 17.73           C  
ATOM   1203  O   LEU A 174      88.782 101.891  47.234  1.00 18.56           O  
ATOM   1204  CB  LEU A 174      86.102 103.739  47.829  1.00 17.97           C  
ATOM   1205  CG  LEU A 174      86.932 104.050  49.094  1.00 19.72           C  
ATOM   1206  CD1 LEU A 174      87.893 105.208  48.807  1.00 21.70           C  
ATOM   1207  CD2 LEU A 174      86.011 104.428  50.251  1.00 19.79           C  
ATOM   1208  N   HIS A 175      86.807 100.875  46.894  1.00 15.41           N  
ATOM   1209  CA  HIS A 175      87.329  99.542  47.175  1.00 17.78           C  
ATOM   1210  C   HIS A 175      88.486  99.201  46.238  1.00 17.76           C  
ATOM   1211  O   HIS A 175      89.550  98.776  46.685  1.00 19.80           O  
ATOM   1212  CB  HIS A 175      86.223  98.499  46.999  1.00 19.64           C  
ATOM   1213  CG  HIS A 175      86.711  97.083  47.009  1.00 25.47           C  
ATOM   1214  ND1 HIS A 175      86.833  96.342  48.164  1.00 26.44           N  
ATOM   1215  CD2 HIS A 175      87.123  96.275  46.001  1.00 24.29           C  
ATOM   1216  CE1 HIS A 175      87.298  95.141  47.870  1.00 27.04           C  
ATOM   1217  NE2 HIS A 175      87.483  95.075  46.564  1.00 28.03           N  
ATOM   1218  N   ASP A 176      88.277  99.386  44.941  1.00 19.49           N  
ATOM   1219  CA  ASP A 176      89.306  99.053  43.969  1.00 18.19           C  
ATOM   1220  C   ASP A 176      90.566  99.895  44.077  1.00 18.80           C  
ATOM   1221  O   ASP A 176      91.680  99.376  43.982  1.00 19.49           O  
ATOM   1222  CB  ASP A 176      88.735  99.136  42.555  1.00 18.97           C  
ATOM   1223  CG  ASP A 176      87.620  98.140  42.333  1.00 20.31           C  
ATOM   1224  OD1 ASP A 176      87.522  97.201  43.146  1.00 19.56           O  
ATOM   1225  OD2 ASP A 176      86.856  98.303  41.357  1.00 21.27           O  
ATOM   1226  N   CYS A 177      90.389 101.190  44.301  1.00 17.62           N  
ATOM   1227  CA  CYS A 177      91.525 102.093  44.418  1.00 19.95           C  
ATOM   1228  C   CYS A 177      92.395 101.806  45.627  1.00 21.48           C  
ATOM   1229  O   CYS A 177      93.621 101.837  45.539  1.00 20.89           O  
ATOM   1230  CB  CYS A 177      91.049 103.538  44.477  1.00 19.15           C  
ATOM   1231  SG  CYS A 177      90.488 104.139  42.884  1.00 16.22           S  
ATOM   1232  N   LEU A 178      91.765 101.537  46.759  1.00 21.69           N  
ATOM   1233  CA  LEU A 178      92.533 101.250  47.956  1.00 25.41           C  
ATOM   1234  C   LEU A 178      93.132  99.852  47.893  1.00 24.94           C  
ATOM   1235  O   LEU A 178      94.201  99.592  48.452  1.00 24.94           O  
ATOM   1236  CB  LEU A 178      91.662 101.437  49.197  1.00 27.89           C  
ATOM   1237  CG  LEU A 178      91.657 102.915  49.606  1.00 30.75           C  
ATOM   1238  CD1 LEU A 178      90.243 103.412  49.810  1.00 34.54           C  
ATOM   1239  CD2 LEU A 178      92.483 103.095  50.862  1.00 32.79           C  
ATOM   1240  N   THR A 179      92.456  98.956  47.189  1.00 24.29           N  
ATOM   1241  CA  THR A 179      92.954  97.596  47.045  1.00 24.74           C  
ATOM   1242  C   THR A 179      94.212  97.617  46.184  1.00 26.57           C  
ATOM   1243  O   THR A 179      95.202  96.961  46.507  1.00 26.82           O  
ATOM   1244  CB  THR A 179      91.902  96.689  46.387  1.00 23.91           C  
ATOM   1245  OG1 THR A 179      90.905  96.343  47.357  1.00 21.41           O  
ATOM   1246  CG2 THR A 179      92.554  95.421  45.841  1.00 25.11           C  
ATOM   1247  N   ARG A 180      94.173  98.380  45.096  1.00 27.86           N  
ATOM   1248  CA  ARG A 180      95.317  98.471  44.196  1.00 30.84           C  
ATOM   1249  C   ARG A 180      96.474  99.248  44.816  1.00 32.17           C  
ATOM   1250  O   ARG A 180      97.629  98.840  44.709  1.00 32.49           O  
ATOM   1251  CB  ARG A 180      94.904  99.123  42.874  1.00 33.06           C  
ATOM   1252  CG  ARG A 180      96.064  99.336  41.917  1.00 36.26           C  
ATOM   1253  CD  ARG A 180      95.594  99.798  40.548  1.00 40.27           C  
ATOM   1254  NE  ARG A 180      96.719 100.121  39.675  1.00 43.25           N  
ATOM   1255  CZ  ARG A 180      96.617 100.352  38.371  1.00 45.28           C  
ATOM   1256  NH1 ARG A 180      95.435 100.296  37.774  1.00 46.01           N  
ATOM   1257  NH2 ARG A 180      97.701 100.639  37.661  1.00 46.43           N  
ATOM   1258  N   ALA A 181      96.158 100.365  45.464  1.00 32.34           N  
ATOM   1259  CA  ALA A 181      97.177 101.197  46.100  1.00 33.75           C  
ATOM   1260  C   ALA A 181      98.002 100.388  47.098  1.00 35.05           C  
ATOM   1261  O   ALA A 181      99.223 100.529  47.165  1.00 34.31           O  
ATOM   1262  CB  ALA A 181      96.516 102.384  46.804  1.00 32.26           C  
ATOM   1263  N   LEU A 182      97.327  99.543  47.870  1.00 36.11           N  
ATOM   1264  CA  LEU A 182      97.995  98.712  48.865  1.00 38.47           C  
ATOM   1265  C   LEU A 182      98.839  97.610  48.234  1.00 40.42           C  
ATOM   1266  O   LEU A 182      99.961  97.354  48.670  1.00 40.63           O  
ATOM   1267  CB  LEU A 182      96.967  98.081  49.803  1.00 38.11           C  
ATOM   1268  CG  LEU A 182      96.282  99.011  50.804  1.00 39.34           C  
ATOM   1269  CD1 LEU A 182      95.201  98.247  51.548  1.00 38.53           C  
ATOM   1270  CD2 LEU A 182      97.312  99.570  51.784  1.00 38.55           C  
ATOM   1271  N   ASN A 183      98.292  96.957  47.213  1.00 41.48           N  
ATOM   1272  CA  ASN A 183      98.996  95.878  46.531  1.00 43.56           C  
ATOM   1273  C   ASN A 183     100.296  96.367  45.907  1.00 44.32           C  
ATOM   1274  O   ASN A 183     101.291  95.641  45.870  1.00 45.12           O  
ATOM   1275  CB  ASN A 183      98.115  95.274  45.434  1.00 44.64           C  
ATOM   1276  CG  ASN A 183      98.797  94.129  44.704  1.00 47.16           C  
ATOM   1277  OD1 ASN A 183      98.451  93.808  43.566  1.00 48.42           O  
ATOM   1278  ND2 ASN A 183      99.765  93.498  45.364  1.00 48.44           N  
ATOM   1279  N   GLU A 184     100.283  97.597  45.408  1.00 43.69           N  
ATOM   1280  CA  GLU A 184     101.464  98.170  44.777  1.00 44.16           C  
ATOM   1281  C   GLU A 184     102.345  98.929  45.763  1.00 43.70           C  
ATOM   1282  O   GLU A 184     103.264  99.643  45.362  1.00 43.57           O  
ATOM   1283  CB  GLU A 184     101.044  99.089  43.627  1.00 44.89           C  
ATOM   1284  CG  GLU A 184     100.491  98.343  42.422  1.00 46.36           C  
ATOM   1285  CD  GLU A 184     100.022  99.267  41.318  1.00 46.65           C  
ATOM   1286  OE1 GLU A 184     100.759 100.215  40.975  1.00 48.47           O  
ATOM   1287  OE2 GLU A 184      98.920  99.044  40.781  1.00 48.74           O  
ATOM   1288  N   GLY A 185     102.061  98.767  47.052  1.00 43.72           N  
ATOM   1289  CA  GLY A 185     102.845  99.432  48.079  1.00 43.81           C  
ATOM   1290  C   GLY A 185     102.961 100.938  47.928  1.00 43.73           C  
ATOM   1291  O   GLY A 185     104.048 101.499  48.070  1.00 44.09           O  
ATOM   1292  N   ALA A 186     101.843 101.600  47.648  1.00 43.02           N  
ATOM   1293  CA  ALA A 186     101.838 103.047  47.490  1.00 42.05           C  
ATOM   1294  C   ALA A 186     101.708 103.731  48.845  1.00 41.25           C  
ATOM   1295  O   ALA A 186     101.171 103.155  49.790  1.00 41.23           O  
ATOM   1296  CB  ALA A 186     100.689 103.467  46.580  1.00 42.28           C  
ATOM   1297  N   THR A 187     102.213 104.957  48.934  1.00 41.26           N  
ATOM   1298  CA  THR A 187     102.142 105.732  50.168  1.00 40.52           C  
ATOM   1299  C   THR A 187     100.733 106.297  50.301  1.00 39.02           C  
ATOM   1300  O   THR A 187     100.372 107.251  49.614  1.00 39.66           O  
ATOM   1301  CB  THR A 187     103.148 106.899  50.151  1.00 41.75           C  
ATOM   1302  OG1 THR A 187     104.470 106.388  49.935  1.00 43.36           O  
ATOM   1303  CG2 THR A 187     103.111 107.657  51.471  1.00 42.45           C  
ATOM   1304  N   ILE A 188      99.944 105.705  51.191  1.00 36.84           N  
ATOM   1305  CA  ILE A 188      98.566 106.135  51.395  1.00 34.85           C  
ATOM   1306  C   ILE A 188      98.368 106.903  52.702  1.00 31.89           C  
ATOM   1307  O   ILE A 188      98.837 106.482  53.761  1.00 31.93           O  
ATOM   1308  CB  ILE A 188      97.611 104.919  51.396  1.00 35.39           C  
ATOM   1309  CG1 ILE A 188      97.866 104.063  50.158  1.00 36.94           C  
ATOM   1310  CG2 ILE A 188      96.164 105.391  51.409  1.00 35.96           C  
ATOM   1311  CD1 ILE A 188      97.071 102.778  50.130  1.00 38.12           C  
ATOM   1312  N   THR A 189      97.674 108.034  52.612  1.00 27.22           N  
ATOM   1313  CA  THR A 189      97.370 108.849  53.777  1.00 24.79           C  
ATOM   1314  C   THR A 189      95.870 108.738  54.013  1.00 22.79           C  
ATOM   1315  O   THR A 189      95.430 107.932  54.838  1.00 23.52           O  
ATOM   1316  CB  THR A 189      97.775 110.324  53.559  1.00 23.96           C  
ATOM   1317  OG1 THR A 189      97.367 110.746  52.254  1.00 21.45           O  
ATOM   1318  CG2 THR A 189      99.289 110.487  53.689  1.00 25.23           C  
ATOM   1319  N   ASP A 190      95.077 109.523  53.289  1.00 20.32           N  
ATOM   1320  CA  ASP A 190      93.625 109.447  53.439  1.00 16.88           C  
ATOM   1321  C   ASP A 190      93.029 108.660  52.262  1.00 15.31           C  
ATOM   1322  O   ASP A 190      93.759 108.179  51.404  1.00 16.74           O  
ATOM   1323  CB  ASP A 190      93.000 110.850  53.533  1.00 15.81           C  
ATOM   1324  CG  ASP A 190      93.311 111.741  52.338  1.00 15.60           C  
ATOM   1325  OD1 ASP A 190      94.059 111.342  51.434  1.00 15.12           O  
ATOM   1326  OD2 ASP A 190      92.797 112.884  52.295  1.00 14.78           O  
ATOM   1327  N   GLU A 191      91.710 108.498  52.255  1.00 15.41           N  
ATOM   1328  CA  GLU A 191      91.051 107.759  51.201  1.00 15.29           C  
ATOM   1329  C   GLU A 191      91.243 108.462  49.862  1.00 13.97           C  
ATOM   1330  O   GLU A 191      91.414 107.818  48.818  1.00 15.48           O  
ATOM   1331  CB  GLU A 191      89.554 107.592  51.491  1.00 15.16           C  
ATOM   1332  CG  GLU A 191      89.220 106.616  52.623  1.00 20.06           C  
ATOM   1333  CD  GLU A 191      89.739 107.080  53.976  1.00 19.05           C  
ATOM   1334  OE1 GLU A 191      89.524 108.254  54.319  1.00 18.67           O  
ATOM   1335  OE2 GLU A 191      90.342 106.271  54.701  1.00 20.76           O  
ATOM   1336  N   ALA A 192      91.234 109.787  49.877  1.00 13.90           N  
ATOM   1337  CA  ALA A 192      91.412 110.537  48.642  1.00 12.75           C  
ATOM   1338  C   ALA A 192      92.735 110.154  47.991  1.00 15.62           C  
ATOM   1339  O   ALA A 192      92.789 109.930  46.791  1.00 15.97           O  
ATOM   1340  CB  ALA A 192      91.376 112.043  48.930  1.00 17.23           C  
ATOM   1341  N   SER A 193      93.792 110.044  48.792  1.00 15.73           N  
ATOM   1342  CA  SER A 193      95.107 109.704  48.248  1.00 14.82           C  
ATOM   1343  C   SER A 193      95.115 108.364  47.516  1.00 17.27           C  
ATOM   1344  O   SER A 193      95.983 108.125  46.687  1.00 16.36           O  
ATOM   1345  CB  SER A 193      96.168 109.698  49.357  1.00 12.80           C  
ATOM   1346  OG  SER A 193      96.036 108.582  50.206  1.00 16.50           O  
ATOM   1347  N   ALA A 194      94.162 107.490  47.825  1.00 15.49           N  
ATOM   1348  CA  ALA A 194      94.100 106.201  47.147  1.00 18.15           C  
ATOM   1349  C   ALA A 194      93.533 106.420  45.747  1.00 18.30           C  
ATOM   1350  O   ALA A 194      93.983 105.803  44.772  1.00 18.39           O  
ATOM   1351  CB  ALA A 194      93.246 105.222  47.927  1.00 19.02           C  
ATOM   1352  N   LEU A 195      92.544 107.300  45.641  1.00 18.26           N  
ATOM   1353  CA  LEU A 195      91.957 107.614  44.341  1.00 19.56           C  
ATOM   1354  C   LEU A 195      92.996 108.328  43.488  1.00 18.95           C  
ATOM   1355  O   LEU A 195      93.135 108.058  42.294  1.00 18.73           O  
ATOM   1356  CB  LEU A 195      90.728 108.516  44.512  1.00 21.14           C  
ATOM   1357  CG  LEU A 195      89.356 107.872  44.753  1.00 25.76           C  
ATOM   1358  CD1 LEU A 195      88.859 107.261  43.467  1.00 28.55           C  
ATOM   1359  CD2 LEU A 195      89.446 106.840  45.862  1.00 24.70           C  
ATOM   1360  N   GLU A 196      93.728 109.243  44.115  1.00 18.02           N  
ATOM   1361  CA  GLU A 196      94.763 110.019  43.435  1.00 18.47           C  
ATOM   1362  C   GLU A 196      95.820 109.096  42.838  1.00 20.50           C  
ATOM   1363  O   GLU A 196      96.251 109.292  41.708  1.00 18.68           O  
ATOM   1364  CB  GLU A 196      95.414 110.979  44.437  1.00 19.47           C  
ATOM   1365  CG  GLU A 196      94.489 112.093  44.929  1.00 18.17           C  
ATOM   1366  CD  GLU A 196      94.940 112.690  46.249  1.00 19.88           C  
ATOM   1367  OE1 GLU A 196      96.163 112.860  46.443  1.00 18.23           O  
ATOM   1368  OE2 GLU A 196      94.072 113.005  47.095  1.00 16.95           O  
ATOM   1369  N   TYR A 197      96.224 108.090  43.606  1.00 22.27           N  
ATOM   1370  CA  TYR A 197      97.233 107.139  43.158  1.00 25.65           C  
ATOM   1371  C   TYR A 197      96.807 106.403  41.888  1.00 26.33           C  
ATOM   1372  O   TYR A 197      97.641 106.040  41.058  1.00 25.33           O  
ATOM   1373  CB  TYR A 197      97.517 106.125  44.260  1.00 28.24           C  
ATOM   1374  CG  TYR A 197      98.497 105.050  43.862  1.00 33.39           C  
ATOM   1375  CD1 TYR A 197      99.848 105.340  43.686  1.00 35.84           C  
ATOM   1376  CD2 TYR A 197      98.069 103.742  43.649  1.00 35.28           C  
ATOM   1377  CE1 TYR A 197     100.751 104.349  43.307  1.00 38.38           C  
ATOM   1378  CE2 TYR A 197      98.961 102.745  43.268  1.00 37.55           C  
ATOM   1379  CZ  TYR A 197     100.300 103.056  43.099  1.00 37.58           C  
ATOM   1380  OH  TYR A 197     101.184 102.071  42.721  1.00 38.50           O  
ATOM   1381  N   CYS A 198      95.505 106.178  41.750  1.00 24.84           N  
ATOM   1382  CA  CYS A 198      94.955 105.483  40.595  1.00 26.42           C  
ATOM   1383  C   CYS A 198      94.549 106.414  39.449  1.00 26.17           C  
ATOM   1384  O   CYS A 198      93.819 106.009  38.540  1.00 26.84           O  
ATOM   1385  CB  CYS A 198      93.756 104.631  41.035  1.00 25.63           C  
ATOM   1386  SG  CYS A 198      94.173 103.388  42.322  1.00 21.20           S  
ATOM   1387  N   GLY A 199      95.004 107.665  39.509  1.00 24.90           N  
ATOM   1388  CA  GLY A 199      94.722 108.621  38.451  1.00 24.25           C  
ATOM   1389  C   GLY A 199      93.478 109.478  38.575  1.00 24.03           C  
ATOM   1390  O   GLY A 199      93.133 110.204  37.639  1.00 22.33           O  
ATOM   1391  N   PHE A 200      92.803 109.406  39.716  1.00 24.23           N  
ATOM   1392  CA  PHE A 200      91.599 110.192  39.928  1.00 25.98           C  
ATOM   1393  C   PHE A 200      91.867 111.511  40.645  1.00 25.41           C  
ATOM   1394  O   PHE A 200      92.892 111.678  41.309  1.00 24.45           O  
ATOM   1395  CB  PHE A 200      90.570 109.372  40.709  1.00 26.45           C  
ATOM   1396  CG  PHE A 200      90.076 108.166  39.968  1.00 26.98           C  
ATOM   1397  CD1 PHE A 200      90.671 106.925  40.151  1.00 26.61           C  
ATOM   1398  CD2 PHE A 200      89.042 108.281  39.049  1.00 27.63           C  
ATOM   1399  CE1 PHE A 200      90.244 105.813  39.424  1.00 28.20           C  
ATOM   1400  CE2 PHE A 200      88.610 107.176  38.318  1.00 27.10           C  
ATOM   1401  CZ  PHE A 200      89.214 105.944  38.508  1.00 27.05           C  
ATOM   1402  N   HIS A 201      90.934 112.448  40.503  1.00 23.75           N  
ATOM   1403  CA  HIS A 201      91.056 113.758  41.128  1.00 24.17           C  
ATOM   1404  C   HIS A 201      89.755 114.154  41.831  1.00 22.02           C  
ATOM   1405  O   HIS A 201      88.925 114.861  41.263  1.00 21.81           O  
ATOM   1406  CB  HIS A 201      91.425 114.800  40.068  1.00 25.41           C  
ATOM   1407  CG  HIS A 201      92.709 114.501  39.357  1.00 28.54           C  
ATOM   1408  ND1 HIS A 201      92.832 113.486  38.434  1.00 31.16           N  
ATOM   1409  CD2 HIS A 201      93.937 115.061  39.464  1.00 28.60           C  
ATOM   1410  CE1 HIS A 201      94.079 113.432  38.003  1.00 29.68           C  
ATOM   1411  NE2 HIS A 201      94.771 114.377  38.612  1.00 30.49           N  
ATOM   1412  N   PRO A 202      89.561 113.691  43.078  1.00 21.26           N  
ATOM   1413  CA  PRO A 202      88.363 113.985  43.874  1.00 20.27           C  
ATOM   1414  C   PRO A 202      88.123 115.479  44.087  1.00 18.43           C  
ATOM   1415  O   PRO A 202      89.063 116.282  44.128  1.00 17.44           O  
ATOM   1416  CB  PRO A 202      88.639 113.266  45.190  1.00 20.80           C  
ATOM   1417  CG  PRO A 202      89.498 112.112  44.774  1.00 20.66           C  
ATOM   1418  CD  PRO A 202      90.448 112.766  43.804  1.00 19.84           C  
ATOM   1419  N   GLN A 203      86.854 115.842  44.242  1.00 17.79           N  
ATOM   1420  CA  GLN A 203      86.484 117.231  44.456  1.00 18.84           C  
ATOM   1421  C   GLN A 203      86.759 117.699  45.878  1.00 18.88           C  
ATOM   1422  O   GLN A 203      86.759 116.912  46.822  1.00 17.28           O  
ATOM   1423  CB  GLN A 203      85.001 117.442  44.129  1.00 22.48           C  
ATOM   1424  CG  GLN A 203      84.690 117.377  42.647  1.00 29.36           C  
ATOM   1425  CD  GLN A 203      85.382 118.483  41.872  1.00 32.17           C  
ATOM   1426  OE1 GLN A 203      85.155 119.666  42.123  1.00 35.36           O  
ATOM   1427  NE2 GLN A 203      86.231 118.102  40.926  1.00 35.94           N  
ATOM   1428  N   LEU A 204      87.016 118.993  46.006  1.00 16.27           N  
ATOM   1429  CA  LEU A 204      87.269 119.620  47.295  1.00 15.41           C  
ATOM   1430  C   LEU A 204      86.019 120.415  47.654  1.00 16.28           C  
ATOM   1431  O   LEU A 204      85.631 121.325  46.927  1.00 19.65           O  
ATOM   1432  CB  LEU A 204      88.476 120.557  47.187  1.00 15.22           C  
ATOM   1433  CG  LEU A 204      89.825 119.846  47.058  1.00 15.25           C  
ATOM   1434  CD1 LEU A 204      90.873 120.780  46.464  1.00 16.29           C  
ATOM   1435  CD2 LEU A 204      90.245 119.361  48.435  1.00 14.65           C  
ATOM   1436  N   VAL A 205      85.376 120.050  48.756  1.00 16.47           N  
ATOM   1437  CA  VAL A 205      84.179 120.742  49.213  1.00 15.56           C  
ATOM   1438  C   VAL A 205      84.587 121.471  50.480  1.00 15.52           C  
ATOM   1439  O   VAL A 205      84.922 120.838  51.480  1.00 14.79           O  
ATOM   1440  CB  VAL A 205      83.043 119.747  49.539  1.00 16.34           C  
ATOM   1441  CG1 VAL A 205      81.819 120.488  50.045  1.00 16.62           C  
ATOM   1442  CG2 VAL A 205      82.694 118.944  48.294  1.00 15.52           C  
ATOM   1443  N   GLU A 206      84.570 122.798  50.441  1.00 16.44           N  
ATOM   1444  CA  GLU A 206      84.977 123.571  51.604  1.00 17.09           C  
ATOM   1445  C   GLU A 206      84.121 123.314  52.837  1.00 19.19           C  
ATOM   1446  O   GLU A 206      82.890 123.346  52.781  1.00 19.95           O  
ATOM   1447  CB  GLU A 206      84.999 125.068  51.274  1.00 19.33           C  
ATOM   1448  CG  GLU A 206      85.116 125.946  52.509  1.00 24.96           C  
ATOM   1449  CD  GLU A 206      85.682 127.315  52.210  1.00 26.36           C  
ATOM   1450  OE1 GLU A 206      85.415 127.845  51.113  1.00 28.49           O  
ATOM   1451  OE2 GLU A 206      86.377 127.864  53.086  1.00 27.63           O  
ATOM   1452  N   GLY A 207      84.798 123.059  53.949  1.00 19.07           N  
ATOM   1453  CA  GLY A 207      84.115 122.801  55.199  1.00 17.68           C  
ATOM   1454  C   GLY A 207      84.689 123.654  56.310  1.00 21.14           C  
ATOM   1455  O   GLY A 207      85.721 124.305  56.138  1.00 20.33           O  
ATOM   1456  N   ARG A 208      84.017 123.657  57.453  1.00 20.39           N  
ATOM   1457  CA  ARG A 208      84.460 124.442  58.599  1.00 22.06           C  
ATOM   1458  C   ARG A 208      85.791 123.949  59.160  1.00 21.62           C  
ATOM   1459  O   ARG A 208      86.031 122.745  59.260  1.00 18.88           O  
ATOM   1460  CB  ARG A 208      83.407 124.388  59.703  1.00 23.48           C  
ATOM   1461  CG  ARG A 208      82.028 124.881  59.312  1.00 26.81           C  
ATOM   1462  CD  ARG A 208      81.048 124.558  60.428  1.00 30.41           C  
ATOM   1463  NE  ARG A 208      81.510 125.097  61.707  1.00 34.02           N  
ATOM   1464  CZ  ARG A 208      81.111 126.259  62.213  1.00 36.99           C  
ATOM   1465  NH1 ARG A 208      80.233 127.003  61.553  1.00 38.24           N  
ATOM   1466  NH2 ARG A 208      81.600 126.684  63.371  1.00 37.59           N  
ATOM   1467  N   ALA A 209      86.645 124.888  59.551  1.00 21.32           N  
ATOM   1468  CA  ALA A 209      87.948 124.553  60.103  1.00 21.94           C  
ATOM   1469  C   ALA A 209      87.850 123.994  61.522  1.00 22.57           C  
ATOM   1470  O   ALA A 209      88.813 123.423  62.028  1.00 24.30           O  
ATOM   1471  CB  ALA A 209      88.846 125.787  60.093  1.00 23.71           C  
ATOM   1472  N   ASP A 210      86.693 124.153  62.162  1.00 23.23           N  
ATOM   1473  CA  ASP A 210      86.507 123.658  63.526  1.00 23.71           C  
ATOM   1474  C   ASP A 210      86.250 122.152  63.555  1.00 22.01           C  
ATOM   1475  O   ASP A 210      86.046 121.565  64.613  1.00 19.76           O  
ATOM   1476  CB  ASP A 210      85.363 124.407  64.223  1.00 26.55           C  
ATOM   1477  CG  ASP A 210      84.018 124.188  63.558  1.00 29.37           C  
ATOM   1478  OD1 ASP A 210      83.988 123.819  62.377  1.00 28.46           O  
ATOM   1479  OD2 ASP A 210      82.984 124.400  64.227  1.00 34.82           O  
ATOM   1480  N   ASN A 211      86.275 121.531  62.380  1.00 21.50           N  
ATOM   1481  CA  ASN A 211      86.079 120.088  62.252  1.00 19.05           C  
ATOM   1482  C   ASN A 211      87.450 119.457  62.493  1.00 20.58           C  
ATOM   1483  O   ASN A 211      88.102 118.981  61.567  1.00 22.66           O  
ATOM   1484  CB  ASN A 211      85.552 119.780  60.844  1.00 19.30           C  
ATOM   1485  CG  ASN A 211      85.352 118.297  60.587  1.00 18.08           C  
ATOM   1486  OD1 ASN A 211      85.251 117.489  61.510  1.00 16.95           O  
ATOM   1487  ND2 ASN A 211      85.269 117.936  59.314  1.00 13.78           N  
ATOM   1488  N   ILE A 212      87.880 119.468  63.754  1.00 19.96           N  
ATOM   1489  CA  ILE A 212      89.188 118.940  64.127  1.00 21.27           C  
ATOM   1490  C   ILE A 212      89.185 117.481  64.570  1.00 20.74           C  
ATOM   1491  O   ILE A 212      88.148 116.929  64.936  1.00 18.46           O  
ATOM   1492  CB  ILE A 212      89.808 119.782  65.264  1.00 22.94           C  
ATOM   1493  CG1 ILE A 212      88.908 119.723  66.505  1.00 24.01           C  
ATOM   1494  CG2 ILE A 212      89.991 121.217  64.796  1.00 23.32           C  
ATOM   1495  CD1 ILE A 212      89.567 120.233  67.780  1.00 26.92           C  
ATOM   1496  N   LYS A 213      90.362 116.863  64.534  1.00 20.65           N  
ATOM   1497  CA  LYS A 213      90.520 115.479  64.954  1.00 21.50           C  
ATOM   1498  C   LYS A 213      91.235 115.472  66.294  1.00 23.55           C  
ATOM   1499  O   LYS A 213      92.319 116.036  66.428  1.00 23.47           O  
ATOM   1500  CB  LYS A 213      91.341 114.688  63.933  1.00 23.47           C  
ATOM   1501  CG  LYS A 213      91.514 113.222  64.307  1.00 28.73           C  
ATOM   1502  CD  LYS A 213      92.096 112.394  63.173  1.00 31.51           C  
ATOM   1503  CE  LYS A 213      93.505 112.814  62.823  1.00 34.79           C  
ATOM   1504  NZ  LYS A 213      94.065 111.969  61.725  1.00 36.88           N  
ATOM   1505  N   VAL A 214      90.618 114.846  67.288  1.00 22.71           N  
ATOM   1506  CA  VAL A 214      91.210 114.777  68.616  1.00 23.71           C  
ATOM   1507  C   VAL A 214      92.330 113.744  68.616  1.00 25.18           C  
ATOM   1508  O   VAL A 214      92.081 112.538  68.551  1.00 25.73           O  
ATOM   1509  CB  VAL A 214      90.157 114.400  69.676  1.00 23.39           C  
ATOM   1510  CG1 VAL A 214      90.792 114.376  71.058  1.00 22.04           C  
ATOM   1511  CG2 VAL A 214      89.011 115.403  69.640  1.00 21.27           C  
ATOM   1512  N   THR A 215      93.566 114.228  68.687  1.00 28.03           N  
ATOM   1513  CA  THR A 215      94.729 113.353  68.680  1.00 30.04           C  
ATOM   1514  C   THR A 215      95.617 113.582  69.900  1.00 31.16           C  
ATOM   1515  O   THR A 215      96.188 112.640  70.448  1.00 30.69           O  
ATOM   1516  CB  THR A 215      95.566 113.578  67.407  1.00 31.50           C  
ATOM   1517  OG1 THR A 215      94.724 113.463  66.250  1.00 34.15           O  
ATOM   1518  CG2 THR A 215      96.675 112.546  67.315  1.00 33.91           C  
ATOM   1519  N   ARG A 216      95.733 114.838  70.316  1.00 32.82           N  
ATOM   1520  CA  ARG A 216      96.552 115.186  71.470  1.00 34.34           C  
ATOM   1521  C   ARG A 216      95.676 115.568  72.660  1.00 34.82           C  
ATOM   1522  O   ARG A 216      94.514 115.939  72.495  1.00 33.52           O  
ATOM   1523  CB  ARG A 216      97.492 116.348  71.137  1.00 36.66           C  
ATOM   1524  CG  ARG A 216      98.652 115.996  70.210  1.00 41.12           C  
ATOM   1525  CD  ARG A 216      98.314 116.224  68.744  1.00 44.27           C  
ATOM   1526  NE  ARG A 216      99.467 115.952  67.886  1.00 47.37           N  
ATOM   1527  CZ  ARG A 216      99.500 116.155  66.572  1.00 48.55           C  
ATOM   1528  NH1 ARG A 216      98.439 116.641  65.939  1.00 49.01           N  
ATOM   1529  NH2 ARG A 216     100.602 115.876  65.888  1.00 49.57           N  
ATOM   1530  N   PRO A 217      96.229 115.486  73.880  1.00 35.15           N  
ATOM   1531  CA  PRO A 217      95.516 115.818  75.116  1.00 35.23           C  
ATOM   1532  C   PRO A 217      94.737 117.133  75.060  1.00 34.41           C  
ATOM   1533  O   PRO A 217      93.572 117.190  75.459  1.00 35.47           O  
ATOM   1534  CB  PRO A 217      96.636 115.853  76.150  1.00 35.21           C  
ATOM   1535  CG  PRO A 217      97.551 114.780  75.662  1.00 35.97           C  
ATOM   1536  CD  PRO A 217      97.611 115.066  74.177  1.00 35.33           C  
ATOM   1537  N   GLU A 218      95.377 118.185  74.556  1.00 34.72           N  
ATOM   1538  CA  GLU A 218      94.742 119.495  74.470  1.00 35.28           C  
ATOM   1539  C   GLU A 218      93.563 119.524  73.507  1.00 34.39           C  
ATOM   1540  O   GLU A 218      92.656 120.343  73.655  1.00 34.26           O  
ATOM   1541  CB  GLU A 218      95.758 120.558  74.039  1.00 38.40           C  
ATOM   1542  CG  GLU A 218      96.282 120.381  72.619  1.00 41.66           C  
ATOM   1543  CD  GLU A 218      97.562 119.570  72.560  1.00 44.18           C  
ATOM   1544  OE1 GLU A 218      97.641 118.519  73.236  1.00 45.04           O  
ATOM   1545  OE2 GLU A 218      98.486 119.980  71.825  1.00 44.87           O  
ATOM   1546  N   ASP A 219      93.580 118.636  72.518  1.00 32.70           N  
ATOM   1547  CA  ASP A 219      92.504 118.590  71.529  1.00 32.40           C  
ATOM   1548  C   ASP A 219      91.130 118.328  72.136  1.00 31.10           C  
ATOM   1549  O   ASP A 219      90.123 118.800  71.612  1.00 29.26           O  
ATOM   1550  CB  ASP A 219      92.790 117.531  70.458  1.00 33.00           C  
ATOM   1551  CG  ASP A 219      93.989 117.881  69.596  1.00 34.05           C  
ATOM   1552  OD1 ASP A 219      94.246 119.087  69.386  1.00 36.67           O  
ATOM   1553  OD2 ASP A 219      94.663 116.950  69.111  1.00 33.93           O  
ATOM   1554  N   LEU A 220      91.080 117.579  73.233  1.00 30.71           N  
ATOM   1555  CA  LEU A 220      89.800 117.271  73.865  1.00 30.09           C  
ATOM   1556  C   LEU A 220      89.095 118.539  74.329  1.00 29.24           C  
ATOM   1557  O   LEU A 220      87.923 118.763  74.018  1.00 27.15           O  
ATOM   1558  CB  LEU A 220      90.001 116.333  75.058  1.00 31.88           C  
ATOM   1559  CG  LEU A 220      88.724 115.746  75.668  1.00 32.72           C  
ATOM   1560  CD1 LEU A 220      88.051 114.823  74.657  1.00 34.06           C  
ATOM   1561  CD2 LEU A 220      89.066 114.975  76.931  1.00 34.40           C  
ATOM   1562  N   ALA A 221      89.817 119.370  75.074  1.00 29.21           N  
ATOM   1563  CA  ALA A 221      89.264 120.618  75.586  1.00 29.34           C  
ATOM   1564  C   ALA A 221      88.808 121.527  74.446  1.00 27.22           C  
ATOM   1565  O   ALA A 221      87.773 122.180  74.544  1.00 27.43           O  
ATOM   1566  CB  ALA A 221      90.302 121.332  76.443  1.00 30.73           C  
ATOM   1567  N   LEU A 222      89.587 121.562  73.369  1.00 26.53           N  
ATOM   1568  CA  LEU A 222      89.252 122.388  72.216  1.00 26.41           C  
ATOM   1569  C   LEU A 222      88.002 121.861  71.518  1.00 25.37           C  
ATOM   1570  O   LEU A 222      87.138 122.637  71.101  1.00 23.23           O  
ATOM   1571  CB  LEU A 222      90.421 122.426  71.225  1.00 26.16           C  
ATOM   1572  CG  LEU A 222      90.229 123.257  69.952  1.00 27.48           C  
ATOM   1573  CD1 LEU A 222      89.868 124.690  70.313  1.00 28.11           C  
ATOM   1574  CD2 LEU A 222      91.502 123.231  69.121  1.00 28.79           C  
ATOM   1575  N   ALA A 223      87.908 120.543  71.384  1.00 25.46           N  
ATOM   1576  CA  ALA A 223      86.747 119.934  70.739  1.00 25.00           C  
ATOM   1577  C   ALA A 223      85.487 120.304  71.515  1.00 26.96           C  
ATOM   1578  O   ALA A 223      84.462 120.653  70.928  1.00 24.40           O  
ATOM   1579  CB  ALA A 223      86.907 118.418  70.694  1.00 26.16           C  
ATOM   1580  N   GLU A 224      85.573 120.234  72.839  1.00 28.36           N  
ATOM   1581  CA  GLU A 224      84.438 120.572  73.687  1.00 31.78           C  
ATOM   1582  C   GLU A 224      84.038 122.027  73.468  1.00 31.99           C  
ATOM   1583  O   GLU A 224      82.854 122.357  73.451  1.00 31.36           O  
ATOM   1584  CB  GLU A 224      84.790 120.341  75.155  1.00 33.72           C  
ATOM   1585  CG  GLU A 224      83.730 120.834  76.118  1.00 38.12           C  
ATOM   1586  CD  GLU A 224      83.983 120.385  77.541  1.00 40.42           C  
ATOM   1587  OE1 GLU A 224      85.132 120.522  78.015  1.00 41.78           O  
ATOM   1588  OE2 GLU A 224      83.031 119.904  78.187  1.00 42.04           O  
ATOM   1589  N   PHE A 225      85.037 122.888  73.296  1.00 31.05           N  
ATOM   1590  CA  PHE A 225      84.795 124.303  73.063  1.00 32.52           C  
ATOM   1591  C   PHE A 225      84.004 124.481  71.771  1.00 32.90           C  
ATOM   1592  O   PHE A 225      83.012 125.208  71.735  1.00 33.20           O  
ATOM   1593  CB  PHE A 225      86.124 125.056  72.963  1.00 32.52           C  
ATOM   1594  CG  PHE A 225      85.981 126.477  72.498  1.00 32.40           C  
ATOM   1595  CD1 PHE A 225      85.373 127.431  73.309  1.00 31.91           C  
ATOM   1596  CD2 PHE A 225      86.414 126.852  71.229  1.00 32.40           C  
ATOM   1597  CE1 PHE A 225      85.201 128.741  72.866  1.00 31.19           C  
ATOM   1598  CE2 PHE A 225      86.246 128.159  70.775  1.00 31.83           C  
ATOM   1599  CZ  PHE A 225      85.634 129.105  71.594  1.00 31.49           C  
ATOM   1600  N   TYR A 226      84.451 123.813  70.712  1.00 32.89           N  
ATOM   1601  CA  TYR A 226      83.790 123.893  69.410  1.00 34.21           C  
ATOM   1602  C   TYR A 226      82.381 123.316  69.436  1.00 35.89           C  
ATOM   1603  O   TYR A 226      81.448 123.905  68.892  1.00 36.27           O  
ATOM   1604  CB  TYR A 226      84.620 123.154  68.356  1.00 32.51           C  
ATOM   1605  CG  TYR A 226      85.849 123.902  67.901  1.00 31.12           C  
ATOM   1606  CD1 TYR A 226      86.987 123.217  67.489  1.00 30.49           C  
ATOM   1607  CD2 TYR A 226      85.865 125.295  67.852  1.00 31.95           C  
ATOM   1608  CE1 TYR A 226      88.114 123.898  67.040  1.00 31.32           C  
ATOM   1609  CE2 TYR A 226      86.985 125.988  67.404  1.00 31.24           C  
ATOM   1610  CZ  TYR A 226      88.104 125.285  66.999  1.00 32.38           C  
ATOM   1611  OH  TYR A 226      89.215 125.958  66.548  1.00 31.81           O  
ATOM   1612  N   LEU A 227      82.239 122.158  70.070  1.00 36.81           N  
ATOM   1613  CA  LEU A 227      80.947 121.487  70.164  1.00 38.54           C  
ATOM   1614  C   LEU A 227      79.982 122.329  70.997  1.00 40.12           C  
ATOM   1615  O   LEU A 227      78.888 122.675  70.547  1.00 39.66           O  
ATOM   1616  CB  LEU A 227      81.126 120.103  70.795  1.00 38.25           C  
ATOM   1617  CG  LEU A 227      80.167 118.995  70.354  1.00 38.98           C  
ATOM   1618  CD1 LEU A 227      80.317 118.762  68.858  1.00 38.34           C  
ATOM   1619  CD2 LEU A 227      80.484 117.714  71.111  1.00 38.61           C  
ATOM   1620  N   THR A 228      80.408 122.667  72.210  1.00 40.73           N  
ATOM   1621  CA  THR A 228      79.602 123.468  73.123  1.00 42.34           C  
ATOM   1622  C   THR A 228      80.445 124.587  73.723  1.00 42.82           C  
ATOM   1623  O   THR A 228      80.795 124.480  74.919  1.00 42.08           O  
ATOM   1624  CB  THR A 228      79.038 122.586  74.234  1.00 42.82           C  
TER    1625      THR A 228                                                      
END
MOLECULE T0420.pdb
ATOM      1  N   MET     1      71.619 109.167  47.132  1.00 90.29           N  
ATOM      2  CA  MET     1      71.053 107.807  46.878  1.00 90.45           C  
ATOM      3  C   MET     1      71.689 106.761  47.790  1.00 88.28           C  
ATOM      4  O   MET     1      71.664 106.906  49.016  1.00 88.91           O  
ATOM      5  CB  MET     1      71.260 107.411  45.415  1.00 91.73           C  
ATOM      6  CG  MET     1      71.941 108.488  44.584  1.00 97.36           C  
ATOM      7  SD  MET     1      73.841 108.693  44.978  1.00 99.73          SE  
ATOM      8  CE  MET     1      74.536 108.305  43.197  1.00 99.73           C  
ATOM      9  N   ASN     2      72.267 105.716  47.201  1.00 85.03           N  
ATOM     10  CA  ASN     2      72.888 104.659  47.995  1.00 81.84           C  
ATOM     11  C   ASN     2      74.252 104.994  48.583  1.00 79.10           C  
ATOM     12  O   ASN     2      75.284 104.814  47.940  1.00 78.70           O  
ATOM     13  CB  ASN     2      72.987 103.382  47.174  1.00 82.29           C  
ATOM     14  CG  ASN     2      71.873 102.422  47.485  1.00 83.43           C  
ATOM     15  OD1 ASN     2      70.725 102.827  47.659  1.00 85.52           O  
ATOM     16  ND2 ASN     2      72.199 101.137  47.553  1.00 86.02           N  
ATOM     17  N   ILE     3      74.248 105.472  49.821  1.00 75.30           N  
ATOM     18  CA  ILE     3      75.487 105.816  50.485  1.00 72.19           C  
ATOM     19  C   ILE     3      75.638 105.118  51.830  1.00 69.90           C  
ATOM     20  O   ILE     3      74.729 105.111  52.659  1.00 69.85           O  
ATOM     21  CB  ILE     3      75.600 107.327  50.711  1.00 72.15           C  
ATOM     22  CG1 ILE     3      75.446 108.067  49.383  1.00 72.99           C  
ATOM     23  CG2 ILE     3      76.953 107.658  51.291  1.00 70.73           C  
ATOM     24  CD1 ILE     3      75.531 109.580  49.521  1.00 74.41           C  
ATOM     25  N   GLY     4      76.799 104.515  52.034  1.00 66.94           N  
ATOM     26  CA  GLY     4      77.060 103.854  53.291  1.00 62.89           C  
ATOM     27  C   GLY     4      78.166 104.579  54.036  1.00 59.88           C  
ATOM     28  O   GLY     4      79.154 105.010  53.446  1.00 59.44           O  
ATOM     29  N   VAL     5      77.993 104.742  55.338  1.00 57.63           N  
ATOM     30  CA  VAL     5      79.015 105.385  56.139  1.00 55.30           C  
ATOM     31  C   VAL     5      79.820 104.305  56.867  1.00 54.83           C  
ATOM     32  O   VAL     5      79.258 103.415  57.519  1.00 55.29           O  
ATOM     33  CB  VAL     5      78.407 106.331  57.182  1.00 55.28           C  
ATOM     34  CG1 VAL     5      79.501 107.107  57.868  1.00 52.77           C  
ATOM     35  CG2 VAL     5      77.436 107.269  56.520  1.00 54.18           C  
ATOM     36  N   ILE     6      81.137 104.363  56.711  1.00 52.33           N  
ATOM     37  CA  ILE     6      82.026 103.430  57.382  1.00 49.91           C  
ATOM     38  C   ILE     6      82.772 104.247  58.432  1.00 49.12           C  
ATOM     39  O   ILE     6      83.618 105.076  58.104  1.00 48.62           O  
ATOM     40  CB  ILE     6      83.073 102.802  56.424  1.00 49.52           C  
ATOM     41  CG1 ILE     6      82.382 101.948  55.361  1.00 48.68           C  
ATOM     42  CG2 ILE     6      84.049 101.945  57.211  1.00 48.22           C  
ATOM     43  CD1 ILE     6      83.341 101.418  54.286  1.00 45.37           C  
ATOM     44  N   ILE     7      82.437 104.024  59.694  1.00 48.36           N  
ATOM     45  CA  ILE     7      83.100 104.722  60.774  1.00 47.98           C  
ATOM     46  C   ILE     7      84.274 103.877  61.245  1.00 48.52           C  
ATOM     47  O   ILE     7      84.083 102.855  61.902  1.00 49.70           O  
ATOM     48  CB  ILE     7      82.152 104.964  61.956  1.00 47.36           C  
ATOM     49  CG1 ILE     7      80.950 105.785  61.483  1.00 45.91           C  
ATOM     50  CG2 ILE     7      82.897 105.675  63.069  1.00 45.97           C  
ATOM     51  CD1 ILE     7      79.957 106.127  62.563  1.00 45.22           C  
ATOM     52  N   LEU     8      85.483 104.303  60.877  1.00 49.06           N  
ATOM     53  CA  LEU     8      86.714 103.622  61.268  1.00 49.60           C  
ATOM     54  C   LEU     8      87.006 104.013  62.709  1.00 50.81           C  
ATOM     55  O   LEU     8      87.061 105.197  63.029  1.00 51.50           O  
ATOM     56  CB  LEU     8      87.873 104.067  60.382  1.00 48.30           C  
ATOM     57  CG  LEU     8      87.724 103.786  58.888  1.00 46.60           C  
ATOM     58  CD1 LEU     8      88.961 104.291  58.149  1.00 42.20           C  
ATOM     59  CD2 LEU     8      87.531 102.280  58.665  1.00 43.49           C  
ATOM     60  N   ALA     9      87.171 103.020  63.575  1.00 52.52           N  
ATOM     61  CA  ALA     9      87.443 103.268  64.982  1.00 53.82           C  
ATOM     62  C   ALA     9      88.307 102.171  65.556  1.00 55.51           C  
ATOM     63  O   ALA     9      88.312 101.961  66.758  1.00 56.08           O  
ATOM     64  CB  ALA     9      86.139 103.372  65.772  1.00 52.59           C  
ATOM     65  N   ALA    10      89.020 101.455  64.693  1.00 59.12           N  
ATOM     66  CA  ALA    10      89.924 100.405  65.149  1.00 63.15           C  
ATOM     67  C   ALA    10      91.195 101.151  65.561  1.00 66.75           C  
ATOM     68  O   ALA    10      91.294 102.364  65.350  1.00 68.61           O  
ATOM     69  CB  ALA    10      90.206  99.433  64.026  1.00 62.44           C  
ATOM     70  N   GLY    11      92.175 100.469  66.134  1.00 70.21           N  
ATOM     71  CA  GLY    11      93.361 101.205  66.554  1.00 75.15           C  
ATOM     72  C   GLY    11      94.613 101.061  65.711  1.00 78.33           C  
ATOM     73  O   GLY    11      95.722 101.227  66.230  1.00 78.74           O  
ATOM     74  N   GLU    12      94.437 100.767  64.422  1.00 81.19           N  
ATOM     75  CA  GLU    12      95.550 100.577  63.494  1.00 83.59           C  
ATOM     76  C   GLU    12      96.612 101.665  63.553  1.00 85.71           C  
ATOM     77  O   GLU    12      96.314 102.831  63.835  1.00 85.98           O  
ATOM     78  CB  GLU    12      95.034 100.456  62.063  1.00 83.44           C  
ATOM     79  CG  GLU    12      94.041 101.527  61.667  1.00 82.74           C  
ATOM     80  CD  GLU    12      92.617 101.052  61.810  1.00 83.09           C  
ATOM     81  OE1 GLU    12      92.365  99.880  61.447  1.00 79.28           O  
ATOM     82  OE2 GLU    12      91.759 101.846  62.268  1.00 83.42           O  
ATOM     83  N   GLY    13      97.853 101.269  63.266  1.00 87.93           N  
ATOM     84  CA  GLY    13      98.965 102.201  63.319  1.00 90.43           C  
ATOM     85  C   GLY    13      99.062 102.724  64.740  1.00 92.14           C  
ATOM     86  O   GLY    13      98.707 102.020  65.697  1.00 91.86           O  
ATOM     87  N   LYS    14      99.551 103.951  64.888  1.00 93.73           N  
ATOM     88  CA  LYS    14      99.652 104.561  66.210  1.00 94.77           C  
ATOM     89  C   LYS    14      98.423 105.454  66.350  1.00 95.25           C  
ATOM     90  O   LYS    14      98.420 106.428  67.102  1.00 95.26           O  
ATOM     91  CB  LYS    14     100.936 105.384  66.328  1.00 94.77           C  
ATOM     92  N   ARG    15      97.380 105.105  65.601  1.00 95.97           N  
ATOM     93  CA  ARG    15      96.131 105.855  65.620  1.00 96.80           C  
ATOM     94  C   ARG    15      95.378 105.615  66.920  1.00 97.12           C  
ATOM     95  O   ARG    15      95.823 104.844  67.772  1.00 97.51           O  
ATOM     96  CB  ARG    15      95.254 105.445  64.439  1.00 96.58           C  
ATOM     97  CG  ARG    15      95.877 105.710  63.079  1.00 96.59           C  
ATOM     98  CD  ARG    15      94.898 105.384  61.960  1.00 96.12           C  
ATOM     99  NE  ARG    15      95.475 105.569  60.630  1.00 96.03           N  
ATOM    100  CZ  ARG    15      96.458 104.827  60.126  1.00 96.46           C  
ATOM    101  NH1 ARG    15      96.984 103.835  60.838  1.00 95.19           N  
ATOM    102  NH2 ARG    15      96.918 105.081  58.907  1.00 96.89           N  
ATOM    103  N   PHE    16      94.240 106.283  67.074  1.00 97.18           N  
ATOM    104  CA  PHE    16      93.436 106.119  68.275  1.00 97.49           C  
ATOM    105  C   PHE    16      92.698 104.794  68.262  1.00 97.80           C  
ATOM    106  O   PHE    16      92.768 104.042  67.287  1.00 98.44           O  
ATOM    107  CB  PHE    16      92.419 107.249  68.401  1.00 97.55           C  
ATOM    108  CG  PHE    16      92.908 108.410  69.205  1.00 98.14           C  
ATOM    109  CD1 PHE    16      92.008 109.219  69.890  1.00 98.54           C  
ATOM    110  CD2 PHE    16      94.269 108.692  69.288  1.00 98.99           C  
ATOM    111  CE1 PHE    16      92.454 110.286  70.657  1.00 99.73           C  
ATOM    112  CE2 PHE    16      94.730 109.756  70.052  1.00 99.73           C  
ATOM    113  CZ  PHE    16      93.821 110.559  70.737  1.00 99.73           C  
ATOM    114  N   GLY    17      91.990 104.498  69.346  1.00 97.56           N  
ATOM    115  CA  GLY    17      91.244 103.256  69.372  1.00 97.36           C  
ATOM    116  C   GLY    17      90.894 102.662  70.721  1.00 97.21           C  
ATOM    117  O   GLY    17      91.776 102.255  71.471  1.00 97.85           O  
ATOM    118  N   GLY    18      89.597 102.608  71.018  1.00 96.53           N  
ATOM    119  CA  GLY    18      89.120 102.023  72.260  1.00 94.80           C  
ATOM    120  C   GLY    18      89.396 102.785  73.541  1.00 93.58           C  
ATOM    121  O   GLY    18      88.477 103.303  74.183  1.00 93.59           O  
ATOM    122  N   ASP    19      90.660 102.835  73.938  1.00 91.98           N  
ATOM    123  CA  ASP    19      91.011 103.550  75.145  1.00 90.00           C  
ATOM    124  C   ASP    19      90.709 105.034  74.941  1.00 87.78           C  
ATOM    125  O   ASP    19      89.786 105.568  75.553  1.00 87.48           O  
ATOM    126  CB  ASP    19      92.493 103.309  75.509  1.00 91.01           C  
ATOM    127  CG  ASP    19      93.463 103.733  74.409  1.00 93.15           C  
ATOM    128  OD1 ASP    19      93.323 103.266  73.259  1.00 95.19           O  
ATOM    129  OD2 ASP    19      94.384 104.528  74.701  1.00 97.76           O  
ATOM    130  N   LYS    20      91.456 105.685  74.055  1.00 85.16           N  
ATOM    131  CA  LYS    20      91.273 107.110  73.786  1.00 82.92           C  
ATOM    132  C   LYS    20      89.816 107.477  73.458  1.00 80.52           C  
ATOM    133  O   LYS    20      89.253 108.420  74.027  1.00 80.56           O  
ATOM    134  CB  LYS    20      92.180 107.539  72.627  1.00 83.51           C  
ATOM    135  CG  LYS    20      93.671 107.243  72.823  1.00 86.11           C  
ATOM    136  CD  LYS    20      94.408 108.386  73.521  1.00 91.90           C  
ATOM    137  CE  LYS    20      95.905 108.087  73.660  1.00 92.28           C  
ATOM    138  NZ  LYS    20      96.592 107.877  72.350  1.00 91.97           N  
ATOM    139  N   LEU    21      89.210 106.721  72.546  1.00 77.43           N  
ATOM    140  CA  LEU    21      87.836 106.968  72.122  1.00 74.10           C  
ATOM    141  C   LEU    21      86.754 106.807  73.200  1.00 72.82           C  
ATOM    142  O   LEU    21      85.572 107.019  72.916  1.00 71.48           O  
ATOM    143  CB  LEU    21      87.507 106.089  70.906  1.00 73.69           C  
ATOM    144  CG  LEU    21      88.288 106.394  69.618  1.00 71.25           C  
ATOM    145  CD1 LEU    21      87.938 105.370  68.578  1.00 69.24           C  
ATOM    146  CD2 LEU    21      87.972 107.783  69.103  1.00 68.55           C  
ATOM    147  N   LEU    22      87.143 106.434  74.424  1.00 71.68           N  
ATOM    148  CA  LEU    22      86.172 106.290  75.512  1.00 70.37           C  
ATOM    149  C   LEU    22      86.095 107.557  76.356  1.00 69.76           C  
ATOM    150  O   LEU    22      85.162 107.730  77.144  1.00 69.42           O  
ATOM    151  CB  LEU    22      86.491 105.095  76.416  1.00 70.07           C  
ATOM    152  CG  LEU    22      86.082 103.676  75.982  1.00 71.01           C  
ATOM    153  CD1 LEU    22      85.902 102.800  77.220  1.00 68.76           C  
ATOM    154  CD2 LEU    22      84.773 103.705  75.206  1.00 72.70           C  
ATOM    155  N   ALA    23      87.078 108.441  76.174  1.00 69.46           N  
ATOM    156  CA  ALA    23      87.127 109.724  76.884  1.00 69.28           C  
ATOM    157  C   ALA    23      85.917 110.570  76.485  1.00 69.04           C  
ATOM    158  O   ALA    23      85.341 110.375  75.412  1.00 69.60           O  
ATOM    159  CB  ALA    23      88.409 110.460  76.543  1.00 69.01           C  
ATOM    160  N   LYS    24      85.549 111.522  77.337  1.00 68.45           N  
ATOM    161  CA  LYS    24      84.383 112.367  77.086  1.00 68.28           C  
ATOM    162  C   LYS    24      84.613 113.775  76.519  1.00 68.22           C  
ATOM    163  O   LYS    24      85.726 114.280  76.472  1.00 68.12           O  
ATOM    164  CB  LYS    24      83.569 112.483  78.376  1.00 67.78           C  
ATOM    165  CG  LYS    24      83.078 111.164  78.927  1.00 68.26           C  
ATOM    166  CD  LYS    24      82.344 111.376  80.231  1.00 66.88           C  
ATOM    167  CE  LYS    24      81.781 110.086  80.774  1.00 69.00           C  
ATOM    168  NZ  LYS    24      80.964 110.366  81.975  1.00 71.95           N  
ATOM    169  N   ILE    25      83.522 114.399  76.101  1.00 68.72           N  
ATOM    170  CA  ILE    25      83.525 115.746  75.553  1.00 69.60           C  
ATOM    171  C   ILE    25      82.113 116.231  75.805  1.00 70.70           C  
ATOM    172  O   ILE    25      81.199 115.924  75.039  1.00 70.98           O  
ATOM    173  CB  ILE    25      83.791 115.732  74.042  1.00 69.72           C  
ATOM    174  CG1 ILE    25      85.257 115.399  73.782  1.00 70.89           C  
ATOM    175  CG2 ILE    25      83.412 117.056  73.429  1.00 69.11           C  
ATOM    176  CD1 ILE    25      85.582 115.164  72.325  1.00 72.99           C  
ATOM    177  N   ASP    26      81.931 116.984  76.881  1.00 71.49           N  
ATOM    178  CA  ASP    26      80.604 117.463  77.233  1.00 72.41           C  
ATOM    179  C   ASP    26      79.866 116.270  77.805  1.00 71.27           C  
ATOM    180  O   ASP    26      78.696 116.051  77.478  1.00 71.67           O  
ATOM    181  CB  ASP    26      79.825 117.975  76.006  1.00 73.68           C  
ATOM    182  CG  ASP    26      80.186 119.402  75.626  1.00 79.66           C  
ATOM    183  OD1 ASP    26      80.133 120.280  76.516  1.00 86.88           O  
ATOM    184  OD2 ASP    26      80.510 119.650  74.441  1.00 84.59           O  
ATOM    185  N   ASN    27      80.559 115.481  78.628  1.00 68.93           N  
ATOM    186  CA  ASN    27      79.942 114.315  79.268  1.00 66.22           C  
ATOM    187  C   ASN    27      79.658 113.120  78.385  1.00 64.66           C  
ATOM    188  O   ASN    27      79.094 112.128  78.859  1.00 65.21           O  
ATOM    189  CB  ASN    27      78.612 114.688  79.922  1.00 65.54           C  
ATOM    190  CG  ASN    27      78.784 115.403  81.225  1.00 64.50           C  
ATOM    191  OD1 ASN    27      79.884 115.485  81.765  1.00 64.45           O  
ATOM    192  ND2 ASN    27      77.683 115.917  81.756  1.00 64.06           N  
ATOM    193  N   THR    28      80.000 113.196  77.108  1.00 62.05           N  
ATOM    194  CA  THR    28      79.717 112.060  76.257  1.00 59.69           C  
ATOM    195  C   THR    28      80.960 111.528  75.569  1.00 58.20           C  
ATOM    196  O   THR    28      81.777 112.288  75.050  1.00 57.50           O  
ATOM    197  CB  THR    28      78.640 112.384  75.191  1.00 59.45           C  
ATOM    198  OG1 THR    28      79.251 112.466  73.900  1.00 59.73           O  
ATOM    199  CG2 THR    28      77.942 113.690  75.508  1.00 57.57           C  
ATOM    200  N   PRO    29      81.119 110.198  75.579  1.00 56.76           N  
ATOM    201  CA  PRO    29      82.239 109.478  74.972  1.00 56.34           C  
ATOM    202  C   PRO    29      82.454 109.932  73.529  1.00 55.95           C  
ATOM    203  O   PRO    29      81.504 110.038  72.765  1.00 56.53           O  
ATOM    204  CB  PRO    29      81.788 108.027  75.065  1.00 56.52           C  
ATOM    205  CG  PRO    29      80.997 108.025  76.333  1.00 56.54           C  
ATOM    206  CD  PRO    29      80.176 109.262  76.213  1.00 55.49           C  
ATOM    207  N   ILE    30      83.700 110.192  73.157  1.00 55.38           N  
ATOM    208  CA  ILE    30      84.000 110.645  71.811  1.00 55.43           C  
ATOM    209  C   ILE    30      83.353 109.800  70.720  1.00 55.32           C  
ATOM    210  O   ILE    30      82.564 110.328  69.926  1.00 56.08           O  
ATOM    211  CB  ILE    30      85.522 110.709  71.577  1.00 55.57           C  
ATOM    212  CG1 ILE    30      86.136 111.685  72.580  1.00 58.50           C  
ATOM    213  CG2 ILE    30      85.833 111.166  70.152  1.00 55.90           C  
ATOM    214  CD1 ILE    30      87.631 111.558  72.699  1.00 61.89           C  
ATOM    215  N   ILE    31      83.672 108.504  70.676  1.00 54.45           N  
ATOM    216  CA  ILE    31      83.118 107.613  69.647  1.00 53.69           C  
ATOM    217  C   ILE    31      81.614 107.793  69.494  1.00 54.48           C  
ATOM    218  O   ILE    31      81.101 107.817  68.377  1.00 53.94           O  
ATOM    219  CB  ILE    31      83.430 106.091  69.930  1.00 53.14           C  
ATOM    220  CG1 ILE    31      82.977 105.234  68.744  1.00 52.34           C  
ATOM    221  CG2 ILE    31      82.709 105.612  71.178  1.00 49.66           C  
ATOM    222  CD1 ILE    31      83.529 105.698  67.414  1.00 48.24           C  
ATOM    223  N   MET    32      80.915 107.933  70.614  1.00 55.33           N  
ATOM    224  CA  MET    32      79.468 108.124  70.580  1.00 57.31           C  
ATOM    225  C   MET    32      79.075 109.453  69.925  1.00 57.61           C  
ATOM    226  O   MET    32      78.130 109.518  69.147  1.00 58.36           O  
ATOM    227  CB  MET    32      78.889 108.041  71.994  1.00 57.46           C  
ATOM    228  CG  MET    32      78.996 106.661  72.614  1.00 62.54           C  
ATOM    229  SD  MET    32      78.000 106.473  74.269  1.00 78.05          SE  
ATOM    230  CE  MET    32      76.220 106.221  73.530  1.00 73.81           C  
ATOM    231  N   ARG    33      79.804 110.515  70.236  1.00 57.73           N  
ATOM    232  CA  ARG    33      79.511 111.806  69.650  1.00 57.85           C  
ATOM    233  C   ARG    33      79.694 111.710  68.131  1.00 56.91           C  
ATOM    234  O   ARG    33      78.834 112.133  67.368  1.00 56.97           O  
ATOM    235  CB  ARG    33      80.455 112.857  70.228  1.00 58.89           C  
ATOM    236  CG  ARG    33      80.107 114.287  69.860  1.00 64.39           C  
ATOM    237  CD  ARG    33      81.310 115.202  70.074  1.00 73.49           C  
ATOM    238  NE  ARG    33      80.955 116.619  70.038  1.00 79.65           N  
ATOM    239  CZ  ARG    33      80.209 117.224  70.960  1.00 84.29           C  
ATOM    240  NH1 ARG    33      79.728 116.544  72.002  1.00 85.07           N  
ATOM    241  NH2 ARG    33      79.953 118.518  70.841  1.00 85.09           N  
ATOM    242  N   THR    34      80.818 111.141  67.710  1.00 55.65           N  
ATOM    243  CA  THR    34      81.154 110.977  66.299  1.00 55.20           C  
ATOM    244  C   THR    34      80.093 110.227  65.496  1.00 56.00           C  
ATOM    245  O   THR    34      79.744 110.616  64.383  1.00 57.09           O  
ATOM    246  CB  THR    34      82.487 110.233  66.153  1.00 54.71           C  
ATOM    247  OG1 THR    34      83.528 111.010  66.753  1.00 56.07           O  
ATOM    248  CG2 THR    34      82.817 109.991  64.698  1.00 53.23           C  
ATOM    249  N   ILE    35      79.595 109.135  66.050  1.00 55.81           N  
ATOM    250  CA  ILE    35      78.573 108.350  65.382  1.00 55.24           C  
ATOM    251  C   ILE    35      77.285 109.182  65.289  1.00 56.74           C  
ATOM    252  O   ILE    35      76.516 109.062  64.335  1.00 56.77           O  
ATOM    253  CB  ILE    35      78.314 107.055  66.181  1.00 54.53           C  
ATOM    254  CG1 ILE    35      79.523 106.122  66.057  1.00 52.33           C  
ATOM    255  CG2 ILE    35      77.025 106.392  65.721  1.00 54.33           C  
ATOM    256  CD1 ILE    35      79.511 104.992  67.061  1.00 52.36           C  
ATOM    257  N   ARG    36      77.063 110.034  66.285  1.00 58.78           N  
ATOM    258  CA  ARG    36      75.872 110.873  66.330  1.00 60.98           C  
ATOM    259  C   ARG    36      75.736 111.810  65.126  1.00 60.67           C  
ATOM    260  O   ARG    36      74.623 112.054  64.639  1.00 60.67           O  
ATOM    261  CB  ARG    36      75.856 111.709  67.617  1.00 62.08           C  
ATOM    262  CG  ARG    36      74.700 112.698  67.669  1.00 70.34           C  
ATOM    263  CD  ARG    36      74.838 113.806  68.723  1.00 81.85           C  
ATOM    264  NE  ARG    36      73.929 114.914  68.396  1.00 91.09           N  
ATOM    265  CZ  ARG    36      73.705 115.989  69.155  1.00 95.58           C  
ATOM    266  NH1 ARG    36      74.321 116.134  70.323  1.00 98.47           N  
ATOM    267  NH2 ARG    36      72.864 116.934  68.737  1.00 96.39           N  
ATOM    268  N   ILE    37      76.852 112.330  64.630  1.00 60.37           N  
ATOM    269  CA  ILE    37      76.760 113.262  63.520  1.00 60.38           C  
ATOM    270  C   ILE    37      76.210 112.662  62.239  1.00 59.58           C  
ATOM    271  O   ILE    37      75.575 113.366  61.461  1.00 60.82           O  
ATOM    272  CB  ILE    37      78.127 113.955  63.185  1.00 60.43           C  
ATOM    273  CG1 ILE    37      78.674 113.407  61.868  1.00 62.85           C  
ATOM    274  CG2 ILE    37      79.129 113.773  64.316  1.00 59.72           C  
ATOM    275  CD1 ILE    37      79.796 114.225  61.284  1.00 67.67           C  
ATOM    276  N   TYR    38      76.439 111.376  62.009  1.00 58.46           N  
ATOM    277  CA  TYR    38      75.958 110.767  60.772  1.00 58.42           C  
ATOM    278  C   TYR    38      74.512 110.287  60.843  1.00 59.45           C  
ATOM    279  O   TYR    38      74.027 109.572  59.957  1.00 59.42           O  
ATOM    280  CB  TYR    38      76.898 109.643  60.352  1.00 57.53           C  
ATOM    281  CG  TYR    38      78.318 110.140  60.220  1.00 57.36           C  
ATOM    282  CD1 TYR    38      79.162 110.183  61.328  1.00 55.51           C  
ATOM    283  CD2 TYR    38      78.800 110.631  59.012  1.00 55.63           C  
ATOM    284  CE1 TYR    38      80.441 110.698  61.244  1.00 49.86           C  
ATOM    285  CE2 TYR    38      80.086 111.152  58.916  1.00 54.10           C  
ATOM    286  CZ  TYR    38      80.901 111.178  60.041  1.00 51.45           C  
ATOM    287  OH  TYR    38      82.186 111.662  59.964  1.00 47.93           O  
ATOM    288  N   GLY    39      73.835 110.720  61.907  1.00 60.10           N  
ATOM    289  CA  GLY    39      72.436 110.407  62.143  1.00 60.00           C  
ATOM    290  C   GLY    39      71.855 109.148  61.549  1.00 60.55           C  
ATOM    291  O   GLY    39      72.378 108.058  61.752  1.00 61.52           O  
ATOM    292  N   ASP    40      70.771 109.296  60.796  1.00 60.94           N  
ATOM    293  CA  ASP    40      70.101 108.136  60.216  1.00 61.01           C  
ATOM    294  C   ASP    40      70.751 107.499  58.989  1.00 60.50           C  
ATOM    295  O   ASP    40      70.166 106.593  58.398  1.00 61.61           O  
ATOM    296  CB  ASP    40      68.633 108.467  59.925  1.00 61.37           C  
ATOM    297  N   LEU    41      71.943 107.952  58.601  1.00 59.40           N  
ATOM    298  CA  LEU    41      72.634 107.336  57.466  1.00 58.41           C  
ATOM    299  C   LEU    41      73.003 105.901  57.874  1.00 58.10           C  
ATOM    300  O   LEU    41      73.050 105.601  59.061  1.00 58.57           O  
ATOM    301  CB  LEU    41      73.916 108.105  57.132  1.00 57.99           C  
ATOM    302  CG  LEU    41      73.826 109.512  56.542  1.00 57.23           C  
ATOM    303  CD1 LEU    41      75.230 110.107  56.371  1.00 57.65           C  
ATOM    304  CD2 LEU    41      73.115 109.447  55.218  1.00 57.35           C  
ATOM    305  N   GLU    42      73.254 105.021  56.905  1.00 57.72           N  
ATOM    306  CA  GLU    42      73.638 103.638  57.205  1.00 58.18           C  
ATOM    307  C   GLU    42      75.083 103.558  57.672  1.00 57.58           C  
ATOM    308  O   GLU    42      76.007 103.563  56.865  1.00 58.58           O  
ATOM    309  CB  GLU    42      73.507 102.748  55.983  1.00 58.83           C  
ATOM    310  CG  GLU    42      72.111 102.537  55.499  1.00 63.58           C  
ATOM    311  CD  GLU    42      72.067 101.539  54.355  1.00 70.64           C  
ATOM    312  OE1 GLU    42      72.384 100.347  54.605  1.00 73.15           O  
ATOM    313  OE2 GLU    42      71.728 101.953  53.216  1.00 70.47           O  
ATOM    314  N   LYS    43      75.268 103.444  58.978  1.00 56.57           N  
ATOM    315  CA  LYS    43      76.589 103.388  59.574  1.00 54.94           C  
ATOM    316  C   LYS    43      77.058 101.962  59.729  1.00 53.93           C  
ATOM    317  O   LYS    43      76.296 101.025  59.586  1.00 54.99           O  
ATOM    318  CB  LYS    43      76.539 104.053  60.944  1.00 54.21           C  
ATOM    319  CG  LYS    43      76.089 105.493  60.873  1.00 56.44           C  
ATOM    320  CD  LYS    43      75.508 105.986  62.175  1.00 57.68           C  
ATOM    321  CE  LYS    43      74.133 105.422  62.382  1.00 62.41           C  
ATOM    322  NZ  LYS    43      73.639 105.759  63.752  1.00 70.06           N  
ATOM    323  N   ILE    44      78.336 101.815  60.023  1.00 53.03           N  
ATOM    324  CA  ILE    44      78.956 100.522  60.253  1.00 51.66           C  
ATOM    325  C   ILE    44      80.189 100.978  61.016  1.00 50.86           C  
ATOM    326  O   ILE    44      80.899 101.871  60.552  1.00 50.25           O  
ATOM    327  CB  ILE    44      79.325  99.798  58.892  1.00 51.74           C  
ATOM    328  CG1 ILE    44      78.773  98.381  58.892  1.00 53.42           C  
ATOM    329  CG2 ILE    44      80.828  99.652  58.706  1.00 51.40           C  
ATOM    330  CD1 ILE    44      77.286  98.305  59.143  1.00 58.76           C  
ATOM    331  N   ILE    45      80.414 100.441  62.209  1.00 49.37           N  
ATOM    332  CA  ILE    45      81.605 100.835  62.958  1.00 48.60           C  
ATOM    333  C   ILE    45      82.599  99.678  62.948  1.00 47.89           C  
ATOM    334  O   ILE    45      82.250  98.549  63.296  1.00 47.54           O  
ATOM    335  CB  ILE    45      81.288 101.224  64.429  1.00 48.70           C  
ATOM    336  CG1 ILE    45      80.526 102.551  64.500  1.00 51.62           C  
ATOM    337  CG2 ILE    45      82.577 101.466  65.175  1.00 48.08           C  
ATOM    338  CD1 ILE    45      79.121 102.524  64.017  1.00 50.63           C  
ATOM    339  N   ILE    46      83.832  99.957  62.530  1.00 47.84           N  
ATOM    340  CA  ILE    46      84.878  98.932  62.471  1.00 48.03           C  
ATOM    341  C   ILE    46      85.761  99.062  63.707  1.00 49.81           C  
ATOM    342  O   ILE    46      86.479 100.044  63.874  1.00 49.96           O  
ATOM    343  CB  ILE    46      85.750  99.079  61.206  1.00 47.88           C  
ATOM    344  CG1 ILE    46      84.863  99.339  59.981  1.00 46.63           C  
ATOM    345  CG2 ILE    46      86.567  97.822  61.007  1.00 45.07           C  
ATOM    346  CD1 ILE    46      83.919  98.205  59.659  1.00 46.69           C  
ATOM    347  N   VAL    47      85.713  98.050  64.563  1.00 51.65           N  
ATOM    348  CA  VAL    47      86.454  98.057  65.801  1.00 52.13           C  
ATOM    349  C   VAL    47      87.558  97.039  65.857  1.00 52.86           C  
ATOM    350  O   VAL    47      87.385  95.892  65.465  1.00 53.50           O  
ATOM    351  CB  VAL    47      85.489  97.786  66.997  1.00 52.29           C  
ATOM    352  CG1 VAL    47      86.271  97.710  68.308  1.00 58.76           C  
ATOM    353  CG2 VAL    47      84.434  98.880  67.086  1.00 49.63           C  
ATOM    354  N   GLY    48      88.700  97.489  66.340  1.00 53.86           N  
ATOM    355  CA  GLY    48      89.803  96.591  66.529  1.00 56.32           C  
ATOM    356  C   GLY    48      90.462  96.636  67.900  1.00 58.56           C  
ATOM    357  O   GLY    48      90.053  95.931  68.838  1.00 58.36           O  
ATOM    358  N   LYS    49      91.398  97.574  68.039  1.00 60.27           N  
ATOM    359  CA  LYS    49      92.245  97.618  69.209  1.00 61.92           C  
ATOM    360  C   LYS    49      91.645  97.359  70.559  1.00 62.63           C  
ATOM    361  O   LYS    49      92.151  96.541  71.335  1.00 63.40           O  
ATOM    362  CB  LYS    49      93.101  98.892  69.217  1.00 62.68           C  
ATOM    363  CG  LYS    49      94.220  98.881  70.262  1.00 65.72           C  
ATOM    364  CD  LYS    49      95.293  99.902  69.929  1.00 71.92           C  
ATOM    365  CE  LYS    49      96.442  99.825  70.923  1.00 74.57           C  
ATOM    366  NZ  LYS    49      97.419 100.945  70.723  1.00 77.45           N  
ATOM    367  N   TYR    50      90.541  98.024  70.825  1.00 61.98           N  
ATOM    368  CA  TYR    50      89.878  97.870  72.096  1.00 62.40           C  
ATOM    369  C   TYR    50      88.384  97.537  72.004  1.00 61.32           C  
ATOM    370  O   TYR    50      87.543  98.201  72.619  1.00 60.53           O  
ATOM    371  CB  TYR    50      90.093  99.142  72.913  1.00 64.35           C  
ATOM    372  CG  TYR    50      91.467  99.231  73.557  1.00 69.92           C  
ATOM    373  CD1 TYR    50      91.851  98.321  74.548  1.00 75.20           C  
ATOM    374  CD2 TYR    50      92.380 100.226  73.191  1.00 71.41           C  
ATOM    375  CE1 TYR    50      93.106  98.398  75.162  1.00 76.64           C  
ATOM    376  CE2 TYR    50      93.639 100.315  73.798  1.00 73.94           C  
ATOM    377  CZ  TYR    50      93.993  99.399  74.787  1.00 76.90           C  
ATOM    378  OH  TYR    50      95.211  99.503  75.430  1.00 78.80           O  
ATOM    379  N   VAL    51      88.073  96.495  71.237  1.00 59.63           N  
ATOM    380  CA  VAL    51      86.707  96.020  71.054  1.00 57.84           C  
ATOM    381  C   VAL    51      85.939  95.973  72.370  1.00 58.37           C  
ATOM    382  O   VAL    51      84.792  96.426  72.461  1.00 58.73           O  
ATOM    383  CB  VAL    51      86.667  94.573  70.482  1.00 58.21           C  
ATOM    384  CG1 VAL    51      85.824  94.537  69.223  1.00 57.69           C  
ATOM    385  CG2 VAL    51      88.069  94.054  70.218  1.00 57.30           C  
ATOM    386  N   ASN    52      86.588  95.412  73.385  1.00 58.63           N  
ATOM    387  CA  ASN    52      86.002  95.231  74.703  1.00 59.29           C  
ATOM    388  C   ASN    52      85.566  96.513  75.391  1.00 59.39           C  
ATOM    389  O   ASN    52      84.513  96.545  76.008  1.00 59.70           O  
ATOM    390  CB  ASN    52      86.986  94.443  75.559  1.00 60.17           C  
ATOM    391  CG  ASN    52      87.796  93.442  74.727  1.00 64.37           C  
ATOM    392  OD1 ASN    52      88.879  93.772  74.214  1.00 67.78           O  
ATOM    393  ND2 ASN    52      87.259  92.223  74.562  1.00 65.23           N  
ATOM    394  N   GLU    53      86.366  97.567  75.292  1.00 60.29           N  
ATOM    395  CA  GLU    53      86.020  98.851  75.889  1.00 60.62           C  
ATOM    396  C   GLU    53      84.865  99.468  75.113  1.00 60.18           C  
ATOM    397  O   GLU    53      83.879  99.925  75.678  1.00 60.82           O  
ATOM    398  CB  GLU    53      87.187  99.834  75.787  1.00 61.28           C  
ATOM    399  CG  GLU    53      88.107  99.932  76.968  1.00 65.75           C  
ATOM    400  CD  GLU    53      89.111  98.815  77.002  1.00 74.97           C  
ATOM    401  OE1 GLU    53      90.250  99.080  77.464  1.00 79.21           O  
ATOM    402  OE2 GLU    53      88.760  97.683  76.579  1.00 76.94           O  
ATOM    403  N   MET    54      85.035  99.481  73.800  1.00 59.89           N  
ATOM    404  CA  MET    54      84.103 100.063  72.844  1.00 60.56           C  
ATOM    405  C   MET    54      82.660  99.563  72.773  1.00 58.62           C  
ATOM    406  O   MET    54      81.708 100.349  72.841  1.00 58.00           O  
ATOM    407  CB  MET    54      84.697  99.924  71.449  1.00 62.14           C  
ATOM    408  CG  MET    54      86.053 100.549  71.282  1.00 69.52           C  
ATOM    409  SD  MET    54      85.886 102.012  70.073  1.00 90.15          SE  
ATOM    410  CE  MET    54      85.198 103.287  71.348  1.00 84.00           C  
ATOM    411  N   LEU    55      82.502  98.256  72.622  1.00 55.88           N  
ATOM    412  CA  LEU    55      81.184  97.676  72.459  1.00 54.39           C  
ATOM    413  C   LEU    55      80.040  98.066  73.373  1.00 53.04           C  
ATOM    414  O   LEU    55      78.959  98.398  72.897  1.00 53.20           O  
ATOM    415  CB  LEU    55      81.306  96.155  72.391  1.00 54.90           C  
ATOM    416  CG  LEU    55      81.307  95.787  70.903  1.00 56.33           C  
ATOM    417  CD1 LEU    55      82.157  94.570  70.662  1.00 61.30           C  
ATOM    418  CD2 LEU    55      79.872  95.590  70.432  1.00 52.82           C  
ATOM    419  N   PRO    56      80.249  98.046  74.694  1.00 51.29           N  
ATOM    420  CA  PRO    56      79.124  98.414  75.552  1.00 49.78           C  
ATOM    421  C   PRO    56      78.523  99.780  75.249  1.00 49.42           C  
ATOM    422  O   PRO    56      77.448 100.106  75.750  1.00 48.99           O  
ATOM    423  CB  PRO    56      79.719  98.312  76.948  1.00 49.07           C  
ATOM    424  CG  PRO    56      80.722  97.225  76.789  1.00 49.39           C  
ATOM    425  CD  PRO    56      81.395  97.595  75.498  1.00 49.72           C  
ATOM    426  N   LEU    57      79.216 100.574  74.436  1.00 49.11           N  
ATOM    427  CA  LEU    57      78.729 101.905  74.052  1.00 50.18           C  
ATOM    428  C   LEU    57      78.107 101.899  72.662  1.00 50.24           C  
ATOM    429  O   LEU    57      77.524 102.890  72.243  1.00 51.13           O  
ATOM    430  CB  LEU    57      79.862 102.932  74.024  1.00 50.39           C  
ATOM    431  CG  LEU    57      80.628 103.337  75.273  1.00 52.72           C  
ATOM    432  CD1 LEU    57      81.414 102.155  75.842  1.00 56.04           C  
ATOM    433  CD2 LEU    57      81.565 104.462  74.883  1.00 54.20           C  
ATOM    434  N   LEU    58      78.256 100.789  71.948  1.00 49.46           N  
ATOM    435  CA  LEU    58      77.741 100.660  70.593  1.00 48.48           C  
ATOM    436  C   LEU    58      76.717  99.532  70.493  1.00 49.44           C  
ATOM    437  O   LEU    58      76.510  98.994  69.411  1.00 50.42           O  
ATOM    438  CB  LEU    58      78.896 100.345  69.647  1.00 47.40           C  
ATOM    439  CG  LEU    58      80.166 101.180  69.771  1.00 44.88           C  
ATOM    440  CD1 LEU    58      81.278 100.576  68.929  1.00 42.95           C  
ATOM    441  CD2 LEU    58      79.876 102.572  69.324  1.00 44.85           C  
ATOM    442  N   MET    59      76.078  99.174  71.605  1.00 49.35           N  
ATOM    443  CA  MET    59      75.125  98.067  71.600  1.00 49.73           C  
ATOM    444  C   MET    59      73.985  98.168  70.591  1.00 49.30           C  
ATOM    445  O   MET    59      73.364  97.162  70.244  1.00 49.30           O  
ATOM    446  CB  MET    59      74.559  97.842  73.010  1.00 50.89           C  
ATOM    447  CG  MET    59      75.565  97.287  74.017  1.00 54.13           C  
ATOM    448  SD  MET    59      76.588  95.782  73.324  1.00 70.34          SE  
ATOM    449  CE  MET    59      75.361  94.347  73.753  1.00 58.89           C  
ATOM    450  N   ASP    60      73.708  99.374  70.110  1.00 47.86           N  
ATOM    451  CA  ASP    60      72.653  99.565  69.124  1.00 46.66           C  
ATOM    452  C   ASP    60      73.221  99.860  67.735  1.00 46.22           C  
ATOM    453  O   ASP    60      72.538 100.445  66.911  1.00 47.02           O  
ATOM    454  CB  ASP    60      71.777 100.727  69.535  1.00 46.17           C  
ATOM    455  CG  ASP    60      72.544 102.034  69.589  1.00 48.07           C  
ATOM    456  OD1 ASP    60      73.801 102.003  69.559  1.00 53.28           O  
ATOM    457  OD2 ASP    60      71.888 103.091  69.676  1.00 47.99           O  
ATOM    458  N   GLN    61      74.463  99.468  67.479  1.00 45.11           N  
ATOM    459  CA  GLN    61      75.091  99.721  66.192  1.00 45.51           C  
ATOM    460  C   GLN    61      75.570  98.418  65.558  1.00 45.51           C  
ATOM    461  O   GLN    61      75.632  97.396  66.234  1.00 47.80           O  
ATOM    462  CB  GLN    61      76.304 100.641  66.367  1.00 44.61           C  
ATOM    463  CG  GLN    61      76.029 101.970  67.031  1.00 47.76           C  
ATOM    464  CD  GLN    61      75.216 102.919  66.169  1.00 49.19           C  
ATOM    465  OE1 GLN    61      75.521 103.116  65.002  1.00 50.52           O  
ATOM    466  NE2 GLN    61      74.185 103.520  66.749  1.00 52.55           N  
ATOM    467  N   ILE    62      75.892  98.445  64.267  1.00 43.40           N  
ATOM    468  CA  ILE    62      76.422  97.260  63.623  1.00 42.80           C  
ATOM    469  C   ILE    62      77.933  97.417  63.754  1.00 43.20           C  
ATOM    470  O   ILE    62      78.536  98.329  63.179  1.00 43.46           O  
ATOM    471  CB  ILE    62      76.065  97.163  62.119  1.00 43.54           C  
ATOM    472  CG1 ILE    62      74.578  96.871  61.943  1.00 44.93           C  
ATOM    473  CG2 ILE    62      76.870  96.046  61.466  1.00 40.91           C  
ATOM    474  CD1 ILE    62      74.146  96.881  60.518  1.00 44.82           C  
ATOM    475  N   VAL    63      78.547  96.526  64.519  1.00 43.82           N  
ATOM    476  CA  VAL    63      79.975  96.594  64.738  1.00 42.60           C  
ATOM    477  C   VAL    63      80.726  95.410  64.165  1.00 43.60           C  
ATOM    478  O   VAL    63      80.362  94.255  64.412  1.00 44.70           O  
ATOM    479  CB  VAL    63      80.264  96.654  66.221  1.00 42.01           C  
ATOM    480  CG1 VAL    63      81.728  96.879  66.438  1.00 41.44           C  
ATOM    481  CG2 VAL    63      79.437  97.758  66.849  1.00 40.36           C  
ATOM    482  N   ILE    64      81.760  95.691  63.380  1.00 43.38           N  
ATOM    483  CA  ILE    64      82.579  94.618  62.834  1.00 43.76           C  
ATOM    484  C   ILE    64      83.935  94.756  63.513  1.00 43.62           C  
ATOM    485  O   ILE    64      84.577  95.801  63.455  1.00 43.62           O  
ATOM    486  CB  ILE    64      82.821  94.702  61.278  1.00 44.89           C  
ATOM    487  CG1 ILE    64      81.509  94.822  60.510  1.00 45.55           C  
ATOM    488  CG2 ILE    64      83.526  93.442  60.799  1.00 41.36           C  
ATOM    489  CD1 ILE    64      81.032  96.228  60.377  1.00 50.68           C  
ATOM    490  N   TYR    65      84.349  93.690  64.171  1.00 43.63           N  
ATOM    491  CA  TYR    65      85.625  93.649  64.829  1.00 43.37           C  
ATOM    492  C   TYR    65      86.648  93.145  63.818  1.00 44.75           C  
ATOM    493  O   TYR    65      86.500  92.057  63.249  1.00 43.95           O  
ATOM    494  CB  TYR    65      85.565  92.702  66.019  1.00 43.55           C  
ATOM    495  CG  TYR    65      86.918  92.251  66.487  1.00 41.43           C  
ATOM    496  CD1 TYR    65      87.852  93.164  66.972  1.00 38.27           C  
ATOM    497  CD2 TYR    65      87.280  90.912  66.418  1.00 41.59           C  
ATOM    498  CE1 TYR    65      89.120  92.749  67.377  1.00 40.70           C  
ATOM    499  CE2 TYR    65      88.550  90.489  66.822  1.00 45.09           C  
ATOM    500  CZ  TYR    65      89.460  91.409  67.299  1.00 42.17           C  
ATOM    501  OH  TYR    65      90.693  90.979  67.699  1.00 40.96           O  
ATOM    502  N   ASN    66      87.685  93.944  63.593  1.00 46.17           N  
ATOM    503  CA  ASN    66      88.737  93.574  62.660  1.00 47.65           C  
ATOM    504  C   ASN    66      89.911  92.902  63.383  1.00 49.38           C  
ATOM    505  O   ASN    66      90.732  93.568  63.999  1.00 50.31           O  
ATOM    506  CB  ASN    66      89.215  94.819  61.946  1.00 47.78           C  
ATOM    507  CG  ASN    66      90.256  94.527  60.923  1.00 47.90           C  
ATOM    508  OD1 ASN    66      90.794  95.442  60.318  1.00 49.13           O  
ATOM    509  ND2 ASN    66      90.552  93.247  60.710  1.00 45.03           N  
ATOM    510  N   PRO    67      90.018  91.566  63.301  1.00 50.88           N  
ATOM    511  CA  PRO    67      91.125  90.896  63.985  1.00 51.48           C  
ATOM    512  C   PRO    67      92.476  91.236  63.350  1.00 51.83           C  
ATOM    513  O   PRO    67      93.525  90.865  63.872  1.00 52.03           O  
ATOM    514  CB  PRO    67      90.772  89.428  63.819  1.00 50.88           C  
ATOM    515  CG  PRO    67      90.292  89.417  62.428  1.00 50.27           C  
ATOM    516  CD  PRO    67      89.335  90.615  62.409  1.00 51.26           C  
ATOM    517  N   PHE    68      92.447  91.941  62.226  1.00 51.67           N  
ATOM    518  CA  PHE    68      93.677  92.303  61.527  1.00 51.96           C  
ATOM    519  C   PHE    68      94.032  93.784  61.633  1.00 51.17           C  
ATOM    520  O   PHE    68      94.899  94.260  60.898  1.00 50.54           O  
ATOM    521  CB  PHE    68      93.555  91.945  60.047  1.00 52.16           C  
ATOM    522  CG  PHE    68      93.289  90.497  59.797  1.00 55.38           C  
ATOM    523  CD1 PHE    68      94.332  89.575  59.785  1.00 56.42           C  
ATOM    524  CD2 PHE    68      91.985  90.042  59.594  1.00 58.52           C  
ATOM    525  CE1 PHE    68      94.080  88.223  59.572  1.00 55.86           C  
ATOM    526  CE2 PHE    68      91.724  88.689  59.382  1.00 57.31           C  
ATOM    527  CZ  PHE    68      92.775  87.781  59.372  1.00 57.16           C  
ATOM    528  N   TRP    69      93.372  94.503  62.542  1.00 50.63           N  
ATOM    529  CA  TRP    69      93.603  95.940  62.694  1.00 50.90           C  
ATOM    530  C   TRP    69      95.071  96.320  62.846  1.00 51.38           C  
ATOM    531  O   TRP    69      95.521  97.326  62.316  1.00 50.73           O  
ATOM    532  CB  TRP    69      92.818  96.480  63.889  1.00 49.66           C  
ATOM    533  CG  TRP    69      93.264  95.906  65.183  1.00 49.78           C  
ATOM    534  CD1 TRP    69      92.800  94.774  65.775  1.00 47.87           C  
ATOM    535  CD2 TRP    69      94.302  96.408  66.032  1.00 49.42           C  
ATOM    536  NE1 TRP    69      93.478  94.536  66.941  1.00 49.11           N  
ATOM    537  CE2 TRP    69      94.411  95.524  67.126  1.00 49.69           C  
ATOM    538  CE3 TRP    69      95.154  97.522  65.977  1.00 49.81           C  
ATOM    539  CZ2 TRP    69      95.340  95.710  68.161  1.00 49.98           C  
ATOM    540  CZ3 TRP    69      96.077  97.709  67.006  1.00 48.86           C  
ATOM    541  CH2 TRP    69      96.160  96.806  68.082  1.00 50.99           C  
ATOM    542  N   ASN    70      95.801  95.490  63.574  1.00 52.70           N  
ATOM    543  CA  ASN    70      97.215  95.690  63.847  1.00 54.65           C  
ATOM    544  C   ASN    70      98.005  95.820  62.549  1.00 53.81           C  
ATOM    545  O   ASN    70      99.035  96.490  62.490  1.00 53.07           O  
ATOM    546  CB  ASN    70      97.723  94.499  64.672  1.00 56.29           C  
ATOM    547  CG  ASN    70      99.025  94.795  65.410  1.00 62.67           C  
ATOM    548  OD1 ASN    70      99.292  95.939  65.809  1.00 69.67           O  
ATOM    549  ND2 ASN    70      99.833  93.754  65.620  1.00 69.79           N  
ATOM    550  N   GLU    71      97.494  95.180  61.509  1.00 53.46           N  
ATOM    551  CA  GLU    71      98.120  95.181  60.202  1.00 53.66           C  
ATOM    552  C   GLU    71      98.038  96.539  59.483  1.00 53.22           C  
ATOM    553  O   GLU    71      98.893  96.854  58.649  1.00 53.15           O  
ATOM    554  CB  GLU    71      97.480  94.092  59.347  1.00 53.92           C  
ATOM    555  CG  GLU    71      98.156  93.870  58.026  1.00 58.69           C  
ATOM    556  CD  GLU    71      97.542  92.719  57.273  1.00 65.74           C  
ATOM    557  OE1 GLU    71      97.404  91.637  57.887  1.00 67.82           O  
ATOM    558  OE2 GLU    71      97.205  92.893  56.079  1.00 68.24           O  
ATOM    559  N   GLY    72      97.022  97.341  59.793  1.00 51.92           N  
ATOM    560  CA  GLY    72      96.920  98.636  59.147  1.00 50.61           C  
ATOM    561  C   GLY    72      95.502  99.049  58.821  1.00 49.73           C  
ATOM    562  O   GLY    72      94.600  98.212  58.787  1.00 50.44           O  
ATOM    563  N   ILE    73      95.305 100.336  58.544  1.00 47.95           N  
ATOM    564  CA  ILE    73      93.970 100.851  58.265  1.00 46.95           C  
ATOM    565  C   ILE    73      93.289 100.350  56.984  1.00 48.19           C  
ATOM    566  O   ILE    73      92.067 100.307  56.913  1.00 48.72           O  
ATOM    567  CB  ILE    73      93.965 102.408  58.279  1.00 45.94           C  
ATOM    568  CG1 ILE    73      92.529 102.910  58.439  1.00 44.83           C  
ATOM    569  CG2 ILE    73      94.575 102.956  57.005  1.00 43.64           C  
ATOM    570  CD1 ILE    73      92.435 104.343  58.871  1.00 42.31           C  
ATOM    571  N   SER    74      94.062  99.969  55.977  1.00 49.42           N  
ATOM    572  CA  SER    74      93.464  99.487  54.733  1.00 50.51           C  
ATOM    573  C   SER    74      92.662  98.231  55.036  1.00 51.13           C  
ATOM    574  O   SER    74      91.685  97.907  54.367  1.00 51.71           O  
ATOM    575  CB  SER    74      94.549  99.127  53.714  1.00 51.19           C  
ATOM    576  OG  SER    74      95.090  97.841  53.993  1.00 52.05           O  
ATOM    577  N   THR    75      93.106  97.528  56.064  1.00 51.38           N  
ATOM    578  CA  THR    75      92.490  96.288  56.472  1.00 51.08           C  
ATOM    579  C   THR    75      91.080  96.514  57.000  1.00 50.36           C  
ATOM    580  O   THR    75      90.183  95.709  56.767  1.00 50.15           O  
ATOM    581  CB  THR    75      93.368  95.617  57.536  1.00 51.62           C  
ATOM    582  OG1 THR    75      93.303  94.202  57.378  1.00 56.50           O  
ATOM    583  CG2 THR    75      92.908  95.984  58.939  1.00 50.68           C  
ATOM    584  N   SER    76      90.890  97.620  57.707  1.00 49.57           N  
ATOM    585  CA  SER    76      89.591  97.951  58.269  1.00 50.05           C  
ATOM    586  C   SER    76      88.694  98.509  57.170  1.00 50.81           C  
ATOM    587  O   SER    76      87.514  98.147  57.047  1.00 51.77           O  
ATOM    588  CB  SER    76      89.766  98.980  59.379  1.00 49.11           C  
ATOM    589  OG  SER    76      90.621  98.472  60.377  1.00 47.99           O  
ATOM    590  N   LEU    77      89.285  99.391  56.369  1.00 51.13           N  
ATOM    591  CA  LEU    77      88.623 100.039  55.248  1.00 51.45           C  
ATOM    592  C   LEU    77      88.006  99.002  54.297  1.00 51.62           C  
ATOM    593  O   LEU    77      86.872  99.147  53.844  1.00 51.07           O  
ATOM    594  CB  LEU    77      89.648 100.869  54.485  1.00 50.84           C  
ATOM    595  CG  LEU    77      89.208 102.173  53.837  1.00 52.69           C  
ATOM    596  CD1 LEU    77      90.141 102.457  52.676  1.00 53.42           C  
ATOM    597  CD2 LEU    77      87.781 102.084  53.355  1.00 53.75           C  
ATOM    598  N   LYS    78      88.761  97.957  53.991  1.00 52.16           N  
ATOM    599  CA  LYS    78      88.273  96.937  53.086  1.00 53.11           C  
ATOM    600  C   LYS    78      87.217  96.080  53.748  1.00 54.20           C  
ATOM    601  O   LYS    78      86.285  95.608  53.099  1.00 55.45           O  
ATOM    602  CB  LYS    78      89.437  96.079  52.584  1.00 52.56           C  
ATOM    603  CG  LYS    78      90.489  96.915  51.878  1.00 55.09           C  
ATOM    604  CD  LYS    78      91.324  96.128  50.892  1.00 58.22           C  
ATOM    605  CE  LYS    78      92.303  95.206  51.568  1.00 61.29           C  
ATOM    606  NZ  LYS    78      93.063  94.473  50.536  1.00 63.27           N  
ATOM    607  N   LEU    79      87.353  95.893  55.050  1.00 54.20           N  
ATOM    608  CA  LEU    79      86.397  95.088  55.777  1.00 53.58           C  
ATOM    609  C   LEU    79      85.031  95.748  55.653  1.00 53.51           C  
ATOM    610  O   LEU    79      84.059  95.111  55.263  1.00 53.13           O  
ATOM    611  CB  LEU    79      86.831  94.994  57.237  1.00 54.15           C  
ATOM    612  CG  LEU    79      86.457  93.736  58.017  1.00 55.50           C  
ATOM    613  CD1 LEU    79      86.571  92.523  57.124  1.00 57.45           C  
ATOM    614  CD2 LEU    79      87.383  93.600  59.221  1.00 55.73           C  
ATOM    615  N   GLY    80      84.972  97.039  55.959  1.00 53.82           N  
ATOM    616  CA  GLY    80      83.714  97.756  55.872  1.00 55.07           C  
ATOM    617  C   GLY    80      83.179  97.908  54.458  1.00 56.82           C  
ATOM    618  O   GLY    80      81.963  97.893  54.230  1.00 57.02           O  
ATOM    619  N   LEU    81      84.079  98.054  53.492  1.00 57.52           N  
ATOM    620  CA  LEU    81      83.648  98.220  52.116  1.00 57.35           C  
ATOM    621  C   LEU    81      82.893  97.011  51.573  1.00 57.82           C  
ATOM    622  O   LEU    81      82.142  97.142  50.619  1.00 58.82           O  
ATOM    623  CB  LEU    81      84.837  98.521  51.216  1.00 57.13           C  
ATOM    624  CG  LEU    81      84.401  99.039  49.844  1.00 56.54           C  
ATOM    625  CD1 LEU    81      83.556 100.301  50.013  1.00 58.60           C  
ATOM    626  CD2 LEU    81      85.625  99.330  48.999  1.00 55.16           C  
ATOM    627  N   ARG    82      83.091  95.837  52.163  1.00 58.01           N  
ATOM    628  CA  ARG    82      82.385  94.651  51.696  1.00 59.28           C  
ATOM    629  C   ARG    82      80.888  94.822  51.944  1.00 60.19           C  
ATOM    630  O   ARG    82      80.047  94.463  51.117  1.00 61.66           O  
ATOM    631  CB  ARG    82      82.862  93.400  52.440  1.00 58.88           C  
ATOM    632  CG  ARG    82      84.253  92.902  52.084  1.00 60.07           C  
ATOM    633  CD  ARG    82      84.664  91.815  53.061  1.00 64.01           C  
ATOM    634  NE  ARG    82      84.689  90.481  52.475  1.00 69.56           N  
ATOM    635  CZ  ARG    82      84.530  89.352  53.168  1.00 74.97           C  
ATOM    636  NH1 ARG    82      84.322  89.382  54.488  1.00 78.67           N  
ATOM    637  NH2 ARG    82      84.583  88.183  52.542  1.00 78.06           N  
ATOM    638  N   PHE    83      80.570  95.383  53.098  1.00 60.58           N  
ATOM    639  CA  PHE    83      79.201  95.589  53.510  1.00 61.91           C  
ATOM    640  C   PHE    83      78.471  96.590  52.596  1.00 62.30           C  
ATOM    641  O   PHE    83      77.239  96.590  52.521  1.00 62.65           O  
ATOM    642  CB  PHE    83      79.230  96.029  54.984  1.00 62.22           C  
ATOM    643  CG  PHE    83      77.879  96.200  55.616  1.00 66.17           C  
ATOM    644  CD1 PHE    83      77.191  97.415  55.517  1.00 71.26           C  
ATOM    645  CD2 PHE    83      77.296  95.162  56.333  1.00 69.17           C  
ATOM    646  CE1 PHE    83      75.936  97.597  56.129  1.00 71.89           C  
ATOM    647  CE2 PHE    83      76.044  95.337  56.947  1.00 72.59           C  
ATOM    648  CZ  PHE    83      75.363  96.561  56.841  1.00 71.44           C  
ATOM    649  N   PHE    84      79.223  97.416  51.874  1.00 62.51           N  
ATOM    650  CA  PHE    84      78.621  98.413  50.979  1.00 63.10           C  
ATOM    651  C   PHE    84      79.188  98.342  49.562  1.00 64.76           C  
ATOM    652  O   PHE    84      79.058  99.302  48.800  1.00 63.81           O  
ATOM    653  CB  PHE    84      78.899  99.832  51.485  1.00 62.18           C  
ATOM    654  CG  PHE    84      78.275 100.157  52.801  1.00 60.99           C  
ATOM    655  CD1 PHE    84      76.904 100.276  52.926  1.00 61.57           C  
ATOM    656  CD2 PHE    84      79.068 100.405  53.910  1.00 60.88           C  
ATOM    657  CE1 PHE    84      76.322 100.643  54.144  1.00 63.23           C  
ATOM    658  CE2 PHE    84      78.501 100.772  55.133  1.00 62.44           C  
ATOM    659  CZ  PHE    84      77.126 100.895  55.250  1.00 62.62           C  
ATOM    660  N   LYS    85      79.813  97.226  49.197  1.00 66.95           N  
ATOM    661  CA  LYS    85      80.441  97.130  47.882  1.00 69.13           C  
ATOM    662  C   LYS    85      79.574  97.522  46.688  1.00 70.31           C  
ATOM    663  O   LYS    85      80.069  98.143  45.749  1.00 71.72           O  
ATOM    664  CB  LYS    85      81.027  95.731  47.663  1.00 69.33           C  
ATOM    665  CG  LYS    85      80.041  94.693  47.173  1.00 72.38           C  
ATOM    666  CD  LYS    85      80.705  93.313  47.006  1.00 77.93           C  
ATOM    667  CE  LYS    85      81.890  93.326  46.034  1.00 79.05           C  
ATOM    668  NZ  LYS    85      82.423  91.957  45.746  1.00 80.80           N  
ATOM    669  N   ASP    86      78.290  97.185  46.710  1.00 70.75           N  
ATOM    670  CA  ASP    86      77.429  97.530  45.584  1.00 70.88           C  
ATOM    671  C   ASP    86      76.709  98.877  45.741  1.00 68.94           C  
ATOM    672  O   ASP    86      75.839  99.211  44.940  1.00 70.04           O  
ATOM    673  CB  ASP    86      76.405  96.415  45.354  1.00 72.35           C  
ATOM    674  CG  ASP    86      75.363  96.347  46.458  1.00 79.03           C  
ATOM    675  OD1 ASP    86      75.761  96.439  47.652  1.00 84.31           O  
ATOM    676  OD2 ASP    86      74.155  96.201  46.130  1.00 84.74           O  
ATOM    677  N   TYR    87      77.053  99.644  46.772  1.00 66.71           N  
ATOM    678  CA  TYR    87      76.431 100.956  46.985  1.00 64.20           C  
ATOM    679  C   TYR    87      77.049 101.957  46.031  1.00 64.05           C  
ATOM    680  O   TYR    87      78.094 101.699  45.440  1.00 64.34           O  
ATOM    681  CB  TYR    87      76.652 101.450  48.414  1.00 63.13           C  
ATOM    682  CG  TYR    87      75.656 100.939  49.422  1.00 59.15           C  
ATOM    683  CD1 TYR    87      75.514  99.576  49.662  1.00 54.93           C  
ATOM    684  CD2 TYR    87      74.858 101.828  50.142  1.00 56.10           C  
ATOM    685  CE1 TYR    87      74.593  99.106  50.605  1.00 53.69           C  
ATOM    686  CE2 TYR    87      73.935 101.380  51.080  1.00 54.90           C  
ATOM    687  CZ  TYR    87      73.805 100.017  51.311  1.00 55.64           C  
ATOM    688  OH  TYR    87      72.897  99.568  52.243  1.00 54.58           O  
ATOM    689  N   ASP    88      76.425 103.114  45.893  1.00 63.66           N  
ATOM    690  CA  ASP    88      76.956 104.114  44.983  1.00 64.27           C  
ATOM    691  C   ASP    88      78.246 104.726  45.519  1.00 63.88           C  
ATOM    692  O   ASP    88      79.174 105.003  44.759  1.00 64.49           O  
ATOM    693  CB  ASP    88      75.912 105.211  44.723  1.00 64.96           C  
ATOM    694  CG  ASP    88      74.598 104.650  44.172  1.00 66.85           C  
ATOM    695  OD1 ASP    88      74.657 103.802  43.253  1.00 66.84           O  
ATOM    696  OD2 ASP    88      73.515 105.060  44.654  1.00 69.17           O  
ATOM    697  N   ALA    89      78.302 104.927  46.831  1.00 62.91           N  
ATOM    698  CA  ALA    89      79.478 105.506  47.459  1.00 61.92           C  
ATOM    699  C   ALA    89      79.477 105.253  48.964  1.00 61.48           C  
ATOM    700  O   ALA    89      78.452 104.891  49.550  1.00 61.97           O  
ATOM    701  CB  ALA    89      79.522 107.005  47.184  1.00 61.21           C  
ATOM    702  N   VAL    90      80.636 105.432  49.588  1.00 60.01           N  
ATOM    703  CA  VAL    90      80.749 105.259  51.029  1.00 58.30           C  
ATOM    704  C   VAL    90      81.391 106.492  51.638  1.00 57.14           C  
ATOM    705  O   VAL    90      82.330 107.057  51.076  1.00 56.86           O  
ATOM    706  CB  VAL    90      81.620 104.030  51.415  1.00 58.42           C  
ATOM    707  CG1 VAL    90      80.921 102.750  51.026  1.00 59.19           C  
ATOM    708  CG2 VAL    90      82.986 104.127  50.750  1.00 56.69           C  
ATOM    709  N   LEU    91      80.869 106.918  52.779  1.00 55.61           N  
ATOM    710  CA  LEU    91      81.426 108.057  53.489  1.00 54.63           C  
ATOM    711  C   LEU    91      82.460 107.429  54.438  1.00 54.65           C  
ATOM    712  O   LEU    91      82.096 106.625  55.294  1.00 55.06           O  
ATOM    713  CB  LEU    91      80.334 108.748  54.298  1.00 53.78           C  
ATOM    714  CG  LEU    91      80.245 110.265  54.188  1.00 54.59           C  
ATOM    715  CD1 LEU    91      79.453 110.846  55.380  1.00 51.75           C  
ATOM    716  CD2 LEU    91      81.658 110.832  54.143  1.00 58.18           C  
ATOM    717  N   VAL    92      83.739 107.763  54.279  1.00 53.62           N  
ATOM    718  CA  VAL    92      84.768 107.187  55.140  1.00 52.79           C  
ATOM    719  C   VAL    92      85.057 108.091  56.320  1.00 52.56           C  
ATOM    720  O   VAL    92      85.872 109.001  56.217  1.00 53.69           O  
ATOM    721  CB  VAL    92      86.077 106.949  54.369  1.00 52.25           C  
ATOM    722  CG1 VAL    92      87.152 106.424  55.314  1.00 51.94           C  
ATOM    723  CG2 VAL    92      85.837 105.951  53.246  1.00 54.42           C  
ATOM    724  N   ALA    93      84.405 107.823  57.447  1.00 51.95           N  
ATOM    725  CA  ALA    93      84.571 108.639  58.646  1.00 51.84           C  
ATOM    726  C   ALA    93      85.574 108.062  59.635  1.00 52.15           C  
ATOM    727  O   ALA    93      85.803 106.856  59.683  1.00 52.28           O  
ATOM    728  CB  ALA    93      83.204 108.855  59.344  1.00 50.81           C  
ATOM    729  N   LEU    94      86.164 108.954  60.425  1.00 52.06           N  
ATOM    730  CA  LEU    94      87.140 108.589  61.436  1.00 52.16           C  
ATOM    731  C   LEU    94      86.519 108.758  62.808  1.00 52.91           C  
ATOM    732  O   LEU    94      85.943 109.803  63.096  1.00 52.88           O  
ATOM    733  CB  LEU    94      88.367 109.480  61.305  1.00 52.24           C  
ATOM    734  CG  LEU    94      89.047 109.292  59.954  1.00 51.55           C  
ATOM    735  CD1 LEU    94      89.981 110.437  59.677  1.00 52.65           C  
ATOM    736  CD2 LEU    94      89.772 107.968  59.958  1.00 50.12           C  
ATOM    737  N   GLY    95      86.645 107.719  63.639  1.00 52.92           N  
ATOM    738  CA  GLY    95      86.084 107.727  64.978  1.00 52.70           C  
ATOM    739  C   GLY    95      86.536 108.894  65.817  1.00 53.74           C  
ATOM    740  O   GLY    95      85.732 109.539  66.479  1.00 54.62           O  
ATOM    741  N   ASP    96      87.828 109.186  65.784  1.00 54.69           N  
ATOM    742  CA  ASP    96      88.369 110.287  66.567  1.00 55.37           C  
ATOM    743  C   ASP    96      88.098 111.692  66.000  1.00 56.11           C  
ATOM    744  O   ASP    96      88.752 112.658  66.391  1.00 57.21           O  
ATOM    745  CB  ASP    96      89.872 110.088  66.759  1.00 54.95           C  
ATOM    746  CG  ASP    96      90.627 110.138  65.458  1.00 58.10           C  
ATOM    747  OD1 ASP    96      89.983 110.169  64.388  1.00 60.60           O  
ATOM    748  OD2 ASP    96      91.872 110.139  65.500  1.00 63.56           O  
ATOM    749  N   MET    97      87.150 111.821  65.079  1.00 56.89           N  
ATOM    750  CA  MET    97      86.831 113.139  64.534  1.00 57.64           C  
ATOM    751  C   MET    97      85.379 113.487  64.838  1.00 57.73           C  
ATOM    752  O   MET    97      84.516 113.390  63.973  1.00 58.84           O  
ATOM    753  CB  MET    97      87.064 113.174  63.031  1.00 57.82           C  
ATOM    754  CG  MET    97      88.514 113.141  62.638  1.00 63.08           C  
ATOM    755  SD  MET    97      88.775 113.529  60.755  1.00 81.64          SE  
ATOM    756  CE  MET    97      90.719 113.549  60.713  1.00 79.03           C  
ATOM    757  N   PRO    98      85.097 113.909  66.080  1.00 57.33           N  
ATOM    758  CA  PRO    98      83.743 114.262  66.494  1.00 57.02           C  
ATOM    759  C   PRO    98      83.397 115.741  66.335  1.00 57.95           C  
ATOM    760  O   PRO    98      82.394 116.214  66.887  1.00 57.74           O  
ATOM    761  CB  PRO    98      83.740 113.840  67.950  1.00 56.71           C  
ATOM    762  CG  PRO    98      85.092 114.320  68.391  1.00 56.30           C  
ATOM    763  CD  PRO    98      86.005 113.905  67.244  1.00 57.38           C  
ATOM    764  N   PHE    99      84.215 116.484  65.596  1.00 58.99           N  
ATOM    765  CA  PHE    99      83.935 117.908  65.444  1.00 59.96           C  
ATOM    766  C   PHE    99      83.334 118.255  64.096  1.00 60.17           C  
ATOM    767  O   PHE    99      82.845 119.361  63.902  1.00 59.52           O  
ATOM    768  CB  PHE    99      85.192 118.738  65.731  1.00 60.42           C  
ATOM    769  CG  PHE    99      85.781 118.474  67.093  1.00 61.47           C  
ATOM    770  CD1 PHE    99      85.007 118.635  68.241  1.00 61.18           C  
ATOM    771  CD2 PHE    99      87.086 117.994  67.223  1.00 60.65           C  
ATOM    772  CE1 PHE    99      85.520 118.317  69.497  1.00 60.89           C  
ATOM    773  CE2 PHE    99      87.604 117.675  68.471  1.00 61.94           C  
ATOM    774  CZ  PHE    99      86.820 117.834  69.613  1.00 60.01           C  
ATOM    775  N   VAL   100      83.376 117.315  63.158  1.00 60.42           N  
ATOM    776  CA  VAL   100      82.751 117.542  61.868  1.00 59.65           C  
ATOM    777  C   VAL   100      81.269 117.660  62.251  1.00 59.60           C  
ATOM    778  O   VAL   100      80.797 116.968  63.151  1.00 58.98           O  
ATOM    779  CB  VAL   100      82.999 116.351  60.924  1.00 59.22           C  
ATOM    780  CG1 VAL   100      83.000 115.083  61.705  1.00 59.86           C  
ATOM    781  CG2 VAL   100      81.933 116.284  59.864  1.00 59.54           C  
ATOM    782  N   THR   101      80.538 118.551  61.594  1.00 60.41           N  
ATOM    783  CA  THR   101      79.130 118.766  61.923  1.00 60.04           C  
ATOM    784  C   THR   101      78.182 118.093  60.952  1.00 61.20           C  
ATOM    785  O   THR   101      78.576 117.754  59.839  1.00 61.16           O  
ATOM    786  CB  THR   101      78.803 120.244  61.913  1.00 59.27           C  
ATOM    787  OG1 THR   101      78.981 120.739  60.584  1.00 57.79           O  
ATOM    788  CG2 THR   101      79.711 120.997  62.861  1.00 56.24           C  
ATOM    789  N   LYS   102      76.933 117.903  61.376  1.00 62.74           N  
ATOM    790  CA  LYS   102      75.934 117.286  60.509  1.00 64.81           C  
ATOM    791  C   LYS   102      75.879 118.093  59.232  1.00 65.39           C  
ATOM    792  O   LYS   102      75.819 117.541  58.136  1.00 64.62           O  
ATOM    793  CB  LYS   102      74.548 117.289  61.156  1.00 65.69           C  
ATOM    794  CG  LYS   102      74.235 116.061  61.996  1.00 69.63           C  
ATOM    795  CD  LYS   102      72.739 115.824  62.059  1.00 74.55           C  
ATOM    796  CE  LYS   102      72.405 114.639  62.937  1.00 77.99           C  
ATOM    797  NZ  LYS   102      72.889 114.863  64.326  1.00 81.50           N  
ATOM    798  N   GLU   103      75.902 119.412  59.391  1.00 66.62           N  
ATOM    799  CA  GLU   103      75.878 120.323  58.257  1.00 68.07           C  
ATOM    800  C   GLU   103      76.974 119.993  57.244  1.00 67.62           C  
ATOM    801  O   GLU   103      76.724 119.985  56.037  1.00 67.46           O  
ATOM    802  CB  GLU   103      76.039 121.763  58.744  1.00 69.67           C  
ATOM    803  CG  GLU   103      74.842 122.277  59.505  1.00 75.46           C  
ATOM    804  CD  GLU   103      73.535 122.020  58.757  1.00 83.50           C  
ATOM    805  OE1 GLU   103      73.498 122.265  57.528  1.00 86.84           O  
ATOM    806  OE2 GLU   103      72.549 121.576  59.396  1.00 86.31           O  
ATOM    807  N   ASP   104      78.185 119.731  57.736  1.00 67.07           N  
ATOM    808  CA  ASP   104      79.305 119.393  56.867  1.00 66.63           C  
ATOM    809  C   ASP   104      78.984 118.133  56.083  1.00 66.12           C  
ATOM    810  O   ASP   104      79.264 118.044  54.886  1.00 65.91           O  
ATOM    811  CB  ASP   104      80.577 119.143  57.679  1.00 66.99           C  
ATOM    812  CG  ASP   104      81.038 120.362  58.440  1.00 68.35           C  
ATOM    813  OD1 ASP   104      80.997 121.463  57.863  1.00 72.59           O  
ATOM    814  OD2 ASP   104      81.458 120.220  59.608  1.00 65.48           O  
ATOM    815  N   VAL   105      78.405 117.150  56.761  1.00 65.88           N  
ATOM    816  CA  VAL   105      78.070 115.899  56.099  1.00 66.65           C  
ATOM    817  C   VAL   105      76.964 116.093  55.070  1.00 67.88           C  
ATOM    818  O   VAL   105      76.948 115.429  54.025  1.00 68.40           O  
ATOM    819  CB  VAL   105      77.632 114.819  57.111  1.00 66.21           C  
ATOM    820  CG1 VAL   105      77.236 113.530  56.369  1.00 63.28           C  
ATOM    821  CG2 VAL   105      78.767 114.554  58.092  1.00 64.83           C  
ATOM    822  N   ASN   106      76.046 117.006  55.372  1.00 68.52           N  
ATOM    823  CA  ASN   106      74.945 117.299  54.475  1.00 69.21           C  
ATOM    824  C   ASN   106      75.521 117.899  53.192  1.00 69.46           C  
ATOM    825  O   ASN   106      75.156 117.491  52.084  1.00 69.79           O  
ATOM    826  CB  ASN   106      73.980 118.278  55.146  1.00 70.36           C  
ATOM    827  CG  ASN   106      72.590 118.252  54.523  1.00 73.18           C  
ATOM    828  OD1 ASN   106      71.923 117.213  54.511  1.00 75.38           O  
ATOM    829  ND2 ASN   106      72.146 119.399  54.003  1.00 78.25           N  
ATOM    830  N   LYS   107      76.434 118.859  53.346  1.00 69.38           N  
ATOM    831  CA  LYS   107      77.072 119.498  52.198  1.00 69.64           C  
ATOM    832  C   LYS   107      77.833 118.484  51.361  1.00 69.90           C  
ATOM    833  O   LYS   107      77.671 118.426  50.147  1.00 70.92           O  
ATOM    834  CB  LYS   107      78.064 120.569  52.643  1.00 69.73           C  
ATOM    835  CG  LYS   107      77.466 121.815  53.240  1.00 70.89           C  
ATOM    836  CD  LYS   107      78.581 122.754  53.661  1.00 72.41           C  
ATOM    837  CE  LYS   107      78.020 123.994  54.287  1.00 75.34           C  
ATOM    838  NZ  LYS   107      77.084 123.633  55.384  1.00 78.79           N  
ATOM    839  N   ILE   108      78.674 117.694  52.018  1.00 69.99           N  
ATOM    840  CA  ILE   108      79.475 116.690  51.326  1.00 70.00           C  
ATOM    841  C   ILE   108      78.630 115.750  50.488  1.00 70.52           C  
ATOM    842  O   ILE   108      78.946 115.489  49.322  1.00 69.75           O  
ATOM    843  CB  ILE   108      80.301 115.837  52.323  1.00 69.97           C  
ATOM    844  CG1 ILE   108      81.223 116.744  53.141  1.00 68.99           C  
ATOM    845  CG2 ILE   108      81.121 114.792  51.562  1.00 67.40           C  
ATOM    846  CD1 ILE   108      82.050 116.021  54.165  1.00 68.64           C  
ATOM    847  N   ILE   109      77.559 115.235  51.084  1.00 71.82           N  
ATOM    848  CA  ILE   109      76.694 114.312  50.372  1.00 73.40           C  
ATOM    849  C   ILE   109      75.963 115.030  49.244  1.00 74.95           C  
ATOM    850  O   ILE   109      75.712 114.444  48.188  1.00 74.87           O  
ATOM    851  CB  ILE   109      75.669 113.648  51.317  1.00 72.92           C  
ATOM    852  CG1 ILE   109      76.396 112.902  52.438  1.00 72.32           C  
ATOM    853  CG2 ILE   109      74.815 112.658  50.543  1.00 73.00           C  
ATOM    854  CD1 ILE   109      75.471 112.152  53.374  1.00 72.12           C  
ATOM    855  N   ASN   110      75.640 116.304  49.454  1.00 76.62           N  
ATOM    856  CA  ASN   110      74.943 117.074  48.427  1.00 77.75           C  
ATOM    857  C   ASN   110      75.827 117.519  47.265  1.00 77.54           C  
ATOM    858  O   ASN   110      75.317 117.937  46.227  1.00 78.41           O  
ATOM    859  CB  ASN   110      74.271 118.306  49.037  1.00 78.60           C  
ATOM    860  CG  ASN   110      73.054 117.952  49.879  1.00 81.57           C  
ATOM    861  OD1 ASN   110      72.228 117.114  49.494  1.00 82.58           O  
ATOM    862  ND2 ASN   110      72.930 118.603  51.031  1.00 85.45           N  
ATOM    863  N   THR   111      77.142 117.424  47.427  1.00 76.50           N  
ATOM    864  CA  THR   111      78.069 117.836  46.379  1.00 75.76           C  
ATOM    865  C   THR   111      78.380 116.689  45.426  1.00 76.37           C  
ATOM    866  O   THR   111      78.986 116.884  44.377  1.00 76.43           O  
ATOM    867  CB  THR   111      79.388 118.337  46.994  1.00 75.39           C  
ATOM    868  OG1 THR   111      79.100 119.332  47.978  1.00 74.42           O  
ATOM    869  CG2 THR   111      80.290 118.936  45.937  1.00 75.41           C  
ATOM    870  N   PHE   112      77.945 115.491  45.788  1.00 77.34           N  
ATOM    871  CA  PHE   112      78.210 114.306  44.982  1.00 78.11           C  
ATOM    872  C   PHE   112      77.405 114.191  43.689  1.00 80.28           C  
ATOM    873  O   PHE   112      76.184 114.050  43.716  1.00 80.80           O  
ATOM    874  CB  PHE   112      77.994 113.060  45.836  1.00 76.72           C  
ATOM    875  CG  PHE   112      78.192 111.781  45.096  1.00 73.51           C  
ATOM    876  CD1 PHE   112      79.335 111.578  44.333  1.00 70.01           C  
ATOM    877  CD2 PHE   112      77.249 110.763  45.182  1.00 71.66           C  
ATOM    878  CE1 PHE   112      79.540 110.378  43.663  1.00 69.79           C  
ATOM    879  CE2 PHE   112      77.443 109.558  44.517  1.00 69.27           C  
ATOM    880  CZ  PHE   112      78.596 109.366  43.755  1.00 69.71           C  
ATOM    881  N   LYS   113      78.103 114.242  42.557  1.00 82.83           N  
ATOM    882  CA  LYS   113      77.463 114.128  41.250  1.00 85.02           C  
ATOM    883  C   LYS   113      78.089 112.966  40.486  1.00 86.49           C  
ATOM    884  O   LYS   113      79.163 112.479  40.850  1.00 86.93           O  
ATOM    885  CB  LYS   113      77.649 115.415  40.446  1.00 84.96           C  
ATOM    886  CG  LYS   113      77.320 116.675  41.213  1.00 85.92           C  
ATOM    887  CD  LYS   113      75.900 116.661  41.722  1.00 88.01           C  
ATOM    888  CE  LYS   113      75.673 117.838  42.646  1.00 90.37           C  
ATOM    889  NZ  LYS   113      74.331 117.785  43.276  1.00 92.40           N  
ATOM    890  N   PRO   114      77.430 112.511  39.406  1.00 87.82           N  
ATOM    891  CA  PRO   114      77.936 111.395  38.593  1.00 88.26           C  
ATOM    892  C   PRO   114      79.341 111.625  38.020  1.00 88.54           C  
ATOM    893  O   PRO   114      80.075 110.672  37.744  1.00 88.72           O  
ATOM    894  CB  PRO   114      76.876 111.262  37.495  1.00 88.45           C  
ATOM    895  CG  PRO   114      75.612 111.728  38.184  1.00 88.65           C  
ATOM    896  CD  PRO   114      76.107 112.954  38.921  1.00 87.87           C  
ATOM    897  N   ASN   115      79.708 112.891  37.838  1.00 88.27           N  
ATOM    898  CA  ASN   115      81.017 113.234  37.299  1.00 87.89           C  
ATOM    899  C   ASN   115      82.099 113.053  38.355  1.00 87.58           C  
ATOM    900  O   ASN   115      83.263 112.827  38.024  1.00 88.00           O  
ATOM    901  CB  ASN   115      81.011 114.676  36.803  1.00 87.90           C  
ATOM    902  N   CYS   116      81.701 113.145  39.623  1.00 86.76           N  
ATOM    903  CA  CYS   116      82.625 113.026  40.747  1.00 86.00           C  
ATOM    904  C   CYS   116      83.114 111.618  41.050  1.00 84.42           C  
ATOM    905  O   CYS   116      82.317 110.697  41.241  1.00 84.56           O  
ATOM    906  CB  CYS   116      81.992 113.593  42.023  1.00 86.32           C  
ATOM    907  SG  CYS   116      81.339 115.287  41.872  1.00 90.88           S  
ATOM    908  N   LYS   117      84.436 111.473  41.101  1.00 82.59           N  
ATOM    909  CA  LYS   117      85.085 110.208  41.429  1.00 80.48           C  
ATOM    910  C   LYS   117      85.085 110.109  42.955  1.00 78.41           C  
ATOM    911  O   LYS   117      84.997 109.026  43.536  1.00 77.64           O  
ATOM    912  CB  LYS   117      86.527 110.211  40.926  1.00 81.04           C  
ATOM    913  CG  LYS   117      86.693 109.859  39.469  1.00 83.13           C  
ATOM    914  CD  LYS   117      86.463 108.377  39.259  1.00 87.67           C  
ATOM    915  CE  LYS   117      86.861 107.948  37.863  1.00 91.25           C  
ATOM    916  NZ  LYS   117      86.017 108.607  36.834  1.00 94.86           N  
ATOM    917  N   ALA   118      85.181 111.268  43.592  1.00 75.75           N  
ATOM    918  CA  ALA   118      85.192 111.348  45.036  1.00 73.60           C  
ATOM    919  C   ALA   118      84.942 112.785  45.442  1.00 72.38           C  
ATOM    920  O   ALA   118      85.389 113.704  44.772  1.00 73.59           O  
ATOM    921  CB  ALA   118      86.529 110.890  45.564  1.00 74.01           C  
ATOM    922  N   VAL   119      84.210 112.976  46.530  1.00 70.08           N  
ATOM    923  CA  VAL   119      83.930 114.309  47.032  1.00 68.06           C  
ATOM    924  C   VAL   119      84.834 114.478  48.231  1.00 67.27           C  
ATOM    925  O   VAL   119      84.939 113.568  49.052  1.00 67.93           O  
ATOM    926  CB  VAL   119      82.487 114.445  47.513  1.00 68.04           C  
ATOM    927  CG1 VAL   119      82.307 115.773  48.190  1.00 66.10           C  
ATOM    928  CG2 VAL   119      81.532 114.315  46.355  1.00 68.91           C  
ATOM    929  N   ILE   120      85.481 115.632  48.348  1.00 65.82           N  
ATOM    930  CA  ILE   120      86.382 115.866  49.468  1.00 64.51           C  
ATOM    931  C   ILE   120      86.098 117.157  50.210  1.00 65.04           C  
ATOM    932  O   ILE   120      86.161 118.246  49.639  1.00 64.40           O  
ATOM    933  CB  ILE   120      87.863 115.901  49.012  1.00 63.92           C  
ATOM    934  CG1 ILE   120      88.264 114.544  48.425  1.00 63.65           C  
ATOM    935  CG2 ILE   120      88.763 116.263  50.187  1.00 61.60           C  
ATOM    936  CD1 ILE   120      89.684 114.494  47.896  1.00 60.61           C  
ATOM    937  N   PRO   121      85.773 117.059  51.505  1.00 65.27           N  
ATOM    938  CA  PRO   121      85.510 118.305  52.230  1.00 65.83           C  
ATOM    939  C   PRO   121      86.783 119.147  52.290  1.00 66.58           C  
ATOM    940  O   PRO   121      87.901 118.618  52.304  1.00 65.85           O  
ATOM    941  CB  PRO   121      85.050 117.820  53.605  1.00 65.49           C  
ATOM    942  CG  PRO   121      85.761 116.510  53.754  1.00 64.49           C  
ATOM    943  CD  PRO   121      85.607 115.889  52.382  1.00 64.85           C  
ATOM    944  N   THR   122      86.595 120.461  52.312  1.00 67.79           N  
ATOM    945  CA  THR   122      87.704 121.402  52.356  1.00 69.21           C  
ATOM    946  C   THR   122      87.402 122.530  53.319  1.00 69.43           C  
ATOM    947  O   THR   122      86.245 122.846  53.592  1.00 69.17           O  
ATOM    948  CB  THR   122      87.962 122.032  50.975  1.00 69.52           C  
ATOM    949  OG1 THR   122      88.161 121.001  50.000  1.00 71.78           O  
ATOM    950  CG2 THR   122      89.194 122.902  51.018  1.00 70.92           C  
ATOM    951  N   HIS   123      88.457 123.134  53.839  1.00 70.60           N  
ATOM    952  CA  HIS   123      88.293 124.250  54.742  1.00 72.73           C  
ATOM    953  C   HIS   123      89.555 125.079  54.795  1.00 74.60           C  
ATOM    954  O   HIS   123      90.575 124.650  55.336  1.00 75.01           O  
ATOM    955  CB  HIS   123      87.915 123.777  56.132  1.00 72.08           C  
ATOM    956  CG  HIS   123      87.799 124.884  57.127  1.00 72.75           C  
ATOM    957  ND1 HIS   123      88.891 125.434  57.756  1.00 74.49           N  
ATOM    958  CD2 HIS   123      86.715 125.527  57.625  1.00 73.58           C  
ATOM    959  CE1 HIS   123      88.487 126.361  58.608  1.00 74.84           C  
ATOM    960  NE2 HIS   123      87.170 126.436  58.547  1.00 73.86           N  
ATOM    961  N   LYS   124      89.463 126.272  54.207  1.00 76.62           N  
ATOM    962  CA  LYS   124      90.561 127.221  54.151  1.00 78.11           C  
ATOM    963  C   LYS   124      91.809 126.634  53.499  1.00 78.93           C  
ATOM    964  O   LYS   124      92.879 126.549  54.113  1.00 79.34           O  
ATOM    965  CB  LYS   124      90.867 127.743  55.553  1.00 78.57           C  
ATOM    966  CG  LYS   124      89.752 128.605  56.124  1.00 80.40           C  
ATOM    967  CD  LYS   124      90.060 129.065  57.544  1.00 83.67           C  
ATOM    968  CE  LYS   124      88.898 129.847  58.140  1.00 84.87           C  
ATOM    969  NZ  LYS   124      89.052 130.018  59.615  1.00 87.62           N  
ATOM    970  N   GLY   125      91.643 126.212  52.248  1.00 79.59           N  
ATOM    971  CA  GLY   125      92.753 125.675  51.485  1.00 80.41           C  
ATOM    972  C   GLY   125      93.002 124.184  51.559  1.00 81.19           C  
ATOM    973  O   GLY   125      93.167 123.532  50.525  1.00 81.94           O  
ATOM    974  N   GLU   126      93.037 123.637  52.771  1.00 81.23           N  
ATOM    975  CA  GLU   126      93.299 122.208  52.949  1.00 80.96           C  
ATOM    976  C   GLU   126      92.057 121.321  52.975  1.00 79.32           C  
ATOM    977  O   GLU   126      90.977 121.743  53.408  1.00 79.79           O  
ATOM    978  CB  GLU   126      94.115 121.994  54.225  1.00 81.55           C  
ATOM    979  CG  GLU   126      93.533 122.678  55.439  1.00 84.47           C  
ATOM    980  CD  GLU   126      94.508 122.726  56.598  1.00 89.37           C  
ATOM    981  OE1 GLU   126      94.954 121.646  57.051  1.00 90.89           O  
ATOM    982  OE2 GLU   126      94.831 123.845  57.058  1.00 91.20           O  
ATOM    983  N   ARG   127      92.225 120.093  52.489  1.00 76.70           N  
ATOM    984  CA  ARG   127      91.141 119.121  52.467  1.00 74.71           C  
ATOM    985  C   ARG   127      91.155 118.253  53.731  1.00 72.90           C  
ATOM    986  O   ARG   127      92.216 117.877  54.233  1.00 72.41           O  
ATOM    987  CB  ARG   127      91.232 118.245  51.211  1.00 74.97           C  
ATOM    988  CG  ARG   127      92.639 117.903  50.754  1.00 75.13           C  
ATOM    989  CD  ARG   127      92.898 118.419  49.339  1.00 76.10           C  
ATOM    990  NE  ARG   127      93.050 117.355  48.344  1.00 77.77           N  
ATOM    991  CZ  ARG   127      93.366 117.569  47.065  1.00 79.80           C  
ATOM    992  NH1 ARG   127      93.561 118.811  46.627  1.00 80.34           N  
ATOM    993  NH2 ARG   127      93.501 116.548  46.220  1.00 78.44           N  
ATOM    994  N   GLY   128      89.963 117.955  54.246  1.00 70.72           N  
ATOM    995  CA  GLY   128      89.845 117.150  55.450  1.00 66.93           C  
ATOM    996  C   GLY   128      88.973 115.917  55.308  1.00 64.25           C  
ATOM    997  O   GLY   128      88.916 115.298  54.250  1.00 64.67           O  
ATOM    998  N   ASN   129      88.294 115.559  56.390  1.00 61.56           N  
ATOM    999  CA  ASN   129      87.428 114.384  56.402  1.00 58.87           C  
ATOM   1000  C   ASN   129      86.078 114.722  57.020  1.00 57.79           C  
ATOM   1001  O   ASN   129      85.945 115.703  57.753  1.00 57.31           O  
ATOM   1002  CB  ASN   129      88.093 113.260  57.189  1.00 58.60           C  
ATOM   1003  CG  ASN   129      89.402 112.817  56.574  1.00 57.95           C  
ATOM   1004  OD1 ASN   129      89.422 112.151  55.537  1.00 56.78           O  
ATOM   1005  ND2 ASN   129      90.508 113.198  57.202  1.00 56.02           N  
ATOM   1006  N   PRO   130      85.071 113.869  56.797  1.00 57.42           N  
ATOM   1007  CA  PRO   130      85.104 112.632  56.014  1.00 56.93           C  
ATOM   1008  C   PRO   130      85.084 112.800  54.507  1.00 57.84           C  
ATOM   1009  O   PRO   130      84.498 113.745  53.983  1.00 58.47           O  
ATOM   1010  CB  PRO   130      83.875 111.898  56.512  1.00 56.26           C  
ATOM   1011  CG  PRO   130      82.909 113.030  56.684  1.00 57.24           C  
ATOM   1012  CD  PRO   130      83.743 114.066  57.403  1.00 56.49           C  
ATOM   1013  N   VAL   131      85.714 111.852  53.822  1.00 58.00           N  
ATOM   1014  CA  VAL   131      85.790 111.834  52.371  1.00 57.97           C  
ATOM   1015  C   VAL   131      84.782 110.849  51.776  1.00 58.42           C  
ATOM   1016  O   VAL   131      84.677 109.704  52.234  1.00 58.77           O  
ATOM   1017  CB  VAL   131      87.204 111.441  51.917  1.00 57.59           C  
ATOM   1018  CG1 VAL   131      87.198 111.014  50.476  1.00 59.19           C  
ATOM   1019  CG2 VAL   131      88.124 112.611  52.088  1.00 58.16           C  
ATOM   1020  N   LEU   132      84.055 111.293  50.750  1.00 58.08           N  
ATOM   1021  CA  LEU   132      83.058 110.449  50.092  1.00 57.65           C  
ATOM   1022  C   LEU   132      83.647 109.779  48.851  1.00 57.67           C  
ATOM   1023  O   LEU   132      83.900 110.443  47.856  1.00 59.54           O  
ATOM   1024  CB  LEU   132      81.833 111.293  49.717  1.00 57.41           C  
ATOM   1025  CG  LEU   132      80.631 110.589  49.074  1.00 58.34           C  
ATOM   1026  CD1 LEU   132      80.298 109.336  49.842  1.00 61.60           C  
ATOM   1027  CD2 LEU   132      79.430 111.512  49.063  1.00 55.91           C  
ATOM   1028  N   ILE   133      83.867 108.468  48.909  1.00 56.74           N  
ATOM   1029  CA  ILE   133      84.448 107.730  47.786  1.00 55.35           C  
ATOM   1030  C   ILE   133      83.375 106.967  47.010  1.00 55.07           C  
ATOM   1031  O   ILE   133      82.522 106.298  47.612  1.00 56.48           O  
ATOM   1032  CB  ILE   133      85.510 106.710  48.265  1.00 55.20           C  
ATOM   1033  CG1 ILE   133      86.601 107.417  49.071  1.00 56.29           C  
ATOM   1034  CG2 ILE   133      86.114 105.996  47.063  1.00 55.79           C  
ATOM   1035  CD1 ILE   133      87.725 106.513  49.499  1.00 57.86           C  
ATOM   1036  N   SER   134      83.443 107.040  45.679  1.00 52.85           N  
ATOM   1037  CA  SER   134      82.458 106.394  44.805  1.00 51.80           C  
ATOM   1038  C   SER   134      82.815 104.995  44.295  1.00 52.90           C  
ATOM   1039  O   SER   134      83.985 104.657  44.136  1.00 53.54           O  
ATOM   1040  CB  SER   134      82.181 107.294  43.602  1.00 51.85           C  
ATOM   1041  OG  SER   134      83.293 107.298  42.722  1.00 47.09           O  
ATOM   1042  N   LYS   135      81.789 104.200  44.007  1.00 55.28           N  
ATOM   1043  CA  LYS   135      81.978 102.836  43.526  1.00 57.82           C  
ATOM   1044  C   LYS   135      83.063 102.729  42.459  1.00 59.79           C  
ATOM   1045  O   LYS   135      83.720 101.689  42.340  1.00 60.63           O  
ATOM   1046  CB  LYS   135      80.648 102.266  42.992  1.00 56.16           C  
ATOM   1047  N   SER   136      83.259 103.791  41.681  1.00 62.28           N  
ATOM   1048  CA  SER   136      84.284 103.751  40.639  1.00 63.96           C  
ATOM   1049  C   SER   136      85.636 103.438  41.283  1.00 64.38           C  
ATOM   1050  O   SER   136      86.423 102.647  40.741  1.00 65.17           O  
ATOM   1051  CB  SER   136      84.355 105.083  39.887  1.00 64.03           C  
ATOM   1052  OG  SER   136      84.767 106.133  40.741  1.00 67.09           O  
ATOM   1053  N   LEU   137      85.880 104.042  42.448  1.00 64.20           N  
ATOM   1054  CA  LEU   137      87.118 103.840  43.199  1.00 64.30           C  
ATOM   1055  C   LEU   137      87.153 102.611  44.128  1.00 63.64           C  
ATOM   1056  O   LEU   137      88.192 102.327  44.717  1.00 63.46           O  
ATOM   1057  CB  LEU   137      87.443 105.078  44.042  1.00 64.99           C  
ATOM   1058  CG  LEU   137      87.910 106.363  43.359  1.00 67.10           C  
ATOM   1059  CD1 LEU   137      89.022 106.027  42.382  1.00 68.80           C  
ATOM   1060  CD2 LEU   137      86.754 107.025  42.647  1.00 70.31           C  
ATOM   1061  N   PHE   138      86.051 101.882  44.282  1.00 62.43           N  
ATOM   1062  CA  PHE   138      86.104 100.728  45.172  1.00 62.24           C  
ATOM   1063  C   PHE   138      87.174  99.736  44.722  1.00 63.75           C  
ATOM   1064  O   PHE   138      87.849  99.132  45.552  1.00 65.01           O  
ATOM   1065  CB  PHE   138      84.746 100.011  45.275  1.00 60.61           C  
ATOM   1066  CG  PHE   138      83.649 100.842  45.899  1.00 55.89           C  
ATOM   1067  CD1 PHE   138      83.911 102.108  46.424  1.00 52.20           C  
ATOM   1068  CD2 PHE   138      82.341 100.363  45.939  1.00 54.02           C  
ATOM   1069  CE1 PHE   138      82.884 102.891  46.974  1.00 50.00           C  
ATOM   1070  CE2 PHE   138      81.306 101.135  46.485  1.00 53.26           C  
ATOM   1071  CZ  PHE   138      81.580 102.401  47.005  1.00 52.41           C  
ATOM   1072  N   ASN   139      87.350  99.558  43.418  1.00 65.81           N  
ATOM   1073  CA  ASN   139      88.372  98.615  42.955  1.00 67.56           C  
ATOM   1074  C   ASN   139      89.744  99.043  43.470  1.00 68.24           C  
ATOM   1075  O   ASN   139      90.535  98.219  43.918  1.00 68.02           O  
ATOM   1076  CB  ASN   139      88.384  98.539  41.433  1.00 67.28           C  
ATOM   1077  N   GLU   140      90.012 100.342  43.413  1.00 69.37           N  
ATOM   1078  CA  GLU   140      91.285 100.880  43.863  1.00 70.51           C  
ATOM   1079  C   GLU   140      91.556 100.634  45.329  1.00 70.69           C  
ATOM   1080  O   GLU   140      92.644 100.196  45.703  1.00 71.04           O  
ATOM   1081  CB  GLU   140      91.342 102.380  43.597  1.00 71.48           C  
ATOM   1082  CG  GLU   140      91.568 102.719  42.147  1.00 74.90           C  
ATOM   1083  CD  GLU   140      92.902 102.195  41.651  1.00 79.72           C  
ATOM   1084  OE1 GLU   140      93.952 102.688  42.138  1.00 80.78           O  
ATOM   1085  OE2 GLU   140      92.894 101.287  40.783  1.00 81.31           O  
ATOM   1086  N   ILE   141      90.568 100.928  46.166  1.00 71.01           N  
ATOM   1087  CA  ILE   141      90.736 100.754  47.598  1.00 70.87           C  
ATOM   1088  C   ILE   141      91.025  99.294  47.941  1.00 70.05           C  
ATOM   1089  O   ILE   141      91.832  99.015  48.828  1.00 70.27           O  
ATOM   1090  CB  ILE   141      89.507 101.342  48.385  1.00 71.02           C  
ATOM   1091  CG1 ILE   141      89.560 100.931  49.851  1.00 72.11           C  
ATOM   1092  CG2 ILE   141      88.219 100.909  47.761  1.00 71.02           C  
ATOM   1093  CD1 ILE   141      88.892  99.606  50.139  1.00 75.02           C  
ATOM   1094  N   GLU   142      90.410  98.365  47.217  1.00 69.37           N  
ATOM   1095  CA  GLU   142      90.659  96.947  47.467  1.00 69.15           C  
ATOM   1096  C   GLU   142      92.147  96.636  47.267  1.00 68.76           C  
ATOM   1097  O   GLU   142      92.722  95.818  47.981  1.00 68.80           O  
ATOM   1098  CB  GLU   142      89.813  96.086  46.535  1.00 68.61           C  
ATOM   1099  N   LYS   143      92.766  97.308  46.299  1.00 68.67           N  
ATOM   1100  CA  LYS   143      94.184  97.113  45.980  1.00 68.20           C  
ATOM   1101  C   LYS   143      95.122  97.568  47.105  1.00 67.70           C  
ATOM   1102  O   LYS   143      96.254  97.090  47.225  1.00 68.14           O  
ATOM   1103  CB  LYS   143      94.525  97.850  44.676  1.00 68.56           C  
ATOM   1104  N   LEU   144      94.645  98.499  47.921  1.00 66.67           N  
ATOM   1105  CA  LEU   144      95.408  99.020  49.049  1.00 65.38           C  
ATOM   1106  C   LEU   144      96.016  97.900  49.921  1.00 64.92           C  
ATOM   1107  O   LEU   144      95.476  96.787  49.994  1.00 64.21           O  
ATOM   1108  CB  LEU   144      94.483  99.898  49.897  1.00 65.48           C  
ATOM   1109  CG  LEU   144      94.824 101.371  50.106  1.00 66.58           C  
ATOM   1110  CD1 LEU   144      95.439 101.960  48.858  1.00 67.08           C  
ATOM   1111  CD2 LEU   144      93.557 102.119  50.485  1.00 66.22           C  
ATOM   1112  N   ARG   145      97.138  98.207  50.578  1.00 64.60           N  
ATOM   1113  CA  ARG   145      97.823  97.256  51.465  1.00 64.15           C  
ATOM   1114  C   ARG   145      98.183  97.860  52.819  1.00 63.00           C  
ATOM   1115  O   ARG   145      98.368  99.075  52.951  1.00 62.62           O  
ATOM   1116  CB  ARG   145      99.101  96.724  50.813  1.00 64.74           C  
ATOM   1117  CG  ARG   145      98.853  95.634  49.791  1.00 69.68           C  
ATOM   1118  CD  ARG   145      99.825  95.721  48.615  1.00 76.97           C  
ATOM   1119  NE  ARG   145     101.228  95.680  49.025  1.00 79.89           N  
ATOM   1120  CZ  ARG   145     101.807  94.649  49.633  1.00 80.04           C  
ATOM   1121  NH1 ARG   145     101.106  93.557  49.911  1.00 77.46           N  
ATOM   1122  NH2 ARG   145     103.091  94.713  49.966  1.00 80.64           N  
ATOM   1123  N   GLY   146      98.270  96.987  53.819  1.00 61.83           N  
ATOM   1124  CA  GLY   146      98.634  97.387  55.168  1.00 59.45           C  
ATOM   1125  C   GLY   146      97.976  98.610  55.772  1.00 58.65           C  
ATOM   1126  O   GLY   146      96.751  98.673  55.929  1.00 57.38           O  
ATOM   1127  N   ASP   147      98.812  99.585  56.120  1.00 57.90           N  
ATOM   1128  CA  ASP   147      98.349 100.817  56.742  1.00 57.47           C  
ATOM   1129  C   ASP   147      98.253 101.992  55.776  1.00 57.66           C  
ATOM   1130  O   ASP   147      98.311 103.150  56.189  1.00 58.10           O  
ATOM   1131  CB  ASP   147      99.268 101.203  57.894  1.00 56.82           C  
ATOM   1132  CG  ASP   147      98.572 102.069  58.919  1.00 58.56           C  
ATOM   1133  OD1 ASP   147      99.230 102.956  59.494  1.00 60.43           O  
ATOM   1134  OD2 ASP   147      97.365 101.852  59.160  1.00 61.44           O  
ATOM   1135  N   VAL   148      98.118 101.695  54.491  1.00 57.82           N  
ATOM   1136  CA  VAL   148      97.990 102.741  53.491  1.00 57.65           C  
ATOM   1137  C   VAL   148      96.523 103.100  53.383  1.00 58.26           C  
ATOM   1138  O   VAL   148      95.702 102.241  53.075  1.00 57.77           O  
ATOM   1139  CB  VAL   148      98.470 102.259  52.130  1.00 57.60           C  
ATOM   1140  CG1 VAL   148      98.224 103.321  51.090  1.00 55.84           C  
ATOM   1141  CG2 VAL   148      99.929 101.907  52.207  1.00 57.70           C  
ATOM   1142  N   GLY   149      96.205 104.367  53.632  1.00 59.53           N  
ATOM   1143  CA  GLY   149      94.829 104.826  53.570  1.00 61.31           C  
ATOM   1144  C   GLY   149      94.349 105.192  52.182  1.00 63.72           C  
ATOM   1145  O   GLY   149      95.051 104.994  51.189  1.00 64.43           O  
ATOM   1146  N   ALA   150      93.147 105.746  52.110  1.00 65.36           N  
ATOM   1147  CA  ALA   150      92.564 106.128  50.831  1.00 67.42           C  
ATOM   1148  C   ALA   150      93.150 107.416  50.231  1.00 68.74           C  
ATOM   1149  O   ALA   150      93.027 107.648  49.025  1.00 68.20           O  
ATOM   1150  CB  ALA   150      91.052 106.251  50.975  1.00 67.32           C  
ATOM   1151  N   ARG   151      93.794 108.241  51.058  1.00 71.18           N  
ATOM   1152  CA  ARG   151      94.378 109.491  50.570  1.00 74.01           C  
ATOM   1153  C   ARG   151      95.388 109.269  49.453  1.00 75.14           C  
ATOM   1154  O   ARG   151      95.635 110.154  48.635  1.00 75.26           O  
ATOM   1155  CB  ARG   151      95.047 110.262  51.702  1.00 74.25           C  
ATOM   1156  CG  ARG   151      95.632 111.606  51.257  1.00 77.89           C  
ATOM   1157  CD  ARG   151      95.776 112.564  52.437  1.00 84.37           C  
ATOM   1158  NE  ARG   151      96.526 111.945  53.525  1.00 89.32           N  
ATOM   1159  CZ  ARG   151      97.811 111.612  53.452  1.00 91.28           C  
ATOM   1160  NH1 ARG   151      98.501 111.848  52.338  1.00 90.83           N  
ATOM   1161  NH2 ARG   151      98.400 111.020  54.487  1.00 92.52           N  
ATOM   1162  N   VAL   152      95.969 108.080  49.420  1.00 76.27           N  
ATOM   1163  CA  VAL   152      96.933 107.758  48.390  1.00 77.39           C  
ATOM   1164  C   VAL   152      96.218 107.653  47.055  1.00 77.89           C  
ATOM   1165  O   VAL   152      96.724 108.117  46.035  1.00 77.93           O  
ATOM   1166  CB  VAL   152      97.636 106.434  48.695  1.00 77.65           C  
ATOM   1167  CG1 VAL   152      98.684 106.155  47.643  1.00 76.78           C  
ATOM   1168  CG2 VAL   152      98.274 106.505  50.072  1.00 80.17           C  
ATOM   1169  N   ILE   153      95.033 107.050  47.069  1.00 78.94           N  
ATOM   1170  CA  ILE   153      94.243 106.886  45.852  1.00 79.79           C  
ATOM   1171  C   ILE   153      93.630 108.209  45.401  1.00 80.54           C  
ATOM   1172  O   ILE   153      93.329 108.391  44.220  1.00 80.78           O  
ATOM   1173  CB  ILE   153      93.086 105.892  46.051  1.00 79.53           C  
ATOM   1174  CG1 ILE   153      93.615 104.580  46.613  1.00 79.70           C  
ATOM   1175  CG2 ILE   153      92.392 105.624  44.723  1.00 78.74           C  
ATOM   1176  CD1 ILE   153      92.523 103.590  46.929  1.00 81.12           C  
ATOM   1177  N   LEU   154      93.443 109.130  46.344  1.00 81.43           N  
ATOM   1178  CA  LEU   154      92.851 110.427  46.027  1.00 81.93           C  
ATOM   1179  C   LEU   154      93.848 111.409  45.398  1.00 83.02           C  
ATOM   1180  O   LEU   154      93.465 112.300  44.639  1.00 83.08           O  
ATOM   1181  CB  LEU   154      92.225 111.044  47.288  1.00 81.24           C  
ATOM   1182  CG  LEU   154      91.005 110.341  47.899  1.00 79.35           C  
ATOM   1183  CD1 LEU   154      90.423 111.199  49.010  1.00 76.84           C  
ATOM   1184  CD2 LEU   154      89.957 110.092  46.833  1.00 78.09           C  
ATOM   1185  N   ASN   155      95.129 111.239  45.700  1.00 84.48           N  
ATOM   1186  CA  ASN   155      96.142 112.132  45.157  1.00 85.67           C  
ATOM   1187  C   ASN   155      96.621 111.689  43.787  1.00 86.38           C  
ATOM   1188  O   ASN   155      97.555 112.265  43.236  1.00 87.30           O  
ATOM   1189  CB  ASN   155      97.325 112.227  46.121  1.00 85.40           C  
ATOM   1190  CG  ASN   155      96.916 112.754  47.478  1.00 86.53           C  
ATOM   1191  OD1 ASN   155      96.189 113.743  47.572  1.00 89.43           O  
ATOM   1192  ND2 ASN   155      97.381 112.102  48.538  1.00 88.56           N  
ATOM   1193  N   LYS   156      95.978 110.669  43.234  1.00 86.65           N  
ATOM   1194  CA  LYS   156      96.355 110.163  41.924  1.00 87.07           C  
ATOM   1195  C   LYS   156      95.167 110.174  40.964  1.00 88.18           C  
ATOM   1196  O   LYS   156      95.101 109.362  40.039  1.00 88.52           O  
ATOM   1197  CB  LYS   156      96.917 108.754  42.049  1.00 86.22           C  
ATOM   1198  N   ILE   157      94.216 111.076  41.192  1.00 89.25           N  
ATOM   1199  CA  ILE   157      93.061 111.177  40.306  1.00 90.64           C  
ATOM   1200  C   ILE   157      92.924 112.613  39.819  1.00 91.38           C  
ATOM   1201  O   ILE   157      93.121 113.564  40.587  1.00 91.57           O  
ATOM   1202  CB  ILE   157      91.731 110.739  40.989  1.00 90.77           C  
ATOM   1203  CG1 ILE   157      91.471 111.576  42.236  1.00 91.50           C  
ATOM   1204  CG2 ILE   157      91.781 109.258  41.332  1.00 90.73           C  
ATOM   1205  CD1 ILE   157      90.091 111.361  42.823  1.00 92.69           C  
ATOM   1206  N   LYS   158      92.593 112.748  38.535  1.00 91.96           N  
ATOM   1207  CA  LYS   158      92.438 114.037  37.862  1.00 92.43           C  
ATOM   1208  C   LYS   158      91.547 115.037  38.592  1.00 92.49           C  
ATOM   1209  O   LYS   158      90.382 114.753  38.871  1.00 92.57           O  
ATOM   1210  CB  LYS   158      91.908 113.810  36.451  1.00 92.67           C  
ATOM   1211  N   ILE   159      92.100 116.215  38.877  1.00 92.42           N  
ATOM   1212  CA  ILE   159      91.364 117.269  39.573  1.00 93.01           C  
ATOM   1213  C   ILE   159      90.042 117.573  38.853  1.00 93.01           C  
ATOM   1214  O   ILE   159      89.114 118.143  39.440  1.00 93.13           O  
ATOM   1215  CB  ILE   159      92.188 118.581  39.649  1.00 93.16           C  
ATOM   1216  CG1 ILE   159      93.679 118.262  39.744  1.00 93.98           C  
ATOM   1217  CG2 ILE   159      91.762 119.392  40.874  1.00 92.59           C  
ATOM   1218  CD1 ILE   159      94.577 119.483  39.653  1.00 94.92           C  
ATOM   1219  N   GLU   160      89.963 117.196  37.579  1.00 92.43           N  
ATOM   1220  CA  GLU   160      88.762 117.430  36.794  1.00 91.90           C  
ATOM   1221  C   GLU   160      87.733 116.371  37.149  1.00 91.72           C  
ATOM   1222  O   GLU   160      86.686 116.271  36.510  1.00 91.47           O  
ATOM   1223  CB  GLU   160      89.089 117.375  35.303  1.00 91.77           C  
ATOM   1224  N   GLU   161      88.037 115.586  38.180  1.00 91.67           N  
ATOM   1225  CA  GLU   161      87.147 114.517  38.625  1.00 91.68           C  
ATOM   1226  C   GLU   161      86.845 114.537  40.126  1.00 90.79           C  
ATOM   1227  O   GLU   161      85.991 113.785  40.602  1.00 90.51           O  
ATOM   1228  CB  GLU   161      87.730 113.160  38.217  1.00 92.12           C  
ATOM   1229  CG  GLU   161      87.775 112.968  36.707  1.00 93.63           C  
ATOM   1230  CD  GLU   161      88.567 111.747  36.282  1.00 96.44           C  
ATOM   1231  OE1 GLU   161      89.811 111.760  36.419  1.00 95.88           O  
ATOM   1232  OE2 GLU   161      87.940 110.775  35.811  1.00 98.07           O  
ATOM   1233  N   LEU   162      87.548 115.385  40.871  1.00 89.70           N  
ATOM   1234  CA  LEU   162      87.294 115.503  42.300  1.00 89.10           C  
ATOM   1235  C   LEU   162      86.207 116.551  42.486  1.00 88.72           C  
ATOM   1236  O   LEU   162      85.885 117.288  41.560  1.00 89.15           O  
ATOM   1237  CB  LEU   162      88.553 115.929  43.061  1.00 89.13           C  
ATOM   1238  CG  LEU   162      89.606 114.852  43.310  1.00 89.45           C  
ATOM   1239  CD1 LEU   162      90.307 114.543  42.011  1.00 91.38           C  
ATOM   1240  CD2 LEU   162      90.605 115.324  44.347  1.00 88.04           C  
ATOM   1241  N   CYS   163      85.637 116.614  43.681  1.00 88.09           N  
ATOM   1242  CA  CYS   163      84.587 117.580  43.968  1.00 87.74           C  
ATOM   1243  C   CYS   163      84.738 118.035  45.410  1.00 86.55           C  
ATOM   1244  O   CYS   163      84.544 117.260  46.342  1.00 87.43           O  
ATOM   1245  CB  CYS   163      83.212 116.942  43.719  1.00 87.82           C  
ATOM   1246  SG  CYS   163      82.989 116.485  41.964  1.00 91.64           S  
ATOM   1247  N   PHE   164      85.096 119.298  45.590  1.00 84.52           N  
ATOM   1248  CA  PHE   164      85.305 119.839  46.919  1.00 83.15           C  
ATOM   1249  C   PHE   164      84.154 120.712  47.388  1.00 83.06           C  
ATOM   1250  O   PHE   164      83.250 121.019  46.622  1.00 83.89           O  
ATOM   1251  CB  PHE   164      86.589 120.658  46.921  1.00 82.45           C  
ATOM   1252  CG  PHE   164      87.750 119.951  46.296  1.00 82.05           C  
ATOM   1253  CD1 PHE   164      88.496 119.028  47.023  1.00 82.19           C  
ATOM   1254  CD2 PHE   164      88.092 120.191  44.975  1.00 81.98           C  
ATOM   1255  CE1 PHE   164      89.567 118.349  46.436  1.00 80.81           C  
ATOM   1256  CE2 PHE   164      89.158 119.517  44.382  1.00 82.43           C  
ATOM   1257  CZ  PHE   164      89.899 118.596  45.116  1.00 80.76           C  
ATOM   1258  N   ILE   165      84.194 121.082  48.665  1.00 82.73           N  
ATOM   1259  CA  ILE   165      83.211 121.965  49.289  1.00 82.62           C  
ATOM   1260  C   ILE   165      83.750 122.403  50.634  1.00 82.13           C  
ATOM   1261  O   ILE   165      84.364 121.619  51.355  1.00 82.40           O  
ATOM   1262  CB  ILE   165      81.819 121.317  49.546  1.00 82.92           C  
ATOM   1263  CG1 ILE   165      81.972 119.925  50.151  1.00 84.16           C  
ATOM   1264  CG2 ILE   165      81.006 121.307  48.272  1.00 84.02           C  
ATOM   1265  CD1 ILE   165      82.258 118.853  49.132  1.00 85.27           C  
ATOM   1266  N   GLU   166      83.519 123.664  50.965  1.00 81.04           N  
ATOM   1267  CA  GLU   166      83.980 124.201  52.224  1.00 80.04           C  
ATOM   1268  C   GLU   166      83.012 123.838  53.317  1.00 78.84           C  
ATOM   1269  O   GLU   166      81.819 124.131  53.224  1.00 79.05           O  
ATOM   1270  CB  GLU   166      84.098 125.715  52.143  1.00 80.39           C  
ATOM   1271  CG  GLU   166      85.356 126.183  51.475  1.00 81.73           C  
ATOM   1272  CD  GLU   166      86.570 126.002  52.358  1.00 84.18           C  
ATOM   1273  OE1 GLU   166      86.607 126.634  53.445  1.00 81.27           O  
ATOM   1274  OE2 GLU   166      87.480 125.233  51.962  1.00 87.18           O  
ATOM   1275  N   CYS   167      83.534 123.188  54.350  1.00 77.43           N  
ATOM   1276  CA  CYS   167      82.735 122.793  55.498  1.00 75.91           C  
ATOM   1277  C   CYS   167      83.425 123.449  56.682  1.00 75.37           C  
ATOM   1278  O   CYS   167      84.381 124.194  56.486  1.00 75.36           O  
ATOM   1279  CB  CYS   167      82.721 121.273  55.624  1.00 75.12           C  
ATOM   1280  SG  CYS   167      82.137 120.444  54.115  1.00 74.97           S  
ATOM   1281  N   SER   168      82.950 123.196  57.896  1.00 74.67           N  
ATOM   1282  CA  SER   168      83.546 123.796  59.087  1.00 74.46           C  
ATOM   1283  C   SER   168      84.979 123.341  59.315  1.00 74.78           C  
ATOM   1284  O   SER   168      85.503 122.490  58.590  1.00 74.75           O  
ATOM   1285  CB  SER   168      82.711 123.466  60.324  1.00 74.60           C  
ATOM   1286  OG  SER   168      82.611 122.068  60.524  1.00 75.49           O  
ATOM   1287  N   GLU   169      85.621 123.909  60.328  1.00 74.91           N  
ATOM   1288  CA  GLU   169      86.993 123.531  60.624  1.00 75.60           C  
ATOM   1289  C   GLU   169      87.033 122.111  61.208  1.00 75.03           C  
ATOM   1290  O   GLU   169      88.088 121.463  61.235  1.00 74.81           O  
ATOM   1291  CB  GLU   169      87.621 124.531  61.599  1.00 75.85           C  
ATOM   1292  CG  GLU   169      86.996 124.527  62.974  1.00 78.98           C  
ATOM   1293  CD  GLU   169      87.788 125.349  63.971  1.00 84.36           C  
ATOM   1294  OE1 GLU   169      89.031 125.397  63.838  1.00 85.45           O  
ATOM   1295  OE2 GLU   169      87.173 125.926  64.895  1.00 86.32           O  
ATOM   1296  N   GLY   170      85.872 121.634  61.661  1.00 74.49           N  
ATOM   1297  CA  GLY   170      85.775 120.301  62.230  1.00 73.18           C  
ATOM   1298  C   GLY   170      86.207 119.243  61.235  1.00 72.55           C  
ATOM   1299  O   GLY   170      86.525 118.121  61.612  1.00 73.48           O  
ATOM   1300  N   VAL   171      86.216 119.606  59.961  1.00 71.29           N  
ATOM   1301  CA  VAL   171      86.618 118.706  58.894  1.00 70.37           C  
ATOM   1302  C   VAL   171      88.126 118.515  58.897  1.00 69.66           C  
ATOM   1303  O   VAL   171      88.662 117.689  58.156  1.00 68.11           O  
ATOM   1304  CB  VAL   171      86.207 119.282  57.534  1.00 71.15           C  
ATOM   1305  CG1 VAL   171      86.843 118.491  56.404  1.00 72.17           C  
ATOM   1306  CG2 VAL   171      84.702 119.258  57.411  1.00 71.59           C  
ATOM   1307  N   LEU   172      88.808 119.284  59.740  1.00 70.43           N  
ATOM   1308  CA  LEU   172      90.262 119.220  59.819  1.00 71.06           C  
ATOM   1309  C   LEU   172      90.784 118.808  61.188  1.00 71.89           C  
ATOM   1310  O   LEU   172      91.947 118.422  61.330  1.00 72.18           O  
ATOM   1311  CB  LEU   172      90.859 120.579  59.460  1.00 70.49           C  
ATOM   1312  CG  LEU   172      90.604 121.171  58.072  1.00 71.03           C  
ATOM   1313  CD1 LEU   172      91.313 122.497  57.991  1.00 69.40           C  
ATOM   1314  CD2 LEU   172      91.105 120.243  56.971  1.00 72.40           C  
ATOM   1315  N   ILE   173      89.920 118.877  62.191  1.00 72.89           N  
ATOM   1316  CA  ILE   173      90.302 118.553  63.556  1.00 74.89           C  
ATOM   1317  C   ILE   173      89.966 117.147  64.029  1.00 75.88           C  
ATOM   1318  O   ILE   173      88.888 116.631  63.764  1.00 77.01           O  
ATOM   1319  CB  ILE   173      89.634 119.534  64.529  1.00 74.91           C  
ATOM   1320  CG1 ILE   173      89.966 120.971  64.114  1.00 75.25           C  
ATOM   1321  CG2 ILE   173      90.062 119.233  65.966  1.00 75.63           C  
ATOM   1322  CD1 ILE   173      89.124 122.017  64.825  1.00 77.55           C  
ATOM   1323  N   ASP   174      90.900 116.536  64.742  1.00 77.31           N  
ATOM   1324  CA  ASP   174      90.693 115.212  65.312  1.00 78.94           C  
ATOM   1325  C   ASP   174      91.163 115.357  66.754  1.00 79.67           C  
ATOM   1326  O   ASP   174      91.927 116.269  67.053  1.00 79.46           O  
ATOM   1327  CB  ASP   174      91.515 114.159  64.575  1.00 79.22           C  
ATOM   1328  CG  ASP   174      92.986 114.352  64.757  1.00 80.14           C  
ATOM   1329  OD1 ASP   174      93.473 114.155  65.890  1.00 84.16           O  
ATOM   1330  OD2 ASP   174      93.654 114.714  63.769  1.00 82.30           O  
ATOM   1331  N   ILE   175      90.709 114.474  67.640  1.00 80.72           N  
ATOM   1332  CA  ILE   175      91.065 114.561  69.055  1.00 81.80           C  
ATOM   1333  C   ILE   175      92.454 115.112  69.310  1.00 83.81           C  
ATOM   1334  O   ILE   175      92.608 116.069  70.067  1.00 84.37           O  
ATOM   1335  CB  ILE   175      90.933 113.211  69.766  1.00 81.18           C  
ATOM   1336  CG1 ILE   175      89.501 112.710  69.642  1.00 80.88           C  
ATOM   1337  CG2 ILE   175      91.239 113.373  71.235  1.00 78.89           C  
ATOM   1338  CD1 ILE   175      88.482 113.718  70.110  1.00 80.65           C  
ATOM   1339  N   ASP   176      93.462 114.527  68.675  1.00 85.66           N  
ATOM   1340  CA  ASP   176      94.826 115.003  68.853  1.00 87.67           C  
ATOM   1341  C   ASP   176      94.997 116.454  68.411  1.00 88.57           C  
ATOM   1342  O   ASP   176      95.491 117.284  69.176  1.00 88.51           O  
ATOM   1343  CB  ASP   176      95.794 114.119  68.078  1.00 88.25           C  
ATOM   1344  CG  ASP   176      95.807 112.694  68.588  1.00 91.14           C  
ATOM   1345  OD1 ASP   176      96.135 112.497  69.785  1.00 94.37           O  
ATOM   1346  OD2 ASP   176      95.487 111.777  67.793  1.00 93.54           O  
ATOM   1347  N   LYS   177      94.579 116.758  67.182  1.00 89.58           N  
ATOM   1348  CA  LYS   177      94.696 118.112  66.627  1.00 90.14           C  
ATOM   1349  C   LYS   177      94.159 119.185  67.567  1.00 90.65           C  
ATOM   1350  O   LYS   177      94.568 120.342  67.494  1.00 91.35           O  
ATOM   1351  CB  LYS   177      93.983 118.193  65.279  1.00 89.55           C  
ATOM   1352  N   LYS   178      93.238 118.801  68.444  1.00 90.82           N  
ATOM   1353  CA  LYS   178      92.670 119.738  69.400  1.00 91.07           C  
ATOM   1354  C   LYS   178      93.395 119.565  70.731  1.00 91.59           C  
ATOM   1355  O   LYS   178      92.770 119.099  71.711  1.00 92.20           O  
ATOM   1356  CB  LYS   178      91.170 119.489  69.564  1.00 90.86           C  
END
