
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  256 ( 2041),  selected  256 , name 2ioh_C
# Molecule2: number of CA atoms  141 ( 1112),  selected  141 , name T0418_2_16_86_211.pdb
# PARAMETERS: 2ioh_C.T0418_2_16_86_211.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     5_C      K       2          3.361
LGA    I     6_C      Y       3          1.531
LGA    E     7_C      T       4          1.234
LGA    A     8_C      V       5          0.083
LGA    V     9_C      Y       6          0.421
LGA    I    10_C      L       7          0.231
LGA    F    11_C      F       8          0.335
LGA    D    12_C      D       9          0.445
LGA    W    13_C      F      10          0.401
LGA    A    14_C      D      11          0.826
LGA    G    15_C      Y      12          0.139
LGA    T    16_C      T      13          0.381
LGA    T    17_C      L      14          0.577
LGA    V    18_C      A      15          0.860
LGA    D    19_C      D      16          1.564
LGA    Y    20_C      -       -           -
LGA    G    21_C      -       -           -
LGA    C    22_C      -       -           -
LGA    F    23_C      -       -           -
LGA    A    24_C      -       -           -
LGA    P    25_C      -       -           -
LGA    L    26_C      -       -           -
LGA    E    27_C      -       -           -
LGA    V    28_C      -       -           -
LGA    F    29_C      -       -           -
LGA    M    30_C      -       -           -
LGA    E    31_C      -       -           -
LGA    I    32_C      -       -           -
LGA    F    33_C      -       -           -
LGA    H    34_C      -       -           -
LGA    K    35_C      -       -           -
LGA    R    36_C      -       -           -
LGA    G    37_C      -       -           -
LGA    V    38_C      -       -           -
LGA    A    39_C      -       -           -
LGA    I    40_C      -       -           -
LGA    T    41_C      -       -           -
LGA    A    42_C      -       -           -
LGA    E    43_C      -       -           -
LGA    E    44_C      -       -           -
LGA    A    45_C      -       -           -
LGA    R    46_C      -       -           -
LGA    K    47_C      -       -           -
LGA    P    48_C      -       -           -
LGA    M    49_C      -       -           -
LGA    G    50_C      -       -           -
LGA    L    51_C      -       -           -
LGA    L    52_C      -       -           -
LGA    R    53_C      -       -           -
LGA    I    54_C      -       -           -
LGA    D    55_C      -       -           -
LGA    H    56_C      -       -           -
LGA    V    57_C      -       -           -
LGA    R    58_C      -       -           -
LGA    A    59_C      -       -           -
LGA    L    60_C      -       -           -
LGA    T    61_C      -       -           -
LGA    E    62_C      -       -           -
LGA    M    63_C      -       -           -
LGA    P    64_C      -       -           -
LGA    R    65_C      -       -           -
LGA    I    66_C      -       -           -
LGA    A    67_C      -       -           -
LGA    S    68_C      -       -           -
LGA    E    69_C      -       -           -
LGA    W    70_C      -       -           -
LGA    N    71_C      -       -           -
LGA    R    72_C      -       -           -
LGA    V    73_C      -       -           -
LGA    F    74_C      -       -           -
LGA    R    75_C      -       -           -
LGA    Q    76_C      -       -           -
LGA    L    77_C      -       -           -
LGA    P    78_C      -       -           -
LGA    T    79_C      -       -           -
LGA    E    80_C      -       -           -
LGA    A    81_C      -       -           -
LGA    D    82_C      -       -           -
LGA    I    83_C      -       -           -
LGA    Q    84_C      -       -           -
LGA    E    85_C      -       -           -
LGA    M    86_C      -       -           -
LGA    Y    87_C      -       -           -
LGA    E    88_C      -       -           -
LGA    E    89_C      -       -           -
LGA    F    90_C      -       -           -
LGA    E    91_C      -       -           -
LGA    E    92_C      -       -           -
LGA    I    93_C      -       -           -
LGA    L    94_C      -       -           -
LGA    F    95_C      -       -           -
LGA    A    96_C      -       -           -
LGA    I    97_C      -       -           -
LGA    L    98_C      -       -           -
LGA    P    99_C      -       -           -
LGA    R   100_C      -       -           -
LGA    Y   101_C      -       -           -
LGA    A   102_C      -       -           -
LGA    S   103_C      I      86          2.756
LGA    P   104_C      L      87          1.743
LGA    I   105_C      F      88          0.932
LGA    N   106_C      P      89          1.636
LGA    G   107_C      D      90          0.935
LGA    V   108_C      T      91          0.965
LGA    K   109_C      L      92          0.714
LGA    E   110_C      P      93          0.439
LGA    V   111_C      T      94          0.792
LGA    I   112_C      L      95          0.301
LGA    A   113_C      T      96          0.214
LGA    S   114_C      X      97          0.701
LGA    L   115_C      L      98          0.860
LGA    R   116_C      K      99          0.476
LGA    E   117_C      K     100          0.466
LGA    R   118_C      Q     101          0.870
LGA    G   119_C      G     102          0.599
LGA    I   120_C      I     103          0.363
LGA    K   121_C      R     104          0.351
LGA    I   122_C      I     105          0.462
LGA    G   123_C      G     106          1.034
LGA    S   124_C      I     107          1.237
LGA    T   125_C      I     108          0.950
LGA    T   126_C      S     109          1.053
LGA    G   127_C      T     110          1.351
LGA    Y   128_C      K     111          1.565
LGA    T   129_C      Y     112          3.126
LGA    R   130_C      -       -           -
LGA    E   131_C      -       -           -
LGA    M   132_C      -       -           -
LGA    M   133_C      R     113          3.381
LGA    D   134_C      F     114          1.624
LGA    I   135_C      R     115          3.121
LGA    V   136_C      I     116          3.401
LGA    A   137_C      L     117          2.077
LGA    K   138_C      S     118          1.703
LGA    E   139_C      F     119          2.435
LGA    A   140_C      L     120          2.587
LGA    A   141_C      R     121          2.950
LGA    L   142_C      N     122          1.598
LGA    Q   143_C      X     123          1.232
LGA    G   144_C      M     124          2.180
LGA    -       -      P     125           -
LGA    Y   145_C      D     126           #
LGA    K   146_C      D     127          5.088
LGA    P   147_C      W     128          3.949
LGA    D   148_C      F     129          1.712
LGA    -       -      D     130           -
LGA    F   149_C      I     131          1.190
LGA    L   150_C      I     132          0.669
LGA    V   151_C      I     133          0.641
LGA    T   152_C      G     134          2.171
LGA    P   153_C      G     135          3.282
LGA    D   154_C      E     136          2.705
LGA    D   155_C      D     137          2.014
LGA    V   156_C      V     138          2.556
LGA    P   157_C      T     139          3.227
LGA    A   158_C      X     140          1.118
LGA    G   159_C      X     141          0.934
LGA    R   160_C      K     142          0.725
LGA    P   161_C      P     143          1.226
LGA    Y   162_C      D     144          1.238
LGA    P   163_C      P     145          1.020
LGA    W   164_C      E     146          1.105
LGA    M   165_C      G     147          0.625
LGA    C   166_C      L     148          0.967
LGA    Y   167_C      L     149          1.422
LGA    K   168_C      L     150          1.475
LGA    N   169_C      A     151          1.161
LGA    A   170_C      I     152          1.144
LGA    M   171_C      D     153          2.163
LGA    E   172_C      R     154          2.079
LGA    L   173_C      L     155          1.846
LGA    G   174_C      K     156          2.337
LGA    V   175_C      A     157          1.357
LGA    Y   176_C      C     158          1.717
LGA    P   177_C      -       -           -
LGA    M   178_C      P     159          0.648
LGA    N   179_C      E     160          1.896
LGA    H   180_C      E     161          0.973
LGA    M   181_C      V     162          0.489
LGA    I   182_C      L     163          0.431
LGA    K   183_C      Y     164          0.590
LGA    V   184_C      I     165          0.453
LGA    G   185_C      G     166          0.417
LGA    D   186_C      D     167          0.760
LGA    T   187_C      S     168          0.703
LGA    V   188_C      T     169          0.825
LGA    S   189_C      V     170          0.521
LGA    D   190_C      D     171          0.523
LGA    M   191_C      A     172          0.290
LGA    K   192_C      G     173          0.269
LGA    E   193_C      T     174          0.055
LGA    G   194_C      A     175          0.514
LGA    R   195_C      A     176          0.842
LGA    N   196_C      A     177          0.952
LGA    A   197_C      A     178          0.841
LGA    G   198_C      G     179          1.006
LGA    M   199_C      V     180          0.892
LGA    W   200_C      S     181          0.840
LGA    T   201_C      F     182          0.313
LGA    V   202_C      T     183          0.724
LGA    G   203_C      G     184          0.645
LGA    V   204_C      V     185          0.499
LGA    I   205_C      T     186          0.989
LGA    L   206_C      S     187          3.387
LGA    G   207_C      -       -           -
LGA    S   208_C      G     188          0.961
LGA    S   209_C      M     189          2.701
LGA    E   210_C      T     190          2.379
LGA    L   211_C      -       -           -
LGA    G   212_C      -       -           -
LGA    L   213_C      -       -           -
LGA    T   214_C      -       -           -
LGA    E   215_C      -       -           -
LGA    E   216_C      -       -           -
LGA    E   217_C      -       -           -
LGA    V   218_C      -       -           -
LGA    E   219_C      -       -           -
LGA    N   220_C      -       -           -
LGA    M   221_C      -       -           -
LGA    D   222_C      -       -           -
LGA    S   223_C      -       -           -
LGA    V   224_C      -       -           -
LGA    E   225_C      -       -           -
LGA    L   226_C      -       -           -
LGA    R   227_C      -       -           -
LGA    E   228_C      -       -           -
LGA    K   229_C      -       -           -
LGA    I   230_C      -       -           -
LGA    E   231_C      -       -           -
LGA    V   232_C      -       -           -
LGA    V   233_C      T     191          0.937
LGA    R   234_C      A     192          0.447
LGA    N   235_C      Q     193          1.202
LGA    R   236_C      E     194          0.747
LGA    F   237_C      F     195          0.753
LGA    V   238_C      Q     196          2.001
LGA    E   239_C      A     197          1.941
LGA    N   240_C      Y     198          2.507
LGA    G   241_C      P     199          2.702
LGA    A   242_C      Y     200          2.625
LGA    H   243_C      D     201          2.802
LGA    F   244_C      R     202          1.427
LGA    T   245_C      I     203          0.159
LGA    I   246_C      I     204          0.215
LGA    E   247_C      S     205          0.595
LGA    T   248_C      T     206          0.538
LGA    M   249_C      L     207          0.790
LGA    Q   250_C      G     208          1.308
LGA    E   251_C      Q     209          1.270
LGA    L   252_C      L     210          0.841
LGA    E   253_C      I     211          2.282
LGA    S   254_C      -       -           -
LGA    V   255_C      -       -           -
LGA    M   256_C      -       -           -
LGA    E   257_C      -       -           -
LGA    H   258_C      -       -           -
LGA    I   259_C      -       -           -
LGA    E   260_C      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  256  141    5.0    138    1.60    18.84     90.142     8.096

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.027610 * X  +   0.143491 * Y  +   0.989266 * Z  + -33.622044
  Y_new =   0.992667 * X  +  -0.112572 * Y  +   0.044033 * Z  + -49.570255
  Z_new =   0.117682 * X  +   0.983228 * Y  +  -0.139331 * Z  + -92.463150 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.711567   -1.430026  [ DEG:    98.0655    -81.9345 ]
  Theta =  -0.117956   -3.023637  [ DEG:    -6.7584   -173.2416 ]
  Phi   =   1.598603   -1.542989  [ DEG:    91.5932    -88.4068 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ioh_C                                        
REMARK     2: T0418_2_16_86_211.pdb                         
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ioh_C.T0418_2_16_86_211.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  256  141   5.0  138   1.60   18.84  90.142
REMARK  ---------------------------------------------------------- 
MOLECULE 2ioh_C
HEADER                                            10-OCT-06   2IOH              
TITLE     CRYSTAL STRUCTURE OF PHOSPHONOACETALDEHYDE HYDROLASE WITH A           
TITLE    2 K53R MUTATION                                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHOSPHONOACETALDEHYDE HYDROLASE;                           
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES;                                                     
COMPND   5 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS CEREUS;                                
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    PHOSPHONOACETALDEHYDE HYDROLASE, HALOACID DEHALOGENASE                
KEYWDS   2 SUPERFAMILY                                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.A.ALLEN,S.D.LAHIRI,G.ZHANG,D.DUNAWAY-MARIANO,E.PEISACH              
REVDAT   1   07-AUG-07 2IOH    0                                                
JRNL        AUTH   S.D.LAHIRI,G.ZHANG,D.DUNAWAY-MARIANO,K.N.ALLEN               
JRNL        TITL   DIVERSIFICATION OF FUNCTION IN THE HALOACID                  
JRNL        TITL 2 DEHALOGENASE ENZYME SUPERFAMILY: THE ROLE OF THE             
JRNL        TITL 3 CAP DOMAIN IN HYDROLYTIC PHOSPHORUSCARBON BOND               
JRNL        TITL 4 CLEAVAGE.                                                    
JRNL        REF    BIOORG.CHEM.                  V.  34   394 2006              
JRNL        REFN   ASTM BOCMBM  US ISSN 0045-2068                               
REMARK   2 RESOLUTION. 2.90 ANGSTROMS.                                          
DBREF  2IOH A    1   267  UNP    O31156   O31156_BACCE     1    267             
DBREF  2IOH B    1   267  UNP    O31156   O31156_BACCE     1    267             
DBREF  2IOH C    1   267  UNP    O31156   O31156_BACCE     1    267             
DBREF  2IOH D    1   267  UNP    O31156   O31156_BACCE     1    267             
SEQRES   1 A  267  MET ASP ARG MET LYS ILE GLU ALA VAL ILE PHE ASP TRP          
SEQRES   2 A  267  ALA GLY THR THR VAL ASP TYR GLY CYS PHE ALA PRO LEU          
SEQRES   3 A  267  GLU VAL PHE MET GLU ILE PHE HIS LYS ARG GLY VAL ALA          
SEQRES   4 A  267  ILE THR ALA GLU GLU ALA ARG LYS PRO MET GLY LEU LEU          
SEQRES   5 A  267  ARG ILE ASP HIS VAL ARG ALA LEU THR GLU MET PRO ARG          
SEQRES   6 A  267  ILE ALA SER GLU TRP ASN ARG VAL PHE ARG GLN LEU PRO          
SEQRES   7 A  267  THR GLU ALA ASP ILE GLN GLU MET TYR GLU GLU PHE GLU          
SEQRES   8 A  267  GLU ILE LEU PHE ALA ILE LEU PRO ARG TYR ALA SER PRO          
SEQRES   9 A  267  ILE ASN GLY VAL LYS GLU VAL ILE ALA SER LEU ARG GLU          
SEQRES  10 A  267  ARG GLY ILE LYS ILE GLY SER THR THR GLY TYR THR ARG          
SEQRES  11 A  267  GLU MET MET ASP ILE VAL ALA LYS GLU ALA ALA LEU GLN          
SEQRES  12 A  267  GLY TYR LYS PRO ASP PHE LEU VAL THR PRO ASP ASP VAL          
SEQRES  13 A  267  PRO ALA GLY ARG PRO TYR PRO TRP MET CYS TYR LYS ASN          
SEQRES  14 A  267  ALA MET GLU LEU GLY VAL TYR PRO MET ASN HIS MET ILE          
SEQRES  15 A  267  LYS VAL GLY ASP THR VAL SER ASP MET LYS GLU GLY ARG          
SEQRES  16 A  267  ASN ALA GLY MET TRP THR VAL GLY VAL ILE LEU GLY SER          
SEQRES  17 A  267  SER GLU LEU GLY LEU THR GLU GLU GLU VAL GLU ASN MET          
SEQRES  18 A  267  ASP SER VAL GLU LEU ARG GLU LYS ILE GLU VAL VAL ARG          
SEQRES  19 A  267  ASN ARG PHE VAL GLU ASN GLY ALA HIS PHE THR ILE GLU          
SEQRES  20 A  267  THR MET GLN GLU LEU GLU SER VAL MET GLU HIS ILE GLU          
SEQRES  21 A  267  LYS GLN GLU LEU ILE ILE SER                                  
SEQRES   1 B  267  MET ASP ARG MET LYS ILE GLU ALA VAL ILE PHE ASP TRP          
SEQRES   2 B  267  ALA GLY THR THR VAL ASP TYR GLY CYS PHE ALA PRO LEU          
SEQRES   3 B  267  GLU VAL PHE MET GLU ILE PHE HIS LYS ARG GLY VAL ALA          
SEQRES   4 B  267  ILE THR ALA GLU GLU ALA ARG LYS PRO MET GLY LEU LEU          
SEQRES   5 B  267  ARG ILE ASP HIS VAL ARG ALA LEU THR GLU MET PRO ARG          
SEQRES   6 B  267  ILE ALA SER GLU TRP ASN ARG VAL PHE ARG GLN LEU PRO          
SEQRES   7 B  267  THR GLU ALA ASP ILE GLN GLU MET TYR GLU GLU PHE GLU          
SEQRES   8 B  267  GLU ILE LEU PHE ALA ILE LEU PRO ARG TYR ALA SER PRO          
SEQRES   9 B  267  ILE ASN GLY VAL LYS GLU VAL ILE ALA SER LEU ARG GLU          
SEQRES  10 B  267  ARG GLY ILE LYS ILE GLY SER THR THR GLY TYR THR ARG          
SEQRES  11 B  267  GLU MET MET ASP ILE VAL ALA LYS GLU ALA ALA LEU GLN          
SEQRES  12 B  267  GLY TYR LYS PRO ASP PHE LEU VAL THR PRO ASP ASP VAL          
SEQRES  13 B  267  PRO ALA GLY ARG PRO TYR PRO TRP MET CYS TYR LYS ASN          
SEQRES  14 B  267  ALA MET GLU LEU GLY VAL TYR PRO MET ASN HIS MET ILE          
SEQRES  15 B  267  LYS VAL GLY ASP THR VAL SER ASP MET LYS GLU GLY ARG          
SEQRES  16 B  267  ASN ALA GLY MET TRP THR VAL GLY VAL ILE LEU GLY SER          
SEQRES  17 B  267  SER GLU LEU GLY LEU THR GLU GLU GLU VAL GLU ASN MET          
SEQRES  18 B  267  ASP SER VAL GLU LEU ARG GLU LYS ILE GLU VAL VAL ARG          
SEQRES  19 B  267  ASN ARG PHE VAL GLU ASN GLY ALA HIS PHE THR ILE GLU          
SEQRES  20 B  267  THR MET GLN GLU LEU GLU SER VAL MET GLU HIS ILE GLU          
SEQRES  21 B  267  LYS GLN GLU LEU ILE ILE SER                                  
SEQRES   1 C  267  MET ASP ARG MET LYS ILE GLU ALA VAL ILE PHE ASP TRP          
SEQRES   2 C  267  ALA GLY THR THR VAL ASP TYR GLY CYS PHE ALA PRO LEU          
SEQRES   3 C  267  GLU VAL PHE MET GLU ILE PHE HIS LYS ARG GLY VAL ALA          
SEQRES   4 C  267  ILE THR ALA GLU GLU ALA ARG LYS PRO MET GLY LEU LEU          
SEQRES   5 C  267  ARG ILE ASP HIS VAL ARG ALA LEU THR GLU MET PRO ARG          
SEQRES   6 C  267  ILE ALA SER GLU TRP ASN ARG VAL PHE ARG GLN LEU PRO          
SEQRES   7 C  267  THR GLU ALA ASP ILE GLN GLU MET TYR GLU GLU PHE GLU          
SEQRES   8 C  267  GLU ILE LEU PHE ALA ILE LEU PRO ARG TYR ALA SER PRO          
SEQRES   9 C  267  ILE ASN GLY VAL LYS GLU VAL ILE ALA SER LEU ARG GLU          
SEQRES  10 C  267  ARG GLY ILE LYS ILE GLY SER THR THR GLY TYR THR ARG          
SEQRES  11 C  267  GLU MET MET ASP ILE VAL ALA LYS GLU ALA ALA LEU GLN          
SEQRES  12 C  267  GLY TYR LYS PRO ASP PHE LEU VAL THR PRO ASP ASP VAL          
SEQRES  13 C  267  PRO ALA GLY ARG PRO TYR PRO TRP MET CYS TYR LYS ASN          
SEQRES  14 C  267  ALA MET GLU LEU GLY VAL TYR PRO MET ASN HIS MET ILE          
SEQRES  15 C  267  LYS VAL GLY ASP THR VAL SER ASP MET LYS GLU GLY ARG          
SEQRES  16 C  267  ASN ALA GLY MET TRP THR VAL GLY VAL ILE LEU GLY SER          
SEQRES  17 C  267  SER GLU LEU GLY LEU THR GLU GLU GLU VAL GLU ASN MET          
SEQRES  18 C  267  ASP SER VAL GLU LEU ARG GLU LYS ILE GLU VAL VAL ARG          
SEQRES  19 C  267  ASN ARG PHE VAL GLU ASN GLY ALA HIS PHE THR ILE GLU          
SEQRES  20 C  267  THR MET GLN GLU LEU GLU SER VAL MET GLU HIS ILE GLU          
SEQRES  21 C  267  LYS GLN GLU LEU ILE ILE SER                                  
SEQRES   1 D  267  MET ASP ARG MET LYS ILE GLU ALA VAL ILE PHE ASP TRP          
SEQRES   2 D  267  ALA GLY THR THR VAL ASP TYR GLY CYS PHE ALA PRO LEU          
SEQRES   3 D  267  GLU VAL PHE MET GLU ILE PHE HIS LYS ARG GLY VAL ALA          
SEQRES   4 D  267  ILE THR ALA GLU GLU ALA ARG LYS PRO MET GLY LEU LEU          
SEQRES   5 D  267  ARG ILE ASP HIS VAL ARG ALA LEU THR GLU MET PRO ARG          
SEQRES   6 D  267  ILE ALA SER GLU TRP ASN ARG VAL PHE ARG GLN LEU PRO          
SEQRES   7 D  267  THR GLU ALA ASP ILE GLN GLU MET TYR GLU GLU PHE GLU          
SEQRES   8 D  267  GLU ILE LEU PHE ALA ILE LEU PRO ARG TYR ALA SER PRO          
SEQRES   9 D  267  ILE ASN GLY VAL LYS GLU VAL ILE ALA SER LEU ARG GLU          
SEQRES  10 D  267  ARG GLY ILE LYS ILE GLY SER THR THR GLY TYR THR ARG          
SEQRES  11 D  267  GLU MET MET ASP ILE VAL ALA LYS GLU ALA ALA LEU GLN          
SEQRES  12 D  267  GLY TYR LYS PRO ASP PHE LEU VAL THR PRO ASP ASP VAL          
SEQRES  13 D  267  PRO ALA GLY ARG PRO TYR PRO TRP MET CYS TYR LYS ASN          
SEQRES  14 D  267  ALA MET GLU LEU GLY VAL TYR PRO MET ASN HIS MET ILE          
SEQRES  15 D  267  LYS VAL GLY ASP THR VAL SER ASP MET LYS GLU GLY ARG          
SEQRES  16 D  267  ASN ALA GLY MET TRP THR VAL GLY VAL ILE LEU GLY SER          
SEQRES  17 D  267  SER GLU LEU GLY LEU THR GLU GLU GLU VAL GLU ASN MET          
SEQRES  18 D  267  ASP SER VAL GLU LEU ARG GLU LYS ILE GLU VAL VAL ARG          
SEQRES  19 D  267  ASN ARG PHE VAL GLU ASN GLY ALA HIS PHE THR ILE GLU          
SEQRES  20 D  267  THR MET GLN GLU LEU GLU SER VAL MET GLU HIS ILE GLU          
SEQRES  21 D  267  LYS GLN GLU LEU ILE ILE SER                                  
HET    PO4  A 320       5                                                       
HET     MG  A 321       1                                                       
HET    PO4  B 320       5                                                       
HET     MG  B 321       1                                                       
HET    PO4  C 320       5                                                       
HET     MG  C 321       1                                                       
HET    PO4  D 320       5                                                       
HET     MG  D 321       1                                                       
HETNAM     PO4 PHOSPHATE ION                                                    
HETNAM      MG MAGNESIUM ION                                                    
FORMUL   5  PO4    4(O4 P 3-)                                                   
FORMUL   6   MG    4(MG 2+)                                                     
FORMUL  13  HOH   *80(H2 O)                                                     
CRYST1  251.728  251.728  156.340  90.00  90.00 120.00 H 3 2        72          
ATOM   4085  N   LYS C   5     -15.567  38.883  69.447  1.00 41.89           N  
ATOM   4086  CA  LYS C   5     -15.448  37.400  69.519  1.00 42.95           C  
ATOM   4087  C   LYS C   5     -14.236  37.020  70.407  1.00 43.54           C  
ATOM   4088  O   LYS C   5     -14.097  35.865  70.828  1.00 44.44           O  
ATOM   4089  CB  LYS C   5     -15.337  36.833  68.090  1.00 42.68           C  
ATOM   4090  CG  LYS C   5     -15.636  35.336  67.930  1.00 44.11           C  
ATOM   4091  CD  LYS C   5     -14.416  34.472  68.257  1.00 43.85           C  
ATOM   4092  CE  LYS C   5     -14.671  33.002  67.966  1.00 43.87           C  
ATOM   4093  NZ  LYS C   5     -13.503  32.153  68.351  1.00 42.51           N  
ATOM   4094  N   ILE C   6     -13.367  37.998  70.681  1.00 42.52           N  
ATOM   4095  CA  ILE C   6     -12.197  37.816  71.558  1.00 41.98           C  
ATOM   4096  C   ILE C   6     -12.116  39.018  72.506  1.00 42.56           C  
ATOM   4097  O   ILE C   6     -11.633  40.099  72.149  1.00 43.60           O  
ATOM   4098  CB  ILE C   6     -10.856  37.659  70.756  1.00 40.17           C  
ATOM   4099  CG1 ILE C   6     -10.604  36.175  70.485  1.00 38.16           C  
ATOM   4100  CG2 ILE C   6      -9.665  38.225  71.548  1.00 39.05           C  
ATOM   4101  CD1 ILE C   6      -9.252  35.874  69.949  1.00 34.99           C  
ATOM   4102  N   GLU C   7     -12.592  38.817  73.725  1.00 41.32           N  
ATOM   4103  CA  GLU C   7     -12.632  39.887  74.700  1.00 41.19           C  
ATOM   4104  C   GLU C   7     -11.380  40.147  75.530  1.00 40.81           C  
ATOM   4105  O   GLU C   7     -11.167  41.271  75.992  1.00 41.19           O  
ATOM   4106  CB  GLU C   7     -13.821  39.662  75.637  1.00 42.11           C  
ATOM   4107  CG  GLU C   7     -15.168  39.936  74.993  1.00 43.80           C  
ATOM   4108  CD  GLU C   7     -16.091  38.741  75.032  1.00 44.58           C  
ATOM   4109  OE1 GLU C   7     -15.846  37.769  74.287  1.00 46.84           O  
ATOM   4110  OE2 GLU C   7     -17.060  38.771  75.819  1.00 45.71           O  
ATOM   4111  N   ALA C   8     -10.547  39.133  75.727  1.00 39.86           N  
ATOM   4112  CA  ALA C   8      -9.367  39.341  76.551  1.00 37.64           C  
ATOM   4113  C   ALA C   8      -8.107  38.642  76.077  1.00 37.54           C  
ATOM   4114  O   ALA C   8      -8.164  37.587  75.431  1.00 38.34           O  
ATOM   4115  CB  ALA C   8      -9.673  38.923  77.977  1.00 35.18           C  
ATOM   4116  N   VAL C   9      -6.972  39.258  76.399  1.00 35.93           N  
ATOM   4117  CA  VAL C   9      -5.650  38.725  76.086  1.00 34.57           C  
ATOM   4118  C   VAL C   9      -4.906  38.744  77.413  1.00 34.01           C  
ATOM   4119  O   VAL C   9      -4.874  39.770  78.092  1.00 33.09           O  
ATOM   4120  CB  VAL C   9      -4.856  39.622  75.100  1.00 35.08           C  
ATOM   4121  CG1 VAL C   9      -3.498  38.999  74.829  1.00 34.66           C  
ATOM   4122  CG2 VAL C   9      -5.616  39.806  73.797  1.00 34.21           C  
ATOM   4123  N   ILE C  10      -4.332  37.617  77.802  1.00 33.74           N  
ATOM   4124  CA  ILE C  10      -3.581  37.578  79.053  1.00 34.81           C  
ATOM   4125  C   ILE C  10      -2.094  37.294  78.790  1.00 33.83           C  
ATOM   4126  O   ILE C  10      -1.717  36.256  78.230  1.00 32.43           O  
ATOM   4127  CB  ILE C  10      -4.205  36.564  80.071  1.00 35.78           C  
ATOM   4128  CG1 ILE C  10      -3.099  35.892  80.875  1.00 36.48           C  
ATOM   4129  CG2 ILE C  10      -5.094  35.566  79.366  1.00 36.08           C  
ATOM   4130  CD1 ILE C  10      -3.618  34.854  81.815  1.00 40.22           C  
ATOM   4131  N   PHE C  11      -1.264  38.252  79.203  1.00 33.36           N  
ATOM   4132  CA  PHE C  11       0.178  38.207  78.996  1.00 31.94           C  
ATOM   4133  C   PHE C  11       0.990  37.613  80.126  1.00 32.06           C  
ATOM   4134  O   PHE C  11       0.570  37.634  81.277  1.00 32.08           O  
ATOM   4135  CB  PHE C  11       0.719  39.627  78.756  1.00 30.81           C  
ATOM   4136  CG  PHE C  11       0.142  40.323  77.549  1.00 30.52           C  
ATOM   4137  CD1 PHE C  11      -0.961  41.158  77.670  1.00 29.25           C  
ATOM   4138  CD2 PHE C  11       0.714  40.148  76.286  1.00 30.83           C  
ATOM   4139  CE1 PHE C  11      -1.485  41.812  76.556  1.00 30.65           C  
ATOM   4140  CE2 PHE C  11       0.195  40.799  75.163  1.00 29.74           C  
ATOM   4141  CZ  PHE C  11      -0.906  41.633  75.300  1.00 30.62           C  
ATOM   4142  N   ASP C  12       2.161  37.088  79.777  1.00 32.96           N  
ATOM   4143  CA  ASP C  12       3.107  36.561  80.758  1.00 33.42           C  
ATOM   4144  C   ASP C  12       3.933  37.802  81.103  1.00 33.74           C  
ATOM   4145  O   ASP C  12       3.732  38.859  80.500  1.00 34.18           O  
ATOM   4146  CB  ASP C  12       4.037  35.527  80.125  1.00 34.33           C  
ATOM   4147  CG  ASP C  12       5.188  35.140  81.049  1.00 35.72           C  
ATOM   4148  OD1 ASP C  12       6.351  35.034  80.587  1.00 34.72           O  
ATOM   4149  OD2 ASP C  12       4.919  34.941  82.251  1.00 37.97           O  
ATOM   4150  N   TRP C  13       4.860  37.700  82.050  1.00 33.84           N  
ATOM   4151  CA  TRP C  13       5.679  38.864  82.373  1.00 33.94           C  
ATOM   4152  C   TRP C  13       7.093  38.802  81.785  1.00 33.59           C  
ATOM   4153  O   TRP C  13       7.291  39.128  80.606  1.00 32.93           O  
ATOM   4154  CB  TRP C  13       5.737  39.100  83.890  1.00 34.80           C  
ATOM   4155  CG  TRP C  13       4.523  39.824  84.423  1.00 36.05           C  
ATOM   4156  CD1 TRP C  13       3.295  39.284  84.677  1.00 37.13           C  
ATOM   4157  CD2 TRP C  13       4.405  41.228  84.696  1.00 35.58           C  
ATOM   4158  NE1 TRP C  13       2.421  40.264  85.086  1.00 37.35           N  
ATOM   4159  CE2 TRP C  13       3.077  41.466  85.104  1.00 35.79           C  
ATOM   4160  CE3 TRP C  13       5.292  42.308  84.629  1.00 37.36           C  
ATOM   4161  CZ2 TRP C  13       2.613  42.739  85.448  1.00 35.22           C  
ATOM   4162  CZ3 TRP C  13       4.828  43.579  84.973  1.00 36.71           C  
ATOM   4163  CH2 TRP C  13       3.501  43.780  85.375  1.00 35.72           C  
ATOM   4164  N   ALA C  14       8.069  38.391  82.595  1.00 32.16           N  
ATOM   4165  CA  ALA C  14       9.456  38.319  82.133  1.00 29.48           C  
ATOM   4166  C   ALA C  14       9.558  37.544  80.831  1.00 28.11           C  
ATOM   4167  O   ALA C  14       9.072  36.416  80.726  1.00 27.03           O  
ATOM   4168  CB  ALA C  14      10.340  37.680  83.190  1.00 28.52           C  
ATOM   4169  N   GLY C  15      10.186  38.177  79.842  1.00 27.82           N  
ATOM   4170  CA  GLY C  15      10.366  37.570  78.534  1.00 27.29           C  
ATOM   4171  C   GLY C  15       9.228  37.827  77.563  1.00 26.75           C  
ATOM   4172  O   GLY C  15       9.307  37.416  76.411  1.00 24.68           O  
ATOM   4173  N   THR C  16       8.176  38.502  78.028  1.00 27.18           N  
ATOM   4174  CA  THR C  16       7.016  38.798  77.191  1.00 27.67           C  
ATOM   4175  C   THR C  16       6.669  40.298  77.168  1.00 29.27           C  
ATOM   4176  O   THR C  16       6.370  40.865  76.112  1.00 29.44           O  
ATOM   4177  CB  THR C  16       5.786  37.993  77.667  1.00 26.69           C  
ATOM   4178  OG1 THR C  16       6.099  36.595  77.673  1.00 24.36           O  
ATOM   4179  CG2 THR C  16       4.612  38.217  76.738  1.00 27.44           C  
ATOM   4180  N   THR C  17       6.704  40.939  78.332  1.00 30.68           N  
ATOM   4181  CA  THR C  17       6.410  42.371  78.420  1.00 31.06           C  
ATOM   4182  C   THR C  17       7.511  43.090  79.195  1.00 31.57           C  
ATOM   4183  O   THR C  17       7.676  44.302  79.086  1.00 31.34           O  
ATOM   4184  CB  THR C  17       5.061  42.648  79.149  1.00 30.77           C  
ATOM   4185  OG1 THR C  17       5.104  42.098  80.476  1.00 30.62           O  
ATOM   4186  CG2 THR C  17       3.905  42.050  78.383  1.00 29.47           C  
ATOM   4187  N   VAL C  18       8.268  42.325  79.972  1.00 32.22           N  
ATOM   4188  CA  VAL C  18       9.322  42.879  80.803  1.00 31.80           C  
ATOM   4189  C   VAL C  18      10.550  41.977  80.771  1.00 31.79           C  
ATOM   4190  O   VAL C  18      10.444  40.788  80.482  1.00 31.64           O  
ATOM   4191  CB  VAL C  18       8.787  43.040  82.255  1.00 33.04           C  
ATOM   4192  CG1 VAL C  18       9.818  42.616  83.271  1.00 34.68           C  
ATOM   4193  CG2 VAL C  18       8.371  44.473  82.489  1.00 33.83           C  
ATOM   4194  N   ASP C  19      11.712  42.562  81.050  1.00 32.27           N  
ATOM   4195  CA  ASP C  19      12.986  41.842  81.080  1.00 31.10           C  
ATOM   4196  C   ASP C  19      13.296  41.060  79.811  1.00 29.14           C  
ATOM   4197  O   ASP C  19      13.213  39.841  79.794  1.00 27.54           O  
ATOM   4198  CB  ASP C  19      13.023  40.898  82.290  1.00 32.74           C  
ATOM   4199  CG  ASP C  19      14.403  40.304  82.532  1.00 34.02           C  
ATOM   4200  OD1 ASP C  19      14.579  39.646  83.573  1.00 34.47           O  
ATOM   4201  OD2 ASP C  19      15.311  40.492  81.691  1.00 35.20           O  
ATOM   4202  N   TYR C  20      13.673  41.774  78.758  1.00 30.15           N  
ATOM   4203  CA  TYR C  20      14.008  41.161  77.473  1.00 31.06           C  
ATOM   4204  C   TYR C  20      15.047  40.052  77.684  1.00 31.76           C  
ATOM   4205  O   TYR C  20      16.033  40.248  78.394  1.00 33.29           O  
ATOM   4206  CB  TYR C  20      14.561  42.237  76.527  1.00 29.32           C  
ATOM   4207  CG  TYR C  20      14.796  41.795  75.098  1.00 30.08           C  
ATOM   4208  CD1 TYR C  20      15.738  40.810  74.788  1.00 30.97           C  
ATOM   4209  CD2 TYR C  20      14.092  42.385  74.044  1.00 29.43           C  
ATOM   4210  CE1 TYR C  20      15.977  40.426  73.467  1.00 32.30           C  
ATOM   4211  CE2 TYR C  20      14.316  42.012  72.723  1.00 30.41           C  
ATOM   4212  CZ  TYR C  20      15.260  41.035  72.438  1.00 33.75           C  
ATOM   4213  OH  TYR C  20      15.499  40.678  71.128  1.00 35.58           O  
ATOM   4214  N   GLY C  21      14.822  38.893  77.072  1.00 31.69           N  
ATOM   4215  CA  GLY C  21      15.756  37.796  77.222  1.00 31.96           C  
ATOM   4216  C   GLY C  21      15.639  37.120  78.578  1.00 34.23           C  
ATOM   4217  O   GLY C  21      16.114  36.000  78.762  1.00 34.75           O  
ATOM   4218  N   CYS C  22      15.015  37.807  79.535  1.00 35.45           N  
ATOM   4219  CA  CYS C  22      14.822  37.260  80.875  1.00 35.25           C  
ATOM   4220  C   CYS C  22      16.165  37.020  81.576  1.00 34.98           C  
ATOM   4221  O   CYS C  22      16.608  35.881  81.716  1.00 34.64           O  
ATOM   4222  CB  CYS C  22      14.039  35.952  80.766  1.00 35.44           C  
ATOM   4223  SG  CYS C  22      13.454  35.299  82.327  1.00 40.92           S  
ATOM   4224  N   PHE C  23      16.798  38.095  82.037  1.00 35.15           N  
ATOM   4225  CA  PHE C  23      18.102  37.986  82.683  1.00 35.20           C  
ATOM   4226  C   PHE C  23      18.220  38.149  84.180  1.00 34.29           C  
ATOM   4227  O   PHE C  23      19.213  37.723  84.758  1.00 34.76           O  
ATOM   4228  CB  PHE C  23      19.071  38.959  82.039  1.00 37.51           C  
ATOM   4229  CG  PHE C  23      19.846  38.365  80.919  1.00 41.36           C  
ATOM   4230  CD1 PHE C  23      19.205  37.992  79.735  1.00 42.97           C  
ATOM   4231  CD2 PHE C  23      21.215  38.139  81.057  1.00 40.81           C  
ATOM   4232  CE1 PHE C  23      19.916  37.393  78.695  1.00 44.29           C  
ATOM   4233  CE2 PHE C  23      21.936  37.548  80.037  1.00 43.44           C  
ATOM   4234  CZ  PHE C  23      21.285  37.170  78.844  1.00 45.21           C  
ATOM   4235  N   ALA C  24      17.237  38.776  84.808  1.00 33.26           N  
ATOM   4236  CA  ALA C  24      17.274  38.990  86.244  1.00 31.35           C  
ATOM   4237  C   ALA C  24      17.868  37.799  87.012  1.00 31.64           C  
ATOM   4238  O   ALA C  24      18.828  37.949  87.764  1.00 31.57           O  
ATOM   4239  CB  ALA C  24      15.875  39.305  86.749  1.00 29.25           C  
ATOM   4240  N   PRO C  25      17.322  36.593  86.812  1.00 32.58           N  
ATOM   4241  CA  PRO C  25      17.817  35.392  87.505  1.00 32.70           C  
ATOM   4242  C   PRO C  25      19.291  35.070  87.239  1.00 33.82           C  
ATOM   4243  O   PRO C  25      20.045  34.784  88.163  1.00 33.22           O  
ATOM   4244  CB  PRO C  25      16.896  34.293  86.989  1.00 32.67           C  
ATOM   4245  CG  PRO C  25      15.641  35.046  86.592  1.00 34.09           C  
ATOM   4246  CD  PRO C  25      16.195  36.262  85.923  1.00 32.48           C  
ATOM   4247  N   LEU C  26      19.687  35.098  85.971  1.00 35.02           N  
ATOM   4248  CA  LEU C  26      21.067  34.818  85.594  1.00 37.46           C  
ATOM   4249  C   LEU C  26      22.022  35.794  86.281  1.00 39.25           C  
ATOM   4250  O   LEU C  26      23.137  35.435  86.667  1.00 39.23           O  
ATOM   4251  CB  LEU C  26      21.224  34.940  84.081  1.00 36.99           C  
ATOM   4252  CG  LEU C  26      20.159  34.206  83.276  1.00 37.25           C  
ATOM   4253  CD1 LEU C  26      20.460  34.336  81.804  1.00 37.11           C  
ATOM   4254  CD2 LEU C  26      20.129  32.747  83.682  1.00 38.46           C  
ATOM   4255  N   GLU C  27      21.570  37.035  86.424  1.00 41.25           N  
ATOM   4256  CA  GLU C  27      22.358  38.080  87.059  1.00 41.35           C  
ATOM   4257  C   GLU C  27      22.705  37.727  88.493  1.00 39.68           C  
ATOM   4258  O   GLU C  27      23.848  37.887  88.903  1.00 39.52           O  
ATOM   4259  CB  GLU C  27      21.597  39.408  87.022  1.00 44.50           C  
ATOM   4260  CG  GLU C  27      22.173  40.432  86.047  1.00 49.19           C  
ATOM   4261  CD  GLU C  27      23.533  40.983  86.483  1.00 51.11           C  
ATOM   4262  OE1 GLU C  27      23.603  41.635  87.549  1.00 51.68           O  
ATOM   4263  OE2 GLU C  27      24.530  40.762  85.758  1.00 52.32           O  
ATOM   4264  N   VAL C  28      21.724  37.248  89.254  1.00 38.46           N  
ATOM   4265  CA  VAL C  28      21.976  36.876  90.647  1.00 38.94           C  
ATOM   4266  C   VAL C  28      22.998  35.739  90.733  1.00 39.34           C  
ATOM   4267  O   VAL C  28      23.935  35.801  91.520  1.00 39.24           O  
ATOM   4268  CB  VAL C  28      20.687  36.432  91.369  1.00 37.67           C  
ATOM   4269  CG1 VAL C  28      20.977  36.207  92.843  1.00 35.65           C  
ATOM   4270  CG2 VAL C  28      19.610  37.475  91.198  1.00 36.97           C  
ATOM   4271  N   PHE C  29      22.815  34.705  89.919  1.00 39.94           N  
ATOM   4272  CA  PHE C  29      23.728  33.574  89.911  1.00 41.18           C  
ATOM   4273  C   PHE C  29      25.153  34.021  89.653  1.00 42.55           C  
ATOM   4274  O   PHE C  29      26.089  33.579  90.318  1.00 42.65           O  
ATOM   4275  CB  PHE C  29      23.309  32.567  88.840  1.00 41.25           C  
ATOM   4276  CG  PHE C  29      22.192  31.654  89.266  1.00 41.87           C  
ATOM   4277  CD1 PHE C  29      21.190  31.297  88.373  1.00 42.04           C  
ATOM   4278  CD2 PHE C  29      22.151  31.133  90.554  1.00 41.65           C  
ATOM   4279  CE1 PHE C  29      20.158  30.430  88.760  1.00 41.70           C  
ATOM   4280  CE2 PHE C  29      21.127  30.268  90.947  1.00 41.79           C  
ATOM   4281  CZ  PHE C  29      20.130  29.917  90.046  1.00 40.79           C  
ATOM   4282  N   MET C  30      25.321  34.907  88.683  1.00 45.21           N  
ATOM   4283  CA  MET C  30      26.651  35.400  88.337  1.00 48.07           C  
ATOM   4284  C   MET C  30      27.254  36.226  89.459  1.00 48.09           C  
ATOM   4285  O   MET C  30      28.455  36.164  89.719  1.00 49.02           O  
ATOM   4286  CB  MET C  30      26.581  36.251  87.071  1.00 48.77           C  
ATOM   4287  CG  MET C  30      26.039  35.513  85.873  1.00 51.37           C  
ATOM   4288  SD  MET C  30      26.177  36.501  84.391  1.00 52.47           S  
ATOM   4289  CE  MET C  30      27.956  36.360  84.125  1.00 51.92           C  
ATOM   4290  N   GLU C  31      26.400  37.001  90.111  1.00 48.39           N  
ATOM   4291  CA  GLU C  31      26.798  37.871  91.205  1.00 50.03           C  
ATOM   4292  C   GLU C  31      27.364  37.064  92.371  1.00 49.38           C  
ATOM   4293  O   GLU C  31      28.467  37.317  92.843  1.00 48.44           O  
ATOM   4294  CB  GLU C  31      25.572  38.651  91.691  1.00 53.28           C  
ATOM   4295  CG  GLU C  31      25.868  39.984  92.345  1.00 58.20           C  
ATOM   4296  CD  GLU C  31      26.074  41.089  91.320  1.00 62.35           C  
ATOM   4297  OE1 GLU C  31      25.104  41.416  90.590  1.00 61.88           O  
ATOM   4298  OE2 GLU C  31      27.209  41.621  91.245  1.00 65.00           O  
ATOM   4299  N   ILE C  32      26.574  36.094  92.820  1.00 48.82           N  
ATOM   4300  CA  ILE C  32      26.901  35.239  93.947  1.00 47.37           C  
ATOM   4301  C   ILE C  32      28.225  34.522  93.837  1.00 46.99           C  
ATOM   4302  O   ILE C  32      28.950  34.405  94.825  1.00 46.13           O  
ATOM   4303  CB  ILE C  32      25.758  34.232  94.175  1.00 47.83           C  
ATOM   4304  CG1 ILE C  32      24.530  35.006  94.653  1.00 48.99           C  
ATOM   4305  CG2 ILE C  32      26.160  33.171  95.190  1.00 48.49           C  
ATOM   4306  CD1 ILE C  32      23.275  34.195  94.748  1.00 52.49           C  
ATOM   4307  N   PHE C  33      28.549  34.033  92.648  1.00 47.21           N  
ATOM   4308  CA  PHE C  33      29.819  33.348  92.468  1.00 48.65           C  
ATOM   4309  C   PHE C  33      30.932  34.377  92.355  1.00 52.11           C  
ATOM   4310  O   PHE C  33      32.081  34.114  92.711  1.00 53.16           O  
ATOM   4311  CB  PHE C  33      29.799  32.460  91.222  1.00 43.75           C  
ATOM   4312  CG  PHE C  33      29.259  31.081  91.477  1.00 40.41           C  
ATOM   4313  CD1 PHE C  33      27.895  30.870  91.661  1.00 38.50           C  
ATOM   4314  CD2 PHE C  33      30.118  29.991  91.554  1.00 37.51           C  
ATOM   4315  CE1 PHE C  33      27.403  29.600  91.919  1.00 35.31           C  
ATOM   4316  CE2 PHE C  33      29.631  28.726  91.810  1.00 35.11           C  
ATOM   4317  CZ  PHE C  33      28.271  28.529  91.992  1.00 35.80           C  
ATOM   4318  N   HIS C  34      30.577  35.561  91.871  1.00 55.93           N  
ATOM   4319  CA  HIS C  34      31.540  36.630  91.694  1.00 59.16           C  
ATOM   4320  C   HIS C  34      32.121  37.117  93.020  1.00 59.97           C  
ATOM   4321  O   HIS C  34      33.334  37.300  93.152  1.00 59.63           O  
ATOM   4322  CB  HIS C  34      30.887  37.787  90.952  1.00 62.89           C  
ATOM   4323  CG  HIS C  34      31.865  38.643  90.219  1.00 67.73           C  
ATOM   4324  ND1 HIS C  34      32.543  38.200  89.103  1.00 70.15           N  
ATOM   4325  CD2 HIS C  34      32.333  39.887  90.477  1.00 68.79           C  
ATOM   4326  CE1 HIS C  34      33.392  39.133  88.708  1.00 71.11           C  
ATOM   4327  NE2 HIS C  34      33.284  40.166  89.526  1.00 71.34           N  
ATOM   4328  N   LYS C  35      31.240  37.323  93.994  1.00 60.93           N  
ATOM   4329  CA  LYS C  35      31.619  37.783  95.321  1.00 61.02           C  
ATOM   4330  C   LYS C  35      32.809  36.969  95.852  1.00 60.69           C  
ATOM   4331  O   LYS C  35      33.495  37.395  96.782  1.00 61.36           O  
ATOM   4332  CB  LYS C  35      30.410  37.664  96.254  1.00 62.33           C  
ATOM   4333  CG  LYS C  35      30.583  38.350  97.592  1.00 66.46           C  
ATOM   4334  CD  LYS C  35      29.362  38.176  98.494  1.00 68.71           C  
ATOM   4335  CE  LYS C  35      28.134  38.898  97.939  1.00 70.96           C  
ATOM   4336  NZ  LYS C  35      26.948  38.832  98.864  1.00 70.06           N  
ATOM   4337  N   ARG C  36      33.051  35.806  95.247  1.00 59.68           N  
ATOM   4338  CA  ARG C  36      34.159  34.924  95.617  1.00 58.13           C  
ATOM   4339  C   ARG C  36      34.928  34.643  94.326  1.00 59.49           C  
ATOM   4340  O   ARG C  36      35.156  35.551  93.531  1.00 59.72           O  
ATOM   4341  CB  ARG C  36      33.607  33.632  96.201  1.00 55.42           C  
ATOM   4342  CG  ARG C  36      32.412  33.877  97.101  1.00 54.12           C  
ATOM   4343  CD  ARG C  36      31.635  32.610  97.398  1.00 54.00           C  
ATOM   4344  NE  ARG C  36      30.199  32.845  97.286  1.00 55.72           N  
ATOM   4345  CZ  ARG C  36      29.499  33.640  98.091  1.00 56.11           C  
ATOM   4346  NH1 ARG C  36      30.102  34.275  99.083  1.00 57.23           N  
ATOM   4347  NH2 ARG C  36      28.202  33.822  97.884  1.00 55.75           N  
ATOM   4348  N   GLY C  37      35.320  33.395  94.104  1.00 61.48           N  
ATOM   4349  CA  GLY C  37      36.037  33.059  92.878  1.00 63.50           C  
ATOM   4350  C   GLY C  37      35.104  32.647  91.740  1.00 65.21           C  
ATOM   4351  O   GLY C  37      35.093  31.483  91.316  1.00 63.99           O  
ATOM   4352  N   VAL C  38      34.327  33.609  91.243  1.00 66.67           N  
ATOM   4353  CA  VAL C  38      33.349  33.379  90.172  1.00 68.48           C  
ATOM   4354  C   VAL C  38      33.853  32.669  88.924  1.00 67.66           C  
ATOM   4355  O   VAL C  38      34.108  31.464  88.952  1.00 68.52           O  
ATOM   4356  CB  VAL C  38      32.678  34.716  89.727  1.00 71.00           C  
ATOM   4357  CG1 VAL C  38      33.747  35.693  89.243  1.00 73.10           C  
ATOM   4358  CG2 VAL C  38      31.603  34.464  88.642  1.00 71.47           C  
ATOM   4359  N   ALA C  39      33.988  33.431  87.839  1.00 65.58           N  
ATOM   4360  CA  ALA C  39      34.411  32.910  86.553  1.00 64.69           C  
ATOM   4361  C   ALA C  39      33.211  32.151  86.003  1.00 64.06           C  
ATOM   4362  O   ALA C  39      33.298  30.957  85.705  1.00 64.87           O  
ATOM   4363  CB  ALA C  39      35.620  31.972  86.713  1.00 64.10           C  
ATOM   4364  N   ILE C  40      32.079  32.839  85.884  1.00 62.40           N  
ATOM   4365  CA  ILE C  40      30.880  32.191  85.371  1.00 61.36           C  
ATOM   4366  C   ILE C  40      30.200  32.974  84.264  1.00 60.54           C  
ATOM   4367  O   ILE C  40      29.975  34.179  84.383  1.00 59.87           O  
ATOM   4368  CB  ILE C  40      29.886  31.916  86.514  1.00 61.74           C  
ATOM   4369  CG1 ILE C  40      30.465  30.823  87.405  1.00 61.66           C  
ATOM   4370  CG2 ILE C  40      28.530  31.480  85.970  1.00 60.73           C  
ATOM   4371  CD1 ILE C  40      29.523  30.342  88.439  1.00 63.27           C  
ATOM   4372  N   THR C  41      29.883  32.265  83.183  1.00 59.78           N  
ATOM   4373  CA  THR C  41      29.234  32.851  82.015  1.00 59.49           C  
ATOM   4374  C   THR C  41      27.722  32.685  82.115  1.00 59.68           C  
ATOM   4375  O   THR C  41      27.236  31.709  82.685  1.00 58.84           O  
ATOM   4376  CB  THR C  41      29.713  32.174  80.717  1.00 59.13           C  
ATOM   4377  OG1 THR C  41      29.027  30.930  80.539  1.00 58.74           O  
ATOM   4378  CG2 THR C  41      31.204  31.895  80.791  1.00 59.34           C  
ATOM   4379  N   ALA C  42      26.983  33.639  81.551  1.00 60.26           N  
ATOM   4380  CA  ALA C  42      25.522  33.606  81.581  1.00 60.03           C  
ATOM   4381  C   ALA C  42      24.970  32.438  80.784  1.00 59.63           C  
ATOM   4382  O   ALA C  42      23.776  32.154  80.829  1.00 59.25           O  
ATOM   4383  CB  ALA C  42      24.956  34.911  81.042  1.00 59.84           C  
ATOM   4384  N   GLU C  43      25.846  31.763  80.050  1.00 60.52           N  
ATOM   4385  CA  GLU C  43      25.444  30.623  79.248  1.00 61.76           C  
ATOM   4386  C   GLU C  43      25.337  29.398  80.160  1.00 60.04           C  
ATOM   4387  O   GLU C  43      24.479  28.541  79.968  1.00 59.84           O  
ATOM   4388  CB  GLU C  43      26.472  30.391  78.135  1.00 65.84           C  
ATOM   4389  CG  GLU C  43      25.884  29.800  76.866  1.00 72.75           C  
ATOM   4390  CD  GLU C  43      26.342  28.372  76.606  1.00 77.23           C  
ATOM   4391  OE1 GLU C  43      26.118  27.494  77.472  1.00 79.48           O  
ATOM   4392  OE2 GLU C  43      26.929  28.129  75.527  1.00 79.97           O  
ATOM   4393  N   GLU C  44      26.211  29.336  81.160  1.00 58.97           N  
ATOM   4394  CA  GLU C  44      26.228  28.240  82.132  1.00 57.20           C  
ATOM   4395  C   GLU C  44      25.041  28.361  83.090  1.00 55.98           C  
ATOM   4396  O   GLU C  44      24.472  27.362  83.516  1.00 55.72           O  
ATOM   4397  CB  GLU C  44      27.534  28.269  82.944  1.00 57.02           C  
ATOM   4398  CG  GLU C  44      28.787  27.824  82.185  1.00 57.47           C  
ATOM   4399  CD  GLU C  44      30.093  28.161  82.913  1.00 58.06           C  
ATOM   4400  OE1 GLU C  44      31.140  27.577  82.550  1.00 57.59           O  
ATOM   4401  OE2 GLU C  44      30.085  29.013  83.833  1.00 58.31           O  
ATOM   4402  N   ALA C  45      24.679  29.599  83.416  1.00 54.95           N  
ATOM   4403  CA  ALA C  45      23.583  29.887  84.331  1.00 54.23           C  
ATOM   4404  C   ALA C  45      22.199  29.510  83.815  1.00 55.23           C  
ATOM   4405  O   ALA C  45      21.264  29.355  84.604  1.00 54.47           O  
ATOM   4406  CB  ALA C  45      23.605  31.362  84.696  1.00 52.64           C  
ATOM   4407  N   ARG C  46      22.060  29.361  82.501  1.00 56.52           N  
ATOM   4408  CA  ARG C  46      20.763  29.016  81.926  1.00 58.31           C  
ATOM   4409  C   ARG C  46      20.507  27.519  81.889  1.00 59.02           C  
ATOM   4410  O   ARG C  46      19.359  27.095  81.809  1.00 60.03           O  
ATOM   4411  CB  ARG C  46      20.625  29.556  80.502  1.00 59.96           C  
ATOM   4412  CG  ARG C  46      20.930  31.028  80.329  1.00 62.77           C  
ATOM   4413  CD  ARG C  46      20.451  31.519  78.965  1.00 63.86           C  
ATOM   4414  NE  ARG C  46      19.141  32.161  79.060  1.00 65.12           N  
ATOM   4415  CZ  ARG C  46      18.932  33.461  78.858  1.00 65.42           C  
ATOM   4416  NH1 ARG C  46      19.944  34.260  78.540  1.00 65.55           N  
ATOM   4417  NH2 ARG C  46      17.714  33.966  78.995  1.00 64.00           N  
ATOM   4418  N   LYS C  47      21.568  26.720  81.939  1.00 59.63           N  
ATOM   4419  CA  LYS C  47      21.409  25.271  81.887  1.00 61.74           C  
ATOM   4420  C   LYS C  47      20.561  24.676  83.009  1.00 62.87           C  
ATOM   4421  O   LYS C  47      19.591  23.969  82.745  1.00 62.59           O  
ATOM   4422  CB  LYS C  47      22.778  24.591  81.854  1.00 62.52           C  
ATOM   4423  CG  LYS C  47      23.480  24.729  80.519  1.00 65.82           C  
ATOM   4424  CD  LYS C  47      24.887  24.158  80.549  1.00 68.81           C  
ATOM   4425  CE  LYS C  47      25.603  24.412  79.222  1.00 70.39           C  
ATOM   4426  NZ  LYS C  47      27.023  23.957  79.243  1.00 71.63           N  
ATOM   4427  N   PRO C  48      20.905  24.964  84.273  1.00 64.07           N  
ATOM   4428  CA  PRO C  48      20.148  24.433  85.410  1.00 65.14           C  
ATOM   4429  C   PRO C  48      18.636  24.550  85.276  1.00 66.69           C  
ATOM   4430  O   PRO C  48      18.088  25.657  85.237  1.00 67.07           O  
ATOM   4431  CB  PRO C  48      20.677  25.250  86.584  1.00 63.98           C  
ATOM   4432  CG  PRO C  48      22.088  25.478  86.203  1.00 64.78           C  
ATOM   4433  CD  PRO C  48      21.971  25.864  84.743  1.00 64.76           C  
ATOM   4434  N   MET C  49      17.970  23.401  85.195  1.00 68.35           N  
ATOM   4435  CA  MET C  49      16.511  23.359  85.109  1.00 69.69           C  
ATOM   4436  C   MET C  49      15.968  22.390  86.161  1.00 68.43           C  
ATOM   4437  O   MET C  49      14.902  21.799  85.989  1.00 68.69           O  
ATOM   4438  CB  MET C  49      16.040  22.944  83.707  1.00 71.93           C  
ATOM   4439  CG  MET C  49      15.566  24.123  82.840  1.00 75.95           C  
ATOM   4440  SD  MET C  49      14.212  25.121  83.592  1.00 80.89           S  
ATOM   4441  CE  MET C  49      12.788  24.693  82.528  1.00 79.60           C  
ATOM   4442  N   GLY C  50      16.720  22.247  87.252  1.00 66.17           N  
ATOM   4443  CA  GLY C  50      16.324  21.366  88.337  1.00 62.12           C  
ATOM   4444  C   GLY C  50      15.030  21.794  89.000  1.00 59.50           C  
ATOM   4445  O   GLY C  50      14.447  22.818  88.644  1.00 60.13           O  
ATOM   4446  N   LEU C  51      14.588  21.021  89.982  1.00 56.30           N  
ATOM   4447  CA  LEU C  51      13.344  21.311  90.678  1.00 53.56           C  
ATOM   4448  C   LEU C  51      13.372  22.571  91.542  1.00 52.64           C  
ATOM   4449  O   LEU C  51      12.607  23.506  91.309  1.00 52.57           O  
ATOM   4450  CB  LEU C  51      12.963  20.104  91.535  1.00 53.60           C  
ATOM   4451  CG  LEU C  51      11.663  20.207  92.324  1.00 52.86           C  
ATOM   4452  CD1 LEU C  51      10.538  20.625  91.401  1.00 53.44           C  
ATOM   4453  CD2 LEU C  51      11.357  18.877  92.965  1.00 52.59           C  
ATOM   4454  N   LEU C  52      14.255  22.587  92.538  1.00 51.55           N  
ATOM   4455  CA  LEU C  52      14.380  23.712  93.465  1.00 49.57           C  
ATOM   4456  C   LEU C  52      15.564  24.626  93.167  1.00 49.05           C  
ATOM   4457  O   LEU C  52      16.500  24.229  92.474  1.00 47.97           O  
ATOM   4458  CB  LEU C  52      14.506  23.184  94.897  1.00 48.72           C  
ATOM   4459  CG  LEU C  52      13.258  22.878  95.729  1.00 47.29           C  
ATOM   4460  CD1 LEU C  52      12.150  22.317  94.869  1.00 47.70           C  
ATOM   4461  CD2 LEU C  52      13.639  21.905  96.828  1.00 45.21           C  
ATOM   4462  N   ARG C  53      15.513  25.847  93.705  1.00 48.49           N  
ATOM   4463  CA  ARG C  53      16.577  26.831  93.517  1.00 48.62           C  
ATOM   4464  C   ARG C  53      17.899  26.336  94.066  1.00 48.17           C  
ATOM   4465  O   ARG C  53      18.943  26.528  93.452  1.00 48.00           O  
ATOM   4466  CB  ARG C  53      16.220  28.157  94.196  1.00 50.34           C  
ATOM   4467  CG  ARG C  53      15.541  29.159  93.284  1.00 52.77           C  
ATOM   4468  CD  ARG C  53      16.519  29.693  92.256  1.00 56.12           C  
ATOM   4469  NE  ARG C  53      15.866  30.107  91.015  1.00 60.13           N  
ATOM   4470  CZ  ARG C  53      14.898  31.018  90.935  1.00 63.34           C  
ATOM   4471  NH1 ARG C  53      14.457  31.621  92.037  1.00 65.25           N  
ATOM   4472  NH2 ARG C  53      14.372  31.328  89.754  1.00 62.99           N  
ATOM   4473  N   ILE C  54      17.857  25.703  95.231  1.00 47.91           N  
ATOM   4474  CA  ILE C  54      19.069  25.182  95.835  1.00 48.66           C  
ATOM   4475  C   ILE C  54      19.687  24.161  94.889  1.00 49.31           C  
ATOM   4476  O   ILE C  54      20.915  24.053  94.785  1.00 49.22           O  
ATOM   4477  CB  ILE C  54      18.762  24.512  97.167  1.00 49.75           C  
ATOM   4478  CG1 ILE C  54      17.710  25.335  97.901  1.00 51.80           C  
ATOM   4479  CG2 ILE C  54      20.027  24.423  98.023  1.00 49.03           C  
ATOM   4480  CD1 ILE C  54      17.322  24.769  99.248  1.00 55.41           C  
ATOM   4481  N   ASP C  55      18.831  23.414  94.196  1.00 49.15           N  
ATOM   4482  CA  ASP C  55      19.300  22.409  93.243  1.00 48.66           C  
ATOM   4483  C   ASP C  55      20.075  23.102  92.116  1.00 47.12           C  
ATOM   4484  O   ASP C  55      21.008  22.533  91.550  1.00 45.88           O  
ATOM   4485  CB  ASP C  55      18.125  21.612  92.639  1.00 50.39           C  
ATOM   4486  CG  ASP C  55      17.287  20.880  93.690  1.00 51.31           C  
ATOM   4487  OD1 ASP C  55      17.857  20.278  94.627  1.00 52.61           O  
ATOM   4488  OD2 ASP C  55      16.044  20.890  93.558  1.00 51.39           O  
ATOM   4489  N   HIS C  56      19.679  24.333  91.792  1.00 45.93           N  
ATOM   4490  CA  HIS C  56      20.349  25.089  90.740  1.00 44.78           C  
ATOM   4491  C   HIS C  56      21.766  25.428  91.188  1.00 43.28           C  
ATOM   4492  O   HIS C  56      22.730  25.181  90.463  1.00 42.00           O  
ATOM   4493  CB  HIS C  56      19.583  26.382  90.408  1.00 46.22           C  
ATOM   4494  CG  HIS C  56      18.211  26.156  89.839  1.00 48.83           C  
ATOM   4495  ND1 HIS C  56      17.957  25.248  88.835  1.00 50.15           N  
ATOM   4496  CD2 HIS C  56      17.023  26.744  90.123  1.00 49.29           C  
ATOM   4497  CE1 HIS C  56      16.671  25.282  88.525  1.00 48.71           C  
ATOM   4498  NE2 HIS C  56      16.083  26.180  89.290  1.00 48.48           N  
ATOM   4499  N   VAL C  57      21.890  25.987  92.388  1.00 41.55           N  
ATOM   4500  CA  VAL C  57      23.193  26.352  92.923  1.00 40.92           C  
ATOM   4501  C   VAL C  57      24.111  25.135  92.963  1.00 41.82           C  
ATOM   4502  O   VAL C  57      25.283  25.218  92.598  1.00 40.93           O  
ATOM   4503  CB  VAL C  57      23.052  26.957  94.329  1.00 40.35           C  
ATOM   4504  CG1 VAL C  57      24.428  27.234  94.929  1.00 40.23           C  
ATOM   4505  CG2 VAL C  57      22.251  28.238  94.244  1.00 37.06           C  
ATOM   4506  N   ARG C  58      23.563  24.003  93.395  1.00 44.01           N  
ATOM   4507  CA  ARG C  58      24.310  22.746  93.468  1.00 45.28           C  
ATOM   4508  C   ARG C  58      24.821  22.323  92.093  1.00 44.88           C  
ATOM   4509  O   ARG C  58      25.953  21.863  91.957  1.00 44.05           O  
ATOM   4510  CB  ARG C  58      23.418  21.636  94.034  1.00 47.71           C  
ATOM   4511  CG  ARG C  58      24.062  20.252  94.069  1.00 50.93           C  
ATOM   4512  CD  ARG C  58      23.218  19.285  94.879  1.00 53.47           C  
ATOM   4513  NE  ARG C  58      22.610  19.979  96.011  1.00 60.43           N  
ATOM   4514  CZ  ARG C  58      22.224  19.405  97.147  1.00 64.30           C  
ATOM   4515  NH1 ARG C  58      22.376  18.098  97.337  1.00 67.67           N  
ATOM   4516  NH2 ARG C  58      21.680  20.144  98.104  1.00 66.31           N  
ATOM   4517  N   ALA C  59      23.966  22.476  91.085  1.00 44.94           N  
ATOM   4518  CA  ALA C  59      24.291  22.116  89.710  1.00 45.72           C  
ATOM   4519  C   ALA C  59      25.539  22.834  89.191  1.00 46.33           C  
ATOM   4520  O   ALA C  59      26.356  22.245  88.480  1.00 45.28           O  
ATOM   4521  CB  ALA C  59      23.100  22.417  88.809  1.00 44.47           C  
ATOM   4522  N   LEU C  60      25.674  24.112  89.536  1.00 46.65           N  
ATOM   4523  CA  LEU C  60      26.829  24.889  89.108  1.00 47.33           C  
ATOM   4524  C   LEU C  60      28.061  24.366  89.824  1.00 48.68           C  
ATOM   4525  O   LEU C  60      29.159  24.356  89.271  1.00 49.31           O  
ATOM   4526  CB  LEU C  60      26.622  26.373  89.427  1.00 47.05           C  
ATOM   4527  CG  LEU C  60      25.658  27.151  88.524  1.00 45.38           C  
ATOM   4528  CD1 LEU C  60      26.155  27.120  87.101  1.00 44.37           C  
ATOM   4529  CD2 LEU C  60      24.277  26.550  88.600  1.00 45.71           C  
ATOM   4530  N   THR C  61      27.864  23.935  91.067  1.00 49.94           N  
ATOM   4531  CA  THR C  61      28.931  23.374  91.880  1.00 50.09           C  
ATOM   4532  C   THR C  61      29.477  22.155  91.156  1.00 50.69           C  
ATOM   4533  O   THR C  61      30.679  22.022  90.953  1.00 50.26           O  
ATOM   4534  CB  THR C  61      28.391  22.905  93.234  1.00 50.74           C  
ATOM   4535  OG1 THR C  61      27.936  24.027  93.994  1.00 50.32           O  
ATOM   4536  CG2 THR C  61      29.456  22.178  94.000  1.00 53.88           C  
ATOM   4537  N   GLU C  62      28.560  21.271  90.773  1.00 52.37           N  
ATOM   4538  CA  GLU C  62      28.868  20.028  90.064  1.00 54.41           C  
ATOM   4539  C   GLU C  62      29.582  20.246  88.723  1.00 55.07           C  
ATOM   4540  O   GLU C  62      30.492  19.499  88.367  1.00 55.59           O  
ATOM   4541  CB  GLU C  62      27.566  19.253  89.800  1.00 55.54           C  
ATOM   4542  CG  GLU C  62      27.510  17.826  90.332  1.00 55.82           C  
ATOM   4543  CD  GLU C  62      26.996  17.751  91.754  1.00 55.98           C  
ATOM   4544  OE1 GLU C  62      27.696  18.212  92.675  1.00 57.43           O  
ATOM   4545  OE2 GLU C  62      25.880  17.237  91.949  1.00 56.23           O  
ATOM   4546  N   MET C  63      29.153  21.258  87.974  1.00 56.12           N  
ATOM   4547  CA  MET C  63      29.736  21.554  86.666  1.00 56.82           C  
ATOM   4548  C   MET C  63      31.259  21.590  86.654  1.00 58.27           C  
ATOM   4549  O   MET C  63      31.873  22.443  87.305  1.00 58.53           O  
ATOM   4550  CB  MET C  63      29.203  22.892  86.146  1.00 55.19           C  
ATOM   4551  CG  MET C  63      28.235  22.771  84.992  1.00 53.54           C  
ATOM   4552  SD  MET C  63      27.405  24.327  84.635  1.00 52.85           S  
ATOM   4553  CE  MET C  63      25.786  23.958  85.227  1.00 52.13           C  
ATOM   4554  N   PRO C  64      31.896  20.655  85.918  1.00 59.67           N  
ATOM   4555  CA  PRO C  64      33.365  20.631  85.847  1.00 60.32           C  
ATOM   4556  C   PRO C  64      33.776  21.989  85.304  1.00 61.65           C  
ATOM   4557  O   PRO C  64      32.958  22.664  84.671  1.00 63.93           O  
ATOM   4558  CB  PRO C  64      33.652  19.516  84.846  1.00 58.53           C  
ATOM   4559  CG  PRO C  64      32.479  18.601  85.013  1.00 59.61           C  
ATOM   4560  CD  PRO C  64      31.312  19.559  85.124  1.00 58.94           C  
ATOM   4561  N   ARG C  65      35.021  22.392  85.536  1.00 61.06           N  
ATOM   4562  CA  ARG C  65      35.500  23.692  85.061  1.00 60.66           C  
ATOM   4563  C   ARG C  65      35.190  24.702  86.156  1.00 60.01           C  
ATOM   4564  O   ARG C  65      36.085  25.401  86.636  1.00 60.14           O  
ATOM   4565  CB  ARG C  65      34.805  24.082  83.742  1.00 60.21           C  
ATOM   4566  CG  ARG C  65      35.336  25.339  83.081  1.00 60.43           C  
ATOM   4567  CD  ARG C  65      34.376  26.495  83.225  1.00 60.86           C  
ATOM   4568  NE  ARG C  65      35.096  27.729  83.514  1.00 62.46           N  
ATOM   4569  CZ  ARG C  65      34.516  28.901  83.755  1.00 62.74           C  
ATOM   4570  NH1 ARG C  65      33.190  29.007  83.736  1.00 61.86           N  
ATOM   4571  NH2 ARG C  65      35.265  29.961  84.036  1.00 62.92           N  
ATOM   4572  N   ILE C  66      33.919  24.774  86.549  1.00 59.07           N  
ATOM   4573  CA  ILE C  66      33.516  25.669  87.626  1.00 57.90           C  
ATOM   4574  C   ILE C  66      34.052  25.038  88.906  1.00 56.93           C  
ATOM   4575  O   ILE C  66      34.615  25.714  89.764  1.00 54.96           O  
ATOM   4576  CB  ILE C  66      31.982  25.800  87.713  1.00 57.79           C  
ATOM   4577  CG1 ILE C  66      31.497  26.830  86.689  1.00 57.26           C  
ATOM   4578  CG2 ILE C  66      31.566  26.206  89.115  1.00 57.94           C  
ATOM   4579  CD1 ILE C  66      30.013  27.077  86.730  1.00 55.34           C  
ATOM   4580  N   ALA C  67      33.888  23.727  89.018  1.00 56.80           N  
ATOM   4581  CA  ALA C  67      34.384  23.011  90.177  1.00 57.75           C  
ATOM   4582  C   ALA C  67      35.885  23.268  90.293  1.00 58.32           C  
ATOM   4583  O   ALA C  67      36.381  23.713  91.330  1.00 57.72           O  
ATOM   4584  CB  ALA C  67      34.117  21.524  90.021  1.00 56.99           C  
ATOM   4585  N   SER C  68      36.597  22.991  89.203  1.00 59.81           N  
ATOM   4586  CA  SER C  68      38.044  23.170  89.127  1.00 60.21           C  
ATOM   4587  C   SER C  68      38.486  24.565  89.562  1.00 60.08           C  
ATOM   4588  O   SER C  68      39.459  24.720  90.306  1.00 59.26           O  
ATOM   4589  CB  SER C  68      38.514  22.902  87.699  1.00 60.50           C  
ATOM   4590  OG  SER C  68      39.913  23.084  87.589  1.00 63.06           O  
ATOM   4591  N   GLU C  69      37.774  25.578  89.080  1.00 60.73           N  
ATOM   4592  CA  GLU C  69      38.062  26.965  89.422  1.00 61.33           C  
ATOM   4593  C   GLU C  69      37.968  27.165  90.933  1.00 60.48           C  
ATOM   4594  O   GLU C  69      38.868  27.732  91.555  1.00 60.04           O  
ATOM   4595  CB  GLU C  69      37.067  27.894  88.722  1.00 63.28           C  
ATOM   4596  CG  GLU C  69      37.509  28.414  87.361  1.00 67.28           C  
ATOM   4597  CD  GLU C  69      38.612  29.459  87.468  1.00 70.08           C  
ATOM   4598  OE1 GLU C  69      39.752  29.084  87.815  1.00 71.09           O  
ATOM   4599  OE2 GLU C  69      38.341  30.657  87.216  1.00 71.31           O  
ATOM   4600  N   TRP C  70      36.868  26.696  91.517  1.00 59.55           N  
ATOM   4601  CA  TRP C  70      36.642  26.816  92.954  1.00 58.49           C  
ATOM   4602  C   TRP C  70      37.806  26.184  93.708  1.00 59.80           C  
ATOM   4603  O   TRP C  70      38.291  26.745  94.691  1.00 60.37           O  
ATOM   4604  CB  TRP C  70      35.310  26.141  93.343  1.00 55.17           C  
ATOM   4605  CG  TRP C  70      34.901  26.303  94.801  1.00 50.52           C  
ATOM   4606  CD1 TRP C  70      35.387  25.606  95.870  1.00 48.97           C  
ATOM   4607  CD2 TRP C  70      33.959  27.249  95.339  1.00 47.31           C  
ATOM   4608  NE1 TRP C  70      34.812  26.056  97.034  1.00 47.61           N  
ATOM   4609  CE2 TRP C  70      33.933  27.064  96.737  1.00 46.42           C  
ATOM   4610  CE3 TRP C  70      33.138  28.231  94.775  1.00 44.75           C  
ATOM   4611  CZ2 TRP C  70      33.120  27.828  97.582  1.00 44.00           C  
ATOM   4612  CZ3 TRP C  70      32.326  28.991  95.617  1.00 43.32           C  
ATOM   4613  CH2 TRP C  70      32.326  28.782  97.003  1.00 42.42           C  
ATOM   4614  N   ASN C  71      38.266  25.028  93.231  1.00 61.05           N  
ATOM   4615  CA  ASN C  71      39.377  24.328  93.870  1.00 62.71           C  
ATOM   4616  C   ASN C  71      40.692  25.100  93.811  1.00 63.94           C  
ATOM   4617  O   ASN C  71      41.478  25.068  94.755  1.00 64.05           O  
ATOM   4618  CB  ASN C  71      39.588  22.954  93.234  1.00 62.96           C  
ATOM   4619  CG  ASN C  71      40.677  22.152  93.934  1.00 64.17           C  
ATOM   4620  OD1 ASN C  71      40.517  21.733  95.081  1.00 65.27           O  
ATOM   4621  ND2 ASN C  71      41.796  21.946  93.249  1.00 64.53           N  
ATOM   4622  N   ARG C  72      40.938  25.788  92.702  1.00 65.41           N  
ATOM   4623  CA  ARG C  72      42.173  26.548  92.547  1.00 66.32           C  
ATOM   4624  C   ARG C  72      42.159  27.797  93.416  1.00 65.43           C  
ATOM   4625  O   ARG C  72      43.201  28.379  93.711  1.00 65.33           O  
ATOM   4626  CB  ARG C  72      42.360  26.951  91.084  1.00 68.84           C  
ATOM   4627  CG  ARG C  72      43.741  27.494  90.759  1.00 71.84           C  
ATOM   4628  CD  ARG C  72      43.759  28.188  89.407  1.00 75.34           C  
ATOM   4629  NE  ARG C  72      43.511  29.627  89.510  1.00 78.73           N  
ATOM   4630  CZ  ARG C  72      42.373  30.182  89.921  1.00 80.54           C  
ATOM   4631  NH1 ARG C  72      41.344  29.426  90.279  1.00 82.75           N  
ATOM   4632  NH2 ARG C  72      42.260  31.504  89.974  1.00 81.08           N  
ATOM   4633  N   VAL C  73      40.966  28.201  93.827  1.00 64.72           N  
ATOM   4634  CA  VAL C  73      40.815  29.388  94.651  1.00 64.39           C  
ATOM   4635  C   VAL C  73      40.753  29.068  96.135  1.00 64.24           C  
ATOM   4636  O   VAL C  73      41.193  29.863  96.970  1.00 63.80           O  
ATOM   4637  CB  VAL C  73      39.537  30.145  94.280  1.00 64.47           C  
ATOM   4638  CG1 VAL C  73      39.455  31.442  95.074  1.00 63.67           C  
ATOM   4639  CG2 VAL C  73      39.511  30.410  92.780  1.00 64.37           C  
ATOM   4640  N   PHE C  74      40.206  27.903  96.462  1.00 64.10           N  
ATOM   4641  CA  PHE C  74      40.065  27.505  97.854  1.00 64.07           C  
ATOM   4642  C   PHE C  74      40.796  26.204  98.209  1.00 64.23           C  
ATOM   4643  O   PHE C  74      40.775  25.768  99.362  1.00 64.03           O  
ATOM   4644  CB  PHE C  74      38.572  27.369  98.202  1.00 63.21           C  
ATOM   4645  CG  PHE C  74      37.749  28.615  97.933  1.00 61.58           C  
ATOM   4646  CD1 PHE C  74      37.025  28.754  96.750  1.00 60.61           C  
ATOM   4647  CD2 PHE C  74      37.670  29.637  98.886  1.00 60.26           C  
ATOM   4648  CE1 PHE C  74      36.231  29.884  96.525  1.00 59.56           C  
ATOM   4649  CE2 PHE C  74      36.878  30.771  98.665  1.00 58.13           C  
ATOM   4650  CZ  PHE C  74      36.159  30.894  97.487  1.00 58.61           C  
ATOM   4651  N   ARG C  75      41.439  25.590  97.222  1.00 64.48           N  
ATOM   4652  CA  ARG C  75      42.170  24.340  97.436  1.00 64.73           C  
ATOM   4653  C   ARG C  75      41.256  23.234  97.960  1.00 62.77           C  
ATOM   4654  O   ARG C  75      41.730  22.237  98.503  1.00 63.03           O  
ATOM   4655  CB  ARG C  75      43.309  24.541  98.440  1.00 67.39           C  
ATOM   4656  CG  ARG C  75      44.113  25.818  98.264  1.00 72.01           C  
ATOM   4657  CD  ARG C  75      44.622  25.990  96.844  1.00 76.97           C  
ATOM   4658  NE  ARG C  75      45.833  26.807  96.818  1.00 81.61           N  
ATOM   4659  CZ  ARG C  75      47.048  26.354  97.120  1.00 83.34           C  
ATOM   4660  NH1 ARG C  75      47.220  25.082  97.463  1.00 84.28           N  
ATOM   4661  NH2 ARG C  75      48.095  27.174  97.093  1.00 83.64           N  
ATOM   4662  N   GLN C  76      39.949  23.408  97.784  1.00 60.55           N  
ATOM   4663  CA  GLN C  76      38.965  22.441  98.266  1.00 58.04           C  
ATOM   4664  C   GLN C  76      37.737  22.446  97.357  1.00 56.09           C  
ATOM   4665  O   GLN C  76      37.459  23.439  96.689  1.00 55.37           O  
ATOM   4666  CB  GLN C  76      38.550  22.824  99.691  1.00 57.74           C  
ATOM   4667  CG  GLN C  76      37.595  21.874 100.391  1.00 58.55           C  
ATOM   4668  CD  GLN C  76      37.077  22.444 101.713  1.00 59.68           C  
ATOM   4669  OE1 GLN C  76      36.586  21.710 102.571  1.00 60.91           O  
ATOM   4670  NE2 GLN C  76      37.176  23.758 101.874  1.00 59.00           N  
ATOM   4671  N   LEU C  77      37.004  21.338  97.325  1.00 54.29           N  
ATOM   4672  CA  LEU C  77      35.797  21.281  96.509  1.00 52.65           C  
ATOM   4673  C   LEU C  77      34.643  21.899  97.295  1.00 51.62           C  
ATOM   4674  O   LEU C  77      34.633  21.861  98.524  1.00 51.54           O  
ATOM   4675  CB  LEU C  77      35.447  19.839  96.143  1.00 51.88           C  
ATOM   4676  CG  LEU C  77      36.432  19.126  95.225  1.00 51.20           C  
ATOM   4677  CD1 LEU C  77      35.743  17.929  94.591  1.00 49.81           C  
ATOM   4678  CD2 LEU C  77      36.914  20.085  94.150  1.00 51.29           C  
ATOM   4679  N   PRO C  78      33.661  22.487  96.592  1.00 50.26           N  
ATOM   4680  CA  PRO C  78      32.507  23.111  97.244  1.00 48.83           C  
ATOM   4681  C   PRO C  78      31.856  22.191  98.275  1.00 48.09           C  
ATOM   4682  O   PRO C  78      31.820  20.976  98.094  1.00 47.95           O  
ATOM   4683  CB  PRO C  78      31.601  23.439  96.069  1.00 49.33           C  
ATOM   4684  CG  PRO C  78      32.588  23.781  94.997  1.00 49.31           C  
ATOM   4685  CD  PRO C  78      33.600  22.673  95.131  1.00 49.87           C  
ATOM   4686  N   THR C  79      31.335  22.799  99.342  1.00 47.40           N  
ATOM   4687  CA  THR C  79      30.714  22.103 100.471  1.00 46.69           C  
ATOM   4688  C   THR C  79      29.200  22.294 100.586  1.00 46.98           C  
ATOM   4689  O   THR C  79      28.642  23.213  99.985  1.00 47.79           O  
ATOM   4690  CB  THR C  79      31.350  22.612 101.779  1.00 46.59           C  
ATOM   4691  OG1 THR C  79      32.739  22.270 101.793  1.00 46.51           O  
ATOM   4692  CG2 THR C  79      30.666  22.020 102.993  1.00 49.36           C  
ATOM   4693  N   GLU C  80      28.533  21.421 101.350  1.00 46.44           N  
ATOM   4694  CA  GLU C  80      27.092  21.554 101.573  1.00 44.78           C  
ATOM   4695  C   GLU C  80      26.958  22.884 102.269  1.00 43.99           C  
ATOM   4696  O   GLU C  80      26.049  23.655 101.997  1.00 44.60           O  
ATOM   4697  CB  GLU C  80      26.553  20.495 102.522  1.00 45.20           C  
ATOM   4698  CG  GLU C  80      26.567  19.097 101.992  1.00 49.98           C  
ATOM   4699  CD  GLU C  80      25.844  18.965 100.676  1.00 52.29           C  
ATOM   4700  OE1 GLU C  80      24.745  19.551 100.531  1.00 54.20           O  
ATOM   4701  OE2 GLU C  80      26.376  18.261  99.794  1.00 53.79           O  
ATOM   4702  N   ALA C  81      27.882  23.135 103.190  1.00 42.81           N  
ATOM   4703  CA  ALA C  81      27.893  24.377 103.931  1.00 41.15           C  
ATOM   4704  C   ALA C  81      27.977  25.524 102.942  1.00 40.99           C  
ATOM   4705  O   ALA C  81      27.249  26.504 103.063  1.00 40.58           O  
ATOM   4706  CB  ALA C  81      29.074  24.408 104.871  1.00 41.18           C  
ATOM   4707  N   ASP C  82      28.862  25.391 101.957  1.00 40.72           N  
ATOM   4708  CA  ASP C  82      29.034  26.424 100.941  1.00 40.66           C  
ATOM   4709  C   ASP C  82      27.792  26.615 100.075  1.00 40.99           C  
ATOM   4710  O   ASP C  82      27.318  27.735  99.895  1.00 41.12           O  
ATOM   4711  CB  ASP C  82      30.221  26.091 100.042  1.00 41.21           C  
ATOM   4712  CG  ASP C  82      31.520  26.055 100.794  1.00 42.56           C  
ATOM   4713  OD1 ASP C  82      31.601  26.680 101.870  1.00 43.74           O  
ATOM   4714  OD2 ASP C  82      32.468  25.415 100.299  1.00 44.53           O  
ATOM   4715  N   ILE C  83      27.278  25.523  99.525  1.00 40.93           N  
ATOM   4716  CA  ILE C  83      26.082  25.591  98.699  1.00 41.76           C  
ATOM   4717  C   ILE C  83      24.984  26.300  99.486  1.00 44.25           C  
ATOM   4718  O   ILE C  83      24.294  27.175  98.964  1.00 45.06           O  
ATOM   4719  CB  ILE C  83      25.607  24.184  98.320  1.00 39.33           C  
ATOM   4720  CG1 ILE C  83      26.714  23.474  97.547  1.00 38.18           C  
ATOM   4721  CG2 ILE C  83      24.326  24.260  97.513  1.00 37.07           C  
ATOM   4722  CD1 ILE C  83      26.348  22.100  97.094  1.00 38.39           C  
ATOM   4723  N   GLN C  84      24.846  25.922 100.753  1.00 46.78           N  
ATOM   4724  CA  GLN C  84      23.849  26.497 101.647  1.00 48.76           C  
ATOM   4725  C   GLN C  84      24.064  27.991 101.866  1.00 48.95           C  
ATOM   4726  O   GLN C  84      23.113  28.761 101.903  1.00 48.93           O  
ATOM   4727  CB  GLN C  84      23.885  25.782 103.000  1.00 51.12           C  
ATOM   4728  CG  GLN C  84      22.772  26.199 103.947  1.00 56.34           C  
ATOM   4729  CD  GLN C  84      21.407  25.691 103.503  1.00 59.98           C  
ATOM   4730  OE1 GLN C  84      20.372  26.305 103.799  1.00 62.12           O  
ATOM   4731  NE2 GLN C  84      21.394  24.557 102.801  1.00 60.15           N  
ATOM   4732  N   GLU C  85      25.318  28.392 102.015  1.00 50.42           N  
ATOM   4733  CA  GLU C  85      25.647  29.793 102.243  1.00 51.44           C  
ATOM   4734  C   GLU C  85      25.315  30.660 101.036  1.00 50.98           C  
ATOM   4735  O   GLU C  85      24.845  31.788 101.192  1.00 50.79           O  
ATOM   4736  CB  GLU C  85      27.132  29.931 102.591  1.00 53.91           C  
ATOM   4737  CG  GLU C  85      27.408  30.846 103.781  1.00 58.16           C  
ATOM   4738  CD  GLU C  85      27.904  32.219 103.377  1.00 60.13           C  
ATOM   4739  OE1 GLU C  85      27.801  33.151 104.206  1.00 62.56           O  
ATOM   4740  OE2 GLU C  85      28.409  32.365 102.242  1.00 60.37           O  
ATOM   4741  N   MET C  86      25.554  30.139  99.835  1.00 50.25           N  
ATOM   4742  CA  MET C  86      25.266  30.897  98.621  1.00 49.85           C  
ATOM   4743  C   MET C  86      23.764  31.007  98.380  1.00 50.13           C  
ATOM   4744  O   MET C  86      23.244  32.108  98.240  1.00 50.76           O  
ATOM   4745  CB  MET C  86      25.952  30.272  97.398  1.00 48.25           C  
ATOM   4746  CG  MET C  86      27.476  30.313  97.455  1.00 46.40           C  
ATOM   4747  SD  MET C  86      28.298  29.903  95.902  1.00 45.22           S  
ATOM   4748  CE  MET C  86      27.947  28.161  95.759  1.00 44.94           C  
ATOM   4749  N   TYR C  87      23.071  29.875  98.325  1.00 50.15           N  
ATOM   4750  CA  TYR C  87      21.627  29.873  98.103  1.00 50.71           C  
ATOM   4751  C   TYR C  87      20.923  30.853  99.039  1.00 51.80           C  
ATOM   4752  O   TYR C  87      20.064  31.635  98.628  1.00 51.32           O  
ATOM   4753  CB  TYR C  87      21.066  28.467  98.329  1.00 50.62           C  
ATOM   4754  CG  TYR C  87      19.582  28.445  98.630  1.00 50.70           C  
ATOM   4755  CD1 TYR C  87      18.644  28.757  97.644  1.00 50.23           C  
ATOM   4756  CD2 TYR C  87      19.119  28.153  99.913  1.00 50.37           C  
ATOM   4757  CE1 TYR C  87      17.279  28.777  97.928  1.00 50.36           C  
ATOM   4758  CE2 TYR C  87      17.755  28.172 100.211  1.00 50.23           C  
ATOM   4759  CZ  TYR C  87      16.841  28.484  99.212  1.00 50.92           C  
ATOM   4760  OH  TYR C  87      15.490  28.484  99.494  1.00 51.71           O  
ATOM   4761  N   GLU C  88      21.299  30.786 100.309  1.00 53.82           N  
ATOM   4762  CA  GLU C  88      20.739  31.633 101.352  1.00 56.92           C  
ATOM   4763  C   GLU C  88      20.782  33.100 100.949  1.00 56.87           C  
ATOM   4764  O   GLU C  88      19.989  33.914 101.409  1.00 58.61           O  
ATOM   4765  CB  GLU C  88      21.564  31.465 102.624  1.00 60.88           C  
ATOM   4766  CG  GLU C  88      20.868  31.872 103.898  1.00 66.04           C  
ATOM   4767  CD  GLU C  88      20.115  30.717 104.517  1.00 70.19           C  
ATOM   4768  OE1 GLU C  88      19.508  30.921 105.593  1.00 74.41           O  
ATOM   4769  OE2 GLU C  88      20.132  29.606 103.934  1.00 71.15           O  
ATOM   4770  N   GLU C  89      21.722  33.420 100.078  1.00 56.83           N  
ATOM   4771  CA  GLU C  89      21.958  34.779  99.619  1.00 56.20           C  
ATOM   4772  C   GLU C  89      21.221  35.141  98.335  1.00 55.13           C  
ATOM   4773  O   GLU C  89      20.993  36.315  98.046  1.00 55.43           O  
ATOM   4774  CB  GLU C  89      23.470  34.929  99.447  1.00 56.99           C  
ATOM   4775  CG  GLU C  89      23.980  36.236  98.939  1.00 59.39           C  
ATOM   4776  CD  GLU C  89      25.490  36.282  99.021  1.00 61.51           C  
ATOM   4777  OE1 GLU C  89      26.013  36.402 100.148  1.00 62.83           O  
ATOM   4778  OE2 GLU C  89      26.156  36.174  97.968  1.00 63.47           O  
ATOM   4779  N   PHE C  90      20.838  34.122  97.576  1.00 53.88           N  
ATOM   4780  CA  PHE C  90      20.147  34.313  96.310  1.00 53.22           C  
ATOM   4781  C   PHE C  90      18.935  35.239  96.392  1.00 54.67           C  
ATOM   4782  O   PHE C  90      18.824  36.196  95.620  1.00 54.61           O  
ATOM   4783  CB  PHE C  90      19.695  32.960  95.752  1.00 49.76           C  
ATOM   4784  CG  PHE C  90      19.186  33.025  94.332  1.00 46.01           C  
ATOM   4785  CD1 PHE C  90      20.072  32.989  93.261  1.00 44.13           C  
ATOM   4786  CD2 PHE C  90      17.822  33.134  94.071  1.00 44.28           C  
ATOM   4787  CE1 PHE C  90      19.610  33.061  91.960  1.00 42.54           C  
ATOM   4788  CE2 PHE C  90      17.353  33.209  92.770  1.00 42.25           C  
ATOM   4789  CZ  PHE C  90      18.248  33.170  91.713  1.00 42.16           C  
ATOM   4790  N   GLU C  91      18.026  34.958  97.321  1.00 55.95           N  
ATOM   4791  CA  GLU C  91      16.820  35.763  97.426  1.00 57.65           C  
ATOM   4792  C   GLU C  91      17.064  37.197  97.827  1.00 56.53           C  
ATOM   4793  O   GLU C  91      16.327  38.096  97.421  1.00 56.95           O  
ATOM   4794  CB  GLU C  91      15.815  35.137  98.391  1.00 61.56           C  
ATOM   4795  CG  GLU C  91      14.411  35.701  98.185  1.00 67.14           C  
ATOM   4796  CD  GLU C  91      13.343  34.961  98.967  1.00 71.09           C  
ATOM   4797  OE1 GLU C  91      13.229  35.183 100.196  1.00 72.69           O  
ATOM   4798  OE2 GLU C  91      12.617  34.152  98.345  1.00 73.51           O  
ATOM   4799  N   GLU C  92      18.097  37.426  98.620  1.00 55.26           N  
ATOM   4800  CA  GLU C  92      18.389  38.782  99.041  1.00 54.10           C  
ATOM   4801  C   GLU C  92      18.733  39.647  97.829  1.00 50.91           C  
ATOM   4802  O   GLU C  92      18.125  40.696  97.607  1.00 50.23           O  
ATOM   4803  CB  GLU C  92      19.542  38.776 100.036  1.00 57.52           C  
ATOM   4804  CG  GLU C  92      19.814  40.127 100.654  1.00 62.65           C  
ATOM   4805  CD  GLU C  92      20.572  40.019 101.962  1.00 66.46           C  
ATOM   4806  OE1 GLU C  92      20.924  41.081 102.525  1.00 68.77           O  
ATOM   4807  OE2 GLU C  92      20.809  38.874 102.427  1.00 68.03           O  
ATOM   4808  N   ILE C  93      19.697  39.183  97.044  1.00 47.50           N  
ATOM   4809  CA  ILE C  93      20.150  39.885  95.854  1.00 45.11           C  
ATOM   4810  C   ILE C  93      19.067  40.040  94.783  1.00 46.06           C  
ATOM   4811  O   ILE C  93      18.982  41.069  94.102  1.00 45.34           O  
ATOM   4812  CB  ILE C  93      21.345  39.153  95.251  1.00 42.72           C  
ATOM   4813  CG1 ILE C  93      22.472  39.104  96.283  1.00 40.09           C  
ATOM   4814  CG2 ILE C  93      21.772  39.827  93.954  1.00 41.14           C  
ATOM   4815  CD1 ILE C  93      23.636  38.229  95.893  1.00 40.09           C  
ATOM   4816  N   LEU C  94      18.244  39.010  94.631  1.00 46.74           N  
ATOM   4817  CA  LEU C  94      17.175  39.033  93.649  1.00 46.65           C  
ATOM   4818  C   LEU C  94      16.288  40.256  93.853  1.00 46.75           C  
ATOM   4819  O   LEU C  94      16.030  41.001  92.909  1.00 47.39           O  
ATOM   4820  CB  LEU C  94      16.352  37.749  93.748  1.00 47.25           C  
ATOM   4821  CG  LEU C  94      15.192  37.577  92.763  1.00 48.28           C  
ATOM   4822  CD1 LEU C  94      15.656  37.812  91.332  1.00 48.44           C  
ATOM   4823  CD2 LEU C  94      14.632  36.178  92.918  1.00 47.51           C  
ATOM   4824  N   PHE C  95      15.827  40.465  95.084  1.00 46.19           N  
ATOM   4825  CA  PHE C  95      14.985  41.623  95.397  1.00 46.08           C  
ATOM   4826  C   PHE C  95      15.701  42.923  95.062  1.00 45.19           C  
ATOM   4827  O   PHE C  95      15.090  43.887  94.588  1.00 44.66           O  
ATOM   4828  CB  PHE C  95      14.633  41.640  96.881  1.00 47.16           C  
ATOM   4829  CG  PHE C  95      13.553  40.685  97.249  1.00 50.71           C  
ATOM   4830  CD1 PHE C  95      12.221  41.040  97.103  1.00 51.59           C  
ATOM   4831  CD2 PHE C  95      13.862  39.408  97.703  1.00 52.39           C  
ATOM   4832  CE1 PHE C  95      11.205  40.133  97.402  1.00 52.81           C  
ATOM   4833  CE2 PHE C  95      12.852  38.490  98.006  1.00 52.27           C  
ATOM   4834  CZ  PHE C  95      11.522  38.854  97.853  1.00 52.66           C  
ATOM   4835  N   ALA C  96      17.004  42.932  95.314  1.00 43.76           N  
ATOM   4836  CA  ALA C  96      17.836  44.102  95.102  1.00 41.92           C  
ATOM   4837  C   ALA C  96      17.970  44.568  93.665  1.00 41.41           C  
ATOM   4838  O   ALA C  96      18.033  45.770  93.409  1.00 41.37           O  
ATOM   4839  CB  ALA C  96      19.214  43.853  95.684  1.00 42.20           C  
ATOM   4840  N   ILE C  97      18.010  43.632  92.724  1.00 40.34           N  
ATOM   4841  CA  ILE C  97      18.187  44.024  91.334  1.00 39.36           C  
ATOM   4842  C   ILE C  97      16.969  43.938  90.423  1.00 40.53           C  
ATOM   4843  O   ILE C  97      17.046  44.328  89.259  1.00 41.11           O  
ATOM   4844  CB  ILE C  97      19.311  43.217  90.695  1.00 37.27           C  
ATOM   4845  CG1 ILE C  97      18.858  41.779  90.476  1.00 36.46           C  
ATOM   4846  CG2 ILE C  97      20.524  43.240  91.596  1.00 35.74           C  
ATOM   4847  CD1 ILE C  97      19.803  40.989  89.630  1.00 36.77           C  
ATOM   4848  N   LEU C  98      15.849  43.432  90.938  1.00 40.73           N  
ATOM   4849  CA  LEU C  98      14.647  43.314  90.124  1.00 40.26           C  
ATOM   4850  C   LEU C  98      14.221  44.634  89.483  1.00 41.06           C  
ATOM   4851  O   LEU C  98      13.840  44.664  88.313  1.00 42.91           O  
ATOM   4852  CB  LEU C  98      13.494  42.738  90.949  1.00 39.82           C  
ATOM   4853  CG  LEU C  98      13.416  41.208  90.972  1.00 40.47           C  
ATOM   4854  CD1 LEU C  98      12.326  40.744  91.929  1.00 40.41           C  
ATOM   4855  CD2 LEU C  98      13.143  40.707  89.563  1.00 39.78           C  
ATOM   4856  N   PRO C  99      14.290  45.748  90.230  1.00 40.68           N  
ATOM   4857  CA  PRO C  99      13.879  47.015  89.618  1.00 40.17           C  
ATOM   4858  C   PRO C  99      14.591  47.311  88.310  1.00 39.54           C  
ATOM   4859  O   PRO C  99      14.038  47.940  87.416  1.00 39.49           O  
ATOM   4860  CB  PRO C  99      14.203  48.037  90.700  1.00 39.53           C  
ATOM   4861  CG  PRO C  99      13.932  47.273  91.957  1.00 39.70           C  
ATOM   4862  CD  PRO C  99      14.581  45.928  91.664  1.00 40.52           C  
ATOM   4863  N   ARG C 100      15.817  46.833  88.186  1.00 40.12           N  
ATOM   4864  CA  ARG C 100      16.580  47.087  86.980  1.00 43.14           C  
ATOM   4865  C   ARG C 100      16.147  46.290  85.753  1.00 43.08           C  
ATOM   4866  O   ARG C 100      16.571  46.587  84.631  1.00 42.39           O  
ATOM   4867  CB  ARG C 100      18.054  46.846  87.253  1.00 46.14           C  
ATOM   4868  CG  ARG C 100      18.914  48.070  87.043  1.00 49.82           C  
ATOM   4869  CD  ARG C 100      20.313  47.759  87.481  1.00 52.49           C  
ATOM   4870  NE  ARG C 100      20.351  47.516  88.914  1.00 53.24           N  
ATOM   4871  CZ  ARG C 100      21.342  46.883  89.523  1.00 55.31           C  
ATOM   4872  NH1 ARG C 100      22.370  46.428  88.811  1.00 55.63           N  
ATOM   4873  NH2 ARG C 100      21.304  46.711  90.838  1.00 56.57           N  
ATOM   4874  N   TYR C 101      15.311  45.277  85.958  1.00 42.62           N  
ATOM   4875  CA  TYR C 101      14.833  44.462  84.848  1.00 41.49           C  
ATOM   4876  C   TYR C 101      13.315  44.489  84.807  1.00 41.28           C  
ATOM   4877  O   TYR C 101      12.672  43.447  84.753  1.00 42.00           O  
ATOM   4878  CB  TYR C 101      15.330  43.023  84.993  1.00 41.13           C  
ATOM   4879  CG  TYR C 101      16.840  42.902  84.984  1.00 41.89           C  
ATOM   4880  CD1 TYR C 101      17.586  43.068  86.155  1.00 41.53           C  
ATOM   4881  CD2 TYR C 101      17.525  42.650  83.799  1.00 41.94           C  
ATOM   4882  CE1 TYR C 101      18.975  42.981  86.141  1.00 41.26           C  
ATOM   4883  CE2 TYR C 101      18.912  42.568  83.774  1.00 42.27           C  
ATOM   4884  CZ  TYR C 101      19.631  42.733  84.944  1.00 42.37           C  
ATOM   4885  OH  TYR C 101      21.005  42.664  84.899  1.00 42.47           O  
ATOM   4886  N   ALA C 102      12.751  45.694  84.823  1.00 40.59           N  
ATOM   4887  CA  ALA C 102      11.306  45.863  84.814  1.00 39.97           C  
ATOM   4888  C   ALA C 102      10.827  46.870  83.783  1.00 40.13           C  
ATOM   4889  O   ALA C 102       9.828  47.549  83.988  1.00 40.11           O  
ATOM   4890  CB  ALA C 102      10.832  46.276  86.196  1.00 38.45           C  
ATOM   4891  N   SER C 103      11.531  46.967  82.667  1.00 41.04           N  
ATOM   4892  CA  SER C 103      11.130  47.904  81.629  1.00 43.14           C  
ATOM   4893  C   SER C 103      10.464  47.224  80.452  1.00 43.09           C  
ATOM   4894  O   SER C 103      10.958  46.231  79.927  1.00 43.62           O  
ATOM   4895  CB  SER C 103      12.331  48.697  81.121  1.00 45.39           C  
ATOM   4896  OG  SER C 103      12.672  49.724  82.032  1.00 50.24           O  
ATOM   4897  N   PRO C 104       9.329  47.764  80.018  1.00 42.90           N  
ATOM   4898  CA  PRO C 104       8.570  47.229  78.887  1.00 43.55           C  
ATOM   4899  C   PRO C 104       9.501  46.848  77.740  1.00 44.03           C  
ATOM   4900  O   PRO C 104      10.406  47.600  77.405  1.00 43.44           O  
ATOM   4901  CB  PRO C 104       7.645  48.380  78.537  1.00 44.43           C  
ATOM   4902  CG  PRO C 104       7.344  48.953  79.899  1.00 44.42           C  
ATOM   4903  CD  PRO C 104       8.699  48.979  80.560  1.00 42.46           C  
ATOM   4904  N   ILE C 105       9.269  45.682  77.141  1.00 45.84           N  
ATOM   4905  CA  ILE C 105      10.106  45.185  76.052  1.00 47.87           C  
ATOM   4906  C   ILE C 105      10.034  45.977  74.749  1.00 52.18           C  
ATOM   4907  O   ILE C 105      10.627  45.580  73.746  1.00 54.59           O  
ATOM   4908  CB  ILE C 105       9.817  43.678  75.788  1.00 45.20           C  
ATOM   4909  CG1 ILE C 105      10.403  42.843  76.928  1.00 44.30           C  
ATOM   4910  CG2 ILE C 105      10.439  43.213  74.489  1.00 42.82           C  
ATOM   4911  CD1 ILE C 105      10.220  41.340  76.775  1.00 42.50           C  
ATOM   4912  N   ASN C 106       9.326  47.099  74.743  1.00 55.29           N  
ATOM   4913  CA  ASN C 106       9.275  47.910  73.525  1.00 59.29           C  
ATOM   4914  C   ASN C 106       8.458  47.293  72.397  1.00 58.43           C  
ATOM   4915  O   ASN C 106       8.813  46.242  71.848  1.00 56.77           O  
ATOM   4916  CB  ASN C 106      10.701  48.190  73.030  1.00 64.83           C  
ATOM   4917  CG  ASN C 106      10.724  48.890  71.683  1.00 70.57           C  
ATOM   4918  OD1 ASN C 106      10.177  49.989  71.528  1.00 73.75           O  
ATOM   4919  ND2 ASN C 106      11.357  48.253  70.697  1.00 73.09           N  
ATOM   4920  N   GLY C 107       7.391  48.007  72.038  1.00 58.49           N  
ATOM   4921  CA  GLY C 107       6.409  47.612  71.028  1.00 58.50           C  
ATOM   4922  C   GLY C 107       5.240  47.200  71.899  1.00 58.16           C  
ATOM   4923  O   GLY C 107       4.080  47.289  71.510  1.00 58.78           O  
ATOM   4924  N   VAL C 108       5.585  46.755  73.102  1.00 57.67           N  
ATOM   4925  CA  VAL C 108       4.613  46.322  74.082  1.00 57.27           C  
ATOM   4926  C   VAL C 108       3.623  47.438  74.407  1.00 58.14           C  
ATOM   4927  O   VAL C 108       2.502  47.448  73.894  1.00 57.39           O  
ATOM   4928  CB  VAL C 108       5.320  45.864  75.374  1.00 56.53           C  
ATOM   4929  CG1 VAL C 108       4.296  45.603  76.475  1.00 54.75           C  
ATOM   4930  CG2 VAL C 108       6.130  44.612  75.092  1.00 54.54           C  
ATOM   4931  N   LYS C 109       4.043  48.383  75.244  1.00 59.12           N  
ATOM   4932  CA  LYS C 109       3.173  49.484  75.645  1.00 60.26           C  
ATOM   4933  C   LYS C 109       2.376  50.097  74.497  1.00 60.91           C  
ATOM   4934  O   LYS C 109       1.357  50.750  74.719  1.00 60.51           O  
ATOM   4935  CB  LYS C 109       3.988  50.574  76.341  1.00 60.10           C  
ATOM   4936  CG  LYS C 109       5.194  51.051  75.558  1.00 61.27           C  
ATOM   4937  CD  LYS C 109       5.761  52.332  76.167  1.00 62.49           C  
ATOM   4938  CE  LYS C 109       6.024  52.192  77.669  1.00 61.96           C  
ATOM   4939  NZ  LYS C 109       6.553  53.457  78.255  1.00 61.69           N  
ATOM   4940  N   GLU C 110       2.832  49.872  73.271  1.00 61.82           N  
ATOM   4941  CA  GLU C 110       2.155  50.416  72.104  1.00 62.71           C  
ATOM   4942  C   GLU C 110       1.011  49.542  71.620  1.00 60.92           C  
ATOM   4943  O   GLU C 110       0.023  50.048  71.091  1.00 61.37           O  
ATOM   4944  CB  GLU C 110       3.155  50.627  70.974  1.00 66.15           C  
ATOM   4945  CG  GLU C 110       4.293  51.546  71.359  1.00 72.14           C  
ATOM   4946  CD  GLU C 110       5.263  51.759  70.221  1.00 76.52           C  
ATOM   4947  OE1 GLU C 110       4.843  52.320  69.182  1.00 78.69           O  
ATOM   4948  OE2 GLU C 110       6.444  51.363  70.365  1.00 80.02           O  
ATOM   4949  N   VAL C 111       1.143  48.232  71.778  1.00 58.80           N  
ATOM   4950  CA  VAL C 111       0.073  47.340  71.359  1.00 56.37           C  
ATOM   4951  C   VAL C 111      -0.939  47.291  72.499  1.00 54.70           C  
ATOM   4952  O   VAL C 111      -2.134  47.132  72.273  1.00 53.36           O  
ATOM   4953  CB  VAL C 111       0.590  45.915  71.044  1.00 55.84           C  
ATOM   4954  CG1 VAL C 111       1.646  45.973  69.943  1.00 54.04           C  
ATOM   4955  CG2 VAL C 111       1.152  45.277  72.288  1.00 56.34           C  
ATOM   4956  N   ILE C 112      -0.450  47.440  73.727  1.00 54.04           N  
ATOM   4957  CA  ILE C 112      -1.324  47.441  74.894  1.00 53.79           C  
ATOM   4958  C   ILE C 112      -2.114  48.741  74.815  1.00 55.03           C  
ATOM   4959  O   ILE C 112      -3.238  48.839  75.319  1.00 55.36           O  
ATOM   4960  CB  ILE C 112      -0.525  47.425  76.219  1.00 52.21           C  
ATOM   4961  CG1 ILE C 112       0.335  46.162  76.313  1.00 50.16           C  
ATOM   4962  CG2 ILE C 112      -1.487  47.501  77.399  1.00 51.71           C  
ATOM   4963  CD1 ILE C 112      -0.447  44.887  76.495  1.00 49.05           C  
ATOM   4964  N   ALA C 113      -1.499  49.745  74.192  1.00 56.30           N  
ATOM   4965  CA  ALA C 113      -2.135  51.043  74.008  1.00 57.03           C  
ATOM   4966  C   ALA C 113      -3.335  50.745  73.130  1.00 57.31           C  
ATOM   4967  O   ALA C 113      -4.468  51.069  73.476  1.00 57.62           O  
ATOM   4968  CB  ALA C 113      -1.188  51.997  73.305  1.00 58.02           C  
ATOM   4969  N   SER C 114      -3.070  50.124  71.985  1.00 57.61           N  
ATOM   4970  CA  SER C 114      -4.130  49.711  71.082  1.00 58.57           C  
ATOM   4971  C   SER C 114      -4.760  48.551  71.856  1.00 59.64           C  
ATOM   4972  O   SER C 114      -4.502  48.409  73.053  1.00 61.69           O  
ATOM   4973  CB  SER C 114      -3.538  49.214  69.765  1.00 58.68           C  
ATOM   4974  OG  SER C 114      -4.512  48.537  68.992  1.00 60.86           O  
ATOM   4975  N   LEU C 115      -5.544  47.703  71.199  1.00 58.54           N  
ATOM   4976  CA  LEU C 115      -6.182  46.591  71.910  1.00 57.07           C  
ATOM   4977  C   LEU C 115      -7.085  47.168  72.991  1.00 57.06           C  
ATOM   4978  O   LEU C 115      -8.289  46.908  73.006  1.00 57.23           O  
ATOM   4979  CB  LEU C 115      -5.143  45.656  72.559  1.00 54.07           C  
ATOM   4980  CG  LEU C 115      -4.601  44.463  71.763  1.00 51.99           C  
ATOM   4981  CD1 LEU C 115      -3.657  43.643  72.630  1.00 50.50           C  
ATOM   4982  CD2 LEU C 115      -5.755  43.594  71.295  1.00 51.59           C  
ATOM   4983  N   ARG C 116      -6.497  47.951  73.892  1.00 56.87           N  
ATOM   4984  CA  ARG C 116      -7.243  48.581  74.967  1.00 57.63           C  
ATOM   4985  C   ARG C 116      -8.120  49.693  74.386  1.00 59.17           C  
ATOM   4986  O   ARG C 116      -9.133  50.077  74.976  1.00 59.61           O  
ATOM   4987  CB  ARG C 116      -6.284  49.145  76.014  1.00 55.17           C  
ATOM   4988  CG  ARG C 116      -6.988  49.608  77.274  1.00 55.47           C  
ATOM   4989  CD  ARG C 116      -5.996  50.049  78.332  1.00 55.90           C  
ATOM   4990  NE  ARG C 116      -5.509  48.953  79.164  1.00 54.61           N  
ATOM   4991  CZ  ARG C 116      -4.480  49.065  79.999  1.00 53.82           C  
ATOM   4992  NH1 ARG C 116      -3.834  50.217  80.101  1.00 54.17           N  
ATOM   4993  NH2 ARG C 116      -4.107  48.037  80.745  1.00 52.30           N  
ATOM   4994  N   GLU C 117      -7.727  50.197  73.220  1.00 60.87           N  
ATOM   4995  CA  GLU C 117      -8.483  51.241  72.540  1.00 61.83           C  
ATOM   4996  C   GLU C 117      -9.736  50.603  71.947  1.00 62.35           C  
ATOM   4997  O   GLU C 117     -10.821  51.180  71.999  1.00 63.39           O  
ATOM   4998  CB  GLU C 117      -7.647  51.862  71.419  1.00 62.99           C  
ATOM   4999  CG  GLU C 117      -8.417  52.845  70.545  1.00 65.72           C  
ATOM   5000  CD  GLU C 117      -7.717  53.140  69.220  1.00 67.76           C  
ATOM   5001  OE1 GLU C 117      -8.318  53.833  68.362  1.00 67.17           O  
ATOM   5002  OE2 GLU C 117      -6.567  52.676  69.037  1.00 68.90           O  
ATOM   5003  N   ARG C 118      -9.576  49.406  71.379  1.00 62.54           N  
ATOM   5004  CA  ARG C 118     -10.690  48.679  70.775  1.00 61.35           C  
ATOM   5005  C   ARG C 118     -11.463  47.819  71.775  1.00 59.54           C  
ATOM   5006  O   ARG C 118     -12.155  46.877  71.382  1.00 60.63           O  
ATOM   5007  CB  ARG C 118     -10.202  47.822  69.590  1.00 62.81           C  
ATOM   5008  CG  ARG C 118      -8.727  47.424  69.640  1.00 67.45           C  
ATOM   5009  CD  ARG C 118      -8.200  46.856  68.308  1.00 70.77           C  
ATOM   5010  NE  ARG C 118      -8.652  45.491  68.029  1.00 75.74           N  
ATOM   5011  CZ  ARG C 118      -9.874  45.164  67.607  1.00 78.74           C  
ATOM   5012  NH1 ARG C 118     -10.789  46.103  67.402  1.00 80.71           N  
ATOM   5013  NH2 ARG C 118     -10.186  43.891  67.387  1.00 78.92           N  
ATOM   5014  N   GLY C 119     -11.336  48.149  73.064  1.00 57.11           N  
ATOM   5015  CA  GLY C 119     -12.053  47.444  74.125  1.00 53.87           C  
ATOM   5016  C   GLY C 119     -11.634  46.063  74.623  1.00 51.28           C  
ATOM   5017  O   GLY C 119     -12.461  45.341  75.182  1.00 51.49           O  
ATOM   5018  N   ILE C 120     -10.370  45.686  74.446  1.00 48.08           N  
ATOM   5019  CA  ILE C 120      -9.898  44.384  74.898  1.00 44.51           C  
ATOM   5020  C   ILE C 120      -9.337  44.490  76.309  1.00 44.56           C  
ATOM   5021  O   ILE C 120      -8.566  45.400  76.611  1.00 45.46           O  
ATOM   5022  CB  ILE C 120      -8.778  43.850  73.987  1.00 43.11           C  
ATOM   5023  CG1 ILE C 120      -9.252  43.822  72.532  1.00 43.93           C  
ATOM   5024  CG2 ILE C 120      -8.355  42.469  74.440  1.00 41.15           C  
ATOM   5025  CD1 ILE C 120     -10.444  42.928  72.271  1.00 44.18           C  
ATOM   5026  N   LYS C 121      -9.724  43.565  77.181  1.00 43.55           N  
ATOM   5027  CA  LYS C 121      -9.221  43.572  78.551  1.00 42.99           C  
ATOM   5028  C   LYS C 121      -7.886  42.818  78.614  1.00 42.00           C  
ATOM   5029  O   LYS C 121      -7.689  41.817  77.913  1.00 41.47           O  
ATOM   5030  CB  LYS C 121     -10.252  42.938  79.486  1.00 43.73           C  
ATOM   5031  CG  LYS C 121     -11.530  43.756  79.578  1.00 45.35           C  
ATOM   5032  CD  LYS C 121     -12.653  43.009  80.271  1.00 46.55           C  
ATOM   5033  CE  LYS C 121     -13.958  43.796  80.199  1.00 45.90           C  
ATOM   5034  NZ  LYS C 121     -15.105  42.965  80.664  1.00 47.05           N  
ATOM   5035  N   ILE C 122      -6.964  43.310  79.442  1.00 39.95           N  
ATOM   5036  CA  ILE C 122      -5.652  42.686  79.570  1.00 38.58           C  
ATOM   5037  C   ILE C 122      -5.345  42.163  80.975  1.00 36.46           C  
ATOM   5038  O   ILE C 122      -5.283  42.927  81.933  1.00 35.80           O  
ATOM   5039  CB  ILE C 122      -4.509  43.665  79.134  1.00 39.46           C  
ATOM   5040  CG1 ILE C 122      -4.843  45.094  79.547  1.00 41.08           C  
ATOM   5041  CG2 ILE C 122      -4.323  43.630  77.618  1.00 40.11           C  
ATOM   5042  CD1 ILE C 122      -5.798  45.814  78.591  1.00 43.06           C  
ATOM   5043  N   GLY C 123      -5.165  40.848  81.080  1.00 34.07           N  
ATOM   5044  CA  GLY C 123      -4.846  40.226  82.351  1.00 31.34           C  
ATOM   5045  C   GLY C 123      -3.450  39.634  82.256  1.00 30.01           C  
ATOM   5046  O   GLY C 123      -2.735  39.905  81.290  1.00 29.68           O  
ATOM   5047  N   SER C 124      -3.053  38.815  83.225  1.00 28.17           N  
ATOM   5048  CA  SER C 124      -1.720  38.232  83.189  1.00 27.62           C  
ATOM   5049  C   SER C 124      -1.472  37.210  84.292  1.00 27.72           C  
ATOM   5050  O   SER C 124      -2.215  37.141  85.258  1.00 28.94           O  
ATOM   5051  CB  SER C 124      -0.669  39.346  83.294  1.00 28.94           C  
ATOM   5052  OG  SER C 124      -0.848  40.145  84.459  1.00 27.52           O  
ATOM   5053  N   THR C 125      -0.423  36.406  84.125  1.00 27.83           N  
ATOM   5054  CA  THR C 125      -0.032  35.407  85.116  1.00 28.11           C  
ATOM   5055  C   THR C 125       1.498  35.455  85.205  1.00 29.36           C  
ATOM   5056  O   THR C 125       2.151  36.176  84.434  1.00 28.61           O  
ATOM   5057  CB  THR C 125      -0.523  33.947  84.752  1.00 28.49           C  
ATOM   5058  OG1 THR C 125       0.259  33.393  83.688  1.00 26.90           O  
ATOM   5059  CG2 THR C 125      -1.980  33.964  84.333  1.00 27.27           C  
ATOM   5060  N   THR C 126       2.073  34.708  86.142  1.00 29.77           N  
ATOM   5061  CA  THR C 126       3.523  34.716  86.310  1.00 29.85           C  
ATOM   5062  C   THR C 126       4.012  33.580  87.174  1.00 29.13           C  
ATOM   5063  O   THR C 126       3.235  32.959  87.886  1.00 28.23           O  
ATOM   5064  CB  THR C 126       4.007  36.046  86.955  1.00 30.67           C  
ATOM   5065  OG1 THR C 126       5.372  35.909  87.366  1.00 31.39           O  
ATOM   5066  CG2 THR C 126       3.170  36.393  88.170  1.00 30.37           C  
ATOM   5067  N   GLY C 127       5.311  33.321  87.097  1.00 29.46           N  
ATOM   5068  CA  GLY C 127       5.911  32.280  87.901  1.00 31.68           C  
ATOM   5069  C   GLY C 127       6.454  32.920  89.160  1.00 33.59           C  
ATOM   5070  O   GLY C 127       6.783  32.240  90.128  1.00 34.03           O  
ATOM   5071  N   TYR C 128       6.542  34.246  89.137  1.00 36.64           N  
ATOM   5072  CA  TYR C 128       7.039  35.032  90.266  1.00 40.20           C  
ATOM   5073  C   TYR C 128       6.107  34.956  91.472  1.00 42.52           C  
ATOM   5074  O   TYR C 128       4.892  34.796  91.329  1.00 43.93           O  
ATOM   5075  CB  TYR C 128       7.205  36.506  89.853  1.00 40.27           C  
ATOM   5076  CG  TYR C 128       8.438  36.809  89.011  1.00 41.77           C  
ATOM   5077  CD1 TYR C 128       8.529  37.996  88.272  1.00 41.70           C  
ATOM   5078  CD2 TYR C 128       9.525  35.934  88.978  1.00 41.51           C  
ATOM   5079  CE1 TYR C 128       9.667  38.301  87.531  1.00 39.49           C  
ATOM   5080  CE2 TYR C 128      10.667  36.234  88.241  1.00 41.00           C  
ATOM   5081  CZ  TYR C 128      10.730  37.418  87.524  1.00 40.50           C  
ATOM   5082  OH  TYR C 128      11.871  37.719  86.817  1.00 40.91           O  
ATOM   5083  N   THR C 129       6.682  35.078  92.664  1.00 44.63           N  
ATOM   5084  CA  THR C 129       5.903  35.052  93.893  1.00 46.82           C  
ATOM   5085  C   THR C 129       5.240  36.411  94.080  1.00 48.62           C  
ATOM   5086  O   THR C 129       5.498  37.351  93.325  1.00 48.36           O  
ATOM   5087  CB  THR C 129       6.794  34.773  95.107  1.00 46.90           C  
ATOM   5088  OG1 THR C 129       7.679  35.883  95.316  1.00 49.56           O  
ATOM   5089  CG2 THR C 129       7.615  33.518  94.879  1.00 46.51           C  
ATOM   5090  N   ARG C 130       4.383  36.522  95.086  1.00 51.73           N  
ATOM   5091  CA  ARG C 130       3.702  37.782  95.328  1.00 55.67           C  
ATOM   5092  C   ARG C 130       4.691  38.897  95.654  1.00 56.56           C  
ATOM   5093  O   ARG C 130       4.585  40.014  95.135  1.00 56.44           O  
ATOM   5094  CB  ARG C 130       2.715  37.651  96.481  1.00 57.48           C  
ATOM   5095  CG  ARG C 130       1.936  38.924  96.714  1.00 62.56           C  
ATOM   5096  CD  ARG C 130       0.751  38.986  95.783  1.00 68.18           C  
ATOM   5097  NE  ARG C 130      -0.118  37.838  96.027  1.00 75.23           N  
ATOM   5098  CZ  ARG C 130      -0.594  37.507  97.230  1.00 78.30           C  
ATOM   5099  NH1 ARG C 130      -0.287  38.239  98.295  1.00 80.08           N  
ATOM   5100  NH2 ARG C 130      -1.366  36.434  97.377  1.00 79.32           N  
ATOM   5101  N   GLU C 131       5.644  38.587  96.529  1.00 57.28           N  
ATOM   5102  CA  GLU C 131       6.650  39.557  96.950  1.00 57.71           C  
ATOM   5103  C   GLU C 131       7.321  40.160  95.729  1.00 54.78           C  
ATOM   5104  O   GLU C 131       7.163  41.345  95.430  1.00 55.80           O  
ATOM   5105  CB  GLU C 131       7.719  38.883  97.812  1.00 62.59           C  
ATOM   5106  CG  GLU C 131       7.187  38.018  98.938  1.00 69.49           C  
ATOM   5107  CD  GLU C 131       8.309  37.420  99.776  1.00 74.33           C  
ATOM   5108  OE1 GLU C 131       8.947  38.170 100.555  1.00 76.54           O  
ATOM   5109  OE2 GLU C 131       8.558  36.201  99.644  1.00 76.63           O  
ATOM   5110  N   MET C 132       8.077  39.325  95.032  1.00 50.03           N  
ATOM   5111  CA  MET C 132       8.785  39.742  93.847  1.00 46.47           C  
ATOM   5112  C   MET C 132       7.944  40.665  92.978  1.00 46.18           C  
ATOM   5113  O   MET C 132       8.400  41.731  92.561  1.00 45.75           O  
ATOM   5114  CB  MET C 132       9.176  38.510  93.065  1.00 43.76           C  
ATOM   5115  CG  MET C 132       9.851  37.496  93.927  1.00 42.97           C  
ATOM   5116  SD  MET C 132      10.305  36.059  92.990  1.00 45.44           S  
ATOM   5117  CE  MET C 132      11.298  36.817  91.684  1.00 46.54           C  
ATOM   5118  N   MET C 133       6.706  40.248  92.726  1.00 46.21           N  
ATOM   5119  CA  MET C 133       5.782  41.001  91.885  1.00 45.25           C  
ATOM   5120  C   MET C 133       5.376  42.391  92.360  1.00 45.31           C  
ATOM   5121  O   MET C 133       5.025  43.234  91.536  1.00 44.40           O  
ATOM   5122  CB  MET C 133       4.533  40.160  91.615  1.00 44.17           C  
ATOM   5123  CG  MET C 133       4.757  39.074  90.572  1.00 44.15           C  
ATOM   5124  SD  MET C 133       5.391  39.736  88.988  1.00 42.41           S  
ATOM   5125  CE  MET C 133       4.019  40.729  88.448  1.00 40.10           C  
ATOM   5126  N   ASP C 134       5.405  42.642  93.667  1.00 45.84           N  
ATOM   5127  CA  ASP C 134       5.051  43.969  94.158  1.00 48.35           C  
ATOM   5128  C   ASP C 134       6.084  44.947  93.622  1.00 49.05           C  
ATOM   5129  O   ASP C 134       5.750  46.046  93.148  1.00 49.33           O  
ATOM   5130  CB  ASP C 134       5.066  44.008  95.681  1.00 52.12           C  
ATOM   5131  CG  ASP C 134       3.804  43.426  96.291  1.00 56.93           C  
ATOM   5132  OD1 ASP C 134       3.827  43.102  97.503  1.00 58.79           O  
ATOM   5133  OD2 ASP C 134       2.789  43.302  95.564  1.00 58.56           O  
ATOM   5134  N   ILE C 135       7.344  44.522  93.695  1.00 47.59           N  
ATOM   5135  CA  ILE C 135       8.474  45.311  93.220  1.00 45.28           C  
ATOM   5136  C   ILE C 135       8.408  45.521  91.706  1.00 44.78           C  
ATOM   5137  O   ILE C 135       8.427  46.657  91.229  1.00 44.97           O  
ATOM   5138  CB  ILE C 135       9.793  44.603  93.549  1.00 44.46           C  
ATOM   5139  CG1 ILE C 135       9.857  44.307  95.047  1.00 41.90           C  
ATOM   5140  CG2 ILE C 135      10.973  45.453  93.096  1.00 43.18           C  
ATOM   5141  CD1 ILE C 135      11.012  43.431  95.430  1.00 40.34           C  
ATOM   5142  N   VAL C 136       8.324  44.419  90.964  1.00 43.41           N  
ATOM   5143  CA  VAL C 136       8.271  44.456  89.505  1.00 43.64           C  
ATOM   5144  C   VAL C 136       7.097  45.251  88.934  1.00 45.44           C  
ATOM   5145  O   VAL C 136       7.261  46.048  88.005  1.00 44.00           O  
ATOM   5146  CB  VAL C 136       8.219  43.033  88.930  1.00 43.00           C  
ATOM   5147  CG1 VAL C 136       8.130  43.089  87.419  1.00 42.68           C  
ATOM   5148  CG2 VAL C 136       9.451  42.253  89.360  1.00 42.95           C  
ATOM   5149  N   ALA C 137       5.911  45.025  89.487  1.00 48.29           N  
ATOM   5150  CA  ALA C 137       4.706  45.708  89.034  1.00 50.02           C  
ATOM   5151  C   ALA C 137       4.816  47.220  89.191  1.00 51.84           C  
ATOM   5152  O   ALA C 137       4.395  47.969  88.304  1.00 51.53           O  
ATOM   5153  CB  ALA C 137       3.504  45.190  89.802  1.00 49.10           C  
ATOM   5154  N   LYS C 138       5.379  47.665  90.313  1.00 53.97           N  
ATOM   5155  CA  LYS C 138       5.533  49.098  90.576  1.00 56.35           C  
ATOM   5156  C   LYS C 138       6.479  49.783  89.591  1.00 56.31           C  
ATOM   5157  O   LYS C 138       6.177  50.861  89.076  1.00 56.25           O  
ATOM   5158  CB  LYS C 138       6.019  49.333  92.011  1.00 59.00           C  
ATOM   5159  CG  LYS C 138       5.006  48.941  93.076  1.00 63.27           C  
ATOM   5160  CD  LYS C 138       5.529  49.190  94.489  1.00 66.54           C  
ATOM   5161  CE  LYS C 138       4.513  48.709  95.537  1.00 70.06           C  
ATOM   5162  NZ  LYS C 138       4.980  48.844  96.956  1.00 70.78           N  
ATOM   5163  N   GLU C 139       7.625  49.162  89.331  1.00 55.82           N  
ATOM   5164  CA  GLU C 139       8.583  49.736  88.402  1.00 55.45           C  
ATOM   5165  C   GLU C 139       8.013  49.723  86.997  1.00 55.61           C  
ATOM   5166  O   GLU C 139       8.102  50.717  86.267  1.00 55.77           O  
ATOM   5167  CB  GLU C 139       9.890  48.948  88.438  1.00 55.72           C  
ATOM   5168  CG  GLU C 139      10.578  49.035  89.775  1.00 58.44           C  
ATOM   5169  CD  GLU C 139      10.876  50.472  90.175  1.00 60.02           C  
ATOM   5170  OE1 GLU C 139      10.964  50.743  91.393  1.00 61.14           O  
ATOM   5171  OE2 GLU C 139      11.027  51.328  89.275  1.00 59.52           O  
ATOM   5172  N   ALA C 140       7.418  48.593  86.624  1.00 55.14           N  
ATOM   5173  CA  ALA C 140       6.835  48.444  85.300  1.00 53.96           C  
ATOM   5174  C   ALA C 140       5.705  49.438  85.102  1.00 53.25           C  
ATOM   5175  O   ALA C 140       5.566  50.026  84.026  1.00 51.74           O  
ATOM   5176  CB  ALA C 140       6.324  47.026  85.115  1.00 53.68           C  
ATOM   5177  N   ALA C 141       4.900  49.625  86.144  1.00 53.07           N  
ATOM   5178  CA  ALA C 141       3.773  50.546  86.072  1.00 54.61           C  
ATOM   5179  C   ALA C 141       4.291  51.951  85.819  1.00 55.71           C  
ATOM   5180  O   ALA C 141       3.925  52.614  84.837  1.00 56.02           O  
ATOM   5181  CB  ALA C 141       2.980  50.505  87.369  1.00 53.68           C  
ATOM   5182  N   LEU C 142       5.157  52.387  86.726  1.00 56.09           N  
ATOM   5183  CA  LEU C 142       5.784  53.699  86.685  1.00 54.69           C  
ATOM   5184  C   LEU C 142       6.696  53.851  85.460  1.00 54.07           C  
ATOM   5185  O   LEU C 142       7.671  54.594  85.496  1.00 54.04           O  
ATOM   5186  CB  LEU C 142       6.584  53.878  87.972  1.00 53.49           C  
ATOM   5187  CG  LEU C 142       7.404  55.138  88.183  1.00 53.83           C  
ATOM   5188  CD1 LEU C 142       6.497  56.331  88.440  1.00 53.76           C  
ATOM   5189  CD2 LEU C 142       8.335  54.898  89.354  1.00 54.46           C  
ATOM   5190  N   GLN C 143       6.373  53.147  84.377  1.00 53.83           N  
ATOM   5191  CA  GLN C 143       7.174  53.202  83.156  1.00 53.02           C  
ATOM   5192  C   GLN C 143       6.412  52.913  81.872  1.00 52.78           C  
ATOM   5193  O   GLN C 143       7.028  52.665  80.833  1.00 52.51           O  
ATOM   5194  CB  GLN C 143       8.342  52.226  83.225  1.00 52.54           C  
ATOM   5195  CG  GLN C 143       9.551  52.731  83.964  1.00 51.89           C  
ATOM   5196  CD  GLN C 143      10.800  52.009  83.518  1.00 51.62           C  
ATOM   5197  OE1 GLN C 143      11.183  52.073  82.345  1.00 51.40           O  
ATOM   5198  NE2 GLN C 143      11.439  51.306  84.446  1.00 50.17           N  
ATOM   5199  N   GLY C 144       5.087  52.911  81.934  1.00 52.69           N  
ATOM   5200  CA  GLY C 144       4.320  52.672  80.726  1.00 52.20           C  
ATOM   5201  C   GLY C 144       3.581  51.355  80.587  1.00 52.00           C  
ATOM   5202  O   GLY C 144       2.944  51.138  79.553  1.00 53.16           O  
ATOM   5203  N   TYR C 145       3.663  50.476  81.589  1.00 50.14           N  
ATOM   5204  CA  TYR C 145       2.954  49.197  81.522  1.00 48.29           C  
ATOM   5205  C   TYR C 145       2.233  48.851  82.810  1.00 47.28           C  
ATOM   5206  O   TYR C 145       2.811  48.882  83.889  1.00 46.37           O  
ATOM   5207  CB  TYR C 145       3.898  48.048  81.173  1.00 47.91           C  
ATOM   5208  CG  TYR C 145       3.201  46.695  81.096  1.00 47.10           C  
ATOM   5209  CD1 TYR C 145       2.293  46.404  80.068  1.00 45.78           C  
ATOM   5210  CD2 TYR C 145       3.455  45.703  82.046  1.00 46.14           C  
ATOM   5211  CE1 TYR C 145       1.661  45.153  79.991  1.00 45.79           C  
ATOM   5212  CE2 TYR C 145       2.831  44.459  81.979  1.00 46.94           C  
ATOM   5213  CZ  TYR C 145       1.936  44.184  80.948  1.00 46.41           C  
ATOM   5214  OH  TYR C 145       1.344  42.935  80.893  1.00 43.83           O  
ATOM   5215  N   LYS C 146       0.963  48.495  82.679  1.00 47.19           N  
ATOM   5216  CA  LYS C 146       0.148  48.136  83.831  1.00 47.06           C  
ATOM   5217  C   LYS C 146      -1.109  47.404  83.338  1.00 46.23           C  
ATOM   5218  O   LYS C 146      -1.995  48.008  82.733  1.00 47.35           O  
ATOM   5219  CB  LYS C 146      -0.220  49.411  84.598  1.00 46.35           C  
ATOM   5220  CG  LYS C 146      -1.127  49.211  85.788  1.00 46.30           C  
ATOM   5221  CD  LYS C 146      -1.599  50.558  86.302  1.00 46.33           C  
ATOM   5222  CE  LYS C 146      -2.707  50.406  87.320  1.00 46.63           C  
ATOM   5223  NZ  LYS C 146      -2.245  49.678  88.525  1.00 47.46           N  
ATOM   5224  N   PRO C 147      -1.183  46.083  83.569  1.00 44.91           N  
ATOM   5225  CA  PRO C 147      -2.338  45.292  83.140  1.00 44.62           C  
ATOM   5226  C   PRO C 147      -3.601  45.560  83.969  1.00 44.32           C  
ATOM   5227  O   PRO C 147      -3.520  46.095  85.076  1.00 44.85           O  
ATOM   5228  CB  PRO C 147      -1.835  43.855  83.291  1.00 44.86           C  
ATOM   5229  CG  PRO C 147      -0.934  43.949  84.470  1.00 44.21           C  
ATOM   5230  CD  PRO C 147      -0.151  45.212  84.161  1.00 44.54           C  
ATOM   5231  N   ASP C 148      -4.761  45.194  83.424  1.00 42.65           N  
ATOM   5232  CA  ASP C 148      -6.034  45.372  84.114  1.00 40.58           C  
ATOM   5233  C   ASP C 148      -6.085  44.471  85.353  1.00 39.94           C  
ATOM   5234  O   ASP C 148      -6.733  44.802  86.347  1.00 40.53           O  
ATOM   5235  CB  ASP C 148      -7.192  45.020  83.179  1.00 41.44           C  
ATOM   5236  CG  ASP C 148      -7.368  46.027  82.057  1.00 43.82           C  
ATOM   5237  OD1 ASP C 148      -7.948  45.670  81.002  1.00 43.72           O  
ATOM   5238  OD2 ASP C 148      -6.936  47.185  82.235  1.00 46.81           O  
ATOM   5239  N   PHE C 149      -5.401  43.331  85.297  1.00 38.06           N  
ATOM   5240  CA  PHE C 149      -5.393  42.413  86.423  1.00 36.32           C  
ATOM   5241  C   PHE C 149      -4.075  41.642  86.545  1.00 35.54           C  
ATOM   5242  O   PHE C 149      -3.278  41.613  85.608  1.00 36.41           O  
ATOM   5243  CB  PHE C 149      -6.565  41.444  86.308  1.00 37.74           C  
ATOM   5244  CG  PHE C 149      -6.855  40.714  87.575  1.00 38.75           C  
ATOM   5245  CD1 PHE C 149      -7.140  41.419  88.739  1.00 38.45           C  
ATOM   5246  CD2 PHE C 149      -6.805  39.325  87.623  1.00 39.53           C  
ATOM   5247  CE1 PHE C 149      -7.368  40.752  89.939  1.00 38.31           C  
ATOM   5248  CE2 PHE C 149      -7.032  38.651  88.822  1.00 40.50           C  
ATOM   5249  CZ  PHE C 149      -7.313  39.368  89.985  1.00 38.92           C  
ATOM   5250  N   LEU C 150      -3.858  41.014  87.700  1.00 33.24           N  
ATOM   5251  CA  LEU C 150      -2.618  40.285  87.965  1.00 32.44           C  
ATOM   5252  C   LEU C 150      -2.852  39.104  88.907  1.00 31.76           C  
ATOM   5253  O   LEU C 150      -3.545  39.246  89.910  1.00 33.55           O  
ATOM   5254  CB  LEU C 150      -1.619  41.262  88.602  1.00 34.37           C  
ATOM   5255  CG  LEU C 150      -0.175  40.954  89.020  1.00 35.23           C  
ATOM   5256  CD1 LEU C 150       0.415  42.233  89.584  1.00 35.41           C  
ATOM   5257  CD2 LEU C 150      -0.096  39.856  90.063  1.00 34.99           C  
ATOM   5258  N   VAL C 151      -2.269  37.947  88.600  1.00 29.51           N  
ATOM   5259  CA  VAL C 151      -2.427  36.766  89.454  1.00 29.47           C  
ATOM   5260  C   VAL C 151      -1.087  36.037  89.617  1.00 30.51           C  
ATOM   5261  O   VAL C 151      -0.292  35.997  88.682  1.00 31.32           O  
ATOM   5262  CB  VAL C 151      -3.461  35.775  88.858  1.00 28.80           C  
ATOM   5263  CG1 VAL C 151      -3.729  34.646  89.838  1.00 27.11           C  
ATOM   5264  CG2 VAL C 151      -4.751  36.502  88.523  1.00 27.32           C  
ATOM   5265  N   THR C 152      -0.841  35.460  90.796  1.00 30.90           N  
ATOM   5266  CA  THR C 152       0.418  34.745  91.061  1.00 33.01           C  
ATOM   5267  C   THR C 152       0.202  33.318  91.586  1.00 33.71           C  
ATOM   5268  O   THR C 152      -0.897  32.964  91.994  1.00 35.79           O  
ATOM   5269  CB  THR C 152       1.292  35.518  92.088  1.00 34.00           C  
ATOM   5270  OG1 THR C 152       0.666  35.494  93.380  1.00 34.66           O  
ATOM   5271  CG2 THR C 152       1.471  36.972  91.645  1.00 32.76           C  
ATOM   5272  N   PRO C 153       1.250  32.477  91.586  1.00 34.01           N  
ATOM   5273  CA  PRO C 153       1.084  31.103  92.077  1.00 33.91           C  
ATOM   5274  C   PRO C 153       0.649  31.045  93.537  1.00 35.27           C  
ATOM   5275  O   PRO C 153       0.323  29.983  94.055  1.00 35.05           O  
ATOM   5276  CB  PRO C 153       2.468  30.494  91.876  1.00 30.64           C  
ATOM   5277  CG  PRO C 153       2.996  31.238  90.722  1.00 30.97           C  
ATOM   5278  CD  PRO C 153       2.601  32.660  91.030  1.00 32.78           C  
ATOM   5279  N   ASP C 154       0.652  32.189  94.205  1.00 38.73           N  
ATOM   5280  CA  ASP C 154       0.258  32.220  95.604  1.00 43.04           C  
ATOM   5281  C   ASP C 154      -1.253  32.325  95.752  1.00 43.61           C  
ATOM   5282  O   ASP C 154      -1.828  31.806  96.715  1.00 44.00           O  
ATOM   5283  CB  ASP C 154       0.930  33.393  96.335  1.00 46.34           C  
ATOM   5284  CG  ASP C 154       2.450  33.255  96.397  1.00 50.34           C  
ATOM   5285  OD1 ASP C 154       2.945  32.105  96.521  1.00 52.01           O  
ATOM   5286  OD2 ASP C 154       3.149  34.295  96.337  1.00 51.99           O  
ATOM   5287  N   ASP C 155      -1.890  32.984  94.788  1.00 43.01           N  
ATOM   5288  CA  ASP C 155      -3.332  33.180  94.816  1.00 42.94           C  
ATOM   5289  C   ASP C 155      -4.142  31.959  94.422  1.00 42.25           C  
ATOM   5290  O   ASP C 155      -5.364  32.049  94.287  1.00 45.12           O  
ATOM   5291  CB  ASP C 155      -3.736  34.341  93.899  1.00 44.59           C  
ATOM   5292  CG  ASP C 155      -2.843  35.543  94.057  1.00 45.72           C  
ATOM   5293  OD1 ASP C 155      -2.475  35.851  95.206  1.00 47.12           O  
ATOM   5294  OD2 ASP C 155      -2.518  36.181  93.035  1.00 46.32           O  
ATOM   5295  N   VAL C 156      -3.489  30.822  94.230  1.00 40.14           N  
ATOM   5296  CA  VAL C 156      -4.219  29.623  93.835  1.00 39.96           C  
ATOM   5297  C   VAL C 156      -3.574  28.366  94.393  1.00 40.09           C  
ATOM   5298  O   VAL C 156      -2.467  28.414  94.924  1.00 41.26           O  
ATOM   5299  CB  VAL C 156      -4.320  29.512  92.289  1.00 40.33           C  
ATOM   5300  CG1 VAL C 156      -5.337  30.520  91.751  1.00 37.51           C  
ATOM   5301  CG2 VAL C 156      -2.943  29.736  91.661  1.00 39.50           C  
ATOM   5302  N   PRO C 157      -4.253  27.217  94.273  1.00 39.67           N  
ATOM   5303  CA  PRO C 157      -3.701  25.966  94.792  1.00 39.43           C  
ATOM   5304  C   PRO C 157      -2.440  25.416  94.127  1.00 40.56           C  
ATOM   5305  O   PRO C 157      -1.722  24.624  94.746  1.00 40.74           O  
ATOM   5306  CB  PRO C 157      -4.887  25.004  94.694  1.00 38.35           C  
ATOM   5307  CG  PRO C 157      -5.633  25.508  93.514  1.00 38.62           C  
ATOM   5308  CD  PRO C 157      -5.608  27.002  93.733  1.00 40.26           C  
ATOM   5309  N   ALA C 158      -2.158  25.822  92.889  1.00 41.25           N  
ATOM   5310  CA  ALA C 158      -0.972  25.304  92.209  1.00 41.01           C  
ATOM   5311  C   ALA C 158      -0.209  26.281  91.331  1.00 42.15           C  
ATOM   5312  O   ALA C 158      -0.646  27.408  91.073  1.00 40.82           O  
ATOM   5313  CB  ALA C 158      -1.330  24.065  91.391  1.00 39.42           C  
ATOM   5314  N   GLY C 159       0.945  25.798  90.871  1.00 44.02           N  
ATOM   5315  CA  GLY C 159       1.845  26.560  90.029  1.00 43.16           C  
ATOM   5316  C   GLY C 159       1.349  26.857  88.634  1.00 41.98           C  
ATOM   5317  O   GLY C 159       0.158  27.073  88.430  1.00 41.74           O  
ATOM   5318  N   ARG C 160       2.263  26.840  87.666  1.00 41.60           N  
ATOM   5319  CA  ARG C 160       1.901  27.184  86.302  1.00 39.99           C  
ATOM   5320  C   ARG C 160       1.516  26.078  85.359  1.00 40.98           C  
ATOM   5321  O   ARG C 160       0.665  26.286  84.492  1.00 47.25           O  
ATOM   5322  CB  ARG C 160       2.986  28.041  85.640  1.00 36.99           C  
ATOM   5323  CG  ARG C 160       2.591  28.527  84.251  1.00 31.31           C  
ATOM   5324  CD  ARG C 160       3.559  29.545  83.716  1.00 29.69           C  
ATOM   5325  NE  ARG C 160       2.945  30.860  83.568  1.00 28.13           N  
ATOM   5326  CZ  ARG C 160       3.628  31.975  83.333  1.00 27.58           C  
ATOM   5327  NH1 ARG C 160       4.945  31.932  83.218  1.00 29.01           N  
ATOM   5328  NH2 ARG C 160       2.998  33.133  83.214  1.00 26.99           N  
ATOM   5329  N   PRO C 161       2.127  24.897  85.461  1.00 37.80           N  
ATOM   5330  CA  PRO C 161       1.578  23.987  84.441  1.00 35.24           C  
ATOM   5331  C   PRO C 161       0.025  23.957  84.450  1.00 34.74           C  
ATOM   5332  O   PRO C 161      -0.587  23.833  83.396  1.00 36.12           O  
ATOM   5333  CB  PRO C 161       2.224  22.646  84.779  1.00 33.96           C  
ATOM   5334  CG  PRO C 161       2.605  22.794  86.254  1.00 36.90           C  
ATOM   5335  CD  PRO C 161       3.053  24.227  86.382  1.00 34.78           C  
ATOM   5336  N   TYR C 162      -0.594  24.140  85.623  1.00 33.85           N  
ATOM   5337  CA  TYR C 162      -2.060  24.134  85.788  1.00 34.47           C  
ATOM   5338  C   TYR C 162      -2.749  25.422  85.333  1.00 35.26           C  
ATOM   5339  O   TYR C 162      -2.126  26.479  85.300  1.00 36.41           O  
ATOM   5340  CB  TYR C 162      -2.434  23.892  87.254  1.00 36.67           C  
ATOM   5341  CG  TYR C 162      -1.866  22.617  87.833  1.00 39.96           C  
ATOM   5342  CD1 TYR C 162      -0.524  22.539  88.223  1.00 40.90           C  
ATOM   5343  CD2 TYR C 162      -2.651  21.467  87.937  1.00 40.20           C  
ATOM   5344  CE1 TYR C 162       0.022  21.346  88.695  1.00 40.94           C  
ATOM   5345  CE2 TYR C 162      -2.115  20.270  88.405  1.00 42.34           C  
ATOM   5346  CZ  TYR C 162      -0.779  20.217  88.781  1.00 42.53           C  
ATOM   5347  OH  TYR C 162      -0.244  19.035  89.238  1.00 44.27           O  
ATOM   5348  N   PRO C 163      -4.066  25.355  85.010  1.00 34.60           N  
ATOM   5349  CA  PRO C 163      -4.871  26.504  84.547  1.00 33.21           C  
ATOM   5350  C   PRO C 163      -5.538  27.419  85.600  1.00 32.92           C  
ATOM   5351  O   PRO C 163      -6.237  28.371  85.238  1.00 32.04           O  
ATOM   5352  CB  PRO C 163      -5.907  25.839  83.650  1.00 31.37           C  
ATOM   5353  CG  PRO C 163      -6.205  24.602  84.410  1.00 31.69           C  
ATOM   5354  CD  PRO C 163      -4.831  24.101  84.851  1.00 32.24           C  
ATOM   5355  N   TRP C 164      -5.310  27.140  86.884  1.00 31.76           N  
ATOM   5356  CA  TRP C 164      -5.906  27.904  87.988  1.00 29.79           C  
ATOM   5357  C   TRP C 164      -5.757  29.428  87.922  1.00 29.78           C  
ATOM   5358  O   TRP C 164      -6.706  30.156  88.217  1.00 29.53           O  
ATOM   5359  CB  TRP C 164      -5.353  27.391  89.318  1.00 29.24           C  
ATOM   5360  CG  TRP C 164      -5.335  25.888  89.431  1.00 28.36           C  
ATOM   5361  CD1 TRP C 164      -4.430  25.138  90.121  1.00 29.75           C  
ATOM   5362  CD2 TRP C 164      -6.234  24.958  88.809  1.00 29.08           C  
ATOM   5363  NE1 TRP C 164      -4.698  23.795  89.963  1.00 30.71           N  
ATOM   5364  CE2 TRP C 164      -5.799  23.656  89.165  1.00 29.30           C  
ATOM   5365  CE3 TRP C 164      -7.364  25.095  87.988  1.00 28.61           C  
ATOM   5366  CZ2 TRP C 164      -6.453  22.501  88.726  1.00 27.48           C  
ATOM   5367  CZ3 TRP C 164      -8.012  23.948  87.552  1.00 28.36           C  
ATOM   5368  CH2 TRP C 164      -7.551  22.665  87.925  1.00 27.87           C  
ATOM   5369  N   MET C 165      -4.577  29.918  87.549  1.00 30.51           N  
ATOM   5370  CA  MET C 165      -4.367  31.366  87.454  1.00 29.69           C  
ATOM   5371  C   MET C 165      -5.136  31.962  86.285  1.00 29.43           C  
ATOM   5372  O   MET C 165      -5.537  33.127  86.328  1.00 28.84           O  
ATOM   5373  CB  MET C 165      -2.880  31.704  87.293  1.00 30.15           C  
ATOM   5374  CG  MET C 165      -1.995  31.277  88.454  1.00 29.67           C  
ATOM   5375  SD  MET C 165      -0.307  31.867  88.259  1.00 27.42           S  
ATOM   5376  CE  MET C 165       0.470  30.484  87.398  1.00 27.11           C  
ATOM   5377  N   CYS C 166      -5.329  31.171  85.228  1.00 30.45           N  
ATOM   5378  CA  CYS C 166      -6.081  31.653  84.067  1.00 30.67           C  
ATOM   5379  C   CYS C 166      -7.570  31.799  84.418  1.00 29.48           C  
ATOM   5380  O   CYS C 166      -8.182  32.815  84.103  1.00 28.11           O  
ATOM   5381  CB  CYS C 166      -5.883  30.721  82.859  1.00 31.02           C  
ATOM   5382  SG  CYS C 166      -4.318  30.999  81.947  1.00 30.06           S  
ATOM   5383  N   TYR C 167      -8.147  30.800  85.085  1.00 28.47           N  
ATOM   5384  CA  TYR C 167      -9.544  30.885  85.484  1.00 28.14           C  
ATOM   5385  C   TYR C 167      -9.752  32.126  86.370  1.00 29.15           C  
ATOM   5386  O   TYR C 167     -10.803  32.776  86.291  1.00 29.02           O  
ATOM   5387  CB  TYR C 167      -9.972  29.624  86.248  1.00 26.75           C  
ATOM   5388  CG  TYR C 167      -9.957  28.338  85.441  1.00 25.32           C  
ATOM   5389  CD1 TYR C 167      -9.880  27.102  86.082  1.00 26.76           C  
ATOM   5390  CD2 TYR C 167      -9.987  28.350  84.048  1.00 24.02           C  
ATOM   5391  CE1 TYR C 167      -9.823  25.904  85.352  1.00 25.67           C  
ATOM   5392  CE2 TYR C 167      -9.933  27.154  83.307  1.00 23.14           C  
ATOM   5393  CZ  TYR C 167      -9.847  25.935  83.968  1.00 24.02           C  
ATOM   5394  OH  TYR C 167      -9.769  24.748  83.270  1.00 22.18           O  
ATOM   5395  N   LYS C 168      -8.767  32.458  87.210  1.00 29.95           N  
ATOM   5396  CA  LYS C 168      -8.890  33.639  88.072  1.00 31.85           C  
ATOM   5397  C   LYS C 168      -9.003  34.901  87.250  1.00 31.12           C  
ATOM   5398  O   LYS C 168      -9.843  35.745  87.533  1.00 32.25           O  
ATOM   5399  CB  LYS C 168      -7.709  33.789  89.023  1.00 34.05           C  
ATOM   5400  CG  LYS C 168      -7.952  33.176  90.386  1.00 39.95           C  
ATOM   5401  CD  LYS C 168      -7.242  33.947  91.498  1.00 44.45           C  
ATOM   5402  CE  LYS C 168      -7.885  35.326  91.747  1.00 47.95           C  
ATOM   5403  NZ  LYS C 168      -9.265  35.277  92.344  1.00 48.59           N  
ATOM   5404  N   ASN C 169      -8.153  35.033  86.239  1.00 29.95           N  
ATOM   5405  CA  ASN C 169      -8.202  36.200  85.363  1.00 29.83           C  
ATOM   5406  C   ASN C 169      -9.585  36.326  84.738  1.00 28.34           C  
ATOM   5407  O   ASN C 169     -10.111  37.423  84.601  1.00 27.62           O  
ATOM   5408  CB  ASN C 169      -7.150  36.084  84.259  1.00 29.93           C  
ATOM   5409  CG  ASN C 169      -5.794  36.588  84.697  1.00 29.59           C  
ATOM   5410  OD1 ASN C 169      -5.496  37.782  84.590  1.00 27.36           O  
ATOM   5411  ND2 ASN C 169      -4.967  35.683  85.211  1.00 28.68           N  
ATOM   5412  N   ALA C 170     -10.158  35.182  84.369  1.00 28.54           N  
ATOM   5413  CA  ALA C 170     -11.482  35.103  83.755  1.00 28.83           C  
ATOM   5414  C   ALA C 170     -12.594  35.690  84.645  1.00 29.83           C  
ATOM   5415  O   ALA C 170     -13.345  36.572  84.212  1.00 27.47           O  
ATOM   5416  CB  ALA C 170     -11.795  33.648  83.409  1.00 25.73           C  
ATOM   5417  N   MET C 171     -12.695  35.191  85.878  1.00 31.67           N  
ATOM   5418  CA  MET C 171     -13.701  35.657  86.831  1.00 33.25           C  
ATOM   5419  C   MET C 171     -13.596  37.151  87.070  1.00 34.80           C  
ATOM   5420  O   MET C 171     -14.573  37.880  86.909  1.00 36.09           O  
ATOM   5421  CB  MET C 171     -13.530  34.974  88.178  1.00 33.83           C  
ATOM   5422  CG  MET C 171     -13.607  33.482  88.137  1.00 36.99           C  
ATOM   5423  SD  MET C 171     -13.542  32.858  89.812  1.00 38.30           S  
ATOM   5424  CE  MET C 171     -12.345  31.546  89.628  1.00 37.77           C  
ATOM   5425  N   GLU C 172     -12.407  37.594  87.472  1.00 35.49           N  
ATOM   5426  CA  GLU C 172     -12.164  38.999  87.763  1.00 36.88           C  
ATOM   5427  C   GLU C 172     -12.368  39.922  86.560  1.00 36.49           C  
ATOM   5428  O   GLU C 172     -12.781  41.063  86.730  1.00 38.77           O  
ATOM   5429  CB  GLU C 172     -10.750  39.188  88.310  1.00 39.84           C  
ATOM   5430  CG  GLU C 172     -10.387  38.283  89.494  1.00 46.99           C  
ATOM   5431  CD  GLU C 172     -11.228  38.520  90.749  1.00 51.55           C  
ATOM   5432  OE1 GLU C 172     -11.591  39.688  91.017  1.00 56.29           O  
ATOM   5433  OE2 GLU C 172     -11.514  37.538  91.475  1.00 52.75           O  
ATOM   5434  N   LEU C 173     -12.090  39.445  85.351  1.00 34.36           N  
ATOM   5435  CA  LEU C 173     -12.263  40.282  84.166  1.00 32.12           C  
ATOM   5436  C   LEU C 173     -13.673  40.186  83.576  1.00 31.98           C  
ATOM   5437  O   LEU C 173     -14.078  41.025  82.765  1.00 31.45           O  
ATOM   5438  CB  LEU C 173     -11.236  39.905  83.097  1.00 31.56           C  
ATOM   5439  CG  LEU C 173      -9.755  40.159  83.392  1.00 31.78           C  
ATOM   5440  CD1 LEU C 173      -8.931  39.575  82.261  1.00 31.46           C  
ATOM   5441  CD2 LEU C 173      -9.478  41.647  83.541  1.00 29.73           C  
ATOM   5442  N   GLY C 174     -14.410  39.155  83.971  1.00 30.78           N  
ATOM   5443  CA  GLY C 174     -15.760  38.979  83.469  1.00 30.03           C  
ATOM   5444  C   GLY C 174     -15.877  38.539  82.021  1.00 30.24           C  
ATOM   5445  O   GLY C 174     -16.754  38.997  81.306  1.00 31.72           O  
ATOM   5446  N   VAL C 175     -15.003  37.644  81.584  1.00 30.91           N  
ATOM   5447  CA  VAL C 175     -15.021  37.131  80.211  1.00 32.04           C  
ATOM   5448  C   VAL C 175     -15.167  35.620  80.392  1.00 34.01           C  
ATOM   5449  O   VAL C 175     -14.415  35.031  81.168  1.00 33.75           O  
ATOM   5450  CB  VAL C 175     -13.679  37.480  79.500  1.00 31.70           C  
ATOM   5451  CG1 VAL C 175     -13.701  37.045  78.038  1.00 28.79           C  
ATOM   5452  CG2 VAL C 175     -13.420  38.980  79.609  1.00 30.44           C  
ATOM   5453  N   TYR C 176     -16.103  34.957  79.716  1.00 36.55           N  
ATOM   5454  CA  TYR C 176     -16.172  33.535  80.024  1.00 40.83           C  
ATOM   5455  C   TYR C 176     -15.912  32.420  79.033  1.00 43.12           C  
ATOM   5456  O   TYR C 176     -15.119  31.510  79.348  1.00 48.61           O  
ATOM   5457  CB  TYR C 176     -17.451  33.193  80.802  1.00 40.84           C  
ATOM   5458  CG  TYR C 176     -18.768  33.657  80.244  1.00 38.09           C  
ATOM   5459  CD1 TYR C 176     -19.394  34.795  80.757  1.00 34.53           C  
ATOM   5460  CD2 TYR C 176     -19.450  32.889  79.306  1.00 37.28           C  
ATOM   5461  CE1 TYR C 176     -20.668  35.149  80.364  1.00 35.32           C  
ATOM   5462  CE2 TYR C 176     -20.736  33.236  78.897  1.00 37.73           C  
ATOM   5463  CZ  TYR C 176     -21.340  34.366  79.436  1.00 36.84           C  
ATOM   5464  OH  TYR C 176     -22.627  34.689  79.074  1.00 39.51           O  
ATOM   5465  N   PRO C 177     -16.564  32.423  77.857  1.00 39.65           N  
ATOM   5466  CA  PRO C 177     -16.182  31.265  77.021  1.00 36.31           C  
ATOM   5467  C   PRO C 177     -14.649  31.349  76.966  1.00 35.27           C  
ATOM   5468  O   PRO C 177     -14.114  32.331  76.454  1.00 33.43           O  
ATOM   5469  CB  PRO C 177     -16.833  31.567  75.675  1.00 34.64           C  
ATOM   5470  CG  PRO C 177     -17.812  32.726  75.971  1.00 37.09           C  
ATOM   5471  CD  PRO C 177     -17.172  33.505  77.071  1.00 34.74           C  
ATOM   5472  N   MET C 178     -13.941  30.366  77.523  1.00 35.37           N  
ATOM   5473  CA  MET C 178     -12.469  30.427  77.540  1.00 36.83           C  
ATOM   5474  C   MET C 178     -11.826  30.678  76.182  1.00 37.38           C  
ATOM   5475  O   MET C 178     -10.803  31.365  76.091  1.00 37.18           O  
ATOM   5476  CB  MET C 178     -11.853  29.158  78.140  1.00 36.83           C  
ATOM   5477  CG  MET C 178     -12.109  28.950  79.631  1.00 38.48           C  
ATOM   5478  SD  MET C 178     -11.581  30.303  80.700  1.00 38.28           S  
ATOM   5479  CE  MET C 178      -9.856  29.981  80.837  1.00 39.27           C  
ATOM   5480  N   ASN C 179     -12.423  30.127  75.128  1.00 37.67           N  
ATOM   5481  CA  ASN C 179     -11.901  30.301  73.778  1.00 37.54           C  
ATOM   5482  C   ASN C 179     -12.175  31.691  73.230  1.00 35.92           C  
ATOM   5483  O   ASN C 179     -12.188  31.894  72.022  1.00 36.13           O  
ATOM   5484  CB  ASN C 179     -12.499  29.252  72.847  1.00 39.64           C  
ATOM   5485  CG  ASN C 179     -14.006  29.328  72.788  1.00 41.50           C  
ATOM   5486  OD1 ASN C 179     -14.670  28.371  72.391  1.00 43.58           O  
ATOM   5487  ND2 ASN C 179     -14.558  30.472  73.177  1.00 43.02           N  
ATOM   5488  N   HIS C 180     -12.427  32.635  74.127  1.00 34.28           N  
ATOM   5489  CA  HIS C 180     -12.646  34.016  73.737  1.00 34.52           C  
ATOM   5490  C   HIS C 180     -11.443  34.783  74.269  1.00 35.10           C  
ATOM   5491  O   HIS C 180     -11.402  36.019  74.241  1.00 35.74           O  
ATOM   5492  CB  HIS C 180     -13.925  34.577  74.358  1.00 34.63           C  
ATOM   5493  CG  HIS C 180     -15.160  34.308  73.555  1.00 36.29           C  
ATOM   5494  ND1 HIS C 180     -16.256  35.144  73.579  1.00 34.67           N  
ATOM   5495  CD2 HIS C 180     -15.478  33.292  72.716  1.00 35.71           C  
ATOM   5496  CE1 HIS C 180     -17.196  34.655  72.789  1.00 35.03           C  
ATOM   5497  NE2 HIS C 180     -16.749  33.532  72.254  1.00 33.88           N  
ATOM   5498  N   MET C 181     -10.465  34.035  74.765  1.00 34.74           N  
ATOM   5499  CA  MET C 181      -9.254  34.628  75.315  1.00 35.19           C  
ATOM   5500  C   MET C 181      -7.993  34.071  74.634  1.00 35.29           C  
ATOM   5501  O   MET C 181      -7.980  32.942  74.131  1.00 35.79           O  
ATOM   5502  CB  MET C 181      -9.187  34.349  76.819  1.00 34.77           C  
ATOM   5503  CG  MET C 181     -10.495  34.572  77.554  1.00 35.66           C  
ATOM   5504  SD  MET C 181     -10.362  34.335  79.342  1.00 35.20           S  
ATOM   5505  CE  MET C 181     -10.113  35.982  79.877  1.00 35.62           C  
ATOM   5506  N   ILE C 182      -6.934  34.872  74.619  1.00 33.48           N  
ATOM   5507  CA  ILE C 182      -5.671  34.447  74.038  1.00 31.63           C  
ATOM   5508  C   ILE C 182      -4.591  34.454  75.123  1.00 30.47           C  
ATOM   5509  O   ILE C 182      -4.573  35.334  75.983  1.00 30.51           O  
ATOM   5510  CB  ILE C 182      -5.229  35.400  72.918  1.00 32.40           C  
ATOM   5511  CG1 ILE C 182      -6.297  35.470  71.833  1.00 31.83           C  
ATOM   5512  CG2 ILE C 182      -3.927  34.920  72.312  1.00 31.88           C  
ATOM   5513  CD1 ILE C 182      -5.929  36.411  70.704  1.00 30.58           C  
ATOM   5514  N   LYS C 183      -3.703  33.466  75.090  1.00 29.07           N  
ATOM   5515  CA  LYS C 183      -2.599  33.381  76.048  1.00 27.92           C  
ATOM   5516  C   LYS C 183      -1.291  33.652  75.313  1.00 28.80           C  
ATOM   5517  O   LYS C 183      -0.989  32.982  74.327  1.00 28.16           O  
ATOM   5518  CB  LYS C 183      -2.519  31.984  76.679  1.00 26.49           C  
ATOM   5519  CG  LYS C 183      -1.250  31.755  77.503  1.00 24.39           C  
ATOM   5520  CD  LYS C 183      -1.134  32.770  78.651  1.00 24.25           C  
ATOM   5521  CE  LYS C 183       0.304  32.933  79.159  1.00 21.05           C  
ATOM   5522  NZ  LYS C 183       0.895  31.695  79.730  1.00 19.01           N  
ATOM   5523  N   VAL C 184      -0.520  34.632  75.774  1.00 29.95           N  
ATOM   5524  CA  VAL C 184       0.762  34.929  75.133  1.00 30.86           C  
ATOM   5525  C   VAL C 184       1.890  34.726  76.134  1.00 30.57           C  
ATOM   5526  O   VAL C 184       1.843  35.238  77.256  1.00 29.44           O  
ATOM   5527  CB  VAL C 184       0.835  36.381  74.596  1.00 31.88           C  
ATOM   5528  CG1 VAL C 184       2.096  36.556  73.767  1.00 30.12           C  
ATOM   5529  CG2 VAL C 184      -0.389  36.700  73.762  1.00 31.50           C  
ATOM   5530  N   GLY C 185       2.905  33.977  75.713  1.00 32.01           N  
ATOM   5531  CA  GLY C 185       4.042  33.693  76.576  1.00 32.93           C  
ATOM   5532  C   GLY C 185       5.351  33.465  75.835  1.00 32.58           C  
ATOM   5533  O   GLY C 185       5.372  33.367  74.608  1.00 31.96           O  
ATOM   5534  N   ASP C 186       6.441  33.354  76.591  1.00 32.64           N  
ATOM   5535  CA  ASP C 186       7.764  33.172  76.012  1.00 32.32           C  
ATOM   5536  C   ASP C 186       8.440  31.810  76.244  1.00 32.93           C  
ATOM   5537  O   ASP C 186       9.597  31.616  75.838  1.00 33.85           O  
ATOM   5538  CB  ASP C 186       8.694  34.293  76.503  1.00 31.16           C  
ATOM   5539  CG  ASP C 186       9.045  34.167  77.975  1.00 31.90           C  
ATOM   5540  OD1 ASP C 186       8.124  34.224  78.818  1.00 32.69           O  
ATOM   5541  OD2 ASP C 186      10.248  34.010  78.290  1.00 31.47           O  
ATOM   5542  N   THR C 187       7.749  30.863  76.874  1.00 31.68           N  
ATOM   5543  CA  THR C 187       8.368  29.557  77.112  1.00 32.13           C  
ATOM   5544  C   THR C 187       7.451  28.371  76.820  1.00 33.38           C  
ATOM   5545  O   THR C 187       6.281  28.536  76.489  1.00 34.32           O  
ATOM   5546  CB  THR C 187       8.856  29.419  78.560  1.00 30.45           C  
ATOM   5547  OG1 THR C 187       7.725  29.244  79.419  1.00 31.30           O  
ATOM   5548  CG2 THR C 187       9.637  30.659  78.987  1.00 27.78           C  
ATOM   5549  N   VAL C 188       7.996  27.168  76.937  1.00 34.17           N  
ATOM   5550  CA  VAL C 188       7.220  25.973  76.678  1.00 35.55           C  
ATOM   5551  C   VAL C 188       6.095  25.834  77.704  1.00 36.71           C  
ATOM   5552  O   VAL C 188       4.966  25.476  77.353  1.00 37.12           O  
ATOM   5553  CB  VAL C 188       8.121  24.725  76.717  1.00 36.64           C  
ATOM   5554  CG1 VAL C 188       7.286  23.472  76.536  1.00 37.86           C  
ATOM   5555  CG2 VAL C 188       9.167  24.813  75.619  1.00 36.91           C  
ATOM   5556  N   SER C 189       6.386  26.123  78.971  1.00 36.76           N  
ATOM   5557  CA  SER C 189       5.354  26.011  79.996  1.00 36.51           C  
ATOM   5558  C   SER C 189       4.213  26.993  79.727  1.00 35.92           C  
ATOM   5559  O   SER C 189       3.069  26.722  80.079  1.00 36.27           O  
ATOM   5560  CB  SER C 189       5.931  26.261  81.391  1.00 35.69           C  
ATOM   5561  OG  SER C 189       6.147  27.639  81.604  1.00 39.17           O  
ATOM   5562  N   ASP C 190       4.518  28.135  79.115  1.00 34.55           N  
ATOM   5563  CA  ASP C 190       3.470  29.099  78.802  1.00 34.16           C  
ATOM   5564  C   ASP C 190       2.485  28.464  77.818  1.00 33.13           C  
ATOM   5565  O   ASP C 190       1.283  28.725  77.866  1.00 33.20           O  
ATOM   5566  CB  ASP C 190       4.048  30.372  78.170  1.00 35.78           C  
ATOM   5567  CG  ASP C 190       4.649  31.321  79.191  1.00 37.04           C  
ATOM   5568  OD1 ASP C 190       5.788  31.091  79.649  1.00 38.15           O  
ATOM   5569  OD2 ASP C 190       3.973  32.309  79.539  1.00 37.74           O  
ATOM   5570  N   MET C 191       2.995  27.627  76.926  1.00 31.02           N  
ATOM   5571  CA  MET C 191       2.135  26.984  75.950  1.00 29.73           C  
ATOM   5572  C   MET C 191       1.210  26.008  76.660  1.00 29.43           C  
ATOM   5573  O   MET C 191       0.002  26.010  76.425  1.00 29.72           O  
ATOM   5574  CB  MET C 191       2.972  26.251  74.902  1.00 28.92           C  
ATOM   5575  CG  MET C 191       3.975  27.133  74.181  1.00 28.02           C  
ATOM   5576  SD  MET C 191       3.230  28.548  73.364  1.00 28.37           S  
ATOM   5577  CE  MET C 191       3.905  29.875  74.297  1.00 28.54           C  
ATOM   5578  N   LYS C 192       1.775  25.181  77.536  1.00 28.09           N  
ATOM   5579  CA  LYS C 192       0.985  24.205  78.280  1.00 27.55           C  
ATOM   5580  C   LYS C 192      -0.135  24.841  79.102  1.00 26.63           C  
ATOM   5581  O   LYS C 192      -1.290  24.422  79.007  1.00 26.88           O  
ATOM   5582  CB  LYS C 192       1.881  23.390  79.202  1.00 29.22           C  
ATOM   5583  CG  LYS C 192       2.789  22.398  78.501  1.00 31.98           C  
ATOM   5584  CD  LYS C 192       3.506  21.565  79.545  1.00 34.86           C  
ATOM   5585  CE  LYS C 192       4.452  20.557  78.935  1.00 37.93           C  
ATOM   5586  NZ  LYS C 192       5.014  19.679  80.006  1.00 40.45           N  
ATOM   5587  N   GLU C 193       0.202  25.840  79.916  1.00 24.92           N  
ATOM   5588  CA  GLU C 193      -0.798  26.527  80.724  1.00 25.05           C  
ATOM   5589  C   GLU C 193      -1.969  26.941  79.837  1.00 26.45           C  
ATOM   5590  O   GLU C 193      -3.129  26.691  80.155  1.00 27.56           O  
ATOM   5591  CB  GLU C 193      -0.190  27.764  81.382  1.00 24.04           C  
ATOM   5592  CG  GLU C 193      -1.199  28.708  82.010  1.00 24.41           C  
ATOM   5593  CD  GLU C 193      -0.550  29.931  82.625  1.00 25.74           C  
ATOM   5594  OE1 GLU C 193       0.376  30.482  82.003  1.00 26.03           O  
ATOM   5595  OE2 GLU C 193      -0.969  30.350  83.726  1.00 28.43           O  
ATOM   5596  N   GLY C 194      -1.662  27.567  78.711  1.00 27.21           N  
ATOM   5597  CA  GLY C 194      -2.711  27.987  77.804  1.00 29.86           C  
ATOM   5598  C   GLY C 194      -3.578  26.860  77.262  1.00 31.26           C  
ATOM   5599  O   GLY C 194      -4.807  26.956  77.275  1.00 31.54           O  
ATOM   5600  N   ARG C 195      -2.959  25.792  76.770  1.00 32.51           N  
ATOM   5601  CA  ARG C 195      -3.737  24.688  76.230  1.00 34.50           C  
ATOM   5602  C   ARG C 195      -4.576  24.055  77.334  1.00 35.47           C  
ATOM   5603  O   ARG C 195      -5.677  23.571  77.079  1.00 36.53           O  
ATOM   5604  CB  ARG C 195      -2.825  23.632  75.590  1.00 35.40           C  
ATOM   5605  CG  ARG C 195      -1.992  24.130  74.414  1.00 37.19           C  
ATOM   5606  CD  ARG C 195      -2.855  24.702  73.301  1.00 40.12           C  
ATOM   5607  NE  ARG C 195      -3.872  23.758  72.832  1.00 44.48           N  
ATOM   5608  CZ  ARG C 195      -3.840  23.114  71.663  1.00 45.30           C  
ATOM   5609  NH1 ARG C 195      -2.839  23.297  70.812  1.00 45.02           N  
ATOM   5610  NH2 ARG C 195      -4.830  22.290  71.339  1.00 46.69           N  
ATOM   5611  N   ASN C 196      -4.068  24.071  78.563  1.00 34.81           N  
ATOM   5612  CA  ASN C 196      -4.800  23.493  79.686  1.00 35.40           C  
ATOM   5613  C   ASN C 196      -6.026  24.286  80.137  1.00 35.53           C  
ATOM   5614  O   ASN C 196      -6.884  23.763  80.844  1.00 36.88           O  
ATOM   5615  CB  ASN C 196      -3.874  23.306  80.883  1.00 36.50           C  
ATOM   5616  CG  ASN C 196      -2.910  22.163  80.693  1.00 37.93           C  
ATOM   5617  OD1 ASN C 196      -3.153  21.257  79.889  1.00 38.54           O  
ATOM   5618  ND2 ASN C 196      -1.816  22.183  81.447  1.00 36.61           N  
ATOM   5619  N   ALA C 197      -6.106  25.549  79.744  1.00 35.30           N  
ATOM   5620  CA  ALA C 197      -7.236  26.381  80.125  1.00 35.09           C  
ATOM   5621  C   ALA C 197      -8.225  26.537  78.966  1.00 35.16           C  
ATOM   5622  O   ALA C 197      -9.199  27.290  79.061  1.00 35.29           O  
ATOM   5623  CB  ALA C 197      -6.737  27.745  80.582  1.00 35.33           C  
ATOM   5624  N   GLY C 198      -7.966  25.830  77.869  1.00 33.96           N  
ATOM   5625  CA  GLY C 198      -8.845  25.907  76.715  1.00 32.36           C  
ATOM   5626  C   GLY C 198      -8.804  27.243  75.992  1.00 32.01           C  
ATOM   5627  O   GLY C 198      -9.817  27.673  75.432  1.00 30.81           O  
ATOM   5628  N   MET C 199      -7.636  27.885  75.992  1.00 31.54           N  
ATOM   5629  CA  MET C 199      -7.442  29.181  75.340  1.00 31.57           C  
ATOM   5630  C   MET C 199      -6.650  29.077  74.031  1.00 32.06           C  
ATOM   5631  O   MET C 199      -6.043  28.044  73.737  1.00 30.86           O  
ATOM   5632  CB  MET C 199      -6.669  30.123  76.268  1.00 31.43           C  
ATOM   5633  CG  MET C 199      -7.201  30.231  77.685  1.00 32.65           C  
ATOM   5634  SD  MET C 199      -6.106  31.229  78.743  1.00 33.08           S  
ATOM   5635  CE  MET C 199      -6.450  32.879  78.094  1.00 30.36           C  
ATOM   5636  N   TRP C 200      -6.672  30.151  73.245  1.00 33.16           N  
ATOM   5637  CA  TRP C 200      -5.887  30.215  72.016  1.00 34.26           C  
ATOM   5638  C   TRP C 200      -4.529  30.589  72.561  1.00 34.83           C  
ATOM   5639  O   TRP C 200      -4.410  31.619  73.228  1.00 34.60           O  
ATOM   5640  CB  TRP C 200      -6.335  31.358  71.122  1.00 36.15           C  
ATOM   5641  CG  TRP C 200      -7.677  31.197  70.575  1.00 38.39           C  
ATOM   5642  CD1 TRP C 200      -8.812  31.831  70.977  1.00 38.94           C  
ATOM   5643  CD2 TRP C 200      -8.050  30.325  69.519  1.00 39.96           C  
ATOM   5644  NE1 TRP C 200      -9.880  31.404  70.231  1.00 39.94           N  
ATOM   5645  CE2 TRP C 200      -9.440  30.477  69.326  1.00 40.49           C  
ATOM   5646  CE3 TRP C 200      -7.347  29.423  68.712  1.00 40.62           C  
ATOM   5647  CZ2 TRP C 200     -10.141  29.758  68.361  1.00 41.37           C  
ATOM   5648  CZ3 TRP C 200      -8.042  28.706  67.752  1.00 40.93           C  
ATOM   5649  CH2 TRP C 200      -9.427  28.879  67.584  1.00 41.60           C  
ATOM   5650  N   THR C 201      -3.505  29.784  72.298  1.00 35.39           N  
ATOM   5651  CA  THR C 201      -2.185  30.113  72.823  1.00 35.55           C  
ATOM   5652  C   THR C 201      -1.156  30.486  71.741  1.00 35.83           C  
ATOM   5653  O   THR C 201      -0.949  29.756  70.770  1.00 36.44           O  
ATOM   5654  CB  THR C 201      -1.657  28.965  73.716  1.00 34.03           C  
ATOM   5655  OG1 THR C 201      -0.676  28.212  73.008  1.00 35.06           O  
ATOM   5656  CG2 THR C 201      -2.798  28.051  74.115  1.00 32.18           C  
ATOM   5657  N   VAL C 202      -0.524  31.642  71.935  1.00 35.58           N  
ATOM   5658  CA  VAL C 202       0.472  32.190  71.015  1.00 35.02           C  
ATOM   5659  C   VAL C 202       1.840  32.400  71.683  1.00 34.98           C  
ATOM   5660  O   VAL C 202       1.923  32.948  72.781  1.00 35.44           O  
ATOM   5661  CB  VAL C 202      -0.011  33.552  70.485  1.00 35.07           C  
ATOM   5662  CG1 VAL C 202       1.051  34.187  69.596  1.00 35.24           C  
ATOM   5663  CG2 VAL C 202      -1.317  33.369  69.739  1.00 34.63           C  
ATOM   5664  N   GLY C 203       2.911  31.982  71.013  1.00 34.28           N  
ATOM   5665  CA  GLY C 203       4.242  32.161  71.576  1.00 33.59           C  
ATOM   5666  C   GLY C 203       5.092  33.202  70.854  1.00 33.40           C  
ATOM   5667  O   GLY C 203       5.139  33.218  69.623  1.00 33.95           O  
ATOM   5668  N   VAL C 204       5.760  34.073  71.614  1.00 32.43           N  
ATOM   5669  CA  VAL C 204       6.630  35.111  71.048  1.00 31.30           C  
ATOM   5670  C   VAL C 204       8.081  34.621  71.060  1.00 31.14           C  
ATOM   5671  O   VAL C 204       8.537  34.042  72.056  1.00 29.87           O  
ATOM   5672  CB  VAL C 204       6.582  36.395  71.869  1.00 31.56           C  
ATOM   5673  CG1 VAL C 204       6.826  37.580  70.967  1.00 31.38           C  
ATOM   5674  CG2 VAL C 204       5.261  36.505  72.588  1.00 33.79           C  
ATOM   5675  N   ILE C 205       8.815  34.880  69.977  1.00 30.38           N  
ATOM   5676  CA  ILE C 205      10.199  34.413  69.875  1.00 31.30           C  
ATOM   5677  C   ILE C 205      11.330  35.409  70.194  1.00 31.10           C  
ATOM   5678  O   ILE C 205      12.162  35.138  71.065  1.00 29.57           O  
ATOM   5679  CB  ILE C 205      10.455  33.794  68.479  1.00 31.97           C  
ATOM   5680  CG1 ILE C 205       9.337  32.795  68.155  1.00 31.86           C  
ATOM   5681  CG2 ILE C 205      11.809  33.071  68.462  1.00 30.89           C  
ATOM   5682  CD1 ILE C 205       9.416  32.180  66.770  1.00 29.69           C  
ATOM   5683  N   LEU C 206      11.378  36.543  69.500  1.00 30.16           N  
ATOM   5684  CA  LEU C 206      12.437  37.514  69.755  1.00 30.80           C  
ATOM   5685  C   LEU C 206      12.318  38.160  71.121  1.00 31.97           C  
ATOM   5686  O   LEU C 206      11.476  39.027  71.328  1.00 33.93           O  
ATOM   5687  CB  LEU C 206      12.455  38.601  68.678  1.00 29.41           C  
ATOM   5688  CG  LEU C 206      13.000  38.126  67.329  1.00 30.75           C  
ATOM   5689  CD1 LEU C 206      12.925  39.264  66.334  1.00 30.39           C  
ATOM   5690  CD2 LEU C 206      14.447  37.623  67.480  1.00 30.54           C  
ATOM   5691  N   GLY C 207      13.174  37.744  72.051  1.00 32.66           N  
ATOM   5692  CA  GLY C 207      13.149  38.291  73.398  1.00 32.24           C  
ATOM   5693  C   GLY C 207      12.772  37.244  74.436  1.00 32.90           C  
ATOM   5694  O   GLY C 207      12.756  37.519  75.634  1.00 33.81           O  
ATOM   5695  N   SER C 208      12.480  36.033  73.972  1.00 31.59           N  
ATOM   5696  CA  SER C 208      12.082  34.953  74.855  1.00 31.63           C  
ATOM   5697  C   SER C 208      13.281  34.364  75.549  1.00 33.35           C  
ATOM   5698  O   SER C 208      14.415  34.727  75.251  1.00 33.59           O  
ATOM   5699  CB  SER C 208      11.405  33.852  74.052  1.00 31.55           C  
ATOM   5700  OG  SER C 208      12.353  33.192  73.234  1.00 31.32           O  
ATOM   5701  N   SER C 209      13.015  33.455  76.484  1.00 35.18           N  
ATOM   5702  CA  SER C 209      14.070  32.764  77.213  1.00 37.33           C  
ATOM   5703  C   SER C 209      14.475  31.603  76.337  1.00 38.80           C  
ATOM   5704  O   SER C 209      15.645  31.228  76.274  1.00 39.98           O  
ATOM   5705  CB  SER C 209      13.558  32.213  78.539  1.00 36.96           C  
ATOM   5706  OG  SER C 209      13.196  33.267  79.409  1.00 42.90           O  
ATOM   5707  N   GLU C 210      13.484  31.034  75.660  1.00 40.28           N  
ATOM   5708  CA  GLU C 210      13.722  29.913  74.775  1.00 40.90           C  
ATOM   5709  C   GLU C 210      14.819  30.308  73.779  1.00 40.85           C  
ATOM   5710  O   GLU C 210      15.667  29.481  73.449  1.00 40.11           O  
ATOM   5711  CB  GLU C 210      12.421  29.536  74.061  1.00 43.64           C  
ATOM   5712  CG  GLU C 210      12.148  28.035  74.018  1.00 46.60           C  
ATOM   5713  CD  GLU C 210      12.064  27.404  75.403  1.00 49.15           C  
ATOM   5714  OE1 GLU C 210      11.195  27.810  76.209  1.00 49.35           O  
ATOM   5715  OE2 GLU C 210      12.868  26.492  75.686  1.00 50.74           O  
ATOM   5716  N   LEU C 211      14.816  31.566  73.320  1.00 40.09           N  
ATOM   5717  CA  LEU C 211      15.848  32.044  72.394  1.00 39.96           C  
ATOM   5718  C   LEU C 211      17.174  32.229  73.145  1.00 40.78           C  
ATOM   5719  O   LEU C 211      18.204  31.709  72.733  1.00 40.54           O  
ATOM   5720  CB  LEU C 211      15.455  33.376  71.749  1.00 38.35           C  
ATOM   5721  CG  LEU C 211      15.840  33.502  70.263  1.00 38.79           C  
ATOM   5722  CD1 LEU C 211      15.683  34.949  69.802  1.00 37.62           C  
ATOM   5723  CD2 LEU C 211      17.266  33.034  70.042  1.00 37.14           C  
ATOM   5724  N   GLY C 212      17.148  32.982  74.242  1.00 41.98           N  
ATOM   5725  CA  GLY C 212      18.352  33.178  75.034  1.00 41.97           C  
ATOM   5726  C   GLY C 212      19.266  34.327  74.656  1.00 43.05           C  
ATOM   5727  O   GLY C 212      20.283  34.546  75.306  1.00 43.92           O  
ATOM   5728  N   LEU C 213      18.917  35.071  73.617  1.00 44.57           N  
ATOM   5729  CA  LEU C 213      19.752  36.186  73.191  1.00 45.43           C  
ATOM   5730  C   LEU C 213      19.379  37.492  73.857  1.00 47.06           C  
ATOM   5731  O   LEU C 213      18.258  37.674  74.328  1.00 46.62           O  
ATOM   5732  CB  LEU C 213      19.680  36.369  71.675  1.00 44.84           C  
ATOM   5733  CG  LEU C 213      20.515  35.465  70.768  1.00 43.62           C  
ATOM   5734  CD1 LEU C 213      20.300  34.014  71.120  1.00 43.90           C  
ATOM   5735  CD2 LEU C 213      20.124  35.728  69.322  1.00 43.86           C  
ATOM   5736  N   THR C 214      20.345  38.402  73.867  1.00 49.97           N  
ATOM   5737  CA  THR C 214      20.198  39.726  74.446  1.00 51.79           C  
ATOM   5738  C   THR C 214      19.756  40.710  73.383  1.00 53.47           C  
ATOM   5739  O   THR C 214      20.077  40.548  72.208  1.00 52.91           O  
ATOM   5740  CB  THR C 214      21.532  40.226  74.996  1.00 51.96           C  
ATOM   5741  OG1 THR C 214      21.895  39.441  76.135  1.00 54.62           O  
ATOM   5742  CG2 THR C 214      21.443  41.685  75.388  1.00 53.65           C  
ATOM   5743  N   GLU C 215      19.015  41.726  73.807  1.00 56.66           N  
ATOM   5744  CA  GLU C 215      18.548  42.776  72.910  1.00 60.19           C  
ATOM   5745  C   GLU C 215      19.728  43.208  72.034  1.00 62.08           C  
ATOM   5746  O   GLU C 215      19.585  43.387  70.820  1.00 61.68           O  
ATOM   5747  CB  GLU C 215      18.048  43.964  73.743  1.00 61.98           C  
ATOM   5748  CG  GLU C 215      17.954  45.298  73.008  1.00 64.51           C  
ATOM   5749  CD  GLU C 215      16.677  45.465  72.207  1.00 66.01           C  
ATOM   5750  OE1 GLU C 215      16.453  44.676  71.259  1.00 66.27           O  
ATOM   5751  OE2 GLU C 215      15.898  46.390  72.536  1.00 66.35           O  
ATOM   5752  N   GLU C 216      20.894  43.352  72.663  1.00 63.93           N  
ATOM   5753  CA  GLU C 216      22.112  43.767  71.978  1.00 64.77           C  
ATOM   5754  C   GLU C 216      22.684  42.669  71.077  1.00 64.20           C  
ATOM   5755  O   GLU C 216      23.054  42.935  69.937  1.00 64.20           O  
ATOM   5756  CB  GLU C 216      23.166  44.197  73.000  1.00 66.93           C  
ATOM   5757  CG  GLU C 216      24.114  45.270  72.488  1.00 71.07           C  
ATOM   5758  CD  GLU C 216      25.577  44.942  72.737  1.00 74.29           C  
ATOM   5759  OE1 GLU C 216      26.439  45.801  72.436  1.00 76.18           O  
ATOM   5760  OE2 GLU C 216      25.869  43.826  73.225  1.00 76.11           O  
ATOM   5761  N   GLU C 217      22.759  41.441  71.580  1.00 63.62           N  
ATOM   5762  CA  GLU C 217      23.285  40.340  70.779  1.00 63.98           C  
ATOM   5763  C   GLU C 217      22.493  40.160  69.483  1.00 65.35           C  
ATOM   5764  O   GLU C 217      23.072  39.957  68.421  1.00 65.46           O  
ATOM   5765  CB  GLU C 217      23.239  39.032  71.558  1.00 62.91           C  
ATOM   5766  CG  GLU C 217      23.883  39.074  72.914  1.00 62.49           C  
ATOM   5767  CD  GLU C 217      23.954  37.698  73.538  1.00 62.80           C  
ATOM   5768  OE1 GLU C 217      24.752  36.866  73.055  1.00 63.70           O  
ATOM   5769  OE2 GLU C 217      23.204  37.439  74.501  1.00 62.78           O  
ATOM   5770  N   VAL C 218      21.167  40.214  69.575  1.00 67.59           N  
ATOM   5771  CA  VAL C 218      20.316  40.054  68.398  1.00 69.58           C  
ATOM   5772  C   VAL C 218      20.640  41.151  67.386  1.00 71.28           C  
ATOM   5773  O   VAL C 218      20.733  40.891  66.188  1.00 69.98           O  
ATOM   5774  CB  VAL C 218      18.816  40.131  68.775  1.00 69.16           C  
ATOM   5775  CG1 VAL C 218      17.959  39.735  67.585  1.00 68.98           C  
ATOM   5776  CG2 VAL C 218      18.527  39.219  69.952  1.00 69.19           C  
ATOM   5777  N   GLU C 219      20.807  42.374  67.893  1.00 74.62           N  
ATOM   5778  CA  GLU C 219      21.141  43.553  67.083  1.00 77.98           C  
ATOM   5779  C   GLU C 219      22.242  43.228  66.081  1.00 78.93           C  
ATOM   5780  O   GLU C 219      22.162  43.586  64.901  1.00 79.64           O  
ATOM   5781  CB  GLU C 219      21.637  44.684  67.987  1.00 80.22           C  
ATOM   5782  CG  GLU C 219      20.581  45.320  68.866  1.00 83.61           C  
ATOM   5783  CD  GLU C 219      19.840  46.441  68.164  1.00 85.59           C  
ATOM   5784  OE1 GLU C 219      18.909  47.009  68.777  1.00 86.43           O  
ATOM   5785  OE2 GLU C 219      20.197  46.755  67.004  1.00 86.40           O  
ATOM   5786  N   ASN C 220      23.280  42.573  66.583  1.00 78.84           N  
ATOM   5787  CA  ASN C 220      24.417  42.163  65.783  1.00 78.46           C  
ATOM   5788  C   ASN C 220      24.078  40.834  65.107  1.00 77.23           C  
ATOM   5789  O   ASN C 220      23.165  40.774  64.289  1.00 77.11           O  
ATOM   5790  CB  ASN C 220      25.644  42.030  66.695  1.00 82.09           C  
ATOM   5791  CG  ASN C 220      26.760  41.200  66.073  1.00 85.80           C  
ATOM   5792  OD1 ASN C 220      27.269  41.520  64.993  1.00 88.05           O  
ATOM   5793  ND2 ASN C 220      27.147  40.120  66.758  1.00 86.55           N  
ATOM   5794  N   MET C 221      24.807  39.780  65.473  1.00 76.12           N  
ATOM   5795  CA  MET C 221      24.647  38.423  64.944  1.00 75.15           C  
ATOM   5796  C   MET C 221      24.384  38.291  63.440  1.00 75.95           C  
ATOM   5797  O   MET C 221      23.706  39.117  62.827  1.00 75.92           O  
ATOM   5798  CB  MET C 221      23.557  37.670  65.723  1.00 72.29           C  
ATOM   5799  CG  MET C 221      23.411  36.215  65.297  1.00 68.41           C  
ATOM   5800  SD  MET C 221      22.322  35.252  66.334  1.00 63.82           S  
ATOM   5801  CE  MET C 221      23.456  34.116  67.078  1.00 63.12           C  
ATOM   5802  N   ASP C 222      24.926  37.228  62.856  1.00 76.86           N  
ATOM   5803  CA  ASP C 222      24.762  36.968  61.431  1.00 78.02           C  
ATOM   5804  C   ASP C 222      23.289  36.754  61.080  1.00 78.04           C  
ATOM   5805  O   ASP C 222      22.677  35.770  61.506  1.00 77.78           O  
ATOM   5806  CB  ASP C 222      25.579  35.741  61.037  1.00 79.10           C  
ATOM   5807  CG  ASP C 222      25.707  35.597  59.544  1.00 79.77           C  
ATOM   5808  OD1 ASP C 222      26.153  36.569  58.892  1.00 79.96           O  
ATOM   5809  OD2 ASP C 222      25.369  34.512  59.026  1.00 80.31           O  
ATOM   5810  N   SER C 223      22.735  37.676  60.297  1.00 77.68           N  
ATOM   5811  CA  SER C 223      21.330  37.629  59.897  1.00 77.41           C  
ATOM   5812  C   SER C 223      20.813  36.269  59.440  1.00 76.59           C  
ATOM   5813  O   SER C 223      19.622  35.983  59.555  1.00 76.90           O  
ATOM   5814  CB  SER C 223      21.063  38.658  58.799  1.00 78.07           C  
ATOM   5815  OG  SER C 223      19.707  38.607  58.384  1.00 79.55           O  
ATOM   5816  N   VAL C 224      21.699  35.433  58.915  1.00 75.31           N  
ATOM   5817  CA  VAL C 224      21.296  34.110  58.455  1.00 74.03           C  
ATOM   5818  C   VAL C 224      21.343  33.095  59.598  1.00 74.17           C  
ATOM   5819  O   VAL C 224      20.735  32.026  59.520  1.00 73.16           O  
ATOM   5820  CB  VAL C 224      22.200  33.638  57.297  1.00 73.20           C  
ATOM   5821  CG1 VAL C 224      21.786  32.248  56.833  1.00 72.20           C  
ATOM   5822  CG2 VAL C 224      22.121  34.635  56.151  1.00 71.66           C  
ATOM   5823  N   GLU C 225      22.062  33.432  60.665  1.00 75.42           N  
ATOM   5824  CA  GLU C 225      22.166  32.543  61.817  1.00 76.48           C  
ATOM   5825  C   GLU C 225      20.958  32.770  62.722  1.00 75.33           C  
ATOM   5826  O   GLU C 225      20.477  31.850  63.388  1.00 75.04           O  
ATOM   5827  CB  GLU C 225      23.456  32.813  62.597  1.00 78.75           C  
ATOM   5828  CG  GLU C 225      23.923  31.611  63.418  1.00 82.18           C  
ATOM   5829  CD  GLU C 225      25.024  31.955  64.406  1.00 83.78           C  
ATOM   5830  OE1 GLU C 225      25.867  32.825  64.080  1.00 85.26           O  
ATOM   5831  OE2 GLU C 225      25.051  31.343  65.501  1.00 83.87           O  
ATOM   5832  N   LEU C 226      20.476  34.010  62.742  1.00 73.75           N  
ATOM   5833  CA  LEU C 226      19.316  34.373  63.541  1.00 71.76           C  
ATOM   5834  C   LEU C 226      18.108  33.619  63.004  1.00 71.88           C  
ATOM   5835  O   LEU C 226      17.480  32.852  63.726  1.00 71.93           O  
ATOM   5836  CB  LEU C 226      19.060  35.877  63.447  1.00 69.36           C  
ATOM   5837  CG  LEU C 226      17.987  36.416  64.387  1.00 67.24           C  
ATOM   5838  CD1 LEU C 226      18.399  36.154  65.819  1.00 67.24           C  
ATOM   5839  CD2 LEU C 226      17.796  37.899  64.158  1.00 66.48           C  
ATOM   5840  N   ARG C 227      17.798  33.834  61.728  1.00 72.42           N  
ATOM   5841  CA  ARG C 227      16.664  33.176  61.089  1.00 73.05           C  
ATOM   5842  C   ARG C 227      16.713  31.670  61.236  1.00 71.96           C  
ATOM   5843  O   ARG C 227      15.716  30.987  61.029  1.00 72.43           O  
ATOM   5844  CB  ARG C 227      16.593  33.542  59.611  1.00 75.85           C  
ATOM   5845  CG  ARG C 227      16.349  35.013  59.384  1.00 81.21           C  
ATOM   5846  CD  ARG C 227      15.987  35.304  57.938  1.00 85.95           C  
ATOM   5847  NE  ARG C 227      15.691  36.723  57.725  1.00 90.02           N  
ATOM   5848  CZ  ARG C 227      14.752  37.405  58.379  1.00 91.87           C  
ATOM   5849  NH1 ARG C 227      14.003  36.805  59.303  1.00 93.00           N  
ATOM   5850  NH2 ARG C 227      14.561  38.692  58.107  1.00 92.65           N  
ATOM   5851  N   GLU C 228      17.876  31.142  61.582  1.00 70.93           N  
ATOM   5852  CA  GLU C 228      17.987  29.710  61.778  1.00 71.08           C  
ATOM   5853  C   GLU C 228      17.593  29.409  63.223  1.00 69.05           C  
ATOM   5854  O   GLU C 228      16.833  28.478  63.486  1.00 69.13           O  
ATOM   5855  CB  GLU C 228      19.416  29.232  61.521  1.00 74.64           C  
ATOM   5856  CG  GLU C 228      19.619  27.742  61.807  1.00 79.33           C  
ATOM   5857  CD  GLU C 228      21.075  27.388  62.088  1.00 82.93           C  
ATOM   5858  OE1 GLU C 228      21.920  27.561  61.177  1.00 84.72           O  
ATOM   5859  OE2 GLU C 228      21.376  26.944  63.223  1.00 83.85           O  
ATOM   5860  N   LYS C 229      18.109  30.212  64.153  1.00 66.48           N  
ATOM   5861  CA  LYS C 229      17.816  30.038  65.574  1.00 63.23           C  
ATOM   5862  C   LYS C 229      16.357  30.343  65.910  1.00 61.53           C  
ATOM   5863  O   LYS C 229      15.798  29.752  66.834  1.00 61.69           O  
ATOM   5864  CB  LYS C 229      18.739  30.914  66.427  1.00 62.50           C  
ATOM   5865  CG  LYS C 229      20.164  30.397  66.538  1.00 60.82           C  
ATOM   5866  CD  LYS C 229      21.004  31.274  67.452  1.00 59.77           C  
ATOM   5867  CE  LYS C 229      22.373  30.662  67.684  1.00 59.57           C  
ATOM   5868  NZ  LYS C 229      23.183  31.453  68.645  1.00 58.44           N  
ATOM   5869  N   ILE C 230      15.747  31.268  65.172  1.00 58.83           N  
ATOM   5870  CA  ILE C 230      14.343  31.602  65.389  1.00 56.73           C  
ATOM   5871  C   ILE C 230      13.519  30.383  64.996  1.00 57.63           C  
ATOM   5872  O   ILE C 230      12.616  29.960  65.720  1.00 58.57           O  
ATOM   5873  CB  ILE C 230      13.888  32.804  64.517  1.00 54.56           C  
ATOM   5874  CG1 ILE C 230      14.464  34.105  65.074  1.00 54.25           C  
ATOM   5875  CG2 ILE C 230      12.365  32.878  64.475  1.00 52.51           C  
ATOM   5876  CD1 ILE C 230      13.951  35.364  64.382  1.00 53.18           C  
ATOM   5877  N   GLU C 231      13.852  29.811  63.847  1.00 57.76           N  
ATOM   5878  CA  GLU C 231      13.144  28.651  63.337  1.00 58.42           C  
ATOM   5879  C   GLU C 231      13.179  27.460  64.288  1.00 57.28           C  
ATOM   5880  O   GLU C 231      12.329  26.579  64.218  1.00 57.57           O  
ATOM   5881  CB  GLU C 231      13.732  28.239  61.990  1.00 61.48           C  
ATOM   5882  CG  GLU C 231      12.867  27.250  61.239  1.00 66.69           C  
ATOM   5883  CD  GLU C 231      11.559  27.870  60.761  1.00 70.48           C  
ATOM   5884  OE1 GLU C 231      11.244  29.013  61.188  1.00 70.49           O  
ATOM   5885  OE2 GLU C 231      10.848  27.211  59.963  1.00 72.13           O  
ATOM   5886  N   VAL C 232      14.160  27.429  65.173  1.00 56.61           N  
ATOM   5887  CA  VAL C 232      14.276  26.322  66.115  1.00 56.25           C  
ATOM   5888  C   VAL C 232      13.301  26.498  67.267  1.00 56.00           C  
ATOM   5889  O   VAL C 232      12.627  25.552  67.673  1.00 54.78           O  
ATOM   5890  CB  VAL C 232      15.701  26.231  66.687  1.00 56.41           C  
ATOM   5891  CG1 VAL C 232      15.857  24.957  67.518  1.00 54.57           C  
ATOM   5892  CG2 VAL C 232      16.711  26.275  65.551  1.00 56.24           C  
ATOM   5893  N   VAL C 233      13.246  27.718  67.790  1.00 56.56           N  
ATOM   5894  CA  VAL C 233      12.361  28.036  68.899  1.00 57.16           C  
ATOM   5895  C   VAL C 233      10.906  27.902  68.457  1.00 57.91           C  
ATOM   5896  O   VAL C 233      10.071  27.380  69.198  1.00 58.13           O  
ATOM   5897  CB  VAL C 233      12.603  29.478  69.415  1.00 56.80           C  
ATOM   5898  CG1 VAL C 233      11.685  29.774  70.587  1.00 56.84           C  
ATOM   5899  CG2 VAL C 233      14.050  29.648  69.834  1.00 55.86           C  
ATOM   5900  N   ARG C 234      10.609  28.365  67.243  1.00 57.69           N  
ATOM   5901  CA  ARG C 234       9.251  28.298  66.714  1.00 57.97           C  
ATOM   5902  C   ARG C 234       8.775  26.850  66.652  1.00 57.10           C  
ATOM   5903  O   ARG C 234       7.622  26.547  66.950  1.00 57.09           O  
ATOM   5904  CB  ARG C 234       9.205  28.924  65.324  1.00 59.99           C  
ATOM   5905  CG  ARG C 234       7.813  29.282  64.826  1.00 63.92           C  
ATOM   5906  CD  ARG C 234       7.796  29.184  63.320  1.00 67.42           C  
ATOM   5907  NE  ARG C 234       8.294  27.862  62.942  1.00 72.91           N  
ATOM   5908  CZ  ARG C 234       8.429  27.418  61.696  1.00 75.39           C  
ATOM   5909  NH1 ARG C 234       8.102  28.196  60.669  1.00 76.63           N  
ATOM   5910  NH2 ARG C 234       8.890  26.187  61.478  1.00 75.74           N  
ATOM   5911  N   ASN C 235       9.674  25.953  66.274  1.00 56.94           N  
ATOM   5912  CA  ASN C 235       9.354  24.539  66.178  1.00 56.98           C  
ATOM   5913  C   ASN C 235       9.100  23.900  67.524  1.00 56.02           C  
ATOM   5914  O   ASN C 235       8.317  22.963  67.633  1.00 57.02           O  
ATOM   5915  CB  ASN C 235      10.481  23.804  65.466  1.00 59.80           C  
ATOM   5916  CG  ASN C 235      10.228  23.673  63.988  1.00 62.98           C  
ATOM   5917  OD1 ASN C 235       9.464  22.808  63.564  1.00 65.85           O  
ATOM   5918  ND2 ASN C 235      10.846  24.543  63.187  1.00 63.68           N  
ATOM   5919  N   ARG C 236       9.773  24.404  68.549  1.00 55.19           N  
ATOM   5920  CA  ARG C 236       9.612  23.878  69.898  1.00 53.81           C  
ATOM   5921  C   ARG C 236       8.248  24.298  70.450  1.00 51.74           C  
ATOM   5922  O   ARG C 236       7.538  23.487  71.046  1.00 50.45           O  
ATOM   5923  CB  ARG C 236      10.732  24.403  70.798  1.00 56.20           C  
ATOM   5924  CG  ARG C 236      10.711  23.872  72.221  1.00 59.39           C  
ATOM   5925  CD  ARG C 236      11.710  24.627  73.085  1.00 63.54           C  
ATOM   5926  NE  ARG C 236      13.078  24.480  72.596  1.00 67.51           N  
ATOM   5927  CZ  ARG C 236      13.767  23.344  72.651  1.00 70.50           C  
ATOM   5928  NH1 ARG C 236      13.213  22.254  73.178  1.00 72.20           N  
ATOM   5929  NH2 ARG C 236      15.006  23.293  72.176  1.00 71.75           N  
ATOM   5930  N   PHE C 237       7.886  25.566  70.242  1.00 49.20           N  
ATOM   5931  CA  PHE C 237       6.600  26.077  70.713  1.00 47.41           C  
ATOM   5932  C   PHE C 237       5.456  25.247  70.153  1.00 48.31           C  
ATOM   5933  O   PHE C 237       4.620  24.724  70.899  1.00 47.97           O  
ATOM   5934  CB  PHE C 237       6.394  27.536  70.296  1.00 42.95           C  
ATOM   5935  CG  PHE C 237       7.124  28.529  71.150  1.00 39.22           C  
ATOM   5936  CD1 PHE C 237       7.517  28.203  72.444  1.00 36.79           C  
ATOM   5937  CD2 PHE C 237       7.383  29.809  70.673  1.00 38.20           C  
ATOM   5938  CE1 PHE C 237       8.155  29.131  73.248  1.00 35.47           C  
ATOM   5939  CE2 PHE C 237       8.020  30.749  71.471  1.00 37.27           C  
ATOM   5940  CZ  PHE C 237       8.407  30.409  72.763  1.00 37.06           C  
ATOM   5941  N   VAL C 238       5.426  25.143  68.829  1.00 48.68           N  
ATOM   5942  CA  VAL C 238       4.398  24.375  68.148  1.00 49.65           C  
ATOM   5943  C   VAL C 238       4.321  22.957  68.677  1.00 50.51           C  
ATOM   5944  O   VAL C 238       3.258  22.495  69.069  1.00 51.61           O  
ATOM   5945  CB  VAL C 238       4.663  24.308  66.644  1.00 48.87           C  
ATOM   5946  CG1 VAL C 238       3.774  23.251  66.009  1.00 48.62           C  
ATOM   5947  CG2 VAL C 238       4.404  25.668  66.023  1.00 48.89           C  
ATOM   5948  N   GLU C 239       5.452  22.269  68.697  1.00 51.90           N  
ATOM   5949  CA  GLU C 239       5.470  20.899  69.173  1.00 53.91           C  
ATOM   5950  C   GLU C 239       5.010  20.792  70.623  1.00 53.08           C  
ATOM   5951  O   GLU C 239       4.917  19.693  71.167  1.00 53.68           O  
ATOM   5952  CB  GLU C 239       6.869  20.309  69.050  1.00 57.81           C  
ATOM   5953  CG  GLU C 239       6.855  18.788  69.044  1.00 65.62           C  
ATOM   5954  CD  GLU C 239       8.199  18.172  69.395  1.00 69.81           C  
ATOM   5955  OE1 GLU C 239       8.312  16.927  69.311  1.00 72.22           O  
ATOM   5956  OE2 GLU C 239       9.131  18.927  69.761  1.00 72.73           O  
ATOM   5957  N   ASN C 240       4.711  21.927  71.248  1.00 51.93           N  
ATOM   5958  CA  ASN C 240       4.282  21.918  72.642  1.00 49.39           C  
ATOM   5959  C   ASN C 240       2.935  22.564  72.919  1.00 47.30           C  
ATOM   5960  O   ASN C 240       2.554  22.720  74.078  1.00 46.72           O  
ATOM   5961  CB  ASN C 240       5.356  22.567  73.517  1.00 50.04           C  
ATOM   5962  CG  ASN C 240       6.503  21.625  73.820  1.00 49.37           C  
ATOM   5963  OD1 ASN C 240       6.538  20.992  74.871  1.00 49.32           O  
ATOM   5964  ND2 ASN C 240       7.441  21.516  72.888  1.00 50.26           N  
ATOM   5965  N   GLY C 241       2.217  22.954  71.871  1.00 45.39           N  
ATOM   5966  CA  GLY C 241       0.908  23.545  72.088  1.00 43.31           C  
ATOM   5967  C   GLY C 241       0.551  24.841  71.386  1.00 42.25           C  
ATOM   5968  O   GLY C 241      -0.626  25.096  71.150  1.00 42.98           O  
ATOM   5969  N   ALA C 242       1.539  25.662  71.051  1.00 40.42           N  
ATOM   5970  CA  ALA C 242       1.258  26.934  70.398  1.00 39.10           C  
ATOM   5971  C   ALA C 242       0.322  26.789  69.205  1.00 39.16           C  
ATOM   5972  O   ALA C 242       0.465  25.871  68.407  1.00 40.50           O  
ATOM   5973  CB  ALA C 242       2.550  27.579  69.958  1.00 38.74           C  
ATOM   5974  N   HIS C 243      -0.651  27.689  69.098  1.00 39.05           N  
ATOM   5975  CA  HIS C 243      -1.590  27.680  67.976  1.00 39.52           C  
ATOM   5976  C   HIS C 243      -0.981  28.547  66.882  1.00 38.56           C  
ATOM   5977  O   HIS C 243      -1.176  28.313  65.690  1.00 37.93           O  
ATOM   5978  CB  HIS C 243      -2.939  28.281  68.386  1.00 40.98           C  
ATOM   5979  CG  HIS C 243      -3.777  27.382  69.239  1.00 42.99           C  
ATOM   5980  ND1 HIS C 243      -4.687  27.864  70.155  1.00 43.51           N  
ATOM   5981  CD2 HIS C 243      -3.870  26.031  69.295  1.00 43.98           C  
ATOM   5982  CE1 HIS C 243      -5.301  26.852  70.740  1.00 43.45           C  
ATOM   5983  NE2 HIS C 243      -4.825  25.728  70.235  1.00 42.97           N  
ATOM   5984  N   PHE C 244      -0.251  29.566  67.322  1.00 38.16           N  
ATOM   5985  CA  PHE C 244       0.412  30.503  66.437  1.00 38.44           C  
ATOM   5986  C   PHE C 244       1.661  31.028  67.127  1.00 39.70           C  
ATOM   5987  O   PHE C 244       1.718  31.079  68.356  1.00 41.24           O  
ATOM   5988  CB  PHE C 244      -0.510  31.676  66.116  1.00 37.36           C  
ATOM   5989  CG  PHE C 244      -1.829  31.263  65.556  1.00 38.61           C  
ATOM   5990  CD1 PHE C 244      -2.944  31.170  66.372  1.00 38.71           C  
ATOM   5991  CD2 PHE C 244      -1.950  30.927  64.213  1.00 38.86           C  
ATOM   5992  CE1 PHE C 244      -4.164  30.745  65.861  1.00 39.05           C  
ATOM   5993  CE2 PHE C 244      -3.164  30.501  63.691  1.00 38.62           C  
ATOM   5994  CZ  PHE C 244      -4.274  30.409  64.516  1.00 39.27           C  
ATOM   5995  N   THR C 245       2.660  31.408  66.329  1.00 39.98           N  
ATOM   5996  CA  THR C 245       3.913  31.959  66.841  1.00 39.06           C  
ATOM   5997  C   THR C 245       4.118  33.319  66.184  1.00 39.81           C  
ATOM   5998  O   THR C 245       3.571  33.578  65.116  1.00 39.90           O  
ATOM   5999  CB  THR C 245       5.112  31.047  66.509  1.00 38.22           C  
ATOM   6000  OG1 THR C 245       5.117  30.749  65.109  1.00 40.12           O  
ATOM   6001  CG2 THR C 245       5.031  29.750  67.294  1.00 36.30           C  
ATOM   6002  N   ILE C 246       4.876  34.197  66.832  1.00 41.18           N  
ATOM   6003  CA  ILE C 246       5.146  35.527  66.288  1.00 42.04           C  
ATOM   6004  C   ILE C 246       6.514  36.005  66.756  1.00 44.46           C  
ATOM   6005  O   ILE C 246       6.931  35.699  67.876  1.00 45.95           O  
ATOM   6006  CB  ILE C 246       4.074  36.548  66.719  1.00 39.48           C  
ATOM   6007  CG1 ILE C 246       3.882  36.509  68.235  1.00 39.69           C  
ATOM   6008  CG2 ILE C 246       2.775  36.247  66.011  1.00 39.31           C  
ATOM   6009  CD1 ILE C 246       2.913  37.551  68.766  1.00 38.26           C  
ATOM   6010  N   GLU C 247       7.215  36.748  65.897  1.00 45.83           N  
ATOM   6011  CA  GLU C 247       8.549  37.245  66.225  1.00 46.66           C  
ATOM   6012  C   GLU C 247       8.549  38.416  67.192  1.00 46.12           C  
ATOM   6013  O   GLU C 247       9.408  38.497  68.063  1.00 47.36           O  
ATOM   6014  CB  GLU C 247       9.302  37.617  64.953  1.00 48.42           C  
ATOM   6015  CG  GLU C 247       9.647  36.412  64.092  1.00 51.33           C  
ATOM   6016  CD  GLU C 247      10.540  36.767  62.920  1.00 53.17           C  
ATOM   6017  OE1 GLU C 247      10.965  35.841  62.190  1.00 53.63           O  
ATOM   6018  OE2 GLU C 247      10.815  37.973  62.730  1.00 54.05           O  
ATOM   6019  N   THR C 248       7.601  39.331  67.035  1.00 45.61           N  
ATOM   6020  CA  THR C 248       7.493  40.464  67.944  1.00 45.94           C  
ATOM   6021  C   THR C 248       6.026  40.694  68.207  1.00 45.41           C  
ATOM   6022  O   THR C 248       5.182  40.356  67.384  1.00 45.12           O  
ATOM   6023  CB  THR C 248       8.094  41.762  67.373  1.00 46.31           C  
ATOM   6024  OG1 THR C 248       7.435  42.101  66.147  1.00 48.91           O  
ATOM   6025  CG2 THR C 248       9.581  41.598  67.133  1.00 46.54           C  
ATOM   6026  N   MET C 249       5.727  41.279  69.357  1.00 46.60           N  
ATOM   6027  CA  MET C 249       4.352  41.538  69.751  1.00 47.35           C  
ATOM   6028  C   MET C 249       3.568  42.198  68.629  1.00 48.36           C  
ATOM   6029  O   MET C 249       2.354  42.059  68.537  1.00 49.21           O  
ATOM   6030  CB  MET C 249       4.323  42.424  70.998  1.00 45.62           C  
ATOM   6031  CG  MET C 249       3.071  42.246  71.843  1.00 45.16           C  
ATOM   6032  SD  MET C 249       2.843  40.526  72.370  1.00 44.34           S  
ATOM   6033  CE  MET C 249       3.718  40.560  73.948  1.00 44.40           C  
ATOM   6034  N   GLN C 250       4.273  42.884  67.748  1.00 50.90           N  
ATOM   6035  CA  GLN C 250       3.615  43.585  66.665  1.00 54.22           C  
ATOM   6036  C   GLN C 250       2.944  42.737  65.591  1.00 53.41           C  
ATOM   6037  O   GLN C 250       2.614  43.237  64.520  1.00 54.50           O  
ATOM   6038  CB  GLN C 250       4.598  44.572  66.053  1.00 57.95           C  
ATOM   6039  CG  GLN C 250       5.057  45.585  67.076  1.00 64.53           C  
ATOM   6040  CD  GLN C 250       6.402  46.153  66.739  1.00 69.58           C  
ATOM   6041  OE1 GLN C 250       6.520  47.041  65.890  1.00 73.35           O  
ATOM   6042  NE2 GLN C 250       7.445  45.625  67.384  1.00 72.12           N  
ATOM   6043  N   GLU C 251       2.727  41.460  65.870  1.00 52.06           N  
ATOM   6044  CA  GLU C 251       2.039  40.609  64.911  1.00 50.48           C  
ATOM   6045  C   GLU C 251       0.767  40.078  65.578  1.00 49.64           C  
ATOM   6046  O   GLU C 251      -0.051  39.422  64.938  1.00 49.86           O  
ATOM   6047  CB  GLU C 251       2.936  39.453  64.475  1.00 50.22           C  
ATOM   6048  CG  GLU C 251       4.299  39.898  63.988  1.00 52.56           C  
ATOM   6049  CD  GLU C 251       5.152  38.747  63.475  1.00 55.22           C  
ATOM   6050  OE1 GLU C 251       6.373  38.956  63.293  1.00 57.35           O  
ATOM   6051  OE2 GLU C 251       4.610  37.639  63.248  1.00 55.09           O  
ATOM   6052  N   LEU C 252       0.603  40.393  66.864  1.00 47.71           N  
ATOM   6053  CA  LEU C 252      -0.549  39.952  67.650  1.00 45.96           C  
ATOM   6054  C   LEU C 252      -1.894  40.367  67.048  1.00 46.96           C  
ATOM   6055  O   LEU C 252      -2.744  39.515  66.782  1.00 47.19           O  
ATOM   6056  CB  LEU C 252      -0.439  40.484  69.080  1.00 41.18           C  
ATOM   6057  CG  LEU C 252      -1.425  39.916  70.098  1.00 37.24           C  
ATOM   6058  CD1 LEU C 252      -1.083  38.475  70.393  1.00 35.14           C  
ATOM   6059  CD2 LEU C 252      -1.358  40.731  71.366  1.00 36.64           C  
ATOM   6060  N   GLU C 253      -2.089  41.669  66.839  1.00 47.85           N  
ATOM   6061  CA  GLU C 253      -3.332  42.184  66.254  1.00 48.73           C  
ATOM   6062  C   GLU C 253      -3.700  41.334  65.045  1.00 48.88           C  
ATOM   6063  O   GLU C 253      -4.831  40.867  64.897  1.00 48.46           O  
ATOM   6064  CB  GLU C 253      -3.145  43.626  65.786  1.00 50.69           C  
ATOM   6065  CG  GLU C 253      -2.740  44.605  66.866  1.00 55.10           C  
ATOM   6066  CD  GLU C 253      -3.892  45.476  67.320  1.00 57.42           C  
ATOM   6067  OE1 GLU C 253      -4.876  44.932  67.865  1.00 59.19           O  
ATOM   6068  OE2 GLU C 253      -3.816  46.707  67.127  1.00 58.80           O  
ATOM   6069  N   SER C 254      -2.717  41.144  64.176  1.00 48.45           N  
ATOM   6070  CA  SER C 254      -2.902  40.363  62.971  1.00 47.43           C  
ATOM   6071  C   SER C 254      -3.435  38.960  63.274  1.00 46.28           C  
ATOM   6072  O   SER C 254      -4.381  38.502  62.635  1.00 45.90           O  
ATOM   6073  CB  SER C 254      -1.572  40.272  62.220  1.00 48.11           C  
ATOM   6074  OG  SER C 254      -1.756  39.719  60.930  1.00 50.52           O  
ATOM   6075  N   VAL C 255      -2.835  38.283  64.250  1.00 45.45           N  
ATOM   6076  CA  VAL C 255      -3.256  36.931  64.607  1.00 44.08           C  
ATOM   6077  C   VAL C 255      -4.694  36.918  65.098  1.00 43.71           C  
ATOM   6078  O   VAL C 255      -5.459  36.016  64.762  1.00 42.14           O  
ATOM   6079  CB  VAL C 255      -2.356  36.319  65.696  1.00 43.78           C  
ATOM   6080  CG1 VAL C 255      -2.797  34.897  65.997  1.00 43.90           C  
ATOM   6081  CG2 VAL C 255      -0.916  36.321  65.234  1.00 43.27           C  
ATOM   6082  N   MET C 256      -5.059  37.912  65.899  1.00 44.99           N  
ATOM   6083  CA  MET C 256      -6.423  37.991  66.408  1.00 46.48           C  
ATOM   6084  C   MET C 256      -7.363  37.945  65.215  1.00 46.50           C  
ATOM   6085  O   MET C 256      -8.231  37.078  65.136  1.00 45.60           O  
ATOM   6086  CB  MET C 256      -6.640  39.292  67.190  1.00 47.07           C  
ATOM   6087  CG  MET C 256      -6.090  39.280  68.602  1.00 49.51           C  
ATOM   6088  SD  MET C 256      -6.173  40.906  69.410  1.00 55.51           S  
ATOM   6089  CE  MET C 256      -7.975  41.056  69.751  1.00 52.92           C  
ATOM   6090  N   GLU C 257      -7.167  38.882  64.289  1.00 47.37           N  
ATOM   6091  CA  GLU C 257      -7.968  38.975  63.078  1.00 48.54           C  
ATOM   6092  C   GLU C 257      -8.161  37.604  62.477  1.00 48.05           C  
ATOM   6093  O   GLU C 257      -9.282  37.205  62.179  1.00 49.56           O  
ATOM   6094  CB  GLU C 257      -7.269  39.858  62.060  1.00 52.43           C  
ATOM   6095  CG  GLU C 257      -7.195  41.308  62.463  1.00 59.89           C  
ATOM   6096  CD  GLU C 257      -8.327  42.122  61.873  1.00 64.57           C  
ATOM   6097  OE1 GLU C 257      -8.358  42.275  60.625  1.00 66.30           O  
ATOM   6098  OE2 GLU C 257      -9.186  42.602  62.651  1.00 68.47           O  
ATOM   6099  N   HIS C 258      -7.064  36.882  62.290  1.00 47.00           N  
ATOM   6100  CA  HIS C 258      -7.139  35.542  61.726  1.00 45.18           C  
ATOM   6101  C   HIS C 258      -8.153  34.726  62.520  1.00 44.40           C  
ATOM   6102  O   HIS C 258      -9.070  34.155  61.944  1.00 44.07           O  
ATOM   6103  CB  HIS C 258      -5.768  34.864  61.767  1.00 44.44           C  
ATOM   6104  CG  HIS C 258      -5.768  33.476  61.207  1.00 43.80           C  
ATOM   6105  ND1 HIS C 258      -5.975  33.214  59.871  1.00 43.88           N  
ATOM   6106  CD2 HIS C 258      -5.612  32.272  61.805  1.00 45.93           C  
ATOM   6107  CE1 HIS C 258      -5.947  31.908  59.670  1.00 45.36           C  
ATOM   6108  NE2 HIS C 258      -5.730  31.312  60.829  1.00 45.09           N  
ATOM   6109  N   ILE C 259      -7.986  34.680  63.842  1.00 44.59           N  
ATOM   6110  CA  ILE C 259      -8.908  33.941  64.706  1.00 44.31           C  
ATOM   6111  C   ILE C 259     -10.320  34.471  64.411  1.00 44.47           C  
ATOM   6112  O   ILE C 259     -11.257  33.696  64.206  1.00 43.82           O  
ATOM   6113  CB  ILE C 259      -8.597  34.177  66.218  1.00 44.66           C  
ATOM   6114  CG1 ILE C 259      -7.087  34.080  66.491  1.00 43.64           C  
ATOM   6115  CG2 ILE C 259      -9.339  33.131  67.069  1.00 44.32           C  
ATOM   6116  CD1 ILE C 259      -6.592  32.687  66.835  1.00 41.61           C  
ATOM   6117  N   GLU C 260     -10.436  35.802  64.386  1.00 44.12           N  
ATOM   6118  CA  GLU C 260     -11.677  36.542  64.116  1.00 43.57           C  
ATOM   6119  C   GLU C 260     -12.398  37.023  65.381  1.00 44.19           C  
ATOM   6120  O   GLU C 260     -12.253  38.185  65.798  1.00 43.06           O  
ATOM   6121  CB  GLU C 260     -12.626  35.718  63.223  1.00 41.83           C  
ATOM   6122  CG  GLU C 260     -12.506  36.079  61.744  1.00 43.24           C  
ATOM   6123  CD  GLU C 260     -12.328  34.877  60.812  1.00 45.22           C  
ATOM   6124  OE1 GLU C 260     -12.150  35.116  59.603  1.00 44.33           O  
ATOM   6125  OE2 GLU C 260     -12.364  33.705  61.265  1.00 46.43           O  
TER    6126      GLU C 260                                                      
END
MOLECULE T0418_2_16_86_211.pdb
ATOM      1  N   LYS     2     -13.076  35.543  67.613  1.00 29.62          
ATOM      2  CA  LYS     2     -12.478  36.834  68.052  0.50 29.11          
ATOM      4  CB  LYS     2     -13.375  38.010  67.650  0.50 29.29          
ATOM      6  CG  LYS     2     -12.641  39.346  67.502  0.50 28.70          
ATOM      8  CD  LYS     2     -13.620  40.472  67.149  0.50 28.45          
ATOM     10  CE  LYS     2     -14.745  40.631  68.215  0.50 27.78          
ATOM     12  NZ  LYS     2     -14.212  40.910  69.618  0.50 23.90          
ATOM     14  C   LYS     2     -12.217  36.842  69.559  1.00 29.22          
ATOM     15  O   LYS     2     -13.013  36.324  70.358  1.00 29.48          
ATOM     16  N   TYR     3     -11.081  37.413  69.934  1.00 28.23          
ATOM     17  CA  TYR     3     -10.713  37.511  71.337  1.00 28.13          
ATOM     18  CB  TYR     3      -9.228  37.205  71.499  1.00 27.69          
ATOM     19  CG  TYR     3      -8.855  35.913  70.851  1.00 27.85          
ATOM     20  CD1 TYR     3      -9.318  34.695  71.359  1.00 27.15          
ATOM     21  CE1 TYR     3      -8.963  33.481  70.741  1.00 29.48          
ATOM     22  CZ  TYR     3      -8.150  33.512  69.615  1.00 28.31          
ATOM     23  OH  TYR     3      -7.781  32.362  68.998  1.00 29.71          
ATOM     24  CE2 TYR     3      -7.689  34.704  69.099  1.00 28.68          
ATOM     25  CD2 TYR     3      -8.054  35.901  69.711  1.00 28.20          
ATOM     26  C   TYR     3     -11.028  38.898  71.895  1.00 27.71          
ATOM     27  O   TYR     3     -10.756  39.901  71.237  1.00 28.58          
ATOM     28  N   THR     4     -11.608  38.949  73.092  1.00 26.98          
ATOM     29  CA  THR     4     -11.921  40.233  73.752  1.00 26.26          
ATOM     30  CB  THR     4     -13.434  40.362  74.092  1.00 25.63          
ATOM     31  OG1 THR     4     -13.795  39.364  75.050  1.00 24.05          
ATOM     32  CG2 THR     4     -14.272  40.199  72.862  1.00 25.42          
ATOM     33  C   THR     4     -11.088  40.424  75.028  1.00 26.20          
ATOM     34  O   THR     4     -11.218  41.432  75.726  1.00 26.38          
ATOM     35  N   VAL     5     -10.260  39.424  75.320  1.00 26.09          
ATOM     36  CA  VAL     5      -9.387  39.390  76.487  1.00 25.98          
ATOM     37  CB  VAL     5      -9.988  38.533  77.656  1.00 26.21          
ATOM     38  CG1 VAL     5      -9.003  38.455  78.853  1.00 25.67          
ATOM     39  CG2 VAL     5     -11.398  39.033  78.080  1.00 25.14          
ATOM     40  C   VAL     5      -8.026  38.798  76.069  1.00 26.19          
ATOM     41  O   VAL     5      -7.939  37.642  75.627  1.00 25.71          
ATOM     42  N   TYR     6      -6.974  39.596  76.199  1.00 25.76          
ATOM     43  CA  TYR     6      -5.616  39.122  75.949  1.00 25.47          
ATOM     44  CB  TYR     6      -4.867  40.089  75.019  1.00 25.89          
ATOM     45  CG  TYR     6      -5.233  40.042  73.546  1.00 26.06          
ATOM     46  CD1 TYR     6      -6.573  40.059  73.118  1.00 27.09          
ATOM     47  CE1 TYR     6      -6.905  40.033  71.753  1.00 27.02          
ATOM     48  CZ  TYR     6      -5.886  40.001  70.813  1.00 26.83          
ATOM     49  OH  TYR     6      -6.181  39.980  69.480  1.00 25.05          
ATOM     50  CE2 TYR     6      -4.551  40.012  71.213  1.00 25.46          
ATOM     51  CD2 TYR     6      -4.234  40.029  72.575  1.00 26.76          
ATOM     52  C   TYR     6      -4.877  39.026  77.278  1.00 25.08          
ATOM     53  O   TYR     6      -4.674  40.032  77.943  1.00 24.69          
ATOM     54  N   LEU     7      -4.487  37.816  77.670  1.00 24.54          
ATOM     55  CA  LEU     7      -3.771  37.624  78.929  1.00 24.14          
ATOM     56  CB  LEU     7      -4.383  36.496  79.763  1.00 23.59          
ATOM     57  CG  LEU     7      -5.870  36.734  80.138  1.00 24.16          
ATOM     58  CD1 LEU     7      -6.521  35.534  80.774  1.00 20.62          
ATOM     59  CD2 LEU     7      -6.014  37.958  81.059  1.00 22.12          
ATOM     60  C   LEU     7      -2.323  37.335  78.582  1.00 24.96          
ATOM     61  O   LEU     7      -2.027  36.555  77.668  1.00 24.77          
ATOM     62  N   PHE     8      -1.430  38.000  79.300  1.00 25.46          
ATOM     63  CA  PHE     8      -0.011  37.932  79.019  1.00 25.12          
ATOM     64  CB  PHE     8       0.536  39.346  78.747  1.00 24.90          
ATOM     65  CG  PHE     8      -0.072  40.030  77.537  1.00 23.20          
ATOM     66  CD1 PHE     8       0.543  39.933  76.300  1.00 20.97          
ATOM     67  CE1 PHE     8       0.002  40.554  75.184  1.00 23.26          
ATOM     68  CZ  PHE     8      -1.183  41.317  75.319  1.00 23.30          
ATOM     69  CE2 PHE     8      -1.795  41.414  76.551  1.00 22.61          
ATOM     70  CD2 PHE     8      -1.243  40.770  77.646  1.00 23.59          
ATOM     71  C   PHE     8       0.758  37.332  80.185  1.00 25.42          
ATOM     72  O   PHE     8       0.489  37.647  81.349  1.00 24.56          
ATOM     73  N   ASP     9       1.705  36.454  79.854  1.00 25.13          
ATOM     74  CA  ASP     9       2.868  36.191  80.698  1.00 25.05          
ATOM     75  CB  ASP     9       3.770  35.134  80.038  1.00 25.36          
ATOM     76  CG  ASP     9       4.800  34.591  80.993  1.00 26.68          
ATOM     77  OD1 ASP     9       4.592  34.704  82.202  1.00 34.85          
ATOM     78  OD2 ASP     9       5.854  34.101  80.583  1.00 35.24          
ATOM     79  C   ASP     9       3.678  37.487  80.915  1.00 24.97          
ATOM     80  O   ASP     9       3.511  38.454  80.172  1.00 26.37          
ATOM     81  N   PHE    10       4.517  37.529  81.947  1.00 23.63          
ATOM     82  CA  PHE    10       5.322  38.732  82.245  1.00 23.16          
ATOM     83  CB  PHE    10       5.224  39.137  83.733  1.00 22.29          
ATOM     84  CG  PHE    10       5.966  40.422  84.054  1.00 22.99          
ATOM     85  CD1 PHE    10       5.373  41.665  83.808  1.00 24.77          
ATOM     86  CE1 PHE    10       6.080  42.878  84.084  1.00 24.55          
ATOM     87  CZ  PHE    10       7.384  42.826  84.610  1.00 22.62          
ATOM     88  CE2 PHE    10       7.982  41.589  84.874  1.00 24.73          
ATOM     89  CD2 PHE    10       7.276  40.382  84.582  1.00 23.46          
ATOM     90  C   PHE    10       6.773  38.604  81.815  1.00 22.66          
ATOM     91  O   PHE    10       7.185  39.218  80.841  1.00 23.91          
ATOM     92  N   ASP    11       7.552  37.779  82.507  1.00 23.43          
ATOM     93  CA  ASP    11       8.986  37.643  82.204  1.00 23.44          
ATOM     94  CB  ASP    11       9.664  36.690  83.184  1.00 23.10          
ATOM     95  CG  ASP    11       9.732  37.232  84.591  1.00 24.03          
ATOM     96  OD1 ASP    11      10.159  38.406  84.796  1.00 24.46          
ATOM     97  OD2 ASP    11       9.374  36.443  85.514  1.00 23.52          
ATOM     98  C   ASP    11       9.215  37.131  80.776  1.00 23.25          
ATOM     99  O   ASP    11       8.635  36.114  80.385  1.00 23.39          
ATOM    100  N   TYR    12      10.044  37.839  80.001  1.00 21.78          
ATOM    101  CA  TYR    12      10.289  37.470  78.592  1.00 19.73          
ATOM    102  CB  TYR    12      10.756  36.006  78.503  1.00 20.19          
ATOM    103  CG  TYR    12      12.274  35.815  78.587  1.00 18.57          
ATOM    104  CD1 TYR    12      13.161  36.790  78.106  1.00 19.37          
ATOM    105  CE1 TYR    12      14.573  36.569  78.131  1.00 17.76          
ATOM    106  CZ  TYR    12      15.053  35.376  78.655  1.00 20.36          
ATOM    107  OH  TYR    12      16.419  35.108  78.707  1.00 20.14          
ATOM    108  CE2 TYR    12      14.181  34.426  79.131  1.00 19.24          
ATOM    109  CD2 TYR    12      12.810  34.625  79.069  1.00 19.14          
ATOM    110  C   TYR    12       9.134  37.682  77.617  1.00 20.20          
ATOM    111  O   TYR    12       9.239  37.335  76.430  1.00 18.25          
ATOM    112  N   THR    13       8.026  38.225  78.105  1.00 19.18          
ATOM    113  CA  THR    13       6.883  38.448  77.261  1.00 20.06          
ATOM    114  CB  THR    13       5.674  37.608  77.705  1.00 19.89          
ATOM    115  OG1 THR    13       5.969  36.211  77.494  1.00 21.97          
ATOM    116  CG2 THR    13       4.465  37.998  76.843  1.00 19.00          
ATOM    117  C   THR    13       6.536  39.943  77.240  1.00 19.72          
ATOM    118  O   THR    13       6.575  40.562  76.173  1.00 19.50          
ATOM    119  N   LEU    14       6.246  40.526  78.410  1.00 19.60          
ATOM    120  CA  LEU    14       5.990  41.979  78.467  1.00 20.37          
ATOM    121  CB  LEU    14       4.878  42.310  79.457  1.00 19.90          
ATOM    122  CG  LEU    14       3.462  41.924  79.113  1.00 21.71          
ATOM    123  CD1 LEU    14       2.570  42.180  80.336  1.00 22.39          
ATOM    124  CD2 LEU    14       2.910  42.633  77.863  1.00 25.95          
ATOM    125  C   LEU    14       7.227  42.813  78.792  1.00 20.70          
ATOM    126  O   LEU    14       7.279  44.014  78.491  1.00 21.38          
ATOM    127  N   ALA    15       8.195  42.183  79.445  1.00 20.70          
ATOM    128  CA  ALA    15       9.386  42.843  79.946  1.00 21.53          
ATOM    129  CB  ALA    15       9.167  43.257  81.419  1.00 22.22          
ATOM    130  C   ALA    15      10.568  41.890  79.847  1.00 21.56          
ATOM    131  O   ALA    15      10.417  40.686  80.082  1.00 20.75          
ATOM    132  N   ASP    16      11.748  42.401  79.485  1.00 21.65          
ATOM    133  CA  ASP    16      12.918  41.546  79.546  1.00 21.72          
ATOM    134  CB  ASP    16      13.931  41.880  78.453  1.00 22.91          
ATOM    135  CG  ASP    16      15.158  40.970  78.479  1.00 22.98          
ATOM    136  OD1 ASP    16      15.256  40.068  79.357  1.00 22.97          
ATOM    137  OD2 ASP    16      16.035  41.171  77.614  1.00 21.32          
ATOM    138  C   ASP    16      13.533  41.709  80.935  1.00 22.65          
ATOM    139  O   ASP    16      14.294  42.647  81.179  1.00 22.64          
ATOM    716  N   ILE    86      13.762  45.639  81.713  1.00 23.54          
ATOM    717  CA  ILE    86      13.426  46.681  80.718  1.00 22.56          
ATOM    718  CB  ILE    86      14.574  46.876  79.682  1.00 23.19          
ATOM    719  CG1 ILE    86      14.888  45.576  78.937  1.00 21.71          
ATOM    720  CD  ILE    86      15.941  45.757  77.811  1.00 21.68          
ATOM    721  CG2 ILE    86      15.863  47.412  80.376  1.00 24.58          
ATOM    722  C   ILE    86      12.104  46.310  80.016  1.00 22.41          
ATOM    723  O   ILE    86      11.770  45.125  79.931  1.00 22.12          
ATOM    724  N   LEU    87      11.383  47.301  79.495  1.00 20.46          
ATOM    725  CA  LEU    87      10.271  47.047  78.556  1.00 21.06          
ATOM    726  CB  LEU    87       9.527  48.370  78.228  1.00 20.51          
ATOM    727  CG  LEU    87       8.794  49.100  79.348  1.00 20.09          
ATOM    728  CD1 LEU    87       8.384  50.552  78.995  1.00 16.88          
ATOM    729  CD2 LEU    87       7.596  48.304  79.781  1.00 18.68          
ATOM    730  C   LEU    87      10.799  46.471  77.222  1.00 21.20          
ATOM    731  O   LEU    87      11.927  46.754  76.831  1.00 21.66          
ATOM    732  N   PHE    88       9.987  45.674  76.538  1.00 20.05          
ATOM    733  CA  PHE    88      10.257  45.319  75.142  1.00 20.27          
ATOM    734  CB  PHE    88       9.515  44.018  74.724  1.00 19.56          
ATOM    735  CG  PHE    88      10.201  42.735  75.188  1.00 20.59          
ATOM    736  CD1 PHE    88      11.463  42.382  74.702  1.00 23.45          
ATOM    737  CE1 PHE    88      12.081  41.228  75.105  1.00 22.55          
ATOM    738  CZ  PHE    88      11.481  40.419  76.026  1.00 20.15          
ATOM    739  CE2 PHE    88      10.225  40.743  76.509  1.00 24.68          
ATOM    740  CD2 PHE    88       9.595  41.893  76.090  1.00 21.23          
ATOM    741  C   PHE    88       9.828  46.473  74.259  1.00 20.40          
ATOM    742  O   PHE    88       8.905  47.226  74.628  1.00 21.31          
ATOM    743  N   PRO    89      10.505  46.651  73.100  1.00 20.26          
ATOM    744  CA  PRO    89      10.186  47.730  72.178  1.00 20.40          
ATOM    745  CB  PRO    89      11.007  47.367  70.922  1.00 20.36          
ATOM    746  CG  PRO    89      12.204  46.716  71.480  1.00 21.73          
ATOM    747  CD  PRO    89      11.653  45.860  72.614  1.00 20.33          
ATOM    748  C   PRO    89       8.712  47.879  71.828  1.00 20.08          
ATOM    749  O   PRO    89       8.274  48.994  71.528  1.00 20.03          
ATOM    750  N   ASP    90       7.968  46.772  71.838  1.00 20.35          
ATOM    751  CA  ASP    90       6.579  46.769  71.395  1.00 20.75          
ATOM    752  CB  ASP    90       6.297  45.545  70.510  1.00 21.27          
ATOM    753  CG  ASP    90       7.023  45.583  69.186  1.00 22.79          
ATOM    754  OD1 ASP    90       7.466  46.661  68.743  1.00 24.07          
ATOM    755  OD2 ASP    90       7.119  44.521  68.561  1.00 25.29          
ATOM    756  C   ASP    90       5.548  46.757  72.517  1.00 20.34          
ATOM    757  O   ASP    90       4.351  46.681  72.247  1.00 20.78          
ATOM    758  N   THR    91       5.989  46.807  73.765  1.00 20.54          
ATOM    759  CA  THR    91       5.087  46.550  74.890  1.00 19.97          
ATOM    760  CB  THR    91       5.857  46.390  76.213  1.00 19.95          
ATOM    761  OG1 THR    91       6.664  45.219  76.137  1.00 22.13          
ATOM    762  CG2 THR    91       4.911  46.239  77.384  1.00 20.27          
ATOM    763  C   THR    91       4.029  47.633  75.011  1.00 19.15          
ATOM    764  O   THR    91       2.838  47.342  75.001  1.00 18.57          
ATOM    765  N   LEU    92       4.478  48.877  75.141  1.00 18.33          
ATOM    766  CA  LEU    92       3.569  49.989  75.332  1.00 18.26          
ATOM    767  CB  LEU    92       4.323  51.266  75.763  1.00 17.66          
ATOM    768  CG  LEU    92       5.227  51.281  77.007  1.00 15.19          
ATOM    769  CD1 LEU    92       5.965  52.631  77.097  1.00 11.30          
ATOM    770  CD2 LEU    92       4.395  51.084  78.225  1.00 16.51          
ATOM    771  C   LEU    92       2.692  50.262  74.103  1.00 18.76          
ATOM    772  O   LEU    92       1.479  50.461  74.258  1.00 20.01          
ATOM    773  N   PRO    93       3.285  50.318  72.885  1.00 18.59          
ATOM    774  CA  PRO    93       2.364  50.587  71.758  1.00 18.67          
ATOM    775  CB  PRO    93       3.292  50.693  70.536  1.00 18.83          
ATOM    776  CG  PRO    93       4.698  50.769  71.074  1.00 18.40          
ATOM    777  CD  PRO    93       4.685  50.178  72.449  1.00 18.35          
ATOM    778  C   PRO    93       1.340  49.477  71.546  1.00 18.83          
ATOM    779  O   PRO    93       0.227  49.749  71.129  1.00 18.94          
ATOM    780  N   THR    94       1.708  48.232  71.826  1.00 19.04          
ATOM    781  CA  THR    94       0.799  47.110  71.575  1.00 18.95          
ATOM    782  CB  THR    94       1.516  45.739  71.710  1.00 19.65          
ATOM    783  OG1 THR    94       2.523  45.622  70.690  1.00 19.01          
ATOM    784  CG2 THR    94       0.513  44.590  71.527  1.00 18.15          
ATOM    785  C   THR    94      -0.385  47.186  72.529  1.00 19.25          
ATOM    786  O   THR    94      -1.541  47.153  72.113  1.00 19.28          
ATOM    787  N   LEU    95      -0.073  47.296  73.816  1.00 19.96          
ATOM    788  CA  LEU    95      -1.064  47.294  74.859  1.00 20.68          
ATOM    789  CB  LEU    95      -0.380  47.224  76.227  1.00 21.67          
ATOM    790  CG  LEU    95       0.341  45.925  76.619  1.00 22.31          
ATOM    791  CD1 LEU    95       0.903  46.007  78.025  1.00 26.20          
ATOM    792  CD2 LEU    95      -0.599  44.775  76.550  1.00 26.86          
ATOM    793  C   LEU    95      -1.964  48.513  74.739  1.00 21.16          
ATOM    794  O   LEU    95      -3.156  48.409  75.010  1.00 21.22          
ATOM    795  N   THR    96      -1.408  49.655  74.304  1.00 21.25          
ATOM    796  CA  THR    96      -2.213  50.844  74.008  1.00 21.22          
ATOM    797  CB  THR    96      -1.338  52.040  73.563  1.00 21.29          
ATOM    798  OG1 THR    96      -0.447  52.403  74.605  1.00 22.50          
ATOM    799  CG2 THR    96      -2.194  53.256  73.207  1.00 21.56          
ATOM    800  C   THR    96      -3.212  50.575  72.883  1.00 21.43          
ATOM    801  O   THR    96      -4.374  50.993  72.946  1.00 20.99          
ATOM    802  N   HSD    97      -2.737  49.910  71.833  1.00 21.94          
ATOM    803  CA  HSD    97      -3.573  49.581  70.677  1.00 22.43          
ATOM    804  CB  HSD    97      -2.729  48.978  69.553  1.00 22.64          
ATOM    805  CG  HSD    97      -3.449  48.856  68.245  1.00 25.32          
ATOM    806  ND1 HSD    97      -4.263  47.784  67.938  1.00 28.13          
ATOM    807  CE1 HSD    97      -4.763  47.944  66.725  1.00 28.68          
ATOM    808  NE2 HSD    97      -4.302  49.081  66.232  1.00 29.53          
ATOM    809  CD2 HSD    97      -3.471  49.667  67.160  1.00 26.78          
ATOM    810  C   HSD    97      -4.720  48.648  71.076  1.00 22.49          
ATOM    811  O   HSD    97      -5.854  48.863  70.656  1.00 22.54          
ATOM    812  N   LEU    98      -4.430  47.629  71.890  1.00 22.90          
ATOM    813  CA  LEU    98      -5.458  46.702  72.362  1.00 23.05          
ATOM    814  CB  LEU    98      -4.842  45.521  73.120  1.00 22.74          
ATOM    815  CG  LEU    98      -3.923  44.586  72.326  1.00 20.64          
ATOM    816  CD1 LEU    98      -3.169  43.591  73.244  1.00 19.50          
ATOM    817  CD2 LEU    98      -4.696  43.869  71.205  1.00 15.85          
ATOM    818  C   LEU    98      -6.521  47.403  73.206  1.00 24.50          
ATOM    819  O   LEU    98      -7.726  47.184  73.018  1.00 24.67          
ATOM    820  N   LYS    99      -6.088  48.277  74.109  1.00 25.44          
ATOM    821  CA  LYS    99      -7.014  48.998  74.982  1.00 26.42          
ATOM    822  CB  LYS    99      -6.260  49.699  76.127  1.00 26.77          
ATOM    823  CG  LYS    99      -5.628  48.723  77.140  1.00 26.71          
ATOM    824  CD  LYS    99      -4.999  49.441  78.340  1.00 26.66          
ATOM    825  CE  LYS    99      -6.024  50.184  79.192  1.00 27.89          
ATOM    826  NZ  LYS    99      -6.935  49.263  79.920  1.00 27.25          
ATOM    827  C   LYS    99      -7.900  49.979  74.213  1.00 26.96          
ATOM    828  O   LYS    99      -9.057  50.203  74.591  1.00 27.40          
ATOM    829  N   LYS   100      -7.366  50.550  73.134  1.00 27.31          
ATOM    830  CA  LYS   100      -8.170  51.373  72.221  1.00 27.99          
ATOM    831  CB  LYS   100      -7.292  52.088  71.196  1.00 27.98          
ATOM    832  CG  LYS   100      -6.720  53.359  71.726  1.00 28.10          
ATOM    833  CD  LYS   100      -5.347  53.618  71.174  1.00 28.05          
ATOM    834  CE  LYS   100      -4.886  55.015  71.598  1.00 27.96          
ATOM    835  NZ  LYS   100      -3.640  55.417  70.892  1.00 27.88          
ATOM    836  C   LYS   100      -9.232  50.545  71.508  1.00 28.41          
ATOM    837  O   LYS   100     -10.315  51.042  71.219  1.00 28.22          
ATOM    838  N   GLN   101      -8.914  49.284  71.229  1.00 28.51          
ATOM    839  CA  GLN   101      -9.890  48.354  70.668  1.00 29.51          
ATOM    840  CB  GLN   101      -9.191  47.086  70.149  1.00 29.23          
ATOM    841  CG  GLN   101      -8.506  47.273  68.804  1.00 30.53          
ATOM    842  CD  GLN   101      -7.812  46.019  68.316  1.00 31.28          
ATOM    843  OE1 GLN   101      -6.947  45.463  68.993  1.00 33.95          
ATOM    844  NE2 GLN   101      -8.189  45.565  67.126  1.00 33.53          
ATOM    845  C   GLN   101     -10.974  47.988  71.693  1.00 28.92          
ATOM    846  O   GLN   101     -12.006  47.445  71.332  1.00 29.19          
ATOM    847  N   GLY   102     -10.732  48.279  72.970  1.00 28.44          
ATOM    848  CA  GLY   102     -11.660  47.886  74.028  1.00 27.66          
ATOM    849  C   GLY   102     -11.490  46.434  74.428  1.00 26.90          
ATOM    850  O   GLY   102     -12.374  45.836  75.033  1.00 27.53          
ATOM    851  N   ILE   103     -10.357  45.856  74.068  1.00 25.97          
ATOM    852  CA  ILE   103      -9.954  44.571  74.592  1.00 25.15          
ATOM    853  CB  ILE   103      -8.891  43.916  73.657  1.00 25.72          
ATOM    854  CG1 ILE   103      -9.598  43.387  72.394  1.00 28.75          
ATOM    855  CD  ILE   103      -8.858  43.602  71.071  1.00 32.21          
ATOM    856  CG2 ILE   103      -8.148  42.768  74.356  1.00 24.81          
ATOM    857  C   ILE   103      -9.470  44.760  76.047  1.00 24.11          
ATOM    858  O   ILE   103      -8.841  45.775  76.378  1.00 23.64          
ATOM    859  N   ARG   104      -9.836  43.809  76.905  1.00 22.93          
ATOM    860  CA  ARG   104      -9.393  43.739  78.295  1.00 22.38          
ATOM    861  CB  ARG   104     -10.432  43.052  79.189  1.00 21.82          
ATOM    862  CG  ARG   104     -11.639  43.963  79.511  1.00 22.99          
ATOM    863  CD  ARG   104     -12.555  43.350  80.543  1.00 23.79          
ATOM    864  NE  ARG   104     -13.217  42.158  80.016  1.00 26.02          
ATOM    865  CZ  ARG   104     -13.959  41.322  80.739  1.00 26.04          
ATOM    866  NH1 ARG   104     -14.138  41.542  82.034  1.00 25.71          
ATOM    867  NH2 ARG   104     -14.514  40.259  80.165  1.00 24.78          
ATOM    868  C   ARG   104      -8.044  43.011  78.368  1.00 22.15          
ATOM    869  O   ARG   104      -7.842  41.976  77.722  1.00 22.69          
ATOM    870  N   ILE   105      -7.113  43.562  79.132  1.00 21.37          
ATOM    871  CA  ILE   105      -5.799  42.950  79.221  1.00 21.36          
ATOM    872  CB  ILE   105      -4.685  43.845  78.615  1.00 21.45          
ATOM    873  CG1 ILE   105      -4.622  45.208  79.317  1.00 21.21          
ATOM    874  CD  ILE   105      -3.372  46.006  78.973  1.00 20.99          
ATOM    875  CG2 ILE   105      -4.901  44.025  77.098  1.00 22.71          
ATOM    876  C   ILE   105      -5.508  42.545  80.651  1.00 21.31          
ATOM    877  O   ILE   105      -6.029  43.114  81.590  1.00 21.58          
ATOM    878  N   GLY   106      -4.696  41.517  80.814  1.00 21.48          
ATOM    879  CA  GLY   106      -4.307  41.082  82.138  1.00 21.34          
ATOM    880  C   GLY   106      -2.972  40.364  82.072  1.00 20.93          
ATOM    881  O   GLY   106      -2.430  40.139  80.986  1.00 20.08          
ATOM    882  N   ILE   107      -2.447  40.026  83.243  1.00 20.95          
ATOM    883  CA  ILE   107      -1.160  39.319  83.378  1.00 20.93          
ATOM    884  CB  ILE   107      -0.078  40.214  84.049  1.00 21.11          
ATOM    885  CG1 ILE   107       0.325  41.388  83.152  1.00 20.55          
ATOM    886  CD  ILE   107       1.349  42.345  83.836  1.00 20.00          
ATOM    887  CG2 ILE   107       1.203  39.438  84.401  1.00 20.89          
ATOM    888  C   ILE   107      -1.370  38.055  84.222  1.00 21.98          
ATOM    889  O   ILE   107      -1.968  38.122  85.302  1.00 21.96          
ATOM    890  N   ILE   108      -0.906  36.905  83.738  1.00 23.06          
ATOM    891  CA  ILE   108      -0.777  35.707  84.608  1.00 24.09          
ATOM    892  CB  ILE   108      -1.797  34.550  84.282  1.00 25.43          
ATOM    893  CG1 ILE   108      -3.226  34.916  84.748  1.00 27.07          
ATOM    894  CD  ILE   108      -4.015  35.716  83.788  1.00 27.73          
ATOM    895  CG2 ILE   108      -1.415  33.269  85.006  1.00 23.92          
ATOM    896  C   ILE   108       0.689  35.245  84.615  1.00 24.05          
ATOM    897  O   ILE   108       1.273  34.891  83.595  1.00 24.50          
ATOM    898  N   SER   109       1.303  35.319  85.788  1.00 24.00          
ATOM    899  CA  SER   109       2.734  35.260  85.873  1.00 23.46          
ATOM    900  CB  SER   109       3.332  36.695  85.913  1.00 23.91          
ATOM    901  OG  SER   109       4.739  36.634  86.160  1.00 21.24          
ATOM    902  C   SER   109       3.136  34.440  87.085  1.00 24.05          
ATOM    903  O   SER   109       2.362  34.328  88.051  1.00 22.41          
ATOM    904  N   THR   110       4.331  33.834  87.005  1.00 23.82          
ATOM    905  CA  THR   110       4.900  33.138  88.158  1.00 24.02          
ATOM    906  CB  THR   110       5.718  31.885  87.734  1.00 24.80          
ATOM    907  OG1 THR   110       4.809  30.972  87.111  1.00 21.86          
ATOM    908  CG2 THR   110       6.364  31.185  88.960  1.00 22.57          
ATOM    909  C   THR   110       5.661  34.110  89.087  1.00 24.45          
ATOM    910  O   THR   110       5.845  33.837  90.248  1.00 23.94          
ATOM    911  N   LYS   111       6.066  35.266  88.559  1.00 24.80          
ATOM    912  CA  LYS   111       6.752  36.269  89.351  1.00 24.75          
ATOM    913  CB  LYS   111       7.350  37.371  88.435  1.00 24.57          
ATOM    914  CG  LYS   111       7.970  38.551  89.191  1.00 26.03          
ATOM    915  CD  LYS   111       8.796  39.506  88.308  1.00 25.47          
ATOM    916  CE  LYS   111      10.151  38.911  87.993  1.00 27.08          
ATOM    917  NZ  LYS   111      10.973  39.860  87.201  1.00 27.31          
ATOM    918  C   LYS   111       5.720  36.811  90.357  1.00 24.52          
ATOM    919  O   LYS   111       4.513  36.795  90.083  1.00 24.83          
ATOM    920  N   TYR   112       6.184  37.252  91.525  1.00 24.03          
ATOM    921  CA  TYR   112       5.295  37.800  92.532  1.00 23.93          
ATOM    922  CB  TYR   112       6.074  38.171  93.792  1.00 24.91          
ATOM    923  CG  TYR   112       6.854  36.992  94.369  1.00 27.15          
ATOM    924  CD1 TYR   112       6.283  35.716  94.429  1.00 27.45          
ATOM    925  CE1 TYR   112       7.013  34.611  94.923  1.00 31.08          
ATOM    926  CZ  TYR   112       8.303  34.796  95.393  1.00 28.86          
ATOM    927  OH  TYR   112       9.011  33.713  95.913  1.00 31.26          
ATOM    928  CE2 TYR   112       8.893  36.058  95.356  1.00 28.90          
ATOM    929  CD2 TYR   112       8.168  37.152  94.823  1.00 27.43          
ATOM    930  C   TYR   112       4.610  39.032  91.989  1.00 23.41          
ATOM    931  O   TYR   112       5.260  39.896  91.364  1.00 23.52          
ATOM    932  N   ARG   113       3.305  39.103  92.232  1.00 21.97          
ATOM    933  CA  ARG   113       2.489  40.236  91.833  1.00 21.75          
ATOM    934  CB  ARG   113       1.031  40.019  92.239  1.00 21.73          
ATOM    935  CG  ARG   113       0.186  41.140  91.722  1.00 23.08          
ATOM    936  CD  ARG   113      -1.252  40.797  91.585  1.00 29.65          
ATOM    937  NE  ARG   113      -1.761  40.257  92.820  1.00 30.40          
ATOM    938  CZ  ARG   113      -2.146  41.000  93.831  1.00 33.13          
ATOM    939  NH1 ARG   113      -2.106  42.325  93.727  1.00 34.65          
ATOM    940  NH2 ARG   113      -2.572  40.409  94.936  1.00 35.49          
ATOM    941  C   ARG   113       2.954  41.569  92.374  1.00 21.21          
ATOM    942  O   ARG   113       2.925  42.564  91.658  1.00 21.65          
ATOM    943  N   PHE   114       3.333  41.612  93.656  1.00 20.92          
ATOM    944  CA  PHE   114       3.889  42.838  94.247  1.00 20.19          
ATOM    945  CB  PHE   114       4.199  42.677  95.771  1.00 19.97          
ATOM    946  CG  PHE   114       5.454  41.888  96.080  1.00 18.39          
ATOM    947  CD1 PHE   114       6.715  42.526  96.088  1.00 19.63          
ATOM    948  CE1 PHE   114       7.914  41.829  96.387  1.00 17.93          
ATOM    949  CZ  PHE   114       7.839  40.450  96.701  1.00 20.29          
ATOM    950  CE2 PHE   114       6.561  39.810  96.724  1.00 20.01          
ATOM    951  CD2 PHE   114       5.385  40.531  96.404  1.00 18.78          
ATOM    952  C   PHE   114       5.106  43.323  93.452  1.00 20.47          
ATOM    953  O   PHE   114       5.327  44.516  93.314  1.00 20.52          
ATOM    954  N   ARG   115       5.892  42.388  92.933  1.00 20.95          
ATOM    955  CA  ARG   115       7.085  42.719  92.176  1.00 22.04          
ATOM    956  CB  ARG   115       7.924  41.466  92.013  1.00 21.74          
ATOM    957  CG  ARG   115       9.238  41.681  91.270  1.00 24.56          
ATOM    958  CD  ARG   115      10.299  42.239  92.221  1.00 27.49          
ATOM    959  NE  ARG   115      10.697  41.201  93.174  1.00 29.27          
ATOM    960  CZ  ARG   115      11.068  41.414  94.437  1.00 29.39          
ATOM    961  NH1 ARG   115      11.103  42.653  94.944  1.00 26.15          
ATOM    962  NH2 ARG   115      11.415  40.371  95.193  1.00 26.91          
ATOM    963  C   ARG   115       6.720  43.344  90.811  1.00 22.23          
ATOM    964  O   ARG   115       7.290  44.373  90.398  1.00 21.97          
ATOM    965  N   ILE   116       5.744  42.721  90.145  1.00 22.57          
ATOM    966  CA  ILE   116       5.160  43.221  88.902  1.00 23.16          
ATOM    967  CB  ILE   116       4.157  42.190  88.356  1.00 23.56          
ATOM    968  CG1 ILE   116       4.920  40.914  87.940  1.00 21.53          
ATOM    969  CD  ILE   116       4.033  39.740  87.742  1.00 18.62          
ATOM    970  CG2 ILE   116       3.257  42.759  87.229  1.00 24.81          
ATOM    971  C   ILE   116       4.540  44.618  89.039  1.00 23.20          
ATOM    972  O   ILE   116       4.736  45.471  88.178  1.00 23.95          
ATOM    973  N   LEU   117       3.824  44.851  90.128  1.00 23.18          
ATOM    974  CA  LEU   117       3.142  46.131  90.333  1.00 22.97          
ATOM    975  CB  LEU   117       2.163  46.067  91.507  1.00 23.35          
ATOM    976  CG  LEU   117       0.893  45.203  91.358  1.00 22.83          
ATOM    977  CD1 LEU   117       0.263  45.068  92.731  1.00 23.77          
ATOM    978  CD2 LEU   117      -0.134  45.791  90.389  1.00 25.25          
ATOM    979  C   LEU   117       4.157  47.220  90.535  1.00 22.48          
ATOM    980  O   LEU   117       4.011  48.312  90.031  1.00 22.68          
ATOM    981  N   SER   118       5.225  46.896  91.239  1.00 22.82          
ATOM    982  CA  SER   118       6.278  47.867  91.486  1.00 22.55          
ATOM    983  CB  SER   118       7.256  47.318  92.508  1.00 22.73          
ATOM    984  OG  SER   118       8.088  48.377  92.966  1.00 25.80          
ATOM    985  C   SER   118       6.996  48.249  90.170  1.00 21.80          
ATOM    986  O   SER   118       7.276  49.429  89.930  1.00 20.84          
ATOM    987  N   PHE   119       7.255  47.248  89.322  1.00 20.76          
ATOM    988  CA  PHE   119       7.778  47.477  87.980  1.00 20.24          
ATOM    989  CB  PHE   119       8.059  46.173  87.223  1.00 18.77          
ATOM    990  CG  PHE   119       8.569  46.403  85.826  1.00 19.44          
ATOM    991  CD1 PHE   119       9.929  46.704  85.600  1.00 17.91          
ATOM    992  CE1 PHE   119      10.385  46.994  84.313  1.00 18.19          
ATOM    993  CZ  PHE   119       9.518  46.942  83.225  1.00 16.24          
ATOM    994  CE2 PHE   119       8.161  46.658  83.439  1.00 18.27          
ATOM    995  CD2 PHE   119       7.703  46.382  84.742  1.00 18.20          
ATOM    996  C   PHE   119       6.840  48.380  87.183  1.00 20.65          
ATOM    997  O   PHE   119       7.280  49.372  86.593  1.00 21.93          
ATOM    998  N   LEU   120       5.556  48.053  87.202  1.00 20.45          
ATOM    999  CA  LEU   120       4.536  48.767  86.441  1.00 20.84          
ATOM   1000  CB  LEU   120       3.167  48.044  86.517  1.00 20.93          
ATOM   1001  CG  LEU   120       3.052  46.558  86.041  1.00 19.24          
ATOM   1002  CD1 LEU   120       1.658  45.978  86.237  1.00 18.53          
ATOM   1003  CD2 LEU   120       3.431  46.440  84.584  1.00 20.96          
ATOM   1004  C   LEU   120       4.380  50.189  86.866  1.00 21.73          
ATOM   1005  O   LEU   120       4.173  51.072  86.033  1.00 21.80          
ATOM   1006  N   ARG   121       4.476  50.431  88.166  1.00 22.60          
ATOM   1007  CA  ARG   121       4.314  51.785  88.694  1.00 23.52          
ATOM   1008  CB  ARG   121       4.536  51.804  90.209  1.00 23.94          
ATOM   1009  CG  ARG   121       3.243  51.762  90.989  1.00 26.77          
ATOM   1010  CD  ARG   121       3.460  52.148  92.462  1.00 32.77          
ATOM   1011  NE  ARG   121       4.296  51.171  93.166  1.00 36.60          
ATOM   1012  CZ  ARG   121       3.868  49.993  93.621  1.00 37.23          
ATOM   1013  NH1 ARG   121       2.606  49.615  93.453  1.00 39.05          
ATOM   1014  NH2 ARG   121       4.712  49.187  94.242  1.00 37.40          
ATOM   1015  C   ARG   121       5.175  52.842  88.028  1.00 23.70          
ATOM   1016  O   ARG   121       4.700  53.965  87.795  1.00 22.66          
ATOM   1017  N   ASN   122       6.433  52.512  87.738  1.00 24.49          
ATOM   1018  CA  ASN   122       7.322  53.455  87.040  1.00 25.95          
ATOM   1019  CB  ASN   122       8.592  53.730  87.849  1.00 26.52          
ATOM   1020  CG  ASN   122       9.381  52.471  88.149  1.00 27.72          
ATOM   1021  OD1 ASN   122       8.830  51.376  88.204  1.00 27.80          
ATOM   1022  ND2 ASN   122      10.678  52.627  88.355  1.00 28.40          
ATOM   1023  C   ASN   122       7.650  53.134  85.563  1.00 26.81          
ATOM   1024  O   ASN   122       8.660  53.617  85.024  1.00 25.03          
ATOM   1025  N   HSD   123       6.782  52.336  84.928  1.00 28.90          
ATOM   1026  CA  HSD   123       6.824  52.065  83.474  1.00 32.33          
ATOM   1027  CB  HSD   123       7.437  50.688  83.175  1.00 32.18          
ATOM   1028  CG  HSD   123       8.880  50.598  83.558  1.00 32.54          
ATOM   1029  ND1 HSD   123       9.292  50.240  84.824  1.00 34.38          
ATOM   1030  CE1 HSD   123      10.612  50.292  84.887  1.00 34.14          
ATOM   1031  NE2 HSD   123      11.067  50.684  83.711  1.00 32.80          
ATOM   1032  CD2 HSD   123      10.004  50.896  82.868  1.00 32.98          
ATOM   1033  C   HSD   123       5.481  52.284  82.732  1.00 34.73          
ATOM   1034  O   HSD   123       5.352  53.269  82.000  1.00 35.69          
ATOM   1035  N   MET   124       4.488  51.397  82.910  1.00 37.36          
ATOM   1036  CA  MET   124       3.182  51.538  82.200  1.00 40.60          
ATOM   1037  CB  MET   124       2.354  50.232  82.186  1.00 40.22          
ATOM   1038  CG  MET   124       3.145  49.006  82.256  1.00 42.29          
ATOM   1039  SD  MET   124       3.035  47.774  80.747  1.00 48.28          
ATOM   1040  CE  MET   124       4.580  46.586  81.143  1.00 45.73          
ATOM   1041  C   MET   124       2.350  52.657  82.824  1.00 40.03          
ATOM   1042  O   MET   124       2.549  52.999  83.991  1.00 39.75          
ATOM   1043  N   PRO   125       1.431  53.264  82.044  1.00 40.89          
ATOM   1044  CA  PRO   125       0.446  54.102  82.734  1.00 40.98          
ATOM   1045  CB  PRO   125      -0.462  54.605  81.603  1.00 41.37          
ATOM   1046  CG  PRO   125       0.315  54.429  80.344  1.00 41.09          
ATOM   1047  CD  PRO   125       1.246  53.269  80.576  1.00 40.96          
ATOM   1048  C   PRO   125      -0.353  53.263  83.731  1.00 41.53          
ATOM   1049  O   PRO   125      -0.658  52.088  83.461  1.00 41.29          
ATOM   1050  N   ASP   126      -0.656  53.841  84.889  1.00 41.77          
ATOM   1051  CA  ASP   126      -1.488  53.161  85.878  1.00 42.26          
ATOM   1052  CB  ASP   126      -1.283  53.797  87.266  1.00 42.73          
ATOM   1053  CG  ASP   126      -1.286  52.769  88.412  1.00 44.34          
ATOM   1054  OD1 ASP   126      -1.670  51.593  88.183  1.00 45.63          
ATOM   1055  OD2 ASP   126      -0.897  53.153  89.552  1.00 45.51          
ATOM   1056  C   ASP   126      -2.927  53.356  85.389  1.00 41.58          
ATOM   1057  O   ASP   126      -3.206  54.386  84.784  1.00 42.21          
ATOM   1058  N   ASP   127      -3.827  52.389  85.556  1.00 40.52          
ATOM   1059  CA  ASP   127      -3.526  50.998  85.880  1.00 39.96          
ATOM   1060  CB  ASP   127      -4.189  50.550  87.197  1.00 40.94          
ATOM   1061  CG  ASP   127      -5.660  50.984  87.315  1.00 41.90          
ATOM   1062  OD1 ASP   127      -5.953  52.208  87.369  1.00 42.06          
ATOM   1063  OD2 ASP   127      -6.518  50.079  87.382  1.00 43.64          
ATOM   1064  C   ASP   127      -4.042  50.185  84.717  1.00 38.20          
ATOM   1065  O   ASP   127      -5.256  50.109  84.494  1.00 37.67          
ATOM   1066  N   TRP   128      -3.113  49.592  83.975  1.00 36.61          
ATOM   1067  CA  TRP   128      -3.429  49.055  82.644  1.00 35.09          
ATOM   1068  CB  TRP   128      -2.227  48.948  81.688  1.00 35.80          
ATOM   1069  CG  TRP   128      -2.234  50.138  80.750  1.00 35.09          
ATOM   1070  CD1 TRP   128      -3.104  51.208  80.783  1.00 35.72          
ATOM   1071  NE1 TRP   128      -2.822  52.085  79.763  1.00 35.55          
ATOM   1072  CE2 TRP   128      -1.742  51.607  79.063  1.00 35.42          
ATOM   1073  CD2 TRP   128      -1.348  50.383  79.658  1.00 34.71          
ATOM   1074  CE3 TRP   128      -0.265  49.688  79.118  1.00 33.51          
ATOM   1075  CZ3 TRP   128       0.399  50.231  78.022  1.00 34.61          
ATOM   1076  CH2 TRP   128      -0.003  51.446  77.455  1.00 35.73          
ATOM   1077  CZ2 TRP   128      -1.074  52.152  77.957  1.00 36.45          
ATOM   1078  C   TRP   128      -4.588  48.100  82.448  1.00 33.02          
ATOM   1079  O   TRP   128      -5.180  48.096  81.379  1.00 32.97          
ATOM   1080  N   PHE   129      -4.895  47.198  83.368  1.00 30.83          
ATOM   1081  CA  PHE   129      -4.519  45.796  83.438  1.00 27.41          
ATOM   1082  CB  PHE   129      -3.210  45.414  84.131  1.00 27.51          
ATOM   1083  CG  PHE   129      -2.070  45.221  83.163  1.00 24.74          
ATOM   1084  CD1 PHE   129      -2.191  44.352  82.086  1.00 22.45          
ATOM   1085  CE1 PHE   129      -1.154  44.219  81.171  1.00 22.50          
ATOM   1086  CZ  PHE   129       0.024  44.986  81.326  1.00 23.94          
ATOM   1087  CE2 PHE   129       0.131  45.854  82.373  1.00 22.97          
ATOM   1088  CD2 PHE   129      -0.908  45.982  83.279  1.00 22.98          
ATOM   1089  C   PHE   129      -5.747  45.423  84.247  1.00 26.85          
ATOM   1090  O   PHE   129      -5.857  45.755  85.438  1.00 26.52          
ATOM   1091  N   ASP   130      -6.726  44.837  83.571  1.00 24.96          
ATOM   1092  CA  ASP   130      -7.957  44.475  84.234  1.00 24.19          
ATOM   1093  CB  ASP   130      -9.012  44.086  83.220  1.00 23.88          
ATOM   1094  CG  ASP   130      -9.437  45.274  82.371  1.00 27.00          
ATOM   1095  OD1 ASP   130     -10.486  45.869  82.696  1.00 29.29          
ATOM   1096  OD2 ASP   130      -8.706  45.627  81.403  1.00 28.94          
ATOM   1097  C   ASP   130      -7.741  43.441  85.330  1.00 22.92          
ATOM   1098  O   ASP   130      -8.495  43.397  86.287  1.00 21.95          
ATOM   1099  N   ILE   131      -6.677  42.649  85.206  1.00 22.22          
ATOM   1100  CA  ILE   131      -6.307  41.674  86.234  1.00 21.82          
ATOM   1101  CB  ILE   131      -7.161  40.373  86.146  1.00 21.76          
ATOM   1102  CG1 ILE   131      -6.930  39.485  87.370  1.00 22.46          
ATOM   1103  CD  ILE   131      -8.071  38.538  87.621  1.00 24.67          
ATOM   1104  CG2 ILE   131      -6.894  39.594  84.846  1.00 19.84          
ATOM   1105  C   ILE   131      -4.825  41.292  86.164  1.00 21.81          
ATOM   1106  O   ILE   131      -4.235  41.209  85.074  1.00 22.19          
ATOM   1107  N   ILE   132      -4.244  41.065  87.334  1.00 20.67          
ATOM   1108  CA  ILE   132      -2.877  40.621  87.448  1.00 21.67          
ATOM   1109  CB  ILE   132      -1.857  41.769  87.836  1.00 21.11          
ATOM   1110  CG1 ILE   132      -1.840  42.854  86.755  1.00 22.05          
ATOM   1111  CD  ILE   132      -1.142  44.103  87.131  1.00 20.96          
ATOM   1112  CG2 ILE   132      -0.429  41.186  87.997  1.00 20.87          
ATOM   1113  C   ILE   132      -2.934  39.561  88.520  1.00 21.42          
ATOM   1114  O   ILE   132      -3.402  39.825  89.625  1.00 21.70          
ATOM   1115  N   ILE   133      -2.490  38.372  88.137  1.00 21.45          
ATOM   1116  CA  ILE   133      -2.309  37.194  88.992  1.00 21.23          
ATOM   1117  CB  ILE   133      -3.092  35.998  88.411  1.00 20.64          
ATOM   1118  CG1 ILE   133      -4.604  36.370  88.251  1.00 20.13          
ATOM   1119  CD  ILE   133      -5.347  36.639  89.520  1.00 22.28          
ATOM   1120  CG2 ILE   133      -2.926  34.728  89.265  1.00 20.74          
ATOM   1121  C   ILE   133      -0.808  36.909  88.984  1.00 21.77          
ATOM   1122  O   ILE   133      -0.211  36.748  87.891  1.00 22.24          
ATOM   1123  N   GLY   134      -0.192  36.907  90.173  1.00 21.68          
ATOM   1124  CA  GLY   134       1.255  36.614  90.338  1.00 20.93          
ATOM   1125  C   GLY   134       1.469  35.278  91.048  1.00 21.26          
ATOM   1126  O   GLY   134       0.500  34.563  91.361  1.00 19.97          
ATOM   1127  N   GLY   135       2.737  34.925  91.268  1.00 21.56          
ATOM   1128  CA  GLY   135       3.112  33.682  91.980  1.00 22.36          
ATOM   1129  C   GLY   135       2.520  33.486  93.377  1.00 23.17          
ATOM   1130  O   GLY   135       2.158  32.354  93.770  1.00 23.27          
ATOM   1131  N   GLU   136       2.383  34.563  94.140  1.00 22.75          
ATOM   1132  CA  GLU   136       1.816  34.428  95.487  1.00 23.36          
ATOM   1133  CB  GLU   136       2.345  35.554  96.403  1.00 23.73          
ATOM   1134  CG  GLU   136       1.681  36.950  96.250  1.00 22.57          
ATOM   1135  CD  GLU   136       2.182  37.801  95.055  1.00 25.96          
ATOM   1136  OE1 GLU   136       2.283  37.277  93.905  1.00 23.49          
ATOM   1137  OE2 GLU   136       2.415  39.034  95.256  1.00 24.73          
ATOM   1138  C   GLU   136       0.247  34.280  95.490  1.00 23.83          
ATOM   1139  O   GLU   136      -0.369  33.896  96.497  1.00 23.40          
ATOM   1140  N   ASP   137      -0.387  34.529  94.351  1.00 24.09          
ATOM   1141  CA  ASP   137      -1.859  34.442  94.272  1.00 25.55          
ATOM   1142  CB  ASP   137      -2.367  35.311  93.131  1.00 25.10          
ATOM   1143  CG  ASP   137      -2.097  36.779  93.352  1.00 25.54          
ATOM   1144  OD1 ASP   137      -2.202  37.277  94.485  1.00 28.50          
ATOM   1145  OD2 ASP   137      -1.772  37.440  92.373  1.00 26.95          
ATOM   1146  C   ASP   137      -2.416  33.017  94.111  1.00 25.84          
ATOM   1147  O   ASP   137      -3.638  32.812  94.093  1.00 26.18          
ATOM   1148  N   VAL   138      -1.521  32.044  93.978  1.00 26.55          
ATOM   1149  CA  VAL   138      -1.889  30.650  93.613  1.00 26.36          
ATOM   1150  CB  VAL   138      -1.768  30.341  92.054  1.00 26.04          
ATOM   1151  CG1 VAL   138      -2.696  31.284  91.225  1.00 26.27          
ATOM   1152  CG2 VAL   138      -0.311  30.428  91.540  1.00 25.06          
ATOM   1153  C   VAL   138      -1.035  29.671  94.398  1.00 26.57          
ATOM   1154  O   VAL   138       0.097  29.981  94.766  1.00 25.71          
ATOM   1155  N   THR   139      -1.596  28.497  94.651  1.00 27.30          
ATOM   1156  CA  THR   139      -0.888  27.445  95.356  1.00 28.33          
ATOM   1157  CB  THR   139      -1.882  26.536  96.095  1.00 28.71          
ATOM   1158  OG1 THR   139      -2.459  27.267  97.177  1.00 26.46          
ATOM   1159  CG2 THR   139      -1.208  25.266  96.628  1.00 30.40          
ATOM   1160  C   THR   139      -0.005  26.648  94.386  1.00 29.17          
ATOM   1161  O   THR   139       1.149  26.353  94.701  1.00 29.07          
ATOM   1162  N   HSD   140      -0.571  26.318  93.219  1.00 29.49          
ATOM   1163  CA  HSD   140       0.113  25.569  92.172  1.00 29.83          
ATOM   1164  CB  HSD   140      -0.736  24.403  91.704  1.00 30.06          
ATOM   1165  CG  HSD   140      -0.980  23.395  92.770  1.00 32.33          
ATOM   1166  ND1 HSD   140      -2.093  23.429  93.583  1.00 35.12          
ATOM   1167  CE1 HSD   140      -2.036  22.425  94.439  1.00 36.33          
ATOM   1168  NE2 HSD   140      -0.925  21.748  94.213  1.00 37.23          
ATOM   1169  CD2 HSD   140      -0.244  22.340  93.177  1.00 34.03          
ATOM   1170  C   HSD   140       0.384  26.459  90.995  1.00 29.35          
ATOM   1171  O   HSD   140      -0.478  27.252  90.580  1.00 28.72          
ATOM   1172  N   HSD   141       1.574  26.307  90.439  1.00 27.98          
ATOM   1173  CA  HSD   141       2.080  27.301  89.512  1.00 28.07          
ATOM   1174  CB  HSD   141       3.463  27.750  90.003  1.00 28.04          
ATOM   1175  CG  HSD   141       3.393  28.496  91.311  1.00 27.71          
ATOM   1176  ND1 HSD   141       3.534  27.875  92.534  1.00 25.16          
ATOM   1177  CE1 HSD   141       3.373  28.759  93.499  1.00 24.61          
ATOM   1178  NE2 HSD   141       3.107  29.934  92.947  1.00 27.11          
ATOM   1179  CD2 HSD   141       3.111  29.796  91.580  1.00 27.35          
ATOM   1180  C   HSD   141       2.111  26.777  88.079  1.00 27.50          
ATOM   1181  O   HSD   141       2.090  25.571  87.879  1.00 26.78          
ATOM   1182  N   LYS   142       2.171  27.681  87.093  1.00 27.81          
ATOM   1183  CA  LYS   142       2.224  27.291  85.662  1.00 28.04          
ATOM   1184  CB  LYS   142       2.551  28.498  84.772  1.00 27.57          
ATOM   1185  CG  LYS   142       1.552  29.656  84.827  1.00 28.67          
ATOM   1186  CD  LYS   142       1.857  30.722  83.749  1.00 28.89          
ATOM   1187  CE  LYS   142       2.936  31.661  84.217  1.00 28.95          
ATOM   1188  NZ  LYS   142       3.314  32.608  83.107  1.00 28.98          
ATOM   1189  C   LYS   142       3.255  26.198  85.486  1.00 27.87          
ATOM   1190  O   LYS   142       4.327  26.282  86.090  1.00 29.23          
ATOM   1191  N   PRO   143       2.977  25.166  84.663  1.00 28.29          
ATOM   1192  CA  PRO   143       1.850  24.958  83.744  1.00 28.58          
ATOM   1193  CB  PRO   143       2.368  23.876  82.765  1.00 28.89          
ATOM   1194  CG  PRO   143       3.359  23.086  83.546  1.00 28.98          
ATOM   1195  CD  PRO   143       3.934  24.034  84.621  1.00 28.62          
ATOM   1196  C   PRO   143       0.482  24.611  84.362  1.00 28.32          
ATOM   1197  O   PRO   143      -0.478  24.469  83.636  1.00 27.84          
ATOM   1198  N   ASP   144       0.368  24.539  85.688  1.00 28.21          
ATOM   1199  CA  ASP   144      -0.954  24.362  86.294  1.00 28.18          
ATOM   1200  CB  ASP   144      -0.841  24.248  87.817  1.00 27.62          
ATOM   1201  CG  ASP   144      -2.147  23.834  88.462  1.00 28.37          
ATOM   1202  OD1 ASP   144      -2.221  22.711  88.967  1.00 26.19          
ATOM   1203  OD2 ASP   144      -3.102  24.628  88.476  1.00 27.88          
ATOM   1204  C   ASP   144      -1.830  25.560  85.908  1.00 27.55          
ATOM   1205  O   ASP   144      -1.396  26.722  86.028  1.00 27.66          
ATOM   1206  N   PRO   145      -3.062  25.287  85.416  1.00 28.58          
ATOM   1207  CA  PRO   145      -3.950  26.371  84.963  1.00 27.87          
ATOM   1208  CB  PRO   145      -4.988  25.617  84.115  1.00 28.13          
ATOM   1209  CG  PRO   145      -5.068  24.268  84.760  1.00 28.65          
ATOM   1210  CD  PRO   145      -3.678  23.948  85.218  1.00 27.05          
ATOM   1211  C   PRO   145      -4.632  27.194  86.078  1.00 28.17          
ATOM   1212  O   PRO   145      -5.499  28.029  85.778  1.00 28.46          
ATOM   1213  N   GLU   146      -4.260  26.975  87.338  1.00 28.42          
ATOM   1214  CA  GLU   146      -4.968  27.605  88.491  1.00 28.55          
ATOM   1215  CB  GLU   146      -4.235  27.313  89.807  1.00 28.72          
ATOM   1216  CG  GLU   146      -5.006  27.727  91.073  1.00 29.01          
ATOM   1217  CD  GLU   146      -4.199  27.550  92.349  1.00 28.29          
ATOM   1218  OE1 GLU   146      -3.457  26.547  92.459  1.00 29.73          
ATOM   1219  OE2 GLU   146      -4.301  28.412  93.245  1.00 27.05          
ATOM   1220  C   GLU   146      -5.100  29.119  88.339  1.00 28.92          
ATOM   1221  O   GLU   146      -6.187  29.681  88.500  1.00 28.72          
ATOM   1222  N   GLY   147      -3.982  29.778  88.050  1.00 29.01          
ATOM   1223  CA  GLY   147      -3.970  31.229  87.917  1.00 29.73          
ATOM   1224  C   GLY   147      -4.714  31.721  86.699  1.00 30.25          
ATOM   1225  O   GLY   147      -5.460  32.706  86.778  1.00 30.55          
ATOM   1226  N   LEU   148      -4.516  31.031  85.574  1.00 30.39          
ATOM   1227  CA  LEU   148      -5.191  31.387  84.335  1.00 30.29          
ATOM   1228  CB  LEU   148      -4.668  30.557  83.142  1.00 29.91          
ATOM   1229  CG  LEU   148      -5.162  30.971  81.723  1.00 31.16          
ATOM   1230  CD1 LEU   148      -5.102  32.485  81.462  1.00 30.38          
ATOM   1231  CD2 LEU   148      -4.345  30.284  80.653  1.00 31.39          
ATOM   1232  C   LEU   148      -6.712  31.250  84.509  1.00 29.93          
ATOM   1233  O   LEU   148      -7.459  32.187  84.189  1.00 29.74          
ATOM   1234  N   LEU   149      -7.156  30.093  85.017  1.00 29.50          
ATOM   1235  CA  LEU   149      -8.573  29.865  85.290  1.00 29.44          
ATOM   1236  CB  LEU   149      -8.819  28.417  85.759  1.00 29.53          
ATOM   1237  CG  LEU   149      -8.523  27.271  84.787  1.00 26.91          
ATOM   1238  CD1 LEU   149      -8.739  25.945  85.501  1.00 25.33          
ATOM   1239  CD2 LEU   149      -9.358  27.402  83.497  1.00 24.96          
ATOM   1240  C   LEU   149      -9.113  30.853  86.320  1.00 30.01          
ATOM   1241  O   LEU   149     -10.254  31.298  86.206  1.00 30.21          
ATOM   1242  N   LEU   150      -8.294  31.198  87.315  1.00 30.89          
ATOM   1243  CA  LEU   150      -8.667  32.200  88.308  1.00 31.50          
ATOM   1244  CB  LEU   150      -7.596  32.361  89.407  1.00 31.23          
ATOM   1245  CG  LEU   150      -7.868  33.398  90.522  1.00 31.44          
ATOM   1246  CD1 LEU   150      -9.066  33.029  91.413  1.00 30.04          
ATOM   1247  CD2 LEU   150      -6.637  33.653  91.380  1.00 31.62          
ATOM   1248  C   LEU   150      -8.980  33.552  87.647  1.00 32.69          
ATOM   1249  O   LEU   150     -10.038  34.150  87.928  1.00 33.35          
ATOM   1250  N   ALA   151      -8.077  34.021  86.780  1.00 32.59          
ATOM   1251  CA  ALA   151      -8.261  35.279  86.067  1.00 33.62          
ATOM   1252  CB  ALA   151      -7.054  35.584  85.235  1.00 33.37          
ATOM   1253  C   ALA   151      -9.529  35.337  85.205  1.00 34.37          
ATOM   1254  O   ALA   151     -10.314  36.307  85.307  1.00 34.50          
ATOM   1255  N   ILE   152      -9.718  34.305  84.366  1.00 35.25          
ATOM   1256  CA  ILE   152     -10.926  34.126  83.543  1.00 35.62          
ATOM   1257  CB  ILE   152     -10.934  32.763  82.776  1.00 35.62          
ATOM   1258  CG1 ILE   152      -9.708  32.606  81.876  1.00 34.67          
ATOM   1259  CD  ILE   152      -9.417  31.151  81.476  1.00 34.42          
ATOM   1260  CG2 ILE   152     -12.206  32.625  81.915  1.00 36.65          
ATOM   1261  C   ILE   152     -12.189  34.206  84.411  1.00 36.96          
ATOM   1262  O   ILE   152     -13.165  34.867  84.043  1.00 36.65          
ATOM   1263  N   ASP   153     -12.150  33.527  85.557  1.00 38.06          
ATOM   1264  CA  ASP   153     -13.238  33.564  86.541  1.00 38.91          
ATOM   1265  CB  ASP   153     -12.964  32.594  87.693  1.00 38.78          
ATOM   1266  CG  ASP   153     -14.020  32.677  88.765  1.00 41.18          
ATOM   1267  OD1 ASP   153     -15.192  32.354  88.469  1.00 38.13          
ATOM   1268  OD2 ASP   153     -13.685  33.102  89.896  1.00 46.00          
ATOM   1269  C   ASP   153     -13.527  34.964  87.090  1.00 39.10          
ATOM   1270  O   ASP   153     -14.683  35.418  87.096  1.00 39.05          
ATOM   1271  N   ARG   154     -12.478  35.640  87.550  1.00 39.66          
ATOM   1272  CA  ARG   154     -12.604  36.995  88.098  1.00 40.18          
ATOM   1273  CB  ARG   154     -11.289  37.457  88.738  1.00 40.91          
ATOM   1274  CG  ARG   154     -10.921  36.683  89.989  1.00 42.64          
ATOM   1275  CD  ARG   154     -10.260  37.574  91.020  1.00 45.63          
ATOM   1276  NE  ARG   154      -9.328  36.801  91.833  1.00 47.12          
ATOM   1277  CZ  ARG   154      -8.246  37.312  92.406  1.00 48.26          
ATOM   1278  NH1 ARG   154      -7.970  38.611  92.256  1.00 47.61          
ATOM   1279  NH2 ARG   154      -7.434  36.525  93.112  1.00 47.30          
ATOM   1280  C   ARG   154     -13.095  38.035  87.083  1.00 39.58          
ATOM   1281  O   ARG   154     -13.827  38.975  87.447  1.00 40.22          
ATOM   1282  N   LEU   155     -12.690  37.865  85.826  1.00 38.30          
ATOM   1283  CA  LEU   155     -13.117  38.749  84.739  1.00 37.14          
ATOM   1284  CB  LEU   155     -12.063  38.749  83.609  1.00 36.73          
ATOM   1285  CG  LEU   155     -10.662  39.400  83.769  1.00 34.97          
ATOM   1286  CD1 LEU   155      -9.880  39.218  82.484  1.00 36.15          
ATOM   1287  CD2 LEU   155     -10.715  40.861  84.079  1.00 34.72          
ATOM   1288  C   LEU   155     -14.549  38.454  84.183  1.00 37.07          
ATOM   1289  O   LEU   155     -15.064  39.218  83.354  1.00 36.32          
ATOM   1290  N   LYS   156     -15.181  37.376  84.671  1.00 36.92          
ATOM   1291  CA  LYS   156     -16.451  36.848  84.132  1.00 37.01          
ATOM   1292  CB  LYS   156     -17.680  37.720  84.475  1.00 37.18          
ATOM   1293  CG  LYS   156     -17.712  38.389  85.856  1.00 38.58          
ATOM   1294  CD  LYS   156     -17.848  37.411  87.018  1.00 39.61          
ATOM   1295  CE  LYS   156     -17.923  38.158  88.346  1.00 39.57          
ATOM   1296  NZ  LYS   156     -19.301  38.673  88.683  1.00 40.82          
ATOM   1297  C   LYS   156     -16.327  36.676  82.618  1.00 37.01          
ATOM   1298  O   LYS   156     -17.227  37.042  81.846  1.00 36.54          
ATOM   1299  N   ALA   157     -15.191  36.124  82.202  1.00 36.76          
ATOM   1300  CA  ALA   157     -14.923  35.911  80.797  1.00 37.12          
ATOM   1301  CB  ALA   157     -13.416  36.198  80.460  1.00 36.14          
ATOM   1302  C   ALA   157     -15.338  34.509  80.356  1.00 37.35          
ATOM   1303  O   ALA   157     -15.522  33.600  81.181  1.00 38.21          
ATOM   1304  N   CYS   158     -15.552  34.391  79.050  1.00 37.47          
ATOM   1305  CA  CYS   158     -15.746  33.106  78.417  0.50 37.00          
ATOM   1307  CB  CYS   158     -16.872  33.168  77.395  0.50 37.04          
ATOM   1309  SG  CYS   158     -18.511  32.998  78.148  0.50 36.19          
ATOM   1311  C   CYS   158     -14.429  32.667  77.787  1.00 37.08          
ATOM   1312  O   CYS   158     -13.785  33.425  77.050  1.00 37.37          
ATOM   1313  N   PRO   159     -13.986  31.421  78.103  1.00 36.60          
ATOM   1314  CA  PRO   159     -12.637  31.046  77.632  1.00 35.62          
ATOM   1315  CB  PRO   159     -12.479  29.599  78.104  1.00 35.48          
ATOM   1316  CG  PRO   159     -13.877  29.111  78.347  1.00 36.57          
ATOM   1317  CD  PRO   159     -14.643  30.306  78.813  1.00 36.59          
ATOM   1318  C   PRO   159     -12.480  31.161  76.108  1.00 35.34          
ATOM   1319  O   PRO   159     -11.385  31.435  75.621  1.00 34.76          
ATOM   1320  N   GLU   160     -13.581  31.008  75.371  1.00 34.46          
ATOM   1321  CA  GLU   160     -13.572  31.187  73.918  1.00 34.88          
ATOM   1322  CB  GLU   160     -14.945  30.864  73.301  1.00 35.84          
ATOM   1323  CG  GLU   160     -15.293  29.376  73.320  1.00 39.68          
ATOM   1324  CD  GLU   160     -15.699  28.846  74.709  1.00 43.90          
ATOM   1325  OE1 GLU   160     -16.231  29.628  75.539  1.00 42.25          
ATOM   1326  OE2 GLU   160     -15.485  27.629  74.959  1.00 47.49          
ATOM   1327  C   GLU   160     -13.089  32.572  73.473  1.00 33.86          
ATOM   1328  O   GLU   160     -12.526  32.703  72.382  1.00 34.28          
ATOM   1329  N   GLU   161     -13.253  33.581  74.319  1.00 32.56          
ATOM   1330  CA  GLU   161     -12.852  34.943  73.950  1.00 32.97          
ATOM   1331  CB  GLU   161     -13.931  35.966  74.329  1.00 33.11          
ATOM   1332  CG  GLU   161     -14.101  36.232  75.807  1.00 34.27          
ATOM   1333  CD  GLU   161     -15.469  36.815  76.099  1.00 36.91          
ATOM   1334  OE1 GLU   161     -16.134  37.214  75.109  1.00 37.88          
ATOM   1335  OE2 GLU   161     -15.880  36.864  77.293  1.00 35.47          
ATOM   1336  C   GLU   161     -11.490  35.365  74.503  1.00 32.61          
ATOM   1337  O   GLU   161     -11.116  36.542  74.411  1.00 32.64          
ATOM   1338  N   VAL   162     -10.762  34.387  75.044  1.00 31.89          
ATOM   1339  CA  VAL   162      -9.492  34.613  75.742  1.00 31.91          
ATOM   1340  CB  VAL   162      -9.493  33.968  77.159  1.00 32.49          
ATOM   1341  CG1 VAL   162      -8.100  34.070  77.824  1.00 30.64          
ATOM   1342  CG2 VAL   162     -10.614  34.582  78.046  1.00 30.78          
ATOM   1343  C   VAL   162      -8.309  34.091  74.928  1.00 31.63          
ATOM   1344  O   VAL   162      -8.291  32.936  74.492  1.00 30.72          
ATOM   1345  N   LEU   163      -7.344  34.977  74.708  1.00 31.17          
ATOM   1346  CA  LEU   163      -6.061  34.599  74.139  1.00 30.89          
ATOM   1347  CB  LEU   163      -5.693  35.510  72.979  1.00 30.52          
ATOM   1348  CG  LEU   163      -4.485  35.088  72.144  1.00 30.76          
ATOM   1349  CD1 LEU   163      -4.643  33.648  71.634  1.00 29.87          
ATOM   1350  CD2 LEU   163      -4.230  36.063  70.980  1.00 30.98          
ATOM   1351  C   LEU   163      -4.992  34.696  75.218  1.00 30.75          
ATOM   1352  O   LEU   163      -4.896  35.708  75.892  1.00 30.06          
ATOM   1353  N   TYR   164      -4.220  33.626  75.400  1.00 30.91          
ATOM   1354  CA  TYR   164      -3.047  33.689  76.276  1.00 31.55          
ATOM   1355  CB  TYR   164      -2.973  32.470  77.203  1.00 31.30          
ATOM   1356  CG  TYR   164      -1.902  32.618  78.276  1.00 33.40          
ATOM   1357  CD1 TYR   164      -1.848  33.781  79.067  1.00 31.47          
ATOM   1358  CE1 TYR   164      -0.887  33.944  80.053  1.00 31.32          
ATOM   1359  CZ  TYR   164       0.062  32.967  80.262  1.00 33.71          
ATOM   1360  OH  TYR   164       0.992  33.188  81.240  1.00 32.32          
ATOM   1361  CE2 TYR   164       0.062  31.782  79.482  1.00 33.92          
ATOM   1362  CD2 TYR   164      -0.937  31.621  78.489  1.00 31.66          
ATOM   1363  C   TYR   164      -1.755  33.813  75.451  1.00 31.34          
ATOM   1364  O   TYR   164      -1.534  33.038  74.515  1.00 32.53          
ATOM   1365  N   ILE   165      -0.889  34.758  75.810  1.00 30.69          
ATOM   1366  CA  ILE   165       0.335  35.049  75.040  1.00 29.49          
ATOM   1367  CB  ILE   165       0.318  36.514  74.448  1.00 29.51          
ATOM   1368  CG1 ILE   165      -0.932  36.778  73.604  1.00 30.79          
ATOM   1369  CD  ILE   165      -2.039  37.483  74.342  1.00 27.44          
ATOM   1370  CG2 ILE   165       1.575  36.794  73.636  1.00 31.57          
ATOM   1371  C   ILE   165       1.578  34.886  75.917  1.00 29.05          
ATOM   1372  O   ILE   165       1.688  35.541  76.944  1.00 28.44          
ATOM   1373  N   GLY   166       2.518  34.023  75.520  1.00 28.54          
ATOM   1374  CA  GLY   166       3.679  33.738  76.376  1.00 27.39          
ATOM   1375  C   GLY   166       4.878  33.445  75.510  1.00 28.08          
ATOM   1376  O   GLY   166       4.733  33.328  74.274  1.00 26.75          
ATOM   1377  N   ASP   167       6.054  33.333  76.146  1.00 27.57          
ATOM   1378  CA  ASP   167       7.293  33.064  75.426  1.00 27.78          
ATOM   1379  CB  ASP   167       8.381  34.005  75.922  1.00 27.52          
ATOM   1380  CG  ASP   167       8.800  33.669  77.324  1.00 28.93          
ATOM   1381  OD1 ASP   167       7.990  33.939  78.215  1.00 30.91          
ATOM   1382  OD2 ASP   167       9.906  33.108  77.533  1.00 31.75          
ATOM   1383  C   ASP   167       7.845  31.632  75.580  1.00 27.57          
ATOM   1384  O   ASP   167       8.887  31.301  74.972  1.00 27.83          
ATOM   1385  N   SER   168       7.202  30.825  76.429  1.00 27.47          
ATOM   1386  CA  SER   168       7.723  29.516  76.835  1.00 26.64          
ATOM   1387  CB  SER   168       8.025  29.498  78.332  1.00 26.94          
ATOM   1388  OG  SER   168       6.799  29.549  79.034  1.00 29.70          
ATOM   1389  C   SER   168       6.726  28.410  76.620  1.00 26.30          
ATOM   1390  O   SER   168       5.504  28.656  76.474  1.00 26.45          
ATOM   1391  N   THR   169       7.244  27.180  76.644  1.00 26.12          
ATOM   1392  CA  THR   169       6.397  25.999  76.621  1.00 26.28          
ATOM   1393  CB  THR   169       7.173  24.733  76.318  1.00 26.36          
ATOM   1394  OG1 THR   169       8.277  24.663  77.212  1.00 26.70          
ATOM   1395  CG2 THR   169       7.683  24.770  74.879  1.00 27.73          
ATOM   1396  C   THR   169       5.599  25.815  77.893  1.00 25.69          
ATOM   1397  O   THR   169       4.515  25.237  77.832  1.00 24.92          
ATOM   1398  N   VAL   170       6.111  26.329  79.025  1.00 26.07          
ATOM   1399  CA  VAL   170       5.317  26.449  80.275  1.00 25.83          
ATOM   1400  CB  VAL   170       6.131  27.138  81.409  1.00 25.84          
ATOM   1401  CG1 VAL   170       5.222  27.558  82.582  1.00 26.91          
ATOM   1402  CG2 VAL   170       7.246  26.221  81.886  1.00 26.04          
ATOM   1403  C   VAL   170       4.024  27.208  80.008  1.00 25.47          
ATOM   1404  O   VAL   170       2.911  26.778  80.406  1.00 25.40          
ATOM   1405  N   ASP   171       4.162  28.332  79.312  1.00 26.32          
ATOM   1406  CA  ASP   171       2.985  29.153  78.990  1.00 26.34          
ATOM   1407  CB  ASP   171       3.435  30.463  78.358  1.00 27.70          
ATOM   1408  CG  ASP   171       4.084  31.399  79.350  1.00 27.98          
ATOM   1409  OD1 ASP   171       3.752  31.363  80.551  1.00 28.13          
ATOM   1410  OD2 ASP   171       4.947  32.188  78.932  1.00 32.79          
ATOM   1411  C   ASP   171       2.065  28.413  78.038  1.00 26.85          
ATOM   1412  O   ASP   171       0.828  28.439  78.209  1.00 26.61          
ATOM   1413  N   ALA   172       2.649  27.764  77.024  1.00 25.61          
ATOM   1414  CA  ALA   172       1.865  27.000  76.055  1.00 27.11          
ATOM   1415  CB  ALA   172       2.741  26.409  74.899  1.00 26.48          
ATOM   1416  C   ALA   172       1.104  25.888  76.751  1.00 27.31          
ATOM   1417  O   ALA   172      -0.092  25.728  76.502  1.00 26.13          
ATOM   1418  N   GLY   173       1.804  25.125  77.599  1.00 27.21          
ATOM   1419  CA  GLY   173       1.167  24.118  78.457  1.00 28.14          
ATOM   1420  C   GLY   173       0.059  24.691  79.333  1.00 28.11          
ATOM   1421  O   GLY   173      -0.985  24.062  79.505  1.00 28.46          
ATOM   1422  N   THR   174       0.263  25.898  79.858  1.00 29.04          
ATOM   1423  CA  THR   174      -0.746  26.532  80.739  1.00 28.63          
ATOM   1424  CB  THR   174      -0.239  27.845  81.422  1.00 29.14          
ATOM   1425  OG1 THR   174       1.062  27.635  82.011  1.00 28.42          
ATOM   1426  CG2 THR   174      -1.201  28.270  82.494  1.00 28.38          
ATOM   1427  C   THR   174      -2.017  26.816  79.962  1.00 28.93          
ATOM   1428  O   THR   174      -3.104  26.500  80.426  1.00 28.93          
ATOM   1429  N   ALA   175      -1.891  27.400  78.777  1.00 29.27          
ATOM   1430  CA  ALA   175      -3.101  27.700  77.976  1.00 30.09          
ATOM   1431  CB  ALA   175      -2.757  28.491  76.732  1.00 29.49          
ATOM   1432  C   ALA   175      -3.856  26.427  77.621  1.00 30.13          
ATOM   1433  O   ALA   175      -5.083  26.372  77.793  1.00 31.05          
ATOM   1434  N   ALA   176      -3.130  25.392  77.172  1.00 29.92          
ATOM   1435  CA  ALA   176      -3.758  24.090  76.823  1.00 30.22          
ATOM   1436  CB  ALA   176      -2.712  23.076  76.314  1.00 29.67          
ATOM   1437  C   ALA   176      -4.493  23.521  78.016  1.00 30.43          
ATOM   1438  O   ALA   176      -5.688  23.205  77.949  1.00 31.30          
ATOM   1439  N   ALA   177      -3.789  23.413  79.136  1.00 30.95          
ATOM   1440  CA  ALA   177      -4.426  22.959  80.380  1.00 30.86          
ATOM   1441  CB  ALA   177      -3.414  22.929  81.542  1.00 29.64          
ATOM   1442  C   ALA   177      -5.706  23.754  80.734  1.00 30.96          
ATOM   1443  O   ALA   177      -6.680  23.173  81.213  1.00 30.26          
ATOM   1444  N   ALA   178      -5.704  25.069  80.481  1.00 31.93          
ATOM   1445  CA  ALA   178      -6.880  25.919  80.731  1.00 32.07          
ATOM   1446  CB  ALA   178      -6.452  27.382  80.979  1.00 32.87          
ATOM   1447  C   ALA   178      -7.969  25.844  79.648  1.00 32.72          
ATOM   1448  O   ALA   178      -9.077  26.302  79.867  1.00 32.75          
ATOM   1449  N   GLY   179      -7.658  25.254  78.492  1.00 33.13          
ATOM   1450  CA  GLY   179      -8.605  25.194  77.382  1.00 32.75          
ATOM   1451  C   GLY   179      -8.815  26.571  76.764  1.00 32.66          
ATOM   1452  O   GLY   179      -9.944  26.923  76.399  1.00 32.34          
ATOM   1453  N   VAL   180      -7.730  27.353  76.664  1.00 31.61          
ATOM   1454  CA  VAL   180      -7.770  28.641  75.970  1.00 30.94          
ATOM   1455  CB  VAL   180      -7.629  29.867  76.972  1.00 31.08          
ATOM   1456  CG1 VAL   180      -8.695  29.789  78.112  1.00 29.39          
ATOM   1457  CG2 VAL   180      -6.241  29.942  77.538  1.00 29.49          
ATOM   1458  C   VAL   180      -6.735  28.739  74.816  1.00 31.18          
ATOM   1459  O   VAL   180      -5.669  28.123  74.866  1.00 30.89          
ATOM   1460  N   SER   181      -7.039  29.545  73.803  1.00 30.60          
ATOM   1461  CA  SER   181      -6.119  29.762  72.685  1.00 30.70          
ATOM   1462  CB  SER   181      -6.775  30.642  71.613  1.00 30.53          
ATOM   1463  OG  SER   181      -7.894  29.988  70.999  1.00 29.90          
ATOM   1464  C   SER   181      -4.772  30.355  73.106  1.00 30.60          
ATOM   1465  O   SER   181      -4.698  31.208  74.007  1.00 30.11          
ATOM   1466  N   PHE   182      -3.709  29.900  72.440  1.00 30.07          
ATOM   1467  CA  PHE   182      -2.341  30.369  72.734  1.00 29.70          
ATOM   1468  CB  PHE   182      -1.478  29.205  73.229  1.00 28.93          
ATOM   1469  CG  PHE   182      -0.081  29.612  73.644  1.00 30.73          
ATOM   1470  CD1 PHE   182       0.124  30.449  74.761  1.00 29.47          
ATOM   1471  CE1 PHE   182       1.406  30.827  75.151  1.00 31.11          
ATOM   1472  CZ  PHE   182       2.526  30.332  74.445  1.00 28.39          
ATOM   1473  CE2 PHE   182       2.328  29.475  73.331  1.00 28.33          
ATOM   1474  CD2 PHE   182       1.034  29.106  72.962  1.00 28.37          
ATOM   1475  C   PHE   182      -1.633  31.041  71.564  1.00 29.02          
ATOM   1476  O   PHE   182      -1.695  30.573  70.424  1.00 28.62          
ATOM   1477  N   THR   183      -0.943  32.151  71.841  1.00 30.11          
ATOM   1478  CA  THR   183      -0.018  32.699  70.860  1.00 28.82          
ATOM   1479  CB  THR   183      -0.516  34.033  70.270  1.00 30.12          
ATOM   1480  OG1 THR   183      -1.611  33.747  69.388  1.00 30.28          
ATOM   1481  CG2 THR   183       0.621  34.771  69.486  1.00 27.41          
ATOM   1482  C   THR   183       1.368  32.763  71.471  1.00 28.92          
ATOM   1483  O   THR   183       1.591  33.421  72.491  1.00 27.48          
ATOM   1484  N   GLY   184       2.284  32.020  70.873  1.00 28.36          
ATOM   1485  CA  GLY   184       3.663  32.001  71.341  1.00 28.69          
ATOM   1486  C   GLY   184       4.432  33.175  70.739  1.00 29.40          
ATOM   1487  O   GLY   184       4.204  33.561  69.581  1.00 29.16          
ATOM   1488  N   VAL   185       5.289  33.775  71.553  1.00 29.52          
ATOM   1489  CA  VAL   185       6.227  34.823  71.108  0.50 29.57          
ATOM   1491  CB  VAL   185       5.977  36.191  71.805  0.50 29.47          
ATOM   1493  CG1 VAL   185       6.778  37.296  71.119  0.50 30.12          
ATOM   1495  CG2 VAL   185       4.518  36.544  71.808  0.50 29.56          
ATOM   1497  C   VAL   185       7.653  34.390  71.427  1.00 29.06          
ATOM   1498  O   VAL   185       7.987  34.165  72.587  1.00 29.80          
ATOM   1499  N   THR   186       8.501  34.296  70.412  1.00 29.30          
ATOM   1500  CA  THR   186       9.882  33.835  70.612  1.00 28.58          
ATOM   1501  CB  THR   186      10.460  33.142  69.334  1.00 28.68          
ATOM   1502  OG1 THR   186      10.512  34.084  68.261  1.00 29.27          
ATOM   1503  CG2 THR   186       9.609  31.926  68.898  1.00 27.42          
ATOM   1504  C   THR   186      10.818  34.915  71.149  1.00 28.67          
ATOM   1505  O   THR   186      11.954  35.027  70.700  1.00 28.42          
ATOM   1506  N   SER   187      10.357  35.678  72.149  1.00 28.95          
ATOM   1507  CA  SER   187      11.169  36.731  72.796  1.00 29.25          
ATOM   1508  CB  SER   187      10.308  37.935  73.169  1.00 29.27          
ATOM   1509  OG  SER   187       9.157  37.486  73.857  1.00 31.18          
ATOM   1510  C   SER   187      11.890  36.215  74.052  1.00 29.26          
ATOM   1511  O   SER   187      12.588  36.976  74.717  1.00 28.99          
ATOM   1512  N   GLY   188      11.722  34.929  74.357  1.00 29.16          
ATOM   1513  CA  GLY   188      12.452  34.291  75.446  1.00 29.38          
ATOM   1514  C   GLY   188      13.575  33.397  74.951  1.00 29.82          
ATOM   1515  O   GLY   188      14.352  33.786  74.080  1.00 30.49          
ATOM   1516  N   MET   189      13.652  32.185  75.503  1.00 30.04          
ATOM   1517  CA  MET   189      14.651  31.196  75.092  1.00 30.01          
ATOM   1518  CB  MET   189      15.408  30.630  76.296  1.00 30.07          
ATOM   1519  CG  MET   189      16.126  31.615  77.109  1.00 31.09          
ATOM   1520  SD  MET   189      17.657  32.307  76.282  0.70 34.38          
ATOM   1521  CE  MET   189      18.750  30.708  76.149  1.00 34.13          
ATOM   1522  C   MET   189      14.031  30.019  74.345  1.00 29.96          
ATOM   1523  O   MET   189      14.740  29.062  74.018  1.00 29.46          
ATOM   1524  N   THR   190      12.727  30.090  74.101  1.00 29.08          
ATOM   1525  CA  THR   190      11.991  29.049  73.389  1.00 30.03          
ATOM   1526  CB  THR   190      10.582  28.862  73.995  1.00 30.20          
ATOM   1527  OG1 THR   190      10.719  28.608  75.384  1.00 34.60          
ATOM   1528  CG2 THR   190       9.802  27.720  73.330  1.00 30.40          
ATOM   1529  C   THR   190      11.851  29.425  71.916  1.00 29.62          
ATOM   1530  O   THR   190      11.431  30.545  71.578  1.00 29.07          
ATOM   1531  N   THR   191      12.216  28.473  71.061  1.00 29.44          
ATOM   1532  CA  THR   191      12.183  28.624  69.607  1.00 29.39          
ATOM   1533  CB  THR   191      13.310  27.793  68.957  1.00 30.38          
ATOM   1534  OG1 THR   191      12.979  26.401  69.037  1.00 30.50          
ATOM   1535  CG2 THR   191      14.646  28.058  69.660  1.00 28.76          
ATOM   1536  C   THR   191      10.853  28.152  69.045  1.00 29.76          
ATOM   1537  O   THR   191      10.117  27.432  69.739  1.00 29.53          
ATOM   1538  N   ALA   192      10.544  28.548  67.793  1.00 29.58          
ATOM   1539  CA  ALA   192       9.320  28.119  67.118  1.00 29.13          
ATOM   1540  CB  ALA   192       9.172  28.791  65.722  1.00 29.19          
ATOM   1541  C   ALA   192       9.223  26.577  67.008  1.00 29.09          
ATOM   1542  O   ALA   192       8.128  26.005  67.122  1.00 28.85          
ATOM   1543  N   GLN   193      10.355  25.922  66.777  1.00 28.17          
ATOM   1544  CA  GLN   193      10.406  24.464  66.753  1.00 28.79          
ATOM   1545  CB  GLN   193      11.809  23.956  66.399  1.00 28.22          
ATOM   1546  CG  GLN   193      11.884  22.420  66.195  1.00 29.86          
ATOM   1547  CD  GLN   193      12.031  21.593  67.516  1.00 33.91          
ATOM   1548  OE1 GLN   193      12.375  22.130  68.580  1.00 36.29          
ATOM   1549  NE2 GLN   193      11.770  20.281  67.433  1.00 31.80          
ATOM   1550  C   GLN   193       9.957  23.869  68.077  1.00 28.83          
ATOM   1551  O   GLN   193       9.182  22.911  68.082  1.00 29.61          
ATOM   1552  N   GLU   194      10.404  24.455  69.195  1.00 27.92          
ATOM   1553  CA  GLU   194      10.016  23.973  70.520  1.00 27.72          
ATOM   1554  CB  GLU   194      10.903  24.578  71.604  1.00 28.41          
ATOM   1555  CG  GLU   194      12.358  24.124  71.434  1.00 29.11          
ATOM   1556  CD  GLU   194      13.352  24.946  72.264  1.00 33.55          
ATOM   1557  OE1 GLU   194      13.063  26.101  72.631  1.00 31.87          
ATOM   1558  OE2 GLU   194      14.468  24.438  72.505  1.00 36.61          
ATOM   1559  C   GLU   194       8.539  24.118  70.849  1.00 28.13          
ATOM   1560  O   GLU   194       7.996  23.286  71.576  1.00 28.95          
ATOM   1561  N   PHE   195       7.876  25.134  70.291  1.00 27.78          
ATOM   1562  CA  PHE   195       6.448  25.356  70.560  1.00 27.60          
ATOM   1563  CB  PHE   195       5.999  26.722  70.031  1.00 27.04          
ATOM   1564  CG  PHE   195       6.227  27.873  70.988  1.00 28.57          
ATOM   1565  CD1 PHE   195       5.556  27.932  72.213  1.00 28.10          
ATOM   1566  CE1 PHE   195       5.738  29.019  73.065  1.00 28.60          
ATOM   1567  CZ  PHE   195       6.623  30.059  72.707  1.00 28.17          
ATOM   1568  CE2 PHE   195       7.285  30.014  71.505  1.00 29.42          
ATOM   1569  CD2 PHE   195       7.073  28.920  70.636  1.00 29.20          
ATOM   1570  C   PHE   195       5.595  24.322  69.886  1.00 27.81          
ATOM   1571  O   PHE   195       4.388  24.246  70.172  1.00 28.62          
ATOM   1572  N   GLN   196       6.193  23.565  68.953  1.00 28.00          
ATOM   1573  CA  GLN   196       5.415  22.654  68.060  1.00 28.03          
ATOM   1574  CB  GLN   196       6.234  22.121  66.858  1.00 28.17          
ATOM   1575  CG  GLN   196       6.634  23.160  65.824  1.00 29.26          
ATOM   1576  CD  GLN   196       5.496  24.111  65.490  1.00 32.07          
ATOM   1577  OE1 GLN   196       4.407  23.676  65.136  1.00 31.14          
ATOM   1578  NE2 GLN   196       5.751  25.418  65.584  1.00 32.53          
ATOM   1579  C   GLN   196       4.828  21.505  68.847  1.00 27.41          
ATOM   1580  O   GLN   196       3.836  20.909  68.443  1.00 26.80          
ATOM   1581  N   ALA   197       5.441  21.233  70.000  1.00 27.36          
ATOM   1582  CA  ALA   197       4.963  20.211  70.916  1.00 27.34          
ATOM   1583  CB  ALA   197       5.976  19.969  71.995  1.00 27.40          
ATOM   1584  C   ALA   197       3.599  20.549  71.529  1.00 26.75          
ATOM   1585  O   ALA   197       2.985  19.700  72.159  1.00 27.17          
ATOM   1586  N   TYR   198       3.132  21.784  71.348  1.00 27.66          
ATOM   1587  CA  TYR   198       1.888  22.273  71.987  1.00 27.71          
ATOM   1588  CB  TYR   198       2.222  23.218  73.155  1.00 28.98          
ATOM   1589  CG  TYR   198       3.075  22.606  74.241  1.00 31.68          
ATOM   1590  CD1 TYR   198       2.493  22.084  75.418  1.00 31.00          
ATOM   1591  CE1 TYR   198       3.317  21.526  76.432  1.00 33.40          
ATOM   1592  CZ  TYR   198       4.701  21.471  76.220  1.00 31.87          
ATOM   1593  OH  TYR   198       5.542  20.945  77.177  1.00 33.47          
ATOM   1594  CE2 TYR   198       5.276  21.957  75.053  1.00 31.80          
ATOM   1595  CD2 TYR   198       4.478  22.534  74.089  1.00 30.17          
ATOM   1596  C   TYR   198       1.028  23.062  71.006  1.00 27.44          
ATOM   1597  O   TYR   198       1.554  23.596  70.012  1.00 25.39          
ATOM   1598  N   PRO   199      -0.291  23.188  71.307  1.00 26.95          
ATOM   1599  CA  PRO   199      -1.191  23.937  70.432  1.00 27.37          
ATOM   1600  CB  PRO   199      -2.607  23.578  70.968  1.00 27.67          
ATOM   1601  CG  PRO   199      -2.415  22.459  71.974  1.00 26.62          
ATOM   1602  CD  PRO   199      -0.996  22.613  72.470  1.00 27.05          
ATOM   1603  C   PRO   199      -0.940  25.455  70.438  1.00 27.64          
ATOM   1604  O   PRO   199      -0.574  26.036  71.464  1.00 28.07          
ATOM   1605  N   TYR   200      -1.122  26.094  69.291  1.00 28.51          
ATOM   1606  CA  TYR   200      -0.984  27.553  69.181  1.00 28.39          
ATOM   1607  CB  TYR   200       0.483  27.956  68.937  1.00 28.12          
ATOM   1608  CG  TYR   200       1.092  27.286  67.713  1.00 29.23          
ATOM   1609  CD1 TYR   200       1.055  27.904  66.452  1.00 30.22          
ATOM   1610  CE1 TYR   200       1.600  27.269  65.316  1.00 27.75          
ATOM   1611  CZ  TYR   200       2.163  26.012  65.453  1.00 28.10          
ATOM   1612  OH  TYR   200       2.700  25.386  64.349  1.00 28.06          
ATOM   1613  CE2 TYR   200       2.194  25.374  66.692  1.00 26.81          
ATOM   1614  CD2 TYR   200       1.675  26.006  67.805  1.00 29.53          
ATOM   1615  C   TYR   200      -1.854  28.017  68.011  1.00 29.50          
ATOM   1616  O   TYR   200      -2.206  27.214  67.120  1.00 28.52          
ATOM   1617  N   ASP   201      -2.167  29.306  68.021  1.00 29.42          
ATOM   1618  CA  ASP   201      -2.749  29.989  66.892  1.00 30.78          
ATOM   1619  CB  ASP   201      -3.443  31.268  67.386  1.00 31.84          
ATOM   1620  CG  ASP   201      -4.895  31.063  67.642  1.00 34.16          
ATOM   1621  OD1 ASP   201      -5.302  29.885  67.776  1.00 35.12          
ATOM   1622  OD2 ASP   201      -5.629  32.079  67.695  1.00 37.28          
ATOM   1623  C   ASP   201      -1.698  30.412  65.906  1.00 30.46          
ATOM   1624  O   ASP   201      -1.764  30.067  64.733  1.00 30.55          
ATOM   1625  N   ARG   202      -0.770  31.219  66.409  1.00 30.69          
ATOM   1626  CA  ARG   202       0.383  31.726  65.703  1.00 30.71          
ATOM   1627  CB  ARG   202       0.173  33.219  65.357  1.00 30.87          
ATOM   1628  CG  ARG   202      -0.615  33.475  64.109  1.00 32.31          
ATOM   1629  CD  ARG   202      -0.559  34.954  63.773  1.00 35.48          
ATOM   1630  NE  ARG   202      -1.190  35.768  64.806  1.00 37.62          
ATOM   1631  CZ  ARG   202      -1.028  37.082  64.932  1.00 39.80          
ATOM   1632  NH1 ARG   202      -0.239  37.745  64.091  1.00 42.12          
ATOM   1633  NH2 ARG   202      -1.656  37.733  65.893  1.00 38.13          
ATOM   1634  C   ARG   202       1.593  31.653  66.626  1.00 30.68          
ATOM   1635  O   ARG   202       1.461  31.511  67.855  1.00 31.05          
ATOM   1636  N   ILE   203       2.775  31.719  66.016  1.00 29.99          
ATOM   1637  CA  ILE   203       4.021  31.914  66.733  0.50 29.91          
ATOM   1639  CB  ILE   203       4.980  30.689  66.644  0.50 29.40          
ATOM   1641  CG1 ILE   203       4.316  29.388  67.127  0.50 28.07          
ATOM   1643  CD  ILE   203       4.012  29.281  68.634  0.50 24.34          
ATOM   1645  CG2 ILE   203       6.279  30.975  67.415  0.50 30.13          
ATOM   1647  C   ILE   203       4.680  33.123  66.078  1.00 30.29          
ATOM   1648  O   ILE   203       5.018  33.072  64.882  1.00 31.17          
ATOM   1649  N   ILE   204       4.859  34.190  66.853  1.00 30.12          
ATOM   1650  CA  ILE   204       5.346  35.470  66.342  1.00 30.67          
ATOM   1651  CB  ILE   204       4.348  36.614  66.701  1.00 30.30          
ATOM   1652  CG1 ILE   204       3.968  36.571  68.184  1.00 30.24          
ATOM   1653  CD  ILE   204       3.245  37.841  68.688  1.00 31.03          
ATOM   1654  CG2 ILE   204       3.063  36.491  65.837  1.00 30.53          
ATOM   1655  C   ILE   204       6.740  35.752  66.864  1.00 30.85          
ATOM   1656  O   ILE   204       7.143  35.145  67.855  1.00 32.34          
ATOM   1657  N   SER   205       7.479  36.657  66.223  1.00 30.89          
ATOM   1658  CA  SER   205       8.802  37.060  66.731  1.00 31.63          
ATOM   1659  CB  SER   205       9.761  37.523  65.616  1.00 31.53          
ATOM   1660  OG  SER   205       9.422  36.957  64.387  1.00 34.62          
ATOM   1661  C   SER   205       8.726  38.184  67.727  1.00 31.36          
ATOM   1662  O   SER   205       9.549  38.262  68.636  1.00 31.48          
ATOM   1663  N   THR   206       7.780  39.094  67.528  1.00 31.39          
ATOM   1664  CA  THR   206       7.694  40.256  68.397  1.00 31.78          
ATOM   1665  CB  THR   206       8.300  41.547  67.768  1.00 31.65          
ATOM   1666  OG1 THR   206       7.678  41.831  66.496  1.00 29.92          
ATOM   1667  CG2 THR   206       9.799  41.393  67.560  1.00 31.94          
ATOM   1668  C   THR   206       6.249  40.468  68.768  1.00 32.33          
ATOM   1669  O   THR   206       5.361  40.078  68.033  1.00 32.08          
ATOM   1670  N   LEU   207       6.031  41.076  69.926  1.00 32.23          
ATOM   1671  CA  LEU   207       4.695  41.333  70.432  1.00 32.50          
ATOM   1672  CB  LEU   207       4.810  42.054  71.769  1.00 32.65          
ATOM   1673  CG  LEU   207       3.731  41.888  72.812  1.00 32.55          
ATOM   1674  CD1 LEU   207       3.511  40.409  73.119  1.00 31.90          
ATOM   1675  CD2 LEU   207       4.156  42.696  74.074  1.00 32.43          
ATOM   1676  C   LEU   207       3.883  42.193  69.491  1.00 32.69          
ATOM   1677  O   LEU   207       2.659  42.042  69.420  1.00 31.97          
ATOM   1678  N   GLY   208       4.566  43.099  68.785  1.00 33.30          
ATOM   1679  CA  GLY   208       3.915  44.042  67.854  1.00 34.10          
ATOM   1680  C   GLY   208       3.157  43.356  66.723  1.00 34.93          
ATOM   1681  O   GLY   208       2.197  43.917  66.148  1.00 34.41          
ATOM   1682  N   GLN   209       3.585  42.132  66.426  1.00 35.26          
ATOM   1683  CA  GLN   209       2.970  41.301  65.428  1.00 37.01          
ATOM   1684  CB  GLN   209       3.897  40.153  65.086  1.00 37.01          
ATOM   1685  CG  GLN   209       4.944  40.551  64.079  1.00 39.42          
ATOM   1686  CD  GLN   209       6.007  39.515  63.924  1.00 43.33          
ATOM   1687  OE1 GLN   209       5.726  38.322  63.928  1.00 47.40          
ATOM   1688  NE2 GLN   209       7.246  39.958  63.786  1.00 44.87          
ATOM   1689  C   GLN   209       1.622  40.782  65.877  1.00 37.66          
ATOM   1690  O   GLN   209       0.838  40.275  65.078  1.00 37.76          
ATOM   1691  N   LEU   210       1.340  40.922  67.159  1.00 38.30          
ATOM   1692  CA  LEU   210       0.026  40.564  67.689  1.00 39.49          
ATOM   1693  CB  LEU   210       0.023  40.739  69.216  1.00 39.62          
ATOM   1694  CG  LEU   210      -0.703  39.828  70.214  1.00 39.33          
ATOM   1695  CD1 LEU   210      -0.693  38.331  69.883  1.00 36.10          
ATOM   1696  CD2 LEU   210      -0.077  40.083  71.560  1.00 37.45          
ATOM   1697  C   LEU   210      -1.054  41.400  67.016  1.00 40.60          
ATOM   1698  O   LEU   210      -2.172  40.925  66.781  1.00 41.32          
ATOM   1699  N   ILE   211      -0.697  42.640  66.685  1.00 41.56          
ATOM   1700  CA  ILE   211      -1.547  43.572  65.950  1.00 41.96          
ATOM   1701  CB  ILE   211      -1.172  45.062  66.259  1.00 42.21          
ATOM   1702  CG1 ILE   211      -1.168  45.366  67.774  1.00 42.34          
ATOM   1703  CD  ILE   211      -2.480  45.107  68.511  1.00 41.30          
ATOM   1704  CG2 ILE   211      -2.040  46.032  65.448  1.00 43.37          
ATOM   1705  C   ILE   211      -1.374  43.340  64.456  1.00 41.85          
ATOM   1706  O   ILE   211      -2.312  42.930  63.776  1.00 42.35          
END
