
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  163 ( 1284),  selected  163 , name 1yr0_A
# Molecule2: number of CA atoms  159 ( 1259),  selected  159 , name T0417.pdb
# PARAMETERS: 1yr0_A.T0417.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     4_A      R      26          1.517
LGA    V     5_A      Y      27          1.882
LGA    E     6_A      H      28          1.565
LGA    L     7_A      L      29          1.110
LGA    R     8_A      R      30          1.625
LGA    D     9_A      P      31          2.042
LGA    A    10_A      P      32          1.675
LGA    T    11_A      R      33          1.673
LGA    V    12_A      R      34          2.319
LGA    D    13_A      N      35          3.270
LGA    D    14_A      D      36          2.303
LGA    L    15_A      G      37          2.222
LGA    S    16_A      A      38          1.879
LGA    G    17_A      A      39          1.448
LGA    I    18_A      I      40          0.886
LGA    X    19_A      H      41          1.285
LGA    E    20_A      Q      42          0.934
LGA    I    21_A      L      43          1.754
LGA    Y    22_A      V      44          2.507
LGA    N    23_A      S      45          2.980
LGA    D    24_A      E      46          3.414
LGA    A    25_A      C      47          4.225
LGA    V    26_A      -       -           -
LGA    V    27_A      -       -           -
LGA    N    28_A      P      48          2.573
LGA    T    29_A      P      49          0.773
LGA    T    30_A      L      50          4.599
LGA    A    31_A      -       -           -
LGA    I    32_A      D      51          2.974
LGA    W    33_A      -       -           -
LGA    N    34_A      -       -           -
LGA    E    35_A      -       -           -
LGA    V    36_A      L      52          5.353
LGA    V    37_A      N      53          4.343
LGA    V    38_A      S      54          1.836
LGA    D    39_A      L      55          2.371
LGA    L    40_A      -       -           -
LGA    E    41_A      Y      56          4.114
LGA    N    42_A      A      57          3.896
LGA    R    43_A      Y      58          2.733
LGA    K    44_A      L      59          2.475
LGA    D    45_A      L      60          2.626
LGA    W    46_A      L      61          2.771
LGA    F    47_A      C      62          1.707
LGA    A    48_A      E      63          1.588
LGA    A    49_A      H      64          1.769
LGA    R    50_A      H      65          1.373
LGA    T    51_A      A      66          4.197
LGA    S    52_A      -       -           -
LGA    R    53_A      -       -           -
LGA    G    54_A      -       -           -
LGA    F    55_A      H      67          3.731
LGA    P    56_A      T      68          1.911
LGA    V    57_A      C      69          2.107
LGA    I    58_A      V      70          1.136
LGA    V    59_A      V      71          0.899
LGA    A    60_A      A      72          0.649
LGA    I    61_A      E      73          1.165
LGA    L    62_A      S      74          2.276
LGA    D    63_A      P      75          4.996
LGA    G    64_A      G      76          1.994
LGA    -       -      G      77           -
LGA    K    65_A      R      78          0.667
LGA    V    66_A      I      79          0.568
LGA    A    67_A      D      80          1.168
LGA    G    68_A      G      81          0.321
LGA    Y    69_A      F      82          1.156
LGA    A    70_A      V      83          1.506
LGA    S    71_A      S      84          2.976
LGA    Y    72_A      A      85          1.260
LGA    G    73_A      Y      86          1.433
LGA    D    74_A      L      87          4.414
LGA    W    75_A      L      88          4.388
LGA    R    76_A      -       -           -
LGA    A    77_A      P      89          4.935
LGA    F    78_A      T      90          2.825
LGA    D    79_A      -       -           -
LGA    G    80_A      -       -           -
LGA    Y    81_A      R      91          1.136
LGA    R    82_A      P      92          1.936
LGA    H    83_A      D      93          1.563
LGA    T    84_A      V      94          1.336
LGA    R    85_A      L      95          2.049
LGA    E    86_A      F      96          0.523
LGA    H    87_A      V      97          1.222
LGA    S    88_A      W      98          3.633
LGA    -       -      Q      99           -
LGA    V    89_A      V     100          2.116
LGA    Y    90_A      A     101          1.545
LGA    V    91_A      V     102          0.910
LGA    H    92_A      H     103          1.655
LGA    K    93_A      S     104          2.797
LGA    D    94_A      R     105          2.261
LGA    A    95_A      A     106          1.318
LGA    R    96_A      R     107          1.750
LGA    G    97_A      G     108          1.966
LGA    H    98_A      H     109          1.504
LGA    G    99_A      R     110          1.199
LGA    I   100_A      L     111          0.907
LGA    G   101_A      G     112          1.078
LGA    K   102_A      R     113          1.171
LGA    R   103_A      A     114          0.455
LGA    L   104_A      M     115          0.530
LGA    X   105_A      L     116          1.096
LGA    Q   106_A      G     117          0.986
LGA    A   107_A      H     118          0.883
LGA    L   108_A      I     119          1.859
LGA    I   109_A      L     120          1.872
LGA    D   110_A      E     121          1.268
LGA    H   111_A      R     122          2.099
LGA    -       -      Q     123           -
LGA    A   112_A      E     124           #
LGA    G   113_A      C     125          4.049
LGA    G   114_A      R     126          2.075
LGA    N   115_A      -       -           -
LGA    D   116_A      H     127          2.074
LGA    V   117_A      V     128          1.807
LGA    H   118_A      R     129          1.930
LGA    V   119_A      H     130          1.340
LGA    L   120_A      L     131          1.087
LGA    I   121_A      E     132          0.544
LGA    A   122_A      T     133          1.644
LGA    A   123_A      T     134          1.034
LGA    I   124_A      V     135          1.230
LGA    E   125_A      G     136          1.611
LGA    A   126_A      P     137          2.135
LGA    E   127_A      D     138          1.275
LGA    N   128_A      N     139          0.887
LGA    T   129_A      Q     140          0.870
LGA    A   130_A      A     141          0.920
LGA    S   131_A      S     142          0.397
LGA    I   132_A      R     143          0.672
LGA    R   133_A      R     144          0.962
LGA    L   134_A      T     145          1.047
LGA    H   135_A      F     146          0.864
LGA    E   136_A      A     147          0.719
LGA    S   137_A      G     148          1.161
LGA    L   138_A      L     149          1.054
LGA    G   139_A      A     150          0.917
LGA    -       -      G     151           -
LGA    -       -      E     152           -
LGA    -       -      R     153           -
LGA    -       -      G     154           -
LGA    -       -      A     155           -
LGA    F   140_A      H     156           #
LGA    R   141_A      V     157          0.912
LGA    V   142_A      S     158          2.242
LGA    V   143_A      E     159          2.819
LGA    G   144_A      Q     160          1.544
LGA    R   145_A      P     161          2.789
LGA    F   146_A      F     162          3.615
LGA    S   147_A      F     163           #
LGA    E   148_A      D     164          2.886
LGA    -       -      R     165           -
LGA    -       -      Q     166           -
LGA    V   149_A      A     167          4.326
LGA    G   150_A      F     168          3.846
LGA    -       -      G     169           -
LGA    T   151_A      G     170           #
LGA    K   152_A      A     171           #
LGA    F   153_A      D     172          4.206
LGA    G   154_A      -       -           -
LGA    R   155_A      -       -           -
LGA    W   156_A      H     173          4.994
LGA    L   157_A      D     174          1.900
LGA    D   158_A      D     175          2.156
LGA    L   159_A      E     176          1.895
LGA    T   160_A      M     177          2.253
LGA    C   161_A      L     178          1.801
LGA    X   162_A      L     179          1.782
LGA    E   163_A      R     180          1.813
LGA    L   164_A      I     181          2.230
LGA    K   165_A      G     182          2.129
LGA    -       -      P     183           -
LGA    L   166_A      F     184          2.181

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  163  159    5.0    142    2.29    18.31     64.117     5.953

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.718187 * X  +  -0.693109 * Y  +  -0.061708 * Z  +  65.466316
  Y_new =   0.693592 * X  +  -0.705898 * Y  +  -0.143659 * Z  +  15.432970
  Z_new =   0.056012 * X  +  -0.145974 * Y  +   0.987701 * Z  +  42.471695 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.146730    2.994863  [ DEG:    -8.4070    171.5930 ]
  Theta =  -0.056041   -3.085552  [ DEG:    -3.2109   -176.7891 ]
  Phi   =   2.373613   -0.767979  [ DEG:   135.9980    -44.0020 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1yr0_A                                        
REMARK     2: T0417.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1yr0_A.T0417.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  163  159   5.0  142   2.29   18.31  64.117
REMARK  ---------------------------------------------------------- 
MOLECULE 1yr0_A
HEADER    TRANSFERASE                             02-FEB-05   1YR0              
TITLE     CRYSTAL STRUCTURE OF PHOSPHINOTHRICIN ACETYLTRANSFERASE               
TITLE    2 FROM AGROBACTERIUM TUMEFACIENS                                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHOSPHINOTHRICIN ACETYLTRANSFERASE;                        
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: AGR_C_1654P;                                                
COMPND   5 EC: 2.3.1.-;                                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AGROBACTERIUM TUMEFACIENS;                      
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: C58;                                                         
SOURCE   5 GENE: AGR_C_1654;                                                    
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: B834 DE3;                                  
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PET T7                                    
KEYWDS    STRUCTURAL GENOMICS, PROTEIN STRUCTURE INITIATIVE, NYSGXRC,           
KEYWDS   2 T1682, AGR_C_1654, PHOSPHINOTHRICIN ACETYLTRANSFERASE, PSI,          
KEYWDS   3 NEW YORK STRUCTURAL GENOMIX RESEARCH CONSORTIUM                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.K.BURLEY,NEW YORK STRUCTURAL GENOMIX RESEARCH CONSORTIUM            
AUTHOR   2 (NYSGXRC)                                                            
REVDAT   1   15-FEB-05 1YR0    0                                                
JRNL        AUTH   K.R.RAJASHANKAR,R.KNIEWEL,K.LEE,C.D.LIMA                     
JRNL        TITL   CRYSTAL STRUCTURE OF PHOSPHINOTHRICIN                        
JRNL        TITL 2 ACETYLTRANSFERASE FROM AGROBACTERIUM TUMEFACIENS             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  1YR0 A    1   167  UNP    Q8UGX8   Q8UGX8_AGRT5     1    165             
DBREF  1YR0 B    1   167  UNP    Q8UGX8   Q8UGX8_AGRT5     1    165             
DBREF  1YR0 C    1   167  UNP    Q8UGX8   Q8UGX8_AGRT5     1    165             
DBREF  1YR0 D    1   167  UNP    Q8UGX8   Q8UGX8_AGRT5     1    165             
SEQRES   1 A  175  MSE SER LEU SER VAL GLU LEU ARG ASP ALA THR VAL ASP          
SEQRES   2 A  175  ASP LEU SER GLY ILE MSE GLU ILE TYR ASN ASP ALA VAL          
SEQRES   3 A  175  VAL ASN THR THR ALA ILE TRP ASN GLU VAL VAL VAL ASP          
SEQRES   4 A  175  LEU GLU ASN ARG LYS ASP TRP PHE ALA ALA ARG THR SER          
SEQRES   5 A  175  ARG GLY PHE PRO VAL ILE VAL ALA ILE LEU ASP GLY LYS          
SEQRES   6 A  175  VAL ALA GLY TYR ALA SER TYR GLY ASP TRP ARG ALA PHE          
SEQRES   7 A  175  ASP GLY TYR ARG HIS THR ARG GLU HIS SER VAL TYR VAL          
SEQRES   8 A  175  HIS LYS ASP ALA ARG GLY HIS GLY ILE GLY LYS ARG LEU          
SEQRES   9 A  175  MSE GLN ALA LEU ILE ASP HIS ALA GLY GLY ASN ASP VAL          
SEQRES  10 A  175  HIS VAL LEU ILE ALA ALA ILE GLU ALA GLU ASN THR ALA          
SEQRES  11 A  175  SER ILE ARG LEU HIS GLU SER LEU GLY PHE ARG VAL VAL          
SEQRES  12 A  175  GLY ARG PHE SER GLU VAL GLY THR LYS PHE GLY ARG TRP          
SEQRES  13 A  175  LEU ASP LEU THR CYS MSE GLU LEU LYS LEU GLY GLU GLY          
SEQRES  14 A  175  HIS HIS HIS HIS HIS HIS                                      
SEQRES   1 B  175  MSE SER LEU SER VAL GLU LEU ARG ASP ALA THR VAL ASP          
SEQRES   2 B  175  ASP LEU SER GLY ILE MSE GLU ILE TYR ASN ASP ALA VAL          
SEQRES   3 B  175  VAL ASN THR THR ALA ILE TRP ASN GLU VAL VAL VAL ASP          
SEQRES   4 B  175  LEU GLU ASN ARG LYS ASP TRP PHE ALA ALA ARG THR SER          
SEQRES   5 B  175  ARG GLY PHE PRO VAL ILE VAL ALA ILE LEU ASP GLY LYS          
SEQRES   6 B  175  VAL ALA GLY TYR ALA SER TYR GLY ASP TRP ARG ALA PHE          
SEQRES   7 B  175  ASP GLY TYR ARG HIS THR ARG GLU HIS SER VAL TYR VAL          
SEQRES   8 B  175  HIS LYS ASP ALA ARG GLY HIS GLY ILE GLY LYS ARG LEU          
SEQRES   9 B  175  MSE GLN ALA LEU ILE ASP HIS ALA GLY GLY ASN ASP VAL          
SEQRES  10 B  175  HIS VAL LEU ILE ALA ALA ILE GLU ALA GLU ASN THR ALA          
SEQRES  11 B  175  SER ILE ARG LEU HIS GLU SER LEU GLY PHE ARG VAL VAL          
SEQRES  12 B  175  GLY ARG PHE SER GLU VAL GLY THR LYS PHE GLY ARG TRP          
SEQRES  13 B  175  LEU ASP LEU THR CYS MSE GLU LEU LYS LEU GLY GLU GLY          
SEQRES  14 B  175  HIS HIS HIS HIS HIS HIS                                      
SEQRES   1 C  175  MSE SER LEU SER VAL GLU LEU ARG ASP ALA THR VAL ASP          
SEQRES   2 C  175  ASP LEU SER GLY ILE MSE GLU ILE TYR ASN ASP ALA VAL          
SEQRES   3 C  175  VAL ASN THR THR ALA ILE TRP ASN GLU VAL VAL VAL ASP          
SEQRES   4 C  175  LEU GLU ASN ARG LYS ASP TRP PHE ALA ALA ARG THR SER          
SEQRES   5 C  175  ARG GLY PHE PRO VAL ILE VAL ALA ILE LEU ASP GLY LYS          
SEQRES   6 C  175  VAL ALA GLY TYR ALA SER TYR GLY ASP TRP ARG ALA PHE          
SEQRES   7 C  175  ASP GLY TYR ARG HIS THR ARG GLU HIS SER VAL TYR VAL          
SEQRES   8 C  175  HIS LYS ASP ALA ARG GLY HIS GLY ILE GLY LYS ARG LEU          
SEQRES   9 C  175  MSE GLN ALA LEU ILE ASP HIS ALA GLY GLY ASN ASP VAL          
SEQRES  10 C  175  HIS VAL LEU ILE ALA ALA ILE GLU ALA GLU ASN THR ALA          
SEQRES  11 C  175  SER ILE ARG LEU HIS GLU SER LEU GLY PHE ARG VAL VAL          
SEQRES  12 C  175  GLY ARG PHE SER GLU VAL GLY THR LYS PHE GLY ARG TRP          
SEQRES  13 C  175  LEU ASP LEU THR CYS MSE GLU LEU LYS LEU GLY GLU GLY          
SEQRES  14 C  175  HIS HIS HIS HIS HIS HIS                                      
SEQRES   1 D  175  MSE SER LEU SER VAL GLU LEU ARG ASP ALA THR VAL ASP          
SEQRES   2 D  175  ASP LEU SER GLY ILE MSE GLU ILE TYR ASN ASP ALA VAL          
SEQRES   3 D  175  VAL ASN THR THR ALA ILE TRP ASN GLU VAL VAL VAL ASP          
SEQRES   4 D  175  LEU GLU ASN ARG LYS ASP TRP PHE ALA ALA ARG THR SER          
SEQRES   5 D  175  ARG GLY PHE PRO VAL ILE VAL ALA ILE LEU ASP GLY LYS          
SEQRES   6 D  175  VAL ALA GLY TYR ALA SER TYR GLY ASP TRP ARG ALA PHE          
SEQRES   7 D  175  ASP GLY TYR ARG HIS THR ARG GLU HIS SER VAL TYR VAL          
SEQRES   8 D  175  HIS LYS ASP ALA ARG GLY HIS GLY ILE GLY LYS ARG LEU          
SEQRES   9 D  175  MSE GLN ALA LEU ILE ASP HIS ALA GLY GLY ASN ASP VAL          
SEQRES  10 D  175  HIS VAL LEU ILE ALA ALA ILE GLU ALA GLU ASN THR ALA          
SEQRES  11 D  175  SER ILE ARG LEU HIS GLU SER LEU GLY PHE ARG VAL VAL          
SEQRES  12 D  175  GLY ARG PHE SER GLU VAL GLY THR LYS PHE GLY ARG TRP          
SEQRES  13 D  175  LEU ASP LEU THR CYS MSE GLU LEU LYS LEU GLY GLU GLY          
SEQRES  14 D  175  HIS HIS HIS HIS HIS HIS                                      
HET    MSE  A  19       8                                                       
HET    MSE  A 105       8                                                       
HET    MSE  A 162       8                                                       
HET    MSE  B  19       8                                                       
HET    MSE  B 105       8                                                       
HET    MSE  B 162       8                                                       
HET    MSE  C  19       8                                                       
HET    MSE  C 105       8                                                       
HET    MSE  C 162       8                                                       
HET    MSE  D  19       8                                                       
HET    MSE  D 105       8                                                       
HET    MSE  D 162       8                                                       
HET    SO4   1001       5                                                       
HET    SO4   1002       5                                                       
HET    SO4   1003       5                                                       
HET    SO4   1004       5                                                       
HET    SO4   1005       5                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SO4 SULFATE ION                                                      
FORMUL   1  MSE    12(C5 H11 N O2 SE)                                           
FORMUL   5  SO4    5(O4 S 2-)                                                   
FORMUL  10  HOH   *823(H2 O)                                                    
CRYST1   73.849   64.490  145.447  90.00  99.30  90.00 C 1 2 1      16          
ATOM      1  N   SER A   4      -8.901 -21.272  58.302  1.00 30.93           N  
ATOM      2  CA  SER A   4      -7.482 -21.496  57.900  1.00 31.52           C  
ATOM      3  C   SER A   4      -6.940 -20.376  57.021  1.00 30.76           C  
ATOM      4  O   SER A   4      -7.679 -19.738  56.266  1.00 31.53           O  
ATOM      5  CB  SER A   4      -7.334 -22.834  57.171  1.00 33.30           C  
ATOM      6  OG  SER A   4      -7.372 -23.918  58.087  1.00 37.62           O  
ATOM      7  N   VAL A   5      -5.638 -20.142  57.138  1.00 28.87           N  
ATOM      8  CA  VAL A   5      -4.968 -19.105  56.371  1.00 25.94           C  
ATOM      9  C   VAL A   5      -4.086 -19.734  55.312  1.00 23.85           C  
ATOM     10  O   VAL A   5      -3.485 -20.777  55.543  1.00 23.84           O  
ATOM     11  CB  VAL A   5      -4.056 -18.248  57.259  1.00 25.76           C  
ATOM     12  CG1 VAL A   5      -3.454 -17.123  56.435  1.00 24.41           C  
ATOM     13  CG2 VAL A   5      -4.834 -17.707  58.441  1.00 26.79           C  
ATOM     14  N   GLU A   6      -4.005 -19.092  54.155  1.00 22.02           N  
ATOM     15  CA  GLU A   6      -3.164 -19.584  53.075  1.00 21.49           C  
ATOM     16  C   GLU A   6      -2.364 -18.428  52.484  1.00 20.56           C  
ATOM     17  O   GLU A   6      -2.870 -17.309  52.357  1.00 18.68           O  
ATOM     18  CB  GLU A   6      -4.011 -20.231  51.979  1.00 22.39           C  
ATOM     19  CG  GLU A   6      -4.785 -21.470  52.414  1.00 25.70           C  
ATOM     20  CD  GLU A   6      -3.909 -22.535  53.043  1.00 25.81           C  
ATOM     21  OE1 GLU A   6      -2.706 -22.604  52.706  1.00 28.63           O  
ATOM     22  OE2 GLU A   6      -4.426 -23.318  53.868  1.00 23.01           O  
ATOM     23  N   LEU A   7      -1.112 -18.703  52.133  1.00 19.11           N  
ATOM     24  CA  LEU A   7      -0.235 -17.688  51.551  1.00 18.87           C  
ATOM     25  C   LEU A   7       0.005 -17.938  50.057  1.00 18.01           C  
ATOM     26  O   LEU A   7       0.040 -19.085  49.610  1.00 16.98           O  
ATOM     27  CB  LEU A   7       1.107 -17.654  52.297  1.00 18.30           C  
ATOM     28  CG  LEU A   7       1.180 -16.884  53.628  1.00 19.54           C  
ATOM     29  CD1 LEU A   7       0.241 -17.497  54.646  1.00 20.55           C  
ATOM     30  CD2 LEU A   7       2.614 -16.897  54.154  1.00 18.71           C  
ATOM     31  N   ARG A   8       0.162 -16.856  49.299  1.00 16.53           N  
ATOM     32  CA  ARG A   8       0.399 -16.935  47.864  1.00 16.36           C  
ATOM     33  C   ARG A   8       0.927 -15.609  47.348  1.00 16.44           C  
ATOM     34  O   ARG A   8       0.939 -14.613  48.077  1.00 17.42           O  
ATOM     35  CB  ARG A   8      -0.894 -17.281  47.110  1.00 16.62           C  
ATOM     36  CG  ARG A   8      -2.001 -16.224  47.199  1.00 17.07           C  
ATOM     37  CD  ARG A   8      -3.165 -16.533  46.242  1.00 19.39           C  
ATOM     38  NE  ARG A   8      -4.313 -15.635  46.398  1.00 18.38           N  
ATOM     39  CZ  ARG A   8      -4.294 -14.321  46.171  1.00 20.92           C  
ATOM     40  NH1 ARG A   8      -3.179 -13.726  45.775  1.00 19.98           N  
ATOM     41  NH2 ARG A   8      -5.398 -13.593  46.333  1.00 17.26           N  
ATOM     42  N   ASP A   9       1.362 -15.598  46.091  1.00 13.18           N  
ATOM     43  CA  ASP A   9       1.864 -14.375  45.475  1.00 13.58           C  
ATOM     44  C   ASP A   9       0.712 -13.390  45.342  1.00 12.49           C  
ATOM     45  O   ASP A   9      -0.418 -13.774  45.032  1.00 11.07           O  
ATOM     46  CB  ASP A   9       2.418 -14.633  44.065  1.00 11.43           C  
ATOM     47  CG  ASP A   9       3.763 -15.333  44.072  1.00 13.56           C  
ATOM     48  OD1 ASP A   9       4.414 -15.370  45.132  1.00  8.88           O  
ATOM     49  OD2 ASP A   9       4.170 -15.830  43.000  1.00 11.76           O  
ATOM     50  N   ALA A  10       1.005 -12.119  45.579  1.00 13.18           N  
ATOM     51  CA  ALA A  10       0.001 -11.078  45.445  1.00 12.28           C  
ATOM     52  C   ALA A  10      -0.154 -10.794  43.954  1.00 13.74           C  
ATOM     53  O   ALA A  10       0.787 -10.987  43.184  1.00 13.81           O  
ATOM     54  CB  ALA A  10       0.460  -9.819  46.160  1.00 12.53           C  
ATOM     55  N   THR A  11      -1.352 -10.383  43.543  1.00 14.01           N  
ATOM     56  CA  THR A  11      -1.597 -10.007  42.150  1.00 14.74           C  
ATOM     57  C   THR A  11      -2.141  -8.586  42.216  1.00 14.98           C  
ATOM     58  O   THR A  11      -2.391  -8.068  43.310  1.00 11.80           O  
ATOM     59  CB  THR A  11      -2.664 -10.890  41.451  1.00 14.97           C  
ATOM     60  OG1 THR A  11      -3.934 -10.703  42.086  1.00 19.03           O  
ATOM     61  CG2 THR A  11      -2.275 -12.358  41.503  1.00 13.88           C  
ATOM     62  N   VAL A  12      -2.334  -7.954  41.062  1.00 15.81           N  
ATOM     63  CA  VAL A  12      -2.859  -6.596  41.057  1.00 17.84           C  
ATOM     64  C   VAL A  12      -4.220  -6.559  41.753  1.00 17.28           C  
ATOM     65  O   VAL A  12      -4.598  -5.542  42.325  1.00 17.39           O  
ATOM     66  CB  VAL A  12      -2.999  -6.016  39.607  1.00 18.66           C  
ATOM     67  CG1 VAL A  12      -1.620  -5.819  38.985  1.00 19.44           C  
ATOM     68  CG2 VAL A  12      -3.849  -6.933  38.746  1.00 20.91           C  
ATOM     69  N   ASP A  13      -4.936  -7.679  41.729  1.00 18.58           N  
ATOM     70  CA  ASP A  13      -6.254  -7.742  42.355  1.00 20.02           C  
ATOM     71  C   ASP A  13      -6.227  -7.674  43.881  1.00 18.22           C  
ATOM     72  O   ASP A  13      -7.266  -7.469  44.508  1.00 18.57           O  
ATOM     73  CB  ASP A  13      -6.993  -9.003  41.906  1.00 22.42           C  
ATOM     74  CG  ASP A  13      -7.243  -9.022  40.410  1.00 26.28           C  
ATOM     75  OD1 ASP A  13      -7.561  -7.955  39.844  1.00 26.81           O  
ATOM     76  OD2 ASP A  13      -7.133 -10.104  39.803  1.00 30.55           O  
ATOM     77  N   ASP A  14      -5.047  -7.838  44.476  1.00 16.74           N  
ATOM     78  CA  ASP A  14      -4.912  -7.777  45.935  1.00 15.65           C  
ATOM     79  C   ASP A  14      -4.414  -6.406  46.385  1.00 14.56           C  
ATOM     80  O   ASP A  14      -4.271  -6.162  47.583  1.00 14.44           O  
ATOM     81  CB  ASP A  14      -3.899  -8.812  46.441  1.00 14.41           C  
ATOM     82  CG  ASP A  14      -4.251 -10.220  46.050  1.00 14.73           C  
ATOM     83  OD1 ASP A  14      -5.369 -10.666  46.365  1.00 14.77           O  
ATOM     84  OD2 ASP A  14      -3.403 -10.890  45.433  1.00 15.17           O  
ATOM     85  N   LEU A  15      -4.159  -5.509  45.439  1.00 12.94           N  
ATOM     86  CA  LEU A  15      -3.615  -4.201  45.792  1.00 14.65           C  
ATOM     87  C   LEU A  15      -4.476  -3.280  46.656  1.00 13.82           C  
ATOM     88  O   LEU A  15      -3.939  -2.547  47.491  1.00 12.29           O  
ATOM     89  CB  LEU A  15      -3.147  -3.470  44.521  1.00 13.78           C  
ATOM     90  CG  LEU A  15      -2.043  -4.200  43.745  1.00 15.41           C  
ATOM     91  CD1 LEU A  15      -1.589  -3.345  42.568  1.00 14.66           C  
ATOM     92  CD2 LEU A  15      -0.860  -4.503  44.660  1.00 12.00           C  
ATOM     93  N   SER A  16      -5.796  -3.299  46.484  1.00 13.36           N  
ATOM     94  CA  SER A  16      -6.625  -2.436  47.314  1.00 13.36           C  
ATOM     95  C   SER A  16      -6.598  -2.959  48.757  1.00 14.09           C  
ATOM     96  O   SER A  16      -6.587  -2.175  49.704  1.00 14.96           O  
ATOM     97  CB  SER A  16      -8.066  -2.335  46.771  1.00 13.31           C  
ATOM     98  OG  SER A  16      -8.762  -3.562  46.832  1.00 16.29           O  
ATOM     99  N   GLY A  17      -6.570  -4.278  48.927  1.00 14.05           N  
ATOM    100  CA  GLY A  17      -6.496  -4.831  50.270  1.00 13.08           C  
ATOM    101  C   GLY A  17      -5.147  -4.509  50.909  1.00 15.21           C  
ATOM    102  O   GLY A  17      -5.059  -4.213  52.103  1.00 15.84           O  
ATOM    103  N   ILE A  18      -4.085  -4.577  50.110  1.00 14.31           N  
ATOM    104  CA  ILE A  18      -2.737  -4.281  50.584  1.00 12.39           C  
ATOM    105  C   ILE A  18      -2.682  -2.799  50.967  1.00 13.45           C  
ATOM    106  O   ILE A  18      -2.146  -2.426  52.014  1.00 12.47           O  
ATOM    107  CB  ILE A  18      -1.677  -4.616  49.479  1.00 10.26           C  
ATOM    108  CG1 ILE A  18      -1.516  -6.140  49.368  1.00 11.41           C  
ATOM    109  CG2 ILE A  18      -0.322  -3.984  49.808  1.00  9.71           C  
ATOM    110  CD1 ILE A  18      -0.469  -6.596  48.353  1.00  9.04           C  
HETATM  111  N   MSE A  19      -3.280  -1.962  50.129  1.00 15.38           N  
HETATM  112  CA  MSE A  19      -3.323  -0.524  50.373  1.00 16.45           C  
HETATM  113  C   MSE A  19      -3.960  -0.218  51.726  1.00 16.90           C  
HETATM  114  O   MSE A  19      -3.463   0.614  52.491  1.00 15.76           O  
HETATM  115  CB  MSE A  19      -4.124   0.157  49.263  1.00 16.77           C  
HETATM  116  CG  MSE A  19      -4.381   1.633  49.493  1.00 23.19           C  
HETATM  117 SE   MSE A  19      -5.672   2.292  48.215  1.00 28.83          SE  
HETATM  118  CE  MSE A  19      -7.290   1.800  49.156  1.00 31.07           C  
ATOM    119  N   GLU A  20      -5.065  -0.890  52.023  1.00 16.80           N  
ATOM    120  CA  GLU A  20      -5.764  -0.663  53.281  1.00 16.50           C  
ATOM    121  C   GLU A  20      -4.906  -1.015  54.486  1.00 15.11           C  
ATOM    122  O   GLU A  20      -4.899  -0.290  55.471  1.00 17.00           O  
ATOM    123  CB  GLU A  20      -7.064  -1.466  53.314  1.00 17.59           C  
ATOM    124  CG  GLU A  20      -8.018  -1.136  52.170  1.00 18.49           C  
ATOM    125  CD  GLU A  20      -9.246  -2.015  52.176  1.00 19.24           C  
ATOM    126  OE1 GLU A  20      -9.156  -3.152  52.693  1.00 19.76           O  
ATOM    127  OE2 GLU A  20     -10.298  -1.580  51.656  1.00 20.90           O  
ATOM    128  N   ILE A  21      -4.185  -2.129  54.414  1.00 14.10           N  
ATOM    129  CA  ILE A  21      -3.333  -2.536  55.524  1.00 12.55           C  
ATOM    130  C   ILE A  21      -2.188  -1.549  55.696  1.00 11.49           C  
ATOM    131  O   ILE A  21      -1.825  -1.191  56.815  1.00 11.76           O  
ATOM    132  CB  ILE A  21      -2.765  -3.961  55.300  1.00 11.25           C  
ATOM    133  CG1 ILE A  21      -3.899  -4.983  55.420  1.00 11.20           C  
ATOM    134  CG2 ILE A  21      -1.660  -4.262  56.333  1.00 11.64           C  
ATOM    135  CD1 ILE A  21      -3.496  -6.412  55.111  1.00 13.82           C  
ATOM    136  N   TYR A  22      -1.621  -1.123  54.573  1.00 13.48           N  
ATOM    137  CA  TYR A  22      -0.522  -0.172  54.574  1.00 13.53           C  
ATOM    138  C   TYR A  22      -0.969   1.155  55.189  1.00 14.69           C  
ATOM    139  O   TYR A  22      -0.316   1.687  56.090  1.00 13.32           O  
ATOM    140  CB  TYR A  22      -0.048   0.059  53.137  1.00 16.59           C  
ATOM    141  CG  TYR A  22       1.072   1.063  53.009  1.00 17.33           C  
ATOM    142  CD1 TYR A  22       2.407   0.658  53.065  1.00 19.77           C  
ATOM    143  CD2 TYR A  22       0.798   2.423  52.863  1.00 18.35           C  
ATOM    144  CE1 TYR A  22       3.443   1.585  52.978  1.00 19.80           C  
ATOM    145  CE2 TYR A  22       1.826   3.359  52.779  1.00 20.14           C  
ATOM    146  CZ  TYR A  22       3.146   2.929  52.838  1.00 20.88           C  
ATOM    147  OH  TYR A  22       4.163   3.845  52.777  1.00 19.84           O  
ATOM    148  N   ASN A  23      -2.083   1.689  54.698  1.00 13.43           N  
ATOM    149  CA  ASN A  23      -2.582   2.952  55.214  1.00 13.67           C  
ATOM    150  C   ASN A  23      -2.925   2.880  56.684  1.00 14.22           C  
ATOM    151  O   ASN A  23      -2.684   3.828  57.430  1.00 14.39           O  
ATOM    152  CB  ASN A  23      -3.786   3.414  54.399  1.00 13.79           C  
ATOM    153  CG  ASN A  23      -3.376   3.905  53.034  1.00 17.31           C  
ATOM    154  OD1 ASN A  23      -2.224   4.320  52.847  1.00 14.88           O  
ATOM    155  ND2 ASN A  23      -4.302   3.878  52.075  1.00 15.49           N  
ATOM    156  N   ASP A  24      -3.472   1.752  57.114  1.00 14.98           N  
ATOM    157  CA  ASP A  24      -3.806   1.625  58.518  1.00 16.19           C  
ATOM    158  C   ASP A  24      -2.536   1.712  59.364  1.00 16.16           C  
ATOM    159  O   ASP A  24      -2.527   2.359  60.412  1.00 15.60           O  
ATOM    160  CB  ASP A  24      -4.499   0.300  58.794  1.00 16.61           C  
ATOM    161  CG  ASP A  24      -4.781   0.110  60.256  1.00 18.24           C  
ATOM    162  OD1 ASP A  24      -5.756   0.707  60.752  1.00 18.75           O  
ATOM    163  OD2 ASP A  24      -4.009  -0.613  60.915  1.00 18.68           O  
ATOM    164  N   ALA A  25      -1.469   1.055  58.912  1.00 15.59           N  
ATOM    165  CA  ALA A  25      -0.202   1.078  59.643  1.00 15.50           C  
ATOM    166  C   ALA A  25       0.319   2.510  59.732  1.00 14.69           C  
ATOM    167  O   ALA A  25       0.784   2.953  60.780  1.00 14.82           O  
ATOM    168  CB  ALA A  25       0.822   0.185  58.950  1.00 14.80           C  
ATOM    169  N   VAL A  26       0.232   3.234  58.625  1.00 15.27           N  
ATOM    170  CA  VAL A  26       0.683   4.619  58.599  1.00 16.57           C  
ATOM    171  C   VAL A  26      -0.075   5.470  59.612  1.00 17.15           C  
ATOM    172  O   VAL A  26       0.516   6.290  60.316  1.00 16.03           O  
ATOM    173  CB  VAL A  26       0.474   5.245  57.217  1.00 16.96           C  
ATOM    174  CG1 VAL A  26       0.837   6.724  57.261  1.00 18.50           C  
ATOM    175  CG2 VAL A  26       1.322   4.518  56.183  1.00 15.84           C  
ATOM    176  N   VAL A  27      -1.388   5.270  59.676  1.00 17.09           N  
ATOM    177  CA  VAL A  27      -2.240   6.037  60.578  1.00 18.84           C  
ATOM    178  C   VAL A  27      -2.105   5.721  62.072  1.00 18.60           C  
ATOM    179  O   VAL A  27      -2.005   6.638  62.884  1.00 18.24           O  
ATOM    180  CB  VAL A  27      -3.756   5.891  60.200  1.00 17.95           C  
ATOM    181  CG1 VAL A  27      -4.627   6.551  61.263  1.00 20.60           C  
ATOM    182  CG2 VAL A  27      -4.033   6.528  58.849  1.00 17.09           C  
ATOM    183  N   ASN A  28      -2.098   4.442  62.443  1.00 19.03           N  
ATOM    184  CA  ASN A  28      -2.027   4.095  63.866  1.00 20.52           C  
ATOM    185  C   ASN A  28      -0.812   3.373  64.418  1.00 18.13           C  
ATOM    186  O   ASN A  28      -0.849   2.928  65.560  1.00 20.04           O  
ATOM    187  CB  ASN A  28      -3.257   3.278  64.270  1.00 24.28           C  
ATOM    188  CG  ASN A  28      -4.515   4.101  64.293  1.00 25.93           C  
ATOM    189  OD1 ASN A  28      -5.189   4.242  63.281  1.00 32.22           O  
ATOM    190  ND2 ASN A  28      -4.833   4.668  65.449  1.00 30.29           N  
ATOM    191  N   THR A  29       0.260   3.248  63.647  1.00 18.81           N  
ATOM    192  CA  THR A  29       1.420   2.525  64.157  1.00 17.59           C  
ATOM    193  C   THR A  29       2.747   3.155  63.787  1.00 16.32           C  
ATOM    194  O   THR A  29       2.809   4.106  63.008  1.00 15.00           O  
ATOM    195  CB  THR A  29       1.442   1.075  63.641  1.00 17.88           C  
ATOM    196  OG1 THR A  29       1.904   1.062  62.284  1.00 18.63           O  
ATOM    197  CG2 THR A  29       0.041   0.469  63.694  1.00 18.27           C  
ATOM    198  N   THR A  30       3.808   2.594  64.355  1.00 15.86           N  
ATOM    199  CA  THR A  30       5.165   3.046  64.101  1.00 15.05           C  
ATOM    200  C   THR A  30       5.839   2.085  63.114  1.00 15.39           C  
ATOM    201  O   THR A  30       7.060   2.048  63.009  1.00 15.72           O  
ATOM    202  CB  THR A  30       5.990   3.074  65.407  1.00 16.61           C  
ATOM    203  OG1 THR A  30       5.992   1.766  65.997  1.00 16.79           O  
ATOM    204  CG2 THR A  30       5.392   4.064  66.398  1.00 16.85           C  
ATOM    205  N   ALA A  31       5.041   1.305  62.394  1.00 15.11           N  
ATOM    206  CA  ALA A  31       5.582   0.357  61.426  1.00 15.73           C  
ATOM    207  C   ALA A  31       6.095   1.076  60.187  1.00 15.22           C  
ATOM    208  O   ALA A  31       6.979   0.578  59.502  1.00 16.36           O  
ATOM    209  CB  ALA A  31       4.511  -0.663  61.036  1.00 16.16           C  
ATOM    210  N   ILE A  32       5.536   2.253  59.917  1.00 16.20           N  
ATOM    211  CA  ILE A  32       5.917   3.061  58.754  1.00 15.72           C  
ATOM    212  C   ILE A  32       6.173   4.476  59.244  1.00 16.47           C  
ATOM    213  O   ILE A  32       5.265   5.143  59.733  1.00 16.61           O  
ATOM    214  CB  ILE A  32       4.793   3.087  57.715  1.00 16.99           C  
ATOM    215  CG1 ILE A  32       4.481   1.655  57.267  1.00 17.19           C  
ATOM    216  CG2 ILE A  32       5.191   3.956  56.533  1.00 16.70           C  
ATOM    217  CD1 ILE A  32       3.279   1.548  56.363  1.00 22.23           C  
ATOM    218  N   TRP A  33       7.411   4.932  59.109  1.00 15.37           N  
ATOM    219  CA  TRP A  33       7.790   6.254  59.587  1.00 16.20           C  
ATOM    220  C   TRP A  33       7.485   7.456  58.686  1.00 17.05           C  
ATOM    221  O   TRP A  33       8.379   8.094  58.126  1.00 16.80           O  
ATOM    222  CB  TRP A  33       9.267   6.228  59.995  1.00 14.07           C  
ATOM    223  CG  TRP A  33       9.517   5.367  61.225  1.00 14.78           C  
ATOM    224  CD1 TRP A  33       8.682   4.418  61.742  1.00 17.03           C  
ATOM    225  CD2 TRP A  33      10.684   5.367  62.061  1.00 16.28           C  
ATOM    226  NE1 TRP A  33       9.253   3.830  62.845  1.00 16.59           N  
ATOM    227  CE2 TRP A  33      10.482   4.392  63.063  1.00 16.17           C  
ATOM    228  CE3 TRP A  33      11.881   6.096  62.061  1.00 15.34           C  
ATOM    229  CZ2 TRP A  33      11.433   4.126  64.053  1.00 16.06           C  
ATOM    230  CZ3 TRP A  33      12.827   5.829  63.046  1.00 14.34           C  
ATOM    231  CH2 TRP A  33      12.597   4.855  64.025  1.00 16.40           C  
ATOM    232  N   ASN A  34       6.196   7.748  58.575  1.00 19.47           N  
ATOM    233  CA  ASN A  34       5.682   8.881  57.817  1.00 22.48           C  
ATOM    234  C   ASN A  34       4.167   8.839  57.980  1.00 22.88           C  
ATOM    235  O   ASN A  34       3.625   7.854  58.482  1.00 20.67           O  
ATOM    236  CB  ASN A  34       6.072   8.797  56.333  1.00 25.51           C  
ATOM    237  CG  ASN A  34       5.419   7.633  55.614  1.00 25.84           C  
ATOM    238  OD1 ASN A  34       4.199   7.511  55.585  1.00 25.29           O  
ATOM    239  ND2 ASN A  34       6.240   6.770  55.024  1.00 29.32           N  
ATOM    240  N   GLU A  35       3.490   9.905  57.574  1.00 22.46           N  
ATOM    241  CA  GLU A  35       2.040   9.969  57.691  1.00 25.68           C  
ATOM    242  C   GLU A  35       1.412  10.051  56.314  1.00 26.28           C  
ATOM    243  O   GLU A  35       0.328  10.611  56.158  1.00 28.61           O  
ATOM    244  CB  GLU A  35       1.605  11.203  58.496  1.00 26.67           C  
ATOM    245  CG  GLU A  35       2.119  11.286  59.928  1.00 28.18           C  
ATOM    246  CD  GLU A  35       3.543  11.805  60.021  1.00 30.55           C  
ATOM    247  OE1 GLU A  35       4.050  12.363  59.020  1.00 32.17           O  
ATOM    248  OE2 GLU A  35       4.152  11.668  61.105  1.00 32.02           O  
ATOM    249  N   VAL A  36       2.087   9.494  55.317  1.00 26.68           N  
ATOM    250  CA  VAL A  36       1.587   9.549  53.948  1.00 26.60           C  
ATOM    251  C   VAL A  36       0.677   8.386  53.572  1.00 25.44           C  
ATOM    252  O   VAL A  36       1.128   7.255  53.413  1.00 22.31           O  
ATOM    253  CB  VAL A  36       2.759   9.609  52.936  1.00 27.83           C  
ATOM    254  CG1 VAL A  36       2.228   9.881  51.536  1.00 27.68           C  
ATOM    255  CG2 VAL A  36       3.750  10.683  53.355  1.00 28.57           C  
ATOM    256  N   VAL A  37      -0.613   8.675  53.443  1.00 25.85           N  
ATOM    257  CA  VAL A  37      -1.581   7.663  53.048  1.00 27.51           C  
ATOM    258  C   VAL A  37      -1.435   7.503  51.540  1.00 26.92           C  
ATOM    259  O   VAL A  37      -1.319   8.494  50.822  1.00 28.33           O  
ATOM    260  CB  VAL A  37      -3.029   8.105  53.387  1.00 28.40           C  
ATOM    261  CG1 VAL A  37      -3.326   9.466  52.769  1.00 29.20           C  
ATOM    262  CG2 VAL A  37      -4.015   7.076  52.877  1.00 30.53           C  
ATOM    263  N   VAL A  38      -1.437   6.263  51.064  1.00 26.64           N  
ATOM    264  CA  VAL A  38      -1.278   5.992  49.636  1.00 27.64           C  
ATOM    265  C   VAL A  38      -2.571   5.539  48.967  1.00 28.16           C  
ATOM    266  O   VAL A  38      -3.486   5.057  49.631  1.00 28.73           O  
ATOM    267  CB  VAL A  38      -0.204   4.901  49.392  1.00 27.11           C  
ATOM    268  CG1 VAL A  38       1.097   5.284  50.080  1.00 26.88           C  
ATOM    269  CG2 VAL A  38      -0.699   3.554  49.899  1.00 27.91           C  
ATOM    270  N   ASP A  39      -2.639   5.689  47.647  1.00 27.23           N  
ATOM    271  CA  ASP A  39      -3.824   5.284  46.894  1.00 26.78           C  
ATOM    272  C   ASP A  39      -3.517   4.041  46.066  1.00 25.26           C  
ATOM    273  O   ASP A  39      -2.430   3.473  46.164  1.00 26.12           O  
ATOM    274  CB  ASP A  39      -4.268   6.411  45.971  1.00 28.86           C  
ATOM    275  CG  ASP A  39      -3.311   6.621  44.823  1.00 30.03           C  
ATOM    276  OD1 ASP A  39      -2.092   6.649  45.077  1.00 31.23           O  
ATOM    277  OD2 ASP A  39      -3.776   6.758  43.671  1.00 33.55           O  
ATOM    278  N   LEU A  40      -4.467   3.635  45.231  1.00 23.18           N  
ATOM    279  CA  LEU A  40      -4.290   2.446  44.408  1.00 22.87           C  
ATOM    280  C   LEU A  40      -3.150   2.566  43.397  1.00 22.70           C  
ATOM    281  O   LEU A  40      -2.398   1.615  43.206  1.00 20.16           O  
ATOM    282  CB  LEU A  40      -5.594   2.104  43.677  1.00 21.36           C  
ATOM    283  CG  LEU A  40      -5.608   0.742  42.971  1.00 23.06           C  
ATOM    284  CD1 LEU A  40      -5.359  -0.365  43.995  1.00 22.12           C  
ATOM    285  CD2 LEU A  40      -6.939   0.529  42.263  1.00 21.54           C  
ATOM    286  N   GLU A  41      -3.021   3.719  42.742  1.00 23.84           N  
ATOM    287  CA  GLU A  41      -1.948   3.891  41.761  1.00 25.29           C  
ATOM    288  C   GLU A  41      -0.598   3.663  42.417  1.00 24.14           C  
ATOM    289  O   GLU A  41       0.274   3.014  41.843  1.00 24.93           O  
ATOM    290  CB  GLU A  41      -1.954   5.292  41.145  1.00 27.22           C  
ATOM    291  CG  GLU A  41      -3.186   5.655  40.347  1.00 30.97           C  
ATOM    292  CD  GLU A  41      -2.965   6.904  39.495  1.00 34.34           C  
ATOM    293  OE1 GLU A  41      -2.161   7.771  39.909  1.00 36.11           O  
ATOM    294  OE2 GLU A  41      -3.600   7.015  38.423  1.00 35.19           O  
ATOM    295  N   ASN A  42      -0.425   4.198  43.623  1.00 21.97           N  
ATOM    296  CA  ASN A  42       0.836   4.037  44.329  1.00 20.98           C  
ATOM    297  C   ASN A  42       1.177   2.557  44.507  1.00 19.75           C  
ATOM    298  O   ASN A  42       2.305   2.155  44.254  1.00 17.31           O  
ATOM    299  CB  ASN A  42       0.791   4.737  45.696  1.00 21.98           C  
ATOM    300  CG  ASN A  42       2.013   4.429  46.552  1.00 22.86           C  
ATOM    301  OD1 ASN A  42       2.140   3.339  47.113  1.00 22.39           O  
ATOM    302  ND2 ASN A  42       2.923   5.390  46.651  1.00 25.03           N  
ATOM    303  N   ARG A  43       0.203   1.751  44.923  1.00 18.19           N  
ATOM    304  CA  ARG A  43       0.438   0.327  45.125  1.00 18.27           C  
ATOM    305  C   ARG A  43       0.719  -0.378  43.806  1.00 18.30           C  
ATOM    306  O   ARG A  43       1.490  -1.335  43.754  1.00 17.57           O  
ATOM    307  CB  ARG A  43      -0.764  -0.324  45.818  1.00 16.32           C  
ATOM    308  CG  ARG A  43      -0.951   0.068  47.290  1.00 20.65           C  
ATOM    309  CD  ARG A  43       0.216  -0.370  48.183  1.00 19.42           C  
ATOM    310  NE  ARG A  43       1.336   0.562  48.127  1.00 20.90           N  
ATOM    311  CZ  ARG A  43       2.492   0.401  48.768  1.00 22.98           C  
ATOM    312  NH1 ARG A  43       2.704  -0.668  49.530  1.00 20.22           N  
ATOM    313  NH2 ARG A  43       3.440   1.323  48.648  1.00 20.01           N  
ATOM    314  N   LYS A  44       0.084   0.102  42.742  1.00 19.76           N  
ATOM    315  CA  LYS A  44       0.273  -0.459  41.412  1.00 20.41           C  
ATOM    316  C   LYS A  44       1.713  -0.272  40.952  1.00 18.58           C  
ATOM    317  O   LYS A  44       2.337  -1.210  40.457  1.00 17.15           O  
ATOM    318  CB  LYS A  44      -0.678   0.216  40.425  1.00 21.21           C  
ATOM    319  CG  LYS A  44      -1.859  -0.640  40.043  1.00 26.07           C  
ATOM    320  CD  LYS A  44      -3.119   0.197  39.945  1.00 28.32           C  
ATOM    321  CE  LYS A  44      -4.190  -0.540  39.178  1.00 31.07           C  
ATOM    322  NZ  LYS A  44      -3.836  -0.596  37.728  1.00 35.79           N  
ATOM    323  N   ASP A  45       2.238   0.941  41.110  1.00 17.91           N  
ATOM    324  CA  ASP A  45       3.617   1.224  40.712  1.00 18.32           C  
ATOM    325  C   ASP A  45       4.546   0.407  41.584  1.00 18.55           C  
ATOM    326  O   ASP A  45       5.486  -0.221  41.100  1.00 19.96           O  
ATOM    327  CB  ASP A  45       3.950   2.701  40.908  1.00 20.47           C  
ATOM    328  CG  ASP A  45       3.071   3.610  40.085  1.00 23.01           C  
ATOM    329  OD1 ASP A  45       2.677   3.204  38.975  1.00 25.70           O  
ATOM    330  OD2 ASP A  45       2.792   4.734  40.542  1.00 26.80           O  
ATOM    331  N   TRP A  46       4.274   0.453  42.886  1.00 16.43           N  
ATOM    332  CA  TRP A  46       5.034  -0.279  43.891  1.00 14.89           C  
ATOM    333  C   TRP A  46       5.086  -1.749  43.488  1.00 13.60           C  
ATOM    334  O   TRP A  46       6.152  -2.365  43.465  1.00 14.72           O  
ATOM    335  CB  TRP A  46       4.337  -0.130  45.248  1.00 15.70           C  
ATOM    336  CG  TRP A  46       4.873  -1.007  46.354  1.00 15.87           C  
ATOM    337  CD1 TRP A  46       6.031  -0.831  47.059  1.00 13.35           C  
ATOM    338  CD2 TRP A  46       4.249  -2.176  46.893  1.00 14.48           C  
ATOM    339  NE1 TRP A  46       6.164  -1.818  48.009  1.00 15.08           N  
ATOM    340  CE2 TRP A  46       5.084  -2.657  47.932  1.00 15.78           C  
ATOM    341  CE3 TRP A  46       3.062  -2.865  46.604  1.00 13.20           C  
ATOM    342  CZ2 TRP A  46       4.770  -3.799  48.687  1.00 13.04           C  
ATOM    343  CZ3 TRP A  46       2.747  -4.004  47.356  1.00 15.63           C  
ATOM    344  CH2 TRP A  46       3.604  -4.457  48.388  1.00 13.65           C  
ATOM    345  N   PHE A  47       3.924  -2.303  43.163  1.00 10.95           N  
ATOM    346  CA  PHE A  47       3.831  -3.700  42.771  1.00 12.11           C  
ATOM    347  C   PHE A  47       4.552  -4.000  41.457  1.00 13.39           C  
ATOM    348  O   PHE A  47       5.137  -5.073  41.291  1.00 14.19           O  
ATOM    349  CB  PHE A  47       2.366  -4.118  42.642  1.00 12.98           C  
ATOM    350  CG  PHE A  47       2.183  -5.545  42.215  1.00 13.83           C  
ATOM    351  CD1 PHE A  47       2.379  -6.587  43.115  1.00 15.04           C  
ATOM    352  CD2 PHE A  47       1.827  -5.849  40.905  1.00 13.74           C  
ATOM    353  CE1 PHE A  47       2.220  -7.909  42.718  1.00 13.76           C  
ATOM    354  CE2 PHE A  47       1.668  -7.165  40.498  1.00 14.37           C  
ATOM    355  CZ  PHE A  47       1.863  -8.195  41.405  1.00 13.03           C  
ATOM    356  N   ALA A  48       4.505  -3.060  40.519  1.00 13.19           N  
ATOM    357  CA  ALA A  48       5.163  -3.254  39.231  1.00 13.59           C  
ATOM    358  C   ALA A  48       6.686  -3.211  39.385  1.00 14.73           C  
ATOM    359  O   ALA A  48       7.402  -3.988  38.753  1.00 15.40           O  
ATOM    360  CB  ALA A  48       4.704  -2.192  38.235  1.00 13.69           C  
ATOM    361  N   ALA A  49       7.172  -2.316  40.239  1.00 14.91           N  
ATOM    362  CA  ALA A  49       8.610  -2.180  40.463  1.00 17.15           C  
ATOM    363  C   ALA A  49       9.193  -3.404  41.154  1.00 16.20           C  
ATOM    364  O   ALA A  49      10.276  -3.867  40.801  1.00 17.95           O  
ATOM    365  CB  ALA A  49       8.900  -0.936  41.280  1.00 15.98           C  
ATOM    366  N   ARG A  50       8.479  -3.938  42.135  1.00 16.99           N  
ATOM    367  CA  ARG A  50       8.972  -5.116  42.824  1.00 17.29           C  
ATOM    368  C   ARG A  50       8.960  -6.326  41.898  1.00 16.02           C  
ATOM    369  O   ARG A  50       9.916  -7.102  41.882  1.00 14.86           O  
ATOM    370  CB  ARG A  50       8.150  -5.378  44.092  1.00 19.24           C  
ATOM    371  CG  ARG A  50       8.794  -4.756  45.332  1.00 23.52           C  
ATOM    372  CD  ARG A  50       7.796  -4.508  46.433  1.00 25.77           C  
ATOM    373  NE  ARG A  50       8.440  -4.278  47.731  1.00 25.13           N  
ATOM    374  CZ  ARG A  50       9.300  -3.299  47.989  1.00 25.63           C  
ATOM    375  NH1 ARG A  50       9.643  -2.438  47.040  1.00 25.68           N  
ATOM    376  NH2 ARG A  50       9.816  -3.179  49.203  1.00 24.15           N  
ATOM    377  N   THR A  51       7.899  -6.471  41.111  1.00 14.74           N  
ATOM    378  CA  THR A  51       7.798  -7.589  40.182  1.00 14.17           C  
ATOM    379  C   THR A  51       8.984  -7.559  39.210  1.00 14.45           C  
ATOM    380  O   THR A  51       9.609  -8.591  38.952  1.00 13.06           O  
ATOM    381  CB  THR A  51       6.442  -7.548  39.418  1.00 13.70           C  
ATOM    382  OG1 THR A  51       5.375  -7.684  40.366  1.00 15.98           O  
ATOM    383  CG2 THR A  51       6.343  -8.682  38.409  1.00 14.39           C  
ATOM    384  N   SER A  52       9.308  -6.370  38.706  1.00 14.53           N  
ATOM    385  CA  SER A  52      10.430  -6.193  37.786  1.00 15.75           C  
ATOM    386  C   SER A  52      11.772  -6.572  38.429  1.00 15.10           C  
ATOM    387  O   SER A  52      12.604  -7.214  37.793  1.00 15.80           O  
ATOM    388  CB  SER A  52      10.505  -4.736  37.305  1.00 15.54           C  
ATOM    389  OG  SER A  52       9.382  -4.393  36.509  1.00 21.44           O  
ATOM    390  N   ARG A  53      11.980  -6.167  39.681  1.00 14.30           N  
ATOM    391  CA  ARG A  53      13.232  -6.462  40.383  1.00 15.70           C  
ATOM    392  C   ARG A  53      13.281  -7.917  40.845  1.00 13.75           C  
ATOM    393  O   ARG A  53      14.319  -8.400  41.296  1.00 14.05           O  
ATOM    394  CB  ARG A  53      13.398  -5.548  41.611  1.00 16.12           C  
ATOM    395  CG  ARG A  53      13.558  -4.056  41.306  1.00 16.60           C  
ATOM    396  CD  ARG A  53      14.898  -3.746  40.655  1.00 18.68           C  
ATOM    397  NE  ARG A  53      16.037  -4.076  41.513  1.00 16.64           N  
ATOM    398  CZ  ARG A  53      16.396  -3.386  42.594  1.00 19.30           C  
ATOM    399  NH1 ARG A  53      15.704  -2.316  42.965  1.00 16.76           N  
ATOM    400  NH2 ARG A  53      17.462  -3.760  43.296  1.00 18.01           N  
ATOM    401  N   GLY A  54      12.151  -8.604  40.736  1.00 13.42           N  
ATOM    402  CA  GLY A  54      12.089  -9.990  41.156  1.00 13.63           C  
ATOM    403  C   GLY A  54      11.866 -10.100  42.653  1.00 13.88           C  
ATOM    404  O   GLY A  54      12.088 -11.156  43.248  1.00 14.07           O  
ATOM    405  N   PHE A  55      11.441  -9.002  43.271  1.00 11.40           N  
ATOM    406  CA  PHE A  55      11.187  -9.004  44.707  1.00 11.44           C  
ATOM    407  C   PHE A  55       9.792  -9.563  44.921  1.00 11.13           C  
ATOM    408  O   PHE A  55       8.858  -9.197  44.222  1.00 11.41           O  
ATOM    409  CB  PHE A  55      11.273  -7.590  45.293  1.00 11.31           C  
ATOM    410  CG  PHE A  55      12.631  -6.950  45.162  1.00 11.16           C  
ATOM    411  CD1 PHE A  55      13.781  -7.726  45.047  1.00 11.75           C  
ATOM    412  CD2 PHE A  55      12.758  -5.565  45.185  1.00 10.72           C  
ATOM    413  CE1 PHE A  55      15.046  -7.129  44.954  1.00 12.76           C  
ATOM    414  CE2 PHE A  55      14.012  -4.958  45.092  1.00 12.06           C  
ATOM    415  CZ  PHE A  55      15.157  -5.740  44.977  1.00 13.47           C  
ATOM    416  N   PRO A  56       9.634 -10.451  45.906  1.00 11.48           N  
ATOM    417  CA  PRO A  56       8.335 -11.058  46.187  1.00  9.79           C  
ATOM    418  C   PRO A  56       7.333 -10.148  46.879  1.00 13.14           C  
ATOM    419  O   PRO A  56       7.697  -9.167  47.527  1.00 11.77           O  
ATOM    420  CB  PRO A  56       8.707 -12.250  47.057  1.00 13.30           C  
ATOM    421  CG  PRO A  56       9.836 -11.687  47.886  1.00 10.46           C  
ATOM    422  CD  PRO A  56      10.655 -10.921  46.859  1.00  9.94           C  
ATOM    423  N   VAL A  57       6.057 -10.475  46.701  1.00 14.24           N  
ATOM    424  CA  VAL A  57       4.963  -9.763  47.336  1.00 14.48           C  
ATOM    425  C   VAL A  57       4.010 -10.896  47.659  1.00 14.71           C  
ATOM    426  O   VAL A  57       3.325 -11.433  46.784  1.00 14.12           O  
ATOM    427  CB  VAL A  57       4.291  -8.738  46.413  1.00 15.59           C  
ATOM    428  CG1 VAL A  57       3.185  -8.013  47.178  1.00 14.44           C  
ATOM    429  CG2 VAL A  57       5.322  -7.723  45.927  1.00 14.07           C  
ATOM    430  N   ILE A  58       4.005 -11.268  48.931  1.00 13.74           N  
ATOM    431  CA  ILE A  58       3.201 -12.374  49.413  1.00 14.09           C  
ATOM    432  C   ILE A  58       2.042 -11.908  50.276  1.00 12.30           C  
ATOM    433  O   ILE A  58       2.218 -11.078  51.160  1.00 14.20           O  
ATOM    434  CB  ILE A  58       4.088 -13.334  50.246  1.00 12.78           C  
ATOM    435  CG1 ILE A  58       5.305 -13.754  49.422  1.00 15.53           C  
ATOM    436  CG2 ILE A  58       3.297 -14.541  50.669  1.00  9.45           C  
ATOM    437  CD1 ILE A  58       6.379 -14.472  50.231  1.00 17.14           C  
ATOM    438  N   VAL A  59       0.851 -12.436  50.014  1.00 12.54           N  
ATOM    439  CA  VAL A  59      -0.301 -12.072  50.819  1.00 10.07           C  
ATOM    440  C   VAL A  59      -0.834 -13.280  51.557  1.00 11.79           C  
ATOM    441  O   VAL A  59      -0.663 -14.418  51.117  1.00 12.17           O  
ATOM    442  CB  VAL A  59      -1.442 -11.455  49.968  1.00 11.31           C  
ATOM    443  CG1 VAL A  59      -1.046 -10.062  49.503  1.00 10.47           C  
ATOM    444  CG2 VAL A  59      -1.748 -12.342  48.770  1.00 10.69           C  
ATOM    445  N   ALA A  60      -1.440 -13.041  52.713  1.00 13.30           N  
ATOM    446  CA  ALA A  60      -2.042 -14.124  53.478  1.00 12.87           C  
ATOM    447  C   ALA A  60      -3.532 -13.911  53.251  1.00 13.43           C  
ATOM    448  O   ALA A  60      -4.046 -12.804  53.415  1.00 10.50           O  
ATOM    449  CB  ALA A  60      -1.697 -13.997  54.963  1.00 12.94           C  
ATOM    450  N   ILE A  61      -4.214 -14.969  52.845  1.00 13.67           N  
ATOM    451  CA  ILE A  61      -5.640 -14.894  52.571  1.00 15.11           C  
ATOM    452  C   ILE A  61      -6.403 -15.652  53.644  1.00 17.92           C  
ATOM    453  O   ILE A  61      -6.096 -16.809  53.944  1.00 18.08           O  
ATOM    454  CB  ILE A  61      -5.968 -15.506  51.199  1.00 15.98           C  
ATOM    455  CG1 ILE A  61      -5.112 -14.836  50.117  1.00 15.14           C  
ATOM    456  CG2 ILE A  61      -7.465 -15.354  50.896  1.00 14.55           C  
ATOM    457  CD1 ILE A  61      -5.362 -13.351  49.953  1.00 13.82           C  
ATOM    458  N   LEU A  62      -7.387 -14.980  54.226  1.00 20.94           N  
ATOM    459  CA  LEU A  62      -8.220 -15.555  55.267  1.00 22.09           C  
ATOM    460  C   LEU A  62      -9.639 -15.050  55.057  1.00 23.29           C  
ATOM    461  O   LEU A  62      -9.864 -13.849  54.927  1.00 21.74           O  
ATOM    462  CB  LEU A  62      -7.713 -15.129  56.647  1.00 22.65           C  
ATOM    463  CG  LEU A  62      -8.541 -15.564  57.857  1.00 23.06           C  
ATOM    464  CD1 LEU A  62      -8.522 -17.081  57.983  1.00 23.27           C  
ATOM    465  CD2 LEU A  62      -7.970 -14.918  59.110  1.00 24.81           C  
ATOM    466  N   ASP A  63     -10.591 -15.974  55.005  1.00 25.60           N  
ATOM    467  CA  ASP A  63     -11.993 -15.619  54.804  1.00 28.85           C  
ATOM    468  C   ASP A  63     -12.177 -14.829  53.505  1.00 27.94           C  
ATOM    469  O   ASP A  63     -12.953 -13.872  53.448  1.00 29.71           O  
ATOM    470  CB  ASP A  63     -12.495 -14.794  55.996  1.00 33.17           C  
ATOM    471  CG  ASP A  63     -14.011 -14.777  56.100  1.00 37.47           C  
ATOM    472  OD1 ASP A  63     -14.610 -15.870  56.189  1.00 39.59           O  
ATOM    473  OD2 ASP A  63     -14.602 -13.674  56.099  1.00 39.62           O  
ATOM    474  N   GLY A  64     -11.453 -15.228  52.466  1.00 26.97           N  
ATOM    475  CA  GLY A  64     -11.563 -14.557  51.183  1.00 26.10           C  
ATOM    476  C   GLY A  64     -10.885 -13.204  51.053  1.00 25.62           C  
ATOM    477  O   GLY A  64     -10.855 -12.630  49.962  1.00 26.49           O  
ATOM    478  N   LYS A  65     -10.329 -12.683  52.140  1.00 23.45           N  
ATOM    479  CA  LYS A  65      -9.672 -11.380  52.076  1.00 22.17           C  
ATOM    480  C   LYS A  65      -8.195 -11.397  52.478  1.00 19.09           C  
ATOM    481  O   LYS A  65      -7.708 -12.366  53.063  1.00 17.69           O  
ATOM    482  CB  LYS A  65     -10.443 -10.387  52.942  1.00 26.46           C  
ATOM    483  CG  LYS A  65     -10.606 -10.825  54.383  1.00 33.03           C  
ATOM    484  CD  LYS A  65     -11.851 -10.203  55.017  1.00 36.93           C  
ATOM    485  CE  LYS A  65     -13.111 -10.933  54.576  1.00 39.74           C  
ATOM    486  NZ  LYS A  65     -13.294 -10.925  53.095  1.00 41.07           N  
ATOM    487  N   VAL A  66      -7.486 -10.320  52.151  1.00 16.05           N  
ATOM    488  CA  VAL A  66      -6.066 -10.200  52.477  1.00 14.40           C  
ATOM    489  C   VAL A  66      -5.929  -9.923  53.965  1.00 14.19           C  
ATOM    490  O   VAL A  66      -6.325  -8.860  54.444  1.00 14.08           O  
ATOM    491  CB  VAL A  66      -5.409  -9.050  51.669  1.00 15.51           C  
ATOM    492  CG1 VAL A  66      -3.951  -8.878  52.074  1.00 11.94           C  
ATOM    493  CG2 VAL A  66      -5.517  -9.348  50.175  1.00 11.38           C  
ATOM    494  N   ALA A  67      -5.381 -10.890  54.697  1.00 13.24           N  
ATOM    495  CA  ALA A  67      -5.211 -10.751  56.141  1.00 10.23           C  
ATOM    496  C   ALA A  67      -3.793 -10.327  56.508  1.00 11.60           C  
ATOM    497  O   ALA A  67      -3.452 -10.205  57.686  1.00 12.13           O  
ATOM    498  CB  ALA A  67      -5.557 -12.055  56.823  1.00 11.81           C  
ATOM    499  N   GLY A  68      -2.974 -10.094  55.491  1.00 11.02           N  
ATOM    500  CA  GLY A  68      -1.608  -9.677  55.726  1.00 11.54           C  
ATOM    501  C   GLY A  68      -0.794  -9.747  54.452  1.00 11.85           C  
ATOM    502  O   GLY A  68      -1.176 -10.424  53.497  1.00 10.44           O  
ATOM    503  N   TYR A  69       0.325  -9.031  54.412  1.00 10.93           N  
ATOM    504  CA  TYR A  69       1.166  -9.076  53.226  1.00 10.37           C  
ATOM    505  C   TYR A  69       2.612  -8.892  53.631  1.00 10.82           C  
ATOM    506  O   TYR A  69       2.908  -8.397  54.721  1.00  9.98           O  
ATOM    507  CB  TYR A  69       0.714  -8.031  52.196  1.00  9.93           C  
ATOM    508  CG  TYR A  69       1.186  -6.613  52.414  1.00 13.02           C  
ATOM    509  CD1 TYR A  69       2.408  -6.177  51.902  1.00 12.68           C  
ATOM    510  CD2 TYR A  69       0.385  -5.693  53.084  1.00 13.70           C  
ATOM    511  CE1 TYR A  69       2.817  -4.847  52.046  1.00 12.18           C  
ATOM    512  CE2 TYR A  69       0.780  -4.367  53.237  1.00 14.60           C  
ATOM    513  CZ  TYR A  69       1.994  -3.951  52.712  1.00 15.23           C  
ATOM    514  OH  TYR A  69       2.373  -2.624  52.842  1.00 13.20           O  
ATOM    515  N   ALA A  70       3.515  -9.325  52.766  1.00 11.04           N  
ATOM    516  CA  ALA A  70       4.933  -9.235  53.076  1.00 10.96           C  
ATOM    517  C   ALA A  70       5.753  -9.035  51.822  1.00 10.39           C  
ATOM    518  O   ALA A  70       5.356  -9.458  50.742  1.00 11.89           O  
ATOM    519  CB  ALA A  70       5.369 -10.491  53.787  1.00  8.98           C  
ATOM    520  N   SER A  71       6.916  -8.414  51.969  1.00 11.97           N  
ATOM    521  CA  SER A  71       7.756  -8.168  50.813  1.00 11.16           C  
ATOM    522  C   SER A  71       9.148  -7.750  51.271  1.00 10.94           C  
ATOM    523  O   SER A  71       9.417  -7.631  52.469  1.00 12.45           O  
ATOM    524  CB  SER A  71       7.108  -7.055  49.976  1.00 13.32           C  
ATOM    525  OG  SER A  71       7.833  -6.765  48.798  1.00 11.64           O  
ATOM    526  N   TYR A  72      10.046  -7.564  50.319  1.00 11.33           N  
ATOM    527  CA  TYR A  72      11.371  -7.069  50.646  1.00 11.18           C  
ATOM    528  C   TYR A  72      11.892  -6.328  49.447  1.00 11.94           C  
ATOM    529  O   TYR A  72      11.394  -6.496  48.335  1.00 13.17           O  
ATOM    530  CB  TYR A  72      12.334  -8.177  51.124  1.00  6.35           C  
ATOM    531  CG  TYR A  72      12.709  -9.285  50.164  1.00  9.00           C  
ATOM    532  CD1 TYR A  72      12.346 -10.608  50.434  1.00  7.79           C  
ATOM    533  CD2 TYR A  72      13.478  -9.032  49.023  1.00  8.11           C  
ATOM    534  CE1 TYR A  72      12.736 -11.645  49.595  1.00 10.03           C  
ATOM    535  CE2 TYR A  72      13.874 -10.065  48.175  1.00  7.40           C  
ATOM    536  CZ  TYR A  72      13.502 -11.363  48.467  1.00  9.08           C  
ATOM    537  OH  TYR A  72      13.885 -12.384  47.634  1.00  7.50           O  
ATOM    538  N   GLY A  73      12.860  -5.460  49.692  1.00 13.11           N  
ATOM    539  CA  GLY A  73      13.436  -4.673  48.626  1.00 11.97           C  
ATOM    540  C   GLY A  73      14.824  -4.239  49.028  1.00 12.65           C  
ATOM    541  O   GLY A  73      15.438  -4.863  49.893  1.00 13.01           O  
ATOM    542  N   ASP A  74      15.325  -3.174  48.416  1.00 13.22           N  
ATOM    543  CA  ASP A  74      16.660  -2.701  48.748  1.00 14.01           C  
ATOM    544  C   ASP A  74      16.758  -2.267  50.204  1.00 15.00           C  
ATOM    545  O   ASP A  74      15.794  -1.778  50.791  1.00 13.82           O  
ATOM    546  CB  ASP A  74      17.073  -1.503  47.888  1.00 14.60           C  
ATOM    547  CG  ASP A  74      17.213  -1.839  46.411  1.00 14.86           C  
ATOM    548  OD1 ASP A  74      17.757  -2.907  46.069  1.00 14.56           O  
ATOM    549  OD2 ASP A  74      16.791  -1.004  45.585  1.00 19.12           O  
ATOM    550  N   TRP A  75      17.936  -2.456  50.785  1.00 16.81           N  
ATOM    551  CA  TRP A  75      18.189  -2.021  52.149  1.00 16.64           C  
ATOM    552  C   TRP A  75      18.945  -0.704  51.980  1.00 18.42           C  
ATOM    553  O   TRP A  75      18.580   0.320  52.553  1.00 22.20           O  
ATOM    554  CB  TRP A  75      19.047  -3.036  52.887  1.00 13.90           C  
ATOM    555  CG  TRP A  75      19.513  -2.541  54.214  1.00 15.02           C  
ATOM    556  CD1 TRP A  75      18.752  -1.975  55.198  1.00 14.73           C  
ATOM    557  CD2 TRP A  75      20.847  -2.596  54.719  1.00 14.36           C  
ATOM    558  NE1 TRP A  75      19.536  -1.677  56.289  1.00 16.55           N  
ATOM    559  CE2 TRP A  75      20.827  -2.051  56.022  1.00 14.59           C  
ATOM    560  CE3 TRP A  75      22.062  -3.060  54.199  1.00 14.76           C  
ATOM    561  CZ2 TRP A  75      21.973  -1.953  56.812  1.00 14.07           C  
ATOM    562  CZ3 TRP A  75      23.204  -2.961  54.986  1.00 13.73           C  
ATOM    563  CH2 TRP A  75      23.149  -2.412  56.279  1.00 11.50           C  
ATOM    564  N   ARG A  76      19.998  -0.750  51.171  1.00 20.14           N  
ATOM    565  CA  ARG A  76      20.811   0.417  50.853  1.00 24.06           C  
ATOM    566  C   ARG A  76      20.914   0.404  49.334  1.00 24.26           C  
ATOM    567  O   ARG A  76      21.387  -0.569  48.748  1.00 23.53           O  
ATOM    568  CB  ARG A  76      22.206   0.284  51.466  1.00 25.90           C  
ATOM    569  CG  ARG A  76      22.187  -0.012  52.948  1.00 29.65           C  
ATOM    570  CD  ARG A  76      22.398   1.242  53.752  1.00 31.42           C  
ATOM    571  NE  ARG A  76      23.732   1.792  53.527  1.00 29.68           N  
ATOM    572  CZ  ARG A  76      24.127   2.972  53.984  1.00 26.73           C  
ATOM    573  NH1 ARG A  76      23.284   3.713  54.687  1.00 26.28           N  
ATOM    574  NH2 ARG A  76      25.353   3.409  53.741  1.00 24.01           N  
ATOM    575  N   ALA A  77      20.462   1.480  48.704  1.00 26.82           N  
ATOM    576  CA  ALA A  77      20.466   1.589  47.248  1.00 28.68           C  
ATOM    577  C   ALA A  77      21.863   1.695  46.637  1.00 28.28           C  
ATOM    578  O   ALA A  77      22.244   2.745  46.117  1.00 27.79           O  
ATOM    579  CB  ALA A  77      19.611   2.788  46.820  1.00 30.64           C  
ATOM    580  N   PHE A  78      22.608   0.595  46.696  1.00 27.64           N  
ATOM    581  CA  PHE A  78      23.954   0.537  46.147  1.00 27.42           C  
ATOM    582  C   PHE A  78      24.278  -0.871  45.645  1.00 26.73           C  
ATOM    583  O   PHE A  78      24.000  -1.865  46.319  1.00 24.06           O  
ATOM    584  CB  PHE A  78      24.980   0.967  47.200  1.00 29.37           C  
ATOM    585  CG  PHE A  78      24.745   2.347  47.744  1.00 32.16           C  
ATOM    586  CD1 PHE A  78      24.164   2.529  48.994  1.00 33.63           C  
ATOM    587  CD2 PHE A  78      25.072   3.469  46.987  1.00 34.83           C  
ATOM    588  CE1 PHE A  78      23.906   3.809  49.487  1.00 35.01           C  
ATOM    589  CE2 PHE A  78      24.819   4.755  47.466  1.00 35.23           C  
ATOM    590  CZ  PHE A  78      24.235   4.927  48.720  1.00 36.19           C  
ATOM    591  N   ASP A  79      24.870  -0.936  44.452  1.00 25.27           N  
ATOM    592  CA  ASP A  79      25.245  -2.192  43.800  1.00 23.84           C  
ATOM    593  C   ASP A  79      25.919  -3.206  44.728  1.00 19.74           C  
ATOM    594  O   ASP A  79      25.671  -4.407  44.633  1.00 16.58           O  
ATOM    595  CB  ASP A  79      26.186  -1.909  42.621  1.00 28.77           C  
ATOM    596  CG  ASP A  79      25.563  -0.999  41.562  1.00 31.63           C  
ATOM    597  OD1 ASP A  79      26.304  -0.585  40.642  1.00 34.89           O  
ATOM    598  OD2 ASP A  79      24.354  -0.702  41.636  1.00 31.59           O  
ATOM    599  N   GLY A  80      26.786  -2.722  45.611  1.00 17.58           N  
ATOM    600  CA  GLY A  80      27.474  -3.618  46.526  1.00 15.63           C  
ATOM    601  C   GLY A  80      26.572  -4.299  47.546  1.00 14.43           C  
ATOM    602  O   GLY A  80      27.005  -5.237  48.222  1.00 13.32           O  
ATOM    603  N   TYR A  81      25.328  -3.840  47.672  1.00 13.05           N  
ATOM    604  CA  TYR A  81      24.394  -4.439  48.631  1.00 14.07           C  
ATOM    605  C   TYR A  81      23.394  -5.333  47.926  1.00 13.76           C  
ATOM    606  O   TYR A  81      22.353  -5.672  48.494  1.00 14.19           O  
ATOM    607  CB  TYR A  81      23.594  -3.380  49.383  1.00 13.34           C  
ATOM    608  CG  TYR A  81      24.389  -2.433  50.235  1.00 17.80           C  
ATOM    609  CD1 TYR A  81      24.999  -1.312  49.677  1.00 17.33           C  
ATOM    610  CD2 TYR A  81      24.481  -2.618  51.611  1.00 19.53           C  
ATOM    611  CE1 TYR A  81      25.673  -0.393  50.467  1.00 17.80           C  
ATOM    612  CE2 TYR A  81      25.153  -1.706  52.414  1.00 20.47           C  
ATOM    613  CZ  TYR A  81      25.745  -0.593  51.835  1.00 21.31           C  
ATOM    614  OH  TYR A  81      26.402   0.320  52.628  1.00 21.82           O  
ATOM    615  N   ARG A  82      23.703  -5.712  46.695  1.00 14.38           N  
ATOM    616  CA  ARG A  82      22.800  -6.540  45.905  1.00 16.33           C  
ATOM    617  C   ARG A  82      22.325  -7.839  46.548  1.00 14.69           C  
ATOM    618  O   ARG A  82      21.270  -8.348  46.185  1.00 16.27           O  
ATOM    619  CB  ARG A  82      23.418  -6.835  44.528  1.00 20.43           C  
ATOM    620  CG  ARG A  82      24.789  -7.502  44.538  1.00 25.68           C  
ATOM    621  CD  ARG A  82      25.176  -7.984  43.130  1.00 27.83           C  
ATOM    622  NE  ARG A  82      26.602  -8.262  43.009  1.00 32.10           N  
ATOM    623  CZ  ARG A  82      27.547  -7.329  43.066  1.00 33.46           C  
ATOM    624  NH1 ARG A  82      27.214  -6.058  43.237  1.00 34.28           N  
ATOM    625  NH2 ARG A  82      28.828  -7.662  42.956  1.00 35.60           N  
ATOM    626  N   HIS A  83      23.078  -8.372  47.507  1.00 14.36           N  
ATOM    627  CA  HIS A  83      22.677  -9.620  48.164  1.00 11.95           C  
ATOM    628  C   HIS A  83      22.044  -9.374  49.534  1.00 10.90           C  
ATOM    629  O   HIS A  83      21.799 -10.308  50.301  1.00  9.59           O  
ATOM    630  CB  HIS A  83      23.888 -10.550  48.303  1.00 10.94           C  
ATOM    631  CG  HIS A  83      24.611 -10.779  47.014  1.00 13.51           C  
ATOM    632  ND1 HIS A  83      24.025 -11.412  45.940  1.00 14.16           N  
ATOM    633  CD2 HIS A  83      25.842 -10.393  46.598  1.00 13.22           C  
ATOM    634  CE1 HIS A  83      24.862 -11.403  44.917  1.00 14.23           C  
ATOM    635  NE2 HIS A  83      25.972 -10.791  45.290  1.00 13.70           N  
ATOM    636  N   THR A  84      21.782  -8.111  49.839  1.00 11.52           N  
ATOM    637  CA  THR A  84      21.154  -7.749  51.104  1.00 10.38           C  
ATOM    638  C   THR A  84      19.803  -7.076  50.808  1.00 10.75           C  
ATOM    639  O   THR A  84      19.720  -6.163  49.983  1.00 11.50           O  
ATOM    640  CB  THR A  84      22.065  -6.793  51.914  1.00  9.77           C  
ATOM    641  OG1 THR A  84      23.313  -7.449  52.200  1.00  8.13           O  
ATOM    642  CG2 THR A  84      21.400  -6.394  53.223  1.00  8.74           C  
ATOM    643  N   ARG A  85      18.744  -7.553  51.457  1.00 11.12           N  
ATOM    644  CA  ARG A  85      17.401  -6.997  51.263  1.00 11.98           C  
ATOM    645  C   ARG A  85      16.746  -6.691  52.612  1.00 12.72           C  
ATOM    646  O   ARG A  85      17.008  -7.378  53.600  1.00 12.92           O  
ATOM    647  CB  ARG A  85      16.509  -7.994  50.497  1.00 11.37           C  
ATOM    648  CG  ARG A  85      16.997  -8.356  49.084  1.00 13.15           C  
ATOM    649  CD  ARG A  85      17.081  -7.121  48.220  1.00 12.24           C  
ATOM    650  NE  ARG A  85      17.594  -7.368  46.871  1.00 13.83           N  
ATOM    651  CZ  ARG A  85      18.510  -6.602  46.287  1.00 13.55           C  
ATOM    652  NH1 ARG A  85      19.008  -5.557  46.941  1.00 12.56           N  
ATOM    653  NH2 ARG A  85      18.910  -6.858  45.050  1.00 10.33           N  
ATOM    654  N   GLU A  86      15.915  -5.649  52.655  1.00 11.08           N  
ATOM    655  CA  GLU A  86      15.203  -5.299  53.881  1.00 11.41           C  
ATOM    656  C   GLU A  86      13.777  -5.756  53.656  1.00 10.60           C  
ATOM    657  O   GLU A  86      13.185  -5.465  52.616  1.00 10.90           O  
ATOM    658  CB  GLU A  86      15.213  -3.790  54.141  1.00 12.44           C  
ATOM    659  CG  GLU A  86      14.580  -3.402  55.486  1.00 12.71           C  
ATOM    660  CD  GLU A  86      14.585  -1.901  55.731  1.00 14.57           C  
ATOM    661  OE1 GLU A  86      15.495  -1.223  55.212  1.00 14.96           O  
ATOM    662  OE2 GLU A  86      13.688  -1.400  56.450  1.00 14.96           O  
ATOM    663  N   HIS A  87      13.232  -6.481  54.621  1.00 10.47           N  
ATOM    664  CA  HIS A  87      11.879  -6.987  54.488  1.00 11.61           C  
ATOM    665  C   HIS A  87      10.913  -6.318  55.445  1.00 12.11           C  
ATOM    666  O   HIS A  87      11.308  -5.697  56.429  1.00 12.48           O  
ATOM    667  CB  HIS A  87      11.853  -8.493  54.735  1.00 12.12           C  
ATOM    668  CG  HIS A  87      12.071  -8.867  56.165  1.00 13.16           C  
ATOM    669  ND1 HIS A  87      13.290  -8.726  56.794  1.00 11.54           N  
ATOM    670  CD2 HIS A  87      11.215  -9.339  57.102  1.00 11.97           C  
ATOM    671  CE1 HIS A  87      13.174  -9.094  58.058  1.00 13.78           C  
ATOM    672  NE2 HIS A  87      11.926  -9.472  58.270  1.00 14.83           N  
ATOM    673  N   SER A  88       9.632  -6.454  55.140  1.00 12.80           N  
ATOM    674  CA  SER A  88       8.600  -5.890  55.976  1.00 14.43           C  
ATOM    675  C   SER A  88       7.435  -6.852  55.913  1.00 11.98           C  
ATOM    676  O   SER A  88       7.174  -7.460  54.875  1.00 11.52           O  
ATOM    677  CB  SER A  88       8.202  -4.496  55.477  1.00 15.26           C  
ATOM    678  OG  SER A  88       7.708  -4.550  54.149  1.00 23.98           O  
ATOM    679  N   VAL A  89       6.765  -7.024  57.041  1.00 12.90           N  
ATOM    680  CA  VAL A  89       5.623  -7.922  57.126  1.00 11.74           C  
ATOM    681  C   VAL A  89       4.505  -7.161  57.804  1.00 12.18           C  
ATOM    682  O   VAL A  89       4.736  -6.474  58.796  1.00 11.60           O  
ATOM    683  CB  VAL A  89       5.951  -9.168  57.972  1.00 12.50           C  
ATOM    684  CG1 VAL A  89       4.686  -9.985  58.205  1.00 12.96           C  
ATOM    685  CG2 VAL A  89       7.009 -10.018  57.270  1.00 11.72           C  
ATOM    686  N   TYR A  90       3.294  -7.276  57.272  1.00 12.58           N  
ATOM    687  CA  TYR A  90       2.162  -6.586  57.871  1.00 11.56           C  
ATOM    688  C   TYR A  90       0.978  -7.520  58.045  1.00 11.48           C  
ATOM    689  O   TYR A  90       0.553  -8.171  57.103  1.00 10.94           O  
ATOM    690  CB  TYR A  90       1.702  -5.404  57.015  1.00 12.87           C  
ATOM    691  CG  TYR A  90       2.766  -4.399  56.669  1.00 14.77           C  
ATOM    692  CD1 TYR A  90       3.582  -4.583  55.552  1.00 14.58           C  
ATOM    693  CD2 TYR A  90       2.922  -3.234  57.419  1.00 13.28           C  
ATOM    694  CE1 TYR A  90       4.521  -3.629  55.184  1.00 16.83           C  
ATOM    695  CE2 TYR A  90       3.859  -2.273  57.061  1.00 17.09           C  
ATOM    696  CZ  TYR A  90       4.653  -2.474  55.938  1.00 18.28           C  
ATOM    697  OH  TYR A  90       5.561  -1.509  55.553  1.00 19.19           O  
ATOM    698  N   VAL A  91       0.454  -7.583  59.259  1.00 11.99           N  
ATOM    699  CA  VAL A  91      -0.702  -8.413  59.520  1.00 13.65           C  
ATOM    700  C   VAL A  91      -1.891  -7.480  59.742  1.00 13.97           C  
ATOM    701  O   VAL A  91      -1.792  -6.489  60.475  1.00 13.36           O  
ATOM    702  CB  VAL A  91      -0.481  -9.299  60.756  1.00 15.91           C  
ATOM    703  CG1 VAL A  91      -1.700 -10.189  60.983  1.00 13.88           C  
ATOM    704  CG2 VAL A  91       0.774 -10.169  60.553  1.00 14.91           C  
ATOM    705  N   HIS A  92      -3.006  -7.783  59.087  1.00 13.30           N  
ATOM    706  CA  HIS A  92      -4.214  -6.972  59.214  1.00 13.73           C  
ATOM    707  C   HIS A  92      -4.592  -6.895  60.693  1.00 14.53           C  
ATOM    708  O   HIS A  92      -4.544  -7.897  61.401  1.00 13.82           O  
ATOM    709  CB  HIS A  92      -5.354  -7.604  58.405  1.00 13.70           C  
ATOM    710  CG  HIS A  92      -6.571  -6.738  58.294  1.00 15.50           C  
ATOM    711  ND1 HIS A  92      -7.340  -6.393  59.384  1.00 13.21           N  
ATOM    712  CD2 HIS A  92      -7.167  -6.168  57.219  1.00 15.39           C  
ATOM    713  CE1 HIS A  92      -8.360  -5.652  58.985  1.00 16.11           C  
ATOM    714  NE2 HIS A  92      -8.278  -5.501  57.676  1.00 15.97           N  
ATOM    715  N   LYS A  93      -4.969  -5.705  61.149  1.00 14.91           N  
ATOM    716  CA  LYS A  93      -5.331  -5.483  62.545  1.00 17.04           C  
ATOM    717  C   LYS A  93      -6.406  -6.413  63.098  1.00 18.12           C  
ATOM    718  O   LYS A  93      -6.430  -6.692  64.297  1.00 16.02           O  
ATOM    719  CB  LYS A  93      -5.773  -4.033  62.745  1.00 19.35           C  
ATOM    720  CG  LYS A  93      -6.997  -3.638  61.943  1.00 18.86           C  
ATOM    721  CD  LYS A  93      -7.330  -2.155  62.157  1.00 20.44           C  
ATOM    722  CE  LYS A  93      -8.507  -1.717  61.303  1.00 19.73           C  
ATOM    723  NZ  LYS A  93      -8.798  -0.283  61.477  1.00 21.20           N  
ATOM    724  N   ASP A  94      -7.292  -6.896  62.232  1.00 17.98           N  
ATOM    725  CA  ASP A  94      -8.363  -7.786  62.672  1.00 18.73           C  
ATOM    726  C   ASP A  94      -8.039  -9.261  62.460  1.00 17.92           C  
ATOM    727  O   ASP A  94      -8.914 -10.112  62.618  1.00 20.59           O  
ATOM    728  CB  ASP A  94      -9.675  -7.458  61.943  1.00 19.23           C  
ATOM    729  CG  ASP A  94     -10.200  -6.061  62.263  1.00 22.03           C  
ATOM    730  OD1 ASP A  94     -10.048  -5.603  63.417  1.00 24.15           O  
ATOM    731  OD2 ASP A  94     -10.784  -5.432  61.359  1.00 21.51           O  
ATOM    732  N   ALA A  95      -6.793  -9.566  62.107  1.00 16.98           N  
ATOM    733  CA  ALA A  95      -6.390 -10.951  61.872  1.00 17.07           C  
ATOM    734  C   ALA A  95      -5.147 -11.329  62.669  1.00 16.93           C  
ATOM    735  O   ALA A  95      -4.369 -12.188  62.254  1.00 17.17           O  
ATOM    736  CB  ALA A  95      -6.137 -11.180  60.385  1.00 14.90           C  
ATOM    737  N   ARG A  96      -4.976 -10.688  63.817  1.00 17.63           N  
ATOM    738  CA  ARG A  96      -3.840 -10.945  64.683  1.00 19.53           C  
ATOM    739  C   ARG A  96      -4.058 -12.217  65.492  1.00 20.84           C  
ATOM    740  O   ARG A  96      -5.192 -12.667  65.657  1.00 17.57           O  
ATOM    741  CB  ARG A  96      -3.639  -9.766  65.630  1.00 21.56           C  
ATOM    742  CG  ARG A  96      -3.491  -8.438  64.924  1.00 24.51           C  
ATOM    743  CD  ARG A  96      -2.178  -8.372  64.171  1.00 27.54           C  
ATOM    744  NE  ARG A  96      -1.048  -8.500  65.087  1.00 32.57           N  
ATOM    745  CZ  ARG A  96       0.214  -8.246  64.764  1.00 31.20           C  
ATOM    746  NH1 ARG A  96       0.521  -7.849  63.537  1.00 36.21           N  
ATOM    747  NH2 ARG A  96       1.171  -8.388  65.666  1.00 32.08           N  
ATOM    748  N   GLY A  97      -2.967 -12.800  65.988  1.00 21.16           N  
ATOM    749  CA  GLY A  97      -3.064 -14.006  66.798  1.00 22.29           C  
ATOM    750  C   GLY A  97      -3.329 -15.299  66.047  1.00 24.30           C  
ATOM    751  O   GLY A  97      -3.707 -16.299  66.659  1.00 23.51           O  
ATOM    752  N   HIS A  98      -3.132 -15.283  64.730  1.00 23.88           N  
ATOM    753  CA  HIS A  98      -3.349 -16.463  63.892  1.00 23.46           C  
ATOM    754  C   HIS A  98      -2.045 -16.986  63.299  1.00 22.32           C  
ATOM    755  O   HIS A  98      -2.062 -17.815  62.394  1.00 21.74           O  
ATOM    756  CB  HIS A  98      -4.320 -16.142  62.752  1.00 23.85           C  
ATOM    757  CG  HIS A  98      -5.719 -15.870  63.209  1.00 27.09           C  
ATOM    758  ND1 HIS A  98      -6.473 -14.824  62.720  1.00 26.27           N  
ATOM    759  CD2 HIS A  98      -6.496 -16.500  64.122  1.00 26.28           C  
ATOM    760  CE1 HIS A  98      -7.652 -14.819  63.315  1.00 25.55           C  
ATOM    761  NE2 HIS A  98      -7.692 -15.824  64.170  1.00 25.74           N  
ATOM    762  N   GLY A  99      -0.920 -16.495  63.808  1.00 21.65           N  
ATOM    763  CA  GLY A  99       0.369 -16.939  63.302  1.00 21.33           C  
ATOM    764  C   GLY A  99       0.677 -16.481  61.884  1.00 20.17           C  
ATOM    765  O   GLY A  99       1.621 -16.967  61.256  1.00 18.18           O  
ATOM    766  N   ILE A 100      -0.113 -15.538  61.380  1.00 18.22           N  
ATOM    767  CA  ILE A 100       0.082 -15.021  60.035  1.00 16.16           C  
ATOM    768  C   ILE A 100       1.452 -14.360  59.880  1.00 15.71           C  
ATOM    769  O   ILE A 100       2.150 -14.589  58.891  1.00 14.93           O  
ATOM    770  CB  ILE A 100      -1.032 -13.995  59.662  1.00 16.88           C  
ATOM    771  CG1 ILE A 100      -2.395 -14.699  59.633  1.00 15.02           C  
ATOM    772  CG2 ILE A 100      -0.730 -13.359  58.306  1.00 14.63           C  
ATOM    773  CD1 ILE A 100      -3.565 -13.806  59.244  1.00 13.10           C  
ATOM    774  N   GLY A 101       1.841 -13.552  60.864  1.00 15.49           N  
ATOM    775  CA  GLY A 101       3.126 -12.878  60.796  1.00 14.17           C  
ATOM    776  C   GLY A 101       4.298 -13.820  60.556  1.00 14.03           C  
ATOM    777  O   GLY A 101       5.090 -13.627  59.631  1.00 13.14           O  
ATOM    778  N   LYS A 102       4.406 -14.850  61.385  1.00 13.49           N  
ATOM    779  CA  LYS A 102       5.496 -15.811  61.265  1.00 13.40           C  
ATOM    780  C   LYS A 102       5.476 -16.520  59.919  1.00 12.70           C  
ATOM    781  O   LYS A 102       6.514 -16.688  59.287  1.00 14.33           O  
ATOM    782  CB  LYS A 102       5.422 -16.851  62.390  1.00 12.53           C  
ATOM    783  CG  LYS A 102       6.704 -17.655  62.559  1.00 14.70           C  
ATOM    784  CD  LYS A 102       6.629 -18.619  63.729  1.00 15.81           C  
ATOM    785  CE  LYS A 102       7.918 -19.424  63.850  1.00 18.67           C  
ATOM    786  NZ  LYS A 102       7.832 -20.531  64.856  1.00 18.44           N  
ATOM    787  N   ARG A 103       4.296 -16.929  59.475  1.00 12.65           N  
ATOM    788  CA  ARG A 103       4.189 -17.627  58.205  1.00 11.10           C  
ATOM    789  C   ARG A 103       4.598 -16.729  57.049  1.00 10.04           C  
ATOM    790  O   ARG A 103       5.239 -17.188  56.111  1.00 10.06           O  
ATOM    791  CB  ARG A 103       2.769 -18.139  58.001  1.00 15.76           C  
ATOM    792  CG  ARG A 103       2.364 -19.197  59.015  1.00 20.65           C  
ATOM    793  CD  ARG A 103       0.913 -19.610  58.833  1.00 23.13           C  
ATOM    794  NE  ARG A 103       0.657 -20.150  57.502  1.00 25.89           N  
ATOM    795  CZ  ARG A 103      -0.546 -20.506  57.063  1.00 26.52           C  
ATOM    796  NH1 ARG A 103      -1.601 -20.379  57.854  1.00 26.93           N  
ATOM    797  NH2 ARG A 103      -0.692 -20.990  55.834  1.00 26.05           N  
ATOM    798  N   LEU A 104       4.232 -15.454  57.113  1.00  9.94           N  
ATOM    799  CA  LEU A 104       4.599 -14.525  56.053  1.00  9.74           C  
ATOM    800  C   LEU A 104       6.105 -14.323  56.023  1.00  9.61           C  
ATOM    801  O   LEU A 104       6.714 -14.305  54.953  1.00  8.26           O  
ATOM    802  CB  LEU A 104       3.917 -13.169  56.251  1.00  7.54           C  
ATOM    803  CG  LEU A 104       2.455 -13.087  55.814  1.00  8.48           C  
ATOM    804  CD1 LEU A 104       1.870 -11.747  56.251  1.00  9.01           C  
ATOM    805  CD2 LEU A 104       2.355 -13.256  54.302  1.00  9.10           C  
HETATM  806  N   MSE A 105       6.714 -14.177  57.195  1.00 10.70           N  
HETATM  807  CA  MSE A 105       8.159 -13.957  57.242  1.00 12.63           C  
HETATM  808  C   MSE A 105       8.915 -15.194  56.798  1.00 12.75           C  
HETATM  809  O   MSE A 105       9.970 -15.094  56.175  1.00 13.72           O  
HETATM  810  CB  MSE A 105       8.602 -13.559  58.649  1.00 13.57           C  
HETATM  811  CG  MSE A 105       9.978 -12.903  58.675  1.00 18.07           C  
HETATM  812 SE   MSE A 105      10.316 -12.061  60.392  1.00 27.33          SE  
HETATM  813  CE  MSE A 105       9.010 -10.635  60.268  1.00 24.72           C  
ATOM    814  N   GLN A 106       8.382 -16.365  57.127  1.00 13.69           N  
ATOM    815  CA  GLN A 106       9.035 -17.602  56.728  1.00 14.88           C  
ATOM    816  C   GLN A 106       9.001 -17.692  55.202  1.00 13.85           C  
ATOM    817  O   GLN A 106       9.972 -18.100  54.573  1.00 13.63           O  
ATOM    818  CB  GLN A 106       8.322 -18.800  57.355  1.00 17.54           C  
ATOM    819  CG  GLN A 106       8.976 -20.133  57.043  1.00 17.72           C  
ATOM    820  CD  GLN A 106      10.427 -20.179  57.479  1.00 21.26           C  
ATOM    821  OE1 GLN A 106      10.740 -20.060  58.667  1.00 21.78           O  
ATOM    822  NE2 GLN A 106      11.327 -20.351  56.513  1.00 19.27           N  
ATOM    823  N   ALA A 107       7.881 -17.291  54.612  1.00 14.14           N  
ATOM    824  CA  ALA A 107       7.734 -17.321  53.163  1.00 12.98           C  
ATOM    825  C   ALA A 107       8.768 -16.398  52.505  1.00 13.93           C  
ATOM    826  O   ALA A 107       9.330 -16.732  51.455  1.00 14.70           O  
ATOM    827  CB  ALA A 107       6.311 -16.910  52.767  1.00 12.87           C  
ATOM    828  N   LEU A 108       9.003 -15.239  53.120  1.00 11.81           N  
ATOM    829  CA  LEU A 108       9.981 -14.275  52.625  1.00 14.39           C  
ATOM    830  C   LEU A 108      11.384 -14.877  52.733  1.00 13.57           C  
ATOM    831  O   LEU A 108      12.222 -14.707  51.841  1.00 14.91           O  
ATOM    832  CB  LEU A 108       9.935 -12.977  53.438  1.00 13.48           C  
ATOM    833  CG  LEU A 108       8.709 -12.079  53.319  1.00 15.01           C  
ATOM    834  CD1 LEU A 108       8.935 -10.823  54.155  1.00 14.54           C  
ATOM    835  CD2 LEU A 108       8.473 -11.697  51.850  1.00 15.42           C  
ATOM    836  N   ILE A 109      11.634 -15.573  53.837  1.00 12.14           N  
ATOM    837  CA  ILE A 109      12.920 -16.216  54.049  1.00 12.36           C  
ATOM    838  C   ILE A 109      13.114 -17.300  52.985  1.00 10.53           C  
ATOM    839  O   ILE A 109      14.198 -17.425  52.414  1.00 13.14           O  
ATOM    840  CB  ILE A 109      13.012 -16.836  55.467  1.00 10.74           C  
ATOM    841  CG1 ILE A 109      13.110 -15.724  56.512  1.00  8.06           C  
ATOM    842  CG2 ILE A 109      14.228 -17.769  55.555  1.00 11.04           C  
ATOM    843  CD1 ILE A 109      12.854 -16.183  57.947  1.00  6.11           C  
ATOM    844  N   ASP A 110      12.065 -18.063  52.696  1.00 12.95           N  
ATOM    845  CA  ASP A 110      12.169 -19.109  51.680  1.00 13.52           C  
ATOM    846  C   ASP A 110      12.444 -18.512  50.316  1.00 11.92           C  
ATOM    847  O   ASP A 110      13.328 -18.966  49.594  1.00 12.95           O  
ATOM    848  CB  ASP A 110      10.892 -19.946  51.603  1.00 17.10           C  
ATOM    849  CG  ASP A 110      10.642 -20.743  52.866  1.00 20.44           C  
ATOM    850  OD1 ASP A 110      11.592 -20.908  53.655  1.00 23.39           O  
ATOM    851  OD2 ASP A 110       9.503 -21.211  53.061  1.00 22.74           O  
ATOM    852  N   HIS A 111      11.694 -17.486  49.956  1.00 13.13           N  
ATOM    853  CA  HIS A 111      11.894 -16.870  48.657  1.00 10.41           C  
ATOM    854  C   HIS A 111      13.314 -16.321  48.548  1.00 10.16           C  
ATOM    855  O   HIS A 111      14.002 -16.551  47.558  1.00  9.48           O  
ATOM    856  CB  HIS A 111      10.873 -15.751  48.448  1.00 13.37           C  
ATOM    857  CG  HIS A 111      10.943 -15.118  47.095  1.00 13.94           C  
ATOM    858  ND1 HIS A 111      11.899 -14.183  46.759  1.00 12.75           N  
ATOM    859  CD2 HIS A 111      10.206 -15.322  45.977  1.00 11.68           C  
ATOM    860  CE1 HIS A 111      11.749 -13.841  45.492  1.00 10.62           C  
ATOM    861  NE2 HIS A 111      10.729 -14.518  44.994  1.00 11.72           N  
ATOM    862  N   ALA A 112      13.750 -15.598  49.577  1.00 10.82           N  
ATOM    863  CA  ALA A 112      15.085 -15.013  49.597  1.00 10.71           C  
ATOM    864  C   ALA A 112      16.169 -16.081  49.414  1.00 11.26           C  
ATOM    865  O   ALA A 112      17.164 -15.862  48.722  1.00 11.37           O  
ATOM    866  CB  ALA A 112      15.301 -14.270  50.911  1.00 10.18           C  
ATOM    867  N   GLY A 113      15.966 -17.238  50.033  1.00 10.98           N  
ATOM    868  CA  GLY A 113      16.938 -18.311  49.927  1.00 11.92           C  
ATOM    869  C   GLY A 113      17.113 -18.816  48.506  1.00 13.07           C  
ATOM    870  O   GLY A 113      18.138 -19.404  48.168  1.00 11.96           O  
ATOM    871  N   GLY A 114      16.107 -18.593  47.671  1.00 11.86           N  
ATOM    872  CA  GLY A 114      16.200 -19.039  46.294  1.00 11.74           C  
ATOM    873  C   GLY A 114      16.372 -17.875  45.348  1.00 12.65           C  
ATOM    874  O   GLY A 114      16.326 -18.037  44.124  1.00 14.11           O  
ATOM    875  N   ASN A 115      16.579 -16.689  45.907  1.00 11.72           N  
ATOM    876  CA  ASN A 115      16.736 -15.507  45.084  1.00 10.79           C  
ATOM    877  C   ASN A 115      18.098 -14.841  45.237  1.00 13.07           C  
ATOM    878  O   ASN A 115      18.237 -13.629  45.046  1.00 12.55           O  
ATOM    879  CB  ASN A 115      15.620 -14.522  45.407  1.00  9.01           C  
ATOM    880  CG  ASN A 115      15.398 -13.521  44.298  1.00 10.12           C  
ATOM    881  OD1 ASN A 115      15.563 -13.842  43.117  1.00 10.74           O  
ATOM    882  ND2 ASN A 115      14.996 -12.311  44.666  1.00  7.02           N  
ATOM    883  N   ASP A 116      19.099 -15.649  45.576  1.00 12.87           N  
ATOM    884  CA  ASP A 116      20.466 -15.167  45.730  1.00 15.55           C  
ATOM    885  C   ASP A 116      20.539 -13.986  46.695  1.00 15.92           C  
ATOM    886  O   ASP A 116      21.162 -12.954  46.420  1.00 14.75           O  
ATOM    887  CB  ASP A 116      21.023 -14.775  44.360  1.00 17.06           C  
ATOM    888  CG  ASP A 116      22.544 -14.715  44.332  1.00 19.95           C  
ATOM    889  OD1 ASP A 116      23.197 -15.175  45.291  1.00 18.52           O  
ATOM    890  OD2 ASP A 116      23.084 -14.210  43.324  1.00 21.72           O  
ATOM    891  N   VAL A 117      19.863 -14.142  47.823  1.00 14.14           N  
ATOM    892  CA  VAL A 117      19.857 -13.130  48.862  1.00 13.70           C  
ATOM    893  C   VAL A 117      20.698 -13.741  49.968  1.00 13.14           C  
ATOM    894  O   VAL A 117      20.457 -14.872  50.385  1.00 12.68           O  
ATOM    895  CB  VAL A 117      18.430 -12.860  49.350  1.00 12.76           C  
ATOM    896  CG1 VAL A 117      18.460 -11.939  50.559  1.00 17.42           C  
ATOM    897  CG2 VAL A 117      17.619 -12.224  48.224  1.00 12.79           C  
ATOM    898  N   HIS A 118      21.703 -13.005  50.425  1.00 12.10           N  
ATOM    899  CA  HIS A 118      22.590 -13.519  51.458  1.00 11.78           C  
ATOM    900  C   HIS A 118      22.182 -13.050  52.843  1.00 11.52           C  
ATOM    901  O   HIS A 118      22.319 -13.780  53.818  1.00 11.62           O  
ATOM    902  CB  HIS A 118      24.028 -13.081  51.163  1.00 11.30           C  
ATOM    903  CG  HIS A 118      25.045 -13.669  52.090  1.00 11.34           C  
ATOM    904  ND1 HIS A 118      25.887 -12.893  52.859  1.00 13.12           N  
ATOM    905  CD2 HIS A 118      25.394 -14.954  52.333  1.00 12.98           C  
ATOM    906  CE1 HIS A 118      26.714 -13.676  53.530  1.00  9.30           C  
ATOM    907  NE2 HIS A 118      26.436 -14.930  53.228  1.00 13.64           N  
ATOM    908  N   VAL A 119      21.685 -11.823  52.932  1.00 12.19           N  
ATOM    909  CA  VAL A 119      21.274 -11.291  54.220  1.00 12.12           C  
ATOM    910  C   VAL A 119      19.927 -10.562  54.156  1.00 11.59           C  
ATOM    911  O   VAL A 119      19.640  -9.845  53.196  1.00 11.54           O  
ATOM    912  CB  VAL A 119      22.343 -10.302  54.779  1.00 12.21           C  
ATOM    913  CG1 VAL A 119      21.867  -9.707  56.094  1.00 11.42           C  
ATOM    914  CG2 VAL A 119      23.683 -11.020  54.984  1.00  7.44           C  
ATOM    915  N   LEU A 120      19.101 -10.777  55.172  1.00 10.60           N  
ATOM    916  CA  LEU A 120      17.822 -10.099  55.293  1.00 12.32           C  
ATOM    917  C   LEU A 120      18.005  -9.176  56.484  1.00 12.25           C  
ATOM    918  O   LEU A 120      18.547  -9.588  57.517  1.00 11.91           O  
ATOM    919  CB  LEU A 120      16.684 -11.076  55.592  1.00 12.57           C  
ATOM    920  CG  LEU A 120      16.134 -11.824  54.380  1.00 13.13           C  
ATOM    921  CD1 LEU A 120      15.054 -12.803  54.842  1.00 12.56           C  
ATOM    922  CD2 LEU A 120      15.553 -10.822  53.375  1.00 13.28           C  
ATOM    923  N   ILE A 121      17.557  -7.935  56.331  1.00 12.13           N  
ATOM    924  CA  ILE A 121      17.671  -6.915  57.367  1.00 12.63           C  
ATOM    925  C   ILE A 121      16.298  -6.478  57.866  1.00 12.46           C  
ATOM    926  O   ILE A 121      15.398  -6.213  57.069  1.00 12.86           O  
ATOM    927  CB  ILE A 121      18.392  -5.639  56.829  1.00 12.06           C  
ATOM    928  CG1 ILE A 121      19.826  -5.967  56.411  1.00 11.82           C  
ATOM    929  CG2 ILE A 121      18.419  -4.561  57.911  1.00 13.66           C  
ATOM    930  CD1 ILE A 121      20.672  -6.533  57.537  1.00  7.80           C  
ATOM    931  N   ALA A 122      16.144  -6.398  59.185  1.00 11.81           N  
ATOM    932  CA  ALA A 122      14.893  -5.948  59.779  1.00 13.18           C  
ATOM    933  C   ALA A 122      15.143  -4.599  60.454  1.00 13.95           C  
ATOM    934  O   ALA A 122      16.119  -4.439  61.192  1.00 14.32           O  
ATOM    935  CB  ALA A 122      14.391  -6.966  60.808  1.00 12.61           C  
ATOM    936  N   ALA A 123      14.288  -3.619  60.160  1.00 13.93           N  
ATOM    937  CA  ALA A 123      14.383  -2.289  60.763  1.00 13.18           C  
ATOM    938  C   ALA A 123      13.104  -2.180  61.579  1.00 12.77           C  
ATOM    939  O   ALA A 123      12.038  -1.886  61.048  1.00 13.74           O  
ATOM    940  CB  ALA A 123      14.427  -1.208  59.692  1.00 15.11           C  
ATOM    941  N   ILE A 124      13.221  -2.424  62.877  1.00 12.65           N  
ATOM    942  CA  ILE A 124      12.069  -2.424  63.766  1.00 13.00           C  
ATOM    943  C   ILE A 124      12.043  -1.253  64.746  1.00 12.92           C  
ATOM    944  O   ILE A 124      13.067  -0.921  65.342  1.00 11.06           O  
ATOM    945  CB  ILE A 124      12.051  -3.734  64.572  1.00 12.60           C  
ATOM    946  CG1 ILE A 124      12.102  -4.921  63.602  1.00 10.92           C  
ATOM    947  CG2 ILE A 124      10.837  -3.770  65.488  1.00 10.39           C  
ATOM    948  CD1 ILE A 124      12.566  -6.232  64.229  1.00 12.06           C  
ATOM    949  N   GLU A 125      10.879  -0.624  64.904  1.00 11.58           N  
ATOM    950  CA  GLU A 125      10.772   0.478  65.857  1.00 12.35           C  
ATOM    951  C   GLU A 125      11.098  -0.167  67.206  1.00 13.07           C  
ATOM    952  O   GLU A 125      10.473  -1.156  67.601  1.00 14.04           O  
ATOM    953  CB  GLU A 125       9.362   1.083  65.837  1.00 11.44           C  
ATOM    954  CG  GLU A 125       9.206   2.301  66.729  1.00  9.91           C  
ATOM    955  CD  GLU A 125       8.616   1.947  68.073  1.00 13.40           C  
ATOM    956  OE1 GLU A 125       7.457   1.492  68.092  1.00 14.22           O  
ATOM    957  OE2 GLU A 125       9.296   2.119  69.106  1.00 12.62           O  
ATOM    958  N   ALA A 126      12.097   0.391  67.886  1.00 14.55           N  
ATOM    959  CA  ALA A 126      12.615  -0.124  69.157  1.00 16.83           C  
ATOM    960  C   ALA A 126      11.668  -0.728  70.200  1.00 16.71           C  
ATOM    961  O   ALA A 126      11.931  -1.818  70.714  1.00 16.54           O  
ATOM    962  CB  ALA A 126      13.472   0.946  69.813  1.00 18.17           C  
ATOM    963  N   GLU A 127      10.584  -0.031  70.521  1.00 14.45           N  
ATOM    964  CA  GLU A 127       9.648  -0.520  71.536  1.00 15.71           C  
ATOM    965  C   GLU A 127       8.714  -1.624  71.052  1.00 13.47           C  
ATOM    966  O   GLU A 127       7.952  -2.177  71.838  1.00 11.52           O  
ATOM    967  CB  GLU A 127       8.805   0.633  72.084  1.00 18.29           C  
ATOM    968  CG  GLU A 127       9.619   1.759  72.680  1.00 24.63           C  
ATOM    969  CD  GLU A 127      10.605   1.270  73.721  1.00 28.38           C  
ATOM    970  OE1 GLU A 127      10.203   0.488  74.603  1.00 32.61           O  
ATOM    971  OE2 GLU A 127      11.781   1.675  73.669  1.00 32.18           O  
ATOM    972  N   ASN A 128       8.771  -1.947  69.764  1.00 13.49           N  
ATOM    973  CA  ASN A 128       7.906  -2.996  69.238  1.00 13.03           C  
ATOM    974  C   ASN A 128       8.494  -4.360  69.580  1.00 13.05           C  
ATOM    975  O   ASN A 128       9.034  -5.053  68.721  1.00 11.86           O  
ATOM    976  CB  ASN A 128       7.754  -2.881  67.723  1.00 13.35           C  
ATOM    977  CG  ASN A 128       6.581  -3.695  67.203  1.00 14.64           C  
ATOM    978  OD1 ASN A 128       6.250  -4.751  67.753  1.00 11.82           O  
ATOM    979  ND2 ASN A 128       5.952  -3.214  66.140  1.00 13.23           N  
ATOM    980  N   THR A 129       8.369  -4.735  70.847  1.00 13.85           N  
ATOM    981  CA  THR A 129       8.891  -6.000  71.343  1.00 13.69           C  
ATOM    982  C   THR A 129       8.314  -7.217  70.630  1.00 13.05           C  
ATOM    983  O   THR A 129       9.023  -8.191  70.377  1.00 15.24           O  
ATOM    984  CB  THR A 129       8.614  -6.126  72.849  1.00 13.87           C  
ATOM    985  OG1 THR A 129       9.187  -5.006  73.522  1.00 17.88           O  
ATOM    986  CG2 THR A 129       9.207  -7.409  73.407  1.00 16.18           C  
ATOM    987  N   ALA A 130       7.024  -7.158  70.313  1.00 13.86           N  
ATOM    988  CA  ALA A 130       6.355  -8.259  69.626  1.00 13.01           C  
ATOM    989  C   ALA A 130       7.017  -8.542  68.279  1.00 12.39           C  
ATOM    990  O   ALA A 130       7.221  -9.700  67.898  1.00 11.13           O  
ATOM    991  CB  ALA A 130       4.874  -7.935  69.424  1.00 13.25           C  
ATOM    992  N   SER A 131       7.347  -7.487  67.549  1.00 11.65           N  
ATOM    993  CA  SER A 131       8.000  -7.676  66.257  1.00 11.56           C  
ATOM    994  C   SER A 131       9.400  -8.240  66.491  1.00 10.14           C  
ATOM    995  O   SER A 131       9.827  -9.160  65.793  1.00 12.83           O  
ATOM    996  CB  SER A 131       8.080  -6.350  65.489  1.00 10.57           C  
ATOM    997  OG  SER A 131       8.717  -6.517  64.233  1.00 12.89           O  
ATOM    998  N   ILE A 132      10.109  -7.698  67.477  1.00  9.83           N  
ATOM    999  CA  ILE A 132      11.455  -8.175  67.776  1.00 10.65           C  
ATOM   1000  C   ILE A 132      11.438  -9.675  68.077  1.00 10.87           C  
ATOM   1001  O   ILE A 132      12.235 -10.436  67.519  1.00 11.73           O  
ATOM   1002  CB  ILE A 132      12.066  -7.388  68.960  1.00 10.48           C  
ATOM   1003  CG1 ILE A 132      12.243  -5.929  68.531  1.00 12.86           C  
ATOM   1004  CG2 ILE A 132      13.422  -7.977  69.364  1.00  8.04           C  
ATOM   1005  CD1 ILE A 132      12.708  -5.000  69.618  1.00 17.52           C  
ATOM   1006  N   ARG A 133      10.512 -10.099  68.931  1.00 12.41           N  
ATOM   1007  CA  ARG A 133      10.392 -11.511  69.286  1.00 12.07           C  
ATOM   1008  C   ARG A 133      10.062 -12.368  68.065  1.00 13.67           C  
ATOM   1009  O   ARG A 133      10.608 -13.468  67.900  1.00 14.37           O  
ATOM   1010  CB  ARG A 133       9.315 -11.698  70.364  1.00 11.06           C  
ATOM   1011  CG  ARG A 133       9.624 -10.983  71.674  1.00 10.38           C  
ATOM   1012  CD  ARG A 133       8.467 -11.104  72.652  1.00 14.33           C  
ATOM   1013  NE  ARG A 133       8.244 -12.481  73.101  1.00 16.51           N  
ATOM   1014  CZ  ARG A 133       8.718 -12.984  74.237  1.00 16.57           C  
ATOM   1015  NH1 ARG A 133       9.446 -12.230  75.052  1.00 16.37           N  
ATOM   1016  NH2 ARG A 133       8.459 -14.242  74.562  1.00 17.44           N  
ATOM   1017  N   LEU A 134       9.175 -11.873  67.204  1.00 13.87           N  
ATOM   1018  CA  LEU A 134       8.803 -12.620  66.000  1.00 13.79           C  
ATOM   1019  C   LEU A 134      10.037 -12.843  65.123  1.00 13.10           C  
ATOM   1020  O   LEU A 134      10.240 -13.935  64.600  1.00 11.94           O  
ATOM   1021  CB  LEU A 134       7.719 -11.873  65.194  1.00 14.44           C  
ATOM   1022  CG  LEU A 134       7.402 -12.451  63.803  1.00 15.42           C  
ATOM   1023  CD1 LEU A 134       6.872 -13.867  63.949  1.00 16.23           C  
ATOM   1024  CD2 LEU A 134       6.375 -11.580  63.094  1.00 17.89           C  
ATOM   1025  N   HIS A 135      10.861 -11.813  64.963  1.00 13.23           N  
ATOM   1026  CA  HIS A 135      12.064 -11.961  64.146  1.00 12.92           C  
ATOM   1027  C   HIS A 135      13.035 -12.941  64.810  1.00 12.17           C  
ATOM   1028  O   HIS A 135      13.648 -13.761  64.130  1.00 12.08           O  
ATOM   1029  CB  HIS A 135      12.762 -10.610  63.931  1.00 12.59           C  
ATOM   1030  CG  HIS A 135      12.072  -9.721  62.941  1.00 13.07           C  
ATOM   1031  ND1 HIS A 135      10.940  -9.000  63.248  1.00 13.81           N  
ATOM   1032  CD2 HIS A 135      12.351  -9.446  61.644  1.00 14.23           C  
ATOM   1033  CE1 HIS A 135      10.552  -8.314  62.187  1.00 15.44           C  
ATOM   1034  NE2 HIS A 135      11.390  -8.568  61.199  1.00 14.42           N  
ATOM   1035  N   GLU A 136      13.159 -12.861  66.135  1.00 12.94           N  
ATOM   1036  CA  GLU A 136      14.051 -13.752  66.873  1.00 12.92           C  
ATOM   1037  C   GLU A 136      13.619 -15.211  66.718  1.00 14.00           C  
ATOM   1038  O   GLU A 136      14.453 -16.103  66.575  1.00 14.10           O  
ATOM   1039  CB  GLU A 136      14.086 -13.378  68.366  1.00 13.98           C  
ATOM   1040  CG  GLU A 136      14.666 -11.985  68.655  1.00 15.08           C  
ATOM   1041  CD  GLU A 136      14.597 -11.590  70.131  1.00 14.72           C  
ATOM   1042  OE1 GLU A 136      13.535 -11.782  70.761  1.00 13.67           O  
ATOM   1043  OE2 GLU A 136      15.602 -11.069  70.661  1.00 14.58           O  
ATOM   1044  N   SER A 137      12.313 -15.453  66.735  1.00 16.52           N  
ATOM   1045  CA  SER A 137      11.812 -16.814  66.603  1.00 17.35           C  
ATOM   1046  C   SER A 137      12.157 -17.380  65.231  1.00 16.35           C  
ATOM   1047  O   SER A 137      12.087 -18.594  65.020  1.00 16.21           O  
ATOM   1048  CB  SER A 137      10.300 -16.857  66.801  1.00 18.96           C  
ATOM   1049  OG  SER A 137       9.636 -16.332  65.669  1.00 17.83           O  
ATOM   1050  N   LEU A 138      12.527 -16.506  64.301  1.00 14.87           N  
ATOM   1051  CA  LEU A 138      12.886 -16.947  62.962  1.00 14.12           C  
ATOM   1052  C   LEU A 138      14.379 -16.840  62.671  1.00 14.06           C  
ATOM   1053  O   LEU A 138      14.808 -16.912  61.517  1.00 14.23           O  
ATOM   1054  CB  LEU A 138      12.070 -16.184  61.910  1.00 15.73           C  
ATOM   1055  CG  LEU A 138      10.604 -16.642  61.861  1.00 14.91           C  
ATOM   1056  CD1 LEU A 138       9.804 -15.737  60.956  1.00 18.33           C  
ATOM   1057  CD2 LEU A 138      10.538 -18.083  61.365  1.00 15.67           C  
ATOM   1058  N   GLY A 139      15.172 -16.664  63.720  1.00 13.47           N  
ATOM   1059  CA  GLY A 139      16.612 -16.610  63.545  1.00 14.30           C  
ATOM   1060  C   GLY A 139      17.302 -15.269  63.432  1.00 15.18           C  
ATOM   1061  O   GLY A 139      18.531 -15.227  63.364  1.00 15.84           O  
ATOM   1062  N   PHE A 140      16.543 -14.177  63.406  1.00 14.45           N  
ATOM   1063  CA  PHE A 140      17.160 -12.861  63.305  1.00 13.76           C  
ATOM   1064  C   PHE A 140      17.884 -12.525  64.600  1.00 13.35           C  
ATOM   1065  O   PHE A 140      17.459 -12.922  65.689  1.00 11.68           O  
ATOM   1066  CB  PHE A 140      16.108 -11.777  63.018  1.00 13.33           C  
ATOM   1067  CG  PHE A 140      15.622 -11.757  61.592  1.00 12.37           C  
ATOM   1068  CD1 PHE A 140      14.721 -12.712  61.127  1.00 13.90           C  
ATOM   1069  CD2 PHE A 140      16.076 -10.785  60.707  1.00 13.86           C  
ATOM   1070  CE1 PHE A 140      14.280 -12.697  59.796  1.00 13.93           C  
ATOM   1071  CE2 PHE A 140      15.642 -10.764  59.378  1.00 13.55           C  
ATOM   1072  CZ  PHE A 140      14.743 -11.722  58.924  1.00 12.38           C  
ATOM   1073  N   ARG A 141      18.991 -11.808  64.481  1.00 12.96           N  
ATOM   1074  CA  ARG A 141      19.737 -11.409  65.664  1.00 14.57           C  
ATOM   1075  C   ARG A 141      19.937  -9.904  65.629  1.00 12.40           C  
ATOM   1076  O   ARG A 141      20.029  -9.301  64.561  1.00  8.60           O  
ATOM   1077  CB  ARG A 141      21.078 -12.141  65.733  1.00 15.50           C  
ATOM   1078  CG  ARG A 141      20.910 -13.646  65.876  1.00 20.68           C  
ATOM   1079  CD  ARG A 141      22.238 -14.362  65.917  1.00 24.08           C  
ATOM   1080  NE  ARG A 141      22.060 -15.811  65.873  1.00 25.71           N  
ATOM   1081  CZ  ARG A 141      23.051 -16.681  65.706  1.00 28.02           C  
ATOM   1082  NH1 ARG A 141      24.303 -16.251  65.566  1.00 29.15           N  
ATOM   1083  NH2 ARG A 141      22.786 -17.980  65.673  1.00 25.41           N  
ATOM   1084  N   VAL A 142      19.986  -9.315  66.814  1.00 11.10           N  
ATOM   1085  CA  VAL A 142      20.152  -7.887  66.965  1.00 12.30           C  
ATOM   1086  C   VAL A 142      21.517  -7.425  66.492  1.00 13.08           C  
ATOM   1087  O   VAL A 142      22.528  -8.090  66.731  1.00 13.27           O  
ATOM   1088  CB  VAL A 142      19.979  -7.477  68.446  1.00 14.07           C  
ATOM   1089  CG1 VAL A 142      20.262  -5.995  68.624  1.00 13.47           C  
ATOM   1090  CG2 VAL A 142      18.563  -7.809  68.916  1.00 15.42           C  
ATOM   1091  N   VAL A 143      21.534  -6.287  65.807  1.00 12.03           N  
ATOM   1092  CA  VAL A 143      22.779  -5.699  65.331  1.00 12.00           C  
ATOM   1093  C   VAL A 143      23.055  -4.505  66.233  1.00 11.79           C  
ATOM   1094  O   VAL A 143      24.161  -4.336  66.748  1.00 11.49           O  
ATOM   1095  CB  VAL A 143      22.668  -5.231  63.856  1.00 11.43           C  
ATOM   1096  CG1 VAL A 143      23.906  -4.412  63.469  1.00 10.14           C  
ATOM   1097  CG2 VAL A 143      22.551  -6.443  62.936  1.00 10.97           C  
ATOM   1098  N   GLY A 144      22.029  -3.688  66.437  1.00 12.50           N  
ATOM   1099  CA  GLY A 144      22.175  -2.517  67.283  1.00 13.20           C  
ATOM   1100  C   GLY A 144      20.917  -1.676  67.298  1.00 13.65           C  
ATOM   1101  O   GLY A 144      19.948  -1.987  66.607  1.00 12.56           O  
ATOM   1102  N   ARG A 145      20.932  -0.596  68.071  1.00 14.10           N  
ATOM   1103  CA  ARG A 145      19.769   0.271  68.169  1.00 14.70           C  
ATOM   1104  C   ARG A 145      20.142   1.738  67.996  1.00 14.99           C  
ATOM   1105  O   ARG A 145      20.975   2.268  68.731  1.00 15.50           O  
ATOM   1106  CB  ARG A 145      19.078   0.042  69.522  1.00 14.01           C  
ATOM   1107  CG  ARG A 145      17.931   0.978  69.850  1.00 15.06           C  
ATOM   1108  CD  ARG A 145      17.136   0.440  71.039  1.00 16.62           C  
ATOM   1109  NE  ARG A 145      16.263   1.447  71.634  1.00 14.95           N  
ATOM   1110  CZ  ARG A 145      15.338   1.194  72.559  1.00 16.16           C  
ATOM   1111  NH1 ARG A 145      15.148  -0.039  73.005  1.00 14.96           N  
ATOM   1112  NH2 ARG A 145      14.599   2.183  73.042  1.00 15.98           N  
ATOM   1113  N   PHE A 146      19.534   2.376  67.002  1.00 14.03           N  
ATOM   1114  CA  PHE A 146      19.781   3.781  66.729  1.00 14.60           C  
ATOM   1115  C   PHE A 146      18.870   4.625  67.603  1.00 15.14           C  
ATOM   1116  O   PHE A 146      17.661   4.390  67.669  1.00 15.21           O  
ATOM   1117  CB  PHE A 146      19.534   4.083  65.256  1.00 15.04           C  
ATOM   1118  CG  PHE A 146      20.471   3.366  64.328  1.00 16.59           C  
ATOM   1119  CD1 PHE A 146      20.241   2.040  63.966  1.00 18.10           C  
ATOM   1120  CD2 PHE A 146      21.590   4.017  63.817  1.00 19.19           C  
ATOM   1121  CE1 PHE A 146      21.110   1.374  63.110  1.00 17.30           C  
ATOM   1122  CE2 PHE A 146      22.465   3.359  62.959  1.00 19.11           C  
ATOM   1123  CZ  PHE A 146      22.224   2.035  62.604  1.00 20.24           C  
ATOM   1124  N   SER A 147      19.454   5.618  68.262  1.00 14.75           N  
ATOM   1125  CA  SER A 147      18.708   6.468  69.170  1.00 14.49           C  
ATOM   1126  C   SER A 147      18.103   7.735  68.566  1.00 14.59           C  
ATOM   1127  O   SER A 147      18.797   8.561  67.969  1.00 14.22           O  
ATOM   1128  CB  SER A 147      19.594   6.834  70.366  1.00 16.10           C  
ATOM   1129  OG  SER A 147      18.900   7.665  71.279  1.00 17.88           O  
ATOM   1130  N   GLU A 148      16.790   7.856  68.733  1.00 11.75           N  
ATOM   1131  CA  GLU A 148      16.022   8.996  68.265  1.00 11.75           C  
ATOM   1132  C   GLU A 148      16.306   9.380  66.818  1.00 12.11           C  
ATOM   1133  O   GLU A 148      16.432  10.556  66.495  1.00 12.60           O  
ATOM   1134  CB  GLU A 148      16.264  10.192  69.195  1.00 12.66           C  
ATOM   1135  CG  GLU A 148      16.108   9.838  70.675  1.00 14.83           C  
ATOM   1136  CD  GLU A 148      16.335  11.020  71.610  1.00 18.43           C  
ATOM   1137  OE1 GLU A 148      17.173  11.891  71.296  1.00 19.37           O  
ATOM   1138  OE2 GLU A 148      15.686  11.062  72.673  1.00 21.28           O  
ATOM   1139  N   VAL A 149      16.386   8.389  65.939  1.00 12.14           N  
ATOM   1140  CA  VAL A 149      16.647   8.668  64.536  1.00 12.41           C  
ATOM   1141  C   VAL A 149      15.357   8.953  63.773  1.00 14.70           C  
ATOM   1142  O   VAL A 149      15.389   9.363  62.611  1.00 16.17           O  
ATOM   1143  CB  VAL A 149      17.404   7.508  63.870  1.00 11.92           C  
ATOM   1144  CG1 VAL A 149      18.875   7.542  64.289  1.00 10.76           C  
ATOM   1145  CG2 VAL A 149      16.779   6.172  64.283  1.00 10.65           C  
ATOM   1146  N   GLY A 150      14.220   8.740  64.427  1.00 14.91           N  
ATOM   1147  CA  GLY A 150      12.953   9.006  63.772  1.00 15.70           C  
ATOM   1148  C   GLY A 150      11.992   9.767  64.662  1.00 15.88           C  
ATOM   1149  O   GLY A 150      12.219   9.892  65.866  1.00 15.13           O  
ATOM   1150  N   THR A 151      10.925  10.296  64.072  1.00 15.75           N  
ATOM   1151  CA  THR A 151       9.916  11.010  64.846  1.00 16.29           C  
ATOM   1152  C   THR A 151       8.530  10.737  64.279  1.00 15.09           C  
ATOM   1153  O   THR A 151       8.346  10.657  63.066  1.00 16.61           O  
ATOM   1154  CB  THR A 151      10.165  12.556  64.884  1.00 17.73           C  
ATOM   1155  OG1 THR A 151       9.228  13.162  65.786  1.00 19.51           O  
ATOM   1156  CG2 THR A 151       9.995  13.187  63.511  1.00 17.72           C  
ATOM   1157  N   LYS A 152       7.568  10.546  65.173  1.00 13.93           N  
ATOM   1158  CA  LYS A 152       6.181  10.303  64.794  1.00 14.31           C  
ATOM   1159  C   LYS A 152       5.309  10.468  66.034  1.00 14.13           C  
ATOM   1160  O   LYS A 152       5.760  10.222  67.149  1.00 14.03           O  
ATOM   1161  CB  LYS A 152       6.002   8.892  64.223  1.00 13.11           C  
ATOM   1162  CG  LYS A 152       4.674   8.724  63.493  1.00 15.06           C  
ATOM   1163  CD  LYS A 152       4.534   7.390  62.758  1.00 13.79           C  
ATOM   1164  CE  LYS A 152       3.186   7.353  62.025  1.00 16.01           C  
ATOM   1165  NZ  LYS A 152       2.936   6.108  61.244  1.00 14.49           N  
ATOM   1166  N   PHE A 153       4.066  10.894  65.843  1.00 15.96           N  
ATOM   1167  CA  PHE A 153       3.153  11.088  66.966  1.00 17.10           C  
ATOM   1168  C   PHE A 153       3.709  12.083  67.988  1.00 16.83           C  
ATOM   1169  O   PHE A 153       3.374  12.017  69.171  1.00 17.09           O  
ATOM   1170  CB  PHE A 153       2.871   9.749  67.664  1.00 17.99           C  
ATOM   1171  CG  PHE A 153       2.394   8.671  66.740  1.00 19.86           C  
ATOM   1172  CD1 PHE A 153       1.306   8.887  65.901  1.00 20.71           C  
ATOM   1173  CD2 PHE A 153       3.030   7.438  66.703  1.00 20.25           C  
ATOM   1174  CE1 PHE A 153       0.859   7.887  65.036  1.00 21.64           C  
ATOM   1175  CE2 PHE A 153       2.591   6.428  65.840  1.00 21.73           C  
ATOM   1176  CZ  PHE A 153       1.504   6.655  65.007  1.00 18.62           C  
ATOM   1177  N   GLY A 154       4.564  12.994  67.534  1.00 19.06           N  
ATOM   1178  CA  GLY A 154       5.131  13.992  68.429  1.00 19.08           C  
ATOM   1179  C   GLY A 154       6.299  13.534  69.290  1.00 20.48           C  
ATOM   1180  O   GLY A 154       6.764  14.287  70.143  1.00 20.30           O  
ATOM   1181  N   ARG A 155       6.789  12.315  69.076  1.00 20.00           N  
ATOM   1182  CA  ARG A 155       7.905  11.815  69.877  1.00 19.33           C  
ATOM   1183  C   ARG A 155       9.045  11.206  69.057  1.00 16.87           C  
ATOM   1184  O   ARG A 155       8.856  10.837  67.899  1.00 14.74           O  
ATOM   1185  CB  ARG A 155       7.407  10.770  70.875  1.00 19.76           C  
ATOM   1186  CG  ARG A 155       6.932   9.463  70.242  1.00 22.18           C  
ATOM   1187  CD  ARG A 155       6.771   8.402  71.322  1.00 23.30           C  
ATOM   1188  NE  ARG A 155       6.419   7.079  70.815  1.00 21.28           N  
ATOM   1189  CZ  ARG A 155       5.243   6.760  70.286  1.00 23.77           C  
ATOM   1190  NH1 ARG A 155       4.287   7.674  70.181  1.00 20.39           N  
ATOM   1191  NH2 ARG A 155       5.018   5.514  69.880  1.00 22.15           N  
ATOM   1192  N   TRP A 156      10.228  11.115  69.671  1.00 16.99           N  
ATOM   1193  CA  TRP A 156      11.397  10.529  69.021  1.00 15.65           C  
ATOM   1194  C   TRP A 156      11.250   9.015  69.052  1.00 15.11           C  
ATOM   1195  O   TRP A 156      10.717   8.451  70.010  1.00 16.02           O  
ATOM   1196  CB  TRP A 156      12.710  10.890  69.739  1.00 16.24           C  
ATOM   1197  CG  TRP A 156      13.124  12.335  69.664  1.00 16.63           C  
ATOM   1198  CD1 TRP A 156      13.178  13.220  70.699  1.00 16.11           C  
ATOM   1199  CD2 TRP A 156      13.519  13.064  68.493  1.00 17.10           C  
ATOM   1200  NE1 TRP A 156      13.578  14.458  70.249  1.00 19.70           N  
ATOM   1201  CE2 TRP A 156      13.793  14.391  68.898  1.00 18.38           C  
ATOM   1202  CE3 TRP A 156      13.665  12.728  67.143  1.00 16.88           C  
ATOM   1203  CZ2 TRP A 156      14.204  15.382  67.999  1.00 17.95           C  
ATOM   1204  CZ3 TRP A 156      14.074  13.714  66.248  1.00 18.08           C  
ATOM   1205  CH2 TRP A 156      14.338  15.027  66.682  1.00 18.07           C  
ATOM   1206  N   LEU A 157      11.742   8.368  68.005  1.00 14.22           N  
ATOM   1207  CA  LEU A 157      11.684   6.920  67.891  1.00 12.38           C  
ATOM   1208  C   LEU A 157      13.081   6.334  67.745  1.00 12.51           C  
ATOM   1209  O   LEU A 157      13.962   6.946  67.134  1.00 12.66           O  
ATOM   1210  CB  LEU A 157      10.867   6.523  66.669  1.00 11.44           C  
ATOM   1211  CG  LEU A 157       9.420   7.015  66.615  1.00 12.27           C  
ATOM   1212  CD1 LEU A 157       8.843   6.678  65.245  1.00 11.78           C  
ATOM   1213  CD2 LEU A 157       8.606   6.363  67.725  1.00 12.46           C  
ATOM   1214  N   ASP A 158      13.273   5.145  68.310  1.00 13.83           N  
ATOM   1215  CA  ASP A 158      14.548   4.442  68.213  1.00 13.22           C  
ATOM   1216  C   ASP A 158      14.344   3.343  67.185  1.00 14.43           C  
ATOM   1217  O   ASP A 158      13.234   2.827  67.026  1.00 15.56           O  
ATOM   1218  CB  ASP A 158      14.944   3.819  69.554  1.00 14.05           C  
ATOM   1219  CG  ASP A 158      15.309   4.854  70.598  1.00 15.82           C  
ATOM   1220  OD1 ASP A 158      15.521   6.027  70.236  1.00 15.77           O  
ATOM   1221  OD2 ASP A 158      15.396   4.485  71.786  1.00 21.04           O  
ATOM   1222  N   LEU A 159      15.414   2.991  66.487  1.00 13.32           N  
ATOM   1223  CA  LEU A 159      15.345   1.961  65.462  1.00 13.55           C  
ATOM   1224  C   LEU A 159      16.293   0.809  65.793  1.00 15.27           C  
ATOM   1225  O   LEU A 159      17.510   0.998  65.854  1.00 15.18           O  
ATOM   1226  CB  LEU A 159      15.710   2.556  64.093  1.00 11.85           C  
ATOM   1227  CG  LEU A 159      15.439   1.666  62.883  1.00 10.44           C  
ATOM   1228  CD1 LEU A 159      13.937   1.467  62.762  1.00 11.02           C  
ATOM   1229  CD2 LEU A 159      15.995   2.297  61.601  1.00 11.28           C  
ATOM   1230  N   THR A 160      15.729  -0.373  66.037  1.00 14.13           N  
ATOM   1231  CA  THR A 160      16.535  -1.557  66.333  1.00 14.13           C  
ATOM   1232  C   THR A 160      16.618  -2.376  65.058  1.00 13.54           C  
ATOM   1233  O   THR A 160      15.598  -2.801  64.510  1.00 13.17           O  
ATOM   1234  CB  THR A 160      15.906  -2.418  67.458  1.00 14.96           C  
ATOM   1235  OG1 THR A 160      16.072  -1.749  68.716  1.00 17.50           O  
ATOM   1236  CG2 THR A 160      16.567  -3.791  67.533  1.00 13.52           C  
ATOM   1237  N   CYS A 161      17.833  -2.573  64.567  1.00 12.80           N  
ATOM   1238  CA  CYS A 161      18.013  -3.342  63.357  1.00 12.73           C  
ATOM   1239  C   CYS A 161      18.487  -4.743  63.694  1.00 11.76           C  
ATOM   1240  O   CYS A 161      19.220  -4.960  64.668  1.00 11.87           O  
ATOM   1241  CB  CYS A 161      18.993  -2.642  62.418  1.00 12.18           C  
ATOM   1242  SG  CYS A 161      18.410  -1.022  61.819  1.00 18.86           S  
HETATM 1243  N   MSE A 162      18.040  -5.687  62.881  1.00 10.86           N  
HETATM 1244  CA  MSE A 162      18.367  -7.088  63.066  1.00 11.05           C  
HETATM 1245  C   MSE A 162      18.740  -7.691  61.722  1.00 10.35           C  
HETATM 1246  O   MSE A 162      18.365  -7.171  60.673  1.00 11.09           O  
HETATM 1247  CB  MSE A 162      17.162  -7.827  63.655  1.00 11.34           C  
HETATM 1248  CG  MSE A 162      16.625  -7.231  64.946  1.00 13.11           C  
HETATM 1249 SE   MSE A 162      15.179  -8.319  65.672  1.00 17.78          SE  
HETATM 1250  CE  MSE A 162      16.196  -9.711  66.512  1.00 10.56           C  
ATOM   1251  N   GLU A 163      19.469  -8.798  61.763  1.00 10.55           N  
ATOM   1252  CA  GLU A 163      19.916  -9.443  60.543  1.00  9.69           C  
ATOM   1253  C   GLU A 163      19.758 -10.956  60.581  1.00 10.38           C  
ATOM   1254  O   GLU A 163      19.824 -11.582  61.642  1.00 10.18           O  
ATOM   1255  CB  GLU A 163      21.391  -9.103  60.299  1.00  9.17           C  
ATOM   1256  CG  GLU A 163      22.320  -9.780  61.300  1.00 11.12           C  
ATOM   1257  CD  GLU A 163      23.759  -9.280  61.248  1.00 13.96           C  
ATOM   1258  OE1 GLU A 163      24.176  -8.712  60.211  1.00 15.80           O  
ATOM   1259  OE2 GLU A 163      24.481  -9.466  62.249  1.00 13.30           O  
ATOM   1260  N   LEU A 164      19.555 -11.521  59.396  1.00 11.26           N  
ATOM   1261  CA  LEU A 164      19.420 -12.955  59.195  1.00 12.25           C  
ATOM   1262  C   LEU A 164      20.301 -13.304  58.002  1.00 12.81           C  
ATOM   1263  O   LEU A 164      20.038 -12.880  56.878  1.00 12.15           O  
ATOM   1264  CB  LEU A 164      17.973 -13.340  58.873  1.00 10.72           C  
ATOM   1265  CG  LEU A 164      17.774 -14.827  58.552  1.00 13.00           C  
ATOM   1266  CD1 LEU A 164      18.299 -15.677  59.704  1.00 14.58           C  
ATOM   1267  CD2 LEU A 164      16.295 -15.119  58.319  1.00 15.22           C  
ATOM   1268  N   LYS A 165      21.354 -14.068  58.250  1.00 14.68           N  
ATOM   1269  CA  LYS A 165      22.257 -14.462  57.184  1.00 17.32           C  
ATOM   1270  C   LYS A 165      21.738 -15.773  56.604  1.00 18.36           C  
ATOM   1271  O   LYS A 165      21.480 -16.720  57.344  1.00 17.67           O  
ATOM   1272  CB  LYS A 165      23.673 -14.632  57.740  1.00 17.10           C  
ATOM   1273  CG  LYS A 165      24.750 -14.909  56.696  1.00 21.01           C  
ATOM   1274  CD  LYS A 165      26.130 -15.059  57.350  1.00 22.51           C  
ATOM   1275  CE  LYS A 165      26.533 -13.797  58.093  1.00 23.95           C  
ATOM   1276  NZ  LYS A 165      27.819 -13.961  58.841  1.00 27.77           N  
ATOM   1277  N   LEU A 166      21.550 -15.811  55.288  1.00 20.24           N  
ATOM   1278  CA  LEU A 166      21.061 -17.010  54.605  1.00 25.69           C  
ATOM   1279  C   LEU A 166      22.216 -17.801  54.004  1.00 27.35           C  
ATOM   1280  O   LEU A 166      22.173 -19.046  54.069  1.00 30.91           O  
ATOM   1281  CB  LEU A 166      20.071 -16.647  53.491  1.00 24.29           C  
ATOM   1282  CG  LEU A 166      18.648 -16.221  53.862  1.00 27.12           C  
ATOM   1283  CD1 LEU A 166      18.682 -14.890  54.588  1.00 27.13           C  
ATOM   1284  CD2 LEU A 166      17.802 -16.100  52.599  1.00 26.77           C  
TER    1285      LEU A 166                                                      
END
MOLECULE T0417.pdb
ATOM      1  N   ARG    26      -8.346 -19.992  57.885  1.00 43.52           N  
ATOM      2  CA  ARG    26      -6.996 -20.186  57.309  1.00 42.87           C  
ATOM      3  C   ARG    26      -6.720 -19.292  56.082  1.00 40.26           C  
ATOM      4  O   ARG    26      -7.623 -18.925  55.355  1.00 41.81           O  
ATOM      5  CB  ARG    26      -6.794 -21.646  56.944  1.00 44.22           C  
ATOM      6  CG  ARG    26      -5.528 -22.164  57.568  1.00 50.33           C  
ATOM      7  CD  ARG    26      -4.338 -22.107  56.614  1.00 57.94           C  
ATOM      8  NE  ARG    26      -3.925 -23.473  56.307  1.00 63.20           N  
ATOM      9  CZ  ARG    26      -3.141 -24.214  57.094  1.00 67.19           C  
ATOM     10  NH1 ARG    26      -2.670 -23.712  58.236  1.00 67.80           N  
ATOM     11  NH2 ARG    26      -2.832 -25.469  56.744  1.00 69.45           N  
ATOM     12  N   TYR    27      -5.463 -18.989  55.840  1.00 37.22           N  
ATOM     13  CA  TYR    27      -5.081 -18.034  54.827  1.00 33.87           C  
ATOM     14  C   TYR    27      -4.220 -18.789  53.867  1.00 33.61           C  
ATOM     15  O   TYR    27      -3.593 -19.751  54.270  1.00 34.13           O  
ATOM     16  CB  TYR    27      -4.241 -16.978  55.500  1.00 33.02           C  
ATOM     17  CG  TYR    27      -5.094 -16.062  56.338  1.00 32.33           C  
ATOM     18  CD1 TYR    27      -5.863 -15.072  55.730  1.00 32.08           C  
ATOM     19  CD2 TYR    27      -5.190 -16.215  57.741  1.00 36.16           C  
ATOM     20  CE1 TYR    27      -6.682 -14.200  56.491  1.00 27.91           C  
ATOM     21  CE2 TYR    27      -6.007 -15.357  58.503  1.00 34.22           C  
ATOM     22  CZ  TYR    27      -6.756 -14.378  57.859  1.00 30.13           C  
ATOM     23  OH  TYR    27      -7.556 -13.514  58.581  1.00 32.02           O  
ATOM     24  N   HIS    28      -4.200 -18.399  52.596  1.00 31.38           N  
ATOM     25  CA  HIS    28      -3.133 -18.828  51.704  1.00 29.66           C  
ATOM     26  C   HIS    28      -2.222 -17.609  51.439  1.00 29.79           C  
ATOM     27  O   HIS    28      -2.664 -16.473  51.590  1.00 29.92           O  
ATOM     28  CB  HIS    28      -3.714 -19.387  50.414  1.00 29.69           C  
ATOM     29  CG  HIS    28      -4.733 -18.514  49.781  1.00 27.79           C  
ATOM     30  ND1 HIS    28      -4.406 -17.527  48.880  1.00 33.31           N  
ATOM     31  CD2 HIS    28      -6.075 -18.479  49.906  1.00 27.26           C  
ATOM     32  CE1 HIS    28      -5.499 -16.883  48.515  1.00 30.56           C  
ATOM     33  NE2 HIS    28      -6.527 -17.455  49.111  1.00 34.84           N  
ATOM     34  N   LEU    29      -0.964 -17.859  51.082  1.00 28.47           N  
ATOM     35  CA  LEU    29       0.044 -16.840  50.892  1.00 28.69           C  
ATOM     36  C   LEU    29       0.368 -16.782  49.412  1.00 29.46           C  
ATOM     37  O   LEU    29       0.441 -17.827  48.773  1.00 26.65           O  
ATOM     38  CB  LEU    29       1.315 -17.178  51.633  1.00 28.79           C  
ATOM     39  CG  LEU    29       1.209 -17.332  53.136  1.00 31.32           C  
ATOM     40  CD1 LEU    29       2.584 -17.475  53.797  1.00 31.37           C  
ATOM     41  CD2 LEU    29       0.465 -16.152  53.746  1.00 27.79           C  
ATOM     42  N   ARG    30       0.472 -15.592  48.857  1.00 26.45           N  
ATOM     43  CA  ARG    30       0.850 -15.438  47.421  1.00 28.49           C  
ATOM     44  C   ARG    30       1.503 -14.076  47.223  1.00 28.52           C  
ATOM     45  O   ARG    30       1.246 -13.151  48.023  1.00 28.69           O  
ATOM     46  CB  ARG    30      -0.398 -15.536  46.509  1.00 27.55           C  
ATOM     47  CG  ARG    30      -1.509 -14.555  46.889  1.00 29.96           C  
ATOM     48  CD  ARG    30      -2.569 -14.424  45.782  1.00 30.98           C  
ATOM     49  NE  ARG    30      -3.645 -13.487  46.083  1.00 29.51           N  
ATOM     50  CZ  ARG    30      -3.588 -12.183  45.767  1.00 29.30           C  
ATOM     51  NH1 ARG    30      -2.490 -11.696  45.232  1.00 27.51           N  
ATOM     52  NH2 ARG    30      -4.599 -11.364  46.024  1.00 30.05           N  
ATOM     53  N   PRO    31       2.289 -13.912  46.147  1.00 29.31           N  
ATOM     54  CA  PRO    31       2.781 -12.578  45.785  1.00 29.25           C  
ATOM     55  C   PRO    31       1.576 -11.677  45.522  1.00 28.45           C  
ATOM     56  O   PRO    31       0.538 -12.140  45.040  1.00 28.22           O  
ATOM     57  CB  PRO    31       3.568 -12.793  44.450  1.00 27.62           C  
ATOM     58  CG  PRO    31       3.832 -14.298  44.399  1.00 31.77           C  
ATOM     59  CD  PRO    31       2.775 -14.983  45.244  1.00 31.08           C  
ATOM     60  N   PRO    32       1.722 -10.383  45.776  1.00 28.65           N  
ATOM     61  CA  PRO    32       0.600  -9.513  45.417  1.00 27.94           C  
ATOM     62  C   PRO    32       0.530  -9.334  43.884  1.00 29.66           C  
ATOM     63  O   PRO    32       1.502  -9.662  43.150  1.00 28.33           O  
ATOM     64  CB  PRO    32       0.978  -8.155  46.056  1.00 28.26           C  
ATOM     65  CG  PRO    32       2.525  -8.120  45.941  1.00 27.98           C  
ATOM     66  CD  PRO    32       2.869  -9.652  46.336  1.00 27.09           C  
ATOM     67  N   ARG    33      -0.623  -8.867  43.407  1.00 30.25           N  
ATOM     68  CA  ARG    33      -0.841  -8.522  41.995  1.00 32.43           C  
ATOM     69  C   ARG    33      -1.143  -7.022  42.003  1.00 32.10           C  
ATOM     70  O   ARG    33      -1.538  -6.471  43.032  1.00 30.61           O  
ATOM     71  CB  ARG    33      -2.040  -9.308  41.456  1.00 33.09           C  
ATOM     72  CG  ARG    33      -1.665 -10.826  41.301  1.00 36.12           C  
ATOM     73  CD  ARG    33      -2.773 -11.718  40.723  1.00 38.47           C  
ATOM     74  NE  ARG    33      -3.928 -11.758  41.601  1.00 48.20           N  
ATOM     75  CZ  ARG    33      -4.301 -12.801  42.347  1.00 50.41           C  
ATOM     76  NH1 ARG    33      -3.618 -13.963  42.324  1.00 50.43           N  
ATOM     77  NH2 ARG    33      -5.386 -12.672  43.108  1.00 47.97           N  
ATOM     78  N   ARG    34      -1.037  -6.379  40.845  1.00 32.63           N  
ATOM     79  CA  ARG    34      -1.252  -4.951  40.766  1.00 33.66           C  
ATOM     80  C   ARG    34      -2.555  -4.456  41.359  1.00 33.45           C  
ATOM     81  O   ARG    34      -2.594  -3.395  42.050  1.00 34.67           O  
ATOM     82  CB  ARG    34      -1.219  -4.558  39.287  1.00 36.26           C  
ATOM     83  CG  ARG    34      -0.054  -3.698  38.981  1.00 44.64           C  
ATOM     84  CD  ARG    34      -0.449  -2.237  38.486  1.00 50.45           C  
ATOM     85  NE  ARG    34      -1.377  -2.197  37.345  1.00 50.08           N  
ATOM     86  CZ  ARG    34      -1.109  -2.490  36.060  1.00 50.81           C  
ATOM     87  NH1 ARG    34       0.080  -2.879  35.630  1.00 48.97           N  
ATOM     88  NH2 ARG    34      -2.090  -2.385  35.180  1.00 44.07           N  
ATOM     89  N   ASN    35      -3.622  -5.210  41.135  1.00 31.69           N  
ATOM     90  CA  ASN    35      -4.929  -4.832  41.671  1.00 32.20           C  
ATOM     91  C   ASN    35      -5.137  -5.068  43.185  1.00 32.68           C  
ATOM     92  O   ASN    35      -6.252  -4.815  43.725  1.00 33.44           O  
ATOM     93  CB  ASN    35      -6.052  -5.445  40.842  1.00 32.80           C  
ATOM     94  CG  ASN    35      -6.124  -4.799  39.448  1.00 37.02           C  
ATOM     95  OD1 ASN    35      -5.603  -3.680  39.256  1.00 38.28           O  
ATOM     96  ND2 ASN    35      -6.720  -5.489  38.486  1.00 37.56           N  
ATOM     97  N   ASP    36      -4.080  -5.517  43.875  1.00 31.38           N  
ATOM     98  CA  ASP    36      -4.155  -5.689  45.326  1.00 30.72           C  
ATOM     99  C   ASP    36      -3.811  -4.373  46.002  1.00 31.33           C  
ATOM    100  O   ASP    36      -3.940  -4.265  47.243  1.00 29.20           O  
ATOM    101  CB  ASP    36      -3.145  -6.743  45.823  1.00 30.37           C  
ATOM    102  CG  ASP    36      -3.559  -8.155  45.498  1.00 33.10           C  
ATOM    103  OD1 ASP    36      -4.793  -8.438  45.430  1.00 31.11           O  
ATOM    104  OD2 ASP    36      -2.643  -9.017  45.303  1.00 34.74           O  
ATOM    105  N   GLY    37      -3.302  -3.397  45.233  1.00 28.72           N  
ATOM    106  CA  GLY    37      -2.790  -2.139  45.866  1.00 29.06           C  
ATOM    107  C   GLY    37      -3.772  -1.464  46.818  1.00 27.90           C  
ATOM    108  O   GLY    37      -3.379  -1.073  47.918  1.00 28.59           O  
ATOM    109  N   ALA    38      -5.052  -1.328  46.411  1.00 26.81           N  
ATOM    110  CA  ALA    38      -6.050  -0.648  47.253  1.00 27.86           C  
ATOM    111  C   ALA    38      -6.302  -1.434  48.538  1.00 26.85           C  
ATOM    112  O   ALA    38      -6.393  -0.859  49.613  1.00 26.00           O  
ATOM    113  CB  ALA    38      -7.404  -0.441  46.524  1.00 28.58           C  
ATOM    114  N   ALA    39      -6.420  -2.743  48.423  1.00 26.15           N  
ATOM    115  CA  ALA    39      -6.681  -3.541  49.640  1.00 27.31           C  
ATOM    116  C   ALA    39      -5.485  -3.539  50.585  1.00 26.72           C  
ATOM    117  O   ALA    39      -5.676  -3.566  51.841  1.00 25.98           O  
ATOM    118  CB  ALA    39      -6.981  -4.976  49.266  1.00 28.08           C  
ATOM    119  N   ILE    40      -4.259  -3.510  50.021  1.00 24.99           N  
ATOM    120  CA  ILE    40      -3.084  -3.519  50.875  1.00 25.29           C  
ATOM    121  C   ILE    40      -2.991  -2.167  51.564  1.00 25.64           C  
ATOM    122  O   ILE    40      -2.692  -2.061  52.785  1.00 26.59           O  
ATOM    123  CB  ILE    40      -1.771  -3.842  50.062  1.00 26.37           C  
ATOM    124  CG1 ILE    40      -1.765  -5.307  49.582  1.00 25.21           C  
ATOM    125  CG2 ILE    40      -0.501  -3.482  50.887  1.00 28.01           C  
ATOM    126  CD1 ILE    40      -0.820  -5.493  48.336  1.00 25.71           C  
ATOM    127  N   HIS    41      -3.226  -1.124  50.812  1.00 24.91           N  
ATOM    128  CA  HIS    41      -3.290   0.226  51.415  1.00 26.65           C  
ATOM    129  C   HIS    41      -4.357   0.361  52.532  1.00 27.01           C  
ATOM    130  O   HIS    41      -4.089   0.938  53.614  1.00 27.31           O  
ATOM    131  CB  HIS    41      -3.421   1.257  50.299  1.00 27.52           C  
ATOM    132  CG  HIS    41      -3.471   2.689  50.767  1.00 29.79           C  
ATOM    133  ND1 HIS    41      -4.657   3.352  50.971  1.00 36.10           N  
ATOM    134  CD2 HIS    41      -2.487   3.553  51.120  1.00 30.28           C  
ATOM    135  CE1 HIS    41      -4.394   4.583  51.409  1.00 34.52           C  
ATOM    136  NE2 HIS    41      -3.080   4.732  51.463  1.00 30.04           N  
ATOM    137  N   GLN    42      -5.549  -0.181  52.287  1.00 26.19           N  
ATOM    138  CA  GLN    42      -6.575  -0.203  53.331  1.00 28.05           C  
ATOM    139  C   GLN    42      -6.133  -1.033  54.531  1.00 27.46           C  
ATOM    140  O   GLN    42      -6.320  -0.609  55.663  1.00 25.37           O  
ATOM    141  CB  GLN    42      -7.895  -0.793  52.829  1.00 28.03           C  
ATOM    142  CG  GLN    42      -9.065  -0.608  53.916  1.00 28.66           C  
ATOM    143  CD  GLN    42     -10.414  -1.142  53.475  1.00 33.32           C  
ATOM    144  OE1 GLN    42     -10.612  -1.447  52.300  1.00 41.41           O  
ATOM    145  NE2 GLN    42     -11.368  -1.274  54.435  1.00 35.69           N  
ATOM    146  N   LEU    43      -5.553  -2.207  54.280  1.00 27.33           N  
ATOM    147  CA  LEU    43      -5.006  -3.048  55.404  1.00 26.81           C  
ATOM    148  C   LEU    43      -4.003  -2.253  56.236  1.00 28.18           C  
ATOM    149  O   LEU    43      -4.098  -2.231  57.472  1.00 26.75           O  
ATOM    150  CB  LEU    43      -4.357  -4.340  54.851  1.00 27.64           C  
ATOM    151  CG  LEU    43      -3.543  -5.187  55.878  1.00 28.07           C  
ATOM    152  CD1 LEU    43      -4.447  -5.675  57.026  1.00 28.03           C  
ATOM    153  CD2 LEU    43      -2.696  -6.319  55.219  1.00 26.79           C  
ATOM    154  N   VAL    44      -3.038  -1.578  55.598  1.00 25.32           N  
ATOM    155  CA  VAL    44      -2.092  -0.803  56.424  1.00 27.38           C  
ATOM    156  C   VAL    44      -2.810   0.307  57.189  1.00 28.00           C  
ATOM    157  O   VAL    44      -2.476   0.543  58.374  1.00 28.99           O  
ATOM    158  CB  VAL    44      -0.938  -0.208  55.564  1.00 26.93           C  
ATOM    159  CG1 VAL    44      -0.058   0.721  56.426  1.00 25.38           C  
ATOM    160  CG2 VAL    44      -0.085  -1.372  54.916  1.00 26.21           C  
ATOM    161  N   SER    45      -3.758   1.019  56.558  0.50 29.31           N  
ATOM    163  CA  SER    45      -4.530   2.069  57.290  0.50 28.98           C  
ATOM    165  C   SER    45      -5.204   1.510  58.552  0.50 30.14           C  
ATOM    167  O   SER    45      -5.327   2.219  59.557  0.50 28.81           O  
ATOM    169  CB  SER    45      -5.610   2.739  56.415  0.50 29.99           C  
ATOM    171  OG  SER    45      -6.666   1.839  56.087  0.50 26.42           O  
ATOM    173  N   GLU    46      -5.603   0.235  58.518  1.00 29.41           N  
ATOM    174  CA  GLU    46      -6.333  -0.365  59.663  1.00 30.42           C  
ATOM    175  C   GLU    46      -5.380  -1.115  60.592  1.00 30.61           C  
ATOM    176  O   GLU    46      -5.800  -1.893  61.437  1.00 32.07           O  
ATOM    177  CB  GLU    46      -7.385  -1.351  59.122  1.00 29.60           C  
ATOM    178  CG  GLU    46      -8.561  -0.603  58.445  1.00 30.64           C  
ATOM    179  CD  GLU    46      -9.644  -1.536  57.896  1.00 33.95           C  
ATOM    180  OE1 GLU    46      -9.492  -2.770  58.054  1.00 35.13           O  
ATOM    181  OE2 GLU    46     -10.681  -1.019  57.398  1.00 37.39           O  
ATOM    182  N   CYS    47      -4.082  -0.928  60.402  1.00 29.99           N  
ATOM    183  CA  CYS    47      -3.106  -1.482  61.336  1.00 32.22           C  
ATOM    184  C   CYS    47      -2.233  -0.385  61.990  1.00 33.20           C  
ATOM    185  O   CYS    47      -0.989  -0.469  61.869  1.00 34.01           O  
ATOM    186  CB  CYS    47      -2.151  -2.416  60.602  1.00 31.67           C  
ATOM    187  SG  CYS    47      -2.907  -3.952  59.988  1.00 35.54           S  
ATOM    188  N   PRO    48      -2.848   0.636  62.636  1.00 34.49           N  
ATOM    189  CA  PRO    48      -1.960   1.588  63.288  1.00 36.81           C  
ATOM    190  C   PRO    48      -1.179   0.786  64.356  1.00 38.94           C  
ATOM    191  O   PRO    48      -1.737  -0.126  64.961  1.00 40.76           O  
ATOM    192  CB  PRO    48      -2.923   2.615  63.920  1.00 36.20           C  
ATOM    193  CG  PRO    48      -4.289   1.884  64.025  1.00 35.83           C  
ATOM    194  CD  PRO    48      -4.276   0.968  62.844  1.00 33.95           C  
ATOM    195  N   PRO    49       0.079   1.149  64.617  1.00 39.35           N  
ATOM    196  CA  PRO    49       0.663   2.420  64.271  1.00 38.77           C  
ATOM    197  C   PRO    49       1.584   2.354  63.048  1.00 37.29           C  
ATOM    198  O   PRO    49       2.427   3.245  62.892  1.00 37.46           O  
ATOM    199  CB  PRO    49       1.470   2.748  65.541  1.00 40.01           C  
ATOM    200  CG  PRO    49       2.034   1.303  65.928  1.00 40.37           C  
ATOM    201  CD  PRO    49       1.058   0.279  65.304  1.00 41.34           C  
ATOM    202  N   LEU    50       1.450   1.339  62.184  1.00 33.60           N  
ATOM    203  CA  LEU    50       2.284   1.281  60.981  1.00 31.37           C  
ATOM    204  C   LEU    50       2.182   2.631  60.288  1.00 31.20           C  
ATOM    205  O   LEU    50       1.073   3.172  60.214  1.00 29.83           O  
ATOM    206  CB  LEU    50       1.787   0.209  59.982  1.00 30.89           C  
ATOM    207  CG  LEU    50       2.256  -1.240  60.149  1.00 35.36           C  
ATOM    208  CD1 LEU    50       1.696  -2.152  58.999  1.00 34.13           C  
ATOM    209  CD2 LEU    50       3.791  -1.342  60.257  1.00 39.60           C  
ATOM    210  N   ASP    51       3.285   3.131  59.727  1.00 30.23           N  
ATOM    211  CA  ASP    51       3.265   4.391  58.953  1.00 32.14           C  
ATOM    212  C   ASP    51       2.478   4.083  57.654  1.00 32.72           C  
ATOM    213  O   ASP    51       2.745   3.101  56.961  1.00 33.65           O  
ATOM    214  CB  ASP    51       4.700   4.857  58.586  1.00 32.53           C  
ATOM    215  CG  ASP    51       5.532   5.165  59.820  1.00 36.98           C  
ATOM    216  OD1 ASP    51       4.926   5.494  60.883  1.00 37.69           O  
ATOM    217  OD2 ASP    51       6.775   5.045  59.780  1.00 40.44           O  
ATOM    218  N   LEU    52       1.508   4.921  57.326  1.00 32.10           N  
ATOM    219  CA  LEU    52       0.755   4.713  56.085  1.00 31.13           C  
ATOM    220  C   LEU    52       1.502   5.463  54.972  1.00 30.90           C  
ATOM    221  O   LEU    52       2.012   6.533  55.194  1.00 36.52           O  
ATOM    222  CB  LEU    52      -0.616   5.308  56.262  1.00 32.12           C  
ATOM    223  CG  LEU    52      -1.594   5.045  55.104  1.00 31.45           C  
ATOM    224  CD1 LEU    52      -1.847   3.528  54.862  1.00 31.65           C  
ATOM    225  CD2 LEU    52      -2.930   5.737  55.507  1.00 29.87           C  
ATOM    226  N   ASN    53       1.700   4.857  53.830  1.00 28.39           N  
ATOM    227  CA  ASN    53       2.218   5.593  52.673  1.00 26.31           C  
ATOM    228  C   ASN    53       1.104   5.797  51.683  1.00 26.38           C  
ATOM    229  O   ASN    53      -0.011   5.313  51.913  1.00 25.57           O  
ATOM    230  CB  ASN    53       3.383   4.793  52.074  1.00 25.78           C  
ATOM    231  CG  ASN    53       4.546   4.710  53.057  1.00 27.10           C  
ATOM    232  OD1 ASN    53       5.246   5.690  53.267  1.00 26.14           O  
ATOM    233  ND2 ASN    53       4.730   3.537  53.722  1.00 24.92           N  
ATOM    234  N   SER    54       1.383   6.532  50.596  1.00 25.16           N  
ATOM    235  CA  SER    54       0.354   6.835  49.608  1.00 25.16           C  
ATOM    236  C   SER    54      -0.118   5.530  48.964  1.00 23.53           C  
ATOM    237  O   SER    54       0.604   4.507  48.912  1.00 25.73           O  
ATOM    238  CB  SER    54       0.928   7.784  48.521  1.00 24.19           C  
ATOM    239  OG  SER    54       1.966   7.067  47.822  1.00 26.19           O  
ATOM    240  N   LEU    55      -1.303   5.553  48.411  1.00 23.74           N  
ATOM    241  CA  LEU    55      -1.746   4.390  47.605  1.00 25.96           C  
ATOM    242  C   LEU    55      -0.731   3.952  46.558  1.00 25.61           C  
ATOM    243  O   LEU    55      -0.473   2.753  46.399  1.00 23.93           O  
ATOM    244  CB  LEU    55      -3.088   4.685  46.939  1.00 26.47           C  
ATOM    245  CG  LEU    55      -3.615   3.669  45.903  1.00 29.78           C  
ATOM    246  CD1 LEU    55      -3.842   2.311  46.576  1.00 28.35           C  
ATOM    247  CD2 LEU    55      -4.939   4.191  45.224  1.00 28.94           C  
ATOM    248  N   TYR    56      -0.213   4.934  45.826  1.00 25.77           N  
ATOM    249  CA  TYR    56       0.735   4.673  44.780  1.00 27.07           C  
ATOM    250  C   TYR    56       1.969   3.962  45.279  1.00 25.81           C  
ATOM    251  O   TYR    56       2.496   3.114  44.599  1.00 25.80           O  
ATOM    252  CB  TYR    56       1.128   6.024  44.188  1.00 29.90           C  
ATOM    253  CG  TYR    56       1.860   5.905  42.933  1.00 34.30           C  
ATOM    254  CD1 TYR    56       3.208   6.312  42.863  1.00 36.92           C  
ATOM    255  CD2 TYR    56       1.239   5.418  41.780  1.00 35.76           C  
ATOM    256  CE1 TYR    56       3.924   6.250  41.701  1.00 37.66           C  
ATOM    257  CE2 TYR    56       1.978   5.346  40.576  1.00 41.36           C  
ATOM    258  CZ  TYR    56       3.330   5.756  40.563  1.00 38.17           C  
ATOM    259  OH  TYR    56       4.107   5.744  39.401  1.00 37.72           O  
ATOM    260  N   ALA    57       2.430   4.245  46.498  1.00 24.29           N  
ATOM    261  CA  ALA    57       3.600   3.522  47.027  1.00 24.86           C  
ATOM    262  C   ALA    57       3.300   2.043  47.112  1.00 26.52           C  
ATOM    263  O   ALA    57       4.136   1.206  46.742  1.00 24.62           O  
ATOM    264  CB  ALA    57       4.022   4.041  48.460  1.00 25.11           C  
ATOM    265  N   TYR    58       2.085   1.677  47.549  1.00 25.92           N  
ATOM    266  CA  TYR    58       1.745   0.230  47.523  1.00 25.14           C  
ATOM    267  C   TYR    58       1.544  -0.336  46.094  1.00 25.37           C  
ATOM    268  O   TYR    58       1.884  -1.535  45.820  1.00 26.48           O  
ATOM    269  CB  TYR    58       0.500  -0.037  48.415  1.00 25.30           C  
ATOM    270  CG  TYR    58       0.848   0.366  49.838  1.00 24.22           C  
ATOM    271  CD1 TYR    58       1.712  -0.443  50.613  1.00 26.80           C  
ATOM    272  CD2 TYR    58       0.434   1.600  50.358  1.00 25.73           C  
ATOM    273  CE1 TYR    58       2.119  -0.052  51.862  1.00 24.96           C  
ATOM    274  CE2 TYR    58       0.829   1.997  51.651  1.00 27.42           C  
ATOM    275  CZ  TYR    58       1.666   1.198  52.361  1.00 26.68           C  
ATOM    276  OH  TYR    58       2.082   1.580  53.589  1.00 26.33           O  
ATOM    277  N   LEU    59       0.993   0.480  45.187  1.00 25.53           N  
ATOM    278  CA  LEU    59       0.833   0.052  43.768  1.00 26.65           C  
ATOM    279  C   LEU    59       2.180  -0.248  43.202  1.00 26.90           C  
ATOM    280  O   LEU    59       2.289  -1.219  42.440  1.00 27.73           O  
ATOM    281  CB  LEU    59       0.110   1.081  42.870  1.00 25.95           C  
ATOM    282  CG  LEU    59      -1.395   1.257  43.234  1.00 30.17           C  
ATOM    283  CD1 LEU    59      -1.913   2.436  42.477  1.00 30.73           C  
ATOM    284  CD2 LEU    59      -2.152  -0.020  42.880  1.00 32.85           C  
ATOM    285  N   LEU    60       3.190   0.583  43.522  1.00 26.74           N  
ATOM    286  CA  LEU    60       4.537   0.344  43.009  1.00 28.23           C  
ATOM    287  C   LEU    60       5.175  -0.951  43.581  1.00 26.91           C  
ATOM    288  O   LEU    60       5.850  -1.697  42.847  1.00 28.49           O  
ATOM    289  CB  LEU    60       5.481   1.514  43.288  1.00 27.52           C  
ATOM    290  CG  LEU    60       5.028   2.794  42.542  1.00 31.15           C  
ATOM    291  CD1 LEU    60       6.040   3.877  42.820  1.00 34.27           C  
ATOM    292  CD2 LEU    60       4.895   2.517  41.057  1.00 34.78           C  
ATOM    293  N   LEU    61       4.973  -1.228  44.867  1.00 25.66           N  
ATOM    294  CA  LEU    61       5.355  -2.555  45.438  1.00 25.96           C  
ATOM    295  C   LEU    61       4.708  -3.706  44.668  1.00 27.92           C  
ATOM    296  O   LEU    61       5.395  -4.736  44.312  1.00 26.78           O  
ATOM    297  CB  LEU    61       5.011  -2.631  46.981  1.00 24.03           C  
ATOM    298  CG  LEU    61       5.942  -1.738  47.856  1.00 27.40           C  
ATOM    299  CD1 LEU    61       5.388  -1.555  49.258  1.00 29.42           C  
ATOM    300  CD2 LEU    61       7.378  -2.403  47.930  1.00 29.76           C  
ATOM    301  N   CYS    62       3.395  -3.594  44.426  1.00 28.08           N  
ATOM    302  CA  CYS    62       2.709  -4.622  43.669  1.00 29.95           C  
ATOM    303  C   CYS    62       3.240  -4.775  42.244  1.00 29.03           C  
ATOM    304  O   CYS    62       3.299  -5.879  41.711  1.00 30.81           O  
ATOM    305  CB  CYS    62       1.200  -4.301  43.597  1.00 27.81           C  
ATOM    306  SG  CYS    62       0.452  -4.497  45.273  1.00 32.08           S  
ATOM    307  N   GLU    63       3.606  -3.660  41.614  1.00 28.85           N  
ATOM    308  CA  GLU    63       3.984  -3.672  40.209  1.00 28.77           C  
ATOM    309  C   GLU    63       5.464  -4.057  40.035  1.00 29.21           C  
ATOM    310  O   GLU    63       5.824  -4.806  39.069  1.00 30.46           O  
ATOM    311  CB  GLU    63       3.736  -2.269  39.615  1.00 29.21           C  
ATOM    312  CG  GLU    63       4.011  -2.222  38.117  1.00 37.67           C  
ATOM    313  CD  GLU    63       2.831  -2.733  37.311  1.00 42.55           C  
ATOM    314  OE1 GLU    63       1.874  -3.245  37.919  1.00 43.83           O  
ATOM    315  OE2 GLU    63       2.830  -2.605  36.080  1.00 47.33           O  
ATOM    316  N   HIS    64       6.324  -3.604  40.928  1.00 28.30           N  
ATOM    317  CA  HIS    64       7.798  -3.733  40.703  1.00 29.07           C  
ATOM    318  C   HIS    64       8.499  -4.765  41.608  1.00 29.26           C  
ATOM    319  O   HIS    64       9.634  -5.197  41.280  1.00 28.57           O  
ATOM    320  CB  HIS    64       8.479  -2.370  40.822  1.00 29.01           C  
ATOM    321  CG  HIS    64       7.974  -1.362  39.825  1.00 28.49           C  
ATOM    322  ND1 HIS    64       7.936  -0.007  40.081  1.00 28.38           N  
ATOM    323  CD2 HIS    64       7.526  -1.515  38.553  1.00 24.53           C  
ATOM    324  CE1 HIS    64       7.455   0.620  39.020  1.00 28.14           C  
ATOM    325  NE2 HIS    64       7.188  -0.268  38.084  1.00 28.59           N  
ATOM    326  N   HIS    65       7.854  -5.122  42.726  1.00 28.00           N  
ATOM    327  CA  HIS    65       8.482  -5.882  43.853  1.00 28.52           C  
ATOM    328  C   HIS    65       7.629  -7.053  44.246  1.00 29.11           C  
ATOM    329  O   HIS    65       7.776  -7.583  45.340  1.00 29.42           O  
ATOM    330  CB  HIS    65       8.708  -4.968  45.082  1.00 28.44           C  
ATOM    331  CG  HIS    65       9.696  -3.874  44.804  1.00 29.33           C  
ATOM    332  ND1 HIS    65      11.035  -4.127  44.603  1.00 30.49           N  
ATOM    333  CD2 HIS    65       9.524  -2.546  44.570  1.00 32.03           C  
ATOM    334  CE1 HIS    65      11.659  -2.990  44.321  1.00 31.66           C  
ATOM    335  NE2 HIS    65      10.761  -2.018  44.311  1.00 32.48           N  
ATOM    336  N   ALA    66       6.734  -7.501  43.352  1.00 28.97           N  
ATOM    337  CA  ALA    66       5.850  -8.614  43.755  1.00 27.60           C  
ATOM    338  C   ALA    66       6.614  -9.902  44.162  1.00 29.41           C  
ATOM    339  O   ALA    66       6.172 -10.655  45.061  1.00 28.82           O  
ATOM    340  CB  ALA    66       4.854  -8.887  42.644  1.00 29.50           C  
ATOM    341  N   HIS    67       7.765 -10.160  43.534  0.60 29.35           N  
ATOM    343  CA  HIS    67       8.490 -11.416  43.798  0.60 30.73           C  
ATOM    345  C   HIS    67       9.115 -11.457  45.178  0.60 30.25           C  
ATOM    347  O   HIS    67       9.508 -12.513  45.645  0.60 29.91           O  
ATOM    349  CB  HIS    67       9.601 -11.631  42.783  0.60 32.25           C  
ATOM    351  CG  HIS    67       9.125 -11.876  41.394  0.60 35.76           C  
ATOM    353  ND1 HIS    67       9.303 -10.959  40.383  0.60 39.69           N  
ATOM    355  CD2 HIS    67       8.568 -12.969  40.819  0.60 39.60           C  
ATOM    357  CE1 HIS    67       8.837 -11.458  39.250  0.60 41.13           C  
ATOM    359  NE2 HIS    67       8.387 -12.677  39.488  0.60 41.48           N  
ATOM    361  N   THR    68       9.227 -10.300  45.818  1.00 28.53           N  
ATOM    362  CA  THR    68       9.747 -10.240  47.181  1.00 28.06           C  
ATOM    363  C   THR    68       8.708  -9.731  48.208  1.00 28.01           C  
ATOM    364  O   THR    68       9.051  -9.481  49.362  1.00 29.14           O  
ATOM    365  CB  THR    68      11.022  -9.397  47.274  1.00 30.04           C  
ATOM    366  OG1 THR    68      10.771  -8.060  46.762  1.00 26.74           O  
ATOM    367  CG2 THR    68      12.220 -10.011  46.441  1.00 31.60           C  
ATOM    368  N   CYS    69       7.443  -9.633  47.826  1.00 27.30           N  
ATOM    369  CA  CYS    69       6.393  -9.288  48.810  1.00 26.87           C  
ATOM    370  C   CYS    69       5.367 -10.433  48.918  1.00 25.92           C  
ATOM    371  O   CYS    69       5.385 -11.363  48.094  1.00 26.43           O  
ATOM    372  CB  CYS    69       5.655  -8.042  48.334  1.00 27.03           C  
ATOM    373  SG  CYS    69       6.671  -6.537  48.199  1.00 29.52           S  
ATOM    374  N   VAL    70       4.429 -10.329  49.868  1.00 25.15           N  
ATOM    375  CA  VAL    70       3.463 -11.459  50.034  1.00 25.33           C  
ATOM    376  C   VAL    70       2.195 -10.879  50.632  1.00 25.27           C  
ATOM    377  O   VAL    70       2.272  -9.847  51.365  1.00 26.70           O  
ATOM    378  CB  VAL    70       4.081 -12.638  50.878  1.00 25.62           C  
ATOM    379  CG1 VAL    70       4.301 -12.275  52.327  1.00 26.59           C  
ATOM    380  CG2 VAL    70       3.183 -13.910  50.750  1.00 25.43           C  
ATOM    381  N   VAL    71       1.076 -11.429  50.234  1.00 25.73           N  
ATOM    382  CA  VAL    71      -0.190 -11.197  50.993  1.00 27.02           C  
ATOM    383  C   VAL    71      -0.700 -12.493  51.564  1.00 26.89           C  
ATOM    384  O   VAL    71      -0.501 -13.535  50.944  1.00 27.92           O  
ATOM    385  CB  VAL    71      -1.297 -10.555  50.119  1.00 27.88           C  
ATOM    386  CG1 VAL    71      -0.903  -9.120  49.756  1.00 26.55           C  
ATOM    387  CG2 VAL    71      -1.611 -11.366  48.866  1.00 27.07           C  
ATOM    388  N   ALA    72      -1.436 -12.405  52.674  1.00 27.30           N  
ATOM    389  CA  ALA    72      -2.130 -13.502  53.312  1.00 27.72           C  
ATOM    390  C   ALA    72      -3.597 -13.243  52.984  1.00 27.98           C  
ATOM    391  O   ALA    72      -4.143 -12.189  53.353  1.00 27.81           O  
ATOM    392  CB  ALA    72      -1.937 -13.486  54.849  1.00 27.15           C  
ATOM    393  N   GLU    73      -4.209 -14.196  52.308  1.00 26.27           N  
ATOM    394  CA  GLU    73      -5.556 -14.020  51.806  1.00 28.32           C  
ATOM    395  C   GLU    73      -6.515 -15.094  52.303  1.00 29.00           C  
ATOM    396  O   GLU    73      -6.209 -16.299  52.198  1.00 28.41           O  
ATOM    397  CB  GLU    73      -5.467 -14.007  50.255  1.00 28.70           C  
ATOM    398  CG  GLU    73      -6.788 -13.841  49.492  1.00 28.92           C  
ATOM    399  CD  GLU    73      -6.522 -13.641  47.984  1.00 32.45           C  
ATOM    400  OE1 GLU    73      -6.024 -14.571  47.289  1.00 27.94           O  
ATOM    401  OE2 GLU    73      -6.801 -12.538  47.503  1.00 34.45           O  
ATOM    402  N   SER    74      -7.731 -14.693  52.694  1.00 29.53           N  
ATOM    403  CA  SER    74      -8.765 -15.673  53.061  1.00 29.75           C  
ATOM    404  C   SER    74      -9.286 -16.458  51.828  1.00 30.06           C  
ATOM    405  O   SER    74      -9.107 -16.011  50.712  1.00 27.77           O  
ATOM    406  CB  SER    74      -9.936 -14.966  53.732  1.00 30.66           C  
ATOM    407  OG  SER    74     -10.589 -14.116  52.794  1.00 33.06           O  
ATOM    408  N   PRO    75      -9.921 -17.647  52.036  1.00 30.63           N  
ATOM    409  CA  PRO    75     -10.562 -18.396  50.904  1.00 30.69           C  
ATOM    410  C   PRO    75     -11.463 -17.474  50.086  1.00 30.82           C  
ATOM    411  O   PRO    75     -11.449 -17.542  48.834  1.00 29.53           O  
ATOM    412  CB  PRO    75     -11.374 -19.484  51.618  1.00 31.01           C  
ATOM    413  CG  PRO    75     -10.601 -19.760  52.810  1.00 30.29           C  
ATOM    414  CD  PRO    75     -10.043 -18.416  53.293  1.00 31.30           C  
ATOM    415  N   GLY    76     -12.172 -16.591  50.798  1.00 30.96           N  
ATOM    416  CA  GLY    76     -13.011 -15.519  50.207  1.00 30.50           C  
ATOM    417  C   GLY    76     -12.343 -14.319  49.514  1.00 31.46           C  
ATOM    418  O   GLY    76     -13.030 -13.535  48.852  1.00 30.66           O  
ATOM    419  N   GLY    77     -11.023 -14.190  49.598  1.00 29.19           N  
ATOM    420  CA  GLY    77     -10.339 -13.232  48.775  1.00 29.58           C  
ATOM    421  C   GLY    77     -10.040 -11.977  49.572  1.00 29.53           C  
ATOM    422  O   GLY    77      -9.684 -10.958  48.995  1.00 31.79           O  
ATOM    423  N   ARG    78     -10.136 -12.044  50.913  1.00 28.48           N  
ATOM    424  CA  ARG    78      -9.873 -10.848  51.727  1.00 29.09           C  
ATOM    425  C   ARG    78      -8.425 -10.891  52.217  1.00 27.79           C  
ATOM    426  O   ARG    78      -7.982 -11.872  52.839  1.00 28.43           O  
ATOM    427  CB  ARG    78     -10.794 -10.803  52.962  1.00 29.24           C  
ATOM    428  CG  ARG    78     -10.674  -9.488  53.783  1.00 29.76           C  
ATOM    429  CD  ARG    78     -11.513  -9.608  55.092  1.00 30.71           C  
ATOM    430  NE  ARG    78     -10.958 -10.669  55.938  1.00 31.17           N  
ATOM    431  CZ  ARG    78     -11.537 -11.832  56.204  1.00 32.87           C  
ATOM    432  NH1 ARG    78     -12.743 -12.132  55.723  1.00 34.43           N  
ATOM    433  NH2 ARG    78     -10.906 -12.702  56.957  1.00 36.64           N  
ATOM    434  N   ILE    79      -7.719  -9.822  51.981  1.00 27.39           N  
ATOM    435  CA  ILE    79      -6.320  -9.697  52.406  1.00 27.72           C  
ATOM    436  C   ILE    79      -6.230  -9.202  53.849  1.00 28.74           C  
ATOM    437  O   ILE    79      -6.599  -8.039  54.157  1.00 28.27           O  
ATOM    438  CB  ILE    79      -5.556  -8.770  51.429  1.00 28.98           C  
ATOM    439  CG1 ILE    79      -5.429  -9.520  50.075  1.00 30.29           C  
ATOM    440  CG2 ILE    79      -4.118  -8.429  51.986  1.00 27.53           C  
ATOM    441  CD1 ILE    79      -4.862  -8.613  48.923  1.00 30.41           C  
ATOM    442  N   ASP    80      -5.729 -10.056  54.735  1.00 27.45           N  
ATOM    443  CA  ASP    80      -5.560  -9.637  56.133  1.00 28.66           C  
ATOM    444  C   ASP    80      -4.080  -9.556  56.572  1.00 27.12           C  
ATOM    445  O   ASP    80      -3.786  -9.295  57.764  1.00 27.99           O  
ATOM    446  CB  ASP    80      -6.302 -10.598  57.051  1.00 28.86           C  
ATOM    447  CG  ASP    80      -7.819 -10.442  56.983  1.00 29.39           C  
ATOM    448  OD1 ASP    80      -8.371  -9.422  56.491  1.00 31.63           O  
ATOM    449  OD2 ASP    80      -8.446 -11.373  57.460  1.00 30.70           O  
ATOM    450  N   GLY    81      -3.150  -9.804  55.643  1.00 26.73           N  
ATOM    451  CA  GLY    81      -1.699  -9.790  56.013  1.00 26.35           C  
ATOM    452  C   GLY    81      -0.916  -9.287  54.805  1.00 27.06           C  
ATOM    453  O   GLY    81      -1.327  -9.574  53.665  1.00 27.66           O  
ATOM    454  N   PHE    82       0.183  -8.565  55.018  1.00 26.51           N  
ATOM    455  CA  PHE    82       1.040  -8.138  53.891  1.00 26.78           C  
ATOM    456  C   PHE    82       2.436  -7.997  54.438  1.00 26.45           C  
ATOM    457  O   PHE    82       2.606  -7.593  55.582  1.00 26.97           O  
ATOM    458  CB  PHE    82       0.543  -6.776  53.385  1.00 25.55           C  
ATOM    459  CG  PHE    82       1.472  -6.089  52.406  1.00 26.55           C  
ATOM    460  CD1 PHE    82       1.701  -6.630  51.137  1.00 26.94           C  
ATOM    461  CD2 PHE    82       2.056  -4.829  52.727  1.00 28.61           C  
ATOM    462  CE1 PHE    82       2.527  -6.009  50.209  1.00 29.39           C  
ATOM    463  CE2 PHE    82       2.893  -4.208  51.782  1.00 28.58           C  
ATOM    464  CZ  PHE    82       3.100  -4.773  50.523  1.00 30.95           C  
ATOM    465  N   VAL    83       3.420  -8.399  53.654  1.00 24.94           N  
ATOM    466  CA  VAL    83       4.809  -8.007  53.940  1.00 25.26           C  
ATOM    467  C   VAL    83       5.398  -7.337  52.693  1.00 26.55           C  
ATOM    468  O   VAL    83       5.277  -7.916  51.586  1.00 27.21           O  
ATOM    469  CB  VAL    83       5.703  -9.191  54.368  1.00 25.08           C  
ATOM    470  CG1 VAL    83       7.258  -8.668  54.534  1.00 23.40           C  
ATOM    471  CG2 VAL    83       5.138  -9.776  55.714  1.00 24.17           C  
ATOM    472  N   SER    84       6.012  -6.150  52.867  1.00 26.00           N  
ATOM    473  CA  SER    84       6.812  -5.520  51.787  1.00 25.97           C  
ATOM    474  C   SER    84       8.260  -5.738  52.063  1.00 26.57           C  
ATOM    475  O   SER    84       8.708  -5.526  53.197  1.00 25.75           O  
ATOM    476  CB  SER    84       6.584  -4.009  51.689  1.00 25.69           C  
ATOM    477  OG  SER    84       6.566  -3.433  52.995  1.00 29.89           O  
ATOM    478  N   ALA    85       8.981  -6.155  51.036  1.00 27.38           N  
ATOM    479  CA  ALA    85      10.420  -6.409  51.144  1.00 27.43           C  
ATOM    480  C   ALA    85      11.047  -6.303  49.764  1.00 27.99           C  
ATOM    481  O   ALA    85      10.339  -6.409  48.746  1.00 25.90           O  
ATOM    482  CB  ALA    85      10.675  -7.820  51.749  1.00 26.76           C  
ATOM    483  N   TYR    86      12.373  -6.084  49.720  1.00 26.25           N  
ATOM    484  CA  TYR    86      13.085  -6.054  48.473  1.00 27.19           C  
ATOM    485  C   TYR    86      14.542  -6.332  48.753  1.00 27.01           C  
ATOM    486  O   TYR    86      15.039  -6.099  49.872  1.00 25.54           O  
ATOM    487  CB  TYR    86      12.930  -4.690  47.804  1.00 27.19           C  
ATOM    488  CG  TYR    86      13.222  -3.493  48.675  1.00 27.65           C  
ATOM    489  CD1 TYR    86      14.527  -2.921  48.729  1.00 26.43           C  
ATOM    490  CD2 TYR    86      12.210  -2.877  49.401  1.00 27.98           C  
ATOM    491  CE1 TYR    86      14.770  -1.791  49.539  1.00 29.99           C  
ATOM    492  CE2 TYR    86      12.431  -1.733  50.185  1.00 30.16           C  
ATOM    493  CZ  TYR    86      13.720  -1.206  50.246  1.00 32.84           C  
ATOM    494  OH  TYR    86      13.937  -0.089  51.017  1.00 30.48           O  
ATOM    495  N   LEU    87      15.214  -6.879  47.759  1.00 26.78           N  
ATOM    496  CA  LEU    87      16.639  -7.019  47.832  1.00 28.40           C  
ATOM    497  C   LEU    87      17.296  -5.651  47.732  1.00 29.06           C  
ATOM    498  O   LEU    87      16.846  -4.805  46.947  1.00 29.51           O  
ATOM    499  CB  LEU    87      17.116  -7.862  46.641  1.00 30.26           C  
ATOM    500  CG  LEU    87      16.613  -9.329  46.576  1.00 29.46           C  
ATOM    501  CD1 LEU    87      17.072 -10.058  45.319  1.00 32.72           C  
ATOM    502  CD2 LEU    87      16.986 -10.139  47.841  1.00 31.05           C  
ATOM    503  N   LEU    88      18.399  -5.442  48.443  1.00 28.70           N  
ATOM    504  CA  LEU    88      19.029  -4.130  48.394  1.00 28.59           C  
ATOM    505  C   LEU    88      19.777  -4.026  47.070  1.00 30.73           C  
ATOM    506  O   LEU    88      20.589  -4.925  46.752  1.00 29.24           O  
ATOM    507  CB  LEU    88      19.982  -3.936  49.566  1.00 28.02           C  
ATOM    508  CG  LEU    88      19.293  -3.794  50.934  1.00 28.39           C  
ATOM    509  CD1 LEU    88      20.279  -3.314  52.018  1.00 28.39           C  
ATOM    510  CD2 LEU    88      18.090  -2.853  50.809  1.00 26.20           C  
ATOM    511  N   PRO    89      19.537  -2.943  46.296  1.00 30.42           N  
ATOM    512  CA  PRO    89      20.219  -2.804  45.014  1.00 32.20           C  
ATOM    513  C   PRO    89      21.762  -2.825  45.095  1.00 32.91           C  
ATOM    514  O   PRO    89      22.425  -3.382  44.199  1.00 33.87           O  
ATOM    515  CB  PRO    89      19.708  -1.448  44.501  1.00 32.80           C  
ATOM    516  CG  PRO    89      18.473  -1.242  45.189  1.00 31.04           C  
ATOM    517  CD  PRO    89      18.620  -1.817  46.540  1.00 31.51           C  
ATOM    518  N   THR    90      22.337  -2.280  46.161  1.00 32.94           N  
ATOM    519  CA  THR    90      23.789  -2.281  46.248  1.00 34.09           C  
ATOM    520  C   THR    90      24.321  -3.484  47.014  1.00 34.35           C  
ATOM    521  O   THR    90      25.531  -3.772  46.941  1.00 33.12           O  
ATOM    522  CB  THR    90      24.364  -1.030  46.892  1.00 34.66           C  
ATOM    523  OG1 THR    90      23.788  -0.864  48.187  1.00 36.62           O  
ATOM    524  CG2 THR    90      24.133   0.240  46.006  1.00 37.20           C  
ATOM    525  N   ARG    91      23.439  -4.200  47.712  1.00 34.03           N  
ATOM    526  CA  ARG    91      23.827  -5.406  48.446  1.00 34.30           C  
ATOM    527  C   ARG    91      22.786  -6.492  48.219  1.00 33.97           C  
ATOM    528  O   ARG    91      21.987  -6.779  49.116  1.00 33.10           O  
ATOM    529  CB  ARG    91      23.918  -5.099  49.926  1.00 35.32           C  
ATOM    530  CG  ARG    91      25.038  -4.153  50.228  1.00 39.65           C  
ATOM    531  CD  ARG    91      25.081  -3.830  51.694  1.00 45.30           C  
ATOM    532  NE  ARG    91      24.050  -2.895  52.145  1.00 49.53           N  
ATOM    533  CZ  ARG    91      23.387  -3.038  53.299  1.00 51.32           C  
ATOM    534  NH1 ARG    91      23.644  -4.086  54.070  1.00 49.57           N  
ATOM    535  NH2 ARG    91      22.462  -2.149  53.688  1.00 50.88           N  
ATOM    536  N   PRO    92      22.792  -7.093  47.026  1.00 33.68           N  
ATOM    537  CA  PRO    92      21.701  -7.972  46.605  1.00 34.12           C  
ATOM    538  C   PRO    92      21.529  -9.270  47.384  1.00 33.82           C  
ATOM    539  O   PRO    92      20.458  -9.870  47.262  1.00 34.58           O  
ATOM    540  CB  PRO    92      21.993  -8.218  45.119  1.00 34.48           C  
ATOM    541  CG  PRO    92      23.428  -7.960  44.972  1.00 33.03           C  
ATOM    542  CD  PRO    92      23.810  -6.941  45.975  1.00 33.84           C  
ATOM    543  N   ASP    93      22.505  -9.659  48.225  1.00 32.31           N  
ATOM    544  CA  ASP    93      22.354 -10.778  49.163  1.00 31.47           C  
ATOM    545  C   ASP    93      21.700 -10.408  50.513  1.00 30.90           C  
ATOM    546  O   ASP    93      21.653 -11.211  51.457  1.00 28.55           O  
ATOM    547  CB  ASP    93      23.721 -11.478  49.413  1.00 33.27           C  
ATOM    548  CG  ASP    93      24.676 -10.625  50.245  1.00 36.78           C  
ATOM    549  OD1 ASP    93      24.443  -9.409  50.429  1.00 40.28           O  
ATOM    550  OD2 ASP    93      25.710 -11.163  50.697  1.00 43.64           O  
ATOM    551  N   VAL    94      21.249  -9.162  50.603  1.00 28.87           N  
ATOM    552  CA  VAL    94      20.457  -8.699  51.733  1.00 28.13           C  
ATOM    553  C   VAL    94      18.981  -8.470  51.323  1.00 28.96           C  
ATOM    554  O   VAL    94      18.695  -7.666  50.418  1.00 28.15           O  
ATOM    555  CB  VAL    94      21.014  -7.370  52.297  1.00 27.32           C  
ATOM    556  CG1 VAL    94      20.109  -6.882  53.458  1.00 27.98           C  
ATOM    557  CG2 VAL    94      22.492  -7.527  52.792  1.00 29.25           C  
ATOM    558  N   LEU    95      18.049  -9.079  52.061  1.00 26.89           N  
ATOM    559  CA  LEU    95      16.633  -8.800  51.864  1.00 26.64           C  
ATOM    560  C   LEU    95      16.230  -7.805  52.970  1.00 27.06           C  
ATOM    561  O   LEU    95      16.477  -8.060  54.160  1.00 28.69           O  
ATOM    562  CB  LEU    95      15.839 -10.098  52.041  1.00 26.26           C  
ATOM    563  CG  LEU    95      14.311  -9.916  51.928  1.00 25.34           C  
ATOM    564  CD1 LEU    95      13.952  -9.685  50.455  1.00 26.94           C  
ATOM    565  CD2 LEU    95      13.604 -11.178  52.432  1.00 32.15           C  
ATOM    566  N   PHE    96      15.679  -6.662  52.566  1.00 27.52           N  
ATOM    567  CA  PHE    96      15.202  -5.675  53.517  1.00 27.55           C  
ATOM    568  C   PHE    96      13.662  -5.765  53.640  1.00 27.78           C  
ATOM    569  O   PHE    96      13.003  -5.745  52.644  1.00 26.91           O  
ATOM    570  CB  PHE    96      15.624  -4.282  53.085  1.00 26.56           C  
ATOM    571  CG  PHE    96      15.205  -3.242  54.081  1.00 30.36           C  
ATOM    572  CD1 PHE    96      15.994  -2.996  55.197  1.00 29.09           C  
ATOM    573  CD2 PHE    96      14.000  -2.540  53.906  1.00 30.48           C  
ATOM    574  CE1 PHE    96      15.624  -2.047  56.130  1.00 31.88           C  
ATOM    575  CE2 PHE    96      13.606  -1.623  54.848  1.00 29.42           C  
ATOM    576  CZ  PHE    96      14.449  -1.386  55.971  1.00 30.26           C  
ATOM    577  N   VAL    97      13.159  -5.909  54.858  1.00 27.66           N  
ATOM    578  CA  VAL    97      11.740  -5.976  55.159  1.00 27.14           C  
ATOM    579  C   VAL    97      11.297  -4.597  55.617  1.00 27.86           C  
ATOM    580  O   VAL    97      11.792  -4.058  56.629  1.00 28.05           O  
ATOM    581  CB  VAL    97      11.463  -7.017  56.234  1.00 28.05           C  
ATOM    582  CG1 VAL    97       9.912  -6.967  56.658  1.00 29.13           C  
ATOM    583  CG2 VAL    97      11.846  -8.350  55.699  1.00 25.98           C  
ATOM    584  N   TRP    98      10.354  -4.026  54.869  1.00 28.94           N  
ATOM    585  CA  TRP    98       9.929  -2.623  55.103  1.00 28.42           C  
ATOM    586  C   TRP    98       8.756  -2.633  56.049  1.00 29.26           C  
ATOM    587  O   TRP    98       8.878  -2.057  57.123  1.00 30.60           O  
ATOM    588  CB  TRP    98       9.587  -1.950  53.765  1.00 27.55           C  
ATOM    589  CG  TRP    98       9.016  -0.590  53.807  1.00 29.09           C  
ATOM    590  CD1 TRP    98       8.785   0.229  54.912  1.00 29.88           C  
ATOM    591  CD2 TRP    98       8.665   0.161  52.671  1.00 30.40           C  
ATOM    592  NE1 TRP    98       8.276   1.440  54.481  1.00 31.04           N  
ATOM    593  CE2 TRP    98       8.181   1.403  53.109  1.00 29.25           C  
ATOM    594  CE3 TRP    98       8.633  -0.145  51.311  1.00 29.88           C  
ATOM    595  CZ2 TRP    98       7.711   2.365  52.224  1.00 31.90           C  
ATOM    596  CZ3 TRP    98       8.212   0.814  50.395  1.00 34.17           C  
ATOM    597  CH2 TRP    98       7.725   2.058  50.859  1.00 30.83           C  
ATOM    598  N   GLN    99       7.614  -3.248  55.678  1.00 25.62           N  
ATOM    599  CA  GLN    99       6.445  -3.289  56.588  1.00 26.52           C  
ATOM    600  C   GLN    99       5.901  -4.710  56.728  1.00 28.09           C  
ATOM    601  O   GLN    99       5.874  -5.466  55.739  1.00 27.74           O  
ATOM    602  CB  GLN    99       5.323  -2.376  56.038  1.00 27.16           C  
ATOM    603  CG  GLN    99       5.757  -0.913  56.070  1.00 29.38           C  
ATOM    604  CD  GLN    99       4.585  -0.002  55.814  1.00 31.01           C  
ATOM    605  OE1 GLN    99       3.976  -0.061  54.750  1.00 29.00           O  
ATOM    606  NE2 GLN    99       4.288   0.883  56.780  1.00 29.69           N  
ATOM    607  N   VAL   100       5.489  -5.065  57.952  1.00 27.68           N  
ATOM    608  CA  VAL   100       4.776  -6.322  58.221  1.00 28.76           C  
ATOM    609  C   VAL   100       3.442  -5.927  58.797  1.00 28.50           C  
ATOM    610  O   VAL   100       3.362  -5.389  59.917  1.00 27.91           O  
ATOM    611  CB  VAL   100       5.543  -7.191  59.220  1.00 28.90           C  
ATOM    612  CG1 VAL   100       4.801  -8.560  59.495  1.00 29.29           C  
ATOM    613  CG2 VAL   100       6.949  -7.415  58.687  1.00 29.67           C  
ATOM    614  N   ALA   101       2.389  -6.094  58.015  1.00 28.23           N  
ATOM    615  CA  ALA   101       1.018  -5.732  58.462  1.00 28.21           C  
ATOM    616  C   ALA   101       0.213  -7.007  58.723  1.00 29.52           C  
ATOM    617  O   ALA   101       0.076  -7.861  57.847  1.00 28.87           O  
ATOM    618  CB  ALA   101       0.330  -4.906  57.384  1.00 30.21           C  
ATOM    619  N   VAL   102      -0.331  -7.127  59.925  1.00 27.61           N  
ATOM    620  CA  VAL   102      -1.207  -8.267  60.262  1.00 28.64           C  
ATOM    621  C   VAL   102      -2.467  -7.696  60.876  1.00 28.88           C  
ATOM    622  O   VAL   102      -2.410  -7.021  61.930  1.00 28.99           O  
ATOM    623  CB  VAL   102      -0.509  -9.219  61.211  1.00 30.54           C  
ATOM    624  CG1 VAL   102      -1.434 -10.307  61.667  1.00 29.44           C  
ATOM    625  CG2 VAL   102       0.720  -9.834  60.558  1.00 28.25           C  
ATOM    626  N   HIS   103      -3.588  -7.835  60.202  1.00 27.37           N  
ATOM    627  CA  HIS   103      -4.831  -7.244  60.725  1.00 26.76           C  
ATOM    628  C   HIS   103      -5.227  -7.777  62.118  1.00 29.75           C  
ATOM    629  O   HIS   103      -4.967  -8.922  62.406  1.00 26.61           O  
ATOM    630  CB  HIS   103      -5.977  -7.524  59.754  1.00 28.19           C  
ATOM    631  CG  HIS   103      -7.130  -6.578  59.921  1.00 28.76           C  
ATOM    632  ND1 HIS   103      -8.104  -6.757  60.883  1.00 29.49           N  
ATOM    633  CD2 HIS   103      -7.419  -5.406  59.298  1.00 30.28           C  
ATOM    634  CE1 HIS   103      -8.984  -5.771  60.801  1.00 31.84           C  
ATOM    635  NE2 HIS   103      -8.599  -4.942  59.840  1.00 32.54           N  
ATOM    636  N   SER   104      -5.849  -6.953  62.977  1.00 31.60           N  
ATOM    637  CA  SER   104      -6.337  -7.442  64.270  1.00 34.74           C  
ATOM    638  C   SER   104      -7.262  -8.656  64.158  1.00 35.83           C  
ATOM    639  O   SER   104      -7.247  -9.472  65.043  1.00 36.87           O  
ATOM    640  CB  SER   104      -7.006  -6.316  65.117  1.00 35.80           C  
ATOM    641  OG  SER   104      -7.916  -5.455  64.372  1.00 39.13           O  
ATOM    642  N   ARG   105      -8.035  -8.808  63.065  1.00 37.04           N  
ATOM    643  CA  ARG   105      -8.992  -9.939  62.956  1.00 37.31           C  
ATOM    644  C   ARG   105      -8.196 -11.217  62.655  1.00 37.29           C  
ATOM    645  O   ARG   105      -8.738 -12.293  62.691  1.00 38.32           O  
ATOM    646  CB  ARG   105     -10.059  -9.717  61.859  1.00 37.38           C  
ATOM    647  CG  ARG   105      -9.546  -9.922  60.417  1.00 37.50           C  
ATOM    648  CD  ARG   105     -10.593  -9.682  59.304  1.00 35.81           C  
ATOM    649  NE  ARG   105     -11.210  -8.341  59.366  1.00 34.57           N  
ATOM    650  CZ  ARG   105     -10.934  -7.297  58.581  1.00 34.77           C  
ATOM    651  NH1 ARG   105     -11.615  -6.151  58.758  1.00 35.83           N  
ATOM    652  NH2 ARG   105      -9.995  -7.344  57.621  1.00 33.39           N  
ATOM    653  N   ALA   106      -6.906 -11.082  62.357  1.00 36.73           N  
ATOM    654  CA  ALA   106      -6.086 -12.231  61.957  1.00 37.30           C  
ATOM    655  C   ALA   106      -5.017 -12.644  62.990  1.00 38.82           C  
ATOM    656  O   ALA   106      -4.114 -13.416  62.680  1.00 38.52           O  
ATOM    657  CB  ALA   106      -5.448 -11.964  60.585  1.00 37.06           C  
ATOM    658  N   ARG   107      -5.113 -12.088  64.193  1.00 40.42           N  
ATOM    659  CA  ARG   107      -4.285 -12.497  65.359  1.00 43.16           C  
ATOM    660  C   ARG   107      -4.401 -13.970  65.700  1.00 42.97           C  
ATOM    661  O   ARG   107      -5.462 -14.594  65.532  1.00 43.89           O  
ATOM    662  CB  ARG   107      -4.697 -11.717  66.605  1.00 43.97           C  
ATOM    663  CG  ARG   107      -4.300 -10.277  66.532  1.00 48.79           C  
ATOM    664  CD  ARG   107      -2.970 -10.143  65.803  1.00 55.48           C  
ATOM    665  NE  ARG   107      -2.759  -8.786  65.308  1.00 59.99           N  
ATOM    666  CZ  ARG   107      -1.573  -8.275  65.013  1.00 62.07           C  
ATOM    667  NH1 ARG   107      -0.462  -9.010  65.150  1.00 62.83           N  
ATOM    668  NH2 ARG   107      -1.500  -7.023  64.583  1.00 65.01           N  
ATOM    669  N   GLY   108      -3.309 -14.542  66.178  1.00 43.59           N  
ATOM    670  CA  GLY   108      -3.320 -15.943  66.575  1.00 43.64           C  
ATOM    671  C   GLY   108      -3.065 -16.904  65.432  1.00 44.48           C  
ATOM    672  O   GLY   108      -3.261 -18.093  65.594  1.00 43.64           O  
ATOM    673  N   HIS   109      -2.608 -16.401  64.287  1.00 43.96           N  
ATOM    674  CA  HIS   109      -2.318 -17.277  63.159  1.00 44.81           C  
ATOM    675  C   HIS   109      -0.822 -17.262  62.841  1.00 44.35           C  
ATOM    676  O   HIS   109      -0.394 -17.882  61.834  1.00 44.94           O  
ATOM    677  CB  HIS   109      -3.116 -16.847  61.894  1.00 45.94           C  
ATOM    678  CG  HIS   109      -4.601 -17.074  61.993  1.00 50.00           C  
ATOM    679  ND1 HIS   109      -5.217 -18.210  61.501  1.00 53.82           N  
ATOM    680  CD2 HIS   109      -5.593 -16.306  62.513  1.00 52.01           C  
ATOM    681  CE1 HIS   109      -6.521 -18.140  61.732  1.00 54.79           C  
ATOM    682  NE2 HIS   109      -6.776 -16.990  62.337  1.00 53.31           N  
ATOM    683  N   ARG   110      -0.046 -16.504  63.638  1.00 42.56           N  
ATOM    684  CA  ARG   110       1.387 -16.316  63.418  1.00 41.19           C  
ATOM    685  C   ARG   110       1.656 -15.936  61.948  1.00 38.86           C  
ATOM    686  O   ARG   110       2.615 -16.457  61.312  1.00 36.36           O  
ATOM    687  CB  ARG   110       2.109 -17.608  63.749  1.00 42.35           C  
ATOM    688  CG  ARG   110       3.175 -17.478  64.793  1.00 49.54           C  
ATOM    689  CD  ARG   110       2.709 -17.960  66.144  1.00 56.27           C  
ATOM    690  NE  ARG   110       3.830 -18.483  66.941  1.00 63.66           N  
ATOM    691  CZ  ARG   110       3.741 -18.939  68.202  1.00 66.48           C  
ATOM    692  NH1 ARG   110       2.579 -18.942  68.859  1.00 67.31           N  
ATOM    693  NH2 ARG   110       4.829 -19.393  68.825  1.00 66.34           N  
ATOM    694  N   LEU   111       0.803 -15.063  61.399  1.00 36.64           N  
ATOM    695  CA  LEU   111       0.934 -14.711  60.004  1.00 36.13           C  
ATOM    696  C   LEU   111       2.263 -14.069  59.730  1.00 35.20           C  
ATOM    697  O   LEU   111       2.786 -14.268  58.647  1.00 35.02           O  
ATOM    698  CB  LEU   111      -0.134 -13.715  59.503  1.00 37.49           C  
ATOM    699  CG  LEU   111      -1.445 -14.246  58.935  1.00 40.47           C  
ATOM    700  CD1 LEU   111      -2.185 -13.067  58.293  1.00 36.90           C  
ATOM    701  CD2 LEU   111      -1.187 -15.437  57.981  1.00 41.44           C  
ATOM    702  N   GLY   112       2.775 -13.237  60.656  1.00 33.27           N  
ATOM    703  CA  GLY   112       4.015 -12.473  60.342  1.00 32.76           C  
ATOM    704  C   GLY   112       5.179 -13.418  60.021  1.00 33.00           C  
ATOM    705  O   GLY   112       5.776 -13.354  58.948  1.00 30.20           O  
ATOM    706  N   ARG   113       5.428 -14.370  60.914  1.00 32.81           N  
ATOM    707  CA  ARG   113       6.415 -15.429  60.648  1.00 34.49           C  
ATOM    708  C   ARG   113       6.133 -16.288  59.440  1.00 32.25           C  
ATOM    709  O   ARG   113       7.054 -16.581  58.686  1.00 31.91           O  
ATOM    710  CB  ARG   113       6.688 -16.370  61.862  1.00 36.39           C  
ATOM    711  CG  ARG   113       5.730 -16.223  62.962  1.00 43.11           C  
ATOM    712  CD  ARG   113       6.218 -15.164  63.983  1.00 49.74           C  
ATOM    713  NE  ARG   113       7.038 -15.759  65.049  1.00 55.53           N  
ATOM    714  CZ  ARG   113       6.763 -15.684  66.340  1.00 54.24           C  
ATOM    715  NH1 ARG   113       7.601 -16.206  67.206  1.00 58.55           N  
ATOM    716  NH2 ARG   113       5.691 -15.044  66.758  1.00 57.00           N  
ATOM    717  N   ALA   114       4.877 -16.694  59.225  1.00 31.63           N  
ATOM    718  CA  ALA   114       4.552 -17.457  57.989  1.00 31.72           C  
ATOM    719  C   ALA   114       4.884 -16.676  56.693  1.00 31.78           C  
ATOM    720  O   ALA   114       5.430 -17.231  55.716  1.00 30.96           O  
ATOM    721  CB  ALA   114       3.104 -17.838  57.959  1.00 31.23           C  
ATOM    722  N   MET   115       4.512 -15.410  56.693  1.00 29.72           N  
ATOM    723  CA  MET   115       4.727 -14.548  55.539  1.00 31.83           C  
ATOM    724  C   MET   115       6.214 -14.314  55.284  1.00 30.40           C  
ATOM    725  O   MET   115       6.680 -14.435  54.137  1.00 30.20           O  
ATOM    726  CB  MET   115       3.932 -13.262  55.684  1.00 31.94           C  
ATOM    727  CG  MET   115       2.395 -13.472  55.437  1.00 30.62           C  
ATOM    728  SD  MET   115       1.599 -11.668  55.459  0.85 34.94          SE  
ATOM    729  CE  MET   115       1.955 -11.047  57.300  1.00 26.83           C  
ATOM    730  N   LEU   116       6.972 -14.034  56.337  1.00 30.11           N  
ATOM    731  CA  LEU   116       8.423 -13.855  56.183  1.00 30.42           C  
ATOM    732  C   LEU   116       9.132 -15.107  55.659  1.00 30.52           C  
ATOM    733  O   LEU   116       9.966 -15.028  54.732  1.00 30.68           O  
ATOM    734  CB  LEU   116       9.049 -13.363  57.495  1.00 29.45           C  
ATOM    735  CG  LEU   116       8.651 -11.953  57.913  1.00 32.33           C  
ATOM    736  CD1 LEU   116       9.015 -11.816  59.419  1.00 35.29           C  
ATOM    737  CD2 LEU   116       9.393 -10.887  57.089  1.00 34.27           C  
ATOM    738  N   GLY   117       8.811 -16.250  56.264  1.00 31.60           N  
ATOM    739  CA  GLY   117       9.225 -17.559  55.761  1.00 32.49           C  
ATOM    740  C   GLY   117       8.870 -17.829  54.321  1.00 33.44           C  
ATOM    741  O   GLY   117       9.713 -18.309  53.581  1.00 34.87           O  
ATOM    742  N   HIS   118       7.643 -17.520  53.908  1.00 32.19           N  
ATOM    743  CA  HIS   118       7.239 -17.655  52.513  1.00 31.65           C  
ATOM    744  C   HIS   118       8.130 -16.889  51.551  1.00 31.42           C  
ATOM    745  O   HIS   118       8.502 -17.405  50.498  1.00 32.19           O  
ATOM    746  CB  HIS   118       5.788 -17.174  52.319  1.00 32.80           C  
ATOM    747  CG  HIS   118       5.195 -17.549  50.997  1.00 32.35           C  
ATOM    748  ND1 HIS   118       5.266 -16.733  49.890  1.00 35.08           N  
ATOM    749  CD2 HIS   118       4.491 -18.640  50.612  1.00 31.11           C  
ATOM    750  CE1 HIS   118       4.647 -17.311  48.877  1.00 34.92           C  
ATOM    751  NE2 HIS   118       4.152 -18.462  49.292  1.00 36.60           N  
ATOM    752  N   ILE   119       8.438 -15.634  51.861  1.00 27.83           N  
ATOM    753  CA  ILE   119       9.319 -14.863  50.990  1.00 28.68           C  
ATOM    754  C   ILE   119      10.745 -15.432  50.966  1.00 29.77           C  
ATOM    755  O   ILE   119      11.387 -15.563  49.902  1.00 30.26           O  
ATOM    756  CB  ILE   119       9.361 -13.371  51.418  1.00 26.17           C  
ATOM    757  CG1 ILE   119       7.980 -12.759  51.268  1.00 27.11           C  
ATOM    758  CG2 ILE   119      10.388 -12.629  50.564  1.00 30.42           C  
ATOM    759  CD1 ILE   119       7.882 -11.398  51.963  1.00 24.95           C  
ATOM    760  N   LEU   120      11.245 -15.784  52.125  1.00 32.96           N  
ATOM    761  CA  LEU   120      12.586 -16.346  52.212  1.00 33.74           C  
ATOM    762  C   LEU   120      12.776 -17.641  51.474  1.00 35.19           C  
ATOM    763  O   LEU   120      13.885 -17.917  51.013  1.00 34.94           O  
ATOM    764  CB  LEU   120      13.022 -16.521  53.656  1.00 33.50           C  
ATOM    765  CG  LEU   120      13.470 -15.247  54.371  1.00 35.70           C  
ATOM    766  CD1 LEU   120      13.544 -15.502  55.849  1.00 38.36           C  
ATOM    767  CD2 LEU   120      14.790 -14.698  53.812  1.00 39.50           C  
ATOM    768  N   GLU   121      11.702 -18.426  51.372  0.50 35.23           N  
ATOM    770  CA  GLU   121      11.690 -19.720  50.677  0.50 35.62           C  
ATOM    772  C   GLU   121      11.723 -19.618  49.173  0.50 35.75           C  
ATOM    774  O   GLU   121      12.049 -20.587  48.503  0.50 34.88           O  
ATOM    776  CB  GLU   121      10.452 -20.526  51.071  0.50 36.69           C  
ATOM    778  CG  GLU   121      10.598 -21.296  52.369  0.50 39.07           C  
ATOM    780  CD  GLU   121      11.349 -22.608  52.206  0.50 42.94           C  
ATOM    782  OE1 GLU   121      12.548 -22.658  52.579  0.50 43.73           O  
ATOM    784  OE2 GLU   121      10.745 -23.587  51.700  0.50 45.46           O  
ATOM    786  N   ARG   122      11.381 -18.453  48.636  1.00 34.98           N  
ATOM    787  CA  ARG   122      11.326 -18.266  47.196  1.00 36.09           C  
ATOM    788  C   ARG   122      12.649 -18.336  46.465  1.00 36.25           C  
ATOM    789  O   ARG   122      13.711 -17.971  47.010  1.00 35.35           O  
ATOM    790  CB  ARG   122      10.743 -16.923  46.844  1.00 34.73           C  
ATOM    791  CG  ARG   122       9.356 -16.751  47.422  1.00 36.99           C  
ATOM    792  CD  ARG   122       8.745 -15.495  46.945  1.00 33.49           C  
ATOM    793  NE  ARG   122       7.382 -15.449  47.459  1.00 31.96           N  
ATOM    794  CZ  ARG   122       6.671 -14.329  47.496  1.00 31.99           C  
ATOM    795  NH1 ARG   122       7.199 -13.234  46.988  1.00 29.85           N  
ATOM    796  NH2 ARG   122       5.442 -14.317  47.987  1.00 32.40           N  
ATOM    797  N   GLN   123      12.554 -18.771  45.212  0.50 36.89           N  
ATOM    799  CA  GLN   123      13.699 -18.931  44.318  0.50 37.61           C  
ATOM    801  C   GLN   123      14.442 -17.601  44.099  0.50 37.74           C  
ATOM    803  O   GLN   123      15.666 -17.585  43.942  0.50 37.85           O  
ATOM    805  CB  GLN   123      13.247 -19.587  42.994  0.50 38.09           C  
ATOM    807  CG  GLN   123      11.711 -19.523  42.707  0.50 40.02           C  
ATOM    809  CD  GLN   123      10.839 -20.426  43.616  0.50 41.57           C  
ATOM    811  OE1 GLN   123       9.933 -19.950  44.313  0.50 39.31           O  
ATOM    813  NE2 GLN   123      11.107 -21.733  43.587  0.50 41.50           N  
ATOM    815  N   GLU   124      13.700 -16.488  44.149  1.00 37.77           N  
ATOM    816  CA  GLU   124      14.272 -15.133  44.085  1.00 37.11           C  
ATOM    817  C   GLU   124      15.204 -14.802  45.267  1.00 35.47           C  
ATOM    818  O   GLU   124      16.125 -13.991  45.123  1.00 36.09           O  
ATOM    819  CB  GLU   124      13.150 -14.074  43.971  1.00 39.80           C  
ATOM    820  CG  GLU   124      12.278 -14.197  42.672  1.00 45.55           C  
ATOM    821  CD  GLU   124      11.085 -15.181  42.758  1.00 49.57           C  
ATOM    822  OE1 GLU   124      11.156 -16.209  43.448  1.00 51.25           O  
ATOM    823  OE2 GLU   124      10.046 -14.917  42.113  1.00 56.74           O  
ATOM    824  N   CYS   125      14.997 -15.449  46.411  1.00 33.75           N  
ATOM    825  CA  CYS   125      15.797 -15.175  47.634  1.00 33.53           C  
ATOM    826  C   CYS   125      16.823 -16.283  47.909  1.00 34.23           C  
ATOM    827  O   CYS   125      17.407 -16.338  48.992  1.00 33.76           O  
ATOM    828  CB  CYS   125      14.878 -14.981  48.857  1.00 31.65           C  
ATOM    829  SG  CYS   125      13.774 -13.531  48.696  1.00 34.67           S  
ATOM    830  N   ARG   126      17.049 -17.157  46.937  0.50 34.15           N  
ATOM    832  CA  ARG   126      17.935 -18.304  47.165  0.50 34.77           C  
ATOM    834  C   ARG   126      19.400 -17.918  47.418  0.50 34.37           C  
ATOM    836  O   ARG   126      20.183 -18.740  47.907  0.50 34.03           O  
ATOM    838  CB  ARG   126      17.821 -19.319  46.026  0.50 35.04           C  
ATOM    840  CG  ARG   126      18.333 -18.817  44.678  0.50 37.29           C  
ATOM    842  CD  ARG   126      17.579 -19.487  43.545  0.50 41.20           C  
ATOM    844  NE  ARG   126      17.995 -19.010  42.229  0.50 42.67           N  
ATOM    846  CZ  ARG   126      17.783 -19.681  41.102  0.50 43.63           C  
ATOM    848  NH1 ARG   126      18.192 -19.174  39.943  0.50 43.05           N  
ATOM    850  NH2 ARG   126      17.164 -20.864  41.139  0.50 42.07           N  
ATOM    852  N   HIS   127      19.775 -16.688  47.079  1.00 33.69           N  
ATOM    853  CA  HIS   127      21.131 -16.196  47.403  1.00 34.51           C  
ATOM    854  C   HIS   127      21.196 -15.224  48.612  1.00 33.68           C  
ATOM    855  O   HIS   127      22.269 -14.732  48.947  1.00 33.77           O  
ATOM    856  CB  HIS   127      21.789 -15.557  46.177  1.00 34.70           C  
ATOM    857  CG  HIS   127      22.155 -16.530  45.106  1.00 39.58           C  
ATOM    858  ND1 HIS   127      21.919 -16.279  43.771  1.00 42.87           N  
ATOM    859  CD2 HIS   127      22.770 -17.740  45.161  1.00 41.75           C  
ATOM    860  CE1 HIS   127      22.375 -17.296  43.048  1.00 45.27           C  
ATOM    861  NE2 HIS   127      22.888 -18.197  43.868  1.00 42.60           N  
ATOM    862  N   VAL   128      20.064 -14.973  49.271  1.00 31.51           N  
ATOM    863  CA  VAL   128      20.045 -14.065  50.396  1.00 31.98           C  
ATOM    864  C   VAL   128      20.826 -14.690  51.529  1.00 33.28           C  
ATOM    865  O   VAL   128      20.625 -15.861  51.855  1.00 33.25           O  
ATOM    866  CB  VAL   128      18.609 -13.790  50.830  1.00 31.75           C  
ATOM    867  CG1 VAL   128      18.528 -13.042  52.204  1.00 29.75           C  
ATOM    868  CG2 VAL   128      17.921 -12.997  49.697  1.00 31.26           C  
ATOM    869  N   ARG   129      21.703 -13.883  52.120  1.00 33.61           N  
ATOM    870  CA  ARG   129      22.571 -14.297  53.224  1.00 34.50           C  
ATOM    871  C   ARG   129      22.190 -13.526  54.517  1.00 33.26           C  
ATOM    872  O   ARG   129      22.449 -14.013  55.628  1.00 31.75           O  
ATOM    873  CB  ARG   129      24.020 -14.099  52.754  1.00 34.29           C  
ATOM    874  CG  ARG   129      25.129 -13.916  53.775  1.00 38.31           C  
ATOM    875  CD  ARG   129      26.523 -13.891  53.047  1.00 39.42           C  
ATOM    876  NE  ARG   129      27.659 -14.088  53.967  1.00 47.11           N  
ATOM    877  CZ  ARG   129      28.008 -15.243  54.525  1.00 49.62           C  
ATOM    878  NH1 ARG   129      27.337 -16.369  54.268  1.00 50.69           N  
ATOM    879  NH2 ARG   129      29.054 -15.275  55.355  1.00 51.11           N  
ATOM    880  N   HIS   130      21.511 -12.368  54.374  1.00 30.80           N  
ATOM    881  CA  HIS   130      21.094 -11.577  55.517  1.00 31.25           C  
ATOM    882  C   HIS   130      19.719 -10.986  55.327  1.00 30.28           C  
ATOM    883  O   HIS   130      19.342 -10.647  54.211  1.00 28.51           O  
ATOM    884  CB  HIS   130      22.004 -10.376  55.683  1.00 32.90           C  
ATOM    885  CG  HIS   130      23.360 -10.734  56.175  1.00 37.29           C  
ATOM    886  ND1 HIS   130      24.436 -10.876  55.325  1.00 42.12           N  
ATOM    887  CD2 HIS   130      23.804 -11.039  57.417  1.00 39.12           C  
ATOM    888  CE1 HIS   130      25.495 -11.229  56.029  1.00 42.47           C  
ATOM    889  NE2 HIS   130      25.139 -11.327  57.299  1.00 42.86           N  
ATOM    890  N   LEU   131      19.027 -10.768  56.433  1.00 28.68           N  
ATOM    891  CA  LEU   131      17.730 -10.086  56.376  1.00 30.58           C  
ATOM    892  C   LEU   131      17.863  -8.857  57.285  1.00 30.29           C  
ATOM    893  O   LEU   131      18.392  -8.977  58.378  1.00 31.90           O  
ATOM    894  CB  LEU   131      16.603 -11.001  56.824  1.00 31.30           C  
ATOM    895  CG  LEU   131      15.193 -10.402  56.770  1.00 34.58           C  
ATOM    896  CD1 LEU   131      14.236 -11.562  56.595  1.00 38.29           C  
ATOM    897  CD2 LEU   131      14.859  -9.562  57.986  1.00 38.57           C  
ATOM    898  N   GLU   132      17.433  -7.691  56.814  1.00 29.02           N  
ATOM    899  CA  GLU   132      17.503  -6.440  57.574  1.00 30.40           C  
ATOM    900  C   GLU   132      16.100  -5.852  57.721  1.00 30.46           C  
ATOM    901  O   GLU   132      15.280  -5.997  56.828  1.00 28.94           O  
ATOM    902  CB  GLU   132      18.375  -5.429  56.802  1.00 29.23           C  
ATOM    903  CG  GLU   132      19.815  -5.591  57.140  1.00 33.74           C  
ATOM    904  CD  GLU   132      20.795  -4.628  56.468  1.00 34.50           C  
ATOM    905  OE1 GLU   132      20.442  -3.536  55.953  1.00 40.50           O  
ATOM    906  OE2 GLU   132      21.979  -4.995  56.487  1.00 38.28           O  
ATOM    907  N   THR   133      15.822  -5.176  58.823  1.00 29.70           N  
ATOM    908  CA  THR   133      14.547  -4.553  58.981  1.00 30.29           C  
ATOM    909  C   THR   133      14.759  -3.544  60.107  1.00 30.59           C  
ATOM    910  O   THR   133      15.825  -3.540  60.727  1.00 30.37           O  
ATOM    911  CB  THR   133      13.463  -5.580  59.356  1.00 31.81           C  
ATOM    912  OG1 THR   133      12.165  -4.978  59.174  1.00 33.20           O  
ATOM    913  CG2 THR   133      13.596  -6.020  60.852  1.00 30.50           C  
ATOM    914  N   THR   134      13.773  -2.722  60.405  1.00 29.32           N  
ATOM    915  CA  THR   134      13.925  -1.880  61.595  1.00 29.75           C  
ATOM    916  C   THR   134      12.775  -2.087  62.577  1.00 29.78           C  
ATOM    917  O   THR   134      11.649  -2.566  62.189  1.00 29.62           O  
ATOM    918  CB  THR   134      14.048  -0.386  61.285  1.00 29.80           C  
ATOM    919  OG1 THR   134      12.767   0.088  60.851  1.00 31.78           O  
ATOM    920  CG2 THR   134      15.133  -0.096  60.202  1.00 30.43           C  
ATOM    921  N   VAL   135      13.073  -1.808  63.835  1.00 30.68           N  
ATOM    922  CA  VAL   135      12.136  -2.013  64.924  1.00 31.53           C  
ATOM    923  C   VAL   135      12.207  -0.818  65.831  1.00 31.82           C  
ATOM    924  O   VAL   135      13.276  -0.305  66.041  1.00 33.90           O  
ATOM    925  CB  VAL   135      12.451  -3.297  65.752  1.00 32.28           C  
ATOM    926  CG1 VAL   135      12.003  -4.557  65.000  1.00 33.93           C  
ATOM    927  CG2 VAL   135      13.919  -3.376  66.200  1.00 33.14           C  
ATOM    928  N   GLY   136      11.088  -0.388  66.412  1.00 33.08           N  
ATOM    929  CA  GLY   136      11.112   0.672  67.420  1.00 34.31           C  
ATOM    930  C   GLY   136      11.590   0.146  68.774  1.00 37.82           C  
ATOM    931  O   GLY   136      11.728  -1.077  68.948  1.00 35.54           O  
ATOM    932  N   PRO   137      11.823   1.064  69.741  1.00 40.57           N  
ATOM    933  CA  PRO   137      12.259   0.716  71.087  1.00 43.55           C  
ATOM    934  C   PRO   137      11.419  -0.339  71.792  1.00 44.62           C  
ATOM    935  O   PRO   137      11.989  -1.224  72.359  1.00 47.20           O  
ATOM    936  CB  PRO   137      12.247   2.059  71.851  1.00 44.14           C  
ATOM    937  CG  PRO   137      11.493   3.033  70.961  1.00 44.40           C  
ATOM    938  CD  PRO   137      11.681   2.523  69.562  1.00 41.56           C  
ATOM    939  N   ASP   138      10.098  -0.287  71.737  1.00 45.76           N  
ATOM    940  CA  ASP   138       9.280  -1.184  72.560  1.00 47.26           C  
ATOM    941  C   ASP   138       8.750  -2.370  71.813  1.00 45.93           C  
ATOM    942  O   ASP   138       7.962  -3.132  72.367  1.00 47.05           O  
ATOM    943  CB  ASP   138       8.013  -0.473  73.063  1.00 49.09           C  
ATOM    944  CG  ASP   138       8.296   0.838  73.789  1.00 53.31           C  
ATOM    945  OD1 ASP   138       9.295   0.909  74.555  1.00 57.05           O  
ATOM    946  OD2 ASP   138       7.484   1.788  73.575  1.00 59.42           O  
ATOM    947  N   ASN   139       9.106  -2.512  70.547  1.00 44.09           N  
ATOM    948  CA  ASN   139       8.455  -3.495  69.723  1.00 42.64           C  
ATOM    949  C   ASN   139       9.029  -4.890  69.965  1.00 40.57           C  
ATOM    950  O   ASN   139       9.709  -5.465  69.104  1.00 38.07           O  
ATOM    951  CB  ASN   139       8.536  -3.075  68.249  1.00 44.42           C  
ATOM    952  CG  ASN   139       7.828  -1.734  67.997  1.00 50.18           C  
ATOM    953  OD1 ASN   139       6.601  -1.663  67.959  1.00 55.95           O  
ATOM    954  ND2 ASN   139       8.601  -0.669  67.886  1.00 52.75           N  
ATOM    955  N   GLN   140       8.770  -5.427  71.157  1.00 38.57           N  
ATOM    956  CA  GLN   140       9.317  -6.737  71.524  1.00 36.96           C  
ATOM    957  C   GLN   140       8.782  -7.919  70.740  1.00 36.24           C  
ATOM    958  O   GLN   140       9.547  -8.850  70.411  1.00 35.42           O  
ATOM    959  CB  GLN   140       9.170  -6.984  73.020  1.00 37.67           C  
ATOM    960  CG  GLN   140       9.872  -5.933  73.868  1.00 41.31           C  
ATOM    961  CD  GLN   140      11.348  -5.776  73.538  1.00 47.33           C  
ATOM    962  OE1 GLN   140      12.036  -6.742  73.198  1.00 48.80           O  
ATOM    963  NE2 GLN   140      11.843  -4.553  73.647  1.00 52.39           N  
ATOM    964  N   ALA   141       7.476  -7.922  70.466  1.00 34.86           N  
ATOM    965  CA  ALA   141       6.894  -9.001  69.703  1.00 34.59           C  
ATOM    966  C   ALA   141       7.500  -9.065  68.306  1.00 35.03           C  
ATOM    967  O   ALA   141       7.748 -10.157  67.773  1.00 35.37           O  
ATOM    968  CB  ALA   141       5.369  -8.880  69.626  1.00 34.68           C  
ATOM    969  N   SER   142       7.753  -7.896  67.722  0.50 35.08           N  
ATOM    971  CA  SER   142       8.337  -7.845  66.381  0.50 34.34           C  
ATOM    973  C   SER   142       9.761  -8.407  66.367  0.50 33.61           C  
ATOM    975  O   SER   142      10.140  -9.132  65.447  0.50 33.91           O  
ATOM    977  CB  SER   142       8.301  -6.414  65.855  0.50 35.14           C  
ATOM    979  OG  SER   142       6.986  -6.105  65.402  0.50 36.83           O  
ATOM    981  N   ARG   143      10.526  -8.107  67.413  1.00 31.92           N  
ATOM    982  CA  ARG   143      11.840  -8.706  67.630  1.00 31.65           C  
ATOM    983  C   ARG   143      11.748 -10.221  67.764  1.00 32.62           C  
ATOM    984  O   ARG   143      12.627 -10.946  67.266  1.00 32.96           O  
ATOM    985  CB  ARG   143      12.555  -8.124  68.855  1.00 31.41           C  
ATOM    986  CG  ARG   143      13.047  -6.696  68.682  1.00 32.38           C  
ATOM    987  CD  ARG   143      13.612  -6.157  70.038  1.00 32.63           C  
ATOM    988  NE  ARG   143      14.354  -4.913  69.907  1.00 33.59           N  
ATOM    989  CZ  ARG   143      13.778  -3.725  69.807  1.00 35.37           C  
ATOM    990  NH1 ARG   143      12.448  -3.613  69.825  1.00 37.45           N  
ATOM    991  NH2 ARG   143      14.531  -2.635  69.695  1.00 38.94           N  
ATOM    992  N   ARG   144      10.694 -10.723  68.420  1.00 31.43           N  
ATOM    993  CA  ARG   144      10.651 -12.163  68.629  1.00 32.29           C  
ATOM    994  C   ARG   144      10.417 -12.893  67.308  1.00 32.97           C  
ATOM    995  O   ARG   144      10.955 -14.015  67.109  1.00 33.70           O  
ATOM    996  CB  ARG   144       9.572 -12.557  69.639  1.00 31.24           C  
ATOM    997  CG  ARG   144      10.041 -12.372  71.087  1.00 31.57           C  
ATOM    998  CD  ARG   144       8.994 -12.898  72.057  1.00 28.92           C  
ATOM    999  NE  ARG   144       7.775 -12.083  72.146  1.00 28.45           N  
ATOM   1000  CZ  ARG   144       7.636 -11.051  73.015  1.00 30.97           C  
ATOM   1001  NH1 ARG   144       8.657 -10.638  73.761  1.00 26.80           N  
ATOM   1002  NH2 ARG   144       6.491 -10.370  73.084  1.00 31.80           N  
ATOM   1003  N   THR   145       9.584 -12.294  66.468  1.00 34.26           N  
ATOM   1004  CA  THR   145       9.315 -12.813  65.108  1.00 37.29           C  
ATOM   1005  C   THR   145      10.660 -12.968  64.373  1.00 37.57           C  
ATOM   1006  O   THR   145      10.990 -14.082  63.937  1.00 36.19           O  
ATOM   1007  CB  THR   145       8.327 -11.943  64.295  1.00 38.03           C  
ATOM   1008  OG1 THR   145       7.046 -11.895  64.937  1.00 38.10           O  
ATOM   1009  CG2 THR   145       8.122 -12.501  62.876  1.00 40.32           C  
ATOM   1010  N   PHE   146      11.463 -11.885  64.308  1.00 37.24           N  
ATOM   1011  CA  PHE   146      12.752 -11.978  63.623  1.00 37.68           C  
ATOM   1012  C   PHE   146      13.739 -12.936  64.331  1.00 39.16           C  
ATOM   1013  O   PHE   146      14.432 -13.733  63.664  1.00 39.77           O  
ATOM   1014  CB  PHE   146      13.302 -10.578  63.240  1.00 38.74           C  
ATOM   1015  CG  PHE   146      12.430  -9.849  62.233  1.00 39.23           C  
ATOM   1016  CD1 PHE   146      12.570 -10.073  60.850  1.00 39.66           C  
ATOM   1017  CD2 PHE   146      11.449  -8.940  62.656  1.00 42.53           C  
ATOM   1018  CE1 PHE   146      11.738  -9.415  59.926  1.00 38.69           C  
ATOM   1019  CE2 PHE   146      10.597  -8.257  61.718  1.00 43.57           C  
ATOM   1020  CZ  PHE   146      10.747  -8.510  60.370  1.00 40.97           C  
ATOM   1021  N   ALA   147      13.764 -12.949  65.679  1.00 38.85           N  
ATOM   1022  CA  ALA   147      14.573 -13.911  66.405  1.00 38.63           C  
ATOM   1023  C   ALA   147      14.224 -15.352  66.060  1.00 38.95           C  
ATOM   1024  O   ALA   147      15.118 -16.185  65.880  1.00 38.97           O  
ATOM   1025  CB  ALA   147      14.489 -13.680  67.919  1.00 38.76           C  
ATOM   1026  N   GLY   148      12.928 -15.655  65.967  1.00 39.30           N  
ATOM   1027  CA  GLY   148      12.488 -17.021  65.682  1.00 39.91           C  
ATOM   1028  C   GLY   148      12.932 -17.477  64.300  1.00 40.74           C  
ATOM   1029  O   GLY   148      13.386 -18.609  64.101  1.00 40.27           O  
ATOM   1030  N   LEU   149      12.802 -16.576  63.352  1.00 40.77           N  
ATOM   1031  CA  LEU   149      13.279 -16.775  62.000  1.00 42.52           C  
ATOM   1032  C   LEU   149      14.793 -17.093  61.926  1.00 42.40           C  
ATOM   1033  O   LEU   149      15.224 -18.004  61.197  1.00 42.72           O  
ATOM   1034  CB  LEU   149      12.971 -15.477  61.243  1.00 41.25           C  
ATOM   1035  CG  LEU   149      12.249 -15.544  59.913  1.00 45.60           C  
ATOM   1036  CD1 LEU   149      11.035 -16.491  59.949  1.00 46.26           C  
ATOM   1037  CD2 LEU   149      11.867 -14.133  59.476  1.00 44.81           C  
ATOM   1038  N   ALA   150      15.591 -16.342  62.677  1.00 42.19           N  
ATOM   1039  CA  ALA   150      17.027 -16.561  62.728  1.00 43.17           C  
ATOM   1040  C   ALA   150      17.367 -17.948  63.296  1.00 44.25           C  
ATOM   1041  O   ALA   150      18.196 -18.677  62.725  1.00 43.93           O  
ATOM   1042  CB  ALA   150      17.687 -15.476  63.536  1.00 43.07           C  
ATOM   1043  N   GLY   151      16.717 -18.312  64.406  1.00 44.73           N  
ATOM   1044  CA  GLY   151      16.996 -19.584  65.091  1.00 45.94           C  
ATOM   1045  C   GLY   151      16.781 -20.785  64.192  1.00 46.14           C  
ATOM   1046  O   GLY   151      17.593 -21.714  64.200  1.00 46.17           O  
ATOM   1047  N   GLU   152      15.701 -20.749  63.405  0.50 46.44           N  
ATOM   1049  CA  GLU   152      15.355 -21.825  62.469  0.50 46.93           C  
ATOM   1051  C   GLU   152      16.289 -21.885  61.233  0.50 47.32           C  
ATOM   1053  O   GLU   152      16.139 -22.769  60.383  0.50 47.10           O  
ATOM   1055  CB  GLU   152      13.879 -21.719  62.035  0.50 46.85           C  
ATOM   1057  CG  GLU   152      12.833 -21.820  63.174  0.50 47.47           C  
ATOM   1059  CD  GLU   152      12.321 -23.254  63.454  0.50 46.92           C  
ATOM   1061  OE1 GLU   152      11.216 -23.391  64.027  0.50 47.24           O  
ATOM   1063  OE2 GLU   152      13.006 -24.237  63.108  0.50 47.10           O  
ATOM   1065  N   ARG   153      17.248 -20.959  61.149  1.00 47.16           N  
ATOM   1066  CA  ARG   153      18.238 -20.930  60.064  1.00 47.60           C  
ATOM   1067  C   ARG   153      19.696 -20.929  60.567  1.00 47.56           C  
ATOM   1068  O   ARG   153      20.636 -20.710  59.783  1.00 48.14           O  
ATOM   1069  CB  ARG   153      17.994 -19.698  59.171  1.00 47.52           C  
ATOM   1070  CG  ARG   153      16.832 -19.877  58.197  1.00 47.85           C  
ATOM   1071  CD  ARG   153      16.214 -18.546  57.703  1.00 48.25           C  
ATOM   1072  NE  ARG   153      15.011 -18.827  56.914  1.00 48.66           N  
ATOM   1073  CZ  ARG   153      13.786 -19.002  57.423  1.00 50.44           C  
ATOM   1074  NH1 ARG   153      12.772 -19.304  56.615  1.00 48.73           N  
ATOM   1075  NH2 ARG   153      13.577 -18.905  58.745  1.00 50.45           N  
ATOM   1076  N   GLY   154      19.888 -21.146  61.865  1.00 46.80           N  
ATOM   1077  CA  GLY   154      21.227 -21.054  62.453  1.00 46.10           C  
ATOM   1078  C   GLY   154      21.881 -19.697  62.200  1.00 45.54           C  
ATOM   1079  O   GLY   154      23.097 -19.614  61.997  1.00 45.73           O  
ATOM   1080  N   ALA   155      21.076 -18.632  62.207  1.00 44.29           N  
ATOM   1081  CA  ALA   155      21.590 -17.269  62.026  1.00 43.19           C  
ATOM   1082  C   ALA   155      21.630 -16.459  63.328  1.00 42.59           C  
ATOM   1083  O   ALA   155      20.902 -16.748  64.267  1.00 43.85           O  
ATOM   1084  CB  ALA   155      20.762 -16.521  60.950  1.00 42.77           C  
ATOM   1085  N   HIS   156      22.501 -15.449  63.335  0.50 41.82           N  
ATOM   1087  CA  HIS   156      22.761 -14.490  64.420  0.50 40.83           C  
ATOM   1089  C   HIS   156      21.740 -13.329  64.284  0.50 40.45           C  
ATOM   1091  O   HIS   156      21.246 -13.088  63.189  0.50 38.80           O  
ATOM   1093  CB  HIS   156      24.227 -14.018  64.216  0.50 40.32           C  
ATOM   1095  CG  HIS   156      24.685 -12.891  65.096  0.50 40.80           C  
ATOM   1097  ND1 HIS   156      24.791 -12.995  66.470  0.50 41.92           N  
ATOM   1099  CD2 HIS   156      25.161 -11.661  64.780  0.50 40.16           C  
ATOM   1101  CE1 HIS   156      25.266 -11.864  66.964  0.50 40.20           C  
ATOM   1103  NE2 HIS   156      25.494 -11.037  65.959  0.50 41.31           N  
ATOM   1105  N   VAL   157      21.385 -12.669  65.389  1.00 40.08           N  
ATOM   1106  CA  VAL   157      20.584 -11.453  65.329  1.00 39.34           C  
ATOM   1107  C   VAL   157      21.385 -10.336  65.956  1.00 38.99           C  
ATOM   1108  O   VAL   157      21.916 -10.490  67.053  1.00 39.41           O  
ATOM   1109  CB  VAL   157      19.272 -11.588  66.093  1.00 40.01           C  
ATOM   1110  CG1 VAL   157      18.442 -10.368  65.866  1.00 38.44           C  
ATOM   1111  CG2 VAL   157      18.469 -12.773  65.588  1.00 41.70           C  
ATOM   1112  N   SER   158      21.497  -9.210  65.278  1.00 37.66           N  
ATOM   1113  CA  SER   158      22.118  -8.062  65.903  1.00 37.51           C  
ATOM   1114  C   SER   158      21.220  -6.839  65.790  1.00 37.11           C  
ATOM   1115  O   SER   158      20.403  -6.749  64.868  1.00 35.42           O  
ATOM   1116  CB  SER   158      23.514  -7.814  65.319  1.00 37.80           C  
ATOM   1117  OG  SER   158      23.502  -6.927  64.215  1.00 43.14           O  
ATOM   1118  N   GLU   159      21.370  -5.902  66.724  1.00 35.91           N  
ATOM   1119  CA  GLU   159      20.530  -4.736  66.732  1.00 36.42           C  
ATOM   1120  C   GLU   159      21.415  -3.544  66.988  1.00 34.94           C  
ATOM   1121  O   GLU   159      22.213  -3.582  67.909  1.00 33.52           O  
ATOM   1122  CB  GLU   159      19.492  -4.883  67.838  1.00 35.95           C  
ATOM   1123  CG  GLU   159      18.476  -3.762  67.893  1.00 39.12           C  
ATOM   1124  CD  GLU   159      17.394  -4.025  68.950  1.00 42.73           C  
ATOM   1125  OE1 GLU   159      16.918  -3.023  69.542  1.00 49.54           O  
ATOM   1126  OE2 GLU   159      17.048  -5.223  69.197  1.00 45.45           O  
ATOM   1127  N   GLN   160      21.300  -2.498  66.174  1.00 33.51           N  
ATOM   1128  CA  GLN   160      22.129  -1.308  66.323  1.00 32.97           C  
ATOM   1129  C   GLN   160      21.274  -0.043  66.169  1.00 33.12           C  
ATOM   1130  O   GLN   160      20.273  -0.044  65.433  1.00 32.75           O  
ATOM   1131  CB  GLN   160      23.248  -1.311  65.271  1.00 33.04           C  
ATOM   1132  CG  GLN   160      24.268  -2.415  65.435  1.00 35.30           C  
ATOM   1133  CD  GLN   160      25.120  -2.256  66.717  1.00 37.92           C  
ATOM   1134  OE1 GLN   160      25.161  -1.165  67.310  1.00 36.23           O  
ATOM   1135  NE2 GLN   160      25.796  -3.344  67.148  1.00 38.98           N  
ATOM   1136  N   PRO   161      21.606   1.025  66.901  1.00 32.36           N  
ATOM   1137  CA  PRO   161      20.919   2.277  66.610  1.00 32.50           C  
ATOM   1138  C   PRO   161      21.023   2.619  65.109  1.00 31.78           C  
ATOM   1139  O   PRO   161      22.044   2.315  64.475  1.00 31.34           O  
ATOM   1140  CB  PRO   161      21.724   3.316  67.388  1.00 32.06           C  
ATOM   1141  CG  PRO   161      22.849   2.550  68.007  1.00 36.00           C  
ATOM   1142  CD  PRO   161      22.550   1.145  68.017  1.00 33.45           C  
ATOM   1143  N   PHE   162      20.003   3.270  64.573  1.00 31.89           N  
ATOM   1144  CA  PHE   162      19.940   3.495  63.129  1.00 30.24           C  
ATOM   1145  C   PHE   162      19.232   4.813  62.816  1.00 30.82           C  
ATOM   1146  O   PHE   162      19.915   5.806  62.484  1.00 31.00           O  
ATOM   1147  CB  PHE   162      19.272   2.276  62.542  1.00 30.99           C  
ATOM   1148  CG  PHE   162      19.224   2.214  61.055  1.00 30.24           C  
ATOM   1149  CD1 PHE   162      20.389   2.274  60.263  1.00 28.98           C  
ATOM   1150  CD2 PHE   162      17.983   1.984  60.440  1.00 30.26           C  
ATOM   1151  CE1 PHE   162      20.299   2.149  58.846  1.00 32.52           C  
ATOM   1152  CE2 PHE   162      17.890   1.837  59.035  1.00 32.42           C  
ATOM   1153  CZ  PHE   162      19.025   1.958  58.233  1.00 29.09           C  
ATOM   1154  N   PHE   163      17.894   4.858  62.874  1.00 28.61           N  
ATOM   1155  CA  PHE   163      17.216   6.123  62.681  1.00 29.80           C  
ATOM   1156  C   PHE   163      16.861   6.665  64.027  1.00 31.94           C  
ATOM   1157  O   PHE   163      16.108   6.009  64.760  1.00 33.39           O  
ATOM   1158  CB  PHE   163      15.921   5.975  61.881  1.00 29.85           C  
ATOM   1159  CG  PHE   163      16.105   5.525  60.438  1.00 26.07           C  
ATOM   1160  CD1 PHE   163      17.286   5.772  59.749  1.00 28.93           C  
ATOM   1161  CD2 PHE   163      15.046   4.906  59.759  1.00 31.95           C  
ATOM   1162  CE1 PHE   163      17.419   5.374  58.366  1.00 31.02           C  
ATOM   1163  CE2 PHE   163      15.150   4.512  58.405  1.00 32.60           C  
ATOM   1164  CZ  PHE   163      16.346   4.772  57.696  1.00 28.90           C  
ATOM   1165  N   ASP   164      17.352   7.854  64.342  1.00 31.19           N  
ATOM   1166  CA  ASP   164      17.091   8.439  65.643  1.00 32.55           C  
ATOM   1167  C   ASP   164      16.350   9.756  65.423  1.00 32.90           C  
ATOM   1168  O   ASP   164      15.909  10.020  64.310  1.00 32.06           O  
ATOM   1169  CB  ASP   164      18.427   8.665  66.335  1.00 34.33           C  
ATOM   1170  CG  ASP   164      19.381   9.524  65.519  1.00 36.82           C  
ATOM   1171  OD1 ASP   164      19.152   9.795  64.293  1.00 39.67           O  
ATOM   1172  OD2 ASP   164      20.402   9.915  66.102  1.00 40.59           O  
ATOM   1173  N   ARG   165      16.294  10.606  66.446  0.50 32.78           N  
ATOM   1175  CA  ARG   165      15.758  11.965  66.319  0.50 34.06           C  
ATOM   1177  C   ARG   165      16.393  12.800  65.194  0.50 32.76           C  
ATOM   1179  O   ARG   165      15.704  13.566  64.520  0.50 32.30           O  
ATOM   1181  CB  ARG   165      15.901  12.736  67.641  0.50 34.03           C  
ATOM   1183  CG  ARG   165      15.044  12.164  68.769  0.50 36.68           C  
ATOM   1185  CD  ARG   165      15.423  12.757  70.129  0.50 37.46           C  
ATOM   1187  NE  ARG   165      14.971  11.910  71.232  0.50 45.30           N  
ATOM   1189  CZ  ARG   165      13.725  11.880  71.709  0.50 48.57           C  
ATOM   1191  NH1 ARG   165      12.779  12.653  71.185  0.50 49.96           N  
ATOM   1193  NH2 ARG   165      13.418  11.076  72.724  0.50 50.43           N  
ATOM   1195  N   GLN   166      17.705  12.665  65.013  0.50 32.09           N  
ATOM   1197  CA  GLN   166      18.420  13.390  63.970  0.50 32.57           C  
ATOM   1199  C   GLN   166      17.857  13.029  62.587  0.50 31.31           C  
ATOM   1201  O   GLN   166      17.595  13.900  61.753  0.50 30.00           O  
ATOM   1203  CB  GLN   166      19.937  13.085  64.055  0.50 32.57           C  
ATOM   1205  CG  GLN   166      20.852  14.026  63.233  0.50 35.47           C  
ATOM   1207  CD  GLN   166      22.346  13.744  63.411  0.50 34.84           C  
ATOM   1209  OE1 GLN   166      22.732  12.898  64.208  0.50 39.56           O  
ATOM   1211  NE2 GLN   166      23.196  14.478  62.674  0.50 38.77           N  
ATOM   1213  N   ALA   167      17.655  11.730  62.373  1.00 29.22           N  
ATOM   1214  CA  ALA   167      17.225  11.213  61.086  1.00 29.75           C  
ATOM   1215  C   ALA   167      15.766  11.616  60.777  1.00 30.76           C  
ATOM   1216  O   ALA   167      15.435  11.877  59.597  1.00 30.39           O  
ATOM   1217  CB  ALA   167      17.364   9.704  61.039  1.00 26.49           C  
ATOM   1218  N   PHE   168      14.932  11.722  61.825  1.00 31.57           N  
ATOM   1219  CA  PHE   168      13.517  12.164  61.650  1.00 31.96           C  
ATOM   1220  C   PHE   168      13.286  13.649  61.710  1.00 32.21           C  
ATOM   1221  O   PHE   168      12.132  14.096  61.604  1.00 32.92           O  
ATOM   1222  CB  PHE   168      12.567  11.443  62.628  1.00 32.43           C  
ATOM   1223  CG  PHE   168      12.409   9.972  62.360  1.00 30.95           C  
ATOM   1224  CD1 PHE   168      11.533   9.522  61.333  1.00 32.26           C  
ATOM   1225  CD2 PHE   168      13.056   9.016  63.156  1.00 32.42           C  
ATOM   1226  CE1 PHE   168      11.319   8.144  61.074  1.00 36.05           C  
ATOM   1227  CE2 PHE   168      12.908   7.664  62.895  1.00 32.07           C  
ATOM   1228  CZ  PHE   168      12.022   7.185  61.874  1.00 35.67           C  
ATOM   1229  N   GLY   169      14.352  14.404  61.892  1.00 32.25           N  
ATOM   1230  CA  GLY   169      14.264  15.872  61.966  1.00 33.51           C  
ATOM   1231  C   GLY   169      13.387  16.346  63.107  1.00 34.34           C  
ATOM   1232  O   GLY   169      12.765  17.414  63.027  1.00 35.41           O  
ATOM   1233  N   GLY   170      13.346  15.586  64.194  1.00 34.82           N  
ATOM   1234  CA  GLY   170      12.547  16.003  65.347  1.00 35.27           C  
ATOM   1235  C   GLY   170      11.069  15.686  65.189  1.00 36.51           C  
ATOM   1236  O   GLY   170      10.260  16.126  65.986  1.00 36.64           O  
ATOM   1237  N   ALA   171      10.690  14.878  64.198  1.00 36.02           N  
ATOM   1238  CA  ALA   171       9.277  14.629  63.983  1.00 36.89           C  
ATOM   1239  C   ALA   171       8.800  13.708  65.085  1.00 37.83           C  
ATOM   1240  O   ALA   171       9.600  13.065  65.742  1.00 37.14           O  
ATOM   1241  CB  ALA   171       9.049  13.995  62.607  1.00 36.67           C  
ATOM   1242  N   ASP   172       7.500  13.666  65.306  1.00 38.13           N  
ATOM   1243  CA  ASP   172       6.938  12.813  66.339  1.00 40.54           C  
ATOM   1244  C   ASP   172       6.880  11.360  65.838  1.00 40.03           C  
ATOM   1245  O   ASP   172       5.830  10.862  65.401  1.00 42.18           O  
ATOM   1246  CB  ASP   172       5.554  13.370  66.698  1.00 41.76           C  
ATOM   1247  CG  ASP   172       4.963  12.759  67.940  1.00 47.72           C  
ATOM   1248  OD1 ASP   172       5.517  11.772  68.502  1.00 53.08           O  
ATOM   1249  OD2 ASP   172       3.897  13.283  68.346  1.00 52.54           O  
ATOM   1250  N   HIS   173       8.025  10.685  65.886  1.00 39.06           N  
ATOM   1251  CA  HIS   173       8.141   9.284  65.445  1.00 37.69           C  
ATOM   1252  C   HIS   173       9.146   8.602  66.377  1.00 37.60           C  
ATOM   1253  O   HIS   173      10.154   9.177  66.733  1.00 35.55           O  
ATOM   1254  CB  HIS   173       8.600   9.248  63.971  1.00 37.68           C  
ATOM   1255  CG  HIS   173       8.488   7.899  63.311  1.00 37.73           C  
ATOM   1256  ND1 HIS   173       9.241   6.819  63.703  1.00 35.65           N  
ATOM   1257  CD2 HIS   173       7.738   7.465  62.259  1.00 41.18           C  
ATOM   1258  CE1 HIS   173       8.964   5.770  62.946  1.00 38.16           C  
ATOM   1259  NE2 HIS   173       8.058   6.138  62.051  1.00 38.08           N  
ATOM   1260  N   ASP   174       8.855   7.380  66.815  1.00 37.19           N  
ATOM   1261  CA  ASP   174       9.824   6.644  67.620  1.00 38.31           C  
ATOM   1262  C   ASP   174      11.102   6.420  66.793  1.00 37.14           C  
ATOM   1263  O   ASP   174      11.037   6.391  65.529  1.00 36.72           O  
ATOM   1264  CB  ASP   174       9.252   5.268  67.946  1.00 38.70           C  
ATOM   1265  CG  ASP   174       8.113   5.326  68.967  1.00 43.22           C  
ATOM   1266  OD1 ASP   174       7.968   6.363  69.667  1.00 49.01           O  
ATOM   1267  OD2 ASP   174       7.365   4.322  69.053  1.00 48.72           O  
ATOM   1268  N   ASP   175      12.224   6.231  67.498  1.00 35.40           N  
ATOM   1269  CA  ASP   175      13.470   5.768  66.899  1.00 35.45           C  
ATOM   1270  C   ASP   175      13.234   4.411  66.236  1.00 35.34           C  
ATOM   1271  O   ASP   175      12.388   3.662  66.702  1.00 35.17           O  
ATOM   1272  CB  ASP   175      14.488   5.573  68.019  1.00 36.20           C  
ATOM   1273  CG  ASP   175      15.088   6.880  68.517  1.00 39.50           C  
ATOM   1274  OD1 ASP   175      14.721   7.973  68.005  1.00 42.16           O  
ATOM   1275  OD2 ASP   175      15.945   6.817  69.437  1.00 44.59           O  
ATOM   1276  N   GLU   176      13.974   4.097  65.169  1.00 34.71           N  
ATOM   1277  CA  GLU   176      13.918   2.790  64.532  1.00 34.11           C  
ATOM   1278  C   GLU   176      15.312   2.186  64.542  1.00 34.73           C  
ATOM   1279  O   GLU   176      16.201   2.707  63.842  1.00 34.95           O  
ATOM   1280  CB  GLU   176      13.455   2.947  63.092  1.00 36.01           C  
ATOM   1281  CG  GLU   176      12.018   3.477  62.968  1.00 36.75           C  
ATOM   1282  CD  GLU   176      10.973   2.356  62.998  1.00 43.16           C  
ATOM   1283  OE1 GLU   176      11.257   1.132  62.730  1.00 39.93           O  
ATOM   1284  OE2 GLU   176       9.810   2.716  63.302  1.00 46.24           O  
ATOM   1285  N   MET   177      15.512   1.111  65.317  1.00 31.93           N  
ATOM   1286  CA  MET   177      16.797   0.443  65.330  1.00 31.94           C  
ATOM   1287  C   MET   177      16.938  -0.556  64.163  1.00 30.52           C  
ATOM   1288  O   MET   177      15.936  -1.086  63.707  1.00 30.12           O  
ATOM   1289  CB  MET   177      16.979  -0.263  66.671  1.00 31.47           C  
ATOM   1290  CG  MET   177      17.307   0.851  67.772  1.00 41.15           C  
ATOM   1291  SD  MET   177      15.602   1.584  68.381  0.45 55.77          SE  
ATOM   1292  CE  MET   177      14.945  -0.016  69.226  1.00 53.35           C  
ATOM   1293  N   LEU   178      18.175  -0.839  63.763  1.00 29.29           N  
ATOM   1294  CA  LEU   178      18.412  -1.735  62.649  1.00 31.28           C  
ATOM   1295  C   LEU   178      18.555  -3.141  63.183  1.00 31.35           C  
ATOM   1296  O   LEU   178      19.461  -3.432  63.988  1.00 31.95           O  
ATOM   1297  CB  LEU   178      19.677  -1.333  61.878  1.00 29.10           C  
ATOM   1298  CG  LEU   178      20.030  -2.319  60.745  1.00 31.33           C  
ATOM   1299  CD1 LEU   178      19.027  -2.317  59.590  1.00 30.10           C  
ATOM   1300  CD2 LEU   178      21.475  -2.062  60.250  1.00 32.35           C  
ATOM   1301  N   LEU   179      17.674  -4.029  62.740  1.00 31.88           N  
ATOM   1302  CA  LEU   179      17.747  -5.419  63.141  1.00 32.27           C  
ATOM   1303  C   LEU   179      18.293  -6.247  61.948  1.00 33.22           C  
ATOM   1304  O   LEU   179      17.807  -6.154  60.821  1.00 32.35           O  
ATOM   1305  CB  LEU   179      16.344  -5.872  63.607  1.00 32.02           C  
ATOM   1306  CG  LEU   179      16.040  -7.172  64.339  1.00 35.18           C  
ATOM   1307  CD1 LEU   179      16.660  -7.096  65.763  1.00 40.95           C  
ATOM   1308  CD2 LEU   179      14.507  -7.435  64.480  1.00 34.77           C  
ATOM   1309  N   ARG   180      19.346  -7.019  62.178  1.00 33.14           N  
ATOM   1310  CA  ARG   180      20.028  -7.723  61.105  1.00 34.71           C  
ATOM   1311  C   ARG   180      20.229  -9.188  61.439  1.00 35.46           C  
ATOM   1312  O   ARG   180      20.797  -9.507  62.470  1.00 36.70           O  
ATOM   1313  CB  ARG   180      21.379  -7.044  60.829  1.00 35.83           C  
ATOM   1314  CG  ARG   180      22.137  -7.590  59.651  1.00 38.09           C  
ATOM   1315  CD  ARG   180      23.177  -6.555  59.260  1.00 45.27           C  
ATOM   1316  NE  ARG   180      23.881  -6.901  58.027  1.00 51.12           N  
ATOM   1317  CZ  ARG   180      24.988  -7.635  58.000  1.00 52.09           C  
ATOM   1318  NH1 ARG   180      25.496  -8.098  59.141  1.00 57.01           N  
ATOM   1319  NH2 ARG   180      25.593  -7.909  56.849  1.00 52.09           N  
ATOM   1320  N   ILE   181      19.764 -10.084  60.581  1.00 36.10           N  
ATOM   1321  CA  ILE   181      19.804 -11.529  60.866  1.00 36.97           C  
ATOM   1322  C   ILE   181      20.643 -12.178  59.794  1.00 38.09           C  
ATOM   1323  O   ILE   181      20.537 -11.816  58.608  1.00 34.62           O  
ATOM   1324  CB  ILE   181      18.406 -12.111  60.751  1.00 38.27           C  
ATOM   1325  CG1 ILE   181      17.432 -11.440  61.708  1.00 41.03           C  
ATOM   1326  CG2 ILE   181      18.386 -13.584  61.005  1.00 40.84           C  
ATOM   1327  CD1 ILE   181      16.062 -11.386  61.071  1.00 48.15           C  
ATOM   1328  N   GLY   182      21.467 -13.164  60.178  1.00 38.91           N  
ATOM   1329  CA  GLY   182      22.320 -13.810  59.209  1.00 40.40           C  
ATOM   1330  C   GLY   182      23.694 -14.077  59.818  1.00 43.20           C  
ATOM   1331  O   GLY   182      23.909 -13.733  60.989  1.00 43.62           O  
ATOM   1332  N   PRO   183      24.631 -14.667  59.034  1.00 43.54           N  
ATOM   1333  CA  PRO   183      24.429 -15.179  57.666  1.00 43.78           C  
ATOM   1334  C   PRO   183      23.517 -16.414  57.641  1.00 43.68           C  
ATOM   1335  O   PRO   183      23.455 -17.141  58.618  1.00 44.02           O  
ATOM   1336  CB  PRO   183      25.856 -15.531  57.193  1.00 43.95           C  
ATOM   1337  CG  PRO   183      26.655 -15.715  58.435  1.00 45.02           C  
ATOM   1338  CD  PRO   183      26.041 -14.805  59.475  1.00 44.24           C  
ATOM   1339  N   PHE   184      22.762 -16.600  56.565  1.00 43.32           N  
ATOM   1340  CA  PHE   184      22.002 -17.819  56.398  1.00 43.90           C  
ATOM   1341  C   PHE   184      22.979 -18.745  55.698  1.00 45.14           C  
ATOM   1342  O   PHE   184      23.746 -18.269  54.855  1.00 45.26           O  
ATOM   1343  CB  PHE   184      20.768 -17.609  55.532  1.00 43.64           C  
ATOM   1344  CG  PHE   184      19.790 -16.620  56.093  1.00 44.04           C  
ATOM   1345  CD1 PHE   184      19.409 -16.675  57.437  1.00 43.12           C  
ATOM   1346  CD2 PHE   184      19.223 -15.648  55.284  1.00 43.20           C  
ATOM   1347  CE1 PHE   184      18.509 -15.769  57.956  1.00 41.15           C  
ATOM   1348  CE2 PHE   184      18.317 -14.734  55.802  1.00 42.25           C  
ATOM   1349  CZ  PHE   184      17.959 -14.791  57.134  1.00 41.41           C  
END
