
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  179 ( 1415),  selected  179 , name 1ib1_F
# Molecule2: number of CA atoms  159 ( 1259),  selected  159 , name T0417.pdb
# PARAMETERS: 1ib1_F.T0417.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S    18_F      R      26           -
LGA    G    19_F      -       -           -
LGA    I    20_F      -       -           -
LGA    P    21_F      -       -           -
LGA    G    22_F      -       -           -
LGA    S    23_F      -       -           -
LGA    P    24_F      -       -           -
LGA    G    25_F      -       -           -
LGA    R    26_F      -       -           -
LGA    Q    27_F      -       -           -
LGA    R    28_F      -       -           -
LGA    R    29_F      -       -           -
LGA    H    30_F      -       -           -
LGA    X    31_F      -       -           -
LGA    L    32_F      -       -           -
LGA    P    33_F      -       -           -
LGA    A    34_F      -       -           -
LGA    N    35_F      Y      27          3.722
LGA    E    36_F      H      28          2.022
LGA    F    37_F      L      29          1.400
LGA    R    38_F      R      30          0.756
LGA    C    39_F      P      31          0.636
LGA    L    40_F      P      32          0.694
LGA    T    41_F      R      33          1.609
LGA    P    42_F      R      34          2.205
LGA    E    43_F      N      35          1.455
LGA    D    44_F      D      36          0.984
LGA    A    45_F      G      37          1.340
LGA    A    46_F      A      38          1.140
LGA    G    47_F      A      39          1.174
LGA    V    48_F      I      40          1.405
LGA    F    49_F      H      41          1.473
LGA    E    50_F      Q      42          1.013
LGA    I    51_F      L      43          1.599
LGA    E    52_F      V      44          1.403
LGA    R    53_F      S      45          1.215
LGA    E    54_F      E      46          1.828
LGA    A    55_F      C      47          1.145
LGA    F    56_F      P      48          2.634
LGA    I    57_F      P      49          4.931
LGA    S    58_F      -       -           -
LGA    V    59_F      -       -           -
LGA    S    60_F      -       -           -
LGA    G    61_F      -       -           -
LGA    N    62_F      L      50           #
LGA    C    63_F      D      51          0.827
LGA    P    64_F      L      52           #
LGA    L    65_F      N      53          3.209
LGA    N    66_F      S      54          2.716
LGA    L    67_F      L      55          1.603
LGA    D    68_F      Y      56          1.669
LGA    E    69_F      A      57          1.441
LGA    V    70_F      Y      58          1.518
LGA    Q    71_F      L      59          1.431
LGA    H    72_F      L      60          1.549
LGA    F    73_F      L      61          2.185
LGA    L    74_F      C      62          1.974
LGA    T    75_F      E      63          1.388
LGA    L    76_F      H      64          1.595
LGA    C    77_F      H      65          1.744
LGA    P    78_F      A      66          1.113
LGA    E    79_F      H      67          0.561
LGA    L    80_F      T      68          1.085
LGA    S    81_F      C      69          0.458
LGA    L    82_F      V      70          0.861
LGA    G    83_F      V      71          1.266
LGA    W    84_F      A      72          1.349
LGA    F    85_F      E      73          1.321
LGA    V    86_F      S      74          1.477
LGA    E    87_F      P      75          1.001
LGA    -       -      G      76           -
LGA    G    88_F      G      77          2.202
LGA    R    89_F      R      78          1.870
LGA    L    90_F      I      79          1.298
LGA    V    91_F      D      80          1.185
LGA    A    92_F      G      81          0.446
LGA    F    93_F      F      82          0.756
LGA    I    94_F      V      83          0.424
LGA    I    95_F      S      84          0.845
LGA    G    96_F      A      85          1.291
LGA    S    97_F      Y      86          1.759
LGA    L    98_F      L      87          2.086
LGA    W    99_F      L      88          1.690
LGA    D   100_F      -       -           -
LGA    E   101_F      -       -           -
LGA    E   102_F      -       -           -
LGA    R   103_F      -       -           -
LGA    L   104_F      -       -           -
LGA    T   105_F      -       -           -
LGA    Q   106_F      -       -           -
LGA    E   107_F      -       -           -
LGA    S   108_F      -       -           -
LGA    L   109_F      -       -           -
LGA    A   110_F      -       -           -
LGA    L   111_F      -       -           -
LGA    H   112_F      -       -           -
LGA    R   113_F      -       -           -
LGA    P   114_F      P      89          4.229
LGA    R   115_F      T      90          5.616
LGA    G   116_F      R      91          3.424
LGA    H   117_F      P      92          2.020
LGA    -       -      D      93           -
LGA    S   118_F      V      94          1.305
LGA    A   119_F      L      95          1.119
LGA    H   120_F      F      96          1.083
LGA    L   121_F      V      97          0.865
LGA    H   122_F      W      98          0.932
LGA    A   123_F      Q      99          0.536
LGA    L   124_F      V     100          0.444
LGA    A   125_F      A     101          0.819
LGA    V   126_F      V     102          0.686
LGA    H   127_F      H     103          1.226
LGA    R   128_F      S     104          1.284
LGA    S   129_F      R     105          0.384
LGA    F   130_F      A     106          0.556
LGA    R   131_F      R     107          1.398
LGA    Q   132_F      G     108          2.682
LGA    Q   133_F      H     109          2.570
LGA    G   134_F      R     110          1.822
LGA    K   135_F      L     111          2.192
LGA    G   136_F      G     112          2.204
LGA    S   137_F      R     113          2.096
LGA    V   138_F      A     114          1.615
LGA    L   139_F      M     115          1.587
LGA    L   140_F      L     116          2.081
LGA    W   141_F      G     117          2.247
LGA    R   142_F      H     118          2.093
LGA    Y   143_F      I     119          2.298
LGA    L   144_F      L     120          2.492
LGA    H   145_F      E     121          2.220
LGA    H   146_F      R     122          2.607
LGA    V   147_F      Q     123           #
LGA    G   148_F      E     124           #
LGA    A   149_F      C     125          3.644
LGA    Q   150_F      R     126          3.133
LGA    P   151_F      H     127          2.911
LGA    A   152_F      -       -           -
LGA    V   153_F      V     128          2.460
LGA    R   154_F      R     129          2.037
LGA    R   155_F      H     130          1.376
LGA    A   156_F      L     131          1.155
LGA    V   157_F      E     132          0.883
LGA    L   158_F      T     133          0.617
LGA    M   159_F      T     134          0.527
LGA    C   160_F      V     135          1.411
LGA    E   161_F      G     136          1.509
LGA    D   162_F      P     137          2.732
LGA    A   163_F      D     138          2.980
LGA    L   164_F      N     139          2.865
LGA    -       -      Q     140           -
LGA    -       -      A     141           -
LGA    V   165_F      S     142          5.034
LGA    P   166_F      R     143          3.588
LGA    F   167_F      R     144          1.595
LGA    Y   168_F      T     145          3.238
LGA    Q   169_F      F     146          4.096
LGA    -       -      A     147           -
LGA    R   170_F      G     148          1.817
LGA    F   171_F      L     149          1.675
LGA    G   172_F      A     150          1.575
LGA    F   173_F      G     151           -
LGA    -       -      E     152           -
LGA    -       -      R     153           -
LGA    -       -      G     154           -
LGA    -       -      A     155           -
LGA    -       -      H     156           -
LGA    H   174_F      V     157          2.123
LGA    P   175_F      S     158          3.452
LGA    A   176_F      E     159          2.216
LGA    G   177_F      Q     160          1.422
LGA    P   178_F      P     161          1.614
LGA    C   179_F      F     162          2.023
LGA    A   180_F      F     163          2.841
LGA    I   181_F      D     164           #
LGA    -       -      R     165           -
LGA    -       -      Q     166           -
LGA    V   182_F      A     167          4.798
LGA    V   183_F      F     168          5.694
LGA    -       -      G     169           -
LGA    -       -      G     170           -
LGA    G   184_F      A     171          4.551
LGA    S   185_F      D     172          2.553
LGA    L   186_F      H     173          1.900
LGA    T   187_F      D     174          3.425
LGA    -       -      D     175           -
LGA    F   188_F      E     176          1.244
LGA    T   189_F      M     177          1.606
LGA    E   190_F      L     178          1.097
LGA    M   191_F      L     179          0.737
LGA    H   192_F      R     180          0.829
LGA    C   193_F      I     181          1.607
LGA    S   194_F      G     182          1.662
LGA    -       -      P     183           -
LGA    L   195_F      F     184          2.852
LGA    R   196_F      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  179  159    5.0    136    2.15    14.71     63.694     6.044

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.562290 * X  +  -0.825680 * Y  +  -0.045625 * Z  +  -3.297456
  Y_new =  -0.779173 * X  +  -0.547484 * Y  +   0.305206 * Z  +  32.991920
  Z_new =  -0.276981 * X  +  -0.136064 * Y  +  -0.951193 * Z  + 109.089859 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.999511    0.142082  [ DEG:  -171.8593      8.1407 ]
  Theta =   0.280651    2.860941  [ DEG:    16.0801    163.9199 ]
  Phi   =  -0.945688    2.195905  [ DEG:   -54.1839    125.8161 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ib1_F                                        
REMARK     2: T0417.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ib1_F.T0417.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  179  159   5.0  136   2.15   14.71  63.694
REMARK  ---------------------------------------------------------- 
MOLECULE 1ib1_F
HEADER    SIGNALING PROTEIN/TRANSFERASE           26-MAR-01   1IB1              
TITLE     CRYSTAL STRUCTURE OF THE 14-3-3 ZETA:SEROTONIN N-                     
TITLE    2 ACETYLTRANSFERASE COMPLEX                                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: 14-3-3 ZETA ISOFORM;                                       
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: PROTEIN KINASE C INHIBITOR PROTEIN-1;                       
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MOL_ID: 2;                                                           
COMPND   7 MOLECULE: SEROTONIN N-ACETYLTRANSFERASE;                             
COMPND   8 CHAIN: E, F, G, H;                                                   
COMPND   9 SYNONYM: ARALKYLAMINE N-ACETYLTRANSFERASE, AA-NAT,                   
COMPND  10 SEROTONIN ACETYLASE;                                                 
COMPND  11 EC: 2.3.1.87;                                                        
COMPND  12 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: YWHAZ;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET14B;                                   
SOURCE  10 MOL_ID: 2;                                                           
SOURCE  11 ORGANISM_SCIENTIFIC: OVIS ARIES;                                     
SOURCE  12 ORGANISM_COMMON: SHEEP;                                              
SOURCE  13 GENE: AANAT OR SNAT;                                                 
SOURCE  14 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  15 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE  16 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)PLYS;                             
SOURCE  17 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  18 EXPRESSION_SYSTEM_PLASMID: PGEX-4T-1                                 
KEYWDS    N-ACETYL TRANSFERASE, 14-3-3, SIGNAL TRANSDUCTION, PROTEIN-           
KEYWDS   2 PROTEIN COMPLEX, PHOSPHORYLATION                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    T.OBSIL,R.GHIRLANDO,D.C.KLEIN,S.GANGULY,F.DYDA                        
REVDAT   2   01-APR-03 1IB1    1       JRNL                                     
REVDAT   1   02-MAY-01 1IB1    0                                                
JRNL        AUTH   T.OBSIL,R.GHIRLANDO,D.C.KLEIN,S.GANGULY,F.DYDA               
JRNL        TITL   CRYSTAL STRUCTURE OF THE 14-3-3ZETA:SEROTONIN                
JRNL        TITL 2 N-ACETYLTRANSFERASE COMPLEX. A ROLE FOR                      
JRNL        TITL 3 SCAFFOLDING IN ENZYME REGULATION.                            
JRNL        REF    CELL                          V. 105   257 2001              
JRNL        REFN   ASTM CELLB5  US ISSN 0092-8674                               
REMARK   2 RESOLUTION. 2.70 ANGSTROMS.                                          
DBREF  1IB1 A    1   245  UNP    P63104   1433Z_HUMAN      1    245             
DBREF  1IB1 B    1   245  UNP    P63104   1433Z_HUMAN      1    245             
DBREF  1IB1 C    1   245  UNP    P63104   1433Z_HUMAN      1    245             
DBREF  1IB1 D    1   245  UNP    P63104   1433Z_HUMAN      1    245             
DBREF  1IB1 E    2   201  UNP    Q29495   SNAT_SHEEP       2    201             
DBREF  1IB1 F    2   201  UNP    Q29495   SNAT_SHEEP       2    201             
DBREF  1IB1 G    2   201  UNP    Q29495   SNAT_SHEEP       2    201             
DBREF  1IB1 H    2   201  UNP    Q29495   SNAT_SHEEP       2    201             
SEQRES   1 A  245  MET ASP LYS ASN GLU LEU VAL GLN LYS ALA LYS LEU ALA          
SEQRES   2 A  245  GLU GLN ALA GLU ARG TYR ASP ASP MET ALA ALA CYS MET          
SEQRES   3 A  245  LYS SER VAL THR GLU GLN GLY ALA GLU LEU SER ASN GLU          
SEQRES   4 A  245  GLU ARG ASN LEU LEU SER VAL ALA TYR LYS ASN VAL VAL          
SEQRES   5 A  245  GLY ALA ARG ARG SER SER TRP ARG VAL VAL SER SER ILE          
SEQRES   6 A  245  GLU GLN LYS THR GLU GLY ALA GLU LYS LYS GLN GLN MET          
SEQRES   7 A  245  ALA ARG GLU TYR ARG GLU LYS ILE GLU THR GLU LEU ARG          
SEQRES   8 A  245  ASP ILE CYS ASN ASP VAL LEU SER LEU LEU GLU LYS PHE          
SEQRES   9 A  245  LEU ILE PRO ASN ALA SER GLN ALA GLU SER LYS VAL PHE          
SEQRES  10 A  245  TYR LEU LYS MET LYS GLY ASP TYR TYR ARG TYR LEU ALA          
SEQRES  11 A  245  GLU VAL ALA ALA GLY ASP ASP LYS LYS GLY ILE VAL ASP          
SEQRES  12 A  245  GLN SER GLN GLN ALA TYR GLN GLU ALA PHE GLU ILE SER          
SEQRES  13 A  245  LYS LYS GLU MET GLN PRO THR HIS PRO ILE ARG LEU GLY          
SEQRES  14 A  245  LEU ALA LEU ASN PHE SER VAL PHE TYR TYR GLU ILE LEU          
SEQRES  15 A  245  ASN SER PRO GLU LYS ALA CYS SER LEU ALA LYS THR ALA          
SEQRES  16 A  245  PHE ASP GLU ALA ILE ALA GLU LEU ASP THR LEU SER GLU          
SEQRES  17 A  245  GLU SER TYR LYS ASP SER THR LEU ILE MET GLN LEU LEU          
SEQRES  18 A  245  ARG ASP ASN LEU THR LEU TRP THR SER ASP THR GLN GLY          
SEQRES  19 A  245  ASP GLU ALA GLU ALA GLY GLU GLY GLY GLU ASN                  
SEQRES   1 B  245  MET ASP LYS ASN GLU LEU VAL GLN LYS ALA LYS LEU ALA          
SEQRES   2 B  245  GLU GLN ALA GLU ARG TYR ASP ASP MET ALA ALA CYS MET          
SEQRES   3 B  245  LYS SER VAL THR GLU GLN GLY ALA GLU LEU SER ASN GLU          
SEQRES   4 B  245  GLU ARG ASN LEU LEU SER VAL ALA TYR LYS ASN VAL VAL          
SEQRES   5 B  245  GLY ALA ARG ARG SER SER TRP ARG VAL VAL SER SER ILE          
SEQRES   6 B  245  GLU GLN LYS THR GLU GLY ALA GLU LYS LYS GLN GLN MET          
SEQRES   7 B  245  ALA ARG GLU TYR ARG GLU LYS ILE GLU THR GLU LEU ARG          
SEQRES   8 B  245  ASP ILE CYS ASN ASP VAL LEU SER LEU LEU GLU LYS PHE          
SEQRES   9 B  245  LEU ILE PRO ASN ALA SER GLN ALA GLU SER LYS VAL PHE          
SEQRES  10 B  245  TYR LEU LYS MET LYS GLY ASP TYR TYR ARG TYR LEU ALA          
SEQRES  11 B  245  GLU VAL ALA ALA GLY ASP ASP LYS LYS GLY ILE VAL ASP          
SEQRES  12 B  245  GLN SER GLN GLN ALA TYR GLN GLU ALA PHE GLU ILE SER          
SEQRES  13 B  245  LYS LYS GLU MET GLN PRO THR HIS PRO ILE ARG LEU GLY          
SEQRES  14 B  245  LEU ALA LEU ASN PHE SER VAL PHE TYR TYR GLU ILE LEU          
SEQRES  15 B  245  ASN SER PRO GLU LYS ALA CYS SER LEU ALA LYS THR ALA          
SEQRES  16 B  245  PHE ASP GLU ALA ILE ALA GLU LEU ASP THR LEU SER GLU          
SEQRES  17 B  245  GLU SER TYR LYS ASP SER THR LEU ILE MET GLN LEU LEU          
SEQRES  18 B  245  ARG ASP ASN LEU THR LEU TRP THR SER ASP THR GLN GLY          
SEQRES  19 B  245  ASP GLU ALA GLU ALA GLY GLU GLY GLY GLU ASN                  
SEQRES   1 C  245  MET ASP LYS ASN GLU LEU VAL GLN LYS ALA LYS LEU ALA          
SEQRES   2 C  245  GLU GLN ALA GLU ARG TYR ASP ASP MET ALA ALA CYS MET          
SEQRES   3 C  245  LYS SER VAL THR GLU GLN GLY ALA GLU LEU SER ASN GLU          
SEQRES   4 C  245  GLU ARG ASN LEU LEU SER VAL ALA TYR LYS ASN VAL VAL          
SEQRES   5 C  245  GLY ALA ARG ARG SER SER TRP ARG VAL VAL SER SER ILE          
SEQRES   6 C  245  GLU GLN LYS THR GLU GLY ALA GLU LYS LYS GLN GLN MET          
SEQRES   7 C  245  ALA ARG GLU TYR ARG GLU LYS ILE GLU THR GLU LEU ARG          
SEQRES   8 C  245  ASP ILE CYS ASN ASP VAL LEU SER LEU LEU GLU LYS PHE          
SEQRES   9 C  245  LEU ILE PRO ASN ALA SER GLN ALA GLU SER LYS VAL PHE          
SEQRES  10 C  245  TYR LEU LYS MET LYS GLY ASP TYR TYR ARG TYR LEU ALA          
SEQRES  11 C  245  GLU VAL ALA ALA GLY ASP ASP LYS LYS GLY ILE VAL ASP          
SEQRES  12 C  245  GLN SER GLN GLN ALA TYR GLN GLU ALA PHE GLU ILE SER          
SEQRES  13 C  245  LYS LYS GLU MET GLN PRO THR HIS PRO ILE ARG LEU GLY          
SEQRES  14 C  245  LEU ALA LEU ASN PHE SER VAL PHE TYR TYR GLU ILE LEU          
SEQRES  15 C  245  ASN SER PRO GLU LYS ALA CYS SER LEU ALA LYS THR ALA          
SEQRES  16 C  245  PHE ASP GLU ALA ILE ALA GLU LEU ASP THR LEU SER GLU          
SEQRES  17 C  245  GLU SER TYR LYS ASP SER THR LEU ILE MET GLN LEU LEU          
SEQRES  18 C  245  ARG ASP ASN LEU THR LEU TRP THR SER ASP THR GLN GLY          
SEQRES  19 C  245  ASP GLU ALA GLU ALA GLY GLU GLY GLY GLU ASN                  
SEQRES   1 D  245  MET ASP LYS ASN GLU LEU VAL GLN LYS ALA LYS LEU ALA          
SEQRES   2 D  245  GLU GLN ALA GLU ARG TYR ASP ASP MET ALA ALA CYS MET          
SEQRES   3 D  245  LYS SER VAL THR GLU GLN GLY ALA GLU LEU SER ASN GLU          
SEQRES   4 D  245  GLU ARG ASN LEU LEU SER VAL ALA TYR LYS ASN VAL VAL          
SEQRES   5 D  245  GLY ALA ARG ARG SER SER TRP ARG VAL VAL SER SER ILE          
SEQRES   6 D  245  GLU GLN LYS THR GLU GLY ALA GLU LYS LYS GLN GLN MET          
SEQRES   7 D  245  ALA ARG GLU TYR ARG GLU LYS ILE GLU THR GLU LEU ARG          
SEQRES   8 D  245  ASP ILE CYS ASN ASP VAL LEU SER LEU LEU GLU LYS PHE          
SEQRES   9 D  245  LEU ILE PRO ASN ALA SER GLN ALA GLU SER LYS VAL PHE          
SEQRES  10 D  245  TYR LEU LYS MET LYS GLY ASP TYR TYR ARG TYR LEU ALA          
SEQRES  11 D  245  GLU VAL ALA ALA GLY ASP ASP LYS LYS GLY ILE VAL ASP          
SEQRES  12 D  245  GLN SER GLN GLN ALA TYR GLN GLU ALA PHE GLU ILE SER          
SEQRES  13 D  245  LYS LYS GLU MET GLN PRO THR HIS PRO ILE ARG LEU GLY          
SEQRES  14 D  245  LEU ALA LEU ASN PHE SER VAL PHE TYR TYR GLU ILE LEU          
SEQRES  15 D  245  ASN SER PRO GLU LYS ALA CYS SER LEU ALA LYS THR ALA          
SEQRES  16 D  245  PHE ASP GLU ALA ILE ALA GLU LEU ASP THR LEU SER GLU          
SEQRES  17 D  245  GLU SER TYR LYS ASP SER THR LEU ILE MET GLN LEU LEU          
SEQRES  18 D  245  ARG ASP ASN LEU THR LEU TRP THR SER ASP THR GLN GLY          
SEQRES  19 D  245  ASP GLU ALA GLU ALA GLY GLU GLY GLY GLU ASN                  
SEQRES   1 E  200  SER THR PRO SER VAL HIS CYS LEU LYS PRO SER PRO LEU          
SEQRES   2 E  200  HIS LEU PRO SER GLY ILE PRO GLY SER PRO GLY ARG GLN          
SEQRES   3 E  200  ARG ARG HIS TPO LEU PRO ALA ASN GLU PHE ARG CYS LEU          
SEQRES   4 E  200  THR PRO GLU ASP ALA ALA GLY VAL PHE GLU ILE GLU ARG          
SEQRES   5 E  200  GLU ALA PHE ILE SER VAL SER GLY ASN CYS PRO LEU ASN          
SEQRES   6 E  200  LEU ASP GLU VAL GLN HIS PHE LEU THR LEU CYS PRO GLU          
SEQRES   7 E  200  LEU SER LEU GLY TRP PHE VAL GLU GLY ARG LEU VAL ALA          
SEQRES   8 E  200  PHE ILE ILE GLY SER LEU TRP ASP GLU GLU ARG LEU THR          
SEQRES   9 E  200  GLN GLU SER LEU ALA LEU HIS ARG PRO ARG GLY HIS SER          
SEQRES  10 E  200  ALA HIS LEU HIS ALA LEU ALA VAL HIS ARG SER PHE ARG          
SEQRES  11 E  200  GLN GLN GLY LYS GLY SER VAL LEU LEU TRP ARG TYR LEU          
SEQRES  12 E  200  HIS HIS VAL GLY ALA GLN PRO ALA VAL ARG ARG ALA VAL          
SEQRES  13 E  200  LEU MET CYS GLU ASP ALA LEU VAL PRO PHE TYR GLN ARG          
SEQRES  14 E  200  PHE GLY PHE HIS PRO ALA GLY PRO CYS ALA ILE VAL VAL          
SEQRES  15 E  200  GLY SER LEU THR PHE THR GLU MET HIS CYS SER LEU ARG          
SEQRES  16 E  200  GLY HIS ALA ALA LEU                                          
SEQRES   1 F  200  SER THR PRO SER VAL HIS CYS LEU LYS PRO SER PRO LEU          
SEQRES   2 F  200  HIS LEU PRO SER GLY ILE PRO GLY SER PRO GLY ARG GLN          
SEQRES   3 F  200  ARG ARG HIS TPO LEU PRO ALA ASN GLU PHE ARG CYS LEU          
SEQRES   4 F  200  THR PRO GLU ASP ALA ALA GLY VAL PHE GLU ILE GLU ARG          
SEQRES   5 F  200  GLU ALA PHE ILE SER VAL SER GLY ASN CYS PRO LEU ASN          
SEQRES   6 F  200  LEU ASP GLU VAL GLN HIS PHE LEU THR LEU CYS PRO GLU          
SEQRES   7 F  200  LEU SER LEU GLY TRP PHE VAL GLU GLY ARG LEU VAL ALA          
SEQRES   8 F  200  PHE ILE ILE GLY SER LEU TRP ASP GLU GLU ARG LEU THR          
SEQRES   9 F  200  GLN GLU SER LEU ALA LEU HIS ARG PRO ARG GLY HIS SER          
SEQRES  10 F  200  ALA HIS LEU HIS ALA LEU ALA VAL HIS ARG SER PHE ARG          
SEQRES  11 F  200  GLN GLN GLY LYS GLY SER VAL LEU LEU TRP ARG TYR LEU          
SEQRES  12 F  200  HIS HIS VAL GLY ALA GLN PRO ALA VAL ARG ARG ALA VAL          
SEQRES  13 F  200  LEU MET CYS GLU ASP ALA LEU VAL PRO PHE TYR GLN ARG          
SEQRES  14 F  200  PHE GLY PHE HIS PRO ALA GLY PRO CYS ALA ILE VAL VAL          
SEQRES  15 F  200  GLY SER LEU THR PHE THR GLU MET HIS CYS SER LEU ARG          
SEQRES  16 F  200  GLY HIS ALA ALA LEU                                          
SEQRES   1 G  200  SER THR PRO SER VAL HIS CYS LEU LYS PRO SER PRO LEU          
SEQRES   2 G  200  HIS LEU PRO SER GLY ILE PRO GLY SER PRO GLY ARG GLN          
SEQRES   3 G  200  ARG ARG HIS TPO LEU PRO ALA ASN GLU PHE ARG CYS LEU          
SEQRES   4 G  200  THR PRO GLU ASP ALA ALA GLY VAL PHE GLU ILE GLU ARG          
SEQRES   5 G  200  GLU ALA PHE ILE SER VAL SER GLY ASN CYS PRO LEU ASN          
SEQRES   6 G  200  LEU ASP GLU VAL GLN HIS PHE LEU THR LEU CYS PRO GLU          
SEQRES   7 G  200  LEU SER LEU GLY TRP PHE VAL GLU GLY ARG LEU VAL ALA          
SEQRES   8 G  200  PHE ILE ILE GLY SER LEU TRP ASP GLU GLU ARG LEU THR          
SEQRES   9 G  200  GLN GLU SER LEU ALA LEU HIS ARG PRO ARG GLY HIS SER          
SEQRES  10 G  200  ALA HIS LEU HIS ALA LEU ALA VAL HIS ARG SER PHE ARG          
SEQRES  11 G  200  GLN GLN GLY LYS GLY SER VAL LEU LEU TRP ARG TYR LEU          
SEQRES  12 G  200  HIS HIS VAL GLY ALA GLN PRO ALA VAL ARG ARG ALA VAL          
SEQRES  13 G  200  LEU MET CYS GLU ASP ALA LEU VAL PRO PHE TYR GLN ARG          
SEQRES  14 G  200  PHE GLY PHE HIS PRO ALA GLY PRO CYS ALA ILE VAL VAL          
SEQRES  15 G  200  GLY SER LEU THR PHE THR GLU MET HIS CYS SER LEU ARG          
SEQRES  16 G  200  GLY HIS ALA ALA LEU                                          
SEQRES   1 H  200  SER THR PRO SER VAL HIS CYS LEU LYS PRO SER PRO LEU          
SEQRES   2 H  200  HIS LEU PRO SER GLY ILE PRO GLY SER PRO GLY ARG GLN          
SEQRES   3 H  200  ARG ARG HIS TPO LEU PRO ALA ASN GLU PHE ARG CYS LEU          
SEQRES   4 H  200  THR PRO GLU ASP ALA ALA GLY VAL PHE GLU ILE GLU ARG          
SEQRES   5 H  200  GLU ALA PHE ILE SER VAL SER GLY ASN CYS PRO LEU ASN          
SEQRES   6 H  200  LEU ASP GLU VAL GLN HIS PHE LEU THR LEU CYS PRO GLU          
SEQRES   7 H  200  LEU SER LEU GLY TRP PHE VAL GLU GLY ARG LEU VAL ALA          
SEQRES   8 H  200  PHE ILE ILE GLY SER LEU TRP ASP GLU GLU ARG LEU THR          
SEQRES   9 H  200  GLN GLU SER LEU ALA LEU HIS ARG PRO ARG GLY HIS SER          
SEQRES  10 H  200  ALA HIS LEU HIS ALA LEU ALA VAL HIS ARG SER PHE ARG          
SEQRES  11 H  200  GLN GLN GLY LYS GLY SER VAL LEU LEU TRP ARG TYR LEU          
SEQRES  12 H  200  HIS HIS VAL GLY ALA GLN PRO ALA VAL ARG ARG ALA VAL          
SEQRES  13 H  200  LEU MET CYS GLU ASP ALA LEU VAL PRO PHE TYR GLN ARG          
SEQRES  14 H  200  PHE GLY PHE HIS PRO ALA GLY PRO CYS ALA ILE VAL VAL          
SEQRES  15 H  200  GLY SER LEU THR PHE THR GLU MET HIS CYS SER LEU ARG          
SEQRES  16 H  200  GLY HIS ALA ALA LEU                                          
HET    TPO  E  31      11                                                       
HET    TPO  F  31      11                                                       
HET    TPO  G  31      11                                                       
HET    TPO  H  31      11                                                       
HET    COT    400      63                                                       
HET    COT    401      63                                                       
HET    COT    402      63                                                       
HET    COT    403      63                                                       
HETNAM     TPO PHOSPHOTHREONINE                                                 
HETNAM     COT COA-S-ACETYL TRYPTAMINE                                          
HETSYN     TPO PHOSPHONOTHREONINE                                               
FORMUL   5  TPO    4(C4 H10 N O6 P)                                             
FORMUL   9  COT    4(C33 H48 N9 O17 P3 S)                                       
FORMUL  13  HOH   *211(H2 O)                                                    
CRYST1   74.717   75.078  101.780  90.14  90.06  63.04 P 1           4          
ATOM   8705  N   SER F  18      -2.425 -24.442  35.283  1.00 47.64           N  
ATOM   8706  CA  SER F  18      -3.856 -24.701  35.451  1.00 48.24           C  
ATOM   8707  C   SER F  18      -4.235 -25.961  34.649  1.00 47.19           C  
ATOM   8708  O   SER F  18      -4.823 -25.876  33.559  1.00 46.36           O  
ATOM   8709  CB  SER F  18      -4.669 -23.483  34.987  1.00 49.11           C  
ATOM   8710  OG  SER F  18      -5.956 -23.450  35.586  1.00 49.26           O  
ATOM   8711  N   GLY F  19      -3.949 -27.120  35.243  1.00 45.38           N  
ATOM   8712  CA  GLY F  19      -4.178 -28.404  34.599  1.00 44.79           C  
ATOM   8713  C   GLY F  19      -5.510 -28.914  34.067  1.00 43.86           C  
ATOM   8714  O   GLY F  19      -6.422 -29.263  34.837  1.00 44.01           O  
ATOM   8715  N   ILE F  20      -5.585 -29.008  32.740  1.00 41.70           N  
ATOM   8716  CA  ILE F  20      -6.748 -29.548  32.039  1.00 39.76           C  
ATOM   8717  C   ILE F  20      -6.205 -30.811  31.375  1.00 39.52           C  
ATOM   8718  O   ILE F  20      -5.649 -30.744  30.280  1.00 40.51           O  
ATOM   8719  CB  ILE F  20      -7.273 -28.611  30.891  1.00 36.91           C  
ATOM   8720  CG1 ILE F  20      -7.904 -27.336  31.451  1.00 35.25           C  
ATOM   8721  CG2 ILE F  20      -8.321 -29.348  30.056  1.00 33.40           C  
ATOM   8722  CD1 ILE F  20      -9.384 -27.475  31.807  1.00 35.76           C  
ATOM   8723  N   PRO F  21      -6.266 -31.963  32.062  1.00 39.52           N  
ATOM   8724  CA  PRO F  21      -5.754 -33.192  31.441  1.00 38.62           C  
ATOM   8725  C   PRO F  21      -6.334 -33.347  30.031  1.00 37.92           C  
ATOM   8726  O   PRO F  21      -7.542 -33.139  29.817  1.00 37.39           O  
ATOM   8727  CB  PRO F  21      -6.268 -34.286  32.381  1.00 39.91           C  
ATOM   8728  CG  PRO F  21      -6.244 -33.602  33.733  1.00 40.45           C  
ATOM   8729  CD  PRO F  21      -6.821 -32.232  33.406  1.00 39.92           C  
ATOM   8730  N   GLY F  22      -5.467 -33.635  29.062  1.00 35.65           N  
ATOM   8731  CA  GLY F  22      -5.931 -33.790  27.695  1.00 33.38           C  
ATOM   8732  C   GLY F  22      -5.927 -32.528  26.843  1.00 32.36           C  
ATOM   8733  O   GLY F  22      -6.045 -32.608  25.626  1.00 31.02           O  
ATOM   8734  N   SER F  23      -5.847 -31.365  27.471  1.00 32.57           N  
ATOM   8735  CA  SER F  23      -5.805 -30.107  26.729  1.00 32.74           C  
ATOM   8736  C   SER F  23      -4.626 -29.302  27.245  1.00 33.47           C  
ATOM   8737  O   SER F  23      -4.761 -28.469  28.151  1.00 33.33           O  
ATOM   8738  CB  SER F  23      -7.108 -29.316  26.869  1.00 33.19           C  
ATOM   8739  OG  SER F  23      -8.092 -29.804  25.977  1.00 35.85           O  
ATOM   8740  N   PRO F  24      -3.444 -29.548  26.663  1.00 33.30           N  
ATOM   8741  CA  PRO F  24      -2.147 -28.937  26.955  1.00 32.71           C  
ATOM   8742  C   PRO F  24      -2.023 -27.403  27.086  1.00 32.85           C  
ATOM   8743  O   PRO F  24      -1.437 -26.906  28.056  1.00 34.96           O  
ATOM   8744  CB  PRO F  24      -1.279 -29.477  25.825  1.00 31.26           C  
ATOM   8745  CG  PRO F  24      -1.825 -30.832  25.627  1.00 30.20           C  
ATOM   8746  CD  PRO F  24      -3.296 -30.551  25.594  1.00 33.15           C  
ATOM   8747  N   GLY F  25      -2.533 -26.642  26.126  1.00 29.62           N  
ATOM   8748  CA  GLY F  25      -2.371 -25.208  26.237  1.00 28.42           C  
ATOM   8749  C   GLY F  25      -3.533 -24.460  26.839  1.00 29.84           C  
ATOM   8750  O   GLY F  25      -3.486 -23.239  26.950  1.00 31.69           O  
ATOM   8751  N   ARG F  26      -4.577 -25.183  27.224  1.00 31.25           N  
ATOM   8752  CA  ARG F  26      -5.773 -24.561  27.788  1.00 30.23           C  
ATOM   8753  C   ARG F  26      -5.665 -24.395  29.287  1.00 29.24           C  
ATOM   8754  O   ARG F  26      -5.116 -25.261  29.974  1.00 28.54           O  
ATOM   8755  CB  ARG F  26      -7.005 -25.396  27.458  1.00 31.35           C  
ATOM   8756  CG  ARG F  26      -7.330 -25.496  25.967  1.00 35.70           C  
ATOM   8757  CD  ARG F  26      -6.264 -26.252  25.209  1.00 37.87           C  
ATOM   8758  NE  ARG F  26      -6.750 -26.877  23.981  1.00 41.41           N  
ATOM   8759  CZ  ARG F  26      -6.035 -27.730  23.244  1.00 42.32           C  
ATOM   8760  NH1 ARG F  26      -4.794 -28.057  23.602  1.00 39.89           N  
ATOM   8761  NH2 ARG F  26      -6.566 -28.269  22.153  1.00 45.78           N  
ATOM   8762  N   GLN F  27      -6.153 -23.267  29.791  1.00 29.50           N  
ATOM   8763  CA  GLN F  27      -6.115 -23.011  31.228  1.00 30.69           C  
ATOM   8764  C   GLN F  27      -7.476 -23.353  31.819  1.00 28.90           C  
ATOM   8765  O   GLN F  27      -8.511 -23.082  31.204  1.00 28.02           O  
ATOM   8766  CB  GLN F  27      -5.741 -21.552  31.511  1.00 32.08           C  
ATOM   8767  CG  GLN F  27      -6.645 -20.532  30.827  1.00 37.09           C  
ATOM   8768  CD  GLN F  27      -5.852 -19.285  30.450  1.00 39.93           C  
ATOM   8769  OE1 GLN F  27      -4.642 -19.217  30.672  1.00 42.38           O  
ATOM   8770  NE2 GLN F  27      -6.530 -18.299  29.856  1.00 38.94           N  
ATOM   8771  N   ARG F  28      -7.456 -24.023  32.967  1.00 26.97           N  
ATOM   8772  CA  ARG F  28      -8.667 -24.424  33.672  1.00 24.25           C  
ATOM   8773  C   ARG F  28      -9.378 -23.227  34.338  1.00 23.38           C  
ATOM   8774  O   ARG F  28      -8.736 -22.270  34.788  1.00 22.16           O  
ATOM   8775  CB  ARG F  28      -8.312 -25.476  34.728  1.00 23.20           C  
ATOM   8776  CG  ARG F  28      -9.514 -26.182  35.318  1.00 23.30           C  
ATOM   8777  CD  ARG F  28      -9.111 -27.233  36.307  1.00 23.70           C  
ATOM   8778  NE  ARG F  28     -10.283 -28.023  36.666  1.00 26.33           N  
ATOM   8779  CZ  ARG F  28     -10.816 -28.063  37.884  1.00 28.13           C  
ATOM   8780  NH1 ARG F  28     -10.278 -27.358  38.879  1.00 29.52           N  
ATOM   8781  NH2 ARG F  28     -11.898 -28.802  38.104  1.00 27.29           N  
ATOM   8782  N   ARG F  29     -10.708 -23.263  34.357  1.00 21.20           N  
ATOM   8783  CA  ARG F  29     -11.483 -22.203  35.001  1.00 16.75           C  
ATOM   8784  C   ARG F  29     -11.154 -22.122  36.484  1.00 15.76           C  
ATOM   8785  O   ARG F  29     -10.669 -23.087  37.088  1.00 15.68           O  
ATOM   8786  CB  ARG F  29     -12.994 -22.403  34.816  1.00 13.69           C  
ATOM   8787  CG  ARG F  29     -13.453 -23.848  34.620  1.00 13.81           C  
ATOM   8788  CD  ARG F  29     -14.023 -24.496  35.877  1.00  8.06           C  
ATOM   8789  NE  ARG F  29     -13.008 -24.679  36.902  1.00  6.20           N  
ATOM   8790  CZ  ARG F  29     -13.201 -25.340  38.034  1.00  2.14           C  
ATOM   8791  NH1 ARG F  29     -14.369 -25.898  38.292  1.00  2.00           N  
ATOM   8792  NH2 ARG F  29     -12.243 -25.374  38.942  1.00  2.00           N  
ATOM   8793  N   HIS F  30     -11.426 -20.962  37.068  1.00 14.89           N  
ATOM   8794  CA  HIS F  30     -11.150 -20.737  38.478  1.00 12.15           C  
ATOM   8795  C   HIS F  30     -12.380 -20.864  39.359  1.00  9.84           C  
ATOM   8796  O   HIS F  30     -13.484 -20.503  38.962  1.00  8.88           O  
ATOM   8797  CB  HIS F  30     -10.646 -19.308  38.720  1.00 13.04           C  
ATOM   8798  CG  HIS F  30      -9.363 -18.965  38.040  1.00 11.33           C  
ATOM   8799  ND1 HIS F  30      -8.139 -19.405  38.498  1.00 13.73           N  
ATOM   8800  CD2 HIS F  30      -9.101 -18.130  37.008  1.00 11.04           C  
ATOM   8801  CE1 HIS F  30      -7.179 -18.849  37.780  1.00 15.01           C  
ATOM   8802  NE2 HIS F  30      -7.737 -18.070  36.871  1.00 14.19           N  
HETATM 8803  N   TPO F  31     -12.160 -21.349  40.571  1.00  7.68           N  
HETATM 8804  CA  TPO F  31     -13.192 -21.413  41.595  1.00  7.96           C  
HETATM 8805  CB  TPO F  31     -13.854 -22.794  41.793  1.00  6.06           C  
HETATM 8806  CG2 TPO F  31     -14.516 -23.242  40.527  1.00  6.26           C  
HETATM 8807  OG1 TPO F  31     -12.854 -23.745  42.204  1.00  9.76           O  
HETATM 8808  P   TPO F  31     -13.322 -25.152  42.709  1.00  7.87           P  
HETATM 8809  O1P TPO F  31     -13.982 -25.815  41.579  1.00 11.72           O  
HETATM 8810  O2P TPO F  31     -12.202 -26.014  43.115  1.00  4.54           O  
HETATM 8811  O3P TPO F  31     -14.245 -24.900  43.844  1.00  6.30           O  
HETATM 8812  C   TPO F  31     -12.460 -20.904  42.823  1.00  9.02           C  
HETATM 8813  O   TPO F  31     -11.234 -20.785  42.799  1.00  8.60           O  
ATOM   8814  N   LEU F  32     -13.195 -20.565  43.870  1.00 11.56           N  
ATOM   8815  CA  LEU F  32     -12.611 -20.036  45.104  1.00 12.90           C  
ATOM   8816  C   LEU F  32     -11.486 -20.936  45.632  1.00 10.52           C  
ATOM   8817  O   LEU F  32     -11.648 -22.150  45.699  1.00 12.63           O  
ATOM   8818  CB  LEU F  32     -13.726 -19.876  46.151  1.00 13.27           C  
ATOM   8819  CG  LEU F  32     -13.732 -18.754  47.198  1.00 14.73           C  
ATOM   8820  CD1 LEU F  32     -13.128 -19.238  48.484  1.00 16.36           C  
ATOM   8821  CD2 LEU F  32     -13.015 -17.511  46.683  1.00 17.83           C  
ATOM   8822  N   PRO F  33     -10.293 -20.362  45.867  1.00  8.38           N  
ATOM   8823  CA  PRO F  33      -9.127 -21.093  46.378  1.00  7.68           C  
ATOM   8824  C   PRO F  33      -9.277 -21.320  47.875  1.00  8.95           C  
ATOM   8825  O   PRO F  33     -10.318 -20.984  48.436  1.00 12.93           O  
ATOM   8826  CB  PRO F  33      -7.974 -20.136  46.081  1.00  7.31           C  
ATOM   8827  CG  PRO F  33      -8.613 -18.781  46.209  1.00  6.68           C  
ATOM   8828  CD  PRO F  33      -9.911 -18.996  45.459  1.00  7.19           C  
ATOM   8829  N   ALA F  34      -8.242 -21.846  48.528  1.00  7.23           N  
ATOM   8830  CA  ALA F  34      -8.323 -22.083  49.962  1.00  6.72           C  
ATOM   8831  C   ALA F  34      -7.019 -21.886  50.729  1.00  6.12           C  
ATOM   8832  O   ALA F  34      -6.305 -22.860  50.994  1.00  8.70           O  
ATOM   8833  CB  ALA F  34      -8.862 -23.471  50.225  1.00 10.01           C  
ATOM   8834  N   ASN F  35      -6.760 -20.654  51.168  1.00  5.74           N  
ATOM   8835  CA  ASN F  35      -5.544 -20.322  51.928  1.00  7.03           C  
ATOM   8836  C   ASN F  35      -4.312 -20.525  51.078  1.00  9.06           C  
ATOM   8837  O   ASN F  35      -3.950 -21.651  50.742  1.00  9.07           O  
ATOM   8838  CB  ASN F  35      -5.400 -21.156  53.212  1.00  2.60           C  
ATOM   8839  CG  ASN F  35      -6.133 -20.555  54.400  1.00  2.00           C  
ATOM   8840  OD1 ASN F  35      -7.167 -19.894  54.256  1.00  3.62           O  
ATOM   8841  ND2 ASN F  35      -5.606 -20.794  55.585  1.00  2.00           N  
ATOM   8842  N   GLU F  36      -3.638 -19.432  50.758  1.00 10.81           N  
ATOM   8843  CA  GLU F  36      -2.459 -19.522  49.928  1.00 10.97           C  
ATOM   8844  C   GLU F  36      -1.543 -18.354  50.179  1.00 11.09           C  
ATOM   8845  O   GLU F  36      -1.908 -17.419  50.867  1.00 13.01           O  
ATOM   8846  CB  GLU F  36      -2.869 -19.594  48.463  1.00  8.92           C  
ATOM   8847  CG  GLU F  36      -3.637 -18.399  47.993  1.00 16.14           C  
ATOM   8848  CD  GLU F  36      -4.390 -18.717  46.724  1.00 18.29           C  
ATOM   8849  OE1 GLU F  36      -3.878 -19.511  45.905  1.00 19.42           O  
ATOM   8850  OE2 GLU F  36      -5.498 -18.163  46.543  1.00 18.78           O  
ATOM   8851  N   PHE F  37      -0.321 -18.467  49.681  1.00 13.27           N  
ATOM   8852  CA  PHE F  37       0.696 -17.441  49.808  1.00 14.38           C  
ATOM   8853  C   PHE F  37       0.993 -17.019  48.392  1.00 15.23           C  
ATOM   8854  O   PHE F  37       1.225 -17.869  47.531  1.00 17.28           O  
ATOM   8855  CB  PHE F  37       1.945 -18.017  50.449  1.00 15.24           C  
ATOM   8856  CG  PHE F  37       1.840 -18.170  51.928  1.00 18.13           C  
ATOM   8857  CD1 PHE F  37       1.399 -19.359  52.485  1.00 17.31           C  
ATOM   8858  CD2 PHE F  37       2.177 -17.114  52.773  1.00 21.43           C  
ATOM   8859  CE1 PHE F  37       1.290 -19.501  53.873  1.00 21.23           C  
ATOM   8860  CE2 PHE F  37       2.073 -17.244  54.162  1.00 22.40           C  
ATOM   8861  CZ  PHE F  37       1.629 -18.442  54.709  1.00 21.33           C  
ATOM   8862  N   ARG F  38       0.931 -15.722  48.119  1.00 14.77           N  
ATOM   8863  CA  ARG F  38       1.174 -15.236  46.769  1.00 15.92           C  
ATOM   8864  C   ARG F  38       1.972 -13.951  46.767  1.00 16.72           C  
ATOM   8865  O   ARG F  38       2.067 -13.268  47.793  1.00 18.38           O  
ATOM   8866  CB  ARG F  38      -0.153 -14.955  46.068  1.00 10.89           C  
ATOM   8867  CG  ARG F  38      -1.272 -15.961  46.350  1.00 13.61           C  
ATOM   8868  CD  ARG F  38      -2.599 -15.491  45.747  1.00 13.16           C  
ATOM   8869  NE  ARG F  38      -2.427 -15.246  44.322  1.00 16.54           N  
ATOM   8870  CZ  ARG F  38      -2.938 -16.001  43.357  1.00 15.99           C  
ATOM   8871  NH1 ARG F  38      -3.690 -17.063  43.652  1.00 13.13           N  
ATOM   8872  NH2 ARG F  38      -2.624 -15.732  42.093  1.00 15.94           N  
ATOM   8873  N   CYS F  39       2.598 -13.648  45.634  1.00 16.97           N  
ATOM   8874  CA  CYS F  39       3.318 -12.394  45.498  1.00 15.73           C  
ATOM   8875  C   CYS F  39       2.162 -11.432  45.293  1.00 16.47           C  
ATOM   8876  O   CYS F  39       1.153 -11.805  44.673  1.00 16.22           O  
ATOM   8877  CB  CYS F  39       4.206 -12.397  44.254  1.00 16.25           C  
ATOM   8878  SG  CYS F  39       5.749 -13.311  44.427  1.00 20.28           S  
ATOM   8879  N   LEU F  40       2.264 -10.229  45.844  1.00 16.56           N  
ATOM   8880  CA  LEU F  40       1.189  -9.262  45.685  1.00 16.20           C  
ATOM   8881  C   LEU F  40       1.278  -8.586  44.321  1.00 17.10           C  
ATOM   8882  O   LEU F  40       2.338  -8.596  43.686  1.00 16.42           O  
ATOM   8883  CB  LEU F  40       1.240  -8.221  46.801  1.00 15.79           C  
ATOM   8884  CG  LEU F  40       1.208  -8.749  48.237  1.00 14.85           C  
ATOM   8885  CD1 LEU F  40       1.322  -7.587  49.215  1.00 11.13           C  
ATOM   8886  CD2 LEU F  40      -0.071  -9.528  48.475  1.00 14.19           C  
ATOM   8887  N   THR F  41       0.151  -8.061  43.845  1.00 19.46           N  
ATOM   8888  CA  THR F  41       0.114  -7.358  42.563  1.00 22.63           C  
ATOM   8889  C   THR F  41      -0.184  -5.885  42.843  1.00 22.50           C  
ATOM   8890  O   THR F  41      -0.695  -5.550  43.911  1.00 21.74           O  
ATOM   8891  CB  THR F  41      -0.980  -7.916  41.637  1.00 24.25           C  
ATOM   8892  OG1 THR F  41      -2.270  -7.667  42.214  1.00 24.62           O  
ATOM   8893  CG2 THR F  41      -0.789  -9.416  41.411  1.00 25.59           C  
ATOM   8894  N   PRO F  42       0.104  -4.989  41.879  1.00 23.92           N  
ATOM   8895  CA  PRO F  42      -0.159  -3.563  42.087  1.00 24.89           C  
ATOM   8896  C   PRO F  42      -1.612  -3.292  42.484  1.00 26.16           C  
ATOM   8897  O   PRO F  42      -1.910  -2.310  43.168  1.00 27.89           O  
ATOM   8898  CB  PRO F  42       0.157  -2.965  40.721  1.00 23.57           C  
ATOM   8899  CG  PRO F  42       1.243  -3.847  40.216  1.00 24.59           C  
ATOM   8900  CD  PRO F  42       0.727  -5.215  40.561  1.00 24.20           C  
ATOM   8901  N   GLU F  43      -2.514  -4.172  42.068  1.00 26.92           N  
ATOM   8902  CA  GLU F  43      -3.940  -4.028  42.372  1.00 27.00           C  
ATOM   8903  C   GLU F  43      -4.233  -4.294  43.859  1.00 24.08           C  
ATOM   8904  O   GLU F  43      -5.252  -3.856  44.390  1.00 22.51           O  
ATOM   8905  CB  GLU F  43      -4.778  -4.965  41.484  1.00 30.52           C  
ATOM   8906  CG  GLU F  43      -4.689  -4.705  39.970  1.00 36.28           C  
ATOM   8907  CD  GLU F  43      -3.278  -4.985  39.441  1.00 42.02           C  
ATOM   8908  OE1 GLU F  43      -2.739  -6.084  39.706  1.00 40.24           O  
ATOM   8909  OE2 GLU F  43      -2.706  -4.101  38.757  1.00 46.03           O  
ATOM   8910  N   ASP F  44      -3.334  -5.005  44.528  1.00 21.69           N  
ATOM   8911  CA  ASP F  44      -3.490  -5.313  45.946  1.00 22.03           C  
ATOM   8912  C   ASP F  44      -3.033  -4.160  46.843  1.00 21.35           C  
ATOM   8913  O   ASP F  44      -3.093  -4.259  48.067  1.00 21.07           O  
ATOM   8914  CB  ASP F  44      -2.688  -6.571  46.314  1.00 23.58           C  
ATOM   8915  CG  ASP F  44      -3.269  -7.847  45.720  1.00 23.88           C  
ATOM   8916  OD1 ASP F  44      -4.424  -8.198  46.063  1.00 25.30           O  
ATOM   8917  OD2 ASP F  44      -2.557  -8.508  44.929  1.00 19.75           O  
ATOM   8918  N   ALA F  45      -2.596  -3.059  46.239  1.00 22.37           N  
ATOM   8919  CA  ALA F  45      -2.112  -1.904  46.998  1.00 20.19           C  
ATOM   8920  C   ALA F  45      -3.151  -1.242  47.878  1.00 18.88           C  
ATOM   8921  O   ALA F  45      -2.846  -0.872  49.011  1.00 19.60           O  
ATOM   8922  CB  ALA F  45      -1.499  -0.883  46.068  1.00 19.97           C  
ATOM   8923  N   ALA F  46      -4.377  -1.097  47.383  1.00 16.87           N  
ATOM   8924  CA  ALA F  46      -5.423  -0.457  48.185  1.00 13.55           C  
ATOM   8925  C   ALA F  46      -5.680  -1.243  49.469  1.00 11.92           C  
ATOM   8926  O   ALA F  46      -5.825  -0.658  50.541  1.00 13.35           O  
ATOM   8927  CB  ALA F  46      -6.696  -0.309  47.387  1.00 12.88           C  
ATOM   8928  N   GLY F  47      -5.674  -2.568  49.359  1.00  8.52           N  
ATOM   8929  CA  GLY F  47      -5.901  -3.421  50.510  1.00  6.56           C  
ATOM   8930  C   GLY F  47      -4.781  -3.338  51.522  1.00  8.09           C  
ATOM   8931  O   GLY F  47      -4.987  -3.568  52.716  1.00  8.24           O  
ATOM   8932  N   VAL F  48      -3.586  -3.006  51.051  1.00  8.38           N  
ATOM   8933  CA  VAL F  48      -2.437  -2.871  51.941  1.00  9.61           C  
ATOM   8934  C   VAL F  48      -2.600  -1.587  52.768  1.00 11.17           C  
ATOM   8935  O   VAL F  48      -2.643  -1.618  54.003  1.00  9.56           O  
ATOM   8936  CB  VAL F  48      -1.144  -2.810  51.135  1.00  8.60           C  
ATOM   8937  CG1 VAL F  48       0.037  -2.594  52.039  1.00  9.09           C  
ATOM   8938  CG2 VAL F  48      -0.988  -4.073  50.355  1.00  6.15           C  
ATOM   8939  N   PHE F  49      -2.770  -0.470  52.068  1.00 12.49           N  
ATOM   8940  CA  PHE F  49      -2.939   0.819  52.717  1.00 14.46           C  
ATOM   8941  C   PHE F  49      -4.147   0.869  53.677  1.00 15.14           C  
ATOM   8942  O   PHE F  49      -4.142   1.619  54.662  1.00 15.33           O  
ATOM   8943  CB  PHE F  49      -3.039   1.915  51.654  1.00 15.16           C  
ATOM   8944  CG  PHE F  49      -3.215   3.288  52.223  1.00 18.28           C  
ATOM   8945  CD1 PHE F  49      -2.117   4.000  52.699  1.00 20.07           C  
ATOM   8946  CD2 PHE F  49      -4.494   3.846  52.345  1.00 19.21           C  
ATOM   8947  CE1 PHE F  49      -2.283   5.241  53.298  1.00 21.40           C  
ATOM   8948  CE2 PHE F  49      -4.676   5.087  52.940  1.00 18.71           C  
ATOM   8949  CZ  PHE F  49      -3.569   5.787  53.421  1.00 22.58           C  
ATOM   8950  N   GLU F  50      -5.167   0.060  53.420  1.00 13.44           N  
ATOM   8951  CA  GLU F  50      -6.340   0.050  54.284  1.00 15.00           C  
ATOM   8952  C   GLU F  50      -6.014  -0.630  55.615  1.00 14.26           C  
ATOM   8953  O   GLU F  50      -6.622  -0.328  56.656  1.00 12.58           O  
ATOM   8954  CB  GLU F  50      -7.498  -0.655  53.576  1.00 19.33           C  
ATOM   8955  CG  GLU F  50      -8.884  -0.240  54.072  1.00 25.54           C  
ATOM   8956  CD  GLU F  50      -9.031   1.279  54.061  1.00 27.55           C  
ATOM   8957  OE1 GLU F  50      -9.600   1.829  55.033  1.00 27.73           O  
ATOM   8958  OE2 GLU F  50      -8.582   1.914  53.077  1.00 29.12           O  
ATOM   8959  N   ILE F  51      -5.063  -1.565  55.565  1.00 14.39           N  
ATOM   8960  CA  ILE F  51      -4.605  -2.289  56.753  1.00 12.29           C  
ATOM   8961  C   ILE F  51      -3.633  -1.377  57.464  1.00 10.76           C  
ATOM   8962  O   ILE F  51      -3.612  -1.320  58.689  1.00 12.18           O  
ATOM   8963  CB  ILE F  51      -3.909  -3.627  56.400  1.00 13.52           C  
ATOM   8964  CG1 ILE F  51      -4.913  -4.587  55.761  1.00 14.97           C  
ATOM   8965  CG2 ILE F  51      -3.349  -4.291  57.644  1.00 13.09           C  
ATOM   8966  CD1 ILE F  51      -4.345  -5.968  55.526  1.00 17.04           C  
ATOM   8967  N   GLU F  52      -2.867  -0.623  56.685  1.00  9.06           N  
ATOM   8968  CA  GLU F  52      -1.911   0.326  57.237  1.00  9.40           C  
ATOM   8969  C   GLU F  52      -2.607   1.459  57.957  1.00  9.87           C  
ATOM   8970  O   GLU F  52      -2.081   1.970  58.949  1.00 11.08           O  
ATOM   8971  CB  GLU F  52      -0.979   0.857  56.160  1.00  9.55           C  
ATOM   8972  CG  GLU F  52       0.002  -0.213  55.723  1.00 10.98           C  
ATOM   8973  CD  GLU F  52       1.131   0.393  54.956  1.00 11.67           C  
ATOM   8974  OE1 GLU F  52       1.014   0.473  53.716  1.00 11.82           O  
ATOM   8975  OE2 GLU F  52       2.131   0.787  55.595  1.00 12.48           O  
ATOM   8976  N   ARG F  53      -3.794   1.843  57.493  1.00 10.22           N  
ATOM   8977  CA  ARG F  53      -4.533   2.900  58.177  1.00 12.01           C  
ATOM   8978  C   ARG F  53      -4.790   2.407  59.612  1.00 12.82           C  
ATOM   8979  O   ARG F  53      -4.317   3.004  60.583  1.00 12.42           O  
ATOM   8980  CB  ARG F  53      -5.857   3.201  57.466  1.00 12.74           C  
ATOM   8981  CG  ARG F  53      -6.392   4.614  57.733  1.00  9.77           C  
ATOM   8982  CD  ARG F  53      -7.906   4.678  57.638  1.00  9.06           C  
ATOM   8983  NE  ARG F  53      -8.413   4.611  56.275  1.00 13.52           N  
ATOM   8984  CZ  ARG F  53      -8.487   5.653  55.441  1.00 19.07           C  
ATOM   8985  NH1 ARG F  53      -8.085   6.868  55.815  1.00 17.86           N  
ATOM   8986  NH2 ARG F  53      -8.982   5.483  54.220  1.00 18.47           N  
ATOM   8987  N   GLU F  54      -5.432   1.251  59.730  1.00 15.59           N  
ATOM   8988  CA  GLU F  54      -5.716   0.676  61.034  1.00 15.79           C  
ATOM   8989  C   GLU F  54      -4.447   0.386  61.839  1.00 15.00           C  
ATOM   8990  O   GLU F  54      -4.289   0.882  62.946  1.00 14.41           O  
ATOM   8991  CB  GLU F  54      -6.530  -0.619  60.870  1.00 16.92           C  
ATOM   8992  CG  GLU F  54      -6.975  -1.303  62.195  1.00 19.57           C  
ATOM   8993  CD  GLU F  54      -5.823  -2.066  62.846  1.00 18.27           C  
ATOM   8994  OE1 GLU F  54      -5.316  -3.023  62.224  1.00 19.52           O  
ATOM   8995  OE2 GLU F  54      -5.415  -1.709  63.970  1.00 17.43           O  
ATOM   8996  N   ALA F  55      -3.564  -0.426  61.269  1.00 15.68           N  
ATOM   8997  CA  ALA F  55      -2.328  -0.876  61.918  1.00 16.47           C  
ATOM   8998  C   ALA F  55      -1.231   0.113  62.293  1.00 16.61           C  
ATOM   8999  O   ALA F  55      -0.577  -0.050  63.329  1.00 13.64           O  
ATOM   9000  CB  ALA F  55      -1.711  -2.033  61.103  1.00 18.81           C  
ATOM   9001  N   PHE F  56      -0.992   1.101  61.437  1.00 18.94           N  
ATOM   9002  CA  PHE F  56       0.073   2.071  61.684  1.00 19.85           C  
ATOM   9003  C   PHE F  56      -0.393   3.499  61.927  1.00 20.36           C  
ATOM   9004  O   PHE F  56       0.005   4.147  62.907  1.00 21.79           O  
ATOM   9005  CB  PHE F  56       1.046   2.076  60.507  1.00 19.45           C  
ATOM   9006  CG  PHE F  56       1.784   0.784  60.307  1.00 18.14           C  
ATOM   9007  CD1 PHE F  56       2.714   0.345  61.240  1.00 17.94           C  
ATOM   9008  CD2 PHE F  56       1.597   0.037  59.152  1.00 19.82           C  
ATOM   9009  CE1 PHE F  56       3.457  -0.822  61.024  1.00 18.38           C  
ATOM   9010  CE2 PHE F  56       2.334  -1.131  58.924  1.00 19.05           C  
ATOM   9011  CZ  PHE F  56       3.266  -1.558  59.863  1.00 17.84           C  
ATOM   9012  N   ILE F  57      -1.236   3.994  61.032  1.00 22.51           N  
ATOM   9013  CA  ILE F  57      -1.733   5.364  61.124  1.00 23.75           C  
ATOM   9014  C   ILE F  57      -2.584   5.679  62.356  1.00 26.82           C  
ATOM   9015  O   ILE F  57      -2.558   6.797  62.860  1.00 29.45           O  
ATOM   9016  CB  ILE F  57      -2.518   5.763  59.861  1.00 20.19           C  
ATOM   9017  CG1 ILE F  57      -1.721   5.390  58.608  1.00 20.15           C  
ATOM   9018  CG2 ILE F  57      -2.736   7.240  59.859  1.00 17.30           C  
ATOM   9019  CD1 ILE F  57      -2.445   5.670  57.296  1.00 16.78           C  
ATOM   9020  N   SER F  58      -3.300   4.696  62.876  1.00 29.26           N  
ATOM   9021  CA  SER F  58      -4.148   4.939  64.031  1.00 28.34           C  
ATOM   9022  C   SER F  58      -3.397   5.032  65.344  1.00 29.01           C  
ATOM   9023  O   SER F  58      -3.905   5.595  66.309  1.00 28.08           O  
ATOM   9024  CB  SER F  58      -5.190   3.845  64.134  1.00 28.37           C  
ATOM   9025  OG  SER F  58      -4.666   2.669  64.735  1.00 25.69           O  
ATOM   9026  N   VAL F  59      -2.203   4.451  65.399  1.00 28.93           N  
ATOM   9027  CA  VAL F  59      -1.431   4.475  66.639  1.00 30.14           C  
ATOM   9028  C   VAL F  59      -0.440   5.637  66.656  1.00 30.57           C  
ATOM   9029  O   VAL F  59      -0.432   6.467  67.562  1.00 31.52           O  
ATOM   9030  CB  VAL F  59      -0.673   3.125  66.882  1.00 27.46           C  
ATOM   9031  CG1 VAL F  59       0.016   3.136  68.239  1.00 26.60           C  
ATOM   9032  CG2 VAL F  59      -1.640   1.954  66.817  1.00 27.50           C  
ATOM   9033  N   SER F  60       0.363   5.714  65.615  1.00 30.68           N  
ATOM   9034  CA  SER F  60       1.386   6.741  65.523  1.00 29.35           C  
ATOM   9035  C   SER F  60       1.061   7.908  64.589  1.00 28.57           C  
ATOM   9036  O   SER F  60       1.772   8.916  64.594  1.00 27.95           O  
ATOM   9037  CB  SER F  60       2.718   6.082  65.098  1.00 30.68           C  
ATOM   9038  OG  SER F  60       2.540   4.765  64.552  1.00 30.70           O  
ATOM   9039  N   GLY F  61       0.006   7.784  63.785  1.00 28.52           N  
ATOM   9040  CA  GLY F  61      -0.332   8.849  62.852  1.00 27.69           C  
ATOM   9041  C   GLY F  61       0.571   8.794  61.626  1.00 29.54           C  
ATOM   9042  O   GLY F  61       0.523   9.662  60.758  1.00 26.57           O  
ATOM   9043  N   ASN F  62       1.369   7.729  61.549  1.00 31.37           N  
ATOM   9044  CA  ASN F  62       2.319   7.493  60.466  1.00 30.84           C  
ATOM   9045  C   ASN F  62       2.207   6.036  60.032  1.00 29.46           C  
ATOM   9046  O   ASN F  62       1.665   5.210  60.772  1.00 28.54           O  
ATOM   9047  CB  ASN F  62       3.751   7.720  60.976  1.00 33.33           C  
ATOM   9048  CG  ASN F  62       4.293   9.088  60.626  1.00 36.28           C  
ATOM   9049  OD1 ASN F  62       4.523   9.402  59.452  1.00 36.57           O  
ATOM   9050  ND2 ASN F  62       4.524   9.907  61.647  1.00 38.13           N  
ATOM   9051  N   CYS F  63       2.707   5.725  58.838  1.00 27.81           N  
ATOM   9052  CA  CYS F  63       2.720   4.353  58.332  1.00 27.28           C  
ATOM   9053  C   CYS F  63       3.926   4.178  57.403  1.00 24.24           C  
ATOM   9054  O   CYS F  63       4.407   5.149  56.814  1.00 24.95           O  
ATOM   9055  CB  CYS F  63       1.410   3.983  57.630  1.00 28.62           C  
ATOM   9056  SG  CYS F  63       1.195   4.634  55.991  1.00 31.57           S  
ATOM   9057  N   PRO F  64       4.452   2.942  57.291  1.00 21.53           N  
ATOM   9058  CA  PRO F  64       5.612   2.613  56.449  1.00 18.97           C  
ATOM   9059  C   PRO F  64       5.536   3.105  55.005  1.00 17.29           C  
ATOM   9060  O   PRO F  64       6.449   3.765  54.517  1.00 15.80           O  
ATOM   9061  CB  PRO F  64       5.639   1.087  56.496  1.00 19.55           C  
ATOM   9062  CG  PRO F  64       5.087   0.782  57.836  1.00 19.33           C  
ATOM   9063  CD  PRO F  64       3.926   1.726  57.931  1.00 19.42           C  
ATOM   9064  N   LEU F  65       4.454   2.759  54.320  1.00 15.28           N  
ATOM   9065  CA  LEU F  65       4.279   3.147  52.936  1.00 14.89           C  
ATOM   9066  C   LEU F  65       2.872   3.631  52.637  1.00 14.11           C  
ATOM   9067  O   LEU F  65       1.887   3.020  53.054  1.00 11.82           O  
ATOM   9068  CB  LEU F  65       4.555   1.954  52.026  1.00 15.94           C  
ATOM   9069  CG  LEU F  65       5.884   1.210  52.081  1.00 14.73           C  
ATOM   9070  CD1 LEU F  65       5.673  -0.185  51.513  1.00 15.93           C  
ATOM   9071  CD2 LEU F  65       6.970   1.973  51.336  1.00 11.47           C  
ATOM   9072  N   ASN F  66       2.784   4.733  51.907  1.00 13.30           N  
ATOM   9073  CA  ASN F  66       1.495   5.267  51.510  1.00 13.55           C  
ATOM   9074  C   ASN F  66       1.129   4.527  50.215  1.00 13.37           C  
ATOM   9075  O   ASN F  66       2.000   3.929  49.592  1.00 12.81           O  
ATOM   9076  CB  ASN F  66       1.569   6.787  51.301  1.00 13.40           C  
ATOM   9077  CG  ASN F  66       2.502   7.186  50.166  1.00 14.21           C  
ATOM   9078  OD1 ASN F  66       2.285   6.832  49.012  1.00 11.98           O  
ATOM   9079  ND2 ASN F  66       3.543   7.935  50.495  1.00 17.00           N  
ATOM   9080  N   LEU F  67      -0.132   4.591  49.794  1.00 15.67           N  
ATOM   9081  CA  LEU F  67      -0.589   3.886  48.593  1.00 15.41           C  
ATOM   9082  C   LEU F  67       0.342   3.978  47.391  1.00 18.36           C  
ATOM   9083  O   LEU F  67       0.661   2.957  46.772  1.00 17.69           O  
ATOM   9084  CB  LEU F  67      -1.985   4.336  48.184  1.00 12.27           C  
ATOM   9085  CG  LEU F  67      -2.654   3.378  47.193  1.00 11.12           C  
ATOM   9086  CD1 LEU F  67      -3.843   2.697  47.848  1.00  8.30           C  
ATOM   9087  CD2 LEU F  67      -3.094   4.133  45.970  1.00 13.34           C  
ATOM   9088  N   ASP F  68       0.780   5.188  47.063  1.00 21.01           N  
ATOM   9089  CA  ASP F  68       1.690   5.399  45.941  1.00 22.95           C  
ATOM   9090  C   ASP F  68       2.972   4.569  46.142  1.00 21.37           C  
ATOM   9091  O   ASP F  68       3.368   3.800  45.268  1.00 20.65           O  
ATOM   9092  CB  ASP F  68       2.014   6.898  45.834  1.00 29.70           C  
ATOM   9093  CG  ASP F  68       3.195   7.189  44.914  1.00 35.79           C  
ATOM   9094  OD1 ASP F  68       2.978   7.268  43.687  1.00 40.58           O  
ATOM   9095  OD2 ASP F  68       4.335   7.344  45.417  1.00 35.90           O  
ATOM   9096  N   GLU F  69       3.594   4.708  47.309  1.00 21.61           N  
ATOM   9097  CA  GLU F  69       4.820   3.987  47.637  1.00 20.02           C  
ATOM   9098  C   GLU F  69       4.616   2.478  47.591  1.00 19.84           C  
ATOM   9099  O   GLU F  69       5.507   1.751  47.157  1.00 21.95           O  
ATOM   9100  CB  GLU F  69       5.315   4.395  49.024  1.00 16.87           C  
ATOM   9101  CG  GLU F  69       5.510   5.870  49.188  1.00 15.71           C  
ATOM   9102  CD  GLU F  69       6.190   6.165  50.497  1.00 17.51           C  
ATOM   9103  OE1 GLU F  69       5.545   6.021  51.562  1.00 19.11           O  
ATOM   9104  OE2 GLU F  69       7.378   6.547  50.458  1.00 18.00           O  
ATOM   9105  N   VAL F  70       3.453   2.017  48.047  1.00 18.92           N  
ATOM   9106  CA  VAL F  70       3.121   0.587  48.053  1.00 19.85           C  
ATOM   9107  C   VAL F  70       2.994   0.086  46.611  1.00 20.01           C  
ATOM   9108  O   VAL F  70       3.569  -0.938  46.241  1.00 17.30           O  
ATOM   9109  CB  VAL F  70       1.782   0.329  48.786  1.00 19.36           C  
ATOM   9110  CG1 VAL F  70       1.374  -1.118  48.650  1.00 21.12           C  
ATOM   9111  CG2 VAL F  70       1.903   0.685  50.247  1.00 20.95           C  
ATOM   9112  N   GLN F  71       2.241   0.825  45.801  1.00 20.21           N  
ATOM   9113  CA  GLN F  71       2.045   0.471  44.404  1.00 20.96           C  
ATOM   9114  C   GLN F  71       3.379   0.438  43.702  1.00 20.26           C  
ATOM   9115  O   GLN F  71       3.625  -0.436  42.862  1.00 21.94           O  
ATOM   9116  CB  GLN F  71       1.151   1.485  43.696  1.00 22.17           C  
ATOM   9117  CG  GLN F  71      -0.313   1.314  43.976  1.00 24.54           C  
ATOM   9118  CD  GLN F  71      -1.095   2.403  43.289  1.00 25.23           C  
ATOM   9119  OE1 GLN F  71      -0.614   3.531  43.136  1.00 23.55           O  
ATOM   9120  NE2 GLN F  71      -2.312   2.076  42.862  1.00 25.55           N  
ATOM   9121  N   HIS F  72       4.251   1.378  44.046  1.00 18.55           N  
ATOM   9122  CA  HIS F  72       5.560   1.433  43.418  1.00 16.98           C  
ATOM   9123  C   HIS F  72       6.316   0.111  43.569  1.00 17.08           C  
ATOM   9124  O   HIS F  72       6.664  -0.534  42.568  1.00 17.96           O  
ATOM   9125  CB  HIS F  72       6.394   2.563  43.996  1.00 12.53           C  
ATOM   9126  CG  HIS F  72       7.782   2.607  43.447  1.00  9.34           C  
ATOM   9127  ND1 HIS F  72       8.901   2.511  44.244  1.00  6.67           N  
ATOM   9128  CD2 HIS F  72       8.229   2.718  42.172  1.00  4.43           C  
ATOM   9129  CE1 HIS F  72       9.982   2.565  43.486  1.00 10.72           C  
ATOM   9130  NE2 HIS F  72       9.599   2.688  42.226  1.00  7.21           N  
ATOM   9131  N   PHE F  73       6.541  -0.310  44.812  1.00 12.86           N  
ATOM   9132  CA  PHE F  73       7.255  -1.547  45.055  1.00 12.63           C  
ATOM   9133  C   PHE F  73       6.585  -2.781  44.439  1.00 14.41           C  
ATOM   9134  O   PHE F  73       7.274  -3.685  43.973  1.00 17.81           O  
ATOM   9135  CB  PHE F  73       7.491  -1.737  46.545  1.00 11.95           C  
ATOM   9136  CG  PHE F  73       8.610  -0.893  47.092  1.00 13.28           C  
ATOM   9137  CD1 PHE F  73       9.752  -0.652  46.334  1.00 12.00           C  
ATOM   9138  CD2 PHE F  73       8.523  -0.334  48.360  1.00 10.93           C  
ATOM   9139  CE1 PHE F  73      10.789   0.137  46.832  1.00 13.41           C  
ATOM   9140  CE2 PHE F  73       9.556   0.453  48.864  1.00 10.99           C  
ATOM   9141  CZ  PHE F  73      10.689   0.689  48.096  1.00 11.95           C  
ATOM   9142  N   LEU F  74       5.256  -2.806  44.375  1.00 12.80           N  
ATOM   9143  CA  LEU F  74       4.561  -3.952  43.798  1.00 10.91           C  
ATOM   9144  C   LEU F  74       4.673  -4.028  42.274  1.00 13.53           C  
ATOM   9145  O   LEU F  74       4.486  -5.096  41.696  1.00 11.64           O  
ATOM   9146  CB  LEU F  74       3.096  -3.984  44.237  1.00  6.95           C  
ATOM   9147  CG  LEU F  74       2.875  -4.273  45.720  1.00  3.37           C  
ATOM   9148  CD1 LEU F  74       1.411  -4.467  45.968  1.00  2.38           C  
ATOM   9149  CD2 LEU F  74       3.630  -5.524  46.146  1.00  3.01           C  
ATOM   9150  N   THR F  75       4.956  -2.897  41.627  1.00 13.44           N  
ATOM   9151  CA  THR F  75       5.110  -2.861  40.175  1.00 11.45           C  
ATOM   9152  C   THR F  75       6.580  -3.109  39.857  1.00 11.16           C  
ATOM   9153  O   THR F  75       6.899  -3.873  38.960  1.00 13.32           O  
ATOM   9154  CB  THR F  75       4.732  -1.485  39.595  1.00 10.86           C  
ATOM   9155  OG1 THR F  75       3.489  -1.048  40.152  1.00 14.71           O  
ATOM   9156  CG2 THR F  75       4.591  -1.565  38.083  1.00 11.00           C  
ATOM   9157  N   LEU F  76       7.466  -2.488  40.634  1.00  8.93           N  
ATOM   9158  CA  LEU F  76       8.906  -2.613  40.453  1.00  7.98           C  
ATOM   9159  C   LEU F  76       9.451  -3.975  40.844  1.00  7.19           C  
ATOM   9160  O   LEU F  76      10.211  -4.576  40.086  1.00  8.28           O  
ATOM   9161  CB  LEU F  76       9.633  -1.542  41.269  1.00  7.75           C  
ATOM   9162  CG  LEU F  76      10.807  -0.767  40.648  1.00  6.18           C  
ATOM   9163  CD1 LEU F  76      11.590  -0.097  41.763  1.00  2.00           C  
ATOM   9164  CD2 LEU F  76      11.719  -1.658  39.835  1.00  2.00           C  
ATOM   9165  N   CYS F  77       9.109  -4.438  42.044  1.00  7.03           N  
ATOM   9166  CA  CYS F  77       9.592  -5.728  42.517  1.00  5.97           C  
ATOM   9167  C   CYS F  77       8.570  -6.555  43.298  1.00  4.79           C  
ATOM   9168  O   CYS F  77       8.737  -6.818  44.481  1.00  2.51           O  
ATOM   9169  CB  CYS F  77      10.878  -5.538  43.328  1.00  8.78           C  
ATOM   9170  SG  CYS F  77      10.795  -4.314  44.674  1.00 11.09           S  
ATOM   9171  N   PRO F  78       7.507  -7.015  42.627  1.00  7.40           N  
ATOM   9172  CA  PRO F  78       6.485  -7.820  43.303  1.00  7.39           C  
ATOM   9173  C   PRO F  78       7.021  -9.129  43.893  1.00  8.27           C  
ATOM   9174  O   PRO F  78       6.473  -9.659  44.858  1.00 10.28           O  
ATOM   9175  CB  PRO F  78       5.463  -8.075  42.193  1.00  8.72           C  
ATOM   9176  CG  PRO F  78       6.271  -7.985  40.937  1.00  8.50           C  
ATOM   9177  CD  PRO F  78       7.163  -6.816  41.205  1.00  7.77           C  
ATOM   9178  N   GLU F  79       8.102  -9.648  43.327  1.00  9.24           N  
ATOM   9179  CA  GLU F  79       8.688 -10.892  43.813  1.00  8.75           C  
ATOM   9180  C   GLU F  79       9.313 -10.726  45.198  1.00  8.38           C  
ATOM   9181  O   GLU F  79       9.708 -11.702  45.839  1.00 10.15           O  
ATOM   9182  CB  GLU F  79       9.724 -11.423  42.818  1.00  6.41           C  
ATOM   9183  CG  GLU F  79      11.011 -10.623  42.720  1.00  2.30           C  
ATOM   9184  CD  GLU F  79      10.846  -9.344  41.907  1.00  3.55           C  
ATOM   9185  OE1 GLU F  79       9.844  -9.168  41.189  1.00  6.60           O  
ATOM   9186  OE2 GLU F  79      11.762  -8.505  41.960  1.00  6.67           O  
ATOM   9187  N   LEU F  80       9.434  -9.483  45.644  1.00  8.96           N  
ATOM   9188  CA  LEU F  80       9.995  -9.207  46.958  1.00  8.80           C  
ATOM   9189  C   LEU F  80       8.871  -8.895  47.933  1.00  7.77           C  
ATOM   9190  O   LEU F  80       9.087  -8.310  48.982  1.00  5.98           O  
ATOM   9191  CB  LEU F  80      11.012  -8.069  46.875  1.00 10.80           C  
ATOM   9192  CG  LEU F  80      12.361  -8.432  46.234  1.00 11.46           C  
ATOM   9193  CD1 LEU F  80      13.056  -7.201  45.727  1.00 10.95           C  
ATOM   9194  CD2 LEU F  80      13.219  -9.150  47.236  1.00  9.37           C  
ATOM   9195  N   SER F  81       7.664  -9.314  47.571  1.00  8.57           N  
ATOM   9196  CA  SER F  81       6.492  -9.107  48.401  1.00  9.43           C  
ATOM   9197  C   SER F  81       5.802 -10.455  48.592  1.00 10.90           C  
ATOM   9198  O   SER F  81       6.054 -11.398  47.843  1.00 13.21           O  
ATOM   9199  CB  SER F  81       5.536  -8.102  47.749  1.00  7.39           C  
ATOM   9200  OG  SER F  81       4.772  -8.705  46.724  1.00  4.57           O  
ATOM   9201  N   LEU F  82       4.958 -10.556  49.611  1.00 13.19           N  
ATOM   9202  CA  LEU F  82       4.241 -11.795  49.883  1.00 12.34           C  
ATOM   9203  C   LEU F  82       3.052 -11.554  50.813  1.00 12.62           C  
ATOM   9204  O   LEU F  82       3.175 -10.824  51.805  1.00 10.49           O  
ATOM   9205  CB  LEU F  82       5.179 -12.830  50.510  1.00  9.69           C  
ATOM   9206  CG  LEU F  82       4.637 -14.262  50.594  1.00  8.90           C  
ATOM   9207  CD1 LEU F  82       4.478 -14.840  49.188  1.00  8.07           C  
ATOM   9208  CD2 LEU F  82       5.562 -15.142  51.423  1.00  6.91           C  
ATOM   9209  N   GLY F  83       1.908 -12.151  50.481  1.00 10.42           N  
ATOM   9210  CA  GLY F  83       0.733 -12.002  51.313  1.00 12.20           C  
ATOM   9211  C   GLY F  83       0.024 -13.314  51.585  1.00 14.28           C  
ATOM   9212  O   GLY F  83       0.097 -14.242  50.784  1.00 13.16           O  
ATOM   9213  N   TRP F  84      -0.608 -13.419  52.751  1.00 16.73           N  
ATOM   9214  CA  TRP F  84      -1.385 -14.608  53.109  1.00 15.19           C  
ATOM   9215  C   TRP F  84      -2.818 -14.264  52.686  1.00 12.89           C  
ATOM   9216  O   TRP F  84      -3.395 -13.270  53.140  1.00 14.54           O  
ATOM   9217  CB  TRP F  84      -1.316 -14.892  54.625  1.00 18.99           C  
ATOM   9218  CG  TRP F  84      -2.154 -16.085  55.121  1.00 23.34           C  
ATOM   9219  CD1 TRP F  84      -3.431 -16.396  54.761  1.00 24.30           C  
ATOM   9220  CD2 TRP F  84      -1.760 -17.087  56.080  1.00 26.58           C  
ATOM   9221  NE1 TRP F  84      -3.860 -17.519  55.426  1.00 23.69           N  
ATOM   9222  CE2 TRP F  84      -2.858 -17.969  56.237  1.00 27.65           C  
ATOM   9223  CE3 TRP F  84      -0.589 -17.326  56.819  1.00 28.20           C  
ATOM   9224  CZ2 TRP F  84      -2.821 -19.084  57.115  1.00 31.39           C  
ATOM   9225  CZ3 TRP F  84      -0.552 -18.437  57.696  1.00 28.69           C  
ATOM   9226  CH2 TRP F  84      -1.662 -19.301  57.829  1.00 29.22           C  
ATOM   9227  N   PHE F  85      -3.350 -15.042  51.756  1.00 10.58           N  
ATOM   9228  CA  PHE F  85      -4.696 -14.855  51.252  1.00  8.85           C  
ATOM   9229  C   PHE F  85      -5.616 -15.914  51.818  1.00 10.40           C  
ATOM   9230  O   PHE F  85      -5.453 -17.098  51.526  1.00 12.02           O  
ATOM   9231  CB  PHE F  85      -4.709 -14.951  49.729  1.00  5.79           C  
ATOM   9232  CG  PHE F  85      -4.052 -13.790  49.048  1.00  4.62           C  
ATOM   9233  CD1 PHE F  85      -2.668 -13.743  48.908  1.00  3.34           C  
ATOM   9234  CD2 PHE F  85      -4.814 -12.747  48.532  1.00  2.00           C  
ATOM   9235  CE1 PHE F  85      -2.052 -12.675  48.258  1.00  2.00           C  
ATOM   9236  CE2 PHE F  85      -4.210 -11.680  47.884  1.00  2.00           C  
ATOM   9237  CZ  PHE F  85      -2.818 -11.649  47.748  1.00  2.18           C  
ATOM   9238  N   VAL F  86      -6.551 -15.504  52.664  1.00 11.26           N  
ATOM   9239  CA  VAL F  86      -7.509 -16.429  53.243  1.00  9.84           C  
ATOM   9240  C   VAL F  86      -8.681 -16.509  52.281  1.00 11.00           C  
ATOM   9241  O   VAL F  86      -9.467 -15.563  52.145  1.00  9.79           O  
ATOM   9242  CB  VAL F  86      -7.969 -15.965  54.628  1.00  9.20           C  
ATOM   9243  CG1 VAL F  86      -9.194 -16.738  55.064  1.00 13.05           C  
ATOM   9244  CG2 VAL F  86      -6.862 -16.198  55.632  1.00  9.31           C  
ATOM   9245  N   GLU F  87      -8.728 -17.620  51.550  1.00 10.12           N  
ATOM   9246  CA  GLU F  87      -9.772 -17.886  50.563  1.00  8.08           C  
ATOM   9247  C   GLU F  87     -10.051 -16.706  49.628  1.00  6.23           C  
ATOM   9248  O   GLU F  87     -11.201 -16.375  49.356  1.00  5.39           O  
ATOM   9249  CB  GLU F  87     -11.035 -18.393  51.264  1.00  8.29           C  
ATOM   9250  CG  GLU F  87     -10.782 -19.739  51.938  1.00 11.29           C  
ATOM   9251  CD  GLU F  87     -12.047 -20.317  52.537  1.00 12.80           C  
ATOM   9252  OE1 GLU F  87     -12.322 -20.031  53.714  1.00 18.01           O  
ATOM   9253  OE2 GLU F  87     -12.761 -21.074  51.850  1.00  6.04           O  
ATOM   9254  N   GLY F  88      -8.976 -16.098  49.121  1.00  4.75           N  
ATOM   9255  CA  GLY F  88      -9.103 -14.966  48.218  1.00  4.85           C  
ATOM   9256  C   GLY F  88      -9.043 -13.586  48.850  1.00  2.78           C  
ATOM   9257  O   GLY F  88      -9.001 -12.579  48.139  1.00  2.00           O  
ATOM   9258  N   ARG F  89      -9.043 -13.539  50.180  1.00  3.91           N  
ATOM   9259  CA  ARG F  89      -8.994 -12.277  50.901  1.00  5.04           C  
ATOM   9260  C   ARG F  89      -7.600 -12.028  51.436  1.00  3.23           C  
ATOM   9261  O   ARG F  89      -7.030 -12.894  52.085  1.00  2.00           O  
ATOM   9262  CB  ARG F  89     -10.000 -12.285  52.053  1.00  6.76           C  
ATOM   9263  CG  ARG F  89     -10.036 -10.996  52.847  1.00 11.05           C  
ATOM   9264  CD  ARG F  89     -11.058 -11.054  53.959  1.00 12.04           C  
ATOM   9265  NE  ARG F  89     -11.114  -9.797  54.703  1.00 12.24           N  
ATOM   9266  CZ  ARG F  89     -11.693  -9.646  55.889  1.00  8.85           C  
ATOM   9267  NH1 ARG F  89     -12.277 -10.673  56.493  1.00  7.19           N  
ATOM   9268  NH2 ARG F  89     -11.689  -8.461  56.470  1.00  5.59           N  
ATOM   9269  N   LEU F  90      -7.037 -10.862  51.140  1.00  2.00           N  
ATOM   9270  CA  LEU F  90      -5.706 -10.531  51.623  1.00  2.19           C  
ATOM   9271  C   LEU F  90      -5.813 -10.112  53.077  1.00  4.57           C  
ATOM   9272  O   LEU F  90      -6.461  -9.109  53.390  1.00  6.68           O  
ATOM   9273  CB  LEU F  90      -5.105  -9.391  50.802  1.00  3.56           C  
ATOM   9274  CG  LEU F  90      -3.680  -8.952  51.164  1.00  5.70           C  
ATOM   9275  CD1 LEU F  90      -2.720 -10.156  51.084  1.00  3.40           C  
ATOM   9276  CD2 LEU F  90      -3.239  -7.820  50.226  1.00  2.38           C  
ATOM   9277  N   VAL F  91      -5.191 -10.868  53.977  1.00  5.50           N  
ATOM   9278  CA  VAL F  91      -5.269 -10.512  55.390  1.00  5.47           C  
ATOM   9279  C   VAL F  91      -3.929 -10.210  56.083  1.00  6.31           C  
ATOM   9280  O   VAL F  91      -3.911  -9.779  57.234  1.00  6.34           O  
ATOM   9281  CB  VAL F  91      -6.055 -11.574  56.180  1.00  5.37           C  
ATOM   9282  CG1 VAL F  91      -7.436 -11.712  55.603  1.00  2.89           C  
ATOM   9283  CG2 VAL F  91      -5.337 -12.899  56.149  1.00  3.91           C  
ATOM   9284  N   ALA F  92      -2.815 -10.423  55.386  1.00  7.29           N  
ATOM   9285  CA  ALA F  92      -1.485 -10.176  55.949  1.00  6.54           C  
ATOM   9286  C   ALA F  92      -0.479 -10.022  54.809  1.00  6.83           C  
ATOM   9287  O   ALA F  92      -0.494 -10.803  53.856  1.00  8.35           O  
ATOM   9288  CB  ALA F  92      -1.087 -11.326  56.856  1.00  5.38           C  
ATOM   9289  N   PHE F  93       0.448  -9.072  54.953  1.00  5.80           N  
ATOM   9290  CA  PHE F  93       1.423  -8.789  53.906  1.00  2.52           C  
ATOM   9291  C   PHE F  93       2.806  -8.431  54.400  1.00  2.00           C  
ATOM   9292  O   PHE F  93       3.008  -8.184  55.571  1.00  2.00           O  
ATOM   9293  CB  PHE F  93       0.936  -7.613  53.045  1.00  2.83           C  
ATOM   9294  CG  PHE F  93       0.905  -6.295  53.779  1.00  5.51           C  
ATOM   9295  CD1 PHE F  93       2.039  -5.497  53.859  1.00  6.48           C  
ATOM   9296  CD2 PHE F  93      -0.248  -5.874  54.436  1.00  4.79           C  
ATOM   9297  CE1 PHE F  93       2.031  -4.305  54.587  1.00  6.37           C  
ATOM   9298  CE2 PHE F  93      -0.264  -4.684  55.168  1.00  7.86           C  
ATOM   9299  CZ  PHE F  93       0.883  -3.899  55.243  1.00  4.65           C  
ATOM   9300  N   ILE F  94       3.742  -8.387  53.456  1.00  4.58           N  
ATOM   9301  CA  ILE F  94       5.130  -7.989  53.664  1.00  4.76           C  
ATOM   9302  C   ILE F  94       5.514  -7.355  52.328  1.00  5.53           C  
ATOM   9303  O   ILE F  94       5.388  -7.984  51.280  1.00  2.00           O  
ATOM   9304  CB  ILE F  94       6.093  -9.171  53.947  1.00  4.62           C  
ATOM   9305  CG1 ILE F  94       5.835  -9.753  55.338  1.00  6.06           C  
ATOM   9306  CG2 ILE F  94       7.534  -8.700  53.885  1.00  2.00           C  
ATOM   9307  CD1 ILE F  94       6.746 -10.906  55.703  1.00  5.44           C  
ATOM   9308  N   ILE F  95       5.836  -6.067  52.362  1.00  7.79           N  
ATOM   9309  CA  ILE F  95       6.262  -5.354  51.168  1.00 10.69           C  
ATOM   9310  C   ILE F  95       7.772  -5.178  51.303  1.00 10.98           C  
ATOM   9311  O   ILE F  95       8.246  -4.646  52.317  1.00 13.99           O  
ATOM   9312  CB  ILE F  95       5.640  -3.951  51.074  1.00 12.74           C  
ATOM   9313  CG1 ILE F  95       4.117  -4.019  51.192  1.00 14.46           C  
ATOM   9314  CG2 ILE F  95       6.041  -3.297  49.747  1.00 14.93           C  
ATOM   9315  CD1 ILE F  95       3.421  -4.679  50.015  1.00 10.55           C  
ATOM   9316  N   GLY F  96       8.528  -5.609  50.300  1.00  8.80           N  
ATOM   9317  CA  GLY F  96       9.964  -5.478  50.374  1.00  7.46           C  
ATOM   9318  C   GLY F  96      10.573  -4.971  49.092  1.00  9.91           C  
ATOM   9319  O   GLY F  96       9.865  -4.666  48.123  1.00  8.75           O  
ATOM   9320  N   SER F  97      11.895  -4.842  49.121  1.00 10.80           N  
ATOM   9321  CA  SER F  97      12.713  -4.406  47.985  1.00  9.12           C  
ATOM   9322  C   SER F  97      14.156  -4.762  48.366  1.00  8.17           C  
ATOM   9323  O   SER F  97      14.416  -5.185  49.500  1.00  6.87           O  
ATOM   9324  CB  SER F  97      12.567  -2.894  47.712  1.00  8.76           C  
ATOM   9325  OG  SER F  97      13.384  -2.116  48.571  1.00 11.77           O  
ATOM   9326  N   LEU F  98      15.087  -4.610  47.434  1.00  8.45           N  
ATOM   9327  CA  LEU F  98      16.485  -4.943  47.706  1.00  8.15           C  
ATOM   9328  C   LEU F  98      17.321  -3.738  48.096  1.00  7.47           C  
ATOM   9329  O   LEU F  98      17.166  -2.654  47.536  1.00  4.80           O  
ATOM   9330  CB  LEU F  98      17.124  -5.637  46.499  1.00  9.01           C  
ATOM   9331  CG  LEU F  98      16.569  -7.004  46.112  1.00  8.68           C  
ATOM   9332  CD1 LEU F  98      17.257  -7.489  44.879  1.00  6.50           C  
ATOM   9333  CD2 LEU F  98      16.770  -7.976  47.269  1.00 11.51           C  
ATOM   9334  N   TRP F  99      18.208  -3.940  49.059  1.00  7.60           N  
ATOM   9335  CA  TRP F  99      19.089  -2.882  49.533  1.00  8.33           C  
ATOM   9336  C   TRP F  99      20.532  -3.365  49.321  1.00  9.01           C  
ATOM   9337  O   TRP F  99      20.784  -4.579  49.315  1.00  6.16           O  
ATOM   9338  CB  TRP F  99      18.803  -2.571  51.010  1.00  7.25           C  
ATOM   9339  CG  TRP F  99      19.616  -1.423  51.581  1.00  7.97           C  
ATOM   9340  CD1 TRP F  99      20.321  -1.414  52.757  1.00  6.68           C  
ATOM   9341  CD2 TRP F  99      19.790  -0.122  51.000  1.00  9.71           C  
ATOM   9342  NE1 TRP F  99      20.919  -0.191  52.937  1.00  6.92           N  
ATOM   9343  CE2 TRP F  99      20.610   0.621  51.880  1.00  9.03           C  
ATOM   9344  CE3 TRP F  99      19.332   0.489  49.824  1.00 11.00           C  
ATOM   9345  CZ2 TRP F  99      20.982   1.945  51.616  1.00 10.50           C  
ATOM   9346  CZ3 TRP F  99      19.703   1.809  49.563  1.00 12.24           C  
ATOM   9347  CH2 TRP F  99      20.521   2.522  50.460  1.00 12.89           C  
ATOM   9348  N   ASP F 100      21.466  -2.431  49.130  1.00  9.89           N  
ATOM   9349  CA  ASP F 100      22.860  -2.800  48.889  1.00 11.98           C  
ATOM   9350  C   ASP F 100      23.913  -2.226  49.846  1.00 12.55           C  
ATOM   9351  O   ASP F 100      25.031  -1.917  49.441  1.00 12.31           O  
ATOM   9352  CB  ASP F 100      23.235  -2.499  47.436  1.00 12.33           C  
ATOM   9353  CG  ASP F 100      23.100  -1.031  47.077  1.00 15.24           C  
ATOM   9354  OD1 ASP F 100      22.796  -0.205  47.967  1.00 15.49           O  
ATOM   9355  OD2 ASP F 100      23.303  -0.709  45.880  1.00 15.57           O  
ATOM   9356  N   GLU F 101      23.564  -2.089  51.116  1.00 13.05           N  
ATOM   9357  CA  GLU F 101      24.500  -1.575  52.099  1.00 14.21           C  
ATOM   9358  C   GLU F 101      24.279  -2.342  53.378  1.00 14.20           C  
ATOM   9359  O   GLU F 101      23.239  -2.962  53.557  1.00 13.19           O  
ATOM   9360  CB  GLU F 101      24.282  -0.079  52.344  1.00 15.81           C  
ATOM   9361  CG  GLU F 101      24.740   0.815  51.201  1.00 20.76           C  
ATOM   9362  CD  GLU F 101      24.543   2.279  51.547  1.00 26.27           C  
ATOM   9363  OE1 GLU F 101      24.590   2.635  52.752  1.00 28.90           O  
ATOM   9364  OE2 GLU F 101      24.336   3.071  50.604  1.00 27.60           O  
ATOM   9365  N   GLU F 102      25.266  -2.300  54.257  1.00 18.03           N  
ATOM   9366  CA  GLU F 102      25.210  -2.982  55.545  1.00 21.82           C  
ATOM   9367  C   GLU F 102      24.070  -2.410  56.396  1.00 23.32           C  
ATOM   9368  O   GLU F 102      23.236  -3.149  56.913  1.00 25.46           O  
ATOM   9369  CB  GLU F 102      26.544  -2.787  56.276  1.00 23.40           C  
ATOM   9370  CG  GLU F 102      27.164  -4.054  56.834  1.00 30.58           C  
ATOM   9371  CD  GLU F 102      26.501  -4.472  58.141  1.00 35.22           C  
ATOM   9372  OE1 GLU F 102      26.312  -3.609  59.029  1.00 39.11           O  
ATOM   9373  OE2 GLU F 102      26.193  -5.675  58.287  1.00 36.96           O  
ATOM   9374  N   ARG F 103      24.043  -1.089  56.534  1.00 21.80           N  
ATOM   9375  CA  ARG F 103      23.030  -0.410  57.335  1.00 19.06           C  
ATOM   9376  C   ARG F 103      21.973   0.209  56.447  1.00 18.17           C  
ATOM   9377  O   ARG F 103      22.244   0.548  55.288  1.00 19.86           O  
ATOM   9378  CB  ARG F 103      23.654   0.739  58.133  1.00 19.80           C  
ATOM   9379  CG  ARG F 103      24.888   0.387  58.925  1.00 24.47           C  
ATOM   9380  CD  ARG F 103      24.533  -0.445  60.114  1.00 27.77           C  
ATOM   9381  NE  ARG F 103      23.624   0.303  60.971  1.00 33.11           N  
ATOM   9382  CZ  ARG F 103      23.148  -0.167  62.113  1.00 32.89           C  
ATOM   9383  NH1 ARG F 103      23.508  -1.381  62.516  1.00 33.14           N  
ATOM   9384  NH2 ARG F 103      22.319   0.571  62.844  1.00 32.77           N  
ATOM   9385  N   LEU F 104      20.781   0.389  57.008  1.00 16.50           N  
ATOM   9386  CA  LEU F 104      19.681   1.026  56.291  1.00 14.99           C  
ATOM   9387  C   LEU F 104      19.858   2.531  56.452  1.00 15.47           C  
ATOM   9388  O   LEU F 104      20.301   2.991  57.500  1.00 13.84           O  
ATOM   9389  CB  LEU F 104      18.339   0.623  56.880  1.00 13.07           C  
ATOM   9390  CG  LEU F 104      17.797  -0.754  56.540  1.00 13.49           C  
ATOM   9391  CD1 LEU F 104      16.547  -1.020  57.360  1.00 15.79           C  
ATOM   9392  CD2 LEU F 104      17.492  -0.803  55.069  1.00 10.60           C  
ATOM   9393  N   THR F 105      19.543   3.288  55.409  1.00 17.73           N  
ATOM   9394  CA  THR F 105      19.683   4.742  55.443  1.00 19.44           C  
ATOM   9395  C   THR F 105      18.313   5.350  55.183  1.00 20.28           C  
ATOM   9396  O   THR F 105      17.371   4.644  54.814  1.00 21.11           O  
ATOM   9397  CB  THR F 105      20.651   5.252  54.354  1.00 17.17           C  
ATOM   9398  OG1 THR F 105      20.087   4.986  53.059  1.00 21.23           O  
ATOM   9399  CG2 THR F 105      22.025   4.577  54.488  1.00 14.94           C  
ATOM   9400  N   GLN F 106      18.188   6.658  55.344  1.00 18.51           N  
ATOM   9401  CA  GLN F 106      16.900   7.275  55.106  1.00 16.78           C  
ATOM   9402  C   GLN F 106      16.383   6.996  53.694  1.00 20.25           C  
ATOM   9403  O   GLN F 106      15.256   6.510  53.492  1.00 20.39           O  
ATOM   9404  CB  GLN F 106      16.971   8.769  55.346  1.00 11.09           C  
ATOM   9405  CG  GLN F 106      15.610   9.427  55.404  1.00  2.00           C  
ATOM   9406  CD  GLN F 106      14.909   9.100  56.691  1.00  4.58           C  
ATOM   9407  OE1 GLN F 106      15.550   8.987  57.738  1.00  6.50           O  
ATOM   9408  NE2 GLN F 106      13.598   8.904  56.856  1.00  4.99           N  
ATOM   9409  N   GLU F 107      17.227   7.327  52.704  1.00 22.99           N  
ATOM   9410  CA  GLU F 107      16.905   7.174  51.287  1.00 25.08           C  
ATOM   9411  C   GLU F 107      16.516   5.770  50.867  1.00 23.71           C  
ATOM   9412  O   GLU F 107      15.864   5.605  49.824  1.00 23.12           O  
ATOM   9413  CB  GLU F 107      18.100   7.627  50.433  1.00 30.07           C  
ATOM   9414  CG  GLU F 107      18.486   9.104  50.565  1.00 37.27           C  
ATOM   9415  CD  GLU F 107      19.449   9.366  51.696  1.00 42.02           C  
ATOM   9416  OE1 GLU F 107      19.867   8.395  52.353  1.00 44.76           O  
ATOM   9417  OE2 GLU F 107      19.784  10.539  51.923  1.00 44.71           O  
ATOM   9418  N   SER F 108      16.907   4.728  51.639  1.00 22.08           N  
ATOM   9419  CA  SER F 108      16.576   3.327  51.290  1.00 21.47           C  
ATOM   9420  C   SER F 108      15.095   3.014  51.440  1.00 20.68           C  
ATOM   9421  O   SER F 108      14.640   1.952  51.005  1.00 21.87           O  
ATOM   9422  CB  SER F 108      17.416   2.355  52.124  1.00 20.95           C  
ATOM   9423  OG  SER F 108      17.400   2.719  53.495  1.00 21.58           O  
ATOM   9424  N   LEU F 109      14.343   3.932  52.039  1.00 19.19           N  
ATOM   9425  CA  LEU F 109      12.908   3.728  52.228  1.00 14.27           C  
ATOM   9426  C   LEU F 109      12.163   3.643  50.906  1.00 13.71           C  
ATOM   9427  O   LEU F 109      11.163   2.934  50.797  1.00 14.20           O  
ATOM   9428  CB  LEU F 109      12.299   4.864  53.046  1.00  9.74           C  
ATOM   9429  CG  LEU F 109      12.430   4.778  54.551  1.00  8.98           C  
ATOM   9430  CD1 LEU F 109      11.401   5.702  55.171  1.00 10.56           C  
ATOM   9431  CD2 LEU F 109      12.168   3.354  55.007  1.00 15.23           C  
ATOM   9432  N   ALA F 110      12.634   4.405  49.924  1.00 10.85           N  
ATOM   9433  CA  ALA F 110      11.988   4.454  48.629  1.00  7.73           C  
ATOM   9434  C   ALA F 110      12.866   3.872  47.552  1.00  6.47           C  
ATOM   9435  O   ALA F 110      12.625   4.072  46.366  1.00  7.65           O  
ATOM   9436  CB  ALA F 110      11.650   5.874  48.296  1.00  8.79           C  
ATOM   9437  N   LEU F 111      13.871   3.113  47.958  1.00  7.91           N  
ATOM   9438  CA  LEU F 111      14.786   2.535  46.991  1.00  7.54           C  
ATOM   9439  C   LEU F 111      14.780   1.025  46.903  1.00  6.29           C  
ATOM   9440  O   LEU F 111      14.543   0.314  47.882  1.00  6.46           O  
ATOM   9441  CB  LEU F 111      16.212   3.034  47.253  1.00  6.77           C  
ATOM   9442  CG  LEU F 111      16.499   4.507  46.930  1.00  5.86           C  
ATOM   9443  CD1 LEU F 111      17.846   4.926  47.478  1.00  2.00           C  
ATOM   9444  CD2 LEU F 111      16.448   4.722  45.442  1.00  2.00           C  
ATOM   9445  N   HIS F 112      14.962   0.562  45.676  1.00  7.55           N  
ATOM   9446  CA  HIS F 112      15.072  -0.847  45.350  1.00  8.62           C  
ATOM   9447  C   HIS F 112      16.361  -0.906  44.547  1.00  8.73           C  
ATOM   9448  O   HIS F 112      16.498  -0.189  43.549  1.00  8.57           O  
ATOM   9449  CB  HIS F 112      13.907  -1.315  44.479  1.00  7.61           C  
ATOM   9450  CG  HIS F 112      14.178  -2.600  43.753  1.00 10.16           C  
ATOM   9451  ND1 HIS F 112      14.586  -3.751  44.396  1.00  9.18           N  
ATOM   9452  CD2 HIS F 112      14.083  -2.917  42.439  1.00  9.48           C  
ATOM   9453  CE1 HIS F 112      14.724  -4.722  43.511  1.00 11.76           C  
ATOM   9454  NE2 HIS F 112      14.426  -4.242  42.317  1.00 10.02           N  
ATOM   9455  N   ARG F 113      17.317  -1.696  45.026  1.00  9.04           N  
ATOM   9456  CA  ARG F 113      18.606  -1.875  44.364  1.00 10.45           C  
ATOM   9457  C   ARG F 113      18.629  -3.258  43.732  1.00 10.89           C  
ATOM   9458  O   ARG F 113      18.896  -4.241  44.414  1.00 11.63           O  
ATOM   9459  CB  ARG F 113      19.741  -1.787  45.381  1.00 11.30           C  
ATOM   9460  CG  ARG F 113      19.766  -0.506  46.211  1.00 15.23           C  
ATOM   9461  CD  ARG F 113      20.127   0.720  45.379  1.00 15.90           C  
ATOM   9462  NE  ARG F 113      20.887   1.657  46.199  1.00 17.58           N  
ATOM   9463  CZ  ARG F 113      20.956   2.965  45.977  1.00 20.74           C  
ATOM   9464  NH1 ARG F 113      20.304   3.502  44.953  1.00 19.89           N  
ATOM   9465  NH2 ARG F 113      21.686   3.734  46.782  1.00 22.86           N  
ATOM   9466  N   PRO F 114      18.399  -3.351  42.411  1.00 10.66           N  
ATOM   9467  CA  PRO F 114      18.383  -4.614  41.661  1.00 11.34           C  
ATOM   9468  C   PRO F 114      19.523  -5.586  41.975  1.00 10.66           C  
ATOM   9469  O   PRO F 114      19.284  -6.794  42.109  1.00 10.59           O  
ATOM   9470  CB  PRO F 114      18.436  -4.134  40.208  1.00 10.53           C  
ATOM   9471  CG  PRO F 114      17.665  -2.870  40.260  1.00 10.42           C  
ATOM   9472  CD  PRO F 114      18.218  -2.209  41.495  1.00  9.53           C  
ATOM   9473  N   ARG F 115      20.753  -5.070  42.080  1.00  9.93           N  
ATOM   9474  CA  ARG F 115      21.916  -5.900  42.384  1.00  8.73           C  
ATOM   9475  C   ARG F 115      22.197  -5.896  43.894  1.00 10.35           C  
ATOM   9476  O   ARG F 115      23.345  -6.057  44.329  1.00 10.27           O  
ATOM   9477  CB  ARG F 115      23.167  -5.405  41.655  1.00 11.07           C  
ATOM   9478  CG  ARG F 115      23.010  -5.034  40.198  1.00 11.86           C  
ATOM   9479  CD  ARG F 115      24.384  -4.895  39.549  1.00 15.65           C  
ATOM   9480  NE  ARG F 115      24.815  -6.165  38.965  1.00 19.67           N  
ATOM   9481  CZ  ARG F 115      25.748  -6.965  39.473  1.00 22.01           C  
ATOM   9482  NH1 ARG F 115      26.372  -6.653  40.603  1.00 25.87           N  
ATOM   9483  NH2 ARG F 115      26.080  -8.071  38.824  1.00 21.10           N  
ATOM   9484  N   GLY F 116      21.166  -5.629  44.685  1.00  9.91           N  
ATOM   9485  CA  GLY F 116      21.318  -5.629  46.127  1.00 11.07           C  
ATOM   9486  C   GLY F 116      21.495  -7.055  46.637  1.00 11.63           C  
ATOM   9487  O   GLY F 116      21.321  -8.017  45.895  1.00 13.57           O  
ATOM   9488  N   HIS F 117      21.756  -7.192  47.925  1.00 10.84           N  
ATOM   9489  CA  HIS F 117      21.985  -8.496  48.535  1.00 14.25           C  
ATOM   9490  C   HIS F 117      21.130  -8.729  49.781  1.00 13.66           C  
ATOM   9491  O   HIS F 117      21.169  -9.802  50.382  1.00 12.73           O  
ATOM   9492  CB  HIS F 117      23.450  -8.580  48.950  1.00 19.07           C  
ATOM   9493  CG  HIS F 117      23.884  -7.425  49.796  1.00 24.72           C  
ATOM   9494  ND1 HIS F 117      23.982  -6.140  49.304  1.00 27.05           N  
ATOM   9495  CD2 HIS F 117      24.194  -7.348  51.112  1.00 24.64           C  
ATOM   9496  CE1 HIS F 117      24.331  -5.323  50.279  1.00 23.38           C  
ATOM   9497  NE2 HIS F 117      24.466  -6.029  51.386  1.00 23.61           N  
ATOM   9498  N   SER F 118      20.367  -7.726  50.175  1.00 15.33           N  
ATOM   9499  CA  SER F 118      19.550  -7.836  51.364  1.00 12.87           C  
ATOM   9500  C   SER F 118      18.090  -7.547  51.085  1.00 10.57           C  
ATOM   9501  O   SER F 118      17.762  -6.581  50.396  1.00 11.84           O  
ATOM   9502  CB  SER F 118      20.080  -6.872  52.428  1.00 12.93           C  
ATOM   9503  OG  SER F 118      21.459  -7.104  52.662  1.00 12.61           O  
ATOM   9504  N   ALA F 119      17.217  -8.416  51.573  1.00  9.75           N  
ATOM   9505  CA  ALA F 119      15.793  -8.224  51.402  1.00  9.92           C  
ATOM   9506  C   ALA F 119      15.326  -7.254  52.485  1.00 13.63           C  
ATOM   9507  O   ALA F 119      15.267  -7.596  53.676  1.00 15.61           O  
ATOM   9508  CB  ALA F 119      15.066  -9.532  51.511  1.00  6.73           C  
ATOM   9509  N   HIS F 120      15.045  -6.025  52.068  1.00 13.68           N  
ATOM   9510  CA  HIS F 120      14.586  -4.977  52.963  1.00 12.42           C  
ATOM   9511  C   HIS F 120      13.062  -5.039  53.153  1.00 11.39           C  
ATOM   9512  O   HIS F 120      12.302  -4.737  52.232  1.00 12.48           O  
ATOM   9513  CB  HIS F 120      15.013  -3.622  52.380  1.00 13.37           C  
ATOM   9514  CG  HIS F 120      14.633  -2.440  53.217  1.00 15.25           C  
ATOM   9515  ND1 HIS F 120      14.647  -1.153  52.723  1.00 12.46           N  
ATOM   9516  CD2 HIS F 120      14.239  -2.345  54.510  1.00 14.28           C  
ATOM   9517  CE1 HIS F 120      14.280  -0.316  53.676  1.00 13.53           C  
ATOM   9518  NE2 HIS F 120      14.026  -1.013  54.770  1.00 14.94           N  
ATOM   9519  N   LEU F 121      12.623  -5.495  54.320  1.00 10.06           N  
ATOM   9520  CA  LEU F 121      11.196  -5.565  54.628  1.00 10.04           C  
ATOM   9521  C   LEU F 121      10.726  -4.176  55.064  1.00 10.89           C  
ATOM   9522  O   LEU F 121      10.977  -3.741  56.197  1.00 10.89           O  
ATOM   9523  CB  LEU F 121      10.916  -6.564  55.761  1.00 11.09           C  
ATOM   9524  CG  LEU F 121      11.087  -8.066  55.551  1.00  7.94           C  
ATOM   9525  CD1 LEU F 121      12.557  -8.416  55.470  1.00 10.33           C  
ATOM   9526  CD2 LEU F 121      10.431  -8.798  56.702  1.00  3.43           C  
ATOM   9527  N   HIS F 122      10.056  -3.482  54.153  1.00 10.98           N  
ATOM   9528  CA  HIS F 122       9.542  -2.138  54.409  1.00 14.52           C  
ATOM   9529  C   HIS F 122       8.363  -2.100  55.380  1.00 15.83           C  
ATOM   9530  O   HIS F 122       8.264  -1.193  56.214  1.00 12.74           O  
ATOM   9531  CB  HIS F 122       9.140  -1.478  53.084  1.00 12.83           C  
ATOM   9532  CG  HIS F 122      10.287  -1.270  52.152  1.00 13.53           C  
ATOM   9533  ND1 HIS F 122      10.986  -0.088  52.035  1.00 15.53           N  
ATOM   9534  CD2 HIS F 122      10.906  -2.141  51.321  1.00 15.62           C  
ATOM   9535  CE1 HIS F 122      11.985  -0.282  51.162  1.00 15.26           C  
ATOM   9536  NE2 HIS F 122      11.977  -1.515  50.702  1.00 16.57           N  
ATOM   9537  N   ALA F 123       7.457  -3.067  55.240  1.00 16.27           N  
ATOM   9538  CA  ALA F 123       6.280  -3.159  56.095  1.00 16.84           C  
ATOM   9539  C   ALA F 123       5.804  -4.593  56.252  1.00 16.65           C  
ATOM   9540  O   ALA F 123       5.880  -5.390  55.313  1.00 14.86           O  
ATOM   9541  CB  ALA F 123       5.163  -2.307  55.539  1.00 16.36           C  
ATOM   9542  N   LEU F 124       5.324  -4.907  57.450  1.00 17.41           N  
ATOM   9543  CA  LEU F 124       4.790  -6.221  57.789  1.00 19.32           C  
ATOM   9544  C   LEU F 124       3.592  -5.960  58.688  1.00 19.54           C  
ATOM   9545  O   LEU F 124       3.725  -5.292  59.726  1.00 19.52           O  
ATOM   9546  CB  LEU F 124       5.833  -7.065  58.542  1.00 18.54           C  
ATOM   9547  CG  LEU F 124       5.310  -8.250  59.379  1.00 19.64           C  
ATOM   9548  CD1 LEU F 124       4.526  -9.238  58.523  1.00 22.51           C  
ATOM   9549  CD2 LEU F 124       6.471  -8.963  60.063  1.00 19.79           C  
ATOM   9550  N   ALA F 125       2.424  -6.451  58.283  1.00 19.33           N  
ATOM   9551  CA  ALA F 125       1.211  -6.252  59.064  1.00 20.41           C  
ATOM   9552  C   ALA F 125       0.186  -7.340  58.847  1.00 19.82           C  
ATOM   9553  O   ALA F 125       0.096  -7.924  57.765  1.00 19.41           O  
ATOM   9554  CB  ALA F 125       0.589  -4.890  58.747  1.00 20.41           C  
ATOM   9555  N   VAL F 126      -0.588  -7.606  59.892  1.00 19.06           N  
ATOM   9556  CA  VAL F 126      -1.650  -8.598  59.856  1.00 18.08           C  
ATOM   9557  C   VAL F 126      -2.941  -7.846  60.160  1.00 18.26           C  
ATOM   9558  O   VAL F 126      -2.969  -6.950  61.005  1.00 20.22           O  
ATOM   9559  CB  VAL F 126      -1.443  -9.716  60.922  1.00 14.17           C  
ATOM   9560  CG1 VAL F 126      -2.570 -10.717  60.876  1.00 12.11           C  
ATOM   9561  CG2 VAL F 126      -0.141 -10.428  60.674  1.00 13.39           C  
ATOM   9562  N   HIS F 127      -3.994  -8.184  59.435  1.00 16.67           N  
ATOM   9563  CA  HIS F 127      -5.289  -7.571  59.636  1.00 17.24           C  
ATOM   9564  C   HIS F 127      -5.703  -7.823  61.106  1.00 17.01           C  
ATOM   9565  O   HIS F 127      -5.548  -8.944  61.630  1.00 14.91           O  
ATOM   9566  CB  HIS F 127      -6.271  -8.219  58.652  1.00 17.75           C  
ATOM   9567  CG  HIS F 127      -7.642  -7.626  58.665  1.00 18.67           C  
ATOM   9568  ND1 HIS F 127      -8.488  -7.719  59.752  1.00 19.78           N  
ATOM   9569  CD2 HIS F 127      -8.352  -7.005  57.691  1.00 18.36           C  
ATOM   9570  CE1 HIS F 127      -9.659  -7.191  59.448  1.00 19.39           C  
ATOM   9571  NE2 HIS F 127      -9.604  -6.749  58.202  1.00 17.73           N  
ATOM   9572  N   ARG F 128      -6.225  -6.788  61.764  1.00 13.30           N  
ATOM   9573  CA  ARG F 128      -6.660  -6.875  63.164  1.00 11.82           C  
ATOM   9574  C   ARG F 128      -7.552  -8.067  63.551  1.00  9.25           C  
ATOM   9575  O   ARG F 128      -7.529  -8.509  64.692  1.00  8.38           O  
ATOM   9576  CB  ARG F 128      -7.371  -5.589  63.561  1.00 14.04           C  
ATOM   9577  CG  ARG F 128      -8.564  -5.297  62.698  1.00 16.81           C  
ATOM   9578  CD  ARG F 128      -9.449  -4.228  63.297  1.00 16.56           C  
ATOM   9579  NE  ARG F 128     -10.741  -4.315  62.621  1.00 17.87           N  
ATOM   9580  CZ  ARG F 128     -11.774  -5.027  63.066  1.00 17.26           C  
ATOM   9581  NH1 ARG F 128     -11.677  -5.713  64.206  1.00 20.22           N  
ATOM   9582  NH2 ARG F 128     -12.890  -5.096  62.344  1.00 16.60           N  
ATOM   9583  N   SER F 129      -8.384  -8.534  62.629  1.00  9.44           N  
ATOM   9584  CA  SER F 129      -9.260  -9.671  62.895  1.00 10.84           C  
ATOM   9585  C   SER F 129      -8.578 -11.036  62.725  1.00 11.89           C  
ATOM   9586  O   SER F 129      -9.232 -12.075  62.850  1.00 14.64           O  
ATOM   9587  CB  SER F 129     -10.471  -9.610  61.973  1.00  6.70           C  
ATOM   9588  OG  SER F 129     -11.082  -8.348  62.068  1.00  2.00           O  
ATOM   9589  N   PHE F 130      -7.284 -11.038  62.422  1.00 10.41           N  
ATOM   9590  CA  PHE F 130      -6.570 -12.290  62.224  1.00 11.58           C  
ATOM   9591  C   PHE F 130      -5.283 -12.358  63.046  1.00 10.78           C  
ATOM   9592  O   PHE F 130      -4.505 -13.321  62.927  1.00 12.78           O  
ATOM   9593  CB  PHE F 130      -6.265 -12.494  60.730  1.00 13.15           C  
ATOM   9594  CG  PHE F 130      -7.484 -12.460  59.848  1.00 14.15           C  
ATOM   9595  CD1 PHE F 130      -8.003 -11.248  59.401  1.00 16.04           C  
ATOM   9596  CD2 PHE F 130      -8.115 -13.639  59.464  1.00 16.33           C  
ATOM   9597  CE1 PHE F 130      -9.131 -11.208  58.586  1.00 16.12           C  
ATOM   9598  CE2 PHE F 130      -9.254 -13.613  58.639  1.00 15.09           C  
ATOM   9599  CZ  PHE F 130      -9.757 -12.397  58.203  1.00 16.53           C  
ATOM   9600  N   ARG F 131      -5.071 -11.356  63.897  1.00  6.10           N  
ATOM   9601  CA  ARG F 131      -3.875 -11.318  64.728  1.00  5.34           C  
ATOM   9602  C   ARG F 131      -3.883 -12.360  65.848  1.00  5.97           C  
ATOM   9603  O   ARG F 131      -4.911 -12.957  66.144  1.00  2.27           O  
ATOM   9604  CB  ARG F 131      -3.664  -9.920  65.294  1.00  2.92           C  
ATOM   9605  CG  ARG F 131      -3.460  -8.866  64.235  1.00  5.01           C  
ATOM   9606  CD  ARG F 131      -3.098  -7.554  64.878  1.00  4.01           C  
ATOM   9607  NE  ARG F 131      -2.842  -6.517  63.888  1.00  9.17           N  
ATOM   9608  CZ  ARG F 131      -3.465  -5.342  63.852  1.00 10.69           C  
ATOM   9609  NH1 ARG F 131      -4.388  -5.040  64.755  1.00 13.00           N  
ATOM   9610  NH2 ARG F 131      -3.179  -4.478  62.888  1.00 10.41           N  
ATOM   9611  N   GLN F 132      -2.716 -12.585  66.442  1.00  7.08           N  
ATOM   9612  CA  GLN F 132      -2.553 -13.557  67.528  1.00 10.72           C  
ATOM   9613  C   GLN F 132      -3.016 -14.987  67.184  1.00 10.66           C  
ATOM   9614  O   GLN F 132      -3.451 -15.742  68.057  1.00  9.86           O  
ATOM   9615  CB  GLN F 132      -3.226 -13.061  68.823  1.00 12.74           C  
ATOM   9616  CG  GLN F 132      -2.795 -11.674  69.297  1.00 17.30           C  
ATOM   9617  CD  GLN F 132      -1.274 -11.510  69.223  1.00 22.81           C  
ATOM   9618  OE1 GLN F 132      -0.514 -12.284  69.813  1.00 21.28           O  
ATOM   9619  NE2 GLN F 132      -0.830 -10.492  68.491  1.00 26.46           N  
ATOM   9620  N   GLN F 133      -2.937 -15.349  65.907  1.00 10.80           N  
ATOM   9621  CA  GLN F 133      -3.310 -16.693  65.457  1.00  8.94           C  
ATOM   9622  C   GLN F 133      -2.076 -17.423  64.883  1.00  9.29           C  
ATOM   9623  O   GLN F 133      -2.162 -18.555  64.385  1.00  8.99           O  
ATOM   9624  CB  GLN F 133      -4.423 -16.623  64.401  1.00  7.99           C  
ATOM   9625  CG  GLN F 133      -5.752 -16.132  64.928  1.00 10.23           C  
ATOM   9626  CD  GLN F 133      -6.736 -15.918  63.785  1.00 12.45           C  
ATOM   9627  OE1 GLN F 133      -6.545 -16.419  62.677  1.00 10.22           O  
ATOM   9628  NE2 GLN F 133      -7.809 -15.176  64.059  1.00 14.06           N  
ATOM   9629  N   GLY F 134      -0.928 -16.763  64.966  1.00  8.26           N  
ATOM   9630  CA  GLY F 134       0.301 -17.339  64.464  1.00  8.22           C  
ATOM   9631  C   GLY F 134       0.524 -17.086  62.989  1.00  8.12           C  
ATOM   9632  O   GLY F 134       1.593 -17.377  62.456  1.00  8.73           O  
ATOM   9633  N   LYS F 135      -0.464 -16.475  62.349  1.00  8.52           N  
ATOM   9634  CA  LYS F 135      -0.416 -16.175  60.920  1.00  7.46           C  
ATOM   9635  C   LYS F 135       0.675 -15.200  60.464  1.00  7.42           C  
ATOM   9636  O   LYS F 135       1.197 -15.334  59.349  1.00  6.41           O  
ATOM   9637  CB  LYS F 135      -1.798 -15.723  60.462  1.00  8.20           C  
ATOM   9638  CG  LYS F 135      -2.829 -16.857  60.464  1.00  8.62           C  
ATOM   9639  CD  LYS F 135      -4.254 -16.331  60.302  1.00 15.30           C  
ATOM   9640  CE  LYS F 135      -4.411 -15.317  59.154  1.00 18.33           C  
ATOM   9641  NZ  LYS F 135      -4.162 -15.867  57.787  1.00 20.02           N  
ATOM   9642  N   GLY F 136       1.024 -14.236  61.320  1.00  8.01           N  
ATOM   9643  CA  GLY F 136       2.071 -13.278  60.998  1.00  5.63           C  
ATOM   9644  C   GLY F 136       3.421 -13.975  60.980  1.00  6.93           C  
ATOM   9645  O   GLY F 136       4.279 -13.671  60.161  1.00  7.14           O  
ATOM   9646  N   SER F 137       3.595 -14.930  61.887  1.00  7.72           N  
ATOM   9647  CA  SER F 137       4.823 -15.700  61.984  1.00  7.58           C  
ATOM   9648  C   SER F 137       4.972 -16.639  60.779  1.00  7.76           C  
ATOM   9649  O   SER F 137       6.055 -16.756  60.196  1.00  9.68           O  
ATOM   9650  CB  SER F 137       4.819 -16.506  63.283  1.00  7.07           C  
ATOM   9651  OG  SER F 137       4.700 -15.642  64.405  1.00  5.97           O  
ATOM   9652  N   VAL F 138       3.885 -17.292  60.395  1.00  6.79           N  
ATOM   9653  CA  VAL F 138       3.907 -18.207  59.266  1.00  4.67           C  
ATOM   9654  C   VAL F 138       4.305 -17.459  57.996  1.00  6.24           C  
ATOM   9655  O   VAL F 138       5.087 -17.967  57.179  1.00  7.60           O  
ATOM   9656  CB  VAL F 138       2.539 -18.890  59.096  1.00  2.32           C  
ATOM   9657  CG1 VAL F 138       2.520 -19.733  57.854  1.00  3.01           C  
ATOM   9658  CG2 VAL F 138       2.263 -19.771  60.279  1.00  2.00           C  
ATOM   9659  N   LEU F 139       3.796 -16.236  57.873  1.00  7.28           N  
ATOM   9660  CA  LEU F 139       4.072 -15.358  56.736  1.00  8.89           C  
ATOM   9661  C   LEU F 139       5.531 -14.935  56.741  1.00  6.70           C  
ATOM   9662  O   LEU F 139       6.204 -15.029  55.727  1.00  9.42           O  
ATOM   9663  CB  LEU F 139       3.195 -14.100  56.824  1.00 12.16           C  
ATOM   9664  CG  LEU F 139       2.777 -13.258  55.606  1.00 12.31           C  
ATOM   9665  CD1 LEU F 139       2.783 -11.802  56.040  1.00 14.56           C  
ATOM   9666  CD2 LEU F 139       3.680 -13.459  54.408  1.00 13.13           C  
ATOM   9667  N   LEU F 140       6.016 -14.467  57.885  1.00  5.67           N  
ATOM   9668  CA  LEU F 140       7.397 -14.009  57.987  1.00  5.14           C  
ATOM   9669  C   LEU F 140       8.365 -15.138  57.648  1.00  5.79           C  
ATOM   9670  O   LEU F 140       9.289 -14.958  56.838  1.00  4.21           O  
ATOM   9671  CB  LEU F 140       7.679 -13.425  59.375  1.00  2.00           C  
ATOM   9672  CG  LEU F 140       9.074 -12.823  59.583  1.00  4.75           C  
ATOM   9673  CD1 LEU F 140       9.429 -11.809  58.473  1.00  2.00           C  
ATOM   9674  CD2 LEU F 140       9.138 -12.158  60.958  1.00  4.66           C  
ATOM   9675  N   TRP F 141       8.125 -16.309  58.237  1.00  7.72           N  
ATOM   9676  CA  TRP F 141       8.961 -17.479  57.992  1.00  7.12           C  
ATOM   9677  C   TRP F 141       8.946 -17.774  56.497  1.00  7.99           C  
ATOM   9678  O   TRP F 141       9.991 -17.891  55.843  1.00  7.49           O  
ATOM   9679  CB  TRP F 141       8.426 -18.676  58.770  1.00  5.50           C  
ATOM   9680  CG  TRP F 141       9.088 -18.868  60.073  1.00  2.00           C  
ATOM   9681  CD1 TRP F 141       8.486 -19.067  61.275  1.00  2.00           C  
ATOM   9682  CD2 TRP F 141      10.497 -18.943  60.314  1.00  2.00           C  
ATOM   9683  NE1 TRP F 141       9.428 -19.272  62.255  1.00  2.00           N  
ATOM   9684  CE2 TRP F 141      10.674 -19.202  61.690  1.00  2.92           C  
ATOM   9685  CE3 TRP F 141      11.631 -18.811  59.495  1.00  2.25           C  
ATOM   9686  CZ2 TRP F 141      11.937 -19.338  62.271  1.00  5.39           C  
ATOM   9687  CZ3 TRP F 141      12.883 -18.942  60.062  1.00  4.01           C  
ATOM   9688  CH2 TRP F 141      13.029 -19.205  61.446  1.00  8.55           C  
ATOM   9689  N   ARG F 142       7.737 -17.807  55.957  1.00 10.45           N  
ATOM   9690  CA  ARG F 142       7.505 -18.068  54.547  1.00 13.16           C  
ATOM   9691  C   ARG F 142       8.309 -17.099  53.667  1.00 13.13           C  
ATOM   9692  O   ARG F 142       8.987 -17.520  52.723  1.00 14.26           O  
ATOM   9693  CB  ARG F 142       6.019 -17.891  54.267  1.00 16.20           C  
ATOM   9694  CG  ARG F 142       5.503 -18.679  53.113  1.00 25.78           C  
ATOM   9695  CD  ARG F 142       5.165 -20.081  53.552  1.00 29.93           C  
ATOM   9696  NE  ARG F 142       4.599 -20.837  52.438  1.00 34.14           N  
ATOM   9697  CZ  ARG F 142       3.683 -21.792  52.570  1.00 35.13           C  
ATOM   9698  NH1 ARG F 142       3.216 -22.107  53.776  1.00 34.30           N  
ATOM   9699  NH2 ARG F 142       3.252 -22.451  51.500  1.00 38.02           N  
ATOM   9700  N   TYR F 143       8.241 -15.809  53.998  1.00 12.14           N  
ATOM   9701  CA  TYR F 143       8.920 -14.753  53.250  1.00 10.76           C  
ATOM   9702  C   TYR F 143      10.425 -14.897  53.283  1.00  9.74           C  
ATOM   9703  O   TYR F 143      11.096 -14.595  52.298  1.00  7.44           O  
ATOM   9704  CB  TYR F 143       8.511 -13.379  53.790  1.00 11.58           C  
ATOM   9705  CG  TYR F 143       9.122 -12.196  53.057  1.00  8.87           C  
ATOM   9706  CD1 TYR F 143       8.534 -11.688  51.893  1.00  5.98           C  
ATOM   9707  CD2 TYR F 143      10.283 -11.575  53.536  1.00  7.57           C  
ATOM   9708  CE1 TYR F 143       9.081 -10.590  51.227  1.00  5.84           C  
ATOM   9709  CE2 TYR F 143      10.839 -10.481  52.872  1.00  6.41           C  
ATOM   9710  CZ  TYR F 143      10.233  -9.996  51.718  1.00  5.11           C  
ATOM   9711  OH  TYR F 143      10.790  -8.932  51.050  1.00  6.08           O  
ATOM   9712  N   LEU F 144      10.957 -15.350  54.415  1.00  9.48           N  
ATOM   9713  CA  LEU F 144      12.398 -15.535  54.561  1.00  8.95           C  
ATOM   9714  C   LEU F 144      12.883 -16.660  53.657  1.00  7.07           C  
ATOM   9715  O   LEU F 144      14.011 -16.630  53.182  1.00  4.97           O  
ATOM   9716  CB  LEU F 144      12.750 -15.840  56.019  1.00  6.94           C  
ATOM   9717  CG  LEU F 144      12.512 -14.703  57.005  1.00  9.80           C  
ATOM   9718  CD1 LEU F 144      12.861 -15.171  58.399  1.00  8.61           C  
ATOM   9719  CD2 LEU F 144      13.343 -13.481  56.611  1.00 11.81           C  
ATOM   9720  N   HIS F 145      12.021 -17.651  53.437  1.00  6.22           N  
ATOM   9721  CA  HIS F 145      12.344 -18.789  52.583  1.00  7.57           C  
ATOM   9722  C   HIS F 145      12.203 -18.387  51.130  1.00  4.33           C  
ATOM   9723  O   HIS F 145      13.057 -18.680  50.303  1.00  2.00           O  
ATOM   9724  CB  HIS F 145      11.436 -19.987  52.900  1.00 11.35           C  
ATOM   9725  CG  HIS F 145      11.823 -20.730  54.145  1.00 15.58           C  
ATOM   9726  ND1 HIS F 145      12.822 -21.682  54.165  1.00 18.24           N  
ATOM   9727  CD2 HIS F 145      11.349 -20.659  55.413  1.00 19.15           C  
ATOM   9728  CE1 HIS F 145      12.945 -22.169  55.388  1.00 20.49           C  
ATOM   9729  NE2 HIS F 145      12.064 -21.564  56.165  1.00 21.48           N  
ATOM   9730  N   HIS F 146      11.132 -17.660  50.848  1.00  5.96           N  
ATOM   9731  CA  HIS F 146      10.828 -17.168  49.507  1.00  8.33           C  
ATOM   9732  C   HIS F 146      11.965 -16.323  48.931  1.00  9.33           C  
ATOM   9733  O   HIS F 146      12.455 -16.592  47.831  1.00  9.22           O  
ATOM   9734  CB  HIS F 146       9.541 -16.340  49.563  1.00  9.07           C  
ATOM   9735  CG  HIS F 146       9.183 -15.673  48.270  1.00  9.18           C  
ATOM   9736  ND1 HIS F 146       8.834 -16.380  47.137  1.00  9.43           N  
ATOM   9737  CD2 HIS F 146       9.091 -14.367  47.940  1.00  9.03           C  
ATOM   9738  CE1 HIS F 146       8.542 -15.532  46.169  1.00 11.76           C  
ATOM   9739  NE2 HIS F 146       8.690 -14.305  46.629  1.00  8.67           N  
ATOM   9740  N   VAL F 147      12.378 -15.301  49.672  1.00 10.01           N  
ATOM   9741  CA  VAL F 147      13.458 -14.419  49.238  1.00  9.97           C  
ATOM   9742  C   VAL F 147      14.830 -15.037  49.474  1.00 12.27           C  
ATOM   9743  O   VAL F 147      15.766 -14.745  48.727  1.00 10.79           O  
ATOM   9744  CB  VAL F 147      13.405 -13.039  49.949  1.00  9.17           C  
ATOM   9745  CG1 VAL F 147      12.113 -12.338  49.624  1.00  8.21           C  
ATOM   9746  CG2 VAL F 147      13.586 -13.196  51.462  1.00  7.42           C  
ATOM   9747  N   GLY F 148      14.947 -15.878  50.508  1.00 14.41           N  
ATOM   9748  CA  GLY F 148      16.220 -16.520  50.820  1.00 15.32           C  
ATOM   9749  C   GLY F 148      16.679 -17.403  49.675  1.00 18.86           C  
ATOM   9750  O   GLY F 148      17.878 -17.585  49.443  1.00 20.08           O  
ATOM   9751  N   ALA F 149      15.696 -17.939  48.956  1.00 20.65           N  
ATOM   9752  CA  ALA F 149      15.917 -18.812  47.817  1.00 21.82           C  
ATOM   9753  C   ALA F 149      16.486 -18.044  46.627  1.00 23.58           C  
ATOM   9754  O   ALA F 149      17.125 -18.629  45.749  1.00 27.15           O  
ATOM   9755  CB  ALA F 149      14.616 -19.499  47.433  1.00 18.37           C  
ATOM   9756  N   GLN F 150      16.244 -16.742  46.578  1.00 24.57           N  
ATOM   9757  CA  GLN F 150      16.764 -15.931  45.487  1.00 27.50           C  
ATOM   9758  C   GLN F 150      18.294 -15.761  45.669  1.00 29.42           C  
ATOM   9759  O   GLN F 150      18.770 -15.150  46.631  1.00 31.30           O  
ATOM   9760  CB  GLN F 150      15.985 -14.614  45.404  1.00 27.27           C  
ATOM   9761  CG  GLN F 150      14.502 -14.868  45.060  1.00 29.16           C  
ATOM   9762  CD  GLN F 150      13.613 -13.652  45.341  1.00 32.40           C  
ATOM   9763  OE1 GLN F 150      14.044 -12.501  45.214  1.00 35.51           O  
ATOM   9764  NE2 GLN F 150      12.356 -13.912  45.705  1.00 31.71           N  
ATOM   9765  N   PRO F 151      19.076 -16.272  44.700  1.00 29.80           N  
ATOM   9766  CA  PRO F 151      20.540 -16.311  44.555  1.00 30.46           C  
ATOM   9767  C   PRO F 151      21.425 -15.105  44.898  1.00 31.69           C  
ATOM   9768  O   PRO F 151      22.647 -15.200  44.737  1.00 33.26           O  
ATOM   9769  CB  PRO F 151      20.725 -16.693  43.076  1.00 30.29           C  
ATOM   9770  CG  PRO F 151      19.479 -17.402  42.736  1.00 30.01           C  
ATOM   9771  CD  PRO F 151      18.444 -16.561  43.399  1.00 29.51           C  
ATOM   9772  N   ALA F 152      20.855 -13.978  45.310  1.00 31.88           N  
ATOM   9773  CA  ALA F 152      21.673 -12.811  45.624  1.00 30.60           C  
ATOM   9774  C   ALA F 152      21.375 -12.290  47.009  1.00 30.28           C  
ATOM   9775  O   ALA F 152      22.210 -11.638  47.637  1.00 30.40           O  
ATOM   9776  CB  ALA F 152      21.455 -11.718  44.590  1.00 30.85           C  
ATOM   9777  N   VAL F 153      20.196 -12.653  47.495  1.00 29.27           N  
ATOM   9778  CA  VAL F 153      19.701 -12.233  48.791  1.00 27.78           C  
ATOM   9779  C   VAL F 153      20.323 -13.054  49.913  1.00 26.01           C  
ATOM   9780  O   VAL F 153      19.826 -14.117  50.256  1.00 28.74           O  
ATOM   9781  CB  VAL F 153      18.169 -12.369  48.824  1.00 29.55           C  
ATOM   9782  CG1 VAL F 153      17.627 -11.707  50.059  1.00 31.78           C  
ATOM   9783  CG2 VAL F 153      17.553 -11.761  47.570  1.00 28.29           C  
ATOM   9784  N   ARG F 154      21.388 -12.526  50.503  1.00 22.66           N  
ATOM   9785  CA  ARG F 154      22.103 -13.203  51.571  1.00 19.59           C  
ATOM   9786  C   ARG F 154      21.626 -12.824  52.967  1.00 17.10           C  
ATOM   9787  O   ARG F 154      21.897 -13.520  53.945  1.00 16.93           O  
ATOM   9788  CB  ARG F 154      23.593 -12.880  51.443  1.00 24.57           C  
ATOM   9789  CG  ARG F 154      24.177 -13.228  50.071  1.00 29.59           C  
ATOM   9790  CD  ARG F 154      25.566 -12.638  49.830  1.00 36.00           C  
ATOM   9791  NE  ARG F 154      26.122 -13.145  48.566  1.00 40.31           N  
ATOM   9792  CZ  ARG F 154      26.055 -12.532  47.394  1.00 40.20           C  
ATOM   9793  NH1 ARG F 154      25.477 -11.358  47.294  1.00 41.74           N  
ATOM   9794  NH2 ARG F 154      26.531 -13.162  46.317  1.00 39.51           N  
ATOM   9795  N   ARG F 155      20.890 -11.734  53.066  1.00 16.73           N  
ATOM   9796  CA  ARG F 155      20.420 -11.265  54.359  1.00 16.85           C  
ATOM   9797  C   ARG F 155      19.029 -10.656  54.245  1.00 13.84           C  
ATOM   9798  O   ARG F 155      18.523 -10.459  53.140  1.00 14.54           O  
ATOM   9799  CB  ARG F 155      21.401 -10.199  54.890  1.00 17.79           C  
ATOM   9800  CG  ARG F 155      21.136  -9.728  56.335  1.00 19.77           C  
ATOM   9801  CD  ARG F 155      22.126  -8.656  56.772  1.00 21.70           C  
ATOM   9802  NE  ARG F 155      21.912  -7.432  56.008  1.00 22.32           N  
ATOM   9803  CZ  ARG F 155      22.750  -6.402  55.970  1.00 20.61           C  
ATOM   9804  NH1 ARG F 155      23.882  -6.422  56.652  1.00 20.09           N  
ATOM   9805  NH2 ARG F 155      22.436  -5.335  55.255  1.00 20.77           N  
ATOM   9806  N   ALA F 156      18.414 -10.387  55.392  1.00 10.99           N  
ATOM   9807  CA  ALA F 156      17.107  -9.739  55.467  1.00  9.74           C  
ATOM   9808  C   ALA F 156      17.254  -8.602  56.487  1.00 10.85           C  
ATOM   9809  O   ALA F 156      17.925  -8.763  57.512  1.00 11.82           O  
ATOM   9810  CB  ALA F 156      16.046 -10.720  55.924  1.00  6.53           C  
ATOM   9811  N   VAL F 157      16.683  -7.443  56.190  1.00 10.80           N  
ATOM   9812  CA  VAL F 157      16.774  -6.305  57.094  1.00  9.55           C  
ATOM   9813  C   VAL F 157      15.427  -5.623  57.273  1.00 11.20           C  
ATOM   9814  O   VAL F 157      14.610  -5.567  56.345  1.00 10.89           O  
ATOM   9815  CB  VAL F 157      17.788  -5.255  56.592  1.00  9.17           C  
ATOM   9816  CG1 VAL F 157      19.186  -5.801  56.688  1.00 10.38           C  
ATOM   9817  CG2 VAL F 157      17.475  -4.851  55.163  1.00  8.69           C  
ATOM   9818  N   LEU F 158      15.201  -5.108  58.475  1.00 11.86           N  
ATOM   9819  CA  LEU F 158      13.972  -4.411  58.805  1.00 11.26           C  
ATOM   9820  C   LEU F 158      14.214  -3.576  60.055  1.00 13.88           C  
ATOM   9821  O   LEU F 158      15.201  -3.772  60.765  1.00 14.79           O  
ATOM   9822  CB  LEU F 158      12.831  -5.409  59.049  1.00  8.12           C  
ATOM   9823  CG  LEU F 158      12.861  -6.383  60.226  1.00  5.31           C  
ATOM   9824  CD1 LEU F 158      12.488  -5.724  61.547  1.00  8.94           C  
ATOM   9825  CD2 LEU F 158      11.873  -7.486  59.940  1.00  6.34           C  
ATOM   9826  N   MET F 159      13.326  -2.624  60.305  1.00 16.07           N  
ATOM   9827  CA  MET F 159      13.415  -1.791  61.496  1.00 13.84           C  
ATOM   9828  C   MET F 159      12.080  -1.982  62.210  1.00 14.80           C  
ATOM   9829  O   MET F 159      11.059  -2.234  61.566  1.00 12.95           O  
ATOM   9830  CB  MET F 159      13.613  -0.322  61.123  1.00  9.90           C  
ATOM   9831  CG  MET F 159      12.363   0.378  60.633  1.00  9.09           C  
ATOM   9832  SD  MET F 159      12.698   1.960  59.860  1.00  5.17           S  
ATOM   9833  CE  MET F 159      12.289   1.576  58.157  1.00 10.73           C  
ATOM   9834  N   CYS F 160      12.093  -1.922  63.532  1.00 16.17           N  
ATOM   9835  CA  CYS F 160      10.871  -2.064  64.300  1.00 16.79           C  
ATOM   9836  C   CYS F 160      11.085  -1.320  65.601  1.00 18.03           C  
ATOM   9837  O   CYS F 160      12.213  -0.906  65.911  1.00 14.99           O  
ATOM   9838  CB  CYS F 160      10.595  -3.533  64.598  1.00 18.20           C  
ATOM   9839  SG  CYS F 160      11.805  -4.296  65.684  1.00 16.09           S  
ATOM   9840  N   GLU F 161      10.006  -1.116  66.347  1.00 20.27           N  
ATOM   9841  CA  GLU F 161      10.105  -0.432  67.625  1.00 21.15           C  
ATOM   9842  C   GLU F 161      10.556  -1.470  68.648  1.00 21.30           C  
ATOM   9843  O   GLU F 161      10.385  -2.668  68.421  1.00 23.05           O  
ATOM   9844  CB  GLU F 161       8.775   0.223  68.007  1.00 21.33           C  
ATOM   9845  CG  GLU F 161       7.531  -0.371  67.345  1.00 27.93           C  
ATOM   9846  CD  GLU F 161       6.803   0.706  66.525  1.00 31.69           C  
ATOM   9847  OE1 GLU F 161       6.764   1.880  66.972  1.00 28.26           O  
ATOM   9848  OE2 GLU F 161       6.268   0.371  65.437  1.00 32.22           O  
ATOM   9849  N   ASP F 162      11.114  -1.019  69.766  1.00 18.70           N  
ATOM   9850  CA  ASP F 162      11.623  -1.924  70.786  1.00 19.20           C  
ATOM   9851  C   ASP F 162      10.752  -3.096  71.194  1.00 18.35           C  
ATOM   9852  O   ASP F 162      11.260  -4.199  71.405  1.00 19.21           O  
ATOM   9853  CB  ASP F 162      12.064  -1.150  72.029  1.00 22.68           C  
ATOM   9854  CG  ASP F 162      13.421  -0.495  71.855  1.00 22.97           C  
ATOM   9855  OD1 ASP F 162      13.495   0.739  72.002  1.00 23.27           O  
ATOM   9856  OD2 ASP F 162      14.409  -1.215  71.579  1.00 27.22           O  
ATOM   9857  N   ALA F 163       9.449  -2.873  71.298  1.00 16.52           N  
ATOM   9858  CA  ALA F 163       8.536  -3.941  71.708  1.00 15.92           C  
ATOM   9859  C   ALA F 163       8.619  -5.196  70.825  1.00 16.31           C  
ATOM   9860  O   ALA F 163       8.570  -6.330  71.331  1.00 18.58           O  
ATOM   9861  CB  ALA F 163       7.103  -3.419  71.747  1.00 15.15           C  
ATOM   9862  N   LEU F 164       8.780  -4.990  69.518  1.00 12.14           N  
ATOM   9863  CA  LEU F 164       8.838  -6.084  68.558  1.00  8.73           C  
ATOM   9864  C   LEU F 164      10.192  -6.741  68.369  1.00  9.99           C  
ATOM   9865  O   LEU F 164      10.301  -7.734  67.634  1.00 11.52           O  
ATOM   9866  CB  LEU F 164       8.302  -5.624  67.207  1.00  4.87           C  
ATOM   9867  CG  LEU F 164       6.802  -5.325  67.224  1.00  3.83           C  
ATOM   9868  CD1 LEU F 164       6.413  -4.496  66.018  1.00  2.00           C  
ATOM   9869  CD2 LEU F 164       6.004  -6.605  67.296  1.00  2.00           C  
ATOM   9870  N   VAL F 165      11.218  -6.222  69.034  1.00  9.96           N  
ATOM   9871  CA  VAL F 165      12.558  -6.792  68.913  1.00 11.12           C  
ATOM   9872  C   VAL F 165      12.615  -8.276  69.323  1.00 12.92           C  
ATOM   9873  O   VAL F 165      13.093  -9.112  68.547  1.00 12.50           O  
ATOM   9874  CB  VAL F 165      13.590  -5.941  69.688  1.00  9.20           C  
ATOM   9875  CG1 VAL F 165      14.927  -6.664  69.794  1.00  7.10           C  
ATOM   9876  CG2 VAL F 165      13.745  -4.578  68.999  1.00  2.00           C  
ATOM   9877  N   PRO F 166      12.067  -8.632  70.513  1.00 14.25           N  
ATOM   9878  CA  PRO F 166      12.089 -10.033  70.954  1.00 13.77           C  
ATOM   9879  C   PRO F 166      11.319 -10.920  69.997  1.00 11.19           C  
ATOM   9880  O   PRO F 166      11.653 -12.085  69.825  1.00 12.78           O  
ATOM   9881  CB  PRO F 166      11.407  -9.968  72.318  1.00 11.61           C  
ATOM   9882  CG  PRO F 166      11.801  -8.633  72.810  1.00 14.16           C  
ATOM   9883  CD  PRO F 166      11.535  -7.780  71.591  1.00 15.08           C  
ATOM   9884  N   PHE F 167      10.286 -10.365  69.378  1.00  9.58           N  
ATOM   9885  CA  PHE F 167       9.472 -11.107  68.424  1.00  9.50           C  
ATOM   9886  C   PHE F 167      10.330 -11.495  67.230  1.00  9.37           C  
ATOM   9887  O   PHE F 167      10.456 -12.669  66.921  1.00  8.36           O  
ATOM   9888  CB  PHE F 167       8.282 -10.256  67.967  1.00  7.94           C  
ATOM   9889  CG  PHE F 167       7.490 -10.857  66.836  1.00  6.98           C  
ATOM   9890  CD1 PHE F 167       6.768 -12.039  67.010  1.00  7.81           C  
ATOM   9891  CD2 PHE F 167       7.425 -10.210  65.606  1.00  7.35           C  
ATOM   9892  CE1 PHE F 167       5.988 -12.560  65.968  1.00  6.48           C  
ATOM   9893  CE2 PHE F 167       6.647 -10.722  64.560  1.00  6.01           C  
ATOM   9894  CZ  PHE F 167       5.928 -11.896  64.739  1.00  4.16           C  
ATOM   9895  N   TYR F 168      10.964 -10.513  66.604  1.00 10.96           N  
ATOM   9896  CA  TYR F 168      11.802 -10.765  65.433  1.00 11.16           C  
ATOM   9897  C   TYR F 168      13.019 -11.681  65.663  1.00 11.60           C  
ATOM   9898  O   TYR F 168      13.503 -12.337  64.727  1.00  9.90           O  
ATOM   9899  CB  TYR F 168      12.214  -9.433  64.796  1.00  9.02           C  
ATOM   9900  CG  TYR F 168      11.069  -8.749  64.103  1.00  7.30           C  
ATOM   9901  CD1 TYR F 168      10.394  -9.374  63.066  1.00  6.31           C  
ATOM   9902  CD2 TYR F 168      10.625  -7.501  64.510  1.00  8.19           C  
ATOM   9903  CE1 TYR F 168       9.298  -8.777  62.461  1.00  7.48           C  
ATOM   9904  CE2 TYR F 168       9.526  -6.896  63.906  1.00  4.99           C  
ATOM   9905  CZ  TYR F 168       8.869  -7.543  62.884  1.00  2.18           C  
ATOM   9906  OH  TYR F 168       7.770  -6.976  62.297  1.00  2.00           O  
ATOM   9907  N   GLN F 169      13.493 -11.763  66.903  1.00 12.61           N  
ATOM   9908  CA  GLN F 169      14.631 -12.617  67.205  1.00 13.37           C  
ATOM   9909  C   GLN F 169      14.264 -14.091  67.056  1.00 13.32           C  
ATOM   9910  O   GLN F 169      15.132 -14.932  66.806  1.00 11.37           O  
ATOM   9911  CB  GLN F 169      15.179 -12.317  68.599  1.00 12.68           C  
ATOM   9912  CG  GLN F 169      15.801 -10.933  68.679  1.00 16.07           C  
ATOM   9913  CD  GLN F 169      16.242 -10.616  70.087  1.00 17.83           C  
ATOM   9914  OE1 GLN F 169      15.448 -10.152  70.911  1.00 21.15           O  
ATOM   9915  NE2 GLN F 169      17.521 -10.836  70.369  1.00 18.84           N  
ATOM   9916  N   ARG F 170      12.967 -14.377  67.105  1.00 13.50           N  
ATOM   9917  CA  ARG F 170      12.462 -15.743  66.973  1.00 14.06           C  
ATOM   9918  C   ARG F 170      12.569 -16.218  65.533  1.00 14.27           C  
ATOM   9919  O   ARG F 170      12.304 -17.387  65.236  1.00 17.34           O  
ATOM   9920  CB  ARG F 170      10.999 -15.827  67.426  1.00 14.56           C  
ATOM   9921  CG  ARG F 170      10.727 -15.058  68.698  1.00 16.89           C  
ATOM   9922  CD  ARG F 170       9.542 -15.566  69.473  1.00 19.85           C  
ATOM   9923  NE  ARG F 170       8.203 -15.271  68.981  1.00 21.46           N  
ATOM   9924  CZ  ARG F 170       7.162 -15.052  69.785  1.00 24.53           C  
ATOM   9925  NH1 ARG F 170       7.309 -15.082  71.112  1.00 21.48           N  
ATOM   9926  NH2 ARG F 170       5.952 -14.870  69.270  1.00 27.87           N  
ATOM   9927  N   PHE F 171      12.966 -15.314  64.642  1.00 11.94           N  
ATOM   9928  CA  PHE F 171      13.096 -15.642  63.221  1.00 11.98           C  
ATOM   9929  C   PHE F 171      14.545 -15.570  62.747  1.00  9.95           C  
ATOM   9930  O   PHE F 171      14.851 -15.867  61.581  1.00  7.09           O  
ATOM   9931  CB  PHE F 171      12.202 -14.711  62.386  1.00 10.33           C  
ATOM   9932  CG  PHE F 171      10.759 -14.736  62.805  1.00  7.43           C  
ATOM   9933  CD1 PHE F 171      10.312 -13.937  63.847  1.00  6.59           C  
ATOM   9934  CD2 PHE F 171       9.857 -15.596  62.197  1.00  7.51           C  
ATOM   9935  CE1 PHE F 171       8.992 -14.000  64.286  1.00  2.73           C  
ATOM   9936  CE2 PHE F 171       8.537 -15.664  62.625  1.00  6.04           C  
ATOM   9937  CZ  PHE F 171       8.108 -14.861  63.680  1.00  4.05           C  
ATOM   9938  N   GLY F 172      15.440 -15.230  63.668  1.00  9.01           N  
ATOM   9939  CA  GLY F 172      16.837 -15.117  63.327  1.00  6.78           C  
ATOM   9940  C   GLY F 172      17.343 -13.693  63.256  1.00  6.24           C  
ATOM   9941  O   GLY F 172      18.539 -13.476  63.093  1.00 10.00           O  
ATOM   9942  N   PHE F 173      16.456 -12.714  63.334  1.00  6.54           N  
ATOM   9943  CA  PHE F 173      16.896 -11.320  63.299  1.00  7.76           C  
ATOM   9944  C   PHE F 173      17.666 -10.962  64.580  1.00 10.63           C  
ATOM   9945  O   PHE F 173      17.376 -11.475  65.671  1.00  8.56           O  
ATOM   9946  CB  PHE F 173      15.710 -10.370  63.132  1.00  5.99           C  
ATOM   9947  CG  PHE F 173      15.072 -10.422  61.774  1.00  5.25           C  
ATOM   9948  CD1 PHE F 173      14.073 -11.355  61.488  1.00  6.47           C  
ATOM   9949  CD2 PHE F 173      15.452  -9.519  60.777  1.00  5.98           C  
ATOM   9950  CE1 PHE F 173      13.453 -11.388  60.215  1.00  3.76           C  
ATOM   9951  CE2 PHE F 173      14.840  -9.545  59.508  1.00  4.23           C  
ATOM   9952  CZ  PHE F 173      13.836 -10.483  59.232  1.00  2.00           C  
ATOM   9953  N   HIS F 174      18.651 -10.084  64.439  1.00 12.30           N  
ATOM   9954  CA  HIS F 174      19.474  -9.659  65.561  1.00 14.00           C  
ATOM   9955  C   HIS F 174      19.476  -8.138  65.687  1.00 14.11           C  
ATOM   9956  O   HIS F 174      19.426  -7.423  64.679  1.00 15.67           O  
ATOM   9957  CB  HIS F 174      20.909 -10.143  65.367  1.00 16.09           C  
ATOM   9958  CG  HIS F 174      21.058 -11.629  65.438  1.00 20.39           C  
ATOM   9959  ND1 HIS F 174      21.023 -12.327  66.626  1.00 23.64           N  
ATOM   9960  CD2 HIS F 174      21.249 -12.551  64.466  1.00 23.51           C  
ATOM   9961  CE1 HIS F 174      21.186 -13.615  66.386  1.00 21.45           C  
ATOM   9962  NE2 HIS F 174      21.324 -13.779  65.084  1.00 22.91           N  
ATOM   9963  N   PRO F 175      19.495  -7.621  66.930  1.00 13.18           N  
ATOM   9964  CA  PRO F 175      19.505  -6.172  67.134  1.00 13.28           C  
ATOM   9965  C   PRO F 175      20.762  -5.556  66.542  1.00 13.33           C  
ATOM   9966  O   PRO F 175      21.852  -6.025  66.795  1.00 13.17           O  
ATOM   9967  CB  PRO F 175      19.488  -6.048  68.653  1.00 10.31           C  
ATOM   9968  CG  PRO F 175      18.711  -7.247  69.078  1.00 11.50           C  
ATOM   9969  CD  PRO F 175      19.327  -8.321  68.217  1.00 14.08           C  
ATOM   9970  N   ALA F 176      20.591  -4.541  65.707  1.00 15.36           N  
ATOM   9971  CA  ALA F 176      21.709  -3.841  65.083  1.00 17.31           C  
ATOM   9972  C   ALA F 176      21.750  -2.369  65.540  1.00 18.86           C  
ATOM   9973  O   ALA F 176      22.262  -1.497  64.834  1.00 17.73           O  
ATOM   9974  CB  ALA F 176      21.607  -3.931  63.567  1.00 17.64           C  
ATOM   9975  N   GLY F 177      21.221  -2.104  66.738  1.00 18.18           N  
ATOM   9976  CA  GLY F 177      21.223  -0.755  67.269  1.00 16.16           C  
ATOM   9977  C   GLY F 177      20.209   0.144  66.610  1.00 15.63           C  
ATOM   9978  O   GLY F 177      19.341  -0.342  65.892  1.00 15.60           O  
ATOM   9979  N   PRO F 178      20.272   1.461  66.864  1.00 15.91           N  
ATOM   9980  CA  PRO F 178      19.345   2.442  66.294  1.00 15.79           C  
ATOM   9981  C   PRO F 178      19.368   2.439  64.777  1.00 13.32           C  
ATOM   9982  O   PRO F 178      20.417   2.268  64.168  1.00 13.91           O  
ATOM   9983  CB  PRO F 178      19.877   3.777  66.835  1.00 14.84           C  
ATOM   9984  CG  PRO F 178      20.542   3.395  68.103  1.00 16.42           C  
ATOM   9985  CD  PRO F 178      21.263   2.127  67.723  1.00 14.90           C  
ATOM   9986  N   CYS F 179      18.207   2.620  64.174  1.00 11.22           N  
ATOM   9987  CA  CYS F 179      18.131   2.677  62.739  1.00 12.91           C  
ATOM   9988  C   CYS F 179      18.287   4.145  62.337  1.00 16.42           C  
ATOM   9989  O   CYS F 179      17.682   5.038  62.942  1.00 19.27           O  
ATOM   9990  CB  CYS F 179      16.791   2.140  62.246  1.00  8.20           C  
ATOM   9991  SG  CYS F 179      16.775   1.902  60.444  1.00  8.53           S  
ATOM   9992  N   ALA F 180      19.090   4.394  61.311  1.00 18.31           N  
ATOM   9993  CA  ALA F 180      19.311   5.745  60.801  1.00 19.14           C  
ATOM   9994  C   ALA F 180      18.077   6.330  60.087  1.00 20.52           C  
ATOM   9995  O   ALA F 180      18.127   7.446  59.575  1.00 20.33           O  
ATOM   9996  CB  ALA F 180      20.499   5.741  59.851  1.00 18.73           C  
ATOM   9997  N   ILE F 181      16.986   5.570  60.024  1.00 22.05           N  
ATOM   9998  CA  ILE F 181      15.774   6.028  59.355  1.00 25.29           C  
ATOM   9999  C   ILE F 181      14.753   6.583  60.350  1.00 27.33           C  
ATOM  10000  O   ILE F 181      14.398   5.913  61.326  1.00 29.41           O  
ATOM  10001  CB  ILE F 181      15.102   4.888  58.552  1.00 24.66           C  
ATOM  10002  CG1 ILE F 181      16.085   4.278  57.559  1.00 23.78           C  
ATOM  10003  CG2 ILE F 181      13.899   5.417  57.793  1.00 25.91           C  
ATOM  10004  CD1 ILE F 181      15.497   3.104  56.790  1.00 23.95           C  
ATOM  10005  N   VAL F 182      14.306   7.815  60.114  1.00 28.91           N  
ATOM  10006  CA  VAL F 182      13.302   8.454  60.964  1.00 27.98           C  
ATOM  10007  C   VAL F 182      12.020   8.649  60.175  1.00 29.10           C  
ATOM  10008  O   VAL F 182      12.042   9.127  59.025  1.00 26.10           O  
ATOM  10009  CB  VAL F 182      13.768   9.822  61.520  1.00 26.76           C  
ATOM  10010  CG1 VAL F 182      14.792   9.612  62.620  1.00 24.86           C  
ATOM  10011  CG2 VAL F 182      14.344  10.693  60.407  1.00 25.09           C  
ATOM  10012  N   VAL F 183      10.916   8.194  60.759  1.00 32.13           N  
ATOM  10013  CA  VAL F 183       9.612   8.310  60.125  1.00 35.61           C  
ATOM  10014  C   VAL F 183       8.799   9.211  61.031  1.00 35.83           C  
ATOM  10015  O   VAL F 183       8.558   8.887  62.199  1.00 31.98           O  
ATOM  10016  CB  VAL F 183       8.918   6.931  59.945  1.00 36.69           C  
ATOM  10017  CG1 VAL F 183       7.565   7.111  59.247  1.00 41.18           C  
ATOM  10018  CG2 VAL F 183       9.807   5.992  59.120  1.00 38.53           C  
ATOM  10019  N   GLY F 184       8.435  10.374  60.502  1.00 37.70           N  
ATOM  10020  CA  GLY F 184       7.680  11.332  61.283  1.00 38.56           C  
ATOM  10021  C   GLY F 184       8.519  11.712  62.495  1.00 37.25           C  
ATOM  10022  O   GLY F 184       9.618  12.251  62.375  1.00 35.71           O  
ATOM  10023  N   SER F 185       8.021  11.376  63.670  1.00 38.02           N  
ATOM  10024  CA  SER F 185       8.724  11.681  64.909  1.00 38.61           C  
ATOM  10025  C   SER F 185       8.944  10.344  65.614  1.00 38.03           C  
ATOM  10026  O   SER F 185       8.780  10.224  66.836  1.00 37.16           O  
ATOM  10027  CB  SER F 185       7.858  12.611  65.775  1.00 39.70           C  
ATOM  10028  OG  SER F 185       7.400  13.741  65.039  1.00 41.69           O  
ATOM  10029  N   LEU F 186       9.297   9.336  64.817  1.00 37.60           N  
ATOM  10030  CA  LEU F 186       9.511   7.974  65.311  1.00 33.36           C  
ATOM  10031  C   LEU F 186      10.904   7.431  65.042  1.00 32.32           C  
ATOM  10032  O   LEU F 186      11.470   7.625  63.952  1.00 34.17           O  
ATOM  10033  CB  LEU F 186       8.490   7.028  64.672  1.00 30.24           C  
ATOM  10034  CG  LEU F 186       7.084   6.976  65.249  1.00 25.16           C  
ATOM  10035  CD1 LEU F 186       6.131   6.353  64.259  1.00 23.47           C  
ATOM  10036  CD2 LEU F 186       7.112   6.186  66.542  1.00 23.33           C  
ATOM  10037  N   THR F 187      11.438   6.732  66.035  1.00 30.97           N  
ATOM  10038  CA  THR F 187      12.759   6.112  65.937  1.00 32.73           C  
ATOM  10039  C   THR F 187      12.613   4.600  66.141  1.00 31.52           C  
ATOM  10040  O   THR F 187      11.789   4.166  66.956  1.00 31.47           O  
ATOM  10041  CB  THR F 187      13.739   6.690  66.981  1.00 33.48           C  
ATOM  10042  OG1 THR F 187      13.107   6.735  68.270  1.00 31.59           O  
ATOM  10043  CG2 THR F 187      14.210   8.094  66.556  1.00 36.85           C  
ATOM  10044  N   PHE F 188      13.427   3.805  65.444  1.00 28.52           N  
ATOM  10045  CA  PHE F 188      13.327   2.351  65.535  1.00 25.11           C  
ATOM  10046  C   PHE F 188      14.669   1.655  65.717  1.00 22.78           C  
ATOM  10047  O   PHE F 188      15.725   2.273  65.548  1.00 22.95           O  
ATOM  10048  CB  PHE F 188      12.690   1.803  64.254  1.00 25.72           C  
ATOM  10049  CG  PHE F 188      11.471   2.558  63.802  1.00 25.22           C  
ATOM  10050  CD1 PHE F 188      10.200   2.166  64.222  1.00 24.50           C  
ATOM  10051  CD2 PHE F 188      11.596   3.659  62.950  1.00 25.52           C  
ATOM  10052  CE1 PHE F 188       9.065   2.863  63.805  1.00 25.74           C  
ATOM  10053  CE2 PHE F 188      10.472   4.367  62.521  1.00 24.63           C  
ATOM  10054  CZ  PHE F 188       9.203   3.970  62.948  1.00 25.54           C  
ATOM  10055  N   THR F 189      14.617   0.364  66.050  1.00 20.78           N  
ATOM  10056  CA  THR F 189      15.811  -0.465  66.214  1.00 20.95           C  
ATOM  10057  C   THR F 189      15.988  -1.245  64.905  1.00 20.94           C  
ATOM  10058  O   THR F 189      15.002  -1.733  64.348  1.00 23.69           O  
ATOM  10059  CB  THR F 189      15.637  -1.498  67.366  1.00 20.58           C  
ATOM  10060  OG1 THR F 189      15.383  -0.827  68.606  1.00 22.46           O  
ATOM  10061  CG2 THR F 189      16.877  -2.333  67.525  1.00 20.79           C  
ATOM  10062  N   GLU F 190      17.212  -1.316  64.384  1.00 20.24           N  
ATOM  10063  CA  GLU F 190      17.485  -2.053  63.143  1.00 20.42           C  
ATOM  10064  C   GLU F 190      17.683  -3.551  63.440  1.00 18.68           C  
ATOM  10065  O   GLU F 190      18.260  -3.916  64.470  1.00 18.38           O  
ATOM  10066  CB  GLU F 190      18.721  -1.475  62.441  1.00 21.04           C  
ATOM  10067  CG  GLU F 190      18.948  -2.031  61.041  1.00 23.77           C  
ATOM  10068  CD  GLU F 190      19.740  -1.046  60.193  1.00 24.64           C  
ATOM  10069  OE1 GLU F 190      19.553   0.172  60.357  1.00 27.63           O  
ATOM  10070  OE2 GLU F 190      20.539  -1.489  59.344  1.00 24.54           O  
ATOM  10071  N   MET F 191      17.206  -4.413  62.548  1.00 17.91           N  
ATOM  10072  CA  MET F 191      17.313  -5.863  62.744  1.00 15.44           C  
ATOM  10073  C   MET F 191      17.906  -6.503  61.502  1.00 13.37           C  
ATOM  10074  O   MET F 191      17.475  -6.203  60.388  1.00 14.49           O  
ATOM  10075  CB  MET F 191      15.922  -6.487  62.967  1.00 15.90           C  
ATOM  10076  CG  MET F 191      15.096  -5.940  64.114  1.00  9.75           C  
ATOM  10077  SD  MET F 191      15.749  -6.403  65.716  1.00 11.49           S  
ATOM  10078  CE  MET F 191      15.080  -7.999  65.922  1.00  4.89           C  
ATOM  10079  N   HIS F 192      18.857  -7.408  61.696  1.00 11.29           N  
ATOM  10080  CA  HIS F 192      19.510  -8.113  60.588  1.00  9.13           C  
ATOM  10081  C   HIS F 192      19.355  -9.622  60.722  1.00  8.75           C  
ATOM  10082  O   HIS F 192      19.556 -10.180  61.803  1.00  9.30           O  
ATOM  10083  CB  HIS F 192      20.994  -7.784  60.534  1.00  7.02           C  
ATOM  10084  CG  HIS F 192      21.288  -6.347  60.251  1.00  5.89           C  
ATOM  10085  ND1 HIS F 192      22.491  -5.758  60.580  1.00  6.33           N  
ATOM  10086  CD2 HIS F 192      20.555  -5.391  59.637  1.00  6.12           C  
ATOM  10087  CE1 HIS F 192      22.488  -4.500  60.179  1.00  8.62           C  
ATOM  10088  NE2 HIS F 192      21.324  -4.252  59.603  1.00  9.28           N  
ATOM  10089  N   CYS F 193      19.018 -10.280  59.618  1.00  9.93           N  
ATOM  10090  CA  CYS F 193      18.829 -11.729  59.604  1.00  9.27           C  
ATOM  10091  C   CYS F 193      19.615 -12.384  58.469  1.00 12.02           C  
ATOM  10092  O   CYS F 193      19.342 -12.140  57.291  1.00 12.78           O  
ATOM  10093  CB  CYS F 193      17.352 -12.050  59.443  1.00  4.54           C  
ATOM  10094  SG  CYS F 193      16.958 -13.775  59.450  1.00  2.00           S  
ATOM  10095  N   SER F 194      20.596 -13.202  58.824  1.00 13.07           N  
ATOM  10096  CA  SER F 194      21.400 -13.883  57.826  1.00 14.01           C  
ATOM  10097  C   SER F 194      20.586 -14.992  57.167  1.00 13.61           C  
ATOM  10098  O   SER F 194      19.798 -15.660  57.826  1.00 12.80           O  
ATOM  10099  CB  SER F 194      22.656 -14.473  58.468  1.00 17.82           C  
ATOM  10100  OG  SER F 194      23.597 -14.861  57.477  1.00 20.79           O  
ATOM  10101  N   LEU F 195      20.756 -15.146  55.861  1.00 12.07           N  
ATOM  10102  CA  LEU F 195      20.063 -16.177  55.102  1.00 15.44           C  
ATOM  10103  C   LEU F 195      21.184 -16.966  54.427  1.00 17.48           C  
ATOM  10104  O   LEU F 195      22.051 -17.511  55.117  1.00 19.75           O  
ATOM  10105  CB  LEU F 195      19.145 -15.550  54.045  1.00 14.69           C  
ATOM  10106  CG  LEU F 195      18.027 -14.592  54.448  1.00 14.76           C  
ATOM  10107  CD1 LEU F 195      17.539 -13.819  53.227  1.00 16.11           C  
ATOM  10108  CD2 LEU F 195      16.896 -15.354  55.091  1.00 11.44           C  
ATOM  10109  N   ARG F 196      21.183 -17.014  53.091  1.00 17.48           N  
ATOM  10110  CA  ARG F 196      22.222 -17.712  52.337  1.00 18.39           C  
ATOM  10111  C   ARG F 196      23.504 -16.906  52.351  1.00 15.04           C  
ATOM  10112  O   ARG F 196      24.049 -16.629  53.405  1.00 12.71           O  
ATOM  10113  CB  ARG F 196      21.798 -17.989  50.878  1.00 19.81           C  
ATOM  10114  CG  ARG F 196      21.025 -16.878  50.186  1.00 22.66           C  
ATOM  10115  CD  ARG F 196      21.327 -16.809  48.689  1.00 28.89           C  
ATOM  10116  NE  ARG F 196      22.461 -15.932  48.388  1.00 37.48           N  
ATOM  10117  CZ  ARG F 196      23.330 -16.111  47.387  1.00 41.47           C  
ATOM  10118  NH1 ARG F 196      23.218 -17.151  46.560  1.00 40.03           N  
ATOM  10119  NH2 ARG F 196      24.299 -15.218  47.183  1.00 43.99           N  
TER   10120      ARG F 196                                                      
END
MOLECULE T0417.pdb
ATOM      1  N   ARG    26      -8.346 -19.992  57.885  1.00 43.52           N  
ATOM      2  CA  ARG    26      -6.996 -20.186  57.309  1.00 42.87           C  
ATOM      3  C   ARG    26      -6.720 -19.292  56.082  1.00 40.26           C  
ATOM      4  O   ARG    26      -7.623 -18.925  55.355  1.00 41.81           O  
ATOM      5  CB  ARG    26      -6.794 -21.646  56.944  1.00 44.22           C  
ATOM      6  CG  ARG    26      -5.528 -22.164  57.568  1.00 50.33           C  
ATOM      7  CD  ARG    26      -4.338 -22.107  56.614  1.00 57.94           C  
ATOM      8  NE  ARG    26      -3.925 -23.473  56.307  1.00 63.20           N  
ATOM      9  CZ  ARG    26      -3.141 -24.214  57.094  1.00 67.19           C  
ATOM     10  NH1 ARG    26      -2.670 -23.712  58.236  1.00 67.80           N  
ATOM     11  NH2 ARG    26      -2.832 -25.469  56.744  1.00 69.45           N  
ATOM     12  N   TYR    27      -5.463 -18.989  55.840  1.00 37.22           N  
ATOM     13  CA  TYR    27      -5.081 -18.034  54.827  1.00 33.87           C  
ATOM     14  C   TYR    27      -4.220 -18.789  53.867  1.00 33.61           C  
ATOM     15  O   TYR    27      -3.593 -19.751  54.270  1.00 34.13           O  
ATOM     16  CB  TYR    27      -4.241 -16.978  55.500  1.00 33.02           C  
ATOM     17  CG  TYR    27      -5.094 -16.062  56.338  1.00 32.33           C  
ATOM     18  CD1 TYR    27      -5.863 -15.072  55.730  1.00 32.08           C  
ATOM     19  CD2 TYR    27      -5.190 -16.215  57.741  1.00 36.16           C  
ATOM     20  CE1 TYR    27      -6.682 -14.200  56.491  1.00 27.91           C  
ATOM     21  CE2 TYR    27      -6.007 -15.357  58.503  1.00 34.22           C  
ATOM     22  CZ  TYR    27      -6.756 -14.378  57.859  1.00 30.13           C  
ATOM     23  OH  TYR    27      -7.556 -13.514  58.581  1.00 32.02           O  
ATOM     24  N   HIS    28      -4.200 -18.399  52.596  1.00 31.38           N  
ATOM     25  CA  HIS    28      -3.133 -18.828  51.704  1.00 29.66           C  
ATOM     26  C   HIS    28      -2.222 -17.609  51.439  1.00 29.79           C  
ATOM     27  O   HIS    28      -2.664 -16.473  51.590  1.00 29.92           O  
ATOM     28  CB  HIS    28      -3.714 -19.387  50.414  1.00 29.69           C  
ATOM     29  CG  HIS    28      -4.733 -18.514  49.781  1.00 27.79           C  
ATOM     30  ND1 HIS    28      -4.406 -17.527  48.880  1.00 33.31           N  
ATOM     31  CD2 HIS    28      -6.075 -18.479  49.906  1.00 27.26           C  
ATOM     32  CE1 HIS    28      -5.499 -16.883  48.515  1.00 30.56           C  
ATOM     33  NE2 HIS    28      -6.527 -17.455  49.111  1.00 34.84           N  
ATOM     34  N   LEU    29      -0.964 -17.859  51.082  1.00 28.47           N  
ATOM     35  CA  LEU    29       0.044 -16.840  50.892  1.00 28.69           C  
ATOM     36  C   LEU    29       0.368 -16.782  49.412  1.00 29.46           C  
ATOM     37  O   LEU    29       0.441 -17.827  48.773  1.00 26.65           O  
ATOM     38  CB  LEU    29       1.315 -17.178  51.633  1.00 28.79           C  
ATOM     39  CG  LEU    29       1.209 -17.332  53.136  1.00 31.32           C  
ATOM     40  CD1 LEU    29       2.584 -17.475  53.797  1.00 31.37           C  
ATOM     41  CD2 LEU    29       0.465 -16.152  53.746  1.00 27.79           C  
ATOM     42  N   ARG    30       0.472 -15.592  48.857  1.00 26.45           N  
ATOM     43  CA  ARG    30       0.850 -15.438  47.421  1.00 28.49           C  
ATOM     44  C   ARG    30       1.503 -14.076  47.223  1.00 28.52           C  
ATOM     45  O   ARG    30       1.246 -13.151  48.023  1.00 28.69           O  
ATOM     46  CB  ARG    30      -0.398 -15.536  46.509  1.00 27.55           C  
ATOM     47  CG  ARG    30      -1.509 -14.555  46.889  1.00 29.96           C  
ATOM     48  CD  ARG    30      -2.569 -14.424  45.782  1.00 30.98           C  
ATOM     49  NE  ARG    30      -3.645 -13.487  46.083  1.00 29.51           N  
ATOM     50  CZ  ARG    30      -3.588 -12.183  45.767  1.00 29.30           C  
ATOM     51  NH1 ARG    30      -2.490 -11.696  45.232  1.00 27.51           N  
ATOM     52  NH2 ARG    30      -4.599 -11.364  46.024  1.00 30.05           N  
ATOM     53  N   PRO    31       2.289 -13.912  46.147  1.00 29.31           N  
ATOM     54  CA  PRO    31       2.781 -12.578  45.785  1.00 29.25           C  
ATOM     55  C   PRO    31       1.576 -11.677  45.522  1.00 28.45           C  
ATOM     56  O   PRO    31       0.538 -12.140  45.040  1.00 28.22           O  
ATOM     57  CB  PRO    31       3.568 -12.793  44.450  1.00 27.62           C  
ATOM     58  CG  PRO    31       3.832 -14.298  44.399  1.00 31.77           C  
ATOM     59  CD  PRO    31       2.775 -14.983  45.244  1.00 31.08           C  
ATOM     60  N   PRO    32       1.722 -10.383  45.776  1.00 28.65           N  
ATOM     61  CA  PRO    32       0.600  -9.513  45.417  1.00 27.94           C  
ATOM     62  C   PRO    32       0.530  -9.334  43.884  1.00 29.66           C  
ATOM     63  O   PRO    32       1.502  -9.662  43.150  1.00 28.33           O  
ATOM     64  CB  PRO    32       0.978  -8.155  46.056  1.00 28.26           C  
ATOM     65  CG  PRO    32       2.525  -8.120  45.941  1.00 27.98           C  
ATOM     66  CD  PRO    32       2.869  -9.652  46.336  1.00 27.09           C  
ATOM     67  N   ARG    33      -0.623  -8.867  43.407  1.00 30.25           N  
ATOM     68  CA  ARG    33      -0.841  -8.522  41.995  1.00 32.43           C  
ATOM     69  C   ARG    33      -1.143  -7.022  42.003  1.00 32.10           C  
ATOM     70  O   ARG    33      -1.538  -6.471  43.032  1.00 30.61           O  
ATOM     71  CB  ARG    33      -2.040  -9.308  41.456  1.00 33.09           C  
ATOM     72  CG  ARG    33      -1.665 -10.826  41.301  1.00 36.12           C  
ATOM     73  CD  ARG    33      -2.773 -11.718  40.723  1.00 38.47           C  
ATOM     74  NE  ARG    33      -3.928 -11.758  41.601  1.00 48.20           N  
ATOM     75  CZ  ARG    33      -4.301 -12.801  42.347  1.00 50.41           C  
ATOM     76  NH1 ARG    33      -3.618 -13.963  42.324  1.00 50.43           N  
ATOM     77  NH2 ARG    33      -5.386 -12.672  43.108  1.00 47.97           N  
ATOM     78  N   ARG    34      -1.037  -6.379  40.845  1.00 32.63           N  
ATOM     79  CA  ARG    34      -1.252  -4.951  40.766  1.00 33.66           C  
ATOM     80  C   ARG    34      -2.555  -4.456  41.359  1.00 33.45           C  
ATOM     81  O   ARG    34      -2.594  -3.395  42.050  1.00 34.67           O  
ATOM     82  CB  ARG    34      -1.219  -4.558  39.287  1.00 36.26           C  
ATOM     83  CG  ARG    34      -0.054  -3.698  38.981  1.00 44.64           C  
ATOM     84  CD  ARG    34      -0.449  -2.237  38.486  1.00 50.45           C  
ATOM     85  NE  ARG    34      -1.377  -2.197  37.345  1.00 50.08           N  
ATOM     86  CZ  ARG    34      -1.109  -2.490  36.060  1.00 50.81           C  
ATOM     87  NH1 ARG    34       0.080  -2.879  35.630  1.00 48.97           N  
ATOM     88  NH2 ARG    34      -2.090  -2.385  35.180  1.00 44.07           N  
ATOM     89  N   ASN    35      -3.622  -5.210  41.135  1.00 31.69           N  
ATOM     90  CA  ASN    35      -4.929  -4.832  41.671  1.00 32.20           C  
ATOM     91  C   ASN    35      -5.137  -5.068  43.185  1.00 32.68           C  
ATOM     92  O   ASN    35      -6.252  -4.815  43.725  1.00 33.44           O  
ATOM     93  CB  ASN    35      -6.052  -5.445  40.842  1.00 32.80           C  
ATOM     94  CG  ASN    35      -6.124  -4.799  39.448  1.00 37.02           C  
ATOM     95  OD1 ASN    35      -5.603  -3.680  39.256  1.00 38.28           O  
ATOM     96  ND2 ASN    35      -6.720  -5.489  38.486  1.00 37.56           N  
ATOM     97  N   ASP    36      -4.080  -5.517  43.875  1.00 31.38           N  
ATOM     98  CA  ASP    36      -4.155  -5.689  45.326  1.00 30.72           C  
ATOM     99  C   ASP    36      -3.811  -4.373  46.002  1.00 31.33           C  
ATOM    100  O   ASP    36      -3.940  -4.265  47.243  1.00 29.20           O  
ATOM    101  CB  ASP    36      -3.145  -6.743  45.823  1.00 30.37           C  
ATOM    102  CG  ASP    36      -3.559  -8.155  45.498  1.00 33.10           C  
ATOM    103  OD1 ASP    36      -4.793  -8.438  45.430  1.00 31.11           O  
ATOM    104  OD2 ASP    36      -2.643  -9.017  45.303  1.00 34.74           O  
ATOM    105  N   GLY    37      -3.302  -3.397  45.233  1.00 28.72           N  
ATOM    106  CA  GLY    37      -2.790  -2.139  45.866  1.00 29.06           C  
ATOM    107  C   GLY    37      -3.772  -1.464  46.818  1.00 27.90           C  
ATOM    108  O   GLY    37      -3.379  -1.073  47.918  1.00 28.59           O  
ATOM    109  N   ALA    38      -5.052  -1.328  46.411  1.00 26.81           N  
ATOM    110  CA  ALA    38      -6.050  -0.648  47.253  1.00 27.86           C  
ATOM    111  C   ALA    38      -6.302  -1.434  48.538  1.00 26.85           C  
ATOM    112  O   ALA    38      -6.393  -0.859  49.613  1.00 26.00           O  
ATOM    113  CB  ALA    38      -7.404  -0.441  46.524  1.00 28.58           C  
ATOM    114  N   ALA    39      -6.420  -2.743  48.423  1.00 26.15           N  
ATOM    115  CA  ALA    39      -6.681  -3.541  49.640  1.00 27.31           C  
ATOM    116  C   ALA    39      -5.485  -3.539  50.585  1.00 26.72           C  
ATOM    117  O   ALA    39      -5.676  -3.566  51.841  1.00 25.98           O  
ATOM    118  CB  ALA    39      -6.981  -4.976  49.266  1.00 28.08           C  
ATOM    119  N   ILE    40      -4.259  -3.510  50.021  1.00 24.99           N  
ATOM    120  CA  ILE    40      -3.084  -3.519  50.875  1.00 25.29           C  
ATOM    121  C   ILE    40      -2.991  -2.167  51.564  1.00 25.64           C  
ATOM    122  O   ILE    40      -2.692  -2.061  52.785  1.00 26.59           O  
ATOM    123  CB  ILE    40      -1.771  -3.842  50.062  1.00 26.37           C  
ATOM    124  CG1 ILE    40      -1.765  -5.307  49.582  1.00 25.21           C  
ATOM    125  CG2 ILE    40      -0.501  -3.482  50.887  1.00 28.01           C  
ATOM    126  CD1 ILE    40      -0.820  -5.493  48.336  1.00 25.71           C  
ATOM    127  N   HIS    41      -3.226  -1.124  50.812  1.00 24.91           N  
ATOM    128  CA  HIS    41      -3.290   0.226  51.415  1.00 26.65           C  
ATOM    129  C   HIS    41      -4.357   0.361  52.532  1.00 27.01           C  
ATOM    130  O   HIS    41      -4.089   0.938  53.614  1.00 27.31           O  
ATOM    131  CB  HIS    41      -3.421   1.257  50.299  1.00 27.52           C  
ATOM    132  CG  HIS    41      -3.471   2.689  50.767  1.00 29.79           C  
ATOM    133  ND1 HIS    41      -4.657   3.352  50.971  1.00 36.10           N  
ATOM    134  CD2 HIS    41      -2.487   3.553  51.120  1.00 30.28           C  
ATOM    135  CE1 HIS    41      -4.394   4.583  51.409  1.00 34.52           C  
ATOM    136  NE2 HIS    41      -3.080   4.732  51.463  1.00 30.04           N  
ATOM    137  N   GLN    42      -5.549  -0.181  52.287  1.00 26.19           N  
ATOM    138  CA  GLN    42      -6.575  -0.203  53.331  1.00 28.05           C  
ATOM    139  C   GLN    42      -6.133  -1.033  54.531  1.00 27.46           C  
ATOM    140  O   GLN    42      -6.320  -0.609  55.663  1.00 25.37           O  
ATOM    141  CB  GLN    42      -7.895  -0.793  52.829  1.00 28.03           C  
ATOM    142  CG  GLN    42      -9.065  -0.608  53.916  1.00 28.66           C  
ATOM    143  CD  GLN    42     -10.414  -1.142  53.475  1.00 33.32           C  
ATOM    144  OE1 GLN    42     -10.612  -1.447  52.300  1.00 41.41           O  
ATOM    145  NE2 GLN    42     -11.368  -1.274  54.435  1.00 35.69           N  
ATOM    146  N   LEU    43      -5.553  -2.207  54.280  1.00 27.33           N  
ATOM    147  CA  LEU    43      -5.006  -3.048  55.404  1.00 26.81           C  
ATOM    148  C   LEU    43      -4.003  -2.253  56.236  1.00 28.18           C  
ATOM    149  O   LEU    43      -4.098  -2.231  57.472  1.00 26.75           O  
ATOM    150  CB  LEU    43      -4.357  -4.340  54.851  1.00 27.64           C  
ATOM    151  CG  LEU    43      -3.543  -5.187  55.878  1.00 28.07           C  
ATOM    152  CD1 LEU    43      -4.447  -5.675  57.026  1.00 28.03           C  
ATOM    153  CD2 LEU    43      -2.696  -6.319  55.219  1.00 26.79           C  
ATOM    154  N   VAL    44      -3.038  -1.578  55.598  1.00 25.32           N  
ATOM    155  CA  VAL    44      -2.092  -0.803  56.424  1.00 27.38           C  
ATOM    156  C   VAL    44      -2.810   0.307  57.189  1.00 28.00           C  
ATOM    157  O   VAL    44      -2.476   0.543  58.374  1.00 28.99           O  
ATOM    158  CB  VAL    44      -0.938  -0.208  55.564  1.00 26.93           C  
ATOM    159  CG1 VAL    44      -0.058   0.721  56.426  1.00 25.38           C  
ATOM    160  CG2 VAL    44      -0.085  -1.372  54.916  1.00 26.21           C  
ATOM    161  N   SER    45      -3.758   1.019  56.558  0.50 29.31           N  
ATOM    163  CA  SER    45      -4.530   2.069  57.290  0.50 28.98           C  
ATOM    165  C   SER    45      -5.204   1.510  58.552  0.50 30.14           C  
ATOM    167  O   SER    45      -5.327   2.219  59.557  0.50 28.81           O  
ATOM    169  CB  SER    45      -5.610   2.739  56.415  0.50 29.99           C  
ATOM    171  OG  SER    45      -6.666   1.839  56.087  0.50 26.42           O  
ATOM    173  N   GLU    46      -5.603   0.235  58.518  1.00 29.41           N  
ATOM    174  CA  GLU    46      -6.333  -0.365  59.663  1.00 30.42           C  
ATOM    175  C   GLU    46      -5.380  -1.115  60.592  1.00 30.61           C  
ATOM    176  O   GLU    46      -5.800  -1.893  61.437  1.00 32.07           O  
ATOM    177  CB  GLU    46      -7.385  -1.351  59.122  1.00 29.60           C  
ATOM    178  CG  GLU    46      -8.561  -0.603  58.445  1.00 30.64           C  
ATOM    179  CD  GLU    46      -9.644  -1.536  57.896  1.00 33.95           C  
ATOM    180  OE1 GLU    46      -9.492  -2.770  58.054  1.00 35.13           O  
ATOM    181  OE2 GLU    46     -10.681  -1.019  57.398  1.00 37.39           O  
ATOM    182  N   CYS    47      -4.082  -0.928  60.402  1.00 29.99           N  
ATOM    183  CA  CYS    47      -3.106  -1.482  61.336  1.00 32.22           C  
ATOM    184  C   CYS    47      -2.233  -0.385  61.990  1.00 33.20           C  
ATOM    185  O   CYS    47      -0.989  -0.469  61.869  1.00 34.01           O  
ATOM    186  CB  CYS    47      -2.151  -2.416  60.602  1.00 31.67           C  
ATOM    187  SG  CYS    47      -2.907  -3.952  59.988  1.00 35.54           S  
ATOM    188  N   PRO    48      -2.848   0.636  62.636  1.00 34.49           N  
ATOM    189  CA  PRO    48      -1.960   1.588  63.288  1.00 36.81           C  
ATOM    190  C   PRO    48      -1.179   0.786  64.356  1.00 38.94           C  
ATOM    191  O   PRO    48      -1.737  -0.126  64.961  1.00 40.76           O  
ATOM    192  CB  PRO    48      -2.923   2.615  63.920  1.00 36.20           C  
ATOM    193  CG  PRO    48      -4.289   1.884  64.025  1.00 35.83           C  
ATOM    194  CD  PRO    48      -4.276   0.968  62.844  1.00 33.95           C  
ATOM    195  N   PRO    49       0.079   1.149  64.617  1.00 39.35           N  
ATOM    196  CA  PRO    49       0.663   2.420  64.271  1.00 38.77           C  
ATOM    197  C   PRO    49       1.584   2.354  63.048  1.00 37.29           C  
ATOM    198  O   PRO    49       2.427   3.245  62.892  1.00 37.46           O  
ATOM    199  CB  PRO    49       1.470   2.748  65.541  1.00 40.01           C  
ATOM    200  CG  PRO    49       2.034   1.303  65.928  1.00 40.37           C  
ATOM    201  CD  PRO    49       1.058   0.279  65.304  1.00 41.34           C  
ATOM    202  N   LEU    50       1.450   1.339  62.184  1.00 33.60           N  
ATOM    203  CA  LEU    50       2.284   1.281  60.981  1.00 31.37           C  
ATOM    204  C   LEU    50       2.182   2.631  60.288  1.00 31.20           C  
ATOM    205  O   LEU    50       1.073   3.172  60.214  1.00 29.83           O  
ATOM    206  CB  LEU    50       1.787   0.209  59.982  1.00 30.89           C  
ATOM    207  CG  LEU    50       2.256  -1.240  60.149  1.00 35.36           C  
ATOM    208  CD1 LEU    50       1.696  -2.152  58.999  1.00 34.13           C  
ATOM    209  CD2 LEU    50       3.791  -1.342  60.257  1.00 39.60           C  
ATOM    210  N   ASP    51       3.285   3.131  59.727  1.00 30.23           N  
ATOM    211  CA  ASP    51       3.265   4.391  58.953  1.00 32.14           C  
ATOM    212  C   ASP    51       2.478   4.083  57.654  1.00 32.72           C  
ATOM    213  O   ASP    51       2.745   3.101  56.961  1.00 33.65           O  
ATOM    214  CB  ASP    51       4.700   4.857  58.586  1.00 32.53           C  
ATOM    215  CG  ASP    51       5.532   5.165  59.820  1.00 36.98           C  
ATOM    216  OD1 ASP    51       4.926   5.494  60.883  1.00 37.69           O  
ATOM    217  OD2 ASP    51       6.775   5.045  59.780  1.00 40.44           O  
ATOM    218  N   LEU    52       1.508   4.921  57.326  1.00 32.10           N  
ATOM    219  CA  LEU    52       0.755   4.713  56.085  1.00 31.13           C  
ATOM    220  C   LEU    52       1.502   5.463  54.972  1.00 30.90           C  
ATOM    221  O   LEU    52       2.012   6.533  55.194  1.00 36.52           O  
ATOM    222  CB  LEU    52      -0.616   5.308  56.262  1.00 32.12           C  
ATOM    223  CG  LEU    52      -1.594   5.045  55.104  1.00 31.45           C  
ATOM    224  CD1 LEU    52      -1.847   3.528  54.862  1.00 31.65           C  
ATOM    225  CD2 LEU    52      -2.930   5.737  55.507  1.00 29.87           C  
ATOM    226  N   ASN    53       1.700   4.857  53.830  1.00 28.39           N  
ATOM    227  CA  ASN    53       2.218   5.593  52.673  1.00 26.31           C  
ATOM    228  C   ASN    53       1.104   5.797  51.683  1.00 26.38           C  
ATOM    229  O   ASN    53      -0.011   5.313  51.913  1.00 25.57           O  
ATOM    230  CB  ASN    53       3.383   4.793  52.074  1.00 25.78           C  
ATOM    231  CG  ASN    53       4.546   4.710  53.057  1.00 27.10           C  
ATOM    232  OD1 ASN    53       5.246   5.690  53.267  1.00 26.14           O  
ATOM    233  ND2 ASN    53       4.730   3.537  53.722  1.00 24.92           N  
ATOM    234  N   SER    54       1.383   6.532  50.596  1.00 25.16           N  
ATOM    235  CA  SER    54       0.354   6.835  49.608  1.00 25.16           C  
ATOM    236  C   SER    54      -0.118   5.530  48.964  1.00 23.53           C  
ATOM    237  O   SER    54       0.604   4.507  48.912  1.00 25.73           O  
ATOM    238  CB  SER    54       0.928   7.784  48.521  1.00 24.19           C  
ATOM    239  OG  SER    54       1.966   7.067  47.822  1.00 26.19           O  
ATOM    240  N   LEU    55      -1.303   5.553  48.411  1.00 23.74           N  
ATOM    241  CA  LEU    55      -1.746   4.390  47.605  1.00 25.96           C  
ATOM    242  C   LEU    55      -0.731   3.952  46.558  1.00 25.61           C  
ATOM    243  O   LEU    55      -0.473   2.753  46.399  1.00 23.93           O  
ATOM    244  CB  LEU    55      -3.088   4.685  46.939  1.00 26.47           C  
ATOM    245  CG  LEU    55      -3.615   3.669  45.903  1.00 29.78           C  
ATOM    246  CD1 LEU    55      -3.842   2.311  46.576  1.00 28.35           C  
ATOM    247  CD2 LEU    55      -4.939   4.191  45.224  1.00 28.94           C  
ATOM    248  N   TYR    56      -0.213   4.934  45.826  1.00 25.77           N  
ATOM    249  CA  TYR    56       0.735   4.673  44.780  1.00 27.07           C  
ATOM    250  C   TYR    56       1.969   3.962  45.279  1.00 25.81           C  
ATOM    251  O   TYR    56       2.496   3.114  44.599  1.00 25.80           O  
ATOM    252  CB  TYR    56       1.128   6.024  44.188  1.00 29.90           C  
ATOM    253  CG  TYR    56       1.860   5.905  42.933  1.00 34.30           C  
ATOM    254  CD1 TYR    56       3.208   6.312  42.863  1.00 36.92           C  
ATOM    255  CD2 TYR    56       1.239   5.418  41.780  1.00 35.76           C  
ATOM    256  CE1 TYR    56       3.924   6.250  41.701  1.00 37.66           C  
ATOM    257  CE2 TYR    56       1.978   5.346  40.576  1.00 41.36           C  
ATOM    258  CZ  TYR    56       3.330   5.756  40.563  1.00 38.17           C  
ATOM    259  OH  TYR    56       4.107   5.744  39.401  1.00 37.72           O  
ATOM    260  N   ALA    57       2.430   4.245  46.498  1.00 24.29           N  
ATOM    261  CA  ALA    57       3.600   3.522  47.027  1.00 24.86           C  
ATOM    262  C   ALA    57       3.300   2.043  47.112  1.00 26.52           C  
ATOM    263  O   ALA    57       4.136   1.206  46.742  1.00 24.62           O  
ATOM    264  CB  ALA    57       4.022   4.041  48.460  1.00 25.11           C  
ATOM    265  N   TYR    58       2.085   1.677  47.549  1.00 25.92           N  
ATOM    266  CA  TYR    58       1.745   0.230  47.523  1.00 25.14           C  
ATOM    267  C   TYR    58       1.544  -0.336  46.094  1.00 25.37           C  
ATOM    268  O   TYR    58       1.884  -1.535  45.820  1.00 26.48           O  
ATOM    269  CB  TYR    58       0.500  -0.037  48.415  1.00 25.30           C  
ATOM    270  CG  TYR    58       0.848   0.366  49.838  1.00 24.22           C  
ATOM    271  CD1 TYR    58       1.712  -0.443  50.613  1.00 26.80           C  
ATOM    272  CD2 TYR    58       0.434   1.600  50.358  1.00 25.73           C  
ATOM    273  CE1 TYR    58       2.119  -0.052  51.862  1.00 24.96           C  
ATOM    274  CE2 TYR    58       0.829   1.997  51.651  1.00 27.42           C  
ATOM    275  CZ  TYR    58       1.666   1.198  52.361  1.00 26.68           C  
ATOM    276  OH  TYR    58       2.082   1.580  53.589  1.00 26.33           O  
ATOM    277  N   LEU    59       0.993   0.480  45.187  1.00 25.53           N  
ATOM    278  CA  LEU    59       0.833   0.052  43.768  1.00 26.65           C  
ATOM    279  C   LEU    59       2.180  -0.248  43.202  1.00 26.90           C  
ATOM    280  O   LEU    59       2.289  -1.219  42.440  1.00 27.73           O  
ATOM    281  CB  LEU    59       0.110   1.081  42.870  1.00 25.95           C  
ATOM    282  CG  LEU    59      -1.395   1.257  43.234  1.00 30.17           C  
ATOM    283  CD1 LEU    59      -1.913   2.436  42.477  1.00 30.73           C  
ATOM    284  CD2 LEU    59      -2.152  -0.020  42.880  1.00 32.85           C  
ATOM    285  N   LEU    60       3.190   0.583  43.522  1.00 26.74           N  
ATOM    286  CA  LEU    60       4.537   0.344  43.009  1.00 28.23           C  
ATOM    287  C   LEU    60       5.175  -0.951  43.581  1.00 26.91           C  
ATOM    288  O   LEU    60       5.850  -1.697  42.847  1.00 28.49           O  
ATOM    289  CB  LEU    60       5.481   1.514  43.288  1.00 27.52           C  
ATOM    290  CG  LEU    60       5.028   2.794  42.542  1.00 31.15           C  
ATOM    291  CD1 LEU    60       6.040   3.877  42.820  1.00 34.27           C  
ATOM    292  CD2 LEU    60       4.895   2.517  41.057  1.00 34.78           C  
ATOM    293  N   LEU    61       4.973  -1.228  44.867  1.00 25.66           N  
ATOM    294  CA  LEU    61       5.355  -2.555  45.438  1.00 25.96           C  
ATOM    295  C   LEU    61       4.708  -3.706  44.668  1.00 27.92           C  
ATOM    296  O   LEU    61       5.395  -4.736  44.312  1.00 26.78           O  
ATOM    297  CB  LEU    61       5.011  -2.631  46.981  1.00 24.03           C  
ATOM    298  CG  LEU    61       5.942  -1.738  47.856  1.00 27.40           C  
ATOM    299  CD1 LEU    61       5.388  -1.555  49.258  1.00 29.42           C  
ATOM    300  CD2 LEU    61       7.378  -2.403  47.930  1.00 29.76           C  
ATOM    301  N   CYS    62       3.395  -3.594  44.426  1.00 28.08           N  
ATOM    302  CA  CYS    62       2.709  -4.622  43.669  1.00 29.95           C  
ATOM    303  C   CYS    62       3.240  -4.775  42.244  1.00 29.03           C  
ATOM    304  O   CYS    62       3.299  -5.879  41.711  1.00 30.81           O  
ATOM    305  CB  CYS    62       1.200  -4.301  43.597  1.00 27.81           C  
ATOM    306  SG  CYS    62       0.452  -4.497  45.273  1.00 32.08           S  
ATOM    307  N   GLU    63       3.606  -3.660  41.614  1.00 28.85           N  
ATOM    308  CA  GLU    63       3.984  -3.672  40.209  1.00 28.77           C  
ATOM    309  C   GLU    63       5.464  -4.057  40.035  1.00 29.21           C  
ATOM    310  O   GLU    63       5.824  -4.806  39.069  1.00 30.46           O  
ATOM    311  CB  GLU    63       3.736  -2.269  39.615  1.00 29.21           C  
ATOM    312  CG  GLU    63       4.011  -2.222  38.117  1.00 37.67           C  
ATOM    313  CD  GLU    63       2.831  -2.733  37.311  1.00 42.55           C  
ATOM    314  OE1 GLU    63       1.874  -3.245  37.919  1.00 43.83           O  
ATOM    315  OE2 GLU    63       2.830  -2.605  36.080  1.00 47.33           O  
ATOM    316  N   HIS    64       6.324  -3.604  40.928  1.00 28.30           N  
ATOM    317  CA  HIS    64       7.798  -3.733  40.703  1.00 29.07           C  
ATOM    318  C   HIS    64       8.499  -4.765  41.608  1.00 29.26           C  
ATOM    319  O   HIS    64       9.634  -5.197  41.280  1.00 28.57           O  
ATOM    320  CB  HIS    64       8.479  -2.370  40.822  1.00 29.01           C  
ATOM    321  CG  HIS    64       7.974  -1.362  39.825  1.00 28.49           C  
ATOM    322  ND1 HIS    64       7.936  -0.007  40.081  1.00 28.38           N  
ATOM    323  CD2 HIS    64       7.526  -1.515  38.553  1.00 24.53           C  
ATOM    324  CE1 HIS    64       7.455   0.620  39.020  1.00 28.14           C  
ATOM    325  NE2 HIS    64       7.188  -0.268  38.084  1.00 28.59           N  
ATOM    326  N   HIS    65       7.854  -5.122  42.726  1.00 28.00           N  
ATOM    327  CA  HIS    65       8.482  -5.882  43.853  1.00 28.52           C  
ATOM    328  C   HIS    65       7.629  -7.053  44.246  1.00 29.11           C  
ATOM    329  O   HIS    65       7.776  -7.583  45.340  1.00 29.42           O  
ATOM    330  CB  HIS    65       8.708  -4.968  45.082  1.00 28.44           C  
ATOM    331  CG  HIS    65       9.696  -3.874  44.804  1.00 29.33           C  
ATOM    332  ND1 HIS    65      11.035  -4.127  44.603  1.00 30.49           N  
ATOM    333  CD2 HIS    65       9.524  -2.546  44.570  1.00 32.03           C  
ATOM    334  CE1 HIS    65      11.659  -2.990  44.321  1.00 31.66           C  
ATOM    335  NE2 HIS    65      10.761  -2.018  44.311  1.00 32.48           N  
ATOM    336  N   ALA    66       6.734  -7.501  43.352  1.00 28.97           N  
ATOM    337  CA  ALA    66       5.850  -8.614  43.755  1.00 27.60           C  
ATOM    338  C   ALA    66       6.614  -9.902  44.162  1.00 29.41           C  
ATOM    339  O   ALA    66       6.172 -10.655  45.061  1.00 28.82           O  
ATOM    340  CB  ALA    66       4.854  -8.887  42.644  1.00 29.50           C  
ATOM    341  N   HIS    67       7.765 -10.160  43.534  0.60 29.35           N  
ATOM    343  CA  HIS    67       8.490 -11.416  43.798  0.60 30.73           C  
ATOM    345  C   HIS    67       9.115 -11.457  45.178  0.60 30.25           C  
ATOM    347  O   HIS    67       9.508 -12.513  45.645  0.60 29.91           O  
ATOM    349  CB  HIS    67       9.601 -11.631  42.783  0.60 32.25           C  
ATOM    351  CG  HIS    67       9.125 -11.876  41.394  0.60 35.76           C  
ATOM    353  ND1 HIS    67       9.303 -10.959  40.383  0.60 39.69           N  
ATOM    355  CD2 HIS    67       8.568 -12.969  40.819  0.60 39.60           C  
ATOM    357  CE1 HIS    67       8.837 -11.458  39.250  0.60 41.13           C  
ATOM    359  NE2 HIS    67       8.387 -12.677  39.488  0.60 41.48           N  
ATOM    361  N   THR    68       9.227 -10.300  45.818  1.00 28.53           N  
ATOM    362  CA  THR    68       9.747 -10.240  47.181  1.00 28.06           C  
ATOM    363  C   THR    68       8.708  -9.731  48.208  1.00 28.01           C  
ATOM    364  O   THR    68       9.051  -9.481  49.362  1.00 29.14           O  
ATOM    365  CB  THR    68      11.022  -9.397  47.274  1.00 30.04           C  
ATOM    366  OG1 THR    68      10.771  -8.060  46.762  1.00 26.74           O  
ATOM    367  CG2 THR    68      12.220 -10.011  46.441  1.00 31.60           C  
ATOM    368  N   CYS    69       7.443  -9.633  47.826  1.00 27.30           N  
ATOM    369  CA  CYS    69       6.393  -9.288  48.810  1.00 26.87           C  
ATOM    370  C   CYS    69       5.367 -10.433  48.918  1.00 25.92           C  
ATOM    371  O   CYS    69       5.385 -11.363  48.094  1.00 26.43           O  
ATOM    372  CB  CYS    69       5.655  -8.042  48.334  1.00 27.03           C  
ATOM    373  SG  CYS    69       6.671  -6.537  48.199  1.00 29.52           S  
ATOM    374  N   VAL    70       4.429 -10.329  49.868  1.00 25.15           N  
ATOM    375  CA  VAL    70       3.463 -11.459  50.034  1.00 25.33           C  
ATOM    376  C   VAL    70       2.195 -10.879  50.632  1.00 25.27           C  
ATOM    377  O   VAL    70       2.272  -9.847  51.365  1.00 26.70           O  
ATOM    378  CB  VAL    70       4.081 -12.638  50.878  1.00 25.62           C  
ATOM    379  CG1 VAL    70       4.301 -12.275  52.327  1.00 26.59           C  
ATOM    380  CG2 VAL    70       3.183 -13.910  50.750  1.00 25.43           C  
ATOM    381  N   VAL    71       1.076 -11.429  50.234  1.00 25.73           N  
ATOM    382  CA  VAL    71      -0.190 -11.197  50.993  1.00 27.02           C  
ATOM    383  C   VAL    71      -0.700 -12.493  51.564  1.00 26.89           C  
ATOM    384  O   VAL    71      -0.501 -13.535  50.944  1.00 27.92           O  
ATOM    385  CB  VAL    71      -1.297 -10.555  50.119  1.00 27.88           C  
ATOM    386  CG1 VAL    71      -0.903  -9.120  49.756  1.00 26.55           C  
ATOM    387  CG2 VAL    71      -1.611 -11.366  48.866  1.00 27.07           C  
ATOM    388  N   ALA    72      -1.436 -12.405  52.674  1.00 27.30           N  
ATOM    389  CA  ALA    72      -2.130 -13.502  53.312  1.00 27.72           C  
ATOM    390  C   ALA    72      -3.597 -13.243  52.984  1.00 27.98           C  
ATOM    391  O   ALA    72      -4.143 -12.189  53.353  1.00 27.81           O  
ATOM    392  CB  ALA    72      -1.937 -13.486  54.849  1.00 27.15           C  
ATOM    393  N   GLU    73      -4.209 -14.196  52.308  1.00 26.27           N  
ATOM    394  CA  GLU    73      -5.556 -14.020  51.806  1.00 28.32           C  
ATOM    395  C   GLU    73      -6.515 -15.094  52.303  1.00 29.00           C  
ATOM    396  O   GLU    73      -6.209 -16.299  52.198  1.00 28.41           O  
ATOM    397  CB  GLU    73      -5.467 -14.007  50.255  1.00 28.70           C  
ATOM    398  CG  GLU    73      -6.788 -13.841  49.492  1.00 28.92           C  
ATOM    399  CD  GLU    73      -6.522 -13.641  47.984  1.00 32.45           C  
ATOM    400  OE1 GLU    73      -6.024 -14.571  47.289  1.00 27.94           O  
ATOM    401  OE2 GLU    73      -6.801 -12.538  47.503  1.00 34.45           O  
ATOM    402  N   SER    74      -7.731 -14.693  52.694  1.00 29.53           N  
ATOM    403  CA  SER    74      -8.765 -15.673  53.061  1.00 29.75           C  
ATOM    404  C   SER    74      -9.286 -16.458  51.828  1.00 30.06           C  
ATOM    405  O   SER    74      -9.107 -16.011  50.712  1.00 27.77           O  
ATOM    406  CB  SER    74      -9.936 -14.966  53.732  1.00 30.66           C  
ATOM    407  OG  SER    74     -10.589 -14.116  52.794  1.00 33.06           O  
ATOM    408  N   PRO    75      -9.921 -17.647  52.036  1.00 30.63           N  
ATOM    409  CA  PRO    75     -10.562 -18.396  50.904  1.00 30.69           C  
ATOM    410  C   PRO    75     -11.463 -17.474  50.086  1.00 30.82           C  
ATOM    411  O   PRO    75     -11.449 -17.542  48.834  1.00 29.53           O  
ATOM    412  CB  PRO    75     -11.374 -19.484  51.618  1.00 31.01           C  
ATOM    413  CG  PRO    75     -10.601 -19.760  52.810  1.00 30.29           C  
ATOM    414  CD  PRO    75     -10.043 -18.416  53.293  1.00 31.30           C  
ATOM    415  N   GLY    76     -12.172 -16.591  50.798  1.00 30.96           N  
ATOM    416  CA  GLY    76     -13.011 -15.519  50.207  1.00 30.50           C  
ATOM    417  C   GLY    76     -12.343 -14.319  49.514  1.00 31.46           C  
ATOM    418  O   GLY    76     -13.030 -13.535  48.852  1.00 30.66           O  
ATOM    419  N   GLY    77     -11.023 -14.190  49.598  1.00 29.19           N  
ATOM    420  CA  GLY    77     -10.339 -13.232  48.775  1.00 29.58           C  
ATOM    421  C   GLY    77     -10.040 -11.977  49.572  1.00 29.53           C  
ATOM    422  O   GLY    77      -9.684 -10.958  48.995  1.00 31.79           O  
ATOM    423  N   ARG    78     -10.136 -12.044  50.913  1.00 28.48           N  
ATOM    424  CA  ARG    78      -9.873 -10.848  51.727  1.00 29.09           C  
ATOM    425  C   ARG    78      -8.425 -10.891  52.217  1.00 27.79           C  
ATOM    426  O   ARG    78      -7.982 -11.872  52.839  1.00 28.43           O  
ATOM    427  CB  ARG    78     -10.794 -10.803  52.962  1.00 29.24           C  
ATOM    428  CG  ARG    78     -10.674  -9.488  53.783  1.00 29.76           C  
ATOM    429  CD  ARG    78     -11.513  -9.608  55.092  1.00 30.71           C  
ATOM    430  NE  ARG    78     -10.958 -10.669  55.938  1.00 31.17           N  
ATOM    431  CZ  ARG    78     -11.537 -11.832  56.204  1.00 32.87           C  
ATOM    432  NH1 ARG    78     -12.743 -12.132  55.723  1.00 34.43           N  
ATOM    433  NH2 ARG    78     -10.906 -12.702  56.957  1.00 36.64           N  
ATOM    434  N   ILE    79      -7.719  -9.822  51.981  1.00 27.39           N  
ATOM    435  CA  ILE    79      -6.320  -9.697  52.406  1.00 27.72           C  
ATOM    436  C   ILE    79      -6.230  -9.202  53.849  1.00 28.74           C  
ATOM    437  O   ILE    79      -6.599  -8.039  54.157  1.00 28.27           O  
ATOM    438  CB  ILE    79      -5.556  -8.770  51.429  1.00 28.98           C  
ATOM    439  CG1 ILE    79      -5.429  -9.520  50.075  1.00 30.29           C  
ATOM    440  CG2 ILE    79      -4.118  -8.429  51.986  1.00 27.53           C  
ATOM    441  CD1 ILE    79      -4.862  -8.613  48.923  1.00 30.41           C  
ATOM    442  N   ASP    80      -5.729 -10.056  54.735  1.00 27.45           N  
ATOM    443  CA  ASP    80      -5.560  -9.637  56.133  1.00 28.66           C  
ATOM    444  C   ASP    80      -4.080  -9.556  56.572  1.00 27.12           C  
ATOM    445  O   ASP    80      -3.786  -9.295  57.764  1.00 27.99           O  
ATOM    446  CB  ASP    80      -6.302 -10.598  57.051  1.00 28.86           C  
ATOM    447  CG  ASP    80      -7.819 -10.442  56.983  1.00 29.39           C  
ATOM    448  OD1 ASP    80      -8.371  -9.422  56.491  1.00 31.63           O  
ATOM    449  OD2 ASP    80      -8.446 -11.373  57.460  1.00 30.70           O  
ATOM    450  N   GLY    81      -3.150  -9.804  55.643  1.00 26.73           N  
ATOM    451  CA  GLY    81      -1.699  -9.790  56.013  1.00 26.35           C  
ATOM    452  C   GLY    81      -0.916  -9.287  54.805  1.00 27.06           C  
ATOM    453  O   GLY    81      -1.327  -9.574  53.665  1.00 27.66           O  
ATOM    454  N   PHE    82       0.183  -8.565  55.018  1.00 26.51           N  
ATOM    455  CA  PHE    82       1.040  -8.138  53.891  1.00 26.78           C  
ATOM    456  C   PHE    82       2.436  -7.997  54.438  1.00 26.45           C  
ATOM    457  O   PHE    82       2.606  -7.593  55.582  1.00 26.97           O  
ATOM    458  CB  PHE    82       0.543  -6.776  53.385  1.00 25.55           C  
ATOM    459  CG  PHE    82       1.472  -6.089  52.406  1.00 26.55           C  
ATOM    460  CD1 PHE    82       1.701  -6.630  51.137  1.00 26.94           C  
ATOM    461  CD2 PHE    82       2.056  -4.829  52.727  1.00 28.61           C  
ATOM    462  CE1 PHE    82       2.527  -6.009  50.209  1.00 29.39           C  
ATOM    463  CE2 PHE    82       2.893  -4.208  51.782  1.00 28.58           C  
ATOM    464  CZ  PHE    82       3.100  -4.773  50.523  1.00 30.95           C  
ATOM    465  N   VAL    83       3.420  -8.399  53.654  1.00 24.94           N  
ATOM    466  CA  VAL    83       4.809  -8.007  53.940  1.00 25.26           C  
ATOM    467  C   VAL    83       5.398  -7.337  52.693  1.00 26.55           C  
ATOM    468  O   VAL    83       5.277  -7.916  51.586  1.00 27.21           O  
ATOM    469  CB  VAL    83       5.703  -9.191  54.368  1.00 25.08           C  
ATOM    470  CG1 VAL    83       7.258  -8.668  54.534  1.00 23.40           C  
ATOM    471  CG2 VAL    83       5.138  -9.776  55.714  1.00 24.17           C  
ATOM    472  N   SER    84       6.012  -6.150  52.867  1.00 26.00           N  
ATOM    473  CA  SER    84       6.812  -5.520  51.787  1.00 25.97           C  
ATOM    474  C   SER    84       8.260  -5.738  52.063  1.00 26.57           C  
ATOM    475  O   SER    84       8.708  -5.526  53.197  1.00 25.75           O  
ATOM    476  CB  SER    84       6.584  -4.009  51.689  1.00 25.69           C  
ATOM    477  OG  SER    84       6.566  -3.433  52.995  1.00 29.89           O  
ATOM    478  N   ALA    85       8.981  -6.155  51.036  1.00 27.38           N  
ATOM    479  CA  ALA    85      10.420  -6.409  51.144  1.00 27.43           C  
ATOM    480  C   ALA    85      11.047  -6.303  49.764  1.00 27.99           C  
ATOM    481  O   ALA    85      10.339  -6.409  48.746  1.00 25.90           O  
ATOM    482  CB  ALA    85      10.675  -7.820  51.749  1.00 26.76           C  
ATOM    483  N   TYR    86      12.373  -6.084  49.720  1.00 26.25           N  
ATOM    484  CA  TYR    86      13.085  -6.054  48.473  1.00 27.19           C  
ATOM    485  C   TYR    86      14.542  -6.332  48.753  1.00 27.01           C  
ATOM    486  O   TYR    86      15.039  -6.099  49.872  1.00 25.54           O  
ATOM    487  CB  TYR    86      12.930  -4.690  47.804  1.00 27.19           C  
ATOM    488  CG  TYR    86      13.222  -3.493  48.675  1.00 27.65           C  
ATOM    489  CD1 TYR    86      14.527  -2.921  48.729  1.00 26.43           C  
ATOM    490  CD2 TYR    86      12.210  -2.877  49.401  1.00 27.98           C  
ATOM    491  CE1 TYR    86      14.770  -1.791  49.539  1.00 29.99           C  
ATOM    492  CE2 TYR    86      12.431  -1.733  50.185  1.00 30.16           C  
ATOM    493  CZ  TYR    86      13.720  -1.206  50.246  1.00 32.84           C  
ATOM    494  OH  TYR    86      13.937  -0.089  51.017  1.00 30.48           O  
ATOM    495  N   LEU    87      15.214  -6.879  47.759  1.00 26.78           N  
ATOM    496  CA  LEU    87      16.639  -7.019  47.832  1.00 28.40           C  
ATOM    497  C   LEU    87      17.296  -5.651  47.732  1.00 29.06           C  
ATOM    498  O   LEU    87      16.846  -4.805  46.947  1.00 29.51           O  
ATOM    499  CB  LEU    87      17.116  -7.862  46.641  1.00 30.26           C  
ATOM    500  CG  LEU    87      16.613  -9.329  46.576  1.00 29.46           C  
ATOM    501  CD1 LEU    87      17.072 -10.058  45.319  1.00 32.72           C  
ATOM    502  CD2 LEU    87      16.986 -10.139  47.841  1.00 31.05           C  
ATOM    503  N   LEU    88      18.399  -5.442  48.443  1.00 28.70           N  
ATOM    504  CA  LEU    88      19.029  -4.130  48.394  1.00 28.59           C  
ATOM    505  C   LEU    88      19.777  -4.026  47.070  1.00 30.73           C  
ATOM    506  O   LEU    88      20.589  -4.925  46.752  1.00 29.24           O  
ATOM    507  CB  LEU    88      19.982  -3.936  49.566  1.00 28.02           C  
ATOM    508  CG  LEU    88      19.293  -3.794  50.934  1.00 28.39           C  
ATOM    509  CD1 LEU    88      20.279  -3.314  52.018  1.00 28.39           C  
ATOM    510  CD2 LEU    88      18.090  -2.853  50.809  1.00 26.20           C  
ATOM    511  N   PRO    89      19.537  -2.943  46.296  1.00 30.42           N  
ATOM    512  CA  PRO    89      20.219  -2.804  45.014  1.00 32.20           C  
ATOM    513  C   PRO    89      21.762  -2.825  45.095  1.00 32.91           C  
ATOM    514  O   PRO    89      22.425  -3.382  44.199  1.00 33.87           O  
ATOM    515  CB  PRO    89      19.708  -1.448  44.501  1.00 32.80           C  
ATOM    516  CG  PRO    89      18.473  -1.242  45.189  1.00 31.04           C  
ATOM    517  CD  PRO    89      18.620  -1.817  46.540  1.00 31.51           C  
ATOM    518  N   THR    90      22.337  -2.280  46.161  1.00 32.94           N  
ATOM    519  CA  THR    90      23.789  -2.281  46.248  1.00 34.09           C  
ATOM    520  C   THR    90      24.321  -3.484  47.014  1.00 34.35           C  
ATOM    521  O   THR    90      25.531  -3.772  46.941  1.00 33.12           O  
ATOM    522  CB  THR    90      24.364  -1.030  46.892  1.00 34.66           C  
ATOM    523  OG1 THR    90      23.788  -0.864  48.187  1.00 36.62           O  
ATOM    524  CG2 THR    90      24.133   0.240  46.006  1.00 37.20           C  
ATOM    525  N   ARG    91      23.439  -4.200  47.712  1.00 34.03           N  
ATOM    526  CA  ARG    91      23.827  -5.406  48.446  1.00 34.30           C  
ATOM    527  C   ARG    91      22.786  -6.492  48.219  1.00 33.97           C  
ATOM    528  O   ARG    91      21.987  -6.779  49.116  1.00 33.10           O  
ATOM    529  CB  ARG    91      23.918  -5.099  49.926  1.00 35.32           C  
ATOM    530  CG  ARG    91      25.038  -4.153  50.228  1.00 39.65           C  
ATOM    531  CD  ARG    91      25.081  -3.830  51.694  1.00 45.30           C  
ATOM    532  NE  ARG    91      24.050  -2.895  52.145  1.00 49.53           N  
ATOM    533  CZ  ARG    91      23.387  -3.038  53.299  1.00 51.32           C  
ATOM    534  NH1 ARG    91      23.644  -4.086  54.070  1.00 49.57           N  
ATOM    535  NH2 ARG    91      22.462  -2.149  53.688  1.00 50.88           N  
ATOM    536  N   PRO    92      22.792  -7.093  47.026  1.00 33.68           N  
ATOM    537  CA  PRO    92      21.701  -7.972  46.605  1.00 34.12           C  
ATOM    538  C   PRO    92      21.529  -9.270  47.384  1.00 33.82           C  
ATOM    539  O   PRO    92      20.458  -9.870  47.262  1.00 34.58           O  
ATOM    540  CB  PRO    92      21.993  -8.218  45.119  1.00 34.48           C  
ATOM    541  CG  PRO    92      23.428  -7.960  44.972  1.00 33.03           C  
ATOM    542  CD  PRO    92      23.810  -6.941  45.975  1.00 33.84           C  
ATOM    543  N   ASP    93      22.505  -9.659  48.225  1.00 32.31           N  
ATOM    544  CA  ASP    93      22.354 -10.778  49.163  1.00 31.47           C  
ATOM    545  C   ASP    93      21.700 -10.408  50.513  1.00 30.90           C  
ATOM    546  O   ASP    93      21.653 -11.211  51.457  1.00 28.55           O  
ATOM    547  CB  ASP    93      23.721 -11.478  49.413  1.00 33.27           C  
ATOM    548  CG  ASP    93      24.676 -10.625  50.245  1.00 36.78           C  
ATOM    549  OD1 ASP    93      24.443  -9.409  50.429  1.00 40.28           O  
ATOM    550  OD2 ASP    93      25.710 -11.163  50.697  1.00 43.64           O  
ATOM    551  N   VAL    94      21.249  -9.162  50.603  1.00 28.87           N  
ATOM    552  CA  VAL    94      20.457  -8.699  51.733  1.00 28.13           C  
ATOM    553  C   VAL    94      18.981  -8.470  51.323  1.00 28.96           C  
ATOM    554  O   VAL    94      18.695  -7.666  50.418  1.00 28.15           O  
ATOM    555  CB  VAL    94      21.014  -7.370  52.297  1.00 27.32           C  
ATOM    556  CG1 VAL    94      20.109  -6.882  53.458  1.00 27.98           C  
ATOM    557  CG2 VAL    94      22.492  -7.527  52.792  1.00 29.25           C  
ATOM    558  N   LEU    95      18.049  -9.079  52.061  1.00 26.89           N  
ATOM    559  CA  LEU    95      16.633  -8.800  51.864  1.00 26.64           C  
ATOM    560  C   LEU    95      16.230  -7.805  52.970  1.00 27.06           C  
ATOM    561  O   LEU    95      16.477  -8.060  54.160  1.00 28.69           O  
ATOM    562  CB  LEU    95      15.839 -10.098  52.041  1.00 26.26           C  
ATOM    563  CG  LEU    95      14.311  -9.916  51.928  1.00 25.34           C  
ATOM    564  CD1 LEU    95      13.952  -9.685  50.455  1.00 26.94           C  
ATOM    565  CD2 LEU    95      13.604 -11.178  52.432  1.00 32.15           C  
ATOM    566  N   PHE    96      15.679  -6.662  52.566  1.00 27.52           N  
ATOM    567  CA  PHE    96      15.202  -5.675  53.517  1.00 27.55           C  
ATOM    568  C   PHE    96      13.662  -5.765  53.640  1.00 27.78           C  
ATOM    569  O   PHE    96      13.003  -5.745  52.644  1.00 26.91           O  
ATOM    570  CB  PHE    96      15.624  -4.282  53.085  1.00 26.56           C  
ATOM    571  CG  PHE    96      15.205  -3.242  54.081  1.00 30.36           C  
ATOM    572  CD1 PHE    96      15.994  -2.996  55.197  1.00 29.09           C  
ATOM    573  CD2 PHE    96      14.000  -2.540  53.906  1.00 30.48           C  
ATOM    574  CE1 PHE    96      15.624  -2.047  56.130  1.00 31.88           C  
ATOM    575  CE2 PHE    96      13.606  -1.623  54.848  1.00 29.42           C  
ATOM    576  CZ  PHE    96      14.449  -1.386  55.971  1.00 30.26           C  
ATOM    577  N   VAL    97      13.159  -5.909  54.858  1.00 27.66           N  
ATOM    578  CA  VAL    97      11.740  -5.976  55.159  1.00 27.14           C  
ATOM    579  C   VAL    97      11.297  -4.597  55.617  1.00 27.86           C  
ATOM    580  O   VAL    97      11.792  -4.058  56.629  1.00 28.05           O  
ATOM    581  CB  VAL    97      11.463  -7.017  56.234  1.00 28.05           C  
ATOM    582  CG1 VAL    97       9.912  -6.967  56.658  1.00 29.13           C  
ATOM    583  CG2 VAL    97      11.846  -8.350  55.699  1.00 25.98           C  
ATOM    584  N   TRP    98      10.354  -4.026  54.869  1.00 28.94           N  
ATOM    585  CA  TRP    98       9.929  -2.623  55.103  1.00 28.42           C  
ATOM    586  C   TRP    98       8.756  -2.633  56.049  1.00 29.26           C  
ATOM    587  O   TRP    98       8.878  -2.057  57.123  1.00 30.60           O  
ATOM    588  CB  TRP    98       9.587  -1.950  53.765  1.00 27.55           C  
ATOM    589  CG  TRP    98       9.016  -0.590  53.807  1.00 29.09           C  
ATOM    590  CD1 TRP    98       8.785   0.229  54.912  1.00 29.88           C  
ATOM    591  CD2 TRP    98       8.665   0.161  52.671  1.00 30.40           C  
ATOM    592  NE1 TRP    98       8.276   1.440  54.481  1.00 31.04           N  
ATOM    593  CE2 TRP    98       8.181   1.403  53.109  1.00 29.25           C  
ATOM    594  CE3 TRP    98       8.633  -0.145  51.311  1.00 29.88           C  
ATOM    595  CZ2 TRP    98       7.711   2.365  52.224  1.00 31.90           C  
ATOM    596  CZ3 TRP    98       8.212   0.814  50.395  1.00 34.17           C  
ATOM    597  CH2 TRP    98       7.725   2.058  50.859  1.00 30.83           C  
ATOM    598  N   GLN    99       7.614  -3.248  55.678  1.00 25.62           N  
ATOM    599  CA  GLN    99       6.445  -3.289  56.588  1.00 26.52           C  
ATOM    600  C   GLN    99       5.901  -4.710  56.728  1.00 28.09           C  
ATOM    601  O   GLN    99       5.874  -5.466  55.739  1.00 27.74           O  
ATOM    602  CB  GLN    99       5.323  -2.376  56.038  1.00 27.16           C  
ATOM    603  CG  GLN    99       5.757  -0.913  56.070  1.00 29.38           C  
ATOM    604  CD  GLN    99       4.585  -0.002  55.814  1.00 31.01           C  
ATOM    605  OE1 GLN    99       3.976  -0.061  54.750  1.00 29.00           O  
ATOM    606  NE2 GLN    99       4.288   0.883  56.780  1.00 29.69           N  
ATOM    607  N   VAL   100       5.489  -5.065  57.952  1.00 27.68           N  
ATOM    608  CA  VAL   100       4.776  -6.322  58.221  1.00 28.76           C  
ATOM    609  C   VAL   100       3.442  -5.927  58.797  1.00 28.50           C  
ATOM    610  O   VAL   100       3.362  -5.389  59.917  1.00 27.91           O  
ATOM    611  CB  VAL   100       5.543  -7.191  59.220  1.00 28.90           C  
ATOM    612  CG1 VAL   100       4.801  -8.560  59.495  1.00 29.29           C  
ATOM    613  CG2 VAL   100       6.949  -7.415  58.687  1.00 29.67           C  
ATOM    614  N   ALA   101       2.389  -6.094  58.015  1.00 28.23           N  
ATOM    615  CA  ALA   101       1.018  -5.732  58.462  1.00 28.21           C  
ATOM    616  C   ALA   101       0.213  -7.007  58.723  1.00 29.52           C  
ATOM    617  O   ALA   101       0.076  -7.861  57.847  1.00 28.87           O  
ATOM    618  CB  ALA   101       0.330  -4.906  57.384  1.00 30.21           C  
ATOM    619  N   VAL   102      -0.331  -7.127  59.925  1.00 27.61           N  
ATOM    620  CA  VAL   102      -1.207  -8.267  60.262  1.00 28.64           C  
ATOM    621  C   VAL   102      -2.467  -7.696  60.876  1.00 28.88           C  
ATOM    622  O   VAL   102      -2.410  -7.021  61.930  1.00 28.99           O  
ATOM    623  CB  VAL   102      -0.509  -9.219  61.211  1.00 30.54           C  
ATOM    624  CG1 VAL   102      -1.434 -10.307  61.667  1.00 29.44           C  
ATOM    625  CG2 VAL   102       0.720  -9.834  60.558  1.00 28.25           C  
ATOM    626  N   HIS   103      -3.588  -7.835  60.202  1.00 27.37           N  
ATOM    627  CA  HIS   103      -4.831  -7.244  60.725  1.00 26.76           C  
ATOM    628  C   HIS   103      -5.227  -7.777  62.118  1.00 29.75           C  
ATOM    629  O   HIS   103      -4.967  -8.922  62.406  1.00 26.61           O  
ATOM    630  CB  HIS   103      -5.977  -7.524  59.754  1.00 28.19           C  
ATOM    631  CG  HIS   103      -7.130  -6.578  59.921  1.00 28.76           C  
ATOM    632  ND1 HIS   103      -8.104  -6.757  60.883  1.00 29.49           N  
ATOM    633  CD2 HIS   103      -7.419  -5.406  59.298  1.00 30.28           C  
ATOM    634  CE1 HIS   103      -8.984  -5.771  60.801  1.00 31.84           C  
ATOM    635  NE2 HIS   103      -8.599  -4.942  59.840  1.00 32.54           N  
ATOM    636  N   SER   104      -5.849  -6.953  62.977  1.00 31.60           N  
ATOM    637  CA  SER   104      -6.337  -7.442  64.270  1.00 34.74           C  
ATOM    638  C   SER   104      -7.262  -8.656  64.158  1.00 35.83           C  
ATOM    639  O   SER   104      -7.247  -9.472  65.043  1.00 36.87           O  
ATOM    640  CB  SER   104      -7.006  -6.316  65.117  1.00 35.80           C  
ATOM    641  OG  SER   104      -7.916  -5.455  64.372  1.00 39.13           O  
ATOM    642  N   ARG   105      -8.035  -8.808  63.065  1.00 37.04           N  
ATOM    643  CA  ARG   105      -8.992  -9.939  62.956  1.00 37.31           C  
ATOM    644  C   ARG   105      -8.196 -11.217  62.655  1.00 37.29           C  
ATOM    645  O   ARG   105      -8.738 -12.293  62.691  1.00 38.32           O  
ATOM    646  CB  ARG   105     -10.059  -9.717  61.859  1.00 37.38           C  
ATOM    647  CG  ARG   105      -9.546  -9.922  60.417  1.00 37.50           C  
ATOM    648  CD  ARG   105     -10.593  -9.682  59.304  1.00 35.81           C  
ATOM    649  NE  ARG   105     -11.210  -8.341  59.366  1.00 34.57           N  
ATOM    650  CZ  ARG   105     -10.934  -7.297  58.581  1.00 34.77           C  
ATOM    651  NH1 ARG   105     -11.615  -6.151  58.758  1.00 35.83           N  
ATOM    652  NH2 ARG   105      -9.995  -7.344  57.621  1.00 33.39           N  
ATOM    653  N   ALA   106      -6.906 -11.082  62.357  1.00 36.73           N  
ATOM    654  CA  ALA   106      -6.086 -12.231  61.957  1.00 37.30           C  
ATOM    655  C   ALA   106      -5.017 -12.644  62.990  1.00 38.82           C  
ATOM    656  O   ALA   106      -4.114 -13.416  62.680  1.00 38.52           O  
ATOM    657  CB  ALA   106      -5.448 -11.964  60.585  1.00 37.06           C  
ATOM    658  N   ARG   107      -5.113 -12.088  64.193  1.00 40.42           N  
ATOM    659  CA  ARG   107      -4.285 -12.497  65.359  1.00 43.16           C  
ATOM    660  C   ARG   107      -4.401 -13.970  65.700  1.00 42.97           C  
ATOM    661  O   ARG   107      -5.462 -14.594  65.532  1.00 43.89           O  
ATOM    662  CB  ARG   107      -4.697 -11.717  66.605  1.00 43.97           C  
ATOM    663  CG  ARG   107      -4.300 -10.277  66.532  1.00 48.79           C  
ATOM    664  CD  ARG   107      -2.970 -10.143  65.803  1.00 55.48           C  
ATOM    665  NE  ARG   107      -2.759  -8.786  65.308  1.00 59.99           N  
ATOM    666  CZ  ARG   107      -1.573  -8.275  65.013  1.00 62.07           C  
ATOM    667  NH1 ARG   107      -0.462  -9.010  65.150  1.00 62.83           N  
ATOM    668  NH2 ARG   107      -1.500  -7.023  64.583  1.00 65.01           N  
ATOM    669  N   GLY   108      -3.309 -14.542  66.178  1.00 43.59           N  
ATOM    670  CA  GLY   108      -3.320 -15.943  66.575  1.00 43.64           C  
ATOM    671  C   GLY   108      -3.065 -16.904  65.432  1.00 44.48           C  
ATOM    672  O   GLY   108      -3.261 -18.093  65.594  1.00 43.64           O  
ATOM    673  N   HIS   109      -2.608 -16.401  64.287  1.00 43.96           N  
ATOM    674  CA  HIS   109      -2.318 -17.277  63.159  1.00 44.81           C  
ATOM    675  C   HIS   109      -0.822 -17.262  62.841  1.00 44.35           C  
ATOM    676  O   HIS   109      -0.394 -17.882  61.834  1.00 44.94           O  
ATOM    677  CB  HIS   109      -3.116 -16.847  61.894  1.00 45.94           C  
ATOM    678  CG  HIS   109      -4.601 -17.074  61.993  1.00 50.00           C  
ATOM    679  ND1 HIS   109      -5.217 -18.210  61.501  1.00 53.82           N  
ATOM    680  CD2 HIS   109      -5.593 -16.306  62.513  1.00 52.01           C  
ATOM    681  CE1 HIS   109      -6.521 -18.140  61.732  1.00 54.79           C  
ATOM    682  NE2 HIS   109      -6.776 -16.990  62.337  1.00 53.31           N  
ATOM    683  N   ARG   110      -0.046 -16.504  63.638  1.00 42.56           N  
ATOM    684  CA  ARG   110       1.387 -16.316  63.418  1.00 41.19           C  
ATOM    685  C   ARG   110       1.656 -15.936  61.948  1.00 38.86           C  
ATOM    686  O   ARG   110       2.615 -16.457  61.312  1.00 36.36           O  
ATOM    687  CB  ARG   110       2.109 -17.608  63.749  1.00 42.35           C  
ATOM    688  CG  ARG   110       3.175 -17.478  64.793  1.00 49.54           C  
ATOM    689  CD  ARG   110       2.709 -17.960  66.144  1.00 56.27           C  
ATOM    690  NE  ARG   110       3.830 -18.483  66.941  1.00 63.66           N  
ATOM    691  CZ  ARG   110       3.741 -18.939  68.202  1.00 66.48           C  
ATOM    692  NH1 ARG   110       2.579 -18.942  68.859  1.00 67.31           N  
ATOM    693  NH2 ARG   110       4.829 -19.393  68.825  1.00 66.34           N  
ATOM    694  N   LEU   111       0.803 -15.063  61.399  1.00 36.64           N  
ATOM    695  CA  LEU   111       0.934 -14.711  60.004  1.00 36.13           C  
ATOM    696  C   LEU   111       2.263 -14.069  59.730  1.00 35.20           C  
ATOM    697  O   LEU   111       2.786 -14.268  58.647  1.00 35.02           O  
ATOM    698  CB  LEU   111      -0.134 -13.715  59.503  1.00 37.49           C  
ATOM    699  CG  LEU   111      -1.445 -14.246  58.935  1.00 40.47           C  
ATOM    700  CD1 LEU   111      -2.185 -13.067  58.293  1.00 36.90           C  
ATOM    701  CD2 LEU   111      -1.187 -15.437  57.981  1.00 41.44           C  
ATOM    702  N   GLY   112       2.775 -13.237  60.656  1.00 33.27           N  
ATOM    703  CA  GLY   112       4.015 -12.473  60.342  1.00 32.76           C  
ATOM    704  C   GLY   112       5.179 -13.418  60.021  1.00 33.00           C  
ATOM    705  O   GLY   112       5.776 -13.354  58.948  1.00 30.20           O  
ATOM    706  N   ARG   113       5.428 -14.370  60.914  1.00 32.81           N  
ATOM    707  CA  ARG   113       6.415 -15.429  60.648  1.00 34.49           C  
ATOM    708  C   ARG   113       6.133 -16.288  59.440  1.00 32.25           C  
ATOM    709  O   ARG   113       7.054 -16.581  58.686  1.00 31.91           O  
ATOM    710  CB  ARG   113       6.688 -16.370  61.862  1.00 36.39           C  
ATOM    711  CG  ARG   113       5.730 -16.223  62.962  1.00 43.11           C  
ATOM    712  CD  ARG   113       6.218 -15.164  63.983  1.00 49.74           C  
ATOM    713  NE  ARG   113       7.038 -15.759  65.049  1.00 55.53           N  
ATOM    714  CZ  ARG   113       6.763 -15.684  66.340  1.00 54.24           C  
ATOM    715  NH1 ARG   113       7.601 -16.206  67.206  1.00 58.55           N  
ATOM    716  NH2 ARG   113       5.691 -15.044  66.758  1.00 57.00           N  
ATOM    717  N   ALA   114       4.877 -16.694  59.225  1.00 31.63           N  
ATOM    718  CA  ALA   114       4.552 -17.457  57.989  1.00 31.72           C  
ATOM    719  C   ALA   114       4.884 -16.676  56.693  1.00 31.78           C  
ATOM    720  O   ALA   114       5.430 -17.231  55.716  1.00 30.96           O  
ATOM    721  CB  ALA   114       3.104 -17.838  57.959  1.00 31.23           C  
ATOM    722  N   MET   115       4.512 -15.410  56.693  1.00 29.72           N  
ATOM    723  CA  MET   115       4.727 -14.548  55.539  1.00 31.83           C  
ATOM    724  C   MET   115       6.214 -14.314  55.284  1.00 30.40           C  
ATOM    725  O   MET   115       6.680 -14.435  54.137  1.00 30.20           O  
ATOM    726  CB  MET   115       3.932 -13.262  55.684  1.00 31.94           C  
ATOM    727  CG  MET   115       2.395 -13.472  55.437  1.00 30.62           C  
ATOM    728  SD  MET   115       1.599 -11.668  55.459  0.85 34.94          SE  
ATOM    729  CE  MET   115       1.955 -11.047  57.300  1.00 26.83           C  
ATOM    730  N   LEU   116       6.972 -14.034  56.337  1.00 30.11           N  
ATOM    731  CA  LEU   116       8.423 -13.855  56.183  1.00 30.42           C  
ATOM    732  C   LEU   116       9.132 -15.107  55.659  1.00 30.52           C  
ATOM    733  O   LEU   116       9.966 -15.028  54.732  1.00 30.68           O  
ATOM    734  CB  LEU   116       9.049 -13.363  57.495  1.00 29.45           C  
ATOM    735  CG  LEU   116       8.651 -11.953  57.913  1.00 32.33           C  
ATOM    736  CD1 LEU   116       9.015 -11.816  59.419  1.00 35.29           C  
ATOM    737  CD2 LEU   116       9.393 -10.887  57.089  1.00 34.27           C  
ATOM    738  N   GLY   117       8.811 -16.250  56.264  1.00 31.60           N  
ATOM    739  CA  GLY   117       9.225 -17.559  55.761  1.00 32.49           C  
ATOM    740  C   GLY   117       8.870 -17.829  54.321  1.00 33.44           C  
ATOM    741  O   GLY   117       9.713 -18.309  53.581  1.00 34.87           O  
ATOM    742  N   HIS   118       7.643 -17.520  53.908  1.00 32.19           N  
ATOM    743  CA  HIS   118       7.239 -17.655  52.513  1.00 31.65           C  
ATOM    744  C   HIS   118       8.130 -16.889  51.551  1.00 31.42           C  
ATOM    745  O   HIS   118       8.502 -17.405  50.498  1.00 32.19           O  
ATOM    746  CB  HIS   118       5.788 -17.174  52.319  1.00 32.80           C  
ATOM    747  CG  HIS   118       5.195 -17.549  50.997  1.00 32.35           C  
ATOM    748  ND1 HIS   118       5.266 -16.733  49.890  1.00 35.08           N  
ATOM    749  CD2 HIS   118       4.491 -18.640  50.612  1.00 31.11           C  
ATOM    750  CE1 HIS   118       4.647 -17.311  48.877  1.00 34.92           C  
ATOM    751  NE2 HIS   118       4.152 -18.462  49.292  1.00 36.60           N  
ATOM    752  N   ILE   119       8.438 -15.634  51.861  1.00 27.83           N  
ATOM    753  CA  ILE   119       9.319 -14.863  50.990  1.00 28.68           C  
ATOM    754  C   ILE   119      10.745 -15.432  50.966  1.00 29.77           C  
ATOM    755  O   ILE   119      11.387 -15.563  49.902  1.00 30.26           O  
ATOM    756  CB  ILE   119       9.361 -13.371  51.418  1.00 26.17           C  
ATOM    757  CG1 ILE   119       7.980 -12.759  51.268  1.00 27.11           C  
ATOM    758  CG2 ILE   119      10.388 -12.629  50.564  1.00 30.42           C  
ATOM    759  CD1 ILE   119       7.882 -11.398  51.963  1.00 24.95           C  
ATOM    760  N   LEU   120      11.245 -15.784  52.125  1.00 32.96           N  
ATOM    761  CA  LEU   120      12.586 -16.346  52.212  1.00 33.74           C  
ATOM    762  C   LEU   120      12.776 -17.641  51.474  1.00 35.19           C  
ATOM    763  O   LEU   120      13.885 -17.917  51.013  1.00 34.94           O  
ATOM    764  CB  LEU   120      13.022 -16.521  53.656  1.00 33.50           C  
ATOM    765  CG  LEU   120      13.470 -15.247  54.371  1.00 35.70           C  
ATOM    766  CD1 LEU   120      13.544 -15.502  55.849  1.00 38.36           C  
ATOM    767  CD2 LEU   120      14.790 -14.698  53.812  1.00 39.50           C  
ATOM    768  N   GLU   121      11.702 -18.426  51.372  0.50 35.23           N  
ATOM    770  CA  GLU   121      11.690 -19.720  50.677  0.50 35.62           C  
ATOM    772  C   GLU   121      11.723 -19.618  49.173  0.50 35.75           C  
ATOM    774  O   GLU   121      12.049 -20.587  48.503  0.50 34.88           O  
ATOM    776  CB  GLU   121      10.452 -20.526  51.071  0.50 36.69           C  
ATOM    778  CG  GLU   121      10.598 -21.296  52.369  0.50 39.07           C  
ATOM    780  CD  GLU   121      11.349 -22.608  52.206  0.50 42.94           C  
ATOM    782  OE1 GLU   121      12.548 -22.658  52.579  0.50 43.73           O  
ATOM    784  OE2 GLU   121      10.745 -23.587  51.700  0.50 45.46           O  
ATOM    786  N   ARG   122      11.381 -18.453  48.636  1.00 34.98           N  
ATOM    787  CA  ARG   122      11.326 -18.266  47.196  1.00 36.09           C  
ATOM    788  C   ARG   122      12.649 -18.336  46.465  1.00 36.25           C  
ATOM    789  O   ARG   122      13.711 -17.971  47.010  1.00 35.35           O  
ATOM    790  CB  ARG   122      10.743 -16.923  46.844  1.00 34.73           C  
ATOM    791  CG  ARG   122       9.356 -16.751  47.422  1.00 36.99           C  
ATOM    792  CD  ARG   122       8.745 -15.495  46.945  1.00 33.49           C  
ATOM    793  NE  ARG   122       7.382 -15.449  47.459  1.00 31.96           N  
ATOM    794  CZ  ARG   122       6.671 -14.329  47.496  1.00 31.99           C  
ATOM    795  NH1 ARG   122       7.199 -13.234  46.988  1.00 29.85           N  
ATOM    796  NH2 ARG   122       5.442 -14.317  47.987  1.00 32.40           N  
ATOM    797  N   GLN   123      12.554 -18.771  45.212  0.50 36.89           N  
ATOM    799  CA  GLN   123      13.699 -18.931  44.318  0.50 37.61           C  
ATOM    801  C   GLN   123      14.442 -17.601  44.099  0.50 37.74           C  
ATOM    803  O   GLN   123      15.666 -17.585  43.942  0.50 37.85           O  
ATOM    805  CB  GLN   123      13.247 -19.587  42.994  0.50 38.09           C  
ATOM    807  CG  GLN   123      11.711 -19.523  42.707  0.50 40.02           C  
ATOM    809  CD  GLN   123      10.839 -20.426  43.616  0.50 41.57           C  
ATOM    811  OE1 GLN   123       9.933 -19.950  44.313  0.50 39.31           O  
ATOM    813  NE2 GLN   123      11.107 -21.733  43.587  0.50 41.50           N  
ATOM    815  N   GLU   124      13.700 -16.488  44.149  1.00 37.77           N  
ATOM    816  CA  GLU   124      14.272 -15.133  44.085  1.00 37.11           C  
ATOM    817  C   GLU   124      15.204 -14.802  45.267  1.00 35.47           C  
ATOM    818  O   GLU   124      16.125 -13.991  45.123  1.00 36.09           O  
ATOM    819  CB  GLU   124      13.150 -14.074  43.971  1.00 39.80           C  
ATOM    820  CG  GLU   124      12.278 -14.197  42.672  1.00 45.55           C  
ATOM    821  CD  GLU   124      11.085 -15.181  42.758  1.00 49.57           C  
ATOM    822  OE1 GLU   124      11.156 -16.209  43.448  1.00 51.25           O  
ATOM    823  OE2 GLU   124      10.046 -14.917  42.113  1.00 56.74           O  
ATOM    824  N   CYS   125      14.997 -15.449  46.411  1.00 33.75           N  
ATOM    825  CA  CYS   125      15.797 -15.175  47.634  1.00 33.53           C  
ATOM    826  C   CYS   125      16.823 -16.283  47.909  1.00 34.23           C  
ATOM    827  O   CYS   125      17.407 -16.338  48.992  1.00 33.76           O  
ATOM    828  CB  CYS   125      14.878 -14.981  48.857  1.00 31.65           C  
ATOM    829  SG  CYS   125      13.774 -13.531  48.696  1.00 34.67           S  
ATOM    830  N   ARG   126      17.049 -17.157  46.937  0.50 34.15           N  
ATOM    832  CA  ARG   126      17.935 -18.304  47.165  0.50 34.77           C  
ATOM    834  C   ARG   126      19.400 -17.918  47.418  0.50 34.37           C  
ATOM    836  O   ARG   126      20.183 -18.740  47.907  0.50 34.03           O  
ATOM    838  CB  ARG   126      17.821 -19.319  46.026  0.50 35.04           C  
ATOM    840  CG  ARG   126      18.333 -18.817  44.678  0.50 37.29           C  
ATOM    842  CD  ARG   126      17.579 -19.487  43.545  0.50 41.20           C  
ATOM    844  NE  ARG   126      17.995 -19.010  42.229  0.50 42.67           N  
ATOM    846  CZ  ARG   126      17.783 -19.681  41.102  0.50 43.63           C  
ATOM    848  NH1 ARG   126      18.192 -19.174  39.943  0.50 43.05           N  
ATOM    850  NH2 ARG   126      17.164 -20.864  41.139  0.50 42.07           N  
ATOM    852  N   HIS   127      19.775 -16.688  47.079  1.00 33.69           N  
ATOM    853  CA  HIS   127      21.131 -16.196  47.403  1.00 34.51           C  
ATOM    854  C   HIS   127      21.196 -15.224  48.612  1.00 33.68           C  
ATOM    855  O   HIS   127      22.269 -14.732  48.947  1.00 33.77           O  
ATOM    856  CB  HIS   127      21.789 -15.557  46.177  1.00 34.70           C  
ATOM    857  CG  HIS   127      22.155 -16.530  45.106  1.00 39.58           C  
ATOM    858  ND1 HIS   127      21.919 -16.279  43.771  1.00 42.87           N  
ATOM    859  CD2 HIS   127      22.770 -17.740  45.161  1.00 41.75           C  
ATOM    860  CE1 HIS   127      22.375 -17.296  43.048  1.00 45.27           C  
ATOM    861  NE2 HIS   127      22.888 -18.197  43.868  1.00 42.60           N  
ATOM    862  N   VAL   128      20.064 -14.973  49.271  1.00 31.51           N  
ATOM    863  CA  VAL   128      20.045 -14.065  50.396  1.00 31.98           C  
ATOM    864  C   VAL   128      20.826 -14.690  51.529  1.00 33.28           C  
ATOM    865  O   VAL   128      20.625 -15.861  51.855  1.00 33.25           O  
ATOM    866  CB  VAL   128      18.609 -13.790  50.830  1.00 31.75           C  
ATOM    867  CG1 VAL   128      18.528 -13.042  52.204  1.00 29.75           C  
ATOM    868  CG2 VAL   128      17.921 -12.997  49.697  1.00 31.26           C  
ATOM    869  N   ARG   129      21.703 -13.883  52.120  1.00 33.61           N  
ATOM    870  CA  ARG   129      22.571 -14.297  53.224  1.00 34.50           C  
ATOM    871  C   ARG   129      22.190 -13.526  54.517  1.00 33.26           C  
ATOM    872  O   ARG   129      22.449 -14.013  55.628  1.00 31.75           O  
ATOM    873  CB  ARG   129      24.020 -14.099  52.754  1.00 34.29           C  
ATOM    874  CG  ARG   129      25.129 -13.916  53.775  1.00 38.31           C  
ATOM    875  CD  ARG   129      26.523 -13.891  53.047  1.00 39.42           C  
ATOM    876  NE  ARG   129      27.659 -14.088  53.967  1.00 47.11           N  
ATOM    877  CZ  ARG   129      28.008 -15.243  54.525  1.00 49.62           C  
ATOM    878  NH1 ARG   129      27.337 -16.369  54.268  1.00 50.69           N  
ATOM    879  NH2 ARG   129      29.054 -15.275  55.355  1.00 51.11           N  
ATOM    880  N   HIS   130      21.511 -12.368  54.374  1.00 30.80           N  
ATOM    881  CA  HIS   130      21.094 -11.577  55.517  1.00 31.25           C  
ATOM    882  C   HIS   130      19.719 -10.986  55.327  1.00 30.28           C  
ATOM    883  O   HIS   130      19.342 -10.647  54.211  1.00 28.51           O  
ATOM    884  CB  HIS   130      22.004 -10.376  55.683  1.00 32.90           C  
ATOM    885  CG  HIS   130      23.360 -10.734  56.175  1.00 37.29           C  
ATOM    886  ND1 HIS   130      24.436 -10.876  55.325  1.00 42.12           N  
ATOM    887  CD2 HIS   130      23.804 -11.039  57.417  1.00 39.12           C  
ATOM    888  CE1 HIS   130      25.495 -11.229  56.029  1.00 42.47           C  
ATOM    889  NE2 HIS   130      25.139 -11.327  57.299  1.00 42.86           N  
ATOM    890  N   LEU   131      19.027 -10.768  56.433  1.00 28.68           N  
ATOM    891  CA  LEU   131      17.730 -10.086  56.376  1.00 30.58           C  
ATOM    892  C   LEU   131      17.863  -8.857  57.285  1.00 30.29           C  
ATOM    893  O   LEU   131      18.392  -8.977  58.378  1.00 31.90           O  
ATOM    894  CB  LEU   131      16.603 -11.001  56.824  1.00 31.30           C  
ATOM    895  CG  LEU   131      15.193 -10.402  56.770  1.00 34.58           C  
ATOM    896  CD1 LEU   131      14.236 -11.562  56.595  1.00 38.29           C  
ATOM    897  CD2 LEU   131      14.859  -9.562  57.986  1.00 38.57           C  
ATOM    898  N   GLU   132      17.433  -7.691  56.814  1.00 29.02           N  
ATOM    899  CA  GLU   132      17.503  -6.440  57.574  1.00 30.40           C  
ATOM    900  C   GLU   132      16.100  -5.852  57.721  1.00 30.46           C  
ATOM    901  O   GLU   132      15.280  -5.997  56.828  1.00 28.94           O  
ATOM    902  CB  GLU   132      18.375  -5.429  56.802  1.00 29.23           C  
ATOM    903  CG  GLU   132      19.815  -5.591  57.140  1.00 33.74           C  
ATOM    904  CD  GLU   132      20.795  -4.628  56.468  1.00 34.50           C  
ATOM    905  OE1 GLU   132      20.442  -3.536  55.953  1.00 40.50           O  
ATOM    906  OE2 GLU   132      21.979  -4.995  56.487  1.00 38.28           O  
ATOM    907  N   THR   133      15.822  -5.176  58.823  1.00 29.70           N  
ATOM    908  CA  THR   133      14.547  -4.553  58.981  1.00 30.29           C  
ATOM    909  C   THR   133      14.759  -3.544  60.107  1.00 30.59           C  
ATOM    910  O   THR   133      15.825  -3.540  60.727  1.00 30.37           O  
ATOM    911  CB  THR   133      13.463  -5.580  59.356  1.00 31.81           C  
ATOM    912  OG1 THR   133      12.165  -4.978  59.174  1.00 33.20           O  
ATOM    913  CG2 THR   133      13.596  -6.020  60.852  1.00 30.50           C  
ATOM    914  N   THR   134      13.773  -2.722  60.405  1.00 29.32           N  
ATOM    915  CA  THR   134      13.925  -1.880  61.595  1.00 29.75           C  
ATOM    916  C   THR   134      12.775  -2.087  62.577  1.00 29.78           C  
ATOM    917  O   THR   134      11.649  -2.566  62.189  1.00 29.62           O  
ATOM    918  CB  THR   134      14.048  -0.386  61.285  1.00 29.80           C  
ATOM    919  OG1 THR   134      12.767   0.088  60.851  1.00 31.78           O  
ATOM    920  CG2 THR   134      15.133  -0.096  60.202  1.00 30.43           C  
ATOM    921  N   VAL   135      13.073  -1.808  63.835  1.00 30.68           N  
ATOM    922  CA  VAL   135      12.136  -2.013  64.924  1.00 31.53           C  
ATOM    923  C   VAL   135      12.207  -0.818  65.831  1.00 31.82           C  
ATOM    924  O   VAL   135      13.276  -0.305  66.041  1.00 33.90           O  
ATOM    925  CB  VAL   135      12.451  -3.297  65.752  1.00 32.28           C  
ATOM    926  CG1 VAL   135      12.003  -4.557  65.000  1.00 33.93           C  
ATOM    927  CG2 VAL   135      13.919  -3.376  66.200  1.00 33.14           C  
ATOM    928  N   GLY   136      11.088  -0.388  66.412  1.00 33.08           N  
ATOM    929  CA  GLY   136      11.112   0.672  67.420  1.00 34.31           C  
ATOM    930  C   GLY   136      11.590   0.146  68.774  1.00 37.82           C  
ATOM    931  O   GLY   136      11.728  -1.077  68.948  1.00 35.54           O  
ATOM    932  N   PRO   137      11.823   1.064  69.741  1.00 40.57           N  
ATOM    933  CA  PRO   137      12.259   0.716  71.087  1.00 43.55           C  
ATOM    934  C   PRO   137      11.419  -0.339  71.792  1.00 44.62           C  
ATOM    935  O   PRO   137      11.989  -1.224  72.359  1.00 47.20           O  
ATOM    936  CB  PRO   137      12.247   2.059  71.851  1.00 44.14           C  
ATOM    937  CG  PRO   137      11.493   3.033  70.961  1.00 44.40           C  
ATOM    938  CD  PRO   137      11.681   2.523  69.562  1.00 41.56           C  
ATOM    939  N   ASP   138      10.098  -0.287  71.737  1.00 45.76           N  
ATOM    940  CA  ASP   138       9.280  -1.184  72.560  1.00 47.26           C  
ATOM    941  C   ASP   138       8.750  -2.370  71.813  1.00 45.93           C  
ATOM    942  O   ASP   138       7.962  -3.132  72.367  1.00 47.05           O  
ATOM    943  CB  ASP   138       8.013  -0.473  73.063  1.00 49.09           C  
ATOM    944  CG  ASP   138       8.296   0.838  73.789  1.00 53.31           C  
ATOM    945  OD1 ASP   138       9.295   0.909  74.555  1.00 57.05           O  
ATOM    946  OD2 ASP   138       7.484   1.788  73.575  1.00 59.42           O  
ATOM    947  N   ASN   139       9.106  -2.512  70.547  1.00 44.09           N  
ATOM    948  CA  ASN   139       8.455  -3.495  69.723  1.00 42.64           C  
ATOM    949  C   ASN   139       9.029  -4.890  69.965  1.00 40.57           C  
ATOM    950  O   ASN   139       9.709  -5.465  69.104  1.00 38.07           O  
ATOM    951  CB  ASN   139       8.536  -3.075  68.249  1.00 44.42           C  
ATOM    952  CG  ASN   139       7.828  -1.734  67.997  1.00 50.18           C  
ATOM    953  OD1 ASN   139       6.601  -1.663  67.959  1.00 55.95           O  
ATOM    954  ND2 ASN   139       8.601  -0.669  67.886  1.00 52.75           N  
ATOM    955  N   GLN   140       8.770  -5.427  71.157  1.00 38.57           N  
ATOM    956  CA  GLN   140       9.317  -6.737  71.524  1.00 36.96           C  
ATOM    957  C   GLN   140       8.782  -7.919  70.740  1.00 36.24           C  
ATOM    958  O   GLN   140       9.547  -8.850  70.411  1.00 35.42           O  
ATOM    959  CB  GLN   140       9.170  -6.984  73.020  1.00 37.67           C  
ATOM    960  CG  GLN   140       9.872  -5.933  73.868  1.00 41.31           C  
ATOM    961  CD  GLN   140      11.348  -5.776  73.538  1.00 47.33           C  
ATOM    962  OE1 GLN   140      12.036  -6.742  73.198  1.00 48.80           O  
ATOM    963  NE2 GLN   140      11.843  -4.553  73.647  1.00 52.39           N  
ATOM    964  N   ALA   141       7.476  -7.922  70.466  1.00 34.86           N  
ATOM    965  CA  ALA   141       6.894  -9.001  69.703  1.00 34.59           C  
ATOM    966  C   ALA   141       7.500  -9.065  68.306  1.00 35.03           C  
ATOM    967  O   ALA   141       7.748 -10.157  67.773  1.00 35.37           O  
ATOM    968  CB  ALA   141       5.369  -8.880  69.626  1.00 34.68           C  
ATOM    969  N   SER   142       7.753  -7.896  67.722  0.50 35.08           N  
ATOM    971  CA  SER   142       8.337  -7.845  66.381  0.50 34.34           C  
ATOM    973  C   SER   142       9.761  -8.407  66.367  0.50 33.61           C  
ATOM    975  O   SER   142      10.140  -9.132  65.447  0.50 33.91           O  
ATOM    977  CB  SER   142       8.301  -6.414  65.855  0.50 35.14           C  
ATOM    979  OG  SER   142       6.986  -6.105  65.402  0.50 36.83           O  
ATOM    981  N   ARG   143      10.526  -8.107  67.413  1.00 31.92           N  
ATOM    982  CA  ARG   143      11.840  -8.706  67.630  1.00 31.65           C  
ATOM    983  C   ARG   143      11.748 -10.221  67.764  1.00 32.62           C  
ATOM    984  O   ARG   143      12.627 -10.946  67.266  1.00 32.96           O  
ATOM    985  CB  ARG   143      12.555  -8.124  68.855  1.00 31.41           C  
ATOM    986  CG  ARG   143      13.047  -6.696  68.682  1.00 32.38           C  
ATOM    987  CD  ARG   143      13.612  -6.157  70.038  1.00 32.63           C  
ATOM    988  NE  ARG   143      14.354  -4.913  69.907  1.00 33.59           N  
ATOM    989  CZ  ARG   143      13.778  -3.725  69.807  1.00 35.37           C  
ATOM    990  NH1 ARG   143      12.448  -3.613  69.825  1.00 37.45           N  
ATOM    991  NH2 ARG   143      14.531  -2.635  69.695  1.00 38.94           N  
ATOM    992  N   ARG   144      10.694 -10.723  68.420  1.00 31.43           N  
ATOM    993  CA  ARG   144      10.651 -12.163  68.629  1.00 32.29           C  
ATOM    994  C   ARG   144      10.417 -12.893  67.308  1.00 32.97           C  
ATOM    995  O   ARG   144      10.955 -14.015  67.109  1.00 33.70           O  
ATOM    996  CB  ARG   144       9.572 -12.557  69.639  1.00 31.24           C  
ATOM    997  CG  ARG   144      10.041 -12.372  71.087  1.00 31.57           C  
ATOM    998  CD  ARG   144       8.994 -12.898  72.057  1.00 28.92           C  
ATOM    999  NE  ARG   144       7.775 -12.083  72.146  1.00 28.45           N  
ATOM   1000  CZ  ARG   144       7.636 -11.051  73.015  1.00 30.97           C  
ATOM   1001  NH1 ARG   144       8.657 -10.638  73.761  1.00 26.80           N  
ATOM   1002  NH2 ARG   144       6.491 -10.370  73.084  1.00 31.80           N  
ATOM   1003  N   THR   145       9.584 -12.294  66.468  1.00 34.26           N  
ATOM   1004  CA  THR   145       9.315 -12.813  65.108  1.00 37.29           C  
ATOM   1005  C   THR   145      10.660 -12.968  64.373  1.00 37.57           C  
ATOM   1006  O   THR   145      10.990 -14.082  63.937  1.00 36.19           O  
ATOM   1007  CB  THR   145       8.327 -11.943  64.295  1.00 38.03           C  
ATOM   1008  OG1 THR   145       7.046 -11.895  64.937  1.00 38.10           O  
ATOM   1009  CG2 THR   145       8.122 -12.501  62.876  1.00 40.32           C  
ATOM   1010  N   PHE   146      11.463 -11.885  64.308  1.00 37.24           N  
ATOM   1011  CA  PHE   146      12.752 -11.978  63.623  1.00 37.68           C  
ATOM   1012  C   PHE   146      13.739 -12.936  64.331  1.00 39.16           C  
ATOM   1013  O   PHE   146      14.432 -13.733  63.664  1.00 39.77           O  
ATOM   1014  CB  PHE   146      13.302 -10.578  63.240  1.00 38.74           C  
ATOM   1015  CG  PHE   146      12.430  -9.849  62.233  1.00 39.23           C  
ATOM   1016  CD1 PHE   146      12.570 -10.073  60.850  1.00 39.66           C  
ATOM   1017  CD2 PHE   146      11.449  -8.940  62.656  1.00 42.53           C  
ATOM   1018  CE1 PHE   146      11.738  -9.415  59.926  1.00 38.69           C  
ATOM   1019  CE2 PHE   146      10.597  -8.257  61.718  1.00 43.57           C  
ATOM   1020  CZ  PHE   146      10.747  -8.510  60.370  1.00 40.97           C  
ATOM   1021  N   ALA   147      13.764 -12.949  65.679  1.00 38.85           N  
ATOM   1022  CA  ALA   147      14.573 -13.911  66.405  1.00 38.63           C  
ATOM   1023  C   ALA   147      14.224 -15.352  66.060  1.00 38.95           C  
ATOM   1024  O   ALA   147      15.118 -16.185  65.880  1.00 38.97           O  
ATOM   1025  CB  ALA   147      14.489 -13.680  67.919  1.00 38.76           C  
ATOM   1026  N   GLY   148      12.928 -15.655  65.967  1.00 39.30           N  
ATOM   1027  CA  GLY   148      12.488 -17.021  65.682  1.00 39.91           C  
ATOM   1028  C   GLY   148      12.932 -17.477  64.300  1.00 40.74           C  
ATOM   1029  O   GLY   148      13.386 -18.609  64.101  1.00 40.27           O  
ATOM   1030  N   LEU   149      12.802 -16.576  63.352  1.00 40.77           N  
ATOM   1031  CA  LEU   149      13.279 -16.775  62.000  1.00 42.52           C  
ATOM   1032  C   LEU   149      14.793 -17.093  61.926  1.00 42.40           C  
ATOM   1033  O   LEU   149      15.224 -18.004  61.197  1.00 42.72           O  
ATOM   1034  CB  LEU   149      12.971 -15.477  61.243  1.00 41.25           C  
ATOM   1035  CG  LEU   149      12.249 -15.544  59.913  1.00 45.60           C  
ATOM   1036  CD1 LEU   149      11.035 -16.491  59.949  1.00 46.26           C  
ATOM   1037  CD2 LEU   149      11.867 -14.133  59.476  1.00 44.81           C  
ATOM   1038  N   ALA   150      15.591 -16.342  62.677  1.00 42.19           N  
ATOM   1039  CA  ALA   150      17.027 -16.561  62.728  1.00 43.17           C  
ATOM   1040  C   ALA   150      17.367 -17.948  63.296  1.00 44.25           C  
ATOM   1041  O   ALA   150      18.196 -18.677  62.725  1.00 43.93           O  
ATOM   1042  CB  ALA   150      17.687 -15.476  63.536  1.00 43.07           C  
ATOM   1043  N   GLY   151      16.717 -18.312  64.406  1.00 44.73           N  
ATOM   1044  CA  GLY   151      16.996 -19.584  65.091  1.00 45.94           C  
ATOM   1045  C   GLY   151      16.781 -20.785  64.192  1.00 46.14           C  
ATOM   1046  O   GLY   151      17.593 -21.714  64.200  1.00 46.17           O  
ATOM   1047  N   GLU   152      15.701 -20.749  63.405  0.50 46.44           N  
ATOM   1049  CA  GLU   152      15.355 -21.825  62.469  0.50 46.93           C  
ATOM   1051  C   GLU   152      16.289 -21.885  61.233  0.50 47.32           C  
ATOM   1053  O   GLU   152      16.139 -22.769  60.383  0.50 47.10           O  
ATOM   1055  CB  GLU   152      13.879 -21.719  62.035  0.50 46.85           C  
ATOM   1057  CG  GLU   152      12.833 -21.820  63.174  0.50 47.47           C  
ATOM   1059  CD  GLU   152      12.321 -23.254  63.454  0.50 46.92           C  
ATOM   1061  OE1 GLU   152      11.216 -23.391  64.027  0.50 47.24           O  
ATOM   1063  OE2 GLU   152      13.006 -24.237  63.108  0.50 47.10           O  
ATOM   1065  N   ARG   153      17.248 -20.959  61.149  1.00 47.16           N  
ATOM   1066  CA  ARG   153      18.238 -20.930  60.064  1.00 47.60           C  
ATOM   1067  C   ARG   153      19.696 -20.929  60.567  1.00 47.56           C  
ATOM   1068  O   ARG   153      20.636 -20.710  59.783  1.00 48.14           O  
ATOM   1069  CB  ARG   153      17.994 -19.698  59.171  1.00 47.52           C  
ATOM   1070  CG  ARG   153      16.832 -19.877  58.197  1.00 47.85           C  
ATOM   1071  CD  ARG   153      16.214 -18.546  57.703  1.00 48.25           C  
ATOM   1072  NE  ARG   153      15.011 -18.827  56.914  1.00 48.66           N  
ATOM   1073  CZ  ARG   153      13.786 -19.002  57.423  1.00 50.44           C  
ATOM   1074  NH1 ARG   153      12.772 -19.304  56.615  1.00 48.73           N  
ATOM   1075  NH2 ARG   153      13.577 -18.905  58.745  1.00 50.45           N  
ATOM   1076  N   GLY   154      19.888 -21.146  61.865  1.00 46.80           N  
ATOM   1077  CA  GLY   154      21.227 -21.054  62.453  1.00 46.10           C  
ATOM   1078  C   GLY   154      21.881 -19.697  62.200  1.00 45.54           C  
ATOM   1079  O   GLY   154      23.097 -19.614  61.997  1.00 45.73           O  
ATOM   1080  N   ALA   155      21.076 -18.632  62.207  1.00 44.29           N  
ATOM   1081  CA  ALA   155      21.590 -17.269  62.026  1.00 43.19           C  
ATOM   1082  C   ALA   155      21.630 -16.459  63.328  1.00 42.59           C  
ATOM   1083  O   ALA   155      20.902 -16.748  64.267  1.00 43.85           O  
ATOM   1084  CB  ALA   155      20.762 -16.521  60.950  1.00 42.77           C  
ATOM   1085  N   HIS   156      22.501 -15.449  63.335  0.50 41.82           N  
ATOM   1087  CA  HIS   156      22.761 -14.490  64.420  0.50 40.83           C  
ATOM   1089  C   HIS   156      21.740 -13.329  64.284  0.50 40.45           C  
ATOM   1091  O   HIS   156      21.246 -13.088  63.189  0.50 38.80           O  
ATOM   1093  CB  HIS   156      24.227 -14.018  64.216  0.50 40.32           C  
ATOM   1095  CG  HIS   156      24.685 -12.891  65.096  0.50 40.80           C  
ATOM   1097  ND1 HIS   156      24.791 -12.995  66.470  0.50 41.92           N  
ATOM   1099  CD2 HIS   156      25.161 -11.661  64.780  0.50 40.16           C  
ATOM   1101  CE1 HIS   156      25.266 -11.864  66.964  0.50 40.20           C  
ATOM   1103  NE2 HIS   156      25.494 -11.037  65.959  0.50 41.31           N  
ATOM   1105  N   VAL   157      21.385 -12.669  65.389  1.00 40.08           N  
ATOM   1106  CA  VAL   157      20.584 -11.453  65.329  1.00 39.34           C  
ATOM   1107  C   VAL   157      21.385 -10.336  65.956  1.00 38.99           C  
ATOM   1108  O   VAL   157      21.916 -10.490  67.053  1.00 39.41           O  
ATOM   1109  CB  VAL   157      19.272 -11.588  66.093  1.00 40.01           C  
ATOM   1110  CG1 VAL   157      18.442 -10.368  65.866  1.00 38.44           C  
ATOM   1111  CG2 VAL   157      18.469 -12.773  65.588  1.00 41.70           C  
ATOM   1112  N   SER   158      21.497  -9.210  65.278  1.00 37.66           N  
ATOM   1113  CA  SER   158      22.118  -8.062  65.903  1.00 37.51           C  
ATOM   1114  C   SER   158      21.220  -6.839  65.790  1.00 37.11           C  
ATOM   1115  O   SER   158      20.403  -6.749  64.868  1.00 35.42           O  
ATOM   1116  CB  SER   158      23.514  -7.814  65.319  1.00 37.80           C  
ATOM   1117  OG  SER   158      23.502  -6.927  64.215  1.00 43.14           O  
ATOM   1118  N   GLU   159      21.370  -5.902  66.724  1.00 35.91           N  
ATOM   1119  CA  GLU   159      20.530  -4.736  66.732  1.00 36.42           C  
ATOM   1120  C   GLU   159      21.415  -3.544  66.988  1.00 34.94           C  
ATOM   1121  O   GLU   159      22.213  -3.582  67.909  1.00 33.52           O  
ATOM   1122  CB  GLU   159      19.492  -4.883  67.838  1.00 35.95           C  
ATOM   1123  CG  GLU   159      18.476  -3.762  67.893  1.00 39.12           C  
ATOM   1124  CD  GLU   159      17.394  -4.025  68.950  1.00 42.73           C  
ATOM   1125  OE1 GLU   159      16.918  -3.023  69.542  1.00 49.54           O  
ATOM   1126  OE2 GLU   159      17.048  -5.223  69.197  1.00 45.45           O  
ATOM   1127  N   GLN   160      21.300  -2.498  66.174  1.00 33.51           N  
ATOM   1128  CA  GLN   160      22.129  -1.308  66.323  1.00 32.97           C  
ATOM   1129  C   GLN   160      21.274  -0.043  66.169  1.00 33.12           C  
ATOM   1130  O   GLN   160      20.273  -0.044  65.433  1.00 32.75           O  
ATOM   1131  CB  GLN   160      23.248  -1.311  65.271  1.00 33.04           C  
ATOM   1132  CG  GLN   160      24.268  -2.415  65.435  1.00 35.30           C  
ATOM   1133  CD  GLN   160      25.120  -2.256  66.717  1.00 37.92           C  
ATOM   1134  OE1 GLN   160      25.161  -1.165  67.310  1.00 36.23           O  
ATOM   1135  NE2 GLN   160      25.796  -3.344  67.148  1.00 38.98           N  
ATOM   1136  N   PRO   161      21.606   1.025  66.901  1.00 32.36           N  
ATOM   1137  CA  PRO   161      20.919   2.277  66.610  1.00 32.50           C  
ATOM   1138  C   PRO   161      21.023   2.619  65.109  1.00 31.78           C  
ATOM   1139  O   PRO   161      22.044   2.315  64.475  1.00 31.34           O  
ATOM   1140  CB  PRO   161      21.724   3.316  67.388  1.00 32.06           C  
ATOM   1141  CG  PRO   161      22.849   2.550  68.007  1.00 36.00           C  
ATOM   1142  CD  PRO   161      22.550   1.145  68.017  1.00 33.45           C  
ATOM   1143  N   PHE   162      20.003   3.270  64.573  1.00 31.89           N  
ATOM   1144  CA  PHE   162      19.940   3.495  63.129  1.00 30.24           C  
ATOM   1145  C   PHE   162      19.232   4.813  62.816  1.00 30.82           C  
ATOM   1146  O   PHE   162      19.915   5.806  62.484  1.00 31.00           O  
ATOM   1147  CB  PHE   162      19.272   2.276  62.542  1.00 30.99           C  
ATOM   1148  CG  PHE   162      19.224   2.214  61.055  1.00 30.24           C  
ATOM   1149  CD1 PHE   162      20.389   2.274  60.263  1.00 28.98           C  
ATOM   1150  CD2 PHE   162      17.983   1.984  60.440  1.00 30.26           C  
ATOM   1151  CE1 PHE   162      20.299   2.149  58.846  1.00 32.52           C  
ATOM   1152  CE2 PHE   162      17.890   1.837  59.035  1.00 32.42           C  
ATOM   1153  CZ  PHE   162      19.025   1.958  58.233  1.00 29.09           C  
ATOM   1154  N   PHE   163      17.894   4.858  62.874  1.00 28.61           N  
ATOM   1155  CA  PHE   163      17.216   6.123  62.681  1.00 29.80           C  
ATOM   1156  C   PHE   163      16.861   6.665  64.027  1.00 31.94           C  
ATOM   1157  O   PHE   163      16.108   6.009  64.760  1.00 33.39           O  
ATOM   1158  CB  PHE   163      15.921   5.975  61.881  1.00 29.85           C  
ATOM   1159  CG  PHE   163      16.105   5.525  60.438  1.00 26.07           C  
ATOM   1160  CD1 PHE   163      17.286   5.772  59.749  1.00 28.93           C  
ATOM   1161  CD2 PHE   163      15.046   4.906  59.759  1.00 31.95           C  
ATOM   1162  CE1 PHE   163      17.419   5.374  58.366  1.00 31.02           C  
ATOM   1163  CE2 PHE   163      15.150   4.512  58.405  1.00 32.60           C  
ATOM   1164  CZ  PHE   163      16.346   4.772  57.696  1.00 28.90           C  
ATOM   1165  N   ASP   164      17.352   7.854  64.342  1.00 31.19           N  
ATOM   1166  CA  ASP   164      17.091   8.439  65.643  1.00 32.55           C  
ATOM   1167  C   ASP   164      16.350   9.756  65.423  1.00 32.90           C  
ATOM   1168  O   ASP   164      15.909  10.020  64.310  1.00 32.06           O  
ATOM   1169  CB  ASP   164      18.427   8.665  66.335  1.00 34.33           C  
ATOM   1170  CG  ASP   164      19.381   9.524  65.519  1.00 36.82           C  
ATOM   1171  OD1 ASP   164      19.152   9.795  64.293  1.00 39.67           O  
ATOM   1172  OD2 ASP   164      20.402   9.915  66.102  1.00 40.59           O  
ATOM   1173  N   ARG   165      16.294  10.606  66.446  0.50 32.78           N  
ATOM   1175  CA  ARG   165      15.758  11.965  66.319  0.50 34.06           C  
ATOM   1177  C   ARG   165      16.393  12.800  65.194  0.50 32.76           C  
ATOM   1179  O   ARG   165      15.704  13.566  64.520  0.50 32.30           O  
ATOM   1181  CB  ARG   165      15.901  12.736  67.641  0.50 34.03           C  
ATOM   1183  CG  ARG   165      15.044  12.164  68.769  0.50 36.68           C  
ATOM   1185  CD  ARG   165      15.423  12.757  70.129  0.50 37.46           C  
ATOM   1187  NE  ARG   165      14.971  11.910  71.232  0.50 45.30           N  
ATOM   1189  CZ  ARG   165      13.725  11.880  71.709  0.50 48.57           C  
ATOM   1191  NH1 ARG   165      12.779  12.653  71.185  0.50 49.96           N  
ATOM   1193  NH2 ARG   165      13.418  11.076  72.724  0.50 50.43           N  
ATOM   1195  N   GLN   166      17.705  12.665  65.013  0.50 32.09           N  
ATOM   1197  CA  GLN   166      18.420  13.390  63.970  0.50 32.57           C  
ATOM   1199  C   GLN   166      17.857  13.029  62.587  0.50 31.31           C  
ATOM   1201  O   GLN   166      17.595  13.900  61.753  0.50 30.00           O  
ATOM   1203  CB  GLN   166      19.937  13.085  64.055  0.50 32.57           C  
ATOM   1205  CG  GLN   166      20.852  14.026  63.233  0.50 35.47           C  
ATOM   1207  CD  GLN   166      22.346  13.744  63.411  0.50 34.84           C  
ATOM   1209  OE1 GLN   166      22.732  12.898  64.208  0.50 39.56           O  
ATOM   1211  NE2 GLN   166      23.196  14.478  62.674  0.50 38.77           N  
ATOM   1213  N   ALA   167      17.655  11.730  62.373  1.00 29.22           N  
ATOM   1214  CA  ALA   167      17.225  11.213  61.086  1.00 29.75           C  
ATOM   1215  C   ALA   167      15.766  11.616  60.777  1.00 30.76           C  
ATOM   1216  O   ALA   167      15.435  11.877  59.597  1.00 30.39           O  
ATOM   1217  CB  ALA   167      17.364   9.704  61.039  1.00 26.49           C  
ATOM   1218  N   PHE   168      14.932  11.722  61.825  1.00 31.57           N  
ATOM   1219  CA  PHE   168      13.517  12.164  61.650  1.00 31.96           C  
ATOM   1220  C   PHE   168      13.286  13.649  61.710  1.00 32.21           C  
ATOM   1221  O   PHE   168      12.132  14.096  61.604  1.00 32.92           O  
ATOM   1222  CB  PHE   168      12.567  11.443  62.628  1.00 32.43           C  
ATOM   1223  CG  PHE   168      12.409   9.972  62.360  1.00 30.95           C  
ATOM   1224  CD1 PHE   168      11.533   9.522  61.333  1.00 32.26           C  
ATOM   1225  CD2 PHE   168      13.056   9.016  63.156  1.00 32.42           C  
ATOM   1226  CE1 PHE   168      11.319   8.144  61.074  1.00 36.05           C  
ATOM   1227  CE2 PHE   168      12.908   7.664  62.895  1.00 32.07           C  
ATOM   1228  CZ  PHE   168      12.022   7.185  61.874  1.00 35.67           C  
ATOM   1229  N   GLY   169      14.352  14.404  61.892  1.00 32.25           N  
ATOM   1230  CA  GLY   169      14.264  15.872  61.966  1.00 33.51           C  
ATOM   1231  C   GLY   169      13.387  16.346  63.107  1.00 34.34           C  
ATOM   1232  O   GLY   169      12.765  17.414  63.027  1.00 35.41           O  
ATOM   1233  N   GLY   170      13.346  15.586  64.194  1.00 34.82           N  
ATOM   1234  CA  GLY   170      12.547  16.003  65.347  1.00 35.27           C  
ATOM   1235  C   GLY   170      11.069  15.686  65.189  1.00 36.51           C  
ATOM   1236  O   GLY   170      10.260  16.126  65.986  1.00 36.64           O  
ATOM   1237  N   ALA   171      10.690  14.878  64.198  1.00 36.02           N  
ATOM   1238  CA  ALA   171       9.277  14.629  63.983  1.00 36.89           C  
ATOM   1239  C   ALA   171       8.800  13.708  65.085  1.00 37.83           C  
ATOM   1240  O   ALA   171       9.600  13.065  65.742  1.00 37.14           O  
ATOM   1241  CB  ALA   171       9.049  13.995  62.607  1.00 36.67           C  
ATOM   1242  N   ASP   172       7.500  13.666  65.306  1.00 38.13           N  
ATOM   1243  CA  ASP   172       6.938  12.813  66.339  1.00 40.54           C  
ATOM   1244  C   ASP   172       6.880  11.360  65.838  1.00 40.03           C  
ATOM   1245  O   ASP   172       5.830  10.862  65.401  1.00 42.18           O  
ATOM   1246  CB  ASP   172       5.554  13.370  66.698  1.00 41.76           C  
ATOM   1247  CG  ASP   172       4.963  12.759  67.940  1.00 47.72           C  
ATOM   1248  OD1 ASP   172       5.517  11.772  68.502  1.00 53.08           O  
ATOM   1249  OD2 ASP   172       3.897  13.283  68.346  1.00 52.54           O  
ATOM   1250  N   HIS   173       8.025  10.685  65.886  1.00 39.06           N  
ATOM   1251  CA  HIS   173       8.141   9.284  65.445  1.00 37.69           C  
ATOM   1252  C   HIS   173       9.146   8.602  66.377  1.00 37.60           C  
ATOM   1253  O   HIS   173      10.154   9.177  66.733  1.00 35.55           O  
ATOM   1254  CB  HIS   173       8.600   9.248  63.971  1.00 37.68           C  
ATOM   1255  CG  HIS   173       8.488   7.899  63.311  1.00 37.73           C  
ATOM   1256  ND1 HIS   173       9.241   6.819  63.703  1.00 35.65           N  
ATOM   1257  CD2 HIS   173       7.738   7.465  62.259  1.00 41.18           C  
ATOM   1258  CE1 HIS   173       8.964   5.770  62.946  1.00 38.16           C  
ATOM   1259  NE2 HIS   173       8.058   6.138  62.051  1.00 38.08           N  
ATOM   1260  N   ASP   174       8.855   7.380  66.815  1.00 37.19           N  
ATOM   1261  CA  ASP   174       9.824   6.644  67.620  1.00 38.31           C  
ATOM   1262  C   ASP   174      11.102   6.420  66.793  1.00 37.14           C  
ATOM   1263  O   ASP   174      11.037   6.391  65.529  1.00 36.72           O  
ATOM   1264  CB  ASP   174       9.252   5.268  67.946  1.00 38.70           C  
ATOM   1265  CG  ASP   174       8.113   5.326  68.967  1.00 43.22           C  
ATOM   1266  OD1 ASP   174       7.968   6.363  69.667  1.00 49.01           O  
ATOM   1267  OD2 ASP   174       7.365   4.322  69.053  1.00 48.72           O  
ATOM   1268  N   ASP   175      12.224   6.231  67.498  1.00 35.40           N  
ATOM   1269  CA  ASP   175      13.470   5.768  66.899  1.00 35.45           C  
ATOM   1270  C   ASP   175      13.234   4.411  66.236  1.00 35.34           C  
ATOM   1271  O   ASP   175      12.388   3.662  66.702  1.00 35.17           O  
ATOM   1272  CB  ASP   175      14.488   5.573  68.019  1.00 36.20           C  
ATOM   1273  CG  ASP   175      15.088   6.880  68.517  1.00 39.50           C  
ATOM   1274  OD1 ASP   175      14.721   7.973  68.005  1.00 42.16           O  
ATOM   1275  OD2 ASP   175      15.945   6.817  69.437  1.00 44.59           O  
ATOM   1276  N   GLU   176      13.974   4.097  65.169  1.00 34.71           N  
ATOM   1277  CA  GLU   176      13.918   2.790  64.532  1.00 34.11           C  
ATOM   1278  C   GLU   176      15.312   2.186  64.542  1.00 34.73           C  
ATOM   1279  O   GLU   176      16.201   2.707  63.842  1.00 34.95           O  
ATOM   1280  CB  GLU   176      13.455   2.947  63.092  1.00 36.01           C  
ATOM   1281  CG  GLU   176      12.018   3.477  62.968  1.00 36.75           C  
ATOM   1282  CD  GLU   176      10.973   2.356  62.998  1.00 43.16           C  
ATOM   1283  OE1 GLU   176      11.257   1.132  62.730  1.00 39.93           O  
ATOM   1284  OE2 GLU   176       9.810   2.716  63.302  1.00 46.24           O  
ATOM   1285  N   MET   177      15.512   1.111  65.317  1.00 31.93           N  
ATOM   1286  CA  MET   177      16.797   0.443  65.330  1.00 31.94           C  
ATOM   1287  C   MET   177      16.938  -0.556  64.163  1.00 30.52           C  
ATOM   1288  O   MET   177      15.936  -1.086  63.707  1.00 30.12           O  
ATOM   1289  CB  MET   177      16.979  -0.263  66.671  1.00 31.47           C  
ATOM   1290  CG  MET   177      17.307   0.851  67.772  1.00 41.15           C  
ATOM   1291  SD  MET   177      15.602   1.584  68.381  0.45 55.77          SE  
ATOM   1292  CE  MET   177      14.945  -0.016  69.226  1.00 53.35           C  
ATOM   1293  N   LEU   178      18.175  -0.839  63.763  1.00 29.29           N  
ATOM   1294  CA  LEU   178      18.412  -1.735  62.649  1.00 31.28           C  
ATOM   1295  C   LEU   178      18.555  -3.141  63.183  1.00 31.35           C  
ATOM   1296  O   LEU   178      19.461  -3.432  63.988  1.00 31.95           O  
ATOM   1297  CB  LEU   178      19.677  -1.333  61.878  1.00 29.10           C  
ATOM   1298  CG  LEU   178      20.030  -2.319  60.745  1.00 31.33           C  
ATOM   1299  CD1 LEU   178      19.027  -2.317  59.590  1.00 30.10           C  
ATOM   1300  CD2 LEU   178      21.475  -2.062  60.250  1.00 32.35           C  
ATOM   1301  N   LEU   179      17.674  -4.029  62.740  1.00 31.88           N  
ATOM   1302  CA  LEU   179      17.747  -5.419  63.141  1.00 32.27           C  
ATOM   1303  C   LEU   179      18.293  -6.247  61.948  1.00 33.22           C  
ATOM   1304  O   LEU   179      17.807  -6.154  60.821  1.00 32.35           O  
ATOM   1305  CB  LEU   179      16.344  -5.872  63.607  1.00 32.02           C  
ATOM   1306  CG  LEU   179      16.040  -7.172  64.339  1.00 35.18           C  
ATOM   1307  CD1 LEU   179      16.660  -7.096  65.763  1.00 40.95           C  
ATOM   1308  CD2 LEU   179      14.507  -7.435  64.480  1.00 34.77           C  
ATOM   1309  N   ARG   180      19.346  -7.019  62.178  1.00 33.14           N  
ATOM   1310  CA  ARG   180      20.028  -7.723  61.105  1.00 34.71           C  
ATOM   1311  C   ARG   180      20.229  -9.188  61.439  1.00 35.46           C  
ATOM   1312  O   ARG   180      20.797  -9.507  62.470  1.00 36.70           O  
ATOM   1313  CB  ARG   180      21.379  -7.044  60.829  1.00 35.83           C  
ATOM   1314  CG  ARG   180      22.137  -7.590  59.651  1.00 38.09           C  
ATOM   1315  CD  ARG   180      23.177  -6.555  59.260  1.00 45.27           C  
ATOM   1316  NE  ARG   180      23.881  -6.901  58.027  1.00 51.12           N  
ATOM   1317  CZ  ARG   180      24.988  -7.635  58.000  1.00 52.09           C  
ATOM   1318  NH1 ARG   180      25.496  -8.098  59.141  1.00 57.01           N  
ATOM   1319  NH2 ARG   180      25.593  -7.909  56.849  1.00 52.09           N  
ATOM   1320  N   ILE   181      19.764 -10.084  60.581  1.00 36.10           N  
ATOM   1321  CA  ILE   181      19.804 -11.529  60.866  1.00 36.97           C  
ATOM   1322  C   ILE   181      20.643 -12.178  59.794  1.00 38.09           C  
ATOM   1323  O   ILE   181      20.537 -11.816  58.608  1.00 34.62           O  
ATOM   1324  CB  ILE   181      18.406 -12.111  60.751  1.00 38.27           C  
ATOM   1325  CG1 ILE   181      17.432 -11.440  61.708  1.00 41.03           C  
ATOM   1326  CG2 ILE   181      18.386 -13.584  61.005  1.00 40.84           C  
ATOM   1327  CD1 ILE   181      16.062 -11.386  61.071  1.00 48.15           C  
ATOM   1328  N   GLY   182      21.467 -13.164  60.178  1.00 38.91           N  
ATOM   1329  CA  GLY   182      22.320 -13.810  59.209  1.00 40.40           C  
ATOM   1330  C   GLY   182      23.694 -14.077  59.818  1.00 43.20           C  
ATOM   1331  O   GLY   182      23.909 -13.733  60.989  1.00 43.62           O  
ATOM   1332  N   PRO   183      24.631 -14.667  59.034  1.00 43.54           N  
ATOM   1333  CA  PRO   183      24.429 -15.179  57.666  1.00 43.78           C  
ATOM   1334  C   PRO   183      23.517 -16.414  57.641  1.00 43.68           C  
ATOM   1335  O   PRO   183      23.455 -17.141  58.618  1.00 44.02           O  
ATOM   1336  CB  PRO   183      25.856 -15.531  57.193  1.00 43.95           C  
ATOM   1337  CG  PRO   183      26.655 -15.715  58.435  1.00 45.02           C  
ATOM   1338  CD  PRO   183      26.041 -14.805  59.475  1.00 44.24           C  
ATOM   1339  N   PHE   184      22.762 -16.600  56.565  1.00 43.32           N  
ATOM   1340  CA  PHE   184      22.002 -17.819  56.398  1.00 43.90           C  
ATOM   1341  C   PHE   184      22.979 -18.745  55.698  1.00 45.14           C  
ATOM   1342  O   PHE   184      23.746 -18.269  54.855  1.00 45.26           O  
ATOM   1343  CB  PHE   184      20.768 -17.609  55.532  1.00 43.64           C  
ATOM   1344  CG  PHE   184      19.790 -16.620  56.093  1.00 44.04           C  
ATOM   1345  CD1 PHE   184      19.409 -16.675  57.437  1.00 43.12           C  
ATOM   1346  CD2 PHE   184      19.223 -15.648  55.284  1.00 43.20           C  
ATOM   1347  CE1 PHE   184      18.509 -15.769  57.956  1.00 41.15           C  
ATOM   1348  CE2 PHE   184      18.317 -14.734  55.802  1.00 42.25           C  
ATOM   1349  CZ  PHE   184      17.959 -14.791  57.134  1.00 41.41           C  
END
