
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  157 ( 1286),  selected  157 , name 1wwz_A
# Molecule2: number of CA atoms  159 ( 1259),  selected  159 , name T0417.pdb
# PARAMETERS: 1wwz_A.T0417.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    D     2_A      -       -           -
LGA    E     3_A      R      26          3.278
LGA    I     4_A      Y      27          1.482
LGA    K     5_A      H      28          0.473
LGA    I     6_A      L      29          0.654
LGA    E     7_A      R      30          0.954
LGA    K     8_A      P      31          1.348
LGA    L     9_A      P      32          1.453
LGA    K    10_A      R      33          2.730
LGA    K    11_A      R      34          2.361
LGA    L    12_A      -       -           -
LGA    D    13_A      N      35          2.135
LGA    K    14_A      -       -           -
LGA    K    15_A      -       -           -
LGA    A    16_A      D      36          2.110
LGA    L    17_A      G      37          1.891
LGA    N    18_A      A      38          2.031
LGA    E    19_A      A      39          1.273
LGA    L    20_A      I      40          0.858
LGA    I    21_A      H      41          1.715
LGA    D    22_A      Q      42          2.123
LGA    V    23_A      L      43          1.479
LGA    Y    24_A      V      44          1.064
LGA    M    25_A      S      45          1.845
LGA    S    26_A      E      46          2.003
LGA    G    27_A      C      47          2.162
LGA    Y    28_A      P      48          2.459
LGA    E    29_A      -       -           -
LGA    G    30_A      -       -           -
LGA    L    31_A      P      49          1.991
LGA    E    32_A      -       -           -
LGA    E    33_A      -       -           -
LGA    Y    34_A      -       -           -
LGA    G    35_A      L      50          2.324
LGA    G    36_A      D      51          2.889
LGA    E    37_A      -       -           -
LGA    G    38_A      -       -           -
LGA    R    39_A      -       -           -
LGA    D    40_A      -       -           -
LGA    Y    41_A      L      52          3.721
LGA    A    42_A      N      53          3.034
LGA    R    43_A      S      54          3.070
LGA    N    44_A      L      55          4.255
LGA    -       -      Y      56           -
LGA    Y    45_A      A      57          3.771
LGA    I    46_A      Y      58          2.049
LGA    K    47_A      L      59          3.295
LGA    W    48_A      L      60          4.383
LGA    C    49_A      L      61          3.161
LGA    W    50_A      C      62          3.373
LGA    K    51_A      E      63          4.886
LGA    K    52_A      H      64          4.762
LGA    A    53_A      H      65          1.711
LGA    S    54_A      A      66          2.208
LGA    D    55_A      H      67          1.917
LGA    G    56_A      T      68          1.639
LGA    F    57_A      C      69          2.023
LGA    F    58_A      V      70          0.958
LGA    V    59_A      V      71          0.689
LGA    A    60_A      A      72          0.509
LGA    K    61_A      E      73          0.854
LGA    V    62_A      S      74          1.181
LGA    G    63_A      P      75          2.042
LGA    D    64_A      G      76          2.762
LGA    -       -      G      77           -
LGA    K    65_A      R      78          0.490
LGA    I    66_A      I      79          0.671
LGA    V    67_A      D      80          0.801
LGA    G    68_A      G      81          0.377
LGA    F    69_A      F      82          1.077
LGA    I    70_A      V      83          1.086
LGA    V    71_A      S      84          1.944
LGA    C    72_A      A      85          2.874
LGA    D    73_A      Y      86          1.419
LGA    K    74_A      L      87          3.118
LGA    D    75_A      -       -           -
LGA    W    76_A      L      88          0.888
LGA    F    77_A      P      89          3.625
LGA    S    78_A      T      90          5.832
LGA    K    79_A      -       -           -
LGA    Y    80_A      -       -           -
LGA    E    81_A      -       -           -
LGA    G    82_A      -       -           -
LGA    R    83_A      R      91          2.712
LGA    I    84_A      P      92          2.470
LGA    V    85_A      D      93          3.221
LGA    -       -      V      94           -
LGA    G    86_A      L      95          1.458
LGA    A    87_A      F      96          1.505
LGA    I    88_A      V      97          1.332
LGA    H    89_A      W      98          1.967
LGA    E    90_A      Q      99          1.801
LGA    F    91_A      V     100          1.289
LGA    V    92_A      A     101          0.898
LGA    V    93_A      V     102          0.893
LGA    D    94_A      H     103          0.742
LGA    K    95_A      S     104          1.338
LGA    K    96_A      R     105          1.463
LGA    F    97_A      A     106          0.705
LGA    Q    98_A      R     107          1.906
LGA    G    99_A      G     108          2.546
LGA    K   100_A      H     109          1.929
LGA    G   101_A      R     110          1.888
LGA    I   102_A      L     111          1.796
LGA    G   103_A      G     112          1.826
LGA    R   104_A      R     113          2.125
LGA    K   105_A      A     114          1.288
LGA    L   106_A      M     115          0.612
LGA    L   107_A      L     116          1.568
LGA    I   108_A      G     117          1.231
LGA    T   109_A      H     118          0.509
LGA    C   110_A      I     119          1.961
LGA    L   111_A      L     120          2.013
LGA    D   112_A      E     121          1.264
LGA    F   113_A      R     122          2.289
LGA    L   114_A      Q     123           #
LGA    -       -      E     124           -
LGA    G   115_A      C     125          3.915
LGA    K   116_A      R     126          0.734
LGA    Y   117_A      H     127          2.858
LGA    N   118_A      V     128          1.330
LGA    D   119_A      R     129          1.301
LGA    T   120_A      H     130          1.508
LGA    I   121_A      L     131          1.529
LGA    E   122_A      E     132          1.350
LGA    L   123_A      T     133          1.257
LGA    W   124_A      T     134          1.627
LGA    V   125_A      V     135          2.183
LGA    G   126_A      G     136          2.297
LGA    E   127_A      P     137          2.521
LGA    K   128_A      D     138          2.538
LGA    N   129_A      N     139          1.733
LGA    Y   130_A      Q     140          1.648
LGA    G   131_A      A     141          1.449
LGA    A   132_A      S     142          0.802
LGA    M   133_A      R     143          1.191
LGA    N   134_A      R     144          1.516
LGA    L   135_A      T     145          1.097
LGA    Y   136_A      F     146          0.791
LGA    E   137_A      A     147          1.170
LGA    K   138_A      G     148          1.612
LGA    F   139_A      L     149          1.418
LGA    G   140_A      A     150          1.355
LGA    -       -      G     151           -
LGA    -       -      E     152           -
LGA    -       -      R     153           -
LGA    -       -      G     154           -
LGA    -       -      A     155           -
LGA    F   141_A      H     156           #
LGA    K   142_A      V     157          1.776
LGA    K   143_A      S     158          3.043
LGA    V   144_A      E     159          3.069
LGA    G   145_A      Q     160          1.715
LGA    K   146_A      P     161          1.979
LGA    S   147_A      F     162          2.180
LGA    -       -      F     163           -
LGA    G   148_A      D     164          1.046
LGA    -       -      R     165           -
LGA    -       -      Q     166           -
LGA    -       -      A     167           -
LGA    -       -      F     168           -
LGA    -       -      G     169           -
LGA    -       -      G     170           -
LGA    -       -      A     171           -
LGA    -       -      D     172           -
LGA    -       -      H     173           -
LGA    -       -      D     174           -
LGA    I   149_A      D     175          0.687
LGA    W   150_A      E     176          0.770
LGA    V   151_A      M     177          1.091
LGA    R   152_A      L     178          0.880
LGA    M   153_A      L     179          1.255
LGA    I   154_A      R     180          1.431
LGA    K   155_A      I     181          1.746
LGA    R   156_A      G     182          1.497
LGA    Q   157_A      P     183          3.138
LGA    -       -      F     184           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  157  159    5.0    136    2.11    11.76     66.120     6.144

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.332660 * X  +  -0.722209 * Y  +   0.606425 * Z  +  25.975739
  Y_new =  -0.902807 * X  +   0.058049 * Y  +  -0.426111 * Z  +   9.204391
  Z_new =   0.272539 * X  +  -0.689235 * Y  +  -0.671326 * Z  +  76.606735 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.343032    0.798560  [ DEG:  -134.2459     45.7541 ]
  Theta =  -0.276031   -2.865562  [ DEG:   -15.8154   -164.1846 ]
  Phi   =  -1.923833    1.217760  [ DEG:  -110.2275     69.7725 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1wwz_A                                        
REMARK     2: T0417.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1wwz_A.T0417.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  157  159   5.0  136   2.11   11.76  66.120
REMARK  ---------------------------------------------------------- 
MOLECULE 1wwz_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   19-JAN-05   1WWZ              
TITLE     CRYSTAL STRUCTURE OF PH1933 FROM PYROCOCCUS HORIKOSHII OT3            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN PH1933;                               
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS HORIKOSHII OT3;                      
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    STRUCTURAL GENOMICS, PYROCOCCUS HORIKOSHII OT3, RIKEN                 
KEYWDS   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.ASADA,N.KUNISHIMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS              
AUTHOR   2 INITIATIVE (RSGI)                                                    
REVDAT   1   01-FEB-05 1WWZ    0                                                
JRNL        AUTH   Y.ASADA,N.KUNISHIMA                                          
JRNL        TITL   CRYSTAL STRUCTURE OF PH1933 FROM PYROCOCCUS                  
JRNL        TITL 2 HORIKOSHII OT3                                               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.75 ANGSTROMS.                                          
DBREF  1WWZ A    1   159  UNP    O59596   O59596_PYRHO     1    159             
DBREF  1WWZ B    1   159  UNP    O59596   O59596_PYRHO     1    159             
SEQRES   1 A  159  MET ASP GLU ILE LYS ILE GLU LYS LEU LYS LYS LEU ASP          
SEQRES   2 A  159  LYS LYS ALA LEU ASN GLU LEU ILE ASP VAL TYR MET SER          
SEQRES   3 A  159  GLY TYR GLU GLY LEU GLU GLU TYR GLY GLY GLU GLY ARG          
SEQRES   4 A  159  ASP TYR ALA ARG ASN TYR ILE LYS TRP CYS TRP LYS LYS          
SEQRES   5 A  159  ALA SER ASP GLY PHE PHE VAL ALA LYS VAL GLY ASP LYS          
SEQRES   6 A  159  ILE VAL GLY PHE ILE VAL CYS ASP LYS ASP TRP PHE SER          
SEQRES   7 A  159  LYS TYR GLU GLY ARG ILE VAL GLY ALA ILE HIS GLU PHE          
SEQRES   8 A  159  VAL VAL ASP LYS LYS PHE GLN GLY LYS GLY ILE GLY ARG          
SEQRES   9 A  159  LYS LEU LEU ILE THR CYS LEU ASP PHE LEU GLY LYS TYR          
SEQRES  10 A  159  ASN ASP THR ILE GLU LEU TRP VAL GLY GLU LYS ASN TYR          
SEQRES  11 A  159  GLY ALA MET ASN LEU TYR GLU LYS PHE GLY PHE LYS LYS          
SEQRES  12 A  159  VAL GLY LYS SER GLY ILE TRP VAL ARG MET ILE LYS ARG          
SEQRES  13 A  159  GLN ASN LEU                                                  
SEQRES   1 B  159  MET ASP GLU ILE LYS ILE GLU LYS LEU LYS LYS LEU ASP          
SEQRES   2 B  159  LYS LYS ALA LEU ASN GLU LEU ILE ASP VAL TYR MET SER          
SEQRES   3 B  159  GLY TYR GLU GLY LEU GLU GLU TYR GLY GLY GLU GLY ARG          
SEQRES   4 B  159  ASP TYR ALA ARG ASN TYR ILE LYS TRP CYS TRP LYS LYS          
SEQRES   5 B  159  ALA SER ASP GLY PHE PHE VAL ALA LYS VAL GLY ASP LYS          
SEQRES   6 B  159  ILE VAL GLY PHE ILE VAL CYS ASP LYS ASP TRP PHE SER          
SEQRES   7 B  159  LYS TYR GLU GLY ARG ILE VAL GLY ALA ILE HIS GLU PHE          
SEQRES   8 B  159  VAL VAL ASP LYS LYS PHE GLN GLY LYS GLY ILE GLY ARG          
SEQRES   9 B  159  LYS LEU LEU ILE THR CYS LEU ASP PHE LEU GLY LYS TYR          
SEQRES  10 B  159  ASN ASP THR ILE GLU LEU TRP VAL GLY GLU LYS ASN TYR          
SEQRES  11 B  159  GLY ALA MET ASN LEU TYR GLU LYS PHE GLY PHE LYS LYS          
SEQRES  12 B  159  VAL GLY LYS SER GLY ILE TRP VAL ARG MET ILE LYS ARG          
SEQRES  13 B  159  GLN ASN LEU                                                  
HET    ACO   1001      51                                                       
HET    ACO   1002      51                                                       
HETNAM     ACO ACETYL COENZYME *A                                               
FORMUL   3  ACO    2(C23 H38 N7 O17 P3 S)                                       
FORMUL   5  HOH   *374(H2 O)                                                    
CRYST1   52.504   56.026  125.774  90.00  90.00  90.00 P 21 21 21    8          
ATOM      1  N   MET A   1     -12.431 -25.916  57.802  1.00 52.40           N  
ATOM      2  CA  MET A   1     -12.777 -24.473  57.955  1.00 52.04           C  
ATOM      3  C   MET A   1     -12.203 -23.642  56.810  1.00 51.00           C  
ATOM      4  O   MET A   1     -12.273 -24.034  55.644  1.00 51.56           O  
ATOM      5  CB  MET A   1     -12.239 -23.938  59.287  1.00 53.18           C  
ATOM      6  CG  MET A   1     -10.731 -24.079  59.451  1.00 54.30           C  
ATOM      7  SD  MET A   1     -10.084 -23.139  60.849  1.00 56.61           S  
ATOM      8  CE  MET A   1     -10.307 -24.318  62.190  1.00 55.60           C  
ATOM      9  N   ASP A   2     -11.636 -22.492  57.158  1.00 49.54           N  
ATOM     10  CA  ASP A   2     -11.042 -21.592  56.181  1.00 47.66           C  
ATOM     11  C   ASP A   2      -9.532 -21.799  56.112  1.00 45.57           C  
ATOM     12  O   ASP A   2      -8.860 -21.883  57.139  1.00 45.23           O  
ATOM     13  CB  ASP A   2     -11.336 -20.142  56.558  1.00 48.57           C  
ATOM     14  CG  ASP A   2     -12.815 -19.881  56.754  1.00 49.02           C  
ATOM     15  OD1 ASP A   2     -13.578 -19.998  55.772  1.00 48.99           O  
ATOM     16  OD2 ASP A   2     -13.213 -19.559  57.893  1.00 49.70           O  
ATOM     17  N   GLU A   3      -9.009 -21.881  54.894  1.00 43.42           N  
ATOM     18  CA  GLU A   3      -7.577 -22.057  54.681  1.00 40.91           C  
ATOM     19  C   GLU A   3      -6.879 -20.709  54.660  1.00 38.64           C  
ATOM     20  O   GLU A   3      -7.436 -19.715  54.196  1.00 38.12           O  
ATOM     21  CB  GLU A   3      -7.299 -22.720  53.333  1.00 41.76           C  
ATOM     22  CG  GLU A   3      -7.546 -24.204  53.240  1.00 43.32           C  
ATOM     23  CD  GLU A   3      -7.155 -24.743  51.873  1.00 44.67           C  
ATOM     24  OE1 GLU A   3      -5.947 -24.709  51.541  1.00 45.03           O  
ATOM     25  OE2 GLU A   3      -8.054 -25.189  51.131  1.00 45.43           O  
ATOM     26  N   ILE A   4      -5.652 -20.682  55.163  1.00 36.09           N  
ATOM     27  CA  ILE A   4      -4.858 -19.469  55.126  1.00 33.21           C  
ATOM     28  C   ILE A   4      -3.985 -19.721  53.910  1.00 31.62           C  
ATOM     29  O   ILE A   4      -3.125 -20.599  53.934  1.00 30.63           O  
ATOM     30  CB  ILE A   4      -3.962 -19.316  56.371  1.00 32.99           C  
ATOM     31  CG1 ILE A   4      -4.826 -19.308  57.631  1.00 33.77           C  
ATOM     32  CG2 ILE A   4      -3.153 -18.021  56.268  1.00 33.02           C  
ATOM     33  CD1 ILE A   4      -4.032 -19.293  58.919  1.00 33.83           C  
ATOM     34  N   LYS A   5      -4.230 -18.979  52.839  1.00 29.18           N  
ATOM     35  CA  LYS A   5      -3.463 -19.155  51.615  1.00 28.29           C  
ATOM     36  C   LYS A   5      -2.434 -18.050  51.438  1.00 27.09           C  
ATOM     37  O   LYS A   5      -2.757 -16.871  51.553  1.00 25.18           O  
ATOM     38  CB  LYS A   5      -4.398 -19.155  50.402  1.00 29.76           C  
ATOM     39  CG  LYS A   5      -5.547 -20.145  50.485  1.00 33.11           C  
ATOM     40  CD  LYS A   5      -6.438 -20.076  49.246  1.00 35.54           C  
ATOM     41  CE  LYS A   5      -7.069 -18.693  49.066  1.00 37.75           C  
ATOM     42  NZ  LYS A   5      -7.975 -18.316  50.192  1.00 37.31           N  
ATOM     43  N   ILE A   6      -1.195 -18.438  51.166  1.00 26.17           N  
ATOM     44  CA  ILE A   6      -0.140 -17.466  50.933  1.00 25.96           C  
ATOM     45  C   ILE A   6       0.150 -17.488  49.437  1.00 26.48           C  
ATOM     46  O   ILE A   6       0.412 -18.544  48.864  1.00 25.48           O  
ATOM     47  CB  ILE A   6       1.158 -17.818  51.697  1.00 25.25           C  
ATOM     48  CG1 ILE A   6       0.873 -17.960  53.196  1.00 25.58           C  
ATOM     49  CG2 ILE A   6       2.201 -16.733  51.460  1.00 24.11           C  
ATOM     50  CD1 ILE A   6       0.334 -16.704  53.853  1.00 25.18           C  
ATOM     51  N   GLU A   7       0.090 -16.325  48.800  1.00 26.84           N  
ATOM     52  CA  GLU A   7       0.351 -16.250  47.368  1.00 28.06           C  
ATOM     53  C   GLU A   7       0.968 -14.926  46.951  1.00 27.44           C  
ATOM     54  O   GLU A   7       0.852 -13.926  47.654  1.00 25.61           O  
ATOM     55  CB  GLU A   7      -0.946 -16.488  46.586  1.00 30.75           C  
ATOM     56  CG  GLU A   7      -2.195 -15.932  47.257  1.00 34.93           C  
ATOM     57  CD  GLU A   7      -3.451 -16.142  46.424  1.00 38.48           C  
ATOM     58  OE1 GLU A   7      -3.747 -15.288  45.560  1.00 40.01           O  
ATOM     59  OE2 GLU A   7      -4.136 -17.169  46.630  1.00 40.13           O  
ATOM     60  N   LYS A   8       1.645 -14.932  45.807  1.00 26.85           N  
ATOM     61  CA  LYS A   8       2.254 -13.716  45.291  1.00 28.08           C  
ATOM     62  C   LYS A   8       1.159 -12.831  44.729  1.00 28.33           C  
ATOM     63  O   LYS A   8       0.262 -13.305  44.033  1.00 28.36           O  
ATOM     64  CB  LYS A   8       3.247 -14.030  44.172  1.00 29.71           C  
ATOM     65  CG  LYS A   8       4.666 -14.274  44.629  1.00 31.99           C  
ATOM     66  CD  LYS A   8       5.607 -14.278  43.438  1.00 32.53           C  
ATOM     67  CE  LYS A   8       7.047 -14.454  43.865  1.00 32.41           C  
ATOM     68  NZ  LYS A   8       7.966 -14.346  42.703  1.00 32.02           N  
ATOM     69  N   LEU A   9       1.221 -11.547  45.047  1.00 27.35           N  
ATOM     70  CA  LEU A   9       0.240 -10.609  44.533  1.00 27.33           C  
ATOM     71  C   LEU A   9       0.553 -10.449  43.047  1.00 27.64           C  
ATOM     72  O   LEU A   9       1.598  -9.912  42.688  1.00 27.56           O  
ATOM     73  CB  LEU A   9       0.375  -9.264  45.243  1.00 25.87           C  
ATOM     74  CG  LEU A   9      -0.611  -8.179  44.813  1.00 25.82           C  
ATOM     75  CD1 LEU A   9      -2.034  -8.667  45.041  1.00 25.27           C  
ATOM     76  CD2 LEU A   9      -0.336  -6.905  45.602  1.00 24.11           C  
ATOM     77  N   LYS A  10      -0.346 -10.924  42.191  1.00 28.22           N  
ATOM     78  CA  LYS A  10      -0.144 -10.848  40.748  1.00 29.75           C  
ATOM     79  C   LYS A  10      -0.191  -9.434  40.189  1.00 30.12           C  
ATOM     80  O   LYS A  10       0.568  -9.094  39.278  1.00 29.29           O  
ATOM     81  CB  LYS A  10      -1.188 -11.697  40.021  1.00 31.55           C  
ATOM     82  CG  LYS A  10      -1.057 -13.180  40.280  1.00 34.72           C  
ATOM     83  CD  LYS A  10      -2.012 -13.984  39.416  1.00 36.26           C  
ATOM     84  CE  LYS A  10      -1.959 -15.444  39.816  1.00 38.46           C  
ATOM     85  NZ  LYS A  10      -0.546 -15.860  40.059  1.00 39.75           N  
ATOM     86  N   LYS A  11      -1.082  -8.613  40.728  1.00 30.88           N  
ATOM     87  CA  LYS A  11      -1.210  -7.253  40.242  1.00 31.68           C  
ATOM     88  C   LYS A  11      -1.741  -6.303  41.303  1.00 30.83           C  
ATOM     89  O   LYS A  11      -2.527  -6.691  42.169  1.00 30.23           O  
ATOM     90  CB  LYS A  11      -2.124  -7.236  39.019  1.00 34.48           C  
ATOM     91  CG  LYS A  11      -3.564  -7.642  39.303  1.00 36.58           C  
ATOM     92  CD  LYS A  11      -4.366  -7.770  38.011  1.00 39.91           C  
ATOM     93  CE  LYS A  11      -3.991  -6.671  37.024  1.00 40.82           C  
ATOM     94  NZ  LYS A  11      -4.981  -6.529  35.928  1.00 42.93           N  
ATOM     95  N   LEU A  12      -1.303  -5.051  41.226  1.00 30.67           N  
ATOM     96  CA  LEU A  12      -1.733  -4.037  42.178  1.00 31.50           C  
ATOM     97  C   LEU A  12      -2.797  -3.123  41.577  1.00 32.18           C  
ATOM     98  O   LEU A  12      -2.529  -1.962  41.259  1.00 30.91           O  
ATOM     99  CB  LEU A  12      -0.538  -3.197  42.647  1.00 30.48           C  
ATOM    100  CG  LEU A  12      -0.865  -2.165  43.728  1.00 31.32           C  
ATOM    101  CD1 LEU A  12      -1.308  -2.880  44.985  1.00 31.43           C  
ATOM    102  CD2 LEU A  12       0.344  -1.299  44.020  1.00 30.62           C  
ATOM    103  N   ASP A  13      -4.004  -3.652  41.415  1.00 33.99           N  
ATOM    104  CA  ASP A  13      -5.099  -2.861  40.870  1.00 35.28           C  
ATOM    105  C   ASP A  13      -5.705  -2.024  41.997  1.00 35.38           C  
ATOM    106  O   ASP A  13      -5.473  -2.301  43.172  1.00 33.69           O  
ATOM    107  CB  ASP A  13      -6.167  -3.776  40.251  1.00 38.02           C  
ATOM    108  CG  ASP A  13      -6.699  -4.807  41.230  1.00 39.98           C  
ATOM    109  OD1 ASP A  13      -7.006  -4.424  42.373  1.00 42.32           O  
ATOM    110  OD2 ASP A  13      -6.823  -5.997  40.856  1.00 42.69           O  
ATOM    111  N   LYS A  14      -6.475  -1.003  41.633  1.00 35.86           N  
ATOM    112  CA  LYS A  14      -7.109  -0.133  42.619  1.00 36.27           C  
ATOM    113  C   LYS A  14      -7.828  -0.936  43.705  1.00 35.41           C  
ATOM    114  O   LYS A  14      -7.893  -0.521  44.864  1.00 35.09           O  
ATOM    115  CB  LYS A  14      -8.099   0.812  41.929  1.00 37.61           C  
ATOM    116  CG  LYS A  14      -7.438   1.795  40.973  1.00 39.59           C  
ATOM    117  CD  LYS A  14      -8.452   2.736  40.335  1.00 41.31           C  
ATOM    118  CE  LYS A  14      -7.772   3.734  39.397  1.00 42.75           C  
ATOM    119  NZ  LYS A  14      -8.745   4.662  38.740  1.00 43.45           N  
ATOM    120  N   LYS A  15      -8.365  -2.090  43.326  1.00 35.46           N  
ATOM    121  CA  LYS A  15      -9.072  -2.949  44.267  1.00 35.19           C  
ATOM    122  C   LYS A  15      -8.114  -3.580  45.280  1.00 34.04           C  
ATOM    123  O   LYS A  15      -8.324  -3.496  46.491  1.00 34.65           O  
ATOM    124  CB  LYS A  15      -9.826  -4.044  43.504  1.00 37.40           C  
ATOM    125  CG  LYS A  15     -10.394  -5.149  44.383  1.00 38.60           C  
ATOM    126  CD  LYS A  15     -11.166  -6.163  43.554  1.00 42.17           C  
ATOM    127  CE  LYS A  15     -11.520  -7.399  44.369  1.00 42.52           C  
ATOM    128  NZ  LYS A  15     -10.931  -8.634  43.769  1.00 44.24           N  
ATOM    129  N   ALA A  16      -7.062  -4.212  44.773  1.00 32.20           N  
ATOM    130  CA  ALA A  16      -6.072  -4.860  45.624  1.00 30.63           C  
ATOM    131  C   ALA A  16      -5.404  -3.835  46.534  1.00 28.44           C  
ATOM    132  O   ALA A  16      -5.214  -4.076  47.725  1.00 28.11           O  
ATOM    133  CB  ALA A  16      -5.022  -5.559  44.767  1.00 30.17           C  
ATOM    134  N   LEU A  17      -5.052  -2.690  45.960  1.00 27.93           N  
ATOM    135  CA  LEU A  17      -4.402  -1.627  46.712  1.00 26.42           C  
ATOM    136  C   LEU A  17      -5.281  -1.199  47.874  1.00 26.52           C  
ATOM    137  O   LEU A  17      -4.797  -0.978  48.983  1.00 24.97           O  
ATOM    138  CB  LEU A  17      -4.122  -0.433  45.795  1.00 25.81           C  
ATOM    139  CG  LEU A  17      -3.473   0.791  46.442  1.00 26.84           C  
ATOM    140  CD1 LEU A  17      -2.138   0.403  47.070  1.00 25.40           C  
ATOM    141  CD2 LEU A  17      -3.279   1.869  45.391  1.00 26.10           C  
ATOM    142  N   ASN A  18      -6.580  -1.091  47.615  1.00 27.90           N  
ATOM    143  CA  ASN A  18      -7.533  -0.688  48.641  1.00 29.97           C  
ATOM    144  C   ASN A  18      -7.524  -1.686  49.797  1.00 29.00           C  
ATOM    145  O   ASN A  18      -7.526  -1.295  50.965  1.00 28.68           O  
ATOM    146  CB  ASN A  18      -8.938  -0.599  48.043  1.00 33.19           C  
ATOM    147  CG  ASN A  18      -9.858   0.293  48.850  1.00 36.63           C  
ATOM    148  OD1 ASN A  18      -9.677   1.511  48.892  1.00 39.44           O  
ATOM    149  ND2 ASN A  18     -10.845  -0.309  49.501  1.00 39.66           N  
ATOM    150  N   GLU A  19      -7.519  -2.975  49.469  1.00 29.00           N  
ATOM    151  CA  GLU A  19      -7.501  -4.022  50.486  1.00 27.89           C  
ATOM    152  C   GLU A  19      -6.214  -3.974  51.297  1.00 26.42           C  
ATOM    153  O   GLU A  19      -6.232  -4.126  52.519  1.00 24.00           O  
ATOM    154  CB  GLU A  19      -7.617  -5.407  49.844  1.00 31.41           C  
ATOM    155  CG  GLU A  19      -8.953  -5.715  49.207  1.00 34.58           C  
ATOM    156  CD  GLU A  19      -9.003  -7.131  48.664  1.00 37.01           C  
ATOM    157  OE1 GLU A  19      -8.790  -8.075  49.455  1.00 38.09           O  
ATOM    158  OE2 GLU A  19      -9.252  -7.299  47.451  1.00 38.67           O  
ATOM    159  N   LEU A  20      -5.092  -3.777  50.611  1.00 24.07           N  
ATOM    160  CA  LEU A  20      -3.807  -3.717  51.292  1.00 22.46           C  
ATOM    161  C   LEU A  20      -3.782  -2.529  52.242  1.00 21.02           C  
ATOM    162  O   LEU A  20      -3.256  -2.619  53.352  1.00 19.83           O  
ATOM    163  CB  LEU A  20      -2.665  -3.611  50.276  1.00 23.04           C  
ATOM    164  CG  LEU A  20      -2.417  -4.876  49.445  1.00 24.34           C  
ATOM    165  CD1 LEU A  20      -1.423  -4.576  48.344  1.00 24.62           C  
ATOM    166  CD2 LEU A  20      -1.904  -5.998  50.341  1.00 26.11           C  
ATOM    167  N   ILE A  21      -4.356  -1.415  51.807  1.00 21.10           N  
ATOM    168  CA  ILE A  21      -4.392  -0.230  52.647  1.00 20.77           C  
ATOM    169  C   ILE A  21      -5.203  -0.509  53.912  1.00 21.71           C  
ATOM    170  O   ILE A  21      -4.774  -0.165  55.013  1.00 21.41           O  
ATOM    171  CB  ILE A  21      -4.985   0.974  51.883  1.00 20.65           C  
ATOM    172  CG1 ILE A  21      -4.039   1.368  50.744  1.00 21.05           C  
ATOM    173  CG2 ILE A  21      -5.192   2.145  52.832  1.00 22.02           C  
ATOM    174  CD1 ILE A  21      -4.535   2.516  49.884  1.00 22.86           C  
ATOM    175  N   ASP A  22      -6.363  -1.145  53.759  1.00 23.34           N  
ATOM    176  CA  ASP A  22      -7.206  -1.472  54.912  1.00 24.13           C  
ATOM    177  C   ASP A  22      -6.436  -2.346  55.906  1.00 22.78           C  
ATOM    178  O   ASP A  22      -6.452  -2.097  57.114  1.00 20.86           O  
ATOM    179  CB  ASP A  22      -8.480  -2.212  54.476  1.00 26.80           C  
ATOM    180  CG  ASP A  22      -9.375  -1.376  53.577  1.00 29.84           C  
ATOM    181  OD1 ASP A  22      -9.230  -0.135  53.560  1.00 31.92           O  
ATOM    182  OD2 ASP A  22     -10.241  -1.965  52.895  1.00 32.81           O  
ATOM    183  N   VAL A  23      -5.766  -3.372  55.391  1.00 22.28           N  
ATOM    184  CA  VAL A  23      -4.984  -4.275  56.229  1.00 21.60           C  
ATOM    185  C   VAL A  23      -3.881  -3.498  56.938  1.00 21.61           C  
ATOM    186  O   VAL A  23      -3.645  -3.670  58.134  1.00 21.24           O  
ATOM    187  CB  VAL A  23      -4.335  -5.401  55.382  1.00 22.55           C  
ATOM    188  CG1 VAL A  23      -3.302  -6.157  56.211  1.00 21.46           C  
ATOM    189  CG2 VAL A  23      -5.408  -6.354  54.881  1.00 21.71           C  
ATOM    190  N   TYR A  24      -3.207  -2.640  56.181  1.00 20.55           N  
ATOM    191  CA  TYR A  24      -2.126  -1.826  56.713  1.00 20.51           C  
ATOM    192  C   TYR A  24      -2.629  -0.910  57.829  1.00 20.79           C  
ATOM    193  O   TYR A  24      -2.054  -0.870  58.916  1.00 19.47           O  
ATOM    194  CB  TYR A  24      -1.522  -0.993  55.581  1.00 19.35           C  
ATOM    195  CG  TYR A  24      -0.374  -0.102  55.992  1.00 19.76           C  
ATOM    196  CD1 TYR A  24       0.947  -0.457  55.713  1.00 20.00           C  
ATOM    197  CD2 TYR A  24      -0.609   1.115  56.630  1.00 19.34           C  
ATOM    198  CE1 TYR A  24       2.003   0.386  56.056  1.00 19.87           C  
ATOM    199  CE2 TYR A  24       0.432   1.958  56.976  1.00 19.27           C  
ATOM    200  CZ  TYR A  24       1.736   1.592  56.687  1.00 20.42           C  
ATOM    201  OH  TYR A  24       2.763   2.440  57.015  1.00 21.21           O  
ATOM    202  N   MET A  25      -3.703  -0.175  57.555  1.00 21.07           N  
ATOM    203  CA  MET A  25      -4.269   0.741  58.544  1.00 23.99           C  
ATOM    204  C   MET A  25      -4.735   0.007  59.800  1.00 24.33           C  
ATOM    205  O   MET A  25      -4.580   0.504  60.919  1.00 24.17           O  
ATOM    206  CB  MET A  25      -5.445   1.517  57.941  1.00 24.41           C  
ATOM    207  CG  MET A  25      -5.081   2.414  56.769  1.00 26.96           C  
ATOM    208  SD  MET A  25      -3.772   3.592  57.154  1.00 27.68           S  
ATOM    209  CE  MET A  25      -4.637   4.735  58.258  1.00 27.05           C  
ATOM    210  N   SER A  26      -5.315  -1.173  59.605  1.00 25.24           N  
ATOM    211  CA  SER A  26      -5.799  -1.984  60.713  1.00 25.72           C  
ATOM    212  C   SER A  26      -4.636  -2.469  61.566  1.00 25.99           C  
ATOM    213  O   SER A  26      -4.650  -2.343  62.790  1.00 25.98           O  
ATOM    214  CB  SER A  26      -6.580  -3.188  60.178  1.00 26.61           C  
ATOM    215  OG  SER A  26      -6.859  -4.118  61.213  1.00 27.55           O  
ATOM    216  N   GLY A  27      -3.622  -3.018  60.910  1.00 26.00           N  
ATOM    217  CA  GLY A  27      -2.470  -3.528  61.626  1.00 25.71           C  
ATOM    218  C   GLY A  27      -1.609  -2.483  62.306  1.00 25.21           C  
ATOM    219  O   GLY A  27      -1.052  -2.744  63.367  1.00 25.73           O  
ATOM    220  N   TYR A  28      -1.485  -1.304  61.703  1.00 24.82           N  
ATOM    221  CA  TYR A  28      -0.665  -0.249  62.290  1.00 25.69           C  
ATOM    222  C   TYR A  28      -1.402   0.668  63.254  1.00 28.27           C  
ATOM    223  O   TYR A  28      -0.843   1.664  63.717  1.00 27.78           O  
ATOM    224  CB  TYR A  28      -0.007   0.600  61.203  1.00 23.80           C  
ATOM    225  CG  TYR A  28       1.321   0.042  60.743  1.00 21.72           C  
ATOM    226  CD1 TYR A  28       1.424  -0.685  59.556  1.00 21.76           C  
ATOM    227  CD2 TYR A  28       2.469   0.211  61.517  1.00 20.66           C  
ATOM    228  CE1 TYR A  28       2.640  -1.234  59.154  1.00 19.87           C  
ATOM    229  CE2 TYR A  28       3.688  -0.333  61.125  1.00 20.48           C  
ATOM    230  CZ  TYR A  28       3.765  -1.054  59.944  1.00 19.04           C  
ATOM    231  OH  TYR A  28       4.965  -1.603  59.562  1.00 18.58           O  
ATOM    232  N   GLU A  29      -2.651   0.334  63.556  1.00 30.04           N  
ATOM    233  CA  GLU A  29      -3.434   1.141  64.480  1.00 32.95           C  
ATOM    234  C   GLU A  29      -2.752   1.077  65.842  1.00 33.52           C  
ATOM    235  O   GLU A  29      -2.559  -0.006  66.400  1.00 33.84           O  
ATOM    236  CB  GLU A  29      -4.862   0.607  64.578  1.00 35.35           C  
ATOM    237  CG  GLU A  29      -5.820   1.537  65.312  1.00 39.25           C  
ATOM    238  CD  GLU A  29      -7.098   0.840  65.735  1.00 41.02           C  
ATOM    239  OE1 GLU A  29      -6.997  -0.185  66.444  1.00 43.31           O  
ATOM    240  OE2 GLU A  29      -8.194   1.316  65.369  1.00 43.33           O  
ATOM    241  N   GLY A  30      -2.378   2.241  66.367  1.00 34.22           N  
ATOM    242  CA  GLY A  30      -1.706   2.292  67.653  1.00 33.83           C  
ATOM    243  C   GLY A  30      -0.210   2.468  67.480  1.00 33.78           C  
ATOM    244  O   GLY A  30       0.487   2.885  68.406  1.00 34.16           O  
ATOM    245  N   LEU A  31       0.283   2.148  66.285  1.00 32.35           N  
ATOM    246  CA  LEU A  31       1.701   2.266  65.963  1.00 32.17           C  
ATOM    247  C   LEU A  31       1.919   3.305  64.867  1.00 31.41           C  
ATOM    248  O   LEU A  31       2.846   3.189  64.060  1.00 30.65           O  
ATOM    249  CB  LEU A  31       2.257   0.906  65.516  1.00 32.88           C  
ATOM    250  CG  LEU A  31       2.550  -0.120  66.612  1.00 34.51           C  
ATOM    251  CD1 LEU A  31       2.799  -1.475  65.989  1.00 34.38           C  
ATOM    252  CD2 LEU A  31       3.756   0.321  67.422  1.00 34.12           C  
ATOM    253  N   GLU A  32       1.063   4.323  64.854  1.00 30.82           N  
ATOM    254  CA  GLU A  32       1.135   5.398  63.868  1.00 30.89           C  
ATOM    255  C   GLU A  32       2.505   6.076  63.819  1.00 30.08           C  
ATOM    256  O   GLU A  32       2.864   6.681  62.810  1.00 29.44           O  
ATOM    257  CB  GLU A  32       0.071   6.467  64.154  1.00 32.11           C  
ATOM    258  CG  GLU A  32      -1.381   6.019  64.007  1.00 33.81           C  
ATOM    259  CD  GLU A  32      -1.859   5.128  65.142  1.00 34.27           C  
ATOM    260  OE1 GLU A  32      -1.188   5.078  66.195  1.00 35.85           O  
ATOM    261  OE2 GLU A  32      -2.920   4.488  64.982  1.00 35.74           O  
ATOM    262  N   GLU A  33       3.255   5.990  64.914  1.00 29.66           N  
ATOM    263  CA  GLU A  33       4.579   6.593  64.980  1.00 29.40           C  
ATOM    264  C   GLU A  33       5.476   5.978  63.910  1.00 28.75           C  
ATOM    265  O   GLU A  33       6.397   6.627  63.411  1.00 28.91           O  
ATOM    266  CB  GLU A  33       5.189   6.386  66.376  1.00 30.10           C  
ATOM    267  CG  GLU A  33       6.679   6.708  66.481  1.00 31.43           C  
ATOM    268  CD  GLU A  33       7.176   6.791  67.923  1.00 32.71           C  
ATOM    269  OE1 GLU A  33       6.615   6.091  68.793  1.00 32.30           O  
ATOM    270  OE2 GLU A  33       8.142   7.541  68.180  1.00 32.96           O  
ATOM    271  N   TYR A  34       5.189   4.730  63.554  1.00 27.29           N  
ATOM    272  CA  TYR A  34       5.969   4.016  62.549  1.00 26.85           C  
ATOM    273  C   TYR A  34       5.171   3.803  61.270  1.00 27.14           C  
ATOM    274  O   TYR A  34       5.725   3.834  60.170  1.00 27.39           O  
ATOM    275  CB  TYR A  34       6.413   2.661  63.102  1.00 25.61           C  
ATOM    276  CG  TYR A  34       7.088   2.752  64.450  1.00 24.61           C  
ATOM    277  CD1 TYR A  34       8.244   3.512  64.623  1.00 23.53           C  
ATOM    278  CD2 TYR A  34       6.565   2.086  65.557  1.00 24.93           C  
ATOM    279  CE1 TYR A  34       8.866   3.606  65.868  1.00 23.93           C  
ATOM    280  CE2 TYR A  34       7.177   2.173  66.808  1.00 23.80           C  
ATOM    281  CZ  TYR A  34       8.326   2.933  66.956  1.00 23.75           C  
ATOM    282  OH  TYR A  34       8.942   3.008  68.184  1.00 23.55           O  
ATOM    283  N   GLY A  35       3.866   3.593  61.418  1.00 27.70           N  
ATOM    284  CA  GLY A  35       3.019   3.365  60.262  1.00 27.17           C  
ATOM    285  C   GLY A  35       2.513   4.619  59.570  1.00 27.86           C  
ATOM    286  O   GLY A  35       1.943   4.531  58.488  1.00 27.32           O  
ATOM    287  N   GLY A  36       2.719   5.781  60.185  1.00 28.47           N  
ATOM    288  CA  GLY A  36       2.250   7.020  59.590  1.00 30.01           C  
ATOM    289  C   GLY A  36       0.772   7.244  59.866  1.00 32.13           C  
ATOM    290  O   GLY A  36       0.097   6.359  60.395  1.00 32.39           O  
ATOM    291  N   GLU A  37       0.266   8.423  59.512  1.00 33.30           N  
ATOM    292  CA  GLU A  37      -1.143   8.753  59.732  1.00 34.50           C  
ATOM    293  C   GLU A  37      -1.901   8.934  58.423  1.00 33.92           C  
ATOM    294  O   GLU A  37      -1.408   9.572  57.493  1.00 35.28           O  
ATOM    295  CB  GLU A  37      -1.269  10.034  60.569  1.00 36.62           C  
ATOM    296  CG  GLU A  37      -0.818   9.886  62.021  1.00 40.28           C  
ATOM    297  CD  GLU A  37      -1.894   9.304  62.926  1.00 42.83           C  
ATOM    298  OE1 GLU A  37      -2.815   8.636  62.402  1.00 44.63           O  
ATOM    299  OE2 GLU A  37      -1.809   9.506  64.157  1.00 44.06           O  
ATOM    300  N   GLY A  38      -3.099   8.364  58.357  1.00 33.12           N  
ATOM    301  CA  GLY A  38      -3.919   8.486  57.166  1.00 31.49           C  
ATOM    302  C   GLY A  38      -3.680   7.425  56.113  1.00 30.44           C  
ATOM    303  O   GLY A  38      -2.595   6.854  56.017  1.00 29.36           O  
ATOM    304  N   ARG A  39      -4.709   7.170  55.311  1.00 29.79           N  
ATOM    305  CA  ARG A  39      -4.633   6.179  54.248  1.00 29.46           C  
ATOM    306  C   ARG A  39      -3.675   6.610  53.135  1.00 29.01           C  
ATOM    307  O   ARG A  39      -3.138   5.770  52.414  1.00 28.29           O  
ATOM    308  CB  ARG A  39      -6.029   5.932  53.669  1.00 30.07           C  
ATOM    309  CG  ARG A  39      -7.008   5.302  54.654  1.00 30.44           C  
ATOM    310  CD  ARG A  39      -8.405   5.203  54.060  1.00 31.12           C  
ATOM    311  NE  ARG A  39      -8.473   4.283  52.927  1.00 31.07           N  
ATOM    312  CZ  ARG A  39      -8.482   2.959  53.036  1.00 30.86           C  
ATOM    313  NH1 ARG A  39      -8.431   2.387  54.231  1.00 32.43           N  
ATOM    314  NH2 ARG A  39      -8.543   2.205  51.946  1.00 31.65           N  
ATOM    315  N   ASP A  40      -3.462   7.917  52.998  1.00 29.03           N  
ATOM    316  CA  ASP A  40      -2.565   8.438  51.970  1.00 28.58           C  
ATOM    317  C   ASP A  40      -1.134   7.953  52.181  1.00 26.65           C  
ATOM    318  O   ASP A  40      -0.481   7.514  51.235  1.00 25.94           O  
ATOM    319  CB  ASP A  40      -2.592   9.969  51.958  1.00 32.22           C  
ATOM    320  CG  ASP A  40      -3.913  10.523  51.468  1.00 35.48           C  
ATOM    321  OD1 ASP A  40      -4.955  10.218  52.086  1.00 39.24           O  
ATOM    322  OD2 ASP A  40      -3.909  11.266  50.466  1.00 38.40           O  
ATOM    323  N   TYR A  41      -0.645   8.041  53.415  1.00 25.29           N  
ATOM    324  CA  TYR A  41       0.707   7.587  53.722  1.00 23.90           C  
ATOM    325  C   TYR A  41       0.825   6.118  53.317  1.00 23.68           C  
ATOM    326  O   TYR A  41       1.763   5.723  52.619  1.00 21.86           O  
ATOM    327  CB  TYR A  41       0.999   7.722  55.220  1.00 24.58           C  
ATOM    328  CG  TYR A  41       2.378   7.237  55.619  1.00 24.44           C  
ATOM    329  CD1 TYR A  41       3.424   8.133  55.827  1.00 25.53           C  
ATOM    330  CD2 TYR A  41       2.641   5.875  55.771  1.00 25.96           C  
ATOM    331  CE1 TYR A  41       4.700   7.683  56.180  1.00 26.16           C  
ATOM    332  CE2 TYR A  41       3.910   5.417  56.119  1.00 25.77           C  
ATOM    333  CZ  TYR A  41       4.933   6.325  56.323  1.00 25.96           C  
ATOM    334  OH  TYR A  41       6.187   5.872  56.674  1.00 27.77           O  
ATOM    335  N   ALA A  42      -0.142   5.318  53.762  1.00 22.94           N  
ATOM    336  CA  ALA A  42      -0.168   3.892  53.461  1.00 21.94           C  
ATOM    337  C   ALA A  42      -0.210   3.645  51.959  1.00 21.67           C  
ATOM    338  O   ALA A  42       0.538   2.822  51.441  1.00 19.40           O  
ATOM    339  CB  ALA A  42      -1.377   3.238  54.130  1.00 22.36           C  
ATOM    340  N   ARG A  43      -1.086   4.361  51.261  1.00 21.20           N  
ATOM    341  CA  ARG A  43      -1.210   4.202  49.819  1.00 21.29           C  
ATOM    342  C   ARG A  43       0.117   4.470  49.112  1.00 21.07           C  
ATOM    343  O   ARG A  43       0.549   3.686  48.270  1.00 19.35           O  
ATOM    344  CB  ARG A  43      -2.288   5.144  49.263  1.00 23.21           C  
ATOM    345  CG  ARG A  43      -2.548   4.960  47.770  1.00 25.21           C  
ATOM    346  CD  ARG A  43      -3.667   5.861  47.240  1.00 29.44           C  
ATOM    347  NE  ARG A  43      -4.957   5.601  47.882  1.00 31.55           N  
ATOM    348  CZ  ARG A  43      -5.359   6.169  49.015  1.00 34.49           C  
ATOM    349  NH1 ARG A  43      -4.575   7.037  49.643  1.00 36.00           N  
ATOM    350  NH2 ARG A  43      -6.546   5.870  49.526  1.00 33.82           N  
ATOM    351  N   ASN A  44       0.764   5.578  49.460  1.00 20.97           N  
ATOM    352  CA  ASN A  44       2.029   5.922  48.832  1.00 22.16           C  
ATOM    353  C   ASN A  44       3.148   4.937  49.146  1.00 21.24           C  
ATOM    354  O   ASN A  44       3.931   4.589  48.263  1.00 20.05           O  
ATOM    355  CB  ASN A  44       2.458   7.336  49.227  1.00 24.13           C  
ATOM    356  CG  ASN A  44       1.449   8.381  48.807  1.00 27.26           C  
ATOM    357  OD1 ASN A  44       0.809   8.250  47.764  1.00 29.08           O  
ATOM    358  ND2 ASN A  44       1.309   9.432  49.608  1.00 27.76           N  
ATOM    359  N   TYR A  45       3.238   4.487  50.393  1.00 19.66           N  
ATOM    360  CA  TYR A  45       4.296   3.548  50.733  1.00 17.83           C  
ATOM    361  C   TYR A  45       4.079   2.206  50.041  1.00 17.26           C  
ATOM    362  O   TYR A  45       5.019   1.617  49.501  1.00 16.69           O  
ATOM    363  CB  TYR A  45       4.397   3.341  52.247  1.00 15.83           C  
ATOM    364  CG  TYR A  45       5.619   2.530  52.624  1.00 16.31           C  
ATOM    365  CD1 TYR A  45       6.884   2.922  52.196  1.00 16.71           C  
ATOM    366  CD2 TYR A  45       5.510   1.362  53.377  1.00 15.41           C  
ATOM    367  CE1 TYR A  45       8.014   2.177  52.503  1.00 16.58           C  
ATOM    368  CE2 TYR A  45       6.639   0.602  53.691  1.00 17.20           C  
ATOM    369  CZ  TYR A  45       7.886   1.020  53.249  1.00 16.95           C  
ATOM    370  OH  TYR A  45       9.012   0.287  53.547  1.00 18.43           O  
ATOM    371  N   ILE A  46       2.841   1.724  50.045  1.00 16.27           N  
ATOM    372  CA  ILE A  46       2.532   0.451  49.402  1.00 15.72           C  
ATOM    373  C   ILE A  46       2.821   0.497  47.901  1.00 15.72           C  
ATOM    374  O   ILE A  46       3.343  -0.465  47.336  1.00 15.18           O  
ATOM    375  CB  ILE A  46       1.059   0.048  49.665  1.00 15.46           C  
ATOM    376  CG1 ILE A  46       0.872  -0.220  51.162  1.00 16.90           C  
ATOM    377  CG2 ILE A  46       0.694  -1.196  48.863  1.00 15.61           C  
ATOM    378  CD1 ILE A  46      -0.557  -0.518  51.579  1.00 16.69           C  
ATOM    379  N   LYS A  47       2.501   1.612  47.252  1.00 15.62           N  
ATOM    380  CA  LYS A  47       2.777   1.745  45.820  1.00 16.74           C  
ATOM    381  C   LYS A  47       4.286   1.709  45.586  1.00 16.15           C  
ATOM    382  O   LYS A  47       4.768   1.075  44.643  1.00 15.55           O  
ATOM    383  CB  LYS A  47       2.200   3.055  45.282  1.00 19.15           C  
ATOM    384  CG  LYS A  47       0.683   3.101  45.275  1.00 21.58           C  
ATOM    385  CD  LYS A  47       0.170   4.463  44.822  1.00 23.80           C  
ATOM    386  CE  LYS A  47       0.597   4.778  43.402  1.00 28.24           C  
ATOM    387  NZ  LYS A  47       0.113   6.125  42.975  1.00 31.44           N  
ATOM    388  N   TRP A  48       5.030   2.385  46.453  1.00 14.99           N  
ATOM    389  CA  TRP A  48       6.485   2.412  46.347  1.00 15.75           C  
ATOM    390  C   TRP A  48       7.053   1.001  46.523  1.00 16.48           C  
ATOM    391  O   TRP A  48       7.967   0.599  45.797  1.00 15.79           O  
ATOM    392  CB  TRP A  48       7.081   3.333  47.413  1.00 16.17           C  
ATOM    393  CG  TRP A  48       8.572   3.491  47.309  1.00 14.39           C  
ATOM    394  CD1 TRP A  48       9.255   4.372  46.516  1.00 15.58           C  
ATOM    395  CD2 TRP A  48       9.560   2.718  47.996  1.00 15.57           C  
ATOM    396  NE1 TRP A  48      10.613   4.196  46.672  1.00 15.79           N  
ATOM    397  CE2 TRP A  48      10.828   3.189  47.577  1.00 16.31           C  
ATOM    398  CE3 TRP A  48       9.501   1.676  48.932  1.00 16.57           C  
ATOM    399  CZ2 TRP A  48      12.025   2.646  48.055  1.00 18.17           C  
ATOM    400  CZ3 TRP A  48      10.695   1.134  49.410  1.00 18.19           C  
ATOM    401  CH2 TRP A  48      11.941   1.627  48.970  1.00 18.84           C  
ATOM    402  N   CYS A  49       6.515   0.256  47.487  1.00 15.45           N  
ATOM    403  CA  CYS A  49       6.978  -1.110  47.733  1.00 17.05           C  
ATOM    404  C   CYS A  49       6.721  -2.000  46.521  1.00 17.46           C  
ATOM    405  O   CYS A  49       7.550  -2.834  46.159  1.00 15.90           O  
ATOM    406  CB  CYS A  49       6.274  -1.714  48.947  1.00 16.48           C  
ATOM    407  SG  CYS A  49       6.841  -1.090  50.544  1.00 17.81           S  
ATOM    408  N   TRP A  50       5.558  -1.817  45.903  1.00 17.25           N  
ATOM    409  CA  TRP A  50       5.188  -2.595  44.727  1.00 18.62           C  
ATOM    410  C   TRP A  50       6.125  -2.307  43.560  1.00 18.88           C  
ATOM    411  O   TRP A  50       6.600  -3.225  42.896  1.00 20.30           O  
ATOM    412  CB  TRP A  50       3.744  -2.282  44.321  1.00 18.14           C  
ATOM    413  CG  TRP A  50       3.315  -2.954  43.046  1.00 18.76           C  
ATOM    414  CD1 TRP A  50       3.177  -2.372  41.819  1.00 18.14           C  
ATOM    415  CD2 TRP A  50       2.989  -4.340  42.874  1.00 19.39           C  
ATOM    416  NE1 TRP A  50       2.784  -3.308  40.892  1.00 18.86           N  
ATOM    417  CE2 TRP A  50       2.659  -4.524  41.513  1.00 20.62           C  
ATOM    418  CE3 TRP A  50       2.940  -5.442  43.737  1.00 21.29           C  
ATOM    419  CZ2 TRP A  50       2.286  -5.769  40.993  1.00 19.30           C  
ATOM    420  CZ3 TRP A  50       2.568  -6.685  43.217  1.00 20.75           C  
ATOM    421  CH2 TRP A  50       2.245  -6.833  41.856  1.00 20.64           C  
ATOM    422  N   LYS A  51       6.404  -1.033  43.316  1.00 19.80           N  
ATOM    423  CA  LYS A  51       7.279  -0.673  42.215  1.00 21.13           C  
ATOM    424  C   LYS A  51       8.690  -1.208  42.430  1.00 21.37           C  
ATOM    425  O   LYS A  51       9.341  -1.671  41.496  1.00 20.50           O  
ATOM    426  CB  LYS A  51       7.310   0.848  42.040  1.00 23.36           C  
ATOM    427  CG  LYS A  51       8.063   1.301  40.805  1.00 29.29           C  
ATOM    428  CD  LYS A  51       7.922   2.795  40.595  1.00 33.19           C  
ATOM    429  CE  LYS A  51       8.761   3.268  39.418  1.00 35.36           C  
ATOM    430  NZ  LYS A  51       8.869   4.755  39.395  1.00 37.80           N  
ATOM    431  N   LYS A  52       9.142  -1.174  43.678  1.00 20.68           N  
ATOM    432  CA  LYS A  52      10.482  -1.623  44.023  1.00 21.29           C  
ATOM    433  C   LYS A  52      10.654  -3.135  44.136  1.00 20.29           C  
ATOM    434  O   LYS A  52      11.708  -3.668  43.769  1.00 19.89           O  
ATOM    435  CB  LYS A  52      10.901  -0.985  45.350  1.00 24.07           C  
ATOM    436  CG  LYS A  52      12.395  -0.787  45.506  1.00 29.38           C  
ATOM    437  CD  LYS A  52      12.907   0.243  44.511  1.00 31.70           C  
ATOM    438  CE  LYS A  52      12.131   1.551  44.632  1.00 35.14           C  
ATOM    439  NZ  LYS A  52      11.354   1.886  43.400  1.00 37.36           N  
ATOM    440  N   ALA A  53       9.632  -3.831  44.629  1.00 19.50           N  
ATOM    441  CA  ALA A  53       9.749  -5.275  44.829  1.00 18.97           C  
ATOM    442  C   ALA A  53       8.479  -6.103  44.620  1.00 20.68           C  
ATOM    443  O   ALA A  53       8.165  -6.984  45.426  1.00 19.52           O  
ATOM    444  CB  ALA A  53      10.307  -5.534  46.232  1.00 19.85           C  
ATOM    445  N   SER A  54       7.764  -5.841  43.533  1.00 21.14           N  
ATOM    446  CA  SER A  54       6.540  -6.579  43.246  1.00 23.09           C  
ATOM    447  C   SER A  54       6.776  -8.089  43.208  1.00 23.26           C  
ATOM    448  O   SER A  54       5.915  -8.870  43.614  1.00 24.02           O  
ATOM    449  CB  SER A  54       5.954  -6.118  41.910  1.00 23.37           C  
ATOM    450  OG  SER A  54       6.922  -6.200  40.879  1.00 25.19           O  
ATOM    451  N   ASP A  55       7.949  -8.494  42.731  1.00 23.12           N  
ATOM    452  CA  ASP A  55       8.285  -9.909  42.630  1.00 24.70           C  
ATOM    453  C   ASP A  55       8.271 -10.645  43.970  1.00 23.50           C  
ATOM    454  O   ASP A  55       8.188 -11.869  44.001  1.00 22.67           O  
ATOM    455  CB  ASP A  55       9.657 -10.070  41.966  1.00 28.01           C  
ATOM    456  CG  ASP A  55      10.008 -11.521  41.695  1.00 32.19           C  
ATOM    457  OD1 ASP A  55       9.161 -12.242  41.126  1.00 32.92           O  
ATOM    458  OD2 ASP A  55      11.133 -11.939  42.044  1.00 33.59           O  
ATOM    459  N   GLY A  56       8.346  -9.904  45.073  1.00 21.51           N  
ATOM    460  CA  GLY A  56       8.346 -10.535  46.384  1.00 18.80           C  
ATOM    461  C   GLY A  56       7.232 -10.028  47.281  1.00 18.40           C  
ATOM    462  O   GLY A  56       7.361 -10.008  48.504  1.00 18.00           O  
ATOM    463  N   PHE A  57       6.135  -9.612  46.660  1.00 17.87           N  
ATOM    464  CA  PHE A  57       4.977  -9.094  47.378  1.00 18.57           C  
ATOM    465  C   PHE A  57       4.037 -10.273  47.630  1.00 19.65           C  
ATOM    466  O   PHE A  57       3.330 -10.719  46.725  1.00 21.26           O  
ATOM    467  CB  PHE A  57       4.290  -8.029  46.515  1.00 22.40           C  
ATOM    468  CG  PHE A  57       3.595  -6.954  47.300  1.00 21.12           C  
ATOM    469  CD1 PHE A  57       4.057  -5.642  47.253  1.00 23.44           C  
ATOM    470  CD2 PHE A  57       2.466  -7.242  48.054  1.00 22.75           C  
ATOM    471  CE1 PHE A  57       3.396  -4.628  47.946  1.00 22.96           C  
ATOM    472  CE2 PHE A  57       1.799  -6.237  48.753  1.00 23.04           C  
ATOM    473  CZ  PHE A  57       2.266  -4.925  48.696  1.00 22.37           C  
ATOM    474  N   PHE A  58       4.047 -10.784  48.857  1.00 17.80           N  
ATOM    475  CA  PHE A  58       3.215 -11.924  49.234  1.00 18.39           C  
ATOM    476  C   PHE A  58       2.042 -11.503  50.103  1.00 18.90           C  
ATOM    477  O   PHE A  58       2.188 -10.667  50.990  1.00 17.31           O  
ATOM    478  CB  PHE A  58       4.048 -12.950  50.007  1.00 19.00           C  
ATOM    479  CG  PHE A  58       5.052 -13.666  49.164  1.00 19.21           C  
ATOM    480  CD1 PHE A  58       4.676 -14.765  48.401  1.00 19.67           C  
ATOM    481  CD2 PHE A  58       6.371 -13.226  49.107  1.00 18.58           C  
ATOM    482  CE1 PHE A  58       5.598 -15.415  47.590  1.00 19.03           C  
ATOM    483  CE2 PHE A  58       7.303 -13.867  48.299  1.00 20.03           C  
ATOM    484  CZ  PHE A  58       6.914 -14.965  47.537  1.00 19.10           C  
ATOM    485  N   VAL A  59       0.878 -12.090  49.849  1.00 19.05           N  
ATOM    486  CA  VAL A  59      -0.300 -11.780  50.644  1.00 20.10           C  
ATOM    487  C   VAL A  59      -0.872 -13.039  51.278  1.00 21.02           C  
ATOM    488  O   VAL A  59      -0.792 -14.128  50.705  1.00 21.51           O  
ATOM    489  CB  VAL A  59      -1.410 -11.112  49.798  1.00 20.77           C  
ATOM    490  CG1 VAL A  59      -0.938  -9.745  49.308  1.00 20.75           C  
ATOM    491  CG2 VAL A  59      -1.788 -12.010  48.628  1.00 21.45           C  
ATOM    492  N   ALA A  60      -1.418 -12.885  52.480  1.00 20.81           N  
ATOM    493  CA  ALA A  60      -2.047 -13.989  53.189  1.00 22.60           C  
ATOM    494  C   ALA A  60      -3.536 -13.774  52.965  1.00 24.85           C  
ATOM    495  O   ALA A  60      -4.040 -12.664  53.140  1.00 23.94           O  
ATOM    496  CB  ALA A  60      -1.723 -13.929  54.683  1.00 20.07           C  
ATOM    497  N   LYS A  61      -4.237 -14.826  52.563  1.00 27.02           N  
ATOM    498  CA  LYS A  61      -5.661 -14.700  52.313  1.00 30.11           C  
ATOM    499  C   LYS A  61      -6.496 -15.759  53.006  1.00 30.81           C  
ATOM    500  O   LYS A  61      -6.085 -16.910  53.157  1.00 31.58           O  
ATOM    501  CB  LYS A  61      -5.933 -14.740  50.806  1.00 30.12           C  
ATOM    502  CG  LYS A  61      -5.313 -13.584  50.035  1.00 30.99           C  
ATOM    503  CD  LYS A  61      -5.535 -13.719  48.537  1.00 33.21           C  
ATOM    504  CE  LYS A  61      -7.012 -13.682  48.176  1.00 35.18           C  
ATOM    505  NZ  LYS A  61      -7.222 -13.846  46.709  1.00 37.30           N  
ATOM    506  N   VAL A  62      -7.672 -15.337  53.452  1.00 32.04           N  
ATOM    507  CA  VAL A  62      -8.627 -16.220  54.099  1.00 32.90           C  
ATOM    508  C   VAL A  62      -9.889 -15.940  53.305  1.00 33.62           C  
ATOM    509  O   VAL A  62     -10.605 -14.978  53.577  1.00 33.88           O  
ATOM    510  CB  VAL A  62      -8.848 -15.846  55.574  1.00 33.52           C  
ATOM    511  CG1 VAL A  62      -9.873 -16.779  56.195  1.00 33.86           C  
ATOM    512  CG2 VAL A  62      -7.532 -15.924  56.330  1.00 33.61           C  
ATOM    513  N   GLY A  63     -10.138 -16.771  52.300  1.00 34.70           N  
ATOM    514  CA  GLY A  63     -11.291 -16.568  51.448  1.00 35.19           C  
ATOM    515  C   GLY A  63     -10.866 -15.669  50.303  1.00 36.45           C  
ATOM    516  O   GLY A  63      -9.816 -15.888  49.698  1.00 36.28           O  
ATOM    517  N   ASP A  64     -11.661 -14.645  50.014  1.00 36.98           N  
ATOM    518  CA  ASP A  64     -11.348 -13.722  48.928  1.00 38.57           C  
ATOM    519  C   ASP A  64     -10.723 -12.429  49.440  1.00 38.14           C  
ATOM    520  O   ASP A  64     -10.438 -11.521  48.657  1.00 38.14           O  
ATOM    521  CB  ASP A  64     -12.617 -13.394  48.138  1.00 40.71           C  
ATOM    522  CG  ASP A  64     -13.260 -14.626  47.530  1.00 43.70           C  
ATOM    523  OD1 ASP A  64     -12.646 -15.237  46.628  1.00 45.82           O  
ATOM    524  OD2 ASP A  64     -14.379 -14.987  47.958  1.00 45.12           O  
ATOM    525  N   LYS A  65     -10.503 -12.346  50.749  1.00 37.65           N  
ATOM    526  CA  LYS A  65      -9.931 -11.140  51.338  1.00 37.00           C  
ATOM    527  C   LYS A  65      -8.492 -11.305  51.796  1.00 35.04           C  
ATOM    528  O   LYS A  65      -8.104 -12.351  52.321  1.00 34.12           O  
ATOM    529  CB  LYS A  65     -10.773 -10.666  52.530  1.00 39.90           C  
ATOM    530  CG  LYS A  65     -10.736 -11.593  53.740  1.00 41.54           C  
ATOM    531  CD  LYS A  65     -11.542 -11.029  54.911  1.00 44.46           C  
ATOM    532  CE  LYS A  65     -10.664 -10.252  55.894  1.00 45.65           C  
ATOM    533  NZ  LYS A  65     -11.273  -8.954  56.317  1.00 46.68           N  
ATOM    534  N   ILE A  66      -7.708 -10.254  51.585  1.00 32.79           N  
ATOM    535  CA  ILE A  66      -6.317 -10.235  52.005  1.00 29.64           C  
ATOM    536  C   ILE A  66      -6.354  -9.858  53.481  1.00 28.23           C  
ATOM    537  O   ILE A  66      -7.015  -8.890  53.856  1.00 28.83           O  
ATOM    538  CB  ILE A  66      -5.523  -9.170  51.231  1.00 29.90           C  
ATOM    539  CG1 ILE A  66      -5.441  -9.561  49.754  1.00 30.51           C  
ATOM    540  CG2 ILE A  66      -4.143  -8.999  51.848  1.00 29.44           C  
ATOM    541  CD1 ILE A  66      -4.731  -8.538  48.887  1.00 30.31           C  
ATOM    542  N   VAL A  67      -5.663 -10.621  54.321  1.00 24.77           N  
ATOM    543  CA  VAL A  67      -5.661 -10.334  55.750  1.00 23.57           C  
ATOM    544  C   VAL A  67      -4.275  -9.965  56.253  1.00 21.40           C  
ATOM    545  O   VAL A  67      -4.098  -9.644  57.425  1.00 20.80           O  
ATOM    546  CB  VAL A  67      -6.180 -11.536  56.568  1.00 23.96           C  
ATOM    547  CG1 VAL A  67      -7.571 -11.921  56.091  1.00 23.76           C  
ATOM    548  CG2 VAL A  67      -5.225 -12.705  56.447  1.00 23.18           C  
ATOM    549  N   GLY A  68      -3.294 -10.017  55.360  1.00 18.89           N  
ATOM    550  CA  GLY A  68      -1.937  -9.679  55.743  1.00 16.91           C  
ATOM    551  C   GLY A  68      -1.017  -9.736  54.541  1.00 17.05           C  
ATOM    552  O   GLY A  68      -1.373 -10.312  53.515  1.00 16.43           O  
ATOM    553  N   PHE A  69       0.156  -9.123  54.650  1.00 16.01           N  
ATOM    554  CA  PHE A  69       1.101  -9.157  53.547  1.00 16.11           C  
ATOM    555  C   PHE A  69       2.513  -8.843  53.990  1.00 14.74           C  
ATOM    556  O   PHE A  69       2.739  -8.306  55.075  1.00 14.66           O  
ATOM    557  CB  PHE A  69       0.650  -8.214  52.408  1.00 16.53           C  
ATOM    558  CG  PHE A  69       0.744  -6.744  52.731  1.00 17.90           C  
ATOM    559  CD1 PHE A  69       1.879  -6.013  52.391  1.00 19.85           C  
ATOM    560  CD2 PHE A  69      -0.326  -6.075  53.325  1.00 20.11           C  
ATOM    561  CE1 PHE A  69       1.948  -4.636  52.629  1.00 18.92           C  
ATOM    562  CE2 PHE A  69      -0.270  -4.699  53.569  1.00 19.43           C  
ATOM    563  CZ  PHE A  69       0.868  -3.978  53.221  1.00 20.61           C  
ATOM    564  N   ILE A  70       3.468  -9.221  53.154  1.00 15.07           N  
ATOM    565  CA  ILE A  70       4.869  -8.971  53.443  1.00 15.01           C  
ATOM    566  C   ILE A  70       5.525  -8.637  52.113  1.00 14.23           C  
ATOM    567  O   ILE A  70       5.182  -9.215  51.079  1.00 15.74           O  
ATOM    568  CB  ILE A  70       5.532 -10.206  54.127  1.00 14.52           C  
ATOM    569  CG1 ILE A  70       6.953  -9.856  54.571  1.00 13.81           C  
ATOM    570  CG2 ILE A  70       5.518 -11.415  53.191  1.00 14.35           C  
ATOM    571  CD1 ILE A  70       7.564 -10.888  55.528  1.00 17.03           C  
ATOM    572  N   VAL A  71       6.440  -7.678  52.139  1.00 13.86           N  
ATOM    573  CA  VAL A  71       7.131  -7.237  50.934  1.00 15.05           C  
ATOM    574  C   VAL A  71       8.589  -7.642  51.035  1.00 13.77           C  
ATOM    575  O   VAL A  71       9.319  -7.129  51.877  1.00 14.01           O  
ATOM    576  CB  VAL A  71       7.023  -5.709  50.787  1.00 15.81           C  
ATOM    577  CG1 VAL A  71       7.753  -5.243  49.534  1.00 16.64           C  
ATOM    578  CG2 VAL A  71       5.551  -5.311  50.732  1.00 16.19           C  
ATOM    579  N   CYS A  72       8.991  -8.567  50.167  1.00 14.92           N  
ATOM    580  CA  CYS A  72      10.350  -9.105  50.152  1.00 15.58           C  
ATOM    581  C   CYS A  72      11.125  -8.614  48.933  1.00 15.86           C  
ATOM    582  O   CYS A  72      10.704  -8.827  47.799  1.00 18.18           O  
ATOM    583  CB  CYS A  72      10.276 -10.630  50.143  1.00 15.97           C  
ATOM    584  SG  CYS A  72       8.998 -11.284  51.256  1.00 19.64           S  
ATOM    585  N   ASP A  73      12.261  -7.971  49.175  1.00 15.13           N  
ATOM    586  CA  ASP A  73      13.088  -7.423  48.102  1.00 15.84           C  
ATOM    587  C   ASP A  73      14.385  -8.215  47.951  1.00 15.58           C  
ATOM    588  O   ASP A  73      15.256  -8.141  48.810  1.00 15.79           O  
ATOM    589  CB  ASP A  73      13.424  -5.963  48.418  1.00 16.54           C  
ATOM    590  CG  ASP A  73      13.926  -5.197  47.207  1.00 18.75           C  
ATOM    591  OD1 ASP A  73      14.508  -5.826  46.298  1.00 18.78           O  
ATOM    592  OD2 ASP A  73      13.744  -3.961  47.176  1.00 17.05           O  
ATOM    593  N   LYS A  74      14.521  -8.952  46.853  1.00 16.56           N  
ATOM    594  CA  LYS A  74      15.728  -9.746  46.625  1.00 17.23           C  
ATOM    595  C   LYS A  74      16.857  -8.888  46.060  1.00 17.86           C  
ATOM    596  O   LYS A  74      17.981  -9.361  45.897  1.00 18.33           O  
ATOM    597  CB  LYS A  74      15.431 -10.890  45.648  1.00 17.87           C  
ATOM    598  CG  LYS A  74      15.084 -10.424  44.239  1.00 22.14           C  
ATOM    599  CD  LYS A  74      14.859 -11.597  43.296  1.00 22.62           C  
ATOM    600  CE  LYS A  74      14.745 -11.135  41.845  1.00 25.92           C  
ATOM    601  NZ  LYS A  74      13.598 -10.205  41.620  1.00 28.58           N  
ATOM    602  N   ASP A  75      16.559  -7.624  45.776  1.00 17.06           N  
ATOM    603  CA  ASP A  75      17.549  -6.729  45.191  1.00 18.47           C  
ATOM    604  C   ASP A  75      17.697  -5.406  45.939  1.00 17.99           C  
ATOM    605  O   ASP A  75      17.492  -4.331  45.373  1.00 17.00           O  
ATOM    606  CB  ASP A  75      17.174  -6.483  43.725  1.00 20.51           C  
ATOM    607  CG  ASP A  75      18.169  -5.600  43.003  1.00 22.79           C  
ATOM    608  OD1 ASP A  75      19.387  -5.797  43.191  1.00 20.99           O  
ATOM    609  OD2 ASP A  75      17.726  -4.720  42.233  1.00 22.45           O  
ATOM    610  N   TRP A  76      18.078  -5.485  47.211  1.00 17.89           N  
ATOM    611  CA  TRP A  76      18.238  -4.286  48.022  1.00 17.91           C  
ATOM    612  C   TRP A  76      19.692  -3.981  48.362  1.00 18.06           C  
ATOM    613  O   TRP A  76      20.411  -4.822  48.900  1.00 21.31           O  
ATOM    614  CB  TRP A  76      17.441  -4.425  49.320  1.00 16.86           C  
ATOM    615  CG  TRP A  76      17.378  -3.156  50.093  1.00 17.55           C  
ATOM    616  CD1 TRP A  76      18.015  -2.873  51.268  1.00 17.18           C  
ATOM    617  CD2 TRP A  76      16.651  -1.976  49.732  1.00 16.68           C  
ATOM    618  NE1 TRP A  76      17.728  -1.586  51.662  1.00 17.82           N  
ATOM    619  CE2 TRP A  76      16.894  -1.014  50.735  1.00 18.83           C  
ATOM    620  CE3 TRP A  76      15.820  -1.638  48.655  1.00 19.34           C  
ATOM    621  CZ2 TRP A  76      16.331   0.269  50.698  1.00 19.57           C  
ATOM    622  CZ3 TRP A  76      15.261  -0.360  48.617  1.00 18.72           C  
ATOM    623  CH2 TRP A  76      15.523   0.573  49.633  1.00 18.14           C  
ATOM    624  N   PHE A  77      20.135  -2.768  48.060  1.00 16.52           N  
ATOM    625  CA  PHE A  77      21.505  -2.436  48.383  1.00 17.01           C  
ATOM    626  C   PHE A  77      21.582  -1.829  49.775  1.00 16.50           C  
ATOM    627  O   PHE A  77      20.849  -0.898  50.104  1.00 16.88           O  
ATOM    628  CB  PHE A  77      22.101  -1.464  47.374  1.00 18.92           C  
ATOM    629  CG  PHE A  77      23.587  -1.338  47.497  1.00 21.65           C  
ATOM    630  CD1 PHE A  77      24.428  -2.218  46.823  1.00 23.80           C  
ATOM    631  CD2 PHE A  77      24.145  -0.399  48.353  1.00 23.80           C  
ATOM    632  CE1 PHE A  77      25.806  -2.165  47.008  1.00 24.80           C  
ATOM    633  CE2 PHE A  77      25.526  -0.341  48.545  1.00 25.07           C  
ATOM    634  CZ  PHE A  77      26.352  -1.226  47.871  1.00 23.60           C  
ATOM    635  N   SER A  78      22.473  -2.373  50.595  1.00 15.50           N  
ATOM    636  CA  SER A  78      22.652  -1.878  51.954  1.00 16.72           C  
ATOM    637  C   SER A  78      24.016  -1.226  52.109  1.00 17.01           C  
ATOM    638  O   SER A  78      25.045  -1.862  51.887  1.00 18.43           O  
ATOM    639  CB  SER A  78      22.527  -3.022  52.959  1.00 16.25           C  
ATOM    640  OG  SER A  78      22.968  -2.596  54.239  1.00 16.93           O  
ATOM    641  N   LYS A  79      24.015   0.044  52.499  1.00 18.20           N  
ATOM    642  CA  LYS A  79      25.256   0.783  52.697  1.00 20.27           C  
ATOM    643  C   LYS A  79      25.996   0.214  53.900  1.00 21.45           C  
ATOM    644  O   LYS A  79      27.213   0.340  54.006  1.00 21.02           O  
ATOM    645  CB  LYS A  79      24.954   2.266  52.925  1.00 23.15           C  
ATOM    646  CG  LYS A  79      24.156   2.913  51.797  1.00 25.30           C  
ATOM    647  CD  LYS A  79      23.857   4.380  52.089  1.00 28.87           C  
ATOM    648  CE  LYS A  79      25.126   5.214  52.118  1.00 29.09           C  
ATOM    649  NZ  LYS A  79      25.796   5.195  50.793  1.00 28.12           N  
ATOM    650  N   TYR A  80      25.253  -0.423  54.801  1.00 21.13           N  
ATOM    651  CA  TYR A  80      25.845  -1.011  55.996  1.00 22.77           C  
ATOM    652  C   TYR A  80      26.573  -2.315  55.672  1.00 23.61           C  
ATOM    653  O   TYR A  80      27.639  -2.587  56.221  1.00 24.02           O  
ATOM    654  CB  TYR A  80      24.754  -1.249  57.038  1.00 22.66           C  
ATOM    655  CG  TYR A  80      24.009   0.012  57.391  1.00 24.40           C  
ATOM    656  CD1 TYR A  80      24.580   0.976  58.223  1.00 23.94           C  
ATOM    657  CD2 TYR A  80      22.747   0.265  56.855  1.00 24.17           C  
ATOM    658  CE1 TYR A  80      23.909   2.164  58.514  1.00 26.87           C  
ATOM    659  CE2 TYR A  80      22.072   1.441  57.136  1.00 26.82           C  
ATOM    660  CZ  TYR A  80      22.654   2.387  57.964  1.00 26.46           C  
ATOM    661  OH  TYR A  80      21.978   3.549  58.240  1.00 30.04           O  
ATOM    662  N   GLU A  81      26.005  -3.113  54.773  1.00 22.79           N  
ATOM    663  CA  GLU A  81      26.626  -4.375  54.375  1.00 24.00           C  
ATOM    664  C   GLU A  81      27.511  -4.132  53.155  1.00 24.65           C  
ATOM    665  O   GLU A  81      28.273  -5.006  52.736  1.00 25.20           O  
ATOM    666  CB  GLU A  81      25.560  -5.418  54.030  1.00 23.32           C  
ATOM    667  CG  GLU A  81      24.581  -5.719  55.154  1.00 23.93           C  
ATOM    668  CD  GLU A  81      25.267  -6.200  56.419  1.00 25.65           C  
ATOM    669  OE1 GLU A  81      26.097  -7.126  56.331  1.00 26.11           O  
ATOM    670  OE2 GLU A  81      24.971  -5.657  57.501  1.00 25.49           O  
ATOM    671  N   GLY A  82      27.390  -2.939  52.581  1.00 24.98           N  
ATOM    672  CA  GLY A  82      28.183  -2.582  51.419  1.00 24.08           C  
ATOM    673  C   GLY A  82      27.943  -3.438  50.191  1.00 24.69           C  
ATOM    674  O   GLY A  82      28.827  -3.558  49.342  1.00 25.52           O  
ATOM    675  N   ARG A  83      26.756  -4.029  50.080  1.00 23.19           N  
ATOM    676  CA  ARG A  83      26.441  -4.877  48.937  1.00 22.12           C  
ATOM    677  C   ARG A  83      24.949  -5.177  48.848  1.00 21.79           C  
ATOM    678  O   ARG A  83      24.174  -4.777  49.715  1.00 21.17           O  
ATOM    679  CB  ARG A  83      27.223  -6.189  49.038  1.00 24.75           C  
ATOM    680  CG  ARG A  83      26.908  -6.985  50.292  1.00 24.63           C  
ATOM    681  CD  ARG A  83      27.972  -8.033  50.571  1.00 26.73           C  
ATOM    682  NE  ARG A  83      27.689  -8.761  51.807  1.00 26.89           N  
ATOM    683  CZ  ARG A  83      26.870  -9.804  51.883  1.00 26.91           C  
ATOM    684  NH1 ARG A  83      26.263 -10.241  50.792  1.00 26.83           N  
ATOM    685  NH2 ARG A  83      26.656 -10.411  53.043  1.00 27.34           N  
ATOM    686  N   ILE A  84      24.550  -5.874  47.791  1.00 21.45           N  
ATOM    687  CA  ILE A  84      23.153  -6.238  47.597  1.00 20.54           C  
ATOM    688  C   ILE A  84      22.750  -7.289  48.624  1.00 20.19           C  
ATOM    689  O   ILE A  84      23.463  -8.270  48.831  1.00 20.24           O  
ATOM    690  CB  ILE A  84      22.909  -6.826  46.182  1.00 21.36           C  
ATOM    691  CG1 ILE A  84      23.158  -5.754  45.120  1.00 23.91           C  
ATOM    692  CG2 ILE A  84      21.491  -7.388  46.081  1.00 19.48           C  
ATOM    693  CD1 ILE A  84      22.271  -4.543  45.254  1.00 26.44           C  
ATOM    694  N   VAL A  85      21.607  -7.076  49.270  1.00 18.09           N  
ATOM    695  CA  VAL A  85      21.103  -8.021  50.262  1.00 17.84           C  
ATOM    696  C   VAL A  85      19.598  -8.146  50.090  1.00 17.15           C  
ATOM    697  O   VAL A  85      18.998  -7.464  49.255  1.00 16.06           O  
ATOM    698  CB  VAL A  85      21.385  -7.545  51.719  1.00 18.95           C  
ATOM    699  CG1 VAL A  85      22.876  -7.386  51.945  1.00 21.22           C  
ATOM    700  CG2 VAL A  85      20.651  -6.236  51.996  1.00 21.26           C  
ATOM    701  N   GLY A  86      18.991  -9.036  50.868  1.00 16.18           N  
ATOM    702  CA  GLY A  86      17.554  -9.192  50.804  1.00 15.39           C  
ATOM    703  C   GLY A  86      16.998  -8.231  51.832  1.00 14.85           C  
ATOM    704  O   GLY A  86      17.690  -7.878  52.787  1.00 15.14           O  
ATOM    705  N   ALA A  87      15.766  -7.781  51.638  1.00 14.79           N  
ATOM    706  CA  ALA A  87      15.168  -6.858  52.587  1.00 15.30           C  
ATOM    707  C   ALA A  87      13.684  -7.106  52.726  1.00 14.95           C  
ATOM    708  O   ALA A  87      13.054  -7.640  51.821  1.00 15.15           O  
ATOM    709  CB  ALA A  87      15.405  -5.411  52.135  1.00 17.16           C  
ATOM    710  N   ILE A  88      13.140  -6.739  53.883  1.00 14.50           N  
ATOM    711  CA  ILE A  88      11.712  -6.836  54.143  1.00 14.78           C  
ATOM    712  C   ILE A  88      11.310  -5.371  54.269  1.00 14.77           C  
ATOM    713  O   ILE A  88      11.730  -4.700  55.208  1.00 15.51           O  
ATOM    714  CB  ILE A  88      11.401  -7.568  55.474  1.00 15.18           C  
ATOM    715  CG1 ILE A  88      11.955  -8.997  55.433  1.00 15.08           C  
ATOM    716  CG2 ILE A  88       9.888  -7.592  55.704  1.00 16.58           C  
ATOM    717  CD1 ILE A  88      11.704  -9.820  56.703  1.00 15.72           C  
ATOM    718  N   HIS A  89      10.525  -4.871  53.317  1.00 14.89           N  
ATOM    719  CA  HIS A  89      10.107  -3.471  53.337  1.00 14.66           C  
ATOM    720  C   HIS A  89       8.861  -3.212  54.166  1.00 14.79           C  
ATOM    721  O   HIS A  89       8.697  -2.128  54.720  1.00 16.02           O  
ATOM    722  CB  HIS A  89       9.855  -2.965  51.916  1.00 14.12           C  
ATOM    723  CG  HIS A  89      11.093  -2.856  51.085  1.00 15.59           C  
ATOM    724  ND1 HIS A  89      12.199  -2.145  51.492  1.00 17.93           N  
ATOM    725  CD2 HIS A  89      11.386  -3.342  49.854  1.00 15.87           C  
ATOM    726  CE1 HIS A  89      13.123  -2.195  50.547  1.00 16.73           C  
ATOM    727  NE2 HIS A  89      12.655  -2.915  49.544  1.00 16.49           N  
ATOM    728  N   GLU A  90       7.979  -4.199  54.229  1.00 14.89           N  
ATOM    729  CA  GLU A  90       6.747  -4.059  54.989  1.00 15.42           C  
ATOM    730  C   GLU A  90       6.266  -5.439  55.409  1.00 15.24           C  
ATOM    731  O   GLU A  90       6.560  -6.430  54.751  1.00 13.48           O  
ATOM    732  CB  GLU A  90       5.680  -3.353  54.151  1.00 16.26           C  
ATOM    733  CG  GLU A  90       4.477  -2.946  54.981  1.00 18.02           C  
ATOM    734  CD  GLU A  90       4.890  -2.241  56.257  1.00 18.77           C  
ATOM    735  OE1 GLU A  90       5.298  -1.063  56.181  1.00 19.53           O  
ATOM    736  OE2 GLU A  90       4.827  -2.871  57.336  1.00 19.19           O  
ATOM    737  N   PHE A  91       5.518  -5.491  56.503  1.00 14.97           N  
ATOM    738  CA  PHE A  91       5.041  -6.759  57.038  1.00 14.22           C  
ATOM    739  C   PHE A  91       3.920  -6.418  58.009  1.00 15.47           C  
ATOM    740  O   PHE A  91       4.164  -5.836  59.063  1.00 16.12           O  
ATOM    741  CB  PHE A  91       6.215  -7.431  57.755  1.00 14.43           C  
ATOM    742  CG  PHE A  91       5.883  -8.733  58.420  1.00 14.16           C  
ATOM    743  CD1 PHE A  91       4.873  -9.555  57.937  1.00 12.67           C  
ATOM    744  CD2 PHE A  91       6.646  -9.168  59.501  1.00 15.89           C  
ATOM    745  CE1 PHE A  91       4.628 -10.798  58.519  1.00 11.71           C  
ATOM    746  CE2 PHE A  91       6.409 -10.411  60.091  1.00 16.23           C  
ATOM    747  CZ  PHE A  91       5.399 -11.225  59.597  1.00 15.67           C  
ATOM    748  N   VAL A  92       2.690  -6.770  57.656  1.00 14.81           N  
ATOM    749  CA  VAL A  92       1.575  -6.433  58.526  1.00 15.74           C  
ATOM    750  C   VAL A  92       0.379  -7.355  58.346  1.00 15.68           C  
ATOM    751  O   VAL A  92       0.094  -7.830  57.247  1.00 15.87           O  
ATOM    752  CB  VAL A  92       1.140  -4.961  58.291  1.00 16.15           C  
ATOM    753  CG1 VAL A  92       0.752  -4.761  56.833  1.00 18.58           C  
ATOM    754  CG2 VAL A  92      -0.018  -4.589  59.210  1.00 17.20           C  
ATOM    755  N   VAL A  93      -0.314  -7.604  59.447  1.00 16.48           N  
ATOM    756  CA  VAL A  93      -1.488  -8.460  59.437  1.00 18.19           C  
ATOM    757  C   VAL A  93      -2.652  -7.711  60.074  1.00 17.86           C  
ATOM    758  O   VAL A  93      -2.469  -7.008  61.065  1.00 18.14           O  
ATOM    759  CB  VAL A  93      -1.224  -9.756  60.227  1.00 17.79           C  
ATOM    760  CG1 VAL A  93      -2.509 -10.556  60.364  1.00 19.14           C  
ATOM    761  CG2 VAL A  93      -0.157 -10.582  59.522  1.00 17.30           C  
ATOM    762  N   ASP A  94      -3.837  -7.849  59.488  1.00 19.34           N  
ATOM    763  CA  ASP A  94      -5.039  -7.208  60.013  1.00 23.04           C  
ATOM    764  C   ASP A  94      -5.120  -7.476  61.512  1.00 23.75           C  
ATOM    765  O   ASP A  94      -4.923  -8.604  61.958  1.00 23.04           O  
ATOM    766  CB  ASP A  94      -6.273  -7.773  59.314  1.00 25.54           C  
ATOM    767  CG  ASP A  94      -7.564  -7.151  59.809  1.00 29.27           C  
ATOM    768  OD1 ASP A  94      -7.899  -7.330  60.998  1.00 32.08           O  
ATOM    769  OD2 ASP A  94      -8.239  -6.481  59.006  1.00 32.49           O  
ATOM    770  N   LYS A  95      -5.403  -6.435  62.288  1.00 24.72           N  
ATOM    771  CA  LYS A  95      -5.482  -6.561  63.739  1.00 25.91           C  
ATOM    772  C   LYS A  95      -6.367  -7.723  64.185  1.00 26.53           C  
ATOM    773  O   LYS A  95      -6.013  -8.468  65.099  1.00 24.93           O  
ATOM    774  CB  LYS A  95      -5.998  -5.253  64.346  1.00 27.62           C  
ATOM    775  CG  LYS A  95      -6.109  -5.251  65.866  1.00 31.31           C  
ATOM    776  CD  LYS A  95      -4.783  -5.580  66.548  1.00 34.01           C  
ATOM    777  CE  LYS A  95      -3.694  -4.562  66.225  1.00 35.92           C  
ATOM    778  NZ  LYS A  95      -4.037  -3.184  66.680  1.00 37.92           N  
ATOM    779  N   LYS A  96      -7.514  -7.873  63.533  1.00 26.79           N  
ATOM    780  CA  LYS A  96      -8.455  -8.933  63.873  1.00 28.74           C  
ATOM    781  C   LYS A  96      -7.915 -10.329  63.580  1.00 29.39           C  
ATOM    782  O   LYS A  96      -8.401 -11.316  64.135  1.00 29.84           O  
ATOM    783  CB  LYS A  96      -9.764  -8.730  63.112  1.00 30.06           C  
ATOM    784  CG  LYS A  96     -10.456  -7.412  63.417  1.00 32.41           C  
ATOM    785  CD  LYS A  96     -11.775  -7.297  62.674  1.00 34.71           C  
ATOM    786  CE  LYS A  96     -12.492  -6.001  63.019  1.00 35.92           C  
ATOM    787  NZ  LYS A  96     -13.840  -5.930  62.383  1.00 38.95           N  
ATOM    788  N   PHE A  97      -6.911 -10.410  62.715  1.00 27.64           N  
ATOM    789  CA  PHE A  97      -6.330 -11.697  62.347  1.00 27.28           C  
ATOM    790  C   PHE A  97      -4.963 -11.967  62.955  1.00 26.56           C  
ATOM    791  O   PHE A  97      -4.343 -12.983  62.659  1.00 26.79           O  
ATOM    792  CB  PHE A  97      -6.245 -11.798  60.826  1.00 27.73           C  
ATOM    793  CG  PHE A  97      -7.577 -11.965  60.162  1.00 28.94           C  
ATOM    794  CD1 PHE A  97      -8.075 -13.233  59.889  1.00 29.16           C  
ATOM    795  CD2 PHE A  97      -8.349 -10.856  59.842  1.00 29.13           C  
ATOM    796  CE1 PHE A  97      -9.328 -13.396  59.304  1.00 29.45           C  
ATOM    797  CE2 PHE A  97      -9.605 -11.004  59.257  1.00 30.69           C  
ATOM    798  CZ  PHE A  97     -10.096 -12.276  58.989  1.00 30.31           C  
ATOM    799  N   GLN A  98      -4.495 -11.061  63.807  1.00 26.23           N  
ATOM    800  CA  GLN A  98      -3.196 -11.226  64.447  1.00 26.13           C  
ATOM    801  C   GLN A  98      -3.238 -12.289  65.540  1.00 27.77           C  
ATOM    802  O   GLN A  98      -4.309 -12.639  66.041  1.00 28.57           O  
ATOM    803  CB  GLN A  98      -2.722  -9.894  65.034  1.00 25.60           C  
ATOM    804  CG  GLN A  98      -2.195  -8.909  63.995  1.00 25.31           C  
ATOM    805  CD  GLN A  98      -1.882  -7.551  64.584  1.00 24.37           C  
ATOM    806  OE1 GLN A  98      -1.703  -7.415  65.795  1.00 26.18           O  
ATOM    807  NE2 GLN A  98      -1.801  -6.534  63.730  1.00 22.22           N  
ATOM    808  N   GLY A  99      -2.064 -12.802  65.898  1.00 27.65           N  
ATOM    809  CA  GLY A  99      -1.974 -13.812  66.937  1.00 28.94           C  
ATOM    810  C   GLY A  99      -2.503 -15.179  66.544  1.00 28.92           C  
ATOM    811  O   GLY A  99      -2.724 -16.030  67.408  1.00 30.00           O  
ATOM    812  N   LYS A 100      -2.703 -15.399  65.248  1.00 28.04           N  
ATOM    813  CA  LYS A 100      -3.216 -16.675  64.756  1.00 27.51           C  
ATOM    814  C   LYS A 100      -2.212 -17.413  63.867  1.00 26.21           C  
ATOM    815  O   LYS A 100      -2.569 -18.361  63.169  1.00 26.58           O  
ATOM    816  CB  LYS A 100      -4.517 -16.450  63.985  1.00 29.34           C  
ATOM    817  CG  LYS A 100      -5.603 -15.754  64.794  1.00 32.25           C  
ATOM    818  CD  LYS A 100      -6.843 -15.509  63.954  1.00 34.20           C  
ATOM    819  CE  LYS A 100      -7.898 -14.736  64.730  1.00 36.72           C  
ATOM    820  NZ  LYS A 100      -8.336 -15.459  65.958  1.00 38.14           N  
ATOM    821  N   GLY A 101      -0.960 -16.970  63.887  1.00 23.89           N  
ATOM    822  CA  GLY A 101       0.065 -17.624  63.090  1.00 22.60           C  
ATOM    823  C   GLY A 101       0.176 -17.181  61.640  1.00 21.71           C  
ATOM    824  O   GLY A 101       0.968 -17.736  60.882  1.00 20.83           O  
ATOM    825  N   ILE A 102      -0.604 -16.184  61.243  1.00 21.07           N  
ATOM    826  CA  ILE A 102      -0.548 -15.717  59.863  1.00 19.69           C  
ATOM    827  C   ILE A 102       0.783 -15.022  59.576  1.00 18.84           C  
ATOM    828  O   ILE A 102       1.400 -15.265  58.538  1.00 16.73           O  
ATOM    829  CB  ILE A 102      -1.719 -14.765  59.550  1.00 21.21           C  
ATOM    830  CG1 ILE A 102      -3.037 -15.544  59.614  1.00 21.46           C  
ATOM    831  CG2 ILE A 102      -1.541 -14.147  58.171  1.00 21.12           C  
ATOM    832  CD1 ILE A 102      -4.275 -14.687  59.468  1.00 22.58           C  
ATOM    833  N   GLY A 103       1.226 -14.173  60.499  1.00 17.58           N  
ATOM    834  CA  GLY A 103       2.491 -13.479  60.316  1.00 17.71           C  
ATOM    835  C   GLY A 103       3.629 -14.468  60.165  1.00 16.84           C  
ATOM    836  O   GLY A 103       4.508 -14.306  59.318  1.00 14.87           O  
ATOM    837  N   ARG A 104       3.606 -15.508  60.995  1.00 17.20           N  
ATOM    838  CA  ARG A 104       4.628 -16.539  60.951  1.00 17.33           C  
ATOM    839  C   ARG A 104       4.681 -17.162  59.557  1.00 16.45           C  
ATOM    840  O   ARG A 104       5.759 -17.375  59.012  1.00 16.67           O  
ATOM    841  CB  ARG A 104       4.320 -17.618  61.993  1.00 19.45           C  
ATOM    842  CG  ARG A 104       5.354 -18.721  62.098  1.00 21.82           C  
ATOM    843  CD  ARG A 104       4.871 -19.811  63.050  1.00 22.95           C  
ATOM    844  NE  ARG A 104       4.732 -19.340  64.427  1.00 25.81           N  
ATOM    845  CZ  ARG A 104       5.749 -19.155  65.264  1.00 25.74           C  
ATOM    846  NH1 ARG A 104       6.992 -19.399  64.870  1.00 27.49           N  
ATOM    847  NH2 ARG A 104       5.523 -18.735  66.499  1.00 29.31           N  
ATOM    848  N   LYS A 105       3.517 -17.453  58.981  1.00 16.17           N  
ATOM    849  CA  LYS A 105       3.464 -18.057  57.649  1.00 17.20           C  
ATOM    850  C   LYS A 105       4.056 -17.133  56.594  1.00 17.13           C  
ATOM    851  O   LYS A 105       4.784 -17.570  55.699  1.00 16.44           O  
ATOM    852  CB  LYS A 105       2.026 -18.406  57.271  1.00 17.78           C  
ATOM    853  CG  LYS A 105       1.376 -19.431  58.189  1.00 22.44           C  
ATOM    854  CD  LYS A 105      -0.038 -19.764  57.731  1.00 25.70           C  
ATOM    855  CE  LYS A 105      -0.033 -20.538  56.423  1.00 26.54           C  
ATOM    856  NZ  LYS A 105       0.625 -21.866  56.582  1.00 27.75           N  
ATOM    857  N   LEU A 106       3.742 -15.850  56.707  1.00 15.46           N  
ATOM    858  CA  LEU A 106       4.261 -14.876  55.762  1.00 16.07           C  
ATOM    859  C   LEU A 106       5.773 -14.743  55.899  1.00 15.93           C  
ATOM    860  O   LEU A 106       6.476 -14.643  54.898  1.00 15.47           O  
ATOM    861  CB  LEU A 106       3.582 -13.517  55.976  1.00 15.33           C  
ATOM    862  CG  LEU A 106       2.153 -13.388  55.431  1.00 16.59           C  
ATOM    863  CD1 LEU A 106       1.519 -12.112  55.954  1.00 15.77           C  
ATOM    864  CD2 LEU A 106       2.173 -13.390  53.900  1.00 16.87           C  
ATOM    865  N   LEU A 107       6.276 -14.754  57.135  1.00 15.23           N  
ATOM    866  CA  LEU A 107       7.714 -14.618  57.355  1.00 14.75           C  
ATOM    867  C   LEU A 107       8.478 -15.824  56.820  1.00 15.36           C  
ATOM    868  O   LEU A 107       9.530 -15.676  56.196  1.00 15.62           O  
ATOM    869  CB  LEU A 107       8.012 -14.402  58.844  1.00 15.74           C  
ATOM    870  CG  LEU A 107       9.461 -14.075  59.232  1.00 17.51           C  
ATOM    871  CD1 LEU A 107       9.976 -12.892  58.411  1.00 17.02           C  
ATOM    872  CD2 LEU A 107       9.525 -13.755  60.720  1.00 17.67           C  
ATOM    873  N   ILE A 108       7.948 -17.020  57.059  1.00 13.74           N  
ATOM    874  CA  ILE A 108       8.582 -18.236  56.563  1.00 14.52           C  
ATOM    875  C   ILE A 108       8.620 -18.192  55.032  1.00 13.96           C  
ATOM    876  O   ILE A 108       9.623 -18.548  54.416  1.00 14.52           O  
ATOM    877  CB  ILE A 108       7.810 -19.489  57.040  1.00 14.19           C  
ATOM    878  CG1 ILE A 108       8.027 -19.666  58.549  1.00 14.62           C  
ATOM    879  CG2 ILE A 108       8.268 -20.726  56.268  1.00 14.28           C  
ATOM    880  CD1 ILE A 108       7.194 -20.783  59.179  1.00 16.20           C  
ATOM    881  N   THR A 109       7.524 -17.740  54.429  1.00 14.35           N  
ATOM    882  CA  THR A 109       7.442 -17.625  52.979  1.00 16.00           C  
ATOM    883  C   THR A 109       8.516 -16.655  52.501  1.00 15.65           C  
ATOM    884  O   THR A 109       9.195 -16.900  51.502  1.00 16.04           O  
ATOM    885  CB  THR A 109       6.061 -17.101  52.547  1.00 16.62           C  
ATOM    886  OG1 THR A 109       5.056 -18.046  52.930  1.00 17.43           O  
ATOM    887  CG2 THR A 109       6.005 -16.899  51.035  1.00 18.11           C  
ATOM    888  N   CYS A 110       8.659 -15.550  53.224  1.00 14.31           N  
ATOM    889  CA  CYS A 110       9.655 -14.537  52.895  1.00 16.43           C  
ATOM    890  C   CYS A 110      11.076 -15.091  52.975  1.00 16.42           C  
ATOM    891  O   CYS A 110      11.896 -14.862  52.083  1.00 17.04           O  
ATOM    892  CB  CYS A 110       9.524 -13.346  53.846  1.00 16.69           C  
ATOM    893  SG  CYS A 110      10.897 -12.168  53.746  1.00 18.31           S  
ATOM    894  N   LEU A 111      11.371 -15.821  54.047  1.00 16.98           N  
ATOM    895  CA  LEU A 111      12.703 -16.386  54.222  1.00 18.63           C  
ATOM    896  C   LEU A 111      13.036 -17.388  53.124  1.00 19.30           C  
ATOM    897  O   LEU A 111      14.167 -17.424  52.634  1.00 19.00           O  
ATOM    898  CB  LEU A 111      12.831 -17.045  55.600  1.00 19.92           C  
ATOM    899  CG  LEU A 111      12.743 -16.086  56.793  1.00 22.98           C  
ATOM    900  CD1 LEU A 111      13.107 -16.820  58.074  1.00 23.18           C  
ATOM    901  CD2 LEU A 111      13.688 -14.920  56.589  1.00 24.21           C  
ATOM    902  N   ASP A 112      12.047 -18.188  52.734  1.00 18.48           N  
ATOM    903  CA  ASP A 112      12.232 -19.181  51.683  1.00 19.42           C  
ATOM    904  C   ASP A 112      12.448 -18.492  50.337  1.00 18.61           C  
ATOM    905  O   ASP A 112      13.310 -18.888  49.556  1.00 19.12           O  
ATOM    906  CB  ASP A 112      11.008 -20.097  51.602  1.00 20.67           C  
ATOM    907  CG  ASP A 112      11.123 -21.124  50.496  1.00 22.58           C  
ATOM    908  OD1 ASP A 112      11.942 -22.055  50.626  1.00 23.40           O  
ATOM    909  OD2 ASP A 112      10.399 -20.991  49.488  1.00 23.98           O  
ATOM    910  N   PHE A 113      11.661 -17.456  50.066  1.00 19.15           N  
ATOM    911  CA  PHE A 113      11.791 -16.716  48.814  1.00 18.01           C  
ATOM    912  C   PHE A 113      13.161 -16.041  48.700  1.00 18.71           C  
ATOM    913  O   PHE A 113      13.886 -16.255  47.730  1.00 19.03           O  
ATOM    914  CB  PHE A 113      10.692 -15.655  48.715  1.00 18.43           C  
ATOM    915  CG  PHE A 113      10.820 -14.755  47.516  1.00 19.91           C  
ATOM    916  CD1 PHE A 113      10.563 -15.236  46.236  1.00 19.68           C  
ATOM    917  CD2 PHE A 113      11.211 -13.426  47.666  1.00 19.92           C  
ATOM    918  CE1 PHE A 113      10.693 -14.409  45.122  1.00 20.53           C  
ATOM    919  CE2 PHE A 113      11.343 -12.588  46.555  1.00 19.95           C  
ATOM    920  CZ  PHE A 113      11.085 -13.081  45.283  1.00 19.70           C  
ATOM    921  N   LEU A 114      13.515 -15.228  49.692  1.00 16.58           N  
ATOM    922  CA  LEU A 114      14.786 -14.513  49.672  1.00 17.58           C  
ATOM    923  C   LEU A 114      16.008 -15.423  49.767  1.00 19.36           C  
ATOM    924  O   LEU A 114      17.086 -15.081  49.271  1.00 18.97           O  
ATOM    925  CB  LEU A 114      14.822 -13.475  50.798  1.00 17.28           C  
ATOM    926  CG  LEU A 114      13.815 -12.327  50.661  1.00 16.35           C  
ATOM    927  CD1 LEU A 114      13.907 -11.394  51.873  1.00 16.32           C  
ATOM    928  CD2 LEU A 114      14.098 -11.558  49.375  1.00 15.11           C  
ATOM    929  N   GLY A 115      15.831 -16.579  50.400  1.00 20.28           N  
ATOM    930  CA  GLY A 115      16.923 -17.525  50.557  1.00 21.71           C  
ATOM    931  C   GLY A 115      17.520 -18.020  49.253  1.00 22.10           C  
ATOM    932  O   GLY A 115      18.657 -18.488  49.228  1.00 23.31           O  
ATOM    933  N   LYS A 116      16.765 -17.924  48.165  1.00 22.45           N  
ATOM    934  CA  LYS A 116      17.264 -18.371  46.875  1.00 24.22           C  
ATOM    935  C   LYS A 116      18.190 -17.339  46.249  1.00 24.18           C  
ATOM    936  O   LYS A 116      19.003 -17.667  45.383  1.00 25.34           O  
ATOM    937  CB  LYS A 116      16.102 -18.619  45.911  1.00 26.00           C  
ATOM    938  CG  LYS A 116      16.555 -19.061  44.527  1.00 31.06           C  
ATOM    939  CD  LYS A 116      15.404 -19.106  43.542  1.00 33.08           C  
ATOM    940  CE  LYS A 116      15.788 -19.873  42.282  1.00 35.83           C  
ATOM    941  NZ  LYS A 116      16.958 -19.282  41.575  1.00 38.04           N  
ATOM    942  N   TYR A 117      18.073 -16.097  46.703  1.00 23.16           N  
ATOM    943  CA  TYR A 117      18.859 -15.001  46.147  1.00 22.36           C  
ATOM    944  C   TYR A 117      19.897 -14.352  47.052  1.00 22.54           C  
ATOM    945  O   TYR A 117      20.973 -13.967  46.593  1.00 23.61           O  
ATOM    946  CB  TYR A 117      17.908 -13.905  45.666  1.00 21.77           C  
ATOM    947  CG  TYR A 117      16.777 -14.399  44.797  1.00 20.20           C  
ATOM    948  CD1 TYR A 117      16.981 -14.694  43.452  1.00 21.67           C  
ATOM    949  CD2 TYR A 117      15.495 -14.566  45.322  1.00 21.77           C  
ATOM    950  CE1 TYR A 117      15.932 -15.138  42.648  1.00 22.78           C  
ATOM    951  CE2 TYR A 117      14.444 -15.009  44.530  1.00 22.22           C  
ATOM    952  CZ  TYR A 117      14.668 -15.292  43.195  1.00 23.88           C  
ATOM    953  OH  TYR A 117      13.624 -15.715  42.405  1.00 26.40           O  
ATOM    954  N   ASN A 118      19.577 -14.216  48.333  1.00 22.93           N  
ATOM    955  CA  ASN A 118      20.482 -13.539  49.256  1.00 21.84           C  
ATOM    956  C   ASN A 118      20.938 -14.371  50.444  1.00 22.72           C  
ATOM    957  O   ASN A 118      20.189 -15.203  50.948  1.00 23.62           O  
ATOM    958  CB  ASN A 118      19.805 -12.266  49.777  1.00 21.74           C  
ATOM    959  CG  ASN A 118      18.923 -11.599  48.732  1.00 20.75           C  
ATOM    960  OD1 ASN A 118      17.691 -11.682  48.794  1.00 20.36           O  
ATOM    961  ND2 ASN A 118      19.549 -10.942  47.762  1.00 19.80           N  
ATOM    962  N   ASP A 119      22.167 -14.133  50.894  1.00 23.36           N  
ATOM    963  CA  ASP A 119      22.710 -14.840  52.050  1.00 24.71           C  
ATOM    964  C   ASP A 119      22.536 -13.954  53.277  1.00 24.55           C  
ATOM    965  O   ASP A 119      22.980 -14.290  54.374  1.00 25.56           O  
ATOM    966  CB  ASP A 119      24.203 -15.154  51.861  1.00 27.70           C  
ATOM    967  CG  ASP A 119      25.058 -13.902  51.690  1.00 29.47           C  
ATOM    968  OD1 ASP A 119      24.780 -12.880  52.349  1.00 30.90           O  
ATOM    969  OD2 ASP A 119      26.029 -13.945  50.904  1.00 33.13           O  
ATOM    970  N   THR A 120      21.883 -12.813  53.073  1.00 22.88           N  
ATOM    971  CA  THR A 120      21.650 -11.856  54.143  1.00 22.28           C  
ATOM    972  C   THR A 120      20.313 -11.151  53.939  1.00 21.27           C  
ATOM    973  O   THR A 120      19.959 -10.799  52.815  1.00 19.43           O  
ATOM    974  CB  THR A 120      22.757 -10.785  54.165  1.00 23.75           C  
ATOM    975  OG1 THR A 120      24.030 -11.417  54.323  1.00 26.07           O  
ATOM    976  CG2 THR A 120      22.539  -9.816  55.307  1.00 25.09           C  
ATOM    977  N   ILE A 121      19.571 -10.964  55.026  1.00 19.12           N  
ATOM    978  CA  ILE A 121      18.288 -10.272  54.965  1.00 19.15           C  
ATOM    979  C   ILE A 121      18.319  -9.144  55.988  1.00 18.07           C  
ATOM    980  O   ILE A 121      18.610  -9.362  57.163  1.00 17.78           O  
ATOM    981  CB  ILE A 121      17.108 -11.211  55.272  1.00 19.03           C  
ATOM    982  CG1 ILE A 121      17.083 -12.357  54.255  1.00 20.83           C  
ATOM    983  CG2 ILE A 121      15.788 -10.431  55.204  1.00 18.73           C  
ATOM    984  CD1 ILE A 121      16.045 -13.417  54.546  1.00 22.34           C  
ATOM    985  N   GLU A 122      18.017  -7.936  55.527  1.00 16.84           N  
ATOM    986  CA  GLU A 122      18.039  -6.751  56.375  1.00 15.91           C  
ATOM    987  C   GLU A 122      16.654  -6.122  56.520  1.00 16.25           C  
ATOM    988  O   GLU A 122      15.820  -6.220  55.618  1.00 15.36           O  
ATOM    989  CB  GLU A 122      19.022  -5.741  55.770  1.00 16.54           C  
ATOM    990  CG  GLU A 122      19.138  -4.406  56.483  1.00 16.34           C  
ATOM    991  CD  GLU A 122      20.097  -3.475  55.760  1.00 18.75           C  
ATOM    992  OE1 GLU A 122      21.319  -3.537  56.018  1.00 17.38           O  
ATOM    993  OE2 GLU A 122      19.627  -2.689  54.911  1.00 20.05           O  
ATOM    994  N   LEU A 123      16.412  -5.485  57.662  1.00 15.44           N  
ATOM    995  CA  LEU A 123      15.134  -4.823  57.903  1.00 15.82           C  
ATOM    996  C   LEU A 123      15.267  -3.769  58.989  1.00 16.01           C  
ATOM    997  O   LEU A 123      16.215  -3.783  59.776  1.00 16.71           O  
ATOM    998  CB  LEU A 123      14.060  -5.846  58.310  1.00 14.65           C  
ATOM    999  CG  LEU A 123      14.274  -6.582  59.641  1.00 16.50           C  
ATOM   1000  CD1 LEU A 123      13.803  -5.701  60.801  1.00 15.63           C  
ATOM   1001  CD2 LEU A 123      13.490  -7.892  59.645  1.00 15.45           C  
ATOM   1002  N   TRP A 124      14.315  -2.842  59.006  1.00 16.23           N  
ATOM   1003  CA  TRP A 124      14.273  -1.791  60.008  1.00 17.32           C  
ATOM   1004  C   TRP A 124      12.918  -1.891  60.693  1.00 17.35           C  
ATOM   1005  O   TRP A 124      11.885  -2.040  60.033  1.00 18.02           O  
ATOM   1006  CB  TRP A 124      14.430  -0.406  59.374  1.00 17.34           C  
ATOM   1007  CG  TRP A 124      15.804  -0.126  58.856  1.00 19.88           C  
ATOM   1008  CD1 TRP A 124      16.291  -0.411  57.610  1.00 20.60           C  
ATOM   1009  CD2 TRP A 124      16.871   0.514  59.567  1.00 20.43           C  
ATOM   1010  NE1 TRP A 124      17.591   0.022  57.500  1.00 20.71           N  
ATOM   1011  CE2 TRP A 124      17.972   0.593  58.686  1.00 20.73           C  
ATOM   1012  CE3 TRP A 124      17.001   1.033  60.864  1.00 20.05           C  
ATOM   1013  CZ2 TRP A 124      19.193   1.168  59.063  1.00 21.44           C  
ATOM   1014  CZ3 TRP A 124      18.214   1.605  61.238  1.00 20.98           C  
ATOM   1015  CH2 TRP A 124      19.294   1.669  60.337  1.00 20.52           C  
ATOM   1016  N   VAL A 125      12.927  -1.821  62.017  1.00 16.55           N  
ATOM   1017  CA  VAL A 125      11.699  -1.920  62.787  1.00 17.58           C  
ATOM   1018  C   VAL A 125      11.684  -0.852  63.875  1.00 17.07           C  
ATOM   1019  O   VAL A 125      12.736  -0.450  64.373  1.00 17.49           O  
ATOM   1020  CB  VAL A 125      11.570  -3.337  63.412  1.00 17.68           C  
ATOM   1021  CG1 VAL A 125      12.815  -3.668  64.220  1.00 20.65           C  
ATOM   1022  CG2 VAL A 125      10.328  -3.421  64.279  1.00 21.05           C  
ATOM   1023  N   GLY A 126      10.487  -0.383  64.222  1.00 18.10           N  
ATOM   1024  CA  GLY A 126      10.356   0.636  65.251  1.00 19.48           C  
ATOM   1025  C   GLY A 126      10.913   0.181  66.586  1.00 19.48           C  
ATOM   1026  O   GLY A 126      10.716  -0.965  66.986  1.00 20.38           O  
ATOM   1027  N   GLU A 127      11.599   1.086  67.282  1.00 20.94           N  
ATOM   1028  CA  GLU A 127      12.215   0.769  68.567  1.00 22.10           C  
ATOM   1029  C   GLU A 127      11.240   0.303  69.650  1.00 22.41           C  
ATOM   1030  O   GLU A 127      11.609  -0.477  70.525  1.00 23.11           O  
ATOM   1031  CB  GLU A 127      13.022   1.975  69.065  1.00 23.36           C  
ATOM   1032  CG  GLU A 127      12.192   3.186  69.468  1.00 25.84           C  
ATOM   1033  CD  GLU A 127      13.049   4.413  69.749  1.00 29.16           C  
ATOM   1034  OE1 GLU A 127      14.194   4.248  70.216  1.00 30.60           O  
ATOM   1035  OE2 GLU A 127      12.573   5.543  69.514  1.00 30.89           O  
ATOM   1036  N   LYS A 128       9.997   0.769  69.588  1.00 21.85           N  
ATOM   1037  CA  LYS A 128       8.997   0.377  70.578  1.00 23.07           C  
ATOM   1038  C   LYS A 128       8.269  -0.903  70.172  1.00 22.23           C  
ATOM   1039  O   LYS A 128       7.532  -1.484  70.962  1.00 22.75           O  
ATOM   1040  CB  LYS A 128       7.973   1.502  70.775  1.00 24.32           C  
ATOM   1041  CG  LYS A 128       8.562   2.805  71.293  1.00 26.08           C  
ATOM   1042  CD  LYS A 128       7.500   3.891  71.415  1.00 26.86           C  
ATOM   1043  CE  LYS A 128       8.137   5.235  71.758  1.00 28.33           C  
ATOM   1044  NZ  LYS A 128       7.161   6.360  71.719  1.00 29.07           N  
ATOM   1045  N   ASN A 129       8.493  -1.348  68.940  1.00 21.33           N  
ATOM   1046  CA  ASN A 129       7.830  -2.542  68.418  1.00 21.01           C  
ATOM   1047  C   ASN A 129       8.454  -3.841  68.934  1.00 21.33           C  
ATOM   1048  O   ASN A 129       9.055  -4.599  68.169  1.00 20.06           O  
ATOM   1049  CB  ASN A 129       7.892  -2.516  66.888  1.00 20.52           C  
ATOM   1050  CG  ASN A 129       6.777  -3.305  66.245  1.00 21.20           C  
ATOM   1051  OD1 ASN A 129       6.143  -4.148  66.880  1.00 21.83           O  
ATOM   1052  ND2 ASN A 129       6.541  -3.045  64.964  1.00 20.00           N  
ATOM   1053  N   TYR A 130       8.298  -4.109  70.229  1.00 20.40           N  
ATOM   1054  CA  TYR A 130       8.870  -5.310  70.832  1.00 20.03           C  
ATOM   1055  C   TYR A 130       8.266  -6.604  70.293  1.00 20.27           C  
ATOM   1056  O   TYR A 130       8.930  -7.641  70.267  1.00 20.42           O  
ATOM   1057  CB  TYR A 130       8.716  -5.246  72.359  1.00 20.34           C  
ATOM   1058  CG  TYR A 130       7.297  -4.987  72.807  1.00 20.98           C  
ATOM   1059  CD1 TYR A 130       6.371  -6.028  72.898  1.00 20.50           C  
ATOM   1060  CD2 TYR A 130       6.863  -3.693  73.088  1.00 21.39           C  
ATOM   1061  CE1 TYR A 130       5.049  -5.782  73.251  1.00 21.49           C  
ATOM   1062  CE2 TYR A 130       5.545  -3.438  73.440  1.00 21.62           C  
ATOM   1063  CZ  TYR A 130       4.644  -4.485  73.518  1.00 21.87           C  
ATOM   1064  OH  TYR A 130       3.337  -4.234  73.851  1.00 25.00           O  
ATOM   1065  N   GLY A 131       7.011  -6.538  69.859  1.00 19.86           N  
ATOM   1066  CA  GLY A 131       6.345  -7.713  69.328  1.00 20.53           C  
ATOM   1067  C   GLY A 131       6.977  -8.204  68.041  1.00 19.72           C  
ATOM   1068  O   GLY A 131       7.276  -9.390  67.893  1.00 20.49           O  
ATOM   1069  N   ALA A 132       7.182  -7.287  67.103  1.00 19.56           N  
ATOM   1070  CA  ALA A 132       7.791  -7.644  65.829  1.00 19.68           C  
ATOM   1071  C   ALA A 132       9.233  -8.090  66.050  1.00 19.38           C  
ATOM   1072  O   ALA A 132       9.682  -9.076  65.465  1.00 18.87           O  
ATOM   1073  CB  ALA A 132       7.745  -6.452  64.873  1.00 19.73           C  
ATOM   1074  N   MET A 133       9.961  -7.369  66.897  1.00 20.23           N  
ATOM   1075  CA  MET A 133      11.346  -7.731  67.156  1.00 21.26           C  
ATOM   1076  C   MET A 133      11.456  -9.113  67.791  1.00 20.93           C  
ATOM   1077  O   MET A 133      12.405  -9.847  67.520  1.00 20.25           O  
ATOM   1078  CB  MET A 133      12.023  -6.675  68.035  1.00 22.01           C  
ATOM   1079  CG  MET A 133      12.207  -5.335  67.330  1.00 24.44           C  
ATOM   1080  SD  MET A 133      13.224  -4.172  68.261  1.00 31.87           S  
ATOM   1081  CE  MET A 133      12.111  -3.740  69.548  1.00 27.50           C  
ATOM   1082  N   ASN A 134      10.487  -9.471  68.634  1.00 21.97           N  
ATOM   1083  CA  ASN A 134      10.502 -10.794  69.261  1.00 22.44           C  
ATOM   1084  C   ASN A 134      10.352 -11.854  68.176  1.00 22.38           C  
ATOM   1085  O   ASN A 134      11.075 -12.849  68.160  1.00 21.90           O  
ATOM   1086  CB  ASN A 134       9.364 -10.935  70.280  1.00 24.57           C  
ATOM   1087  CG  ASN A 134       9.276 -12.343  70.867  1.00 27.35           C  
ATOM   1088  OD1 ASN A 134      10.275 -12.903  71.325  1.00 30.87           O  
ATOM   1089  ND2 ASN A 134       8.079 -12.914  70.860  1.00 29.81           N  
ATOM   1090  N   LEU A 135       9.411 -11.632  67.262  1.00 21.84           N  
ATOM   1091  CA  LEU A 135       9.188 -12.571  66.171  1.00 20.72           C  
ATOM   1092  C   LEU A 135      10.448 -12.703  65.316  1.00 19.17           C  
ATOM   1093  O   LEU A 135      10.882 -13.809  64.998  1.00 19.10           O  
ATOM   1094  CB  LEU A 135       8.011 -12.112  65.300  1.00 21.02           C  
ATOM   1095  CG  LEU A 135       7.700 -12.967  64.064  1.00 22.19           C  
ATOM   1096  CD1 LEU A 135       7.563 -14.437  64.462  1.00 22.68           C  
ATOM   1097  CD2 LEU A 135       6.420 -12.465  63.406  1.00 23.52           C  
ATOM   1098  N   TYR A 136      11.044 -11.575  64.942  1.00 17.82           N  
ATOM   1099  CA  TYR A 136      12.250 -11.623  64.121  1.00 17.36           C  
ATOM   1100  C   TYR A 136      13.409 -12.373  64.788  1.00 17.78           C  
ATOM   1101  O   TYR A 136      14.115 -13.143  64.132  1.00 17.23           O  
ATOM   1102  CB  TYR A 136      12.710 -10.207  63.750  1.00 15.66           C  
ATOM   1103  CG  TYR A 136      11.766  -9.467  62.821  1.00 16.83           C  
ATOM   1104  CD1 TYR A 136      11.203 -10.102  61.711  1.00 17.96           C  
ATOM   1105  CD2 TYR A 136      11.473  -8.120  63.027  1.00 16.96           C  
ATOM   1106  CE1 TYR A 136      10.368  -9.408  60.828  1.00 18.97           C  
ATOM   1107  CE2 TYR A 136      10.644  -7.419  62.151  1.00 17.73           C  
ATOM   1108  CZ  TYR A 136      10.097  -8.069  61.054  1.00 19.64           C  
ATOM   1109  OH  TYR A 136       9.288  -7.374  60.179  1.00 19.61           O  
ATOM   1110  N   GLU A 137      13.613 -12.147  66.083  1.00 20.24           N  
ATOM   1111  CA  GLU A 137      14.704 -12.814  66.791  1.00 21.71           C  
ATOM   1112  C   GLU A 137      14.492 -14.327  66.848  1.00 22.97           C  
ATOM   1113  O   GLU A 137      15.449 -15.100  66.802  1.00 22.67           O  
ATOM   1114  CB  GLU A 137      14.854 -12.247  68.208  1.00 23.95           C  
ATOM   1115  CG  GLU A 137      15.148 -10.755  68.241  1.00 27.24           C  
ATOM   1116  CD  GLU A 137      15.541 -10.261  69.622  1.00 30.45           C  
ATOM   1117  OE1 GLU A 137      14.862 -10.628  70.602  1.00 30.62           O  
ATOM   1118  OE2 GLU A 137      16.527  -9.500  69.725  1.00 31.87           O  
ATOM   1119  N   LYS A 138      13.235 -14.744  66.941  1.00 23.82           N  
ATOM   1120  CA  LYS A 138      12.908 -16.165  66.982  1.00 24.08           C  
ATOM   1121  C   LYS A 138      13.296 -16.837  65.674  1.00 24.45           C  
ATOM   1122  O   LYS A 138      13.491 -18.053  65.617  1.00 23.68           O  
ATOM   1123  CB  LYS A 138      11.416 -16.350  67.232  1.00 26.59           C  
ATOM   1124  CG  LYS A 138      11.028 -16.064  68.660  1.00 29.67           C  
ATOM   1125  CD  LYS A 138       9.531 -15.941  68.814  1.00 33.04           C  
ATOM   1126  CE  LYS A 138       9.152 -16.088  70.274  1.00 34.84           C  
ATOM   1127  NZ  LYS A 138       7.908 -16.902  70.368  1.00 37.75           N  
ATOM   1128  N   PHE A 139      13.400 -16.036  64.620  1.00 22.38           N  
ATOM   1129  CA  PHE A 139      13.762 -16.556  63.315  1.00 22.22           C  
ATOM   1130  C   PHE A 139      15.212 -16.290  62.945  1.00 22.23           C  
ATOM   1131  O   PHE A 139      15.601 -16.431  61.788  1.00 23.42           O  
ATOM   1132  CB  PHE A 139      12.816 -15.995  62.255  1.00 20.74           C  
ATOM   1133  CG  PHE A 139      11.523 -16.745  62.165  1.00 20.26           C  
ATOM   1134  CD1 PHE A 139      11.391 -17.820  61.290  1.00 19.99           C  
ATOM   1135  CD2 PHE A 139      10.462 -16.430  63.007  1.00 20.35           C  
ATOM   1136  CE1 PHE A 139      10.220 -18.574  61.255  1.00 19.32           C  
ATOM   1137  CE2 PHE A 139       9.285 -17.178  62.981  1.00 20.87           C  
ATOM   1138  CZ  PHE A 139       9.165 -18.253  62.103  1.00 20.19           C  
ATOM   1139  N   GLY A 140      16.011 -15.902  63.932  1.00 22.95           N  
ATOM   1140  CA  GLY A 140      17.419 -15.674  63.674  1.00 21.81           C  
ATOM   1141  C   GLY A 140      17.892 -14.260  63.415  1.00 21.76           C  
ATOM   1142  O   GLY A 140      19.088 -14.054  63.219  1.00 22.56           O  
ATOM   1143  N   PHE A 141      16.983 -13.290  63.394  1.00 20.58           N  
ATOM   1144  CA  PHE A 141      17.383 -11.906  63.161  1.00 20.63           C  
ATOM   1145  C   PHE A 141      18.035 -11.351  64.420  1.00 22.04           C  
ATOM   1146  O   PHE A 141      17.639 -11.691  65.535  1.00 22.75           O  
ATOM   1147  CB  PHE A 141      16.168 -11.046  62.791  1.00 19.72           C  
ATOM   1148  CG  PHE A 141      15.732 -11.191  61.358  1.00 19.83           C  
ATOM   1149  CD1 PHE A 141      16.234 -10.342  60.377  1.00 19.42           C  
ATOM   1150  CD2 PHE A 141      14.827 -12.182  60.988  1.00 20.06           C  
ATOM   1151  CE1 PHE A 141      15.842 -10.473  59.049  1.00 20.05           C  
ATOM   1152  CE2 PHE A 141      14.426 -12.324  59.657  1.00 20.92           C  
ATOM   1153  CZ  PHE A 141      14.935 -11.466  58.686  1.00 20.60           C  
ATOM   1154  N   LYS A 142      19.040 -10.502  64.233  1.00 21.49           N  
ATOM   1155  CA  LYS A 142      19.746  -9.887  65.348  1.00 23.87           C  
ATOM   1156  C   LYS A 142      19.797  -8.373  65.159  1.00 23.56           C  
ATOM   1157  O   LYS A 142      19.920  -7.884  64.037  1.00 21.88           O  
ATOM   1158  CB  LYS A 142      21.175 -10.438  65.439  1.00 25.22           C  
ATOM   1159  CG  LYS A 142      21.259 -11.939  65.673  1.00 29.36           C  
ATOM   1160  CD  LYS A 142      22.708 -12.407  65.700  1.00 32.80           C  
ATOM   1161  CE  LYS A 142      22.801 -13.903  65.958  1.00 34.33           C  
ATOM   1162  NZ  LYS A 142      22.162 -14.272  67.253  1.00 37.73           N  
ATOM   1163  N   LYS A 143      19.685  -7.636  66.259  1.00 25.00           N  
ATOM   1164  CA  LYS A 143      19.744  -6.182  66.202  1.00 25.72           C  
ATOM   1165  C   LYS A 143      21.197  -5.819  65.938  1.00 26.90           C  
ATOM   1166  O   LYS A 143      22.096  -6.369  66.572  1.00 27.08           O  
ATOM   1167  CB  LYS A 143      19.277  -5.584  67.530  1.00 27.44           C  
ATOM   1168  CG  LYS A 143      17.860  -5.985  67.905  1.00 27.50           C  
ATOM   1169  CD  LYS A 143      17.439  -5.389  69.236  1.00 29.39           C  
ATOM   1170  CE  LYS A 143      16.068  -5.898  69.651  1.00 29.80           C  
ATOM   1171  NZ  LYS A 143      15.644  -5.351  70.973  1.00 29.50           N  
ATOM   1172  N   VAL A 144      21.438  -4.901  65.008  1.00 26.36           N  
ATOM   1173  CA  VAL A 144      22.809  -4.532  64.686  1.00 28.15           C  
ATOM   1174  C   VAL A 144      23.073  -3.037  64.575  1.00 28.40           C  
ATOM   1175  O   VAL A 144      24.200  -2.623  64.310  1.00 29.72           O  
ATOM   1176  CB  VAL A 144      23.259  -5.202  63.375  1.00 28.59           C  
ATOM   1177  CG1 VAL A 144      23.281  -6.709  63.551  1.00 29.21           C  
ATOM   1178  CG2 VAL A 144      22.315  -4.814  62.242  1.00 29.38           C  
ATOM   1179  N   GLY A 145      22.045  -2.226  64.782  1.00 28.32           N  
ATOM   1180  CA  GLY A 145      22.233  -0.790  64.692  1.00 27.75           C  
ATOM   1181  C   GLY A 145      20.941  -0.032  64.880  1.00 27.28           C  
ATOM   1182  O   GLY A 145      19.891  -0.627  65.104  1.00 25.13           O  
ATOM   1183  N   LYS A 146      21.017   1.289  64.790  1.00 27.78           N  
ATOM   1184  CA  LYS A 146      19.840   2.124  64.958  1.00 29.60           C  
ATOM   1185  C   LYS A 146      19.960   3.415  64.168  1.00 29.22           C  
ATOM   1186  O   LYS A 146      21.051   3.823  63.767  1.00 30.15           O  
ATOM   1187  CB  LYS A 146      19.642   2.469  66.433  1.00 31.10           C  
ATOM   1188  CG  LYS A 146      20.763   3.317  67.004  1.00 34.81           C  
ATOM   1189  CD  LYS A 146      20.482   3.738  68.436  1.00 37.30           C  
ATOM   1190  CE  LYS A 146      21.651   4.520  69.010  1.00 37.69           C  
ATOM   1191  NZ  LYS A 146      22.901   3.709  69.015  1.00 40.23           N  
ATOM   1192  N   SER A 147      18.816   4.047  63.951  1.00 28.47           N  
ATOM   1193  CA  SER A 147      18.736   5.309  63.236  1.00 27.51           C  
ATOM   1194  C   SER A 147      17.494   6.001  63.767  1.00 26.61           C  
ATOM   1195  O   SER A 147      16.379   5.699  63.346  1.00 24.67           O  
ATOM   1196  CB  SER A 147      18.597   5.075  61.732  1.00 28.43           C  
ATOM   1197  OG  SER A 147      18.491   6.309  61.042  1.00 28.63           O  
ATOM   1198  N   GLY A 148      17.690   6.922  64.703  1.00 26.88           N  
ATOM   1199  CA  GLY A 148      16.556   7.617  65.278  1.00 26.03           C  
ATOM   1200  C   GLY A 148      15.639   6.637  65.987  1.00 25.42           C  
ATOM   1201  O   GLY A 148      16.075   5.889  66.863  1.00 27.06           O  
ATOM   1202  N   ILE A 149      14.369   6.627  65.601  1.00 25.28           N  
ATOM   1203  CA  ILE A 149      13.395   5.736  66.216  1.00 23.82           C  
ATOM   1204  C   ILE A 149      13.418   4.343  65.584  1.00 23.53           C  
ATOM   1205  O   ILE A 149      12.614   3.477  65.942  1.00 23.44           O  
ATOM   1206  CB  ILE A 149      11.967   6.313  66.087  1.00 24.65           C  
ATOM   1207  CG1 ILE A 149      11.511   6.273  64.626  1.00 24.11           C  
ATOM   1208  CG2 ILE A 149      11.946   7.754  66.584  1.00 25.14           C  
ATOM   1209  CD1 ILE A 149      10.104   6.783  64.411  1.00 24.47           C  
ATOM   1210  N   TRP A 150      14.348   4.124  64.658  1.00 22.22           N  
ATOM   1211  CA  TRP A 150      14.435   2.840  63.964  1.00 21.42           C  
ATOM   1212  C   TRP A 150      15.613   1.951  64.348  1.00 20.82           C  
ATOM   1213  O   TRP A 150      16.728   2.426  64.565  1.00 21.95           O  
ATOM   1214  CB  TRP A 150      14.464   3.066  62.444  1.00 20.78           C  
ATOM   1215  CG  TRP A 150      13.313   3.874  61.936  1.00 20.13           C  
ATOM   1216  CD1 TRP A 150      13.292   5.220  61.705  1.00 20.76           C  
ATOM   1217  CD2 TRP A 150      11.999   3.395  61.643  1.00 21.45           C  
ATOM   1218  NE1 TRP A 150      12.043   5.609  61.290  1.00 21.88           N  
ATOM   1219  CE2 TRP A 150      11.228   4.510  61.246  1.00 21.09           C  
ATOM   1220  CE3 TRP A 150      11.392   2.133  61.686  1.00 21.80           C  
ATOM   1221  CZ2 TRP A 150       9.881   4.398  60.883  1.00 21.49           C  
ATOM   1222  CZ3 TRP A 150      10.050   2.022  61.328  1.00 22.39           C  
ATOM   1223  CH2 TRP A 150       9.312   3.150  60.935  1.00 22.28           C  
ATOM   1224  N   VAL A 151      15.345   0.649  64.411  1.00 20.10           N  
ATOM   1225  CA  VAL A 151      16.350  -0.359  64.741  1.00 19.25           C  
ATOM   1226  C   VAL A 151      16.597  -1.247  63.519  1.00 19.54           C  
ATOM   1227  O   VAL A 151      15.651  -1.666  62.855  1.00 19.82           O  
ATOM   1228  CB  VAL A 151      15.871  -1.255  65.903  1.00 19.61           C  
ATOM   1229  CG1 VAL A 151      16.875  -2.375  66.154  1.00 19.40           C  
ATOM   1230  CG2 VAL A 151      15.675  -0.418  67.149  1.00 20.78           C  
ATOM   1231  N   ARG A 152      17.864  -1.525  63.219  1.00 18.18           N  
ATOM   1232  CA  ARG A 152      18.201  -2.369  62.076  1.00 18.10           C  
ATOM   1233  C   ARG A 152      18.485  -3.794  62.531  1.00 18.34           C  
ATOM   1234  O   ARG A 152      19.239  -4.022  63.483  1.00 19.03           O  
ATOM   1235  CB  ARG A 152      19.423  -1.823  61.322  1.00 17.35           C  
ATOM   1236  CG  ARG A 152      19.732  -2.573  60.016  1.00 19.75           C  
ATOM   1237  CD  ARG A 152      20.894  -1.931  59.237  1.00 19.60           C  
ATOM   1238  NE  ARG A 152      22.197  -2.168  59.855  1.00 21.93           N  
ATOM   1239  CZ  ARG A 152      23.057  -3.112  59.472  1.00 23.05           C  
ATOM   1240  NH1 ARG A 152      22.767  -3.921  58.457  1.00 22.50           N  
ATOM   1241  NH2 ARG A 152      24.206  -3.261  60.121  1.00 24.77           N  
ATOM   1242  N   MET A 153      17.864  -4.752  61.854  1.00 17.70           N  
ATOM   1243  CA  MET A 153      18.060  -6.157  62.175  1.00 18.03           C  
ATOM   1244  C   MET A 153      18.544  -6.889  60.940  1.00 19.29           C  
ATOM   1245  O   MET A 153      18.195  -6.531  59.814  1.00 17.55           O  
ATOM   1246  CB  MET A 153      16.763  -6.777  62.693  1.00 18.81           C  
ATOM   1247  CG  MET A 153      16.283  -6.125  63.978  1.00 19.79           C  
ATOM   1248  SD  MET A 153      14.868  -6.927  64.727  1.00 20.23           S  
ATOM   1249  CE  MET A 153      15.667  -8.349  65.504  1.00 21.64           C  
ATOM   1250  N   ILE A 154      19.347  -7.921  61.154  1.00 19.81           N  
ATOM   1251  CA  ILE A 154      19.898  -8.670  60.040  1.00 21.86           C  
ATOM   1252  C   ILE A 154      19.918 -10.165  60.334  1.00 21.75           C  
ATOM   1253  O   ILE A 154      20.033 -10.578  61.490  1.00 20.60           O  
ATOM   1254  CB  ILE A 154      21.343  -8.186  59.749  1.00 23.84           C  
ATOM   1255  CG1 ILE A 154      21.760  -8.568  58.335  1.00 27.60           C  
ATOM   1256  CG2 ILE A 154      22.309  -8.762  60.772  1.00 27.42           C  
ATOM   1257  CD1 ILE A 154      21.367  -7.531  57.306  1.00 28.30           C  
ATOM   1258  N   LYS A 155      19.778 -10.965  59.284  1.00 21.26           N  
ATOM   1259  CA  LYS A 155      19.884 -12.410  59.361  1.00 23.02           C  
ATOM   1260  C   LYS A 155      20.854 -12.940  58.306  1.00 23.73           C  
ATOM   1261  O   LYS A 155      20.746 -12.680  57.114  1.00 23.05           O  
ATOM   1262  CB  LYS A 155      18.491 -13.010  59.162  1.00 23.51           C  
ATOM   1263  CG  LYS A 155      18.484 -14.540  59.245  1.00 24.01           C  
ATOM   1264  CD  LYS A 155      17.092 -15.149  59.073  1.00 24.41           C  
ATOM   1265  CE  LYS A 155      17.124 -16.684  59.028  1.00 27.03           C  
ATOM   1266  NZ  LYS A 155      17.638 -17.209  60.286  1.00 30.64           N  
ATOM   1267  N   ARG A 156      21.863 -13.684  58.789  1.00 24.78           N  
ATOM   1268  CA  ARG A 156      22.874 -14.179  57.868  1.00 28.24           C  
ATOM   1269  C   ARG A 156      22.752 -15.691  57.670  1.00 30.48           C  
ATOM   1270  O   ARG A 156      22.306 -16.427  58.544  1.00 29.43           O  
ATOM   1271  CB  ARG A 156      24.250 -13.837  58.450  1.00 28.35           C  
ATOM   1272  CG  ARG A 156      24.461 -12.330  58.640  1.00 30.38           C  
ATOM   1273  CD  ARG A 156      25.897 -12.012  59.077  1.00 30.81           C  
ATOM   1274  NE  ARG A 156      26.006 -10.640  59.581  1.00 34.04           N  
ATOM   1275  CZ  ARG A 156      26.046  -9.649  58.671  1.00 34.33           C  
ATOM   1276  NH1 ARG A 156      25.949  -9.928  57.382  1.00 34.31           N  
ATOM   1277  NH2 ARG A 156      26.231  -8.388  59.072  1.00 36.74           N  
ATOM   1278  N   GLN A 157      23.113 -16.143  56.451  1.00 33.78           N  
ATOM   1279  CA  GLN A 157      23.068 -17.576  56.166  1.00 37.30           C  
ATOM   1280  C   GLN A 157      24.208 -18.317  56.875  1.00 38.71           C  
ATOM   1281  O   GLN A 157      24.000 -19.237  57.659  1.00 40.86           O  
ATOM   1282  CB  GLN A 157      23.174 -17.781  54.644  1.00 38.38           C  
ATOM   1283  CG  GLN A 157      21.807 -17.941  53.951  1.00 40.63           C  
ATOM   1284  CD  GLN A 157      21.996 -18.491  52.547  1.00 42.27           C  
ATOM   1285  OE1 GLN A 157      23.061 -18.948  52.154  1.00 44.01           O  
ATOM   1286  NE2 GLN A 157      20.883 -18.439  51.771  1.00 42.25           N  
TER    1287      GLN A 157                                                      
END
MOLECULE T0417.pdb
ATOM      1  N   ARG    26      -8.346 -19.992  57.885  1.00 43.52           N  
ATOM      2  CA  ARG    26      -6.996 -20.186  57.309  1.00 42.87           C  
ATOM      3  C   ARG    26      -6.720 -19.292  56.082  1.00 40.26           C  
ATOM      4  O   ARG    26      -7.623 -18.925  55.355  1.00 41.81           O  
ATOM      5  CB  ARG    26      -6.794 -21.646  56.944  1.00 44.22           C  
ATOM      6  CG  ARG    26      -5.528 -22.164  57.568  1.00 50.33           C  
ATOM      7  CD  ARG    26      -4.338 -22.107  56.614  1.00 57.94           C  
ATOM      8  NE  ARG    26      -3.925 -23.473  56.307  1.00 63.20           N  
ATOM      9  CZ  ARG    26      -3.141 -24.214  57.094  1.00 67.19           C  
ATOM     10  NH1 ARG    26      -2.670 -23.712  58.236  1.00 67.80           N  
ATOM     11  NH2 ARG    26      -2.832 -25.469  56.744  1.00 69.45           N  
ATOM     12  N   TYR    27      -5.463 -18.989  55.840  1.00 37.22           N  
ATOM     13  CA  TYR    27      -5.081 -18.034  54.827  1.00 33.87           C  
ATOM     14  C   TYR    27      -4.220 -18.789  53.867  1.00 33.61           C  
ATOM     15  O   TYR    27      -3.593 -19.751  54.270  1.00 34.13           O  
ATOM     16  CB  TYR    27      -4.241 -16.978  55.500  1.00 33.02           C  
ATOM     17  CG  TYR    27      -5.094 -16.062  56.338  1.00 32.33           C  
ATOM     18  CD1 TYR    27      -5.863 -15.072  55.730  1.00 32.08           C  
ATOM     19  CD2 TYR    27      -5.190 -16.215  57.741  1.00 36.16           C  
ATOM     20  CE1 TYR    27      -6.682 -14.200  56.491  1.00 27.91           C  
ATOM     21  CE2 TYR    27      -6.007 -15.357  58.503  1.00 34.22           C  
ATOM     22  CZ  TYR    27      -6.756 -14.378  57.859  1.00 30.13           C  
ATOM     23  OH  TYR    27      -7.556 -13.514  58.581  1.00 32.02           O  
ATOM     24  N   HIS    28      -4.200 -18.399  52.596  1.00 31.38           N  
ATOM     25  CA  HIS    28      -3.133 -18.828  51.704  1.00 29.66           C  
ATOM     26  C   HIS    28      -2.222 -17.609  51.439  1.00 29.79           C  
ATOM     27  O   HIS    28      -2.664 -16.473  51.590  1.00 29.92           O  
ATOM     28  CB  HIS    28      -3.714 -19.387  50.414  1.00 29.69           C  
ATOM     29  CG  HIS    28      -4.733 -18.514  49.781  1.00 27.79           C  
ATOM     30  ND1 HIS    28      -4.406 -17.527  48.880  1.00 33.31           N  
ATOM     31  CD2 HIS    28      -6.075 -18.479  49.906  1.00 27.26           C  
ATOM     32  CE1 HIS    28      -5.499 -16.883  48.515  1.00 30.56           C  
ATOM     33  NE2 HIS    28      -6.527 -17.455  49.111  1.00 34.84           N  
ATOM     34  N   LEU    29      -0.964 -17.859  51.082  1.00 28.47           N  
ATOM     35  CA  LEU    29       0.044 -16.840  50.892  1.00 28.69           C  
ATOM     36  C   LEU    29       0.368 -16.782  49.412  1.00 29.46           C  
ATOM     37  O   LEU    29       0.441 -17.827  48.773  1.00 26.65           O  
ATOM     38  CB  LEU    29       1.315 -17.178  51.633  1.00 28.79           C  
ATOM     39  CG  LEU    29       1.209 -17.332  53.136  1.00 31.32           C  
ATOM     40  CD1 LEU    29       2.584 -17.475  53.797  1.00 31.37           C  
ATOM     41  CD2 LEU    29       0.465 -16.152  53.746  1.00 27.79           C  
ATOM     42  N   ARG    30       0.472 -15.592  48.857  1.00 26.45           N  
ATOM     43  CA  ARG    30       0.850 -15.438  47.421  1.00 28.49           C  
ATOM     44  C   ARG    30       1.503 -14.076  47.223  1.00 28.52           C  
ATOM     45  O   ARG    30       1.246 -13.151  48.023  1.00 28.69           O  
ATOM     46  CB  ARG    30      -0.398 -15.536  46.509  1.00 27.55           C  
ATOM     47  CG  ARG    30      -1.509 -14.555  46.889  1.00 29.96           C  
ATOM     48  CD  ARG    30      -2.569 -14.424  45.782  1.00 30.98           C  
ATOM     49  NE  ARG    30      -3.645 -13.487  46.083  1.00 29.51           N  
ATOM     50  CZ  ARG    30      -3.588 -12.183  45.767  1.00 29.30           C  
ATOM     51  NH1 ARG    30      -2.490 -11.696  45.232  1.00 27.51           N  
ATOM     52  NH2 ARG    30      -4.599 -11.364  46.024  1.00 30.05           N  
ATOM     53  N   PRO    31       2.289 -13.912  46.147  1.00 29.31           N  
ATOM     54  CA  PRO    31       2.781 -12.578  45.785  1.00 29.25           C  
ATOM     55  C   PRO    31       1.576 -11.677  45.522  1.00 28.45           C  
ATOM     56  O   PRO    31       0.538 -12.140  45.040  1.00 28.22           O  
ATOM     57  CB  PRO    31       3.568 -12.793  44.450  1.00 27.62           C  
ATOM     58  CG  PRO    31       3.832 -14.298  44.399  1.00 31.77           C  
ATOM     59  CD  PRO    31       2.775 -14.983  45.244  1.00 31.08           C  
ATOM     60  N   PRO    32       1.722 -10.383  45.776  1.00 28.65           N  
ATOM     61  CA  PRO    32       0.600  -9.513  45.417  1.00 27.94           C  
ATOM     62  C   PRO    32       0.530  -9.334  43.884  1.00 29.66           C  
ATOM     63  O   PRO    32       1.502  -9.662  43.150  1.00 28.33           O  
ATOM     64  CB  PRO    32       0.978  -8.155  46.056  1.00 28.26           C  
ATOM     65  CG  PRO    32       2.525  -8.120  45.941  1.00 27.98           C  
ATOM     66  CD  PRO    32       2.869  -9.652  46.336  1.00 27.09           C  
ATOM     67  N   ARG    33      -0.623  -8.867  43.407  1.00 30.25           N  
ATOM     68  CA  ARG    33      -0.841  -8.522  41.995  1.00 32.43           C  
ATOM     69  C   ARG    33      -1.143  -7.022  42.003  1.00 32.10           C  
ATOM     70  O   ARG    33      -1.538  -6.471  43.032  1.00 30.61           O  
ATOM     71  CB  ARG    33      -2.040  -9.308  41.456  1.00 33.09           C  
ATOM     72  CG  ARG    33      -1.665 -10.826  41.301  1.00 36.12           C  
ATOM     73  CD  ARG    33      -2.773 -11.718  40.723  1.00 38.47           C  
ATOM     74  NE  ARG    33      -3.928 -11.758  41.601  1.00 48.20           N  
ATOM     75  CZ  ARG    33      -4.301 -12.801  42.347  1.00 50.41           C  
ATOM     76  NH1 ARG    33      -3.618 -13.963  42.324  1.00 50.43           N  
ATOM     77  NH2 ARG    33      -5.386 -12.672  43.108  1.00 47.97           N  
ATOM     78  N   ARG    34      -1.037  -6.379  40.845  1.00 32.63           N  
ATOM     79  CA  ARG    34      -1.252  -4.951  40.766  1.00 33.66           C  
ATOM     80  C   ARG    34      -2.555  -4.456  41.359  1.00 33.45           C  
ATOM     81  O   ARG    34      -2.594  -3.395  42.050  1.00 34.67           O  
ATOM     82  CB  ARG    34      -1.219  -4.558  39.287  1.00 36.26           C  
ATOM     83  CG  ARG    34      -0.054  -3.698  38.981  1.00 44.64           C  
ATOM     84  CD  ARG    34      -0.449  -2.237  38.486  1.00 50.45           C  
ATOM     85  NE  ARG    34      -1.377  -2.197  37.345  1.00 50.08           N  
ATOM     86  CZ  ARG    34      -1.109  -2.490  36.060  1.00 50.81           C  
ATOM     87  NH1 ARG    34       0.080  -2.879  35.630  1.00 48.97           N  
ATOM     88  NH2 ARG    34      -2.090  -2.385  35.180  1.00 44.07           N  
ATOM     89  N   ASN    35      -3.622  -5.210  41.135  1.00 31.69           N  
ATOM     90  CA  ASN    35      -4.929  -4.832  41.671  1.00 32.20           C  
ATOM     91  C   ASN    35      -5.137  -5.068  43.185  1.00 32.68           C  
ATOM     92  O   ASN    35      -6.252  -4.815  43.725  1.00 33.44           O  
ATOM     93  CB  ASN    35      -6.052  -5.445  40.842  1.00 32.80           C  
ATOM     94  CG  ASN    35      -6.124  -4.799  39.448  1.00 37.02           C  
ATOM     95  OD1 ASN    35      -5.603  -3.680  39.256  1.00 38.28           O  
ATOM     96  ND2 ASN    35      -6.720  -5.489  38.486  1.00 37.56           N  
ATOM     97  N   ASP    36      -4.080  -5.517  43.875  1.00 31.38           N  
ATOM     98  CA  ASP    36      -4.155  -5.689  45.326  1.00 30.72           C  
ATOM     99  C   ASP    36      -3.811  -4.373  46.002  1.00 31.33           C  
ATOM    100  O   ASP    36      -3.940  -4.265  47.243  1.00 29.20           O  
ATOM    101  CB  ASP    36      -3.145  -6.743  45.823  1.00 30.37           C  
ATOM    102  CG  ASP    36      -3.559  -8.155  45.498  1.00 33.10           C  
ATOM    103  OD1 ASP    36      -4.793  -8.438  45.430  1.00 31.11           O  
ATOM    104  OD2 ASP    36      -2.643  -9.017  45.303  1.00 34.74           O  
ATOM    105  N   GLY    37      -3.302  -3.397  45.233  1.00 28.72           N  
ATOM    106  CA  GLY    37      -2.790  -2.139  45.866  1.00 29.06           C  
ATOM    107  C   GLY    37      -3.772  -1.464  46.818  1.00 27.90           C  
ATOM    108  O   GLY    37      -3.379  -1.073  47.918  1.00 28.59           O  
ATOM    109  N   ALA    38      -5.052  -1.328  46.411  1.00 26.81           N  
ATOM    110  CA  ALA    38      -6.050  -0.648  47.253  1.00 27.86           C  
ATOM    111  C   ALA    38      -6.302  -1.434  48.538  1.00 26.85           C  
ATOM    112  O   ALA    38      -6.393  -0.859  49.613  1.00 26.00           O  
ATOM    113  CB  ALA    38      -7.404  -0.441  46.524  1.00 28.58           C  
ATOM    114  N   ALA    39      -6.420  -2.743  48.423  1.00 26.15           N  
ATOM    115  CA  ALA    39      -6.681  -3.541  49.640  1.00 27.31           C  
ATOM    116  C   ALA    39      -5.485  -3.539  50.585  1.00 26.72           C  
ATOM    117  O   ALA    39      -5.676  -3.566  51.841  1.00 25.98           O  
ATOM    118  CB  ALA    39      -6.981  -4.976  49.266  1.00 28.08           C  
ATOM    119  N   ILE    40      -4.259  -3.510  50.021  1.00 24.99           N  
ATOM    120  CA  ILE    40      -3.084  -3.519  50.875  1.00 25.29           C  
ATOM    121  C   ILE    40      -2.991  -2.167  51.564  1.00 25.64           C  
ATOM    122  O   ILE    40      -2.692  -2.061  52.785  1.00 26.59           O  
ATOM    123  CB  ILE    40      -1.771  -3.842  50.062  1.00 26.37           C  
ATOM    124  CG1 ILE    40      -1.765  -5.307  49.582  1.00 25.21           C  
ATOM    125  CG2 ILE    40      -0.501  -3.482  50.887  1.00 28.01           C  
ATOM    126  CD1 ILE    40      -0.820  -5.493  48.336  1.00 25.71           C  
ATOM    127  N   HIS    41      -3.226  -1.124  50.812  1.00 24.91           N  
ATOM    128  CA  HIS    41      -3.290   0.226  51.415  1.00 26.65           C  
ATOM    129  C   HIS    41      -4.357   0.361  52.532  1.00 27.01           C  
ATOM    130  O   HIS    41      -4.089   0.938  53.614  1.00 27.31           O  
ATOM    131  CB  HIS    41      -3.421   1.257  50.299  1.00 27.52           C  
ATOM    132  CG  HIS    41      -3.471   2.689  50.767  1.00 29.79           C  
ATOM    133  ND1 HIS    41      -4.657   3.352  50.971  1.00 36.10           N  
ATOM    134  CD2 HIS    41      -2.487   3.553  51.120  1.00 30.28           C  
ATOM    135  CE1 HIS    41      -4.394   4.583  51.409  1.00 34.52           C  
ATOM    136  NE2 HIS    41      -3.080   4.732  51.463  1.00 30.04           N  
ATOM    137  N   GLN    42      -5.549  -0.181  52.287  1.00 26.19           N  
ATOM    138  CA  GLN    42      -6.575  -0.203  53.331  1.00 28.05           C  
ATOM    139  C   GLN    42      -6.133  -1.033  54.531  1.00 27.46           C  
ATOM    140  O   GLN    42      -6.320  -0.609  55.663  1.00 25.37           O  
ATOM    141  CB  GLN    42      -7.895  -0.793  52.829  1.00 28.03           C  
ATOM    142  CG  GLN    42      -9.065  -0.608  53.916  1.00 28.66           C  
ATOM    143  CD  GLN    42     -10.414  -1.142  53.475  1.00 33.32           C  
ATOM    144  OE1 GLN    42     -10.612  -1.447  52.300  1.00 41.41           O  
ATOM    145  NE2 GLN    42     -11.368  -1.274  54.435  1.00 35.69           N  
ATOM    146  N   LEU    43      -5.553  -2.207  54.280  1.00 27.33           N  
ATOM    147  CA  LEU    43      -5.006  -3.048  55.404  1.00 26.81           C  
ATOM    148  C   LEU    43      -4.003  -2.253  56.236  1.00 28.18           C  
ATOM    149  O   LEU    43      -4.098  -2.231  57.472  1.00 26.75           O  
ATOM    150  CB  LEU    43      -4.357  -4.340  54.851  1.00 27.64           C  
ATOM    151  CG  LEU    43      -3.543  -5.187  55.878  1.00 28.07           C  
ATOM    152  CD1 LEU    43      -4.447  -5.675  57.026  1.00 28.03           C  
ATOM    153  CD2 LEU    43      -2.696  -6.319  55.219  1.00 26.79           C  
ATOM    154  N   VAL    44      -3.038  -1.578  55.598  1.00 25.32           N  
ATOM    155  CA  VAL    44      -2.092  -0.803  56.424  1.00 27.38           C  
ATOM    156  C   VAL    44      -2.810   0.307  57.189  1.00 28.00           C  
ATOM    157  O   VAL    44      -2.476   0.543  58.374  1.00 28.99           O  
ATOM    158  CB  VAL    44      -0.938  -0.208  55.564  1.00 26.93           C  
ATOM    159  CG1 VAL    44      -0.058   0.721  56.426  1.00 25.38           C  
ATOM    160  CG2 VAL    44      -0.085  -1.372  54.916  1.00 26.21           C  
ATOM    161  N   SER    45      -3.758   1.019  56.558  0.50 29.31           N  
ATOM    163  CA  SER    45      -4.530   2.069  57.290  0.50 28.98           C  
ATOM    165  C   SER    45      -5.204   1.510  58.552  0.50 30.14           C  
ATOM    167  O   SER    45      -5.327   2.219  59.557  0.50 28.81           O  
ATOM    169  CB  SER    45      -5.610   2.739  56.415  0.50 29.99           C  
ATOM    171  OG  SER    45      -6.666   1.839  56.087  0.50 26.42           O  
ATOM    173  N   GLU    46      -5.603   0.235  58.518  1.00 29.41           N  
ATOM    174  CA  GLU    46      -6.333  -0.365  59.663  1.00 30.42           C  
ATOM    175  C   GLU    46      -5.380  -1.115  60.592  1.00 30.61           C  
ATOM    176  O   GLU    46      -5.800  -1.893  61.437  1.00 32.07           O  
ATOM    177  CB  GLU    46      -7.385  -1.351  59.122  1.00 29.60           C  
ATOM    178  CG  GLU    46      -8.561  -0.603  58.445  1.00 30.64           C  
ATOM    179  CD  GLU    46      -9.644  -1.536  57.896  1.00 33.95           C  
ATOM    180  OE1 GLU    46      -9.492  -2.770  58.054  1.00 35.13           O  
ATOM    181  OE2 GLU    46     -10.681  -1.019  57.398  1.00 37.39           O  
ATOM    182  N   CYS    47      -4.082  -0.928  60.402  1.00 29.99           N  
ATOM    183  CA  CYS    47      -3.106  -1.482  61.336  1.00 32.22           C  
ATOM    184  C   CYS    47      -2.233  -0.385  61.990  1.00 33.20           C  
ATOM    185  O   CYS    47      -0.989  -0.469  61.869  1.00 34.01           O  
ATOM    186  CB  CYS    47      -2.151  -2.416  60.602  1.00 31.67           C  
ATOM    187  SG  CYS    47      -2.907  -3.952  59.988  1.00 35.54           S  
ATOM    188  N   PRO    48      -2.848   0.636  62.636  1.00 34.49           N  
ATOM    189  CA  PRO    48      -1.960   1.588  63.288  1.00 36.81           C  
ATOM    190  C   PRO    48      -1.179   0.786  64.356  1.00 38.94           C  
ATOM    191  O   PRO    48      -1.737  -0.126  64.961  1.00 40.76           O  
ATOM    192  CB  PRO    48      -2.923   2.615  63.920  1.00 36.20           C  
ATOM    193  CG  PRO    48      -4.289   1.884  64.025  1.00 35.83           C  
ATOM    194  CD  PRO    48      -4.276   0.968  62.844  1.00 33.95           C  
ATOM    195  N   PRO    49       0.079   1.149  64.617  1.00 39.35           N  
ATOM    196  CA  PRO    49       0.663   2.420  64.271  1.00 38.77           C  
ATOM    197  C   PRO    49       1.584   2.354  63.048  1.00 37.29           C  
ATOM    198  O   PRO    49       2.427   3.245  62.892  1.00 37.46           O  
ATOM    199  CB  PRO    49       1.470   2.748  65.541  1.00 40.01           C  
ATOM    200  CG  PRO    49       2.034   1.303  65.928  1.00 40.37           C  
ATOM    201  CD  PRO    49       1.058   0.279  65.304  1.00 41.34           C  
ATOM    202  N   LEU    50       1.450   1.339  62.184  1.00 33.60           N  
ATOM    203  CA  LEU    50       2.284   1.281  60.981  1.00 31.37           C  
ATOM    204  C   LEU    50       2.182   2.631  60.288  1.00 31.20           C  
ATOM    205  O   LEU    50       1.073   3.172  60.214  1.00 29.83           O  
ATOM    206  CB  LEU    50       1.787   0.209  59.982  1.00 30.89           C  
ATOM    207  CG  LEU    50       2.256  -1.240  60.149  1.00 35.36           C  
ATOM    208  CD1 LEU    50       1.696  -2.152  58.999  1.00 34.13           C  
ATOM    209  CD2 LEU    50       3.791  -1.342  60.257  1.00 39.60           C  
ATOM    210  N   ASP    51       3.285   3.131  59.727  1.00 30.23           N  
ATOM    211  CA  ASP    51       3.265   4.391  58.953  1.00 32.14           C  
ATOM    212  C   ASP    51       2.478   4.083  57.654  1.00 32.72           C  
ATOM    213  O   ASP    51       2.745   3.101  56.961  1.00 33.65           O  
ATOM    214  CB  ASP    51       4.700   4.857  58.586  1.00 32.53           C  
ATOM    215  CG  ASP    51       5.532   5.165  59.820  1.00 36.98           C  
ATOM    216  OD1 ASP    51       4.926   5.494  60.883  1.00 37.69           O  
ATOM    217  OD2 ASP    51       6.775   5.045  59.780  1.00 40.44           O  
ATOM    218  N   LEU    52       1.508   4.921  57.326  1.00 32.10           N  
ATOM    219  CA  LEU    52       0.755   4.713  56.085  1.00 31.13           C  
ATOM    220  C   LEU    52       1.502   5.463  54.972  1.00 30.90           C  
ATOM    221  O   LEU    52       2.012   6.533  55.194  1.00 36.52           O  
ATOM    222  CB  LEU    52      -0.616   5.308  56.262  1.00 32.12           C  
ATOM    223  CG  LEU    52      -1.594   5.045  55.104  1.00 31.45           C  
ATOM    224  CD1 LEU    52      -1.847   3.528  54.862  1.00 31.65           C  
ATOM    225  CD2 LEU    52      -2.930   5.737  55.507  1.00 29.87           C  
ATOM    226  N   ASN    53       1.700   4.857  53.830  1.00 28.39           N  
ATOM    227  CA  ASN    53       2.218   5.593  52.673  1.00 26.31           C  
ATOM    228  C   ASN    53       1.104   5.797  51.683  1.00 26.38           C  
ATOM    229  O   ASN    53      -0.011   5.313  51.913  1.00 25.57           O  
ATOM    230  CB  ASN    53       3.383   4.793  52.074  1.00 25.78           C  
ATOM    231  CG  ASN    53       4.546   4.710  53.057  1.00 27.10           C  
ATOM    232  OD1 ASN    53       5.246   5.690  53.267  1.00 26.14           O  
ATOM    233  ND2 ASN    53       4.730   3.537  53.722  1.00 24.92           N  
ATOM    234  N   SER    54       1.383   6.532  50.596  1.00 25.16           N  
ATOM    235  CA  SER    54       0.354   6.835  49.608  1.00 25.16           C  
ATOM    236  C   SER    54      -0.118   5.530  48.964  1.00 23.53           C  
ATOM    237  O   SER    54       0.604   4.507  48.912  1.00 25.73           O  
ATOM    238  CB  SER    54       0.928   7.784  48.521  1.00 24.19           C  
ATOM    239  OG  SER    54       1.966   7.067  47.822  1.00 26.19           O  
ATOM    240  N   LEU    55      -1.303   5.553  48.411  1.00 23.74           N  
ATOM    241  CA  LEU    55      -1.746   4.390  47.605  1.00 25.96           C  
ATOM    242  C   LEU    55      -0.731   3.952  46.558  1.00 25.61           C  
ATOM    243  O   LEU    55      -0.473   2.753  46.399  1.00 23.93           O  
ATOM    244  CB  LEU    55      -3.088   4.685  46.939  1.00 26.47           C  
ATOM    245  CG  LEU    55      -3.615   3.669  45.903  1.00 29.78           C  
ATOM    246  CD1 LEU    55      -3.842   2.311  46.576  1.00 28.35           C  
ATOM    247  CD2 LEU    55      -4.939   4.191  45.224  1.00 28.94           C  
ATOM    248  N   TYR    56      -0.213   4.934  45.826  1.00 25.77           N  
ATOM    249  CA  TYR    56       0.735   4.673  44.780  1.00 27.07           C  
ATOM    250  C   TYR    56       1.969   3.962  45.279  1.00 25.81           C  
ATOM    251  O   TYR    56       2.496   3.114  44.599  1.00 25.80           O  
ATOM    252  CB  TYR    56       1.128   6.024  44.188  1.00 29.90           C  
ATOM    253  CG  TYR    56       1.860   5.905  42.933  1.00 34.30           C  
ATOM    254  CD1 TYR    56       3.208   6.312  42.863  1.00 36.92           C  
ATOM    255  CD2 TYR    56       1.239   5.418  41.780  1.00 35.76           C  
ATOM    256  CE1 TYR    56       3.924   6.250  41.701  1.00 37.66           C  
ATOM    257  CE2 TYR    56       1.978   5.346  40.576  1.00 41.36           C  
ATOM    258  CZ  TYR    56       3.330   5.756  40.563  1.00 38.17           C  
ATOM    259  OH  TYR    56       4.107   5.744  39.401  1.00 37.72           O  
ATOM    260  N   ALA    57       2.430   4.245  46.498  1.00 24.29           N  
ATOM    261  CA  ALA    57       3.600   3.522  47.027  1.00 24.86           C  
ATOM    262  C   ALA    57       3.300   2.043  47.112  1.00 26.52           C  
ATOM    263  O   ALA    57       4.136   1.206  46.742  1.00 24.62           O  
ATOM    264  CB  ALA    57       4.022   4.041  48.460  1.00 25.11           C  
ATOM    265  N   TYR    58       2.085   1.677  47.549  1.00 25.92           N  
ATOM    266  CA  TYR    58       1.745   0.230  47.523  1.00 25.14           C  
ATOM    267  C   TYR    58       1.544  -0.336  46.094  1.00 25.37           C  
ATOM    268  O   TYR    58       1.884  -1.535  45.820  1.00 26.48           O  
ATOM    269  CB  TYR    58       0.500  -0.037  48.415  1.00 25.30           C  
ATOM    270  CG  TYR    58       0.848   0.366  49.838  1.00 24.22           C  
ATOM    271  CD1 TYR    58       1.712  -0.443  50.613  1.00 26.80           C  
ATOM    272  CD2 TYR    58       0.434   1.600  50.358  1.00 25.73           C  
ATOM    273  CE1 TYR    58       2.119  -0.052  51.862  1.00 24.96           C  
ATOM    274  CE2 TYR    58       0.829   1.997  51.651  1.00 27.42           C  
ATOM    275  CZ  TYR    58       1.666   1.198  52.361  1.00 26.68           C  
ATOM    276  OH  TYR    58       2.082   1.580  53.589  1.00 26.33           O  
ATOM    277  N   LEU    59       0.993   0.480  45.187  1.00 25.53           N  
ATOM    278  CA  LEU    59       0.833   0.052  43.768  1.00 26.65           C  
ATOM    279  C   LEU    59       2.180  -0.248  43.202  1.00 26.90           C  
ATOM    280  O   LEU    59       2.289  -1.219  42.440  1.00 27.73           O  
ATOM    281  CB  LEU    59       0.110   1.081  42.870  1.00 25.95           C  
ATOM    282  CG  LEU    59      -1.395   1.257  43.234  1.00 30.17           C  
ATOM    283  CD1 LEU    59      -1.913   2.436  42.477  1.00 30.73           C  
ATOM    284  CD2 LEU    59      -2.152  -0.020  42.880  1.00 32.85           C  
ATOM    285  N   LEU    60       3.190   0.583  43.522  1.00 26.74           N  
ATOM    286  CA  LEU    60       4.537   0.344  43.009  1.00 28.23           C  
ATOM    287  C   LEU    60       5.175  -0.951  43.581  1.00 26.91           C  
ATOM    288  O   LEU    60       5.850  -1.697  42.847  1.00 28.49           O  
ATOM    289  CB  LEU    60       5.481   1.514  43.288  1.00 27.52           C  
ATOM    290  CG  LEU    60       5.028   2.794  42.542  1.00 31.15           C  
ATOM    291  CD1 LEU    60       6.040   3.877  42.820  1.00 34.27           C  
ATOM    292  CD2 LEU    60       4.895   2.517  41.057  1.00 34.78           C  
ATOM    293  N   LEU    61       4.973  -1.228  44.867  1.00 25.66           N  
ATOM    294  CA  LEU    61       5.355  -2.555  45.438  1.00 25.96           C  
ATOM    295  C   LEU    61       4.708  -3.706  44.668  1.00 27.92           C  
ATOM    296  O   LEU    61       5.395  -4.736  44.312  1.00 26.78           O  
ATOM    297  CB  LEU    61       5.011  -2.631  46.981  1.00 24.03           C  
ATOM    298  CG  LEU    61       5.942  -1.738  47.856  1.00 27.40           C  
ATOM    299  CD1 LEU    61       5.388  -1.555  49.258  1.00 29.42           C  
ATOM    300  CD2 LEU    61       7.378  -2.403  47.930  1.00 29.76           C  
ATOM    301  N   CYS    62       3.395  -3.594  44.426  1.00 28.08           N  
ATOM    302  CA  CYS    62       2.709  -4.622  43.669  1.00 29.95           C  
ATOM    303  C   CYS    62       3.240  -4.775  42.244  1.00 29.03           C  
ATOM    304  O   CYS    62       3.299  -5.879  41.711  1.00 30.81           O  
ATOM    305  CB  CYS    62       1.200  -4.301  43.597  1.00 27.81           C  
ATOM    306  SG  CYS    62       0.452  -4.497  45.273  1.00 32.08           S  
ATOM    307  N   GLU    63       3.606  -3.660  41.614  1.00 28.85           N  
ATOM    308  CA  GLU    63       3.984  -3.672  40.209  1.00 28.77           C  
ATOM    309  C   GLU    63       5.464  -4.057  40.035  1.00 29.21           C  
ATOM    310  O   GLU    63       5.824  -4.806  39.069  1.00 30.46           O  
ATOM    311  CB  GLU    63       3.736  -2.269  39.615  1.00 29.21           C  
ATOM    312  CG  GLU    63       4.011  -2.222  38.117  1.00 37.67           C  
ATOM    313  CD  GLU    63       2.831  -2.733  37.311  1.00 42.55           C  
ATOM    314  OE1 GLU    63       1.874  -3.245  37.919  1.00 43.83           O  
ATOM    315  OE2 GLU    63       2.830  -2.605  36.080  1.00 47.33           O  
ATOM    316  N   HIS    64       6.324  -3.604  40.928  1.00 28.30           N  
ATOM    317  CA  HIS    64       7.798  -3.733  40.703  1.00 29.07           C  
ATOM    318  C   HIS    64       8.499  -4.765  41.608  1.00 29.26           C  
ATOM    319  O   HIS    64       9.634  -5.197  41.280  1.00 28.57           O  
ATOM    320  CB  HIS    64       8.479  -2.370  40.822  1.00 29.01           C  
ATOM    321  CG  HIS    64       7.974  -1.362  39.825  1.00 28.49           C  
ATOM    322  ND1 HIS    64       7.936  -0.007  40.081  1.00 28.38           N  
ATOM    323  CD2 HIS    64       7.526  -1.515  38.553  1.00 24.53           C  
ATOM    324  CE1 HIS    64       7.455   0.620  39.020  1.00 28.14           C  
ATOM    325  NE2 HIS    64       7.188  -0.268  38.084  1.00 28.59           N  
ATOM    326  N   HIS    65       7.854  -5.122  42.726  1.00 28.00           N  
ATOM    327  CA  HIS    65       8.482  -5.882  43.853  1.00 28.52           C  
ATOM    328  C   HIS    65       7.629  -7.053  44.246  1.00 29.11           C  
ATOM    329  O   HIS    65       7.776  -7.583  45.340  1.00 29.42           O  
ATOM    330  CB  HIS    65       8.708  -4.968  45.082  1.00 28.44           C  
ATOM    331  CG  HIS    65       9.696  -3.874  44.804  1.00 29.33           C  
ATOM    332  ND1 HIS    65      11.035  -4.127  44.603  1.00 30.49           N  
ATOM    333  CD2 HIS    65       9.524  -2.546  44.570  1.00 32.03           C  
ATOM    334  CE1 HIS    65      11.659  -2.990  44.321  1.00 31.66           C  
ATOM    335  NE2 HIS    65      10.761  -2.018  44.311  1.00 32.48           N  
ATOM    336  N   ALA    66       6.734  -7.501  43.352  1.00 28.97           N  
ATOM    337  CA  ALA    66       5.850  -8.614  43.755  1.00 27.60           C  
ATOM    338  C   ALA    66       6.614  -9.902  44.162  1.00 29.41           C  
ATOM    339  O   ALA    66       6.172 -10.655  45.061  1.00 28.82           O  
ATOM    340  CB  ALA    66       4.854  -8.887  42.644  1.00 29.50           C  
ATOM    341  N   HIS    67       7.765 -10.160  43.534  0.60 29.35           N  
ATOM    343  CA  HIS    67       8.490 -11.416  43.798  0.60 30.73           C  
ATOM    345  C   HIS    67       9.115 -11.457  45.178  0.60 30.25           C  
ATOM    347  O   HIS    67       9.508 -12.513  45.645  0.60 29.91           O  
ATOM    349  CB  HIS    67       9.601 -11.631  42.783  0.60 32.25           C  
ATOM    351  CG  HIS    67       9.125 -11.876  41.394  0.60 35.76           C  
ATOM    353  ND1 HIS    67       9.303 -10.959  40.383  0.60 39.69           N  
ATOM    355  CD2 HIS    67       8.568 -12.969  40.819  0.60 39.60           C  
ATOM    357  CE1 HIS    67       8.837 -11.458  39.250  0.60 41.13           C  
ATOM    359  NE2 HIS    67       8.387 -12.677  39.488  0.60 41.48           N  
ATOM    361  N   THR    68       9.227 -10.300  45.818  1.00 28.53           N  
ATOM    362  CA  THR    68       9.747 -10.240  47.181  1.00 28.06           C  
ATOM    363  C   THR    68       8.708  -9.731  48.208  1.00 28.01           C  
ATOM    364  O   THR    68       9.051  -9.481  49.362  1.00 29.14           O  
ATOM    365  CB  THR    68      11.022  -9.397  47.274  1.00 30.04           C  
ATOM    366  OG1 THR    68      10.771  -8.060  46.762  1.00 26.74           O  
ATOM    367  CG2 THR    68      12.220 -10.011  46.441  1.00 31.60           C  
ATOM    368  N   CYS    69       7.443  -9.633  47.826  1.00 27.30           N  
ATOM    369  CA  CYS    69       6.393  -9.288  48.810  1.00 26.87           C  
ATOM    370  C   CYS    69       5.367 -10.433  48.918  1.00 25.92           C  
ATOM    371  O   CYS    69       5.385 -11.363  48.094  1.00 26.43           O  
ATOM    372  CB  CYS    69       5.655  -8.042  48.334  1.00 27.03           C  
ATOM    373  SG  CYS    69       6.671  -6.537  48.199  1.00 29.52           S  
ATOM    374  N   VAL    70       4.429 -10.329  49.868  1.00 25.15           N  
ATOM    375  CA  VAL    70       3.463 -11.459  50.034  1.00 25.33           C  
ATOM    376  C   VAL    70       2.195 -10.879  50.632  1.00 25.27           C  
ATOM    377  O   VAL    70       2.272  -9.847  51.365  1.00 26.70           O  
ATOM    378  CB  VAL    70       4.081 -12.638  50.878  1.00 25.62           C  
ATOM    379  CG1 VAL    70       4.301 -12.275  52.327  1.00 26.59           C  
ATOM    380  CG2 VAL    70       3.183 -13.910  50.750  1.00 25.43           C  
ATOM    381  N   VAL    71       1.076 -11.429  50.234  1.00 25.73           N  
ATOM    382  CA  VAL    71      -0.190 -11.197  50.993  1.00 27.02           C  
ATOM    383  C   VAL    71      -0.700 -12.493  51.564  1.00 26.89           C  
ATOM    384  O   VAL    71      -0.501 -13.535  50.944  1.00 27.92           O  
ATOM    385  CB  VAL    71      -1.297 -10.555  50.119  1.00 27.88           C  
ATOM    386  CG1 VAL    71      -0.903  -9.120  49.756  1.00 26.55           C  
ATOM    387  CG2 VAL    71      -1.611 -11.366  48.866  1.00 27.07           C  
ATOM    388  N   ALA    72      -1.436 -12.405  52.674  1.00 27.30           N  
ATOM    389  CA  ALA    72      -2.130 -13.502  53.312  1.00 27.72           C  
ATOM    390  C   ALA    72      -3.597 -13.243  52.984  1.00 27.98           C  
ATOM    391  O   ALA    72      -4.143 -12.189  53.353  1.00 27.81           O  
ATOM    392  CB  ALA    72      -1.937 -13.486  54.849  1.00 27.15           C  
ATOM    393  N   GLU    73      -4.209 -14.196  52.308  1.00 26.27           N  
ATOM    394  CA  GLU    73      -5.556 -14.020  51.806  1.00 28.32           C  
ATOM    395  C   GLU    73      -6.515 -15.094  52.303  1.00 29.00           C  
ATOM    396  O   GLU    73      -6.209 -16.299  52.198  1.00 28.41           O  
ATOM    397  CB  GLU    73      -5.467 -14.007  50.255  1.00 28.70           C  
ATOM    398  CG  GLU    73      -6.788 -13.841  49.492  1.00 28.92           C  
ATOM    399  CD  GLU    73      -6.522 -13.641  47.984  1.00 32.45           C  
ATOM    400  OE1 GLU    73      -6.024 -14.571  47.289  1.00 27.94           O  
ATOM    401  OE2 GLU    73      -6.801 -12.538  47.503  1.00 34.45           O  
ATOM    402  N   SER    74      -7.731 -14.693  52.694  1.00 29.53           N  
ATOM    403  CA  SER    74      -8.765 -15.673  53.061  1.00 29.75           C  
ATOM    404  C   SER    74      -9.286 -16.458  51.828  1.00 30.06           C  
ATOM    405  O   SER    74      -9.107 -16.011  50.712  1.00 27.77           O  
ATOM    406  CB  SER    74      -9.936 -14.966  53.732  1.00 30.66           C  
ATOM    407  OG  SER    74     -10.589 -14.116  52.794  1.00 33.06           O  
ATOM    408  N   PRO    75      -9.921 -17.647  52.036  1.00 30.63           N  
ATOM    409  CA  PRO    75     -10.562 -18.396  50.904  1.00 30.69           C  
ATOM    410  C   PRO    75     -11.463 -17.474  50.086  1.00 30.82           C  
ATOM    411  O   PRO    75     -11.449 -17.542  48.834  1.00 29.53           O  
ATOM    412  CB  PRO    75     -11.374 -19.484  51.618  1.00 31.01           C  
ATOM    413  CG  PRO    75     -10.601 -19.760  52.810  1.00 30.29           C  
ATOM    414  CD  PRO    75     -10.043 -18.416  53.293  1.00 31.30           C  
ATOM    415  N   GLY    76     -12.172 -16.591  50.798  1.00 30.96           N  
ATOM    416  CA  GLY    76     -13.011 -15.519  50.207  1.00 30.50           C  
ATOM    417  C   GLY    76     -12.343 -14.319  49.514  1.00 31.46           C  
ATOM    418  O   GLY    76     -13.030 -13.535  48.852  1.00 30.66           O  
ATOM    419  N   GLY    77     -11.023 -14.190  49.598  1.00 29.19           N  
ATOM    420  CA  GLY    77     -10.339 -13.232  48.775  1.00 29.58           C  
ATOM    421  C   GLY    77     -10.040 -11.977  49.572  1.00 29.53           C  
ATOM    422  O   GLY    77      -9.684 -10.958  48.995  1.00 31.79           O  
ATOM    423  N   ARG    78     -10.136 -12.044  50.913  1.00 28.48           N  
ATOM    424  CA  ARG    78      -9.873 -10.848  51.727  1.00 29.09           C  
ATOM    425  C   ARG    78      -8.425 -10.891  52.217  1.00 27.79           C  
ATOM    426  O   ARG    78      -7.982 -11.872  52.839  1.00 28.43           O  
ATOM    427  CB  ARG    78     -10.794 -10.803  52.962  1.00 29.24           C  
ATOM    428  CG  ARG    78     -10.674  -9.488  53.783  1.00 29.76           C  
ATOM    429  CD  ARG    78     -11.513  -9.608  55.092  1.00 30.71           C  
ATOM    430  NE  ARG    78     -10.958 -10.669  55.938  1.00 31.17           N  
ATOM    431  CZ  ARG    78     -11.537 -11.832  56.204  1.00 32.87           C  
ATOM    432  NH1 ARG    78     -12.743 -12.132  55.723  1.00 34.43           N  
ATOM    433  NH2 ARG    78     -10.906 -12.702  56.957  1.00 36.64           N  
ATOM    434  N   ILE    79      -7.719  -9.822  51.981  1.00 27.39           N  
ATOM    435  CA  ILE    79      -6.320  -9.697  52.406  1.00 27.72           C  
ATOM    436  C   ILE    79      -6.230  -9.202  53.849  1.00 28.74           C  
ATOM    437  O   ILE    79      -6.599  -8.039  54.157  1.00 28.27           O  
ATOM    438  CB  ILE    79      -5.556  -8.770  51.429  1.00 28.98           C  
ATOM    439  CG1 ILE    79      -5.429  -9.520  50.075  1.00 30.29           C  
ATOM    440  CG2 ILE    79      -4.118  -8.429  51.986  1.00 27.53           C  
ATOM    441  CD1 ILE    79      -4.862  -8.613  48.923  1.00 30.41           C  
ATOM    442  N   ASP    80      -5.729 -10.056  54.735  1.00 27.45           N  
ATOM    443  CA  ASP    80      -5.560  -9.637  56.133  1.00 28.66           C  
ATOM    444  C   ASP    80      -4.080  -9.556  56.572  1.00 27.12           C  
ATOM    445  O   ASP    80      -3.786  -9.295  57.764  1.00 27.99           O  
ATOM    446  CB  ASP    80      -6.302 -10.598  57.051  1.00 28.86           C  
ATOM    447  CG  ASP    80      -7.819 -10.442  56.983  1.00 29.39           C  
ATOM    448  OD1 ASP    80      -8.371  -9.422  56.491  1.00 31.63           O  
ATOM    449  OD2 ASP    80      -8.446 -11.373  57.460  1.00 30.70           O  
ATOM    450  N   GLY    81      -3.150  -9.804  55.643  1.00 26.73           N  
ATOM    451  CA  GLY    81      -1.699  -9.790  56.013  1.00 26.35           C  
ATOM    452  C   GLY    81      -0.916  -9.287  54.805  1.00 27.06           C  
ATOM    453  O   GLY    81      -1.327  -9.574  53.665  1.00 27.66           O  
ATOM    454  N   PHE    82       0.183  -8.565  55.018  1.00 26.51           N  
ATOM    455  CA  PHE    82       1.040  -8.138  53.891  1.00 26.78           C  
ATOM    456  C   PHE    82       2.436  -7.997  54.438  1.00 26.45           C  
ATOM    457  O   PHE    82       2.606  -7.593  55.582  1.00 26.97           O  
ATOM    458  CB  PHE    82       0.543  -6.776  53.385  1.00 25.55           C  
ATOM    459  CG  PHE    82       1.472  -6.089  52.406  1.00 26.55           C  
ATOM    460  CD1 PHE    82       1.701  -6.630  51.137  1.00 26.94           C  
ATOM    461  CD2 PHE    82       2.056  -4.829  52.727  1.00 28.61           C  
ATOM    462  CE1 PHE    82       2.527  -6.009  50.209  1.00 29.39           C  
ATOM    463  CE2 PHE    82       2.893  -4.208  51.782  1.00 28.58           C  
ATOM    464  CZ  PHE    82       3.100  -4.773  50.523  1.00 30.95           C  
ATOM    465  N   VAL    83       3.420  -8.399  53.654  1.00 24.94           N  
ATOM    466  CA  VAL    83       4.809  -8.007  53.940  1.00 25.26           C  
ATOM    467  C   VAL    83       5.398  -7.337  52.693  1.00 26.55           C  
ATOM    468  O   VAL    83       5.277  -7.916  51.586  1.00 27.21           O  
ATOM    469  CB  VAL    83       5.703  -9.191  54.368  1.00 25.08           C  
ATOM    470  CG1 VAL    83       7.258  -8.668  54.534  1.00 23.40           C  
ATOM    471  CG2 VAL    83       5.138  -9.776  55.714  1.00 24.17           C  
ATOM    472  N   SER    84       6.012  -6.150  52.867  1.00 26.00           N  
ATOM    473  CA  SER    84       6.812  -5.520  51.787  1.00 25.97           C  
ATOM    474  C   SER    84       8.260  -5.738  52.063  1.00 26.57           C  
ATOM    475  O   SER    84       8.708  -5.526  53.197  1.00 25.75           O  
ATOM    476  CB  SER    84       6.584  -4.009  51.689  1.00 25.69           C  
ATOM    477  OG  SER    84       6.566  -3.433  52.995  1.00 29.89           O  
ATOM    478  N   ALA    85       8.981  -6.155  51.036  1.00 27.38           N  
ATOM    479  CA  ALA    85      10.420  -6.409  51.144  1.00 27.43           C  
ATOM    480  C   ALA    85      11.047  -6.303  49.764  1.00 27.99           C  
ATOM    481  O   ALA    85      10.339  -6.409  48.746  1.00 25.90           O  
ATOM    482  CB  ALA    85      10.675  -7.820  51.749  1.00 26.76           C  
ATOM    483  N   TYR    86      12.373  -6.084  49.720  1.00 26.25           N  
ATOM    484  CA  TYR    86      13.085  -6.054  48.473  1.00 27.19           C  
ATOM    485  C   TYR    86      14.542  -6.332  48.753  1.00 27.01           C  
ATOM    486  O   TYR    86      15.039  -6.099  49.872  1.00 25.54           O  
ATOM    487  CB  TYR    86      12.930  -4.690  47.804  1.00 27.19           C  
ATOM    488  CG  TYR    86      13.222  -3.493  48.675  1.00 27.65           C  
ATOM    489  CD1 TYR    86      14.527  -2.921  48.729  1.00 26.43           C  
ATOM    490  CD2 TYR    86      12.210  -2.877  49.401  1.00 27.98           C  
ATOM    491  CE1 TYR    86      14.770  -1.791  49.539  1.00 29.99           C  
ATOM    492  CE2 TYR    86      12.431  -1.733  50.185  1.00 30.16           C  
ATOM    493  CZ  TYR    86      13.720  -1.206  50.246  1.00 32.84           C  
ATOM    494  OH  TYR    86      13.937  -0.089  51.017  1.00 30.48           O  
ATOM    495  N   LEU    87      15.214  -6.879  47.759  1.00 26.78           N  
ATOM    496  CA  LEU    87      16.639  -7.019  47.832  1.00 28.40           C  
ATOM    497  C   LEU    87      17.296  -5.651  47.732  1.00 29.06           C  
ATOM    498  O   LEU    87      16.846  -4.805  46.947  1.00 29.51           O  
ATOM    499  CB  LEU    87      17.116  -7.862  46.641  1.00 30.26           C  
ATOM    500  CG  LEU    87      16.613  -9.329  46.576  1.00 29.46           C  
ATOM    501  CD1 LEU    87      17.072 -10.058  45.319  1.00 32.72           C  
ATOM    502  CD2 LEU    87      16.986 -10.139  47.841  1.00 31.05           C  
ATOM    503  N   LEU    88      18.399  -5.442  48.443  1.00 28.70           N  
ATOM    504  CA  LEU    88      19.029  -4.130  48.394  1.00 28.59           C  
ATOM    505  C   LEU    88      19.777  -4.026  47.070  1.00 30.73           C  
ATOM    506  O   LEU    88      20.589  -4.925  46.752  1.00 29.24           O  
ATOM    507  CB  LEU    88      19.982  -3.936  49.566  1.00 28.02           C  
ATOM    508  CG  LEU    88      19.293  -3.794  50.934  1.00 28.39           C  
ATOM    509  CD1 LEU    88      20.279  -3.314  52.018  1.00 28.39           C  
ATOM    510  CD2 LEU    88      18.090  -2.853  50.809  1.00 26.20           C  
ATOM    511  N   PRO    89      19.537  -2.943  46.296  1.00 30.42           N  
ATOM    512  CA  PRO    89      20.219  -2.804  45.014  1.00 32.20           C  
ATOM    513  C   PRO    89      21.762  -2.825  45.095  1.00 32.91           C  
ATOM    514  O   PRO    89      22.425  -3.382  44.199  1.00 33.87           O  
ATOM    515  CB  PRO    89      19.708  -1.448  44.501  1.00 32.80           C  
ATOM    516  CG  PRO    89      18.473  -1.242  45.189  1.00 31.04           C  
ATOM    517  CD  PRO    89      18.620  -1.817  46.540  1.00 31.51           C  
ATOM    518  N   THR    90      22.337  -2.280  46.161  1.00 32.94           N  
ATOM    519  CA  THR    90      23.789  -2.281  46.248  1.00 34.09           C  
ATOM    520  C   THR    90      24.321  -3.484  47.014  1.00 34.35           C  
ATOM    521  O   THR    90      25.531  -3.772  46.941  1.00 33.12           O  
ATOM    522  CB  THR    90      24.364  -1.030  46.892  1.00 34.66           C  
ATOM    523  OG1 THR    90      23.788  -0.864  48.187  1.00 36.62           O  
ATOM    524  CG2 THR    90      24.133   0.240  46.006  1.00 37.20           C  
ATOM    525  N   ARG    91      23.439  -4.200  47.712  1.00 34.03           N  
ATOM    526  CA  ARG    91      23.827  -5.406  48.446  1.00 34.30           C  
ATOM    527  C   ARG    91      22.786  -6.492  48.219  1.00 33.97           C  
ATOM    528  O   ARG    91      21.987  -6.779  49.116  1.00 33.10           O  
ATOM    529  CB  ARG    91      23.918  -5.099  49.926  1.00 35.32           C  
ATOM    530  CG  ARG    91      25.038  -4.153  50.228  1.00 39.65           C  
ATOM    531  CD  ARG    91      25.081  -3.830  51.694  1.00 45.30           C  
ATOM    532  NE  ARG    91      24.050  -2.895  52.145  1.00 49.53           N  
ATOM    533  CZ  ARG    91      23.387  -3.038  53.299  1.00 51.32           C  
ATOM    534  NH1 ARG    91      23.644  -4.086  54.070  1.00 49.57           N  
ATOM    535  NH2 ARG    91      22.462  -2.149  53.688  1.00 50.88           N  
ATOM    536  N   PRO    92      22.792  -7.093  47.026  1.00 33.68           N  
ATOM    537  CA  PRO    92      21.701  -7.972  46.605  1.00 34.12           C  
ATOM    538  C   PRO    92      21.529  -9.270  47.384  1.00 33.82           C  
ATOM    539  O   PRO    92      20.458  -9.870  47.262  1.00 34.58           O  
ATOM    540  CB  PRO    92      21.993  -8.218  45.119  1.00 34.48           C  
ATOM    541  CG  PRO    92      23.428  -7.960  44.972  1.00 33.03           C  
ATOM    542  CD  PRO    92      23.810  -6.941  45.975  1.00 33.84           C  
ATOM    543  N   ASP    93      22.505  -9.659  48.225  1.00 32.31           N  
ATOM    544  CA  ASP    93      22.354 -10.778  49.163  1.00 31.47           C  
ATOM    545  C   ASP    93      21.700 -10.408  50.513  1.00 30.90           C  
ATOM    546  O   ASP    93      21.653 -11.211  51.457  1.00 28.55           O  
ATOM    547  CB  ASP    93      23.721 -11.478  49.413  1.00 33.27           C  
ATOM    548  CG  ASP    93      24.676 -10.625  50.245  1.00 36.78           C  
ATOM    549  OD1 ASP    93      24.443  -9.409  50.429  1.00 40.28           O  
ATOM    550  OD2 ASP    93      25.710 -11.163  50.697  1.00 43.64           O  
ATOM    551  N   VAL    94      21.249  -9.162  50.603  1.00 28.87           N  
ATOM    552  CA  VAL    94      20.457  -8.699  51.733  1.00 28.13           C  
ATOM    553  C   VAL    94      18.981  -8.470  51.323  1.00 28.96           C  
ATOM    554  O   VAL    94      18.695  -7.666  50.418  1.00 28.15           O  
ATOM    555  CB  VAL    94      21.014  -7.370  52.297  1.00 27.32           C  
ATOM    556  CG1 VAL    94      20.109  -6.882  53.458  1.00 27.98           C  
ATOM    557  CG2 VAL    94      22.492  -7.527  52.792  1.00 29.25           C  
ATOM    558  N   LEU    95      18.049  -9.079  52.061  1.00 26.89           N  
ATOM    559  CA  LEU    95      16.633  -8.800  51.864  1.00 26.64           C  
ATOM    560  C   LEU    95      16.230  -7.805  52.970  1.00 27.06           C  
ATOM    561  O   LEU    95      16.477  -8.060  54.160  1.00 28.69           O  
ATOM    562  CB  LEU    95      15.839 -10.098  52.041  1.00 26.26           C  
ATOM    563  CG  LEU    95      14.311  -9.916  51.928  1.00 25.34           C  
ATOM    564  CD1 LEU    95      13.952  -9.685  50.455  1.00 26.94           C  
ATOM    565  CD2 LEU    95      13.604 -11.178  52.432  1.00 32.15           C  
ATOM    566  N   PHE    96      15.679  -6.662  52.566  1.00 27.52           N  
ATOM    567  CA  PHE    96      15.202  -5.675  53.517  1.00 27.55           C  
ATOM    568  C   PHE    96      13.662  -5.765  53.640  1.00 27.78           C  
ATOM    569  O   PHE    96      13.003  -5.745  52.644  1.00 26.91           O  
ATOM    570  CB  PHE    96      15.624  -4.282  53.085  1.00 26.56           C  
ATOM    571  CG  PHE    96      15.205  -3.242  54.081  1.00 30.36           C  
ATOM    572  CD1 PHE    96      15.994  -2.996  55.197  1.00 29.09           C  
ATOM    573  CD2 PHE    96      14.000  -2.540  53.906  1.00 30.48           C  
ATOM    574  CE1 PHE    96      15.624  -2.047  56.130  1.00 31.88           C  
ATOM    575  CE2 PHE    96      13.606  -1.623  54.848  1.00 29.42           C  
ATOM    576  CZ  PHE    96      14.449  -1.386  55.971  1.00 30.26           C  
ATOM    577  N   VAL    97      13.159  -5.909  54.858  1.00 27.66           N  
ATOM    578  CA  VAL    97      11.740  -5.976  55.159  1.00 27.14           C  
ATOM    579  C   VAL    97      11.297  -4.597  55.617  1.00 27.86           C  
ATOM    580  O   VAL    97      11.792  -4.058  56.629  1.00 28.05           O  
ATOM    581  CB  VAL    97      11.463  -7.017  56.234  1.00 28.05           C  
ATOM    582  CG1 VAL    97       9.912  -6.967  56.658  1.00 29.13           C  
ATOM    583  CG2 VAL    97      11.846  -8.350  55.699  1.00 25.98           C  
ATOM    584  N   TRP    98      10.354  -4.026  54.869  1.00 28.94           N  
ATOM    585  CA  TRP    98       9.929  -2.623  55.103  1.00 28.42           C  
ATOM    586  C   TRP    98       8.756  -2.633  56.049  1.00 29.26           C  
ATOM    587  O   TRP    98       8.878  -2.057  57.123  1.00 30.60           O  
ATOM    588  CB  TRP    98       9.587  -1.950  53.765  1.00 27.55           C  
ATOM    589  CG  TRP    98       9.016  -0.590  53.807  1.00 29.09           C  
ATOM    590  CD1 TRP    98       8.785   0.229  54.912  1.00 29.88           C  
ATOM    591  CD2 TRP    98       8.665   0.161  52.671  1.00 30.40           C  
ATOM    592  NE1 TRP    98       8.276   1.440  54.481  1.00 31.04           N  
ATOM    593  CE2 TRP    98       8.181   1.403  53.109  1.00 29.25           C  
ATOM    594  CE3 TRP    98       8.633  -0.145  51.311  1.00 29.88           C  
ATOM    595  CZ2 TRP    98       7.711   2.365  52.224  1.00 31.90           C  
ATOM    596  CZ3 TRP    98       8.212   0.814  50.395  1.00 34.17           C  
ATOM    597  CH2 TRP    98       7.725   2.058  50.859  1.00 30.83           C  
ATOM    598  N   GLN    99       7.614  -3.248  55.678  1.00 25.62           N  
ATOM    599  CA  GLN    99       6.445  -3.289  56.588  1.00 26.52           C  
ATOM    600  C   GLN    99       5.901  -4.710  56.728  1.00 28.09           C  
ATOM    601  O   GLN    99       5.874  -5.466  55.739  1.00 27.74           O  
ATOM    602  CB  GLN    99       5.323  -2.376  56.038  1.00 27.16           C  
ATOM    603  CG  GLN    99       5.757  -0.913  56.070  1.00 29.38           C  
ATOM    604  CD  GLN    99       4.585  -0.002  55.814  1.00 31.01           C  
ATOM    605  OE1 GLN    99       3.976  -0.061  54.750  1.00 29.00           O  
ATOM    606  NE2 GLN    99       4.288   0.883  56.780  1.00 29.69           N  
ATOM    607  N   VAL   100       5.489  -5.065  57.952  1.00 27.68           N  
ATOM    608  CA  VAL   100       4.776  -6.322  58.221  1.00 28.76           C  
ATOM    609  C   VAL   100       3.442  -5.927  58.797  1.00 28.50           C  
ATOM    610  O   VAL   100       3.362  -5.389  59.917  1.00 27.91           O  
ATOM    611  CB  VAL   100       5.543  -7.191  59.220  1.00 28.90           C  
ATOM    612  CG1 VAL   100       4.801  -8.560  59.495  1.00 29.29           C  
ATOM    613  CG2 VAL   100       6.949  -7.415  58.687  1.00 29.67           C  
ATOM    614  N   ALA   101       2.389  -6.094  58.015  1.00 28.23           N  
ATOM    615  CA  ALA   101       1.018  -5.732  58.462  1.00 28.21           C  
ATOM    616  C   ALA   101       0.213  -7.007  58.723  1.00 29.52           C  
ATOM    617  O   ALA   101       0.076  -7.861  57.847  1.00 28.87           O  
ATOM    618  CB  ALA   101       0.330  -4.906  57.384  1.00 30.21           C  
ATOM    619  N   VAL   102      -0.331  -7.127  59.925  1.00 27.61           N  
ATOM    620  CA  VAL   102      -1.207  -8.267  60.262  1.00 28.64           C  
ATOM    621  C   VAL   102      -2.467  -7.696  60.876  1.00 28.88           C  
ATOM    622  O   VAL   102      -2.410  -7.021  61.930  1.00 28.99           O  
ATOM    623  CB  VAL   102      -0.509  -9.219  61.211  1.00 30.54           C  
ATOM    624  CG1 VAL   102      -1.434 -10.307  61.667  1.00 29.44           C  
ATOM    625  CG2 VAL   102       0.720  -9.834  60.558  1.00 28.25           C  
ATOM    626  N   HIS   103      -3.588  -7.835  60.202  1.00 27.37           N  
ATOM    627  CA  HIS   103      -4.831  -7.244  60.725  1.00 26.76           C  
ATOM    628  C   HIS   103      -5.227  -7.777  62.118  1.00 29.75           C  
ATOM    629  O   HIS   103      -4.967  -8.922  62.406  1.00 26.61           O  
ATOM    630  CB  HIS   103      -5.977  -7.524  59.754  1.00 28.19           C  
ATOM    631  CG  HIS   103      -7.130  -6.578  59.921  1.00 28.76           C  
ATOM    632  ND1 HIS   103      -8.104  -6.757  60.883  1.00 29.49           N  
ATOM    633  CD2 HIS   103      -7.419  -5.406  59.298  1.00 30.28           C  
ATOM    634  CE1 HIS   103      -8.984  -5.771  60.801  1.00 31.84           C  
ATOM    635  NE2 HIS   103      -8.599  -4.942  59.840  1.00 32.54           N  
ATOM    636  N   SER   104      -5.849  -6.953  62.977  1.00 31.60           N  
ATOM    637  CA  SER   104      -6.337  -7.442  64.270  1.00 34.74           C  
ATOM    638  C   SER   104      -7.262  -8.656  64.158  1.00 35.83           C  
ATOM    639  O   SER   104      -7.247  -9.472  65.043  1.00 36.87           O  
ATOM    640  CB  SER   104      -7.006  -6.316  65.117  1.00 35.80           C  
ATOM    641  OG  SER   104      -7.916  -5.455  64.372  1.00 39.13           O  
ATOM    642  N   ARG   105      -8.035  -8.808  63.065  1.00 37.04           N  
ATOM    643  CA  ARG   105      -8.992  -9.939  62.956  1.00 37.31           C  
ATOM    644  C   ARG   105      -8.196 -11.217  62.655  1.00 37.29           C  
ATOM    645  O   ARG   105      -8.738 -12.293  62.691  1.00 38.32           O  
ATOM    646  CB  ARG   105     -10.059  -9.717  61.859  1.00 37.38           C  
ATOM    647  CG  ARG   105      -9.546  -9.922  60.417  1.00 37.50           C  
ATOM    648  CD  ARG   105     -10.593  -9.682  59.304  1.00 35.81           C  
ATOM    649  NE  ARG   105     -11.210  -8.341  59.366  1.00 34.57           N  
ATOM    650  CZ  ARG   105     -10.934  -7.297  58.581  1.00 34.77           C  
ATOM    651  NH1 ARG   105     -11.615  -6.151  58.758  1.00 35.83           N  
ATOM    652  NH2 ARG   105      -9.995  -7.344  57.621  1.00 33.39           N  
ATOM    653  N   ALA   106      -6.906 -11.082  62.357  1.00 36.73           N  
ATOM    654  CA  ALA   106      -6.086 -12.231  61.957  1.00 37.30           C  
ATOM    655  C   ALA   106      -5.017 -12.644  62.990  1.00 38.82           C  
ATOM    656  O   ALA   106      -4.114 -13.416  62.680  1.00 38.52           O  
ATOM    657  CB  ALA   106      -5.448 -11.964  60.585  1.00 37.06           C  
ATOM    658  N   ARG   107      -5.113 -12.088  64.193  1.00 40.42           N  
ATOM    659  CA  ARG   107      -4.285 -12.497  65.359  1.00 43.16           C  
ATOM    660  C   ARG   107      -4.401 -13.970  65.700  1.00 42.97           C  
ATOM    661  O   ARG   107      -5.462 -14.594  65.532  1.00 43.89           O  
ATOM    662  CB  ARG   107      -4.697 -11.717  66.605  1.00 43.97           C  
ATOM    663  CG  ARG   107      -4.300 -10.277  66.532  1.00 48.79           C  
ATOM    664  CD  ARG   107      -2.970 -10.143  65.803  1.00 55.48           C  
ATOM    665  NE  ARG   107      -2.759  -8.786  65.308  1.00 59.99           N  
ATOM    666  CZ  ARG   107      -1.573  -8.275  65.013  1.00 62.07           C  
ATOM    667  NH1 ARG   107      -0.462  -9.010  65.150  1.00 62.83           N  
ATOM    668  NH2 ARG   107      -1.500  -7.023  64.583  1.00 65.01           N  
ATOM    669  N   GLY   108      -3.309 -14.542  66.178  1.00 43.59           N  
ATOM    670  CA  GLY   108      -3.320 -15.943  66.575  1.00 43.64           C  
ATOM    671  C   GLY   108      -3.065 -16.904  65.432  1.00 44.48           C  
ATOM    672  O   GLY   108      -3.261 -18.093  65.594  1.00 43.64           O  
ATOM    673  N   HIS   109      -2.608 -16.401  64.287  1.00 43.96           N  
ATOM    674  CA  HIS   109      -2.318 -17.277  63.159  1.00 44.81           C  
ATOM    675  C   HIS   109      -0.822 -17.262  62.841  1.00 44.35           C  
ATOM    676  O   HIS   109      -0.394 -17.882  61.834  1.00 44.94           O  
ATOM    677  CB  HIS   109      -3.116 -16.847  61.894  1.00 45.94           C  
ATOM    678  CG  HIS   109      -4.601 -17.074  61.993  1.00 50.00           C  
ATOM    679  ND1 HIS   109      -5.217 -18.210  61.501  1.00 53.82           N  
ATOM    680  CD2 HIS   109      -5.593 -16.306  62.513  1.00 52.01           C  
ATOM    681  CE1 HIS   109      -6.521 -18.140  61.732  1.00 54.79           C  
ATOM    682  NE2 HIS   109      -6.776 -16.990  62.337  1.00 53.31           N  
ATOM    683  N   ARG   110      -0.046 -16.504  63.638  1.00 42.56           N  
ATOM    684  CA  ARG   110       1.387 -16.316  63.418  1.00 41.19           C  
ATOM    685  C   ARG   110       1.656 -15.936  61.948  1.00 38.86           C  
ATOM    686  O   ARG   110       2.615 -16.457  61.312  1.00 36.36           O  
ATOM    687  CB  ARG   110       2.109 -17.608  63.749  1.00 42.35           C  
ATOM    688  CG  ARG   110       3.175 -17.478  64.793  1.00 49.54           C  
ATOM    689  CD  ARG   110       2.709 -17.960  66.144  1.00 56.27           C  
ATOM    690  NE  ARG   110       3.830 -18.483  66.941  1.00 63.66           N  
ATOM    691  CZ  ARG   110       3.741 -18.939  68.202  1.00 66.48           C  
ATOM    692  NH1 ARG   110       2.579 -18.942  68.859  1.00 67.31           N  
ATOM    693  NH2 ARG   110       4.829 -19.393  68.825  1.00 66.34           N  
ATOM    694  N   LEU   111       0.803 -15.063  61.399  1.00 36.64           N  
ATOM    695  CA  LEU   111       0.934 -14.711  60.004  1.00 36.13           C  
ATOM    696  C   LEU   111       2.263 -14.069  59.730  1.00 35.20           C  
ATOM    697  O   LEU   111       2.786 -14.268  58.647  1.00 35.02           O  
ATOM    698  CB  LEU   111      -0.134 -13.715  59.503  1.00 37.49           C  
ATOM    699  CG  LEU   111      -1.445 -14.246  58.935  1.00 40.47           C  
ATOM    700  CD1 LEU   111      -2.185 -13.067  58.293  1.00 36.90           C  
ATOM    701  CD2 LEU   111      -1.187 -15.437  57.981  1.00 41.44           C  
ATOM    702  N   GLY   112       2.775 -13.237  60.656  1.00 33.27           N  
ATOM    703  CA  GLY   112       4.015 -12.473  60.342  1.00 32.76           C  
ATOM    704  C   GLY   112       5.179 -13.418  60.021  1.00 33.00           C  
ATOM    705  O   GLY   112       5.776 -13.354  58.948  1.00 30.20           O  
ATOM    706  N   ARG   113       5.428 -14.370  60.914  1.00 32.81           N  
ATOM    707  CA  ARG   113       6.415 -15.429  60.648  1.00 34.49           C  
ATOM    708  C   ARG   113       6.133 -16.288  59.440  1.00 32.25           C  
ATOM    709  O   ARG   113       7.054 -16.581  58.686  1.00 31.91           O  
ATOM    710  CB  ARG   113       6.688 -16.370  61.862  1.00 36.39           C  
ATOM    711  CG  ARG   113       5.730 -16.223  62.962  1.00 43.11           C  
ATOM    712  CD  ARG   113       6.218 -15.164  63.983  1.00 49.74           C  
ATOM    713  NE  ARG   113       7.038 -15.759  65.049  1.00 55.53           N  
ATOM    714  CZ  ARG   113       6.763 -15.684  66.340  1.00 54.24           C  
ATOM    715  NH1 ARG   113       7.601 -16.206  67.206  1.00 58.55           N  
ATOM    716  NH2 ARG   113       5.691 -15.044  66.758  1.00 57.00           N  
ATOM    717  N   ALA   114       4.877 -16.694  59.225  1.00 31.63           N  
ATOM    718  CA  ALA   114       4.552 -17.457  57.989  1.00 31.72           C  
ATOM    719  C   ALA   114       4.884 -16.676  56.693  1.00 31.78           C  
ATOM    720  O   ALA   114       5.430 -17.231  55.716  1.00 30.96           O  
ATOM    721  CB  ALA   114       3.104 -17.838  57.959  1.00 31.23           C  
ATOM    722  N   MET   115       4.512 -15.410  56.693  1.00 29.72           N  
ATOM    723  CA  MET   115       4.727 -14.548  55.539  1.00 31.83           C  
ATOM    724  C   MET   115       6.214 -14.314  55.284  1.00 30.40           C  
ATOM    725  O   MET   115       6.680 -14.435  54.137  1.00 30.20           O  
ATOM    726  CB  MET   115       3.932 -13.262  55.684  1.00 31.94           C  
ATOM    727  CG  MET   115       2.395 -13.472  55.437  1.00 30.62           C  
ATOM    728  SD  MET   115       1.599 -11.668  55.459  0.85 34.94          SE  
ATOM    729  CE  MET   115       1.955 -11.047  57.300  1.00 26.83           C  
ATOM    730  N   LEU   116       6.972 -14.034  56.337  1.00 30.11           N  
ATOM    731  CA  LEU   116       8.423 -13.855  56.183  1.00 30.42           C  
ATOM    732  C   LEU   116       9.132 -15.107  55.659  1.00 30.52           C  
ATOM    733  O   LEU   116       9.966 -15.028  54.732  1.00 30.68           O  
ATOM    734  CB  LEU   116       9.049 -13.363  57.495  1.00 29.45           C  
ATOM    735  CG  LEU   116       8.651 -11.953  57.913  1.00 32.33           C  
ATOM    736  CD1 LEU   116       9.015 -11.816  59.419  1.00 35.29           C  
ATOM    737  CD2 LEU   116       9.393 -10.887  57.089  1.00 34.27           C  
ATOM    738  N   GLY   117       8.811 -16.250  56.264  1.00 31.60           N  
ATOM    739  CA  GLY   117       9.225 -17.559  55.761  1.00 32.49           C  
ATOM    740  C   GLY   117       8.870 -17.829  54.321  1.00 33.44           C  
ATOM    741  O   GLY   117       9.713 -18.309  53.581  1.00 34.87           O  
ATOM    742  N   HIS   118       7.643 -17.520  53.908  1.00 32.19           N  
ATOM    743  CA  HIS   118       7.239 -17.655  52.513  1.00 31.65           C  
ATOM    744  C   HIS   118       8.130 -16.889  51.551  1.00 31.42           C  
ATOM    745  O   HIS   118       8.502 -17.405  50.498  1.00 32.19           O  
ATOM    746  CB  HIS   118       5.788 -17.174  52.319  1.00 32.80           C  
ATOM    747  CG  HIS   118       5.195 -17.549  50.997  1.00 32.35           C  
ATOM    748  ND1 HIS   118       5.266 -16.733  49.890  1.00 35.08           N  
ATOM    749  CD2 HIS   118       4.491 -18.640  50.612  1.00 31.11           C  
ATOM    750  CE1 HIS   118       4.647 -17.311  48.877  1.00 34.92           C  
ATOM    751  NE2 HIS   118       4.152 -18.462  49.292  1.00 36.60           N  
ATOM    752  N   ILE   119       8.438 -15.634  51.861  1.00 27.83           N  
ATOM    753  CA  ILE   119       9.319 -14.863  50.990  1.00 28.68           C  
ATOM    754  C   ILE   119      10.745 -15.432  50.966  1.00 29.77           C  
ATOM    755  O   ILE   119      11.387 -15.563  49.902  1.00 30.26           O  
ATOM    756  CB  ILE   119       9.361 -13.371  51.418  1.00 26.17           C  
ATOM    757  CG1 ILE   119       7.980 -12.759  51.268  1.00 27.11           C  
ATOM    758  CG2 ILE   119      10.388 -12.629  50.564  1.00 30.42           C  
ATOM    759  CD1 ILE   119       7.882 -11.398  51.963  1.00 24.95           C  
ATOM    760  N   LEU   120      11.245 -15.784  52.125  1.00 32.96           N  
ATOM    761  CA  LEU   120      12.586 -16.346  52.212  1.00 33.74           C  
ATOM    762  C   LEU   120      12.776 -17.641  51.474  1.00 35.19           C  
ATOM    763  O   LEU   120      13.885 -17.917  51.013  1.00 34.94           O  
ATOM    764  CB  LEU   120      13.022 -16.521  53.656  1.00 33.50           C  
ATOM    765  CG  LEU   120      13.470 -15.247  54.371  1.00 35.70           C  
ATOM    766  CD1 LEU   120      13.544 -15.502  55.849  1.00 38.36           C  
ATOM    767  CD2 LEU   120      14.790 -14.698  53.812  1.00 39.50           C  
ATOM    768  N   GLU   121      11.702 -18.426  51.372  0.50 35.23           N  
ATOM    770  CA  GLU   121      11.690 -19.720  50.677  0.50 35.62           C  
ATOM    772  C   GLU   121      11.723 -19.618  49.173  0.50 35.75           C  
ATOM    774  O   GLU   121      12.049 -20.587  48.503  0.50 34.88           O  
ATOM    776  CB  GLU   121      10.452 -20.526  51.071  0.50 36.69           C  
ATOM    778  CG  GLU   121      10.598 -21.296  52.369  0.50 39.07           C  
ATOM    780  CD  GLU   121      11.349 -22.608  52.206  0.50 42.94           C  
ATOM    782  OE1 GLU   121      12.548 -22.658  52.579  0.50 43.73           O  
ATOM    784  OE2 GLU   121      10.745 -23.587  51.700  0.50 45.46           O  
ATOM    786  N   ARG   122      11.381 -18.453  48.636  1.00 34.98           N  
ATOM    787  CA  ARG   122      11.326 -18.266  47.196  1.00 36.09           C  
ATOM    788  C   ARG   122      12.649 -18.336  46.465  1.00 36.25           C  
ATOM    789  O   ARG   122      13.711 -17.971  47.010  1.00 35.35           O  
ATOM    790  CB  ARG   122      10.743 -16.923  46.844  1.00 34.73           C  
ATOM    791  CG  ARG   122       9.356 -16.751  47.422  1.00 36.99           C  
ATOM    792  CD  ARG   122       8.745 -15.495  46.945  1.00 33.49           C  
ATOM    793  NE  ARG   122       7.382 -15.449  47.459  1.00 31.96           N  
ATOM    794  CZ  ARG   122       6.671 -14.329  47.496  1.00 31.99           C  
ATOM    795  NH1 ARG   122       7.199 -13.234  46.988  1.00 29.85           N  
ATOM    796  NH2 ARG   122       5.442 -14.317  47.987  1.00 32.40           N  
ATOM    797  N   GLN   123      12.554 -18.771  45.212  0.50 36.89           N  
ATOM    799  CA  GLN   123      13.699 -18.931  44.318  0.50 37.61           C  
ATOM    801  C   GLN   123      14.442 -17.601  44.099  0.50 37.74           C  
ATOM    803  O   GLN   123      15.666 -17.585  43.942  0.50 37.85           O  
ATOM    805  CB  GLN   123      13.247 -19.587  42.994  0.50 38.09           C  
ATOM    807  CG  GLN   123      11.711 -19.523  42.707  0.50 40.02           C  
ATOM    809  CD  GLN   123      10.839 -20.426  43.616  0.50 41.57           C  
ATOM    811  OE1 GLN   123       9.933 -19.950  44.313  0.50 39.31           O  
ATOM    813  NE2 GLN   123      11.107 -21.733  43.587  0.50 41.50           N  
ATOM    815  N   GLU   124      13.700 -16.488  44.149  1.00 37.77           N  
ATOM    816  CA  GLU   124      14.272 -15.133  44.085  1.00 37.11           C  
ATOM    817  C   GLU   124      15.204 -14.802  45.267  1.00 35.47           C  
ATOM    818  O   GLU   124      16.125 -13.991  45.123  1.00 36.09           O  
ATOM    819  CB  GLU   124      13.150 -14.074  43.971  1.00 39.80           C  
ATOM    820  CG  GLU   124      12.278 -14.197  42.672  1.00 45.55           C  
ATOM    821  CD  GLU   124      11.085 -15.181  42.758  1.00 49.57           C  
ATOM    822  OE1 GLU   124      11.156 -16.209  43.448  1.00 51.25           O  
ATOM    823  OE2 GLU   124      10.046 -14.917  42.113  1.00 56.74           O  
ATOM    824  N   CYS   125      14.997 -15.449  46.411  1.00 33.75           N  
ATOM    825  CA  CYS   125      15.797 -15.175  47.634  1.00 33.53           C  
ATOM    826  C   CYS   125      16.823 -16.283  47.909  1.00 34.23           C  
ATOM    827  O   CYS   125      17.407 -16.338  48.992  1.00 33.76           O  
ATOM    828  CB  CYS   125      14.878 -14.981  48.857  1.00 31.65           C  
ATOM    829  SG  CYS   125      13.774 -13.531  48.696  1.00 34.67           S  
ATOM    830  N   ARG   126      17.049 -17.157  46.937  0.50 34.15           N  
ATOM    832  CA  ARG   126      17.935 -18.304  47.165  0.50 34.77           C  
ATOM    834  C   ARG   126      19.400 -17.918  47.418  0.50 34.37           C  
ATOM    836  O   ARG   126      20.183 -18.740  47.907  0.50 34.03           O  
ATOM    838  CB  ARG   126      17.821 -19.319  46.026  0.50 35.04           C  
ATOM    840  CG  ARG   126      18.333 -18.817  44.678  0.50 37.29           C  
ATOM    842  CD  ARG   126      17.579 -19.487  43.545  0.50 41.20           C  
ATOM    844  NE  ARG   126      17.995 -19.010  42.229  0.50 42.67           N  
ATOM    846  CZ  ARG   126      17.783 -19.681  41.102  0.50 43.63           C  
ATOM    848  NH1 ARG   126      18.192 -19.174  39.943  0.50 43.05           N  
ATOM    850  NH2 ARG   126      17.164 -20.864  41.139  0.50 42.07           N  
ATOM    852  N   HIS   127      19.775 -16.688  47.079  1.00 33.69           N  
ATOM    853  CA  HIS   127      21.131 -16.196  47.403  1.00 34.51           C  
ATOM    854  C   HIS   127      21.196 -15.224  48.612  1.00 33.68           C  
ATOM    855  O   HIS   127      22.269 -14.732  48.947  1.00 33.77           O  
ATOM    856  CB  HIS   127      21.789 -15.557  46.177  1.00 34.70           C  
ATOM    857  CG  HIS   127      22.155 -16.530  45.106  1.00 39.58           C  
ATOM    858  ND1 HIS   127      21.919 -16.279  43.771  1.00 42.87           N  
ATOM    859  CD2 HIS   127      22.770 -17.740  45.161  1.00 41.75           C  
ATOM    860  CE1 HIS   127      22.375 -17.296  43.048  1.00 45.27           C  
ATOM    861  NE2 HIS   127      22.888 -18.197  43.868  1.00 42.60           N  
ATOM    862  N   VAL   128      20.064 -14.973  49.271  1.00 31.51           N  
ATOM    863  CA  VAL   128      20.045 -14.065  50.396  1.00 31.98           C  
ATOM    864  C   VAL   128      20.826 -14.690  51.529  1.00 33.28           C  
ATOM    865  O   VAL   128      20.625 -15.861  51.855  1.00 33.25           O  
ATOM    866  CB  VAL   128      18.609 -13.790  50.830  1.00 31.75           C  
ATOM    867  CG1 VAL   128      18.528 -13.042  52.204  1.00 29.75           C  
ATOM    868  CG2 VAL   128      17.921 -12.997  49.697  1.00 31.26           C  
ATOM    869  N   ARG   129      21.703 -13.883  52.120  1.00 33.61           N  
ATOM    870  CA  ARG   129      22.571 -14.297  53.224  1.00 34.50           C  
ATOM    871  C   ARG   129      22.190 -13.526  54.517  1.00 33.26           C  
ATOM    872  O   ARG   129      22.449 -14.013  55.628  1.00 31.75           O  
ATOM    873  CB  ARG   129      24.020 -14.099  52.754  1.00 34.29           C  
ATOM    874  CG  ARG   129      25.129 -13.916  53.775  1.00 38.31           C  
ATOM    875  CD  ARG   129      26.523 -13.891  53.047  1.00 39.42           C  
ATOM    876  NE  ARG   129      27.659 -14.088  53.967  1.00 47.11           N  
ATOM    877  CZ  ARG   129      28.008 -15.243  54.525  1.00 49.62           C  
ATOM    878  NH1 ARG   129      27.337 -16.369  54.268  1.00 50.69           N  
ATOM    879  NH2 ARG   129      29.054 -15.275  55.355  1.00 51.11           N  
ATOM    880  N   HIS   130      21.511 -12.368  54.374  1.00 30.80           N  
ATOM    881  CA  HIS   130      21.094 -11.577  55.517  1.00 31.25           C  
ATOM    882  C   HIS   130      19.719 -10.986  55.327  1.00 30.28           C  
ATOM    883  O   HIS   130      19.342 -10.647  54.211  1.00 28.51           O  
ATOM    884  CB  HIS   130      22.004 -10.376  55.683  1.00 32.90           C  
ATOM    885  CG  HIS   130      23.360 -10.734  56.175  1.00 37.29           C  
ATOM    886  ND1 HIS   130      24.436 -10.876  55.325  1.00 42.12           N  
ATOM    887  CD2 HIS   130      23.804 -11.039  57.417  1.00 39.12           C  
ATOM    888  CE1 HIS   130      25.495 -11.229  56.029  1.00 42.47           C  
ATOM    889  NE2 HIS   130      25.139 -11.327  57.299  1.00 42.86           N  
ATOM    890  N   LEU   131      19.027 -10.768  56.433  1.00 28.68           N  
ATOM    891  CA  LEU   131      17.730 -10.086  56.376  1.00 30.58           C  
ATOM    892  C   LEU   131      17.863  -8.857  57.285  1.00 30.29           C  
ATOM    893  O   LEU   131      18.392  -8.977  58.378  1.00 31.90           O  
ATOM    894  CB  LEU   131      16.603 -11.001  56.824  1.00 31.30           C  
ATOM    895  CG  LEU   131      15.193 -10.402  56.770  1.00 34.58           C  
ATOM    896  CD1 LEU   131      14.236 -11.562  56.595  1.00 38.29           C  
ATOM    897  CD2 LEU   131      14.859  -9.562  57.986  1.00 38.57           C  
ATOM    898  N   GLU   132      17.433  -7.691  56.814  1.00 29.02           N  
ATOM    899  CA  GLU   132      17.503  -6.440  57.574  1.00 30.40           C  
ATOM    900  C   GLU   132      16.100  -5.852  57.721  1.00 30.46           C  
ATOM    901  O   GLU   132      15.280  -5.997  56.828  1.00 28.94           O  
ATOM    902  CB  GLU   132      18.375  -5.429  56.802  1.00 29.23           C  
ATOM    903  CG  GLU   132      19.815  -5.591  57.140  1.00 33.74           C  
ATOM    904  CD  GLU   132      20.795  -4.628  56.468  1.00 34.50           C  
ATOM    905  OE1 GLU   132      20.442  -3.536  55.953  1.00 40.50           O  
ATOM    906  OE2 GLU   132      21.979  -4.995  56.487  1.00 38.28           O  
ATOM    907  N   THR   133      15.822  -5.176  58.823  1.00 29.70           N  
ATOM    908  CA  THR   133      14.547  -4.553  58.981  1.00 30.29           C  
ATOM    909  C   THR   133      14.759  -3.544  60.107  1.00 30.59           C  
ATOM    910  O   THR   133      15.825  -3.540  60.727  1.00 30.37           O  
ATOM    911  CB  THR   133      13.463  -5.580  59.356  1.00 31.81           C  
ATOM    912  OG1 THR   133      12.165  -4.978  59.174  1.00 33.20           O  
ATOM    913  CG2 THR   133      13.596  -6.020  60.852  1.00 30.50           C  
ATOM    914  N   THR   134      13.773  -2.722  60.405  1.00 29.32           N  
ATOM    915  CA  THR   134      13.925  -1.880  61.595  1.00 29.75           C  
ATOM    916  C   THR   134      12.775  -2.087  62.577  1.00 29.78           C  
ATOM    917  O   THR   134      11.649  -2.566  62.189  1.00 29.62           O  
ATOM    918  CB  THR   134      14.048  -0.386  61.285  1.00 29.80           C  
ATOM    919  OG1 THR   134      12.767   0.088  60.851  1.00 31.78           O  
ATOM    920  CG2 THR   134      15.133  -0.096  60.202  1.00 30.43           C  
ATOM    921  N   VAL   135      13.073  -1.808  63.835  1.00 30.68           N  
ATOM    922  CA  VAL   135      12.136  -2.013  64.924  1.00 31.53           C  
ATOM    923  C   VAL   135      12.207  -0.818  65.831  1.00 31.82           C  
ATOM    924  O   VAL   135      13.276  -0.305  66.041  1.00 33.90           O  
ATOM    925  CB  VAL   135      12.451  -3.297  65.752  1.00 32.28           C  
ATOM    926  CG1 VAL   135      12.003  -4.557  65.000  1.00 33.93           C  
ATOM    927  CG2 VAL   135      13.919  -3.376  66.200  1.00 33.14           C  
ATOM    928  N   GLY   136      11.088  -0.388  66.412  1.00 33.08           N  
ATOM    929  CA  GLY   136      11.112   0.672  67.420  1.00 34.31           C  
ATOM    930  C   GLY   136      11.590   0.146  68.774  1.00 37.82           C  
ATOM    931  O   GLY   136      11.728  -1.077  68.948  1.00 35.54           O  
ATOM    932  N   PRO   137      11.823   1.064  69.741  1.00 40.57           N  
ATOM    933  CA  PRO   137      12.259   0.716  71.087  1.00 43.55           C  
ATOM    934  C   PRO   137      11.419  -0.339  71.792  1.00 44.62           C  
ATOM    935  O   PRO   137      11.989  -1.224  72.359  1.00 47.20           O  
ATOM    936  CB  PRO   137      12.247   2.059  71.851  1.00 44.14           C  
ATOM    937  CG  PRO   137      11.493   3.033  70.961  1.00 44.40           C  
ATOM    938  CD  PRO   137      11.681   2.523  69.562  1.00 41.56           C  
ATOM    939  N   ASP   138      10.098  -0.287  71.737  1.00 45.76           N  
ATOM    940  CA  ASP   138       9.280  -1.184  72.560  1.00 47.26           C  
ATOM    941  C   ASP   138       8.750  -2.370  71.813  1.00 45.93           C  
ATOM    942  O   ASP   138       7.962  -3.132  72.367  1.00 47.05           O  
ATOM    943  CB  ASP   138       8.013  -0.473  73.063  1.00 49.09           C  
ATOM    944  CG  ASP   138       8.296   0.838  73.789  1.00 53.31           C  
ATOM    945  OD1 ASP   138       9.295   0.909  74.555  1.00 57.05           O  
ATOM    946  OD2 ASP   138       7.484   1.788  73.575  1.00 59.42           O  
ATOM    947  N   ASN   139       9.106  -2.512  70.547  1.00 44.09           N  
ATOM    948  CA  ASN   139       8.455  -3.495  69.723  1.00 42.64           C  
ATOM    949  C   ASN   139       9.029  -4.890  69.965  1.00 40.57           C  
ATOM    950  O   ASN   139       9.709  -5.465  69.104  1.00 38.07           O  
ATOM    951  CB  ASN   139       8.536  -3.075  68.249  1.00 44.42           C  
ATOM    952  CG  ASN   139       7.828  -1.734  67.997  1.00 50.18           C  
ATOM    953  OD1 ASN   139       6.601  -1.663  67.959  1.00 55.95           O  
ATOM    954  ND2 ASN   139       8.601  -0.669  67.886  1.00 52.75           N  
ATOM    955  N   GLN   140       8.770  -5.427  71.157  1.00 38.57           N  
ATOM    956  CA  GLN   140       9.317  -6.737  71.524  1.00 36.96           C  
ATOM    957  C   GLN   140       8.782  -7.919  70.740  1.00 36.24           C  
ATOM    958  O   GLN   140       9.547  -8.850  70.411  1.00 35.42           O  
ATOM    959  CB  GLN   140       9.170  -6.984  73.020  1.00 37.67           C  
ATOM    960  CG  GLN   140       9.872  -5.933  73.868  1.00 41.31           C  
ATOM    961  CD  GLN   140      11.348  -5.776  73.538  1.00 47.33           C  
ATOM    962  OE1 GLN   140      12.036  -6.742  73.198  1.00 48.80           O  
ATOM    963  NE2 GLN   140      11.843  -4.553  73.647  1.00 52.39           N  
ATOM    964  N   ALA   141       7.476  -7.922  70.466  1.00 34.86           N  
ATOM    965  CA  ALA   141       6.894  -9.001  69.703  1.00 34.59           C  
ATOM    966  C   ALA   141       7.500  -9.065  68.306  1.00 35.03           C  
ATOM    967  O   ALA   141       7.748 -10.157  67.773  1.00 35.37           O  
ATOM    968  CB  ALA   141       5.369  -8.880  69.626  1.00 34.68           C  
ATOM    969  N   SER   142       7.753  -7.896  67.722  0.50 35.08           N  
ATOM    971  CA  SER   142       8.337  -7.845  66.381  0.50 34.34           C  
ATOM    973  C   SER   142       9.761  -8.407  66.367  0.50 33.61           C  
ATOM    975  O   SER   142      10.140  -9.132  65.447  0.50 33.91           O  
ATOM    977  CB  SER   142       8.301  -6.414  65.855  0.50 35.14           C  
ATOM    979  OG  SER   142       6.986  -6.105  65.402  0.50 36.83           O  
ATOM    981  N   ARG   143      10.526  -8.107  67.413  1.00 31.92           N  
ATOM    982  CA  ARG   143      11.840  -8.706  67.630  1.00 31.65           C  
ATOM    983  C   ARG   143      11.748 -10.221  67.764  1.00 32.62           C  
ATOM    984  O   ARG   143      12.627 -10.946  67.266  1.00 32.96           O  
ATOM    985  CB  ARG   143      12.555  -8.124  68.855  1.00 31.41           C  
ATOM    986  CG  ARG   143      13.047  -6.696  68.682  1.00 32.38           C  
ATOM    987  CD  ARG   143      13.612  -6.157  70.038  1.00 32.63           C  
ATOM    988  NE  ARG   143      14.354  -4.913  69.907  1.00 33.59           N  
ATOM    989  CZ  ARG   143      13.778  -3.725  69.807  1.00 35.37           C  
ATOM    990  NH1 ARG   143      12.448  -3.613  69.825  1.00 37.45           N  
ATOM    991  NH2 ARG   143      14.531  -2.635  69.695  1.00 38.94           N  
ATOM    992  N   ARG   144      10.694 -10.723  68.420  1.00 31.43           N  
ATOM    993  CA  ARG   144      10.651 -12.163  68.629  1.00 32.29           C  
ATOM    994  C   ARG   144      10.417 -12.893  67.308  1.00 32.97           C  
ATOM    995  O   ARG   144      10.955 -14.015  67.109  1.00 33.70           O  
ATOM    996  CB  ARG   144       9.572 -12.557  69.639  1.00 31.24           C  
ATOM    997  CG  ARG   144      10.041 -12.372  71.087  1.00 31.57           C  
ATOM    998  CD  ARG   144       8.994 -12.898  72.057  1.00 28.92           C  
ATOM    999  NE  ARG   144       7.775 -12.083  72.146  1.00 28.45           N  
ATOM   1000  CZ  ARG   144       7.636 -11.051  73.015  1.00 30.97           C  
ATOM   1001  NH1 ARG   144       8.657 -10.638  73.761  1.00 26.80           N  
ATOM   1002  NH2 ARG   144       6.491 -10.370  73.084  1.00 31.80           N  
ATOM   1003  N   THR   145       9.584 -12.294  66.468  1.00 34.26           N  
ATOM   1004  CA  THR   145       9.315 -12.813  65.108  1.00 37.29           C  
ATOM   1005  C   THR   145      10.660 -12.968  64.373  1.00 37.57           C  
ATOM   1006  O   THR   145      10.990 -14.082  63.937  1.00 36.19           O  
ATOM   1007  CB  THR   145       8.327 -11.943  64.295  1.00 38.03           C  
ATOM   1008  OG1 THR   145       7.046 -11.895  64.937  1.00 38.10           O  
ATOM   1009  CG2 THR   145       8.122 -12.501  62.876  1.00 40.32           C  
ATOM   1010  N   PHE   146      11.463 -11.885  64.308  1.00 37.24           N  
ATOM   1011  CA  PHE   146      12.752 -11.978  63.623  1.00 37.68           C  
ATOM   1012  C   PHE   146      13.739 -12.936  64.331  1.00 39.16           C  
ATOM   1013  O   PHE   146      14.432 -13.733  63.664  1.00 39.77           O  
ATOM   1014  CB  PHE   146      13.302 -10.578  63.240  1.00 38.74           C  
ATOM   1015  CG  PHE   146      12.430  -9.849  62.233  1.00 39.23           C  
ATOM   1016  CD1 PHE   146      12.570 -10.073  60.850  1.00 39.66           C  
ATOM   1017  CD2 PHE   146      11.449  -8.940  62.656  1.00 42.53           C  
ATOM   1018  CE1 PHE   146      11.738  -9.415  59.926  1.00 38.69           C  
ATOM   1019  CE2 PHE   146      10.597  -8.257  61.718  1.00 43.57           C  
ATOM   1020  CZ  PHE   146      10.747  -8.510  60.370  1.00 40.97           C  
ATOM   1021  N   ALA   147      13.764 -12.949  65.679  1.00 38.85           N  
ATOM   1022  CA  ALA   147      14.573 -13.911  66.405  1.00 38.63           C  
ATOM   1023  C   ALA   147      14.224 -15.352  66.060  1.00 38.95           C  
ATOM   1024  O   ALA   147      15.118 -16.185  65.880  1.00 38.97           O  
ATOM   1025  CB  ALA   147      14.489 -13.680  67.919  1.00 38.76           C  
ATOM   1026  N   GLY   148      12.928 -15.655  65.967  1.00 39.30           N  
ATOM   1027  CA  GLY   148      12.488 -17.021  65.682  1.00 39.91           C  
ATOM   1028  C   GLY   148      12.932 -17.477  64.300  1.00 40.74           C  
ATOM   1029  O   GLY   148      13.386 -18.609  64.101  1.00 40.27           O  
ATOM   1030  N   LEU   149      12.802 -16.576  63.352  1.00 40.77           N  
ATOM   1031  CA  LEU   149      13.279 -16.775  62.000  1.00 42.52           C  
ATOM   1032  C   LEU   149      14.793 -17.093  61.926  1.00 42.40           C  
ATOM   1033  O   LEU   149      15.224 -18.004  61.197  1.00 42.72           O  
ATOM   1034  CB  LEU   149      12.971 -15.477  61.243  1.00 41.25           C  
ATOM   1035  CG  LEU   149      12.249 -15.544  59.913  1.00 45.60           C  
ATOM   1036  CD1 LEU   149      11.035 -16.491  59.949  1.00 46.26           C  
ATOM   1037  CD2 LEU   149      11.867 -14.133  59.476  1.00 44.81           C  
ATOM   1038  N   ALA   150      15.591 -16.342  62.677  1.00 42.19           N  
ATOM   1039  CA  ALA   150      17.027 -16.561  62.728  1.00 43.17           C  
ATOM   1040  C   ALA   150      17.367 -17.948  63.296  1.00 44.25           C  
ATOM   1041  O   ALA   150      18.196 -18.677  62.725  1.00 43.93           O  
ATOM   1042  CB  ALA   150      17.687 -15.476  63.536  1.00 43.07           C  
ATOM   1043  N   GLY   151      16.717 -18.312  64.406  1.00 44.73           N  
ATOM   1044  CA  GLY   151      16.996 -19.584  65.091  1.00 45.94           C  
ATOM   1045  C   GLY   151      16.781 -20.785  64.192  1.00 46.14           C  
ATOM   1046  O   GLY   151      17.593 -21.714  64.200  1.00 46.17           O  
ATOM   1047  N   GLU   152      15.701 -20.749  63.405  0.50 46.44           N  
ATOM   1049  CA  GLU   152      15.355 -21.825  62.469  0.50 46.93           C  
ATOM   1051  C   GLU   152      16.289 -21.885  61.233  0.50 47.32           C  
ATOM   1053  O   GLU   152      16.139 -22.769  60.383  0.50 47.10           O  
ATOM   1055  CB  GLU   152      13.879 -21.719  62.035  0.50 46.85           C  
ATOM   1057  CG  GLU   152      12.833 -21.820  63.174  0.50 47.47           C  
ATOM   1059  CD  GLU   152      12.321 -23.254  63.454  0.50 46.92           C  
ATOM   1061  OE1 GLU   152      11.216 -23.391  64.027  0.50 47.24           O  
ATOM   1063  OE2 GLU   152      13.006 -24.237  63.108  0.50 47.10           O  
ATOM   1065  N   ARG   153      17.248 -20.959  61.149  1.00 47.16           N  
ATOM   1066  CA  ARG   153      18.238 -20.930  60.064  1.00 47.60           C  
ATOM   1067  C   ARG   153      19.696 -20.929  60.567  1.00 47.56           C  
ATOM   1068  O   ARG   153      20.636 -20.710  59.783  1.00 48.14           O  
ATOM   1069  CB  ARG   153      17.994 -19.698  59.171  1.00 47.52           C  
ATOM   1070  CG  ARG   153      16.832 -19.877  58.197  1.00 47.85           C  
ATOM   1071  CD  ARG   153      16.214 -18.546  57.703  1.00 48.25           C  
ATOM   1072  NE  ARG   153      15.011 -18.827  56.914  1.00 48.66           N  
ATOM   1073  CZ  ARG   153      13.786 -19.002  57.423  1.00 50.44           C  
ATOM   1074  NH1 ARG   153      12.772 -19.304  56.615  1.00 48.73           N  
ATOM   1075  NH2 ARG   153      13.577 -18.905  58.745  1.00 50.45           N  
ATOM   1076  N   GLY   154      19.888 -21.146  61.865  1.00 46.80           N  
ATOM   1077  CA  GLY   154      21.227 -21.054  62.453  1.00 46.10           C  
ATOM   1078  C   GLY   154      21.881 -19.697  62.200  1.00 45.54           C  
ATOM   1079  O   GLY   154      23.097 -19.614  61.997  1.00 45.73           O  
ATOM   1080  N   ALA   155      21.076 -18.632  62.207  1.00 44.29           N  
ATOM   1081  CA  ALA   155      21.590 -17.269  62.026  1.00 43.19           C  
ATOM   1082  C   ALA   155      21.630 -16.459  63.328  1.00 42.59           C  
ATOM   1083  O   ALA   155      20.902 -16.748  64.267  1.00 43.85           O  
ATOM   1084  CB  ALA   155      20.762 -16.521  60.950  1.00 42.77           C  
ATOM   1085  N   HIS   156      22.501 -15.449  63.335  0.50 41.82           N  
ATOM   1087  CA  HIS   156      22.761 -14.490  64.420  0.50 40.83           C  
ATOM   1089  C   HIS   156      21.740 -13.329  64.284  0.50 40.45           C  
ATOM   1091  O   HIS   156      21.246 -13.088  63.189  0.50 38.80           O  
ATOM   1093  CB  HIS   156      24.227 -14.018  64.216  0.50 40.32           C  
ATOM   1095  CG  HIS   156      24.685 -12.891  65.096  0.50 40.80           C  
ATOM   1097  ND1 HIS   156      24.791 -12.995  66.470  0.50 41.92           N  
ATOM   1099  CD2 HIS   156      25.161 -11.661  64.780  0.50 40.16           C  
ATOM   1101  CE1 HIS   156      25.266 -11.864  66.964  0.50 40.20           C  
ATOM   1103  NE2 HIS   156      25.494 -11.037  65.959  0.50 41.31           N  
ATOM   1105  N   VAL   157      21.385 -12.669  65.389  1.00 40.08           N  
ATOM   1106  CA  VAL   157      20.584 -11.453  65.329  1.00 39.34           C  
ATOM   1107  C   VAL   157      21.385 -10.336  65.956  1.00 38.99           C  
ATOM   1108  O   VAL   157      21.916 -10.490  67.053  1.00 39.41           O  
ATOM   1109  CB  VAL   157      19.272 -11.588  66.093  1.00 40.01           C  
ATOM   1110  CG1 VAL   157      18.442 -10.368  65.866  1.00 38.44           C  
ATOM   1111  CG2 VAL   157      18.469 -12.773  65.588  1.00 41.70           C  
ATOM   1112  N   SER   158      21.497  -9.210  65.278  1.00 37.66           N  
ATOM   1113  CA  SER   158      22.118  -8.062  65.903  1.00 37.51           C  
ATOM   1114  C   SER   158      21.220  -6.839  65.790  1.00 37.11           C  
ATOM   1115  O   SER   158      20.403  -6.749  64.868  1.00 35.42           O  
ATOM   1116  CB  SER   158      23.514  -7.814  65.319  1.00 37.80           C  
ATOM   1117  OG  SER   158      23.502  -6.927  64.215  1.00 43.14           O  
ATOM   1118  N   GLU   159      21.370  -5.902  66.724  1.00 35.91           N  
ATOM   1119  CA  GLU   159      20.530  -4.736  66.732  1.00 36.42           C  
ATOM   1120  C   GLU   159      21.415  -3.544  66.988  1.00 34.94           C  
ATOM   1121  O   GLU   159      22.213  -3.582  67.909  1.00 33.52           O  
ATOM   1122  CB  GLU   159      19.492  -4.883  67.838  1.00 35.95           C  
ATOM   1123  CG  GLU   159      18.476  -3.762  67.893  1.00 39.12           C  
ATOM   1124  CD  GLU   159      17.394  -4.025  68.950  1.00 42.73           C  
ATOM   1125  OE1 GLU   159      16.918  -3.023  69.542  1.00 49.54           O  
ATOM   1126  OE2 GLU   159      17.048  -5.223  69.197  1.00 45.45           O  
ATOM   1127  N   GLN   160      21.300  -2.498  66.174  1.00 33.51           N  
ATOM   1128  CA  GLN   160      22.129  -1.308  66.323  1.00 32.97           C  
ATOM   1129  C   GLN   160      21.274  -0.043  66.169  1.00 33.12           C  
ATOM   1130  O   GLN   160      20.273  -0.044  65.433  1.00 32.75           O  
ATOM   1131  CB  GLN   160      23.248  -1.311  65.271  1.00 33.04           C  
ATOM   1132  CG  GLN   160      24.268  -2.415  65.435  1.00 35.30           C  
ATOM   1133  CD  GLN   160      25.120  -2.256  66.717  1.00 37.92           C  
ATOM   1134  OE1 GLN   160      25.161  -1.165  67.310  1.00 36.23           O  
ATOM   1135  NE2 GLN   160      25.796  -3.344  67.148  1.00 38.98           N  
ATOM   1136  N   PRO   161      21.606   1.025  66.901  1.00 32.36           N  
ATOM   1137  CA  PRO   161      20.919   2.277  66.610  1.00 32.50           C  
ATOM   1138  C   PRO   161      21.023   2.619  65.109  1.00 31.78           C  
ATOM   1139  O   PRO   161      22.044   2.315  64.475  1.00 31.34           O  
ATOM   1140  CB  PRO   161      21.724   3.316  67.388  1.00 32.06           C  
ATOM   1141  CG  PRO   161      22.849   2.550  68.007  1.00 36.00           C  
ATOM   1142  CD  PRO   161      22.550   1.145  68.017  1.00 33.45           C  
ATOM   1143  N   PHE   162      20.003   3.270  64.573  1.00 31.89           N  
ATOM   1144  CA  PHE   162      19.940   3.495  63.129  1.00 30.24           C  
ATOM   1145  C   PHE   162      19.232   4.813  62.816  1.00 30.82           C  
ATOM   1146  O   PHE   162      19.915   5.806  62.484  1.00 31.00           O  
ATOM   1147  CB  PHE   162      19.272   2.276  62.542  1.00 30.99           C  
ATOM   1148  CG  PHE   162      19.224   2.214  61.055  1.00 30.24           C  
ATOM   1149  CD1 PHE   162      20.389   2.274  60.263  1.00 28.98           C  
ATOM   1150  CD2 PHE   162      17.983   1.984  60.440  1.00 30.26           C  
ATOM   1151  CE1 PHE   162      20.299   2.149  58.846  1.00 32.52           C  
ATOM   1152  CE2 PHE   162      17.890   1.837  59.035  1.00 32.42           C  
ATOM   1153  CZ  PHE   162      19.025   1.958  58.233  1.00 29.09           C  
ATOM   1154  N   PHE   163      17.894   4.858  62.874  1.00 28.61           N  
ATOM   1155  CA  PHE   163      17.216   6.123  62.681  1.00 29.80           C  
ATOM   1156  C   PHE   163      16.861   6.665  64.027  1.00 31.94           C  
ATOM   1157  O   PHE   163      16.108   6.009  64.760  1.00 33.39           O  
ATOM   1158  CB  PHE   163      15.921   5.975  61.881  1.00 29.85           C  
ATOM   1159  CG  PHE   163      16.105   5.525  60.438  1.00 26.07           C  
ATOM   1160  CD1 PHE   163      17.286   5.772  59.749  1.00 28.93           C  
ATOM   1161  CD2 PHE   163      15.046   4.906  59.759  1.00 31.95           C  
ATOM   1162  CE1 PHE   163      17.419   5.374  58.366  1.00 31.02           C  
ATOM   1163  CE2 PHE   163      15.150   4.512  58.405  1.00 32.60           C  
ATOM   1164  CZ  PHE   163      16.346   4.772  57.696  1.00 28.90           C  
ATOM   1165  N   ASP   164      17.352   7.854  64.342  1.00 31.19           N  
ATOM   1166  CA  ASP   164      17.091   8.439  65.643  1.00 32.55           C  
ATOM   1167  C   ASP   164      16.350   9.756  65.423  1.00 32.90           C  
ATOM   1168  O   ASP   164      15.909  10.020  64.310  1.00 32.06           O  
ATOM   1169  CB  ASP   164      18.427   8.665  66.335  1.00 34.33           C  
ATOM   1170  CG  ASP   164      19.381   9.524  65.519  1.00 36.82           C  
ATOM   1171  OD1 ASP   164      19.152   9.795  64.293  1.00 39.67           O  
ATOM   1172  OD2 ASP   164      20.402   9.915  66.102  1.00 40.59           O  
ATOM   1173  N   ARG   165      16.294  10.606  66.446  0.50 32.78           N  
ATOM   1175  CA  ARG   165      15.758  11.965  66.319  0.50 34.06           C  
ATOM   1177  C   ARG   165      16.393  12.800  65.194  0.50 32.76           C  
ATOM   1179  O   ARG   165      15.704  13.566  64.520  0.50 32.30           O  
ATOM   1181  CB  ARG   165      15.901  12.736  67.641  0.50 34.03           C  
ATOM   1183  CG  ARG   165      15.044  12.164  68.769  0.50 36.68           C  
ATOM   1185  CD  ARG   165      15.423  12.757  70.129  0.50 37.46           C  
ATOM   1187  NE  ARG   165      14.971  11.910  71.232  0.50 45.30           N  
ATOM   1189  CZ  ARG   165      13.725  11.880  71.709  0.50 48.57           C  
ATOM   1191  NH1 ARG   165      12.779  12.653  71.185  0.50 49.96           N  
ATOM   1193  NH2 ARG   165      13.418  11.076  72.724  0.50 50.43           N  
ATOM   1195  N   GLN   166      17.705  12.665  65.013  0.50 32.09           N  
ATOM   1197  CA  GLN   166      18.420  13.390  63.970  0.50 32.57           C  
ATOM   1199  C   GLN   166      17.857  13.029  62.587  0.50 31.31           C  
ATOM   1201  O   GLN   166      17.595  13.900  61.753  0.50 30.00           O  
ATOM   1203  CB  GLN   166      19.937  13.085  64.055  0.50 32.57           C  
ATOM   1205  CG  GLN   166      20.852  14.026  63.233  0.50 35.47           C  
ATOM   1207  CD  GLN   166      22.346  13.744  63.411  0.50 34.84           C  
ATOM   1209  OE1 GLN   166      22.732  12.898  64.208  0.50 39.56           O  
ATOM   1211  NE2 GLN   166      23.196  14.478  62.674  0.50 38.77           N  
ATOM   1213  N   ALA   167      17.655  11.730  62.373  1.00 29.22           N  
ATOM   1214  CA  ALA   167      17.225  11.213  61.086  1.00 29.75           C  
ATOM   1215  C   ALA   167      15.766  11.616  60.777  1.00 30.76           C  
ATOM   1216  O   ALA   167      15.435  11.877  59.597  1.00 30.39           O  
ATOM   1217  CB  ALA   167      17.364   9.704  61.039  1.00 26.49           C  
ATOM   1218  N   PHE   168      14.932  11.722  61.825  1.00 31.57           N  
ATOM   1219  CA  PHE   168      13.517  12.164  61.650  1.00 31.96           C  
ATOM   1220  C   PHE   168      13.286  13.649  61.710  1.00 32.21           C  
ATOM   1221  O   PHE   168      12.132  14.096  61.604  1.00 32.92           O  
ATOM   1222  CB  PHE   168      12.567  11.443  62.628  1.00 32.43           C  
ATOM   1223  CG  PHE   168      12.409   9.972  62.360  1.00 30.95           C  
ATOM   1224  CD1 PHE   168      11.533   9.522  61.333  1.00 32.26           C  
ATOM   1225  CD2 PHE   168      13.056   9.016  63.156  1.00 32.42           C  
ATOM   1226  CE1 PHE   168      11.319   8.144  61.074  1.00 36.05           C  
ATOM   1227  CE2 PHE   168      12.908   7.664  62.895  1.00 32.07           C  
ATOM   1228  CZ  PHE   168      12.022   7.185  61.874  1.00 35.67           C  
ATOM   1229  N   GLY   169      14.352  14.404  61.892  1.00 32.25           N  
ATOM   1230  CA  GLY   169      14.264  15.872  61.966  1.00 33.51           C  
ATOM   1231  C   GLY   169      13.387  16.346  63.107  1.00 34.34           C  
ATOM   1232  O   GLY   169      12.765  17.414  63.027  1.00 35.41           O  
ATOM   1233  N   GLY   170      13.346  15.586  64.194  1.00 34.82           N  
ATOM   1234  CA  GLY   170      12.547  16.003  65.347  1.00 35.27           C  
ATOM   1235  C   GLY   170      11.069  15.686  65.189  1.00 36.51           C  
ATOM   1236  O   GLY   170      10.260  16.126  65.986  1.00 36.64           O  
ATOM   1237  N   ALA   171      10.690  14.878  64.198  1.00 36.02           N  
ATOM   1238  CA  ALA   171       9.277  14.629  63.983  1.00 36.89           C  
ATOM   1239  C   ALA   171       8.800  13.708  65.085  1.00 37.83           C  
ATOM   1240  O   ALA   171       9.600  13.065  65.742  1.00 37.14           O  
ATOM   1241  CB  ALA   171       9.049  13.995  62.607  1.00 36.67           C  
ATOM   1242  N   ASP   172       7.500  13.666  65.306  1.00 38.13           N  
ATOM   1243  CA  ASP   172       6.938  12.813  66.339  1.00 40.54           C  
ATOM   1244  C   ASP   172       6.880  11.360  65.838  1.00 40.03           C  
ATOM   1245  O   ASP   172       5.830  10.862  65.401  1.00 42.18           O  
ATOM   1246  CB  ASP   172       5.554  13.370  66.698  1.00 41.76           C  
ATOM   1247  CG  ASP   172       4.963  12.759  67.940  1.00 47.72           C  
ATOM   1248  OD1 ASP   172       5.517  11.772  68.502  1.00 53.08           O  
ATOM   1249  OD2 ASP   172       3.897  13.283  68.346  1.00 52.54           O  
ATOM   1250  N   HIS   173       8.025  10.685  65.886  1.00 39.06           N  
ATOM   1251  CA  HIS   173       8.141   9.284  65.445  1.00 37.69           C  
ATOM   1252  C   HIS   173       9.146   8.602  66.377  1.00 37.60           C  
ATOM   1253  O   HIS   173      10.154   9.177  66.733  1.00 35.55           O  
ATOM   1254  CB  HIS   173       8.600   9.248  63.971  1.00 37.68           C  
ATOM   1255  CG  HIS   173       8.488   7.899  63.311  1.00 37.73           C  
ATOM   1256  ND1 HIS   173       9.241   6.819  63.703  1.00 35.65           N  
ATOM   1257  CD2 HIS   173       7.738   7.465  62.259  1.00 41.18           C  
ATOM   1258  CE1 HIS   173       8.964   5.770  62.946  1.00 38.16           C  
ATOM   1259  NE2 HIS   173       8.058   6.138  62.051  1.00 38.08           N  
ATOM   1260  N   ASP   174       8.855   7.380  66.815  1.00 37.19           N  
ATOM   1261  CA  ASP   174       9.824   6.644  67.620  1.00 38.31           C  
ATOM   1262  C   ASP   174      11.102   6.420  66.793  1.00 37.14           C  
ATOM   1263  O   ASP   174      11.037   6.391  65.529  1.00 36.72           O  
ATOM   1264  CB  ASP   174       9.252   5.268  67.946  1.00 38.70           C  
ATOM   1265  CG  ASP   174       8.113   5.326  68.967  1.00 43.22           C  
ATOM   1266  OD1 ASP   174       7.968   6.363  69.667  1.00 49.01           O  
ATOM   1267  OD2 ASP   174       7.365   4.322  69.053  1.00 48.72           O  
ATOM   1268  N   ASP   175      12.224   6.231  67.498  1.00 35.40           N  
ATOM   1269  CA  ASP   175      13.470   5.768  66.899  1.00 35.45           C  
ATOM   1270  C   ASP   175      13.234   4.411  66.236  1.00 35.34           C  
ATOM   1271  O   ASP   175      12.388   3.662  66.702  1.00 35.17           O  
ATOM   1272  CB  ASP   175      14.488   5.573  68.019  1.00 36.20           C  
ATOM   1273  CG  ASP   175      15.088   6.880  68.517  1.00 39.50           C  
ATOM   1274  OD1 ASP   175      14.721   7.973  68.005  1.00 42.16           O  
ATOM   1275  OD2 ASP   175      15.945   6.817  69.437  1.00 44.59           O  
ATOM   1276  N   GLU   176      13.974   4.097  65.169  1.00 34.71           N  
ATOM   1277  CA  GLU   176      13.918   2.790  64.532  1.00 34.11           C  
ATOM   1278  C   GLU   176      15.312   2.186  64.542  1.00 34.73           C  
ATOM   1279  O   GLU   176      16.201   2.707  63.842  1.00 34.95           O  
ATOM   1280  CB  GLU   176      13.455   2.947  63.092  1.00 36.01           C  
ATOM   1281  CG  GLU   176      12.018   3.477  62.968  1.00 36.75           C  
ATOM   1282  CD  GLU   176      10.973   2.356  62.998  1.00 43.16           C  
ATOM   1283  OE1 GLU   176      11.257   1.132  62.730  1.00 39.93           O  
ATOM   1284  OE2 GLU   176       9.810   2.716  63.302  1.00 46.24           O  
ATOM   1285  N   MET   177      15.512   1.111  65.317  1.00 31.93           N  
ATOM   1286  CA  MET   177      16.797   0.443  65.330  1.00 31.94           C  
ATOM   1287  C   MET   177      16.938  -0.556  64.163  1.00 30.52           C  
ATOM   1288  O   MET   177      15.936  -1.086  63.707  1.00 30.12           O  
ATOM   1289  CB  MET   177      16.979  -0.263  66.671  1.00 31.47           C  
ATOM   1290  CG  MET   177      17.307   0.851  67.772  1.00 41.15           C  
ATOM   1291  SD  MET   177      15.602   1.584  68.381  0.45 55.77          SE  
ATOM   1292  CE  MET   177      14.945  -0.016  69.226  1.00 53.35           C  
ATOM   1293  N   LEU   178      18.175  -0.839  63.763  1.00 29.29           N  
ATOM   1294  CA  LEU   178      18.412  -1.735  62.649  1.00 31.28           C  
ATOM   1295  C   LEU   178      18.555  -3.141  63.183  1.00 31.35           C  
ATOM   1296  O   LEU   178      19.461  -3.432  63.988  1.00 31.95           O  
ATOM   1297  CB  LEU   178      19.677  -1.333  61.878  1.00 29.10           C  
ATOM   1298  CG  LEU   178      20.030  -2.319  60.745  1.00 31.33           C  
ATOM   1299  CD1 LEU   178      19.027  -2.317  59.590  1.00 30.10           C  
ATOM   1300  CD2 LEU   178      21.475  -2.062  60.250  1.00 32.35           C  
ATOM   1301  N   LEU   179      17.674  -4.029  62.740  1.00 31.88           N  
ATOM   1302  CA  LEU   179      17.747  -5.419  63.141  1.00 32.27           C  
ATOM   1303  C   LEU   179      18.293  -6.247  61.948  1.00 33.22           C  
ATOM   1304  O   LEU   179      17.807  -6.154  60.821  1.00 32.35           O  
ATOM   1305  CB  LEU   179      16.344  -5.872  63.607  1.00 32.02           C  
ATOM   1306  CG  LEU   179      16.040  -7.172  64.339  1.00 35.18           C  
ATOM   1307  CD1 LEU   179      16.660  -7.096  65.763  1.00 40.95           C  
ATOM   1308  CD2 LEU   179      14.507  -7.435  64.480  1.00 34.77           C  
ATOM   1309  N   ARG   180      19.346  -7.019  62.178  1.00 33.14           N  
ATOM   1310  CA  ARG   180      20.028  -7.723  61.105  1.00 34.71           C  
ATOM   1311  C   ARG   180      20.229  -9.188  61.439  1.00 35.46           C  
ATOM   1312  O   ARG   180      20.797  -9.507  62.470  1.00 36.70           O  
ATOM   1313  CB  ARG   180      21.379  -7.044  60.829  1.00 35.83           C  
ATOM   1314  CG  ARG   180      22.137  -7.590  59.651  1.00 38.09           C  
ATOM   1315  CD  ARG   180      23.177  -6.555  59.260  1.00 45.27           C  
ATOM   1316  NE  ARG   180      23.881  -6.901  58.027  1.00 51.12           N  
ATOM   1317  CZ  ARG   180      24.988  -7.635  58.000  1.00 52.09           C  
ATOM   1318  NH1 ARG   180      25.496  -8.098  59.141  1.00 57.01           N  
ATOM   1319  NH2 ARG   180      25.593  -7.909  56.849  1.00 52.09           N  
ATOM   1320  N   ILE   181      19.764 -10.084  60.581  1.00 36.10           N  
ATOM   1321  CA  ILE   181      19.804 -11.529  60.866  1.00 36.97           C  
ATOM   1322  C   ILE   181      20.643 -12.178  59.794  1.00 38.09           C  
ATOM   1323  O   ILE   181      20.537 -11.816  58.608  1.00 34.62           O  
ATOM   1324  CB  ILE   181      18.406 -12.111  60.751  1.00 38.27           C  
ATOM   1325  CG1 ILE   181      17.432 -11.440  61.708  1.00 41.03           C  
ATOM   1326  CG2 ILE   181      18.386 -13.584  61.005  1.00 40.84           C  
ATOM   1327  CD1 ILE   181      16.062 -11.386  61.071  1.00 48.15           C  
ATOM   1328  N   GLY   182      21.467 -13.164  60.178  1.00 38.91           N  
ATOM   1329  CA  GLY   182      22.320 -13.810  59.209  1.00 40.40           C  
ATOM   1330  C   GLY   182      23.694 -14.077  59.818  1.00 43.20           C  
ATOM   1331  O   GLY   182      23.909 -13.733  60.989  1.00 43.62           O  
ATOM   1332  N   PRO   183      24.631 -14.667  59.034  1.00 43.54           N  
ATOM   1333  CA  PRO   183      24.429 -15.179  57.666  1.00 43.78           C  
ATOM   1334  C   PRO   183      23.517 -16.414  57.641  1.00 43.68           C  
ATOM   1335  O   PRO   183      23.455 -17.141  58.618  1.00 44.02           O  
ATOM   1336  CB  PRO   183      25.856 -15.531  57.193  1.00 43.95           C  
ATOM   1337  CG  PRO   183      26.655 -15.715  58.435  1.00 45.02           C  
ATOM   1338  CD  PRO   183      26.041 -14.805  59.475  1.00 44.24           C  
ATOM   1339  N   PHE   184      22.762 -16.600  56.565  1.00 43.32           N  
ATOM   1340  CA  PHE   184      22.002 -17.819  56.398  1.00 43.90           C  
ATOM   1341  C   PHE   184      22.979 -18.745  55.698  1.00 45.14           C  
ATOM   1342  O   PHE   184      23.746 -18.269  54.855  1.00 45.26           O  
ATOM   1343  CB  PHE   184      20.768 -17.609  55.532  1.00 43.64           C  
ATOM   1344  CG  PHE   184      19.790 -16.620  56.093  1.00 44.04           C  
ATOM   1345  CD1 PHE   184      19.409 -16.675  57.437  1.00 43.12           C  
ATOM   1346  CD2 PHE   184      19.223 -15.648  55.284  1.00 43.20           C  
ATOM   1347  CE1 PHE   184      18.509 -15.769  57.956  1.00 41.15           C  
ATOM   1348  CE2 PHE   184      18.317 -14.734  55.802  1.00 42.25           C  
ATOM   1349  CZ  PHE   184      17.959 -14.791  57.134  1.00 41.41           C  
END
