
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  236 ( 1845),  selected  236 , name 3crm_A
# Molecule2: number of CA atoms  232 ( 1859),  selected  232 , name T0416_6_115_194_315.pdb
# PARAMETERS: 3crm_A.T0416_6_115_194_315.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     3_A      -       -           -
LGA    L     4_A      K       6          2.381
LGA    P     5_A      P       7          2.406
LGA    P     6_A      F       8          1.037
LGA    A     7_A      L       9          0.677
LGA    I     8_A      I      10          0.536
LGA    F     9_A      V      11          0.719
LGA    L    10_A      I      12          0.597
LGA    M    11_A      V      13          0.692
LGA    G    12_A      G      14          1.367
LGA    P    13_A      P      15          2.043
LGA    T    14_A      T      16          2.347
LGA    A    15_A      A      17          2.899
LGA    A    16_A      S      18          1.843
LGA    G    17_A      G      19          1.683
LGA    K    18_A      K      20          0.566
LGA    T    19_A      T      21          0.814
LGA    D    20_A      E      22          1.499
LGA    L    21_A      L      23          0.911
LGA    A    22_A      S      24          0.742
LGA    M    23_A      I      25          1.607
LGA    A    24_A      E      26          1.407
LGA    L    25_A      V      27          0.535
LGA    A    26_A      A      28          1.151
LGA    D    27_A      K      29          1.566
LGA    A    28_A      K      30          0.928
LGA    L    29_A      F      31          0.534
LGA    P    30_A      N      32          1.673
LGA    C    31_A      G      33          0.941
LGA    E    32_A      E      34          1.237
LGA    L    33_A      I      35          0.334
LGA    I    34_A      I      36          0.534
LGA    S    35_A      S      37          0.631
LGA    V    36_A      G      38          0.512
LGA    D    37_A      D      39          0.791
LGA    S    38_A      S      40          0.837
LGA    A    39_A      M      41          0.759
LGA    L    40_A      Q      42          0.653
LGA    I    41_A      V      43          0.518
LGA    Y    42_A      Y      44          0.656
LGA    R    43_A      Q      45          0.420
LGA    G    44_A      G      46          0.370
LGA    M    45_A      M      47          0.504
LGA    D    46_A      D      48          0.578
LGA    I    47_A      I      49          0.705
LGA    G    48_A      G      50          0.969
LGA    T    49_A      T      51          0.883
LGA    A    50_A      A      52          0.937
LGA    K    51_A      K      53          0.894
LGA    P    52_A      V      54          0.955
LGA    S    53_A      T      55          2.072
LGA    R    54_A      T      56          2.850
LGA    E    55_A      E      57          1.149
LGA    L    56_A      E      58          1.321
LGA    L    57_A      M      59          3.141
LGA    A    58_A      E      60           #
LGA    R    59_A      G      61          2.006
LGA    Y    60_A      I      62          2.664
LGA    P    61_A      P      63          2.282
LGA    H    62_A      X      64          1.358
LGA    R    63_A      Y      65          0.691
LGA    L    64_A      M      66          0.254
LGA    I    65_A      I      67          0.692
LGA    D    66_A      D      68          0.620
LGA    I    67_A      I      69          0.626
LGA    R    68_A      L      70          0.817
LGA    D    69_A      P      71          0.491
LGA    P    70_A      P      72          0.431
LGA    A    71_A      D      73          0.563
LGA    E    72_A      A      74          0.603
LGA    S    73_A      S      75          0.677
LGA    Y    74_A      F      76          0.618
LGA    S    75_A      S      77          1.487
LGA    A    76_A      A      78          1.137
LGA    A    77_A      Y      79          1.271
LGA    E    78_A      E      80          0.912
LGA    F    79_A      F      81          0.522
LGA    R    80_A      K      82          0.539
LGA    A    81_A      K      83          0.448
LGA    D    82_A      R      84          0.244
LGA    A    83_A      A      85          0.307
LGA    L    84_A      E      86          0.155
LGA    A    85_A      K      87          0.406
LGA    A    86_A      Y      88          0.544
LGA    M    87_A      I      89          0.159
LGA    A    88_A      K      90          0.420
LGA    K    89_A      D      91          0.514
LGA    A    90_A      I      92          0.210
LGA    T    91_A      T      93          0.430
LGA    A    92_A      R      94          0.268
LGA    R    93_A      R      95          0.546
LGA    G    94_A      G      96          0.882
LGA    R    95_A      K      97          0.849
LGA    I    96_A      V      98          0.863
LGA    P    97_A      P      99          0.730
LGA    L    98_A      I     100          0.575
LGA    L    99_A      I     101          0.680
LGA    V   100_A      A     102          0.900
LGA    G   101_A      G     103          0.464
LGA    G   102_A      G     104          3.233
LGA    T   103_A      T     105          1.795
LGA    M   104_A      G     106          1.767
LGA    L   105_A      L     107          1.032
LGA    Y   106_A      Y     108          0.611
LGA    Y   107_A      I     109          0.568
LGA    K   108_A      Q     110          1.512
LGA    A   109_A      S     111          1.065
LGA    L   110_A      L     112          0.677
LGA    L   111_A      L     113          1.771
LGA    E   112_A      Y     114          2.562
LGA    G   113_A      N     115          4.095
LGA    L   199_A      E     194          4.627
LGA    P   200_A      N     195          3.768
LGA    Y   201_A      Y     196          2.390
LGA    T   202_A      D     197          1.063
LGA    V   203_A      T     198          1.014
LGA    A   204_A      L     199          0.710
LGA    Q   205_A      L     200          0.630
LGA    L   206_A      I     201          0.440
LGA    A   207_A      G     202          0.524
LGA    I   208_A      I     203          0.657
LGA    A   209_A      E     204          2.061
LGA    P   210_A      M     205          1.929
LGA    E   211_A      -       -           -
LGA    Q   212_A      S     206          1.265
LGA    R   213_A      R     207          1.671
LGA    Q   214_A      E     208          1.066
LGA    V   215_A      T     209          0.726
LGA    L   216_A      L     210          1.314
LGA    H   217_A      Y     211          0.998
LGA    A   218_A      L     212          0.894
LGA    R   219_A      R     213          1.025
LGA    I   220_A      I     214          0.731
LGA    A   221_A      N     215          0.728
LGA    Q   222_A      K     216          1.057
LGA    R   223_A      R     217          0.959
LGA    F   224_A      V     218          0.649
LGA    R   225_A      D     219          1.078
LGA    Q   226_A      I     220          1.098
LGA    M   227_A      M     221          0.675
LGA    L   228_A      L     222          0.835
LGA    E   229_A      G     223          1.134
LGA    Q   230_A      X     224          0.777
LGA    G   231_A      G     225          0.750
LGA    F   232_A      L     226          0.525
LGA    I   233_A      F     227          0.863
LGA    A   234_A      N     228          0.980
LGA    E   235_A      E     229          0.504
LGA    V   236_A      V     230          0.455
LGA    E   237_A      Q     231          0.395
LGA    A   238_A      X     232          0.807
LGA    L   239_A      L     233          0.893
LGA    H   240_A      V     234          0.743
LGA    A   241_A      E     235          0.777
LGA    R   242_A      Q     236          2.120
LGA    S   243_A      G     237          2.869
LGA    D   244_A      -       -           -
LGA    L   245_A      F     238          2.305
LGA    H   246_A      E     239          2.195
LGA    A   247_A      A     240          3.827
LGA    G   248_A      -       -           -
LGA    L   249_A      S     241          2.184
LGA    P   250_A      Q     242          1.552
LGA    S   251_A      S     243          0.502
LGA    I   252_A      M     244          1.274
LGA    R   253_A      Q     245          2.485
LGA    A   254_A      A     246          2.267
LGA    V   255_A      I     247          1.592
LGA    G   256_A      G     248          1.221
LGA    Y   257_A      Y     249          0.805
LGA    R   258_A      K     250          0.632
LGA    Q   259_A      E     251          0.883
LGA    V   260_A      L     252          1.139
LGA    W   261_A      V     253          0.973
LGA    D   262_A      P     254          1.266
LGA    Y   263_A      V     255          0.996
LGA    L   264_A      I     256          0.665
LGA    D   265_A      K     257          1.580
LGA    G   266_A      G     258          1.126
LGA    K   267_A      N     259          1.594
LGA    L   268_A      I     260          1.309
LGA    S   269_A      S     261          0.680
LGA    Y   270_A      M     262          1.063
LGA    A   271_A      E     263          0.500
LGA    E   272_A      N     264          0.936
LGA    M   273_A      A     265          1.444
LGA    T   274_A      V     266          0.976
LGA    E   275_A      E     267          0.760
LGA    R   276_A      K     268          0.708
LGA    G   277_A      L     269          0.669
LGA    I   278_A      K     270          0.499
LGA    I   279_A      Q     271          0.560
LGA    A   280_A      X     272          0.985
LGA    T   281_A      S     273          0.693
LGA    R   282_A      R     274          0.639
LGA    Q   283_A      Q     275          1.258
LGA    L   284_A      Y     276          0.961
LGA    A   285_A      A     277          0.469
LGA    K   286_A      K     278          1.161
LGA    R   287_A      R     279          1.126
LGA    Q   288_A      Q     280          0.306
LGA    F   289_A      L     281          1.115
LGA    T   290_A      T     282          1.682
LGA    W   291_A      W     283          0.960
LGA    L   292_A      F     284          0.858
LGA    R   293_A      K     285          1.294
LGA    S   294_A      N     286          1.241
LGA    W   295_A      K     287          3.155
LGA    S   296_A      M     288          3.484
LGA    H   297_A      N     289          2.839
LGA    L   298_A      V     290          1.262
LGA    H   299_A      X     291          0.609
LGA    W   300_A      W     292          0.758
LGA    M   301_A      L     293          0.845
LGA    D   302_A      N     294          1.975
LGA    S   303_A      K     295          2.015
LGA    L   304_A      E     296          3.672
LGA    -       -      R     297           -
LGA    A   305_A      M     298          1.157
LGA    G   306_A      S     299          2.038
LGA    -       -      L     300           -
LGA    -       -      Q     301           -
LGA    D   307_A      M     302          0.593
LGA    N   308_A      M     303          0.564
LGA    L   309_A      L     304          0.761
LGA    P   310_A      D     305          0.884
LGA    R   311_A      E     306          0.522
LGA    A   312_A      I     307          0.874
LGA    L   313_A      T     308          1.429
LGA    R   314_A      T     309          1.329
LGA    Y   315_A      Q     310          1.879
LGA    L   316_A      I     311          2.743
LGA    K   317_A      N     312          4.186
LGA    T   318_A      K     313          4.992
LGA    V   319_A      -       -           -
LGA    S   320_A      -       -           -
LGA    I   321_A      R     314          1.172
LGA    L   322_A      S     315          0.692
LGA    A   323_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  236  232    5.0    228    1.45    34.65     92.171    14.668

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.570495 * X  +   0.536604 * Y  +  -0.621765 * Z  + -26.750225
  Y_new =   0.348445 * X  +  -0.843676 * Y  +  -0.408408 * Z  +   8.364316
  Z_new =  -0.743722 * X  +   0.016344 * Y  +  -0.668290 * Z  +  95.714272 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   3.117141   -0.024451  [ DEG:   178.5991     -1.4009 ]
  Theta =   0.838620    2.302972  [ DEG:    48.0494    131.9506 ]
  Phi   =   0.548306   -2.593287  [ DEG:    31.4156   -148.5844 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3crm_A                                        
REMARK     2: T0416_6_115_194_315.pdb                       
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3crm_A.T0416_6_115_194_315.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  236  232   5.0  228   1.45   34.65  92.171
REMARK  ---------------------------------------------------------- 
MOLECULE 3crm_A
HEADER    TRANSFERASE                             07-APR-08   3CRM              
TITLE     STRUCTURE OF TRNA DIMETHYLALLYLTRANSFERASE: RNA                       
TITLE    2 MODIFICATION THROUGH A CHANNEL                                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRNA DELTA(2)-ISOPENTENYLPYROPHOSPHATE                     
COMPND   3 TRANSFERASE;                                                         
COMPND   4 CHAIN: A;                                                            
COMPND   5 SYNONYM: IPP TRANSFERASE, ISOPENTENYL-DIPHOSPHATE:TRNA               
COMPND   6 ISOPENTENYLTRANSFERASE, IPTASE, IPPT, TRNA DMATASE;                  
COMPND   7 EC: 2.5.1.8;                                                         
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS AERUGINOSA;                         
SOURCE   3 GENE: MIAA;                                                          
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PLM-1                                     
KEYWDS    TRANSFERASE, ATP-BINDING, NUCLEOTIDE-BINDING,                         
KEYWDS   2 NUCLEOTIDYLTRANSFERASE, TRNA PROCESSING                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.H.HUANG,W.XIE,C.ZHOU                                                
REVDAT   1   29-APR-08 3CRM    0                                                
JRNL        AUTH   W.XIE,C.ZHOU,R.H.HUANG                                       
JRNL        TITL   STRUCTURE OF TRNA DIMETHYLALLYLTRANSFERASE: RNA              
JRNL        TITL 2 MODIFICATION THROUGH A CHANNEL                               
JRNL        REF    J.MOL.BIOL.                   V. 367   872 2007              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  3CRM A    1   323  UNP    Q9HUL9   MIAA_PSEAE       1    323             
SEQRES   1 A  323  MET SER SER LEU PRO PRO ALA ILE PHE LEU MET GLY PRO          
SEQRES   2 A  323  THR ALA ALA GLY LYS THR ASP LEU ALA MET ALA LEU ALA          
SEQRES   3 A  323  ASP ALA LEU PRO CYS GLU LEU ILE SER VAL ASP SER ALA          
SEQRES   4 A  323  LEU ILE TYR ARG GLY MET ASP ILE GLY THR ALA LYS PRO          
SEQRES   5 A  323  SER ARG GLU LEU LEU ALA ARG TYR PRO HIS ARG LEU ILE          
SEQRES   6 A  323  ASP ILE ARG ASP PRO ALA GLU SER TYR SER ALA ALA GLU          
SEQRES   7 A  323  PHE ARG ALA ASP ALA LEU ALA ALA MET ALA LYS ALA THR          
SEQRES   8 A  323  ALA ARG GLY ARG ILE PRO LEU LEU VAL GLY GLY THR MET          
SEQRES   9 A  323  LEU TYR TYR LYS ALA LEU LEU GLU GLY LEU ALA ASP MET          
SEQRES  10 A  323  PRO GLY ALA ASP PRO GLU VAL ARG ALA ALA ILE GLU ALA          
SEQRES  11 A  323  GLU ALA GLN ALA GLU GLY TRP GLU ALA LEU HIS ARG GLN          
SEQRES  12 A  323  LEU ALA GLU VAL ASP PRO GLU SER ALA ALA ARG ILE HIS          
SEQRES  13 A  323  PRO ASN ASP PRO GLN ARG LEU MET ARG ALA LEU GLU VAL          
SEQRES  14 A  323  TYR ARG LEU GLY GLY VAL SER MET SER ASP LEU ARG ARG          
SEQRES  15 A  323  ARG GLN SER ALA GLU LYS ALA ASP PHE ASP ALA SER GLY          
SEQRES  16 A  323  ARG ASN GLN LEU PRO TYR THR VAL ALA GLN LEU ALA ILE          
SEQRES  17 A  323  ALA PRO GLU GLN ARG GLN VAL LEU HIS ALA ARG ILE ALA          
SEQRES  18 A  323  GLN ARG PHE ARG GLN MET LEU GLU GLN GLY PHE ILE ALA          
SEQRES  19 A  323  GLU VAL GLU ALA LEU HIS ALA ARG SER ASP LEU HIS ALA          
SEQRES  20 A  323  GLY LEU PRO SER ILE ARG ALA VAL GLY TYR ARG GLN VAL          
SEQRES  21 A  323  TRP ASP TYR LEU ASP GLY LYS LEU SER TYR ALA GLU MET          
SEQRES  22 A  323  THR GLU ARG GLY ILE ILE ALA THR ARG GLN LEU ALA LYS          
SEQRES  23 A  323  ARG GLN PHE THR TRP LEU ARG SER TRP SER HIS LEU HIS          
SEQRES  24 A  323  TRP MET ASP SER LEU ALA GLY ASP ASN LEU PRO ARG ALA          
SEQRES  25 A  323  LEU ARG TYR LEU LYS THR VAL SER ILE LEU ALA                  
FORMUL   2  HOH   *109(H2 O)                                                    
CRYST1   76.083   76.083   58.302  90.00  90.00  90.00 P 41          4          
ATOM      1  N   SER A   3      10.593 -21.272  15.843  1.00 47.29           N  
ATOM      2  CA  SER A   3      10.007 -21.108  17.207  1.00 48.00           C  
ATOM      3  C   SER A   3      10.577 -19.849  17.849  1.00 46.65           C  
ATOM      4  O   SER A   3      11.794 -19.697  17.963  1.00 49.66           O  
ATOM      5  CB  SER A   3      10.338 -22.324  18.072  1.00 47.90           C  
ATOM      6  OG  SER A   3      11.740 -22.508  18.178  1.00 50.60           O  
ATOM      7  N   LEU A   4       9.697 -18.943  18.260  1.00 43.13           N  
ATOM      8  CA  LEU A   4      10.135 -17.698  18.878  1.00 39.64           C  
ATOM      9  C   LEU A   4      10.209 -17.830  20.391  1.00 36.26           C  
ATOM     10  O   LEU A   4       9.319 -18.406  21.017  1.00 35.54           O  
ATOM     11  CB  LEU A   4       9.186 -16.559  18.500  1.00 39.77           C  
ATOM     12  CG  LEU A   4       9.124 -16.250  17.001  1.00 40.32           C  
ATOM     13  CD1 LEU A   4       8.101 -15.154  16.733  1.00 41.09           C  
ATOM     14  CD2 LEU A   4      10.505 -15.828  16.520  1.00 40.92           C  
ATOM     15  N   PRO A   5      11.284 -17.306  20.999  1.00 33.66           N  
ATOM     16  CA  PRO A   5      11.430 -17.389  22.454  1.00 31.59           C  
ATOM     17  C   PRO A   5      10.284 -16.666  23.171  1.00 29.87           C  
ATOM     18  O   PRO A   5       9.674 -15.744  22.618  1.00 27.25           O  
ATOM     19  CB  PRO A   5      12.808 -16.769  22.700  1.00 31.01           C  
ATOM     20  CG  PRO A   5      12.972 -15.820  21.550  1.00 33.32           C  
ATOM     21  CD  PRO A   5      12.428 -16.605  20.388  1.00 33.10           C  
ATOM     22  N   PRO A   6       9.976 -17.082  24.412  1.00 28.98           N  
ATOM     23  CA  PRO A   6       8.901 -16.503  25.223  1.00 29.52           C  
ATOM     24  C   PRO A   6       9.156 -15.115  25.807  1.00 28.66           C  
ATOM     25  O   PRO A   6      10.295 -14.714  26.035  1.00 29.18           O  
ATOM     26  CB  PRO A   6       8.706 -17.547  26.315  1.00 27.83           C  
ATOM     27  CG  PRO A   6      10.104 -17.987  26.569  1.00 28.94           C  
ATOM     28  CD  PRO A   6      10.667 -18.150  25.159  1.00 29.75           C  
ATOM     29  N   ALA A   7       8.067 -14.400  26.050  1.00 28.31           N  
ATOM     30  CA  ALA A   7       8.105 -13.065  26.634  1.00 28.76           C  
ATOM     31  C   ALA A   7       6.730 -12.785  27.233  1.00 29.44           C  
ATOM     32  O   ALA A   7       5.713 -13.246  26.714  1.00 31.07           O  
ATOM     33  CB  ALA A   7       8.440 -12.024  25.565  1.00 28.70           C  
ATOM     34  N   ILE A   8       6.703 -12.040  28.330  1.00 28.85           N  
ATOM     35  CA  ILE A   8       5.452 -11.700  28.992  1.00 28.13           C  
ATOM     36  C   ILE A   8       5.334 -10.185  29.143  1.00 29.78           C  
ATOM     37  O   ILE A   8       6.300  -9.523  29.517  1.00 28.17           O  
ATOM     38  CB  ILE A   8       5.377 -12.316  30.416  1.00 29.26           C  
ATOM     39  CG1 ILE A   8       5.493 -13.842  30.348  1.00 30.80           C  
ATOM     40  CG2 ILE A   8       4.074 -11.907  31.087  1.00 29.03           C  
ATOM     41  CD1 ILE A   8       5.683 -14.499  31.711  1.00 30.99           C  
ATOM     42  N   PHE A   9       4.157  -9.648  28.823  1.00 29.06           N  
ATOM     43  CA  PHE A   9       3.870  -8.222  28.984  1.00 29.63           C  
ATOM     44  C   PHE A   9       2.886  -8.170  30.150  1.00 29.58           C  
ATOM     45  O   PHE A   9       1.895  -8.900  30.149  1.00 28.70           O  
ATOM     46  CB  PHE A   9       3.168  -7.636  27.752  1.00 30.52           C  
ATOM     47  CG  PHE A   9       4.081  -7.318  26.598  1.00 31.89           C  
ATOM     48  CD1 PHE A   9       5.399  -7.765  26.569  1.00 30.70           C  
ATOM     49  CD2 PHE A   9       3.598  -6.594  25.511  1.00 32.29           C  
ATOM     50  CE1 PHE A   9       6.218  -7.499  25.474  1.00 33.32           C  
ATOM     51  CE2 PHE A   9       4.410  -6.324  24.410  1.00 34.08           C  
ATOM     52  CZ  PHE A   9       5.721  -6.777  24.394  1.00 33.51           C  
ATOM     53  N   LEU A  10       3.160  -7.332  31.144  1.00 28.55           N  
ATOM     54  CA  LEU A  10       2.269  -7.191  32.290  1.00 28.48           C  
ATOM     55  C   LEU A  10       1.961  -5.702  32.394  1.00 30.01           C  
ATOM     56  O   LEU A  10       2.726  -4.938  32.988  1.00 28.89           O  
ATOM     57  CB  LEU A  10       2.948  -7.669  33.577  1.00 30.77           C  
ATOM     58  CG  LEU A  10       2.034  -8.180  34.699  1.00 34.96           C  
ATOM     59  CD1 LEU A  10       2.824  -8.236  36.000  1.00 35.84           C  
ATOM     60  CD2 LEU A  10       0.818  -7.289  34.858  1.00 35.70           C  
ATOM     61  N   MET A  11       0.841  -5.290  31.808  1.00 28.64           N  
ATOM     62  CA  MET A  11       0.462  -3.886  31.818  1.00 30.24           C  
ATOM     63  C   MET A  11      -0.790  -3.592  32.629  1.00 29.96           C  
ATOM     64  O   MET A  11      -1.484  -4.496  33.097  1.00 29.61           O  
ATOM     65  CB  MET A  11       0.271  -3.392  30.379  1.00 32.14           C  
ATOM     66  CG  MET A  11      -0.746  -4.187  29.582  1.00 35.09           C  
ATOM     67  SD  MET A  11      -0.644  -3.824  27.802  1.00 43.13           S  
ATOM     68  CE  MET A  11       0.647  -4.928  27.323  1.00 38.32           C  
ATOM     69  N   GLY A  12      -1.069  -2.309  32.790  1.00 29.72           N  
ATOM     70  CA  GLY A  12      -2.230  -1.908  33.547  1.00 29.28           C  
ATOM     71  C   GLY A  12      -2.118  -0.457  33.948  1.00 28.68           C  
ATOM     72  O   GLY A  12      -1.048   0.149  33.826  1.00 27.63           O  
ATOM     73  N   PRO A  13      -3.213   0.135  34.430  1.00 28.62           N  
ATOM     74  CA  PRO A  13      -3.180   1.537  34.836  1.00 28.37           C  
ATOM     75  C   PRO A  13      -2.373   1.743  36.107  1.00 28.80           C  
ATOM     76  O   PRO A  13      -2.063   0.788  36.831  1.00 26.59           O  
ATOM     77  CB  PRO A  13      -4.655   1.871  35.020  1.00 29.24           C  
ATOM     78  CG  PRO A  13      -5.218   0.572  35.527  1.00 28.36           C  
ATOM     79  CD  PRO A  13      -4.556  -0.443  34.621  1.00 27.56           C  
ATOM     80  N   THR A  14      -2.035   3.000  36.369  1.00 29.11           N  
ATOM     81  CA  THR A  14      -1.270   3.351  37.554  1.00 29.91           C  
ATOM     82  C   THR A  14      -2.033   2.935  38.813  1.00 28.45           C  
ATOM     83  O   THR A  14      -3.249   3.120  38.905  1.00 28.57           O  
ATOM     84  CB  THR A  14      -0.982   4.876  37.585  1.00 29.70           C  
ATOM     85  OG1 THR A  14      -0.185   5.197  38.730  1.00 31.06           O  
ATOM     86  CG2 THR A  14      -2.279   5.672  37.623  1.00 29.84           C  
ATOM     87  N   ALA A  15      -1.307   2.338  39.757  1.00 27.96           N  
ATOM     88  CA  ALA A  15      -1.850   1.883  41.038  1.00 28.07           C  
ATOM     89  C   ALA A  15      -2.620   0.564  40.980  1.00 29.38           C  
ATOM     90  O   ALA A  15      -3.225   0.157  41.970  1.00 28.48           O  
ATOM     91  CB  ALA A  15      -2.731   2.981  41.659  1.00 28.53           C  
ATOM     92  N   ALA A  16      -2.579  -0.119  39.838  1.00 28.66           N  
ATOM     93  CA  ALA A  16      -3.290  -1.389  39.683  1.00 30.68           C  
ATOM     94  C   ALA A  16      -2.662  -2.566  40.442  1.00 31.75           C  
ATOM     95  O   ALA A  16      -3.298  -3.609  40.611  1.00 31.41           O  
ATOM     96  CB  ALA A  16      -3.405  -1.741  38.206  1.00 33.63           C  
ATOM     97  N   GLY A  17      -1.417  -2.406  40.884  1.00 29.45           N  
ATOM     98  CA  GLY A  17      -0.751  -3.477  41.611  1.00 33.58           C  
ATOM     99  C   GLY A  17       0.007  -4.438  40.707  1.00 33.51           C  
ATOM    100  O   GLY A  17       0.055  -5.641  40.964  1.00 34.71           O  
ATOM    101  N   LYS A  18       0.605  -3.902  39.649  1.00 34.22           N  
ATOM    102  CA  LYS A  18       1.361  -4.708  38.692  1.00 35.99           C  
ATOM    103  C   LYS A  18       2.611  -5.366  39.277  1.00 36.51           C  
ATOM    104  O   LYS A  18       2.914  -6.519  38.971  1.00 34.23           O  
ATOM    105  CB  LYS A  18       1.764  -3.849  37.486  1.00 35.71           C  
ATOM    106  CG  LYS A  18       0.599  -3.441  36.588  1.00 40.44           C  
ATOM    107  CD  LYS A  18       1.045  -2.585  35.401  1.00 41.28           C  
ATOM    108  CE  LYS A  18       1.287  -1.134  35.794  1.00 43.50           C  
ATOM    109  NZ  LYS A  18       2.441  -0.975  36.718  1.00 46.94           N  
ATOM    110  N   THR A  19       3.338  -4.631  40.113  1.00 38.11           N  
ATOM    111  CA  THR A  19       4.571  -5.144  40.708  1.00 38.73           C  
ATOM    112  C   THR A  19       4.360  -6.375  41.588  1.00 39.79           C  
ATOM    113  O   THR A  19       5.232  -7.244  41.673  1.00 39.44           O  
ATOM    114  CB  THR A  19       5.283  -4.040  41.525  1.00 40.37           C  
ATOM    115  OG1 THR A  19       5.523  -2.908  40.679  1.00 40.30           O  
ATOM    116  CG2 THR A  19       6.620  -4.545  42.067  1.00 40.38           C  
ATOM    117  N   ASP A  20       3.205  -6.454  42.240  1.00 39.28           N  
ATOM    118  CA  ASP A  20       2.898  -7.591  43.101  1.00 40.06           C  
ATOM    119  C   ASP A  20       2.791  -8.876  42.285  1.00 37.97           C  
ATOM    120  O   ASP A  20       3.308  -9.919  42.683  1.00 36.28           O  
ATOM    121  CB  ASP A  20       1.588  -7.341  43.854  1.00 44.08           C  
ATOM    122  CG  ASP A  20       1.728  -6.271  44.923  1.00 48.56           C  
ATOM    123  OD1 ASP A  20       0.699  -5.663  45.297  1.00 50.72           O  
ATOM    124  OD2 ASP A  20       2.865  -6.049  45.396  1.00 49.53           O  
ATOM    125  N   LEU A  21       2.120  -8.801  41.141  1.00 35.41           N  
ATOM    126  CA  LEU A  21       1.970  -9.975  40.290  1.00 34.57           C  
ATOM    127  C   LEU A  21       3.297 -10.315  39.615  1.00 32.37           C  
ATOM    128  O   LEU A  21       3.605 -11.484  39.383  1.00 31.39           O  
ATOM    129  CB  LEU A  21       0.892  -9.734  39.233  1.00 33.39           C  
ATOM    130  CG  LEU A  21       0.704 -10.868  38.222  1.00 33.39           C  
ATOM    131  CD1 LEU A  21       0.481 -12.193  38.949  1.00 32.27           C  
ATOM    132  CD2 LEU A  21      -0.469 -10.548  37.319  1.00 33.10           C  
ATOM    133  N   ALA A  22       4.080  -9.287  39.305  1.00 32.29           N  
ATOM    134  CA  ALA A  22       5.377  -9.480  38.668  1.00 31.45           C  
ATOM    135  C   ALA A  22       6.290 -10.292  39.593  1.00 32.02           C  
ATOM    136  O   ALA A  22       7.017 -11.183  39.152  1.00 29.95           O  
ATOM    137  CB  ALA A  22       6.008  -8.123  38.355  1.00 32.29           C  
ATOM    138  N   MET A  23       6.243  -9.982  40.883  1.00 32.41           N  
ATOM    139  CA  MET A  23       7.060 -10.692  41.857  1.00 34.66           C  
ATOM    140  C   MET A  23       6.633 -12.151  41.965  1.00 35.47           C  
ATOM    141  O   MET A  23       7.474 -13.049  42.029  1.00 35.25           O  
ATOM    142  CB  MET A  23       6.961 -10.013  43.221  1.00 37.77           C  
ATOM    143  CG  MET A  23       7.847  -8.788  43.355  1.00 41.60           C  
ATOM    144  SD  MET A  23       7.630  -7.915  44.920  1.00 48.89           S  
ATOM    145  CE  MET A  23       7.428  -9.278  46.084  1.00 49.33           C  
ATOM    146  N   ALA A  24       5.324 -12.383  41.979  1.00 35.79           N  
ATOM    147  CA  ALA A  24       4.797 -13.737  42.065  1.00 35.84           C  
ATOM    148  C   ALA A  24       5.277 -14.546  40.863  1.00 36.16           C  
ATOM    149  O   ALA A  24       5.684 -15.705  40.996  1.00 35.98           O  
ATOM    150  CB  ALA A  24       3.269 -13.703  42.105  1.00 36.85           C  
ATOM    151  N   LEU A  25       5.229 -13.930  39.684  1.00 34.37           N  
ATOM    152  CA  LEU A  25       5.672 -14.596  38.466  1.00 33.55           C  
ATOM    153  C   LEU A  25       7.175 -14.874  38.514  1.00 33.45           C  
ATOM    154  O   LEU A  25       7.627 -15.955  38.135  1.00 33.02           O  
ATOM    155  CB  LEU A  25       5.328 -13.738  37.244  1.00 32.76           C  
ATOM    156  CG  LEU A  25       3.838 -13.734  36.882  1.00 36.11           C  
ATOM    157  CD1 LEU A  25       3.532 -12.641  35.871  1.00 34.88           C  
ATOM    158  CD2 LEU A  25       3.460 -15.106  36.328  1.00 35.63           C  
ATOM    159  N   ALA A  26       7.938 -13.900  38.999  1.00 33.65           N  
ATOM    160  CA  ALA A  26       9.385 -14.038  39.089  1.00 35.15           C  
ATOM    161  C   ALA A  26       9.789 -15.164  40.040  1.00 36.72           C  
ATOM    162  O   ALA A  26      10.838 -15.780  39.864  1.00 36.99           O  
ATOM    163  CB  ALA A  26      10.007 -12.725  39.541  1.00 34.89           C  
ATOM    164  N   ASP A  27       8.961 -15.427  41.046  1.00 38.51           N  
ATOM    165  CA  ASP A  27       9.249 -16.488  42.005  1.00 39.81           C  
ATOM    166  C   ASP A  27       8.795 -17.848  41.481  1.00 39.83           C  
ATOM    167  O   ASP A  27       9.197 -18.886  42.007  1.00 40.18           O  
ATOM    168  CB  ASP A  27       8.560 -16.218  43.352  1.00 41.29           C  
ATOM    169  CG  ASP A  27       9.176 -15.052  44.111  1.00 43.84           C  
ATOM    170  OD1 ASP A  27      10.421 -14.944  44.139  1.00 45.53           O  
ATOM    171  OD2 ASP A  27       8.414 -14.254  44.697  1.00 45.89           O  
ATOM    172  N   ALA A  28       7.962 -17.843  40.444  1.00 38.14           N  
ATOM    173  CA  ALA A  28       7.453 -19.087  39.873  1.00 37.83           C  
ATOM    174  C   ALA A  28       8.210 -19.526  38.619  1.00 38.16           C  
ATOM    175  O   ALA A  28       8.331 -20.720  38.346  1.00 36.39           O  
ATOM    176  CB  ALA A  28       5.964 -18.941  39.561  1.00 39.11           C  
ATOM    177  N   LEU A  29       8.714 -18.560  37.859  1.00 37.18           N  
ATOM    178  CA  LEU A  29       9.452 -18.847  36.632  1.00 37.05           C  
ATOM    179  C   LEU A  29      10.723 -18.009  36.571  1.00 36.14           C  
ATOM    180  O   LEU A  29      10.818 -16.960  37.213  1.00 34.74           O  
ATOM    181  CB  LEU A  29       8.585 -18.532  35.407  1.00 40.56           C  
ATOM    182  CG  LEU A  29       7.340 -19.381  35.136  1.00 41.99           C  
ATOM    183  CD1 LEU A  29       6.513 -18.736  34.036  1.00 44.46           C  
ATOM    184  CD2 LEU A  29       7.751 -20.790  34.738  1.00 42.15           C  
ATOM    185  N   PRO A  30      11.727 -18.468  35.808  1.00 35.01           N  
ATOM    186  CA  PRO A  30      12.975 -17.707  35.698  1.00 34.36           C  
ATOM    187  C   PRO A  30      12.708 -16.495  34.814  1.00 34.13           C  
ATOM    188  O   PRO A  30      12.716 -16.595  33.590  1.00 32.99           O  
ATOM    189  CB  PRO A  30      13.930 -18.707  35.051  1.00 34.18           C  
ATOM    190  CG  PRO A  30      13.013 -19.495  34.152  1.00 36.16           C  
ATOM    191  CD  PRO A  30      11.802 -19.724  35.036  1.00 34.84           C  
ATOM    192  N   CYS A  31      12.462 -15.353  35.443  1.00 33.69           N  
ATOM    193  CA  CYS A  31      12.162 -14.137  34.703  1.00 35.13           C  
ATOM    194  C   CYS A  31      13.220 -13.056  34.810  1.00 33.46           C  
ATOM    195  O   CYS A  31      14.105 -13.100  35.662  1.00 34.35           O  
ATOM    196  CB  CYS A  31      10.823 -13.557  35.172  1.00 35.22           C  
ATOM    197  SG  CYS A  31       9.411 -14.639  34.930  1.00 40.04           S  
ATOM    198  N   GLU A  32      13.111 -12.088  33.911  1.00 32.54           N  
ATOM    199  CA  GLU A  32      13.997 -10.941  33.874  1.00 32.46           C  
ATOM    200  C   GLU A  32      13.038  -9.764  33.817  1.00 30.69           C  
ATOM    201  O   GLU A  32      12.439  -9.510  32.775  1.00 28.76           O  
ATOM    202  CB  GLU A  32      14.853 -10.959  32.613  1.00 36.37           C  
ATOM    203  CG  GLU A  32      15.880  -9.848  32.544  1.00 41.38           C  
ATOM    204  CD  GLU A  32      17.007 -10.042  33.537  1.00 47.81           C  
ATOM    205  OE1 GLU A  32      16.777  -9.856  34.752  1.00 51.22           O  
ATOM    206  OE2 GLU A  32      18.122 -10.395  33.101  1.00 49.53           O  
ATOM    207  N   LEU A  33      12.885  -9.064  34.937  1.00 28.93           N  
ATOM    208  CA  LEU A  33      11.982  -7.924  35.021  1.00 29.08           C  
ATOM    209  C   LEU A  33      12.511  -6.722  34.256  1.00 28.08           C  
ATOM    210  O   LEU A  33      13.653  -6.294  34.454  1.00 25.95           O  
ATOM    211  CB  LEU A  33      11.759  -7.540  36.487  1.00 29.21           C  
ATOM    212  CG  LEU A  33      10.978  -8.562  37.316  1.00 33.72           C  
ATOM    213  CD1 LEU A  33      11.117  -8.250  38.797  1.00 36.54           C  
ATOM    214  CD2 LEU A  33       9.522  -8.538  36.896  1.00 33.57           C  
ATOM    215  N   ILE A  34      11.669  -6.190  33.375  1.00 27.17           N  
ATOM    216  CA  ILE A  34      12.012  -5.031  32.563  1.00 25.92           C  
ATOM    217  C   ILE A  34      10.904  -4.000  32.735  1.00 26.59           C  
ATOM    218  O   ILE A  34       9.735  -4.272  32.443  1.00 23.81           O  
ATOM    219  CB  ILE A  34      12.136  -5.407  31.068  1.00 26.36           C  
ATOM    220  CG1 ILE A  34      13.223  -6.473  30.892  1.00 29.74           C  
ATOM    221  CG2 ILE A  34      12.467  -4.168  30.239  1.00 25.53           C  
ATOM    222  CD1 ILE A  34      13.411  -6.941  29.463  1.00 30.40           C  
ATOM    223  N   SER A  35      11.269  -2.817  33.218  1.00 25.94           N  
ATOM    224  CA  SER A  35      10.286  -1.764  33.440  1.00 25.05           C  
ATOM    225  C   SER A  35       9.931  -1.031  32.152  1.00 25.58           C  
ATOM    226  O   SER A  35      10.802  -0.698  31.356  1.00 27.59           O  
ATOM    227  CB  SER A  35      10.810  -0.767  34.475  1.00 25.22           C  
ATOM    228  OG  SER A  35       9.873   0.265  34.703  1.00 25.13           O  
ATOM    229  N   VAL A  36       8.635  -0.805  31.955  1.00 24.85           N  
ATOM    230  CA  VAL A  36       8.123  -0.091  30.789  1.00 25.72           C  
ATOM    231  C   VAL A  36       7.399   1.115  31.387  1.00 27.52           C  
ATOM    232  O   VAL A  36       6.174   1.125  31.502  1.00 27.83           O  
ATOM    233  CB  VAL A  36       7.117  -0.961  30.003  1.00 24.34           C  
ATOM    234  CG1 VAL A  36       6.725  -0.272  28.696  1.00 23.46           C  
ATOM    235  CG2 VAL A  36       7.736  -2.331  29.720  1.00 24.77           C  
ATOM    236  N   ASP A  37       8.175   2.124  31.785  1.00 27.78           N  
ATOM    237  CA  ASP A  37       7.625   3.319  32.419  1.00 26.89           C  
ATOM    238  C   ASP A  37       8.501   4.535  32.119  1.00 27.77           C  
ATOM    239  O   ASP A  37       9.683   4.548  32.456  1.00 24.60           O  
ATOM    240  CB  ASP A  37       7.563   3.097  33.929  1.00 28.79           C  
ATOM    241  CG  ASP A  37       6.818   4.198  34.652  1.00 32.18           C  
ATOM    242  OD1 ASP A  37       5.686   3.939  35.107  1.00 35.53           O  
ATOM    243  OD2 ASP A  37       7.352   5.319  34.760  1.00 31.90           O  
ATOM    244  N   SER A  38       7.911   5.555  31.500  1.00 27.68           N  
ATOM    245  CA  SER A  38       8.638   6.774  31.135  1.00 27.91           C  
ATOM    246  C   SER A  38       9.083   7.619  32.328  1.00 29.09           C  
ATOM    247  O   SER A  38       9.871   8.554  32.171  1.00 32.43           O  
ATOM    248  CB  SER A  38       7.772   7.631  30.207  1.00 27.71           C  
ATOM    249  OG  SER A  38       6.525   7.942  30.821  1.00 28.61           O  
ATOM    250  N   ALA A  39       8.579   7.296  33.515  1.00 26.97           N  
ATOM    251  CA  ALA A  39       8.926   8.045  34.725  1.00 27.66           C  
ATOM    252  C   ALA A  39       9.954   7.335  35.613  1.00 27.27           C  
ATOM    253  O   ALA A  39      10.837   7.975  36.185  1.00 24.62           O  
ATOM    254  CB  ALA A  39       7.657   8.335  35.535  1.00 27.60           C  
ATOM    255  N   LEU A  40       9.831   6.016  35.736  1.00 24.49           N  
ATOM    256  CA  LEU A  40      10.750   5.234  36.568  1.00 23.60           C  
ATOM    257  C   LEU A  40      12.199   5.232  36.084  1.00 22.76           C  
ATOM    258  O   LEU A  40      13.103   4.839  36.826  1.00 22.52           O  
ATOM    259  CB  LEU A  40      10.237   3.791  36.694  1.00 24.84           C  
ATOM    260  CG  LEU A  40       9.289   3.477  37.859  1.00 29.52           C  
ATOM    261  CD1 LEU A  40       8.447   4.677  38.207  1.00 30.78           C  
ATOM    262  CD2 LEU A  40       8.419   2.270  37.504  1.00 28.16           C  
ATOM    263  N   ILE A  41      12.428   5.657  34.846  1.00 24.12           N  
ATOM    264  CA  ILE A  41      13.790   5.702  34.317  1.00 25.93           C  
ATOM    265  C   ILE A  41      14.638   6.750  35.036  1.00 24.99           C  
ATOM    266  O   ILE A  41      15.866   6.657  35.044  1.00 24.85           O  
ATOM    267  CB  ILE A  41      13.817   6.057  32.807  1.00 26.65           C  
ATOM    268  CG1 ILE A  41      13.184   7.430  32.587  1.00 26.01           C  
ATOM    269  CG2 ILE A  41      13.087   4.993  32.001  1.00 26.58           C  
ATOM    270  CD1 ILE A  41      13.330   7.952  31.166  1.00 29.86           C  
ATOM    271  N   TYR A  42      13.981   7.730  35.654  1.00 25.56           N  
ATOM    272  CA  TYR A  42      14.685   8.829  36.318  1.00 25.38           C  
ATOM    273  C   TYR A  42      15.164   8.657  37.750  1.00 26.10           C  
ATOM    274  O   TYR A  42      14.378   8.395  38.660  1.00 24.73           O  
ATOM    275  CB  TYR A  42      13.837  10.100  36.255  1.00 24.94           C  
ATOM    276  CG  TYR A  42      13.615  10.606  34.854  1.00 25.83           C  
ATOM    277  CD1 TYR A  42      12.339  10.616  34.290  1.00 25.33           C  
ATOM    278  CD2 TYR A  42      14.685  11.063  34.084  1.00 25.57           C  
ATOM    279  CE1 TYR A  42      12.135  11.067  32.995  1.00 28.54           C  
ATOM    280  CE2 TYR A  42      14.495  11.517  32.786  1.00 27.32           C  
ATOM    281  CZ  TYR A  42      13.217  11.518  32.249  1.00 28.05           C  
ATOM    282  OH  TYR A  42      13.022  11.979  30.971  1.00 32.15           O  
ATOM    283  N   ARG A  43      16.464   8.842  37.943  1.00 25.92           N  
ATOM    284  CA  ARG A  43      17.058   8.758  39.268  1.00 27.32           C  
ATOM    285  C   ARG A  43      16.585   9.999  40.024  1.00 27.55           C  
ATOM    286  O   ARG A  43      16.372  11.053  39.422  1.00 26.55           O  
ATOM    287  CB  ARG A  43      18.589   8.755  39.164  1.00 30.62           C  
ATOM    288  CG  ARG A  43      19.161   7.557  38.418  1.00 31.71           C  
ATOM    289  CD  ARG A  43      20.680   7.524  38.515  1.00 34.46           C  
ATOM    290  NE  ARG A  43      21.307   8.564  37.704  1.00 37.79           N  
ATOM    291  CZ  ARG A  43      21.655   8.409  36.430  1.00 39.16           C  
ATOM    292  NH1 ARG A  43      21.441   7.251  35.820  1.00 38.69           N  
ATOM    293  NH2 ARG A  43      22.216   9.413  35.766  1.00 39.01           N  
ATOM    294  N   GLY A  44      16.407   9.869  41.336  1.00 27.07           N  
ATOM    295  CA  GLY A  44      15.949  10.992  42.136  1.00 28.66           C  
ATOM    296  C   GLY A  44      14.440  11.206  42.118  1.00 29.89           C  
ATOM    297  O   GLY A  44      13.933  12.123  42.762  1.00 30.10           O  
ATOM    298  N   MET A  45      13.718  10.381  41.366  1.00 27.85           N  
ATOM    299  CA  MET A  45      12.262  10.496  41.296  1.00 26.36           C  
ATOM    300  C   MET A  45      11.727   9.128  41.685  1.00 26.46           C  
ATOM    301  O   MET A  45      11.400   8.300  40.827  1.00 27.45           O  
ATOM    302  CB  MET A  45      11.831  10.894  39.877  1.00 25.78           C  
ATOM    303  CG  MET A  45      12.358  12.281  39.453  1.00 27.26           C  
ATOM    304  SD  MET A  45      11.970  12.799  37.751  1.00 27.44           S  
ATOM    305  CE  MET A  45      10.195  12.929  37.859  1.00 29.03           C  
ATOM    306  N   ASP A  46      11.640   8.901  42.993  1.00 26.46           N  
ATOM    307  CA  ASP A  46      11.215   7.605  43.525  1.00 27.29           C  
ATOM    308  C   ASP A  46       9.869   7.579  44.253  1.00 26.56           C  
ATOM    309  O   ASP A  46       9.074   6.651  44.070  1.00 26.19           O  
ATOM    310  CB  ASP A  46      12.281   7.066  44.488  1.00 29.06           C  
ATOM    311  CG  ASP A  46      13.699   7.229  43.961  1.00 32.58           C  
ATOM    312  OD1 ASP A  46      13.912   7.135  42.734  1.00 33.97           O  
ATOM    313  OD2 ASP A  46      14.611   7.436  44.789  1.00 36.89           O  
ATOM    314  N   ILE A  47       9.636   8.577  45.099  1.00 25.18           N  
ATOM    315  CA  ILE A  47       8.405   8.663  45.882  1.00 24.61           C  
ATOM    316  C   ILE A  47       7.187   9.038  45.032  1.00 25.61           C  
ATOM    317  O   ILE A  47       6.171   8.341  45.044  1.00 24.42           O  
ATOM    318  CB  ILE A  47       8.561   9.697  47.025  1.00 25.20           C  
ATOM    319  CG1 ILE A  47       9.691   9.255  47.965  1.00 28.15           C  
ATOM    320  CG2 ILE A  47       7.238   9.838  47.798  1.00 27.87           C  
ATOM    321  CD1 ILE A  47      10.089  10.307  48.979  1.00 32.02           C  
ATOM    322  N   GLY A  48       7.302  10.139  44.297  1.00 23.94           N  
ATOM    323  CA  GLY A  48       6.198  10.590  43.463  1.00 25.40           C  
ATOM    324  C   GLY A  48       5.856   9.686  42.290  1.00 24.26           C  
ATOM    325  O   GLY A  48       4.784   9.815  41.695  1.00 23.46           O  
ATOM    326  N   THR A  49       6.759   8.777  41.949  1.00 24.13           N  
ATOM    327  CA  THR A  49       6.543   7.852  40.841  1.00 25.01           C  
ATOM    328  C   THR A  49       6.132   6.462  41.318  1.00 25.85           C  
ATOM    329  O   THR A  49       5.956   5.554  40.507  1.00 25.77           O  
ATOM    330  CB  THR A  49       7.819   7.677  40.006  1.00 26.56           C  
ATOM    331  OG1 THR A  49       8.877   7.211  40.856  1.00 24.70           O  
ATOM    332  CG2 THR A  49       8.222   8.997  39.345  1.00 23.27           C  
ATOM    333  N   ALA A  50       5.996   6.295  42.631  1.00 25.46           N  
ATOM    334  CA  ALA A  50       5.638   4.999  43.211  1.00 27.53           C  
ATOM    335  C   ALA A  50       6.647   3.925  42.795  1.00 28.41           C  
ATOM    336  O   ALA A  50       6.290   2.770  42.551  1.00 27.60           O  
ATOM    337  CB  ALA A  50       4.222   4.592  42.784  1.00 27.28           C  
ATOM    338  N   LYS A  51       7.916   4.311  42.719  1.00 27.07           N  
ATOM    339  CA  LYS A  51       8.969   3.380  42.338  1.00 26.92           C  
ATOM    340  C   LYS A  51       9.139   2.307  43.414  1.00 28.10           C  
ATOM    341  O   LYS A  51       9.044   2.593  44.604  1.00 27.23           O  
ATOM    342  CB  LYS A  51      10.289   4.135  42.150  1.00 26.46           C  
ATOM    343  CG  LYS A  51      11.453   3.280  41.635  1.00 29.02           C  
ATOM    344  CD  LYS A  51      12.713   4.130  41.432  1.00 27.41           C  
ATOM    345  CE  LYS A  51      12.502   5.176  40.345  1.00 27.12           C  
ATOM    346  NZ  LYS A  51      13.591   6.196  40.322  1.00 27.90           N  
ATOM    347  N   PRO A  52       9.360   1.050  43.007  1.00 29.08           N  
ATOM    348  CA  PRO A  52       9.535  -0.002  44.012  1.00 31.38           C  
ATOM    349  C   PRO A  52      10.677   0.376  44.953  1.00 32.13           C  
ATOM    350  O   PRO A  52      11.638   1.028  44.537  1.00 31.92           O  
ATOM    351  CB  PRO A  52       9.857  -1.227  43.171  1.00 31.84           C  
ATOM    352  CG  PRO A  52       9.026  -0.999  41.944  1.00 32.95           C  
ATOM    353  CD  PRO A  52       9.254   0.477  41.653  1.00 28.87           C  
ATOM    354  N   SER A  53      10.572  -0.026  46.214  1.00 32.42           N  
ATOM    355  CA  SER A  53      11.605   0.295  47.193  1.00 35.15           C  
ATOM    356  C   SER A  53      12.956  -0.286  46.800  1.00 34.99           C  
ATOM    357  O   SER A  53      13.036  -1.246  46.034  1.00 33.47           O  
ATOM    358  CB  SER A  53      11.213  -0.233  48.577  1.00 36.20           C  
ATOM    359  OG  SER A  53      11.241  -1.651  48.601  1.00 36.88           O  
ATOM    360  N   ARG A  54      14.016   0.305  47.336  1.00 37.29           N  
ATOM    361  CA  ARG A  54      15.370  -0.147  47.057  1.00 39.82           C  
ATOM    362  C   ARG A  54      15.555  -1.591  47.536  1.00 39.51           C  
ATOM    363  O   ARG A  54      16.275  -2.372  46.918  1.00 37.08           O  
ATOM    364  CB  ARG A  54      16.370   0.791  47.740  1.00 43.44           C  
ATOM    365  CG  ARG A  54      17.812   0.608  47.298  1.00 50.86           C  
ATOM    366  CD  ARG A  54      18.477   1.952  47.007  1.00 54.34           C  
ATOM    367  NE  ARG A  54      18.392   2.882  48.132  1.00 58.59           N  
ATOM    368  CZ  ARG A  54      18.917   4.106  48.135  1.00 60.74           C  
ATOM    369  NH1 ARG A  54      19.571   4.555  47.069  1.00 60.72           N  
ATOM    370  NH2 ARG A  54      18.786   4.887  49.200  1.00 61.08           N  
ATOM    371  N   GLU A  55      14.893  -1.949  48.633  1.00 41.15           N  
ATOM    372  CA  GLU A  55      14.985  -3.308  49.161  1.00 44.11           C  
ATOM    373  C   GLU A  55      14.297  -4.283  48.208  1.00 43.12           C  
ATOM    374  O   GLU A  55      14.774  -5.396  47.984  1.00 42.22           O  
ATOM    375  CB  GLU A  55      14.329  -3.399  50.543  1.00 47.88           C  
ATOM    376  CG  GLU A  55      13.374  -2.256  50.865  1.00 53.73           C  
ATOM    377  CD  GLU A  55      14.103  -0.992  51.295  1.00 56.00           C  
ATOM    378  OE1 GLU A  55      14.679  -0.989  52.406  1.00 58.75           O  
ATOM    379  OE2 GLU A  55      14.108  -0.009  50.525  1.00 57.28           O  
ATOM    380  N   LEU A  56      13.176  -3.851  47.644  1.00 41.04           N  
ATOM    381  CA  LEU A  56      12.423  -4.685  46.718  1.00 40.54           C  
ATOM    382  C   LEU A  56      13.218  -4.866  45.426  1.00 39.23           C  
ATOM    383  O   LEU A  56      13.309  -5.973  44.892  1.00 38.83           O  
ATOM    384  CB  LEU A  56      11.067  -4.038  46.421  1.00 42.79           C  
ATOM    385  CG  LEU A  56       9.934  -4.938  45.918  1.00 43.94           C  
ATOM    386  CD1 LEU A  56      10.241  -5.471  44.524  1.00 45.71           C  
ATOM    387  CD2 LEU A  56       9.735  -6.075  46.909  1.00 46.74           C  
ATOM    388  N   LEU A  57      13.797  -3.776  44.929  1.00 37.68           N  
ATOM    389  CA  LEU A  57      14.583  -3.830  43.701  1.00 37.49           C  
ATOM    390  C   LEU A  57      15.804  -4.733  43.859  1.00 38.40           C  
ATOM    391  O   LEU A  57      16.268  -5.338  42.893  1.00 36.77           O  
ATOM    392  CB  LEU A  57      15.026  -2.420  43.288  1.00 37.87           C  
ATOM    393  CG  LEU A  57      13.885  -1.481  42.883  1.00 36.48           C  
ATOM    394  CD1 LEU A  57      14.438  -0.114  42.506  1.00 36.96           C  
ATOM    395  CD2 LEU A  57      13.127  -2.090  41.718  1.00 36.67           C  
ATOM    396  N   ALA A  58      16.315  -4.816  45.081  1.00 39.05           N  
ATOM    397  CA  ALA A  58      17.476  -5.653  45.371  1.00 41.38           C  
ATOM    398  C   ALA A  58      17.149  -7.129  45.159  1.00 41.32           C  
ATOM    399  O   ALA A  58      17.956  -7.877  44.610  1.00 42.80           O  
ATOM    400  CB  ALA A  58      17.941  -5.422  46.806  1.00 40.07           C  
ATOM    401  N   ARG A  59      15.963  -7.546  45.594  1.00 41.43           N  
ATOM    402  CA  ARG A  59      15.546  -8.936  45.446  1.00 41.51           C  
ATOM    403  C   ARG A  59      14.840  -9.221  44.118  1.00 41.05           C  
ATOM    404  O   ARG A  59      14.766 -10.371  43.683  1.00 40.31           O  
ATOM    405  CB  ARG A  59      14.647  -9.337  46.619  1.00 45.32           C  
ATOM    406  CG  ARG A  59      13.517  -8.374  46.889  1.00 51.48           C  
ATOM    407  CD  ARG A  59      12.710  -8.798  48.109  1.00 56.42           C  
ATOM    408  NE  ARG A  59      12.262 -10.185  48.009  1.00 60.46           N  
ATOM    409  CZ  ARG A  59      11.262 -10.700  48.717  1.00 62.02           C  
ATOM    410  NH1 ARG A  59      10.598  -9.941  49.580  1.00 62.70           N  
ATOM    411  NH2 ARG A  59      10.925 -11.973  48.561  1.00 63.11           N  
ATOM    412  N   TYR A  60      14.323  -8.172  43.481  1.00 38.43           N  
ATOM    413  CA  TYR A  60      13.640  -8.289  42.195  1.00 37.09           C  
ATOM    414  C   TYR A  60      14.156  -7.177  41.278  1.00 35.78           C  
ATOM    415  O   TYR A  60      13.482  -6.164  41.072  1.00 35.40           O  
ATOM    416  CB  TYR A  60      12.128  -8.131  42.373  1.00 37.44           C  
ATOM    417  CG  TYR A  60      11.481  -9.207  43.215  1.00 39.51           C  
ATOM    418  CD1 TYR A  60      11.204 -10.468  42.685  1.00 39.53           C  
ATOM    419  CD2 TYR A  60      11.134  -8.958  44.541  1.00 39.12           C  
ATOM    420  CE1 TYR A  60      10.588 -11.457  43.461  1.00 40.47           C  
ATOM    421  CE2 TYR A  60      10.524  -9.934  45.326  1.00 39.74           C  
ATOM    422  CZ  TYR A  60      10.251 -11.178  44.782  1.00 39.88           C  
ATOM    423  OH  TYR A  60       9.629 -12.129  45.557  1.00 41.42           O  
ATOM    424  N   PRO A  61      15.367  -7.351  40.725  1.00 35.11           N  
ATOM    425  CA  PRO A  61      15.984  -6.365  39.832  1.00 34.91           C  
ATOM    426  C   PRO A  61      15.129  -6.051  38.610  1.00 33.70           C  
ATOM    427  O   PRO A  61      14.590  -6.950  37.968  1.00 33.16           O  
ATOM    428  CB  PRO A  61      17.307  -7.028  39.451  1.00 36.42           C  
ATOM    429  CG  PRO A  61      17.617  -7.864  40.654  1.00 37.48           C  
ATOM    430  CD  PRO A  61      16.282  -8.483  40.952  1.00 36.20           C  
ATOM    431  N   HIS A  62      15.010  -4.763  38.304  1.00 32.28           N  
ATOM    432  CA  HIS A  62      14.236  -4.298  37.157  1.00 32.06           C  
ATOM    433  C   HIS A  62      15.150  -3.573  36.182  1.00 32.13           C  
ATOM    434  O   HIS A  62      15.873  -2.656  36.571  1.00 33.46           O  
ATOM    435  CB  HIS A  62      13.162  -3.292  37.581  1.00 32.55           C  
ATOM    436  CG  HIS A  62      11.948  -3.900  38.207  1.00 33.56           C  
ATOM    437  ND1 HIS A  62      12.006  -4.713  39.317  1.00 30.85           N  
ATOM    438  CD2 HIS A  62      10.634  -3.755  37.914  1.00 33.04           C  
ATOM    439  CE1 HIS A  62      10.779  -5.040  39.683  1.00 34.81           C  
ATOM    440  NE2 HIS A  62       9.928  -4.472  38.848  1.00 32.66           N  
ATOM    441  N   ARG A  63      15.124  -3.974  34.917  1.00 29.15           N  
ATOM    442  CA  ARG A  63      15.920  -3.278  33.919  1.00 28.29           C  
ATOM    443  C   ARG A  63      15.178  -1.982  33.574  1.00 27.18           C  
ATOM    444  O   ARG A  63      13.951  -1.914  33.677  1.00 26.02           O  
ATOM    445  CB  ARG A  63      16.065  -4.128  32.653  1.00 29.33           C  
ATOM    446  CG  ARG A  63      16.772  -5.460  32.872  1.00 33.85           C  
ATOM    447  CD  ARG A  63      18.206  -5.255  33.325  1.00 36.15           C  
ATOM    448  NE  ARG A  63      18.881  -6.529  33.548  1.00 41.16           N  
ATOM    449  CZ  ARG A  63      20.164  -6.650  33.875  1.00 43.51           C  
ATOM    450  NH1 ARG A  63      20.920  -5.567  34.020  1.00 44.09           N  
ATOM    451  NH2 ARG A  63      20.693  -7.856  34.057  1.00 42.15           N  
ATOM    452  N   LEU A  64      15.934  -0.962  33.176  1.00 26.24           N  
ATOM    453  CA  LEU A  64      15.391   0.336  32.774  1.00 27.47           C  
ATOM    454  C   LEU A  64      14.796   1.214  33.875  1.00 28.10           C  
ATOM    455  O   LEU A  64      13.891   2.012  33.627  1.00 26.61           O  
ATOM    456  CB  LEU A  64      14.375   0.157  31.640  1.00 28.00           C  
ATOM    457  CG  LEU A  64      14.872  -0.693  30.462  1.00 27.01           C  
ATOM    458  CD1 LEU A  64      13.829  -0.681  29.368  1.00 27.96           C  
ATOM    459  CD2 LEU A  64      16.204  -0.161  29.931  1.00 28.79           C  
ATOM    460  N   ILE A  65      15.294   1.052  35.094  1.00 27.20           N  
ATOM    461  CA  ILE A  65      14.868   1.897  36.198  1.00 26.19           C  
ATOM    462  C   ILE A  65      16.147   2.584  36.667  1.00 28.00           C  
ATOM    463  O   ILE A  65      17.200   1.944  36.756  1.00 26.15           O  
ATOM    464  CB  ILE A  65      14.252   1.096  37.362  1.00 27.66           C  
ATOM    465  CG1 ILE A  65      12.877   0.559  36.947  1.00 27.07           C  
ATOM    466  CG2 ILE A  65      14.101   1.997  38.597  1.00 28.58           C  
ATOM    467  CD1 ILE A  65      12.095  -0.081  38.089  1.00 29.44           C  
ATOM    468  N   ASP A  66      16.055   3.884  36.941  1.00 26.93           N  
ATOM    469  CA  ASP A  66      17.199   4.680  37.393  1.00 28.36           C  
ATOM    470  C   ASP A  66      18.337   4.700  36.371  1.00 29.03           C  
ATOM    471  O   ASP A  66      19.510   4.595  36.738  1.00 29.49           O  
ATOM    472  CB  ASP A  66      17.739   4.157  38.737  1.00 31.39           C  
ATOM    473  CG  ASP A  66      16.791   4.421  39.898  1.00 33.72           C  
ATOM    474  OD1 ASP A  66      16.090   5.454  39.870  1.00 33.43           O  
ATOM    475  OD2 ASP A  66      16.756   3.605  40.847  1.00 36.10           O  
ATOM    476  N   ILE A  67      17.996   4.849  35.096  1.00 26.05           N  
ATOM    477  CA  ILE A  67      18.999   4.863  34.037  1.00 27.34           C  
ATOM    478  C   ILE A  67      19.261   6.246  33.437  1.00 26.63           C  
ATOM    479  O   ILE A  67      20.127   6.399  32.576  1.00 26.17           O  
ATOM    480  CB  ILE A  67      18.592   3.927  32.885  1.00 29.45           C  
ATOM    481  CG1 ILE A  67      17.198   4.304  32.379  1.00 30.11           C  
ATOM    482  CG2 ILE A  67      18.615   2.480  33.363  1.00 29.65           C  
ATOM    483  CD1 ILE A  67      16.858   3.707  31.030  1.00 32.33           C  
ATOM    484  N   ARG A  68      18.520   7.250  33.896  1.00 25.29           N  
ATOM    485  CA  ARG A  68      18.671   8.605  33.375  1.00 25.92           C  
ATOM    486  C   ARG A  68      18.580   9.643  34.479  1.00 25.57           C  
ATOM    487  O   ARG A  68      17.950   9.411  35.509  1.00 22.02           O  
ATOM    488  CB  ARG A  68      17.572   8.889  32.339  1.00 27.80           C  
ATOM    489  CG  ARG A  68      18.054   9.187  30.922  1.00 34.19           C  
ATOM    490  CD  ARG A  68      19.182   8.273  30.515  1.00 32.84           C  
ATOM    491  NE  ARG A  68      19.154   7.887  29.106  1.00 32.61           N  
ATOM    492  CZ  ARG A  68      19.534   6.683  28.688  1.00 33.48           C  
ATOM    493  NH1 ARG A  68      19.950   5.789  29.575  1.00 33.74           N  
ATOM    494  NH2 ARG A  68      19.507   6.369  27.399  1.00 34.64           N  
ATOM    495  N   ASP A  69      19.224  10.785  34.261  1.00 26.47           N  
ATOM    496  CA  ASP A  69      19.165  11.890  35.213  1.00 27.31           C  
ATOM    497  C   ASP A  69      17.955  12.706  34.756  1.00 24.72           C  
ATOM    498  O   ASP A  69      17.641  12.736  33.561  1.00 26.39           O  
ATOM    499  CB  ASP A  69      20.431  12.750  35.120  1.00 28.82           C  
ATOM    500  CG  ASP A  69      20.358  13.984  36.001  1.00 28.52           C  
ATOM    501  OD1 ASP A  69      20.681  13.882  37.206  1.00 29.49           O  
ATOM    502  OD2 ASP A  69      19.961  15.052  35.488  1.00 30.21           O  
ATOM    503  N   PRO A  70      17.264  13.384  35.687  1.00 24.44           N  
ATOM    504  CA  PRO A  70      16.091  14.184  35.307  1.00 25.31           C  
ATOM    505  C   PRO A  70      16.329  15.262  34.248  1.00 26.89           C  
ATOM    506  O   PRO A  70      15.376  15.778  33.670  1.00 25.62           O  
ATOM    507  CB  PRO A  70      15.632  14.780  36.636  1.00 25.66           C  
ATOM    508  CG  PRO A  70      16.035  13.741  37.625  1.00 25.04           C  
ATOM    509  CD  PRO A  70      17.411  13.337  37.153  1.00 23.46           C  
ATOM    510  N   ALA A  71      17.590  15.612  33.998  1.00 28.07           N  
ATOM    511  CA  ALA A  71      17.888  16.630  32.989  1.00 30.03           C  
ATOM    512  C   ALA A  71      17.950  16.022  31.594  1.00 33.01           C  
ATOM    513  O   ALA A  71      18.104  16.739  30.609  1.00 33.61           O  
ATOM    514  CB  ALA A  71      19.213  17.328  33.304  1.00 28.48           C  
ATOM    515  N   GLU A  72      17.828  14.700  31.513  1.00 33.46           N  
ATOM    516  CA  GLU A  72      17.891  14.003  30.232  1.00 36.06           C  
ATOM    517  C   GLU A  72      16.522  13.609  29.699  1.00 37.47           C  
ATOM    518  O   GLU A  72      15.560  13.492  30.452  1.00 39.23           O  
ATOM    519  CB  GLU A  72      18.748  12.747  30.361  1.00 35.64           C  
ATOM    520  CG  GLU A  72      20.169  13.000  30.801  1.00 36.71           C  
ATOM    521  CD  GLU A  72      20.961  11.719  30.926  1.00 37.60           C  
ATOM    522  OE1 GLU A  72      20.714  10.951  31.877  1.00 38.50           O  
ATOM    523  OE2 GLU A  72      21.829  11.473  30.063  1.00 39.43           O  
ATOM    524  N   SER A  73      16.444  13.409  28.389  1.00 37.77           N  
ATOM    525  CA  SER A  73      15.198  13.006  27.759  1.00 40.34           C  
ATOM    526  C   SER A  73      15.306  11.524  27.387  1.00 38.41           C  
ATOM    527  O   SER A  73      16.405  10.977  27.339  1.00 38.92           O  
ATOM    528  CB  SER A  73      14.944  13.850  26.510  1.00 42.45           C  
ATOM    529  OG  SER A  73      13.666  13.565  25.971  1.00 48.59           O  
ATOM    530  N   TYR A  74      14.169  10.885  27.125  1.00 37.97           N  
ATOM    531  CA  TYR A  74      14.145   9.469  26.768  1.00 38.50           C  
ATOM    532  C   TYR A  74      12.983   9.219  25.811  1.00 38.88           C  
ATOM    533  O   TYR A  74      11.821   9.341  26.195  1.00 42.36           O  
ATOM    534  CB  TYR A  74      13.962   8.624  28.034  1.00 36.07           C  
ATOM    535  CG  TYR A  74      14.298   7.157  27.880  1.00 34.27           C  
ATOM    536  CD1 TYR A  74      15.605   6.742  27.625  1.00 34.97           C  
ATOM    537  CD2 TYR A  74      13.313   6.176  28.029  1.00 35.10           C  
ATOM    538  CE1 TYR A  74      15.928   5.383  27.525  1.00 35.27           C  
ATOM    539  CE2 TYR A  74      13.624   4.819  27.932  1.00 34.57           C  
ATOM    540  CZ  TYR A  74      14.931   4.432  27.681  1.00 34.17           C  
ATOM    541  OH  TYR A  74      15.242   3.092  27.594  1.00 34.83           O  
ATOM    542  N   SER A  75      13.292   8.857  24.573  1.00 39.26           N  
ATOM    543  CA  SER A  75      12.254   8.619  23.575  1.00 37.57           C  
ATOM    544  C   SER A  75      11.756   7.183  23.535  1.00 37.51           C  
ATOM    545  O   SER A  75      12.399   6.274  24.063  1.00 36.05           O  
ATOM    546  CB  SER A  75      12.771   8.992  22.183  1.00 38.10           C  
ATOM    547  OG  SER A  75      13.833   8.134  21.797  1.00 39.75           O  
ATOM    548  N   ALA A  76      10.601   6.992  22.903  1.00 35.65           N  
ATOM    549  CA  ALA A  76      10.019   5.668  22.750  1.00 34.85           C  
ATOM    550  C   ALA A  76      10.961   4.860  21.855  1.00 35.92           C  
ATOM    551  O   ALA A  76      11.003   3.627  21.923  1.00 34.38           O  
ATOM    552  CB  ALA A  76       8.635   5.769  22.110  1.00 33.64           C  
ATOM    553  N   ALA A  77      11.716   5.568  21.015  1.00 33.13           N  
ATOM    554  CA  ALA A  77      12.671   4.919  20.122  1.00 33.97           C  
ATOM    555  C   ALA A  77      13.831   4.374  20.950  1.00 33.53           C  
ATOM    556  O   ALA A  77      14.343   3.286  20.679  1.00 31.81           O  
ATOM    557  CB  ALA A  77      13.184   5.911  19.085  1.00 34.34           C  
ATOM    558  N   GLU A  78      14.243   5.132  21.965  1.00 33.54           N  
ATOM    559  CA  GLU A  78      15.335   4.702  22.832  1.00 33.33           C  
ATOM    560  C   GLU A  78      14.872   3.533  23.693  1.00 31.45           C  
ATOM    561  O   GLU A  78      15.628   2.596  23.925  1.00 29.54           O  
ATOM    562  CB  GLU A  78      15.797   5.845  23.740  1.00 37.66           C  
ATOM    563  CG  GLU A  78      16.341   7.052  22.999  1.00 43.32           C  
ATOM    564  CD  GLU A  78      16.808   8.145  23.941  1.00 45.68           C  
ATOM    565  OE1 GLU A  78      17.812   7.929  24.656  1.00 46.46           O  
ATOM    566  OE2 GLU A  78      16.164   9.214  23.968  1.00 48.72           O  
ATOM    567  N   PHE A  79      13.636   3.602  24.182  1.00 30.06           N  
ATOM    568  CA  PHE A  79      13.098   2.516  24.995  1.00 29.62           C  
ATOM    569  C   PHE A  79      13.107   1.250  24.152  1.00 29.96           C  
ATOM    570  O   PHE A  79      13.528   0.187  24.602  1.00 27.84           O  
ATOM    571  CB  PHE A  79      11.656   2.794  25.414  1.00 28.00           C  
ATOM    572  CG  PHE A  79      10.932   1.566  25.903  1.00 27.15           C  
ATOM    573  CD1 PHE A  79      11.179   1.057  27.174  1.00 26.53           C  
ATOM    574  CD2 PHE A  79      10.071   0.872  25.058  1.00 26.74           C  
ATOM    575  CE1 PHE A  79      10.581  -0.129  27.602  1.00 26.38           C  
ATOM    576  CE2 PHE A  79       9.467  -0.314  25.474  1.00 26.46           C  
ATOM    577  CZ  PHE A  79       9.726  -0.818  26.751  1.00 25.48           C  
ATOM    578  N   ARG A  80      12.607   1.386  22.930  1.00 29.37           N  
ATOM    579  CA  ARG A  80      12.535   0.287  21.976  1.00 32.20           C  
ATOM    580  C   ARG A  80      13.882  -0.421  21.862  1.00 31.56           C  
ATOM    581  O   ARG A  80      13.969  -1.647  21.986  1.00 31.35           O  
ATOM    582  CB  ARG A  80      12.098   0.853  20.623  1.00 36.49           C  
ATOM    583  CG  ARG A  80      12.422   0.010  19.408  1.00 42.65           C  
ATOM    584  CD  ARG A  80      11.344  -0.994  19.092  1.00 47.73           C  
ATOM    585  NE  ARG A  80      11.483  -1.472  17.720  1.00 52.18           N  
ATOM    586  CZ  ARG A  80      10.855  -2.535  17.227  1.00 55.06           C  
ATOM    587  NH1 ARG A  80      10.038  -3.246  17.991  1.00 55.66           N  
ATOM    588  NH2 ARG A  80      11.048  -2.886  15.963  1.00 56.02           N  
ATOM    589  N   ALA A  81      14.934   0.357  21.628  1.00 30.15           N  
ATOM    590  CA  ALA A  81      16.272  -0.197  21.494  1.00 32.14           C  
ATOM    591  C   ALA A  81      16.740  -0.832  22.797  1.00 30.44           C  
ATOM    592  O   ALA A  81      17.247  -1.953  22.800  1.00 32.05           O  
ATOM    593  CB  ALA A  81      17.252   0.894  21.060  1.00 31.66           C  
ATOM    594  N   ASP A  82      16.568  -0.111  23.901  1.00 30.96           N  
ATOM    595  CA  ASP A  82      16.983  -0.600  25.211  1.00 31.11           C  
ATOM    596  C   ASP A  82      16.237  -1.863  25.614  1.00 29.41           C  
ATOM    597  O   ASP A  82      16.820  -2.783  26.193  1.00 29.53           O  
ATOM    598  CB  ASP A  82      16.760   0.476  26.279  1.00 32.85           C  
ATOM    599  CG  ASP A  82      17.799   1.581  26.224  1.00 37.91           C  
ATOM    600  OD1 ASP A  82      18.699   1.507  25.360  1.00 38.10           O  
ATOM    601  OD2 ASP A  82      17.720   2.521  27.047  1.00 37.94           O  
ATOM    602  N   ALA A  83      14.944  -1.902  25.318  1.00 27.54           N  
ATOM    603  CA  ALA A  83      14.130  -3.060  25.666  1.00 28.03           C  
ATOM    604  C   ALA A  83      14.531  -4.290  24.848  1.00 27.34           C  
ATOM    605  O   ALA A  83      14.653  -5.389  25.390  1.00 27.92           O  
ATOM    606  CB  ALA A  83      12.643  -2.735  25.461  1.00 27.34           C  
ATOM    607  N   LEU A  84      14.733  -4.111  23.548  1.00 29.09           N  
ATOM    608  CA  LEU A  84      15.117  -5.235  22.700  1.00 29.99           C  
ATOM    609  C   LEU A  84      16.442  -5.832  23.152  1.00 30.23           C  
ATOM    610  O   LEU A  84      16.617  -7.052  23.145  1.00 30.39           O  
ATOM    611  CB  LEU A  84      15.213  -4.799  21.240  1.00 29.41           C  
ATOM    612  CG  LEU A  84      13.889  -4.456  20.560  1.00 31.62           C  
ATOM    613  CD1 LEU A  84      14.160  -3.949  19.152  1.00 33.76           C  
ATOM    614  CD2 LEU A  84      12.993  -5.687  20.523  1.00 34.31           C  
ATOM    615  N   ALA A  85      17.370  -4.967  23.551  1.00 30.45           N  
ATOM    616  CA  ALA A  85      18.676  -5.411  24.010  1.00 31.21           C  
ATOM    617  C   ALA A  85      18.537  -6.170  25.326  1.00 29.71           C  
ATOM    618  O   ALA A  85      19.182  -7.198  25.524  1.00 29.56           O  
ATOM    619  CB  ALA A  85      19.609  -4.213  24.187  1.00 30.84           C  
ATOM    620  N   ALA A  86      17.691  -5.662  26.218  1.00 29.18           N  
ATOM    621  CA  ALA A  86      17.468  -6.296  27.512  1.00 29.26           C  
ATOM    622  C   ALA A  86      16.788  -7.646  27.327  1.00 28.70           C  
ATOM    623  O   ALA A  86      17.107  -8.612  28.020  1.00 28.72           O  
ATOM    624  CB  ALA A  86      16.612  -5.399  28.405  1.00 28.75           C  
ATOM    625  N   MET A  87      15.845  -7.707  26.397  1.00 29.11           N  
ATOM    626  CA  MET A  87      15.133  -8.950  26.126  1.00 30.90           C  
ATOM    627  C   MET A  87      16.066 -10.012  25.534  1.00 31.51           C  
ATOM    628  O   MET A  87      15.976 -11.190  25.885  1.00 28.90           O  
ATOM    629  CB  MET A  87      13.960  -8.691  25.180  1.00 29.17           C  
ATOM    630  CG  MET A  87      12.825  -7.900  25.827  1.00 31.11           C  
ATOM    631  SD  MET A  87      11.492  -7.571  24.672  1.00 31.13           S  
ATOM    632  CE  MET A  87      12.056  -6.079  23.933  1.00 38.75           C  
ATOM    633  N   ALA A  88      16.966  -9.592  24.646  1.00 31.19           N  
ATOM    634  CA  ALA A  88      17.908 -10.522  24.023  1.00 31.71           C  
ATOM    635  C   ALA A  88      18.890 -11.074  25.057  1.00 33.89           C  
ATOM    636  O   ALA A  88      19.197 -12.272  25.070  1.00 32.24           O  
ATOM    637  CB  ALA A  88      18.665  -9.823  22.897  1.00 31.99           C  
ATOM    638  N   LYS A  89      19.375 -10.194  25.924  1.00 33.56           N  
ATOM    639  CA  LYS A  89      20.315 -10.581  26.966  1.00 36.11           C  
ATOM    640  C   LYS A  89      19.668 -11.585  27.918  1.00 35.84           C  
ATOM    641  O   LYS A  89      20.294 -12.570  28.313  1.00 36.37           O  
ATOM    642  CB  LYS A  89      20.772  -9.341  27.734  1.00 38.95           C  
ATOM    643  CG  LYS A  89      21.968  -9.557  28.642  1.00 45.17           C  
ATOM    644  CD  LYS A  89      22.507  -8.220  29.144  1.00 49.26           C  
ATOM    645  CE  LYS A  89      23.750  -8.398  30.002  1.00 51.84           C  
ATOM    646  NZ  LYS A  89      24.302  -7.088  30.452  1.00 54.01           N  
ATOM    647  N   ALA A  90      18.413 -11.332  28.277  1.00 34.58           N  
ATOM    648  CA  ALA A  90      17.677 -12.213  29.179  1.00 32.28           C  
ATOM    649  C   ALA A  90      17.419 -13.559  28.507  1.00 30.71           C  
ATOM    650  O   ALA A  90      17.604 -14.617  29.116  1.00 30.91           O  
ATOM    651  CB  ALA A  90      16.360 -11.565  29.575  1.00 31.05           C  
ATOM    652  N   THR A  91      16.989 -13.507  27.253  1.00 29.52           N  
ATOM    653  CA  THR A  91      16.709 -14.711  26.481  1.00 30.91           C  
ATOM    654  C   THR A  91      17.956 -15.581  26.338  1.00 30.93           C  
ATOM    655  O   THR A  91      17.885 -16.803  26.462  1.00 31.21           O  
ATOM    656  CB  THR A  91      16.169 -14.350  25.081  1.00 31.74           C  
ATOM    657  OG1 THR A  91      14.903 -13.689  25.220  1.00 30.68           O  
ATOM    658  CG2 THR A  91      15.990 -15.607  24.224  1.00 30.77           C  
ATOM    659  N   ALA A  92      19.098 -14.948  26.082  1.00 31.48           N  
ATOM    660  CA  ALA A  92      20.352 -15.676  25.928  1.00 32.57           C  
ATOM    661  C   ALA A  92      20.681 -16.458  27.195  1.00 32.75           C  
ATOM    662  O   ALA A  92      21.392 -17.466  27.153  1.00 31.93           O  
ATOM    663  CB  ALA A  92      21.479 -14.709  25.608  1.00 33.93           C  
ATOM    664  N   ARG A  93      20.158 -15.992  28.323  1.00 32.93           N  
ATOM    665  CA  ARG A  93      20.401 -16.646  29.600  1.00 34.19           C  
ATOM    666  C   ARG A  93      19.247 -17.557  30.018  1.00 32.08           C  
ATOM    667  O   ARG A  93      19.196 -18.018  31.153  1.00 31.92           O  
ATOM    668  CB  ARG A  93      20.658 -15.594  30.682  1.00 37.28           C  
ATOM    669  CG  ARG A  93      21.763 -14.612  30.311  1.00 43.56           C  
ATOM    670  CD  ARG A  93      22.798 -14.483  31.414  1.00 47.63           C  
ATOM    671  NE  ARG A  93      22.259 -13.874  32.625  1.00 51.78           N  
ATOM    672  CZ  ARG A  93      22.932 -13.768  33.767  1.00 54.15           C  
ATOM    673  NH1 ARG A  93      24.171 -14.235  33.856  1.00 55.05           N  
ATOM    674  NH2 ARG A  93      22.373 -13.185  34.819  1.00 56.96           N  
ATOM    675  N   GLY A  94      18.325 -17.811  29.098  1.00 31.85           N  
ATOM    676  CA  GLY A  94      17.197 -18.679  29.397  1.00 30.03           C  
ATOM    677  C   GLY A  94      16.144 -18.074  30.310  1.00 29.67           C  
ATOM    678  O   GLY A  94      15.263 -18.775  30.811  1.00 28.30           O  
ATOM    679  N   ARG A  95      16.236 -16.773  30.544  1.00 28.46           N  
ATOM    680  CA  ARG A  95      15.266 -16.098  31.394  1.00 30.50           C  
ATOM    681  C   ARG A  95      14.144 -15.569  30.513  1.00 28.30           C  
ATOM    682  O   ARG A  95      14.371 -15.200  29.363  1.00 28.57           O  
ATOM    683  CB  ARG A  95      15.926 -14.936  32.140  1.00 32.93           C  
ATOM    684  CG  ARG A  95      16.919 -15.361  33.207  1.00 38.36           C  
ATOM    685  CD  ARG A  95      17.707 -14.171  33.747  1.00 40.27           C  
ATOM    686  NE  ARG A  95      18.656 -14.589  34.776  1.00 46.57           N  
ATOM    687  CZ  ARG A  95      19.606 -13.812  35.288  1.00 49.35           C  
ATOM    688  NH1 ARG A  95      19.749 -12.561  34.867  1.00 51.04           N  
ATOM    689  NH2 ARG A  95      20.412 -14.286  36.230  1.00 51.00           N  
ATOM    690  N   ILE A  96      12.933 -15.546  31.052  1.00 27.42           N  
ATOM    691  CA  ILE A  96      11.792 -15.044  30.306  1.00 28.45           C  
ATOM    692  C   ILE A  96      11.624 -13.547  30.566  1.00 27.54           C  
ATOM    693  O   ILE A  96      11.415 -13.127  31.707  1.00 28.24           O  
ATOM    694  CB  ILE A  96      10.498 -15.753  30.720  1.00 29.62           C  
ATOM    695  CG1 ILE A  96      10.619 -17.256  30.454  1.00 31.31           C  
ATOM    696  CG2 ILE A  96       9.325 -15.167  29.947  1.00 29.72           C  
ATOM    697  CD1 ILE A  96       9.459 -18.062  31.006  1.00 34.10           C  
ATOM    698  N   PRO A  97      11.732 -12.724  29.513  1.00 27.00           N  
ATOM    699  CA  PRO A  97      11.576 -11.274  29.682  1.00 27.81           C  
ATOM    700  C   PRO A  97      10.164 -11.001  30.173  1.00 27.59           C  
ATOM    701  O   PRO A  97       9.194 -11.472  29.573  1.00 28.00           O  
ATOM    702  CB  PRO A  97      11.788 -10.728  28.266  1.00 27.13           C  
ATOM    703  CG  PRO A  97      12.678 -11.754  27.633  1.00 28.06           C  
ATOM    704  CD  PRO A  97      12.085 -13.053  28.123  1.00 27.20           C  
ATOM    705  N   LEU A  98      10.052 -10.255  31.268  1.00 26.40           N  
ATOM    706  CA  LEU A  98       8.757  -9.903  31.833  1.00 26.86           C  
ATOM    707  C   LEU A  98       8.693  -8.374  31.866  1.00 27.19           C  
ATOM    708  O   LEU A  98       9.233  -7.743  32.776  1.00 28.35           O  
ATOM    709  CB  LEU A  98       8.626 -10.467  33.257  1.00 28.52           C  
ATOM    710  CG  LEU A  98       7.213 -10.575  33.845  1.00 29.18           C  
ATOM    711  CD1 LEU A  98       7.307 -11.088  35.276  1.00 31.20           C  
ATOM    712  CD2 LEU A  98       6.513  -9.233  33.812  1.00 30.67           C  
ATOM    713  N   LEU A  99       8.043  -7.792  30.863  1.00 25.47           N  
ATOM    714  CA  LEU A  99       7.923  -6.340  30.756  1.00 27.49           C  
ATOM    715  C   LEU A  99       6.715  -5.820  31.523  1.00 27.23           C  
ATOM    716  O   LEU A  99       5.564  -6.062  31.147  1.00 30.62           O  
ATOM    717  CB  LEU A  99       7.852  -5.935  29.277  1.00 26.09           C  
ATOM    718  CG  LEU A  99       9.163  -6.095  28.492  1.00 28.88           C  
ATOM    719  CD1 LEU A  99       9.482  -7.573  28.256  1.00 28.83           C  
ATOM    720  CD2 LEU A  99       9.036  -5.367  27.161  1.00 30.31           C  
ATOM    721  N   VAL A 100       6.986  -5.094  32.602  1.00 26.04           N  
ATOM    722  CA  VAL A 100       5.932  -4.571  33.458  1.00 25.18           C  
ATOM    723  C   VAL A 100       5.897  -3.041  33.507  1.00 26.02           C  
ATOM    724  O   VAL A 100       6.920  -2.377  33.692  1.00 23.37           O  
ATOM    725  CB  VAL A 100       6.089  -5.182  34.883  1.00 26.27           C  
ATOM    726  CG1 VAL A 100       7.490  -4.915  35.401  1.00 25.39           C  
ATOM    727  CG2 VAL A 100       5.019  -4.643  35.838  1.00 24.01           C  
ATOM    728  N   GLY A 101       4.711  -2.476  33.315  1.00 25.60           N  
ATOM    729  CA  GLY A 101       4.596  -1.031  33.340  1.00 26.91           C  
ATOM    730  C   GLY A 101       3.282  -0.506  32.799  1.00 27.11           C  
ATOM    731  O   GLY A 101       2.404  -1.276  32.413  1.00 28.03           O  
ATOM    732  N   GLY A 102       3.157   0.815  32.768  1.00 29.72           N  
ATOM    733  CA  GLY A 102       1.939   1.434  32.284  1.00 30.33           C  
ATOM    734  C   GLY A 102       2.099   2.423  31.145  1.00 30.77           C  
ATOM    735  O   GLY A 102       1.127   3.074  30.772  1.00 31.35           O  
ATOM    736  N   THR A 103       3.303   2.563  30.593  1.00 30.90           N  
ATOM    737  CA  THR A 103       3.501   3.488  29.477  1.00 29.55           C  
ATOM    738  C   THR A 103       3.175   2.718  28.195  1.00 30.96           C  
ATOM    739  O   THR A 103       4.043   2.082  27.595  1.00 28.45           O  
ATOM    740  CB  THR A 103       4.955   4.028  29.438  1.00 30.45           C  
ATOM    741  OG1 THR A 103       5.247   4.694  30.677  1.00 28.52           O  
ATOM    742  CG2 THR A 103       5.125   5.020  28.294  1.00 26.51           C  
ATOM    743  N   MET A 104       1.907   2.781  27.790  1.00 30.74           N  
ATOM    744  CA  MET A 104       1.424   2.059  26.619  1.00 33.43           C  
ATOM    745  C   MET A 104       2.114   2.410  25.308  1.00 32.59           C  
ATOM    746  O   MET A 104       2.249   1.557  24.430  1.00 32.43           O  
ATOM    747  CB  MET A 104      -0.089   2.253  26.474  1.00 34.92           C  
ATOM    748  CG  MET A 104      -0.876   1.933  27.733  1.00 40.24           C  
ATOM    749  SD  MET A 104      -0.460   0.331  28.454  1.00 41.54           S  
ATOM    750  CE  MET A 104      -0.802   0.651  30.182  1.00 43.88           C  
ATOM    751  N   LEU A 105       2.543   3.660  25.174  1.00 32.61           N  
ATOM    752  CA  LEU A 105       3.229   4.107  23.969  1.00 33.31           C  
ATOM    753  C   LEU A 105       4.510   3.288  23.785  1.00 33.21           C  
ATOM    754  O   LEU A 105       4.925   3.002  22.657  1.00 31.94           O  
ATOM    755  CB  LEU A 105       3.554   5.597  24.083  1.00 36.63           C  
ATOM    756  CG  LEU A 105       3.538   6.402  22.781  1.00 41.09           C  
ATOM    757  CD1 LEU A 105       3.212   7.861  23.090  1.00 41.60           C  
ATOM    758  CD2 LEU A 105       4.873   6.273  22.068  1.00 42.63           C  
ATOM    759  N   TYR A 106       5.131   2.916  24.901  1.00 30.40           N  
ATOM    760  CA  TYR A 106       6.344   2.110  24.864  1.00 31.36           C  
ATOM    761  C   TYR A 106       6.013   0.704  24.368  1.00 30.76           C  
ATOM    762  O   TYR A 106       6.693   0.173  23.489  1.00 33.37           O  
ATOM    763  CB  TYR A 106       6.984   2.035  26.255  1.00 29.85           C  
ATOM    764  CG  TYR A 106       7.795   3.254  26.660  1.00 32.51           C  
ATOM    765  CD1 TYR A 106       7.843   4.396  25.858  1.00 33.02           C  
ATOM    766  CD2 TYR A 106       8.518   3.261  27.856  1.00 33.49           C  
ATOM    767  CE1 TYR A 106       8.592   5.515  26.236  1.00 34.32           C  
ATOM    768  CE2 TYR A 106       9.268   4.368  28.241  1.00 32.47           C  
ATOM    769  CZ  TYR A 106       9.301   5.491  27.429  1.00 34.75           C  
ATOM    770  OH  TYR A 106      10.044   6.584  27.816  1.00 33.73           O  
ATOM    771  N   TYR A 107       4.974   0.095  24.930  1.00 31.19           N  
ATOM    772  CA  TYR A 107       4.588  -1.247  24.501  1.00 32.00           C  
ATOM    773  C   TYR A 107       4.285  -1.224  23.009  1.00 32.83           C  
ATOM    774  O   TYR A 107       4.635  -2.151  22.273  1.00 32.15           O  
ATOM    775  CB  TYR A 107       3.350  -1.736  25.256  1.00 31.27           C  
ATOM    776  CG  TYR A 107       3.616  -2.204  26.670  1.00 32.09           C  
ATOM    777  CD1 TYR A 107       3.185  -1.454  27.763  1.00 29.28           C  
ATOM    778  CD2 TYR A 107       4.283  -3.405  26.915  1.00 30.58           C  
ATOM    779  CE1 TYR A 107       3.406  -1.887  29.066  1.00 31.34           C  
ATOM    780  CE2 TYR A 107       4.515  -3.850  28.218  1.00 31.31           C  
ATOM    781  CZ  TYR A 107       4.071  -3.082  29.287  1.00 31.34           C  
ATOM    782  OH  TYR A 107       4.291  -3.503  30.574  1.00 34.12           O  
ATOM    783  N   LYS A 108       3.633  -0.154  22.574  1.00 32.67           N  
ATOM    784  CA  LYS A 108       3.267   0.023  21.173  1.00 36.05           C  
ATOM    785  C   LYS A 108       4.513   0.025  20.294  1.00 36.05           C  
ATOM    786  O   LYS A 108       4.591  -0.707  19.301  1.00 36.58           O  
ATOM    787  CB  LYS A 108       2.518   1.347  20.998  1.00 39.50           C  
ATOM    788  CG  LYS A 108       1.476   1.340  19.887  1.00 45.01           C  
ATOM    789  CD  LYS A 108       0.236   0.570  20.327  1.00 48.42           C  
ATOM    790  CE  LYS A 108      -0.904   0.710  19.327  1.00 50.36           C  
ATOM    791  NZ  LYS A 108      -2.138   0.025  19.814  1.00 51.99           N  
ATOM    792  N   ALA A 109       5.485   0.854  20.659  1.00 35.71           N  
ATOM    793  CA  ALA A 109       6.727   0.950  19.900  1.00 36.05           C  
ATOM    794  C   ALA A 109       7.396  -0.417  19.757  1.00 37.10           C  
ATOM    795  O   ALA A 109       7.975  -0.728  18.714  1.00 35.98           O  
ATOM    796  CB  ALA A 109       7.678   1.931  20.572  1.00 35.35           C  
ATOM    797  N   LEU A 110       7.311  -1.228  20.808  1.00 36.72           N  
ATOM    798  CA  LEU A 110       7.902  -2.563  20.795  1.00 39.12           C  
ATOM    799  C   LEU A 110       7.146  -3.516  19.874  1.00 39.86           C  
ATOM    800  O   LEU A 110       7.756  -4.269  19.117  1.00 40.37           O  
ATOM    801  CB  LEU A 110       7.929  -3.152  22.209  1.00 37.03           C  
ATOM    802  CG  LEU A 110       9.274  -3.229  22.935  1.00 40.37           C  
ATOM    803  CD1 LEU A 110       9.096  -4.025  24.221  1.00 35.57           C  
ATOM    804  CD2 LEU A 110      10.314  -3.905  22.051  1.00 38.05           C  
ATOM    805  N   LEU A 111       5.819  -3.489  19.953  1.00 43.43           N  
ATOM    806  CA  LEU A 111       4.981  -4.351  19.124  1.00 47.65           C  
ATOM    807  C   LEU A 111       5.016  -3.928  17.664  1.00 49.97           C  
ATOM    808  O   LEU A 111       4.990  -4.764  16.762  1.00 50.87           O  
ATOM    809  CB  LEU A 111       3.533  -4.322  19.621  1.00 47.80           C  
ATOM    810  CG  LEU A 111       3.212  -5.101  20.899  1.00 48.61           C  
ATOM    811  CD1 LEU A 111       1.785  -4.802  21.335  1.00 49.55           C  
ATOM    812  CD2 LEU A 111       3.397  -6.593  20.647  1.00 48.38           C  
ATOM    813  N   GLU A 112       5.073  -2.621  17.442  1.00 52.91           N  
ATOM    814  CA  GLU A 112       5.105  -2.069  16.097  1.00 55.36           C  
ATOM    815  C   GLU A 112       6.452  -1.408  15.813  1.00 56.78           C  
ATOM    816  O   GLU A 112       7.482  -2.081  15.773  1.00 57.30           O  
ATOM    817  CB  GLU A 112       3.962  -1.067  15.934  1.00 56.75           C  
ATOM    818  CG  GLU A 112       2.585  -1.705  16.063  1.00 59.19           C  
ATOM    819  CD  GLU A 112       1.460  -0.688  16.126  1.00 61.37           C  
ATOM    820  OE1 GLU A 112       1.432   0.231  15.278  1.00 63.27           O  
ATOM    821  OE2 GLU A 112       0.596  -0.814  17.019  1.00 62.52           O  
ATOM    822  N   GLY A 113       6.448  -0.091  15.624  1.00 58.25           N  
ATOM    823  CA  GLY A 113       7.687   0.613  15.342  1.00 58.78           C  
ATOM    824  C   GLY A 113       7.916   1.810  16.242  1.00 59.32           C  
ATOM    825  O   GLY A 113       8.981   2.429  16.205  1.00 60.52           O  
ATOM    826  N   LEU A 199       8.531  -7.919  16.486  1.00 41.76           N  
ATOM    827  CA  LEU A 199       8.962  -8.528  17.740  1.00 41.96           C  
ATOM    828  C   LEU A 199       9.181 -10.031  17.588  1.00 40.69           C  
ATOM    829  O   LEU A 199       8.226 -10.799  17.478  1.00 40.44           O  
ATOM    830  CB  LEU A 199       7.919  -8.283  18.832  1.00 42.60           C  
ATOM    831  CG  LEU A 199       8.338  -7.410  20.015  1.00 45.97           C  
ATOM    832  CD1 LEU A 199       7.321  -7.582  21.138  1.00 43.98           C  
ATOM    833  CD2 LEU A 199       9.723  -7.812  20.501  1.00 43.26           C  
ATOM    834  N   PRO A 200      10.450 -10.469  17.590  1.00 40.21           N  
ATOM    835  CA  PRO A 200      10.791 -11.888  17.449  1.00 38.60           C  
ATOM    836  C   PRO A 200      10.596 -12.679  18.742  1.00 35.88           C  
ATOM    837  O   PRO A 200      11.515 -13.343  19.220  1.00 34.61           O  
ATOM    838  CB  PRO A 200      12.250 -11.839  17.014  1.00 38.57           C  
ATOM    839  CG  PRO A 200      12.766 -10.682  17.815  1.00 40.09           C  
ATOM    840  CD  PRO A 200      11.669  -9.643  17.647  1.00 39.87           C  
ATOM    841  N   TYR A 201       9.393 -12.595  19.303  1.00 34.79           N  
ATOM    842  CA  TYR A 201       9.064 -13.304  20.536  1.00 32.58           C  
ATOM    843  C   TYR A 201       7.620 -13.768  20.535  1.00 32.28           C  
ATOM    844  O   TYR A 201       6.768 -13.153  19.899  1.00 32.35           O  
ATOM    845  CB  TYR A 201       9.245 -12.400  21.767  1.00 32.10           C  
ATOM    846  CG  TYR A 201      10.660 -11.969  22.046  1.00 29.97           C  
ATOM    847  CD1 TYR A 201      11.196 -10.838  21.432  1.00 30.12           C  
ATOM    848  CD2 TYR A 201      11.481 -12.714  22.892  1.00 28.74           C  
ATOM    849  CE1 TYR A 201      12.514 -10.462  21.646  1.00 30.55           C  
ATOM    850  CE2 TYR A 201      12.807 -12.348  23.112  1.00 30.60           C  
ATOM    851  CZ  TYR A 201      13.314 -11.218  22.481  1.00 28.01           C  
ATOM    852  OH  TYR A 201      14.625 -10.852  22.667  1.00 27.99           O  
ATOM    853  N   THR A 202       7.354 -14.866  21.236  1.00 30.82           N  
ATOM    854  CA  THR A 202       5.989 -15.348  21.383  1.00 31.04           C  
ATOM    855  C   THR A 202       5.585 -14.623  22.665  1.00 30.42           C  
ATOM    856  O   THR A 202       6.127 -14.900  23.732  1.00 29.91           O  
ATOM    857  CB  THR A 202       5.939 -16.869  21.615  1.00 32.00           C  
ATOM    858  OG1 THR A 202       6.475 -17.544  20.471  1.00 33.29           O  
ATOM    859  CG2 THR A 202       4.504 -17.325  21.844  1.00 30.82           C  
ATOM    860  N   VAL A 203       4.649 -13.691  22.567  1.00 30.26           N  
ATOM    861  CA  VAL A 203       4.279 -12.915  23.740  1.00 31.91           C  
ATOM    862  C   VAL A 203       2.913 -13.166  24.363  1.00 31.24           C  
ATOM    863  O   VAL A 203       1.895 -13.231  23.673  1.00 32.59           O  
ATOM    864  CB  VAL A 203       4.390 -11.403  23.436  1.00 31.51           C  
ATOM    865  CG1 VAL A 203       4.280 -10.595  24.730  1.00 32.45           C  
ATOM    866  CG2 VAL A 203       5.706 -11.114  22.725  1.00 31.47           C  
ATOM    867  N   ALA A 204       2.913 -13.309  25.684  1.00 31.04           N  
ATOM    868  CA  ALA A 204       1.689 -13.490  26.448  1.00 30.85           C  
ATOM    869  C   ALA A 204       1.461 -12.100  27.033  1.00 31.94           C  
ATOM    870  O   ALA A 204       2.317 -11.579  27.749  1.00 31.11           O  
ATOM    871  CB  ALA A 204       1.898 -14.509  27.565  1.00 31.66           C  
ATOM    872  N   GLN A 205       0.328 -11.490  26.712  1.00 30.86           N  
ATOM    873  CA  GLN A 205       0.038 -10.151  27.208  1.00 32.72           C  
ATOM    874  C   GLN A 205      -1.029 -10.153  28.293  1.00 32.08           C  
ATOM    875  O   GLN A 205      -2.178 -10.534  28.055  1.00 32.39           O  
ATOM    876  CB  GLN A 205      -0.386  -9.251  26.045  1.00 34.07           C  
ATOM    877  CG  GLN A 205       0.663  -9.179  24.938  1.00 36.08           C  
ATOM    878  CD  GLN A 205       0.328  -8.151  23.877  1.00 38.10           C  
ATOM    879  OE1 GLN A 205       0.127  -6.975  24.179  1.00 39.34           O  
ATOM    880  NE2 GLN A 205       0.275  -8.588  22.625  1.00 37.82           N  
ATOM    881  N   LEU A 206      -0.635  -9.726  29.489  1.00 30.05           N  
ATOM    882  CA  LEU A 206      -1.543  -9.674  30.629  1.00 31.64           C  
ATOM    883  C   LEU A 206      -1.806  -8.230  31.044  1.00 30.86           C  
ATOM    884  O   LEU A 206      -0.943  -7.362  30.902  1.00 28.98           O  
ATOM    885  CB  LEU A 206      -0.947 -10.437  31.821  1.00 32.98           C  
ATOM    886  CG  LEU A 206      -0.634 -11.935  31.708  1.00 37.95           C  
ATOM    887  CD1 LEU A 206      -1.908 -12.706  31.397  1.00 38.92           C  
ATOM    888  CD2 LEU A 206       0.406 -12.172  30.631  1.00 41.21           C  
ATOM    889  N   ALA A 207      -3.008  -7.980  31.550  1.00 30.51           N  
ATOM    890  CA  ALA A 207      -3.389  -6.655  32.020  1.00 31.21           C  
ATOM    891  C   ALA A 207      -4.082  -6.837  33.362  1.00 32.89           C  
ATOM    892  O   ALA A 207      -4.856  -7.780  33.550  1.00 32.67           O  
ATOM    893  CB  ALA A 207      -4.331  -5.979  31.024  1.00 31.88           C  
ATOM    894  N   ILE A 208      -3.800  -5.941  34.299  1.00 31.96           N  
ATOM    895  CA  ILE A 208      -4.400  -6.031  35.619  1.00 32.93           C  
ATOM    896  C   ILE A 208      -5.003  -4.696  36.040  1.00 33.05           C  
ATOM    897  O   ILE A 208      -4.410  -3.638  35.826  1.00 32.93           O  
ATOM    898  CB  ILE A 208      -3.355  -6.478  36.661  1.00 33.38           C  
ATOM    899  CG1 ILE A 208      -4.034  -6.754  38.003  1.00 33.70           C  
ATOM    900  CG2 ILE A 208      -2.276  -5.406  36.811  1.00 33.73           C  
ATOM    901  CD1 ILE A 208      -3.128  -7.436  39.010  1.00 34.11           C  
ATOM    902  N   ALA A 209      -6.193  -4.761  36.627  1.00 32.50           N  
ATOM    903  CA  ALA A 209      -6.905  -3.575  37.091  1.00 32.70           C  
ATOM    904  C   ALA A 209      -8.123  -4.018  37.891  1.00 34.14           C  
ATOM    905  O   ALA A 209      -8.609  -5.136  37.723  1.00 31.39           O  
ATOM    906  CB  ALA A 209      -7.346  -2.726  35.901  1.00 33.59           C  
ATOM    907  N   PRO A 210      -8.627  -3.152  38.787  1.00 35.34           N  
ATOM    908  CA  PRO A 210      -9.804  -3.511  39.587  1.00 38.23           C  
ATOM    909  C   PRO A 210     -11.028  -3.554  38.678  1.00 39.56           C  
ATOM    910  O   PRO A 210     -11.113  -2.791  37.716  1.00 38.56           O  
ATOM    911  CB  PRO A 210      -9.911  -2.365  40.597  1.00 38.23           C  
ATOM    912  CG  PRO A 210      -8.540  -1.739  40.602  1.00 40.55           C  
ATOM    913  CD  PRO A 210      -8.120  -1.824  39.164  1.00 36.40           C  
ATOM    914  N   GLU A 211     -11.971  -4.437  38.986  1.00 41.78           N  
ATOM    915  CA  GLU A 211     -13.190  -4.558  38.195  1.00 45.03           C  
ATOM    916  C   GLU A 211     -13.876  -3.194  38.096  1.00 45.95           C  
ATOM    917  O   GLU A 211     -14.284  -2.767  37.014  1.00 46.37           O  
ATOM    918  CB  GLU A 211     -14.133  -5.572  38.848  1.00 48.55           C  
ATOM    919  CG  GLU A 211     -13.522  -6.961  39.018  1.00 52.71           C  
ATOM    920  CD  GLU A 211     -14.367  -7.876  39.891  1.00 56.30           C  
ATOM    921  OE1 GLU A 211     -14.562  -7.553  41.085  1.00 56.44           O  
ATOM    922  OE2 GLU A 211     -14.833  -8.918  39.382  1.00 59.08           O  
ATOM    923  N   GLN A 212     -13.992  -2.513  39.233  1.00 45.22           N  
ATOM    924  CA  GLN A 212     -14.622  -1.196  39.282  1.00 45.42           C  
ATOM    925  C   GLN A 212     -13.561  -0.100  39.324  1.00 44.42           C  
ATOM    926  O   GLN A 212     -12.698  -0.096  40.203  1.00 42.84           O  
ATOM    927  CB  GLN A 212     -15.514  -1.088  40.520  1.00 46.98           C  
ATOM    928  CG  GLN A 212     -16.564  -2.185  40.641  1.00 49.92           C  
ATOM    929  CD  GLN A 212     -17.530  -2.201  39.471  1.00 52.30           C  
ATOM    930  OE1 GLN A 212     -18.168  -1.192  39.164  1.00 53.55           O  
ATOM    931  NE2 GLN A 212     -17.648  -3.351  38.815  1.00 51.85           N  
ATOM    932  N   ARG A 213     -13.629   0.834  38.380  1.00 43.70           N  
ATOM    933  CA  ARG A 213     -12.662   1.924  38.331  1.00 45.05           C  
ATOM    934  C   ARG A 213     -12.735   2.817  39.569  1.00 42.69           C  
ATOM    935  O   ARG A 213     -11.783   3.528  39.885  1.00 40.12           O  
ATOM    936  CB  ARG A 213     -12.864   2.760  37.060  1.00 48.31           C  
ATOM    937  CG  ARG A 213     -12.494   2.015  35.783  1.00 53.08           C  
ATOM    938  CD  ARG A 213     -12.614   2.894  34.546  1.00 56.95           C  
ATOM    939  NE  ARG A 213     -11.788   4.097  34.642  1.00 60.30           N  
ATOM    940  CZ  ARG A 213     -11.597   4.955  33.646  1.00 61.89           C  
ATOM    941  NH1 ARG A 213     -12.169   4.750  32.466  1.00 62.29           N  
ATOM    942  NH2 ARG A 213     -10.833   6.024  33.828  1.00 62.93           N  
ATOM    943  N   GLN A 214     -13.864   2.773  40.272  1.00 41.25           N  
ATOM    944  CA  GLN A 214     -14.041   3.576  41.482  1.00 39.77           C  
ATOM    945  C   GLN A 214     -13.023   3.146  42.537  1.00 36.86           C  
ATOM    946  O   GLN A 214     -12.521   3.967  43.310  1.00 35.45           O  
ATOM    947  CB  GLN A 214     -15.459   3.406  42.041  1.00 43.43           C  
ATOM    948  CG  GLN A 214     -16.570   3.923  41.132  1.00 47.75           C  
ATOM    949  CD  GLN A 214     -16.615   3.214  39.789  1.00 51.15           C  
ATOM    950  OE1 GLN A 214     -16.766   1.991  39.721  1.00 50.91           O  
ATOM    951  NE2 GLN A 214     -16.482   3.981  38.711  1.00 53.34           N  
ATOM    952  N   VAL A 215     -12.731   1.849  42.566  1.00 33.51           N  
ATOM    953  CA  VAL A 215     -11.767   1.298  43.508  1.00 31.12           C  
ATOM    954  C   VAL A 215     -10.375   1.839  43.195  1.00 29.80           C  
ATOM    955  O   VAL A 215      -9.601   2.133  44.100  1.00 27.76           O  
ATOM    956  CB  VAL A 215     -11.726  -0.246  43.433  1.00 31.18           C  
ATOM    957  CG1 VAL A 215     -10.627  -0.784  44.341  1.00 31.33           C  
ATOM    958  CG2 VAL A 215     -13.077  -0.827  43.842  1.00 33.15           C  
ATOM    959  N   LEU A 216     -10.058   1.960  41.910  1.00 28.00           N  
ATOM    960  CA  LEU A 216      -8.753   2.474  41.507  1.00 29.36           C  
ATOM    961  C   LEU A 216      -8.616   3.945  41.902  1.00 27.81           C  
ATOM    962  O   LEU A 216      -7.581   4.363  42.424  1.00 26.73           O  
ATOM    963  CB  LEU A 216      -8.557   2.328  39.992  1.00 29.22           C  
ATOM    964  CG  LEU A 216      -7.153   2.683  39.477  1.00 30.19           C  
ATOM    965  CD1 LEU A 216      -6.147   1.684  40.024  1.00 31.29           C  
ATOM    966  CD2 LEU A 216      -7.127   2.670  37.949  1.00 31.12           C  
ATOM    967  N   HIS A 217      -9.668   4.722  41.662  1.00 28.55           N  
ATOM    968  CA  HIS A 217      -9.662   6.146  41.987  1.00 28.45           C  
ATOM    969  C   HIS A 217      -9.476   6.417  43.478  1.00 28.71           C  
ATOM    970  O   HIS A 217      -8.788   7.365  43.866  1.00 27.73           O  
ATOM    971  CB  HIS A 217     -10.957   6.796  41.497  1.00 32.83           C  
ATOM    972  CG  HIS A 217     -11.037   6.922  40.006  1.00 35.86           C  
ATOM    973  ND1 HIS A 217     -12.142   7.431  39.358  1.00 39.50           N  
ATOM    974  CD2 HIS A 217     -10.144   6.610  39.039  1.00 37.67           C  
ATOM    975  CE1 HIS A 217     -11.925   7.425  38.055  1.00 39.18           C  
ATOM    976  NE2 HIS A 217     -10.720   6.931  37.835  1.00 39.41           N  
ATOM    977  N   ALA A 218     -10.089   5.586  44.312  1.00 27.08           N  
ATOM    978  CA  ALA A 218      -9.962   5.751  45.752  1.00 25.93           C  
ATOM    979  C   ALA A 218      -8.502   5.524  46.162  1.00 26.29           C  
ATOM    980  O   ALA A 218      -7.946   6.284  46.952  1.00 27.84           O  
ATOM    981  CB  ALA A 218     -10.881   4.766  46.478  1.00 26.27           C  
ATOM    982  N   ARG A 219      -7.889   4.478  45.615  1.00 25.08           N  
ATOM    983  CA  ARG A 219      -6.494   4.159  45.917  1.00 26.51           C  
ATOM    984  C   ARG A 219      -5.547   5.250  45.403  1.00 25.08           C  
ATOM    985  O   ARG A 219      -4.560   5.593  46.055  1.00 26.96           O  
ATOM    986  CB  ARG A 219      -6.130   2.801  45.301  1.00 27.05           C  
ATOM    987  CG  ARG A 219      -4.632   2.513  45.193  1.00 26.77           C  
ATOM    988  CD  ARG A 219      -3.925   2.543  46.545  1.00 29.25           C  
ATOM    989  NE  ARG A 219      -2.533   2.120  46.414  1.00 29.48           N  
ATOM    990  CZ  ARG A 219      -1.578   2.380  47.301  1.00 31.84           C  
ATOM    991  NH1 ARG A 219      -1.855   3.071  48.400  1.00 32.61           N  
ATOM    992  NH2 ARG A 219      -0.342   1.946  47.089  1.00 32.18           N  
ATOM    993  N   ILE A 220      -5.847   5.801  44.235  1.00 24.03           N  
ATOM    994  CA  ILE A 220      -5.003   6.851  43.675  1.00 23.62           C  
ATOM    995  C   ILE A 220      -4.948   8.080  44.578  1.00 22.89           C  
ATOM    996  O   ILE A 220      -3.883   8.655  44.788  1.00 22.81           O  
ATOM    997  CB  ILE A 220      -5.491   7.259  42.269  1.00 23.83           C  
ATOM    998  CG1 ILE A 220      -5.061   6.190  41.253  1.00 24.55           C  
ATOM    999  CG2 ILE A 220      -4.955   8.642  41.908  1.00 22.21           C  
ATOM   1000  CD1 ILE A 220      -5.685   6.345  39.883  1.00 26.34           C  
ATOM   1001  N   ALA A 221      -6.096   8.472  45.119  1.00 24.20           N  
ATOM   1002  CA  ALA A 221      -6.168   9.640  46.000  1.00 26.29           C  
ATOM   1003  C   ALA A 221      -5.396   9.390  47.297  1.00 26.25           C  
ATOM   1004  O   ALA A 221      -4.600  10.229  47.743  1.00 26.05           O  
ATOM   1005  CB  ALA A 221      -7.630   9.962  46.320  1.00 26.32           C  
ATOM   1006  N   GLN A 222      -5.649   8.237  47.904  1.00 25.31           N  
ATOM   1007  CA  GLN A 222      -4.988   7.875  49.152  1.00 25.57           C  
ATOM   1008  C   GLN A 222      -3.486   7.734  48.950  1.00 25.45           C  
ATOM   1009  O   GLN A 222      -2.698   8.219  49.768  1.00 26.05           O  
ATOM   1010  CB  GLN A 222      -5.582   6.572  49.701  1.00 26.91           C  
ATOM   1011  CG  GLN A 222      -4.928   6.057  50.981  1.00 26.26           C  
ATOM   1012  CD  GLN A 222      -3.821   5.076  50.702  1.00 30.99           C  
ATOM   1013  OE1 GLN A 222      -3.979   4.168  49.878  1.00 29.30           O  
ATOM   1014  NE2 GLN A 222      -2.690   5.231  51.395  1.00 30.07           N  
ATOM   1015  N   ARG A 223      -3.086   7.087  47.858  1.00 25.27           N  
ATOM   1016  CA  ARG A 223      -1.666   6.894  47.575  1.00 25.82           C  
ATOM   1017  C   ARG A 223      -0.947   8.227  47.391  1.00 26.76           C  
ATOM   1018  O   ARG A 223       0.172   8.407  47.872  1.00 26.46           O  
ATOM   1019  CB  ARG A 223      -1.470   6.027  46.321  1.00 27.16           C  
ATOM   1020  CG  ARG A 223      -0.015   5.621  46.081  1.00 27.29           C  
ATOM   1021  CD  ARG A 223       0.155   4.861  44.765  1.00 26.79           C  
ATOM   1022  NE  ARG A 223      -0.153   5.692  43.603  1.00 25.50           N  
ATOM   1023  CZ  ARG A 223       0.112   5.340  42.349  1.00 27.01           C  
ATOM   1024  NH1 ARG A 223       0.687   4.175  42.105  1.00 26.28           N  
ATOM   1025  NH2 ARG A 223      -0.183   6.156  41.342  1.00 29.32           N  
ATOM   1026  N   PHE A 224      -1.592   9.164  46.701  1.00 26.49           N  
ATOM   1027  CA  PHE A 224      -0.989  10.467  46.476  1.00 26.18           C  
ATOM   1028  C   PHE A 224      -0.802  11.188  47.806  1.00 26.12           C  
ATOM   1029  O   PHE A 224       0.256  11.741  48.074  1.00 23.57           O  
ATOM   1030  CB  PHE A 224      -1.854  11.319  45.535  1.00 25.70           C  
ATOM   1031  CG  PHE A 224      -1.169  12.567  45.056  1.00 27.43           C  
ATOM   1032  CD1 PHE A 224      -1.229  13.742  45.795  1.00 26.81           C  
ATOM   1033  CD2 PHE A 224      -0.409  12.550  43.889  1.00 28.33           C  
ATOM   1034  CE1 PHE A 224      -0.543  14.882  45.382  1.00 27.92           C  
ATOM   1035  CE2 PHE A 224       0.282  13.682  43.468  1.00 28.78           C  
ATOM   1036  CZ  PHE A 224       0.215  14.852  44.219  1.00 29.39           C  
ATOM   1037  N   ARG A 225      -1.829  11.167  48.645  1.00 25.94           N  
ATOM   1038  CA  ARG A 225      -1.736  11.836  49.938  1.00 28.94           C  
ATOM   1039  C   ARG A 225      -0.614  11.244  50.789  1.00 28.81           C  
ATOM   1040  O   ARG A 225       0.074  11.971  51.511  1.00 27.77           O  
ATOM   1041  CB  ARG A 225      -3.084  11.762  50.660  1.00 26.53           C  
ATOM   1042  CG  ARG A 225      -4.154  12.565  49.931  1.00 28.75           C  
ATOM   1043  CD  ARG A 225      -5.468  12.606  50.679  1.00 30.37           C  
ATOM   1044  NE  ARG A 225      -6.184  13.848  50.391  1.00 35.55           N  
ATOM   1045  CZ  ARG A 225      -7.140  13.975  49.480  1.00 37.96           C  
ATOM   1046  NH1 ARG A 225      -7.516  12.929  48.757  1.00 41.52           N  
ATOM   1047  NH2 ARG A 225      -7.716  15.155  49.291  1.00 37.76           N  
ATOM   1048  N   GLN A 226      -0.417   9.933  50.679  1.00 29.32           N  
ATOM   1049  CA  GLN A 226       0.630   9.240  51.421  1.00 29.42           C  
ATOM   1050  C   GLN A 226       2.012   9.626  50.874  1.00 29.94           C  
ATOM   1051  O   GLN A 226       2.977   9.719  51.629  1.00 28.26           O  
ATOM   1052  CB  GLN A 226       0.413   7.725  51.325  1.00 33.06           C  
ATOM   1053  CG  GLN A 226       1.351   6.874  52.171  1.00 37.99           C  
ATOM   1054  CD  GLN A 226       1.318   7.235  53.646  1.00 39.32           C  
ATOM   1055  OE1 GLN A 226       0.307   7.712  54.164  1.00 43.56           O  
ATOM   1056  NE2 GLN A 226       2.426   6.995  54.334  1.00 40.30           N  
ATOM   1057  N   MET A 227       2.109   9.837  49.560  1.00 27.50           N  
ATOM   1058  CA  MET A 227       3.380  10.243  48.953  1.00 26.13           C  
ATOM   1059  C   MET A 227       3.833  11.546  49.602  1.00 25.77           C  
ATOM   1060  O   MET A 227       5.009  11.722  49.922  1.00 24.94           O  
ATOM   1061  CB  MET A 227       3.222  10.477  47.447  1.00 24.42           C  
ATOM   1062  CG  MET A 227       3.003   9.220  46.626  1.00 22.89           C  
ATOM   1063  SD  MET A 227       2.607   9.630  44.900  1.00 25.06           S  
ATOM   1064  CE  MET A 227       2.961   8.067  44.114  1.00 23.06           C  
ATOM   1065  N   LEU A 228       2.891  12.464  49.787  1.00 25.76           N  
ATOM   1066  CA  LEU A 228       3.199  13.748  50.406  1.00 30.70           C  
ATOM   1067  C   LEU A 228       3.705  13.555  51.830  1.00 33.22           C  
ATOM   1068  O   LEU A 228       4.553  14.306  52.302  1.00 35.35           O  
ATOM   1069  CB  LEU A 228       1.966  14.657  50.408  1.00 29.45           C  
ATOM   1070  CG  LEU A 228       1.579  15.323  49.082  1.00 31.87           C  
ATOM   1071  CD1 LEU A 228       2.722  16.194  48.590  1.00 28.64           C  
ATOM   1072  CD2 LEU A 228       1.266  14.273  48.050  1.00 36.85           C  
ATOM   1073  N   GLU A 229       3.185  12.543  52.511  1.00 35.24           N  
ATOM   1074  CA  GLU A 229       3.605  12.261  53.876  1.00 37.04           C  
ATOM   1075  C   GLU A 229       4.967  11.584  53.923  1.00 35.49           C  
ATOM   1076  O   GLU A 229       5.691  11.726  54.902  1.00 36.16           O  
ATOM   1077  CB  GLU A 229       2.573  11.373  54.579  1.00 39.68           C  
ATOM   1078  CG  GLU A 229       1.292  12.090  54.979  1.00 44.90           C  
ATOM   1079  CD  GLU A 229       1.526  13.154  56.039  1.00 48.36           C  
ATOM   1080  OE1 GLU A 229       2.125  12.822  57.086  1.00 48.99           O  
ATOM   1081  OE2 GLU A 229       1.111  14.318  55.828  1.00 48.64           O  
ATOM   1082  N   GLN A 230       5.321  10.860  52.866  1.00 34.92           N  
ATOM   1083  CA  GLN A 230       6.595  10.157  52.834  1.00 34.65           C  
ATOM   1084  C   GLN A 230       7.782  10.920  52.242  1.00 33.75           C  
ATOM   1085  O   GLN A 230       8.857  10.352  52.087  1.00 35.68           O  
ATOM   1086  CB  GLN A 230       6.440   8.814  52.114  1.00 38.14           C  
ATOM   1087  CG  GLN A 230       5.555   7.809  52.849  1.00 41.64           C  
ATOM   1088  CD  GLN A 230       5.971   7.592  54.303  1.00 46.02           C  
ATOM   1089  OE1 GLN A 230       7.140   7.327  54.600  1.00 46.97           O  
ATOM   1090  NE2 GLN A 230       5.008   7.694  55.213  1.00 45.64           N  
ATOM   1091  N   GLY A 231       7.597  12.194  51.910  1.00 31.41           N  
ATOM   1092  CA  GLY A 231       8.712  12.971  51.386  1.00 31.95           C  
ATOM   1093  C   GLY A 231       8.668  13.455  49.945  1.00 30.14           C  
ATOM   1094  O   GLY A 231       9.675  13.938  49.429  1.00 31.28           O  
ATOM   1095  N   PHE A 232       7.518  13.333  49.293  1.00 29.99           N  
ATOM   1096  CA  PHE A 232       7.367  13.769  47.901  1.00 27.50           C  
ATOM   1097  C   PHE A 232       7.810  15.235  47.736  1.00 28.54           C  
ATOM   1098  O   PHE A 232       8.538  15.574  46.802  1.00 28.61           O  
ATOM   1099  CB  PHE A 232       5.896  13.579  47.481  1.00 26.28           C  
ATOM   1100  CG  PHE A 232       5.626  13.749  45.992  1.00 26.18           C  
ATOM   1101  CD1 PHE A 232       6.661  13.865  45.069  1.00 25.12           C  
ATOM   1102  CD2 PHE A 232       4.312  13.774  45.523  1.00 26.83           C  
ATOM   1103  CE1 PHE A 232       6.390  14.010  43.699  1.00 23.66           C  
ATOM   1104  CE2 PHE A 232       4.031  13.918  44.154  1.00 26.41           C  
ATOM   1105  CZ  PHE A 232       5.075  14.036  43.242  1.00 24.71           C  
ATOM   1106  N   ILE A 233       7.391  16.105  48.650  1.00 27.94           N  
ATOM   1107  CA  ILE A 233       7.757  17.516  48.558  1.00 29.86           C  
ATOM   1108  C   ILE A 233       9.269  17.759  48.619  1.00 28.92           C  
ATOM   1109  O   ILE A 233       9.812  18.517  47.808  1.00 27.52           O  
ATOM   1110  CB  ILE A 233       7.049  18.347  49.656  1.00 30.96           C  
ATOM   1111  CG1 ILE A 233       5.539  18.349  49.397  1.00 34.18           C  
ATOM   1112  CG2 ILE A 233       7.579  19.770  49.664  1.00 32.89           C  
ATOM   1113  CD1 ILE A 233       4.729  19.138  50.416  1.00 35.03           C  
ATOM   1114  N   ALA A 234       9.944  17.126  49.577  1.00 27.86           N  
ATOM   1115  CA  ALA A 234      11.391  17.274  49.706  1.00 29.17           C  
ATOM   1116  C   ALA A 234      12.081  16.712  48.461  1.00 28.99           C  
ATOM   1117  O   ALA A 234      13.125  17.210  48.031  1.00 27.79           O  
ATOM   1118  CB  ALA A 234      11.887  16.545  50.949  1.00 29.62           C  
ATOM   1119  N   GLU A 235      11.497  15.664  47.889  1.00 25.98           N  
ATOM   1120  CA  GLU A 235      12.051  15.051  46.689  1.00 27.19           C  
ATOM   1121  C   GLU A 235      12.041  16.071  45.553  1.00 25.45           C  
ATOM   1122  O   GLU A 235      13.050  16.279  44.872  1.00 26.85           O  
ATOM   1123  CB  GLU A 235      11.219  13.831  46.290  1.00 28.11           C  
ATOM   1124  CG  GLU A 235      11.753  13.074  45.085  1.00 27.63           C  
ATOM   1125  CD  GLU A 235      10.974  11.798  44.815  1.00 28.38           C  
ATOM   1126  OE1 GLU A 235       9.844  11.875  44.286  1.00 27.25           O  
ATOM   1127  OE2 GLU A 235      11.488  10.714  45.147  1.00 28.13           O  
ATOM   1128  N   VAL A 236      10.896  16.710  45.347  1.00 23.03           N  
ATOM   1129  CA  VAL A 236      10.775  17.699  44.290  1.00 23.27           C  
ATOM   1130  C   VAL A 236      11.606  18.938  44.617  1.00 24.47           C  
ATOM   1131  O   VAL A 236      12.120  19.604  43.721  1.00 23.68           O  
ATOM   1132  CB  VAL A 236       9.295  18.084  44.073  1.00 22.23           C  
ATOM   1133  CG1 VAL A 236       9.174  19.137  42.983  1.00 23.41           C  
ATOM   1134  CG2 VAL A 236       8.501  16.843  43.694  1.00 20.48           C  
ATOM   1135  N   GLU A 237      11.747  19.230  45.905  1.00 25.60           N  
ATOM   1136  CA  GLU A 237      12.528  20.376  46.359  1.00 27.92           C  
ATOM   1137  C   GLU A 237      13.968  20.282  45.828  1.00 26.62           C  
ATOM   1138  O   GLU A 237      14.563  21.288  45.432  1.00 24.41           O  
ATOM   1139  CB  GLU A 237      12.523  20.411  47.895  1.00 34.28           C  
ATOM   1140  CG  GLU A 237      12.478  21.799  48.496  1.00 41.75           C  
ATOM   1141  CD  GLU A 237      12.075  21.789  49.965  1.00 45.70           C  
ATOM   1142  OE1 GLU A 237      11.928  22.883  50.545  1.00 48.33           O  
ATOM   1143  OE2 GLU A 237      11.904  20.688  50.539  1.00 46.91           O  
ATOM   1144  N   ALA A 238      14.522  19.072  45.816  1.00 26.01           N  
ATOM   1145  CA  ALA A 238      15.884  18.864  45.323  1.00 27.50           C  
ATOM   1146  C   ALA A 238      15.953  19.124  43.817  1.00 27.44           C  
ATOM   1147  O   ALA A 238      16.951  19.632  43.312  1.00 27.10           O  
ATOM   1148  CB  ALA A 238      16.347  17.442  45.628  1.00 26.59           C  
ATOM   1149  N   LEU A 239      14.892  18.770  43.099  1.00 26.01           N  
ATOM   1150  CA  LEU A 239      14.855  18.993  41.653  1.00 25.53           C  
ATOM   1151  C   LEU A 239      14.663  20.474  41.360  1.00 26.56           C  
ATOM   1152  O   LEU A 239      15.316  21.038  40.481  1.00 26.76           O  
ATOM   1153  CB  LEU A 239      13.709  18.207  41.022  1.00 25.06           C  
ATOM   1154  CG  LEU A 239      13.707  16.694  41.246  1.00 25.64           C  
ATOM   1155  CD1 LEU A 239      12.422  16.100  40.686  1.00 27.06           C  
ATOM   1156  CD2 LEU A 239      14.929  16.073  40.586  1.00 29.26           C  
ATOM   1157  N   HIS A 240      13.756  21.087  42.114  1.00 26.23           N  
ATOM   1158  CA  HIS A 240      13.413  22.506  41.982  1.00 27.64           C  
ATOM   1159  C   HIS A 240      14.635  23.401  42.188  1.00 28.79           C  
ATOM   1160  O   HIS A 240      14.739  24.478  41.593  1.00 27.28           O  
ATOM   1161  CB  HIS A 240      12.341  22.849  43.020  1.00 29.14           C  
ATOM   1162  CG  HIS A 240      11.841  24.257  42.952  1.00 32.24           C  
ATOM   1163  ND1 HIS A 240      10.862  24.660  42.068  1.00 33.94           N  
ATOM   1164  CD2 HIS A 240      12.157  25.350  43.687  1.00 31.68           C  
ATOM   1165  CE1 HIS A 240      10.595  25.939  42.264  1.00 34.89           C  
ATOM   1166  NE2 HIS A 240      11.366  26.382  43.240  1.00 36.70           N  
ATOM   1167  N   ALA A 241      15.560  22.940  43.023  1.00 27.91           N  
ATOM   1168  CA  ALA A 241      16.770  23.693  43.338  1.00 29.25           C  
ATOM   1169  C   ALA A 241      17.844  23.655  42.249  1.00 28.23           C  
ATOM   1170  O   ALA A 241      18.788  24.449  42.279  1.00 29.29           O  
ATOM   1171  CB  ALA A 241      17.353  23.188  44.654  1.00 28.94           C  
ATOM   1172  N   ARG A 242      17.705  22.743  41.293  1.00 27.58           N  
ATOM   1173  CA  ARG A 242      18.688  22.612  40.218  1.00 27.14           C  
ATOM   1174  C   ARG A 242      18.482  23.628  39.095  1.00 27.67           C  
ATOM   1175  O   ARG A 242      17.391  23.747  38.535  1.00 24.96           O  
ATOM   1176  CB  ARG A 242      18.657  21.185  39.655  1.00 25.55           C  
ATOM   1177  CG  ARG A 242      19.261  20.147  40.595  1.00 27.97           C  
ATOM   1178  CD  ARG A 242      19.201  18.742  40.021  1.00 26.78           C  
ATOM   1179  NE  ARG A 242      19.860  18.637  38.721  1.00 23.93           N  
ATOM   1180  CZ  ARG A 242      20.036  17.490  38.072  1.00 24.33           C  
ATOM   1181  NH1 ARG A 242      19.605  16.356  38.607  1.00 25.45           N  
ATOM   1182  NH2 ARG A 242      20.632  17.474  36.886  1.00 24.93           N  
ATOM   1183  N   SER A 243      19.534  24.365  38.760  1.00 27.60           N  
ATOM   1184  CA  SER A 243      19.420  25.366  37.708  1.00 29.91           C  
ATOM   1185  C   SER A 243      19.350  24.713  36.334  1.00 29.08           C  
ATOM   1186  O   SER A 243      18.921  25.341  35.366  1.00 30.98           O  
ATOM   1187  CB  SER A 243      20.602  26.345  37.764  1.00 32.78           C  
ATOM   1188  OG  SER A 243      21.815  25.689  37.472  1.00 38.17           O  
ATOM   1189  N   ASP A 244      19.769  23.454  36.245  1.00 26.69           N  
ATOM   1190  CA  ASP A 244      19.723  22.755  34.970  1.00 26.75           C  
ATOM   1191  C   ASP A 244      18.398  22.025  34.751  1.00 27.40           C  
ATOM   1192  O   ASP A 244      18.254  21.246  33.818  1.00 27.68           O  
ATOM   1193  CB  ASP A 244      20.918  21.797  34.828  1.00 27.88           C  
ATOM   1194  CG  ASP A 244      20.979  20.743  35.926  1.00 28.20           C  
ATOM   1195  OD1 ASP A 244      20.512  21.006  37.059  1.00 25.39           O  
ATOM   1196  OD2 ASP A 244      21.522  19.651  35.648  1.00 27.25           O  
ATOM   1197  N   LEU A 245      17.424  22.289  35.613  1.00 25.56           N  
ATOM   1198  CA  LEU A 245      16.104  21.687  35.461  1.00 27.14           C  
ATOM   1199  C   LEU A 245      15.061  22.802  35.491  1.00 27.56           C  
ATOM   1200  O   LEU A 245      15.272  23.835  36.124  1.00 27.18           O  
ATOM   1201  CB  LEU A 245      15.806  20.694  36.597  1.00 24.57           C  
ATOM   1202  CG  LEU A 245      16.711  19.474  36.792  1.00 23.12           C  
ATOM   1203  CD1 LEU A 245      16.113  18.576  37.876  1.00 23.78           C  
ATOM   1204  CD2 LEU A 245      16.851  18.706  35.479  1.00 24.76           C  
ATOM   1205  N   HIS A 246      13.952  22.605  34.786  1.00 28.15           N  
ATOM   1206  CA  HIS A 246      12.864  23.577  34.805  1.00 27.86           C  
ATOM   1207  C   HIS A 246      11.557  22.804  34.672  1.00 27.72           C  
ATOM   1208  O   HIS A 246      11.555  21.648  34.253  1.00 25.94           O  
ATOM   1209  CB  HIS A 246      13.002  24.641  33.702  1.00 31.05           C  
ATOM   1210  CG  HIS A 246      12.941  24.104  32.307  1.00 33.78           C  
ATOM   1211  ND1 HIS A 246      14.049  23.620  31.644  1.00 37.47           N  
ATOM   1212  CD2 HIS A 246      11.906  23.989  31.441  1.00 33.63           C  
ATOM   1213  CE1 HIS A 246      13.701  23.233  30.429  1.00 35.50           C  
ATOM   1214  NE2 HIS A 246      12.404  23.446  30.281  1.00 37.99           N  
ATOM   1215  N   ALA A 247      10.458  23.445  35.050  1.00 28.73           N  
ATOM   1216  CA  ALA A 247       9.136  22.825  35.027  1.00 31.67           C  
ATOM   1217  C   ALA A 247       8.694  22.260  33.684  1.00 32.14           C  
ATOM   1218  O   ALA A 247       7.802  21.413  33.637  1.00 33.03           O  
ATOM   1219  CB  ALA A 247       8.093  23.822  35.528  1.00 33.05           C  
ATOM   1220  N   GLY A 248       9.316  22.718  32.601  1.00 31.87           N  
ATOM   1221  CA  GLY A 248       8.929  22.247  31.279  1.00 32.42           C  
ATOM   1222  C   GLY A 248       9.611  20.993  30.753  1.00 33.13           C  
ATOM   1223  O   GLY A 248       9.266  20.511  29.673  1.00 33.04           O  
ATOM   1224  N   LEU A 249      10.563  20.446  31.501  1.00 30.50           N  
ATOM   1225  CA  LEU A 249      11.270  19.247  31.051  1.00 31.35           C  
ATOM   1226  C   LEU A 249      10.408  17.985  31.038  1.00 31.86           C  
ATOM   1227  O   LEU A 249       9.449  17.869  31.796  1.00 29.76           O  
ATOM   1228  CB  LEU A 249      12.497  18.995  31.927  1.00 30.75           C  
ATOM   1229  CG  LEU A 249      13.667  19.978  31.844  1.00 29.63           C  
ATOM   1230  CD1 LEU A 249      14.684  19.601  32.909  1.00 30.63           C  
ATOM   1231  CD2 LEU A 249      14.305  19.935  30.457  1.00 29.77           C  
ATOM   1232  N   PRO A 250      10.750  17.019  30.167  1.00 32.78           N  
ATOM   1233  CA  PRO A 250      10.019  15.753  30.048  1.00 34.24           C  
ATOM   1234  C   PRO A 250       9.865  15.031  31.381  1.00 32.89           C  
ATOM   1235  O   PRO A 250       8.798  14.509  31.693  1.00 35.04           O  
ATOM   1236  CB  PRO A 250      10.873  14.959  29.063  1.00 34.91           C  
ATOM   1237  CG  PRO A 250      11.378  16.021  28.155  1.00 35.74           C  
ATOM   1238  CD  PRO A 250      11.798  17.105  29.133  1.00 36.10           C  
ATOM   1239  N   SER A 251      10.937  15.012  32.167  1.00 32.78           N  
ATOM   1240  CA  SER A 251      10.925  14.349  33.465  1.00 31.01           C  
ATOM   1241  C   SER A 251       9.876  14.916  34.420  1.00 30.28           C  
ATOM   1242  O   SER A 251       9.173  14.160  35.089  1.00 29.75           O  
ATOM   1243  CB  SER A 251      12.315  14.434  34.118  1.00 30.62           C  
ATOM   1244  OG  SER A 251      12.686  15.781  34.376  1.00 29.35           O  
ATOM   1245  N   ILE A 252       9.767  16.243  34.482  1.00 28.25           N  
ATOM   1246  CA  ILE A 252       8.805  16.877  35.378  1.00 29.41           C  
ATOM   1247  C   ILE A 252       7.373  16.643  34.901  1.00 28.86           C  
ATOM   1248  O   ILE A 252       6.411  17.047  35.550  1.00 28.76           O  
ATOM   1249  CB  ILE A 252       9.085  18.398  35.516  1.00 29.64           C  
ATOM   1250  CG1 ILE A 252      10.466  18.620  36.135  1.00 32.47           C  
ATOM   1251  CG2 ILE A 252       8.053  19.050  36.419  1.00 31.42           C  
ATOM   1252  CD1 ILE A 252      11.613  18.328  35.218  1.00 36.28           C  
ATOM   1253  N   ARG A 253       7.249  15.965  33.765  1.00 28.58           N  
ATOM   1254  CA  ARG A 253       5.951  15.633  33.195  1.00 30.35           C  
ATOM   1255  C   ARG A 253       5.371  14.432  33.945  1.00 28.05           C  
ATOM   1256  O   ARG A 253       4.177  14.139  33.834  1.00 28.20           O  
ATOM   1257  CB  ARG A 253       6.117  15.314  31.704  1.00 35.53           C  
ATOM   1258  CG  ARG A 253       4.892  15.543  30.845  1.00 43.40           C  
ATOM   1259  CD  ARG A 253       5.309  15.674  29.378  1.00 47.33           C  
ATOM   1260  NE  ARG A 253       6.215  16.806  29.189  1.00 51.87           N  
ATOM   1261  CZ  ARG A 253       6.924  17.030  28.086  1.00 54.60           C  
ATOM   1262  NH1 ARG A 253       6.841  16.198  27.056  1.00 55.12           N  
ATOM   1263  NH2 ARG A 253       7.723  18.088  28.013  1.00 54.63           N  
ATOM   1264  N   ALA A 254       6.213  13.736  34.715  1.00 26.08           N  
ATOM   1265  CA  ALA A 254       5.740  12.588  35.494  1.00 25.59           C  
ATOM   1266  C   ALA A 254       4.561  13.107  36.318  1.00 25.81           C  
ATOM   1267  O   ALA A 254       4.669  14.148  36.966  1.00 23.15           O  
ATOM   1268  CB  ALA A 254       6.862  12.061  36.411  1.00 24.45           C  
ATOM   1269  N   VAL A 255       3.436  12.392  36.296  1.00 26.19           N  
ATOM   1270  CA  VAL A 255       2.246  12.866  36.998  1.00 26.88           C  
ATOM   1271  C   VAL A 255       2.451  13.267  38.452  1.00 26.13           C  
ATOM   1272  O   VAL A 255       3.064  12.540  39.237  1.00 26.62           O  
ATOM   1273  CB  VAL A 255       1.088  11.837  36.935  1.00 29.52           C  
ATOM   1274  CG1 VAL A 255      -0.158  12.432  37.574  1.00 31.89           C  
ATOM   1275  CG2 VAL A 255       0.801  11.461  35.489  1.00 32.60           C  
ATOM   1276  N   GLY A 256       1.930  14.443  38.790  1.00 24.36           N  
ATOM   1277  CA  GLY A 256       2.037  14.956  40.141  1.00 24.50           C  
ATOM   1278  C   GLY A 256       3.204  15.905  40.361  1.00 23.29           C  
ATOM   1279  O   GLY A 256       3.093  16.855  41.137  1.00 21.42           O  
ATOM   1280  N   TYR A 257       4.315  15.674  39.666  1.00 24.08           N  
ATOM   1281  CA  TYR A 257       5.496  16.516  39.854  1.00 21.91           C  
ATOM   1282  C   TYR A 257       5.314  18.002  39.569  1.00 22.20           C  
ATOM   1283  O   TYR A 257       5.774  18.848  40.347  1.00 21.33           O  
ATOM   1284  CB  TYR A 257       6.684  15.953  39.063  1.00 22.51           C  
ATOM   1285  CG  TYR A 257       7.320  14.754  39.755  1.00 22.43           C  
ATOM   1286  CD1 TYR A 257       6.722  13.495  39.696  1.00 19.34           C  
ATOM   1287  CD2 TYR A 257       8.469  14.902  40.541  1.00 22.69           C  
ATOM   1288  CE1 TYR A 257       7.239  12.411  40.404  1.00 22.97           C  
ATOM   1289  CE2 TYR A 257       8.998  13.821  41.261  1.00 21.91           C  
ATOM   1290  CZ  TYR A 257       8.374  12.582  41.185  1.00 24.18           C  
ATOM   1291  OH  TYR A 257       8.865  11.517  41.895  1.00 25.77           O  
ATOM   1292  N   ARG A 258       4.625  18.331  38.481  1.00 20.87           N  
ATOM   1293  CA  ARG A 258       4.409  19.733  38.138  1.00 21.94           C  
ATOM   1294  C   ARG A 258       3.574  20.462  39.198  1.00 22.24           C  
ATOM   1295  O   ARG A 258       3.801  21.646  39.471  1.00 20.34           O  
ATOM   1296  CB  ARG A 258       3.744  19.844  36.754  1.00 22.97           C  
ATOM   1297  CG  ARG A 258       3.504  21.280  36.274  1.00 26.03           C  
ATOM   1298  CD  ARG A 258       4.802  22.085  36.279  1.00 30.76           C  
ATOM   1299  NE  ARG A 258       4.626  23.472  35.848  1.00 33.77           N  
ATOM   1300  CZ  ARG A 258       4.578  23.869  34.580  1.00 33.80           C  
ATOM   1301  NH1 ARG A 258       4.691  22.984  33.595  1.00 32.64           N  
ATOM   1302  NH2 ARG A 258       4.428  25.157  34.295  1.00 34.43           N  
ATOM   1303  N   GLN A 259       2.615  19.759  39.803  1.00 22.38           N  
ATOM   1304  CA  GLN A 259       1.777  20.364  40.838  1.00 23.72           C  
ATOM   1305  C   GLN A 259       2.624  20.696  42.068  1.00 24.25           C  
ATOM   1306  O   GLN A 259       2.494  21.775  42.650  1.00 25.02           O  
ATOM   1307  CB  GLN A 259       0.625  19.426  41.228  1.00 24.03           C  
ATOM   1308  CG  GLN A 259      -0.516  19.363  40.207  1.00 25.59           C  
ATOM   1309  CD  GLN A 259      -0.057  18.925  38.827  1.00 28.16           C  
ATOM   1310  OE1 GLN A 259      -0.031  19.722  37.879  1.00 32.15           O  
ATOM   1311  NE2 GLN A 259       0.310  17.657  38.704  1.00 23.54           N  
ATOM   1312  N   VAL A 260       3.494  19.768  42.459  1.00 24.02           N  
ATOM   1313  CA  VAL A 260       4.376  19.990  43.604  1.00 26.21           C  
ATOM   1314  C   VAL A 260       5.351  21.122  43.256  1.00 25.41           C  
ATOM   1315  O   VAL A 260       5.655  21.977  44.087  1.00 25.18           O  
ATOM   1316  CB  VAL A 260       5.168  18.707  43.953  1.00 27.54           C  
ATOM   1317  CG1 VAL A 260       6.114  18.963  45.128  1.00 26.42           C  
ATOM   1318  CG2 VAL A 260       4.201  17.576  44.299  1.00 28.67           C  
ATOM   1319  N   TRP A 261       5.822  21.133  42.015  1.00 23.88           N  
ATOM   1320  CA  TRP A 261       6.747  22.163  41.560  1.00 23.82           C  
ATOM   1321  C   TRP A 261       6.072  23.538  41.641  1.00 25.33           C  
ATOM   1322  O   TRP A 261       6.674  24.502  42.115  1.00 26.55           O  
ATOM   1323  CB  TRP A 261       7.199  21.851  40.124  1.00 21.20           C  
ATOM   1324  CG  TRP A 261       8.302  22.731  39.602  1.00 23.23           C  
ATOM   1325  CD1 TRP A 261       8.244  24.071  39.375  1.00 25.47           C  
ATOM   1326  CD2 TRP A 261       9.632  22.322  39.256  1.00 25.14           C  
ATOM   1327  NE1 TRP A 261       9.454  24.527  38.909  1.00 26.95           N  
ATOM   1328  CE2 TRP A 261      10.324  23.473  38.826  1.00 27.97           C  
ATOM   1329  CE3 TRP A 261      10.305  21.091  39.268  1.00 25.72           C  
ATOM   1330  CZ2 TRP A 261      11.661  23.434  38.409  1.00 28.09           C  
ATOM   1331  CZ3 TRP A 261      11.637  21.051  38.855  1.00 26.35           C  
ATOM   1332  CH2 TRP A 261      12.300  22.219  38.430  1.00 26.24           C  
ATOM   1333  N   ASP A 262       4.821  23.625  41.189  1.00 24.21           N  
ATOM   1334  CA  ASP A 262       4.078  24.886  41.232  1.00 27.21           C  
ATOM   1335  C   ASP A 262       3.835  25.321  42.679  1.00 26.63           C  
ATOM   1336  O   ASP A 262       3.785  26.516  42.977  1.00 28.73           O  
ATOM   1337  CB  ASP A 262       2.733  24.753  40.515  1.00 26.85           C  
ATOM   1338  CG  ASP A 262       2.867  24.772  39.004  1.00 31.44           C  
ATOM   1339  OD1 ASP A 262       3.999  24.919  38.488  1.00 32.25           O  
ATOM   1340  OD2 ASP A 262       1.827  24.646  38.331  1.00 32.81           O  
ATOM   1341  N   TYR A 263       3.669  24.348  43.565  1.00 27.68           N  
ATOM   1342  CA  TYR A 263       3.467  24.636  44.981  1.00 28.87           C  
ATOM   1343  C   TYR A 263       4.744  25.286  45.505  1.00 30.15           C  
ATOM   1344  O   TYR A 263       4.691  26.275  46.232  1.00 30.34           O  
ATOM   1345  CB  TYR A 263       3.193  23.344  45.748  1.00 29.25           C  
ATOM   1346  CG  TYR A 263       3.227  23.508  47.248  1.00 34.44           C  
ATOM   1347  CD1 TYR A 263       2.195  24.163  47.924  1.00 33.83           C  
ATOM   1348  CD2 TYR A 263       4.297  23.011  47.997  1.00 35.62           C  
ATOM   1349  CE1 TYR A 263       2.227  24.315  49.310  1.00 37.00           C  
ATOM   1350  CE2 TYR A 263       4.339  23.160  49.383  1.00 37.37           C  
ATOM   1351  CZ  TYR A 263       3.301  23.811  50.031  1.00 39.24           C  
ATOM   1352  OH  TYR A 263       3.335  23.958  51.401  1.00 41.96           O  
ATOM   1353  N   LEU A 264       5.889  24.718  45.125  1.00 30.42           N  
ATOM   1354  CA  LEU A 264       7.190  25.247  45.534  1.00 32.04           C  
ATOM   1355  C   LEU A 264       7.443  26.644  44.972  1.00 33.74           C  
ATOM   1356  O   LEU A 264       8.236  27.409  45.527  1.00 32.93           O  
ATOM   1357  CB  LEU A 264       8.312  24.295  45.097  1.00 32.29           C  
ATOM   1358  CG  LEU A 264       8.655  23.162  46.074  1.00 35.83           C  
ATOM   1359  CD1 LEU A 264       7.392  22.521  46.596  1.00 38.17           C  
ATOM   1360  CD2 LEU A 264       9.543  22.131  45.384  1.00 35.17           C  
ATOM   1361  N   ASP A 265       6.778  26.977  43.868  1.00 33.60           N  
ATOM   1362  CA  ASP A 265       6.928  28.303  43.275  1.00 36.25           C  
ATOM   1363  C   ASP A 265       5.957  29.300  43.900  1.00 35.75           C  
ATOM   1364  O   ASP A 265       5.922  30.466  43.510  1.00 37.03           O  
ATOM   1365  CB  ASP A 265       6.703  28.264  41.763  1.00 36.59           C  
ATOM   1366  CG  ASP A 265       7.952  27.882  40.999  1.00 38.80           C  
ATOM   1367  OD1 ASP A 265       9.058  28.125  41.517  1.00 42.66           O  
ATOM   1368  OD2 ASP A 265       7.832  27.359  39.873  1.00 41.84           O  
ATOM   1369  N   GLY A 266       5.170  28.829  44.862  1.00 36.02           N  
ATOM   1370  CA  GLY A 266       4.215  29.685  45.542  1.00 36.00           C  
ATOM   1371  C   GLY A 266       2.965  30.003  44.745  1.00 37.35           C  
ATOM   1372  O   GLY A 266       2.236  30.942  45.072  1.00 35.64           O  
ATOM   1373  N   LYS A 267       2.690  29.214  43.713  1.00 35.51           N  
ATOM   1374  CA  LYS A 267       1.522  29.475  42.882  1.00 36.83           C  
ATOM   1375  C   LYS A 267       0.267  28.726  43.305  1.00 36.26           C  
ATOM   1376  O   LYS A 267      -0.842  29.092  42.918  1.00 36.19           O  
ATOM   1377  CB  LYS A 267       1.857  29.156  41.423  1.00 40.28           C  
ATOM   1378  CG  LYS A 267       3.181  29.759  40.994  1.00 44.08           C  
ATOM   1379  CD  LYS A 267       3.224  30.081  39.514  1.00 48.97           C  
ATOM   1380  CE  LYS A 267       3.144  28.836  38.658  1.00 50.37           C  
ATOM   1381  NZ  LYS A 267       3.284  29.192  37.216  1.00 53.45           N  
ATOM   1382  N   LEU A 268       0.444  27.696  44.120  1.00 34.11           N  
ATOM   1383  CA  LEU A 268      -0.666  26.870  44.581  1.00 34.29           C  
ATOM   1384  C   LEU A 268      -0.670  26.685  46.086  1.00 33.84           C  
ATOM   1385  O   LEU A 268       0.381  26.719  46.726  1.00 34.75           O  
ATOM   1386  CB  LEU A 268      -0.577  25.479  43.943  1.00 34.85           C  
ATOM   1387  CG  LEU A 268      -1.234  25.187  42.594  1.00 38.25           C  
ATOM   1388  CD1 LEU A 268      -1.050  26.337  41.634  1.00 38.92           C  
ATOM   1389  CD2 LEU A 268      -0.635  23.894  42.047  1.00 36.26           C  
ATOM   1390  N   SER A 269      -1.857  26.478  46.644  1.00 32.93           N  
ATOM   1391  CA  SER A 269      -1.988  26.210  48.069  1.00 33.73           C  
ATOM   1392  C   SER A 269      -1.729  24.707  48.189  1.00 33.59           C  
ATOM   1393  O   SER A 269      -1.752  23.978  47.184  1.00 30.59           O  
ATOM   1394  CB  SER A 269      -3.404  26.512  48.553  1.00 31.97           C  
ATOM   1395  OG  SER A 269      -4.315  25.536  48.072  1.00 30.63           O  
ATOM   1396  N   TYR A 270      -1.484  24.244  49.408  1.00 32.99           N  
ATOM   1397  CA  TYR A 270      -1.231  22.832  49.653  1.00 34.02           C  
ATOM   1398  C   TYR A 270      -2.428  22.001  49.187  1.00 32.78           C  
ATOM   1399  O   TYR A 270      -2.264  20.933  48.593  1.00 32.45           O  
ATOM   1400  CB  TYR A 270      -1.000  22.596  51.147  1.00 35.00           C  
ATOM   1401  CG  TYR A 270      -0.332  21.283  51.473  1.00 36.12           C  
ATOM   1402  CD1 TYR A 270       1.055  21.157  51.417  1.00 36.36           C  
ATOM   1403  CD2 TYR A 270      -1.082  20.169  51.852  1.00 36.90           C  
ATOM   1404  CE1 TYR A 270       1.682  19.958  51.737  1.00 38.25           C  
ATOM   1405  CE2 TYR A 270      -0.464  18.959  52.171  1.00 36.50           C  
ATOM   1406  CZ  TYR A 270       0.919  18.865  52.112  1.00 38.73           C  
ATOM   1407  OH  TYR A 270       1.546  17.679  52.425  1.00 41.82           O  
ATOM   1408  N   ALA A 271      -3.631  22.504  49.457  1.00 31.20           N  
ATOM   1409  CA  ALA A 271      -4.866  21.816  49.081  1.00 30.87           C  
ATOM   1410  C   ALA A 271      -5.048  21.703  47.566  1.00 29.71           C  
ATOM   1411  O   ALA A 271      -5.467  20.658  47.056  1.00 29.17           O  
ATOM   1412  CB  ALA A 271      -6.062  22.534  49.689  1.00 31.80           C  
ATOM   1413  N   GLU A 272      -4.748  22.783  46.854  1.00 29.00           N  
ATOM   1414  CA  GLU A 272      -4.878  22.798  45.396  1.00 30.37           C  
ATOM   1415  C   GLU A 272      -3.847  21.866  44.767  1.00 29.36           C  
ATOM   1416  O   GLU A 272      -4.138  21.150  43.800  1.00 29.55           O  
ATOM   1417  CB  GLU A 272      -4.681  24.216  44.858  1.00 31.31           C  
ATOM   1418  CG  GLU A 272      -5.639  25.236  45.446  1.00 34.06           C  
ATOM   1419  CD  GLU A 272      -5.381  26.644  44.943  1.00 36.24           C  
ATOM   1420  OE1 GLU A 272      -4.205  27.064  44.918  1.00 35.97           O  
ATOM   1421  OE2 GLU A 272      -6.360  27.336  44.582  1.00 39.63           O  
ATOM   1422  N   MET A 273      -2.636  21.882  45.306  1.00 28.13           N  
ATOM   1423  CA  MET A 273      -1.599  21.011  44.782  1.00 28.30           C  
ATOM   1424  C   MET A 273      -2.045  19.561  44.950  1.00 27.07           C  
ATOM   1425  O   MET A 273      -1.911  18.745  44.035  1.00 26.94           O  
ATOM   1426  CB  MET A 273      -0.278  21.264  45.510  1.00 29.03           C  
ATOM   1427  CG  MET A 273       0.827  20.310  45.121  1.00 32.65           C  
ATOM   1428  SD  MET A 273       1.047  19.050  46.366  1.00 39.67           S  
ATOM   1429  CE  MET A 273       2.135  19.954  47.480  1.00 36.54           C  
ATOM   1430  N   THR A 274      -2.600  19.245  46.115  1.00 26.46           N  
ATOM   1431  CA  THR A 274      -3.065  17.889  46.380  1.00 26.36           C  
ATOM   1432  C   THR A 274      -4.195  17.468  45.435  1.00 26.76           C  
ATOM   1433  O   THR A 274      -4.128  16.405  44.813  1.00 26.42           O  
ATOM   1434  CB  THR A 274      -3.547  17.742  47.850  1.00 27.17           C  
ATOM   1435  OG1 THR A 274      -2.472  18.072  48.736  1.00 27.82           O  
ATOM   1436  CG2 THR A 274      -3.988  16.311  48.134  1.00 27.46           C  
ATOM   1437  N   GLU A 275      -5.225  18.303  45.318  1.00 26.52           N  
ATOM   1438  CA  GLU A 275      -6.361  17.988  44.452  1.00 28.04           C  
ATOM   1439  C   GLU A 275      -5.962  17.807  42.992  1.00 25.09           C  
ATOM   1440  O   GLU A 275      -6.376  16.849  42.335  1.00 23.52           O  
ATOM   1441  CB  GLU A 275      -7.424  19.088  44.538  1.00 33.27           C  
ATOM   1442  CG  GLU A 275      -8.696  18.772  43.747  1.00 41.06           C  
ATOM   1443  CD  GLU A 275      -9.702  19.915  43.771  1.00 47.60           C  
ATOM   1444  OE1 GLU A 275      -9.981  20.440  44.871  1.00 49.60           O  
ATOM   1445  OE2 GLU A 275     -10.220  20.284  42.693  1.00 50.97           O  
ATOM   1446  N   ARG A 276      -5.147  18.725  42.490  1.00 23.74           N  
ATOM   1447  CA  ARG A 276      -4.720  18.677  41.103  1.00 23.86           C  
ATOM   1448  C   ARG A 276      -3.734  17.561  40.787  1.00 23.48           C  
ATOM   1449  O   ARG A 276      -3.698  17.074  39.661  1.00 23.55           O  
ATOM   1450  CB  ARG A 276      -4.181  20.050  40.693  1.00 22.75           C  
ATOM   1451  CG  ARG A 276      -5.279  21.106  40.779  1.00 25.40           C  
ATOM   1452  CD  ARG A 276      -4.772  22.527  40.634  1.00 25.48           C  
ATOM   1453  NE  ARG A 276      -5.850  23.479  40.890  1.00 26.38           N  
ATOM   1454  CZ  ARG A 276      -5.708  24.800  40.890  1.00 26.76           C  
ATOM   1455  NH1 ARG A 276      -4.529  25.349  40.642  1.00 25.67           N  
ATOM   1456  NH2 ARG A 276      -6.749  25.575  41.163  1.00 29.33           N  
ATOM   1457  N   GLY A 277      -2.940  17.149  41.770  1.00 21.98           N  
ATOM   1458  CA  GLY A 277      -2.026  16.045  41.536  1.00 21.70           C  
ATOM   1459  C   GLY A 277      -2.848  14.764  41.441  1.00 21.79           C  
ATOM   1460  O   GLY A 277      -2.544  13.863  40.650  1.00 21.38           O  
ATOM   1461  N   ILE A 278      -3.894  14.679  42.260  1.00 20.90           N  
ATOM   1462  CA  ILE A 278      -4.786  13.524  42.248  1.00 22.65           C  
ATOM   1463  C   ILE A 278      -5.544  13.512  40.914  1.00 23.49           C  
ATOM   1464  O   ILE A 278      -5.655  12.472  40.267  1.00 23.08           O  
ATOM   1465  CB  ILE A 278      -5.790  13.576  43.431  1.00 23.39           C  
ATOM   1466  CG1 ILE A 278      -5.057  13.259  44.743  1.00 24.77           C  
ATOM   1467  CG2 ILE A 278      -6.920  12.571  43.212  1.00 23.72           C  
ATOM   1468  CD1 ILE A 278      -5.905  13.459  46.003  1.00 25.68           C  
ATOM   1469  N   ILE A 279      -6.053  14.671  40.500  1.00 24.00           N  
ATOM   1470  CA  ILE A 279      -6.764  14.763  39.222  1.00 23.61           C  
ATOM   1471  C   ILE A 279      -5.855  14.319  38.075  1.00 23.28           C  
ATOM   1472  O   ILE A 279      -6.254  13.537  37.203  1.00 22.37           O  
ATOM   1473  CB  ILE A 279      -7.220  16.204  38.940  1.00 24.59           C  
ATOM   1474  CG1 ILE A 279      -8.367  16.584  39.879  1.00 26.74           C  
ATOM   1475  CG2 ILE A 279      -7.662  16.337  37.485  1.00 23.58           C  
ATOM   1476  CD1 ILE A 279      -8.752  18.053  39.783  1.00 29.31           C  
ATOM   1477  N   ALA A 280      -4.627  14.823  38.083  1.00 22.12           N  
ATOM   1478  CA  ALA A 280      -3.661  14.480  37.047  1.00 22.83           C  
ATOM   1479  C   ALA A 280      -3.424  12.970  36.982  1.00 22.29           C  
ATOM   1480  O   ALA A 280      -3.295  12.397  35.898  1.00 19.46           O  
ATOM   1481  CB  ALA A 280      -2.345  15.225  37.300  1.00 24.63           C  
ATOM   1482  N   THR A 281      -3.380  12.321  38.141  1.00 21.69           N  
ATOM   1483  CA  THR A 281      -3.157  10.881  38.188  1.00 22.89           C  
ATOM   1484  C   THR A 281      -4.390  10.099  37.713  1.00 24.14           C  
ATOM   1485  O   THR A 281      -4.251   9.055  37.072  1.00 24.00           O  
ATOM   1486  CB  THR A 281      -2.755  10.430  39.614  1.00 22.99           C  
ATOM   1487  OG1 THR A 281      -1.636  11.215  40.051  1.00 21.95           O  
ATOM   1488  CG2 THR A 281      -2.362   8.964  39.621  1.00 24.31           C  
ATOM   1489  N   ARG A 282      -5.590  10.588  38.027  1.00 23.83           N  
ATOM   1490  CA  ARG A 282      -6.802   9.913  37.558  1.00 26.96           C  
ATOM   1491  C   ARG A 282      -6.871  10.039  36.034  1.00 27.51           C  
ATOM   1492  O   ARG A 282      -7.324   9.126  35.340  1.00 25.94           O  
ATOM   1493  CB  ARG A 282      -8.063  10.545  38.152  1.00 28.70           C  
ATOM   1494  CG  ARG A 282      -8.273  10.294  39.627  1.00 34.10           C  
ATOM   1495  CD  ARG A 282      -9.760  10.322  39.935  1.00 39.60           C  
ATOM   1496  NE  ARG A 282     -10.041  10.860  41.258  1.00 48.02           N  
ATOM   1497  CZ  ARG A 282     -10.198  12.153  41.526  1.00 47.48           C  
ATOM   1498  NH1 ARG A 282     -10.106  13.054  40.559  1.00 49.68           N  
ATOM   1499  NH2 ARG A 282     -10.443  12.543  42.769  1.00 49.13           N  
ATOM   1500  N   GLN A 283      -6.413  11.183  35.532  1.00 27.27           N  
ATOM   1501  CA  GLN A 283      -6.400  11.475  34.098  1.00 29.51           C  
ATOM   1502  C   GLN A 283      -5.477  10.491  33.381  1.00 28.36           C  
ATOM   1503  O   GLN A 283      -5.786  10.006  32.288  1.00 27.46           O  
ATOM   1504  CB  GLN A 283      -5.917  12.907  33.877  1.00 33.85           C  
ATOM   1505  CG  GLN A 283      -6.814  13.749  32.995  1.00 43.84           C  
ATOM   1506  CD  GLN A 283      -8.259  13.728  33.442  1.00 45.92           C  
ATOM   1507  OE1 GLN A 283      -8.569  14.017  34.596  1.00 50.96           O  
ATOM   1508  NE2 GLN A 283      -9.156  13.385  32.525  1.00 47.36           N  
ATOM   1509  N   LEU A 284      -4.335  10.207  34.000  1.00 25.34           N  
ATOM   1510  CA  LEU A 284      -3.388   9.259  33.434  1.00 26.25           C  
ATOM   1511  C   LEU A 284      -4.047   7.882  33.339  1.00 25.54           C  
ATOM   1512  O   LEU A 284      -3.963   7.215  32.308  1.00 24.53           O  
ATOM   1513  CB  LEU A 284      -2.134   9.177  34.311  1.00 24.20           C  
ATOM   1514  CG  LEU A 284      -1.236   7.969  34.020  1.00 26.88           C  
ATOM   1515  CD1 LEU A 284      -0.693   8.066  32.601  1.00 24.99           C  
ATOM   1516  CD2 LEU A 284      -0.094   7.917  35.034  1.00 25.77           C  
ATOM   1517  N   ALA A 285      -4.702   7.461  34.416  1.00 25.22           N  
ATOM   1518  CA  ALA A 285      -5.368   6.157  34.438  1.00 27.83           C  
ATOM   1519  C   ALA A 285      -6.449   6.087  33.358  1.00 29.54           C  
ATOM   1520  O   ALA A 285      -6.639   5.052  32.714  1.00 28.56           O  
ATOM   1521  CB  ALA A 285      -5.980   5.901  35.813  1.00 27.20           C  
ATOM   1522  N   LYS A 286      -7.150   7.196  33.161  1.00 27.61           N  
ATOM   1523  CA  LYS A 286      -8.199   7.256  32.151  1.00 32.19           C  
ATOM   1524  C   LYS A 286      -7.571   7.043  30.773  1.00 31.45           C  
ATOM   1525  O   LYS A 286      -8.089   6.275  29.959  1.00 30.24           O  
ATOM   1526  CB  LYS A 286      -8.909   8.611  32.224  1.00 35.37           C  
ATOM   1527  CG  LYS A 286     -10.146   8.736  31.350  1.00 40.98           C  
ATOM   1528  CD  LYS A 286     -10.875  10.048  31.643  1.00 44.49           C  
ATOM   1529  CE  LYS A 286     -12.180  10.155  30.860  1.00 47.14           C  
ATOM   1530  NZ  LYS A 286     -12.976  11.360  31.249  1.00 45.08           N  
ATOM   1531  N   ARG A 287      -6.444   7.711  30.521  1.00 29.58           N  
ATOM   1532  CA  ARG A 287      -5.747   7.571  29.246  1.00 31.09           C  
ATOM   1533  C   ARG A 287      -5.224   6.152  29.059  1.00 31.09           C  
ATOM   1534  O   ARG A 287      -5.246   5.616  27.949  1.00 29.43           O  
ATOM   1535  CB  ARG A 287      -4.567   8.547  29.153  1.00 32.47           C  
ATOM   1536  CG  ARG A 287      -4.953  10.013  28.992  1.00 34.12           C  
ATOM   1537  CD  ARG A 287      -3.766  10.819  28.478  1.00 37.61           C  
ATOM   1538  NE  ARG A 287      -2.658  10.848  29.433  1.00 39.41           N  
ATOM   1539  CZ  ARG A 287      -2.647  11.594  30.534  1.00 39.80           C  
ATOM   1540  NH1 ARG A 287      -3.684  12.371  30.814  1.00 38.11           N  
ATOM   1541  NH2 ARG A 287      -1.603  11.559  31.356  1.00 38.14           N  
ATOM   1542  N   GLN A 288      -4.733   5.556  30.144  1.00 30.01           N  
ATOM   1543  CA  GLN A 288      -4.206   4.200  30.099  1.00 30.82           C  
ATOM   1544  C   GLN A 288      -5.322   3.214  29.767  1.00 32.59           C  
ATOM   1545  O   GLN A 288      -5.126   2.287  28.976  1.00 32.28           O  
ATOM   1546  CB  GLN A 288      -3.543   3.848  31.440  1.00 31.04           C  
ATOM   1547  CG  GLN A 288      -2.175   4.514  31.621  1.00 27.63           C  
ATOM   1548  CD  GLN A 288      -1.608   4.367  33.025  1.00 29.38           C  
ATOM   1549  OE1 GLN A 288      -0.402   4.161  33.199  1.00 30.84           O  
ATOM   1550  NE2 GLN A 288      -2.465   4.497  34.031  1.00 23.08           N  
ATOM   1551  N   PHE A 289      -6.494   3.417  30.362  1.00 32.05           N  
ATOM   1552  CA  PHE A 289      -7.625   2.543  30.080  1.00 34.16           C  
ATOM   1553  C   PHE A 289      -8.023   2.661  28.608  1.00 34.54           C  
ATOM   1554  O   PHE A 289      -8.404   1.672  27.983  1.00 34.55           O  
ATOM   1555  CB  PHE A 289      -8.816   2.896  30.969  1.00 33.69           C  
ATOM   1556  CG  PHE A 289      -8.818   2.182  32.291  1.00 35.58           C  
ATOM   1557  CD1 PHE A 289      -8.819   2.897  33.484  1.00 35.94           C  
ATOM   1558  CD2 PHE A 289      -8.838   0.791  32.345  1.00 36.63           C  
ATOM   1559  CE1 PHE A 289      -8.843   2.241  34.712  1.00 36.93           C  
ATOM   1560  CE2 PHE A 289      -8.863   0.123  33.568  1.00 37.85           C  
ATOM   1561  CZ  PHE A 289      -8.866   0.851  34.755  1.00 37.40           C  
ATOM   1562  N   THR A 290      -7.923   3.869  28.056  1.00 34.80           N  
ATOM   1563  CA  THR A 290      -8.268   4.091  26.654  1.00 37.29           C  
ATOM   1564  C   THR A 290      -7.369   3.265  25.731  1.00 37.57           C  
ATOM   1565  O   THR A 290      -7.845   2.674  24.760  1.00 36.47           O  
ATOM   1566  CB  THR A 290      -8.155   5.584  26.279  1.00 38.29           C  
ATOM   1567  OG1 THR A 290      -9.143   6.327  27.003  1.00 39.39           O  
ATOM   1568  CG2 THR A 290      -8.369   5.783  24.782  1.00 38.63           C  
ATOM   1569  N   TRP A 291      -6.072   3.229  26.031  1.00 37.58           N  
ATOM   1570  CA  TRP A 291      -5.133   2.449  25.230  1.00 38.78           C  
ATOM   1571  C   TRP A 291      -5.460   0.961  25.334  1.00 39.66           C  
ATOM   1572  O   TRP A 291      -5.482   0.245  24.333  1.00 38.48           O  
ATOM   1573  CB  TRP A 291      -3.691   2.647  25.707  1.00 39.30           C  
ATOM   1574  CG  TRP A 291      -3.018   3.887  25.217  1.00 41.55           C  
ATOM   1575  CD1 TRP A 291      -3.098   5.137  25.761  1.00 42.29           C  
ATOM   1576  CD2 TRP A 291      -2.133   3.993  24.094  1.00 42.67           C  
ATOM   1577  NE1 TRP A 291      -2.314   6.014  25.049  1.00 41.63           N  
ATOM   1578  CE2 TRP A 291      -1.711   5.339  24.021  1.00 42.44           C  
ATOM   1579  CE3 TRP A 291      -1.655   3.080  23.143  1.00 43.29           C  
ATOM   1580  CZ2 TRP A 291      -0.831   5.797  23.033  1.00 43.08           C  
ATOM   1581  CZ3 TRP A 291      -0.779   3.536  22.160  1.00 44.93           C  
ATOM   1582  CH2 TRP A 291      -0.377   4.883  22.115  1.00 44.08           C  
ATOM   1583  N   LEU A 292      -5.709   0.513  26.560  1.00 39.52           N  
ATOM   1584  CA  LEU A 292      -6.004  -0.886  26.837  1.00 42.65           C  
ATOM   1585  C   LEU A 292      -7.323  -1.399  26.266  1.00 45.63           C  
ATOM   1586  O   LEU A 292      -7.404  -2.552  25.838  1.00 44.89           O  
ATOM   1587  CB  LEU A 292      -5.970  -1.125  28.353  1.00 40.26           C  
ATOM   1588  CG  LEU A 292      -4.626  -0.834  29.037  1.00 38.90           C  
ATOM   1589  CD1 LEU A 292      -4.781  -0.888  30.548  1.00 37.69           C  
ATOM   1590  CD2 LEU A 292      -3.582  -1.832  28.566  1.00 38.32           C  
ATOM   1591  N   ARG A 293      -8.350  -0.552  26.249  1.00 48.17           N  
ATOM   1592  CA  ARG A 293      -9.655  -0.967  25.741  1.00 52.16           C  
ATOM   1593  C   ARG A 293      -9.606  -1.409  24.279  1.00 52.45           C  
ATOM   1594  O   ARG A 293     -10.403  -2.243  23.849  1.00 53.80           O  
ATOM   1595  CB  ARG A 293     -10.683   0.163  25.890  1.00 54.61           C  
ATOM   1596  CG  ARG A 293     -10.709   1.145  24.731  1.00 59.05           C  
ATOM   1597  CD  ARG A 293     -12.015   1.925  24.693  1.00 63.13           C  
ATOM   1598  NE  ARG A 293     -12.204   2.604  23.414  1.00 66.71           N  
ATOM   1599  CZ  ARG A 293     -13.321   3.230  23.051  1.00 68.53           C  
ATOM   1600  NH1 ARG A 293     -14.362   3.271  23.874  1.00 69.09           N  
ATOM   1601  NH2 ARG A 293     -13.399   3.812  21.860  1.00 69.59           N  
ATOM   1602  N   SER A 294      -8.671  -0.852  23.518  1.00 52.47           N  
ATOM   1603  CA  SER A 294      -8.539  -1.196  22.106  1.00 53.25           C  
ATOM   1604  C   SER A 294      -7.335  -2.097  21.851  1.00 52.60           C  
ATOM   1605  O   SER A 294      -6.927  -2.291  20.705  1.00 52.96           O  
ATOM   1606  CB  SER A 294      -8.408   0.078  21.271  1.00 54.64           C  
ATOM   1607  OG  SER A 294      -7.286   0.839  21.684  1.00 58.13           O  
ATOM   1608  N   TRP A 295      -6.777  -2.647  22.922  1.00 50.87           N  
ATOM   1609  CA  TRP A 295      -5.609  -3.519  22.830  1.00 49.42           C  
ATOM   1610  C   TRP A 295      -6.046  -4.966  22.617  1.00 49.20           C  
ATOM   1611  O   TRP A 295      -6.774  -5.532  23.432  1.00 49.82           O  
ATOM   1612  CB  TRP A 295      -4.791  -3.398  24.117  1.00 48.46           C  
ATOM   1613  CG  TRP A 295      -3.328  -3.660  23.957  1.00 46.64           C  
ATOM   1614  CD1 TRP A 295      -2.712  -4.873  23.871  1.00 44.67           C  
ATOM   1615  CD2 TRP A 295      -2.292  -2.675  23.873  1.00 45.62           C  
ATOM   1616  NE1 TRP A 295      -1.353  -4.706  23.743  1.00 44.09           N  
ATOM   1617  CE2 TRP A 295      -1.069  -3.366  23.739  1.00 44.72           C  
ATOM   1618  CE3 TRP A 295      -2.281  -1.274  23.898  1.00 46.24           C  
ATOM   1619  CZ2 TRP A 295       0.158  -2.704  23.633  1.00 44.17           C  
ATOM   1620  CZ3 TRP A 295      -1.060  -0.613  23.790  1.00 47.22           C  
ATOM   1621  CH2 TRP A 295       0.143  -1.332  23.658  1.00 46.86           C  
ATOM   1622  N   SER A 296      -5.596  -5.566  21.522  1.00 48.81           N  
ATOM   1623  CA  SER A 296      -5.962  -6.943  21.221  1.00 48.94           C  
ATOM   1624  C   SER A 296      -5.018  -7.953  21.867  1.00 47.88           C  
ATOM   1625  O   SER A 296      -3.858  -7.646  22.155  1.00 46.57           O  
ATOM   1626  CB  SER A 296      -5.988  -7.160  19.707  1.00 50.06           C  
ATOM   1627  OG  SER A 296      -4.701  -6.976  19.146  1.00 52.86           O  
ATOM   1628  N   HIS A 297      -5.533  -9.157  22.091  1.00 46.99           N  
ATOM   1629  CA  HIS A 297      -4.765 -10.245  22.683  1.00 47.69           C  
ATOM   1630  C   HIS A 297      -4.357  -9.959  24.125  1.00 46.34           C  
ATOM   1631  O   HIS A 297      -3.236 -10.264  24.537  1.00 46.38           O  
ATOM   1632  CB  HIS A 297      -3.517 -10.531  21.839  1.00 49.86           C  
ATOM   1633  CG  HIS A 297      -3.808 -10.763  20.388  1.00 53.26           C  
ATOM   1634  ND1 HIS A 297      -4.713 -11.706  19.951  1.00 54.80           N  
ATOM   1635  CD2 HIS A 297      -3.304 -10.182  19.273  1.00 54.59           C  
ATOM   1636  CE1 HIS A 297      -4.755 -11.697  18.631  1.00 54.99           C  
ATOM   1637  NE2 HIS A 297      -3.909 -10.781  18.194  1.00 54.82           N  
ATOM   1638  N   LEU A 298      -5.271  -9.367  24.886  1.00 43.98           N  
ATOM   1639  CA  LEU A 298      -5.018  -9.055  26.287  1.00 43.11           C  
ATOM   1640  C   LEU A 298      -5.790  -9.998  27.195  1.00 42.65           C  
ATOM   1641  O   LEU A 298      -6.972 -10.257  26.967  1.00 42.83           O  
ATOM   1642  CB  LEU A 298      -5.435  -7.618  26.611  1.00 43.71           C  
ATOM   1643  CG  LEU A 298      -4.383  -6.511  26.548  1.00 44.29           C  
ATOM   1644  CD1 LEU A 298      -5.004  -5.211  27.039  1.00 45.00           C  
ATOM   1645  CD2 LEU A 298      -3.182  -6.883  27.412  1.00 44.60           C  
ATOM   1646  N   HIS A 299      -5.120 -10.516  28.216  1.00 40.18           N  
ATOM   1647  CA  HIS A 299      -5.772 -11.397  29.171  1.00 38.96           C  
ATOM   1648  C   HIS A 299      -5.844 -10.619  30.484  1.00 38.48           C  
ATOM   1649  O   HIS A 299      -4.821 -10.362  31.129  1.00 35.84           O  
ATOM   1650  CB  HIS A 299      -4.971 -12.687  29.349  1.00 39.60           C  
ATOM   1651  CG  HIS A 299      -5.722 -13.765  30.067  1.00 41.94           C  
ATOM   1652  ND1 HIS A 299      -5.433 -14.143  31.361  1.00 42.57           N  
ATOM   1653  CD2 HIS A 299      -6.763 -14.537  29.674  1.00 41.52           C  
ATOM   1654  CE1 HIS A 299      -6.263 -15.100  31.734  1.00 42.15           C  
ATOM   1655  NE2 HIS A 299      -7.081 -15.357  30.730  1.00 42.22           N  
ATOM   1656  N   TRP A 300      -7.058 -10.234  30.869  1.00 36.41           N  
ATOM   1657  CA  TRP A 300      -7.260  -9.453  32.082  1.00 37.12           C  
ATOM   1658  C   TRP A 300      -7.213 -10.200  33.408  1.00 36.61           C  
ATOM   1659  O   TRP A 300      -7.648 -11.348  33.518  1.00 36.17           O  
ATOM   1660  CB  TRP A 300      -8.574  -8.668  31.991  1.00 36.30           C  
ATOM   1661  CG  TRP A 300      -8.504  -7.542  31.011  1.00 38.14           C  
ATOM   1662  CD1 TRP A 300      -8.766  -7.597  29.670  1.00 38.54           C  
ATOM   1663  CD2 TRP A 300      -8.099  -6.197  31.288  1.00 39.18           C  
ATOM   1664  NE1 TRP A 300      -8.546  -6.365  29.096  1.00 39.33           N  
ATOM   1665  CE2 TRP A 300      -8.138  -5.488  30.068  1.00 39.09           C  
ATOM   1666  CE3 TRP A 300      -7.703  -5.522  32.451  1.00 39.81           C  
ATOM   1667  CZ2 TRP A 300      -7.801  -4.135  29.976  1.00 40.68           C  
ATOM   1668  CZ3 TRP A 300      -7.365  -4.174  32.360  1.00 40.98           C  
ATOM   1669  CH2 TRP A 300      -7.418  -3.497  31.131  1.00 42.01           C  
ATOM   1670  N   MET A 301      -6.670  -9.509  34.408  1.00 36.87           N  
ATOM   1671  CA  MET A 301      -6.519 -10.008  35.770  1.00 38.01           C  
ATOM   1672  C   MET A 301      -7.201  -8.981  36.672  1.00 37.21           C  
ATOM   1673  O   MET A 301      -7.171  -7.786  36.387  1.00 35.03           O  
ATOM   1674  CB  MET A 301      -5.039 -10.068  36.158  1.00 41.12           C  
ATOM   1675  CG  MET A 301      -4.117 -10.747  35.157  1.00 47.64           C  
ATOM   1676  SD  MET A 301      -3.988 -12.516  35.415  1.00 50.20           S  
ATOM   1677  CE  MET A 301      -5.179 -13.091  34.228  1.00 51.44           C  
ATOM   1678  N   ASP A 302      -7.800  -9.443  37.764  1.00 37.62           N  
ATOM   1679  CA  ASP A 302      -8.471  -8.550  38.703  1.00 36.63           C  
ATOM   1680  C   ASP A 302      -7.527  -8.197  39.850  1.00 36.19           C  
ATOM   1681  O   ASP A 302      -7.041  -9.079  40.555  1.00 36.68           O  
ATOM   1682  CB  ASP A 302      -9.740  -9.222  39.239  1.00 38.36           C  
ATOM   1683  CG  ASP A 302     -10.396  -8.438  40.370  1.00 40.47           C  
ATOM   1684  OD1 ASP A 302     -10.158  -7.216  40.496  1.00 41.61           O  
ATOM   1685  OD2 ASP A 302     -11.172  -9.053  41.131  1.00 42.99           O  
ATOM   1686  N   SER A 303      -7.272  -6.904  40.027  1.00 36.03           N  
ATOM   1687  CA  SER A 303      -6.379  -6.425  41.078  1.00 36.77           C  
ATOM   1688  C   SER A 303      -6.748  -6.933  42.471  1.00 37.26           C  
ATOM   1689  O   SER A 303      -5.879  -7.098  43.325  1.00 38.23           O  
ATOM   1690  CB  SER A 303      -6.357  -4.891  41.103  1.00 36.62           C  
ATOM   1691  OG  SER A 303      -5.799  -4.352  39.917  1.00 34.93           O  
ATOM   1692  N   LEU A 304      -8.030  -7.186  42.699  1.00 36.09           N  
ATOM   1693  CA  LEU A 304      -8.476  -7.642  44.012  1.00 38.44           C  
ATOM   1694  C   LEU A 304      -8.509  -9.157  44.198  1.00 39.01           C  
ATOM   1695  O   LEU A 304      -8.927  -9.641  45.251  1.00 37.69           O  
ATOM   1696  CB  LEU A 304      -9.862  -7.069  44.314  1.00 38.78           C  
ATOM   1697  CG  LEU A 304      -9.997  -5.546  44.288  1.00 41.19           C  
ATOM   1698  CD1 LEU A 304     -11.451  -5.158  44.515  1.00 41.56           C  
ATOM   1699  CD2 LEU A 304      -9.096  -4.929  45.352  1.00 40.75           C  
ATOM   1700  N   ALA A 305      -8.071  -9.902  43.190  1.00 39.77           N  
ATOM   1701  CA  ALA A 305      -8.078 -11.362  43.268  1.00 40.09           C  
ATOM   1702  C   ALA A 305      -6.809 -11.913  43.910  1.00 41.33           C  
ATOM   1703  O   ALA A 305      -5.727 -11.346  43.760  1.00 41.10           O  
ATOM   1704  CB  ALA A 305      -8.254 -11.954  41.876  1.00 40.32           C  
ATOM   1705  N   GLY A 306      -6.945 -13.029  44.617  1.00 42.58           N  
ATOM   1706  CA  GLY A 306      -5.791 -13.631  45.263  1.00 44.41           C  
ATOM   1707  C   GLY A 306      -5.197 -14.800  44.494  1.00 44.69           C  
ATOM   1708  O   GLY A 306      -4.212 -15.400  44.928  1.00 45.83           O  
ATOM   1709  N   ASP A 307      -5.775 -15.126  43.344  1.00 45.31           N  
ATOM   1710  CA  ASP A 307      -5.278 -16.250  42.558  1.00 45.91           C  
ATOM   1711  C   ASP A 307      -4.842 -15.876  41.146  1.00 44.46           C  
ATOM   1712  O   ASP A 307      -5.086 -16.626  40.197  1.00 44.30           O  
ATOM   1713  CB  ASP A 307      -6.351 -17.343  42.492  1.00 49.04           C  
ATOM   1714  CG  ASP A 307      -7.621 -16.872  41.809  1.00 53.06           C  
ATOM   1715  OD1 ASP A 307      -8.141 -15.800  42.190  1.00 54.75           O  
ATOM   1716  OD2 ASP A 307      -8.103 -17.576  40.896  1.00 55.26           O  
ATOM   1717  N   ASN A 308      -4.185 -14.729  41.001  1.00 41.64           N  
ATOM   1718  CA  ASN A 308      -3.738 -14.299  39.683  1.00 40.44           C  
ATOM   1719  C   ASN A 308      -2.541 -15.083  39.165  1.00 39.59           C  
ATOM   1720  O   ASN A 308      -2.386 -15.253  37.958  1.00 39.65           O  
ATOM   1721  CB  ASN A 308      -3.420 -12.799  39.681  1.00 40.27           C  
ATOM   1722  CG  ASN A 308      -4.670 -11.945  39.750  1.00 41.10           C  
ATOM   1723  OD1 ASN A 308      -5.671 -12.243  39.100  1.00 41.23           O  
ATOM   1724  ND2 ASN A 308      -4.615 -10.868  40.527  1.00 39.32           N  
ATOM   1725  N   LEU A 309      -1.700 -15.573  40.071  1.00 40.03           N  
ATOM   1726  CA  LEU A 309      -0.528 -16.336  39.659  1.00 40.65           C  
ATOM   1727  C   LEU A 309      -0.930 -17.576  38.850  1.00 41.20           C  
ATOM   1728  O   LEU A 309      -0.475 -17.764  37.717  1.00 39.44           O  
ATOM   1729  CB  LEU A 309       0.307 -16.729  40.888  1.00 42.62           C  
ATOM   1730  CG  LEU A 309       1.690 -17.362  40.676  1.00 44.42           C  
ATOM   1731  CD1 LEU A 309       1.553 -18.827  40.320  1.00 47.44           C  
ATOM   1732  CD2 LEU A 309       2.439 -16.605  39.589  1.00 46.02           C  
ATOM   1733  N   PRO A 310      -1.797 -18.437  39.412  1.00 41.52           N  
ATOM   1734  CA  PRO A 310      -2.194 -19.627  38.652  1.00 41.54           C  
ATOM   1735  C   PRO A 310      -2.913 -19.290  37.346  1.00 42.27           C  
ATOM   1736  O   PRO A 310      -2.771 -19.997  36.350  1.00 41.74           O  
ATOM   1737  CB  PRO A 310      -3.081 -20.391  39.637  1.00 43.15           C  
ATOM   1738  CG  PRO A 310      -3.642 -19.307  40.512  1.00 43.59           C  
ATOM   1739  CD  PRO A 310      -2.441 -18.421  40.737  1.00 42.20           C  
ATOM   1740  N   ARG A 311      -3.679 -18.203  37.342  1.00 42.39           N  
ATOM   1741  CA  ARG A 311      -4.387 -17.816  36.129  1.00 42.80           C  
ATOM   1742  C   ARG A 311      -3.412 -17.349  35.050  1.00 41.08           C  
ATOM   1743  O   ARG A 311      -3.608 -17.618  33.862  1.00 39.98           O  
ATOM   1744  CB  ARG A 311      -5.407 -16.714  36.425  1.00 45.32           C  
ATOM   1745  CG  ARG A 311      -6.141 -16.236  35.183  1.00 50.52           C  
ATOM   1746  CD  ARG A 311      -7.523 -15.712  35.515  1.00 55.22           C  
ATOM   1747  NE  ARG A 311      -8.289 -15.428  34.306  1.00 58.81           N  
ATOM   1748  CZ  ARG A 311      -9.610 -15.297  34.271  1.00 61.43           C  
ATOM   1749  NH1 ARG A 311     -10.322 -15.425  35.387  1.00 62.47           N  
ATOM   1750  NH2 ARG A 311     -10.223 -15.043  33.121  1.00 61.81           N  
ATOM   1751  N   ALA A 312      -2.361 -16.648  35.465  1.00 39.22           N  
ATOM   1752  CA  ALA A 312      -1.362 -16.161  34.522  1.00 38.96           C  
ATOM   1753  C   ALA A 312      -0.585 -17.333  33.917  1.00 37.69           C  
ATOM   1754  O   ALA A 312      -0.333 -17.371  32.710  1.00 36.70           O  
ATOM   1755  CB  ALA A 312      -0.407 -15.198  35.219  1.00 38.52           C  
ATOM   1756  N   LEU A 313      -0.213 -18.291  34.757  1.00 37.41           N  
ATOM   1757  CA  LEU A 313       0.534 -19.452  34.290  1.00 38.68           C  
ATOM   1758  C   LEU A 313      -0.260 -20.252  33.261  1.00 40.15           C  
ATOM   1759  O   LEU A 313       0.300 -20.726  32.270  1.00 38.94           O  
ATOM   1760  CB  LEU A 313       0.924 -20.340  35.473  1.00 39.23           C  
ATOM   1761  CG  LEU A 313       1.906 -19.704  36.464  1.00 39.71           C  
ATOM   1762  CD1 LEU A 313       2.204 -20.680  37.590  1.00 41.84           C  
ATOM   1763  CD2 LEU A 313       3.194 -19.316  35.741  1.00 39.09           C  
ATOM   1764  N   ARG A 314      -1.564 -20.393  33.491  1.00 41.07           N  
ATOM   1765  CA  ARG A 314      -2.419 -21.128  32.566  1.00 41.59           C  
ATOM   1766  C   ARG A 314      -2.523 -20.403  31.230  1.00 41.15           C  
ATOM   1767  O   ARG A 314      -2.641 -21.035  30.178  1.00 40.15           O  
ATOM   1768  CB  ARG A 314      -3.827 -21.297  33.141  1.00 46.20           C  
ATOM   1769  CG  ARG A 314      -4.803 -21.898  32.142  1.00 50.43           C  
ATOM   1770  CD  ARG A 314      -6.233 -21.442  32.394  1.00 57.28           C  
ATOM   1771  NE  ARG A 314      -7.103 -21.764  31.263  1.00 61.46           N  
ATOM   1772  CZ  ARG A 314      -8.327 -21.271  31.092  1.00 63.28           C  
ATOM   1773  NH1 ARG A 314      -8.838 -20.426  31.980  1.00 64.06           N  
ATOM   1774  NH2 ARG A 314      -9.038 -21.615  30.024  1.00 64.03           N  
ATOM   1775  N   TYR A 315      -2.485 -19.074  31.269  1.00 39.74           N  
ATOM   1776  CA  TYR A 315      -2.587 -18.305  30.037  1.00 39.36           C  
ATOM   1777  C   TYR A 315      -1.380 -18.535  29.134  1.00 38.09           C  
ATOM   1778  O   TYR A 315      -1.510 -18.531  27.909  1.00 39.15           O  
ATOM   1779  CB  TYR A 315      -2.729 -16.812  30.331  1.00 38.35           C  
ATOM   1780  CG  TYR A 315      -2.963 -15.997  29.080  1.00 39.08           C  
ATOM   1781  CD1 TYR A 315      -4.088 -16.220  28.282  1.00 38.49           C  
ATOM   1782  CD2 TYR A 315      -2.049 -15.026  28.673  1.00 37.53           C  
ATOM   1783  CE1 TYR A 315      -4.295 -15.499  27.106  1.00 38.40           C  
ATOM   1784  CE2 TYR A 315      -2.247 -14.299  27.501  1.00 38.84           C  
ATOM   1785  CZ  TYR A 315      -3.372 -14.542  26.723  1.00 37.53           C  
ATOM   1786  OH  TYR A 315      -3.567 -13.839  25.558  1.00 37.92           O  
ATOM   1787  N   LEU A 316      -0.210 -18.733  29.734  1.00 37.17           N  
ATOM   1788  CA  LEU A 316       1.002 -18.975  28.955  1.00 37.67           C  
ATOM   1789  C   LEU A 316       0.791 -20.176  28.044  1.00 37.05           C  
ATOM   1790  O   LEU A 316       1.195 -20.166  26.878  1.00 35.74           O  
ATOM   1791  CB  LEU A 316       2.200 -19.238  29.874  1.00 37.81           C  
ATOM   1792  CG  LEU A 316       2.548 -18.123  30.866  1.00 40.98           C  
ATOM   1793  CD1 LEU A 316       3.859 -18.456  31.562  1.00 41.09           C  
ATOM   1794  CD2 LEU A 316       2.663 -16.792  30.136  1.00 41.68           C  
ATOM   1795  N   LYS A 317       0.154 -21.210  28.585  1.00 36.74           N  
ATOM   1796  CA  LYS A 317      -0.121 -22.415  27.822  1.00 38.13           C  
ATOM   1797  C   LYS A 317      -1.145 -22.099  26.745  1.00 37.83           C  
ATOM   1798  O   LYS A 317      -1.113 -22.679  25.661  1.00 37.33           O  
ATOM   1799  CB  LYS A 317      -0.645 -23.517  28.740  1.00 39.74           C  
ATOM   1800  CG  LYS A 317       0.359 -23.973  29.788  1.00 43.45           C  
ATOM   1801  CD  LYS A 317      -0.230 -25.058  30.673  1.00 46.33           C  
ATOM   1802  CE  LYS A 317       0.770 -25.540  31.707  1.00 49.24           C  
ATOM   1803  NZ  LYS A 317       0.207 -26.647  32.536  1.00 51.53           N  
ATOM   1804  N   THR A 318      -2.048 -21.172  27.048  1.00 38.22           N  
ATOM   1805  CA  THR A 318      -3.070 -20.775  26.089  1.00 40.23           C  
ATOM   1806  C   THR A 318      -2.403 -20.131  24.874  1.00 40.83           C  
ATOM   1807  O   THR A 318      -2.806 -20.364  23.734  1.00 41.42           O  
ATOM   1808  CB  THR A 318      -4.063 -19.759  26.709  1.00 40.93           C  
ATOM   1809  OG1 THR A 318      -4.760 -20.372  27.804  1.00 40.35           O  
ATOM   1810  CG2 THR A 318      -5.068 -19.291  25.669  1.00 41.43           C  
ATOM   1811  N   VAL A 319      -1.372 -19.331  25.129  1.00 39.96           N  
ATOM   1812  CA  VAL A 319      -0.649 -18.640  24.065  1.00 40.81           C  
ATOM   1813  C   VAL A 319       0.402 -19.546  23.432  1.00 39.89           C  
ATOM   1814  O   VAL A 319       1.210 -19.107  22.613  1.00 38.36           O  
ATOM   1815  CB  VAL A 319       0.043 -17.370  24.612  1.00 41.19           C  
ATOM   1816  CG1 VAL A 319       0.613 -16.545  23.465  1.00 44.29           C  
ATOM   1817  CG2 VAL A 319      -0.953 -16.548  25.404  1.00 44.98           C  
ATOM   1818  N   SER A 320       0.384 -20.815  23.824  1.00 38.73           N  
ATOM   1819  CA  SER A 320       1.316 -21.806  23.304  1.00 38.82           C  
ATOM   1820  C   SER A 320       2.760 -21.593  23.746  1.00 38.26           C  
ATOM   1821  O   SER A 320       3.682 -21.622  22.930  1.00 39.35           O  
ATOM   1822  CB  SER A 320       1.241 -21.860  21.774  1.00 39.36           C  
ATOM   1823  OG  SER A 320      -0.010 -22.379  21.351  1.00 36.37           O  
ATOM   1824  N   ILE A 321       2.940 -21.370  25.045  1.00 36.94           N  
ATOM   1825  CA  ILE A 321       4.265 -21.202  25.628  1.00 36.46           C  
ATOM   1826  C   ILE A 321       4.443 -22.283  26.687  1.00 36.54           C  
ATOM   1827  O   ILE A 321       3.742 -22.292  27.702  1.00 35.35           O  
ATOM   1828  CB  ILE A 321       4.447 -19.829  26.309  1.00 37.36           C  
ATOM   1829  CG1 ILE A 321       4.525 -18.721  25.254  1.00 37.11           C  
ATOM   1830  CG2 ILE A 321       5.710 -19.847  27.171  1.00 36.31           C  
ATOM   1831  CD1 ILE A 321       4.748 -17.333  25.839  1.00 36.74           C  
ATOM   1832  N   LEU A 322       5.381 -23.191  26.441  1.00 36.86           N  
ATOM   1833  CA  LEU A 322       5.658 -24.280  27.365  1.00 38.85           C  
ATOM   1834  C   LEU A 322       6.731 -23.848  28.354  1.00 41.96           C  
ATOM   1835  O   LEU A 322       7.864 -23.545  27.967  1.00 41.71           O  
ATOM   1836  CB  LEU A 322       6.118 -25.519  26.587  1.00 38.61           C  
ATOM   1837  CG  LEU A 322       6.266 -26.834  27.356  1.00 39.27           C  
ATOM   1838  CD1 LEU A 322       4.964 -27.160  28.092  1.00 39.34           C  
ATOM   1839  CD2 LEU A 322       6.617 -27.948  26.379  1.00 37.23           C  
ATOM   1840  N   ALA A 323       6.355 -23.814  29.629  1.00 46.03           N  
ATOM   1841  CA  ALA A 323       7.243 -23.412  30.714  1.00 49.79           C  
ATOM   1842  C   ALA A 323       7.732 -21.984  30.518  1.00 51.70           C  
ATOM   1843  O   ALA A 323       7.306 -21.343  29.534  1.00 53.68           O  
ATOM   1844  CB  ALA A 323       8.426 -24.366  30.810  1.00 51.39           C  
ATOM   1845  OXT ALA A 323       8.533 -21.519  31.356  1.00 54.86           O  
TER    1846      ALA A 323                                                      
END
MOLECULE T0416_6_115_194_315.pdb
ATOM      1  N   LYS     6       9.770 -16.706  17.344  1.00 47.34          
ATOM      2  CA  LYS     6       9.686 -15.469  18.171  1.00 47.92          
ATOM      3  C   LYS     6       9.964 -15.789  19.633  1.00 48.21          
ATOM      4  O   LYS     6       9.492 -16.801  20.167  1.00 48.06          
ATOM      5  CB  LYS     6       8.296 -14.851  18.062  1.00 48.33          
ATOM      6  CG  LYS     6       7.859 -14.572  16.663  1.00 51.47          
ATOM      7  CD  LYS     6       6.355 -14.397  16.582  1.00 55.16          
ATOM      8  CE  LYS     6       5.919 -14.283  15.119  1.00 58.23          
ATOM      9  NZ  LYS     6       4.444 -14.137  14.929  1.00 59.84          
ATOM     10  N   PRO     7      10.743 -14.930  20.304  1.00 47.62          
ATOM     11  CA  PRO     7      11.079 -15.125  21.721  1.00 47.47          
ATOM     12  C   PRO     7       9.897 -14.902  22.682  1.00 46.63          
ATOM     13  O   PRO     7       9.082 -13.993  22.493  1.00 46.51          
ATOM     14  CB  PRO     7      12.203 -14.114  21.955  1.00 48.11          
ATOM     15  CG  PRO     7      11.877 -13.021  20.986  1.00 48.00          
ATOM     16  CD  PRO     7      11.471 -13.782  19.741  1.00 46.88          
ATOM     17  N   PHE     8       9.814 -15.737  23.715  1.00 44.40          
ATOM     18  CA  PHE     8       8.747 -15.622  24.697  1.00 41.95          
ATOM     19  C   PHE     8       8.958 -14.388  25.566  1.00 40.54          
ATOM     20  O   PHE     8      10.068 -14.136  26.041  1.00 40.58          
ATOM     21  CB  PHE     8       8.694 -16.865  25.591  1.00 41.58          
ATOM     22  CG  PHE     8       7.522 -16.884  26.531  1.00 41.07          
ATOM     23  CD1 PHE     8       6.222 -16.919  26.036  1.00 42.79          
ATOM     24  CD2 PHE     8       7.707 -16.854  27.901  1.00 39.99          
ATOM     25  CE1 PHE     8       5.122 -16.927  26.895  1.00 42.19          
ATOM     26  CE2 PHE     8       6.611 -16.863  28.767  1.00 41.03          
ATOM     27  CZ  PHE     8       5.315 -16.899  28.253  1.00 40.90          
ATOM     28  N   LEU     9       7.881 -13.631  25.767  1.00 38.04          
ATOM     29  CA  LEU     9       7.915 -12.418  26.583  1.00 36.38          
ATOM     30  C   LEU     9       6.629 -12.238  27.393  1.00 35.98          
ATOM     31  O   LEU     9       5.542 -12.412  26.847  1.00 37.94          
ATOM     32  CB  LEU     9       8.085 -11.198  25.687  1.00 33.92          
ATOM     33  CG  LEU     9       8.128  -9.872  26.431  1.00 31.31          
ATOM     34  CD1 LEU     9       9.465  -9.700  27.105  1.00 30.33          
ATOM     35  CD2 LEU     9       7.901  -8.759  25.453  1.00 32.13          
ATOM     36  N   ILE    10       6.742 -11.899  28.680  1.00 34.13          
ATOM     37  CA  ILE    10       5.554 -11.660  29.516  1.00 33.61          
ATOM     38  C   ILE    10       5.402 -10.159  29.661  1.00 32.88          
ATOM     39  O   ILE    10       6.389  -9.457  29.867  1.00 32.89          
ATOM     40  CB  ILE    10       5.671 -12.221  30.978  1.00 34.19          
ATOM     41  CG1 ILE    10       5.795 -13.745  30.994  1.00 34.92          
ATOM     42  CG2 ILE    10       4.410 -11.875  31.762  1.00 32.53          
ATOM     43  CD  ILE    10       4.537 -14.446  30.557  1.00 35.17          
ATOM     44  N   VAL    11       4.179  -9.656  29.545  1.00 32.25          
ATOM     45  CA  VAL    11       3.953  -8.211  29.699  1.00 33.18          
ATOM     46  C   VAL    11       2.799  -7.993  30.705  1.00 33.37          
ATOM     47  O   VAL    11       1.670  -8.456  30.494  1.00 33.93          
ATOM     48  CB  VAL    11       3.605  -7.524  28.325  1.00 31.73          
ATOM     49  CG1 VAL    11       3.619  -6.017  28.467  1.00 30.56          
ATOM     50  CG2 VAL    11       4.587  -7.943  27.263  1.00 29.73          
ATOM     51  N   ILE    12       3.091  -7.290  31.797  1.00 31.84          
ATOM     52  CA  ILE    12       2.106  -7.032  32.842  1.00 30.80          
ATOM     53  C   ILE    12       1.866  -5.536  33.017  1.00 31.11          
ATOM     54  O   ILE    12       2.624  -4.849  33.708  1.00 30.46          
ATOM     55  CB  ILE    12       2.569  -7.632  34.189  1.00 29.53          
ATOM     56  CG1 ILE    12       2.895  -9.114  33.996  1.00 29.86          
ATOM     57  CG2 ILE    12       1.478  -7.487  35.230  1.00 30.33          
ATOM     58  CD  ILE    12       3.522  -9.776  35.203  1.00 26.96          
ATOM     59  N   VAL    13       0.808  -5.035  32.383  1.00 30.72          
ATOM     60  CA  VAL    13       0.466  -3.620  32.457  1.00 29.94          
ATOM     61  C   VAL    13      -0.652  -3.426  33.452  1.00 29.66          
ATOM     62  O   VAL    13      -1.336  -4.374  33.801  1.00 30.84          
ATOM     63  CB  VAL    13      -0.002  -3.077  31.090  1.00 29.53          
ATOM     64  CG1 VAL    13       1.132  -3.140  30.075  1.00 29.05          
ATOM     65  CG2 VAL    13      -1.188  -3.876  30.601  1.00 28.45          
ATOM     66  N   GLY    14      -0.839  -2.199  33.909  1.00 30.29          
ATOM     67  CA  GLY    14      -1.889  -1.938  34.871  1.00 31.58          
ATOM     68  C   GLY    14      -1.642  -0.598  35.525  1.00 32.22          
ATOM     69  O   GLY    14      -0.521  -0.108  35.523  1.00 31.01          
ATOM     70  N   PRO    15      -2.677   0.021  36.103  1.00 33.98          
ATOM     71  CA  PRO    15      -2.483   1.323  36.744  1.00 35.35          
ATOM     72  C   PRO    15      -1.478   1.279  37.893  1.00 36.07          
ATOM     73  O   PRO    15      -1.230   0.218  38.457  1.00 36.01          
ATOM     74  CB  PRO    15      -3.897   1.696  37.187  1.00 34.89          
ATOM     75  CG  PRO    15      -4.545   0.365  37.419  1.00 34.89          
ATOM     76  CD  PRO    15      -4.070  -0.442  36.245  1.00 35.07          
ATOM     77  N   THR    16      -0.891   2.431  38.211  1.00 36.66          
ATOM     78  CA  THR    16       0.089   2.538  39.286  1.00 38.58          
ATOM     79  C   THR    16      -0.373   1.853  40.573  1.00 40.27          
ATOM     80  O   THR    16      -1.523   2.001  40.989  1.00 40.98          
ATOM     81  CB  THR    16       0.385   3.997  39.643  1.00 37.33          
ATOM     82  OG1 THR    16       0.786   4.705  38.474  1.00 36.77          
ATOM     83  CG2 THR    16       1.495   4.061  40.671  1.00 38.23          
ATOM     84  N   ALA    17       0.536   1.118  41.208  1.00 40.72          
ATOM     85  CA  ALA    17       0.219   0.417  42.443  1.00 42.57          
ATOM     86  C   ALA    17      -1.083  -0.378  42.324  1.00 43.15          
ATOM     87  O   ALA    17      -2.011  -0.205  43.123  1.00 43.42          
ATOM     88  CB  ALA    17       0.109   1.412  43.597  1.00 43.65          
ATOM     89  N   SER    18      -1.159  -1.238  41.317  1.00 42.43          
ATOM     90  CA  SER    18      -2.344  -2.051  41.119  1.00 40.61          
ATOM     91  C   SER    18      -1.921  -3.495  41.298  1.00 40.77          
ATOM     92  O   SER    18      -2.693  -4.424  41.054  1.00 42.04          
ATOM     93  CB  SER    18      -2.892  -1.870  39.719  1.00 38.47          
ATOM     94  OG  SER    18      -2.013  -2.466  38.804  1.00 36.84          
ATOM     95  N   GLY    19      -0.681  -3.681  41.730  1.00 40.01          
ATOM     96  CA  GLY    19      -0.170  -5.026  41.920  1.00 40.03          
ATOM     97  C   GLY    19       0.645  -5.548  40.744  1.00 38.18          
ATOM     98  O   GLY    19       1.235  -6.625  40.806  1.00 38.21          
ATOM     99  N   LYS    20       0.684  -4.791  39.660  1.00 36.98          
ATOM    100  CA  LYS    20       1.444  -5.241  38.522  1.00 35.89          
ATOM    101  C   LYS    20       2.908  -5.443  38.936  1.00 36.34          
ATOM    102  O   LYS    20       3.527  -6.452  38.590  1.00 37.13          
ATOM    103  CB  LYS    20       1.330  -4.248  37.362  1.00 33.94          
ATOM    104  CG  LYS    20       1.849  -2.871  37.685  1.00 32.57          
ATOM    105  CD  LYS    20       1.824  -1.935  36.498  1.00 29.33          
ATOM    106  CE  LYS    20       2.436  -0.614  36.924  1.00 31.07          
ATOM    107  NZ  LYS    20       2.250   0.476  35.923  1.00 35.59          
ATOM    108  N   THR    21       3.455  -4.511  39.705  1.00 35.70          
ATOM    109  CA  THR    21       4.840  -4.619  40.147  1.00 35.75          
ATOM    110  C   THR    21       5.079  -5.838  41.024  1.00 35.78          
ATOM    111  O   THR    21       6.054  -6.572  40.832  1.00 35.67          
ATOM    112  CB  THR    21       5.269  -3.372  40.918  1.00 36.24          
ATOM    113  OG1 THR    21       5.065  -2.221  40.090  1.00 38.69          
ATOM    114  CG2 THR    21       6.742  -3.464  41.302  1.00 36.35          
ATOM    115  N   GLU    22       4.197  -6.056  41.989  1.00 35.56          
ATOM    116  CA  GLU    22       4.326  -7.196  42.879  1.00 36.42          
ATOM    117  C   GLU    22       4.155  -8.475  42.073  1.00 35.88          
ATOM    118  O   GLU    22       4.979  -9.381  42.161  1.00 37.29          
ATOM    119  CB  GLU    22       3.271  -7.119  43.984  1.00 39.34          
ATOM    120  CG  GLU    22       3.439  -5.935  44.935  1.00 43.60          
ATOM    121  CD  GLU    22       3.007  -4.586  44.343  1.00 45.57          
ATOM    122  OE1 GLU    22       3.218  -3.557  45.018  1.00 48.08          
ATOM    123  OE2 GLU    22       2.457  -4.544  43.224  1.00 46.06          
ATOM    124  N   LEU    23       3.090  -8.539  41.276  1.00 34.58          
ATOM    125  CA  LEU    23       2.826  -9.704  40.445  1.00 32.10          
ATOM    126  C   LEU    23       4.039 -10.051  39.576  1.00 31.09          
ATOM    127  O   LEU    23       4.403 -11.217  39.458  1.00 27.98          
ATOM    128  CB  LEU    23       1.599  -9.455  39.558  1.00 30.74          
ATOM    129  CG  LEU    23       1.222 -10.580  38.579  1.00 28.65          
ATOM    130  CD1 LEU    23       0.822 -11.814  39.341  1.00 28.78          
ATOM    131  CD2 LEU    23       0.098 -10.121  37.709  1.00 27.36          
ATOM    132  N   SER    24       4.663  -9.040  38.973  1.00 32.29          
ATOM    133  CA  SER    24       5.842  -9.271  38.129  1.00 34.51          
ATOM    134  C   SER    24       6.915 -10.040  38.890  1.00 34.30          
ATOM    135  O   SER    24       7.439 -11.030  38.403  1.00 35.07          
ATOM    136  CB  SER    24       6.445  -7.954  37.634  1.00 35.30          
ATOM    137  OG  SER    24       5.598  -7.333  36.691  1.00 39.93          
ATOM    138  N   ILE    25       7.237  -9.584  40.089  1.00 33.62          
ATOM    139  CA  ILE    25       8.251 -10.244  40.876  1.00 33.95          
ATOM    140  C   ILE    25       7.850 -11.690  41.196  1.00 35.37          
ATOM    141  O   ILE    25       8.677 -12.608  41.097  1.00 35.34          
ATOM    142  CB  ILE    25       8.529  -9.434  42.163  1.00 32.96          
ATOM    143  CG1 ILE    25       9.066  -8.055  41.768  1.00 30.36          
ATOM    144  CG2 ILE    25       9.512 -10.154  43.053  1.00 31.35          
ATOM    145  CD  ILE    25       9.495  -7.203  42.916  1.00 28.44          
ATOM    146  N   GLU    26       6.586 -11.909  41.554  1.00 36.42          
ATOM    147  CA  GLU    26       6.106 -13.262  41.869  1.00 38.00          
ATOM    148  C   GLU    26       6.267 -14.202  40.671  1.00 37.34          
ATOM    149  O   GLU    26       6.623 -15.369  40.836  1.00 37.59          
ATOM    150  CB  GLU    26       4.635 -13.220  42.317  1.00 39.45          
ATOM    151  CG  GLU    26       4.434 -12.560  43.690  1.00 44.45          
ATOM    152  CD  GLU    26       5.131 -13.307  44.839  1.00 47.76          
ATOM    153  OE1 GLU    26       4.635 -14.390  45.253  1.00 48.13          
ATOM    154  OE2 GLU    26       6.188 -12.815  45.322  1.00 48.16          
ATOM    155  N   VAL    27       6.001 -13.683  39.473  1.00 36.34          
ATOM    156  CA  VAL    27       6.141 -14.460  38.248  1.00 34.75          
ATOM    157  C   VAL    27       7.627 -14.683  37.994  1.00 35.06          
ATOM    158  O   VAL    27       8.044 -15.752  37.567  1.00 34.96          
ATOM    159  CB  VAL    27       5.549 -13.714  37.055  1.00 31.86          
ATOM    160  CG1 VAL    27       5.834 -14.462  35.783  1.00 29.36          
ATOM    161  CG2 VAL    27       4.072 -13.543  37.255  1.00 31.53          
ATOM    162  N   ALA    28       8.419 -13.657  38.275  1.00 35.66          
ATOM    163  CA  ALA    28       9.849 -13.720  38.085  1.00 36.34          
ATOM    164  C   ALA    28      10.465 -14.753  39.009  1.00 38.34          
ATOM    165  O   ALA    28      11.452 -15.406  38.660  1.00 39.44          
ATOM    166  CB  ALA    28      10.464 -12.368  38.340  1.00 36.23          
ATOM    167  N   LYS    29       9.889 -14.910  40.194  1.00 39.77          
ATOM    168  CA  LYS    29      10.408 -15.880  41.146  1.00 40.39          
ATOM    169  C   LYS    29       9.949 -17.299  40.859  1.00 40.52          
ATOM    170  O   LYS    29      10.622 -18.239  41.252  1.00 41.59          
ATOM    171  CB  LYS    29      10.006 -15.511  42.574  1.00 40.53          
ATOM    172  CG  LYS    29      10.744 -14.316  43.150  1.00 41.23          
ATOM    173  CD  LYS    29      10.663 -14.309  44.681  1.00 44.42          
ATOM    174  CE  LYS    29       9.211 -14.279  45.195  1.00 44.59          
ATOM    175  NZ  LYS    29       9.113 -14.333  46.690  1.00 43.59          
ATOM    176  N   LYS    30       8.816 -17.465  40.186  1.00 40.21          
ATOM    177  CA  LYS    30       8.337 -18.806  39.901  1.00 41.59          
ATOM    178  C   LYS    30       8.884 -19.327  38.571  1.00 43.51          
ATOM    179  O   LYS    30       8.861 -20.529  38.327  1.00 43.62          
ATOM    180  CB  LYS    30       6.801 -18.834  39.902  1.00 42.72          
ATOM    181  CG  LYS    30       6.171 -20.223  39.924  1.00 43.38          
ATOM    182  CD  LYS    30       4.653 -20.122  39.904  1.00 45.84          
ATOM    183  CE  LYS    30       3.983 -21.471  40.139  1.00 47.92          
ATOM    184  NZ  LYS    30       2.499 -21.323  40.293  1.00 50.92          
ATOM    185  N   PHE    31       9.388 -18.430  37.721  1.00 44.17          
ATOM    186  CA  PHE    31       9.940 -18.814  36.419  1.00 44.51          
ATOM    187  C   PHE    31      11.289 -18.170  36.195  1.00 45.33          
ATOM    188  O   PHE    31      11.634 -17.818  35.068  1.00 45.02          
ATOM    189  CB  PHE    31       8.991 -18.398  35.307  1.00 44.39          
ATOM    190  CG  PHE    31       7.643 -19.013  35.427  1.00 45.82          
ATOM    191  CD1 PHE    31       7.406 -20.293  34.943  1.00 47.34          
ATOM    192  CD2 PHE    31       6.620 -18.344  36.087  1.00 46.46          
ATOM    193  CE1 PHE    31       6.160 -20.904  35.118  1.00 48.67          
ATOM    194  CE2 PHE    31       5.371 -18.940  36.271  1.00 47.96          
ATOM    195  CZ  PHE    31       5.137 -20.224  35.787  1.00 48.48          
ATOM    196  N   ASN    32      12.050 -18.044  37.282  1.00 47.84          
ATOM    197  CA  ASN    32      13.382 -17.419  37.295  1.00 49.84          
ATOM    198  C   ASN    32      13.603 -16.505  36.095  1.00 49.50          
ATOM    199  O   ASN    32      14.394 -16.794  35.191  1.00 50.98          
ATOM    200  CB  ASN    32      14.500 -18.479  37.383  1.00 51.79          
ATOM    201  CG  ASN    32      14.698 -19.234  36.078  1.00 54.42          
ATOM    202  OD1 ASN    32      13.726 -19.668  35.450  1.00 56.40          
ATOM    203  ND2 ASN    32      15.954 -19.411  35.670  1.00 55.03          
ATOM    204  N   GLY    33      12.871 -15.398  36.096  1.00 47.07          
ATOM    205  CA  GLY    33      12.994 -14.433  35.027  1.00 44.42          
ATOM    206  C   GLY    33      13.567 -13.138  35.566  1.00 42.58          
ATOM    207  O   GLY    33      13.970 -13.059  36.725  1.00 41.73          
ATOM    208  N   GLU    34      13.620 -12.124  34.711  1.00 41.54          
ATOM    209  CA  GLU    34      14.122 -10.821  35.099  1.00 39.53          
ATOM    210  C   GLU    34      13.166  -9.801  34.512  1.00 38.04          
ATOM    211  O   GLU    34      12.592 -10.005  33.440  1.00 36.36          
ATOM    212  CB  GLU    34      15.537 -10.613  34.582  1.00 39.38          
ATOM    213  CG  GLU    34      16.453 -11.766  34.939  1.00 40.36          
ATOM    214  CD  GLU    34      17.877 -11.540  34.490  1.00 41.95          
ATOM    215  OE1 GLU    34      18.066 -10.907  33.422  1.00 43.40          
ATOM    216  OE2 GLU    34      18.814 -12.009  35.185  1.00 40.07          
ATOM    217  N   ILE    35      13.008  -8.695  35.222  1.00 37.64          
ATOM    218  CA  ILE    35      12.066  -7.665  34.828  1.00 37.78          
ATOM    219  C   ILE    35      12.679  -6.440  34.183  1.00 37.21          
ATOM    220  O   ILE    35      13.723  -5.963  34.602  1.00 37.93          
ATOM    221  CB  ILE    35      11.252  -7.203  36.064  1.00 37.03          
ATOM    222  CG1 ILE    35      10.621  -8.415  36.738  1.00 36.19          
ATOM    223  CG2 ILE    35      10.186  -6.211  35.656  1.00 37.14          
ATOM    224  CD  ILE    35       9.858  -8.090  37.952  1.00 35.95          
ATOM    225  N   ILE    36      12.003  -5.926  33.166  1.00 37.04          
ATOM    226  CA  ILE    36      12.438  -4.716  32.496  1.00 36.12          
ATOM    227  C   ILE    36      11.354  -3.669  32.787  1.00 37.69          
ATOM    228  O   ILE    36      10.207  -3.833  32.380  1.00 38.12          
ATOM    229  CB  ILE    36      12.548  -4.928  30.981  1.00 33.73          
ATOM    230  CG1 ILE    36      13.667  -5.921  30.678  1.00 31.77          
ATOM    231  CG2 ILE    36      12.795  -3.610  30.292  1.00 31.97          
ATOM    232  CD  ILE    36      13.730  -6.342  29.233  1.00 26.96          
ATOM    233  N   SER    37      11.709  -2.610  33.506  1.00 37.83          
ATOM    234  CA  SER    37      10.744  -1.571  33.829  1.00 37.74          
ATOM    235  C   SER    37      10.202  -0.918  32.553  1.00 37.95          
ATOM    236  O   SER    37      10.969  -0.487  31.692  1.00 37.35          
ATOM    237  CB  SER    37      11.403  -0.535  34.740  1.00 36.72          
ATOM    238  OG  SER    37      10.688   0.680  34.738  1.00 36.77          
ATOM    239  N   GLY    38       8.874  -0.871  32.426  1.00 38.61          
ATOM    240  CA  GLY    38       8.253  -0.268  31.252  1.00 39.20          
ATOM    241  C   GLY    38       7.872   1.183  31.485  1.00 41.13          
ATOM    242  O   GLY    38       7.455   1.899  30.565  1.00 39.58          
ATOM    243  N   ASP    39       8.020   1.615  32.734  1.00 42.10          
ATOM    244  CA  ASP    39       7.694   2.977  33.129  1.00 44.59          
ATOM    245  C   ASP    39       8.674   3.991  32.530  1.00 45.44          
ATOM    246  O   ASP    39       9.884   3.849  32.665  1.00 46.29          
ATOM    247  CB  ASP    39       7.719   3.090  34.648  1.00 46.64          
ATOM    248  CG  ASP    39       7.028   4.342  35.149  1.00 49.62          
ATOM    249  OD1 ASP    39       7.453   5.452  34.775  1.00 51.11          
ATOM    250  OD2 ASP    39       6.046   4.214  35.915  1.00 52.78          
ATOM    251  N   SER    40       8.149   5.028  31.890  1.00 45.73          
ATOM    252  CA  SER    40       9.007   6.038  31.286  1.00 46.96          
ATOM    253  C   SER    40       9.523   7.073  32.276  1.00 47.74          
ATOM    254  O   SER    40      10.194   8.033  31.886  1.00 47.33          
ATOM    255  CB  SER    40       8.276   6.763  30.142  1.00 46.76          
ATOM    256  OG  SER    40       7.151   7.504  30.591  1.00 44.02          
ATOM    257  N   MET    41       9.212   6.894  33.554  1.00 49.05          
ATOM    258  CA  MET    41       9.645   7.852  34.575  1.00 50.21          
ATOM    259  C   MET    41      10.623   7.277  35.575  1.00 48.79          
ATOM    260  O   MET    41      11.443   7.998  36.156  1.00 48.16          
ATOM    261  CB  MET    41       8.430   8.401  35.322  1.00 54.92          
ATOM    262  CG  MET    41       7.630   9.422  34.534  1.00 60.15          
ATOM    263  SD  MET    41       8.726  10.939  33.973  1.00 69.60          
ATOM    264  CE  MET    41       9.133  11.711  35.709  1.00 65.89          
ATOM    265  N   GLN    42      10.521   5.967  35.778  1.00 47.21          
ATOM    266  CA  GLN    42      11.387   5.258  36.710  1.00 44.79          
ATOM    267  C   GLN    42      12.805   5.173  36.162  1.00 43.38          
ATOM    268  O   GLN    42      13.702   4.659  36.822  1.00 42.91          
ATOM    269  CB  GLN    42      10.808   3.867  36.988  1.00 44.81          
ATOM    270  CG  GLN    42       9.722   3.895  38.074  1.00 45.40          
ATOM    271  CD  GLN    42       9.045   2.552  38.305  1.00 46.04          
ATOM    272  OE1 GLN    42       9.697   1.498  38.352  1.00 47.48          
ATOM    273  NE2 GLN    42       7.731   2.587  38.483  1.00 45.63          
ATOM    274  N   VAL    43      13.002   5.709  34.960  1.00 41.63          
ATOM    275  CA  VAL    43      14.308   5.709  34.338  1.00 39.69          
ATOM    276  C   VAL    43      15.179   6.815  34.916  1.00 39.24          
ATOM    277  O   VAL    43      16.398   6.742  34.848  1.00 39.12          
ATOM    278  CB  VAL    43      14.194   5.913  32.814  1.00 40.00          
ATOM    279  CG1 VAL    43      13.727   4.629  32.143  1.00 39.83          
ATOM    280  CG2 VAL    43      13.216   7.035  32.519  1.00 37.24          
ATOM    281  N   TYR    44      14.547   7.831  35.496  1.00 39.65          
ATOM    282  CA  TYR    44      15.278   8.961  36.069  1.00 40.32          
ATOM    283  C   TYR    44      15.685   8.755  37.538  1.00 42.44          
ATOM    284  O   TYR    44      14.876   8.359  38.372  1.00 42.07          
ATOM    285  CB  TYR    44      14.450  10.236  35.952  1.00 39.33          
ATOM    286  CG  TYR    44      14.102  10.623  34.536  1.00 40.85          
ATOM    287  CD1 TYR    44      15.075  11.124  33.664  1.00 40.75          
ATOM    288  CD2 TYR    44      12.798  10.482  34.059  1.00 40.46          
ATOM    289  CE1 TYR    44      14.750  11.471  32.350  1.00 41.84          
ATOM    290  CE2 TYR    44      12.467  10.829  32.753  1.00 41.49          
ATOM    291  CZ  TYR    44      13.437  11.319  31.901  1.00 42.05          
ATOM    292  OH  TYR    44      13.093  11.647  30.599  1.00 42.46          
ATOM    293  N   GLN    45      16.945   9.042  37.847  1.00 43.92          
ATOM    294  CA  GLN    45      17.452   8.884  39.196  1.00 46.34          
ATOM    295  C   GLN    45      17.102  10.118  40.029  1.00 47.78          
ATOM    296  O   GLN    45      17.187  11.249  39.548  1.00 47.56          
ATOM    297  CB  GLN    45      18.965   8.648  39.145  1.00 47.12          
ATOM    298  CG  GLN    45      19.690   9.695  38.307  1.00 50.07          
ATOM    299  CD  GLN    45      20.942   9.167  37.622  1.00 50.58          
ATOM    300  OE1 GLN    45      20.898   8.142  36.937  1.00 50.72          
ATOM    301  NE2 GLN    45      22.057   9.879  37.783  1.00 49.70          
ATOM    302  N   GLY    46      16.685   9.896  41.274  1.00 48.21          
ATOM    303  CA  GLY    46      16.318  11.011  42.135  1.00 49.37          
ATOM    304  C   GLY    46      14.813  11.171  42.212  1.00 50.77          
ATOM    305  O   GLY    46      14.273  11.756  43.159  1.00 49.20          
ATOM    306  N   MET    47      14.137  10.648  41.193  1.00 52.76          
ATOM    307  CA  MET    47      12.685  10.704  41.117  1.00 54.61          
ATOM    308  C   MET    47      12.150   9.309  41.425  1.00 53.36          
ATOM    309  O   MET    47      11.777   8.565  40.523  1.00 53.21          
ATOM    310  CB  MET    47      12.261  11.145  39.723  1.00 56.82          
ATOM    311  CG  MET    47      13.015  12.367  39.261  1.00 61.64          
ATOM    312  SD  MET    47      12.390  13.007  37.567  1.00 70.25          
ATOM    313  CE  MET    47      11.239  14.436  38.153  1.00 69.01          
ATOM    314  N   ASP    48      12.109   8.969  42.713  1.00 52.63          
ATOM    315  CA  ASP    48      11.651   7.657  43.149  1.00 51.41          
ATOM    316  C   ASP    48      10.236   7.640  43.742  1.00 49.19          
ATOM    317  O   ASP    48       9.437   6.753  43.438  1.00 48.61          
ATOM    318  CB  ASP    48      12.644   7.074  44.166  1.00 52.25          
ATOM    319  CG  ASP    48      14.094   7.486  43.887  1.00 52.83          
ATOM    320  OD1 ASP    48      14.559   7.391  42.724  1.00 52.86          
ATOM    321  OD2 ASP    48      14.782   7.901  44.845  1.00 52.66          
ATOM    322  N   ILE    49       9.924   8.620  44.578  1.00 46.94          
ATOM    323  CA  ILE    49       8.617   8.680  45.210  1.00 45.38          
ATOM    324  C   ILE    49       7.471   9.008  44.261  1.00 43.66          
ATOM    325  O   ILE    49       6.463   8.309  44.243  1.00 43.49          
ATOM    326  CB  ILE    49       8.618   9.712  46.353  1.00 45.88          
ATOM    327  CG1 ILE    49       9.599   9.276  47.434  1.00 44.79          
ATOM    328  CG2 ILE    49       7.206   9.873  46.912  1.00 46.48          
ATOM    329  CD  ILE    49       9.745  10.265  48.557  1.00 47.30          
ATOM    330  N   GLY    50       7.617  10.070  43.479  1.00 42.05          
ATOM    331  CA  GLY    50       6.546  10.454  42.569  1.00 41.84          
ATOM    332  C   GLY    50       6.304   9.495  41.416  1.00 39.86          
ATOM    333  O   GLY    50       5.323   9.614  40.685  1.00 38.30          
ATOM    334  N   THR    51       7.185   8.522  41.268  1.00 38.59          
ATOM    335  CA  THR    51       7.065   7.593  40.177  1.00 39.16          
ATOM    336  C   THR    51       6.732   6.186  40.632  1.00 39.81          
ATOM    337  O   THR    51       6.650   5.269  39.811  1.00 40.79          
ATOM    338  CB  THR    51       8.364   7.555  39.405  1.00 39.85          
ATOM    339  OG1 THR    51       9.419   7.139  40.288  1.00 39.12          
ATOM    340  CG2 THR    51       8.684   8.950  38.852  1.00 39.88          
ATOM    341  N   ALA    52       6.545   6.017  41.939  1.00 39.14          
ATOM    342  CA  ALA    52       6.226   4.717  42.538  1.00 37.57          
ATOM    343  C   ALA    52       7.338   3.724  42.226  1.00 38.14          
ATOM    344  O   ALA    52       7.094   2.532  42.036  1.00 37.54          
ATOM    345  CB  ALA    52       4.886   4.200  42.022  1.00 35.81          
ATOM    346  N   LYS    53       8.565   4.235  42.181  1.00 40.06          
ATOM    347  CA  LYS    53       9.741   3.420  41.888  1.00 42.16          
ATOM    348  C   LYS    53       9.989   2.345  42.939  1.00 42.20          
ATOM    349  O   LYS    53      10.161   2.651  44.121  1.00 42.30          
ATOM    350  CB  LYS    53      10.978   4.311  41.782  1.00 42.37          
ATOM    351  CG  LYS    53      12.272   3.549  41.536  1.00 42.48          
ATOM    352  CD  LYS    53      13.408   4.512  41.341  1.00 41.69          
ATOM    353  CE  LYS    53      13.132   5.409  40.152  1.00 42.68          
ATOM    354  NZ  LYS    53      14.081   6.557  40.102  1.00 44.19          
ATOM    355  N   VAL    54      10.027   1.089  42.498  1.00 42.43          
ATOM    356  CA  VAL    54      10.262  -0.040  43.395  1.00 42.54          
ATOM    357  C   VAL    54      11.678  -0.002  43.960  1.00 42.74          
ATOM    358  O   VAL    54      12.640   0.289  43.238  1.00 42.21          
ATOM    359  CB  VAL    54      10.024  -1.382  42.660  1.00 43.26          
ATOM    360  CG1 VAL    54      10.765  -1.401  41.325  1.00 43.42          
ATOM    361  CG2 VAL    54      10.471  -2.525  43.538  1.00 44.75          
ATOM    362  N   THR    55      11.810  -0.291  45.250  1.00 41.88          
ATOM    363  CA  THR    55      13.120  -0.254  45.891  1.00 42.17          
ATOM    364  C   THR    55      13.915  -1.537  45.748  1.00 40.91          
ATOM    365  O   THR    55      13.357  -2.611  45.534  1.00 37.85          
ATOM    366  CB  THR    55      12.999   0.093  47.397  1.00 42.92          
ATOM    367  OG1 THR    55      12.447  -1.019  48.126  1.00 45.00          
ATOM    368  CG2 THR    55      12.105   1.306  47.580  1.00 44.24          
ATOM    369  N   THR    56      15.233  -1.406  45.856  1.00 42.43          
ATOM    370  CA  THR    56      16.114  -2.557  45.731  1.00 44.85          
ATOM    371  C   THR    56      15.630  -3.688  46.640  1.00 45.98          
ATOM    372  O   THR    56      15.676  -4.852  46.262  1.00 46.23          
ATOM    373  CB  THR    56      17.581  -2.218  46.109  1.00 44.96          
ATOM    374  OG1 THR    56      17.663  -1.947  47.513  1.00 47.28          
ATOM    375  CG2 THR    56      18.067  -0.995  45.350  1.00 46.18          
ATOM    376  N   GLU    57      15.143  -3.343  47.828  1.00 47.39          
ATOM    377  CA  GLU    57      14.674  -4.344  48.773  1.00 47.62          
ATOM    378  C   GLU    57      13.441  -5.053  48.306  1.00 47.71          
ATOM    379  O   GLU    57      13.327  -6.260  48.438  1.00 48.16          
ATOM    380  CB  GLU    57      14.361  -3.712  50.117  1.00 49.17          
ATOM    381  CG  GLU    57      13.931  -4.714  51.180  1.00 50.98          
ATOM    382  CD  GLU    57      13.395  -4.031  52.437  1.00 52.75          
ATOM    383  OE1 GLU    57      13.203  -4.714  53.468  1.00 53.26          
ATOM    384  OE2 GLU    57      13.154  -2.807  52.382  1.00 54.01          
ATOM    385  N   GLU    58      12.502  -4.291  47.779  1.00 48.34          
ATOM    386  CA  GLU    58      11.257  -4.857  47.314  1.00 50.36          
ATOM    387  C   GLU    58      11.435  -5.758  46.103  1.00 51.67          
ATOM    388  O   GLU    58      10.605  -6.627  45.843  1.00 51.05          
ATOM    389  CB  GLU    58      10.276  -3.730  47.011  1.00 51.70          
ATOM    390  CG  GLU    58      10.044  -2.804  48.205  1.00 54.05          
ATOM    391  CD  GLU    58       9.059  -1.690  47.897  1.00 54.95          
ATOM    392  OE1 GLU    58       9.289  -0.952  46.911  1.00 53.56          
ATOM    393  OE2 GLU    58       8.062  -1.554  48.646  1.00 56.23          
ATOM    394  N   MET    59      12.522  -5.561  45.366  1.00 53.00          
ATOM    395  CA  MET    59      12.804  -6.374  44.179  1.00 54.52          
ATOM    396  C   MET    59      13.089  -7.828  44.530  1.00 54.25          
ATOM    397  O   MET    59      13.251  -8.662  43.641  1.00 54.07          
ATOM    398  CB  MET    59      14.009  -5.814  43.428  1.00 57.77          
ATOM    399  CG  MET    59      13.794  -4.457  42.799  1.00 62.25          
ATOM    400  SD  MET    59      15.363  -3.879  41.807  1.00 70.44          
ATOM    401  CE  MET    59      15.371  -1.998  42.290  1.00 67.49          
ATOM    402  N   GLU    60      13.163  -8.110  45.831  1.00 53.56          
ATOM    403  CA  GLU    60      13.433  -9.453  46.352  1.00 52.64          
ATOM    404  C   GLU    60      14.481 -10.251  45.585  1.00 50.43          
ATOM    405  O   GLU    60      14.318 -11.450  45.392  1.00 51.35          
ATOM    406  CB  GLU    60      12.135 -10.261  46.420  1.00 53.57          
ATOM    407  CG  GLU    60      11.354 -10.074  47.708  1.00 56.49          
ATOM    408  CD  GLU    60       9.894 -10.467  47.562  1.00 59.54          
ATOM    409  OE1 GLU    60       9.610 -11.476  46.869  1.00 60.10          
ATOM    410  OE2 GLU    60       9.029  -9.774  48.151  1.00 60.23          
ATOM    411  N   GLY    61      15.554  -9.601  45.154  1.00 48.05          
ATOM    412  CA  GLY    61      16.582 -10.330  44.443  1.00 46.22          
ATOM    413  C   GLY    61      16.423 -10.307  42.939  1.00 45.02          
ATOM    414  O   GLY    61      17.412 -10.296  42.208  1.00 46.21          
ATOM    415  N   ILE    62      15.189 -10.308  42.455  1.00 43.60          
ATOM    416  CA  ILE    62      14.969 -10.276  41.019  1.00 41.23          
ATOM    417  C   ILE    62      15.599  -9.022  40.419  1.00 40.65          
ATOM    418  O   ILE    62      15.292  -7.905  40.821  1.00 41.62          
ATOM    419  CB  ILE    62      13.479 -10.248  40.689  1.00 40.73          
ATOM    420  CG1 ILE    62      12.776 -11.464  41.306  1.00 38.20          
ATOM    421  CG2 ILE    62      13.306 -10.157  39.179  1.00 41.74          
ATOM    422  CD  ILE    62      13.258 -12.789  40.784  1.00 36.15          
ATOM    423  N   PRO    63      16.491  -9.190  39.442  1.00 40.13          
ATOM    424  CA  PRO    63      17.144  -8.041  38.805  1.00 40.32          
ATOM    425  C   PRO    63      16.221  -7.197  37.917  1.00 39.75          
ATOM    426  O   PRO    63      15.509  -7.736  37.073  1.00 39.18          
ATOM    427  CB  PRO    63      18.277  -8.694  38.008  1.00 40.21          
ATOM    428  CG  PRO    63      17.715 -10.036  37.661  1.00 39.66          
ATOM    429  CD  PRO    63      17.070 -10.455  38.959  1.00 40.22          
ATOM    430  N   HSD    64      16.235  -5.877  38.115  1.00 39.80          
ATOM    431  CA  HSD    64      15.404  -4.971  37.322  1.00 40.76          
ATOM    432  C   HSD    64      16.240  -4.041  36.409  1.00 42.95          
ATOM    433  O   HSD    64      17.318  -3.576  36.786  1.00 41.97          
ATOM    434  CB  HSD    64      14.493  -4.123  38.232  1.00 37.92          
ATOM    435  CG  HSD    64      13.430  -4.905  38.944  1.00 36.17          
ATOM    436  ND1 HSD    64      12.239  -4.340  39.346  1.00 36.89          
ATOM    437  CD2 HSD    64      13.383  -6.196  39.354  1.00 35.64          
ATOM    438  CE1 HSD    64      11.505  -5.244  39.969  1.00 35.10          
ATOM    439  NE2 HSD    64      12.177  -6.380  39.986  1.00 33.58          
ATOM    440  N   TYR    65      15.734  -3.786  35.201  1.00 44.46          
ATOM    441  CA  TYR    65      16.416  -2.924  34.246  1.00 46.92          
ATOM    442  C   TYR    65      15.558  -1.722  33.913  1.00 48.79          
ATOM    443  O   TYR    65      14.356  -1.716  34.197  1.00 48.51          
ATOM    444  CB  TYR    65      16.734  -3.679  32.956  1.00 46.24          
ATOM    445  CG  TYR    65      17.495  -4.956  33.189  1.00 46.04          
ATOM    446  CD1 TYR    65      16.839  -6.181  33.203  1.00 45.12          
ATOM    447  CD2 TYR    65      18.876  -4.940  33.421  1.00 46.83          
ATOM    448  CE1 TYR    65      17.538  -7.365  33.439  1.00 45.27          
ATOM    449  CE2 TYR    65      19.587  -6.118  33.664  1.00 44.91          
ATOM    450  CZ  TYR    65      18.915  -7.324  33.666  1.00 44.46          
ATOM    451  OH  TYR    65      19.618  -8.485  33.861  1.00 42.99          
ATOM    452  N   MET    66      16.180  -0.709  33.310  1.00 50.14          
ATOM    453  CA  MET    66      15.474   0.511  32.938  1.00 52.49          
ATOM    454  C   MET    66      15.065   1.366  34.144  1.00 51.53          
ATOM    455  O   MET    66      14.097   2.124  34.068  1.00 50.60          
ATOM    456  CB  MET    66      14.225   0.152  32.137  1.00 57.56          
ATOM    457  CG  MET    66      14.507  -0.541  30.808  1.00 65.45          
ATOM    458  SD  MET    66      15.334   0.620  29.477  1.00 71.33          
ATOM    459  CE  MET    66      13.820   1.809  29.184  1.00 69.78          
ATOM    460  N   ILE    67      15.790   1.237  35.256  1.00 50.85          
ATOM    461  CA  ILE    67      15.494   2.005  36.472  1.00 49.39          
ATOM    462  C   ILE    67      16.742   2.762  36.944  1.00 48.87          
ATOM    463  O   ILE    67      17.774   2.150  37.219  1.00 49.58          
ATOM    464  CB  ILE    67      14.973   1.076  37.606  1.00 48.43          
ATOM    465  CG1 ILE    67      13.742   0.313  37.121  1.00 47.01          
ATOM    466  CG2 ILE    67      14.617   1.897  38.840  1.00 47.68          
ATOM    467  CD  ILE    67      13.258  -0.716  38.065  1.00 46.08          
ATOM    468  N   ASP    68      16.639   4.090  37.028  1.00 47.81          
ATOM    469  CA  ASP    68      17.760   4.942  37.434  1.00 47.06          
ATOM    470  C   ASP    68      18.911   4.812  36.444  1.00 46.44          
ATOM    471  O   ASP    68      20.064   4.604  36.838  1.00 46.29          
ATOM    472  CB  ASP    68      18.277   4.568  38.826  1.00 48.04          
ATOM    473  CG  ASP    68      17.305   4.924  39.929  1.00 49.01          
ATOM    474  OD1 ASP    68      16.806   6.072  39.939  1.00 51.42          
ATOM    475  OD2 ASP    68      17.052   4.068  40.799  1.00 48.86          
ATOM    476  N   ILE    69      18.599   4.922  35.158  1.00 44.44          
ATOM    477  CA  ILE    69      19.616   4.812  34.129  1.00 42.98          
ATOM    478  C   ILE    69      19.953   6.161  33.496  1.00 42.60          
ATOM    479  O   ILE    69      20.851   6.252  32.664  1.00 42.00          
ATOM    480  CB  ILE    69      19.170   3.854  33.018  1.00 43.70          
ATOM    481  CG1 ILE    69      17.845   4.328  32.414  1.00 43.50          
ATOM    482  CG2 ILE    69      19.052   2.449  33.565  1.00 44.67          
ATOM    483  CD  ILE    69      17.404   3.536  31.203  1.00 42.90          
ATOM    484  N   LEU    70      19.245   7.212  33.902  1.00 42.59          
ATOM    485  CA  LEU    70      19.486   8.549  33.359  1.00 40.82          
ATOM    486  C   LEU    70      19.250   9.633  34.407  1.00 41.05          
ATOM    487  O   LEU    70      18.577   9.405  35.398  1.00 41.88          
ATOM    488  CB  LEU    70      18.548   8.791  32.171  1.00 39.27          
ATOM    489  CG  LEU    70      18.589   7.800  31.020  1.00 36.21          
ATOM    490  CD1 LEU    70      17.340   7.949  30.200  1.00 36.04          
ATOM    491  CD2 LEU    70      19.824   8.038  30.194  1.00 34.44          
ATOM    492  N   PRO    71      19.835  10.825  34.214  1.00 43.24          
ATOM    493  CA  PRO    71      19.650  11.934  35.154  1.00 41.06          
ATOM    494  C   PRO    71      18.362  12.638  34.725  1.00 42.77          
ATOM    495  O   PRO    71      17.904  12.457  33.605  1.00 42.17          
ATOM    496  CB  PRO    71      20.879  12.792  34.919  1.00 42.02          
ATOM    497  CG  PRO    71      21.065  12.653  33.448  1.00 41.82          
ATOM    498  CD  PRO    71      20.887  11.154  33.242  1.00 42.37          
ATOM    499  N   PRO    72      17.770  13.460  35.603  1.00 46.11          
ATOM    500  CA  PRO    72      16.522  14.173  35.299  1.00 45.97          
ATOM    501  C   PRO    72      16.497  14.962  33.990  1.00 48.27          
ATOM    502  O   PRO    72      15.500  14.933  33.254  1.00 49.06          
ATOM    503  CB  PRO    72      16.327  15.057  36.521  1.00 45.64          
ATOM    504  CG  PRO    72      16.892  14.201  37.619  1.00 45.86          
ATOM    505  CD  PRO    72      18.180  13.706  36.995  1.00 45.76          
ATOM    506  N   ASP    73      17.593  15.659  33.693  1.00 50.27          
ATOM    507  CA  ASP    73      17.710  16.484  32.476  1.00 50.11          
ATOM    508  C   ASP    73      17.880  15.666  31.197  1.00 50.04          
ATOM    509  O   ASP    73      17.918  16.220  30.087  1.00 51.02          
ATOM    510  CB  ASP    73      18.889  17.460  32.625  1.00 52.01          
ATOM    511  CG  ASP    73      20.224  16.746  32.837  1.00 54.57          
ATOM    512  OD1 ASP    73      20.667  16.017  31.911  1.00 55.67          
ATOM    513  OD2 ASP    73      20.834  16.922  33.921  1.00 53.87          
ATOM    514  N   ALA    74      17.997  14.350  31.356  1.00 48.21          
ATOM    515  CA  ALA    74      18.159  13.464  30.210  1.00 45.93          
ATOM    516  C   ALA    74      16.842  13.337  29.472  1.00 44.07          
ATOM    517  O   ALA    74      15.780  13.627  30.015  1.00 41.10          
ATOM    518  CB  ALA    74      18.645  12.094  30.668  1.00 46.53          
ATOM    519  N   SER    75      16.921  12.893  28.229  1.00 44.15          
ATOM    520  CA  SER    75      15.727  12.747  27.425  1.00 44.33          
ATOM    521  C   SER    75      15.354  11.285  27.232  1.00 42.90          
ATOM    522  O   SER    75      16.217  10.409  27.187  1.00 42.46          
ATOM    523  CB  SER    75      15.932  13.425  26.073  1.00 45.22          
ATOM    524  OG  SER    75      14.852  13.131  25.206  1.00 48.08          
ATOM    525  N   PHE    76      14.058  11.028  27.128  1.00 42.25          
ATOM    526  CA  PHE    76      13.589   9.677  26.939  1.00 42.63          
ATOM    527  C   PHE    76      12.435   9.680  25.950  1.00 44.28          
ATOM    528  O   PHE    76      11.843  10.731  25.681  1.00 44.93          
ATOM    529  CB  PHE    76      13.158   9.080  28.272  1.00 41.10          
ATOM    530  CG  PHE    76      13.230   7.592  28.304  1.00 40.73          
ATOM    531  CD1 PHE    76      14.438   6.943  28.082  1.00 40.57          
ATOM    532  CD2 PHE    76      12.091   6.830  28.513  1.00 40.81          
ATOM    533  CE1 PHE    76      14.515   5.548  28.069  1.00 40.33          
ATOM    534  CE2 PHE    76      12.157   5.431  28.503  1.00 40.80          
ATOM    535  CZ  PHE    76      13.375   4.793  28.276  1.00 39.45          
ATOM    536  N   SER    77      12.112   8.506  25.413  1.00 44.42          
ATOM    537  CA  SER    77      11.050   8.409  24.423  1.00 44.38          
ATOM    538  C   SER    77      10.626   6.972  24.168  1.00 44.19          
ATOM    539  O   SER    77      11.321   6.029  24.532  1.00 43.90          
ATOM    540  CB  SER    77      11.537   8.990  23.107  1.00 45.47          
ATOM    541  OG  SER    77      12.572   8.162  22.578  1.00 47.33          
ATOM    542  N   ALA    78       9.481   6.813  23.521  1.00 42.68          
ATOM    543  CA  ALA    78       8.996   5.488  23.212  1.00 42.21          
ATOM    544  C   ALA    78      10.066   4.637  22.487  1.00 43.10          
ATOM    545  O   ALA    78      10.303   3.504  22.882  1.00 42.31          
ATOM    546  CB  ALA    78       7.714   5.577  22.377  1.00 41.89          
ATOM    547  N   TYR    79      10.724   5.159  21.448  1.00 44.68          
ATOM    548  CA  TYR    79      11.728   4.350  20.756  1.00 46.27          
ATOM    549  C   TYR    79      12.962   4.134  21.609  1.00 44.55          
ATOM    550  O   TYR    79      13.531   3.041  21.616  1.00 43.90          
ATOM    551  CB  TYR    79      12.148   4.962  19.403  1.00 52.71          
ATOM    552  CG  TYR    79      13.289   4.209  18.700  1.00 58.76          
ATOM    553  CD1 TYR    79      14.585   4.755  18.646  1.00 61.33          
ATOM    554  CD2 TYR    79      13.085   2.935  18.131  1.00 60.40          
ATOM    555  CE1 TYR    79      15.655   4.053  18.050  1.00 63.02          
ATOM    556  CE2 TYR    79      14.152   2.218  17.531  1.00 62.10          
ATOM    557  CZ  TYR    79      15.431   2.784  17.497  1.00 63.41          
ATOM    558  OH  TYR    79      16.489   2.099  16.917  1.00 62.92          
ATOM    559  N   GLU    80      13.384   5.165  22.327  1.00 42.75          
ATOM    560  CA  GLU    80      14.558   5.030  23.179  1.00 41.93          
ATOM    561  C   GLU    80      14.369   3.772  24.037  1.00 40.72          
ATOM    562  O   GLU    80      15.285   2.960  24.174  1.00 41.10          
ATOM    563  CB  GLU    80      14.726   6.288  24.053  1.00 41.99          
ATOM    564  CG  GLU    80      15.937   6.271  24.984  1.00 43.40          
ATOM    565  CD  GLU    80      17.244   5.907  24.289  1.00 44.68          
ATOM    566  OE1 GLU    80      18.281   5.855  24.990  1.00 44.88          
ATOM    567  OE2 GLU    80      17.247   5.676  23.057  1.00 44.63          
ATOM    568  N   PHE    81      13.158   3.609  24.570  1.00 38.87          
ATOM    569  CA  PHE    81      12.781   2.465  25.407  1.00 36.19          
ATOM    570  C   PHE    81      12.849   1.170  24.596  1.00 36.54          
ATOM    571  O   PHE    81      13.312   0.137  25.086  1.00 35.85          
ATOM    572  CB  PHE    81      11.357   2.689  25.962  1.00 33.12          
ATOM    573  CG  PHE    81      10.681   1.435  26.465  1.00 30.51          
ATOM    574  CD1 PHE    81      11.210   0.717  27.524  1.00 29.09          
ATOM    575  CD2 PHE    81       9.528   0.957  25.850  1.00 30.08          
ATOM    576  CE1 PHE    81      10.613  -0.454  27.955  1.00 28.28          
ATOM    577  CE2 PHE    81       8.925  -0.218  26.280  1.00 28.60          
ATOM    578  CZ  PHE    81       9.470  -0.921  27.330  1.00 27.92          
ATOM    579  N   LYS    82      12.394   1.239  23.347  1.00 37.42          
ATOM    580  CA  LYS    82      12.392   0.079  22.453  1.00 38.62          
ATOM    581  C   LYS    82      13.807  -0.407  22.131  1.00 38.47          
ATOM    582  O   LYS    82      14.089  -1.606  22.162  1.00 36.19          
ATOM    583  CB  LYS    82      11.656   0.420  21.148  1.00 39.34          
ATOM    584  CG  LYS    82      11.549  -0.733  20.172  1.00 38.40          
ATOM    585  CD  LYS    82      10.907  -0.297  18.874  1.00 39.39          
ATOM    586  CE  LYS    82      10.964  -1.429  17.858  1.00 41.17          
ATOM    587  NZ  LYS    82       9.977  -1.274  16.742  1.00 42.70          
ATOM    588  N   LYS    83      14.690   0.535  21.822  1.00 39.75          
ATOM    589  CA  LYS    83      16.067   0.201  21.496  1.00 40.53          
ATOM    590  C   LYS    83      16.724  -0.543  22.648  1.00 40.76          
ATOM    591  O   LYS    83      17.320  -1.608  22.444  1.00 41.80          
ATOM    592  CB  LYS    83      16.863   1.470  21.177  1.00 40.74          
ATOM    593  CG  LYS    83      18.312   1.194  20.853  1.00 42.46          
ATOM    594  CD  LYS    83      19.071   2.446  20.455  1.00 45.99          
ATOM    595  CE  LYS    83      20.459   2.070  19.928  1.00 48.24          
ATOM    596  NZ  LYS    83      21.259   3.243  19.463  1.00 50.23          
ATOM    597  N   ARG    84      16.607   0.020  23.856  1.00 40.35          
ATOM    598  CA  ARG    84      17.190  -0.572  25.084  1.00 39.35          
ATOM    599  C   ARG    84      16.484  -1.854  25.530  1.00 37.92          
ATOM    600  O   ARG    84      17.133  -2.806  25.954  1.00 36.85          
ATOM    601  CB  ARG    84      17.156   0.429  26.250  1.00 36.67          
ATOM    602  CG  ARG    84      17.859   1.728  25.980  1.00 36.15          
ATOM    603  CD  ARG    84      18.054   2.528  27.259  1.00 38.44          
ATOM    604  NE  ARG    84      18.593   3.855  26.966  1.00 40.06          
ATOM    605  CZ  ARG    84      19.648   4.396  27.567  1.00 40.78          
ATOM    606  NH1 ARG    84      20.299   3.728  28.515  1.00 40.28          
ATOM    607  NH2 ARG    84      20.058   5.606  27.202  1.00 41.15          
ATOM    608  N   ALA    85      15.158  -1.862  25.438  1.00 37.30          
ATOM    609  CA  ALA    85      14.393  -3.027  25.822  1.00 38.07          
ATOM    610  C   ALA    85      14.677  -4.226  24.905  1.00 38.96          
ATOM    611  O   ALA    85      14.838  -5.338  25.393  1.00 38.84          
ATOM    612  CB  ALA    85      12.906  -2.698  25.837  1.00 37.62          
ATOM    613  N   GLU    86      14.755  -4.012  23.590  1.00 40.01          
ATOM    614  CA  GLU    86      15.020  -5.119  22.663  1.00 40.70          
ATOM    615  C   GLU    86      16.344  -5.794  22.966  1.00 39.19          
ATOM    616  O   GLU    86      16.460  -7.009  22.858  1.00 37.95          
ATOM    617  CB  GLU    86      15.035  -4.644  21.199  1.00 43.09          
ATOM    618  CG  GLU    86      13.732  -4.026  20.702  1.00 48.93          
ATOM    619  CD  GLU    86      13.759  -3.649  19.220  1.00 52.55          
ATOM    620  OE1 GLU    86      13.735  -4.566  18.368  1.00 56.38          
ATOM    621  OE2 GLU    86      13.814  -2.435  18.898  1.00 54.39          
ATOM    622  N   LYS    87      17.346  -5.012  23.343  1.00 38.58          
ATOM    623  CA  LYS    87      18.640  -5.592  23.648  1.00 38.74          
ATOM    624  C   LYS    87      18.535  -6.451  24.909  1.00 37.94          
ATOM    625  O   LYS    87      18.982  -7.593  24.913  1.00 37.92          
ATOM    626  CB  LYS    87      19.692  -4.489  23.821  1.00 40.10          
ATOM    627  CG  LYS    87      19.922  -3.647  22.563  1.00 40.60          
ATOM    628  CD  LYS    87      20.746  -2.395  22.866  1.00 42.69          
ATOM    629  CE  LYS    87      20.904  -1.490  21.628  1.00 42.87          
ATOM    630  NZ  LYS    87      21.492  -0.138  21.934  1.00 39.82          
ATOM    631  N   TYR    88      17.925  -5.910  25.962  1.00 36.95          
ATOM    632  CA  TYR    88      17.762  -6.644  27.214  1.00 37.15          
ATOM    633  C   TYR    88      16.916  -7.913  27.029  1.00 37.80          
ATOM    634  O   TYR    88      17.218  -8.973  27.580  1.00 37.94          
ATOM    635  CB  TYR    88      17.124  -5.756  28.295  1.00 37.25          
ATOM    636  CG  TYR    88      18.036  -4.700  28.910  1.00 39.23          
ATOM    637  CD1 TYR    88      17.783  -3.333  28.719  1.00 41.10          
ATOM    638  CD2 TYR    88      19.113  -5.059  29.734  1.00 38.28          
ATOM    639  CE1 TYR    88      18.568  -2.351  29.335  1.00 41.52          
ATOM    640  CE2 TYR    88      19.908  -4.081  30.358  1.00 38.86          
ATOM    641  CZ  TYR    88      19.626  -2.732  30.153  1.00 41.28          
ATOM    642  OH  TYR    88      20.390  -1.755  30.754  1.00 40.69          
ATOM    643  N   ILE    89      15.853  -7.815  26.250  1.00 37.05          
ATOM    644  CA  ILE    89      15.015  -8.973  26.022  1.00 36.98          
ATOM    645  C   ILE    89      15.820 -10.109  25.369  1.00 37.79          
ATOM    646  O   ILE    89      15.541 -11.282  25.617  1.00 37.75          
ATOM    647  CB  ILE    89      13.792  -8.608  25.139  1.00 35.57          
ATOM    648  CG1 ILE    89      12.904  -7.602  25.886  1.00 33.73          
ATOM    649  CG2 ILE    89      13.017  -9.859  24.777  1.00 33.51          
ATOM    650  CD  ILE    89      11.739  -7.066  25.077  1.00 30.08          
ATOM    651  N   LYS    90      16.806  -9.776  24.533  1.00 38.00          
ATOM    652  CA  LYS    90      17.631 -10.807  23.886  1.00 38.01          
ATOM    653  C   LYS    90      18.670 -11.334  24.868  1.00 38.13          
ATOM    654  O   LYS    90      18.861 -12.542  24.992  1.00 37.33          
ATOM    655  CB  LYS    90      18.349 -10.258  22.639  1.00 39.66          
ATOM    656  CG  LYS    90      17.608 -10.447  21.296  1.00 40.93          
ATOM    657  CD  LYS    90      18.408  -9.912  20.066  1.00 41.15          
ATOM    658  CE  LYS    90      18.564  -8.369  20.076  1.00 42.47          
ATOM    659  NZ  LYS    90      19.370  -7.772  18.962  1.00 39.46          
ATOM    660  N   ASP    91      19.342 -10.428  25.565  1.00 37.73          
ATOM    661  CA  ASP    91      20.350 -10.837  26.521  1.00 38.39          
ATOM    662  C   ASP    91      19.727 -11.783  27.541  1.00 38.89          
ATOM    663  O   ASP    91      20.293 -12.821  27.849  1.00 39.41          
ATOM    664  CB  ASP    91      20.930  -9.613  27.221  1.00 39.76          
ATOM    665  CG  ASP    91      22.095  -9.957  28.110  1.00 40.54          
ATOM    666  OD1 ASP    91      23.143 -10.368  27.568  1.00 41.54          
ATOM    667  OD2 ASP    91      21.961  -9.820  29.341  1.00 39.83          
ATOM    668  N   ILE    92      18.553 -11.418  28.052  1.00 38.96          
ATOM    669  CA  ILE    92      17.828 -12.232  29.034  1.00 39.57          
ATOM    670  C   ILE    92      17.530 -13.640  28.495  1.00 40.37          
ATOM    671  O   ILE    92      17.873 -14.645  29.131  1.00 41.32          
ATOM    672  CB  ILE    92      16.481 -11.547  29.448  1.00 38.05          
ATOM    673  CG1 ILE    92      16.772 -10.233  30.174  1.00 38.15          
ATOM    674  CG2 ILE    92      15.653 -12.464  30.338  1.00 36.72          
ATOM    675  CD  ILE    92      15.537  -9.460  30.585  1.00 35.07          
ATOM    676  N   THR    93      16.896 -13.717  27.326  1.00 40.55          
ATOM    677  CA  THR    93      16.551 -15.012  26.745  1.00 39.43          
ATOM    678  C   THR    93      17.799 -15.812  26.487  1.00 38.37          
ATOM    679  O   THR    93      17.805 -17.030  26.638  1.00 37.61          
ATOM    680  CB  THR    93      15.849 -14.890  25.379  1.00 40.05          
ATOM    681  OG1 THR    93      14.887 -13.822  25.391  1.00 40.47          
ATOM    682  CG2 THR    93      15.152 -16.199  25.048  1.00 38.13          
ATOM    683  N   ARG    94      18.851 -15.102  26.091  1.00 38.34          
ATOM    684  CA  ARG    94      20.141 -15.708  25.766  1.00 38.82          
ATOM    685  C   ARG    94      20.741 -16.429  26.954  1.00 37.58          
ATOM    686  O   ARG    94      21.525 -17.358  26.788  1.00 37.56          
ATOM    687  CB  ARG    94      21.106 -14.625  25.251  1.00 39.26          
ATOM    688  CG  ARG    94      22.336 -15.144  24.519  1.00 39.09          
ATOM    689  CD  ARG    94      23.214 -13.978  24.047  1.00 39.93          
ATOM    690  NE  ARG    94      23.583 -13.091  25.149  1.00 43.31          
ATOM    691  CZ  ARG    94      24.223 -13.484  26.250  1.00 44.23          
ATOM    692  NH1 ARG    94      24.509 -12.604  27.209  1.00 45.12          
ATOM    693  NH2 ARG    94      24.578 -14.756  26.396  1.00 44.13          
ATOM    694  N   ARG    95      20.374 -15.999  28.152  1.00 38.15          
ATOM    695  CA  ARG    95      20.890 -16.641  29.355  1.00 39.17          
ATOM    696  C   ARG    95      19.842 -17.586  29.935  1.00 40.16          
ATOM    697  O   ARG    95      19.773 -17.807  31.148  1.00 40.51          
ATOM    698  CB  ARG    95      21.312 -15.597  30.384  1.00 39.03          
ATOM    699  CG  ARG    95      22.321 -14.600  29.835  1.00 40.05          
ATOM    700  CD  ARG    95      22.995 -13.810  30.936  1.00 42.08          
ATOM    701  NE  ARG    95      22.028 -13.214  31.869  1.00 44.60          
ATOM    702  CZ  ARG    95      21.082 -12.352  31.516  1.00 45.39          
ATOM    703  NH1 ARG    95      20.262 -11.869  32.426  1.00 45.54          
ATOM    704  NH2 ARG    95      20.957 -11.974  30.249  1.00 47.84          
ATOM    705  N   GLY    96      19.024 -18.134  29.035  1.00 41.04          
ATOM    706  CA  GLY    96      17.982 -19.081  29.403  1.00 41.01          
ATOM    707  C   GLY    96      16.998 -18.627  30.459  1.00 41.51          
ATOM    708  O   GLY    96      16.566 -19.424  31.286  1.00 41.53          
ATOM    709  N   LYS    97      16.644 -17.350  30.443  1.00 41.90          
ATOM    710  CA  LYS    97      15.692 -16.832  31.419  1.00 42.49          
ATOM    711  C   LYS    97      14.426 -16.318  30.727  1.00 41.53          
ATOM    712  O   LYS    97      14.305 -16.363  29.498  1.00 42.10          
ATOM    713  CB  LYS    97      16.334 -15.716  32.252  1.00 43.46          
ATOM    714  CG  LYS    97      17.166 -16.206  33.436  1.00 45.45          
ATOM    715  CD  LYS    97      17.908 -15.050  34.122  1.00 48.34          
ATOM    716  CE  LYS    97      18.004 -15.240  35.662  1.00 50.04          
ATOM    717  NZ  LYS    97      18.682 -16.515  36.088  1.00 48.07          
ATOM    718  N   VAL    98      13.483 -15.833  31.524  1.00 38.99          
ATOM    719  CA  VAL    98      12.230 -15.338  30.989  1.00 36.53          
ATOM    720  C   VAL    98      12.110 -13.838  31.071  1.00 37.14          
ATOM    721  O   VAL    98      11.898 -13.280  32.152  1.00 36.62          
ATOM    722  CB  VAL    98      11.041 -15.936  31.733  1.00 35.74          
ATOM    723  CG1 VAL    98       9.748 -15.385  31.159  1.00 34.97          
ATOM    724  CG2 VAL    98      11.084 -17.440  31.629  1.00 34.69          
ATOM    725  N   PRO    99      12.236 -13.158  29.924  1.00 36.43          
ATOM    726  CA  PRO    99      12.133 -11.702  29.880  1.00 35.92          
ATOM    727  C   PRO    99      10.707 -11.243  30.242  1.00 36.90          
ATOM    728  O   PRO    99       9.723 -11.657  29.609  1.00 36.32          
ATOM    729  CB  PRO    99      12.510 -11.383  28.444  1.00 35.09          
ATOM    730  CG  PRO    99      11.952 -12.549  27.710  1.00 35.11          
ATOM    731  CD  PRO    99      12.350 -13.717  28.570  1.00 35.83          
ATOM    732  N   ILE   100      10.609 -10.378  31.256  1.00 35.85          
ATOM    733  CA  ILE   100       9.324  -9.866  31.746  1.00 34.09          
ATOM    734  C   ILE   100       9.369  -8.347  31.820  1.00 34.92          
ATOM    735  O   ILE   100      10.280  -7.778  32.418  1.00 35.54          
ATOM    736  CB  ILE   100       9.038 -10.371  33.182  1.00 33.56          
ATOM    737  CG1 ILE   100       9.218 -11.888  33.261  1.00 33.93          
ATOM    738  CG2 ILE   100       7.648 -10.007  33.583  1.00 30.85          
ATOM    739  CD  ILE   100       9.497 -12.376  34.658  1.00 33.77          
ATOM    740  N   ILE   101       8.394  -7.688  31.213  1.00 35.33          
ATOM    741  CA  ILE   101       8.345  -6.238  31.279  1.00 35.38          
ATOM    742  C   ILE   101       7.166  -5.844  32.173  1.00 35.55          
ATOM    743  O   ILE   101       6.032  -6.270  31.972  1.00 34.79          
ATOM    744  CB  ILE   101       8.215  -5.592  29.879  1.00 34.99          
ATOM    745  CG1 ILE   101       7.036  -6.192  29.133  1.00 36.58          
ATOM    746  CG2 ILE   101       9.498  -5.807  29.099  1.00 34.45          
ATOM    747  CD  ILE   101       6.915  -5.691  27.723  1.00 39.07          
ATOM    748  N   ALA   102       7.478  -5.049  33.189  1.00 35.59          
ATOM    749  CA  ALA   102       6.510  -4.580  34.147  1.00 34.62          
ATOM    750  C   ALA   102       6.215  -3.135  33.837  1.00 36.25          
ATOM    751  O   ALA   102       7.129  -2.337  33.607  1.00 36.56          
ATOM    752  CB  ALA   102       7.066  -4.700  35.535  1.00 31.84          
ATOM    753  N   GLY   103       4.928  -2.806  33.808  1.00 36.86          
ATOM    754  CA  GLY   103       4.514  -1.438  33.547  1.00 34.82          
ATOM    755  C   GLY   103       4.605  -1.026  32.101  1.00 34.11          
ATOM    756  O   GLY   103       4.742  -1.863  31.211  1.00 34.68          
ATOM    757  N   GLY   104       4.527   0.282  31.880  1.00 34.21          
ATOM    758  CA  GLY   104       4.591   0.823  30.538  1.00 32.64          
ATOM    759  C   GLY   104       3.248   1.377  30.095  1.00 32.24          
ATOM    760  O   GLY   104       2.210   0.989  30.619  1.00 30.34          
ATOM    761  N   THR   105       3.271   2.290  29.129  1.00 34.02          
ATOM    762  CA  THR   105       2.050   2.892  28.604  1.00 36.46          
ATOM    763  C   THR   105       1.713   2.289  27.233  1.00 37.92          
ATOM    764  O   THR   105       2.510   1.540  26.673  1.00 39.04          
ATOM    765  CB  THR   105       2.202   4.430  28.452  1.00 35.92          
ATOM    766  OG1 THR   105       3.371   4.736  27.677  1.00 35.55          
ATOM    767  CG2 THR   105       2.293   5.096  29.818  1.00 36.82          
ATOM    768  N   GLY   106       0.540   2.619  26.698  1.00 38.11          
ATOM    769  CA  GLY   106       0.146   2.102  25.400  1.00 37.56          
ATOM    770  C   GLY   106       1.221   2.304  24.344  1.00 37.63          
ATOM    771  O   GLY   106       1.659   1.346  23.714  1.00 35.90          
ATOM    772  N   LEU   107       1.653   3.544  24.140  1.00 38.20          
ATOM    773  CA  LEU   107       2.685   3.791  23.151  1.00 39.43          
ATOM    774  C   LEU   107       3.891   2.894  23.389  1.00 39.89          
ATOM    775  O   LEU   107       4.174   2.017  22.579  1.00 41.10          
ATOM    776  CB  LEU   107       3.131   5.252  23.168  1.00 41.15          
ATOM    777  CG  LEU   107       2.421   6.254  22.244  1.00 41.69          
ATOM    778  CD1 LEU   107       2.941   7.651  22.577  1.00 42.07          
ATOM    779  CD2 LEU   107       2.684   5.922  20.777  1.00 41.61          
ATOM    780  N   TYR   108       4.583   3.096  24.509  1.00 39.43          
ATOM    781  CA  TYR   108       5.766   2.308  24.847  1.00 38.14          
ATOM    782  C   TYR   108       5.590   0.811  24.689  1.00 37.73          
ATOM    783  O   TYR   108       6.523   0.120  24.310  1.00 37.59          
ATOM    784  CB  TYR   108       6.209   2.586  26.283  1.00 40.80          
ATOM    785  CG  TYR   108       6.759   3.969  26.516  1.00 43.04          
ATOM    786  CD1 TYR   108       8.091   4.149  26.882  1.00 42.95          
ATOM    787  CD2 TYR   108       5.943   5.101  26.371  1.00 44.06          
ATOM    788  CE1 TYR   108       8.609   5.421  27.098  1.00 45.65          
ATOM    789  CE2 TYR   108       6.446   6.384  26.583  1.00 46.23          
ATOM    790  CZ  TYR   108       7.788   6.536  26.947  1.00 47.17          
ATOM    791  OH  TYR   108       8.307   7.800  27.154  1.00 48.96          
ATOM    792  N   ILE   109       4.403   0.303  24.987  1.00 38.17          
ATOM    793  CA  ILE   109       4.185  -1.120  24.881  1.00 39.47          
ATOM    794  C   ILE   109       3.935  -1.613  23.469  1.00 40.68          
ATOM    795  O   ILE   109       4.524  -2.605  23.053  1.00 42.01          
ATOM    796  CB  ILE   109       3.038  -1.567  25.781  1.00 39.28          
ATOM    797  CG1 ILE   109       3.376  -1.240  27.225  1.00 41.80          
ATOM    798  CG2 ILE   109       2.815  -3.062  25.646  1.00 39.71          
ATOM    799  CD  ILE   109       4.689  -1.861  27.711  1.00 43.04          
ATOM    800  N   GLN   110       3.070  -0.944  22.718  1.00 41.74          
ATOM    801  CA  GLN   110       2.827  -1.410  21.365  1.00 42.65          
ATOM    802  C   GLN   110       4.045  -1.161  20.478  1.00 42.85          
ATOM    803  O   GLN   110       4.395  -1.985  19.624  1.00 43.03          
ATOM    804  CB  GLN   110       1.574  -0.757  20.759  1.00 43.38          
ATOM    805  CG  GLN   110       1.751   0.625  20.174  1.00 43.67          
ATOM    806  CD  GLN   110       0.605   0.995  19.236  1.00 44.36          
ATOM    807  OE1 GLN   110       0.534   2.121  18.741  1.00 44.31          
ATOM    808  NE2 GLN   110      -0.294   0.039  18.983  1.00 43.98          
ATOM    809  N   SER   111       4.712  -0.038  20.695  1.00 42.96          
ATOM    810  CA  SER   111       5.890   0.292  19.900  1.00 43.29          
ATOM    811  C   SER   111       6.911  -0.835  20.019  1.00 43.63          
ATOM    812  O   SER   111       7.658  -1.120  19.081  1.00 43.24          
ATOM    813  CB  SER   111       6.490   1.620  20.382  1.00 41.83          
ATOM    814  OG  SER   111       5.519   2.653  20.359  1.00 38.04          
ATOM    815  N   LEU   112       6.910  -1.484  21.179  1.00 42.94          
ATOM    816  CA  LEU   112       7.820  -2.589  21.466  1.00 43.24          
ATOM    817  C   LEU   112       7.305  -3.932  20.984  1.00 42.84          
ATOM    818  O   LEU   112       8.084  -4.826  20.664  1.00 43.39          
ATOM    819  CB  LEU   112       8.073  -2.679  22.980  1.00 42.95          
ATOM    820  CG  LEU   112       8.738  -3.944  23.539  1.00 41.60          
ATOM    821  CD1 LEU   112      10.130  -4.145  22.941  1.00 40.14          
ATOM    822  CD2 LEU   112       8.806  -3.824  25.042  1.00 40.07          
ATOM    823  N   LEU   113       5.991  -4.079  20.943  1.00 42.94          
ATOM    824  CA  LEU   113       5.404  -5.342  20.529  1.00 43.87          
ATOM    825  C   LEU   113       5.256  -5.507  19.022  1.00 43.65          
ATOM    826  O   LEU   113       5.468  -6.595  18.492  1.00 43.18          
ATOM    827  CB  LEU   113       4.040  -5.520  21.201  1.00 44.22          
ATOM    828  CG  LEU   113       4.098  -5.537  22.733  1.00 45.40          
ATOM    829  CD1 LEU   113       2.696  -5.608  23.294  1.00 45.75          
ATOM    830  CD2 LEU   113       4.926  -6.726  23.201  1.00 45.87          
ATOM    831  N   TYR   114       4.929  -4.421  18.335  1.00 43.62          
ATOM    832  CA  TYR   114       4.706  -4.469  16.899  1.00 43.89          
ATOM    833  C   TYR   114       5.617  -3.561  16.106  1.00 45.49          
ATOM    834  O   TYR   114       5.993  -2.496  16.576  1.00 47.98          
ATOM    835  CB  TYR   114       3.260  -4.078  16.614  1.00 43.38          
ATOM    836  CG  TYR   114       2.270  -4.789  17.502  1.00 40.83          
ATOM    837  CD1 TYR   114       2.213  -6.172  17.514  1.00 39.48          
ATOM    838  CD2 TYR   114       1.400  -4.079  18.333  1.00 40.02          
ATOM    839  CE1 TYR   114       1.327  -6.844  18.322  1.00 40.57          
ATOM    840  CE2 TYR   114       0.495  -4.743  19.155  1.00 40.05          
ATOM    841  CZ  TYR   114       0.471  -6.140  19.138  1.00 40.06          
ATOM    842  OH  TYR   114      -0.394  -6.860  19.917  1.00 39.18          
ATOM    843  N   ASN   115       5.955  -3.974  14.892  1.00 47.91          
ATOM    844  CA  ASN   115       6.802  -3.165  14.034  1.00 49.56          
ATOM    845  C   ASN   115       6.010  -2.369  13.028  1.00 50.49          
ATOM    846  O   ASN   115       6.268  -2.476  11.836  1.00 50.90          
ATOM    847  CB  ASN   115       7.765  -4.042  13.268  1.00 49.54          
ATOM    848  CG  ASN   115       9.037  -4.256  13.998  1.00 51.39          
ATOM    849  OD1 ASN   115       9.954  -4.869  13.468  1.00 52.45          
ATOM    850  ND2 ASN   115       9.117  -3.749  15.233  1.00 52.07          
ATOM   1490  N   GLU   194       4.232  -8.569  14.796  1.00 47.75          
ATOM   1491  CA  GLU   194       4.617  -8.834  16.179  1.00 49.40          
ATOM   1492  C   GLU   194       6.024  -9.388  16.317  1.00 48.31          
ATOM   1493  O   GLU   194       6.399 -10.332  15.638  1.00 48.33          
ATOM   1494  CB  GLU   194       3.630  -9.789  16.843  1.00 51.42          
ATOM   1495  CG  GLU   194       3.490 -11.112  16.136  1.00 56.87          
ATOM   1496  CD  GLU   194       2.523 -12.042  16.848  1.00 60.08          
ATOM   1497  OE1 GLU   194       2.177 -13.105  16.267  1.00 61.22          
ATOM   1498  OE2 GLU   194       2.115 -11.713  17.992  1.00 60.95          
ATOM   1499  N   ASN   195       6.787  -8.798  17.226  1.00 46.51          
ATOM   1500  CA  ASN   195       8.143  -9.207  17.436  1.00 45.67          
ATOM   1501  C   ASN   195       8.302 -10.310  18.443  1.00 45.98          
ATOM   1502  O   ASN   195       9.308 -11.001  18.434  1.00 47.00          
ATOM   1503  CB  ASN   195       8.982  -8.016  17.860  1.00 47.07          
ATOM   1504  CG  ASN   195       8.897  -6.874  16.867  1.00 48.46          
ATOM   1505  OD1 ASN   195       8.841  -7.099  15.655  1.00 49.07          
ATOM   1506  ND2 ASN   195       8.880  -5.641  17.372  1.00 48.06          
ATOM   1507  N   TYR   196       7.326 -10.499  19.315  1.00 46.29          
ATOM   1508  CA  TYR   196       7.467 -11.540  20.317  1.00 47.17          
ATOM   1509  C   TYR   196       6.232 -12.389  20.522  1.00 47.82          
ATOM   1510  O   TYR   196       5.125 -12.002  20.152  1.00 47.37          
ATOM   1511  CB  TYR   196       7.860 -10.918  21.664  1.00 46.04          
ATOM   1512  CG  TYR   196       8.973  -9.899  21.584  1.00 45.49          
ATOM   1513  CD1 TYR   196       8.701  -8.549  21.361  1.00 44.85          
ATOM   1514  CD2 TYR   196      10.304 -10.286  21.742  1.00 45.74          
ATOM   1515  CE1 TYR   196       9.736  -7.609  21.307  1.00 44.31          
ATOM   1516  CE2 TYR   196      11.340  -9.361  21.684  1.00 43.91          
ATOM   1517  CZ  TYR   196      11.055  -8.032  21.471  1.00 43.56          
ATOM   1518  OH  TYR   196      12.099  -7.141  21.438  1.00 42.22          
ATOM   1519  N   ASP   197       6.451 -13.561  21.112  1.00 48.93          
ATOM   1520  CA  ASP   197       5.371 -14.486  21.452  1.00 50.31          
ATOM   1521  C   ASP   197       4.840 -13.955  22.786  1.00 50.43          
ATOM   1522  O   ASP   197       4.990 -14.599  23.832  1.00 51.08          
ATOM   1523  CB  ASP   197       5.918 -15.900  21.660  1.00 51.47          
ATOM   1524  CG  ASP   197       4.886 -16.831  22.266  1.00 53.27          
ATOM   1525  OD1 ASP   197       5.258 -17.893  22.809  1.00 53.86          
ATOM   1526  OD2 ASP   197       3.686 -16.493  22.203  1.00 55.59          
ATOM   1527  N   THR   198       4.213 -12.782  22.737  1.00 49.76          
ATOM   1528  CA  THR   198       3.713 -12.096  23.932  1.00 49.28          
ATOM   1529  C   THR   198       2.563 -12.709  24.722  1.00 47.06          
ATOM   1530  O   THR   198       1.661 -13.327  24.170  1.00 46.55          
ATOM   1531  CB  THR   198       3.316 -10.626  23.597  1.00 50.79          
ATOM   1532  OG1 THR   198       2.051 -10.612  22.924  1.00 52.00          
ATOM   1533  CG2 THR   198       4.370  -9.971  22.696  1.00 51.01          
ATOM   1534  N   LEU   199       2.632 -12.528  26.034  1.00 46.23          
ATOM   1535  CA  LEU   199       1.601 -12.991  26.946  1.00 45.60          
ATOM   1536  C   LEU   199       1.181 -11.716  27.675  1.00 44.21          
ATOM   1537  O   LEU   199       1.519 -11.500  28.833  1.00 44.85          
ATOM   1538  CB  LEU   199       2.165 -14.024  27.925  1.00 44.96          
ATOM   1539  CG  LEU   199       1.253 -14.518  29.057  1.00 44.18          
ATOM   1540  CD1 LEU   199      -0.198 -14.656  28.608  1.00 43.89          
ATOM   1541  CD2 LEU   199       1.800 -15.840  29.538  1.00 45.05          
ATOM   1542  N   LEU   200       0.460 -10.863  26.959  1.00 41.66          
ATOM   1543  CA  LEU   200       0.026  -9.582  27.478  1.00 40.53          
ATOM   1544  C   LEU   200      -1.114  -9.672  28.479  1.00 39.77          
ATOM   1545  O   LEU   200      -2.234 -10.034  28.127  1.00 37.94          
ATOM   1546  CB  LEU   200      -0.372  -8.688  26.310  1.00 40.26          
ATOM   1547  CG  LEU   200      -0.657  -7.221  26.580  1.00 41.39          
ATOM   1548  CD1 LEU   200       0.606  -6.499  27.040  1.00 40.32          
ATOM   1549  CD2 LEU   200      -1.184  -6.590  25.299  1.00 42.87          
ATOM   1550  N   ILE   201      -0.821  -9.338  29.732  1.00 39.53          
ATOM   1551  CA  ILE   201      -1.838  -9.382  30.775  1.00 41.00          
ATOM   1552  C   ILE   201      -1.965  -8.007  31.463  1.00 40.72          
ATOM   1553  O   ILE   201      -0.981  -7.287  31.653  1.00 39.19          
ATOM   1554  CB  ILE   201      -1.542 -10.523  31.829  1.00 40.54          
ATOM   1555  CG1 ILE   201      -0.531 -10.072  32.855  1.00 40.51          
ATOM   1556  CG2 ILE   201      -0.955 -11.744  31.155  1.00 40.02          
ATOM   1557  CD  ILE   201      -1.170  -9.597  34.101  1.00 41.99          
ATOM   1558  N   GLY   202      -3.196  -7.644  31.809  1.00 41.71          
ATOM   1559  CA  GLY   202      -3.450  -6.372  32.457  1.00 42.46          
ATOM   1560  C   GLY   202      -4.338  -6.522  33.676  1.00 43.59          
ATOM   1561  O   GLY   202      -5.207  -7.391  33.711  1.00 43.17          
ATOM   1562  N   ILE   203      -4.107  -5.686  34.684  1.00 45.16          
ATOM   1563  CA  ILE   203      -4.900  -5.716  35.906  1.00 46.85          
ATOM   1564  C   ILE   203      -5.963  -4.638  35.810  1.00 48.66          
ATOM   1565  O   ILE   203      -5.655  -3.452  35.710  1.00 48.68          
ATOM   1566  CB  ILE   203      -4.041  -5.445  37.133  1.00 45.94          
ATOM   1567  CG1 ILE   203      -2.866  -6.419  37.179  1.00 46.14          
ATOM   1568  CG2 ILE   203      -4.882  -5.594  38.376  1.00 46.19          
ATOM   1569  CD  ILE   203      -1.912  -6.143  38.319  1.00 45.78          
ATOM   1570  N   GLU   204      -7.216  -5.058  35.849  1.00 51.48          
ATOM   1571  CA  GLU   204      -8.332  -4.138  35.715  1.00 55.82          
ATOM   1572  C   GLU   204      -9.114  -3.943  37.015  1.00 56.85          
ATOM   1573  O   GLU   204      -8.898  -4.644  37.995  1.00 56.30          
ATOM   1574  CB  GLU   204      -9.269  -4.675  34.637  1.00 59.26          
ATOM   1575  CG  GLU   204     -10.412  -3.758  34.261  1.00 64.70          
ATOM   1576  CD  GLU   204     -11.575  -4.512  33.653  1.00 67.29          
ATOM   1577  OE1 GLU   204     -12.163  -5.358  34.370  1.00 69.22          
ATOM   1578  OE2 GLU   204     -11.889  -4.257  32.466  1.00 68.13          
ATOM   1579  N   MET   205     -10.035  -2.988  37.010  1.00 58.68          
ATOM   1580  CA  MET   205     -10.855  -2.725  38.174  1.00 61.00          
ATOM   1581  C   MET   205     -11.885  -1.669  37.811  1.00 59.37          
ATOM   1582  O   MET   205     -11.719  -0.954  36.826  1.00 58.70          
ATOM   1583  CB  MET   205      -9.978  -2.261  39.332  1.00 66.33          
ATOM   1584  CG  MET   205      -9.104  -1.084  38.972  1.00 74.24          
ATOM   1585  SD  MET   205      -7.625  -0.835  40.201  1.00 86.23          
ATOM   1586  CE  MET   205      -8.641  -0.116  41.686  1.00 83.03          
ATOM   1587  N   SER   206     -12.954  -1.581  38.598  1.00 57.85          
ATOM   1588  CA  SER   206     -14.017  -0.622  38.331  1.00 57.29          
ATOM   1589  C   SER   206     -13.525   0.799  38.510  1.00 57.42          
ATOM   1590  O   SER   206     -12.622   1.049  39.304  1.00 57.34          
ATOM   1591  CB  SER   206     -15.212  -0.875  39.253  1.00 58.20          
ATOM   1592  OG  SER   206     -14.949  -0.485  40.595  1.00 58.30          
ATOM   1593  N   ARG   207     -14.121   1.732  37.774  1.00 57.81          
ATOM   1594  CA  ARG   207     -13.720   3.130  37.862  1.00 57.90          
ATOM   1595  C   ARG   207     -13.876   3.620  39.294  1.00 57.25          
ATOM   1596  O   ARG   207     -13.126   4.486  39.747  1.00 57.38          
ATOM   1597  CB  ARG   207     -14.567   4.018  36.933  1.00 59.77          
ATOM   1598  CG  ARG   207     -13.797   5.238  36.402  1.00 61.95          
ATOM   1599  CD  ARG   207     -14.603   6.536  36.316  1.00 63.77          
ATOM   1600  NE  ARG   207     -15.787   6.495  35.515  1.00 65.96          
ATOM   1601  CZ  ARG   207     -16.987   7.059  35.671  1.00 66.23          
ATOM   1602  NH1 ARG   207     -17.834   6.800  34.702  1.00 66.18          
ATOM   1603  NH2 ARG   207     -17.386   7.808  36.700  1.00 64.90          
ATOM   1604  N   GLU   208     -14.856   3.069  40.004  1.00 56.65          
ATOM   1605  CA  GLU   208     -15.097   3.463  41.387  1.00 56.14          
ATOM   1606  C   GLU   208     -13.862   3.162  42.237  1.00 55.10          
ATOM   1607  O   GLU   208     -13.262   4.069  42.819  1.00 54.75          
ATOM   1608  CB  GLU   208     -16.300   2.709  41.977  1.00 56.67          
ATOM   1609  CG  GLU   208     -17.676   2.979  41.343  1.00 57.91          
ATOM   1610  CD  GLU   208     -18.003   2.049  40.169  1.00 58.56          
ATOM   1611  OE1 GLU   208     -17.721   2.435  39.013  1.00 58.35          
ATOM   1612  OE2 GLU   208     -18.530   0.931  40.407  1.00 57.29          
ATOM   1613  N   THR   209     -13.490   1.883  42.301  1.00 54.16          
ATOM   1614  CA  THR   209     -12.340   1.456  43.092  1.00 53.60          
ATOM   1615  C   THR   209     -11.061   2.129  42.604  1.00 53.06          
ATOM   1616  O   THR   209     -10.239   2.571  43.400  1.00 52.72          
ATOM   1617  CB  THR   209     -12.153  -0.092  43.046  1.00 52.87          
ATOM   1618  OG1 THR   209     -13.366  -0.746  43.439  1.00 51.02          
ATOM   1619  CG2 THR   209     -11.043  -0.527  43.995  1.00 52.66          
ATOM   1620  N   LEU   210     -10.901   2.203  41.291  1.00 52.94          
ATOM   1621  CA  LEU   210      -9.730   2.828  40.703  1.00 52.98          
ATOM   1622  C   LEU   210      -9.528   4.235  41.261  1.00 52.71          
ATOM   1623  O   LEU   210      -8.509   4.528  41.891  1.00 52.92          
ATOM   1624  CB  LEU   210      -9.889   2.903  39.180  1.00 54.27          
ATOM   1625  CG  LEU   210      -8.820   3.668  38.374  1.00 54.83          
ATOM   1626  CD1 LEU   210      -7.497   2.944  38.513  1.00 56.79          
ATOM   1627  CD2 LEU   210      -9.212   3.773  36.904  1.00 53.90          
ATOM   1628  N   TYR   211     -10.512   5.097  41.028  1.00 52.09          
ATOM   1629  CA  TYR   211     -10.454   6.482  41.481  1.00 52.39          
ATOM   1630  C   TYR   211     -10.234   6.630  42.979  1.00 51.09          
ATOM   1631  O   TYR   211      -9.549   7.548  43.435  1.00 50.28          
ATOM   1632  CB  TYR   211     -11.728   7.237  41.061  1.00 54.07          
ATOM   1633  CG  TYR   211     -11.758   7.638  39.596  1.00 56.55          
ATOM   1634  CD1 TYR   211     -12.669   8.581  39.128  1.00 57.92          
ATOM   1635  CD2 TYR   211     -10.858   7.092  38.684  1.00 57.95          
ATOM   1636  CE1 TYR   211     -12.681   8.975  37.789  1.00 59.13          
ATOM   1637  CE2 TYR   211     -10.859   7.474  37.347  1.00 59.28          
ATOM   1638  CZ  TYR   211     -11.772   8.419  36.907  1.00 60.34          
ATOM   1639  OH  TYR   211     -11.763   8.810  35.586  1.00 61.94          
ATOM   1640  N   LEU   212     -10.808   5.721  43.748  1.00 50.37          
ATOM   1641  CA  LEU   212     -10.654   5.778  45.187  1.00 49.40          
ATOM   1642  C   LEU   212      -9.215   5.448  45.593  1.00 48.18          
ATOM   1643  O   LEU   212      -8.628   6.134  46.430  1.00 47.77          
ATOM   1644  CB  LEU   212     -11.630   4.805  45.834  1.00 50.41          
ATOM   1645  CG  LEU   212     -11.704   4.886  47.349  1.00 51.44          
ATOM   1646  CD1 LEU   212     -12.122   6.288  47.772  1.00 51.12          
ATOM   1647  CD2 LEU   212     -12.696   3.850  47.841  1.00 52.30          
ATOM   1648  N   ARG   213      -8.648   4.411  44.982  1.00 47.23          
ATOM   1649  CA  ARG   213      -7.288   3.993  45.291  1.00 45.81          
ATOM   1650  C   ARG   213      -6.283   5.054  44.893  1.00 45.00          
ATOM   1651  O   ARG   213      -5.316   5.301  45.618  1.00 45.34          
ATOM   1652  CB  ARG   213      -6.953   2.680  44.589  1.00 46.12          
ATOM   1653  CG  ARG   213      -7.893   1.561  44.947  1.00 47.50          
ATOM   1654  CD  ARG   213      -7.285   0.226  44.633  1.00 49.26          
ATOM   1655  NE  ARG   213      -6.204  -0.149  45.481  1.00 50.85          
ATOM   1656  CZ  ARG   213      -4.999  -0.646  45.219  1.00 52.07          
ATOM   1657  NH1 ARG   213      -4.277  -0.882  46.291  1.00 51.27          
ATOM   1658  NH2 ARG   213      -4.484  -0.876  44.015  1.00 52.18          
ATOM   1659  N   ILE   214      -6.505   5.677  43.740  1.00 42.90          
ATOM   1660  CA  ILE   214      -5.607   6.723  43.284  1.00 42.58          
ATOM   1661  C   ILE   214      -5.609   7.858  44.301  1.00 44.04          
ATOM   1662  O   ILE   214      -4.549   8.290  44.754  1.00 44.37          
ATOM   1663  CB  ILE   214      -6.015   7.257  41.894  1.00 42.38          
ATOM   1664  CG1 ILE   214      -5.905   6.130  40.856  1.00 41.56          
ATOM   1665  CG2 ILE   214      -5.131   8.432  41.499  1.00 40.53          
ATOM   1666  CD  ILE   214      -6.409   6.490  39.488  1.00 40.18          
ATOM   1667  N   ASN   215      -6.780   8.339  44.694  1.00 44.37          
ATOM   1668  CA  ASN   215      -6.782   9.402  45.689  1.00 46.12          
ATOM   1669  C   ASN   215      -5.987   8.978  46.906  1.00 45.68          
ATOM   1670  O   ASN   215      -5.266   9.777  47.492  1.00 45.52          
ATOM   1671  CB  ASN   215      -8.198   9.764  46.118  1.00 47.65          
ATOM   1672  CG  ASN   215      -9.003  10.321  44.984  1.00 49.26          
ATOM   1673  OD1 ASN   215      -8.501  11.116  44.187  1.00 50.48          
ATOM   1674  ND2 ASN   215     -10.263   9.922  44.902  1.00 50.51          
ATOM   1675  N   LYS   216      -6.107   7.711  47.274  1.00 45.88          
ATOM   1676  CA  LYS   216      -5.394   7.213  48.435  1.00 46.84          
ATOM   1677  C   LYS   216      -3.888   7.081  48.215  1.00 46.74          
ATOM   1678  O   LYS   216      -3.116   7.192  49.158  1.00 46.10          
ATOM   1679  CB  LYS   216      -5.984   5.876  48.880  1.00 48.06          
ATOM   1680  CG  LYS   216      -5.384   5.354  50.172  1.00 51.11          
ATOM   1681  CD  LYS   216      -6.408   4.614  51.040  1.00 52.88          
ATOM   1682  CE  LYS   216      -5.802   4.179  52.382  1.00 52.11          
ATOM   1683  NZ  LYS   216      -6.811   3.570  53.287  1.00 51.76          
ATOM   1684  N   ARG   217      -3.464   6.859  46.978  1.00 47.09          
ATOM   1685  CA  ARG   217      -2.040   6.725  46.708  1.00 47.24          
ATOM   1686  C   ARG   217      -1.372   8.088  46.677  1.00 46.13          
ATOM   1687  O   ARG   217      -0.179   8.219  46.959  1.00 46.25          
ATOM   1688  CB  ARG   217      -1.820   6.000  45.388  1.00 48.37          
ATOM   1689  CG  ARG   217      -0.383   5.876  44.976  1.00 50.40          
ATOM   1690  CD  ARG   217      -0.312   5.084  43.691  1.00 55.04          
ATOM   1691  NE  ARG   217      -1.153   5.631  42.611  1.00 58.04          
ATOM   1692  CZ  ARG   217      -0.829   6.677  41.851  1.00 58.71          
ATOM   1693  NH1 ARG   217      -1.659   7.091  40.896  1.00 58.58          
ATOM   1694  NH2 ARG   217       0.322   7.310  42.050  1.00 58.89          
ATOM   1695  N   VAL   218      -2.145   9.108  46.333  1.00 46.00          
ATOM   1696  CA  VAL   218      -1.609  10.455  46.284  1.00 46.08          
ATOM   1697  C   VAL   218      -1.417  10.905  47.725  1.00 47.54          
ATOM   1698  O   VAL   218      -0.449  11.586  48.042  1.00 46.77          
ATOM   1699  CB  VAL   218      -2.564  11.419  45.510  1.00 44.61          
ATOM   1700  CG1 VAL   218      -2.020  12.835  45.537  1.00 44.97          
ATOM   1701  CG2 VAL   218      -2.703  10.968  44.068  1.00 41.49          
ATOM   1702  N   ASP   219      -2.329  10.501  48.608  1.00 49.53          
ATOM   1703  CA  ASP   219      -2.219  10.875  50.019  1.00 50.83          
ATOM   1704  C   ASP   219      -0.959  10.273  50.608  1.00 51.42          
ATOM   1705  O   ASP   219      -0.230  10.942  51.334  1.00 52.60          
ATOM   1706  CB  ASP   219      -3.429  10.395  50.829  1.00 51.95          
ATOM   1707  CG  ASP   219      -4.704  11.146  50.482  1.00 54.27          
ATOM   1708  OD1 ASP   219      -4.604  12.292  49.978  1.00 54.93          
ATOM   1709  OD2 ASP   219      -5.813  10.598  50.730  1.00 54.88          
ATOM   1710  N   ILE   220      -0.704   9.007  50.298  1.00 50.93          
ATOM   1711  CA  ILE   220       0.475   8.335  50.820  1.00 50.35          
ATOM   1712  C   ILE   220       1.763   8.987  50.330  1.00 50.83          
ATOM   1713  O   ILE   220       2.692   9.191  51.107  1.00 49.12          
ATOM   1714  CB  ILE   220       0.489   6.861  50.422  1.00 50.25          
ATOM   1715  CG1 ILE   220      -0.829   6.199  50.819  1.00 49.65          
ATOM   1716  CG2 ILE   220       1.650   6.162  51.101  1.00 49.47          
ATOM   1717  CD  ILE   220      -0.965   4.771  50.337  1.00 48.90          
ATOM   1718  N   MET   221       1.819   9.308  49.040  1.00 52.75          
ATOM   1719  CA  MET   221       3.011   9.936  48.478  1.00 54.09          
ATOM   1720  C   MET   221       3.341  11.226  49.222  1.00 53.07          
ATOM   1721  O   MET   221       4.496  11.462  49.582  1.00 53.63          
ATOM   1722  CB  MET   221       2.829  10.262  46.996  1.00 57.37          
ATOM   1723  CG  MET   221       2.482   9.089  46.099  1.00 61.31          
ATOM   1724  SD  MET   221       2.805   9.516  44.215  1.00 68.30          
ATOM   1725  CE  MET   221       1.657  11.071  43.994  1.00 66.79          
ATOM   1726  N   LEU   222       2.329  12.066  49.435  1.00 51.20          
ATOM   1727  CA  LEU   222       2.529  13.324  50.144  1.00 48.78          
ATOM   1728  C   LEU   222       3.049  12.992  51.524  1.00 47.82          
ATOM   1729  O   LEU   222       3.943  13.657  52.041  1.00 46.99          
ATOM   1730  CB  LEU   222       1.211  14.101  50.261  1.00 47.68          
ATOM   1731  CG  LEU   222       0.761  14.988  49.091  1.00 47.08          
ATOM   1732  CD1 LEU   222       1.733  16.140  48.895  1.00 47.95          
ATOM   1733  CD2 LEU   222       0.673  14.168  47.838  1.00 47.74          
ATOM   1734  N   GLY   223       2.490  11.934  52.102  1.00 47.54          
ATOM   1735  CA  GLY   223       2.885  11.507  53.429  1.00 46.72          
ATOM   1736  C   GLY   223       4.254  10.872  53.473  1.00 47.26          
ATOM   1737  O   GLY   223       4.836  10.750  54.540  1.00 46.92          
ATOM   1738  N   HSD   224       4.783  10.465  52.326  1.00 48.55          
ATOM   1739  CA  HSD   224       6.096   9.847  52.324  1.00 49.09          
ATOM   1740  C   HSD   224       7.240  10.792  51.959  1.00 49.59          
ATOM   1741  O   HSD   224       8.401  10.389  51.959  1.00 50.22          
ATOM   1742  CB  HSD   224       6.102   8.628  51.408  1.00 50.46          
ATOM   1743  CG  HSD   224       5.612   7.376  52.070  1.00 52.48          
ATOM   1744  ND1 HSD   224       5.705   6.134  51.476  1.00 53.25          
ATOM   1745  CD2 HSD   224       5.035   7.170  53.278  1.00 52.96          
ATOM   1746  CE1 HSD   224       5.207   5.219  52.288  1.00 52.93          
ATOM   1747  NE2 HSD   224       4.793   5.821  53.389  1.00 53.58          
ATOM   1748  N   GLY   225       6.922  12.046  51.652  1.00 48.30          
ATOM   1749  CA  GLY   225       7.965  12.995  51.318  1.00 48.19          
ATOM   1750  C   GLY   225       8.060  13.385  49.858  1.00 48.65          
ATOM   1751  O   GLY   225       9.127  13.797  49.398  1.00 48.46          
ATOM   1752  N   LEU   226       6.955  13.245  49.126  1.00 49.00          
ATOM   1753  CA  LEU   226       6.908  13.607  47.703  1.00 48.60          
ATOM   1754  C   LEU   226       7.306  15.064  47.518  1.00 48.18          
ATOM   1755  O   LEU   226       8.145  15.389  46.681  1.00 47.55          
ATOM   1756  CB  LEU   226       5.495  13.408  47.131  1.00 46.67          
ATOM   1757  CG  LEU   226       5.224  14.068  45.771  1.00 46.21          
ATOM   1758  CD1 LEU   226       6.161  13.498  44.722  1.00 44.40          
ATOM   1759  CD2 LEU   226       3.772  13.858  45.362  1.00 45.96          
ATOM   1760  N   PHE   227       6.690  15.939  48.303  1.00 48.68          
ATOM   1761  CA  PHE   227       6.985  17.353  48.209  1.00 49.66          
ATOM   1762  C   PHE   227       8.466  17.600  48.501  1.00 50.70          
ATOM   1763  O   PHE   227       9.099  18.414  47.833  1.00 51.23          
ATOM   1764  CB  PHE   227       6.100  18.141  49.178  1.00 49.58          
ATOM   1765  CG  PHE   227       6.176  19.632  49.000  1.00 49.04          
ATOM   1766  CD1 PHE   227       7.235  20.359  49.538  1.00 49.30          
ATOM   1767  CD2 PHE   227       5.205  20.306  48.266  1.00 49.29          
ATOM   1768  CE1 PHE   227       7.327  21.743  49.355  1.00 49.51          
ATOM   1769  CE2 PHE   227       5.285  21.687  48.077  1.00 49.75          
ATOM   1770  CZ  PHE   227       6.354  22.409  48.620  1.00 49.71          
ATOM   1771  N   ASN   228       9.027  16.894  49.480  1.00 50.89          
ATOM   1772  CA  ASN   228      10.435  17.082  49.808  1.00 51.21          
ATOM   1773  C   ASN   228      11.299  16.702  48.605  1.00 51.40          
ATOM   1774  O   ASN   228      12.339  17.312  48.347  1.00 50.59          
ATOM   1775  CB  ASN   228      10.834  16.227  51.009  1.00 52.09          
ATOM   1776  CG  ASN   228      12.219  16.566  51.521  1.00 53.59          
ATOM   1777  OD1 ASN   228      12.820  15.809  52.281  1.00 54.96          
ATOM   1778  ND2 ASN   228      12.733  17.718  51.109  1.00 55.01          
ATOM   1779  N   GLU   229      10.853  15.695  47.866  1.00 51.04          
ATOM   1780  CA  GLU   229      11.586  15.244  46.706  1.00 51.72          
ATOM   1781  C   GLU   229      11.588  16.311  45.614  1.00 52.23          
ATOM   1782  O   GLU   229      12.655  16.693  45.128  1.00 53.72          
ATOM   1783  CB  GLU   229      10.979  13.954  46.175  1.00 52.05          
ATOM   1784  CG  GLU   229      11.899  13.129  45.301  1.00 52.84          
ATOM   1785  CD  GLU   229      11.213  11.880  44.807  1.00 53.57          
ATOM   1786  OE1 GLU   229      10.385  11.998  43.877  1.00 54.71          
ATOM   1787  OE2 GLU   229      11.478  10.787  45.357  1.00 52.14          
ATOM   1788  N   VAL   230      10.411  16.805  45.229  1.00 51.22          
ATOM   1789  CA  VAL   230      10.349  17.821  44.184  1.00 50.77          
ATOM   1790  C   VAL   230      11.131  19.055  44.597  1.00 50.92          
ATOM   1791  O   VAL   230      11.509  19.868  43.758  1.00 50.86          
ATOM   1792  CB  VAL   230       8.906  18.250  43.857  1.00 49.81          
ATOM   1793  CG1 VAL   230       8.028  17.040  43.649  1.00 50.73          
ATOM   1794  CG2 VAL   230       8.371  19.127  44.939  1.00 51.11          
ATOM   1795  N   GLN   231      11.382  19.188  45.894  1.00 51.90          
ATOM   1796  CA  GLN   231      12.138  20.326  46.401  1.00 52.73          
ATOM   1797  C   GLN   231      13.605  20.151  46.074  1.00 52.44          
ATOM   1798  O   GLN   231      14.255  21.086  45.636  1.00 52.48          
ATOM   1799  CB  GLN   231      11.968  20.457  47.914  1.00 53.42          
ATOM   1800  CG  GLN   231      10.643  21.061  48.363  1.00 53.33          
ATOM   1801  CD  GLN   231      10.629  21.347  49.861  1.00 53.59          
ATOM   1802  OE1 GLN   231      10.758  20.433  50.678  1.00 52.65          
ATOM   1803  NE2 GLN   231      10.476  22.620  50.225  1.00 53.06          
ATOM   1804  N   HSD   232      14.119  18.949  46.296  1.00 52.83          
ATOM   1805  CA  HSD   232      15.516  18.668  46.014  1.00 54.59          
ATOM   1806  C   HSD   232      15.772  18.771  44.522  1.00 54.60          
ATOM   1807  O   HSD   232      16.822  19.255  44.092  1.00 55.63          
ATOM   1808  CB  HSD   232      15.883  17.271  46.496  1.00 57.52          
ATOM   1809  CG  HSD   232      15.827  17.112  47.986  1.00 61.50          
ATOM   1810  ND1 HSD   232      15.522  15.912  48.596  1.00 62.41          
ATOM   1811  CD2 HSD   232      16.055  17.995  48.991  1.00 62.97          
ATOM   1812  CE1 HSD   232      15.564  16.062  49.910  1.00 63.57          
ATOM   1813  NE2 HSD   232      15.886  17.316  50.176  1.00 63.76          
ATOM   1814  N   LEU   233      14.814  18.311  43.724  1.00 54.34          
ATOM   1815  CA  LEU   233      14.948  18.351  42.267  1.00 53.56          
ATOM   1816  C   LEU   233      14.915  19.773  41.744  1.00 53.10          
ATOM   1817  O   LEU   233      15.781  20.168  40.973  1.00 53.07          
ATOM   1818  CB  LEU   233      13.830  17.547  41.616  1.00 53.05          
ATOM   1819  CG  LEU   233      13.928  16.035  41.776  1.00 53.98          
ATOM   1820  CD1 LEU   233      12.601  15.396  41.410  1.00 54.57          
ATOM   1821  CD2 LEU   233      15.049  15.502  40.893  1.00 53.99          
ATOM   1822  N   VAL   234      13.908  20.533  42.160  1.00 53.72          
ATOM   1823  CA  VAL   234      13.772  21.911  41.720  1.00 54.50          
ATOM   1824  C   VAL   234      14.955  22.759  42.197  1.00 55.31          
ATOM   1825  O   VAL   234      15.336  23.719  41.538  1.00 55.74          
ATOM   1826  CB  VAL   234      12.433  22.518  42.204  1.00 53.90          
ATOM   1827  CG1 VAL   234      12.458  22.698  43.704  1.00 56.91          
ATOM   1828  CG2 VAL   234      12.178  23.828  41.514  1.00 54.67          
ATOM   1829  N   GLU   235      15.539  22.398  43.334  1.00 56.55          
ATOM   1830  CA  GLU   235      16.690  23.125  43.862  1.00 58.23          
ATOM   1831  C   GLU   235      17.933  22.818  43.029  1.00 58.14          
ATOM   1832  O   GLU   235      18.782  23.685  42.822  1.00 58.69          
ATOM   1833  CB  GLU   235      16.941  22.758  45.333  1.00 60.13          
ATOM   1834  CG  GLU   235      16.176  23.627  46.343  1.00 63.27          
ATOM   1835  CD  GLU   235      16.297  23.141  47.793  1.00 65.19          
ATOM   1836  OE1 GLU   235      15.981  23.935  48.716  1.00 64.07          
ATOM   1837  OE2 GLU   235      16.690  21.967  48.007  1.00 66.28          
ATOM   1838  N   GLN   236      18.039  21.584  42.548  1.00 57.92          
ATOM   1839  CA  GLN   236      19.172  21.193  41.718  1.00 58.19          
ATOM   1840  C   GLN   236      19.008  21.716  40.289  1.00 58.15          
ATOM   1841  O   GLN   236      19.696  21.276  39.366  1.00 58.41          
ATOM   1842  CB  GLN   236      19.319  19.675  41.714  1.00 57.21          
ATOM   1843  CG  GLN   236      19.913  19.154  42.992  1.00 59.59          
ATOM   1844  CD  GLN   236      19.697  17.669  43.162  1.00 62.56          
ATOM   1845  OE1 GLN   236      18.555  17.205  43.234  1.00 64.35          
ATOM   1846  NE2 GLN   236      20.791  16.909  43.237  1.00 62.86          
ATOM   1847  N   GLY   237      18.081  22.656  40.120  1.00 57.82          
ATOM   1848  CA  GLY   237      17.834  23.252  38.823  1.00 55.54          
ATOM   1849  C   GLY   237      17.242  22.339  37.777  1.00 55.47          
ATOM   1850  O   GLY   237      17.083  22.752  36.627  1.00 55.87          
ATOM   1851  N   PHE   238      16.909  21.108  38.150  1.00 54.70          
ATOM   1852  CA  PHE   238      16.333  20.175  37.186  1.00 54.43          
ATOM   1853  C   PHE   238      14.965  20.597  36.686  1.00 54.15          
ATOM   1854  O   PHE   238      14.288  19.833  36.016  1.00 54.72          
ATOM   1855  CB  PHE   238      16.248  18.776  37.778  1.00 55.06          
ATOM   1856  CG  PHE   238      17.564  18.088  37.871  1.00 55.44          
ATOM   1857  CD1 PHE   238      18.398  18.015  36.769  1.00 55.52          
ATOM   1858  CD2 PHE   238      17.956  17.473  39.050  1.00 57.40          
ATOM   1859  CE1 PHE   238      19.610  17.327  36.837  1.00 56.79          
ATOM   1860  CE2 PHE   238      19.170  16.778  39.135  1.00 58.19          
ATOM   1861  CZ  PHE   238      19.997  16.706  38.026  1.00 57.47          
ATOM   1862  N   GLU   239      14.561  21.814  37.019  1.00 54.78          
ATOM   1863  CA  GLU   239      13.286  22.357  36.580  1.00 55.30          
ATOM   1864  C   GLU   239      13.415  22.627  35.071  1.00 55.95          
ATOM   1865  O   GLU   239      14.525  22.618  34.540  1.00 56.90          
ATOM   1866  CB  GLU   239      13.040  23.654  37.338  1.00 56.17          
ATOM   1867  CG  GLU   239      11.688  24.276  37.127  1.00 58.62          
ATOM   1868  CD  GLU   239      11.557  25.627  37.821  1.00 60.91          
ATOM   1869  OE1 GLU   239      12.351  25.889  38.762  1.00 59.94          
ATOM   1870  OE2 GLU   239      10.650  26.411  37.436  1.00 60.79          
ATOM   1871  N   ALA   240      12.301  22.865  34.384  1.00 54.47          
ATOM   1872  CA  ALA   240      12.335  23.137  32.950  1.00 53.29          
ATOM   1873  C   ALA   240      12.608  21.881  32.109  1.00 52.86          
ATOM   1874  O   ALA   240      12.584  21.917  30.869  1.00 51.49          
ATOM   1875  CB  ALA   240      13.383  24.219  32.646  1.00 51.46          
ATOM   1876  N   SER   241      12.863  20.770  32.795  1.00 52.63          
ATOM   1877  CA  SER   241      13.141  19.487  32.150  1.00 52.57          
ATOM   1878  C   SER   241      11.859  18.723  31.846  1.00 52.68          
ATOM   1879  O   SER   241      10.835  18.927  32.496  1.00 53.04          
ATOM   1880  CB  SER   241      14.023  18.630  33.060  1.00 51.54          
ATOM   1881  OG  SER   241      15.177  19.335  33.450  1.00 50.84          
ATOM   1882  N   GLN   242      11.921  17.833  30.867  1.00 53.10          
ATOM   1883  CA  GLN   242      10.756  17.044  30.494  1.00 53.88          
ATOM   1884  C   GLN   242      10.242  16.263  31.687  1.00 54.11          
ATOM   1885  O   GLN   242       9.048  16.248  31.968  1.00 54.86          
ATOM   1886  CB  GLN   242      11.121  16.079  29.365  1.00 55.50          
ATOM   1887  CG  GLN   242      10.373  14.752  29.387  1.00 56.34          
ATOM   1888  CD  GLN   242      10.874  13.787  28.333  1.00 56.34          
ATOM   1889  OE1 GLN   242      12.054  13.449  28.295  1.00 56.46          
ATOM   1890  NE2 GLN   242       9.975  13.343  27.465  1.00 57.42          
ATOM   1891  N   SER   243      11.153  15.610  32.394  1.00 54.24          
ATOM   1892  CA  SER   243      10.773  14.819  33.554  1.00 53.83          
ATOM   1893  C   SER   243       9.962  15.619  34.578  1.00 54.07          
ATOM   1894  O   SER   243       8.988  15.111  35.121  1.00 53.71          
ATOM   1895  CB  SER   243      12.025  14.264  34.206  1.00 53.39          
ATOM   1896  OG  SER   243      12.933  15.318  34.435  1.00 54.65          
ATOM   1897  N   MET   244      10.358  16.866  34.835  1.00 54.91          
ATOM   1898  CA  MET   244       9.664  17.713  35.810  1.00 55.19          
ATOM   1899  C   MET   244       8.284  18.155  35.370  1.00 53.27          
ATOM   1900  O   MET   244       7.635  18.944  36.058  1.00 52.57          
ATOM   1901  CB  MET   244      10.485  18.962  36.112  1.00 60.45          
ATOM   1902  CG  MET   244      11.764  18.715  36.878  1.00 66.90          
ATOM   1903  SD  MET   244      11.481  18.227  38.722  1.00 76.91          
ATOM   1904  CE  MET   244      11.439  19.994  39.505  1.00 74.29          
ATOM   1905  N   GLN   245       7.845  17.657  34.218  1.00 52.02          
ATOM   1906  CA  GLN   245       6.538  18.002  33.662  1.00 50.21          
ATOM   1907  C   GLN   245       5.555  16.882  33.851  1.00 49.21          
ATOM   1908  O   GLN   245       4.385  17.019  33.509  1.00 49.73          
ATOM   1909  CB  GLN   245       6.667  18.312  32.173  1.00 49.10          
ATOM   1910  CG  GLN   245       7.278  19.652  31.894  1.00 48.85          
ATOM   1911  CD  GLN   245       6.407  20.759  32.420  1.00 49.81          
ATOM   1912  OE1 GLN   245       5.255  20.891  32.015  1.00 51.70          
ATOM   1913  NE2 GLN   245       6.944  21.564  33.330  1.00 50.84          
ATOM   1914  N   ALA   246       6.041  15.767  34.383  1.00 49.21          
ATOM   1915  CA  ALA   246       5.190  14.602  34.612  1.00 49.16          
ATOM   1916  C   ALA   246       4.235  14.858  35.766  1.00 48.33          
ATOM   1917  O   ALA   246       4.560  15.586  36.709  1.00 47.49          
ATOM   1918  CB  ALA   246       6.041  13.373  34.907  1.00 48.23          
ATOM   1919  N   ILE   247       3.053  14.257  35.684  1.00 47.65          
ATOM   1920  CA  ILE   247       2.060  14.423  36.725  1.00 46.43          
ATOM   1921  C   ILE   247       2.682  14.001  38.062  1.00 45.24          
ATOM   1922  O   ILE   247       3.232  12.906  38.193  1.00 43.81          
ATOM   1923  CB  ILE   247       0.783  13.592  36.405  1.00 46.72          
ATOM   1924  CG1 ILE   247       0.287  12.915  37.681  1.00 47.64          
ATOM   1925  CG2 ILE   247       1.049  12.611  35.247  1.00 46.66          
ATOM   1926  CD  ILE   247      -0.708  11.809  37.439  1.00 50.82          
ATOM   1927  N   GLY   248       2.611  14.896  39.040  1.00 44.32          
ATOM   1928  CA  GLY   248       3.194  14.618  40.338  1.00 44.63          
ATOM   1929  C   GLY   248       4.406  15.502  40.631  1.00 43.81          
ATOM   1930  O   GLY   248       4.998  15.439  41.706  1.00 43.85          
ATOM   1931  N   TYR   249       4.786  16.326  39.668  1.00 43.00          
ATOM   1932  CA  TYR   249       5.906  17.209  39.852  1.00 42.47          
ATOM   1933  C   TYR   249       5.543  18.571  39.321  1.00 44.75          
ATOM   1934  O   TYR   249       5.803  19.581  39.971  1.00 46.97          
ATOM   1935  CB  TYR   249       7.158  16.700  39.130  1.00 39.81          
ATOM   1936  CG  TYR   249       7.706  15.406  39.667  1.00 36.35          
ATOM   1937  CD1 TYR   249       7.136  14.201  39.319  1.00 35.98          
ATOM   1938  CD2 TYR   249       8.783  15.392  40.535  1.00 34.84          
ATOM   1939  CE1 TYR   249       7.625  13.006  39.818  1.00 36.42          
ATOM   1940  CE2 TYR   249       9.283  14.202  41.043  1.00 35.06          
ATOM   1941  CZ  TYR   249       8.700  13.011  40.676  1.00 35.44          
ATOM   1942  OH  TYR   249       9.197  11.819  41.146  1.00 35.17          
ATOM   1943  N   LYS   250       4.931  18.609  38.142  1.00 45.83          
ATOM   1944  CA  LYS   250       4.546  19.883  37.540  1.00 46.38          
ATOM   1945  C   LYS   250       3.497  20.619  38.381  1.00 46.13          
ATOM   1946  O   LYS   250       3.433  21.845  38.349  1.00 47.15          
ATOM   1947  CB  LYS   250       4.017  19.679  36.108  1.00 47.06          
ATOM   1948  CG  LYS   250       2.721  18.900  36.022  1.00 48.18          
ATOM   1949  CD  LYS   250       2.125  18.891  34.618  1.00 47.37          
ATOM   1950  CE  LYS   250       0.813  18.109  34.616  1.00 47.67          
ATOM   1951  NZ  LYS   250       0.166  18.049  33.283  1.00 48.34          
ATOM   1952  N   GLU   251       2.692  19.882  39.145  1.00 45.84          
ATOM   1953  CA  GLU   251       1.669  20.512  39.974  1.00 45.20          
ATOM   1954  C   GLU   251       2.257  21.083  41.245  1.00 43.71          
ATOM   1955  O   GLU   251       1.835  22.130  41.721  1.00 42.83          
ATOM   1956  CB  GLU   251       0.565  19.517  40.338  1.00 46.13          
ATOM   1957  CG  GLU   251      -0.155  18.934  39.135  1.00 48.53          
ATOM   1958  CD  GLU   251       0.410  17.596  38.709  1.00 49.88          
ATOM   1959  OE1 GLU   251       1.544  17.265  39.138  1.00 50.12          
ATOM   1960  OE2 GLU   251      -0.278  16.889  37.932  1.00 49.85          
ATOM   1961  N   LEU   252       3.245  20.390  41.788  1.00 43.53          
ATOM   1962  CA  LEU   252       3.886  20.831  43.012  1.00 42.57          
ATOM   1963  C   LEU   252       4.928  21.922  42.821  1.00 42.00          
ATOM   1964  O   LEU   252       5.227  22.648  43.756  1.00 42.30          
ATOM   1965  CB  LEU   252       4.512  19.635  43.736  1.00 41.74          
ATOM   1966  CG  LEU   252       3.547  18.511  44.150  1.00 41.92          
ATOM   1967  CD1 LEU   252       4.312  17.378  44.828  1.00 42.76          
ATOM   1968  CD2 LEU   252       2.494  19.048  45.086  1.00 40.89          
ATOM   1969  N   VAL   253       5.494  22.055  41.630  1.00 42.00          
ATOM   1970  CA  VAL   253       6.506  23.098  41.440  1.00 42.95          
ATOM   1971  C   VAL   253       5.957  24.484  41.772  1.00 44.10          
ATOM   1972  O   VAL   253       6.607  25.265  42.460  1.00 44.41          
ATOM   1973  CB  VAL   253       7.078  23.119  39.992  1.00 41.99          
ATOM   1974  CG1 VAL   253       8.115  24.221  39.854  1.00 39.96          
ATOM   1975  CG2 VAL   253       7.720  21.787  39.669  1.00 42.77          
ATOM   1976  N   PRO   254       4.743  24.805  41.291  1.00 45.20          
ATOM   1977  CA  PRO   254       4.124  26.111  41.551  1.00 45.81          
ATOM   1978  C   PRO   254       3.925  26.422  43.034  1.00 45.87          
ATOM   1979  O   PRO   254       4.113  27.558  43.471  1.00 46.34          
ATOM   1980  CB  PRO   254       2.789  26.018  40.804  1.00 45.36          
ATOM   1981  CG  PRO   254       3.108  25.114  39.670  1.00 45.40          
ATOM   1982  CD  PRO   254       3.917  24.032  40.348  1.00 46.25          
ATOM   1983  N   VAL   255       3.555  25.407  43.804  1.00 45.65          
ATOM   1984  CA  VAL   255       3.323  25.591  45.224  1.00 46.52          
ATOM   1985  C   VAL   255       4.634  25.881  45.971  1.00 45.46          
ATOM   1986  O   VAL   255       4.631  26.462  47.057  1.00 44.66          
ATOM   1987  CB  VAL   255       2.562  24.354  45.825  1.00 46.99          
ATOM   1988  CG1 VAL   255       3.439  23.133  45.793  1.00 48.49          
ATOM   1989  CG2 VAL   255       2.109  24.654  47.237  1.00 49.86          
ATOM   1990  N   ILE   256       5.751  25.507  45.362  1.00 45.49          
ATOM   1991  CA  ILE   256       7.056  25.745  45.954  1.00 46.29          
ATOM   1992  C   ILE   256       7.435  27.214  45.784  1.00 47.82          
ATOM   1993  O   ILE   256       8.270  27.754  46.516  1.00 48.39          
ATOM   1994  CB  ILE   256       8.130  24.897  45.280  1.00 46.02          
ATOM   1995  CG1 ILE   256       7.762  23.427  45.383  1.00 47.63          
ATOM   1996  CG2 ILE   256       9.468  25.123  45.943  1.00 46.15          
ATOM   1997  CD  ILE   256       8.770  22.513  44.697  1.00 47.88          
ATOM   1998  N   LYS   257       6.808  27.856  44.811  1.00 47.54          
ATOM   1999  CA  LYS   257       7.057  29.256  44.529  1.00 48.04          
ATOM   2000  C   LYS   257       6.095  30.144  45.315  1.00 47.94          
ATOM   2001  O   LYS   257       6.389  31.307  45.602  1.00 48.31          
ATOM   2002  CB  LYS   257       6.926  29.490  43.023  1.00 49.79          
ATOM   2003  CG  LYS   257       7.852  28.570  42.220  1.00 51.05          
ATOM   2004  CD  LYS   257       7.865  28.896  40.744  1.00 51.18          
ATOM   2005  CE  LYS   257       8.949  28.114  40.016  1.00 52.26          
ATOM   2006  NZ  LYS   257       8.908  28.350  38.537  1.00 51.23          
ATOM   2007  N   GLY   258       4.946  29.582  45.669  1.00 46.79          
ATOM   2008  CA  GLY   258       3.973  30.325  46.436  1.00 45.83          
ATOM   2009  C   GLY   258       2.921  30.953  45.554  1.00 45.01          
ATOM   2010  O   GLY   258       2.265  31.921  45.944  1.00 44.91          
ATOM   2011  N   ASN   259       2.756  30.414  44.356  1.00 43.60          
ATOM   2012  CA  ASN   259       1.757  30.948  43.445  1.00 43.75          
ATOM   2013  C   ASN   259       0.458  30.169  43.563  1.00 43.71          
ATOM   2014  O   ASN   259      -0.609  30.661  43.208  1.00 42.68          
ATOM   2015  CB  ASN   259       2.277  30.909  42.009  1.00 43.72          
ATOM   2016  CG  ASN   259       3.456  31.826  41.802  1.00 44.15          
ATOM   2017  OD1 ASN   259       4.545  31.383  41.428  1.00 45.04          
ATOM   2018  ND2 ASN   259       3.254  33.113  42.060  1.00 43.19          
ATOM   2019  N   ILE   260       0.550  28.954  44.081  1.00 43.37          
ATOM   2020  CA  ILE   260      -0.637  28.137  44.252  1.00 43.46          
ATOM   2021  C   ILE   260      -0.611  27.477  45.638  1.00 43.92          
ATOM   2022  O   ILE   260       0.465  27.206  46.190  1.00 42.74          
ATOM   2023  CB  ILE   260      -0.726  27.095  43.115  1.00 43.21          
ATOM   2024  CG1 ILE   260      -1.974  26.234  43.282  1.00 43.70          
ATOM   2025  CG2 ILE   260       0.541  26.255  43.068  1.00 43.86          
ATOM   2026  CD  ILE   260      -2.181  25.234  42.160  1.00 44.18          
ATOM   2027  N   SER   261      -1.789  27.245  46.219  1.00 44.15          
ATOM   2028  CA  SER   261      -1.874  26.646  47.560  1.00 44.65          
ATOM   2029  C   SER   261      -1.703  25.141  47.512  1.00 44.60          
ATOM   2030  O   SER   261      -2.022  24.509  46.516  1.00 44.23          
ATOM   2031  CB  SER   261      -3.218  26.984  48.215  1.00 43.24          
ATOM   2032  OG  SER   261      -4.290  26.404  47.507  1.00 43.70          
ATOM   2033  N   MET   262      -1.201  24.572  48.599  1.00 46.15          
ATOM   2034  CA  MET   262      -0.993  23.135  48.663  1.00 47.95          
ATOM   2035  C   MET   262      -2.303  22.393  48.419  1.00 46.17          
ATOM   2036  O   MET   262      -2.341  21.413  47.676  1.00 45.54          
ATOM   2037  CB  MET   262      -0.418  22.746  50.029  1.00 51.56          
ATOM   2038  CG  MET   262      -0.078  21.262  50.196  1.00 56.73          
ATOM   2039  SD  MET   262       1.519  20.694  49.227  1.00 68.54          
ATOM   2040  CE  MET   262       0.661  20.288  47.543  1.00 64.64          
ATOM   2041  N   GLU   263      -3.376  22.871  49.040  1.00 45.51          
ATOM   2042  CA  GLU   263      -4.690  22.247  48.899  1.00 45.04          
ATOM   2043  C   GLU   263      -5.118  22.133  47.447  1.00 44.37          
ATOM   2044  O   GLU   263      -5.347  21.035  46.935  1.00 42.41          
ATOM   2045  CB  GLU   263      -5.738  23.045  49.678  1.00 45.88          
ATOM   2046  CG  GLU   263      -5.523  23.008  51.187  1.00 48.51          
ATOM   2047  CD  GLU   263      -4.644  24.132  51.716  1.00 50.02          
ATOM   2048  OE1 GLU   263      -4.298  24.079  52.917  1.00 50.44          
ATOM   2049  OE2 GLU   263      -4.319  25.069  50.948  1.00 51.15          
ATOM   2050  N   ASN   264      -5.226  23.289  46.798  1.00 44.68          
ATOM   2051  CA  ASN   264      -5.613  23.378  45.397  1.00 44.86          
ATOM   2052  C   ASN   264      -4.731  22.509  44.490  1.00 44.40          
ATOM   2053  O   ASN   264      -5.232  21.786  43.621  1.00 44.99          
ATOM   2054  CB  ASN   264      -5.571  24.840  44.954  1.00 45.20          
ATOM   2055  CG  ASN   264      -6.725  25.644  45.526  1.00 47.47          
ATOM   2056  OD1 ASN   264      -6.823  26.848  45.318  1.00 47.36          
ATOM   2057  ND2 ASN   264      -7.620  24.967  46.247  1.00 49.46          
ATOM   2058  N   ALA   265      -3.422  22.574  44.707  1.00 43.68          
ATOM   2059  CA  ALA   265      -2.468  21.794  43.935  1.00 42.84          
ATOM   2060  C   ALA   265      -2.749  20.305  44.092  1.00 42.53          
ATOM   2061  O   ALA   265      -2.871  19.580  43.103  1.00 42.36          
ATOM   2062  CB  ALA   265      -1.052  22.109  44.390  1.00 42.55          
ATOM   2063  N   VAL   266      -2.843  19.841  45.331  1.00 42.41          
ATOM   2064  CA  VAL   266      -3.108  18.434  45.571  1.00 43.43          
ATOM   2065  C   VAL   266      -4.404  18.022  44.900  1.00 44.60          
ATOM   2066  O   VAL   266      -4.527  16.904  44.404  1.00 44.52          
ATOM   2067  CB  VAL   266      -3.202  18.130  47.074  1.00 44.20          
ATOM   2068  CG1 VAL   266      -3.556  16.660  47.287  1.00 42.88          
ATOM   2069  CG2 VAL   266      -1.875  18.457  47.741  1.00 43.74          
ATOM   2070  N   GLU   267      -5.373  18.931  44.890  1.00 46.48          
ATOM   2071  CA  GLU   267      -6.658  18.660  44.259  1.00 47.56          
ATOM   2072  C   GLU   267      -6.456  18.351  42.774  1.00 47.85          
ATOM   2073  O   GLU   267      -7.092  17.447  42.222  1.00 47.49          
ATOM   2074  CB  GLU   267      -7.572  19.865  44.396  1.00 49.81          
ATOM   2075  CG  GLU   267      -8.763  19.766  43.492  1.00 55.10          
ATOM   2076  CD  GLU   267     -10.067  19.881  44.229  1.00 58.36          
ATOM   2077  OE1 GLU   267     -10.443  21.026  44.578  1.00 60.03          
ATOM   2078  OE2 GLU   267     -10.697  18.825  44.483  1.00 60.12          
ATOM   2079  N   LYS   268      -5.566  19.113  42.135  1.00 47.95          
ATOM   2080  CA  LYS   268      -5.262  18.927  40.722  1.00 48.04          
ATOM   2081  C   LYS   268      -4.369  17.712  40.488  1.00 47.98          
ATOM   2082  O   LYS   268      -4.441  17.072  39.438  1.00 48.31          
ATOM   2083  CB  LYS   268      -4.604  20.187  40.154  1.00 47.51          
ATOM   2084  CG  LYS   268      -5.534  21.394  40.148  1.00 49.27          
ATOM   2085  CD  LYS   268      -4.978  22.558  39.331  1.00 50.77          
ATOM   2086  CE  LYS   268      -3.645  23.070  39.900  1.00 51.57          
ATOM   2087  NZ  LYS   268      -3.096  24.265  39.171  1.00 50.01          
ATOM   2088  N   LEU   269      -3.529  17.396  41.470  1.00 48.23          
ATOM   2089  CA  LEU   269      -2.643  16.242  41.371  1.00 47.71          
ATOM   2090  C   LEU   269      -3.442  14.928  41.365  1.00 47.84          
ATOM   2091  O   LEU   269      -3.144  14.018  40.591  1.00 47.71          
ATOM   2092  CB  LEU   269      -1.637  16.252  42.532  1.00 46.71          
ATOM   2093  CG  LEU   269      -0.758  15.019  42.762  1.00 45.77          
ATOM   2094  CD1 LEU   269      -0.011  14.668  41.499  1.00 46.01          
ATOM   2095  CD2 LEU   269       0.216  15.295  43.894  1.00 45.49          
ATOM   2096  N   LYS   270      -4.456  14.827  42.221  1.00 47.27          
ATOM   2097  CA  LYS   270      -5.276  13.617  42.276  1.00 47.21          
ATOM   2098  C   LYS   270      -6.162  13.535  41.038  1.00 47.74          
ATOM   2099  O   LYS   270      -6.550  12.448  40.614  1.00 47.84          
ATOM   2100  CB  LYS   270      -6.160  13.615  43.523  1.00 46.87          
ATOM   2101  CG  LYS   270      -5.398  13.685  44.847  1.00 45.75          
ATOM   2102  CD  LYS   270      -6.354  13.642  46.036  1.00 43.37          
ATOM   2103  CE  LYS   270      -5.619  13.777  47.346  1.00 42.55          
ATOM   2104  NZ  LYS   270      -6.516  13.481  48.479  1.00 42.55          
ATOM   2105  N   GLN   271      -6.491  14.689  40.466  1.00 47.50          
ATOM   2106  CA  GLN   271      -7.318  14.706  39.279  1.00 47.55          
ATOM   2107  C   GLN   271      -6.498  14.205  38.090  1.00 46.89          
ATOM   2108  O   GLN   271      -6.837  13.186  37.493  1.00 48.08          
ATOM   2109  CB  GLN   271      -7.846  16.116  39.008  1.00 50.10          
ATOM   2110  CG  GLN   271      -9.040  16.129  38.072  1.00 51.28          
ATOM   2111  CD  GLN   271      -9.270  17.471  37.406  1.00 51.63          
ATOM   2112  OE1 GLN   271     -10.281  17.664  36.729  1.00 51.74          
ATOM   2113  NE2 GLN   271      -8.332  18.401  37.585  1.00 51.56          
ATOM   2114  N   HSD   272      -5.418  14.908  37.746  1.00 45.28          
ATOM   2115  CA  HSD   272      -4.553  14.493  36.629  1.00 42.45          
ATOM   2116  C   HSD   272      -4.225  13.007  36.753  1.00 40.81          
ATOM   2117  O   HSD   272      -4.041  12.325  35.754  1.00 39.84          
ATOM   2118  CB  HSD   272      -3.221  15.258  36.637  1.00 43.50          
ATOM   2119  CG  HSD   272      -3.334  16.704  36.277  1.00 45.07          
ATOM   2120  ND1 HSD   272      -4.092  17.599  36.999  1.00 45.43          
ATOM   2121  CD2 HSD   272      -2.752  17.416  35.286  1.00 46.21          
ATOM   2122  CE1 HSD   272      -3.972  18.803  36.470  1.00 45.55          
ATOM   2123  NE2 HSD   272      -3.164  18.719  35.430  1.00 46.84          
ATOM   2124  N   SER   273      -4.126  12.519  37.989  1.00 38.20          
ATOM   2125  CA  SER   273      -3.803  11.130  38.213  1.00 35.52          
ATOM   2126  C   SER   273      -4.983  10.267  37.835  1.00 35.68          
ATOM   2127  O   SER   273      -4.811   9.191  37.264  1.00 35.30          
ATOM   2128  CB  SER   273      -3.412  10.895  39.668  1.00 35.90          
ATOM   2129  OG  SER   273      -2.188  11.530  39.993  1.00 32.29          
ATOM   2130  N   ARG   274      -6.187  10.727  38.149  1.00 35.75          
ATOM   2131  CA  ARG   274      -7.390   9.969  37.802  1.00 36.75          
ATOM   2132  C   ARG   274      -7.588   9.937  36.285  1.00 37.28          
ATOM   2133  O   ARG   274      -7.869   8.888  35.722  1.00 38.52          
ATOM   2134  CB  ARG   274      -8.637  10.580  38.459  1.00 36.95          
ATOM   2135  CG  ARG   274      -8.698  10.466  39.974  1.00 36.82          
ATOM   2136  CD  ARG   274     -10.054  10.929  40.488  1.00 36.70          
ATOM   2137  NE  ARG   274     -10.274  12.356  40.263  1.00 38.35          
ATOM   2138  CZ  ARG   274     -10.032  13.306  41.167  1.00 38.14          
ATOM   2139  NH1 ARG   274      -9.561  12.981  42.363  1.00 36.22          
ATOM   2140  NH2 ARG   274     -10.264  14.582  40.878  1.00 37.03          
ATOM   2141  N   GLN   275      -7.443  11.086  35.629  1.00 38.05          
ATOM   2142  CA  GLN   275      -7.617  11.169  34.183  1.00 38.52          
ATOM   2143  C   GLN   275      -6.583  10.312  33.478  1.00 38.01          
ATOM   2144  O   GLN   275      -6.896   9.574  32.543  1.00 39.39          
ATOM   2145  CB  GLN   275      -7.474  12.608  33.709  1.00 40.25          
ATOM   2146  CG  GLN   275      -8.511  13.556  34.284  1.00 43.98          
ATOM   2147  CD  GLN   275      -8.149  15.020  34.056  1.00 46.35          
ATOM   2148  OE1 GLN   275      -7.853  15.427  32.936  1.00 48.91          
ATOM   2149  NE2 GLN   275      -8.177  15.816  35.123  1.00 47.14          
ATOM   2150  N   TYR   276      -5.344  10.411  33.934  1.00 36.36          
ATOM   2151  CA  TYR   276      -4.262   9.650  33.344  1.00 35.31          
ATOM   2152  C   TYR   276      -4.531   8.157  33.426  1.00 34.41          
ATOM   2153  O   TYR   276      -4.445   7.449  32.430  1.00 33.63          
ATOM   2154  CB  TYR   276      -2.950  10.005  34.050  1.00 35.75          
ATOM   2155  CG  TYR   276      -1.751   9.236  33.559  1.00 36.20          
ATOM   2156  CD1 TYR   276      -1.464   7.966  34.054  1.00 36.58          
ATOM   2157  CD2 TYR   276      -0.903   9.778  32.600  1.00 35.33          
ATOM   2158  CE1 TYR   276      -0.358   7.257  33.609  1.00 37.87          
ATOM   2159  CE2 TYR   276       0.202   9.082  32.142  1.00 36.76          
ATOM   2160  CZ  TYR   276       0.473   7.820  32.654  1.00 38.26          
ATOM   2161  OH  TYR   276       1.582   7.126  32.231  1.00 40.41          
ATOM   2162  N   ALA   277      -4.858   7.685  34.619  1.00 34.89          
ATOM   2163  CA  ALA   277      -5.136   6.275  34.828  1.00 36.30          
ATOM   2164  C   ALA   277      -6.255   5.819  33.905  1.00 38.00          
ATOM   2165  O   ALA   277      -6.225   4.706  33.376  1.00 36.91          
ATOM   2166  CB  ALA   277      -5.530   6.026  36.276  1.00 35.53          
ATOM   2167  N   LYS   278      -7.251   6.679  33.723  1.00 40.20          
ATOM   2168  CA  LYS   278      -8.383   6.359  32.865  1.00 42.32          
ATOM   2169  C   LYS   278      -7.949   6.259  31.429  1.00 43.49          
ATOM   2170  O   LYS   278      -8.225   5.263  30.762  1.00 44.62          
ATOM   2171  CB  LYS   278      -9.477   7.419  32.990  1.00 43.95          
ATOM   2172  CG  LYS   278     -10.619   7.243  31.998  1.00 46.27          
ATOM   2173  CD  LYS   278     -11.846   8.053  32.398  1.00 49.97          
ATOM   2174  CE  LYS   278     -13.027   7.776  31.461  1.00 51.38          
ATOM   2175  NZ  LYS   278     -14.346   8.206  32.045  1.00 53.63          
ATOM   2176  N   ARG   279      -7.271   7.296  30.948  1.00 44.33          
ATOM   2177  CA  ARG   279      -6.798   7.321  29.561  1.00 45.32          
ATOM   2178  C   ARG   279      -5.950   6.079  29.228  1.00 45.13          
ATOM   2179  O   ARG   279      -6.048   5.529  28.134  1.00 44.57          
ATOM   2180  CB  ARG   279      -6.008   8.619  29.301  1.00 47.62          
ATOM   2181  CG  ARG   279      -5.490   8.795  27.863  1.00 50.39          
ATOM   2182  CD  ARG   279      -5.468  10.270  27.446  1.00 53.84          
ATOM   2183  NE  ARG   279      -4.936  11.132  28.466  1.00 57.92          
ATOM   2184  CZ  ARG   279      -5.349  12.289  28.988  1.00 58.57          
ATOM   2185  NH1 ARG   279      -4.546  12.767  29.919  1.00 59.22          
ATOM   2186  NH2 ARG   279      -6.458  12.959  28.669  1.00 58.05          
ATOM   2187  N   GLN   280      -5.142   5.629  30.186  1.00 44.54          
ATOM   2188  CA  GLN   280      -4.299   4.466  29.979  1.00 42.49          
ATOM   2189  C   GLN   280      -5.092   3.179  29.965  1.00 42.31          
ATOM   2190  O   GLN   280      -4.725   2.219  29.298  1.00 42.76          
ATOM   2191  CB  GLN   280      -3.229   4.386  31.065  1.00 41.79          
ATOM   2192  CG  GLN   280      -1.842   4.200  30.515  1.00 42.04          
ATOM   2193  CD  GLN   280      -1.452   5.345  29.597  1.00 42.96          
ATOM   2194  OE1 GLN   280      -0.920   5.137  28.501  1.00 41.69          
ATOM   2195  NE2 GLN   280      -1.723   6.569  30.040  1.00 42.65          
ATOM   2196  N   LEU   281      -6.177   3.149  30.720  1.00 43.60          
ATOM   2197  CA  LEU   281      -7.005   1.954  30.795  1.00 44.86          
ATOM   2198  C   LEU   281      -7.760   1.866  29.474  1.00 46.02          
ATOM   2199  O   LEU   281      -7.866   0.798  28.873  1.00 46.62          
ATOM   2200  CB  LEU   281      -7.986   2.084  31.964  1.00 46.05          
ATOM   2201  CG  LEU   281      -8.521   0.834  32.659  1.00 47.29          
ATOM   2202  CD1 LEU   281      -9.210  -0.042  31.635  1.00 48.02          
ATOM   2203  CD2 LEU   281      -7.383   0.073  33.349  1.00 47.94          
ATOM   2204  N   THR   282      -8.259   3.012  29.018  1.00 46.51          
ATOM   2205  CA  THR   282      -9.011   3.086  27.779  1.00 46.62          
ATOM   2206  C   THR   282      -8.209   2.592  26.578  1.00 47.68          
ATOM   2207  O   THR   282      -8.715   1.818  25.766  1.00 48.50          
ATOM   2208  CB  THR   282      -9.477   4.525  27.521  1.00 46.54          
ATOM   2209  OG1 THR   282     -10.263   4.981  28.627  1.00 44.95          
ATOM   2210  CG2 THR   282     -10.313   4.591  26.265  1.00 48.15          
ATOM   2211  N   TRP   283      -6.960   3.041  26.478  1.00 49.10          
ATOM   2212  CA  TRP   283      -6.054   2.668  25.387  1.00 48.96          
ATOM   2213  C   TRP   283      -5.796   1.160  25.333  1.00 48.30          
ATOM   2214  O   TRP   283      -5.877   0.555  24.268  1.00 48.47          
ATOM   2215  CB  TRP   283      -4.710   3.386  25.551  1.00 50.31          
ATOM   2216  CG  TRP   283      -3.929   3.535  24.282  1.00 53.10          
ATOM   2217  CD1 TRP   283      -3.892   4.632  23.471  1.00 53.65          
ATOM   2218  CD2 TRP   283      -3.116   2.541  23.645  1.00 53.31          
ATOM   2219  NE1 TRP   283      -3.107   4.384  22.379  1.00 53.64          
ATOM   2220  CE2 TRP   283      -2.611   3.113  22.464  1.00 53.34          
ATOM   2221  CE3 TRP   283      -2.748   1.233  23.970  1.00 54.28          
ATOM   2222  CZ2 TRP   283      -1.788   2.417  21.588  1.00 55.15          
ATOM   2223  CZ3 TRP   283      -1.924   0.534  23.101  1.00 54.82          
ATOM   2224  CH2 TRP   283      -1.443   1.133  21.924  1.00 55.31          
ATOM   2225  N   PHE   284      -5.472   0.568  26.480  1.00 47.17          
ATOM   2226  CA  PHE   284      -5.194  -0.858  26.554  1.00 45.95          
ATOM   2227  C   PHE   284      -6.413  -1.712  26.276  1.00 46.16          
ATOM   2228  O   PHE   284      -6.318  -2.934  26.213  1.00 47.88          
ATOM   2229  CB  PHE   284      -4.607  -1.229  27.922  1.00 42.99          
ATOM   2230  CG  PHE   284      -3.119  -1.052  28.005  1.00 40.18          
ATOM   2231  CD1 PHE   284      -2.281  -1.783  27.178  1.00 38.71          
ATOM   2232  CD2 PHE   284      -2.555  -0.133  28.888  1.00 40.20          
ATOM   2233  CE1 PHE   284      -0.906  -1.610  27.230  1.00 38.81          
ATOM   2234  CE2 PHE   284      -1.174   0.054  28.951  1.00 38.51          
ATOM   2235  CZ  PHE   284      -0.352  -0.684  28.118  1.00 39.99          
ATOM   2236  N   LYS   285      -7.569  -1.093  26.111  1.00 46.47          
ATOM   2237  CA  LYS   285      -8.747  -1.884  25.829  1.00 47.62          
ATOM   2238  C   LYS   285      -9.215  -1.695  24.405  1.00 48.73          
ATOM   2239  O   LYS   285      -9.863  -2.571  23.847  1.00 49.63          
ATOM   2240  CB  LYS   285      -9.860  -1.528  26.789  1.00 47.52          
ATOM   2241  CG  LYS   285      -9.475  -1.804  28.215  1.00 49.56          
ATOM   2242  CD  LYS   285     -10.683  -1.752  29.140  1.00 51.10          
ATOM   2243  CE  LYS   285     -11.397  -3.104  29.245  1.00 51.69          
ATOM   2244  NZ  LYS   285     -10.700  -4.102  30.117  1.00 51.69          
ATOM   2245  N   ASN   286      -8.868  -0.558  23.814  1.00 49.04          
ATOM   2246  CA  ASN   286      -9.260  -0.247  22.453  1.00 50.46          
ATOM   2247  C   ASN   286      -8.121  -0.338  21.443  1.00 50.96          
ATOM   2248  O   ASN   286      -8.236   0.171  20.333  1.00 51.83          
ATOM   2249  CB  ASN   286      -9.847   1.164  22.407  1.00 52.33          
ATOM   2250  CG  ASN   286     -11.065   1.320  23.282  1.00 54.53          
ATOM   2251  OD1 ASN   286     -11.519   2.441  23.545  1.00 55.13          
ATOM   2252  ND2 ASN   286     -11.610   0.197  23.740  1.00 55.49          
ATOM   2253  N   LYS   287      -7.020  -0.974  21.809  1.00 49.95          
ATOM   2254  CA  LYS   287      -5.896  -1.048  20.890  1.00 50.52          
ATOM   2255  C   LYS   287      -5.153  -2.352  21.034  1.00 51.97          
ATOM   2256  O   LYS   287      -4.591  -2.877  20.072  1.00 52.44          
ATOM   2257  CB  LYS   287      -4.909   0.091  21.161  1.00 50.17          
ATOM   2258  CG  LYS   287      -5.476   1.494  21.098  1.00 48.41          
ATOM   2259  CD  LYS   287      -5.691   1.932  19.669  1.00 49.42          
ATOM   2260  CE  LYS   287      -5.956   3.434  19.586  1.00 50.59          
ATOM   2261  NZ  LYS   287      -4.832   4.254  20.139  1.00 50.42          
ATOM   2262  N   MET   288      -5.140  -2.869  22.252  1.00 54.12          
ATOM   2263  CA  MET   288      -4.431  -4.106  22.540  1.00 56.02          
ATOM   2264  C   MET   288      -5.382  -5.213  22.882  1.00 54.23          
ATOM   2265  O   MET   288      -6.522  -4.988  23.288  1.00 53.68          
ATOM   2266  CB  MET   288      -3.501  -3.926  23.735  1.00 61.19          
ATOM   2267  CG  MET   288      -2.671  -2.667  23.730  1.00 67.84          
ATOM   2268  SD  MET   288      -1.138  -2.799  22.617  1.00 79.05          
ATOM   2269  CE  MET   288       0.044  -3.697  23.862  1.00 75.12          
ATOM   2270  N   ASN   289      -4.886  -6.422  22.726  1.00 53.34          
ATOM   2271  CA  ASN   289      -5.667  -7.579  23.057  1.00 53.29          
ATOM   2272  C   ASN   289      -5.017  -8.084  24.333  1.00 50.83          
ATOM   2273  O   ASN   289      -4.131  -8.932  24.302  1.00 49.74          
ATOM   2274  CB  ASN   289      -5.564  -8.625  21.953  1.00 56.36          
ATOM   2275  CG  ASN   289      -6.458  -9.808  22.210  1.00 58.29          
ATOM   2276  OD1 ASN   289      -7.680  -9.659  22.324  1.00 58.96          
ATOM   2277  ND2 ASN   289      -5.863 -10.994  22.316  1.00 59.23          
ATOM   2278  N   VAL   290      -5.446  -7.523  25.453  1.00 48.80          
ATOM   2279  CA  VAL   290      -4.910  -7.887  26.751  1.00 47.23          
ATOM   2280  C   VAL   290      -5.792  -8.891  27.489  1.00 45.86          
ATOM   2281  O   VAL   290      -7.021  -8.836  27.398  1.00 44.14          
ATOM   2282  CB  VAL   290      -4.785  -6.651  27.664  1.00 46.63          
ATOM   2283  CG1 VAL   290      -4.015  -7.007  28.914  1.00 46.42          
ATOM   2284  CG2 VAL   290      -4.128  -5.517  26.915  1.00 46.08          
ATOM   2285  N   HSD   291      -5.153  -9.801  28.228  1.00 45.26          
ATOM   2286  CA  HSD   291      -5.853 -10.808  29.039  1.00 43.68          
ATOM   2287  C   HSD   291      -5.984 -10.136  30.408  1.00 41.95          
ATOM   2288  O   HSD   291      -5.090 -10.212  31.242  1.00 41.42          
ATOM   2289  CB  HSD   291      -5.017 -12.093  29.139  1.00 45.12          
ATOM   2290  CG  HSD   291      -5.728 -13.236  29.801  1.00 47.50          
ATOM   2291  ND1 HSD   291      -6.067 -13.231  31.137  1.00 49.19          
ATOM   2292  CD2 HSD   291      -6.129 -14.434  29.315  1.00 48.36          
ATOM   2293  CE1 HSD   291      -6.643 -14.379  31.450  1.00 48.95          
ATOM   2294  NE2 HSD   291      -6.692 -15.126  30.362  1.00 49.58          
ATOM   2295  N   TRP   292      -7.105  -9.462  30.613  1.00 40.90          
ATOM   2296  CA  TRP   292      -7.368  -8.742  31.843  1.00 40.61          
ATOM   2297  C   TRP   292      -7.686  -9.607  33.055  1.00 40.95          
ATOM   2298  O   TRP   292      -8.454 -10.557  32.958  1.00 41.63          
ATOM   2299  CB  TRP   292      -8.526  -7.771  31.636  1.00 40.25          
ATOM   2300  CG  TRP   292      -8.274  -6.779  30.563  1.00 39.85          
ATOM   2301  CD1 TRP   292      -8.661  -6.855  29.260  1.00 38.13          
ATOM   2302  CD2 TRP   292      -7.531  -5.564  30.696  1.00 40.33          
ATOM   2303  NE1 TRP   292      -8.205  -5.752  28.571  1.00 39.14          
ATOM   2304  CE2 TRP   292      -7.509  -4.945  29.429  1.00 40.04          
ATOM   2305  CE3 TRP   292      -6.886  -4.937  31.769  1.00 40.44          
ATOM   2306  CZ2 TRP   292      -6.859  -3.733  29.200  1.00 40.75          
ATOM   2307  CZ3 TRP   292      -6.241  -3.732  31.548  1.00 40.21          
ATOM   2308  CH2 TRP   292      -6.234  -3.139  30.268  1.00 42.10          
ATOM   2309  N   LEU   293      -7.089  -9.257  34.196  1.00 41.00          
ATOM   2310  CA  LEU   293      -7.307  -9.933  35.475  1.00 40.14          
ATOM   2311  C   LEU   293      -8.026  -8.905  36.313  1.00 40.38          
ATOM   2312  O   LEU   293      -7.472  -7.843  36.581  1.00 40.60          
ATOM   2313  CB  LEU   293      -5.984 -10.274  36.154  1.00 38.82          
ATOM   2314  CG  LEU   293      -5.110 -11.199  35.326  1.00 39.72          
ATOM   2315  CD1 LEU   293      -3.797 -11.494  36.031  1.00 38.67          
ATOM   2316  CD2 LEU   293      -5.895 -12.473  35.064  1.00 40.48          
ATOM   2317  N   ASN   294      -9.250  -9.211  36.730  1.00 42.06          
ATOM   2318  CA  ASN   294     -10.041  -8.275  37.536  1.00 42.99          
ATOM   2319  C   ASN   294      -9.539  -8.244  38.994  1.00 42.40          
ATOM   2320  O   ASN   294      -9.800  -9.147  39.767  1.00 43.13          
ATOM   2321  CB  ASN   294     -11.521  -8.682  37.457  1.00 43.12          
ATOM   2322  CG  ASN   294     -12.457  -7.637  38.043  1.00 43.42          
ATOM   2323  OD1 ASN   294     -13.669  -7.699  37.821  1.00 44.84          
ATOM   2324  ND2 ASN   294     -11.906  -6.680  38.800  1.00 41.98          
ATOM   2325  N   LYS   295      -8.811  -7.194  39.348  1.00 43.13          
ATOM   2326  CA  LYS   295      -8.253  -7.047  40.677  1.00 44.01          
ATOM   2327  C   LYS   295      -9.313  -7.034  41.774  1.00 47.25          
ATOM   2328  O   LYS   295      -9.015  -7.299  42.942  1.00 48.02          
ATOM   2329  CB  LYS   295      -7.446  -5.766  40.753  1.00 42.24          
ATOM   2330  CG  LYS   295      -6.686  -5.590  42.016  1.00 42.84          
ATOM   2331  CD  LYS   295      -6.654  -4.138  42.427  1.00 41.97          
ATOM   2332  CE  LYS   295      -5.265  -3.736  42.874  1.00 42.08          
ATOM   2333  NZ  LYS   295      -4.617  -4.779  43.697  1.00 40.12          
ATOM   2334  N   GLU   296     -10.554  -6.736  41.414  1.00 49.88          
ATOM   2335  CA  GLU   296     -11.635  -6.700  42.395  1.00 52.31          
ATOM   2336  C   GLU   296     -12.243  -8.072  42.657  1.00 52.26          
ATOM   2337  O   GLU   296     -13.304  -8.179  43.273  1.00 53.05          
ATOM   2338  CB  GLU   296     -12.728  -5.742  41.914  1.00 54.20          
ATOM   2339  CG  GLU   296     -12.342  -4.282  41.971  1.00 57.99          
ATOM   2340  CD  GLU   296     -13.383  -3.378  41.337  1.00 60.64          
ATOM   2341  OE1 GLU   296     -13.255  -2.139  41.457  1.00 62.59          
ATOM   2342  OE2 GLU   296     -14.328  -3.905  40.710  1.00 60.61          
ATOM   2343  N   ARG   297     -11.552  -9.115  42.213  1.00 52.15          
ATOM   2344  CA  ARG   297     -12.045 -10.478  42.350  1.00 52.31          
ATOM   2345  C   ARG   297     -10.908 -11.491  42.500  1.00 50.64          
ATOM   2346  O   ARG   297     -11.123 -12.649  42.850  1.00 49.87          
ATOM   2347  CB  ARG   297     -12.922 -10.796  41.124  1.00 53.68          
ATOM   2348  CG  ARG   297     -13.339 -12.235  40.948  1.00 58.16          
ATOM   2349  CD  ARG   297     -12.319 -12.955  40.102  1.00 62.33          
ATOM   2350  NE  ARG   297     -12.864 -14.119  39.483  1.00 67.18          
ATOM   2351  CZ  ARG   297     -12.451 -15.380  39.413  1.00 69.01          
ATOM   2352  NH1 ARG   297     -11.343 -15.881  39.961  1.00 68.90          
ATOM   2353  NH2 ARG   297     -13.246 -16.161  38.703  1.00 69.75          
ATOM   2354  N   MET   298      -9.693 -11.038  42.250  1.00 49.65          
ATOM   2355  CA  MET   298      -8.541 -11.903  42.356  1.00 50.50          
ATOM   2356  C   MET   298      -7.472 -11.290  43.238  1.00 48.11          
ATOM   2357  O   MET   298      -7.401 -10.075  43.404  1.00 47.23          
ATOM   2358  CB  MET   298      -7.949 -12.163  40.986  1.00 56.16          
ATOM   2359  CG  MET   298      -8.803 -13.028  40.098  1.00 64.13          
ATOM   2360  SD  MET   298      -7.976 -13.256  38.354  1.00 73.14          
ATOM   2361  CE  MET   298      -9.250 -12.214  37.289  1.00 70.76          
ATOM   2362  N   SER   299      -6.617 -12.143  43.776  1.00 44.79          
ATOM   2363  CA  SER   299      -5.559 -11.700  44.652  1.00 43.78          
ATOM   2364  C   SER   299      -4.202 -11.928  44.027  1.00 43.59          
ATOM   2365  O   SER   299      -4.092 -12.631  43.038  1.00 44.01          
ATOM   2366  CB  SER   299      -5.630 -12.478  45.948  1.00 43.01          
ATOM   2367  OG  SER   299      -5.428 -13.850  45.693  1.00 38.72          
ATOM   2368  N   LEU   300      -3.164 -11.360  44.631  1.00 45.42          
ATOM   2369  CA  LEU   300      -1.813 -11.519  44.113  1.00 46.46          
ATOM   2370  C   LEU   300      -1.527 -12.981  43.790  1.00 46.29          
ATOM   2371  O   LEU   300      -0.977 -13.281  42.736  1.00 47.27          
ATOM   2372  CB  LEU   300      -0.793 -10.992  45.119  1.00 46.38          
ATOM   2373  CG  LEU   300       0.675 -11.080  44.682  1.00 47.84          
ATOM   2374  CD1 LEU   300       0.876 -10.362  43.352  1.00 45.68          
ATOM   2375  CD2 LEU   300       1.578 -10.470  45.764  1.00 48.95          
ATOM   2376  N   GLN   301      -1.914 -13.884  44.686  1.00 45.54          
ATOM   2377  CA  GLN   301      -1.695 -15.308  44.478  1.00 46.12          
ATOM   2378  C   GLN   301      -2.615 -15.887  43.416  1.00 47.69          
ATOM   2379  O   GLN   301      -2.218 -16.753  42.641  1.00 47.50          
ATOM   2380  CB  GLN   301      -1.924 -16.082  45.763  1.00 46.17          
ATOM   2381  CG  GLN   301      -1.622 -17.564  45.643  1.00 46.12          
ATOM   2382  CD  GLN   301      -0.136 -17.838  45.601  1.00 45.52          
ATOM   2383  OE1 GLN   301       0.572 -17.307  44.754  1.00 44.36          
ATOM   2384  NE2 GLN   301       0.346 -18.671  46.524  1.00 45.99          
ATOM   2385  N   MET   302      -3.861 -15.439  43.399  1.00 49.31          
ATOM   2386  CA  MET   302      -4.797 -15.938  42.409  1.00 51.32          
ATOM   2387  C   MET   302      -4.385 -15.528  41.006  1.00 52.45          
ATOM   2388  O   MET   302      -4.563 -16.285  40.061  1.00 52.64          
ATOM   2389  CB  MET   302      -6.200 -15.436  42.704  1.00 52.89          
ATOM   2390  CG  MET   302      -6.855 -16.153  43.851  1.00 57.45          
ATOM   2391  SD  MET   302      -8.378 -15.173  44.471  1.00 62.65          
ATOM   2392  CE  MET   302      -9.628 -15.560  43.052  1.00 62.89          
ATOM   2393  N   MET   303      -3.845 -14.325  40.867  1.00 53.09          
ATOM   2394  CA  MET   303      -3.406 -13.857  39.571  1.00 53.97          
ATOM   2395  C   MET   303      -2.217 -14.696  39.122  1.00 52.85          
ATOM   2396  O   MET   303      -2.169 -15.134  37.982  1.00 52.25          
ATOM   2397  CB  MET   303      -2.999 -12.391  39.643  1.00 57.76          
ATOM   2398  CG  MET   303      -4.109 -11.452  40.071  1.00 63.73          
ATOM   2399  SD  MET   303      -3.617  -9.563  39.822  1.00 70.50          
ATOM   2400  CE  MET   303      -3.534  -8.998  41.681  1.00 70.66          
ATOM   2401  N   LEU   304      -1.267 -14.928  40.027  1.00 52.23          
ATOM   2402  CA  LEU   304      -0.086 -15.718  39.706  1.00 51.04          
ATOM   2403  C   LEU   304      -0.471 -17.097  39.207  1.00 51.98          
ATOM   2404  O   LEU   304       0.309 -17.748  38.525  1.00 53.52          
ATOM   2405  CB  LEU   304       0.837 -15.844  40.922  1.00 49.65          
ATOM   2406  CG  LEU   304       2.130 -16.655  40.773  1.00 47.72          
ATOM   2407  CD1 LEU   304       2.999 -16.079  39.681  1.00 46.43          
ATOM   2408  CD2 LEU   304       2.876 -16.643  42.087  1.00 46.76          
ATOM   2409  N   ASP   305      -1.671 -17.551  39.540  1.00 53.53          
ATOM   2410  CA  ASP   305      -2.109 -18.859  39.081  1.00 54.88          
ATOM   2411  C   ASP   305      -2.729 -18.774  37.718  1.00 54.61          
ATOM   2412  O   ASP   305      -2.629 -19.709  36.933  1.00 55.30          
ATOM   2413  CB  ASP   305      -3.099 -19.477  40.055  1.00 56.92          
ATOM   2414  CG  ASP   305      -2.415 -20.011  41.284  1.00 60.74          
ATOM   2415  OD1 ASP   305      -1.398 -20.735  41.116  1.00 62.71          
ATOM   2416  OD2 ASP   305      -2.884 -19.724  42.412  1.00 61.25          
ATOM   2417  N   GLU   306      -3.393 -17.660  37.445  1.00 55.22          
ATOM   2418  CA  GLU   306      -4.012 -17.454  36.147  1.00 55.87          
ATOM   2419  C   GLU   306      -2.905 -17.445  35.105  1.00 55.93          
ATOM   2420  O   GLU   306      -3.042 -18.029  34.029  1.00 56.27          
ATOM   2421  CB  GLU   306      -4.748 -16.122  36.124  1.00 57.59          
ATOM   2422  CG  GLU   306      -6.257 -16.253  36.166  1.00 61.17          
ATOM   2423  CD  GLU   306      -6.816 -16.815  34.885  1.00 62.73          
ATOM   2424  OE1 GLU   306      -6.546 -16.211  33.817  1.00 63.01          
ATOM   2425  OE2 GLU   306      -7.521 -17.852  34.950  1.00 64.03          
ATOM   2426  N   ILE   307      -1.805 -16.778  35.443  1.00 55.01          
ATOM   2427  CA  ILE   307      -0.650 -16.667  34.563  1.00 54.51          
ATOM   2428  C   ILE   307       0.085 -17.996  34.460  1.00 54.74          
ATOM   2429  O   ILE   307       0.626 -18.335  33.411  1.00 53.61          
ATOM   2430  CB  ILE   307       0.339 -15.581  35.081  1.00 53.45          
ATOM   2431  CG1 ILE   307      -0.316 -14.207  35.000  1.00 53.10          
ATOM   2432  CG2 ILE   307       1.616 -15.576  34.253  1.00 53.14          
ATOM   2433  CD  ILE   307       0.533 -13.103  35.547  1.00 51.89          
ATOM   2434  N   THR   308       0.094 -18.752  35.551  1.00 55.72          
ATOM   2435  CA  THR   308       0.789 -20.028  35.573  1.00 57.22          
ATOM   2436  C   THR   308       0.082 -21.019  34.656  1.00 57.78          
ATOM   2437  O   THR   308       0.712 -21.883  34.057  1.00 58.79          
ATOM   2438  CB  THR   308       0.891 -20.562  37.028  1.00 57.17          
ATOM   2439  OG1 THR   308       2.063 -21.375  37.156  1.00 57.44          
ATOM   2440  CG2 THR   308      -0.331 -21.372  37.397  1.00 58.77          
ATOM   2441  N   THR   309      -1.228 -20.869  34.523  1.00 58.23          
ATOM   2442  CA  THR   309      -2.000 -21.748  33.664  1.00 58.17          
ATOM   2443  C   THR   309      -1.745 -21.379  32.214  1.00 57.88          
ATOM   2444  O   THR   309      -1.687 -22.234  31.336  1.00 57.72          
ATOM   2445  CB  THR   309      -3.494 -21.600  33.955  1.00 59.17          
ATOM   2446  OG1 THR   309      -3.746 -21.966  35.317  1.00 59.29          
ATOM   2447  CG2 THR   309      -4.319 -22.476  33.022  1.00 59.28          
ATOM   2448  N   GLN   310      -1.598 -20.086  31.977  1.00 58.69          
ATOM   2449  CA  GLN   310      -1.347 -19.579  30.646  1.00 59.14          
ATOM   2450  C   GLN   310       0.065 -19.993  30.215  1.00 59.03          
ATOM   2451  O   GLN   310       0.296 -20.278  29.046  1.00 60.40          
ATOM   2452  CB  GLN   310      -1.489 -18.054  30.644  1.00 59.01          
ATOM   2453  CG  GLN   310      -2.202 -17.467  29.433  1.00 59.91          
ATOM   2454  CD  GLN   310      -3.696 -17.758  29.409  1.00 59.59          
ATOM   2455  OE1 GLN   310      -4.416 -17.289  28.525  1.00 58.69          
ATOM   2456  NE2 GLN   310      -4.168 -18.532  30.378  1.00 58.43          
ATOM   2457  N   ILE   311       1.003 -20.039  31.157  1.00 58.73          
ATOM   2458  CA  ILE   311       2.376 -20.425  30.835  1.00 59.08          
ATOM   2459  C   ILE   311       2.537 -21.934  30.661  1.00 61.03          
ATOM   2460  O   ILE   311       3.463 -22.396  29.979  1.00 60.61          
ATOM   2461  CB  ILE   311       3.380 -19.950  31.918  1.00 57.94          
ATOM   2462  CG1 ILE   311       3.404 -18.424  31.978  1.00 56.82          
ATOM   2463  CG2 ILE   311       4.774 -20.463  31.601  1.00 56.28          
ATOM   2464  CD  ILE   311       4.156 -17.877  33.159  1.00 56.25          
ATOM   2465  N   ASN   312       1.653 -22.710  31.286  1.00 61.99          
ATOM   2466  CA  ASN   312       1.719 -24.167  31.149  1.00 62.47          
ATOM   2467  C   ASN   312       1.166 -24.608  29.776  1.00 64.15          
ATOM   2468  O   ASN   312       0.939 -25.796  29.548  1.00 64.42          
ATOM   2469  CB  ASN   312       0.962 -24.876  32.295  1.00 61.80          
ATOM   2470  CG  ASN   312       1.702 -24.806  33.644  1.00 60.42          
ATOM   2471  OD1 ASN   312       2.883 -24.439  33.716  1.00 60.65          
ATOM   2472  ND2 ASN   312       1.003 -25.178  34.715  1.00 57.04          
ATOM   2473  N   LYS   313       0.990 -23.648  28.861  1.00 65.63          
ATOM   2474  CA  LYS   313       0.534 -23.932  27.492  1.00 67.33          
ATOM   2475  C   LYS   313       1.699 -23.596  26.559  1.00 68.99          
ATOM   2476  O   LYS   313       2.085 -24.409  25.706  1.00 68.36          
ATOM   2477  CB  LYS   313      -0.703 -23.097  27.105  1.00 66.37          
ATOM   2478  CG  LYS   313      -1.966 -23.428  27.904  1.00 65.14          
ATOM   2479  CD  LYS   313      -2.291 -24.916  27.830  1.00 64.60          
ATOM   2480  CE  LYS   313      -3.074 -25.401  29.056  1.00 63.38          
ATOM   2481  NZ  LYS   313      -3.453 -26.856  28.978  1.00 60.24          
ATOM   2482  N   ARG   314       2.267 -22.402  26.745  1.00 71.80          
ATOM   2483  CA  ARG   314       3.410 -21.937  25.948  1.00 74.39          
ATOM   2484  C   ARG   314       4.544 -22.959  26.006  1.00 75.46          
ATOM   2485  O   ARG   314       5.475 -22.905  25.199  1.00 76.09          
ATOM   2486  CB  ARG   314       3.946 -20.593  26.469  1.00 73.93          
ATOM   2487  CG  ARG   314       3.064 -19.379  26.240  1.00 74.77          
ATOM   2488  CD  ARG   314       2.928 -19.011  24.764  1.00 75.33          
ATOM   2489  NE  ARG   314       2.398 -17.655  24.608  1.00 75.78          
ATOM   2490  CZ  ARG   314       1.191 -17.260  25.009  1.00 75.66          
ATOM   2491  NH1 ARG   314       0.364 -18.116  25.589  1.00 76.05          
ATOM   2492  NH2 ARG   314       0.815 -15.997  24.857  1.00 75.79          
ATOM   2493  N   SER   315       4.472 -23.873  26.973  1.00 76.96          
ATOM   2494  CA  SER   315       5.494 -24.906  27.118  1.00 79.42          
ATOM   2495  C   SER   315       4.966 -26.290  26.719  1.00 80.34          
ATOM   2496  O   SER   315       5.372 -26.766  25.630  1.00 80.78          
ATOM   2497  CB  SER   315       6.047 -24.927  28.561  1.00 79.23          
ATOM   2498  OG  SER   315       5.022 -25.081  29.532  1.00 79.03          
END
