
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  196 ( 1595),  selected  196 , name 2qor_A
# Molecule2: number of CA atoms  232 ( 1859),  selected  232 , name T0416_6_115_194_315.pdb
# PARAMETERS: 2qor_A.T0416_6_115_194_315.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_A      -       -           -
LGA    A     2_A      K       6          3.241
LGA    R     3_A      P       7          2.843
LGA    I     4_A      -       -           -
LGA    P     5_A      F       8          2.074
LGA    P     6_A      L       9          1.043
LGA    L     7_A      I      10          1.042
LGA    V     8_A      V      11          1.227
LGA    V     9_A      I      12          1.355
LGA    C    10_A      V      13          1.172
LGA    G    11_A      G      14          1.581
LGA    P    12_A      P      15          1.801
LGA    S    13_A      T      16          1.934
LGA    G    14_A      A      17          3.393
LGA    V    15_A      S      18          2.046
LGA    G    16_A      G      19          1.470
LGA    K    17_A      K      20          0.929
LGA    G    18_A      T      21          0.936
LGA    T    19_A      E      22          1.322
LGA    L    20_A      L      23          1.116
LGA    I    21_A      S      24          0.945
LGA    K    22_A      I      25          1.584
LGA    K    23_A      E      26          1.252
LGA    V    24_A      V      27          0.668
LGA    L    25_A      A      28          1.455
LGA    S    26_A      K      29          2.150
LGA    E    27_A      K      30          1.607
LGA    F    28_A      F      31          1.755
LGA    P    29_A      N      32          1.824
LGA    S    30_A      -       -           -
LGA    R    31_A      -       -           -
LGA    F    32_A      G      33          1.875
LGA    R    33_A      E      34          1.943
LGA    F    34_A      I      35          1.146
LGA    S    35_A      I      36          1.447
LGA    I    36_A      S      37          4.150
LGA    S    37_A      G      38          5.243
LGA    C    38_A      D      39           #
LGA    -       -      S      40           -
LGA    -       -      M      41           -
LGA    -       -      Q      42           -
LGA    T    39_A      V      43          1.859
LGA    T    40_A      Y      44          2.774
LGA    R    41_A      Q      45           #
LGA    -       -      G      46           -
LGA    N    42_A      M      47          1.027
LGA    K    43_A      D      48          1.176
LGA    R    44_A      I      49          3.291
LGA    E    45_A      G      50           -
LGA    K    46_A      T      51           -
LGA    -       -      A      52           -
LGA    -       -      K      53           -
LGA    -       -      V      54           -
LGA    E    47_A      T      55          1.668
LGA    T    48_A      T      56          3.343
LGA    N    49_A      E      57           -
LGA    G    50_A      E      58           -
LGA    V    51_A      M      59           #
LGA    -       -      E      60           -
LGA    -       -      G      61           -
LGA    -       -      I      62           -
LGA    -       -      P      63           -
LGA    D    52_A      X      64          4.817
LGA    -       -      Y      65           -
LGA    Y    53_A      M      66          4.642
LGA    Y    54_A      I      67          2.103
LGA    F    55_A      D      68          1.898
LGA    -       -      I      69           -
LGA    V    56_A      L      70          2.593
LGA    D    57_A      P      71          2.239
LGA    K    58_A      P      72          3.518
LGA    D    59_A      D      73          2.897
LGA    D    60_A      A      74          2.951
LGA    F    61_A      S      75          3.576
LGA    E    62_A      F      76          4.582
LGA    R    63_A      S      77           -
LGA    K    64_A      A      78           -
LGA    L    65_A      Y      79           #
LGA    K    66_A      E      80           #
LGA    E    67_A      -       -           -
LGA    G    68_A      -       -           -
LGA    Q    69_A      -       -           -
LGA    F    70_A      F      81          3.348
LGA    L    71_A      K      82          0.961
LGA    E    72_A      K      83           #
LGA    F    73_A      -       -           -
LGA    D    74_A      -       -           -
LGA    K    75_A      -       -           -
LGA    Y    76_A      -       -           -
LGA    A    77_A      -       -           -
LGA    N    78_A      -       -           -
LGA    N    79_A      -       -           -
LGA    F    80_A      -       -           -
LGA    Y    81_A      -       -           -
LGA    G    82_A      -       -           -
LGA    T    83_A      R      84          5.100
LGA    L    84_A      A      85          3.429
LGA    K    85_A      E      86          3.781
LGA    S    86_A      K      87          3.587
LGA    E    87_A      Y      88          2.113
LGA    Y    88_A      I      89          1.937
LGA    D    89_A      K      90          3.107
LGA    L    90_A      D      91          2.204
LGA    A    91_A      I      92          0.764
LGA    V    92_A      T      93          2.716
LGA    G    93_A      R      94          2.257
LGA    E    94_A      R      95          0.895
LGA    G    95_A      G      96          2.373
LGA    K    96_A      K      97          1.998
LGA    I    97_A      V      98          2.205
LGA    C    98_A      P      99          1.009
LGA    L    99_A      I     100          0.477
LGA    F   100_A      I     101          0.805
LGA    E   101_A      A     102          1.914
LGA    X   102_A      G     103          3.277
LGA    N   103_A      G     104          2.745
LGA    -       -      T     105           -
LGA    I   104_A      G     106          1.736
LGA    N   105_A      L     107          1.639
LGA    G   106_A      Y     108          1.481
LGA    V   107_A      I     109          1.796
LGA    K   108_A      Q     110          1.768
LGA    Q   109_A      S     111          0.671
LGA    L   110_A      L     112          1.438
LGA    K   111_A      L     113          2.540
LGA    E   112_A      Y     114          2.351
LGA    S   113_A      N     115          3.299
LGA    K   114_A      -       -           -
LGA    H   115_A      -       -           -
LGA    I   116_A      E     194           #
LGA    Q   117_A      N     195          1.907
LGA    D   118_A      Y     196          2.169
LGA    G   119_A      D     197          3.423
LGA    I   120_A      T     198          1.919
LGA    -       -      L     199           -
LGA    Y   121_A      L     200          1.358
LGA    I   122_A      I     201          1.367
LGA    F   123_A      G     202          1.812
LGA    V   124_A      I     203          1.573
LGA    K   125_A      E     204          0.722
LGA    P   126_A      M     205          1.970
LGA    P   127_A      -       -           -
LGA    S   128_A      S     206          1.688
LGA    I   129_A      R     207          1.907
LGA    D   130_A      E     208          1.579
LGA    I   131_A      T     209          1.462
LGA    L   132_A      L     210          2.061
LGA    L   133_A      Y     211          2.097
LGA    G   134_A      L     212          2.228
LGA    R   135_A      R     213          2.070
LGA    L   136_A      I     214          2.117
LGA    K   137_A      N     215          2.534
LGA    N   138_A      K     216          2.596
LGA    R   139_A      R     217          2.339
LGA    -       -      V     218           -
LGA    N   140_A      D     219          3.066
LGA    T   141_A      I     220          3.293
LGA    E   142_A      M     221          2.551
LGA    K   143_A      L     222           #
LGA    -       -      G     223           -
LGA    -       -      X     224           -
LGA    -       -      G     225           -
LGA    -       -      L     226           -
LGA    -       -      F     227           -
LGA    -       -      N     228           -
LGA    -       -      E     229           -
LGA    -       -      V     230           -
LGA    -       -      Q     231           -
LGA    -       -      X     232           -
LGA    -       -      L     233           -
LGA    -       -      V     234           -
LGA    -       -      E     235           -
LGA    -       -      Q     236           -
LGA    -       -      G     237           -
LGA    -       -      F     238           -
LGA    -       -      E     239           -
LGA    -       -      A     240           -
LGA    -       -      S     241           -
LGA    -       -      Q     242           -
LGA    -       -      S     243           -
LGA    -       -      M     244           -
LGA    -       -      Q     245           -
LGA    -       -      A     246           -
LGA    -       -      I     247           -
LGA    -       -      G     248           -
LGA    -       -      Y     249           -
LGA    -       -      K     250           -
LGA    -       -      E     251           -
LGA    -       -      L     252           -
LGA    -       -      V     253           -
LGA    -       -      P     254           -
LGA    -       -      V     255           -
LGA    -       -      I     256           -
LGA    -       -      K     257           -
LGA    -       -      G     258           -
LGA    -       -      N     259           -
LGA    -       -      I     260           -
LGA    -       -      S     261           -
LGA    -       -      M     262           -
LGA    -       -      E     263           -
LGA    -       -      N     264           -
LGA    -       -      A     265           -
LGA    -       -      V     266           -
LGA    -       -      E     267           -
LGA    P   144_A      K     268          5.633
LGA    E   145_A      L     269          1.700
LGA    E   146_A      -       -           -
LGA    I   147_A      K     270          3.666
LGA    N   148_A      Q     271          3.179
LGA    K   149_A      X     272          3.110
LGA    R   150_A      S     273          2.893
LGA    X   151_A      R     274          1.704
LGA    Q   152_A      Q     275          1.685
LGA    E   153_A      Y     276          1.854
LGA    L   154_A      A     277          1.691
LGA    T   155_A      K     278          1.629
LGA    R   156_A      R     279          1.308
LGA    E   157_A      Q     280          2.053
LGA    X   158_A      L     281          2.414
LGA    D   159_A      T     282          1.947
LGA    E   160_A      W     283          2.211
LGA    A   161_A      F     284          2.080
LGA    D   162_A      K     285          2.390
LGA    K   163_A      N     286          2.293
LGA    V   164_A      K     287          1.959
LGA    G   165_A      M     288          2.762
LGA    F   166_A      N     289          2.106
LGA    N   167_A      V     290          4.444
LGA    Y   168_A      X     291          1.393
LGA    F   169_A      W     292          1.601
LGA    I   170_A      L     293          1.398
LGA    V   171_A      N     294          1.223
LGA    N   172_A      K     295          1.911
LGA    D   173_A      E     296          2.845
LGA    -       -      R     297           -
LGA    -       -      M     298           -
LGA    D   174_A      S     299          2.268
LGA    L   175_A      L     300          2.015
LGA    A   176_A      Q     301          2.500
LGA    R   177_A      M     302          2.316
LGA    T   178_A      M     303          2.418
LGA    Y   179_A      L     304          2.349
LGA    A   180_A      D     305          2.243
LGA    E   181_A      E     306          1.947
LGA    L   182_A      I     307          2.395
LGA    R   183_A      T     308          1.833
LGA    E   184_A      T     309          1.400
LGA    Y   185_A      Q     310          1.921
LGA    L   186_A      I     311          2.407
LGA    L   187_A      N     312          2.094
LGA    G   188_A      K     313          2.483
LGA    S   189_A      R     314          3.364
LGA    Y   190_A      -       -           -
LGA    P   191_A      S     315          0.899
LGA    Q   192_A      -       -           -
LGA    L   193_A      -       -           -
LGA    R   194_A      -       -           -
LGA    G   195_A      -       -           -
LGA    G   196_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  196  232    5.0    155    2.38    14.84     43.118     6.247

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.365786 * X  +  -0.929124 * Y  +  -0.054131 * Z  +  16.845278
  Y_new =  -0.857708 * X  +  -0.359106 * Y  +   0.367939 * Z  + -57.895626
  Z_new =  -0.361300 * X  +  -0.088159 * Y  +  -0.928273 * Z  + 209.101868 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -3.046906    0.094686  [ DEG:  -174.5749      5.4251 ]
  Theta =   0.369661    2.771931  [ DEG:    21.1800    158.8200 ]
  Phi   =  -1.167683    1.973910  [ DEG:   -66.9033    113.0967 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2qor_A                                        
REMARK     2: T0416_6_115_194_315.pdb                       
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2qor_A.T0416_6_115_194_315.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  196  232   5.0  155   2.38   14.84  43.118
REMARK  ---------------------------------------------------------- 
MOLECULE 2qor_A
HEADER    TRANSFERASE                             20-JUL-07   2QOR              
TITLE     CRYSTAL STRUCTURE OF PLASMODIUM VIVAX GUANYLATE KINASE                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GUANYLATE KINASE;                                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: GMP KINASE, GUANOSINE MONOPHOSPHATE KINASE;                 
COMPND   5 EC: 2.7.4.8;                                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PLASMODIUM VIVAX;                               
SOURCE   3 ORGANISM_COMMON: MALARIA PARASITE;                                   
SOURCE   4 GENE: PV099895, PVX_099895;                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)PLYSS;                            
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: BG1861                                    
KEYWDS    PHOSPHOTRANSFERASE, PURINE METABOLISM, STRUCTURAL GENOMICS,           
KEYWDS   2 STRUCTURAL GENOMICS OF PATHOGENIC PROTOZOA CONSORTIUM, SGPP,         
KEYWDS   3 PSI, PROTEIN STRUCTURE INITIATIVE, KINASE                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    E.A.MERRITT,I.LE TRONG,STRUCTURAL GENOMICS OF PATHOGENIC              
AUTHOR   2 PROTOZOA CONSORTIUM (SGPP)                                           
REVDAT   2   14-AUG-07 2QOR    1       REMARK                                   
REVDAT   1   07-AUG-07 2QOR    0                                                
JRNL        AUTH   I.LE TRONG,E.A.MERRITT                                       
JRNL        TITL   PLASMODIUM VIVAX GUANYLATE KINASE.                           
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2QOR A    1   196  UNP    A5K709   A5K709_PLAVI     1    196             
SEQRES   1 A  204  MSE ALA HIS HIS HIS HIS HIS HIS MSE ALA ARG ILE PRO          
SEQRES   2 A  204  PRO LEU VAL VAL CYS GLY PRO SER GLY VAL GLY LYS GLY          
SEQRES   3 A  204  THR LEU ILE LYS LYS VAL LEU SER GLU PHE PRO SER ARG          
SEQRES   4 A  204  PHE ARG PHE SER ILE SER CYS THR THR ARG ASN LYS ARG          
SEQRES   5 A  204  GLU LYS GLU THR ASN GLY VAL ASP TYR TYR PHE VAL ASP          
SEQRES   6 A  204  LYS ASP ASP PHE GLU ARG LYS LEU LYS GLU GLY GLN PHE          
SEQRES   7 A  204  LEU GLU PHE ASP LYS TYR ALA ASN ASN PHE TYR GLY THR          
SEQRES   8 A  204  LEU LYS SER GLU TYR ASP LEU ALA VAL GLY GLU GLY LYS          
SEQRES   9 A  204  ILE CYS LEU PHE GLU MSE ASN ILE ASN GLY VAL LYS GLN          
SEQRES  10 A  204  LEU LYS GLU SER LYS HIS ILE GLN ASP GLY ILE TYR ILE          
SEQRES  11 A  204  PHE VAL LYS PRO PRO SER ILE ASP ILE LEU LEU GLY ARG          
SEQRES  12 A  204  LEU LYS ASN ARG ASN THR GLU LYS PRO GLU GLU ILE ASN          
SEQRES  13 A  204  LYS ARG MSE GLN GLU LEU THR ARG GLU MSE ASP GLU ALA          
SEQRES  14 A  204  ASP LYS VAL GLY PHE ASN TYR PHE ILE VAL ASN ASP ASP          
SEQRES  15 A  204  LEU ALA ARG THR TYR ALA GLU LEU ARG GLU TYR LEU LEU          
SEQRES  16 A  204  GLY SER TYR PRO GLN LEU ARG GLY GLY                          
HET    MSE  A   1       8                                                       
HET    MSE  A 102       8                                                       
HET    MSE  A 151       8                                                       
HET    MSE  A 158       8                                                       
HET    5GP  A 197      24                                                       
HET    POP  A 198      14                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     5GP GUANOSINE-5'-MONOPHOSPHATE                                       
HETNAM     POP PYROPHOSPHATE 2-                                                 
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   2  5GP    C10 H14 N5 O8 P                                              
FORMUL   3  POP    H2 O7 P2 2-                                                  
FORMUL   4  HOH   *64(H2 O)                                                     
CRYST1   43.535   43.535  342.800  90.00  90.00 120.00 P 65 2 2     12          
HETATM    1  N   MSE A   1      13.901 -20.347  13.606  1.00 35.56           N  
HETATM    2  CA  MSE A   1      12.768 -20.610  14.547  1.00 35.82           C  
HETATM    3  C   MSE A   1      12.644 -19.525  15.613  1.00 33.28           C  
HETATM    4  O   MSE A   1      13.644 -19.039  16.145  1.00 32.71           O  
HETATM    5  CB  MSE A   1      12.943 -21.970  15.198  1.00 35.87           C  
HETATM    6  CG  MSE A   1      12.833 -23.110  14.211  1.00 38.17           C  
HETATM    7 SE   MSE A   1      13.246 -24.763  15.093  1.00 40.68          SE  
HETATM    8  CE  MSE A   1      13.144 -25.988  13.571  1.00 40.19           C  
ATOM      9  N   ALA A   2      11.405 -19.170  15.938  1.00 31.37           N  
ATOM     10  CA  ALA A   2      11.135 -17.968  16.703  1.00 29.53           C  
ATOM     11  C   ALA A   2      11.657 -18.063  18.143  1.00 28.70           C  
ATOM     12  O   ALA A   2      11.581 -19.123  18.770  1.00 28.55           O  
ATOM     13  CB  ALA A   2       9.648 -17.687  16.702  1.00 30.61           C  
ATOM     14  N   ARG A   3      12.206 -16.964  18.654  1.00 27.71           N  
ATOM     15  CA  ARG A   3      12.564 -16.899  20.069  1.00 28.09           C  
ATOM     16  C   ARG A   3      11.298 -16.967  20.908  1.00 25.61           C  
ATOM     17  O   ARG A   3      10.182 -16.753  20.410  1.00 23.60           O  
ATOM     18  CB  ARG A   3      13.326 -15.621  20.408  1.00 28.33           C  
ATOM     19  CG  ARG A   3      14.723 -15.541  19.837  1.00 31.03           C  
ATOM     20  CD  ARG A   3      15.450 -14.308  20.384  1.00 33.70           C  
ATOM     21  NE  ARG A   3      16.584 -13.910  19.550  1.00 38.46           N  
ATOM     22  CZ  ARG A   3      17.737 -14.572  19.476  1.00 39.06           C  
ATOM     23  NH1 ARG A   3      17.931 -15.692  20.179  1.00 41.48           N  
ATOM     24  NH2 ARG A   3      18.701 -14.116  18.683  1.00 41.38           N  
ATOM     25  N   ILE A   4      11.483 -17.286  22.183  1.00 23.53           N  
ATOM     26  CA  ILE A   4      10.380 -17.417  23.093  1.00 23.11           C  
ATOM     27  C   ILE A   4       9.820 -16.009  23.266  1.00 23.53           C  
ATOM     28  O   ILE A   4      10.592 -15.050  23.436  1.00 22.74           O  
ATOM     29  CB  ILE A   4      10.858 -18.136  24.407  1.00 23.62           C  
ATOM     30  CG1 ILE A   4       9.670 -18.635  25.210  1.00 24.44           C  
ATOM     31  CG2 ILE A   4      11.768 -17.238  25.240  1.00 25.52           C  
ATOM     32  CD1 ILE A   4      10.069 -19.626  26.308  1.00 22.77           C  
ATOM     33  N   PRO A   5       8.487 -15.850  23.110  1.00 21.91           N  
ATOM     34  CA  PRO A   5       7.902 -14.513  23.162  1.00 22.29           C  
ATOM     35  C   PRO A   5       8.017 -13.857  24.535  1.00 21.30           C  
ATOM     36  O   PRO A   5       7.785 -14.497  25.549  1.00 21.15           O  
ATOM     37  CB  PRO A   5       6.428 -14.734  22.829  1.00 22.40           C  
ATOM     38  CG  PRO A   5       6.199 -16.200  22.935  1.00 24.85           C  
ATOM     39  CD  PRO A   5       7.486 -16.894  22.850  1.00 22.58           C  
ATOM     40  N   PRO A   6       8.417 -12.582  24.566  1.00 20.04           N  
ATOM     41  CA  PRO A   6       8.401 -11.872  25.839  1.00 19.53           C  
ATOM     42  C   PRO A   6       7.005 -11.769  26.451  1.00 18.58           C  
ATOM     43  O   PRO A   6       6.001 -11.734  25.735  1.00 20.91           O  
ATOM     44  CB  PRO A   6       8.905 -10.474  25.481  1.00 21.12           C  
ATOM     45  CG  PRO A   6       9.572 -10.599  24.180  1.00 21.95           C  
ATOM     46  CD  PRO A   6       8.964 -11.771  23.458  1.00 20.37           C  
ATOM     47  N   LEU A   7       6.958 -11.682  27.776  1.00 18.60           N  
ATOM     48  CA  LEU A   7       5.744 -11.451  28.513  1.00 18.72           C  
ATOM     49  C   LEU A   7       5.647  -9.958  28.791  1.00 19.00           C  
ATOM     50  O   LEU A   7       6.573  -9.377  29.348  1.00 19.01           O  
ATOM     51  CB  LEU A   7       5.788 -12.196  29.844  1.00 18.48           C  
ATOM     52  CG  LEU A   7       4.606 -11.954  30.781  1.00 19.24           C  
ATOM     53  CD1 LEU A   7       3.246 -12.250  30.129  1.00 19.22           C  
ATOM     54  CD2 LEU A   7       4.818 -12.788  32.049  1.00 19.56           C  
ATOM     55  N   VAL A   8       4.530  -9.344  28.406  1.00 18.18           N  
ATOM     56  CA  VAL A   8       4.344  -7.912  28.575  1.00 19.38           C  
ATOM     57  C   VAL A   8       3.130  -7.634  29.459  1.00 19.39           C  
ATOM     58  O   VAL A   8       2.013  -8.032  29.143  1.00 19.93           O  
ATOM     59  CB  VAL A   8       4.165  -7.204  27.224  1.00 19.21           C  
ATOM     60  CG1 VAL A   8       4.183  -5.671  27.422  1.00 20.73           C  
ATOM     61  CG2 VAL A   8       5.276  -7.622  26.266  1.00 19.38           C  
ATOM     62  N   VAL A   9       3.366  -6.968  30.580  1.00 19.07           N  
ATOM     63  CA  VAL A   9       2.310  -6.692  31.546  1.00 18.96           C  
ATOM     64  C   VAL A   9       1.985  -5.207  31.574  1.00 19.30           C  
ATOM     65  O   VAL A   9       2.880  -4.373  31.686  1.00 19.92           O  
ATOM     66  CB  VAL A   9       2.672  -7.244  32.946  1.00 19.47           C  
ATOM     67  CG1 VAL A   9       1.555  -6.912  33.964  1.00 19.39           C  
ATOM     68  CG2 VAL A   9       2.925  -8.768  32.874  1.00 22.10           C  
ATOM     69  N   CYS A  10       0.695  -4.894  31.449  1.00 19.62           N  
ATOM     70  CA  CYS A  10       0.218  -3.509  31.317  1.00 19.20           C  
ATOM     71  C   CYS A  10      -1.016  -3.348  32.196  1.00 19.62           C  
ATOM     72  O   CYS A  10      -1.760  -4.288  32.429  1.00 18.09           O  
ATOM     73  CB  CYS A  10      -0.143  -3.257  29.849  1.00 20.10           C  
ATOM     74  SG  CYS A  10      -0.630  -1.604  29.446  1.00 22.09           S  
ATOM     75  N   GLY A  11      -1.214  -2.147  32.695  1.00 19.33           N  
ATOM     76  CA  GLY A  11      -2.439  -1.810  33.395  1.00 18.70           C  
ATOM     77  C   GLY A  11      -2.297  -0.485  34.087  1.00 18.31           C  
ATOM     78  O   GLY A  11      -1.201   0.051  34.188  1.00 19.48           O  
ATOM     79  N   PRO A  12      -3.423   0.067  34.572  1.00 17.63           N  
ATOM     80  CA  PRO A  12      -3.359   1.367  35.171  1.00 18.51           C  
ATOM     81  C   PRO A  12      -2.605   1.355  36.479  1.00 19.08           C  
ATOM     82  O   PRO A  12      -2.467   0.320  37.123  1.00 17.14           O  
ATOM     83  CB  PRO A  12      -4.823   1.759  35.375  1.00 18.35           C  
ATOM     84  CG  PRO A  12      -5.590   0.495  35.331  1.00 18.35           C  
ATOM     85  CD  PRO A  12      -4.775  -0.501  34.565  1.00 18.78           C  
ATOM     86  N   SER A  13      -2.089   2.517  36.836  1.00 20.37           N  
ATOM     87  CA  SER A  13      -1.440   2.708  38.114  1.00 20.53           C  
ATOM     88  C   SER A  13      -2.456   2.401  39.211  1.00 19.61           C  
ATOM     89  O   SER A  13      -3.604   2.859  39.139  1.00 21.19           O  
ATOM     90  CB  SER A  13      -0.942   4.159  38.223  1.00 22.10           C  
ATOM     91  OG  SER A  13      -0.408   4.423  39.505  1.00 26.66           O  
ATOM     92  N   GLY A  14      -2.024   1.657  40.227  1.00 19.56           N  
ATOM     93  CA  GLY A  14      -2.870   1.331  41.378  1.00 19.20           C  
ATOM     94  C   GLY A  14      -3.560  -0.021  41.222  1.00 19.17           C  
ATOM     95  O   GLY A  14      -4.307  -0.439  42.099  1.00 21.18           O  
ATOM     96  N   VAL A  15      -3.307  -0.713  40.120  1.00 17.58           N  
ATOM     97  CA  VAL A  15      -3.971  -2.014  39.880  1.00 18.61           C  
ATOM     98  C   VAL A  15      -3.285  -3.223  40.489  1.00 19.37           C  
ATOM     99  O   VAL A  15      -3.873  -4.312  40.512  1.00 21.56           O  
ATOM    100  CB  VAL A  15      -4.187  -2.253  38.366  1.00 18.00           C  
ATOM    101  CG1 VAL A  15      -2.912  -2.789  37.670  1.00 18.96           C  
ATOM    102  CG2 VAL A  15      -5.379  -3.137  38.143  1.00 20.40           C  
ATOM    103  N   GLY A  16      -2.069  -3.055  40.984  1.00 18.66           N  
ATOM    104  CA  GLY A  16      -1.306  -4.145  41.611  1.00 20.19           C  
ATOM    105  C   GLY A  16      -0.513  -5.018  40.656  1.00 21.40           C  
ATOM    106  O   GLY A  16      -0.136  -6.135  41.000  1.00 22.93           O  
ATOM    107  N   LYS A  17      -0.217  -4.527  39.462  1.00 21.67           N  
ATOM    108  CA  LYS A  17       0.521  -5.339  38.502  1.00 22.68           C  
ATOM    109  C   LYS A  17       1.993  -5.578  38.938  1.00 23.25           C  
ATOM    110  O   LYS A  17       2.568  -6.629  38.652  1.00 21.58           O  
ATOM    111  CB  LYS A  17       0.413  -4.744  37.084  1.00 24.75           C  
ATOM    112  CG  LYS A  17       1.213  -3.530  36.866  1.00 22.84           C  
ATOM    113  CD  LYS A  17       0.732  -2.687  35.675  1.00 22.84           C  
ATOM    114  CE  LYS A  17       1.317  -1.303  35.783  1.00 24.81           C  
ATOM    115  NZ  LYS A  17       0.493  -0.422  36.705  1.00 25.02           N  
ATOM    116  N   GLY A  18       2.575  -4.638  39.671  1.00 21.40           N  
ATOM    117  CA  GLY A  18       3.925  -4.810  40.202  1.00 21.98           C  
ATOM    118  C   GLY A  18       4.002  -6.011  41.137  1.00 19.63           C  
ATOM    119  O   GLY A  18       4.899  -6.853  41.022  1.00 20.08           O  
ATOM    120  N   THR A  19       3.042  -6.122  42.036  1.00 19.41           N  
ATOM    121  CA  THR A  19       3.008  -7.260  42.952  1.00 18.85           C  
ATOM    122  C   THR A  19       2.808  -8.579  42.203  1.00 18.53           C  
ATOM    123  O   THR A  19       3.462  -9.573  42.521  1.00 19.13           O  
ATOM    124  CB  THR A  19       1.939  -7.082  43.982  1.00 21.39           C  
ATOM    125  OG1 THR A  19       2.161  -5.824  44.632  1.00 22.30           O  
ATOM    126  CG2 THR A  19       2.002  -8.192  45.001  1.00 20.69           C  
ATOM    127  N   LEU A  20       1.905  -8.598  41.238  1.00 18.72           N  
ATOM    128  CA  LEU A  20       1.714  -9.803  40.432  1.00 18.00           C  
ATOM    129  C   LEU A  20       3.026 -10.197  39.745  1.00 18.48           C  
ATOM    130  O   LEU A  20       3.401 -11.389  39.691  1.00 17.74           O  
ATOM    131  CB  LEU A  20       0.615  -9.606  39.395  1.00 19.67           C  
ATOM    132  CG  LEU A  20      -0.802  -9.539  39.945  1.00 20.67           C  
ATOM    133  CD1 LEU A  20      -1.768  -9.190  38.831  1.00 22.12           C  
ATOM    134  CD2 LEU A  20      -1.149 -10.859  40.618  1.00 21.86           C  
ATOM    135  N   ILE A  21       3.721  -9.223  39.164  1.00 18.36           N  
ATOM    136  CA  ILE A  21       5.018  -9.498  38.532  1.00 18.42           C  
ATOM    137  C   ILE A  21       6.031 -10.086  39.525  1.00 19.19           C  
ATOM    138  O   ILE A  21       6.742 -11.056  39.206  1.00 19.10           O  
ATOM    139  CB  ILE A  21       5.599  -8.244  37.832  1.00 18.68           C  
ATOM    140  CG1 ILE A  21       4.765  -7.903  36.594  1.00 19.71           C  
ATOM    141  CG2 ILE A  21       7.051  -8.458  37.447  1.00 19.08           C  
ATOM    142  CD1 ILE A  21       5.030  -6.477  36.061  1.00 21.24           C  
ATOM    143  N   LYS A  22       6.085  -9.533  40.731  1.00 19.55           N  
ATOM    144  CA  LYS A  22       6.968 -10.056  41.785  1.00 19.52           C  
ATOM    145  C   LYS A  22       6.637 -11.510  42.165  1.00 19.78           C  
ATOM    146  O   LYS A  22       7.522 -12.295  42.481  1.00 19.46           O  
ATOM    147  CB  LYS A  22       6.930  -9.151  43.015  1.00 20.10           C  
ATOM    148  CG  LYS A  22       7.600  -7.813  42.797  1.00 21.31           C  
ATOM    149  CD  LYS A  22       7.569  -6.946  44.052  1.00 22.71           C  
ATOM    150  CE  LYS A  22       8.343  -5.637  43.846  1.00 26.88           C  
ATOM    151  NZ  LYS A  22       7.684  -4.843  42.805  1.00 34.20           N  
ATOM    152  N   LYS A  23       5.358 -11.860  42.121  1.00 18.97           N  
ATOM    153  CA  LYS A  23       4.947 -13.231  42.342  1.00 19.24           C  
ATOM    154  C   LYS A  23       5.392 -14.153  41.212  1.00 18.16           C  
ATOM    155  O   LYS A  23       5.829 -15.267  41.487  1.00 17.53           O  
ATOM    156  CB  LYS A  23       3.449 -13.315  42.563  1.00 18.85           C  
ATOM    157  CG  LYS A  23       3.012 -12.641  43.833  1.00 20.83           C  
ATOM    158  CD  LYS A  23       1.497 -12.734  44.035  1.00 22.70           C  
ATOM    159  CE  LYS A  23       1.074 -14.062  44.538  1.00 25.14           C  
ATOM    160  NZ  LYS A  23       1.560 -14.357  45.940  1.00 25.28           N  
ATOM    161  N   VAL A  24       5.310 -13.698  39.959  1.00 17.20           N  
ATOM    162  CA  VAL A  24       5.791 -14.488  38.817  1.00 18.08           C  
ATOM    163  C   VAL A  24       7.267 -14.749  38.965  1.00 18.19           C  
ATOM    164  O   VAL A  24       7.740 -15.872  38.759  1.00 17.75           O  
ATOM    165  CB  VAL A  24       5.578 -13.782  37.480  1.00 18.38           C  
ATOM    166  CG1 VAL A  24       6.291 -14.556  36.331  1.00 17.91           C  
ATOM    167  CG2 VAL A  24       4.050 -13.623  37.210  1.00 18.93           C  
ATOM    168  N   LEU A  25       7.997 -13.705  39.344  1.00 17.50           N  
ATOM    169  CA  LEU A  25       9.458 -13.798  39.485  1.00 18.42           C  
ATOM    170  C   LEU A  25       9.850 -14.649  40.683  1.00 19.30           C  
ATOM    171  O   LEU A  25      10.928 -15.243  40.702  1.00 20.43           O  
ATOM    172  CB  LEU A  25      10.060 -12.394  39.589  1.00 19.07           C  
ATOM    173  CG  LEU A  25       9.963 -11.514  38.351  1.00 19.18           C  
ATOM    174  CD1 LEU A  25      10.396 -10.042  38.655  1.00 19.71           C  
ATOM    175  CD2 LEU A  25      10.757 -12.081  37.197  1.00 24.03           C  
ATOM    176  N   SER A  26       8.974 -14.697  41.675  1.00 19.52           N  
ATOM    177  CA  SER A  26       9.152 -15.522  42.854  1.00 19.13           C  
ATOM    178  C   SER A  26       8.980 -16.998  42.551  1.00 19.40           C  
ATOM    179  O   SER A  26       9.743 -17.832  43.074  1.00 20.34           O  
ATOM    180  CB  SER A  26       8.166 -15.106  43.968  1.00 19.48           C  
ATOM    181  OG  SER A  26       8.453 -13.784  44.419  1.00 22.33           O  
ATOM    182  N   GLU A  27       7.973 -17.343  41.751  1.00 18.90           N  
ATOM    183  CA  GLU A  27       7.754 -18.749  41.397  1.00 18.78           C  
ATOM    184  C   GLU A  27       8.703 -19.232  40.307  1.00 18.92           C  
ATOM    185  O   GLU A  27       9.142 -20.408  40.330  1.00 18.85           O  
ATOM    186  CB  GLU A  27       6.308 -19.011  40.953  1.00 19.07           C  
ATOM    187  CG  GLU A  27       6.075 -20.481  40.669  1.00 19.74           C  
ATOM    188  CD  GLU A  27       4.632 -20.896  40.481  1.00 20.90           C  
ATOM    189  OE1 GLU A  27       3.726 -20.026  40.366  1.00 20.37           O  
ATOM    190  OE2 GLU A  27       4.449 -22.138  40.388  1.00 22.76           O  
ATOM    191  N   PHE A  28       9.025 -18.341  39.367  1.00 18.99           N  
ATOM    192  CA  PHE A  28       9.796 -18.691  38.164  1.00 18.75           C  
ATOM    193  C   PHE A  28      11.105 -17.872  37.974  1.00 19.34           C  
ATOM    194  O   PHE A  28      11.342 -17.296  36.899  1.00 18.86           O  
ATOM    195  CB  PHE A  28       8.904 -18.491  36.932  1.00 18.89           C  
ATOM    196  CG  PHE A  28       7.577 -19.230  36.974  1.00 17.10           C  
ATOM    197  CD1 PHE A  28       7.504 -20.589  36.713  1.00 17.94           C  
ATOM    198  CD2 PHE A  28       6.398 -18.548  37.215  1.00 18.92           C  
ATOM    199  CE1 PHE A  28       6.305 -21.263  36.731  1.00 18.89           C  
ATOM    200  CE2 PHE A  28       5.180 -19.221  37.227  1.00 19.59           C  
ATOM    201  CZ  PHE A  28       5.142 -20.587  36.991  1.00 18.16           C  
ATOM    202  N   PRO A  29      11.940 -17.787  39.024  1.00 18.55           N  
ATOM    203  CA  PRO A  29      13.054 -16.849  38.996  1.00 19.87           C  
ATOM    204  C   PRO A  29      14.166 -17.195  38.007  1.00 20.39           C  
ATOM    205  O   PRO A  29      14.884 -16.280  37.565  1.00 22.27           O  
ATOM    206  CB  PRO A  29      13.591 -16.915  40.415  1.00 20.14           C  
ATOM    207  CG  PRO A  29      13.236 -18.235  40.872  1.00 20.38           C  
ATOM    208  CD  PRO A  29      11.895 -18.497  40.297  1.00 19.43           C  
ATOM    209  N   SER A  30      14.315 -18.483  37.684  1.00 20.64           N  
ATOM    210  CA  SER A  30      15.290 -18.924  36.674  1.00 21.07           C  
ATOM    211  C   SER A  30      14.734 -18.869  35.246  1.00 21.62           C  
ATOM    212  O   SER A  30      15.448 -19.202  34.291  1.00 22.69           O  
ATOM    213  CB  SER A  30      15.722 -20.358  36.931  1.00 22.25           C  
ATOM    214  OG  SER A  30      16.149 -20.541  38.267  1.00 23.89           O  
ATOM    215  N   ARG A  31      13.468 -18.491  35.091  1.00 18.62           N  
ATOM    216  CA  ARG A  31      12.805 -18.601  33.785  1.00 18.91           C  
ATOM    217  C   ARG A  31      12.593 -17.245  33.112  1.00 20.06           C  
ATOM    218  O   ARG A  31      12.582 -17.152  31.871  1.00 20.55           O  
ATOM    219  CB  ARG A  31      11.461 -19.333  33.913  1.00 18.39           C  
ATOM    220  CG  ARG A  31      11.437 -20.594  34.777  1.00 20.09           C  
ATOM    221  CD  ARG A  31      12.386 -21.702  34.361  1.00 20.92           C  
ATOM    222  NE  ARG A  31      12.383 -22.729  35.399  1.00 21.82           N  
ATOM    223  CZ  ARG A  31      13.365 -23.597  35.611  1.00 23.52           C  
ATOM    224  NH1 ARG A  31      14.447 -23.605  34.853  1.00 25.39           N  
ATOM    225  NH2 ARG A  31      13.245 -24.462  36.602  1.00 23.60           N  
ATOM    226  N   PHE A  32      12.407 -16.199  33.918  1.00 19.86           N  
ATOM    227  CA  PHE A  32      12.143 -14.834  33.405  1.00 19.75           C  
ATOM    228  C   PHE A  32      13.273 -13.910  33.827  1.00 21.24           C  
ATOM    229  O   PHE A  32      13.875 -14.104  34.875  1.00 21.67           O  
ATOM    230  CB  PHE A  32      10.853 -14.242  33.991  1.00 18.99           C  
ATOM    231  CG  PHE A  32       9.583 -14.929  33.558  1.00 19.47           C  
ATOM    232  CD1 PHE A  32       9.051 -15.976  34.311  1.00 17.35           C  
ATOM    233  CD2 PHE A  32       8.895 -14.512  32.447  1.00 20.82           C  
ATOM    234  CE1 PHE A  32       7.884 -16.600  33.925  1.00 20.51           C  
ATOM    235  CE2 PHE A  32       7.714 -15.125  32.054  1.00 18.80           C  
ATOM    236  CZ  PHE A  32       7.212 -16.184  32.803  1.00 19.63           C  
ATOM    237  N   ARG A  33      13.553 -12.890  33.014  1.00 21.98           N  
ATOM    238  CA  ARG A  33      14.408 -11.796  33.443  1.00 22.10           C  
ATOM    239  C   ARG A  33      13.594 -10.514  33.277  1.00 20.47           C  
ATOM    240  O   ARG A  33      13.110 -10.243  32.189  1.00 20.08           O  
ATOM    241  CB  ARG A  33      15.688 -11.717  32.614  1.00 22.44           C  
ATOM    242  CG  ARG A  33      16.663 -10.681  33.161  1.00 24.04           C  
ATOM    243  CD  ARG A  33      17.902 -10.458  32.328  1.00 26.32           C  
ATOM    244  NE  ARG A  33      18.722  -9.452  32.994  1.00 28.31           N  
ATOM    245  CZ  ARG A  33      18.488  -8.140  32.952  1.00 31.68           C  
ATOM    246  NH1 ARG A  33      17.497  -7.660  32.217  1.00 30.31           N  
ATOM    247  NH2 ARG A  33      19.272  -7.306  33.627  1.00 33.80           N  
ATOM    248  N   PHE A  34      13.450  -9.752  34.359  1.00 19.43           N  
ATOM    249  CA  PHE A  34      12.694  -8.500  34.356  1.00 19.59           C  
ATOM    250  C   PHE A  34      13.510  -7.420  33.637  1.00 19.68           C  
ATOM    251  O   PHE A  34      14.694  -7.205  33.946  1.00 20.22           O  
ATOM    252  CB  PHE A  34      12.401  -8.051  35.798  1.00 20.00           C  
ATOM    253  CG  PHE A  34      11.608  -6.777  35.884  1.00 19.70           C  
ATOM    254  CD1 PHE A  34      10.314  -6.725  35.394  1.00 19.36           C  
ATOM    255  CD2 PHE A  34      12.143  -5.650  36.466  1.00 19.00           C  
ATOM    256  CE1 PHE A  34       9.545  -5.554  35.458  1.00 19.79           C  
ATOM    257  CE2 PHE A  34      11.391  -4.462  36.528  1.00 21.08           C  
ATOM    258  CZ  PHE A  34      10.090  -4.422  36.028  1.00 21.20           C  
ATOM    259  N   SER A  35      12.867  -6.740  32.696  1.00 20.02           N  
ATOM    260  CA  SER A  35      13.478  -5.600  32.015  1.00 18.84           C  
ATOM    261  C   SER A  35      13.427  -4.358  32.901  1.00 19.08           C  
ATOM    262  O   SER A  35      12.339  -3.869  33.253  1.00 20.19           O  
ATOM    263  CB  SER A  35      12.771  -5.330  30.696  1.00 20.36           C  
ATOM    264  OG  SER A  35      13.236  -4.122  30.082  1.00 20.90           O  
ATOM    265  N   ILE A  36      14.605  -3.865  33.263  1.00 19.35           N  
ATOM    266  CA  ILE A  36      14.732  -2.688  34.106  1.00 18.82           C  
ATOM    267  C   ILE A  36      14.667  -1.457  33.205  1.00 19.33           C  
ATOM    268  O   ILE A  36      15.609  -1.146  32.496  1.00 20.21           O  
ATOM    269  CB  ILE A  36      16.045  -2.718  34.927  1.00 19.34           C  
ATOM    270  CG1 ILE A  36      16.135  -4.005  35.751  1.00 20.57           C  
ATOM    271  CG2 ILE A  36      16.143  -1.535  35.894  1.00 18.26           C  
ATOM    272  CD1 ILE A  36      17.511  -4.280  36.235  1.00 20.37           C  
ATOM    273  N   SER A  37      13.538  -0.755  33.267  1.00 18.47           N  
ATOM    274  CA  SER A  37      13.308   0.428  32.460  1.00 18.32           C  
ATOM    275  C   SER A  37      14.095   1.598  33.016  1.00 17.81           C  
ATOM    276  O   SER A  37      14.497   1.609  34.189  1.00 18.52           O  
ATOM    277  CB  SER A  37      11.808   0.785  32.452  1.00 19.03           C  
ATOM    278  OG  SER A  37      11.030  -0.207  31.794  1.00 19.59           O  
ATOM    279  N   CYS A  38      14.367   2.568  32.150  1.00 18.34           N  
ATOM    280  CA  CYS A  38      14.795   3.882  32.625  1.00 17.03           C  
ATOM    281  C   CYS A  38      13.579   4.714  32.911  1.00 18.54           C  
ATOM    282  O   CYS A  38      12.610   4.663  32.182  1.00 17.82           O  
ATOM    283  CB  CYS A  38      15.616   4.631  31.590  1.00 18.66           C  
ATOM    284  SG  CYS A  38      17.213   3.904  31.324  1.00 21.17           S  
ATOM    285  N   THR A  39      13.657   5.513  33.955  1.00 17.80           N  
ATOM    286  CA  THR A  39      12.642   6.526  34.211  1.00 17.83           C  
ATOM    287  C   THR A  39      13.284   7.789  34.795  1.00 16.99           C  
ATOM    288  O   THR A  39      14.322   7.740  35.451  1.00 19.28           O  
ATOM    289  CB  THR A  39      11.509   6.034  35.138  1.00 15.99           C  
ATOM    290  OG1 THR A  39      10.494   7.058  35.252  1.00 18.95           O  
ATOM    291  CG2 THR A  39      12.021   5.709  36.521  1.00 15.98           C  
ATOM    292  N   THR A  40      12.638   8.912  34.520  1.00 17.60           N  
ATOM    293  CA  THR A  40      13.020  10.215  35.058  1.00 20.02           C  
ATOM    294  C   THR A  40      12.245  10.556  36.330  1.00 20.71           C  
ATOM    295  O   THR A  40      12.541  11.563  36.977  1.00 20.13           O  
ATOM    296  CB  THR A  40      12.813  11.345  34.031  1.00 20.04           C  
ATOM    297  OG1 THR A  40      11.420  11.474  33.703  1.00 20.31           O  
ATOM    298  CG2 THR A  40      13.637  11.081  32.769  1.00 20.98           C  
ATOM    299  N   ARG A  41      11.266   9.737  36.718  1.00 20.75           N  
ATOM    300  CA  ARG A  41      10.510  10.064  37.929  1.00 22.62           C  
ATOM    301  C   ARG A  41      11.384   9.819  39.158  1.00 23.65           C  
ATOM    302  O   ARG A  41      12.353   9.080  39.082  1.00 23.01           O  
ATOM    303  CB  ARG A  41       9.179   9.312  38.001  1.00 23.51           C  
ATOM    304  CG  ARG A  41       9.249   7.872  38.396  1.00 23.92           C  
ATOM    305  CD  ARG A  41       8.026   7.547  39.249  1.00 23.38           C  
ATOM    306  NE  ARG A  41       7.814   6.116  39.406  1.00 20.87           N  
ATOM    307  CZ  ARG A  41       8.408   5.348  40.303  1.00 21.61           C  
ATOM    308  NH1 ARG A  41       9.338   5.823  41.136  1.00 18.64           N  
ATOM    309  NH2 ARG A  41       8.067   4.076  40.351  1.00 21.65           N  
ATOM    310  N   ASN A  42      11.063  10.488  40.268  1.00 24.23           N  
ATOM    311  CA  ASN A  42      11.814  10.322  41.504  1.00 25.43           C  
ATOM    312  C   ASN A  42      11.602   8.917  42.079  1.00 25.48           C  
ATOM    313  O   ASN A  42      10.510   8.378  42.045  1.00 24.91           O  
ATOM    314  CB  ASN A  42      11.401  11.362  42.538  1.00 25.98           C  
ATOM    315  CG  ASN A  42      11.723  12.778  42.107  1.00 29.94           C  
ATOM    316  OD1 ASN A  42      10.916  13.691  42.306  1.00 35.62           O  
ATOM    317  ND2 ASN A  42      12.906  12.975  41.531  1.00 30.87           N  
ATOM    318  N   LYS A  43      12.671   8.342  42.606  1.00 26.46           N  
ATOM    319  CA  LYS A  43      12.636   7.016  43.205  1.00 27.57           C  
ATOM    320  C   LYS A  43      11.918   7.132  44.543  1.00 28.15           C  
ATOM    321  O   LYS A  43      12.093   8.126  45.259  1.00 26.59           O  
ATOM    322  CB  LYS A  43      14.086   6.547  43.374  1.00 28.33           C  
ATOM    323  CG  LYS A  43      14.375   5.307  44.211  1.00 28.10           C  
ATOM    324  CD  LYS A  43      15.890   5.327  44.569  1.00 29.39           C  
ATOM    325  CE  LYS A  43      16.265   4.712  45.922  1.00 30.89           C  
ATOM    326  NZ  LYS A  43      15.226   4.729  46.980  1.00 32.07           N  
ATOM    327  N   ARG A  44      11.083   6.148  44.859  1.00 28.86           N  
ATOM    328  CA  ARG A  44      10.419   6.097  46.165  1.00 30.42           C  
ATOM    329  C   ARG A  44      11.371   5.429  47.160  1.00 30.71           C  
ATOM    330  O   ARG A  44      12.327   4.763  46.751  1.00 30.02           O  
ATOM    331  CB  ARG A  44       9.095   5.329  46.089  1.00 32.42           C  
ATOM    332  CG  ARG A  44       8.122   5.777  45.008  1.00 35.40           C  
ATOM    333  CD  ARG A  44       8.083   7.271  44.828  1.00 41.24           C  
ATOM    334  NE  ARG A  44       6.917   7.698  44.050  1.00 42.46           N  
ATOM    335  CZ  ARG A  44       6.860   8.780  43.267  1.00 44.78           C  
ATOM    336  NH1 ARG A  44       7.911   9.580  43.102  1.00 44.62           N  
ATOM    337  NH2 ARG A  44       5.724   9.055  42.623  1.00 46.67           N  
ATOM    338  N   GLU A  45      11.115   5.575  48.459  1.00 30.94           N  
ATOM    339  CA  GLU A  45      12.147   5.195  49.433  1.00 32.09           C  
ATOM    340  C   GLU A  45      12.514   3.714  49.430  1.00 31.55           C  
ATOM    341  O   GLU A  45      13.667   3.384  49.703  1.00 34.58           O  
ATOM    342  CB  GLU A  45      11.891   5.734  50.863  1.00 33.19           C  
ATOM    343  CG  GLU A  45      10.564   5.420  51.530  1.00 36.15           C  
ATOM    344  CD  GLU A  45      10.347   6.238  52.834  1.00 36.29           C  
ATOM    345  OE1 GLU A  45      11.211   7.065  53.212  1.00 41.40           O  
ATOM    346  OE2 GLU A  45       9.297   6.061  53.483  1.00 43.90           O  
ATOM    347  N   LYS A  46      11.588   2.825  49.092  1.00 29.56           N  
ATOM    348  CA  LYS A  46      11.947   1.395  49.064  1.00 29.72           C  
ATOM    349  C   LYS A  46      12.098   0.810  47.655  1.00 27.63           C  
ATOM    350  O   LYS A  46      12.079  -0.399  47.471  1.00 27.17           O  
ATOM    351  CB  LYS A  46      10.972   0.591  49.924  1.00 30.01           C  
ATOM    352  CG  LYS A  46      11.128   0.862  51.414  1.00 32.50           C  
ATOM    353  CD  LYS A  46      12.501   0.439  51.917  1.00 33.76           C  
ATOM    354  CE  LYS A  46      12.592   0.468  53.427  1.00 35.18           C  
ATOM    355  NZ  LYS A  46      14.020   0.566  53.872  1.00 36.98           N  
ATOM    356  N   GLU A  47      12.249   1.681  46.658  1.00 25.78           N  
ATOM    357  CA  GLU A  47      12.668   1.254  45.338  1.00 24.35           C  
ATOM    358  C   GLU A  47      14.180   1.286  45.282  1.00 23.92           C  
ATOM    359  O   GLU A  47      14.826   1.972  46.083  1.00 25.08           O  
ATOM    360  CB  GLU A  47      12.084   2.156  44.257  1.00 24.15           C  
ATOM    361  CG  GLU A  47      10.651   1.913  44.022  1.00 24.15           C  
ATOM    362  CD  GLU A  47      10.074   2.822  42.957  1.00 25.60           C  
ATOM    363  OE1 GLU A  47      10.339   4.035  43.004  1.00 24.30           O  
ATOM    364  OE2 GLU A  47       9.342   2.316  42.093  1.00 28.24           O  
ATOM    365  N   THR A  48      14.746   0.539  44.344  1.00 23.17           N  
ATOM    366  CA  THR A  48      16.184   0.430  44.232  1.00 22.29           C  
ATOM    367  C   THR A  48      16.642   0.682  42.802  1.00 21.87           C  
ATOM    368  O   THR A  48      16.174   0.037  41.864  1.00 19.94           O  
ATOM    369  CB  THR A  48      16.639  -0.955  44.713  1.00 22.69           C  
ATOM    370  OG1 THR A  48      16.207  -1.119  46.062  1.00 24.06           O  
ATOM    371  CG2 THR A  48      18.156  -1.096  44.663  1.00 22.56           C  
ATOM    372  N   ASN A  49      17.568   1.621  42.654  1.00 23.32           N  
ATOM    373  CA  ASN A  49      18.146   1.933  41.355  1.00 24.33           C  
ATOM    374  C   ASN A  49      18.871   0.706  40.849  1.00 24.21           C  
ATOM    375  O   ASN A  49      19.670   0.127  41.579  1.00 24.98           O  
ATOM    376  CB  ASN A  49      19.110   3.115  41.480  1.00 26.03           C  
ATOM    377  CG  ASN A  49      19.612   3.607  40.140  1.00 27.54           C  
ATOM    378  OD1 ASN A  49      18.850   3.730  39.180  1.00 24.26           O  
ATOM    379  ND2 ASN A  49      20.906   3.912  40.076  1.00 31.98           N  
ATOM    380  N   GLY A  50      18.559   0.270  39.629  1.00 22.96           N  
ATOM    381  CA  GLY A  50      19.154  -0.948  39.075  1.00 23.07           C  
ATOM    382  C   GLY A  50      18.447  -2.241  39.443  1.00 22.58           C  
ATOM    383  O   GLY A  50      18.957  -3.332  39.175  1.00 24.39           O  
ATOM    384  N   VAL A  51      17.253  -2.135  40.028  1.00 21.94           N  
ATOM    385  CA  VAL A  51      16.417  -3.299  40.306  1.00 21.55           C  
ATOM    386  C   VAL A  51      15.027  -3.054  39.771  1.00 21.16           C  
ATOM    387  O   VAL A  51      14.542  -3.779  38.906  1.00 21.60           O  
ATOM    388  CB  VAL A  51      16.362  -3.587  41.815  1.00 21.55           C  
ATOM    389  CG1 VAL A  51      15.384  -4.734  42.141  1.00 23.43           C  
ATOM    390  CG2 VAL A  51      17.753  -3.879  42.342  1.00 21.66           C  
ATOM    391  N   ASP A  52      14.404  -1.985  40.254  1.00 20.15           N  
ATOM    392  CA  ASP A  52      13.060  -1.591  39.829  1.00 20.24           C  
ATOM    393  C   ASP A  52      13.088  -0.751  38.541  1.00 19.98           C  
ATOM    394  O   ASP A  52      12.316  -0.992  37.630  1.00 20.03           O  
ATOM    395  CB  ASP A  52      12.424  -0.779  40.937  1.00 20.20           C  
ATOM    396  CG  ASP A  52      12.270  -1.572  42.203  1.00 22.98           C  
ATOM    397  OD1 ASP A  52      11.424  -2.488  42.198  1.00 27.96           O  
ATOM    398  OD2 ASP A  52      13.010  -1.308  43.166  1.00 23.20           O  
ATOM    399  N   TYR A  53      13.997   0.221  38.519  1.00 19.29           N  
ATOM    400  CA  TYR A  53      14.252   1.097  37.378  1.00 19.22           C  
ATOM    401  C   TYR A  53      15.715   1.500  37.445  1.00 18.14           C  
ATOM    402  O   TYR A  53      16.355   1.345  38.493  1.00 18.48           O  
ATOM    403  CB  TYR A  53      13.437   2.400  37.471  1.00 18.24           C  
ATOM    404  CG  TYR A  53      11.954   2.254  37.212  1.00 18.46           C  
ATOM    405  CD1 TYR A  53      11.032   2.261  38.255  1.00 20.13           C  
ATOM    406  CD2 TYR A  53      11.468   2.158  35.919  1.00 18.60           C  
ATOM    407  CE1 TYR A  53       9.680   2.121  38.004  1.00 19.91           C  
ATOM    408  CE2 TYR A  53      10.107   2.027  35.654  1.00 18.19           C  
ATOM    409  CZ  TYR A  53       9.220   2.007  36.709  1.00 20.02           C  
ATOM    410  OH  TYR A  53       7.866   1.900  36.468  1.00 20.01           O  
ATOM    411  N   TYR A  54      16.217   2.041  36.345  1.00 17.68           N  
ATOM    412  CA  TYR A  54      17.385   2.916  36.352  1.00 19.18           C  
ATOM    413  C   TYR A  54      16.825   4.328  36.420  1.00 19.33           C  
ATOM    414  O   TYR A  54      16.210   4.806  35.467  1.00 19.54           O  
ATOM    415  CB  TYR A  54      18.228   2.773  35.091  1.00 19.51           C  
ATOM    416  CG  TYR A  54      18.811   1.397  34.919  1.00 21.09           C  
ATOM    417  CD1 TYR A  54      19.831   0.955  35.751  1.00 23.56           C  
ATOM    418  CD2 TYR A  54      18.298   0.504  33.968  1.00 20.70           C  
ATOM    419  CE1 TYR A  54      20.361  -0.319  35.621  1.00 23.78           C  
ATOM    420  CE2 TYR A  54      18.844  -0.754  33.816  1.00 19.91           C  
ATOM    421  CZ  TYR A  54      19.860  -1.164  34.650  1.00 23.79           C  
ATOM    422  OH  TYR A  54      20.376  -2.434  34.510  1.00 24.10           O  
ATOM    423  N   PHE A  55      17.003   4.972  37.556  1.00 19.45           N  
ATOM    424  CA  PHE A  55      16.504   6.331  37.744  1.00 19.83           C  
ATOM    425  C   PHE A  55      17.519   7.323  37.205  1.00 20.95           C  
ATOM    426  O   PHE A  55      18.609   7.431  37.738  1.00 19.94           O  
ATOM    427  CB  PHE A  55      16.239   6.576  39.227  1.00 20.93           C  
ATOM    428  CG  PHE A  55      15.177   5.686  39.799  1.00 19.44           C  
ATOM    429  CD1 PHE A  55      15.511   4.476  40.411  1.00 21.25           C  
ATOM    430  CD2 PHE A  55      13.843   6.044  39.716  1.00 20.68           C  
ATOM    431  CE1 PHE A  55      14.525   3.645  40.957  1.00 22.46           C  
ATOM    432  CE2 PHE A  55      12.856   5.228  40.234  1.00 21.42           C  
ATOM    433  CZ  PHE A  55      13.199   4.012  40.870  1.00 21.63           C  
ATOM    434  N   VAL A  56      17.146   8.052  36.151  1.00 20.65           N  
ATOM    435  CA  VAL A  56      18.057   8.980  35.479  1.00 21.58           C  
ATOM    436  C   VAL A  56      17.409  10.362  35.426  1.00 22.30           C  
ATOM    437  O   VAL A  56      16.216  10.507  35.685  1.00 21.94           O  
ATOM    438  CB  VAL A  56      18.397   8.458  34.065  1.00 21.71           C  
ATOM    439  CG1 VAL A  56      19.083   7.099  34.167  1.00 21.68           C  
ATOM    440  CG2 VAL A  56      17.124   8.356  33.207  1.00 20.77           C  
ATOM    441  N   ASP A  57      18.185  11.400  35.148  1.00 24.01           N  
ATOM    442  CA  ASP A  57      17.555  12.701  34.970  1.00 25.42           C  
ATOM    443  C   ASP A  57      17.150  12.821  33.504  1.00 25.44           C  
ATOM    444  O   ASP A  57      17.570  12.012  32.677  1.00 24.54           O  
ATOM    445  CB  ASP A  57      18.437  13.851  35.471  1.00 26.96           C  
ATOM    446  CG  ASP A  57      19.675  14.055  34.650  1.00 30.47           C  
ATOM    447  OD1 ASP A  57      19.692  13.701  33.456  1.00 35.94           O  
ATOM    448  OD2 ASP A  57      20.645  14.609  35.211  1.00 38.02           O  
ATOM    449  N   LYS A  58      16.312  13.809  33.205  1.00 26.88           N  
ATOM    450  CA  LYS A  58      15.696  13.950  31.887  1.00 27.26           C  
ATOM    451  C   LYS A  58      16.758  14.193  30.806  1.00 26.15           C  
ATOM    452  O   LYS A  58      16.623  13.731  29.680  1.00 24.77           O  
ATOM    453  CB  LYS A  58      14.660  15.075  31.946  1.00 28.12           C  
ATOM    454  CG  LYS A  58      13.699  15.162  30.768  1.00 30.08           C  
ATOM    455  CD  LYS A  58      12.792  16.419  30.851  1.00 31.56           C  
ATOM    456  CE  LYS A  58      13.530  17.748  30.581  1.00 35.50           C  
ATOM    457  NZ  LYS A  58      13.519  18.169  29.135  1.00 36.76           N  
ATOM    458  N   ASP A  59      17.827  14.897  31.169  1.00 26.82           N  
ATOM    459  CA  ASP A  59      18.988  15.079  30.288  1.00 27.57           C  
ATOM    460  C   ASP A  59      19.605  13.752  29.871  1.00 26.22           C  
ATOM    461  O   ASP A  59      19.910  13.541  28.702  1.00 25.74           O  
ATOM    462  CB  ASP A  59      20.067  15.912  30.992  1.00 28.82           C  
ATOM    463  CG  ASP A  59      19.849  17.409  30.857  1.00 33.50           C  
ATOM    464  OD1 ASP A  59      18.856  17.847  30.222  1.00 38.50           O  
ATOM    465  OD2 ASP A  59      20.691  18.158  31.402  1.00 39.74           O  
ATOM    466  N   ASP A  60      19.780  12.847  30.826  1.00 24.75           N  
ATOM    467  CA  ASP A  60      20.400  11.567  30.514  1.00 24.56           C  
ATOM    468  C   ASP A  60      19.440  10.655  29.769  1.00 23.14           C  
ATOM    469  O   ASP A  60      19.869   9.839  28.961  1.00 22.21           O  
ATOM    470  CB  ASP A  60      20.949  10.912  31.778  1.00 25.39           C  
ATOM    471  CG  ASP A  60      22.197  11.617  32.299  1.00 29.60           C  
ATOM    472  OD1 ASP A  60      22.768  12.476  31.575  1.00 31.74           O  
ATOM    473  OD2 ASP A  60      22.616  11.313  33.437  1.00 34.25           O  
ATOM    474  N   PHE A  61      18.144  10.798  30.037  1.00 21.47           N  
ATOM    475  CA  PHE A  61      17.141  10.051  29.301  1.00 21.17           C  
ATOM    476  C   PHE A  61      17.181  10.444  27.814  1.00 20.96           C  
ATOM    477  O   PHE A  61      17.169   9.571  26.930  1.00 19.31           O  
ATOM    478  CB  PHE A  61      15.744  10.298  29.861  1.00 20.33           C  
ATOM    479  CG  PHE A  61      14.726   9.315  29.372  1.00 19.24           C  
ATOM    480  CD1 PHE A  61      14.165   9.459  28.116  1.00 18.77           C  
ATOM    481  CD2 PHE A  61      14.367   8.225  30.136  1.00 17.15           C  
ATOM    482  CE1 PHE A  61      13.232   8.550  27.647  1.00 19.88           C  
ATOM    483  CE2 PHE A  61      13.430   7.317  29.673  1.00 18.35           C  
ATOM    484  CZ  PHE A  61      12.862   7.494  28.411  1.00 19.90           C  
ATOM    485  N   GLU A  62      17.218  11.747  27.556  1.00 21.47           N  
ATOM    486  CA  GLU A  62      17.290  12.270  26.181  1.00 22.51           C  
ATOM    487  C   GLU A  62      18.558  11.816  25.451  1.00 21.73           C  
ATOM    488  O   GLU A  62      18.516  11.468  24.267  1.00 21.51           O  
ATOM    489  CB  GLU A  62      17.218  13.801  26.170  1.00 22.99           C  
ATOM    490  CG  GLU A  62      17.005  14.355  24.747  1.00 23.24           C  
ATOM    491  CD  GLU A  62      17.131  15.861  24.579  1.00 29.29           C  
ATOM    492  OE1 GLU A  62      18.075  16.489  25.145  1.00 38.39           O  
ATOM    493  OE2 GLU A  62      16.307  16.421  23.805  1.00 36.39           O  
ATOM    494  N   ARG A  63      19.687  11.840  26.150  1.00 21.76           N  
ATOM    495  CA  ARG A  63      20.946  11.373  25.592  1.00 22.89           C  
ATOM    496  C   ARG A  63      20.850   9.915  25.213  1.00 21.19           C  
ATOM    497  O   ARG A  63      21.232   9.535  24.114  1.00 21.92           O  
ATOM    498  CB  ARG A  63      22.091  11.559  26.592  1.00 23.31           C  
ATOM    499  CG  ARG A  63      22.425  13.007  26.868  1.00 26.41           C  
ATOM    500  CD  ARG A  63      23.749  13.195  27.602  1.00 28.17           C  
ATOM    501  NE  ARG A  63      24.246  14.554  27.378  1.00 32.27           N  
ATOM    502  CZ  ARG A  63      23.773  15.647  27.982  1.00 34.17           C  
ATOM    503  NH1 ARG A  63      22.787  15.563  28.879  1.00 36.28           N  
ATOM    504  NH2 ARG A  63      24.297  16.835  27.690  1.00 34.05           N  
ATOM    505  N   LYS A  64      20.323   9.094  26.122  1.00 20.15           N  
ATOM    506  CA  LYS A  64      20.140   7.671  25.850  1.00 20.29           C  
ATOM    507  C   LYS A  64      19.220   7.435  24.653  1.00 19.03           C  
ATOM    508  O   LYS A  64      19.482   6.594  23.792  1.00 18.43           O  
ATOM    509  CB  LYS A  64      19.632   6.954  27.111  1.00 20.56           C  
ATOM    510  CG  LYS A  64      20.713   6.784  28.183  1.00 22.07           C  
ATOM    511  CD  LYS A  64      20.168   6.124  29.473  1.00 23.44           C  
ATOM    512  CE  LYS A  64      21.248   5.401  30.275  1.00 27.15           C  
ATOM    513  NZ  LYS A  64      22.458   6.204  30.640  1.00 29.65           N  
ATOM    514  N   LEU A  65      18.123   8.176  24.595  1.00 18.76           N  
ATOM    515  CA  LEU A  65      17.224   8.090  23.465  1.00 19.21           C  
ATOM    516  C   LEU A  65      17.925   8.405  22.140  1.00 19.32           C  
ATOM    517  O   LEU A  65      17.808   7.640  21.179  1.00 18.47           O  
ATOM    518  CB  LEU A  65      16.058   9.045  23.672  1.00 19.27           C  
ATOM    519  CG  LEU A  65      15.049   9.168  22.537  1.00 18.58           C  
ATOM    520  CD1 LEU A  65      14.434   7.816  22.177  1.00 16.41           C  
ATOM    521  CD2 LEU A  65      13.998  10.212  22.937  1.00 21.49           C  
ATOM    522  N   LYS A  66      18.636   9.528  22.091  1.00 19.89           N  
ATOM    523  CA  LYS A  66      19.256   9.982  20.839  1.00 20.51           C  
ATOM    524  C   LYS A  66      20.422   9.087  20.435  1.00 21.15           C  
ATOM    525  O   LYS A  66      20.736   8.986  19.253  1.00 20.38           O  
ATOM    526  CB  LYS A  66      19.714  11.452  20.915  1.00 21.25           C  
ATOM    527  CG  LYS A  66      18.550  12.437  20.969  1.00 20.58           C  
ATOM    528  CD  LYS A  66      18.954  13.869  20.724  1.00 20.98           C  
ATOM    529  CE  LYS A  66      19.608  14.516  21.907  1.00 22.43           C  
ATOM    530  NZ  LYS A  66      19.674  16.015  21.702  1.00 19.90           N  
ATOM    531  N   GLU A  67      21.071   8.456  21.413  1.00 21.30           N  
ATOM    532  CA  GLU A  67      22.133   7.477  21.123  1.00 22.40           C  
ATOM    533  C   GLU A  67      21.596   6.106  20.718  1.00 22.73           C  
ATOM    534  O   GLU A  67      22.376   5.215  20.390  1.00 24.33           O  
ATOM    535  CB  GLU A  67      23.090   7.325  22.313  1.00 24.64           C  
ATOM    536  CG  GLU A  67      23.909   8.599  22.654  1.00 30.25           C  
ATOM    537  CD  GLU A  67      24.690   9.204  21.470  1.00 39.00           C  
ATOM    538  OE1 GLU A  67      25.677   8.576  21.001  1.00 45.97           O  
ATOM    539  OE2 GLU A  67      24.337  10.330  21.025  1.00 41.42           O  
ATOM    540  N   GLY A  68      20.277   5.929  20.736  1.00 20.43           N  
ATOM    541  CA  GLY A  68      19.660   4.723  20.191  1.00 20.23           C  
ATOM    542  C   GLY A  68      19.560   3.561  21.170  1.00 19.82           C  
ATOM    543  O   GLY A  68      19.460   2.396  20.759  1.00 19.59           O  
ATOM    544  N   GLN A  69      19.572   3.876  22.455  1.00 18.14           N  
ATOM    545  CA  GLN A  69      19.465   2.851  23.509  1.00 19.70           C  
ATOM    546  C   GLN A  69      18.062   2.258  23.731  1.00 19.30           C  
ATOM    547  O   GLN A  69      17.955   1.194  24.360  1.00 19.86           O  
ATOM    548  CB  GLN A  69      19.948   3.409  24.847  1.00 19.88           C  
ATOM    549  CG  GLN A  69      21.344   4.000  24.865  1.00 24.20           C  
ATOM    550  CD  GLN A  69      22.437   2.983  24.757  1.00 30.29           C  
ATOM    551  OE1 GLN A  69      22.211   1.782  24.901  1.00 35.06           O  
ATOM    552  NE2 GLN A  69      23.654   3.460  24.497  1.00 34.89           N  
ATOM    553  N   PHE A  70      16.991   2.928  23.287  1.00 19.41           N  
ATOM    554  CA  PHE A  70      15.612   2.469  23.620  1.00 19.45           C  
ATOM    555  C   PHE A  70      14.881   1.748  22.493  1.00 19.49           C  
ATOM    556  O   PHE A  70      14.962   2.152  21.335  1.00 20.18           O  
ATOM    557  CB  PHE A  70      14.721   3.629  24.097  1.00 19.68           C  
ATOM    558  CG  PHE A  70      15.184   4.281  25.374  1.00 17.73           C  
ATOM    559  CD1 PHE A  70      15.309   3.551  26.544  1.00 20.12           C  
ATOM    560  CD2 PHE A  70      15.467   5.634  25.409  1.00 19.42           C  
ATOM    561  CE1 PHE A  70      15.730   4.162  27.707  1.00 19.93           C  
ATOM    562  CE2 PHE A  70      15.886   6.239  26.558  1.00 17.28           C  
ATOM    563  CZ  PHE A  70      16.021   5.510  27.711  1.00 19.45           C  
ATOM    564  N   LEU A  71      14.156   0.692  22.866  1.00 19.25           N  
ATOM    565  CA  LEU A  71      13.224  -0.020  21.982  1.00 20.21           C  
ATOM    566  C   LEU A  71      11.898   0.749  21.880  1.00 21.06           C  
ATOM    567  O   LEU A  71      11.210   0.718  20.858  1.00 21.43           O  
ATOM    568  CB  LEU A  71      12.925  -1.425  22.549  1.00 21.40           C  
ATOM    569  CG  LEU A  71      13.905  -2.565  22.294  1.00 24.70           C  
ATOM    570  CD1 LEU A  71      13.617  -3.772  23.194  1.00 24.64           C  
ATOM    571  CD2 LEU A  71      13.874  -2.964  20.822  1.00 28.87           C  
ATOM    572  N   GLU A  72      11.535   1.408  22.970  1.00 19.41           N  
ATOM    573  CA  GLU A  72      10.334   2.220  23.023  1.00 18.68           C  
ATOM    574  C   GLU A  72      10.477   3.182  24.182  1.00 18.40           C  
ATOM    575  O   GLU A  72      11.264   2.946  25.099  1.00 18.83           O  
ATOM    576  CB  GLU A  72       9.084   1.353  23.201  1.00 19.05           C  
ATOM    577  CG  GLU A  72       9.033   0.542  24.508  1.00 21.43           C  
ATOM    578  CD  GLU A  72       8.715   1.387  25.732  1.00 24.07           C  
ATOM    579  OE1 GLU A  72       9.269   1.098  26.827  1.00 23.68           O  
ATOM    580  OE2 GLU A  72       7.914   2.340  25.613  1.00 22.40           O  
ATOM    581  N   PHE A  73       9.678   4.234  24.155  1.00 19.16           N  
ATOM    582  CA  PHE A  73       9.623   5.162  25.262  1.00 19.45           C  
ATOM    583  C   PHE A  73       8.300   5.905  25.253  1.00 19.51           C  
ATOM    584  O   PHE A  73       7.583   5.975  24.239  1.00 18.21           O  
ATOM    585  CB  PHE A  73      10.778   6.156  25.197  1.00 20.77           C  
ATOM    586  CG  PHE A  73      10.641   7.154  24.072  1.00 22.19           C  
ATOM    587  CD1 PHE A  73      10.815   6.757  22.754  1.00 25.53           C  
ATOM    588  CD2 PHE A  73      10.272   8.463  24.331  1.00 26.70           C  
ATOM    589  CE1 PHE A  73      10.665   7.676  21.710  1.00 25.48           C  
ATOM    590  CE2 PHE A  73      10.124   9.376  23.298  1.00 24.60           C  
ATOM    591  CZ  PHE A  73      10.329   8.975  21.988  1.00 24.65           C  
ATOM    592  N   ASP A  74       7.973   6.477  26.392  1.00 19.07           N  
ATOM    593  CA  ASP A  74       6.769   7.300  26.464  1.00 19.45           C  
ATOM    594  C   ASP A  74       6.911   8.290  27.595  1.00 20.70           C  
ATOM    595  O   ASP A  74       7.802   8.149  28.445  1.00 20.53           O  
ATOM    596  CB  ASP A  74       5.524   6.418  26.653  1.00 20.78           C  
ATOM    597  CG  ASP A  74       4.213   7.151  26.307  1.00 20.43           C  
ATOM    598  OD1 ASP A  74       4.230   8.035  25.447  1.00 24.74           O  
ATOM    599  OD2 ASP A  74       3.172   6.830  26.894  1.00 29.82           O  
ATOM    600  N   LYS A  75       6.078   9.328  27.551  1.00 21.39           N  
ATOM    601  CA  LYS A  75       5.870  10.219  28.665  1.00 22.49           C  
ATOM    602  C   LYS A  75       4.609   9.710  29.383  1.00 23.19           C  
ATOM    603  O   LYS A  75       3.572   9.483  28.753  1.00 23.36           O  
ATOM    604  CB  LYS A  75       5.673  11.663  28.192  1.00 23.40           C  
ATOM    605  CG  LYS A  75       5.717  12.701  29.335  1.00 24.09           C  
ATOM    606  CD  LYS A  75       5.928  14.148  28.878  1.00 28.16           C  
ATOM    607  CE  LYS A  75       5.056  14.521  27.671  1.00 32.32           C  
ATOM    608  NZ  LYS A  75       5.244  15.962  27.220  1.00 33.72           N  
ATOM    609  N   TYR A  76       4.717   9.514  30.692  1.00 20.81           N  
ATOM    610  CA  TYR A  76       3.561   9.092  31.496  1.00 21.37           C  
ATOM    611  C   TYR A  76       3.569   9.990  32.725  1.00 20.51           C  
ATOM    612  O   TYR A  76       4.569  10.071  33.426  1.00 18.34           O  
ATOM    613  CB  TYR A  76       3.706   7.617  31.861  1.00 21.10           C  
ATOM    614  CG  TYR A  76       2.634   7.121  32.826  1.00 19.85           C  
ATOM    615  CD1 TYR A  76       1.489   6.488  32.359  1.00 22.35           C  
ATOM    616  CD2 TYR A  76       2.765   7.333  34.195  1.00 22.83           C  
ATOM    617  CE1 TYR A  76       0.504   6.044  33.247  1.00 21.44           C  
ATOM    618  CE2 TYR A  76       1.791   6.922  35.086  1.00 21.38           C  
ATOM    619  CZ  TYR A  76       0.668   6.273  34.616  1.00 23.86           C  
ATOM    620  OH  TYR A  76      -0.295   5.884  35.522  1.00 21.57           O  
ATOM    621  N   ALA A  77       2.480  10.706  32.972  1.00 22.25           N  
ATOM    622  CA  ALA A  77       2.386  11.540  34.165  1.00 23.01           C  
ATOM    623  C   ALA A  77       3.601  12.479  34.351  1.00 23.49           C  
ATOM    624  O   ALA A  77       4.258  12.487  35.381  1.00 25.62           O  
ATOM    625  CB  ALA A  77       2.178  10.632  35.404  1.00 22.86           C  
ATOM    626  N   ASN A  78       3.927  13.235  33.320  1.00 24.74           N  
ATOM    627  CA  ASN A  78       5.029  14.219  33.384  1.00 24.66           C  
ATOM    628  C   ASN A  78       6.448  13.665  33.506  1.00 23.73           C  
ATOM    629  O   ASN A  78       7.378  14.447  33.719  1.00 24.67           O  
ATOM    630  CB  ASN A  78       4.819  15.256  34.511  1.00 27.09           C  
ATOM    631  CG  ASN A  78       3.643  16.175  34.266  1.00 31.61           C  
ATOM    632  OD1 ASN A  78       3.463  16.718  33.164  1.00 36.93           O  
ATOM    633  ND2 ASN A  78       2.846  16.386  35.310  1.00 34.99           N  
ATOM    634  N   ASN A  79       6.633  12.351  33.347  1.00 22.54           N  
ATOM    635  CA  ASN A  79       7.973  11.769  33.322  1.00 21.45           C  
ATOM    636  C   ASN A  79       8.121  10.819  32.150  1.00 20.09           C  
ATOM    637  O   ASN A  79       7.132  10.355  31.570  1.00 19.10           O  
ATOM    638  CB  ASN A  79       8.259  11.012  34.613  1.00 21.86           C  
ATOM    639  CG  ASN A  79       8.515  11.919  35.767  1.00 25.22           C  
ATOM    640  OD1 ASN A  79       7.677  12.048  36.670  1.00 28.73           O  
ATOM    641  ND2 ASN A  79       9.679  12.565  35.761  1.00 21.47           N  
ATOM    642  N   PHE A  80       9.369  10.538  31.822  1.00 19.88           N  
ATOM    643  CA  PHE A  80       9.734   9.677  30.713  1.00 19.95           C  
ATOM    644  C   PHE A  80      10.091   8.283  31.220  1.00 18.07           C  
ATOM    645  O   PHE A  80      10.748   8.127  32.248  1.00 18.27           O  
ATOM    646  CB  PHE A  80      10.916  10.246  29.961  1.00 21.42           C  
ATOM    647  CG  PHE A  80      10.609  11.554  29.293  1.00 22.89           C  
ATOM    648  CD1 PHE A  80       9.730  11.596  28.221  1.00 27.53           C  
ATOM    649  CD2 PHE A  80      11.193  12.720  29.715  1.00 27.83           C  
ATOM    650  CE1 PHE A  80       9.420  12.796  27.602  1.00 28.06           C  
ATOM    651  CE2 PHE A  80      10.889  13.938  29.089  1.00 28.71           C  
ATOM    652  CZ  PHE A  80      10.005  13.970  28.042  1.00 27.93           C  
ATOM    653  N   TYR A  81       9.679   7.294  30.453  1.00 17.77           N  
ATOM    654  CA  TYR A  81       9.952   5.906  30.734  1.00 18.35           C  
ATOM    655  C   TYR A  81      10.387   5.251  29.458  1.00 19.05           C  
ATOM    656  O   TYR A  81       9.875   5.586  28.396  1.00 20.19           O  
ATOM    657  CB  TYR A  81       8.681   5.211  31.204  1.00 19.08           C  
ATOM    658  CG  TYR A  81       8.114   5.726  32.499  1.00 15.55           C  
ATOM    659  CD1 TYR A  81       8.277   5.018  33.680  1.00 17.15           C  
ATOM    660  CD2 TYR A  81       7.391   6.917  32.549  1.00 16.46           C  
ATOM    661  CE1 TYR A  81       7.734   5.501  34.883  1.00 16.56           C  
ATOM    662  CE2 TYR A  81       6.855   7.402  33.747  1.00 18.02           C  
ATOM    663  CZ  TYR A  81       7.039   6.691  34.902  1.00 19.31           C  
ATOM    664  OH  TYR A  81       6.484   7.183  36.069  1.00 18.13           O  
ATOM    665  N   GLY A  82      11.316   4.299  29.550  1.00 18.73           N  
ATOM    666  CA  GLY A  82      11.855   3.684  28.339  1.00 18.56           C  
ATOM    667  C   GLY A  82      12.482   2.322  28.561  1.00 19.10           C  
ATOM    668  O   GLY A  82      13.078   2.072  29.609  1.00 18.48           O  
ATOM    669  N   THR A  83      12.307   1.439  27.571  1.00 19.23           N  
ATOM    670  CA  THR A  83      12.806   0.074  27.608  1.00 19.51           C  
ATOM    671  C   THR A  83      14.103   0.015  26.846  1.00 19.21           C  
ATOM    672  O   THR A  83      14.178   0.415  25.664  1.00 19.29           O  
ATOM    673  CB  THR A  83      11.818  -0.920  26.947  1.00 19.37           C  
ATOM    674  OG1 THR A  83      10.600  -0.999  27.717  1.00 20.50           O  
ATOM    675  CG2 THR A  83      12.435  -2.289  26.837  1.00 19.55           C  
ATOM    676  N   LEU A  84      15.134  -0.480  27.519  1.00 19.75           N  
ATOM    677  CA  LEU A  84      16.462  -0.534  26.946  1.00 19.31           C  
ATOM    678  C   LEU A  84      16.625  -1.774  26.084  1.00 20.48           C  
ATOM    679  O   LEU A  84      16.312  -2.898  26.499  1.00 20.62           O  
ATOM    680  CB  LEU A  84      17.522  -0.548  28.042  1.00 19.20           C  
ATOM    681  CG  LEU A  84      17.695   0.707  28.888  1.00 19.64           C  
ATOM    682  CD1 LEU A  84      18.453   0.335  30.145  1.00 21.73           C  
ATOM    683  CD2 LEU A  84      18.414   1.803  28.092  1.00 19.60           C  
ATOM    684  N   LYS A  85      17.165  -1.576  24.887  1.00 20.74           N  
ATOM    685  CA  LYS A  85      17.567  -2.692  24.049  1.00 21.05           C  
ATOM    686  C   LYS A  85      18.489  -3.670  24.796  1.00 20.59           C  
ATOM    687  O   LYS A  85      18.318  -4.877  24.704  1.00 21.16           O  
ATOM    688  CB  LYS A  85      18.276  -2.182  22.803  1.00 21.09           C  
ATOM    689  CG  LYS A  85      17.362  -1.484  21.829  1.00 24.06           C  
ATOM    690  CD  LYS A  85      18.148  -0.710  20.783  1.00 24.43           C  
ATOM    691  CE  LYS A  85      17.221  -0.147  19.733  1.00 26.91           C  
ATOM    692  NZ  LYS A  85      17.975   0.550  18.672  1.00 28.19           N  
ATOM    693  N   SER A  86      19.469  -3.132  25.522  1.00 20.83           N  
ATOM    694  CA  SER A  86      20.407  -3.940  26.296  1.00 20.85           C  
ATOM    695  C   SER A  86      19.740  -4.882  27.293  1.00 21.10           C  
ATOM    696  O   SER A  86      20.251  -5.978  27.549  1.00 21.00           O  
ATOM    697  CB  SER A  86      21.387  -3.049  27.046  1.00 21.62           C  
ATOM    698  OG  SER A  86      20.731  -2.244  28.006  1.00 22.31           O  
ATOM    699  N   GLU A  87      18.605  -4.476  27.857  1.00 19.90           N  
ATOM    700  CA  GLU A  87      17.926  -5.310  28.844  1.00 20.73           C  
ATOM    701  C   GLU A  87      17.237  -6.490  28.170  1.00 21.55           C  
ATOM    702  O   GLU A  87      17.253  -7.604  28.698  1.00 22.21           O  
ATOM    703  CB  GLU A  87      16.916  -4.489  29.656  1.00 19.78           C  
ATOM    704  CG  GLU A  87      17.555  -3.503  30.637  1.00 21.61           C  
ATOM    705  CD  GLU A  87      18.075  -4.176  31.900  1.00 23.42           C  
ATOM    706  OE1 GLU A  87      17.319  -4.930  32.562  1.00 22.27           O  
ATOM    707  OE2 GLU A  87      19.263  -3.966  32.229  1.00 24.58           O  
ATOM    708  N   TYR A  88      16.627  -6.262  27.011  1.00 22.32           N  
ATOM    709  CA  TYR A  88      16.058  -7.354  26.232  1.00 22.25           C  
ATOM    710  C   TYR A  88      17.190  -8.292  25.796  1.00 22.51           C  
ATOM    711  O   TYR A  88      17.064  -9.504  25.913  1.00 21.78           O  
ATOM    712  CB  TYR A  88      15.257  -6.841  25.021  1.00 25.07           C  
ATOM    713  CG  TYR A  88      14.788  -7.953  24.115  1.00 24.37           C  
ATOM    714  CD1 TYR A  88      13.828  -8.856  24.543  1.00 28.81           C  
ATOM    715  CD2 TYR A  88      15.340  -8.134  22.855  1.00 28.81           C  
ATOM    716  CE1 TYR A  88      13.408  -9.893  23.731  1.00 29.55           C  
ATOM    717  CE2 TYR A  88      14.925  -9.181  22.036  1.00 29.78           C  
ATOM    718  CZ  TYR A  88      13.953 -10.057  22.490  1.00 29.00           C  
ATOM    719  OH  TYR A  88      13.518 -11.123  21.708  1.00 30.63           O  
ATOM    720  N   ASP A  89      18.308  -7.728  25.356  1.00 22.53           N  
ATOM    721  CA  ASP A  89      19.463  -8.523  24.926  1.00 23.64           C  
ATOM    722  C   ASP A  89      20.014  -9.414  26.037  1.00 23.60           C  
ATOM    723  O   ASP A  89      20.428 -10.541  25.780  1.00 23.55           O  
ATOM    724  CB  ASP A  89      20.586  -7.615  24.413  1.00 24.71           C  
ATOM    725  CG  ASP A  89      20.302  -7.023  23.050  1.00 29.67           C  
ATOM    726  OD1 ASP A  89      19.364  -7.472  22.348  1.00 33.70           O  
ATOM    727  OD2 ASP A  89      21.057  -6.095  22.665  1.00 35.98           O  
ATOM    728  N   LEU A  90      20.049  -8.909  27.265  1.00 23.61           N  
ATOM    729  CA  LEU A  90      20.460  -9.719  28.417  1.00 23.47           C  
ATOM    730  C   LEU A  90      19.544 -10.918  28.650  1.00 24.66           C  
ATOM    731  O   LEU A  90      20.019 -12.009  28.979  1.00 23.17           O  
ATOM    732  CB  LEU A  90      20.501  -8.879  29.689  1.00 24.11           C  
ATOM    733  CG  LEU A  90      21.617  -7.836  29.785  1.00 26.53           C  
ATOM    734  CD1 LEU A  90      21.371  -6.899  30.981  1.00 28.07           C  
ATOM    735  CD2 LEU A  90      22.963  -8.520  29.882  1.00 26.45           C  
ATOM    736  N   ALA A  91      18.233 -10.717  28.523  1.00 23.53           N  
ATOM    737  CA  ALA A  91      17.293 -11.829  28.666  1.00 24.08           C  
ATOM    738  C   ALA A  91      17.590 -12.862  27.599  1.00 24.36           C  
ATOM    739  O   ALA A  91      17.715 -14.047  27.902  1.00 23.35           O  
ATOM    740  CB  ALA A  91      15.878 -11.352  28.559  1.00 23.64           C  
ATOM    741  N   VAL A  92      17.736 -12.404  26.356  1.00 23.81           N  
ATOM    742  CA  VAL A  92      18.024 -13.304  25.231  1.00 25.96           C  
ATOM    743  C   VAL A  92      19.323 -14.098  25.406  1.00 26.60           C  
ATOM    744  O   VAL A  92      19.334 -15.315  25.209  1.00 27.60           O  
ATOM    745  CB  VAL A  92      18.047 -12.550  23.886  1.00 26.12           C  
ATOM    746  CG1 VAL A  92      18.569 -13.446  22.774  1.00 28.00           C  
ATOM    747  CG2 VAL A  92      16.644 -12.012  23.562  1.00 25.53           C  
ATOM    748  N   GLY A  93      20.393 -13.419  25.802  1.00 26.09           N  
ATOM    749  CA  GLY A  93      21.670 -14.077  26.073  1.00 26.22           C  
ATOM    750  C   GLY A  93      21.593 -15.117  27.180  1.00 25.46           C  
ATOM    751  O   GLY A  93      22.311 -16.119  27.150  1.00 24.92           O  
ATOM    752  N   GLU A  94      20.709 -14.904  28.144  1.00 24.45           N  
ATOM    753  CA  GLU A  94      20.533 -15.826  29.256  1.00 25.76           C  
ATOM    754  C   GLU A  94      19.579 -16.965  28.935  1.00 24.32           C  
ATOM    755  O   GLU A  94      19.390 -17.856  29.754  1.00 24.64           O  
ATOM    756  CB  GLU A  94      20.027 -15.086  30.485  1.00 26.32           C  
ATOM    757  CG  GLU A  94      21.066 -14.171  31.086  1.00 29.19           C  
ATOM    758  CD  GLU A  94      20.593 -13.502  32.354  1.00 29.80           C  
ATOM    759  OE1 GLU A  94      19.425 -13.712  32.763  1.00 36.09           O  
ATOM    760  OE2 GLU A  94      21.397 -12.751  32.947  1.00 35.54           O  
ATOM    761  N   GLY A  95      18.988 -16.926  27.746  1.00 23.27           N  
ATOM    762  CA  GLY A  95      17.991 -17.909  27.340  1.00 22.72           C  
ATOM    763  C   GLY A  95      16.686 -17.778  28.093  1.00 21.61           C  
ATOM    764  O   GLY A  95      15.907 -18.718  28.129  1.00 19.77           O  
ATOM    765  N   LYS A  96      16.418 -16.610  28.686  1.00 20.60           N  
ATOM    766  CA  LYS A  96      15.229 -16.434  29.517  1.00 21.53           C  
ATOM    767  C   LYS A  96      14.092 -15.702  28.788  1.00 21.31           C  
ATOM    768  O   LYS A  96      14.295 -15.108  27.733  1.00 19.01           O  
ATOM    769  CB  LYS A  96      15.591 -15.668  30.789  1.00 22.06           C  
ATOM    770  CG  LYS A  96      16.449 -16.450  31.785  1.00 23.96           C  
ATOM    771  CD  LYS A  96      16.540 -15.634  33.063  1.00 25.27           C  
ATOM    772  CE  LYS A  96      17.349 -16.241  34.208  1.00 29.51           C  
ATOM    773  NZ  LYS A  96      16.825 -15.592  35.496  1.00 31.31           N  
ATOM    774  N   ILE A  97      12.899 -15.783  29.358  1.00 19.95           N  
ATOM    775  CA  ILE A  97      11.763 -15.020  28.857  1.00 20.24           C  
ATOM    776  C   ILE A  97      11.912 -13.600  29.400  1.00 19.92           C  
ATOM    777  O   ILE A  97      11.995 -13.412  30.595  1.00 19.92           O  
ATOM    778  CB  ILE A  97      10.444 -15.610  29.353  1.00 18.66           C  
ATOM    779  CG1 ILE A  97      10.327 -17.093  28.975  1.00 19.89           C  
ATOM    780  CG2 ILE A  97       9.257 -14.885  28.758  1.00 18.91           C  
ATOM    781  CD1 ILE A  97       9.211 -17.816  29.748  1.00 21.70           C  
ATOM    782  N   CYS A  98      11.926 -12.603  28.528  1.00 19.47           N  
ATOM    783  CA  CYS A  98      12.020 -11.220  29.001  1.00 18.95           C  
ATOM    784  C   CYS A  98      10.644 -10.838  29.534  1.00 17.79           C  
ATOM    785  O   CYS A  98       9.632 -11.134  28.911  1.00 17.53           O  
ATOM    786  CB  CYS A  98      12.425 -10.299  27.860  1.00 19.66           C  
ATOM    787  SG  CYS A  98      12.843  -8.664  28.446  1.00 22.55           S  
ATOM    788  N   LEU A  99      10.601 -10.231  30.712  1.00 19.56           N  
ATOM    789  CA  LEU A  99       9.342  -9.757  31.282  1.00 18.94           C  
ATOM    790  C   LEU A  99       9.369  -8.233  31.316  1.00 18.64           C  
ATOM    791  O   LEU A  99      10.200  -7.632  31.995  1.00 19.97           O  
ATOM    792  CB  LEU A  99       9.143 -10.342  32.678  1.00 18.89           C  
ATOM    793  CG  LEU A  99       7.711 -10.388  33.224  1.00 19.13           C  
ATOM    794  CD1 LEU A  99       7.646 -11.168  34.554  1.00 18.74           C  
ATOM    795  CD2 LEU A  99       7.149  -8.956  33.411  1.00 19.15           C  
ATOM    796  N   PHE A 100       8.502  -7.614  30.521  1.00 19.47           N  
ATOM    797  CA  PHE A 100       8.402  -6.160  30.480  1.00 19.14           C  
ATOM    798  C   PHE A 100       7.172  -5.708  31.241  1.00 20.18           C  
ATOM    799  O   PHE A 100       6.119  -6.332  31.162  1.00 20.16           O  
ATOM    800  CB  PHE A 100       8.217  -5.663  29.053  1.00 19.32           C  
ATOM    801  CG  PHE A 100       9.340  -5.978  28.112  1.00 20.29           C  
ATOM    802  CD1 PHE A 100       9.179  -6.945  27.127  1.00 21.97           C  
ATOM    803  CD2 PHE A 100      10.514  -5.264  28.137  1.00 22.20           C  
ATOM    804  CE1 PHE A 100      10.189  -7.198  26.187  1.00 21.18           C  
ATOM    805  CE2 PHE A 100      11.527  -5.533  27.207  1.00 22.14           C  
ATOM    806  CZ  PHE A 100      11.350  -6.492  26.236  1.00 22.21           C  
ATOM    807  N   GLU A 101       7.280  -4.564  31.917  1.00 21.71           N  
ATOM    808  CA  GLU A 101       6.111  -3.867  32.416  1.00 23.26           C  
ATOM    809  C   GLU A 101       6.149  -2.492  31.792  1.00 22.09           C  
ATOM    810  O   GLU A 101       7.128  -1.788  31.957  1.00 22.39           O  
ATOM    811  CB  GLU A 101       6.122  -3.727  33.922  1.00 23.88           C  
ATOM    812  CG  GLU A 101       4.854  -3.061  34.441  1.00 25.32           C  
ATOM    813  CD  GLU A 101       5.031  -2.329  35.744  1.00 29.19           C  
ATOM    814  OE1 GLU A 101       4.992  -2.973  36.812  1.00 32.45           O  
ATOM    815  OE2 GLU A 101       5.165  -1.086  35.690  1.00 35.19           O  
HETATM  816  N   MSE A 102       5.113  -2.154  31.049  1.00 23.58           N  
HETATM  817  CA  MSE A 102       5.032  -0.861  30.363  1.00 24.70           C  
HETATM  818  C   MSE A 102       3.585  -0.445  30.178  1.00 24.38           C  
HETATM  819  O   MSE A 102       2.675  -1.256  30.300  1.00 24.13           O  
HETATM  820  CB  MSE A 102       5.735  -0.939  29.010  1.00 25.73           C  
HETATM  821  CG  MSE A 102       5.210  -2.022  28.122  1.00 25.50           C  
HETATM  822 SE   MSE A 102       6.080  -2.080  26.378  1.00 28.58          SE  
HETATM  823  CE  MSE A 102       7.901  -2.452  26.899  1.00 29.30           C  
ATOM    824  N   ASN A 103       3.392   0.818  29.849  1.00 23.72           N  
ATOM    825  CA  ASN A 103       2.060   1.371  29.629  1.00 24.29           C  
ATOM    826  C   ASN A 103       1.567   1.072  28.222  1.00 23.84           C  
ATOM    827  O   ASN A 103       2.255   0.471  27.395  1.00 23.88           O  
ATOM    828  CB  ASN A 103       2.043   2.894  29.938  1.00 23.94           C  
ATOM    829  CG  ASN A 103       2.740   3.728  28.874  1.00 26.59           C  
ATOM    830  OD1 ASN A 103       3.352   3.196  27.956  1.00 23.85           O  
ATOM    831  ND2 ASN A 103       2.616   5.052  28.976  1.00 29.98           N  
ATOM    832  N   ILE A 104       0.357   1.508  27.942  1.00 24.79           N  
ATOM    833  CA  ILE A 104      -0.325   1.105  26.741  1.00 25.75           C  
ATOM    834  C   ILE A 104       0.383   1.633  25.487  1.00 25.15           C  
ATOM    835  O   ILE A 104       0.471   0.920  24.485  1.00 25.67           O  
ATOM    836  CB  ILE A 104      -1.825   1.482  26.873  1.00 28.92           C  
ATOM    837  CG1 ILE A 104      -2.697   0.723  25.873  1.00 33.25           C  
ATOM    838  CG2 ILE A 104      -2.023   2.968  26.830  1.00 30.25           C  
ATOM    839  CD1 ILE A 104      -4.023   0.297  26.505  1.00 36.01           C  
ATOM    840  N   ASN A 105       0.958   2.837  25.551  1.00 24.08           N  
ATOM    841  CA  ASN A 105       1.715   3.378  24.406  1.00 25.04           C  
ATOM    842  C   ASN A 105       2.994   2.573  24.129  1.00 24.04           C  
ATOM    843  O   ASN A 105       3.364   2.350  22.977  1.00 22.14           O  
ATOM    844  CB  ASN A 105       2.031   4.856  24.616  1.00 25.73           C  
ATOM    845  CG  ASN A 105       0.789   5.737  24.495  1.00 29.82           C  
ATOM    846  OD1 ASN A 105      -0.171   5.372  23.827  1.00 31.03           O  
ATOM    847  ND2 ASN A 105       0.818   6.909  25.123  1.00 31.63           N  
ATOM    848  N   GLY A 106       3.647   2.115  25.191  1.00 23.90           N  
ATOM    849  CA  GLY A 106       4.795   1.210  25.059  1.00 24.17           C  
ATOM    850  C   GLY A 106       4.384  -0.096  24.413  1.00 25.01           C  
ATOM    851  O   GLY A 106       5.076  -0.602  23.520  1.00 24.84           O  
ATOM    852  N   VAL A 107       3.246  -0.637  24.826  1.00 24.79           N  
ATOM    853  CA  VAL A 107       2.698  -1.836  24.173  1.00 24.29           C  
ATOM    854  C   VAL A 107       2.489  -1.624  22.670  1.00 24.52           C  
ATOM    855  O   VAL A 107       2.876  -2.448  21.860  1.00 24.12           O  
ATOM    856  CB  VAL A 107       1.356  -2.263  24.781  1.00 24.54           C  
ATOM    857  CG1 VAL A 107       0.725  -3.393  23.940  1.00 24.35           C  
ATOM    858  CG2 VAL A 107       1.518  -2.711  26.240  1.00 25.51           C  
ATOM    859  N   LYS A 108       1.851  -0.514  22.305  1.00 24.76           N  
ATOM    860  CA  LYS A 108       1.629  -0.195  20.903  1.00 24.89           C  
ATOM    861  C   LYS A 108       2.945  -0.164  20.135  1.00 23.98           C  
ATOM    862  O   LYS A 108       3.015  -0.657  19.011  1.00 24.62           O  
ATOM    863  CB  LYS A 108       0.883   1.143  20.771  1.00 24.58           C  
ATOM    864  CG  LYS A 108      -0.570   1.052  21.230  1.00 27.76           C  
ATOM    865  CD  LYS A 108      -1.372   2.288  20.900  1.00 29.22           C  
ATOM    866  CE  LYS A 108      -1.352   3.309  22.004  1.00 33.99           C  
ATOM    867  NZ  LYS A 108      -2.431   4.352  21.839  1.00 36.39           N  
ATOM    868  N   GLN A 109       3.982   0.417  20.738  1.00 22.64           N  
ATOM    869  CA  GLN A 109       5.286   0.505  20.101  1.00 24.10           C  
ATOM    870  C   GLN A 109       5.969  -0.849  19.949  1.00 23.17           C  
ATOM    871  O   GLN A 109       6.554  -1.139  18.906  1.00 22.11           O  
ATOM    872  CB  GLN A 109       6.213   1.440  20.869  1.00 23.94           C  
ATOM    873  CG  GLN A 109       5.823   2.885  20.810  1.00 24.17           C  
ATOM    874  CD  GLN A 109       6.688   3.762  21.705  1.00 26.36           C  
ATOM    875  OE1 GLN A 109       7.887   3.928  21.465  1.00 23.10           O  
ATOM    876  NE2 GLN A 109       6.066   4.366  22.724  1.00 28.02           N  
ATOM    877  N   LEU A 110       5.913  -1.674  20.988  1.00 23.75           N  
ATOM    878  CA  LEU A 110       6.550  -2.993  20.925  1.00 24.87           C  
ATOM    879  C   LEU A 110       5.901  -3.853  19.846  1.00 25.20           C  
ATOM    880  O   LEU A 110       6.584  -4.575  19.117  1.00 25.64           O  
ATOM    881  CB  LEU A 110       6.468  -3.702  22.287  1.00 23.80           C  
ATOM    882  CG  LEU A 110       7.710  -4.489  22.675  1.00 27.94           C  
ATOM    883  CD1 LEU A 110       8.846  -3.504  22.905  1.00 28.54           C  
ATOM    884  CD2 LEU A 110       7.460  -5.341  23.932  1.00 27.14           C  
ATOM    885  N   LYS A 111       4.580  -3.754  19.723  1.00 26.48           N  
ATOM    886  CA  LYS A 111       3.852  -4.502  18.703  1.00 27.97           C  
ATOM    887  C   LYS A 111       4.263  -4.136  17.282  1.00 28.54           C  
ATOM    888  O   LYS A 111       4.162  -4.959  16.391  1.00 28.90           O  
ATOM    889  CB  LYS A 111       2.347  -4.315  18.870  1.00 27.77           C  
ATOM    890  CG  LYS A 111       1.816  -5.023  20.103  1.00 29.30           C  
ATOM    891  CD  LYS A 111       0.356  -4.758  20.314  1.00 29.77           C  
ATOM    892  CE  LYS A 111      -0.480  -5.861  19.747  1.00 35.79           C  
ATOM    893  NZ  LYS A 111      -0.456  -7.045  20.616  1.00 31.99           N  
ATOM    894  N   GLU A 112       4.745  -2.918  17.078  1.00 29.42           N  
ATOM    895  CA  GLU A 112       5.211  -2.476  15.758  1.00 31.45           C  
ATOM    896  C   GLU A 112       6.723  -2.610  15.567  1.00 31.24           C  
ATOM    897  O   GLU A 112       7.220  -2.377  14.472  1.00 30.96           O  
ATOM    898  CB  GLU A 112       4.774  -1.025  15.505  1.00 31.80           C  
ATOM    899  CG  GLU A 112       3.266  -0.858  15.557  1.00 34.81           C  
ATOM    900  CD  GLU A 112       2.804   0.580  15.390  1.00 35.81           C  
ATOM    901  OE1 GLU A 112       3.267   1.253  14.443  1.00 41.32           O  
ATOM    902  OE2 GLU A 112       1.954   1.023  16.208  1.00 44.23           O  
ATOM    903  N   SER A 113       7.443  -3.001  16.617  1.00 31.65           N  
ATOM    904  CA  SER A 113       8.900  -3.109  16.579  1.00 32.63           C  
ATOM    905  C   SER A 113       9.360  -4.281  15.724  1.00 34.54           C  
ATOM    906  O   SER A 113       8.731  -5.339  15.706  1.00 34.96           O  
ATOM    907  CB  SER A 113       9.478  -3.259  17.994  1.00 33.09           C  
ATOM    908  OG  SER A 113      10.900  -3.356  17.986  1.00 33.02           O  
ATOM    909  N   LYS A 114      10.470  -4.073  15.023  1.00 36.48           N  
ATOM    910  CA  LYS A 114      11.081  -5.116  14.206  1.00 37.52           C  
ATOM    911  C   LYS A 114      12.118  -5.897  15.025  1.00 37.87           C  
ATOM    912  O   LYS A 114      12.646  -6.903  14.560  1.00 37.89           O  
ATOM    913  CB  LYS A 114      11.699  -4.500  12.948  1.00 38.24           C  
ATOM    914  CG  LYS A 114      10.731  -3.582  12.176  1.00 38.09           C  
ATOM    915  CD  LYS A 114      11.413  -2.869  11.010  1.00 38.43           C  
ATOM    916  CE  LYS A 114      10.838  -1.469  10.793  1.00 38.95           C  
ATOM    917  NZ  LYS A 114      11.331  -0.820   9.539  1.00 38.42           N  
ATOM    918  N   HIS A 115      12.386  -5.441  16.252  1.00 38.28           N  
ATOM    919  CA  HIS A 115      13.308  -6.133  17.169  1.00 38.60           C  
ATOM    920  C   HIS A 115      12.677  -7.313  17.911  1.00 38.69           C  
ATOM    921  O   HIS A 115      13.401  -8.164  18.427  1.00 39.62           O  
ATOM    922  CB  HIS A 115      13.901  -5.160  18.200  1.00 38.70           C  
ATOM    923  CG  HIS A 115      15.026  -4.330  17.667  1.00 39.54           C  
ATOM    924  ND1 HIS A 115      15.003  -2.951  17.668  1.00 39.47           N  
ATOM    925  CD2 HIS A 115      16.203  -4.686  17.101  1.00 40.57           C  
ATOM    926  CE1 HIS A 115      16.120  -2.496  17.130  1.00 40.96           C  
ATOM    927  NE2 HIS A 115      16.866  -3.527  16.777  1.00 40.90           N  
ATOM    928  N   ILE A 116      11.350  -7.360  17.971  1.00 38.50           N  
ATOM    929  CA  ILE A 116      10.642  -8.428  18.689  1.00 38.62           C  
ATOM    930  C   ILE A 116       9.485  -8.958  17.841  1.00 38.25           C  
ATOM    931  O   ILE A 116       8.579  -8.212  17.486  1.00 37.65           O  
ATOM    932  CB  ILE A 116      10.133  -7.928  20.050  1.00 39.22           C  
ATOM    933  CG1 ILE A 116      11.326  -7.587  20.955  1.00 39.10           C  
ATOM    934  CG2 ILE A 116       9.233  -8.978  20.716  1.00 39.03           C  
ATOM    935  CD1 ILE A 116      10.941  -7.019  22.273  1.00 38.64           C  
ATOM    936  N   GLN A 117       9.521 -10.251  17.521  1.00 38.47           N  
ATOM    937  CA  GLN A 117       8.595 -10.824  16.532  1.00 38.67           C  
ATOM    938  C   GLN A 117       7.193 -11.103  17.072  1.00 37.51           C  
ATOM    939  O   GLN A 117       6.204 -11.031  16.338  1.00 37.16           O  
ATOM    940  CB  GLN A 117       9.195 -12.093  15.926  1.00 39.88           C  
ATOM    941  CG  GLN A 117      10.508 -11.847  15.181  1.00 42.90           C  
ATOM    942  CD  GLN A 117      10.409 -10.717  14.161  1.00 46.52           C  
ATOM    943  OE1 GLN A 117      10.837  -9.585  14.418  1.00 49.03           O  
ATOM    944  NE2 GLN A 117       9.822 -11.014  13.004  1.00 48.87           N  
ATOM    945  N   ASP A 118       7.094 -11.405  18.355  1.00 35.30           N  
ATOM    946  CA  ASP A 118       5.820 -11.771  18.925  1.00 34.05           C  
ATOM    947  C   ASP A 118       5.909 -11.455  20.419  1.00 32.67           C  
ATOM    948  O   ASP A 118       6.980 -11.162  20.928  1.00 32.66           O  
ATOM    949  CB  ASP A 118       5.571 -13.265  18.655  1.00 35.71           C  
ATOM    950  CG  ASP A 118       4.142 -13.701  18.949  1.00 40.36           C  
ATOM    951  OD1 ASP A 118       3.244 -12.830  19.051  1.00 45.95           O  
ATOM    952  OD2 ASP A 118       3.921 -14.928  19.090  1.00 44.68           O  
ATOM    953  N   GLY A 119       4.786 -11.451  21.105  1.00 31.35           N  
ATOM    954  CA  GLY A 119       4.806 -11.298  22.566  1.00 29.79           C  
ATOM    955  C   GLY A 119       3.494 -11.763  23.139  1.00 28.18           C  
ATOM    956  O   GLY A 119       2.514 -11.905  22.413  1.00 27.60           O  
ATOM    957  N   ILE A 120       3.486 -12.030  24.437  1.00 25.68           N  
ATOM    958  CA  ILE A 120       2.258 -12.345  25.159  1.00 26.26           C  
ATOM    959  C   ILE A 120       1.923 -11.139  26.008  1.00 25.99           C  
ATOM    960  O   ILE A 120       2.686 -10.778  26.917  1.00 25.93           O  
ATOM    961  CB  ILE A 120       2.396 -13.609  26.008  1.00 26.41           C  
ATOM    962  CG1 ILE A 120       2.653 -14.804  25.067  1.00 27.57           C  
ATOM    963  CG2 ILE A 120       1.127 -13.829  26.840  1.00 26.90           C  
ATOM    964  CD1 ILE A 120       2.748 -16.127  25.733  1.00 28.29           C  
ATOM    965  N   TYR A 121       0.798 -10.504  25.675  1.00 25.06           N  
ATOM    966  CA  TYR A 121       0.428  -9.216  26.233  1.00 24.33           C  
ATOM    967  C   TYR A 121      -0.775  -9.370  27.157  1.00 25.07           C  
ATOM    968  O   TYR A 121      -1.838  -9.843  26.723  1.00 26.53           O  
ATOM    969  CB  TYR A 121       0.087  -8.218  25.117  1.00 24.31           C  
ATOM    970  CG  TYR A 121       1.242  -7.859  24.210  1.00 23.82           C  
ATOM    971  CD1 TYR A 121       1.582  -8.668  23.145  1.00 24.56           C  
ATOM    972  CD2 TYR A 121       1.975  -6.692  24.403  1.00 24.42           C  
ATOM    973  CE1 TYR A 121       2.635  -8.339  22.287  1.00 25.26           C  
ATOM    974  CE2 TYR A 121       3.029  -6.349  23.539  1.00 26.59           C  
ATOM    975  CZ  TYR A 121       3.355  -7.187  22.501  1.00 25.17           C  
ATOM    976  OH  TYR A 121       4.372  -6.880  21.628  1.00 26.52           O  
ATOM    977  N   ILE A 122      -0.585  -8.974  28.418  1.00 24.96           N  
ATOM    978  CA  ILE A 122      -1.613  -9.096  29.457  1.00 24.40           C  
ATOM    979  C   ILE A 122      -1.984  -7.730  30.010  1.00 25.31           C  
ATOM    980  O   ILE A 122      -1.106  -6.950  30.367  1.00 26.27           O  
ATOM    981  CB  ILE A 122      -1.100  -9.988  30.605  1.00 24.51           C  
ATOM    982  CG1 ILE A 122      -0.767 -11.386  30.052  1.00 24.42           C  
ATOM    983  CG2 ILE A 122      -2.160 -10.051  31.735  1.00 25.34           C  
ATOM    984  CD1 ILE A 122      -0.458 -12.411  31.115  1.00 26.29           C  
ATOM    985  N   PHE A 123      -3.277  -7.422  30.040  1.00 24.78           N  
ATOM    986  CA  PHE A 123      -3.757  -6.201  30.680  1.00 24.42           C  
ATOM    987  C   PHE A 123      -4.433  -6.538  31.994  1.00 24.72           C  
ATOM    988  O   PHE A 123      -5.353  -7.368  32.021  1.00 24.42           O  
ATOM    989  CB  PHE A 123      -4.736  -5.483  29.766  1.00 25.37           C  
ATOM    990  CG  PHE A 123      -5.071  -4.076  30.214  1.00 25.49           C  
ATOM    991  CD1 PHE A 123      -6.193  -3.824  30.969  1.00 27.22           C  
ATOM    992  CD2 PHE A 123      -4.238  -3.009  29.876  1.00 25.52           C  
ATOM    993  CE1 PHE A 123      -6.506  -2.524  31.357  1.00 26.04           C  
ATOM    994  CE2 PHE A 123      -4.523  -1.736  30.270  1.00 27.08           C  
ATOM    995  CZ  PHE A 123      -5.669  -1.479  31.010  1.00 27.39           C  
ATOM    996  N   VAL A 124      -3.968  -5.884  33.069  1.00 24.01           N  
ATOM    997  CA  VAL A 124      -4.469  -6.071  34.436  1.00 22.88           C  
ATOM    998  C   VAL A 124      -5.479  -4.977  34.733  1.00 21.38           C  
ATOM    999  O   VAL A 124      -5.157  -3.783  34.632  1.00 21.49           O  
ATOM   1000  CB  VAL A 124      -3.325  -6.071  35.483  1.00 23.10           C  
ATOM   1001  CG1 VAL A 124      -3.861  -6.435  36.890  1.00 22.87           C  
ATOM   1002  CG2 VAL A 124      -2.221  -7.056  35.061  1.00 23.80           C  
ATOM   1003  N   LYS A 125      -6.714  -5.395  35.019  1.00 20.12           N  
ATOM   1004  CA  LYS A 125      -7.827  -4.490  35.338  1.00 21.06           C  
ATOM   1005  C   LYS A 125      -8.142  -4.498  36.835  1.00 20.48           C  
ATOM   1006  O   LYS A 125      -7.967  -5.523  37.507  1.00 19.86           O  
ATOM   1007  CB  LYS A 125      -9.099  -4.925  34.629  1.00 21.32           C  
ATOM   1008  CG  LYS A 125      -9.033  -4.915  33.142  1.00 22.27           C  
ATOM   1009  CD  LYS A 125     -10.330  -5.458  32.547  1.00 23.95           C  
ATOM   1010  CE  LYS A 125     -11.489  -4.514  32.783  1.00 27.01           C  
ATOM   1011  NZ  LYS A 125     -12.662  -4.794  31.926  1.00 26.27           N  
ATOM   1012  N   PRO A 126      -8.658  -3.383  37.355  1.00 20.46           N  
ATOM   1013  CA  PRO A 126      -9.092  -3.386  38.751  1.00 20.35           C  
ATOM   1014  C   PRO A 126     -10.485  -4.015  38.874  1.00 20.50           C  
ATOM   1015  O   PRO A 126     -11.195  -4.096  37.884  1.00 21.74           O  
ATOM   1016  CB  PRO A 126      -9.171  -1.903  39.079  1.00 20.13           C  
ATOM   1017  CG  PRO A 126      -9.615  -1.288  37.787  1.00 20.19           C  
ATOM   1018  CD  PRO A 126      -8.904  -2.084  36.711  1.00 20.37           C  
ATOM   1019  N   PRO A 127     -10.885  -4.437  40.083  1.00 21.69           N  
ATOM   1020  CA  PRO A 127     -12.271  -4.936  40.239  1.00 22.14           C  
ATOM   1021  C   PRO A 127     -13.330  -3.878  39.910  1.00 22.99           C  
ATOM   1022  O   PRO A 127     -14.426  -4.215  39.445  1.00 23.75           O  
ATOM   1023  CB  PRO A 127     -12.330  -5.362  41.718  1.00 22.76           C  
ATOM   1024  CG  PRO A 127     -11.178  -4.629  42.376  1.00 23.56           C  
ATOM   1025  CD  PRO A 127     -10.123  -4.491  41.336  1.00 21.66           C  
ATOM   1026  N   SER A 128     -13.006  -2.604  40.172  1.00 23.35           N  
ATOM   1027  CA  SER A 128     -13.829  -1.470  39.779  1.00 22.95           C  
ATOM   1028  C   SER A 128     -12.925  -0.238  39.737  1.00 22.04           C  
ATOM   1029  O   SER A 128     -11.887  -0.198  40.388  1.00 20.14           O  
ATOM   1030  CB  SER A 128     -14.984  -1.249  40.756  1.00 23.74           C  
ATOM   1031  OG  SER A 128     -14.543  -0.606  41.950  1.00 22.71           O  
ATOM   1032  N   ILE A 129     -13.305   0.755  38.946  1.00 24.05           N  
ATOM   1033  CA  ILE A 129     -12.582   2.025  38.920  1.00 24.10           C  
ATOM   1034  C   ILE A 129     -12.568   2.674  40.305  1.00 23.22           C  
ATOM   1035  O   ILE A 129     -11.551   3.216  40.735  1.00 22.44           O  
ATOM   1036  CB  ILE A 129     -13.220   3.002  37.900  1.00 24.90           C  
ATOM   1037  CG1 ILE A 129     -13.045   2.500  36.464  1.00 28.81           C  
ATOM   1038  CG2 ILE A 129     -12.645   4.408  38.045  1.00 25.05           C  
ATOM   1039  CD1 ILE A 129     -11.689   1.943  36.160  1.00 30.03           C  
ATOM   1040  N   ASP A 130     -13.702   2.619  40.985  1.00 22.94           N  
ATOM   1041  CA  ASP A 130     -13.853   3.199  42.323  1.00 23.18           C  
ATOM   1042  C   ASP A 130     -12.817   2.619  43.281  1.00 21.40           C  
ATOM   1043  O   ASP A 130     -12.170   3.357  44.023  1.00 20.87           O  
ATOM   1044  CB  ASP A 130     -15.266   2.936  42.859  1.00 24.68           C  
ATOM   1045  CG  ASP A 130     -15.428   3.303  44.337  1.00 27.97           C  
ATOM   1046  OD1 ASP A 130     -15.357   4.525  44.668  1.00 36.85           O  
ATOM   1047  OD2 ASP A 130     -15.686   2.385  45.164  1.00 31.94           O  
ATOM   1048  N   ILE A 131     -12.624   1.302  43.227  1.00 20.45           N  
ATOM   1049  CA  ILE A 131     -11.634   0.648  44.086  1.00 20.60           C  
ATOM   1050  C   ILE A 131     -10.230   1.127  43.735  1.00 20.13           C  
ATOM   1051  O   ILE A 131      -9.447   1.469  44.626  1.00 18.92           O  
ATOM   1052  CB  ILE A 131     -11.743  -0.895  44.026  1.00 19.72           C  
ATOM   1053  CG1 ILE A 131     -13.020  -1.358  44.754  1.00 18.86           C  
ATOM   1054  CG2 ILE A 131     -10.548  -1.537  44.665  1.00 19.46           C  
ATOM   1055  CD1 ILE A 131     -13.415  -2.823  44.429  1.00 20.45           C  
ATOM   1056  N   LEU A 132      -9.930   1.211  42.441  1.00 20.66           N  
ATOM   1057  CA  LEU A 132      -8.620   1.690  42.014  1.00 22.17           C  
ATOM   1058  C   LEU A 132      -8.340   3.139  42.463  1.00 22.27           C  
ATOM   1059  O   LEU A 132      -7.244   3.440  42.963  1.00 21.60           O  
ATOM   1060  CB  LEU A 132      -8.465   1.524  40.487  1.00 23.58           C  
ATOM   1061  CG  LEU A 132      -7.078   1.835  39.886  1.00 25.61           C  
ATOM   1062  CD1 LEU A 132      -6.032   1.422  40.825  1.00 32.42           C  
ATOM   1063  CD2 LEU A 132      -6.826   1.130  38.590  1.00 25.87           C  
ATOM   1064  N   LEU A 133      -9.328   4.021  42.320  1.00 21.78           N  
ATOM   1065  CA  LEU A 133      -9.183   5.410  42.759  1.00 21.94           C  
ATOM   1066  C   LEU A 133      -8.916   5.455  44.253  1.00 21.65           C  
ATOM   1067  O   LEU A 133      -8.099   6.245  44.718  1.00 22.85           O  
ATOM   1068  CB  LEU A 133     -10.428   6.236  42.417  1.00 21.22           C  
ATOM   1069  CG  LEU A 133     -10.810   6.401  40.935  1.00 25.50           C  
ATOM   1070  CD1 LEU A 133     -11.954   7.394  40.802  1.00 25.71           C  
ATOM   1071  CD2 LEU A 133      -9.587   6.855  40.113  1.00 23.59           C  
ATOM   1072  N   GLY A 134      -9.615   4.612  45.005  1.00 20.54           N  
ATOM   1073  CA  GLY A 134      -9.366   4.462  46.441  1.00 19.98           C  
ATOM   1074  C   GLY A 134      -7.963   3.987  46.785  1.00 19.35           C  
ATOM   1075  O   GLY A 134      -7.328   4.487  47.729  1.00 19.38           O  
ATOM   1076  N   ARG A 135      -7.472   3.027  46.020  1.00 19.93           N  
ATOM   1077  CA  ARG A 135      -6.102   2.560  46.200  1.00 20.93           C  
ATOM   1078  C   ARG A 135      -5.088   3.669  45.923  1.00 20.26           C  
ATOM   1079  O   ARG A 135      -4.162   3.839  46.678  1.00 20.97           O  
ATOM   1080  CB  ARG A 135      -5.814   1.351  45.335  1.00 21.97           C  
ATOM   1081  CG  ARG A 135      -6.580   0.120  45.783  1.00 21.38           C  
ATOM   1082  CD  ARG A 135      -5.950  -1.165  45.242  1.00 23.70           C  
ATOM   1083  NE  ARG A 135      -4.865  -1.619  46.112  1.00 26.06           N  
ATOM   1084  CZ  ARG A 135      -3.567  -1.666  45.796  1.00 28.95           C  
ATOM   1085  NH1 ARG A 135      -3.133  -1.304  44.607  1.00 30.58           N  
ATOM   1086  NH2 ARG A 135      -2.685  -2.088  46.698  1.00 29.76           N  
ATOM   1087  N   LEU A 136      -5.278   4.428  44.857  1.00 21.17           N  
ATOM   1088  CA  LEU A 136      -4.388   5.571  44.576  1.00 22.54           C  
ATOM   1089  C   LEU A 136      -4.405   6.589  45.691  1.00 23.80           C  
ATOM   1090  O   LEU A 136      -3.355   7.104  46.083  1.00 21.56           O  
ATOM   1091  CB  LEU A 136      -4.753   6.239  43.246  1.00 23.93           C  
ATOM   1092  CG  LEU A 136      -4.331   5.465  41.994  1.00 25.14           C  
ATOM   1093  CD1 LEU A 136      -4.863   6.171  40.706  1.00 25.52           C  
ATOM   1094  CD2 LEU A 136      -2.823   5.261  41.951  1.00 27.51           C  
ATOM   1095  N   LYS A 137      -5.602   6.884  46.216  1.00 24.60           N  
ATOM   1096  CA  LYS A 137      -5.743   7.790  47.346  1.00 25.06           C  
ATOM   1097  C   LYS A 137      -5.052   7.324  48.613  1.00 25.05           C  
ATOM   1098  O   LYS A 137      -4.648   8.145  49.421  1.00 26.68           O  
ATOM   1099  CB  LYS A 137      -7.234   8.081  47.633  1.00 24.74           C  
ATOM   1100  CG  LYS A 137      -7.776   9.111  46.667  1.00 25.85           C  
ATOM   1101  CD  LYS A 137      -9.180   9.565  47.009  1.00 24.90           C  
ATOM   1102  CE  LYS A 137     -10.247   8.734  46.338  1.00 24.96           C  
ATOM   1103  NZ  LYS A 137     -11.536   9.496  46.349  1.00 22.45           N  
ATOM   1104  N   ASN A 138      -4.942   6.019  48.802  1.00 25.26           N  
ATOM   1105  CA  ASN A 138      -4.242   5.452  49.955  1.00 26.43           C  
ATOM   1106  C   ASN A 138      -2.724   5.603  49.892  1.00 27.45           C  
ATOM   1107  O   ASN A 138      -2.034   5.269  50.856  1.00 26.80           O  
ATOM   1108  CB  ASN A 138      -4.579   3.971  50.117  1.00 26.81           C  
ATOM   1109  CG  ASN A 138      -5.623   3.741  51.142  1.00 27.70           C  
ATOM   1110  OD1 ASN A 138      -5.536   4.259  52.268  1.00 23.73           O  
ATOM   1111  ND2 ASN A 138      -6.649   2.991  50.765  1.00 32.63           N  
ATOM   1112  N   ARG A 139      -2.211   6.087  48.761  1.00 27.72           N  
ATOM   1113  CA  ARG A 139      -0.809   6.490  48.683  1.00 29.71           C  
ATOM   1114  C   ARG A 139      -0.662   7.848  49.397  1.00 30.63           C  
ATOM   1115  O   ARG A 139      -0.834   8.904  48.800  1.00 31.72           O  
ATOM   1116  CB  ARG A 139      -0.351   6.555  47.222  1.00 29.84           C  
ATOM   1117  CG  ARG A 139      -0.525   5.219  46.495  1.00 30.77           C  
ATOM   1118  CD  ARG A 139      -0.097   5.284  45.038  1.00 31.60           C  
ATOM   1119  NE  ARG A 139      -0.070   3.948  44.448  1.00 32.56           N  
ATOM   1120  CZ  ARG A 139       0.355   3.671  43.221  1.00 33.01           C  
ATOM   1121  NH1 ARG A 139       0.799   4.629  42.422  1.00 32.58           N  
ATOM   1122  NH2 ARG A 139       0.344   2.411  42.806  1.00 36.81           N  
ATOM   1123  N   ASN A 140      -0.358   7.792  50.689  1.00 31.86           N  
ATOM   1124  CA  ASN A 140      -0.368   8.979  51.561  1.00 32.29           C  
ATOM   1125  C   ASN A 140       0.536  10.107  51.104  1.00 32.43           C  
ATOM   1126  O   ASN A 140       0.238  11.285  51.347  1.00 31.87           O  
ATOM   1127  CB  ASN A 140       0.064   8.599  52.986  1.00 32.67           C  
ATOM   1128  CG  ASN A 140      -0.112   9.746  53.971  1.00 34.48           C  
ATOM   1129  OD1 ASN A 140      -1.034  10.553  53.841  1.00 41.11           O  
ATOM   1130  ND2 ASN A 140       0.780   9.833  54.947  1.00 37.62           N  
ATOM   1131  N   THR A 141       1.637   9.734  50.460  1.00 32.66           N  
ATOM   1132  CA  THR A 141       2.766  10.627  50.236  1.00 34.01           C  
ATOM   1133  C   THR A 141       2.811  11.284  48.842  1.00 34.34           C  
ATOM   1134  O   THR A 141       3.520  12.291  48.662  1.00 35.57           O  
ATOM   1135  CB  THR A 141       4.077   9.856  50.422  1.00 34.29           C  
ATOM   1136  OG1 THR A 141       4.216   8.899  49.362  1.00 39.04           O  
ATOM   1137  CG2 THR A 141       4.081   9.126  51.761  1.00 36.48           C  
ATOM   1138  N   GLU A 142       2.101  10.712  47.864  1.00 33.14           N  
ATOM   1139  CA  GLU A 142       2.084  11.242  46.492  1.00 32.49           C  
ATOM   1140  C   GLU A 142       1.322  12.577  46.480  1.00 29.98           C  
ATOM   1141  O   GLU A 142       0.366  12.735  47.215  1.00 29.67           O  
ATOM   1142  CB  GLU A 142       1.429  10.243  45.518  1.00 32.79           C  
ATOM   1143  CG  GLU A 142       2.221   8.913  45.314  1.00 36.51           C  
ATOM   1144  CD  GLU A 142       1.882   8.160  44.000  1.00 38.05           C  
ATOM   1145  OE1 GLU A 142       0.776   8.346  43.442  1.00 45.48           O  
ATOM   1146  OE2 GLU A 142       2.724   7.358  43.525  1.00 42.99           O  
ATOM   1147  N   LYS A 143       1.756  13.529  45.657  1.00 28.49           N  
ATOM   1148  CA  LYS A 143       1.110  14.847  45.584  1.00 27.08           C  
ATOM   1149  C   LYS A 143      -0.191  14.786  44.774  1.00 24.89           C  
ATOM   1150  O   LYS A 143      -0.320  13.966  43.878  1.00 24.30           O  
ATOM   1151  CB  LYS A 143       2.067  15.859  44.956  1.00 27.69           C  
ATOM   1152  CG  LYS A 143       3.379  16.064  45.720  1.00 29.16           C  
ATOM   1153  CD  LYS A 143       3.163  16.772  47.045  1.00 31.13           C  
ATOM   1154  CE  LYS A 143       4.480  17.319  47.618  1.00 32.81           C  
ATOM   1155  NZ  LYS A 143       4.317  18.626  48.317  1.00 33.61           N  
ATOM   1156  N   PRO A 144      -1.170  15.664  45.073  1.00 23.00           N  
ATOM   1157  CA  PRO A 144      -2.412  15.634  44.294  1.00 22.30           C  
ATOM   1158  C   PRO A 144      -2.238  15.701  42.767  1.00 20.70           C  
ATOM   1159  O   PRO A 144      -2.987  15.036  42.040  1.00 20.17           O  
ATOM   1160  CB  PRO A 144      -3.166  16.865  44.808  1.00 21.69           C  
ATOM   1161  CG  PRO A 144      -2.691  16.992  46.241  1.00 21.93           C  
ATOM   1162  CD  PRO A 144      -1.238  16.640  46.184  1.00 22.30           C  
ATOM   1163  N   GLU A 145      -1.280  16.484  42.289  1.00 20.94           N  
ATOM   1164  CA  GLU A 145      -1.063  16.589  40.849  1.00 22.23           C  
ATOM   1165  C   GLU A 145      -0.601  15.255  40.266  1.00 22.43           C  
ATOM   1166  O   GLU A 145      -0.969  14.896  39.148  1.00 21.13           O  
ATOM   1167  CB  GLU A 145      -0.039  17.671  40.516  1.00 23.48           C  
ATOM   1168  CG  GLU A 145       0.026  17.988  39.010  1.00 25.21           C  
ATOM   1169  CD  GLU A 145      -1.327  18.455  38.477  1.00 31.81           C  
ATOM   1170  OE1 GLU A 145      -1.785  19.568  38.873  1.00 37.90           O  
ATOM   1171  OE2 GLU A 145      -1.915  17.720  37.657  1.00 33.95           O  
ATOM   1172  N   GLU A 146       0.212  14.533  41.036  1.00 22.40           N  
ATOM   1173  CA  GLU A 146       0.731  13.224  40.603  1.00 23.83           C  
ATOM   1174  C   GLU A 146      -0.413  12.238  40.499  1.00 22.37           C  
ATOM   1175  O   GLU A 146      -0.570  11.553  39.496  1.00 22.20           O  
ATOM   1176  CB  GLU A 146       1.804  12.744  41.579  1.00 25.00           C  
ATOM   1177  CG  GLU A 146       3.052  13.607  41.496  1.00 29.37           C  
ATOM   1178  CD  GLU A 146       4.074  13.365  42.612  1.00 31.08           C  
ATOM   1179  OE1 GLU A 146       3.688  13.263  43.813  1.00 37.52           O  
ATOM   1180  OE2 GLU A 146       5.286  13.328  42.270  1.00 37.48           O  
ATOM   1181  N   ILE A 147      -1.265  12.220  41.523  1.00 20.57           N  
ATOM   1182  CA  ILE A 147      -2.460  11.392  41.529  1.00 20.19           C  
ATOM   1183  C   ILE A 147      -3.385  11.783  40.383  1.00 19.78           C  
ATOM   1184  O   ILE A 147      -3.883  10.920  39.665  1.00 18.52           O  
ATOM   1185  CB  ILE A 147      -3.221  11.493  42.881  1.00 22.28           C  
ATOM   1186  CG1 ILE A 147      -2.327  11.072  44.058  1.00 25.14           C  
ATOM   1187  CG2 ILE A 147      -4.488  10.668  42.851  1.00 20.50           C  
ATOM   1188  CD1 ILE A 147      -1.746   9.674  43.960  1.00 29.78           C  
ATOM   1189  N   ASN A 148      -3.545  13.087  40.170  1.00 19.70           N  
ATOM   1190  CA  ASN A 148      -4.343  13.605  39.076  1.00 19.95           C  
ATOM   1191  C   ASN A 148      -3.891  13.052  37.745  1.00 19.08           C  
ATOM   1192  O   ASN A 148      -4.696  12.515  36.972  1.00 20.73           O  
ATOM   1193  CB  ASN A 148      -4.277  15.129  39.029  1.00 19.09           C  
ATOM   1194  CG  ASN A 148      -5.118  15.705  37.907  1.00 21.13           C  
ATOM   1195  OD1 ASN A 148      -6.274  15.310  37.723  1.00 24.17           O  
ATOM   1196  ND2 ASN A 148      -4.538  16.624  37.140  1.00 21.22           N  
ATOM   1197  N   LYS A 149      -2.599  13.147  37.483  1.00 18.11           N  
ATOM   1198  CA  LYS A 149      -2.074  12.662  36.209  1.00 18.61           C  
ATOM   1199  C   LYS A 149      -2.285  11.155  36.042  1.00 19.02           C  
ATOM   1200  O   LYS A 149      -2.677  10.685  34.983  1.00 19.08           O  
ATOM   1201  CB  LYS A 149      -0.602  13.042  36.061  1.00 19.22           C  
ATOM   1202  CG  LYS A 149      -0.358  14.513  35.828  1.00 20.25           C  
ATOM   1203  CD  LYS A 149      -0.327  14.853  34.343  1.00 26.43           C  
ATOM   1204  CE  LYS A 149      -0.423  16.344  34.102  1.00 25.24           C  
ATOM   1205  NZ  LYS A 149      -1.771  16.826  34.509  1.00 27.18           N  
ATOM   1206  N   ARG A 150      -2.043  10.400  37.094  1.00 18.26           N  
ATOM   1207  CA  ARG A 150      -2.275   8.964  37.054  1.00 19.97           C  
ATOM   1208  C   ARG A 150      -3.728   8.576  36.798  1.00 20.71           C  
ATOM   1209  O   ARG A 150      -4.013   7.560  36.114  1.00 22.56           O  
ATOM   1210  CB  ARG A 150      -1.740   8.328  38.336  1.00 19.60           C  
ATOM   1211  CG  ARG A 150      -0.229   8.325  38.375  1.00 19.48           C  
ATOM   1212  CD  ARG A 150       0.334   7.918  39.725  1.00 21.11           C  
ATOM   1213  NE  ARG A 150       1.795   8.000  39.698  1.00 21.87           N  
ATOM   1214  CZ  ARG A 150       2.631   7.063  39.260  1.00 21.76           C  
ATOM   1215  NH1 ARG A 150       2.188   5.898  38.793  1.00 20.20           N  
ATOM   1216  NH2 ARG A 150       3.936   7.288  39.280  1.00 21.17           N  
HETATM 1217  N   MSE A 151      -4.661   9.359  37.336  1.00 20.57           N  
HETATM 1218  CA  MSE A 151      -6.087   9.165  37.054  1.00 21.69           C  
HETATM 1219  C   MSE A 151      -6.449   9.599  35.625  1.00 21.88           C  
HETATM 1220  O   MSE A 151      -7.293   8.999  35.009  1.00 23.30           O  
HETATM 1221  CB  MSE A 151      -6.935   9.929  38.086  1.00 22.27           C  
HETATM 1222  CG  MSE A 151      -6.734   9.400  39.485  1.00 21.32           C  
HETATM 1223 SE   MSE A 151      -7.872  10.320  40.786  1.00 24.24          SE  
HETATM 1224  CE  MSE A 151      -7.598   9.161  42.347  1.00 25.37           C  
ATOM   1225  N   GLN A 152      -5.793  10.623  35.085  1.00 22.80           N  
ATOM   1226  CA  GLN A 152      -6.017  10.996  33.684  1.00 22.61           C  
ATOM   1227  C   GLN A 152      -5.506   9.890  32.744  1.00 23.54           C  
ATOM   1228  O   GLN A 152      -6.156   9.546  31.752  1.00 23.51           O  
ATOM   1229  CB  GLN A 152      -5.378  12.345  33.376  1.00 23.25           C  
ATOM   1230  CG  GLN A 152      -6.039  13.490  34.121  1.00 22.17           C  
ATOM   1231  CD  GLN A 152      -5.278  14.813  34.025  1.00 24.16           C  
ATOM   1232  OE1 GLN A 152      -4.049  14.844  34.012  1.00 33.29           O  
ATOM   1233  NE2 GLN A 152      -6.013  15.906  33.972  1.00 29.68           N  
ATOM   1234  N   GLU A 153      -4.349   9.325  33.061  1.00 22.47           N  
ATOM   1235  CA  GLU A 153      -3.807   8.208  32.271  1.00 23.63           C  
ATOM   1236  C   GLU A 153      -4.754   7.021  32.344  1.00 24.16           C  
ATOM   1237  O   GLU A 153      -5.005   6.382  31.345  1.00 26.00           O  
ATOM   1238  CB  GLU A 153      -2.415   7.794  32.769  1.00 23.29           C  
ATOM   1239  CG  GLU A 153      -1.293   8.835  32.573  1.00 21.64           C  
ATOM   1240  CD  GLU A 153      -0.779   8.978  31.132  1.00 24.00           C  
ATOM   1241  OE1 GLU A 153      -1.322   8.342  30.211  1.00 24.86           O  
ATOM   1242  OE2 GLU A 153       0.183   9.744  30.913  1.00 23.40           O  
ATOM   1243  N   LEU A 154      -5.270   6.732  33.538  1.00 25.70           N  
ATOM   1244  CA  LEU A 154      -6.285   5.691  33.734  1.00 25.81           C  
ATOM   1245  C   LEU A 154      -7.434   5.794  32.737  1.00 26.41           C  
ATOM   1246  O   LEU A 154      -7.808   4.804  32.116  1.00 24.80           O  
ATOM   1247  CB  LEU A 154      -6.806   5.733  35.174  1.00 26.98           C  
ATOM   1248  CG  LEU A 154      -8.086   4.945  35.482  1.00 27.26           C  
ATOM   1249  CD1 LEU A 154      -7.805   3.458  35.410  1.00 28.59           C  
ATOM   1250  CD2 LEU A 154      -8.608   5.295  36.866  1.00 27.43           C  
ATOM   1251  N   THR A 155      -8.002   6.986  32.567  1.00 28.40           N  
ATOM   1252  CA  THR A 155      -9.134   7.157  31.659  1.00 28.13           C  
ATOM   1253  C   THR A 155      -8.796   6.742  30.244  1.00 29.38           C  
ATOM   1254  O   THR A 155      -9.543   5.987  29.619  1.00 30.56           O  
ATOM   1255  CB  THR A 155      -9.642   8.611  31.674  1.00 28.90           C  
ATOM   1256  OG1 THR A 155      -9.992   8.947  33.017  1.00 30.30           O  
ATOM   1257  CG2 THR A 155     -10.870   8.772  30.777  1.00 30.25           C  
ATOM   1258  N   ARG A 156      -7.659   7.213  29.742  1.00 29.51           N  
ATOM   1259  CA  ARG A 156      -7.190   6.829  28.414  1.00 28.69           C  
ATOM   1260  C   ARG A 156      -6.970   5.318  28.328  1.00 27.97           C  
ATOM   1261  O   ARG A 156      -7.399   4.656  27.378  1.00 27.15           O  
ATOM   1262  CB  ARG A 156      -5.877   7.550  28.108  1.00 30.16           C  
ATOM   1263  CG  ARG A 156      -5.108   7.013  26.894  1.00 31.98           C  
ATOM   1264  CD  ARG A 156      -5.038   8.031  25.769  1.00 37.27           C  
ATOM   1265  NE  ARG A 156      -4.294   7.533  24.608  1.00 39.01           N  
ATOM   1266  CZ  ARG A 156      -4.273   8.121  23.411  1.00 41.37           C  
ATOM   1267  NH1 ARG A 156      -4.971   9.236  23.192  1.00 43.35           N  
ATOM   1268  NH2 ARG A 156      -3.569   7.579  22.414  1.00 41.06           N  
ATOM   1269  N   GLU A 157      -6.282   4.783  29.327  1.00 26.50           N  
ATOM   1270  CA  GLU A 157      -5.908   3.364  29.337  1.00 26.78           C  
ATOM   1271  C   GLU A 157      -7.121   2.456  29.300  1.00 26.54           C  
ATOM   1272  O   GLU A 157      -7.159   1.506  28.513  1.00 25.85           O  
ATOM   1273  CB  GLU A 157      -5.070   3.059  30.566  1.00 25.74           C  
ATOM   1274  CG  GLU A 157      -3.703   3.682  30.507  1.00 25.82           C  
ATOM   1275  CD  GLU A 157      -3.021   3.741  31.874  1.00 25.95           C  
ATOM   1276  OE1 GLU A 157      -3.735   3.809  32.892  1.00 25.35           O  
ATOM   1277  OE2 GLU A 157      -1.771   3.751  31.911  1.00 23.57           O  
HETATM 1278  N   MSE A 158      -8.115   2.759  30.128  1.00 26.85           N  
HETATM 1279  CA  MSE A 158      -9.343   1.955  30.193  1.00 28.45           C  
HETATM 1280  C   MSE A 158     -10.137   2.046  28.890  1.00 29.26           C  
HETATM 1281  O   MSE A 158     -10.770   1.078  28.472  1.00 30.03           O  
HETATM 1282  CB  MSE A 158     -10.214   2.390  31.389  1.00 28.72           C  
HETATM 1283  CG  MSE A 158      -9.622   2.015  32.769  1.00 31.04           C  
HETATM 1284 SE   MSE A 158      -9.174   0.119  33.068  1.00 33.32          SE  
HETATM 1285  CE  MSE A 158     -10.994  -0.594  33.300  1.00 35.23           C  
ATOM   1286  N   ASP A 159     -10.077   3.208  28.252  1.00 29.13           N  
ATOM   1287  CA  ASP A 159     -10.750   3.456  26.986  1.00 29.94           C  
ATOM   1288  C   ASP A 159     -10.111   2.672  25.839  1.00 30.36           C  
ATOM   1289  O   ASP A 159     -10.817   2.157  24.980  1.00 31.70           O  
ATOM   1290  CB  ASP A 159     -10.705   4.953  26.669  1.00 30.58           C  
ATOM   1291  CG  ASP A 159     -11.572   5.334  25.481  1.00 33.43           C  
ATOM   1292  OD1 ASP A 159     -12.774   4.980  25.483  1.00 37.64           O  
ATOM   1293  OD2 ASP A 159     -11.054   5.989  24.551  1.00 34.61           O  
ATOM   1294  N   GLU A 160      -8.785   2.579  25.830  1.00 29.00           N  
ATOM   1295  CA  GLU A 160      -8.054   2.055  24.671  1.00 29.04           C  
ATOM   1296  C   GLU A 160      -7.642   0.592  24.744  1.00 27.82           C  
ATOM   1297  O   GLU A 160      -7.246   0.017  23.726  1.00 27.18           O  
ATOM   1298  CB  GLU A 160      -6.790   2.879  24.448  1.00 29.34           C  
ATOM   1299  CG  GLU A 160      -7.074   4.333  24.146  1.00 31.29           C  
ATOM   1300  CD  GLU A 160      -5.881   5.061  23.565  1.00 32.24           C  
ATOM   1301  OE1 GLU A 160      -4.746   4.535  23.629  1.00 36.79           O  
ATOM   1302  OE2 GLU A 160      -6.087   6.175  23.043  1.00 38.71           O  
ATOM   1303  N   ALA A 161      -7.709  -0.010  25.933  1.00 26.67           N  
ATOM   1304  CA  ALA A 161      -7.172  -1.356  26.146  1.00 27.48           C  
ATOM   1305  C   ALA A 161      -7.829  -2.383  25.218  1.00 26.91           C  
ATOM   1306  O   ALA A 161      -7.183  -3.311  24.744  1.00 26.98           O  
ATOM   1307  CB  ALA A 161      -7.360  -1.763  27.602  1.00 26.43           C  
ATOM   1308  N   ASP A 162      -9.119  -2.196  24.982  1.00 27.16           N  
ATOM   1309  CA  ASP A 162      -9.914  -3.052  24.101  1.00 29.02           C  
ATOM   1310  C   ASP A 162      -9.468  -2.987  22.635  1.00 28.75           C  
ATOM   1311  O   ASP A 162      -9.725  -3.904  21.858  1.00 29.75           O  
ATOM   1312  CB  ASP A 162     -11.407  -2.672  24.211  1.00 30.73           C  
ATOM   1313  CG  ASP A 162     -11.629  -1.198  24.622  1.00 34.93           C  
ATOM   1314  OD1 ASP A 162     -11.261  -0.822  25.781  1.00 37.95           O  
ATOM   1315  OD2 ASP A 162     -12.174  -0.420  23.806  1.00 39.87           O  
ATOM   1316  N   LYS A 163      -8.794  -1.914  22.255  1.00 28.23           N  
ATOM   1317  CA  LYS A 163      -8.449  -1.682  20.859  1.00 28.47           C  
ATOM   1318  C   LYS A 163      -7.009  -2.068  20.528  1.00 27.84           C  
ATOM   1319  O   LYS A 163      -6.624  -2.053  19.370  1.00 26.94           O  
ATOM   1320  CB  LYS A 163      -8.673  -0.210  20.524  1.00 28.60           C  
ATOM   1321  CG  LYS A 163      -9.992   0.357  21.035  1.00 29.91           C  
ATOM   1322  CD  LYS A 163     -10.019   1.867  20.902  1.00 29.85           C  
ATOM   1323  CE  LYS A 163     -11.182   2.490  21.667  1.00 31.39           C  
ATOM   1324  NZ  LYS A 163     -11.224   3.984  21.494  1.00 31.96           N  
ATOM   1325  N   VAL A 164      -6.225  -2.434  21.541  1.00 27.28           N  
ATOM   1326  CA  VAL A 164      -4.774  -2.572  21.395  1.00 27.43           C  
ATOM   1327  C   VAL A 164      -4.312  -3.970  20.976  1.00 27.67           C  
ATOM   1328  O   VAL A 164      -3.282  -4.115  20.312  1.00 28.65           O  
ATOM   1329  CB  VAL A 164      -4.068  -2.141  22.702  1.00 27.76           C  
ATOM   1330  CG1 VAL A 164      -2.647  -2.681  22.778  1.00 27.75           C  
ATOM   1331  CG2 VAL A 164      -4.069  -0.628  22.791  1.00 28.59           C  
ATOM   1332  N   GLY A 165      -5.058  -4.997  21.358  1.00 26.97           N  
ATOM   1333  CA  GLY A 165      -4.706  -6.366  20.976  1.00 26.05           C  
ATOM   1334  C   GLY A 165      -4.061  -7.199  22.071  1.00 25.06           C  
ATOM   1335  O   GLY A 165      -3.144  -7.998  21.809  1.00 24.70           O  
ATOM   1336  N   PHE A 166      -4.559  -7.071  23.294  1.00 22.33           N  
ATOM   1337  CA  PHE A 166      -4.055  -7.898  24.374  1.00 21.15           C  
ATOM   1338  C   PHE A 166      -4.507  -9.335  24.218  1.00 21.31           C  
ATOM   1339  O   PHE A 166      -5.601  -9.621  23.721  1.00 19.97           O  
ATOM   1340  CB  PHE A 166      -4.482  -7.363  25.746  1.00 19.51           C  
ATOM   1341  CG  PHE A 166      -3.781  -6.107  26.122  1.00 17.94           C  
ATOM   1342  CD1 PHE A 166      -4.360  -4.878  25.881  1.00 19.34           C  
ATOM   1343  CD2 PHE A 166      -2.528  -6.157  26.717  1.00 17.08           C  
ATOM   1344  CE1 PHE A 166      -3.692  -3.708  26.212  1.00 19.71           C  
ATOM   1345  CE2 PHE A 166      -1.863  -4.995  27.055  1.00 18.31           C  
ATOM   1346  CZ  PHE A 166      -2.436  -3.780  26.798  1.00 18.80           C  
ATOM   1347  N   ASN A 167      -3.642 -10.233  24.656  1.00 20.43           N  
ATOM   1348  CA  ASN A 167      -3.924 -11.654  24.609  1.00 20.52           C  
ATOM   1349  C   ASN A 167      -4.816 -12.078  25.758  1.00 21.65           C  
ATOM   1350  O   ASN A 167      -5.575 -13.056  25.652  1.00 21.85           O  
ATOM   1351  CB  ASN A 167      -2.616 -12.428  24.653  1.00 20.86           C  
ATOM   1352  CG  ASN A 167      -1.762 -12.185  23.444  1.00 21.46           C  
ATOM   1353  OD1 ASN A 167      -0.845 -11.358  23.465  1.00 23.56           O  
ATOM   1354  ND2 ASN A 167      -2.072 -12.891  22.356  1.00 24.61           N  
ATOM   1355  N   TYR A 168      -4.741 -11.346  26.866  1.00 21.19           N  
ATOM   1356  CA  TYR A 168      -5.463 -11.726  28.067  1.00 22.25           C  
ATOM   1357  C   TYR A 168      -5.744 -10.514  28.948  1.00 21.29           C  
ATOM   1358  O   TYR A 168      -4.891  -9.612  29.119  1.00 20.57           O  
ATOM   1359  CB  TYR A 168      -4.660 -12.720  28.873  1.00 24.32           C  
ATOM   1360  CG  TYR A 168      -5.451 -13.570  29.856  1.00 25.73           C  
ATOM   1361  CD1 TYR A 168      -6.184 -14.666  29.422  1.00 30.53           C  
ATOM   1362  CD2 TYR A 168      -5.393 -13.331  31.220  1.00 29.36           C  
ATOM   1363  CE1 TYR A 168      -6.884 -15.480  30.325  1.00 29.09           C  
ATOM   1364  CE2 TYR A 168      -6.085 -14.138  32.131  1.00 27.90           C  
ATOM   1365  CZ  TYR A 168      -6.827 -15.210  31.667  1.00 28.63           C  
ATOM   1366  OH  TYR A 168      -7.509 -16.013  32.546  1.00 31.34           O  
ATOM   1367  N   PHE A 169      -6.955 -10.503  29.481  1.00 21.50           N  
ATOM   1368  CA  PHE A 169      -7.387  -9.521  30.445  1.00 20.45           C  
ATOM   1369  C   PHE A 169      -7.635 -10.251  31.767  1.00 20.80           C  
ATOM   1370  O   PHE A 169      -8.355 -11.266  31.819  1.00 21.65           O  
ATOM   1371  CB  PHE A 169      -8.669  -8.847  29.975  1.00 21.63           C  
ATOM   1372  CG  PHE A 169      -8.482  -7.934  28.793  1.00 22.08           C  
ATOM   1373  CD1 PHE A 169      -8.645  -8.409  27.493  1.00 23.75           C  
ATOM   1374  CD2 PHE A 169      -8.114  -6.607  28.977  1.00 21.05           C  
ATOM   1375  CE1 PHE A 169      -8.465  -7.565  26.398  1.00 23.26           C  
ATOM   1376  CE2 PHE A 169      -7.944  -5.747  27.878  1.00 22.83           C  
ATOM   1377  CZ  PHE A 169      -8.119  -6.234  26.593  1.00 22.18           C  
ATOM   1378  N   ILE A 170      -7.044  -9.734  32.830  1.00 19.45           N  
ATOM   1379  CA  ILE A 170      -7.170 -10.346  34.146  1.00 20.20           C  
ATOM   1380  C   ILE A 170      -7.590  -9.270  35.140  1.00 19.67           C  
ATOM   1381  O   ILE A 170      -7.143  -8.122  35.043  1.00 19.88           O  
ATOM   1382  CB  ILE A 170      -5.859 -11.080  34.544  1.00 19.80           C  
ATOM   1383  CG1 ILE A 170      -6.068 -11.979  35.771  1.00 23.16           C  
ATOM   1384  CG2 ILE A 170      -4.698 -10.119  34.724  1.00 21.20           C  
ATOM   1385  CD1 ILE A 170      -4.873 -12.905  36.036  1.00 20.95           C  
ATOM   1386  N   VAL A 171      -8.477  -9.636  36.066  1.00 19.48           N  
ATOM   1387  CA  VAL A 171      -9.003  -8.717  37.062  1.00 19.40           C  
ATOM   1388  C   VAL A 171      -8.305  -9.022  38.384  1.00 20.63           C  
ATOM   1389  O   VAL A 171      -8.393 -10.148  38.895  1.00 20.22           O  
ATOM   1390  CB  VAL A 171     -10.540  -8.889  37.217  1.00 20.04           C  
ATOM   1391  CG1 VAL A 171     -11.080  -7.977  38.279  1.00 20.48           C  
ATOM   1392  CG2 VAL A 171     -11.244  -8.613  35.875  1.00 21.10           C  
ATOM   1393  N   ASN A 172      -7.584  -8.041  38.918  1.00 19.36           N  
ATOM   1394  CA  ASN A 172      -6.844  -8.229  40.160  1.00 19.92           C  
ATOM   1395  C   ASN A 172      -7.687  -7.825  41.367  1.00 20.06           C  
ATOM   1396  O   ASN A 172      -7.513  -6.745  41.916  1.00 21.11           O  
ATOM   1397  CB  ASN A 172      -5.515  -7.468  40.130  1.00 19.76           C  
ATOM   1398  CG  ASN A 172      -4.614  -7.827  41.297  1.00 20.24           C  
ATOM   1399  OD1 ASN A 172      -4.812  -8.861  41.949  1.00 21.04           O  
ATOM   1400  ND2 ASN A 172      -3.617  -6.982  41.573  1.00 20.06           N  
ATOM   1401  N   ASP A 173      -8.608  -8.703  41.758  1.00 19.73           N  
ATOM   1402  CA  ASP A 173      -9.470  -8.466  42.928  1.00 20.99           C  
ATOM   1403  C   ASP A 173      -8.780  -8.867  44.223  1.00 20.86           C  
ATOM   1404  O   ASP A 173      -8.943  -8.224  45.222  1.00 21.65           O  
ATOM   1405  CB  ASP A 173     -10.827  -9.198  42.794  1.00 21.31           C  
ATOM   1406  CG  ASP A 173     -10.699 -10.722  42.793  1.00 25.29           C  
ATOM   1407  OD1 ASP A 173      -9.697 -11.212  42.250  1.00 23.87           O  
ATOM   1408  OD2 ASP A 173     -11.603 -11.428  43.312  1.00 26.87           O  
ATOM   1409  N   ASP A 174      -7.988  -9.933  44.179  1.00 21.07           N  
ATOM   1410  CA  ASP A 174      -7.340 -10.490  45.366  1.00 20.54           C  
ATOM   1411  C   ASP A 174      -6.072 -11.118  44.839  1.00 20.49           C  
ATOM   1412  O   ASP A 174      -6.148 -11.899  43.899  1.00 20.07           O  
ATOM   1413  CB  ASP A 174      -8.194 -11.581  45.970  1.00 21.87           C  
ATOM   1414  CG  ASP A 174      -7.456 -12.374  47.033  1.00 23.12           C  
ATOM   1415  OD1 ASP A 174      -7.066 -11.771  48.067  1.00 25.64           O  
ATOM   1416  OD2 ASP A 174      -7.271 -13.588  46.834  1.00 25.12           O  
ATOM   1417  N   LEU A 175      -4.925 -10.810  45.435  1.00 19.98           N  
ATOM   1418  CA  LEU A 175      -3.664 -11.244  44.859  1.00 19.71           C  
ATOM   1419  C   LEU A 175      -3.563 -12.759  44.758  1.00 18.34           C  
ATOM   1420  O   LEU A 175      -3.088 -13.265  43.752  1.00 18.54           O  
ATOM   1421  CB  LEU A 175      -2.482 -10.726  45.671  1.00 20.71           C  
ATOM   1422  CG  LEU A 175      -2.155  -9.248  45.471  1.00 25.71           C  
ATOM   1423  CD1 LEU A 175      -1.211  -8.810  46.582  1.00 27.04           C  
ATOM   1424  CD2 LEU A 175      -1.555  -9.028  44.074  1.00 27.09           C  
ATOM   1425  N   ALA A 176      -3.918 -13.482  45.822  1.00 16.43           N  
ATOM   1426  CA  ALA A 176      -3.811 -14.975  45.766  1.00 17.50           C  
ATOM   1427  C   ALA A 176      -4.666 -15.571  44.654  1.00 17.88           C  
ATOM   1428  O   ALA A 176      -4.203 -16.417  43.885  1.00 17.13           O  
ATOM   1429  CB  ALA A 176      -4.176 -15.602  47.104  1.00 19.12           C  
ATOM   1430  N   ARG A 177      -5.926 -15.157  44.566  1.00 17.85           N  
ATOM   1431  CA  ARG A 177      -6.805 -15.665  43.529  1.00 17.64           C  
ATOM   1432  C   ARG A 177      -6.298 -15.287  42.148  1.00 17.67           C  
ATOM   1433  O   ARG A 177      -6.266 -16.109  41.227  1.00 17.98           O  
ATOM   1434  CB  ARG A 177      -8.214 -15.115  43.694  1.00 19.10           C  
ATOM   1435  CG  ARG A 177      -9.232 -15.779  42.756  1.00 19.21           C  
ATOM   1436  CD  ARG A 177     -10.251 -14.806  42.186  1.00 21.00           C  
ATOM   1437  NE  ARG A 177      -9.672 -13.770  41.330  1.00 18.98           N  
ATOM   1438  CZ  ARG A 177      -9.325 -13.943  40.061  1.00 21.44           C  
ATOM   1439  NH1 ARG A 177      -9.464 -15.122  39.465  1.00 18.90           N  
ATOM   1440  NH2 ARG A 177      -8.807 -12.917  39.383  1.00 22.17           N  
ATOM   1441  N   THR A 178      -5.948 -14.019  41.995  1.00 17.45           N  
ATOM   1442  CA  THR A 178      -5.522 -13.512  40.691  1.00 17.51           C  
ATOM   1443  C   THR A 178      -4.230 -14.164  40.220  1.00 17.55           C  
ATOM   1444  O   THR A 178      -4.105 -14.534  39.032  1.00 18.53           O  
ATOM   1445  CB  THR A 178      -5.334 -12.002  40.749  1.00 19.44           C  
ATOM   1446  OG1 THR A 178      -6.557 -11.412  41.199  1.00 19.04           O  
ATOM   1447  CG2 THR A 178      -4.962 -11.475  39.374  1.00 17.40           C  
ATOM   1448  N   TYR A 179      -3.289 -14.362  41.144  1.00 17.60           N  
ATOM   1449  CA  TYR A 179      -2.068 -15.044  40.772  1.00 17.56           C  
ATOM   1450  C   TYR A 179      -2.305 -16.509  40.414  1.00 18.42           C  
ATOM   1451  O   TYR A 179      -1.660 -17.040  39.498  1.00 18.74           O  
ATOM   1452  CB  TYR A 179      -0.967 -14.919  41.834  1.00 19.17           C  
ATOM   1453  CG  TYR A 179       0.292 -15.595  41.339  1.00 20.68           C  
ATOM   1454  CD1 TYR A 179       1.033 -15.039  40.285  1.00 20.64           C  
ATOM   1455  CD2 TYR A 179       0.699 -16.831  41.846  1.00 20.65           C  
ATOM   1456  CE1 TYR A 179       2.148 -15.670  39.792  1.00 20.21           C  
ATOM   1457  CE2 TYR A 179       1.826 -17.475  41.347  1.00 19.42           C  
ATOM   1458  CZ  TYR A 179       2.533 -16.894  40.314  1.00 20.93           C  
ATOM   1459  OH  TYR A 179       3.630 -17.522  39.803  1.00 21.30           O  
ATOM   1460  N   ALA A 180      -3.190 -17.175  41.147  1.00 16.82           N  
ATOM   1461  CA  ALA A 180      -3.541 -18.556  40.781  1.00 17.96           C  
ATOM   1462  C   ALA A 180      -4.069 -18.607  39.341  1.00 18.65           C  
ATOM   1463  O   ALA A 180      -3.722 -19.510  38.592  1.00 19.99           O  
ATOM   1464  CB  ALA A 180      -4.541 -19.152  41.776  1.00 18.94           C  
ATOM   1465  N   GLU A 181      -4.883 -17.632  38.945  1.00 18.72           N  
ATOM   1466  CA  GLU A 181      -5.344 -17.549  37.564  1.00 19.54           C  
ATOM   1467  C   GLU A 181      -4.221 -17.256  36.561  1.00 18.82           C  
ATOM   1468  O   GLU A 181      -4.080 -17.932  35.525  1.00 19.10           O  
ATOM   1469  CB  GLU A 181      -6.453 -16.501  37.439  1.00 18.12           C  
ATOM   1470  CG  GLU A 181      -6.921 -16.297  36.009  1.00 18.91           C  
ATOM   1471  CD  GLU A 181      -7.934 -15.209  35.847  1.00 23.20           C  
ATOM   1472  OE1 GLU A 181      -8.377 -14.611  36.865  1.00 21.98           O  
ATOM   1473  OE2 GLU A 181      -8.284 -14.934  34.673  1.00 24.03           O  
ATOM   1474  N   LEU A 182      -3.429 -16.238  36.874  1.00 18.23           N  
ATOM   1475  CA  LEU A 182      -2.332 -15.806  36.034  1.00 19.14           C  
ATOM   1476  C   LEU A 182      -1.311 -16.925  35.776  1.00 19.22           C  
ATOM   1477  O   LEU A 182      -0.909 -17.142  34.648  1.00 19.04           O  
ATOM   1478  CB  LEU A 182      -1.650 -14.602  36.668  1.00 18.18           C  
ATOM   1479  CG  LEU A 182      -0.381 -14.085  35.991  1.00 17.86           C  
ATOM   1480  CD1 LEU A 182      -0.726 -13.689  34.553  1.00 18.68           C  
ATOM   1481  CD2 LEU A 182       0.252 -12.979  36.778  1.00 20.58           C  
ATOM   1482  N   ARG A 183      -0.888 -17.636  36.813  1.00 19.69           N  
ATOM   1483  CA  ARG A 183       0.116 -18.686  36.626  1.00 20.03           C  
ATOM   1484  C   ARG A 183      -0.399 -19.792  35.706  1.00 20.87           C  
ATOM   1485  O   ARG A 183       0.358 -20.312  34.895  1.00 20.68           O  
ATOM   1486  CB  ARG A 183       0.602 -19.257  37.958  1.00 20.68           C  
ATOM   1487  CG  ARG A 183      -0.421 -20.029  38.723  1.00 20.28           C  
ATOM   1488  CD  ARG A 183       0.114 -20.432  40.101  1.00 19.29           C  
ATOM   1489  NE  ARG A 183       1.230 -21.366  40.023  1.00 19.19           N  
ATOM   1490  CZ  ARG A 183       1.095 -22.659  39.727  1.00 20.47           C  
ATOM   1491  NH1 ARG A 183      -0.108 -23.178  39.487  1.00 21.72           N  
ATOM   1492  NH2 ARG A 183       2.157 -23.442  39.681  1.00 20.74           N  
ATOM   1493  N   GLU A 184      -1.688 -20.121  35.792  1.00 21.40           N  
ATOM   1494  CA  GLU A 184      -2.261 -21.120  34.888  1.00 23.38           C  
ATOM   1495  C   GLU A 184      -2.309 -20.631  33.436  1.00 22.57           C  
ATOM   1496  O   GLU A 184      -2.031 -21.387  32.505  1.00 20.74           O  
ATOM   1497  CB  GLU A 184      -3.618 -21.623  35.408  1.00 25.33           C  
ATOM   1498  CG  GLU A 184      -3.402 -22.696  36.490  1.00 30.20           C  
ATOM   1499  CD  GLU A 184      -4.675 -23.218  37.118  1.00 30.81           C  
ATOM   1500  OE1 GLU A 184      -4.690 -23.396  38.368  1.00 33.20           O  
ATOM   1501  OE2 GLU A 184      -5.651 -23.444  36.358  1.00 37.37           O  
ATOM   1502  N   TYR A 185      -2.615 -19.359  33.253  1.00 22.16           N  
ATOM   1503  CA  TYR A 185      -2.523 -18.750  31.919  1.00 22.27           C  
ATOM   1504  C   TYR A 185      -1.104 -18.820  31.358  1.00 21.58           C  
ATOM   1505  O   TYR A 185      -0.915 -19.108  30.166  1.00 21.33           O  
ATOM   1506  CB  TYR A 185      -2.937 -17.277  31.960  1.00 23.61           C  
ATOM   1507  CG  TYR A 185      -2.802 -16.643  30.604  1.00 24.06           C  
ATOM   1508  CD1 TYR A 185      -3.652 -17.008  29.571  1.00 27.92           C  
ATOM   1509  CD2 TYR A 185      -1.807 -15.707  30.338  1.00 25.37           C  
ATOM   1510  CE1 TYR A 185      -3.523 -16.448  28.297  1.00 26.94           C  
ATOM   1511  CE2 TYR A 185      -1.678 -15.146  29.070  1.00 25.22           C  
ATOM   1512  CZ  TYR A 185      -2.542 -15.530  28.064  1.00 26.91           C  
ATOM   1513  OH  TYR A 185      -2.434 -14.995  26.803  1.00 27.73           O  
ATOM   1514  N   LEU A 186      -0.118 -18.509  32.209  1.00 20.05           N  
ATOM   1515  CA  LEU A 186       1.274 -18.512  31.793  1.00 20.26           C  
ATOM   1516  C   LEU A 186       1.766 -19.926  31.464  1.00 19.66           C  
ATOM   1517  O   LEU A 186       2.444 -20.127  30.451  1.00 19.19           O  
ATOM   1518  CB  LEU A 186       2.169 -17.886  32.853  1.00 20.36           C  
ATOM   1519  CG  LEU A 186       1.987 -16.401  33.133  1.00 20.26           C  
ATOM   1520  CD1 LEU A 186       2.928 -15.932  34.215  1.00 20.47           C  
ATOM   1521  CD2 LEU A 186       2.168 -15.557  31.819  1.00 20.36           C  
ATOM   1522  N   LEU A 187       1.437 -20.889  32.319  1.00 19.79           N  
ATOM   1523  CA  LEU A 187       1.792 -22.291  32.077  1.00 20.42           C  
ATOM   1524  C   LEU A 187       1.156 -22.813  30.802  1.00 21.54           C  
ATOM   1525  O   LEU A 187       1.759 -23.611  30.084  1.00 21.69           O  
ATOM   1526  CB  LEU A 187       1.405 -23.150  33.286  1.00 20.95           C  
ATOM   1527  CG  LEU A 187       2.276 -22.878  34.516  1.00 19.95           C  
ATOM   1528  CD1 LEU A 187       1.657 -23.432  35.803  1.00 20.90           C  
ATOM   1529  CD2 LEU A 187       3.683 -23.445  34.308  1.00 19.02           C  
ATOM   1530  N   GLY A 188      -0.054 -22.360  30.503  1.00 21.93           N  
ATOM   1531  CA  GLY A 188      -0.734 -22.756  29.274  1.00 22.95           C  
ATOM   1532  C   GLY A 188      -0.129 -22.089  28.049  1.00 22.66           C  
ATOM   1533  O   GLY A 188      -0.117 -22.672  26.943  1.00 23.49           O  
ATOM   1534  N   SER A 189       0.371 -20.870  28.228  1.00 22.11           N  
ATOM   1535  CA  SER A 189       0.882 -20.058  27.129  1.00 22.10           C  
ATOM   1536  C   SER A 189       2.338 -20.379  26.808  1.00 21.75           C  
ATOM   1537  O   SER A 189       2.800 -20.207  25.666  1.00 21.12           O  
ATOM   1538  CB  SER A 189       0.726 -18.555  27.459  1.00 22.70           C  
ATOM   1539  OG  SER A 189      -0.655 -18.238  27.570  1.00 25.70           O  
ATOM   1540  N   TYR A 190       3.064 -20.817  27.830  1.00 19.92           N  
ATOM   1541  CA  TYR A 190       4.485 -21.113  27.712  1.00 19.72           C  
ATOM   1542  C   TYR A 190       4.664 -22.578  28.075  1.00 18.63           C  
ATOM   1543  O   TYR A 190       4.918 -22.883  29.247  1.00 17.72           O  
ATOM   1544  CB  TYR A 190       5.277 -20.288  28.704  1.00 19.63           C  
ATOM   1545  CG  TYR A 190       5.391 -18.814  28.361  1.00 18.78           C  
ATOM   1546  CD1 TYR A 190       6.203 -18.402  27.309  1.00 17.02           C  
ATOM   1547  CD2 TYR A 190       4.689 -17.850  29.082  1.00 16.62           C  
ATOM   1548  CE1 TYR A 190       6.343 -17.044  26.983  1.00 19.60           C  
ATOM   1549  CE2 TYR A 190       4.805 -16.495  28.766  1.00 19.27           C  
ATOM   1550  CZ  TYR A 190       5.637 -16.093  27.726  1.00 18.89           C  
ATOM   1551  OH  TYR A 190       5.779 -14.764  27.412  1.00 20.51           O  
ATOM   1552  N   PRO A 191       4.486 -23.474  27.100  1.00 20.17           N  
ATOM   1553  CA  PRO A 191       4.644 -24.901  27.411  1.00 20.37           C  
ATOM   1554  C   PRO A 191       6.050 -25.246  27.915  1.00 20.61           C  
ATOM   1555  O   PRO A 191       6.249 -26.341  28.447  1.00 19.06           O  
ATOM   1556  CB  PRO A 191       4.360 -25.602  26.076  1.00 21.38           C  
ATOM   1557  CG  PRO A 191       4.409 -24.540  25.037  1.00 23.19           C  
ATOM   1558  CD  PRO A 191       4.090 -23.247  25.703  1.00 20.29           C  
ATOM   1559  N   GLN A 192       6.994 -24.306  27.764  1.00 18.68           N  
ATOM   1560  CA  GLN A 192       8.379 -24.486  28.194  1.00 19.73           C  
ATOM   1561  C   GLN A 192       8.563 -24.246  29.682  1.00 20.34           C  
ATOM   1562  O   GLN A 192       9.614 -24.587  30.217  1.00 20.51           O  
ATOM   1563  CB  GLN A 192       9.321 -23.496  27.491  1.00 19.84           C  
ATOM   1564  CG  GLN A 192       9.122 -23.339  26.012  1.00 19.54           C  
ATOM   1565  CD  GLN A 192       8.056 -22.338  25.640  1.00 20.04           C  
ATOM   1566  OE1 GLN A 192       7.259 -21.890  26.486  1.00 21.16           O  
ATOM   1567  NE2 GLN A 192       8.035 -21.964  24.367  1.00 21.48           N  
ATOM   1568  N   LEU A 193       7.557 -23.647  30.328  1.00 20.13           N  
ATOM   1569  CA  LEU A 193       7.686 -23.105  31.683  1.00 22.24           C  
ATOM   1570  C   LEU A 193       7.398 -24.101  32.802  1.00 23.21           C  
ATOM   1571  O   LEU A 193       6.398 -24.801  32.764  1.00 24.25           O  
ATOM   1572  CB  LEU A 193       6.712 -21.943  31.834  1.00 21.78           C  
ATOM   1573  CG  LEU A 193       6.867 -21.015  33.043  1.00 21.70           C  
ATOM   1574  CD1 LEU A 193       8.180 -20.207  33.001  1.00 21.20           C  
ATOM   1575  CD2 LEU A 193       5.650 -20.101  33.121  1.00 22.92           C  
ATOM   1576  N   ARG A 194       8.282 -24.141  33.797  1.00 25.18           N  
ATOM   1577  CA  ARG A 194       8.024 -24.838  35.072  1.00 26.26           C  
ATOM   1578  C   ARG A 194       8.658 -24.036  36.215  1.00 24.60           C  
ATOM   1579  O   ARG A 194       9.509 -23.178  35.978  1.00 22.73           O  
ATOM   1580  CB  ARG A 194       8.555 -26.292  35.026  1.00 28.15           C  
ATOM   1581  CG  ARG A 194      10.065 -26.554  35.391  1.00 28.75           C  
ATOM   1582  CD  ARG A 194      10.180 -28.002  35.831  1.00 32.91           C  
ATOM   1583  NE  ARG A 194      11.469 -28.520  36.332  1.00 33.14           N  
ATOM   1584  CZ  ARG A 194      11.842 -28.469  37.609  1.00 35.43           C  
ATOM   1585  NH1 ARG A 194      11.085 -27.885  38.531  1.00 36.04           N  
ATOM   1586  NH2 ARG A 194      13.005 -28.976  37.966  1.00 38.22           N  
ATOM   1587  N   GLY A 195       8.255 -24.330  37.444  1.00 24.74           N  
ATOM   1588  CA  GLY A 195       8.680 -23.566  38.596  1.00 24.30           C  
ATOM   1589  C   GLY A 195      10.179 -23.584  38.782  1.00 24.66           C  
ATOM   1590  O   GLY A 195      10.856 -24.522  38.358  1.00 24.93           O  
ATOM   1591  N   GLY A 196      10.689 -22.527  39.407  1.00 24.88           N  
ATOM   1592  CA  GLY A 196      12.034 -22.508  39.958  1.00 24.18           C  
ATOM   1593  C   GLY A 196      13.007 -21.636  39.198  1.00 24.81           C  
ATOM   1594  O   GLY A 196      12.636 -20.868  38.290  1.00 23.08           O  
ATOM   1595  OXT GLY A 196      14.206 -21.706  39.517  1.00 24.73           O  
TER    1596      GLY A 196                                                      
END
MOLECULE T0416_6_115_194_315.pdb
ATOM      1  N   LYS     6       9.770 -16.706  17.344  1.00 47.34          
ATOM      2  CA  LYS     6       9.686 -15.469  18.171  1.00 47.92          
ATOM      3  C   LYS     6       9.964 -15.789  19.633  1.00 48.21          
ATOM      4  O   LYS     6       9.492 -16.801  20.167  1.00 48.06          
ATOM      5  CB  LYS     6       8.296 -14.851  18.062  1.00 48.33          
ATOM      6  CG  LYS     6       7.859 -14.572  16.663  1.00 51.47          
ATOM      7  CD  LYS     6       6.355 -14.397  16.582  1.00 55.16          
ATOM      8  CE  LYS     6       5.919 -14.283  15.119  1.00 58.23          
ATOM      9  NZ  LYS     6       4.444 -14.137  14.929  1.00 59.84          
ATOM     10  N   PRO     7      10.743 -14.930  20.304  1.00 47.62          
ATOM     11  CA  PRO     7      11.079 -15.125  21.721  1.00 47.47          
ATOM     12  C   PRO     7       9.897 -14.902  22.682  1.00 46.63          
ATOM     13  O   PRO     7       9.082 -13.993  22.493  1.00 46.51          
ATOM     14  CB  PRO     7      12.203 -14.114  21.955  1.00 48.11          
ATOM     15  CG  PRO     7      11.877 -13.021  20.986  1.00 48.00          
ATOM     16  CD  PRO     7      11.471 -13.782  19.741  1.00 46.88          
ATOM     17  N   PHE     8       9.814 -15.737  23.715  1.00 44.40          
ATOM     18  CA  PHE     8       8.747 -15.622  24.697  1.00 41.95          
ATOM     19  C   PHE     8       8.958 -14.388  25.566  1.00 40.54          
ATOM     20  O   PHE     8      10.068 -14.136  26.041  1.00 40.58          
ATOM     21  CB  PHE     8       8.694 -16.865  25.591  1.00 41.58          
ATOM     22  CG  PHE     8       7.522 -16.884  26.531  1.00 41.07          
ATOM     23  CD1 PHE     8       6.222 -16.919  26.036  1.00 42.79          
ATOM     24  CD2 PHE     8       7.707 -16.854  27.901  1.00 39.99          
ATOM     25  CE1 PHE     8       5.122 -16.927  26.895  1.00 42.19          
ATOM     26  CE2 PHE     8       6.611 -16.863  28.767  1.00 41.03          
ATOM     27  CZ  PHE     8       5.315 -16.899  28.253  1.00 40.90          
ATOM     28  N   LEU     9       7.881 -13.631  25.767  1.00 38.04          
ATOM     29  CA  LEU     9       7.915 -12.418  26.583  1.00 36.38          
ATOM     30  C   LEU     9       6.629 -12.238  27.393  1.00 35.98          
ATOM     31  O   LEU     9       5.542 -12.412  26.847  1.00 37.94          
ATOM     32  CB  LEU     9       8.085 -11.198  25.687  1.00 33.92          
ATOM     33  CG  LEU     9       8.128  -9.872  26.431  1.00 31.31          
ATOM     34  CD1 LEU     9       9.465  -9.700  27.105  1.00 30.33          
ATOM     35  CD2 LEU     9       7.901  -8.759  25.453  1.00 32.13          
ATOM     36  N   ILE    10       6.742 -11.899  28.680  1.00 34.13          
ATOM     37  CA  ILE    10       5.554 -11.660  29.516  1.00 33.61          
ATOM     38  C   ILE    10       5.402 -10.159  29.661  1.00 32.88          
ATOM     39  O   ILE    10       6.389  -9.457  29.867  1.00 32.89          
ATOM     40  CB  ILE    10       5.671 -12.221  30.978  1.00 34.19          
ATOM     41  CG1 ILE    10       5.795 -13.745  30.994  1.00 34.92          
ATOM     42  CG2 ILE    10       4.410 -11.875  31.762  1.00 32.53          
ATOM     43  CD  ILE    10       4.537 -14.446  30.557  1.00 35.17          
ATOM     44  N   VAL    11       4.179  -9.656  29.545  1.00 32.25          
ATOM     45  CA  VAL    11       3.953  -8.211  29.699  1.00 33.18          
ATOM     46  C   VAL    11       2.799  -7.993  30.705  1.00 33.37          
ATOM     47  O   VAL    11       1.670  -8.456  30.494  1.00 33.93          
ATOM     48  CB  VAL    11       3.605  -7.524  28.325  1.00 31.73          
ATOM     49  CG1 VAL    11       3.619  -6.017  28.467  1.00 30.56          
ATOM     50  CG2 VAL    11       4.587  -7.943  27.263  1.00 29.73          
ATOM     51  N   ILE    12       3.091  -7.290  31.797  1.00 31.84          
ATOM     52  CA  ILE    12       2.106  -7.032  32.842  1.00 30.80          
ATOM     53  C   ILE    12       1.866  -5.536  33.017  1.00 31.11          
ATOM     54  O   ILE    12       2.624  -4.849  33.708  1.00 30.46          
ATOM     55  CB  ILE    12       2.569  -7.632  34.189  1.00 29.53          
ATOM     56  CG1 ILE    12       2.895  -9.114  33.996  1.00 29.86          
ATOM     57  CG2 ILE    12       1.478  -7.487  35.230  1.00 30.33          
ATOM     58  CD  ILE    12       3.522  -9.776  35.203  1.00 26.96          
ATOM     59  N   VAL    13       0.808  -5.035  32.383  1.00 30.72          
ATOM     60  CA  VAL    13       0.466  -3.620  32.457  1.00 29.94          
ATOM     61  C   VAL    13      -0.652  -3.426  33.452  1.00 29.66          
ATOM     62  O   VAL    13      -1.336  -4.374  33.801  1.00 30.84          
ATOM     63  CB  VAL    13      -0.002  -3.077  31.090  1.00 29.53          
ATOM     64  CG1 VAL    13       1.132  -3.140  30.075  1.00 29.05          
ATOM     65  CG2 VAL    13      -1.188  -3.876  30.601  1.00 28.45          
ATOM     66  N   GLY    14      -0.839  -2.199  33.909  1.00 30.29          
ATOM     67  CA  GLY    14      -1.889  -1.938  34.871  1.00 31.58          
ATOM     68  C   GLY    14      -1.642  -0.598  35.525  1.00 32.22          
ATOM     69  O   GLY    14      -0.521  -0.108  35.523  1.00 31.01          
ATOM     70  N   PRO    15      -2.677   0.021  36.103  1.00 33.98          
ATOM     71  CA  PRO    15      -2.483   1.323  36.744  1.00 35.35          
ATOM     72  C   PRO    15      -1.478   1.279  37.893  1.00 36.07          
ATOM     73  O   PRO    15      -1.230   0.218  38.457  1.00 36.01          
ATOM     74  CB  PRO    15      -3.897   1.696  37.187  1.00 34.89          
ATOM     75  CG  PRO    15      -4.545   0.365  37.419  1.00 34.89          
ATOM     76  CD  PRO    15      -4.070  -0.442  36.245  1.00 35.07          
ATOM     77  N   THR    16      -0.891   2.431  38.211  1.00 36.66          
ATOM     78  CA  THR    16       0.089   2.538  39.286  1.00 38.58          
ATOM     79  C   THR    16      -0.373   1.853  40.573  1.00 40.27          
ATOM     80  O   THR    16      -1.523   2.001  40.989  1.00 40.98          
ATOM     81  CB  THR    16       0.385   3.997  39.643  1.00 37.33          
ATOM     82  OG1 THR    16       0.786   4.705  38.474  1.00 36.77          
ATOM     83  CG2 THR    16       1.495   4.061  40.671  1.00 38.23          
ATOM     84  N   ALA    17       0.536   1.118  41.208  1.00 40.72          
ATOM     85  CA  ALA    17       0.219   0.417  42.443  1.00 42.57          
ATOM     86  C   ALA    17      -1.083  -0.378  42.324  1.00 43.15          
ATOM     87  O   ALA    17      -2.011  -0.205  43.123  1.00 43.42          
ATOM     88  CB  ALA    17       0.109   1.412  43.597  1.00 43.65          
ATOM     89  N   SER    18      -1.159  -1.238  41.317  1.00 42.43          
ATOM     90  CA  SER    18      -2.344  -2.051  41.119  1.00 40.61          
ATOM     91  C   SER    18      -1.921  -3.495  41.298  1.00 40.77          
ATOM     92  O   SER    18      -2.693  -4.424  41.054  1.00 42.04          
ATOM     93  CB  SER    18      -2.892  -1.870  39.719  1.00 38.47          
ATOM     94  OG  SER    18      -2.013  -2.466  38.804  1.00 36.84          
ATOM     95  N   GLY    19      -0.681  -3.681  41.730  1.00 40.01          
ATOM     96  CA  GLY    19      -0.170  -5.026  41.920  1.00 40.03          
ATOM     97  C   GLY    19       0.645  -5.548  40.744  1.00 38.18          
ATOM     98  O   GLY    19       1.235  -6.625  40.806  1.00 38.21          
ATOM     99  N   LYS    20       0.684  -4.791  39.660  1.00 36.98          
ATOM    100  CA  LYS    20       1.444  -5.241  38.522  1.00 35.89          
ATOM    101  C   LYS    20       2.908  -5.443  38.936  1.00 36.34          
ATOM    102  O   LYS    20       3.527  -6.452  38.590  1.00 37.13          
ATOM    103  CB  LYS    20       1.330  -4.248  37.362  1.00 33.94          
ATOM    104  CG  LYS    20       1.849  -2.871  37.685  1.00 32.57          
ATOM    105  CD  LYS    20       1.824  -1.935  36.498  1.00 29.33          
ATOM    106  CE  LYS    20       2.436  -0.614  36.924  1.00 31.07          
ATOM    107  NZ  LYS    20       2.250   0.476  35.923  1.00 35.59          
ATOM    108  N   THR    21       3.455  -4.511  39.705  1.00 35.70          
ATOM    109  CA  THR    21       4.840  -4.619  40.147  1.00 35.75          
ATOM    110  C   THR    21       5.079  -5.838  41.024  1.00 35.78          
ATOM    111  O   THR    21       6.054  -6.572  40.832  1.00 35.67          
ATOM    112  CB  THR    21       5.269  -3.372  40.918  1.00 36.24          
ATOM    113  OG1 THR    21       5.065  -2.221  40.090  1.00 38.69          
ATOM    114  CG2 THR    21       6.742  -3.464  41.302  1.00 36.35          
ATOM    115  N   GLU    22       4.197  -6.056  41.989  1.00 35.56          
ATOM    116  CA  GLU    22       4.326  -7.196  42.879  1.00 36.42          
ATOM    117  C   GLU    22       4.155  -8.475  42.073  1.00 35.88          
ATOM    118  O   GLU    22       4.979  -9.381  42.161  1.00 37.29          
ATOM    119  CB  GLU    22       3.271  -7.119  43.984  1.00 39.34          
ATOM    120  CG  GLU    22       3.439  -5.935  44.935  1.00 43.60          
ATOM    121  CD  GLU    22       3.007  -4.586  44.343  1.00 45.57          
ATOM    122  OE1 GLU    22       3.218  -3.557  45.018  1.00 48.08          
ATOM    123  OE2 GLU    22       2.457  -4.544  43.224  1.00 46.06          
ATOM    124  N   LEU    23       3.090  -8.539  41.276  1.00 34.58          
ATOM    125  CA  LEU    23       2.826  -9.704  40.445  1.00 32.10          
ATOM    126  C   LEU    23       4.039 -10.051  39.576  1.00 31.09          
ATOM    127  O   LEU    23       4.403 -11.217  39.458  1.00 27.98          
ATOM    128  CB  LEU    23       1.599  -9.455  39.558  1.00 30.74          
ATOM    129  CG  LEU    23       1.222 -10.580  38.579  1.00 28.65          
ATOM    130  CD1 LEU    23       0.822 -11.814  39.341  1.00 28.78          
ATOM    131  CD2 LEU    23       0.098 -10.121  37.709  1.00 27.36          
ATOM    132  N   SER    24       4.663  -9.040  38.973  1.00 32.29          
ATOM    133  CA  SER    24       5.842  -9.271  38.129  1.00 34.51          
ATOM    134  C   SER    24       6.915 -10.040  38.890  1.00 34.30          
ATOM    135  O   SER    24       7.439 -11.030  38.403  1.00 35.07          
ATOM    136  CB  SER    24       6.445  -7.954  37.634  1.00 35.30          
ATOM    137  OG  SER    24       5.598  -7.333  36.691  1.00 39.93          
ATOM    138  N   ILE    25       7.237  -9.584  40.089  1.00 33.62          
ATOM    139  CA  ILE    25       8.251 -10.244  40.876  1.00 33.95          
ATOM    140  C   ILE    25       7.850 -11.690  41.196  1.00 35.37          
ATOM    141  O   ILE    25       8.677 -12.608  41.097  1.00 35.34          
ATOM    142  CB  ILE    25       8.529  -9.434  42.163  1.00 32.96          
ATOM    143  CG1 ILE    25       9.066  -8.055  41.768  1.00 30.36          
ATOM    144  CG2 ILE    25       9.512 -10.154  43.053  1.00 31.35          
ATOM    145  CD  ILE    25       9.495  -7.203  42.916  1.00 28.44          
ATOM    146  N   GLU    26       6.586 -11.909  41.554  1.00 36.42          
ATOM    147  CA  GLU    26       6.106 -13.262  41.869  1.00 38.00          
ATOM    148  C   GLU    26       6.267 -14.202  40.671  1.00 37.34          
ATOM    149  O   GLU    26       6.623 -15.369  40.836  1.00 37.59          
ATOM    150  CB  GLU    26       4.635 -13.220  42.317  1.00 39.45          
ATOM    151  CG  GLU    26       4.434 -12.560  43.690  1.00 44.45          
ATOM    152  CD  GLU    26       5.131 -13.307  44.839  1.00 47.76          
ATOM    153  OE1 GLU    26       4.635 -14.390  45.253  1.00 48.13          
ATOM    154  OE2 GLU    26       6.188 -12.815  45.322  1.00 48.16          
ATOM    155  N   VAL    27       6.001 -13.683  39.473  1.00 36.34          
ATOM    156  CA  VAL    27       6.141 -14.460  38.248  1.00 34.75          
ATOM    157  C   VAL    27       7.627 -14.683  37.994  1.00 35.06          
ATOM    158  O   VAL    27       8.044 -15.752  37.567  1.00 34.96          
ATOM    159  CB  VAL    27       5.549 -13.714  37.055  1.00 31.86          
ATOM    160  CG1 VAL    27       5.834 -14.462  35.783  1.00 29.36          
ATOM    161  CG2 VAL    27       4.072 -13.543  37.255  1.00 31.53          
ATOM    162  N   ALA    28       8.419 -13.657  38.275  1.00 35.66          
ATOM    163  CA  ALA    28       9.849 -13.720  38.085  1.00 36.34          
ATOM    164  C   ALA    28      10.465 -14.753  39.009  1.00 38.34          
ATOM    165  O   ALA    28      11.452 -15.406  38.660  1.00 39.44          
ATOM    166  CB  ALA    28      10.464 -12.368  38.340  1.00 36.23          
ATOM    167  N   LYS    29       9.889 -14.910  40.194  1.00 39.77          
ATOM    168  CA  LYS    29      10.408 -15.880  41.146  1.00 40.39          
ATOM    169  C   LYS    29       9.949 -17.299  40.859  1.00 40.52          
ATOM    170  O   LYS    29      10.622 -18.239  41.252  1.00 41.59          
ATOM    171  CB  LYS    29      10.006 -15.511  42.574  1.00 40.53          
ATOM    172  CG  LYS    29      10.744 -14.316  43.150  1.00 41.23          
ATOM    173  CD  LYS    29      10.663 -14.309  44.681  1.00 44.42          
ATOM    174  CE  LYS    29       9.211 -14.279  45.195  1.00 44.59          
ATOM    175  NZ  LYS    29       9.113 -14.333  46.690  1.00 43.59          
ATOM    176  N   LYS    30       8.816 -17.465  40.186  1.00 40.21          
ATOM    177  CA  LYS    30       8.337 -18.806  39.901  1.00 41.59          
ATOM    178  C   LYS    30       8.884 -19.327  38.571  1.00 43.51          
ATOM    179  O   LYS    30       8.861 -20.529  38.327  1.00 43.62          
ATOM    180  CB  LYS    30       6.801 -18.834  39.902  1.00 42.72          
ATOM    181  CG  LYS    30       6.171 -20.223  39.924  1.00 43.38          
ATOM    182  CD  LYS    30       4.653 -20.122  39.904  1.00 45.84          
ATOM    183  CE  LYS    30       3.983 -21.471  40.139  1.00 47.92          
ATOM    184  NZ  LYS    30       2.499 -21.323  40.293  1.00 50.92          
ATOM    185  N   PHE    31       9.388 -18.430  37.721  1.00 44.17          
ATOM    186  CA  PHE    31       9.940 -18.814  36.419  1.00 44.51          
ATOM    187  C   PHE    31      11.289 -18.170  36.195  1.00 45.33          
ATOM    188  O   PHE    31      11.634 -17.818  35.068  1.00 45.02          
ATOM    189  CB  PHE    31       8.991 -18.398  35.307  1.00 44.39          
ATOM    190  CG  PHE    31       7.643 -19.013  35.427  1.00 45.82          
ATOM    191  CD1 PHE    31       7.406 -20.293  34.943  1.00 47.34          
ATOM    192  CD2 PHE    31       6.620 -18.344  36.087  1.00 46.46          
ATOM    193  CE1 PHE    31       6.160 -20.904  35.118  1.00 48.67          
ATOM    194  CE2 PHE    31       5.371 -18.940  36.271  1.00 47.96          
ATOM    195  CZ  PHE    31       5.137 -20.224  35.787  1.00 48.48          
ATOM    196  N   ASN    32      12.050 -18.044  37.282  1.00 47.84          
ATOM    197  CA  ASN    32      13.382 -17.419  37.295  1.00 49.84          
ATOM    198  C   ASN    32      13.603 -16.505  36.095  1.00 49.50          
ATOM    199  O   ASN    32      14.394 -16.794  35.191  1.00 50.98          
ATOM    200  CB  ASN    32      14.500 -18.479  37.383  1.00 51.79          
ATOM    201  CG  ASN    32      14.698 -19.234  36.078  1.00 54.42          
ATOM    202  OD1 ASN    32      13.726 -19.668  35.450  1.00 56.40          
ATOM    203  ND2 ASN    32      15.954 -19.411  35.670  1.00 55.03          
ATOM    204  N   GLY    33      12.871 -15.398  36.096  1.00 47.07          
ATOM    205  CA  GLY    33      12.994 -14.433  35.027  1.00 44.42          
ATOM    206  C   GLY    33      13.567 -13.138  35.566  1.00 42.58          
ATOM    207  O   GLY    33      13.970 -13.059  36.725  1.00 41.73          
ATOM    208  N   GLU    34      13.620 -12.124  34.711  1.00 41.54          
ATOM    209  CA  GLU    34      14.122 -10.821  35.099  1.00 39.53          
ATOM    210  C   GLU    34      13.166  -9.801  34.512  1.00 38.04          
ATOM    211  O   GLU    34      12.592 -10.005  33.440  1.00 36.36          
ATOM    212  CB  GLU    34      15.537 -10.613  34.582  1.00 39.38          
ATOM    213  CG  GLU    34      16.453 -11.766  34.939  1.00 40.36          
ATOM    214  CD  GLU    34      17.877 -11.540  34.490  1.00 41.95          
ATOM    215  OE1 GLU    34      18.066 -10.907  33.422  1.00 43.40          
ATOM    216  OE2 GLU    34      18.814 -12.009  35.185  1.00 40.07          
ATOM    217  N   ILE    35      13.008  -8.695  35.222  1.00 37.64          
ATOM    218  CA  ILE    35      12.066  -7.665  34.828  1.00 37.78          
ATOM    219  C   ILE    35      12.679  -6.440  34.183  1.00 37.21          
ATOM    220  O   ILE    35      13.723  -5.963  34.602  1.00 37.93          
ATOM    221  CB  ILE    35      11.252  -7.203  36.064  1.00 37.03          
ATOM    222  CG1 ILE    35      10.621  -8.415  36.738  1.00 36.19          
ATOM    223  CG2 ILE    35      10.186  -6.211  35.656  1.00 37.14          
ATOM    224  CD  ILE    35       9.858  -8.090  37.952  1.00 35.95          
ATOM    225  N   ILE    36      12.003  -5.926  33.166  1.00 37.04          
ATOM    226  CA  ILE    36      12.438  -4.716  32.496  1.00 36.12          
ATOM    227  C   ILE    36      11.354  -3.669  32.787  1.00 37.69          
ATOM    228  O   ILE    36      10.207  -3.833  32.380  1.00 38.12          
ATOM    229  CB  ILE    36      12.548  -4.928  30.981  1.00 33.73          
ATOM    230  CG1 ILE    36      13.667  -5.921  30.678  1.00 31.77          
ATOM    231  CG2 ILE    36      12.795  -3.610  30.292  1.00 31.97          
ATOM    232  CD  ILE    36      13.730  -6.342  29.233  1.00 26.96          
ATOM    233  N   SER    37      11.709  -2.610  33.506  1.00 37.83          
ATOM    234  CA  SER    37      10.744  -1.571  33.829  1.00 37.74          
ATOM    235  C   SER    37      10.202  -0.918  32.553  1.00 37.95          
ATOM    236  O   SER    37      10.969  -0.487  31.692  1.00 37.35          
ATOM    237  CB  SER    37      11.403  -0.535  34.740  1.00 36.72          
ATOM    238  OG  SER    37      10.688   0.680  34.738  1.00 36.77          
ATOM    239  N   GLY    38       8.874  -0.871  32.426  1.00 38.61          
ATOM    240  CA  GLY    38       8.253  -0.268  31.252  1.00 39.20          
ATOM    241  C   GLY    38       7.872   1.183  31.485  1.00 41.13          
ATOM    242  O   GLY    38       7.455   1.899  30.565  1.00 39.58          
ATOM    243  N   ASP    39       8.020   1.615  32.734  1.00 42.10          
ATOM    244  CA  ASP    39       7.694   2.977  33.129  1.00 44.59          
ATOM    245  C   ASP    39       8.674   3.991  32.530  1.00 45.44          
ATOM    246  O   ASP    39       9.884   3.849  32.665  1.00 46.29          
ATOM    247  CB  ASP    39       7.719   3.090  34.648  1.00 46.64          
ATOM    248  CG  ASP    39       7.028   4.342  35.149  1.00 49.62          
ATOM    249  OD1 ASP    39       7.453   5.452  34.775  1.00 51.11          
ATOM    250  OD2 ASP    39       6.046   4.214  35.915  1.00 52.78          
ATOM    251  N   SER    40       8.149   5.028  31.890  1.00 45.73          
ATOM    252  CA  SER    40       9.007   6.038  31.286  1.00 46.96          
ATOM    253  C   SER    40       9.523   7.073  32.276  1.00 47.74          
ATOM    254  O   SER    40      10.194   8.033  31.886  1.00 47.33          
ATOM    255  CB  SER    40       8.276   6.763  30.142  1.00 46.76          
ATOM    256  OG  SER    40       7.151   7.504  30.591  1.00 44.02          
ATOM    257  N   MET    41       9.212   6.894  33.554  1.00 49.05          
ATOM    258  CA  MET    41       9.645   7.852  34.575  1.00 50.21          
ATOM    259  C   MET    41      10.623   7.277  35.575  1.00 48.79          
ATOM    260  O   MET    41      11.443   7.998  36.156  1.00 48.16          
ATOM    261  CB  MET    41       8.430   8.401  35.322  1.00 54.92          
ATOM    262  CG  MET    41       7.630   9.422  34.534  1.00 60.15          
ATOM    263  SD  MET    41       8.726  10.939  33.973  1.00 69.60          
ATOM    264  CE  MET    41       9.133  11.711  35.709  1.00 65.89          
ATOM    265  N   GLN    42      10.521   5.967  35.778  1.00 47.21          
ATOM    266  CA  GLN    42      11.387   5.258  36.710  1.00 44.79          
ATOM    267  C   GLN    42      12.805   5.173  36.162  1.00 43.38          
ATOM    268  O   GLN    42      13.702   4.659  36.822  1.00 42.91          
ATOM    269  CB  GLN    42      10.808   3.867  36.988  1.00 44.81          
ATOM    270  CG  GLN    42       9.722   3.895  38.074  1.00 45.40          
ATOM    271  CD  GLN    42       9.045   2.552  38.305  1.00 46.04          
ATOM    272  OE1 GLN    42       9.697   1.498  38.352  1.00 47.48          
ATOM    273  NE2 GLN    42       7.731   2.587  38.483  1.00 45.63          
ATOM    274  N   VAL    43      13.002   5.709  34.960  1.00 41.63          
ATOM    275  CA  VAL    43      14.308   5.709  34.338  1.00 39.69          
ATOM    276  C   VAL    43      15.179   6.815  34.916  1.00 39.24          
ATOM    277  O   VAL    43      16.398   6.742  34.848  1.00 39.12          
ATOM    278  CB  VAL    43      14.194   5.913  32.814  1.00 40.00          
ATOM    279  CG1 VAL    43      13.727   4.629  32.143  1.00 39.83          
ATOM    280  CG2 VAL    43      13.216   7.035  32.519  1.00 37.24          
ATOM    281  N   TYR    44      14.547   7.831  35.496  1.00 39.65          
ATOM    282  CA  TYR    44      15.278   8.961  36.069  1.00 40.32          
ATOM    283  C   TYR    44      15.685   8.755  37.538  1.00 42.44          
ATOM    284  O   TYR    44      14.876   8.359  38.372  1.00 42.07          
ATOM    285  CB  TYR    44      14.450  10.236  35.952  1.00 39.33          
ATOM    286  CG  TYR    44      14.102  10.623  34.536  1.00 40.85          
ATOM    287  CD1 TYR    44      15.075  11.124  33.664  1.00 40.75          
ATOM    288  CD2 TYR    44      12.798  10.482  34.059  1.00 40.46          
ATOM    289  CE1 TYR    44      14.750  11.471  32.350  1.00 41.84          
ATOM    290  CE2 TYR    44      12.467  10.829  32.753  1.00 41.49          
ATOM    291  CZ  TYR    44      13.437  11.319  31.901  1.00 42.05          
ATOM    292  OH  TYR    44      13.093  11.647  30.599  1.00 42.46          
ATOM    293  N   GLN    45      16.945   9.042  37.847  1.00 43.92          
ATOM    294  CA  GLN    45      17.452   8.884  39.196  1.00 46.34          
ATOM    295  C   GLN    45      17.102  10.118  40.029  1.00 47.78          
ATOM    296  O   GLN    45      17.187  11.249  39.548  1.00 47.56          
ATOM    297  CB  GLN    45      18.965   8.648  39.145  1.00 47.12          
ATOM    298  CG  GLN    45      19.690   9.695  38.307  1.00 50.07          
ATOM    299  CD  GLN    45      20.942   9.167  37.622  1.00 50.58          
ATOM    300  OE1 GLN    45      20.898   8.142  36.937  1.00 50.72          
ATOM    301  NE2 GLN    45      22.057   9.879  37.783  1.00 49.70          
ATOM    302  N   GLY    46      16.685   9.896  41.274  1.00 48.21          
ATOM    303  CA  GLY    46      16.318  11.011  42.135  1.00 49.37          
ATOM    304  C   GLY    46      14.813  11.171  42.212  1.00 50.77          
ATOM    305  O   GLY    46      14.273  11.756  43.159  1.00 49.20          
ATOM    306  N   MET    47      14.137  10.648  41.193  1.00 52.76          
ATOM    307  CA  MET    47      12.685  10.704  41.117  1.00 54.61          
ATOM    308  C   MET    47      12.150   9.309  41.425  1.00 53.36          
ATOM    309  O   MET    47      11.777   8.565  40.523  1.00 53.21          
ATOM    310  CB  MET    47      12.261  11.145  39.723  1.00 56.82          
ATOM    311  CG  MET    47      13.015  12.367  39.261  1.00 61.64          
ATOM    312  SD  MET    47      12.390  13.007  37.567  1.00 70.25          
ATOM    313  CE  MET    47      11.239  14.436  38.153  1.00 69.01          
ATOM    314  N   ASP    48      12.109   8.969  42.713  1.00 52.63          
ATOM    315  CA  ASP    48      11.651   7.657  43.149  1.00 51.41          
ATOM    316  C   ASP    48      10.236   7.640  43.742  1.00 49.19          
ATOM    317  O   ASP    48       9.437   6.753  43.438  1.00 48.61          
ATOM    318  CB  ASP    48      12.644   7.074  44.166  1.00 52.25          
ATOM    319  CG  ASP    48      14.094   7.486  43.887  1.00 52.83          
ATOM    320  OD1 ASP    48      14.559   7.391  42.724  1.00 52.86          
ATOM    321  OD2 ASP    48      14.782   7.901  44.845  1.00 52.66          
ATOM    322  N   ILE    49       9.924   8.620  44.578  1.00 46.94          
ATOM    323  CA  ILE    49       8.617   8.680  45.210  1.00 45.38          
ATOM    324  C   ILE    49       7.471   9.008  44.261  1.00 43.66          
ATOM    325  O   ILE    49       6.463   8.309  44.243  1.00 43.49          
ATOM    326  CB  ILE    49       8.618   9.712  46.353  1.00 45.88          
ATOM    327  CG1 ILE    49       9.599   9.276  47.434  1.00 44.79          
ATOM    328  CG2 ILE    49       7.206   9.873  46.912  1.00 46.48          
ATOM    329  CD  ILE    49       9.745  10.265  48.557  1.00 47.30          
ATOM    330  N   GLY    50       7.617  10.070  43.479  1.00 42.05          
ATOM    331  CA  GLY    50       6.546  10.454  42.569  1.00 41.84          
ATOM    332  C   GLY    50       6.304   9.495  41.416  1.00 39.86          
ATOM    333  O   GLY    50       5.323   9.614  40.685  1.00 38.30          
ATOM    334  N   THR    51       7.185   8.522  41.268  1.00 38.59          
ATOM    335  CA  THR    51       7.065   7.593  40.177  1.00 39.16          
ATOM    336  C   THR    51       6.732   6.186  40.632  1.00 39.81          
ATOM    337  O   THR    51       6.650   5.269  39.811  1.00 40.79          
ATOM    338  CB  THR    51       8.364   7.555  39.405  1.00 39.85          
ATOM    339  OG1 THR    51       9.419   7.139  40.288  1.00 39.12          
ATOM    340  CG2 THR    51       8.684   8.950  38.852  1.00 39.88          
ATOM    341  N   ALA    52       6.545   6.017  41.939  1.00 39.14          
ATOM    342  CA  ALA    52       6.226   4.717  42.538  1.00 37.57          
ATOM    343  C   ALA    52       7.338   3.724  42.226  1.00 38.14          
ATOM    344  O   ALA    52       7.094   2.532  42.036  1.00 37.54          
ATOM    345  CB  ALA    52       4.886   4.200  42.022  1.00 35.81          
ATOM    346  N   LYS    53       8.565   4.235  42.181  1.00 40.06          
ATOM    347  CA  LYS    53       9.741   3.420  41.888  1.00 42.16          
ATOM    348  C   LYS    53       9.989   2.345  42.939  1.00 42.20          
ATOM    349  O   LYS    53      10.161   2.651  44.121  1.00 42.30          
ATOM    350  CB  LYS    53      10.978   4.311  41.782  1.00 42.37          
ATOM    351  CG  LYS    53      12.272   3.549  41.536  1.00 42.48          
ATOM    352  CD  LYS    53      13.408   4.512  41.341  1.00 41.69          
ATOM    353  CE  LYS    53      13.132   5.409  40.152  1.00 42.68          
ATOM    354  NZ  LYS    53      14.081   6.557  40.102  1.00 44.19          
ATOM    355  N   VAL    54      10.027   1.089  42.498  1.00 42.43          
ATOM    356  CA  VAL    54      10.262  -0.040  43.395  1.00 42.54          
ATOM    357  C   VAL    54      11.678  -0.002  43.960  1.00 42.74          
ATOM    358  O   VAL    54      12.640   0.289  43.238  1.00 42.21          
ATOM    359  CB  VAL    54      10.024  -1.382  42.660  1.00 43.26          
ATOM    360  CG1 VAL    54      10.765  -1.401  41.325  1.00 43.42          
ATOM    361  CG2 VAL    54      10.471  -2.525  43.538  1.00 44.75          
ATOM    362  N   THR    55      11.810  -0.291  45.250  1.00 41.88          
ATOM    363  CA  THR    55      13.120  -0.254  45.891  1.00 42.17          
ATOM    364  C   THR    55      13.915  -1.537  45.748  1.00 40.91          
ATOM    365  O   THR    55      13.357  -2.611  45.534  1.00 37.85          
ATOM    366  CB  THR    55      12.999   0.093  47.397  1.00 42.92          
ATOM    367  OG1 THR    55      12.447  -1.019  48.126  1.00 45.00          
ATOM    368  CG2 THR    55      12.105   1.306  47.580  1.00 44.24          
ATOM    369  N   THR    56      15.233  -1.406  45.856  1.00 42.43          
ATOM    370  CA  THR    56      16.114  -2.557  45.731  1.00 44.85          
ATOM    371  C   THR    56      15.630  -3.688  46.640  1.00 45.98          
ATOM    372  O   THR    56      15.676  -4.852  46.262  1.00 46.23          
ATOM    373  CB  THR    56      17.581  -2.218  46.109  1.00 44.96          
ATOM    374  OG1 THR    56      17.663  -1.947  47.513  1.00 47.28          
ATOM    375  CG2 THR    56      18.067  -0.995  45.350  1.00 46.18          
ATOM    376  N   GLU    57      15.143  -3.343  47.828  1.00 47.39          
ATOM    377  CA  GLU    57      14.674  -4.344  48.773  1.00 47.62          
ATOM    378  C   GLU    57      13.441  -5.053  48.306  1.00 47.71          
ATOM    379  O   GLU    57      13.327  -6.260  48.438  1.00 48.16          
ATOM    380  CB  GLU    57      14.361  -3.712  50.117  1.00 49.17          
ATOM    381  CG  GLU    57      13.931  -4.714  51.180  1.00 50.98          
ATOM    382  CD  GLU    57      13.395  -4.031  52.437  1.00 52.75          
ATOM    383  OE1 GLU    57      13.203  -4.714  53.468  1.00 53.26          
ATOM    384  OE2 GLU    57      13.154  -2.807  52.382  1.00 54.01          
ATOM    385  N   GLU    58      12.502  -4.291  47.779  1.00 48.34          
ATOM    386  CA  GLU    58      11.257  -4.857  47.314  1.00 50.36          
ATOM    387  C   GLU    58      11.435  -5.758  46.103  1.00 51.67          
ATOM    388  O   GLU    58      10.605  -6.627  45.843  1.00 51.05          
ATOM    389  CB  GLU    58      10.276  -3.730  47.011  1.00 51.70          
ATOM    390  CG  GLU    58      10.044  -2.804  48.205  1.00 54.05          
ATOM    391  CD  GLU    58       9.059  -1.690  47.897  1.00 54.95          
ATOM    392  OE1 GLU    58       9.289  -0.952  46.911  1.00 53.56          
ATOM    393  OE2 GLU    58       8.062  -1.554  48.646  1.00 56.23          
ATOM    394  N   MET    59      12.522  -5.561  45.366  1.00 53.00          
ATOM    395  CA  MET    59      12.804  -6.374  44.179  1.00 54.52          
ATOM    396  C   MET    59      13.089  -7.828  44.530  1.00 54.25          
ATOM    397  O   MET    59      13.251  -8.662  43.641  1.00 54.07          
ATOM    398  CB  MET    59      14.009  -5.814  43.428  1.00 57.77          
ATOM    399  CG  MET    59      13.794  -4.457  42.799  1.00 62.25          
ATOM    400  SD  MET    59      15.363  -3.879  41.807  1.00 70.44          
ATOM    401  CE  MET    59      15.371  -1.998  42.290  1.00 67.49          
ATOM    402  N   GLU    60      13.163  -8.110  45.831  1.00 53.56          
ATOM    403  CA  GLU    60      13.433  -9.453  46.352  1.00 52.64          
ATOM    404  C   GLU    60      14.481 -10.251  45.585  1.00 50.43          
ATOM    405  O   GLU    60      14.318 -11.450  45.392  1.00 51.35          
ATOM    406  CB  GLU    60      12.135 -10.261  46.420  1.00 53.57          
ATOM    407  CG  GLU    60      11.354 -10.074  47.708  1.00 56.49          
ATOM    408  CD  GLU    60       9.894 -10.467  47.562  1.00 59.54          
ATOM    409  OE1 GLU    60       9.610 -11.476  46.869  1.00 60.10          
ATOM    410  OE2 GLU    60       9.029  -9.774  48.151  1.00 60.23          
ATOM    411  N   GLY    61      15.554  -9.601  45.154  1.00 48.05          
ATOM    412  CA  GLY    61      16.582 -10.330  44.443  1.00 46.22          
ATOM    413  C   GLY    61      16.423 -10.307  42.939  1.00 45.02          
ATOM    414  O   GLY    61      17.412 -10.296  42.208  1.00 46.21          
ATOM    415  N   ILE    62      15.189 -10.308  42.455  1.00 43.60          
ATOM    416  CA  ILE    62      14.969 -10.276  41.019  1.00 41.23          
ATOM    417  C   ILE    62      15.599  -9.022  40.419  1.00 40.65          
ATOM    418  O   ILE    62      15.292  -7.905  40.821  1.00 41.62          
ATOM    419  CB  ILE    62      13.479 -10.248  40.689  1.00 40.73          
ATOM    420  CG1 ILE    62      12.776 -11.464  41.306  1.00 38.20          
ATOM    421  CG2 ILE    62      13.306 -10.157  39.179  1.00 41.74          
ATOM    422  CD  ILE    62      13.258 -12.789  40.784  1.00 36.15          
ATOM    423  N   PRO    63      16.491  -9.190  39.442  1.00 40.13          
ATOM    424  CA  PRO    63      17.144  -8.041  38.805  1.00 40.32          
ATOM    425  C   PRO    63      16.221  -7.197  37.917  1.00 39.75          
ATOM    426  O   PRO    63      15.509  -7.736  37.073  1.00 39.18          
ATOM    427  CB  PRO    63      18.277  -8.694  38.008  1.00 40.21          
ATOM    428  CG  PRO    63      17.715 -10.036  37.661  1.00 39.66          
ATOM    429  CD  PRO    63      17.070 -10.455  38.959  1.00 40.22          
ATOM    430  N   HSD    64      16.235  -5.877  38.115  1.00 39.80          
ATOM    431  CA  HSD    64      15.404  -4.971  37.322  1.00 40.76          
ATOM    432  C   HSD    64      16.240  -4.041  36.409  1.00 42.95          
ATOM    433  O   HSD    64      17.318  -3.576  36.786  1.00 41.97          
ATOM    434  CB  HSD    64      14.493  -4.123  38.232  1.00 37.92          
ATOM    435  CG  HSD    64      13.430  -4.905  38.944  1.00 36.17          
ATOM    436  ND1 HSD    64      12.239  -4.340  39.346  1.00 36.89          
ATOM    437  CD2 HSD    64      13.383  -6.196  39.354  1.00 35.64          
ATOM    438  CE1 HSD    64      11.505  -5.244  39.969  1.00 35.10          
ATOM    439  NE2 HSD    64      12.177  -6.380  39.986  1.00 33.58          
ATOM    440  N   TYR    65      15.734  -3.786  35.201  1.00 44.46          
ATOM    441  CA  TYR    65      16.416  -2.924  34.246  1.00 46.92          
ATOM    442  C   TYR    65      15.558  -1.722  33.913  1.00 48.79          
ATOM    443  O   TYR    65      14.356  -1.716  34.197  1.00 48.51          
ATOM    444  CB  TYR    65      16.734  -3.679  32.956  1.00 46.24          
ATOM    445  CG  TYR    65      17.495  -4.956  33.189  1.00 46.04          
ATOM    446  CD1 TYR    65      16.839  -6.181  33.203  1.00 45.12          
ATOM    447  CD2 TYR    65      18.876  -4.940  33.421  1.00 46.83          
ATOM    448  CE1 TYR    65      17.538  -7.365  33.439  1.00 45.27          
ATOM    449  CE2 TYR    65      19.587  -6.118  33.664  1.00 44.91          
ATOM    450  CZ  TYR    65      18.915  -7.324  33.666  1.00 44.46          
ATOM    451  OH  TYR    65      19.618  -8.485  33.861  1.00 42.99          
ATOM    452  N   MET    66      16.180  -0.709  33.310  1.00 50.14          
ATOM    453  CA  MET    66      15.474   0.511  32.938  1.00 52.49          
ATOM    454  C   MET    66      15.065   1.366  34.144  1.00 51.53          
ATOM    455  O   MET    66      14.097   2.124  34.068  1.00 50.60          
ATOM    456  CB  MET    66      14.225   0.152  32.137  1.00 57.56          
ATOM    457  CG  MET    66      14.507  -0.541  30.808  1.00 65.45          
ATOM    458  SD  MET    66      15.334   0.620  29.477  1.00 71.33          
ATOM    459  CE  MET    66      13.820   1.809  29.184  1.00 69.78          
ATOM    460  N   ILE    67      15.790   1.237  35.256  1.00 50.85          
ATOM    461  CA  ILE    67      15.494   2.005  36.472  1.00 49.39          
ATOM    462  C   ILE    67      16.742   2.762  36.944  1.00 48.87          
ATOM    463  O   ILE    67      17.774   2.150  37.219  1.00 49.58          
ATOM    464  CB  ILE    67      14.973   1.076  37.606  1.00 48.43          
ATOM    465  CG1 ILE    67      13.742   0.313  37.121  1.00 47.01          
ATOM    466  CG2 ILE    67      14.617   1.897  38.840  1.00 47.68          
ATOM    467  CD  ILE    67      13.258  -0.716  38.065  1.00 46.08          
ATOM    468  N   ASP    68      16.639   4.090  37.028  1.00 47.81          
ATOM    469  CA  ASP    68      17.760   4.942  37.434  1.00 47.06          
ATOM    470  C   ASP    68      18.911   4.812  36.444  1.00 46.44          
ATOM    471  O   ASP    68      20.064   4.604  36.838  1.00 46.29          
ATOM    472  CB  ASP    68      18.277   4.568  38.826  1.00 48.04          
ATOM    473  CG  ASP    68      17.305   4.924  39.929  1.00 49.01          
ATOM    474  OD1 ASP    68      16.806   6.072  39.939  1.00 51.42          
ATOM    475  OD2 ASP    68      17.052   4.068  40.799  1.00 48.86          
ATOM    476  N   ILE    69      18.599   4.922  35.158  1.00 44.44          
ATOM    477  CA  ILE    69      19.616   4.812  34.129  1.00 42.98          
ATOM    478  C   ILE    69      19.953   6.161  33.496  1.00 42.60          
ATOM    479  O   ILE    69      20.851   6.252  32.664  1.00 42.00          
ATOM    480  CB  ILE    69      19.170   3.854  33.018  1.00 43.70          
ATOM    481  CG1 ILE    69      17.845   4.328  32.414  1.00 43.50          
ATOM    482  CG2 ILE    69      19.052   2.449  33.565  1.00 44.67          
ATOM    483  CD  ILE    69      17.404   3.536  31.203  1.00 42.90          
ATOM    484  N   LEU    70      19.245   7.212  33.902  1.00 42.59          
ATOM    485  CA  LEU    70      19.486   8.549  33.359  1.00 40.82          
ATOM    486  C   LEU    70      19.250   9.633  34.407  1.00 41.05          
ATOM    487  O   LEU    70      18.577   9.405  35.398  1.00 41.88          
ATOM    488  CB  LEU    70      18.548   8.791  32.171  1.00 39.27          
ATOM    489  CG  LEU    70      18.589   7.800  31.020  1.00 36.21          
ATOM    490  CD1 LEU    70      17.340   7.949  30.200  1.00 36.04          
ATOM    491  CD2 LEU    70      19.824   8.038  30.194  1.00 34.44          
ATOM    492  N   PRO    71      19.835  10.825  34.214  1.00 43.24          
ATOM    493  CA  PRO    71      19.650  11.934  35.154  1.00 41.06          
ATOM    494  C   PRO    71      18.362  12.638  34.725  1.00 42.77          
ATOM    495  O   PRO    71      17.904  12.457  33.605  1.00 42.17          
ATOM    496  CB  PRO    71      20.879  12.792  34.919  1.00 42.02          
ATOM    497  CG  PRO    71      21.065  12.653  33.448  1.00 41.82          
ATOM    498  CD  PRO    71      20.887  11.154  33.242  1.00 42.37          
ATOM    499  N   PRO    72      17.770  13.460  35.603  1.00 46.11          
ATOM    500  CA  PRO    72      16.522  14.173  35.299  1.00 45.97          
ATOM    501  C   PRO    72      16.497  14.962  33.990  1.00 48.27          
ATOM    502  O   PRO    72      15.500  14.933  33.254  1.00 49.06          
ATOM    503  CB  PRO    72      16.327  15.057  36.521  1.00 45.64          
ATOM    504  CG  PRO    72      16.892  14.201  37.619  1.00 45.86          
ATOM    505  CD  PRO    72      18.180  13.706  36.995  1.00 45.76          
ATOM    506  N   ASP    73      17.593  15.659  33.693  1.00 50.27          
ATOM    507  CA  ASP    73      17.710  16.484  32.476  1.00 50.11          
ATOM    508  C   ASP    73      17.880  15.666  31.197  1.00 50.04          
ATOM    509  O   ASP    73      17.918  16.220  30.087  1.00 51.02          
ATOM    510  CB  ASP    73      18.889  17.460  32.625  1.00 52.01          
ATOM    511  CG  ASP    73      20.224  16.746  32.837  1.00 54.57          
ATOM    512  OD1 ASP    73      20.667  16.017  31.911  1.00 55.67          
ATOM    513  OD2 ASP    73      20.834  16.922  33.921  1.00 53.87          
ATOM    514  N   ALA    74      17.997  14.350  31.356  1.00 48.21          
ATOM    515  CA  ALA    74      18.159  13.464  30.210  1.00 45.93          
ATOM    516  C   ALA    74      16.842  13.337  29.472  1.00 44.07          
ATOM    517  O   ALA    74      15.780  13.627  30.015  1.00 41.10          
ATOM    518  CB  ALA    74      18.645  12.094  30.668  1.00 46.53          
ATOM    519  N   SER    75      16.921  12.893  28.229  1.00 44.15          
ATOM    520  CA  SER    75      15.727  12.747  27.425  1.00 44.33          
ATOM    521  C   SER    75      15.354  11.285  27.232  1.00 42.90          
ATOM    522  O   SER    75      16.217  10.409  27.187  1.00 42.46          
ATOM    523  CB  SER    75      15.932  13.425  26.073  1.00 45.22          
ATOM    524  OG  SER    75      14.852  13.131  25.206  1.00 48.08          
ATOM    525  N   PHE    76      14.058  11.028  27.128  1.00 42.25          
ATOM    526  CA  PHE    76      13.589   9.677  26.939  1.00 42.63          
ATOM    527  C   PHE    76      12.435   9.680  25.950  1.00 44.28          
ATOM    528  O   PHE    76      11.843  10.731  25.681  1.00 44.93          
ATOM    529  CB  PHE    76      13.158   9.080  28.272  1.00 41.10          
ATOM    530  CG  PHE    76      13.230   7.592  28.304  1.00 40.73          
ATOM    531  CD1 PHE    76      14.438   6.943  28.082  1.00 40.57          
ATOM    532  CD2 PHE    76      12.091   6.830  28.513  1.00 40.81          
ATOM    533  CE1 PHE    76      14.515   5.548  28.069  1.00 40.33          
ATOM    534  CE2 PHE    76      12.157   5.431  28.503  1.00 40.80          
ATOM    535  CZ  PHE    76      13.375   4.793  28.276  1.00 39.45          
ATOM    536  N   SER    77      12.112   8.506  25.413  1.00 44.42          
ATOM    537  CA  SER    77      11.050   8.409  24.423  1.00 44.38          
ATOM    538  C   SER    77      10.626   6.972  24.168  1.00 44.19          
ATOM    539  O   SER    77      11.321   6.029  24.532  1.00 43.90          
ATOM    540  CB  SER    77      11.537   8.990  23.107  1.00 45.47          
ATOM    541  OG  SER    77      12.572   8.162  22.578  1.00 47.33          
ATOM    542  N   ALA    78       9.481   6.813  23.521  1.00 42.68          
ATOM    543  CA  ALA    78       8.996   5.488  23.212  1.00 42.21          
ATOM    544  C   ALA    78      10.066   4.637  22.487  1.00 43.10          
ATOM    545  O   ALA    78      10.303   3.504  22.882  1.00 42.31          
ATOM    546  CB  ALA    78       7.714   5.577  22.377  1.00 41.89          
ATOM    547  N   TYR    79      10.724   5.159  21.448  1.00 44.68          
ATOM    548  CA  TYR    79      11.728   4.350  20.756  1.00 46.27          
ATOM    549  C   TYR    79      12.962   4.134  21.609  1.00 44.55          
ATOM    550  O   TYR    79      13.531   3.041  21.616  1.00 43.90          
ATOM    551  CB  TYR    79      12.148   4.962  19.403  1.00 52.71          
ATOM    552  CG  TYR    79      13.289   4.209  18.700  1.00 58.76          
ATOM    553  CD1 TYR    79      14.585   4.755  18.646  1.00 61.33          
ATOM    554  CD2 TYR    79      13.085   2.935  18.131  1.00 60.40          
ATOM    555  CE1 TYR    79      15.655   4.053  18.050  1.00 63.02          
ATOM    556  CE2 TYR    79      14.152   2.218  17.531  1.00 62.10          
ATOM    557  CZ  TYR    79      15.431   2.784  17.497  1.00 63.41          
ATOM    558  OH  TYR    79      16.489   2.099  16.917  1.00 62.92          
ATOM    559  N   GLU    80      13.384   5.165  22.327  1.00 42.75          
ATOM    560  CA  GLU    80      14.558   5.030  23.179  1.00 41.93          
ATOM    561  C   GLU    80      14.369   3.772  24.037  1.00 40.72          
ATOM    562  O   GLU    80      15.285   2.960  24.174  1.00 41.10          
ATOM    563  CB  GLU    80      14.726   6.288  24.053  1.00 41.99          
ATOM    564  CG  GLU    80      15.937   6.271  24.984  1.00 43.40          
ATOM    565  CD  GLU    80      17.244   5.907  24.289  1.00 44.68          
ATOM    566  OE1 GLU    80      18.281   5.855  24.990  1.00 44.88          
ATOM    567  OE2 GLU    80      17.247   5.676  23.057  1.00 44.63          
ATOM    568  N   PHE    81      13.158   3.609  24.570  1.00 38.87          
ATOM    569  CA  PHE    81      12.781   2.465  25.407  1.00 36.19          
ATOM    570  C   PHE    81      12.849   1.170  24.596  1.00 36.54          
ATOM    571  O   PHE    81      13.312   0.137  25.086  1.00 35.85          
ATOM    572  CB  PHE    81      11.357   2.689  25.962  1.00 33.12          
ATOM    573  CG  PHE    81      10.681   1.435  26.465  1.00 30.51          
ATOM    574  CD1 PHE    81      11.210   0.717  27.524  1.00 29.09          
ATOM    575  CD2 PHE    81       9.528   0.957  25.850  1.00 30.08          
ATOM    576  CE1 PHE    81      10.613  -0.454  27.955  1.00 28.28          
ATOM    577  CE2 PHE    81       8.925  -0.218  26.280  1.00 28.60          
ATOM    578  CZ  PHE    81       9.470  -0.921  27.330  1.00 27.92          
ATOM    579  N   LYS    82      12.394   1.239  23.347  1.00 37.42          
ATOM    580  CA  LYS    82      12.392   0.079  22.453  1.00 38.62          
ATOM    581  C   LYS    82      13.807  -0.407  22.131  1.00 38.47          
ATOM    582  O   LYS    82      14.089  -1.606  22.162  1.00 36.19          
ATOM    583  CB  LYS    82      11.656   0.420  21.148  1.00 39.34          
ATOM    584  CG  LYS    82      11.549  -0.733  20.172  1.00 38.40          
ATOM    585  CD  LYS    82      10.907  -0.297  18.874  1.00 39.39          
ATOM    586  CE  LYS    82      10.964  -1.429  17.858  1.00 41.17          
ATOM    587  NZ  LYS    82       9.977  -1.274  16.742  1.00 42.70          
ATOM    588  N   LYS    83      14.690   0.535  21.822  1.00 39.75          
ATOM    589  CA  LYS    83      16.067   0.201  21.496  1.00 40.53          
ATOM    590  C   LYS    83      16.724  -0.543  22.648  1.00 40.76          
ATOM    591  O   LYS    83      17.320  -1.608  22.444  1.00 41.80          
ATOM    592  CB  LYS    83      16.863   1.470  21.177  1.00 40.74          
ATOM    593  CG  LYS    83      18.312   1.194  20.853  1.00 42.46          
ATOM    594  CD  LYS    83      19.071   2.446  20.455  1.00 45.99          
ATOM    595  CE  LYS    83      20.459   2.070  19.928  1.00 48.24          
ATOM    596  NZ  LYS    83      21.259   3.243  19.463  1.00 50.23          
ATOM    597  N   ARG    84      16.607   0.020  23.856  1.00 40.35          
ATOM    598  CA  ARG    84      17.190  -0.572  25.084  1.00 39.35          
ATOM    599  C   ARG    84      16.484  -1.854  25.530  1.00 37.92          
ATOM    600  O   ARG    84      17.133  -2.806  25.954  1.00 36.85          
ATOM    601  CB  ARG    84      17.156   0.429  26.250  1.00 36.67          
ATOM    602  CG  ARG    84      17.859   1.728  25.980  1.00 36.15          
ATOM    603  CD  ARG    84      18.054   2.528  27.259  1.00 38.44          
ATOM    604  NE  ARG    84      18.593   3.855  26.966  1.00 40.06          
ATOM    605  CZ  ARG    84      19.648   4.396  27.567  1.00 40.78          
ATOM    606  NH1 ARG    84      20.299   3.728  28.515  1.00 40.28          
ATOM    607  NH2 ARG    84      20.058   5.606  27.202  1.00 41.15          
ATOM    608  N   ALA    85      15.158  -1.862  25.438  1.00 37.30          
ATOM    609  CA  ALA    85      14.393  -3.027  25.822  1.00 38.07          
ATOM    610  C   ALA    85      14.677  -4.226  24.905  1.00 38.96          
ATOM    611  O   ALA    85      14.838  -5.338  25.393  1.00 38.84          
ATOM    612  CB  ALA    85      12.906  -2.698  25.837  1.00 37.62          
ATOM    613  N   GLU    86      14.755  -4.012  23.590  1.00 40.01          
ATOM    614  CA  GLU    86      15.020  -5.119  22.663  1.00 40.70          
ATOM    615  C   GLU    86      16.344  -5.794  22.966  1.00 39.19          
ATOM    616  O   GLU    86      16.460  -7.009  22.858  1.00 37.95          
ATOM    617  CB  GLU    86      15.035  -4.644  21.199  1.00 43.09          
ATOM    618  CG  GLU    86      13.732  -4.026  20.702  1.00 48.93          
ATOM    619  CD  GLU    86      13.759  -3.649  19.220  1.00 52.55          
ATOM    620  OE1 GLU    86      13.735  -4.566  18.368  1.00 56.38          
ATOM    621  OE2 GLU    86      13.814  -2.435  18.898  1.00 54.39          
ATOM    622  N   LYS    87      17.346  -5.012  23.343  1.00 38.58          
ATOM    623  CA  LYS    87      18.640  -5.592  23.648  1.00 38.74          
ATOM    624  C   LYS    87      18.535  -6.451  24.909  1.00 37.94          
ATOM    625  O   LYS    87      18.982  -7.593  24.913  1.00 37.92          
ATOM    626  CB  LYS    87      19.692  -4.489  23.821  1.00 40.10          
ATOM    627  CG  LYS    87      19.922  -3.647  22.563  1.00 40.60          
ATOM    628  CD  LYS    87      20.746  -2.395  22.866  1.00 42.69          
ATOM    629  CE  LYS    87      20.904  -1.490  21.628  1.00 42.87          
ATOM    630  NZ  LYS    87      21.492  -0.138  21.934  1.00 39.82          
ATOM    631  N   TYR    88      17.925  -5.910  25.962  1.00 36.95          
ATOM    632  CA  TYR    88      17.762  -6.644  27.214  1.00 37.15          
ATOM    633  C   TYR    88      16.916  -7.913  27.029  1.00 37.80          
ATOM    634  O   TYR    88      17.218  -8.973  27.580  1.00 37.94          
ATOM    635  CB  TYR    88      17.124  -5.756  28.295  1.00 37.25          
ATOM    636  CG  TYR    88      18.036  -4.700  28.910  1.00 39.23          
ATOM    637  CD1 TYR    88      17.783  -3.333  28.719  1.00 41.10          
ATOM    638  CD2 TYR    88      19.113  -5.059  29.734  1.00 38.28          
ATOM    639  CE1 TYR    88      18.568  -2.351  29.335  1.00 41.52          
ATOM    640  CE2 TYR    88      19.908  -4.081  30.358  1.00 38.86          
ATOM    641  CZ  TYR    88      19.626  -2.732  30.153  1.00 41.28          
ATOM    642  OH  TYR    88      20.390  -1.755  30.754  1.00 40.69          
ATOM    643  N   ILE    89      15.853  -7.815  26.250  1.00 37.05          
ATOM    644  CA  ILE    89      15.015  -8.973  26.022  1.00 36.98          
ATOM    645  C   ILE    89      15.820 -10.109  25.369  1.00 37.79          
ATOM    646  O   ILE    89      15.541 -11.282  25.617  1.00 37.75          
ATOM    647  CB  ILE    89      13.792  -8.608  25.139  1.00 35.57          
ATOM    648  CG1 ILE    89      12.904  -7.602  25.886  1.00 33.73          
ATOM    649  CG2 ILE    89      13.017  -9.859  24.777  1.00 33.51          
ATOM    650  CD  ILE    89      11.739  -7.066  25.077  1.00 30.08          
ATOM    651  N   LYS    90      16.806  -9.776  24.533  1.00 38.00          
ATOM    652  CA  LYS    90      17.631 -10.807  23.886  1.00 38.01          
ATOM    653  C   LYS    90      18.670 -11.334  24.868  1.00 38.13          
ATOM    654  O   LYS    90      18.861 -12.542  24.992  1.00 37.33          
ATOM    655  CB  LYS    90      18.349 -10.258  22.639  1.00 39.66          
ATOM    656  CG  LYS    90      17.608 -10.447  21.296  1.00 40.93          
ATOM    657  CD  LYS    90      18.408  -9.912  20.066  1.00 41.15          
ATOM    658  CE  LYS    90      18.564  -8.369  20.076  1.00 42.47          
ATOM    659  NZ  LYS    90      19.370  -7.772  18.962  1.00 39.46          
ATOM    660  N   ASP    91      19.342 -10.428  25.565  1.00 37.73          
ATOM    661  CA  ASP    91      20.350 -10.837  26.521  1.00 38.39          
ATOM    662  C   ASP    91      19.727 -11.783  27.541  1.00 38.89          
ATOM    663  O   ASP    91      20.293 -12.821  27.849  1.00 39.41          
ATOM    664  CB  ASP    91      20.930  -9.613  27.221  1.00 39.76          
ATOM    665  CG  ASP    91      22.095  -9.957  28.110  1.00 40.54          
ATOM    666  OD1 ASP    91      23.143 -10.368  27.568  1.00 41.54          
ATOM    667  OD2 ASP    91      21.961  -9.820  29.341  1.00 39.83          
ATOM    668  N   ILE    92      18.553 -11.418  28.052  1.00 38.96          
ATOM    669  CA  ILE    92      17.828 -12.232  29.034  1.00 39.57          
ATOM    670  C   ILE    92      17.530 -13.640  28.495  1.00 40.37          
ATOM    671  O   ILE    92      17.873 -14.645  29.131  1.00 41.32          
ATOM    672  CB  ILE    92      16.481 -11.547  29.448  1.00 38.05          
ATOM    673  CG1 ILE    92      16.772 -10.233  30.174  1.00 38.15          
ATOM    674  CG2 ILE    92      15.653 -12.464  30.338  1.00 36.72          
ATOM    675  CD  ILE    92      15.537  -9.460  30.585  1.00 35.07          
ATOM    676  N   THR    93      16.896 -13.717  27.326  1.00 40.55          
ATOM    677  CA  THR    93      16.551 -15.012  26.745  1.00 39.43          
ATOM    678  C   THR    93      17.799 -15.812  26.487  1.00 38.37          
ATOM    679  O   THR    93      17.805 -17.030  26.638  1.00 37.61          
ATOM    680  CB  THR    93      15.849 -14.890  25.379  1.00 40.05          
ATOM    681  OG1 THR    93      14.887 -13.822  25.391  1.00 40.47          
ATOM    682  CG2 THR    93      15.152 -16.199  25.048  1.00 38.13          
ATOM    683  N   ARG    94      18.851 -15.102  26.091  1.00 38.34          
ATOM    684  CA  ARG    94      20.141 -15.708  25.766  1.00 38.82          
ATOM    685  C   ARG    94      20.741 -16.429  26.954  1.00 37.58          
ATOM    686  O   ARG    94      21.525 -17.358  26.788  1.00 37.56          
ATOM    687  CB  ARG    94      21.106 -14.625  25.251  1.00 39.26          
ATOM    688  CG  ARG    94      22.336 -15.144  24.519  1.00 39.09          
ATOM    689  CD  ARG    94      23.214 -13.978  24.047  1.00 39.93          
ATOM    690  NE  ARG    94      23.583 -13.091  25.149  1.00 43.31          
ATOM    691  CZ  ARG    94      24.223 -13.484  26.250  1.00 44.23          
ATOM    692  NH1 ARG    94      24.509 -12.604  27.209  1.00 45.12          
ATOM    693  NH2 ARG    94      24.578 -14.756  26.396  1.00 44.13          
ATOM    694  N   ARG    95      20.374 -15.999  28.152  1.00 38.15          
ATOM    695  CA  ARG    95      20.890 -16.641  29.355  1.00 39.17          
ATOM    696  C   ARG    95      19.842 -17.586  29.935  1.00 40.16          
ATOM    697  O   ARG    95      19.773 -17.807  31.148  1.00 40.51          
ATOM    698  CB  ARG    95      21.312 -15.597  30.384  1.00 39.03          
ATOM    699  CG  ARG    95      22.321 -14.600  29.835  1.00 40.05          
ATOM    700  CD  ARG    95      22.995 -13.810  30.936  1.00 42.08          
ATOM    701  NE  ARG    95      22.028 -13.214  31.869  1.00 44.60          
ATOM    702  CZ  ARG    95      21.082 -12.352  31.516  1.00 45.39          
ATOM    703  NH1 ARG    95      20.262 -11.869  32.426  1.00 45.54          
ATOM    704  NH2 ARG    95      20.957 -11.974  30.249  1.00 47.84          
ATOM    705  N   GLY    96      19.024 -18.134  29.035  1.00 41.04          
ATOM    706  CA  GLY    96      17.982 -19.081  29.403  1.00 41.01          
ATOM    707  C   GLY    96      16.998 -18.627  30.459  1.00 41.51          
ATOM    708  O   GLY    96      16.566 -19.424  31.286  1.00 41.53          
ATOM    709  N   LYS    97      16.644 -17.350  30.443  1.00 41.90          
ATOM    710  CA  LYS    97      15.692 -16.832  31.419  1.00 42.49          
ATOM    711  C   LYS    97      14.426 -16.318  30.727  1.00 41.53          
ATOM    712  O   LYS    97      14.305 -16.363  29.498  1.00 42.10          
ATOM    713  CB  LYS    97      16.334 -15.716  32.252  1.00 43.46          
ATOM    714  CG  LYS    97      17.166 -16.206  33.436  1.00 45.45          
ATOM    715  CD  LYS    97      17.908 -15.050  34.122  1.00 48.34          
ATOM    716  CE  LYS    97      18.004 -15.240  35.662  1.00 50.04          
ATOM    717  NZ  LYS    97      18.682 -16.515  36.088  1.00 48.07          
ATOM    718  N   VAL    98      13.483 -15.833  31.524  1.00 38.99          
ATOM    719  CA  VAL    98      12.230 -15.338  30.989  1.00 36.53          
ATOM    720  C   VAL    98      12.110 -13.838  31.071  1.00 37.14          
ATOM    721  O   VAL    98      11.898 -13.280  32.152  1.00 36.62          
ATOM    722  CB  VAL    98      11.041 -15.936  31.733  1.00 35.74          
ATOM    723  CG1 VAL    98       9.748 -15.385  31.159  1.00 34.97          
ATOM    724  CG2 VAL    98      11.084 -17.440  31.629  1.00 34.69          
ATOM    725  N   PRO    99      12.236 -13.158  29.924  1.00 36.43          
ATOM    726  CA  PRO    99      12.133 -11.702  29.880  1.00 35.92          
ATOM    727  C   PRO    99      10.707 -11.243  30.242  1.00 36.90          
ATOM    728  O   PRO    99       9.723 -11.657  29.609  1.00 36.32          
ATOM    729  CB  PRO    99      12.510 -11.383  28.444  1.00 35.09          
ATOM    730  CG  PRO    99      11.952 -12.549  27.710  1.00 35.11          
ATOM    731  CD  PRO    99      12.350 -13.717  28.570  1.00 35.83          
ATOM    732  N   ILE   100      10.609 -10.378  31.256  1.00 35.85          
ATOM    733  CA  ILE   100       9.324  -9.866  31.746  1.00 34.09          
ATOM    734  C   ILE   100       9.369  -8.347  31.820  1.00 34.92          
ATOM    735  O   ILE   100      10.280  -7.778  32.418  1.00 35.54          
ATOM    736  CB  ILE   100       9.038 -10.371  33.182  1.00 33.56          
ATOM    737  CG1 ILE   100       9.218 -11.888  33.261  1.00 33.93          
ATOM    738  CG2 ILE   100       7.648 -10.007  33.583  1.00 30.85          
ATOM    739  CD  ILE   100       9.497 -12.376  34.658  1.00 33.77          
ATOM    740  N   ILE   101       8.394  -7.688  31.213  1.00 35.33          
ATOM    741  CA  ILE   101       8.345  -6.238  31.279  1.00 35.38          
ATOM    742  C   ILE   101       7.166  -5.844  32.173  1.00 35.55          
ATOM    743  O   ILE   101       6.032  -6.270  31.972  1.00 34.79          
ATOM    744  CB  ILE   101       8.215  -5.592  29.879  1.00 34.99          
ATOM    745  CG1 ILE   101       7.036  -6.192  29.133  1.00 36.58          
ATOM    746  CG2 ILE   101       9.498  -5.807  29.099  1.00 34.45          
ATOM    747  CD  ILE   101       6.915  -5.691  27.723  1.00 39.07          
ATOM    748  N   ALA   102       7.478  -5.049  33.189  1.00 35.59          
ATOM    749  CA  ALA   102       6.510  -4.580  34.147  1.00 34.62          
ATOM    750  C   ALA   102       6.215  -3.135  33.837  1.00 36.25          
ATOM    751  O   ALA   102       7.129  -2.337  33.607  1.00 36.56          
ATOM    752  CB  ALA   102       7.066  -4.700  35.535  1.00 31.84          
ATOM    753  N   GLY   103       4.928  -2.806  33.808  1.00 36.86          
ATOM    754  CA  GLY   103       4.514  -1.438  33.547  1.00 34.82          
ATOM    755  C   GLY   103       4.605  -1.026  32.101  1.00 34.11          
ATOM    756  O   GLY   103       4.742  -1.863  31.211  1.00 34.68          
ATOM    757  N   GLY   104       4.527   0.282  31.880  1.00 34.21          
ATOM    758  CA  GLY   104       4.591   0.823  30.538  1.00 32.64          
ATOM    759  C   GLY   104       3.248   1.377  30.095  1.00 32.24          
ATOM    760  O   GLY   104       2.210   0.989  30.619  1.00 30.34          
ATOM    761  N   THR   105       3.271   2.290  29.129  1.00 34.02          
ATOM    762  CA  THR   105       2.050   2.892  28.604  1.00 36.46          
ATOM    763  C   THR   105       1.713   2.289  27.233  1.00 37.92          
ATOM    764  O   THR   105       2.510   1.540  26.673  1.00 39.04          
ATOM    765  CB  THR   105       2.202   4.430  28.452  1.00 35.92          
ATOM    766  OG1 THR   105       3.371   4.736  27.677  1.00 35.55          
ATOM    767  CG2 THR   105       2.293   5.096  29.818  1.00 36.82          
ATOM    768  N   GLY   106       0.540   2.619  26.698  1.00 38.11          
ATOM    769  CA  GLY   106       0.146   2.102  25.400  1.00 37.56          
ATOM    770  C   GLY   106       1.221   2.304  24.344  1.00 37.63          
ATOM    771  O   GLY   106       1.659   1.346  23.714  1.00 35.90          
ATOM    772  N   LEU   107       1.653   3.544  24.140  1.00 38.20          
ATOM    773  CA  LEU   107       2.685   3.791  23.151  1.00 39.43          
ATOM    774  C   LEU   107       3.891   2.894  23.389  1.00 39.89          
ATOM    775  O   LEU   107       4.174   2.017  22.579  1.00 41.10          
ATOM    776  CB  LEU   107       3.131   5.252  23.168  1.00 41.15          
ATOM    777  CG  LEU   107       2.421   6.254  22.244  1.00 41.69          
ATOM    778  CD1 LEU   107       2.941   7.651  22.577  1.00 42.07          
ATOM    779  CD2 LEU   107       2.684   5.922  20.777  1.00 41.61          
ATOM    780  N   TYR   108       4.583   3.096  24.509  1.00 39.43          
ATOM    781  CA  TYR   108       5.766   2.308  24.847  1.00 38.14          
ATOM    782  C   TYR   108       5.590   0.811  24.689  1.00 37.73          
ATOM    783  O   TYR   108       6.523   0.120  24.310  1.00 37.59          
ATOM    784  CB  TYR   108       6.209   2.586  26.283  1.00 40.80          
ATOM    785  CG  TYR   108       6.759   3.969  26.516  1.00 43.04          
ATOM    786  CD1 TYR   108       8.091   4.149  26.882  1.00 42.95          
ATOM    787  CD2 TYR   108       5.943   5.101  26.371  1.00 44.06          
ATOM    788  CE1 TYR   108       8.609   5.421  27.098  1.00 45.65          
ATOM    789  CE2 TYR   108       6.446   6.384  26.583  1.00 46.23          
ATOM    790  CZ  TYR   108       7.788   6.536  26.947  1.00 47.17          
ATOM    791  OH  TYR   108       8.307   7.800  27.154  1.00 48.96          
ATOM    792  N   ILE   109       4.403   0.303  24.987  1.00 38.17          
ATOM    793  CA  ILE   109       4.185  -1.120  24.881  1.00 39.47          
ATOM    794  C   ILE   109       3.935  -1.613  23.469  1.00 40.68          
ATOM    795  O   ILE   109       4.524  -2.605  23.053  1.00 42.01          
ATOM    796  CB  ILE   109       3.038  -1.567  25.781  1.00 39.28          
ATOM    797  CG1 ILE   109       3.376  -1.240  27.225  1.00 41.80          
ATOM    798  CG2 ILE   109       2.815  -3.062  25.646  1.00 39.71          
ATOM    799  CD  ILE   109       4.689  -1.861  27.711  1.00 43.04          
ATOM    800  N   GLN   110       3.070  -0.944  22.718  1.00 41.74          
ATOM    801  CA  GLN   110       2.827  -1.410  21.365  1.00 42.65          
ATOM    802  C   GLN   110       4.045  -1.161  20.478  1.00 42.85          
ATOM    803  O   GLN   110       4.395  -1.985  19.624  1.00 43.03          
ATOM    804  CB  GLN   110       1.574  -0.757  20.759  1.00 43.38          
ATOM    805  CG  GLN   110       1.751   0.625  20.174  1.00 43.67          
ATOM    806  CD  GLN   110       0.605   0.995  19.236  1.00 44.36          
ATOM    807  OE1 GLN   110       0.534   2.121  18.741  1.00 44.31          
ATOM    808  NE2 GLN   110      -0.294   0.039  18.983  1.00 43.98          
ATOM    809  N   SER   111       4.712  -0.038  20.695  1.00 42.96          
ATOM    810  CA  SER   111       5.890   0.292  19.900  1.00 43.29          
ATOM    811  C   SER   111       6.911  -0.835  20.019  1.00 43.63          
ATOM    812  O   SER   111       7.658  -1.120  19.081  1.00 43.24          
ATOM    813  CB  SER   111       6.490   1.620  20.382  1.00 41.83          
ATOM    814  OG  SER   111       5.519   2.653  20.359  1.00 38.04          
ATOM    815  N   LEU   112       6.910  -1.484  21.179  1.00 42.94          
ATOM    816  CA  LEU   112       7.820  -2.589  21.466  1.00 43.24          
ATOM    817  C   LEU   112       7.305  -3.932  20.984  1.00 42.84          
ATOM    818  O   LEU   112       8.084  -4.826  20.664  1.00 43.39          
ATOM    819  CB  LEU   112       8.073  -2.679  22.980  1.00 42.95          
ATOM    820  CG  LEU   112       8.738  -3.944  23.539  1.00 41.60          
ATOM    821  CD1 LEU   112      10.130  -4.145  22.941  1.00 40.14          
ATOM    822  CD2 LEU   112       8.806  -3.824  25.042  1.00 40.07          
ATOM    823  N   LEU   113       5.991  -4.079  20.943  1.00 42.94          
ATOM    824  CA  LEU   113       5.404  -5.342  20.529  1.00 43.87          
ATOM    825  C   LEU   113       5.256  -5.507  19.022  1.00 43.65          
ATOM    826  O   LEU   113       5.468  -6.595  18.492  1.00 43.18          
ATOM    827  CB  LEU   113       4.040  -5.520  21.201  1.00 44.22          
ATOM    828  CG  LEU   113       4.098  -5.537  22.733  1.00 45.40          
ATOM    829  CD1 LEU   113       2.696  -5.608  23.294  1.00 45.75          
ATOM    830  CD2 LEU   113       4.926  -6.726  23.201  1.00 45.87          
ATOM    831  N   TYR   114       4.929  -4.421  18.335  1.00 43.62          
ATOM    832  CA  TYR   114       4.706  -4.469  16.899  1.00 43.89          
ATOM    833  C   TYR   114       5.617  -3.561  16.106  1.00 45.49          
ATOM    834  O   TYR   114       5.993  -2.496  16.576  1.00 47.98          
ATOM    835  CB  TYR   114       3.260  -4.078  16.614  1.00 43.38          
ATOM    836  CG  TYR   114       2.270  -4.789  17.502  1.00 40.83          
ATOM    837  CD1 TYR   114       2.213  -6.172  17.514  1.00 39.48          
ATOM    838  CD2 TYR   114       1.400  -4.079  18.333  1.00 40.02          
ATOM    839  CE1 TYR   114       1.327  -6.844  18.322  1.00 40.57          
ATOM    840  CE2 TYR   114       0.495  -4.743  19.155  1.00 40.05          
ATOM    841  CZ  TYR   114       0.471  -6.140  19.138  1.00 40.06          
ATOM    842  OH  TYR   114      -0.394  -6.860  19.917  1.00 39.18          
ATOM    843  N   ASN   115       5.955  -3.974  14.892  1.00 47.91          
ATOM    844  CA  ASN   115       6.802  -3.165  14.034  1.00 49.56          
ATOM    845  C   ASN   115       6.010  -2.369  13.028  1.00 50.49          
ATOM    846  O   ASN   115       6.268  -2.476  11.836  1.00 50.90          
ATOM    847  CB  ASN   115       7.765  -4.042  13.268  1.00 49.54          
ATOM    848  CG  ASN   115       9.037  -4.256  13.998  1.00 51.39          
ATOM    849  OD1 ASN   115       9.954  -4.869  13.468  1.00 52.45          
ATOM    850  ND2 ASN   115       9.117  -3.749  15.233  1.00 52.07          
ATOM   1490  N   GLU   194       4.232  -8.569  14.796  1.00 47.75          
ATOM   1491  CA  GLU   194       4.617  -8.834  16.179  1.00 49.40          
ATOM   1492  C   GLU   194       6.024  -9.388  16.317  1.00 48.31          
ATOM   1493  O   GLU   194       6.399 -10.332  15.638  1.00 48.33          
ATOM   1494  CB  GLU   194       3.630  -9.789  16.843  1.00 51.42          
ATOM   1495  CG  GLU   194       3.490 -11.112  16.136  1.00 56.87          
ATOM   1496  CD  GLU   194       2.523 -12.042  16.848  1.00 60.08          
ATOM   1497  OE1 GLU   194       2.177 -13.105  16.267  1.00 61.22          
ATOM   1498  OE2 GLU   194       2.115 -11.713  17.992  1.00 60.95          
ATOM   1499  N   ASN   195       6.787  -8.798  17.226  1.00 46.51          
ATOM   1500  CA  ASN   195       8.143  -9.207  17.436  1.00 45.67          
ATOM   1501  C   ASN   195       8.302 -10.310  18.443  1.00 45.98          
ATOM   1502  O   ASN   195       9.308 -11.001  18.434  1.00 47.00          
ATOM   1503  CB  ASN   195       8.982  -8.016  17.860  1.00 47.07          
ATOM   1504  CG  ASN   195       8.897  -6.874  16.867  1.00 48.46          
ATOM   1505  OD1 ASN   195       8.841  -7.099  15.655  1.00 49.07          
ATOM   1506  ND2 ASN   195       8.880  -5.641  17.372  1.00 48.06          
ATOM   1507  N   TYR   196       7.326 -10.499  19.315  1.00 46.29          
ATOM   1508  CA  TYR   196       7.467 -11.540  20.317  1.00 47.17          
ATOM   1509  C   TYR   196       6.232 -12.389  20.522  1.00 47.82          
ATOM   1510  O   TYR   196       5.125 -12.002  20.152  1.00 47.37          
ATOM   1511  CB  TYR   196       7.860 -10.918  21.664  1.00 46.04          
ATOM   1512  CG  TYR   196       8.973  -9.899  21.584  1.00 45.49          
ATOM   1513  CD1 TYR   196       8.701  -8.549  21.361  1.00 44.85          
ATOM   1514  CD2 TYR   196      10.304 -10.286  21.742  1.00 45.74          
ATOM   1515  CE1 TYR   196       9.736  -7.609  21.307  1.00 44.31          
ATOM   1516  CE2 TYR   196      11.340  -9.361  21.684  1.00 43.91          
ATOM   1517  CZ  TYR   196      11.055  -8.032  21.471  1.00 43.56          
ATOM   1518  OH  TYR   196      12.099  -7.141  21.438  1.00 42.22          
ATOM   1519  N   ASP   197       6.451 -13.561  21.112  1.00 48.93          
ATOM   1520  CA  ASP   197       5.371 -14.486  21.452  1.00 50.31          
ATOM   1521  C   ASP   197       4.840 -13.955  22.786  1.00 50.43          
ATOM   1522  O   ASP   197       4.990 -14.599  23.832  1.00 51.08          
ATOM   1523  CB  ASP   197       5.918 -15.900  21.660  1.00 51.47          
ATOM   1524  CG  ASP   197       4.886 -16.831  22.266  1.00 53.27          
ATOM   1525  OD1 ASP   197       5.258 -17.893  22.809  1.00 53.86          
ATOM   1526  OD2 ASP   197       3.686 -16.493  22.203  1.00 55.59          
ATOM   1527  N   THR   198       4.213 -12.782  22.737  1.00 49.76          
ATOM   1528  CA  THR   198       3.713 -12.096  23.932  1.00 49.28          
ATOM   1529  C   THR   198       2.563 -12.709  24.722  1.00 47.06          
ATOM   1530  O   THR   198       1.661 -13.327  24.170  1.00 46.55          
ATOM   1531  CB  THR   198       3.316 -10.626  23.597  1.00 50.79          
ATOM   1532  OG1 THR   198       2.051 -10.612  22.924  1.00 52.00          
ATOM   1533  CG2 THR   198       4.370  -9.971  22.696  1.00 51.01          
ATOM   1534  N   LEU   199       2.632 -12.528  26.034  1.00 46.23          
ATOM   1535  CA  LEU   199       1.601 -12.991  26.946  1.00 45.60          
ATOM   1536  C   LEU   199       1.181 -11.716  27.675  1.00 44.21          
ATOM   1537  O   LEU   199       1.519 -11.500  28.833  1.00 44.85          
ATOM   1538  CB  LEU   199       2.165 -14.024  27.925  1.00 44.96          
ATOM   1539  CG  LEU   199       1.253 -14.518  29.057  1.00 44.18          
ATOM   1540  CD1 LEU   199      -0.198 -14.656  28.608  1.00 43.89          
ATOM   1541  CD2 LEU   199       1.800 -15.840  29.538  1.00 45.05          
ATOM   1542  N   LEU   200       0.460 -10.863  26.959  1.00 41.66          
ATOM   1543  CA  LEU   200       0.026  -9.582  27.478  1.00 40.53          
ATOM   1544  C   LEU   200      -1.114  -9.672  28.479  1.00 39.77          
ATOM   1545  O   LEU   200      -2.234 -10.034  28.127  1.00 37.94          
ATOM   1546  CB  LEU   200      -0.372  -8.688  26.310  1.00 40.26          
ATOM   1547  CG  LEU   200      -0.657  -7.221  26.580  1.00 41.39          
ATOM   1548  CD1 LEU   200       0.606  -6.499  27.040  1.00 40.32          
ATOM   1549  CD2 LEU   200      -1.184  -6.590  25.299  1.00 42.87          
ATOM   1550  N   ILE   201      -0.821  -9.338  29.732  1.00 39.53          
ATOM   1551  CA  ILE   201      -1.838  -9.382  30.775  1.00 41.00          
ATOM   1552  C   ILE   201      -1.965  -8.007  31.463  1.00 40.72          
ATOM   1553  O   ILE   201      -0.981  -7.287  31.653  1.00 39.19          
ATOM   1554  CB  ILE   201      -1.542 -10.523  31.829  1.00 40.54          
ATOM   1555  CG1 ILE   201      -0.531 -10.072  32.855  1.00 40.51          
ATOM   1556  CG2 ILE   201      -0.955 -11.744  31.155  1.00 40.02          
ATOM   1557  CD  ILE   201      -1.170  -9.597  34.101  1.00 41.99          
ATOM   1558  N   GLY   202      -3.196  -7.644  31.809  1.00 41.71          
ATOM   1559  CA  GLY   202      -3.450  -6.372  32.457  1.00 42.46          
ATOM   1560  C   GLY   202      -4.338  -6.522  33.676  1.00 43.59          
ATOM   1561  O   GLY   202      -5.207  -7.391  33.711  1.00 43.17          
ATOM   1562  N   ILE   203      -4.107  -5.686  34.684  1.00 45.16          
ATOM   1563  CA  ILE   203      -4.900  -5.716  35.906  1.00 46.85          
ATOM   1564  C   ILE   203      -5.963  -4.638  35.810  1.00 48.66          
ATOM   1565  O   ILE   203      -5.655  -3.452  35.710  1.00 48.68          
ATOM   1566  CB  ILE   203      -4.041  -5.445  37.133  1.00 45.94          
ATOM   1567  CG1 ILE   203      -2.866  -6.419  37.179  1.00 46.14          
ATOM   1568  CG2 ILE   203      -4.882  -5.594  38.376  1.00 46.19          
ATOM   1569  CD  ILE   203      -1.912  -6.143  38.319  1.00 45.78          
ATOM   1570  N   GLU   204      -7.216  -5.058  35.849  1.00 51.48          
ATOM   1571  CA  GLU   204      -8.332  -4.138  35.715  1.00 55.82          
ATOM   1572  C   GLU   204      -9.114  -3.943  37.015  1.00 56.85          
ATOM   1573  O   GLU   204      -8.898  -4.644  37.995  1.00 56.30          
ATOM   1574  CB  GLU   204      -9.269  -4.675  34.637  1.00 59.26          
ATOM   1575  CG  GLU   204     -10.412  -3.758  34.261  1.00 64.70          
ATOM   1576  CD  GLU   204     -11.575  -4.512  33.653  1.00 67.29          
ATOM   1577  OE1 GLU   204     -12.163  -5.358  34.370  1.00 69.22          
ATOM   1578  OE2 GLU   204     -11.889  -4.257  32.466  1.00 68.13          
ATOM   1579  N   MET   205     -10.035  -2.988  37.010  1.00 58.68          
ATOM   1580  CA  MET   205     -10.855  -2.725  38.174  1.00 61.00          
ATOM   1581  C   MET   205     -11.885  -1.669  37.811  1.00 59.37          
ATOM   1582  O   MET   205     -11.719  -0.954  36.826  1.00 58.70          
ATOM   1583  CB  MET   205      -9.978  -2.261  39.332  1.00 66.33          
ATOM   1584  CG  MET   205      -9.104  -1.084  38.972  1.00 74.24          
ATOM   1585  SD  MET   205      -7.625  -0.835  40.201  1.00 86.23          
ATOM   1586  CE  MET   205      -8.641  -0.116  41.686  1.00 83.03          
ATOM   1587  N   SER   206     -12.954  -1.581  38.598  1.00 57.85          
ATOM   1588  CA  SER   206     -14.017  -0.622  38.331  1.00 57.29          
ATOM   1589  C   SER   206     -13.525   0.799  38.510  1.00 57.42          
ATOM   1590  O   SER   206     -12.622   1.049  39.304  1.00 57.34          
ATOM   1591  CB  SER   206     -15.212  -0.875  39.253  1.00 58.20          
ATOM   1592  OG  SER   206     -14.949  -0.485  40.595  1.00 58.30          
ATOM   1593  N   ARG   207     -14.121   1.732  37.774  1.00 57.81          
ATOM   1594  CA  ARG   207     -13.720   3.130  37.862  1.00 57.90          
ATOM   1595  C   ARG   207     -13.876   3.620  39.294  1.00 57.25          
ATOM   1596  O   ARG   207     -13.126   4.486  39.747  1.00 57.38          
ATOM   1597  CB  ARG   207     -14.567   4.018  36.933  1.00 59.77          
ATOM   1598  CG  ARG   207     -13.797   5.238  36.402  1.00 61.95          
ATOM   1599  CD  ARG   207     -14.603   6.536  36.316  1.00 63.77          
ATOM   1600  NE  ARG   207     -15.787   6.495  35.515  1.00 65.96          
ATOM   1601  CZ  ARG   207     -16.987   7.059  35.671  1.00 66.23          
ATOM   1602  NH1 ARG   207     -17.834   6.800  34.702  1.00 66.18          
ATOM   1603  NH2 ARG   207     -17.386   7.808  36.700  1.00 64.90          
ATOM   1604  N   GLU   208     -14.856   3.069  40.004  1.00 56.65          
ATOM   1605  CA  GLU   208     -15.097   3.463  41.387  1.00 56.14          
ATOM   1606  C   GLU   208     -13.862   3.162  42.237  1.00 55.10          
ATOM   1607  O   GLU   208     -13.262   4.069  42.819  1.00 54.75          
ATOM   1608  CB  GLU   208     -16.300   2.709  41.977  1.00 56.67          
ATOM   1609  CG  GLU   208     -17.676   2.979  41.343  1.00 57.91          
ATOM   1610  CD  GLU   208     -18.003   2.049  40.169  1.00 58.56          
ATOM   1611  OE1 GLU   208     -17.721   2.435  39.013  1.00 58.35          
ATOM   1612  OE2 GLU   208     -18.530   0.931  40.407  1.00 57.29          
ATOM   1613  N   THR   209     -13.490   1.883  42.301  1.00 54.16          
ATOM   1614  CA  THR   209     -12.340   1.456  43.092  1.00 53.60          
ATOM   1615  C   THR   209     -11.061   2.129  42.604  1.00 53.06          
ATOM   1616  O   THR   209     -10.239   2.571  43.400  1.00 52.72          
ATOM   1617  CB  THR   209     -12.153  -0.092  43.046  1.00 52.87          
ATOM   1618  OG1 THR   209     -13.366  -0.746  43.439  1.00 51.02          
ATOM   1619  CG2 THR   209     -11.043  -0.527  43.995  1.00 52.66          
ATOM   1620  N   LEU   210     -10.901   2.203  41.291  1.00 52.94          
ATOM   1621  CA  LEU   210      -9.730   2.828  40.703  1.00 52.98          
ATOM   1622  C   LEU   210      -9.528   4.235  41.261  1.00 52.71          
ATOM   1623  O   LEU   210      -8.509   4.528  41.891  1.00 52.92          
ATOM   1624  CB  LEU   210      -9.889   2.903  39.180  1.00 54.27          
ATOM   1625  CG  LEU   210      -8.820   3.668  38.374  1.00 54.83          
ATOM   1626  CD1 LEU   210      -7.497   2.944  38.513  1.00 56.79          
ATOM   1627  CD2 LEU   210      -9.212   3.773  36.904  1.00 53.90          
ATOM   1628  N   TYR   211     -10.512   5.097  41.028  1.00 52.09          
ATOM   1629  CA  TYR   211     -10.454   6.482  41.481  1.00 52.39          
ATOM   1630  C   TYR   211     -10.234   6.630  42.979  1.00 51.09          
ATOM   1631  O   TYR   211      -9.549   7.548  43.435  1.00 50.28          
ATOM   1632  CB  TYR   211     -11.728   7.237  41.061  1.00 54.07          
ATOM   1633  CG  TYR   211     -11.758   7.638  39.596  1.00 56.55          
ATOM   1634  CD1 TYR   211     -12.669   8.581  39.128  1.00 57.92          
ATOM   1635  CD2 TYR   211     -10.858   7.092  38.684  1.00 57.95          
ATOM   1636  CE1 TYR   211     -12.681   8.975  37.789  1.00 59.13          
ATOM   1637  CE2 TYR   211     -10.859   7.474  37.347  1.00 59.28          
ATOM   1638  CZ  TYR   211     -11.772   8.419  36.907  1.00 60.34          
ATOM   1639  OH  TYR   211     -11.763   8.810  35.586  1.00 61.94          
ATOM   1640  N   LEU   212     -10.808   5.721  43.748  1.00 50.37          
ATOM   1641  CA  LEU   212     -10.654   5.778  45.187  1.00 49.40          
ATOM   1642  C   LEU   212      -9.215   5.448  45.593  1.00 48.18          
ATOM   1643  O   LEU   212      -8.628   6.134  46.430  1.00 47.77          
ATOM   1644  CB  LEU   212     -11.630   4.805  45.834  1.00 50.41          
ATOM   1645  CG  LEU   212     -11.704   4.886  47.349  1.00 51.44          
ATOM   1646  CD1 LEU   212     -12.122   6.288  47.772  1.00 51.12          
ATOM   1647  CD2 LEU   212     -12.696   3.850  47.841  1.00 52.30          
ATOM   1648  N   ARG   213      -8.648   4.411  44.982  1.00 47.23          
ATOM   1649  CA  ARG   213      -7.288   3.993  45.291  1.00 45.81          
ATOM   1650  C   ARG   213      -6.283   5.054  44.893  1.00 45.00          
ATOM   1651  O   ARG   213      -5.316   5.301  45.618  1.00 45.34          
ATOM   1652  CB  ARG   213      -6.953   2.680  44.589  1.00 46.12          
ATOM   1653  CG  ARG   213      -7.893   1.561  44.947  1.00 47.50          
ATOM   1654  CD  ARG   213      -7.285   0.226  44.633  1.00 49.26          
ATOM   1655  NE  ARG   213      -6.204  -0.149  45.481  1.00 50.85          
ATOM   1656  CZ  ARG   213      -4.999  -0.646  45.219  1.00 52.07          
ATOM   1657  NH1 ARG   213      -4.277  -0.882  46.291  1.00 51.27          
ATOM   1658  NH2 ARG   213      -4.484  -0.876  44.015  1.00 52.18          
ATOM   1659  N   ILE   214      -6.505   5.677  43.740  1.00 42.90          
ATOM   1660  CA  ILE   214      -5.607   6.723  43.284  1.00 42.58          
ATOM   1661  C   ILE   214      -5.609   7.858  44.301  1.00 44.04          
ATOM   1662  O   ILE   214      -4.549   8.290  44.754  1.00 44.37          
ATOM   1663  CB  ILE   214      -6.015   7.257  41.894  1.00 42.38          
ATOM   1664  CG1 ILE   214      -5.905   6.130  40.856  1.00 41.56          
ATOM   1665  CG2 ILE   214      -5.131   8.432  41.499  1.00 40.53          
ATOM   1666  CD  ILE   214      -6.409   6.490  39.488  1.00 40.18          
ATOM   1667  N   ASN   215      -6.780   8.339  44.694  1.00 44.37          
ATOM   1668  CA  ASN   215      -6.782   9.402  45.689  1.00 46.12          
ATOM   1669  C   ASN   215      -5.987   8.978  46.906  1.00 45.68          
ATOM   1670  O   ASN   215      -5.266   9.777  47.492  1.00 45.52          
ATOM   1671  CB  ASN   215      -8.198   9.764  46.118  1.00 47.65          
ATOM   1672  CG  ASN   215      -9.003  10.321  44.984  1.00 49.26          
ATOM   1673  OD1 ASN   215      -8.501  11.116  44.187  1.00 50.48          
ATOM   1674  ND2 ASN   215     -10.263   9.922  44.902  1.00 50.51          
ATOM   1675  N   LYS   216      -6.107   7.711  47.274  1.00 45.88          
ATOM   1676  CA  LYS   216      -5.394   7.213  48.435  1.00 46.84          
ATOM   1677  C   LYS   216      -3.888   7.081  48.215  1.00 46.74          
ATOM   1678  O   LYS   216      -3.116   7.192  49.158  1.00 46.10          
ATOM   1679  CB  LYS   216      -5.984   5.876  48.880  1.00 48.06          
ATOM   1680  CG  LYS   216      -5.384   5.354  50.172  1.00 51.11          
ATOM   1681  CD  LYS   216      -6.408   4.614  51.040  1.00 52.88          
ATOM   1682  CE  LYS   216      -5.802   4.179  52.382  1.00 52.11          
ATOM   1683  NZ  LYS   216      -6.811   3.570  53.287  1.00 51.76          
ATOM   1684  N   ARG   217      -3.464   6.859  46.978  1.00 47.09          
ATOM   1685  CA  ARG   217      -2.040   6.725  46.708  1.00 47.24          
ATOM   1686  C   ARG   217      -1.372   8.088  46.677  1.00 46.13          
ATOM   1687  O   ARG   217      -0.179   8.219  46.959  1.00 46.25          
ATOM   1688  CB  ARG   217      -1.820   6.000  45.388  1.00 48.37          
ATOM   1689  CG  ARG   217      -0.383   5.876  44.976  1.00 50.40          
ATOM   1690  CD  ARG   217      -0.312   5.084  43.691  1.00 55.04          
ATOM   1691  NE  ARG   217      -1.153   5.631  42.611  1.00 58.04          
ATOM   1692  CZ  ARG   217      -0.829   6.677  41.851  1.00 58.71          
ATOM   1693  NH1 ARG   217      -1.659   7.091  40.896  1.00 58.58          
ATOM   1694  NH2 ARG   217       0.322   7.310  42.050  1.00 58.89          
ATOM   1695  N   VAL   218      -2.145   9.108  46.333  1.00 46.00          
ATOM   1696  CA  VAL   218      -1.609  10.455  46.284  1.00 46.08          
ATOM   1697  C   VAL   218      -1.417  10.905  47.725  1.00 47.54          
ATOM   1698  O   VAL   218      -0.449  11.586  48.042  1.00 46.77          
ATOM   1699  CB  VAL   218      -2.564  11.419  45.510  1.00 44.61          
ATOM   1700  CG1 VAL   218      -2.020  12.835  45.537  1.00 44.97          
ATOM   1701  CG2 VAL   218      -2.703  10.968  44.068  1.00 41.49          
ATOM   1702  N   ASP   219      -2.329  10.501  48.608  1.00 49.53          
ATOM   1703  CA  ASP   219      -2.219  10.875  50.019  1.00 50.83          
ATOM   1704  C   ASP   219      -0.959  10.273  50.608  1.00 51.42          
ATOM   1705  O   ASP   219      -0.230  10.942  51.334  1.00 52.60          
ATOM   1706  CB  ASP   219      -3.429  10.395  50.829  1.00 51.95          
ATOM   1707  CG  ASP   219      -4.704  11.146  50.482  1.00 54.27          
ATOM   1708  OD1 ASP   219      -4.604  12.292  49.978  1.00 54.93          
ATOM   1709  OD2 ASP   219      -5.813  10.598  50.730  1.00 54.88          
ATOM   1710  N   ILE   220      -0.704   9.007  50.298  1.00 50.93          
ATOM   1711  CA  ILE   220       0.475   8.335  50.820  1.00 50.35          
ATOM   1712  C   ILE   220       1.763   8.987  50.330  1.00 50.83          
ATOM   1713  O   ILE   220       2.692   9.191  51.107  1.00 49.12          
ATOM   1714  CB  ILE   220       0.489   6.861  50.422  1.00 50.25          
ATOM   1715  CG1 ILE   220      -0.829   6.199  50.819  1.00 49.65          
ATOM   1716  CG2 ILE   220       1.650   6.162  51.101  1.00 49.47          
ATOM   1717  CD  ILE   220      -0.965   4.771  50.337  1.00 48.90          
ATOM   1718  N   MET   221       1.819   9.308  49.040  1.00 52.75          
ATOM   1719  CA  MET   221       3.011   9.936  48.478  1.00 54.09          
ATOM   1720  C   MET   221       3.341  11.226  49.222  1.00 53.07          
ATOM   1721  O   MET   221       4.496  11.462  49.582  1.00 53.63          
ATOM   1722  CB  MET   221       2.829  10.262  46.996  1.00 57.37          
ATOM   1723  CG  MET   221       2.482   9.089  46.099  1.00 61.31          
ATOM   1724  SD  MET   221       2.805   9.516  44.215  1.00 68.30          
ATOM   1725  CE  MET   221       1.657  11.071  43.994  1.00 66.79          
ATOM   1726  N   LEU   222       2.329  12.066  49.435  1.00 51.20          
ATOM   1727  CA  LEU   222       2.529  13.324  50.144  1.00 48.78          
ATOM   1728  C   LEU   222       3.049  12.992  51.524  1.00 47.82          
ATOM   1729  O   LEU   222       3.943  13.657  52.041  1.00 46.99          
ATOM   1730  CB  LEU   222       1.211  14.101  50.261  1.00 47.68          
ATOM   1731  CG  LEU   222       0.761  14.988  49.091  1.00 47.08          
ATOM   1732  CD1 LEU   222       1.733  16.140  48.895  1.00 47.95          
ATOM   1733  CD2 LEU   222       0.673  14.168  47.838  1.00 47.74          
ATOM   1734  N   GLY   223       2.490  11.934  52.102  1.00 47.54          
ATOM   1735  CA  GLY   223       2.885  11.507  53.429  1.00 46.72          
ATOM   1736  C   GLY   223       4.254  10.872  53.473  1.00 47.26          
ATOM   1737  O   GLY   223       4.836  10.750  54.540  1.00 46.92          
ATOM   1738  N   HSD   224       4.783  10.465  52.326  1.00 48.55          
ATOM   1739  CA  HSD   224       6.096   9.847  52.324  1.00 49.09          
ATOM   1740  C   HSD   224       7.240  10.792  51.959  1.00 49.59          
ATOM   1741  O   HSD   224       8.401  10.389  51.959  1.00 50.22          
ATOM   1742  CB  HSD   224       6.102   8.628  51.408  1.00 50.46          
ATOM   1743  CG  HSD   224       5.612   7.376  52.070  1.00 52.48          
ATOM   1744  ND1 HSD   224       5.705   6.134  51.476  1.00 53.25          
ATOM   1745  CD2 HSD   224       5.035   7.170  53.278  1.00 52.96          
ATOM   1746  CE1 HSD   224       5.207   5.219  52.288  1.00 52.93          
ATOM   1747  NE2 HSD   224       4.793   5.821  53.389  1.00 53.58          
ATOM   1748  N   GLY   225       6.922  12.046  51.652  1.00 48.30          
ATOM   1749  CA  GLY   225       7.965  12.995  51.318  1.00 48.19          
ATOM   1750  C   GLY   225       8.060  13.385  49.858  1.00 48.65          
ATOM   1751  O   GLY   225       9.127  13.797  49.398  1.00 48.46          
ATOM   1752  N   LEU   226       6.955  13.245  49.126  1.00 49.00          
ATOM   1753  CA  LEU   226       6.908  13.607  47.703  1.00 48.60          
ATOM   1754  C   LEU   226       7.306  15.064  47.518  1.00 48.18          
ATOM   1755  O   LEU   226       8.145  15.389  46.681  1.00 47.55          
ATOM   1756  CB  LEU   226       5.495  13.408  47.131  1.00 46.67          
ATOM   1757  CG  LEU   226       5.224  14.068  45.771  1.00 46.21          
ATOM   1758  CD1 LEU   226       6.161  13.498  44.722  1.00 44.40          
ATOM   1759  CD2 LEU   226       3.772  13.858  45.362  1.00 45.96          
ATOM   1760  N   PHE   227       6.690  15.939  48.303  1.00 48.68          
ATOM   1761  CA  PHE   227       6.985  17.353  48.209  1.00 49.66          
ATOM   1762  C   PHE   227       8.466  17.600  48.501  1.00 50.70          
ATOM   1763  O   PHE   227       9.099  18.414  47.833  1.00 51.23          
ATOM   1764  CB  PHE   227       6.100  18.141  49.178  1.00 49.58          
ATOM   1765  CG  PHE   227       6.176  19.632  49.000  1.00 49.04          
ATOM   1766  CD1 PHE   227       7.235  20.359  49.538  1.00 49.30          
ATOM   1767  CD2 PHE   227       5.205  20.306  48.266  1.00 49.29          
ATOM   1768  CE1 PHE   227       7.327  21.743  49.355  1.00 49.51          
ATOM   1769  CE2 PHE   227       5.285  21.687  48.077  1.00 49.75          
ATOM   1770  CZ  PHE   227       6.354  22.409  48.620  1.00 49.71          
ATOM   1771  N   ASN   228       9.027  16.894  49.480  1.00 50.89          
ATOM   1772  CA  ASN   228      10.435  17.082  49.808  1.00 51.21          
ATOM   1773  C   ASN   228      11.299  16.702  48.605  1.00 51.40          
ATOM   1774  O   ASN   228      12.339  17.312  48.347  1.00 50.59          
ATOM   1775  CB  ASN   228      10.834  16.227  51.009  1.00 52.09          
ATOM   1776  CG  ASN   228      12.219  16.566  51.521  1.00 53.59          
ATOM   1777  OD1 ASN   228      12.820  15.809  52.281  1.00 54.96          
ATOM   1778  ND2 ASN   228      12.733  17.718  51.109  1.00 55.01          
ATOM   1779  N   GLU   229      10.853  15.695  47.866  1.00 51.04          
ATOM   1780  CA  GLU   229      11.586  15.244  46.706  1.00 51.72          
ATOM   1781  C   GLU   229      11.588  16.311  45.614  1.00 52.23          
ATOM   1782  O   GLU   229      12.655  16.693  45.128  1.00 53.72          
ATOM   1783  CB  GLU   229      10.979  13.954  46.175  1.00 52.05          
ATOM   1784  CG  GLU   229      11.899  13.129  45.301  1.00 52.84          
ATOM   1785  CD  GLU   229      11.213  11.880  44.807  1.00 53.57          
ATOM   1786  OE1 GLU   229      10.385  11.998  43.877  1.00 54.71          
ATOM   1787  OE2 GLU   229      11.478  10.787  45.357  1.00 52.14          
ATOM   1788  N   VAL   230      10.411  16.805  45.229  1.00 51.22          
ATOM   1789  CA  VAL   230      10.349  17.821  44.184  1.00 50.77          
ATOM   1790  C   VAL   230      11.131  19.055  44.597  1.00 50.92          
ATOM   1791  O   VAL   230      11.509  19.868  43.758  1.00 50.86          
ATOM   1792  CB  VAL   230       8.906  18.250  43.857  1.00 49.81          
ATOM   1793  CG1 VAL   230       8.028  17.040  43.649  1.00 50.73          
ATOM   1794  CG2 VAL   230       8.371  19.127  44.939  1.00 51.11          
ATOM   1795  N   GLN   231      11.382  19.188  45.894  1.00 51.90          
ATOM   1796  CA  GLN   231      12.138  20.326  46.401  1.00 52.73          
ATOM   1797  C   GLN   231      13.605  20.151  46.074  1.00 52.44          
ATOM   1798  O   GLN   231      14.255  21.086  45.636  1.00 52.48          
ATOM   1799  CB  GLN   231      11.968  20.457  47.914  1.00 53.42          
ATOM   1800  CG  GLN   231      10.643  21.061  48.363  1.00 53.33          
ATOM   1801  CD  GLN   231      10.629  21.347  49.861  1.00 53.59          
ATOM   1802  OE1 GLN   231      10.758  20.433  50.678  1.00 52.65          
ATOM   1803  NE2 GLN   231      10.476  22.620  50.225  1.00 53.06          
ATOM   1804  N   HSD   232      14.119  18.949  46.296  1.00 52.83          
ATOM   1805  CA  HSD   232      15.516  18.668  46.014  1.00 54.59          
ATOM   1806  C   HSD   232      15.772  18.771  44.522  1.00 54.60          
ATOM   1807  O   HSD   232      16.822  19.255  44.092  1.00 55.63          
ATOM   1808  CB  HSD   232      15.883  17.271  46.496  1.00 57.52          
ATOM   1809  CG  HSD   232      15.827  17.112  47.986  1.00 61.50          
ATOM   1810  ND1 HSD   232      15.522  15.912  48.596  1.00 62.41          
ATOM   1811  CD2 HSD   232      16.055  17.995  48.991  1.00 62.97          
ATOM   1812  CE1 HSD   232      15.564  16.062  49.910  1.00 63.57          
ATOM   1813  NE2 HSD   232      15.886  17.316  50.176  1.00 63.76          
ATOM   1814  N   LEU   233      14.814  18.311  43.724  1.00 54.34          
ATOM   1815  CA  LEU   233      14.948  18.351  42.267  1.00 53.56          
ATOM   1816  C   LEU   233      14.915  19.773  41.744  1.00 53.10          
ATOM   1817  O   LEU   233      15.781  20.168  40.973  1.00 53.07          
ATOM   1818  CB  LEU   233      13.830  17.547  41.616  1.00 53.05          
ATOM   1819  CG  LEU   233      13.928  16.035  41.776  1.00 53.98          
ATOM   1820  CD1 LEU   233      12.601  15.396  41.410  1.00 54.57          
ATOM   1821  CD2 LEU   233      15.049  15.502  40.893  1.00 53.99          
ATOM   1822  N   VAL   234      13.908  20.533  42.160  1.00 53.72          
ATOM   1823  CA  VAL   234      13.772  21.911  41.720  1.00 54.50          
ATOM   1824  C   VAL   234      14.955  22.759  42.197  1.00 55.31          
ATOM   1825  O   VAL   234      15.336  23.719  41.538  1.00 55.74          
ATOM   1826  CB  VAL   234      12.433  22.518  42.204  1.00 53.90          
ATOM   1827  CG1 VAL   234      12.458  22.698  43.704  1.00 56.91          
ATOM   1828  CG2 VAL   234      12.178  23.828  41.514  1.00 54.67          
ATOM   1829  N   GLU   235      15.539  22.398  43.334  1.00 56.55          
ATOM   1830  CA  GLU   235      16.690  23.125  43.862  1.00 58.23          
ATOM   1831  C   GLU   235      17.933  22.818  43.029  1.00 58.14          
ATOM   1832  O   GLU   235      18.782  23.685  42.822  1.00 58.69          
ATOM   1833  CB  GLU   235      16.941  22.758  45.333  1.00 60.13          
ATOM   1834  CG  GLU   235      16.176  23.627  46.343  1.00 63.27          
ATOM   1835  CD  GLU   235      16.297  23.141  47.793  1.00 65.19          
ATOM   1836  OE1 GLU   235      15.981  23.935  48.716  1.00 64.07          
ATOM   1837  OE2 GLU   235      16.690  21.967  48.007  1.00 66.28          
ATOM   1838  N   GLN   236      18.039  21.584  42.548  1.00 57.92          
ATOM   1839  CA  GLN   236      19.172  21.193  41.718  1.00 58.19          
ATOM   1840  C   GLN   236      19.008  21.716  40.289  1.00 58.15          
ATOM   1841  O   GLN   236      19.696  21.276  39.366  1.00 58.41          
ATOM   1842  CB  GLN   236      19.319  19.675  41.714  1.00 57.21          
ATOM   1843  CG  GLN   236      19.913  19.154  42.992  1.00 59.59          
ATOM   1844  CD  GLN   236      19.697  17.669  43.162  1.00 62.56          
ATOM   1845  OE1 GLN   236      18.555  17.205  43.234  1.00 64.35          
ATOM   1846  NE2 GLN   236      20.791  16.909  43.237  1.00 62.86          
ATOM   1847  N   GLY   237      18.081  22.656  40.120  1.00 57.82          
ATOM   1848  CA  GLY   237      17.834  23.252  38.823  1.00 55.54          
ATOM   1849  C   GLY   237      17.242  22.339  37.777  1.00 55.47          
ATOM   1850  O   GLY   237      17.083  22.752  36.627  1.00 55.87          
ATOM   1851  N   PHE   238      16.909  21.108  38.150  1.00 54.70          
ATOM   1852  CA  PHE   238      16.333  20.175  37.186  1.00 54.43          
ATOM   1853  C   PHE   238      14.965  20.597  36.686  1.00 54.15          
ATOM   1854  O   PHE   238      14.288  19.833  36.016  1.00 54.72          
ATOM   1855  CB  PHE   238      16.248  18.776  37.778  1.00 55.06          
ATOM   1856  CG  PHE   238      17.564  18.088  37.871  1.00 55.44          
ATOM   1857  CD1 PHE   238      18.398  18.015  36.769  1.00 55.52          
ATOM   1858  CD2 PHE   238      17.956  17.473  39.050  1.00 57.40          
ATOM   1859  CE1 PHE   238      19.610  17.327  36.837  1.00 56.79          
ATOM   1860  CE2 PHE   238      19.170  16.778  39.135  1.00 58.19          
ATOM   1861  CZ  PHE   238      19.997  16.706  38.026  1.00 57.47          
ATOM   1862  N   GLU   239      14.561  21.814  37.019  1.00 54.78          
ATOM   1863  CA  GLU   239      13.286  22.357  36.580  1.00 55.30          
ATOM   1864  C   GLU   239      13.415  22.627  35.071  1.00 55.95          
ATOM   1865  O   GLU   239      14.525  22.618  34.540  1.00 56.90          
ATOM   1866  CB  GLU   239      13.040  23.654  37.338  1.00 56.17          
ATOM   1867  CG  GLU   239      11.688  24.276  37.127  1.00 58.62          
ATOM   1868  CD  GLU   239      11.557  25.627  37.821  1.00 60.91          
ATOM   1869  OE1 GLU   239      12.351  25.889  38.762  1.00 59.94          
ATOM   1870  OE2 GLU   239      10.650  26.411  37.436  1.00 60.79          
ATOM   1871  N   ALA   240      12.301  22.865  34.384  1.00 54.47          
ATOM   1872  CA  ALA   240      12.335  23.137  32.950  1.00 53.29          
ATOM   1873  C   ALA   240      12.608  21.881  32.109  1.00 52.86          
ATOM   1874  O   ALA   240      12.584  21.917  30.869  1.00 51.49          
ATOM   1875  CB  ALA   240      13.383  24.219  32.646  1.00 51.46          
ATOM   1876  N   SER   241      12.863  20.770  32.795  1.00 52.63          
ATOM   1877  CA  SER   241      13.141  19.487  32.150  1.00 52.57          
ATOM   1878  C   SER   241      11.859  18.723  31.846  1.00 52.68          
ATOM   1879  O   SER   241      10.835  18.927  32.496  1.00 53.04          
ATOM   1880  CB  SER   241      14.023  18.630  33.060  1.00 51.54          
ATOM   1881  OG  SER   241      15.177  19.335  33.450  1.00 50.84          
ATOM   1882  N   GLN   242      11.921  17.833  30.867  1.00 53.10          
ATOM   1883  CA  GLN   242      10.756  17.044  30.494  1.00 53.88          
ATOM   1884  C   GLN   242      10.242  16.263  31.687  1.00 54.11          
ATOM   1885  O   GLN   242       9.048  16.248  31.968  1.00 54.86          
ATOM   1886  CB  GLN   242      11.121  16.079  29.365  1.00 55.50          
ATOM   1887  CG  GLN   242      10.373  14.752  29.387  1.00 56.34          
ATOM   1888  CD  GLN   242      10.874  13.787  28.333  1.00 56.34          
ATOM   1889  OE1 GLN   242      12.054  13.449  28.295  1.00 56.46          
ATOM   1890  NE2 GLN   242       9.975  13.343  27.465  1.00 57.42          
ATOM   1891  N   SER   243      11.153  15.610  32.394  1.00 54.24          
ATOM   1892  CA  SER   243      10.773  14.819  33.554  1.00 53.83          
ATOM   1893  C   SER   243       9.962  15.619  34.578  1.00 54.07          
ATOM   1894  O   SER   243       8.988  15.111  35.121  1.00 53.71          
ATOM   1895  CB  SER   243      12.025  14.264  34.206  1.00 53.39          
ATOM   1896  OG  SER   243      12.933  15.318  34.435  1.00 54.65          
ATOM   1897  N   MET   244      10.358  16.866  34.835  1.00 54.91          
ATOM   1898  CA  MET   244       9.664  17.713  35.810  1.00 55.19          
ATOM   1899  C   MET   244       8.284  18.155  35.370  1.00 53.27          
ATOM   1900  O   MET   244       7.635  18.944  36.058  1.00 52.57          
ATOM   1901  CB  MET   244      10.485  18.962  36.112  1.00 60.45          
ATOM   1902  CG  MET   244      11.764  18.715  36.878  1.00 66.90          
ATOM   1903  SD  MET   244      11.481  18.227  38.722  1.00 76.91          
ATOM   1904  CE  MET   244      11.439  19.994  39.505  1.00 74.29          
ATOM   1905  N   GLN   245       7.845  17.657  34.218  1.00 52.02          
ATOM   1906  CA  GLN   245       6.538  18.002  33.662  1.00 50.21          
ATOM   1907  C   GLN   245       5.555  16.882  33.851  1.00 49.21          
ATOM   1908  O   GLN   245       4.385  17.019  33.509  1.00 49.73          
ATOM   1909  CB  GLN   245       6.667  18.312  32.173  1.00 49.10          
ATOM   1910  CG  GLN   245       7.278  19.652  31.894  1.00 48.85          
ATOM   1911  CD  GLN   245       6.407  20.759  32.420  1.00 49.81          
ATOM   1912  OE1 GLN   245       5.255  20.891  32.015  1.00 51.70          
ATOM   1913  NE2 GLN   245       6.944  21.564  33.330  1.00 50.84          
ATOM   1914  N   ALA   246       6.041  15.767  34.383  1.00 49.21          
ATOM   1915  CA  ALA   246       5.190  14.602  34.612  1.00 49.16          
ATOM   1916  C   ALA   246       4.235  14.858  35.766  1.00 48.33          
ATOM   1917  O   ALA   246       4.560  15.586  36.709  1.00 47.49          
ATOM   1918  CB  ALA   246       6.041  13.373  34.907  1.00 48.23          
ATOM   1919  N   ILE   247       3.053  14.257  35.684  1.00 47.65          
ATOM   1920  CA  ILE   247       2.060  14.423  36.725  1.00 46.43          
ATOM   1921  C   ILE   247       2.682  14.001  38.062  1.00 45.24          
ATOM   1922  O   ILE   247       3.232  12.906  38.193  1.00 43.81          
ATOM   1923  CB  ILE   247       0.783  13.592  36.405  1.00 46.72          
ATOM   1924  CG1 ILE   247       0.287  12.915  37.681  1.00 47.64          
ATOM   1925  CG2 ILE   247       1.049  12.611  35.247  1.00 46.66          
ATOM   1926  CD  ILE   247      -0.708  11.809  37.439  1.00 50.82          
ATOM   1927  N   GLY   248       2.611  14.896  39.040  1.00 44.32          
ATOM   1928  CA  GLY   248       3.194  14.618  40.338  1.00 44.63          
ATOM   1929  C   GLY   248       4.406  15.502  40.631  1.00 43.81          
ATOM   1930  O   GLY   248       4.998  15.439  41.706  1.00 43.85          
ATOM   1931  N   TYR   249       4.786  16.326  39.668  1.00 43.00          
ATOM   1932  CA  TYR   249       5.906  17.209  39.852  1.00 42.47          
ATOM   1933  C   TYR   249       5.543  18.571  39.321  1.00 44.75          
ATOM   1934  O   TYR   249       5.803  19.581  39.971  1.00 46.97          
ATOM   1935  CB  TYR   249       7.158  16.700  39.130  1.00 39.81          
ATOM   1936  CG  TYR   249       7.706  15.406  39.667  1.00 36.35          
ATOM   1937  CD1 TYR   249       7.136  14.201  39.319  1.00 35.98          
ATOM   1938  CD2 TYR   249       8.783  15.392  40.535  1.00 34.84          
ATOM   1939  CE1 TYR   249       7.625  13.006  39.818  1.00 36.42          
ATOM   1940  CE2 TYR   249       9.283  14.202  41.043  1.00 35.06          
ATOM   1941  CZ  TYR   249       8.700  13.011  40.676  1.00 35.44          
ATOM   1942  OH  TYR   249       9.197  11.819  41.146  1.00 35.17          
ATOM   1943  N   LYS   250       4.931  18.609  38.142  1.00 45.83          
ATOM   1944  CA  LYS   250       4.546  19.883  37.540  1.00 46.38          
ATOM   1945  C   LYS   250       3.497  20.619  38.381  1.00 46.13          
ATOM   1946  O   LYS   250       3.433  21.845  38.349  1.00 47.15          
ATOM   1947  CB  LYS   250       4.017  19.679  36.108  1.00 47.06          
ATOM   1948  CG  LYS   250       2.721  18.900  36.022  1.00 48.18          
ATOM   1949  CD  LYS   250       2.125  18.891  34.618  1.00 47.37          
ATOM   1950  CE  LYS   250       0.813  18.109  34.616  1.00 47.67          
ATOM   1951  NZ  LYS   250       0.166  18.049  33.283  1.00 48.34          
ATOM   1952  N   GLU   251       2.692  19.882  39.145  1.00 45.84          
ATOM   1953  CA  GLU   251       1.669  20.512  39.974  1.00 45.20          
ATOM   1954  C   GLU   251       2.257  21.083  41.245  1.00 43.71          
ATOM   1955  O   GLU   251       1.835  22.130  41.721  1.00 42.83          
ATOM   1956  CB  GLU   251       0.565  19.517  40.338  1.00 46.13          
ATOM   1957  CG  GLU   251      -0.155  18.934  39.135  1.00 48.53          
ATOM   1958  CD  GLU   251       0.410  17.596  38.709  1.00 49.88          
ATOM   1959  OE1 GLU   251       1.544  17.265  39.138  1.00 50.12          
ATOM   1960  OE2 GLU   251      -0.278  16.889  37.932  1.00 49.85          
ATOM   1961  N   LEU   252       3.245  20.390  41.788  1.00 43.53          
ATOM   1962  CA  LEU   252       3.886  20.831  43.012  1.00 42.57          
ATOM   1963  C   LEU   252       4.928  21.922  42.821  1.00 42.00          
ATOM   1964  O   LEU   252       5.227  22.648  43.756  1.00 42.30          
ATOM   1965  CB  LEU   252       4.512  19.635  43.736  1.00 41.74          
ATOM   1966  CG  LEU   252       3.547  18.511  44.150  1.00 41.92          
ATOM   1967  CD1 LEU   252       4.312  17.378  44.828  1.00 42.76          
ATOM   1968  CD2 LEU   252       2.494  19.048  45.086  1.00 40.89          
ATOM   1969  N   VAL   253       5.494  22.055  41.630  1.00 42.00          
ATOM   1970  CA  VAL   253       6.506  23.098  41.440  1.00 42.95          
ATOM   1971  C   VAL   253       5.957  24.484  41.772  1.00 44.10          
ATOM   1972  O   VAL   253       6.607  25.265  42.460  1.00 44.41          
ATOM   1973  CB  VAL   253       7.078  23.119  39.992  1.00 41.99          
ATOM   1974  CG1 VAL   253       8.115  24.221  39.854  1.00 39.96          
ATOM   1975  CG2 VAL   253       7.720  21.787  39.669  1.00 42.77          
ATOM   1976  N   PRO   254       4.743  24.805  41.291  1.00 45.20          
ATOM   1977  CA  PRO   254       4.124  26.111  41.551  1.00 45.81          
ATOM   1978  C   PRO   254       3.925  26.422  43.034  1.00 45.87          
ATOM   1979  O   PRO   254       4.113  27.558  43.471  1.00 46.34          
ATOM   1980  CB  PRO   254       2.789  26.018  40.804  1.00 45.36          
ATOM   1981  CG  PRO   254       3.108  25.114  39.670  1.00 45.40          
ATOM   1982  CD  PRO   254       3.917  24.032  40.348  1.00 46.25          
ATOM   1983  N   VAL   255       3.555  25.407  43.804  1.00 45.65          
ATOM   1984  CA  VAL   255       3.323  25.591  45.224  1.00 46.52          
ATOM   1985  C   VAL   255       4.634  25.881  45.971  1.00 45.46          
ATOM   1986  O   VAL   255       4.631  26.462  47.057  1.00 44.66          
ATOM   1987  CB  VAL   255       2.562  24.354  45.825  1.00 46.99          
ATOM   1988  CG1 VAL   255       3.439  23.133  45.793  1.00 48.49          
ATOM   1989  CG2 VAL   255       2.109  24.654  47.237  1.00 49.86          
ATOM   1990  N   ILE   256       5.751  25.507  45.362  1.00 45.49          
ATOM   1991  CA  ILE   256       7.056  25.745  45.954  1.00 46.29          
ATOM   1992  C   ILE   256       7.435  27.214  45.784  1.00 47.82          
ATOM   1993  O   ILE   256       8.270  27.754  46.516  1.00 48.39          
ATOM   1994  CB  ILE   256       8.130  24.897  45.280  1.00 46.02          
ATOM   1995  CG1 ILE   256       7.762  23.427  45.383  1.00 47.63          
ATOM   1996  CG2 ILE   256       9.468  25.123  45.943  1.00 46.15          
ATOM   1997  CD  ILE   256       8.770  22.513  44.697  1.00 47.88          
ATOM   1998  N   LYS   257       6.808  27.856  44.811  1.00 47.54          
ATOM   1999  CA  LYS   257       7.057  29.256  44.529  1.00 48.04          
ATOM   2000  C   LYS   257       6.095  30.144  45.315  1.00 47.94          
ATOM   2001  O   LYS   257       6.389  31.307  45.602  1.00 48.31          
ATOM   2002  CB  LYS   257       6.926  29.490  43.023  1.00 49.79          
ATOM   2003  CG  LYS   257       7.852  28.570  42.220  1.00 51.05          
ATOM   2004  CD  LYS   257       7.865  28.896  40.744  1.00 51.18          
ATOM   2005  CE  LYS   257       8.949  28.114  40.016  1.00 52.26          
ATOM   2006  NZ  LYS   257       8.908  28.350  38.537  1.00 51.23          
ATOM   2007  N   GLY   258       4.946  29.582  45.669  1.00 46.79          
ATOM   2008  CA  GLY   258       3.973  30.325  46.436  1.00 45.83          
ATOM   2009  C   GLY   258       2.921  30.953  45.554  1.00 45.01          
ATOM   2010  O   GLY   258       2.265  31.921  45.944  1.00 44.91          
ATOM   2011  N   ASN   259       2.756  30.414  44.356  1.00 43.60          
ATOM   2012  CA  ASN   259       1.757  30.948  43.445  1.00 43.75          
ATOM   2013  C   ASN   259       0.458  30.169  43.563  1.00 43.71          
ATOM   2014  O   ASN   259      -0.609  30.661  43.208  1.00 42.68          
ATOM   2015  CB  ASN   259       2.277  30.909  42.009  1.00 43.72          
ATOM   2016  CG  ASN   259       3.456  31.826  41.802  1.00 44.15          
ATOM   2017  OD1 ASN   259       4.545  31.383  41.428  1.00 45.04          
ATOM   2018  ND2 ASN   259       3.254  33.113  42.060  1.00 43.19          
ATOM   2019  N   ILE   260       0.550  28.954  44.081  1.00 43.37          
ATOM   2020  CA  ILE   260      -0.637  28.137  44.252  1.00 43.46          
ATOM   2021  C   ILE   260      -0.611  27.477  45.638  1.00 43.92          
ATOM   2022  O   ILE   260       0.465  27.206  46.190  1.00 42.74          
ATOM   2023  CB  ILE   260      -0.726  27.095  43.115  1.00 43.21          
ATOM   2024  CG1 ILE   260      -1.974  26.234  43.282  1.00 43.70          
ATOM   2025  CG2 ILE   260       0.541  26.255  43.068  1.00 43.86          
ATOM   2026  CD  ILE   260      -2.181  25.234  42.160  1.00 44.18          
ATOM   2027  N   SER   261      -1.789  27.245  46.219  1.00 44.15          
ATOM   2028  CA  SER   261      -1.874  26.646  47.560  1.00 44.65          
ATOM   2029  C   SER   261      -1.703  25.141  47.512  1.00 44.60          
ATOM   2030  O   SER   261      -2.022  24.509  46.516  1.00 44.23          
ATOM   2031  CB  SER   261      -3.218  26.984  48.215  1.00 43.24          
ATOM   2032  OG  SER   261      -4.290  26.404  47.507  1.00 43.70          
ATOM   2033  N   MET   262      -1.201  24.572  48.599  1.00 46.15          
ATOM   2034  CA  MET   262      -0.993  23.135  48.663  1.00 47.95          
ATOM   2035  C   MET   262      -2.303  22.393  48.419  1.00 46.17          
ATOM   2036  O   MET   262      -2.341  21.413  47.676  1.00 45.54          
ATOM   2037  CB  MET   262      -0.418  22.746  50.029  1.00 51.56          
ATOM   2038  CG  MET   262      -0.078  21.262  50.196  1.00 56.73          
ATOM   2039  SD  MET   262       1.519  20.694  49.227  1.00 68.54          
ATOM   2040  CE  MET   262       0.661  20.288  47.543  1.00 64.64          
ATOM   2041  N   GLU   263      -3.376  22.871  49.040  1.00 45.51          
ATOM   2042  CA  GLU   263      -4.690  22.247  48.899  1.00 45.04          
ATOM   2043  C   GLU   263      -5.118  22.133  47.447  1.00 44.37          
ATOM   2044  O   GLU   263      -5.347  21.035  46.935  1.00 42.41          
ATOM   2045  CB  GLU   263      -5.738  23.045  49.678  1.00 45.88          
ATOM   2046  CG  GLU   263      -5.523  23.008  51.187  1.00 48.51          
ATOM   2047  CD  GLU   263      -4.644  24.132  51.716  1.00 50.02          
ATOM   2048  OE1 GLU   263      -4.298  24.079  52.917  1.00 50.44          
ATOM   2049  OE2 GLU   263      -4.319  25.069  50.948  1.00 51.15          
ATOM   2050  N   ASN   264      -5.226  23.289  46.798  1.00 44.68          
ATOM   2051  CA  ASN   264      -5.613  23.378  45.397  1.00 44.86          
ATOM   2052  C   ASN   264      -4.731  22.509  44.490  1.00 44.40          
ATOM   2053  O   ASN   264      -5.232  21.786  43.621  1.00 44.99          
ATOM   2054  CB  ASN   264      -5.571  24.840  44.954  1.00 45.20          
ATOM   2055  CG  ASN   264      -6.725  25.644  45.526  1.00 47.47          
ATOM   2056  OD1 ASN   264      -6.823  26.848  45.318  1.00 47.36          
ATOM   2057  ND2 ASN   264      -7.620  24.967  46.247  1.00 49.46          
ATOM   2058  N   ALA   265      -3.422  22.574  44.707  1.00 43.68          
ATOM   2059  CA  ALA   265      -2.468  21.794  43.935  1.00 42.84          
ATOM   2060  C   ALA   265      -2.749  20.305  44.092  1.00 42.53          
ATOM   2061  O   ALA   265      -2.871  19.580  43.103  1.00 42.36          
ATOM   2062  CB  ALA   265      -1.052  22.109  44.390  1.00 42.55          
ATOM   2063  N   VAL   266      -2.843  19.841  45.331  1.00 42.41          
ATOM   2064  CA  VAL   266      -3.108  18.434  45.571  1.00 43.43          
ATOM   2065  C   VAL   266      -4.404  18.022  44.900  1.00 44.60          
ATOM   2066  O   VAL   266      -4.527  16.904  44.404  1.00 44.52          
ATOM   2067  CB  VAL   266      -3.202  18.130  47.074  1.00 44.20          
ATOM   2068  CG1 VAL   266      -3.556  16.660  47.287  1.00 42.88          
ATOM   2069  CG2 VAL   266      -1.875  18.457  47.741  1.00 43.74          
ATOM   2070  N   GLU   267      -5.373  18.931  44.890  1.00 46.48          
ATOM   2071  CA  GLU   267      -6.658  18.660  44.259  1.00 47.56          
ATOM   2072  C   GLU   267      -6.456  18.351  42.774  1.00 47.85          
ATOM   2073  O   GLU   267      -7.092  17.447  42.222  1.00 47.49          
ATOM   2074  CB  GLU   267      -7.572  19.865  44.396  1.00 49.81          
ATOM   2075  CG  GLU   267      -8.763  19.766  43.492  1.00 55.10          
ATOM   2076  CD  GLU   267     -10.067  19.881  44.229  1.00 58.36          
ATOM   2077  OE1 GLU   267     -10.443  21.026  44.578  1.00 60.03          
ATOM   2078  OE2 GLU   267     -10.697  18.825  44.483  1.00 60.12          
ATOM   2079  N   LYS   268      -5.566  19.113  42.135  1.00 47.95          
ATOM   2080  CA  LYS   268      -5.262  18.927  40.722  1.00 48.04          
ATOM   2081  C   LYS   268      -4.369  17.712  40.488  1.00 47.98          
ATOM   2082  O   LYS   268      -4.441  17.072  39.438  1.00 48.31          
ATOM   2083  CB  LYS   268      -4.604  20.187  40.154  1.00 47.51          
ATOM   2084  CG  LYS   268      -5.534  21.394  40.148  1.00 49.27          
ATOM   2085  CD  LYS   268      -4.978  22.558  39.331  1.00 50.77          
ATOM   2086  CE  LYS   268      -3.645  23.070  39.900  1.00 51.57          
ATOM   2087  NZ  LYS   268      -3.096  24.265  39.171  1.00 50.01          
ATOM   2088  N   LEU   269      -3.529  17.396  41.470  1.00 48.23          
ATOM   2089  CA  LEU   269      -2.643  16.242  41.371  1.00 47.71          
ATOM   2090  C   LEU   269      -3.442  14.928  41.365  1.00 47.84          
ATOM   2091  O   LEU   269      -3.144  14.018  40.591  1.00 47.71          
ATOM   2092  CB  LEU   269      -1.637  16.252  42.532  1.00 46.71          
ATOM   2093  CG  LEU   269      -0.758  15.019  42.762  1.00 45.77          
ATOM   2094  CD1 LEU   269      -0.011  14.668  41.499  1.00 46.01          
ATOM   2095  CD2 LEU   269       0.216  15.295  43.894  1.00 45.49          
ATOM   2096  N   LYS   270      -4.456  14.827  42.221  1.00 47.27          
ATOM   2097  CA  LYS   270      -5.276  13.617  42.276  1.00 47.21          
ATOM   2098  C   LYS   270      -6.162  13.535  41.038  1.00 47.74          
ATOM   2099  O   LYS   270      -6.550  12.448  40.614  1.00 47.84          
ATOM   2100  CB  LYS   270      -6.160  13.615  43.523  1.00 46.87          
ATOM   2101  CG  LYS   270      -5.398  13.685  44.847  1.00 45.75          
ATOM   2102  CD  LYS   270      -6.354  13.642  46.036  1.00 43.37          
ATOM   2103  CE  LYS   270      -5.619  13.777  47.346  1.00 42.55          
ATOM   2104  NZ  LYS   270      -6.516  13.481  48.479  1.00 42.55          
ATOM   2105  N   GLN   271      -6.491  14.689  40.466  1.00 47.50          
ATOM   2106  CA  GLN   271      -7.318  14.706  39.279  1.00 47.55          
ATOM   2107  C   GLN   271      -6.498  14.205  38.090  1.00 46.89          
ATOM   2108  O   GLN   271      -6.837  13.186  37.493  1.00 48.08          
ATOM   2109  CB  GLN   271      -7.846  16.116  39.008  1.00 50.10          
ATOM   2110  CG  GLN   271      -9.040  16.129  38.072  1.00 51.28          
ATOM   2111  CD  GLN   271      -9.270  17.471  37.406  1.00 51.63          
ATOM   2112  OE1 GLN   271     -10.281  17.664  36.729  1.00 51.74          
ATOM   2113  NE2 GLN   271      -8.332  18.401  37.585  1.00 51.56          
ATOM   2114  N   HSD   272      -5.418  14.908  37.746  1.00 45.28          
ATOM   2115  CA  HSD   272      -4.553  14.493  36.629  1.00 42.45          
ATOM   2116  C   HSD   272      -4.225  13.007  36.753  1.00 40.81          
ATOM   2117  O   HSD   272      -4.041  12.325  35.754  1.00 39.84          
ATOM   2118  CB  HSD   272      -3.221  15.258  36.637  1.00 43.50          
ATOM   2119  CG  HSD   272      -3.334  16.704  36.277  1.00 45.07          
ATOM   2120  ND1 HSD   272      -4.092  17.599  36.999  1.00 45.43          
ATOM   2121  CD2 HSD   272      -2.752  17.416  35.286  1.00 46.21          
ATOM   2122  CE1 HSD   272      -3.972  18.803  36.470  1.00 45.55          
ATOM   2123  NE2 HSD   272      -3.164  18.719  35.430  1.00 46.84          
ATOM   2124  N   SER   273      -4.126  12.519  37.989  1.00 38.20          
ATOM   2125  CA  SER   273      -3.803  11.130  38.213  1.00 35.52          
ATOM   2126  C   SER   273      -4.983  10.267  37.835  1.00 35.68          
ATOM   2127  O   SER   273      -4.811   9.191  37.264  1.00 35.30          
ATOM   2128  CB  SER   273      -3.412  10.895  39.668  1.00 35.90          
ATOM   2129  OG  SER   273      -2.188  11.530  39.993  1.00 32.29          
ATOM   2130  N   ARG   274      -6.187  10.727  38.149  1.00 35.75          
ATOM   2131  CA  ARG   274      -7.390   9.969  37.802  1.00 36.75          
ATOM   2132  C   ARG   274      -7.588   9.937  36.285  1.00 37.28          
ATOM   2133  O   ARG   274      -7.869   8.888  35.722  1.00 38.52          
ATOM   2134  CB  ARG   274      -8.637  10.580  38.459  1.00 36.95          
ATOM   2135  CG  ARG   274      -8.698  10.466  39.974  1.00 36.82          
ATOM   2136  CD  ARG   274     -10.054  10.929  40.488  1.00 36.70          
ATOM   2137  NE  ARG   274     -10.274  12.356  40.263  1.00 38.35          
ATOM   2138  CZ  ARG   274     -10.032  13.306  41.167  1.00 38.14          
ATOM   2139  NH1 ARG   274      -9.561  12.981  42.363  1.00 36.22          
ATOM   2140  NH2 ARG   274     -10.264  14.582  40.878  1.00 37.03          
ATOM   2141  N   GLN   275      -7.443  11.086  35.629  1.00 38.05          
ATOM   2142  CA  GLN   275      -7.617  11.169  34.183  1.00 38.52          
ATOM   2143  C   GLN   275      -6.583  10.312  33.478  1.00 38.01          
ATOM   2144  O   GLN   275      -6.896   9.574  32.543  1.00 39.39          
ATOM   2145  CB  GLN   275      -7.474  12.608  33.709  1.00 40.25          
ATOM   2146  CG  GLN   275      -8.511  13.556  34.284  1.00 43.98          
ATOM   2147  CD  GLN   275      -8.149  15.020  34.056  1.00 46.35          
ATOM   2148  OE1 GLN   275      -7.853  15.427  32.936  1.00 48.91          
ATOM   2149  NE2 GLN   275      -8.177  15.816  35.123  1.00 47.14          
ATOM   2150  N   TYR   276      -5.344  10.411  33.934  1.00 36.36          
ATOM   2151  CA  TYR   276      -4.262   9.650  33.344  1.00 35.31          
ATOM   2152  C   TYR   276      -4.531   8.157  33.426  1.00 34.41          
ATOM   2153  O   TYR   276      -4.445   7.449  32.430  1.00 33.63          
ATOM   2154  CB  TYR   276      -2.950  10.005  34.050  1.00 35.75          
ATOM   2155  CG  TYR   276      -1.751   9.236  33.559  1.00 36.20          
ATOM   2156  CD1 TYR   276      -1.464   7.966  34.054  1.00 36.58          
ATOM   2157  CD2 TYR   276      -0.903   9.778  32.600  1.00 35.33          
ATOM   2158  CE1 TYR   276      -0.358   7.257  33.609  1.00 37.87          
ATOM   2159  CE2 TYR   276       0.202   9.082  32.142  1.00 36.76          
ATOM   2160  CZ  TYR   276       0.473   7.820  32.654  1.00 38.26          
ATOM   2161  OH  TYR   276       1.582   7.126  32.231  1.00 40.41          
ATOM   2162  N   ALA   277      -4.858   7.685  34.619  1.00 34.89          
ATOM   2163  CA  ALA   277      -5.136   6.275  34.828  1.00 36.30          
ATOM   2164  C   ALA   277      -6.255   5.819  33.905  1.00 38.00          
ATOM   2165  O   ALA   277      -6.225   4.706  33.376  1.00 36.91          
ATOM   2166  CB  ALA   277      -5.530   6.026  36.276  1.00 35.53          
ATOM   2167  N   LYS   278      -7.251   6.679  33.723  1.00 40.20          
ATOM   2168  CA  LYS   278      -8.383   6.359  32.865  1.00 42.32          
ATOM   2169  C   LYS   278      -7.949   6.259  31.429  1.00 43.49          
ATOM   2170  O   LYS   278      -8.225   5.263  30.762  1.00 44.62          
ATOM   2171  CB  LYS   278      -9.477   7.419  32.990  1.00 43.95          
ATOM   2172  CG  LYS   278     -10.619   7.243  31.998  1.00 46.27          
ATOM   2173  CD  LYS   278     -11.846   8.053  32.398  1.00 49.97          
ATOM   2174  CE  LYS   278     -13.027   7.776  31.461  1.00 51.38          
ATOM   2175  NZ  LYS   278     -14.346   8.206  32.045  1.00 53.63          
ATOM   2176  N   ARG   279      -7.271   7.296  30.948  1.00 44.33          
ATOM   2177  CA  ARG   279      -6.798   7.321  29.561  1.00 45.32          
ATOM   2178  C   ARG   279      -5.950   6.079  29.228  1.00 45.13          
ATOM   2179  O   ARG   279      -6.048   5.529  28.134  1.00 44.57          
ATOM   2180  CB  ARG   279      -6.008   8.619  29.301  1.00 47.62          
ATOM   2181  CG  ARG   279      -5.490   8.795  27.863  1.00 50.39          
ATOM   2182  CD  ARG   279      -5.468  10.270  27.446  1.00 53.84          
ATOM   2183  NE  ARG   279      -4.936  11.132  28.466  1.00 57.92          
ATOM   2184  CZ  ARG   279      -5.349  12.289  28.988  1.00 58.57          
ATOM   2185  NH1 ARG   279      -4.546  12.767  29.919  1.00 59.22          
ATOM   2186  NH2 ARG   279      -6.458  12.959  28.669  1.00 58.05          
ATOM   2187  N   GLN   280      -5.142   5.629  30.186  1.00 44.54          
ATOM   2188  CA  GLN   280      -4.299   4.466  29.979  1.00 42.49          
ATOM   2189  C   GLN   280      -5.092   3.179  29.965  1.00 42.31          
ATOM   2190  O   GLN   280      -4.725   2.219  29.298  1.00 42.76          
ATOM   2191  CB  GLN   280      -3.229   4.386  31.065  1.00 41.79          
ATOM   2192  CG  GLN   280      -1.842   4.200  30.515  1.00 42.04          
ATOM   2193  CD  GLN   280      -1.452   5.345  29.597  1.00 42.96          
ATOM   2194  OE1 GLN   280      -0.920   5.137  28.501  1.00 41.69          
ATOM   2195  NE2 GLN   280      -1.723   6.569  30.040  1.00 42.65          
ATOM   2196  N   LEU   281      -6.177   3.149  30.720  1.00 43.60          
ATOM   2197  CA  LEU   281      -7.005   1.954  30.795  1.00 44.86          
ATOM   2198  C   LEU   281      -7.760   1.866  29.474  1.00 46.02          
ATOM   2199  O   LEU   281      -7.866   0.798  28.873  1.00 46.62          
ATOM   2200  CB  LEU   281      -7.986   2.084  31.964  1.00 46.05          
ATOM   2201  CG  LEU   281      -8.521   0.834  32.659  1.00 47.29          
ATOM   2202  CD1 LEU   281      -9.210  -0.042  31.635  1.00 48.02          
ATOM   2203  CD2 LEU   281      -7.383   0.073  33.349  1.00 47.94          
ATOM   2204  N   THR   282      -8.259   3.012  29.018  1.00 46.51          
ATOM   2205  CA  THR   282      -9.011   3.086  27.779  1.00 46.62          
ATOM   2206  C   THR   282      -8.209   2.592  26.578  1.00 47.68          
ATOM   2207  O   THR   282      -8.715   1.818  25.766  1.00 48.50          
ATOM   2208  CB  THR   282      -9.477   4.525  27.521  1.00 46.54          
ATOM   2209  OG1 THR   282     -10.263   4.981  28.627  1.00 44.95          
ATOM   2210  CG2 THR   282     -10.313   4.591  26.265  1.00 48.15          
ATOM   2211  N   TRP   283      -6.960   3.041  26.478  1.00 49.10          
ATOM   2212  CA  TRP   283      -6.054   2.668  25.387  1.00 48.96          
ATOM   2213  C   TRP   283      -5.796   1.160  25.333  1.00 48.30          
ATOM   2214  O   TRP   283      -5.877   0.555  24.268  1.00 48.47          
ATOM   2215  CB  TRP   283      -4.710   3.386  25.551  1.00 50.31          
ATOM   2216  CG  TRP   283      -3.929   3.535  24.282  1.00 53.10          
ATOM   2217  CD1 TRP   283      -3.892   4.632  23.471  1.00 53.65          
ATOM   2218  CD2 TRP   283      -3.116   2.541  23.645  1.00 53.31          
ATOM   2219  NE1 TRP   283      -3.107   4.384  22.379  1.00 53.64          
ATOM   2220  CE2 TRP   283      -2.611   3.113  22.464  1.00 53.34          
ATOM   2221  CE3 TRP   283      -2.748   1.233  23.970  1.00 54.28          
ATOM   2222  CZ2 TRP   283      -1.788   2.417  21.588  1.00 55.15          
ATOM   2223  CZ3 TRP   283      -1.924   0.534  23.101  1.00 54.82          
ATOM   2224  CH2 TRP   283      -1.443   1.133  21.924  1.00 55.31          
ATOM   2225  N   PHE   284      -5.472   0.568  26.480  1.00 47.17          
ATOM   2226  CA  PHE   284      -5.194  -0.858  26.554  1.00 45.95          
ATOM   2227  C   PHE   284      -6.413  -1.712  26.276  1.00 46.16          
ATOM   2228  O   PHE   284      -6.318  -2.934  26.213  1.00 47.88          
ATOM   2229  CB  PHE   284      -4.607  -1.229  27.922  1.00 42.99          
ATOM   2230  CG  PHE   284      -3.119  -1.052  28.005  1.00 40.18          
ATOM   2231  CD1 PHE   284      -2.281  -1.783  27.178  1.00 38.71          
ATOM   2232  CD2 PHE   284      -2.555  -0.133  28.888  1.00 40.20          
ATOM   2233  CE1 PHE   284      -0.906  -1.610  27.230  1.00 38.81          
ATOM   2234  CE2 PHE   284      -1.174   0.054  28.951  1.00 38.51          
ATOM   2235  CZ  PHE   284      -0.352  -0.684  28.118  1.00 39.99          
ATOM   2236  N   LYS   285      -7.569  -1.093  26.111  1.00 46.47          
ATOM   2237  CA  LYS   285      -8.747  -1.884  25.829  1.00 47.62          
ATOM   2238  C   LYS   285      -9.215  -1.695  24.405  1.00 48.73          
ATOM   2239  O   LYS   285      -9.863  -2.571  23.847  1.00 49.63          
ATOM   2240  CB  LYS   285      -9.860  -1.528  26.789  1.00 47.52          
ATOM   2241  CG  LYS   285      -9.475  -1.804  28.215  1.00 49.56          
ATOM   2242  CD  LYS   285     -10.683  -1.752  29.140  1.00 51.10          
ATOM   2243  CE  LYS   285     -11.397  -3.104  29.245  1.00 51.69          
ATOM   2244  NZ  LYS   285     -10.700  -4.102  30.117  1.00 51.69          
ATOM   2245  N   ASN   286      -8.868  -0.558  23.814  1.00 49.04          
ATOM   2246  CA  ASN   286      -9.260  -0.247  22.453  1.00 50.46          
ATOM   2247  C   ASN   286      -8.121  -0.338  21.443  1.00 50.96          
ATOM   2248  O   ASN   286      -8.236   0.171  20.333  1.00 51.83          
ATOM   2249  CB  ASN   286      -9.847   1.164  22.407  1.00 52.33          
ATOM   2250  CG  ASN   286     -11.065   1.320  23.282  1.00 54.53          
ATOM   2251  OD1 ASN   286     -11.519   2.441  23.545  1.00 55.13          
ATOM   2252  ND2 ASN   286     -11.610   0.197  23.740  1.00 55.49          
ATOM   2253  N   LYS   287      -7.020  -0.974  21.809  1.00 49.95          
ATOM   2254  CA  LYS   287      -5.896  -1.048  20.890  1.00 50.52          
ATOM   2255  C   LYS   287      -5.153  -2.352  21.034  1.00 51.97          
ATOM   2256  O   LYS   287      -4.591  -2.877  20.072  1.00 52.44          
ATOM   2257  CB  LYS   287      -4.909   0.091  21.161  1.00 50.17          
ATOM   2258  CG  LYS   287      -5.476   1.494  21.098  1.00 48.41          
ATOM   2259  CD  LYS   287      -5.691   1.932  19.669  1.00 49.42          
ATOM   2260  CE  LYS   287      -5.956   3.434  19.586  1.00 50.59          
ATOM   2261  NZ  LYS   287      -4.832   4.254  20.139  1.00 50.42          
ATOM   2262  N   MET   288      -5.140  -2.869  22.252  1.00 54.12          
ATOM   2263  CA  MET   288      -4.431  -4.106  22.540  1.00 56.02          
ATOM   2264  C   MET   288      -5.382  -5.213  22.882  1.00 54.23          
ATOM   2265  O   MET   288      -6.522  -4.988  23.288  1.00 53.68          
ATOM   2266  CB  MET   288      -3.501  -3.926  23.735  1.00 61.19          
ATOM   2267  CG  MET   288      -2.671  -2.667  23.730  1.00 67.84          
ATOM   2268  SD  MET   288      -1.138  -2.799  22.617  1.00 79.05          
ATOM   2269  CE  MET   288       0.044  -3.697  23.862  1.00 75.12          
ATOM   2270  N   ASN   289      -4.886  -6.422  22.726  1.00 53.34          
ATOM   2271  CA  ASN   289      -5.667  -7.579  23.057  1.00 53.29          
ATOM   2272  C   ASN   289      -5.017  -8.084  24.333  1.00 50.83          
ATOM   2273  O   ASN   289      -4.131  -8.932  24.302  1.00 49.74          
ATOM   2274  CB  ASN   289      -5.564  -8.625  21.953  1.00 56.36          
ATOM   2275  CG  ASN   289      -6.458  -9.808  22.210  1.00 58.29          
ATOM   2276  OD1 ASN   289      -7.680  -9.659  22.324  1.00 58.96          
ATOM   2277  ND2 ASN   289      -5.863 -10.994  22.316  1.00 59.23          
ATOM   2278  N   VAL   290      -5.446  -7.523  25.453  1.00 48.80          
ATOM   2279  CA  VAL   290      -4.910  -7.887  26.751  1.00 47.23          
ATOM   2280  C   VAL   290      -5.792  -8.891  27.489  1.00 45.86          
ATOM   2281  O   VAL   290      -7.021  -8.836  27.398  1.00 44.14          
ATOM   2282  CB  VAL   290      -4.785  -6.651  27.664  1.00 46.63          
ATOM   2283  CG1 VAL   290      -4.015  -7.007  28.914  1.00 46.42          
ATOM   2284  CG2 VAL   290      -4.128  -5.517  26.915  1.00 46.08          
ATOM   2285  N   HSD   291      -5.153  -9.801  28.228  1.00 45.26          
ATOM   2286  CA  HSD   291      -5.853 -10.808  29.039  1.00 43.68          
ATOM   2287  C   HSD   291      -5.984 -10.136  30.408  1.00 41.95          
ATOM   2288  O   HSD   291      -5.090 -10.212  31.242  1.00 41.42          
ATOM   2289  CB  HSD   291      -5.017 -12.093  29.139  1.00 45.12          
ATOM   2290  CG  HSD   291      -5.728 -13.236  29.801  1.00 47.50          
ATOM   2291  ND1 HSD   291      -6.067 -13.231  31.137  1.00 49.19          
ATOM   2292  CD2 HSD   291      -6.129 -14.434  29.315  1.00 48.36          
ATOM   2293  CE1 HSD   291      -6.643 -14.379  31.450  1.00 48.95          
ATOM   2294  NE2 HSD   291      -6.692 -15.126  30.362  1.00 49.58          
ATOM   2295  N   TRP   292      -7.105  -9.462  30.613  1.00 40.90          
ATOM   2296  CA  TRP   292      -7.368  -8.742  31.843  1.00 40.61          
ATOM   2297  C   TRP   292      -7.686  -9.607  33.055  1.00 40.95          
ATOM   2298  O   TRP   292      -8.454 -10.557  32.958  1.00 41.63          
ATOM   2299  CB  TRP   292      -8.526  -7.771  31.636  1.00 40.25          
ATOM   2300  CG  TRP   292      -8.274  -6.779  30.563  1.00 39.85          
ATOM   2301  CD1 TRP   292      -8.661  -6.855  29.260  1.00 38.13          
ATOM   2302  CD2 TRP   292      -7.531  -5.564  30.696  1.00 40.33          
ATOM   2303  NE1 TRP   292      -8.205  -5.752  28.571  1.00 39.14          
ATOM   2304  CE2 TRP   292      -7.509  -4.945  29.429  1.00 40.04          
ATOM   2305  CE3 TRP   292      -6.886  -4.937  31.769  1.00 40.44          
ATOM   2306  CZ2 TRP   292      -6.859  -3.733  29.200  1.00 40.75          
ATOM   2307  CZ3 TRP   292      -6.241  -3.732  31.548  1.00 40.21          
ATOM   2308  CH2 TRP   292      -6.234  -3.139  30.268  1.00 42.10          
ATOM   2309  N   LEU   293      -7.089  -9.257  34.196  1.00 41.00          
ATOM   2310  CA  LEU   293      -7.307  -9.933  35.475  1.00 40.14          
ATOM   2311  C   LEU   293      -8.026  -8.905  36.313  1.00 40.38          
ATOM   2312  O   LEU   293      -7.472  -7.843  36.581  1.00 40.60          
ATOM   2313  CB  LEU   293      -5.984 -10.274  36.154  1.00 38.82          
ATOM   2314  CG  LEU   293      -5.110 -11.199  35.326  1.00 39.72          
ATOM   2315  CD1 LEU   293      -3.797 -11.494  36.031  1.00 38.67          
ATOM   2316  CD2 LEU   293      -5.895 -12.473  35.064  1.00 40.48          
ATOM   2317  N   ASN   294      -9.250  -9.211  36.730  1.00 42.06          
ATOM   2318  CA  ASN   294     -10.041  -8.275  37.536  1.00 42.99          
ATOM   2319  C   ASN   294      -9.539  -8.244  38.994  1.00 42.40          
ATOM   2320  O   ASN   294      -9.800  -9.147  39.767  1.00 43.13          
ATOM   2321  CB  ASN   294     -11.521  -8.682  37.457  1.00 43.12          
ATOM   2322  CG  ASN   294     -12.457  -7.637  38.043  1.00 43.42          
ATOM   2323  OD1 ASN   294     -13.669  -7.699  37.821  1.00 44.84          
ATOM   2324  ND2 ASN   294     -11.906  -6.680  38.800  1.00 41.98          
ATOM   2325  N   LYS   295      -8.811  -7.194  39.348  1.00 43.13          
ATOM   2326  CA  LYS   295      -8.253  -7.047  40.677  1.00 44.01          
ATOM   2327  C   LYS   295      -9.313  -7.034  41.774  1.00 47.25          
ATOM   2328  O   LYS   295      -9.015  -7.299  42.942  1.00 48.02          
ATOM   2329  CB  LYS   295      -7.446  -5.766  40.753  1.00 42.24          
ATOM   2330  CG  LYS   295      -6.686  -5.590  42.016  1.00 42.84          
ATOM   2331  CD  LYS   295      -6.654  -4.138  42.427  1.00 41.97          
ATOM   2332  CE  LYS   295      -5.265  -3.736  42.874  1.00 42.08          
ATOM   2333  NZ  LYS   295      -4.617  -4.779  43.697  1.00 40.12          
ATOM   2334  N   GLU   296     -10.554  -6.736  41.414  1.00 49.88          
ATOM   2335  CA  GLU   296     -11.635  -6.700  42.395  1.00 52.31          
ATOM   2336  C   GLU   296     -12.243  -8.072  42.657  1.00 52.26          
ATOM   2337  O   GLU   296     -13.304  -8.179  43.273  1.00 53.05          
ATOM   2338  CB  GLU   296     -12.728  -5.742  41.914  1.00 54.20          
ATOM   2339  CG  GLU   296     -12.342  -4.282  41.971  1.00 57.99          
ATOM   2340  CD  GLU   296     -13.383  -3.378  41.337  1.00 60.64          
ATOM   2341  OE1 GLU   296     -13.255  -2.139  41.457  1.00 62.59          
ATOM   2342  OE2 GLU   296     -14.328  -3.905  40.710  1.00 60.61          
ATOM   2343  N   ARG   297     -11.552  -9.115  42.213  1.00 52.15          
ATOM   2344  CA  ARG   297     -12.045 -10.478  42.350  1.00 52.31          
ATOM   2345  C   ARG   297     -10.908 -11.491  42.500  1.00 50.64          
ATOM   2346  O   ARG   297     -11.123 -12.649  42.850  1.00 49.87          
ATOM   2347  CB  ARG   297     -12.922 -10.796  41.124  1.00 53.68          
ATOM   2348  CG  ARG   297     -13.339 -12.235  40.948  1.00 58.16          
ATOM   2349  CD  ARG   297     -12.319 -12.955  40.102  1.00 62.33          
ATOM   2350  NE  ARG   297     -12.864 -14.119  39.483  1.00 67.18          
ATOM   2351  CZ  ARG   297     -12.451 -15.380  39.413  1.00 69.01          
ATOM   2352  NH1 ARG   297     -11.343 -15.881  39.961  1.00 68.90          
ATOM   2353  NH2 ARG   297     -13.246 -16.161  38.703  1.00 69.75          
ATOM   2354  N   MET   298      -9.693 -11.038  42.250  1.00 49.65          
ATOM   2355  CA  MET   298      -8.541 -11.903  42.356  1.00 50.50          
ATOM   2356  C   MET   298      -7.472 -11.290  43.238  1.00 48.11          
ATOM   2357  O   MET   298      -7.401 -10.075  43.404  1.00 47.23          
ATOM   2358  CB  MET   298      -7.949 -12.163  40.986  1.00 56.16          
ATOM   2359  CG  MET   298      -8.803 -13.028  40.098  1.00 64.13          
ATOM   2360  SD  MET   298      -7.976 -13.256  38.354  1.00 73.14          
ATOM   2361  CE  MET   298      -9.250 -12.214  37.289  1.00 70.76          
ATOM   2362  N   SER   299      -6.617 -12.143  43.776  1.00 44.79          
ATOM   2363  CA  SER   299      -5.559 -11.700  44.652  1.00 43.78          
ATOM   2364  C   SER   299      -4.202 -11.928  44.027  1.00 43.59          
ATOM   2365  O   SER   299      -4.092 -12.631  43.038  1.00 44.01          
ATOM   2366  CB  SER   299      -5.630 -12.478  45.948  1.00 43.01          
ATOM   2367  OG  SER   299      -5.428 -13.850  45.693  1.00 38.72          
ATOM   2368  N   LEU   300      -3.164 -11.360  44.631  1.00 45.42          
ATOM   2369  CA  LEU   300      -1.813 -11.519  44.113  1.00 46.46          
ATOM   2370  C   LEU   300      -1.527 -12.981  43.790  1.00 46.29          
ATOM   2371  O   LEU   300      -0.977 -13.281  42.736  1.00 47.27          
ATOM   2372  CB  LEU   300      -0.793 -10.992  45.119  1.00 46.38          
ATOM   2373  CG  LEU   300       0.675 -11.080  44.682  1.00 47.84          
ATOM   2374  CD1 LEU   300       0.876 -10.362  43.352  1.00 45.68          
ATOM   2375  CD2 LEU   300       1.578 -10.470  45.764  1.00 48.95          
ATOM   2376  N   GLN   301      -1.914 -13.884  44.686  1.00 45.54          
ATOM   2377  CA  GLN   301      -1.695 -15.308  44.478  1.00 46.12          
ATOM   2378  C   GLN   301      -2.615 -15.887  43.416  1.00 47.69          
ATOM   2379  O   GLN   301      -2.218 -16.753  42.641  1.00 47.50          
ATOM   2380  CB  GLN   301      -1.924 -16.082  45.763  1.00 46.17          
ATOM   2381  CG  GLN   301      -1.622 -17.564  45.643  1.00 46.12          
ATOM   2382  CD  GLN   301      -0.136 -17.838  45.601  1.00 45.52          
ATOM   2383  OE1 GLN   301       0.572 -17.307  44.754  1.00 44.36          
ATOM   2384  NE2 GLN   301       0.346 -18.671  46.524  1.00 45.99          
ATOM   2385  N   MET   302      -3.861 -15.439  43.399  1.00 49.31          
ATOM   2386  CA  MET   302      -4.797 -15.938  42.409  1.00 51.32          
ATOM   2387  C   MET   302      -4.385 -15.528  41.006  1.00 52.45          
ATOM   2388  O   MET   302      -4.563 -16.285  40.061  1.00 52.64          
ATOM   2389  CB  MET   302      -6.200 -15.436  42.704  1.00 52.89          
ATOM   2390  CG  MET   302      -6.855 -16.153  43.851  1.00 57.45          
ATOM   2391  SD  MET   302      -8.378 -15.173  44.471  1.00 62.65          
ATOM   2392  CE  MET   302      -9.628 -15.560  43.052  1.00 62.89          
ATOM   2393  N   MET   303      -3.845 -14.325  40.867  1.00 53.09          
ATOM   2394  CA  MET   303      -3.406 -13.857  39.571  1.00 53.97          
ATOM   2395  C   MET   303      -2.217 -14.696  39.122  1.00 52.85          
ATOM   2396  O   MET   303      -2.169 -15.134  37.982  1.00 52.25          
ATOM   2397  CB  MET   303      -2.999 -12.391  39.643  1.00 57.76          
ATOM   2398  CG  MET   303      -4.109 -11.452  40.071  1.00 63.73          
ATOM   2399  SD  MET   303      -3.617  -9.563  39.822  1.00 70.50          
ATOM   2400  CE  MET   303      -3.534  -8.998  41.681  1.00 70.66          
ATOM   2401  N   LEU   304      -1.267 -14.928  40.027  1.00 52.23          
ATOM   2402  CA  LEU   304      -0.086 -15.718  39.706  1.00 51.04          
ATOM   2403  C   LEU   304      -0.471 -17.097  39.207  1.00 51.98          
ATOM   2404  O   LEU   304       0.309 -17.748  38.525  1.00 53.52          
ATOM   2405  CB  LEU   304       0.837 -15.844  40.922  1.00 49.65          
ATOM   2406  CG  LEU   304       2.130 -16.655  40.773  1.00 47.72          
ATOM   2407  CD1 LEU   304       2.999 -16.079  39.681  1.00 46.43          
ATOM   2408  CD2 LEU   304       2.876 -16.643  42.087  1.00 46.76          
ATOM   2409  N   ASP   305      -1.671 -17.551  39.540  1.00 53.53          
ATOM   2410  CA  ASP   305      -2.109 -18.859  39.081  1.00 54.88          
ATOM   2411  C   ASP   305      -2.729 -18.774  37.718  1.00 54.61          
ATOM   2412  O   ASP   305      -2.629 -19.709  36.933  1.00 55.30          
ATOM   2413  CB  ASP   305      -3.099 -19.477  40.055  1.00 56.92          
ATOM   2414  CG  ASP   305      -2.415 -20.011  41.284  1.00 60.74          
ATOM   2415  OD1 ASP   305      -1.398 -20.735  41.116  1.00 62.71          
ATOM   2416  OD2 ASP   305      -2.884 -19.724  42.412  1.00 61.25          
ATOM   2417  N   GLU   306      -3.393 -17.660  37.445  1.00 55.22          
ATOM   2418  CA  GLU   306      -4.012 -17.454  36.147  1.00 55.87          
ATOM   2419  C   GLU   306      -2.905 -17.445  35.105  1.00 55.93          
ATOM   2420  O   GLU   306      -3.042 -18.029  34.029  1.00 56.27          
ATOM   2421  CB  GLU   306      -4.748 -16.122  36.124  1.00 57.59          
ATOM   2422  CG  GLU   306      -6.257 -16.253  36.166  1.00 61.17          
ATOM   2423  CD  GLU   306      -6.816 -16.815  34.885  1.00 62.73          
ATOM   2424  OE1 GLU   306      -6.546 -16.211  33.817  1.00 63.01          
ATOM   2425  OE2 GLU   306      -7.521 -17.852  34.950  1.00 64.03          
ATOM   2426  N   ILE   307      -1.805 -16.778  35.443  1.00 55.01          
ATOM   2427  CA  ILE   307      -0.650 -16.667  34.563  1.00 54.51          
ATOM   2428  C   ILE   307       0.085 -17.996  34.460  1.00 54.74          
ATOM   2429  O   ILE   307       0.626 -18.335  33.411  1.00 53.61          
ATOM   2430  CB  ILE   307       0.339 -15.581  35.081  1.00 53.45          
ATOM   2431  CG1 ILE   307      -0.316 -14.207  35.000  1.00 53.10          
ATOM   2432  CG2 ILE   307       1.616 -15.576  34.253  1.00 53.14          
ATOM   2433  CD  ILE   307       0.533 -13.103  35.547  1.00 51.89          
ATOM   2434  N   THR   308       0.094 -18.752  35.551  1.00 55.72          
ATOM   2435  CA  THR   308       0.789 -20.028  35.573  1.00 57.22          
ATOM   2436  C   THR   308       0.082 -21.019  34.656  1.00 57.78          
ATOM   2437  O   THR   308       0.712 -21.883  34.057  1.00 58.79          
ATOM   2438  CB  THR   308       0.891 -20.562  37.028  1.00 57.17          
ATOM   2439  OG1 THR   308       2.063 -21.375  37.156  1.00 57.44          
ATOM   2440  CG2 THR   308      -0.331 -21.372  37.397  1.00 58.77          
ATOM   2441  N   THR   309      -1.228 -20.869  34.523  1.00 58.23          
ATOM   2442  CA  THR   309      -2.000 -21.748  33.664  1.00 58.17          
ATOM   2443  C   THR   309      -1.745 -21.379  32.214  1.00 57.88          
ATOM   2444  O   THR   309      -1.687 -22.234  31.336  1.00 57.72          
ATOM   2445  CB  THR   309      -3.494 -21.600  33.955  1.00 59.17          
ATOM   2446  OG1 THR   309      -3.746 -21.966  35.317  1.00 59.29          
ATOM   2447  CG2 THR   309      -4.319 -22.476  33.022  1.00 59.28          
ATOM   2448  N   GLN   310      -1.598 -20.086  31.977  1.00 58.69          
ATOM   2449  CA  GLN   310      -1.347 -19.579  30.646  1.00 59.14          
ATOM   2450  C   GLN   310       0.065 -19.993  30.215  1.00 59.03          
ATOM   2451  O   GLN   310       0.296 -20.278  29.046  1.00 60.40          
ATOM   2452  CB  GLN   310      -1.489 -18.054  30.644  1.00 59.01          
ATOM   2453  CG  GLN   310      -2.202 -17.467  29.433  1.00 59.91          
ATOM   2454  CD  GLN   310      -3.696 -17.758  29.409  1.00 59.59          
ATOM   2455  OE1 GLN   310      -4.416 -17.289  28.525  1.00 58.69          
ATOM   2456  NE2 GLN   310      -4.168 -18.532  30.378  1.00 58.43          
ATOM   2457  N   ILE   311       1.003 -20.039  31.157  1.00 58.73          
ATOM   2458  CA  ILE   311       2.376 -20.425  30.835  1.00 59.08          
ATOM   2459  C   ILE   311       2.537 -21.934  30.661  1.00 61.03          
ATOM   2460  O   ILE   311       3.463 -22.396  29.979  1.00 60.61          
ATOM   2461  CB  ILE   311       3.380 -19.950  31.918  1.00 57.94          
ATOM   2462  CG1 ILE   311       3.404 -18.424  31.978  1.00 56.82          
ATOM   2463  CG2 ILE   311       4.774 -20.463  31.601  1.00 56.28          
ATOM   2464  CD  ILE   311       4.156 -17.877  33.159  1.00 56.25          
ATOM   2465  N   ASN   312       1.653 -22.710  31.286  1.00 61.99          
ATOM   2466  CA  ASN   312       1.719 -24.167  31.149  1.00 62.47          
ATOM   2467  C   ASN   312       1.166 -24.608  29.776  1.00 64.15          
ATOM   2468  O   ASN   312       0.939 -25.796  29.548  1.00 64.42          
ATOM   2469  CB  ASN   312       0.962 -24.876  32.295  1.00 61.80          
ATOM   2470  CG  ASN   312       1.702 -24.806  33.644  1.00 60.42          
ATOM   2471  OD1 ASN   312       2.883 -24.439  33.716  1.00 60.65          
ATOM   2472  ND2 ASN   312       1.003 -25.178  34.715  1.00 57.04          
ATOM   2473  N   LYS   313       0.990 -23.648  28.861  1.00 65.63          
ATOM   2474  CA  LYS   313       0.534 -23.932  27.492  1.00 67.33          
ATOM   2475  C   LYS   313       1.699 -23.596  26.559  1.00 68.99          
ATOM   2476  O   LYS   313       2.085 -24.409  25.706  1.00 68.36          
ATOM   2477  CB  LYS   313      -0.703 -23.097  27.105  1.00 66.37          
ATOM   2478  CG  LYS   313      -1.966 -23.428  27.904  1.00 65.14          
ATOM   2479  CD  LYS   313      -2.291 -24.916  27.830  1.00 64.60          
ATOM   2480  CE  LYS   313      -3.074 -25.401  29.056  1.00 63.38          
ATOM   2481  NZ  LYS   313      -3.453 -26.856  28.978  1.00 60.24          
ATOM   2482  N   ARG   314       2.267 -22.402  26.745  1.00 71.80          
ATOM   2483  CA  ARG   314       3.410 -21.937  25.948  1.00 74.39          
ATOM   2484  C   ARG   314       4.544 -22.959  26.006  1.00 75.46          
ATOM   2485  O   ARG   314       5.475 -22.905  25.199  1.00 76.09          
ATOM   2486  CB  ARG   314       3.946 -20.593  26.469  1.00 73.93          
ATOM   2487  CG  ARG   314       3.064 -19.379  26.240  1.00 74.77          
ATOM   2488  CD  ARG   314       2.928 -19.011  24.764  1.00 75.33          
ATOM   2489  NE  ARG   314       2.398 -17.655  24.608  1.00 75.78          
ATOM   2490  CZ  ARG   314       1.191 -17.260  25.009  1.00 75.66          
ATOM   2491  NH1 ARG   314       0.364 -18.116  25.589  1.00 76.05          
ATOM   2492  NH2 ARG   314       0.815 -15.997  24.857  1.00 75.79          
ATOM   2493  N   SER   315       4.472 -23.873  26.973  1.00 76.96          
ATOM   2494  CA  SER   315       5.494 -24.906  27.118  1.00 79.42          
ATOM   2495  C   SER   315       4.966 -26.290  26.719  1.00 80.34          
ATOM   2496  O   SER   315       5.372 -26.766  25.630  1.00 80.78          
ATOM   2497  CB  SER   315       6.047 -24.927  28.561  1.00 79.23          
ATOM   2498  OG  SER   315       5.022 -25.081  29.532  1.00 79.03          
END
