
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  244 ( 1945),  selected  244 , name 2qgn_A
# Molecule2: number of CA atoms  232 ( 1859),  selected  232 , name T0416_6_115_194_315.pdb
# PARAMETERS: 2qgn_A.T0416_6_115_194_315.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     2_A      K       6           #
LGA    E     3_A      P       7          1.039
LGA    K     4_A      F       8          1.034
LGA    L     5_A      L       9          0.717
LGA    V     6_A      I      10          1.056
LGA    A     7_A      V      11          0.837
LGA    I     8_A      I      12          1.017
LGA    V     9_A      V      13          1.320
LGA    G    10_A      G      14          1.886
LGA    P    11_A      P      15          1.890
LGA    T    12_A      T      16          1.749
LGA    A    13_A      A      17          2.466
LGA    V    14_A      S      18          1.577
LGA    G    15_A      G      19          1.112
LGA    K    16_A      K      20          0.768
LGA    T    17_A      T      21          0.177
LGA    K    18_A      E      22          0.892
LGA    T    19_A      L      23          0.923
LGA    S    20_A      S      24          0.861
LGA    V    21_A      I      25          0.615
LGA    X    22_A      E      26          0.554
LGA    L    23_A      V      27          0.869
LGA    A    24_A      A      28          0.946
LGA    K    25_A      K      29          0.806
LGA    R    26_A      K      30          1.165
LGA    L    27_A      F      31          1.534
LGA    N    28_A      N      32          1.729
LGA    G    29_A      G      33          0.991
LGA    E    30_A      E      34          0.578
LGA    V    31_A      I      35          0.333
LGA    I    32_A      I      36          0.417
LGA    S    33_A      S      37          0.626
LGA    G    34_A      G      38          0.709
LGA    D    35_A      D      39          0.240
LGA    S    36_A      S      40          1.122
LGA    X    37_A      M      41          0.495
LGA    Q    38_A      Q      42          0.503
LGA    V    39_A      V      43          0.682
LGA    Y    40_A      Y      44          0.650
LGA    R    41_A      Q      45          0.883
LGA    G    42_A      G      46          1.425
LGA    X    43_A      M      47          1.214
LGA    D    44_A      D      48          0.966
LGA    I    45_A      I      49          0.991
LGA    G    46_A      G      50          1.108
LGA    T    47_A      T      51          1.082
LGA    A    48_A      A      52          1.134
LGA    K    49_A      K      53          0.685
LGA    I    50_A      V      54          0.477
LGA    T    51_A      T      55          0.956
LGA    A    52_A      T      56          1.722
LGA    E    53_A      E      57          2.318
LGA    E    54_A      E      58          2.029
LGA    X    55_A      M      59          1.267
LGA    D    56_A      E      60          1.097
LGA    G    57_A      G      61          1.477
LGA    V    58_A      I      62          0.953
LGA    P    59_A      P      63          0.699
LGA    H    60_A      X      64          0.454
LGA    H    61_A      Y      65          0.188
LGA    L    62_A      M      66          0.328
LGA    I    63_A      I      67          0.230
LGA    D    64_A      D      68          0.462
LGA    I    65_A      I      69          0.405
LGA    K    66_A      L      70          0.402
LGA    D    67_A      P      71          0.366
LGA    P    68_A      P      72          1.000
LGA    S    69_A      D      73          1.365
LGA    E    70_A      A      74          1.057
LGA    S    71_A      S      75          1.385
LGA    F    72_A      F      76          0.971
LGA    S    73_A      S      77          1.415
LGA    V    74_A      A      78          1.480
LGA    A    75_A      Y      79          2.160
LGA    D    76_A      E      80          1.615
LGA    F    77_A      F      81          0.986
LGA    Q    78_A      K      82          1.247
LGA    D    79_A      K      83          1.359
LGA    L    80_A      R      84          0.503
LGA    A    81_A      A      85          0.489
LGA    T    82_A      E      86          0.446
LGA    P    83_A      K      87          0.446
LGA    L    84_A      Y      88          0.448
LGA    I    85_A      I      89          0.375
LGA    T    86_A      K      90          0.249
LGA    E    87_A      D      91          0.163
LGA    I    88_A      I      92          0.279
LGA    H    89_A      T      93          0.531
LGA    E    90_A      R      94          1.214
LGA    R    91_A      R      95          1.225
LGA    G    92_A      G      96          0.839
LGA    R    93_A      K      97          0.773
LGA    L    94_A      V      98          0.710
LGA    P    95_A      P      99          0.460
LGA    F    96_A      I     100          0.640
LGA    L    97_A      I     101          1.320
LGA    V    98_A      A     102          1.224
LGA    G    99_A      G     103          1.090
LGA    G   100_A      G     104          1.044
LGA    T   101_A      T     105          1.135
LGA    G   102_A      G     106          0.553
LGA    L   103_A      L     107          0.624
LGA    Y   104_A      Y     108          0.673
LGA    V   105_A      I     109          0.773
LGA    N   106_A      Q     110          1.075
LGA    A   107_A      S     111          1.239
LGA    V   108_A      L     112          1.089
LGA    I   109_A      L     113          1.038
LGA    H   110_A      Y     114          1.305
LGA    Q   111_A      N     115          3.657
LGA    F   112_A      -       -           -
LGA    N   113_A      -       -           -
LGA    L   114_A      -       -           -
LGA    G   115_A      -       -           -
LGA    E   185_A      -       -           -
LGA    T   186_A      -       -           -
LGA    P   187_A      -       -           -
LGA    S   188_A      E     194          0.720
LGA    P   189_A      N     195          2.027
LGA    Y   190_A      Y     196          1.001
LGA    N   191_A      D     197          0.589
LGA    L   192_A      T     198          0.683
LGA    V   193_A      L     199          0.796
LGA    X   194_A      L     200          0.624
LGA    I   195_A      I     201          0.661
LGA    G   196_A      G     202          1.095
LGA    L   197_A      I     203          0.869
LGA    T   198_A      E     204          0.406
LGA    X   199_A      M     205          1.266
LGA    E   200_A      S     206          1.941
LGA    R   201_A      R     207          1.548
LGA    D   202_A      E     208          1.635
LGA    V   203_A      T     209          1.573
LGA    L   204_A      L     210          1.467
LGA    Y   205_A      Y     211          1.419
LGA    D   206_A      L     212          1.447
LGA    R   207_A      R     213          1.360
LGA    I   208_A      I     214          1.044
LGA    N   209_A      N     215          1.021
LGA    R   210_A      K     216          1.110
LGA    R   211_A      R     217          0.817
LGA    V   212_A      V     218          0.870
LGA    D   213_A      D     219          0.960
LGA    Q   214_A      I     220          1.154
LGA    X   215_A      M     221          1.010
LGA    V   216_A      L     222          0.734
LGA    E   217_A      G     223          1.060
LGA    E   218_A      X     224          0.958
LGA    G   219_A      G     225          0.947
LGA    L   220_A      L     226          0.748
LGA    I   221_A      F     227          0.766
LGA    D   222_A      N     228          1.205
LGA    E   223_A      E     229          0.889
LGA    A   224_A      V     230          0.712
LGA    K   225_A      Q     231          1.463
LGA    K   226_A      X     232          1.644
LGA    L   227_A      L     233          1.068
LGA    Y   228_A      V     234          1.075
LGA    D   229_A      E     235          1.606
LGA    R   230_A      Q     236          1.425
LGA    G   231_A      G     237          0.991
LGA    I   232_A      F     238          0.992
LGA    R   233_A      E     239          1.647
LGA    D   234_A      A     240          1.806
LGA    C   235_A      S     241          1.583
LGA    Q   236_A      Q     242          1.586
LGA    S   237_A      S     243          1.024
LGA    V   238_A      M     244          0.298
LGA    Q   239_A      Q     245          0.352
LGA    A   240_A      A     246          0.727
LGA    I   241_A      I     247          1.280
LGA    G   242_A      G     248          1.553
LGA    Y   243_A      Y     249          0.640
LGA    K   244_A      K     250          0.640
LGA    E   245_A      E     251          0.868
LGA    X   246_A      L     252          0.517
LGA    Y   247_A      V     253          0.917
LGA    D   248_A      P     254          2.451
LGA    Y   249_A      V     255          1.625
LGA    L   250_A      I     256          1.866
LGA    D   251_A      K     257          3.319
LGA    G   252_A      G     258          2.928
LGA    N   253_A      N     259          2.918
LGA    V   254_A      I     260          1.536
LGA    T   255_A      S     261          0.310
LGA    L   256_A      M     262          0.567
LGA    E   257_A      E     263          1.303
LGA    E   258_A      N     264          1.115
LGA    A   259_A      A     265          1.011
LGA    I   260_A      V     266          1.178
LGA    D   261_A      E     267          1.556
LGA    T   262_A      K     268          0.871
LGA    L   263_A      L     269          0.637
LGA    K   264_A      K     270          0.657
LGA    R   265_A      Q     271          0.666
LGA    N   266_A      X     272          0.588
LGA    S   267_A      S     273          0.410
LGA    R   268_A      R     274          0.722
LGA    R   269_A      Q     275          0.700
LGA    Y   270_A      Y     276          0.487
LGA    A   271_A      A     277          0.460
LGA    K   272_A      K     278          0.414
LGA    R   273_A      R     279          0.344
LGA    Q   274_A      Q     280          0.322
LGA    L   275_A      L     281          0.365
LGA    T   276_A      T     282          0.547
LGA    W   277_A      W     283          0.275
LGA    F   278_A      F     284          0.132
LGA    R   279_A      K     285          0.816
LGA    N   280_A      N     286          0.981
LGA    K   281_A      K     287          2.043
LGA    A   282_A      M     288          3.703
LGA    N   283_A      N     289          2.403
LGA    V   284_A      V     290          1.176
LGA    T   285_A      X     291          0.836
LGA    W   286_A      W     292          0.868
LGA    F   287_A      L     293          0.753
LGA    D   288_A      N     294          0.945
LGA    X   289_A      K     295          1.144
LGA    T   290_A      E     296          2.198
LGA    D   291_A      R     297          5.727
LGA    V   292_A      M     298          3.319
LGA    D   293_A      S     299          2.727
LGA    F   294_A      L     300          1.945
LGA    D   295_A      Q     301          2.234
LGA    K   296_A      M     302          2.296
LGA    K   297_A      M     303          2.545
LGA    I   298_A      L     304          1.529
LGA    X   299_A      D     305          1.060
LGA    E   300_A      E     306          1.778
LGA    I   301_A      I     307          2.027
LGA    H   302_A      T     308          1.796
LGA    N   303_A      T     309          1.297
LGA    F   304_A      Q     310          1.559
LGA    I   305_A      -       -           -
LGA    A   306_A      I     311          0.623
LGA    G   307_A      N     312          3.425
LGA    K   308_A      K     313          4.423
LGA    L   309_A      R     314          2.372
LGA    E   310_A      S     315          3.353
LGA    E   311_A      -       -           -
LGA    K   312_A      -       -           -
LGA    S   313_A      -       -           -
LGA    K   314_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  244  232    5.0    231    1.39    46.32     93.816    15.534

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.692283 * X  +   0.318337 * Y  +   0.647615 * Z  +  -8.244802
  Y_new =  -0.222889 * X  +  -0.759231 * Y  +   0.611465 * Z  +  12.291361
  Z_new =   0.686341 * X  +  -0.567653 * Y  +  -0.454649 * Z  +  31.883675 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.246103    0.895490  [ DEG:  -128.6922     51.3078 ]
  Theta =  -0.756446   -2.385146  [ DEG:   -43.3412   -136.6588 ]
  Phi   =  -0.311481    2.830112  [ DEG:   -17.8466    162.1534 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2qgn_A                                        
REMARK     2: T0416_6_115_194_315.pdb                       
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2qgn_A.T0416_6_115_194_315.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  244  232   5.0  231   1.39   46.32  93.816
REMARK  ---------------------------------------------------------- 
MOLECULE 2qgn_A
HEADER    TRANSFERASE                             29-JUN-07   2QGN              
TITLE     CRYSTAL STRUCTURE OF TRNA ISOPENTENYLPYROPHOSPHATE                    
TITLE    2 TRANSFERASE (BH2366) FROM BACILLUS HALODURANS, NORTHEAST             
TITLE    3 STRUCTURAL GENOMICS CONSORTIUM TARGET BHR41.                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRNA DELTA(2)-ISOPENTENYLPYROPHOSPHATE                     
COMPND   3 TRANSFERASE;                                                         
COMPND   4 CHAIN: A;                                                            
COMPND   5 SYNONYM: IPP TRANSFERASE, ISOPENTENYL-DIPHOSPHATE:TRNA               
COMPND   6 ISOPENTENYLTRANSFERASE, IPTASE, IPPT;                                
COMPND   7 EC: 2.5.1.8;                                                         
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS HALODURANS C-125;                      
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: C-125, DSM 18197, FERM 7344, JCM 9153;                       
SOURCE   5 ATCC: BAA-125;                                                       
SOURCE   6 GENE: MIAA, BH2366;                                                  
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)+MAGIC;                           
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_VECTOR: BL21;                                      
SOURCE  12 EXPRESSION_SYSTEM_PLASMID: PET21                                     
KEYWDS    ALPHA-BETA PROTEIN, STRUCTURAL GENOMICS, PSI-2, PROTEIN               
KEYWDS   2 STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL GENOMICS                  
KEYWDS   3 CONSORTIUM, NESG                                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    F.FOROUHAR,H.NEELY,M.ABASHIDZE,J.SEETHARAMAN,R.SHASTRY,               
AUTHOR   2 H.JANJUA,K.CUNNINGHAM,L-C.MA,R.XIAO,J.LIU,M.C.BARAN,                 
AUTHOR   3 T.B.ACTON,B.ROST,G.T.MONTELIONE,L.TONG,J.F.HUNT,NORTHEAST            
AUTHOR   4 STRUCTURAL GENOMICS CONSORTIUM (NESG)                                
REVDAT   1   17-JUL-07 2QGN    0                                                
JRNL        AUTH   F.FOROUHAR,H.NEELY,M.ABASHIDZE,J.SEETHARAMAN,                
JRNL        AUTH 2 R.SHASTRY,H.JANJUA,K.CUNNINGHAM,L-C.MA,R.XIAO,               
JRNL        AUTH 3 J.LIU,M.C.BARAN,T.B.ACTON,B.ROST,G.T.MONTELIONE,             
JRNL        AUTH 4 L.TONG,J.F.HUNT                                              
JRNL        TITL   CRYSTAL STRUCTURE OF TRNA ISOPENTENYLPYROPHOSPHATE           
JRNL        TITL 2 TRANSFERASE (BH2366) FROM BACILLUS HALODURANS.               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.40 ANGSTROMS.                                          
DBREF  2QGN A    1   314  UNP    Q9KAC3   MIAA_BACHD       1    314             
SEQRES   1 A  322  MSE LYS GLU LYS LEU VAL ALA ILE VAL GLY PRO THR ALA          
SEQRES   2 A  322  VAL GLY LYS THR LYS THR SER VAL MSE LEU ALA LYS ARG          
SEQRES   3 A  322  LEU ASN GLY GLU VAL ILE SER GLY ASP SER MSE GLN VAL          
SEQRES   4 A  322  TYR ARG GLY MSE ASP ILE GLY THR ALA LYS ILE THR ALA          
SEQRES   5 A  322  GLU GLU MSE ASP GLY VAL PRO HIS HIS LEU ILE ASP ILE          
SEQRES   6 A  322  LYS ASP PRO SER GLU SER PHE SER VAL ALA ASP PHE GLN          
SEQRES   7 A  322  ASP LEU ALA THR PRO LEU ILE THR GLU ILE HIS GLU ARG          
SEQRES   8 A  322  GLY ARG LEU PRO PHE LEU VAL GLY GLY THR GLY LEU TYR          
SEQRES   9 A  322  VAL ASN ALA VAL ILE HIS GLN PHE ASN LEU GLY ASP ILE          
SEQRES  10 A  322  ARG ALA ASP GLU ASP TYR ARG HIS GLU LEU GLU ALA PHE          
SEQRES  11 A  322  VAL ASN SER TYR GLY VAL GLN ALA LEU HIS ASP LYS LEU          
SEQRES  12 A  322  SER LYS ILE ASP PRO LYS ALA ALA ALA ALA ILE HIS PRO          
SEQRES  13 A  322  ASN ASN TYR ARG ARG VAL ILE ARG ALA LEU GLU ILE ILE          
SEQRES  14 A  322  LYS LEU THR GLY LYS THR VAL THR GLU GLN ALA ARG HIS          
SEQRES  15 A  322  GLU GLU GLU THR PRO SER PRO TYR ASN LEU VAL MSE ILE          
SEQRES  16 A  322  GLY LEU THR MSE GLU ARG ASP VAL LEU TYR ASP ARG ILE          
SEQRES  17 A  322  ASN ARG ARG VAL ASP GLN MSE VAL GLU GLU GLY LEU ILE          
SEQRES  18 A  322  ASP GLU ALA LYS LYS LEU TYR ASP ARG GLY ILE ARG ASP          
SEQRES  19 A  322  CYS GLN SER VAL GLN ALA ILE GLY TYR LYS GLU MSE TYR          
SEQRES  20 A  322  ASP TYR LEU ASP GLY ASN VAL THR LEU GLU GLU ALA ILE          
SEQRES  21 A  322  ASP THR LEU LYS ARG ASN SER ARG ARG TYR ALA LYS ARG          
SEQRES  22 A  322  GLN LEU THR TRP PHE ARG ASN LYS ALA ASN VAL THR TRP          
SEQRES  23 A  322  PHE ASP MSE THR ASP VAL ASP PHE ASP LYS LYS ILE MSE          
SEQRES  24 A  322  GLU ILE HIS ASN PHE ILE ALA GLY LYS LEU GLU GLU LYS          
SEQRES  25 A  322  SER LYS LEU GLU HIS HIS HIS HIS HIS HIS                      
HET    MSE  A  22       8                                                       
HET    MSE  A  37       8                                                       
HET    MSE  A  43       8                                                       
HET    MSE  A  55       8                                                       
HET    MSE  A 194       8                                                       
HET    MSE  A 199       8                                                       
HET    MSE  A 215       8                                                       
HET    MSE  A 246       8                                                       
HET    MSE  A 289       8                                                       
HET    MSE  A 299       8                                                       
HET    SO4  A 401       5                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SO4 SULFATE ION                                                      
FORMUL   1  MSE    10(C5 H11 N O2 SE)                                           
FORMUL   2  SO4    O4 S 2-                                                      
FORMUL   3  HOH   *35(H2 O)                                                     
CRYST1   50.855   50.855  204.697  90.00  90.00 120.00 P 61          6          
ATOM      1  N   LYS A   2      15.402 -13.134  21.432  1.00 57.08           N  
ATOM      2  CA  LYS A   2      14.211 -12.262  21.270  1.00 57.13           C  
ATOM      3  C   LYS A   2      13.001 -12.997  20.669  1.00 56.86           C  
ATOM      4  O   LYS A   2      12.403 -12.533  19.696  1.00 58.02           O  
ATOM      5  CB  LYS A   2      14.582 -11.046  20.412  1.00 59.39           C  
ATOM      6  CG  LYS A   2      15.203 -11.395  19.058  1.00 61.88           C  
ATOM      7  CD  LYS A   2      15.945 -10.205  18.436  1.00 64.20           C  
ATOM      8  CE  LYS A   2      15.032  -9.000  18.226  1.00 65.05           C  
ATOM      9  NZ  LYS A   2      15.730  -7.898  17.507  1.00 64.61           N  
ATOM     10  N   GLU A   3      12.651 -14.143  21.253  1.00 54.60           N  
ATOM     11  CA  GLU A   3      11.509 -14.935  20.795  1.00 51.70           C  
ATOM     12  C   GLU A   3      10.336 -14.738  21.753  1.00 49.87           C  
ATOM     13  O   GLU A   3       9.427 -13.956  21.476  1.00 50.92           O  
ATOM     14  CB  GLU A   3      11.863 -16.421  20.746  1.00 52.13           C  
ATOM     15  CG  GLU A   3      10.773 -17.286  20.130  1.00 53.24           C  
ATOM     16  CD  GLU A   3      10.760 -17.218  18.610  1.00 55.50           C  
ATOM     17  OE1 GLU A   3      11.134 -18.230  17.959  1.00 53.41           O  
ATOM     18  OE2 GLU A   3      10.383 -16.148  18.072  1.00 54.26           O  
ATOM     19  N   LYS A   4      10.364 -15.437  22.885  1.00 46.24           N  
ATOM     20  CA  LYS A   4       9.287 -15.334  23.864  1.00 44.00           C  
ATOM     21  C   LYS A   4       9.370 -14.038  24.641  1.00 42.59           C  
ATOM     22  O   LYS A   4      10.447 -13.467  24.799  1.00 42.78           O  
ATOM     23  CB  LYS A   4       9.312 -16.518  24.844  1.00 43.45           C  
ATOM     24  CG  LYS A   4       9.128 -17.894  24.193  1.00 43.96           C  
ATOM     25  CD  LYS A   4       8.843 -18.988  25.223  1.00 43.24           C  
ATOM     26  CE  LYS A   4       8.950 -20.387  24.612  1.00 42.70           C  
ATOM     27  NZ  LYS A   4      10.376 -20.749  24.310  1.00 44.82           N  
ATOM     28  N   LEU A   5       8.214 -13.591  25.126  1.00 40.86           N  
ATOM     29  CA  LEU A   5       8.089 -12.357  25.890  1.00 38.70           C  
ATOM     30  C   LEU A   5       6.700 -12.247  26.519  1.00 37.36           C  
ATOM     31  O   LEU A   5       5.695 -12.623  25.905  1.00 38.21           O  
ATOM     32  CB  LEU A   5       8.320 -11.150  24.977  1.00 38.75           C  
ATOM     33  CG  LEU A   5       7.998  -9.795  25.607  1.00 39.86           C  
ATOM     34  CD1 LEU A   5       8.785  -9.642  26.899  1.00 41.10           C  
ATOM     35  CD2 LEU A   5       8.343  -8.677  24.635  1.00 37.37           C  
ATOM     36  N   VAL A   6       6.654 -11.731  27.744  1.00 34.81           N  
ATOM     37  CA  VAL A   6       5.404 -11.526  28.480  1.00 28.79           C  
ATOM     38  C   VAL A   6       5.319 -10.029  28.757  1.00 28.69           C  
ATOM     39  O   VAL A   6       6.328  -9.391  29.059  1.00 30.85           O  
ATOM     40  CB  VAL A   6       5.399 -12.299  29.832  1.00 28.06           C  
ATOM     41  CG1 VAL A   6       4.129 -11.994  30.618  1.00 24.56           C  
ATOM     42  CG2 VAL A   6       5.511 -13.791  29.575  1.00 28.83           C  
ATOM     43  N   ALA A   7       4.123  -9.471  28.643  1.00 27.96           N  
ATOM     44  CA  ALA A   7       3.919  -8.049  28.878  1.00 27.45           C  
ATOM     45  C   ALA A   7       2.786  -7.880  29.868  1.00 27.39           C  
ATOM     46  O   ALA A   7       1.739  -8.517  29.742  1.00 26.82           O  
ATOM     47  CB  ALA A   7       3.577  -7.350  27.575  1.00 28.37           C  
ATOM     48  N   ILE A   8       2.998  -7.019  30.850  1.00 27.63           N  
ATOM     49  CA  ILE A   8       1.992  -6.779  31.864  1.00 29.35           C  
ATOM     50  C   ILE A   8       1.612  -5.328  31.817  1.00 29.21           C  
ATOM     51  O   ILE A   8       2.405  -4.476  32.190  1.00 31.46           O  
ATOM     52  CB  ILE A   8       2.541  -7.090  33.229  1.00 30.16           C  
ATOM     53  CG1 ILE A   8       3.082  -8.523  33.234  1.00 32.89           C  
ATOM     54  CG2 ILE A   8       1.455  -6.880  34.280  1.00 31.83           C  
ATOM     55  CD1 ILE A   8       3.801  -8.880  34.502  1.00 35.55           C  
ATOM     56  N   VAL A   9       0.403  -5.039  31.354  1.00 29.23           N  
ATOM     57  CA  VAL A   9      -0.034  -3.648  31.235  1.00 28.10           C  
ATOM     58  C   VAL A   9      -1.218  -3.329  32.126  1.00 28.20           C  
ATOM     59  O   VAL A   9      -1.885  -4.223  32.629  1.00 27.13           O  
ATOM     60  CB  VAL A   9      -0.403  -3.328  29.775  1.00 26.43           C  
ATOM     61  CG1 VAL A   9       0.838  -3.433  28.894  1.00 26.50           C  
ATOM     62  CG2 VAL A   9      -1.453  -4.317  29.276  1.00 25.53           C  
ATOM     63  N   GLY A  10      -1.468  -2.044  32.314  1.00 29.26           N  
ATOM     64  CA  GLY A  10      -2.577  -1.635  33.141  1.00 31.68           C  
ATOM     65  C   GLY A  10      -2.296  -0.319  33.828  1.00 32.94           C  
ATOM     66  O   GLY A  10      -1.141   0.090  33.922  1.00 34.87           O  
ATOM     67  N   PRO A  11      -3.333   0.371  34.327  1.00 33.20           N  
ATOM     68  CA  PRO A  11      -3.153   1.657  35.009  1.00 33.05           C  
ATOM     69  C   PRO A  11      -2.340   1.512  36.288  1.00 33.78           C  
ATOM     70  O   PRO A  11      -2.033   0.398  36.716  1.00 35.06           O  
ATOM     71  CB  PRO A  11      -4.584   2.105  35.270  1.00 31.69           C  
ATOM     72  CG  PRO A  11      -5.296   0.804  35.486  1.00 32.94           C  
ATOM     73  CD  PRO A  11      -4.736  -0.078  34.401  1.00 32.43           C  
ATOM     74  N   THR A  12      -1.988   2.641  36.888  1.00 34.23           N  
ATOM     75  CA  THR A  12      -1.204   2.639  38.113  1.00 35.24           C  
ATOM     76  C   THR A  12      -2.033   2.159  39.302  1.00 34.81           C  
ATOM     77  O   THR A  12      -3.260   2.276  39.298  1.00 35.81           O  
ATOM     78  CB  THR A  12      -0.646   4.061  38.424  1.00 37.20           C  
ATOM     79  OG1 THR A  12      -1.736   4.972  38.631  1.00 39.98           O  
ATOM     80  CG2 THR A  12       0.216   4.562  37.272  1.00 37.16           C  
ATOM     81  N   ALA A  13      -1.347   1.608  40.304  1.00 34.11           N  
ATOM     82  CA  ALA A  13      -1.968   1.110  41.537  1.00 32.33           C  
ATOM     83  C   ALA A  13      -2.824  -0.136  41.359  1.00 31.62           C  
ATOM     84  O   ALA A  13      -3.631  -0.460  42.234  1.00 30.15           O  
ATOM     85  CB  ALA A  13      -2.803   2.222  42.191  1.00 30.75           C  
ATOM     86  N   VAL A  14      -2.673  -0.831  40.235  1.00 31.24           N  
ATOM     87  CA  VAL A  14      -3.477  -2.038  40.022  1.00 32.02           C  
ATOM     88  C   VAL A  14      -2.766  -3.304  40.493  1.00 30.52           C  
ATOM     89  O   VAL A  14      -3.386  -4.350  40.617  1.00 29.16           O  
ATOM     90  CB  VAL A  14      -3.880  -2.196  38.535  1.00 33.44           C  
ATOM     91  CG1 VAL A  14      -4.474  -0.902  38.043  1.00 36.14           C  
ATOM     92  CG2 VAL A  14      -2.680  -2.605  37.682  1.00 32.75           C  
ATOM     93  N   GLY A  15      -1.467  -3.201  40.759  1.00 32.12           N  
ATOM     94  CA  GLY A  15      -0.721  -4.358  41.223  1.00 32.80           C  
ATOM     95  C   GLY A  15       0.227  -4.931  40.189  1.00 33.18           C  
ATOM     96  O   GLY A  15       0.653  -6.084  40.286  1.00 33.78           O  
ATOM     97  N   LYS A  16       0.556  -4.128  39.188  1.00 33.74           N  
ATOM     98  CA  LYS A  16       1.464  -4.571  38.147  1.00 35.02           C  
ATOM     99  C   LYS A  16       2.763  -5.094  38.753  1.00 34.64           C  
ATOM    100  O   LYS A  16       3.136  -6.234  38.516  1.00 34.00           O  
ATOM    101  CB  LYS A  16       1.722  -3.428  37.160  1.00 33.01           C  
ATOM    102  CG  LYS A  16       0.880  -3.549  35.877  1.00 37.78           C  
ATOM    103  CD  LYS A  16       0.352  -2.208  35.311  1.00 38.75           C  
ATOM    104  CE  LYS A  16       1.464  -1.190  35.037  1.00 38.04           C  
ATOM    105  NZ  LYS A  16       2.104  -0.711  36.293  1.00 39.43           N  
ATOM    106  N   THR A  17       3.431  -4.281  39.563  1.00 35.04           N  
ATOM    107  CA  THR A  17       4.689  -4.704  40.183  1.00 35.31           C  
ATOM    108  C   THR A  17       4.580  -5.955  41.035  1.00 35.05           C  
ATOM    109  O   THR A  17       5.387  -6.878  40.899  1.00 35.29           O  
ATOM    110  CB  THR A  17       5.283  -3.627  41.089  1.00 34.87           C  
ATOM    111  OG1 THR A  17       5.550  -2.442  40.327  1.00 35.41           O  
ATOM    112  CG2 THR A  17       6.566  -4.134  41.702  1.00 33.63           C  
ATOM    113  N   LYS A  18       3.606  -5.978  41.939  1.00 34.04           N  
ATOM    114  CA  LYS A  18       3.439  -7.137  42.810  1.00 33.76           C  
ATOM    115  C   LYS A  18       3.249  -8.408  41.981  1.00 33.23           C  
ATOM    116  O   LYS A  18       4.012  -9.362  42.130  1.00 33.60           O  
ATOM    117  CB  LYS A  18       2.240  -6.963  43.751  1.00 32.15           C  
ATOM    118  CG  LYS A  18       2.034  -8.155  44.711  1.00 30.26           C  
ATOM    119  CD  LYS A  18       0.795  -7.996  45.594  1.00 29.41           C  
ATOM    120  CE  LYS A  18       0.648  -9.134  46.630  1.00 30.03           C  
ATOM    121  NZ  LYS A  18       1.711  -9.136  47.714  1.00 27.97           N  
ATOM    122  N   THR A  19       2.237  -8.403  41.112  1.00 30.53           N  
ATOM    123  CA  THR A  19       1.934  -9.551  40.264  1.00 32.30           C  
ATOM    124  C   THR A  19       3.157  -9.887  39.425  1.00 32.19           C  
ATOM    125  O   THR A  19       3.474 -11.047  39.170  1.00 32.95           O  
ATOM    126  CB  THR A  19       0.734  -9.260  39.330  1.00 32.75           C  
ATOM    127  OG1 THR A  19       1.024  -8.125  38.517  1.00 38.91           O  
ATOM    128  CG2 THR A  19      -0.496  -8.947  40.125  1.00 31.97           C  
ATOM    129  N   SER A  20       3.859  -8.839  39.034  1.00 32.47           N  
ATOM    130  CA  SER A  20       5.049  -8.949  38.221  1.00 33.82           C  
ATOM    131  C   SER A  20       6.156  -9.783  38.850  1.00 34.15           C  
ATOM    132  O   SER A  20       6.618 -10.758  38.251  1.00 35.20           O  
ATOM    133  CB  SER A  20       5.592  -7.555  37.923  1.00 30.76           C  
ATOM    134  OG  SER A  20       6.574  -7.623  36.933  1.00 35.02           O  
ATOM    135  N   VAL A  21       6.587  -9.405  40.052  1.00 32.93           N  
ATOM    136  CA  VAL A  21       7.674 -10.124  40.700  1.00 31.91           C  
ATOM    137  C   VAL A  21       7.296 -11.548  41.072  1.00 32.56           C  
ATOM    138  O   VAL A  21       8.140 -12.440  41.033  1.00 33.01           O  
ATOM    139  CB  VAL A  21       8.209  -9.351  41.924  1.00 31.15           C  
ATOM    140  CG1 VAL A  21       8.504  -7.907  41.511  1.00 30.07           C  
ATOM    141  CG2 VAL A  21       7.239  -9.403  43.071  1.00 33.49           C  
HETATM  142  N   MSE A  22       6.023 -11.778  41.387  1.00 32.93           N  
HETATM  143  CA  MSE A  22       5.590 -13.122  41.723  1.00 32.48           C  
HETATM  144  C   MSE A  22       5.666 -14.026  40.496  1.00 31.63           C  
HETATM  145  O   MSE A  22       6.106 -15.177  40.589  1.00 32.16           O  
HETATM  146  CB  MSE A  22       4.162 -13.122  42.267  1.00 34.42           C  
HETATM  147  CG  MSE A  22       4.037 -12.607  43.684  1.00 37.52           C  
HETATM  148 SE   MSE A  22       2.177 -12.485  44.216  1.00 44.31          SE  
HETATM  149  CE  MSE A  22       2.019 -14.219  45.075  1.00 35.44           C  
ATOM    150  N   LEU A  23       5.232 -13.526  39.343  1.00 29.51           N  
ATOM    151  CA  LEU A  23       5.288 -14.341  38.136  1.00 29.47           C  
ATOM    152  C   LEU A  23       6.738 -14.628  37.781  1.00 30.03           C  
ATOM    153  O   LEU A  23       7.067 -15.736  37.362  1.00 28.38           O  
ATOM    154  CB  LEU A  23       4.582 -13.649  36.969  1.00 27.46           C  
ATOM    155  CG  LEU A  23       3.052 -13.723  37.012  1.00 27.05           C  
ATOM    156  CD1 LEU A  23       2.476 -12.675  36.089  1.00 26.87           C  
ATOM    157  CD2 LEU A  23       2.575 -15.127  36.599  1.00 25.65           C  
ATOM    158  N   ALA A  24       7.610 -13.639  37.959  1.00 31.41           N  
ATOM    159  CA  ALA A  24       9.020 -13.851  37.650  1.00 33.65           C  
ATOM    160  C   ALA A  24       9.597 -15.013  38.466  1.00 35.40           C  
ATOM    161  O   ALA A  24      10.268 -15.888  37.912  1.00 34.26           O  
ATOM    162  CB  ALA A  24       9.810 -12.589  37.904  1.00 32.28           C  
ATOM    163  N   LYS A  25       9.313 -15.037  39.768  1.00 37.14           N  
ATOM    164  CA  LYS A  25       9.818 -16.101  40.643  1.00 39.83           C  
ATOM    165  C   LYS A  25       9.233 -17.457  40.259  1.00 39.48           C  
ATOM    166  O   LYS A  25       9.838 -18.499  40.506  1.00 41.35           O  
ATOM    167  CB  LYS A  25       9.495 -15.784  42.106  1.00 40.44           C  
ATOM    168  CG  LYS A  25       9.967 -14.410  42.543  1.00 43.48           C  
ATOM    169  CD  LYS A  25       9.396 -14.015  43.900  1.00 45.82           C  
ATOM    170  CE  LYS A  25       9.969 -14.865  45.027  1.00 47.63           C  
ATOM    171  NZ  LYS A  25      11.454 -14.729  45.143  1.00 49.68           N  
ATOM    172  N   ARG A  26       8.056 -17.437  39.645  1.00 39.75           N  
ATOM    173  CA  ARG A  26       7.417 -18.661  39.202  1.00 37.82           C  
ATOM    174  C   ARG A  26       7.830 -19.060  37.775  1.00 39.11           C  
ATOM    175  O   ARG A  26       7.711 -20.224  37.414  1.00 40.59           O  
ATOM    176  CB  ARG A  26       5.894 -18.515  39.277  1.00 38.20           C  
ATOM    177  CG  ARG A  26       5.314 -18.748  40.655  1.00 38.38           C  
ATOM    178  CD  ARG A  26       4.140 -17.840  40.930  1.00 40.38           C  
ATOM    179  NE  ARG A  26       3.412 -18.282  42.115  1.00 39.00           N  
ATOM    180  CZ  ARG A  26       2.562 -19.307  42.132  1.00 41.35           C  
ATOM    181  NH1 ARG A  26       1.950 -19.640  43.271  1.00 40.81           N  
ATOM    182  NH2 ARG A  26       2.306 -19.984  41.011  1.00 35.50           N  
ATOM    183  N   LEU A  27       8.320 -18.122  36.964  1.00 37.69           N  
ATOM    184  CA  LEU A  27       8.695 -18.468  35.592  1.00 36.82           C  
ATOM    185  C   LEU A  27      10.106 -18.100  35.187  1.00 35.61           C  
ATOM    186  O   LEU A  27      10.372 -17.847  34.014  1.00 33.26           O  
ATOM    187  CB  LEU A  27       7.722 -17.842  34.590  1.00 37.85           C  
ATOM    188  CG  LEU A  27       6.273 -18.324  34.628  1.00 37.70           C  
ATOM    189  CD1 LEU A  27       5.409 -17.393  33.821  1.00 35.46           C  
ATOM    190  CD2 LEU A  27       6.189 -19.740  34.100  1.00 39.15           C  
ATOM    191  N   ASN A  28      11.008 -18.080  36.159  1.00 36.84           N  
ATOM    192  CA  ASN A  28      12.405 -17.754  35.909  1.00 36.23           C  
ATOM    193  C   ASN A  28      12.554 -16.572  34.958  1.00 36.66           C  
ATOM    194  O   ASN A  28      13.103 -16.705  33.863  1.00 34.88           O  
ATOM    195  CB  ASN A  28      13.116 -18.955  35.314  1.00 34.78           C  
ATOM    196  CG  ASN A  28      14.606 -18.768  35.280  1.00 35.89           C  
ATOM    197  OD1 ASN A  28      15.279 -19.139  34.302  1.00 35.68           O  
ATOM    198  ND2 ASN A  28      15.144 -18.184  36.346  1.00 32.44           N  
ATOM    199  N   GLY A  29      12.071 -15.409  35.380  1.00 36.85           N  
ATOM    200  CA  GLY A  29      12.161 -14.243  34.526  1.00 36.04           C  
ATOM    201  C   GLY A  29      12.791 -13.020  35.157  1.00 35.80           C  
ATOM    202  O   GLY A  29      12.964 -12.943  36.380  1.00 33.56           O  
ATOM    203  N   GLU A  30      13.136 -12.071  34.288  1.00 34.27           N  
ATOM    204  CA  GLU A  30      13.747 -10.796  34.660  1.00 35.32           C  
ATOM    205  C   GLU A  30      12.805  -9.685  34.196  1.00 34.30           C  
ATOM    206  O   GLU A  30      12.172  -9.793  33.146  1.00 33.85           O  
ATOM    207  CB  GLU A  30      15.124 -10.627  33.992  1.00 36.05           C  
ATOM    208  CG  GLU A  30      16.204 -11.609  34.471  1.00 41.59           C  
ATOM    209  CD  GLU A  30      17.616 -11.271  33.965  1.00 43.89           C  
ATOM    210  OE1 GLU A  30      18.072 -10.116  34.138  1.00 45.75           O  
ATOM    211  OE2 GLU A  30      18.286 -12.166  33.401  1.00 48.50           O  
ATOM    212  N   VAL A  31      12.714  -8.621  34.981  1.00 32.02           N  
ATOM    213  CA  VAL A  31      11.822  -7.530  34.646  1.00 30.46           C  
ATOM    214  C   VAL A  31      12.458  -6.341  33.952  1.00 29.60           C  
ATOM    215  O   VAL A  31      13.507  -5.835  34.367  1.00 30.95           O  
ATOM    216  CB  VAL A  31      11.077  -7.033  35.902  1.00 29.08           C  
ATOM    217  CG1 VAL A  31      10.328  -5.732  35.604  1.00 26.74           C  
ATOM    218  CG2 VAL A  31      10.092  -8.106  36.346  1.00 28.32           C  
ATOM    219  N   ILE A  32      11.816  -5.919  32.872  1.00 28.74           N  
ATOM    220  CA  ILE A  32      12.265  -4.761  32.119  1.00 30.16           C  
ATOM    221  C   ILE A  32      11.152  -3.750  32.303  1.00 29.44           C  
ATOM    222  O   ILE A  32      10.042  -3.957  31.830  1.00 29.64           O  
ATOM    223  CB  ILE A  32      12.414  -5.058  30.624  1.00 29.18           C  
ATOM    224  CG1 ILE A  32      13.436  -6.161  30.387  1.00 29.11           C  
ATOM    225  CG2 ILE A  32      12.888  -3.821  29.919  1.00 29.33           C  
ATOM    226  CD1 ILE A  32      13.486  -6.608  28.938  1.00 29.16           C  
ATOM    227  N   SER A  33      11.450  -2.675  33.017  1.00 32.46           N  
ATOM    228  CA  SER A  33      10.460  -1.645  33.276  1.00 33.76           C  
ATOM    229  C   SER A  33      10.109  -0.851  32.047  1.00 34.43           C  
ATOM    230  O   SER A  33      10.980  -0.503  31.255  1.00 31.20           O  
ATOM    231  CB  SER A  33      10.948  -0.647  34.312  1.00 33.12           C  
ATOM    232  OG  SER A  33      10.070   0.465  34.311  1.00 33.94           O  
ATOM    233  N   GLY A  34       8.826  -0.537  31.912  1.00 35.15           N  
ATOM    234  CA  GLY A  34       8.382   0.248  30.782  1.00 38.08           C  
ATOM    235  C   GLY A  34       8.006   1.657  31.219  1.00 38.30           C  
ATOM    236  O   GLY A  34       7.814   2.542  30.390  1.00 39.98           O  
ATOM    237  N   ASP A  35       7.893   1.860  32.525  1.00 38.29           N  
ATOM    238  CA  ASP A  35       7.545   3.159  33.081  1.00 37.99           C  
ATOM    239  C   ASP A  35       8.798   4.036  33.010  1.00 39.89           C  
ATOM    240  O   ASP A  35       9.706   3.917  33.836  1.00 38.66           O  
ATOM    241  CB  ASP A  35       7.062   2.961  34.522  1.00 36.80           C  
ATOM    242  CG  ASP A  35       6.811   4.267  35.253  1.00 37.39           C  
ATOM    243  OD1 ASP A  35       5.944   5.064  34.843  1.00 36.40           O  
ATOM    244  OD2 ASP A  35       7.490   4.484  36.265  1.00 40.38           O  
ATOM    245  N   SER A  36       8.845   4.898  31.994  1.00 42.73           N  
ATOM    246  CA  SER A  36       9.989   5.781  31.764  1.00 44.49           C  
ATOM    247  C   SER A  36      10.395   6.560  33.002  1.00 46.33           C  
ATOM    248  O   SER A  36      11.581   6.794  33.225  1.00 47.55           O  
ATOM    249  CB  SER A  36       9.686   6.744  30.622  1.00 43.76           C  
ATOM    250  OG  SER A  36       8.500   7.471  30.873  1.00 47.00           O  
HETATM  251  N   MSE A  37       9.413   6.956  33.808  1.00 47.05           N  
HETATM  252  CA  MSE A  37       9.686   7.689  35.041  1.00 47.30           C  
HETATM  253  C   MSE A  37      10.622   6.943  35.993  1.00 44.88           C  
HETATM  254  O   MSE A  37      11.316   7.565  36.801  1.00 42.27           O  
HETATM  255  CB  MSE A  37       8.379   8.003  35.762  1.00 52.71           C  
HETATM  256  CG  MSE A  37       7.632   9.138  35.139  1.00 59.98           C  
HETATM  257 SE   MSE A  37       8.791  10.683  35.110  1.00 74.34          SE  
HETATM  258  CE  MSE A  37       9.202  10.730  33.218  1.00 69.77           C  
ATOM    259  N   GLN A  38      10.634   5.614  35.896  1.00 43.00           N  
ATOM    260  CA  GLN A  38      11.481   4.765  36.745  1.00 42.08           C  
ATOM    261  C   GLN A  38      12.968   4.973  36.464  1.00 40.57           C  
ATOM    262  O   GLN A  38      13.807   4.653  37.297  1.00 39.56           O  
ATOM    263  CB  GLN A  38      11.166   3.272  36.530  1.00 42.93           C  
ATOM    264  CG  GLN A  38       9.826   2.747  37.068  1.00 42.32           C  
ATOM    265  CD  GLN A  38       9.690   2.836  38.584  1.00 43.35           C  
ATOM    266  OE1 GLN A  38      10.663   2.671  39.326  1.00 44.46           O  
ATOM    267  NE2 GLN A  38       8.469   3.074  39.049  1.00 42.13           N  
ATOM    268  N   VAL A  39      13.290   5.504  35.291  1.00 40.35           N  
ATOM    269  CA  VAL A  39      14.678   5.718  34.911  1.00 40.05           C  
ATOM    270  C   VAL A  39      15.408   6.808  35.676  1.00 40.69           C  
ATOM    271  O   VAL A  39      16.601   6.692  35.931  1.00 41.43           O  
ATOM    272  CB  VAL A  39      14.798   6.090  33.442  1.00 40.76           C  
ATOM    273  CG1 VAL A  39      14.065   5.072  32.585  1.00 40.19           C  
ATOM    274  CG2 VAL A  39      14.238   7.498  33.227  1.00 42.18           C  
ATOM    275  N   TYR A  40      14.715   7.877  36.032  1.00 40.60           N  
ATOM    276  CA  TYR A  40      15.380   8.985  36.711  1.00 40.74           C  
ATOM    277  C   TYR A  40      15.803   8.745  38.148  1.00 40.24           C  
ATOM    278  O   TYR A  40      15.000   8.877  39.058  1.00 41.19           O  
ATOM    279  CB  TYR A  40      14.480  10.202  36.638  1.00 39.26           C  
ATOM    280  CG  TYR A  40      14.188  10.608  35.228  1.00 38.22           C  
ATOM    281  CD1 TYR A  40      15.197  11.104  34.406  1.00 37.33           C  
ATOM    282  CD2 TYR A  40      12.896  10.548  34.724  1.00 36.53           C  
ATOM    283  CE1 TYR A  40      14.916  11.546  33.122  1.00 36.65           C  
ATOM    284  CE2 TYR A  40      12.611  10.988  33.444  1.00 35.63           C  
ATOM    285  CZ  TYR A  40      13.616  11.485  32.655  1.00 35.07           C  
ATOM    286  OH  TYR A  40      13.318  11.963  31.408  1.00 36.09           O  
ATOM    287  N   ARG A  41      17.074   8.429  38.359  1.00 43.04           N  
ATOM    288  CA  ARG A  41      17.548   8.176  39.715  1.00 46.55           C  
ATOM    289  C   ARG A  41      17.404   9.376  40.655  1.00 46.23           C  
ATOM    290  O   ARG A  41      17.384  10.529  40.220  1.00 46.53           O  
ATOM    291  CB  ARG A  41      18.997   7.675  39.675  1.00 46.33           C  
ATOM    292  CG  ARG A  41      19.867   8.402  38.679  1.00 47.07           C  
ATOM    293  CD  ARG A  41      21.013   7.519  38.170  1.00 46.12           C  
ATOM    294  NE  ARG A  41      21.700   8.193  37.074  1.00 44.90           N  
ATOM    295  CZ  ARG A  41      22.525   7.615  36.208  1.00 44.18           C  
ATOM    296  NH1 ARG A  41      22.793   6.320  36.286  1.00 45.43           N  
ATOM    297  NH2 ARG A  41      23.081   8.345  35.253  1.00 45.22           N  
ATOM    298  N   GLY A  42      17.290   9.088  41.949  1.00 46.47           N  
ATOM    299  CA  GLY A  42      17.123  10.146  42.931  1.00 46.61           C  
ATOM    300  C   GLY A  42      15.648  10.462  43.118  1.00 46.57           C  
ATOM    301  O   GLY A  42      15.187  10.705  44.230  1.00 45.26           O  
HETATM  302  N   MSE A  43      14.911  10.464  42.015  1.00 46.88           N  
HETATM  303  CA  MSE A  43      13.480  10.726  42.034  1.00 48.27           C  
HETATM  304  C   MSE A  43      12.792   9.379  42.335  1.00 47.37           C  
HETATM  305  O   MSE A  43      12.459   8.622  41.420  1.00 45.98           O  
HETATM  306  CB  MSE A  43      13.060  11.288  40.666  1.00 49.52           C  
HETATM  307  CG  MSE A  43      13.797  12.591  40.283  1.00 52.34           C  
HETATM  308 SE   MSE A  43      13.488  13.261  38.455  1.00 56.22          SE  
HETATM  309  CE  MSE A  43      11.645  13.870  38.642  1.00 52.51           C  
ATOM    310  N   ASP A  44      12.604   9.076  43.623  1.00 46.70           N  
ATOM    311  CA  ASP A  44      11.991   7.808  44.041  1.00 45.85           C  
ATOM    312  C   ASP A  44      10.587   7.937  44.636  1.00 44.09           C  
ATOM    313  O   ASP A  44       9.760   7.033  44.517  1.00 42.76           O  
ATOM    314  CB  ASP A  44      12.871   7.097  45.077  1.00 46.30           C  
ATOM    315  CG  ASP A  44      14.342   7.247  44.800  1.00 47.05           C  
ATOM    316  OD1 ASP A  44      14.738   7.233  43.620  1.00 46.22           O  
ATOM    317  OD2 ASP A  44      15.110   7.366  45.772  1.00 49.17           O  
ATOM    318  N   ILE A  45      10.321   9.055  45.291  1.00 43.10           N  
ATOM    319  CA  ILE A  45       9.022   9.256  45.907  1.00 41.08           C  
ATOM    320  C   ILE A  45       7.952   9.636  44.897  1.00 39.66           C  
ATOM    321  O   ILE A  45       6.911   9.000  44.836  1.00 38.54           O  
ATOM    322  CB  ILE A  45       9.078  10.359  46.970  1.00 40.36           C  
ATOM    323  CG1 ILE A  45      10.086   9.991  48.054  1.00 41.31           C  
ATOM    324  CG2 ILE A  45       7.702  10.564  47.559  1.00 40.41           C  
ATOM    325  CD1 ILE A  45      10.474  11.167  48.950  1.00 45.87           C  
ATOM    326  N   GLY A  46       8.204  10.680  44.113  1.00 40.72           N  
ATOM    327  CA  GLY A  46       7.216  11.127  43.140  1.00 41.27           C  
ATOM    328  C   GLY A  46       6.912  10.140  42.022  1.00 42.57           C  
ATOM    329  O   GLY A  46       5.831  10.166  41.423  1.00 43.96           O  
ATOM    330  N   THR A  47       7.868   9.259  41.752  1.00 40.88           N  
ATOM    331  CA  THR A  47       7.729   8.270  40.699  1.00 40.31           C  
ATOM    332  C   THR A  47       7.266   6.917  41.217  1.00 40.01           C  
ATOM    333  O   THR A  47       6.933   6.025  40.432  1.00 37.87           O  
ATOM    334  CB  THR A  47       9.051   8.070  39.997  1.00 41.05           C  
ATOM    335  OG1 THR A  47      10.021   7.653  40.961  1.00 42.31           O  
ATOM    336  CG2 THR A  47       9.519   9.366  39.367  1.00 41.80           C  
ATOM    337  N   ALA A  48       7.237   6.757  42.538  1.00 40.37           N  
ATOM    338  CA  ALA A  48       6.814   5.486  43.129  1.00 39.46           C  
ATOM    339  C   ALA A  48       7.795   4.391  42.702  1.00 39.63           C  
ATOM    340  O   ALA A  48       7.406   3.262  42.416  1.00 39.17           O  
ATOM    341  CB  ALA A  48       5.412   5.141  42.667  1.00 40.33           C  
ATOM    342  N   LYS A  49       9.073   4.755  42.654  1.00 39.35           N  
ATOM    343  CA  LYS A  49      10.125   3.846  42.261  1.00 37.96           C  
ATOM    344  C   LYS A  49      10.086   2.564  43.062  1.00 39.82           C  
ATOM    345  O   LYS A  49      10.041   2.586  44.287  1.00 38.72           O  
ATOM    346  CB  LYS A  49      11.481   4.513  42.449  1.00 37.87           C  
ATOM    347  CG  LYS A  49      12.646   3.721  41.884  1.00 36.87           C  
ATOM    348  CD  LYS A  49      13.796   4.629  41.629  1.00 36.39           C  
ATOM    349  CE  LYS A  49      13.434   5.606  40.518  1.00 38.79           C  
ATOM    350  NZ  LYS A  49      14.345   6.792  40.518  1.00 39.17           N  
ATOM    351  N   ILE A  50      10.102   1.443  42.354  1.00 40.16           N  
ATOM    352  CA  ILE A  50      10.081   0.146  42.995  1.00 41.28           C  
ATOM    353  C   ILE A  50      11.323   0.004  43.847  1.00 40.78           C  
ATOM    354  O   ILE A  50      12.418   0.328  43.404  1.00 42.12           O  
ATOM    355  CB  ILE A  50      10.047  -0.969  41.949  1.00 41.39           C  
ATOM    356  CG1 ILE A  50      10.032  -2.325  42.634  1.00 42.93           C  
ATOM    357  CG2 ILE A  50      11.223  -0.839  41.033  1.00 39.61           C  
ATOM    358  CD1 ILE A  50       9.985  -3.482  41.663  1.00 43.98           C  
ATOM    359  N   THR A  51      11.145  -0.480  45.068  1.00 41.73           N  
ATOM    360  CA  THR A  51      12.262  -0.663  45.987  1.00 42.23           C  
ATOM    361  C   THR A  51      12.864  -2.054  45.886  1.00 44.20           C  
ATOM    362  O   THR A  51      12.236  -2.986  45.381  1.00 43.32           O  
ATOM    363  CB  THR A  51      11.816  -0.487  47.428  1.00 41.95           C  
ATOM    364  OG1 THR A  51      10.894  -1.535  47.771  1.00 37.36           O  
ATOM    365  CG2 THR A  51      11.149   0.862  47.600  1.00 40.06           C  
ATOM    366  N   ALA A  52      14.085  -2.183  46.393  1.00 46.71           N  
ATOM    367  CA  ALA A  52      14.799  -3.455  46.385  1.00 48.43           C  
ATOM    368  C   ALA A  52      14.009  -4.496  47.172  1.00 49.18           C  
ATOM    369  O   ALA A  52      14.091  -5.696  46.910  1.00 47.83           O  
ATOM    370  CB  ALA A  52      16.176  -3.273  46.997  1.00 48.21           C  
ATOM    371  N   GLU A  53      13.239  -4.018  48.139  1.00 50.16           N  
ATOM    372  CA  GLU A  53      12.429  -4.891  48.964  1.00 50.75           C  
ATOM    373  C   GLU A  53      11.347  -5.542  48.108  1.00 50.15           C  
ATOM    374  O   GLU A  53      11.347  -6.757  47.915  1.00 49.89           O  
ATOM    375  CB  GLU A  53      11.811  -4.075  50.095  1.00 51.43           C  
ATOM    376  CG  GLU A  53      11.069  -4.877  51.142  1.00 55.85           C  
ATOM    377  CD  GLU A  53       9.700  -5.318  50.678  1.00 57.27           C  
ATOM    378  OE1 GLU A  53       9.605  -6.373  50.010  1.00 59.81           O  
ATOM    379  OE2 GLU A  53       8.719  -4.601  50.973  1.00 57.54           O  
ATOM    380  N   GLU A  54      10.436  -4.732  47.581  1.00 49.58           N  
ATOM    381  CA  GLU A  54       9.344  -5.252  46.767  1.00 48.93           C  
ATOM    382  C   GLU A  54       9.815  -5.892  45.482  1.00 48.70           C  
ATOM    383  O   GLU A  54       9.105  -6.676  44.863  1.00 49.50           O  
ATOM    384  CB  GLU A  54       8.356  -4.136  46.455  1.00 48.53           C  
ATOM    385  CG  GLU A  54       8.956  -2.960  45.750  1.00 51.21           C  
ATOM    386  CD  GLU A  54       8.120  -1.719  45.953  1.00 52.83           C  
ATOM    387  OE1 GLU A  54       6.897  -1.775  45.698  1.00 52.36           O  
ATOM    388  OE2 GLU A  54       8.687  -0.689  46.374  1.00 53.87           O  
HETATM  389  N   MSE A  55      11.024  -5.548  45.084  1.00 49.75           N  
HETATM  390  CA  MSE A  55      11.606  -6.093  43.879  1.00 50.33           C  
HETATM  391  C   MSE A  55      11.956  -7.554  44.193  1.00 50.32           C  
HETATM  392  O   MSE A  55      12.081  -8.396  43.296  1.00 49.47           O  
HETATM  393  CB  MSE A  55      12.855  -5.276  43.552  1.00 52.48           C  
HETATM  394  CG  MSE A  55      13.368  -5.360  42.134  1.00 52.98           C  
HETATM  395 SE   MSE A  55      14.955  -4.253  41.926  1.00 56.84          SE  
HETATM  396  CE  MSE A  55      14.143  -2.499  41.702  1.00 54.96           C  
ATOM    397  N   ASP A  56      12.076  -7.844  45.488  1.00 50.20           N  
ATOM    398  CA  ASP A  56      12.437  -9.174  45.987  1.00 49.14           C  
ATOM    399  C   ASP A  56      13.819  -9.490  45.431  1.00 47.95           C  
ATOM    400  O   ASP A  56      14.724  -8.655  45.505  1.00 48.24           O  
ATOM    401  CB  ASP A  56      11.419 -10.235  45.544  1.00 50.01           C  
ATOM    402  CG  ASP A  56      11.037 -11.201  46.673  1.00 52.68           C  
ATOM    403  OD1 ASP A  56       9.952 -11.825  46.573  1.00 50.67           O  
ATOM    404  OD2 ASP A  56      11.812 -11.347  47.654  1.00 50.92           O  
ATOM    405  N   GLY A  57      13.993 -10.684  44.879  1.00 45.48           N  
ATOM    406  CA  GLY A  57      15.289 -11.033  44.323  1.00 43.14           C  
ATOM    407  C   GLY A  57      15.283 -10.975  42.809  1.00 41.68           C  
ATOM    408  O   GLY A  57      16.254 -11.357  42.158  1.00 41.72           O  
ATOM    409  N   VAL A  58      14.186 -10.482  42.246  1.00 39.91           N  
ATOM    410  CA  VAL A  58      14.050 -10.402  40.803  1.00 38.57           C  
ATOM    411  C   VAL A  58      14.836  -9.236  40.225  1.00 38.22           C  
ATOM    412  O   VAL A  58      14.610  -8.087  40.576  1.00 39.26           O  
ATOM    413  CB  VAL A  58      12.574 -10.277  40.422  1.00 39.65           C  
ATOM    414  CG1 VAL A  58      12.409 -10.420  38.919  1.00 40.87           C  
ATOM    415  CG2 VAL A  58      11.767 -11.338  41.158  1.00 38.82           C  
ATOM    416  N   PRO A  59      15.782  -9.520  39.320  1.00 37.73           N  
ATOM    417  CA  PRO A  59      16.572  -8.436  38.731  1.00 39.49           C  
ATOM    418  C   PRO A  59      15.733  -7.554  37.805  1.00 39.94           C  
ATOM    419  O   PRO A  59      14.923  -8.060  37.028  1.00 40.65           O  
ATOM    420  CB  PRO A  59      17.690  -9.185  38.003  1.00 38.56           C  
ATOM    421  CG  PRO A  59      17.010 -10.425  37.546  1.00 36.87           C  
ATOM    422  CD  PRO A  59      16.132 -10.820  38.723  1.00 38.73           C  
ATOM    423  N   HIS A  60      15.917  -6.236  37.908  1.00 39.54           N  
ATOM    424  CA  HIS A  60      15.174  -5.282  37.085  1.00 38.76           C  
ATOM    425  C   HIS A  60      16.078  -4.397  36.246  1.00 39.51           C  
ATOM    426  O   HIS A  60      17.210  -4.106  36.627  1.00 39.51           O  
ATOM    427  CB  HIS A  60      14.277  -4.401  37.959  1.00 35.08           C  
ATOM    428  CG  HIS A  60      13.098  -5.122  38.521  1.00 36.34           C  
ATOM    429  ND1 HIS A  60      11.811  -4.633  38.438  1.00 34.16           N  
ATOM    430  CD2 HIS A  60      13.004  -6.319  39.150  1.00 34.92           C  
ATOM    431  CE1 HIS A  60      10.977  -5.497  38.986  1.00 34.91           C  
ATOM    432  NE2 HIS A  60      11.676  -6.528  39.425  1.00 36.15           N  
ATOM    433  N   HIS A  61      15.570  -3.952  35.103  1.00 39.63           N  
ATOM    434  CA  HIS A  61      16.360  -3.102  34.230  1.00 40.22           C  
ATOM    435  C   HIS A  61      15.636  -1.800  33.927  1.00 40.59           C  
ATOM    436  O   HIS A  61      14.432  -1.672  34.164  1.00 40.42           O  
ATOM    437  CB  HIS A  61      16.667  -3.853  32.932  1.00 40.85           C  
ATOM    438  CG  HIS A  61      17.221  -5.227  33.156  1.00 43.14           C  
ATOM    439  ND1 HIS A  61      16.453  -6.271  33.625  1.00 45.10           N  
ATOM    440  CD2 HIS A  61      18.477  -5.713  33.026  1.00 43.19           C  
ATOM    441  CE1 HIS A  61      17.211  -7.341  33.774  1.00 43.13           C  
ATOM    442  NE2 HIS A  61      18.443  -7.030  33.419  1.00 44.92           N  
ATOM    443  N   LEU A  62      16.375  -0.822  33.416  1.00 40.70           N  
ATOM    444  CA  LEU A  62      15.776   0.457  33.053  1.00 41.46           C  
ATOM    445  C   LEU A  62      15.257   1.247  34.245  1.00 40.42           C  
ATOM    446  O   LEU A  62      14.265   1.960  34.133  1.00 39.89           O  
ATOM    447  CB  LEU A  62      14.637   0.220  32.056  1.00 40.78           C  
ATOM    448  CG  LEU A  62      15.007  -0.073  30.602  1.00 41.22           C  
ATOM    449  CD1 LEU A  62      16.262  -0.904  30.510  1.00 40.62           C  
ATOM    450  CD2 LEU A  62      13.842  -0.765  29.931  1.00 40.72           C  
ATOM    451  N   ILE A  63      15.924   1.100  35.382  1.00 41.05           N  
ATOM    452  CA  ILE A  63      15.573   1.825  36.592  1.00 41.28           C  
ATOM    453  C   ILE A  63      16.845   2.516  37.040  1.00 42.16           C  
ATOM    454  O   ILE A  63      17.897   1.881  37.129  1.00 43.05           O  
ATOM    455  CB  ILE A  63      15.106   0.880  37.692  1.00 41.72           C  
ATOM    456  CG1 ILE A  63      13.711   0.375  37.342  1.00 40.87           C  
ATOM    457  CG2 ILE A  63      15.129   1.582  39.053  1.00 37.84           C  
ATOM    458  CD1 ILE A  63      13.153  -0.571  38.353  1.00 40.55           C  
ATOM    459  N   ASP A  64      16.751   3.816  37.291  1.00 42.79           N  
ATOM    460  CA  ASP A  64      17.896   4.606  37.721  1.00 44.52           C  
ATOM    461  C   ASP A  64      19.066   4.529  36.744  1.00 45.03           C  
ATOM    462  O   ASP A  64      20.194   4.225  37.131  1.00 46.34           O  
ATOM    463  CB  ASP A  64      18.342   4.169  39.123  1.00 43.25           C  
ATOM    464  CG  ASP A  64      17.364   4.598  40.196  1.00 43.55           C  
ATOM    465  OD1 ASP A  64      17.540   4.191  41.371  1.00 41.29           O  
ATOM    466  OD2 ASP A  64      16.420   5.353  39.858  1.00 40.92           O  
ATOM    467  N   ILE A  65      18.793   4.805  35.474  1.00 46.22           N  
ATOM    468  CA  ILE A  65      19.842   4.781  34.464  1.00 47.18           C  
ATOM    469  C   ILE A  65      20.087   6.156  33.859  1.00 47.92           C  
ATOM    470  O   ILE A  65      20.952   6.307  33.001  1.00 50.03           O  
ATOM    471  CB  ILE A  65      19.505   3.825  33.306  1.00 47.57           C  
ATOM    472  CG1 ILE A  65      18.128   4.179  32.737  1.00 46.51           C  
ATOM    473  CG2 ILE A  65      19.579   2.380  33.776  1.00 45.96           C  
ATOM    474  CD1 ILE A  65      17.793   3.446  31.458  1.00 46.04           C  
ATOM    475  N   LYS A  66      19.323   7.155  34.292  1.00 48.21           N  
ATOM    476  CA  LYS A  66      19.493   8.499  33.758  1.00 49.11           C  
ATOM    477  C   LYS A  66      19.250   9.580  34.809  1.00 49.26           C  
ATOM    478  O   LYS A  66      18.546   9.357  35.802  1.00 48.62           O  
ATOM    479  CB  LYS A  66      18.570   8.698  32.542  1.00 49.85           C  
ATOM    480  CG  LYS A  66      18.751   7.616  31.460  1.00 51.40           C  
ATOM    481  CD  LYS A  66      18.083   7.958  30.126  1.00 51.79           C  
ATOM    482  CE  LYS A  66      18.877   8.994  29.333  1.00 52.74           C  
ATOM    483  NZ  LYS A  66      20.176   8.476  28.836  1.00 52.74           N  
ATOM    484  N   ASP A  67      19.858  10.747  34.590  1.00 50.28           N  
ATOM    485  CA  ASP A  67      19.727  11.883  35.508  1.00 50.76           C  
ATOM    486  C   ASP A  67      18.434  12.641  35.285  1.00 49.50           C  
ATOM    487  O   ASP A  67      17.946  12.749  34.159  1.00 48.31           O  
ATOM    488  CB  ASP A  67      20.882  12.877  35.336  1.00 53.27           C  
ATOM    489  CG  ASP A  67      22.219  12.301  35.741  1.00 57.12           C  
ATOM    490  OD1 ASP A  67      22.282  11.639  36.806  1.00 58.80           O  
ATOM    491  OD2 ASP A  67      23.211  12.525  35.001  1.00 58.21           O  
ATOM    492  N   PRO A  68      17.890  13.220  36.354  1.00 48.01           N  
ATOM    493  CA  PRO A  68      16.642  13.977  36.272  1.00 47.88           C  
ATOM    494  C   PRO A  68      16.616  15.083  35.214  1.00 47.65           C  
ATOM    495  O   PRO A  68      15.544  15.483  34.750  1.00 48.07           O  
ATOM    496  CB  PRO A  68      16.466  14.507  37.697  1.00 47.58           C  
ATOM    497  CG  PRO A  68      17.860  14.578  38.224  1.00 47.14           C  
ATOM    498  CD  PRO A  68      18.483  13.318  37.698  1.00 47.09           C  
ATOM    499  N   SER A  69      17.791  15.557  34.815  1.00 47.98           N  
ATOM    500  CA  SER A  69      17.901  16.631  33.819  1.00 49.29           C  
ATOM    501  C   SER A  69      17.795  16.180  32.354  1.00 49.25           C  
ATOM    502  O   SER A  69      17.551  17.000  31.462  1.00 48.09           O  
ATOM    503  CB  SER A  69      19.227  17.379  34.013  1.00 48.69           C  
ATOM    504  OG  SER A  69      20.322  16.478  33.964  1.00 49.08           O  
ATOM    505  N   GLU A  70      17.981  14.884  32.111  1.00 48.72           N  
ATOM    506  CA  GLU A  70      17.920  14.338  30.754  1.00 49.51           C  
ATOM    507  C   GLU A  70      16.520  13.879  30.362  1.00 49.64           C  
ATOM    508  O   GLU A  70      15.578  13.973  31.149  1.00 51.22           O  
ATOM    509  CB  GLU A  70      18.871  13.151  30.614  1.00 50.48           C  
ATOM    510  CG  GLU A  70      20.182  13.289  31.372  1.00 52.11           C  
ATOM    511  CD  GLU A  70      21.084  12.096  31.148  1.00 52.66           C  
ATOM    512  OE1 GLU A  70      21.758  12.061  30.094  1.00 55.17           O  
ATOM    513  OE2 GLU A  70      21.102  11.192  32.012  1.00 49.50           O  
ATOM    514  N   SER A  71      16.393  13.368  29.143  1.00 48.51           N  
ATOM    515  CA  SER A  71      15.106  12.894  28.654  1.00 47.86           C  
ATOM    516  C   SER A  71      15.173  11.416  28.273  1.00 46.97           C  
ATOM    517  O   SER A  71      16.255  10.854  28.112  1.00 45.10           O  
ATOM    518  CB  SER A  71      14.661  13.731  27.451  1.00 47.21           C  
ATOM    519  OG  SER A  71      15.659  13.757  26.448  1.00 45.64           O  
ATOM    520  N   PHE A  72      14.011  10.791  28.138  1.00 46.85           N  
ATOM    521  CA  PHE A  72      13.946   9.376  27.790  1.00 46.95           C  
ATOM    522  C   PHE A  72      12.853   9.153  26.750  1.00 47.12           C  
ATOM    523  O   PHE A  72      11.710   8.833  27.092  1.00 48.73           O  
ATOM    524  CB  PHE A  72      13.658   8.550  29.047  1.00 45.16           C  
ATOM    525  CG  PHE A  72      13.985   7.096  28.901  1.00 42.96           C  
ATOM    526  CD1 PHE A  72      15.277   6.697  28.604  1.00 40.75           C  
ATOM    527  CD2 PHE A  72      12.994   6.131  29.024  1.00 43.56           C  
ATOM    528  CE1 PHE A  72      15.581   5.366  28.423  1.00 38.52           C  
ATOM    529  CE2 PHE A  72      13.290   4.790  28.844  1.00 40.68           C  
ATOM    530  CZ  PHE A  72      14.585   4.411  28.544  1.00 41.18           C  
ATOM    531  N   SER A  73      13.211   9.315  25.479  1.00 45.24           N  
ATOM    532  CA  SER A  73      12.250   9.158  24.385  1.00 44.87           C  
ATOM    533  C   SER A  73      11.809   7.720  24.152  1.00 43.24           C  
ATOM    534  O   SER A  73      12.417   6.780  24.654  1.00 43.51           O  
ATOM    535  CB  SER A  73      12.842   9.698  23.087  1.00 43.33           C  
ATOM    536  OG  SER A  73      14.039   9.006  22.779  1.00 44.40           O  
ATOM    537  N   VAL A  74      10.745   7.551  23.383  1.00 42.30           N  
ATOM    538  CA  VAL A  74      10.280   6.215  23.093  1.00 41.34           C  
ATOM    539  C   VAL A  74      11.403   5.497  22.339  1.00 42.16           C  
ATOM    540  O   VAL A  74      11.489   4.269  22.366  1.00 43.97           O  
ATOM    541  CB  VAL A  74       8.976   6.232  22.254  1.00 40.73           C  
ATOM    542  CG1 VAL A  74       9.181   7.013  20.962  1.00 40.96           C  
ATOM    543  CG2 VAL A  74       8.545   4.817  21.948  1.00 39.37           C  
ATOM    544  N   ALA A  75      12.276   6.266  21.692  1.00 41.77           N  
ATOM    545  CA  ALA A  75      13.405   5.699  20.946  1.00 40.52           C  
ATOM    546  C   ALA A  75      14.505   5.214  21.898  1.00 39.81           C  
ATOM    547  O   ALA A  75      15.018   4.112  21.732  1.00 39.47           O  
ATOM    548  CB  ALA A  75      13.975   6.737  19.969  1.00 39.85           C  
ATOM    549  N   ASP A  76      14.863   6.032  22.888  1.00 38.71           N  
ATOM    550  CA  ASP A  76      15.891   5.648  23.850  1.00 39.85           C  
ATOM    551  C   ASP A  76      15.482   4.327  24.529  1.00 39.88           C  
ATOM    552  O   ASP A  76      16.322   3.465  24.796  1.00 39.09           O  
ATOM    553  CB  ASP A  76      16.078   6.730  24.928  1.00 42.99           C  
ATOM    554  CG  ASP A  76      16.343   8.116  24.352  1.00 47.59           C  
ATOM    555  OD1 ASP A  76      17.202   8.249  23.442  1.00 49.47           O  
ATOM    556  OD2 ASP A  76      15.698   9.082  24.826  1.00 47.05           O  
ATOM    557  N   PHE A  77      14.185   4.193  24.808  1.00 39.60           N  
ATOM    558  CA  PHE A  77      13.605   3.005  25.429  1.00 39.95           C  
ATOM    559  C   PHE A  77      13.746   1.791  24.491  1.00 40.14           C  
ATOM    560  O   PHE A  77      14.284   0.751  24.871  1.00 38.47           O  
ATOM    561  CB  PHE A  77      12.119   3.268  25.763  1.00 41.13           C  
ATOM    562  CG  PHE A  77      11.394   2.065  26.311  1.00 39.69           C  
ATOM    563  CD1 PHE A  77      11.727   1.539  27.556  1.00 39.45           C  
ATOM    564  CD2 PHE A  77      10.437   1.407  25.538  1.00 39.46           C  
ATOM    565  CE1 PHE A  77      11.125   0.368  28.014  1.00 41.77           C  
ATOM    566  CE2 PHE A  77       9.831   0.242  25.985  1.00 38.46           C  
ATOM    567  CZ  PHE A  77      10.176  -0.282  27.224  1.00 40.43           C  
ATOM    568  N   GLN A  78      13.266   1.931  23.263  1.00 40.67           N  
ATOM    569  CA  GLN A  78      13.359   0.850  22.292  1.00 40.25           C  
ATOM    570  C   GLN A  78      14.810   0.398  22.068  1.00 40.10           C  
ATOM    571  O   GLN A  78      15.070  -0.793  21.938  1.00 40.07           O  
ATOM    572  CB  GLN A  78      12.753   1.288  20.960  1.00 38.67           C  
ATOM    573  CG  GLN A  78      12.501   0.152  19.988  1.00 37.05           C  
ATOM    574  CD  GLN A  78      12.075   0.655  18.634  1.00 37.74           C  
ATOM    575  OE1 GLN A  78      12.830   1.345  17.967  1.00 39.87           O  
ATOM    576  NE2 GLN A  78      10.858   0.321  18.223  1.00 38.81           N  
ATOM    577  N   ASP A  79      15.756   1.335  22.027  1.00 39.94           N  
ATOM    578  CA  ASP A  79      17.150   0.960  21.805  1.00 39.82           C  
ATOM    579  C   ASP A  79      17.734   0.128  22.944  1.00 39.18           C  
ATOM    580  O   ASP A  79      18.695  -0.613  22.739  1.00 38.86           O  
ATOM    581  CB  ASP A  79      18.038   2.197  21.571  1.00 41.99           C  
ATOM    582  CG  ASP A  79      17.757   2.893  20.232  1.00 45.77           C  
ATOM    583  OD1 ASP A  79      17.307   2.225  19.269  1.00 47.57           O  
ATOM    584  OD2 ASP A  79      18.005   4.117  20.130  1.00 46.62           O  
ATOM    585  N   LEU A  80      17.156   0.246  24.135  1.00 37.67           N  
ATOM    586  CA  LEU A  80      17.639  -0.500  25.299  1.00 37.61           C  
ATOM    587  C   LEU A  80      16.764  -1.706  25.602  1.00 36.26           C  
ATOM    588  O   LEU A  80      17.236  -2.726  26.099  1.00 36.21           O  
ATOM    589  CB  LEU A  80      17.673   0.410  26.533  1.00 37.52           C  
ATOM    590  CG  LEU A  80      18.784   1.457  26.638  1.00 37.49           C  
ATOM    591  CD1 LEU A  80      18.503   2.418  27.790  1.00 35.30           C  
ATOM    592  CD2 LEU A  80      20.107   0.748  26.841  1.00 35.45           C  
ATOM    593  N   ALA A  81      15.479  -1.573  25.308  1.00 36.06           N  
ATOM    594  CA  ALA A  81      14.541  -2.643  25.558  1.00 37.96           C  
ATOM    595  C   ALA A  81      14.801  -3.872  24.677  1.00 38.72           C  
ATOM    596  O   ALA A  81      14.890  -4.985  25.187  1.00 40.17           O  
ATOM    597  CB  ALA A  81      13.117  -2.133  25.373  1.00 37.19           C  
ATOM    598  N   THR A  82      14.941  -3.671  23.370  1.00 40.35           N  
ATOM    599  CA  THR A  82      15.181  -4.772  22.432  1.00 42.14           C  
ATOM    600  C   THR A  82      16.447  -5.577  22.747  1.00 42.38           C  
ATOM    601  O   THR A  82      16.416  -6.798  22.818  1.00 41.39           O  
ATOM    602  CB  THR A  82      15.257  -4.243  20.957  1.00 44.14           C  
ATOM    603  OG1 THR A  82      14.010  -3.620  20.605  1.00 42.54           O  
ATOM    604  CG2 THR A  82      15.552  -5.389  19.973  1.00 42.30           C  
ATOM    605  N   PRO A  83      17.585  -4.901  22.937  1.00 43.78           N  
ATOM    606  CA  PRO A  83      18.806  -5.653  23.238  1.00 44.80           C  
ATOM    607  C   PRO A  83      18.678  -6.433  24.542  1.00 46.45           C  
ATOM    608  O   PRO A  83      19.233  -7.519  24.677  1.00 49.06           O  
ATOM    609  CB  PRO A  83      19.874  -4.565  23.317  1.00 43.61           C  
ATOM    610  CG  PRO A  83      19.374  -3.539  22.352  1.00 44.93           C  
ATOM    611  CD  PRO A  83      17.894  -3.482  22.709  1.00 44.91           C  
ATOM    612  N   LEU A  84      17.934  -5.885  25.497  1.00 45.75           N  
ATOM    613  CA  LEU A  84      17.759  -6.555  26.775  1.00 46.01           C  
ATOM    614  C   LEU A  84      16.922  -7.822  26.673  1.00 47.04           C  
ATOM    615  O   LEU A  84      17.188  -8.804  27.367  1.00 47.65           O  
ATOM    616  CB  LEU A  84      17.138  -5.606  27.799  1.00 44.53           C  
ATOM    617  CG  LEU A  84      18.197  -4.896  28.639  1.00 44.96           C  
ATOM    618  CD1 LEU A  84      17.572  -3.806  29.456  1.00 44.64           C  
ATOM    619  CD2 LEU A  84      18.887  -5.911  29.533  1.00 45.51           C  
ATOM    620  N   ILE A  85      15.912  -7.805  25.810  1.00 45.58           N  
ATOM    621  CA  ILE A  85      15.066  -8.973  25.651  1.00 45.34           C  
ATOM    622  C   ILE A  85      15.906 -10.152  25.176  1.00 45.75           C  
ATOM    623  O   ILE A  85      15.794 -11.264  25.690  1.00 45.68           O  
ATOM    624  CB  ILE A  85      13.935  -8.708  24.643  1.00 44.42           C  
ATOM    625  CG1 ILE A  85      12.975  -7.660  25.214  1.00 43.35           C  
ATOM    626  CG2 ILE A  85      13.191  -9.991  24.351  1.00 43.92           C  
ATOM    627  CD1 ILE A  85      11.743  -7.429  24.381  1.00 41.95           C  
ATOM    628  N   THR A  86      16.768  -9.901  24.205  1.00 46.43           N  
ATOM    629  CA  THR A  86      17.616 -10.954  23.685  1.00 47.41           C  
ATOM    630  C   THR A  86      18.655 -11.389  24.722  1.00 46.65           C  
ATOM    631  O   THR A  86      18.913 -12.581  24.885  1.00 46.83           O  
ATOM    632  CB  THR A  86      18.286 -10.488  22.377  1.00 48.49           C  
ATOM    633  OG1 THR A  86      17.281 -10.344  21.365  1.00 48.08           O  
ATOM    634  CG2 THR A  86      19.319 -11.489  21.903  1.00 48.65           C  
ATOM    635  N   GLU A  87      19.235 -10.430  25.433  1.00 47.33           N  
ATOM    636  CA  GLU A  87      20.230 -10.747  26.457  1.00 49.42           C  
ATOM    637  C   GLU A  87      19.614 -11.562  27.597  1.00 49.27           C  
ATOM    638  O   GLU A  87      20.244 -12.478  28.133  1.00 50.32           O  
ATOM    639  CB  GLU A  87      20.865  -9.466  27.014  1.00 50.84           C  
ATOM    640  CG  GLU A  87      22.129  -9.026  26.273  1.00 54.78           C  
ATOM    641  CD  GLU A  87      21.911  -7.867  25.294  1.00 57.72           C  
ATOM    642  OE1 GLU A  87      21.745  -6.708  25.758  1.00 60.26           O  
ATOM    643  OE2 GLU A  87      21.901  -8.115  24.061  1.00 57.79           O  
ATOM    644  N   ILE A  88      18.383 -11.233  27.969  1.00 47.93           N  
ATOM    645  CA  ILE A  88      17.728 -11.971  29.033  1.00 48.04           C  
ATOM    646  C   ILE A  88      17.584 -13.436  28.645  1.00 48.74           C  
ATOM    647  O   ILE A  88      17.829 -14.324  29.463  1.00 47.90           O  
ATOM    648  CB  ILE A  88      16.351 -11.369  29.372  1.00 45.96           C  
ATOM    649  CG1 ILE A  88      16.539 -10.135  30.257  1.00 44.75           C  
ATOM    650  CG2 ILE A  88      15.490 -12.387  30.101  1.00 48.58           C  
ATOM    651  CD1 ILE A  88      15.257  -9.391  30.551  1.00 41.20           C  
ATOM    652  N   HIS A  89      17.206 -13.692  27.394  1.00 50.45           N  
ATOM    653  CA  HIS A  89      17.050 -15.069  26.916  1.00 52.78           C  
ATOM    654  C   HIS A  89      18.347 -15.869  26.938  1.00 53.99           C  
ATOM    655  O   HIS A  89      18.318 -17.089  27.087  1.00 54.05           O  
ATOM    656  CB  HIS A  89      16.487 -15.096  25.498  1.00 53.56           C  
ATOM    657  CG  HIS A  89      14.996 -15.022  25.445  1.00 56.00           C  
ATOM    658  ND1 HIS A  89      14.183 -15.881  26.151  1.00 56.30           N  
ATOM    659  CD2 HIS A  89      14.167 -14.204  24.753  1.00 56.18           C  
ATOM    660  CE1 HIS A  89      12.917 -15.598  25.895  1.00 57.31           C  
ATOM    661  NE2 HIS A  89      12.882 -14.583  25.049  1.00 57.56           N  
ATOM    662  N   GLU A  90      19.481 -15.191  26.785  1.00 54.55           N  
ATOM    663  CA  GLU A  90      20.758 -15.887  26.796  1.00 55.56           C  
ATOM    664  C   GLU A  90      21.005 -16.534  28.145  1.00 55.78           C  
ATOM    665  O   GLU A  90      21.600 -17.606  28.223  1.00 55.62           O  
ATOM    666  CB  GLU A  90      21.897 -14.927  26.467  1.00 57.23           C  
ATOM    667  CG  GLU A  90      21.876 -14.433  25.039  1.00 60.57           C  
ATOM    668  CD  GLU A  90      22.137 -15.539  24.029  1.00 61.56           C  
ATOM    669  OE1 GLU A  90      21.954 -15.281  22.817  1.00 62.29           O  
ATOM    670  OE2 GLU A  90      22.529 -16.657  24.442  1.00 61.46           O  
ATOM    671  N   ARG A  91      20.558 -15.878  29.212  1.00 55.42           N  
ATOM    672  CA  ARG A  91      20.736 -16.429  30.551  1.00 54.10           C  
ATOM    673  C   ARG A  91      19.733 -17.569  30.735  1.00 52.93           C  
ATOM    674  O   ARG A  91      19.916 -18.431  31.588  1.00 53.25           O  
ATOM    675  CB  ARG A  91      20.490 -15.360  31.622  1.00 54.38           C  
ATOM    676  CG  ARG A  91      21.329 -14.090  31.498  1.00 55.47           C  
ATOM    677  CD  ARG A  91      20.925 -13.077  32.568  1.00 55.56           C  
ATOM    678  NE  ARG A  91      21.592 -11.795  32.389  1.00 57.39           N  
ATOM    679  CZ  ARG A  91      21.387 -10.985  31.356  1.00 59.69           C  
ATOM    680  NH1 ARG A  91      20.525 -11.323  30.406  1.00 59.85           N  
ATOM    681  NH2 ARG A  91      22.055  -9.844  31.257  1.00 59.15           N  
ATOM    682  N   GLY A  92      18.674 -17.566  29.932  1.00 50.05           N  
ATOM    683  CA  GLY A  92      17.682 -18.615  30.033  1.00 47.59           C  
ATOM    684  C   GLY A  92      16.397 -18.154  30.681  1.00 46.88           C  
ATOM    685  O   GLY A  92      15.428 -18.917  30.774  1.00 46.82           O  
ATOM    686  N   ARG A  93      16.385 -16.905  31.138  1.00 44.90           N  
ATOM    687  CA  ARG A  93      15.201 -16.347  31.768  1.00 42.41           C  
ATOM    688  C   ARG A  93      14.213 -15.865  30.728  1.00 40.72           C  
ATOM    689  O   ARG A  93      14.541 -15.715  29.556  1.00 40.10           O  
ATOM    690  CB  ARG A  93      15.553 -15.171  32.681  1.00 45.40           C  
ATOM    691  CG  ARG A  93      16.080 -15.533  34.057  1.00 48.71           C  
ATOM    692  CD  ARG A  93      17.523 -15.985  34.024  1.00 50.62           C  
ATOM    693  NE  ARG A  93      18.076 -16.124  35.373  1.00 56.28           N  
ATOM    694  CZ  ARG A  93      18.161 -15.134  36.262  1.00 59.20           C  
ATOM    695  NH1 ARG A  93      18.675 -15.355  37.468  1.00 60.44           N  
ATOM    696  NH2 ARG A  93      17.731 -13.917  35.950  1.00 61.70           N  
ATOM    697  N   LEU A  94      12.996 -15.623  31.201  1.00 40.52           N  
ATOM    698  CA  LEU A  94      11.870 -15.138  30.411  1.00 38.23           C  
ATOM    699  C   LEU A  94      11.740 -13.634  30.656  1.00 38.67           C  
ATOM    700  O   LEU A  94      11.467 -13.199  31.770  1.00 40.16           O  
ATOM    701  CB  LEU A  94      10.605 -15.838  30.880  1.00 34.74           C  
ATOM    702  CG  LEU A  94       9.288 -15.361  30.300  1.00 36.30           C  
ATOM    703  CD1 LEU A  94       9.315 -15.474  28.768  1.00 33.03           C  
ATOM    704  CD2 LEU A  94       8.164 -16.203  30.883  1.00 32.21           C  
ATOM    705  N   PRO A  95      11.944 -12.815  29.619  1.00 38.50           N  
ATOM    706  CA  PRO A  95      11.837 -11.362  29.791  1.00 37.21           C  
ATOM    707  C   PRO A  95      10.396 -10.929  30.057  1.00 34.52           C  
ATOM    708  O   PRO A  95       9.458 -11.426  29.438  1.00 36.69           O  
ATOM    709  CB  PRO A  95      12.389 -10.817  28.476  1.00 36.80           C  
ATOM    710  CG  PRO A  95      11.979 -11.870  27.494  1.00 39.52           C  
ATOM    711  CD  PRO A  95      12.296 -13.158  28.231  1.00 37.70           C  
ATOM    712  N   PHE A  96      10.243 -10.005  30.994  1.00 32.99           N  
ATOM    713  CA  PHE A  96       8.947  -9.477  31.405  1.00 31.94           C  
ATOM    714  C   PHE A  96       8.887  -7.957  31.227  1.00 32.87           C  
ATOM    715  O   PHE A  96       9.521  -7.229  31.997  1.00 34.41           O  
ATOM    716  CB  PHE A  96       8.725  -9.764  32.886  1.00 29.05           C  
ATOM    717  CG  PHE A  96       8.068 -11.077  33.177  1.00 26.65           C  
ATOM    718  CD1 PHE A  96       6.714 -11.124  33.518  1.00 24.62           C  
ATOM    719  CD2 PHE A  96       8.803 -12.263  33.155  1.00 24.92           C  
ATOM    720  CE1 PHE A  96       6.108 -12.326  33.838  1.00 20.57           C  
ATOM    721  CE2 PHE A  96       8.204 -13.474  33.473  1.00 22.84           C  
ATOM    722  CZ  PHE A  96       6.857 -13.512  33.818  1.00 22.92           C  
ATOM    723  N   LEU A  97       8.126  -7.472  30.242  1.00 32.45           N  
ATOM    724  CA  LEU A  97       7.987  -6.023  30.027  1.00 31.89           C  
ATOM    725  C   LEU A  97       6.919  -5.558  31.004  1.00 33.21           C  
ATOM    726  O   LEU A  97       5.754  -5.916  30.847  1.00 35.57           O  
ATOM    727  CB  LEU A  97       7.502  -5.717  28.610  1.00 31.02           C  
ATOM    728  CG  LEU A  97       8.026  -4.432  27.933  1.00 32.32           C  
ATOM    729  CD1 LEU A  97       7.019  -3.973  26.886  1.00 31.01           C  
ATOM    730  CD2 LEU A  97       8.238  -3.342  28.941  1.00 30.84           C  
ATOM    731  N   VAL A  98       7.279  -4.757  32.001  1.00 32.70           N  
ATOM    732  CA  VAL A  98       6.267  -4.341  32.972  1.00 32.41           C  
ATOM    733  C   VAL A  98       5.862  -2.868  32.929  1.00 31.94           C  
ATOM    734  O   VAL A  98       6.672  -1.978  33.173  1.00 32.18           O  
ATOM    735  CB  VAL A  98       6.715  -4.714  34.412  1.00 32.66           C  
ATOM    736  CG1 VAL A  98       5.604  -4.438  35.389  1.00 30.92           C  
ATOM    737  CG2 VAL A  98       7.101  -6.190  34.467  1.00 30.40           C  
ATOM    738  N   GLY A  99       4.592  -2.624  32.616  1.00 31.65           N  
ATOM    739  CA  GLY A  99       4.087  -1.263  32.559  1.00 31.81           C  
ATOM    740  C   GLY A  99       4.534  -0.411  31.380  1.00 31.27           C  
ATOM    741  O   GLY A  99       5.012  -0.933  30.371  1.00 31.53           O  
ATOM    742  N   GLY A 100       4.374   0.907  31.522  1.00 31.16           N  
ATOM    743  CA  GLY A 100       4.727   1.856  30.476  1.00 33.22           C  
ATOM    744  C   GLY A 100       3.477   2.320  29.735  1.00 34.05           C  
ATOM    745  O   GLY A 100       2.402   1.741  29.918  1.00 35.53           O  
ATOM    746  N   THR A 101       3.595   3.360  28.911  1.00 33.64           N  
ATOM    747  CA  THR A 101       2.442   3.855  28.148  1.00 34.09           C  
ATOM    748  C   THR A 101       2.152   2.969  26.938  1.00 34.50           C  
ATOM    749  O   THR A 101       2.991   2.162  26.548  1.00 31.58           O  
ATOM    750  CB  THR A 101       2.685   5.263  27.618  1.00 33.75           C  
ATOM    751  OG1 THR A 101       3.730   5.224  26.637  1.00 36.72           O  
ATOM    752  CG2 THR A 101       3.102   6.189  28.750  1.00 34.18           C  
ATOM    753  N   GLY A 102       0.966   3.129  26.349  1.00 36.58           N  
ATOM    754  CA  GLY A 102       0.593   2.345  25.183  1.00 37.21           C  
ATOM    755  C   GLY A 102       1.591   2.535  24.048  1.00 41.10           C  
ATOM    756  O   GLY A 102       1.771   1.654  23.205  1.00 40.68           O  
ATOM    757  N   LEU A 103       2.256   3.691  24.042  1.00 41.57           N  
ATOM    758  CA  LEU A 103       3.247   4.027  23.020  1.00 41.51           C  
ATOM    759  C   LEU A 103       4.519   3.189  23.206  1.00 42.52           C  
ATOM    760  O   LEU A 103       4.921   2.459  22.296  1.00 43.31           O  
ATOM    761  CB  LEU A 103       3.589   5.526  23.098  1.00 41.13           C  
ATOM    762  CG  LEU A 103       4.172   6.266  21.880  1.00 42.93           C  
ATOM    763  CD1 LEU A 103       4.638   7.632  22.328  1.00 40.09           C  
ATOM    764  CD2 LEU A 103       5.331   5.495  21.256  1.00 41.55           C  
ATOM    765  N   TYR A 104       5.155   3.286  24.375  1.00 42.12           N  
ATOM    766  CA  TYR A 104       6.374   2.507  24.637  1.00 43.53           C  
ATOM    767  C   TYR A 104       6.209   1.002  24.359  1.00 43.03           C  
ATOM    768  O   TYR A 104       7.044   0.388  23.689  1.00 42.69           O  
ATOM    769  CB  TYR A 104       6.848   2.694  26.089  1.00 45.75           C  
ATOM    770  CG  TYR A 104       7.520   4.026  26.384  1.00 45.80           C  
ATOM    771  CD1 TYR A 104       8.582   4.101  27.282  1.00 47.53           C  
ATOM    772  CD2 TYR A 104       7.134   5.192  25.729  1.00 46.24           C  
ATOM    773  CE1 TYR A 104       9.255   5.296  27.513  1.00 48.04           C  
ATOM    774  CE2 TYR A 104       7.801   6.400  25.954  1.00 46.44           C  
ATOM    775  CZ  TYR A 104       8.866   6.438  26.842  1.00 47.62           C  
ATOM    776  OH  TYR A 104       9.586   7.599  27.007  1.00 48.87           O  
ATOM    777  N   VAL A 105       5.134   0.406  24.869  1.00 41.95           N  
ATOM    778  CA  VAL A 105       4.919  -1.018  24.660  1.00 43.02           C  
ATOM    779  C   VAL A 105       4.689  -1.373  23.191  1.00 42.73           C  
ATOM    780  O   VAL A 105       5.200  -2.385  22.702  1.00 42.37           O  
ATOM    781  CB  VAL A 105       3.741  -1.539  25.505  1.00 42.49           C  
ATOM    782  CG1 VAL A 105       4.105  -1.498  26.974  1.00 41.62           C  
ATOM    783  CG2 VAL A 105       2.513  -0.701  25.249  1.00 45.45           C  
ATOM    784  N   ASN A 106       3.926  -0.545  22.484  1.00 41.98           N  
ATOM    785  CA  ASN A 106       3.664  -0.803  21.070  1.00 42.08           C  
ATOM    786  C   ASN A 106       4.942  -0.709  20.228  1.00 41.24           C  
ATOM    787  O   ASN A 106       5.075  -1.407  19.231  1.00 39.43           O  
ATOM    788  CB  ASN A 106       2.604   0.166  20.525  1.00 40.10           C  
ATOM    789  CG  ASN A 106       1.271  -0.522  20.227  1.00 41.38           C  
ATOM    790  OD1 ASN A 106       0.331   0.111  19.737  1.00 42.03           O  
ATOM    791  ND2 ASN A 106       1.183  -1.822  20.523  1.00 39.69           N  
ATOM    792  N   ALA A 107       5.883   0.138  20.640  1.00 41.30           N  
ATOM    793  CA  ALA A 107       7.129   0.295  19.900  1.00 41.14           C  
ATOM    794  C   ALA A 107       8.067  -0.894  20.078  1.00 42.53           C  
ATOM    795  O   ALA A 107       8.834  -1.222  19.174  1.00 44.99           O  
ATOM    796  CB  ALA A 107       7.839   1.579  20.314  1.00 38.36           C  
ATOM    797  N   VAL A 108       8.030  -1.539  21.236  1.00 42.63           N  
ATOM    798  CA  VAL A 108       8.905  -2.681  21.453  1.00 43.27           C  
ATOM    799  C   VAL A 108       8.295  -3.963  20.920  1.00 44.25           C  
ATOM    800  O   VAL A 108       8.946  -4.689  20.167  1.00 46.20           O  
ATOM    801  CB  VAL A 108       9.249  -2.873  22.953  1.00 43.92           C  
ATOM    802  CG1 VAL A 108       9.795  -4.270  23.194  1.00 41.96           C  
ATOM    803  CG2 VAL A 108      10.294  -1.843  23.378  1.00 43.44           C  
ATOM    804  N   ILE A 109       7.050  -4.237  21.297  1.00 43.12           N  
ATOM    805  CA  ILE A 109       6.382  -5.453  20.859  1.00 42.72           C  
ATOM    806  C   ILE A 109       6.076  -5.453  19.371  1.00 42.38           C  
ATOM    807  O   ILE A 109       5.700  -6.475  18.820  1.00 43.56           O  
ATOM    808  CB  ILE A 109       5.063  -5.679  21.612  1.00 42.34           C  
ATOM    809  CG1 ILE A 109       4.011  -4.686  21.118  1.00 44.07           C  
ATOM    810  CG2 ILE A 109       5.291  -5.520  23.116  1.00 42.77           C  
ATOM    811  CD1 ILE A 109       2.650  -4.863  21.758  1.00 44.79           C  
ATOM    812  N   HIS A 110       6.216  -4.313  18.710  1.00 41.56           N  
ATOM    813  CA  HIS A 110       5.940  -4.276  17.276  1.00 40.84           C  
ATOM    814  C   HIS A 110       7.104  -3.738  16.477  1.00 41.39           C  
ATOM    815  O   HIS A 110       6.972  -3.467  15.277  1.00 41.25           O  
ATOM    816  CB  HIS A 110       4.702  -3.437  16.996  1.00 38.72           C  
ATOM    817  CG  HIS A 110       3.428  -4.119  17.367  1.00 38.74           C  
ATOM    818  ND1 HIS A 110       2.362  -3.449  17.928  1.00 41.10           N  
ATOM    819  CD2 HIS A 110       3.035  -5.406  17.232  1.00 38.05           C  
ATOM    820  CE1 HIS A 110       1.366  -4.296  18.123  1.00 40.28           C  
ATOM    821  NE2 HIS A 110       1.748  -5.490  17.707  1.00 36.92           N  
ATOM    822  N   GLN A 111       8.241  -3.585  17.154  1.00 41.47           N  
ATOM    823  CA  GLN A 111       9.465  -3.085  16.540  1.00 41.94           C  
ATOM    824  C   GLN A 111       9.224  -1.880  15.635  1.00 40.16           C  
ATOM    825  O   GLN A 111       9.558  -1.921  14.457  1.00 40.37           O  
ATOM    826  CB  GLN A 111      10.139  -4.197  15.729  1.00 44.53           C  
ATOM    827  CG  GLN A 111      10.991  -5.171  16.537  1.00 48.45           C  
ATOM    828  CD  GLN A 111      12.161  -4.495  17.237  1.00 52.25           C  
ATOM    829  OE1 GLN A 111      11.991  -3.861  18.283  1.00 54.91           O  
ATOM    830  NE2 GLN A 111      13.357  -4.616  16.655  1.00 52.75           N  
ATOM    831  N   PHE A 112       8.641  -0.817  16.181  1.00 38.74           N  
ATOM    832  CA  PHE A 112       8.374   0.387  15.409  1.00 37.00           C  
ATOM    833  C   PHE A 112       9.653   0.885  14.742  1.00 35.88           C  
ATOM    834  O   PHE A 112      10.757   0.652  15.238  1.00 35.40           O  
ATOM    835  CB  PHE A 112       7.815   1.490  16.318  1.00 37.19           C  
ATOM    836  CG  PHE A 112       6.341   1.380  16.591  1.00 35.84           C  
ATOM    837  CD1 PHE A 112       5.586   0.330  16.072  1.00 36.23           C  
ATOM    838  CD2 PHE A 112       5.697   2.358  17.354  1.00 36.14           C  
ATOM    839  CE1 PHE A 112       4.207   0.259  16.306  1.00 35.65           C  
ATOM    840  CE2 PHE A 112       4.325   2.300  17.594  1.00 32.97           C  
ATOM    841  CZ  PHE A 112       3.575   1.248  17.070  1.00 33.22           C  
ATOM    842  N   ASN A 113       9.492   1.568  13.614  1.00 34.29           N  
ATOM    843  CA  ASN A 113      10.620   2.129  12.879  1.00 35.00           C  
ATOM    844  C   ASN A 113      10.719   3.605  13.303  1.00 33.73           C  
ATOM    845  O   ASN A 113      10.236   4.493  12.601  1.00 34.17           O  
ATOM    846  CB  ASN A 113      10.341   2.029  11.378  1.00 34.99           C  
ATOM    847  CG  ASN A 113      11.538   2.401  10.523  1.00 34.11           C  
ATOM    848  OD1 ASN A 113      12.359   3.240  10.894  1.00 32.41           O  
ATOM    849  ND2 ASN A 113      11.629   1.780   9.355  1.00 35.10           N  
ATOM    850  N   LEU A 114      11.334   3.861  14.450  1.00 33.51           N  
ATOM    851  CA  LEU A 114      11.452   5.224  14.964  1.00 34.08           C  
ATOM    852  C   LEU A 114      12.557   6.033  14.302  1.00 35.26           C  
ATOM    853  O   LEU A 114      13.601   5.489  13.928  1.00 35.23           O  
ATOM    854  CB  LEU A 114      11.656   5.194  16.484  1.00 31.78           C  
ATOM    855  CG  LEU A 114      10.528   4.544  17.302  1.00 29.15           C  
ATOM    856  CD1 LEU A 114      10.902   4.527  18.788  1.00 32.92           C  
ATOM    857  CD2 LEU A 114       9.246   5.314  17.106  1.00 25.29           C  
ATOM    858  N   GLY A 115      12.322   7.333  14.147  1.00 36.90           N  
ATOM    859  CA  GLY A 115      13.317   8.184  13.517  1.00 40.72           C  
ATOM    860  C   GLY A 115      13.334   9.587  14.090  1.00 42.35           C  
ATOM    861  O   GLY A 115      12.511   9.911  14.938  1.00 44.03           O  
ATOM    862  N   GLU A 185      -0.634  -3.053  14.983  1.00 69.26           N  
ATOM    863  CA  GLU A 185      -1.393  -3.350  13.773  1.00 68.97           C  
ATOM    864  C   GLU A 185      -1.028  -4.750  13.272  1.00 67.71           C  
ATOM    865  O   GLU A 185      -1.833  -5.687  13.354  1.00 67.58           O  
ATOM    866  CB  GLU A 185      -1.082  -2.309  12.691  1.00 70.89           C  
ATOM    867  CG  GLU A 185      -2.153  -2.200  11.616  1.00 71.99           C  
ATOM    868  CD  GLU A 185      -3.461  -1.651  12.161  1.00 72.71           C  
ATOM    869  OE1 GLU A 185      -4.490  -1.750  11.453  1.00 72.35           O  
ATOM    870  OE2 GLU A 185      -3.453  -1.114  13.294  1.00 72.70           O  
ATOM    871  N   THR A 186       0.189  -4.879  12.747  1.00 64.80           N  
ATOM    872  CA  THR A 186       0.695  -6.152  12.241  1.00 62.02           C  
ATOM    873  C   THR A 186       1.131  -7.006  13.434  1.00 60.37           C  
ATOM    874  O   THR A 186       1.468  -6.468  14.488  1.00 61.18           O  
ATOM    875  CB  THR A 186       1.903  -5.929  11.334  1.00 61.86           C  
ATOM    876  OG1 THR A 186       2.929  -5.261  12.076  1.00 62.85           O  
ATOM    877  CG2 THR A 186       1.526  -5.065  10.141  1.00 61.23           C  
ATOM    878  N   PRO A 187       1.126  -8.344  13.287  1.00 57.82           N  
ATOM    879  CA  PRO A 187       1.528  -9.243  14.374  1.00 55.40           C  
ATOM    880  C   PRO A 187       2.917  -8.954  14.923  1.00 54.04           C  
ATOM    881  O   PRO A 187       3.795  -8.488  14.195  1.00 54.20           O  
ATOM    882  CB  PRO A 187       1.442 -10.628  13.731  1.00 55.64           C  
ATOM    883  CG  PRO A 187       1.700 -10.352  12.291  1.00 56.28           C  
ATOM    884  CD  PRO A 187       0.878  -9.109  12.053  1.00 57.07           C  
ATOM    885  N   SER A 188       3.116  -9.242  16.207  1.00 52.17           N  
ATOM    886  CA  SER A 188       4.406  -9.007  16.846  1.00 50.17           C  
ATOM    887  C   SER A 188       5.452 -10.031  16.476  1.00 50.40           C  
ATOM    888  O   SER A 188       5.160 -11.223  16.395  1.00 51.19           O  
ATOM    889  CB  SER A 188       4.291  -9.023  18.357  1.00 48.38           C  
ATOM    890  OG  SER A 188       5.600  -9.014  18.908  1.00 45.10           O  
ATOM    891  N   PRO A 189       6.699  -9.583  16.272  1.00 49.75           N  
ATOM    892  CA  PRO A 189       7.780 -10.499  15.917  1.00 49.43           C  
ATOM    893  C   PRO A 189       8.152 -11.407  17.088  1.00 49.34           C  
ATOM    894  O   PRO A 189       8.966 -12.322  16.942  1.00 50.77           O  
ATOM    895  CB  PRO A 189       8.911  -9.554  15.530  1.00 49.62           C  
ATOM    896  CG  PRO A 189       8.665  -8.370  16.409  1.00 48.76           C  
ATOM    897  CD  PRO A 189       7.175  -8.190  16.263  1.00 49.28           C  
ATOM    898  N   TYR A 190       7.558 -11.137  18.249  1.00 48.17           N  
ATOM    899  CA  TYR A 190       7.796 -11.927  19.455  1.00 45.64           C  
ATOM    900  C   TYR A 190       6.611 -12.857  19.699  1.00 45.98           C  
ATOM    901  O   TYR A 190       5.577 -12.752  19.043  1.00 46.01           O  
ATOM    902  CB  TYR A 190       7.940 -11.026  20.692  1.00 43.51           C  
ATOM    903  CG  TYR A 190       9.096 -10.045  20.669  1.00 41.14           C  
ATOM    904  CD1 TYR A 190       8.944  -8.765  20.138  1.00 42.78           C  
ATOM    905  CD2 TYR A 190      10.346 -10.399  21.175  1.00 40.88           C  
ATOM    906  CE1 TYR A 190      10.011  -7.863  20.112  1.00 39.93           C  
ATOM    907  CE2 TYR A 190      11.420  -9.504  21.151  1.00 38.56           C  
ATOM    908  CZ  TYR A 190      11.240  -8.243  20.617  1.00 37.16           C  
ATOM    909  OH  TYR A 190      12.288  -7.367  20.565  1.00 35.04           O  
ATOM    910  N   ASN A 191       6.792 -13.781  20.640  1.00 45.55           N  
ATOM    911  CA  ASN A 191       5.753 -14.714  21.065  1.00 44.73           C  
ATOM    912  C   ASN A 191       5.377 -14.044  22.376  1.00 44.14           C  
ATOM    913  O   ASN A 191       5.880 -14.393  23.448  1.00 43.67           O  
ATOM    914  CB  ASN A 191       6.342 -16.110  21.305  1.00 46.12           C  
ATOM    915  CG  ASN A 191       5.298 -17.129  21.748  1.00 46.94           C  
ATOM    916  OD1 ASN A 191       4.119 -17.005  21.431  1.00 50.18           O  
ATOM    917  ND2 ASN A 191       5.739 -18.159  22.465  1.00 46.77           N  
ATOM    918  N   LEU A 192       4.525 -13.036  22.253  1.00 43.92           N  
ATOM    919  CA  LEU A 192       4.091 -12.225  23.378  1.00 43.24           C  
ATOM    920  C   LEU A 192       2.852 -12.729  24.079  1.00 41.46           C  
ATOM    921  O   LEU A 192       1.956 -13.290  23.460  1.00 40.43           O  
ATOM    922  CB  LEU A 192       3.819 -10.797  22.903  1.00 43.14           C  
ATOM    923  CG  LEU A 192       4.381  -9.642  23.731  1.00 45.39           C  
ATOM    924  CD1 LEU A 192       3.673  -8.361  23.298  1.00 47.98           C  
ATOM    925  CD2 LEU A 192       4.172  -9.878  25.225  1.00 46.11           C  
ATOM    926  N   VAL A 193       2.802 -12.504  25.381  1.00 41.81           N  
ATOM    927  CA  VAL A 193       1.642 -12.886  26.158  1.00 44.62           C  
ATOM    928  C   VAL A 193       1.162 -11.664  26.935  1.00 45.25           C  
ATOM    929  O   VAL A 193       1.385 -11.566  28.138  1.00 48.52           O  
ATOM    930  CB  VAL A 193       1.969 -13.993  27.160  1.00 45.81           C  
ATOM    931  CG1 VAL A 193       0.707 -14.371  27.907  1.00 45.46           C  
ATOM    932  CG2 VAL A 193       2.556 -15.208  26.443  1.00 47.99           C  
HETATM  933  N   MSE A 194       0.506 -10.736  26.243  1.00 44.90           N  
HETATM  934  CA  MSE A 194       0.003  -9.509  26.858  1.00 42.63           C  
HETATM  935  C   MSE A 194      -1.126  -9.712  27.860  1.00 39.25           C  
HETATM  936  O   MSE A 194      -2.219 -10.165  27.506  1.00 37.25           O  
HETATM  937  CB  MSE A 194      -0.498  -8.544  25.788  1.00 47.54           C  
HETATM  938  CG  MSE A 194       0.567  -7.818  24.996  1.00 55.69           C  
HETATM  939 SE   MSE A 194       0.231  -5.896  25.025  1.00 65.73          SE  
HETATM  940  CE  MSE A 194       2.025  -5.283  25.363  1.00 61.39           C  
ATOM    941  N   ILE A 195      -0.872  -9.359  29.110  1.00 34.44           N  
ATOM    942  CA  ILE A 195      -1.899  -9.482  30.124  1.00 32.16           C  
ATOM    943  C   ILE A 195      -2.211  -8.102  30.691  1.00 29.97           C  
ATOM    944  O   ILE A 195      -1.320  -7.268  30.887  1.00 27.98           O  
ATOM    945  CB  ILE A 195      -1.451 -10.427  31.243  1.00 33.57           C  
ATOM    946  CG1 ILE A 195      -0.183  -9.903  31.894  1.00 32.84           C  
ATOM    947  CG2 ILE A 195      -1.162 -11.808  30.656  1.00 36.53           C  
ATOM    948  CD1 ILE A 195       0.492 -10.919  32.741  1.00 36.40           C  
ATOM    949  N   GLY A 196      -3.485  -7.865  30.946  1.00 29.75           N  
ATOM    950  CA  GLY A 196      -3.895  -6.588  31.479  1.00 30.04           C  
ATOM    951  C   GLY A 196      -4.471  -6.748  32.856  1.00 29.98           C  
ATOM    952  O   GLY A 196      -5.198  -7.709  33.138  1.00 30.21           O  
ATOM    953  N   LEU A 197      -4.142  -5.799  33.721  1.00 30.29           N  
ATOM    954  CA  LEU A 197      -4.632  -5.829  35.088  1.00 31.27           C  
ATOM    955  C   LEU A 197      -5.642  -4.715  35.307  1.00 32.80           C  
ATOM    956  O   LEU A 197      -5.296  -3.543  35.222  1.00 34.74           O  
ATOM    957  CB  LEU A 197      -3.457  -5.681  36.054  1.00 27.25           C  
ATOM    958  CG  LEU A 197      -2.378  -6.765  35.911  1.00 28.06           C  
ATOM    959  CD1 LEU A 197      -1.413  -6.679  37.106  1.00 23.82           C  
ATOM    960  CD2 LEU A 197      -3.025  -8.143  35.853  1.00 22.00           C  
ATOM    961  N   THR A 198      -6.891  -5.084  35.564  1.00 34.94           N  
ATOM    962  CA  THR A 198      -7.941  -4.100  35.816  1.00 37.72           C  
ATOM    963  C   THR A 198      -8.468  -4.213  37.224  1.00 38.44           C  
ATOM    964  O   THR A 198      -8.152  -5.153  37.953  1.00 36.68           O  
ATOM    965  CB  THR A 198      -9.174  -4.256  34.910  1.00 38.40           C  
ATOM    966  OG1 THR A 198      -9.524  -5.642  34.814  1.00 37.80           O  
ATOM    967  CG2 THR A 198      -8.928  -3.655  33.566  1.00 39.06           C  
HETATM  968  N   MSE A 199      -9.326  -3.257  37.566  1.00 39.80           N  
HETATM  969  CA  MSE A 199      -9.913  -3.178  38.889  1.00 42.08           C  
HETATM  970  C   MSE A 199     -11.165  -2.305  38.805  1.00 42.89           C  
HETATM  971  O   MSE A 199     -11.316  -1.519  37.871  1.00 42.38           O  
HETATM  972  CB  MSE A 199      -8.870  -2.556  39.815  1.00 43.44           C  
HETATM  973  CG  MSE A 199      -9.217  -2.476  41.282  1.00 45.68           C  
HETATM  974 SE   MSE A 199      -7.654  -1.841  42.277  1.00 54.38          SE  
HETATM  975  CE  MSE A 199      -6.712  -3.525  42.509  1.00 46.66           C  
ATOM    976  N   GLU A 200     -12.063  -2.454  39.771  1.00 44.40           N  
ATOM    977  CA  GLU A 200     -13.292  -1.665  39.799  1.00 49.22           C  
ATOM    978  C   GLU A 200     -13.031  -0.166  39.926  1.00 49.85           C  
ATOM    979  O   GLU A 200     -12.438   0.284  40.909  1.00 49.94           O  
ATOM    980  CB  GLU A 200     -14.172  -2.121  40.950  1.00 50.46           C  
ATOM    981  CG  GLU A 200     -15.075  -3.257  40.577  1.00 53.74           C  
ATOM    982  CD  GLU A 200     -15.482  -4.069  41.776  1.00 56.02           C  
ATOM    983  OE1 GLU A 200     -15.951  -3.466  42.778  1.00 57.17           O  
ATOM    984  OE2 GLU A 200     -15.336  -5.313  41.712  1.00 56.95           O  
ATOM    985  N   ARG A 201     -13.501   0.595  38.938  1.00 51.21           N  
ATOM    986  CA  ARG A 201     -13.313   2.046  38.890  1.00 53.72           C  
ATOM    987  C   ARG A 201     -13.120   2.732  40.252  1.00 53.70           C  
ATOM    988  O   ARG A 201     -12.135   3.440  40.460  1.00 54.86           O  
ATOM    989  CB  ARG A 201     -14.475   2.706  38.138  1.00 56.57           C  
ATOM    990  CG  ARG A 201     -14.084   4.025  37.495  1.00 62.41           C  
ATOM    991  CD  ARG A 201     -15.216   4.640  36.678  1.00 64.68           C  
ATOM    992  NE  ARG A 201     -16.362   5.005  37.506  1.00 66.81           N  
ATOM    993  CZ  ARG A 201     -17.374   5.755  37.085  1.00 67.84           C  
ATOM    994  NH1 ARG A 201     -17.377   6.218  35.842  1.00 68.43           N  
ATOM    995  NH2 ARG A 201     -18.381   6.040  37.904  1.00 68.00           N  
ATOM    996  N   ASP A 202     -14.049   2.526  41.177  1.00 53.55           N  
ATOM    997  CA  ASP A 202     -13.952   3.127  42.504  1.00 53.07           C  
ATOM    998  C   ASP A 202     -12.688   2.740  43.250  1.00 51.50           C  
ATOM    999  O   ASP A 202     -11.888   3.595  43.616  1.00 51.60           O  
ATOM   1000  CB  ASP A 202     -15.151   2.728  43.358  1.00 56.15           C  
ATOM   1001  CG  ASP A 202     -16.357   3.590  43.100  1.00 58.86           C  
ATOM   1002  OD1 ASP A 202     -17.463   3.196  43.540  1.00 61.32           O  
ATOM   1003  OD2 ASP A 202     -16.199   4.663  42.473  1.00 59.92           O  
ATOM   1004  N   VAL A 203     -12.520   1.445  43.489  1.00 50.12           N  
ATOM   1005  CA  VAL A 203     -11.358   0.969  44.219  1.00 47.61           C  
ATOM   1006  C   VAL A 203     -10.075   1.514  43.609  1.00 46.46           C  
ATOM   1007  O   VAL A 203      -9.139   1.853  44.333  1.00 46.65           O  
ATOM   1008  CB  VAL A 203     -11.292  -0.582  44.240  1.00 48.05           C  
ATOM   1009  CG1 VAL A 203     -10.103  -1.041  45.062  1.00 45.83           C  
ATOM   1010  CG2 VAL A 203     -12.589  -1.154  44.808  1.00 46.52           C  
ATOM   1011  N   LEU A 204     -10.027   1.600  42.281  1.00 43.57           N  
ATOM   1012  CA  LEU A 204      -8.834   2.113  41.618  1.00 42.65           C  
ATOM   1013  C   LEU A 204      -8.566   3.570  41.990  1.00 42.53           C  
ATOM   1014  O   LEU A 204      -7.438   3.936  42.325  1.00 41.14           O  
ATOM   1015  CB  LEU A 204      -8.968   2.001  40.100  1.00 41.78           C  
ATOM   1016  CG  LEU A 204      -7.732   2.487  39.330  1.00 41.77           C  
ATOM   1017  CD1 LEU A 204      -6.519   1.678  39.749  1.00 42.13           C  
ATOM   1018  CD2 LEU A 204      -7.969   2.358  37.835  1.00 42.78           C  
ATOM   1019  N   TYR A 205      -9.608   4.396  41.924  1.00 43.49           N  
ATOM   1020  CA  TYR A 205      -9.470   5.808  42.248  1.00 44.66           C  
ATOM   1021  C   TYR A 205      -9.126   5.989  43.721  1.00 47.10           C  
ATOM   1022  O   TYR A 205      -8.262   6.796  44.086  1.00 49.37           O  
ATOM   1023  CB  TYR A 205     -10.755   6.572  41.905  1.00 43.37           C  
ATOM   1024  CG  TYR A 205     -10.998   6.711  40.422  1.00 43.76           C  
ATOM   1025  CD1 TYR A 205     -10.012   6.369  39.509  1.00 43.52           C  
ATOM   1026  CD2 TYR A 205     -12.206   7.201  39.930  1.00 44.17           C  
ATOM   1027  CE1 TYR A 205     -10.213   6.505  38.148  1.00 44.43           C  
ATOM   1028  CE2 TYR A 205     -12.422   7.346  38.557  1.00 44.79           C  
ATOM   1029  CZ  TYR A 205     -11.410   6.993  37.667  1.00 45.37           C  
ATOM   1030  OH  TYR A 205     -11.577   7.123  36.298  1.00 44.54           O  
ATOM   1031  N   ASP A 206      -9.791   5.218  44.567  1.00 46.79           N  
ATOM   1032  CA  ASP A 206      -9.554   5.298  45.996  1.00 47.99           C  
ATOM   1033  C   ASP A 206      -8.103   4.949  46.327  1.00 46.64           C  
ATOM   1034  O   ASP A 206      -7.486   5.594  47.172  1.00 48.53           O  
ATOM   1035  CB  ASP A 206     -10.523   4.357  46.718  1.00 50.22           C  
ATOM   1036  CG  ASP A 206     -10.494   4.523  48.213  1.00 51.54           C  
ATOM   1037  OD1 ASP A 206     -11.519   4.193  48.849  1.00 53.68           O  
ATOM   1038  OD2 ASP A 206      -9.458   4.966  48.754  1.00 52.36           O  
ATOM   1039  N   ARG A 207      -7.553   3.939  45.663  1.00 45.13           N  
ATOM   1040  CA  ARG A 207      -6.176   3.542  45.930  1.00 44.09           C  
ATOM   1041  C   ARG A 207      -5.210   4.604  45.425  1.00 43.65           C  
ATOM   1042  O   ARG A 207      -4.184   4.853  46.046  1.00 43.64           O  
ATOM   1043  CB  ARG A 207      -5.886   2.186  45.283  1.00 43.91           C  
ATOM   1044  CG  ARG A 207      -6.473   1.018  46.057  1.00 43.02           C  
ATOM   1045  CD  ARG A 207      -6.578  -0.236  45.207  1.00 43.12           C  
ATOM   1046  NE  ARG A 207      -5.297  -0.752  44.710  1.00 43.47           N  
ATOM   1047  CZ  ARG A 207      -4.480  -1.545  45.399  1.00 43.88           C  
ATOM   1048  NH1 ARG A 207      -4.789  -1.921  46.633  1.00 45.46           N  
ATOM   1049  NH2 ARG A 207      -3.373  -1.995  44.838  1.00 41.82           N  
ATOM   1050  N   ILE A 208      -5.560   5.232  44.306  1.00 44.22           N  
ATOM   1051  CA  ILE A 208      -4.755   6.288  43.702  1.00 44.52           C  
ATOM   1052  C   ILE A 208      -4.722   7.518  44.614  1.00 46.07           C  
ATOM   1053  O   ILE A 208      -3.675   8.144  44.801  1.00 45.94           O  
ATOM   1054  CB  ILE A 208      -5.326   6.676  42.318  1.00 43.19           C  
ATOM   1055  CG1 ILE A 208      -4.897   5.640  41.283  1.00 42.43           C  
ATOM   1056  CG2 ILE A 208      -4.880   8.072  41.920  1.00 40.42           C  
ATOM   1057  CD1 ILE A 208      -5.334   5.970  39.878  1.00 40.05           C  
ATOM   1058  N   ASN A 209      -5.873   7.871  45.171  1.00 46.16           N  
ATOM   1059  CA  ASN A 209      -5.924   9.004  46.075  1.00 47.31           C  
ATOM   1060  C   ASN A 209      -5.066   8.688  47.294  1.00 47.93           C  
ATOM   1061  O   ASN A 209      -4.222   9.488  47.685  1.00 46.73           O  
ATOM   1062  CB  ASN A 209      -7.361   9.297  46.506  1.00 46.05           C  
ATOM   1063  CG  ASN A 209      -8.272   9.587  45.329  1.00 47.09           C  
ATOM   1064  OD1 ASN A 209      -7.822  10.090  44.295  1.00 44.96           O  
ATOM   1065  ND2 ASN A 209      -9.562   9.278  45.481  1.00 43.85           N  
ATOM   1066  N   ARG A 210      -5.264   7.517  47.888  1.00 49.63           N  
ATOM   1067  CA  ARG A 210      -4.479   7.142  49.060  1.00 52.73           C  
ATOM   1068  C   ARG A 210      -2.990   7.117  48.722  1.00 51.80           C  
ATOM   1069  O   ARG A 210      -2.155   7.516  49.530  1.00 51.88           O  
ATOM   1070  CB  ARG A 210      -4.940   5.776  49.595  1.00 57.11           C  
ATOM   1071  CG  ARG A 210      -4.216   5.303  50.865  1.00 61.65           C  
ATOM   1072  CD  ARG A 210      -5.154   4.514  51.789  1.00 65.12           C  
ATOM   1073  NE  ARG A 210      -6.066   3.647  51.041  1.00 69.15           N  
ATOM   1074  CZ  ARG A 210      -6.991   2.857  51.589  1.00 71.48           C  
ATOM   1075  NH1 ARG A 210      -7.146   2.802  52.909  1.00 71.55           N  
ATOM   1076  NH2 ARG A 210      -7.778   2.125  50.810  1.00 71.47           N  
ATOM   1077  N   ARG A 211      -2.674   6.656  47.517  1.00 51.06           N  
ATOM   1078  CA  ARG A 211      -1.300   6.581  47.024  1.00 49.66           C  
ATOM   1079  C   ARG A 211      -0.644   7.959  47.155  1.00 48.19           C  
ATOM   1080  O   ARG A 211       0.461   8.085  47.667  1.00 46.42           O  
ATOM   1081  CB  ARG A 211      -1.331   6.162  45.553  1.00 52.20           C  
ATOM   1082  CG  ARG A 211      -0.406   5.027  45.168  1.00 54.87           C  
ATOM   1083  CD  ARG A 211       1.021   5.486  45.110  1.00 58.33           C  
ATOM   1084  NE  ARG A 211       1.713   5.021  43.904  1.00 62.17           N  
ATOM   1085  CZ  ARG A 211       1.530   5.523  42.684  1.00 64.10           C  
ATOM   1086  NH1 ARG A 211       0.668   6.513  42.486  1.00 65.41           N  
ATOM   1087  NH2 ARG A 211       2.228   5.048  41.661  1.00 64.77           N  
ATOM   1088  N   VAL A 212      -1.348   8.982  46.681  1.00 47.01           N  
ATOM   1089  CA  VAL A 212      -0.868  10.354  46.728  1.00 46.06           C  
ATOM   1090  C   VAL A 212      -0.627  10.831  48.164  1.00 45.85           C  
ATOM   1091  O   VAL A 212       0.338  11.551  48.432  1.00 45.24           O  
ATOM   1092  CB  VAL A 212      -1.872  11.305  46.031  1.00 46.57           C  
ATOM   1093  CG1 VAL A 212      -1.357  12.738  46.061  1.00 46.21           C  
ATOM   1094  CG2 VAL A 212      -2.096  10.859  44.587  1.00 45.66           C  
ATOM   1095  N   ASP A 213      -1.507  10.431  49.081  1.00 44.49           N  
ATOM   1096  CA  ASP A 213      -1.384  10.804  50.486  1.00 44.81           C  
ATOM   1097  C   ASP A 213      -0.061  10.320  51.055  1.00 45.16           C  
ATOM   1098  O   ASP A 213       0.613  11.038  51.787  1.00 44.60           O  
ATOM   1099  CB  ASP A 213      -2.531  10.215  51.309  1.00 45.86           C  
ATOM   1100  CG  ASP A 213      -3.837  10.925  51.074  1.00 46.18           C  
ATOM   1101  OD1 ASP A 213      -3.803  12.148  50.830  1.00 50.25           O  
ATOM   1102  OD2 ASP A 213      -4.898  10.271  51.145  1.00 48.29           O  
ATOM   1103  N   GLN A 214       0.304   9.092  50.717  1.00 46.74           N  
ATOM   1104  CA  GLN A 214       1.555   8.531  51.175  1.00 48.24           C  
ATOM   1105  C   GLN A 214       2.739   9.313  50.617  1.00 47.11           C  
ATOM   1106  O   GLN A 214       3.729   9.508  51.313  1.00 46.90           O  
ATOM   1107  CB  GLN A 214       1.660   7.065  50.759  1.00 52.53           C  
ATOM   1108  CG  GLN A 214       0.799   6.117  51.575  1.00 58.76           C  
ATOM   1109  CD  GLN A 214       0.879   4.680  51.069  1.00 62.30           C  
ATOM   1110  OE1 GLN A 214       1.971   4.156  50.810  1.00 64.48           O  
ATOM   1111  NE2 GLN A 214      -0.279   4.031  50.937  1.00 62.99           N  
HETATM 1112  N   MSE A 215       2.652   9.767  49.370  1.00 46.98           N  
HETATM 1113  CA  MSE A 215       3.770  10.520  48.798  1.00 48.72           C  
HETATM 1114  C   MSE A 215       3.961  11.826  49.551  1.00 48.94           C  
HETATM 1115  O   MSE A 215       5.092  12.261  49.788  1.00 48.37           O  
HETATM 1116  CB  MSE A 215       3.543  10.836  47.318  1.00 48.21           C  
HETATM 1117  CG  MSE A 215       3.427   9.623  46.422  1.00 47.79           C  
HETATM 1118 SE   MSE A 215       3.107  10.139  44.580  1.00 50.84          SE  
HETATM 1119  CE  MSE A 215       4.408   9.010  43.729  1.00 51.69           C  
ATOM   1120  N   VAL A 216       2.849  12.450  49.919  1.00 49.10           N  
ATOM   1121  CA  VAL A 216       2.908  13.704  50.645  1.00 51.24           C  
ATOM   1122  C   VAL A 216       3.484  13.480  52.034  1.00 52.46           C  
ATOM   1123  O   VAL A 216       4.275  14.289  52.521  1.00 53.41           O  
ATOM   1124  CB  VAL A 216       1.514  14.349  50.763  1.00 51.51           C  
ATOM   1125  CG1 VAL A 216       1.566  15.523  51.711  1.00 52.02           C  
ATOM   1126  CG2 VAL A 216       1.048  14.814  49.400  1.00 50.42           C  
ATOM   1127  N   GLU A 217       3.103  12.370  52.661  1.00 54.07           N  
ATOM   1128  CA  GLU A 217       3.585  12.061  54.000  1.00 56.01           C  
ATOM   1129  C   GLU A 217       4.995  11.483  53.981  1.00 55.58           C  
ATOM   1130  O   GLU A 217       5.687  11.475  55.001  1.00 56.52           O  
ATOM   1131  CB  GLU A 217       2.627  11.095  54.708  1.00 58.46           C  
ATOM   1132  CG  GLU A 217       2.766   9.630  54.322  1.00 63.91           C  
ATOM   1133  CD  GLU A 217       1.888   8.725  55.178  1.00 66.53           C  
ATOM   1134  OE1 GLU A 217       2.032   8.771  56.424  1.00 67.46           O  
ATOM   1135  OE2 GLU A 217       1.058   7.971  54.608  1.00 67.53           O  
ATOM   1136  N   GLU A 218       5.423  11.010  52.817  1.00 54.32           N  
ATOM   1137  CA  GLU A 218       6.756  10.444  52.678  1.00 53.34           C  
ATOM   1138  C   GLU A 218       7.786  11.541  52.407  1.00 51.30           C  
ATOM   1139  O   GLU A 218       8.989  11.329  52.566  1.00 52.39           O  
ATOM   1140  CB  GLU A 218       6.782   9.417  51.542  1.00 55.83           C  
ATOM   1141  CG  GLU A 218       8.158   8.814  51.326  1.00 58.65           C  
ATOM   1142  CD  GLU A 218       8.236   7.879  50.138  1.00 59.78           C  
ATOM   1143  OE1 GLU A 218       9.347   7.374  49.875  1.00 60.54           O  
ATOM   1144  OE2 GLU A 218       7.204   7.645  49.468  1.00 62.62           O  
ATOM   1145  N   GLY A 219       7.304  12.710  51.998  1.00 48.18           N  
ATOM   1146  CA  GLY A 219       8.195  13.820  51.722  1.00 46.36           C  
ATOM   1147  C   GLY A 219       8.220  14.246  50.265  1.00 45.35           C  
ATOM   1148  O   GLY A 219       9.142  14.942  49.840  1.00 45.31           O  
ATOM   1149  N   LEU A 220       7.222  13.830  49.490  1.00 44.55           N  
ATOM   1150  CA  LEU A 220       7.164  14.202  48.076  1.00 43.14           C  
ATOM   1151  C   LEU A 220       7.466  15.687  47.913  1.00 42.62           C  
ATOM   1152  O   LEU A 220       8.334  16.071  47.120  1.00 42.14           O  
ATOM   1153  CB  LEU A 220       5.784  13.901  47.490  1.00 43.98           C  
ATOM   1154  CG  LEU A 220       5.526  14.489  46.099  1.00 43.44           C  
ATOM   1155  CD1 LEU A 220       6.589  14.028  45.132  1.00 43.95           C  
ATOM   1156  CD2 LEU A 220       4.160  14.066  45.629  1.00 44.62           C  
ATOM   1157  N   ILE A 221       6.739  16.509  48.674  1.00 40.86           N  
ATOM   1158  CA  ILE A 221       6.898  17.962  48.666  1.00 38.42           C  
ATOM   1159  C   ILE A 221       8.371  18.397  48.714  1.00 37.56           C  
ATOM   1160  O   ILE A 221       8.828  19.126  47.844  1.00 37.04           O  
ATOM   1161  CB  ILE A 221       6.104  18.631  49.864  1.00 38.45           C  
ATOM   1162  CG1 ILE A 221       5.971  17.664  51.056  1.00 38.46           C  
ATOM   1163  CG2 ILE A 221       4.714  19.065  49.408  1.00 37.20           C  
ATOM   1164  CD1 ILE A 221       7.233  17.499  51.928  1.00 35.37           C  
ATOM   1165  N   ASP A 222       9.112  17.928  49.713  1.00 38.88           N  
ATOM   1166  CA  ASP A 222      10.525  18.282  49.870  1.00 39.72           C  
ATOM   1167  C   ASP A 222      11.370  17.760  48.697  1.00 39.58           C  
ATOM   1168  O   ASP A 222      12.347  18.395  48.310  1.00 38.91           O  
ATOM   1169  CB  ASP A 222      11.043  17.721  51.204  1.00 43.13           C  
ATOM   1170  CG  ASP A 222      12.180  18.555  51.821  1.00 47.00           C  
ATOM   1171  OD1 ASP A 222      12.469  18.346  53.022  1.00 50.82           O  
ATOM   1172  OD2 ASP A 222      12.789  19.402  51.131  1.00 46.66           O  
ATOM   1173  N   GLU A 223      11.001  16.611  48.133  1.00 39.57           N  
ATOM   1174  CA  GLU A 223      11.752  16.066  47.000  1.00 38.28           C  
ATOM   1175  C   GLU A 223      11.653  17.013  45.812  1.00 38.43           C  
ATOM   1176  O   GLU A 223      12.649  17.294  45.127  1.00 40.52           O  
ATOM   1177  CB  GLU A 223      11.203  14.709  46.589  1.00 36.07           C  
ATOM   1178  CG  GLU A 223      11.912  14.124  45.396  1.00 36.52           C  
ATOM   1179  CD  GLU A 223      11.350  12.785  45.008  1.00 36.47           C  
ATOM   1180  OE1 GLU A 223      10.224  12.745  44.469  1.00 38.45           O  
ATOM   1181  OE2 GLU A 223      12.025  11.768  45.270  1.00 34.92           O  
ATOM   1182  N   ALA A 224      10.442  17.507  45.582  1.00 37.24           N  
ATOM   1183  CA  ALA A 224      10.179  18.440  44.492  1.00 39.05           C  
ATOM   1184  C   ALA A 224      10.952  19.728  44.726  1.00 41.01           C  
ATOM   1185  O   ALA A 224      11.731  20.165  43.870  1.00 40.23           O  
ATOM   1186  CB  ALA A 224       8.680  18.745  44.412  1.00 38.26           C  
ATOM   1187  N   LYS A 225      10.720  20.340  45.887  1.00 41.29           N  
ATOM   1188  CA  LYS A 225      11.402  21.579  46.230  1.00 43.38           C  
ATOM   1189  C   LYS A 225      12.908  21.430  45.983  1.00 43.57           C  
ATOM   1190  O   LYS A 225      13.509  22.260  45.306  1.00 42.83           O  
ATOM   1191  CB  LYS A 225      11.132  21.951  47.694  1.00 45.34           C  
ATOM   1192  CG  LYS A 225      11.606  23.342  48.075  1.00 45.61           C  
ATOM   1193  CD  LYS A 225      11.493  23.583  49.578  1.00 47.58           C  
ATOM   1194  CE  LYS A 225      12.105  24.929  49.957  1.00 48.29           C  
ATOM   1195  NZ  LYS A 225      13.474  25.101  49.381  1.00 44.50           N  
ATOM   1196  N   LYS A 226      13.525  20.375  46.510  1.00 44.21           N  
ATOM   1197  CA  LYS A 226      14.959  20.190  46.288  1.00 44.57           C  
ATOM   1198  C   LYS A 226      15.296  20.189  44.795  1.00 44.08           C  
ATOM   1199  O   LYS A 226      16.219  20.877  44.377  1.00 45.72           O  
ATOM   1200  CB  LYS A 226      15.459  18.896  46.949  1.00 44.62           C  
ATOM   1201  CG  LYS A 226      15.753  19.044  48.449  1.00 48.77           C  
ATOM   1202  CD  LYS A 226      16.434  17.815  49.061  1.00 49.63           C  
ATOM   1203  CE  LYS A 226      15.444  16.693  49.379  1.00 50.09           C  
ATOM   1204  NZ  LYS A 226      14.527  17.027  50.515  1.00 49.47           N  
ATOM   1205  N   LEU A 227      14.547  19.429  43.995  1.00 43.84           N  
ATOM   1206  CA  LEU A 227      14.785  19.367  42.554  1.00 43.39           C  
ATOM   1207  C   LEU A 227      14.529  20.728  41.936  1.00 43.78           C  
ATOM   1208  O   LEU A 227      15.146  21.103  40.940  1.00 45.02           O  
ATOM   1209  CB  LEU A 227      13.858  18.346  41.885  1.00 42.30           C  
ATOM   1210  CG  LEU A 227      14.032  16.856  42.217  1.00 42.26           C  
ATOM   1211  CD1 LEU A 227      12.884  16.041  41.624  1.00 42.47           C  
ATOM   1212  CD2 LEU A 227      15.357  16.376  41.679  1.00 41.32           C  
ATOM   1213  N   TYR A 228      13.606  21.464  42.538  1.00 44.01           N  
ATOM   1214  CA  TYR A 228      13.236  22.782  42.051  1.00 43.59           C  
ATOM   1215  C   TYR A 228      14.365  23.767  42.273  1.00 44.86           C  
ATOM   1216  O   TYR A 228      14.699  24.571  41.394  1.00 43.89           O  
ATOM   1217  CB  TYR A 228      12.002  23.256  42.797  1.00 44.27           C  
ATOM   1218  CG  TYR A 228      11.440  24.554  42.303  1.00 45.36           C  
ATOM   1219  CD1 TYR A 228      10.681  24.606  41.136  1.00 46.33           C  
ATOM   1220  CD2 TYR A 228      11.625  25.726  43.026  1.00 45.56           C  
ATOM   1221  CE1 TYR A 228      10.115  25.796  40.710  1.00 46.04           C  
ATOM   1222  CE2 TYR A 228      11.063  26.917  42.612  1.00 44.96           C  
ATOM   1223  CZ  TYR A 228      10.308  26.949  41.461  1.00 46.02           C  
ATOM   1224  OH  TYR A 228       9.729  28.135  41.074  1.00 46.75           O  
ATOM   1225  N   ASP A 229      14.946  23.706  43.464  1.00 44.67           N  
ATOM   1226  CA  ASP A 229      16.040  24.593  43.814  1.00 45.60           C  
ATOM   1227  C   ASP A 229      17.322  24.240  43.071  1.00 45.76           C  
ATOM   1228  O   ASP A 229      18.155  25.112  42.815  1.00 46.23           O  
ATOM   1229  CB  ASP A 229      16.264  24.572  45.323  1.00 45.62           C  
ATOM   1230  CG  ASP A 229      15.088  25.151  46.084  1.00 47.00           C  
ATOM   1231  OD1 ASP A 229      14.478  26.124  45.586  1.00 50.00           O  
ATOM   1232  OD2 ASP A 229      14.774  24.648  47.180  1.00 48.33           O  
ATOM   1233  N   ARG A 230      17.465  22.963  42.717  1.00 44.65           N  
ATOM   1234  CA  ARG A 230      18.636  22.485  41.988  1.00 43.83           C  
ATOM   1235  C   ARG A 230      18.709  23.116  40.600  1.00 42.96           C  
ATOM   1236  O   ARG A 230      19.772  23.162  39.984  1.00 45.03           O  
ATOM   1237  CB  ARG A 230      18.593  20.951  41.851  1.00 45.12           C  
ATOM   1238  CG  ARG A 230      19.032  20.177  43.106  1.00 46.08           C  
ATOM   1239  CD  ARG A 230      18.951  18.665  42.921  1.00 46.90           C  
ATOM   1240  NE  ARG A 230      19.307  18.253  41.563  1.00 50.32           N  
ATOM   1241  CZ  ARG A 230      19.396  16.991  41.152  1.00 51.06           C  
ATOM   1242  NH1 ARG A 230      19.716  16.731  39.894  1.00 52.89           N  
ATOM   1243  NH2 ARG A 230      19.180  15.987  41.993  1.00 51.85           N  
ATOM   1244  N   GLY A 231      17.578  23.606  40.105  1.00 43.26           N  
ATOM   1245  CA  GLY A 231      17.564  24.204  38.784  1.00 41.77           C  
ATOM   1246  C   GLY A 231      17.087  23.217  37.728  1.00 41.10           C  
ATOM   1247  O   GLY A 231      17.269  23.448  36.531  1.00 40.22           O  
ATOM   1248  N   ILE A 232      16.476  22.121  38.176  1.00 39.91           N  
ATOM   1249  CA  ILE A 232      15.945  21.082  37.284  1.00 38.58           C  
ATOM   1250  C   ILE A 232      14.575  21.515  36.791  1.00 39.10           C  
ATOM   1251  O   ILE A 232      13.626  21.590  37.571  1.00 41.55           O  
ATOM   1252  CB  ILE A 232      15.766  19.718  38.016  1.00 36.83           C  
ATOM   1253  CG1 ILE A 232      17.109  19.212  38.530  1.00 35.59           C  
ATOM   1254  CG2 ILE A 232      15.175  18.672  37.071  1.00 36.64           C  
ATOM   1255  CD1 ILE A 232      18.094  18.909  37.441  1.00 33.82           C  
ATOM   1256  N   ARG A 233      14.466  21.800  35.503  1.00 39.26           N  
ATOM   1257  CA  ARG A 233      13.194  22.216  34.941  1.00 40.84           C  
ATOM   1258  C   ARG A 233      13.232  22.190  33.432  1.00 42.48           C  
ATOM   1259  O   ARG A 233      14.294  22.024  32.828  1.00 41.52           O  
ATOM   1260  CB  ARG A 233      12.815  23.625  35.416  1.00 44.53           C  
ATOM   1261  CG  ARG A 233      13.863  24.716  35.156  1.00 46.07           C  
ATOM   1262  CD  ARG A 233      13.246  26.128  35.282  1.00 50.63           C  
ATOM   1263  NE  ARG A 233      14.230  27.210  35.245  1.00 51.57           N  
ATOM   1264  CZ  ARG A 233      14.903  27.652  36.305  1.00 55.27           C  
ATOM   1265  NH1 ARG A 233      15.783  28.640  36.173  1.00 56.34           N  
ATOM   1266  NH2 ARG A 233      14.688  27.121  37.500  1.00 55.62           N  
ATOM   1267  N   ASP A 234      12.058  22.343  32.825  1.00 43.85           N  
ATOM   1268  CA  ASP A 234      11.939  22.346  31.375  1.00 46.42           C  
ATOM   1269  C   ASP A 234      12.460  21.033  30.786  1.00 46.23           C  
ATOM   1270  O   ASP A 234      13.162  21.028  29.774  1.00 46.78           O  
ATOM   1271  CB  ASP A 234      12.725  23.530  30.800  1.00 48.64           C  
ATOM   1272  CG  ASP A 234      12.102  24.879  31.144  1.00 51.33           C  
ATOM   1273  OD1 ASP A 234      12.793  25.905  30.982  1.00 54.28           O  
ATOM   1274  OD2 ASP A 234      10.922  24.928  31.560  1.00 52.54           O  
ATOM   1275  N   CYS A 235      12.112  19.924  31.431  1.00 45.75           N  
ATOM   1276  CA  CYS A 235      12.533  18.597  30.991  1.00 46.11           C  
ATOM   1277  C   CYS A 235      11.504  17.573  31.453  1.00 46.24           C  
ATOM   1278  O   CYS A 235      11.058  17.620  32.596  1.00 47.70           O  
ATOM   1279  CB  CYS A 235      13.901  18.266  31.583  1.00 45.56           C  
ATOM   1280  SG  CYS A 235      14.023  18.615  33.359  1.00 45.05           S  
ATOM   1281  N   GLN A 236      11.138  16.642  30.580  1.00 46.82           N  
ATOM   1282  CA  GLN A 236      10.131  15.655  30.936  1.00 45.78           C  
ATOM   1283  C   GLN A 236      10.106  15.226  32.391  1.00 44.72           C  
ATOM   1284  O   GLN A 236       9.050  15.244  33.010  1.00 45.12           O  
ATOM   1285  CB  GLN A 236      10.234  14.419  30.049  1.00 46.03           C  
ATOM   1286  CG  GLN A 236      11.554  13.730  30.012  1.00 48.00           C  
ATOM   1287  CD  GLN A 236      11.455  12.385  29.302  1.00 50.19           C  
ATOM   1288  OE1 GLN A 236      11.023  11.394  29.889  1.00 50.87           O  
ATOM   1289  NE2 GLN A 236      11.832  12.352  28.026  1.00 49.31           N  
ATOM   1290  N   SER A 237      11.258  14.865  32.945  1.00 43.97           N  
ATOM   1291  CA  SER A 237      11.311  14.423  34.329  1.00 42.16           C  
ATOM   1292  C   SER A 237      10.473  15.293  35.263  1.00 44.13           C  
ATOM   1293  O   SER A 237       9.742  14.785  36.113  1.00 43.70           O  
ATOM   1294  CB  SER A 237      12.742  14.431  34.835  1.00 43.81           C  
ATOM   1295  OG  SER A 237      13.080  15.728  35.290  1.00 39.94           O  
ATOM   1296  N   VAL A 238      10.588  16.608  35.114  1.00 44.50           N  
ATOM   1297  CA  VAL A 238       9.852  17.537  35.959  1.00 45.19           C  
ATOM   1298  C   VAL A 238       8.421  17.765  35.486  1.00 45.79           C  
ATOM   1299  O   VAL A 238       7.525  17.993  36.295  1.00 47.97           O  
ATOM   1300  CB  VAL A 238      10.584  18.902  36.032  1.00 46.78           C  
ATOM   1301  CG1 VAL A 238       9.673  19.944  36.643  1.00 47.61           C  
ATOM   1302  CG2 VAL A 238      11.856  18.776  36.863  1.00 45.76           C  
ATOM   1303  N   GLN A 239       8.208  17.712  34.175  1.00 46.40           N  
ATOM   1304  CA  GLN A 239       6.875  17.921  33.602  1.00 45.70           C  
ATOM   1305  C   GLN A 239       5.991  16.696  33.810  1.00 44.51           C  
ATOM   1306  O   GLN A 239       4.805  16.711  33.485  1.00 43.82           O  
ATOM   1307  CB  GLN A 239       6.984  18.213  32.100  1.00 47.05           C  
ATOM   1308  CG  GLN A 239       7.974  19.320  31.732  1.00 48.28           C  
ATOM   1309  CD  GLN A 239       7.772  19.835  30.315  1.00 50.20           C  
ATOM   1310  OE1 GLN A 239       7.768  19.062  29.355  1.00 52.00           O  
ATOM   1311  NE2 GLN A 239       7.601  21.151  30.178  1.00 51.57           N  
ATOM   1312  N   ALA A 240       6.587  15.640  34.353  1.00 43.54           N  
ATOM   1313  CA  ALA A 240       5.886  14.391  34.602  1.00 43.11           C  
ATOM   1314  C   ALA A 240       4.578  14.618  35.328  1.00 42.64           C  
ATOM   1315  O   ALA A 240       4.467  15.492  36.181  1.00 41.92           O  
ATOM   1316  CB  ALA A 240       6.766  13.449  35.407  1.00 43.73           C  
ATOM   1317  N   ILE A 241       3.597  13.796  34.994  1.00 43.52           N  
ATOM   1318  CA  ILE A 241       2.281  13.891  35.582  1.00 42.85           C  
ATOM   1319  C   ILE A 241       2.295  13.527  37.063  1.00 43.12           C  
ATOM   1320  O   ILE A 241       1.357  12.910  37.573  1.00 45.50           O  
ATOM   1321  CB  ILE A 241       1.303  12.980  34.812  1.00 43.98           C  
ATOM   1322  CG1 ILE A 241      -0.135  13.389  35.117  1.00 42.09           C  
ATOM   1323  CG2 ILE A 241       1.568  11.517  35.155  1.00 43.40           C  
ATOM   1324  CD1 ILE A 241      -1.144  12.685  34.279  1.00 41.21           C  
ATOM   1325  N   GLY A 242       3.370  13.920  37.738  1.00 42.52           N  
ATOM   1326  CA  GLY A 242       3.516  13.662  39.158  1.00 41.62           C  
ATOM   1327  C   GLY A 242       4.293  14.761  39.876  1.00 42.58           C  
ATOM   1328  O   GLY A 242       4.148  14.929  41.088  1.00 43.02           O  
ATOM   1329  N   TYR A 243       5.121  15.501  39.136  1.00 41.51           N  
ATOM   1330  CA  TYR A 243       5.923  16.589  39.695  1.00 40.82           C  
ATOM   1331  C   TYR A 243       5.446  17.970  39.227  1.00 41.63           C  
ATOM   1332  O   TYR A 243       5.637  18.976  39.919  1.00 41.74           O  
ATOM   1333  CB  TYR A 243       7.402  16.419  39.323  1.00 39.97           C  
ATOM   1334  CG  TYR A 243       8.086  15.245  39.998  1.00 42.59           C  
ATOM   1335  CD1 TYR A 243       8.076  13.971  39.426  1.00 42.13           C  
ATOM   1336  CD2 TYR A 243       8.720  15.405  41.232  1.00 43.60           C  
ATOM   1337  CE1 TYR A 243       8.684  12.885  40.075  1.00 42.93           C  
ATOM   1338  CE2 TYR A 243       9.325  14.328  41.886  1.00 42.98           C  
ATOM   1339  CZ  TYR A 243       9.303  13.077  41.306  1.00 43.79           C  
ATOM   1340  OH  TYR A 243       9.888  12.028  41.979  1.00 44.21           O  
ATOM   1341  N   LYS A 244       4.838  18.018  38.047  1.00 41.22           N  
ATOM   1342  CA  LYS A 244       4.337  19.279  37.512  1.00 41.64           C  
ATOM   1343  C   LYS A 244       3.375  19.943  38.518  1.00 43.17           C  
ATOM   1344  O   LYS A 244       3.384  21.164  38.680  1.00 42.56           O  
ATOM   1345  CB  LYS A 244       3.618  19.043  36.175  1.00 41.11           C  
ATOM   1346  CG  LYS A 244       2.361  18.192  36.287  1.00 39.56           C  
ATOM   1347  CD  LYS A 244       1.648  18.054  34.951  1.00 41.01           C  
ATOM   1348  CE  LYS A 244       0.346  17.263  35.094  1.00 39.72           C  
ATOM   1349  NZ  LYS A 244      -0.395  17.137  33.812  1.00 38.90           N  
ATOM   1350  N   GLU A 245       2.557  19.139  39.196  1.00 43.03           N  
ATOM   1351  CA  GLU A 245       1.607  19.670  40.174  1.00 45.23           C  
ATOM   1352  C   GLU A 245       2.327  20.412  41.302  1.00 46.87           C  
ATOM   1353  O   GLU A 245       1.894  21.489  41.730  1.00 47.39           O  
ATOM   1354  CB  GLU A 245       0.757  18.554  40.792  1.00 44.84           C  
ATOM   1355  CG  GLU A 245      -0.101  17.754  39.818  1.00 46.40           C  
ATOM   1356  CD  GLU A 245       0.701  16.786  38.968  1.00 47.00           C  
ATOM   1357  OE1 GLU A 245       1.810  16.387  39.387  1.00 47.35           O  
ATOM   1358  OE2 GLU A 245       0.209  16.412  37.887  1.00 48.23           O  
HETATM 1359  N   MSE A 246       3.414  19.825  41.795  1.00 46.73           N  
HETATM 1360  CA  MSE A 246       4.191  20.442  42.861  1.00 45.85           C  
HETATM 1361  C   MSE A 246       4.864  21.715  42.352  1.00 44.69           C  
HETATM 1362  O   MSE A 246       4.821  22.748  43.014  1.00 44.19           O  
HETATM 1363  CB  MSE A 246       5.252  19.474  43.390  1.00 46.42           C  
HETATM 1364  CG  MSE A 246       4.689  18.271  44.125  1.00 49.59           C  
HETATM 1365 SE   MSE A 246       3.585  18.752  45.648  1.00 57.94          SE  
HETATM 1366  CE  MSE A 246       1.851  18.250  44.977  1.00 52.95           C  
ATOM   1367  N   TYR A 247       5.479  21.653  41.177  1.00 43.69           N  
ATOM   1368  CA  TYR A 247       6.127  22.845  40.645  1.00 44.60           C  
ATOM   1369  C   TYR A 247       5.137  23.980  40.456  1.00 44.49           C  
ATOM   1370  O   TYR A 247       5.508  25.149  40.531  1.00 45.55           O  
ATOM   1371  CB  TYR A 247       6.822  22.558  39.317  1.00 44.74           C  
ATOM   1372  CG  TYR A 247       8.197  21.961  39.482  1.00 44.11           C  
ATOM   1373  CD1 TYR A 247       9.263  22.418  38.715  1.00 44.13           C  
ATOM   1374  CD2 TYR A 247       8.430  20.924  40.382  1.00 43.77           C  
ATOM   1375  CE1 TYR A 247      10.531  21.861  38.836  1.00 45.11           C  
ATOM   1376  CE2 TYR A 247       9.698  20.355  40.506  1.00 44.00           C  
ATOM   1377  CZ  TYR A 247      10.740  20.827  39.726  1.00 42.47           C  
ATOM   1378  OH  TYR A 247      11.982  20.256  39.799  1.00 40.63           O  
ATOM   1379  N   ASP A 248       3.877  23.638  40.214  1.00 42.64           N  
ATOM   1380  CA  ASP A 248       2.860  24.652  40.041  1.00 40.34           C  
ATOM   1381  C   ASP A 248       2.603  25.299  41.395  1.00 40.18           C  
ATOM   1382  O   ASP A 248       2.142  26.434  41.476  1.00 40.09           O  
ATOM   1383  CB  ASP A 248       1.571  24.037  39.525  1.00 39.73           C  
ATOM   1384  CG  ASP A 248       0.701  25.047  38.830  1.00 39.90           C  
ATOM   1385  OD1 ASP A 248      -0.517  24.829  38.753  1.00 42.48           O  
ATOM   1386  OD2 ASP A 248       1.239  26.064  38.342  1.00 42.17           O  
ATOM   1387  N   TYR A 249       2.900  24.556  42.457  1.00 39.73           N  
ATOM   1388  CA  TYR A 249       2.726  25.050  43.812  1.00 39.70           C  
ATOM   1389  C   TYR A 249       3.919  25.921  44.194  1.00 39.93           C  
ATOM   1390  O   TYR A 249       3.750  27.040  44.687  1.00 38.68           O  
ATOM   1391  CB  TYR A 249       2.618  23.890  44.792  1.00 38.98           C  
ATOM   1392  CG  TYR A 249       2.959  24.275  46.215  1.00 39.67           C  
ATOM   1393  CD1 TYR A 249       2.119  25.089  46.965  1.00 37.88           C  
ATOM   1394  CD2 TYR A 249       4.144  23.831  46.806  1.00 40.27           C  
ATOM   1395  CE1 TYR A 249       2.454  25.449  48.275  1.00 39.17           C  
ATOM   1396  CE2 TYR A 249       4.487  24.182  48.107  1.00 38.25           C  
ATOM   1397  CZ  TYR A 249       3.639  24.989  48.835  1.00 38.39           C  
ATOM   1398  OH  TYR A 249       3.969  25.315  50.126  1.00 38.09           O  
ATOM   1399  N   LEU A 250       5.119  25.391  43.967  1.00 39.41           N  
ATOM   1400  CA  LEU A 250       6.346  26.107  44.267  1.00 40.94           C  
ATOM   1401  C   LEU A 250       6.383  27.435  43.512  1.00 41.26           C  
ATOM   1402  O   LEU A 250       6.759  28.456  44.075  1.00 42.76           O  
ATOM   1403  CB  LEU A 250       7.580  25.265  43.905  1.00 41.48           C  
ATOM   1404  CG  LEU A 250       8.047  24.172  44.876  1.00 40.92           C  
ATOM   1405  CD1 LEU A 250       8.352  24.764  46.256  1.00 42.18           C  
ATOM   1406  CD2 LEU A 250       6.989  23.128  44.987  1.00 42.76           C  
ATOM   1407  N   ASP A 251       5.983  27.426  42.247  1.00 40.45           N  
ATOM   1408  CA  ASP A 251       5.968  28.645  41.454  1.00 41.16           C  
ATOM   1409  C   ASP A 251       5.083  29.698  42.106  1.00 42.16           C  
ATOM   1410  O   ASP A 251       5.244  30.888  41.853  1.00 43.10           O  
ATOM   1411  CB  ASP A 251       5.453  28.350  40.042  1.00 41.65           C  
ATOM   1412  CG  ASP A 251       6.551  27.878  39.105  1.00 40.60           C  
ATOM   1413  OD1 ASP A 251       6.259  27.085  38.176  1.00 37.68           O  
ATOM   1414  OD2 ASP A 251       7.706  28.317  39.294  1.00 41.32           O  
ATOM   1415  N   GLY A 252       4.139  29.256  42.931  1.00 42.31           N  
ATOM   1416  CA  GLY A 252       3.254  30.185  43.601  1.00 41.53           C  
ATOM   1417  C   GLY A 252       1.959  30.403  42.851  1.00 42.65           C  
ATOM   1418  O   GLY A 252       1.384  31.483  42.909  1.00 44.25           O  
ATOM   1419  N   ASN A 253       1.481  29.387  42.147  1.00 42.29           N  
ATOM   1420  CA  ASN A 253       0.238  29.533  41.395  1.00 41.36           C  
ATOM   1421  C   ASN A 253      -0.974  28.966  42.124  1.00 40.21           C  
ATOM   1422  O   ASN A 253      -2.096  29.432  41.928  1.00 38.27           O  
ATOM   1423  CB  ASN A 253       0.373  28.864  40.033  1.00 42.84           C  
ATOM   1424  CG  ASN A 253       1.514  29.437  39.235  1.00 45.86           C  
ATOM   1425  OD1 ASN A 253       1.933  28.876  38.226  1.00 47.62           O  
ATOM   1426  ND2 ASN A 253       2.032  30.572  39.692  1.00 47.98           N  
ATOM   1427  N   VAL A 254      -0.745  27.967  42.968  1.00 38.15           N  
ATOM   1428  CA  VAL A 254      -1.833  27.340  43.709  1.00 36.45           C  
ATOM   1429  C   VAL A 254      -1.376  27.030  45.120  1.00 35.60           C  
ATOM   1430  O   VAL A 254      -0.178  27.048  45.393  1.00 32.29           O  
ATOM   1431  CB  VAL A 254      -2.254  26.023  43.036  1.00 37.25           C  
ATOM   1432  CG1 VAL A 254      -2.789  26.297  41.625  1.00 37.80           C  
ATOM   1433  CG2 VAL A 254      -1.052  25.084  42.959  1.00 36.21           C  
ATOM   1434  N   THR A 255      -2.323  26.754  46.015  1.00 37.36           N  
ATOM   1435  CA  THR A 255      -1.970  26.405  47.390  1.00 39.91           C  
ATOM   1436  C   THR A 255      -1.580  24.922  47.419  1.00 40.95           C  
ATOM   1437  O   THR A 255      -1.917  24.165  46.504  1.00 40.21           O  
ATOM   1438  CB  THR A 255      -3.144  26.629  48.387  1.00 41.77           C  
ATOM   1439  OG1 THR A 255      -4.201  25.702  48.108  1.00 43.74           O  
ATOM   1440  CG2 THR A 255      -3.682  28.056  48.285  1.00 40.76           C  
ATOM   1441  N   LEU A 256      -0.877  24.514  48.471  1.00 41.51           N  
ATOM   1442  CA  LEU A 256      -0.429  23.130  48.609  1.00 43.39           C  
ATOM   1443  C   LEU A 256      -1.551  22.110  48.436  1.00 44.47           C  
ATOM   1444  O   LEU A 256      -1.425  21.180  47.650  1.00 42.41           O  
ATOM   1445  CB  LEU A 256       0.237  22.921  49.972  1.00 42.29           C  
ATOM   1446  CG  LEU A 256       0.808  21.524  50.249  1.00 43.53           C  
ATOM   1447  CD1 LEU A 256       1.863  21.164  49.215  1.00 41.85           C  
ATOM   1448  CD2 LEU A 256       1.418  21.500  51.648  1.00 43.42           C  
ATOM   1449  N   GLU A 257      -2.646  22.288  49.171  1.00 46.71           N  
ATOM   1450  CA  GLU A 257      -3.754  21.359  49.078  1.00 49.20           C  
ATOM   1451  C   GLU A 257      -4.347  21.326  47.671  1.00 50.92           C  
ATOM   1452  O   GLU A 257      -4.746  20.265  47.193  1.00 52.33           O  
ATOM   1453  CB  GLU A 257      -4.838  21.711  50.087  1.00 51.55           C  
ATOM   1454  CG  GLU A 257      -5.560  23.002  49.791  1.00 55.92           C  
ATOM   1455  CD  GLU A 257      -6.937  23.033  50.419  1.00 58.47           C  
ATOM   1456  OE1 GLU A 257      -7.811  22.252  49.969  1.00 57.12           O  
ATOM   1457  OE2 GLU A 257      -7.141  23.829  51.369  1.00 60.30           O  
ATOM   1458  N   GLU A 258      -4.412  22.477  47.006  1.00 51.21           N  
ATOM   1459  CA  GLU A 258      -4.940  22.523  45.643  1.00 51.63           C  
ATOM   1460  C   GLU A 258      -4.032  21.720  44.720  1.00 50.36           C  
ATOM   1461  O   GLU A 258      -4.503  21.014  43.822  1.00 50.70           O  
ATOM   1462  CB  GLU A 258      -5.043  23.976  45.140  1.00 52.91           C  
ATOM   1463  CG  GLU A 258      -6.124  24.788  45.846  1.00 56.39           C  
ATOM   1464  CD  GLU A 258      -6.023  26.292  45.609  1.00 59.31           C  
ATOM   1465  OE1 GLU A 258      -6.829  27.030  46.220  1.00 61.17           O  
ATOM   1466  OE2 GLU A 258      -5.151  26.742  44.827  1.00 60.36           O  
ATOM   1467  N   ALA A 259      -2.727  21.818  44.944  1.00 48.53           N  
ATOM   1468  CA  ALA A 259      -1.778  21.078  44.118  1.00 46.67           C  
ATOM   1469  C   ALA A 259      -2.037  19.590  44.321  1.00 45.83           C  
ATOM   1470  O   ALA A 259      -2.290  18.856  43.362  1.00 44.16           O  
ATOM   1471  CB  ALA A 259      -0.357  21.423  44.519  1.00 44.18           C  
ATOM   1472  N   ILE A 260      -1.975  19.169  45.580  1.00 43.60           N  
ATOM   1473  CA  ILE A 260      -2.200  17.789  45.955  1.00 44.37           C  
ATOM   1474  C   ILE A 260      -3.479  17.218  45.352  1.00 45.59           C  
ATOM   1475  O   ILE A 260      -3.484  16.120  44.795  1.00 45.73           O  
ATOM   1476  CB  ILE A 260      -2.272  17.655  47.471  1.00 43.08           C  
ATOM   1477  CG1 ILE A 260      -0.901  17.938  48.073  1.00 42.56           C  
ATOM   1478  CG2 ILE A 260      -2.755  16.268  47.847  1.00 43.22           C  
ATOM   1479  CD1 ILE A 260      -0.872  17.851  49.586  1.00 41.50           C  
ATOM   1480  N   ASP A 261      -4.566  17.965  45.465  1.00 47.62           N  
ATOM   1481  CA  ASP A 261      -5.839  17.520  44.929  1.00 48.53           C  
ATOM   1482  C   ASP A 261      -5.717  17.364  43.417  1.00 48.04           C  
ATOM   1483  O   ASP A 261      -6.092  16.333  42.854  1.00 49.11           O  
ATOM   1484  CB  ASP A 261      -6.935  18.531  45.275  1.00 49.32           C  
ATOM   1485  CG  ASP A 261      -8.317  18.045  44.897  1.00 52.80           C  
ATOM   1486  OD1 ASP A 261      -8.577  17.863  43.687  1.00 56.17           O  
ATOM   1487  OD2 ASP A 261      -9.155  17.844  45.806  1.00 54.53           O  
ATOM   1488  N   THR A 262      -5.175  18.383  42.762  1.00 46.14           N  
ATOM   1489  CA  THR A 262      -5.013  18.342  41.317  1.00 43.62           C  
ATOM   1490  C   THR A 262      -4.115  17.180  40.927  1.00 42.73           C  
ATOM   1491  O   THR A 262      -4.229  16.615  39.838  1.00 41.83           O  
ATOM   1492  CB  THR A 262      -4.397  19.644  40.806  1.00 44.66           C  
ATOM   1493  OG1 THR A 262      -5.239  20.736  41.190  1.00 43.14           O  
ATOM   1494  CG2 THR A 262      -4.254  19.611  39.286  1.00 41.78           C  
ATOM   1495  N   LEU A 263      -3.207  16.833  41.823  1.00 39.41           N  
ATOM   1496  CA  LEU A 263      -2.326  15.721  41.555  1.00 36.57           C  
ATOM   1497  C   LEU A 263      -3.155  14.439  41.563  1.00 35.07           C  
ATOM   1498  O   LEU A 263      -2.961  13.567  40.733  1.00 33.54           O  
ATOM   1499  CB  LEU A 263      -1.244  15.642  42.614  1.00 33.97           C  
ATOM   1500  CG  LEU A 263      -0.415  14.371  42.544  1.00 34.92           C  
ATOM   1501  CD1 LEU A 263       0.094  14.118  41.131  1.00 34.43           C  
ATOM   1502  CD2 LEU A 263       0.727  14.529  43.513  1.00 35.72           C  
ATOM   1503  N   LYS A 264      -4.089  14.333  42.495  1.00 33.97           N  
ATOM   1504  CA  LYS A 264      -4.908  13.150  42.553  1.00 36.21           C  
ATOM   1505  C   LYS A 264      -5.849  13.135  41.363  1.00 39.51           C  
ATOM   1506  O   LYS A 264      -6.120  12.086  40.777  1.00 40.31           O  
ATOM   1507  CB  LYS A 264      -5.718  13.110  43.842  1.00 33.75           C  
ATOM   1508  CG  LYS A 264      -4.885  13.082  45.111  1.00 31.71           C  
ATOM   1509  CD  LYS A 264      -5.775  13.145  46.340  1.00 27.28           C  
ATOM   1510  CE  LYS A 264      -4.964  13.060  47.618  1.00 29.38           C  
ATOM   1511  NZ  LYS A 264      -5.840  13.124  48.827  1.00 25.93           N  
ATOM   1512  N   ARG A 265      -6.345  14.305  40.988  1.00 41.42           N  
ATOM   1513  CA  ARG A 265      -7.276  14.399  39.868  1.00 43.87           C  
ATOM   1514  C   ARG A 265      -6.590  14.037  38.557  1.00 42.77           C  
ATOM   1515  O   ARG A 265      -7.164  13.335  37.739  1.00 43.04           O  
ATOM   1516  CB  ARG A 265      -7.876  15.819  39.810  1.00 47.17           C  
ATOM   1517  CG  ARG A 265      -8.773  16.121  38.601  1.00 50.67           C  
ATOM   1518  CD  ARG A 265      -9.373  17.548  38.693  1.00 54.42           C  
ATOM   1519  NE  ARG A 265      -9.924  17.994  37.414  1.00 56.17           N  
ATOM   1520  CZ  ARG A 265     -11.020  17.480  36.859  1.00 58.00           C  
ATOM   1521  NH1 ARG A 265     -11.687  16.509  37.480  1.00 58.70           N  
ATOM   1522  NH2 ARG A 265     -11.429  17.915  35.673  1.00 56.59           N  
ATOM   1523  N   ASN A 266      -5.359  14.504  38.362  1.00 43.52           N  
ATOM   1524  CA  ASN A 266      -4.627  14.203  37.136  1.00 41.85           C  
ATOM   1525  C   ASN A 266      -4.192  12.761  37.091  1.00 40.31           C  
ATOM   1526  O   ASN A 266      -3.939  12.219  36.021  1.00 40.49           O  
ATOM   1527  CB  ASN A 266      -3.407  15.103  36.996  1.00 42.98           C  
ATOM   1528  CG  ASN A 266      -3.792  16.547  36.786  1.00 43.69           C  
ATOM   1529  OD1 ASN A 266      -4.908  16.833  36.350  1.00 43.11           O  
ATOM   1530  ND2 ASN A 266      -2.876  17.466  37.086  1.00 42.64           N  
ATOM   1531  N   SER A 267      -4.093  12.142  38.258  1.00 39.36           N  
ATOM   1532  CA  SER A 267      -3.710  10.745  38.320  1.00 38.37           C  
ATOM   1533  C   SER A 267      -4.904   9.871  37.978  1.00 38.87           C  
ATOM   1534  O   SER A 267      -4.780   8.910  37.220  1.00 39.96           O  
ATOM   1535  CB  SER A 267      -3.193  10.399  39.706  1.00 35.77           C  
ATOM   1536  OG  SER A 267      -1.928  10.980  39.902  1.00 36.39           O  
ATOM   1537  N   ARG A 268      -6.061  10.203  38.536  1.00 39.15           N  
ATOM   1538  CA  ARG A 268      -7.258   9.424  38.258  1.00 40.63           C  
ATOM   1539  C   ARG A 268      -7.624   9.519  36.789  1.00 43.14           C  
ATOM   1540  O   ARG A 268      -8.104   8.550  36.205  1.00 45.45           O  
ATOM   1541  CB  ARG A 268      -8.443   9.899  39.105  1.00 37.07           C  
ATOM   1542  CG  ARG A 268      -8.294   9.619  40.594  1.00 36.84           C  
ATOM   1543  CD  ARG A 268      -9.591   9.874  41.333  1.00 34.63           C  
ATOM   1544  NE  ARG A 268     -10.084  11.235  41.122  1.00 37.47           N  
ATOM   1545  CZ  ARG A 268      -9.700  12.300  41.821  1.00 36.69           C  
ATOM   1546  NH1 ARG A 268      -8.810  12.178  42.795  1.00 35.96           N  
ATOM   1547  NH2 ARG A 268     -10.213  13.493  41.540  1.00 38.81           N  
ATOM   1548  N   ARG A 269      -7.401  10.681  36.183  1.00 43.44           N  
ATOM   1549  CA  ARG A 269      -7.742  10.825  34.779  1.00 44.44           C  
ATOM   1550  C   ARG A 269      -6.768  10.028  33.934  1.00 43.89           C  
ATOM   1551  O   ARG A 269      -7.157   9.397  32.953  1.00 45.27           O  
ATOM   1552  CB  ARG A 269      -7.739  12.301  34.364  1.00 44.57           C  
ATOM   1553  CG  ARG A 269      -8.791  13.126  35.103  1.00 46.96           C  
ATOM   1554  CD  ARG A 269      -8.665  14.625  34.826  1.00 49.30           C  
ATOM   1555  NE  ARG A 269      -9.074  14.992  33.477  1.00 51.38           N  
ATOM   1556  CZ  ARG A 269     -10.326  14.941  33.025  1.00 51.65           C  
ATOM   1557  NH1 ARG A 269     -10.596  15.299  31.775  1.00 51.88           N  
ATOM   1558  NH2 ARG A 269     -11.312  14.540  33.817  1.00 51.90           N  
ATOM   1559  N   TYR A 270      -5.502  10.025  34.324  1.00 42.03           N  
ATOM   1560  CA  TYR A 270      -4.524   9.294  33.548  1.00 41.56           C  
ATOM   1561  C   TYR A 270      -4.808   7.800  33.596  1.00 43.43           C  
ATOM   1562  O   TYR A 270      -4.902   7.147  32.558  1.00 45.31           O  
ATOM   1563  CB  TYR A 270      -3.125   9.580  34.061  1.00 40.62           C  
ATOM   1564  CG  TYR A 270      -2.039   8.931  33.244  1.00 39.53           C  
ATOM   1565  CD1 TYR A 270      -1.276   7.900  33.770  1.00 38.67           C  
ATOM   1566  CD2 TYR A 270      -1.740   9.384  31.961  1.00 40.34           C  
ATOM   1567  CE1 TYR A 270      -0.231   7.337  33.049  1.00 38.61           C  
ATOM   1568  CE2 TYR A 270      -0.695   8.828  31.225  1.00 41.08           C  
ATOM   1569  CZ  TYR A 270       0.058   7.806  31.781  1.00 39.92           C  
ATOM   1570  OH  TYR A 270       1.122   7.277  31.088  1.00 41.44           O  
ATOM   1571  N   ALA A 271      -4.953   7.259  34.799  1.00 43.28           N  
ATOM   1572  CA  ALA A 271      -5.230   5.839  34.941  1.00 42.87           C  
ATOM   1573  C   ALA A 271      -6.333   5.478  33.957  1.00 43.66           C  
ATOM   1574  O   ALA A 271      -6.208   4.529  33.183  1.00 44.18           O  
ATOM   1575  CB  ALA A 271      -5.664   5.532  36.366  1.00 41.68           C  
ATOM   1576  N   LYS A 272      -7.402   6.264  33.974  1.00 44.71           N  
ATOM   1577  CA  LYS A 272      -8.529   6.040  33.085  1.00 46.39           C  
ATOM   1578  C   LYS A 272      -8.093   5.982  31.622  1.00 47.57           C  
ATOM   1579  O   LYS A 272      -8.345   4.994  30.926  1.00 48.19           O  
ATOM   1580  CB  LYS A 272      -9.557   7.148  33.281  1.00 46.51           C  
ATOM   1581  CG  LYS A 272     -10.690   7.116  32.295  1.00 47.94           C  
ATOM   1582  CD  LYS A 272     -11.701   8.196  32.618  1.00 47.23           C  
ATOM   1583  CE  LYS A 272     -12.841   8.170  31.628  1.00 48.22           C  
ATOM   1584  NZ  LYS A 272     -13.878   9.158  31.991  1.00 47.52           N  
ATOM   1585  N   ARG A 273      -7.428   7.039  31.163  1.00 48.35           N  
ATOM   1586  CA  ARG A 273      -6.956   7.109  29.781  1.00 48.48           C  
ATOM   1587  C   ARG A 273      -6.157   5.870  29.373  1.00 47.50           C  
ATOM   1588  O   ARG A 273      -6.310   5.357  28.261  1.00 46.63           O  
ATOM   1589  CB  ARG A 273      -6.086   8.355  29.577  1.00 49.64           C  
ATOM   1590  CG  ARG A 273      -6.848   9.672  29.564  1.00 51.94           C  
ATOM   1591  CD  ARG A 273      -5.889  10.852  29.391  1.00 54.34           C  
ATOM   1592  NE  ARG A 273      -5.386  11.376  30.663  1.00 53.65           N  
ATOM   1593  CZ  ARG A 273      -4.138  11.791  30.867  1.00 54.27           C  
ATOM   1594  NH1 ARG A 273      -3.779  12.260  32.060  1.00 53.72           N  
ATOM   1595  NH2 ARG A 273      -3.240  11.717  29.889  1.00 53.56           N  
ATOM   1596  N   GLN A 274      -5.301   5.391  30.265  1.00 46.33           N  
ATOM   1597  CA  GLN A 274      -4.500   4.216  29.951  1.00 46.95           C  
ATOM   1598  C   GLN A 274      -5.346   2.948  29.940  1.00 46.11           C  
ATOM   1599  O   GLN A 274      -5.169   2.092  29.079  1.00 45.24           O  
ATOM   1600  CB  GLN A 274      -3.339   4.073  30.941  1.00 47.13           C  
ATOM   1601  CG  GLN A 274      -2.081   4.858  30.563  1.00 49.11           C  
ATOM   1602  CD  GLN A 274      -1.318   4.239  29.381  1.00 50.22           C  
ATOM   1603  OE1 GLN A 274      -1.285   4.788  28.253  1.00 47.06           O  
ATOM   1604  NE2 GLN A 274      -0.702   3.085  29.634  1.00 51.28           N  
ATOM   1605  N   LEU A 275      -6.269   2.829  30.887  1.00 47.02           N  
ATOM   1606  CA  LEU A 275      -7.133   1.653  30.958  1.00 48.46           C  
ATOM   1607  C   LEU A 275      -7.993   1.519  29.692  1.00 48.56           C  
ATOM   1608  O   LEU A 275      -8.266   0.412  29.233  1.00 47.49           O  
ATOM   1609  CB  LEU A 275      -8.037   1.746  32.190  1.00 49.68           C  
ATOM   1610  CG  LEU A 275      -8.295   0.470  32.991  1.00 49.33           C  
ATOM   1611  CD1 LEU A 275      -9.229   0.803  34.149  1.00 49.71           C  
ATOM   1612  CD2 LEU A 275      -8.900  -0.600  32.102  1.00 50.14           C  
ATOM   1613  N   THR A 276      -8.415   2.643  29.123  1.00 49.53           N  
ATOM   1614  CA  THR A 276      -9.232   2.605  27.917  1.00 48.44           C  
ATOM   1615  C   THR A 276      -8.368   2.319  26.699  1.00 48.39           C  
ATOM   1616  O   THR A 276      -8.789   1.624  25.777  1.00 48.49           O  
ATOM   1617  CB  THR A 276      -9.965   3.935  27.695  1.00 47.54           C  
ATOM   1618  OG1 THR A 276     -10.694   4.279  28.876  1.00 47.93           O  
ATOM   1619  CG2 THR A 276     -10.936   3.814  26.538  1.00 48.36           C  
ATOM   1620  N   TRP A 277      -7.154   2.852  26.707  1.00 48.70           N  
ATOM   1621  CA  TRP A 277      -6.225   2.657  25.601  1.00 50.72           C  
ATOM   1622  C   TRP A 277      -5.940   1.172  25.436  1.00 51.27           C  
ATOM   1623  O   TRP A 277      -6.116   0.613  24.354  1.00 52.77           O  
ATOM   1624  CB  TRP A 277      -4.916   3.392  25.870  1.00 51.92           C  
ATOM   1625  CG  TRP A 277      -4.064   3.561  24.661  1.00 53.22           C  
ATOM   1626  CD1 TRP A 277      -3.946   4.688  23.891  1.00 54.99           C  
ATOM   1627  CD2 TRP A 277      -3.205   2.581  24.072  1.00 53.63           C  
ATOM   1628  NE1 TRP A 277      -3.065   4.469  22.862  1.00 54.44           N  
ATOM   1629  CE2 TRP A 277      -2.595   3.185  22.949  1.00 54.95           C  
ATOM   1630  CE3 TRP A 277      -2.891   1.253  24.382  1.00 53.36           C  
ATOM   1631  CZ2 TRP A 277      -1.683   2.502  22.134  1.00 54.72           C  
ATOM   1632  CZ3 TRP A 277      -1.986   0.573  23.573  1.00 54.15           C  
ATOM   1633  CH2 TRP A 277      -1.392   1.200  22.460  1.00 55.10           C  
ATOM   1634  N   PHE A 278      -5.499   0.528  26.507  1.00 48.89           N  
ATOM   1635  CA  PHE A 278      -5.205  -0.888  26.426  1.00 49.40           C  
ATOM   1636  C   PHE A 278      -6.464  -1.738  26.266  1.00 49.95           C  
ATOM   1637  O   PHE A 278      -6.401  -2.822  25.702  1.00 49.68           O  
ATOM   1638  CB  PHE A 278      -4.406  -1.337  27.647  1.00 47.46           C  
ATOM   1639  CG  PHE A 278      -2.976  -0.915  27.614  1.00 43.42           C  
ATOM   1640  CD1 PHE A 278      -2.459  -0.110  28.611  1.00 43.02           C  
ATOM   1641  CD2 PHE A 278      -2.135  -1.354  26.601  1.00 42.88           C  
ATOM   1642  CE1 PHE A 278      -1.118   0.253  28.599  1.00 41.51           C  
ATOM   1643  CE2 PHE A 278      -0.792  -0.998  26.578  1.00 40.46           C  
ATOM   1644  CZ  PHE A 278      -0.283  -0.194  27.580  1.00 41.21           C  
ATOM   1645  N   ARG A 279      -7.598  -1.253  26.765  1.00 52.67           N  
ATOM   1646  CA  ARG A 279      -8.873  -1.974  26.630  1.00 55.85           C  
ATOM   1647  C   ARG A 279      -9.214  -2.058  25.146  1.00 57.15           C  
ATOM   1648  O   ARG A 279      -9.938  -2.950  24.714  1.00 56.14           O  
ATOM   1649  CB  ARG A 279     -10.004  -1.220  27.342  1.00 57.95           C  
ATOM   1650  CG  ARG A 279     -10.230  -1.588  28.801  1.00 62.06           C  
ATOM   1651  CD  ARG A 279     -11.247  -2.710  28.934  1.00 66.09           C  
ATOM   1652  NE  ARG A 279     -11.391  -3.187  30.311  1.00 69.23           N  
ATOM   1653  CZ  ARG A 279     -11.678  -2.413  31.356  1.00 69.67           C  
ATOM   1654  NH1 ARG A 279     -11.855  -1.106  31.192  1.00 70.11           N  
ATOM   1655  NH2 ARG A 279     -11.796  -2.951  32.563  1.00 68.25           N  
ATOM   1656  N   ASN A 280      -8.685  -1.104  24.381  1.00 59.78           N  
ATOM   1657  CA  ASN A 280      -8.909  -1.021  22.943  1.00 62.45           C  
ATOM   1658  C   ASN A 280      -8.078  -2.030  22.162  1.00 63.60           C  
ATOM   1659  O   ASN A 280      -8.614  -2.802  21.366  1.00 65.07           O  
ATOM   1660  CB  ASN A 280      -8.586   0.390  22.440  1.00 63.96           C  
ATOM   1661  CG  ASN A 280      -8.140   0.405  20.984  1.00 64.62           C  
ATOM   1662  OD1 ASN A 280      -8.934   0.168  20.073  1.00 65.76           O  
ATOM   1663  ND2 ASN A 280      -6.858   0.676  20.763  1.00 65.14           N  
ATOM   1664  N   LYS A 281      -6.767  -2.017  22.384  1.00 64.29           N  
ATOM   1665  CA  LYS A 281      -5.873  -2.930  21.684  1.00 64.42           C  
ATOM   1666  C   LYS A 281      -6.177  -4.377  22.041  1.00 63.14           C  
ATOM   1667  O   LYS A 281      -6.063  -4.778  23.200  1.00 63.16           O  
ATOM   1668  CB  LYS A 281      -4.412  -2.612  22.011  1.00 65.85           C  
ATOM   1669  CG  LYS A 281      -3.436  -3.295  21.068  1.00 69.20           C  
ATOM   1670  CD  LYS A 281      -2.071  -2.619  21.040  1.00 71.13           C  
ATOM   1671  CE  LYS A 281      -1.242  -2.973  22.259  1.00 74.25           C  
ATOM   1672  NZ  LYS A 281      -1.870  -2.496  23.522  1.00 76.35           N  
ATOM   1673  N   ALA A 282      -6.568  -5.165  21.041  1.00 61.04           N  
ATOM   1674  CA  ALA A 282      -6.895  -6.566  21.279  1.00 58.40           C  
ATOM   1675  C   ALA A 282      -5.681  -7.351  21.765  1.00 56.19           C  
ATOM   1676  O   ALA A 282      -4.698  -6.776  22.238  1.00 55.49           O  
ATOM   1677  CB  ALA A 282      -7.463  -7.196  20.016  1.00 57.25           C  
ATOM   1678  N   ASN A 283      -5.760  -8.670  21.641  1.00 53.32           N  
ATOM   1679  CA  ASN A 283      -4.692  -9.549  22.087  1.00 50.15           C  
ATOM   1680  C   ASN A 283      -4.246  -9.248  23.524  1.00 47.09           C  
ATOM   1681  O   ASN A 283      -3.108  -9.518  23.908  1.00 47.71           O  
ATOM   1682  CB  ASN A 283      -3.512  -9.489  21.109  1.00 50.30           C  
ATOM   1683  CG  ASN A 283      -3.729 -10.381  19.889  1.00 52.87           C  
ATOM   1684  OD1 ASN A 283      -3.009 -10.296  18.884  1.00 50.87           O  
ATOM   1685  ND2 ASN A 283      -4.737 -11.257  19.980  1.00 53.06           N  
ATOM   1686  N   VAL A 284      -5.142  -8.685  24.322  1.00 41.91           N  
ATOM   1687  CA  VAL A 284      -4.802  -8.418  25.707  1.00 39.68           C  
ATOM   1688  C   VAL A 284      -5.754  -9.150  26.634  1.00 38.04           C  
ATOM   1689  O   VAL A 284      -6.934  -8.819  26.716  1.00 37.77           O  
ATOM   1690  CB  VAL A 284      -4.816  -6.912  26.026  1.00 39.75           C  
ATOM   1691  CG1 VAL A 284      -4.699  -6.689  27.533  1.00 38.15           C  
ATOM   1692  CG2 VAL A 284      -3.648  -6.236  25.312  1.00 36.18           C  
ATOM   1693  N   THR A 285      -5.231 -10.159  27.326  1.00 35.61           N  
ATOM   1694  CA  THR A 285      -6.050 -10.943  28.238  1.00 34.10           C  
ATOM   1695  C   THR A 285      -6.194 -10.158  29.513  1.00 32.98           C  
ATOM   1696  O   THR A 285      -5.205  -9.705  30.068  1.00 33.83           O  
ATOM   1697  CB  THR A 285      -5.400 -12.271  28.574  1.00 33.60           C  
ATOM   1698  OG1 THR A 285      -4.890 -12.865  27.375  1.00 34.86           O  
ATOM   1699  CG2 THR A 285      -6.432 -13.197  29.210  1.00 32.19           C  
ATOM   1700  N   TRP A 286      -7.423 -10.003  29.983  1.00 33.38           N  
ATOM   1701  CA  TRP A 286      -7.656  -9.245  31.197  1.00 34.57           C  
ATOM   1702  C   TRP A 286      -7.979 -10.055  32.456  1.00 35.57           C  
ATOM   1703  O   TRP A 286      -8.714 -11.036  32.413  1.00 37.67           O  
ATOM   1704  CB  TRP A 286      -8.773  -8.209  30.959  1.00 33.36           C  
ATOM   1705  CG  TRP A 286      -8.407  -7.114  29.959  1.00 32.29           C  
ATOM   1706  CD1 TRP A 286      -8.585  -7.143  28.605  1.00 31.33           C  
ATOM   1707  CD2 TRP A 286      -7.726  -5.878  30.242  1.00 32.07           C  
ATOM   1708  NE1 TRP A 286      -8.057  -6.010  28.031  1.00 34.46           N  
ATOM   1709  CE2 TRP A 286      -7.526  -5.216  29.012  1.00 32.07           C  
ATOM   1710  CE3 TRP A 286      -7.266  -5.272  31.415  1.00 33.24           C  
ATOM   1711  CZ2 TRP A 286      -6.887  -3.977  28.920  1.00 32.78           C  
ATOM   1712  CZ3 TRP A 286      -6.627  -4.037  31.322  1.00 33.16           C  
ATOM   1713  CH2 TRP A 286      -6.446  -3.406  30.083  1.00 32.27           C  
ATOM   1714  N   PHE A 287      -7.405  -9.624  33.574  1.00 36.41           N  
ATOM   1715  CA  PHE A 287      -7.654 -10.231  34.877  1.00 36.77           C  
ATOM   1716  C   PHE A 287      -7.868  -9.030  35.784  1.00 37.05           C  
ATOM   1717  O   PHE A 287      -7.043  -8.112  35.799  1.00 33.90           O  
ATOM   1718  CB  PHE A 287      -6.441 -11.012  35.382  1.00 36.65           C  
ATOM   1719  CG  PHE A 287      -5.989 -12.091  34.455  1.00 36.37           C  
ATOM   1720  CD1 PHE A 287      -4.963 -11.863  33.554  1.00 38.55           C  
ATOM   1721  CD2 PHE A 287      -6.604 -13.334  34.466  1.00 35.20           C  
ATOM   1722  CE1 PHE A 287      -4.559 -12.857  32.679  1.00 40.13           C  
ATOM   1723  CE2 PHE A 287      -6.206 -14.328  33.594  1.00 34.64           C  
ATOM   1724  CZ  PHE A 287      -5.183 -14.088  32.701  1.00 37.43           C  
ATOM   1725  N   ASP A 288      -8.975  -9.009  36.521  1.00 37.76           N  
ATOM   1726  CA  ASP A 288      -9.195  -7.877  37.399  1.00 39.58           C  
ATOM   1727  C   ASP A 288      -8.955  -8.315  38.821  1.00 39.68           C  
ATOM   1728  O   ASP A 288      -9.589  -9.234  39.349  1.00 38.18           O  
ATOM   1729  CB  ASP A 288     -10.587  -7.268  37.225  1.00 43.54           C  
ATOM   1730  CG  ASP A 288     -11.656  -8.066  37.889  1.00 45.57           C  
ATOM   1731  OD1 ASP A 288     -11.785  -9.264  37.549  1.00 48.63           O  
ATOM   1732  OD2 ASP A 288     -12.368  -7.486  38.743  1.00 45.10           O  
HETATM 1733  N   MSE A 289      -7.983  -7.653  39.426  1.00 39.29           N  
HETATM 1734  CA  MSE A 289      -7.575  -7.963  40.774  1.00 41.05           C  
HETATM 1735  C   MSE A 289      -8.642  -7.540  41.776  1.00 43.62           C  
HETATM 1736  O   MSE A 289      -9.380  -8.378  42.290  1.00 47.66           O  
HETATM 1737  CB  MSE A 289      -6.234  -7.289  40.973  1.00 39.29           C  
HETATM 1738  CG  MSE A 289      -5.385  -7.466  39.682  1.00 41.06           C  
HETATM 1739 SE   MSE A 289      -5.200  -9.347  39.137  1.00 42.98          SE  
HETATM 1740  CE  MSE A 289      -4.013  -9.928  40.540  1.00 37.68           C  
ATOM   1741  N   THR A 290      -8.735  -6.248  42.045  1.00 44.15           N  
ATOM   1742  CA  THR A 290      -9.747  -5.722  42.949  1.00 43.78           C  
ATOM   1743  C   THR A 290     -10.145  -6.643  44.116  1.00 44.20           C  
ATOM   1744  O   THR A 290     -10.971  -7.547  43.977  1.00 42.23           O  
ATOM   1745  CB  THR A 290     -10.995  -5.304  42.128  1.00 43.32           C  
ATOM   1746  OG1 THR A 290     -12.151  -5.285  42.973  1.00 43.49           O  
ATOM   1747  CG2 THR A 290     -11.204  -6.248  40.951  1.00 43.66           C  
ATOM   1748  N   ASP A 291      -9.528  -6.405  45.268  1.00 44.69           N  
ATOM   1749  CA  ASP A 291      -9.811  -7.178  46.464  1.00 46.70           C  
ATOM   1750  C   ASP A 291      -9.667  -8.675  46.256  1.00 46.24           C  
ATOM   1751  O   ASP A 291     -10.503  -9.448  46.712  1.00 45.03           O  
ATOM   1752  CB  ASP A 291     -11.225  -6.861  46.964  1.00 48.58           C  
ATOM   1753  CG  ASP A 291     -11.296  -5.528  47.685  1.00 51.41           C  
ATOM   1754  OD1 ASP A 291     -12.423  -5.015  47.882  1.00 53.31           O  
ATOM   1755  OD2 ASP A 291     -10.219  -5.000  48.067  1.00 51.34           O  
ATOM   1756  N   VAL A 292      -8.603  -9.103  45.592  1.00 45.16           N  
ATOM   1757  CA  VAL A 292      -8.446 -10.526  45.374  1.00 45.48           C  
ATOM   1758  C   VAL A 292      -7.237 -11.090  46.099  1.00 44.30           C  
ATOM   1759  O   VAL A 292      -6.344 -10.349  46.490  1.00 46.43           O  
ATOM   1760  CB  VAL A 292      -8.342 -10.840  43.877  1.00 47.56           C  
ATOM   1761  CG1 VAL A 292      -7.006 -10.360  43.332  1.00 47.17           C  
ATOM   1762  CG2 VAL A 292      -8.540 -12.327  43.655  1.00 51.47           C  
ATOM   1763  N   ASP A 293      -7.217 -12.400  46.298  1.00 42.76           N  
ATOM   1764  CA  ASP A 293      -6.091 -13.026  46.974  1.00 42.74           C  
ATOM   1765  C   ASP A 293      -4.991 -13.328  45.971  1.00 41.24           C  
ATOM   1766  O   ASP A 293      -5.153 -14.205  45.122  1.00 41.34           O  
ATOM   1767  CB  ASP A 293      -6.511 -14.334  47.644  1.00 43.46           C  
ATOM   1768  CG  ASP A 293      -5.327 -15.091  48.216  1.00 42.78           C  
ATOM   1769  OD1 ASP A 293      -5.479 -16.278  48.579  1.00 43.35           O  
ATOM   1770  OD2 ASP A 293      -4.239 -14.484  48.301  1.00 42.89           O  
ATOM   1771  N   PHE A 294      -3.869 -12.628  46.072  1.00 40.57           N  
ATOM   1772  CA  PHE A 294      -2.781 -12.863  45.132  1.00 41.18           C  
ATOM   1773  C   PHE A 294      -2.302 -14.302  45.153  1.00 41.72           C  
ATOM   1774  O   PHE A 294      -1.731 -14.777  44.175  1.00 39.39           O  
ATOM   1775  CB  PHE A 294      -1.619 -11.889  45.372  1.00 38.87           C  
ATOM   1776  CG  PHE A 294      -1.824 -10.546  44.715  1.00 37.52           C  
ATOM   1777  CD1 PHE A 294      -2.860  -9.715  45.118  1.00 36.36           C  
ATOM   1778  CD2 PHE A 294      -1.014 -10.132  43.661  1.00 36.03           C  
ATOM   1779  CE1 PHE A 294      -3.089  -8.492  44.479  1.00 35.41           C  
ATOM   1780  CE2 PHE A 294      -1.239  -8.916  43.025  1.00 33.75           C  
ATOM   1781  CZ  PHE A 294      -2.277  -8.097  43.432  1.00 33.97           C  
ATOM   1782  N   ASP A 295      -2.566 -15.005  46.252  1.00 42.97           N  
ATOM   1783  CA  ASP A 295      -2.165 -16.401  46.369  1.00 44.05           C  
ATOM   1784  C   ASP A 295      -3.070 -17.287  45.516  1.00 45.44           C  
ATOM   1785  O   ASP A 295      -2.798 -18.469  45.326  1.00 46.93           O  
ATOM   1786  CB  ASP A 295      -2.207 -16.838  47.837  1.00 44.40           C  
ATOM   1787  CG  ASP A 295      -0.926 -16.507  48.570  1.00 44.56           C  
ATOM   1788  OD1 ASP A 295      -0.887 -16.661  49.808  1.00 44.34           O  
ATOM   1789  OD2 ASP A 295       0.046 -16.100  47.896  1.00 45.54           O  
ATOM   1790  N   LYS A 296      -4.140 -16.696  44.996  1.00 45.91           N  
ATOM   1791  CA  LYS A 296      -5.091 -17.406  44.150  1.00 46.65           C  
ATOM   1792  C   LYS A 296      -4.909 -16.966  42.702  1.00 44.35           C  
ATOM   1793  O   LYS A 296      -4.599 -17.774  41.821  1.00 44.00           O  
ATOM   1794  CB  LYS A 296      -6.526 -17.090  44.569  1.00 50.29           C  
ATOM   1795  CG  LYS A 296      -7.271 -18.217  45.247  1.00 53.96           C  
ATOM   1796  CD  LYS A 296      -6.725 -18.516  46.631  1.00 56.84           C  
ATOM   1797  CE  LYS A 296      -7.639 -19.500  47.365  1.00 59.34           C  
ATOM   1798  NZ  LYS A 296      -7.823 -20.769  46.601  1.00 61.14           N  
ATOM   1799  N   LYS A 297      -5.108 -15.674  42.467  1.00 42.15           N  
ATOM   1800  CA  LYS A 297      -4.980 -15.117  41.125  1.00 40.50           C  
ATOM   1801  C   LYS A 297      -3.677 -15.487  40.460  1.00 37.74           C  
ATOM   1802  O   LYS A 297      -3.658 -15.841  39.286  1.00 37.50           O  
ATOM   1803  CB  LYS A 297      -5.121 -13.591  41.147  1.00 38.88           C  
ATOM   1804  CG  LYS A 297      -6.550 -13.109  40.996  1.00 41.10           C  
ATOM   1805  CD  LYS A 297      -7.160 -13.541  39.660  1.00 41.13           C  
ATOM   1806  CE  LYS A 297      -8.522 -12.892  39.448  1.00 41.80           C  
ATOM   1807  NZ  LYS A 297      -9.118 -13.181  38.113  1.00 39.55           N  
ATOM   1808  N   ILE A 298      -2.589 -15.424  41.210  1.00 34.60           N  
ATOM   1809  CA  ILE A 298      -1.304 -15.753  40.629  1.00 34.98           C  
ATOM   1810  C   ILE A 298      -1.324 -17.107  39.919  1.00 35.35           C  
ATOM   1811  O   ILE A 298      -0.859 -17.206  38.793  1.00 35.51           O  
ATOM   1812  CB  ILE A 298      -0.182 -15.761  41.682  1.00 35.02           C  
ATOM   1813  CG1 ILE A 298       1.152 -16.009  40.994  1.00 35.34           C  
ATOM   1814  CG2 ILE A 298      -0.427 -16.857  42.713  1.00 36.72           C  
ATOM   1815  CD1 ILE A 298       1.564 -14.905  40.108  1.00 36.13           C  
HETATM 1816  N   MSE A 299      -1.867 -18.139  40.555  1.00 34.88           N  
HETATM 1817  CA  MSE A 299      -1.898 -19.455  39.932  1.00 36.60           C  
HETATM 1818  C   MSE A 299      -2.694 -19.405  38.643  1.00 35.03           C  
HETATM 1819  O   MSE A 299      -2.358 -20.073  37.681  1.00 35.19           O  
HETATM 1820  CB  MSE A 299      -2.536 -20.490  40.858  1.00 40.96           C  
HETATM 1821  CG  MSE A 299      -1.922 -20.589  42.243  1.00 46.82           C  
HETATM 1822 SE   MSE A 299      -2.740 -21.997  43.307  1.00 55.84          SE  
HETATM 1823  CE  MSE A 299      -4.234 -21.016  44.056  1.00 51.23           C  
ATOM   1824  N   GLU A 300      -3.756 -18.612  38.640  1.00 35.16           N  
ATOM   1825  CA  GLU A 300      -4.618 -18.469  37.474  1.00 34.43           C  
ATOM   1826  C   GLU A 300      -3.827 -17.905  36.289  1.00 34.89           C  
ATOM   1827  O   GLU A 300      -3.821 -18.491  35.211  1.00 33.12           O  
ATOM   1828  CB  GLU A 300      -5.788 -17.542  37.822  1.00 33.47           C  
ATOM   1829  CG  GLU A 300      -6.951 -17.566  36.841  1.00 36.89           C  
ATOM   1830  CD  GLU A 300      -7.986 -16.478  37.123  1.00 38.27           C  
ATOM   1831  OE1 GLU A 300      -8.385 -16.311  38.295  1.00 38.01           O  
ATOM   1832  OE2 GLU A 300      -8.408 -15.793  36.166  1.00 40.73           O  
ATOM   1833  N   ILE A 301      -3.144 -16.782  36.521  1.00 35.84           N  
ATOM   1834  CA  ILE A 301      -2.343 -16.084  35.514  1.00 36.02           C  
ATOM   1835  C   ILE A 301      -1.162 -16.945  35.101  1.00 37.36           C  
ATOM   1836  O   ILE A 301      -0.896 -17.167  33.915  1.00 37.60           O  
ATOM   1837  CB  ILE A 301      -1.800 -14.730  36.083  1.00 36.05           C  
ATOM   1838  CG1 ILE A 301      -2.957 -13.916  36.675  1.00 36.77           C  
ATOM   1839  CG2 ILE A 301      -1.110 -13.919  34.985  1.00 32.54           C  
ATOM   1840  CD1 ILE A 301      -2.538 -12.652  37.399  1.00 37.22           C  
ATOM   1841  N   HIS A 302      -0.452 -17.424  36.108  1.00 39.17           N  
ATOM   1842  CA  HIS A 302       0.713 -18.263  35.900  1.00 39.82           C  
ATOM   1843  C   HIS A 302       0.399 -19.363  34.893  1.00 39.54           C  
ATOM   1844  O   HIS A 302       1.063 -19.488  33.860  1.00 37.98           O  
ATOM   1845  CB  HIS A 302       1.137 -18.876  37.231  1.00 40.78           C  
ATOM   1846  CG  HIS A 302       2.306 -19.796  37.125  1.00 42.69           C  
ATOM   1847  ND1 HIS A 302       2.799 -20.495  38.201  1.00 44.85           N  
ATOM   1848  CD2 HIS A 302       3.070 -20.145  36.062  1.00 44.77           C  
ATOM   1849  CE1 HIS A 302       3.816 -21.240  37.809  1.00 46.39           C  
ATOM   1850  NE2 HIS A 302       4.001 -21.045  36.516  1.00 47.27           N  
ATOM   1851  N   ASN A 303      -0.609 -20.165  35.209  1.00 37.16           N  
ATOM   1852  CA  ASN A 303      -1.008 -21.241  34.329  1.00 37.07           C  
ATOM   1853  C   ASN A 303      -1.334 -20.707  32.922  1.00 38.73           C  
ATOM   1854  O   ASN A 303      -0.806 -21.213  31.929  1.00 39.72           O  
ATOM   1855  CB  ASN A 303      -2.216 -21.961  34.917  1.00 35.25           C  
ATOM   1856  CG  ASN A 303      -2.730 -23.047  34.013  1.00 36.08           C  
ATOM   1857  OD1 ASN A 303      -2.047 -24.042  33.752  1.00 36.76           O  
ATOM   1858  ND2 ASN A 303      -3.941 -22.867  33.525  1.00 34.11           N  
ATOM   1859  N   PHE A 304      -2.183 -19.681  32.835  1.00 38.76           N  
ATOM   1860  CA  PHE A 304      -2.544 -19.125  31.537  1.00 39.24           C  
ATOM   1861  C   PHE A 304      -1.316 -18.748  30.718  1.00 39.61           C  
ATOM   1862  O   PHE A 304      -1.224 -19.105  29.545  1.00 41.26           O  
ATOM   1863  CB  PHE A 304      -3.464 -17.901  31.682  1.00 40.63           C  
ATOM   1864  CG  PHE A 304      -3.636 -17.120  30.399  1.00 39.89           C  
ATOM   1865  CD1 PHE A 304      -2.904 -15.959  30.167  1.00 38.66           C  
ATOM   1866  CD2 PHE A 304      -4.461 -17.591  29.384  1.00 39.06           C  
ATOM   1867  CE1 PHE A 304      -2.990 -15.289  28.947  1.00 37.77           C  
ATOM   1868  CE2 PHE A 304      -4.546 -16.920  28.161  1.00 39.25           C  
ATOM   1869  CZ  PHE A 304      -3.809 -15.771  27.945  1.00 35.93           C  
ATOM   1870  N   ILE A 305      -0.379 -18.032  31.331  1.00 39.12           N  
ATOM   1871  CA  ILE A 305       0.839 -17.623  30.639  1.00 39.79           C  
ATOM   1872  C   ILE A 305       1.659 -18.838  30.186  1.00 41.27           C  
ATOM   1873  O   ILE A 305       2.012 -18.961  29.006  1.00 38.98           O  
ATOM   1874  CB  ILE A 305       1.710 -16.715  31.537  1.00 40.21           C  
ATOM   1875  CG1 ILE A 305       0.970 -15.404  31.815  1.00 39.79           C  
ATOM   1876  CG2 ILE A 305       3.049 -16.421  30.861  1.00 42.05           C  
ATOM   1877  CD1 ILE A 305       1.721 -14.454  32.725  1.00 36.85           C  
ATOM   1878  N   ALA A 306       1.951 -19.743  31.120  1.00 41.59           N  
ATOM   1879  CA  ALA A 306       2.727 -20.939  30.800  1.00 41.67           C  
ATOM   1880  C   ALA A 306       2.114 -21.646  29.613  1.00 43.42           C  
ATOM   1881  O   ALA A 306       2.804 -22.006  28.654  1.00 42.79           O  
ATOM   1882  CB  ALA A 306       2.750 -21.883  31.989  1.00 41.08           C  
ATOM   1883  N   GLY A 307       0.801 -21.826  29.692  1.00 45.29           N  
ATOM   1884  CA  GLY A 307       0.072 -22.510  28.645  1.00 48.82           C  
ATOM   1885  C   GLY A 307       0.124 -21.829  27.296  1.00 51.38           C  
ATOM   1886  O   GLY A 307       0.558 -22.419  26.304  1.00 52.56           O  
ATOM   1887  N   LYS A 308      -0.311 -20.580  27.255  1.00 52.27           N  
ATOM   1888  CA  LYS A 308      -0.316 -19.855  26.004  1.00 53.92           C  
ATOM   1889  C   LYS A 308       1.064 -19.820  25.347  1.00 53.98           C  
ATOM   1890  O   LYS A 308       1.169 -19.961  24.140  1.00 55.14           O  
ATOM   1891  CB  LYS A 308      -0.856 -18.435  26.212  1.00 53.50           C  
ATOM   1892  CG  LYS A 308      -1.094 -17.696  24.906  1.00 54.62           C  
ATOM   1893  CD  LYS A 308      -1.912 -16.432  25.105  1.00 55.17           C  
ATOM   1894  CE  LYS A 308      -2.164 -15.732  23.778  1.00 53.20           C  
ATOM   1895  NZ  LYS A 308      -3.211 -14.680  23.887  1.00 52.62           N  
ATOM   1896  N   LEU A 309       2.127 -19.658  26.122  1.00 55.34           N  
ATOM   1897  CA  LEU A 309       3.454 -19.606  25.512  1.00 56.60           C  
ATOM   1898  C   LEU A 309       3.805 -20.868  24.736  1.00 59.64           C  
ATOM   1899  O   LEU A 309       4.326 -20.797  23.624  1.00 58.72           O  
ATOM   1900  CB  LEU A 309       4.531 -19.350  26.568  1.00 53.63           C  
ATOM   1901  CG  LEU A 309       4.836 -17.881  26.886  1.00 52.18           C  
ATOM   1902  CD1 LEU A 309       5.744 -17.800  28.097  1.00 47.34           C  
ATOM   1903  CD2 LEU A 309       5.486 -17.200  25.677  1.00 49.48           C  
ATOM   1904  N   GLU A 310       3.511 -22.023  25.325  1.00 63.64           N  
ATOM   1905  CA  GLU A 310       3.821 -23.301  24.697  1.00 68.08           C  
ATOM   1906  C   GLU A 310       2.976 -23.670  23.485  1.00 70.06           C  
ATOM   1907  O   GLU A 310       3.485 -24.264  22.536  1.00 70.59           O  
ATOM   1908  CB  GLU A 310       3.748 -24.416  25.735  1.00 69.37           C  
ATOM   1909  CG  GLU A 310       5.060 -24.652  26.449  1.00 72.87           C  
ATOM   1910  CD  GLU A 310       4.879 -25.389  27.755  1.00 74.55           C  
ATOM   1911  OE1 GLU A 310       4.190 -26.433  27.754  1.00 75.01           O  
ATOM   1912  OE2 GLU A 310       5.428 -24.924  28.780  1.00 76.13           O  
ATOM   1913  N   GLU A 311       1.692 -23.330  23.508  1.00 71.90           N  
ATOM   1914  CA  GLU A 311       0.830 -23.656  22.378  1.00 73.87           C  
ATOM   1915  C   GLU A 311       1.244 -22.896  21.116  1.00 74.02           C  
ATOM   1916  O   GLU A 311       1.452 -23.499  20.061  1.00 73.33           O  
ATOM   1917  CB  GLU A 311      -0.637 -23.355  22.713  1.00 75.07           C  
ATOM   1918  CG  GLU A 311      -0.879 -21.963  23.275  1.00 76.56           C  
ATOM   1919  CD  GLU A 311      -2.357 -21.621  23.397  1.00 78.23           C  
ATOM   1920  OE1 GLU A 311      -3.110 -22.410  24.017  1.00 78.03           O  
ATOM   1921  OE2 GLU A 311      -2.762 -20.555  22.879  1.00 78.76           O  
ATOM   1922  N   LYS A 312       1.376 -21.577  21.235  1.00 75.12           N  
ATOM   1923  CA  LYS A 312       1.760 -20.733  20.107  1.00 75.85           C  
ATOM   1924  C   LYS A 312       3.006 -21.221  19.382  1.00 76.11           C  
ATOM   1925  O   LYS A 312       3.179 -20.955  18.193  1.00 76.43           O  
ATOM   1926  CB  LYS A 312       1.965 -19.283  20.561  1.00 76.35           C  
ATOM   1927  CG  LYS A 312       0.666 -18.501  20.737  1.00 77.18           C  
ATOM   1928  CD  LYS A 312       0.928 -17.016  20.960  1.00 79.08           C  
ATOM   1929  CE  LYS A 312       1.178 -16.686  22.428  1.00 80.31           C  
ATOM   1930  NZ  LYS A 312       2.289 -17.474  23.045  1.00 80.44           N  
ATOM   1931  N   SER A 313       3.875 -21.935  20.089  1.00 75.96           N  
ATOM   1932  CA  SER A 313       5.087 -22.444  19.466  1.00 75.55           C  
ATOM   1933  C   SER A 313       4.818 -23.795  18.806  1.00 75.57           C  
ATOM   1934  O   SER A 313       5.269 -24.836  19.293  1.00 74.67           O  
ATOM   1935  CB  SER A 313       6.213 -22.571  20.500  1.00 75.77           C  
ATOM   1936  OG  SER A 313       5.926 -23.553  21.477  1.00 76.40           O  
ATOM   1937  N   LYS A 314       4.076 -23.766  17.698  1.00 75.47           N  
ATOM   1938  CA  LYS A 314       3.742 -24.978  16.947  1.00 75.76           C  
ATOM   1939  C   LYS A 314       4.881 -25.392  16.015  1.00 76.37           C  
ATOM   1940  O   LYS A 314       5.345 -26.550  16.132  1.00 75.94           O  
ATOM   1941  CB  LYS A 314       2.455 -24.778  16.126  1.00 74.98           C  
ATOM   1942  CG  LYS A 314       2.481 -23.602  15.143  1.00 74.52           C  
ATOM   1943  CD  LYS A 314       1.719 -22.391  15.679  1.00 72.28           C  
ATOM   1944  CE  LYS A 314       0.239 -22.716  15.871  1.00 71.47           C  
ATOM   1945  NZ  LYS A 314      -0.572 -21.549  16.313  1.00 69.90           N  
TER    1946      LYS A 314                                                      
END
MOLECULE T0416_6_115_194_315.pdb
ATOM      1  N   LYS     6       9.770 -16.706  17.344  1.00 47.34          
ATOM      2  CA  LYS     6       9.686 -15.469  18.171  1.00 47.92          
ATOM      3  C   LYS     6       9.964 -15.789  19.633  1.00 48.21          
ATOM      4  O   LYS     6       9.492 -16.801  20.167  1.00 48.06          
ATOM      5  CB  LYS     6       8.296 -14.851  18.062  1.00 48.33          
ATOM      6  CG  LYS     6       7.859 -14.572  16.663  1.00 51.47          
ATOM      7  CD  LYS     6       6.355 -14.397  16.582  1.00 55.16          
ATOM      8  CE  LYS     6       5.919 -14.283  15.119  1.00 58.23          
ATOM      9  NZ  LYS     6       4.444 -14.137  14.929  1.00 59.84          
ATOM     10  N   PRO     7      10.743 -14.930  20.304  1.00 47.62          
ATOM     11  CA  PRO     7      11.079 -15.125  21.721  1.00 47.47          
ATOM     12  C   PRO     7       9.897 -14.902  22.682  1.00 46.63          
ATOM     13  O   PRO     7       9.082 -13.993  22.493  1.00 46.51          
ATOM     14  CB  PRO     7      12.203 -14.114  21.955  1.00 48.11          
ATOM     15  CG  PRO     7      11.877 -13.021  20.986  1.00 48.00          
ATOM     16  CD  PRO     7      11.471 -13.782  19.741  1.00 46.88          
ATOM     17  N   PHE     8       9.814 -15.737  23.715  1.00 44.40          
ATOM     18  CA  PHE     8       8.747 -15.622  24.697  1.00 41.95          
ATOM     19  C   PHE     8       8.958 -14.388  25.566  1.00 40.54          
ATOM     20  O   PHE     8      10.068 -14.136  26.041  1.00 40.58          
ATOM     21  CB  PHE     8       8.694 -16.865  25.591  1.00 41.58          
ATOM     22  CG  PHE     8       7.522 -16.884  26.531  1.00 41.07          
ATOM     23  CD1 PHE     8       6.222 -16.919  26.036  1.00 42.79          
ATOM     24  CD2 PHE     8       7.707 -16.854  27.901  1.00 39.99          
ATOM     25  CE1 PHE     8       5.122 -16.927  26.895  1.00 42.19          
ATOM     26  CE2 PHE     8       6.611 -16.863  28.767  1.00 41.03          
ATOM     27  CZ  PHE     8       5.315 -16.899  28.253  1.00 40.90          
ATOM     28  N   LEU     9       7.881 -13.631  25.767  1.00 38.04          
ATOM     29  CA  LEU     9       7.915 -12.418  26.583  1.00 36.38          
ATOM     30  C   LEU     9       6.629 -12.238  27.393  1.00 35.98          
ATOM     31  O   LEU     9       5.542 -12.412  26.847  1.00 37.94          
ATOM     32  CB  LEU     9       8.085 -11.198  25.687  1.00 33.92          
ATOM     33  CG  LEU     9       8.128  -9.872  26.431  1.00 31.31          
ATOM     34  CD1 LEU     9       9.465  -9.700  27.105  1.00 30.33          
ATOM     35  CD2 LEU     9       7.901  -8.759  25.453  1.00 32.13          
ATOM     36  N   ILE    10       6.742 -11.899  28.680  1.00 34.13          
ATOM     37  CA  ILE    10       5.554 -11.660  29.516  1.00 33.61          
ATOM     38  C   ILE    10       5.402 -10.159  29.661  1.00 32.88          
ATOM     39  O   ILE    10       6.389  -9.457  29.867  1.00 32.89          
ATOM     40  CB  ILE    10       5.671 -12.221  30.978  1.00 34.19          
ATOM     41  CG1 ILE    10       5.795 -13.745  30.994  1.00 34.92          
ATOM     42  CG2 ILE    10       4.410 -11.875  31.762  1.00 32.53          
ATOM     43  CD  ILE    10       4.537 -14.446  30.557  1.00 35.17          
ATOM     44  N   VAL    11       4.179  -9.656  29.545  1.00 32.25          
ATOM     45  CA  VAL    11       3.953  -8.211  29.699  1.00 33.18          
ATOM     46  C   VAL    11       2.799  -7.993  30.705  1.00 33.37          
ATOM     47  O   VAL    11       1.670  -8.456  30.494  1.00 33.93          
ATOM     48  CB  VAL    11       3.605  -7.524  28.325  1.00 31.73          
ATOM     49  CG1 VAL    11       3.619  -6.017  28.467  1.00 30.56          
ATOM     50  CG2 VAL    11       4.587  -7.943  27.263  1.00 29.73          
ATOM     51  N   ILE    12       3.091  -7.290  31.797  1.00 31.84          
ATOM     52  CA  ILE    12       2.106  -7.032  32.842  1.00 30.80          
ATOM     53  C   ILE    12       1.866  -5.536  33.017  1.00 31.11          
ATOM     54  O   ILE    12       2.624  -4.849  33.708  1.00 30.46          
ATOM     55  CB  ILE    12       2.569  -7.632  34.189  1.00 29.53          
ATOM     56  CG1 ILE    12       2.895  -9.114  33.996  1.00 29.86          
ATOM     57  CG2 ILE    12       1.478  -7.487  35.230  1.00 30.33          
ATOM     58  CD  ILE    12       3.522  -9.776  35.203  1.00 26.96          
ATOM     59  N   VAL    13       0.808  -5.035  32.383  1.00 30.72          
ATOM     60  CA  VAL    13       0.466  -3.620  32.457  1.00 29.94          
ATOM     61  C   VAL    13      -0.652  -3.426  33.452  1.00 29.66          
ATOM     62  O   VAL    13      -1.336  -4.374  33.801  1.00 30.84          
ATOM     63  CB  VAL    13      -0.002  -3.077  31.090  1.00 29.53          
ATOM     64  CG1 VAL    13       1.132  -3.140  30.075  1.00 29.05          
ATOM     65  CG2 VAL    13      -1.188  -3.876  30.601  1.00 28.45          
ATOM     66  N   GLY    14      -0.839  -2.199  33.909  1.00 30.29          
ATOM     67  CA  GLY    14      -1.889  -1.938  34.871  1.00 31.58          
ATOM     68  C   GLY    14      -1.642  -0.598  35.525  1.00 32.22          
ATOM     69  O   GLY    14      -0.521  -0.108  35.523  1.00 31.01          
ATOM     70  N   PRO    15      -2.677   0.021  36.103  1.00 33.98          
ATOM     71  CA  PRO    15      -2.483   1.323  36.744  1.00 35.35          
ATOM     72  C   PRO    15      -1.478   1.279  37.893  1.00 36.07          
ATOM     73  O   PRO    15      -1.230   0.218  38.457  1.00 36.01          
ATOM     74  CB  PRO    15      -3.897   1.696  37.187  1.00 34.89          
ATOM     75  CG  PRO    15      -4.545   0.365  37.419  1.00 34.89          
ATOM     76  CD  PRO    15      -4.070  -0.442  36.245  1.00 35.07          
ATOM     77  N   THR    16      -0.891   2.431  38.211  1.00 36.66          
ATOM     78  CA  THR    16       0.089   2.538  39.286  1.00 38.58          
ATOM     79  C   THR    16      -0.373   1.853  40.573  1.00 40.27          
ATOM     80  O   THR    16      -1.523   2.001  40.989  1.00 40.98          
ATOM     81  CB  THR    16       0.385   3.997  39.643  1.00 37.33          
ATOM     82  OG1 THR    16       0.786   4.705  38.474  1.00 36.77          
ATOM     83  CG2 THR    16       1.495   4.061  40.671  1.00 38.23          
ATOM     84  N   ALA    17       0.536   1.118  41.208  1.00 40.72          
ATOM     85  CA  ALA    17       0.219   0.417  42.443  1.00 42.57          
ATOM     86  C   ALA    17      -1.083  -0.378  42.324  1.00 43.15          
ATOM     87  O   ALA    17      -2.011  -0.205  43.123  1.00 43.42          
ATOM     88  CB  ALA    17       0.109   1.412  43.597  1.00 43.65          
ATOM     89  N   SER    18      -1.159  -1.238  41.317  1.00 42.43          
ATOM     90  CA  SER    18      -2.344  -2.051  41.119  1.00 40.61          
ATOM     91  C   SER    18      -1.921  -3.495  41.298  1.00 40.77          
ATOM     92  O   SER    18      -2.693  -4.424  41.054  1.00 42.04          
ATOM     93  CB  SER    18      -2.892  -1.870  39.719  1.00 38.47          
ATOM     94  OG  SER    18      -2.013  -2.466  38.804  1.00 36.84          
ATOM     95  N   GLY    19      -0.681  -3.681  41.730  1.00 40.01          
ATOM     96  CA  GLY    19      -0.170  -5.026  41.920  1.00 40.03          
ATOM     97  C   GLY    19       0.645  -5.548  40.744  1.00 38.18          
ATOM     98  O   GLY    19       1.235  -6.625  40.806  1.00 38.21          
ATOM     99  N   LYS    20       0.684  -4.791  39.660  1.00 36.98          
ATOM    100  CA  LYS    20       1.444  -5.241  38.522  1.00 35.89          
ATOM    101  C   LYS    20       2.908  -5.443  38.936  1.00 36.34          
ATOM    102  O   LYS    20       3.527  -6.452  38.590  1.00 37.13          
ATOM    103  CB  LYS    20       1.330  -4.248  37.362  1.00 33.94          
ATOM    104  CG  LYS    20       1.849  -2.871  37.685  1.00 32.57          
ATOM    105  CD  LYS    20       1.824  -1.935  36.498  1.00 29.33          
ATOM    106  CE  LYS    20       2.436  -0.614  36.924  1.00 31.07          
ATOM    107  NZ  LYS    20       2.250   0.476  35.923  1.00 35.59          
ATOM    108  N   THR    21       3.455  -4.511  39.705  1.00 35.70          
ATOM    109  CA  THR    21       4.840  -4.619  40.147  1.00 35.75          
ATOM    110  C   THR    21       5.079  -5.838  41.024  1.00 35.78          
ATOM    111  O   THR    21       6.054  -6.572  40.832  1.00 35.67          
ATOM    112  CB  THR    21       5.269  -3.372  40.918  1.00 36.24          
ATOM    113  OG1 THR    21       5.065  -2.221  40.090  1.00 38.69          
ATOM    114  CG2 THR    21       6.742  -3.464  41.302  1.00 36.35          
ATOM    115  N   GLU    22       4.197  -6.056  41.989  1.00 35.56          
ATOM    116  CA  GLU    22       4.326  -7.196  42.879  1.00 36.42          
ATOM    117  C   GLU    22       4.155  -8.475  42.073  1.00 35.88          
ATOM    118  O   GLU    22       4.979  -9.381  42.161  1.00 37.29          
ATOM    119  CB  GLU    22       3.271  -7.119  43.984  1.00 39.34          
ATOM    120  CG  GLU    22       3.439  -5.935  44.935  1.00 43.60          
ATOM    121  CD  GLU    22       3.007  -4.586  44.343  1.00 45.57          
ATOM    122  OE1 GLU    22       3.218  -3.557  45.018  1.00 48.08          
ATOM    123  OE2 GLU    22       2.457  -4.544  43.224  1.00 46.06          
ATOM    124  N   LEU    23       3.090  -8.539  41.276  1.00 34.58          
ATOM    125  CA  LEU    23       2.826  -9.704  40.445  1.00 32.10          
ATOM    126  C   LEU    23       4.039 -10.051  39.576  1.00 31.09          
ATOM    127  O   LEU    23       4.403 -11.217  39.458  1.00 27.98          
ATOM    128  CB  LEU    23       1.599  -9.455  39.558  1.00 30.74          
ATOM    129  CG  LEU    23       1.222 -10.580  38.579  1.00 28.65          
ATOM    130  CD1 LEU    23       0.822 -11.814  39.341  1.00 28.78          
ATOM    131  CD2 LEU    23       0.098 -10.121  37.709  1.00 27.36          
ATOM    132  N   SER    24       4.663  -9.040  38.973  1.00 32.29          
ATOM    133  CA  SER    24       5.842  -9.271  38.129  1.00 34.51          
ATOM    134  C   SER    24       6.915 -10.040  38.890  1.00 34.30          
ATOM    135  O   SER    24       7.439 -11.030  38.403  1.00 35.07          
ATOM    136  CB  SER    24       6.445  -7.954  37.634  1.00 35.30          
ATOM    137  OG  SER    24       5.598  -7.333  36.691  1.00 39.93          
ATOM    138  N   ILE    25       7.237  -9.584  40.089  1.00 33.62          
ATOM    139  CA  ILE    25       8.251 -10.244  40.876  1.00 33.95          
ATOM    140  C   ILE    25       7.850 -11.690  41.196  1.00 35.37          
ATOM    141  O   ILE    25       8.677 -12.608  41.097  1.00 35.34          
ATOM    142  CB  ILE    25       8.529  -9.434  42.163  1.00 32.96          
ATOM    143  CG1 ILE    25       9.066  -8.055  41.768  1.00 30.36          
ATOM    144  CG2 ILE    25       9.512 -10.154  43.053  1.00 31.35          
ATOM    145  CD  ILE    25       9.495  -7.203  42.916  1.00 28.44          
ATOM    146  N   GLU    26       6.586 -11.909  41.554  1.00 36.42          
ATOM    147  CA  GLU    26       6.106 -13.262  41.869  1.00 38.00          
ATOM    148  C   GLU    26       6.267 -14.202  40.671  1.00 37.34          
ATOM    149  O   GLU    26       6.623 -15.369  40.836  1.00 37.59          
ATOM    150  CB  GLU    26       4.635 -13.220  42.317  1.00 39.45          
ATOM    151  CG  GLU    26       4.434 -12.560  43.690  1.00 44.45          
ATOM    152  CD  GLU    26       5.131 -13.307  44.839  1.00 47.76          
ATOM    153  OE1 GLU    26       4.635 -14.390  45.253  1.00 48.13          
ATOM    154  OE2 GLU    26       6.188 -12.815  45.322  1.00 48.16          
ATOM    155  N   VAL    27       6.001 -13.683  39.473  1.00 36.34          
ATOM    156  CA  VAL    27       6.141 -14.460  38.248  1.00 34.75          
ATOM    157  C   VAL    27       7.627 -14.683  37.994  1.00 35.06          
ATOM    158  O   VAL    27       8.044 -15.752  37.567  1.00 34.96          
ATOM    159  CB  VAL    27       5.549 -13.714  37.055  1.00 31.86          
ATOM    160  CG1 VAL    27       5.834 -14.462  35.783  1.00 29.36          
ATOM    161  CG2 VAL    27       4.072 -13.543  37.255  1.00 31.53          
ATOM    162  N   ALA    28       8.419 -13.657  38.275  1.00 35.66          
ATOM    163  CA  ALA    28       9.849 -13.720  38.085  1.00 36.34          
ATOM    164  C   ALA    28      10.465 -14.753  39.009  1.00 38.34          
ATOM    165  O   ALA    28      11.452 -15.406  38.660  1.00 39.44          
ATOM    166  CB  ALA    28      10.464 -12.368  38.340  1.00 36.23          
ATOM    167  N   LYS    29       9.889 -14.910  40.194  1.00 39.77          
ATOM    168  CA  LYS    29      10.408 -15.880  41.146  1.00 40.39          
ATOM    169  C   LYS    29       9.949 -17.299  40.859  1.00 40.52          
ATOM    170  O   LYS    29      10.622 -18.239  41.252  1.00 41.59          
ATOM    171  CB  LYS    29      10.006 -15.511  42.574  1.00 40.53          
ATOM    172  CG  LYS    29      10.744 -14.316  43.150  1.00 41.23          
ATOM    173  CD  LYS    29      10.663 -14.309  44.681  1.00 44.42          
ATOM    174  CE  LYS    29       9.211 -14.279  45.195  1.00 44.59          
ATOM    175  NZ  LYS    29       9.113 -14.333  46.690  1.00 43.59          
ATOM    176  N   LYS    30       8.816 -17.465  40.186  1.00 40.21          
ATOM    177  CA  LYS    30       8.337 -18.806  39.901  1.00 41.59          
ATOM    178  C   LYS    30       8.884 -19.327  38.571  1.00 43.51          
ATOM    179  O   LYS    30       8.861 -20.529  38.327  1.00 43.62          
ATOM    180  CB  LYS    30       6.801 -18.834  39.902  1.00 42.72          
ATOM    181  CG  LYS    30       6.171 -20.223  39.924  1.00 43.38          
ATOM    182  CD  LYS    30       4.653 -20.122  39.904  1.00 45.84          
ATOM    183  CE  LYS    30       3.983 -21.471  40.139  1.00 47.92          
ATOM    184  NZ  LYS    30       2.499 -21.323  40.293  1.00 50.92          
ATOM    185  N   PHE    31       9.388 -18.430  37.721  1.00 44.17          
ATOM    186  CA  PHE    31       9.940 -18.814  36.419  1.00 44.51          
ATOM    187  C   PHE    31      11.289 -18.170  36.195  1.00 45.33          
ATOM    188  O   PHE    31      11.634 -17.818  35.068  1.00 45.02          
ATOM    189  CB  PHE    31       8.991 -18.398  35.307  1.00 44.39          
ATOM    190  CG  PHE    31       7.643 -19.013  35.427  1.00 45.82          
ATOM    191  CD1 PHE    31       7.406 -20.293  34.943  1.00 47.34          
ATOM    192  CD2 PHE    31       6.620 -18.344  36.087  1.00 46.46          
ATOM    193  CE1 PHE    31       6.160 -20.904  35.118  1.00 48.67          
ATOM    194  CE2 PHE    31       5.371 -18.940  36.271  1.00 47.96          
ATOM    195  CZ  PHE    31       5.137 -20.224  35.787  1.00 48.48          
ATOM    196  N   ASN    32      12.050 -18.044  37.282  1.00 47.84          
ATOM    197  CA  ASN    32      13.382 -17.419  37.295  1.00 49.84          
ATOM    198  C   ASN    32      13.603 -16.505  36.095  1.00 49.50          
ATOM    199  O   ASN    32      14.394 -16.794  35.191  1.00 50.98          
ATOM    200  CB  ASN    32      14.500 -18.479  37.383  1.00 51.79          
ATOM    201  CG  ASN    32      14.698 -19.234  36.078  1.00 54.42          
ATOM    202  OD1 ASN    32      13.726 -19.668  35.450  1.00 56.40          
ATOM    203  ND2 ASN    32      15.954 -19.411  35.670  1.00 55.03          
ATOM    204  N   GLY    33      12.871 -15.398  36.096  1.00 47.07          
ATOM    205  CA  GLY    33      12.994 -14.433  35.027  1.00 44.42          
ATOM    206  C   GLY    33      13.567 -13.138  35.566  1.00 42.58          
ATOM    207  O   GLY    33      13.970 -13.059  36.725  1.00 41.73          
ATOM    208  N   GLU    34      13.620 -12.124  34.711  1.00 41.54          
ATOM    209  CA  GLU    34      14.122 -10.821  35.099  1.00 39.53          
ATOM    210  C   GLU    34      13.166  -9.801  34.512  1.00 38.04          
ATOM    211  O   GLU    34      12.592 -10.005  33.440  1.00 36.36          
ATOM    212  CB  GLU    34      15.537 -10.613  34.582  1.00 39.38          
ATOM    213  CG  GLU    34      16.453 -11.766  34.939  1.00 40.36          
ATOM    214  CD  GLU    34      17.877 -11.540  34.490  1.00 41.95          
ATOM    215  OE1 GLU    34      18.066 -10.907  33.422  1.00 43.40          
ATOM    216  OE2 GLU    34      18.814 -12.009  35.185  1.00 40.07          
ATOM    217  N   ILE    35      13.008  -8.695  35.222  1.00 37.64          
ATOM    218  CA  ILE    35      12.066  -7.665  34.828  1.00 37.78          
ATOM    219  C   ILE    35      12.679  -6.440  34.183  1.00 37.21          
ATOM    220  O   ILE    35      13.723  -5.963  34.602  1.00 37.93          
ATOM    221  CB  ILE    35      11.252  -7.203  36.064  1.00 37.03          
ATOM    222  CG1 ILE    35      10.621  -8.415  36.738  1.00 36.19          
ATOM    223  CG2 ILE    35      10.186  -6.211  35.656  1.00 37.14          
ATOM    224  CD  ILE    35       9.858  -8.090  37.952  1.00 35.95          
ATOM    225  N   ILE    36      12.003  -5.926  33.166  1.00 37.04          
ATOM    226  CA  ILE    36      12.438  -4.716  32.496  1.00 36.12          
ATOM    227  C   ILE    36      11.354  -3.669  32.787  1.00 37.69          
ATOM    228  O   ILE    36      10.207  -3.833  32.380  1.00 38.12          
ATOM    229  CB  ILE    36      12.548  -4.928  30.981  1.00 33.73          
ATOM    230  CG1 ILE    36      13.667  -5.921  30.678  1.00 31.77          
ATOM    231  CG2 ILE    36      12.795  -3.610  30.292  1.00 31.97          
ATOM    232  CD  ILE    36      13.730  -6.342  29.233  1.00 26.96          
ATOM    233  N   SER    37      11.709  -2.610  33.506  1.00 37.83          
ATOM    234  CA  SER    37      10.744  -1.571  33.829  1.00 37.74          
ATOM    235  C   SER    37      10.202  -0.918  32.553  1.00 37.95          
ATOM    236  O   SER    37      10.969  -0.487  31.692  1.00 37.35          
ATOM    237  CB  SER    37      11.403  -0.535  34.740  1.00 36.72          
ATOM    238  OG  SER    37      10.688   0.680  34.738  1.00 36.77          
ATOM    239  N   GLY    38       8.874  -0.871  32.426  1.00 38.61          
ATOM    240  CA  GLY    38       8.253  -0.268  31.252  1.00 39.20          
ATOM    241  C   GLY    38       7.872   1.183  31.485  1.00 41.13          
ATOM    242  O   GLY    38       7.455   1.899  30.565  1.00 39.58          
ATOM    243  N   ASP    39       8.020   1.615  32.734  1.00 42.10          
ATOM    244  CA  ASP    39       7.694   2.977  33.129  1.00 44.59          
ATOM    245  C   ASP    39       8.674   3.991  32.530  1.00 45.44          
ATOM    246  O   ASP    39       9.884   3.849  32.665  1.00 46.29          
ATOM    247  CB  ASP    39       7.719   3.090  34.648  1.00 46.64          
ATOM    248  CG  ASP    39       7.028   4.342  35.149  1.00 49.62          
ATOM    249  OD1 ASP    39       7.453   5.452  34.775  1.00 51.11          
ATOM    250  OD2 ASP    39       6.046   4.214  35.915  1.00 52.78          
ATOM    251  N   SER    40       8.149   5.028  31.890  1.00 45.73          
ATOM    252  CA  SER    40       9.007   6.038  31.286  1.00 46.96          
ATOM    253  C   SER    40       9.523   7.073  32.276  1.00 47.74          
ATOM    254  O   SER    40      10.194   8.033  31.886  1.00 47.33          
ATOM    255  CB  SER    40       8.276   6.763  30.142  1.00 46.76          
ATOM    256  OG  SER    40       7.151   7.504  30.591  1.00 44.02          
ATOM    257  N   MET    41       9.212   6.894  33.554  1.00 49.05          
ATOM    258  CA  MET    41       9.645   7.852  34.575  1.00 50.21          
ATOM    259  C   MET    41      10.623   7.277  35.575  1.00 48.79          
ATOM    260  O   MET    41      11.443   7.998  36.156  1.00 48.16          
ATOM    261  CB  MET    41       8.430   8.401  35.322  1.00 54.92          
ATOM    262  CG  MET    41       7.630   9.422  34.534  1.00 60.15          
ATOM    263  SD  MET    41       8.726  10.939  33.973  1.00 69.60          
ATOM    264  CE  MET    41       9.133  11.711  35.709  1.00 65.89          
ATOM    265  N   GLN    42      10.521   5.967  35.778  1.00 47.21          
ATOM    266  CA  GLN    42      11.387   5.258  36.710  1.00 44.79          
ATOM    267  C   GLN    42      12.805   5.173  36.162  1.00 43.38          
ATOM    268  O   GLN    42      13.702   4.659  36.822  1.00 42.91          
ATOM    269  CB  GLN    42      10.808   3.867  36.988  1.00 44.81          
ATOM    270  CG  GLN    42       9.722   3.895  38.074  1.00 45.40          
ATOM    271  CD  GLN    42       9.045   2.552  38.305  1.00 46.04          
ATOM    272  OE1 GLN    42       9.697   1.498  38.352  1.00 47.48          
ATOM    273  NE2 GLN    42       7.731   2.587  38.483  1.00 45.63          
ATOM    274  N   VAL    43      13.002   5.709  34.960  1.00 41.63          
ATOM    275  CA  VAL    43      14.308   5.709  34.338  1.00 39.69          
ATOM    276  C   VAL    43      15.179   6.815  34.916  1.00 39.24          
ATOM    277  O   VAL    43      16.398   6.742  34.848  1.00 39.12          
ATOM    278  CB  VAL    43      14.194   5.913  32.814  1.00 40.00          
ATOM    279  CG1 VAL    43      13.727   4.629  32.143  1.00 39.83          
ATOM    280  CG2 VAL    43      13.216   7.035  32.519  1.00 37.24          
ATOM    281  N   TYR    44      14.547   7.831  35.496  1.00 39.65          
ATOM    282  CA  TYR    44      15.278   8.961  36.069  1.00 40.32          
ATOM    283  C   TYR    44      15.685   8.755  37.538  1.00 42.44          
ATOM    284  O   TYR    44      14.876   8.359  38.372  1.00 42.07          
ATOM    285  CB  TYR    44      14.450  10.236  35.952  1.00 39.33          
ATOM    286  CG  TYR    44      14.102  10.623  34.536  1.00 40.85          
ATOM    287  CD1 TYR    44      15.075  11.124  33.664  1.00 40.75          
ATOM    288  CD2 TYR    44      12.798  10.482  34.059  1.00 40.46          
ATOM    289  CE1 TYR    44      14.750  11.471  32.350  1.00 41.84          
ATOM    290  CE2 TYR    44      12.467  10.829  32.753  1.00 41.49          
ATOM    291  CZ  TYR    44      13.437  11.319  31.901  1.00 42.05          
ATOM    292  OH  TYR    44      13.093  11.647  30.599  1.00 42.46          
ATOM    293  N   GLN    45      16.945   9.042  37.847  1.00 43.92          
ATOM    294  CA  GLN    45      17.452   8.884  39.196  1.00 46.34          
ATOM    295  C   GLN    45      17.102  10.118  40.029  1.00 47.78          
ATOM    296  O   GLN    45      17.187  11.249  39.548  1.00 47.56          
ATOM    297  CB  GLN    45      18.965   8.648  39.145  1.00 47.12          
ATOM    298  CG  GLN    45      19.690   9.695  38.307  1.00 50.07          
ATOM    299  CD  GLN    45      20.942   9.167  37.622  1.00 50.58          
ATOM    300  OE1 GLN    45      20.898   8.142  36.937  1.00 50.72          
ATOM    301  NE2 GLN    45      22.057   9.879  37.783  1.00 49.70          
ATOM    302  N   GLY    46      16.685   9.896  41.274  1.00 48.21          
ATOM    303  CA  GLY    46      16.318  11.011  42.135  1.00 49.37          
ATOM    304  C   GLY    46      14.813  11.171  42.212  1.00 50.77          
ATOM    305  O   GLY    46      14.273  11.756  43.159  1.00 49.20          
ATOM    306  N   MET    47      14.137  10.648  41.193  1.00 52.76          
ATOM    307  CA  MET    47      12.685  10.704  41.117  1.00 54.61          
ATOM    308  C   MET    47      12.150   9.309  41.425  1.00 53.36          
ATOM    309  O   MET    47      11.777   8.565  40.523  1.00 53.21          
ATOM    310  CB  MET    47      12.261  11.145  39.723  1.00 56.82          
ATOM    311  CG  MET    47      13.015  12.367  39.261  1.00 61.64          
ATOM    312  SD  MET    47      12.390  13.007  37.567  1.00 70.25          
ATOM    313  CE  MET    47      11.239  14.436  38.153  1.00 69.01          
ATOM    314  N   ASP    48      12.109   8.969  42.713  1.00 52.63          
ATOM    315  CA  ASP    48      11.651   7.657  43.149  1.00 51.41          
ATOM    316  C   ASP    48      10.236   7.640  43.742  1.00 49.19          
ATOM    317  O   ASP    48       9.437   6.753  43.438  1.00 48.61          
ATOM    318  CB  ASP    48      12.644   7.074  44.166  1.00 52.25          
ATOM    319  CG  ASP    48      14.094   7.486  43.887  1.00 52.83          
ATOM    320  OD1 ASP    48      14.559   7.391  42.724  1.00 52.86          
ATOM    321  OD2 ASP    48      14.782   7.901  44.845  1.00 52.66          
ATOM    322  N   ILE    49       9.924   8.620  44.578  1.00 46.94          
ATOM    323  CA  ILE    49       8.617   8.680  45.210  1.00 45.38          
ATOM    324  C   ILE    49       7.471   9.008  44.261  1.00 43.66          
ATOM    325  O   ILE    49       6.463   8.309  44.243  1.00 43.49          
ATOM    326  CB  ILE    49       8.618   9.712  46.353  1.00 45.88          
ATOM    327  CG1 ILE    49       9.599   9.276  47.434  1.00 44.79          
ATOM    328  CG2 ILE    49       7.206   9.873  46.912  1.00 46.48          
ATOM    329  CD  ILE    49       9.745  10.265  48.557  1.00 47.30          
ATOM    330  N   GLY    50       7.617  10.070  43.479  1.00 42.05          
ATOM    331  CA  GLY    50       6.546  10.454  42.569  1.00 41.84          
ATOM    332  C   GLY    50       6.304   9.495  41.416  1.00 39.86          
ATOM    333  O   GLY    50       5.323   9.614  40.685  1.00 38.30          
ATOM    334  N   THR    51       7.185   8.522  41.268  1.00 38.59          
ATOM    335  CA  THR    51       7.065   7.593  40.177  1.00 39.16          
ATOM    336  C   THR    51       6.732   6.186  40.632  1.00 39.81          
ATOM    337  O   THR    51       6.650   5.269  39.811  1.00 40.79          
ATOM    338  CB  THR    51       8.364   7.555  39.405  1.00 39.85          
ATOM    339  OG1 THR    51       9.419   7.139  40.288  1.00 39.12          
ATOM    340  CG2 THR    51       8.684   8.950  38.852  1.00 39.88          
ATOM    341  N   ALA    52       6.545   6.017  41.939  1.00 39.14          
ATOM    342  CA  ALA    52       6.226   4.717  42.538  1.00 37.57          
ATOM    343  C   ALA    52       7.338   3.724  42.226  1.00 38.14          
ATOM    344  O   ALA    52       7.094   2.532  42.036  1.00 37.54          
ATOM    345  CB  ALA    52       4.886   4.200  42.022  1.00 35.81          
ATOM    346  N   LYS    53       8.565   4.235  42.181  1.00 40.06          
ATOM    347  CA  LYS    53       9.741   3.420  41.888  1.00 42.16          
ATOM    348  C   LYS    53       9.989   2.345  42.939  1.00 42.20          
ATOM    349  O   LYS    53      10.161   2.651  44.121  1.00 42.30          
ATOM    350  CB  LYS    53      10.978   4.311  41.782  1.00 42.37          
ATOM    351  CG  LYS    53      12.272   3.549  41.536  1.00 42.48          
ATOM    352  CD  LYS    53      13.408   4.512  41.341  1.00 41.69          
ATOM    353  CE  LYS    53      13.132   5.409  40.152  1.00 42.68          
ATOM    354  NZ  LYS    53      14.081   6.557  40.102  1.00 44.19          
ATOM    355  N   VAL    54      10.027   1.089  42.498  1.00 42.43          
ATOM    356  CA  VAL    54      10.262  -0.040  43.395  1.00 42.54          
ATOM    357  C   VAL    54      11.678  -0.002  43.960  1.00 42.74          
ATOM    358  O   VAL    54      12.640   0.289  43.238  1.00 42.21          
ATOM    359  CB  VAL    54      10.024  -1.382  42.660  1.00 43.26          
ATOM    360  CG1 VAL    54      10.765  -1.401  41.325  1.00 43.42          
ATOM    361  CG2 VAL    54      10.471  -2.525  43.538  1.00 44.75          
ATOM    362  N   THR    55      11.810  -0.291  45.250  1.00 41.88          
ATOM    363  CA  THR    55      13.120  -0.254  45.891  1.00 42.17          
ATOM    364  C   THR    55      13.915  -1.537  45.748  1.00 40.91          
ATOM    365  O   THR    55      13.357  -2.611  45.534  1.00 37.85          
ATOM    366  CB  THR    55      12.999   0.093  47.397  1.00 42.92          
ATOM    367  OG1 THR    55      12.447  -1.019  48.126  1.00 45.00          
ATOM    368  CG2 THR    55      12.105   1.306  47.580  1.00 44.24          
ATOM    369  N   THR    56      15.233  -1.406  45.856  1.00 42.43          
ATOM    370  CA  THR    56      16.114  -2.557  45.731  1.00 44.85          
ATOM    371  C   THR    56      15.630  -3.688  46.640  1.00 45.98          
ATOM    372  O   THR    56      15.676  -4.852  46.262  1.00 46.23          
ATOM    373  CB  THR    56      17.581  -2.218  46.109  1.00 44.96          
ATOM    374  OG1 THR    56      17.663  -1.947  47.513  1.00 47.28          
ATOM    375  CG2 THR    56      18.067  -0.995  45.350  1.00 46.18          
ATOM    376  N   GLU    57      15.143  -3.343  47.828  1.00 47.39          
ATOM    377  CA  GLU    57      14.674  -4.344  48.773  1.00 47.62          
ATOM    378  C   GLU    57      13.441  -5.053  48.306  1.00 47.71          
ATOM    379  O   GLU    57      13.327  -6.260  48.438  1.00 48.16          
ATOM    380  CB  GLU    57      14.361  -3.712  50.117  1.00 49.17          
ATOM    381  CG  GLU    57      13.931  -4.714  51.180  1.00 50.98          
ATOM    382  CD  GLU    57      13.395  -4.031  52.437  1.00 52.75          
ATOM    383  OE1 GLU    57      13.203  -4.714  53.468  1.00 53.26          
ATOM    384  OE2 GLU    57      13.154  -2.807  52.382  1.00 54.01          
ATOM    385  N   GLU    58      12.502  -4.291  47.779  1.00 48.34          
ATOM    386  CA  GLU    58      11.257  -4.857  47.314  1.00 50.36          
ATOM    387  C   GLU    58      11.435  -5.758  46.103  1.00 51.67          
ATOM    388  O   GLU    58      10.605  -6.627  45.843  1.00 51.05          
ATOM    389  CB  GLU    58      10.276  -3.730  47.011  1.00 51.70          
ATOM    390  CG  GLU    58      10.044  -2.804  48.205  1.00 54.05          
ATOM    391  CD  GLU    58       9.059  -1.690  47.897  1.00 54.95          
ATOM    392  OE1 GLU    58       9.289  -0.952  46.911  1.00 53.56          
ATOM    393  OE2 GLU    58       8.062  -1.554  48.646  1.00 56.23          
ATOM    394  N   MET    59      12.522  -5.561  45.366  1.00 53.00          
ATOM    395  CA  MET    59      12.804  -6.374  44.179  1.00 54.52          
ATOM    396  C   MET    59      13.089  -7.828  44.530  1.00 54.25          
ATOM    397  O   MET    59      13.251  -8.662  43.641  1.00 54.07          
ATOM    398  CB  MET    59      14.009  -5.814  43.428  1.00 57.77          
ATOM    399  CG  MET    59      13.794  -4.457  42.799  1.00 62.25          
ATOM    400  SD  MET    59      15.363  -3.879  41.807  1.00 70.44          
ATOM    401  CE  MET    59      15.371  -1.998  42.290  1.00 67.49          
ATOM    402  N   GLU    60      13.163  -8.110  45.831  1.00 53.56          
ATOM    403  CA  GLU    60      13.433  -9.453  46.352  1.00 52.64          
ATOM    404  C   GLU    60      14.481 -10.251  45.585  1.00 50.43          
ATOM    405  O   GLU    60      14.318 -11.450  45.392  1.00 51.35          
ATOM    406  CB  GLU    60      12.135 -10.261  46.420  1.00 53.57          
ATOM    407  CG  GLU    60      11.354 -10.074  47.708  1.00 56.49          
ATOM    408  CD  GLU    60       9.894 -10.467  47.562  1.00 59.54          
ATOM    409  OE1 GLU    60       9.610 -11.476  46.869  1.00 60.10          
ATOM    410  OE2 GLU    60       9.029  -9.774  48.151  1.00 60.23          
ATOM    411  N   GLY    61      15.554  -9.601  45.154  1.00 48.05          
ATOM    412  CA  GLY    61      16.582 -10.330  44.443  1.00 46.22          
ATOM    413  C   GLY    61      16.423 -10.307  42.939  1.00 45.02          
ATOM    414  O   GLY    61      17.412 -10.296  42.208  1.00 46.21          
ATOM    415  N   ILE    62      15.189 -10.308  42.455  1.00 43.60          
ATOM    416  CA  ILE    62      14.969 -10.276  41.019  1.00 41.23          
ATOM    417  C   ILE    62      15.599  -9.022  40.419  1.00 40.65          
ATOM    418  O   ILE    62      15.292  -7.905  40.821  1.00 41.62          
ATOM    419  CB  ILE    62      13.479 -10.248  40.689  1.00 40.73          
ATOM    420  CG1 ILE    62      12.776 -11.464  41.306  1.00 38.20          
ATOM    421  CG2 ILE    62      13.306 -10.157  39.179  1.00 41.74          
ATOM    422  CD  ILE    62      13.258 -12.789  40.784  1.00 36.15          
ATOM    423  N   PRO    63      16.491  -9.190  39.442  1.00 40.13          
ATOM    424  CA  PRO    63      17.144  -8.041  38.805  1.00 40.32          
ATOM    425  C   PRO    63      16.221  -7.197  37.917  1.00 39.75          
ATOM    426  O   PRO    63      15.509  -7.736  37.073  1.00 39.18          
ATOM    427  CB  PRO    63      18.277  -8.694  38.008  1.00 40.21          
ATOM    428  CG  PRO    63      17.715 -10.036  37.661  1.00 39.66          
ATOM    429  CD  PRO    63      17.070 -10.455  38.959  1.00 40.22          
ATOM    430  N   HSD    64      16.235  -5.877  38.115  1.00 39.80          
ATOM    431  CA  HSD    64      15.404  -4.971  37.322  1.00 40.76          
ATOM    432  C   HSD    64      16.240  -4.041  36.409  1.00 42.95          
ATOM    433  O   HSD    64      17.318  -3.576  36.786  1.00 41.97          
ATOM    434  CB  HSD    64      14.493  -4.123  38.232  1.00 37.92          
ATOM    435  CG  HSD    64      13.430  -4.905  38.944  1.00 36.17          
ATOM    436  ND1 HSD    64      12.239  -4.340  39.346  1.00 36.89          
ATOM    437  CD2 HSD    64      13.383  -6.196  39.354  1.00 35.64          
ATOM    438  CE1 HSD    64      11.505  -5.244  39.969  1.00 35.10          
ATOM    439  NE2 HSD    64      12.177  -6.380  39.986  1.00 33.58          
ATOM    440  N   TYR    65      15.734  -3.786  35.201  1.00 44.46          
ATOM    441  CA  TYR    65      16.416  -2.924  34.246  1.00 46.92          
ATOM    442  C   TYR    65      15.558  -1.722  33.913  1.00 48.79          
ATOM    443  O   TYR    65      14.356  -1.716  34.197  1.00 48.51          
ATOM    444  CB  TYR    65      16.734  -3.679  32.956  1.00 46.24          
ATOM    445  CG  TYR    65      17.495  -4.956  33.189  1.00 46.04          
ATOM    446  CD1 TYR    65      16.839  -6.181  33.203  1.00 45.12          
ATOM    447  CD2 TYR    65      18.876  -4.940  33.421  1.00 46.83          
ATOM    448  CE1 TYR    65      17.538  -7.365  33.439  1.00 45.27          
ATOM    449  CE2 TYR    65      19.587  -6.118  33.664  1.00 44.91          
ATOM    450  CZ  TYR    65      18.915  -7.324  33.666  1.00 44.46          
ATOM    451  OH  TYR    65      19.618  -8.485  33.861  1.00 42.99          
ATOM    452  N   MET    66      16.180  -0.709  33.310  1.00 50.14          
ATOM    453  CA  MET    66      15.474   0.511  32.938  1.00 52.49          
ATOM    454  C   MET    66      15.065   1.366  34.144  1.00 51.53          
ATOM    455  O   MET    66      14.097   2.124  34.068  1.00 50.60          
ATOM    456  CB  MET    66      14.225   0.152  32.137  1.00 57.56          
ATOM    457  CG  MET    66      14.507  -0.541  30.808  1.00 65.45          
ATOM    458  SD  MET    66      15.334   0.620  29.477  1.00 71.33          
ATOM    459  CE  MET    66      13.820   1.809  29.184  1.00 69.78          
ATOM    460  N   ILE    67      15.790   1.237  35.256  1.00 50.85          
ATOM    461  CA  ILE    67      15.494   2.005  36.472  1.00 49.39          
ATOM    462  C   ILE    67      16.742   2.762  36.944  1.00 48.87          
ATOM    463  O   ILE    67      17.774   2.150  37.219  1.00 49.58          
ATOM    464  CB  ILE    67      14.973   1.076  37.606  1.00 48.43          
ATOM    465  CG1 ILE    67      13.742   0.313  37.121  1.00 47.01          
ATOM    466  CG2 ILE    67      14.617   1.897  38.840  1.00 47.68          
ATOM    467  CD  ILE    67      13.258  -0.716  38.065  1.00 46.08          
ATOM    468  N   ASP    68      16.639   4.090  37.028  1.00 47.81          
ATOM    469  CA  ASP    68      17.760   4.942  37.434  1.00 47.06          
ATOM    470  C   ASP    68      18.911   4.812  36.444  1.00 46.44          
ATOM    471  O   ASP    68      20.064   4.604  36.838  1.00 46.29          
ATOM    472  CB  ASP    68      18.277   4.568  38.826  1.00 48.04          
ATOM    473  CG  ASP    68      17.305   4.924  39.929  1.00 49.01          
ATOM    474  OD1 ASP    68      16.806   6.072  39.939  1.00 51.42          
ATOM    475  OD2 ASP    68      17.052   4.068  40.799  1.00 48.86          
ATOM    476  N   ILE    69      18.599   4.922  35.158  1.00 44.44          
ATOM    477  CA  ILE    69      19.616   4.812  34.129  1.00 42.98          
ATOM    478  C   ILE    69      19.953   6.161  33.496  1.00 42.60          
ATOM    479  O   ILE    69      20.851   6.252  32.664  1.00 42.00          
ATOM    480  CB  ILE    69      19.170   3.854  33.018  1.00 43.70          
ATOM    481  CG1 ILE    69      17.845   4.328  32.414  1.00 43.50          
ATOM    482  CG2 ILE    69      19.052   2.449  33.565  1.00 44.67          
ATOM    483  CD  ILE    69      17.404   3.536  31.203  1.00 42.90          
ATOM    484  N   LEU    70      19.245   7.212  33.902  1.00 42.59          
ATOM    485  CA  LEU    70      19.486   8.549  33.359  1.00 40.82          
ATOM    486  C   LEU    70      19.250   9.633  34.407  1.00 41.05          
ATOM    487  O   LEU    70      18.577   9.405  35.398  1.00 41.88          
ATOM    488  CB  LEU    70      18.548   8.791  32.171  1.00 39.27          
ATOM    489  CG  LEU    70      18.589   7.800  31.020  1.00 36.21          
ATOM    490  CD1 LEU    70      17.340   7.949  30.200  1.00 36.04          
ATOM    491  CD2 LEU    70      19.824   8.038  30.194  1.00 34.44          
ATOM    492  N   PRO    71      19.835  10.825  34.214  1.00 43.24          
ATOM    493  CA  PRO    71      19.650  11.934  35.154  1.00 41.06          
ATOM    494  C   PRO    71      18.362  12.638  34.725  1.00 42.77          
ATOM    495  O   PRO    71      17.904  12.457  33.605  1.00 42.17          
ATOM    496  CB  PRO    71      20.879  12.792  34.919  1.00 42.02          
ATOM    497  CG  PRO    71      21.065  12.653  33.448  1.00 41.82          
ATOM    498  CD  PRO    71      20.887  11.154  33.242  1.00 42.37          
ATOM    499  N   PRO    72      17.770  13.460  35.603  1.00 46.11          
ATOM    500  CA  PRO    72      16.522  14.173  35.299  1.00 45.97          
ATOM    501  C   PRO    72      16.497  14.962  33.990  1.00 48.27          
ATOM    502  O   PRO    72      15.500  14.933  33.254  1.00 49.06          
ATOM    503  CB  PRO    72      16.327  15.057  36.521  1.00 45.64          
ATOM    504  CG  PRO    72      16.892  14.201  37.619  1.00 45.86          
ATOM    505  CD  PRO    72      18.180  13.706  36.995  1.00 45.76          
ATOM    506  N   ASP    73      17.593  15.659  33.693  1.00 50.27          
ATOM    507  CA  ASP    73      17.710  16.484  32.476  1.00 50.11          
ATOM    508  C   ASP    73      17.880  15.666  31.197  1.00 50.04          
ATOM    509  O   ASP    73      17.918  16.220  30.087  1.00 51.02          
ATOM    510  CB  ASP    73      18.889  17.460  32.625  1.00 52.01          
ATOM    511  CG  ASP    73      20.224  16.746  32.837  1.00 54.57          
ATOM    512  OD1 ASP    73      20.667  16.017  31.911  1.00 55.67          
ATOM    513  OD2 ASP    73      20.834  16.922  33.921  1.00 53.87          
ATOM    514  N   ALA    74      17.997  14.350  31.356  1.00 48.21          
ATOM    515  CA  ALA    74      18.159  13.464  30.210  1.00 45.93          
ATOM    516  C   ALA    74      16.842  13.337  29.472  1.00 44.07          
ATOM    517  O   ALA    74      15.780  13.627  30.015  1.00 41.10          
ATOM    518  CB  ALA    74      18.645  12.094  30.668  1.00 46.53          
ATOM    519  N   SER    75      16.921  12.893  28.229  1.00 44.15          
ATOM    520  CA  SER    75      15.727  12.747  27.425  1.00 44.33          
ATOM    521  C   SER    75      15.354  11.285  27.232  1.00 42.90          
ATOM    522  O   SER    75      16.217  10.409  27.187  1.00 42.46          
ATOM    523  CB  SER    75      15.932  13.425  26.073  1.00 45.22          
ATOM    524  OG  SER    75      14.852  13.131  25.206  1.00 48.08          
ATOM    525  N   PHE    76      14.058  11.028  27.128  1.00 42.25          
ATOM    526  CA  PHE    76      13.589   9.677  26.939  1.00 42.63          
ATOM    527  C   PHE    76      12.435   9.680  25.950  1.00 44.28          
ATOM    528  O   PHE    76      11.843  10.731  25.681  1.00 44.93          
ATOM    529  CB  PHE    76      13.158   9.080  28.272  1.00 41.10          
ATOM    530  CG  PHE    76      13.230   7.592  28.304  1.00 40.73          
ATOM    531  CD1 PHE    76      14.438   6.943  28.082  1.00 40.57          
ATOM    532  CD2 PHE    76      12.091   6.830  28.513  1.00 40.81          
ATOM    533  CE1 PHE    76      14.515   5.548  28.069  1.00 40.33          
ATOM    534  CE2 PHE    76      12.157   5.431  28.503  1.00 40.80          
ATOM    535  CZ  PHE    76      13.375   4.793  28.276  1.00 39.45          
ATOM    536  N   SER    77      12.112   8.506  25.413  1.00 44.42          
ATOM    537  CA  SER    77      11.050   8.409  24.423  1.00 44.38          
ATOM    538  C   SER    77      10.626   6.972  24.168  1.00 44.19          
ATOM    539  O   SER    77      11.321   6.029  24.532  1.00 43.90          
ATOM    540  CB  SER    77      11.537   8.990  23.107  1.00 45.47          
ATOM    541  OG  SER    77      12.572   8.162  22.578  1.00 47.33          
ATOM    542  N   ALA    78       9.481   6.813  23.521  1.00 42.68          
ATOM    543  CA  ALA    78       8.996   5.488  23.212  1.00 42.21          
ATOM    544  C   ALA    78      10.066   4.637  22.487  1.00 43.10          
ATOM    545  O   ALA    78      10.303   3.504  22.882  1.00 42.31          
ATOM    546  CB  ALA    78       7.714   5.577  22.377  1.00 41.89          
ATOM    547  N   TYR    79      10.724   5.159  21.448  1.00 44.68          
ATOM    548  CA  TYR    79      11.728   4.350  20.756  1.00 46.27          
ATOM    549  C   TYR    79      12.962   4.134  21.609  1.00 44.55          
ATOM    550  O   TYR    79      13.531   3.041  21.616  1.00 43.90          
ATOM    551  CB  TYR    79      12.148   4.962  19.403  1.00 52.71          
ATOM    552  CG  TYR    79      13.289   4.209  18.700  1.00 58.76          
ATOM    553  CD1 TYR    79      14.585   4.755  18.646  1.00 61.33          
ATOM    554  CD2 TYR    79      13.085   2.935  18.131  1.00 60.40          
ATOM    555  CE1 TYR    79      15.655   4.053  18.050  1.00 63.02          
ATOM    556  CE2 TYR    79      14.152   2.218  17.531  1.00 62.10          
ATOM    557  CZ  TYR    79      15.431   2.784  17.497  1.00 63.41          
ATOM    558  OH  TYR    79      16.489   2.099  16.917  1.00 62.92          
ATOM    559  N   GLU    80      13.384   5.165  22.327  1.00 42.75          
ATOM    560  CA  GLU    80      14.558   5.030  23.179  1.00 41.93          
ATOM    561  C   GLU    80      14.369   3.772  24.037  1.00 40.72          
ATOM    562  O   GLU    80      15.285   2.960  24.174  1.00 41.10          
ATOM    563  CB  GLU    80      14.726   6.288  24.053  1.00 41.99          
ATOM    564  CG  GLU    80      15.937   6.271  24.984  1.00 43.40          
ATOM    565  CD  GLU    80      17.244   5.907  24.289  1.00 44.68          
ATOM    566  OE1 GLU    80      18.281   5.855  24.990  1.00 44.88          
ATOM    567  OE2 GLU    80      17.247   5.676  23.057  1.00 44.63          
ATOM    568  N   PHE    81      13.158   3.609  24.570  1.00 38.87          
ATOM    569  CA  PHE    81      12.781   2.465  25.407  1.00 36.19          
ATOM    570  C   PHE    81      12.849   1.170  24.596  1.00 36.54          
ATOM    571  O   PHE    81      13.312   0.137  25.086  1.00 35.85          
ATOM    572  CB  PHE    81      11.357   2.689  25.962  1.00 33.12          
ATOM    573  CG  PHE    81      10.681   1.435  26.465  1.00 30.51          
ATOM    574  CD1 PHE    81      11.210   0.717  27.524  1.00 29.09          
ATOM    575  CD2 PHE    81       9.528   0.957  25.850  1.00 30.08          
ATOM    576  CE1 PHE    81      10.613  -0.454  27.955  1.00 28.28          
ATOM    577  CE2 PHE    81       8.925  -0.218  26.280  1.00 28.60          
ATOM    578  CZ  PHE    81       9.470  -0.921  27.330  1.00 27.92          
ATOM    579  N   LYS    82      12.394   1.239  23.347  1.00 37.42          
ATOM    580  CA  LYS    82      12.392   0.079  22.453  1.00 38.62          
ATOM    581  C   LYS    82      13.807  -0.407  22.131  1.00 38.47          
ATOM    582  O   LYS    82      14.089  -1.606  22.162  1.00 36.19          
ATOM    583  CB  LYS    82      11.656   0.420  21.148  1.00 39.34          
ATOM    584  CG  LYS    82      11.549  -0.733  20.172  1.00 38.40          
ATOM    585  CD  LYS    82      10.907  -0.297  18.874  1.00 39.39          
ATOM    586  CE  LYS    82      10.964  -1.429  17.858  1.00 41.17          
ATOM    587  NZ  LYS    82       9.977  -1.274  16.742  1.00 42.70          
ATOM    588  N   LYS    83      14.690   0.535  21.822  1.00 39.75          
ATOM    589  CA  LYS    83      16.067   0.201  21.496  1.00 40.53          
ATOM    590  C   LYS    83      16.724  -0.543  22.648  1.00 40.76          
ATOM    591  O   LYS    83      17.320  -1.608  22.444  1.00 41.80          
ATOM    592  CB  LYS    83      16.863   1.470  21.177  1.00 40.74          
ATOM    593  CG  LYS    83      18.312   1.194  20.853  1.00 42.46          
ATOM    594  CD  LYS    83      19.071   2.446  20.455  1.00 45.99          
ATOM    595  CE  LYS    83      20.459   2.070  19.928  1.00 48.24          
ATOM    596  NZ  LYS    83      21.259   3.243  19.463  1.00 50.23          
ATOM    597  N   ARG    84      16.607   0.020  23.856  1.00 40.35          
ATOM    598  CA  ARG    84      17.190  -0.572  25.084  1.00 39.35          
ATOM    599  C   ARG    84      16.484  -1.854  25.530  1.00 37.92          
ATOM    600  O   ARG    84      17.133  -2.806  25.954  1.00 36.85          
ATOM    601  CB  ARG    84      17.156   0.429  26.250  1.00 36.67          
ATOM    602  CG  ARG    84      17.859   1.728  25.980  1.00 36.15          
ATOM    603  CD  ARG    84      18.054   2.528  27.259  1.00 38.44          
ATOM    604  NE  ARG    84      18.593   3.855  26.966  1.00 40.06          
ATOM    605  CZ  ARG    84      19.648   4.396  27.567  1.00 40.78          
ATOM    606  NH1 ARG    84      20.299   3.728  28.515  1.00 40.28          
ATOM    607  NH2 ARG    84      20.058   5.606  27.202  1.00 41.15          
ATOM    608  N   ALA    85      15.158  -1.862  25.438  1.00 37.30          
ATOM    609  CA  ALA    85      14.393  -3.027  25.822  1.00 38.07          
ATOM    610  C   ALA    85      14.677  -4.226  24.905  1.00 38.96          
ATOM    611  O   ALA    85      14.838  -5.338  25.393  1.00 38.84          
ATOM    612  CB  ALA    85      12.906  -2.698  25.837  1.00 37.62          
ATOM    613  N   GLU    86      14.755  -4.012  23.590  1.00 40.01          
ATOM    614  CA  GLU    86      15.020  -5.119  22.663  1.00 40.70          
ATOM    615  C   GLU    86      16.344  -5.794  22.966  1.00 39.19          
ATOM    616  O   GLU    86      16.460  -7.009  22.858  1.00 37.95          
ATOM    617  CB  GLU    86      15.035  -4.644  21.199  1.00 43.09          
ATOM    618  CG  GLU    86      13.732  -4.026  20.702  1.00 48.93          
ATOM    619  CD  GLU    86      13.759  -3.649  19.220  1.00 52.55          
ATOM    620  OE1 GLU    86      13.735  -4.566  18.368  1.00 56.38          
ATOM    621  OE2 GLU    86      13.814  -2.435  18.898  1.00 54.39          
ATOM    622  N   LYS    87      17.346  -5.012  23.343  1.00 38.58          
ATOM    623  CA  LYS    87      18.640  -5.592  23.648  1.00 38.74          
ATOM    624  C   LYS    87      18.535  -6.451  24.909  1.00 37.94          
ATOM    625  O   LYS    87      18.982  -7.593  24.913  1.00 37.92          
ATOM    626  CB  LYS    87      19.692  -4.489  23.821  1.00 40.10          
ATOM    627  CG  LYS    87      19.922  -3.647  22.563  1.00 40.60          
ATOM    628  CD  LYS    87      20.746  -2.395  22.866  1.00 42.69          
ATOM    629  CE  LYS    87      20.904  -1.490  21.628  1.00 42.87          
ATOM    630  NZ  LYS    87      21.492  -0.138  21.934  1.00 39.82          
ATOM    631  N   TYR    88      17.925  -5.910  25.962  1.00 36.95          
ATOM    632  CA  TYR    88      17.762  -6.644  27.214  1.00 37.15          
ATOM    633  C   TYR    88      16.916  -7.913  27.029  1.00 37.80          
ATOM    634  O   TYR    88      17.218  -8.973  27.580  1.00 37.94          
ATOM    635  CB  TYR    88      17.124  -5.756  28.295  1.00 37.25          
ATOM    636  CG  TYR    88      18.036  -4.700  28.910  1.00 39.23          
ATOM    637  CD1 TYR    88      17.783  -3.333  28.719  1.00 41.10          
ATOM    638  CD2 TYR    88      19.113  -5.059  29.734  1.00 38.28          
ATOM    639  CE1 TYR    88      18.568  -2.351  29.335  1.00 41.52          
ATOM    640  CE2 TYR    88      19.908  -4.081  30.358  1.00 38.86          
ATOM    641  CZ  TYR    88      19.626  -2.732  30.153  1.00 41.28          
ATOM    642  OH  TYR    88      20.390  -1.755  30.754  1.00 40.69          
ATOM    643  N   ILE    89      15.853  -7.815  26.250  1.00 37.05          
ATOM    644  CA  ILE    89      15.015  -8.973  26.022  1.00 36.98          
ATOM    645  C   ILE    89      15.820 -10.109  25.369  1.00 37.79          
ATOM    646  O   ILE    89      15.541 -11.282  25.617  1.00 37.75          
ATOM    647  CB  ILE    89      13.792  -8.608  25.139  1.00 35.57          
ATOM    648  CG1 ILE    89      12.904  -7.602  25.886  1.00 33.73          
ATOM    649  CG2 ILE    89      13.017  -9.859  24.777  1.00 33.51          
ATOM    650  CD  ILE    89      11.739  -7.066  25.077  1.00 30.08          
ATOM    651  N   LYS    90      16.806  -9.776  24.533  1.00 38.00          
ATOM    652  CA  LYS    90      17.631 -10.807  23.886  1.00 38.01          
ATOM    653  C   LYS    90      18.670 -11.334  24.868  1.00 38.13          
ATOM    654  O   LYS    90      18.861 -12.542  24.992  1.00 37.33          
ATOM    655  CB  LYS    90      18.349 -10.258  22.639  1.00 39.66          
ATOM    656  CG  LYS    90      17.608 -10.447  21.296  1.00 40.93          
ATOM    657  CD  LYS    90      18.408  -9.912  20.066  1.00 41.15          
ATOM    658  CE  LYS    90      18.564  -8.369  20.076  1.00 42.47          
ATOM    659  NZ  LYS    90      19.370  -7.772  18.962  1.00 39.46          
ATOM    660  N   ASP    91      19.342 -10.428  25.565  1.00 37.73          
ATOM    661  CA  ASP    91      20.350 -10.837  26.521  1.00 38.39          
ATOM    662  C   ASP    91      19.727 -11.783  27.541  1.00 38.89          
ATOM    663  O   ASP    91      20.293 -12.821  27.849  1.00 39.41          
ATOM    664  CB  ASP    91      20.930  -9.613  27.221  1.00 39.76          
ATOM    665  CG  ASP    91      22.095  -9.957  28.110  1.00 40.54          
ATOM    666  OD1 ASP    91      23.143 -10.368  27.568  1.00 41.54          
ATOM    667  OD2 ASP    91      21.961  -9.820  29.341  1.00 39.83          
ATOM    668  N   ILE    92      18.553 -11.418  28.052  1.00 38.96          
ATOM    669  CA  ILE    92      17.828 -12.232  29.034  1.00 39.57          
ATOM    670  C   ILE    92      17.530 -13.640  28.495  1.00 40.37          
ATOM    671  O   ILE    92      17.873 -14.645  29.131  1.00 41.32          
ATOM    672  CB  ILE    92      16.481 -11.547  29.448  1.00 38.05          
ATOM    673  CG1 ILE    92      16.772 -10.233  30.174  1.00 38.15          
ATOM    674  CG2 ILE    92      15.653 -12.464  30.338  1.00 36.72          
ATOM    675  CD  ILE    92      15.537  -9.460  30.585  1.00 35.07          
ATOM    676  N   THR    93      16.896 -13.717  27.326  1.00 40.55          
ATOM    677  CA  THR    93      16.551 -15.012  26.745  1.00 39.43          
ATOM    678  C   THR    93      17.799 -15.812  26.487  1.00 38.37          
ATOM    679  O   THR    93      17.805 -17.030  26.638  1.00 37.61          
ATOM    680  CB  THR    93      15.849 -14.890  25.379  1.00 40.05          
ATOM    681  OG1 THR    93      14.887 -13.822  25.391  1.00 40.47          
ATOM    682  CG2 THR    93      15.152 -16.199  25.048  1.00 38.13          
ATOM    683  N   ARG    94      18.851 -15.102  26.091  1.00 38.34          
ATOM    684  CA  ARG    94      20.141 -15.708  25.766  1.00 38.82          
ATOM    685  C   ARG    94      20.741 -16.429  26.954  1.00 37.58          
ATOM    686  O   ARG    94      21.525 -17.358  26.788  1.00 37.56          
ATOM    687  CB  ARG    94      21.106 -14.625  25.251  1.00 39.26          
ATOM    688  CG  ARG    94      22.336 -15.144  24.519  1.00 39.09          
ATOM    689  CD  ARG    94      23.214 -13.978  24.047  1.00 39.93          
ATOM    690  NE  ARG    94      23.583 -13.091  25.149  1.00 43.31          
ATOM    691  CZ  ARG    94      24.223 -13.484  26.250  1.00 44.23          
ATOM    692  NH1 ARG    94      24.509 -12.604  27.209  1.00 45.12          
ATOM    693  NH2 ARG    94      24.578 -14.756  26.396  1.00 44.13          
ATOM    694  N   ARG    95      20.374 -15.999  28.152  1.00 38.15          
ATOM    695  CA  ARG    95      20.890 -16.641  29.355  1.00 39.17          
ATOM    696  C   ARG    95      19.842 -17.586  29.935  1.00 40.16          
ATOM    697  O   ARG    95      19.773 -17.807  31.148  1.00 40.51          
ATOM    698  CB  ARG    95      21.312 -15.597  30.384  1.00 39.03          
ATOM    699  CG  ARG    95      22.321 -14.600  29.835  1.00 40.05          
ATOM    700  CD  ARG    95      22.995 -13.810  30.936  1.00 42.08          
ATOM    701  NE  ARG    95      22.028 -13.214  31.869  1.00 44.60          
ATOM    702  CZ  ARG    95      21.082 -12.352  31.516  1.00 45.39          
ATOM    703  NH1 ARG    95      20.262 -11.869  32.426  1.00 45.54          
ATOM    704  NH2 ARG    95      20.957 -11.974  30.249  1.00 47.84          
ATOM    705  N   GLY    96      19.024 -18.134  29.035  1.00 41.04          
ATOM    706  CA  GLY    96      17.982 -19.081  29.403  1.00 41.01          
ATOM    707  C   GLY    96      16.998 -18.627  30.459  1.00 41.51          
ATOM    708  O   GLY    96      16.566 -19.424  31.286  1.00 41.53          
ATOM    709  N   LYS    97      16.644 -17.350  30.443  1.00 41.90          
ATOM    710  CA  LYS    97      15.692 -16.832  31.419  1.00 42.49          
ATOM    711  C   LYS    97      14.426 -16.318  30.727  1.00 41.53          
ATOM    712  O   LYS    97      14.305 -16.363  29.498  1.00 42.10          
ATOM    713  CB  LYS    97      16.334 -15.716  32.252  1.00 43.46          
ATOM    714  CG  LYS    97      17.166 -16.206  33.436  1.00 45.45          
ATOM    715  CD  LYS    97      17.908 -15.050  34.122  1.00 48.34          
ATOM    716  CE  LYS    97      18.004 -15.240  35.662  1.00 50.04          
ATOM    717  NZ  LYS    97      18.682 -16.515  36.088  1.00 48.07          
ATOM    718  N   VAL    98      13.483 -15.833  31.524  1.00 38.99          
ATOM    719  CA  VAL    98      12.230 -15.338  30.989  1.00 36.53          
ATOM    720  C   VAL    98      12.110 -13.838  31.071  1.00 37.14          
ATOM    721  O   VAL    98      11.898 -13.280  32.152  1.00 36.62          
ATOM    722  CB  VAL    98      11.041 -15.936  31.733  1.00 35.74          
ATOM    723  CG1 VAL    98       9.748 -15.385  31.159  1.00 34.97          
ATOM    724  CG2 VAL    98      11.084 -17.440  31.629  1.00 34.69          
ATOM    725  N   PRO    99      12.236 -13.158  29.924  1.00 36.43          
ATOM    726  CA  PRO    99      12.133 -11.702  29.880  1.00 35.92          
ATOM    727  C   PRO    99      10.707 -11.243  30.242  1.00 36.90          
ATOM    728  O   PRO    99       9.723 -11.657  29.609  1.00 36.32          
ATOM    729  CB  PRO    99      12.510 -11.383  28.444  1.00 35.09          
ATOM    730  CG  PRO    99      11.952 -12.549  27.710  1.00 35.11          
ATOM    731  CD  PRO    99      12.350 -13.717  28.570  1.00 35.83          
ATOM    732  N   ILE   100      10.609 -10.378  31.256  1.00 35.85          
ATOM    733  CA  ILE   100       9.324  -9.866  31.746  1.00 34.09          
ATOM    734  C   ILE   100       9.369  -8.347  31.820  1.00 34.92          
ATOM    735  O   ILE   100      10.280  -7.778  32.418  1.00 35.54          
ATOM    736  CB  ILE   100       9.038 -10.371  33.182  1.00 33.56          
ATOM    737  CG1 ILE   100       9.218 -11.888  33.261  1.00 33.93          
ATOM    738  CG2 ILE   100       7.648 -10.007  33.583  1.00 30.85          
ATOM    739  CD  ILE   100       9.497 -12.376  34.658  1.00 33.77          
ATOM    740  N   ILE   101       8.394  -7.688  31.213  1.00 35.33          
ATOM    741  CA  ILE   101       8.345  -6.238  31.279  1.00 35.38          
ATOM    742  C   ILE   101       7.166  -5.844  32.173  1.00 35.55          
ATOM    743  O   ILE   101       6.032  -6.270  31.972  1.00 34.79          
ATOM    744  CB  ILE   101       8.215  -5.592  29.879  1.00 34.99          
ATOM    745  CG1 ILE   101       7.036  -6.192  29.133  1.00 36.58          
ATOM    746  CG2 ILE   101       9.498  -5.807  29.099  1.00 34.45          
ATOM    747  CD  ILE   101       6.915  -5.691  27.723  1.00 39.07          
ATOM    748  N   ALA   102       7.478  -5.049  33.189  1.00 35.59          
ATOM    749  CA  ALA   102       6.510  -4.580  34.147  1.00 34.62          
ATOM    750  C   ALA   102       6.215  -3.135  33.837  1.00 36.25          
ATOM    751  O   ALA   102       7.129  -2.337  33.607  1.00 36.56          
ATOM    752  CB  ALA   102       7.066  -4.700  35.535  1.00 31.84          
ATOM    753  N   GLY   103       4.928  -2.806  33.808  1.00 36.86          
ATOM    754  CA  GLY   103       4.514  -1.438  33.547  1.00 34.82          
ATOM    755  C   GLY   103       4.605  -1.026  32.101  1.00 34.11          
ATOM    756  O   GLY   103       4.742  -1.863  31.211  1.00 34.68          
ATOM    757  N   GLY   104       4.527   0.282  31.880  1.00 34.21          
ATOM    758  CA  GLY   104       4.591   0.823  30.538  1.00 32.64          
ATOM    759  C   GLY   104       3.248   1.377  30.095  1.00 32.24          
ATOM    760  O   GLY   104       2.210   0.989  30.619  1.00 30.34          
ATOM    761  N   THR   105       3.271   2.290  29.129  1.00 34.02          
ATOM    762  CA  THR   105       2.050   2.892  28.604  1.00 36.46          
ATOM    763  C   THR   105       1.713   2.289  27.233  1.00 37.92          
ATOM    764  O   THR   105       2.510   1.540  26.673  1.00 39.04          
ATOM    765  CB  THR   105       2.202   4.430  28.452  1.00 35.92          
ATOM    766  OG1 THR   105       3.371   4.736  27.677  1.00 35.55          
ATOM    767  CG2 THR   105       2.293   5.096  29.818  1.00 36.82          
ATOM    768  N   GLY   106       0.540   2.619  26.698  1.00 38.11          
ATOM    769  CA  GLY   106       0.146   2.102  25.400  1.00 37.56          
ATOM    770  C   GLY   106       1.221   2.304  24.344  1.00 37.63          
ATOM    771  O   GLY   106       1.659   1.346  23.714  1.00 35.90          
ATOM    772  N   LEU   107       1.653   3.544  24.140  1.00 38.20          
ATOM    773  CA  LEU   107       2.685   3.791  23.151  1.00 39.43          
ATOM    774  C   LEU   107       3.891   2.894  23.389  1.00 39.89          
ATOM    775  O   LEU   107       4.174   2.017  22.579  1.00 41.10          
ATOM    776  CB  LEU   107       3.131   5.252  23.168  1.00 41.15          
ATOM    777  CG  LEU   107       2.421   6.254  22.244  1.00 41.69          
ATOM    778  CD1 LEU   107       2.941   7.651  22.577  1.00 42.07          
ATOM    779  CD2 LEU   107       2.684   5.922  20.777  1.00 41.61          
ATOM    780  N   TYR   108       4.583   3.096  24.509  1.00 39.43          
ATOM    781  CA  TYR   108       5.766   2.308  24.847  1.00 38.14          
ATOM    782  C   TYR   108       5.590   0.811  24.689  1.00 37.73          
ATOM    783  O   TYR   108       6.523   0.120  24.310  1.00 37.59          
ATOM    784  CB  TYR   108       6.209   2.586  26.283  1.00 40.80          
ATOM    785  CG  TYR   108       6.759   3.969  26.516  1.00 43.04          
ATOM    786  CD1 TYR   108       8.091   4.149  26.882  1.00 42.95          
ATOM    787  CD2 TYR   108       5.943   5.101  26.371  1.00 44.06          
ATOM    788  CE1 TYR   108       8.609   5.421  27.098  1.00 45.65          
ATOM    789  CE2 TYR   108       6.446   6.384  26.583  1.00 46.23          
ATOM    790  CZ  TYR   108       7.788   6.536  26.947  1.00 47.17          
ATOM    791  OH  TYR   108       8.307   7.800  27.154  1.00 48.96          
ATOM    792  N   ILE   109       4.403   0.303  24.987  1.00 38.17          
ATOM    793  CA  ILE   109       4.185  -1.120  24.881  1.00 39.47          
ATOM    794  C   ILE   109       3.935  -1.613  23.469  1.00 40.68          
ATOM    795  O   ILE   109       4.524  -2.605  23.053  1.00 42.01          
ATOM    796  CB  ILE   109       3.038  -1.567  25.781  1.00 39.28          
ATOM    797  CG1 ILE   109       3.376  -1.240  27.225  1.00 41.80          
ATOM    798  CG2 ILE   109       2.815  -3.062  25.646  1.00 39.71          
ATOM    799  CD  ILE   109       4.689  -1.861  27.711  1.00 43.04          
ATOM    800  N   GLN   110       3.070  -0.944  22.718  1.00 41.74          
ATOM    801  CA  GLN   110       2.827  -1.410  21.365  1.00 42.65          
ATOM    802  C   GLN   110       4.045  -1.161  20.478  1.00 42.85          
ATOM    803  O   GLN   110       4.395  -1.985  19.624  1.00 43.03          
ATOM    804  CB  GLN   110       1.574  -0.757  20.759  1.00 43.38          
ATOM    805  CG  GLN   110       1.751   0.625  20.174  1.00 43.67          
ATOM    806  CD  GLN   110       0.605   0.995  19.236  1.00 44.36          
ATOM    807  OE1 GLN   110       0.534   2.121  18.741  1.00 44.31          
ATOM    808  NE2 GLN   110      -0.294   0.039  18.983  1.00 43.98          
ATOM    809  N   SER   111       4.712  -0.038  20.695  1.00 42.96          
ATOM    810  CA  SER   111       5.890   0.292  19.900  1.00 43.29          
ATOM    811  C   SER   111       6.911  -0.835  20.019  1.00 43.63          
ATOM    812  O   SER   111       7.658  -1.120  19.081  1.00 43.24          
ATOM    813  CB  SER   111       6.490   1.620  20.382  1.00 41.83          
ATOM    814  OG  SER   111       5.519   2.653  20.359  1.00 38.04          
ATOM    815  N   LEU   112       6.910  -1.484  21.179  1.00 42.94          
ATOM    816  CA  LEU   112       7.820  -2.589  21.466  1.00 43.24          
ATOM    817  C   LEU   112       7.305  -3.932  20.984  1.00 42.84          
ATOM    818  O   LEU   112       8.084  -4.826  20.664  1.00 43.39          
ATOM    819  CB  LEU   112       8.073  -2.679  22.980  1.00 42.95          
ATOM    820  CG  LEU   112       8.738  -3.944  23.539  1.00 41.60          
ATOM    821  CD1 LEU   112      10.130  -4.145  22.941  1.00 40.14          
ATOM    822  CD2 LEU   112       8.806  -3.824  25.042  1.00 40.07          
ATOM    823  N   LEU   113       5.991  -4.079  20.943  1.00 42.94          
ATOM    824  CA  LEU   113       5.404  -5.342  20.529  1.00 43.87          
ATOM    825  C   LEU   113       5.256  -5.507  19.022  1.00 43.65          
ATOM    826  O   LEU   113       5.468  -6.595  18.492  1.00 43.18          
ATOM    827  CB  LEU   113       4.040  -5.520  21.201  1.00 44.22          
ATOM    828  CG  LEU   113       4.098  -5.537  22.733  1.00 45.40          
ATOM    829  CD1 LEU   113       2.696  -5.608  23.294  1.00 45.75          
ATOM    830  CD2 LEU   113       4.926  -6.726  23.201  1.00 45.87          
ATOM    831  N   TYR   114       4.929  -4.421  18.335  1.00 43.62          
ATOM    832  CA  TYR   114       4.706  -4.469  16.899  1.00 43.89          
ATOM    833  C   TYR   114       5.617  -3.561  16.106  1.00 45.49          
ATOM    834  O   TYR   114       5.993  -2.496  16.576  1.00 47.98          
ATOM    835  CB  TYR   114       3.260  -4.078  16.614  1.00 43.38          
ATOM    836  CG  TYR   114       2.270  -4.789  17.502  1.00 40.83          
ATOM    837  CD1 TYR   114       2.213  -6.172  17.514  1.00 39.48          
ATOM    838  CD2 TYR   114       1.400  -4.079  18.333  1.00 40.02          
ATOM    839  CE1 TYR   114       1.327  -6.844  18.322  1.00 40.57          
ATOM    840  CE2 TYR   114       0.495  -4.743  19.155  1.00 40.05          
ATOM    841  CZ  TYR   114       0.471  -6.140  19.138  1.00 40.06          
ATOM    842  OH  TYR   114      -0.394  -6.860  19.917  1.00 39.18          
ATOM    843  N   ASN   115       5.955  -3.974  14.892  1.00 47.91          
ATOM    844  CA  ASN   115       6.802  -3.165  14.034  1.00 49.56          
ATOM    845  C   ASN   115       6.010  -2.369  13.028  1.00 50.49          
ATOM    846  O   ASN   115       6.268  -2.476  11.836  1.00 50.90          
ATOM    847  CB  ASN   115       7.765  -4.042  13.268  1.00 49.54          
ATOM    848  CG  ASN   115       9.037  -4.256  13.998  1.00 51.39          
ATOM    849  OD1 ASN   115       9.954  -4.869  13.468  1.00 52.45          
ATOM    850  ND2 ASN   115       9.117  -3.749  15.233  1.00 52.07          
ATOM   1490  N   GLU   194       4.232  -8.569  14.796  1.00 47.75          
ATOM   1491  CA  GLU   194       4.617  -8.834  16.179  1.00 49.40          
ATOM   1492  C   GLU   194       6.024  -9.388  16.317  1.00 48.31          
ATOM   1493  O   GLU   194       6.399 -10.332  15.638  1.00 48.33          
ATOM   1494  CB  GLU   194       3.630  -9.789  16.843  1.00 51.42          
ATOM   1495  CG  GLU   194       3.490 -11.112  16.136  1.00 56.87          
ATOM   1496  CD  GLU   194       2.523 -12.042  16.848  1.00 60.08          
ATOM   1497  OE1 GLU   194       2.177 -13.105  16.267  1.00 61.22          
ATOM   1498  OE2 GLU   194       2.115 -11.713  17.992  1.00 60.95          
ATOM   1499  N   ASN   195       6.787  -8.798  17.226  1.00 46.51          
ATOM   1500  CA  ASN   195       8.143  -9.207  17.436  1.00 45.67          
ATOM   1501  C   ASN   195       8.302 -10.310  18.443  1.00 45.98          
ATOM   1502  O   ASN   195       9.308 -11.001  18.434  1.00 47.00          
ATOM   1503  CB  ASN   195       8.982  -8.016  17.860  1.00 47.07          
ATOM   1504  CG  ASN   195       8.897  -6.874  16.867  1.00 48.46          
ATOM   1505  OD1 ASN   195       8.841  -7.099  15.655  1.00 49.07          
ATOM   1506  ND2 ASN   195       8.880  -5.641  17.372  1.00 48.06          
ATOM   1507  N   TYR   196       7.326 -10.499  19.315  1.00 46.29          
ATOM   1508  CA  TYR   196       7.467 -11.540  20.317  1.00 47.17          
ATOM   1509  C   TYR   196       6.232 -12.389  20.522  1.00 47.82          
ATOM   1510  O   TYR   196       5.125 -12.002  20.152  1.00 47.37          
ATOM   1511  CB  TYR   196       7.860 -10.918  21.664  1.00 46.04          
ATOM   1512  CG  TYR   196       8.973  -9.899  21.584  1.00 45.49          
ATOM   1513  CD1 TYR   196       8.701  -8.549  21.361  1.00 44.85          
ATOM   1514  CD2 TYR   196      10.304 -10.286  21.742  1.00 45.74          
ATOM   1515  CE1 TYR   196       9.736  -7.609  21.307  1.00 44.31          
ATOM   1516  CE2 TYR   196      11.340  -9.361  21.684  1.00 43.91          
ATOM   1517  CZ  TYR   196      11.055  -8.032  21.471  1.00 43.56          
ATOM   1518  OH  TYR   196      12.099  -7.141  21.438  1.00 42.22          
ATOM   1519  N   ASP   197       6.451 -13.561  21.112  1.00 48.93          
ATOM   1520  CA  ASP   197       5.371 -14.486  21.452  1.00 50.31          
ATOM   1521  C   ASP   197       4.840 -13.955  22.786  1.00 50.43          
ATOM   1522  O   ASP   197       4.990 -14.599  23.832  1.00 51.08          
ATOM   1523  CB  ASP   197       5.918 -15.900  21.660  1.00 51.47          
ATOM   1524  CG  ASP   197       4.886 -16.831  22.266  1.00 53.27          
ATOM   1525  OD1 ASP   197       5.258 -17.893  22.809  1.00 53.86          
ATOM   1526  OD2 ASP   197       3.686 -16.493  22.203  1.00 55.59          
ATOM   1527  N   THR   198       4.213 -12.782  22.737  1.00 49.76          
ATOM   1528  CA  THR   198       3.713 -12.096  23.932  1.00 49.28          
ATOM   1529  C   THR   198       2.563 -12.709  24.722  1.00 47.06          
ATOM   1530  O   THR   198       1.661 -13.327  24.170  1.00 46.55          
ATOM   1531  CB  THR   198       3.316 -10.626  23.597  1.00 50.79          
ATOM   1532  OG1 THR   198       2.051 -10.612  22.924  1.00 52.00          
ATOM   1533  CG2 THR   198       4.370  -9.971  22.696  1.00 51.01          
ATOM   1534  N   LEU   199       2.632 -12.528  26.034  1.00 46.23          
ATOM   1535  CA  LEU   199       1.601 -12.991  26.946  1.00 45.60          
ATOM   1536  C   LEU   199       1.181 -11.716  27.675  1.00 44.21          
ATOM   1537  O   LEU   199       1.519 -11.500  28.833  1.00 44.85          
ATOM   1538  CB  LEU   199       2.165 -14.024  27.925  1.00 44.96          
ATOM   1539  CG  LEU   199       1.253 -14.518  29.057  1.00 44.18          
ATOM   1540  CD1 LEU   199      -0.198 -14.656  28.608  1.00 43.89          
ATOM   1541  CD2 LEU   199       1.800 -15.840  29.538  1.00 45.05          
ATOM   1542  N   LEU   200       0.460 -10.863  26.959  1.00 41.66          
ATOM   1543  CA  LEU   200       0.026  -9.582  27.478  1.00 40.53          
ATOM   1544  C   LEU   200      -1.114  -9.672  28.479  1.00 39.77          
ATOM   1545  O   LEU   200      -2.234 -10.034  28.127  1.00 37.94          
ATOM   1546  CB  LEU   200      -0.372  -8.688  26.310  1.00 40.26          
ATOM   1547  CG  LEU   200      -0.657  -7.221  26.580  1.00 41.39          
ATOM   1548  CD1 LEU   200       0.606  -6.499  27.040  1.00 40.32          
ATOM   1549  CD2 LEU   200      -1.184  -6.590  25.299  1.00 42.87          
ATOM   1550  N   ILE   201      -0.821  -9.338  29.732  1.00 39.53          
ATOM   1551  CA  ILE   201      -1.838  -9.382  30.775  1.00 41.00          
ATOM   1552  C   ILE   201      -1.965  -8.007  31.463  1.00 40.72          
ATOM   1553  O   ILE   201      -0.981  -7.287  31.653  1.00 39.19          
ATOM   1554  CB  ILE   201      -1.542 -10.523  31.829  1.00 40.54          
ATOM   1555  CG1 ILE   201      -0.531 -10.072  32.855  1.00 40.51          
ATOM   1556  CG2 ILE   201      -0.955 -11.744  31.155  1.00 40.02          
ATOM   1557  CD  ILE   201      -1.170  -9.597  34.101  1.00 41.99          
ATOM   1558  N   GLY   202      -3.196  -7.644  31.809  1.00 41.71          
ATOM   1559  CA  GLY   202      -3.450  -6.372  32.457  1.00 42.46          
ATOM   1560  C   GLY   202      -4.338  -6.522  33.676  1.00 43.59          
ATOM   1561  O   GLY   202      -5.207  -7.391  33.711  1.00 43.17          
ATOM   1562  N   ILE   203      -4.107  -5.686  34.684  1.00 45.16          
ATOM   1563  CA  ILE   203      -4.900  -5.716  35.906  1.00 46.85          
ATOM   1564  C   ILE   203      -5.963  -4.638  35.810  1.00 48.66          
ATOM   1565  O   ILE   203      -5.655  -3.452  35.710  1.00 48.68          
ATOM   1566  CB  ILE   203      -4.041  -5.445  37.133  1.00 45.94          
ATOM   1567  CG1 ILE   203      -2.866  -6.419  37.179  1.00 46.14          
ATOM   1568  CG2 ILE   203      -4.882  -5.594  38.376  1.00 46.19          
ATOM   1569  CD  ILE   203      -1.912  -6.143  38.319  1.00 45.78          
ATOM   1570  N   GLU   204      -7.216  -5.058  35.849  1.00 51.48          
ATOM   1571  CA  GLU   204      -8.332  -4.138  35.715  1.00 55.82          
ATOM   1572  C   GLU   204      -9.114  -3.943  37.015  1.00 56.85          
ATOM   1573  O   GLU   204      -8.898  -4.644  37.995  1.00 56.30          
ATOM   1574  CB  GLU   204      -9.269  -4.675  34.637  1.00 59.26          
ATOM   1575  CG  GLU   204     -10.412  -3.758  34.261  1.00 64.70          
ATOM   1576  CD  GLU   204     -11.575  -4.512  33.653  1.00 67.29          
ATOM   1577  OE1 GLU   204     -12.163  -5.358  34.370  1.00 69.22          
ATOM   1578  OE2 GLU   204     -11.889  -4.257  32.466  1.00 68.13          
ATOM   1579  N   MET   205     -10.035  -2.988  37.010  1.00 58.68          
ATOM   1580  CA  MET   205     -10.855  -2.725  38.174  1.00 61.00          
ATOM   1581  C   MET   205     -11.885  -1.669  37.811  1.00 59.37          
ATOM   1582  O   MET   205     -11.719  -0.954  36.826  1.00 58.70          
ATOM   1583  CB  MET   205      -9.978  -2.261  39.332  1.00 66.33          
ATOM   1584  CG  MET   205      -9.104  -1.084  38.972  1.00 74.24          
ATOM   1585  SD  MET   205      -7.625  -0.835  40.201  1.00 86.23          
ATOM   1586  CE  MET   205      -8.641  -0.116  41.686  1.00 83.03          
ATOM   1587  N   SER   206     -12.954  -1.581  38.598  1.00 57.85          
ATOM   1588  CA  SER   206     -14.017  -0.622  38.331  1.00 57.29          
ATOM   1589  C   SER   206     -13.525   0.799  38.510  1.00 57.42          
ATOM   1590  O   SER   206     -12.622   1.049  39.304  1.00 57.34          
ATOM   1591  CB  SER   206     -15.212  -0.875  39.253  1.00 58.20          
ATOM   1592  OG  SER   206     -14.949  -0.485  40.595  1.00 58.30          
ATOM   1593  N   ARG   207     -14.121   1.732  37.774  1.00 57.81          
ATOM   1594  CA  ARG   207     -13.720   3.130  37.862  1.00 57.90          
ATOM   1595  C   ARG   207     -13.876   3.620  39.294  1.00 57.25          
ATOM   1596  O   ARG   207     -13.126   4.486  39.747  1.00 57.38          
ATOM   1597  CB  ARG   207     -14.567   4.018  36.933  1.00 59.77          
ATOM   1598  CG  ARG   207     -13.797   5.238  36.402  1.00 61.95          
ATOM   1599  CD  ARG   207     -14.603   6.536  36.316  1.00 63.77          
ATOM   1600  NE  ARG   207     -15.787   6.495  35.515  1.00 65.96          
ATOM   1601  CZ  ARG   207     -16.987   7.059  35.671  1.00 66.23          
ATOM   1602  NH1 ARG   207     -17.834   6.800  34.702  1.00 66.18          
ATOM   1603  NH2 ARG   207     -17.386   7.808  36.700  1.00 64.90          
ATOM   1604  N   GLU   208     -14.856   3.069  40.004  1.00 56.65          
ATOM   1605  CA  GLU   208     -15.097   3.463  41.387  1.00 56.14          
ATOM   1606  C   GLU   208     -13.862   3.162  42.237  1.00 55.10          
ATOM   1607  O   GLU   208     -13.262   4.069  42.819  1.00 54.75          
ATOM   1608  CB  GLU   208     -16.300   2.709  41.977  1.00 56.67          
ATOM   1609  CG  GLU   208     -17.676   2.979  41.343  1.00 57.91          
ATOM   1610  CD  GLU   208     -18.003   2.049  40.169  1.00 58.56          
ATOM   1611  OE1 GLU   208     -17.721   2.435  39.013  1.00 58.35          
ATOM   1612  OE2 GLU   208     -18.530   0.931  40.407  1.00 57.29          
ATOM   1613  N   THR   209     -13.490   1.883  42.301  1.00 54.16          
ATOM   1614  CA  THR   209     -12.340   1.456  43.092  1.00 53.60          
ATOM   1615  C   THR   209     -11.061   2.129  42.604  1.00 53.06          
ATOM   1616  O   THR   209     -10.239   2.571  43.400  1.00 52.72          
ATOM   1617  CB  THR   209     -12.153  -0.092  43.046  1.00 52.87          
ATOM   1618  OG1 THR   209     -13.366  -0.746  43.439  1.00 51.02          
ATOM   1619  CG2 THR   209     -11.043  -0.527  43.995  1.00 52.66          
ATOM   1620  N   LEU   210     -10.901   2.203  41.291  1.00 52.94          
ATOM   1621  CA  LEU   210      -9.730   2.828  40.703  1.00 52.98          
ATOM   1622  C   LEU   210      -9.528   4.235  41.261  1.00 52.71          
ATOM   1623  O   LEU   210      -8.509   4.528  41.891  1.00 52.92          
ATOM   1624  CB  LEU   210      -9.889   2.903  39.180  1.00 54.27          
ATOM   1625  CG  LEU   210      -8.820   3.668  38.374  1.00 54.83          
ATOM   1626  CD1 LEU   210      -7.497   2.944  38.513  1.00 56.79          
ATOM   1627  CD2 LEU   210      -9.212   3.773  36.904  1.00 53.90          
ATOM   1628  N   TYR   211     -10.512   5.097  41.028  1.00 52.09          
ATOM   1629  CA  TYR   211     -10.454   6.482  41.481  1.00 52.39          
ATOM   1630  C   TYR   211     -10.234   6.630  42.979  1.00 51.09          
ATOM   1631  O   TYR   211      -9.549   7.548  43.435  1.00 50.28          
ATOM   1632  CB  TYR   211     -11.728   7.237  41.061  1.00 54.07          
ATOM   1633  CG  TYR   211     -11.758   7.638  39.596  1.00 56.55          
ATOM   1634  CD1 TYR   211     -12.669   8.581  39.128  1.00 57.92          
ATOM   1635  CD2 TYR   211     -10.858   7.092  38.684  1.00 57.95          
ATOM   1636  CE1 TYR   211     -12.681   8.975  37.789  1.00 59.13          
ATOM   1637  CE2 TYR   211     -10.859   7.474  37.347  1.00 59.28          
ATOM   1638  CZ  TYR   211     -11.772   8.419  36.907  1.00 60.34          
ATOM   1639  OH  TYR   211     -11.763   8.810  35.586  1.00 61.94          
ATOM   1640  N   LEU   212     -10.808   5.721  43.748  1.00 50.37          
ATOM   1641  CA  LEU   212     -10.654   5.778  45.187  1.00 49.40          
ATOM   1642  C   LEU   212      -9.215   5.448  45.593  1.00 48.18          
ATOM   1643  O   LEU   212      -8.628   6.134  46.430  1.00 47.77          
ATOM   1644  CB  LEU   212     -11.630   4.805  45.834  1.00 50.41          
ATOM   1645  CG  LEU   212     -11.704   4.886  47.349  1.00 51.44          
ATOM   1646  CD1 LEU   212     -12.122   6.288  47.772  1.00 51.12          
ATOM   1647  CD2 LEU   212     -12.696   3.850  47.841  1.00 52.30          
ATOM   1648  N   ARG   213      -8.648   4.411  44.982  1.00 47.23          
ATOM   1649  CA  ARG   213      -7.288   3.993  45.291  1.00 45.81          
ATOM   1650  C   ARG   213      -6.283   5.054  44.893  1.00 45.00          
ATOM   1651  O   ARG   213      -5.316   5.301  45.618  1.00 45.34          
ATOM   1652  CB  ARG   213      -6.953   2.680  44.589  1.00 46.12          
ATOM   1653  CG  ARG   213      -7.893   1.561  44.947  1.00 47.50          
ATOM   1654  CD  ARG   213      -7.285   0.226  44.633  1.00 49.26          
ATOM   1655  NE  ARG   213      -6.204  -0.149  45.481  1.00 50.85          
ATOM   1656  CZ  ARG   213      -4.999  -0.646  45.219  1.00 52.07          
ATOM   1657  NH1 ARG   213      -4.277  -0.882  46.291  1.00 51.27          
ATOM   1658  NH2 ARG   213      -4.484  -0.876  44.015  1.00 52.18          
ATOM   1659  N   ILE   214      -6.505   5.677  43.740  1.00 42.90          
ATOM   1660  CA  ILE   214      -5.607   6.723  43.284  1.00 42.58          
ATOM   1661  C   ILE   214      -5.609   7.858  44.301  1.00 44.04          
ATOM   1662  O   ILE   214      -4.549   8.290  44.754  1.00 44.37          
ATOM   1663  CB  ILE   214      -6.015   7.257  41.894  1.00 42.38          
ATOM   1664  CG1 ILE   214      -5.905   6.130  40.856  1.00 41.56          
ATOM   1665  CG2 ILE   214      -5.131   8.432  41.499  1.00 40.53          
ATOM   1666  CD  ILE   214      -6.409   6.490  39.488  1.00 40.18          
ATOM   1667  N   ASN   215      -6.780   8.339  44.694  1.00 44.37          
ATOM   1668  CA  ASN   215      -6.782   9.402  45.689  1.00 46.12          
ATOM   1669  C   ASN   215      -5.987   8.978  46.906  1.00 45.68          
ATOM   1670  O   ASN   215      -5.266   9.777  47.492  1.00 45.52          
ATOM   1671  CB  ASN   215      -8.198   9.764  46.118  1.00 47.65          
ATOM   1672  CG  ASN   215      -9.003  10.321  44.984  1.00 49.26          
ATOM   1673  OD1 ASN   215      -8.501  11.116  44.187  1.00 50.48          
ATOM   1674  ND2 ASN   215     -10.263   9.922  44.902  1.00 50.51          
ATOM   1675  N   LYS   216      -6.107   7.711  47.274  1.00 45.88          
ATOM   1676  CA  LYS   216      -5.394   7.213  48.435  1.00 46.84          
ATOM   1677  C   LYS   216      -3.888   7.081  48.215  1.00 46.74          
ATOM   1678  O   LYS   216      -3.116   7.192  49.158  1.00 46.10          
ATOM   1679  CB  LYS   216      -5.984   5.876  48.880  1.00 48.06          
ATOM   1680  CG  LYS   216      -5.384   5.354  50.172  1.00 51.11          
ATOM   1681  CD  LYS   216      -6.408   4.614  51.040  1.00 52.88          
ATOM   1682  CE  LYS   216      -5.802   4.179  52.382  1.00 52.11          
ATOM   1683  NZ  LYS   216      -6.811   3.570  53.287  1.00 51.76          
ATOM   1684  N   ARG   217      -3.464   6.859  46.978  1.00 47.09          
ATOM   1685  CA  ARG   217      -2.040   6.725  46.708  1.00 47.24          
ATOM   1686  C   ARG   217      -1.372   8.088  46.677  1.00 46.13          
ATOM   1687  O   ARG   217      -0.179   8.219  46.959  1.00 46.25          
ATOM   1688  CB  ARG   217      -1.820   6.000  45.388  1.00 48.37          
ATOM   1689  CG  ARG   217      -0.383   5.876  44.976  1.00 50.40          
ATOM   1690  CD  ARG   217      -0.312   5.084  43.691  1.00 55.04          
ATOM   1691  NE  ARG   217      -1.153   5.631  42.611  1.00 58.04          
ATOM   1692  CZ  ARG   217      -0.829   6.677  41.851  1.00 58.71          
ATOM   1693  NH1 ARG   217      -1.659   7.091  40.896  1.00 58.58          
ATOM   1694  NH2 ARG   217       0.322   7.310  42.050  1.00 58.89          
ATOM   1695  N   VAL   218      -2.145   9.108  46.333  1.00 46.00          
ATOM   1696  CA  VAL   218      -1.609  10.455  46.284  1.00 46.08          
ATOM   1697  C   VAL   218      -1.417  10.905  47.725  1.00 47.54          
ATOM   1698  O   VAL   218      -0.449  11.586  48.042  1.00 46.77          
ATOM   1699  CB  VAL   218      -2.564  11.419  45.510  1.00 44.61          
ATOM   1700  CG1 VAL   218      -2.020  12.835  45.537  1.00 44.97          
ATOM   1701  CG2 VAL   218      -2.703  10.968  44.068  1.00 41.49          
ATOM   1702  N   ASP   219      -2.329  10.501  48.608  1.00 49.53          
ATOM   1703  CA  ASP   219      -2.219  10.875  50.019  1.00 50.83          
ATOM   1704  C   ASP   219      -0.959  10.273  50.608  1.00 51.42          
ATOM   1705  O   ASP   219      -0.230  10.942  51.334  1.00 52.60          
ATOM   1706  CB  ASP   219      -3.429  10.395  50.829  1.00 51.95          
ATOM   1707  CG  ASP   219      -4.704  11.146  50.482  1.00 54.27          
ATOM   1708  OD1 ASP   219      -4.604  12.292  49.978  1.00 54.93          
ATOM   1709  OD2 ASP   219      -5.813  10.598  50.730  1.00 54.88          
ATOM   1710  N   ILE   220      -0.704   9.007  50.298  1.00 50.93          
ATOM   1711  CA  ILE   220       0.475   8.335  50.820  1.00 50.35          
ATOM   1712  C   ILE   220       1.763   8.987  50.330  1.00 50.83          
ATOM   1713  O   ILE   220       2.692   9.191  51.107  1.00 49.12          
ATOM   1714  CB  ILE   220       0.489   6.861  50.422  1.00 50.25          
ATOM   1715  CG1 ILE   220      -0.829   6.199  50.819  1.00 49.65          
ATOM   1716  CG2 ILE   220       1.650   6.162  51.101  1.00 49.47          
ATOM   1717  CD  ILE   220      -0.965   4.771  50.337  1.00 48.90          
ATOM   1718  N   MET   221       1.819   9.308  49.040  1.00 52.75          
ATOM   1719  CA  MET   221       3.011   9.936  48.478  1.00 54.09          
ATOM   1720  C   MET   221       3.341  11.226  49.222  1.00 53.07          
ATOM   1721  O   MET   221       4.496  11.462  49.582  1.00 53.63          
ATOM   1722  CB  MET   221       2.829  10.262  46.996  1.00 57.37          
ATOM   1723  CG  MET   221       2.482   9.089  46.099  1.00 61.31          
ATOM   1724  SD  MET   221       2.805   9.516  44.215  1.00 68.30          
ATOM   1725  CE  MET   221       1.657  11.071  43.994  1.00 66.79          
ATOM   1726  N   LEU   222       2.329  12.066  49.435  1.00 51.20          
ATOM   1727  CA  LEU   222       2.529  13.324  50.144  1.00 48.78          
ATOM   1728  C   LEU   222       3.049  12.992  51.524  1.00 47.82          
ATOM   1729  O   LEU   222       3.943  13.657  52.041  1.00 46.99          
ATOM   1730  CB  LEU   222       1.211  14.101  50.261  1.00 47.68          
ATOM   1731  CG  LEU   222       0.761  14.988  49.091  1.00 47.08          
ATOM   1732  CD1 LEU   222       1.733  16.140  48.895  1.00 47.95          
ATOM   1733  CD2 LEU   222       0.673  14.168  47.838  1.00 47.74          
ATOM   1734  N   GLY   223       2.490  11.934  52.102  1.00 47.54          
ATOM   1735  CA  GLY   223       2.885  11.507  53.429  1.00 46.72          
ATOM   1736  C   GLY   223       4.254  10.872  53.473  1.00 47.26          
ATOM   1737  O   GLY   223       4.836  10.750  54.540  1.00 46.92          
ATOM   1738  N   HSD   224       4.783  10.465  52.326  1.00 48.55          
ATOM   1739  CA  HSD   224       6.096   9.847  52.324  1.00 49.09          
ATOM   1740  C   HSD   224       7.240  10.792  51.959  1.00 49.59          
ATOM   1741  O   HSD   224       8.401  10.389  51.959  1.00 50.22          
ATOM   1742  CB  HSD   224       6.102   8.628  51.408  1.00 50.46          
ATOM   1743  CG  HSD   224       5.612   7.376  52.070  1.00 52.48          
ATOM   1744  ND1 HSD   224       5.705   6.134  51.476  1.00 53.25          
ATOM   1745  CD2 HSD   224       5.035   7.170  53.278  1.00 52.96          
ATOM   1746  CE1 HSD   224       5.207   5.219  52.288  1.00 52.93          
ATOM   1747  NE2 HSD   224       4.793   5.821  53.389  1.00 53.58          
ATOM   1748  N   GLY   225       6.922  12.046  51.652  1.00 48.30          
ATOM   1749  CA  GLY   225       7.965  12.995  51.318  1.00 48.19          
ATOM   1750  C   GLY   225       8.060  13.385  49.858  1.00 48.65          
ATOM   1751  O   GLY   225       9.127  13.797  49.398  1.00 48.46          
ATOM   1752  N   LEU   226       6.955  13.245  49.126  1.00 49.00          
ATOM   1753  CA  LEU   226       6.908  13.607  47.703  1.00 48.60          
ATOM   1754  C   LEU   226       7.306  15.064  47.518  1.00 48.18          
ATOM   1755  O   LEU   226       8.145  15.389  46.681  1.00 47.55          
ATOM   1756  CB  LEU   226       5.495  13.408  47.131  1.00 46.67          
ATOM   1757  CG  LEU   226       5.224  14.068  45.771  1.00 46.21          
ATOM   1758  CD1 LEU   226       6.161  13.498  44.722  1.00 44.40          
ATOM   1759  CD2 LEU   226       3.772  13.858  45.362  1.00 45.96          
ATOM   1760  N   PHE   227       6.690  15.939  48.303  1.00 48.68          
ATOM   1761  CA  PHE   227       6.985  17.353  48.209  1.00 49.66          
ATOM   1762  C   PHE   227       8.466  17.600  48.501  1.00 50.70          
ATOM   1763  O   PHE   227       9.099  18.414  47.833  1.00 51.23          
ATOM   1764  CB  PHE   227       6.100  18.141  49.178  1.00 49.58          
ATOM   1765  CG  PHE   227       6.176  19.632  49.000  1.00 49.04          
ATOM   1766  CD1 PHE   227       7.235  20.359  49.538  1.00 49.30          
ATOM   1767  CD2 PHE   227       5.205  20.306  48.266  1.00 49.29          
ATOM   1768  CE1 PHE   227       7.327  21.743  49.355  1.00 49.51          
ATOM   1769  CE2 PHE   227       5.285  21.687  48.077  1.00 49.75          
ATOM   1770  CZ  PHE   227       6.354  22.409  48.620  1.00 49.71          
ATOM   1771  N   ASN   228       9.027  16.894  49.480  1.00 50.89          
ATOM   1772  CA  ASN   228      10.435  17.082  49.808  1.00 51.21          
ATOM   1773  C   ASN   228      11.299  16.702  48.605  1.00 51.40          
ATOM   1774  O   ASN   228      12.339  17.312  48.347  1.00 50.59          
ATOM   1775  CB  ASN   228      10.834  16.227  51.009  1.00 52.09          
ATOM   1776  CG  ASN   228      12.219  16.566  51.521  1.00 53.59          
ATOM   1777  OD1 ASN   228      12.820  15.809  52.281  1.00 54.96          
ATOM   1778  ND2 ASN   228      12.733  17.718  51.109  1.00 55.01          
ATOM   1779  N   GLU   229      10.853  15.695  47.866  1.00 51.04          
ATOM   1780  CA  GLU   229      11.586  15.244  46.706  1.00 51.72          
ATOM   1781  C   GLU   229      11.588  16.311  45.614  1.00 52.23          
ATOM   1782  O   GLU   229      12.655  16.693  45.128  1.00 53.72          
ATOM   1783  CB  GLU   229      10.979  13.954  46.175  1.00 52.05          
ATOM   1784  CG  GLU   229      11.899  13.129  45.301  1.00 52.84          
ATOM   1785  CD  GLU   229      11.213  11.880  44.807  1.00 53.57          
ATOM   1786  OE1 GLU   229      10.385  11.998  43.877  1.00 54.71          
ATOM   1787  OE2 GLU   229      11.478  10.787  45.357  1.00 52.14          
ATOM   1788  N   VAL   230      10.411  16.805  45.229  1.00 51.22          
ATOM   1789  CA  VAL   230      10.349  17.821  44.184  1.00 50.77          
ATOM   1790  C   VAL   230      11.131  19.055  44.597  1.00 50.92          
ATOM   1791  O   VAL   230      11.509  19.868  43.758  1.00 50.86          
ATOM   1792  CB  VAL   230       8.906  18.250  43.857  1.00 49.81          
ATOM   1793  CG1 VAL   230       8.028  17.040  43.649  1.00 50.73          
ATOM   1794  CG2 VAL   230       8.371  19.127  44.939  1.00 51.11          
ATOM   1795  N   GLN   231      11.382  19.188  45.894  1.00 51.90          
ATOM   1796  CA  GLN   231      12.138  20.326  46.401  1.00 52.73          
ATOM   1797  C   GLN   231      13.605  20.151  46.074  1.00 52.44          
ATOM   1798  O   GLN   231      14.255  21.086  45.636  1.00 52.48          
ATOM   1799  CB  GLN   231      11.968  20.457  47.914  1.00 53.42          
ATOM   1800  CG  GLN   231      10.643  21.061  48.363  1.00 53.33          
ATOM   1801  CD  GLN   231      10.629  21.347  49.861  1.00 53.59          
ATOM   1802  OE1 GLN   231      10.758  20.433  50.678  1.00 52.65          
ATOM   1803  NE2 GLN   231      10.476  22.620  50.225  1.00 53.06          
ATOM   1804  N   HSD   232      14.119  18.949  46.296  1.00 52.83          
ATOM   1805  CA  HSD   232      15.516  18.668  46.014  1.00 54.59          
ATOM   1806  C   HSD   232      15.772  18.771  44.522  1.00 54.60          
ATOM   1807  O   HSD   232      16.822  19.255  44.092  1.00 55.63          
ATOM   1808  CB  HSD   232      15.883  17.271  46.496  1.00 57.52          
ATOM   1809  CG  HSD   232      15.827  17.112  47.986  1.00 61.50          
ATOM   1810  ND1 HSD   232      15.522  15.912  48.596  1.00 62.41          
ATOM   1811  CD2 HSD   232      16.055  17.995  48.991  1.00 62.97          
ATOM   1812  CE1 HSD   232      15.564  16.062  49.910  1.00 63.57          
ATOM   1813  NE2 HSD   232      15.886  17.316  50.176  1.00 63.76          
ATOM   1814  N   LEU   233      14.814  18.311  43.724  1.00 54.34          
ATOM   1815  CA  LEU   233      14.948  18.351  42.267  1.00 53.56          
ATOM   1816  C   LEU   233      14.915  19.773  41.744  1.00 53.10          
ATOM   1817  O   LEU   233      15.781  20.168  40.973  1.00 53.07          
ATOM   1818  CB  LEU   233      13.830  17.547  41.616  1.00 53.05          
ATOM   1819  CG  LEU   233      13.928  16.035  41.776  1.00 53.98          
ATOM   1820  CD1 LEU   233      12.601  15.396  41.410  1.00 54.57          
ATOM   1821  CD2 LEU   233      15.049  15.502  40.893  1.00 53.99          
ATOM   1822  N   VAL   234      13.908  20.533  42.160  1.00 53.72          
ATOM   1823  CA  VAL   234      13.772  21.911  41.720  1.00 54.50          
ATOM   1824  C   VAL   234      14.955  22.759  42.197  1.00 55.31          
ATOM   1825  O   VAL   234      15.336  23.719  41.538  1.00 55.74          
ATOM   1826  CB  VAL   234      12.433  22.518  42.204  1.00 53.90          
ATOM   1827  CG1 VAL   234      12.458  22.698  43.704  1.00 56.91          
ATOM   1828  CG2 VAL   234      12.178  23.828  41.514  1.00 54.67          
ATOM   1829  N   GLU   235      15.539  22.398  43.334  1.00 56.55          
ATOM   1830  CA  GLU   235      16.690  23.125  43.862  1.00 58.23          
ATOM   1831  C   GLU   235      17.933  22.818  43.029  1.00 58.14          
ATOM   1832  O   GLU   235      18.782  23.685  42.822  1.00 58.69          
ATOM   1833  CB  GLU   235      16.941  22.758  45.333  1.00 60.13          
ATOM   1834  CG  GLU   235      16.176  23.627  46.343  1.00 63.27          
ATOM   1835  CD  GLU   235      16.297  23.141  47.793  1.00 65.19          
ATOM   1836  OE1 GLU   235      15.981  23.935  48.716  1.00 64.07          
ATOM   1837  OE2 GLU   235      16.690  21.967  48.007  1.00 66.28          
ATOM   1838  N   GLN   236      18.039  21.584  42.548  1.00 57.92          
ATOM   1839  CA  GLN   236      19.172  21.193  41.718  1.00 58.19          
ATOM   1840  C   GLN   236      19.008  21.716  40.289  1.00 58.15          
ATOM   1841  O   GLN   236      19.696  21.276  39.366  1.00 58.41          
ATOM   1842  CB  GLN   236      19.319  19.675  41.714  1.00 57.21          
ATOM   1843  CG  GLN   236      19.913  19.154  42.992  1.00 59.59          
ATOM   1844  CD  GLN   236      19.697  17.669  43.162  1.00 62.56          
ATOM   1845  OE1 GLN   236      18.555  17.205  43.234  1.00 64.35          
ATOM   1846  NE2 GLN   236      20.791  16.909  43.237  1.00 62.86          
ATOM   1847  N   GLY   237      18.081  22.656  40.120  1.00 57.82          
ATOM   1848  CA  GLY   237      17.834  23.252  38.823  1.00 55.54          
ATOM   1849  C   GLY   237      17.242  22.339  37.777  1.00 55.47          
ATOM   1850  O   GLY   237      17.083  22.752  36.627  1.00 55.87          
ATOM   1851  N   PHE   238      16.909  21.108  38.150  1.00 54.70          
ATOM   1852  CA  PHE   238      16.333  20.175  37.186  1.00 54.43          
ATOM   1853  C   PHE   238      14.965  20.597  36.686  1.00 54.15          
ATOM   1854  O   PHE   238      14.288  19.833  36.016  1.00 54.72          
ATOM   1855  CB  PHE   238      16.248  18.776  37.778  1.00 55.06          
ATOM   1856  CG  PHE   238      17.564  18.088  37.871  1.00 55.44          
ATOM   1857  CD1 PHE   238      18.398  18.015  36.769  1.00 55.52          
ATOM   1858  CD2 PHE   238      17.956  17.473  39.050  1.00 57.40          
ATOM   1859  CE1 PHE   238      19.610  17.327  36.837  1.00 56.79          
ATOM   1860  CE2 PHE   238      19.170  16.778  39.135  1.00 58.19          
ATOM   1861  CZ  PHE   238      19.997  16.706  38.026  1.00 57.47          
ATOM   1862  N   GLU   239      14.561  21.814  37.019  1.00 54.78          
ATOM   1863  CA  GLU   239      13.286  22.357  36.580  1.00 55.30          
ATOM   1864  C   GLU   239      13.415  22.627  35.071  1.00 55.95          
ATOM   1865  O   GLU   239      14.525  22.618  34.540  1.00 56.90          
ATOM   1866  CB  GLU   239      13.040  23.654  37.338  1.00 56.17          
ATOM   1867  CG  GLU   239      11.688  24.276  37.127  1.00 58.62          
ATOM   1868  CD  GLU   239      11.557  25.627  37.821  1.00 60.91          
ATOM   1869  OE1 GLU   239      12.351  25.889  38.762  1.00 59.94          
ATOM   1870  OE2 GLU   239      10.650  26.411  37.436  1.00 60.79          
ATOM   1871  N   ALA   240      12.301  22.865  34.384  1.00 54.47          
ATOM   1872  CA  ALA   240      12.335  23.137  32.950  1.00 53.29          
ATOM   1873  C   ALA   240      12.608  21.881  32.109  1.00 52.86          
ATOM   1874  O   ALA   240      12.584  21.917  30.869  1.00 51.49          
ATOM   1875  CB  ALA   240      13.383  24.219  32.646  1.00 51.46          
ATOM   1876  N   SER   241      12.863  20.770  32.795  1.00 52.63          
ATOM   1877  CA  SER   241      13.141  19.487  32.150  1.00 52.57          
ATOM   1878  C   SER   241      11.859  18.723  31.846  1.00 52.68          
ATOM   1879  O   SER   241      10.835  18.927  32.496  1.00 53.04          
ATOM   1880  CB  SER   241      14.023  18.630  33.060  1.00 51.54          
ATOM   1881  OG  SER   241      15.177  19.335  33.450  1.00 50.84          
ATOM   1882  N   GLN   242      11.921  17.833  30.867  1.00 53.10          
ATOM   1883  CA  GLN   242      10.756  17.044  30.494  1.00 53.88          
ATOM   1884  C   GLN   242      10.242  16.263  31.687  1.00 54.11          
ATOM   1885  O   GLN   242       9.048  16.248  31.968  1.00 54.86          
ATOM   1886  CB  GLN   242      11.121  16.079  29.365  1.00 55.50          
ATOM   1887  CG  GLN   242      10.373  14.752  29.387  1.00 56.34          
ATOM   1888  CD  GLN   242      10.874  13.787  28.333  1.00 56.34          
ATOM   1889  OE1 GLN   242      12.054  13.449  28.295  1.00 56.46          
ATOM   1890  NE2 GLN   242       9.975  13.343  27.465  1.00 57.42          
ATOM   1891  N   SER   243      11.153  15.610  32.394  1.00 54.24          
ATOM   1892  CA  SER   243      10.773  14.819  33.554  1.00 53.83          
ATOM   1893  C   SER   243       9.962  15.619  34.578  1.00 54.07          
ATOM   1894  O   SER   243       8.988  15.111  35.121  1.00 53.71          
ATOM   1895  CB  SER   243      12.025  14.264  34.206  1.00 53.39          
ATOM   1896  OG  SER   243      12.933  15.318  34.435  1.00 54.65          
ATOM   1897  N   MET   244      10.358  16.866  34.835  1.00 54.91          
ATOM   1898  CA  MET   244       9.664  17.713  35.810  1.00 55.19          
ATOM   1899  C   MET   244       8.284  18.155  35.370  1.00 53.27          
ATOM   1900  O   MET   244       7.635  18.944  36.058  1.00 52.57          
ATOM   1901  CB  MET   244      10.485  18.962  36.112  1.00 60.45          
ATOM   1902  CG  MET   244      11.764  18.715  36.878  1.00 66.90          
ATOM   1903  SD  MET   244      11.481  18.227  38.722  1.00 76.91          
ATOM   1904  CE  MET   244      11.439  19.994  39.505  1.00 74.29          
ATOM   1905  N   GLN   245       7.845  17.657  34.218  1.00 52.02          
ATOM   1906  CA  GLN   245       6.538  18.002  33.662  1.00 50.21          
ATOM   1907  C   GLN   245       5.555  16.882  33.851  1.00 49.21          
ATOM   1908  O   GLN   245       4.385  17.019  33.509  1.00 49.73          
ATOM   1909  CB  GLN   245       6.667  18.312  32.173  1.00 49.10          
ATOM   1910  CG  GLN   245       7.278  19.652  31.894  1.00 48.85          
ATOM   1911  CD  GLN   245       6.407  20.759  32.420  1.00 49.81          
ATOM   1912  OE1 GLN   245       5.255  20.891  32.015  1.00 51.70          
ATOM   1913  NE2 GLN   245       6.944  21.564  33.330  1.00 50.84          
ATOM   1914  N   ALA   246       6.041  15.767  34.383  1.00 49.21          
ATOM   1915  CA  ALA   246       5.190  14.602  34.612  1.00 49.16          
ATOM   1916  C   ALA   246       4.235  14.858  35.766  1.00 48.33          
ATOM   1917  O   ALA   246       4.560  15.586  36.709  1.00 47.49          
ATOM   1918  CB  ALA   246       6.041  13.373  34.907  1.00 48.23          
ATOM   1919  N   ILE   247       3.053  14.257  35.684  1.00 47.65          
ATOM   1920  CA  ILE   247       2.060  14.423  36.725  1.00 46.43          
ATOM   1921  C   ILE   247       2.682  14.001  38.062  1.00 45.24          
ATOM   1922  O   ILE   247       3.232  12.906  38.193  1.00 43.81          
ATOM   1923  CB  ILE   247       0.783  13.592  36.405  1.00 46.72          
ATOM   1924  CG1 ILE   247       0.287  12.915  37.681  1.00 47.64          
ATOM   1925  CG2 ILE   247       1.049  12.611  35.247  1.00 46.66          
ATOM   1926  CD  ILE   247      -0.708  11.809  37.439  1.00 50.82          
ATOM   1927  N   GLY   248       2.611  14.896  39.040  1.00 44.32          
ATOM   1928  CA  GLY   248       3.194  14.618  40.338  1.00 44.63          
ATOM   1929  C   GLY   248       4.406  15.502  40.631  1.00 43.81          
ATOM   1930  O   GLY   248       4.998  15.439  41.706  1.00 43.85          
ATOM   1931  N   TYR   249       4.786  16.326  39.668  1.00 43.00          
ATOM   1932  CA  TYR   249       5.906  17.209  39.852  1.00 42.47          
ATOM   1933  C   TYR   249       5.543  18.571  39.321  1.00 44.75          
ATOM   1934  O   TYR   249       5.803  19.581  39.971  1.00 46.97          
ATOM   1935  CB  TYR   249       7.158  16.700  39.130  1.00 39.81          
ATOM   1936  CG  TYR   249       7.706  15.406  39.667  1.00 36.35          
ATOM   1937  CD1 TYR   249       7.136  14.201  39.319  1.00 35.98          
ATOM   1938  CD2 TYR   249       8.783  15.392  40.535  1.00 34.84          
ATOM   1939  CE1 TYR   249       7.625  13.006  39.818  1.00 36.42          
ATOM   1940  CE2 TYR   249       9.283  14.202  41.043  1.00 35.06          
ATOM   1941  CZ  TYR   249       8.700  13.011  40.676  1.00 35.44          
ATOM   1942  OH  TYR   249       9.197  11.819  41.146  1.00 35.17          
ATOM   1943  N   LYS   250       4.931  18.609  38.142  1.00 45.83          
ATOM   1944  CA  LYS   250       4.546  19.883  37.540  1.00 46.38          
ATOM   1945  C   LYS   250       3.497  20.619  38.381  1.00 46.13          
ATOM   1946  O   LYS   250       3.433  21.845  38.349  1.00 47.15          
ATOM   1947  CB  LYS   250       4.017  19.679  36.108  1.00 47.06          
ATOM   1948  CG  LYS   250       2.721  18.900  36.022  1.00 48.18          
ATOM   1949  CD  LYS   250       2.125  18.891  34.618  1.00 47.37          
ATOM   1950  CE  LYS   250       0.813  18.109  34.616  1.00 47.67          
ATOM   1951  NZ  LYS   250       0.166  18.049  33.283  1.00 48.34          
ATOM   1952  N   GLU   251       2.692  19.882  39.145  1.00 45.84          
ATOM   1953  CA  GLU   251       1.669  20.512  39.974  1.00 45.20          
ATOM   1954  C   GLU   251       2.257  21.083  41.245  1.00 43.71          
ATOM   1955  O   GLU   251       1.835  22.130  41.721  1.00 42.83          
ATOM   1956  CB  GLU   251       0.565  19.517  40.338  1.00 46.13          
ATOM   1957  CG  GLU   251      -0.155  18.934  39.135  1.00 48.53          
ATOM   1958  CD  GLU   251       0.410  17.596  38.709  1.00 49.88          
ATOM   1959  OE1 GLU   251       1.544  17.265  39.138  1.00 50.12          
ATOM   1960  OE2 GLU   251      -0.278  16.889  37.932  1.00 49.85          
ATOM   1961  N   LEU   252       3.245  20.390  41.788  1.00 43.53          
ATOM   1962  CA  LEU   252       3.886  20.831  43.012  1.00 42.57          
ATOM   1963  C   LEU   252       4.928  21.922  42.821  1.00 42.00          
ATOM   1964  O   LEU   252       5.227  22.648  43.756  1.00 42.30          
ATOM   1965  CB  LEU   252       4.512  19.635  43.736  1.00 41.74          
ATOM   1966  CG  LEU   252       3.547  18.511  44.150  1.00 41.92          
ATOM   1967  CD1 LEU   252       4.312  17.378  44.828  1.00 42.76          
ATOM   1968  CD2 LEU   252       2.494  19.048  45.086  1.00 40.89          
ATOM   1969  N   VAL   253       5.494  22.055  41.630  1.00 42.00          
ATOM   1970  CA  VAL   253       6.506  23.098  41.440  1.00 42.95          
ATOM   1971  C   VAL   253       5.957  24.484  41.772  1.00 44.10          
ATOM   1972  O   VAL   253       6.607  25.265  42.460  1.00 44.41          
ATOM   1973  CB  VAL   253       7.078  23.119  39.992  1.00 41.99          
ATOM   1974  CG1 VAL   253       8.115  24.221  39.854  1.00 39.96          
ATOM   1975  CG2 VAL   253       7.720  21.787  39.669  1.00 42.77          
ATOM   1976  N   PRO   254       4.743  24.805  41.291  1.00 45.20          
ATOM   1977  CA  PRO   254       4.124  26.111  41.551  1.00 45.81          
ATOM   1978  C   PRO   254       3.925  26.422  43.034  1.00 45.87          
ATOM   1979  O   PRO   254       4.113  27.558  43.471  1.00 46.34          
ATOM   1980  CB  PRO   254       2.789  26.018  40.804  1.00 45.36          
ATOM   1981  CG  PRO   254       3.108  25.114  39.670  1.00 45.40          
ATOM   1982  CD  PRO   254       3.917  24.032  40.348  1.00 46.25          
ATOM   1983  N   VAL   255       3.555  25.407  43.804  1.00 45.65          
ATOM   1984  CA  VAL   255       3.323  25.591  45.224  1.00 46.52          
ATOM   1985  C   VAL   255       4.634  25.881  45.971  1.00 45.46          
ATOM   1986  O   VAL   255       4.631  26.462  47.057  1.00 44.66          
ATOM   1987  CB  VAL   255       2.562  24.354  45.825  1.00 46.99          
ATOM   1988  CG1 VAL   255       3.439  23.133  45.793  1.00 48.49          
ATOM   1989  CG2 VAL   255       2.109  24.654  47.237  1.00 49.86          
ATOM   1990  N   ILE   256       5.751  25.507  45.362  1.00 45.49          
ATOM   1991  CA  ILE   256       7.056  25.745  45.954  1.00 46.29          
ATOM   1992  C   ILE   256       7.435  27.214  45.784  1.00 47.82          
ATOM   1993  O   ILE   256       8.270  27.754  46.516  1.00 48.39          
ATOM   1994  CB  ILE   256       8.130  24.897  45.280  1.00 46.02          
ATOM   1995  CG1 ILE   256       7.762  23.427  45.383  1.00 47.63          
ATOM   1996  CG2 ILE   256       9.468  25.123  45.943  1.00 46.15          
ATOM   1997  CD  ILE   256       8.770  22.513  44.697  1.00 47.88          
ATOM   1998  N   LYS   257       6.808  27.856  44.811  1.00 47.54          
ATOM   1999  CA  LYS   257       7.057  29.256  44.529  1.00 48.04          
ATOM   2000  C   LYS   257       6.095  30.144  45.315  1.00 47.94          
ATOM   2001  O   LYS   257       6.389  31.307  45.602  1.00 48.31          
ATOM   2002  CB  LYS   257       6.926  29.490  43.023  1.00 49.79          
ATOM   2003  CG  LYS   257       7.852  28.570  42.220  1.00 51.05          
ATOM   2004  CD  LYS   257       7.865  28.896  40.744  1.00 51.18          
ATOM   2005  CE  LYS   257       8.949  28.114  40.016  1.00 52.26          
ATOM   2006  NZ  LYS   257       8.908  28.350  38.537  1.00 51.23          
ATOM   2007  N   GLY   258       4.946  29.582  45.669  1.00 46.79          
ATOM   2008  CA  GLY   258       3.973  30.325  46.436  1.00 45.83          
ATOM   2009  C   GLY   258       2.921  30.953  45.554  1.00 45.01          
ATOM   2010  O   GLY   258       2.265  31.921  45.944  1.00 44.91          
ATOM   2011  N   ASN   259       2.756  30.414  44.356  1.00 43.60          
ATOM   2012  CA  ASN   259       1.757  30.948  43.445  1.00 43.75          
ATOM   2013  C   ASN   259       0.458  30.169  43.563  1.00 43.71          
ATOM   2014  O   ASN   259      -0.609  30.661  43.208  1.00 42.68          
ATOM   2015  CB  ASN   259       2.277  30.909  42.009  1.00 43.72          
ATOM   2016  CG  ASN   259       3.456  31.826  41.802  1.00 44.15          
ATOM   2017  OD1 ASN   259       4.545  31.383  41.428  1.00 45.04          
ATOM   2018  ND2 ASN   259       3.254  33.113  42.060  1.00 43.19          
ATOM   2019  N   ILE   260       0.550  28.954  44.081  1.00 43.37          
ATOM   2020  CA  ILE   260      -0.637  28.137  44.252  1.00 43.46          
ATOM   2021  C   ILE   260      -0.611  27.477  45.638  1.00 43.92          
ATOM   2022  O   ILE   260       0.465  27.206  46.190  1.00 42.74          
ATOM   2023  CB  ILE   260      -0.726  27.095  43.115  1.00 43.21          
ATOM   2024  CG1 ILE   260      -1.974  26.234  43.282  1.00 43.70          
ATOM   2025  CG2 ILE   260       0.541  26.255  43.068  1.00 43.86          
ATOM   2026  CD  ILE   260      -2.181  25.234  42.160  1.00 44.18          
ATOM   2027  N   SER   261      -1.789  27.245  46.219  1.00 44.15          
ATOM   2028  CA  SER   261      -1.874  26.646  47.560  1.00 44.65          
ATOM   2029  C   SER   261      -1.703  25.141  47.512  1.00 44.60          
ATOM   2030  O   SER   261      -2.022  24.509  46.516  1.00 44.23          
ATOM   2031  CB  SER   261      -3.218  26.984  48.215  1.00 43.24          
ATOM   2032  OG  SER   261      -4.290  26.404  47.507  1.00 43.70          
ATOM   2033  N   MET   262      -1.201  24.572  48.599  1.00 46.15          
ATOM   2034  CA  MET   262      -0.993  23.135  48.663  1.00 47.95          
ATOM   2035  C   MET   262      -2.303  22.393  48.419  1.00 46.17          
ATOM   2036  O   MET   262      -2.341  21.413  47.676  1.00 45.54          
ATOM   2037  CB  MET   262      -0.418  22.746  50.029  1.00 51.56          
ATOM   2038  CG  MET   262      -0.078  21.262  50.196  1.00 56.73          
ATOM   2039  SD  MET   262       1.519  20.694  49.227  1.00 68.54          
ATOM   2040  CE  MET   262       0.661  20.288  47.543  1.00 64.64          
ATOM   2041  N   GLU   263      -3.376  22.871  49.040  1.00 45.51          
ATOM   2042  CA  GLU   263      -4.690  22.247  48.899  1.00 45.04          
ATOM   2043  C   GLU   263      -5.118  22.133  47.447  1.00 44.37          
ATOM   2044  O   GLU   263      -5.347  21.035  46.935  1.00 42.41          
ATOM   2045  CB  GLU   263      -5.738  23.045  49.678  1.00 45.88          
ATOM   2046  CG  GLU   263      -5.523  23.008  51.187  1.00 48.51          
ATOM   2047  CD  GLU   263      -4.644  24.132  51.716  1.00 50.02          
ATOM   2048  OE1 GLU   263      -4.298  24.079  52.917  1.00 50.44          
ATOM   2049  OE2 GLU   263      -4.319  25.069  50.948  1.00 51.15          
ATOM   2050  N   ASN   264      -5.226  23.289  46.798  1.00 44.68          
ATOM   2051  CA  ASN   264      -5.613  23.378  45.397  1.00 44.86          
ATOM   2052  C   ASN   264      -4.731  22.509  44.490  1.00 44.40          
ATOM   2053  O   ASN   264      -5.232  21.786  43.621  1.00 44.99          
ATOM   2054  CB  ASN   264      -5.571  24.840  44.954  1.00 45.20          
ATOM   2055  CG  ASN   264      -6.725  25.644  45.526  1.00 47.47          
ATOM   2056  OD1 ASN   264      -6.823  26.848  45.318  1.00 47.36          
ATOM   2057  ND2 ASN   264      -7.620  24.967  46.247  1.00 49.46          
ATOM   2058  N   ALA   265      -3.422  22.574  44.707  1.00 43.68          
ATOM   2059  CA  ALA   265      -2.468  21.794  43.935  1.00 42.84          
ATOM   2060  C   ALA   265      -2.749  20.305  44.092  1.00 42.53          
ATOM   2061  O   ALA   265      -2.871  19.580  43.103  1.00 42.36          
ATOM   2062  CB  ALA   265      -1.052  22.109  44.390  1.00 42.55          
ATOM   2063  N   VAL   266      -2.843  19.841  45.331  1.00 42.41          
ATOM   2064  CA  VAL   266      -3.108  18.434  45.571  1.00 43.43          
ATOM   2065  C   VAL   266      -4.404  18.022  44.900  1.00 44.60          
ATOM   2066  O   VAL   266      -4.527  16.904  44.404  1.00 44.52          
ATOM   2067  CB  VAL   266      -3.202  18.130  47.074  1.00 44.20          
ATOM   2068  CG1 VAL   266      -3.556  16.660  47.287  1.00 42.88          
ATOM   2069  CG2 VAL   266      -1.875  18.457  47.741  1.00 43.74          
ATOM   2070  N   GLU   267      -5.373  18.931  44.890  1.00 46.48          
ATOM   2071  CA  GLU   267      -6.658  18.660  44.259  1.00 47.56          
ATOM   2072  C   GLU   267      -6.456  18.351  42.774  1.00 47.85          
ATOM   2073  O   GLU   267      -7.092  17.447  42.222  1.00 47.49          
ATOM   2074  CB  GLU   267      -7.572  19.865  44.396  1.00 49.81          
ATOM   2075  CG  GLU   267      -8.763  19.766  43.492  1.00 55.10          
ATOM   2076  CD  GLU   267     -10.067  19.881  44.229  1.00 58.36          
ATOM   2077  OE1 GLU   267     -10.443  21.026  44.578  1.00 60.03          
ATOM   2078  OE2 GLU   267     -10.697  18.825  44.483  1.00 60.12          
ATOM   2079  N   LYS   268      -5.566  19.113  42.135  1.00 47.95          
ATOM   2080  CA  LYS   268      -5.262  18.927  40.722  1.00 48.04          
ATOM   2081  C   LYS   268      -4.369  17.712  40.488  1.00 47.98          
ATOM   2082  O   LYS   268      -4.441  17.072  39.438  1.00 48.31          
ATOM   2083  CB  LYS   268      -4.604  20.187  40.154  1.00 47.51          
ATOM   2084  CG  LYS   268      -5.534  21.394  40.148  1.00 49.27          
ATOM   2085  CD  LYS   268      -4.978  22.558  39.331  1.00 50.77          
ATOM   2086  CE  LYS   268      -3.645  23.070  39.900  1.00 51.57          
ATOM   2087  NZ  LYS   268      -3.096  24.265  39.171  1.00 50.01          
ATOM   2088  N   LEU   269      -3.529  17.396  41.470  1.00 48.23          
ATOM   2089  CA  LEU   269      -2.643  16.242  41.371  1.00 47.71          
ATOM   2090  C   LEU   269      -3.442  14.928  41.365  1.00 47.84          
ATOM   2091  O   LEU   269      -3.144  14.018  40.591  1.00 47.71          
ATOM   2092  CB  LEU   269      -1.637  16.252  42.532  1.00 46.71          
ATOM   2093  CG  LEU   269      -0.758  15.019  42.762  1.00 45.77          
ATOM   2094  CD1 LEU   269      -0.011  14.668  41.499  1.00 46.01          
ATOM   2095  CD2 LEU   269       0.216  15.295  43.894  1.00 45.49          
ATOM   2096  N   LYS   270      -4.456  14.827  42.221  1.00 47.27          
ATOM   2097  CA  LYS   270      -5.276  13.617  42.276  1.00 47.21          
ATOM   2098  C   LYS   270      -6.162  13.535  41.038  1.00 47.74          
ATOM   2099  O   LYS   270      -6.550  12.448  40.614  1.00 47.84          
ATOM   2100  CB  LYS   270      -6.160  13.615  43.523  1.00 46.87          
ATOM   2101  CG  LYS   270      -5.398  13.685  44.847  1.00 45.75          
ATOM   2102  CD  LYS   270      -6.354  13.642  46.036  1.00 43.37          
ATOM   2103  CE  LYS   270      -5.619  13.777  47.346  1.00 42.55          
ATOM   2104  NZ  LYS   270      -6.516  13.481  48.479  1.00 42.55          
ATOM   2105  N   GLN   271      -6.491  14.689  40.466  1.00 47.50          
ATOM   2106  CA  GLN   271      -7.318  14.706  39.279  1.00 47.55          
ATOM   2107  C   GLN   271      -6.498  14.205  38.090  1.00 46.89          
ATOM   2108  O   GLN   271      -6.837  13.186  37.493  1.00 48.08          
ATOM   2109  CB  GLN   271      -7.846  16.116  39.008  1.00 50.10          
ATOM   2110  CG  GLN   271      -9.040  16.129  38.072  1.00 51.28          
ATOM   2111  CD  GLN   271      -9.270  17.471  37.406  1.00 51.63          
ATOM   2112  OE1 GLN   271     -10.281  17.664  36.729  1.00 51.74          
ATOM   2113  NE2 GLN   271      -8.332  18.401  37.585  1.00 51.56          
ATOM   2114  N   HSD   272      -5.418  14.908  37.746  1.00 45.28          
ATOM   2115  CA  HSD   272      -4.553  14.493  36.629  1.00 42.45          
ATOM   2116  C   HSD   272      -4.225  13.007  36.753  1.00 40.81          
ATOM   2117  O   HSD   272      -4.041  12.325  35.754  1.00 39.84          
ATOM   2118  CB  HSD   272      -3.221  15.258  36.637  1.00 43.50          
ATOM   2119  CG  HSD   272      -3.334  16.704  36.277  1.00 45.07          
ATOM   2120  ND1 HSD   272      -4.092  17.599  36.999  1.00 45.43          
ATOM   2121  CD2 HSD   272      -2.752  17.416  35.286  1.00 46.21          
ATOM   2122  CE1 HSD   272      -3.972  18.803  36.470  1.00 45.55          
ATOM   2123  NE2 HSD   272      -3.164  18.719  35.430  1.00 46.84          
ATOM   2124  N   SER   273      -4.126  12.519  37.989  1.00 38.20          
ATOM   2125  CA  SER   273      -3.803  11.130  38.213  1.00 35.52          
ATOM   2126  C   SER   273      -4.983  10.267  37.835  1.00 35.68          
ATOM   2127  O   SER   273      -4.811   9.191  37.264  1.00 35.30          
ATOM   2128  CB  SER   273      -3.412  10.895  39.668  1.00 35.90          
ATOM   2129  OG  SER   273      -2.188  11.530  39.993  1.00 32.29          
ATOM   2130  N   ARG   274      -6.187  10.727  38.149  1.00 35.75          
ATOM   2131  CA  ARG   274      -7.390   9.969  37.802  1.00 36.75          
ATOM   2132  C   ARG   274      -7.588   9.937  36.285  1.00 37.28          
ATOM   2133  O   ARG   274      -7.869   8.888  35.722  1.00 38.52          
ATOM   2134  CB  ARG   274      -8.637  10.580  38.459  1.00 36.95          
ATOM   2135  CG  ARG   274      -8.698  10.466  39.974  1.00 36.82          
ATOM   2136  CD  ARG   274     -10.054  10.929  40.488  1.00 36.70          
ATOM   2137  NE  ARG   274     -10.274  12.356  40.263  1.00 38.35          
ATOM   2138  CZ  ARG   274     -10.032  13.306  41.167  1.00 38.14          
ATOM   2139  NH1 ARG   274      -9.561  12.981  42.363  1.00 36.22          
ATOM   2140  NH2 ARG   274     -10.264  14.582  40.878  1.00 37.03          
ATOM   2141  N   GLN   275      -7.443  11.086  35.629  1.00 38.05          
ATOM   2142  CA  GLN   275      -7.617  11.169  34.183  1.00 38.52          
ATOM   2143  C   GLN   275      -6.583  10.312  33.478  1.00 38.01          
ATOM   2144  O   GLN   275      -6.896   9.574  32.543  1.00 39.39          
ATOM   2145  CB  GLN   275      -7.474  12.608  33.709  1.00 40.25          
ATOM   2146  CG  GLN   275      -8.511  13.556  34.284  1.00 43.98          
ATOM   2147  CD  GLN   275      -8.149  15.020  34.056  1.00 46.35          
ATOM   2148  OE1 GLN   275      -7.853  15.427  32.936  1.00 48.91          
ATOM   2149  NE2 GLN   275      -8.177  15.816  35.123  1.00 47.14          
ATOM   2150  N   TYR   276      -5.344  10.411  33.934  1.00 36.36          
ATOM   2151  CA  TYR   276      -4.262   9.650  33.344  1.00 35.31          
ATOM   2152  C   TYR   276      -4.531   8.157  33.426  1.00 34.41          
ATOM   2153  O   TYR   276      -4.445   7.449  32.430  1.00 33.63          
ATOM   2154  CB  TYR   276      -2.950  10.005  34.050  1.00 35.75          
ATOM   2155  CG  TYR   276      -1.751   9.236  33.559  1.00 36.20          
ATOM   2156  CD1 TYR   276      -1.464   7.966  34.054  1.00 36.58          
ATOM   2157  CD2 TYR   276      -0.903   9.778  32.600  1.00 35.33          
ATOM   2158  CE1 TYR   276      -0.358   7.257  33.609  1.00 37.87          
ATOM   2159  CE2 TYR   276       0.202   9.082  32.142  1.00 36.76          
ATOM   2160  CZ  TYR   276       0.473   7.820  32.654  1.00 38.26          
ATOM   2161  OH  TYR   276       1.582   7.126  32.231  1.00 40.41          
ATOM   2162  N   ALA   277      -4.858   7.685  34.619  1.00 34.89          
ATOM   2163  CA  ALA   277      -5.136   6.275  34.828  1.00 36.30          
ATOM   2164  C   ALA   277      -6.255   5.819  33.905  1.00 38.00          
ATOM   2165  O   ALA   277      -6.225   4.706  33.376  1.00 36.91          
ATOM   2166  CB  ALA   277      -5.530   6.026  36.276  1.00 35.53          
ATOM   2167  N   LYS   278      -7.251   6.679  33.723  1.00 40.20          
ATOM   2168  CA  LYS   278      -8.383   6.359  32.865  1.00 42.32          
ATOM   2169  C   LYS   278      -7.949   6.259  31.429  1.00 43.49          
ATOM   2170  O   LYS   278      -8.225   5.263  30.762  1.00 44.62          
ATOM   2171  CB  LYS   278      -9.477   7.419  32.990  1.00 43.95          
ATOM   2172  CG  LYS   278     -10.619   7.243  31.998  1.00 46.27          
ATOM   2173  CD  LYS   278     -11.846   8.053  32.398  1.00 49.97          
ATOM   2174  CE  LYS   278     -13.027   7.776  31.461  1.00 51.38          
ATOM   2175  NZ  LYS   278     -14.346   8.206  32.045  1.00 53.63          
ATOM   2176  N   ARG   279      -7.271   7.296  30.948  1.00 44.33          
ATOM   2177  CA  ARG   279      -6.798   7.321  29.561  1.00 45.32          
ATOM   2178  C   ARG   279      -5.950   6.079  29.228  1.00 45.13          
ATOM   2179  O   ARG   279      -6.048   5.529  28.134  1.00 44.57          
ATOM   2180  CB  ARG   279      -6.008   8.619  29.301  1.00 47.62          
ATOM   2181  CG  ARG   279      -5.490   8.795  27.863  1.00 50.39          
ATOM   2182  CD  ARG   279      -5.468  10.270  27.446  1.00 53.84          
ATOM   2183  NE  ARG   279      -4.936  11.132  28.466  1.00 57.92          
ATOM   2184  CZ  ARG   279      -5.349  12.289  28.988  1.00 58.57          
ATOM   2185  NH1 ARG   279      -4.546  12.767  29.919  1.00 59.22          
ATOM   2186  NH2 ARG   279      -6.458  12.959  28.669  1.00 58.05          
ATOM   2187  N   GLN   280      -5.142   5.629  30.186  1.00 44.54          
ATOM   2188  CA  GLN   280      -4.299   4.466  29.979  1.00 42.49          
ATOM   2189  C   GLN   280      -5.092   3.179  29.965  1.00 42.31          
ATOM   2190  O   GLN   280      -4.725   2.219  29.298  1.00 42.76          
ATOM   2191  CB  GLN   280      -3.229   4.386  31.065  1.00 41.79          
ATOM   2192  CG  GLN   280      -1.842   4.200  30.515  1.00 42.04          
ATOM   2193  CD  GLN   280      -1.452   5.345  29.597  1.00 42.96          
ATOM   2194  OE1 GLN   280      -0.920   5.137  28.501  1.00 41.69          
ATOM   2195  NE2 GLN   280      -1.723   6.569  30.040  1.00 42.65          
ATOM   2196  N   LEU   281      -6.177   3.149  30.720  1.00 43.60          
ATOM   2197  CA  LEU   281      -7.005   1.954  30.795  1.00 44.86          
ATOM   2198  C   LEU   281      -7.760   1.866  29.474  1.00 46.02          
ATOM   2199  O   LEU   281      -7.866   0.798  28.873  1.00 46.62          
ATOM   2200  CB  LEU   281      -7.986   2.084  31.964  1.00 46.05          
ATOM   2201  CG  LEU   281      -8.521   0.834  32.659  1.00 47.29          
ATOM   2202  CD1 LEU   281      -9.210  -0.042  31.635  1.00 48.02          
ATOM   2203  CD2 LEU   281      -7.383   0.073  33.349  1.00 47.94          
ATOM   2204  N   THR   282      -8.259   3.012  29.018  1.00 46.51          
ATOM   2205  CA  THR   282      -9.011   3.086  27.779  1.00 46.62          
ATOM   2206  C   THR   282      -8.209   2.592  26.578  1.00 47.68          
ATOM   2207  O   THR   282      -8.715   1.818  25.766  1.00 48.50          
ATOM   2208  CB  THR   282      -9.477   4.525  27.521  1.00 46.54          
ATOM   2209  OG1 THR   282     -10.263   4.981  28.627  1.00 44.95          
ATOM   2210  CG2 THR   282     -10.313   4.591  26.265  1.00 48.15          
ATOM   2211  N   TRP   283      -6.960   3.041  26.478  1.00 49.10          
ATOM   2212  CA  TRP   283      -6.054   2.668  25.387  1.00 48.96          
ATOM   2213  C   TRP   283      -5.796   1.160  25.333  1.00 48.30          
ATOM   2214  O   TRP   283      -5.877   0.555  24.268  1.00 48.47          
ATOM   2215  CB  TRP   283      -4.710   3.386  25.551  1.00 50.31          
ATOM   2216  CG  TRP   283      -3.929   3.535  24.282  1.00 53.10          
ATOM   2217  CD1 TRP   283      -3.892   4.632  23.471  1.00 53.65          
ATOM   2218  CD2 TRP   283      -3.116   2.541  23.645  1.00 53.31          
ATOM   2219  NE1 TRP   283      -3.107   4.384  22.379  1.00 53.64          
ATOM   2220  CE2 TRP   283      -2.611   3.113  22.464  1.00 53.34          
ATOM   2221  CE3 TRP   283      -2.748   1.233  23.970  1.00 54.28          
ATOM   2222  CZ2 TRP   283      -1.788   2.417  21.588  1.00 55.15          
ATOM   2223  CZ3 TRP   283      -1.924   0.534  23.101  1.00 54.82          
ATOM   2224  CH2 TRP   283      -1.443   1.133  21.924  1.00 55.31          
ATOM   2225  N   PHE   284      -5.472   0.568  26.480  1.00 47.17          
ATOM   2226  CA  PHE   284      -5.194  -0.858  26.554  1.00 45.95          
ATOM   2227  C   PHE   284      -6.413  -1.712  26.276  1.00 46.16          
ATOM   2228  O   PHE   284      -6.318  -2.934  26.213  1.00 47.88          
ATOM   2229  CB  PHE   284      -4.607  -1.229  27.922  1.00 42.99          
ATOM   2230  CG  PHE   284      -3.119  -1.052  28.005  1.00 40.18          
ATOM   2231  CD1 PHE   284      -2.281  -1.783  27.178  1.00 38.71          
ATOM   2232  CD2 PHE   284      -2.555  -0.133  28.888  1.00 40.20          
ATOM   2233  CE1 PHE   284      -0.906  -1.610  27.230  1.00 38.81          
ATOM   2234  CE2 PHE   284      -1.174   0.054  28.951  1.00 38.51          
ATOM   2235  CZ  PHE   284      -0.352  -0.684  28.118  1.00 39.99          
ATOM   2236  N   LYS   285      -7.569  -1.093  26.111  1.00 46.47          
ATOM   2237  CA  LYS   285      -8.747  -1.884  25.829  1.00 47.62          
ATOM   2238  C   LYS   285      -9.215  -1.695  24.405  1.00 48.73          
ATOM   2239  O   LYS   285      -9.863  -2.571  23.847  1.00 49.63          
ATOM   2240  CB  LYS   285      -9.860  -1.528  26.789  1.00 47.52          
ATOM   2241  CG  LYS   285      -9.475  -1.804  28.215  1.00 49.56          
ATOM   2242  CD  LYS   285     -10.683  -1.752  29.140  1.00 51.10          
ATOM   2243  CE  LYS   285     -11.397  -3.104  29.245  1.00 51.69          
ATOM   2244  NZ  LYS   285     -10.700  -4.102  30.117  1.00 51.69          
ATOM   2245  N   ASN   286      -8.868  -0.558  23.814  1.00 49.04          
ATOM   2246  CA  ASN   286      -9.260  -0.247  22.453  1.00 50.46          
ATOM   2247  C   ASN   286      -8.121  -0.338  21.443  1.00 50.96          
ATOM   2248  O   ASN   286      -8.236   0.171  20.333  1.00 51.83          
ATOM   2249  CB  ASN   286      -9.847   1.164  22.407  1.00 52.33          
ATOM   2250  CG  ASN   286     -11.065   1.320  23.282  1.00 54.53          
ATOM   2251  OD1 ASN   286     -11.519   2.441  23.545  1.00 55.13          
ATOM   2252  ND2 ASN   286     -11.610   0.197  23.740  1.00 55.49          
ATOM   2253  N   LYS   287      -7.020  -0.974  21.809  1.00 49.95          
ATOM   2254  CA  LYS   287      -5.896  -1.048  20.890  1.00 50.52          
ATOM   2255  C   LYS   287      -5.153  -2.352  21.034  1.00 51.97          
ATOM   2256  O   LYS   287      -4.591  -2.877  20.072  1.00 52.44          
ATOM   2257  CB  LYS   287      -4.909   0.091  21.161  1.00 50.17          
ATOM   2258  CG  LYS   287      -5.476   1.494  21.098  1.00 48.41          
ATOM   2259  CD  LYS   287      -5.691   1.932  19.669  1.00 49.42          
ATOM   2260  CE  LYS   287      -5.956   3.434  19.586  1.00 50.59          
ATOM   2261  NZ  LYS   287      -4.832   4.254  20.139  1.00 50.42          
ATOM   2262  N   MET   288      -5.140  -2.869  22.252  1.00 54.12          
ATOM   2263  CA  MET   288      -4.431  -4.106  22.540  1.00 56.02          
ATOM   2264  C   MET   288      -5.382  -5.213  22.882  1.00 54.23          
ATOM   2265  O   MET   288      -6.522  -4.988  23.288  1.00 53.68          
ATOM   2266  CB  MET   288      -3.501  -3.926  23.735  1.00 61.19          
ATOM   2267  CG  MET   288      -2.671  -2.667  23.730  1.00 67.84          
ATOM   2268  SD  MET   288      -1.138  -2.799  22.617  1.00 79.05          
ATOM   2269  CE  MET   288       0.044  -3.697  23.862  1.00 75.12          
ATOM   2270  N   ASN   289      -4.886  -6.422  22.726  1.00 53.34          
ATOM   2271  CA  ASN   289      -5.667  -7.579  23.057  1.00 53.29          
ATOM   2272  C   ASN   289      -5.017  -8.084  24.333  1.00 50.83          
ATOM   2273  O   ASN   289      -4.131  -8.932  24.302  1.00 49.74          
ATOM   2274  CB  ASN   289      -5.564  -8.625  21.953  1.00 56.36          
ATOM   2275  CG  ASN   289      -6.458  -9.808  22.210  1.00 58.29          
ATOM   2276  OD1 ASN   289      -7.680  -9.659  22.324  1.00 58.96          
ATOM   2277  ND2 ASN   289      -5.863 -10.994  22.316  1.00 59.23          
ATOM   2278  N   VAL   290      -5.446  -7.523  25.453  1.00 48.80          
ATOM   2279  CA  VAL   290      -4.910  -7.887  26.751  1.00 47.23          
ATOM   2280  C   VAL   290      -5.792  -8.891  27.489  1.00 45.86          
ATOM   2281  O   VAL   290      -7.021  -8.836  27.398  1.00 44.14          
ATOM   2282  CB  VAL   290      -4.785  -6.651  27.664  1.00 46.63          
ATOM   2283  CG1 VAL   290      -4.015  -7.007  28.914  1.00 46.42          
ATOM   2284  CG2 VAL   290      -4.128  -5.517  26.915  1.00 46.08          
ATOM   2285  N   HSD   291      -5.153  -9.801  28.228  1.00 45.26          
ATOM   2286  CA  HSD   291      -5.853 -10.808  29.039  1.00 43.68          
ATOM   2287  C   HSD   291      -5.984 -10.136  30.408  1.00 41.95          
ATOM   2288  O   HSD   291      -5.090 -10.212  31.242  1.00 41.42          
ATOM   2289  CB  HSD   291      -5.017 -12.093  29.139  1.00 45.12          
ATOM   2290  CG  HSD   291      -5.728 -13.236  29.801  1.00 47.50          
ATOM   2291  ND1 HSD   291      -6.067 -13.231  31.137  1.00 49.19          
ATOM   2292  CD2 HSD   291      -6.129 -14.434  29.315  1.00 48.36          
ATOM   2293  CE1 HSD   291      -6.643 -14.379  31.450  1.00 48.95          
ATOM   2294  NE2 HSD   291      -6.692 -15.126  30.362  1.00 49.58          
ATOM   2295  N   TRP   292      -7.105  -9.462  30.613  1.00 40.90          
ATOM   2296  CA  TRP   292      -7.368  -8.742  31.843  1.00 40.61          
ATOM   2297  C   TRP   292      -7.686  -9.607  33.055  1.00 40.95          
ATOM   2298  O   TRP   292      -8.454 -10.557  32.958  1.00 41.63          
ATOM   2299  CB  TRP   292      -8.526  -7.771  31.636  1.00 40.25          
ATOM   2300  CG  TRP   292      -8.274  -6.779  30.563  1.00 39.85          
ATOM   2301  CD1 TRP   292      -8.661  -6.855  29.260  1.00 38.13          
ATOM   2302  CD2 TRP   292      -7.531  -5.564  30.696  1.00 40.33          
ATOM   2303  NE1 TRP   292      -8.205  -5.752  28.571  1.00 39.14          
ATOM   2304  CE2 TRP   292      -7.509  -4.945  29.429  1.00 40.04          
ATOM   2305  CE3 TRP   292      -6.886  -4.937  31.769  1.00 40.44          
ATOM   2306  CZ2 TRP   292      -6.859  -3.733  29.200  1.00 40.75          
ATOM   2307  CZ3 TRP   292      -6.241  -3.732  31.548  1.00 40.21          
ATOM   2308  CH2 TRP   292      -6.234  -3.139  30.268  1.00 42.10          
ATOM   2309  N   LEU   293      -7.089  -9.257  34.196  1.00 41.00          
ATOM   2310  CA  LEU   293      -7.307  -9.933  35.475  1.00 40.14          
ATOM   2311  C   LEU   293      -8.026  -8.905  36.313  1.00 40.38          
ATOM   2312  O   LEU   293      -7.472  -7.843  36.581  1.00 40.60          
ATOM   2313  CB  LEU   293      -5.984 -10.274  36.154  1.00 38.82          
ATOM   2314  CG  LEU   293      -5.110 -11.199  35.326  1.00 39.72          
ATOM   2315  CD1 LEU   293      -3.797 -11.494  36.031  1.00 38.67          
ATOM   2316  CD2 LEU   293      -5.895 -12.473  35.064  1.00 40.48          
ATOM   2317  N   ASN   294      -9.250  -9.211  36.730  1.00 42.06          
ATOM   2318  CA  ASN   294     -10.041  -8.275  37.536  1.00 42.99          
ATOM   2319  C   ASN   294      -9.539  -8.244  38.994  1.00 42.40          
ATOM   2320  O   ASN   294      -9.800  -9.147  39.767  1.00 43.13          
ATOM   2321  CB  ASN   294     -11.521  -8.682  37.457  1.00 43.12          
ATOM   2322  CG  ASN   294     -12.457  -7.637  38.043  1.00 43.42          
ATOM   2323  OD1 ASN   294     -13.669  -7.699  37.821  1.00 44.84          
ATOM   2324  ND2 ASN   294     -11.906  -6.680  38.800  1.00 41.98          
ATOM   2325  N   LYS   295      -8.811  -7.194  39.348  1.00 43.13          
ATOM   2326  CA  LYS   295      -8.253  -7.047  40.677  1.00 44.01          
ATOM   2327  C   LYS   295      -9.313  -7.034  41.774  1.00 47.25          
ATOM   2328  O   LYS   295      -9.015  -7.299  42.942  1.00 48.02          
ATOM   2329  CB  LYS   295      -7.446  -5.766  40.753  1.00 42.24          
ATOM   2330  CG  LYS   295      -6.686  -5.590  42.016  1.00 42.84          
ATOM   2331  CD  LYS   295      -6.654  -4.138  42.427  1.00 41.97          
ATOM   2332  CE  LYS   295      -5.265  -3.736  42.874  1.00 42.08          
ATOM   2333  NZ  LYS   295      -4.617  -4.779  43.697  1.00 40.12          
ATOM   2334  N   GLU   296     -10.554  -6.736  41.414  1.00 49.88          
ATOM   2335  CA  GLU   296     -11.635  -6.700  42.395  1.00 52.31          
ATOM   2336  C   GLU   296     -12.243  -8.072  42.657  1.00 52.26          
ATOM   2337  O   GLU   296     -13.304  -8.179  43.273  1.00 53.05          
ATOM   2338  CB  GLU   296     -12.728  -5.742  41.914  1.00 54.20          
ATOM   2339  CG  GLU   296     -12.342  -4.282  41.971  1.00 57.99          
ATOM   2340  CD  GLU   296     -13.383  -3.378  41.337  1.00 60.64          
ATOM   2341  OE1 GLU   296     -13.255  -2.139  41.457  1.00 62.59          
ATOM   2342  OE2 GLU   296     -14.328  -3.905  40.710  1.00 60.61          
ATOM   2343  N   ARG   297     -11.552  -9.115  42.213  1.00 52.15          
ATOM   2344  CA  ARG   297     -12.045 -10.478  42.350  1.00 52.31          
ATOM   2345  C   ARG   297     -10.908 -11.491  42.500  1.00 50.64          
ATOM   2346  O   ARG   297     -11.123 -12.649  42.850  1.00 49.87          
ATOM   2347  CB  ARG   297     -12.922 -10.796  41.124  1.00 53.68          
ATOM   2348  CG  ARG   297     -13.339 -12.235  40.948  1.00 58.16          
ATOM   2349  CD  ARG   297     -12.319 -12.955  40.102  1.00 62.33          
ATOM   2350  NE  ARG   297     -12.864 -14.119  39.483  1.00 67.18          
ATOM   2351  CZ  ARG   297     -12.451 -15.380  39.413  1.00 69.01          
ATOM   2352  NH1 ARG   297     -11.343 -15.881  39.961  1.00 68.90          
ATOM   2353  NH2 ARG   297     -13.246 -16.161  38.703  1.00 69.75          
ATOM   2354  N   MET   298      -9.693 -11.038  42.250  1.00 49.65          
ATOM   2355  CA  MET   298      -8.541 -11.903  42.356  1.00 50.50          
ATOM   2356  C   MET   298      -7.472 -11.290  43.238  1.00 48.11          
ATOM   2357  O   MET   298      -7.401 -10.075  43.404  1.00 47.23          
ATOM   2358  CB  MET   298      -7.949 -12.163  40.986  1.00 56.16          
ATOM   2359  CG  MET   298      -8.803 -13.028  40.098  1.00 64.13          
ATOM   2360  SD  MET   298      -7.976 -13.256  38.354  1.00 73.14          
ATOM   2361  CE  MET   298      -9.250 -12.214  37.289  1.00 70.76          
ATOM   2362  N   SER   299      -6.617 -12.143  43.776  1.00 44.79          
ATOM   2363  CA  SER   299      -5.559 -11.700  44.652  1.00 43.78          
ATOM   2364  C   SER   299      -4.202 -11.928  44.027  1.00 43.59          
ATOM   2365  O   SER   299      -4.092 -12.631  43.038  1.00 44.01          
ATOM   2366  CB  SER   299      -5.630 -12.478  45.948  1.00 43.01          
ATOM   2367  OG  SER   299      -5.428 -13.850  45.693  1.00 38.72          
ATOM   2368  N   LEU   300      -3.164 -11.360  44.631  1.00 45.42          
ATOM   2369  CA  LEU   300      -1.813 -11.519  44.113  1.00 46.46          
ATOM   2370  C   LEU   300      -1.527 -12.981  43.790  1.00 46.29          
ATOM   2371  O   LEU   300      -0.977 -13.281  42.736  1.00 47.27          
ATOM   2372  CB  LEU   300      -0.793 -10.992  45.119  1.00 46.38          
ATOM   2373  CG  LEU   300       0.675 -11.080  44.682  1.00 47.84          
ATOM   2374  CD1 LEU   300       0.876 -10.362  43.352  1.00 45.68          
ATOM   2375  CD2 LEU   300       1.578 -10.470  45.764  1.00 48.95          
ATOM   2376  N   GLN   301      -1.914 -13.884  44.686  1.00 45.54          
ATOM   2377  CA  GLN   301      -1.695 -15.308  44.478  1.00 46.12          
ATOM   2378  C   GLN   301      -2.615 -15.887  43.416  1.00 47.69          
ATOM   2379  O   GLN   301      -2.218 -16.753  42.641  1.00 47.50          
ATOM   2380  CB  GLN   301      -1.924 -16.082  45.763  1.00 46.17          
ATOM   2381  CG  GLN   301      -1.622 -17.564  45.643  1.00 46.12          
ATOM   2382  CD  GLN   301      -0.136 -17.838  45.601  1.00 45.52          
ATOM   2383  OE1 GLN   301       0.572 -17.307  44.754  1.00 44.36          
ATOM   2384  NE2 GLN   301       0.346 -18.671  46.524  1.00 45.99          
ATOM   2385  N   MET   302      -3.861 -15.439  43.399  1.00 49.31          
ATOM   2386  CA  MET   302      -4.797 -15.938  42.409  1.00 51.32          
ATOM   2387  C   MET   302      -4.385 -15.528  41.006  1.00 52.45          
ATOM   2388  O   MET   302      -4.563 -16.285  40.061  1.00 52.64          
ATOM   2389  CB  MET   302      -6.200 -15.436  42.704  1.00 52.89          
ATOM   2390  CG  MET   302      -6.855 -16.153  43.851  1.00 57.45          
ATOM   2391  SD  MET   302      -8.378 -15.173  44.471  1.00 62.65          
ATOM   2392  CE  MET   302      -9.628 -15.560  43.052  1.00 62.89          
ATOM   2393  N   MET   303      -3.845 -14.325  40.867  1.00 53.09          
ATOM   2394  CA  MET   303      -3.406 -13.857  39.571  1.00 53.97          
ATOM   2395  C   MET   303      -2.217 -14.696  39.122  1.00 52.85          
ATOM   2396  O   MET   303      -2.169 -15.134  37.982  1.00 52.25          
ATOM   2397  CB  MET   303      -2.999 -12.391  39.643  1.00 57.76          
ATOM   2398  CG  MET   303      -4.109 -11.452  40.071  1.00 63.73          
ATOM   2399  SD  MET   303      -3.617  -9.563  39.822  1.00 70.50          
ATOM   2400  CE  MET   303      -3.534  -8.998  41.681  1.00 70.66          
ATOM   2401  N   LEU   304      -1.267 -14.928  40.027  1.00 52.23          
ATOM   2402  CA  LEU   304      -0.086 -15.718  39.706  1.00 51.04          
ATOM   2403  C   LEU   304      -0.471 -17.097  39.207  1.00 51.98          
ATOM   2404  O   LEU   304       0.309 -17.748  38.525  1.00 53.52          
ATOM   2405  CB  LEU   304       0.837 -15.844  40.922  1.00 49.65          
ATOM   2406  CG  LEU   304       2.130 -16.655  40.773  1.00 47.72          
ATOM   2407  CD1 LEU   304       2.999 -16.079  39.681  1.00 46.43          
ATOM   2408  CD2 LEU   304       2.876 -16.643  42.087  1.00 46.76          
ATOM   2409  N   ASP   305      -1.671 -17.551  39.540  1.00 53.53          
ATOM   2410  CA  ASP   305      -2.109 -18.859  39.081  1.00 54.88          
ATOM   2411  C   ASP   305      -2.729 -18.774  37.718  1.00 54.61          
ATOM   2412  O   ASP   305      -2.629 -19.709  36.933  1.00 55.30          
ATOM   2413  CB  ASP   305      -3.099 -19.477  40.055  1.00 56.92          
ATOM   2414  CG  ASP   305      -2.415 -20.011  41.284  1.00 60.74          
ATOM   2415  OD1 ASP   305      -1.398 -20.735  41.116  1.00 62.71          
ATOM   2416  OD2 ASP   305      -2.884 -19.724  42.412  1.00 61.25          
ATOM   2417  N   GLU   306      -3.393 -17.660  37.445  1.00 55.22          
ATOM   2418  CA  GLU   306      -4.012 -17.454  36.147  1.00 55.87          
ATOM   2419  C   GLU   306      -2.905 -17.445  35.105  1.00 55.93          
ATOM   2420  O   GLU   306      -3.042 -18.029  34.029  1.00 56.27          
ATOM   2421  CB  GLU   306      -4.748 -16.122  36.124  1.00 57.59          
ATOM   2422  CG  GLU   306      -6.257 -16.253  36.166  1.00 61.17          
ATOM   2423  CD  GLU   306      -6.816 -16.815  34.885  1.00 62.73          
ATOM   2424  OE1 GLU   306      -6.546 -16.211  33.817  1.00 63.01          
ATOM   2425  OE2 GLU   306      -7.521 -17.852  34.950  1.00 64.03          
ATOM   2426  N   ILE   307      -1.805 -16.778  35.443  1.00 55.01          
ATOM   2427  CA  ILE   307      -0.650 -16.667  34.563  1.00 54.51          
ATOM   2428  C   ILE   307       0.085 -17.996  34.460  1.00 54.74          
ATOM   2429  O   ILE   307       0.626 -18.335  33.411  1.00 53.61          
ATOM   2430  CB  ILE   307       0.339 -15.581  35.081  1.00 53.45          
ATOM   2431  CG1 ILE   307      -0.316 -14.207  35.000  1.00 53.10          
ATOM   2432  CG2 ILE   307       1.616 -15.576  34.253  1.00 53.14          
ATOM   2433  CD  ILE   307       0.533 -13.103  35.547  1.00 51.89          
ATOM   2434  N   THR   308       0.094 -18.752  35.551  1.00 55.72          
ATOM   2435  CA  THR   308       0.789 -20.028  35.573  1.00 57.22          
ATOM   2436  C   THR   308       0.082 -21.019  34.656  1.00 57.78          
ATOM   2437  O   THR   308       0.712 -21.883  34.057  1.00 58.79          
ATOM   2438  CB  THR   308       0.891 -20.562  37.028  1.00 57.17          
ATOM   2439  OG1 THR   308       2.063 -21.375  37.156  1.00 57.44          
ATOM   2440  CG2 THR   308      -0.331 -21.372  37.397  1.00 58.77          
ATOM   2441  N   THR   309      -1.228 -20.869  34.523  1.00 58.23          
ATOM   2442  CA  THR   309      -2.000 -21.748  33.664  1.00 58.17          
ATOM   2443  C   THR   309      -1.745 -21.379  32.214  1.00 57.88          
ATOM   2444  O   THR   309      -1.687 -22.234  31.336  1.00 57.72          
ATOM   2445  CB  THR   309      -3.494 -21.600  33.955  1.00 59.17          
ATOM   2446  OG1 THR   309      -3.746 -21.966  35.317  1.00 59.29          
ATOM   2447  CG2 THR   309      -4.319 -22.476  33.022  1.00 59.28          
ATOM   2448  N   GLN   310      -1.598 -20.086  31.977  1.00 58.69          
ATOM   2449  CA  GLN   310      -1.347 -19.579  30.646  1.00 59.14          
ATOM   2450  C   GLN   310       0.065 -19.993  30.215  1.00 59.03          
ATOM   2451  O   GLN   310       0.296 -20.278  29.046  1.00 60.40          
ATOM   2452  CB  GLN   310      -1.489 -18.054  30.644  1.00 59.01          
ATOM   2453  CG  GLN   310      -2.202 -17.467  29.433  1.00 59.91          
ATOM   2454  CD  GLN   310      -3.696 -17.758  29.409  1.00 59.59          
ATOM   2455  OE1 GLN   310      -4.416 -17.289  28.525  1.00 58.69          
ATOM   2456  NE2 GLN   310      -4.168 -18.532  30.378  1.00 58.43          
ATOM   2457  N   ILE   311       1.003 -20.039  31.157  1.00 58.73          
ATOM   2458  CA  ILE   311       2.376 -20.425  30.835  1.00 59.08          
ATOM   2459  C   ILE   311       2.537 -21.934  30.661  1.00 61.03          
ATOM   2460  O   ILE   311       3.463 -22.396  29.979  1.00 60.61          
ATOM   2461  CB  ILE   311       3.380 -19.950  31.918  1.00 57.94          
ATOM   2462  CG1 ILE   311       3.404 -18.424  31.978  1.00 56.82          
ATOM   2463  CG2 ILE   311       4.774 -20.463  31.601  1.00 56.28          
ATOM   2464  CD  ILE   311       4.156 -17.877  33.159  1.00 56.25          
ATOM   2465  N   ASN   312       1.653 -22.710  31.286  1.00 61.99          
ATOM   2466  CA  ASN   312       1.719 -24.167  31.149  1.00 62.47          
ATOM   2467  C   ASN   312       1.166 -24.608  29.776  1.00 64.15          
ATOM   2468  O   ASN   312       0.939 -25.796  29.548  1.00 64.42          
ATOM   2469  CB  ASN   312       0.962 -24.876  32.295  1.00 61.80          
ATOM   2470  CG  ASN   312       1.702 -24.806  33.644  1.00 60.42          
ATOM   2471  OD1 ASN   312       2.883 -24.439  33.716  1.00 60.65          
ATOM   2472  ND2 ASN   312       1.003 -25.178  34.715  1.00 57.04          
ATOM   2473  N   LYS   313       0.990 -23.648  28.861  1.00 65.63          
ATOM   2474  CA  LYS   313       0.534 -23.932  27.492  1.00 67.33          
ATOM   2475  C   LYS   313       1.699 -23.596  26.559  1.00 68.99          
ATOM   2476  O   LYS   313       2.085 -24.409  25.706  1.00 68.36          
ATOM   2477  CB  LYS   313      -0.703 -23.097  27.105  1.00 66.37          
ATOM   2478  CG  LYS   313      -1.966 -23.428  27.904  1.00 65.14          
ATOM   2479  CD  LYS   313      -2.291 -24.916  27.830  1.00 64.60          
ATOM   2480  CE  LYS   313      -3.074 -25.401  29.056  1.00 63.38          
ATOM   2481  NZ  LYS   313      -3.453 -26.856  28.978  1.00 60.24          
ATOM   2482  N   ARG   314       2.267 -22.402  26.745  1.00 71.80          
ATOM   2483  CA  ARG   314       3.410 -21.937  25.948  1.00 74.39          
ATOM   2484  C   ARG   314       4.544 -22.959  26.006  1.00 75.46          
ATOM   2485  O   ARG   314       5.475 -22.905  25.199  1.00 76.09          
ATOM   2486  CB  ARG   314       3.946 -20.593  26.469  1.00 73.93          
ATOM   2487  CG  ARG   314       3.064 -19.379  26.240  1.00 74.77          
ATOM   2488  CD  ARG   314       2.928 -19.011  24.764  1.00 75.33          
ATOM   2489  NE  ARG   314       2.398 -17.655  24.608  1.00 75.78          
ATOM   2490  CZ  ARG   314       1.191 -17.260  25.009  1.00 75.66          
ATOM   2491  NH1 ARG   314       0.364 -18.116  25.589  1.00 76.05          
ATOM   2492  NH2 ARG   314       0.815 -15.997  24.857  1.00 75.79          
ATOM   2493  N   SER   315       4.472 -23.873  26.973  1.00 76.96          
ATOM   2494  CA  SER   315       5.494 -24.906  27.118  1.00 79.42          
ATOM   2495  C   SER   315       4.966 -26.290  26.719  1.00 80.34          
ATOM   2496  O   SER   315       5.372 -26.766  25.630  1.00 80.78          
ATOM   2497  CB  SER   315       6.047 -24.927  28.561  1.00 79.23          
ATOM   2498  OG  SER   315       5.022 -25.081  29.532  1.00 79.03          
END
