
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  186 ( 1512),  selected  186 , name 2atf_A
# Molecule2: number of CA atoms  138 ( 1133),  selected  138 , name T0414.pdb
# PARAMETERS: 2atf_A.T0414.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    E     5_A      A       3           -
LGA    L     6_A      M       4           -
LGA    L     7_A      K       5           -
LGA    K     8_A      -       -           -
LGA    P     9_A      -       -           -
LGA    R    10_A      -       -           -
LGA    T    11_A      -       -           -
LGA    L    12_A      -       -           -
LGA    A    13_A      P       6          4.812
LGA    D    14_A      D       7           -
LGA    L    15_A      -       -           -
LGA    I    16_A      -       -           -
LGA    R    17_A      -       -           -
LGA    I    18_A      -       -           -
LGA    L    19_A      -       -           -
LGA    H    20_A      -       -           -
LGA    E    21_A      -       -           -
LGA    L    22_A      -       -           -
LGA    F    23_A      -       -           -
LGA    A    24_A      -       -           -
LGA    G    25_A      -       -           -
LGA    D    26_A      -       -           -
LGA    E    27_A      -       -           -
LGA    V    28_A      -       -           -
LGA    N    29_A      -       -           -
LGA    V    30_A      -       -           -
LGA    E    31_A      -       -           -
LGA    E    32_A      -       -           -
LGA    V    33_A      -       -           -
LGA    Q    34_A      -       -           -
LGA    A    35_A      -       -           -
LGA    V    36_A      -       -           -
LGA    L    37_A      -       -           -
LGA    E    38_A      -       -           -
LGA    A    39_A      -       -           -
LGA    Y    40_A      -       -           -
LGA    E    41_A      -       -           -
LGA    S    42_A      -       -           -
LGA    N    43_A      -       -           -
LGA    P    44_A      -       -           -
LGA    A    45_A      -       -           -
LGA    E    46_A      -       -           -
LGA    W    47_A      I       8           #
LGA    A    48_A      -       -           -
LGA    L    49_A      Y       9          4.682
LGA    Y    50_A      E      10          2.227
LGA    A    51_A      N      11          1.829
LGA    K    52_A      N      12          2.083
LGA    F    53_A      R      13          2.315
LGA    D    54_A      E      14          2.634
LGA    Q    55_A      -       -           -
LGA    Y    56_A      -       -           -
LGA    R    57_A      -       -           -
LGA    Y    58_A      -       -           -
LGA    T    59_A      G      15          1.693
LGA    R    60_A      I      16          1.442
LGA    N    61_A      L      17          0.826
LGA    L    62_A      C      18          1.325
LGA    V    63_A      V      19          1.175
LGA    D    64_A      Y      20          0.929
LGA    Q    65_A      K      21          0.831
LGA    G    66_A      N      22          2.433
LGA    N    67_A      -       -           -
LGA    G    68_A      E      23          0.571
LGA    K    69_A      K      24          0.240
LGA    F    70_A      W      25          0.687
LGA    N    71_A      L      26          1.309
LGA    L    72_A      V      27          1.011
LGA    X    73_A      C      28          0.994
LGA    I    74_A      I      29          0.712
LGA    L    75_A      K      30          0.798
LGA    C    76_A      N      31          0.970
LGA    W    77_A      W      32          1.170
LGA    G    78_A      K      33          5.030
LGA    E    79_A      P      34           -
LGA    G    80_A      -       -           -
LGA    H    81_A      D      35          4.944
LGA    G    82_A      N      36          0.459
LGA    -       -      D      37           -
LGA    -       -      I      38           -
LGA    -       -      E      39           -
LGA    -       -      G      40           -
LGA    -       -      I      41           -
LGA    S    83_A      A      42           #
LGA    S    84_A      H      43          3.040
LGA    I    85_A      L      44          0.690
LGA    H    86_A      E      45          0.781
LGA    D    87_A      I      46          0.489
LGA    H    88_A      H      47          1.576
LGA    T    89_A      H      48          2.919
LGA    D    90_A      S      49          1.230
LGA    S    91_A      T      50          0.373
LGA    H    92_A      D      51          1.645
LGA    C    93_A      E      52          0.521
LGA    F    94_A      Q      53          0.765
LGA    L    95_A      F      54          0.784
LGA    K    96_A      I      55          0.708
LGA    L    97_A      L      56          1.025
LGA    L    98_A      S      57          1.572
LGA    Q    99_A      A      58          1.265
LGA    G   100_A      G      59          1.408
LGA    N   101_A      K      60          1.813
LGA    L   102_A      A      61          0.995
LGA    K   103_A      I      62          0.647
LGA    E   104_A      L      63          0.921
LGA    T   105_A      I      64          1.437
LGA    L   106_A      T      65          1.356
LGA    F   107_A      A      66          0.580
LGA    D   108_A      E      67          0.491
LGA    W   109_A      K      68          3.095
LGA    P   110_A      E      69          3.853
LGA    D   111_A      N      70          2.878
LGA    K   112_A      -       -           -
LGA    K   113_A      -       -           -
LGA    S   114_A      D      71          3.192
LGA    N   115_A      K      72          3.633
LGA    E   116_A      -       -           -
LGA    X   117_A      F      73          1.883
LGA    I   118_A      N      74          3.040
LGA    K   119_A      I      75          0.932
LGA    K   120_A      E      76          3.594
LGA    S   121_A      -       -           -
LGA    E   122_A      L      77          1.093
LGA    R   123_A      T      78          1.074
LGA    T   124_A      L      79          0.823
LGA    L   125_A      M      80          0.722
LGA    R   126_A      E      81          2.398
LGA    E   127_A      K      82          2.376
LGA    N   128_A      G      83          3.297
LGA    Q   129_A      K      84          2.278
LGA    C   130_A      V      85          1.362
LGA    A   131_A      Y      86          0.555
LGA    Y   132_A      N      87          0.474
LGA    I   133_A      V      88          0.772
LGA    N   134_A      P      89          1.540
LGA    D   135_A      A      90          2.386
LGA    S   136_A      E      91          4.407
LGA    I   137_A      -       -           -
LGA    G   138_A      C      92          1.960
LGA    L   139_A      W      93          0.926
LGA    H   140_A      F      94          1.054
LGA    R   141_A      Y      95          1.897
LGA    V   142_A      S      96          0.678
LGA    E   143_A      I      97          0.882
LGA    N   144_A      T      98          0.568
LGA    V   145_A      Q      99          4.556
LGA    S   146_A      -       -           -
LGA    H   147_A      -       -           -
LGA    T   148_A      -       -           -
LGA    E   149_A      K     100          4.716
LGA    P   150_A      D     101          1.201
LGA    A   151_A      T     102          0.945
LGA    V   152_A      K     103          0.997
LGA    S   153_A      M     104          0.979
LGA    L   154_A      M     105          0.960
LGA    H   155_A      Y     106          0.828
LGA    L   156_A      V     107          0.775
LGA    Y   157_A      Q     108          0.440
LGA    S   158_A      D     109          1.853
LGA    P   159_A      S     110          4.536
LGA    P   160_A      N     111          2.750
LGA    F   161_A      C     112          1.394
LGA    D   162_A      S     113          2.621
LGA    T   163_A      M     114          1.039
LGA    -       -      D     115           -
LGA    -       -      N     116           -
LGA    C   164_A      S     117          2.279
LGA    H   165_A      D     118          1.016
LGA    A   166_A      F     119          0.950
LGA    F   167_A      C     120          1.116
LGA    D   168_A      D     121          1.645
LGA    Q   169_A      L     122          1.657
LGA    R   170_A      S     123          2.118
LGA    T   171_A      K     124           -
LGA    G   172_A      E     125           -
LGA    H   173_A      E     126           -
LGA    K   174_A      I     127           -
LGA    N   175_A      E     128           -
LGA    K   176_A      Y     129           -
LGA    V   177_A      I     130           -
LGA    T   178_A      Q     131           -
LGA    X   179_A      T     132           -
LGA    T   180_A      N     133           -
LGA    F   181_A      A     134           -
LGA    H   182_A      R     135           -
LGA    S   183_A      K     136           -
LGA    K   184_A      L     137           -
LGA    F   185_A      F     138           -
LGA    G   186_A      E     139           -
LGA    I   187_A      K     140           -
LGA    R   188_A      -       -           -
LGA    T   189_A      -       -           -
LGA    P   190_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  186  138    5.0    107    2.06     7.48     63.105     4.955

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.405088 * X  +  -0.099495 * Y  +   0.908848 * Z  +  -2.058438
  Y_new =  -0.054132 * X  +  -0.989707 * Y  +  -0.132474 * Z  +  23.818293
  Z_new =   0.912674 * X  +  -0.102861 * Y  +   0.395533 * Z  +  -7.785939 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.254422    2.887171  [ DEG:   -14.5773    165.4227 ]
  Theta =  -1.149780   -1.991813  [ DEG:   -65.8775   -114.1225 ]
  Phi   =  -3.008750    0.132843  [ DEG:  -172.3887      7.6113 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2atf_A                                        
REMARK     2: T0414.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2atf_A.T0414.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  186  138   5.0  107   2.06    7.48  63.105
REMARK  ---------------------------------------------------------- 
MOLECULE 2atf_A
HEADER    OXIDOREDUCTASE                          24-AUG-05   2ATF              
TITLE     X-RAY STRUCTURE OF CYSTEINE DIOXYGENASE TYPE I FROM MUS               
TITLE    2 MUSCULUS MM.241056                                                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CYSTEINE DIOXYGENASE TYPE I;                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: CDO, CDO-I;                                                 
COMPND   5 EC: 1.13.11.20;                                                      
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   3 ORGANISM_COMMON: MOUSE;                                              
SOURCE   4 GENE: CDO1;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: B834 P(RARE2);                             
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PVP 16                                    
KEYWDS    MM.241056, PFAM05995.2 CDO_I, BC013638, CUPIN FAMILY,                 
KEYWDS   2 STRUCTURAL GENOMICS, PROTEIN STRUCTURE INITIATIVE, PSI,              
KEYWDS   3 CENTER FOR EUKARYOTIC STRUCTURAL GENOMICS, CESG                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    G.E.WESENBERG,G.N.PHILLIPS JR.,J.G.MCCOY,E.BITTO,                     
AUTHOR   2 C.A.BINGMAN,S.T.M.ALLARD,CENTER FOR EUKARYOTIC STRUCTURAL            
AUTHOR   3 GENOMICS (CESG)                                                      
REVDAT   3   13-FEB-07 2ATF    1       JRNL                                     
REVDAT   2   04-JUL-06 2ATF    1       EXPDTA                                   
REVDAT   1   18-OCT-05 2ATF    0                                                
JRNL        AUTH   J.G.MCCOY,L.J.BAILEY,E.BITTO,C.A.BINGMAN,D.J.ACETI,          
JRNL        AUTH 2 B.G.FOX,G.N.PHILLIPS                                         
JRNL        TITL   STRUCTURE AND MECHANISM OF MOUSE CYSTEINE                    
JRNL        TITL 2 DIOXYGENASE.                                                 
JRNL        REF    PROC.NATL.ACAD.SCI.USA        V. 103  3084 2006              
JRNL        REFN   ASTM PNASA6  US ISSN 0027-8424                               
REMARK   2 RESOLUTION. 1.75 ANGSTROMS.                                          
DBREF  2ATF A    1   200  UNP    P60334   CDO1_MOUSE       1    200             
SEQRES   1 A  200  SER GLU ARG THR GLU LEU LEU LYS PRO ARG THR LEU ALA          
SEQRES   2 A  200  ASP LEU ILE ARG ILE LEU HIS GLU LEU PHE ALA GLY ASP          
SEQRES   3 A  200  GLU VAL ASN VAL GLU GLU VAL GLN ALA VAL LEU GLU ALA          
SEQRES   4 A  200  TYR GLU SER ASN PRO ALA GLU TRP ALA LEU TYR ALA LYS          
SEQRES   5 A  200  PHE ASP GLN TYR ARG TYR THR ARG ASN LEU VAL ASP GLN          
SEQRES   6 A  200  GLY ASN GLY LYS PHE ASN LEU MSE ILE LEU CYS TRP GLY          
SEQRES   7 A  200  GLU GLY HIS GLY SER SER ILE HIS ASP HIS THR ASP SER          
SEQRES   8 A  200  HIS CYS PHE LEU LYS LEU LEU GLN GLY ASN LEU LYS GLU          
SEQRES   9 A  200  THR LEU PHE ASP TRP PRO ASP LYS LYS SER ASN GLU MSE          
SEQRES  10 A  200  ILE LYS LYS SER GLU ARG THR LEU ARG GLU ASN GLN CYS          
SEQRES  11 A  200  ALA TYR ILE ASN ASP SER ILE GLY LEU HIS ARG VAL GLU          
SEQRES  12 A  200  ASN VAL SER HIS THR GLU PRO ALA VAL SER LEU HIS LEU          
SEQRES  13 A  200  TYR SER PRO PRO PHE ASP THR CYS HIS ALA PHE ASP GLN          
SEQRES  14 A  200  ARG THR GLY HIS LYS ASN LYS VAL THR MSE THR PHE HIS          
SEQRES  15 A  200  SER LYS PHE GLY ILE ARG THR PRO PHE THR THR SER GLY          
SEQRES  16 A  200  SER LEU GLU ASN ASN                                          
HET    MSE  A  73       8                                                       
HET    MSE  A 117       8                                                       
HET    MSE  A 179      13                                                       
HET     NI  A   1       1                                                       
HET    EDO    234       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      NI NICKEL (II) ION                                                  
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    3(C5 H11 N O2 SE)                                            
FORMUL   2   NI    NI 2+                                                        
FORMUL   3  EDO    C2 H6 O2                                                     
FORMUL   4  HOH   *188(H2 O)                                                    
CRYST1   57.550   57.550  122.076  90.00  90.00  90.00 P 43 21 2     8          
ATOM      1  N   GLU A   5      39.678  -8.509  33.112  1.00 34.02           N  
ATOM      2  CA  GLU A   5      38.285  -8.923  32.731  1.00 32.88           C  
ATOM      3  C   GLU A   5      37.709  -7.994  31.638  1.00 30.01           C  
ATOM      4  O   GLU A   5      37.946  -6.797  31.686  1.00 31.47           O  
ATOM      5  CB  GLU A   5      37.393  -8.882  33.984  1.00 32.69           C  
ATOM      6  CG  GLU A   5      37.684 -10.068  34.946  1.00 36.26           C  
ATOM      7  CD  GLU A   5      36.993  -9.963  36.311  1.00 36.76           C  
ATOM      8  OE1 GLU A   5      36.495  -8.853  36.687  1.00 38.42           O  
ATOM      9  OE2 GLU A   5      36.971 -11.019  37.016  1.00 40.12           O  
ATOM     10  N   LEU A   6      36.938  -8.510  30.680  1.00 26.39           N  
ATOM     11  CA  LEU A   6      36.215  -7.604  29.787  1.00 22.95           C  
ATOM     12  C   LEU A   6      34.858  -7.388  30.397  1.00 21.22           C  
ATOM     13  O   LEU A   6      34.084  -8.323  30.466  1.00 18.90           O  
ATOM     14  CB  LEU A   6      35.995  -8.199  28.403  1.00 23.98           C  
ATOM     15  CG  LEU A   6      37.083  -8.738  27.525  1.00 27.45           C  
ATOM     16  CD1 LEU A   6      36.385  -9.292  26.278  1.00 29.67           C  
ATOM     17  CD2 LEU A   6      37.972  -7.531  27.190  1.00 28.41           C  
ATOM     18  N   LEU A   7      34.558  -6.171  30.850  1.00 19.13           N  
ATOM     19  CA  LEU A   7      33.239  -5.884  31.417  1.00 18.64           C  
ATOM     20  C   LEU A   7      32.293  -5.211  30.408  1.00 17.18           C  
ATOM     21  O   LEU A   7      32.747  -4.664  29.381  1.00 17.46           O  
ATOM     22  CB  LEU A   7      33.359  -5.041  32.706  1.00 19.72           C  
ATOM     23  CG  LEU A   7      34.203  -5.680  33.815  1.00 21.16           C  
ATOM     24  CD1 LEU A   7      34.454  -4.649  34.930  1.00 27.19           C  
ATOM     25  CD2 LEU A   7      33.522  -6.955  34.362  1.00 23.40           C  
ATOM     26  N   LYS A   8      31.000  -5.235  30.693  1.00 15.96           N  
ATOM     27  CA  LYS A   8      30.051  -4.636  29.782  1.00 16.02           C  
ATOM     28  C   LYS A   8      30.190  -3.099  29.829  1.00 14.77           C  
ATOM     29  O   LYS A   8      30.072  -2.499  30.938  1.00 13.97           O  
ATOM     30  CB  LYS A   8      28.621  -4.983  30.157  1.00 16.78           C  
ATOM     31  CG  LYS A   8      27.590  -4.434  29.163  1.00 16.80           C  
ATOM     32  CD  LYS A   8      26.163  -4.908  29.558  1.00 19.18           C  
ATOM     33  CE  LYS A   8      25.086  -4.507  28.540  1.00 24.61           C  
ATOM     34  NZ  LYS A   8      25.229  -5.395  27.261  1.00 27.94           N  
ATOM     35  N   PRO A   9      30.418  -2.463  28.673  1.00 14.15           N  
ATOM     36  CA  PRO A   9      30.473  -0.999  28.760  1.00 14.37           C  
ATOM     37  C   PRO A   9      29.132  -0.401  29.154  1.00 15.82           C  
ATOM     38  O   PRO A   9      28.119  -0.739  28.556  1.00 16.91           O  
ATOM     39  CB  PRO A   9      30.869  -0.569  27.333  1.00 14.54           C  
ATOM     40  CG  PRO A   9      31.389  -1.824  26.646  1.00 14.77           C  
ATOM     41  CD  PRO A   9      30.727  -2.990  27.318  1.00 14.18           C  
ATOM     42  N   ARG A  10      29.131   0.496  30.137  1.00 17.24           N  
ATOM     43  CA  ARG A  10      27.872   1.073  30.648  1.00 20.30           C  
ATOM     44  C   ARG A  10      27.358   2.208  29.771  1.00 17.94           C  
ATOM     45  O   ARG A  10      26.157   2.471  29.727  1.00 18.69           O  
ATOM     46  CB  ARG A  10      28.105   1.649  32.080  1.00 21.13           C  
ATOM     47  CG  ARG A  10      28.621   0.596  33.156  1.00 25.74           C  
ATOM     48  CD  ARG A  10      29.243   1.207  34.475  1.00 28.09           C  
ATOM     49  NE  ARG A  10      29.860   2.547  34.371  1.00 39.06           N  
ATOM     50  CZ  ARG A  10      31.141   2.857  34.654  1.00 44.36           C  
ATOM     51  NH1 ARG A  10      32.022   1.934  35.060  1.00 43.99           N  
ATOM     52  NH2 ARG A  10      31.562   4.119  34.510  1.00 46.18           N  
ATOM     53  N   THR A  11      28.280   2.868  29.108  1.00 16.68           N  
ATOM     54  CA  THR A  11      28.046   4.031  28.278  1.00 15.27           C  
ATOM     55  C   THR A  11      29.091   4.072  27.137  1.00 13.89           C  
ATOM     56  O   THR A  11      30.099   3.365  27.183  1.00 12.15           O  
ATOM     57  CB  THR A  11      28.260   5.342  29.083  1.00 16.26           C  
ATOM     58  OG1 THR A  11      29.631   5.438  29.488  1.00 14.39           O  
ATOM     59  CG2 THR A  11      27.352   5.369  30.357  1.00 16.03           C  
ATOM     60  N   LEU A  12      28.907   5.002  26.195  1.00 12.19           N  
ATOM     61  CA  LEU A  12      29.910   5.186  25.152  1.00 13.15           C  
ATOM     62  C   LEU A  12      31.283   5.591  25.749  1.00 13.17           C  
ATOM     63  O   LEU A  12      32.333   5.085  25.370  1.00 11.93           O  
ATOM     64  CB  LEU A  12      29.436   6.230  24.115  1.00 12.45           C  
ATOM     65  CG  LEU A  12      30.448   6.531  23.014  1.00 13.11           C  
ATOM     66  CD1 LEU A  12      30.809   5.272  22.185  1.00 15.05           C  
ATOM     67  CD2 LEU A  12      29.892   7.717  22.143  1.00 13.92           C  
ATOM     68  N   ALA A  13      31.268   6.465  26.746  1.00 13.20           N  
ATOM     69  CA  ALA A  13      32.523   6.904  27.356  1.00 13.55           C  
ATOM     70  C   ALA A  13      33.221   5.693  28.006  1.00 12.62           C  
ATOM     71  O   ALA A  13      34.439   5.537  27.891  1.00 12.50           O  
ATOM     72  CB  ALA A  13      32.202   7.984  28.423  1.00 13.44           C  
ATOM     73  N   ASP A  14      32.426   4.834  28.624  1.00 13.68           N  
ATOM     74  CA  ASP A  14      32.946   3.618  29.266  0.50 12.63           C  
ATOM     76  C   ASP A  14      33.526   2.697  28.193  1.00 13.91           C  
ATOM     77  O   ASP A  14      34.644   2.177  28.351  1.00 13.38           O  
ATOM     78  CB  ASP A  14      31.828   2.922  30.051  0.50 13.62           C  
ATOM     80  CG  ASP A  14      32.356   2.055  31.165  0.50 11.66           C  
ATOM     82  OD1 ASP A  14      33.358   2.462  31.808  0.50 12.59           O  
ATOM     84  OD2 ASP A  14      31.758   0.988  31.381  0.50 11.52           O  
ATOM     86  N   LEU A  15      32.773   2.488  27.109  1.00 11.43           N  
ATOM     87  CA  LEU A  15      33.355   1.720  25.988  1.00 10.71           C  
ATOM     88  C   LEU A  15      34.710   2.274  25.562  1.00 11.70           C  
ATOM     89  O   LEU A  15      35.659   1.518  25.304  1.00 10.25           O  
ATOM     90  CB  LEU A  15      32.401   1.802  24.770  1.00 10.18           C  
ATOM     91  CG  LEU A  15      32.905   1.163  23.457  1.00 11.54           C  
ATOM     92  CD1 LEU A  15      33.240  -0.381  23.633  1.00 11.98           C  
ATOM     93  CD2 LEU A  15      31.820   1.402  22.389  1.00 10.20           C  
ATOM     94  N   ILE A  16      34.822   3.599  25.363  1.00 11.87           N  
ATOM     95  CA  ILE A  16      36.081   4.183  24.893  1.00 12.46           C  
ATOM     96  C   ILE A  16      37.226   3.904  25.908  1.00 12.61           C  
ATOM     97  O   ILE A  16      38.347   3.519  25.541  1.00 11.60           O  
ATOM     98  CB  ILE A  16      35.884   5.713  24.637  1.00 11.55           C  
ATOM     99  CG1 ILE A  16      34.960   5.941  23.401  1.00 12.82           C  
ATOM    100  CG2 ILE A  16      37.231   6.403  24.428  1.00 12.45           C  
ATOM    101  CD1 ILE A  16      34.498   7.424  23.312  1.00 12.46           C  
ATOM    102  N   ARG A  17      36.908   4.040  27.199  1.00 14.44           N  
ATOM    103  CA  ARG A  17      37.872   3.679  28.268  1.00 16.06           C  
ATOM    104  C   ARG A  17      38.358   2.234  28.114  1.00 14.05           C  
ATOM    105  O   ARG A  17      39.554   1.968  28.110  1.00 13.29           O  
ATOM    106  CB  ARG A  17      37.213   3.815  29.638  1.00 14.95           C  
ATOM    107  CG  ARG A  17      38.233   3.465  30.806  1.00 20.83           C  
ATOM    108  CD  ARG A  17      37.612   3.191  32.170  1.00 23.07           C  
ATOM    109  NE  ARG A  17      36.483   2.262  32.201  1.00 28.22           N  
ATOM    110  CZ  ARG A  17      36.544   0.939  32.336  1.00 27.48           C  
ATOM    111  NH1 ARG A  17      37.698   0.270  32.400  1.00 29.08           N  
ATOM    112  NH2 ARG A  17      35.399   0.269  32.365  1.00 31.28           N  
ATOM    113  N   ILE A  18      37.412   1.317  27.941  1.00 13.02           N  
ATOM    114  CA  ILE A  18      37.739  -0.103  27.796  1.00 13.56           C  
ATOM    115  C   ILE A  18      38.589  -0.318  26.546  1.00 13.99           C  
ATOM    116  O   ILE A  18      39.597  -1.075  26.579  1.00 13.31           O  
ATOM    117  CB  ILE A  18      36.458  -0.964  27.787  1.00 14.19           C  
ATOM    118  CG1 ILE A  18      35.751  -0.916  29.176  1.00 15.29           C  
ATOM    119  CG2 ILE A  18      36.779  -2.433  27.481  1.00 15.89           C  
ATOM    120  CD1 ILE A  18      34.292  -1.300  29.138  1.00 18.64           C  
ATOM    121  N   LEU A  19      38.214   0.347  25.433  1.00 11.85           N  
ATOM    122  CA  LEU A  19      39.005   0.235  24.232  1.00 11.33           C  
ATOM    123  C   LEU A  19      40.451   0.678  24.420  1.00 13.14           C  
ATOM    124  O   LEU A  19      41.375   0.083  23.865  1.00 12.95           O  
ATOM    125  CB  LEU A  19      38.350   0.979  23.057  1.00 10.24           C  
ATOM    126  CG  LEU A  19      37.034   0.343  22.629  1.00  8.36           C  
ATOM    127  CD1 LEU A  19      36.361   1.343  21.634  1.00  9.88           C  
ATOM    128  CD2 LEU A  19      37.225  -0.990  21.903  1.00 11.37           C  
ATOM    129  N   HIS A  20      40.644   1.779  25.128  1.00 14.01           N  
ATOM    130  CA  HIS A  20      41.998   2.215  25.356  1.00 14.79           C  
ATOM    131  C   HIS A  20      42.760   1.130  26.157  1.00 14.94           C  
ATOM    132  O   HIS A  20      43.937   0.975  25.934  1.00 14.49           O  
ATOM    133  CB  HIS A  20      42.035   3.560  26.081  1.00 15.52           C  
ATOM    134  CG  HIS A  20      41.850   4.750  25.175  1.00 18.41           C  
ATOM    135  ND1 HIS A  20      42.877   5.621  24.868  1.00 23.99           N  
ATOM    136  CD2 HIS A  20      40.765   5.212  24.514  1.00 24.24           C  
ATOM    137  CE1 HIS A  20      42.422   6.581  24.075  1.00 26.32           C  
ATOM    138  NE2 HIS A  20      41.132   6.361  23.852  1.00 18.07           N  
ATOM    139  N   GLU A  21      42.096   0.389  27.029  1.00 15.41           N  
ATOM    140  CA  GLU A  21      42.793  -0.736  27.753  1.00 16.50           C  
ATOM    141  C   GLU A  21      43.170  -1.877  26.785  1.00 15.78           C  
ATOM    142  O   GLU A  21      44.318  -2.371  26.734  1.00 14.90           O  
ATOM    143  CB  GLU A  21      41.888  -1.231  28.908  1.00 17.29           C  
ATOM    144  CG  GLU A  21      41.653  -0.134  30.000  1.00 18.49           C  
ATOM    145  CD  GLU A  21      40.712  -0.535  31.122  1.00 21.62           C  
ATOM    146  OE1 GLU A  21      40.286  -1.702  31.146  1.00 25.77           O  
ATOM    147  OE2 GLU A  21      40.417   0.319  32.026  1.00 23.25           O  
ATOM    148  N   LEU A  22      42.206  -2.243  25.949  1.00 15.06           N  
ATOM    149  CA  LEU A  22      42.385  -3.339  24.978  1.00 15.11           C  
ATOM    150  C   LEU A  22      43.470  -3.068  23.936  1.00 15.79           C  
ATOM    151  O   LEU A  22      44.062  -4.034  23.439  1.00 17.54           O  
ATOM    152  CB  LEU A  22      41.069  -3.632  24.255  1.00 15.58           C  
ATOM    153  CG  LEU A  22      40.035  -4.312  25.151  1.00 17.29           C  
ATOM    154  CD1 LEU A  22      38.705  -4.425  24.391  1.00 18.99           C  
ATOM    155  CD2 LEU A  22      40.594  -5.699  25.599  1.00 21.72           C  
ATOM    156  N   PHE A  23      43.711  -1.789  23.586  1.00 13.17           N  
ATOM    157  CA  PHE A  23      44.752  -1.380  22.629  1.00 14.59           C  
ATOM    158  C   PHE A  23      46.037  -0.826  23.321  1.00 15.45           C  
ATOM    159  O   PHE A  23      46.882  -0.157  22.679  1.00 16.58           O  
ATOM    160  CB  PHE A  23      44.161  -0.374  21.589  1.00 14.05           C  
ATOM    161  CG  PHE A  23      43.230  -1.043  20.611  1.00 13.67           C  
ATOM    162  CD1 PHE A  23      43.678  -1.477  19.381  1.00 12.86           C  
ATOM    163  CD2 PHE A  23      41.910  -1.238  20.955  1.00 16.05           C  
ATOM    164  CE1 PHE A  23      42.794  -2.140  18.469  1.00 13.07           C  
ATOM    165  CE2 PHE A  23      41.031  -1.868  20.054  1.00 13.73           C  
ATOM    166  CZ  PHE A  23      41.502  -2.331  18.830  1.00 14.88           C  
ATOM    167  N   ALA A  24      46.177  -1.120  24.605  1.00 16.53           N  
ATOM    168  CA  ALA A  24      47.351  -0.612  25.368  1.00 19.42           C  
ATOM    169  C   ALA A  24      48.639  -1.221  24.838  1.00 20.95           C  
ATOM    170  O   ALA A  24      49.720  -0.616  24.912  1.00 22.44           O  
ATOM    171  CB  ALA A  24      47.199  -0.894  26.869  1.00 18.25           C  
ATOM    172  N   GLY A  25      48.515  -2.414  24.268  1.00 23.52           N  
ATOM    173  CA  GLY A  25      49.676  -3.155  23.724  1.00 23.90           C  
ATOM    174  C   GLY A  25      49.827  -3.027  22.221  1.00 25.18           C  
ATOM    175  O   GLY A  25      49.208  -2.147  21.585  1.00 24.97           O  
ATOM    176  N   ASP A  26      50.650  -3.902  21.640  1.00 24.66           N  
ATOM    177  CA  ASP A  26      50.975  -3.771  20.204  1.00 26.46           C  
ATOM    178  C   ASP A  26      50.154  -4.704  19.314  1.00 25.27           C  
ATOM    179  O   ASP A  26      50.212  -4.602  18.064  1.00 26.49           O  
ATOM    180  CB  ASP A  26      52.446  -4.067  19.946  1.00 27.22           C  
ATOM    181  CG  ASP A  26      53.337  -2.954  20.396  1.00 32.47           C  
ATOM    182  OD1 ASP A  26      52.856  -1.784  20.456  1.00 36.00           O  
ATOM    183  OD2 ASP A  26      54.523  -3.273  20.663  1.00 36.02           O  
ATOM    184  N   GLU A  27      49.430  -5.615  19.941  1.00 24.80           N  
ATOM    185  CA  GLU A  27      48.593  -6.509  19.178  1.00 25.33           C  
ATOM    186  C   GLU A  27      47.121  -6.262  19.561  1.00 24.69           C  
ATOM    187  O   GLU A  27      46.819  -5.380  20.372  1.00 25.31           O  
ATOM    188  CB  GLU A  27      49.096  -7.964  19.346  1.00 26.06           C  
ATOM    189  CG  GLU A  27      50.576  -8.206  18.763  1.00 27.13           C  
ATOM    190  CD  GLU A  27      50.631  -8.226  17.204  1.00 31.84           C  
ATOM    191  OE1 GLU A  27      49.791  -8.947  16.597  1.00 32.39           O  
ATOM    192  OE2 GLU A  27      51.510  -7.546  16.592  1.00 29.70           O  
ATOM    193  N   VAL A  28      46.216  -7.017  18.951  1.00 22.67           N  
ATOM    194  CA  VAL A  28      44.784  -6.753  19.025  1.00 20.97           C  
ATOM    195  C   VAL A  28      44.150  -8.122  19.173  1.00 19.81           C  
ATOM    196  O   VAL A  28      44.360  -9.007  18.296  1.00 19.41           O  
ATOM    197  CB  VAL A  28      44.340  -6.138  17.665  1.00 21.27           C  
ATOM    198  CG1 VAL A  28      42.862  -5.895  17.592  1.00 22.56           C  
ATOM    199  CG2 VAL A  28      45.152  -4.850  17.363  1.00 23.65           C  
ATOM    200  N   ASN A  29      43.367  -8.298  20.229  1.00 17.24           N  
ATOM    201  CA  ASN A  29      42.552  -9.487  20.337  1.00 16.89           C  
ATOM    202  C   ASN A  29      41.219  -9.197  19.664  1.00 15.84           C  
ATOM    203  O   ASN A  29      40.359  -8.504  20.235  1.00 15.67           O  
ATOM    204  CB  ASN A  29      42.355  -9.898  21.796  1.00 19.05           C  
ATOM    205  CG  ASN A  29      41.701 -11.249  21.912  1.00 21.95           C  
ATOM    206  OD1 ASN A  29      40.702 -11.562  21.208  1.00 21.93           O  
ATOM    207  ND2 ASN A  29      42.251 -12.096  22.810  1.00 23.84           N  
ATOM    208  N   VAL A  30      41.077  -9.666  18.425  1.00 13.88           N  
ATOM    209  CA  VAL A  30      39.941  -9.265  17.595  1.00 14.64           C  
ATOM    210  C   VAL A  30      38.648  -9.670  18.227  1.00 13.24           C  
ATOM    211  O   VAL A  30      37.656  -8.931  18.199  1.00 13.15           O  
ATOM    212  CB  VAL A  30      40.071  -9.885  16.158  1.00 14.72           C  
ATOM    213  CG1 VAL A  30      38.724  -9.875  15.447  1.00 16.68           C  
ATOM    214  CG2 VAL A  30      41.181  -9.135  15.410  1.00 17.89           C  
ATOM    215  N   GLU A  31      38.617 -10.893  18.762  1.00 14.10           N  
ATOM    216  CA  GLU A  31      37.356 -11.419  19.288  0.50 12.97           C  
ATOM    218  C   GLU A  31      36.942 -10.675  20.553  1.00 13.06           C  
ATOM    219  O   GLU A  31      35.740 -10.470  20.768  1.00 12.11           O  
ATOM    220  CB  GLU A  31      37.449 -12.937  19.564  0.50 13.29           C  
ATOM    222  CG  GLU A  31      37.667 -13.772  18.312  0.50 12.61           C  
ATOM    224  CD  GLU A  31      39.143 -13.732  17.788  0.50 12.29           C  
ATOM    226  OE1 GLU A  31      40.074 -13.292  18.499  0.50 14.41           O  
ATOM    228  OE2 GLU A  31      39.347 -14.151  16.645  0.50 20.25           O  
ATOM    230  N   GLU A  32      37.921 -10.245  21.371  1.00 13.57           N  
ATOM    231  CA  GLU A  32      37.570  -9.473  22.569  1.00 12.87           C  
ATOM    232  C   GLU A  32      37.037  -8.098  22.182  1.00 12.41           C  
ATOM    233  O   GLU A  32      36.086  -7.600  22.790  1.00 12.12           O  
ATOM    234  CB  GLU A  32      38.765  -9.311  23.498  1.00 15.57           C  
ATOM    235  CG  GLU A  32      39.177 -10.710  24.093  1.00 17.68           C  
ATOM    236  CD  GLU A  32      40.236 -10.603  25.125  1.00 27.23           C  
ATOM    237  OE1 GLU A  32      40.912  -9.572  25.144  1.00 27.23           O  
ATOM    238  OE2 GLU A  32      40.406 -11.572  25.916  1.00 28.48           O  
ATOM    239  N   VAL A  33      37.674  -7.489  21.184  1.00 11.47           N  
ATOM    240  CA  VAL A  33      37.273  -6.128  20.763  1.00 10.64           C  
ATOM    241  C   VAL A  33      35.876  -6.186  20.160  1.00 11.31           C  
ATOM    242  O   VAL A  33      35.006  -5.369  20.481  1.00 11.13           O  
ATOM    243  CB  VAL A  33      38.291  -5.483  19.792  1.00 12.12           C  
ATOM    244  CG1 VAL A  33      37.641  -4.141  19.199  1.00 10.71           C  
ATOM    245  CG2 VAL A  33      39.667  -5.222  20.536  1.00 12.35           C  
ATOM    246  N   GLN A  34      35.619  -7.193  19.330  1.00 10.30           N  
ATOM    247  CA  GLN A  34      34.260  -7.365  18.798  1.00 10.31           C  
ATOM    248  C   GLN A  34      33.204  -7.600  19.883  1.00 12.61           C  
ATOM    249  O   GLN A  34      32.101  -7.056  19.821  1.00 10.38           O  
ATOM    250  CB  GLN A  34      34.267  -8.523  17.828  1.00 10.80           C  
ATOM    251  CG  GLN A  34      32.953  -8.619  17.065  1.00 14.77           C  
ATOM    252  CD  GLN A  34      33.084  -9.738  16.097  1.00 24.52           C  
ATOM    253  OE1 GLN A  34      33.837 -10.706  16.351  1.00 30.68           O  
ATOM    254  NE2 GLN A  34      32.367  -9.663  15.028  1.00 22.15           N  
ATOM    255  N   ALA A  35      33.543  -8.416  20.894  1.00 11.44           N  
ATOM    256  CA  ALA A  35      32.591  -8.712  21.953  1.00 11.81           C  
ATOM    257  C   ALA A  35      32.238  -7.479  22.779  1.00 10.77           C  
ATOM    258  O   ALA A  35      31.062  -7.293  23.132  1.00 11.16           O  
ATOM    259  CB  ALA A  35      33.161  -9.770  22.872  1.00 12.75           C  
ATOM    260  N   VAL A  36      33.253  -6.641  23.052  1.00 10.87           N  
ATOM    261  CA  VAL A  36      33.028  -5.443  23.876  0.50 11.43           C  
ATOM    263  C   VAL A  36      32.198  -4.423  23.062  1.00 11.40           C  
ATOM    264  O   VAL A  36      31.258  -3.801  23.591  1.00 10.26           O  
ATOM    265  CB  VAL A  36      34.369  -4.840  24.493  0.50 12.00           C  
ATOM    267  CG1 VAL A  36      35.070  -5.855  25.496  0.50  8.60           C  
ATOM    269  CG2 VAL A  36      35.350  -4.372  23.455  0.50 13.39           C  
ATOM    271  N   LEU A  37      32.486  -4.316  21.770  1.00 12.91           N  
ATOM    272  CA  LEU A  37      31.716  -3.388  20.917  1.00 11.87           C  
ATOM    273  C   LEU A  37      30.260  -3.851  20.868  1.00 12.27           C  
ATOM    274  O   LEU A  37      29.312  -3.062  21.002  1.00 12.57           O  
ATOM    275  CB  LEU A  37      32.316  -3.280  19.506  1.00 10.50           C  
ATOM    276  CG  LEU A  37      33.612  -2.481  19.378  1.00 13.43           C  
ATOM    277  CD1 LEU A  37      34.328  -2.774  18.026  1.00 14.78           C  
ATOM    278  CD2 LEU A  37      33.338  -0.928  19.558  1.00 11.79           C  
ATOM    279  N   GLU A  38      30.046  -5.141  20.677  1.00 12.99           N  
ATOM    280  CA  GLU A  38      28.695  -5.667  20.628  1.00 13.78           C  
ATOM    281  C   GLU A  38      27.965  -5.487  21.968  1.00 13.99           C  
ATOM    282  O   GLU A  38      26.757  -5.218  21.986  1.00 14.05           O  
ATOM    283  CB  GLU A  38      28.756  -7.143  20.279  1.00 14.72           C  
ATOM    284  CG  GLU A  38      27.441  -7.713  19.891  1.00 20.76           C  
ATOM    285  CD  GLU A  38      27.594  -8.814  18.878  1.00 24.97           C  
ATOM    286  OE1 GLU A  38      27.900  -8.575  17.686  1.00 21.95           O  
ATOM    287  OE2 GLU A  38      27.424  -9.956  19.306  1.00 26.36           O  
ATOM    288  N   ALA A  39      28.705  -5.593  23.075  1.00 12.47           N  
ATOM    289  CA  ALA A  39      28.114  -5.520  24.411  1.00 12.24           C  
ATOM    290  C   ALA A  39      27.616  -4.091  24.772  1.00 12.85           C  
ATOM    291  O   ALA A  39      26.716  -3.942  25.594  1.00 13.64           O  
ATOM    292  CB  ALA A  39      29.114  -6.033  25.493  1.00 13.28           C  
ATOM    293  N   TYR A  40      28.185  -3.063  24.150  1.00 12.29           N  
ATOM    294  CA  TYR A  40      27.681  -1.697  24.428  1.00 11.57           C  
ATOM    295  C   TYR A  40      26.265  -1.571  23.818  1.00 13.54           C  
ATOM    296  O   TYR A  40      26.082  -1.781  22.608  1.00 11.78           O  
ATOM    297  CB  TYR A  40      28.647  -0.661  23.790  1.00 11.33           C  
ATOM    298  CG  TYR A  40      27.996   0.717  23.700  1.00 11.26           C  
ATOM    299  CD1 TYR A  40      27.548   1.356  24.836  1.00 11.53           C  
ATOM    300  CD2 TYR A  40      27.833   1.380  22.444  1.00 11.40           C  
ATOM    301  CE1 TYR A  40      26.962   2.611  24.779  1.00 13.30           C  
ATOM    302  CE2 TYR A  40      27.218   2.656  22.380  1.00 11.54           C  
ATOM    303  CZ  TYR A  40      26.783   3.252  23.556  1.00 11.49           C  
ATOM    304  OH  TYR A  40      26.150   4.487  23.530  1.00 10.84           O  
ATOM    305  N   GLU A  41      25.264  -1.230  24.629  1.00 13.69           N  
ATOM    306  CA  GLU A  41      23.893  -1.073  24.152  0.50 15.05           C  
ATOM    308  C   GLU A  41      23.769   0.368  23.630  1.00 14.16           C  
ATOM    309  O   GLU A  41      23.858   1.289  24.396  1.00 14.02           O  
ATOM    310  CB  GLU A  41      22.912  -1.297  25.310  0.50 15.75           C  
ATOM    312  CG  GLU A  41      21.449  -1.345  24.880  0.50 16.81           C  
ATOM    314  CD  GLU A  41      20.512  -1.828  25.997  0.50 20.03           C  
ATOM    316  OE1 GLU A  41      20.371  -3.059  26.185  0.50 24.95           O  
ATOM    318  OE2 GLU A  41      19.902  -0.980  26.665  0.50 24.64           O  
ATOM    320  N   SER A  42      23.606   0.517  22.331  1.00 13.50           N  
ATOM    321  CA  SER A  42      23.540   1.864  21.721  1.00 12.65           C  
ATOM    322  C   SER A  42      22.550   2.755  22.476  1.00 13.06           C  
ATOM    323  O   SER A  42      21.371   2.388  22.644  1.00 15.05           O  
ATOM    324  CB  SER A  42      23.166   1.745  20.243  1.00 13.73           C  
ATOM    325  OG  SER A  42      23.001   3.068  19.714  1.00 12.12           O  
ATOM    326  N   ASN A  43      23.021   3.913  22.911  1.00 13.62           N  
ATOM    327  CA  ASN A  43      22.167   4.907  23.569  1.00 15.20           C  
ATOM    328  C   ASN A  43      22.260   6.225  22.792  1.00 14.37           C  
ATOM    329  O   ASN A  43      23.281   6.921  22.847  1.00 14.04           O  
ATOM    330  CB  ASN A  43      22.615   5.075  25.007  1.00 14.57           C  
ATOM    331  CG  ASN A  43      21.793   6.127  25.738  1.00 20.31           C  
ATOM    332  OD1 ASN A  43      20.957   6.797  25.121  1.00 22.66           O  
ATOM    333  ND2 ASN A  43      21.991   6.246  27.047  1.00 18.94           N  
ATOM    334  N   PRO A  44      21.236   6.523  21.968  1.00 15.15           N  
ATOM    335  CA  PRO A  44      21.400   7.725  21.126  1.00 14.58           C  
ATOM    336  C   PRO A  44      21.800   9.008  21.821  1.00 13.80           C  
ATOM    337  O   PRO A  44      22.484   9.832  21.177  1.00 13.98           O  
ATOM    338  CB  PRO A  44      20.042   7.863  20.430  1.00 15.13           C  
ATOM    339  CG  PRO A  44      19.480   6.463  20.401  1.00 17.40           C  
ATOM    340  CD  PRO A  44      19.962   5.817  21.685  1.00 17.33           C  
ATOM    341  N   ALA A  45      21.423   9.233  23.099  1.00 13.22           N  
ATOM    342  CA  ALA A  45      21.794  10.497  23.752  1.00 14.19           C  
ATOM    343  C   ALA A  45      23.298  10.655  23.870  1.00 14.26           C  
ATOM    344  O   ALA A  45      23.825  11.791  23.863  1.00 15.35           O  
ATOM    345  CB  ALA A  45      21.225  10.556  25.165  1.00 15.51           C  
ATOM    346  N   GLU A  46      23.994   9.510  23.980  1.00 12.88           N  
ATOM    347  CA  GLU A  46      25.440   9.499  24.152  1.00 11.48           C  
ATOM    348  C   GLU A  46      26.229   9.798  22.891  1.00 12.34           C  
ATOM    349  O   GLU A  46      27.392  10.237  22.986  1.00 12.62           O  
ATOM    350  CB  GLU A  46      25.922   8.154  24.685  1.00 12.74           C  
ATOM    351  CG  GLU A  46      25.346   7.912  26.106  1.00 12.95           C  
ATOM    352  CD  GLU A  46      25.604   6.531  26.644  1.00 16.82           C  
ATOM    353  OE1 GLU A  46      26.170   5.683  25.914  1.00 14.66           O  
ATOM    354  OE2 GLU A  46      25.257   6.316  27.829  1.00 17.12           O  
ATOM    355  N   TRP A  47      25.625   9.535  21.732  1.00 11.71           N  
ATOM    356  CA  TRP A  47      26.352   9.740  20.459  1.00 12.54           C  
ATOM    357  C   TRP A  47      25.729  10.767  19.514  1.00 12.73           C  
ATOM    358  O   TRP A  47      26.297  11.079  18.456  1.00 12.32           O  
ATOM    359  CB  TRP A  47      26.678   8.380  19.790  1.00 11.75           C  
ATOM    360  CG  TRP A  47      25.498   7.457  19.590  1.00 11.57           C  
ATOM    361  CD1 TRP A  47      25.244   6.299  20.286  1.00 11.65           C  
ATOM    362  CD2 TRP A  47      24.515   7.534  18.561  1.00 12.77           C  
ATOM    363  NE1 TRP A  47      24.108   5.716  19.801  1.00 11.63           N  
ATOM    364  CE2 TRP A  47      23.654   6.436  18.725  1.00 12.89           C  
ATOM    365  CE3 TRP A  47      24.227   8.480  17.554  1.00 13.07           C  
ATOM    366  CZ2 TRP A  47      22.533   6.215  17.891  1.00 12.47           C  
ATOM    367  CZ3 TRP A  47      23.109   8.277  16.743  1.00 12.26           C  
ATOM    368  CH2 TRP A  47      22.268   7.163  16.918  1.00 12.45           C  
ATOM    369  N   ALA A  48      24.637  11.388  19.944  1.00 12.72           N  
ATOM    370  CA  ALA A  48      23.977  12.430  19.125  1.00 12.99           C  
ATOM    371  C   ALA A  48      24.958  13.503  18.637  1.00 13.53           C  
ATOM    372  O   ALA A  48      24.869  13.955  17.474  1.00 12.64           O  
ATOM    373  CB  ALA A  48      22.834  13.080  19.916  1.00 13.72           C  
ATOM    374  N   LEU A  49      25.903  13.895  19.508  1.00 13.59           N  
ATOM    375  CA  LEU A  49      26.897  14.911  19.153  1.00 13.14           C  
ATOM    376  C   LEU A  49      27.621  14.591  17.825  1.00 12.86           C  
ATOM    377  O   LEU A  49      28.013  15.499  17.082  1.00 13.79           O  
ATOM    378  CB  LEU A  49      27.908  15.079  20.273  1.00 12.50           C  
ATOM    379  CG  LEU A  49      29.079  16.038  20.084  1.00 14.16           C  
ATOM    380  CD1 LEU A  49      28.579  17.468  19.966  1.00 14.13           C  
ATOM    381  CD2 LEU A  49      30.085  15.880  21.261  1.00 13.57           C  
ATOM    382  N   TYR A  50      27.826  13.298  17.561  1.00 11.42           N  
ATOM    383  CA  TYR A  50      28.602  12.871  16.438  1.00 11.80           C  
ATOM    384  C   TYR A  50      27.783  12.534  15.230  1.00 12.16           C  
ATOM    385  O   TYR A  50      28.369  12.378  14.146  1.00 12.87           O  
ATOM    386  CB  TYR A  50      29.430  11.610  16.823  1.00 11.14           C  
ATOM    387  CG  TYR A  50      30.226  11.818  18.081  1.00  9.86           C  
ATOM    388  CD1 TYR A  50      31.354  12.658  18.104  1.00 11.71           C  
ATOM    389  CD2 TYR A  50      29.804  11.208  19.277  1.00 10.12           C  
ATOM    390  CE1 TYR A  50      32.060  12.857  19.313  1.00 14.26           C  
ATOM    391  CE2 TYR A  50      30.517  11.381  20.458  1.00 14.88           C  
ATOM    392  CZ  TYR A  50      31.655  12.197  20.445  1.00 13.94           C  
ATOM    393  OH  TYR A  50      32.334  12.336  21.617  1.00 16.39           O  
ATOM    394  N   ALA A  51      26.476  12.463  15.392  1.00 12.57           N  
ATOM    395  CA  ALA A  51      25.557  11.977  14.331  1.00 14.68           C  
ATOM    396  C   ALA A  51      25.179  13.144  13.409  1.00 14.46           C  
ATOM    397  O   ALA A  51      24.042  13.660  13.432  1.00 16.25           O  
ATOM    398  CB  ALA A  51      24.329  11.336  14.941  1.00 16.97           C  
ATOM    399  N   LYS A  52      26.174  13.602  12.652  1.00 12.44           N  
ATOM    400  CA  LYS A  52      26.021  14.766  11.761  1.00 13.40           C  
ATOM    401  C   LYS A  52      25.877  14.241  10.358  1.00 12.19           C  
ATOM    402  O   LYS A  52      26.817  13.704   9.797  1.00 13.02           O  
ATOM    403  CB  LYS A  52      27.279  15.607  11.813  1.00 12.84           C  
ATOM    404  CG  LYS A  52      27.606  16.176  13.239  1.00 13.87           C  
ATOM    405  CD  LYS A  52      28.909  17.019  13.169  1.00 16.37           C  
ATOM    406  CE  LYS A  52      29.519  17.154  14.564  1.00 17.65           C  
ATOM    407  NZ  LYS A  52      28.593  17.928  15.558  1.00 17.68           N  
ATOM    408  N   PHE A  53      24.679  14.374   9.816  1.00 11.43           N  
ATOM    409  CA  PHE A  53      24.392  13.817   8.504  1.00 11.11           C  
ATOM    410  C   PHE A  53      24.610  14.839   7.378  1.00 11.40           C  
ATOM    411  O   PHE A  53      24.558  16.058   7.616  1.00 11.67           O  
ATOM    412  CB  PHE A  53      22.922  13.387   8.462  1.00 12.35           C  
ATOM    413  CG  PHE A  53      22.641  12.088   9.177  1.00 11.02           C  
ATOM    414  CD1 PHE A  53      22.458  10.920   8.425  1.00 11.11           C  
ATOM    415  CD2 PHE A  53      22.542  12.039  10.574  1.00 11.97           C  
ATOM    416  CE1 PHE A  53      22.207   9.705   9.061  1.00 14.01           C  
ATOM    417  CE2 PHE A  53      22.304  10.809  11.216  1.00 13.50           C  
ATOM    418  CZ  PHE A  53      22.113   9.657  10.446  1.00 13.60           C  
ATOM    419  N   ASP A  54      24.822  14.320   6.166  1.00 11.41           N  
ATOM    420  CA  ASP A  54      24.822  15.100   4.949  1.00 12.02           C  
ATOM    421  C   ASP A  54      23.706  14.549   4.074  1.00 11.91           C  
ATOM    422  O   ASP A  54      23.479  13.360   4.038  1.00 12.54           O  
ATOM    423  CB  ASP A  54      26.130  14.949   4.209  1.00 12.36           C  
ATOM    424  CG  ASP A  54      26.168  15.793   2.917  1.00 14.39           C  
ATOM    425  OD1 ASP A  54      26.421  16.998   3.041  1.00 15.18           O  
ATOM    426  OD2 ASP A  54      25.968  15.202   1.841  1.00 15.27           O  
ATOM    427  N   GLN A  55      23.018  15.446   3.367  1.00 12.57           N  
ATOM    428  CA  GLN A  55      21.909  14.952   2.522  1.00 13.49           C  
ATOM    429  C   GLN A  55      22.324  13.994   1.403  1.00 12.88           C  
ATOM    430  O   GLN A  55      21.535  13.100   1.028  1.00 14.91           O  
ATOM    431  CB  GLN A  55      21.180  16.153   1.884  1.00 14.76           C  
ATOM    432  CG  GLN A  55      19.992  15.672   1.062  1.00 19.30           C  
ATOM    433  CD  GLN A  55      19.054  16.786   0.676  1.00 24.01           C  
ATOM    434  OE1 GLN A  55      19.006  17.780   1.354  1.00 25.42           O  
ATOM    435  NE2 GLN A  55      18.318  16.621  -0.444  1.00 22.70           N  
ATOM    436  N   TYR A  56      23.532  14.181   0.888  1.00 11.50           N  
ATOM    437  CA  TYR A  56      23.946  13.564  -0.375  1.00 11.64           C  
ATOM    438  C   TYR A  56      24.819  12.308  -0.225  1.00 12.92           C  
ATOM    439  O   TYR A  56      24.814  11.455  -1.121  1.00 13.01           O  
ATOM    440  CB  TYR A  56      24.626  14.582  -1.266  1.00 14.10           C  
ATOM    441  CG  TYR A  56      23.705  15.777  -1.401  1.00 15.87           C  
ATOM    442  CD1 TYR A  56      22.448  15.641  -2.033  1.00 20.48           C  
ATOM    443  CD2 TYR A  56      24.021  16.992  -0.800  1.00 14.86           C  
ATOM    444  CE1 TYR A  56      21.559  16.716  -2.104  1.00 18.64           C  
ATOM    445  CE2 TYR A  56      23.123  18.106  -0.855  1.00 18.51           C  
ATOM    446  CZ  TYR A  56      21.896  17.955  -1.512  1.00 21.64           C  
ATOM    447  OH  TYR A  56      20.973  19.049  -1.558  1.00 21.16           O  
ATOM    448  N   ARG A  57      25.610  12.203   0.855  1.00 11.36           N  
ATOM    449  CA  ARG A  57      26.372  10.952   0.993  1.00 10.91           C  
ATOM    450  C   ARG A  57      26.612  10.653   2.488  1.00 11.52           C  
ATOM    451  O   ARG A  57      26.338  11.502   3.364  1.00  9.79           O  
ATOM    452  CB  ARG A  57      27.731  11.075   0.296  1.00 12.61           C  
ATOM    453  CG  ARG A  57      28.561  12.243   0.825  1.00 12.65           C  
ATOM    454  CD  ARG A  57      30.071  11.977   0.629  1.00 22.94           C  
ATOM    455  NE  ARG A  57      30.520  10.846   1.465  1.00 19.50           N  
ATOM    456  CZ  ARG A  57      31.679  10.233   1.288  1.00 25.99           C  
ATOM    457  NH1 ARG A  57      32.507  10.652   0.327  1.00 24.40           N  
ATOM    458  NH2 ARG A  57      32.015   9.207   2.066  1.00 25.47           N  
ATOM    459  N   TYR A  58      27.204   9.515   2.770  1.00 11.38           N  
ATOM    460  CA  TYR A  58      27.445   9.230   4.214  1.00 10.65           C  
ATOM    461  C   TYR A  58      28.619  10.073   4.737  1.00  9.64           C  
ATOM    462  O   TYR A  58      29.513  10.501   3.959  1.00 10.89           O  
ATOM    463  CB  TYR A  58      27.730   7.756   4.478  1.00 11.03           C  
ATOM    464  CG  TYR A  58      29.036   7.273   3.914  1.00 13.81           C  
ATOM    465  CD1 TYR A  58      30.188   7.241   4.731  1.00 14.72           C  
ATOM    466  CD2 TYR A  58      29.121   6.791   2.605  1.00 14.81           C  
ATOM    467  CE1 TYR A  58      31.383   6.785   4.251  1.00 17.82           C  
ATOM    468  CE2 TYR A  58      30.339   6.303   2.113  1.00 17.54           C  
ATOM    469  CZ  TYR A  58      31.455   6.341   2.938  1.00 18.66           C  
ATOM    470  OH  TYR A  58      32.665   5.825   2.524  1.00 22.98           O  
ATOM    471  N   THR A  59      28.614  10.310   6.048  1.00  9.69           N  
ATOM    472  CA  THR A  59      29.648  11.177   6.644  1.00  8.95           C  
ATOM    473  C   THR A  59      30.448  10.375   7.660  1.00  8.41           C  
ATOM    474  O   THR A  59      29.929   9.442   8.258  1.00  8.05           O  
ATOM    475  CB  THR A  59      29.017  12.347   7.375  1.00  8.57           C  
ATOM    476  OG1 THR A  59      28.167  11.895   8.413  1.00 10.36           O  
ATOM    477  CG2 THR A  59      28.238  13.275   6.392  1.00 12.93           C  
ATOM    478  N   ARG A  60      31.719  10.736   7.820  1.00  8.60           N  
ATOM    479  CA  ARG A  60      32.631  10.084   8.806  1.00  9.20           C  
ATOM    480  C   ARG A  60      32.960  11.108   9.910  1.00  9.10           C  
ATOM    481  O   ARG A  60      33.492  12.222   9.614  1.00 11.10           O  
ATOM    482  CB  ARG A  60      33.969   9.672   8.101  1.00 11.24           C  
ATOM    483  CG  ARG A  60      33.742   8.677   6.965  1.00 12.71           C  
ATOM    484  CD  ARG A  60      35.078   8.499   6.144  1.00 14.61           C  
ATOM    485  NE  ARG A  60      36.083   7.758   6.875  1.00 20.67           N  
ATOM    486  CZ  ARG A  60      37.252   8.260   7.304  1.00 25.52           C  
ATOM    487  NH1 ARG A  60      37.530   9.548   7.178  1.00 25.53           N  
ATOM    488  NH2 ARG A  60      38.169   7.466   7.876  1.00 25.86           N  
ATOM    489  N   ASN A  61      32.722  10.716  11.161  1.00  8.44           N  
ATOM    490  CA  ASN A  61      32.743  11.664  12.282  1.00  8.39           C  
ATOM    491  C   ASN A  61      33.663  11.120  13.348  1.00  9.63           C  
ATOM    492  O   ASN A  61      33.306  10.142  14.029  1.00  9.75           O  
ATOM    493  CB  ASN A  61      31.292  11.882  12.800  1.00  7.73           C  
ATOM    494  CG  ASN A  61      30.402  12.446  11.699  1.00  9.61           C  
ATOM    495  OD1 ASN A  61      30.461  13.635  11.386  1.00  9.98           O  
ATOM    496  ND2 ASN A  61      29.643  11.570  11.058  1.00 10.72           N  
ATOM    497  N   LEU A  62      34.851  11.708  13.479  1.00  9.72           N  
ATOM    498  CA  LEU A  62      35.865  11.117  14.377  1.00 10.65           C  
ATOM    499  C   LEU A  62      35.401  11.334  15.817  1.00 10.47           C  
ATOM    500  O   LEU A  62      34.991  12.423  16.213  1.00 11.57           O  
ATOM    501  CB  LEU A  62      37.241  11.801  14.151  1.00  9.95           C  
ATOM    502  CG  LEU A  62      38.423  11.250  15.034  1.00 11.77           C  
ATOM    503  CD1 LEU A  62      38.717   9.773  14.715  1.00 13.61           C  
ATOM    504  CD2 LEU A  62      39.626  12.160  14.722  1.00 13.40           C  
ATOM    505  N   VAL A  63      35.496  10.277  16.619  1.00  9.65           N  
ATOM    506  CA  VAL A  63      35.105  10.325  18.020  1.00 10.02           C  
ATOM    507  C   VAL A  63      36.333  10.273  18.935  1.00 11.04           C  
ATOM    508  O   VAL A  63      36.400  11.018  19.939  1.00 12.36           O  
ATOM    509  CB  VAL A  63      34.187   9.111  18.358  1.00  9.87           C  
ATOM    510  CG1 VAL A  63      33.847   9.044  19.917  1.00 11.69           C  
ATOM    511  CG2 VAL A  63      32.841   9.107  17.551  1.00 11.13           C  
ATOM    512  N   ASP A  64      37.256   9.391  18.625  1.00 11.15           N  
ATOM    513  CA  ASP A  64      38.446   9.186  19.487  1.00 12.92           C  
ATOM    514  C   ASP A  64      39.639   8.757  18.646  1.00 12.94           C  
ATOM    515  O   ASP A  64      39.522   7.942  17.733  1.00 11.70           O  
ATOM    516  CB  ASP A  64      38.129   8.121  20.545  1.00 12.56           C  
ATOM    517  CG  ASP A  64      39.161   8.109  21.696  1.00 15.78           C  
ATOM    518  OD1 ASP A  64      39.013   8.897  22.666  1.00 19.71           O  
ATOM    519  OD2 ASP A  64      40.077   7.300  21.587  1.00 18.07           O  
ATOM    520  N   GLN A  65      40.822   9.323  18.956  1.00 15.95           N  
ATOM    521  CA  GLN A  65      42.054   8.913  18.242  1.00 18.64           C  
ATOM    522  C   GLN A  65      42.905   7.828  18.830  1.00 19.82           C  
ATOM    523  O   GLN A  65      43.981   7.535  18.296  1.00 21.35           O  
ATOM    524  CB  GLN A  65      42.946  10.135  18.032  1.00 20.63           C  
ATOM    525  CG  GLN A  65      42.341  10.970  17.011  1.00 23.56           C  
ATOM    526  CD  GLN A  65      43.184  12.113  16.635  1.00 25.13           C  
ATOM    527  OE1 GLN A  65      43.581  12.913  17.480  1.00 28.77           O  
ATOM    528  NE2 GLN A  65      43.437  12.241  15.352  1.00 29.39           N  
ATOM    529  N   GLY A  66      42.445   7.242  19.926  1.00 18.62           N  
ATOM    530  CA  GLY A  66      42.919   5.982  20.369  1.00 21.18           C  
ATOM    531  C   GLY A  66      44.356   6.051  20.825  1.00 23.79           C  
ATOM    532  O   GLY A  66      45.041   5.042  20.761  1.00 23.45           O  
ATOM    533  N   ASN A  67      44.786   7.239  21.259  1.00 25.46           N  
ATOM    534  CA  ASN A  67      46.212   7.423  21.675  1.00 28.58           C  
ATOM    535  C   ASN A  67      47.139   6.896  20.550  1.00 28.20           C  
ATOM    536  O   ASN A  67      48.204   6.291  20.828  1.00 29.48           O  
ATOM    537  CB  ASN A  67      46.455   6.657  22.999  1.00 29.68           C  
ATOM    538  CG  ASN A  67      46.265   7.533  24.274  1.00 34.97           C  
ATOM    539  OD1 ASN A  67      45.154   7.978  24.598  1.00 38.01           O  
ATOM    540  ND2 ASN A  67      47.369   7.759  25.010  1.00 40.01           N  
ATOM    541  N   GLY A  68      46.693   7.068  19.292  1.00 27.64           N  
ATOM    542  CA  GLY A  68      47.423   6.640  18.091  1.00 26.50           C  
ATOM    543  C   GLY A  68      47.343   5.174  17.624  1.00 25.35           C  
ATOM    544  O   GLY A  68      47.874   4.822  16.564  1.00 25.81           O  
ATOM    545  N   LYS A  69      46.662   4.324  18.386  1.00 23.32           N  
ATOM    546  CA  LYS A  69      46.590   2.893  18.065  1.00 22.30           C  
ATOM    547  C   LYS A  69      45.394   2.548  17.154  1.00 19.76           C  
ATOM    548  O   LYS A  69      45.379   1.484  16.483  1.00 18.76           O  
ATOM    549  CB  LYS A  69      46.399   2.127  19.358  1.00 23.64           C  
ATOM    550  CG  LYS A  69      47.620   2.159  20.289  1.00 24.37           C  
ATOM    551  CD  LYS A  69      48.739   1.316  19.695  1.00 27.18           C  
ATOM    552  CE  LYS A  69      49.889   1.127  20.672  1.00 27.57           C  
ATOM    553  NZ  LYS A  69      49.551   0.645  22.024  1.00 27.15           N  
ATOM    554  N   PHE A  70      44.401   3.424  17.183  1.00 19.35           N  
ATOM    555  CA  PHE A  70      43.128   3.203  16.493  1.00 17.78           C  
ATOM    556  C   PHE A  70      42.381   4.502  16.309  1.00 18.47           C  
ATOM    557  O   PHE A  70      42.631   5.474  17.040  1.00 19.68           O  
ATOM    558  CB  PHE A  70      42.278   2.150  17.242  1.00 17.61           C  
ATOM    559  CG  PHE A  70      41.648   2.636  18.569  1.00 15.95           C  
ATOM    560  CD1 PHE A  70      40.510   3.482  18.591  1.00 18.26           C  
ATOM    561  CD2 PHE A  70      42.163   2.219  19.751  1.00 20.41           C  
ATOM    562  CE1 PHE A  70      39.930   3.869  19.850  1.00 18.64           C  
ATOM    563  CE2 PHE A  70      41.591   2.611  20.971  1.00 20.23           C  
ATOM    564  CZ  PHE A  70      40.485   3.425  20.995  1.00 17.41           C  
ATOM    565  N   ASN A  71      41.503   4.541  15.312  1.00 18.21           N  
ATOM    566  CA  ASN A  71      40.583   5.685  15.065  1.00 17.73           C  
ATOM    567  C   ASN A  71      39.214   5.072  15.425  1.00 15.65           C  
ATOM    568  O   ASN A  71      38.888   3.930  14.979  1.00 16.34           O  
ATOM    569  CB  ASN A  71      40.538   6.014  13.562  1.00 18.68           C  
ATOM    570  CG  ASN A  71      41.464   7.165  13.123  1.00 21.73           C  
ATOM    571  OD1 ASN A  71      41.933   7.963  13.911  1.00 27.36           O  
ATOM    572  ND2 ASN A  71      41.743   7.196  11.820  1.00 26.64           N  
ATOM    573  N   LEU A  72      38.439   5.749  16.273  1.00 12.58           N  
ATOM    574  CA  LEU A  72      37.042   5.351  16.499  1.00 11.31           C  
ATOM    575  C   LEU A  72      36.166   6.466  15.915  1.00 11.13           C  
ATOM    576  O   LEU A  72      36.375   7.642  16.214  1.00 10.43           O  
ATOM    577  CB  LEU A  72      36.785   5.233  18.022  1.00 11.51           C  
ATOM    578  CG  LEU A  72      35.357   4.777  18.394  1.00 11.46           C  
ATOM    579  CD1 LEU A  72      35.078   3.246  18.036  1.00 10.32           C  
ATOM    580  CD2 LEU A  72      35.105   4.963  19.899  1.00 12.65           C  
HETATM  581  N   MSE A  73      35.193   6.109  15.072  1.00  9.92           N  
HETATM  582  CA  MSE A  73      34.437   7.136  14.347  1.00  9.79           C  
HETATM  583  C   MSE A  73      33.015   6.659  14.146  1.00  9.43           C  
HETATM  584  O   MSE A  73      32.721   5.427  14.313  1.00 10.28           O  
HETATM  585  CB  MSE A  73      35.092   7.453  12.979  1.00  9.80           C  
HETATM  586  CG  MSE A  73      35.113   6.266  12.061  1.00 12.13           C  
HETATM  587 SE   MSE A  73      36.133   6.638  10.477  1.00 13.55          SE  
HETATM  588  CE  MSE A  73      37.822   6.550  11.314  1.00 13.74           C  
ATOM    589  N   ILE A  74      32.112   7.624  13.932  1.00  8.76           N  
ATOM    590  CA  ILE A  74      30.693   7.324  13.694  1.00  7.97           C  
ATOM    591  C   ILE A  74      30.379   7.733  12.264  1.00  9.52           C  
ATOM    592  O   ILE A  74      30.727   8.836  11.830  1.00  9.17           O  
ATOM    593  CB  ILE A  74      29.810   8.043  14.710  1.00  8.22           C  
ATOM    594  CG1 ILE A  74      29.919   7.212  16.018  1.00 10.95           C  
ATOM    595  CG2 ILE A  74      28.322   8.144  14.217  1.00 11.31           C  
ATOM    596  CD1 ILE A  74      29.305   7.890  17.231  1.00 12.12           C  
ATOM    597  N   LEU A  75      29.786   6.791  11.530  1.00  8.27           N  
ATOM    598  CA  LEU A  75      29.362   7.061  10.136  1.00  8.47           C  
ATOM    599  C   LEU A  75      27.834   7.149  10.100  1.00  9.54           C  
ATOM    600  O   LEU A  75      27.116   6.375  10.732  1.00  8.89           O  
ATOM    601  CB  LEU A  75      29.853   5.975   9.169  1.00  9.83           C  
ATOM    602  CG  LEU A  75      31.301   6.123   8.629  1.00  8.99           C  
ATOM    603  CD1 LEU A  75      32.349   6.250   9.735  1.00 10.25           C  
ATOM    604  CD2 LEU A  75      31.641   4.976   7.614  1.00 11.70           C  
ATOM    605  N   CYS A  76      27.372   8.169   9.385  1.00  8.65           N  
ATOM    606  CA  CYS A  76      25.946   8.506   9.327  1.00  8.55           C  
ATOM    607  C   CYS A  76      25.515   8.345   7.903  1.00  9.97           C  
ATOM    608  O   CYS A  76      26.060   9.022   7.016  1.00  8.82           O  
ATOM    609  CB  CYS A  76      25.760   9.968   9.789  1.00  9.63           C  
ATOM    610  SG  CYS A  76      26.205  10.196  11.518  1.00 13.68           S  
ATOM    611  N   TRP A  77      24.507   7.464   7.691  1.00  9.20           N  
ATOM    612  CA  TRP A  77      24.144   7.017   6.319  1.00  8.43           C  
ATOM    613  C   TRP A  77      22.693   7.459   6.126  1.00 10.70           C  
ATOM    614  O   TRP A  77      21.771   6.959   6.787  1.00 12.49           O  
ATOM    615  CB  TRP A  77      24.144   5.505   6.229  1.00 10.07           C  
ATOM    616  CG  TRP A  77      25.424   4.854   6.735  1.00 10.59           C  
ATOM    617  CD1 TRP A  77      25.768   4.624   8.036  1.00 12.12           C  
ATOM    618  CD2 TRP A  77      26.497   4.353   5.930  1.00  9.44           C  
ATOM    619  NE1 TRP A  77      26.989   3.990   8.099  1.00  9.25           N  
ATOM    620  CE2 TRP A  77      27.465   3.827   6.816  1.00 11.23           C  
ATOM    621  CE3 TRP A  77      26.735   4.277   4.538  1.00 12.94           C  
ATOM    622  CZ2 TRP A  77      28.642   3.231   6.360  1.00 10.38           C  
ATOM    623  CZ3 TRP A  77      27.885   3.709   4.092  1.00 12.41           C  
ATOM    624  CH2 TRP A  77      28.853   3.174   5.022  1.00 11.81           C  
ATOM    625  N   GLY A  78      22.504   8.425   5.258  1.00 10.50           N  
ATOM    626  CA  GLY A  78      21.119   8.820   4.917  1.00 10.71           C  
ATOM    627  C   GLY A  78      20.448   7.640   4.207  1.00 12.13           C  
ATOM    628  O   GLY A  78      21.099   6.667   3.775  1.00 10.51           O  
ATOM    629  N   GLU A  79      19.117   7.751   4.047  1.00 10.96           N  
ATOM    630  CA  GLU A  79      18.405   6.750   3.241  1.00 13.13           C  
ATOM    631  C   GLU A  79      19.039   6.591   1.858  1.00 11.89           C  
ATOM    632  O   GLU A  79      19.237   7.563   1.067  1.00 12.13           O  
ATOM    633  CB  GLU A  79      16.923   7.202   3.133  1.00 14.28           C  
ATOM    634  CG  GLU A  79      16.312   7.329   4.491  1.00 17.09           C  
ATOM    635  CD  GLU A  79      16.370   8.736   5.121  1.00 22.23           C  
ATOM    636  OE1 GLU A  79      17.334   9.517   4.943  1.00 20.89           O  
ATOM    637  OE2 GLU A  79      15.386   9.047   5.855  1.00 27.38           O  
ATOM    638  N   GLY A  80      19.385   5.349   1.526  1.00 12.25           N  
ATOM    639  CA  GLY A  80      19.994   5.062   0.240  1.00 12.17           C  
ATOM    640  C   GLY A  80      21.466   5.313   0.090  1.00 12.47           C  
ATOM    641  O   GLY A  80      22.034   5.045  -0.993  1.00 14.01           O  
ATOM    642  N   HIS A  81      22.130   5.839   1.129  1.00 10.79           N  
ATOM    643  CA  HIS A  81      23.524   6.140   0.999  1.00 10.41           C  
ATOM    644  C   HIS A  81      24.351   4.837   1.090  1.00  9.73           C  
ATOM    645  O   HIS A  81      24.076   4.022   1.930  1.00 12.45           O  
ATOM    646  CB  HIS A  81      23.971   7.055   2.122  1.00  9.36           C  
ATOM    647  CG  HIS A  81      23.493   8.469   1.966  1.00  8.96           C  
ATOM    648  ND1 HIS A  81      23.755   9.452   2.911  1.00 10.15           N  
ATOM    649  CD2 HIS A  81      22.768   9.061   0.980  1.00 14.78           C  
ATOM    650  CE1 HIS A  81      23.191  10.591   2.508  1.00  9.78           C  
ATOM    651  NE2 HIS A  81      22.608  10.383   1.330  1.00 12.51           N  
ATOM    652  N   GLY A  82      25.368   4.727   0.242  1.00 12.91           N  
ATOM    653  CA  GLY A  82      26.251   3.555   0.356  1.00 12.61           C  
ATOM    654  C   GLY A  82      27.701   3.909   0.075  1.00 11.88           C  
ATOM    655  O   GLY A  82      28.053   5.070  -0.274  1.00 11.45           O  
ATOM    656  N   SER A  83      28.560   2.910   0.290  1.00 12.10           N  
ATOM    657  CA  SER A  83      29.990   3.093   0.040  1.00 12.65           C  
ATOM    658  C   SER A  83      30.360   2.477  -1.322  1.00 12.19           C  
ATOM    659  O   SER A  83      29.538   1.802  -1.977  1.00 11.66           O  
ATOM    660  CB  SER A  83      30.791   2.351   1.134  1.00 11.95           C  
ATOM    661  OG  SER A  83      30.776   0.941   0.878  1.00 11.83           O  
ATOM    662  N   SER A  84      31.607   2.712  -1.688  1.00 12.87           N  
ATOM    663  CA  SER A  84      32.259   1.953  -2.771  0.50 12.87           C  
ATOM    665  C   SER A  84      32.529   0.550  -2.272  1.00 12.32           C  
ATOM    666  O   SER A  84      32.392   0.269  -1.069  1.00 12.09           O  
ATOM    667  CB  SER A  84      33.615   2.581  -3.121  0.50 14.17           C  
ATOM    669  OG  SER A  84      33.454   3.914  -3.565  0.50 18.69           O  
ATOM    671  N   ILE A  85      32.922  -0.327  -3.207  1.00 11.00           N  
ATOM    672  CA  ILE A  85      33.564  -1.612  -2.827  1.00 10.66           C  
ATOM    673  C   ILE A  85      34.957  -1.159  -2.418  1.00  9.47           C  
ATOM    674  O   ILE A  85      35.643  -0.448  -3.172  1.00 11.11           O  
ATOM    675  CB  ILE A  85      33.632  -2.587  -4.038  1.00 11.25           C  
ATOM    676  CG1 ILE A  85      32.212  -3.016  -4.447  1.00 13.01           C  
ATOM    677  CG2 ILE A  85      34.452  -3.836  -3.615  1.00 10.50           C  
ATOM    678  CD1 ILE A  85      32.208  -3.747  -5.839  1.00 13.01           C  
ATOM    679  N   HIS A  86      35.403  -1.521  -1.206  1.00  9.98           N  
ATOM    680  CA  HIS A  86      36.684  -1.005  -0.776  1.00 10.45           C  
ATOM    681  C   HIS A  86      37.463  -1.999   0.101  1.00  9.90           C  
ATOM    682  O   HIS A  86      36.920  -2.971   0.611  1.00  9.66           O  
ATOM    683  CB  HIS A  86      36.499   0.324  -0.029  1.00 11.20           C  
ATOM    684  CG  HIS A  86      35.634   0.203   1.189  1.00 13.31           C  
ATOM    685  ND1 HIS A  86      34.258   0.342   1.134  1.00 11.39           N  
ATOM    686  CD2 HIS A  86      35.930  -0.130   2.475  1.00 15.00           C  
ATOM    687  CE1 HIS A  86      33.744   0.111   2.337  1.00  9.96           C  
ATOM    688  NE2 HIS A  86      34.735  -0.158   3.182  1.00 12.49           N  
ATOM    689  N   ASP A  87      38.746  -1.697   0.285  1.00 10.40           N  
ATOM    690  CA  ASP A  87      39.592  -2.491   1.192  1.00 11.28           C  
ATOM    691  C   ASP A  87      39.806  -1.693   2.479  1.00 12.01           C  
ATOM    692  O   ASP A  87      39.178  -0.629   2.695  1.00 12.64           O  
ATOM    693  CB  ASP A  87      40.970  -2.781   0.517  1.00 10.72           C  
ATOM    694  CG  ASP A  87      41.743  -1.521   0.142  1.00 14.24           C  
ATOM    695  OD1 ASP A  87      41.316  -0.365   0.394  1.00 16.22           O  
ATOM    696  OD2 ASP A  87      42.841  -1.664  -0.463  1.00 16.72           O  
ATOM    697  N   HIS A  88      40.717  -2.185   3.338  1.00 10.91           N  
ATOM    698  CA  HIS A  88      40.923  -1.531   4.623  1.00 11.45           C  
ATOM    699  C   HIS A  88      42.412  -1.423   4.996  1.00 12.31           C  
ATOM    700  O   HIS A  88      42.743  -1.442   6.190  1.00 13.57           O  
ATOM    701  CB  HIS A  88      40.130  -2.259   5.734  1.00 11.96           C  
ATOM    702  CG  HIS A  88      38.662  -2.298   5.447  1.00 12.02           C  
ATOM    703  ND1 HIS A  88      38.098  -3.219   4.589  1.00 13.83           N  
ATOM    704  CD2 HIS A  88      37.691  -1.412   5.761  1.00 14.77           C  
ATOM    705  CE1 HIS A  88      36.799  -2.948   4.458  1.00 15.63           C  
ATOM    706  NE2 HIS A  88      36.535  -1.862   5.171  1.00 10.03           N  
ATOM    707  N   THR A  89      43.276  -1.329   3.979  1.00 11.54           N  
ATOM    708  CA  THR A  89      44.628  -0.748   4.116  1.00 13.37           C  
ATOM    709  C   THR A  89      45.374  -1.496   5.208  1.00 13.29           C  
ATOM    710  O   THR A  89      45.976  -0.877   6.116  1.00 14.75           O  
ATOM    711  CB  THR A  89      44.522   0.792   4.372  1.00 13.35           C  
ATOM    712  OG1 THR A  89      43.672   1.352   3.349  1.00 15.51           O  
ATOM    713  CG2 THR A  89      45.878   1.531   4.313  1.00 14.50           C  
ATOM    714  N   ASP A  90      45.287  -2.812   5.168  1.00 12.68           N  
ATOM    715  CA  ASP A  90      46.062  -3.683   6.078  1.00 13.36           C  
ATOM    716  C   ASP A  90      45.773  -3.459   7.571  1.00 15.11           C  
ATOM    717  O   ASP A  90      46.653  -3.719   8.440  1.00 15.71           O  
ATOM    718  CB  ASP A  90      47.538  -3.483   5.792  1.00 13.93           C  
ATOM    719  CG  ASP A  90      47.967  -4.154   4.482  1.00 13.24           C  
ATOM    720  OD1 ASP A  90      47.670  -5.353   4.352  1.00 17.90           O  
ATOM    721  OD2 ASP A  90      48.631  -3.524   3.643  1.00 16.06           O  
ATOM    722  N   SER A  91      44.568  -2.963   7.846  1.00 15.35           N  
ATOM    723  CA  SER A  91      44.087  -2.657   9.209  1.00 15.08           C  
ATOM    724  C   SER A  91      42.934  -3.544   9.589  1.00 14.64           C  
ATOM    725  O   SER A  91      42.239  -4.128   8.733  1.00 17.09           O  
ATOM    726  CB  SER A  91      43.624  -1.186   9.306  1.00 16.35           C  
ATOM    727  OG  SER A  91      44.782  -0.388   9.110  1.00 22.26           O  
ATOM    728  N   HIS A  92      42.735  -3.667  10.897  1.00 13.16           N  
ATOM    729  CA  HIS A  92      41.551  -4.306  11.433  1.00 13.06           C  
ATOM    730  C   HIS A  92      40.406  -3.312  11.318  1.00 13.53           C  
ATOM    731  O   HIS A  92      40.595  -2.137  11.539  1.00 13.56           O  
ATOM    732  CB  HIS A  92      41.707  -4.517  12.924  1.00 14.44           C  
ATOM    733  CG  HIS A  92      42.790  -5.467  13.281  1.00 16.17           C  
ATOM    734  ND1 HIS A  92      42.663  -6.820  13.085  1.00 17.01           N  
ATOM    735  CD2 HIS A  92      44.001  -5.264  13.850  1.00 20.33           C  
ATOM    736  CE1 HIS A  92      43.778  -7.414  13.501  1.00 22.67           C  
ATOM    737  NE2 HIS A  92      44.597  -6.492  13.987  1.00 21.96           N  
ATOM    738  N   CYS A  93      39.218  -3.792  11.006  1.00 12.24           N  
ATOM    739  CA  CYS A  93      38.057  -2.881  10.877  1.00 12.04           C  
ATOM    740  C   CYS A  93      36.846  -3.491  11.546  1.00 10.81           C  
ATOM    741  O   CYS A  93      36.398  -4.563  11.151  1.00 12.14           O  
ATOM    742  CB  CYS A  93      37.795  -2.650   9.386  1.00 12.44           C  
ATOM    743  SG  CYS A  93      36.422  -1.536   9.126  1.00 20.08           S  
ATOM    744  N   PHE A  94      36.317  -2.839  12.573  1.00 10.29           N  
ATOM    745  CA  PHE A  94      35.117  -3.293  13.283  1.00  8.67           C  
ATOM    746  C   PHE A  94      34.006  -2.313  12.975  1.00  8.82           C  
ATOM    747  O   PHE A  94      34.245  -1.116  12.882  1.00  9.01           O  
ATOM    748  CB  PHE A  94      35.364  -3.250  14.815  1.00  9.09           C  
ATOM    749  CG  PHE A  94      36.562  -4.104  15.257  1.00 10.87           C  
ATOM    750  CD1 PHE A  94      36.345  -5.399  15.781  1.00 10.17           C  
ATOM    751  CD2 PHE A  94      37.851  -3.607  15.151  1.00 11.87           C  
ATOM    752  CE1 PHE A  94      37.433  -6.206  16.205  1.00 10.62           C  
ATOM    753  CE2 PHE A  94      38.993  -4.395  15.574  1.00 12.25           C  
ATOM    754  CZ  PHE A  94      38.740  -5.729  16.107  1.00 12.42           C  
ATOM    755  N   LEU A  95      32.786  -2.810  12.784  1.00  9.55           N  
ATOM    756  CA  LEU A  95      31.684  -1.956  12.398  1.00 11.69           C  
ATOM    757  C   LEU A  95      30.519  -2.381  13.283  1.00 11.95           C  
ATOM    758  O   LEU A  95      30.031  -3.505  13.167  1.00 12.46           O  
ATOM    759  CB  LEU A  95      31.406  -2.209  10.868  1.00 13.56           C  
ATOM    760  CG  LEU A  95      30.386  -1.340  10.163  1.00 18.34           C  
ATOM    761  CD1 LEU A  95      30.377  -1.813   8.689  1.00 22.44           C  
ATOM    762  CD2 LEU A  95      28.972  -1.442  10.688  1.00 17.66           C  
ATOM    763  N   LYS A  96      30.047  -1.484  14.149  1.00 11.07           N  
ATOM    764  CA  LYS A  96      28.901  -1.809  15.017  1.00 11.29           C  
ATOM    765  C   LYS A  96      27.728  -0.932  14.675  1.00 11.93           C  
ATOM    766  O   LYS A  96      27.901   0.317  14.567  1.00 12.56           O  
ATOM    767  CB  LYS A  96      29.270  -1.570  16.511  1.00 12.01           C  
ATOM    768  CG  LYS A  96      28.087  -1.992  17.459  1.00 14.63           C  
ATOM    769  CD  LYS A  96      28.110  -1.162  18.663  1.00 17.25           C  
ATOM    770  CE  LYS A  96      26.823  -1.373  19.496  1.00 15.10           C  
ATOM    771  NZ  LYS A  96      26.594  -2.754  20.118  1.00 11.95           N  
ATOM    772  N   LEU A  97      26.543  -1.503  14.525  1.00 11.33           N  
ATOM    773  CA  LEU A  97      25.383  -0.665  14.244  1.00 11.83           C  
ATOM    774  C   LEU A  97      24.912   0.034  15.515  1.00 12.62           C  
ATOM    775  O   LEU A  97      24.665  -0.632  16.519  1.00 13.10           O  
ATOM    776  CB  LEU A  97      24.216  -1.449  13.589  1.00 13.50           C  
ATOM    777  CG  LEU A  97      24.124  -1.500  12.062  1.00 13.24           C  
ATOM    778  CD1 LEU A  97      23.852  -0.105  11.405  1.00 15.63           C  
ATOM    779  CD2 LEU A  97      25.499  -1.978  11.593  1.00 15.85           C  
ATOM    780  N   LEU A  98      24.720   1.365  15.433  1.00 11.47           N  
ATOM    781  CA  LEU A  98      24.165   2.169  16.535  1.00 11.89           C  
ATOM    782  C   LEU A  98      22.678   2.450  16.303  1.00 13.15           C  
ATOM    783  O   LEU A  98      21.909   2.683  17.265  1.00 14.09           O  
ATOM    784  CB  LEU A  98      24.942   3.508  16.698  1.00 10.88           C  
ATOM    785  CG  LEU A  98      26.410   3.352  17.178  1.00 10.45           C  
ATOM    786  CD1 LEU A  98      27.032   4.752  17.321  1.00  7.75           C  
ATOM    787  CD2 LEU A  98      26.523   2.565  18.520  1.00 12.39           C  
ATOM    788  N   GLN A  99      22.279   2.470  15.033  1.00 13.30           N  
ATOM    789  CA  GLN A  99      20.877   2.790  14.649  1.00 14.34           C  
ATOM    790  C   GLN A  99      20.612   2.298  13.239  1.00 14.29           C  
ATOM    791  O   GLN A  99      21.421   2.490  12.359  1.00 12.84           O  
ATOM    792  CB  GLN A  99      20.603   4.313  14.693  1.00 13.49           C  
ATOM    793  CG  GLN A  99      19.159   4.734  14.187  1.00 16.78           C  
ATOM    794  CD  GLN A  99      19.032   6.211  14.173  1.00 20.26           C  
ATOM    795  OE1 GLN A  99      19.083   6.837  15.239  1.00 23.39           O  
ATOM    796  NE2 GLN A  99      18.986   6.817  12.955  1.00 24.14           N  
ATOM    797  N   GLY A 100      19.454   1.665  13.017  1.00 14.02           N  
ATOM    798  CA  GLY A 100      19.107   1.239  11.672  1.00 14.21           C  
ATOM    799  C   GLY A 100      19.768  -0.062  11.277  1.00 12.90           C  
ATOM    800  O   GLY A 100      20.253  -0.796  12.103  1.00 14.96           O  
ATOM    801  N   ASN A 101      19.911  -0.255   9.974  1.00 13.75           N  
ATOM    802  CA  ASN A 101      20.473  -1.497   9.449  1.00 14.19           C  
ATOM    803  C   ASN A 101      21.331  -1.156   8.240  1.00 13.28           C  
ATOM    804  O   ASN A 101      21.080  -0.181   7.547  1.00 12.55           O  
ATOM    805  CB  ASN A 101      19.361  -2.398   8.908  1.00 15.27           C  
ATOM    806  CG  ASN A 101      18.414  -2.886   9.999  1.00 18.14           C  
ATOM    807  OD1 ASN A 101      18.737  -3.804  10.767  1.00 21.57           O  
ATOM    808  ND2 ASN A 101      17.241  -2.290  10.050  1.00 22.53           N  
ATOM    809  N   LEU A 102      22.356  -1.969   8.002  1.00 12.83           N  
ATOM    810  CA  LEU A 102      23.180  -1.761   6.791  1.00 11.56           C  
ATOM    811  C   LEU A 102      23.311  -3.115   6.099  1.00 10.91           C  
ATOM    812  O   LEU A 102      23.428  -4.136   6.771  1.00 14.22           O  
ATOM    813  CB  LEU A 102      24.581  -1.236   7.173  1.00 11.80           C  
ATOM    814  CG  LEU A 102      24.627   0.193   7.727  1.00 11.88           C  
ATOM    815  CD1 LEU A 102      26.049   0.509   8.348  1.00 13.33           C  
ATOM    816  CD2 LEU A 102      24.369   1.184   6.613  1.00 12.80           C  
ATOM    817  N   LYS A 103      23.364  -3.106   4.774  1.00 12.23           N  
ATOM    818  CA  LYS A 103      23.606  -4.320   4.011  1.00 13.65           C  
ATOM    819  C   LYS A 103      25.119  -4.377   3.716  1.00 13.01           C  
ATOM    820  O   LYS A 103      25.694  -3.418   3.201  1.00 12.70           O  
ATOM    821  CB  LYS A 103      22.792  -4.329   2.744  1.00 13.87           C  
ATOM    822  CG  LYS A 103      23.109  -5.603   1.885  1.00 14.76           C  
ATOM    823  CD  LYS A 103      22.227  -5.689   0.652  1.00 21.15           C  
ATOM    824  CE  LYS A 103      22.612  -4.773  -0.419  1.00 24.63           C  
ATOM    825  NZ  LYS A 103      22.036  -5.285  -1.754  1.00 27.39           N  
ATOM    826  N   GLU A 104      25.758  -5.501   4.022  1.00 13.69           N  
ATOM    827  CA  GLU A 104      27.211  -5.622   3.727  1.00 13.11           C  
ATOM    828  C   GLU A 104      27.333  -6.657   2.606  1.00 14.76           C  
ATOM    829  O   GLU A 104      26.819  -7.782   2.756  1.00 16.77           O  
ATOM    830  CB  GLU A 104      27.967  -6.120   4.980  1.00 14.63           C  
ATOM    831  CG  GLU A 104      29.545  -6.242   4.714  1.00 15.81           C  
ATOM    832  CD  GLU A 104      30.294  -6.942   5.840  1.00 16.33           C  
ATOM    833  OE1 GLU A 104      29.708  -7.828   6.518  1.00 19.19           O  
ATOM    834  OE2 GLU A 104      31.487  -6.615   6.055  1.00 16.54           O  
ATOM    835  N   THR A 105      28.002  -6.298   1.527  1.00 13.70           N  
ATOM    836  CA  THR A 105      28.192  -7.230   0.409  1.00 14.63           C  
ATOM    837  C   THR A 105      29.695  -7.549   0.361  1.00 15.99           C  
ATOM    838  O   THR A 105      30.528  -6.629   0.336  1.00 13.39           O  
ATOM    839  CB  THR A 105      27.707  -6.625  -0.904  1.00 16.59           C  
ATOM    840  OG1 THR A 105      26.308  -6.303  -0.784  1.00 15.71           O  
ATOM    841  CG2 THR A 105      27.827  -7.656  -1.991  1.00 17.54           C  
ATOM    842  N   LEU A 106      30.020  -8.842   0.386  1.00 15.27           N  
ATOM    843  CA  LEU A 106      31.415  -9.275   0.404  1.00 16.57           C  
ATOM    844  C   LEU A 106      31.885  -9.670  -1.008  1.00 16.50           C  
ATOM    845  O   LEU A 106      31.131 -10.288  -1.779  1.00 17.19           O  
ATOM    846  CB  LEU A 106      31.628 -10.464   1.335  1.00 18.10           C  
ATOM    847  CG  LEU A 106      31.350 -10.414   2.823  1.00 20.66           C  
ATOM    848  CD1 LEU A 106      32.152 -11.556   3.469  1.00 28.59           C  
ATOM    849  CD2 LEU A 106      31.715  -9.054   3.433  1.00 24.10           C  
ATOM    850  N   PHE A 107      33.118  -9.283  -1.318  1.00 15.76           N  
ATOM    851  CA  PHE A 107      33.733  -9.528  -2.618  1.00 15.84           C  
ATOM    852  C   PHE A 107      35.129 -10.137  -2.429  1.00 16.58           C  
ATOM    853  O   PHE A 107      35.869  -9.790  -1.499  1.00 15.98           O  
ATOM    854  CB  PHE A 107      33.874  -8.242  -3.415  1.00 16.15           C  
ATOM    855  CG  PHE A 107      32.551  -7.654  -3.903  1.00 17.07           C  
ATOM    856  CD1 PHE A 107      32.037  -7.985  -5.168  1.00 17.62           C  
ATOM    857  CD2 PHE A 107      31.840  -6.787  -3.103  1.00 19.22           C  
ATOM    858  CE1 PHE A 107      30.815  -7.430  -5.583  1.00 20.65           C  
ATOM    859  CE2 PHE A 107      30.624  -6.221  -3.539  1.00 19.00           C  
ATOM    860  CZ  PHE A 107      30.126  -6.553  -4.761  1.00 19.92           C  
ATOM    861  N   ASP A 108      35.523 -11.031  -3.339  1.00 17.76           N  
ATOM    862  CA  ASP A 108      36.923 -11.420  -3.278  1.00 17.79           C  
ATOM    863  C   ASP A 108      37.793 -10.383  -3.941  1.00 16.83           C  
ATOM    864  O   ASP A 108      37.346  -9.587  -4.817  1.00 15.68           O  
ATOM    865  CB  ASP A 108      37.138 -12.800  -3.965  1.00 21.00           C  
ATOM    866  CG  ASP A 108      36.607 -13.961  -3.144  1.00 25.77           C  
ATOM    867  OD1 ASP A 108      36.807 -14.032  -1.907  1.00 30.56           O  
ATOM    868  OD2 ASP A 108      36.003 -14.832  -3.776  1.00 33.29           O  
ATOM    869  N   TRP A 109      39.087 -10.397  -3.592  1.00 15.54           N  
ATOM    870  CA  TRP A 109      40.060  -9.563  -4.294  1.00 16.57           C  
ATOM    871  C   TRP A 109      40.045  -9.930  -5.799  1.00 18.97           C  
ATOM    872  O   TRP A 109      40.019 -11.116  -6.132  1.00 19.39           O  
ATOM    873  CB  TRP A 109      41.474  -9.783  -3.724  1.00 15.95           C  
ATOM    874  CG  TRP A 109      41.639  -9.056  -2.411  1.00 14.79           C  
ATOM    875  CD1 TRP A 109      41.359  -9.532  -1.154  1.00 16.98           C  
ATOM    876  CD2 TRP A 109      42.082  -7.713  -2.249  1.00 13.73           C  
ATOM    877  NE1 TRP A 109      41.629  -8.568  -0.222  1.00 13.75           N  
ATOM    878  CE2 TRP A 109      42.067  -7.432  -0.849  1.00 11.93           C  
ATOM    879  CE3 TRP A 109      42.521  -6.724  -3.124  1.00 12.01           C  
ATOM    880  CZ2 TRP A 109      42.498  -6.205  -0.330  1.00 13.19           C  
ATOM    881  CZ3 TRP A 109      42.934  -5.487  -2.601  1.00 14.60           C  
ATOM    882  CH2 TRP A 109      42.915  -5.236  -1.219  1.00 14.93           C  
ATOM    883  N   PRO A 110      40.017  -8.918  -6.676  1.00 21.42           N  
ATOM    884  CA  PRO A 110      40.000  -9.149  -8.132  1.00 24.51           C  
ATOM    885  C   PRO A 110      41.292  -9.782  -8.616  1.00 27.63           C  
ATOM    886  O   PRO A 110      42.365  -9.540  -8.048  1.00 26.50           O  
ATOM    887  CB  PRO A 110      39.874  -7.741  -8.725  1.00 24.64           C  
ATOM    888  CG  PRO A 110      39.453  -6.864  -7.643  1.00 23.93           C  
ATOM    889  CD  PRO A 110      39.963  -7.478  -6.352  1.00 21.44           C  
ATOM    890  N   ASP A 111      41.178 -10.632  -9.629  1.00 32.14           N  
ATOM    891  CA  ASP A 111      42.358 -11.039 -10.395  1.00 37.09           C  
ATOM    892  C   ASP A 111      42.786  -9.933 -11.372  1.00 39.18           C  
ATOM    893  O   ASP A 111      42.156  -8.859 -11.470  1.00 40.01           O  
ATOM    894  CB  ASP A 111      42.096 -12.336 -11.155  1.00 37.54           C  
ATOM    895  CG  ASP A 111      41.675 -13.466 -10.245  1.00 41.58           C  
ATOM    896  OD1 ASP A 111      42.325 -13.687  -9.191  1.00 44.70           O  
ATOM    897  OD2 ASP A 111      40.684 -14.147 -10.587  1.00 47.20           O  
ATOM    898  N   LYS A 112      43.839 -10.219 -12.122  1.00 42.26           N  
ATOM    899  CA  LYS A 112      44.470  -9.218 -12.984  1.00 44.72           C  
ATOM    900  C   LYS A 112      43.681  -8.922 -14.269  1.00 45.27           C  
ATOM    901  O   LYS A 112      43.766  -7.806 -14.817  1.00 46.28           O  
ATOM    902  CB  LYS A 112      45.921  -9.625 -13.311  1.00 45.17           C  
ATOM    903  CG  LYS A 112      46.843  -9.871 -12.079  1.00 47.88           C  
ATOM    904  CD  LYS A 112      47.276  -8.576 -11.372  1.00 49.60           C  
ATOM    905  CE  LYS A 112      46.338  -8.224 -10.218  1.00 49.57           C  
ATOM    906  NZ  LYS A 112      46.271  -6.743 -10.060  1.00 49.16           N  
ATOM    907  N   LYS A 113      42.930  -9.915 -14.744  1.00 45.72           N  
ATOM    908  CA  LYS A 113      42.065  -9.757 -15.905  1.00 45.55           C  
ATOM    909  C   LYS A 113      40.885  -8.898 -15.491  1.00 45.26           C  
ATOM    910  O   LYS A 113      40.239  -9.181 -14.472  1.00 45.37           O  
ATOM    911  CB  LYS A 113      41.510 -11.110 -16.394  1.00 45.72           C  
ATOM    912  CG  LYS A 113      42.474 -12.001 -17.143  1.00 47.90           C  
ATOM    913  CD  LYS A 113      42.353 -11.910 -18.678  1.00 49.54           C  
ATOM    914  CE  LYS A 113      43.663 -12.417 -19.347  1.00 48.75           C  
ATOM    915  NZ  LYS A 113      43.520 -12.786 -20.791  1.00 48.84           N  
ATOM    916  N   SER A 114      40.603  -7.860 -16.275  1.00 43.98           N  
ATOM    917  CA  SER A 114      39.394  -7.085 -16.080  1.00 42.84           C  
ATOM    918  C   SER A 114      38.200  -8.027 -16.204  1.00 41.67           C  
ATOM    919  O   SER A 114      38.005  -8.657 -17.236  1.00 42.86           O  
ATOM    920  CB  SER A 114      39.306  -5.967 -17.114  1.00 43.12           C  
ATOM    921  OG  SER A 114      37.948  -5.590 -17.294  1.00 44.31           O  
ATOM    922  N   ASN A 115      37.432  -8.157 -15.134  1.00 39.14           N  
ATOM    923  CA  ASN A 115      36.210  -8.934 -15.128  1.00 37.24           C  
ATOM    924  C   ASN A 115      35.272  -8.311 -14.141  1.00 34.96           C  
ATOM    925  O   ASN A 115      35.692  -7.608 -13.220  1.00 33.99           O  
ATOM    926  CB  ASN A 115      36.464 -10.385 -14.683  1.00 38.07           C  
ATOM    927  CG  ASN A 115      37.068 -11.246 -15.774  1.00 41.45           C  
ATOM    928  OD1 ASN A 115      36.976 -10.940 -16.979  1.00 45.89           O  
ATOM    929  ND2 ASN A 115      37.698 -12.340 -15.361  1.00 43.30           N  
ATOM    930  N   GLU A 116      33.996  -8.584 -14.330  1.00 32.80           N  
ATOM    931  CA  GLU A 116      32.982  -8.196 -13.391  1.00 31.52           C  
ATOM    932  C   GLU A 116      33.312  -8.823 -12.019  1.00 29.79           C  
ATOM    933  O   GLU A 116      33.621 -10.020 -11.923  1.00 26.74           O  
ATOM    934  CB  GLU A 116      31.627  -8.666 -13.912  1.00 33.18           C  
ATOM    935  CG  GLU A 116      30.518  -8.732 -12.903  1.00 35.42           C  
ATOM    936  CD  GLU A 116      29.819  -7.404 -12.667  1.00 44.09           C  
ATOM    937  OE1 GLU A 116      29.939  -6.482 -13.516  1.00 44.76           O  
ATOM    938  OE2 GLU A 116      29.133  -7.286 -11.617  1.00 47.52           O  
HETATM  939  N   MSE A 117      33.280  -8.004 -10.973  1.00 26.72           N  
HETATM  940  CA  MSE A 117      33.390  -8.536  -9.620  1.00 24.64           C  
HETATM  941  C   MSE A 117      32.035  -9.087  -9.159  1.00 26.90           C  
HETATM  942  O   MSE A 117      31.057  -8.343  -8.970  1.00 28.53           O  
HETATM  943  CB  MSE A 117      33.844  -7.412  -8.663  1.00 23.21           C  
HETATM  944  CG  MSE A 117      35.083  -6.681  -9.124  1.00 20.71           C  
HETATM  945 SE   MSE A 117      35.479  -5.215  -7.845  1.00 16.93          SE  
HETATM  946  CE  MSE A 117      35.926  -6.305  -6.282  1.00 16.78           C  
ATOM    947  N   ILE A 118      31.973 -10.381  -8.926  1.00 28.49           N  
ATOM    948  CA  ILE A 118      30.733 -11.009  -8.450  1.00 29.61           C  
ATOM    949  C   ILE A 118      30.700 -11.091  -6.921  1.00 29.37           C  
ATOM    950  O   ILE A 118      31.664 -11.527  -6.317  1.00 30.13           O  
ATOM    951  CB  ILE A 118      30.586 -12.429  -9.066  1.00 30.60           C  
ATOM    952  CG1 ILE A 118      30.674 -12.326 -10.599  1.00 31.46           C  
ATOM    953  CG2 ILE A 118      29.290 -13.138  -8.574  1.00 31.19           C  
ATOM    954  CD1 ILE A 118      29.534 -11.527 -11.237  1.00 35.53           C  
ATOM    955  N   LYS A 119      29.576 -10.723  -6.299  1.00 29.36           N  
ATOM    956  CA  LYS A 119      29.511 -10.831  -4.846  1.00 29.08           C  
ATOM    957  C   LYS A 119      29.732 -12.273  -4.366  1.00 29.00           C  
ATOM    958  O   LYS A 119      29.274 -13.256  -5.017  1.00 28.65           O  
ATOM    959  CB  LYS A 119      28.217 -10.246  -4.298  1.00 30.02           C  
ATOM    960  CG  LYS A 119      26.975 -10.983  -4.696  1.00 31.20           C  
ATOM    961  CD  LYS A 119      25.741 -10.337  -4.174  1.00 35.41           C  
ATOM    962  CE  LYS A 119      24.541 -10.821  -4.984  1.00 37.24           C  
ATOM    963  NZ  LYS A 119      23.214 -10.433  -4.427  1.00 37.94           N  
ATOM    964  N   LYS A 120      30.465 -12.424  -3.268  1.00 27.99           N  
ATOM    965  CA  LYS A 120      30.616 -13.733  -2.682  1.00 27.27           C  
ATOM    966  C   LYS A 120      29.496 -14.043  -1.687  1.00 26.96           C  
ATOM    967  O   LYS A 120      28.997 -15.173  -1.622  1.00 27.19           O  
ATOM    968  CB  LYS A 120      32.040 -14.011  -2.198  1.00 27.26           C  
ATOM    969  CG  LYS A 120      32.519 -13.389  -0.957  1.00 32.55           C  
ATOM    970  CD  LYS A 120      33.682 -14.283  -0.394  1.00 34.57           C  
ATOM    971  CE  LYS A 120      34.474 -13.616   0.731  1.00 38.73           C  
ATOM    972  NZ  LYS A 120      35.630 -12.805   0.254  1.00 37.61           N  
ATOM    973  N   SER A 121      29.006 -13.018  -0.994  1.00 24.80           N  
ATOM    974  CA  SER A 121      27.862 -13.205  -0.091  1.00 22.86           C  
ATOM    975  C   SER A 121      27.383 -11.846   0.397  1.00 22.18           C  
ATOM    976  O   SER A 121      28.048 -10.833   0.176  1.00 19.91           O  
ATOM    977  CB  SER A 121      28.261 -14.034   1.113  1.00 22.74           C  
ATOM    978  OG  SER A 121      29.213 -13.341   1.889  1.00 24.94           O  
ATOM    979  N   GLU A 122      26.230 -11.835   1.041  1.00 21.75           N  
ATOM    980  CA  GLU A 122      25.729 -10.589   1.612  1.00 22.37           C  
ATOM    981  C   GLU A 122      25.019 -10.871   2.895  1.00 22.50           C  
ATOM    982  O   GLU A 122      24.506 -11.979   3.112  1.00 20.63           O  
ATOM    983  CB  GLU A 122      24.812  -9.848   0.638  1.00 23.21           C  
ATOM    984  CG  GLU A 122      23.616 -10.628   0.120  1.00 25.95           C  
ATOM    985  CD  GLU A 122      22.710  -9.788  -0.760  1.00 27.62           C  
ATOM    986  OE1 GLU A 122      23.131  -9.367  -1.854  1.00 32.00           O  
ATOM    987  OE2 GLU A 122      21.567  -9.533  -0.330  1.00 36.56           O  
ATOM    988  N   ARG A 123      24.949  -9.864   3.751  1.00 20.95           N  
ATOM    989  CA  ARG A 123      24.163  -9.996   4.957  1.00 20.66           C  
ATOM    990  C   ARG A 123      23.674  -8.652   5.415  1.00 20.31           C  
ATOM    991  O   ARG A 123      24.185  -7.607   4.972  1.00 18.88           O  
ATOM    992  CB  ARG A 123      24.948 -10.672   6.061  1.00 21.94           C  
ATOM    993  CG  ARG A 123      26.125  -9.892   6.500  1.00 21.56           C  
ATOM    994  CD  ARG A 123      26.904 -10.614   7.575  1.00 25.75           C  
ATOM    995  NE  ARG A 123      28.219 -10.006   7.691  1.00 25.35           N  
ATOM    996  CZ  ARG A 123      29.029 -10.143   8.732  1.00 27.97           C  
ATOM    997  NH1 ARG A 123      28.672 -10.877   9.782  1.00 27.98           N  
ATOM    998  NH2 ARG A 123      30.205  -9.543   8.713  1.00 25.97           N  
ATOM    999  N   THR A 124      22.692  -8.697   6.308  1.00 20.07           N  
ATOM   1000  CA  THR A 124      22.074  -7.504   6.860  1.00 19.88           C  
ATOM   1001  C   THR A 124      22.587  -7.406   8.288  1.00 21.50           C  
ATOM   1002  O   THR A 124      22.399  -8.332   9.120  1.00 21.58           O  
ATOM   1003  CB  THR A 124      20.530  -7.570   6.837  1.00 22.38           C  
ATOM   1004  OG1 THR A 124      20.078  -7.542   5.482  1.00 22.52           O  
ATOM   1005  CG2 THR A 124      19.968  -6.333   7.500  1.00 22.16           C  
ATOM   1006  N   LEU A 125      23.290  -6.299   8.563  1.00 18.74           N  
ATOM   1007  CA  LEU A 125      23.841  -6.028   9.907  1.00 17.59           C  
ATOM   1008  C   LEU A 125      22.790  -5.218  10.668  1.00 17.94           C  
ATOM   1009  O   LEU A 125      22.306  -4.183  10.167  1.00 16.72           O  
ATOM   1010  CB  LEU A 125      25.173  -5.256   9.757  1.00 17.29           C  
ATOM   1011  CG  LEU A 125      26.307  -5.804   8.889  1.00 20.80           C  
ATOM   1012  CD1 LEU A 125      27.438  -4.794   8.703  1.00 21.95           C  
ATOM   1013  CD2 LEU A 125      26.845  -7.140   9.537  1.00 19.57           C  
ATOM   1014  N   ARG A 126      22.383  -5.671  11.850  1.00 16.91           N  
ATOM   1015  CA  ARG A 126      21.283  -5.015  12.546  1.00 18.09           C  
ATOM   1016  C   ARG A 126      21.748  -4.227  13.751  1.00 16.08           C  
ATOM   1017  O   ARG A 126      22.894  -4.418  14.224  1.00 16.58           O  
ATOM   1018  CB  ARG A 126      20.242  -6.066  12.953  1.00 19.65           C  
ATOM   1019  CG  ARG A 126      19.941  -6.994  11.764  1.00 22.70           C  
ATOM   1020  CD  ARG A 126      18.557  -7.568  11.876  1.00 24.24           C  
ATOM   1021  NE  ARG A 126      18.145  -8.284  10.655  1.00 26.81           N  
ATOM   1022  CZ  ARG A 126      17.514  -7.688   9.643  1.00 26.15           C  
ATOM   1023  NH1 ARG A 126      17.279  -6.375   9.698  1.00 23.14           N  
ATOM   1024  NH2 ARG A 126      17.133  -8.387   8.567  1.00 28.73           N  
ATOM   1025  N   GLU A 127      20.853  -3.412  14.282  1.00 17.63           N  
ATOM   1026  CA  GLU A 127      21.197  -2.645  15.478  1.00 18.55           C  
ATOM   1027  C   GLU A 127      21.920  -3.463  16.537  1.00 17.29           C  
ATOM   1028  O   GLU A 127      21.481  -4.587  16.936  1.00 15.49           O  
ATOM   1029  CB  GLU A 127      19.955  -1.965  16.099  1.00 19.64           C  
ATOM   1030  CG  GLU A 127      19.633  -0.648  15.448  1.00 22.32           C  
ATOM   1031  CD  GLU A 127      18.424   0.099  16.080  1.00 23.96           C  
ATOM   1032  OE1 GLU A 127      17.975  -0.254  17.238  1.00 25.50           O  
ATOM   1033  OE2 GLU A 127      17.930   1.007  15.364  1.00 23.87           O  
ATOM   1034  N   ASN A 128      23.013  -2.862  17.007  1.00 15.66           N  
ATOM   1035  CA  ASN A 128      23.900  -3.341  18.047  1.00 15.28           C  
ATOM   1036  C   ASN A 128      24.867  -4.458  17.665  1.00 14.28           C  
ATOM   1037  O   ASN A 128      25.824  -4.737  18.394  1.00 15.40           O  
ATOM   1038  CB  ASN A 128      23.152  -3.671  19.336  1.00 16.13           C  
ATOM   1039  CG  ASN A 128      22.802  -2.430  20.123  1.00 14.32           C  
ATOM   1040  OD1 ASN A 128      23.660  -1.613  20.420  1.00 11.91           O  
ATOM   1041  ND2 ASN A 128      21.550  -2.348  20.544  1.00 16.90           N  
ATOM   1042  N   GLN A 129      24.680  -5.016  16.493  1.00 14.55           N  
ATOM   1043  CA  GLN A 129      25.578  -6.088  16.028  0.50 15.70           C  
ATOM   1045  C   GLN A 129      26.938  -5.478  15.664  1.00 15.54           C  
ATOM   1046  O   GLN A 129      26.984  -4.342  15.240  1.00 15.67           O  
ATOM   1047  CB  GLN A 129      24.949  -6.836  14.842  0.50 15.45           C  
ATOM   1049  CG  GLN A 129      23.617  -7.555  15.185  0.50 15.05           C  
ATOM   1051  CD  GLN A 129      23.037  -8.386  14.035  0.50 17.36           C  
ATOM   1053  OE1 GLN A 129      23.350  -8.167  12.863  0.50 20.49           O  
ATOM   1055  NE2 GLN A 129      22.153  -9.341  14.371  0.50 22.06           N  
ATOM   1057  N   CYS A 130      28.035  -6.237  15.867  1.00 15.77           N  
ATOM   1058  CA  CYS A 130      29.353  -5.770  15.437  1.00 15.58           C  
ATOM   1059  C   CYS A 130      29.975  -6.731  14.476  1.00 17.19           C  
ATOM   1060  O   CYS A 130      30.187  -7.916  14.833  1.00 17.43           O  
ATOM   1061  CB  CYS A 130      30.279  -5.531  16.632  1.00 17.51           C  
ATOM   1062  SG  CYS A 130      31.937  -4.856  16.214  1.00 16.74           S  
ATOM   1063  N   ALA A 131      30.269  -6.250  13.263  1.00 15.17           N  
ATOM   1064  CA  ALA A 131      30.924  -7.064  12.237  1.00 14.14           C  
ATOM   1065  C   ALA A 131      32.418  -6.708  12.230  1.00 13.97           C  
ATOM   1066  O   ALA A 131      32.850  -5.706  12.825  1.00 13.10           O  
ATOM   1067  CB  ALA A 131      30.290  -6.790  10.858  1.00 15.05           C  
ATOM   1068  N   TYR A 132      33.188  -7.564  11.562  1.00 13.49           N  
ATOM   1069  CA  TYR A 132      34.641  -7.402  11.485  1.00 12.59           C  
ATOM   1070  C   TYR A 132      35.055  -7.753  10.087  1.00 11.36           C  
ATOM   1071  O   TYR A 132      34.514  -8.716   9.470  1.00 11.47           O  
ATOM   1072  CB  TYR A 132      35.310  -8.358  12.469  1.00 13.52           C  
ATOM   1073  CG  TYR A 132      36.789  -8.414  12.298  1.00 12.34           C  
ATOM   1074  CD1 TYR A 132      37.391  -9.497  11.654  1.00 14.76           C  
ATOM   1075  CD2 TYR A 132      37.591  -7.386  12.755  1.00 12.27           C  
ATOM   1076  CE1 TYR A 132      38.765  -9.519  11.447  1.00 14.20           C  
ATOM   1077  CE2 TYR A 132      38.955  -7.391  12.566  1.00 12.93           C  
ATOM   1078  CZ  TYR A 132      39.549  -8.467  11.942  1.00 13.26           C  
ATOM   1079  OH  TYR A 132      40.906  -8.468  11.805  1.00 14.21           O  
ATOM   1080  N   ILE A 133      36.015  -6.986   9.570  1.00 11.23           N  
ATOM   1081  CA  ILE A 133      36.655  -7.330   8.284  1.00 12.78           C  
ATOM   1082  C   ILE A 133      38.121  -6.938   8.283  1.00 11.98           C  
ATOM   1083  O   ILE A 133      38.516  -6.032   8.994  1.00 11.45           O  
ATOM   1084  CB  ILE A 133      35.922  -6.681   7.072  1.00 11.86           C  
ATOM   1085  CG1 ILE A 133      36.328  -7.399   5.752  1.00 15.74           C  
ATOM   1086  CG2 ILE A 133      36.114  -5.178   7.058  1.00 11.01           C  
ATOM   1087  CD1 ILE A 133      35.411  -7.085   4.537  1.00 15.59           C  
ATOM   1088  N   ASN A 134      38.917  -7.640   7.475  1.00 11.19           N  
ATOM   1089  CA  ASN A 134      40.260  -7.193   7.196  1.00 11.92           C  
ATOM   1090  C   ASN A 134      40.577  -7.672   5.769  1.00 11.19           C  
ATOM   1091  O   ASN A 134      39.759  -8.364   5.167  1.00 12.07           O  
ATOM   1092  CB  ASN A 134      41.287  -7.737   8.224  1.00 13.15           C  
ATOM   1093  CG  ASN A 134      41.377  -9.281   8.186  1.00 17.79           C  
ATOM   1094  OD1 ASN A 134      41.368  -9.888   7.094  1.00 20.48           O  
ATOM   1095  ND2 ASN A 134      41.421  -9.930   9.380  1.00 19.90           N  
ATOM   1096  N   ASP A 135      41.704  -7.219   5.227  1.00 12.17           N  
ATOM   1097  CA  ASP A 135      42.052  -7.492   3.814  1.00 14.01           C  
ATOM   1098  C   ASP A 135      42.216  -8.980   3.514  1.00 16.55           C  
ATOM   1099  O   ASP A 135      41.989  -9.421   2.395  1.00 16.58           O  
ATOM   1100  CB  ASP A 135      43.304  -6.717   3.430  1.00 13.00           C  
ATOM   1101  CG  ASP A 135      43.055  -5.246   3.278  1.00 14.45           C  
ATOM   1102  OD1 ASP A 135      41.856  -4.794   3.259  1.00 12.35           O  
ATOM   1103  OD2 ASP A 135      44.034  -4.525   3.077  1.00 16.36           O  
ATOM   1104  N   SER A 136      42.599  -9.771   4.521  1.00 18.77           N  
ATOM   1105  CA  SER A 136      42.707 -11.223   4.328  0.50 19.99           C  
ATOM   1107  C   SER A 136      41.343 -11.869   4.096  1.00 20.07           C  
ATOM   1108  O   SER A 136      41.243 -12.882   3.391  1.00 21.66           O  
ATOM   1109  CB  SER A 136      43.407 -11.895   5.517  0.50 20.15           C  
ATOM   1111  OG  SER A 136      42.488 -12.120   6.564  0.50 23.16           O  
ATOM   1113  N   ILE A 137      40.278 -11.291   4.668  1.00 19.35           N  
ATOM   1114  CA  ILE A 137      38.909 -11.799   4.545  1.00 17.90           C  
ATOM   1115  C   ILE A 137      38.313 -11.430   3.160  1.00 18.54           C  
ATOM   1116  O   ILE A 137      37.659 -12.255   2.494  1.00 20.10           O  
ATOM   1117  CB  ILE A 137      38.005 -11.272   5.704  1.00 19.61           C  
ATOM   1118  CG1 ILE A 137      38.447 -11.902   7.042  1.00 16.39           C  
ATOM   1119  CG2 ILE A 137      36.519 -11.524   5.416  1.00 18.77           C  
ATOM   1120  CD1 ILE A 137      37.740 -11.279   8.338  1.00 17.75           C  
ATOM   1121  N   GLY A 138      38.542 -10.206   2.718  1.00 15.53           N  
ATOM   1122  CA  GLY A 138      38.160  -9.810   1.365  1.00 14.57           C  
ATOM   1123  C   GLY A 138      37.824  -8.340   1.387  1.00 14.85           C  
ATOM   1124  O   GLY A 138      38.319  -7.608   2.257  1.00 14.30           O  
ATOM   1125  N   LEU A 139      37.004  -7.936   0.412  1.00 13.93           N  
ATOM   1126  CA  LEU A 139      36.582  -6.512   0.195  1.00 12.71           C  
ATOM   1127  C   LEU A 139      35.122  -6.422   0.497  1.00 13.25           C  
ATOM   1128  O   LEU A 139      34.444  -7.439   0.497  1.00 14.00           O  
ATOM   1129  CB  LEU A 139      36.797  -6.098  -1.256  1.00 12.40           C  
ATOM   1130  CG  LEU A 139      38.225  -6.302  -1.813  1.00 12.04           C  
ATOM   1131  CD1 LEU A 139      38.254  -6.007  -3.279  1.00 11.94           C  
ATOM   1132  CD2 LEU A 139      39.090  -5.322  -1.109  1.00 12.11           C  
ATOM   1133  N   HIS A 140      34.615  -5.220   0.825  1.00 11.81           N  
ATOM   1134  CA  HIS A 140      33.145  -5.140   0.997  1.00 10.81           C  
ATOM   1135  C   HIS A 140      32.601  -3.802   0.501  1.00 10.59           C  
ATOM   1136  O   HIS A 140      33.352  -2.864   0.258  1.00 12.25           O  
ATOM   1137  CB  HIS A 140      32.695  -5.442   2.423  1.00 12.02           C  
ATOM   1138  CG  HIS A 140      33.034  -4.396   3.451  1.00 11.96           C  
ATOM   1139  ND1 HIS A 140      32.653  -4.548   4.763  1.00 11.41           N  
ATOM   1140  CD2 HIS A 140      33.629  -3.176   3.361  1.00 12.44           C  
ATOM   1141  CE1 HIS A 140      33.030  -3.484   5.448  1.00 12.35           C  
ATOM   1142  NE2 HIS A 140      33.646  -2.648   4.632  1.00 11.83           N  
ATOM   1143  N   ARG A 141      31.295  -3.806   0.277  1.00 10.45           N  
ATOM   1144  CA  ARG A 141      30.478  -2.605   0.079  0.25 11.16           C  
ATOM   1147  C   ARG A 141      29.542  -2.592   1.303  1.00 10.58           C  
ATOM   1148  O   ARG A 141      29.082  -3.670   1.756  1.00 11.73           O  
ATOM   1149  CB  ARG A 141      29.690  -2.753  -1.247  0.25 10.93           C  
ATOM   1152  CG  ARG A 141      28.923  -1.508  -1.781  0.25 11.97           C  
ATOM   1155  CD  ARG A 141      28.485  -1.673  -3.287  0.25 11.86           C  
ATOM   1158  NE  ARG A 141      29.086  -0.671  -4.170  0.25 13.03           N  
ATOM   1161  CZ  ARG A 141      29.424  -0.872  -5.445  0.25 12.45           C  
ATOM   1164  NH1 ARG A 141      29.228  -2.045  -6.030  0.25 12.37           N  
ATOM   1167  NH2 ARG A 141      29.984   0.106  -6.140  0.25 12.31           N  
ATOM   1170  N   VAL A 142      29.247  -1.408   1.860  1.00 11.25           N  
ATOM   1171  CA  VAL A 142      28.263  -1.282   2.969  1.00 10.29           C  
ATOM   1172  C   VAL A 142      27.209  -0.266   2.472  1.00 10.37           C  
ATOM   1173  O   VAL A 142      27.584   0.758   1.940  1.00  9.99           O  
ATOM   1174  CB  VAL A 142      28.946  -0.785   4.260  1.00 12.02           C  
ATOM   1175  CG1 VAL A 142      27.962  -0.487   5.320  1.00 13.71           C  
ATOM   1176  CG2 VAL A 142      29.920  -1.901   4.789  1.00 13.10           C  
ATOM   1177  N   GLU A 143      25.917  -0.545   2.648  1.00 10.40           N  
ATOM   1178  CA  GLU A 143      24.909   0.351   2.038  1.00 12.54           C  
ATOM   1179  C   GLU A 143      23.719   0.448   2.987  1.00 11.66           C  
ATOM   1180  O   GLU A 143      23.304  -0.518   3.609  1.00 12.05           O  
ATOM   1181  CB  GLU A 143      24.368  -0.194   0.705  1.00 14.59           C  
ATOM   1182  CG  GLU A 143      25.325  -0.445  -0.397  1.00 19.47           C  
ATOM   1183  CD  GLU A 143      24.653  -1.239  -1.498  1.00 24.89           C  
ATOM   1184  OE1 GLU A 143      24.749  -2.475  -1.475  1.00 20.45           O  
ATOM   1185  OE2 GLU A 143      23.977  -0.616  -2.340  1.00 29.81           O  
ATOM   1186  N   ASN A 144      23.183   1.656   3.127  1.00 10.75           N  
ATOM   1187  CA  ASN A 144      21.910   1.799   3.801  1.00 10.23           C  
ATOM   1188  C   ASN A 144      20.832   1.692   2.706  1.00 11.10           C  
ATOM   1189  O   ASN A 144      20.624   2.614   1.966  1.00 10.78           O  
ATOM   1190  CB  ASN A 144      21.792   3.175   4.518  1.00 10.60           C  
ATOM   1191  CG  ASN A 144      20.468   3.274   5.271  1.00 10.38           C  
ATOM   1192  OD1 ASN A 144      19.814   2.245   5.456  1.00 10.74           O  
ATOM   1193  ND2 ASN A 144      20.090   4.481   5.737  1.00 11.44           N  
ATOM   1194  N   VAL A 145      20.232   0.520   2.582  1.00 12.20           N  
ATOM   1195  CA  VAL A 145      19.281   0.342   1.473  1.00 14.33           C  
ATOM   1196  C   VAL A 145      17.896   0.847   1.857  1.00 14.38           C  
ATOM   1197  O   VAL A 145      16.971   0.863   1.021  1.00 13.86           O  
ATOM   1198  CB  VAL A 145      19.230  -1.123   0.967  1.00 15.02           C  
ATOM   1199  CG1 VAL A 145      20.615  -1.498   0.330  1.00 16.95           C  
ATOM   1200  CG2 VAL A 145      18.707  -2.084   2.095  1.00 17.56           C  
ATOM   1201  N   SER A 146      17.751   1.249   3.099  1.00 13.41           N  
ATOM   1202  CA  SER A 146      16.441   1.754   3.580  1.00 13.25           C  
ATOM   1203  C   SER A 146      15.988   3.008   2.829  1.00 14.70           C  
ATOM   1204  O   SER A 146      16.771   3.923   2.562  1.00 14.72           O  
ATOM   1205  CB  SER A 146      16.514   2.081   5.083  1.00 13.45           C  
ATOM   1206  OG  SER A 146      15.212   2.408   5.584  1.00 12.62           O  
ATOM   1207  N   HIS A 147      14.675   3.083   2.537  1.00 13.79           N  
ATOM   1208  CA  HIS A 147      14.089   4.300   1.996  1.00 14.30           C  
ATOM   1209  C   HIS A 147      13.578   5.244   3.088  1.00 13.86           C  
ATOM   1210  O   HIS A 147      13.233   6.416   2.769  1.00 15.98           O  
ATOM   1211  CB  HIS A 147      12.898   3.920   1.102  1.00 14.06           C  
ATOM   1212  CG  HIS A 147      13.300   3.305  -0.215  1.00 14.12           C  
ATOM   1213  ND1 HIS A 147      13.293   4.009  -1.396  1.00 18.12           N  
ATOM   1214  CD2 HIS A 147      13.716   2.052  -0.526  1.00 14.40           C  
ATOM   1215  CE1 HIS A 147      13.715   3.229  -2.380  1.00 15.23           C  
ATOM   1216  NE2 HIS A 147      13.997   2.046  -1.874  1.00 15.79           N  
ATOM   1217  N   THR A 148      13.491   4.761   4.330  1.00 14.65           N  
ATOM   1218  CA  THR A 148      12.872   5.552   5.409  1.00 15.61           C  
ATOM   1219  C   THR A 148      13.651   5.710   6.723  1.00 16.48           C  
ATOM   1220  O   THR A 148      13.253   6.505   7.566  1.00 16.55           O  
ATOM   1221  CB  THR A 148      11.500   4.919   5.799  1.00 14.80           C  
ATOM   1222  OG1 THR A 148      11.719   3.543   6.154  1.00 16.90           O  
ATOM   1223  CG2 THR A 148      10.555   4.976   4.633  1.00 14.77           C  
ATOM   1224  N   GLU A 149      14.737   4.983   6.921  1.00 15.66           N  
ATOM   1225  CA  GLU A 149      15.451   5.060   8.206  1.00 15.79           C  
ATOM   1226  C   GLU A 149      16.937   5.364   7.933  1.00 14.86           C  
ATOM   1227  O   GLU A 149      17.574   4.573   7.270  1.00 15.75           O  
ATOM   1228  CB  GLU A 149      15.365   3.725   8.946  1.00 16.80           C  
ATOM   1229  CG  GLU A 149      13.934   3.380   9.470  1.00 21.44           C  
ATOM   1230  CD  GLU A 149      13.364   4.450  10.422  1.00 29.72           C  
ATOM   1231  OE1 GLU A 149      14.138   5.203  11.089  1.00 29.69           O  
ATOM   1232  OE2 GLU A 149      12.110   4.533  10.522  1.00 32.61           O  
ATOM   1233  N   PRO A 150      17.456   6.484   8.418  1.00 12.76           N  
ATOM   1234  CA  PRO A 150      18.914   6.673   8.478  0.50 12.67           C  
ATOM   1236  C   PRO A 150      19.573   5.598   9.312  1.00 13.37           C  
ATOM   1237  O   PRO A 150      18.932   5.076  10.241  1.00 15.61           O  
ATOM   1238  CB  PRO A 150      19.039   8.023   9.179  0.50 13.27           C  
ATOM   1240  CG  PRO A 150      17.842   8.756   8.655  0.50 11.13           C  
ATOM   1242  CD  PRO A 150      16.734   7.735   8.679  0.50 13.47           C  
ATOM   1244  N   ALA A 151      20.846   5.282   9.023  1.00 11.39           N  
ATOM   1245  CA  ALA A 151      21.574   4.304   9.823  1.00 10.60           C  
ATOM   1246  C   ALA A 151      22.767   5.101  10.409  1.00 10.07           C  
ATOM   1247  O   ALA A 151      23.261   6.067   9.801  1.00  9.58           O  
ATOM   1248  CB  ALA A 151      22.147   3.178   8.955  1.00 11.31           C  
ATOM   1249  N   VAL A 152      23.214   4.633  11.545  1.00 10.11           N  
ATOM   1250  CA  VAL A 152      24.397   5.212  12.214  1.00  9.46           C  
ATOM   1251  C   VAL A 152      25.234   4.023  12.657  1.00 10.39           C  
ATOM   1252  O   VAL A 152      24.721   3.086  13.271  1.00 10.20           O  
ATOM   1253  CB  VAL A 152      24.008   6.073  13.428  1.00 10.42           C  
ATOM   1254  CG1 VAL A 152      25.269   6.612  14.071  1.00  9.20           C  
ATOM   1255  CG2 VAL A 152      23.038   7.195  12.984  1.00  9.42           C  
ATOM   1256  N   SER A 153      26.520   4.064  12.331  1.00  8.42           N  
ATOM   1257  CA  SER A 153      27.414   2.966  12.692  1.00  8.63           C  
ATOM   1258  C   SER A 153      28.658   3.493  13.365  1.00  9.82           C  
ATOM   1259  O   SER A 153      29.077   4.635  13.116  1.00  9.65           O  
ATOM   1260  CB  SER A 153      27.760   2.127  11.468  1.00 10.82           C  
ATOM   1261  OG  SER A 153      28.280   2.908  10.379  1.00 10.15           O  
ATOM   1262  N   LEU A 154      29.262   2.664  14.221  1.00  8.30           N  
ATOM   1263  CA  LEU A 154      30.453   3.003  15.003  1.00  9.59           C  
ATOM   1264  C   LEU A 154      31.542   2.102  14.416  1.00 10.63           C  
ATOM   1265  O   LEU A 154      31.388   0.850  14.413  1.00 10.86           O  
ATOM   1266  CB  LEU A 154      30.197   2.582  16.490  1.00  9.90           C  
ATOM   1267  CG  LEU A 154      31.370   2.822  17.463  1.00 11.20           C  
ATOM   1268  CD1 LEU A 154      31.684   4.374  17.576  1.00 10.28           C  
ATOM   1269  CD2 LEU A 154      31.055   2.301  18.886  1.00 11.76           C  
ATOM   1270  N   HIS A 155      32.608   2.698  13.927  1.00  9.35           N  
ATOM   1271  CA  HIS A 155      33.702   1.986  13.275  1.00  8.85           C  
ATOM   1272  C   HIS A 155      35.005   2.199  14.077  1.00 10.58           C  
ATOM   1273  O   HIS A 155      35.327   3.328  14.497  1.00 10.44           O  
ATOM   1274  CB  HIS A 155      33.947   2.523  11.832  1.00 10.23           C  
ATOM   1275  CG  HIS A 155      32.776   2.323  10.908  1.00 12.20           C  
ATOM   1276  ND1 HIS A 155      32.915   1.759   9.657  1.00 15.06           N  
ATOM   1277  CD2 HIS A 155      31.451   2.614  11.049  1.00 13.15           C  
ATOM   1278  CE1 HIS A 155      31.722   1.697   9.072  1.00 14.10           C  
ATOM   1279  NE2 HIS A 155      30.825   2.209   9.887  1.00 12.48           N  
ATOM   1280  N   LEU A 156      35.784   1.120  14.211  1.00  9.83           N  
ATOM   1281  CA  LEU A 156      37.102   1.185  14.866  1.00 10.01           C  
ATOM   1282  C   LEU A 156      38.085   0.582  13.871  1.00 10.57           C  
ATOM   1283  O   LEU A 156      37.838  -0.523  13.362  1.00 10.00           O  
ATOM   1284  CB  LEU A 156      37.102   0.281  16.104  1.00 11.80           C  
ATOM   1285  CG  LEU A 156      38.380   0.404  16.981  1.00 13.59           C  
ATOM   1286  CD1 LEU A 156      38.076   0.106  18.447  1.00 16.20           C  
ATOM   1287  CD2 LEU A 156      39.482  -0.509  16.437  1.00 13.35           C  
ATOM   1288  N   TYR A 157      39.142   1.328  13.551  1.00 10.77           N  
ATOM   1289  CA  TYR A 157      40.170   0.826  12.620  1.00 12.26           C  
ATOM   1290  C   TYR A 157      41.485   0.879  13.297  1.00 12.14           C  
ATOM   1291  O   TYR A 157      41.778   1.878  13.944  1.00 12.50           O  
ATOM   1292  CB  TYR A 157      40.266   1.762  11.422  1.00 12.78           C  
ATOM   1293  CG  TYR A 157      38.981   1.716  10.638  1.00 17.48           C  
ATOM   1294  CD1 TYR A 157      38.541   0.506  10.130  1.00 15.04           C  
ATOM   1295  CD2 TYR A 157      38.189   2.838  10.483  1.00 20.00           C  
ATOM   1296  CE1 TYR A 157      37.332   0.425   9.436  1.00 18.68           C  
ATOM   1297  CE2 TYR A 157      36.952   2.761   9.787  1.00 21.03           C  
ATOM   1298  CZ  TYR A 157      36.560   1.559   9.280  1.00 18.65           C  
ATOM   1299  OH  TYR A 157      35.369   1.327   8.574  1.00 22.90           O  
ATOM   1300  N   SER A 158      42.246  -0.211  13.207  1.00 11.39           N  
ATOM   1301  CA  SER A 158      43.529  -0.280  13.912  1.00 11.24           C  
ATOM   1302  C   SER A 158      44.503  -1.040  13.001  1.00 12.24           C  
ATOM   1303  O   SER A 158      44.231  -2.196  12.674  1.00 11.25           O  
ATOM   1304  CB  SER A 158      43.405  -1.023  15.252  1.00 13.06           C  
ATOM   1305  OG  SER A 158      44.721  -1.082  15.862  1.00 13.55           O  
ATOM   1306  N   PRO A 159      45.656  -0.414  12.643  1.00 13.63           N  
ATOM   1307  CA  PRO A 159      46.073   0.967  12.938  1.00 15.50           C  
ATOM   1308  C   PRO A 159      45.149   1.963  12.223  1.00 15.22           C  
ATOM   1309  O   PRO A 159      44.398   1.545  11.310  1.00 15.05           O  
ATOM   1310  CB  PRO A 159      47.522   1.051  12.369  1.00 15.71           C  
ATOM   1311  CG  PRO A 159      47.960  -0.357  12.264  1.00 16.35           C  
ATOM   1312  CD  PRO A 159      46.714  -1.167  11.940  1.00 14.86           C  
ATOM   1313  N   PRO A 160      45.166   3.235  12.629  1.00 15.71           N  
ATOM   1314  CA  PRO A 160      44.375   4.214  11.895  1.00 16.52           C  
ATOM   1315  C   PRO A 160      44.852   4.314  10.433  1.00 16.93           C  
ATOM   1316  O   PRO A 160      46.053   4.103  10.144  1.00 17.06           O  
ATOM   1317  CB  PRO A 160      44.667   5.528  12.633  1.00 18.07           C  
ATOM   1318  CG  PRO A 160      45.255   5.160  13.903  1.00 19.33           C  
ATOM   1319  CD  PRO A 160      45.952   3.860  13.699  1.00 15.90           C  
ATOM   1320  N   PHE A 161      43.939   4.638   9.513  1.00 16.37           N  
ATOM   1321  CA  PHE A 161      44.332   4.882   8.135  1.00 18.22           C  
ATOM   1322  C   PHE A 161      43.458   5.956   7.535  1.00 19.20           C  
ATOM   1323  O   PHE A 161      42.277   6.083   7.869  1.00 18.76           O  
ATOM   1324  CB  PHE A 161      44.324   3.584   7.253  1.00 17.36           C  
ATOM   1325  CG  PHE A 161      42.968   2.902   7.143  1.00 16.85           C  
ATOM   1326  CD1 PHE A 161      42.099   3.193   6.077  1.00 18.99           C  
ATOM   1327  CD2 PHE A 161      42.555   1.955   8.113  1.00 17.76           C  
ATOM   1328  CE1 PHE A 161      40.819   2.545   5.987  1.00 20.46           C  
ATOM   1329  CE2 PHE A 161      41.302   1.314   8.037  1.00 16.65           C  
ATOM   1330  CZ  PHE A 161      40.417   1.606   6.946  1.00 17.44           C  
ATOM   1331  N   ASP A 162      44.023   6.760   6.655  1.00 20.89           N  
ATOM   1332  CA  ASP A 162      43.131   7.723   6.020  1.00 22.71           C  
ATOM   1333  C   ASP A 162      43.127   7.613   4.505  1.00 22.39           C  
ATOM   1334  O   ASP A 162      42.493   8.451   3.841  1.00 21.15           O  
ATOM   1335  CB  ASP A 162      43.469   9.134   6.468  1.00 24.80           C  
ATOM   1336  CG  ASP A 162      44.954   9.382   6.464  1.00 29.73           C  
ATOM   1337  OD1 ASP A 162      45.634   8.768   5.613  1.00 34.51           O  
ATOM   1338  OD2 ASP A 162      45.446  10.144   7.354  1.00 38.80           O  
ATOM   1339  N   THR A 163      43.796   6.590   3.954  1.00 20.52           N  
ATOM   1340  CA  THR A 163      43.582   6.302   2.530  1.00 20.58           C  
ATOM   1341  C   THR A 163      43.205   4.822   2.377  1.00 19.86           C  
ATOM   1342  O   THR A 163      43.527   3.973   3.259  1.00 17.77           O  
ATOM   1343  CB  THR A 163      44.817   6.599   1.668  1.00 21.70           C  
ATOM   1344  OG1 THR A 163      45.800   5.631   1.988  1.00 25.15           O  
ATOM   1345  CG2 THR A 163      45.386   8.002   1.944  1.00 21.76           C  
ATOM   1346  N   CYS A 164      42.458   4.532   1.303  1.00 17.71           N  
ATOM   1347  CA  CYS A 164      42.116   3.141   0.903  1.00 18.88           C  
ATOM   1348  C   CYS A 164      41.837   3.092  -0.603  1.00 17.59           C  
ATOM   1349  O   CYS A 164      42.045   4.101  -1.288  1.00 19.23           O  
ATOM   1350  CB  CYS A 164      40.949   2.587   1.712  1.00 18.46           C  
ATOM   1351  SG  CYS A 164      39.346   3.388   1.378  1.00 22.24           S  
ATOM   1352  N   HIS A 165      41.411   1.942  -1.120  1.00 16.98           N  
ATOM   1353  CA  HIS A 165      41.082   1.827  -2.522  1.00 16.68           C  
ATOM   1354  C   HIS A 165      39.620   1.564  -2.692  1.00 17.69           C  
ATOM   1355  O   HIS A 165      39.023   0.824  -1.905  1.00 15.51           O  
ATOM   1356  CB  HIS A 165      41.885   0.671  -3.162  1.00 18.41           C  
ATOM   1357  CG  HIS A 165      43.361   0.854  -3.036  1.00 20.32           C  
ATOM   1358  ND1 HIS A 165      44.091   0.300  -2.006  1.00 19.57           N  
ATOM   1359  CD2 HIS A 165      44.243   1.556  -3.795  1.00 22.04           C  
ATOM   1360  CE1 HIS A 165      45.363   0.660  -2.127  1.00 22.01           C  
ATOM   1361  NE2 HIS A 165      45.485   1.405  -3.208  1.00 21.17           N  
ATOM   1362  N   ALA A 166      39.050   2.156  -3.740  1.00 16.60           N  
ATOM   1363  CA  ALA A 166      37.735   1.786  -4.217  1.00 17.34           C  
ATOM   1364  C   ALA A 166      37.934   0.946  -5.460  1.00 17.35           C  
ATOM   1365  O   ALA A 166      38.825   1.248  -6.281  1.00 18.75           O  
ATOM   1366  CB  ALA A 166      36.922   3.046  -4.580  1.00 16.90           C  
ATOM   1367  N   PHE A 167      37.065  -0.032  -5.631  1.00 16.19           N  
ATOM   1368  CA  PHE A 167      37.120  -0.942  -6.747  1.00 17.42           C  
ATOM   1369  C   PHE A 167      35.894  -0.797  -7.658  1.00 18.77           C  
ATOM   1370  O   PHE A 167      34.778  -0.762  -7.193  1.00 17.91           O  
ATOM   1371  CB  PHE A 167      37.152  -2.364  -6.223  1.00 16.69           C  
ATOM   1372  CG  PHE A 167      38.372  -2.656  -5.427  1.00 16.73           C  
ATOM   1373  CD1 PHE A 167      39.454  -3.362  -5.982  1.00 18.38           C  
ATOM   1374  CD2 PHE A 167      38.472  -2.180  -4.103  1.00 14.81           C  
ATOM   1375  CE1 PHE A 167      40.605  -3.596  -5.235  1.00 18.02           C  
ATOM   1376  CE2 PHE A 167      39.631  -2.402  -3.327  1.00 14.93           C  
ATOM   1377  CZ  PHE A 167      40.708  -3.112  -3.891  1.00 14.37           C  
ATOM   1378  N   ASP A 168      36.142  -0.830  -8.958  1.00 18.94           N  
ATOM   1379  CA  ASP A 168      35.081  -0.756  -9.981  1.00 21.79           C  
ATOM   1380  C   ASP A 168      34.466  -2.134 -10.135  1.00 21.56           C  
ATOM   1381  O   ASP A 168      35.158  -3.103 -10.505  1.00 20.65           O  
ATOM   1382  CB  ASP A 168      35.746  -0.271 -11.275  1.00 22.34           C  
ATOM   1383  CG  ASP A 168      34.829  -0.347 -12.501  1.00 29.84           C  
ATOM   1384  OD1 ASP A 168      33.581  -0.439 -12.357  1.00 33.00           O  
ATOM   1385  OD2 ASP A 168      35.431  -0.342 -13.608  1.00 35.15           O  
ATOM   1386  N   GLN A 169      33.180  -2.252  -9.837  1.00 21.00           N  
ATOM   1387  CA  GLN A 169      32.548  -3.565  -9.800  1.00 23.27           C  
ATOM   1388  C   GLN A 169      32.558  -4.224 -11.178  1.00 23.75           C  
ATOM   1389  O   GLN A 169      32.403  -5.443 -11.261  1.00 24.63           O  
ATOM   1390  CB  GLN A 169      31.110  -3.510  -9.286  1.00 22.40           C  
ATOM   1391  CG  GLN A 169      30.514  -4.863  -8.938  1.00 24.47           C  
ATOM   1392  CD  GLN A 169      29.127  -4.774  -8.316  1.00 24.95           C  
ATOM   1393  OE1 GLN A 169      28.692  -3.710  -7.854  1.00 27.94           O  
ATOM   1394  NE2 GLN A 169      28.424  -5.918  -8.275  1.00 28.68           N  
ATOM   1395  N   ARG A 170      32.667  -3.404 -12.229  1.00 24.75           N  
ATOM   1396  CA  ARG A 170      32.583  -3.903 -13.604  0.50 24.49           C  
ATOM   1398  C   ARG A 170      33.909  -4.472 -14.111  1.00 25.02           C  
ATOM   1399  O   ARG A 170      33.924  -5.324 -15.010  1.00 25.14           O  
ATOM   1400  CB  ARG A 170      32.104  -2.799 -14.554  0.50 24.88           C  
ATOM   1402  CG  ARG A 170      30.636  -2.899 -14.943  0.50 25.33           C  
ATOM   1404  CD  ARG A 170      30.241  -1.825 -15.953  0.50 24.53           C  
ATOM   1406  NE  ARG A 170      30.153  -0.493 -15.349  0.50 28.40           N  
ATOM   1408  CZ  ARG A 170      29.940   0.645 -16.020  0.50 27.81           C  
ATOM   1410  NH1 ARG A 170      29.784   0.653 -17.339  0.50 27.70           N  
ATOM   1412  NH2 ARG A 170      29.881   1.783 -15.359  0.50 26.81           N  
ATOM   1414  N   THR A 171      35.024  -4.022 -13.541  1.00 24.29           N  
ATOM   1415  CA  THR A 171      36.360  -4.405 -14.022  1.00 25.09           C  
ATOM   1416  C   THR A 171      37.331  -4.920 -12.942  1.00 24.98           C  
ATOM   1417  O   THR A 171      38.369  -5.556 -13.265  1.00 25.00           O  
ATOM   1418  CB  THR A 171      37.082  -3.219 -14.694  1.00 26.17           C  
ATOM   1419  OG1 THR A 171      37.284  -2.185 -13.733  1.00 24.36           O  
ATOM   1420  CG2 THR A 171      36.270  -2.629 -15.914  1.00 26.01           C  
ATOM   1421  N   GLY A 172      37.043  -4.597 -11.675  1.00 23.27           N  
ATOM   1422  CA  GLY A 172      37.997  -4.887 -10.621  1.00 22.98           C  
ATOM   1423  C   GLY A 172      39.111  -3.851 -10.509  1.00 22.95           C  
ATOM   1424  O   GLY A 172      39.967  -3.950  -9.597  1.00 22.09           O  
ATOM   1425  N   HIS A 173      39.104  -2.822 -11.364  1.00 22.87           N  
ATOM   1426  CA  HIS A 173      40.147  -1.811 -11.294  0.50 22.69           C  
ATOM   1428  C   HIS A 173      39.984  -0.980 -10.029  1.00 22.91           C  
ATOM   1429  O   HIS A 173      38.879  -0.673  -9.612  1.00 23.33           O  
ATOM   1430  CB  HIS A 173      40.170  -0.926 -12.554  0.50 23.23           C  
ATOM   1432  CG  HIS A 173      40.512  -1.673 -13.809  0.50 23.18           C  
ATOM   1434  ND1 HIS A 173      40.167  -1.218 -15.067  0.50 25.10           N  
ATOM   1436  CD2 HIS A 173      41.151  -2.853 -13.999  0.50 23.52           C  
ATOM   1438  CE1 HIS A 173      40.587  -2.083 -15.974  0.50 23.72           C  
ATOM   1440  NE2 HIS A 173      41.191  -3.080 -15.352  0.50 22.94           N  
ATOM   1442  N   LYS A 174      41.081  -0.680  -9.384  1.00 23.46           N  
ATOM   1443  CA  LYS A 174      40.983   0.102  -8.145  1.00 24.75           C  
ATOM   1444  C   LYS A 174      41.588   1.477  -8.305  1.00 25.04           C  
ATOM   1445  O   LYS A 174      42.420   1.700  -9.186  1.00 25.22           O  
ATOM   1446  CB  LYS A 174      41.662  -0.648  -6.997  1.00 25.25           C  
ATOM   1447  CG  LYS A 174      43.130  -0.760  -7.137  1.00 26.11           C  
ATOM   1448  CD  LYS A 174      43.747  -1.305  -5.855  1.00 30.27           C  
ATOM   1449  CE  LYS A 174      45.060  -2.014  -6.092  1.00 33.03           C  
ATOM   1450  NZ  LYS A 174      46.127  -1.218  -6.808  1.00 32.37           N  
ATOM   1451  N   ASN A 175      41.151   2.413  -7.475  1.00 24.20           N  
ATOM   1452  CA  ASN A 175      41.788   3.717  -7.380  1.00 26.16           C  
ATOM   1453  C   ASN A 175      41.939   4.096  -5.925  1.00 25.58           C  
ATOM   1454  O   ASN A 175      41.139   3.676  -5.075  1.00 23.80           O  
ATOM   1455  CB  ASN A 175      41.016   4.780  -8.155  1.00 27.26           C  
ATOM   1456  CG  ASN A 175      39.637   5.031  -7.581  1.00 32.53           C  
ATOM   1457  OD1 ASN A 175      38.773   4.141  -7.598  1.00 35.96           O  
ATOM   1458  ND2 ASN A 175      39.413   6.257  -7.070  1.00 34.81           N  
ATOM   1459  N   LYS A 176      42.990   4.855  -5.644  1.00 25.51           N  
ATOM   1460  CA  LYS A 176      43.290   5.254  -4.290  1.00 26.42           C  
ATOM   1461  C   LYS A 176      42.383   6.417  -3.956  1.00 25.99           C  
ATOM   1462  O   LYS A 176      42.130   7.292  -4.789  1.00 26.55           O  
ATOM   1463  CB  LYS A 176      44.760   5.642  -4.161  1.00 26.82           C  
ATOM   1464  CG  LYS A 176      45.286   5.640  -2.747  1.00 31.78           C  
ATOM   1465  CD  LYS A 176      46.824   5.898  -2.754  1.00 30.49           C  
ATOM   1466  CE  LYS A 176      47.410   5.820  -1.326  1.00 35.44           C  
ATOM   1467  NZ  LYS A 176      48.916   5.968  -1.300  1.00 36.77           N  
ATOM   1468  N   VAL A 177      41.845   6.405  -2.749  1.00 23.32           N  
ATOM   1469  CA  VAL A 177      40.949   7.437  -2.292  1.00 23.98           C  
ATOM   1470  C   VAL A 177      41.450   7.944  -0.928  1.00 23.56           C  
ATOM   1471  O   VAL A 177      41.928   7.158  -0.092  1.00 21.77           O  
ATOM   1472  CB  VAL A 177      39.544   6.852  -2.089  1.00 23.72           C  
ATOM   1473  CG1 VAL A 177      38.640   7.839  -1.278  1.00 27.54           C  
ATOM   1474  CG2 VAL A 177      38.891   6.472  -3.444  1.00 25.34           C  
ATOM   1475  N   THR A 178      41.360   9.259  -0.715  1.00 23.49           N  
ATOM   1476  CA  THR A 178      41.723   9.838   0.586  1.00 24.98           C  
ATOM   1477  C   THR A 178      40.443  10.145   1.258  1.00 24.29           C  
ATOM   1478  O   THR A 178      39.562  10.821   0.694  1.00 26.16           O  
ATOM   1479  CB  THR A 178      42.557  11.103   0.499  1.00 25.76           C  
ATOM   1480  OG1 THR A 178      43.794  10.757  -0.108  1.00 28.07           O  
ATOM   1481  CG2 THR A 178      42.854  11.659   1.960  1.00 26.41           C  
HETATM 1482  N   MSE A 179      40.332   9.630   2.463  1.00 22.73           N  
HETATM 1483  CA  MSE A 179      39.120   9.843   3.182  0.50 22.89           C  
HETATM 1485  C   MSE A 179      39.287  11.039   4.087  1.00 22.63           C  
HETATM 1486  O   MSE A 179      40.387  11.371   4.529  1.00 23.69           O  
HETATM 1487  CB  MSE A 179      38.734   8.606   3.949  0.50 23.11           C  
HETATM 1489  CG  MSE A 179      38.292   7.508   3.013  0.50 23.58           C  
HETATM 1491 SE   MSE A 179      37.998   5.992   4.069  0.50 21.87          SE  
HETATM 1493  CE  MSE A 179      39.877   5.338   4.146  0.50 24.96           C  
ATOM   1495  N   THR A 180      38.189  11.731   4.287  1.00 21.84           N  
ATOM   1496  CA  THR A 180      38.246  12.974   5.039  1.00 20.44           C  
ATOM   1497  C   THR A 180      37.222  12.798   6.169  1.00 18.42           C  
ATOM   1498  O   THR A 180      36.323  11.965   6.057  1.00 17.01           O  
ATOM   1499  CB  THR A 180      37.842  14.161   4.141  1.00 21.88           C  
ATOM   1500  OG1 THR A 180      36.490  13.970   3.702  1.00 25.67           O  
ATOM   1501  CG2 THR A 180      38.712  14.164   2.922  1.00 23.65           C  
ATOM   1502  N   PHE A 181      37.386  13.585   7.220  1.00 16.54           N  
ATOM   1503  CA  PHE A 181      36.410  13.614   8.312  1.00 15.27           C  
ATOM   1504  C   PHE A 181      35.443  14.754   8.115  1.00 14.37           C  
ATOM   1505  O   PHE A 181      35.875  15.899   7.912  1.00 15.27           O  
ATOM   1506  CB  PHE A 181      37.117  13.750   9.665  1.00 14.81           C  
ATOM   1507  CG  PHE A 181      37.808  12.498  10.111  1.00 16.63           C  
ATOM   1508  CD1 PHE A 181      37.095  11.337  10.328  1.00 14.43           C  
ATOM   1509  CD2 PHE A 181      39.196  12.484  10.297  1.00 20.21           C  
ATOM   1510  CE1 PHE A 181      37.732  10.166  10.744  1.00 18.12           C  
ATOM   1511  CE2 PHE A 181      39.828  11.338  10.715  1.00 18.27           C  
ATOM   1512  CZ  PHE A 181      39.121  10.173  10.938  1.00 18.89           C  
ATOM   1513  N   HIS A 182      34.154  14.462   8.259  1.00 11.01           N  
ATOM   1514  CA  HIS A 182      33.089  15.469   8.229  1.00 11.03           C  
ATOM   1515  C   HIS A 182      33.153  16.301   9.509  1.00 10.84           C  
ATOM   1516  O   HIS A 182      32.850  17.492   9.526  1.00 11.26           O  
ATOM   1517  CB  HIS A 182      31.731  14.730   8.183  1.00 10.81           C  
ATOM   1518  CG  HIS A 182      30.556  15.624   8.005  1.00 11.59           C  
ATOM   1519  ND1 HIS A 182      30.280  16.271   6.811  1.00 11.81           N  
ATOM   1520  CD2 HIS A 182      29.570  15.964   8.862  1.00 12.98           C  
ATOM   1521  CE1 HIS A 182      29.160  16.948   6.938  1.00 12.08           C  
ATOM   1522  NE2 HIS A 182      28.714  16.793   8.177  1.00 14.19           N  
ATOM   1523  N   SER A 183      33.538  15.638  10.604  1.00 10.08           N  
ATOM   1524  CA  SER A 183      33.652  16.327  11.916  1.00  9.38           C  
ATOM   1525  C   SER A 183      34.695  15.603  12.749  1.00 10.86           C  
ATOM   1526  O   SER A 183      35.093  14.444  12.420  1.00 10.17           O  
ATOM   1527  CB  SER A 183      32.317  16.337  12.659  1.00  9.23           C  
ATOM   1528  OG  SER A 183      31.880  15.029  13.090  1.00  9.77           O  
ATOM   1529  N   LYS A 184      35.219  16.300  13.784  1.00 11.12           N  
ATOM   1530  CA  LYS A 184      36.153  15.667  14.740  1.00 11.83           C  
ATOM   1531  C   LYS A 184      35.793  16.153  16.111  1.00 11.74           C  
ATOM   1532  O   LYS A 184      35.623  17.347  16.317  1.00 10.16           O  
ATOM   1533  CB  LYS A 184      37.629  16.009  14.438  1.00 11.56           C  
ATOM   1534  CG  LYS A 184      38.169  15.611  13.058  1.00 13.98           C  
ATOM   1535  CD  LYS A 184      39.666  15.998  12.965  1.00 17.26           C  
ATOM   1536  CE  LYS A 184      40.327  15.461  11.763  1.00 29.13           C  
ATOM   1537  NZ  LYS A 184      41.830  15.650  11.888  1.00 36.86           N  
ATOM   1538  N   PHE A 185      35.556  15.222  17.022  1.00 11.07           N  
ATOM   1539  CA  PHE A 185      35.189  15.533  18.436  1.00 11.91           C  
ATOM   1540  C   PHE A 185      33.954  16.412  18.523  1.00 12.32           C  
ATOM   1541  O   PHE A 185      33.884  17.326  19.349  1.00 12.78           O  
ATOM   1542  CB  PHE A 185      36.414  16.147  19.118  1.00 12.21           C  
ATOM   1543  CG  PHE A 185      37.712  15.426  18.767  1.00 15.13           C  
ATOM   1544  CD1 PHE A 185      37.886  14.077  19.091  1.00 19.06           C  
ATOM   1545  CD2 PHE A 185      38.713  16.073  18.058  1.00 16.82           C  
ATOM   1546  CE1 PHE A 185      39.081  13.433  18.755  1.00 19.44           C  
ATOM   1547  CE2 PHE A 185      39.889  15.443  17.720  1.00 17.65           C  
ATOM   1548  CZ  PHE A 185      40.055  14.108  18.057  1.00 16.41           C  
ATOM   1549  N   GLY A 186      32.968  16.152  17.662  1.00 10.16           N  
ATOM   1550  CA  GLY A 186      31.744  16.913  17.647  1.00 12.27           C  
ATOM   1551  C   GLY A 186      31.766  18.238  16.873  1.00 13.07           C  
ATOM   1552  O   GLY A 186      30.714  18.878  16.799  1.00 15.08           O  
ATOM   1553  N   ILE A 187      32.920  18.581  16.298  1.00 11.95           N  
ATOM   1554  CA  ILE A 187      33.126  19.866  15.607  1.00 11.62           C  
ATOM   1555  C   ILE A 187      33.166  19.629  14.105  1.00 10.30           C  
ATOM   1556  O   ILE A 187      33.986  18.872  13.637  1.00 10.86           O  
ATOM   1557  CB  ILE A 187      34.440  20.541  16.074  1.00 12.77           C  
ATOM   1558  CG1 ILE A 187      34.433  20.724  17.605  1.00 13.62           C  
ATOM   1559  CG2 ILE A 187      34.662  21.943  15.345  1.00 11.81           C  
ATOM   1560  CD1 ILE A 187      33.229  21.510  18.177  1.00 15.63           C  
ATOM   1561  N   ARG A 188      32.246  20.277  13.387  1.00 10.88           N  
ATOM   1562  CA  ARG A 188      32.278  20.191  11.904  1.00 11.77           C  
ATOM   1563  C   ARG A 188      33.623  20.703  11.386  1.00 12.37           C  
ATOM   1564  O   ARG A 188      34.125  21.775  11.817  1.00 12.26           O  
ATOM   1565  CB  ARG A 188      31.116  21.019  11.357  1.00 11.17           C  
ATOM   1566  CG  ARG A 188      31.063  21.021   9.788  1.00 14.47           C  
ATOM   1567  CD  ARG A 188      30.428  19.728   9.233  1.00 15.10           C  
ATOM   1568  NE  ARG A 188      30.309  19.897   7.770  1.00 13.34           N  
ATOM   1569  CZ  ARG A 188      31.243  19.609   6.868  1.00 17.81           C  
ATOM   1570  NH1 ARG A 188      32.375  19.018   7.195  1.00 14.76           N  
ATOM   1571  NH2 ARG A 188      31.012  19.882   5.564  1.00 22.52           N  
ATOM   1572  N   THR A 189      34.232  19.960  10.465  1.00 13.30           N  
ATOM   1573  CA  THR A 189      35.556  20.305   9.926  1.00 16.05           C  
ATOM   1574  C   THR A 189      35.461  20.365   8.428  1.00 19.11           C  
ATOM   1575  O   THR A 189      35.779  19.377   7.750  1.00 20.14           O  
ATOM   1576  CB  THR A 189      36.642  19.319  10.333  1.00 16.19           C  
ATOM   1577  OG1 THR A 189      36.175  17.961  10.068  1.00 17.02           O  
ATOM   1578  CG2 THR A 189      36.913  19.398  11.825  1.00 16.65           C  
ATOM   1579  N   PRO A 190      34.974  21.507   7.911  1.00 20.60           N  
ATOM   1580  CA  PRO A 190      34.785  21.703   6.462  1.00 23.66           C  
ATOM   1581  C   PRO A 190      36.100  21.579   5.699  1.00 25.43           C  
ATOM   1582  O   PRO A 190      37.170  21.932   6.251  1.00 28.18           O  
ATOM   1583  CB  PRO A 190      34.267  23.147   6.358  1.00 23.25           C  
ATOM   1584  CG  PRO A 190      33.718  23.473   7.672  1.00 23.31           C  
ATOM   1585  CD  PRO A 190      34.589  22.700   8.670  1.00 20.18           C  
TER    1586      PRO A 190                                                      
END
MOLECULE T0414.pdb
ATOM      1  N   ALA     3      33.302  15.772  39.809  1.00 36.36           N  
ATOM      2  CA  ALA     3      33.703  14.577  39.009  1.00 34.68           C  
ATOM      3  C   ALA     3      33.623  14.788  37.490  1.00 33.45           C  
ATOM      4  O   ALA     3      32.753  15.521  36.975  1.00 34.46           O  
ATOM      5  CB  ALA     3      32.891  13.338  39.421  1.00 34.63           C  
ATOM      6  N   MET     4      34.518  14.186  36.727  0.50 33.03           N  
ATOM      8  CA  MET     4      34.520  14.424  35.288  0.50 31.92           C  
ATOM     10  C   MET     4      33.425  13.560  34.616  0.50 29.87           C  
ATOM     12  O   MET     4      33.219  12.421  35.010  0.50 28.81           O  
ATOM     14  CB  MET     4      35.942  14.155  34.757  0.50 32.53           C  
ATOM     16  CG  MET     4      36.126  13.883  33.287  0.50 33.68           C  
ATOM     18  SD  MET     4      37.621  12.592  33.077  0.30 35.37          SE  
ATOM     20  CE  MET     4      38.935  13.454  34.246  0.50 35.07           C  
ATOM     22  N   LYS     5      32.683  14.127  33.663  0.50 27.74           N  
ATOM     24  CA  LYS     5      31.796  13.306  32.842  0.50 25.75           C  
ATOM     26  C   LYS     5      32.631  12.565  31.797  0.50 23.22           C  
ATOM     28  O   LYS     5      33.773  12.916  31.546  0.50 22.57           O  
ATOM     30  CB  LYS     5      30.709  14.150  32.160  0.50 26.57           C  
ATOM     32  CG  LYS     5      29.525  14.483  33.071  0.50 27.85           C  
ATOM     34  CD  LYS     5      28.325  14.912  32.262  0.50 29.82           C  
ATOM     36  CE  LYS     5      27.439  13.747  31.918  0.50 28.42           C  
ATOM     38  NZ  LYS     5      26.334  13.574  32.915  0.50 27.77           N  
ATOM     40  N   PRO     6      32.050  11.528  31.182  1.00 21.30           N  
ATOM     41  CA  PRO     6      32.693  10.923  29.996  1.00 19.52           C  
ATOM     42  C   PRO     6      32.625  11.935  28.854  1.00 18.68           C  
ATOM     43  O   PRO     6      31.774  12.839  28.867  1.00 19.30           O  
ATOM     44  CB  PRO     6      31.790   9.733  29.675  1.00 19.69           C  
ATOM     45  CG  PRO     6      30.458  10.178  30.200  1.00 20.34           C  
ATOM     46  CD  PRO     6      30.766  10.901  31.500  1.00 21.56           C  
ATOM     47  N   ASP     7      33.506  11.792  27.867  1.00 17.52           N  
ATOM     48  CA  ASP     7      33.309  12.556  26.627  1.00 16.91           C  
ATOM     49  C   ASP     7      32.131  11.917  25.899  1.00 15.85           C  
ATOM     50  O   ASP     7      31.966  10.690  25.921  1.00 17.32           O  
ATOM     51  CB  ASP     7      34.552  12.523  25.770  1.00 17.30           C  
ATOM     52  CG  ASP     7      35.764  13.025  26.518  1.00 20.36           C  
ATOM     53  OD1 ASP     7      35.723  14.200  26.989  1.00 22.01           O  
ATOM     54  OD2 ASP     7      36.738  12.272  26.639  1.00 20.73           O  
ATOM     55  N   ILE     8      31.291  12.738  25.293  1.00 16.43           N  
ATOM     56  CA  ILE     8      30.057  12.263  24.664  1.00 16.85           C  
ATOM     57  C   ILE     8      30.093  12.721  23.218  1.00 17.30           C  
ATOM     58  O   ILE     8      30.202  13.939  22.920  1.00 16.82           O  
ATOM     59  CB  ILE     8      28.808  12.859  25.331  1.00 16.75           C  
ATOM     60  CG1 ILE     8      28.809  12.531  26.831  1.00 17.21           C  
ATOM     61  CG2 ILE     8      27.531  12.326  24.628  1.00 17.36           C  
ATOM     62  CD1 ILE     8      27.659  13.134  27.576  1.00 21.50           C  
ATOM     63  N   TYR     9      30.035  11.755  22.304  1.00 16.25           N  
ATOM     64  CA  TYR     9      30.189  12.064  20.879  1.00 16.53           C  
ATOM     65  C   TYR     9      28.922  11.695  20.103  1.00 16.71           C  
ATOM     66  O   TYR     9      28.269  10.652  20.365  1.00 17.09           O  
ATOM     67  CB  TYR     9      31.309  11.207  20.307  1.00 18.16           C  
ATOM     68  CG  TYR     9      32.621  11.239  21.056  1.00 19.13           C  
ATOM     69  CD1 TYR     9      33.272  12.425  21.336  1.00 20.08           C  
ATOM     70  CD2 TYR     9      33.226  10.035  21.442  1.00 21.22           C  
ATOM     71  CE1 TYR     9      34.527  12.415  22.020  1.00 19.52           C  
ATOM     72  CE2 TYR     9      34.442  10.010  22.068  1.00 19.90           C  
ATOM     73  CZ  TYR     9      35.070  11.186  22.368  1.00 19.38           C  
ATOM     74  OH  TYR     9      36.285  11.080  23.009  1.00 22.23           O  
ATOM     75  N   GLU    10      28.590  12.535  19.113  1.00 16.20           N  
ATOM     76  CA  GLU    10      27.458  12.237  18.240  1.00 17.73           C  
ATOM     77  C   GLU    10      27.825  12.717  16.832  1.00 17.84           C  
ATOM     78  O   GLU    10      28.762  13.547  16.657  1.00 17.95           O  
ATOM     79  CB  GLU    10      26.181  12.949  18.724  1.00 18.99           C  
ATOM     80  CG  GLU    10      26.360  14.445  18.695  1.00 21.75           C  
ATOM     81  CD  GLU    10      25.209  15.268  19.281  1.00 25.44           C  
ATOM     82  OE1 GLU    10      24.163  14.693  19.649  1.00 33.26           O  
ATOM     83  OE2 GLU    10      25.399  16.514  19.308  1.00 33.86           O  
ATOM     84  N   ASN    11      27.070  12.220  15.860  1.00 15.68           N  
ATOM     85  CA  ASN    11      27.238  12.683  14.477  1.00 15.50           C  
ATOM     86  C   ASN    11      25.856  12.930  13.910  1.00 16.30           C  
ATOM     87  O   ASN    11      25.046  11.966  13.797  1.00 16.56           O  
ATOM     88  CB  ASN    11      27.966  11.608  13.647  1.00 17.10           C  
ATOM     89  CG  ASN    11      28.062  11.990  12.175  1.00 17.78           C  
ATOM     90  OD1 ASN    11      27.841  13.151  11.836  1.00 17.07           O  
ATOM     91  ND2 ASN    11      28.398  11.027  11.314  1.00 16.10           N  
ATOM     92  N   ASN    12      25.572  14.203  13.592  1.00 17.76           N  
ATOM     93  CA  ASN    12      24.307  14.543  12.923  1.00 18.55           C  
ATOM     94  C   ASN    12      24.489  14.954  11.485  1.00 19.79           C  
ATOM     95  O   ASN    12      23.556  15.494  10.875  1.00 23.14           O  
ATOM     96  CB  ASN    12      23.564  15.640  13.703  1.00 20.05           C  
ATOM     97  CG  ASN    12      23.156  15.160  15.094  1.00 23.62           C  
ATOM     98  OD1 ASN    12      23.532  15.777  16.086  1.00 32.59           O  
ATOM     99  ND2 ASN    12      22.482  14.022  15.159  1.00 27.73           N  
ATOM    100  N   ARG    13      25.665  14.690  10.940  1.00 16.78           N  
ATOM    101  CA  ARG    13      26.007  15.090   9.567  1.00 17.18           C  
ATOM    102  C   ARG    13      25.867  13.915   8.606  1.00 17.32           C  
ATOM    103  O   ARG    13      25.768  12.761   9.017  1.00 18.57           O  
ATOM    104  CB  ARG    13      27.463  15.613   9.536  1.00 16.99           C  
ATOM    105  CG  ARG    13      27.698  16.841  10.366  1.00 16.86           C  
ATOM    106  CD  ARG    13      29.145  17.340  10.231  1.00 18.64           C  
ATOM    107  NE  ARG    13      29.314  18.572  11.017  1.00 20.84           N  
ATOM    108  CZ  ARG    13      29.068  19.795  10.555  1.00 22.46           C  
ATOM    109  NH1 ARG    13      28.699  19.980   9.285  1.00 21.30           N  
ATOM    110  NH2 ARG    13      29.238  20.846  11.368  1.00 26.57           N  
ATOM    111  N   GLU    14      25.874  14.191   7.309  1.00 16.57           N  
ATOM    112  CA  GLU    14      25.895  13.116   6.308  1.00 17.51           C  
ATOM    113  C   GLU    14      27.211  12.302   6.422  1.00 16.26           C  
ATOM    114  O   GLU    14      28.303  12.837   6.662  1.00 18.17           O  
ATOM    115  CB  GLU    14      25.802  13.757   4.918  1.00 18.63           C  
ATOM    116  CG  GLU    14      25.635  12.781   3.785  1.00 22.71           C  
ATOM    117  CD  GLU    14      25.134  13.481   2.513  1.00 24.46           C  
ATOM    118  OE1 GLU    14      23.942  13.830   2.472  1.00 28.70           O  
ATOM    119  OE2 GLU    14      25.953  13.623   1.579  1.00 28.01           O  
ATOM    120  N   GLY    15      27.111  10.995   6.267  1.00 17.10           N  
ATOM    121  CA  GLY    15      28.324  10.243   6.152  1.00 18.01           C  
ATOM    122  C   GLY    15      29.095  10.097   7.455  1.00 17.23           C  
ATOM    123  O   GLY    15      28.526   9.934   8.543  1.00 17.23           O  
ATOM    124  N   ILE    16      30.411  10.148   7.345  1.00 17.29           N  
ATOM    125  CA  ILE    16      31.280   9.730   8.446  1.00 16.95           C  
ATOM    126  C   ILE    16      31.787  10.890   9.280  1.00 16.79           C  
ATOM    127  O   ILE    16      32.203  11.929   8.740  1.00 17.82           O  
ATOM    128  CB  ILE    16      32.507   8.989   7.861  1.00 16.44           C  
ATOM    129  CG1 ILE    16      32.046   7.772   7.049  1.00 18.83           C  
ATOM    130  CG2 ILE    16      33.466   8.593   8.953  1.00 17.93           C  
ATOM    131  CD1 ILE    16      33.193   7.165   6.146  1.00 19.62           C  
ATOM    132  N   LEU    17      31.774  10.717  10.609  1.00 16.67           N  
ATOM    133  CA  LEU    17      32.462  11.624  11.507  1.00 17.09           C  
ATOM    134  C   LEU    17      33.304  10.755  12.436  1.00 17.42           C  
ATOM    135  O   LEU    17      32.781   9.846  13.128  1.00 17.89           O  
ATOM    136  CB  LEU    17      31.464  12.429  12.342  1.00 17.81           C  
ATOM    137  CG  LEU    17      32.111  13.501  13.216  1.00 17.47           C  
ATOM    138  CD1 LEU    17      32.620  14.670  12.347  1.00 19.68           C  
ATOM    139  CD2 LEU    17      31.074  13.984  14.258  1.00 19.13           C  
ATOM    140  N   CYS    18      34.601  11.024  12.429  0.50 18.77           N  
ATOM    142  CA  CYS    18      35.503  10.383  13.334  0.50 18.68           C  
ATOM    144  C   CYS    18      35.329  11.084  14.662  0.50 17.75           C  
ATOM    146  O   CYS    18      35.414  12.342  14.749  0.50 17.11           O  
ATOM    148  CB  CYS    18      36.931  10.520  12.822  0.50 19.68           C  
ATOM    150  SG  CYS    18      38.169   9.741  13.895  0.50 25.35           S  
ATOM    152  N   VAL    19      35.090  10.285  15.703  1.00 17.60           N  
ATOM    153  CA  VAL    19      34.852  10.884  17.017  1.00 17.61           C  
ATOM    154  C   VAL    19      35.901  10.621  18.082  1.00 18.84           C  
ATOM    155  O   VAL    19      36.031  11.426  19.030  1.00 19.37           O  
ATOM    156  CB  VAL    19      33.441  10.554  17.541  1.00 18.37           C  
ATOM    157  CG1 VAL    19      32.386  11.066  16.565  1.00 19.97           C  
ATOM    158  CG2 VAL    19      33.285   9.036  17.807  1.00 19.29           C  
ATOM    159  N   TYR    20      36.659   9.537  17.949  1.00 17.79           N  
ATOM    160  CA  TYR    20      37.705   9.219  18.927  1.00 17.31           C  
ATOM    161  C   TYR    20      38.904   8.679  18.151  1.00 17.74           C  
ATOM    162  O   TYR    20      38.744   7.851  17.253  1.00 17.59           O  
ATOM    163  CB  TYR    20      37.239   8.164  19.938  1.00 18.63           C  
ATOM    164  CG  TYR    20      38.375   7.755  20.831  1.00 18.31           C  
ATOM    165  CD1 TYR    20      38.666   8.491  22.001  1.00 18.30           C  
ATOM    166  CD2 TYR    20      39.252   6.735  20.480  1.00 17.90           C  
ATOM    167  CE1 TYR    20      39.781   8.162  22.798  1.00 16.64           C  
ATOM    168  CE2 TYR    20      40.353   6.396  21.280  1.00 17.14           C  
ATOM    169  CZ  TYR    20      40.610   7.128  22.429  1.00 17.75           C  
ATOM    170  OH  TYR    20      41.720   6.807  23.204  1.00 18.23           O  
ATOM    171  N   LYS    21      40.092   9.175  18.494  0.50 18.45           N  
ATOM    173  CA  LYS    21      41.325   8.709  17.899  0.50 19.23           C  
ATOM    175  C   LYS    21      42.410   8.666  18.967  0.50 18.93           C  
ATOM    177  O   LYS    21      42.492   9.553  19.844  0.50 18.14           O  
ATOM    179  CB  LYS    21      41.769   9.654  16.755  0.50 19.72           C  
ATOM    181  CG  LYS    21      42.986   9.166  15.984  0.50 21.51           C  
ATOM    183  CD  LYS    21      43.277  10.047  14.777  0.50 22.28           C  
ATOM    185  CE  LYS    21      44.165   9.322  13.775  0.50 26.01           C  
ATOM    187  NZ  LYS    21      44.998  10.242  12.956  0.50 28.80           N  
ATOM    189  N   ASN    22      43.246   7.641  18.893  1.00 18.57           N  
ATOM    190  CA  ASN    22      44.510   7.675  19.646  1.00 19.63           C  
ATOM    191  C   ASN    22      45.633   7.170  18.740  1.00 20.21           C  
ATOM    192  O   ASN    22      45.442   7.146  17.525  1.00 21.67           O  
ATOM    193  CB  ASN    22      44.393   6.968  21.000  1.00 19.28           C  
ATOM    194  CG  ASN    22      44.119   5.476  20.878  1.00 18.68           C  
ATOM    195  OD1 ASN    22      44.477   4.855  19.876  1.00 18.07           O  
ATOM    196  ND2 ASN    22      43.512   4.893  21.908  1.00 19.31           N  
ATOM    197  N   GLU    23      46.798   6.802  19.268  0.50 20.33           N  
ATOM    199  CA  GLU    23      47.871   6.392  18.343  0.50 20.79           C  
ATOM    201  C   GLU    23      47.688   4.963  17.811  0.50 20.15           C  
ATOM    203  O   GLU    23      48.445   4.517  16.927  0.50 21.08           O  
ATOM    205  CB  GLU    23      49.271   6.615  18.948  0.50 21.32           C  
ATOM    207  CG  GLU    23      49.531   8.068  19.373  0.50 24.58           C  
ATOM    209  CD  GLU    23      49.988   9.002  18.251  0.50 28.91           C  
ATOM    211  OE1 GLU    23      50.063   8.588  17.074  0.50 31.75           O  
ATOM    213  OE2 GLU    23      50.296  10.181  18.573  0.50 31.68           O  
ATOM    215  N   LYS    24      46.657   4.262  18.314  1.00 19.87           N  
ATOM    216  CA  LYS    24      46.411   2.876  17.906  1.00 18.64           C  
ATOM    217  C   LYS    24      45.123   2.675  17.102  1.00 18.65           C  
ATOM    218  O   LYS    24      45.163   2.084  16.009  1.00 19.79           O  
ATOM    219  CB  LYS    24      46.397   1.937  19.115  1.00 19.67           C  
ATOM    220  CG  LYS    24      47.742   1.895  19.853  1.00 19.24           C  
ATOM    221  CD  LYS    24      47.728   0.842  20.946  1.00 23.27           C  
ATOM    222  CE  LYS    24      49.012   0.890  21.752  1.00 25.06           C  
ATOM    223  NZ  LYS    24      49.012  -0.142  22.838  1.00 26.49           N  
ATOM    224  N   TRP    25      43.996   3.147  17.659  1.00 17.80           N  
ATOM    225  CA  TRP    25      42.710   2.938  16.969  1.00 17.10           C  
ATOM    226  C   TRP    25      41.877   4.189  16.872  1.00 17.05           C  
ATOM    227  O   TRP    25      42.166   5.213  17.501  1.00 17.33           O  
ATOM    228  CB  TRP    25      41.866   1.812  17.636  1.00 17.38           C  
ATOM    229  CG  TRP    25      41.250   2.174  18.989  1.00 17.07           C  
ATOM    230  CD1 TRP    25      40.015   2.746  19.223  1.00 17.16           C  
ATOM    231  CD2 TRP    25      41.857   2.004  20.276  1.00 17.43           C  
ATOM    232  NE1 TRP    25      39.803   2.914  20.576  1.00 16.55           N  
ATOM    233  CE2 TRP    25      40.925   2.472  21.248  1.00 16.10           C  
ATOM    234  CE3 TRP    25      43.109   1.515  20.713  1.00 17.97           C  
ATOM    235  CZ2 TRP    25      41.217   2.471  22.613  1.00 17.89           C  
ATOM    236  CZ3 TRP    25      43.372   1.485  22.082  1.00 18.95           C  
ATOM    237  CH2 TRP    25      42.441   1.975  23.006  1.00 18.93           C  
ATOM    238  N   LEU    26      40.846   4.125  16.057  0.60 17.36           N  
ATOM    240  CA  LEU    26      39.876   5.195  16.053  0.60 18.29           C  
ATOM    242  C   LEU    26      38.473   4.598  16.034  0.60 17.48           C  
ATOM    244  O   LEU    26      38.259   3.406  15.788  0.60 17.47           O  
ATOM    246  CB  LEU    26      40.140   6.186  14.899  0.60 19.00           C  
ATOM    248  CG  LEU    26      40.146   5.630  13.476  0.60 19.25           C  
ATOM    250  CD1 LEU    26      38.728   5.417  13.012  0.60 20.31           C  
ATOM    252  CD2 LEU    26      40.883   6.556  12.503  0.60 20.54           C  
ATOM    254  N   VAL    27      37.519   5.464  16.315  1.00 16.98           N  
ATOM    255  CA  VAL    27      36.079   5.101  16.320  1.00 16.22           C  
ATOM    256  C   VAL    27      35.324   6.179  15.576  1.00 17.45           C  
ATOM    257  O   VAL    27      35.516   7.373  15.844  1.00 17.46           O  
ATOM    258  CB  VAL    27      35.508   5.013  17.747  1.00 17.18           C  
ATOM    259  CG1 VAL    27      34.016   4.551  17.698  1.00 17.61           C  
ATOM    260  CG2 VAL    27      36.386   4.029  18.599  1.00 18.01           C  
ATOM    261  N   CYS    28      34.532   5.742  14.596  1.00 16.21           N  
ATOM    262  CA  CYS    28      33.759   6.689  13.774  1.00 16.26           C  
ATOM    263  C   CYS    28      32.281   6.352  13.879  1.00 16.20           C  
ATOM    264  O   CYS    28      31.899   5.183  14.110  1.00 16.98           O  
ATOM    265  CB  CYS    28      34.172   6.658  12.295  1.00 17.39           C  
ATOM    266  SG  CYS    28      35.986   6.912  12.142  1.00 20.98           S  
ATOM    267  N   ILE    29      31.448   7.378  13.699  1.00 15.71           N  
ATOM    268  CA  ILE    29      30.004   7.183  13.582  1.00 16.13           C  
ATOM    269  C   ILE    29      29.622   7.517  12.143  1.00 16.17           C  
ATOM    270  O   ILE    29      29.951   8.598  11.640  1.00 16.02           O  
ATOM    271  CB  ILE    29      29.218   8.103  14.534  1.00 15.82           C  
ATOM    272  CG1 ILE    29      29.672   7.931  15.981  1.00 15.39           C  
ATOM    273  CG2 ILE    29      27.672   7.900  14.365  1.00 16.09           C  
ATOM    274  CD1 ILE    29      29.037   8.958  16.945  1.00 16.58           C  
ATOM    275  N   LYS    30      28.964   6.585  11.458  1.00 15.88           N  
ATOM    276  CA  LYS    30      28.619   6.785  10.046  1.00 16.21           C  
ATOM    277  C   LYS    30      27.111   6.820   9.855  1.00 16.94           C  
ATOM    278  O   LYS    30      26.400   5.844  10.190  1.00 17.39           O  
ATOM    279  CB  LYS    30      29.211   5.653   9.187  1.00 16.56           C  
ATOM    280  CG  LYS    30      28.903   5.844   7.679  1.00 16.88           C  
ATOM    281  CD  LYS    30      29.732   4.833   6.862  1.00 19.31           C  
ATOM    282  CE  LYS    30      28.991   3.507   6.870  1.00 23.50           C  
ATOM    283  NZ  LYS    30      29.684   2.542   5.986  1.00 28.32           N  
ATOM    284  N   ASN    31      26.611   7.913   9.293  1.00 16.40           N  
ATOM    285  CA  ASN    31      25.209   8.052   8.889  1.00 17.24           C  
ATOM    286  C   ASN    31      25.092   7.792   7.399  1.00 16.60           C  
ATOM    287  O   ASN    31      26.100   7.564   6.719  1.00 16.88           O  
ATOM    288  CB  ASN    31      24.767   9.479   9.184  1.00 17.08           C  
ATOM    289  CG  ASN    31      24.690   9.754  10.673  1.00 17.35           C  
ATOM    290  OD1 ASN    31      24.445   8.818  11.459  1.00 18.51           O  
ATOM    291  ND2 ASN    31      24.915  11.008  11.075  1.00 17.06           N  
ATOM    292  N   TRP    32      23.871   7.844   6.911  1.00 16.43           N  
ATOM    293  CA  TRP    32      23.640   7.654   5.477  1.00 16.87           C  
ATOM    294  C   TRP    32      24.449   8.658   4.661  1.00 16.97           C  
ATOM    295  O   TRP    32      24.639   9.823   5.074  1.00 16.70           O  
ATOM    296  CB  TRP    32      22.156   7.862   5.182  1.00 17.49           C  
ATOM    297  CG  TRP    32      21.767   7.703   3.743  1.00 17.90           C  
ATOM    298  CD1 TRP    32      21.359   6.557   3.112  1.00 18.47           C  
ATOM    299  CD2 TRP    32      21.714   8.745   2.762  1.00 18.65           C  
ATOM    300  NE1 TRP    32      21.081   6.816   1.771  1.00 18.32           N  
ATOM    301  CE2 TRP    32      21.286   8.155   1.538  1.00 18.64           C  
ATOM    302  CE3 TRP    32      22.008  10.118   2.789  1.00 19.67           C  
ATOM    303  CZ2 TRP    32      21.111   8.911   0.360  1.00 20.15           C  
ATOM    304  CZ3 TRP    32      21.847  10.867   1.615  1.00 19.53           C  
ATOM    305  CH2 TRP    32      21.417  10.252   0.420  1.00 19.49           C  
ATOM    306  N   LYS    33      24.952   8.206   3.512  0.50 17.41           N  
ATOM    308  CA  LYS    33      25.520   9.105   2.498  0.50 17.81           C  
ATOM    310  C   LYS    33      25.221   8.457   1.149  0.50 17.76           C  
ATOM    312  O   LYS    33      25.111   7.233   1.067  0.50 17.30           O  
ATOM    314  CB  LYS    33      27.029   9.355   2.697  0.50 18.50           C  
ATOM    316  CG  LYS    33      27.905   8.108   2.859  0.50 17.53           C  
ATOM    318  CD  LYS    33      29.408   8.459   2.928  0.50 18.75           C  
ATOM    320  CE  LYS    33      30.249   7.268   3.434  0.50 20.65           C  
ATOM    322  NZ  LYS    33      30.410   6.095   2.495  0.50 16.18           N  
ATOM    324  N   PRO    34      25.079   9.276   0.086  1.00 18.09           N  
ATOM    325  CA  PRO    34      24.701   8.769  -1.247  1.00 17.70           C  
ATOM    326  C   PRO    34      25.425   7.508  -1.743  1.00 17.56           C  
ATOM    327  O   PRO    34      24.713   6.627  -2.293  1.00 18.77           O  
ATOM    328  CB  PRO    34      24.961   9.981  -2.167  1.00 18.28           C  
ATOM    329  CG  PRO    34      24.611  11.156  -1.256  1.00 18.87           C  
ATOM    330  CD  PRO    34      25.223  10.745   0.112  1.00 18.21           C  
ATOM    331  N   ASP    35      26.747   7.350  -1.534  1.00 17.59           N  
ATOM    332  CA  ASP    35      27.385   6.155  -2.089  1.00 18.40           C  
ATOM    333  C   ASP    35      27.192   4.889  -1.257  1.00 18.59           C  
ATOM    334  O   ASP    35      27.739   3.819  -1.588  1.00 19.50           O  
ATOM    335  CB  ASP    35      28.859   6.364  -2.436  1.00 20.01           C  
ATOM    336  CG  ASP    35      29.792   6.326  -1.216  1.00 22.64           C  
ATOM    337  OD1 ASP    35      29.327   6.354  -0.069  1.00 22.36           O  
ATOM    338  OD2 ASP    35      31.036   6.280  -1.401  1.00 23.21           O  
ATOM    339  N   ASN    36      26.428   5.029  -0.175  1.00 18.02           N  
ATOM    340  CA  ASN    36      25.942   3.845   0.531  1.00 17.85           C  
ATOM    341  C   ASN    36      24.460   3.595   0.249  1.00 17.64           C  
ATOM    342  O   ASN    36      23.911   2.588   0.689  1.00 18.05           O  
ATOM    343  CB  ASN    36      26.070   3.983   2.065  1.00 17.18           C  
ATOM    344  CG  ASN    36      27.514   3.879   2.602  1.00 21.55           C  
ATOM    345  OD1 ASN    36      27.793   4.451   3.630  1.00 30.18           O  
ATOM    346  ND2 ASN    36      28.382   3.116   1.979  1.00 22.47           N  
ATOM    347  N   ASP    37      23.767   4.533  -0.402  1.00 17.32           N  
ATOM    348  CA  ASP    37      22.368   4.259  -0.719  1.00 17.22           C  
ATOM    349  C   ASP    37      22.249   3.126  -1.732  1.00 17.35           C  
ATOM    350  O   ASP    37      23.126   2.958  -2.584  1.00 16.67           O  
ATOM    351  CB  ASP    37      21.719   5.511  -1.320  1.00 17.88           C  
ATOM    352  CG  ASP    37      20.216   5.393  -1.364  1.00 19.89           C  
ATOM    353  OD1 ASP    37      19.582   5.512  -0.288  1.00 21.62           O  
ATOM    354  OD2 ASP    37      19.642   5.158  -2.463  1.00 21.16           O  
ATOM    355  N   ILE    38      21.133   2.394  -1.689  1.00 17.76           N  
ATOM    356  CA  ILE    38      20.948   1.345  -2.698  1.00 19.14           C  
ATOM    357  C   ILE    38      21.100   1.900  -4.142  1.00 19.71           C  
ATOM    358  O   ILE    38      21.650   1.209  -5.026  1.00 20.54           O  
ATOM    359  CB  ILE    38      19.631   0.599  -2.485  1.00 20.17           C  
ATOM    360  CG1 ILE    38      19.657  -0.700  -3.319  1.00 23.22           C  
ATOM    361  CG2 ILE    38      18.432   1.531  -2.673  1.00 21.76           C  
ATOM    362  CD1 ILE    38      18.852  -1.758  -2.799  1.00 26.67           C  
ATOM    363  N   GLU    39      20.657   3.123  -4.368  0.60 18.65           N  
ATOM    365  CA  GLU    39      20.767   3.699  -5.713  0.60 19.62           C  
ATOM    367  C   GLU    39      22.157   4.152  -6.078  0.60 18.83           C  
ATOM    369  O   GLU    39      22.462   4.334  -7.279  0.60 18.82           O  
ATOM    371  CB  GLU    39      19.802   4.868  -5.875  0.60 20.14           C  
ATOM    373  CG  GLU    39      18.363   4.498  -5.623  0.60 22.99           C  
ATOM    375  CD  GLU    39      17.802   3.417  -6.560  0.60 26.07           C  
ATOM    377  OE1 GLU    39      18.361   3.139  -7.646  0.60 28.94           O  
ATOM    379  OE2 GLU    39      16.752   2.856  -6.193  0.60 29.97           O  
ATOM    381  N   GLY    40      22.978   4.383  -5.045  1.00 18.92           N  
ATOM    382  CA  GLY    40      24.291   5.006  -5.202  1.00 18.70           C  
ATOM    383  C   GLY    40      25.463   4.046  -5.085  1.00 19.12           C  
ATOM    384  O   GLY    40      26.595   4.471  -5.205  1.00 19.59           O  
ATOM    385  N   ILE    41      25.200   2.751  -4.884  0.60 18.76           N  
ATOM    387  CA  ILE    41      26.291   1.771  -4.803  0.60 18.02           C  
ATOM    389  C   ILE    41      27.102   1.716  -6.095  0.60 19.31           C  
ATOM    391  O   ILE    41      26.554   1.450  -7.164  0.60 19.38           O  
ATOM    393  CB  ILE    41      25.747   0.371  -4.471  0.60 18.50           C  
ATOM    395  CG1 ILE    41      25.154   0.371  -3.047  0.60 16.67           C  
ATOM    397  CG2 ILE    41      26.865  -0.693  -4.714  0.60 18.56           C  
ATOM    399  CD1 ILE    41      26.117   0.701  -1.919  0.60 18.37           C  
ATOM    401  N   ALA    42      28.406   1.999  -6.003  1.00 18.68           N  
ATOM    402  CA  ALA    42      29.215   2.174  -7.214  1.00 18.88           C  
ATOM    403  C   ALA    42      30.629   1.659  -7.102  1.00 18.31           C  
ATOM    404  O   ALA    42      31.295   1.493  -8.116  1.00 19.25           O  
ATOM    405  CB  ALA    42      29.242   3.688  -7.591  1.00 20.23           C  
ATOM    406  N   HIS    43      31.115   1.464  -5.871  1.00 18.00           N  
ATOM    407  CA  HIS    43      32.509   1.052  -5.664  1.00 16.78           C  
ATOM    408  C   HIS    43      32.608   0.370  -4.335  1.00 17.54           C  
ATOM    409  O   HIS    43      31.736   0.546  -3.468  1.00 17.90           O  
ATOM    410  CB  HIS    43      33.476   2.259  -5.653  1.00 17.86           C  
ATOM    411  CG  HIS    43      32.934   3.453  -4.934  1.00 19.00           C  
ATOM    412  ND1 HIS    43      32.468   4.574  -5.596  1.00 21.45           N  
ATOM    413  CD2 HIS    43      32.713   3.670  -3.607  1.00 20.87           C  
ATOM    414  CE1 HIS    43      32.005   5.442  -4.703  1.00 21.76           C  
ATOM    415  NE2 HIS    43      32.134   4.915  -3.491  1.00 19.81           N  
ATOM    416  N   LEU    44      33.631  -0.452  -4.191  1.00 16.28           N  
ATOM    417  CA  LEU    44      33.989  -1.078  -2.928  1.00 17.41           C  
ATOM    418  C   LEU    44      35.303  -0.515  -2.426  1.00 17.57           C  
ATOM    419  O   LEU    44      36.044   0.102  -3.192  1.00 17.75           O  
ATOM    420  CB  LEU    44      34.140  -2.601  -3.105  1.00 17.41           C  
ATOM    421  CG  LEU    44      32.923  -3.314  -3.708  1.00 17.06           C  
ATOM    422  CD1 LEU    44      33.208  -4.832  -3.740  1.00 18.99           C  
ATOM    423  CD2 LEU    44      31.642  -3.059  -2.890  1.00 17.87           C  
ATOM    424  N   GLU    45      35.613  -0.780  -1.153  1.00 17.32           N  
ATOM    425  CA  GLU    45      36.838  -0.282  -0.525  1.00 17.85           C  
ATOM    426  C   GLU    45      37.617  -1.484  -0.022  1.00 17.53           C  
ATOM    427  O   GLU    45      37.061  -2.561   0.258  1.00 17.19           O  
ATOM    428  CB  GLU    45      36.464   0.633   0.652  1.00 17.71           C  
ATOM    429  CG  GLU    45      37.645   1.395   1.289  1.00 20.73           C  
ATOM    430  CD  GLU    45      37.161   2.412   2.345  1.00 20.50           C  
ATOM    431  OE1 GLU    45      35.935   2.549   2.565  1.00 24.99           O  
ATOM    432  OE2 GLU    45      38.030   3.068   2.921  1.00 32.85           O  
ATOM    433  N   ILE    46      38.916  -1.284   0.170  1.00 18.33           N  
ATOM    434  CA  ILE    46      39.732  -2.349   0.745  1.00 17.98           C  
ATOM    435  C   ILE    46      40.781  -1.674   1.626  1.00 18.08           C  
ATOM    436  O   ILE    46      41.329  -0.614   1.260  1.00 18.26           O  
ATOM    437  CB  ILE    46      40.416  -3.214  -0.352  1.00 18.64           C  
ATOM    438  CG1 ILE    46      41.137  -4.429   0.253  1.00 18.66           C  
ATOM    439  CG2 ILE    46      41.422  -2.371  -1.208  1.00 19.08           C  
ATOM    440  CD1 ILE    46      41.531  -5.521  -0.807  1.00 19.38           C  
ATOM    441  N   HIS    47      41.048  -2.282   2.786  1.00 16.96           N  
ATOM    442  CA  HIS    47      42.132  -1.817   3.653  1.00 17.05           C  
ATOM    443  C   HIS    47      43.253  -2.845   3.589  1.00 18.55           C  
ATOM    444  O   HIS    47      43.075  -4.019   3.928  1.00 19.63           O  
ATOM    445  CB  HIS    47      41.662  -1.750   5.117  1.00 16.94           C  
ATOM    446  CG  HIS    47      40.576  -0.758   5.342  1.00 18.33           C  
ATOM    447  ND1 HIS    47      40.674   0.562   4.944  1.00 20.82           N  
ATOM    448  CD2 HIS    47      39.376  -0.884   5.957  1.00 18.76           C  
ATOM    449  CE1 HIS    47      39.567   1.204   5.295  1.00 22.99           C  
ATOM    450  NE2 HIS    47      38.777   0.359   5.929  1.00 21.68           N  
ATOM    451  N   HIS    48      44.436  -2.396   3.203  1.00 19.42           N  
ATOM    452  CA  HIS    48      45.560  -3.339   3.148  1.00 19.25           C  
ATOM    453  C   HIS    48      46.243  -3.658   4.465  1.00 20.51           C  
ATOM    454  O   HIS    48      46.962  -4.659   4.545  1.00 22.55           O  
ATOM    455  CB  HIS    48      46.594  -2.852   2.116  1.00 19.61           C  
ATOM    456  CG  HIS    48      46.001  -2.629   0.756  1.00 19.32           C  
ATOM    457  ND1 HIS    48      45.428  -3.647   0.021  1.00 21.37           N  
ATOM    458  CD2 HIS    48      45.871  -1.508   0.005  1.00 21.07           C  
ATOM    459  CE1 HIS    48      44.980  -3.168  -1.128  1.00 23.63           C  
ATOM    460  NE2 HIS    48      45.210  -1.868  -1.151  1.00 20.64           N  
ATOM    461  N   SER    49      45.998  -2.843   5.488  0.50 19.93           N  
ATOM    463  CA  SER    49      46.805  -2.926   6.702  0.50 19.80           C  
ATOM    465  C   SER    49      46.013  -2.977   8.005  0.50 19.98           C  
ATOM    467  O   SER    49      46.602  -3.081   9.079  0.50 19.76           O  
ATOM    469  CB  SER    49      47.783  -1.755   6.733  0.50 21.12           C  
ATOM    471  OG  SER    49      48.664  -1.820   5.623  0.50 20.88           O  
ATOM    473  N   THR    50      44.689  -2.893   7.908  1.00 19.07           N  
ATOM    474  CA  THR    50      43.835  -2.910   9.105  1.00 18.53           C  
ATOM    475  C   THR    50      42.602  -3.775   8.911  1.00 18.49           C  
ATOM    476  O   THR    50      42.030  -3.815   7.816  1.00 18.74           O  
ATOM    477  CB  THR    50      43.401  -1.487   9.583  1.00 19.33           C  
ATOM    478  OG1 THR    50      42.743  -1.587  10.864  1.00 18.04           O  
ATOM    479  CG2 THR    50      42.423  -0.839   8.629  1.00 18.56           C  
ATOM    480  N   ASP    51      42.210  -4.431   9.995  1.00 17.41           N  
ATOM    481  CA  ASP    51      40.881  -4.992  10.096  1.00 17.63           C  
ATOM    482  C   ASP    51      39.907  -3.856  10.464  1.00 17.46           C  
ATOM    483  O   ASP    51      40.329  -2.803  10.977  1.00 17.76           O  
ATOM    484  CB  ASP    51      40.800  -6.071  11.184  1.00 17.59           C  
ATOM    485  CG  ASP    51      41.726  -7.267  10.947  1.00 19.72           C  
ATOM    486  OD1 ASP    51      42.217  -7.479   9.811  1.00 20.29           O  
ATOM    487  OD2 ASP    51      41.972  -8.026  11.927  1.00 20.23           O  
ATOM    488  N   GLU    52      38.607  -4.071  10.242  1.00 16.99           N  
ATOM    489  CA  GLU    52      37.626  -3.062  10.649  1.00 16.56           C  
ATOM    490  C   GLU    52      36.385  -3.735  11.205  1.00 16.04           C  
ATOM    491  O   GLU    52      35.928  -4.744  10.655  1.00 16.25           O  
ATOM    492  CB  GLU    52      37.261  -2.210   9.428  1.00 17.33           C  
ATOM    493  CG  GLU    52      36.173  -1.163   9.732  1.00 16.96           C  
ATOM    494  CD  GLU    52      35.956  -0.161   8.605  1.00 20.76           C  
ATOM    495  OE1 GLU    52      36.723  -0.186   7.649  1.00 25.16           O  
ATOM    496  OE2 GLU    52      35.003   0.653   8.675  1.00 22.73           O  
ATOM    497  N   GLN    53      35.891  -3.230  12.338  1.00 15.29           N  
ATOM    498  CA  GLN    53      34.665  -3.780  12.905  1.00 15.57           C  
ATOM    499  C   GLN    53      33.520  -2.794  12.783  1.00 15.96           C  
ATOM    500  O   GLN    53      33.738  -1.562  12.838  1.00 16.46           O  
ATOM    501  CB  GLN    53      34.829  -4.170  14.375  1.00 16.29           C  
ATOM    502  CG  GLN    53      35.923  -5.262  14.568  1.00 16.43           C  
ATOM    503  CD  GLN    53      37.313  -4.679  14.546  1.00 16.79           C  
ATOM    504  OE1 GLN    53      37.608  -3.724  15.302  1.00 18.53           O  
ATOM    505  NE2 GLN    53      38.222  -5.243  13.706  1.00 17.69           N  
ATOM    506  N   PHE    54      32.304  -3.328  12.595  1.00 15.22           N  
ATOM    507  CA  PHE    54      31.127  -2.504  12.339  1.00 16.12           C  
ATOM    508  C   PHE    54      30.054  -2.893  13.333  1.00 16.75           C  
ATOM    509  O   PHE    54      29.820  -4.072  13.596  1.00 16.26           O  
ATOM    510  CB  PHE    54      30.589  -2.820  10.928  1.00 18.13           C  
ATOM    511  CG  PHE    54      31.582  -2.567   9.813  1.00 18.64           C  
ATOM    512  CD1 PHE    54      31.539  -1.357   9.108  1.00 23.57           C  
ATOM    513  CD2 PHE    54      32.565  -3.497   9.498  1.00 20.61           C  
ATOM    514  CE1 PHE    54      32.466  -1.122   8.039  1.00 23.85           C  
ATOM    515  CE2 PHE    54      33.469  -3.245   8.445  1.00 21.03           C  
ATOM    516  CZ  PHE    54      33.403  -2.103   7.732  1.00 23.10           C  
ATOM    517  N   ILE    55      29.342  -1.885  13.826  1.00 16.51           N  
ATOM    518  CA  ILE    55      28.284  -2.074  14.793  1.00 17.03           C  
ATOM    519  C   ILE    55      27.113  -1.256  14.344  1.00 17.63           C  
ATOM    520  O   ILE    55      27.219  -0.042  14.280  1.00 19.02           O  
ATOM    521  CB  ILE    55      28.722  -1.606  16.189  1.00 17.26           C  
ATOM    522  CG1 ILE    55      29.903  -2.450  16.650  1.00 19.11           C  
ATOM    523  CG2 ILE    55      27.555  -1.596  17.205  1.00 20.27           C  
ATOM    524  CD1 ILE    55      30.713  -1.812  17.871  1.00 21.34           C  
ATOM    525  N   LEU    56      25.977  -1.905  14.085  1.00 16.33           N  
ATOM    526  CA  LEU    56      24.747  -1.204  13.647  1.00 16.30           C  
ATOM    527  C   LEU    56      24.031  -0.642  14.872  1.00 18.33           C  
ATOM    528  O   LEU    56      23.734  -1.411  15.823  1.00 18.34           O  
ATOM    529  CB  LEU    56      23.830  -2.203  12.892  1.00 16.00           C  
ATOM    530  CG  LEU    56      22.516  -1.620  12.334  1.00 17.40           C  
ATOM    531  CD1 LEU    56      22.773  -0.483  11.297  1.00 17.23           C  
ATOM    532  CD2 LEU    56      21.728  -2.718  11.668  1.00 17.81           C  
ATOM    533  N   SER    57      23.668   0.645  14.801  1.00 16.83           N  
ATOM    534  CA  SER    57      22.992   1.328  15.912  1.00 17.51           C  
ATOM    535  C   SER    57      21.512   1.580  15.625  1.00 17.72           C  
ATOM    536  O   SER    57      20.643   1.305  16.491  1.00 19.77           O  
ATOM    537  CB  SER    57      23.699   2.672  16.203  1.00 18.26           C  
ATOM    538  OG  SER    57      23.076   3.279  17.342  1.00 19.31           O  
ATOM    539  N   ALA    58      21.206   2.078  14.435  1.00 17.62           N  
ATOM    540  CA  ALA    58      19.819   2.443  14.049  1.00 17.30           C  
ATOM    541  C   ALA    58      19.572   2.038  12.608  1.00 17.02           C  
ATOM    542  O   ALA    58      20.517   1.998  11.804  1.00 17.01           O  
ATOM    543  CB  ALA    58      19.608   3.979  14.147  1.00 18.83           C  
ATOM    544  N   GLY    59      18.307   1.766  12.274  1.00 17.28           N  
ATOM    545  CA  GLY    59      17.964   1.495  10.891  1.00 16.19           C  
ATOM    546  C   GLY    59      18.505   0.148  10.443  1.00 16.70           C  
ATOM    547  O   GLY    59      18.883  -0.706  11.262  1.00 18.82           O  
ATOM    548  N   LYS    60      18.516  -0.003   9.130  1.00 17.10           N  
ATOM    549  CA  LYS    60      18.939  -1.270   8.509  1.00 17.10           C  
ATOM    550  C   LYS    60      20.211  -1.057   7.731  1.00 16.91           C  
ATOM    551  O   LYS    60      20.491   0.048   7.223  1.00 17.29           O  
ATOM    552  CB  LYS    60      17.868  -1.789   7.539  1.00 17.78           C  
ATOM    553  CG  LYS    60      16.534  -2.132   8.176  1.00 19.75           C  
ATOM    554  CD  LYS    60      15.542  -2.331   7.033  1.00 23.56           C  
ATOM    555  CE  LYS    60      14.212  -2.731   7.566  1.00 28.36           C  
ATOM    556  NZ  LYS    60      13.370  -2.904   6.333  1.00 31.59           N  
ATOM    557  N   ALA    61      21.001  -2.123   7.606  1.00 16.77           N  
ATOM    558  CA  ALA    61      22.221  -2.028   6.802  1.00 16.67           C  
ATOM    559  C   ALA    61      22.629  -3.387   6.313  1.00 15.90           C  
ATOM    560  O   ALA    61      22.370  -4.390   6.973  1.00 16.52           O  
ATOM    561  CB  ALA    61      23.365  -1.431   7.605  1.00 17.21           C  
ATOM    562  N   ILE    62      23.253  -3.381   5.140  1.00 15.63           N  
ATOM    563  CA  ILE    62      23.855  -4.564   4.557  1.00 16.08           C  
ATOM    564  C   ILE    62      25.346  -4.326   4.359  1.00 16.56           C  
ATOM    565  O   ILE    62      25.774  -3.236   3.948  1.00 17.64           O  
ATOM    566  CB  ILE    62      23.180  -4.862   3.187  1.00 16.18           C  
ATOM    567  CG1 ILE    62      21.712  -5.258   3.409  1.00 16.39           C  
ATOM    568  CG2 ILE    62      23.914  -5.966   2.429  1.00 17.86           C  
ATOM    569  CD1 ILE    62      20.897  -5.187   2.113  1.00 18.67           C  
ATOM    570  N   LEU    63      26.139  -5.328   4.702  0.60 17.10           N  
ATOM    572  CA  LEU    63      27.582  -5.258   4.487  0.60 17.07           C  
ATOM    574  C   LEU    63      27.917  -6.113   3.262  0.60 17.18           C  
ATOM    576  O   LEU    63      27.628  -7.325   3.249  0.60 17.35           O  
ATOM    578  CB  LEU    63      28.314  -5.806   5.717  0.60 17.84           C  
ATOM    580  CG  LEU    63      29.835  -5.699   5.783  0.60 19.15           C  
ATOM    582  CD1 LEU    63      30.335  -4.263   5.645  0.60 20.68           C  
ATOM    584  CD2 LEU    63      30.261  -6.285   7.125  0.60 20.79           C  
ATOM    586  N   ILE    64      28.462  -5.489   2.213  1.00 17.14           N  
ATOM    587  CA  ILE    64      28.939  -6.178   1.043  1.00 17.08           C  
ATOM    588  C   ILE    64      30.369  -6.603   1.362  1.00 17.38           C  
ATOM    589  O   ILE    64      31.166  -5.790   1.854  1.00 17.79           O  
ATOM    590  CB  ILE    64      29.025  -5.221  -0.204  1.00 17.12           C  
ATOM    591  CG1 ILE    64      27.653  -4.600  -0.477  1.00 20.00           C  
ATOM    592  CG2 ILE    64      29.565  -5.973  -1.440  1.00 18.04           C  
ATOM    593  CD1 ILE    64      27.724  -3.368  -1.404  1.00 18.37           C  
ATOM    594  N   THR    65      30.692  -7.855   1.036  1.00 17.86           N  
ATOM    595  CA  THR    65      32.085  -8.292   1.054  1.00 18.12           C  
ATOM    596  C   THR    65      32.351  -8.962  -0.277  1.00 18.58           C  
ATOM    597  O   THR    65      31.426  -9.489  -0.913  1.00 19.44           O  
ATOM    598  CB  THR    65      32.442  -9.196   2.224  1.00 18.08           C  
ATOM    599  OG1 THR    65      31.489 -10.258   2.313  1.00 17.62           O  
ATOM    600  CG2 THR    65      32.480  -8.375   3.559  1.00 18.10           C  
ATOM    601  N   ALA    66      33.604  -8.910  -0.732  1.00 18.05           N  
ATOM    602  CA  ALA    66      33.887  -9.450  -2.064  1.00 19.25           C  
ATOM    603  C   ALA    66      35.328  -9.878  -2.199  1.00 20.53           C  
ATOM    604  O   ALA    66      36.212  -9.407  -1.476  1.00 19.89           O  
ATOM    605  CB  ALA    66      33.524  -8.414  -3.132  1.00 18.61           C  
ATOM    606  N   GLU    67      35.552 -10.810  -3.119  0.50 21.75           N  
ATOM    608  CA  GLU    67      36.905 -11.053  -3.604  0.50 23.27           C  
ATOM    610  C   GLU    67      36.961 -10.670  -5.072  0.50 23.78           C  
ATOM    612  O   GLU    67      35.966 -10.742  -5.801  0.50 23.10           O  
ATOM    614  CB  GLU    67      37.331 -12.510  -3.419  0.50 24.24           C  
ATOM    616  CG  GLU    67      36.394 -13.509  -4.035  0.50 24.63           C  
ATOM    618  CD  GLU    67      37.087 -14.820  -4.402  0.50 28.22           C  
ATOM    620  OE1 GLU    67      38.147 -15.137  -3.823  0.50 32.90           O  
ATOM    622  OE2 GLU    67      36.559 -15.533  -5.271  0.50 28.66           O  
ATOM    624  N   LYS    68      38.146 -10.272  -5.497  1.00 25.28           N  
ATOM    625  CA  LYS    68      38.360  -9.857  -6.863  1.00 28.72           C  
ATOM    626  C   LYS    68      39.027 -11.029  -7.554  1.00 32.09           C  
ATOM    627  O   LYS    68      40.039 -11.551  -7.074  1.00 31.54           O  
ATOM    628  CB  LYS    68      39.241  -8.601  -6.884  1.00 29.61           C  
ATOM    629  CG  LYS    68      39.108  -7.741  -8.117  1.00 31.87           C  
ATOM    630  CD  LYS    68      40.084  -6.600  -7.985  1.00 36.13           C  
ATOM    631  CE  LYS    68      39.622  -5.388  -8.724  1.00 38.28           C  
ATOM    632  NZ  LYS    68      40.805  -4.612  -9.152  1.00 39.70           N  
ATOM    633  N   GLU    69      38.424 -11.473  -8.649  1.00 35.03           N  
ATOM    634  CA  GLU    69      38.917 -12.620  -9.406  1.00 39.92           C  
ATOM    635  C   GLU    69      39.030 -12.134 -10.841  1.00 40.91           C  
ATOM    636  O   GLU    69      38.033 -11.714 -11.454  1.00 41.18           O  
ATOM    637  CB  GLU    69      37.931 -13.779  -9.292  1.00 39.88           C  
ATOM    638  CG  GLU    69      38.377 -15.100  -9.892  1.00 43.51           C  
ATOM    639  CD  GLU    69      37.375 -16.216  -9.594  1.00 44.52           C  
ATOM    640  OE1 GLU    69      36.155 -16.024  -9.860  1.00 48.99           O  
ATOM    641  OE2 GLU    69      37.811 -17.284  -9.089  1.00 51.23           O  
ATOM    642  N   ASN    70      40.251 -12.181 -11.367  1.00 42.55           N  
ATOM    643  CA  ASN    70      40.575 -11.491 -12.608  1.00 43.92           C  
ATOM    644  C   ASN    70      40.117 -10.034 -12.458  1.00 43.58           C  
ATOM    645  O   ASN    70      40.566  -9.346 -11.534  1.00 44.59           O  
ATOM    646  CB  ASN    70      39.956 -12.229 -13.798  1.00 44.78           C  
ATOM    647  CG  ASN    70      40.392 -13.702 -13.857  1.00 47.87           C  
ATOM    648  OD1 ASN    70      39.561 -14.621 -13.749  1.00 50.12           O  
ATOM    649  ND2 ASN    70      41.705 -13.928 -13.996  1.00 49.37           N  
ATOM    650  N   ASP    71      39.205  -9.566 -13.303  1.00 42.45           N  
ATOM    651  CA  ASP    71      38.738  -8.185 -13.157  1.00 40.43           C  
ATOM    652  C   ASP    71      37.290  -8.046 -12.683  1.00 37.49           C  
ATOM    653  O   ASP    71      36.686  -6.980 -12.864  1.00 38.69           O  
ATOM    654  CB  ASP    71      38.957  -7.396 -14.460  1.00 42.43           C  
ATOM    655  CG  ASP    71      40.191  -6.496 -14.398  1.00 45.99           C  
ATOM    656  OD1 ASP    71      40.131  -5.434 -13.716  1.00 49.92           O  
ATOM    657  OD2 ASP    71      41.221  -6.850 -15.031  1.00 50.27           O  
ATOM    658  N   LYS    72      36.767  -9.099 -12.049  0.50 35.27           N  
ATOM    660  CA  LYS    72      35.371  -9.161 -11.600  0.50 32.39           C  
ATOM    662  C   LYS    72      35.275  -9.506 -10.110  0.50 29.34           C  
ATOM    664  O   LYS    72      36.090 -10.275  -9.587  0.50 28.53           O  
ATOM    666  CB  LYS    72      34.591 -10.201 -12.415  0.50 33.11           C  
ATOM    668  CG  LYS    72      34.608  -9.996 -13.937  0.50 35.22           C  
ATOM    670  CD  LYS    72      33.882  -8.716 -14.352  0.50 38.16           C  
ATOM    672  CE  LYS    72      34.141  -8.381 -15.814  0.50 39.07           C  
ATOM    674  NZ  LYS    72      33.714  -6.985 -16.107  0.50 40.06           N  
ATOM    676  N   PHE    73      34.262  -8.964  -9.438  1.00 26.19           N  
ATOM    677  CA  PHE    73      34.074  -9.258  -8.021  1.00 23.01           C  
ATOM    678  C   PHE    73      33.128 -10.431  -7.845  1.00 22.56           C  
ATOM    679  O   PHE    73      32.081 -10.476  -8.500  1.00 23.23           O  
ATOM    680  CB  PHE    73      33.469  -8.031  -7.331  1.00 20.77           C  
ATOM    681  CG  PHE    73      34.463  -6.919  -7.084  1.00 21.12           C  
ATOM    682  CD1 PHE    73      35.500  -7.085  -6.160  1.00 19.24           C  
ATOM    683  CD2 PHE    73      34.334  -5.723  -7.758  1.00 21.62           C  
ATOM    684  CE1 PHE    73      36.375  -6.072  -5.895  1.00 21.26           C  
ATOM    685  CE2 PHE    73      35.228  -4.661  -7.503  1.00 22.84           C  
ATOM    686  CZ  PHE    73      36.266  -4.864  -6.584  1.00 21.71           C  
ATOM    687  N   ASN    74      33.495 -11.335  -6.947  1.00 21.12           N  
ATOM    688  CA  ASN    74      32.560 -12.346  -6.421  1.00 20.80           C  
ATOM    689  C   ASN    74      31.983 -11.719  -5.159  1.00 20.55           C  
ATOM    690  O   ASN    74      32.750 -11.406  -4.236  1.00 22.73           O  
ATOM    691  CB  ASN    74      33.309 -13.625  -6.086  1.00 20.81           C  
ATOM    692  CG  ASN    74      33.834 -14.312  -7.327  1.00 25.44           C  
ATOM    693  OD1 ASN    74      33.216 -14.214  -8.401  1.00 27.61           O  
ATOM    694  ND2 ASN    74      34.993 -14.981  -7.207  1.00 30.25           N  
ATOM    695  N   ILE    75      30.669 -11.539  -5.100  1.00 18.59           N  
ATOM    696  CA  ILE    75      30.034 -10.671  -4.091  1.00 18.13           C  
ATOM    697  C   ILE    75      29.212 -11.482  -3.061  1.00 19.08           C  
ATOM    698  O   ILE    75      28.517 -12.471  -3.419  1.00 20.00           O  
ATOM    699  CB  ILE    75      29.156  -9.640  -4.810  1.00 18.07           C  
ATOM    700  CG1 ILE    75      30.044  -8.658  -5.589  1.00 20.24           C  
ATOM    701  CG2 ILE    75      28.174  -8.940  -3.848  1.00 20.77           C  
ATOM    702  CD1 ILE    75      29.365  -8.065  -6.753  1.00 22.60           C  
ATOM    703  N   GLU    76      29.308 -11.084  -1.800  0.60 18.87           N  
ATOM    705  CA  GLU    76      28.466 -11.612  -0.735  0.60 19.16           C  
ATOM    707  C   GLU    76      27.745 -10.407  -0.128  0.60 18.09           C  
ATOM    709  O   GLU    76      28.305  -9.282  -0.057  0.60 17.76           O  
ATOM    711  CB  GLU    76      29.339 -12.289   0.332  0.60 20.14           C  
ATOM    713  CG  GLU    76      28.599 -12.731   1.582  0.60 23.37           C  
ATOM    715  CD  GLU    76      27.702 -13.942   1.355  0.60 29.19           C  
ATOM    717  OE1 GLU    76      27.747 -14.565   0.258  0.60 32.28           O  
ATOM    719  OE2 GLU    76      26.959 -14.270   2.308  0.60 32.34           O  
ATOM    721  N   LEU    77      26.507 -10.648   0.309  1.00 17.46           N  
ATOM    722  CA  LEU    77      25.737  -9.644   1.062  1.00 16.79           C  
ATOM    723  C   LEU    77      25.380 -10.220   2.405  1.00 17.12           C  
ATOM    724  O   LEU    77      24.908 -11.374   2.464  1.00 18.05           O  
ATOM    725  CB  LEU    77      24.444  -9.268   0.347  1.00 17.08           C  
ATOM    726  CG  LEU    77      24.616  -8.756  -1.076  1.00 19.68           C  
ATOM    727  CD1 LEU    77      23.246  -8.352  -1.603  1.00 21.69           C  
ATOM    728  CD2 LEU    77      25.579  -7.545  -1.129  1.00 20.67           C  
ATOM    729  N   THR    78      25.559  -9.426   3.459  1.00 16.43           N  
ATOM    730  CA  THR    78      25.221  -9.860   4.834  1.00 15.99           C  
ATOM    731  C   THR    78      24.328  -8.790   5.447  1.00 15.43           C  
ATOM    732  O   THR    78      24.749  -7.629   5.601  1.00 17.08           O  
ATOM    733  CB  THR    78      26.486  -9.986   5.646  1.00 18.10           C  
ATOM    734  OG1 THR    78      27.333 -10.990   5.038  1.00 18.81           O  
ATOM    735  CG2 THR    78      26.154 -10.425   7.078  1.00 19.52           C  
ATOM    736  N   LEU    79      23.096  -9.173   5.798  1.00 16.06           N  
ATOM    737  CA  LEU    79      22.203  -8.219   6.475  1.00 16.46           C  
ATOM    738  C   LEU    79      22.688  -8.061   7.930  1.00 16.23           C  
ATOM    739  O   LEU    79      22.753  -9.061   8.674  1.00 18.78           O  
ATOM    740  CB  LEU    79      20.763  -8.778   6.464  1.00 16.37           C  
ATOM    741  CG  LEU    79      19.661  -7.907   7.062  1.00 17.37           C  
ATOM    742  CD1 LEU    79      19.486  -6.552   6.335  1.00 17.46           C  
ATOM    743  CD2 LEU    79      18.339  -8.679   7.091  1.00 17.44           C  
ATOM    744  N   MET    80      23.043  -6.836   8.320  1.00 17.05           N  
ATOM    745  CA  MET    80      23.489  -6.622   9.699  1.00 17.35           C  
ATOM    746  C   MET    80      22.360  -6.683  10.705  1.00 17.54           C  
ATOM    747  O   MET    80      21.228  -6.227  10.449  1.00 17.87           O  
ATOM    748  CB  MET    80      24.216  -5.268   9.819  1.00 17.15           C  
ATOM    749  CG  MET    80      25.447  -5.249   9.025  1.00 18.39           C  
ATOM    750  SD  MET    80      26.260  -3.413   9.223  0.65 23.14          SE  
ATOM    751  CE  MET    80      27.062  -3.666  10.979  1.00 20.64           C  
ATOM    752  N   GLU    81      22.687  -7.257  11.866  0.60 18.87           N  
ATOM    754  CA  GLU    81      21.777  -7.318  12.996  0.60 20.00           C  
ATOM    756  C   GLU    81      22.268  -6.434  14.122  0.60 18.60           C  
ATOM    758  O   GLU    81      23.461  -6.432  14.462  0.60 18.57           O  
ATOM    760  CB  GLU    81      21.696  -8.754  13.501  0.60 19.45           C  
ATOM    762  CG  GLU    81      21.101  -9.688  12.452  0.60 22.13           C  
ATOM    764  CD  GLU    81      21.019 -11.157  12.881  0.60 24.43           C  
ATOM    766  OE1 GLU    81      20.800 -11.435  14.084  0.60 29.15           O  
ATOM    768  OE2 GLU    81      21.169 -12.041  12.000  0.60 30.97           O  
ATOM    770  N   LYS    82      21.350  -5.682  14.714  0.60 18.42           N  
ATOM    772  CA  LYS    82      21.673  -4.932  15.912  0.60 18.51           C  
ATOM    774  C   LYS    82      21.959  -5.956  17.026  0.60 18.11           C  
ATOM    776  O   LYS    82      21.220  -6.944  17.204  0.60 18.72           O  
ATOM    778  CB  LYS    82      20.511  -4.024  16.313  0.60 18.81           C  
ATOM    780  CG  LYS    82      20.367  -2.809  15.416  0.60 18.90           C  
ATOM    782  CD  LYS    82      19.161  -1.970  15.834  0.60 20.64           C  
ATOM    784  CE  LYS    82      18.782  -1.014  14.727  0.60 21.42           C  
ATOM    786  NZ  LYS    82      18.024  -1.683  13.641  0.60 23.36           N  
ATOM    788  N   GLY    83      23.046  -5.688  17.747  1.00 17.31           N  
ATOM    789  CA  GLY    83      23.527  -6.516  18.854  1.00 17.58           C  
ATOM    790  C   GLY    83      24.740  -7.351  18.496  1.00 17.40           C  
ATOM    791  O   GLY    83      25.387  -7.936  19.376  1.00 18.34           O  
ATOM    792  N   LYS    84      25.042  -7.417  17.207  1.00 16.76           N  
ATOM    793  CA  LYS    84      26.235  -8.150  16.738  1.00 16.39           C  
ATOM    794  C   LYS    84      27.368  -7.205  16.328  1.00 16.76           C  
ATOM    795  O   LYS    84      27.148  -5.985  16.124  1.00 18.19           O  
ATOM    796  CB  LYS    84      25.878  -9.082  15.566  1.00 17.48           C  
ATOM    797  CG  LYS    84      24.850 -10.156  15.982  1.00 18.67           C  
ATOM    798  CD  LYS    84      24.706 -11.195  14.880  1.00 22.19           C  
ATOM    799  CE  LYS    84      23.681 -12.239  15.269  1.00 28.66           C  
ATOM    800  NZ  LYS    84      23.635 -13.207  14.106  1.00 32.70           N  
ATOM    801  N   VAL    85      28.578  -7.780  16.255  1.00 16.21           N  
ATOM    802  CA  VAL    85      29.724  -7.040  15.762  1.00 15.81           C  
ATOM    803  C   VAL    85      30.213  -7.783  14.514  1.00 16.70           C  
ATOM    804  O   VAL    85      30.260  -9.029  14.520  1.00 17.45           O  
ATOM    805  CB  VAL    85      30.846  -6.992  16.798  1.00 16.74           C  
ATOM    806  CG1 VAL    85      32.078  -6.270  16.245  1.00 17.88           C  
ATOM    807  CG2 VAL    85      30.371  -6.241  18.061  1.00 17.90           C  
ATOM    808  N   TYR    86      30.536  -7.031  13.450  1.00 15.64           N  
ATOM    809  CA  TYR    86      31.005  -7.610  12.178  1.00 17.07           C  
ATOM    810  C   TYR    86      32.428  -7.196  11.980  1.00 17.74           C  
ATOM    811  O   TYR    86      32.784  -6.042  12.192  1.00 18.97           O  
ATOM    812  CB  TYR    86      30.128  -7.093  11.010  1.00 16.66           C  
ATOM    813  CG  TYR    86      28.709  -7.580  11.209  1.00 15.88           C  
ATOM    814  CD1 TYR    86      28.249  -8.706  10.552  1.00 16.34           C  
ATOM    815  CD2 TYR    86      27.809  -6.907  12.072  1.00 16.28           C  
ATOM    816  CE1 TYR    86      26.958  -9.193  10.759  1.00 14.73           C  
ATOM    817  CE2 TYR    86      26.521  -7.416  12.280  1.00 15.61           C  
ATOM    818  CZ  TYR    86      26.114  -8.585  11.633  1.00 14.83           C  
ATOM    819  OH  TYR    86      24.834  -9.091  11.844  1.00 17.74           O  
ATOM    820  N   ASN    87      33.252  -8.143  11.539  1.00 16.15           N  
ATOM    821  CA  ASN    87      34.647  -7.813  11.249  1.00 16.28           C  
ATOM    822  C   ASN    87      34.967  -8.085   9.791  1.00 16.88           C  
ATOM    823  O   ASN    87      34.703  -9.187   9.297  1.00 16.54           O  
ATOM    824  CB  ASN    87      35.566  -8.680  12.140  1.00 16.99           C  
ATOM    825  CG  ASN    87      37.049  -8.507  11.803  1.00 18.96           C  
ATOM    826  OD1 ASN    87      37.591  -7.425  11.920  1.00 17.98           O  
ATOM    827  ND2 ASN    87      37.712  -9.592  11.402  1.00 18.13           N  
ATOM    828  N   VAL    88      35.546  -7.085   9.132  1.00 16.41           N  
ATOM    829  CA  VAL    88      36.085  -7.245   7.770  1.00 16.80           C  
ATOM    830  C   VAL    88      37.602  -7.279   7.914  1.00 17.60           C  
ATOM    831  O   VAL    88      38.200  -6.260   8.236  1.00 16.72           O  
ATOM    832  CB  VAL    88      35.655  -6.066   6.852  1.00 16.61           C  
ATOM    833  CG1 VAL    88      36.350  -6.207   5.486  1.00 17.54           C  
ATOM    834  CG2 VAL    88      34.145  -6.101   6.660  1.00 18.60           C  
ATOM    835  N   PRO    89      38.226  -8.441   7.691  1.00 17.46           N  
ATOM    836  CA  PRO    89      39.693  -8.472   7.841  1.00 18.21           C  
ATOM    837  C   PRO    89      40.371  -7.648   6.736  1.00 17.75           C  
ATOM    838  O   PRO    89      39.796  -7.459   5.639  1.00 17.90           O  
ATOM    839  CB  PRO    89      40.068  -9.953   7.641  1.00 19.26           C  
ATOM    840  CG  PRO    89      38.811 -10.684   7.578  1.00 22.10           C  
ATOM    841  CD  PRO    89      37.644  -9.760   7.350  1.00 19.36           C  
ATOM    842  N   ALA    90      41.602  -7.223   7.002  1.00 17.81           N  
ATOM    843  CA  ALA    90      42.410  -6.568   5.984  1.00 17.60           C  
ATOM    844  C   ALA    90      42.467  -7.417   4.715  1.00 17.75           C  
ATOM    845  O   ALA    90      42.462  -8.685   4.788  1.00 18.42           O  
ATOM    846  CB  ALA    90      43.820  -6.416   6.507  1.00 17.36           C  
ATOM    847  N   GLU    91      42.491  -6.715   3.575  1.00 17.80           N  
ATOM    848  CA  GLU    91      42.560  -7.340   2.249  1.00 19.04           C  
ATOM    849  C   GLU    91      41.258  -7.999   1.794  1.00 19.36           C  
ATOM    850  O   GLU    91      41.232  -8.778   0.813  1.00 21.60           O  
ATOM    851  CB  GLU    91      43.726  -8.338   2.133  1.00 19.33           C  
ATOM    852  CG  GLU    91      45.078  -7.770   2.532  1.00 21.26           C  
ATOM    853  CD  GLU    91      45.639  -6.748   1.523  1.00 23.31           C  
ATOM    854  OE1 GLU    91      44.913  -6.288   0.616  1.00 24.66           O  
ATOM    855  OE2 GLU    91      46.819  -6.375   1.678  1.00 27.27           O  
ATOM    856  N   CYS    92      40.167  -7.659   2.459  1.00 19.41           N  
ATOM    857  CA  CYS    92      38.849  -8.089   2.002  1.00 18.30           C  
ATOM    858  C   CYS    92      38.121  -6.846   1.474  1.00 17.59           C  
ATOM    859  O   CYS    92      37.976  -5.859   2.211  1.00 18.82           O  
ATOM    860  CB  CYS    92      38.069  -8.689   3.170  1.00 18.57           C  
ATOM    861  SG  CYS    92      36.398  -9.298   2.672  1.00 22.65           S  
ATOM    862  N   TRP    93      37.619  -6.904   0.239  1.00 16.71           N  
ATOM    863  CA  TRP    93      36.846  -5.767  -0.287  1.00 16.83           C  
ATOM    864  C   TRP    93      35.498  -5.678   0.429  1.00 17.61           C  
ATOM    865  O   TRP    93      34.892  -6.700   0.734  1.00 17.54           O  
ATOM    866  CB  TRP    93      36.578  -6.006  -1.784  1.00 17.22           C  
ATOM    867  CG  TRP    93      37.800  -5.880  -2.605  1.00 17.28           C  
ATOM    868  CD1 TRP    93      38.625  -6.899  -3.028  1.00 18.03           C  
ATOM    869  CD2 TRP    93      38.359  -4.657  -3.124  1.00 17.06           C  
ATOM    870  NE1 TRP    93      39.685  -6.363  -3.791  1.00 18.99           N  
ATOM    871  CE2 TRP    93      39.519  -5.001  -3.878  1.00 19.05           C  
ATOM    872  CE3 TRP    93      37.968  -3.311  -3.050  1.00 18.33           C  
ATOM    873  CZ2 TRP    93      40.312  -4.031  -4.522  1.00 18.83           C  
ATOM    874  CZ3 TRP    93      38.772  -2.329  -3.662  1.00 18.94           C  
ATOM    875  CH2 TRP    93      39.942  -2.697  -4.389  1.00 17.89           C  
ATOM    876  N   PHE    94      35.015  -4.463   0.670  1.00 16.25           N  
ATOM    877  CA  PHE    94      33.733  -4.347   1.367  1.00 16.00           C  
ATOM    878  C   PHE    94      33.103  -3.013   1.053  1.00 16.50           C  
ATOM    879  O   PHE    94      33.760  -2.078   0.536  1.00 16.78           O  
ATOM    880  CB  PHE    94      33.967  -4.407   2.892  1.00 16.42           C  
ATOM    881  CG  PHE    94      34.644  -3.171   3.432  1.00 15.99           C  
ATOM    882  CD1 PHE    94      33.879  -2.105   4.005  1.00 17.05           C  
ATOM    883  CD2 PHE    94      36.019  -3.046   3.357  1.00 18.78           C  
ATOM    884  CE1 PHE    94      34.525  -0.935   4.439  1.00 16.59           C  
ATOM    885  CE2 PHE    94      36.676  -1.882   3.776  1.00 17.42           C  
ATOM    886  CZ  PHE    94      35.928  -0.838   4.327  1.00 17.25           C  
ATOM    887  N   TYR    95      31.823  -2.894   1.409  1.00 16.04           N  
ATOM    888  CA  TYR    95      31.191  -1.568   1.498  1.00 17.12           C  
ATOM    889  C   TYR    95      29.856  -1.764   2.171  1.00 17.96           C  
ATOM    890  O   TYR    95      29.424  -2.879   2.367  1.00 20.58           O  
ATOM    891  CB  TYR    95      30.998  -0.895   0.113  1.00 18.45           C  
ATOM    892  CG  TYR    95      31.337   0.580   0.122  1.00 18.66           C  
ATOM    893  CD1 TYR    95      32.587   0.990   0.570  1.00 19.74           C  
ATOM    894  CD2 TYR    95      30.402   1.534  -0.287  1.00 19.52           C  
ATOM    895  CE1 TYR    95      32.943   2.365   0.605  1.00 19.65           C  
ATOM    896  CE2 TYR    95      30.732   2.907  -0.250  1.00 18.72           C  
ATOM    897  CZ  TYR    95      31.999   3.288   0.206  1.00 20.62           C  
ATOM    898  OH  TYR    95      32.344   4.665   0.229  1.00 22.21           O  
ATOM    899  N   SER    96      29.203  -0.670   2.536  0.60 17.85           N  
ATOM    901  CA  SER    96      27.903  -0.753   3.193  0.60 17.20           C  
ATOM    903  C   SER    96      26.789  -0.333   2.243  0.60 17.09           C  
ATOM    905  O   SER    96      26.997   0.501   1.358  0.60 17.78           O  
ATOM    907  CB  SER    96      27.841   0.244   4.360  0.60 17.61           C  
ATOM    909  OG  SER    96      28.810  -0.014   5.351  0.60 17.19           O  
ATOM    911  N   ILE    97      25.591  -0.868   2.483  1.00 16.44           N  
ATOM    912  CA  ILE    97      24.354  -0.321   1.901  1.00 16.59           C  
ATOM    913  C   ILE    97      23.466   0.075   3.073  1.00 16.37           C  
ATOM    914  O   ILE    97      23.232  -0.712   3.980  1.00 16.97           O  
ATOM    915  CB  ILE    97      23.598  -1.358   1.079  1.00 16.73           C  
ATOM    916  CG1 ILE    97      24.576  -2.160   0.227  1.00 18.48           C  
ATOM    917  CG2 ILE    97      22.560  -0.652   0.174  1.00 16.97           C  
ATOM    918  CD1 ILE    97      23.902  -3.326  -0.606  1.00 17.80           C  
ATOM    919  N   THR    98      23.017   1.331   3.080  1.00 15.49           N  
ATOM    920  CA  THR    98      22.286   1.859   4.223  1.00 16.39           C  
ATOM    921  C   THR    98      21.072   2.651   3.774  1.00 16.27           C  
ATOM    922  O   THR    98      20.908   2.874   2.568  1.00 17.78           O  
ATOM    923  CB  THR    98      23.211   2.765   5.097  1.00 16.82           C  
ATOM    924  OG1 THR    98      23.608   3.912   4.341  1.00 17.49           O  
ATOM    925  CG2 THR    98      24.464   2.014   5.498  1.00 16.73           C  
ATOM    926  N   GLN    99      20.236   3.037   4.733  1.00 16.84           N  
ATOM    927  CA  GLN    99      19.023   3.786   4.445  1.00 17.55           C  
ATOM    928  C   GLN    99      19.118   5.115   5.158  1.00 17.89           C  
ATOM    929  O   GLN    99      20.071   5.344   5.952  1.00 17.09           O  
ATOM    930  CB  GLN    99      17.817   2.960   4.903  1.00 17.09           C  
ATOM    931  CG  GLN    99      17.684   1.680   4.073  1.00 19.07           C  
ATOM    932  CD  GLN    99      16.368   0.929   4.356  1.00 17.48           C  
ATOM    933  OE1 GLN    99      15.827   0.962   5.462  1.00 19.87           O  
ATOM    934  NE2 GLN    99      15.842   0.280   3.318  1.00 20.07           N  
ATOM    935  N   LYS   100      18.167   6.016   4.869  1.00 18.24           N  
ATOM    936  CA  LYS   100      18.372   7.390   5.328  1.00 19.40           C  
ATOM    937  C   LYS   100      18.445   7.522   6.839  1.00 18.81           C  
ATOM    938  O   LYS   100      19.093   8.459   7.347  1.00 20.39           O  
ATOM    939  CB  LYS   100      17.344   8.344   4.722  1.00 20.14           C  
ATOM    940  CG  LYS   100      17.807   8.722   3.296  1.00 25.10           C  
ATOM    941  CD  LYS   100      17.413  10.126   2.880  1.00 35.39           C  
ATOM    942  CE  LYS   100      17.894  10.393   1.474  1.00 37.85           C  
ATOM    943  NZ  LYS   100      17.334   9.340   0.590  1.00 43.07           N  
ATOM    944  N   ASP   101      17.819   6.596   7.562  1.00 18.77           N  
ATOM    945  CA  ASP   101      17.849   6.637   9.032  1.00 18.97           C  
ATOM    946  C   ASP   101      18.862   5.684   9.673  1.00 19.71           C  
ATOM    947  O   ASP   101      18.846   5.468  10.885  1.00 20.13           O  
ATOM    948  CB  ASP   101      16.470   6.352   9.623  1.00 21.14           C  
ATOM    949  CG  ASP   101      15.902   5.004   9.206  1.00 24.80           C  
ATOM    950  OD1 ASP   101      16.414   4.346   8.270  1.00 24.17           O  
ATOM    951  OD2 ASP   101      14.860   4.613   9.808  1.00 30.33           O  
ATOM    952  N   THR   102      19.724   5.102   8.860  1.00 17.06           N  
ATOM    953  CA  THR   102      20.753   4.177   9.371  1.00 17.20           C  
ATOM    954  C   THR   102      21.889   4.902  10.090  1.00 17.58           C  
ATOM    955  O   THR   102      22.381   5.936   9.603  1.00 17.93           O  
ATOM    956  CB  THR   102      21.326   3.378   8.205  1.00 16.57           C  
ATOM    957  OG1 THR   102      20.262   2.654   7.559  1.00 17.53           O  
ATOM    958  CG2 THR   102      22.397   2.359   8.701  1.00 16.80           C  
ATOM    959  N   LYS   103      22.363   4.314  11.198  1.00 17.25           N  
ATOM    960  CA  LYS   103      23.555   4.803  11.872  1.00 16.04           C  
ATOM    961  C   LYS   103      24.375   3.590  12.301  1.00 17.48           C  
ATOM    962  O   LYS   103      23.787   2.647  12.869  1.00 17.08           O  
ATOM    963  CB  LYS   103      23.136   5.585  13.113  1.00 17.08           C  
ATOM    964  CG  LYS   103      24.323   6.281  13.816  1.00 18.18           C  
ATOM    965  CD  LYS   103      23.881   7.037  15.083  1.00 17.54           C  
ATOM    966  CE  LYS   103      22.969   8.210  14.792  1.00 17.74           C  
ATOM    967  NZ  LYS   103      23.675   9.408  14.151  1.00 17.79           N  
ATOM    968  N   MET   104      25.674   3.601  12.015  1.00 16.61           N  
ATOM    969  CA  MET   104      26.548   2.545  12.515  1.00 18.76           C  
ATOM    970  C   MET   104      27.829   3.126  13.028  1.00 18.07           C  
ATOM    971  O   MET   104      28.140   4.287  12.750  1.00 18.20           O  
ATOM    972  CB  MET   104      26.832   1.498  11.444  1.00 21.04           C  
ATOM    973  CG  MET   104      27.693   1.995  10.381  1.00 20.27           C  
ATOM    974  SD  MET   104      28.064   0.469   9.085  0.65 25.94          SE  
ATOM    975  CE  MET   104      26.490   0.644   8.340  1.00 12.83           C  
ATOM    976  N   MET   105      28.546   2.355  13.841  1.00 16.39           N  
ATOM    977  CA  MET   105      29.865   2.791  14.274  1.00 16.00           C  
ATOM    978  C   MET   105      30.870   1.843  13.689  1.00 16.24           C  
ATOM    979  O   MET   105      30.551   0.676  13.404  1.00 16.92           O  
ATOM    980  CB  MET   105      29.987   2.739  15.796  1.00 17.84           C  
ATOM    981  CG  MET   105      29.272   3.873  16.539  1.00 18.81           C  
ATOM    982  SD  MET   105      27.305   3.624  16.437  0.65 22.03          SE  
ATOM    983  CE  MET   105      26.852   4.856  17.895  1.00 19.82           C  
ATOM    984  N   TYR   106      32.079   2.338  13.459  1.00 15.94           N  
ATOM    985  CA  TYR   106      33.147   1.409  13.065  1.00 15.84           C  
ATOM    986  C   TYR   106      34.440   1.718  13.784  1.00 16.88           C  
ATOM    987  O   TYR   106      34.627   2.835  14.304  1.00 15.69           O  
ATOM    988  CB  TYR   106      33.333   1.386  11.548  1.00 17.37           C  
ATOM    989  CG  TYR   106      33.900   2.623  10.865  1.00 17.47           C  
ATOM    990  CD1 TYR   106      35.261   2.903  10.902  1.00 18.62           C  
ATOM    991  CD2 TYR   106      33.066   3.437  10.077  1.00 18.38           C  
ATOM    992  CE1 TYR   106      35.818   4.006  10.169  1.00 19.35           C  
ATOM    993  CE2 TYR   106      33.586   4.511   9.358  1.00 18.20           C  
ATOM    994  CZ  TYR   106      34.954   4.774   9.397  1.00 18.96           C  
ATOM    995  OH  TYR   106      35.485   5.823   8.665  1.00 20.37           O  
ATOM    996  N   VAL   107      35.269   0.673  13.871  1.00 16.69           N  
ATOM    997  CA  VAL   107      36.543   0.737  14.570  1.00 16.04           C  
ATOM    998  C   VAL   107      37.608   0.241  13.612  1.00 17.16           C  
ATOM    999  O   VAL   107      37.430  -0.776  12.944  1.00 16.81           O  
ATOM   1000  CB  VAL   107      36.533  -0.180  15.832  1.00 17.67           C  
ATOM   1001  CG1 VAL   107      37.847   0.002  16.625  1.00 17.38           C  
ATOM   1002  CG2 VAL   107      35.345   0.191  16.747  1.00 17.95           C  
ATOM   1003  N   GLN   108      38.702   0.982  13.518  1.00 17.82           N  
ATOM   1004  CA  GLN   108      39.866   0.519  12.703  1.00 18.01           C  
ATOM   1005  C   GLN   108      41.167   1.158  13.236  1.00 16.91           C  
ATOM   1006  O   GLN   108      41.138   1.936  14.171  1.00 17.32           O  
ATOM   1007  CB  GLN   108      39.712   0.894  11.213  1.00 18.57           C  
ATOM   1008  CG  GLN   108      39.699   2.410  11.035  1.00 19.50           C  
ATOM   1009  CD  GLN   108      39.527   2.873   9.607  1.00 24.12           C  
ATOM   1010  OE1 GLN   108      38.629   2.410   8.870  1.00 30.18           O  
ATOM   1011  NE2 GLN   108      40.376   3.781   9.213  1.00 32.65           N  
ATOM   1012  N   ASP   109      42.305   0.823  12.617  1.00 17.22           N  
ATOM   1013  CA  ASP   109      43.601   1.346  13.028  1.00 18.82           C  
ATOM   1014  C   ASP   109      43.622   2.853  12.801  1.00 20.82           C  
ATOM   1015  O   ASP   109      43.022   3.345  11.842  1.00 22.83           O  
ATOM   1016  CB  ASP   109      44.669   0.676  12.150  1.00 18.66           C  
ATOM   1017  CG  ASP   109      46.071   0.895  12.683  1.00 22.39           C  
ATOM   1018  OD1 ASP   109      46.557   2.062  12.669  1.00 24.76           O  
ATOM   1019  OD2 ASP   109      46.684  -0.113  13.066  1.00 24.55           O  
ATOM   1020  N   SER   110      44.262   3.596  13.694  1.00 21.00           N  
ATOM   1021  CA  SER   110      44.244   5.067  13.586  1.00 22.62           C  
ATOM   1022  C   SER   110      45.081   5.605  12.462  1.00 25.40           C  
ATOM   1023  O   SER   110      44.986   6.794  12.130  1.00 26.13           O  
ATOM   1024  CB  SER   110      44.637   5.744  14.889  1.00 22.48           C  
ATOM   1025  OG  SER   110      45.889   5.282  15.300  1.00 22.98           O  
ATOM   1026  N   ASN   111      45.892   4.759  11.841  0.50 26.61           N  
ATOM   1028  CA  ASN   111      46.619   5.173  10.626  0.50 29.51           C  
ATOM   1030  C   ASN   111      45.681   5.102   9.410  0.50 30.95           C  
ATOM   1032  O   ASN   111      45.748   4.156   8.625  0.50 32.22           O  
ATOM   1034  CB  ASN   111      47.838   4.276  10.385  0.50 29.55           C  
ATOM   1036  CG  ASN   111      48.726   4.132  11.602  0.50 31.43           C  
ATOM   1038  OD1 ASN   111      49.072   5.116  12.262  0.50 34.49           O  
ATOM   1040  ND2 ASN   111      49.124   2.894  11.894  0.50 34.01           N  
ATOM   1042  N   CYS   112      44.802   6.099   9.277  0.70 31.56           N  
ATOM   1043  CA  CYS   112      43.714   6.121   8.291  0.70 33.74           C  
ATOM   1044  C   CYS   112      44.025   6.946   7.039  0.70 35.48           C  
ATOM   1045  O   CYS   112      43.115   7.492   6.392  0.70 36.54           O  
ATOM   1046  CB  CYS   112      42.421   6.617   8.949  0.70 34.26           C  
ATOM   1047  SG  CYS   112      42.624   8.239   9.688  0.70 38.38           S  
ATOM   1048  N   SER   113      45.304   7.035   6.682  0.80 36.18           N  
ATOM   1049  CA  SER   113      45.657   7.515   5.355  0.80 37.26           C  
ATOM   1050  C   SER   113      45.138   6.506   4.323  0.80 37.37           C  
ATOM   1051  O   SER   113      45.038   5.311   4.592  0.80 38.31           O  
ATOM   1052  CB  SER   113      47.163   7.671   5.215  0.80 37.70           C  
ATOM   1053  OG  SER   113      47.763   6.406   5.045  0.80 40.92           O  
ATOM   1054  N   MET   114      44.784   7.001   3.147  1.00 36.61           N  
ATOM   1055  CA  MET   114      44.471   6.162   2.011  1.00 33.90           C  
ATOM   1056  C   MET   114      45.735   5.618   1.356  1.00 32.87           C  
ATOM   1057  O   MET   114      45.671   4.991   0.303  1.00 33.52           O  
ATOM   1058  CB  MET   114      43.673   6.968   0.992  1.00 34.29           C  
ATOM   1059  CG  MET   114      42.287   7.333   1.490  1.00 32.36           C  
ATOM   1060  SD  MET   114      41.175   5.772   1.643  0.55 31.57          SE  
ATOM   1061  CE  MET   114      41.516   4.865  -0.033  1.00 33.03           C  
ATOM   1062  N   ASP   115      46.893   5.872   1.969  1.00 30.98           N  
ATOM   1063  CA  ASP   115      48.127   5.247   1.531  1.00 29.39           C  
ATOM   1064  C   ASP   115      48.030   3.732   1.565  1.00 27.19           C  
ATOM   1065  O   ASP   115      48.696   3.061   0.786  1.00 28.38           O  
ATOM   1066  CB  ASP   115      49.284   5.647   2.457  1.00 31.04           C  
ATOM   1067  CG  ASP   115      49.683   7.106   2.301  1.00 36.35           C  
ATOM   1068  OD1 ASP   115      49.629   7.607   1.145  1.00 42.16           O  
ATOM   1069  OD2 ASP   115      50.065   7.734   3.328  1.00 40.44           O  
ATOM   1070  N   ASN   116      47.228   3.197   2.488  0.50 25.45           N  
ATOM   1072  CA  ASN   116      47.176   1.750   2.681  0.50 24.21           C  
ATOM   1074  C   ASN   116      45.799   1.164   2.389  0.50 22.98           C  
ATOM   1076  O   ASN   116      45.516   0.045   2.797  0.50 22.33           O  
ATOM   1078  CB  ASN   116      47.592   1.358   4.104  0.50 25.01           C  
ATOM   1080  CG  ASN   116      48.980   1.834   4.465  0.50 26.25           C  
ATOM   1082  OD1 ASN   116      49.848   1.970   3.602  0.50 30.22           O  
ATOM   1084  ND2 ASN   116      49.197   2.086   5.746  0.50 29.34           N  
ATOM   1086  N   SER   117      44.963   1.933   1.689  1.00 21.10           N  
ATOM   1087  CA  SER   117      43.626   1.481   1.305  1.00 20.32           C  
ATOM   1088  C   SER   117      43.373   1.845  -0.159  1.00 20.03           C  
ATOM   1089  O   SER   117      44.116   2.635  -0.762  1.00 21.17           O  
ATOM   1090  CB  SER   117      42.552   2.095   2.202  1.00 20.76           C  
ATOM   1091  OG  SER   117      42.802   1.844   3.590  1.00 22.22           O  
ATOM   1092  N   ASP   118      42.327   1.281  -0.746  1.00 18.98           N  
ATOM   1093  CA  ASP   118      41.985   1.582  -2.128  1.00 18.98           C  
ATOM   1094  C   ASP   118      40.481   1.476  -2.334  1.00 17.82           C  
ATOM   1095  O   ASP   118      39.797   0.823  -1.529  1.00 18.84           O  
ATOM   1096  CB  ASP   118      42.653   0.597  -3.081  1.00 18.47           C  
ATOM   1097  CG  ASP   118      44.134   0.915  -3.329  1.00 23.99           C  
ATOM   1098  OD1 ASP   118      44.418   1.937  -4.000  1.00 25.51           O  
ATOM   1099  OD2 ASP   118      44.999   0.142  -2.847  1.00 24.80           O  
ATOM   1100  N   PHE   119      39.976   2.113  -3.390  1.00 16.98           N  
ATOM   1101  CA  PHE   119      38.613   1.890  -3.870  1.00 17.39           C  
ATOM   1102  C   PHE   119      38.675   1.277  -5.266  1.00 17.52           C  
ATOM   1103  O   PHE   119      39.670   1.445  -5.981  1.00 17.46           O  
ATOM   1104  CB  PHE   119      37.807   3.196  -3.976  1.00 18.11           C  
ATOM   1105  CG  PHE   119      37.442   3.782  -2.642  1.00 17.20           C  
ATOM   1106  CD1 PHE   119      36.241   3.464  -2.011  1.00 17.33           C  
ATOM   1107  CD2 PHE   119      38.331   4.662  -2.005  1.00 19.04           C  
ATOM   1108  CE1 PHE   119      35.939   4.024  -0.751  1.00 20.51           C  
ATOM   1109  CE2 PHE   119      38.034   5.201  -0.745  1.00 20.22           C  
ATOM   1110  CZ  PHE   119      36.845   4.895  -0.135  1.00 20.12           C  
ATOM   1111  N   CYS   120      37.628   0.572  -5.670  1.00 17.45           N  
ATOM   1112  CA  CYS   120      37.555   0.047  -7.026  1.00 17.73           C  
ATOM   1113  C   CYS   120      36.106   0.087  -7.475  1.00 18.47           C  
ATOM   1114  O   CYS   120      35.201  -0.272  -6.689  1.00 17.83           O  
ATOM   1115  CB  CYS   120      38.089  -1.401  -7.045  1.00 18.30           C  
ATOM   1116  SG  CYS   120      38.102  -2.100  -8.702  0.85 21.04           S  
ATOM   1117  N   ASP   121      35.859   0.534  -8.706  1.00 18.02           N  
ATOM   1118  CA  ASP   121      34.503   0.578  -9.212  1.00 18.36           C  
ATOM   1119  C   ASP   121      33.919  -0.819  -9.406  1.00 19.09           C  
ATOM   1120  O   ASP   121      34.624  -1.758  -9.800  1.00 20.85           O  
ATOM   1121  CB  ASP   121      34.500   1.247 -10.587  1.00 18.48           C  
ATOM   1122  CG  ASP   121      34.724   2.753 -10.529  1.00 22.48           C  
ATOM   1123  OD1 ASP   121      34.777   3.377  -9.432  1.00 23.19           O  
ATOM   1124  OD2 ASP   121      34.794   3.308 -11.654  1.00 24.90           O  
ATOM   1125  N   LEU   122      32.619  -0.916  -9.181  1.00 18.88           N  
ATOM   1126  CA  LEU   122      31.864  -2.076  -9.555  1.00 19.10           C  
ATOM   1127  C   LEU   122      31.440  -1.902 -11.008  1.00 20.26           C  
ATOM   1128  O   LEU   122      31.216  -0.778 -11.467  1.00 21.26           O  
ATOM   1129  CB  LEU   122      30.615  -2.141  -8.682  1.00 19.71           C  
ATOM   1130  CG  LEU   122      30.854  -2.431  -7.195  1.00 18.36           C  
ATOM   1131  CD1 LEU   122      29.620  -2.013  -6.392  1.00 20.58           C  
ATOM   1132  CD2 LEU   122      31.061  -3.930  -7.010  1.00 21.72           C  
ATOM   1133  N   SER   123      31.288  -3.024 -11.710  1.00 20.30           N  
ATOM   1134  CA  SER   123      30.757  -2.964 -13.084  1.00 21.25           C  
ATOM   1135  C   SER   123      29.244  -2.686 -13.056  1.00 21.59           C  
ATOM   1136  O   SER   123      28.599  -2.828 -11.995  1.00 20.17           O  
ATOM   1137  CB  SER   123      30.982  -4.316 -13.769  1.00 21.57           C  
ATOM   1138  OG  SER   123      30.121  -5.293 -13.208  1.00 21.76           O  
ATOM   1139  N   LYS   124      28.651  -2.482 -14.240  0.50 21.41           N  
ATOM   1141  CA  LYS   124      27.189  -2.349 -14.367  0.50 22.09           C  
ATOM   1143  C   LYS   124      26.407  -3.585 -13.913  0.50 20.42           C  
ATOM   1145  O   LYS   124      25.404  -3.454 -13.193  0.50 19.79           O  
ATOM   1147  CB  LYS   124      26.775  -1.962 -15.804  0.50 22.57           C  
ATOM   1149  CG  LYS   124      25.663  -0.888 -15.824  0.50 25.93           C  
ATOM   1151  CD  LYS   124      25.184  -0.523 -17.241  0.50 25.36           C  
ATOM   1153  CE  LYS   124      26.129   0.427 -17.981  0.50 30.01           C  
ATOM   1155  NZ  LYS   124      25.505   0.962 -19.259  0.50 30.02           N  
ATOM   1157  N   GLU   125      26.825  -4.780 -14.331  0.60 19.59           N  
ATOM   1159  CA  GLU   125      26.131  -5.996 -13.881  0.60 19.69           C  
ATOM   1161  C   GLU   125      26.302  -6.092 -12.373  0.60 18.94           C  
ATOM   1163  O   GLU   125      25.366  -6.501 -11.678  0.60 18.66           O  
ATOM   1165  CB  GLU   125      26.661  -7.290 -14.526  0.60 19.99           C  
ATOM   1167  CG  GLU   125      26.151  -8.577 -13.844  0.60 20.98           C  
ATOM   1169  CD  GLU   125      26.607  -9.843 -14.539  0.60 21.63           C  
ATOM   1171  OE1 GLU   125      26.261 -10.005 -15.714  0.60 19.71           O  
ATOM   1173  OE2 GLU   125      27.260 -10.698 -13.888  0.60 27.62           O  
ATOM   1175  N   GLU   126      27.489  -5.753 -11.848  1.00 19.08           N  
ATOM   1176  CA  GLU   126      27.648  -5.938 -10.406  1.00 18.73           C  
ATOM   1177  C   GLU   126      26.741  -5.028  -9.609  1.00 18.15           C  
ATOM   1178  O   GLU   126      26.161  -5.438  -8.607  1.00 17.99           O  
ATOM   1179  CB  GLU   126      29.117  -5.727 -10.000  1.00 18.57           C  
ATOM   1180  CG  GLU   126      29.971  -6.889 -10.484  1.00 18.38           C  
ATOM   1181  CD  GLU   126      31.451  -6.622 -10.553  1.00 23.86           C  
ATOM   1182  OE1 GLU   126      31.903  -5.448 -10.410  1.00 22.43           O  
ATOM   1183  OE2 GLU   126      32.148  -7.648 -10.769  1.00 26.13           O  
ATOM   1184  N   ILE   127      26.640  -3.766 -10.046  1.00 17.91           N  
ATOM   1185  CA  ILE   127      25.729  -2.831  -9.371  1.00 17.65           C  
ATOM   1186  C   ILE   127      24.278  -3.349  -9.459  1.00 17.13           C  
ATOM   1187  O   ILE   127      23.605  -3.412  -8.428  1.00 17.30           O  
ATOM   1188  CB  ILE   127      25.860  -1.432  -9.962  1.00 18.60           C  
ATOM   1189  CG1 ILE   127      27.226  -0.907  -9.564  1.00 18.46           C  
ATOM   1190  CG2 ILE   127      24.801  -0.512  -9.437  1.00 19.31           C  
ATOM   1191  CD1 ILE   127      27.652   0.347 -10.378  1.00 20.44           C  
ATOM   1192  N   GLU   128      23.824  -3.758 -10.663  1.00 18.39           N  
ATOM   1193  CA  GLU   128      22.454  -4.230 -10.797  1.00 20.00           C  
ATOM   1194  C   GLU   128      22.223  -5.470  -9.953  1.00 18.15           C  
ATOM   1195  O   GLU   128      21.169  -5.629  -9.342  1.00 18.91           O  
ATOM   1196  CB  GLU   128      22.138  -4.598 -12.257  1.00 20.94           C  
ATOM   1197  CG  GLU   128      22.052  -3.429 -13.162  1.00 23.65           C  
ATOM   1198  CD  GLU   128      21.814  -3.828 -14.628  1.00 25.57           C  
ATOM   1199  OE1 GLU   128      21.660  -5.043 -14.953  1.00 30.78           O  
ATOM   1200  OE2 GLU   128      21.811  -2.893 -15.466  1.00 32.76           O  
ATOM   1201  N   TYR   129      23.200  -6.376  -9.937  1.00 17.26           N  
ATOM   1202  CA  TYR   129      23.116  -7.601  -9.141  1.00 17.84           C  
ATOM   1203  C   TYR   129      22.970  -7.266  -7.649  1.00 18.04           C  
ATOM   1204  O   TYR   129      22.105  -7.813  -6.920  1.00 18.35           O  
ATOM   1205  CB  TYR   129      24.391  -8.393  -9.363  1.00 18.21           C  
ATOM   1206  CG  TYR   129      24.534  -9.595  -8.483  1.00 18.38           C  
ATOM   1207  CD1 TYR   129      23.709 -10.725  -8.630  1.00 18.41           C  
ATOM   1208  CD2 TYR   129      25.523  -9.622  -7.498  1.00 20.53           C  
ATOM   1209  CE1 TYR   129      23.864 -11.827  -7.804  1.00 17.58           C  
ATOM   1210  CE2 TYR   129      25.680 -10.727  -6.675  1.00 19.51           C  
ATOM   1211  CZ  TYR   129      24.855 -11.837  -6.813  1.00 18.04           C  
ATOM   1212  OH  TYR   129      25.046 -12.968  -6.031  1.00 20.25           O  
ATOM   1213  N   ILE   130      23.838  -6.374  -7.162  1.00 16.52           N  
ATOM   1214  CA  ILE   130      23.709  -5.978  -5.770  1.00 17.09           C  
ATOM   1215  C   ILE   130      22.356  -5.330  -5.503  1.00 16.91           C  
ATOM   1216  O   ILE   130      21.727  -5.628  -4.479  1.00 18.49           O  
ATOM   1217  CB  ILE   130      24.863  -5.005  -5.382  1.00 17.07           C  
ATOM   1218  CG1 ILE   130      26.193  -5.809  -5.366  1.00 17.50           C  
ATOM   1219  CG2 ILE   130      24.540  -4.313  -4.062  1.00 18.07           C  
ATOM   1220  CD1 ILE   130      27.479  -4.888  -5.348  1.00 19.29           C  
ATOM   1221  N   GLN   131      21.902  -4.417  -6.379  1.00 16.81           N  
ATOM   1222  CA  GLN   131      20.627  -3.733  -6.147  1.00 16.26           C  
ATOM   1223  C   GLN   131      19.446  -4.743  -6.100  1.00 16.96           C  
ATOM   1224  O   GLN   131      18.583  -4.655  -5.232  1.00 17.72           O  
ATOM   1225  CB  GLN   131      20.379  -2.693  -7.226  1.00 17.36           C  
ATOM   1226  CG  GLN   131      21.329  -1.508  -7.062  1.00 17.32           C  
ATOM   1227  CD  GLN   131      21.262  -0.489  -8.196  1.00 18.14           C  
ATOM   1228  OE1 GLN   131      20.970  -0.828  -9.350  1.00 21.38           O  
ATOM   1229  NE2 GLN   131      21.621   0.769  -7.879  1.00 20.80           N  
ATOM   1230  N   THR   132      19.419  -5.674  -7.054  1.00 16.48           N  
ATOM   1231  CA  THR   132      18.346  -6.671  -7.094  1.00 16.57           C  
ATOM   1232  C   THR   132      18.269  -7.419  -5.769  1.00 17.80           C  
ATOM   1233  O   THR   132      17.198  -7.577  -5.188  1.00 18.56           O  
ATOM   1234  CB  THR   132      18.604  -7.637  -8.232  1.00 18.12           C  
ATOM   1235  OG1 THR   132      18.408  -6.933  -9.460  1.00 18.40           O  
ATOM   1236  CG2 THR   132      17.597  -8.815  -8.160  1.00 17.65           C  
ATOM   1237  N   ASN   133      19.409  -7.901  -5.303  1.00 17.31           N  
ATOM   1238  CA  ASN   133      19.415  -8.773  -4.108  1.00 17.08           C  
ATOM   1239  C   ASN   133      19.311  -7.976  -2.822  1.00 17.38           C  
ATOM   1240  O   ASN   133      18.656  -8.409  -1.867  1.00 18.85           O  
ATOM   1241  CB  ASN   133      20.651  -9.693  -4.135  1.00 17.47           C  
ATOM   1242  CG  ASN   133      20.577 -10.696  -5.293  1.00 20.14           C  
ATOM   1243  OD1 ASN   133      21.201 -10.534  -6.357  1.00 20.33           O  
ATOM   1244  ND2 ASN   133      19.772 -11.703  -5.112  1.00 16.52           N  
ATOM   1245  N   ALA   134      19.907  -6.785  -2.801  1.00 17.14           N  
ATOM   1246  CA  ALA   134      19.819  -5.949  -1.597  1.00 17.67           C  
ATOM   1247  C   ALA   134      18.425  -5.402  -1.350  1.00 17.75           C  
ATOM   1248  O   ALA   134      18.010  -5.294  -0.191  1.00 18.61           O  
ATOM   1249  CB  ALA   134      20.833  -4.785  -1.649  1.00 18.35           C  
ATOM   1250  N   ARG   135      17.690  -5.062  -2.413  0.50 17.68           N  
ATOM   1252  CA  ARG   135      16.292  -4.640  -2.250  0.50 18.19           C  
ATOM   1254  C   ARG   135      15.572  -5.671  -1.405  0.50 17.60           C  
ATOM   1256  O   ARG   135      14.915  -5.319  -0.421  0.50 17.24           O  
ATOM   1258  CB  ARG   135      15.558  -4.482  -3.598  0.50 18.84           C  
ATOM   1260  CG  ARG   135      15.634  -3.088  -4.185  0.50 20.89           C  
ATOM   1262  CD  ARG   135      14.767  -2.913  -5.452  0.50 19.82           C  
ATOM   1264  NE  ARG   135      15.253  -3.691  -6.597  0.50 21.02           N  
ATOM   1266  CZ  ARG   135      16.118  -3.257  -7.510  0.50 20.55           C  
ATOM   1268  NH1 ARG   135      16.660  -2.051  -7.414  0.50 19.77           N  
ATOM   1270  NH2 ARG   135      16.470  -4.039  -8.515  0.50 20.94           N  
ATOM   1272  N   LYS   136      15.739  -6.941  -1.769  1.00 17.30           N  
ATOM   1273  CA  LYS   136      15.013  -8.042  -1.104  1.00 16.20           C  
ATOM   1274  C   LYS   136      15.561  -8.221   0.317  1.00 16.60           C  
ATOM   1275  O   LYS   136      14.805  -8.320   1.280  1.00 16.64           O  
ATOM   1276  CB  LYS   136      15.162  -9.303  -1.914  1.00 17.03           C  
ATOM   1277  CG  LYS   136      14.430  -9.172  -3.243  1.00 20.14           C  
ATOM   1278  CD  LYS   136      14.770 -10.338  -4.113  1.00 23.30           C  
ATOM   1279  CE  LYS   136      14.162 -10.175  -5.516  1.00 25.56           C  
ATOM   1280  NZ  LYS   136      12.720 -10.573  -5.377  1.00 29.92           N  
ATOM   1281  N   LEU   137      16.893  -8.204   0.420  1.00 16.81           N  
ATOM   1282  CA  LEU   137      17.533  -8.532   1.692  1.00 16.98           C  
ATOM   1283  C   LEU   137      17.144  -7.528   2.759  1.00 17.23           C  
ATOM   1284  O   LEU   137      16.991  -7.903   3.926  1.00 17.59           O  
ATOM   1285  CB  LEU   137      19.054  -8.638   1.497  1.00 17.81           C  
ATOM   1286  CG  LEU   137      19.910  -9.022   2.716  1.00 18.22           C  
ATOM   1287  CD1 LEU   137      19.354 -10.327   3.309  1.00 18.14           C  
ATOM   1288  CD2 LEU   137      21.383  -9.126   2.302  1.00 17.26           C  
ATOM   1289  N   PHE   138      16.984  -6.245   2.373  1.00 17.07           N  
ATOM   1290  CA  PHE   138      16.586  -5.233   3.356  1.00 18.73           C  
ATOM   1291  C   PHE   138      15.282  -5.558   4.070  1.00 19.99           C  
ATOM   1292  O   PHE   138      15.090  -5.139   5.217  1.00 21.34           O  
ATOM   1293  CB  PHE   138      16.442  -3.844   2.687  1.00 18.10           C  
ATOM   1294  CG  PHE   138      17.686  -3.006   2.719  1.00 17.50           C  
ATOM   1295  CD1 PHE   138      18.139  -2.388   1.555  1.00 16.88           C  
ATOM   1296  CD2 PHE   138      18.396  -2.812   3.903  1.00 17.33           C  
ATOM   1297  CE1 PHE   138      19.283  -1.541   1.583  1.00 18.86           C  
ATOM   1298  CE2 PHE   138      19.527  -1.973   3.909  1.00 19.25           C  
ATOM   1299  CZ  PHE   138      19.952  -1.367   2.760  1.00 17.67           C  
ATOM   1300  N   GLU   139      14.439  -6.386   3.444  1.00 18.92           N  
ATOM   1301  CA  GLU   139      13.138  -6.676   3.996  1.00 19.71           C  
ATOM   1302  C   GLU   139      13.066  -8.043   4.661  1.00 17.95           C  
ATOM   1303  O   GLU   139      12.014  -8.404   5.137  1.00 18.66           O  
ATOM   1304  CB  GLU   139      12.101  -6.581   2.895  1.00 19.85           C  
ATOM   1305  CG  GLU   139      12.117  -5.275   2.063  1.00 23.35           C  
ATOM   1306  CD  GLU   139      12.058  -4.002   2.912  1.00 30.03           C  
ATOM   1307  OE1 GLU   139      11.489  -3.989   4.046  1.00 30.29           O  
ATOM   1308  OE2 GLU   139      12.582  -2.966   2.407  1.00 33.04           O  
ATOM   1309  N   LYS   140      14.176  -8.786   4.703  1.00 17.80           N  
ATOM   1310  CA  LYS   140      14.103 -10.176   5.243  1.00 19.28           C  
ATOM   1311  C   LYS   140      14.286 -10.219   6.749  1.00 21.74           C  
ATOM   1312  O   LYS   140      14.695  -9.206   7.393  1.00 21.57           O  
ATOM   1313  CB  LYS   140      15.170 -11.064   4.589  1.00 18.37           C  
ATOM   1314  CG  LYS   140      14.909 -11.354   3.112  1.00 18.79           C  
ATOM   1315  CD  LYS   140      16.003 -12.193   2.490  1.00 19.32           C  
ATOM   1316  CE  LYS   140      15.652 -12.412   0.999  1.00 21.12           C  
ATOM   1317  NZ  LYS   140      16.766 -13.100   0.285  1.00 22.33           N  
ATOM   1318  OXT LYS   140      14.000 -11.276   7.370  1.00 23.13           O  
END
