
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  186 ( 1512),  selected  186 , name 2gh2_A
# Molecule2: number of CA atoms  138 ( 1133),  selected  138 , name T0414.pdb
# PARAMETERS: 2gh2_A.T0414.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    E     5_A      A       3           -
LGA    L     6_A      M       4           -
LGA    L     7_A      K       5           -
LGA    K     8_A      -       -           -
LGA    P     9_A      -       -           -
LGA    R    10_A      -       -           -
LGA    T    11_A      -       -           -
LGA    L    12_A      -       -           -
LGA    A    13_A      P       6          4.758
LGA    D    14_A      D       7           -
LGA    L    15_A      -       -           -
LGA    I    16_A      -       -           -
LGA    R    17_A      -       -           -
LGA    I    18_A      -       -           -
LGA    L    19_A      -       -           -
LGA    H    20_A      -       -           -
LGA    E    21_A      -       -           -
LGA    L    22_A      -       -           -
LGA    F    23_A      -       -           -
LGA    A    24_A      -       -           -
LGA    G    25_A      -       -           -
LGA    D    26_A      -       -           -
LGA    E    27_A      -       -           -
LGA    V    28_A      -       -           -
LGA    N    29_A      -       -           -
LGA    V    30_A      -       -           -
LGA    E    31_A      -       -           -
LGA    E    32_A      -       -           -
LGA    V    33_A      -       -           -
LGA    Q    34_A      -       -           -
LGA    A    35_A      -       -           -
LGA    V    36_A      -       -           -
LGA    L    37_A      -       -           -
LGA    E    38_A      -       -           -
LGA    A    39_A      -       -           -
LGA    Y    40_A      -       -           -
LGA    E    41_A      -       -           -
LGA    S    42_A      -       -           -
LGA    N    43_A      -       -           -
LGA    P    44_A      -       -           -
LGA    A    45_A      -       -           -
LGA    E    46_A      I       8          4.926
LGA    W    47_A      Y       9          4.001
LGA    A    48_A      E      10          3.239
LGA    L    49_A      -       -           -
LGA    Y    50_A      -       -           -
LGA    A    51_A      N      11          1.503
LGA    K    52_A      N      12          2.367
LGA    F    53_A      R      13          2.179
LGA    D    54_A      E      14          2.786
LGA    Q    55_A      -       -           -
LGA    Y    56_A      -       -           -
LGA    R    57_A      -       -           -
LGA    Y    58_A      -       -           -
LGA    T    59_A      G      15          1.766
LGA    R    60_A      I      16          1.545
LGA    N    61_A      L      17          0.791
LGA    L    62_A      C      18          1.323
LGA    V    63_A      V      19          1.070
LGA    D    64_A      Y      20          1.111
LGA    Q    65_A      K      21          0.991
LGA    G    66_A      N      22          2.181
LGA    N    67_A      -       -           -
LGA    G    68_A      E      23          0.675
LGA    K    69_A      K      24          0.336
LGA    F    70_A      W      25          1.063
LGA    N    71_A      L      26          1.653
LGA    L    72_A      V      27          1.204
LGA    M    73_A      C      28          1.071
LGA    I    74_A      I      29          0.926
LGA    L    75_A      K      30          0.933
LGA    C    76_A      N      31          1.140
LGA    W    77_A      W      32          1.107
LGA    G    78_A      K      33          4.903
LGA    E    79_A      P      34           -
LGA    G    80_A      -       -           -
LGA    H    81_A      D      35          4.847
LGA    G    82_A      N      36          0.450
LGA    -       -      D      37           -
LGA    -       -      I      38           -
LGA    -       -      E      39           -
LGA    -       -      G      40           -
LGA    -       -      I      41           -
LGA    S    83_A      A      42           #
LGA    S    84_A      H      43          3.009
LGA    I    85_A      L      44          0.773
LGA    H    86_A      E      45          0.884
LGA    D    87_A      I      46          0.483
LGA    H    88_A      H      47          1.395
LGA    T    89_A      H      48          2.817
LGA    D    90_A      S      49          1.184
LGA    S    91_A      T      50          0.461
LGA    H    92_A      D      51          1.578
LGA    C    93_A      E      52          0.603
LGA    F    94_A      Q      53          0.921
LGA    L    95_A      F      54          0.945
LGA    K    96_A      I      55          0.901
LGA    L    97_A      L      56          1.218
LGA    L    98_A      S      57          1.714
LGA    Q    99_A      A      58          1.439
LGA    G   100_A      G      59          1.454
LGA    N   101_A      K      60          1.746
LGA    L   102_A      A      61          1.063
LGA    K   103_A      I      62          0.684
LGA    E   104_A      L      63          0.762
LGA    T   105_A      I      64          1.387
LGA    L   106_A      T      65          1.273
LGA    F   107_A      A      66          0.471
LGA    D   108_A      E      67          0.713
LGA    W   109_A      K      68          3.151
LGA    P   110_A      E      69          3.673
LGA    D   111_A      N      70          3.045
LGA    K   112_A      -       -           -
LGA    K   113_A      -       -           -
LGA    S   114_A      D      71          2.991
LGA    N   115_A      K      72          3.395
LGA    E   116_A      -       -           -
LGA    M   117_A      F      73          1.700
LGA    I   118_A      N      74          2.908
LGA    K   119_A      I      75          0.826
LGA    K   120_A      E      76          3.380
LGA    S   121_A      -       -           -
LGA    E   122_A      L      77          1.019
LGA    R   123_A      T      78          1.221
LGA    T   124_A      L      79          1.070
LGA    L   125_A      M      80          0.921
LGA    R   126_A      E      81          2.627
LGA    E   127_A      K      82          2.609
LGA    N   128_A      G      83          3.552
LGA    Q   129_A      K      84          2.520
LGA    C   130_A      V      85          1.605
LGA    A   131_A      Y      86          0.781
LGA    Y   132_A      N      87          0.519
LGA    I   133_A      V      88          0.774
LGA    N   134_A      P      89          1.572
LGA    D   135_A      A      90          2.351
LGA    S   136_A      E      91          4.504
LGA    I   137_A      -       -           -
LGA    G   138_A      C      92          1.905
LGA    L   139_A      W      93          1.088
LGA    H   140_A      F      94          1.081
LGA    R   141_A      Y      95          1.733
LGA    V   142_A      S      96          0.653
LGA    E   143_A      I      97          1.062
LGA    N   144_A      T      98          0.459
LGA    V   145_A      Q      99          4.392
LGA    S   146_A      -       -           -
LGA    H   147_A      -       -           -
LGA    T   148_A      -       -           -
LGA    E   149_A      K     100          4.423
LGA    P   150_A      D     101          1.331
LGA    A   151_A      T     102          1.082
LGA    V   152_A      K     103          1.167
LGA    S   153_A      M     104          1.135
LGA    L   154_A      M     105          1.030
LGA    H   155_A      Y     106          1.018
LGA    L   156_A      V     107          0.889
LGA    Y   157_A      Q     108          0.635
LGA    S   158_A      D     109          1.644
LGA    P   159_A      S     110          4.610
LGA    P   160_A      N     111          2.425
LGA    F   161_A      C     112          1.597
LGA    D   162_A      S     113          1.960
LGA    T   163_A      M     114          0.993
LGA    -       -      D     115           -
LGA    -       -      N     116           -
LGA    C   164_A      S     117          2.177
LGA    H   165_A      D     118          1.058
LGA    A   166_A      F     119          1.017
LGA    F   167_A      C     120          1.298
LGA    D   168_A      D     121          1.722
LGA    Q   169_A      L     122          1.667
LGA    R   170_A      S     123          2.013
LGA    T   171_A      K     124           -
LGA    G   172_A      E     125           -
LGA    H   173_A      E     126           -
LGA    K   174_A      I     127           -
LGA    N   175_A      E     128           -
LGA    K   176_A      Y     129           -
LGA    V   177_A      I     130           -
LGA    T   178_A      Q     131           -
LGA    M   179_A      T     132           -
LGA    T   180_A      N     133           -
LGA    F   181_A      A     134           -
LGA    H   182_A      R     135           -
LGA    S   183_A      K     136           -
LGA    K   184_A      L     137           -
LGA    F   185_A      F     138           -
LGA    G   186_A      E     139           -
LGA    I   187_A      K     140           -
LGA    R   188_A      -       -           -
LGA    T   189_A      -       -           -
LGA    P   190_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  186  138    5.0    108    2.10     7.41     63.477     4.917

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.112736 * X  +  -0.399585 * Y  +   0.909738 * Z  +  81.871483
  Y_new =   0.988372 * X  +  -0.048928 * Y  +  -0.143971 * Z  +  11.066772
  Z_new =   0.102040 * X  +   0.915390 * Y  +   0.389422 * Z  +  28.123497 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.168573   -1.973020  [ DEG:    66.9543   -113.0457 ]
  Theta =  -0.102218   -3.039375  [ DEG:    -5.8567   -174.1433 ]
  Phi   =   1.457225   -1.684368  [ DEG:    83.4928    -96.5072 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2gh2_A                                        
REMARK     2: T0414.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2gh2_A.T0414.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  186  138   5.0  108   2.10    7.41  63.477
REMARK  ---------------------------------------------------------- 
MOLECULE 2gh2_A
HEADER    OXIDOREDUCTASE                          24-MAR-06   2GH2              
TITLE     1.5 A RESOLUTION R. NORVEGICUS CYSTEINE DIOXYGENASE                   
TITLE    2 STRUCTURE CRYSTALLIZED IN THE PRESENCE OF CYSTEINE                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CYSTEINE DIOXYGENASE TYPE I;                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: CDO, CDO-I;                                                 
COMPND   5 EC: 1.13.11.20;                                                      
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RATTUS NORVEGICUS;                              
SOURCE   3 ORGANISM_COMMON: RAT;                                                
SOURCE   4 GENE: CDO1;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET32A                                    
KEYWDS    THIOETHER, CYSTEINYL-TYROSINE, CUPIN, BETA-SANDWICH,                  
KEYWDS   2 TETRAHEDRAL IRON COORDINATION                                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.R.SIMMONS,P.A.KARPLUS,M.H STIPANUK                                  
REVDAT   2   18-JUL-06 2GH2    1       JRNL                                     
REVDAT   1   11-APR-06 2GH2    0                                                
JRNL        AUTH   C.R.SIMMONS,Q.LIU,Q.HUANG,Q.HAO,T.P.BEGLEY,                  
JRNL        AUTH 2 P.A.KARPLUS,M.H.STIPANUK                                     
JRNL        TITL   CRYSTAL STRUCTURE OF MAMMALIAN CYSTEINE                      
JRNL        TITL 2 DIOXYGENASE: A NOVEL MONONUCLEAR IRON CENTER FOR             
JRNL        TITL 3 CYSTEINE THIOL OXIDATION.                                    
JRNL        REF    J.BIOL.CHEM.                  V. 281 18723 2006              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 1.50 ANGSTROMS.                                          
DBREF  2GH2 A    1   200  UNP    P21816   CDO1_RAT         1    200             
SEQRES   1 A  200  MET GLU ARG THR GLU LEU LEU LYS PRO ARG THR LEU ALA          
SEQRES   2 A  200  ASP LEU ILE ARG ILE LEU HIS GLU LEU PHE ALA GLY ASP          
SEQRES   3 A  200  GLU VAL ASN VAL GLU GLU VAL GLN ALA VAL LEU GLU ALA          
SEQRES   4 A  200  TYR GLU SER ASN PRO ALA GLU TRP ALA LEU TYR ALA LYS          
SEQRES   5 A  200  PHE ASP GLN TYR ARG TYR THR ARG ASN LEU VAL ASP GLN          
SEQRES   6 A  200  GLY ASN GLY LYS PHE ASN LEU MET ILE LEU CYS TRP GLY          
SEQRES   7 A  200  GLU GLY HIS GLY SER SER ILE HIS ASP HIS THR ASP SER          
SEQRES   8 A  200  HIS CYS PHE LEU LYS LEU LEU GLN GLY ASN LEU LYS GLU          
SEQRES   9 A  200  THR LEU PHE ASP TRP PRO ASP LYS LYS SER ASN GLU MET          
SEQRES  10 A  200  ILE LYS LYS SER GLU ARG THR LEU ARG GLU ASN GLN CYS          
SEQRES  11 A  200  ALA TYR ILE ASN ASP SER ILE GLY LEU HIS ARG VAL GLU          
SEQRES  12 A  200  ASN VAL SER HIS THR GLU PRO ALA VAL SER LEU HIS LEU          
SEQRES  13 A  200  TYR SER PRO PRO PHE ASP THR CYS HIS ALA PHE ASP GLN          
SEQRES  14 A  200  ARG THR GLY HIS LYS ASN LYS VAL THR MET THR PHE HIS          
SEQRES  15 A  200  SER LYS PHE GLY ILE ARG THR PRO PHE THR THR SER GLY          
SEQRES  16 A  200  SER LEU GLU ASN ASN                                          
HET    SO4    451       5                                                       
HET     FE  A 501       1                                                       
HETNAM     SO4 SULFATE ION                                                      
HETNAM      FE FE (III) ION                                                     
FORMUL   2  SO4    O4 S 2-                                                      
FORMUL   3   FE    FE 3+                                                        
FORMUL   4  HOH   *343(H2 O)                                                    
CRYST1   57.484   57.484  122.804  90.00  90.00  90.00 P 43 21 2     8          
ATOM      1  N   GLU A   5      40.557  -8.544  31.828  1.00 34.46           N  
ATOM      2  CA  GLU A   5      39.135  -8.642  32.303  1.00 32.42           C  
ATOM      3  C   GLU A   5      38.257  -7.702  31.478  1.00 29.96           C  
ATOM      4  O   GLU A   5      38.349  -6.486  31.602  1.00 30.53           O  
ATOM      5  CB  GLU A   5      39.030  -8.259  33.786  1.00 35.19           C  
ATOM      6  CG  GLU A   5      37.627  -8.426  34.368  1.00 37.28           C  
ATOM      7  CD  GLU A   5      37.514  -7.975  35.822  1.00 40.11           C  
ATOM      8  OE1 GLU A   5      37.863  -6.803  36.114  1.00 41.59           O  
ATOM      9  OE2 GLU A   5      37.070  -8.783  36.676  1.00 41.08           O  
ATOM     10  N   LEU A   6      37.406  -8.276  30.639  1.00 25.59           N  
ATOM     11  CA  LEU A   6      36.526  -7.499  29.783  1.00 22.69           C  
ATOM     12  C   LEU A   6      35.196  -7.267  30.468  1.00 20.70           C  
ATOM     13  O   LEU A   6      34.458  -8.208  30.712  1.00 21.24           O  
ATOM     14  CB  LEU A   6      36.256  -8.248  28.481  1.00 22.20           C  
ATOM     15  CG  LEU A   6      37.382  -8.684  27.554  1.00 23.88           C  
ATOM     16  CD1 LEU A   6      36.734  -9.217  26.273  1.00 23.92           C  
ATOM     17  CD2 LEU A   6      38.305  -7.506  27.237  1.00 23.09           C  
ATOM     18  N   LEU A   7      34.877  -6.015  30.766  1.00 18.48           N  
ATOM     19  CA  LEU A   7      33.620  -5.695  31.422  1.00 18.10           C  
ATOM     20  C   LEU A   7      32.721  -4.976  30.421  1.00 16.40           C  
ATOM     21  O   LEU A   7      33.189  -4.455  29.400  1.00 17.97           O  
ATOM     22  CB  LEU A   7      33.869  -4.816  32.640  1.00 19.32           C  
ATOM     23  CG  LEU A   7      34.716  -5.470  33.730  1.00 22.83           C  
ATOM     24  CD1 LEU A   7      35.012  -4.446  34.822  1.00 24.60           C  
ATOM     25  CD2 LEU A   7      33.986  -6.671  34.301  1.00 22.96           C  
ATOM     26  N   LYS A   8      31.430  -4.960  30.710  1.00 15.73           N  
ATOM     27  CA  LYS A   8      30.501  -4.319  29.799  1.00 13.96           C  
ATOM     28  C   LYS A   8      30.657  -2.810  29.813  1.00 14.16           C  
ATOM     29  O   LYS A   8      30.612  -2.204  30.884  1.00 13.43           O  
ATOM     30  CB  LYS A   8      29.072  -4.627  30.196  1.00 14.98           C  
ATOM     31  CG  LYS A   8      28.022  -3.986  29.312  1.00 19.26           C  
ATOM     32  CD  LYS A   8      26.628  -4.117  29.943  1.00 24.25           C  
ATOM     33  CE  LYS A   8      25.593  -3.308  29.188  1.00 26.30           C  
ATOM     34  NZ  LYS A   8      25.451  -3.788  27.788  1.00 29.72           N  
ATOM     35  N   PRO A   9      30.844  -2.187  28.646  1.00 12.22           N  
ATOM     36  CA  PRO A   9      30.975  -0.717  28.627  1.00 12.15           C  
ATOM     37  C   PRO A   9      29.626  -0.165  29.031  1.00 11.71           C  
ATOM     38  O   PRO A   9      28.611  -0.533  28.436  1.00 13.31           O  
ATOM     39  CB  PRO A   9      31.251  -0.390  27.160  1.00 14.28           C  
ATOM     40  CG  PRO A   9      31.849  -1.626  26.626  1.00 14.52           C  
ATOM     41  CD  PRO A   9      31.091  -2.753  27.313  1.00 12.88           C  
ATOM     42  N   ARG A  10      29.615   0.758  29.987  1.00 13.06           N  
ATOM     43  CA  ARG A  10      28.368   1.341  30.490  1.00 15.80           C  
ATOM     44  C   ARG A  10      27.878   2.499  29.653  1.00 13.99           C  
ATOM     45  O   ARG A  10      26.708   2.837  29.686  1.00 14.29           O  
ATOM     46  CB  ARG A  10      28.590   1.871  31.900  1.00 18.75           C  
ATOM     47  CG  ARG A  10      29.099   0.837  32.889  1.00 25.85           C  
ATOM     48  CD  ARG A  10      29.284   1.463  34.265  1.00 32.91           C  
ATOM     49  NE  ARG A  10      27.995   1.858  34.842  1.00 38.80           N  
ATOM     50  CZ  ARG A  10      27.346   2.991  34.576  1.00 41.11           C  
ATOM     51  NH1 ARG A  10      27.848   3.890  33.733  1.00 43.89           N  
ATOM     52  NH2 ARG A  10      26.169   3.218  35.146  1.00 43.46           N  
ATOM     53  N   THR A  11      28.813   3.141  28.968  1.00 12.07           N  
ATOM     54  CA  THR A  11      28.531   4.308  28.146  1.00 11.17           C  
ATOM     55  C   THR A  11      29.572   4.355  27.021  1.00  9.65           C  
ATOM     56  O   THR A  11      30.567   3.603  27.049  1.00 10.10           O  
ATOM     57  CB  THR A  11      28.748   5.604  28.936  1.00 12.58           C  
ATOM     58  OG1 THR A  11      30.131   5.676  29.304  1.00 13.51           O  
ATOM     59  CG2 THR A  11      27.879   5.623  30.208  1.00 12.59           C  
ATOM     60  N   LEU A  12      29.373   5.248  26.040  1.00 10.44           N  
ATOM     61  CA  LEU A  12      30.363   5.400  24.967  1.00  9.89           C  
ATOM     62  C   LEU A  12      31.727   5.807  25.555  1.00 10.41           C  
ATOM     63  O   LEU A  12      32.778   5.296  25.157  1.00  8.82           O  
ATOM     64  CB  LEU A  12      29.891   6.461  23.956  1.00 10.02           C  
ATOM     65  CG  LEU A  12      30.882   6.760  22.833  1.00  9.97           C  
ATOM     66  CD1 LEU A  12      31.222   5.481  22.045  1.00 13.49           C  
ATOM     67  CD2 LEU A  12      30.262   7.832  21.933  1.00 12.89           C  
ATOM     68  N   ALA A  13      31.721   6.716  26.527  1.00 10.67           N  
ATOM     69  CA  ALA A  13      32.977   7.124  27.146  1.00 11.57           C  
ATOM     70  C   ALA A  13      33.669   5.935  27.818  1.00 11.20           C  
ATOM     71  O   ALA A  13      34.896   5.813  27.754  1.00 12.09           O  
ATOM     72  CB  ALA A  13      32.717   8.216  28.181  1.00 12.27           C  
ATOM     73  N   ASP A  14      32.885   5.057  28.437  1.00 11.26           N  
ATOM     74  CA  ASP A  14      33.445   3.883  29.115  1.00 11.64           C  
ATOM     75  C   ASP A  14      34.030   2.960  28.049  1.00 11.23           C  
ATOM     76  O   ASP A  14      35.110   2.405  28.225  1.00 11.98           O  
ATOM     77  CB  ASP A  14      32.339   3.176  29.891  1.00 13.59           C  
ATOM     78  CG  ASP A  14      32.870   2.257  30.953  1.00 16.91           C  
ATOM     79  OD1 ASP A  14      33.853   2.654  31.647  1.00 18.13           O  
ATOM     80  OD2 ASP A  14      32.298   1.162  31.112  1.00 16.53           O  
ATOM     81  N   LEU A  15      33.309   2.791  26.944  1.00 10.62           N  
ATOM     82  CA  LEU A  15      33.819   1.959  25.842  1.00  9.63           C  
ATOM     83  C   LEU A  15      35.165   2.490  25.341  1.00 10.66           C  
ATOM     84  O   LEU A  15      36.092   1.720  25.068  1.00 10.81           O  
ATOM     85  CB  LEU A  15      32.822   1.967  24.678  1.00  9.06           C  
ATOM     86  CG  LEU A  15      33.279   1.356  23.348  1.00  8.22           C  
ATOM     87  CD1 LEU A  15      33.579  -0.153  23.527  1.00  9.39           C  
ATOM     88  CD2 LEU A  15      32.160   1.555  22.321  1.00 10.15           C  
ATOM     89  N   ILE A  16      35.279   3.798  25.195  1.00  9.04           N  
ATOM     90  CA  ILE A  16      36.509   4.395  24.704  1.00  9.75           C  
ATOM     91  C   ILE A  16      37.652   4.101  25.689  1.00 10.31           C  
ATOM     92  O   ILE A  16      38.766   3.752  25.260  1.00 10.07           O  
ATOM     93  CB  ILE A  16      36.300   5.923  24.466  1.00  9.46           C  
ATOM     94  CG1 ILE A  16      35.410   6.119  23.229  1.00 10.68           C  
ATOM     95  CG2 ILE A  16      37.627   6.626  24.281  1.00 11.62           C  
ATOM     96  CD1 ILE A  16      34.908   7.553  23.032  1.00 12.11           C  
ATOM     97  N   ARG A  17      37.392   4.228  26.991  1.00 10.51           N  
ATOM     98  CA  ARG A  17      38.434   3.920  27.987  1.00 11.26           C  
ATOM     99  C   ARG A  17      38.849   2.445  27.869  1.00 11.25           C  
ATOM    100  O   ARG A  17      40.053   2.128  27.874  1.00 10.58           O  
ATOM    101  CB  ARG A  17      37.885   4.224  29.385  1.00 13.57           C  
ATOM    102  CG  ARG A  17      38.891   4.202  30.517  1.00 18.74           C  
ATOM    103  CD  ARG A  17      38.950   2.854  31.152  1.00 21.00           C  
ATOM    104  NE  ARG A  17      37.620   2.465  31.609  1.00 23.42           N  
ATOM    105  CZ  ARG A  17      37.304   1.261  32.054  1.00 23.46           C  
ATOM    106  NH1 ARG A  17      38.231   0.310  32.123  1.00 24.77           N  
ATOM    107  NH2 ARG A  17      36.045   0.998  32.371  1.00 25.22           N  
ATOM    108  N   ILE A  18      37.882   1.539  27.722  1.00 11.01           N  
ATOM    109  CA  ILE A  18      38.196   0.123  27.607  1.00 11.50           C  
ATOM    110  C   ILE A  18      39.006  -0.131  26.340  1.00 10.88           C  
ATOM    111  O   ILE A  18      39.943  -0.925  26.344  1.00 12.45           O  
ATOM    112  CB  ILE A  18      36.897  -0.709  27.627  1.00 12.44           C  
ATOM    113  CG1 ILE A  18      36.273  -0.617  29.023  1.00 12.61           C  
ATOM    114  CG2 ILE A  18      37.161  -2.186  27.283  1.00 14.94           C  
ATOM    115  CD1 ILE A  18      34.771  -0.907  29.044  1.00 14.30           C  
ATOM    116  N   LEU A  19      38.647   0.525  25.240  1.00  8.93           N  
ATOM    117  CA  LEU A  19      39.408   0.340  24.011  1.00  9.69           C  
ATOM    118  C   LEU A  19      40.847   0.828  24.180  1.00 10.68           C  
ATOM    119  O   LEU A  19      41.766   0.246  23.629  1.00  9.65           O  
ATOM    120  CB  LEU A  19      38.730   1.080  22.858  1.00  9.75           C  
ATOM    121  CG  LEU A  19      37.380   0.512  22.428  1.00  7.98           C  
ATOM    122  CD1 LEU A  19      36.726   1.499  21.483  1.00  7.83           C  
ATOM    123  CD2 LEU A  19      37.538  -0.858  21.734  1.00  9.48           C  
ATOM    124  N   HIS A  20      41.065   1.903  24.926  1.00 10.79           N  
ATOM    125  CA  HIS A  20      42.441   2.352  25.137  1.00 10.95           C  
ATOM    126  C   HIS A  20      43.204   1.257  25.879  1.00 10.57           C  
ATOM    127  O   HIS A  20      44.402   1.087  25.658  1.00 12.65           O  
ATOM    128  CB  HIS A  20      42.455   3.665  25.927  1.00 12.01           C  
ATOM    129  CG  HIS A  20      41.997   4.836  25.127  1.00 14.37           C  
ATOM    130  ND1 HIS A  20      41.602   6.026  25.708  1.00 19.98           N  
ATOM    131  CD2 HIS A  20      41.853   5.002  23.798  1.00 18.08           C  
ATOM    132  CE1 HIS A  20      41.244   6.876  24.759  1.00 19.49           C  
ATOM    133  NE2 HIS A  20      41.396   6.277  23.591  1.00 15.24           N  
ATOM    134  N   GLU A  21      42.527   0.505  26.737  1.00 11.40           N  
ATOM    135  CA  GLU A  21      43.225  -0.597  27.423  1.00 10.77           C  
ATOM    136  C   GLU A  21      43.539  -1.756  26.446  1.00 11.44           C  
ATOM    137  O   GLU A  21      44.649  -2.322  26.454  1.00 11.55           O  
ATOM    138  CB  GLU A  21      42.389  -1.113  28.599  1.00 11.84           C  
ATOM    139  CG  GLU A  21      42.169  -0.036  29.678  1.00 14.93           C  
ATOM    140  CD  GLU A  21      41.255  -0.468  30.815  1.00 20.63           C  
ATOM    141  OE1 GLU A  21      40.802  -1.644  30.836  1.00 23.76           O  
ATOM    142  OE2 GLU A  21      40.982   0.373  31.709  1.00 21.28           O  
ATOM    143  N   LEU A  22      42.570  -2.098  25.605  1.00 10.84           N  
ATOM    144  CA  LEU A  22      42.775  -3.209  24.661  1.00 10.57           C  
ATOM    145  C   LEU A  22      43.803  -2.924  23.589  1.00 11.56           C  
ATOM    146  O   LEU A  22      44.333  -3.861  22.973  1.00 12.80           O  
ATOM    147  CB  LEU A  22      41.456  -3.605  23.986  1.00 11.68           C  
ATOM    148  CG  LEU A  22      40.402  -4.054  24.991  1.00 11.07           C  
ATOM    149  CD1 LEU A  22      39.042  -4.238  24.288  1.00 12.38           C  
ATOM    150  CD2 LEU A  22      40.857  -5.358  25.638  1.00 15.08           C  
ATOM    151  N   PHE A  23      44.082  -1.651  23.331  1.00 10.56           N  
ATOM    152  CA  PHE A  23      45.086  -1.283  22.328  1.00 10.15           C  
ATOM    153  C   PHE A  23      46.343  -0.713  22.980  1.00 11.86           C  
ATOM    154  O   PHE A  23      47.117  -0.036  22.309  1.00 12.15           O  
ATOM    155  CB  PHE A  23      44.485  -0.277  21.322  1.00 11.04           C  
ATOM    156  CG  PHE A  23      43.498  -0.903  20.376  1.00  9.02           C  
ATOM    157  CD1 PHE A  23      43.936  -1.405  19.128  1.00  9.97           C  
ATOM    158  CD2 PHE A  23      42.148  -1.053  20.723  1.00  8.89           C  
ATOM    159  CE1 PHE A  23      43.062  -2.034  18.253  1.00 10.84           C  
ATOM    160  CE2 PHE A  23      41.239  -1.699  19.826  1.00 10.20           C  
ATOM    161  CZ  PHE A  23      41.714  -2.186  18.587  1.00 11.56           C  
ATOM    162  N   ALA A  24      46.539  -0.987  24.271  1.00 11.22           N  
ATOM    163  CA  ALA A  24      47.733  -0.475  24.947  1.00 11.45           C  
ATOM    164  C   ALA A  24      49.008  -1.092  24.399  1.00 13.65           C  
ATOM    165  O   ALA A  24      50.083  -0.469  24.432  1.00 15.23           O  
ATOM    166  CB  ALA A  24      47.632  -0.737  26.442  1.00 12.73           C  
ATOM    167  N   GLY A  25      48.879  -2.299  23.880  1.00 14.60           N  
ATOM    168  CA  GLY A  25      50.031  -3.009  23.343  1.00 16.05           C  
ATOM    169  C   GLY A  25      50.183  -2.888  21.841  1.00 16.21           C  
ATOM    170  O   GLY A  25      49.601  -1.997  21.210  1.00 15.39           O  
ATOM    171  N   ASP A  26      50.951  -3.807  21.251  1.00 16.98           N  
ATOM    172  CA  ASP A  26      51.234  -3.732  19.817  1.00 18.21           C  
ATOM    173  C   ASP A  26      50.422  -4.642  18.924  1.00 16.92           C  
ATOM    174  O   ASP A  26      50.470  -4.515  17.677  1.00 18.74           O  
ATOM    175  CB  ASP A  26      52.722  -4.017  19.568  1.00 20.48           C  
ATOM    176  CG  ASP A  26      53.625  -2.969  20.170  1.00 24.12           C  
ATOM    177  OD1 ASP A  26      53.254  -1.771  20.144  1.00 26.53           O  
ATOM    178  OD2 ASP A  26      54.719  -3.345  20.644  1.00 26.72           O  
ATOM    179  N   GLU A  27      49.701  -5.559  19.551  1.00 15.24           N  
ATOM    180  CA  GLU A  27      48.847  -6.479  18.818  1.00 15.82           C  
ATOM    181  C   GLU A  27      47.372  -6.226  19.157  1.00 14.85           C  
ATOM    182  O   GLU A  27      47.051  -5.377  19.991  1.00 14.78           O  
ATOM    183  CB  GLU A  27      49.279  -7.923  19.110  1.00 15.03           C  
ATOM    184  CG  GLU A  27      50.737  -8.212  18.640  1.00 17.00           C  
ATOM    185  CD  GLU A  27      50.890  -8.265  17.106  1.00 20.72           C  
ATOM    186  OE1 GLU A  27      50.084  -8.964  16.461  1.00 22.84           O  
ATOM    187  OE2 GLU A  27      51.816  -7.613  16.559  1.00 21.83           O  
ATOM    188  N   VAL A  28      46.478  -6.948  18.490  1.00 13.68           N  
ATOM    189  CA  VAL A  28      45.042  -6.757  18.669  1.00 13.42           C  
ATOM    190  C   VAL A  28      44.332  -8.069  18.859  1.00 12.95           C  
ATOM    191  O   VAL A  28      44.422  -8.953  18.004  1.00 14.05           O  
ATOM    192  CB  VAL A  28      44.428  -6.054  17.412  1.00 13.44           C  
ATOM    193  CG1 VAL A  28      42.903  -5.836  17.588  1.00 13.73           C  
ATOM    194  CG2 VAL A  28      45.117  -4.730  17.189  1.00 12.84           C  
ATOM    195  N   ASN A  29      43.633  -8.206  19.983  1.00 13.00           N  
ATOM    196  CA  ASN A  29      42.815  -9.396  20.202  1.00 11.92           C  
ATOM    197  C   ASN A  29      41.468  -9.045  19.573  1.00 11.47           C  
ATOM    198  O   ASN A  29      40.615  -8.390  20.177  1.00 11.96           O  
ATOM    199  CB  ASN A  29      42.636  -9.700  21.683  1.00 14.19           C  
ATOM    200  CG  ASN A  29      41.909 -11.010  21.911  1.00 14.47           C  
ATOM    201  OD1 ASN A  29      40.925 -11.314  21.239  1.00 13.53           O  
ATOM    202  ND2 ASN A  29      42.388 -11.802  22.875  1.00 16.71           N  
ATOM    203  N   VAL A  30      41.295  -9.478  18.337  1.00 10.35           N  
ATOM    204  CA  VAL A  30      40.108  -9.169  17.573  1.00 11.70           C  
ATOM    205  C   VAL A  30      38.826  -9.600  18.239  1.00 11.41           C  
ATOM    206  O   VAL A  30      37.833  -8.850  18.267  1.00 10.74           O  
ATOM    207  CB  VAL A  30      40.202  -9.797  16.155  1.00 12.53           C  
ATOM    208  CG1 VAL A  30      38.888  -9.595  15.412  1.00 13.34           C  
ATOM    209  CG2 VAL A  30      41.329  -9.126  15.383  1.00 14.67           C  
ATOM    210  N   GLU A  31      38.813 -10.805  18.794  1.00 12.26           N  
ATOM    211  CA  GLU A  31      37.595 -11.284  19.424  1.00 12.20           C  
ATOM    212  C   GLU A  31      37.187 -10.498  20.657  1.00 10.94           C  
ATOM    213  O   GLU A  31      35.987 -10.284  20.871  1.00 11.46           O  
ATOM    214  CB  GLU A  31      37.732 -12.769  19.761  1.00 13.50           C  
ATOM    215  CG  GLU A  31      37.919 -13.665  18.524  1.00 16.41           C  
ATOM    216  CD  GLU A  31      39.344 -13.680  17.971  1.00 17.69           C  
ATOM    217  OE1 GLU A  31      40.302 -13.218  18.634  1.00 17.83           O  
ATOM    218  OE2 GLU A  31      39.497 -14.175  16.828  1.00 22.49           O  
ATOM    219  N   GLU A  32      38.165 -10.068  21.460  1.00 10.35           N  
ATOM    220  CA  GLU A  32      37.828  -9.273  22.634  1.00 10.70           C  
ATOM    221  C   GLU A  32      37.338  -7.887  22.207  1.00 10.48           C  
ATOM    222  O   GLU A  32      36.407  -7.373  22.821  1.00 10.75           O  
ATOM    223  CB  GLU A  32      39.019  -9.118  23.573  1.00 12.69           C  
ATOM    224  CG  GLU A  32      39.480 -10.458  24.168  1.00 15.35           C  
ATOM    225  CD  GLU A  32      40.493 -10.293  25.274  1.00 19.98           C  
ATOM    226  OE1 GLU A  32      41.046  -9.186  25.428  1.00 20.71           O  
ATOM    227  OE2 GLU A  32      40.739 -11.280  26.002  1.00 21.97           O  
ATOM    228  N   VAL A  33      37.986  -7.272  21.204  1.00  8.85           N  
ATOM    229  CA  VAL A  33      37.533  -5.938  20.758  1.00  9.18           C  
ATOM    230  C   VAL A  33      36.100  -6.040  20.198  1.00 10.37           C  
ATOM    231  O   VAL A  33      35.223  -5.228  20.519  1.00 10.94           O  
ATOM    232  CB  VAL A  33      38.484  -5.337  19.688  1.00  9.74           C  
ATOM    233  CG1 VAL A  33      37.865  -4.068  19.119  1.00 10.15           C  
ATOM    234  CG2 VAL A  33      39.884  -5.044  20.297  1.00 10.01           C  
ATOM    235  N   GLN A  34      35.836  -7.081  19.415  1.00  8.97           N  
ATOM    236  CA  GLN A  34      34.504  -7.260  18.862  1.00 10.98           C  
ATOM    237  C   GLN A  34      33.482  -7.478  19.986  1.00 11.03           C  
ATOM    238  O   GLN A  34      32.383  -6.928  19.940  1.00 11.15           O  
ATOM    239  CB  GLN A  34      34.511  -8.456  17.903  1.00 14.30           C  
ATOM    240  CG  GLN A  34      33.256  -8.517  17.044  1.00 17.62           C  
ATOM    241  CD  GLN A  34      33.468  -9.347  15.794  1.00 21.22           C  
ATOM    242  OE1 GLN A  34      34.515 -10.019  15.621  1.00 23.22           O  
ATOM    243  NE2 GLN A  34      32.485  -9.303  14.907  1.00 21.75           N  
ATOM    244  N   ALA A  35      33.866  -8.246  21.003  1.00 11.01           N  
ATOM    245  CA  ALA A  35      32.941  -8.519  22.094  1.00 10.09           C  
ATOM    246  C   ALA A  35      32.563  -7.257  22.867  1.00 10.98           C  
ATOM    247  O   ALA A  35      31.401  -7.061  23.200  1.00 10.44           O  
ATOM    248  CB  ALA A  35      33.522  -9.547  23.045  1.00 12.80           C  
ATOM    249  N   VAL A  36      33.544  -6.395  23.134  1.00  9.75           N  
ATOM    250  CA  VAL A  36      33.251  -5.187  23.883  1.00 11.10           C  
ATOM    251  C   VAL A  36      32.441  -4.194  23.058  1.00 10.70           C  
ATOM    252  O   VAL A  36      31.527  -3.548  23.584  1.00 10.28           O  
ATOM    253  CB  VAL A  36      34.567  -4.541  24.424  1.00 14.17           C  
ATOM    254  CG1 VAL A  36      35.391  -3.963  23.330  1.00 17.82           C  
ATOM    255  CG2 VAL A  36      34.239  -3.489  25.443  1.00 21.15           C  
ATOM    256  N   LEU A  37      32.734  -4.127  21.761  1.00 10.85           N  
ATOM    257  CA  LEU A  37      31.964  -3.225  20.896  1.00 10.71           C  
ATOM    258  C   LEU A  37      30.533  -3.716  20.856  1.00 12.25           C  
ATOM    259  O   LEU A  37      29.580  -2.920  20.970  1.00 11.65           O  
ATOM    260  CB  LEU A  37      32.540  -3.239  19.479  1.00 10.44           C  
ATOM    261  CG  LEU A  37      33.781  -2.391  19.309  1.00 11.72           C  
ATOM    262  CD1 LEU A  37      34.417  -2.745  17.954  1.00 13.18           C  
ATOM    263  CD2 LEU A  37      33.420  -0.906  19.345  1.00 13.40           C  
ATOM    264  N   GLU A  38      30.353  -5.024  20.683  1.00 12.68           N  
ATOM    265  CA  GLU A  38      28.982  -5.522  20.652  1.00 14.46           C  
ATOM    266  C   GLU A  38      28.231  -5.330  21.978  1.00 13.93           C  
ATOM    267  O   GLU A  38      27.034  -5.042  21.978  1.00 15.34           O  
ATOM    268  CB  GLU A  38      28.972  -6.989  20.250  1.00 16.97           C  
ATOM    269  CG  GLU A  38      27.592  -7.486  19.901  1.00 22.90           C  
ATOM    270  CD  GLU A  38      27.636  -8.586  18.873  1.00 25.52           C  
ATOM    271  OE1 GLU A  38      28.020  -8.317  17.711  1.00 24.39           O  
ATOM    272  OE2 GLU A  38      27.311  -9.730  19.237  1.00 28.64           O  
ATOM    273  N   ALA A  39      28.934  -5.438  23.102  1.00 11.70           N  
ATOM    274  CA  ALA A  39      28.317  -5.289  24.415  1.00 12.67           C  
ATOM    275  C   ALA A  39      27.881  -3.864  24.762  1.00 12.70           C  
ATOM    276  O   ALA A  39      27.019  -3.676  25.628  1.00 14.11           O  
ATOM    277  CB  ALA A  39      29.279  -5.847  25.504  1.00 12.83           C  
ATOM    278  N   TYR A  40      28.477  -2.860  24.130  1.00 11.19           N  
ATOM    279  CA  TYR A  40      28.024  -1.476  24.397  1.00 10.62           C  
ATOM    280  C   TYR A  40      26.630  -1.346  23.801  1.00 10.90           C  
ATOM    281  O   TYR A  40      26.436  -1.585  22.616  1.00 12.18           O  
ATOM    282  CB  TYR A  40      28.964  -0.463  23.721  1.00  9.59           C  
ATOM    283  CG  TYR A  40      28.368   0.926  23.631  1.00  9.84           C  
ATOM    284  CD1 TYR A  40      27.971   1.596  24.782  1.00  9.42           C  
ATOM    285  CD2 TYR A  40      28.159   1.544  22.383  1.00 10.63           C  
ATOM    286  CE1 TYR A  40      27.370   2.869  24.704  1.00 10.34           C  
ATOM    287  CE2 TYR A  40      27.550   2.805  22.296  1.00 10.88           C  
ATOM    288  CZ  TYR A  40      27.169   3.445  23.450  1.00 10.44           C  
ATOM    289  OH  TYR A  40      26.493   4.653  23.372  1.00 10.66           O  
ATOM    290  N   GLU A  41      25.655  -0.963  24.617  1.00 11.59           N  
ATOM    291  CA  GLU A  41      24.287  -0.775  24.130  1.00 11.97           C  
ATOM    292  C   GLU A  41      24.185   0.668  23.642  1.00 10.56           C  
ATOM    293  O   GLU A  41      24.293   1.624  24.415  1.00 11.42           O  
ATOM    294  CB  GLU A  41      23.278  -0.973  25.249  1.00 14.90           C  
ATOM    295  CG  GLU A  41      23.120  -2.402  25.707  1.00 22.93           C  
ATOM    296  CD  GLU A  41      22.082  -2.497  26.796  1.00 27.47           C  
ATOM    297  OE1 GLU A  41      21.010  -1.848  26.658  1.00 30.79           O  
ATOM    298  OE2 GLU A  41      22.337  -3.197  27.795  1.00 31.59           O  
ATOM    299  N   SER A  42      23.937   0.825  22.355  1.00 10.52           N  
ATOM    300  CA  SER A  42      23.850   2.168  21.786  1.00 10.04           C  
ATOM    301  C   SER A  42      22.906   3.099  22.548  1.00  9.52           C  
ATOM    302  O   SER A  42      21.751   2.750  22.778  1.00 12.24           O  
ATOM    303  CB  SER A  42      23.378   2.055  20.335  1.00 10.60           C  
ATOM    304  OG  SER A  42      23.298   3.341  19.747  1.00 10.23           O  
ATOM    305  N   ASN A  43      23.398   4.278  22.924  1.00 10.73           N  
ATOM    306  CA  ASN A  43      22.575   5.245  23.637  1.00 12.71           C  
ATOM    307  C   ASN A  43      22.705   6.504  22.789  1.00 11.09           C  
ATOM    308  O   ASN A  43      23.717   7.219  22.836  1.00 11.61           O  
ATOM    309  CB  ASN A  43      23.101   5.460  25.041  1.00 14.22           C  
ATOM    310  CG  ASN A  43      22.305   6.490  25.776  1.00 17.77           C  
ATOM    311  OD1 ASN A  43      21.546   7.238  25.158  1.00 20.93           O  
ATOM    312  ND2 ASN A  43      22.448   6.534  27.087  1.00 17.97           N  
ATOM    313  N   PRO A  44      21.673   6.800  21.991  1.00 11.31           N  
ATOM    314  CA  PRO A  44      21.723   7.982  21.114  1.00 11.41           C  
ATOM    315  C   PRO A  44      22.172   9.297  21.725  1.00 11.72           C  
ATOM    316  O   PRO A  44      22.847  10.068  21.048  1.00 12.97           O  
ATOM    317  CB  PRO A  44      20.312   8.054  20.535  1.00 12.72           C  
ATOM    318  CG  PRO A  44      19.811   6.610  20.612  1.00 14.02           C  
ATOM    319  CD  PRO A  44      20.372   6.109  21.916  1.00 12.33           C  
ATOM    320  N   ALA A  45      21.845   9.561  22.990  1.00 10.69           N  
ATOM    321  CA  ALA A  45      22.257  10.816  23.603  1.00 11.29           C  
ATOM    322  C   ALA A  45      23.755  10.925  23.707  1.00 10.82           C  
ATOM    323  O   ALA A  45      24.305  12.024  23.643  1.00 14.01           O  
ATOM    324  CB  ALA A  45      21.644  10.971  25.008  1.00 13.60           C  
ATOM    325  N   GLU A  46      24.406   9.782  23.874  1.00  9.05           N  
ATOM    326  CA  GLU A  46      25.858   9.765  24.037  1.00 10.61           C  
ATOM    327  C   GLU A  46      26.636  10.078  22.768  1.00 12.08           C  
ATOM    328  O   GLU A  46      27.773  10.554  22.841  1.00 11.73           O  
ATOM    329  CB  GLU A  46      26.291   8.395  24.562  1.00 11.11           C  
ATOM    330  CG  GLU A  46      25.788   8.177  25.972  1.00 12.48           C  
ATOM    331  CD  GLU A  46      26.074   6.789  26.517  1.00 13.89           C  
ATOM    332  OE1 GLU A  46      26.608   5.939  25.777  1.00 12.13           O  
ATOM    333  OE2 GLU A  46      25.742   6.557  27.713  1.00 17.09           O  
ATOM    334  N   TRP A  47      26.041   9.813  21.616  1.00  9.84           N  
ATOM    335  CA  TRP A  47      26.761  10.063  20.379  1.00 10.55           C  
ATOM    336  C   TRP A  47      26.105  11.083  19.452  1.00 10.38           C  
ATOM    337  O   TRP A  47      26.558  11.288  18.330  1.00 10.33           O  
ATOM    338  CB  TRP A  47      27.031   8.727  19.635  1.00  9.36           C  
ATOM    339  CG  TRP A  47      25.861   7.782  19.475  1.00  8.42           C  
ATOM    340  CD1 TRP A  47      25.615   6.649  20.204  1.00  8.67           C  
ATOM    341  CD2 TRP A  47      24.817   7.863  18.496  1.00  9.67           C  
ATOM    342  NE1 TRP A  47      24.486   6.016  19.741  1.00  8.62           N  
ATOM    343  CE2 TRP A  47      23.965   6.735  18.697  1.00  8.48           C  
ATOM    344  CE3 TRP A  47      24.513   8.767  17.478  1.00  8.78           C  
ATOM    345  CZ2 TRP A  47      22.834   6.500  17.911  1.00 10.65           C  
ATOM    346  CZ3 TRP A  47      23.375   8.535  16.689  1.00  8.36           C  
ATOM    347  CH2 TRP A  47      22.556   7.413  16.914  1.00 10.05           C  
ATOM    348  N   ALA A  48      25.063  11.750  19.938  1.00 10.20           N  
ATOM    349  CA  ALA A  48      24.386  12.767  19.121  1.00 10.21           C  
ATOM    350  C   ALA A  48      25.347  13.827  18.559  1.00 10.02           C  
ATOM    351  O   ALA A  48      25.206  14.264  17.414  1.00 11.83           O  
ATOM    352  CB  ALA A  48      23.277  13.424  19.948  1.00 11.28           C  
ATOM    353  N   LEU A  49      26.315  14.237  19.360  1.00 10.01           N  
ATOM    354  CA  LEU A  49      27.318  15.215  18.957  1.00  9.91           C  
ATOM    355  C   LEU A  49      28.032  14.847  17.663  1.00 10.80           C  
ATOM    356  O   LEU A  49      28.430  15.731  16.883  1.00 11.73           O  
ATOM    357  CB  LEU A  49      28.355  15.331  20.075  1.00 10.32           C  
ATOM    358  CG  LEU A  49      29.552  16.244  19.782  1.00 11.54           C  
ATOM    359  CD1 LEU A  49      29.043  17.731  19.683  1.00 12.97           C  
ATOM    360  CD2 LEU A  49      30.553  16.124  20.896  1.00 13.02           C  
ATOM    361  N   TYR A  50      28.207  13.543  17.439  1.00 10.53           N  
ATOM    362  CA  TYR A  50      28.954  13.055  16.273  1.00 11.51           C  
ATOM    363  C   TYR A  50      28.076  12.698  15.099  1.00 12.03           C  
ATOM    364  O   TYR A  50      28.597  12.505  13.996  1.00 13.78           O  
ATOM    365  CB  TYR A  50      29.763  11.795  16.660  1.00 11.30           C  
ATOM    366  CG  TYR A  50      30.552  11.974  17.917  1.00 10.30           C  
ATOM    367  CD1 TYR A  50      31.636  12.846  17.959  1.00 12.16           C  
ATOM    368  CD2 TYR A  50      30.197  11.306  19.079  1.00 10.17           C  
ATOM    369  CE1 TYR A  50      32.340  13.032  19.131  1.00 13.43           C  
ATOM    370  CE2 TYR A  50      30.884  11.499  20.246  1.00 12.16           C  
ATOM    371  CZ  TYR A  50      31.958  12.358  20.263  1.00 13.12           C  
ATOM    372  OH  TYR A  50      32.659  12.514  21.434  1.00 16.53           O  
ATOM    373  N   ALA A  51      26.763  12.696  15.315  1.00 12.05           N  
ATOM    374  CA  ALA A  51      25.814  12.247  14.282  1.00 13.31           C  
ATOM    375  C   ALA A  51      25.465  13.374  13.338  1.00 13.35           C  
ATOM    376  O   ALA A  51      24.342  13.860  13.337  1.00 15.69           O  
ATOM    377  CB  ALA A  51      24.566  11.717  14.935  1.00 16.26           C  
ATOM    378  N   LYS A  52      26.450  13.794  12.558  1.00 11.23           N  
ATOM    379  CA  LYS A  52      26.258  14.925  11.639  1.00 12.99           C  
ATOM    380  C   LYS A  52      26.076  14.370  10.248  1.00 11.34           C  
ATOM    381  O   LYS A  52      27.018  13.849   9.657  1.00 14.01           O  
ATOM    382  CB  LYS A  52      27.481  15.860  11.678  1.00 12.58           C  
ATOM    383  CG  LYS A  52      27.859  16.334  13.087  1.00 17.03           C  
ATOM    384  CD  LYS A  52      29.116  17.185  13.072  1.00 18.97           C  
ATOM    385  CE  LYS A  52      29.729  17.334  14.486  1.00 20.57           C  
ATOM    386  NZ  LYS A  52      28.821  18.091  15.460  1.00 24.01           N  
ATOM    387  N   PHE A  53      24.868  14.510   9.729  1.00 10.07           N  
ATOM    388  CA  PHE A  53      24.545  13.982   8.392  1.00  9.83           C  
ATOM    389  C   PHE A  53      24.743  14.984   7.257  1.00 11.77           C  
ATOM    390  O   PHE A  53      24.728  16.191   7.484  1.00 12.55           O  
ATOM    391  CB  PHE A  53      23.076  13.527   8.353  1.00 11.09           C  
ATOM    392  CG  PHE A  53      22.812  12.245   9.083  1.00 10.93           C  
ATOM    393  CD1 PHE A  53      22.624  11.061   8.381  1.00 10.94           C  
ATOM    394  CD2 PHE A  53      22.742  12.231  10.480  1.00 11.74           C  
ATOM    395  CE1 PHE A  53      22.362   9.872   9.064  1.00 10.74           C  
ATOM    396  CE2 PHE A  53      22.480  11.041  11.171  1.00 10.82           C  
ATOM    397  CZ  PHE A  53      22.292   9.878  10.459  1.00 11.59           C  
ATOM    398  N   ASP A  54      24.900  14.466   6.041  1.00 12.82           N  
ATOM    399  CA  ASP A  54      25.001  15.301   4.829  1.00 12.34           C  
ATOM    400  C   ASP A  54      23.894  14.765   3.962  1.00 12.97           C  
ATOM    401  O   ASP A  54      23.598  13.574   3.955  1.00 12.21           O  
ATOM    402  CB  ASP A  54      26.333  15.128   4.130  1.00 11.60           C  
ATOM    403  CG  ASP A  54      26.426  15.929   2.835  1.00 14.55           C  
ATOM    404  OD1 ASP A  54      26.719  17.132   2.956  1.00 16.65           O  
ATOM    405  OD2 ASP A  54      26.203  15.356   1.742  1.00 14.69           O  
ATOM    406  N   GLN A  55      23.239  15.642   3.211  1.00 13.18           N  
ATOM    407  CA  GLN A  55      22.143  15.174   2.413  1.00 13.80           C  
ATOM    408  C   GLN A  55      22.508  14.251   1.257  1.00 12.94           C  
ATOM    409  O   GLN A  55      21.727  13.384   0.901  1.00 15.42           O  
ATOM    410  CB  GLN A  55      21.368  16.374   1.857  1.00 18.01           C  
ATOM    411  CG  GLN A  55      20.364  15.982   0.763  1.00 23.06           C  
ATOM    412  CD  GLN A  55      19.303  17.035   0.534  1.00 28.35           C  
ATOM    413  OE1 GLN A  55      18.958  17.784   1.448  1.00 30.50           O  
ATOM    414  NE2 GLN A  55      18.761  17.086  -0.686  1.00 28.10           N  
ATOM    415  N   TYR A  56      23.723  14.396   0.746  1.00 12.12           N  
ATOM    416  CA  TYR A  56      24.109  13.689  -0.449  1.00 13.13           C  
ATOM    417  C   TYR A  56      24.913  12.431  -0.325  1.00 13.09           C  
ATOM    418  O   TYR A  56      24.886  11.604  -1.229  1.00 15.21           O  
ATOM    419  CB  TYR A  56      24.838  14.665  -1.355  1.00 13.96           C  
ATOM    420  CG  TYR A  56      24.028  15.915  -1.556  1.00 16.97           C  
ATOM    421  CD1 TYR A  56      22.850  15.877  -2.294  1.00 17.05           C  
ATOM    422  CD2 TYR A  56      24.422  17.112  -0.968  1.00 16.30           C  
ATOM    423  CE1 TYR A  56      22.069  17.011  -2.453  1.00 20.35           C  
ATOM    424  CE2 TYR A  56      23.651  18.264  -1.112  1.00 18.40           C  
ATOM    425  CZ  TYR A  56      22.483  18.196  -1.857  1.00 20.44           C  
ATOM    426  OH  TYR A  56      21.725  19.325  -2.022  1.00 22.76           O  
ATOM    427  N   ARG A  57      25.635  12.277   0.771  1.00 11.28           N  
ATOM    428  CA  ARG A  57      26.415  11.056   0.958  1.00 11.91           C  
ATOM    429  C   ARG A  57      26.699  10.812   2.433  1.00 10.29           C  
ATOM    430  O   ARG A  57      26.439  11.681   3.272  1.00 10.66           O  
ATOM    431  CB  ARG A  57      27.729  11.131   0.182  1.00 14.10           C  
ATOM    432  CG  ARG A  57      28.637  12.227   0.615  1.00 15.32           C  
ATOM    433  CD  ARG A  57      30.079  11.850   0.362  1.00 19.86           C  
ATOM    434  NE  ARG A  57      30.487  10.809   1.310  1.00 21.03           N  
ATOM    435  CZ  ARG A  57      31.700  10.282   1.356  1.00 24.77           C  
ATOM    436  NH1 ARG A  57      32.640  10.697   0.506  1.00 26.52           N  
ATOM    437  NH2 ARG A  57      31.971   9.340   2.254  1.00 27.02           N  
ATOM    438  N   TYR A  58      27.200   9.623   2.755  1.00  9.57           N  
ATOM    439  CA  TYR A  58      27.487   9.355   4.178  1.00  9.17           C  
ATOM    440  C   TYR A  58      28.671  10.175   4.648  1.00  9.03           C  
ATOM    441  O   TYR A  58      29.551  10.553   3.862  1.00 11.13           O  
ATOM    442  CB  TYR A  58      27.734   7.854   4.410  1.00 10.32           C  
ATOM    443  CG  TYR A  58      29.026   7.320   3.868  1.00 11.50           C  
ATOM    444  CD1 TYR A  58      30.167   7.271   4.672  1.00 12.98           C  
ATOM    445  CD2 TYR A  58      29.106   6.803   2.568  1.00 12.72           C  
ATOM    446  CE1 TYR A  58      31.362   6.702   4.204  1.00 15.82           C  
ATOM    447  CE2 TYR A  58      30.290   6.248   2.094  1.00 16.11           C  
ATOM    448  CZ  TYR A  58      31.410   6.198   2.924  1.00 16.79           C  
ATOM    449  OH  TYR A  58      32.601   5.651   2.477  1.00 20.45           O  
ATOM    450  N   THR A  59      28.677  10.444   5.948  1.00  9.51           N  
ATOM    451  CA  THR A  59      29.730  11.233   6.553  1.00 10.14           C  
ATOM    452  C   THR A  59      30.547  10.428   7.545  1.00 10.09           C  
ATOM    453  O   THR A  59      30.035   9.471   8.135  1.00  9.79           O  
ATOM    454  CB  THR A  59      29.182  12.440   7.292  1.00  9.36           C  
ATOM    455  OG1 THR A  59      28.267  12.026   8.320  1.00  9.80           O  
ATOM    456  CG2 THR A  59      28.471  13.395   6.316  1.00 11.28           C  
ATOM    457  N   ARG A  60      31.804  10.825   7.719  1.00  9.83           N  
ATOM    458  CA  ARG A  60      32.751  10.157   8.646  1.00  9.60           C  
ATOM    459  C   ARG A  60      33.058  11.199   9.725  1.00  9.96           C  
ATOM    460  O   ARG A  60      33.566  12.279   9.417  1.00 11.43           O  
ATOM    461  CB  ARG A  60      34.067   9.769   7.934  1.00 13.40           C  
ATOM    462  CG  ARG A  60      33.907   8.730   6.856  1.00 16.32           C  
ATOM    463  CD  ARG A  60      35.262   8.401   6.141  1.00 19.70           C  
ATOM    464  NE  ARG A  60      35.057   7.225   5.307  1.00 28.19           N  
ATOM    465  CZ  ARG A  60      35.159   5.983   5.770  1.00 27.66           C  
ATOM    466  NH1 ARG A  60      35.489   5.795   7.043  1.00 30.03           N  
ATOM    467  NH2 ARG A  60      34.867   4.936   4.998  1.00 31.54           N  
ATOM    468  N   ASN A  61      32.798  10.859  10.982  1.00  8.23           N  
ATOM    469  CA  ASN A  61      32.969  11.806  12.086  1.00  8.93           C  
ATOM    470  C   ASN A  61      33.867  11.200  13.137  1.00  8.67           C  
ATOM    471  O   ASN A  61      33.484  10.276  13.830  1.00 10.43           O  
ATOM    472  CB  ASN A  61      31.563  12.078  12.655  1.00  8.82           C  
ATOM    473  CG  ASN A  61      30.622  12.606  11.593  1.00  9.19           C  
ATOM    474  OD1 ASN A  61      30.640  13.797  11.291  1.00 10.20           O  
ATOM    475  ND2 ASN A  61      29.842  11.720  10.976  1.00  8.39           N  
ATOM    476  N   LEU A  62      35.070  11.742  13.246  1.00  9.09           N  
ATOM    477  CA  LEU A  62      36.072  11.228  14.179  1.00  9.61           C  
ATOM    478  C   LEU A  62      35.678  11.477  15.625  1.00  9.59           C  
ATOM    479  O   LEU A  62      35.321  12.605  16.020  1.00 10.23           O  
ATOM    480  CB  LEU A  62      37.436  11.886  13.870  1.00  9.35           C  
ATOM    481  CG  LEU A  62      38.655  11.364  14.651  1.00 11.11           C  
ATOM    482  CD1 LEU A  62      38.913   9.887  14.351  1.00 11.70           C  
ATOM    483  CD2 LEU A  62      39.851  12.221  14.251  1.00 13.43           C  
ATOM    484  N   VAL A  63      35.750  10.416  16.423  1.00  9.08           N  
ATOM    485  CA  VAL A  63      35.389  10.450  17.834  1.00  9.46           C  
ATOM    486  C   VAL A  63      36.625  10.380  18.744  1.00 10.72           C  
ATOM    487  O   VAL A  63      36.703  11.101  19.739  1.00 10.96           O  
ATOM    488  CB  VAL A  63      34.452   9.238  18.185  1.00  9.43           C  
ATOM    489  CG1 VAL A  63      34.194   9.184  19.716  1.00 10.46           C  
ATOM    490  CG2 VAL A  63      33.124   9.351  17.420  1.00  9.70           C  
ATOM    491  N   ASP A  64      37.574   9.508  18.403  1.00  9.62           N  
ATOM    492  CA  ASP A  64      38.760   9.340  19.254  1.00 10.64           C  
ATOM    493  C   ASP A  64      39.906   8.871  18.372  1.00 10.87           C  
ATOM    494  O   ASP A  64      39.700   8.066  17.468  1.00  9.38           O  
ATOM    495  CB  ASP A  64      38.458   8.255  20.309  1.00 11.26           C  
ATOM    496  CG  ASP A  64      39.479   8.220  21.430  1.00 11.98           C  
ATOM    497  OD1 ASP A  64      39.376   9.080  22.337  1.00 14.48           O  
ATOM    498  OD2 ASP A  64      40.360   7.341  21.370  1.00 12.50           O  
ATOM    499  N   GLN A  65      41.131   9.333  18.665  1.00 11.33           N  
ATOM    500  CA  GLN A  65      42.294   8.915  17.883  1.00 13.40           C  
ATOM    501  C   GLN A  65      43.111   7.807  18.518  1.00 13.87           C  
ATOM    502  O   GLN A  65      44.229   7.527  18.071  1.00 14.25           O  
ATOM    503  CB  GLN A  65      43.188  10.108  17.599  1.00 15.21           C  
ATOM    504  CG  GLN A  65      42.554  11.032  16.629  1.00 16.73           C  
ATOM    505  CD  GLN A  65      43.419  12.218  16.308  1.00 18.27           C  
ATOM    506  OE1 GLN A  65      43.809  12.981  17.194  1.00 21.52           O  
ATOM    507  NE2 GLN A  65      43.714  12.390  15.034  1.00 22.21           N  
ATOM    508  N   GLY A  66      42.566   7.208  19.572  1.00 12.97           N  
ATOM    509  CA  GLY A  66      43.168   6.059  20.232  1.00 14.58           C  
ATOM    510  C   GLY A  66      44.639   6.107  20.594  1.00 16.04           C  
ATOM    511  O   GLY A  66      45.311   5.072  20.567  1.00 15.67           O  
ATOM    512  N   ASN A  67      45.129   7.288  20.941  1.00 17.43           N  
ATOM    513  CA  ASN A  67      46.539   7.432  21.303  1.00 18.43           C  
ATOM    514  C   ASN A  67      47.404   6.929  20.160  1.00 19.05           C  
ATOM    515  O   ASN A  67      48.485   6.376  20.393  1.00 20.09           O  
ATOM    516  CB  ASN A  67      46.823   6.608  22.553  1.00 22.02           C  
ATOM    517  CG  ASN A  67      46.091   7.132  23.765  1.00 26.25           C  
ATOM    518  OD1 ASN A  67      46.330   8.253  24.201  1.00 30.96           O  
ATOM    519  ND2 ASN A  67      45.183   6.323  24.314  1.00 29.69           N  
ATOM    520  N   GLY A  68      46.918   7.100  18.932  1.00 18.26           N  
ATOM    521  CA  GLY A  68      47.662   6.666  17.762  1.00 16.12           C  
ATOM    522  C   GLY A  68      47.536   5.209  17.319  1.00 15.89           C  
ATOM    523  O   GLY A  68      48.067   4.826  16.261  1.00 17.25           O  
ATOM    524  N   LYS A  69      46.856   4.385  18.119  1.00 15.18           N  
ATOM    525  CA  LYS A  69      46.718   2.971  17.807  1.00 14.85           C  
ATOM    526  C   LYS A  69      45.503   2.689  16.930  1.00 14.72           C  
ATOM    527  O   LYS A  69      45.445   1.665  16.257  1.00 14.33           O  
ATOM    528  CB  LYS A  69      46.559   2.161  19.101  1.00 16.37           C  
ATOM    529  CG  LYS A  69      47.780   2.148  20.020  1.00 17.98           C  
ATOM    530  CD  LYS A  69      48.921   1.362  19.392  1.00 18.60           C  
ATOM    531  CE  LYS A  69      50.135   1.399  20.309  1.00 18.72           C  
ATOM    532  NZ  LYS A  69      49.855   0.824  21.659  1.00 17.76           N  
ATOM    533  N   PHE A  70      44.522   3.579  16.974  1.00 13.81           N  
ATOM    534  CA  PHE A  70      43.305   3.373  16.203  1.00 13.91           C  
ATOM    535  C   PHE A  70      42.522   4.659  15.996  1.00 12.07           C  
ATOM    536  O   PHE A  70      42.730   5.654  16.683  1.00 15.13           O  
ATOM    537  CB  PHE A  70      42.380   2.357  16.909  1.00 12.04           C  
ATOM    538  CG  PHE A  70      41.818   2.830  18.259  1.00 12.19           C  
ATOM    539  CD1 PHE A  70      40.757   3.731  18.317  1.00 12.74           C  
ATOM    540  CD2 PHE A  70      42.329   2.325  19.437  1.00 13.92           C  
ATOM    541  CE1 PHE A  70      40.212   4.109  19.547  1.00 11.50           C  
ATOM    542  CE2 PHE A  70      41.799   2.693  20.681  1.00 14.12           C  
ATOM    543  CZ  PHE A  70      40.741   3.583  20.733  1.00 11.93           C  
ATOM    544  N   ASN A  71      41.657   4.644  14.997  1.00 12.73           N  
ATOM    545  CA  ASN A  71      40.736   5.778  14.768  1.00 12.67           C  
ATOM    546  C   ASN A  71      39.358   5.210  15.115  1.00 12.46           C  
ATOM    547  O   ASN A  71      39.012   4.129  14.644  1.00 13.20           O  
ATOM    548  CB  ASN A  71      40.669   6.172  13.288  1.00 14.62           C  
ATOM    549  CG  ASN A  71      41.766   7.109  12.857  1.00 17.59           C  
ATOM    550  OD1 ASN A  71      42.324   7.849  13.664  1.00 20.84           O  
ATOM    551  ND2 ASN A  71      42.078   7.081  11.562  1.00 20.47           N  
ATOM    552  N   LEU A  72      38.590   5.902  15.947  1.00 10.54           N  
ATOM    553  CA  LEU A  72      37.217   5.490  16.274  1.00  9.14           C  
ATOM    554  C   LEU A  72      36.355   6.604  15.666  1.00 10.18           C  
ATOM    555  O   LEU A  72      36.574   7.790  15.950  1.00  9.35           O  
ATOM    556  CB  LEU A  72      37.012   5.415  17.794  1.00  9.08           C  
ATOM    557  CG  LEU A  72      35.624   4.929  18.185  1.00  9.17           C  
ATOM    558  CD1 LEU A  72      35.463   3.431  17.876  1.00 10.56           C  
ATOM    559  CD2 LEU A  72      35.414   5.200  19.720  1.00 10.49           C  
ATOM    560  N   MET A  73      35.424   6.245  14.786  1.00  9.51           N  
ATOM    561  CA  MET A  73      34.591   7.259  14.134  1.00  8.25           C  
ATOM    562  C   MET A  73      33.170   6.795  13.991  1.00  8.27           C  
ATOM    563  O   MET A  73      32.857   5.605  14.097  1.00  9.64           O  
ATOM    564  CB  MET A  73      35.154   7.558  12.737  1.00 12.64           C  
ATOM    565  CG  MET A  73      35.260   6.340  11.879  1.00 14.12           C  
ATOM    566  SD  MET A  73      36.261   6.640  10.403  1.00 16.75           S  
ATOM    567  CE  MET A  73      37.920   6.430  11.128  1.00 17.16           C  
ATOM    568  N   ILE A  74      32.288   7.764  13.781  1.00  7.25           N  
ATOM    569  CA  ILE A  74      30.890   7.452  13.575  1.00  7.04           C  
ATOM    570  C   ILE A  74      30.537   7.860  12.147  1.00  8.12           C  
ATOM    571  O   ILE A  74      30.854   8.970  11.699  1.00  7.68           O  
ATOM    572  CB  ILE A  74      30.059   8.204  14.598  1.00  7.80           C  
ATOM    573  CG1 ILE A  74      30.165   7.404  15.915  1.00  9.59           C  
ATOM    574  CG2 ILE A  74      28.586   8.375  14.135  1.00 11.10           C  
ATOM    575  CD1 ILE A  74      29.486   8.024  17.131  1.00  9.36           C  
ATOM    576  N   LEU A  75      29.917   6.915  11.431  1.00  7.50           N  
ATOM    577  CA  LEU A  75      29.473   7.159  10.054  1.00  7.90           C  
ATOM    578  C   LEU A  75      27.955   7.333  10.055  1.00  7.13           C  
ATOM    579  O   LEU A  75      27.235   6.592  10.686  1.00  7.50           O  
ATOM    580  CB  LEU A  75      29.922   6.026   9.125  1.00  8.50           C  
ATOM    581  CG  LEU A  75      31.300   6.282   8.499  1.00  8.59           C  
ATOM    582  CD1 LEU A  75      32.413   6.366   9.603  1.00  9.90           C  
ATOM    583  CD2 LEU A  75      31.616   5.182   7.501  1.00 12.38           C  
ATOM    584  N   CYS A  76      27.487   8.347   9.329  1.00  7.33           N  
ATOM    585  CA  CYS A  76      26.065   8.694   9.283  1.00  8.64           C  
ATOM    586  C   CYS A  76      25.623   8.517   7.849  1.00  8.99           C  
ATOM    587  O   CYS A  76      26.112   9.197   6.960  1.00  9.47           O  
ATOM    588  CB  CYS A  76      25.871  10.156   9.729  1.00  8.03           C  
ATOM    589  SG  CYS A  76      26.388  10.348  11.424  1.00 12.09           S  
ATOM    590  N   TRP A  77      24.684   7.596   7.649  1.00  8.33           N  
ATOM    591  CA  TRP A  77      24.226   7.223   6.313  1.00  9.17           C  
ATOM    592  C   TRP A  77      22.799   7.653   6.076  1.00 10.42           C  
ATOM    593  O   TRP A  77      21.902   7.119   6.714  1.00 10.39           O  
ATOM    594  CB  TRP A  77      24.255   5.699   6.155  1.00  9.65           C  
ATOM    595  CG  TRP A  77      25.500   5.021   6.680  1.00  8.26           C  
ATOM    596  CD1 TRP A  77      25.834   4.802   7.995  1.00  8.30           C  
ATOM    597  CD2 TRP A  77      26.552   4.465   5.890  1.00  8.61           C  
ATOM    598  NE1 TRP A  77      27.046   4.134   8.062  1.00  9.26           N  
ATOM    599  CE2 TRP A  77      27.504   3.916   6.786  1.00  9.16           C  
ATOM    600  CE3 TRP A  77      26.785   4.369   4.502  1.00  9.84           C  
ATOM    601  CZ2 TRP A  77      28.684   3.284   6.344  1.00 10.27           C  
ATOM    602  CZ3 TRP A  77      27.937   3.756   4.065  1.00 10.60           C  
ATOM    603  CH2 TRP A  77      28.890   3.213   4.991  1.00 11.78           C  
ATOM    604  N   GLY A  78      22.586   8.591   5.159  1.00  9.26           N  
ATOM    605  CA  GLY A  78      21.217   8.961   4.844  1.00  9.16           C  
ATOM    606  C   GLY A  78      20.570   7.802   4.099  1.00 10.94           C  
ATOM    607  O   GLY A  78      21.215   6.818   3.733  1.00  9.87           O  
ATOM    608  N   GLU A  79      19.272   7.924   3.899  1.00 11.61           N  
ATOM    609  CA  GLU A  79      18.536   6.914   3.152  1.00 11.59           C  
ATOM    610  C   GLU A  79      19.163   6.730   1.770  1.00  9.81           C  
ATOM    611  O   GLU A  79      19.324   7.713   1.007  1.00 11.89           O  
ATOM    612  CB  GLU A  79      17.082   7.389   3.002  1.00 12.00           C  
ATOM    613  CG  GLU A  79      16.345   7.449   4.312  1.00 15.15           C  
ATOM    614  CD  GLU A  79      16.388   8.818   4.977  1.00 19.33           C  
ATOM    615  OE1 GLU A  79      17.347   9.599   4.773  1.00 19.78           O  
ATOM    616  OE2 GLU A  79      15.436   9.112   5.737  1.00 22.99           O  
ATOM    617  N   GLY A  80      19.507   5.483   1.443  1.00 10.49           N  
ATOM    618  CA  GLY A  80      20.079   5.182   0.151  1.00 10.93           C  
ATOM    619  C   GLY A  80      21.557   5.465   0.005  1.00 11.77           C  
ATOM    620  O   GLY A  80      22.112   5.255  -1.053  1.00 13.49           O  
ATOM    621  N   HIS A  81      22.195   5.953   1.063  1.00 10.90           N  
ATOM    622  CA  HIS A  81      23.628   6.233   0.972  1.00 10.02           C  
ATOM    623  C   HIS A  81      24.424   4.960   1.108  1.00 10.83           C  
ATOM    624  O   HIS A  81      24.042   4.077   1.842  1.00 12.91           O  
ATOM    625  CB  HIS A  81      24.038   7.159   2.095  1.00  8.68           C  
ATOM    626  CG  HIS A  81      23.555   8.558   1.908  1.00  9.09           C  
ATOM    627  ND1 HIS A  81      23.818   9.547   2.826  1.00 10.21           N  
ATOM    628  CD2 HIS A  81      22.839   9.135   0.909  1.00  9.64           C  
ATOM    629  CE1 HIS A  81      23.282  10.685   2.405  1.00  9.70           C  
ATOM    630  NE2 HIS A  81      22.681  10.461   1.246  1.00 10.32           N  
ATOM    631  N   GLY A  82      25.541   4.874   0.394  1.00 11.31           N  
ATOM    632  CA  GLY A  82      26.357   3.674   0.494  1.00 10.37           C  
ATOM    633  C   GLY A  82      27.786   3.980   0.106  1.00  9.86           C  
ATOM    634  O   GLY A  82      28.119   5.043  -0.421  1.00 11.23           O  
ATOM    635  N   SER A  83      28.627   2.972   0.314  1.00 10.82           N  
ATOM    636  CA  SER A  83      30.044   3.095   0.024  1.00 10.21           C  
ATOM    637  C   SER A  83      30.389   2.413  -1.286  1.00 11.55           C  
ATOM    638  O   SER A  83      29.569   1.785  -1.933  1.00 11.87           O  
ATOM    639  CB  SER A  83      30.845   2.405   1.142  1.00 11.01           C  
ATOM    640  OG  SER A  83      30.820   0.974   0.966  1.00 10.82           O  
ATOM    641  N   SER A  84      31.645   2.552  -1.648  1.00 12.44           N  
ATOM    642  CA  SER A  84      32.219   1.877  -2.785  1.00 13.23           C  
ATOM    643  C   SER A  84      32.599   0.488  -2.263  1.00 12.44           C  
ATOM    644  O   SER A  84      32.505   0.216  -1.062  1.00 12.06           O  
ATOM    645  CB  SER A  84      33.517   2.583  -3.162  1.00 14.76           C  
ATOM    646  OG  SER A  84      34.418   2.484  -2.083  1.00 22.05           O  
ATOM    647  N   ILE A  85      32.998  -0.400  -3.169  1.00 12.31           N  
ATOM    648  CA  ILE A  85      33.559  -1.696  -2.755  1.00 10.95           C  
ATOM    649  C   ILE A  85      34.967  -1.244  -2.387  1.00 11.49           C  
ATOM    650  O   ILE A  85      35.637  -0.562  -3.167  1.00 11.29           O  
ATOM    651  CB  ILE A  85      33.652  -2.665  -3.916  1.00 11.91           C  
ATOM    652  CG1 ILE A  85      32.227  -3.000  -4.392  1.00 12.96           C  
ATOM    653  CG2 ILE A  85      34.440  -3.920  -3.481  1.00 12.33           C  
ATOM    654  CD1 ILE A  85      32.161  -3.925  -5.641  1.00 14.12           C  
ATOM    655  N   HIS A  86      35.432  -1.592  -1.194  1.00  9.43           N  
ATOM    656  CA  HIS A  86      36.736  -1.127  -0.766  1.00 10.77           C  
ATOM    657  C   HIS A  86      37.478  -2.106   0.144  1.00  9.72           C  
ATOM    658  O   HIS A  86      36.904  -3.074   0.663  1.00  9.45           O  
ATOM    659  CB  HIS A  86      36.574   0.219  -0.044  1.00 11.60           C  
ATOM    660  CG  HIS A  86      35.718   0.146   1.188  1.00 11.77           C  
ATOM    661  ND1 HIS A  86      34.347   0.275   1.136  1.00  9.94           N  
ATOM    662  CD2 HIS A  86      36.022  -0.136   2.477  1.00  9.97           C  
ATOM    663  CE1 HIS A  86      33.842   0.071   2.341  1.00  9.93           C  
ATOM    664  NE2 HIS A  86      34.837  -0.185   3.176  1.00 11.63           N  
ATOM    665  N   ASP A  87      38.777  -1.818   0.294  1.00  9.02           N  
ATOM    666  CA  ASP A  87      39.667  -2.566   1.172  1.00  9.18           C  
ATOM    667  C   ASP A  87      39.895  -1.745   2.416  1.00 10.36           C  
ATOM    668  O   ASP A  87      39.268  -0.688   2.607  1.00 10.14           O  
ATOM    669  CB  ASP A  87      41.003  -2.874   0.459  1.00 10.87           C  
ATOM    670  CG  ASP A  87      41.756  -1.631   0.014  1.00 12.37           C  
ATOM    671  OD1 ASP A  87      41.301  -0.494   0.228  1.00 12.21           O  
ATOM    672  OD2 ASP A  87      42.851  -1.801  -0.572  1.00 13.81           O  
ATOM    673  N   HIS A  88      40.813  -2.218   3.263  1.00  9.62           N  
ATOM    674  CA  HIS A  88      41.074  -1.561   4.525  1.00  9.93           C  
ATOM    675  C   HIS A  88      42.525  -1.329   4.869  1.00 10.08           C  
ATOM    676  O   HIS A  88      42.895  -1.324   6.046  1.00 10.22           O  
ATOM    677  CB  HIS A  88      40.325  -2.291   5.642  1.00 10.41           C  
ATOM    678  CG  HIS A  88      38.841  -2.311   5.427  1.00 10.13           C  
ATOM    679  ND1 HIS A  88      38.219  -3.247   4.622  1.00 10.29           N  
ATOM    680  CD2 HIS A  88      37.879  -1.440   5.808  1.00 10.36           C  
ATOM    681  CE1 HIS A  88      36.935  -2.949   4.521  1.00 11.58           C  
ATOM    682  NE2 HIS A  88      36.709  -1.852   5.225  1.00  8.74           N  
ATOM    683  N   THR A  89      43.350  -1.247   3.823  1.00  9.74           N  
ATOM    684  CA  THR A  89      44.721  -0.781   3.978  1.00 10.30           C  
ATOM    685  C   THR A  89      45.516  -1.471   5.060  1.00  9.36           C  
ATOM    686  O   THR A  89      46.176  -0.845   5.895  1.00 11.24           O  
ATOM    687  CB  THR A  89      44.638   0.729   4.231  1.00 11.25           C  
ATOM    688  OG1 THR A  89      43.770   1.290   3.243  1.00 14.34           O  
ATOM    689  CG2 THR A  89      46.002   1.413   4.144  1.00 12.07           C  
ATOM    690  N   ASP A  90      45.429  -2.784   5.038  1.00 10.60           N  
ATOM    691  CA  ASP A  90      46.172  -3.623   5.984  1.00 11.78           C  
ATOM    692  C   ASP A  90      45.880  -3.374   7.457  1.00 12.30           C  
ATOM    693  O   ASP A  90      46.703  -3.675   8.342  1.00 14.54           O  
ATOM    694  CB  ASP A  90      47.673  -3.523   5.723  1.00 12.18           C  
ATOM    695  CG  ASP A  90      48.086  -4.238   4.452  1.00 13.24           C  
ATOM    696  OD1 ASP A  90      47.751  -5.438   4.324  1.00 15.73           O  
ATOM    697  OD2 ASP A  90      48.755  -3.628   3.587  1.00 14.18           O  
ATOM    698  N   SER A  91      44.668  -2.884   7.701  1.00 11.14           N  
ATOM    699  CA  SER A  91      44.187  -2.620   9.040  1.00 11.02           C  
ATOM    700  C   SER A  91      42.994  -3.459   9.429  1.00  9.67           C  
ATOM    701  O   SER A  91      42.268  -3.985   8.573  1.00 13.02           O  
ATOM    702  CB  SER A  91      43.772  -1.155   9.151  1.00 12.95           C  
ATOM    703  OG  SER A  91      44.915  -0.324   9.161  1.00 18.33           O  
ATOM    704  N   HIS A  92      42.779  -3.563  10.739  1.00 10.49           N  
ATOM    705  CA  HIS A  92      41.609  -4.242  11.279  1.00 10.70           C  
ATOM    706  C   HIS A  92      40.480  -3.244  11.155  1.00 11.53           C  
ATOM    707  O   HIS A  92      40.702  -2.028  11.348  1.00 12.37           O  
ATOM    708  CB  HIS A  92      41.760  -4.498  12.771  1.00 12.29           C  
ATOM    709  CG  HIS A  92      42.879  -5.414  13.120  1.00 13.68           C  
ATOM    710  ND1 HIS A  92      42.772  -6.784  13.026  1.00 13.55           N  
ATOM    711  CD2 HIS A  92      44.134  -5.156  13.556  1.00 15.23           C  
ATOM    712  CE1 HIS A  92      43.919  -7.334  13.383  1.00 15.25           C  
ATOM    713  NE2 HIS A  92      44.761  -6.369  13.706  1.00 15.06           N  
ATOM    714  N   CYS A  93      39.283  -3.711  10.830  1.00 10.11           N  
ATOM    715  CA  CYS A  93      38.156  -2.795  10.754  1.00  9.32           C  
ATOM    716  C   CYS A  93      36.929  -3.382  11.414  1.00  9.89           C  
ATOM    717  O   CYS A  93      36.421  -4.432  11.011  1.00 11.65           O  
ATOM    718  CB  CYS A  93      37.892  -2.476   9.291  1.00  8.65           C  
ATOM    719  SG  CYS A  93      36.580  -1.256   9.007  1.00 12.35           S  
ATOM    720  N   PHE A  94      36.448  -2.703  12.451  1.00  9.18           N  
ATOM    721  CA  PHE A  94      35.269  -3.147  13.192  1.00  8.75           C  
ATOM    722  C   PHE A  94      34.141  -2.180  12.917  1.00  9.36           C  
ATOM    723  O   PHE A  94      34.356  -0.976  12.917  1.00  9.08           O  
ATOM    724  CB  PHE A  94      35.555  -3.156  14.699  1.00  8.45           C  
ATOM    725  CG  PHE A  94      36.741  -4.008  15.119  1.00  9.56           C  
ATOM    726  CD1 PHE A  94      36.552  -5.275  15.657  1.00  9.86           C  
ATOM    727  CD2 PHE A  94      38.034  -3.500  15.019  1.00  9.41           C  
ATOM    728  CE1 PHE A  94      37.659  -6.032  16.103  1.00 10.40           C  
ATOM    729  CE2 PHE A  94      39.141  -4.246  15.452  1.00 10.26           C  
ATOM    730  CZ  PHE A  94      38.943  -5.521  16.001  1.00 10.29           C  
ATOM    731  N   LEU A  95      32.940  -2.711  12.734  1.00  9.73           N  
ATOM    732  CA  LEU A  95      31.804  -1.847  12.409  1.00  9.31           C  
ATOM    733  C   LEU A  95      30.636  -2.263  13.286  1.00 11.53           C  
ATOM    734  O   LEU A  95      30.154  -3.383  13.181  1.00 13.84           O  
ATOM    735  CB  LEU A  95      31.449  -2.057  10.925  1.00 15.42           C  
ATOM    736  CG  LEU A  95      30.470  -1.189  10.167  1.00 20.90           C  
ATOM    737  CD1 LEU A  95      30.540  -1.632   8.725  1.00 20.89           C  
ATOM    738  CD2 LEU A  95      29.054  -1.346  10.680  1.00 21.32           C  
ATOM    739  N   LYS A  96      30.159  -1.346  14.115  1.00  9.44           N  
ATOM    740  CA  LYS A  96      29.047  -1.644  15.003  1.00 10.01           C  
ATOM    741  C   LYS A  96      27.883  -0.741  14.684  1.00 10.55           C  
ATOM    742  O   LYS A  96      28.048   0.483  14.620  1.00 11.95           O  
ATOM    743  CB  LYS A  96      29.438  -1.421  16.462  1.00 12.66           C  
ATOM    744  CG  LYS A  96      28.252  -1.792  17.426  1.00 15.45           C  
ATOM    745  CD  LYS A  96      28.277  -0.916  18.642  1.00 16.46           C  
ATOM    746  CE  LYS A  96      26.996  -1.119  19.486  1.00 13.58           C  
ATOM    747  NZ  LYS A  96      26.863  -2.498  20.087  1.00 13.50           N  
ATOM    748  N   LEU A  97      26.693  -1.294  14.509  1.00 11.09           N  
ATOM    749  CA  LEU A  97      25.538  -0.478  14.222  1.00 10.83           C  
ATOM    750  C   LEU A  97      25.016   0.205  15.473  1.00 11.45           C  
ATOM    751  O   LEU A  97      24.766  -0.464  16.488  1.00 11.70           O  
ATOM    752  CB  LEU A  97      24.403  -1.332  13.654  1.00 14.34           C  
ATOM    753  CG  LEU A  97      24.279  -1.361  12.137  1.00 16.68           C  
ATOM    754  CD1 LEU A  97      23.822   0.016  11.623  1.00 17.08           C  
ATOM    755  CD2 LEU A  97      25.629  -1.796  11.542  1.00 17.49           C  
ATOM    756  N   LEU A  98      24.826   1.521  15.394  1.00 10.46           N  
ATOM    757  CA  LEU A  98      24.268   2.310  16.500  1.00  9.87           C  
ATOM    758  C   LEU A  98      22.794   2.660  16.275  1.00 11.87           C  
ATOM    759  O   LEU A  98      22.078   2.923  17.237  1.00 13.21           O  
ATOM    760  CB  LEU A  98      25.064   3.613  16.683  1.00 11.25           C  
ATOM    761  CG  LEU A  98      26.545   3.493  17.074  1.00  9.59           C  
ATOM    762  CD1 LEU A  98      27.167   4.873  17.218  1.00 10.39           C  
ATOM    763  CD2 LEU A  98      26.653   2.676  18.361  1.00 10.84           C  
ATOM    764  N   GLN A  99      22.352   2.697  15.012  1.00 10.17           N  
ATOM    765  CA  GLN A  99      20.977   3.036  14.663  1.00 10.34           C  
ATOM    766  C   GLN A  99      20.709   2.569  13.242  1.00 10.77           C  
ATOM    767  O   GLN A  99      21.554   2.738  12.351  1.00  9.77           O  
ATOM    768  CB  GLN A  99      20.789   4.534  14.705  1.00  9.92           C  
ATOM    769  CG  GLN A  99      19.433   5.050  14.169  1.00 12.57           C  
ATOM    770  CD  GLN A  99      19.423   6.568  14.093  1.00 15.52           C  
ATOM    771  OE1 GLN A  99      19.499   7.240  15.126  1.00 18.40           O  
ATOM    772  NE2 GLN A  99      19.374   7.118  12.869  1.00 17.52           N  
ATOM    773  N   GLY A 100      19.541   1.969  13.027  1.00 12.46           N  
ATOM    774  CA  GLY A 100      19.180   1.515  11.688  1.00 11.73           C  
ATOM    775  C   GLY A 100      19.790   0.194  11.277  1.00 10.84           C  
ATOM    776  O   GLY A 100      20.218  -0.598  12.124  1.00 12.94           O  
ATOM    777  N   ASN A 101      19.873  -0.024   9.964  1.00 11.82           N  
ATOM    778  CA  ASN A 101      20.417  -1.268   9.439  1.00 12.46           C  
ATOM    779  C   ASN A 101      21.314  -0.942   8.260  1.00 11.50           C  
ATOM    780  O   ASN A 101      21.078   0.030   7.552  1.00 12.72           O  
ATOM    781  CB  ASN A 101      19.288  -2.145   8.883  1.00 14.08           C  
ATOM    782  CG  ASN A 101      18.303  -2.607   9.945  1.00 16.01           C  
ATOM    783  OD1 ASN A 101      18.588  -3.498  10.754  1.00 18.62           O  
ATOM    784  ND2 ASN A 101      17.131  -2.001   9.937  1.00 19.96           N  
ATOM    785  N   LEU A 102      22.326  -1.770   8.035  1.00 10.97           N  
ATOM    786  CA  LEU A 102      23.189  -1.596   6.878  1.00 10.34           C  
ATOM    787  C   LEU A 102      23.345  -2.928   6.173  1.00 11.48           C  
ATOM    788  O   LEU A 102      23.413  -3.957   6.834  1.00 13.30           O  
ATOM    789  CB  LEU A 102      24.582  -1.096   7.297  1.00  9.84           C  
ATOM    790  CG  LEU A 102      24.663   0.328   7.838  1.00  9.97           C  
ATOM    791  CD1 LEU A 102      26.027   0.563   8.448  1.00  9.90           C  
ATOM    792  CD2 LEU A 102      24.425   1.323   6.714  1.00 10.21           C  
ATOM    793  N   LYS A 103      23.414  -2.897   4.848  1.00  9.85           N  
ATOM    794  CA  LYS A 103      23.638  -4.129   4.076  1.00 10.45           C  
ATOM    795  C   LYS A 103      25.151  -4.227   3.798  1.00 11.03           C  
ATOM    796  O   LYS A 103      25.750  -3.272   3.268  1.00 10.84           O  
ATOM    797  CB  LYS A 103      22.897  -4.064   2.752  1.00 12.61           C  
ATOM    798  CG  LYS A 103      23.192  -5.245   1.819  1.00 15.02           C  
ATOM    799  CD  LYS A 103      22.546  -4.959   0.455  1.00 17.74           C  
ATOM    800  CE  LYS A 103      22.672  -6.071  -0.527  1.00 22.87           C  
ATOM    801  NZ  LYS A 103      22.018  -5.608  -1.801  1.00 22.86           N  
ATOM    802  N   GLU A 104      25.765  -5.348   4.166  1.00 10.51           N  
ATOM    803  CA  GLU A 104      27.186  -5.549   3.905  1.00 10.40           C  
ATOM    804  C   GLU A 104      27.291  -6.612   2.823  1.00 11.61           C  
ATOM    805  O   GLU A 104      26.738  -7.716   2.986  1.00 13.24           O  
ATOM    806  CB  GLU A 104      27.928  -6.053   5.157  1.00 10.82           C  
ATOM    807  CG  GLU A 104      29.455  -6.146   4.899  1.00 11.21           C  
ATOM    808  CD  GLU A 104      30.230  -6.840   6.018  1.00 14.31           C  
ATOM    809  OE1 GLU A 104      29.639  -7.686   6.705  1.00 17.51           O  
ATOM    810  OE2 GLU A 104      31.434  -6.546   6.201  1.00 13.49           O  
ATOM    811  N   THR A 105      27.971  -6.294   1.732  1.00 10.53           N  
ATOM    812  CA  THR A 105      28.153  -7.245   0.635  1.00 12.82           C  
ATOM    813  C   THR A 105      29.641  -7.549   0.579  1.00 13.17           C  
ATOM    814  O   THR A 105      30.458  -6.626   0.540  1.00 12.75           O  
ATOM    815  CB  THR A 105      27.701  -6.632  -0.683  1.00 12.15           C  
ATOM    816  OG1 THR A 105      26.311  -6.260  -0.578  1.00 14.48           O  
ATOM    817  CG2 THR A 105      27.834  -7.644  -1.804  1.00 13.31           C  
ATOM    818  N   LEU A 106      29.986  -8.833   0.578  1.00 12.88           N  
ATOM    819  CA  LEU A 106      31.400  -9.244   0.560  1.00 13.59           C  
ATOM    820  C   LEU A 106      31.871  -9.633  -0.837  1.00 13.17           C  
ATOM    821  O   LEU A 106      31.122 -10.230  -1.610  1.00 15.11           O  
ATOM    822  CB  LEU A 106      31.604 -10.435   1.504  1.00 15.77           C  
ATOM    823  CG  LEU A 106      31.144 -10.271   2.949  1.00 17.85           C  
ATOM    824  CD1 LEU A 106      31.590 -11.476   3.788  1.00 21.19           C  
ATOM    825  CD2 LEU A 106      31.702  -8.990   3.522  1.00 19.71           C  
ATOM    826  N   PHE A 107      33.101  -9.272  -1.160  1.00 11.98           N  
ATOM    827  CA  PHE A 107      33.682  -9.599  -2.461  1.00 13.47           C  
ATOM    828  C   PHE A 107      35.084 -10.139  -2.268  1.00 15.42           C  
ATOM    829  O   PHE A 107      35.783  -9.763  -1.329  1.00 14.75           O  
ATOM    830  CB  PHE A 107      33.801  -8.361  -3.334  1.00 13.22           C  
ATOM    831  CG  PHE A 107      32.485  -7.772  -3.763  1.00 13.08           C  
ATOM    832  CD1 PHE A 107      31.937  -8.076  -5.000  1.00 13.56           C  
ATOM    833  CD2 PHE A 107      31.822  -6.863  -2.953  1.00 15.05           C  
ATOM    834  CE1 PHE A 107      30.755  -7.477  -5.416  1.00 15.28           C  
ATOM    835  CE2 PHE A 107      30.632  -6.262  -3.381  1.00 13.80           C  
ATOM    836  CZ  PHE A 107      30.114  -6.567  -4.593  1.00 15.97           C  
ATOM    837  N   ASP A 108      35.498 -11.036  -3.152  1.00 15.66           N  
ATOM    838  CA  ASP A 108      36.864 -11.526  -3.071  1.00 17.03           C  
ATOM    839  C   ASP A 108      37.756 -10.507  -3.775  1.00 15.25           C  
ATOM    840  O   ASP A 108      37.286  -9.651  -4.544  1.00 15.80           O  
ATOM    841  CB  ASP A 108      37.012 -12.864  -3.808  1.00 20.25           C  
ATOM    842  CG  ASP A 108      36.500 -14.050  -3.009  1.00 23.17           C  
ATOM    843  OD1 ASP A 108      36.759 -14.149  -1.793  1.00 28.15           O  
ATOM    844  OD2 ASP A 108      35.855 -14.914  -3.625  1.00 28.18           O  
ATOM    845  N   TRP A 109      39.057 -10.568  -3.492  1.00 15.09           N  
ATOM    846  CA  TRP A 109      40.008  -9.703  -4.182  1.00 15.17           C  
ATOM    847  C   TRP A 109      39.999 -10.080  -5.683  1.00 17.01           C  
ATOM    848  O   TRP A 109      40.001 -11.254  -6.040  1.00 17.07           O  
ATOM    849  CB  TRP A 109      41.428  -9.911  -3.634  1.00 13.74           C  
ATOM    850  CG  TRP A 109      41.664  -9.228  -2.328  1.00 12.06           C  
ATOM    851  CD1 TRP A 109      41.423  -9.722  -1.081  1.00 13.33           C  
ATOM    852  CD2 TRP A 109      42.123  -7.890  -2.160  1.00 10.93           C  
ATOM    853  NE1 TRP A 109      41.702  -8.754  -0.134  1.00 11.69           N  
ATOM    854  CE2 TRP A 109      42.132  -7.621  -0.776  1.00 10.31           C  
ATOM    855  CE3 TRP A 109      42.534  -6.892  -3.047  1.00 11.58           C  
ATOM    856  CZ2 TRP A 109      42.533  -6.383  -0.257  1.00 11.62           C  
ATOM    857  CZ3 TRP A 109      42.938  -5.654  -2.534  1.00 12.31           C  
ATOM    858  CH2 TRP A 109      42.933  -5.417  -1.141  1.00 12.40           C  
ATOM    859  N   PRO A 110      39.964  -9.087  -6.570  1.00 19.08           N  
ATOM    860  CA  PRO A 110      39.955  -9.387  -8.006  1.00 21.90           C  
ATOM    861  C   PRO A 110      41.293  -9.936  -8.517  1.00 24.93           C  
ATOM    862  O   PRO A 110      42.327  -9.793  -7.866  1.00 24.31           O  
ATOM    863  CB  PRO A 110      39.627  -8.043  -8.644  1.00 22.73           C  
ATOM    864  CG  PRO A 110      40.158  -7.044  -7.659  1.00 22.39           C  
ATOM    865  CD  PRO A 110      39.771  -7.648  -6.321  1.00 20.19           C  
ATOM    866  N   ASP A 111      41.260 -10.600  -9.662  1.00 28.94           N  
ATOM    867  CA  ASP A 111      42.495 -11.085 -10.279  1.00 33.40           C  
ATOM    868  C   ASP A 111      42.943  -9.918 -11.152  1.00 36.18           C  
ATOM    869  O   ASP A 111      42.198  -8.951 -11.317  1.00 36.88           O  
ATOM    870  CB  ASP A 111      42.245 -12.310 -11.155  1.00 34.36           C  
ATOM    871  CG  ASP A 111      41.789 -13.518 -10.354  1.00 35.04           C  
ATOM    872  OD1 ASP A 111      42.393 -13.824  -9.305  1.00 35.67           O  
ATOM    873  OD2 ASP A 111      40.825 -14.172 -10.787  1.00 37.28           O  
ATOM    874  N   LYS A 112      44.141  -9.990 -11.714  1.00 38.93           N  
ATOM    875  CA  LYS A 112      44.629  -8.895 -12.545  1.00 41.54           C  
ATOM    876  C   LYS A 112      43.774  -8.690 -13.797  1.00 42.05           C  
ATOM    877  O   LYS A 112      43.651  -7.574 -14.298  1.00 42.03           O  
ATOM    878  CB  LYS A 112      46.096  -9.130 -12.924  1.00 43.86           C  
ATOM    879  CG  LYS A 112      47.064  -9.045 -11.730  1.00 47.11           C  
ATOM    880  CD  LYS A 112      48.534  -9.217 -12.145  1.00 49.19           C  
ATOM    881  CE  LYS A 112      49.466  -9.121 -10.938  1.00 50.84           C  
ATOM    882  NZ  LYS A 112      50.905  -9.359 -11.283  1.00 51.45           N  
ATOM    883  N   LYS A 113      43.163  -9.762 -14.285  1.00 42.18           N  
ATOM    884  CA  LYS A 113      42.328  -9.683 -15.477  1.00 42.47           C  
ATOM    885  C   LYS A 113      41.019  -8.951 -15.196  1.00 42.03           C  
ATOM    886  O   LYS A 113      40.406  -9.154 -14.148  1.00 42.00           O  
ATOM    887  CB  LYS A 113      42.027 -11.089 -15.993  1.00 43.97           C  
ATOM    888  CG  LYS A 113      41.054 -11.134 -17.160  1.00 45.91           C  
ATOM    889  CD  LYS A 113      40.848 -12.561 -17.640  1.00 47.13           C  
ATOM    890  CE  LYS A 113      39.892 -12.613 -18.819  1.00 48.65           C  
ATOM    891  NZ  LYS A 113      39.734 -14.003 -19.349  1.00 50.09           N  
ATOM    892  N   SER A 114      40.597  -8.098 -16.129  1.00 40.54           N  
ATOM    893  CA  SER A 114      39.348  -7.363 -15.968  1.00 39.40           C  
ATOM    894  C   SER A 114      38.187  -8.337 -15.981  1.00 38.24           C  
ATOM    895  O   SER A 114      38.075  -9.185 -16.868  1.00 38.23           O  
ATOM    896  CB  SER A 114      39.157  -6.347 -17.084  1.00 39.71           C  
ATOM    897  OG  SER A 114      37.812  -5.904 -17.099  1.00 40.57           O  
ATOM    898  N   ASN A 115      37.307  -8.203 -15.003  1.00 36.81           N  
ATOM    899  CA  ASN A 115      36.180  -9.101 -14.897  1.00 35.97           C  
ATOM    900  C   ASN A 115      35.168  -8.525 -13.925  1.00 34.23           C  
ATOM    901  O   ASN A 115      35.506  -7.687 -13.102  1.00 33.73           O  
ATOM    902  CB  ASN A 115      36.683 -10.450 -14.392  1.00 38.70           C  
ATOM    903  CG  ASN A 115      35.762 -11.573 -14.742  1.00 41.53           C  
ATOM    904  OD1 ASN A 115      34.775 -11.832 -14.044  1.00 44.37           O  
ATOM    905  ND2 ASN A 115      36.063 -12.254 -15.846  1.00 43.38           N  
ATOM    906  N   GLU A 116      33.923  -8.963 -14.037  1.00 32.59           N  
ATOM    907  CA  GLU A 116      32.873  -8.495 -13.140  1.00 30.72           C  
ATOM    908  C   GLU A 116      33.158  -9.025 -11.730  1.00 28.31           C  
ATOM    909  O   GLU A 116      33.503 -10.192 -11.553  1.00 25.58           O  
ATOM    910  CB  GLU A 116      31.514  -9.031 -13.597  1.00 32.82           C  
ATOM    911  CG  GLU A 116      30.361  -8.656 -12.690  1.00 36.96           C  
ATOM    912  CD  GLU A 116      29.667  -7.397 -13.146  1.00 40.24           C  
ATOM    913  OE1 GLU A 116      30.374  -6.410 -13.436  1.00 42.56           O  
ATOM    914  OE2 GLU A 116      28.416  -7.389 -13.215  1.00 42.97           O  
ATOM    915  N   MET A 117      33.027  -8.169 -10.726  1.00 26.48           N  
ATOM    916  CA  MET A 117      33.248  -8.633  -9.369  1.00 24.95           C  
ATOM    917  C   MET A 117      31.922  -9.209  -8.908  1.00 25.70           C  
ATOM    918  O   MET A 117      30.930  -8.485  -8.750  1.00 25.31           O  
ATOM    919  CB  MET A 117      33.674  -7.473  -8.465  1.00 21.71           C  
ATOM    920  CG  MET A 117      34.922  -6.740  -8.947  1.00 18.25           C  
ATOM    921  SD  MET A 117      35.432  -5.383  -7.822  1.00 16.72           S  
ATOM    922  CE  MET A 117      35.870  -6.323  -6.321  1.00 15.61           C  
ATOM    923  N   ILE A 118      31.889 -10.515  -8.701  1.00 25.56           N  
ATOM    924  CA  ILE A 118      30.660 -11.156  -8.274  1.00 26.37           C  
ATOM    925  C   ILE A 118      30.636 -11.319  -6.759  1.00 25.27           C  
ATOM    926  O   ILE A 118      31.558 -11.870  -6.166  1.00 24.46           O  
ATOM    927  CB  ILE A 118      30.510 -12.506  -8.981  1.00 26.89           C  
ATOM    928  CG1 ILE A 118      30.495 -12.262 -10.488  1.00 28.27           C  
ATOM    929  CG2 ILE A 118      29.254 -13.218  -8.521  1.00 28.77           C  
ATOM    930  CD1 ILE A 118      29.436 -11.296 -10.919  1.00 29.12           C  
ATOM    931  N   LYS A 119      29.570 -10.838  -6.127  1.00 25.41           N  
ATOM    932  CA  LYS A 119      29.513 -10.927  -4.678  1.00 25.23           C  
ATOM    933  C   LYS A 119      29.583 -12.344  -4.150  1.00 25.04           C  
ATOM    934  O   LYS A 119      29.040 -13.270  -4.764  1.00 23.95           O  
ATOM    935  CB  LYS A 119      28.258 -10.210  -4.157  1.00 26.59           C  
ATOM    936  CG  LYS A 119      26.938 -10.765  -4.650  1.00 29.21           C  
ATOM    937  CD  LYS A 119      25.827  -9.724  -4.511  1.00 31.91           C  
ATOM    938  CE  LYS A 119      26.077  -8.513  -5.446  1.00 33.83           C  
ATOM    939  NZ  LYS A 119      25.019  -7.433  -5.426  1.00 35.46           N  
ATOM    940  N   LYS A 120      30.286 -12.521  -3.028  1.00 23.83           N  
ATOM    941  CA  LYS A 120      30.410 -13.829  -2.387  1.00 24.77           C  
ATOM    942  C   LYS A 120      29.195 -14.058  -1.506  1.00 24.24           C  
ATOM    943  O   LYS A 120      28.665 -15.161  -1.426  1.00 25.19           O  
ATOM    944  CB  LYS A 120      31.658 -13.900  -1.514  1.00 26.68           C  
ATOM    945  CG  LYS A 120      32.941 -13.654  -2.240  1.00 32.01           C  
ATOM    946  CD  LYS A 120      34.035 -13.214  -1.256  1.00 35.06           C  
ATOM    947  CE  LYS A 120      34.417 -14.336  -0.297  1.00 36.34           C  
ATOM    948  NZ  LYS A 120      33.395 -14.560   0.745  1.00 37.36           N  
ATOM    949  N   SER A 121      28.733 -13.002  -0.845  1.00 22.52           N  
ATOM    950  CA  SER A 121      27.583 -13.128   0.036  1.00 20.27           C  
ATOM    951  C   SER A 121      27.181 -11.746   0.487  1.00 19.51           C  
ATOM    952  O   SER A 121      27.851 -10.763   0.160  1.00 17.19           O  
ATOM    953  CB  SER A 121      27.919 -13.959   1.272  1.00 20.67           C  
ATOM    954  OG  SER A 121      28.938 -13.343   2.048  1.00 21.19           O  
ATOM    955  N   GLU A 122      26.075 -11.682   1.215  1.00 18.73           N  
ATOM    956  CA  GLU A 122      25.603 -10.407   1.724  1.00 19.30           C  
ATOM    957  C   GLU A 122      24.837 -10.665   2.993  1.00 20.04           C  
ATOM    958  O   GLU A 122      24.351 -11.776   3.239  1.00 18.58           O  
ATOM    959  CB  GLU A 122      24.713  -9.674   0.700  1.00 21.50           C  
ATOM    960  CG  GLU A 122      23.405 -10.364   0.378  1.00 25.47           C  
ATOM    961  CD  GLU A 122      22.585  -9.583  -0.623  1.00 27.49           C  
ATOM    962  OE1 GLU A 122      23.114  -9.239  -1.703  1.00 30.89           O  
ATOM    963  OE2 GLU A 122      21.407  -9.319  -0.335  1.00 30.87           O  
ATOM    964  N   ARG A 123      24.760  -9.652   3.834  1.00 18.93           N  
ATOM    965  CA  ARG A 123      24.022  -9.801   5.057  1.00 18.91           C  
ATOM    966  C   ARG A 123      23.560  -8.462   5.561  1.00 18.50           C  
ATOM    967  O   ARG A 123      24.091  -7.406   5.183  1.00 17.95           O  
ATOM    968  CB  ARG A 123      24.859 -10.490   6.122  1.00 19.97           C  
ATOM    969  CG  ARG A 123      26.087  -9.735   6.494  1.00 19.02           C  
ATOM    970  CD  ARG A 123      26.793 -10.430   7.622  1.00 22.04           C  
ATOM    971  NE  ARG A 123      28.096  -9.806   7.807  1.00 21.25           N  
ATOM    972  CZ  ARG A 123      28.913 -10.036   8.836  1.00 22.60           C  
ATOM    973  NH1 ARG A 123      28.579 -10.878   9.808  1.00 21.70           N  
ATOM    974  NH2 ARG A 123      30.090  -9.445   8.864  1.00 19.58           N  
ATOM    975  N   THR A 124      22.545  -8.506   6.413  1.00 16.91           N  
ATOM    976  CA  THR A 124      22.011  -7.293   6.976  1.00 16.86           C  
ATOM    977  C   THR A 124      22.530  -7.147   8.396  1.00 16.57           C  
ATOM    978  O   THR A 124      22.349  -8.024   9.239  1.00 16.79           O  
ATOM    979  CB  THR A 124      20.470  -7.304   6.965  1.00 18.59           C  
ATOM    980  OG1 THR A 124      20.020  -7.293   5.607  1.00 21.09           O  
ATOM    981  CG2 THR A 124      19.929  -6.082   7.696  1.00 19.91           C  
ATOM    982  N   LEU A 125      23.228  -6.040   8.649  1.00 15.41           N  
ATOM    983  CA  LEU A 125      23.759  -5.785   9.973  1.00 14.88           C  
ATOM    984  C   LEU A 125      22.681  -4.980  10.676  1.00 14.88           C  
ATOM    985  O   LEU A 125      22.185  -3.979  10.154  1.00 15.50           O  
ATOM    986  CB  LEU A 125      25.082  -5.005   9.881  1.00 15.56           C  
ATOM    987  CG  LEU A 125      26.198  -5.612   9.044  1.00 16.44           C  
ATOM    988  CD1 LEU A 125      27.348  -4.620   8.988  1.00 16.86           C  
ATOM    989  CD2 LEU A 125      26.691  -6.932   9.647  1.00 17.68           C  
ATOM    990  N   ARG A 126      22.319  -5.425  11.874  1.00 16.86           N  
ATOM    991  CA  ARG A 126      21.254  -4.772  12.612  1.00 16.15           C  
ATOM    992  C   ARG A 126      21.745  -4.013  13.831  1.00 15.09           C  
ATOM    993  O   ARG A 126      22.901  -4.144  14.218  1.00 14.81           O  
ATOM    994  CB  ARG A 126      20.220  -5.830  12.984  1.00 19.78           C  
ATOM    995  CG  ARG A 126      19.664  -6.490  11.718  1.00 20.71           C  
ATOM    996  CD  ARG A 126      18.562  -7.468  12.006  1.00 21.59           C  
ATOM    997  NE  ARG A 126      18.099  -8.097  10.772  1.00 21.78           N  
ATOM    998  CZ  ARG A 126      17.384  -7.488   9.833  1.00 22.00           C  
ATOM    999  NH1 ARG A 126      17.043  -6.202   9.967  1.00 22.14           N  
ATOM   1000  NH2 ARG A 126      16.975  -8.181   8.770  1.00 22.89           N  
ATOM   1001  N   GLU A 127      20.851  -3.214  14.411  1.00 17.65           N  
ATOM   1002  CA  GLU A 127      21.169  -2.395  15.569  1.00 18.04           C  
ATOM   1003  C   GLU A 127      21.936  -3.192  16.620  1.00 16.98           C  
ATOM   1004  O   GLU A 127      21.534  -4.292  16.997  1.00 15.83           O  
ATOM   1005  CB  GLU A 127      19.865  -1.820  16.152  1.00 20.00           C  
ATOM   1006  CG  GLU A 127      19.968  -1.068  17.466  1.00 26.63           C  
ATOM   1007  CD  GLU A 127      18.575  -0.648  17.962  1.00 29.23           C  
ATOM   1008  OE1 GLU A 127      18.034   0.331  17.426  1.00 28.46           O  
ATOM   1009  OE2 GLU A 127      18.005  -1.322  18.868  1.00 31.72           O  
ATOM   1010  N   ASN A 128      23.059  -2.605  17.036  1.00 15.72           N  
ATOM   1011  CA  ASN A 128      23.982  -3.086  18.052  1.00 15.02           C  
ATOM   1012  C   ASN A 128      24.903  -4.217  17.653  1.00 13.77           C  
ATOM   1013  O   ASN A 128      25.808  -4.557  18.393  1.00 16.04           O  
ATOM   1014  CB  ASN A 128      23.233  -3.428  19.337  1.00 14.46           C  
ATOM   1015  CG  ASN A 128      22.917  -2.198  20.170  1.00 14.47           C  
ATOM   1016  OD1 ASN A 128      21.775  -2.018  20.636  1.00 18.46           O  
ATOM   1017  ND2 ASN A 128      23.910  -1.355  20.380  1.00  9.93           N  
ATOM   1018  N   GLN A 129      24.721  -4.752  16.457  1.00 14.93           N  
ATOM   1019  CA  GLN A 129      25.613  -5.824  15.996  1.00 15.26           C  
ATOM   1020  C   GLN A 129      26.986  -5.248  15.583  1.00 16.68           C  
ATOM   1021  O   GLN A 129      27.039  -4.109  15.121  1.00 16.13           O  
ATOM   1022  CB  GLN A 129      24.973  -6.528  14.793  1.00 16.50           C  
ATOM   1023  CG  GLN A 129      25.898  -7.576  14.189  1.00 19.83           C  
ATOM   1024  CD  GLN A 129      25.243  -8.291  13.047  1.00 21.93           C  
ATOM   1025  OE1 GLN A 129      24.093  -7.971  12.684  1.00 23.74           O  
ATOM   1026  NE2 GLN A 129      25.960  -9.271  12.454  1.00 21.22           N  
ATOM   1027  N   CYS A 130      28.085  -5.990  15.788  1.00 18.45           N  
ATOM   1028  CA  CYS A 130      29.402  -5.520  15.359  1.00 16.84           C  
ATOM   1029  C   CYS A 130      30.006  -6.512  14.377  1.00 17.75           C  
ATOM   1030  O   CYS A 130      30.179  -7.698  14.704  1.00 19.69           O  
ATOM   1031  CB  CYS A 130      30.375  -5.337  16.545  1.00 18.85           C  
ATOM   1032  SG  CYS A 130      32.083  -4.698  16.134  1.00 19.21           S  
ATOM   1033  N   ALA A 131      30.331  -6.021  13.181  1.00 14.31           N  
ATOM   1034  CA  ALA A 131      30.964  -6.831  12.132  1.00 13.81           C  
ATOM   1035  C   ALA A 131      32.456  -6.552  12.117  1.00 12.44           C  
ATOM   1036  O   ALA A 131      32.922  -5.549  12.662  1.00 13.28           O  
ATOM   1037  CB  ALA A 131      30.371  -6.499  10.769  1.00 12.90           C  
ATOM   1038  N   TYR A 132      33.205  -7.450  11.479  1.00 10.81           N  
ATOM   1039  CA  TYR A 132      34.650  -7.312  11.385  1.00  9.84           C  
ATOM   1040  C   TYR A 132      35.116  -7.674   9.987  1.00  9.81           C  
ATOM   1041  O   TYR A 132      34.566  -8.598   9.341  1.00 10.64           O  
ATOM   1042  CB  TYR A 132      35.317  -8.286  12.377  1.00 11.28           C  
ATOM   1043  CG  TYR A 132      36.827  -8.339  12.255  1.00 11.11           C  
ATOM   1044  CD1 TYR A 132      37.634  -7.301  12.732  1.00 12.35           C  
ATOM   1045  CD2 TYR A 132      37.452  -9.418  11.624  1.00 11.37           C  
ATOM   1046  CE1 TYR A 132      39.003  -7.334  12.583  1.00 11.74           C  
ATOM   1047  CE2 TYR A 132      38.825  -9.460  11.474  1.00 12.19           C  
ATOM   1048  CZ  TYR A 132      39.600  -8.413  11.957  1.00 13.22           C  
ATOM   1049  OH  TYR A 132      40.969  -8.429  11.841  1.00 13.19           O  
ATOM   1050  N   ILE A 133      36.118  -6.949   9.510  1.00 10.43           N  
ATOM   1051  CA  ILE A 133      36.711  -7.274   8.223  1.00 11.00           C  
ATOM   1052  C   ILE A 133      38.177  -6.865   8.217  1.00 11.00           C  
ATOM   1053  O   ILE A 133      38.607  -6.005   8.993  1.00 10.54           O  
ATOM   1054  CB  ILE A 133      35.962  -6.591   7.040  1.00 11.24           C  
ATOM   1055  CG1 ILE A 133      36.446  -7.192   5.708  1.00 10.57           C  
ATOM   1056  CG2 ILE A 133      36.169  -5.077   7.082  1.00 12.79           C  
ATOM   1057  CD1 ILE A 133      35.531  -6.815   4.530  1.00 12.79           C  
ATOM   1058  N   ASN A 134      38.966  -7.565   7.408  1.00 10.35           N  
ATOM   1059  CA  ASN A 134      40.356  -7.196   7.205  1.00 11.51           C  
ATOM   1060  C   ASN A 134      40.692  -7.664   5.787  1.00 11.88           C  
ATOM   1061  O   ASN A 134      39.928  -8.422   5.200  1.00 12.29           O  
ATOM   1062  CB  ASN A 134      41.295  -7.798   8.260  1.00 14.68           C  
ATOM   1063  CG  ASN A 134      41.358  -9.282   8.206  1.00 19.26           C  
ATOM   1064  OD1 ASN A 134      41.407  -9.872   7.134  1.00 21.29           O  
ATOM   1065  ND2 ASN A 134      41.389  -9.917   9.379  1.00 20.10           N  
ATOM   1066  N   ASP A 135      41.782  -7.169   5.224  1.00 11.84           N  
ATOM   1067  CA  ASP A 135      42.142  -7.542   3.861  1.00 12.21           C  
ATOM   1068  C   ASP A 135      42.361  -9.046   3.645  1.00 14.51           C  
ATOM   1069  O   ASP A 135      42.141  -9.536   2.542  1.00 14.37           O  
ATOM   1070  CB  ASP A 135      43.383  -6.775   3.414  1.00 11.64           C  
ATOM   1071  CG  ASP A 135      43.138  -5.302   3.220  1.00 12.32           C  
ATOM   1072  OD1 ASP A 135      41.954  -4.849   3.186  1.00  9.69           O  
ATOM   1073  OD2 ASP A 135      44.145  -4.566   3.065  1.00 12.29           O  
ATOM   1074  N   SER A 136      42.730  -9.779   4.692  1.00 14.97           N  
ATOM   1075  CA  SER A 136      42.953 -11.211   4.517  1.00 17.21           C  
ATOM   1076  C   SER A 136      41.629 -11.908   4.231  1.00 18.86           C  
ATOM   1077  O   SER A 136      41.596 -12.937   3.556  1.00 21.70           O  
ATOM   1078  CB  SER A 136      43.595 -11.805   5.769  1.00 18.86           C  
ATOM   1079  OG  SER A 136      42.689 -11.766   6.864  1.00 25.76           O  
ATOM   1080  N   ILE A 137      40.532 -11.346   4.736  1.00 16.49           N  
ATOM   1081  CA  ILE A 137      39.205 -11.918   4.533  1.00 17.02           C  
ATOM   1082  C   ILE A 137      38.669 -11.530   3.157  1.00 18.02           C  
ATOM   1083  O   ILE A 137      38.167 -12.385   2.411  1.00 21.26           O  
ATOM   1084  CB  ILE A 137      38.218 -11.432   5.612  1.00 17.89           C  
ATOM   1085  CG1 ILE A 137      38.727 -11.861   6.991  1.00 18.66           C  
ATOM   1086  CG2 ILE A 137      36.812 -12.023   5.372  1.00 21.33           C  
ATOM   1087  CD1 ILE A 137      37.883 -11.320   8.155  1.00 19.94           C  
ATOM   1088  N   GLY A 138      38.797 -10.258   2.795  1.00 14.74           N  
ATOM   1089  CA  GLY A 138      38.264  -9.833   1.508  1.00 13.46           C  
ATOM   1090  C   GLY A 138      37.912  -8.364   1.515  1.00 11.63           C  
ATOM   1091  O   GLY A 138      38.441  -7.621   2.346  1.00 13.17           O  
ATOM   1092  N   LEU A 139      37.054  -7.957   0.581  1.00 11.80           N  
ATOM   1093  CA  LEU A 139      36.623  -6.580   0.401  1.00 11.31           C  
ATOM   1094  C   LEU A 139      35.134  -6.541   0.720  1.00 10.35           C  
ATOM   1095  O   LEU A 139      34.462  -7.594   0.818  1.00 12.45           O  
ATOM   1096  CB  LEU A 139      36.800  -6.151  -1.065  1.00 10.29           C  
ATOM   1097  CG  LEU A 139      38.167  -6.411  -1.718  1.00 10.85           C  
ATOM   1098  CD1 LEU A 139      38.102  -6.168  -3.232  1.00 11.14           C  
ATOM   1099  CD2 LEU A 139      39.157  -5.480  -1.045  1.00 10.77           C  
ATOM   1100  N   HIS A 140      34.608  -5.327   0.898  1.00 11.37           N  
ATOM   1101  CA  HIS A 140      33.162  -5.219   1.081  1.00  9.57           C  
ATOM   1102  C   HIS A 140      32.620  -3.878   0.647  1.00 10.01           C  
ATOM   1103  O   HIS A 140      33.369  -2.933   0.397  1.00  9.61           O  
ATOM   1104  CB  HIS A 140      32.723  -5.499   2.539  1.00 11.36           C  
ATOM   1105  CG  HIS A 140      33.042  -4.411   3.525  1.00 10.51           C  
ATOM   1106  ND1 HIS A 140      32.672  -4.508   4.848  1.00 10.59           N  
ATOM   1107  CD2 HIS A 140      33.725  -3.251   3.404  1.00 10.00           C  
ATOM   1108  CE1 HIS A 140      33.130  -3.449   5.503  1.00  9.12           C  
ATOM   1109  NE2 HIS A 140      33.769  -2.674   4.648  1.00  9.90           N  
ATOM   1110  N   ARG A 141      31.294  -3.831   0.524  1.00 10.33           N  
ATOM   1111  CA  ARG A 141      30.567  -2.594   0.249  1.00 10.57           C  
ATOM   1112  C   ARG A 141      29.593  -2.526   1.441  1.00 10.24           C  
ATOM   1113  O   ARG A 141      29.111  -3.567   1.928  1.00 10.79           O  
ATOM   1114  CB  ARG A 141      29.769  -2.674  -1.060  1.00 12.97           C  
ATOM   1115  CG  ARG A 141      29.130  -1.336  -1.449  1.00 16.30           C  
ATOM   1116  CD  ARG A 141      28.054  -1.447  -2.488  1.00 19.85           C  
ATOM   1117  NE  ARG A 141      28.492  -1.871  -3.814  1.00 23.07           N  
ATOM   1118  CZ  ARG A 141      29.103  -1.089  -4.704  1.00 22.97           C  
ATOM   1119  NH1 ARG A 141      29.389   0.184  -4.426  1.00 22.37           N  
ATOM   1120  NH2 ARG A 141      29.371  -1.568  -5.917  1.00 23.29           N  
ATOM   1121  N   VAL A 142      29.328  -1.329   1.937  1.00  9.35           N  
ATOM   1122  CA  VAL A 142      28.383  -1.171   3.046  1.00  8.69           C  
ATOM   1123  C   VAL A 142      27.349  -0.164   2.551  1.00  9.03           C  
ATOM   1124  O   VAL A 142      27.716   0.892   2.054  1.00 11.23           O  
ATOM   1125  CB  VAL A 142      29.098  -0.649   4.318  1.00  9.50           C  
ATOM   1126  CG1 VAL A 142      28.109  -0.426   5.418  1.00 11.33           C  
ATOM   1127  CG2 VAL A 142      30.112  -1.730   4.803  1.00 10.72           C  
ATOM   1128  N   GLU A 143      26.059  -0.456   2.717  1.00  8.92           N  
ATOM   1129  CA  GLU A 143      25.038   0.450   2.157  1.00 10.63           C  
ATOM   1130  C   GLU A 143      23.837   0.570   3.058  1.00 10.09           C  
ATOM   1131  O   GLU A 143      23.438  -0.411   3.694  1.00 10.76           O  
ATOM   1132  CB  GLU A 143      24.484  -0.133   0.851  1.00 13.95           C  
ATOM   1133  CG  GLU A 143      25.474  -0.326  -0.260  1.00 16.12           C  
ATOM   1134  CD  GLU A 143      24.858  -1.108  -1.419  1.00 19.67           C  
ATOM   1135  OE1 GLU A 143      24.770  -2.348  -1.302  1.00 17.11           O  
ATOM   1136  OE2 GLU A 143      24.448  -0.471  -2.429  1.00 25.09           O  
ATOM   1137  N   ASN A 144      23.263   1.769   3.137  1.00  9.48           N  
ATOM   1138  CA  ASN A 144      21.998   1.908   3.870  1.00  9.67           C  
ATOM   1139  C   ASN A 144      20.954   1.852   2.738  1.00  9.87           C  
ATOM   1140  O   ASN A 144      20.733   2.830   2.019  1.00 11.02           O  
ATOM   1141  CB  ASN A 144      21.873   3.263   4.580  1.00  8.93           C  
ATOM   1142  CG  ASN A 144      20.525   3.407   5.269  1.00  9.06           C  
ATOM   1143  OD1 ASN A 144      19.799   2.424   5.387  1.00 10.37           O  
ATOM   1144  ND2 ASN A 144      20.171   4.632   5.710  1.00  8.38           N  
ATOM   1145  N   VAL A 145      20.303   0.699   2.590  1.00  9.59           N  
ATOM   1146  CA  VAL A 145      19.326   0.543   1.497  1.00 11.84           C  
ATOM   1147  C   VAL A 145      17.937   1.027   1.896  1.00 10.57           C  
ATOM   1148  O   VAL A 145      17.003   0.986   1.084  1.00 12.06           O  
ATOM   1149  CB  VAL A 145      19.224  -0.941   1.027  1.00 13.08           C  
ATOM   1150  CG1 VAL A 145      20.615  -1.408   0.475  1.00 13.59           C  
ATOM   1151  CG2 VAL A 145      18.789  -1.850   2.157  1.00 15.84           C  
ATOM   1152  N   SER A 146      17.795   1.469   3.137  1.00 10.25           N  
ATOM   1153  CA  SER A 146      16.486   1.964   3.603  1.00  9.92           C  
ATOM   1154  C   SER A 146      16.064   3.216   2.853  1.00 11.51           C  
ATOM   1155  O   SER A 146      16.887   4.070   2.508  1.00 11.91           O  
ATOM   1156  CB  SER A 146      16.539   2.302   5.085  1.00 10.21           C  
ATOM   1157  OG  SER A 146      15.244   2.721   5.536  1.00  9.93           O  
ATOM   1158  N   HIS A 147      14.751   3.315   2.607  1.00 10.59           N  
ATOM   1159  CA  HIS A 147      14.168   4.478   1.960  1.00 11.45           C  
ATOM   1160  C   HIS A 147      13.620   5.434   3.018  1.00 11.35           C  
ATOM   1161  O   HIS A 147      13.303   6.583   2.704  1.00 13.53           O  
ATOM   1162  CB  HIS A 147      12.984   4.068   1.080  1.00 12.27           C  
ATOM   1163  CG  HIS A 147      13.381   3.484  -0.231  1.00 13.31           C  
ATOM   1164  ND1 HIS A 147      13.395   4.229  -1.385  1.00 14.29           N  
ATOM   1165  CD2 HIS A 147      13.810   2.247  -0.570  1.00 14.28           C  
ATOM   1166  CE1 HIS A 147      13.830   3.482  -2.382  1.00 13.90           C  
ATOM   1167  NE2 HIS A 147      14.089   2.276  -1.915  1.00 14.37           N  
ATOM   1168  N   THR A 148      13.555   4.989   4.274  1.00 12.36           N  
ATOM   1169  CA  THR A 148      12.926   5.784   5.336  1.00 12.39           C  
ATOM   1170  C   THR A 148      13.714   5.964   6.636  1.00 12.99           C  
ATOM   1171  O   THR A 148      13.329   6.755   7.480  1.00 14.01           O  
ATOM   1172  CB  THR A 148      11.574   5.122   5.732  1.00 13.11           C  
ATOM   1173  OG1 THR A 148      11.820   3.753   6.116  1.00 13.51           O  
ATOM   1174  CG2 THR A 148      10.593   5.147   4.561  1.00 14.06           C  
ATOM   1175  N   GLU A 149      14.806   5.226   6.797  1.00 10.32           N  
ATOM   1176  CA  GLU A 149      15.564   5.309   8.039  1.00 11.97           C  
ATOM   1177  C   GLU A 149      17.051   5.566   7.901  1.00 12.39           C  
ATOM   1178  O   GLU A 149      17.772   4.777   7.311  1.00 14.81           O  
ATOM   1179  CB  GLU A 149      15.420   4.015   8.817  1.00 12.60           C  
ATOM   1180  CG  GLU A 149      13.978   3.700   9.289  1.00 17.69           C  
ATOM   1181  CD  GLU A 149      13.404   4.756  10.227  1.00 22.56           C  
ATOM   1182  OE1 GLU A 149      14.184   5.479  10.891  1.00 21.47           O  
ATOM   1183  OE2 GLU A 149      12.151   4.855  10.311  1.00 24.06           O  
ATOM   1184  N   PRO A 150      17.529   6.680   8.449  1.00 11.24           N  
ATOM   1185  CA  PRO A 150      18.963   6.976   8.386  1.00 11.41           C  
ATOM   1186  C   PRO A 150      19.645   5.937   9.288  1.00 12.17           C  
ATOM   1187  O   PRO A 150      19.041   5.443  10.240  1.00 14.62           O  
ATOM   1188  CB  PRO A 150      19.053   8.358   9.005  1.00 11.93           C  
ATOM   1189  CG  PRO A 150      17.718   8.982   8.614  1.00 14.93           C  
ATOM   1190  CD  PRO A 150      16.756   7.841   8.903  1.00 13.25           C  
ATOM   1191  N   ALA A 151      20.899   5.596   8.995  1.00  9.38           N  
ATOM   1192  CA  ALA A 151      21.635   4.624   9.810  1.00  8.32           C  
ATOM   1193  C   ALA A 151      22.868   5.318  10.390  1.00  8.09           C  
ATOM   1194  O   ALA A 151      23.385   6.281   9.807  1.00  8.20           O  
ATOM   1195  CB  ALA A 151      22.093   3.448   8.957  1.00 10.62           C  
ATOM   1196  N   VAL A 152      23.318   4.825  11.537  1.00  8.19           N  
ATOM   1197  CA  VAL A 152      24.527   5.375  12.172  1.00  7.88           C  
ATOM   1198  C   VAL A 152      25.341   4.195  12.630  1.00  7.95           C  
ATOM   1199  O   VAL A 152      24.807   3.262  13.232  1.00  8.99           O  
ATOM   1200  CB  VAL A 152      24.172   6.273  13.387  1.00  8.94           C  
ATOM   1201  CG1 VAL A 152      25.448   6.836  14.004  1.00  7.54           C  
ATOM   1202  CG2 VAL A 152      23.250   7.451  12.923  1.00  9.59           C  
ATOM   1203  N   SER A 153      26.634   4.213  12.313  1.00  5.94           N  
ATOM   1204  CA  SER A 153      27.511   3.113  12.710  1.00  7.22           C  
ATOM   1205  C   SER A 153      28.776   3.643  13.346  1.00  7.93           C  
ATOM   1206  O   SER A 153      29.225   4.762  13.074  1.00  8.28           O  
ATOM   1207  CB  SER A 153      27.847   2.237  11.492  1.00  9.43           C  
ATOM   1208  OG  SER A 153      28.315   3.009  10.395  1.00  7.43           O  
ATOM   1209  N   LEU A 154      29.360   2.814  14.194  1.00  7.94           N  
ATOM   1210  CA  LEU A 154      30.579   3.142  14.928  1.00  8.19           C  
ATOM   1211  C   LEU A 154      31.681   2.266  14.333  1.00  9.36           C  
ATOM   1212  O   LEU A 154      31.576   1.022  14.326  1.00  9.79           O  
ATOM   1213  CB  LEU A 154      30.361   2.795  16.423  1.00  8.38           C  
ATOM   1214  CG  LEU A 154      31.552   3.014  17.373  1.00  8.75           C  
ATOM   1215  CD1 LEU A 154      31.882   4.502  17.452  1.00 10.59           C  
ATOM   1216  CD2 LEU A 154      31.215   2.521  18.774  1.00  9.89           C  
ATOM   1217  N   HIS A 155      32.736   2.900  13.852  1.00  8.17           N  
ATOM   1218  CA  HIS A 155      33.828   2.149  13.219  1.00  7.86           C  
ATOM   1219  C   HIS A 155      35.148   2.329  13.934  1.00  8.57           C  
ATOM   1220  O   HIS A 155      35.507   3.438  14.340  1.00  8.56           O  
ATOM   1221  CB  HIS A 155      34.022   2.625  11.777  1.00  8.58           C  
ATOM   1222  CG  HIS A 155      32.825   2.421  10.901  1.00  8.25           C  
ATOM   1223  ND1 HIS A 155      32.905   1.750   9.703  1.00  9.34           N  
ATOM   1224  CD2 HIS A 155      31.529   2.774  11.049  1.00  9.94           C  
ATOM   1225  CE1 HIS A 155      31.700   1.687   9.150  1.00 10.11           C  
ATOM   1226  NE2 HIS A 155      30.848   2.298   9.955  1.00  9.98           N  
ATOM   1227  N   LEU A 156      35.898   1.235  14.050  1.00  8.15           N  
ATOM   1228  CA  LEU A 156      37.233   1.290  14.659  1.00  8.58           C  
ATOM   1229  C   LEU A 156      38.215   0.664  13.677  1.00  8.06           C  
ATOM   1230  O   LEU A 156      38.021  -0.467  13.219  1.00 10.39           O  
ATOM   1231  CB  LEU A 156      37.259   0.520  15.999  1.00  9.65           C  
ATOM   1232  CG  LEU A 156      38.599   0.632  16.790  1.00 12.31           C  
ATOM   1233  CD1 LEU A 156      38.340   0.424  18.258  1.00 15.76           C  
ATOM   1234  CD2 LEU A 156      39.673  -0.360  16.289  1.00 13.36           C  
ATOM   1235  N   TYR A 157      39.264   1.405  13.357  1.00  8.56           N  
ATOM   1236  CA  TYR A 157      40.285   0.914  12.435  1.00 10.40           C  
ATOM   1237  C   TYR A 157      41.629   0.977  13.123  1.00 10.78           C  
ATOM   1238  O   TYR A 157      41.979   2.001  13.703  1.00 11.50           O  
ATOM   1239  CB  TYR A 157      40.322   1.766  11.179  1.00 11.58           C  
ATOM   1240  CG  TYR A 157      39.017   1.674  10.420  1.00 11.12           C  
ATOM   1241  CD1 TYR A 157      38.328   2.809  10.152  1.00 13.27           C  
ATOM   1242  CD2 TYR A 157      38.437   0.457  10.046  1.00 11.74           C  
ATOM   1243  CE1 TYR A 157      37.056   2.775   9.516  1.00 13.78           C  
ATOM   1244  CE2 TYR A 157      37.145   0.429   9.412  1.00 13.04           C  
ATOM   1245  CZ  TYR A 157      36.494   1.565   9.156  1.00 13.01           C  
ATOM   1246  OH  TYR A 157      35.297   1.379   8.504  1.00 16.00           O  
ATOM   1247  N   SER A 158      42.375  -0.120  13.047  1.00  9.77           N  
ATOM   1248  CA  SER A 158      43.700  -0.161  13.679  1.00 10.19           C  
ATOM   1249  C   SER A 158      44.683  -0.954  12.824  1.00 10.93           C  
ATOM   1250  O   SER A 158      44.395  -2.093  12.485  1.00 11.15           O  
ATOM   1251  CB  SER A 158      43.608  -0.827  15.051  1.00 10.55           C  
ATOM   1252  OG  SER A 158      44.881  -0.826  15.689  1.00 12.79           O  
ATOM   1253  N   PRO A 159      45.843  -0.358  12.446  1.00 10.62           N  
ATOM   1254  CA  PRO A 159      46.267   1.007  12.764  1.00 12.05           C  
ATOM   1255  C   PRO A 159      45.379   2.009  12.039  1.00 12.02           C  
ATOM   1256  O   PRO A 159      44.575   1.631  11.207  1.00 12.30           O  
ATOM   1257  CB  PRO A 159      47.700   1.074  12.219  1.00 13.73           C  
ATOM   1258  CG  PRO A 159      48.143  -0.362  12.170  1.00 14.50           C  
ATOM   1259  CD  PRO A 159      46.911  -1.096  11.730  1.00 12.01           C  
ATOM   1260  N   PRO A 160      45.486   3.295  12.371  1.00 13.04           N  
ATOM   1261  CA  PRO A 160      44.632   4.247  11.664  1.00 14.32           C  
ATOM   1262  C   PRO A 160      45.093   4.325  10.215  1.00 14.42           C  
ATOM   1263  O   PRO A 160      46.273   4.089   9.922  1.00 17.34           O  
ATOM   1264  CB  PRO A 160      44.906   5.571  12.388  1.00 14.31           C  
ATOM   1265  CG  PRO A 160      45.389   5.164  13.688  1.00 17.13           C  
ATOM   1266  CD  PRO A 160      46.260   3.970  13.419  1.00 14.21           C  
ATOM   1267  N   PHE A 161      44.181   4.637   9.311  1.00 14.92           N  
ATOM   1268  CA  PHE A 161      44.568   4.825   7.916  1.00 16.34           C  
ATOM   1269  C   PHE A 161      43.737   5.934   7.312  1.00 18.06           C  
ATOM   1270  O   PHE A 161      42.584   6.144   7.705  1.00 18.61           O  
ATOM   1271  CB  PHE A 161      44.487   3.507   7.108  1.00 16.07           C  
ATOM   1272  CG  PHE A 161      43.120   2.904   7.024  1.00 15.19           C  
ATOM   1273  CD1 PHE A 161      42.259   3.269   6.002  1.00 16.06           C  
ATOM   1274  CD2 PHE A 161      42.704   1.936   7.950  1.00 15.87           C  
ATOM   1275  CE1 PHE A 161      41.012   2.685   5.893  1.00 16.55           C  
ATOM   1276  CE2 PHE A 161      41.440   1.342   7.845  1.00 13.82           C  
ATOM   1277  CZ  PHE A 161      40.596   1.712   6.821  1.00 14.67           C  
ATOM   1278  N   ASP A 162      44.359   6.663   6.391  1.00 19.31           N  
ATOM   1279  CA  ASP A 162      43.757   7.807   5.738  1.00 22.40           C  
ATOM   1280  C   ASP A 162      43.403   7.576   4.284  1.00 20.07           C  
ATOM   1281  O   ASP A 162      42.771   8.427   3.668  1.00 18.84           O  
ATOM   1282  CB  ASP A 162      44.718   9.006   5.797  1.00 26.82           C  
ATOM   1283  CG  ASP A 162      44.847   9.585   7.186  1.00 32.75           C  
ATOM   1284  OD1 ASP A 162      43.793   9.809   7.837  1.00 36.67           O  
ATOM   1285  OD2 ASP A 162      45.996   9.826   7.618  1.00 36.54           O  
ATOM   1286  N   THR A 163      43.817   6.449   3.717  1.00 17.74           N  
ATOM   1287  CA  THR A 163      43.524   6.183   2.311  1.00 17.22           C  
ATOM   1288  C   THR A 163      43.184   4.705   2.167  1.00 16.42           C  
ATOM   1289  O   THR A 163      43.520   3.906   3.042  1.00 16.18           O  
ATOM   1290  CB  THR A 163      44.762   6.431   1.405  1.00 19.58           C  
ATOM   1291  OG1 THR A 163      45.790   5.505   1.779  1.00 21.44           O  
ATOM   1292  CG2 THR A 163      45.302   7.823   1.577  1.00 18.29           C  
ATOM   1293  N   CYS A 164      42.508   4.365   1.075  1.00 15.25           N  
ATOM   1294  CA  CYS A 164      42.140   2.980   0.772  1.00 17.20           C  
ATOM   1295  C   CYS A 164      41.873   2.959  -0.722  1.00 16.38           C  
ATOM   1296  O   CYS A 164      42.124   3.949  -1.423  1.00 17.59           O  
ATOM   1297  CB  CYS A 164      40.874   2.550   1.521  1.00 18.59           C  
ATOM   1298  SG  CYS A 164      39.354   3.329   0.937  1.00 23.62           S  
ATOM   1299  N   HIS A 165      41.380   1.832  -1.217  1.00 14.97           N  
ATOM   1300  CA  HIS A 165      41.058   1.699  -2.624  1.00 14.69           C  
ATOM   1301  C   HIS A 165      39.598   1.419  -2.843  1.00 15.13           C  
ATOM   1302  O   HIS A 165      38.974   0.661  -2.089  1.00 15.16           O  
ATOM   1303  CB  HIS A 165      41.810   0.535  -3.257  1.00 15.41           C  
ATOM   1304  CG  HIS A 165      43.291   0.670  -3.184  1.00 15.35           C  
ATOM   1305  ND1 HIS A 165      44.037   0.042  -2.217  1.00 14.05           N  
ATOM   1306  CD2 HIS A 165      44.167   1.387  -3.935  1.00 16.33           C  
ATOM   1307  CE1 HIS A 165      45.311   0.365  -2.367  1.00 16.64           C  
ATOM   1308  NE2 HIS A 165      45.418   1.179  -3.401  1.00 16.64           N  
ATOM   1309  N   ALA A 166      39.058   2.024  -3.893  1.00 14.24           N  
ATOM   1310  CA  ALA A 166      37.697   1.757  -4.291  1.00 14.99           C  
ATOM   1311  C   ALA A 166      37.863   0.833  -5.504  1.00 15.61           C  
ATOM   1312  O   ALA A 166      38.797   1.014  -6.300  1.00 17.53           O  
ATOM   1313  CB  ALA A 166      37.028   3.046  -4.682  1.00 15.00           C  
ATOM   1314  N   PHE A 167      36.987  -0.154  -5.628  1.00 13.43           N  
ATOM   1315  CA  PHE A 167      37.050  -1.114  -6.741  1.00 15.37           C  
ATOM   1316  C   PHE A 167      35.852  -0.974  -7.674  1.00 16.63           C  
ATOM   1317  O   PHE A 167      34.731  -0.863  -7.226  1.00 17.61           O  
ATOM   1318  CB  PHE A 167      37.092  -2.543  -6.201  1.00 14.97           C  
ATOM   1319  CG  PHE A 167      38.338  -2.861  -5.422  1.00 15.40           C  
ATOM   1320  CD1 PHE A 167      39.372  -3.578  -6.015  1.00 15.89           C  
ATOM   1321  CD2 PHE A 167      38.506  -2.405  -4.121  1.00 14.30           C  
ATOM   1322  CE1 PHE A 167      40.550  -3.829  -5.329  1.00 16.21           C  
ATOM   1323  CE2 PHE A 167      39.696  -2.658  -3.422  1.00 15.87           C  
ATOM   1324  CZ  PHE A 167      40.715  -3.368  -4.030  1.00 14.98           C  
ATOM   1325  N   ASP A 168      36.111  -0.980  -8.976  1.00 17.14           N  
ATOM   1326  CA  ASP A 168      35.039  -0.875  -9.966  1.00 19.75           C  
ATOM   1327  C   ASP A 168      34.403  -2.242 -10.087  1.00 20.82           C  
ATOM   1328  O   ASP A 168      35.056  -3.221 -10.469  1.00 20.59           O  
ATOM   1329  CB  ASP A 168      35.588  -0.448 -11.318  1.00 23.54           C  
ATOM   1330  CG  ASP A 168      34.486  -0.250 -12.349  1.00 27.01           C  
ATOM   1331  OD1 ASP A 168      33.452  -0.939 -12.248  1.00 30.61           O  
ATOM   1332  OD2 ASP A 168      34.656   0.592 -13.262  1.00 32.61           O  
ATOM   1333  N   GLN A 169      33.124  -2.329  -9.762  1.00 21.23           N  
ATOM   1334  CA  GLN A 169      32.456  -3.616  -9.791  1.00 20.61           C  
ATOM   1335  C   GLN A 169      32.409  -4.271 -11.160  1.00 22.29           C  
ATOM   1336  O   GLN A 169      32.360  -5.493 -11.260  1.00 22.01           O  
ATOM   1337  CB  GLN A 169      31.040  -3.501  -9.247  1.00 21.13           C  
ATOM   1338  CG  GLN A 169      30.463  -4.856  -8.957  1.00 22.37           C  
ATOM   1339  CD  GLN A 169      29.127  -4.781  -8.307  1.00 24.35           C  
ATOM   1340  OE1 GLN A 169      28.642  -3.694  -7.998  1.00 26.24           O  
ATOM   1341  NE2 GLN A 169      28.516  -5.935  -8.077  1.00 25.33           N  
ATOM   1342  N   ARG A 170      32.458  -3.462 -12.204  1.00 23.79           N  
ATOM   1343  CA  ARG A 170      32.410  -4.012 -13.554  1.00 26.15           C  
ATOM   1344  C   ARG A 170      33.731  -4.639 -14.016  1.00 26.48           C  
ATOM   1345  O   ARG A 170      33.721  -5.551 -14.848  1.00 28.41           O  
ATOM   1346  CB  ARG A 170      31.997  -2.919 -14.547  1.00 27.98           C  
ATOM   1347  CG  ARG A 170      30.648  -2.265 -14.240  1.00 32.68           C  
ATOM   1348  CD  ARG A 170      29.469  -3.175 -14.572  1.00 37.35           C  
ATOM   1349  NE  ARG A 170      29.291  -4.283 -13.634  1.00 40.58           N  
ATOM   1350  CZ  ARG A 170      28.764  -4.164 -12.416  1.00 42.07           C  
ATOM   1351  NH1 ARG A 170      28.354  -2.979 -11.971  1.00 44.03           N  
ATOM   1352  NH2 ARG A 170      28.629  -5.232 -11.645  1.00 43.05           N  
ATOM   1353  N   THR A 171      34.860  -4.185 -13.465  1.00 25.68           N  
ATOM   1354  CA  THR A 171      36.170  -4.687 -13.893  1.00 25.61           C  
ATOM   1355  C   THR A 171      37.121  -5.213 -12.829  1.00 24.75           C  
ATOM   1356  O   THR A 171      38.000  -6.026 -13.121  1.00 25.02           O  
ATOM   1357  CB  THR A 171      36.957  -3.599 -14.633  1.00 27.14           C  
ATOM   1358  OG1 THR A 171      37.242  -2.527 -13.725  1.00 26.02           O  
ATOM   1359  CG2 THR A 171      36.155  -3.048 -15.822  1.00 27.30           C  
ATOM   1360  N   GLY A 172      36.977  -4.732 -11.602  1.00 23.78           N  
ATOM   1361  CA  GLY A 172      37.886  -5.166 -10.560  1.00 22.41           C  
ATOM   1362  C   GLY A 172      39.024  -4.178 -10.415  1.00 22.84           C  
ATOM   1363  O   GLY A 172      39.851  -4.284  -9.503  1.00 22.40           O  
ATOM   1364  N   HIS A 173      39.068  -3.203 -11.316  1.00 23.74           N  
ATOM   1365  CA  HIS A 173      40.106  -2.164 -11.312  1.00 24.63           C  
ATOM   1366  C   HIS A 173      40.002  -1.320 -10.042  1.00 23.95           C  
ATOM   1367  O   HIS A 173      38.903  -1.014  -9.575  1.00 22.68           O  
ATOM   1368  CB  HIS A 173      39.931  -1.265 -12.546  1.00 28.07           C  
ATOM   1369  CG  HIS A 173      40.941  -0.161 -12.656  1.00 32.35           C  
ATOM   1370  ND1 HIS A 173      42.265  -0.389 -12.969  1.00 34.62           N  
ATOM   1371  CD2 HIS A 173      40.811   1.181 -12.531  1.00 34.16           C  
ATOM   1372  CE1 HIS A 173      42.905   0.766 -13.035  1.00 34.84           C  
ATOM   1373  NE2 HIS A 173      42.046   1.735 -12.774  1.00 34.38           N  
ATOM   1374  N   LYS A 174      41.134  -0.923  -9.477  1.00 22.88           N  
ATOM   1375  CA  LYS A 174      41.067  -0.124  -8.258  1.00 23.08           C  
ATOM   1376  C   LYS A 174      41.696   1.238  -8.409  1.00 23.34           C  
ATOM   1377  O   LYS A 174      42.529   1.477  -9.294  1.00 23.87           O  
ATOM   1378  CB  LYS A 174      41.733  -0.860  -7.095  1.00 25.03           C  
ATOM   1379  CG  LYS A 174      43.227  -1.012  -7.216  1.00 26.29           C  
ATOM   1380  CD  LYS A 174      43.821  -1.670  -5.973  1.00 29.43           C  
ATOM   1381  CE  LYS A 174      45.223  -2.181  -6.234  1.00 31.12           C  
ATOM   1382  NZ  LYS A 174      46.121  -1.105  -6.750  1.00 31.98           N  
ATOM   1383  N   ASN A 175      41.275   2.143  -7.545  1.00 23.36           N  
ATOM   1384  CA  ASN A 175      41.824   3.481  -7.528  1.00 24.88           C  
ATOM   1385  C   ASN A 175      41.934   3.921  -6.085  1.00 23.69           C  
ATOM   1386  O   ASN A 175      41.077   3.602  -5.244  1.00 21.98           O  
ATOM   1387  CB  ASN A 175      40.960   4.465  -8.329  1.00 28.86           C  
ATOM   1388  CG  ASN A 175      39.623   4.732  -7.687  1.00 31.92           C  
ATOM   1389  OD1 ASN A 175      38.757   3.856  -7.638  1.00 34.92           O  
ATOM   1390  ND2 ASN A 175      39.442   5.956  -7.182  1.00 34.13           N  
ATOM   1391  N   LYS A 176      43.009   4.640  -5.801  1.00 23.92           N  
ATOM   1392  CA  LYS A 176      43.276   5.123  -4.466  1.00 24.11           C  
ATOM   1393  C   LYS A 176      42.358   6.275  -4.140  1.00 24.10           C  
ATOM   1394  O   LYS A 176      42.141   7.171  -4.952  1.00 26.21           O  
ATOM   1395  CB  LYS A 176      44.743   5.552  -4.349  1.00 25.88           C  
ATOM   1396  CG  LYS A 176      45.155   5.907  -2.933  1.00 28.89           C  
ATOM   1397  CD  LYS A 176      46.669   6.000  -2.798  1.00 31.27           C  
ATOM   1398  CE  LYS A 176      47.078   6.214  -1.335  1.00 32.40           C  
ATOM   1399  NZ  LYS A 176      48.508   6.652  -1.172  1.00 34.02           N  
ATOM   1400  N   VAL A 177      41.813   6.245  -2.934  1.00 21.55           N  
ATOM   1401  CA  VAL A 177      40.928   7.285  -2.468  1.00 21.25           C  
ATOM   1402  C   VAL A 177      41.433   7.786  -1.124  1.00 20.02           C  
ATOM   1403  O   VAL A 177      41.969   7.015  -0.318  1.00 18.41           O  
ATOM   1404  CB  VAL A 177      39.522   6.727  -2.293  1.00 21.85           C  
ATOM   1405  CG1 VAL A 177      38.656   7.712  -1.516  1.00 22.60           C  
ATOM   1406  CG2 VAL A 177      38.937   6.423  -3.658  1.00 23.34           C  
ATOM   1407  N   THR A 178      41.288   9.082  -0.883  1.00 20.34           N  
ATOM   1408  CA  THR A 178      41.703   9.622   0.393  1.00 22.71           C  
ATOM   1409  C   THR A 178      40.433   9.884   1.166  1.00 22.06           C  
ATOM   1410  O   THR A 178      39.489  10.462   0.646  1.00 22.91           O  
ATOM   1411  CB  THR A 178      42.502  10.914   0.241  1.00 22.63           C  
ATOM   1412  OG1 THR A 178      43.754  10.607  -0.369  1.00 26.02           O  
ATOM   1413  CG2 THR A 178      42.771  11.532   1.605  1.00 25.87           C  
ATOM   1414  N   MET A 179      40.424   9.404   2.398  1.00 23.43           N  
ATOM   1415  CA  MET A 179      39.309   9.532   3.304  1.00 26.55           C  
ATOM   1416  C   MET A 179      39.355  10.923   3.911  1.00 27.23           C  
ATOM   1417  O   MET A 179      40.436  11.450   4.208  1.00 28.14           O  
ATOM   1418  CB  MET A 179      39.450   8.461   4.400  1.00 29.38           C  
ATOM   1419  CG  MET A 179      38.669   8.680   5.697  1.00 32.45           C  
ATOM   1420  SD  MET A 179      39.033   7.413   6.976  1.00 35.29           S  
ATOM   1421  CE  MET A 179      40.427   8.156   7.920  1.00 34.30           C  
ATOM   1422  N   THR A 180      38.190  11.520   4.085  1.00 25.92           N  
ATOM   1423  CA  THR A 180      38.152  12.826   4.710  1.00 26.14           C  
ATOM   1424  C   THR A 180      37.141  12.773   5.834  1.00 24.61           C  
ATOM   1425  O   THR A 180      36.142  12.041   5.756  1.00 23.50           O  
ATOM   1426  CB  THR A 180      37.721  13.918   3.739  1.00 27.17           C  
ATOM   1427  OG1 THR A 180      36.504  13.519   3.093  1.00 30.81           O  
ATOM   1428  CG2 THR A 180      38.824  14.175   2.703  1.00 28.00           C  
ATOM   1429  N   PHE A 181      37.423  13.531   6.890  1.00 23.97           N  
ATOM   1430  CA  PHE A 181      36.512  13.607   8.022  1.00 21.25           C  
ATOM   1431  C   PHE A 181      35.596  14.808   7.912  1.00 20.33           C  
ATOM   1432  O   PHE A 181      36.067  15.931   7.694  1.00 21.28           O  
ATOM   1433  CB  PHE A 181      37.271  13.725   9.332  1.00 23.27           C  
ATOM   1434  CG  PHE A 181      37.951  12.472   9.763  1.00 23.03           C  
ATOM   1435  CD1 PHE A 181      37.225  11.326  10.000  1.00 22.79           C  
ATOM   1436  CD2 PHE A 181      39.333  12.442   9.945  1.00 25.43           C  
ATOM   1437  CE1 PHE A 181      37.835  10.169  10.399  1.00 23.33           C  
ATOM   1438  CE2 PHE A 181      39.963  11.279  10.356  1.00 25.44           C  
ATOM   1439  CZ  PHE A 181      39.210  10.133  10.582  1.00 24.58           C  
ATOM   1440  N   HIS A 182      34.297  14.563   8.081  1.00 15.01           N  
ATOM   1441  CA  HIS A 182      33.240  15.561   8.074  1.00 12.63           C  
ATOM   1442  C   HIS A 182      33.347  16.405   9.364  1.00 12.06           C  
ATOM   1443  O   HIS A 182      33.038  17.605   9.385  1.00 13.05           O  
ATOM   1444  CB  HIS A 182      31.888  14.839   8.083  1.00 13.11           C  
ATOM   1445  CG  HIS A 182      30.716  15.743   7.915  1.00 13.40           C  
ATOM   1446  ND1 HIS A 182      30.439  16.387   6.729  1.00 14.54           N  
ATOM   1447  CD2 HIS A 182      29.744  16.109   8.781  1.00 13.90           C  
ATOM   1448  CE1 HIS A 182      29.345  17.107   6.871  1.00 16.06           C  
ATOM   1449  NE2 HIS A 182      28.902  16.955   8.107  1.00 15.84           N  
ATOM   1450  N   SER A 183      33.735  15.753  10.445  1.00 11.03           N  
ATOM   1451  CA  SER A 183      33.905  16.459  11.732  1.00 10.88           C  
ATOM   1452  C   SER A 183      34.913  15.703  12.554  1.00 12.80           C  
ATOM   1453  O   SER A 183      35.212  14.518  12.281  1.00 11.94           O  
ATOM   1454  CB  SER A 183      32.592  16.529  12.513  1.00 11.98           C  
ATOM   1455  OG  SER A 183      32.139  15.236  12.915  1.00 10.49           O  
ATOM   1456  N   LYS A 184      35.474  16.395  13.545  1.00 10.66           N  
ATOM   1457  CA  LYS A 184      36.445  15.774  14.427  1.00 11.73           C  
ATOM   1458  C   LYS A 184      36.131  16.242  15.823  1.00 11.62           C  
ATOM   1459  O   LYS A 184      36.038  17.437  16.066  1.00 11.73           O  
ATOM   1460  CB  LYS A 184      37.878  16.183  14.027  1.00 15.09           C  
ATOM   1461  CG  LYS A 184      38.330  15.527  12.742  1.00 19.24           C  
ATOM   1462  CD  LYS A 184      39.669  16.028  12.228  1.00 24.67           C  
ATOM   1463  CE  LYS A 184      40.825  15.459  13.013  1.00 28.07           C  
ATOM   1464  NZ  LYS A 184      42.068  15.386  12.152  1.00 32.19           N  
ATOM   1465  N   PHE A 185      35.905  15.302  16.726  1.00 10.89           N  
ATOM   1466  CA  PHE A 185      35.597  15.621  18.107  1.00 11.75           C  
ATOM   1467  C   PHE A 185      34.393  16.549  18.219  1.00 13.40           C  
ATOM   1468  O   PHE A 185      34.352  17.418  19.081  1.00 14.17           O  
ATOM   1469  CB  PHE A 185      36.837  16.223  18.777  1.00 12.88           C  
ATOM   1470  CG  PHE A 185      38.117  15.455  18.478  1.00 13.64           C  
ATOM   1471  CD1 PHE A 185      38.270  14.140  18.869  1.00 17.90           C  
ATOM   1472  CD2 PHE A 185      39.110  16.040  17.703  1.00 17.58           C  
ATOM   1473  CE1 PHE A 185      39.406  13.402  18.481  1.00 19.04           C  
ATOM   1474  CE2 PHE A 185      40.252  15.307  17.305  1.00 19.43           C  
ATOM   1475  CZ  PHE A 185      40.385  13.986  17.701  1.00 18.26           C  
ATOM   1476  N   GLY A 186      33.415  16.342  17.342  1.00 11.17           N  
ATOM   1477  CA  GLY A 186      32.181  17.112  17.369  1.00 13.17           C  
ATOM   1478  C   GLY A 186      32.196  18.433  16.629  1.00 11.79           C  
ATOM   1479  O   GLY A 186      31.161  19.100  16.526  1.00 15.02           O  
ATOM   1480  N   ILE A 187      33.353  18.789  16.076  1.00 11.54           N  
ATOM   1481  CA  ILE A 187      33.541  20.052  15.357  1.00 11.32           C  
ATOM   1482  C   ILE A 187      33.570  19.807  13.843  1.00 10.81           C  
ATOM   1483  O   ILE A 187      34.358  18.993  13.380  1.00 11.96           O  
ATOM   1484  CB  ILE A 187      34.899  20.700  15.760  1.00 13.00           C  
ATOM   1485  CG1 ILE A 187      34.982  20.853  17.288  1.00 12.56           C  
ATOM   1486  CG2 ILE A 187      35.053  22.064  15.059  1.00 14.36           C  
ATOM   1487  CD1 ILE A 187      33.927  21.807  17.890  1.00 15.79           C  
ATOM   1488  N   ARG A 188      32.725  20.514  13.093  1.00 12.51           N  
ATOM   1489  CA  ARG A 188      32.672  20.368  11.655  1.00 14.29           C  
ATOM   1490  C   ARG A 188      34.037  20.789  11.137  1.00 16.60           C  
ATOM   1491  O   ARG A 188      34.594  21.828  11.548  1.00 17.07           O  
ATOM   1492  CB  ARG A 188      31.568  21.253  11.095  1.00 15.18           C  
ATOM   1493  CG  ARG A 188      31.457  21.195   9.599  1.00 16.40           C  
ATOM   1494  CD  ARG A 188      30.784  19.913   9.069  1.00 17.76           C  
ATOM   1495  NE  ARG A 188      30.671  20.039   7.614  1.00 18.84           N  
ATOM   1496  CZ  ARG A 188      31.617  19.719   6.734  1.00 20.09           C  
ATOM   1497  NH1 ARG A 188      32.779  19.208   7.111  1.00 17.33           N  
ATOM   1498  NH2 ARG A 188      31.428  20.018   5.447  1.00 21.56           N  
ATOM   1499  N   THR A 189      34.603  19.973  10.263  1.00 17.51           N  
ATOM   1500  CA  THR A 189      35.918  20.288   9.717  1.00 21.59           C  
ATOM   1501  C   THR A 189      35.825  20.311   8.217  1.00 24.11           C  
ATOM   1502  O   THR A 189      36.040  19.291   7.551  1.00 26.05           O  
ATOM   1503  CB  THR A 189      36.987  19.255  10.158  1.00 22.04           C  
ATOM   1504  OG1 THR A 189      36.532  17.937   9.838  1.00 23.05           O  
ATOM   1505  CG2 THR A 189      37.269  19.362  11.678  1.00 22.33           C  
ATOM   1506  N   PRO A 190      35.483  21.475   7.655  1.00 26.07           N  
ATOM   1507  CA  PRO A 190      35.360  21.614   6.201  1.00 29.11           C  
ATOM   1508  C   PRO A 190      36.696  21.677   5.461  1.00 30.32           C  
ATOM   1509  O   PRO A 190      37.716  22.014   6.089  1.00 32.58           O  
ATOM   1510  CB  PRO A 190      34.558  22.898   6.053  1.00 29.81           C  
ATOM   1511  CG  PRO A 190      35.066  23.719   7.185  1.00 29.69           C  
ATOM   1512  CD  PRO A 190      35.085  22.716   8.337  1.00 27.26           C  
TER    1513      PRO A 190                                                      
END
MOLECULE T0414.pdb
ATOM      1  N   ALA     3      33.302  15.772  39.809  1.00 36.36           N  
ATOM      2  CA  ALA     3      33.703  14.577  39.009  1.00 34.68           C  
ATOM      3  C   ALA     3      33.623  14.788  37.490  1.00 33.45           C  
ATOM      4  O   ALA     3      32.753  15.521  36.975  1.00 34.46           O  
ATOM      5  CB  ALA     3      32.891  13.338  39.421  1.00 34.63           C  
ATOM      6  N   MET     4      34.518  14.186  36.727  0.50 33.03           N  
ATOM      8  CA  MET     4      34.520  14.424  35.288  0.50 31.92           C  
ATOM     10  C   MET     4      33.425  13.560  34.616  0.50 29.87           C  
ATOM     12  O   MET     4      33.219  12.421  35.010  0.50 28.81           O  
ATOM     14  CB  MET     4      35.942  14.155  34.757  0.50 32.53           C  
ATOM     16  CG  MET     4      36.126  13.883  33.287  0.50 33.68           C  
ATOM     18  SD  MET     4      37.621  12.592  33.077  0.30 35.37          SE  
ATOM     20  CE  MET     4      38.935  13.454  34.246  0.50 35.07           C  
ATOM     22  N   LYS     5      32.683  14.127  33.663  0.50 27.74           N  
ATOM     24  CA  LYS     5      31.796  13.306  32.842  0.50 25.75           C  
ATOM     26  C   LYS     5      32.631  12.565  31.797  0.50 23.22           C  
ATOM     28  O   LYS     5      33.773  12.916  31.546  0.50 22.57           O  
ATOM     30  CB  LYS     5      30.709  14.150  32.160  0.50 26.57           C  
ATOM     32  CG  LYS     5      29.525  14.483  33.071  0.50 27.85           C  
ATOM     34  CD  LYS     5      28.325  14.912  32.262  0.50 29.82           C  
ATOM     36  CE  LYS     5      27.439  13.747  31.918  0.50 28.42           C  
ATOM     38  NZ  LYS     5      26.334  13.574  32.915  0.50 27.77           N  
ATOM     40  N   PRO     6      32.050  11.528  31.182  1.00 21.30           N  
ATOM     41  CA  PRO     6      32.693  10.923  29.996  1.00 19.52           C  
ATOM     42  C   PRO     6      32.625  11.935  28.854  1.00 18.68           C  
ATOM     43  O   PRO     6      31.774  12.839  28.867  1.00 19.30           O  
ATOM     44  CB  PRO     6      31.790   9.733  29.675  1.00 19.69           C  
ATOM     45  CG  PRO     6      30.458  10.178  30.200  1.00 20.34           C  
ATOM     46  CD  PRO     6      30.766  10.901  31.500  1.00 21.56           C  
ATOM     47  N   ASP     7      33.506  11.792  27.867  1.00 17.52           N  
ATOM     48  CA  ASP     7      33.309  12.556  26.627  1.00 16.91           C  
ATOM     49  C   ASP     7      32.131  11.917  25.899  1.00 15.85           C  
ATOM     50  O   ASP     7      31.966  10.690  25.921  1.00 17.32           O  
ATOM     51  CB  ASP     7      34.552  12.523  25.770  1.00 17.30           C  
ATOM     52  CG  ASP     7      35.764  13.025  26.518  1.00 20.36           C  
ATOM     53  OD1 ASP     7      35.723  14.200  26.989  1.00 22.01           O  
ATOM     54  OD2 ASP     7      36.738  12.272  26.639  1.00 20.73           O  
ATOM     55  N   ILE     8      31.291  12.738  25.293  1.00 16.43           N  
ATOM     56  CA  ILE     8      30.057  12.263  24.664  1.00 16.85           C  
ATOM     57  C   ILE     8      30.093  12.721  23.218  1.00 17.30           C  
ATOM     58  O   ILE     8      30.202  13.939  22.920  1.00 16.82           O  
ATOM     59  CB  ILE     8      28.808  12.859  25.331  1.00 16.75           C  
ATOM     60  CG1 ILE     8      28.809  12.531  26.831  1.00 17.21           C  
ATOM     61  CG2 ILE     8      27.531  12.326  24.628  1.00 17.36           C  
ATOM     62  CD1 ILE     8      27.659  13.134  27.576  1.00 21.50           C  
ATOM     63  N   TYR     9      30.035  11.755  22.304  1.00 16.25           N  
ATOM     64  CA  TYR     9      30.189  12.064  20.879  1.00 16.53           C  
ATOM     65  C   TYR     9      28.922  11.695  20.103  1.00 16.71           C  
ATOM     66  O   TYR     9      28.269  10.652  20.365  1.00 17.09           O  
ATOM     67  CB  TYR     9      31.309  11.207  20.307  1.00 18.16           C  
ATOM     68  CG  TYR     9      32.621  11.239  21.056  1.00 19.13           C  
ATOM     69  CD1 TYR     9      33.272  12.425  21.336  1.00 20.08           C  
ATOM     70  CD2 TYR     9      33.226  10.035  21.442  1.00 21.22           C  
ATOM     71  CE1 TYR     9      34.527  12.415  22.020  1.00 19.52           C  
ATOM     72  CE2 TYR     9      34.442  10.010  22.068  1.00 19.90           C  
ATOM     73  CZ  TYR     9      35.070  11.186  22.368  1.00 19.38           C  
ATOM     74  OH  TYR     9      36.285  11.080  23.009  1.00 22.23           O  
ATOM     75  N   GLU    10      28.590  12.535  19.113  1.00 16.20           N  
ATOM     76  CA  GLU    10      27.458  12.237  18.240  1.00 17.73           C  
ATOM     77  C   GLU    10      27.825  12.717  16.832  1.00 17.84           C  
ATOM     78  O   GLU    10      28.762  13.547  16.657  1.00 17.95           O  
ATOM     79  CB  GLU    10      26.181  12.949  18.724  1.00 18.99           C  
ATOM     80  CG  GLU    10      26.360  14.445  18.695  1.00 21.75           C  
ATOM     81  CD  GLU    10      25.209  15.268  19.281  1.00 25.44           C  
ATOM     82  OE1 GLU    10      24.163  14.693  19.649  1.00 33.26           O  
ATOM     83  OE2 GLU    10      25.399  16.514  19.308  1.00 33.86           O  
ATOM     84  N   ASN    11      27.070  12.220  15.860  1.00 15.68           N  
ATOM     85  CA  ASN    11      27.238  12.683  14.477  1.00 15.50           C  
ATOM     86  C   ASN    11      25.856  12.930  13.910  1.00 16.30           C  
ATOM     87  O   ASN    11      25.046  11.966  13.797  1.00 16.56           O  
ATOM     88  CB  ASN    11      27.966  11.608  13.647  1.00 17.10           C  
ATOM     89  CG  ASN    11      28.062  11.990  12.175  1.00 17.78           C  
ATOM     90  OD1 ASN    11      27.841  13.151  11.836  1.00 17.07           O  
ATOM     91  ND2 ASN    11      28.398  11.027  11.314  1.00 16.10           N  
ATOM     92  N   ASN    12      25.572  14.203  13.592  1.00 17.76           N  
ATOM     93  CA  ASN    12      24.307  14.543  12.923  1.00 18.55           C  
ATOM     94  C   ASN    12      24.489  14.954  11.485  1.00 19.79           C  
ATOM     95  O   ASN    12      23.556  15.494  10.875  1.00 23.14           O  
ATOM     96  CB  ASN    12      23.564  15.640  13.703  1.00 20.05           C  
ATOM     97  CG  ASN    12      23.156  15.160  15.094  1.00 23.62           C  
ATOM     98  OD1 ASN    12      23.532  15.777  16.086  1.00 32.59           O  
ATOM     99  ND2 ASN    12      22.482  14.022  15.159  1.00 27.73           N  
ATOM    100  N   ARG    13      25.665  14.690  10.940  1.00 16.78           N  
ATOM    101  CA  ARG    13      26.007  15.090   9.567  1.00 17.18           C  
ATOM    102  C   ARG    13      25.867  13.915   8.606  1.00 17.32           C  
ATOM    103  O   ARG    13      25.768  12.761   9.017  1.00 18.57           O  
ATOM    104  CB  ARG    13      27.463  15.613   9.536  1.00 16.99           C  
ATOM    105  CG  ARG    13      27.698  16.841  10.366  1.00 16.86           C  
ATOM    106  CD  ARG    13      29.145  17.340  10.231  1.00 18.64           C  
ATOM    107  NE  ARG    13      29.314  18.572  11.017  1.00 20.84           N  
ATOM    108  CZ  ARG    13      29.068  19.795  10.555  1.00 22.46           C  
ATOM    109  NH1 ARG    13      28.699  19.980   9.285  1.00 21.30           N  
ATOM    110  NH2 ARG    13      29.238  20.846  11.368  1.00 26.57           N  
ATOM    111  N   GLU    14      25.874  14.191   7.309  1.00 16.57           N  
ATOM    112  CA  GLU    14      25.895  13.116   6.308  1.00 17.51           C  
ATOM    113  C   GLU    14      27.211  12.302   6.422  1.00 16.26           C  
ATOM    114  O   GLU    14      28.303  12.837   6.662  1.00 18.17           O  
ATOM    115  CB  GLU    14      25.802  13.757   4.918  1.00 18.63           C  
ATOM    116  CG  GLU    14      25.635  12.781   3.785  1.00 22.71           C  
ATOM    117  CD  GLU    14      25.134  13.481   2.513  1.00 24.46           C  
ATOM    118  OE1 GLU    14      23.942  13.830   2.472  1.00 28.70           O  
ATOM    119  OE2 GLU    14      25.953  13.623   1.579  1.00 28.01           O  
ATOM    120  N   GLY    15      27.111  10.995   6.267  1.00 17.10           N  
ATOM    121  CA  GLY    15      28.324  10.243   6.152  1.00 18.01           C  
ATOM    122  C   GLY    15      29.095  10.097   7.455  1.00 17.23           C  
ATOM    123  O   GLY    15      28.526   9.934   8.543  1.00 17.23           O  
ATOM    124  N   ILE    16      30.411  10.148   7.345  1.00 17.29           N  
ATOM    125  CA  ILE    16      31.280   9.730   8.446  1.00 16.95           C  
ATOM    126  C   ILE    16      31.787  10.890   9.280  1.00 16.79           C  
ATOM    127  O   ILE    16      32.203  11.929   8.740  1.00 17.82           O  
ATOM    128  CB  ILE    16      32.507   8.989   7.861  1.00 16.44           C  
ATOM    129  CG1 ILE    16      32.046   7.772   7.049  1.00 18.83           C  
ATOM    130  CG2 ILE    16      33.466   8.593   8.953  1.00 17.93           C  
ATOM    131  CD1 ILE    16      33.193   7.165   6.146  1.00 19.62           C  
ATOM    132  N   LEU    17      31.774  10.717  10.609  1.00 16.67           N  
ATOM    133  CA  LEU    17      32.462  11.624  11.507  1.00 17.09           C  
ATOM    134  C   LEU    17      33.304  10.755  12.436  1.00 17.42           C  
ATOM    135  O   LEU    17      32.781   9.846  13.128  1.00 17.89           O  
ATOM    136  CB  LEU    17      31.464  12.429  12.342  1.00 17.81           C  
ATOM    137  CG  LEU    17      32.111  13.501  13.216  1.00 17.47           C  
ATOM    138  CD1 LEU    17      32.620  14.670  12.347  1.00 19.68           C  
ATOM    139  CD2 LEU    17      31.074  13.984  14.258  1.00 19.13           C  
ATOM    140  N   CYS    18      34.601  11.024  12.429  0.50 18.77           N  
ATOM    142  CA  CYS    18      35.503  10.383  13.334  0.50 18.68           C  
ATOM    144  C   CYS    18      35.329  11.084  14.662  0.50 17.75           C  
ATOM    146  O   CYS    18      35.414  12.342  14.749  0.50 17.11           O  
ATOM    148  CB  CYS    18      36.931  10.520  12.822  0.50 19.68           C  
ATOM    150  SG  CYS    18      38.169   9.741  13.895  0.50 25.35           S  
ATOM    152  N   VAL    19      35.090  10.285  15.703  1.00 17.60           N  
ATOM    153  CA  VAL    19      34.852  10.884  17.017  1.00 17.61           C  
ATOM    154  C   VAL    19      35.901  10.621  18.082  1.00 18.84           C  
ATOM    155  O   VAL    19      36.031  11.426  19.030  1.00 19.37           O  
ATOM    156  CB  VAL    19      33.441  10.554  17.541  1.00 18.37           C  
ATOM    157  CG1 VAL    19      32.386  11.066  16.565  1.00 19.97           C  
ATOM    158  CG2 VAL    19      33.285   9.036  17.807  1.00 19.29           C  
ATOM    159  N   TYR    20      36.659   9.537  17.949  1.00 17.79           N  
ATOM    160  CA  TYR    20      37.705   9.219  18.927  1.00 17.31           C  
ATOM    161  C   TYR    20      38.904   8.679  18.151  1.00 17.74           C  
ATOM    162  O   TYR    20      38.744   7.851  17.253  1.00 17.59           O  
ATOM    163  CB  TYR    20      37.239   8.164  19.938  1.00 18.63           C  
ATOM    164  CG  TYR    20      38.375   7.755  20.831  1.00 18.31           C  
ATOM    165  CD1 TYR    20      38.666   8.491  22.001  1.00 18.30           C  
ATOM    166  CD2 TYR    20      39.252   6.735  20.480  1.00 17.90           C  
ATOM    167  CE1 TYR    20      39.781   8.162  22.798  1.00 16.64           C  
ATOM    168  CE2 TYR    20      40.353   6.396  21.280  1.00 17.14           C  
ATOM    169  CZ  TYR    20      40.610   7.128  22.429  1.00 17.75           C  
ATOM    170  OH  TYR    20      41.720   6.807  23.204  1.00 18.23           O  
ATOM    171  N   LYS    21      40.092   9.175  18.494  0.50 18.45           N  
ATOM    173  CA  LYS    21      41.325   8.709  17.899  0.50 19.23           C  
ATOM    175  C   LYS    21      42.410   8.666  18.967  0.50 18.93           C  
ATOM    177  O   LYS    21      42.492   9.553  19.844  0.50 18.14           O  
ATOM    179  CB  LYS    21      41.769   9.654  16.755  0.50 19.72           C  
ATOM    181  CG  LYS    21      42.986   9.166  15.984  0.50 21.51           C  
ATOM    183  CD  LYS    21      43.277  10.047  14.777  0.50 22.28           C  
ATOM    185  CE  LYS    21      44.165   9.322  13.775  0.50 26.01           C  
ATOM    187  NZ  LYS    21      44.998  10.242  12.956  0.50 28.80           N  
ATOM    189  N   ASN    22      43.246   7.641  18.893  1.00 18.57           N  
ATOM    190  CA  ASN    22      44.510   7.675  19.646  1.00 19.63           C  
ATOM    191  C   ASN    22      45.633   7.170  18.740  1.00 20.21           C  
ATOM    192  O   ASN    22      45.442   7.146  17.525  1.00 21.67           O  
ATOM    193  CB  ASN    22      44.393   6.968  21.000  1.00 19.28           C  
ATOM    194  CG  ASN    22      44.119   5.476  20.878  1.00 18.68           C  
ATOM    195  OD1 ASN    22      44.477   4.855  19.876  1.00 18.07           O  
ATOM    196  ND2 ASN    22      43.512   4.893  21.908  1.00 19.31           N  
ATOM    197  N   GLU    23      46.798   6.802  19.268  0.50 20.33           N  
ATOM    199  CA  GLU    23      47.871   6.392  18.343  0.50 20.79           C  
ATOM    201  C   GLU    23      47.688   4.963  17.811  0.50 20.15           C  
ATOM    203  O   GLU    23      48.445   4.517  16.927  0.50 21.08           O  
ATOM    205  CB  GLU    23      49.271   6.615  18.948  0.50 21.32           C  
ATOM    207  CG  GLU    23      49.531   8.068  19.373  0.50 24.58           C  
ATOM    209  CD  GLU    23      49.988   9.002  18.251  0.50 28.91           C  
ATOM    211  OE1 GLU    23      50.063   8.588  17.074  0.50 31.75           O  
ATOM    213  OE2 GLU    23      50.296  10.181  18.573  0.50 31.68           O  
ATOM    215  N   LYS    24      46.657   4.262  18.314  1.00 19.87           N  
ATOM    216  CA  LYS    24      46.411   2.876  17.906  1.00 18.64           C  
ATOM    217  C   LYS    24      45.123   2.675  17.102  1.00 18.65           C  
ATOM    218  O   LYS    24      45.163   2.084  16.009  1.00 19.79           O  
ATOM    219  CB  LYS    24      46.397   1.937  19.115  1.00 19.67           C  
ATOM    220  CG  LYS    24      47.742   1.895  19.853  1.00 19.24           C  
ATOM    221  CD  LYS    24      47.728   0.842  20.946  1.00 23.27           C  
ATOM    222  CE  LYS    24      49.012   0.890  21.752  1.00 25.06           C  
ATOM    223  NZ  LYS    24      49.012  -0.142  22.838  1.00 26.49           N  
ATOM    224  N   TRP    25      43.996   3.147  17.659  1.00 17.80           N  
ATOM    225  CA  TRP    25      42.710   2.938  16.969  1.00 17.10           C  
ATOM    226  C   TRP    25      41.877   4.189  16.872  1.00 17.05           C  
ATOM    227  O   TRP    25      42.166   5.213  17.501  1.00 17.33           O  
ATOM    228  CB  TRP    25      41.866   1.812  17.636  1.00 17.38           C  
ATOM    229  CG  TRP    25      41.250   2.174  18.989  1.00 17.07           C  
ATOM    230  CD1 TRP    25      40.015   2.746  19.223  1.00 17.16           C  
ATOM    231  CD2 TRP    25      41.857   2.004  20.276  1.00 17.43           C  
ATOM    232  NE1 TRP    25      39.803   2.914  20.576  1.00 16.55           N  
ATOM    233  CE2 TRP    25      40.925   2.472  21.248  1.00 16.10           C  
ATOM    234  CE3 TRP    25      43.109   1.515  20.713  1.00 17.97           C  
ATOM    235  CZ2 TRP    25      41.217   2.471  22.613  1.00 17.89           C  
ATOM    236  CZ3 TRP    25      43.372   1.485  22.082  1.00 18.95           C  
ATOM    237  CH2 TRP    25      42.441   1.975  23.006  1.00 18.93           C  
ATOM    238  N   LEU    26      40.846   4.125  16.057  0.60 17.36           N  
ATOM    240  CA  LEU    26      39.876   5.195  16.053  0.60 18.29           C  
ATOM    242  C   LEU    26      38.473   4.598  16.034  0.60 17.48           C  
ATOM    244  O   LEU    26      38.259   3.406  15.788  0.60 17.47           O  
ATOM    246  CB  LEU    26      40.140   6.186  14.899  0.60 19.00           C  
ATOM    248  CG  LEU    26      40.146   5.630  13.476  0.60 19.25           C  
ATOM    250  CD1 LEU    26      38.728   5.417  13.012  0.60 20.31           C  
ATOM    252  CD2 LEU    26      40.883   6.556  12.503  0.60 20.54           C  
ATOM    254  N   VAL    27      37.519   5.464  16.315  1.00 16.98           N  
ATOM    255  CA  VAL    27      36.079   5.101  16.320  1.00 16.22           C  
ATOM    256  C   VAL    27      35.324   6.179  15.576  1.00 17.45           C  
ATOM    257  O   VAL    27      35.516   7.373  15.844  1.00 17.46           O  
ATOM    258  CB  VAL    27      35.508   5.013  17.747  1.00 17.18           C  
ATOM    259  CG1 VAL    27      34.016   4.551  17.698  1.00 17.61           C  
ATOM    260  CG2 VAL    27      36.386   4.029  18.599  1.00 18.01           C  
ATOM    261  N   CYS    28      34.532   5.742  14.596  1.00 16.21           N  
ATOM    262  CA  CYS    28      33.759   6.689  13.774  1.00 16.26           C  
ATOM    263  C   CYS    28      32.281   6.352  13.879  1.00 16.20           C  
ATOM    264  O   CYS    28      31.899   5.183  14.110  1.00 16.98           O  
ATOM    265  CB  CYS    28      34.172   6.658  12.295  1.00 17.39           C  
ATOM    266  SG  CYS    28      35.986   6.912  12.142  1.00 20.98           S  
ATOM    267  N   ILE    29      31.448   7.378  13.699  1.00 15.71           N  
ATOM    268  CA  ILE    29      30.004   7.183  13.582  1.00 16.13           C  
ATOM    269  C   ILE    29      29.622   7.517  12.143  1.00 16.17           C  
ATOM    270  O   ILE    29      29.951   8.598  11.640  1.00 16.02           O  
ATOM    271  CB  ILE    29      29.218   8.103  14.534  1.00 15.82           C  
ATOM    272  CG1 ILE    29      29.672   7.931  15.981  1.00 15.39           C  
ATOM    273  CG2 ILE    29      27.672   7.900  14.365  1.00 16.09           C  
ATOM    274  CD1 ILE    29      29.037   8.958  16.945  1.00 16.58           C  
ATOM    275  N   LYS    30      28.964   6.585  11.458  1.00 15.88           N  
ATOM    276  CA  LYS    30      28.619   6.785  10.046  1.00 16.21           C  
ATOM    277  C   LYS    30      27.111   6.820   9.855  1.00 16.94           C  
ATOM    278  O   LYS    30      26.400   5.844  10.190  1.00 17.39           O  
ATOM    279  CB  LYS    30      29.211   5.653   9.187  1.00 16.56           C  
ATOM    280  CG  LYS    30      28.903   5.844   7.679  1.00 16.88           C  
ATOM    281  CD  LYS    30      29.732   4.833   6.862  1.00 19.31           C  
ATOM    282  CE  LYS    30      28.991   3.507   6.870  1.00 23.50           C  
ATOM    283  NZ  LYS    30      29.684   2.542   5.986  1.00 28.32           N  
ATOM    284  N   ASN    31      26.611   7.913   9.293  1.00 16.40           N  
ATOM    285  CA  ASN    31      25.209   8.052   8.889  1.00 17.24           C  
ATOM    286  C   ASN    31      25.092   7.792   7.399  1.00 16.60           C  
ATOM    287  O   ASN    31      26.100   7.564   6.719  1.00 16.88           O  
ATOM    288  CB  ASN    31      24.767   9.479   9.184  1.00 17.08           C  
ATOM    289  CG  ASN    31      24.690   9.754  10.673  1.00 17.35           C  
ATOM    290  OD1 ASN    31      24.445   8.818  11.459  1.00 18.51           O  
ATOM    291  ND2 ASN    31      24.915  11.008  11.075  1.00 17.06           N  
ATOM    292  N   TRP    32      23.871   7.844   6.911  1.00 16.43           N  
ATOM    293  CA  TRP    32      23.640   7.654   5.477  1.00 16.87           C  
ATOM    294  C   TRP    32      24.449   8.658   4.661  1.00 16.97           C  
ATOM    295  O   TRP    32      24.639   9.823   5.074  1.00 16.70           O  
ATOM    296  CB  TRP    32      22.156   7.862   5.182  1.00 17.49           C  
ATOM    297  CG  TRP    32      21.767   7.703   3.743  1.00 17.90           C  
ATOM    298  CD1 TRP    32      21.359   6.557   3.112  1.00 18.47           C  
ATOM    299  CD2 TRP    32      21.714   8.745   2.762  1.00 18.65           C  
ATOM    300  NE1 TRP    32      21.081   6.816   1.771  1.00 18.32           N  
ATOM    301  CE2 TRP    32      21.286   8.155   1.538  1.00 18.64           C  
ATOM    302  CE3 TRP    32      22.008  10.118   2.789  1.00 19.67           C  
ATOM    303  CZ2 TRP    32      21.111   8.911   0.360  1.00 20.15           C  
ATOM    304  CZ3 TRP    32      21.847  10.867   1.615  1.00 19.53           C  
ATOM    305  CH2 TRP    32      21.417  10.252   0.420  1.00 19.49           C  
ATOM    306  N   LYS    33      24.952   8.206   3.512  0.50 17.41           N  
ATOM    308  CA  LYS    33      25.520   9.105   2.498  0.50 17.81           C  
ATOM    310  C   LYS    33      25.221   8.457   1.149  0.50 17.76           C  
ATOM    312  O   LYS    33      25.111   7.233   1.067  0.50 17.30           O  
ATOM    314  CB  LYS    33      27.029   9.355   2.697  0.50 18.50           C  
ATOM    316  CG  LYS    33      27.905   8.108   2.859  0.50 17.53           C  
ATOM    318  CD  LYS    33      29.408   8.459   2.928  0.50 18.75           C  
ATOM    320  CE  LYS    33      30.249   7.268   3.434  0.50 20.65           C  
ATOM    322  NZ  LYS    33      30.410   6.095   2.495  0.50 16.18           N  
ATOM    324  N   PRO    34      25.079   9.276   0.086  1.00 18.09           N  
ATOM    325  CA  PRO    34      24.701   8.769  -1.247  1.00 17.70           C  
ATOM    326  C   PRO    34      25.425   7.508  -1.743  1.00 17.56           C  
ATOM    327  O   PRO    34      24.713   6.627  -2.293  1.00 18.77           O  
ATOM    328  CB  PRO    34      24.961   9.981  -2.167  1.00 18.28           C  
ATOM    329  CG  PRO    34      24.611  11.156  -1.256  1.00 18.87           C  
ATOM    330  CD  PRO    34      25.223  10.745   0.112  1.00 18.21           C  
ATOM    331  N   ASP    35      26.747   7.350  -1.534  1.00 17.59           N  
ATOM    332  CA  ASP    35      27.385   6.155  -2.089  1.00 18.40           C  
ATOM    333  C   ASP    35      27.192   4.889  -1.257  1.00 18.59           C  
ATOM    334  O   ASP    35      27.739   3.819  -1.588  1.00 19.50           O  
ATOM    335  CB  ASP    35      28.859   6.364  -2.436  1.00 20.01           C  
ATOM    336  CG  ASP    35      29.792   6.326  -1.216  1.00 22.64           C  
ATOM    337  OD1 ASP    35      29.327   6.354  -0.069  1.00 22.36           O  
ATOM    338  OD2 ASP    35      31.036   6.280  -1.401  1.00 23.21           O  
ATOM    339  N   ASN    36      26.428   5.029  -0.175  1.00 18.02           N  
ATOM    340  CA  ASN    36      25.942   3.845   0.531  1.00 17.85           C  
ATOM    341  C   ASN    36      24.460   3.595   0.249  1.00 17.64           C  
ATOM    342  O   ASN    36      23.911   2.588   0.689  1.00 18.05           O  
ATOM    343  CB  ASN    36      26.070   3.983   2.065  1.00 17.18           C  
ATOM    344  CG  ASN    36      27.514   3.879   2.602  1.00 21.55           C  
ATOM    345  OD1 ASN    36      27.793   4.451   3.630  1.00 30.18           O  
ATOM    346  ND2 ASN    36      28.382   3.116   1.979  1.00 22.47           N  
ATOM    347  N   ASP    37      23.767   4.533  -0.402  1.00 17.32           N  
ATOM    348  CA  ASP    37      22.368   4.259  -0.719  1.00 17.22           C  
ATOM    349  C   ASP    37      22.249   3.126  -1.732  1.00 17.35           C  
ATOM    350  O   ASP    37      23.126   2.958  -2.584  1.00 16.67           O  
ATOM    351  CB  ASP    37      21.719   5.511  -1.320  1.00 17.88           C  
ATOM    352  CG  ASP    37      20.216   5.393  -1.364  1.00 19.89           C  
ATOM    353  OD1 ASP    37      19.582   5.512  -0.288  1.00 21.62           O  
ATOM    354  OD2 ASP    37      19.642   5.158  -2.463  1.00 21.16           O  
ATOM    355  N   ILE    38      21.133   2.394  -1.689  1.00 17.76           N  
ATOM    356  CA  ILE    38      20.948   1.345  -2.698  1.00 19.14           C  
ATOM    357  C   ILE    38      21.100   1.900  -4.142  1.00 19.71           C  
ATOM    358  O   ILE    38      21.650   1.209  -5.026  1.00 20.54           O  
ATOM    359  CB  ILE    38      19.631   0.599  -2.485  1.00 20.17           C  
ATOM    360  CG1 ILE    38      19.657  -0.700  -3.319  1.00 23.22           C  
ATOM    361  CG2 ILE    38      18.432   1.531  -2.673  1.00 21.76           C  
ATOM    362  CD1 ILE    38      18.852  -1.758  -2.799  1.00 26.67           C  
ATOM    363  N   GLU    39      20.657   3.123  -4.368  0.60 18.65           N  
ATOM    365  CA  GLU    39      20.767   3.699  -5.713  0.60 19.62           C  
ATOM    367  C   GLU    39      22.157   4.152  -6.078  0.60 18.83           C  
ATOM    369  O   GLU    39      22.462   4.334  -7.279  0.60 18.82           O  
ATOM    371  CB  GLU    39      19.802   4.868  -5.875  0.60 20.14           C  
ATOM    373  CG  GLU    39      18.363   4.498  -5.623  0.60 22.99           C  
ATOM    375  CD  GLU    39      17.802   3.417  -6.560  0.60 26.07           C  
ATOM    377  OE1 GLU    39      18.361   3.139  -7.646  0.60 28.94           O  
ATOM    379  OE2 GLU    39      16.752   2.856  -6.193  0.60 29.97           O  
ATOM    381  N   GLY    40      22.978   4.383  -5.045  1.00 18.92           N  
ATOM    382  CA  GLY    40      24.291   5.006  -5.202  1.00 18.70           C  
ATOM    383  C   GLY    40      25.463   4.046  -5.085  1.00 19.12           C  
ATOM    384  O   GLY    40      26.595   4.471  -5.205  1.00 19.59           O  
ATOM    385  N   ILE    41      25.200   2.751  -4.884  0.60 18.76           N  
ATOM    387  CA  ILE    41      26.291   1.771  -4.803  0.60 18.02           C  
ATOM    389  C   ILE    41      27.102   1.716  -6.095  0.60 19.31           C  
ATOM    391  O   ILE    41      26.554   1.450  -7.164  0.60 19.38           O  
ATOM    393  CB  ILE    41      25.747   0.371  -4.471  0.60 18.50           C  
ATOM    395  CG1 ILE    41      25.154   0.371  -3.047  0.60 16.67           C  
ATOM    397  CG2 ILE    41      26.865  -0.693  -4.714  0.60 18.56           C  
ATOM    399  CD1 ILE    41      26.117   0.701  -1.919  0.60 18.37           C  
ATOM    401  N   ALA    42      28.406   1.999  -6.003  1.00 18.68           N  
ATOM    402  CA  ALA    42      29.215   2.174  -7.214  1.00 18.88           C  
ATOM    403  C   ALA    42      30.629   1.659  -7.102  1.00 18.31           C  
ATOM    404  O   ALA    42      31.295   1.493  -8.116  1.00 19.25           O  
ATOM    405  CB  ALA    42      29.242   3.688  -7.591  1.00 20.23           C  
ATOM    406  N   HIS    43      31.115   1.464  -5.871  1.00 18.00           N  
ATOM    407  CA  HIS    43      32.509   1.052  -5.664  1.00 16.78           C  
ATOM    408  C   HIS    43      32.608   0.370  -4.335  1.00 17.54           C  
ATOM    409  O   HIS    43      31.736   0.546  -3.468  1.00 17.90           O  
ATOM    410  CB  HIS    43      33.476   2.259  -5.653  1.00 17.86           C  
ATOM    411  CG  HIS    43      32.934   3.453  -4.934  1.00 19.00           C  
ATOM    412  ND1 HIS    43      32.468   4.574  -5.596  1.00 21.45           N  
ATOM    413  CD2 HIS    43      32.713   3.670  -3.607  1.00 20.87           C  
ATOM    414  CE1 HIS    43      32.005   5.442  -4.703  1.00 21.76           C  
ATOM    415  NE2 HIS    43      32.134   4.915  -3.491  1.00 19.81           N  
ATOM    416  N   LEU    44      33.631  -0.452  -4.191  1.00 16.28           N  
ATOM    417  CA  LEU    44      33.989  -1.078  -2.928  1.00 17.41           C  
ATOM    418  C   LEU    44      35.303  -0.515  -2.426  1.00 17.57           C  
ATOM    419  O   LEU    44      36.044   0.102  -3.192  1.00 17.75           O  
ATOM    420  CB  LEU    44      34.140  -2.601  -3.105  1.00 17.41           C  
ATOM    421  CG  LEU    44      32.923  -3.314  -3.708  1.00 17.06           C  
ATOM    422  CD1 LEU    44      33.208  -4.832  -3.740  1.00 18.99           C  
ATOM    423  CD2 LEU    44      31.642  -3.059  -2.890  1.00 17.87           C  
ATOM    424  N   GLU    45      35.613  -0.780  -1.153  1.00 17.32           N  
ATOM    425  CA  GLU    45      36.838  -0.282  -0.525  1.00 17.85           C  
ATOM    426  C   GLU    45      37.617  -1.484  -0.022  1.00 17.53           C  
ATOM    427  O   GLU    45      37.061  -2.561   0.258  1.00 17.19           O  
ATOM    428  CB  GLU    45      36.464   0.633   0.652  1.00 17.71           C  
ATOM    429  CG  GLU    45      37.645   1.395   1.289  1.00 20.73           C  
ATOM    430  CD  GLU    45      37.161   2.412   2.345  1.00 20.50           C  
ATOM    431  OE1 GLU    45      35.935   2.549   2.565  1.00 24.99           O  
ATOM    432  OE2 GLU    45      38.030   3.068   2.921  1.00 32.85           O  
ATOM    433  N   ILE    46      38.916  -1.284   0.170  1.00 18.33           N  
ATOM    434  CA  ILE    46      39.732  -2.349   0.745  1.00 17.98           C  
ATOM    435  C   ILE    46      40.781  -1.674   1.626  1.00 18.08           C  
ATOM    436  O   ILE    46      41.329  -0.614   1.260  1.00 18.26           O  
ATOM    437  CB  ILE    46      40.416  -3.214  -0.352  1.00 18.64           C  
ATOM    438  CG1 ILE    46      41.137  -4.429   0.253  1.00 18.66           C  
ATOM    439  CG2 ILE    46      41.422  -2.371  -1.208  1.00 19.08           C  
ATOM    440  CD1 ILE    46      41.531  -5.521  -0.807  1.00 19.38           C  
ATOM    441  N   HIS    47      41.048  -2.282   2.786  1.00 16.96           N  
ATOM    442  CA  HIS    47      42.132  -1.817   3.653  1.00 17.05           C  
ATOM    443  C   HIS    47      43.253  -2.845   3.589  1.00 18.55           C  
ATOM    444  O   HIS    47      43.075  -4.019   3.928  1.00 19.63           O  
ATOM    445  CB  HIS    47      41.662  -1.750   5.117  1.00 16.94           C  
ATOM    446  CG  HIS    47      40.576  -0.758   5.342  1.00 18.33           C  
ATOM    447  ND1 HIS    47      40.674   0.562   4.944  1.00 20.82           N  
ATOM    448  CD2 HIS    47      39.376  -0.884   5.957  1.00 18.76           C  
ATOM    449  CE1 HIS    47      39.567   1.204   5.295  1.00 22.99           C  
ATOM    450  NE2 HIS    47      38.777   0.359   5.929  1.00 21.68           N  
ATOM    451  N   HIS    48      44.436  -2.396   3.203  1.00 19.42           N  
ATOM    452  CA  HIS    48      45.560  -3.339   3.148  1.00 19.25           C  
ATOM    453  C   HIS    48      46.243  -3.658   4.465  1.00 20.51           C  
ATOM    454  O   HIS    48      46.962  -4.659   4.545  1.00 22.55           O  
ATOM    455  CB  HIS    48      46.594  -2.852   2.116  1.00 19.61           C  
ATOM    456  CG  HIS    48      46.001  -2.629   0.756  1.00 19.32           C  
ATOM    457  ND1 HIS    48      45.428  -3.647   0.021  1.00 21.37           N  
ATOM    458  CD2 HIS    48      45.871  -1.508   0.005  1.00 21.07           C  
ATOM    459  CE1 HIS    48      44.980  -3.168  -1.128  1.00 23.63           C  
ATOM    460  NE2 HIS    48      45.210  -1.868  -1.151  1.00 20.64           N  
ATOM    461  N   SER    49      45.998  -2.843   5.488  0.50 19.93           N  
ATOM    463  CA  SER    49      46.805  -2.926   6.702  0.50 19.80           C  
ATOM    465  C   SER    49      46.013  -2.977   8.005  0.50 19.98           C  
ATOM    467  O   SER    49      46.602  -3.081   9.079  0.50 19.76           O  
ATOM    469  CB  SER    49      47.783  -1.755   6.733  0.50 21.12           C  
ATOM    471  OG  SER    49      48.664  -1.820   5.623  0.50 20.88           O  
ATOM    473  N   THR    50      44.689  -2.893   7.908  1.00 19.07           N  
ATOM    474  CA  THR    50      43.835  -2.910   9.105  1.00 18.53           C  
ATOM    475  C   THR    50      42.602  -3.775   8.911  1.00 18.49           C  
ATOM    476  O   THR    50      42.030  -3.815   7.816  1.00 18.74           O  
ATOM    477  CB  THR    50      43.401  -1.487   9.583  1.00 19.33           C  
ATOM    478  OG1 THR    50      42.743  -1.587  10.864  1.00 18.04           O  
ATOM    479  CG2 THR    50      42.423  -0.839   8.629  1.00 18.56           C  
ATOM    480  N   ASP    51      42.210  -4.431   9.995  1.00 17.41           N  
ATOM    481  CA  ASP    51      40.881  -4.992  10.096  1.00 17.63           C  
ATOM    482  C   ASP    51      39.907  -3.856  10.464  1.00 17.46           C  
ATOM    483  O   ASP    51      40.329  -2.803  10.977  1.00 17.76           O  
ATOM    484  CB  ASP    51      40.800  -6.071  11.184  1.00 17.59           C  
ATOM    485  CG  ASP    51      41.726  -7.267  10.947  1.00 19.72           C  
ATOM    486  OD1 ASP    51      42.217  -7.479   9.811  1.00 20.29           O  
ATOM    487  OD2 ASP    51      41.972  -8.026  11.927  1.00 20.23           O  
ATOM    488  N   GLU    52      38.607  -4.071  10.242  1.00 16.99           N  
ATOM    489  CA  GLU    52      37.626  -3.062  10.649  1.00 16.56           C  
ATOM    490  C   GLU    52      36.385  -3.735  11.205  1.00 16.04           C  
ATOM    491  O   GLU    52      35.928  -4.744  10.655  1.00 16.25           O  
ATOM    492  CB  GLU    52      37.261  -2.210   9.428  1.00 17.33           C  
ATOM    493  CG  GLU    52      36.173  -1.163   9.732  1.00 16.96           C  
ATOM    494  CD  GLU    52      35.956  -0.161   8.605  1.00 20.76           C  
ATOM    495  OE1 GLU    52      36.723  -0.186   7.649  1.00 25.16           O  
ATOM    496  OE2 GLU    52      35.003   0.653   8.675  1.00 22.73           O  
ATOM    497  N   GLN    53      35.891  -3.230  12.338  1.00 15.29           N  
ATOM    498  CA  GLN    53      34.665  -3.780  12.905  1.00 15.57           C  
ATOM    499  C   GLN    53      33.520  -2.794  12.783  1.00 15.96           C  
ATOM    500  O   GLN    53      33.738  -1.562  12.838  1.00 16.46           O  
ATOM    501  CB  GLN    53      34.829  -4.170  14.375  1.00 16.29           C  
ATOM    502  CG  GLN    53      35.923  -5.262  14.568  1.00 16.43           C  
ATOM    503  CD  GLN    53      37.313  -4.679  14.546  1.00 16.79           C  
ATOM    504  OE1 GLN    53      37.608  -3.724  15.302  1.00 18.53           O  
ATOM    505  NE2 GLN    53      38.222  -5.243  13.706  1.00 17.69           N  
ATOM    506  N   PHE    54      32.304  -3.328  12.595  1.00 15.22           N  
ATOM    507  CA  PHE    54      31.127  -2.504  12.339  1.00 16.12           C  
ATOM    508  C   PHE    54      30.054  -2.893  13.333  1.00 16.75           C  
ATOM    509  O   PHE    54      29.820  -4.072  13.596  1.00 16.26           O  
ATOM    510  CB  PHE    54      30.589  -2.820  10.928  1.00 18.13           C  
ATOM    511  CG  PHE    54      31.582  -2.567   9.813  1.00 18.64           C  
ATOM    512  CD1 PHE    54      31.539  -1.357   9.108  1.00 23.57           C  
ATOM    513  CD2 PHE    54      32.565  -3.497   9.498  1.00 20.61           C  
ATOM    514  CE1 PHE    54      32.466  -1.122   8.039  1.00 23.85           C  
ATOM    515  CE2 PHE    54      33.469  -3.245   8.445  1.00 21.03           C  
ATOM    516  CZ  PHE    54      33.403  -2.103   7.732  1.00 23.10           C  
ATOM    517  N   ILE    55      29.342  -1.885  13.826  1.00 16.51           N  
ATOM    518  CA  ILE    55      28.284  -2.074  14.793  1.00 17.03           C  
ATOM    519  C   ILE    55      27.113  -1.256  14.344  1.00 17.63           C  
ATOM    520  O   ILE    55      27.219  -0.042  14.280  1.00 19.02           O  
ATOM    521  CB  ILE    55      28.722  -1.606  16.189  1.00 17.26           C  
ATOM    522  CG1 ILE    55      29.903  -2.450  16.650  1.00 19.11           C  
ATOM    523  CG2 ILE    55      27.555  -1.596  17.205  1.00 20.27           C  
ATOM    524  CD1 ILE    55      30.713  -1.812  17.871  1.00 21.34           C  
ATOM    525  N   LEU    56      25.977  -1.905  14.085  1.00 16.33           N  
ATOM    526  CA  LEU    56      24.747  -1.204  13.647  1.00 16.30           C  
ATOM    527  C   LEU    56      24.031  -0.642  14.872  1.00 18.33           C  
ATOM    528  O   LEU    56      23.734  -1.411  15.823  1.00 18.34           O  
ATOM    529  CB  LEU    56      23.830  -2.203  12.892  1.00 16.00           C  
ATOM    530  CG  LEU    56      22.516  -1.620  12.334  1.00 17.40           C  
ATOM    531  CD1 LEU    56      22.773  -0.483  11.297  1.00 17.23           C  
ATOM    532  CD2 LEU    56      21.728  -2.718  11.668  1.00 17.81           C  
ATOM    533  N   SER    57      23.668   0.645  14.801  1.00 16.83           N  
ATOM    534  CA  SER    57      22.992   1.328  15.912  1.00 17.51           C  
ATOM    535  C   SER    57      21.512   1.580  15.625  1.00 17.72           C  
ATOM    536  O   SER    57      20.643   1.305  16.491  1.00 19.77           O  
ATOM    537  CB  SER    57      23.699   2.672  16.203  1.00 18.26           C  
ATOM    538  OG  SER    57      23.076   3.279  17.342  1.00 19.31           O  
ATOM    539  N   ALA    58      21.206   2.078  14.435  1.00 17.62           N  
ATOM    540  CA  ALA    58      19.819   2.443  14.049  1.00 17.30           C  
ATOM    541  C   ALA    58      19.572   2.038  12.608  1.00 17.02           C  
ATOM    542  O   ALA    58      20.517   1.998  11.804  1.00 17.01           O  
ATOM    543  CB  ALA    58      19.608   3.979  14.147  1.00 18.83           C  
ATOM    544  N   GLY    59      18.307   1.766  12.274  1.00 17.28           N  
ATOM    545  CA  GLY    59      17.964   1.495  10.891  1.00 16.19           C  
ATOM    546  C   GLY    59      18.505   0.148  10.443  1.00 16.70           C  
ATOM    547  O   GLY    59      18.883  -0.706  11.262  1.00 18.82           O  
ATOM    548  N   LYS    60      18.516  -0.003   9.130  1.00 17.10           N  
ATOM    549  CA  LYS    60      18.939  -1.270   8.509  1.00 17.10           C  
ATOM    550  C   LYS    60      20.211  -1.057   7.731  1.00 16.91           C  
ATOM    551  O   LYS    60      20.491   0.048   7.223  1.00 17.29           O  
ATOM    552  CB  LYS    60      17.868  -1.789   7.539  1.00 17.78           C  
ATOM    553  CG  LYS    60      16.534  -2.132   8.176  1.00 19.75           C  
ATOM    554  CD  LYS    60      15.542  -2.331   7.033  1.00 23.56           C  
ATOM    555  CE  LYS    60      14.212  -2.731   7.566  1.00 28.36           C  
ATOM    556  NZ  LYS    60      13.370  -2.904   6.333  1.00 31.59           N  
ATOM    557  N   ALA    61      21.001  -2.123   7.606  1.00 16.77           N  
ATOM    558  CA  ALA    61      22.221  -2.028   6.802  1.00 16.67           C  
ATOM    559  C   ALA    61      22.629  -3.387   6.313  1.00 15.90           C  
ATOM    560  O   ALA    61      22.370  -4.390   6.973  1.00 16.52           O  
ATOM    561  CB  ALA    61      23.365  -1.431   7.605  1.00 17.21           C  
ATOM    562  N   ILE    62      23.253  -3.381   5.140  1.00 15.63           N  
ATOM    563  CA  ILE    62      23.855  -4.564   4.557  1.00 16.08           C  
ATOM    564  C   ILE    62      25.346  -4.326   4.359  1.00 16.56           C  
ATOM    565  O   ILE    62      25.774  -3.236   3.948  1.00 17.64           O  
ATOM    566  CB  ILE    62      23.180  -4.862   3.187  1.00 16.18           C  
ATOM    567  CG1 ILE    62      21.712  -5.258   3.409  1.00 16.39           C  
ATOM    568  CG2 ILE    62      23.914  -5.966   2.429  1.00 17.86           C  
ATOM    569  CD1 ILE    62      20.897  -5.187   2.113  1.00 18.67           C  
ATOM    570  N   LEU    63      26.139  -5.328   4.702  0.60 17.10           N  
ATOM    572  CA  LEU    63      27.582  -5.258   4.487  0.60 17.07           C  
ATOM    574  C   LEU    63      27.917  -6.113   3.262  0.60 17.18           C  
ATOM    576  O   LEU    63      27.628  -7.325   3.249  0.60 17.35           O  
ATOM    578  CB  LEU    63      28.314  -5.806   5.717  0.60 17.84           C  
ATOM    580  CG  LEU    63      29.835  -5.699   5.783  0.60 19.15           C  
ATOM    582  CD1 LEU    63      30.335  -4.263   5.645  0.60 20.68           C  
ATOM    584  CD2 LEU    63      30.261  -6.285   7.125  0.60 20.79           C  
ATOM    586  N   ILE    64      28.462  -5.489   2.213  1.00 17.14           N  
ATOM    587  CA  ILE    64      28.939  -6.178   1.043  1.00 17.08           C  
ATOM    588  C   ILE    64      30.369  -6.603   1.362  1.00 17.38           C  
ATOM    589  O   ILE    64      31.166  -5.790   1.854  1.00 17.79           O  
ATOM    590  CB  ILE    64      29.025  -5.221  -0.204  1.00 17.12           C  
ATOM    591  CG1 ILE    64      27.653  -4.600  -0.477  1.00 20.00           C  
ATOM    592  CG2 ILE    64      29.565  -5.973  -1.440  1.00 18.04           C  
ATOM    593  CD1 ILE    64      27.724  -3.368  -1.404  1.00 18.37           C  
ATOM    594  N   THR    65      30.692  -7.855   1.036  1.00 17.86           N  
ATOM    595  CA  THR    65      32.085  -8.292   1.054  1.00 18.12           C  
ATOM    596  C   THR    65      32.351  -8.962  -0.277  1.00 18.58           C  
ATOM    597  O   THR    65      31.426  -9.489  -0.913  1.00 19.44           O  
ATOM    598  CB  THR    65      32.442  -9.196   2.224  1.00 18.08           C  
ATOM    599  OG1 THR    65      31.489 -10.258   2.313  1.00 17.62           O  
ATOM    600  CG2 THR    65      32.480  -8.375   3.559  1.00 18.10           C  
ATOM    601  N   ALA    66      33.604  -8.910  -0.732  1.00 18.05           N  
ATOM    602  CA  ALA    66      33.887  -9.450  -2.064  1.00 19.25           C  
ATOM    603  C   ALA    66      35.328  -9.878  -2.199  1.00 20.53           C  
ATOM    604  O   ALA    66      36.212  -9.407  -1.476  1.00 19.89           O  
ATOM    605  CB  ALA    66      33.524  -8.414  -3.132  1.00 18.61           C  
ATOM    606  N   GLU    67      35.552 -10.810  -3.119  0.50 21.75           N  
ATOM    608  CA  GLU    67      36.905 -11.053  -3.604  0.50 23.27           C  
ATOM    610  C   GLU    67      36.961 -10.670  -5.072  0.50 23.78           C  
ATOM    612  O   GLU    67      35.966 -10.742  -5.801  0.50 23.10           O  
ATOM    614  CB  GLU    67      37.331 -12.510  -3.419  0.50 24.24           C  
ATOM    616  CG  GLU    67      36.394 -13.509  -4.035  0.50 24.63           C  
ATOM    618  CD  GLU    67      37.087 -14.820  -4.402  0.50 28.22           C  
ATOM    620  OE1 GLU    67      38.147 -15.137  -3.823  0.50 32.90           O  
ATOM    622  OE2 GLU    67      36.559 -15.533  -5.271  0.50 28.66           O  
ATOM    624  N   LYS    68      38.146 -10.272  -5.497  1.00 25.28           N  
ATOM    625  CA  LYS    68      38.360  -9.857  -6.863  1.00 28.72           C  
ATOM    626  C   LYS    68      39.027 -11.029  -7.554  1.00 32.09           C  
ATOM    627  O   LYS    68      40.039 -11.551  -7.074  1.00 31.54           O  
ATOM    628  CB  LYS    68      39.241  -8.601  -6.884  1.00 29.61           C  
ATOM    629  CG  LYS    68      39.108  -7.741  -8.117  1.00 31.87           C  
ATOM    630  CD  LYS    68      40.084  -6.600  -7.985  1.00 36.13           C  
ATOM    631  CE  LYS    68      39.622  -5.388  -8.724  1.00 38.28           C  
ATOM    632  NZ  LYS    68      40.805  -4.612  -9.152  1.00 39.70           N  
ATOM    633  N   GLU    69      38.424 -11.473  -8.649  1.00 35.03           N  
ATOM    634  CA  GLU    69      38.917 -12.620  -9.406  1.00 39.92           C  
ATOM    635  C   GLU    69      39.030 -12.134 -10.841  1.00 40.91           C  
ATOM    636  O   GLU    69      38.033 -11.714 -11.454  1.00 41.18           O  
ATOM    637  CB  GLU    69      37.931 -13.779  -9.292  1.00 39.88           C  
ATOM    638  CG  GLU    69      38.377 -15.100  -9.892  1.00 43.51           C  
ATOM    639  CD  GLU    69      37.375 -16.216  -9.594  1.00 44.52           C  
ATOM    640  OE1 GLU    69      36.155 -16.024  -9.860  1.00 48.99           O  
ATOM    641  OE2 GLU    69      37.811 -17.284  -9.089  1.00 51.23           O  
ATOM    642  N   ASN    70      40.251 -12.181 -11.367  1.00 42.55           N  
ATOM    643  CA  ASN    70      40.575 -11.491 -12.608  1.00 43.92           C  
ATOM    644  C   ASN    70      40.117 -10.034 -12.458  1.00 43.58           C  
ATOM    645  O   ASN    70      40.566  -9.346 -11.534  1.00 44.59           O  
ATOM    646  CB  ASN    70      39.956 -12.229 -13.798  1.00 44.78           C  
ATOM    647  CG  ASN    70      40.392 -13.702 -13.857  1.00 47.87           C  
ATOM    648  OD1 ASN    70      39.561 -14.621 -13.749  1.00 50.12           O  
ATOM    649  ND2 ASN    70      41.705 -13.928 -13.996  1.00 49.37           N  
ATOM    650  N   ASP    71      39.205  -9.566 -13.303  1.00 42.45           N  
ATOM    651  CA  ASP    71      38.738  -8.185 -13.157  1.00 40.43           C  
ATOM    652  C   ASP    71      37.290  -8.046 -12.683  1.00 37.49           C  
ATOM    653  O   ASP    71      36.686  -6.980 -12.864  1.00 38.69           O  
ATOM    654  CB  ASP    71      38.957  -7.396 -14.460  1.00 42.43           C  
ATOM    655  CG  ASP    71      40.191  -6.496 -14.398  1.00 45.99           C  
ATOM    656  OD1 ASP    71      40.131  -5.434 -13.716  1.00 49.92           O  
ATOM    657  OD2 ASP    71      41.221  -6.850 -15.031  1.00 50.27           O  
ATOM    658  N   LYS    72      36.767  -9.099 -12.049  0.50 35.27           N  
ATOM    660  CA  LYS    72      35.371  -9.161 -11.600  0.50 32.39           C  
ATOM    662  C   LYS    72      35.275  -9.506 -10.110  0.50 29.34           C  
ATOM    664  O   LYS    72      36.090 -10.275  -9.587  0.50 28.53           O  
ATOM    666  CB  LYS    72      34.591 -10.201 -12.415  0.50 33.11           C  
ATOM    668  CG  LYS    72      34.608  -9.996 -13.937  0.50 35.22           C  
ATOM    670  CD  LYS    72      33.882  -8.716 -14.352  0.50 38.16           C  
ATOM    672  CE  LYS    72      34.141  -8.381 -15.814  0.50 39.07           C  
ATOM    674  NZ  LYS    72      33.714  -6.985 -16.107  0.50 40.06           N  
ATOM    676  N   PHE    73      34.262  -8.964  -9.438  1.00 26.19           N  
ATOM    677  CA  PHE    73      34.074  -9.258  -8.021  1.00 23.01           C  
ATOM    678  C   PHE    73      33.128 -10.431  -7.845  1.00 22.56           C  
ATOM    679  O   PHE    73      32.081 -10.476  -8.500  1.00 23.23           O  
ATOM    680  CB  PHE    73      33.469  -8.031  -7.331  1.00 20.77           C  
ATOM    681  CG  PHE    73      34.463  -6.919  -7.084  1.00 21.12           C  
ATOM    682  CD1 PHE    73      35.500  -7.085  -6.160  1.00 19.24           C  
ATOM    683  CD2 PHE    73      34.334  -5.723  -7.758  1.00 21.62           C  
ATOM    684  CE1 PHE    73      36.375  -6.072  -5.895  1.00 21.26           C  
ATOM    685  CE2 PHE    73      35.228  -4.661  -7.503  1.00 22.84           C  
ATOM    686  CZ  PHE    73      36.266  -4.864  -6.584  1.00 21.71           C  
ATOM    687  N   ASN    74      33.495 -11.335  -6.947  1.00 21.12           N  
ATOM    688  CA  ASN    74      32.560 -12.346  -6.421  1.00 20.80           C  
ATOM    689  C   ASN    74      31.983 -11.719  -5.159  1.00 20.55           C  
ATOM    690  O   ASN    74      32.750 -11.406  -4.236  1.00 22.73           O  
ATOM    691  CB  ASN    74      33.309 -13.625  -6.086  1.00 20.81           C  
ATOM    692  CG  ASN    74      33.834 -14.312  -7.327  1.00 25.44           C  
ATOM    693  OD1 ASN    74      33.216 -14.214  -8.401  1.00 27.61           O  
ATOM    694  ND2 ASN    74      34.993 -14.981  -7.207  1.00 30.25           N  
ATOM    695  N   ILE    75      30.669 -11.539  -5.100  1.00 18.59           N  
ATOM    696  CA  ILE    75      30.034 -10.671  -4.091  1.00 18.13           C  
ATOM    697  C   ILE    75      29.212 -11.482  -3.061  1.00 19.08           C  
ATOM    698  O   ILE    75      28.517 -12.471  -3.419  1.00 20.00           O  
ATOM    699  CB  ILE    75      29.156  -9.640  -4.810  1.00 18.07           C  
ATOM    700  CG1 ILE    75      30.044  -8.658  -5.589  1.00 20.24           C  
ATOM    701  CG2 ILE    75      28.174  -8.940  -3.848  1.00 20.77           C  
ATOM    702  CD1 ILE    75      29.365  -8.065  -6.753  1.00 22.60           C  
ATOM    703  N   GLU    76      29.308 -11.084  -1.800  0.60 18.87           N  
ATOM    705  CA  GLU    76      28.466 -11.612  -0.735  0.60 19.16           C  
ATOM    707  C   GLU    76      27.745 -10.407  -0.128  0.60 18.09           C  
ATOM    709  O   GLU    76      28.305  -9.282  -0.057  0.60 17.76           O  
ATOM    711  CB  GLU    76      29.339 -12.289   0.332  0.60 20.14           C  
ATOM    713  CG  GLU    76      28.599 -12.731   1.582  0.60 23.37           C  
ATOM    715  CD  GLU    76      27.702 -13.942   1.355  0.60 29.19           C  
ATOM    717  OE1 GLU    76      27.747 -14.565   0.258  0.60 32.28           O  
ATOM    719  OE2 GLU    76      26.959 -14.270   2.308  0.60 32.34           O  
ATOM    721  N   LEU    77      26.507 -10.648   0.309  1.00 17.46           N  
ATOM    722  CA  LEU    77      25.737  -9.644   1.062  1.00 16.79           C  
ATOM    723  C   LEU    77      25.380 -10.220   2.405  1.00 17.12           C  
ATOM    724  O   LEU    77      24.908 -11.374   2.464  1.00 18.05           O  
ATOM    725  CB  LEU    77      24.444  -9.268   0.347  1.00 17.08           C  
ATOM    726  CG  LEU    77      24.616  -8.756  -1.076  1.00 19.68           C  
ATOM    727  CD1 LEU    77      23.246  -8.352  -1.603  1.00 21.69           C  
ATOM    728  CD2 LEU    77      25.579  -7.545  -1.129  1.00 20.67           C  
ATOM    729  N   THR    78      25.559  -9.426   3.459  1.00 16.43           N  
ATOM    730  CA  THR    78      25.221  -9.860   4.834  1.00 15.99           C  
ATOM    731  C   THR    78      24.328  -8.790   5.447  1.00 15.43           C  
ATOM    732  O   THR    78      24.749  -7.629   5.601  1.00 17.08           O  
ATOM    733  CB  THR    78      26.486  -9.986   5.646  1.00 18.10           C  
ATOM    734  OG1 THR    78      27.333 -10.990   5.038  1.00 18.81           O  
ATOM    735  CG2 THR    78      26.154 -10.425   7.078  1.00 19.52           C  
ATOM    736  N   LEU    79      23.096  -9.173   5.798  1.00 16.06           N  
ATOM    737  CA  LEU    79      22.203  -8.219   6.475  1.00 16.46           C  
ATOM    738  C   LEU    79      22.688  -8.061   7.930  1.00 16.23           C  
ATOM    739  O   LEU    79      22.753  -9.061   8.674  1.00 18.78           O  
ATOM    740  CB  LEU    79      20.763  -8.778   6.464  1.00 16.37           C  
ATOM    741  CG  LEU    79      19.661  -7.907   7.062  1.00 17.37           C  
ATOM    742  CD1 LEU    79      19.486  -6.552   6.335  1.00 17.46           C  
ATOM    743  CD2 LEU    79      18.339  -8.679   7.091  1.00 17.44           C  
ATOM    744  N   MET    80      23.043  -6.836   8.320  1.00 17.05           N  
ATOM    745  CA  MET    80      23.489  -6.622   9.699  1.00 17.35           C  
ATOM    746  C   MET    80      22.360  -6.683  10.705  1.00 17.54           C  
ATOM    747  O   MET    80      21.228  -6.227  10.449  1.00 17.87           O  
ATOM    748  CB  MET    80      24.216  -5.268   9.819  1.00 17.15           C  
ATOM    749  CG  MET    80      25.447  -5.249   9.025  1.00 18.39           C  
ATOM    750  SD  MET    80      26.260  -3.413   9.223  0.65 23.14          SE  
ATOM    751  CE  MET    80      27.062  -3.666  10.979  1.00 20.64           C  
ATOM    752  N   GLU    81      22.687  -7.257  11.866  0.60 18.87           N  
ATOM    754  CA  GLU    81      21.777  -7.318  12.996  0.60 20.00           C  
ATOM    756  C   GLU    81      22.268  -6.434  14.122  0.60 18.60           C  
ATOM    758  O   GLU    81      23.461  -6.432  14.462  0.60 18.57           O  
ATOM    760  CB  GLU    81      21.696  -8.754  13.501  0.60 19.45           C  
ATOM    762  CG  GLU    81      21.101  -9.688  12.452  0.60 22.13           C  
ATOM    764  CD  GLU    81      21.019 -11.157  12.881  0.60 24.43           C  
ATOM    766  OE1 GLU    81      20.800 -11.435  14.084  0.60 29.15           O  
ATOM    768  OE2 GLU    81      21.169 -12.041  12.000  0.60 30.97           O  
ATOM    770  N   LYS    82      21.350  -5.682  14.714  0.60 18.42           N  
ATOM    772  CA  LYS    82      21.673  -4.932  15.912  0.60 18.51           C  
ATOM    774  C   LYS    82      21.959  -5.956  17.026  0.60 18.11           C  
ATOM    776  O   LYS    82      21.220  -6.944  17.204  0.60 18.72           O  
ATOM    778  CB  LYS    82      20.511  -4.024  16.313  0.60 18.81           C  
ATOM    780  CG  LYS    82      20.367  -2.809  15.416  0.60 18.90           C  
ATOM    782  CD  LYS    82      19.161  -1.970  15.834  0.60 20.64           C  
ATOM    784  CE  LYS    82      18.782  -1.014  14.727  0.60 21.42           C  
ATOM    786  NZ  LYS    82      18.024  -1.683  13.641  0.60 23.36           N  
ATOM    788  N   GLY    83      23.046  -5.688  17.747  1.00 17.31           N  
ATOM    789  CA  GLY    83      23.527  -6.516  18.854  1.00 17.58           C  
ATOM    790  C   GLY    83      24.740  -7.351  18.496  1.00 17.40           C  
ATOM    791  O   GLY    83      25.387  -7.936  19.376  1.00 18.34           O  
ATOM    792  N   LYS    84      25.042  -7.417  17.207  1.00 16.76           N  
ATOM    793  CA  LYS    84      26.235  -8.150  16.738  1.00 16.39           C  
ATOM    794  C   LYS    84      27.368  -7.205  16.328  1.00 16.76           C  
ATOM    795  O   LYS    84      27.148  -5.985  16.124  1.00 18.19           O  
ATOM    796  CB  LYS    84      25.878  -9.082  15.566  1.00 17.48           C  
ATOM    797  CG  LYS    84      24.850 -10.156  15.982  1.00 18.67           C  
ATOM    798  CD  LYS    84      24.706 -11.195  14.880  1.00 22.19           C  
ATOM    799  CE  LYS    84      23.681 -12.239  15.269  1.00 28.66           C  
ATOM    800  NZ  LYS    84      23.635 -13.207  14.106  1.00 32.70           N  
ATOM    801  N   VAL    85      28.578  -7.780  16.255  1.00 16.21           N  
ATOM    802  CA  VAL    85      29.724  -7.040  15.762  1.00 15.81           C  
ATOM    803  C   VAL    85      30.213  -7.783  14.514  1.00 16.70           C  
ATOM    804  O   VAL    85      30.260  -9.029  14.520  1.00 17.45           O  
ATOM    805  CB  VAL    85      30.846  -6.992  16.798  1.00 16.74           C  
ATOM    806  CG1 VAL    85      32.078  -6.270  16.245  1.00 17.88           C  
ATOM    807  CG2 VAL    85      30.371  -6.241  18.061  1.00 17.90           C  
ATOM    808  N   TYR    86      30.536  -7.031  13.450  1.00 15.64           N  
ATOM    809  CA  TYR    86      31.005  -7.610  12.178  1.00 17.07           C  
ATOM    810  C   TYR    86      32.428  -7.196  11.980  1.00 17.74           C  
ATOM    811  O   TYR    86      32.784  -6.042  12.192  1.00 18.97           O  
ATOM    812  CB  TYR    86      30.128  -7.093  11.010  1.00 16.66           C  
ATOM    813  CG  TYR    86      28.709  -7.580  11.209  1.00 15.88           C  
ATOM    814  CD1 TYR    86      28.249  -8.706  10.552  1.00 16.34           C  
ATOM    815  CD2 TYR    86      27.809  -6.907  12.072  1.00 16.28           C  
ATOM    816  CE1 TYR    86      26.958  -9.193  10.759  1.00 14.73           C  
ATOM    817  CE2 TYR    86      26.521  -7.416  12.280  1.00 15.61           C  
ATOM    818  CZ  TYR    86      26.114  -8.585  11.633  1.00 14.83           C  
ATOM    819  OH  TYR    86      24.834  -9.091  11.844  1.00 17.74           O  
ATOM    820  N   ASN    87      33.252  -8.143  11.539  1.00 16.15           N  
ATOM    821  CA  ASN    87      34.647  -7.813  11.249  1.00 16.28           C  
ATOM    822  C   ASN    87      34.967  -8.085   9.791  1.00 16.88           C  
ATOM    823  O   ASN    87      34.703  -9.187   9.297  1.00 16.54           O  
ATOM    824  CB  ASN    87      35.566  -8.680  12.140  1.00 16.99           C  
ATOM    825  CG  ASN    87      37.049  -8.507  11.803  1.00 18.96           C  
ATOM    826  OD1 ASN    87      37.591  -7.425  11.920  1.00 17.98           O  
ATOM    827  ND2 ASN    87      37.712  -9.592  11.402  1.00 18.13           N  
ATOM    828  N   VAL    88      35.546  -7.085   9.132  1.00 16.41           N  
ATOM    829  CA  VAL    88      36.085  -7.245   7.770  1.00 16.80           C  
ATOM    830  C   VAL    88      37.602  -7.279   7.914  1.00 17.60           C  
ATOM    831  O   VAL    88      38.200  -6.260   8.236  1.00 16.72           O  
ATOM    832  CB  VAL    88      35.655  -6.066   6.852  1.00 16.61           C  
ATOM    833  CG1 VAL    88      36.350  -6.207   5.486  1.00 17.54           C  
ATOM    834  CG2 VAL    88      34.145  -6.101   6.660  1.00 18.60           C  
ATOM    835  N   PRO    89      38.226  -8.441   7.691  1.00 17.46           N  
ATOM    836  CA  PRO    89      39.693  -8.472   7.841  1.00 18.21           C  
ATOM    837  C   PRO    89      40.371  -7.648   6.736  1.00 17.75           C  
ATOM    838  O   PRO    89      39.796  -7.459   5.639  1.00 17.90           O  
ATOM    839  CB  PRO    89      40.068  -9.953   7.641  1.00 19.26           C  
ATOM    840  CG  PRO    89      38.811 -10.684   7.578  1.00 22.10           C  
ATOM    841  CD  PRO    89      37.644  -9.760   7.350  1.00 19.36           C  
ATOM    842  N   ALA    90      41.602  -7.223   7.002  1.00 17.81           N  
ATOM    843  CA  ALA    90      42.410  -6.568   5.984  1.00 17.60           C  
ATOM    844  C   ALA    90      42.467  -7.417   4.715  1.00 17.75           C  
ATOM    845  O   ALA    90      42.462  -8.685   4.788  1.00 18.42           O  
ATOM    846  CB  ALA    90      43.820  -6.416   6.507  1.00 17.36           C  
ATOM    847  N   GLU    91      42.491  -6.715   3.575  1.00 17.80           N  
ATOM    848  CA  GLU    91      42.560  -7.340   2.249  1.00 19.04           C  
ATOM    849  C   GLU    91      41.258  -7.999   1.794  1.00 19.36           C  
ATOM    850  O   GLU    91      41.232  -8.778   0.813  1.00 21.60           O  
ATOM    851  CB  GLU    91      43.726  -8.338   2.133  1.00 19.33           C  
ATOM    852  CG  GLU    91      45.078  -7.770   2.532  1.00 21.26           C  
ATOM    853  CD  GLU    91      45.639  -6.748   1.523  1.00 23.31           C  
ATOM    854  OE1 GLU    91      44.913  -6.288   0.616  1.00 24.66           O  
ATOM    855  OE2 GLU    91      46.819  -6.375   1.678  1.00 27.27           O  
ATOM    856  N   CYS    92      40.167  -7.659   2.459  1.00 19.41           N  
ATOM    857  CA  CYS    92      38.849  -8.089   2.002  1.00 18.30           C  
ATOM    858  C   CYS    92      38.121  -6.846   1.474  1.00 17.59           C  
ATOM    859  O   CYS    92      37.976  -5.859   2.211  1.00 18.82           O  
ATOM    860  CB  CYS    92      38.069  -8.689   3.170  1.00 18.57           C  
ATOM    861  SG  CYS    92      36.398  -9.298   2.672  1.00 22.65           S  
ATOM    862  N   TRP    93      37.619  -6.904   0.239  1.00 16.71           N  
ATOM    863  CA  TRP    93      36.846  -5.767  -0.287  1.00 16.83           C  
ATOM    864  C   TRP    93      35.498  -5.678   0.429  1.00 17.61           C  
ATOM    865  O   TRP    93      34.892  -6.700   0.734  1.00 17.54           O  
ATOM    866  CB  TRP    93      36.578  -6.006  -1.784  1.00 17.22           C  
ATOM    867  CG  TRP    93      37.800  -5.880  -2.605  1.00 17.28           C  
ATOM    868  CD1 TRP    93      38.625  -6.899  -3.028  1.00 18.03           C  
ATOM    869  CD2 TRP    93      38.359  -4.657  -3.124  1.00 17.06           C  
ATOM    870  NE1 TRP    93      39.685  -6.363  -3.791  1.00 18.99           N  
ATOM    871  CE2 TRP    93      39.519  -5.001  -3.878  1.00 19.05           C  
ATOM    872  CE3 TRP    93      37.968  -3.311  -3.050  1.00 18.33           C  
ATOM    873  CZ2 TRP    93      40.312  -4.031  -4.522  1.00 18.83           C  
ATOM    874  CZ3 TRP    93      38.772  -2.329  -3.662  1.00 18.94           C  
ATOM    875  CH2 TRP    93      39.942  -2.697  -4.389  1.00 17.89           C  
ATOM    876  N   PHE    94      35.015  -4.463   0.670  1.00 16.25           N  
ATOM    877  CA  PHE    94      33.733  -4.347   1.367  1.00 16.00           C  
ATOM    878  C   PHE    94      33.103  -3.013   1.053  1.00 16.50           C  
ATOM    879  O   PHE    94      33.760  -2.078   0.536  1.00 16.78           O  
ATOM    880  CB  PHE    94      33.967  -4.407   2.892  1.00 16.42           C  
ATOM    881  CG  PHE    94      34.644  -3.171   3.432  1.00 15.99           C  
ATOM    882  CD1 PHE    94      33.879  -2.105   4.005  1.00 17.05           C  
ATOM    883  CD2 PHE    94      36.019  -3.046   3.357  1.00 18.78           C  
ATOM    884  CE1 PHE    94      34.525  -0.935   4.439  1.00 16.59           C  
ATOM    885  CE2 PHE    94      36.676  -1.882   3.776  1.00 17.42           C  
ATOM    886  CZ  PHE    94      35.928  -0.838   4.327  1.00 17.25           C  
ATOM    887  N   TYR    95      31.823  -2.894   1.409  1.00 16.04           N  
ATOM    888  CA  TYR    95      31.191  -1.568   1.498  1.00 17.12           C  
ATOM    889  C   TYR    95      29.856  -1.764   2.171  1.00 17.96           C  
ATOM    890  O   TYR    95      29.424  -2.879   2.367  1.00 20.58           O  
ATOM    891  CB  TYR    95      30.998  -0.895   0.113  1.00 18.45           C  
ATOM    892  CG  TYR    95      31.337   0.580   0.122  1.00 18.66           C  
ATOM    893  CD1 TYR    95      32.587   0.990   0.570  1.00 19.74           C  
ATOM    894  CD2 TYR    95      30.402   1.534  -0.287  1.00 19.52           C  
ATOM    895  CE1 TYR    95      32.943   2.365   0.605  1.00 19.65           C  
ATOM    896  CE2 TYR    95      30.732   2.907  -0.250  1.00 18.72           C  
ATOM    897  CZ  TYR    95      31.999   3.288   0.206  1.00 20.62           C  
ATOM    898  OH  TYR    95      32.344   4.665   0.229  1.00 22.21           O  
ATOM    899  N   SER    96      29.203  -0.670   2.536  0.60 17.85           N  
ATOM    901  CA  SER    96      27.903  -0.753   3.193  0.60 17.20           C  
ATOM    903  C   SER    96      26.789  -0.333   2.243  0.60 17.09           C  
ATOM    905  O   SER    96      26.997   0.501   1.358  0.60 17.78           O  
ATOM    907  CB  SER    96      27.841   0.244   4.360  0.60 17.61           C  
ATOM    909  OG  SER    96      28.810  -0.014   5.351  0.60 17.19           O  
ATOM    911  N   ILE    97      25.591  -0.868   2.483  1.00 16.44           N  
ATOM    912  CA  ILE    97      24.354  -0.321   1.901  1.00 16.59           C  
ATOM    913  C   ILE    97      23.466   0.075   3.073  1.00 16.37           C  
ATOM    914  O   ILE    97      23.232  -0.712   3.980  1.00 16.97           O  
ATOM    915  CB  ILE    97      23.598  -1.358   1.079  1.00 16.73           C  
ATOM    916  CG1 ILE    97      24.576  -2.160   0.227  1.00 18.48           C  
ATOM    917  CG2 ILE    97      22.560  -0.652   0.174  1.00 16.97           C  
ATOM    918  CD1 ILE    97      23.902  -3.326  -0.606  1.00 17.80           C  
ATOM    919  N   THR    98      23.017   1.331   3.080  1.00 15.49           N  
ATOM    920  CA  THR    98      22.286   1.859   4.223  1.00 16.39           C  
ATOM    921  C   THR    98      21.072   2.651   3.774  1.00 16.27           C  
ATOM    922  O   THR    98      20.908   2.874   2.568  1.00 17.78           O  
ATOM    923  CB  THR    98      23.211   2.765   5.097  1.00 16.82           C  
ATOM    924  OG1 THR    98      23.608   3.912   4.341  1.00 17.49           O  
ATOM    925  CG2 THR    98      24.464   2.014   5.498  1.00 16.73           C  
ATOM    926  N   GLN    99      20.236   3.037   4.733  1.00 16.84           N  
ATOM    927  CA  GLN    99      19.023   3.786   4.445  1.00 17.55           C  
ATOM    928  C   GLN    99      19.118   5.115   5.158  1.00 17.89           C  
ATOM    929  O   GLN    99      20.071   5.344   5.952  1.00 17.09           O  
ATOM    930  CB  GLN    99      17.817   2.960   4.903  1.00 17.09           C  
ATOM    931  CG  GLN    99      17.684   1.680   4.073  1.00 19.07           C  
ATOM    932  CD  GLN    99      16.368   0.929   4.356  1.00 17.48           C  
ATOM    933  OE1 GLN    99      15.827   0.962   5.462  1.00 19.87           O  
ATOM    934  NE2 GLN    99      15.842   0.280   3.318  1.00 20.07           N  
ATOM    935  N   LYS   100      18.167   6.016   4.869  1.00 18.24           N  
ATOM    936  CA  LYS   100      18.372   7.390   5.328  1.00 19.40           C  
ATOM    937  C   LYS   100      18.445   7.522   6.839  1.00 18.81           C  
ATOM    938  O   LYS   100      19.093   8.459   7.347  1.00 20.39           O  
ATOM    939  CB  LYS   100      17.344   8.344   4.722  1.00 20.14           C  
ATOM    940  CG  LYS   100      17.807   8.722   3.296  1.00 25.10           C  
ATOM    941  CD  LYS   100      17.413  10.126   2.880  1.00 35.39           C  
ATOM    942  CE  LYS   100      17.894  10.393   1.474  1.00 37.85           C  
ATOM    943  NZ  LYS   100      17.334   9.340   0.590  1.00 43.07           N  
ATOM    944  N   ASP   101      17.819   6.596   7.562  1.00 18.77           N  
ATOM    945  CA  ASP   101      17.849   6.637   9.032  1.00 18.97           C  
ATOM    946  C   ASP   101      18.862   5.684   9.673  1.00 19.71           C  
ATOM    947  O   ASP   101      18.846   5.468  10.885  1.00 20.13           O  
ATOM    948  CB  ASP   101      16.470   6.352   9.623  1.00 21.14           C  
ATOM    949  CG  ASP   101      15.902   5.004   9.206  1.00 24.80           C  
ATOM    950  OD1 ASP   101      16.414   4.346   8.270  1.00 24.17           O  
ATOM    951  OD2 ASP   101      14.860   4.613   9.808  1.00 30.33           O  
ATOM    952  N   THR   102      19.724   5.102   8.860  1.00 17.06           N  
ATOM    953  CA  THR   102      20.753   4.177   9.371  1.00 17.20           C  
ATOM    954  C   THR   102      21.889   4.902  10.090  1.00 17.58           C  
ATOM    955  O   THR   102      22.381   5.936   9.603  1.00 17.93           O  
ATOM    956  CB  THR   102      21.326   3.378   8.205  1.00 16.57           C  
ATOM    957  OG1 THR   102      20.262   2.654   7.559  1.00 17.53           O  
ATOM    958  CG2 THR   102      22.397   2.359   8.701  1.00 16.80           C  
ATOM    959  N   LYS   103      22.363   4.314  11.198  1.00 17.25           N  
ATOM    960  CA  LYS   103      23.555   4.803  11.872  1.00 16.04           C  
ATOM    961  C   LYS   103      24.375   3.590  12.301  1.00 17.48           C  
ATOM    962  O   LYS   103      23.787   2.647  12.869  1.00 17.08           O  
ATOM    963  CB  LYS   103      23.136   5.585  13.113  1.00 17.08           C  
ATOM    964  CG  LYS   103      24.323   6.281  13.816  1.00 18.18           C  
ATOM    965  CD  LYS   103      23.881   7.037  15.083  1.00 17.54           C  
ATOM    966  CE  LYS   103      22.969   8.210  14.792  1.00 17.74           C  
ATOM    967  NZ  LYS   103      23.675   9.408  14.151  1.00 17.79           N  
ATOM    968  N   MET   104      25.674   3.601  12.015  1.00 16.61           N  
ATOM    969  CA  MET   104      26.548   2.545  12.515  1.00 18.76           C  
ATOM    970  C   MET   104      27.829   3.126  13.028  1.00 18.07           C  
ATOM    971  O   MET   104      28.140   4.287  12.750  1.00 18.20           O  
ATOM    972  CB  MET   104      26.832   1.498  11.444  1.00 21.04           C  
ATOM    973  CG  MET   104      27.693   1.995  10.381  1.00 20.27           C  
ATOM    974  SD  MET   104      28.064   0.469   9.085  0.65 25.94          SE  
ATOM    975  CE  MET   104      26.490   0.644   8.340  1.00 12.83           C  
ATOM    976  N   MET   105      28.546   2.355  13.841  1.00 16.39           N  
ATOM    977  CA  MET   105      29.865   2.791  14.274  1.00 16.00           C  
ATOM    978  C   MET   105      30.870   1.843  13.689  1.00 16.24           C  
ATOM    979  O   MET   105      30.551   0.676  13.404  1.00 16.92           O  
ATOM    980  CB  MET   105      29.987   2.739  15.796  1.00 17.84           C  
ATOM    981  CG  MET   105      29.272   3.873  16.539  1.00 18.81           C  
ATOM    982  SD  MET   105      27.305   3.624  16.437  0.65 22.03          SE  
ATOM    983  CE  MET   105      26.852   4.856  17.895  1.00 19.82           C  
ATOM    984  N   TYR   106      32.079   2.338  13.459  1.00 15.94           N  
ATOM    985  CA  TYR   106      33.147   1.409  13.065  1.00 15.84           C  
ATOM    986  C   TYR   106      34.440   1.718  13.784  1.00 16.88           C  
ATOM    987  O   TYR   106      34.627   2.835  14.304  1.00 15.69           O  
ATOM    988  CB  TYR   106      33.333   1.386  11.548  1.00 17.37           C  
ATOM    989  CG  TYR   106      33.900   2.623  10.865  1.00 17.47           C  
ATOM    990  CD1 TYR   106      35.261   2.903  10.902  1.00 18.62           C  
ATOM    991  CD2 TYR   106      33.066   3.437  10.077  1.00 18.38           C  
ATOM    992  CE1 TYR   106      35.818   4.006  10.169  1.00 19.35           C  
ATOM    993  CE2 TYR   106      33.586   4.511   9.358  1.00 18.20           C  
ATOM    994  CZ  TYR   106      34.954   4.774   9.397  1.00 18.96           C  
ATOM    995  OH  TYR   106      35.485   5.823   8.665  1.00 20.37           O  
ATOM    996  N   VAL   107      35.269   0.673  13.871  1.00 16.69           N  
ATOM    997  CA  VAL   107      36.543   0.737  14.570  1.00 16.04           C  
ATOM    998  C   VAL   107      37.608   0.241  13.612  1.00 17.16           C  
ATOM    999  O   VAL   107      37.430  -0.776  12.944  1.00 16.81           O  
ATOM   1000  CB  VAL   107      36.533  -0.180  15.832  1.00 17.67           C  
ATOM   1001  CG1 VAL   107      37.847   0.002  16.625  1.00 17.38           C  
ATOM   1002  CG2 VAL   107      35.345   0.191  16.747  1.00 17.95           C  
ATOM   1003  N   GLN   108      38.702   0.982  13.518  1.00 17.82           N  
ATOM   1004  CA  GLN   108      39.866   0.519  12.703  1.00 18.01           C  
ATOM   1005  C   GLN   108      41.167   1.158  13.236  1.00 16.91           C  
ATOM   1006  O   GLN   108      41.138   1.936  14.171  1.00 17.32           O  
ATOM   1007  CB  GLN   108      39.712   0.894  11.213  1.00 18.57           C  
ATOM   1008  CG  GLN   108      39.699   2.410  11.035  1.00 19.50           C  
ATOM   1009  CD  GLN   108      39.527   2.873   9.607  1.00 24.12           C  
ATOM   1010  OE1 GLN   108      38.629   2.410   8.870  1.00 30.18           O  
ATOM   1011  NE2 GLN   108      40.376   3.781   9.213  1.00 32.65           N  
ATOM   1012  N   ASP   109      42.305   0.823  12.617  1.00 17.22           N  
ATOM   1013  CA  ASP   109      43.601   1.346  13.028  1.00 18.82           C  
ATOM   1014  C   ASP   109      43.622   2.853  12.801  1.00 20.82           C  
ATOM   1015  O   ASP   109      43.022   3.345  11.842  1.00 22.83           O  
ATOM   1016  CB  ASP   109      44.669   0.676  12.150  1.00 18.66           C  
ATOM   1017  CG  ASP   109      46.071   0.895  12.683  1.00 22.39           C  
ATOM   1018  OD1 ASP   109      46.557   2.062  12.669  1.00 24.76           O  
ATOM   1019  OD2 ASP   109      46.684  -0.113  13.066  1.00 24.55           O  
ATOM   1020  N   SER   110      44.262   3.596  13.694  1.00 21.00           N  
ATOM   1021  CA  SER   110      44.244   5.067  13.586  1.00 22.62           C  
ATOM   1022  C   SER   110      45.081   5.605  12.462  1.00 25.40           C  
ATOM   1023  O   SER   110      44.986   6.794  12.130  1.00 26.13           O  
ATOM   1024  CB  SER   110      44.637   5.744  14.889  1.00 22.48           C  
ATOM   1025  OG  SER   110      45.889   5.282  15.300  1.00 22.98           O  
ATOM   1026  N   ASN   111      45.892   4.759  11.841  0.50 26.61           N  
ATOM   1028  CA  ASN   111      46.619   5.173  10.626  0.50 29.51           C  
ATOM   1030  C   ASN   111      45.681   5.102   9.410  0.50 30.95           C  
ATOM   1032  O   ASN   111      45.748   4.156   8.625  0.50 32.22           O  
ATOM   1034  CB  ASN   111      47.838   4.276  10.385  0.50 29.55           C  
ATOM   1036  CG  ASN   111      48.726   4.132  11.602  0.50 31.43           C  
ATOM   1038  OD1 ASN   111      49.072   5.116  12.262  0.50 34.49           O  
ATOM   1040  ND2 ASN   111      49.124   2.894  11.894  0.50 34.01           N  
ATOM   1042  N   CYS   112      44.802   6.099   9.277  0.70 31.56           N  
ATOM   1043  CA  CYS   112      43.714   6.121   8.291  0.70 33.74           C  
ATOM   1044  C   CYS   112      44.025   6.946   7.039  0.70 35.48           C  
ATOM   1045  O   CYS   112      43.115   7.492   6.392  0.70 36.54           O  
ATOM   1046  CB  CYS   112      42.421   6.617   8.949  0.70 34.26           C  
ATOM   1047  SG  CYS   112      42.624   8.239   9.688  0.70 38.38           S  
ATOM   1048  N   SER   113      45.304   7.035   6.682  0.80 36.18           N  
ATOM   1049  CA  SER   113      45.657   7.515   5.355  0.80 37.26           C  
ATOM   1050  C   SER   113      45.138   6.506   4.323  0.80 37.37           C  
ATOM   1051  O   SER   113      45.038   5.311   4.592  0.80 38.31           O  
ATOM   1052  CB  SER   113      47.163   7.671   5.215  0.80 37.70           C  
ATOM   1053  OG  SER   113      47.763   6.406   5.045  0.80 40.92           O  
ATOM   1054  N   MET   114      44.784   7.001   3.147  1.00 36.61           N  
ATOM   1055  CA  MET   114      44.471   6.162   2.011  1.00 33.90           C  
ATOM   1056  C   MET   114      45.735   5.618   1.356  1.00 32.87           C  
ATOM   1057  O   MET   114      45.671   4.991   0.303  1.00 33.52           O  
ATOM   1058  CB  MET   114      43.673   6.968   0.992  1.00 34.29           C  
ATOM   1059  CG  MET   114      42.287   7.333   1.490  1.00 32.36           C  
ATOM   1060  SD  MET   114      41.175   5.772   1.643  0.55 31.57          SE  
ATOM   1061  CE  MET   114      41.516   4.865  -0.033  1.00 33.03           C  
ATOM   1062  N   ASP   115      46.893   5.872   1.969  1.00 30.98           N  
ATOM   1063  CA  ASP   115      48.127   5.247   1.531  1.00 29.39           C  
ATOM   1064  C   ASP   115      48.030   3.732   1.565  1.00 27.19           C  
ATOM   1065  O   ASP   115      48.696   3.061   0.786  1.00 28.38           O  
ATOM   1066  CB  ASP   115      49.284   5.647   2.457  1.00 31.04           C  
ATOM   1067  CG  ASP   115      49.683   7.106   2.301  1.00 36.35           C  
ATOM   1068  OD1 ASP   115      49.629   7.607   1.145  1.00 42.16           O  
ATOM   1069  OD2 ASP   115      50.065   7.734   3.328  1.00 40.44           O  
ATOM   1070  N   ASN   116      47.228   3.197   2.488  0.50 25.45           N  
ATOM   1072  CA  ASN   116      47.176   1.750   2.681  0.50 24.21           C  
ATOM   1074  C   ASN   116      45.799   1.164   2.389  0.50 22.98           C  
ATOM   1076  O   ASN   116      45.516   0.045   2.797  0.50 22.33           O  
ATOM   1078  CB  ASN   116      47.592   1.358   4.104  0.50 25.01           C  
ATOM   1080  CG  ASN   116      48.980   1.834   4.465  0.50 26.25           C  
ATOM   1082  OD1 ASN   116      49.848   1.970   3.602  0.50 30.22           O  
ATOM   1084  ND2 ASN   116      49.197   2.086   5.746  0.50 29.34           N  
ATOM   1086  N   SER   117      44.963   1.933   1.689  1.00 21.10           N  
ATOM   1087  CA  SER   117      43.626   1.481   1.305  1.00 20.32           C  
ATOM   1088  C   SER   117      43.373   1.845  -0.159  1.00 20.03           C  
ATOM   1089  O   SER   117      44.116   2.635  -0.762  1.00 21.17           O  
ATOM   1090  CB  SER   117      42.552   2.095   2.202  1.00 20.76           C  
ATOM   1091  OG  SER   117      42.802   1.844   3.590  1.00 22.22           O  
ATOM   1092  N   ASP   118      42.327   1.281  -0.746  1.00 18.98           N  
ATOM   1093  CA  ASP   118      41.985   1.582  -2.128  1.00 18.98           C  
ATOM   1094  C   ASP   118      40.481   1.476  -2.334  1.00 17.82           C  
ATOM   1095  O   ASP   118      39.797   0.823  -1.529  1.00 18.84           O  
ATOM   1096  CB  ASP   118      42.653   0.597  -3.081  1.00 18.47           C  
ATOM   1097  CG  ASP   118      44.134   0.915  -3.329  1.00 23.99           C  
ATOM   1098  OD1 ASP   118      44.418   1.937  -4.000  1.00 25.51           O  
ATOM   1099  OD2 ASP   118      44.999   0.142  -2.847  1.00 24.80           O  
ATOM   1100  N   PHE   119      39.976   2.113  -3.390  1.00 16.98           N  
ATOM   1101  CA  PHE   119      38.613   1.890  -3.870  1.00 17.39           C  
ATOM   1102  C   PHE   119      38.675   1.277  -5.266  1.00 17.52           C  
ATOM   1103  O   PHE   119      39.670   1.445  -5.981  1.00 17.46           O  
ATOM   1104  CB  PHE   119      37.807   3.196  -3.976  1.00 18.11           C  
ATOM   1105  CG  PHE   119      37.442   3.782  -2.642  1.00 17.20           C  
ATOM   1106  CD1 PHE   119      36.241   3.464  -2.011  1.00 17.33           C  
ATOM   1107  CD2 PHE   119      38.331   4.662  -2.005  1.00 19.04           C  
ATOM   1108  CE1 PHE   119      35.939   4.024  -0.751  1.00 20.51           C  
ATOM   1109  CE2 PHE   119      38.034   5.201  -0.745  1.00 20.22           C  
ATOM   1110  CZ  PHE   119      36.845   4.895  -0.135  1.00 20.12           C  
ATOM   1111  N   CYS   120      37.628   0.572  -5.670  1.00 17.45           N  
ATOM   1112  CA  CYS   120      37.555   0.047  -7.026  1.00 17.73           C  
ATOM   1113  C   CYS   120      36.106   0.087  -7.475  1.00 18.47           C  
ATOM   1114  O   CYS   120      35.201  -0.272  -6.689  1.00 17.83           O  
ATOM   1115  CB  CYS   120      38.089  -1.401  -7.045  1.00 18.30           C  
ATOM   1116  SG  CYS   120      38.102  -2.100  -8.702  0.85 21.04           S  
ATOM   1117  N   ASP   121      35.859   0.534  -8.706  1.00 18.02           N  
ATOM   1118  CA  ASP   121      34.503   0.578  -9.212  1.00 18.36           C  
ATOM   1119  C   ASP   121      33.919  -0.819  -9.406  1.00 19.09           C  
ATOM   1120  O   ASP   121      34.624  -1.758  -9.800  1.00 20.85           O  
ATOM   1121  CB  ASP   121      34.500   1.247 -10.587  1.00 18.48           C  
ATOM   1122  CG  ASP   121      34.724   2.753 -10.529  1.00 22.48           C  
ATOM   1123  OD1 ASP   121      34.777   3.377  -9.432  1.00 23.19           O  
ATOM   1124  OD2 ASP   121      34.794   3.308 -11.654  1.00 24.90           O  
ATOM   1125  N   LEU   122      32.619  -0.916  -9.181  1.00 18.88           N  
ATOM   1126  CA  LEU   122      31.864  -2.076  -9.555  1.00 19.10           C  
ATOM   1127  C   LEU   122      31.440  -1.902 -11.008  1.00 20.26           C  
ATOM   1128  O   LEU   122      31.216  -0.778 -11.467  1.00 21.26           O  
ATOM   1129  CB  LEU   122      30.615  -2.141  -8.682  1.00 19.71           C  
ATOM   1130  CG  LEU   122      30.854  -2.431  -7.195  1.00 18.36           C  
ATOM   1131  CD1 LEU   122      29.620  -2.013  -6.392  1.00 20.58           C  
ATOM   1132  CD2 LEU   122      31.061  -3.930  -7.010  1.00 21.72           C  
ATOM   1133  N   SER   123      31.288  -3.024 -11.710  1.00 20.30           N  
ATOM   1134  CA  SER   123      30.757  -2.964 -13.084  1.00 21.25           C  
ATOM   1135  C   SER   123      29.244  -2.686 -13.056  1.00 21.59           C  
ATOM   1136  O   SER   123      28.599  -2.828 -11.995  1.00 20.17           O  
ATOM   1137  CB  SER   123      30.982  -4.316 -13.769  1.00 21.57           C  
ATOM   1138  OG  SER   123      30.121  -5.293 -13.208  1.00 21.76           O  
ATOM   1139  N   LYS   124      28.651  -2.482 -14.240  0.50 21.41           N  
ATOM   1141  CA  LYS   124      27.189  -2.349 -14.367  0.50 22.09           C  
ATOM   1143  C   LYS   124      26.407  -3.585 -13.913  0.50 20.42           C  
ATOM   1145  O   LYS   124      25.404  -3.454 -13.193  0.50 19.79           O  
ATOM   1147  CB  LYS   124      26.775  -1.962 -15.804  0.50 22.57           C  
ATOM   1149  CG  LYS   124      25.663  -0.888 -15.824  0.50 25.93           C  
ATOM   1151  CD  LYS   124      25.184  -0.523 -17.241  0.50 25.36           C  
ATOM   1153  CE  LYS   124      26.129   0.427 -17.981  0.50 30.01           C  
ATOM   1155  NZ  LYS   124      25.505   0.962 -19.259  0.50 30.02           N  
ATOM   1157  N   GLU   125      26.825  -4.780 -14.331  0.60 19.59           N  
ATOM   1159  CA  GLU   125      26.131  -5.996 -13.881  0.60 19.69           C  
ATOM   1161  C   GLU   125      26.302  -6.092 -12.373  0.60 18.94           C  
ATOM   1163  O   GLU   125      25.366  -6.501 -11.678  0.60 18.66           O  
ATOM   1165  CB  GLU   125      26.661  -7.290 -14.526  0.60 19.99           C  
ATOM   1167  CG  GLU   125      26.151  -8.577 -13.844  0.60 20.98           C  
ATOM   1169  CD  GLU   125      26.607  -9.843 -14.539  0.60 21.63           C  
ATOM   1171  OE1 GLU   125      26.261 -10.005 -15.714  0.60 19.71           O  
ATOM   1173  OE2 GLU   125      27.260 -10.698 -13.888  0.60 27.62           O  
ATOM   1175  N   GLU   126      27.489  -5.753 -11.848  1.00 19.08           N  
ATOM   1176  CA  GLU   126      27.648  -5.938 -10.406  1.00 18.73           C  
ATOM   1177  C   GLU   126      26.741  -5.028  -9.609  1.00 18.15           C  
ATOM   1178  O   GLU   126      26.161  -5.438  -8.607  1.00 17.99           O  
ATOM   1179  CB  GLU   126      29.117  -5.727 -10.000  1.00 18.57           C  
ATOM   1180  CG  GLU   126      29.971  -6.889 -10.484  1.00 18.38           C  
ATOM   1181  CD  GLU   126      31.451  -6.622 -10.553  1.00 23.86           C  
ATOM   1182  OE1 GLU   126      31.903  -5.448 -10.410  1.00 22.43           O  
ATOM   1183  OE2 GLU   126      32.148  -7.648 -10.769  1.00 26.13           O  
ATOM   1184  N   ILE   127      26.640  -3.766 -10.046  1.00 17.91           N  
ATOM   1185  CA  ILE   127      25.729  -2.831  -9.371  1.00 17.65           C  
ATOM   1186  C   ILE   127      24.278  -3.349  -9.459  1.00 17.13           C  
ATOM   1187  O   ILE   127      23.605  -3.412  -8.428  1.00 17.30           O  
ATOM   1188  CB  ILE   127      25.860  -1.432  -9.962  1.00 18.60           C  
ATOM   1189  CG1 ILE   127      27.226  -0.907  -9.564  1.00 18.46           C  
ATOM   1190  CG2 ILE   127      24.801  -0.512  -9.437  1.00 19.31           C  
ATOM   1191  CD1 ILE   127      27.652   0.347 -10.378  1.00 20.44           C  
ATOM   1192  N   GLU   128      23.824  -3.758 -10.663  1.00 18.39           N  
ATOM   1193  CA  GLU   128      22.454  -4.230 -10.797  1.00 20.00           C  
ATOM   1194  C   GLU   128      22.223  -5.470  -9.953  1.00 18.15           C  
ATOM   1195  O   GLU   128      21.169  -5.629  -9.342  1.00 18.91           O  
ATOM   1196  CB  GLU   128      22.138  -4.598 -12.257  1.00 20.94           C  
ATOM   1197  CG  GLU   128      22.052  -3.429 -13.162  1.00 23.65           C  
ATOM   1198  CD  GLU   128      21.814  -3.828 -14.628  1.00 25.57           C  
ATOM   1199  OE1 GLU   128      21.660  -5.043 -14.953  1.00 30.78           O  
ATOM   1200  OE2 GLU   128      21.811  -2.893 -15.466  1.00 32.76           O  
ATOM   1201  N   TYR   129      23.200  -6.376  -9.937  1.00 17.26           N  
ATOM   1202  CA  TYR   129      23.116  -7.601  -9.141  1.00 17.84           C  
ATOM   1203  C   TYR   129      22.970  -7.266  -7.649  1.00 18.04           C  
ATOM   1204  O   TYR   129      22.105  -7.813  -6.920  1.00 18.35           O  
ATOM   1205  CB  TYR   129      24.391  -8.393  -9.363  1.00 18.21           C  
ATOM   1206  CG  TYR   129      24.534  -9.595  -8.483  1.00 18.38           C  
ATOM   1207  CD1 TYR   129      23.709 -10.725  -8.630  1.00 18.41           C  
ATOM   1208  CD2 TYR   129      25.523  -9.622  -7.498  1.00 20.53           C  
ATOM   1209  CE1 TYR   129      23.864 -11.827  -7.804  1.00 17.58           C  
ATOM   1210  CE2 TYR   129      25.680 -10.727  -6.675  1.00 19.51           C  
ATOM   1211  CZ  TYR   129      24.855 -11.837  -6.813  1.00 18.04           C  
ATOM   1212  OH  TYR   129      25.046 -12.968  -6.031  1.00 20.25           O  
ATOM   1213  N   ILE   130      23.838  -6.374  -7.162  1.00 16.52           N  
ATOM   1214  CA  ILE   130      23.709  -5.978  -5.770  1.00 17.09           C  
ATOM   1215  C   ILE   130      22.356  -5.330  -5.503  1.00 16.91           C  
ATOM   1216  O   ILE   130      21.727  -5.628  -4.479  1.00 18.49           O  
ATOM   1217  CB  ILE   130      24.863  -5.005  -5.382  1.00 17.07           C  
ATOM   1218  CG1 ILE   130      26.193  -5.809  -5.366  1.00 17.50           C  
ATOM   1219  CG2 ILE   130      24.540  -4.313  -4.062  1.00 18.07           C  
ATOM   1220  CD1 ILE   130      27.479  -4.888  -5.348  1.00 19.29           C  
ATOM   1221  N   GLN   131      21.902  -4.417  -6.379  1.00 16.81           N  
ATOM   1222  CA  GLN   131      20.627  -3.733  -6.147  1.00 16.26           C  
ATOM   1223  C   GLN   131      19.446  -4.743  -6.100  1.00 16.96           C  
ATOM   1224  O   GLN   131      18.583  -4.655  -5.232  1.00 17.72           O  
ATOM   1225  CB  GLN   131      20.379  -2.693  -7.226  1.00 17.36           C  
ATOM   1226  CG  GLN   131      21.329  -1.508  -7.062  1.00 17.32           C  
ATOM   1227  CD  GLN   131      21.262  -0.489  -8.196  1.00 18.14           C  
ATOM   1228  OE1 GLN   131      20.970  -0.828  -9.350  1.00 21.38           O  
ATOM   1229  NE2 GLN   131      21.621   0.769  -7.879  1.00 20.80           N  
ATOM   1230  N   THR   132      19.419  -5.674  -7.054  1.00 16.48           N  
ATOM   1231  CA  THR   132      18.346  -6.671  -7.094  1.00 16.57           C  
ATOM   1232  C   THR   132      18.269  -7.419  -5.769  1.00 17.80           C  
ATOM   1233  O   THR   132      17.198  -7.577  -5.188  1.00 18.56           O  
ATOM   1234  CB  THR   132      18.604  -7.637  -8.232  1.00 18.12           C  
ATOM   1235  OG1 THR   132      18.408  -6.933  -9.460  1.00 18.40           O  
ATOM   1236  CG2 THR   132      17.597  -8.815  -8.160  1.00 17.65           C  
ATOM   1237  N   ASN   133      19.409  -7.901  -5.303  1.00 17.31           N  
ATOM   1238  CA  ASN   133      19.415  -8.773  -4.108  1.00 17.08           C  
ATOM   1239  C   ASN   133      19.311  -7.976  -2.822  1.00 17.38           C  
ATOM   1240  O   ASN   133      18.656  -8.409  -1.867  1.00 18.85           O  
ATOM   1241  CB  ASN   133      20.651  -9.693  -4.135  1.00 17.47           C  
ATOM   1242  CG  ASN   133      20.577 -10.696  -5.293  1.00 20.14           C  
ATOM   1243  OD1 ASN   133      21.201 -10.534  -6.357  1.00 20.33           O  
ATOM   1244  ND2 ASN   133      19.772 -11.703  -5.112  1.00 16.52           N  
ATOM   1245  N   ALA   134      19.907  -6.785  -2.801  1.00 17.14           N  
ATOM   1246  CA  ALA   134      19.819  -5.949  -1.597  1.00 17.67           C  
ATOM   1247  C   ALA   134      18.425  -5.402  -1.350  1.00 17.75           C  
ATOM   1248  O   ALA   134      18.010  -5.294  -0.191  1.00 18.61           O  
ATOM   1249  CB  ALA   134      20.833  -4.785  -1.649  1.00 18.35           C  
ATOM   1250  N   ARG   135      17.690  -5.062  -2.413  0.50 17.68           N  
ATOM   1252  CA  ARG   135      16.292  -4.640  -2.250  0.50 18.19           C  
ATOM   1254  C   ARG   135      15.572  -5.671  -1.405  0.50 17.60           C  
ATOM   1256  O   ARG   135      14.915  -5.319  -0.421  0.50 17.24           O  
ATOM   1258  CB  ARG   135      15.558  -4.482  -3.598  0.50 18.84           C  
ATOM   1260  CG  ARG   135      15.634  -3.088  -4.185  0.50 20.89           C  
ATOM   1262  CD  ARG   135      14.767  -2.913  -5.452  0.50 19.82           C  
ATOM   1264  NE  ARG   135      15.253  -3.691  -6.597  0.50 21.02           N  
ATOM   1266  CZ  ARG   135      16.118  -3.257  -7.510  0.50 20.55           C  
ATOM   1268  NH1 ARG   135      16.660  -2.051  -7.414  0.50 19.77           N  
ATOM   1270  NH2 ARG   135      16.470  -4.039  -8.515  0.50 20.94           N  
ATOM   1272  N   LYS   136      15.739  -6.941  -1.769  1.00 17.30           N  
ATOM   1273  CA  LYS   136      15.013  -8.042  -1.104  1.00 16.20           C  
ATOM   1274  C   LYS   136      15.561  -8.221   0.317  1.00 16.60           C  
ATOM   1275  O   LYS   136      14.805  -8.320   1.280  1.00 16.64           O  
ATOM   1276  CB  LYS   136      15.162  -9.303  -1.914  1.00 17.03           C  
ATOM   1277  CG  LYS   136      14.430  -9.172  -3.243  1.00 20.14           C  
ATOM   1278  CD  LYS   136      14.770 -10.338  -4.113  1.00 23.30           C  
ATOM   1279  CE  LYS   136      14.162 -10.175  -5.516  1.00 25.56           C  
ATOM   1280  NZ  LYS   136      12.720 -10.573  -5.377  1.00 29.92           N  
ATOM   1281  N   LEU   137      16.893  -8.204   0.420  1.00 16.81           N  
ATOM   1282  CA  LEU   137      17.533  -8.532   1.692  1.00 16.98           C  
ATOM   1283  C   LEU   137      17.144  -7.528   2.759  1.00 17.23           C  
ATOM   1284  O   LEU   137      16.991  -7.903   3.926  1.00 17.59           O  
ATOM   1285  CB  LEU   137      19.054  -8.638   1.497  1.00 17.81           C  
ATOM   1286  CG  LEU   137      19.910  -9.022   2.716  1.00 18.22           C  
ATOM   1287  CD1 LEU   137      19.354 -10.327   3.309  1.00 18.14           C  
ATOM   1288  CD2 LEU   137      21.383  -9.126   2.302  1.00 17.26           C  
ATOM   1289  N   PHE   138      16.984  -6.245   2.373  1.00 17.07           N  
ATOM   1290  CA  PHE   138      16.586  -5.233   3.356  1.00 18.73           C  
ATOM   1291  C   PHE   138      15.282  -5.558   4.070  1.00 19.99           C  
ATOM   1292  O   PHE   138      15.090  -5.139   5.217  1.00 21.34           O  
ATOM   1293  CB  PHE   138      16.442  -3.844   2.687  1.00 18.10           C  
ATOM   1294  CG  PHE   138      17.686  -3.006   2.719  1.00 17.50           C  
ATOM   1295  CD1 PHE   138      18.139  -2.388   1.555  1.00 16.88           C  
ATOM   1296  CD2 PHE   138      18.396  -2.812   3.903  1.00 17.33           C  
ATOM   1297  CE1 PHE   138      19.283  -1.541   1.583  1.00 18.86           C  
ATOM   1298  CE2 PHE   138      19.527  -1.973   3.909  1.00 19.25           C  
ATOM   1299  CZ  PHE   138      19.952  -1.367   2.760  1.00 17.67           C  
ATOM   1300  N   GLU   139      14.439  -6.386   3.444  1.00 18.92           N  
ATOM   1301  CA  GLU   139      13.138  -6.676   3.996  1.00 19.71           C  
ATOM   1302  C   GLU   139      13.066  -8.043   4.661  1.00 17.95           C  
ATOM   1303  O   GLU   139      12.014  -8.404   5.137  1.00 18.66           O  
ATOM   1304  CB  GLU   139      12.101  -6.581   2.895  1.00 19.85           C  
ATOM   1305  CG  GLU   139      12.117  -5.275   2.063  1.00 23.35           C  
ATOM   1306  CD  GLU   139      12.058  -4.002   2.912  1.00 30.03           C  
ATOM   1307  OE1 GLU   139      11.489  -3.989   4.046  1.00 30.29           O  
ATOM   1308  OE2 GLU   139      12.582  -2.966   2.407  1.00 33.04           O  
ATOM   1309  N   LYS   140      14.176  -8.786   4.703  1.00 17.80           N  
ATOM   1310  CA  LYS   140      14.103 -10.176   5.243  1.00 19.28           C  
ATOM   1311  C   LYS   140      14.286 -10.219   6.749  1.00 21.74           C  
ATOM   1312  O   LYS   140      14.695  -9.206   7.393  1.00 21.57           O  
ATOM   1313  CB  LYS   140      15.170 -11.064   4.589  1.00 18.37           C  
ATOM   1314  CG  LYS   140      14.909 -11.354   3.112  1.00 18.79           C  
ATOM   1315  CD  LYS   140      16.003 -12.193   2.490  1.00 19.32           C  
ATOM   1316  CE  LYS   140      15.652 -12.412   0.999  1.00 21.12           C  
ATOM   1317  NZ  LYS   140      16.766 -13.100   0.285  1.00 22.33           N  
ATOM   1318  OXT LYS   140      14.000 -11.276   7.370  1.00 23.13           O  
END
