
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  174 ( 1409),  selected  174 , name 1yfx_A
# Molecule2: number of CA atoms  138 ( 1133),  selected  138 , name T0414.pdb
# PARAMETERS: 1yfx_A.T0414.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      A       3           -
LGA    L     2_A      M       4           -
LGA    T     3_A      -       -           -
LGA    Y     4_A      -       -           -
LGA    G     5_A      -       -           -
LGA    A     6_A      K       5           #
LGA    P     7_A      P       6          2.697
LGA    F     8_A      D       7          3.325
LGA    N     9_A      I       8          4.658
LGA    F    10_A      -       -           -
LGA    P    11_A      -       -           -
LGA    R    12_A      -       -           -
LGA    W    13_A      Y       9          3.359
LGA    I    14_A      E      10          2.860
LGA    D    15_A      -       -           -
LGA    E    16_A      -       -           -
LGA    H    17_A      N      11          3.041
LGA    A    18_A      N      12          2.101
LGA    H    19_A      -       -           -
LGA    L    20_A      R      13          1.814
LGA    L    21_A      -       -           -
LGA    K    22_A      E      14          0.706
LGA    P    23_A      -       -           -
LGA    P    24_A      -       -           -
LGA    V    25_A      -       -           -
LGA    G    26_A      G      15          0.702
LGA    N    27_A      I      16          0.173
LGA    R    28_A      L      17          0.485
LGA    Q    29_A      C      18          0.605
LGA    V    30_A      V      19          0.563
LGA    W    31_A      Y      20          2.472
LGA    Q    32_A      K      21          4.739
LGA    D    33_A      N      22           #
LGA    S    34_A      E      23          4.085
LGA    D    35_A      K      24          2.902
LGA    F    36_A      W      25          1.052
LGA    I    37_A      L      26          1.934
LGA    V    38_A      V      27          1.033
LGA    T    39_A      C      28          0.170
LGA    V    40_A      I      29          0.455
LGA    V    41_A      K      30          0.453
LGA    G    42_A      N      31          1.100
LGA    G    43_A      W      32          1.428
LGA    P    44_A      K      33          4.457
LGA    N    45_A      P      34          3.886
LGA    H    46_A      D      35          1.757
LGA    R    47_A      N      36          3.913
LGA    -       -      D      37           -
LGA    -       -      I      38           -
LGA    -       -      E      39           -
LGA    -       -      G      40           -
LGA    -       -      I      41           -
LGA    T    48_A      A      42          1.951
LGA    D    49_A      H      43          1.616
LGA    Y    50_A      L      44          0.609
LGA    H    51_A      E      45          0.448
LGA    D    52_A      I      46          0.946
LGA    D    53_A      H      47          0.592
LGA    P    54_A      H      48          1.351
LGA    L    55_A      S      49          3.159
LGA    -       -      T      50           -
LGA    E    56_A      D      51          0.381
LGA    E    57_A      E      52          0.335
LGA    F    58_A      Q      53          0.975
LGA    F    59_A      F      54          0.897
LGA    Y    60_A      I      55          1.020
LGA    Q    61_A      L      56          0.931
LGA    L    62_A      S      57          1.693
LGA    R    63_A      A      58          1.774
LGA    G    64_A      G      59          1.862
LGA    N    65_A      K      60          1.536
LGA    A    66_A      A      61          0.769
LGA    Y    67_A      I      62          1.065
LGA    L    68_A      L      63          1.704
LGA    N    69_A      I      64          1.920
LGA    L    70_A      T      65          2.141
LGA    W    71_A      A      66          1.256
LGA    V    72_A      E      67          4.124
LGA    D    73_A      K      68          6.279
LGA    G    74_A      E      69          4.363
LGA    -       -      N      70           -
LGA    -       -      D      71           -
LGA    -       -      K      72           -
LGA    -       -      F      73           -
LGA    R    75_A      N      74          1.503
LGA    R    76_A      I      75          1.304
LGA    E    77_A      E      76          1.211
LGA    R    78_A      L      77          0.607
LGA    A    79_A      T      78          1.762
LGA    D    80_A      L      79          1.810
LGA    L    81_A      M      80          1.587
LGA    K    82_A      E      81          2.409
LGA    E    83_A      K      82          2.427
LGA    G    84_A      G      83          2.475
LGA    D    85_A      K      84          2.467
LGA    I    86_A      V      85          0.931
LGA    F    87_A      Y      86          0.671
LGA    L    88_A      N      87          1.062
LGA    L    89_A      V      88          0.837
LGA    P    90_A      P      89          0.926
LGA    P    91_A      A      90          0.544
LGA    H    92_A      E      91          1.262
LGA    V    93_A      C      92          0.734
LGA    R    94_A      W      93          0.619
LGA    H    95_A      F      94          0.886
LGA    S    96_A      Y      95          1.860
LGA    P    97_A      S      96          1.378
LGA    Q    98_A      I      97          1.327
LGA    R    99_A      T      98          1.507
LGA    P   100_A      Q      99          1.579
LGA    E   101_A      K     100          3.053
LGA    A   102_A      D     101          1.767
LGA    G   103_A      -       -           -
LGA    S   104_A      T     102          2.131
LGA    A   105_A      K     103          1.547
LGA    C   106_A      M     104          0.885
LGA    L   107_A      M     105          1.089
LGA    V   108_A      Y     106          0.442
LGA    I   109_A      V     107          0.744
LGA    E   110_A      Q     108          0.864
LGA    R   111_A      D     109          0.671
LGA    Q   112_A      S     110          2.868
LGA    R   113_A      N     111          3.276
LGA    P   114_A      C     112           -
LGA    A   115_A      S     113           -
LGA    G   116_A      M     114           -
LGA    M   117_A      D     115          5.470
LGA    L   118_A      N     116          1.837
LGA    D   119_A      S     117          0.910
LGA    G   120_A      D     118          0.825
LGA    F   121_A      F     119          0.727
LGA    E   122_A      C     120          0.558
LGA    W   123_A      D     121          0.650
LGA    Y   124_A      L     122          2.462
LGA    C   125_A      S     123          1.328
LGA    D   126_A      K     124          2.051
LGA    A   127_A      E     125          3.810
LGA    C   128_A      -       -           -
LGA    G   129_A      E     126           #
LGA    H   130_A      -       -           -
LGA    L   131_A      -       -           -
LGA    V   132_A      -       -           -
LGA    H   133_A      -       -           -
LGA    R   134_A      -       -           -
LGA    V   135_A      -       -           -
LGA    E   136_A      -       -           -
LGA    V   137_A      -       -           -
LGA    Q   138_A      -       -           -
LGA    L   139_A      -       -           -
LGA    K   140_A      -       -           -
LGA    S   141_A      -       -           -
LGA    I   142_A      -       -           -
LGA    V   143_A      -       -           -
LGA    T   144_A      -       -           -
LGA    D   145_A      -       -           -
LGA    L   146_A      -       -           -
LGA    P   147_A      -       -           -
LGA    P   148_A      -       -           -
LGA    L   149_A      -       -           -
LGA    F   150_A      -       -           -
LGA    E   151_A      -       -           -
LGA    S   152_A      -       -           -
LGA    F   153_A      -       -           -
LGA    Y   154_A      -       -           -
LGA    A   155_A      -       -           -
LGA    S   156_A      -       -           -
LGA    E   157_A      -       -           -
LGA    D   158_A      -       -           -
LGA    K   159_A      -       -           -
LGA    R   160_A      -       -           -
LGA    R   161_A      -       -           -
LGA    C   162_A      -       -           -
LGA    P   163_A      -       -           -
LGA    H   164_A      -       -           -
LGA    C   165_A      -       -           -
LGA    G   166_A      -       -           -
LGA    Q   167_A      -       -           -
LGA    V   168_A      -       -           -
LGA    H   169_A      -       -           -
LGA    P   170_A      -       -           -
LGA    G   171_A      -       -           -
LGA    R   172_A      -       -           -
LGA    A   173_A      -       -           -
LGA    A   174_A      I     127           #
LGA    -       -      E     128           -
LGA    -       -      Y     129           -
LGA    -       -      I     130           -
LGA    -       -      Q     131           -
LGA    -       -      T     132           -
LGA    -       -      N     133           -
LGA    -       -      A     134           -
LGA    -       -      R     135           -
LGA    -       -      K     136           -
LGA    -       -      L     137           -
LGA    -       -      F     138           -
LGA    -       -      E     139           -
LGA    -       -      K     140           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  174  138    5.0    106    2.14    12.26     64.208     4.740

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.913705 * X  +  -0.317602 * Y  +   0.253520 * Z  +  31.456165
  Y_new =   0.404618 * X  +   0.769016 * Y  +  -0.494873 * Z  + -16.691366
  Z_new =  -0.037788 * X  +   0.554747 * Y  +   0.831161 * Z  + -12.377572 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.588535   -2.553058  [ DEG:    33.7206   -146.2794 ]
  Theta =   0.037797    3.103795  [ DEG:     2.1656    177.8344 ]
  Phi   =   0.416878   -2.724715  [ DEG:    23.8853   -156.1147 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1yfx_A                                        
REMARK     2: T0414.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1yfx_A.T0414.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  174  138   5.0  106   2.14   12.26  64.208
REMARK  ---------------------------------------------------------- 
MOLECULE 1yfx_A
HEADER    OXIDOREDUCTASE                          04-JAN-05   1YFX              
TITLE     CRYSTAL STRUCTURE OF 3-HYDROXYANTHRANILATE-3,4-DIOXYGENASE            
TITLE    2 FROM RALSTONIA METALLIDURANS COMPLEXED WITH 4-CHLORO-3-              
TITLE    3 HYDROXYANTHRANILIC ACID AND NO                                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: 3-HYDROXYANTHRANILATE-3,4-DIOXYGENASE;                     
COMPND   3 CHAIN: A;                                                            
COMPND   4 EC: 1.13.11.6;                                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RALSTONIA METALLIDURANS;                        
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    CUPIN                                                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.ZHANG,K.L.COLABROY,T.P.BEGLEY,S.E.EALICK                            
REVDAT   1   31-MAY-05 1YFX    0                                                
JRNL        AUTH   Y.ZHANG,K.L.COLABROY,T.P.BEGLEY,S.E.EALICK                   
JRNL        TITL   STRUCTURAL STUDIES ON                                        
JRNL        TITL 2 3-HYDROXYANTHRANILATE-3,4-DIOXYGENASE: THE                   
JRNL        TITL 3 CATALYTIC MECHANISM OF A COMPLEX OXIDATION                   
JRNL        TITL 4 INVOLVED IN NAD BIOSYNTHESIS.                                
JRNL        REF    BIOCHEMISTRY                  V.  44  7632 2005              
JRNL        REFN   ASTM BICHAW  US ISSN 0006-2960                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  1YFX A    1   174  GB     48769986 ZP_00274330      1    174             
SEQRES   1 A  174  MET LEU THR TYR GLY ALA PRO PHE ASN PHE PRO ARG TRP          
SEQRES   2 A  174  ILE ASP GLU HIS ALA HIS LEU LEU LYS PRO PRO VAL GLY          
SEQRES   3 A  174  ASN ARG GLN VAL TRP GLN ASP SER ASP PHE ILE VAL THR          
SEQRES   4 A  174  VAL VAL GLY GLY PRO ASN HIS ARG THR ASP TYR HIS ASP          
SEQRES   5 A  174  ASP PRO LEU GLU GLU PHE PHE TYR GLN LEU ARG GLY ASN          
SEQRES   6 A  174  ALA TYR LEU ASN LEU TRP VAL ASP GLY ARG ARG GLU ARG          
SEQRES   7 A  174  ALA ASP LEU LYS GLU GLY ASP ILE PHE LEU LEU PRO PRO          
SEQRES   8 A  174  HIS VAL ARG HIS SER PRO GLN ARG PRO GLU ALA GLY SER          
SEQRES   9 A  174  ALA CYS LEU VAL ILE GLU ARG GLN ARG PRO ALA GLY MET          
SEQRES  10 A  174  LEU ASP GLY PHE GLU TRP TYR CYS ASP ALA CYS GLY HIS          
SEQRES  11 A  174  LEU VAL HIS ARG VAL GLU VAL GLN LEU LYS SER ILE VAL          
SEQRES  12 A  174  THR ASP LEU PRO PRO LEU PHE GLU SER PHE TYR ALA SER          
SEQRES  13 A  174  GLU ASP LYS ARG ARG CYS PRO HIS CYS GLY GLN VAL HIS          
SEQRES  14 A  174  PRO GLY ARG ALA ALA                                          
HET     FE    300       1                                                       
HET     FE    301       1                                                       
HET     NO    310       2                                                       
HET    TRS    400       8                                                       
HET    4AA    401      12                                                       
HETNAM      FE FE (III) ION                                                     
HETNAM      NO NITROGEN OXIDE                                                   
HETNAM     TRS 2-AMINO-2-HYDROXYMETHYL-PROPANE-1,3-DIOL                         
HETNAM     4AA 4-CHLORO-3-HYDROXYANTHRANILIC ACID                               
HETSYN     TRS TRIS BUFFER                                                      
HETSYN     4AA 2-AMINO-4-CHLORO-3-HYDROXYBENZOIC ACID                           
FORMUL   2   FE    2(FE 3+)                                                     
FORMUL   4   NO    N O                                                          
FORMUL   5  TRS    C4 H12 N O3 1+                                               
FORMUL   6  4AA    C7 H6 CL N O3                                                
FORMUL   7  HOH   *82(H2 O)                                                     
CRYST1   57.900   57.900  230.600  90.00  90.00 120.00 P 65 2 2     12          
ATOM      1  N   MET A   1      48.604  12.143  30.759  1.00 71.48           N  
ATOM      2  CA  MET A   1      47.230  12.721  30.847  1.00 71.49           C  
ATOM      3  C   MET A   1      46.269  12.050  29.865  1.00 69.09           C  
ATOM      4  O   MET A   1      46.692  11.328  28.958  1.00 67.54           O  
ATOM      5  CB  MET A   1      47.264  14.229  30.566  1.00 74.14           C  
ATOM      6  CG  MET A   1      47.878  14.609  29.224  1.00 78.74           C  
ATOM      7  SD  MET A   1      47.052  16.018  28.432  1.00 85.73           S  
ATOM      8  CE  MET A   1      47.267  17.300  29.699  1.00 83.54           C  
ATOM      9  N   LEU A   2      44.976  12.296  30.058  1.00 66.36           N  
ATOM     10  CA  LEU A   2      43.951  11.737  29.187  1.00 63.07           C  
ATOM     11  C   LEU A   2      43.843  12.598  27.929  1.00 60.92           C  
ATOM     12  O   LEU A   2      42.924  13.406  27.783  1.00 59.52           O  
ATOM     13  CB  LEU A   2      42.603  11.683  29.916  1.00 62.45           C  
ATOM     14  CG  LEU A   2      42.543  10.834  31.192  1.00 62.67           C  
ATOM     15  CD1 LEU A   2      41.146  10.911  31.812  1.00 62.54           C  
ATOM     16  CD2 LEU A   2      42.897   9.397  30.862  1.00 61.78           C  
ATOM     17  N   THR A   3      44.804  12.413  27.030  1.00 57.81           N  
ATOM     18  CA  THR A   3      44.881  13.142  25.769  1.00 56.29           C  
ATOM     19  C   THR A   3      43.551  13.203  25.011  1.00 54.43           C  
ATOM     20  O   THR A   3      43.273  14.181  24.309  1.00 52.48           O  
ATOM     21  CB  THR A   3      45.935  12.491  24.841  1.00 57.40           C  
ATOM     22  OG1 THR A   3      47.161  12.315  25.560  1.00 60.13           O  
ATOM     23  CG2 THR A   3      46.196  13.361  23.624  1.00 58.37           C  
ATOM     24  N   TYR A   4      42.729  12.165  25.157  1.00 52.47           N  
ATOM     25  CA  TYR A   4      41.450  12.101  24.453  1.00 50.05           C  
ATOM     26  C   TYR A   4      40.234  12.453  25.299  1.00 49.62           C  
ATOM     27  O   TYR A   4      39.098  12.193  24.899  1.00 48.28           O  
ATOM     28  CB  TYR A   4      41.260  10.708  23.850  1.00 47.11           C  
ATOM     29  CG  TYR A   4      42.442  10.252  23.024  1.00 44.81           C  
ATOM     30  CD1 TYR A   4      42.836  10.950  21.888  1.00 43.17           C  
ATOM     31  CD2 TYR A   4      43.170   9.122  23.386  1.00 43.88           C  
ATOM     32  CE1 TYR A   4      43.920  10.537  21.133  1.00 43.32           C  
ATOM     33  CE2 TYR A   4      44.254   8.698  22.638  1.00 41.22           C  
ATOM     34  CZ  TYR A   4      44.625   9.405  21.513  1.00 44.34           C  
ATOM     35  OH  TYR A   4      45.692   8.966  20.761  1.00 44.70           O  
ATOM     36  N   GLY A   5      40.473  13.045  26.466  1.00 48.60           N  
ATOM     37  CA  GLY A   5      39.377  13.432  27.332  1.00 47.65           C  
ATOM     38  C   GLY A   5      38.848  12.332  28.228  1.00 47.02           C  
ATOM     39  O   GLY A   5      39.355  11.214  28.234  1.00 49.31           O  
ATOM     40  N   ALA A   6      37.814  12.657  28.991  1.00 45.85           N  
ATOM     41  CA  ALA A   6      37.205  11.706  29.904  1.00 46.57           C  
ATOM     42  C   ALA A   6      36.102  10.903  29.207  1.00 46.39           C  
ATOM     43  O   ALA A   6      35.727  11.195  28.070  1.00 43.54           O  
ATOM     44  CB  ALA A   6      36.627  12.451  31.101  1.00 47.15           C  
ATOM     45  N   PRO A   7      35.579   9.869  29.882  1.00 44.43           N  
ATOM     46  CA  PRO A   7      34.516   9.078  29.258  1.00 46.40           C  
ATOM     47  C   PRO A   7      33.278   9.958  29.074  1.00 46.51           C  
ATOM     48  O   PRO A   7      33.127  10.969  29.763  1.00 46.19           O  
ATOM     49  CB  PRO A   7      34.277   7.963  30.271  1.00 46.42           C  
ATOM     50  CG  PRO A   7      35.625   7.828  30.951  1.00 46.11           C  
ATOM     51  CD  PRO A   7      36.018   9.261  31.147  1.00 42.70           C  
ATOM     52  N   PHE A   8      32.405   9.587  28.139  1.00 45.85           N  
ATOM     53  CA  PHE A   8      31.180  10.345  27.905  1.00 45.44           C  
ATOM     54  C   PHE A   8      30.085   9.448  27.316  1.00 47.18           C  
ATOM     55  O   PHE A   8      30.379   8.419  26.696  1.00 46.33           O  
ATOM     56  CB  PHE A   8      31.467  11.557  27.011  1.00 42.71           C  
ATOM     57  CG  PHE A   8      31.946  11.207  25.629  1.00 43.78           C  
ATOM     58  CD1 PHE A   8      31.037  10.886  24.623  1.00 42.77           C  
ATOM     59  CD2 PHE A   8      33.302  11.232  25.324  1.00 40.21           C  
ATOM     60  CE1 PHE A   8      31.472  10.602  23.337  1.00 42.29           C  
ATOM     61  CE2 PHE A   8      33.745  10.949  24.038  1.00 44.23           C  
ATOM     62  CZ  PHE A   8      32.829  10.635  23.042  1.00 41.59           C  
ATOM     63  N   ASN A   9      28.824   9.829  27.530  1.00 46.47           N  
ATOM     64  CA  ASN A   9      27.709   9.025  27.051  1.00 45.22           C  
ATOM     65  C   ASN A   9      27.701   9.001  25.527  1.00 44.98           C  
ATOM     66  O   ASN A   9      27.670  10.050  24.883  1.00 45.79           O  
ATOM     67  CB  ASN A   9      26.389   9.564  27.617  1.00 44.57           C  
ATOM     68  CG  ASN A   9      25.237   8.604  27.407  1.00 44.62           C  
ATOM     69  OD1 ASN A   9      24.601   8.603  26.356  1.00 47.69           O  
ATOM     70  ND2 ASN A   9      24.980   7.758  28.400  1.00 44.62           N  
ATOM     71  N   PHE A  10      27.737   7.800  24.952  1.00 43.70           N  
ATOM     72  CA  PHE A  10      27.784   7.657  23.496  1.00 44.39           C  
ATOM     73  C   PHE A  10      26.452   7.874  22.775  1.00 43.36           C  
ATOM     74  O   PHE A  10      26.407   8.503  21.718  1.00 43.58           O  
ATOM     75  CB  PHE A  10      28.375   6.293  23.126  1.00 44.01           C  
ATOM     76  CG  PHE A  10      28.902   6.220  21.719  1.00 41.81           C  
ATOM     77  CD1 PHE A  10      29.378   7.358  21.082  1.00 40.90           C  
ATOM     78  CD2 PHE A  10      28.961   5.003  21.047  1.00 43.26           C  
ATOM     79  CE1 PHE A  10      29.909   7.291  19.800  1.00 41.04           C  
ATOM     80  CE2 PHE A  10      29.488   4.922  19.763  1.00 41.87           C  
ATOM     81  CZ  PHE A  10      29.963   6.067  19.139  1.00 43.73           C  
ATOM     82  N   PRO A  11      25.354   7.335  23.319  1.00 43.44           N  
ATOM     83  CA  PRO A  11      24.050   7.523  22.673  1.00 43.86           C  
ATOM     84  C   PRO A  11      23.761   9.016  22.546  1.00 45.00           C  
ATOM     85  O   PRO A  11      23.296   9.491  21.510  1.00 44.85           O  
ATOM     86  CB  PRO A  11      23.096   6.833  23.637  1.00 42.01           C  
ATOM     87  CG  PRO A  11      23.912   5.705  24.138  1.00 42.19           C  
ATOM     88  CD  PRO A  11      25.262   6.344  24.402  1.00 41.36           C  
ATOM     89  N   ARG A  12      24.051   9.752  23.615  1.00 47.82           N  
ATOM     90  CA  ARG A  12      23.840  11.195  23.639  1.00 48.90           C  
ATOM     91  C   ARG A  12      24.710  11.903  22.607  1.00 48.00           C  
ATOM     92  O   ARG A  12      24.243  12.795  21.906  1.00 50.14           O  
ATOM     93  CB  ARG A  12      24.144  11.749  25.035  1.00 51.65           C  
ATOM     94  CG  ARG A  12      24.172  13.263  25.096  1.00 54.54           C  
ATOM     95  CD  ARG A  12      24.486  13.751  26.493  1.00 58.52           C  
ATOM     96  NE  ARG A  12      24.418  15.206  26.584  1.00 62.07           N  
ATOM     97  CZ  ARG A  12      24.719  15.899  27.678  1.00 63.06           C  
ATOM     98  NH1 ARG A  12      25.109  15.268  28.777  1.00 63.34           N  
ATOM     99  NH2 ARG A  12      24.635  17.222  27.670  1.00 64.22           N  
ATOM    100  N   TRP A  13      25.980  11.514  22.522  1.00 47.64           N  
ATOM    101  CA  TRP A  13      26.898  12.111  21.550  1.00 45.35           C  
ATOM    102  C   TRP A  13      26.335  11.910  20.143  1.00 45.91           C  
ATOM    103  O   TRP A  13      26.361  12.821  19.313  1.00 45.91           O  
ATOM    104  CB  TRP A  13      28.271  11.437  21.628  1.00 43.85           C  
ATOM    105  CG  TRP A  13      29.300  12.009  20.683  1.00 40.33           C  
ATOM    106  CD1 TRP A  13      30.180  13.020  20.944  1.00 39.36           C  
ATOM    107  CD2 TRP A  13      29.567  11.585  19.336  1.00 40.44           C  
ATOM    108  NE1 TRP A  13      30.983  13.249  19.851  1.00 40.67           N  
ATOM    109  CE2 TRP A  13      30.628  12.383  18.849  1.00 40.65           C  
ATOM    110  CE3 TRP A  13      29.014  10.614  18.497  1.00 40.50           C  
ATOM    111  CZ2 TRP A  13      31.147  12.233  17.559  1.00 41.41           C  
ATOM    112  CZ3 TRP A  13      29.529  10.465  17.211  1.00 39.87           C  
ATOM    113  CH2 TRP A  13      30.587  11.272  16.756  1.00 40.84           C  
ATOM    114  N   ILE A  14      25.834  10.708  19.877  1.00 45.79           N  
ATOM    115  CA  ILE A  14      25.280  10.411  18.565  1.00 46.55           C  
ATOM    116  C   ILE A  14      24.054  11.287  18.293  1.00 47.92           C  
ATOM    117  O   ILE A  14      23.919  11.841  17.199  1.00 49.52           O  
ATOM    118  CB  ILE A  14      24.920   8.912  18.429  1.00 44.41           C  
ATOM    119  CG1 ILE A  14      26.186   8.062  18.594  1.00 44.96           C  
ATOM    120  CG2 ILE A  14      24.311   8.643  17.056  1.00 44.81           C  
ATOM    121  CD1 ILE A  14      25.965   6.559  18.483  1.00 40.53           C  
ATOM    122  N   ASP A  15      23.175  11.425  19.284  1.00 48.30           N  
ATOM    123  CA  ASP A  15      21.985  12.265  19.127  1.00 49.46           C  
ATOM    124  C   ASP A  15      22.384  13.692  18.762  1.00 51.33           C  
ATOM    125  O   ASP A  15      21.761  14.321  17.914  1.00 53.49           O  
ATOM    126  CB  ASP A  15      21.160  12.307  20.419  1.00 47.78           C  
ATOM    127  CG  ASP A  15      20.490  10.989  20.732  1.00 51.11           C  
ATOM    128  OD1 ASP A  15      20.244  10.214  19.790  1.00 53.36           O  
ATOM    129  OD2 ASP A  15      20.194  10.726  21.920  1.00 55.52           O  
ATOM    130  N   GLU A  16      23.436  14.197  19.399  1.00 52.59           N  
ATOM    131  CA  GLU A  16      23.888  15.559  19.151  1.00 53.06           C  
ATOM    132  C   GLU A  16      24.630  15.811  17.849  1.00 51.41           C  
ATOM    133  O   GLU A  16      24.673  16.944  17.379  1.00 51.48           O  
ATOM    134  CB  GLU A  16      24.745  16.041  20.318  1.00 54.60           C  
ATOM    135  CG  GLU A  16      23.972  16.159  21.610  1.00 59.79           C  
ATOM    136  CD  GLU A  16      24.797  16.750  22.735  1.00 64.01           C  
ATOM    137  OE1 GLU A  16      24.267  16.866  23.862  1.00 65.90           O  
ATOM    138  OE2 GLU A  16      25.975  17.100  22.493  1.00 67.06           O  
ATOM    139  N   HIS A  17      25.222  14.779  17.261  1.00 51.32           N  
ATOM    140  CA  HIS A  17      25.943  14.969  16.008  1.00 50.83           C  
ATOM    141  C   HIS A  17      25.217  14.311  14.846  1.00 52.56           C  
ATOM    142  O   HIS A  17      25.749  14.231  13.737  1.00 51.30           O  
ATOM    143  CB  HIS A  17      27.357  14.400  16.110  1.00 52.77           C  
ATOM    144  CG  HIS A  17      28.214  15.090  17.123  1.00 56.73           C  
ATOM    145  ND1 HIS A  17      28.025  14.943  18.481  1.00 55.44           N  
ATOM    146  CD2 HIS A  17      29.251  15.950  16.976  1.00 56.50           C  
ATOM    147  CE1 HIS A  17      28.911  15.682  19.127  1.00 57.49           C  
ATOM    148  NE2 HIS A  17      29.666  16.303  18.237  1.00 57.10           N  
ATOM    149  N   ALA A  18      24.000  13.843  15.106  1.00 53.17           N  
ATOM    150  CA  ALA A  18      23.197  13.187  14.082  1.00 56.59           C  
ATOM    151  C   ALA A  18      23.151  14.018  12.806  1.00 57.80           C  
ATOM    152  O   ALA A  18      23.441  13.523  11.720  1.00 58.41           O  
ATOM    153  CB  ALA A  18      21.784  12.945  14.601  1.00 55.77           C  
ATOM    154  N   HIS A  19      22.807  15.292  12.946  1.00 59.52           N  
ATOM    155  CA  HIS A  19      22.716  16.187  11.800  1.00 61.46           C  
ATOM    156  C   HIS A  19      24.034  16.378  11.042  1.00 61.19           C  
ATOM    157  O   HIS A  19      24.038  16.881   9.922  1.00 62.04           O  
ATOM    158  CB  HIS A  19      22.173  17.540  12.259  1.00 61.90           C  
ATOM    159  CG  HIS A  19      23.005  18.194  13.316  1.00 63.54           C  
ATOM    160  ND1 HIS A  19      24.000  19.102  13.024  1.00 63.08           N  
ATOM    161  CD2 HIS A  19      23.014  18.041  14.662  1.00 63.91           C  
ATOM    162  CE1 HIS A  19      24.588  19.480  14.146  1.00 63.94           C  
ATOM    163  NE2 HIS A  19      24.010  18.851  15.153  1.00 65.77           N  
ATOM    164  N   LEU A  20      25.149  15.975  11.643  1.00 62.75           N  
ATOM    165  CA  LEU A  20      26.456  16.117  10.994  1.00 63.16           C  
ATOM    166  C   LEU A  20      26.831  14.948  10.085  1.00 63.42           C  
ATOM    167  O   LEU A  20      27.765  15.051   9.292  1.00 64.05           O  
ATOM    168  CB  LEU A  20      27.555  16.312  12.046  1.00 63.85           C  
ATOM    169  CG  LEU A  20      27.851  17.722  12.575  1.00 64.76           C  
ATOM    170  CD1 LEU A  20      26.854  18.733  12.025  1.00 65.02           C  
ATOM    171  CD2 LEU A  20      27.818  17.701  14.091  1.00 64.25           C  
ATOM    172  N   LEU A  21      26.108  13.839  10.201  1.00 63.54           N  
ATOM    173  CA  LEU A  21      26.377  12.665   9.378  1.00 63.76           C  
ATOM    174  C   LEU A  21      25.715  12.842   8.010  1.00 65.22           C  
ATOM    175  O   LEU A  21      24.500  12.675   7.869  1.00 66.61           O  
ATOM    176  CB  LEU A  21      25.828  11.413  10.062  1.00 61.75           C  
ATOM    177  CG  LEU A  21      26.310  11.169  11.495  1.00 61.24           C  
ATOM    178  CD1 LEU A  21      25.616   9.951  12.068  1.00 59.25           C  
ATOM    179  CD2 LEU A  21      27.812  10.980  11.505  1.00 57.63           C  
ATOM    180  N   LYS A  22      26.513  13.179   7.002  1.00 65.23           N  
ATOM    181  CA  LYS A  22      25.975  13.397   5.666  1.00 64.32           C  
ATOM    182  C   LYS A  22      26.724  12.657   4.563  1.00 62.44           C  
ATOM    183  O   LYS A  22      27.878  12.262   4.735  1.00 62.16           O  
ATOM    184  CB  LYS A  22      25.960  14.894   5.350  1.00 66.83           C  
ATOM    185  CG  LYS A  22      25.169  15.724   6.346  1.00 69.46           C  
ATOM    186  CD  LYS A  22      24.770  17.066   5.756  1.00 71.29           C  
ATOM    187  CE  LYS A  22      23.797  16.881   4.600  1.00 73.07           C  
ATOM    188  NZ  LYS A  22      22.572  16.146   5.022  1.00 74.11           N  
ATOM    189  N   PRO A  23      26.061  12.459   3.409  1.00 60.92           N  
ATOM    190  CA  PRO A  23      26.626  11.770   2.243  1.00 58.27           C  
ATOM    191  C   PRO A  23      27.846  12.503   1.689  1.00 56.45           C  
ATOM    192  O   PRO A  23      28.055  13.682   1.975  1.00 57.28           O  
ATOM    193  CB  PRO A  23      25.469  11.770   1.247  1.00 58.81           C  
ATOM    194  CG  PRO A  23      24.261  11.771   2.124  1.00 61.17           C  
ATOM    195  CD  PRO A  23      24.639  12.773   3.184  1.00 60.40           C  
ATOM    196  N   PRO A  24      28.658  11.813   0.877  1.00 54.17           N  
ATOM    197  CA  PRO A  24      28.442  10.410   0.496  1.00 52.70           C  
ATOM    198  C   PRO A  24      28.799   9.368   1.575  1.00 51.49           C  
ATOM    199  O   PRO A  24      28.136   8.342   1.681  1.00 50.76           O  
ATOM    200  CB  PRO A  24      29.293  10.264  -0.762  1.00 52.05           C  
ATOM    201  CG  PRO A  24      30.450  11.192  -0.484  1.00 50.98           C  
ATOM    202  CD  PRO A  24      29.751  12.413   0.091  1.00 52.51           C  
ATOM    203  N   VAL A  25      29.820   9.643   2.384  1.00 49.44           N  
ATOM    204  CA  VAL A  25      30.250   8.699   3.416  1.00 48.01           C  
ATOM    205  C   VAL A  25      29.355   8.562   4.658  1.00 47.50           C  
ATOM    206  O   VAL A  25      29.136   7.447   5.135  1.00 46.21           O  
ATOM    207  CB  VAL A  25      31.677   9.014   3.898  1.00 47.46           C  
ATOM    208  CG1 VAL A  25      32.158   7.911   4.843  1.00 49.28           C  
ATOM    209  CG2 VAL A  25      32.616   9.141   2.705  1.00 46.73           C  
ATOM    210  N   GLY A  26      28.853   9.682   5.177  1.00 45.71           N  
ATOM    211  CA  GLY A  26      28.005   9.653   6.362  1.00 47.58           C  
ATOM    212  C   GLY A  26      28.870   9.551   7.604  1.00 48.37           C  
ATOM    213  O   GLY A  26      28.416   9.186   8.690  1.00 46.71           O  
ATOM    214  N   ASN A  27      30.131   9.914   7.401  1.00 50.09           N  
ATOM    215  CA  ASN A  27      31.207   9.875   8.386  1.00 50.45           C  
ATOM    216  C   ASN A  27      31.316  10.950   9.465  1.00 50.02           C  
ATOM    217  O   ASN A  27      30.966  12.107   9.254  1.00 51.15           O  
ATOM    218  CB  ASN A  27      32.532   9.850   7.624  1.00 50.29           C  
ATOM    219  CG  ASN A  27      33.267   8.572   7.817  1.00 52.41           C  
ATOM    220  OD1 ASN A  27      32.729   7.630   8.394  1.00 57.20           O  
ATOM    221  ND2 ASN A  27      34.501   8.514   7.338  1.00 51.84           N  
ATOM    222  N   ARG A  28      31.843  10.540  10.617  1.00 50.86           N  
ATOM    223  CA  ARG A  28      32.092  11.428  11.753  1.00 49.36           C  
ATOM    224  C   ARG A  28      33.063  10.735  12.706  1.00 47.68           C  
ATOM    225  O   ARG A  28      32.746   9.692  13.278  1.00 47.65           O  
ATOM    226  CB  ARG A  28      30.802  11.762  12.501  1.00 51.82           C  
ATOM    227  CG  ARG A  28      31.003  12.710  13.685  1.00 54.28           C  
ATOM    228  CD  ARG A  28      31.515  14.062  13.224  1.00 57.64           C  
ATOM    229  NE  ARG A  28      31.565  15.058  14.293  1.00 58.83           N  
ATOM    230  CZ  ARG A  28      31.692  16.367  14.078  1.00 61.59           C  
ATOM    231  NH1 ARG A  28      31.779  16.829  12.835  1.00 60.33           N  
ATOM    232  NH2 ARG A  28      31.737  17.218  15.098  1.00 62.03           N  
ATOM    233  N   GLN A  29      34.246  11.317  12.866  1.00 45.91           N  
ATOM    234  CA  GLN A  29      35.271  10.763  13.744  1.00 45.58           C  
ATOM    235  C   GLN A  29      35.088  11.269  15.178  1.00 44.61           C  
ATOM    236  O   GLN A  29      34.915  12.462  15.401  1.00 45.34           O  
ATOM    237  CB  GLN A  29      36.656  11.148  13.217  1.00 45.81           C  
ATOM    238  CG  GLN A  29      37.767  10.270  13.743  1.00 51.99           C  
ATOM    239  CD  GLN A  29      39.068  10.441  12.982  1.00 51.97           C  
ATOM    240  OE1 GLN A  29      39.076  10.524  11.753  1.00 53.06           O  
ATOM    241  NE2 GLN A  29      40.181  10.471  13.710  1.00 52.46           N  
ATOM    242  N   VAL A  30      35.140  10.363  16.149  1.00 43.79           N  
ATOM    243  CA  VAL A  30      34.961  10.733  17.548  1.00 42.91           C  
ATOM    244  C   VAL A  30      36.156  11.457  18.186  1.00 45.73           C  
ATOM    245  O   VAL A  30      35.989  12.493  18.825  1.00 46.42           O  
ATOM    246  CB  VAL A  30      34.619   9.495  18.399  1.00 41.91           C  
ATOM    247  CG1 VAL A  30      34.359   9.909  19.826  1.00 37.11           C  
ATOM    248  CG2 VAL A  30      33.387   8.780  17.815  1.00 42.00           C  
ATOM    249  N   TRP A  31      37.354  10.904  18.036  1.00 46.09           N  
ATOM    250  CA  TRP A  31      38.552  11.518  18.597  1.00 47.00           C  
ATOM    251  C   TRP A  31      39.528  11.810  17.474  1.00 47.88           C  
ATOM    252  O   TRP A  31      39.598  11.068  16.497  1.00 49.56           O  
ATOM    253  CB  TRP A  31      39.219  10.584  19.612  1.00 43.70           C  
ATOM    254  CG  TRP A  31      38.405  10.327  20.837  1.00 42.93           C  
ATOM    255  CD1 TRP A  31      38.210  11.175  21.884  1.00 41.82           C  
ATOM    256  CD2 TRP A  31      37.677   9.130  21.147  1.00 42.89           C  
ATOM    257  NE1 TRP A  31      37.409  10.583  22.831  1.00 43.37           N  
ATOM    258  CE2 TRP A  31      37.066   9.328  22.403  1.00 42.04           C  
ATOM    259  CE3 TRP A  31      37.481   7.910  20.480  1.00 40.67           C  
ATOM    260  CZ2 TRP A  31      36.270   8.352  23.010  1.00 41.37           C  
ATOM    261  CZ3 TRP A  31      36.687   6.940  21.083  1.00 41.95           C  
ATOM    262  CH2 TRP A  31      36.093   7.167  22.336  1.00 42.53           C  
ATOM    263  N   GLN A  32      40.282  12.891  17.612  1.00 49.17           N  
ATOM    264  CA  GLN A  32      41.245  13.263  16.592  1.00 50.91           C  
ATOM    265  C   GLN A  32      42.658  12.826  16.950  1.00 51.94           C  
ATOM    266  O   GLN A  32      43.013  12.710  18.125  1.00 50.66           O  
ATOM    267  CB  GLN A  32      41.230  14.779  16.376  1.00 51.88           C  
ATOM    268  CG  GLN A  32      39.904  15.343  15.886  1.00 53.37           C  
ATOM    269  CD  GLN A  32      39.594  14.942  14.461  1.00 54.61           C  
ATOM    270  OE1 GLN A  32      40.402  15.153  13.556  1.00 55.69           O  
ATOM    271  NE2 GLN A  32      38.418  14.366  14.251  1.00 56.23           N  
ATOM    272  N   ASP A  33      43.450  12.581  15.911  1.00 52.99           N  
ATOM    273  CA  ASP A  33      44.846  12.191  16.046  1.00 54.34           C  
ATOM    274  C   ASP A  33      45.112  11.052  17.014  1.00 53.32           C  
ATOM    275  O   ASP A  33      45.927  11.186  17.923  1.00 54.08           O  
ATOM    276  CB  ASP A  33      45.685  13.404  16.461  1.00 57.37           C  
ATOM    277  CG  ASP A  33      45.502  14.589  15.529  1.00 59.30           C  
ATOM    278  OD1 ASP A  33      45.648  14.420  14.294  1.00 59.64           O  
ATOM    279  OD2 ASP A  33      45.216  15.692  16.038  1.00 58.65           O  
ATOM    280  N   SER A  34      44.437   9.927  16.806  1.00 51.78           N  
ATOM    281  CA  SER A  34      44.613   8.758  17.655  1.00 48.07           C  
ATOM    282  C   SER A  34      44.972   7.576  16.766  1.00 47.34           C  
ATOM    283  O   SER A  34      44.705   7.600  15.567  1.00 47.35           O  
ATOM    284  CB  SER A  34      43.325   8.478  18.431  1.00 48.60           C  
ATOM    285  OG  SER A  34      42.208   8.428  17.563  1.00 48.97           O  
ATOM    286  N   ASP A  35      45.594   6.549  17.335  1.00 44.72           N  
ATOM    287  CA  ASP A  35      45.961   5.391  16.530  1.00 43.20           C  
ATOM    288  C   ASP A  35      44.677   4.662  16.123  1.00 42.22           C  
ATOM    289  O   ASP A  35      44.562   4.199  14.992  1.00 44.12           O  
ATOM    290  CB  ASP A  35      46.888   4.456  17.305  1.00 40.59           C  
ATOM    291  CG  ASP A  35      47.253   3.216  16.514  1.00 40.21           C  
ATOM    292  OD1 ASP A  35      47.146   2.108  17.069  1.00 42.99           O  
ATOM    293  OD2 ASP A  35      47.647   3.339  15.340  1.00 41.46           O  
ATOM    294  N   PHE A  36      43.722   4.559  17.047  1.00 40.55           N  
ATOM    295  CA  PHE A  36      42.440   3.928  16.738  1.00 41.34           C  
ATOM    296  C   PHE A  36      41.557   5.020  16.118  1.00 41.88           C  
ATOM    297  O   PHE A  36      41.336   6.080  16.726  1.00 41.83           O  
ATOM    298  CB  PHE A  36      41.759   3.388  18.005  1.00 40.13           C  
ATOM    299  CG  PHE A  36      42.169   1.983  18.385  1.00 44.37           C  
ATOM    300  CD1 PHE A  36      42.508   1.676  19.701  1.00 45.50           C  
ATOM    301  CD2 PHE A  36      42.174   0.957  17.439  1.00 48.18           C  
ATOM    302  CE1 PHE A  36      42.848   0.374  20.082  1.00 44.96           C  
ATOM    303  CE2 PHE A  36      42.512  -0.357  17.805  1.00 50.02           C  
ATOM    304  CZ  PHE A  36      42.851  -0.646  19.138  1.00 48.47           C  
ATOM    305  N   ILE A  37      41.089   4.776  14.898  1.00 38.19           N  
ATOM    306  CA  ILE A  37      40.215   5.720  14.223  1.00 37.99           C  
ATOM    307  C   ILE A  37      38.793   5.275  14.564  1.00 38.48           C  
ATOM    308  O   ILE A  37      38.297   4.266  14.049  1.00 39.02           O  
ATOM    309  CB  ILE A  37      40.453   5.701  12.699  1.00 38.45           C  
ATOM    310  CG1 ILE A  37      41.930   5.976  12.411  1.00 39.18           C  
ATOM    311  CG2 ILE A  37      39.613   6.773  12.015  1.00 38.72           C  
ATOM    312  CD1 ILE A  37      42.266   6.017  10.945  1.00 40.72           C  
ATOM    313  N   VAL A  38      38.163   6.015  15.472  1.00 37.54           N  
ATOM    314  CA  VAL A  38      36.813   5.706  15.919  1.00 38.40           C  
ATOM    315  C   VAL A  38      35.805   6.615  15.243  1.00 40.64           C  
ATOM    316  O   VAL A  38      35.833   7.842  15.401  1.00 40.24           O  
ATOM    317  CB  VAL A  38      36.688   5.861  17.440  1.00 36.89           C  
ATOM    318  CG1 VAL A  38      35.278   5.514  17.884  1.00 37.13           C  
ATOM    319  CG2 VAL A  38      37.692   4.964  18.127  1.00 39.03           C  
ATOM    320  N   THR A  39      34.902   6.002  14.488  1.00 40.41           N  
ATOM    321  CA  THR A  39      33.910   6.767  13.761  1.00 41.31           C  
ATOM    322  C   THR A  39      32.501   6.225  13.902  1.00 41.13           C  
ATOM    323  O   THR A  39      32.277   5.058  14.233  1.00 39.01           O  
ATOM    324  CB  THR A  39      34.219   6.781  12.252  1.00 41.75           C  
ATOM    325  OG1 THR A  39      33.984   5.470  11.718  1.00 45.50           O  
ATOM    326  CG2 THR A  39      35.669   7.169  11.994  1.00 38.01           C  
ATOM    327  N   VAL A  40      31.550   7.112  13.653  1.00 43.14           N  
ATOM    328  CA  VAL A  40      30.146   6.757  13.657  1.00 42.36           C  
ATOM    329  C   VAL A  40      29.722   7.103  12.239  1.00 42.54           C  
ATOM    330  O   VAL A  40      30.042   8.184  11.734  1.00 41.74           O  
ATOM    331  CB  VAL A  40      29.335   7.591  14.641  1.00 43.84           C  
ATOM    332  CG1 VAL A  40      27.851   7.275  14.472  1.00 41.09           C  
ATOM    333  CG2 VAL A  40      29.790   7.287  16.075  1.00 44.03           C  
ATOM    334  N   VAL A  41      29.034   6.173  11.593  1.00 41.20           N  
ATOM    335  CA  VAL A  41      28.575   6.375  10.232  1.00 41.80           C  
ATOM    336  C   VAL A  41      27.062   6.215  10.176  1.00 41.08           C  
ATOM    337  O   VAL A  41      26.522   5.216  10.656  1.00 39.70           O  
ATOM    338  CB  VAL A  41      29.205   5.346   9.276  1.00 41.08           C  
ATOM    339  CG1 VAL A  41      29.026   5.806   7.843  1.00 43.35           C  
ATOM    340  CG2 VAL A  41      30.673   5.146   9.610  1.00 40.00           C  
ATOM    341  N   GLY A  42      26.394   7.198   9.585  1.00 41.13           N  
ATOM    342  CA  GLY A  42      24.949   7.156   9.471  1.00 44.21           C  
ATOM    343  C   GLY A  42      24.489   7.046   8.032  1.00 44.75           C  
ATOM    344  O   GLY A  42      25.272   6.730   7.140  1.00 45.58           O  
ATOM    345  N   GLY A  43      23.209   7.310   7.797  1.00 46.29           N  
ATOM    346  CA  GLY A  43      22.685   7.228   6.450  1.00 44.88           C  
ATOM    347  C   GLY A  43      21.715   8.354   6.178  1.00 45.87           C  
ATOM    348  O   GLY A  43      21.408   9.126   7.084  1.00 46.26           O  
ATOM    349  N   PRO A  44      21.215   8.478   4.939  1.00 45.42           N  
ATOM    350  CA  PRO A  44      21.533   7.602   3.804  1.00 46.05           C  
ATOM    351  C   PRO A  44      22.878   7.982   3.200  1.00 46.21           C  
ATOM    352  O   PRO A  44      23.132   9.159   2.967  1.00 47.11           O  
ATOM    353  CB  PRO A  44      20.395   7.873   2.810  1.00 45.47           C  
ATOM    354  CG  PRO A  44      19.345   8.621   3.618  1.00 48.33           C  
ATOM    355  CD  PRO A  44      20.169   9.441   4.569  1.00 45.57           C  
ATOM    356  N   ASN A  45      23.736   7.002   2.937  1.00 46.10           N  
ATOM    357  CA  ASN A  45      25.032   7.311   2.340  1.00 48.58           C  
ATOM    358  C   ASN A  45      24.961   7.069   0.833  1.00 50.24           C  
ATOM    359  O   ASN A  45      23.909   6.710   0.307  1.00 51.03           O  
ATOM    360  CB  ASN A  45      26.142   6.458   2.981  1.00 44.20           C  
ATOM    361  CG  ASN A  45      26.061   4.993   2.590  1.00 46.30           C  
ATOM    362  OD1 ASN A  45      25.024   4.516   2.131  1.00 43.22           O  
ATOM    363  ND2 ASN A  45      27.163   4.265   2.786  1.00 42.74           N  
ATOM    364  N   HIS A  46      26.070   7.283   0.136  1.00 50.74           N  
ATOM    365  CA  HIS A  46      26.106   7.065  -1.301  1.00 50.88           C  
ATOM    366  C   HIS A  46      27.476   6.527  -1.663  1.00 50.43           C  
ATOM    367  O   HIS A  46      28.414   7.292  -1.892  1.00 50.09           O  
ATOM    368  CB  HIS A  46      25.861   8.365  -2.062  1.00 53.99           C  
ATOM    369  CG  HIS A  46      25.702   8.169  -3.537  1.00 58.22           C  
ATOM    370  ND1 HIS A  46      25.875   9.187  -4.448  1.00 60.10           N  
ATOM    371  CD2 HIS A  46      25.370   7.071  -4.258  1.00 59.74           C  
ATOM    372  CE1 HIS A  46      25.659   8.725  -5.668  1.00 61.81           C  
ATOM    373  NE2 HIS A  46      25.350   7.443  -5.580  1.00 61.20           N  
ATOM    374  N   ARG A  47      27.577   5.203  -1.719  1.00 49.01           N  
ATOM    375  CA  ARG A  47      28.827   4.526  -2.024  1.00 46.77           C  
ATOM    376  C   ARG A  47      28.642   3.568  -3.202  1.00 47.14           C  
ATOM    377  O   ARG A  47      27.754   2.718  -3.184  1.00 46.46           O  
ATOM    378  CB  ARG A  47      29.294   3.731  -0.795  1.00 46.26           C  
ATOM    379  CG  ARG A  47      29.477   4.550   0.494  1.00 46.27           C  
ATOM    380  CD  ARG A  47      30.677   5.492   0.410  1.00 44.39           C  
ATOM    381  NE  ARG A  47      31.946   4.784   0.239  1.00 44.46           N  
ATOM    382  CZ  ARG A  47      32.669   4.255   1.227  1.00 44.58           C  
ATOM    383  NH1 ARG A  47      32.270   4.345   2.492  1.00 41.10           N  
ATOM    384  NH2 ARG A  47      33.799   3.627   0.941  1.00 44.02           N  
ATOM    385  N   THR A  48      29.476   3.711  -4.223  1.00 45.71           N  
ATOM    386  CA  THR A  48      29.409   2.833  -5.388  1.00 45.00           C  
ATOM    387  C   THR A  48      30.757   2.153  -5.492  1.00 43.04           C  
ATOM    388  O   THR A  48      30.979   1.292  -6.334  1.00 45.35           O  
ATOM    389  CB  THR A  48      29.136   3.621  -6.700  1.00 45.33           C  
ATOM    390  OG1 THR A  48      30.258   4.456  -7.009  1.00 46.16           O  
ATOM    391  CG2 THR A  48      27.898   4.493  -6.547  1.00 44.65           C  
ATOM    392  N   ASP A  49      31.637   2.543  -4.581  1.00 43.62           N  
ATOM    393  CA  ASP A  49      33.003   2.054  -4.497  1.00 41.64           C  
ATOM    394  C   ASP A  49      33.187   0.887  -3.521  1.00 41.98           C  
ATOM    395  O   ASP A  49      32.412   0.721  -2.573  1.00 38.52           O  
ATOM    396  CB  ASP A  49      33.887   3.207  -4.031  1.00 43.69           C  
ATOM    397  CG  ASP A  49      33.644   3.561  -2.567  1.00 42.08           C  
ATOM    398  OD1 ASP A  49      34.390   3.051  -1.712  1.00 41.49           O  
ATOM    399  OD2 ASP A  49      32.696   4.327  -2.265  1.00 42.09           O  
ATOM    400  N   TYR A  50      34.230   0.096  -3.764  1.00 41.05           N  
ATOM    401  CA  TYR A  50      34.595  -1.028  -2.903  1.00 42.52           C  
ATOM    402  C   TYR A  50      35.924  -0.632  -2.268  1.00 41.72           C  
ATOM    403  O   TYR A  50      36.897  -0.347  -2.973  1.00 41.40           O  
ATOM    404  CB  TYR A  50      34.798  -2.314  -3.711  1.00 41.99           C  
ATOM    405  CG  TYR A  50      33.518  -3.018  -4.078  1.00 47.27           C  
ATOM    406  CD1 TYR A  50      33.068  -4.111  -3.336  1.00 46.13           C  
ATOM    407  CD2 TYR A  50      32.743  -2.584  -5.156  1.00 46.30           C  
ATOM    408  CE1 TYR A  50      31.878  -4.753  -3.656  1.00 44.67           C  
ATOM    409  CE2 TYR A  50      31.546  -3.221  -5.485  1.00 45.78           C  
ATOM    410  CZ  TYR A  50      31.120  -4.304  -4.728  1.00 47.47           C  
ATOM    411  OH  TYR A  50      29.930  -4.928  -5.026  1.00 45.97           O  
ATOM    412  N   HIS A  51      35.958  -0.617  -0.943  1.00 39.90           N  
ATOM    413  CA  HIS A  51      37.154  -0.241  -0.210  1.00 41.39           C  
ATOM    414  C   HIS A  51      38.065  -1.436   0.004  1.00 41.24           C  
ATOM    415  O   HIS A  51      37.610  -2.542   0.299  1.00 44.41           O  
ATOM    416  CB  HIS A  51      36.774   0.364   1.148  1.00 39.21           C  
ATOM    417  CG  HIS A  51      37.942   0.889   1.930  1.00 42.25           C  
ATOM    418  ND1 HIS A  51      37.882   1.129   3.285  1.00 42.76           N  
ATOM    419  CD2 HIS A  51      39.189   1.250   1.544  1.00 44.93           C  
ATOM    420  CE1 HIS A  51      39.039   1.611   3.703  1.00 40.93           C  
ATOM    421  NE2 HIS A  51      39.850   1.696   2.666  1.00 45.74           N  
ATOM    422  N   ASP A  52      39.360  -1.202  -0.159  1.00 41.23           N  
ATOM    423  CA  ASP A  52      40.357  -2.235   0.044  1.00 41.17           C  
ATOM    424  C   ASP A  52      41.243  -1.727   1.170  1.00 41.48           C  
ATOM    425  O   ASP A  52      42.236  -1.026   0.942  1.00 38.05           O  
ATOM    426  CB  ASP A  52      41.161  -2.444  -1.232  1.00 43.51           C  
ATOM    427  CG  ASP A  52      42.312  -3.387  -1.041  1.00 46.69           C  
ATOM    428  OD1 ASP A  52      42.345  -4.083  -0.003  1.00 48.92           O  
ATOM    429  OD2 ASP A  52      43.184  -3.440  -1.933  1.00 49.35           O  
ATOM    430  N   ASP A  53      40.856  -2.075   2.394  1.00 40.57           N  
ATOM    431  CA  ASP A  53      41.569  -1.647   3.582  1.00 39.78           C  
ATOM    432  C   ASP A  53      42.683  -2.637   3.910  1.00 40.19           C  
ATOM    433  O   ASP A  53      42.441  -3.831   4.025  1.00 40.36           O  
ATOM    434  CB  ASP A  53      40.569  -1.535   4.736  1.00 41.19           C  
ATOM    435  CG  ASP A  53      41.110  -0.750   5.911  1.00 40.29           C  
ATOM    436  OD1 ASP A  53      40.299  -0.130   6.623  1.00 39.75           O  
ATOM    437  OD2 ASP A  53      42.337  -0.757   6.127  1.00 41.77           O  
ATOM    438  N   PRO A  54      43.927  -2.152   4.049  1.00 37.90           N  
ATOM    439  CA  PRO A  54      45.049  -3.040   4.363  1.00 39.10           C  
ATOM    440  C   PRO A  54      44.995  -3.602   5.785  1.00 40.30           C  
ATOM    441  O   PRO A  54      45.706  -4.548   6.117  1.00 40.84           O  
ATOM    442  CB  PRO A  54      46.266  -2.146   4.133  1.00 37.80           C  
ATOM    443  CG  PRO A  54      45.762  -0.805   4.494  1.00 38.33           C  
ATOM    444  CD  PRO A  54      44.398  -0.775   3.843  1.00 38.12           C  
ATOM    445  N   LEU A  55      44.136  -3.018   6.617  1.00 41.74           N  
ATOM    446  CA  LEU A  55      43.975  -3.450   8.003  1.00 40.82           C  
ATOM    447  C   LEU A  55      42.516  -3.868   8.239  1.00 40.19           C  
ATOM    448  O   LEU A  55      41.669  -3.690   7.364  1.00 39.23           O  
ATOM    449  CB  LEU A  55      44.379  -2.303   8.945  1.00 42.23           C  
ATOM    450  CG  LEU A  55      45.831  -1.811   8.751  1.00 42.54           C  
ATOM    451  CD1 LEU A  55      46.098  -0.537   9.558  1.00 43.47           C  
ATOM    452  CD2 LEU A  55      46.789  -2.906   9.173  1.00 38.97           C  
ATOM    453  N   GLU A  56      42.227  -4.416   9.415  1.00 40.21           N  
ATOM    454  CA  GLU A  56      40.875  -4.866   9.736  1.00 39.85           C  
ATOM    455  C   GLU A  56      40.002  -3.675  10.090  1.00 40.59           C  
ATOM    456  O   GLU A  56      40.505  -2.582  10.381  1.00 38.36           O  
ATOM    457  CB  GLU A  56      40.888  -5.827  10.935  1.00 40.47           C  
ATOM    458  CG  GLU A  56      42.087  -6.756  11.005  1.00 41.93           C  
ATOM    459  CD  GLU A  56      42.044  -7.675  12.214  1.00 42.00           C  
ATOM    460  OE1 GLU A  56      41.535  -7.261  13.277  1.00 44.19           O  
ATOM    461  OE2 GLU A  56      42.536  -8.810  12.111  1.00 42.90           O  
ATOM    462  N   GLU A  57      38.694  -3.896  10.055  1.00 38.08           N  
ATOM    463  CA  GLU A  57      37.729  -2.866  10.397  1.00 37.81           C  
ATOM    464  C   GLU A  57      36.698  -3.506  11.321  1.00 38.99           C  
ATOM    465  O   GLU A  57      36.200  -4.594  11.029  1.00 36.59           O  
ATOM    466  CB  GLU A  57      37.025  -2.336   9.147  1.00 40.06           C  
ATOM    467  CG  GLU A  57      37.946  -1.806   8.055  1.00 39.88           C  
ATOM    468  CD  GLU A  57      37.195  -1.123   6.927  1.00 41.86           C  
ATOM    469  OE1 GLU A  57      37.855  -0.679   5.967  1.00 45.05           O  
ATOM    470  OE2 GLU A  57      35.951  -1.018   6.989  1.00 41.37           O  
ATOM    471  N   PHE A  58      36.396  -2.849  12.439  1.00 37.43           N  
ATOM    472  CA  PHE A  58      35.404  -3.362  13.384  1.00 36.02           C  
ATOM    473  C   PHE A  58      34.080  -2.640  13.158  1.00 36.60           C  
ATOM    474  O   PHE A  58      34.047  -1.421  12.974  1.00 38.55           O  
ATOM    475  CB  PHE A  58      35.860  -3.134  14.829  1.00 34.42           C  
ATOM    476  CG  PHE A  58      34.797  -3.425  15.855  1.00 35.21           C  
ATOM    477  CD1 PHE A  58      34.539  -4.729  16.268  1.00 34.34           C  
ATOM    478  CD2 PHE A  58      34.031  -2.393  16.389  1.00 34.99           C  
ATOM    479  CE1 PHE A  58      33.534  -4.999  17.199  1.00 38.45           C  
ATOM    480  CE2 PHE A  58      33.023  -2.651  17.316  1.00 36.08           C  
ATOM    481  CZ  PHE A  58      32.772  -3.956  17.725  1.00 35.95           C  
ATOM    482  N   PHE A  59      32.985  -3.384  13.189  1.00 34.02           N  
ATOM    483  CA  PHE A  59      31.681  -2.782  12.987  1.00 33.79           C  
ATOM    484  C   PHE A  59      30.727  -3.121  14.132  1.00 34.88           C  
ATOM    485  O   PHE A  59      30.732  -4.230  14.658  1.00 35.42           O  
ATOM    486  CB  PHE A  59      31.047  -3.286  11.686  1.00 35.08           C  
ATOM    487  CG  PHE A  59      31.765  -2.862  10.425  1.00 35.31           C  
ATOM    488  CD1 PHE A  59      31.295  -1.790   9.669  1.00 37.89           C  
ATOM    489  CD2 PHE A  59      32.877  -3.558   9.972  1.00 35.14           C  
ATOM    490  CE1 PHE A  59      31.921  -1.419   8.475  1.00 39.78           C  
ATOM    491  CE2 PHE A  59      33.514  -3.198   8.782  1.00 35.89           C  
ATOM    492  CZ  PHE A  59      33.035  -2.130   8.032  1.00 38.64           C  
ATOM    493  N   TYR A  60      29.914  -2.155  14.518  1.00 34.40           N  
ATOM    494  CA  TYR A  60      28.909  -2.386  15.536  1.00 35.96           C  
ATOM    495  C   TYR A  60      27.731  -1.509  15.151  1.00 36.11           C  
ATOM    496  O   TYR A  60      27.726  -0.298  15.421  1.00 35.12           O  
ATOM    497  CB  TYR A  60      29.427  -2.021  16.925  1.00 36.72           C  
ATOM    498  CG  TYR A  60      28.496  -2.445  18.028  1.00 38.23           C  
ATOM    499  CD1 TYR A  60      27.352  -3.196  17.747  1.00 40.33           C  
ATOM    500  CD2 TYR A  60      28.746  -2.094  19.352  1.00 38.82           C  
ATOM    501  CE1 TYR A  60      26.482  -3.586  18.750  1.00 43.93           C  
ATOM    502  CE2 TYR A  60      27.878  -2.481  20.369  1.00 43.30           C  
ATOM    503  CZ  TYR A  60      26.750  -3.225  20.057  1.00 42.80           C  
ATOM    504  OH  TYR A  60      25.884  -3.612  21.045  1.00 47.64           O  
ATOM    505  N   GLN A  61      26.744  -2.115  14.490  1.00 35.49           N  
ATOM    506  CA  GLN A  61      25.575  -1.368  14.040  1.00 37.15           C  
ATOM    507  C   GLN A  61      24.709  -1.087  15.249  1.00 38.64           C  
ATOM    508  O   GLN A  61      23.966  -1.946  15.706  1.00 41.86           O  
ATOM    509  CB  GLN A  61      24.782  -2.155  12.978  1.00 35.39           C  
ATOM    510  CG  GLN A  61      23.699  -1.318  12.268  1.00 32.28           C  
ATOM    511  CD  GLN A  61      24.266  -0.232  11.346  1.00 36.08           C  
ATOM    512  OE1 GLN A  61      23.752   0.890  11.295  1.00 38.41           O  
ATOM    513  NE2 GLN A  61      25.314  -0.568  10.604  1.00 35.65           N  
ATOM    514  N   LEU A  62      24.823   0.132  15.759  1.00 41.77           N  
ATOM    515  CA  LEU A  62      24.091   0.558  16.944  1.00 41.88           C  
ATOM    516  C   LEU A  62      22.642   0.894  16.665  1.00 43.05           C  
ATOM    517  O   LEU A  62      21.756   0.465  17.394  1.00 44.30           O  
ATOM    518  CB  LEU A  62      24.765   1.782  17.562  1.00 42.53           C  
ATOM    519  CG  LEU A  62      26.261   1.714  17.865  1.00 42.43           C  
ATOM    520  CD1 LEU A  62      26.692   2.995  18.573  1.00 44.27           C  
ATOM    521  CD2 LEU A  62      26.559   0.529  18.726  1.00 40.47           C  
ATOM    522  N   ARG A  63      22.405   1.680  15.621  1.00 42.20           N  
ATOM    523  CA  ARG A  63      21.050   2.074  15.271  1.00 43.60           C  
ATOM    524  C   ARG A  63      20.742   1.780  13.808  1.00 44.95           C  
ATOM    525  O   ARG A  63      21.562   2.050  12.922  1.00 44.73           O  
ATOM    526  CB  ARG A  63      20.848   3.569  15.542  1.00 42.45           C  
ATOM    527  CG  ARG A  63      21.110   3.976  16.995  1.00 45.38           C  
ATOM    528  CD  ARG A  63      20.930   5.469  17.192  1.00 44.42           C  
ATOM    529  NE  ARG A  63      21.336   5.900  18.527  1.00 47.46           N  
ATOM    530  CZ  ARG A  63      21.330   7.167  18.937  1.00 47.33           C  
ATOM    531  NH1 ARG A  63      20.936   8.133  18.116  1.00 43.58           N  
ATOM    532  NH2 ARG A  63      21.733   7.472  20.163  1.00 47.24           N  
ATOM    533  N   GLY A  64      19.562   1.210  13.573  1.00 44.29           N  
ATOM    534  CA  GLY A  64      19.125   0.911  12.224  1.00 43.26           C  
ATOM    535  C   GLY A  64      19.794  -0.272  11.557  1.00 43.62           C  
ATOM    536  O   GLY A  64      20.527  -1.030  12.186  1.00 43.88           O  
ATOM    537  N   ASN A  65      19.544  -0.412  10.261  1.00 43.98           N  
ATOM    538  CA  ASN A  65      20.095  -1.516   9.490  1.00 42.33           C  
ATOM    539  C   ASN A  65      20.890  -1.003   8.309  1.00 41.29           C  
ATOM    540  O   ASN A  65      20.605   0.066   7.769  1.00 40.62           O  
ATOM    541  CB  ASN A  65      18.959  -2.400   8.975  1.00 44.20           C  
ATOM    542  CG  ASN A  65      17.951  -2.742  10.059  1.00 43.19           C  
ATOM    543  OD1 ASN A  65      18.215  -3.568  10.928  1.00 43.41           O  
ATOM    544  ND2 ASN A  65      16.794  -2.087  10.015  1.00 42.38           N  
ATOM    545  N   ALA A  66      21.882  -1.785   7.904  1.00 41.53           N  
ATOM    546  CA  ALA A  66      22.724  -1.446   6.768  1.00 40.30           C  
ATOM    547  C   ALA A  66      23.281  -2.764   6.238  1.00 40.58           C  
ATOM    548  O   ALA A  66      22.965  -3.818   6.766  1.00 38.71           O  
ATOM    549  CB  ALA A  66      23.861  -0.536   7.223  1.00 39.99           C  
ATOM    550  N   TYR A  67      24.092  -2.712   5.185  1.00 42.33           N  
ATOM    551  CA  TYR A  67      24.707  -3.933   4.665  1.00 42.04           C  
ATOM    552  C   TYR A  67      25.978  -3.621   3.889  1.00 41.39           C  
ATOM    553  O   TYR A  67      26.191  -2.498   3.433  1.00 41.70           O  
ATOM    554  CB  TYR A  67      23.740  -4.755   3.783  1.00 38.42           C  
ATOM    555  CG  TYR A  67      23.223  -4.066   2.538  1.00 40.41           C  
ATOM    556  CD1 TYR A  67      22.188  -3.132   2.611  1.00 38.45           C  
ATOM    557  CD2 TYR A  67      23.771  -4.352   1.280  1.00 40.23           C  
ATOM    558  CE1 TYR A  67      21.709  -2.497   1.470  1.00 41.80           C  
ATOM    559  CE2 TYR A  67      23.301  -3.720   0.129  1.00 40.91           C  
ATOM    560  CZ  TYR A  67      22.271  -2.796   0.233  1.00 41.84           C  
ATOM    561  OH  TYR A  67      21.798  -2.166  -0.890  1.00 44.34           O  
ATOM    562  N   LEU A  68      26.831  -4.625   3.773  1.00 40.32           N  
ATOM    563  CA  LEU A  68      28.076  -4.469   3.059  1.00 40.97           C  
ATOM    564  C   LEU A  68      28.054  -5.307   1.789  1.00 41.86           C  
ATOM    565  O   LEU A  68      27.840  -6.520   1.842  1.00 39.26           O  
ATOM    566  CB  LEU A  68      29.243  -4.921   3.935  1.00 39.17           C  
ATOM    567  CG  LEU A  68      29.413  -4.195   5.277  1.00 41.12           C  
ATOM    568  CD1 LEU A  68      30.594  -4.774   6.021  1.00 37.91           C  
ATOM    569  CD2 LEU A  68      29.614  -2.706   5.043  1.00 38.42           C  
ATOM    570  N   ASN A  69      28.236  -4.657   0.645  1.00 41.49           N  
ATOM    571  CA  ASN A  69      28.323  -5.403  -0.602  1.00 43.90           C  
ATOM    572  C   ASN A  69      29.773  -5.877  -0.589  1.00 44.22           C  
ATOM    573  O   ASN A  69      30.672  -5.098  -0.276  1.00 44.73           O  
ATOM    574  CB  ASN A  69      28.046  -4.506  -1.814  1.00 43.05           C  
ATOM    575  CG  ASN A  69      26.562  -4.326  -2.071  1.00 46.49           C  
ATOM    576  OD1 ASN A  69      25.766  -5.230  -1.805  1.00 45.60           O  
ATOM    577  ND2 ASN A  69      26.181  -3.168  -2.602  1.00 48.67           N  
ATOM    578  N   LEU A  70      29.997  -7.151  -0.896  1.00 44.72           N  
ATOM    579  CA  LEU A  70      31.340  -7.721  -0.870  1.00 48.71           C  
ATOM    580  C   LEU A  70      31.682  -8.554  -2.107  1.00 52.73           C  
ATOM    581  O   LEU A  70      30.872  -8.722  -3.013  1.00 52.71           O  
ATOM    582  CB  LEU A  70      31.486  -8.643   0.346  1.00 46.34           C  
ATOM    583  CG  LEU A  70      31.067  -8.196   1.750  1.00 45.99           C  
ATOM    584  CD1 LEU A  70      30.897  -9.419   2.635  1.00 45.01           C  
ATOM    585  CD2 LEU A  70      32.099  -7.247   2.334  1.00 44.54           C  
ATOM    586  N   TRP A  71      32.914  -9.058  -2.106  1.00 58.11           N  
ATOM    587  CA  TRP A  71      33.453  -9.964  -3.125  1.00 62.36           C  
ATOM    588  C   TRP A  71      34.101 -11.019  -2.224  1.00 65.51           C  
ATOM    589  O   TRP A  71      34.994 -10.689  -1.440  1.00 65.40           O  
ATOM    590  CB  TRP A  71      34.543  -9.307  -3.979  1.00 62.24           C  
ATOM    591  CG  TRP A  71      34.051  -8.385  -5.049  1.00 63.48           C  
ATOM    592  CD1 TRP A  71      33.978  -7.029  -4.986  1.00 64.43           C  
ATOM    593  CD2 TRP A  71      33.572  -8.753  -6.351  1.00 64.84           C  
ATOM    594  NE1 TRP A  71      33.483  -6.523  -6.166  1.00 65.61           N  
ATOM    595  CE2 TRP A  71      33.226  -7.560  -7.021  1.00 64.14           C  
ATOM    596  CE3 TRP A  71      33.401  -9.975  -7.015  1.00 65.27           C  
ATOM    597  CZ2 TRP A  71      32.718  -7.549  -8.323  1.00 64.04           C  
ATOM    598  CZ3 TRP A  71      32.894  -9.963  -8.313  1.00 64.27           C  
ATOM    599  CH2 TRP A  71      32.561  -8.755  -8.951  1.00 64.04           C  
ATOM    600  N   VAL A  72      33.656 -12.270  -2.309  1.00 68.87           N  
ATOM    601  CA  VAL A  72      34.213 -13.312  -1.445  1.00 73.16           C  
ATOM    602  C   VAL A  72      35.253 -14.209  -2.115  1.00 75.17           C  
ATOM    603  O   VAL A  72      36.085 -14.821  -1.442  1.00 75.83           O  
ATOM    604  CB  VAL A  72      33.092 -14.198  -0.852  1.00 73.67           C  
ATOM    605  CG1 VAL A  72      32.519 -15.109  -1.929  1.00 74.30           C  
ATOM    606  CG2 VAL A  72      33.634 -15.000   0.325  1.00 74.49           C  
ATOM    607  N   ASP A  73      35.196 -14.294  -3.438  1.00 78.18           N  
ATOM    608  CA  ASP A  73      36.148 -15.096  -4.202  1.00 80.35           C  
ATOM    609  C   ASP A  73      36.309 -14.439  -5.559  1.00 81.12           C  
ATOM    610  O   ASP A  73      37.421 -14.232  -6.046  1.00 81.92           O  
ATOM    611  CB  ASP A  73      35.638 -16.534  -4.369  1.00 80.09           C  
ATOM    612  CG  ASP A  73      36.156 -17.466  -3.285  1.00 81.15           C  
ATOM    613  OD1 ASP A  73      37.378 -17.730  -3.264  1.00 81.19           O  
ATOM    614  OD2 ASP A  73      35.347 -17.930  -2.453  1.00 80.05           O  
ATOM    615  N   GLY A  74      35.167 -14.102  -6.145  1.00 81.20           N  
ATOM    616  CA  GLY A  74      35.113 -13.461  -7.441  1.00 81.01           C  
ATOM    617  C   GLY A  74      33.637 -13.214  -7.648  1.00 81.45           C  
ATOM    618  O   GLY A  74      33.193 -12.788  -8.714  1.00 82.31           O  
ATOM    619  N   ARG A  75      32.877 -13.493  -6.593  1.00 80.64           N  
ATOM    620  CA  ARG A  75      31.433 -13.325  -6.603  1.00 79.50           C  
ATOM    621  C   ARG A  75      31.016 -12.217  -5.644  1.00 78.42           C  
ATOM    622  O   ARG A  75      31.560 -12.094  -4.545  1.00 77.27           O  
ATOM    623  CB  ARG A  75      30.755 -14.637  -6.208  1.00 80.76           C  
ATOM    624  N   ARG A  76      30.052 -11.409  -6.072  1.00 77.06           N  
ATOM    625  CA  ARG A  76      29.545 -10.324  -5.249  1.00 76.24           C  
ATOM    626  C   ARG A  76      28.702 -10.915  -4.129  1.00 74.22           C  
ATOM    627  O   ARG A  76      27.830 -11.746  -4.370  1.00 74.29           O  
ATOM    628  CB  ARG A  76      28.703  -9.374  -6.097  1.00 78.21           C  
ATOM    629  CG  ARG A  76      29.492  -8.707  -7.209  1.00 81.95           C  
ATOM    630  CD  ARG A  76      28.629  -7.765  -8.028  1.00 84.03           C  
ATOM    631  NE  ARG A  76      29.408  -7.064  -9.045  1.00 85.99           N  
ATOM    632  CZ  ARG A  76      28.894  -6.207  -9.922  1.00 87.06           C  
ATOM    633  NH1 ARG A  76      27.593  -5.939  -9.911  1.00 87.29           N  
ATOM    634  NH2 ARG A  76      29.678  -5.615 -10.811  1.00 88.00           N  
ATOM    635  N   GLU A  77      28.969 -10.492  -2.900  1.00 71.29           N  
ATOM    636  CA  GLU A  77      28.232 -11.000  -1.754  1.00 68.24           C  
ATOM    637  C   GLU A  77      27.614  -9.863  -0.963  1.00 65.08           C  
ATOM    638  O   GLU A  77      27.941  -8.695  -1.169  1.00 63.74           O  
ATOM    639  CB  GLU A  77      29.166 -11.804  -0.853  1.00 69.69           C  
ATOM    640  CG  GLU A  77      29.880 -12.935  -1.573  1.00 72.92           C  
ATOM    641  CD  GLU A  77      29.098 -14.234  -1.551  1.00 74.87           C  
ATOM    642  OE1 GLU A  77      29.085 -14.896  -0.489  1.00 75.64           O  
ATOM    643  OE2 GLU A  77      28.494 -14.589  -2.588  1.00 76.30           O  
ATOM    644  N   ARG A  78      26.709 -10.211  -0.061  1.00 61.23           N  
ATOM    645  CA  ARG A  78      26.056  -9.218   0.770  1.00 58.37           C  
ATOM    646  C   ARG A  78      26.053  -9.648   2.229  1.00 56.08           C  
ATOM    647  O   ARG A  78      25.454 -10.658   2.581  1.00 56.35           O  
ATOM    648  CB  ARG A  78      24.622  -8.978   0.290  1.00 57.01           C  
ATOM    649  CG  ARG A  78      23.714  -8.395   1.358  1.00 57.18           C  
ATOM    650  CD  ARG A  78      22.498  -7.691   0.777  1.00 56.96           C  
ATOM    651  NE  ARG A  78      21.626  -7.197   1.841  1.00 57.10           N  
ATOM    652  CZ  ARG A  78      20.693  -6.261   1.684  1.00 56.01           C  
ATOM    653  NH1 ARG A  78      20.498  -5.703   0.497  1.00 57.11           N  
ATOM    654  NH2 ARG A  78      19.963  -5.870   2.722  1.00 55.03           N  
ATOM    655  N   ALA A  79      26.750  -8.888   3.065  1.00 53.35           N  
ATOM    656  CA  ALA A  79      26.806  -9.171   4.492  1.00 50.75           C  
ATOM    657  C   ALA A  79      25.969  -8.100   5.180  1.00 50.04           C  
ATOM    658  O   ALA A  79      26.371  -6.934   5.262  1.00 47.48           O  
ATOM    659  CB  ALA A  79      28.248  -9.121   4.992  1.00 51.14           C  
ATOM    660  N   ASP A  80      24.790  -8.494   5.651  1.00 47.71           N  
ATOM    661  CA  ASP A  80      23.887  -7.573   6.321  1.00 47.16           C  
ATOM    662  C   ASP A  80      24.343  -7.184   7.720  1.00 45.16           C  
ATOM    663  O   ASP A  80      24.886  -8.003   8.457  1.00 45.05           O  
ATOM    664  CB  ASP A  80      22.491  -8.187   6.394  1.00 49.33           C  
ATOM    665  CG  ASP A  80      21.746  -8.083   5.080  1.00 54.14           C  
ATOM    666  OD1 ASP A  80      20.999  -7.097   4.890  1.00 54.86           O  
ATOM    667  OD2 ASP A  80      21.918  -8.979   4.226  1.00 59.62           O  
ATOM    668  N   LEU A  81      24.142  -5.915   8.065  1.00 43.56           N  
ATOM    669  CA  LEU A  81      24.486  -5.426   9.392  1.00 42.01           C  
ATOM    670  C   LEU A  81      23.171  -5.032  10.065  1.00 40.90           C  
ATOM    671  O   LEU A  81      22.783  -3.870  10.041  1.00 39.74           O  
ATOM    672  CB  LEU A  81      25.415  -4.202   9.316  1.00 40.58           C  
ATOM    673  CG  LEU A  81      26.865  -4.404   8.845  1.00 40.34           C  
ATOM    674  CD1 LEU A  81      27.586  -3.065   8.807  1.00 38.42           C  
ATOM    675  CD2 LEU A  81      27.590  -5.355   9.768  1.00 35.43           C  
ATOM    676  N   LYS A  82      22.466  -6.006  10.634  1.00 42.30           N  
ATOM    677  CA  LYS A  82      21.211  -5.695  11.309  1.00 44.61           C  
ATOM    678  C   LYS A  82      21.532  -4.990  12.617  1.00 43.08           C  
ATOM    679  O   LYS A  82      22.542  -5.281  13.257  1.00 41.31           O  
ATOM    680  CB  LYS A  82      20.404  -6.965  11.600  1.00 46.87           C  
ATOM    681  CG  LYS A  82      19.392  -7.366  10.516  1.00 52.39           C  
ATOM    682  CD  LYS A  82      20.064  -7.816   9.228  1.00 56.80           C  
ATOM    683  CE  LYS A  82      19.379  -9.053   8.624  1.00 59.68           C  
ATOM    684  NZ  LYS A  82      17.978  -8.820   8.163  1.00 60.41           N  
ATOM    685  N   GLU A  83      20.674  -4.058  13.011  1.00 44.18           N  
ATOM    686  CA  GLU A  83      20.893  -3.339  14.255  1.00 42.24           C  
ATOM    687  C   GLU A  83      21.238  -4.302  15.378  1.00 41.65           C  
ATOM    688  O   GLU A  83      20.493  -5.253  15.651  1.00 39.72           O  
ATOM    689  CB  GLU A  83      19.654  -2.548  14.638  1.00 43.40           C  
ATOM    690  CG  GLU A  83      19.772  -1.939  16.004  1.00 45.60           C  
ATOM    691  CD  GLU A  83      18.525  -1.217  16.412  1.00 48.28           C  
ATOM    692  OE1 GLU A  83      18.294  -0.107  15.889  1.00 49.15           O  
ATOM    693  OE2 GLU A  83      17.775  -1.773  17.249  1.00 50.94           O  
ATOM    694  N   GLY A  84      22.376  -4.058  16.024  1.00 38.66           N  
ATOM    695  CA  GLY A  84      22.806  -4.912  17.113  1.00 37.86           C  
ATOM    696  C   GLY A  84      23.946  -5.833  16.721  1.00 37.53           C  
ATOM    697  O   GLY A  84      24.596  -6.411  17.575  1.00 39.25           O  
ATOM    698  N   ASP A  85      24.186  -5.961  15.423  1.00 38.15           N  
ATOM    699  CA  ASP A  85      25.249  -6.820  14.909  1.00 38.84           C  
ATOM    700  C   ASP A  85      26.630  -6.190  15.044  1.00 36.76           C  
ATOM    701  O   ASP A  85      26.774  -4.975  14.945  1.00 36.26           O  
ATOM    702  CB  ASP A  85      25.038  -7.107  13.410  1.00 40.44           C  
ATOM    703  CG  ASP A  85      23.884  -8.065  13.131  1.00 39.34           C  
ATOM    704  OD1 ASP A  85      23.486  -8.165  11.946  1.00 43.34           O  
ATOM    705  OD2 ASP A  85      23.387  -8.724  14.062  1.00 39.96           O  
ATOM    706  N   ILE A  86      27.629  -7.030  15.287  1.00 36.21           N  
ATOM    707  CA  ILE A  86      29.024  -6.604  15.330  1.00 37.90           C  
ATOM    708  C   ILE A  86      29.671  -7.464  14.245  1.00 39.20           C  
ATOM    709  O   ILE A  86      29.139  -8.522  13.893  1.00 39.36           O  
ATOM    710  CB  ILE A  86      29.729  -6.870  16.678  1.00 37.51           C  
ATOM    711  CG1 ILE A  86      29.389  -8.261  17.200  1.00 38.31           C  
ATOM    712  CG2 ILE A  86      29.369  -5.784  17.673  1.00 39.55           C  
ATOM    713  CD1 ILE A  86      30.346  -8.705  18.289  1.00 41.77           C  
ATOM    714  N   PHE A  87      30.810  -7.028  13.724  1.00 38.12           N  
ATOM    715  CA  PHE A  87      31.469  -7.746  12.642  1.00 38.96           C  
ATOM    716  C   PHE A  87      32.908  -7.263  12.518  1.00 40.97           C  
ATOM    717  O   PHE A  87      33.176  -6.064  12.639  1.00 40.99           O  
ATOM    718  CB  PHE A  87      30.692  -7.456  11.346  1.00 37.79           C  
ATOM    719  CG  PHE A  87      31.333  -7.981  10.091  1.00 37.55           C  
ATOM    720  CD1 PHE A  87      31.549  -9.343   9.911  1.00 35.72           C  
ATOM    721  CD2 PHE A  87      31.654  -7.107   9.051  1.00 37.10           C  
ATOM    722  CE1 PHE A  87      32.071  -9.831   8.714  1.00 39.96           C  
ATOM    723  CE2 PHE A  87      32.179  -7.582   7.845  1.00 39.13           C  
ATOM    724  CZ  PHE A  87      32.387  -8.944   7.674  1.00 40.41           C  
ATOM    725  N   LEU A  88      33.834  -8.197  12.303  1.00 40.48           N  
ATOM    726  CA  LEU A  88      35.240  -7.856  12.129  1.00 40.28           C  
ATOM    727  C   LEU A  88      35.592  -8.263  10.697  1.00 42.54           C  
ATOM    728  O   LEU A  88      35.459  -9.426  10.324  1.00 42.68           O  
ATOM    729  CB  LEU A  88      36.107  -8.618  13.135  1.00 39.27           C  
ATOM    730  CG  LEU A  88      37.596  -8.240  13.140  1.00 41.16           C  
ATOM    731  CD1 LEU A  88      37.766  -6.777  13.517  1.00 40.62           C  
ATOM    732  CD2 LEU A  88      38.345  -9.132  14.115  1.00 41.10           C  
ATOM    733  N   LEU A  89      36.025  -7.303   9.886  1.00 41.96           N  
ATOM    734  CA  LEU A  89      36.353  -7.575   8.491  1.00 39.90           C  
ATOM    735  C   LEU A  89      37.838  -7.865   8.305  1.00 39.92           C  
ATOM    736  O   LEU A  89      38.681  -7.072   8.708  1.00 38.07           O  
ATOM    737  CB  LEU A  89      35.949  -6.376   7.634  1.00 38.45           C  
ATOM    738  CG  LEU A  89      36.128  -6.411   6.111  1.00 40.75           C  
ATOM    739  CD1 LEU A  89      35.264  -7.500   5.482  1.00 38.74           C  
ATOM    740  CD2 LEU A  89      35.731  -5.057   5.553  1.00 39.42           C  
ATOM    741  N   PRO A  90      38.178  -9.011   7.690  1.00 37.79           N  
ATOM    742  CA  PRO A  90      39.595  -9.323   7.490  1.00 38.39           C  
ATOM    743  C   PRO A  90      40.199  -8.246   6.586  1.00 38.16           C  
ATOM    744  O   PRO A  90      39.494  -7.617   5.795  1.00 36.32           O  
ATOM    745  CB  PRO A  90      39.568 -10.688   6.796  1.00 37.36           C  
ATOM    746  CG  PRO A  90      38.208 -11.233   7.104  1.00 38.57           C  
ATOM    747  CD  PRO A  90      37.332 -10.016   7.029  1.00 38.95           C  
ATOM    748  N   PRO A  91      41.516  -8.035   6.675  1.00 39.78           N  
ATOM    749  CA  PRO A  91      42.136  -7.011   5.827  1.00 41.42           C  
ATOM    750  C   PRO A  91      41.955  -7.330   4.343  1.00 42.61           C  
ATOM    751  O   PRO A  91      41.932  -8.498   3.953  1.00 43.27           O  
ATOM    752  CB  PRO A  91      43.612  -7.066   6.233  1.00 41.88           C  
ATOM    753  CG  PRO A  91      43.596  -7.718   7.604  1.00 41.61           C  
ATOM    754  CD  PRO A  91      42.528  -8.765   7.453  1.00 39.64           C  
ATOM    755  N   HIS A  92      41.806  -6.293   3.527  1.00 42.17           N  
ATOM    756  CA  HIS A  92      41.681  -6.450   2.079  1.00 43.75           C  
ATOM    757  C   HIS A  92      40.390  -7.010   1.488  1.00 43.37           C  
ATOM    758  O   HIS A  92      40.261  -7.061   0.267  1.00 44.41           O  
ATOM    759  CB  HIS A  92      42.868  -7.263   1.539  1.00 43.01           C  
ATOM    760  CG  HIS A  92      44.194  -6.591   1.735  1.00 43.35           C  
ATOM    761  ND1 HIS A  92      44.498  -5.368   1.176  1.00 44.85           N  
ATOM    762  CD2 HIS A  92      45.286  -6.962   2.445  1.00 42.23           C  
ATOM    763  CE1 HIS A  92      45.720  -5.015   1.533  1.00 44.85           C  
ATOM    764  NE2 HIS A  92      46.221  -5.965   2.302  1.00 45.30           N  
ATOM    765  N   VAL A  93      39.434  -7.435   2.308  1.00 42.70           N  
ATOM    766  CA  VAL A  93      38.191  -7.925   1.722  1.00 40.14           C  
ATOM    767  C   VAL A  93      37.471  -6.701   1.170  1.00 40.31           C  
ATOM    768  O   VAL A  93      37.200  -5.747   1.902  1.00 40.69           O  
ATOM    769  CB  VAL A  93      37.282  -8.639   2.742  1.00 38.63           C  
ATOM    770  CG1 VAL A  93      35.970  -9.017   2.075  1.00 38.18           C  
ATOM    771  CG2 VAL A  93      37.960  -9.884   3.255  1.00 37.23           C  
ATOM    772  N   ARG A  94      37.172  -6.732  -0.126  1.00 38.76           N  
ATOM    773  CA  ARG A  94      36.519  -5.615  -0.790  1.00 40.90           C  
ATOM    774  C   ARG A  94      35.095  -5.423  -0.274  1.00 42.26           C  
ATOM    775  O   ARG A  94      34.304  -6.368  -0.214  1.00 41.62           O  
ATOM    776  CB  ARG A  94      36.535  -5.841  -2.303  1.00 42.39           C  
ATOM    777  CG  ARG A  94      37.927  -6.224  -2.861  1.00 43.56           C  
ATOM    778  CD  ARG A  94      38.962  -5.133  -2.657  1.00 45.88           C  
ATOM    779  NE  ARG A  94      40.099  -5.249  -3.578  1.00 50.02           N  
ATOM    780  CZ  ARG A  94      41.169  -6.023  -3.395  1.00 49.02           C  
ATOM    781  NH1 ARG A  94      41.289  -6.779  -2.310  1.00 49.03           N  
ATOM    782  NH2 ARG A  94      42.136  -6.036  -4.305  1.00 49.04           N  
ATOM    783  N   HIS A  95      34.772  -4.189   0.094  1.00 39.71           N  
ATOM    784  CA  HIS A  95      33.461  -3.902   0.651  1.00 39.54           C  
ATOM    785  C   HIS A  95      32.965  -2.522   0.289  1.00 39.67           C  
ATOM    786  O   HIS A  95      33.733  -1.559   0.258  1.00 38.99           O  
ATOM    787  CB  HIS A  95      33.501  -4.039   2.178  1.00 35.70           C  
ATOM    788  CG  HIS A  95      34.550  -3.189   2.825  1.00 38.36           C  
ATOM    789  ND1 HIS A  95      35.894  -3.492   2.764  1.00 38.13           N  
ATOM    790  CD2 HIS A  95      34.460  -2.016   3.493  1.00 34.61           C  
ATOM    791  CE1 HIS A  95      36.586  -2.542   3.368  1.00 37.26           C  
ATOM    792  NE2 HIS A  95      35.739  -1.636   3.818  1.00 37.41           N  
ATOM    793  N   SER A  96      31.659  -2.441   0.042  1.00 38.91           N  
ATOM    794  CA  SER A  96      30.992  -1.199  -0.315  1.00 38.64           C  
ATOM    795  C   SER A  96      29.828  -1.036   0.668  1.00 40.73           C  
ATOM    796  O   SER A  96      28.773  -1.649   0.495  1.00 41.76           O  
ATOM    797  CB  SER A  96      30.475  -1.300  -1.752  1.00 35.12           C  
ATOM    798  OG  SER A  96      29.944  -0.066  -2.204  1.00 34.57           O  
ATOM    799  N   PRO A  97      30.003  -0.204   1.711  1.00 41.53           N  
ATOM    800  CA  PRO A  97      28.948   0.006   2.711  1.00 41.65           C  
ATOM    801  C   PRO A  97      27.705   0.698   2.176  1.00 39.38           C  
ATOM    802  O   PRO A  97      27.783   1.778   1.600  1.00 42.04           O  
ATOM    803  CB  PRO A  97      29.643   0.837   3.797  1.00 41.88           C  
ATOM    804  CG  PRO A  97      31.128   0.583   3.562  1.00 44.53           C  
ATOM    805  CD  PRO A  97      31.203   0.575   2.056  1.00 43.24           C  
ATOM    806  N   GLN A  98      26.559   0.065   2.373  1.00 38.27           N  
ATOM    807  CA  GLN A  98      25.290   0.620   1.924  1.00 36.54           C  
ATOM    808  C   GLN A  98      24.487   0.927   3.178  1.00 36.58           C  
ATOM    809  O   GLN A  98      24.120   0.034   3.936  1.00 37.32           O  
ATOM    810  CB  GLN A  98      24.559  -0.389   1.034  1.00 39.97           C  
ATOM    811  CG  GLN A  98      25.351  -0.799  -0.209  1.00 37.65           C  
ATOM    812  CD  GLN A  98      25.782   0.395  -1.048  1.00 37.61           C  
ATOM    813  OE1 GLN A  98      25.009   1.317  -1.269  1.00 38.85           O  
ATOM    814  NE2 GLN A  98      27.016   0.369  -1.533  1.00 38.88           N  
ATOM    815  N   ARG A  99      24.236   2.205   3.399  1.00 37.65           N  
ATOM    816  CA  ARG A  99      23.522   2.642   4.584  1.00 40.52           C  
ATOM    817  C   ARG A  99      22.362   3.498   4.122  1.00 41.00           C  
ATOM    818  O   ARG A  99      22.446   4.718   4.089  1.00 40.67           O  
ATOM    819  CB  ARG A  99      24.491   3.417   5.482  1.00 38.35           C  
ATOM    820  CG  ARG A  99      25.744   2.583   5.821  1.00 37.83           C  
ATOM    821  CD  ARG A  99      26.752   3.308   6.728  1.00 37.61           C  
ATOM    822  NE  ARG A  99      27.842   2.414   7.134  1.00 35.34           N  
ATOM    823  CZ  ARG A  99      27.722   1.441   8.035  1.00 34.14           C  
ATOM    824  NH1 ARG A  99      26.558   1.229   8.643  1.00 33.74           N  
ATOM    825  NH2 ARG A  99      28.755   0.661   8.314  1.00 34.43           N  
ATOM    826  N   PRO A 100      21.249   2.849   3.758  1.00 43.32           N  
ATOM    827  CA  PRO A 100      20.041   3.514   3.269  1.00 44.54           C  
ATOM    828  C   PRO A 100      19.128   4.238   4.258  1.00 46.75           C  
ATOM    829  O   PRO A 100      18.405   5.148   3.858  1.00 47.62           O  
ATOM    830  CB  PRO A 100      19.312   2.386   2.550  1.00 43.87           C  
ATOM    831  CG  PRO A 100      19.610   1.211   3.412  1.00 42.22           C  
ATOM    832  CD  PRO A 100      21.084   1.382   3.739  1.00 42.95           C  
ATOM    833  N   GLU A 101      19.143   3.871   5.534  1.00 47.55           N  
ATOM    834  CA  GLU A 101      18.226   4.550   6.440  1.00 49.49           C  
ATOM    835  C   GLU A 101      18.719   5.726   7.277  1.00 48.53           C  
ATOM    836  O   GLU A 101      19.763   5.672   7.917  1.00 49.91           O  
ATOM    837  CB  GLU A 101      17.508   3.526   7.334  1.00 49.99           C  
ATOM    838  CG  GLU A 101      18.361   2.465   7.989  1.00 52.78           C  
ATOM    839  CD  GLU A 101      17.510   1.323   8.543  1.00 55.08           C  
ATOM    840  OE1 GLU A 101      17.130   0.420   7.765  1.00 56.47           O  
ATOM    841  OE2 GLU A 101      17.205   1.331   9.752  1.00 56.05           O  
ATOM    842  N   ALA A 102      17.937   6.801   7.242  1.00 47.47           N  
ATOM    843  CA  ALA A 102      18.231   8.015   7.993  1.00 46.33           C  
ATOM    844  C   ALA A 102      18.159   7.687   9.473  1.00 45.05           C  
ATOM    845  O   ALA A 102      17.434   6.780   9.869  1.00 46.44           O  
ATOM    846  CB  ALA A 102      17.222   9.087   7.652  1.00 46.02           C  
ATOM    847  N   GLY A 103      18.913   8.416  10.289  1.00 45.36           N  
ATOM    848  CA  GLY A 103      18.903   8.159  11.719  1.00 44.31           C  
ATOM    849  C   GLY A 103      19.638   6.882  12.073  1.00 44.67           C  
ATOM    850  O   GLY A 103      19.594   6.418  13.210  1.00 45.27           O  
ATOM    851  N   SER A 104      20.313   6.311  11.083  1.00 43.47           N  
ATOM    852  CA  SER A 104      21.072   5.086  11.272  1.00 43.63           C  
ATOM    853  C   SER A 104      22.421   5.450  11.903  1.00 42.26           C  
ATOM    854  O   SER A 104      22.882   6.586  11.772  1.00 43.23           O  
ATOM    855  CB  SER A 104      21.304   4.421   9.909  1.00 44.17           C  
ATOM    856  OG  SER A 104      21.564   3.044  10.066  1.00 50.34           O  
ATOM    857  N   ALA A 105      23.056   4.492  12.572  1.00 41.46           N  
ATOM    858  CA  ALA A 105      24.354   4.742  13.196  1.00 40.36           C  
ATOM    859  C   ALA A 105      25.130   3.459  13.451  1.00 39.00           C  
ATOM    860  O   ALA A 105      24.665   2.559  14.147  1.00 39.06           O  
ATOM    861  CB  ALA A 105      24.171   5.501  14.497  1.00 40.22           C  
ATOM    862  N   CYS A 106      26.329   3.386  12.884  1.00 38.64           N  
ATOM    863  CA  CYS A 106      27.174   2.218  13.049  1.00 37.19           C  
ATOM    864  C   CYS A 106      28.545   2.648  13.529  1.00 39.10           C  
ATOM    865  O   CYS A 106      29.165   3.536  12.945  1.00 40.92           O  
ATOM    866  CB  CYS A 106      27.324   1.476  11.719  1.00 37.06           C  
ATOM    867  SG  CYS A 106      28.392   0.018  11.784  1.00 36.98           S  
ATOM    868  N   LEU A 107      29.007   2.029  14.608  1.00 38.05           N  
ATOM    869  CA  LEU A 107      30.328   2.320  15.139  1.00 35.63           C  
ATOM    870  C   LEU A 107      31.333   1.590  14.241  1.00 36.44           C  
ATOM    871  O   LEU A 107      31.246   0.374  14.072  1.00 34.93           O  
ATOM    872  CB  LEU A 107      30.446   1.796  16.571  1.00 35.94           C  
ATOM    873  CG  LEU A 107      31.846   1.756  17.191  1.00 36.70           C  
ATOM    874  CD1 LEU A 107      32.384   3.175  17.362  1.00 34.54           C  
ATOM    875  CD2 LEU A 107      31.786   1.032  18.523  1.00 36.98           C  
ATOM    876  N   VAL A 108      32.263   2.332  13.647  1.00 34.84           N  
ATOM    877  CA  VAL A 108      33.274   1.729  12.788  1.00 36.40           C  
ATOM    878  C   VAL A 108      34.647   2.124  13.334  1.00 37.51           C  
ATOM    879  O   VAL A 108      34.970   3.310  13.436  1.00 38.35           O  
ATOM    880  CB  VAL A 108      33.157   2.209  11.313  1.00 38.71           C  
ATOM    881  CG1 VAL A 108      34.298   1.627  10.500  1.00 37.92           C  
ATOM    882  CG2 VAL A 108      31.809   1.790  10.708  1.00 38.04           C  
ATOM    883  N   ILE A 109      35.438   1.126  13.708  1.00 36.10           N  
ATOM    884  CA  ILE A 109      36.769   1.366  14.243  1.00 36.18           C  
ATOM    885  C   ILE A 109      37.809   0.760  13.312  1.00 38.04           C  
ATOM    886  O   ILE A 109      37.686  -0.395  12.897  1.00 38.34           O  
ATOM    887  CB  ILE A 109      36.904   0.745  15.638  1.00 35.06           C  
ATOM    888  CG1 ILE A 109      35.929   1.441  16.588  1.00 33.19           C  
ATOM    889  CG2 ILE A 109      38.342   0.825  16.123  1.00 30.81           C  
ATOM    890  CD1 ILE A 109      35.861   0.811  17.954  1.00 35.80           C  
ATOM    891  N   GLU A 110      38.817   1.558  12.972  1.00 37.57           N  
ATOM    892  CA  GLU A 110      39.897   1.129  12.092  1.00 38.13           C  
ATOM    893  C   GLU A 110      41.210   1.593  12.733  1.00 41.00           C  
ATOM    894  O   GLU A 110      41.197   2.130  13.845  1.00 37.71           O  
ATOM    895  CB  GLU A 110      39.733   1.761  10.697  1.00 37.34           C  
ATOM    896  CG  GLU A 110      38.292   1.799  10.195  1.00 38.50           C  
ATOM    897  CD  GLU A 110      38.172   2.063   8.697  1.00 42.17           C  
ATOM    898  OE1 GLU A 110      39.138   2.588   8.093  1.00 37.67           O  
ATOM    899  OE2 GLU A 110      37.092   1.750   8.126  1.00 42.14           O  
ATOM    900  N   ARG A 111      42.326   1.390  12.031  1.00 40.27           N  
ATOM    901  CA  ARG A 111      43.653   1.783  12.522  1.00 44.15           C  
ATOM    902  C   ARG A 111      44.319   2.789  11.592  1.00 43.44           C  
ATOM    903  O   ARG A 111      44.038   2.817  10.395  1.00 43.92           O  
ATOM    904  CB  ARG A 111      44.597   0.571  12.606  1.00 42.52           C  
ATOM    905  CG  ARG A 111      44.452  -0.350  13.804  1.00 46.87           C  
ATOM    906  CD  ARG A 111      45.481  -1.489  13.709  1.00 44.52           C  
ATOM    907  NE  ARG A 111      46.817  -0.940  13.502  1.00 43.33           N  
ATOM    908  CZ  ARG A 111      47.873  -1.628  13.080  1.00 43.02           C  
ATOM    909  NH1 ARG A 111      47.776  -2.919  12.809  1.00 40.78           N  
ATOM    910  NH2 ARG A 111      49.034  -1.010  12.920  1.00 45.56           N  
ATOM    911  N   GLN A 112      45.210   3.603  12.150  1.00 45.31           N  
ATOM    912  CA  GLN A 112      45.980   4.564  11.360  1.00 45.86           C  
ATOM    913  C   GLN A 112      46.901   3.702  10.508  1.00 44.09           C  
ATOM    914  O   GLN A 112      47.578   2.825  11.037  1.00 45.77           O  
ATOM    915  CB  GLN A 112      46.852   5.439  12.261  1.00 48.32           C  
ATOM    916  CG  GLN A 112      46.131   6.559  12.960  1.00 56.32           C  
ATOM    917  CD  GLN A 112      46.307   7.880  12.245  1.00 59.75           C  
ATOM    918  OE1 GLN A 112      45.946   8.020  11.074  1.00 62.91           O  
ATOM    919  NE2 GLN A 112      46.871   8.859  12.946  1.00 62.12           N  
ATOM    920  N   ARG A 113      46.934   3.937   9.204  1.00 45.41           N  
ATOM    921  CA  ARG A 113      47.797   3.143   8.340  1.00 48.02           C  
ATOM    922  C   ARG A 113      49.245   3.621   8.374  1.00 49.83           C  
ATOM    923  O   ARG A 113      49.519   4.813   8.235  1.00 49.86           O  
ATOM    924  CB  ARG A 113      47.306   3.177   6.890  1.00 47.12           C  
ATOM    925  CG  ARG A 113      46.050   2.372   6.599  1.00 44.56           C  
ATOM    926  CD  ARG A 113      44.851   2.948   7.297  1.00 42.27           C  
ATOM    927  NE  ARG A 113      43.629   2.749   6.524  1.00 38.41           N  
ATOM    928  CZ  ARG A 113      42.400   2.800   7.032  1.00 38.77           C  
ATOM    929  NH1 ARG A 113      42.216   3.037   8.330  1.00 31.56           N  
ATOM    930  NH2 ARG A 113      41.353   2.628   6.232  1.00 39.46           N  
ATOM    931  N   PRO A 114      50.190   2.690   8.570  1.00 50.95           N  
ATOM    932  CA  PRO A 114      51.618   3.009   8.615  1.00 52.17           C  
ATOM    933  C   PRO A 114      52.059   3.507   7.236  1.00 53.04           C  
ATOM    934  O   PRO A 114      51.442   3.161   6.227  1.00 52.62           O  
ATOM    935  CB  PRO A 114      52.263   1.668   8.953  1.00 52.68           C  
ATOM    936  CG  PRO A 114      51.202   0.960   9.727  1.00 53.14           C  
ATOM    937  CD  PRO A 114      49.961   1.283   8.938  1.00 52.28           C  
ATOM    938  N   ALA A 115      53.114   4.317   7.198  1.00 53.00           N  
ATOM    939  CA  ALA A 115      53.631   4.839   5.935  1.00 53.13           C  
ATOM    940  C   ALA A 115      53.941   3.669   5.006  1.00 52.43           C  
ATOM    941  O   ALA A 115      54.546   2.690   5.423  1.00 52.54           O  
ATOM    942  CB  ALA A 115      54.893   5.652   6.186  1.00 51.95           C  
ATOM    943  N   GLY A 116      53.511   3.762   3.754  1.00 52.72           N  
ATOM    944  CA  GLY A 116      53.783   2.685   2.816  1.00 54.06           C  
ATOM    945  C   GLY A 116      52.634   1.705   2.673  1.00 54.31           C  
ATOM    946  O   GLY A 116      52.558   0.948   1.703  1.00 54.28           O  
ATOM    947  N   MET A 117      51.740   1.706   3.652  1.00 53.67           N  
ATOM    948  CA  MET A 117      50.586   0.826   3.612  1.00 52.47           C  
ATOM    949  C   MET A 117      49.455   1.655   3.031  1.00 49.79           C  
ATOM    950  O   MET A 117      48.906   2.536   3.693  1.00 50.13           O  
ATOM    951  CB  MET A 117      50.236   0.357   5.018  1.00 55.83           C  
ATOM    952  CG  MET A 117      49.232  -0.765   5.050  1.00 57.59           C  
ATOM    953  SD  MET A 117      49.039  -1.337   6.731  1.00 64.38           S  
ATOM    954  CE  MET A 117      50.677  -2.010   7.037  1.00 58.38           C  
ATOM    955  N   LEU A 118      49.111   1.377   1.784  1.00 46.74           N  
ATOM    956  CA  LEU A 118      48.078   2.153   1.133  1.00 45.96           C  
ATOM    957  C   LEU A 118      46.719   1.478   1.102  1.00 45.23           C  
ATOM    958  O   LEU A 118      46.606   0.254   1.194  1.00 43.95           O  
ATOM    959  CB  LEU A 118      48.506   2.486  -0.303  1.00 45.97           C  
ATOM    960  CG  LEU A 118      49.961   2.924  -0.508  1.00 46.70           C  
ATOM    961  CD1 LEU A 118      50.149   3.383  -1.946  1.00 48.33           C  
ATOM    962  CD2 LEU A 118      50.311   4.051   0.456  1.00 46.16           C  
ATOM    963  N   ASP A 119      45.699   2.319   0.975  1.00 45.03           N  
ATOM    964  CA  ASP A 119      44.311   1.906   0.881  1.00 44.33           C  
ATOM    965  C   ASP A 119      43.932   1.935  -0.584  1.00 44.11           C  
ATOM    966  O   ASP A 119      44.467   2.733  -1.358  1.00 44.41           O  
ATOM    967  CB  ASP A 119      43.412   2.887   1.630  1.00 44.99           C  
ATOM    968  CG  ASP A 119      43.354   2.603   3.105  1.00 45.51           C  
ATOM    969  OD1 ASP A 119      42.318   2.079   3.557  1.00 48.09           O  
ATOM    970  OD2 ASP A 119      44.343   2.889   3.808  1.00 44.72           O  
ATOM    971  N   GLY A 120      43.012   1.061  -0.963  1.00 42.70           N  
ATOM    972  CA  GLY A 120      42.564   1.032  -2.332  1.00 41.78           C  
ATOM    973  C   GLY A 120      41.073   1.283  -2.382  1.00 42.01           C  
ATOM    974  O   GLY A 120      40.340   0.924  -1.463  1.00 40.35           O  
ATOM    975  N   PHE A 121      40.637   1.927  -3.453  1.00 42.48           N  
ATOM    976  CA  PHE A 121      39.237   2.215  -3.687  1.00 44.43           C  
ATOM    977  C   PHE A 121      38.993   1.726  -5.098  1.00 46.38           C  
ATOM    978  O   PHE A 121      39.678   2.137  -6.036  1.00 46.93           O  
ATOM    979  CB  PHE A 121      38.984   3.707  -3.530  1.00 43.14           C  
ATOM    980  CG  PHE A 121      39.082   4.162  -2.108  1.00 46.94           C  
ATOM    981  CD1 PHE A 121      37.988   4.048  -1.253  1.00 46.13           C  
ATOM    982  CD2 PHE A 121      40.290   4.619  -1.591  1.00 44.48           C  
ATOM    983  CE1 PHE A 121      38.098   4.375   0.097  1.00 46.31           C  
ATOM    984  CE2 PHE A 121      40.409   4.947  -0.245  1.00 45.30           C  
ATOM    985  CZ  PHE A 121      39.312   4.823   0.601  1.00 46.82           C  
ATOM    986  N   GLU A 122      38.027   0.822  -5.237  1.00 48.34           N  
ATOM    987  CA  GLU A 122      37.733   0.224  -6.527  1.00 49.52           C  
ATOM    988  C   GLU A 122      36.286   0.258  -6.990  1.00 51.10           C  
ATOM    989  O   GLU A 122      35.350   0.389  -6.193  1.00 51.00           O  
ATOM    990  CB  GLU A 122      38.198  -1.232  -6.516  1.00 48.85           C  
ATOM    991  CG  GLU A 122      39.668  -1.407  -6.227  1.00 45.30           C  
ATOM    992  CD  GLU A 122      40.042  -2.856  -5.996  1.00 44.17           C  
ATOM    993  OE1 GLU A 122      41.228  -3.199  -6.163  1.00 47.87           O  
ATOM    994  OE2 GLU A 122      39.164  -3.656  -5.634  1.00 43.38           O  
ATOM    995  N   TRP A 123      36.132   0.121  -8.304  1.00 51.21           N  
ATOM    996  CA  TRP A 123      34.836   0.076  -8.968  1.00 49.65           C  
ATOM    997  C   TRP A 123      34.897  -1.091  -9.935  1.00 50.55           C  
ATOM    998  O   TRP A 123      35.917  -1.303 -10.595  1.00 50.05           O  
ATOM    999  CB  TRP A 123      34.572   1.360  -9.739  1.00 47.47           C  
ATOM   1000  CG  TRP A 123      34.200   2.494  -8.872  1.00 45.03           C  
ATOM   1001  CD1 TRP A 123      32.946   2.838  -8.466  1.00 43.12           C  
ATOM   1002  CD2 TRP A 123      35.092   3.433  -8.271  1.00 44.32           C  
ATOM   1003  NE1 TRP A 123      32.999   3.941  -7.645  1.00 44.71           N  
ATOM   1004  CE2 TRP A 123      34.308   4.325  -7.509  1.00 44.73           C  
ATOM   1005  CE3 TRP A 123      36.480   3.606  -8.300  1.00 45.03           C  
ATOM   1006  CZ2 TRP A 123      34.867   5.378  -6.783  1.00 43.45           C  
ATOM   1007  CZ3 TRP A 123      37.036   4.659  -7.573  1.00 42.86           C  
ATOM   1008  CH2 TRP A 123      36.229   5.528  -6.828  1.00 43.22           C  
ATOM   1009  N   TYR A 124      33.808  -1.850 -10.004  1.00 51.78           N  
ATOM   1010  CA  TYR A 124      33.714  -3.009 -10.884  1.00 51.08           C  
ATOM   1011  C   TYR A 124      32.576  -2.804 -11.868  1.00 52.70           C  
ATOM   1012  O   TYR A 124      31.656  -2.022 -11.605  1.00 51.92           O  
ATOM   1013  CB  TYR A 124      33.467  -4.265 -10.056  1.00 51.24           C  
ATOM   1014  CG  TYR A 124      34.643  -4.643  -9.197  1.00 51.30           C  
ATOM   1015  CD1 TYR A 124      35.603  -5.546  -9.652  1.00 50.96           C  
ATOM   1016  CD2 TYR A 124      34.819  -4.069  -7.941  1.00 50.32           C  
ATOM   1017  CE1 TYR A 124      36.708  -5.869  -8.876  1.00 50.27           C  
ATOM   1018  CE2 TYR A 124      35.917  -4.382  -7.161  1.00 51.20           C  
ATOM   1019  CZ  TYR A 124      36.855  -5.283  -7.632  1.00 51.68           C  
ATOM   1020  OH  TYR A 124      37.931  -5.606  -6.845  1.00 52.37           O  
ATOM   1021  N   CYS A 125      32.631  -3.512 -12.993  1.00 54.42           N  
ATOM   1022  CA  CYS A 125      31.602  -3.379 -14.020  1.00 56.46           C  
ATOM   1023  C   CYS A 125      30.329  -4.181 -13.759  1.00 57.60           C  
ATOM   1024  O   CYS A 125      30.387  -5.342 -13.357  1.00 56.89           O  
ATOM   1025  CB  CYS A 125      32.166  -3.779 -15.383  1.00 56.24           C  
ATOM   1026  SG  CYS A 125      31.000  -3.532 -16.750  1.00 56.08           S  
ATOM   1027  N   ASP A 126      29.182  -3.547 -13.992  1.00 60.19           N  
ATOM   1028  CA  ASP A 126      27.886  -4.198 -13.817  1.00 63.53           C  
ATOM   1029  C   ASP A 126      27.777  -5.362 -14.792  1.00 64.26           C  
ATOM   1030  O   ASP A 126      27.252  -6.423 -14.457  1.00 65.02           O  
ATOM   1031  CB  ASP A 126      26.737  -3.230 -14.122  1.00 66.69           C  
ATOM   1032  CG  ASP A 126      26.151  -2.588 -12.878  1.00 71.03           C  
ATOM   1033  OD1 ASP A 126      25.962  -3.304 -11.868  1.00 72.37           O  
ATOM   1034  OD2 ASP A 126      25.861  -1.371 -12.922  1.00 72.78           O  
ATOM   1035  N   ALA A 127      28.279  -5.141 -16.002  1.00 64.42           N  
ATOM   1036  CA  ALA A 127      28.222  -6.134 -17.062  1.00 64.49           C  
ATOM   1037  C   ALA A 127      29.138  -7.338 -16.885  1.00 65.07           C  
ATOM   1038  O   ALA A 127      28.659  -8.439 -16.631  1.00 67.22           O  
ATOM   1039  CB  ALA A 127      28.494  -5.466 -18.404  1.00 64.16           C  
ATOM   1040  N   CYS A 128      30.446  -7.146 -17.020  1.00 64.63           N  
ATOM   1041  CA  CYS A 128      31.362  -8.275 -16.888  1.00 64.12           C  
ATOM   1042  C   CYS A 128      31.963  -8.458 -15.501  1.00 64.61           C  
ATOM   1043  O   CYS A 128      32.705  -9.409 -15.266  1.00 64.26           O  
ATOM   1044  CB  CYS A 128      32.486  -8.173 -17.927  1.00 64.15           C  
ATOM   1045  SG  CYS A 128      33.599  -6.759 -17.764  1.00 63.79           S  
ATOM   1046  N   GLY A 129      31.640  -7.553 -14.582  1.00 65.25           N  
ATOM   1047  CA  GLY A 129      32.171  -7.652 -13.231  1.00 64.32           C  
ATOM   1048  C   GLY A 129      33.671  -7.434 -13.149  1.00 63.62           C  
ATOM   1049  O   GLY A 129      34.273  -7.588 -12.090  1.00 64.40           O  
ATOM   1050  N   HIS A 130      34.280  -7.068 -14.270  1.00 62.38           N  
ATOM   1051  CA  HIS A 130      35.720  -6.837 -14.325  1.00 62.37           C  
ATOM   1052  C   HIS A 130      36.064  -5.550 -13.561  1.00 59.60           C  
ATOM   1053  O   HIS A 130      35.205  -4.689 -13.371  1.00 55.58           O  
ATOM   1054  CB  HIS A 130      36.141  -6.717 -15.798  1.00 65.51           C  
ATOM   1055  CG  HIS A 130      37.617  -6.821 -16.033  1.00 68.45           C  
ATOM   1056  ND1 HIS A 130      38.341  -7.958 -15.749  1.00 70.60           N  
ATOM   1057  CD2 HIS A 130      38.497  -5.942 -16.573  1.00 70.85           C  
ATOM   1058  CE1 HIS A 130      39.602  -7.777 -16.103  1.00 72.03           C  
ATOM   1059  NE2 HIS A 130      39.722  -6.563 -16.608  1.00 71.30           N  
ATOM   1060  N   LEU A 131      37.314  -5.433 -13.112  1.00 58.11           N  
ATOM   1061  CA  LEU A 131      37.755  -4.231 -12.404  1.00 56.20           C  
ATOM   1062  C   LEU A 131      37.780  -3.085 -13.416  1.00 55.77           C  
ATOM   1063  O   LEU A 131      38.393  -3.195 -14.475  1.00 55.12           O  
ATOM   1064  CB  LEU A 131      39.155  -4.436 -11.814  1.00 54.30           C  
ATOM   1065  CG  LEU A 131      39.833  -3.221 -11.173  1.00 54.64           C  
ATOM   1066  CD1 LEU A 131      38.987  -2.695 -10.025  1.00 54.27           C  
ATOM   1067  CD2 LEU A 131      41.219  -3.609 -10.672  1.00 51.85           C  
ATOM   1068  N   VAL A 132      37.106  -1.993 -13.087  1.00 55.18           N  
ATOM   1069  CA  VAL A 132      37.030  -0.843 -13.972  1.00 54.13           C  
ATOM   1070  C   VAL A 132      38.052   0.241 -13.648  1.00 54.09           C  
ATOM   1071  O   VAL A 132      38.636   0.841 -14.548  1.00 52.06           O  
ATOM   1072  CB  VAL A 132      35.626  -0.223 -13.916  1.00 55.25           C  
ATOM   1073  CG1 VAL A 132      35.602   1.093 -14.663  1.00 55.94           C  
ATOM   1074  CG2 VAL A 132      34.614  -1.190 -14.509  1.00 57.26           C  
ATOM   1075  N   HIS A 133      38.269   0.483 -12.361  1.00 53.08           N  
ATOM   1076  CA  HIS A 133      39.198   1.517 -11.933  1.00 51.71           C  
ATOM   1077  C   HIS A 133      39.618   1.302 -10.483  1.00 51.71           C  
ATOM   1078  O   HIS A 133      38.813   0.877  -9.651  1.00 51.35           O  
ATOM   1079  CB  HIS A 133      38.525   2.882 -12.087  1.00 51.35           C  
ATOM   1080  CG  HIS A 133      39.402   4.043 -11.732  1.00 53.32           C  
ATOM   1081  ND1 HIS A 133      40.605   4.286 -12.359  1.00 55.38           N  
ATOM   1082  CD2 HIS A 133      39.227   5.052 -10.846  1.00 53.78           C  
ATOM   1083  CE1 HIS A 133      41.134   5.398 -11.874  1.00 55.20           C  
ATOM   1084  NE2 HIS A 133      40.316   5.881 -10.955  1.00 54.87           N  
ATOM   1085  N   ARG A 134      40.881   1.589 -10.188  1.00 51.14           N  
ATOM   1086  CA  ARG A 134      41.405   1.444  -8.836  1.00 50.68           C  
ATOM   1087  C   ARG A 134      42.351   2.578  -8.489  1.00 51.33           C  
ATOM   1088  O   ARG A 134      43.249   2.903  -9.259  1.00 52.65           O  
ATOM   1089  CB  ARG A 134      42.148   0.116  -8.678  1.00 51.44           C  
ATOM   1090  CG  ARG A 134      42.868  -0.029  -7.334  1.00 51.82           C  
ATOM   1091  CD  ARG A 134      43.714  -1.293  -7.280  1.00 50.36           C  
ATOM   1092  NE  ARG A 134      44.524  -1.372  -6.065  1.00 50.04           N  
ATOM   1093  CZ  ARG A 134      44.054  -1.705  -4.866  1.00 50.13           C  
ATOM   1094  NH1 ARG A 134      42.772  -1.994  -4.707  1.00 49.66           N  
ATOM   1095  NH2 ARG A 134      44.868  -1.748  -3.822  1.00 50.06           N  
ATOM   1096  N   VAL A 135      42.135   3.188  -7.331  1.00 51.38           N  
ATOM   1097  CA  VAL A 135      42.996   4.263  -6.868  1.00 49.10           C  
ATOM   1098  C   VAL A 135      43.601   3.846  -5.538  1.00 50.12           C  
ATOM   1099  O   VAL A 135      42.883   3.427  -4.628  1.00 49.42           O  
ATOM   1100  CB  VAL A 135      42.220   5.562  -6.627  1.00 50.17           C  
ATOM   1101  CG1 VAL A 135      43.196   6.692  -6.341  1.00 48.31           C  
ATOM   1102  CG2 VAL A 135      41.346   5.889  -7.830  1.00 51.46           C  
ATOM   1103  N   GLU A 136      44.920   3.933  -5.429  1.00 48.66           N  
ATOM   1104  CA  GLU A 136      45.584   3.601  -4.183  1.00 49.82           C  
ATOM   1105  C   GLU A 136      45.980   4.928  -3.558  1.00 48.98           C  
ATOM   1106  O   GLU A 136      46.468   5.827  -4.249  1.00 47.77           O  
ATOM   1107  CB  GLU A 136      46.831   2.754  -4.420  1.00 51.97           C  
ATOM   1108  CG  GLU A 136      46.569   1.425  -5.081  1.00 55.39           C  
ATOM   1109  CD  GLU A 136      47.750   0.488  -4.950  1.00 56.62           C  
ATOM   1110  OE1 GLU A 136      48.889   0.989  -4.860  1.00 57.65           O  
ATOM   1111  OE2 GLU A 136      47.543  -0.745  -4.945  1.00 60.89           O  
ATOM   1112  N   VAL A 137      45.756   5.052  -2.256  1.00 47.80           N  
ATOM   1113  CA  VAL A 137      46.063   6.279  -1.538  1.00 48.67           C  
ATOM   1114  C   VAL A 137      46.583   6.005  -0.135  1.00 50.14           C  
ATOM   1115  O   VAL A 137      46.224   5.005   0.487  1.00 50.99           O  
ATOM   1116  CB  VAL A 137      44.813   7.167  -1.403  1.00 48.72           C  
ATOM   1117  CG1 VAL A 137      44.447   7.776  -2.731  1.00 49.97           C  
ATOM   1118  CG2 VAL A 137      43.650   6.333  -0.895  1.00 50.55           C  
ATOM   1119  N   GLN A 138      47.454   6.888   0.341  1.00 50.98           N  
ATOM   1120  CA  GLN A 138      47.996   6.795   1.688  1.00 52.23           C  
ATOM   1121  C   GLN A 138      46.889   7.539   2.413  1.00 53.25           C  
ATOM   1122  O   GLN A 138      46.817   8.768   2.368  1.00 53.24           O  
ATOM   1123  CB  GLN A 138      49.328   7.551   1.780  1.00 51.57           C  
ATOM   1124  CG  GLN A 138      50.043   7.487   3.136  1.00 53.25           C  
ATOM   1125  CD  GLN A 138      50.410   6.077   3.566  1.00 53.04           C  
ATOM   1126  OE1 GLN A 138      49.740   5.479   4.412  1.00 54.98           O  
ATOM   1127  NE2 GLN A 138      51.472   5.535   2.984  1.00 52.62           N  
ATOM   1128  N   LEU A 139      45.997   6.778   3.035  1.00 54.75           N  
ATOM   1129  CA  LEU A 139      44.849   7.348   3.722  1.00 56.46           C  
ATOM   1130  C   LEU A 139      45.264   8.116   4.958  1.00 56.88           C  
ATOM   1131  O   LEU A 139      45.883   7.565   5.861  1.00 58.22           O  
ATOM   1132  CB  LEU A 139      43.866   6.230   4.090  1.00 57.66           C  
ATOM   1133  CG  LEU A 139      42.381   6.599   4.157  1.00 58.84           C  
ATOM   1134  CD1 LEU A 139      41.933   7.217   2.839  1.00 58.17           C  
ATOM   1135  CD2 LEU A 139      41.572   5.350   4.457  1.00 58.65           C  
ATOM   1136  N   LYS A 140      44.921   9.396   4.988  1.00 58.07           N  
ATOM   1137  CA  LYS A 140      45.261  10.252   6.111  1.00 60.48           C  
ATOM   1138  C   LYS A 140      43.996  10.627   6.888  1.00 61.15           C  
ATOM   1139  O   LYS A 140      44.074  11.003   8.056  1.00 60.84           O  
ATOM   1140  CB  LYS A 140      45.971  11.508   5.597  1.00 62.62           C  
ATOM   1141  CG  LYS A 140      46.703  12.333   6.651  1.00 66.24           C  
ATOM   1142  CD  LYS A 140      47.444  13.507   5.989  1.00 68.76           C  
ATOM   1143  CE  LYS A 140      48.229  14.355   6.994  1.00 70.50           C  
ATOM   1144  NZ  LYS A 140      48.997  15.459   6.328  1.00 69.47           N  
ATOM   1145  N   SER A 141      42.834  10.505   6.244  1.00 61.37           N  
ATOM   1146  CA  SER A 141      41.556  10.831   6.889  1.00 61.75           C  
ATOM   1147  C   SER A 141      40.345  10.161   6.233  1.00 61.73           C  
ATOM   1148  O   SER A 141      39.887  10.606   5.180  1.00 61.61           O  
ATOM   1149  CB  SER A 141      41.336  12.342   6.883  1.00 60.46           C  
ATOM   1150  OG  SER A 141      40.079  12.659   7.451  1.00 62.15           O  
ATOM   1151  N   ILE A 142      39.809   9.115   6.856  1.00 61.59           N  
ATOM   1152  CA  ILE A 142      38.655   8.435   6.276  1.00 62.09           C  
ATOM   1153  C   ILE A 142      37.423   9.322   6.238  1.00 61.51           C  
ATOM   1154  O   ILE A 142      36.376   8.901   5.751  1.00 61.97           O  
ATOM   1155  CB  ILE A 142      38.270   7.131   7.036  1.00 62.79           C  
ATOM   1156  CG1 ILE A 142      37.949   7.438   8.498  1.00 61.85           C  
ATOM   1157  CG2 ILE A 142      39.376   6.102   6.906  1.00 63.49           C  
ATOM   1158  CD1 ILE A 142      37.517   6.208   9.290  1.00 61.79           C  
ATOM   1159  N   VAL A 143      37.540  10.544   6.751  1.00 61.02           N  
ATOM   1160  CA  VAL A 143      36.408  11.469   6.752  1.00 60.94           C  
ATOM   1161  C   VAL A 143      36.487  12.530   5.650  1.00 61.55           C  
ATOM   1162  O   VAL A 143      35.457  12.959   5.133  1.00 62.77           O  
ATOM   1163  CB  VAL A 143      36.255  12.200   8.115  1.00 60.50           C  
ATOM   1164  CG1 VAL A 143      35.090  13.180   8.049  1.00 60.57           C  
ATOM   1165  CG2 VAL A 143      36.022  11.196   9.233  1.00 58.48           C  
ATOM   1166  N   THR A 144      37.695  12.950   5.279  1.00 60.99           N  
ATOM   1167  CA  THR A 144      37.830  13.980   4.247  1.00 60.29           C  
ATOM   1168  C   THR A 144      38.483  13.555   2.935  1.00 59.93           C  
ATOM   1169  O   THR A 144      38.210  14.150   1.895  1.00 60.46           O  
ATOM   1170  CB  THR A 144      38.615  15.193   4.768  1.00 59.92           C  
ATOM   1171  OG1 THR A 144      39.954  14.793   5.079  1.00 62.21           O  
ATOM   1172  CG2 THR A 144      37.957  15.763   6.011  1.00 58.00           C  
ATOM   1173  N   ASP A 145      39.343  12.542   2.974  1.00 59.53           N  
ATOM   1174  CA  ASP A 145      40.027  12.090   1.762  1.00 59.14           C  
ATOM   1175  C   ASP A 145      39.151  11.358   0.748  1.00 59.41           C  
ATOM   1176  O   ASP A 145      39.450  11.357  -0.446  1.00 59.30           O  
ATOM   1177  CB  ASP A 145      41.197  11.167   2.112  1.00 59.29           C  
ATOM   1178  CG  ASP A 145      42.383  11.911   2.693  1.00 61.88           C  
ATOM   1179  OD1 ASP A 145      42.716  13.008   2.190  1.00 64.06           O  
ATOM   1180  OD2 ASP A 145      42.993  11.383   3.645  1.00 60.24           O  
ATOM   1181  N   LEU A 146      38.075  10.741   1.222  1.00 58.66           N  
ATOM   1182  CA  LEU A 146      37.198   9.957   0.362  1.00 58.06           C  
ATOM   1183  C   LEU A 146      36.386  10.659  -0.731  1.00 57.54           C  
ATOM   1184  O   LEU A 146      36.558  10.354  -1.913  1.00 56.67           O  
ATOM   1185  CB  LEU A 146      36.270   9.094   1.233  1.00 56.79           C  
ATOM   1186  CG  LEU A 146      36.861   7.757   1.712  1.00 56.78           C  
ATOM   1187  CD1 LEU A 146      38.202   7.993   2.406  1.00 55.10           C  
ATOM   1188  CD2 LEU A 146      35.874   7.054   2.646  1.00 55.10           C  
ATOM   1189  N   PRO A 147      35.500  11.602  -0.361  1.00 57.98           N  
ATOM   1190  CA  PRO A 147      34.681  12.309  -1.351  1.00 58.44           C  
ATOM   1191  C   PRO A 147      35.437  12.821  -2.582  1.00 60.28           C  
ATOM   1192  O   PRO A 147      34.952  12.703  -3.708  1.00 61.00           O  
ATOM   1193  CB  PRO A 147      34.060  13.438  -0.536  1.00 58.59           C  
ATOM   1194  CG  PRO A 147      33.934  12.832   0.822  1.00 58.14           C  
ATOM   1195  CD  PRO A 147      35.271  12.156   0.985  1.00 57.27           C  
ATOM   1196  N   PRO A 148      36.632  13.401  -2.383  1.00 60.39           N  
ATOM   1197  CA  PRO A 148      37.403  13.910  -3.519  1.00 60.44           C  
ATOM   1198  C   PRO A 148      37.814  12.815  -4.497  1.00 60.47           C  
ATOM   1199  O   PRO A 148      37.866  13.044  -5.704  1.00 60.39           O  
ATOM   1200  CB  PRO A 148      38.605  14.566  -2.846  1.00 61.41           C  
ATOM   1201  CG  PRO A 148      38.026  15.044  -1.544  1.00 61.44           C  
ATOM   1202  CD  PRO A 148      37.235  13.837  -1.113  1.00 61.60           C  
ATOM   1203  N   LEU A 149      38.107  11.628  -3.975  1.00 60.89           N  
ATOM   1204  CA  LEU A 149      38.510  10.512  -4.827  1.00 60.65           C  
ATOM   1205  C   LEU A 149      37.346  10.064  -5.702  1.00 59.01           C  
ATOM   1206  O   LEU A 149      37.493   9.903  -6.909  1.00 58.66           O  
ATOM   1207  CB  LEU A 149      38.981   9.323  -3.984  1.00 62.37           C  
ATOM   1208  CG  LEU A 149      40.055   9.551  -2.924  1.00 65.01           C  
ATOM   1209  CD1 LEU A 149      40.539   8.193  -2.435  1.00 66.06           C  
ATOM   1210  CD2 LEU A 149      41.221  10.357  -3.493  1.00 67.11           C  
ATOM   1211  N   PHE A 150      36.189   9.862  -5.079  1.00 56.71           N  
ATOM   1212  CA  PHE A 150      35.002   9.426  -5.793  1.00 55.63           C  
ATOM   1213  C   PHE A 150      34.643  10.429  -6.881  1.00 55.40           C  
ATOM   1214  O   PHE A 150      34.359  10.055  -8.017  1.00 53.99           O  
ATOM   1215  CB  PHE A 150      33.810   9.286  -4.829  1.00 53.74           C  
ATOM   1216  CG  PHE A 150      34.072   8.380  -3.654  1.00 51.48           C  
ATOM   1217  CD1 PHE A 150      34.907   7.273  -3.776  1.00 50.54           C  
ATOM   1218  CD2 PHE A 150      33.464   8.625  -2.426  1.00 50.51           C  
ATOM   1219  CE1 PHE A 150      35.134   6.427  -2.689  1.00 49.86           C  
ATOM   1220  CE2 PHE A 150      33.684   7.785  -1.338  1.00 49.91           C  
ATOM   1221  CZ  PHE A 150      34.521   6.685  -1.471  1.00 48.62           C  
ATOM   1222  N   GLU A 151      34.662  11.708  -6.519  1.00 54.45           N  
ATOM   1223  CA  GLU A 151      34.325  12.770  -7.454  1.00 54.55           C  
ATOM   1224  C   GLU A 151      35.156  12.712  -8.735  1.00 52.06           C  
ATOM   1225  O   GLU A 151      34.653  13.020  -9.814  1.00 52.59           O  
ATOM   1226  CB  GLU A 151      34.494  14.136  -6.780  1.00 56.67           C  
ATOM   1227  CG  GLU A 151      33.892  15.277  -7.577  1.00 63.84           C  
ATOM   1228  CD  GLU A 151      32.371  15.212  -7.636  1.00 67.32           C  
ATOM   1229  OE1 GLU A 151      31.783  15.817  -8.562  1.00 69.32           O  
ATOM   1230  OE2 GLU A 151      31.763  14.566  -6.752  1.00 68.92           O  
ATOM   1231  N   SER A 152      36.420  12.307  -8.627  1.00 50.20           N  
ATOM   1232  CA  SER A 152      37.273  12.225  -9.808  1.00 48.99           C  
ATOM   1233  C   SER A 152      36.872  11.028 -10.670  1.00 48.77           C  
ATOM   1234  O   SER A 152      37.015  11.056 -11.894  1.00 47.16           O  
ATOM   1235  CB  SER A 152      38.754  12.139  -9.407  1.00 50.92           C  
ATOM   1236  OG  SER A 152      39.041  10.964  -8.670  1.00 53.70           O  
ATOM   1237  N   PHE A 153      36.362   9.978 -10.031  1.00 46.83           N  
ATOM   1238  CA  PHE A 153      35.914   8.800 -10.769  1.00 46.84           C  
ATOM   1239  C   PHE A 153      34.650   9.170 -11.552  1.00 47.55           C  
ATOM   1240  O   PHE A 153      34.537   8.886 -12.747  1.00 47.37           O  
ATOM   1241  CB  PHE A 153      35.611   7.649  -9.809  1.00 43.85           C  
ATOM   1242  CG  PHE A 153      34.940   6.469 -10.465  1.00 44.03           C  
ATOM   1243  CD1 PHE A 153      33.578   6.231 -10.278  1.00 40.02           C  
ATOM   1244  CD2 PHE A 153      35.670   5.596 -11.268  1.00 41.51           C  
ATOM   1245  CE1 PHE A 153      32.955   5.142 -10.879  1.00 39.30           C  
ATOM   1246  CE2 PHE A 153      35.058   4.502 -11.873  1.00 44.06           C  
ATOM   1247  CZ  PHE A 153      33.697   4.274 -11.677  1.00 41.03           C  
ATOM   1248  N   TYR A 154      33.720   9.831 -10.867  1.00 47.39           N  
ATOM   1249  CA  TYR A 154      32.454  10.244 -11.461  1.00 50.13           C  
ATOM   1250  C   TYR A 154      32.593  11.287 -12.568  1.00 51.99           C  
ATOM   1251  O   TYR A 154      31.763  11.356 -13.473  1.00 52.62           O  
ATOM   1252  CB  TYR A 154      31.513  10.795 -10.381  1.00 47.71           C  
ATOM   1253  CG  TYR A 154      31.177   9.813  -9.276  1.00 49.97           C  
ATOM   1254  CD1 TYR A 154      31.085   8.446  -9.535  1.00 48.94           C  
ATOM   1255  CD2 TYR A 154      30.901  10.255  -7.984  1.00 48.56           C  
ATOM   1256  CE1 TYR A 154      30.723   7.545  -8.538  1.00 51.16           C  
ATOM   1257  CE2 TYR A 154      30.536   9.364  -6.976  1.00 50.31           C  
ATOM   1258  CZ  TYR A 154      30.447   8.010  -7.259  1.00 50.99           C  
ATOM   1259  OH  TYR A 154      30.070   7.124  -6.274  1.00 48.77           O  
ATOM   1260  N   ALA A 155      33.642  12.096 -12.496  1.00 54.28           N  
ATOM   1261  CA  ALA A 155      33.861  13.146 -13.481  1.00 55.67           C  
ATOM   1262  C   ALA A 155      34.631  12.683 -14.710  1.00 55.70           C  
ATOM   1263  O   ALA A 155      34.986  13.494 -15.559  1.00 57.77           O  
ATOM   1264  CB  ALA A 155      34.595  14.317 -12.825  1.00 57.33           C  
ATOM   1265  N   SER A 156      34.873  11.385 -14.820  1.00 55.68           N  
ATOM   1266  CA  SER A 156      35.639  10.871 -15.947  1.00 56.00           C  
ATOM   1267  C   SER A 156      35.097   9.572 -16.525  1.00 57.16           C  
ATOM   1268  O   SER A 156      35.075   8.543 -15.853  1.00 57.30           O  
ATOM   1269  CB  SER A 156      37.092  10.663 -15.518  1.00 54.31           C  
ATOM   1270  OG  SER A 156      37.837  10.018 -16.533  1.00 55.33           O  
ATOM   1271  N   GLU A 157      34.677   9.618 -17.782  1.00 59.13           N  
ATOM   1272  CA  GLU A 157      34.152   8.433 -18.433  1.00 60.45           C  
ATOM   1273  C   GLU A 157      35.300   7.485 -18.764  1.00 60.62           C  
ATOM   1274  O   GLU A 157      35.094   6.287 -18.971  1.00 61.34           O  
ATOM   1275  CB  GLU A 157      33.402   8.822 -19.704  1.00 64.28           C  
ATOM   1276  CG  GLU A 157      32.401   9.939 -19.493  1.00 67.43           C  
ATOM   1277  CD  GLU A 157      31.407  10.048 -20.629  1.00 71.61           C  
ATOM   1278  OE1 GLU A 157      31.833   9.966 -21.804  1.00 72.51           O  
ATOM   1279  OE2 GLU A 157      30.201  10.220 -20.346  1.00 73.70           O  
ATOM   1280  N   ASP A 158      36.514   8.023 -18.812  1.00 59.93           N  
ATOM   1281  CA  ASP A 158      37.687   7.209 -19.105  1.00 60.09           C  
ATOM   1282  C   ASP A 158      37.978   6.302 -17.917  1.00 58.97           C  
ATOM   1283  O   ASP A 158      38.327   5.132 -18.083  1.00 57.37           O  
ATOM   1284  CB  ASP A 158      38.899   8.097 -19.386  1.00 62.76           C  
ATOM   1285  CG  ASP A 158      38.633   9.106 -20.481  1.00 67.18           C  
ATOM   1286  OD1 ASP A 158      37.838  10.047 -20.246  1.00 69.09           O  
ATOM   1287  OD2 ASP A 158      39.212   8.952 -21.578  1.00 68.61           O  
ATOM   1288  N   LYS A 159      37.841   6.844 -16.712  1.00 57.58           N  
ATOM   1289  CA  LYS A 159      38.078   6.041 -15.520  1.00 57.25           C  
ATOM   1290  C   LYS A 159      36.973   4.998 -15.407  1.00 56.00           C  
ATOM   1291  O   LYS A 159      37.221   3.861 -15.015  1.00 54.49           O  
ATOM   1292  CB  LYS A 159      38.083   6.916 -14.265  1.00 57.62           C  
ATOM   1293  CG  LYS A 159      39.301   7.803 -14.122  1.00 56.42           C  
ATOM   1294  CD  LYS A 159      39.148   8.723 -12.930  1.00 58.47           C  
ATOM   1295  CE  LYS A 159      40.438   9.460 -12.628  1.00 59.47           C  
ATOM   1296  NZ  LYS A 159      40.916  10.238 -13.788  1.00 60.14           N  
ATOM   1297  N   ARG A 160      35.758   5.400 -15.773  1.00 55.46           N  
ATOM   1298  CA  ARG A 160      34.590   4.527 -15.707  1.00 56.81           C  
ATOM   1299  C   ARG A 160      34.498   3.471 -16.808  1.00 57.68           C  
ATOM   1300  O   ARG A 160      33.693   2.545 -16.706  1.00 58.96           O  
ATOM   1301  CB  ARG A 160      33.309   5.368 -15.719  1.00 55.61           C  
ATOM   1302  CG  ARG A 160      33.257   6.435 -14.635  1.00 55.90           C  
ATOM   1303  CD  ARG A 160      31.829   6.814 -14.297  1.00 57.83           C  
ATOM   1304  NE  ARG A 160      31.166   7.544 -15.370  1.00 60.23           N  
ATOM   1305  CZ  ARG A 160      31.451   8.799 -15.696  1.00 64.57           C  
ATOM   1306  NH1 ARG A 160      32.388   9.459 -15.028  1.00 67.11           N  
ATOM   1307  NH2 ARG A 160      30.804   9.396 -16.687  1.00 65.26           N  
ATOM   1308  N   ARG A 161      35.316   3.598 -17.850  1.00 58.12           N  
ATOM   1309  CA  ARG A 161      35.284   2.652 -18.967  1.00 58.21           C  
ATOM   1310  C   ARG A 161      35.885   1.293 -18.614  1.00 58.21           C  
ATOM   1311  O   ARG A 161      37.066   1.195 -18.269  1.00 58.21           O  
ATOM   1312  CB  ARG A 161      36.024   3.239 -20.176  1.00 59.22           C  
ATOM   1313  CG  ARG A 161      35.722   2.547 -21.507  1.00 61.06           C  
ATOM   1314  CD  ARG A 161      36.632   3.044 -22.634  1.00 60.33           C  
ATOM   1315  NE  ARG A 161      36.703   4.504 -22.691  1.00 59.17           N  
ATOM   1316  CZ  ARG A 161      35.671   5.296 -22.966  1.00 59.91           C  
ATOM   1317  NH1 ARG A 161      34.478   4.778 -23.217  1.00 60.02           N  
ATOM   1318  NH2 ARG A 161      35.831   6.612 -22.983  1.00 60.35           N  
ATOM   1319  N   CYS A 162      35.069   0.245 -18.705  1.00 58.28           N  
ATOM   1320  CA  CYS A 162      35.530  -1.107 -18.401  1.00 60.53           C  
ATOM   1321  C   CYS A 162      36.548  -1.542 -19.444  1.00 62.38           C  
ATOM   1322  O   CYS A 162      36.248  -1.593 -20.636  1.00 63.01           O  
ATOM   1323  CB  CYS A 162      34.357  -2.098 -18.385  1.00 59.62           C  
ATOM   1324  SG  CYS A 162      34.864  -3.837 -18.225  1.00 58.67           S  
ATOM   1325  N   PRO A 163      37.769  -1.869 -19.004  1.00 64.41           N  
ATOM   1326  CA  PRO A 163      38.839  -2.298 -19.905  1.00 65.99           C  
ATOM   1327  C   PRO A 163      38.591  -3.676 -20.496  1.00 67.66           C  
ATOM   1328  O   PRO A 163      39.396  -4.176 -21.282  1.00 68.32           O  
ATOM   1329  CB  PRO A 163      40.063  -2.287 -19.002  1.00 66.42           C  
ATOM   1330  CG  PRO A 163      39.494  -2.748 -17.700  1.00 64.50           C  
ATOM   1331  CD  PRO A 163      38.214  -1.933 -17.600  1.00 64.95           C  
ATOM   1332  N   HIS A 164      37.475  -4.290 -20.123  1.00 68.52           N  
ATOM   1333  CA  HIS A 164      37.182  -5.621 -20.622  1.00 69.76           C  
ATOM   1334  C   HIS A 164      36.029  -5.688 -21.615  1.00 69.23           C  
ATOM   1335  O   HIS A 164      36.115  -6.400 -22.614  1.00 68.88           O  
ATOM   1336  CB  HIS A 164      36.911  -6.564 -19.450  1.00 70.76           C  
ATOM   1337  CG  HIS A 164      36.897  -8.009 -19.834  1.00 72.67           C  
ATOM   1338  ND1 HIS A 164      35.809  -8.612 -20.428  1.00 73.40           N  
ATOM   1339  CD2 HIS A 164      37.852  -8.963 -19.739  1.00 73.46           C  
ATOM   1340  CE1 HIS A 164      36.094  -9.877 -20.681  1.00 74.37           C  
ATOM   1341  NE2 HIS A 164      37.328 -10.116 -20.272  1.00 74.64           N  
ATOM   1342  N   CYS A 165      34.955  -4.952 -21.354  1.00 67.93           N  
ATOM   1343  CA  CYS A 165      33.819  -4.978 -22.261  1.00 67.74           C  
ATOM   1344  C   CYS A 165      33.446  -3.583 -22.752  1.00 66.68           C  
ATOM   1345  O   CYS A 165      32.487  -3.421 -23.501  1.00 66.50           O  
ATOM   1346  CB  CYS A 165      32.615  -5.641 -21.588  1.00 67.26           C  
ATOM   1347  SG  CYS A 165      31.674  -4.558 -20.512  1.00 69.01           S  
ATOM   1348  N   GLY A 166      34.203  -2.581 -22.316  1.00 65.28           N  
ATOM   1349  CA  GLY A 166      33.957  -1.216 -22.749  1.00 63.16           C  
ATOM   1350  C   GLY A 166      32.745  -0.505 -22.177  1.00 62.29           C  
ATOM   1351  O   GLY A 166      32.449   0.624 -22.568  1.00 61.57           O  
ATOM   1352  N   GLN A 167      32.030  -1.156 -21.268  1.00 62.11           N  
ATOM   1353  CA  GLN A 167      30.861  -0.540 -20.647  1.00 61.09           C  
ATOM   1354  C   GLN A 167      31.316   0.614 -19.746  1.00 59.57           C  
ATOM   1355  O   GLN A 167      32.313   0.499 -19.041  1.00 58.22           O  
ATOM   1356  CB  GLN A 167      30.099  -1.583 -19.819  1.00 63.13           C  
ATOM   1357  CG  GLN A 167      28.987  -1.018 -18.944  1.00 65.39           C  
ATOM   1358  CD  GLN A 167      27.801  -0.502 -19.738  1.00 68.79           C  
ATOM   1359  OE1 GLN A 167      26.894   0.125 -19.183  1.00 68.91           O  
ATOM   1360  NE2 GLN A 167      27.794  -0.771 -21.043  1.00 70.77           N  
ATOM   1361  N   VAL A 168      30.589   1.726 -19.786  1.00 58.90           N  
ATOM   1362  CA  VAL A 168      30.913   2.888 -18.965  1.00 58.66           C  
ATOM   1363  C   VAL A 168      30.100   2.841 -17.676  1.00 59.29           C  
ATOM   1364  O   VAL A 168      28.869   2.894 -17.703  1.00 59.42           O  
ATOM   1365  CB  VAL A 168      30.602   4.209 -19.698  1.00 57.28           C  
ATOM   1366  CG1 VAL A 168      30.837   5.382 -18.772  1.00 55.85           C  
ATOM   1367  CG2 VAL A 168      31.473   4.335 -20.940  1.00 55.55           C  
ATOM   1368  N   HIS A 169      30.802   2.734 -16.553  1.00 59.36           N  
ATOM   1369  CA  HIS A 169      30.171   2.671 -15.247  1.00 58.67           C  
ATOM   1370  C   HIS A 169      29.236   3.863 -15.061  1.00 59.57           C  
ATOM   1371  O   HIS A 169      29.579   4.991 -15.400  1.00 57.57           O  
ATOM   1372  CB  HIS A 169      31.246   2.671 -14.163  1.00 58.33           C  
ATOM   1373  CG  HIS A 169      30.708   2.509 -12.778  1.00 59.05           C  
ATOM   1374  ND1 HIS A 169      30.659   1.291 -12.134  1.00 58.65           N  
ATOM   1375  CD2 HIS A 169      30.176   3.410 -11.918  1.00 59.26           C  
ATOM   1376  CE1 HIS A 169      30.121   1.450 -10.939  1.00 58.91           C  
ATOM   1377  NE2 HIS A 169      29.820   2.726 -10.782  1.00 59.11           N  
ATOM   1378  N   PRO A 170      28.036   3.620 -14.515  1.00 61.84           N  
ATOM   1379  CA  PRO A 170      27.014   4.646 -14.267  1.00 63.93           C  
ATOM   1380  C   PRO A 170      27.456   5.857 -13.446  1.00 66.05           C  
ATOM   1381  O   PRO A 170      26.714   6.831 -13.325  1.00 65.58           O  
ATOM   1382  CB  PRO A 170      25.907   3.864 -13.566  1.00 63.83           C  
ATOM   1383  CG  PRO A 170      26.043   2.491 -14.166  1.00 63.05           C  
ATOM   1384  CD  PRO A 170      27.532   2.283 -14.150  1.00 61.93           C  
ATOM   1385  N   GLY A 171      28.655   5.804 -12.877  1.00 68.80           N  
ATOM   1386  CA  GLY A 171      29.117   6.924 -12.074  1.00 71.45           C  
ATOM   1387  C   GLY A 171      28.280   7.070 -10.814  1.00 73.98           C  
ATOM   1388  O   GLY A 171      27.874   6.070 -10.223  1.00 73.85           O  
ATOM   1389  N   ARG A 172      28.014   8.305 -10.398  1.00 77.01           N  
ATOM   1390  CA  ARG A 172      27.213   8.530  -9.196  1.00 80.91           C  
ATOM   1391  C   ARG A 172      25.728   8.309  -9.465  1.00 83.01           C  
ATOM   1392  O   ARG A 172      24.903   9.204  -9.265  1.00 83.43           O  
ATOM   1393  CB  ARG A 172      27.429   9.944  -8.648  1.00 81.08           C  
ATOM   1394  CG  ARG A 172      27.152  11.059  -9.634  1.00 82.76           C  
ATOM   1395  CD  ARG A 172      26.990  12.391  -8.915  1.00 84.86           C  
ATOM   1396  NE  ARG A 172      27.104  13.521  -9.832  1.00 87.23           N  
ATOM   1397  CZ  ARG A 172      28.252  13.946 -10.353  1.00 88.21           C  
ATOM   1398  NH1 ARG A 172      29.388  13.334 -10.041  1.00 88.02           N  
ATOM   1399  NH2 ARG A 172      28.266  14.975 -11.190  1.00 88.45           N  
ATOM   1400  N   ALA A 173      25.400   7.106  -9.921  1.00 84.44           N  
ATOM   1401  CA  ALA A 173      24.021   6.747 -10.222  1.00 86.07           C  
ATOM   1402  C   ALA A 173      23.922   5.236 -10.366  1.00 87.00           C  
ATOM   1403  O   ALA A 173      22.943   4.714 -10.905  1.00 87.63           O  
ATOM   1404  CB  ALA A 173      23.568   7.433 -11.507  1.00 85.58           C  
ATOM   1405  N   ALA A 174      24.947   4.538  -9.881  1.00 87.27           N  
ATOM   1406  CA  ALA A 174      24.991   3.081  -9.942  1.00 87.44           C  
ATOM   1407  C   ALA A 174      24.469   2.485  -8.641  1.00 87.23           C  
ATOM   1408  O   ALA A 174      24.326   3.190  -7.642  1.00 87.31           O  
ATOM   1409  CB  ALA A 174      26.418   2.610 -10.197  1.00 87.65           C  
TER    1410      ALA A 174                                                      
END
MOLECULE T0414.pdb
ATOM      1  N   ALA     3      33.302  15.772  39.809  1.00 36.36           N  
ATOM      2  CA  ALA     3      33.703  14.577  39.009  1.00 34.68           C  
ATOM      3  C   ALA     3      33.623  14.788  37.490  1.00 33.45           C  
ATOM      4  O   ALA     3      32.753  15.521  36.975  1.00 34.46           O  
ATOM      5  CB  ALA     3      32.891  13.338  39.421  1.00 34.63           C  
ATOM      6  N   MET     4      34.518  14.186  36.727  0.50 33.03           N  
ATOM      8  CA  MET     4      34.520  14.424  35.288  0.50 31.92           C  
ATOM     10  C   MET     4      33.425  13.560  34.616  0.50 29.87           C  
ATOM     12  O   MET     4      33.219  12.421  35.010  0.50 28.81           O  
ATOM     14  CB  MET     4      35.942  14.155  34.757  0.50 32.53           C  
ATOM     16  CG  MET     4      36.126  13.883  33.287  0.50 33.68           C  
ATOM     18  SD  MET     4      37.621  12.592  33.077  0.30 35.37          SE  
ATOM     20  CE  MET     4      38.935  13.454  34.246  0.50 35.07           C  
ATOM     22  N   LYS     5      32.683  14.127  33.663  0.50 27.74           N  
ATOM     24  CA  LYS     5      31.796  13.306  32.842  0.50 25.75           C  
ATOM     26  C   LYS     5      32.631  12.565  31.797  0.50 23.22           C  
ATOM     28  O   LYS     5      33.773  12.916  31.546  0.50 22.57           O  
ATOM     30  CB  LYS     5      30.709  14.150  32.160  0.50 26.57           C  
ATOM     32  CG  LYS     5      29.525  14.483  33.071  0.50 27.85           C  
ATOM     34  CD  LYS     5      28.325  14.912  32.262  0.50 29.82           C  
ATOM     36  CE  LYS     5      27.439  13.747  31.918  0.50 28.42           C  
ATOM     38  NZ  LYS     5      26.334  13.574  32.915  0.50 27.77           N  
ATOM     40  N   PRO     6      32.050  11.528  31.182  1.00 21.30           N  
ATOM     41  CA  PRO     6      32.693  10.923  29.996  1.00 19.52           C  
ATOM     42  C   PRO     6      32.625  11.935  28.854  1.00 18.68           C  
ATOM     43  O   PRO     6      31.774  12.839  28.867  1.00 19.30           O  
ATOM     44  CB  PRO     6      31.790   9.733  29.675  1.00 19.69           C  
ATOM     45  CG  PRO     6      30.458  10.178  30.200  1.00 20.34           C  
ATOM     46  CD  PRO     6      30.766  10.901  31.500  1.00 21.56           C  
ATOM     47  N   ASP     7      33.506  11.792  27.867  1.00 17.52           N  
ATOM     48  CA  ASP     7      33.309  12.556  26.627  1.00 16.91           C  
ATOM     49  C   ASP     7      32.131  11.917  25.899  1.00 15.85           C  
ATOM     50  O   ASP     7      31.966  10.690  25.921  1.00 17.32           O  
ATOM     51  CB  ASP     7      34.552  12.523  25.770  1.00 17.30           C  
ATOM     52  CG  ASP     7      35.764  13.025  26.518  1.00 20.36           C  
ATOM     53  OD1 ASP     7      35.723  14.200  26.989  1.00 22.01           O  
ATOM     54  OD2 ASP     7      36.738  12.272  26.639  1.00 20.73           O  
ATOM     55  N   ILE     8      31.291  12.738  25.293  1.00 16.43           N  
ATOM     56  CA  ILE     8      30.057  12.263  24.664  1.00 16.85           C  
ATOM     57  C   ILE     8      30.093  12.721  23.218  1.00 17.30           C  
ATOM     58  O   ILE     8      30.202  13.939  22.920  1.00 16.82           O  
ATOM     59  CB  ILE     8      28.808  12.859  25.331  1.00 16.75           C  
ATOM     60  CG1 ILE     8      28.809  12.531  26.831  1.00 17.21           C  
ATOM     61  CG2 ILE     8      27.531  12.326  24.628  1.00 17.36           C  
ATOM     62  CD1 ILE     8      27.659  13.134  27.576  1.00 21.50           C  
ATOM     63  N   TYR     9      30.035  11.755  22.304  1.00 16.25           N  
ATOM     64  CA  TYR     9      30.189  12.064  20.879  1.00 16.53           C  
ATOM     65  C   TYR     9      28.922  11.695  20.103  1.00 16.71           C  
ATOM     66  O   TYR     9      28.269  10.652  20.365  1.00 17.09           O  
ATOM     67  CB  TYR     9      31.309  11.207  20.307  1.00 18.16           C  
ATOM     68  CG  TYR     9      32.621  11.239  21.056  1.00 19.13           C  
ATOM     69  CD1 TYR     9      33.272  12.425  21.336  1.00 20.08           C  
ATOM     70  CD2 TYR     9      33.226  10.035  21.442  1.00 21.22           C  
ATOM     71  CE1 TYR     9      34.527  12.415  22.020  1.00 19.52           C  
ATOM     72  CE2 TYR     9      34.442  10.010  22.068  1.00 19.90           C  
ATOM     73  CZ  TYR     9      35.070  11.186  22.368  1.00 19.38           C  
ATOM     74  OH  TYR     9      36.285  11.080  23.009  1.00 22.23           O  
ATOM     75  N   GLU    10      28.590  12.535  19.113  1.00 16.20           N  
ATOM     76  CA  GLU    10      27.458  12.237  18.240  1.00 17.73           C  
ATOM     77  C   GLU    10      27.825  12.717  16.832  1.00 17.84           C  
ATOM     78  O   GLU    10      28.762  13.547  16.657  1.00 17.95           O  
ATOM     79  CB  GLU    10      26.181  12.949  18.724  1.00 18.99           C  
ATOM     80  CG  GLU    10      26.360  14.445  18.695  1.00 21.75           C  
ATOM     81  CD  GLU    10      25.209  15.268  19.281  1.00 25.44           C  
ATOM     82  OE1 GLU    10      24.163  14.693  19.649  1.00 33.26           O  
ATOM     83  OE2 GLU    10      25.399  16.514  19.308  1.00 33.86           O  
ATOM     84  N   ASN    11      27.070  12.220  15.860  1.00 15.68           N  
ATOM     85  CA  ASN    11      27.238  12.683  14.477  1.00 15.50           C  
ATOM     86  C   ASN    11      25.856  12.930  13.910  1.00 16.30           C  
ATOM     87  O   ASN    11      25.046  11.966  13.797  1.00 16.56           O  
ATOM     88  CB  ASN    11      27.966  11.608  13.647  1.00 17.10           C  
ATOM     89  CG  ASN    11      28.062  11.990  12.175  1.00 17.78           C  
ATOM     90  OD1 ASN    11      27.841  13.151  11.836  1.00 17.07           O  
ATOM     91  ND2 ASN    11      28.398  11.027  11.314  1.00 16.10           N  
ATOM     92  N   ASN    12      25.572  14.203  13.592  1.00 17.76           N  
ATOM     93  CA  ASN    12      24.307  14.543  12.923  1.00 18.55           C  
ATOM     94  C   ASN    12      24.489  14.954  11.485  1.00 19.79           C  
ATOM     95  O   ASN    12      23.556  15.494  10.875  1.00 23.14           O  
ATOM     96  CB  ASN    12      23.564  15.640  13.703  1.00 20.05           C  
ATOM     97  CG  ASN    12      23.156  15.160  15.094  1.00 23.62           C  
ATOM     98  OD1 ASN    12      23.532  15.777  16.086  1.00 32.59           O  
ATOM     99  ND2 ASN    12      22.482  14.022  15.159  1.00 27.73           N  
ATOM    100  N   ARG    13      25.665  14.690  10.940  1.00 16.78           N  
ATOM    101  CA  ARG    13      26.007  15.090   9.567  1.00 17.18           C  
ATOM    102  C   ARG    13      25.867  13.915   8.606  1.00 17.32           C  
ATOM    103  O   ARG    13      25.768  12.761   9.017  1.00 18.57           O  
ATOM    104  CB  ARG    13      27.463  15.613   9.536  1.00 16.99           C  
ATOM    105  CG  ARG    13      27.698  16.841  10.366  1.00 16.86           C  
ATOM    106  CD  ARG    13      29.145  17.340  10.231  1.00 18.64           C  
ATOM    107  NE  ARG    13      29.314  18.572  11.017  1.00 20.84           N  
ATOM    108  CZ  ARG    13      29.068  19.795  10.555  1.00 22.46           C  
ATOM    109  NH1 ARG    13      28.699  19.980   9.285  1.00 21.30           N  
ATOM    110  NH2 ARG    13      29.238  20.846  11.368  1.00 26.57           N  
ATOM    111  N   GLU    14      25.874  14.191   7.309  1.00 16.57           N  
ATOM    112  CA  GLU    14      25.895  13.116   6.308  1.00 17.51           C  
ATOM    113  C   GLU    14      27.211  12.302   6.422  1.00 16.26           C  
ATOM    114  O   GLU    14      28.303  12.837   6.662  1.00 18.17           O  
ATOM    115  CB  GLU    14      25.802  13.757   4.918  1.00 18.63           C  
ATOM    116  CG  GLU    14      25.635  12.781   3.785  1.00 22.71           C  
ATOM    117  CD  GLU    14      25.134  13.481   2.513  1.00 24.46           C  
ATOM    118  OE1 GLU    14      23.942  13.830   2.472  1.00 28.70           O  
ATOM    119  OE2 GLU    14      25.953  13.623   1.579  1.00 28.01           O  
ATOM    120  N   GLY    15      27.111  10.995   6.267  1.00 17.10           N  
ATOM    121  CA  GLY    15      28.324  10.243   6.152  1.00 18.01           C  
ATOM    122  C   GLY    15      29.095  10.097   7.455  1.00 17.23           C  
ATOM    123  O   GLY    15      28.526   9.934   8.543  1.00 17.23           O  
ATOM    124  N   ILE    16      30.411  10.148   7.345  1.00 17.29           N  
ATOM    125  CA  ILE    16      31.280   9.730   8.446  1.00 16.95           C  
ATOM    126  C   ILE    16      31.787  10.890   9.280  1.00 16.79           C  
ATOM    127  O   ILE    16      32.203  11.929   8.740  1.00 17.82           O  
ATOM    128  CB  ILE    16      32.507   8.989   7.861  1.00 16.44           C  
ATOM    129  CG1 ILE    16      32.046   7.772   7.049  1.00 18.83           C  
ATOM    130  CG2 ILE    16      33.466   8.593   8.953  1.00 17.93           C  
ATOM    131  CD1 ILE    16      33.193   7.165   6.146  1.00 19.62           C  
ATOM    132  N   LEU    17      31.774  10.717  10.609  1.00 16.67           N  
ATOM    133  CA  LEU    17      32.462  11.624  11.507  1.00 17.09           C  
ATOM    134  C   LEU    17      33.304  10.755  12.436  1.00 17.42           C  
ATOM    135  O   LEU    17      32.781   9.846  13.128  1.00 17.89           O  
ATOM    136  CB  LEU    17      31.464  12.429  12.342  1.00 17.81           C  
ATOM    137  CG  LEU    17      32.111  13.501  13.216  1.00 17.47           C  
ATOM    138  CD1 LEU    17      32.620  14.670  12.347  1.00 19.68           C  
ATOM    139  CD2 LEU    17      31.074  13.984  14.258  1.00 19.13           C  
ATOM    140  N   CYS    18      34.601  11.024  12.429  0.50 18.77           N  
ATOM    142  CA  CYS    18      35.503  10.383  13.334  0.50 18.68           C  
ATOM    144  C   CYS    18      35.329  11.084  14.662  0.50 17.75           C  
ATOM    146  O   CYS    18      35.414  12.342  14.749  0.50 17.11           O  
ATOM    148  CB  CYS    18      36.931  10.520  12.822  0.50 19.68           C  
ATOM    150  SG  CYS    18      38.169   9.741  13.895  0.50 25.35           S  
ATOM    152  N   VAL    19      35.090  10.285  15.703  1.00 17.60           N  
ATOM    153  CA  VAL    19      34.852  10.884  17.017  1.00 17.61           C  
ATOM    154  C   VAL    19      35.901  10.621  18.082  1.00 18.84           C  
ATOM    155  O   VAL    19      36.031  11.426  19.030  1.00 19.37           O  
ATOM    156  CB  VAL    19      33.441  10.554  17.541  1.00 18.37           C  
ATOM    157  CG1 VAL    19      32.386  11.066  16.565  1.00 19.97           C  
ATOM    158  CG2 VAL    19      33.285   9.036  17.807  1.00 19.29           C  
ATOM    159  N   TYR    20      36.659   9.537  17.949  1.00 17.79           N  
ATOM    160  CA  TYR    20      37.705   9.219  18.927  1.00 17.31           C  
ATOM    161  C   TYR    20      38.904   8.679  18.151  1.00 17.74           C  
ATOM    162  O   TYR    20      38.744   7.851  17.253  1.00 17.59           O  
ATOM    163  CB  TYR    20      37.239   8.164  19.938  1.00 18.63           C  
ATOM    164  CG  TYR    20      38.375   7.755  20.831  1.00 18.31           C  
ATOM    165  CD1 TYR    20      38.666   8.491  22.001  1.00 18.30           C  
ATOM    166  CD2 TYR    20      39.252   6.735  20.480  1.00 17.90           C  
ATOM    167  CE1 TYR    20      39.781   8.162  22.798  1.00 16.64           C  
ATOM    168  CE2 TYR    20      40.353   6.396  21.280  1.00 17.14           C  
ATOM    169  CZ  TYR    20      40.610   7.128  22.429  1.00 17.75           C  
ATOM    170  OH  TYR    20      41.720   6.807  23.204  1.00 18.23           O  
ATOM    171  N   LYS    21      40.092   9.175  18.494  0.50 18.45           N  
ATOM    173  CA  LYS    21      41.325   8.709  17.899  0.50 19.23           C  
ATOM    175  C   LYS    21      42.410   8.666  18.967  0.50 18.93           C  
ATOM    177  O   LYS    21      42.492   9.553  19.844  0.50 18.14           O  
ATOM    179  CB  LYS    21      41.769   9.654  16.755  0.50 19.72           C  
ATOM    181  CG  LYS    21      42.986   9.166  15.984  0.50 21.51           C  
ATOM    183  CD  LYS    21      43.277  10.047  14.777  0.50 22.28           C  
ATOM    185  CE  LYS    21      44.165   9.322  13.775  0.50 26.01           C  
ATOM    187  NZ  LYS    21      44.998  10.242  12.956  0.50 28.80           N  
ATOM    189  N   ASN    22      43.246   7.641  18.893  1.00 18.57           N  
ATOM    190  CA  ASN    22      44.510   7.675  19.646  1.00 19.63           C  
ATOM    191  C   ASN    22      45.633   7.170  18.740  1.00 20.21           C  
ATOM    192  O   ASN    22      45.442   7.146  17.525  1.00 21.67           O  
ATOM    193  CB  ASN    22      44.393   6.968  21.000  1.00 19.28           C  
ATOM    194  CG  ASN    22      44.119   5.476  20.878  1.00 18.68           C  
ATOM    195  OD1 ASN    22      44.477   4.855  19.876  1.00 18.07           O  
ATOM    196  ND2 ASN    22      43.512   4.893  21.908  1.00 19.31           N  
ATOM    197  N   GLU    23      46.798   6.802  19.268  0.50 20.33           N  
ATOM    199  CA  GLU    23      47.871   6.392  18.343  0.50 20.79           C  
ATOM    201  C   GLU    23      47.688   4.963  17.811  0.50 20.15           C  
ATOM    203  O   GLU    23      48.445   4.517  16.927  0.50 21.08           O  
ATOM    205  CB  GLU    23      49.271   6.615  18.948  0.50 21.32           C  
ATOM    207  CG  GLU    23      49.531   8.068  19.373  0.50 24.58           C  
ATOM    209  CD  GLU    23      49.988   9.002  18.251  0.50 28.91           C  
ATOM    211  OE1 GLU    23      50.063   8.588  17.074  0.50 31.75           O  
ATOM    213  OE2 GLU    23      50.296  10.181  18.573  0.50 31.68           O  
ATOM    215  N   LYS    24      46.657   4.262  18.314  1.00 19.87           N  
ATOM    216  CA  LYS    24      46.411   2.876  17.906  1.00 18.64           C  
ATOM    217  C   LYS    24      45.123   2.675  17.102  1.00 18.65           C  
ATOM    218  O   LYS    24      45.163   2.084  16.009  1.00 19.79           O  
ATOM    219  CB  LYS    24      46.397   1.937  19.115  1.00 19.67           C  
ATOM    220  CG  LYS    24      47.742   1.895  19.853  1.00 19.24           C  
ATOM    221  CD  LYS    24      47.728   0.842  20.946  1.00 23.27           C  
ATOM    222  CE  LYS    24      49.012   0.890  21.752  1.00 25.06           C  
ATOM    223  NZ  LYS    24      49.012  -0.142  22.838  1.00 26.49           N  
ATOM    224  N   TRP    25      43.996   3.147  17.659  1.00 17.80           N  
ATOM    225  CA  TRP    25      42.710   2.938  16.969  1.00 17.10           C  
ATOM    226  C   TRP    25      41.877   4.189  16.872  1.00 17.05           C  
ATOM    227  O   TRP    25      42.166   5.213  17.501  1.00 17.33           O  
ATOM    228  CB  TRP    25      41.866   1.812  17.636  1.00 17.38           C  
ATOM    229  CG  TRP    25      41.250   2.174  18.989  1.00 17.07           C  
ATOM    230  CD1 TRP    25      40.015   2.746  19.223  1.00 17.16           C  
ATOM    231  CD2 TRP    25      41.857   2.004  20.276  1.00 17.43           C  
ATOM    232  NE1 TRP    25      39.803   2.914  20.576  1.00 16.55           N  
ATOM    233  CE2 TRP    25      40.925   2.472  21.248  1.00 16.10           C  
ATOM    234  CE3 TRP    25      43.109   1.515  20.713  1.00 17.97           C  
ATOM    235  CZ2 TRP    25      41.217   2.471  22.613  1.00 17.89           C  
ATOM    236  CZ3 TRP    25      43.372   1.485  22.082  1.00 18.95           C  
ATOM    237  CH2 TRP    25      42.441   1.975  23.006  1.00 18.93           C  
ATOM    238  N   LEU    26      40.846   4.125  16.057  0.60 17.36           N  
ATOM    240  CA  LEU    26      39.876   5.195  16.053  0.60 18.29           C  
ATOM    242  C   LEU    26      38.473   4.598  16.034  0.60 17.48           C  
ATOM    244  O   LEU    26      38.259   3.406  15.788  0.60 17.47           O  
ATOM    246  CB  LEU    26      40.140   6.186  14.899  0.60 19.00           C  
ATOM    248  CG  LEU    26      40.146   5.630  13.476  0.60 19.25           C  
ATOM    250  CD1 LEU    26      38.728   5.417  13.012  0.60 20.31           C  
ATOM    252  CD2 LEU    26      40.883   6.556  12.503  0.60 20.54           C  
ATOM    254  N   VAL    27      37.519   5.464  16.315  1.00 16.98           N  
ATOM    255  CA  VAL    27      36.079   5.101  16.320  1.00 16.22           C  
ATOM    256  C   VAL    27      35.324   6.179  15.576  1.00 17.45           C  
ATOM    257  O   VAL    27      35.516   7.373  15.844  1.00 17.46           O  
ATOM    258  CB  VAL    27      35.508   5.013  17.747  1.00 17.18           C  
ATOM    259  CG1 VAL    27      34.016   4.551  17.698  1.00 17.61           C  
ATOM    260  CG2 VAL    27      36.386   4.029  18.599  1.00 18.01           C  
ATOM    261  N   CYS    28      34.532   5.742  14.596  1.00 16.21           N  
ATOM    262  CA  CYS    28      33.759   6.689  13.774  1.00 16.26           C  
ATOM    263  C   CYS    28      32.281   6.352  13.879  1.00 16.20           C  
ATOM    264  O   CYS    28      31.899   5.183  14.110  1.00 16.98           O  
ATOM    265  CB  CYS    28      34.172   6.658  12.295  1.00 17.39           C  
ATOM    266  SG  CYS    28      35.986   6.912  12.142  1.00 20.98           S  
ATOM    267  N   ILE    29      31.448   7.378  13.699  1.00 15.71           N  
ATOM    268  CA  ILE    29      30.004   7.183  13.582  1.00 16.13           C  
ATOM    269  C   ILE    29      29.622   7.517  12.143  1.00 16.17           C  
ATOM    270  O   ILE    29      29.951   8.598  11.640  1.00 16.02           O  
ATOM    271  CB  ILE    29      29.218   8.103  14.534  1.00 15.82           C  
ATOM    272  CG1 ILE    29      29.672   7.931  15.981  1.00 15.39           C  
ATOM    273  CG2 ILE    29      27.672   7.900  14.365  1.00 16.09           C  
ATOM    274  CD1 ILE    29      29.037   8.958  16.945  1.00 16.58           C  
ATOM    275  N   LYS    30      28.964   6.585  11.458  1.00 15.88           N  
ATOM    276  CA  LYS    30      28.619   6.785  10.046  1.00 16.21           C  
ATOM    277  C   LYS    30      27.111   6.820   9.855  1.00 16.94           C  
ATOM    278  O   LYS    30      26.400   5.844  10.190  1.00 17.39           O  
ATOM    279  CB  LYS    30      29.211   5.653   9.187  1.00 16.56           C  
ATOM    280  CG  LYS    30      28.903   5.844   7.679  1.00 16.88           C  
ATOM    281  CD  LYS    30      29.732   4.833   6.862  1.00 19.31           C  
ATOM    282  CE  LYS    30      28.991   3.507   6.870  1.00 23.50           C  
ATOM    283  NZ  LYS    30      29.684   2.542   5.986  1.00 28.32           N  
ATOM    284  N   ASN    31      26.611   7.913   9.293  1.00 16.40           N  
ATOM    285  CA  ASN    31      25.209   8.052   8.889  1.00 17.24           C  
ATOM    286  C   ASN    31      25.092   7.792   7.399  1.00 16.60           C  
ATOM    287  O   ASN    31      26.100   7.564   6.719  1.00 16.88           O  
ATOM    288  CB  ASN    31      24.767   9.479   9.184  1.00 17.08           C  
ATOM    289  CG  ASN    31      24.690   9.754  10.673  1.00 17.35           C  
ATOM    290  OD1 ASN    31      24.445   8.818  11.459  1.00 18.51           O  
ATOM    291  ND2 ASN    31      24.915  11.008  11.075  1.00 17.06           N  
ATOM    292  N   TRP    32      23.871   7.844   6.911  1.00 16.43           N  
ATOM    293  CA  TRP    32      23.640   7.654   5.477  1.00 16.87           C  
ATOM    294  C   TRP    32      24.449   8.658   4.661  1.00 16.97           C  
ATOM    295  O   TRP    32      24.639   9.823   5.074  1.00 16.70           O  
ATOM    296  CB  TRP    32      22.156   7.862   5.182  1.00 17.49           C  
ATOM    297  CG  TRP    32      21.767   7.703   3.743  1.00 17.90           C  
ATOM    298  CD1 TRP    32      21.359   6.557   3.112  1.00 18.47           C  
ATOM    299  CD2 TRP    32      21.714   8.745   2.762  1.00 18.65           C  
ATOM    300  NE1 TRP    32      21.081   6.816   1.771  1.00 18.32           N  
ATOM    301  CE2 TRP    32      21.286   8.155   1.538  1.00 18.64           C  
ATOM    302  CE3 TRP    32      22.008  10.118   2.789  1.00 19.67           C  
ATOM    303  CZ2 TRP    32      21.111   8.911   0.360  1.00 20.15           C  
ATOM    304  CZ3 TRP    32      21.847  10.867   1.615  1.00 19.53           C  
ATOM    305  CH2 TRP    32      21.417  10.252   0.420  1.00 19.49           C  
ATOM    306  N   LYS    33      24.952   8.206   3.512  0.50 17.41           N  
ATOM    308  CA  LYS    33      25.520   9.105   2.498  0.50 17.81           C  
ATOM    310  C   LYS    33      25.221   8.457   1.149  0.50 17.76           C  
ATOM    312  O   LYS    33      25.111   7.233   1.067  0.50 17.30           O  
ATOM    314  CB  LYS    33      27.029   9.355   2.697  0.50 18.50           C  
ATOM    316  CG  LYS    33      27.905   8.108   2.859  0.50 17.53           C  
ATOM    318  CD  LYS    33      29.408   8.459   2.928  0.50 18.75           C  
ATOM    320  CE  LYS    33      30.249   7.268   3.434  0.50 20.65           C  
ATOM    322  NZ  LYS    33      30.410   6.095   2.495  0.50 16.18           N  
ATOM    324  N   PRO    34      25.079   9.276   0.086  1.00 18.09           N  
ATOM    325  CA  PRO    34      24.701   8.769  -1.247  1.00 17.70           C  
ATOM    326  C   PRO    34      25.425   7.508  -1.743  1.00 17.56           C  
ATOM    327  O   PRO    34      24.713   6.627  -2.293  1.00 18.77           O  
ATOM    328  CB  PRO    34      24.961   9.981  -2.167  1.00 18.28           C  
ATOM    329  CG  PRO    34      24.611  11.156  -1.256  1.00 18.87           C  
ATOM    330  CD  PRO    34      25.223  10.745   0.112  1.00 18.21           C  
ATOM    331  N   ASP    35      26.747   7.350  -1.534  1.00 17.59           N  
ATOM    332  CA  ASP    35      27.385   6.155  -2.089  1.00 18.40           C  
ATOM    333  C   ASP    35      27.192   4.889  -1.257  1.00 18.59           C  
ATOM    334  O   ASP    35      27.739   3.819  -1.588  1.00 19.50           O  
ATOM    335  CB  ASP    35      28.859   6.364  -2.436  1.00 20.01           C  
ATOM    336  CG  ASP    35      29.792   6.326  -1.216  1.00 22.64           C  
ATOM    337  OD1 ASP    35      29.327   6.354  -0.069  1.00 22.36           O  
ATOM    338  OD2 ASP    35      31.036   6.280  -1.401  1.00 23.21           O  
ATOM    339  N   ASN    36      26.428   5.029  -0.175  1.00 18.02           N  
ATOM    340  CA  ASN    36      25.942   3.845   0.531  1.00 17.85           C  
ATOM    341  C   ASN    36      24.460   3.595   0.249  1.00 17.64           C  
ATOM    342  O   ASN    36      23.911   2.588   0.689  1.00 18.05           O  
ATOM    343  CB  ASN    36      26.070   3.983   2.065  1.00 17.18           C  
ATOM    344  CG  ASN    36      27.514   3.879   2.602  1.00 21.55           C  
ATOM    345  OD1 ASN    36      27.793   4.451   3.630  1.00 30.18           O  
ATOM    346  ND2 ASN    36      28.382   3.116   1.979  1.00 22.47           N  
ATOM    347  N   ASP    37      23.767   4.533  -0.402  1.00 17.32           N  
ATOM    348  CA  ASP    37      22.368   4.259  -0.719  1.00 17.22           C  
ATOM    349  C   ASP    37      22.249   3.126  -1.732  1.00 17.35           C  
ATOM    350  O   ASP    37      23.126   2.958  -2.584  1.00 16.67           O  
ATOM    351  CB  ASP    37      21.719   5.511  -1.320  1.00 17.88           C  
ATOM    352  CG  ASP    37      20.216   5.393  -1.364  1.00 19.89           C  
ATOM    353  OD1 ASP    37      19.582   5.512  -0.288  1.00 21.62           O  
ATOM    354  OD2 ASP    37      19.642   5.158  -2.463  1.00 21.16           O  
ATOM    355  N   ILE    38      21.133   2.394  -1.689  1.00 17.76           N  
ATOM    356  CA  ILE    38      20.948   1.345  -2.698  1.00 19.14           C  
ATOM    357  C   ILE    38      21.100   1.900  -4.142  1.00 19.71           C  
ATOM    358  O   ILE    38      21.650   1.209  -5.026  1.00 20.54           O  
ATOM    359  CB  ILE    38      19.631   0.599  -2.485  1.00 20.17           C  
ATOM    360  CG1 ILE    38      19.657  -0.700  -3.319  1.00 23.22           C  
ATOM    361  CG2 ILE    38      18.432   1.531  -2.673  1.00 21.76           C  
ATOM    362  CD1 ILE    38      18.852  -1.758  -2.799  1.00 26.67           C  
ATOM    363  N   GLU    39      20.657   3.123  -4.368  0.60 18.65           N  
ATOM    365  CA  GLU    39      20.767   3.699  -5.713  0.60 19.62           C  
ATOM    367  C   GLU    39      22.157   4.152  -6.078  0.60 18.83           C  
ATOM    369  O   GLU    39      22.462   4.334  -7.279  0.60 18.82           O  
ATOM    371  CB  GLU    39      19.802   4.868  -5.875  0.60 20.14           C  
ATOM    373  CG  GLU    39      18.363   4.498  -5.623  0.60 22.99           C  
ATOM    375  CD  GLU    39      17.802   3.417  -6.560  0.60 26.07           C  
ATOM    377  OE1 GLU    39      18.361   3.139  -7.646  0.60 28.94           O  
ATOM    379  OE2 GLU    39      16.752   2.856  -6.193  0.60 29.97           O  
ATOM    381  N   GLY    40      22.978   4.383  -5.045  1.00 18.92           N  
ATOM    382  CA  GLY    40      24.291   5.006  -5.202  1.00 18.70           C  
ATOM    383  C   GLY    40      25.463   4.046  -5.085  1.00 19.12           C  
ATOM    384  O   GLY    40      26.595   4.471  -5.205  1.00 19.59           O  
ATOM    385  N   ILE    41      25.200   2.751  -4.884  0.60 18.76           N  
ATOM    387  CA  ILE    41      26.291   1.771  -4.803  0.60 18.02           C  
ATOM    389  C   ILE    41      27.102   1.716  -6.095  0.60 19.31           C  
ATOM    391  O   ILE    41      26.554   1.450  -7.164  0.60 19.38           O  
ATOM    393  CB  ILE    41      25.747   0.371  -4.471  0.60 18.50           C  
ATOM    395  CG1 ILE    41      25.154   0.371  -3.047  0.60 16.67           C  
ATOM    397  CG2 ILE    41      26.865  -0.693  -4.714  0.60 18.56           C  
ATOM    399  CD1 ILE    41      26.117   0.701  -1.919  0.60 18.37           C  
ATOM    401  N   ALA    42      28.406   1.999  -6.003  1.00 18.68           N  
ATOM    402  CA  ALA    42      29.215   2.174  -7.214  1.00 18.88           C  
ATOM    403  C   ALA    42      30.629   1.659  -7.102  1.00 18.31           C  
ATOM    404  O   ALA    42      31.295   1.493  -8.116  1.00 19.25           O  
ATOM    405  CB  ALA    42      29.242   3.688  -7.591  1.00 20.23           C  
ATOM    406  N   HIS    43      31.115   1.464  -5.871  1.00 18.00           N  
ATOM    407  CA  HIS    43      32.509   1.052  -5.664  1.00 16.78           C  
ATOM    408  C   HIS    43      32.608   0.370  -4.335  1.00 17.54           C  
ATOM    409  O   HIS    43      31.736   0.546  -3.468  1.00 17.90           O  
ATOM    410  CB  HIS    43      33.476   2.259  -5.653  1.00 17.86           C  
ATOM    411  CG  HIS    43      32.934   3.453  -4.934  1.00 19.00           C  
ATOM    412  ND1 HIS    43      32.468   4.574  -5.596  1.00 21.45           N  
ATOM    413  CD2 HIS    43      32.713   3.670  -3.607  1.00 20.87           C  
ATOM    414  CE1 HIS    43      32.005   5.442  -4.703  1.00 21.76           C  
ATOM    415  NE2 HIS    43      32.134   4.915  -3.491  1.00 19.81           N  
ATOM    416  N   LEU    44      33.631  -0.452  -4.191  1.00 16.28           N  
ATOM    417  CA  LEU    44      33.989  -1.078  -2.928  1.00 17.41           C  
ATOM    418  C   LEU    44      35.303  -0.515  -2.426  1.00 17.57           C  
ATOM    419  O   LEU    44      36.044   0.102  -3.192  1.00 17.75           O  
ATOM    420  CB  LEU    44      34.140  -2.601  -3.105  1.00 17.41           C  
ATOM    421  CG  LEU    44      32.923  -3.314  -3.708  1.00 17.06           C  
ATOM    422  CD1 LEU    44      33.208  -4.832  -3.740  1.00 18.99           C  
ATOM    423  CD2 LEU    44      31.642  -3.059  -2.890  1.00 17.87           C  
ATOM    424  N   GLU    45      35.613  -0.780  -1.153  1.00 17.32           N  
ATOM    425  CA  GLU    45      36.838  -0.282  -0.525  1.00 17.85           C  
ATOM    426  C   GLU    45      37.617  -1.484  -0.022  1.00 17.53           C  
ATOM    427  O   GLU    45      37.061  -2.561   0.258  1.00 17.19           O  
ATOM    428  CB  GLU    45      36.464   0.633   0.652  1.00 17.71           C  
ATOM    429  CG  GLU    45      37.645   1.395   1.289  1.00 20.73           C  
ATOM    430  CD  GLU    45      37.161   2.412   2.345  1.00 20.50           C  
ATOM    431  OE1 GLU    45      35.935   2.549   2.565  1.00 24.99           O  
ATOM    432  OE2 GLU    45      38.030   3.068   2.921  1.00 32.85           O  
ATOM    433  N   ILE    46      38.916  -1.284   0.170  1.00 18.33           N  
ATOM    434  CA  ILE    46      39.732  -2.349   0.745  1.00 17.98           C  
ATOM    435  C   ILE    46      40.781  -1.674   1.626  1.00 18.08           C  
ATOM    436  O   ILE    46      41.329  -0.614   1.260  1.00 18.26           O  
ATOM    437  CB  ILE    46      40.416  -3.214  -0.352  1.00 18.64           C  
ATOM    438  CG1 ILE    46      41.137  -4.429   0.253  1.00 18.66           C  
ATOM    439  CG2 ILE    46      41.422  -2.371  -1.208  1.00 19.08           C  
ATOM    440  CD1 ILE    46      41.531  -5.521  -0.807  1.00 19.38           C  
ATOM    441  N   HIS    47      41.048  -2.282   2.786  1.00 16.96           N  
ATOM    442  CA  HIS    47      42.132  -1.817   3.653  1.00 17.05           C  
ATOM    443  C   HIS    47      43.253  -2.845   3.589  1.00 18.55           C  
ATOM    444  O   HIS    47      43.075  -4.019   3.928  1.00 19.63           O  
ATOM    445  CB  HIS    47      41.662  -1.750   5.117  1.00 16.94           C  
ATOM    446  CG  HIS    47      40.576  -0.758   5.342  1.00 18.33           C  
ATOM    447  ND1 HIS    47      40.674   0.562   4.944  1.00 20.82           N  
ATOM    448  CD2 HIS    47      39.376  -0.884   5.957  1.00 18.76           C  
ATOM    449  CE1 HIS    47      39.567   1.204   5.295  1.00 22.99           C  
ATOM    450  NE2 HIS    47      38.777   0.359   5.929  1.00 21.68           N  
ATOM    451  N   HIS    48      44.436  -2.396   3.203  1.00 19.42           N  
ATOM    452  CA  HIS    48      45.560  -3.339   3.148  1.00 19.25           C  
ATOM    453  C   HIS    48      46.243  -3.658   4.465  1.00 20.51           C  
ATOM    454  O   HIS    48      46.962  -4.659   4.545  1.00 22.55           O  
ATOM    455  CB  HIS    48      46.594  -2.852   2.116  1.00 19.61           C  
ATOM    456  CG  HIS    48      46.001  -2.629   0.756  1.00 19.32           C  
ATOM    457  ND1 HIS    48      45.428  -3.647   0.021  1.00 21.37           N  
ATOM    458  CD2 HIS    48      45.871  -1.508   0.005  1.00 21.07           C  
ATOM    459  CE1 HIS    48      44.980  -3.168  -1.128  1.00 23.63           C  
ATOM    460  NE2 HIS    48      45.210  -1.868  -1.151  1.00 20.64           N  
ATOM    461  N   SER    49      45.998  -2.843   5.488  0.50 19.93           N  
ATOM    463  CA  SER    49      46.805  -2.926   6.702  0.50 19.80           C  
ATOM    465  C   SER    49      46.013  -2.977   8.005  0.50 19.98           C  
ATOM    467  O   SER    49      46.602  -3.081   9.079  0.50 19.76           O  
ATOM    469  CB  SER    49      47.783  -1.755   6.733  0.50 21.12           C  
ATOM    471  OG  SER    49      48.664  -1.820   5.623  0.50 20.88           O  
ATOM    473  N   THR    50      44.689  -2.893   7.908  1.00 19.07           N  
ATOM    474  CA  THR    50      43.835  -2.910   9.105  1.00 18.53           C  
ATOM    475  C   THR    50      42.602  -3.775   8.911  1.00 18.49           C  
ATOM    476  O   THR    50      42.030  -3.815   7.816  1.00 18.74           O  
ATOM    477  CB  THR    50      43.401  -1.487   9.583  1.00 19.33           C  
ATOM    478  OG1 THR    50      42.743  -1.587  10.864  1.00 18.04           O  
ATOM    479  CG2 THR    50      42.423  -0.839   8.629  1.00 18.56           C  
ATOM    480  N   ASP    51      42.210  -4.431   9.995  1.00 17.41           N  
ATOM    481  CA  ASP    51      40.881  -4.992  10.096  1.00 17.63           C  
ATOM    482  C   ASP    51      39.907  -3.856  10.464  1.00 17.46           C  
ATOM    483  O   ASP    51      40.329  -2.803  10.977  1.00 17.76           O  
ATOM    484  CB  ASP    51      40.800  -6.071  11.184  1.00 17.59           C  
ATOM    485  CG  ASP    51      41.726  -7.267  10.947  1.00 19.72           C  
ATOM    486  OD1 ASP    51      42.217  -7.479   9.811  1.00 20.29           O  
ATOM    487  OD2 ASP    51      41.972  -8.026  11.927  1.00 20.23           O  
ATOM    488  N   GLU    52      38.607  -4.071  10.242  1.00 16.99           N  
ATOM    489  CA  GLU    52      37.626  -3.062  10.649  1.00 16.56           C  
ATOM    490  C   GLU    52      36.385  -3.735  11.205  1.00 16.04           C  
ATOM    491  O   GLU    52      35.928  -4.744  10.655  1.00 16.25           O  
ATOM    492  CB  GLU    52      37.261  -2.210   9.428  1.00 17.33           C  
ATOM    493  CG  GLU    52      36.173  -1.163   9.732  1.00 16.96           C  
ATOM    494  CD  GLU    52      35.956  -0.161   8.605  1.00 20.76           C  
ATOM    495  OE1 GLU    52      36.723  -0.186   7.649  1.00 25.16           O  
ATOM    496  OE2 GLU    52      35.003   0.653   8.675  1.00 22.73           O  
ATOM    497  N   GLN    53      35.891  -3.230  12.338  1.00 15.29           N  
ATOM    498  CA  GLN    53      34.665  -3.780  12.905  1.00 15.57           C  
ATOM    499  C   GLN    53      33.520  -2.794  12.783  1.00 15.96           C  
ATOM    500  O   GLN    53      33.738  -1.562  12.838  1.00 16.46           O  
ATOM    501  CB  GLN    53      34.829  -4.170  14.375  1.00 16.29           C  
ATOM    502  CG  GLN    53      35.923  -5.262  14.568  1.00 16.43           C  
ATOM    503  CD  GLN    53      37.313  -4.679  14.546  1.00 16.79           C  
ATOM    504  OE1 GLN    53      37.608  -3.724  15.302  1.00 18.53           O  
ATOM    505  NE2 GLN    53      38.222  -5.243  13.706  1.00 17.69           N  
ATOM    506  N   PHE    54      32.304  -3.328  12.595  1.00 15.22           N  
ATOM    507  CA  PHE    54      31.127  -2.504  12.339  1.00 16.12           C  
ATOM    508  C   PHE    54      30.054  -2.893  13.333  1.00 16.75           C  
ATOM    509  O   PHE    54      29.820  -4.072  13.596  1.00 16.26           O  
ATOM    510  CB  PHE    54      30.589  -2.820  10.928  1.00 18.13           C  
ATOM    511  CG  PHE    54      31.582  -2.567   9.813  1.00 18.64           C  
ATOM    512  CD1 PHE    54      31.539  -1.357   9.108  1.00 23.57           C  
ATOM    513  CD2 PHE    54      32.565  -3.497   9.498  1.00 20.61           C  
ATOM    514  CE1 PHE    54      32.466  -1.122   8.039  1.00 23.85           C  
ATOM    515  CE2 PHE    54      33.469  -3.245   8.445  1.00 21.03           C  
ATOM    516  CZ  PHE    54      33.403  -2.103   7.732  1.00 23.10           C  
ATOM    517  N   ILE    55      29.342  -1.885  13.826  1.00 16.51           N  
ATOM    518  CA  ILE    55      28.284  -2.074  14.793  1.00 17.03           C  
ATOM    519  C   ILE    55      27.113  -1.256  14.344  1.00 17.63           C  
ATOM    520  O   ILE    55      27.219  -0.042  14.280  1.00 19.02           O  
ATOM    521  CB  ILE    55      28.722  -1.606  16.189  1.00 17.26           C  
ATOM    522  CG1 ILE    55      29.903  -2.450  16.650  1.00 19.11           C  
ATOM    523  CG2 ILE    55      27.555  -1.596  17.205  1.00 20.27           C  
ATOM    524  CD1 ILE    55      30.713  -1.812  17.871  1.00 21.34           C  
ATOM    525  N   LEU    56      25.977  -1.905  14.085  1.00 16.33           N  
ATOM    526  CA  LEU    56      24.747  -1.204  13.647  1.00 16.30           C  
ATOM    527  C   LEU    56      24.031  -0.642  14.872  1.00 18.33           C  
ATOM    528  O   LEU    56      23.734  -1.411  15.823  1.00 18.34           O  
ATOM    529  CB  LEU    56      23.830  -2.203  12.892  1.00 16.00           C  
ATOM    530  CG  LEU    56      22.516  -1.620  12.334  1.00 17.40           C  
ATOM    531  CD1 LEU    56      22.773  -0.483  11.297  1.00 17.23           C  
ATOM    532  CD2 LEU    56      21.728  -2.718  11.668  1.00 17.81           C  
ATOM    533  N   SER    57      23.668   0.645  14.801  1.00 16.83           N  
ATOM    534  CA  SER    57      22.992   1.328  15.912  1.00 17.51           C  
ATOM    535  C   SER    57      21.512   1.580  15.625  1.00 17.72           C  
ATOM    536  O   SER    57      20.643   1.305  16.491  1.00 19.77           O  
ATOM    537  CB  SER    57      23.699   2.672  16.203  1.00 18.26           C  
ATOM    538  OG  SER    57      23.076   3.279  17.342  1.00 19.31           O  
ATOM    539  N   ALA    58      21.206   2.078  14.435  1.00 17.62           N  
ATOM    540  CA  ALA    58      19.819   2.443  14.049  1.00 17.30           C  
ATOM    541  C   ALA    58      19.572   2.038  12.608  1.00 17.02           C  
ATOM    542  O   ALA    58      20.517   1.998  11.804  1.00 17.01           O  
ATOM    543  CB  ALA    58      19.608   3.979  14.147  1.00 18.83           C  
ATOM    544  N   GLY    59      18.307   1.766  12.274  1.00 17.28           N  
ATOM    545  CA  GLY    59      17.964   1.495  10.891  1.00 16.19           C  
ATOM    546  C   GLY    59      18.505   0.148  10.443  1.00 16.70           C  
ATOM    547  O   GLY    59      18.883  -0.706  11.262  1.00 18.82           O  
ATOM    548  N   LYS    60      18.516  -0.003   9.130  1.00 17.10           N  
ATOM    549  CA  LYS    60      18.939  -1.270   8.509  1.00 17.10           C  
ATOM    550  C   LYS    60      20.211  -1.057   7.731  1.00 16.91           C  
ATOM    551  O   LYS    60      20.491   0.048   7.223  1.00 17.29           O  
ATOM    552  CB  LYS    60      17.868  -1.789   7.539  1.00 17.78           C  
ATOM    553  CG  LYS    60      16.534  -2.132   8.176  1.00 19.75           C  
ATOM    554  CD  LYS    60      15.542  -2.331   7.033  1.00 23.56           C  
ATOM    555  CE  LYS    60      14.212  -2.731   7.566  1.00 28.36           C  
ATOM    556  NZ  LYS    60      13.370  -2.904   6.333  1.00 31.59           N  
ATOM    557  N   ALA    61      21.001  -2.123   7.606  1.00 16.77           N  
ATOM    558  CA  ALA    61      22.221  -2.028   6.802  1.00 16.67           C  
ATOM    559  C   ALA    61      22.629  -3.387   6.313  1.00 15.90           C  
ATOM    560  O   ALA    61      22.370  -4.390   6.973  1.00 16.52           O  
ATOM    561  CB  ALA    61      23.365  -1.431   7.605  1.00 17.21           C  
ATOM    562  N   ILE    62      23.253  -3.381   5.140  1.00 15.63           N  
ATOM    563  CA  ILE    62      23.855  -4.564   4.557  1.00 16.08           C  
ATOM    564  C   ILE    62      25.346  -4.326   4.359  1.00 16.56           C  
ATOM    565  O   ILE    62      25.774  -3.236   3.948  1.00 17.64           O  
ATOM    566  CB  ILE    62      23.180  -4.862   3.187  1.00 16.18           C  
ATOM    567  CG1 ILE    62      21.712  -5.258   3.409  1.00 16.39           C  
ATOM    568  CG2 ILE    62      23.914  -5.966   2.429  1.00 17.86           C  
ATOM    569  CD1 ILE    62      20.897  -5.187   2.113  1.00 18.67           C  
ATOM    570  N   LEU    63      26.139  -5.328   4.702  0.60 17.10           N  
ATOM    572  CA  LEU    63      27.582  -5.258   4.487  0.60 17.07           C  
ATOM    574  C   LEU    63      27.917  -6.113   3.262  0.60 17.18           C  
ATOM    576  O   LEU    63      27.628  -7.325   3.249  0.60 17.35           O  
ATOM    578  CB  LEU    63      28.314  -5.806   5.717  0.60 17.84           C  
ATOM    580  CG  LEU    63      29.835  -5.699   5.783  0.60 19.15           C  
ATOM    582  CD1 LEU    63      30.335  -4.263   5.645  0.60 20.68           C  
ATOM    584  CD2 LEU    63      30.261  -6.285   7.125  0.60 20.79           C  
ATOM    586  N   ILE    64      28.462  -5.489   2.213  1.00 17.14           N  
ATOM    587  CA  ILE    64      28.939  -6.178   1.043  1.00 17.08           C  
ATOM    588  C   ILE    64      30.369  -6.603   1.362  1.00 17.38           C  
ATOM    589  O   ILE    64      31.166  -5.790   1.854  1.00 17.79           O  
ATOM    590  CB  ILE    64      29.025  -5.221  -0.204  1.00 17.12           C  
ATOM    591  CG1 ILE    64      27.653  -4.600  -0.477  1.00 20.00           C  
ATOM    592  CG2 ILE    64      29.565  -5.973  -1.440  1.00 18.04           C  
ATOM    593  CD1 ILE    64      27.724  -3.368  -1.404  1.00 18.37           C  
ATOM    594  N   THR    65      30.692  -7.855   1.036  1.00 17.86           N  
ATOM    595  CA  THR    65      32.085  -8.292   1.054  1.00 18.12           C  
ATOM    596  C   THR    65      32.351  -8.962  -0.277  1.00 18.58           C  
ATOM    597  O   THR    65      31.426  -9.489  -0.913  1.00 19.44           O  
ATOM    598  CB  THR    65      32.442  -9.196   2.224  1.00 18.08           C  
ATOM    599  OG1 THR    65      31.489 -10.258   2.313  1.00 17.62           O  
ATOM    600  CG2 THR    65      32.480  -8.375   3.559  1.00 18.10           C  
ATOM    601  N   ALA    66      33.604  -8.910  -0.732  1.00 18.05           N  
ATOM    602  CA  ALA    66      33.887  -9.450  -2.064  1.00 19.25           C  
ATOM    603  C   ALA    66      35.328  -9.878  -2.199  1.00 20.53           C  
ATOM    604  O   ALA    66      36.212  -9.407  -1.476  1.00 19.89           O  
ATOM    605  CB  ALA    66      33.524  -8.414  -3.132  1.00 18.61           C  
ATOM    606  N   GLU    67      35.552 -10.810  -3.119  0.50 21.75           N  
ATOM    608  CA  GLU    67      36.905 -11.053  -3.604  0.50 23.27           C  
ATOM    610  C   GLU    67      36.961 -10.670  -5.072  0.50 23.78           C  
ATOM    612  O   GLU    67      35.966 -10.742  -5.801  0.50 23.10           O  
ATOM    614  CB  GLU    67      37.331 -12.510  -3.419  0.50 24.24           C  
ATOM    616  CG  GLU    67      36.394 -13.509  -4.035  0.50 24.63           C  
ATOM    618  CD  GLU    67      37.087 -14.820  -4.402  0.50 28.22           C  
ATOM    620  OE1 GLU    67      38.147 -15.137  -3.823  0.50 32.90           O  
ATOM    622  OE2 GLU    67      36.559 -15.533  -5.271  0.50 28.66           O  
ATOM    624  N   LYS    68      38.146 -10.272  -5.497  1.00 25.28           N  
ATOM    625  CA  LYS    68      38.360  -9.857  -6.863  1.00 28.72           C  
ATOM    626  C   LYS    68      39.027 -11.029  -7.554  1.00 32.09           C  
ATOM    627  O   LYS    68      40.039 -11.551  -7.074  1.00 31.54           O  
ATOM    628  CB  LYS    68      39.241  -8.601  -6.884  1.00 29.61           C  
ATOM    629  CG  LYS    68      39.108  -7.741  -8.117  1.00 31.87           C  
ATOM    630  CD  LYS    68      40.084  -6.600  -7.985  1.00 36.13           C  
ATOM    631  CE  LYS    68      39.622  -5.388  -8.724  1.00 38.28           C  
ATOM    632  NZ  LYS    68      40.805  -4.612  -9.152  1.00 39.70           N  
ATOM    633  N   GLU    69      38.424 -11.473  -8.649  1.00 35.03           N  
ATOM    634  CA  GLU    69      38.917 -12.620  -9.406  1.00 39.92           C  
ATOM    635  C   GLU    69      39.030 -12.134 -10.841  1.00 40.91           C  
ATOM    636  O   GLU    69      38.033 -11.714 -11.454  1.00 41.18           O  
ATOM    637  CB  GLU    69      37.931 -13.779  -9.292  1.00 39.88           C  
ATOM    638  CG  GLU    69      38.377 -15.100  -9.892  1.00 43.51           C  
ATOM    639  CD  GLU    69      37.375 -16.216  -9.594  1.00 44.52           C  
ATOM    640  OE1 GLU    69      36.155 -16.024  -9.860  1.00 48.99           O  
ATOM    641  OE2 GLU    69      37.811 -17.284  -9.089  1.00 51.23           O  
ATOM    642  N   ASN    70      40.251 -12.181 -11.367  1.00 42.55           N  
ATOM    643  CA  ASN    70      40.575 -11.491 -12.608  1.00 43.92           C  
ATOM    644  C   ASN    70      40.117 -10.034 -12.458  1.00 43.58           C  
ATOM    645  O   ASN    70      40.566  -9.346 -11.534  1.00 44.59           O  
ATOM    646  CB  ASN    70      39.956 -12.229 -13.798  1.00 44.78           C  
ATOM    647  CG  ASN    70      40.392 -13.702 -13.857  1.00 47.87           C  
ATOM    648  OD1 ASN    70      39.561 -14.621 -13.749  1.00 50.12           O  
ATOM    649  ND2 ASN    70      41.705 -13.928 -13.996  1.00 49.37           N  
ATOM    650  N   ASP    71      39.205  -9.566 -13.303  1.00 42.45           N  
ATOM    651  CA  ASP    71      38.738  -8.185 -13.157  1.00 40.43           C  
ATOM    652  C   ASP    71      37.290  -8.046 -12.683  1.00 37.49           C  
ATOM    653  O   ASP    71      36.686  -6.980 -12.864  1.00 38.69           O  
ATOM    654  CB  ASP    71      38.957  -7.396 -14.460  1.00 42.43           C  
ATOM    655  CG  ASP    71      40.191  -6.496 -14.398  1.00 45.99           C  
ATOM    656  OD1 ASP    71      40.131  -5.434 -13.716  1.00 49.92           O  
ATOM    657  OD2 ASP    71      41.221  -6.850 -15.031  1.00 50.27           O  
ATOM    658  N   LYS    72      36.767  -9.099 -12.049  0.50 35.27           N  
ATOM    660  CA  LYS    72      35.371  -9.161 -11.600  0.50 32.39           C  
ATOM    662  C   LYS    72      35.275  -9.506 -10.110  0.50 29.34           C  
ATOM    664  O   LYS    72      36.090 -10.275  -9.587  0.50 28.53           O  
ATOM    666  CB  LYS    72      34.591 -10.201 -12.415  0.50 33.11           C  
ATOM    668  CG  LYS    72      34.608  -9.996 -13.937  0.50 35.22           C  
ATOM    670  CD  LYS    72      33.882  -8.716 -14.352  0.50 38.16           C  
ATOM    672  CE  LYS    72      34.141  -8.381 -15.814  0.50 39.07           C  
ATOM    674  NZ  LYS    72      33.714  -6.985 -16.107  0.50 40.06           N  
ATOM    676  N   PHE    73      34.262  -8.964  -9.438  1.00 26.19           N  
ATOM    677  CA  PHE    73      34.074  -9.258  -8.021  1.00 23.01           C  
ATOM    678  C   PHE    73      33.128 -10.431  -7.845  1.00 22.56           C  
ATOM    679  O   PHE    73      32.081 -10.476  -8.500  1.00 23.23           O  
ATOM    680  CB  PHE    73      33.469  -8.031  -7.331  1.00 20.77           C  
ATOM    681  CG  PHE    73      34.463  -6.919  -7.084  1.00 21.12           C  
ATOM    682  CD1 PHE    73      35.500  -7.085  -6.160  1.00 19.24           C  
ATOM    683  CD2 PHE    73      34.334  -5.723  -7.758  1.00 21.62           C  
ATOM    684  CE1 PHE    73      36.375  -6.072  -5.895  1.00 21.26           C  
ATOM    685  CE2 PHE    73      35.228  -4.661  -7.503  1.00 22.84           C  
ATOM    686  CZ  PHE    73      36.266  -4.864  -6.584  1.00 21.71           C  
ATOM    687  N   ASN    74      33.495 -11.335  -6.947  1.00 21.12           N  
ATOM    688  CA  ASN    74      32.560 -12.346  -6.421  1.00 20.80           C  
ATOM    689  C   ASN    74      31.983 -11.719  -5.159  1.00 20.55           C  
ATOM    690  O   ASN    74      32.750 -11.406  -4.236  1.00 22.73           O  
ATOM    691  CB  ASN    74      33.309 -13.625  -6.086  1.00 20.81           C  
ATOM    692  CG  ASN    74      33.834 -14.312  -7.327  1.00 25.44           C  
ATOM    693  OD1 ASN    74      33.216 -14.214  -8.401  1.00 27.61           O  
ATOM    694  ND2 ASN    74      34.993 -14.981  -7.207  1.00 30.25           N  
ATOM    695  N   ILE    75      30.669 -11.539  -5.100  1.00 18.59           N  
ATOM    696  CA  ILE    75      30.034 -10.671  -4.091  1.00 18.13           C  
ATOM    697  C   ILE    75      29.212 -11.482  -3.061  1.00 19.08           C  
ATOM    698  O   ILE    75      28.517 -12.471  -3.419  1.00 20.00           O  
ATOM    699  CB  ILE    75      29.156  -9.640  -4.810  1.00 18.07           C  
ATOM    700  CG1 ILE    75      30.044  -8.658  -5.589  1.00 20.24           C  
ATOM    701  CG2 ILE    75      28.174  -8.940  -3.848  1.00 20.77           C  
ATOM    702  CD1 ILE    75      29.365  -8.065  -6.753  1.00 22.60           C  
ATOM    703  N   GLU    76      29.308 -11.084  -1.800  0.60 18.87           N  
ATOM    705  CA  GLU    76      28.466 -11.612  -0.735  0.60 19.16           C  
ATOM    707  C   GLU    76      27.745 -10.407  -0.128  0.60 18.09           C  
ATOM    709  O   GLU    76      28.305  -9.282  -0.057  0.60 17.76           O  
ATOM    711  CB  GLU    76      29.339 -12.289   0.332  0.60 20.14           C  
ATOM    713  CG  GLU    76      28.599 -12.731   1.582  0.60 23.37           C  
ATOM    715  CD  GLU    76      27.702 -13.942   1.355  0.60 29.19           C  
ATOM    717  OE1 GLU    76      27.747 -14.565   0.258  0.60 32.28           O  
ATOM    719  OE2 GLU    76      26.959 -14.270   2.308  0.60 32.34           O  
ATOM    721  N   LEU    77      26.507 -10.648   0.309  1.00 17.46           N  
ATOM    722  CA  LEU    77      25.737  -9.644   1.062  1.00 16.79           C  
ATOM    723  C   LEU    77      25.380 -10.220   2.405  1.00 17.12           C  
ATOM    724  O   LEU    77      24.908 -11.374   2.464  1.00 18.05           O  
ATOM    725  CB  LEU    77      24.444  -9.268   0.347  1.00 17.08           C  
ATOM    726  CG  LEU    77      24.616  -8.756  -1.076  1.00 19.68           C  
ATOM    727  CD1 LEU    77      23.246  -8.352  -1.603  1.00 21.69           C  
ATOM    728  CD2 LEU    77      25.579  -7.545  -1.129  1.00 20.67           C  
ATOM    729  N   THR    78      25.559  -9.426   3.459  1.00 16.43           N  
ATOM    730  CA  THR    78      25.221  -9.860   4.834  1.00 15.99           C  
ATOM    731  C   THR    78      24.328  -8.790   5.447  1.00 15.43           C  
ATOM    732  O   THR    78      24.749  -7.629   5.601  1.00 17.08           O  
ATOM    733  CB  THR    78      26.486  -9.986   5.646  1.00 18.10           C  
ATOM    734  OG1 THR    78      27.333 -10.990   5.038  1.00 18.81           O  
ATOM    735  CG2 THR    78      26.154 -10.425   7.078  1.00 19.52           C  
ATOM    736  N   LEU    79      23.096  -9.173   5.798  1.00 16.06           N  
ATOM    737  CA  LEU    79      22.203  -8.219   6.475  1.00 16.46           C  
ATOM    738  C   LEU    79      22.688  -8.061   7.930  1.00 16.23           C  
ATOM    739  O   LEU    79      22.753  -9.061   8.674  1.00 18.78           O  
ATOM    740  CB  LEU    79      20.763  -8.778   6.464  1.00 16.37           C  
ATOM    741  CG  LEU    79      19.661  -7.907   7.062  1.00 17.37           C  
ATOM    742  CD1 LEU    79      19.486  -6.552   6.335  1.00 17.46           C  
ATOM    743  CD2 LEU    79      18.339  -8.679   7.091  1.00 17.44           C  
ATOM    744  N   MET    80      23.043  -6.836   8.320  1.00 17.05           N  
ATOM    745  CA  MET    80      23.489  -6.622   9.699  1.00 17.35           C  
ATOM    746  C   MET    80      22.360  -6.683  10.705  1.00 17.54           C  
ATOM    747  O   MET    80      21.228  -6.227  10.449  1.00 17.87           O  
ATOM    748  CB  MET    80      24.216  -5.268   9.819  1.00 17.15           C  
ATOM    749  CG  MET    80      25.447  -5.249   9.025  1.00 18.39           C  
ATOM    750  SD  MET    80      26.260  -3.413   9.223  0.65 23.14          SE  
ATOM    751  CE  MET    80      27.062  -3.666  10.979  1.00 20.64           C  
ATOM    752  N   GLU    81      22.687  -7.257  11.866  0.60 18.87           N  
ATOM    754  CA  GLU    81      21.777  -7.318  12.996  0.60 20.00           C  
ATOM    756  C   GLU    81      22.268  -6.434  14.122  0.60 18.60           C  
ATOM    758  O   GLU    81      23.461  -6.432  14.462  0.60 18.57           O  
ATOM    760  CB  GLU    81      21.696  -8.754  13.501  0.60 19.45           C  
ATOM    762  CG  GLU    81      21.101  -9.688  12.452  0.60 22.13           C  
ATOM    764  CD  GLU    81      21.019 -11.157  12.881  0.60 24.43           C  
ATOM    766  OE1 GLU    81      20.800 -11.435  14.084  0.60 29.15           O  
ATOM    768  OE2 GLU    81      21.169 -12.041  12.000  0.60 30.97           O  
ATOM    770  N   LYS    82      21.350  -5.682  14.714  0.60 18.42           N  
ATOM    772  CA  LYS    82      21.673  -4.932  15.912  0.60 18.51           C  
ATOM    774  C   LYS    82      21.959  -5.956  17.026  0.60 18.11           C  
ATOM    776  O   LYS    82      21.220  -6.944  17.204  0.60 18.72           O  
ATOM    778  CB  LYS    82      20.511  -4.024  16.313  0.60 18.81           C  
ATOM    780  CG  LYS    82      20.367  -2.809  15.416  0.60 18.90           C  
ATOM    782  CD  LYS    82      19.161  -1.970  15.834  0.60 20.64           C  
ATOM    784  CE  LYS    82      18.782  -1.014  14.727  0.60 21.42           C  
ATOM    786  NZ  LYS    82      18.024  -1.683  13.641  0.60 23.36           N  
ATOM    788  N   GLY    83      23.046  -5.688  17.747  1.00 17.31           N  
ATOM    789  CA  GLY    83      23.527  -6.516  18.854  1.00 17.58           C  
ATOM    790  C   GLY    83      24.740  -7.351  18.496  1.00 17.40           C  
ATOM    791  O   GLY    83      25.387  -7.936  19.376  1.00 18.34           O  
ATOM    792  N   LYS    84      25.042  -7.417  17.207  1.00 16.76           N  
ATOM    793  CA  LYS    84      26.235  -8.150  16.738  1.00 16.39           C  
ATOM    794  C   LYS    84      27.368  -7.205  16.328  1.00 16.76           C  
ATOM    795  O   LYS    84      27.148  -5.985  16.124  1.00 18.19           O  
ATOM    796  CB  LYS    84      25.878  -9.082  15.566  1.00 17.48           C  
ATOM    797  CG  LYS    84      24.850 -10.156  15.982  1.00 18.67           C  
ATOM    798  CD  LYS    84      24.706 -11.195  14.880  1.00 22.19           C  
ATOM    799  CE  LYS    84      23.681 -12.239  15.269  1.00 28.66           C  
ATOM    800  NZ  LYS    84      23.635 -13.207  14.106  1.00 32.70           N  
ATOM    801  N   VAL    85      28.578  -7.780  16.255  1.00 16.21           N  
ATOM    802  CA  VAL    85      29.724  -7.040  15.762  1.00 15.81           C  
ATOM    803  C   VAL    85      30.213  -7.783  14.514  1.00 16.70           C  
ATOM    804  O   VAL    85      30.260  -9.029  14.520  1.00 17.45           O  
ATOM    805  CB  VAL    85      30.846  -6.992  16.798  1.00 16.74           C  
ATOM    806  CG1 VAL    85      32.078  -6.270  16.245  1.00 17.88           C  
ATOM    807  CG2 VAL    85      30.371  -6.241  18.061  1.00 17.90           C  
ATOM    808  N   TYR    86      30.536  -7.031  13.450  1.00 15.64           N  
ATOM    809  CA  TYR    86      31.005  -7.610  12.178  1.00 17.07           C  
ATOM    810  C   TYR    86      32.428  -7.196  11.980  1.00 17.74           C  
ATOM    811  O   TYR    86      32.784  -6.042  12.192  1.00 18.97           O  
ATOM    812  CB  TYR    86      30.128  -7.093  11.010  1.00 16.66           C  
ATOM    813  CG  TYR    86      28.709  -7.580  11.209  1.00 15.88           C  
ATOM    814  CD1 TYR    86      28.249  -8.706  10.552  1.00 16.34           C  
ATOM    815  CD2 TYR    86      27.809  -6.907  12.072  1.00 16.28           C  
ATOM    816  CE1 TYR    86      26.958  -9.193  10.759  1.00 14.73           C  
ATOM    817  CE2 TYR    86      26.521  -7.416  12.280  1.00 15.61           C  
ATOM    818  CZ  TYR    86      26.114  -8.585  11.633  1.00 14.83           C  
ATOM    819  OH  TYR    86      24.834  -9.091  11.844  1.00 17.74           O  
ATOM    820  N   ASN    87      33.252  -8.143  11.539  1.00 16.15           N  
ATOM    821  CA  ASN    87      34.647  -7.813  11.249  1.00 16.28           C  
ATOM    822  C   ASN    87      34.967  -8.085   9.791  1.00 16.88           C  
ATOM    823  O   ASN    87      34.703  -9.187   9.297  1.00 16.54           O  
ATOM    824  CB  ASN    87      35.566  -8.680  12.140  1.00 16.99           C  
ATOM    825  CG  ASN    87      37.049  -8.507  11.803  1.00 18.96           C  
ATOM    826  OD1 ASN    87      37.591  -7.425  11.920  1.00 17.98           O  
ATOM    827  ND2 ASN    87      37.712  -9.592  11.402  1.00 18.13           N  
ATOM    828  N   VAL    88      35.546  -7.085   9.132  1.00 16.41           N  
ATOM    829  CA  VAL    88      36.085  -7.245   7.770  1.00 16.80           C  
ATOM    830  C   VAL    88      37.602  -7.279   7.914  1.00 17.60           C  
ATOM    831  O   VAL    88      38.200  -6.260   8.236  1.00 16.72           O  
ATOM    832  CB  VAL    88      35.655  -6.066   6.852  1.00 16.61           C  
ATOM    833  CG1 VAL    88      36.350  -6.207   5.486  1.00 17.54           C  
ATOM    834  CG2 VAL    88      34.145  -6.101   6.660  1.00 18.60           C  
ATOM    835  N   PRO    89      38.226  -8.441   7.691  1.00 17.46           N  
ATOM    836  CA  PRO    89      39.693  -8.472   7.841  1.00 18.21           C  
ATOM    837  C   PRO    89      40.371  -7.648   6.736  1.00 17.75           C  
ATOM    838  O   PRO    89      39.796  -7.459   5.639  1.00 17.90           O  
ATOM    839  CB  PRO    89      40.068  -9.953   7.641  1.00 19.26           C  
ATOM    840  CG  PRO    89      38.811 -10.684   7.578  1.00 22.10           C  
ATOM    841  CD  PRO    89      37.644  -9.760   7.350  1.00 19.36           C  
ATOM    842  N   ALA    90      41.602  -7.223   7.002  1.00 17.81           N  
ATOM    843  CA  ALA    90      42.410  -6.568   5.984  1.00 17.60           C  
ATOM    844  C   ALA    90      42.467  -7.417   4.715  1.00 17.75           C  
ATOM    845  O   ALA    90      42.462  -8.685   4.788  1.00 18.42           O  
ATOM    846  CB  ALA    90      43.820  -6.416   6.507  1.00 17.36           C  
ATOM    847  N   GLU    91      42.491  -6.715   3.575  1.00 17.80           N  
ATOM    848  CA  GLU    91      42.560  -7.340   2.249  1.00 19.04           C  
ATOM    849  C   GLU    91      41.258  -7.999   1.794  1.00 19.36           C  
ATOM    850  O   GLU    91      41.232  -8.778   0.813  1.00 21.60           O  
ATOM    851  CB  GLU    91      43.726  -8.338   2.133  1.00 19.33           C  
ATOM    852  CG  GLU    91      45.078  -7.770   2.532  1.00 21.26           C  
ATOM    853  CD  GLU    91      45.639  -6.748   1.523  1.00 23.31           C  
ATOM    854  OE1 GLU    91      44.913  -6.288   0.616  1.00 24.66           O  
ATOM    855  OE2 GLU    91      46.819  -6.375   1.678  1.00 27.27           O  
ATOM    856  N   CYS    92      40.167  -7.659   2.459  1.00 19.41           N  
ATOM    857  CA  CYS    92      38.849  -8.089   2.002  1.00 18.30           C  
ATOM    858  C   CYS    92      38.121  -6.846   1.474  1.00 17.59           C  
ATOM    859  O   CYS    92      37.976  -5.859   2.211  1.00 18.82           O  
ATOM    860  CB  CYS    92      38.069  -8.689   3.170  1.00 18.57           C  
ATOM    861  SG  CYS    92      36.398  -9.298   2.672  1.00 22.65           S  
ATOM    862  N   TRP    93      37.619  -6.904   0.239  1.00 16.71           N  
ATOM    863  CA  TRP    93      36.846  -5.767  -0.287  1.00 16.83           C  
ATOM    864  C   TRP    93      35.498  -5.678   0.429  1.00 17.61           C  
ATOM    865  O   TRP    93      34.892  -6.700   0.734  1.00 17.54           O  
ATOM    866  CB  TRP    93      36.578  -6.006  -1.784  1.00 17.22           C  
ATOM    867  CG  TRP    93      37.800  -5.880  -2.605  1.00 17.28           C  
ATOM    868  CD1 TRP    93      38.625  -6.899  -3.028  1.00 18.03           C  
ATOM    869  CD2 TRP    93      38.359  -4.657  -3.124  1.00 17.06           C  
ATOM    870  NE1 TRP    93      39.685  -6.363  -3.791  1.00 18.99           N  
ATOM    871  CE2 TRP    93      39.519  -5.001  -3.878  1.00 19.05           C  
ATOM    872  CE3 TRP    93      37.968  -3.311  -3.050  1.00 18.33           C  
ATOM    873  CZ2 TRP    93      40.312  -4.031  -4.522  1.00 18.83           C  
ATOM    874  CZ3 TRP    93      38.772  -2.329  -3.662  1.00 18.94           C  
ATOM    875  CH2 TRP    93      39.942  -2.697  -4.389  1.00 17.89           C  
ATOM    876  N   PHE    94      35.015  -4.463   0.670  1.00 16.25           N  
ATOM    877  CA  PHE    94      33.733  -4.347   1.367  1.00 16.00           C  
ATOM    878  C   PHE    94      33.103  -3.013   1.053  1.00 16.50           C  
ATOM    879  O   PHE    94      33.760  -2.078   0.536  1.00 16.78           O  
ATOM    880  CB  PHE    94      33.967  -4.407   2.892  1.00 16.42           C  
ATOM    881  CG  PHE    94      34.644  -3.171   3.432  1.00 15.99           C  
ATOM    882  CD1 PHE    94      33.879  -2.105   4.005  1.00 17.05           C  
ATOM    883  CD2 PHE    94      36.019  -3.046   3.357  1.00 18.78           C  
ATOM    884  CE1 PHE    94      34.525  -0.935   4.439  1.00 16.59           C  
ATOM    885  CE2 PHE    94      36.676  -1.882   3.776  1.00 17.42           C  
ATOM    886  CZ  PHE    94      35.928  -0.838   4.327  1.00 17.25           C  
ATOM    887  N   TYR    95      31.823  -2.894   1.409  1.00 16.04           N  
ATOM    888  CA  TYR    95      31.191  -1.568   1.498  1.00 17.12           C  
ATOM    889  C   TYR    95      29.856  -1.764   2.171  1.00 17.96           C  
ATOM    890  O   TYR    95      29.424  -2.879   2.367  1.00 20.58           O  
ATOM    891  CB  TYR    95      30.998  -0.895   0.113  1.00 18.45           C  
ATOM    892  CG  TYR    95      31.337   0.580   0.122  1.00 18.66           C  
ATOM    893  CD1 TYR    95      32.587   0.990   0.570  1.00 19.74           C  
ATOM    894  CD2 TYR    95      30.402   1.534  -0.287  1.00 19.52           C  
ATOM    895  CE1 TYR    95      32.943   2.365   0.605  1.00 19.65           C  
ATOM    896  CE2 TYR    95      30.732   2.907  -0.250  1.00 18.72           C  
ATOM    897  CZ  TYR    95      31.999   3.288   0.206  1.00 20.62           C  
ATOM    898  OH  TYR    95      32.344   4.665   0.229  1.00 22.21           O  
ATOM    899  N   SER    96      29.203  -0.670   2.536  0.60 17.85           N  
ATOM    901  CA  SER    96      27.903  -0.753   3.193  0.60 17.20           C  
ATOM    903  C   SER    96      26.789  -0.333   2.243  0.60 17.09           C  
ATOM    905  O   SER    96      26.997   0.501   1.358  0.60 17.78           O  
ATOM    907  CB  SER    96      27.841   0.244   4.360  0.60 17.61           C  
ATOM    909  OG  SER    96      28.810  -0.014   5.351  0.60 17.19           O  
ATOM    911  N   ILE    97      25.591  -0.868   2.483  1.00 16.44           N  
ATOM    912  CA  ILE    97      24.354  -0.321   1.901  1.00 16.59           C  
ATOM    913  C   ILE    97      23.466   0.075   3.073  1.00 16.37           C  
ATOM    914  O   ILE    97      23.232  -0.712   3.980  1.00 16.97           O  
ATOM    915  CB  ILE    97      23.598  -1.358   1.079  1.00 16.73           C  
ATOM    916  CG1 ILE    97      24.576  -2.160   0.227  1.00 18.48           C  
ATOM    917  CG2 ILE    97      22.560  -0.652   0.174  1.00 16.97           C  
ATOM    918  CD1 ILE    97      23.902  -3.326  -0.606  1.00 17.80           C  
ATOM    919  N   THR    98      23.017   1.331   3.080  1.00 15.49           N  
ATOM    920  CA  THR    98      22.286   1.859   4.223  1.00 16.39           C  
ATOM    921  C   THR    98      21.072   2.651   3.774  1.00 16.27           C  
ATOM    922  O   THR    98      20.908   2.874   2.568  1.00 17.78           O  
ATOM    923  CB  THR    98      23.211   2.765   5.097  1.00 16.82           C  
ATOM    924  OG1 THR    98      23.608   3.912   4.341  1.00 17.49           O  
ATOM    925  CG2 THR    98      24.464   2.014   5.498  1.00 16.73           C  
ATOM    926  N   GLN    99      20.236   3.037   4.733  1.00 16.84           N  
ATOM    927  CA  GLN    99      19.023   3.786   4.445  1.00 17.55           C  
ATOM    928  C   GLN    99      19.118   5.115   5.158  1.00 17.89           C  
ATOM    929  O   GLN    99      20.071   5.344   5.952  1.00 17.09           O  
ATOM    930  CB  GLN    99      17.817   2.960   4.903  1.00 17.09           C  
ATOM    931  CG  GLN    99      17.684   1.680   4.073  1.00 19.07           C  
ATOM    932  CD  GLN    99      16.368   0.929   4.356  1.00 17.48           C  
ATOM    933  OE1 GLN    99      15.827   0.962   5.462  1.00 19.87           O  
ATOM    934  NE2 GLN    99      15.842   0.280   3.318  1.00 20.07           N  
ATOM    935  N   LYS   100      18.167   6.016   4.869  1.00 18.24           N  
ATOM    936  CA  LYS   100      18.372   7.390   5.328  1.00 19.40           C  
ATOM    937  C   LYS   100      18.445   7.522   6.839  1.00 18.81           C  
ATOM    938  O   LYS   100      19.093   8.459   7.347  1.00 20.39           O  
ATOM    939  CB  LYS   100      17.344   8.344   4.722  1.00 20.14           C  
ATOM    940  CG  LYS   100      17.807   8.722   3.296  1.00 25.10           C  
ATOM    941  CD  LYS   100      17.413  10.126   2.880  1.00 35.39           C  
ATOM    942  CE  LYS   100      17.894  10.393   1.474  1.00 37.85           C  
ATOM    943  NZ  LYS   100      17.334   9.340   0.590  1.00 43.07           N  
ATOM    944  N   ASP   101      17.819   6.596   7.562  1.00 18.77           N  
ATOM    945  CA  ASP   101      17.849   6.637   9.032  1.00 18.97           C  
ATOM    946  C   ASP   101      18.862   5.684   9.673  1.00 19.71           C  
ATOM    947  O   ASP   101      18.846   5.468  10.885  1.00 20.13           O  
ATOM    948  CB  ASP   101      16.470   6.352   9.623  1.00 21.14           C  
ATOM    949  CG  ASP   101      15.902   5.004   9.206  1.00 24.80           C  
ATOM    950  OD1 ASP   101      16.414   4.346   8.270  1.00 24.17           O  
ATOM    951  OD2 ASP   101      14.860   4.613   9.808  1.00 30.33           O  
ATOM    952  N   THR   102      19.724   5.102   8.860  1.00 17.06           N  
ATOM    953  CA  THR   102      20.753   4.177   9.371  1.00 17.20           C  
ATOM    954  C   THR   102      21.889   4.902  10.090  1.00 17.58           C  
ATOM    955  O   THR   102      22.381   5.936   9.603  1.00 17.93           O  
ATOM    956  CB  THR   102      21.326   3.378   8.205  1.00 16.57           C  
ATOM    957  OG1 THR   102      20.262   2.654   7.559  1.00 17.53           O  
ATOM    958  CG2 THR   102      22.397   2.359   8.701  1.00 16.80           C  
ATOM    959  N   LYS   103      22.363   4.314  11.198  1.00 17.25           N  
ATOM    960  CA  LYS   103      23.555   4.803  11.872  1.00 16.04           C  
ATOM    961  C   LYS   103      24.375   3.590  12.301  1.00 17.48           C  
ATOM    962  O   LYS   103      23.787   2.647  12.869  1.00 17.08           O  
ATOM    963  CB  LYS   103      23.136   5.585  13.113  1.00 17.08           C  
ATOM    964  CG  LYS   103      24.323   6.281  13.816  1.00 18.18           C  
ATOM    965  CD  LYS   103      23.881   7.037  15.083  1.00 17.54           C  
ATOM    966  CE  LYS   103      22.969   8.210  14.792  1.00 17.74           C  
ATOM    967  NZ  LYS   103      23.675   9.408  14.151  1.00 17.79           N  
ATOM    968  N   MET   104      25.674   3.601  12.015  1.00 16.61           N  
ATOM    969  CA  MET   104      26.548   2.545  12.515  1.00 18.76           C  
ATOM    970  C   MET   104      27.829   3.126  13.028  1.00 18.07           C  
ATOM    971  O   MET   104      28.140   4.287  12.750  1.00 18.20           O  
ATOM    972  CB  MET   104      26.832   1.498  11.444  1.00 21.04           C  
ATOM    973  CG  MET   104      27.693   1.995  10.381  1.00 20.27           C  
ATOM    974  SD  MET   104      28.064   0.469   9.085  0.65 25.94          SE  
ATOM    975  CE  MET   104      26.490   0.644   8.340  1.00 12.83           C  
ATOM    976  N   MET   105      28.546   2.355  13.841  1.00 16.39           N  
ATOM    977  CA  MET   105      29.865   2.791  14.274  1.00 16.00           C  
ATOM    978  C   MET   105      30.870   1.843  13.689  1.00 16.24           C  
ATOM    979  O   MET   105      30.551   0.676  13.404  1.00 16.92           O  
ATOM    980  CB  MET   105      29.987   2.739  15.796  1.00 17.84           C  
ATOM    981  CG  MET   105      29.272   3.873  16.539  1.00 18.81           C  
ATOM    982  SD  MET   105      27.305   3.624  16.437  0.65 22.03          SE  
ATOM    983  CE  MET   105      26.852   4.856  17.895  1.00 19.82           C  
ATOM    984  N   TYR   106      32.079   2.338  13.459  1.00 15.94           N  
ATOM    985  CA  TYR   106      33.147   1.409  13.065  1.00 15.84           C  
ATOM    986  C   TYR   106      34.440   1.718  13.784  1.00 16.88           C  
ATOM    987  O   TYR   106      34.627   2.835  14.304  1.00 15.69           O  
ATOM    988  CB  TYR   106      33.333   1.386  11.548  1.00 17.37           C  
ATOM    989  CG  TYR   106      33.900   2.623  10.865  1.00 17.47           C  
ATOM    990  CD1 TYR   106      35.261   2.903  10.902  1.00 18.62           C  
ATOM    991  CD2 TYR   106      33.066   3.437  10.077  1.00 18.38           C  
ATOM    992  CE1 TYR   106      35.818   4.006  10.169  1.00 19.35           C  
ATOM    993  CE2 TYR   106      33.586   4.511   9.358  1.00 18.20           C  
ATOM    994  CZ  TYR   106      34.954   4.774   9.397  1.00 18.96           C  
ATOM    995  OH  TYR   106      35.485   5.823   8.665  1.00 20.37           O  
ATOM    996  N   VAL   107      35.269   0.673  13.871  1.00 16.69           N  
ATOM    997  CA  VAL   107      36.543   0.737  14.570  1.00 16.04           C  
ATOM    998  C   VAL   107      37.608   0.241  13.612  1.00 17.16           C  
ATOM    999  O   VAL   107      37.430  -0.776  12.944  1.00 16.81           O  
ATOM   1000  CB  VAL   107      36.533  -0.180  15.832  1.00 17.67           C  
ATOM   1001  CG1 VAL   107      37.847   0.002  16.625  1.00 17.38           C  
ATOM   1002  CG2 VAL   107      35.345   0.191  16.747  1.00 17.95           C  
ATOM   1003  N   GLN   108      38.702   0.982  13.518  1.00 17.82           N  
ATOM   1004  CA  GLN   108      39.866   0.519  12.703  1.00 18.01           C  
ATOM   1005  C   GLN   108      41.167   1.158  13.236  1.00 16.91           C  
ATOM   1006  O   GLN   108      41.138   1.936  14.171  1.00 17.32           O  
ATOM   1007  CB  GLN   108      39.712   0.894  11.213  1.00 18.57           C  
ATOM   1008  CG  GLN   108      39.699   2.410  11.035  1.00 19.50           C  
ATOM   1009  CD  GLN   108      39.527   2.873   9.607  1.00 24.12           C  
ATOM   1010  OE1 GLN   108      38.629   2.410   8.870  1.00 30.18           O  
ATOM   1011  NE2 GLN   108      40.376   3.781   9.213  1.00 32.65           N  
ATOM   1012  N   ASP   109      42.305   0.823  12.617  1.00 17.22           N  
ATOM   1013  CA  ASP   109      43.601   1.346  13.028  1.00 18.82           C  
ATOM   1014  C   ASP   109      43.622   2.853  12.801  1.00 20.82           C  
ATOM   1015  O   ASP   109      43.022   3.345  11.842  1.00 22.83           O  
ATOM   1016  CB  ASP   109      44.669   0.676  12.150  1.00 18.66           C  
ATOM   1017  CG  ASP   109      46.071   0.895  12.683  1.00 22.39           C  
ATOM   1018  OD1 ASP   109      46.557   2.062  12.669  1.00 24.76           O  
ATOM   1019  OD2 ASP   109      46.684  -0.113  13.066  1.00 24.55           O  
ATOM   1020  N   SER   110      44.262   3.596  13.694  1.00 21.00           N  
ATOM   1021  CA  SER   110      44.244   5.067  13.586  1.00 22.62           C  
ATOM   1022  C   SER   110      45.081   5.605  12.462  1.00 25.40           C  
ATOM   1023  O   SER   110      44.986   6.794  12.130  1.00 26.13           O  
ATOM   1024  CB  SER   110      44.637   5.744  14.889  1.00 22.48           C  
ATOM   1025  OG  SER   110      45.889   5.282  15.300  1.00 22.98           O  
ATOM   1026  N   ASN   111      45.892   4.759  11.841  0.50 26.61           N  
ATOM   1028  CA  ASN   111      46.619   5.173  10.626  0.50 29.51           C  
ATOM   1030  C   ASN   111      45.681   5.102   9.410  0.50 30.95           C  
ATOM   1032  O   ASN   111      45.748   4.156   8.625  0.50 32.22           O  
ATOM   1034  CB  ASN   111      47.838   4.276  10.385  0.50 29.55           C  
ATOM   1036  CG  ASN   111      48.726   4.132  11.602  0.50 31.43           C  
ATOM   1038  OD1 ASN   111      49.072   5.116  12.262  0.50 34.49           O  
ATOM   1040  ND2 ASN   111      49.124   2.894  11.894  0.50 34.01           N  
ATOM   1042  N   CYS   112      44.802   6.099   9.277  0.70 31.56           N  
ATOM   1043  CA  CYS   112      43.714   6.121   8.291  0.70 33.74           C  
ATOM   1044  C   CYS   112      44.025   6.946   7.039  0.70 35.48           C  
ATOM   1045  O   CYS   112      43.115   7.492   6.392  0.70 36.54           O  
ATOM   1046  CB  CYS   112      42.421   6.617   8.949  0.70 34.26           C  
ATOM   1047  SG  CYS   112      42.624   8.239   9.688  0.70 38.38           S  
ATOM   1048  N   SER   113      45.304   7.035   6.682  0.80 36.18           N  
ATOM   1049  CA  SER   113      45.657   7.515   5.355  0.80 37.26           C  
ATOM   1050  C   SER   113      45.138   6.506   4.323  0.80 37.37           C  
ATOM   1051  O   SER   113      45.038   5.311   4.592  0.80 38.31           O  
ATOM   1052  CB  SER   113      47.163   7.671   5.215  0.80 37.70           C  
ATOM   1053  OG  SER   113      47.763   6.406   5.045  0.80 40.92           O  
ATOM   1054  N   MET   114      44.784   7.001   3.147  1.00 36.61           N  
ATOM   1055  CA  MET   114      44.471   6.162   2.011  1.00 33.90           C  
ATOM   1056  C   MET   114      45.735   5.618   1.356  1.00 32.87           C  
ATOM   1057  O   MET   114      45.671   4.991   0.303  1.00 33.52           O  
ATOM   1058  CB  MET   114      43.673   6.968   0.992  1.00 34.29           C  
ATOM   1059  CG  MET   114      42.287   7.333   1.490  1.00 32.36           C  
ATOM   1060  SD  MET   114      41.175   5.772   1.643  0.55 31.57          SE  
ATOM   1061  CE  MET   114      41.516   4.865  -0.033  1.00 33.03           C  
ATOM   1062  N   ASP   115      46.893   5.872   1.969  1.00 30.98           N  
ATOM   1063  CA  ASP   115      48.127   5.247   1.531  1.00 29.39           C  
ATOM   1064  C   ASP   115      48.030   3.732   1.565  1.00 27.19           C  
ATOM   1065  O   ASP   115      48.696   3.061   0.786  1.00 28.38           O  
ATOM   1066  CB  ASP   115      49.284   5.647   2.457  1.00 31.04           C  
ATOM   1067  CG  ASP   115      49.683   7.106   2.301  1.00 36.35           C  
ATOM   1068  OD1 ASP   115      49.629   7.607   1.145  1.00 42.16           O  
ATOM   1069  OD2 ASP   115      50.065   7.734   3.328  1.00 40.44           O  
ATOM   1070  N   ASN   116      47.228   3.197   2.488  0.50 25.45           N  
ATOM   1072  CA  ASN   116      47.176   1.750   2.681  0.50 24.21           C  
ATOM   1074  C   ASN   116      45.799   1.164   2.389  0.50 22.98           C  
ATOM   1076  O   ASN   116      45.516   0.045   2.797  0.50 22.33           O  
ATOM   1078  CB  ASN   116      47.592   1.358   4.104  0.50 25.01           C  
ATOM   1080  CG  ASN   116      48.980   1.834   4.465  0.50 26.25           C  
ATOM   1082  OD1 ASN   116      49.848   1.970   3.602  0.50 30.22           O  
ATOM   1084  ND2 ASN   116      49.197   2.086   5.746  0.50 29.34           N  
ATOM   1086  N   SER   117      44.963   1.933   1.689  1.00 21.10           N  
ATOM   1087  CA  SER   117      43.626   1.481   1.305  1.00 20.32           C  
ATOM   1088  C   SER   117      43.373   1.845  -0.159  1.00 20.03           C  
ATOM   1089  O   SER   117      44.116   2.635  -0.762  1.00 21.17           O  
ATOM   1090  CB  SER   117      42.552   2.095   2.202  1.00 20.76           C  
ATOM   1091  OG  SER   117      42.802   1.844   3.590  1.00 22.22           O  
ATOM   1092  N   ASP   118      42.327   1.281  -0.746  1.00 18.98           N  
ATOM   1093  CA  ASP   118      41.985   1.582  -2.128  1.00 18.98           C  
ATOM   1094  C   ASP   118      40.481   1.476  -2.334  1.00 17.82           C  
ATOM   1095  O   ASP   118      39.797   0.823  -1.529  1.00 18.84           O  
ATOM   1096  CB  ASP   118      42.653   0.597  -3.081  1.00 18.47           C  
ATOM   1097  CG  ASP   118      44.134   0.915  -3.329  1.00 23.99           C  
ATOM   1098  OD1 ASP   118      44.418   1.937  -4.000  1.00 25.51           O  
ATOM   1099  OD2 ASP   118      44.999   0.142  -2.847  1.00 24.80           O  
ATOM   1100  N   PHE   119      39.976   2.113  -3.390  1.00 16.98           N  
ATOM   1101  CA  PHE   119      38.613   1.890  -3.870  1.00 17.39           C  
ATOM   1102  C   PHE   119      38.675   1.277  -5.266  1.00 17.52           C  
ATOM   1103  O   PHE   119      39.670   1.445  -5.981  1.00 17.46           O  
ATOM   1104  CB  PHE   119      37.807   3.196  -3.976  1.00 18.11           C  
ATOM   1105  CG  PHE   119      37.442   3.782  -2.642  1.00 17.20           C  
ATOM   1106  CD1 PHE   119      36.241   3.464  -2.011  1.00 17.33           C  
ATOM   1107  CD2 PHE   119      38.331   4.662  -2.005  1.00 19.04           C  
ATOM   1108  CE1 PHE   119      35.939   4.024  -0.751  1.00 20.51           C  
ATOM   1109  CE2 PHE   119      38.034   5.201  -0.745  1.00 20.22           C  
ATOM   1110  CZ  PHE   119      36.845   4.895  -0.135  1.00 20.12           C  
ATOM   1111  N   CYS   120      37.628   0.572  -5.670  1.00 17.45           N  
ATOM   1112  CA  CYS   120      37.555   0.047  -7.026  1.00 17.73           C  
ATOM   1113  C   CYS   120      36.106   0.087  -7.475  1.00 18.47           C  
ATOM   1114  O   CYS   120      35.201  -0.272  -6.689  1.00 17.83           O  
ATOM   1115  CB  CYS   120      38.089  -1.401  -7.045  1.00 18.30           C  
ATOM   1116  SG  CYS   120      38.102  -2.100  -8.702  0.85 21.04           S  
ATOM   1117  N   ASP   121      35.859   0.534  -8.706  1.00 18.02           N  
ATOM   1118  CA  ASP   121      34.503   0.578  -9.212  1.00 18.36           C  
ATOM   1119  C   ASP   121      33.919  -0.819  -9.406  1.00 19.09           C  
ATOM   1120  O   ASP   121      34.624  -1.758  -9.800  1.00 20.85           O  
ATOM   1121  CB  ASP   121      34.500   1.247 -10.587  1.00 18.48           C  
ATOM   1122  CG  ASP   121      34.724   2.753 -10.529  1.00 22.48           C  
ATOM   1123  OD1 ASP   121      34.777   3.377  -9.432  1.00 23.19           O  
ATOM   1124  OD2 ASP   121      34.794   3.308 -11.654  1.00 24.90           O  
ATOM   1125  N   LEU   122      32.619  -0.916  -9.181  1.00 18.88           N  
ATOM   1126  CA  LEU   122      31.864  -2.076  -9.555  1.00 19.10           C  
ATOM   1127  C   LEU   122      31.440  -1.902 -11.008  1.00 20.26           C  
ATOM   1128  O   LEU   122      31.216  -0.778 -11.467  1.00 21.26           O  
ATOM   1129  CB  LEU   122      30.615  -2.141  -8.682  1.00 19.71           C  
ATOM   1130  CG  LEU   122      30.854  -2.431  -7.195  1.00 18.36           C  
ATOM   1131  CD1 LEU   122      29.620  -2.013  -6.392  1.00 20.58           C  
ATOM   1132  CD2 LEU   122      31.061  -3.930  -7.010  1.00 21.72           C  
ATOM   1133  N   SER   123      31.288  -3.024 -11.710  1.00 20.30           N  
ATOM   1134  CA  SER   123      30.757  -2.964 -13.084  1.00 21.25           C  
ATOM   1135  C   SER   123      29.244  -2.686 -13.056  1.00 21.59           C  
ATOM   1136  O   SER   123      28.599  -2.828 -11.995  1.00 20.17           O  
ATOM   1137  CB  SER   123      30.982  -4.316 -13.769  1.00 21.57           C  
ATOM   1138  OG  SER   123      30.121  -5.293 -13.208  1.00 21.76           O  
ATOM   1139  N   LYS   124      28.651  -2.482 -14.240  0.50 21.41           N  
ATOM   1141  CA  LYS   124      27.189  -2.349 -14.367  0.50 22.09           C  
ATOM   1143  C   LYS   124      26.407  -3.585 -13.913  0.50 20.42           C  
ATOM   1145  O   LYS   124      25.404  -3.454 -13.193  0.50 19.79           O  
ATOM   1147  CB  LYS   124      26.775  -1.962 -15.804  0.50 22.57           C  
ATOM   1149  CG  LYS   124      25.663  -0.888 -15.824  0.50 25.93           C  
ATOM   1151  CD  LYS   124      25.184  -0.523 -17.241  0.50 25.36           C  
ATOM   1153  CE  LYS   124      26.129   0.427 -17.981  0.50 30.01           C  
ATOM   1155  NZ  LYS   124      25.505   0.962 -19.259  0.50 30.02           N  
ATOM   1157  N   GLU   125      26.825  -4.780 -14.331  0.60 19.59           N  
ATOM   1159  CA  GLU   125      26.131  -5.996 -13.881  0.60 19.69           C  
ATOM   1161  C   GLU   125      26.302  -6.092 -12.373  0.60 18.94           C  
ATOM   1163  O   GLU   125      25.366  -6.501 -11.678  0.60 18.66           O  
ATOM   1165  CB  GLU   125      26.661  -7.290 -14.526  0.60 19.99           C  
ATOM   1167  CG  GLU   125      26.151  -8.577 -13.844  0.60 20.98           C  
ATOM   1169  CD  GLU   125      26.607  -9.843 -14.539  0.60 21.63           C  
ATOM   1171  OE1 GLU   125      26.261 -10.005 -15.714  0.60 19.71           O  
ATOM   1173  OE2 GLU   125      27.260 -10.698 -13.888  0.60 27.62           O  
ATOM   1175  N   GLU   126      27.489  -5.753 -11.848  1.00 19.08           N  
ATOM   1176  CA  GLU   126      27.648  -5.938 -10.406  1.00 18.73           C  
ATOM   1177  C   GLU   126      26.741  -5.028  -9.609  1.00 18.15           C  
ATOM   1178  O   GLU   126      26.161  -5.438  -8.607  1.00 17.99           O  
ATOM   1179  CB  GLU   126      29.117  -5.727 -10.000  1.00 18.57           C  
ATOM   1180  CG  GLU   126      29.971  -6.889 -10.484  1.00 18.38           C  
ATOM   1181  CD  GLU   126      31.451  -6.622 -10.553  1.00 23.86           C  
ATOM   1182  OE1 GLU   126      31.903  -5.448 -10.410  1.00 22.43           O  
ATOM   1183  OE2 GLU   126      32.148  -7.648 -10.769  1.00 26.13           O  
ATOM   1184  N   ILE   127      26.640  -3.766 -10.046  1.00 17.91           N  
ATOM   1185  CA  ILE   127      25.729  -2.831  -9.371  1.00 17.65           C  
ATOM   1186  C   ILE   127      24.278  -3.349  -9.459  1.00 17.13           C  
ATOM   1187  O   ILE   127      23.605  -3.412  -8.428  1.00 17.30           O  
ATOM   1188  CB  ILE   127      25.860  -1.432  -9.962  1.00 18.60           C  
ATOM   1189  CG1 ILE   127      27.226  -0.907  -9.564  1.00 18.46           C  
ATOM   1190  CG2 ILE   127      24.801  -0.512  -9.437  1.00 19.31           C  
ATOM   1191  CD1 ILE   127      27.652   0.347 -10.378  1.00 20.44           C  
ATOM   1192  N   GLU   128      23.824  -3.758 -10.663  1.00 18.39           N  
ATOM   1193  CA  GLU   128      22.454  -4.230 -10.797  1.00 20.00           C  
ATOM   1194  C   GLU   128      22.223  -5.470  -9.953  1.00 18.15           C  
ATOM   1195  O   GLU   128      21.169  -5.629  -9.342  1.00 18.91           O  
ATOM   1196  CB  GLU   128      22.138  -4.598 -12.257  1.00 20.94           C  
ATOM   1197  CG  GLU   128      22.052  -3.429 -13.162  1.00 23.65           C  
ATOM   1198  CD  GLU   128      21.814  -3.828 -14.628  1.00 25.57           C  
ATOM   1199  OE1 GLU   128      21.660  -5.043 -14.953  1.00 30.78           O  
ATOM   1200  OE2 GLU   128      21.811  -2.893 -15.466  1.00 32.76           O  
ATOM   1201  N   TYR   129      23.200  -6.376  -9.937  1.00 17.26           N  
ATOM   1202  CA  TYR   129      23.116  -7.601  -9.141  1.00 17.84           C  
ATOM   1203  C   TYR   129      22.970  -7.266  -7.649  1.00 18.04           C  
ATOM   1204  O   TYR   129      22.105  -7.813  -6.920  1.00 18.35           O  
ATOM   1205  CB  TYR   129      24.391  -8.393  -9.363  1.00 18.21           C  
ATOM   1206  CG  TYR   129      24.534  -9.595  -8.483  1.00 18.38           C  
ATOM   1207  CD1 TYR   129      23.709 -10.725  -8.630  1.00 18.41           C  
ATOM   1208  CD2 TYR   129      25.523  -9.622  -7.498  1.00 20.53           C  
ATOM   1209  CE1 TYR   129      23.864 -11.827  -7.804  1.00 17.58           C  
ATOM   1210  CE2 TYR   129      25.680 -10.727  -6.675  1.00 19.51           C  
ATOM   1211  CZ  TYR   129      24.855 -11.837  -6.813  1.00 18.04           C  
ATOM   1212  OH  TYR   129      25.046 -12.968  -6.031  1.00 20.25           O  
ATOM   1213  N   ILE   130      23.838  -6.374  -7.162  1.00 16.52           N  
ATOM   1214  CA  ILE   130      23.709  -5.978  -5.770  1.00 17.09           C  
ATOM   1215  C   ILE   130      22.356  -5.330  -5.503  1.00 16.91           C  
ATOM   1216  O   ILE   130      21.727  -5.628  -4.479  1.00 18.49           O  
ATOM   1217  CB  ILE   130      24.863  -5.005  -5.382  1.00 17.07           C  
ATOM   1218  CG1 ILE   130      26.193  -5.809  -5.366  1.00 17.50           C  
ATOM   1219  CG2 ILE   130      24.540  -4.313  -4.062  1.00 18.07           C  
ATOM   1220  CD1 ILE   130      27.479  -4.888  -5.348  1.00 19.29           C  
ATOM   1221  N   GLN   131      21.902  -4.417  -6.379  1.00 16.81           N  
ATOM   1222  CA  GLN   131      20.627  -3.733  -6.147  1.00 16.26           C  
ATOM   1223  C   GLN   131      19.446  -4.743  -6.100  1.00 16.96           C  
ATOM   1224  O   GLN   131      18.583  -4.655  -5.232  1.00 17.72           O  
ATOM   1225  CB  GLN   131      20.379  -2.693  -7.226  1.00 17.36           C  
ATOM   1226  CG  GLN   131      21.329  -1.508  -7.062  1.00 17.32           C  
ATOM   1227  CD  GLN   131      21.262  -0.489  -8.196  1.00 18.14           C  
ATOM   1228  OE1 GLN   131      20.970  -0.828  -9.350  1.00 21.38           O  
ATOM   1229  NE2 GLN   131      21.621   0.769  -7.879  1.00 20.80           N  
ATOM   1230  N   THR   132      19.419  -5.674  -7.054  1.00 16.48           N  
ATOM   1231  CA  THR   132      18.346  -6.671  -7.094  1.00 16.57           C  
ATOM   1232  C   THR   132      18.269  -7.419  -5.769  1.00 17.80           C  
ATOM   1233  O   THR   132      17.198  -7.577  -5.188  1.00 18.56           O  
ATOM   1234  CB  THR   132      18.604  -7.637  -8.232  1.00 18.12           C  
ATOM   1235  OG1 THR   132      18.408  -6.933  -9.460  1.00 18.40           O  
ATOM   1236  CG2 THR   132      17.597  -8.815  -8.160  1.00 17.65           C  
ATOM   1237  N   ASN   133      19.409  -7.901  -5.303  1.00 17.31           N  
ATOM   1238  CA  ASN   133      19.415  -8.773  -4.108  1.00 17.08           C  
ATOM   1239  C   ASN   133      19.311  -7.976  -2.822  1.00 17.38           C  
ATOM   1240  O   ASN   133      18.656  -8.409  -1.867  1.00 18.85           O  
ATOM   1241  CB  ASN   133      20.651  -9.693  -4.135  1.00 17.47           C  
ATOM   1242  CG  ASN   133      20.577 -10.696  -5.293  1.00 20.14           C  
ATOM   1243  OD1 ASN   133      21.201 -10.534  -6.357  1.00 20.33           O  
ATOM   1244  ND2 ASN   133      19.772 -11.703  -5.112  1.00 16.52           N  
ATOM   1245  N   ALA   134      19.907  -6.785  -2.801  1.00 17.14           N  
ATOM   1246  CA  ALA   134      19.819  -5.949  -1.597  1.00 17.67           C  
ATOM   1247  C   ALA   134      18.425  -5.402  -1.350  1.00 17.75           C  
ATOM   1248  O   ALA   134      18.010  -5.294  -0.191  1.00 18.61           O  
ATOM   1249  CB  ALA   134      20.833  -4.785  -1.649  1.00 18.35           C  
ATOM   1250  N   ARG   135      17.690  -5.062  -2.413  0.50 17.68           N  
ATOM   1252  CA  ARG   135      16.292  -4.640  -2.250  0.50 18.19           C  
ATOM   1254  C   ARG   135      15.572  -5.671  -1.405  0.50 17.60           C  
ATOM   1256  O   ARG   135      14.915  -5.319  -0.421  0.50 17.24           O  
ATOM   1258  CB  ARG   135      15.558  -4.482  -3.598  0.50 18.84           C  
ATOM   1260  CG  ARG   135      15.634  -3.088  -4.185  0.50 20.89           C  
ATOM   1262  CD  ARG   135      14.767  -2.913  -5.452  0.50 19.82           C  
ATOM   1264  NE  ARG   135      15.253  -3.691  -6.597  0.50 21.02           N  
ATOM   1266  CZ  ARG   135      16.118  -3.257  -7.510  0.50 20.55           C  
ATOM   1268  NH1 ARG   135      16.660  -2.051  -7.414  0.50 19.77           N  
ATOM   1270  NH2 ARG   135      16.470  -4.039  -8.515  0.50 20.94           N  
ATOM   1272  N   LYS   136      15.739  -6.941  -1.769  1.00 17.30           N  
ATOM   1273  CA  LYS   136      15.013  -8.042  -1.104  1.00 16.20           C  
ATOM   1274  C   LYS   136      15.561  -8.221   0.317  1.00 16.60           C  
ATOM   1275  O   LYS   136      14.805  -8.320   1.280  1.00 16.64           O  
ATOM   1276  CB  LYS   136      15.162  -9.303  -1.914  1.00 17.03           C  
ATOM   1277  CG  LYS   136      14.430  -9.172  -3.243  1.00 20.14           C  
ATOM   1278  CD  LYS   136      14.770 -10.338  -4.113  1.00 23.30           C  
ATOM   1279  CE  LYS   136      14.162 -10.175  -5.516  1.00 25.56           C  
ATOM   1280  NZ  LYS   136      12.720 -10.573  -5.377  1.00 29.92           N  
ATOM   1281  N   LEU   137      16.893  -8.204   0.420  1.00 16.81           N  
ATOM   1282  CA  LEU   137      17.533  -8.532   1.692  1.00 16.98           C  
ATOM   1283  C   LEU   137      17.144  -7.528   2.759  1.00 17.23           C  
ATOM   1284  O   LEU   137      16.991  -7.903   3.926  1.00 17.59           O  
ATOM   1285  CB  LEU   137      19.054  -8.638   1.497  1.00 17.81           C  
ATOM   1286  CG  LEU   137      19.910  -9.022   2.716  1.00 18.22           C  
ATOM   1287  CD1 LEU   137      19.354 -10.327   3.309  1.00 18.14           C  
ATOM   1288  CD2 LEU   137      21.383  -9.126   2.302  1.00 17.26           C  
ATOM   1289  N   PHE   138      16.984  -6.245   2.373  1.00 17.07           N  
ATOM   1290  CA  PHE   138      16.586  -5.233   3.356  1.00 18.73           C  
ATOM   1291  C   PHE   138      15.282  -5.558   4.070  1.00 19.99           C  
ATOM   1292  O   PHE   138      15.090  -5.139   5.217  1.00 21.34           O  
ATOM   1293  CB  PHE   138      16.442  -3.844   2.687  1.00 18.10           C  
ATOM   1294  CG  PHE   138      17.686  -3.006   2.719  1.00 17.50           C  
ATOM   1295  CD1 PHE   138      18.139  -2.388   1.555  1.00 16.88           C  
ATOM   1296  CD2 PHE   138      18.396  -2.812   3.903  1.00 17.33           C  
ATOM   1297  CE1 PHE   138      19.283  -1.541   1.583  1.00 18.86           C  
ATOM   1298  CE2 PHE   138      19.527  -1.973   3.909  1.00 19.25           C  
ATOM   1299  CZ  PHE   138      19.952  -1.367   2.760  1.00 17.67           C  
ATOM   1300  N   GLU   139      14.439  -6.386   3.444  1.00 18.92           N  
ATOM   1301  CA  GLU   139      13.138  -6.676   3.996  1.00 19.71           C  
ATOM   1302  C   GLU   139      13.066  -8.043   4.661  1.00 17.95           C  
ATOM   1303  O   GLU   139      12.014  -8.404   5.137  1.00 18.66           O  
ATOM   1304  CB  GLU   139      12.101  -6.581   2.895  1.00 19.85           C  
ATOM   1305  CG  GLU   139      12.117  -5.275   2.063  1.00 23.35           C  
ATOM   1306  CD  GLU   139      12.058  -4.002   2.912  1.00 30.03           C  
ATOM   1307  OE1 GLU   139      11.489  -3.989   4.046  1.00 30.29           O  
ATOM   1308  OE2 GLU   139      12.582  -2.966   2.407  1.00 33.04           O  
ATOM   1309  N   LYS   140      14.176  -8.786   4.703  1.00 17.80           N  
ATOM   1310  CA  LYS   140      14.103 -10.176   5.243  1.00 19.28           C  
ATOM   1311  C   LYS   140      14.286 -10.219   6.749  1.00 21.74           C  
ATOM   1312  O   LYS   140      14.695  -9.206   7.393  1.00 21.57           O  
ATOM   1313  CB  LYS   140      15.170 -11.064   4.589  1.00 18.37           C  
ATOM   1314  CG  LYS   140      14.909 -11.354   3.112  1.00 18.79           C  
ATOM   1315  CD  LYS   140      16.003 -12.193   2.490  1.00 19.32           C  
ATOM   1316  CE  LYS   140      15.652 -12.412   0.999  1.00 21.12           C  
ATOM   1317  NZ  LYS   140      16.766 -13.100   0.285  1.00 22.33           N  
ATOM   1318  OXT LYS   140      14.000 -11.276   7.370  1.00 23.13           O  
END
