
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  151 ( 1197),  selected  151 , name 2qyb_A
# Molecule2: number of CA atoms  176 ( 1390),  selected  176 , name T0412.pdb
# PARAMETERS: 2qyb_A.T0412.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     7_A      -       -           -
LGA    E     8_A      -       -           -
LGA    I     9_A      S       1          1.130
LGA    X    10_A      -       -           -
LGA    N    11_A      -       -           -
LGA    R    12_A      N       2          2.333
LGA    T    13_A      A       3          1.510
LGA    L    14_A      L       4          2.398
LGA    D    15_A      F       5          2.616
LGA    L    16_A      S       6          2.299
LGA    Q    17_A      S       7          2.282
LGA    I    18_A      R       8          2.411
LGA    I    19_A      D       9          2.309
LGA    X    20_A      I      10          2.068
LGA    D    21_A      L      11          2.079
LGA    D    22_A      E      12          2.332
LGA    L    23_A      V      13          1.905
LGA    L    24_A      L      14          1.614
LGA    N    25_A      Q      15          1.761
LGA    L    26_A      D      16          1.877
LGA    L    27_A      I      17          1.446
LGA    L    28_A      H      18          1.432
LGA    K    29_A      M      19          1.246
LGA    E    30_A      E      20          1.683
LGA    F    31_A      T      21          2.197
LGA    K    32_A      G      22          4.142
LGA    L    33_A      -       -           -
LGA    D    34_A      E      23          1.867
LGA    L    35_A      T      24          0.616
LGA    A    36_A      V      25          0.407
LGA    V    37_A      A      26          0.360
LGA    I    38_A      I      27          0.528
LGA    R    39_A      A      28          1.270
LGA    L    40_A      T      29          3.081
LGA    V    41_A      -       -           -
LGA    D    42_A      -       -           -
LGA    E    43_A      -       -           -
LGA    K    44_A      -       -           -
LGA    G    45_A      K      30          5.009
LGA    V    46_A      N      31          1.572
LGA    -       -      D      32           -
LGA    -       -      I      33           -
LGA    -       -      Y      34           -
LGA    L    47_A      L      35          4.463
LGA    R    48_A      Q      36          2.936
LGA    V    49_A      Y      37          1.775
LGA    R    50_A      I      38          1.726
LGA    S    51_A      Q      39          2.102
LGA    Y    52_A      I      40          2.211
LGA    S    53_A      I      41          1.586
LGA    G    54_A      E      42          2.037
LGA    K    55_A      S      43          4.564
LGA    -       -      V      44           -
LGA    -       -      H      45           -
LGA    -       -      A      46           -
LGA    -       -      L      47           -
LGA    -       -      R      48           -
LGA    G    56_A      F      49          4.559
LGA    I    57_A      H      50          5.242
LGA    A    58_A      V      51          4.046
LGA    G    59_A      D      52          2.557
LGA    I    60_A      -       -           -
LGA    A    61_A      -       -           -
LGA    G    62_A      E      53          4.938
LGA    K    63_A      N      54           #
LGA    -       -      A      55           -
LGA    D    64_A      I      56           #
LGA    W    65_A      R      57          5.213
LGA    E    66_A      P      58          5.350
LGA    P    67_A      L      59          3.309
LGA    E    68_A      T      60          3.700
LGA    I    69_A      -       -           -
LGA    E    70_A      M      61          4.924
LGA    T    71_A      S      62          3.782
LGA    Y    72_A      S      63          2.735
LGA    I    73_A      N      64          2.381
LGA    G    74_A      G      65          2.023
LGA    E    75_A      W      66          1.629
LGA    A    76_A      M      67          2.115
LGA    F    77_A      L      68          2.192
LGA    L    78_A      M      69          2.176
LGA    S    79_A      S      70          2.837
LGA    -       -      T      71           -
LGA    -       -      M      72           -
LGA    -       -      N      73           -
LGA    -       -      D      74           -
LGA    -       -      K      75           -
LGA    -       -      A      76           -
LGA    -       -      I      77           -
LGA    -       -      D      78           -
LGA    -       -      N      79           -
LGA    -       -      T      80           -
LGA    -       -      V      81           -
LGA    -       -      R      82           -
LGA    -       -      R      83           -
LGA    -       -      A      84           -
LGA    -       -      N      85           -
LGA    -       -      T      86           -
LGA    -       -      I      87           -
LGA    -       -      T      88           -
LGA    -       -      Q      89           -
LGA    -       -      K      90           -
LGA    -       -      D      91           -
LGA    -       -      G      92           -
LGA    -       -      I      93           -
LGA    -       -      R      94           -
LGA    -       -      F      95           -
LGA    -       -      E      96           -
LGA    -       -      V      97           -
LGA    -       -      D      98           -
LGA    -       -      D      99           -
LGA    -       -      M     100           -
LGA    -       -      M     101           -
LGA    -       -      A     102           -
LGA    -       -      R     103           -
LGA    -       -      I     104           -
LGA    -       -      R     105           -
LGA    -       -      Q     106           -
LGA    -       -      V     107           -
LGA    N    80_A      R     108          2.746
LGA    -       -      E     109           -
LGA    -       -      Q     110           -
LGA    R    81_A      G     111          3.873
LGA    L    82_A      Y     112          1.749
LGA    Q    83_A      A     113          1.749
LGA    F    84_A      S     114          1.487
LGA    V    85_A      A     115          3.670
LGA    N    86_A      E     116           #
LGA    D    87_A      -       -           -
LGA    T    88_A      -       -           -
LGA    Q    89_A      -       -           -
LGA    Y    90_A      -       -           -
LGA    X    91_A      -       -           -
LGA    T    92_A      H     117           #
LGA    K    93_A      I     118           #
LGA    P    94_A      -       -           -
LGA    L    95_A      -       -           -
LGA    T    96_A      P     119          3.442
LGA    R    97_A      F     120          3.067
LGA    E    98_A      V     121          3.284
LGA    L    99_A      -       -           -
LGA    X   100_A      -       -           -
LGA    Q   101_A      -       -           -
LGA    K   102_A      -       -           -
LGA    E   103_A      -       -           -
LGA    G   104_A      -       -           -
LGA    I   105_A      G     122           #
LGA    K   106_A      G     123          4.645
LGA    S   107_A      G     124          3.072
LGA    F   108_A      T     125          1.792
LGA    A   109_A      I     126          0.703
LGA    H   110_A      C     127          2.053
LGA    I   111_A      V     128          1.502
LGA    P   112_A      L     129          1.876
LGA    I   113_A      L     130          2.031
LGA    S   114_A      P     131          3.202
LGA    R   115_A      M     132          6.124
LGA    K   116_A      T     133           -
LGA    G   117_A      I     134           -
LGA    E   118_A      Q     135           -
LGA    P   119_A      G     136           -
LGA    P   120_A      -       -           -
LGA    F   121_A      Q     137          4.921
LGA    G   122_A      P     138          3.654
LGA    -       -      V     139           -
LGA    I   123_A      T     140          1.296
LGA    L   124_A      M     141          0.958
LGA    S   125_A      G     142          1.620
LGA    V   126_A      L     143          0.221
LGA    F   127_A      G     144          1.468
LGA    S   128_A      G     145          2.891
LGA    R   129_A      A     146          3.870
LGA    T   130_A      L     147           -
LGA    I   131_A      D     148          4.785
LGA    V   132_A      R     149          2.593
LGA    -       -      I     150           -
LGA    -       -      K     151           -
LGA    G   133_A      Q     152          2.017
LGA    L   134_A      N     153          1.538
LGA    F   135_A      Y     154          1.179
LGA    N   136_A      D     155          1.593
LGA    E   137_A      R     156           #
LGA    P   138_A      -       -           -
LGA    F   139_A      Y     157          3.710
LGA    L   140_A      L     158          1.805
LGA    N   141_A      E     159          2.839
LGA    L   142_A      L     160          2.780
LGA    L   143_A      L     161          1.004
LGA    E   144_A      L     162          1.401
LGA    S   145_A      N     163          2.091
LGA    L   146_A      G     164          0.677
LGA    A   147_A      V     165          2.563
LGA    G   148_A      Q     166          4.036
LGA    Q   149_A      Q     167          3.318
LGA    L   150_A      L     168          3.789
LGA    A   151_A      K     169           #
LGA    Q   152_A      K     170          4.381
LGA    A   153_A      S     171          1.832
LGA    V   154_A      -       -           -
LGA    K   155_A      -       -           -
LGA    I   156_A      D     172          1.331
LGA    V   157_A      S     173          4.000
LGA    -       -      F     174           -
LGA    -       -      H     175           -
LGA    -       -      Q     176           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  151  176    5.0    109    2.84    11.01     37.523     3.701

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.821453 * X  +   0.568563 * Y  +   0.044179 * Z  +  11.740108
  Y_new =   0.417278 * X  +  -0.546455 * Y  +  -0.726131 * Z  +  72.055321
  Z_new =  -0.388709 * X  +   0.614917 * Y  +  -0.686136 * Z  +  61.240070 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.410879   -0.730714  [ DEG:   138.1332    -41.8668 ]
  Theta =   0.399230    2.742362  [ DEG:    22.8742    157.1258 ]
  Phi   =   0.470008   -2.671585  [ DEG:    26.9295   -153.0705 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2qyb_A                                        
REMARK     2: T0412.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2qyb_A.T0412.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  151  176   5.0  109   2.84   11.01  37.523
REMARK  ---------------------------------------------------------- 
MOLECULE 2qyb_A
HEADER    MEMBRANE PROTEIN                        14-AUG-07   2QYB              
TITLE     CRYSTAL STRUCTURE OF THE GAF DOMAIN REGION OF PUTATIVE                
TITLE    2 MEMBRANE PROTEIN FROM GEOBACTER SULFURREDUCENS PCA                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MEMBRANE PROTEIN, PUTATIVE;                                
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: GAF DOMAIN: RESIDUES 661-838;                              
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: GEOBACTER SULFURREDUCENS PCA;                   
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: PCA, DSM 12127;                                              
SOURCE   5 ATCC: 51573;                                                         
SOURCE   6 GENE: GSU1429;                                                       
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    GAF DOMAIN, DOMAIN OF PUTATIVE MEMBRANE PROTEIN, PSI-2,               
KEYWDS   2 MCSG, STRUCTURAL GENOMICS, PROTEIN STRUCTURE INITIATIVE,             
KEYWDS   3 MIDWEST CENTER FOR STRUCTURAL GENOMICS                               
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    B.NOCEK,E.DUGGAN,S.CLANCY,A.JOACHIMIAK,MIDWEST CENTER FOR             
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   28-AUG-07 2QYB    0                                                
JRNL        AUTH   B.NOCEK,E.DUGGAN,E.CLANCY,A.JOACHIMIAK                       
JRNL        TITL   CRYSTAL STRUCTURE OF THE GAF DOMAIN REGION OF                
JRNL        TITL 2 PUTATIVE MEMBRANE PROTEIN FROM GEOBACTER                     
JRNL        TITL 3 SULFURREDUCENS PCA.                                          
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.40 ANGSTROMS.                                          
DBREF  2QYB A    2   179  UNP    Q74D90   Q74D90_GEOSL   661    838             
SEQRES   1 A  181  SER ASN ALA VAL ARG LEU ARG ALA SER GLU ILE MSE ASN          
SEQRES   2 A  181  ARG THR LEU ASP LEU GLN ILE ILE MSE ASP ASP LEU LEU          
SEQRES   3 A  181  ASN LEU LEU LEU LYS GLU PHE LYS LEU ASP LEU ALA VAL          
SEQRES   4 A  181  ILE ARG LEU VAL ASP GLU LYS GLY VAL LEU ARG VAL ARG          
SEQRES   5 A  181  SER TYR SER GLY LYS GLY ILE ALA GLY ILE ALA GLY LYS          
SEQRES   6 A  181  ASP TRP GLU PRO GLU ILE GLU THR TYR ILE GLY GLU ALA          
SEQRES   7 A  181  PHE LEU SER ASN ARG LEU GLN PHE VAL ASN ASP THR GLN          
SEQRES   8 A  181  TYR MSE THR LYS PRO LEU THR ARG GLU LEU MSE GLN LYS          
SEQRES   9 A  181  GLU GLY ILE LYS SER PHE ALA HIS ILE PRO ILE SER ARG          
SEQRES  10 A  181  LYS GLY GLU PRO PRO PHE GLY ILE LEU SER VAL PHE SER          
SEQRES  11 A  181  ARG THR ILE VAL GLY LEU PHE ASN GLU PRO PHE LEU ASN          
SEQRES  12 A  181  LEU LEU GLU SER LEU ALA GLY GLN LEU ALA GLN ALA VAL          
SEQRES  13 A  181  LYS ILE VAL THR GLU MSE GLU ALA LYS GLU ARG GLU ARG          
SEQRES  14 A  181  GLU GLU LYS GLU ARG ILE LEU LEU GLU ASN ALA ARG              
HET    MSE  A  10       8                                                       
HET    MSE  A  20       8                                                       
HET    MSE  A  91       8                                                       
HET    MSE  A 100       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   2  HOH   *17(H2 O)                                                     
CRYST1   64.886   64.886   90.456  90.00  90.00 120.00 P 31 2 1      6          
ATOM      1  N   SER A   7      12.011  24.037  91.063  1.00 51.55           N  
ATOM      2  CA  SER A   7      10.837  24.994  91.069  1.00 51.88           C  
ATOM      3  C   SER A   7      11.126  26.360  91.772  1.00 51.85           C  
ATOM      4  O   SER A   7      10.903  27.438  91.214  1.00 52.07           O  
ATOM      5  CB  SER A   7       9.622  24.325  91.686  1.00 51.50           C  
ATOM      6  OG  SER A   7       8.784  25.291  92.287  1.00 51.54           O  
ATOM      7  N   GLU A   8      11.609  26.297  93.005  1.00 51.64           N  
ATOM      8  CA  GLU A   8      12.192  27.461  93.674  1.00 51.43           C  
ATOM      9  C   GLU A   8      13.479  27.903  92.945  1.00 50.72           C  
ATOM     10  O   GLU A   8      13.692  29.094  92.626  1.00 49.91           O  
ATOM     11  CB  GLU A   8      12.484  27.141  95.156  1.00 51.12           C  
ATOM     12  CG  GLU A   8      12.972  25.682  95.460  1.00 52.03           C  
ATOM     13  CD  GLU A   8      13.122  25.394  96.967  1.00 52.59           C  
ATOM     14  OE1 GLU A   8      12.435  26.056  97.779  1.00 53.35           O  
ATOM     15  OE2 GLU A   8      13.921  24.499  97.344  1.00 54.18           O  
ATOM     16  N   ILE A   9      14.338  26.925  92.686  1.00 50.12           N  
ATOM     17  CA  ILE A   9      15.567  27.168  91.958  1.00 50.23           C  
ATOM     18  C   ILE A   9      15.236  27.603  90.518  1.00 49.43           C  
ATOM     19  O   ILE A   9      15.802  28.542  90.000  1.00 48.76           O  
ATOM     20  CB  ILE A   9      16.514  25.947  92.074  1.00 50.25           C  
ATOM     21  CG1 ILE A   9      17.678  26.037  91.082  1.00 50.32           C  
ATOM     22  CG2 ILE A   9      15.735  24.668  91.910  1.00 52.01           C  
ATOM     23  CD1 ILE A   9      18.942  25.286  91.569  1.00 51.35           C  
HETATM   24  N   MSE A  10      14.252  26.954  89.929  1.00 49.26           N  
HETATM   25  CA  MSE A  10      13.693  27.365  88.653  1.00 49.61           C  
HETATM   26  C   MSE A  10      13.315  28.840  88.602  1.00 48.62           C  
HETATM   27  O   MSE A  10      13.667  29.532  87.645  1.00 48.70           O  
HETATM   28  CB  MSE A  10      12.433  26.543  88.337  1.00 49.52           C  
HETATM   29  CG  MSE A  10      11.911  26.860  86.985  1.00 49.97           C  
HETATM   30 SE   MSE A  10      10.384  25.795  86.513  0.60 53.20          SE  
HETATM   31  CE  MSE A  10      10.392  26.203  84.626  1.00 52.25           C  
ATOM     32  N   ASN A  11      12.552  29.280  89.601  1.00 47.50           N  
ATOM     33  CA  ASN A  11      12.123  30.697  89.713  1.00 46.80           C  
ATOM     34  C   ASN A  11      13.260  31.680  89.950  1.00 45.88           C  
ATOM     35  O   ASN A  11      13.241  32.783  89.417  1.00 46.46           O  
ATOM     36  CB  ASN A  11      11.066  30.860  90.810  1.00 46.78           C  
ATOM     37  CG  ASN A  11       9.664  30.495  90.328  1.00 46.72           C  
ATOM     38  OD1 ASN A  11       9.144  31.122  89.414  1.00 47.94           O  
ATOM     39  ND2 ASN A  11       9.053  29.502  90.950  1.00 43.21           N  
ATOM     40  N   ARG A  12      14.254  31.271  90.740  1.00 44.75           N  
ATOM     41  CA  ARG A  12      15.479  32.067  90.911  1.00 43.70           C  
ATOM     42  C   ARG A  12      16.303  32.151  89.619  1.00 41.18           C  
ATOM     43  O   ARG A  12      16.835  33.188  89.307  1.00 40.60           O  
ATOM     44  CB  ARG A  12      16.332  31.554  92.105  1.00 43.90           C  
ATOM     45  CG  ARG A  12      15.806  32.062  93.467  1.00 45.09           C  
ATOM     46  CD  ARG A  12      16.341  31.259  94.701  1.00 47.10           C  
ATOM     47  NE  ARG A  12      17.792  30.929  94.701  1.00 48.50           N  
ATOM     48  CZ  ARG A  12      18.301  29.691  94.593  1.00 47.49           C  
ATOM     49  NH1 ARG A  12      17.525  28.612  94.486  1.00 46.77           N  
ATOM     50  NH2 ARG A  12      19.607  29.522  94.592  1.00 47.46           N  
ATOM     51  N   THR A  13      16.368  31.071  88.862  1.00 39.27           N  
ATOM     52  CA  THR A  13      17.014  31.098  87.561  1.00 38.45           C  
ATOM     53  C   THR A  13      16.245  32.000  86.572  1.00 37.30           C  
ATOM     54  O   THR A  13      16.847  32.773  85.831  1.00 37.46           O  
ATOM     55  CB  THR A  13      17.132  29.683  87.022  1.00 38.18           C  
ATOM     56  OG1 THR A  13      17.806  28.888  88.000  1.00 38.18           O  
ATOM     57  CG2 THR A  13      17.908  29.614  85.690  1.00 38.50           C  
ATOM     58  N   LEU A  14      14.927  31.953  86.588  1.00 35.83           N  
ATOM     59  CA  LEU A  14      14.163  32.845  85.719  1.00 35.54           C  
ATOM     60  C   LEU A  14      14.353  34.303  86.121  1.00 34.47           C  
ATOM     61  O   LEU A  14      14.324  35.180  85.277  1.00 33.81           O  
ATOM     62  CB  LEU A  14      12.678  32.478  85.712  1.00 35.18           C  
ATOM     63  CG  LEU A  14      12.305  31.151  85.018  1.00 35.77           C  
ATOM     64  CD1 LEU A  14      10.851  30.728  85.356  1.00 31.31           C  
ATOM     65  CD2 LEU A  14      12.540  31.239  83.488  1.00 33.39           C  
ATOM     66  N   ASP A  15      14.552  34.553  87.406  1.00 33.99           N  
ATOM     67  CA  ASP A  15      14.898  35.895  87.880  1.00 34.36           C  
ATOM     68  C   ASP A  15      16.304  36.307  87.462  1.00 33.59           C  
ATOM     69  O   ASP A  15      16.559  37.467  87.123  1.00 34.56           O  
ATOM     70  CB  ASP A  15      14.862  35.953  89.395  1.00 34.05           C  
ATOM     71  CG  ASP A  15      13.489  35.919  89.933  1.00 35.48           C  
ATOM     72  OD1 ASP A  15      12.557  36.240  89.187  1.00 36.79           O  
ATOM     73  OD2 ASP A  15      13.345  35.626  91.137  1.00 41.86           O  
ATOM     74  N   LEU A  16      17.219  35.359  87.524  1.00 32.62           N  
ATOM     75  CA  LEU A  16      18.553  35.605  87.061  1.00 32.59           C  
ATOM     76  C   LEU A  16      18.557  36.068  85.609  1.00 32.45           C  
ATOM     77  O   LEU A  16      19.229  37.019  85.280  1.00 31.68           O  
ATOM     78  CB  LEU A  16      19.416  34.353  87.237  1.00 33.33           C  
ATOM     79  CG  LEU A  16      20.814  34.401  86.600  1.00 32.32           C  
ATOM     80  CD1 LEU A  16      21.691  35.531  87.203  1.00 27.92           C  
ATOM     81  CD2 LEU A  16      21.425  32.983  86.698  1.00 29.56           C  
ATOM     82  N   GLN A  17      17.780  35.392  84.766  1.00 32.76           N  
ATOM     83  CA  GLN A  17      17.630  35.760  83.348  1.00 32.80           C  
ATOM     84  C   GLN A  17      17.278  37.232  83.089  1.00 32.81           C  
ATOM     85  O   GLN A  17      17.854  37.877  82.211  1.00 33.55           O  
ATOM     86  CB  GLN A  17      16.555  34.886  82.740  1.00 32.81           C  
ATOM     87  CG  GLN A  17      16.460  34.976  81.252  1.00 33.80           C  
ATOM     88  CD  GLN A  17      17.699  34.396  80.527  1.00 33.94           C  
ATOM     89  OE1 GLN A  17      18.004  33.191  80.641  1.00 35.22           O  
ATOM     90  NE2 GLN A  17      18.404  35.264  79.771  1.00 28.33           N  
ATOM     91  N   ILE A  18      16.301  37.722  83.833  1.00 32.99           N  
ATOM     92  CA  ILE A  18      15.776  39.077  83.723  1.00 33.24           C  
ATOM     93  C   ILE A  18      16.818  40.084  84.184  1.00 34.00           C  
ATOM     94  O   ILE A  18      16.984  41.138  83.566  1.00 33.90           O  
ATOM     95  CB  ILE A  18      14.491  39.252  84.601  1.00 33.42           C  
ATOM     96  CG1 ILE A  18      13.341  38.373  84.061  1.00 33.40           C  
ATOM     97  CG2 ILE A  18      14.080  40.735  84.661  1.00 32.40           C  
ATOM     98  CD1 ILE A  18      12.211  38.037  85.084  1.00 33.50           C  
ATOM     99  N   ILE A  19      17.519  39.757  85.269  1.00 34.74           N  
ATOM    100  CA  ILE A  19      18.632  40.555  85.707  1.00 35.59           C  
ATOM    101  C   ILE A  19      19.642  40.694  84.544  1.00 36.93           C  
ATOM    102  O   ILE A  19      20.011  41.829  84.172  1.00 36.90           O  
ATOM    103  CB  ILE A  19      19.274  39.949  86.991  1.00 35.85           C  
ATOM    104  CG1 ILE A  19      18.445  40.272  88.242  1.00 35.32           C  
ATOM    105  CG2 ILE A  19      20.676  40.495  87.250  1.00 35.26           C  
ATOM    106  CD1 ILE A  19      18.871  39.456  89.459  1.00 34.12           C  
HETATM  107  N   MSE A  20      20.057  39.563  83.942  1.00 37.56           N  
HETATM  108  CA  MSE A  20      21.077  39.592  82.865  1.00 39.40           C  
HETATM  109  C   MSE A  20      20.591  40.367  81.679  1.00 37.56           C  
HETATM  110  O   MSE A  20      21.259  41.262  81.208  1.00 37.89           O  
HETATM  111  CB  MSE A  20      21.464  38.207  82.384  1.00 38.60           C  
HETATM  112  CG  MSE A  20      22.058  37.357  83.452  1.00 42.04           C  
HETATM  113 SE   MSE A  20      22.818  35.600  82.852  1.00 52.08          SE  
HETATM  114  CE  MSE A  20      21.193  34.632  82.228  1.00 42.91           C  
ATOM    115  N   ASP A  21      19.420  40.008  81.183  1.00 37.33           N  
ATOM    116  CA  ASP A  21      18.847  40.718  80.038  1.00 36.41           C  
ATOM    117  C   ASP A  21      18.736  42.232  80.256  1.00 35.13           C  
ATOM    118  O   ASP A  21      18.982  42.985  79.338  1.00 33.89           O  
ATOM    119  CB  ASP A  21      17.457  40.133  79.689  1.00 36.40           C  
ATOM    120  CG  ASP A  21      17.540  38.769  78.927  1.00 37.12           C  
ATOM    121  OD1 ASP A  21      18.599  38.125  78.829  1.00 38.50           O  
ATOM    122  OD2 ASP A  21      16.515  38.335  78.414  1.00 36.73           O  
ATOM    123  N   ASP A  22      18.297  42.658  81.446  1.00 34.76           N  
ATOM    124  CA  ASP A  22      18.119  44.100  81.742  1.00 34.40           C  
ATOM    125  C   ASP A  22      19.462  44.777  81.749  1.00 32.78           C  
ATOM    126  O   ASP A  22      19.621  45.877  81.259  1.00 32.26           O  
ATOM    127  CB  ASP A  22      17.438  44.360  83.113  1.00 34.44           C  
ATOM    128  CG  ASP A  22      15.966  44.006  83.134  1.00 36.88           C  
ATOM    129  OD1 ASP A  22      15.397  43.722  82.044  1.00 37.74           O  
ATOM    130  OD2 ASP A  22      15.376  44.003  84.257  1.00 39.02           O  
ATOM    131  N   LEU A  23      20.455  44.118  82.321  1.00 32.55           N  
ATOM    132  CA  LEU A  23      21.785  44.726  82.369  1.00 31.97           C  
ATOM    133  C   LEU A  23      22.366  44.941  80.993  1.00 31.39           C  
ATOM    134  O   LEU A  23      22.855  45.998  80.708  1.00 30.59           O  
ATOM    135  CB  LEU A  23      22.731  43.939  83.301  1.00 32.02           C  
ATOM    136  CG  LEU A  23      22.450  44.242  84.807  1.00 30.66           C  
ATOM    137  CD1 LEU A  23      23.089  43.235  85.769  1.00 28.60           C  
ATOM    138  CD2 LEU A  23      22.855  45.667  85.205  1.00 26.38           C  
ATOM    139  N   LEU A  24      22.280  43.950  80.119  1.00 32.40           N  
ATOM    140  CA  LEU A  24      22.770  44.125  78.733  1.00 32.57           C  
ATOM    141  C   LEU A  24      21.984  45.220  77.980  1.00 32.77           C  
ATOM    142  O   LEU A  24      22.572  46.034  77.305  1.00 32.44           O  
ATOM    143  CB  LEU A  24      22.687  42.836  77.936  1.00 32.02           C  
ATOM    144  CG  LEU A  24      23.432  41.588  78.397  1.00 33.90           C  
ATOM    145  CD1 LEU A  24      23.269  40.369  77.349  1.00 27.80           C  
ATOM    146  CD2 LEU A  24      24.896  41.903  78.708  1.00 28.06           C  
ATOM    147  N   ASN A  25      20.656  45.225  78.094  1.00 33.53           N  
ATOM    148  CA  ASN A  25      19.819  46.315  77.533  1.00 33.65           C  
ATOM    149  C   ASN A  25      20.256  47.684  78.027  1.00 33.48           C  
ATOM    150  O   ASN A  25      20.329  48.631  77.264  1.00 33.68           O  
ATOM    151  CB  ASN A  25      18.341  46.108  77.883  1.00 33.68           C  
ATOM    152  CG  ASN A  25      17.714  44.806  77.229  1.00 36.24           C  
ATOM    153  OD1 ASN A  25      18.197  44.265  76.211  1.00 36.85           O  
ATOM    154  ND2 ASN A  25      16.611  44.347  77.814  1.00 36.12           N  
ATOM    155  N   LEU A  26      20.574  47.820  79.309  1.00 34.69           N  
ATOM    156  CA  LEU A  26      21.005  49.159  79.834  1.00 34.57           C  
ATOM    157  C   LEU A  26      22.384  49.537  79.281  1.00 34.61           C  
ATOM    158  O   LEU A  26      22.650  50.666  78.886  1.00 35.67           O  
ATOM    159  CB  LEU A  26      20.997  49.189  81.356  1.00 33.98           C  
ATOM    160  CG  LEU A  26      19.669  49.076  82.134  1.00 35.36           C  
ATOM    161  CD1 LEU A  26      20.012  48.865  83.597  1.00 35.55           C  
ATOM    162  CD2 LEU A  26      18.731  50.279  82.006  1.00 34.78           C  
ATOM    163  N   LEU A  27      23.267  48.563  79.221  1.00 35.38           N  
ATOM    164  CA  LEU A  27      24.606  48.737  78.611  1.00 35.24           C  
ATOM    165  C   LEU A  27      24.507  49.247  77.168  1.00 35.60           C  
ATOM    166  O   LEU A  27      25.231  50.152  76.776  1.00 35.93           O  
ATOM    167  CB  LEU A  27      25.270  47.381  78.584  1.00 34.62           C  
ATOM    168  CG  LEU A  27      26.765  47.122  78.682  1.00 35.37           C  
ATOM    169  CD1 LEU A  27      27.052  45.782  77.876  1.00 31.29           C  
ATOM    170  CD2 LEU A  27      27.581  48.232  78.246  1.00 29.69           C  
ATOM    171  N   LEU A  28      23.609  48.659  76.373  1.00 35.50           N  
ATOM    172  CA  LEU A  28      23.514  49.034  74.952  1.00 35.77           C  
ATOM    173  C   LEU A  28      22.892  50.414  74.837  1.00 35.81           C  
ATOM    174  O   LEU A  28      23.338  51.203  74.042  1.00 36.33           O  
ATOM    175  CB  LEU A  28      22.792  47.966  74.088  1.00 35.06           C  
ATOM    176  CG  LEU A  28      23.782  47.002  73.411  1.00 35.46           C  
ATOM    177  CD1 LEU A  28      24.724  46.429  74.467  1.00 34.05           C  
ATOM    178  CD2 LEU A  28      23.124  45.839  72.565  1.00 34.55           C  
ATOM    179  N   LYS A  29      21.918  50.731  75.683  1.00 36.81           N  
ATOM    180  CA  LYS A  29      21.400  52.104  75.788  1.00 37.10           C  
ATOM    181  C   LYS A  29      22.494  53.150  76.091  1.00 36.79           C  
ATOM    182  O   LYS A  29      22.511  54.210  75.490  1.00 35.93           O  
ATOM    183  CB  LYS A  29      20.327  52.197  76.875  1.00 38.31           C  
ATOM    184  CG  LYS A  29      18.896  52.026  76.407  1.00 42.67           C  
ATOM    185  CD  LYS A  29      18.110  53.346  76.428  1.00 50.32           C  
ATOM    186  CE  LYS A  29      17.986  53.986  77.858  1.00 54.58           C  
ATOM    187  NZ  LYS A  29      17.672  53.018  78.997  1.00 56.21           N  
ATOM    188  N   GLU A  30      23.364  52.867  77.056  1.00 36.61           N  
ATOM    189  CA  GLU A  30      24.272  53.899  77.581  1.00 36.52           C  
ATOM    190  C   GLU A  30      25.517  54.064  76.678  1.00 36.79           C  
ATOM    191  O   GLU A  30      26.156  55.126  76.655  1.00 37.60           O  
ATOM    192  CB  GLU A  30      24.687  53.562  79.025  1.00 35.84           C  
ATOM    193  CG  GLU A  30      25.570  54.660  79.703  1.00 36.59           C  
ATOM    194  CD  GLU A  30      25.849  54.438  81.201  1.00 35.88           C  
ATOM    195  OE1 GLU A  30      25.104  53.663  81.809  1.00 34.26           O  
ATOM    196  OE2 GLU A  30      26.809  55.036  81.768  1.00 31.39           O  
ATOM    197  N   PHE A  31      25.890  53.011  75.954  1.00 36.74           N  
ATOM    198  CA  PHE A  31      27.149  53.032  75.203  1.00 36.27           C  
ATOM    199  C   PHE A  31      26.979  52.654  73.757  1.00 36.19           C  
ATOM    200  O   PHE A  31      25.986  52.025  73.365  1.00 35.60           O  
ATOM    201  CB  PHE A  31      28.183  52.126  75.853  1.00 35.68           C  
ATOM    202  CG  PHE A  31      28.523  52.505  77.279  1.00 35.05           C  
ATOM    203  CD1 PHE A  31      29.374  53.575  77.548  1.00 34.81           C  
ATOM    204  CD2 PHE A  31      28.016  51.777  78.346  1.00 33.94           C  
ATOM    205  CE1 PHE A  31      29.716  53.926  78.842  1.00 33.45           C  
ATOM    206  CE2 PHE A  31      28.350  52.130  79.669  1.00 34.56           C  
ATOM    207  CZ  PHE A  31      29.192  53.213  79.908  1.00 34.22           C  
ATOM    208  N   LYS A  32      27.982  53.040  72.961  1.00 37.48           N  
ATOM    209  CA  LYS A  32      28.027  52.742  71.507  1.00 37.68           C  
ATOM    210  C   LYS A  32      28.392  51.298  71.195  1.00 37.30           C  
ATOM    211  O   LYS A  32      29.235  51.054  70.334  1.00 38.06           O  
ATOM    212  CB  LYS A  32      29.011  53.685  70.794  1.00 38.19           C  
ATOM    213  CG  LYS A  32      28.677  55.160  70.988  1.00 39.37           C  
ATOM    214  CD  LYS A  32      29.741  56.071  70.369  1.00 39.46           C  
ATOM    215  CE  LYS A  32      29.482  57.552  70.775  1.00 40.27           C  
ATOM    216  NZ  LYS A  32      30.334  58.465  69.946  1.00 41.26           N  
ATOM    217  N   LEU A  33      27.752  50.363  71.906  1.00 37.06           N  
ATOM    218  CA  LEU A  33      27.825  48.940  71.642  1.00 36.91           C  
ATOM    219  C   LEU A  33      26.568  48.588  70.860  1.00 37.24           C  
ATOM    220  O   LEU A  33      25.501  49.187  71.077  1.00 37.96           O  
ATOM    221  CB  LEU A  33      27.828  48.154  72.944  1.00 36.38           C  
ATOM    222  CG  LEU A  33      29.114  48.248  73.737  1.00 35.67           C  
ATOM    223  CD1 LEU A  33      28.885  47.654  75.107  1.00 32.03           C  
ATOM    224  CD2 LEU A  33      30.287  47.573  72.984  1.00 31.34           C  
ATOM    225  N   ASP A  34      26.682  47.619  69.970  1.00 36.14           N  
ATOM    226  CA  ASP A  34      25.559  47.208  69.160  1.00 35.45           C  
ATOM    227  C   ASP A  34      25.157  45.787  69.473  1.00 34.83           C  
ATOM    228  O   ASP A  34      24.071  45.371  69.099  1.00 35.41           O  
ATOM    229  CB  ASP A  34      25.925  47.299  67.683  1.00 35.99           C  
ATOM    230  CG  ASP A  34      26.165  48.704  67.253  1.00 37.33           C  
ATOM    231  OD1 ASP A  34      25.168  49.434  67.091  1.00 43.09           O  
ATOM    232  OD2 ASP A  34      27.339  49.096  67.091  1.00 38.86           O  
ATOM    233  N   LEU A  35      26.017  45.028  70.146  1.00 33.88           N  
ATOM    234  CA  LEU A  35      25.650  43.660  70.536  1.00 33.15           C  
ATOM    235  C   LEU A  35      26.427  43.308  71.782  1.00 31.40           C  
ATOM    236  O   LEU A  35      27.543  43.773  71.938  1.00 29.70           O  
ATOM    237  CB  LEU A  35      25.937  42.666  69.404  1.00 32.76           C  
ATOM    238  CG  LEU A  35      25.636  41.175  69.655  1.00 33.61           C  
ATOM    239  CD1 LEU A  35      24.147  40.829  69.853  1.00 33.49           C  
ATOM    240  CD2 LEU A  35      26.204  40.377  68.465  1.00 34.46           C  
ATOM    241  N   ALA A  36      25.783  42.530  72.662  1.00 30.05           N  
ATOM    242  CA  ALA A  36      26.353  42.058  73.904  1.00 29.10           C  
ATOM    243  C   ALA A  36      25.821  40.653  74.125  1.00 28.70           C  
ATOM    244  O   ALA A  36      24.648  40.410  73.939  1.00 28.21           O  
ATOM    245  CB  ALA A  36      25.966  42.992  75.113  1.00 27.94           C  
ATOM    246  N   VAL A  37      26.677  39.743  74.561  1.00 28.72           N  
ATOM    247  CA  VAL A  37      26.285  38.362  74.784  1.00 29.15           C  
ATOM    248  C   VAL A  37      26.865  37.934  76.142  1.00 29.36           C  
ATOM    249  O   VAL A  37      27.986  38.280  76.459  1.00 30.30           O  
ATOM    250  CB  VAL A  37      26.765  37.393  73.605  1.00 29.39           C  
ATOM    251  CG1 VAL A  37      26.189  36.024  73.748  1.00 28.01           C  
ATOM    252  CG2 VAL A  37      26.407  37.936  72.229  1.00 26.61           C  
ATOM    253  N   ILE A  38      26.072  37.245  76.957  1.00 29.26           N  
ATOM    254  CA  ILE A  38      26.586  36.491  78.121  1.00 29.25           C  
ATOM    255  C   ILE A  38      26.543  34.976  77.765  1.00 29.47           C  
ATOM    256  O   ILE A  38      25.519  34.471  77.325  1.00 29.64           O  
ATOM    257  CB  ILE A  38      25.747  36.752  79.389  1.00 28.62           C  
ATOM    258  CG1 ILE A  38      25.954  38.180  79.886  1.00 29.10           C  
ATOM    259  CG2 ILE A  38      26.070  35.746  80.498  1.00 29.62           C  
ATOM    260  CD1 ILE A  38      24.793  38.704  80.723  1.00 27.10           C  
ATOM    261  N   ARG A  39      27.662  34.287  77.946  1.00 30.05           N  
ATOM    262  CA  ARG A  39      27.708  32.844  77.910  1.00 31.14           C  
ATOM    263  C   ARG A  39      28.076  32.317  79.299  1.00 31.88           C  
ATOM    264  O   ARG A  39      28.895  32.925  79.999  1.00 31.21           O  
ATOM    265  CB  ARG A  39      28.742  32.343  76.905  1.00 30.59           C  
ATOM    266  CG  ARG A  39      28.449  32.771  75.507  1.00 31.69           C  
ATOM    267  CD  ARG A  39      29.483  32.187  74.579  1.00 32.63           C  
ATOM    268  NE  ARG A  39      29.102  32.350  73.177  1.00 34.30           N  
ATOM    269  CZ  ARG A  39      29.178  33.499  72.497  1.00 34.49           C  
ATOM    270  NH1 ARG A  39      29.590  34.627  73.071  1.00 34.67           N  
ATOM    271  NH2 ARG A  39      28.812  33.538  71.230  1.00 34.68           N  
ATOM    272  N   LEU A  40      27.478  31.174  79.660  1.00 32.50           N  
ATOM    273  CA  LEU A  40      27.796  30.473  80.897  1.00 32.90           C  
ATOM    274  C   LEU A  40      28.171  29.040  80.583  1.00 34.23           C  
ATOM    275  O   LEU A  40      27.638  28.435  79.666  1.00 34.61           O  
ATOM    276  CB  LEU A  40      26.614  30.524  81.881  1.00 32.39           C  
ATOM    277  CG  LEU A  40      26.147  31.932  82.295  1.00 32.90           C  
ATOM    278  CD1 LEU A  40      24.880  31.973  83.243  1.00 31.11           C  
ATOM    279  CD2 LEU A  40      27.304  32.727  82.880  1.00 31.32           C  
ATOM    280  N   VAL A  41      29.109  28.500  81.343  1.00 36.17           N  
ATOM    281  CA  VAL A  41      29.475  27.133  81.158  1.00 37.97           C  
ATOM    282  C   VAL A  41      28.317  26.253  81.592  1.00 38.91           C  
ATOM    283  O   VAL A  41      27.694  26.518  82.613  1.00 39.13           O  
ATOM    284  CB  VAL A  41      30.771  26.744  81.911  1.00 38.39           C  
ATOM    285  CG1 VAL A  41      31.144  25.332  81.533  1.00 39.09           C  
ATOM    286  CG2 VAL A  41      31.913  27.652  81.523  1.00 38.53           C  
ATOM    287  N   ASP A  42      28.025  25.214  80.803  1.00 40.36           N  
ATOM    288  CA  ASP A  42      27.045  24.218  81.197  1.00 41.84           C  
ATOM    289  C   ASP A  42      27.812  23.095  81.904  1.00 42.76           C  
ATOM    290  O   ASP A  42      29.035  23.146  81.994  1.00 43.31           O  
ATOM    291  CB  ASP A  42      26.223  23.724  79.988  1.00 40.95           C  
ATOM    292  CG  ASP A  42      27.056  22.943  78.970  1.00 40.00           C  
ATOM    293  OD1 ASP A  42      28.245  22.660  79.258  1.00 36.02           O  
ATOM    294  OD2 ASP A  42      26.513  22.591  77.893  1.00 36.33           O  
ATOM    295  N   GLU A  43      27.082  22.106  82.416  1.00 44.06           N  
ATOM    296  CA  GLU A  43      27.674  20.907  83.052  1.00 44.97           C  
ATOM    297  C   GLU A  43      28.836  20.297  82.239  1.00 45.31           C  
ATOM    298  O   GLU A  43      29.848  19.920  82.806  1.00 46.21           O  
ATOM    299  CB  GLU A  43      26.615  19.802  83.304  1.00 45.92           C  
ATOM    300  CG  GLU A  43      25.112  20.260  83.307  1.00 49.10           C  
ATOM    301  CD  GLU A  43      24.506  20.353  81.885  1.00 52.57           C  
ATOM    302  OE1 GLU A  43      24.515  19.328  81.151  1.00 54.96           O  
ATOM    303  OE2 GLU A  43      24.026  21.445  81.505  1.00 52.51           O  
ATOM    304  N   LYS A  44      28.701  20.228  80.915  1.00 45.14           N  
ATOM    305  CA  LYS A  44      29.716  19.597  80.078  1.00 44.45           C  
ATOM    306  C   LYS A  44      30.881  20.531  79.757  1.00 43.82           C  
ATOM    307  O   LYS A  44      31.767  20.173  78.970  1.00 43.93           O  
ATOM    308  CB  LYS A  44      29.078  19.080  78.787  1.00 45.42           C  
ATOM    309  CG  LYS A  44      28.071  17.935  79.017  1.00 48.15           C  
ATOM    310  CD  LYS A  44      26.639  18.453  79.275  1.00 52.85           C  
ATOM    311  CE  LYS A  44      25.768  18.574  77.964  1.00 54.63           C  
ATOM    312  NZ  LYS A  44      24.428  19.228  78.190  1.00 53.47           N  
ATOM    313  N   GLY A  45      30.892  21.722  80.364  1.00 42.55           N  
ATOM    314  CA  GLY A  45      31.948  22.723  80.093  1.00 41.36           C  
ATOM    315  C   GLY A  45      31.824  23.598  78.831  1.00 40.44           C  
ATOM    316  O   GLY A  45      32.731  24.382  78.550  1.00 40.25           O  
ATOM    317  N   VAL A  46      30.741  23.465  78.057  1.00 38.43           N  
ATOM    318  CA  VAL A  46      30.512  24.326  76.891  1.00 37.63           C  
ATOM    319  C   VAL A  46      29.997  25.737  77.336  1.00 36.53           C  
ATOM    320  O   VAL A  46      29.154  25.851  78.233  1.00 35.05           O  
ATOM    321  CB  VAL A  46      29.482  23.653  75.906  1.00 37.78           C  
ATOM    322  CG1 VAL A  46      29.157  24.565  74.685  1.00 38.06           C  
ATOM    323  CG2 VAL A  46      29.958  22.288  75.472  1.00 35.47           C  
ATOM    324  N   LEU A  47      30.514  26.789  76.697  1.00 35.83           N  
ATOM    325  CA  LEU A  47      30.030  28.168  76.889  1.00 35.75           C  
ATOM    326  C   LEU A  47      28.755  28.394  76.072  1.00 34.87           C  
ATOM    327  O   LEU A  47      28.797  28.613  74.854  1.00 34.81           O  
ATOM    328  CB  LEU A  47      31.093  29.201  76.504  1.00 35.72           C  
ATOM    329  CG  LEU A  47      32.211  29.457  77.523  1.00 37.04           C  
ATOM    330  CD1 LEU A  47      33.283  30.320  76.890  1.00 35.25           C  
ATOM    331  CD2 LEU A  47      31.673  30.120  78.812  1.00 37.61           C  
ATOM    332  N   ARG A  48      27.623  28.305  76.764  1.00 34.50           N  
ATOM    333  CA  ARG A  48      26.325  28.405  76.168  1.00 34.04           C  
ATOM    334  C   ARG A  48      25.841  29.846  76.235  1.00 33.77           C  
ATOM    335  O   ARG A  48      25.881  30.472  77.307  1.00 32.84           O  
ATOM    336  CB  ARG A  48      25.341  27.515  76.935  1.00 35.07           C  
ATOM    337  CG  ARG A  48      25.624  25.997  76.903  1.00 38.42           C  
ATOM    338  CD  ARG A  48      25.135  25.286  75.651  1.00 42.35           C  
ATOM    339  NE  ARG A  48      23.843  25.804  75.185  1.00 45.15           N  
ATOM    340  CZ  ARG A  48      22.622  25.331  75.489  1.00 46.50           C  
ATOM    341  NH1 ARG A  48      21.548  25.951  74.997  1.00 46.18           N  
ATOM    342  NH2 ARG A  48      22.445  24.275  76.284  1.00 46.13           N  
ATOM    343  N   VAL A  49      25.322  30.339  75.111  1.00 32.95           N  
ATOM    344  CA  VAL A  49      24.588  31.615  75.090  1.00 32.25           C  
ATOM    345  C   VAL A  49      23.327  31.581  75.965  1.00 32.85           C  
ATOM    346  O   VAL A  49      22.387  30.776  75.738  1.00 32.07           O  
ATOM    347  CB  VAL A  49      24.157  32.027  73.681  1.00 31.63           C  
ATOM    348  CG1 VAL A  49      23.378  33.337  73.755  1.00 29.96           C  
ATOM    349  CG2 VAL A  49      25.386  32.113  72.756  1.00 29.37           C  
ATOM    350  N   ARG A  50      23.344  32.441  76.997  1.00 32.29           N  
ATOM    351  CA  ARG A  50      22.242  32.523  77.960  1.00 30.96           C  
ATOM    352  C   ARG A  50      21.543  33.881  77.965  1.00 30.00           C  
ATOM    353  O   ARG A  50      20.467  33.991  78.480  1.00 30.67           O  
ATOM    354  CB  ARG A  50      22.760  32.189  79.363  1.00 30.27           C  
ATOM    355  CG  ARG A  50      23.327  30.773  79.502  1.00 29.16           C  
ATOM    356  CD  ARG A  50      22.408  29.720  78.857  1.00 29.56           C  
ATOM    357  NE  ARG A  50      22.688  28.376  79.319  1.00 27.07           N  
ATOM    358  CZ  ARG A  50      21.977  27.310  78.993  1.00 28.74           C  
ATOM    359  NH1 ARG A  50      20.933  27.432  78.201  1.00 31.32           N  
ATOM    360  NH2 ARG A  50      22.304  26.110  79.464  1.00 30.80           N  
ATOM    361  N   SER A  51      22.145  34.905  77.399  1.00 29.41           N  
ATOM    362  CA  SER A  51      21.540  36.208  77.375  1.00 29.56           C  
ATOM    363  C   SER A  51      22.224  37.029  76.325  1.00 30.23           C  
ATOM    364  O   SER A  51      23.376  36.848  76.068  1.00 30.74           O  
ATOM    365  CB  SER A  51      21.697  36.885  78.745  1.00 29.14           C  
ATOM    366  OG  SER A  51      21.151  38.188  78.728  1.00 29.19           O  
ATOM    367  N   TYR A  52      21.512  37.953  75.721  1.00 32.71           N  
ATOM    368  CA  TYR A  52      22.094  38.809  74.673  1.00 34.08           C  
ATOM    369  C   TYR A  52      21.179  40.007  74.416  1.00 33.80           C  
ATOM    370  O   TYR A  52      19.993  39.942  74.673  1.00 33.25           O  
ATOM    371  CB  TYR A  52      22.301  38.004  73.387  1.00 35.22           C  
ATOM    372  CG  TYR A  52      21.030  37.718  72.688  1.00 36.21           C  
ATOM    373  CD1 TYR A  52      20.392  36.482  72.809  1.00 38.01           C  
ATOM    374  CD2 TYR A  52      20.437  38.707  71.916  1.00 38.67           C  
ATOM    375  CE1 TYR A  52      19.173  36.258  72.151  1.00 39.88           C  
ATOM    376  CE2 TYR A  52      19.254  38.508  71.283  1.00 38.92           C  
ATOM    377  CZ  TYR A  52      18.624  37.298  71.392  1.00 38.43           C  
ATOM    378  OH  TYR A  52      17.452  37.190  70.699  1.00 40.90           O  
ATOM    379  N   SER A  53      21.742  41.097  73.940  1.00 34.16           N  
ATOM    380  CA  SER A  53      20.954  42.283  73.596  1.00 35.13           C  
ATOM    381  C   SER A  53      21.528  42.849  72.292  1.00 35.23           C  
ATOM    382  O   SER A  53      22.668  42.642  72.015  1.00 34.29           O  
ATOM    383  CB  SER A  53      20.963  43.324  74.733  1.00 35.06           C  
ATOM    384  OG  SER A  53      20.137  44.464  74.431  1.00 33.90           O  
ATOM    385  N   GLY A  54      20.715  43.537  71.503  1.00 36.58           N  
ATOM    386  CA  GLY A  54      21.133  44.000  70.192  1.00 38.11           C  
ATOM    387  C   GLY A  54      20.905  42.935  69.118  1.00 39.41           C  
ATOM    388  O   GLY A  54      20.438  41.821  69.391  1.00 40.35           O  
ATOM    389  N   LYS A  55      21.272  43.267  67.895  1.00 40.70           N  
ATOM    390  CA  LYS A  55      21.071  42.368  66.760  1.00 41.63           C  
ATOM    391  C   LYS A  55      22.399  41.805  66.283  1.00 41.68           C  
ATOM    392  O   LYS A  55      23.416  42.416  66.478  1.00 41.86           O  
ATOM    393  CB  LYS A  55      20.300  43.084  65.627  1.00 42.26           C  
ATOM    394  CG  LYS A  55      20.595  44.592  65.450  1.00 42.24           C  
ATOM    395  CD  LYS A  55      19.781  45.207  64.307  1.00 42.60           C  
ATOM    396  CE  LYS A  55      20.593  46.252  63.529  1.00 43.26           C  
ATOM    397  NZ  LYS A  55      19.734  47.365  63.014  1.00 44.90           N  
ATOM    398  N   GLY A  56      22.369  40.614  65.694  1.00 42.88           N  
ATOM    399  CA  GLY A  56      23.566  39.847  65.310  1.00 43.59           C  
ATOM    400  C   GLY A  56      23.700  38.465  65.952  1.00 44.35           C  
ATOM    401  O   GLY A  56      24.608  37.708  65.603  1.00 45.57           O  
ATOM    402  N   ILE A  57      22.827  38.109  66.895  1.00 45.07           N  
ATOM    403  CA  ILE A  57      22.940  36.778  67.532  1.00 45.74           C  
ATOM    404  C   ILE A  57      22.766  35.587  66.552  1.00 46.67           C  
ATOM    405  O   ILE A  57      23.250  34.473  66.819  1.00 47.62           O  
ATOM    406  CB  ILE A  57      21.928  36.599  68.703  1.00 46.45           C  
ATOM    407  CG1 ILE A  57      22.557  35.751  69.848  1.00 46.80           C  
ATOM    408  CG2 ILE A  57      20.535  36.005  68.193  1.00 44.34           C  
ATOM    409  CD1 ILE A  57      23.760  36.381  70.522  1.00 43.03           C  
ATOM    410  N   ALA A  58      22.077  35.820  65.433  1.00 46.43           N  
ATOM    411  CA  ALA A  58      21.845  34.783  64.439  1.00 46.75           C  
ATOM    412  C   ALA A  58      23.048  34.627  63.472  1.00 46.70           C  
ATOM    413  O   ALA A  58      23.013  33.779  62.573  1.00 45.95           O  
ATOM    414  CB  ALA A  58      20.532  35.072  63.663  1.00 46.34           C  
ATOM    415  N   GLY A  59      24.092  35.445  63.671  1.00 46.91           N  
ATOM    416  CA  GLY A  59      25.343  35.353  62.888  1.00 47.31           C  
ATOM    417  C   GLY A  59      26.607  35.020  63.699  1.00 47.33           C  
ATOM    418  O   GLY A  59      26.568  34.207  64.639  1.00 46.44           O  
ATOM    419  N   ILE A  60      27.716  35.668  63.311  1.00 47.51           N  
ATOM    420  CA  ILE A  60      29.095  35.262  63.656  1.00 47.90           C  
ATOM    421  C   ILE A  60      29.392  35.280  65.150  1.00 47.62           C  
ATOM    422  O   ILE A  60      30.117  34.410  65.662  1.00 47.89           O  
ATOM    423  CB  ILE A  60      30.174  36.168  62.935  1.00 48.65           C  
ATOM    424  CG1 ILE A  60      31.482  35.414  62.710  1.00 48.55           C  
ATOM    425  CG2 ILE A  60      30.443  37.462  63.719  1.00 50.03           C  
ATOM    426  CD1 ILE A  60      31.390  34.472  61.544  1.00 50.39           C  
ATOM    427  N   ALA A  61      28.826  36.276  65.833  1.00 46.68           N  
ATOM    428  CA  ALA A  61      29.068  36.512  67.235  1.00 45.42           C  
ATOM    429  C   ALA A  61      28.094  35.730  68.137  1.00 45.05           C  
ATOM    430  O   ALA A  61      28.101  35.926  69.358  1.00 43.53           O  
ATOM    431  CB  ALA A  61      28.979  38.024  67.509  1.00 45.01           C  
ATOM    432  N   GLY A  62      27.313  34.799  67.572  1.00 44.76           N  
ATOM    433  CA  GLY A  62      26.155  34.238  68.304  1.00 44.97           C  
ATOM    434  C   GLY A  62      26.060  32.769  68.767  1.00 45.19           C  
ATOM    435  O   GLY A  62      24.981  32.357  69.344  1.00 45.21           O  
ATOM    436  N   LYS A  63      27.114  31.967  68.539  1.00 43.95           N  
ATOM    437  CA  LYS A  63      27.012  30.516  68.793  1.00 44.07           C  
ATOM    438  C   LYS A  63      27.493  30.068  70.186  1.00 44.32           C  
ATOM    439  O   LYS A  63      28.066  30.823  70.927  1.00 43.41           O  
ATOM    440  CB  LYS A  63      27.759  29.737  67.708  1.00 43.69           C  
ATOM    441  CG  LYS A  63      27.189  29.977  66.312  1.00 44.26           C  
ATOM    442  CD  LYS A  63      28.198  29.701  65.220  1.00 43.63           C  
ATOM    443  CE  LYS A  63      27.581  29.881  63.842  1.00 43.88           C  
ATOM    444  NZ  LYS A  63      28.021  28.813  62.883  1.00 44.05           N  
ATOM    445  N   ASP A  64      27.274  28.802  70.510  1.00 45.17           N  
ATOM    446  CA  ASP A  64      27.857  28.209  71.690  1.00 46.33           C  
ATOM    447  C   ASP A  64      29.316  27.804  71.436  1.00 46.99           C  
ATOM    448  O   ASP A  64      29.649  27.389  70.321  1.00 47.14           O  
ATOM    449  CB  ASP A  64      27.004  27.007  72.104  1.00 46.39           C  
ATOM    450  CG  ASP A  64      25.616  27.416  72.590  1.00 45.13           C  
ATOM    451  OD1 ASP A  64      25.366  28.625  72.831  1.00 40.94           O  
ATOM    452  OD2 ASP A  64      24.782  26.508  72.731  1.00 43.74           O  
ATOM    453  N   TRP A  65      30.188  27.946  72.444  1.00 47.71           N  
ATOM    454  CA  TRP A  65      31.620  27.632  72.272  1.00 48.41           C  
ATOM    455  C   TRP A  65      32.214  26.668  73.306  1.00 49.32           C  
ATOM    456  O   TRP A  65      32.164  26.897  74.532  1.00 48.22           O  
ATOM    457  CB  TRP A  65      32.459  28.930  72.201  1.00 49.83           C  
ATOM    458  CG  TRP A  65      32.104  29.695  70.967  1.00 51.66           C  
ATOM    459  CD1 TRP A  65      31.119  30.624  70.844  1.00 52.54           C  
ATOM    460  CD2 TRP A  65      32.649  29.510  69.646  1.00 52.50           C  
ATOM    461  NE1 TRP A  65      31.035  31.060  69.559  1.00 53.17           N  
ATOM    462  CE2 TRP A  65      31.972  30.408  68.795  1.00 52.86           C  
ATOM    463  CE3 TRP A  65      33.661  28.694  69.112  1.00 52.80           C  
ATOM    464  CZ2 TRP A  65      32.240  30.500  67.410  1.00 52.53           C  
ATOM    465  CZ3 TRP A  65      33.957  28.806  67.731  1.00 52.96           C  
ATOM    466  CH2 TRP A  65      33.238  29.703  66.898  1.00 51.98           C  
ATOM    467  N   GLU A  66      32.774  25.572  72.789  1.00 50.19           N  
ATOM    468  CA  GLU A  66      33.795  24.815  73.521  1.00 50.87           C  
ATOM    469  C   GLU A  66      35.051  25.703  73.606  1.00 50.88           C  
ATOM    470  O   GLU A  66      35.668  26.054  72.570  1.00 50.32           O  
ATOM    471  CB  GLU A  66      34.131  23.501  72.834  1.00 50.85           C  
ATOM    472  CG  GLU A  66      32.910  22.611  72.591  1.00 52.54           C  
ATOM    473  CD  GLU A  66      33.257  21.176  72.207  1.00 51.56           C  
ATOM    474  OE1 GLU A  66      34.423  20.883  71.849  1.00 52.70           O  
ATOM    475  OE2 GLU A  66      32.336  20.346  72.265  1.00 52.67           O  
ATOM    476  N   PRO A  67      35.428  26.079  74.843  1.00 50.91           N  
ATOM    477  CA  PRO A  67      36.540  27.011  74.973  1.00 50.88           C  
ATOM    478  C   PRO A  67      37.843  26.392  74.447  1.00 50.95           C  
ATOM    479  O   PRO A  67      38.126  25.209  74.681  1.00 50.62           O  
ATOM    480  CB  PRO A  67      36.588  27.314  76.474  1.00 50.62           C  
ATOM    481  CG  PRO A  67      35.906  26.187  77.113  1.00 50.76           C  
ATOM    482  CD  PRO A  67      34.896  25.652  76.148  1.00 50.27           C  
ATOM    483  N   GLU A  68      38.585  27.217  73.716  1.00 51.37           N  
ATOM    484  CA  GLU A  68      39.829  26.857  73.060  1.00 51.94           C  
ATOM    485  C   GLU A  68      40.776  28.029  72.882  1.00 51.44           C  
ATOM    486  O   GLU A  68      40.368  29.141  72.569  1.00 51.50           O  
ATOM    487  CB  GLU A  68      39.520  26.297  71.685  1.00 52.68           C  
ATOM    488  CG  GLU A  68      39.599  24.832  71.663  1.00 55.90           C  
ATOM    489  CD  GLU A  68      39.231  24.321  70.334  1.00 61.11           C  
ATOM    490  OE1 GLU A  68      39.848  24.769  69.323  1.00 63.87           O  
ATOM    491  OE2 GLU A  68      38.311  23.474  70.308  1.00 64.96           O  
ATOM    492  N   ILE A  69      42.058  27.760  73.020  1.00 51.45           N  
ATOM    493  CA  ILE A  69      43.052  28.832  72.982  1.00 51.19           C  
ATOM    494  C   ILE A  69      43.136  29.491  71.572  1.00 50.75           C  
ATOM    495  O   ILE A  69      43.479  30.664  71.465  1.00 50.55           O  
ATOM    496  CB  ILE A  69      44.432  28.365  73.622  1.00 51.11           C  
ATOM    497  CG1 ILE A  69      45.393  29.559  73.755  1.00 52.15           C  
ATOM    498  CG2 ILE A  69      45.068  27.201  72.844  1.00 50.41           C  
ATOM    499  CD1 ILE A  69      46.249  29.529  75.007  1.00 52.05           C  
ATOM    500  N   GLU A  70      42.730  28.773  70.520  1.00 50.27           N  
ATOM    501  CA  GLU A  70      42.712  29.326  69.145  1.00 49.96           C  
ATOM    502  C   GLU A  70      41.636  30.403  68.836  1.00 49.26           C  
ATOM    503  O   GLU A  70      41.647  31.000  67.753  1.00 48.97           O  
ATOM    504  CB  GLU A  70      42.601  28.198  68.094  1.00 50.49           C  
ATOM    505  CG  GLU A  70      43.826  27.265  68.000  1.00 51.27           C  
ATOM    506  CD  GLU A  70      43.785  26.095  69.001  1.00 53.28           C  
ATOM    507  OE1 GLU A  70      42.735  25.871  69.686  1.00 52.36           O  
ATOM    508  OE2 GLU A  70      44.827  25.406  69.093  1.00 53.73           O  
ATOM    509  N   THR A  71      40.716  30.640  69.762  1.00 48.37           N  
ATOM    510  CA  THR A  71      39.758  31.726  69.624  1.00 47.84           C  
ATOM    511  C   THR A  71      40.046  32.787  70.685  1.00 47.18           C  
ATOM    512  O   THR A  71      40.577  32.463  71.732  1.00 46.48           O  
ATOM    513  CB  THR A  71      38.302  31.187  69.798  1.00 48.27           C  
ATOM    514  OG1 THR A  71      38.171  30.608  71.097  1.00 44.78           O  
ATOM    515  CG2 THR A  71      37.949  30.106  68.690  1.00 47.83           C  
ATOM    516  N   TYR A  72      39.656  34.045  70.430  1.00 46.80           N  
ATOM    517  CA  TYR A  72      39.813  35.127  71.433  1.00 46.22           C  
ATOM    518  C   TYR A  72      38.972  34.864  72.680  1.00 45.13           C  
ATOM    519  O   TYR A  72      39.402  35.122  73.777  1.00 44.04           O  
ATOM    520  CB  TYR A  72      39.382  36.486  70.888  1.00 46.72           C  
ATOM    521  CG  TYR A  72      40.186  37.049  69.752  1.00 47.08           C  
ATOM    522  CD1 TYR A  72      41.395  37.697  69.973  1.00 47.76           C  
ATOM    523  CD2 TYR A  72      39.705  36.994  68.454  1.00 47.88           C  
ATOM    524  CE1 TYR A  72      42.140  38.243  68.919  1.00 46.40           C  
ATOM    525  CE2 TYR A  72      40.442  37.533  67.403  1.00 48.73           C  
ATOM    526  CZ  TYR A  72      41.662  38.157  67.644  1.00 47.49           C  
ATOM    527  OH  TYR A  72      42.378  38.694  66.584  1.00 48.51           O  
ATOM    528  N   ILE A  73      37.757  34.371  72.474  1.00 44.89           N  
ATOM    529  CA  ILE A  73      36.837  34.050  73.552  1.00 44.95           C  
ATOM    530  C   ILE A  73      37.288  32.848  74.415  1.00 44.82           C  
ATOM    531  O   ILE A  73      37.177  32.857  75.635  1.00 44.23           O  
ATOM    532  CB  ILE A  73      35.421  33.805  72.985  1.00 44.98           C  
ATOM    533  CG1 ILE A  73      34.396  33.754  74.119  1.00 43.34           C  
ATOM    534  CG2 ILE A  73      35.390  32.519  72.096  1.00 45.03           C  
ATOM    535  CD1 ILE A  73      32.996  33.866  73.632  1.00 45.20           C  
ATOM    536  N   GLY A  74      37.831  31.826  73.780  1.00 45.39           N  
ATOM    537  CA  GLY A  74      38.431  30.707  74.509  1.00 45.50           C  
ATOM    538  C   GLY A  74      39.658  31.132  75.296  1.00 45.69           C  
ATOM    539  O   GLY A  74      39.914  30.620  76.386  1.00 45.82           O  
ATOM    540  N   GLU A  75      40.417  32.067  74.735  1.00 45.67           N  
ATOM    541  CA  GLU A  75      41.630  32.539  75.380  1.00 45.21           C  
ATOM    542  C   GLU A  75      41.266  33.381  76.596  1.00 44.52           C  
ATOM    543  O   GLU A  75      41.919  33.298  77.618  1.00 44.43           O  
ATOM    544  CB  GLU A  75      42.517  33.325  74.389  1.00 46.27           C  
ATOM    545  CG  GLU A  75      43.792  34.020  75.003  1.00 47.45           C  
ATOM    546  CD  GLU A  75      44.682  33.066  75.798  1.00 51.90           C  
ATOM    547  OE1 GLU A  75      44.500  31.841  75.643  1.00 57.93           O  
ATOM    548  OE2 GLU A  75      45.560  33.524  76.579  1.00 52.44           O  
ATOM    549  N   ALA A  76      40.205  34.161  76.500  1.00 43.29           N  
ATOM    550  CA  ALA A  76      39.757  34.956  77.641  1.00 43.18           C  
ATOM    551  C   ALA A  76      39.291  34.076  78.796  1.00 42.37           C  
ATOM    552  O   ALA A  76      39.604  34.308  79.972  1.00 42.35           O  
ATOM    553  CB  ALA A  76      38.646  35.912  77.207  1.00 42.99           C  
ATOM    554  N   PHE A  77      38.533  33.050  78.442  1.00 42.27           N  
ATOM    555  CA  PHE A  77      37.985  32.131  79.415  1.00 41.63           C  
ATOM    556  C   PHE A  77      39.068  31.314  80.048  1.00 42.19           C  
ATOM    557  O   PHE A  77      39.102  31.190  81.274  1.00 43.27           O  
ATOM    558  CB  PHE A  77      36.992  31.180  78.762  1.00 40.66           C  
ATOM    559  CG  PHE A  77      36.326  30.264  79.724  1.00 39.14           C  
ATOM    560  CD1 PHE A  77      35.366  30.746  80.612  1.00 39.74           C  
ATOM    561  CD2 PHE A  77      36.661  28.938  79.773  1.00 38.74           C  
ATOM    562  CE1 PHE A  77      34.739  29.901  81.533  1.00 38.61           C  
ATOM    563  CE2 PHE A  77      36.033  28.079  80.685  1.00 39.28           C  
ATOM    564  CZ  PHE A  77      35.062  28.566  81.552  1.00 39.67           C  
ATOM    565  N   LEU A  78      39.937  30.746  79.201  1.00 42.21           N  
ATOM    566  CA  LEU A  78      40.920  29.766  79.644  1.00 42.30           C  
ATOM    567  C   LEU A  78      42.083  30.387  80.420  1.00 42.09           C  
ATOM    568  O   LEU A  78      42.647  29.732  81.263  1.00 41.98           O  
ATOM    569  CB  LEU A  78      41.463  28.952  78.463  1.00 41.52           C  
ATOM    570  CG  LEU A  78      40.625  27.740  78.031  1.00 41.96           C  
ATOM    571  CD1 LEU A  78      41.072  27.184  76.631  1.00 39.92           C  
ATOM    572  CD2 LEU A  78      40.688  26.643  79.094  1.00 38.40           C  
ATOM    573  N   SER A  79      42.447  31.618  80.082  1.00 42.30           N  
ATOM    574  CA  SER A  79      43.439  32.373  80.812  1.00 42.95           C  
ATOM    575  C   SER A  79      42.852  33.282  81.889  1.00 43.43           C  
ATOM    576  O   SER A  79      43.604  33.923  82.620  1.00 43.51           O  
ATOM    577  CB  SER A  79      44.199  33.282  79.869  1.00 43.16           C  
ATOM    578  OG  SER A  79      43.491  34.523  79.795  1.00 45.39           O  
ATOM    579  N   ASN A  80      41.522  33.382  81.970  1.00 43.86           N  
ATOM    580  CA  ASN A  80      40.882  34.291  82.905  1.00 43.43           C  
ATOM    581  C   ASN A  80      41.377  35.741  82.777  1.00 43.69           C  
ATOM    582  O   ASN A  80      41.680  36.413  83.733  1.00 43.83           O  
ATOM    583  CB  ASN A  80      41.008  33.765  84.332  1.00 43.41           C  
ATOM    584  CG  ASN A  80      40.062  34.471  85.304  1.00 41.88           C  
ATOM    585  OD1 ASN A  80      39.013  34.944  84.920  1.00 43.91           O  
ATOM    586  ND2 ASN A  80      40.452  34.548  86.553  1.00 41.08           N  
ATOM    587  N   ARG A  81      41.411  36.247  81.563  1.00 44.81           N  
ATOM    588  CA  ARG A  81      41.916  37.590  81.346  1.00 46.18           C  
ATOM    589  C   ARG A  81      41.215  38.112  80.148  1.00 45.08           C  
ATOM    590  O   ARG A  81      41.005  37.389  79.196  1.00 45.48           O  
ATOM    591  CB  ARG A  81      43.422  37.573  81.084  1.00 46.67           C  
ATOM    592  CG  ARG A  81      44.324  37.963  82.295  1.00 49.17           C  
ATOM    593  CD  ARG A  81      45.785  37.632  81.965  1.00 51.13           C  
ATOM    594  NE  ARG A  81      45.859  37.229  80.542  1.00 56.64           N  
ATOM    595  CZ  ARG A  81      46.526  37.856  79.560  1.00 56.15           C  
ATOM    596  NH1 ARG A  81      46.436  37.355  78.318  1.00 56.29           N  
ATOM    597  NH2 ARG A  81      47.291  38.935  79.793  1.00 53.95           N  
ATOM    598  N   LEU A  82      40.861  39.379  80.194  1.00 44.18           N  
ATOM    599  CA  LEU A  82      40.110  39.947  79.119  1.00 43.80           C  
ATOM    600  C   LEU A  82      40.934  39.988  77.845  1.00 42.26           C  
ATOM    601  O   LEU A  82      42.157  40.012  77.879  1.00 42.34           O  
ATOM    602  CB  LEU A  82      39.565  41.328  79.495  1.00 43.63           C  
ATOM    603  CG  LEU A  82      40.561  42.404  79.814  1.00 44.05           C  
ATOM    604  CD1 LEU A  82      41.027  43.079  78.545  1.00 44.41           C  
ATOM    605  CD2 LEU A  82      39.896  43.387  80.776  1.00 44.87           C  
ATOM    606  N   GLN A  83      40.225  39.953  76.735  1.00 40.68           N  
ATOM    607  CA  GLN A  83      40.797  40.029  75.412  1.00 40.30           C  
ATOM    608  C   GLN A  83      40.002  41.080  74.641  1.00 39.82           C  
ATOM    609  O   GLN A  83      38.743  41.103  74.706  1.00 39.31           O  
ATOM    610  CB  GLN A  83      40.608  38.682  74.725  1.00 41.44           C  
ATOM    611  CG  GLN A  83      41.127  37.491  75.499  1.00 43.98           C  
ATOM    612  CD  GLN A  83      42.638  37.520  75.627  1.00 49.27           C  
ATOM    613  OE1 GLN A  83      43.366  37.458  74.621  1.00 49.46           O  
ATOM    614  NE2 GLN A  83      43.123  37.623  76.873  1.00 51.38           N  
ATOM    615  N   PHE A  84      40.671  41.962  73.921  1.00 38.64           N  
ATOM    616  CA  PHE A  84      39.901  42.944  73.110  1.00 38.63           C  
ATOM    617  C   PHE A  84      40.625  43.340  71.830  1.00 37.20           C  
ATOM    618  O   PHE A  84      41.809  43.178  71.742  1.00 36.85           O  
ATOM    619  CB  PHE A  84      39.530  44.196  73.947  1.00 38.50           C  
ATOM    620  CG  PHE A  84      40.703  44.963  74.413  1.00 39.01           C  
ATOM    621  CD1 PHE A  84      41.199  46.030  73.665  1.00 40.25           C  
ATOM    622  CD2 PHE A  84      41.364  44.597  75.588  1.00 41.16           C  
ATOM    623  CE1 PHE A  84      42.332  46.730  74.104  1.00 39.69           C  
ATOM    624  CE2 PHE A  84      42.505  45.296  76.035  1.00 38.34           C  
ATOM    625  CZ  PHE A  84      42.983  46.348  75.292  1.00 38.38           C  
ATOM    626  N   VAL A  85      39.867  43.818  70.852  1.00 36.64           N  
ATOM    627  CA  VAL A  85      40.380  44.342  69.580  1.00 36.98           C  
ATOM    628  C   VAL A  85      39.735  45.726  69.401  1.00 36.85           C  
ATOM    629  O   VAL A  85      38.500  45.853  69.332  1.00 37.41           O  
ATOM    630  CB  VAL A  85      40.094  43.374  68.358  1.00 37.02           C  
ATOM    631  CG1 VAL A  85      40.482  43.986  67.033  1.00 35.48           C  
ATOM    632  CG2 VAL A  85      40.805  42.066  68.540  1.00 35.64           C  
ATOM    633  N   ASN A  86      40.568  46.773  69.381  1.00 36.87           N  
ATOM    634  CA  ASN A  86      40.049  48.141  69.242  1.00 36.69           C  
ATOM    635  C   ASN A  86      39.675  48.543  67.815  1.00 37.07           C  
ATOM    636  O   ASN A  86      38.766  49.355  67.618  1.00 36.95           O  
ATOM    637  CB  ASN A  86      40.970  49.155  69.922  1.00 36.17           C  
ATOM    638  CG  ASN A  86      40.460  49.534  71.287  1.00 34.12           C  
ATOM    639  OD1 ASN A  86      41.185  49.600  72.262  1.00 35.06           O  
ATOM    640  ND2 ASN A  86      39.190  49.737  71.362  1.00 30.98           N  
ATOM    641  N   ASP A  87      40.328  47.910  66.836  1.00 37.39           N  
ATOM    642  CA  ASP A  87      40.044  48.136  65.431  1.00 37.37           C  
ATOM    643  C   ASP A  87      40.184  46.834  64.631  1.00 37.12           C  
ATOM    644  O   ASP A  87      41.287  46.364  64.398  1.00 36.61           O  
ATOM    645  CB  ASP A  87      40.955  49.231  64.840  1.00 36.93           C  
ATOM    646  CG  ASP A  87      40.453  49.726  63.485  1.00 37.28           C  
ATOM    647  OD1 ASP A  87      39.781  48.923  62.806  1.00 32.73           O  
ATOM    648  OD2 ASP A  87      40.722  50.910  63.108  1.00 37.81           O  
ATOM    649  N   THR A  88      39.054  46.286  64.183  1.00 36.90           N  
ATOM    650  CA  THR A  88      39.068  45.056  63.430  1.00 37.21           C  
ATOM    651  C   THR A  88      39.910  45.106  62.122  1.00 37.51           C  
ATOM    652  O   THR A  88      40.276  44.061  61.615  1.00 37.10           O  
ATOM    653  CB  THR A  88      37.635  44.570  63.108  1.00 36.95           C  
ATOM    654  OG1 THR A  88      36.924  45.629  62.477  1.00 35.28           O  
ATOM    655  CG2 THR A  88      36.880  44.098  64.411  1.00 37.17           C  
ATOM    656  N   GLN A  89      40.228  46.287  61.586  1.00 37.81           N  
ATOM    657  CA  GLN A  89      41.064  46.317  60.394  1.00 38.62           C  
ATOM    658  C   GLN A  89      42.476  45.777  60.659  1.00 38.34           C  
ATOM    659  O   GLN A  89      43.151  45.401  59.731  1.00 37.90           O  
ATOM    660  CB  GLN A  89      41.088  47.702  59.708  1.00 38.26           C  
ATOM    661  CG  GLN A  89      42.060  48.690  60.302  1.00 39.73           C  
ATOM    662  CD  GLN A  89      42.120  50.064  59.562  1.00 41.10           C  
ATOM    663  OE1 GLN A  89      42.350  50.130  58.344  1.00 43.94           O  
ATOM    664  NE2 GLN A  89      41.973  51.166  60.327  1.00 43.36           N  
ATOM    665  N   TYR A  90      42.886  45.690  61.928  1.00 38.71           N  
ATOM    666  CA  TYR A  90      44.271  45.362  62.303  1.00 38.67           C  
ATOM    667  C   TYR A  90      44.428  44.050  63.034  1.00 38.20           C  
ATOM    668  O   TYR A  90      45.477  43.759  63.584  1.00 39.42           O  
ATOM    669  CB  TYR A  90      44.877  46.514  63.153  1.00 39.04           C  
ATOM    670  CG  TYR A  90      44.868  47.845  62.433  1.00 39.15           C  
ATOM    671  CD1 TYR A  90      45.235  47.937  61.080  1.00 39.37           C  
ATOM    672  CD2 TYR A  90      44.525  49.018  63.105  1.00 41.66           C  
ATOM    673  CE1 TYR A  90      45.221  49.150  60.414  1.00 39.44           C  
ATOM    674  CE2 TYR A  90      44.516  50.235  62.463  1.00 39.56           C  
ATOM    675  CZ  TYR A  90      44.854  50.288  61.108  1.00 40.75           C  
ATOM    676  OH  TYR A  90      44.846  51.481  60.460  1.00 41.10           O  
HETATM  677  N   MSE A  91      43.406  43.231  63.009  1.00 38.42           N  
HETATM  678  CA  MSE A  91      43.503  41.851  63.494  1.00 37.75           C  
HETATM  679  C   MSE A  91      44.432  41.020  62.651  1.00 38.81           C  
HETATM  680  O   MSE A  91      44.547  41.224  61.441  1.00 39.09           O  
HETATM  681  CB  MSE A  91      42.141  41.188  63.407  1.00 38.35           C  
HETATM  682  CG  MSE A  91      41.098  41.752  64.335  1.00 36.93           C  
HETATM  683 SE   MSE A  91      39.395  40.954  63.902  0.60 34.98          SE  
HETATM  684  CE  MSE A  91      39.659  39.304  64.866  1.00 30.58           C  
ATOM    685  N   THR A  92      45.059  40.040  63.290  1.00 39.79           N  
ATOM    686  CA  THR A  92      45.985  39.143  62.620  1.00 40.44           C  
ATOM    687  C   THR A  92      45.351  37.787  62.156  1.00 40.67           C  
ATOM    688  O   THR A  92      46.050  36.962  61.575  1.00 40.85           O  
ATOM    689  CB  THR A  92      47.201  38.856  63.550  1.00 41.11           C  
ATOM    690  OG1 THR A  92      46.754  38.139  64.702  1.00 42.70           O  
ATOM    691  CG2 THR A  92      47.854  40.167  64.015  1.00 40.29           C  
ATOM    692  N   LYS A  93      44.062  37.557  62.416  1.00 39.90           N  
ATOM    693  CA  LYS A  93      43.386  36.369  61.925  1.00 39.30           C  
ATOM    694  C   LYS A  93      42.628  36.768  60.660  1.00 38.91           C  
ATOM    695  O   LYS A  93      41.600  37.449  60.717  1.00 38.49           O  
ATOM    696  CB  LYS A  93      42.417  35.843  62.963  1.00 39.98           C  
ATOM    697  CG  LYS A  93      43.041  35.020  64.061  1.00 39.25           C  
ATOM    698  CD  LYS A  93      42.098  34.885  65.239  1.00 39.33           C  
ATOM    699  CE  LYS A  93      42.851  34.362  66.484  1.00 39.17           C  
ATOM    700  NZ  LYS A  93      43.436  32.995  66.249  1.00 38.79           N  
ATOM    701  N   PRO A  94      43.161  36.384  59.499  1.00 38.31           N  
ATOM    702  CA  PRO A  94      42.624  37.027  58.305  1.00 37.77           C  
ATOM    703  C   PRO A  94      41.204  36.622  57.894  1.00 37.35           C  
ATOM    704  O   PRO A  94      40.443  37.480  57.468  1.00 36.97           O  
ATOM    705  CB  PRO A  94      43.664  36.709  57.220  1.00 37.96           C  
ATOM    706  CG  PRO A  94      44.513  35.574  57.756  1.00 37.84           C  
ATOM    707  CD  PRO A  94      44.278  35.460  59.224  1.00 37.76           C  
ATOM    708  N   LEU A  95      40.837  35.351  58.007  1.00 37.30           N  
ATOM    709  CA  LEU A  95      39.463  34.949  57.673  1.00 37.02           C  
ATOM    710  C   LEU A  95      38.450  35.467  58.698  1.00 36.44           C  
ATOM    711  O   LEU A  95      37.402  35.974  58.343  1.00 35.76           O  
ATOM    712  CB  LEU A  95      39.335  33.421  57.558  1.00 37.09           C  
ATOM    713  CG  LEU A  95      37.873  33.035  57.291  1.00 37.16           C  
ATOM    714  CD1 LEU A  95      37.457  33.458  55.836  1.00 33.42           C  
ATOM    715  CD2 LEU A  95      37.669  31.591  57.570  1.00 37.43           C  
ATOM    716  N   THR A  96      38.776  35.293  59.966  1.00 36.81           N  
ATOM    717  CA  THR A  96      37.968  35.777  61.052  1.00 37.97           C  
ATOM    718  C   THR A  96      37.762  37.288  60.891  1.00 38.61           C  
ATOM    719  O   THR A  96      36.633  37.759  60.857  1.00 38.37           O  
ATOM    720  CB  THR A  96      38.648  35.447  62.413  1.00 38.45           C  
ATOM    721  OG1 THR A  96      38.962  34.040  62.482  1.00 38.58           O  
ATOM    722  CG2 THR A  96      37.781  35.877  63.596  1.00 36.95           C  
ATOM    723  N   ARG A  97      38.847  38.037  60.733  1.00 39.56           N  
ATOM    724  CA  ARG A  97      38.748  39.466  60.426  1.00 40.75           C  
ATOM    725  C   ARG A  97      37.794  39.737  59.280  1.00 42.14           C  
ATOM    726  O   ARG A  97      36.872  40.556  59.391  1.00 43.18           O  
ATOM    727  CB  ARG A  97      40.115  39.996  60.045  1.00 40.51           C  
ATOM    728  CG  ARG A  97      40.159  41.388  59.449  1.00 40.56           C  
ATOM    729  CD  ARG A  97      41.584  41.617  58.971  1.00 43.37           C  
ATOM    730  NE  ARG A  97      41.833  42.957  58.487  1.00 47.54           N  
ATOM    731  CZ  ARG A  97      41.563  43.402  57.249  1.00 50.59           C  
ATOM    732  NH1 ARG A  97      41.001  42.597  56.339  1.00 52.27           N  
ATOM    733  NH2 ARG A  97      41.859  44.679  56.907  1.00 47.92           N  
ATOM    734  N   GLU A  98      37.991  39.033  58.174  1.00 42.22           N  
ATOM    735  CA  GLU A  98      37.119  39.236  57.038  1.00 42.85           C  
ATOM    736  C   GLU A  98      35.633  38.968  57.402  1.00 42.62           C  
ATOM    737  O   GLU A  98      34.748  39.737  57.016  1.00 42.59           O  
ATOM    738  CB  GLU A  98      37.600  38.361  55.873  1.00 42.89           C  
ATOM    739  CG  GLU A  98      36.879  38.586  54.572  1.00 45.80           C  
ATOM    740  CD  GLU A  98      37.032  40.002  54.039  1.00 49.94           C  
ATOM    741  OE1 GLU A  98      38.075  40.664  54.322  1.00 49.84           O  
ATOM    742  OE2 GLU A  98      36.096  40.436  53.317  1.00 53.32           O  
ATOM    743  N   LEU A  99      35.370  37.892  58.150  1.00 42.41           N  
ATOM    744  CA  LEU A  99      33.981  37.494  58.498  1.00 42.17           C  
ATOM    745  C   LEU A  99      33.294  38.544  59.360  1.00 41.41           C  
ATOM    746  O   LEU A  99      32.136  38.851  59.170  1.00 40.73           O  
ATOM    747  CB  LEU A  99      33.959  36.163  59.227  1.00 41.90           C  
ATOM    748  CG  LEU A  99      33.623  34.862  58.507  1.00 43.93           C  
ATOM    749  CD1 LEU A  99      33.773  34.875  56.954  1.00 42.82           C  
ATOM    750  CD2 LEU A  99      34.436  33.713  59.153  1.00 42.48           C  
HETATM  751  N   MSE A 100      34.053  39.109  60.281  1.00 41.68           N  
HETATM  752  CA  MSE A 100      33.545  40.094  61.206  1.00 42.30           C  
HETATM  753  C   MSE A 100      33.275  41.446  60.562  1.00 42.57           C  
HETATM  754  O   MSE A 100      32.224  42.038  60.839  1.00 42.62           O  
HETATM  755  CB  MSE A 100      34.502  40.258  62.375  1.00 42.31           C  
HETATM  756  CG  MSE A 100      34.620  38.982  63.233  1.00 42.34           C  
HETATM  757 SE   MSE A 100      35.586  39.319  64.890  0.50 43.64          SE  
HETATM  758  CE  MSE A 100      34.667  40.965  65.343  1.00 44.48           C  
ATOM    759  N   GLN A 101      34.207  41.932  59.726  1.00 42.26           N  
ATOM    760  CA  GLN A 101      34.006  43.193  58.990  1.00 42.22           C  
ATOM    761  C   GLN A 101      32.791  43.090  58.029  1.00 42.09           C  
ATOM    762  O   GLN A 101      32.068  44.049  57.783  1.00 41.34           O  
ATOM    763  CB  GLN A 101      35.267  43.577  58.190  1.00 42.02           C  
ATOM    764  CG  GLN A 101      36.542  43.815  58.996  1.00 41.08           C  
ATOM    765  CD  GLN A 101      37.682  44.416  58.145  1.00 41.91           C  
ATOM    766  OE1 GLN A 101      38.044  43.900  57.066  1.00 40.83           O  
ATOM    767  NE2 GLN A 101      38.241  45.516  58.624  1.00 40.35           N  
ATOM    768  N   LYS A 102      32.574  41.904  57.493  1.00 42.83           N  
ATOM    769  CA  LYS A 102      31.424  41.643  56.648  1.00 43.22           C  
ATOM    770  C   LYS A 102      30.124  41.826  57.464  1.00 43.51           C  
ATOM    771  O   LYS A 102      29.109  42.237  56.928  1.00 44.82           O  
ATOM    772  CB  LYS A 102      31.595  40.231  56.020  1.00 43.68           C  
ATOM    773  CG  LYS A 102      30.428  39.672  55.176  1.00 43.76           C  
ATOM    774  CD  LYS A 102      30.041  40.521  53.935  1.00 43.78           C  
ATOM    775  CE  LYS A 102      28.624  40.128  53.487  1.00 43.78           C  
ATOM    776  NZ  LYS A 102      28.241  40.597  52.123  1.00 44.45           N  
ATOM    777  N   GLU A 103      30.158  41.536  58.758  1.00 43.61           N  
ATOM    778  CA  GLU A 103      29.055  41.842  59.661  1.00 44.02           C  
ATOM    779  C   GLU A 103      29.057  43.315  60.096  1.00 43.62           C  
ATOM    780  O   GLU A 103      28.125  43.743  60.776  1.00 43.43           O  
ATOM    781  CB  GLU A 103      29.146  41.000  60.954  1.00 44.81           C  
ATOM    782  CG  GLU A 103      29.087  39.496  60.783  1.00 47.77           C  
ATOM    783  CD  GLU A 103      27.780  38.881  61.273  1.00 51.94           C  
ATOM    784  OE1 GLU A 103      26.708  39.542  61.205  1.00 55.38           O  
ATOM    785  OE2 GLU A 103      27.813  37.715  61.705  1.00 53.13           O  
ATOM    786  N   GLY A 104      30.103  44.075  59.771  1.00 43.11           N  
ATOM    787  CA  GLY A 104      30.167  45.495  60.151  1.00 42.72           C  
ATOM    788  C   GLY A 104      30.814  45.796  61.505  1.00 42.44           C  
ATOM    789  O   GLY A 104      30.843  46.943  61.956  1.00 42.27           O  
ATOM    790  N   ILE A 105      31.373  44.771  62.142  1.00 42.37           N  
ATOM    791  CA  ILE A 105      32.049  44.918  63.456  1.00 41.59           C  
ATOM    792  C   ILE A 105      33.375  45.697  63.404  1.00 40.77           C  
ATOM    793  O   ILE A 105      34.323  45.277  62.728  1.00 39.41           O  
ATOM    794  CB  ILE A 105      32.319  43.533  64.108  1.00 41.47           C  
ATOM    795  CG1 ILE A 105      30.975  42.778  64.321  1.00 42.46           C  
ATOM    796  CG2 ILE A 105      33.128  43.714  65.433  1.00 41.10           C  
ATOM    797  CD1 ILE A 105      31.091  41.189  64.439  1.00 42.04           C  
ATOM    798  N   LYS A 106      33.443  46.806  64.144  1.00 39.70           N  
ATOM    799  CA  LYS A 106      34.651  47.653  64.201  1.00 39.92           C  
ATOM    800  C   LYS A 106      35.579  47.331  65.368  1.00 37.66           C  
ATOM    801  O   LYS A 106      36.771  47.553  65.310  1.00 36.94           O  
ATOM    802  CB  LYS A 106      34.237  49.137  64.283  1.00 39.93           C  
ATOM    803  CG  LYS A 106      33.514  49.547  63.034  1.00 41.32           C  
ATOM    804  CD  LYS A 106      33.375  51.052  62.825  1.00 41.79           C  
ATOM    805  CE  LYS A 106      32.772  51.315  61.419  1.00 42.57           C  
ATOM    806  NZ  LYS A 106      33.485  50.515  60.295  1.00 43.37           N  
ATOM    807  N   SER A 107      35.005  46.800  66.425  1.00 36.49           N  
ATOM    808  CA  SER A 107      35.596  46.855  67.764  1.00 35.77           C  
ATOM    809  C   SER A 107      34.930  45.736  68.625  1.00 35.00           C  
ATOM    810  O   SER A 107      33.715  45.506  68.500  1.00 34.80           O  
ATOM    811  CB  SER A 107      35.278  48.241  68.284  1.00 35.59           C  
ATOM    812  OG  SER A 107      35.905  48.525  69.504  1.00 39.74           O  
ATOM    813  N   PHE A 108      35.684  44.993  69.432  1.00 34.39           N  
ATOM    814  CA  PHE A 108      35.046  44.036  70.349  1.00 34.42           C  
ATOM    815  C   PHE A 108      35.877  43.710  71.564  1.00 33.79           C  
ATOM    816  O   PHE A 108      37.055  44.042  71.621  1.00 34.02           O  
ATOM    817  CB  PHE A 108      34.582  42.732  69.635  1.00 35.28           C  
ATOM    818  CG  PHE A 108      35.704  41.843  69.191  1.00 36.49           C  
ATOM    819  CD1 PHE A 108      36.258  40.914  70.063  1.00 36.64           C  
ATOM    820  CD2 PHE A 108      36.217  41.950  67.912  1.00 35.07           C  
ATOM    821  CE1 PHE A 108      37.317  40.107  69.666  1.00 37.64           C  
ATOM    822  CE2 PHE A 108      37.254  41.136  67.501  1.00 35.62           C  
ATOM    823  CZ  PHE A 108      37.809  40.210  68.383  1.00 36.57           C  
ATOM    824  N   ALA A 109      35.243  43.067  72.542  1.00 33.00           N  
ATOM    825  CA  ALA A 109      35.906  42.678  73.812  1.00 32.48           C  
ATOM    826  C   ALA A 109      35.257  41.428  74.406  1.00 31.97           C  
ATOM    827  O   ALA A 109      34.054  41.239  74.267  1.00 31.89           O  
ATOM    828  CB  ALA A 109      35.860  43.821  74.823  1.00 31.70           C  
ATOM    829  N   HIS A 110      36.081  40.564  75.013  1.00 31.71           N  
ATOM    830  CA  HIS A 110      35.621  39.416  75.791  1.00 30.70           C  
ATOM    831  C   HIS A 110      36.136  39.516  77.222  1.00 29.49           C  
ATOM    832  O   HIS A 110      37.328  39.621  77.442  1.00 28.17           O  
ATOM    833  CB  HIS A 110      36.052  38.098  75.133  1.00 30.64           C  
ATOM    834  CG  HIS A 110      35.462  37.886  73.776  1.00 31.32           C  
ATOM    835  ND1 HIS A 110      36.185  38.019  72.606  1.00 35.39           N  
ATOM    836  CD2 HIS A 110      34.209  37.553  73.404  1.00 31.82           C  
ATOM    837  CE1 HIS A 110      35.402  37.769  71.571  1.00 35.17           C  
ATOM    838  NE2 HIS A 110      34.198  37.476  72.029  1.00 34.70           N  
ATOM    839  N   ILE A 111      35.213  39.447  78.187  1.00 29.42           N  
ATOM    840  CA  ILE A 111      35.489  39.722  79.583  1.00 29.27           C  
ATOM    841  C   ILE A 111      35.048  38.543  80.399  1.00 29.82           C  
ATOM    842  O   ILE A 111      33.867  38.186  80.380  1.00 30.18           O  
ATOM    843  CB  ILE A 111      34.732  40.974  80.082  1.00 29.60           C  
ATOM    844  CG1 ILE A 111      35.069  42.196  79.197  1.00 29.93           C  
ATOM    845  CG2 ILE A 111      35.014  41.230  81.598  1.00 28.03           C  
ATOM    846  CD1 ILE A 111      33.876  42.579  78.342  1.00 31.23           C  
ATOM    847  N   PRO A 112      35.980  37.939  81.153  1.00 30.23           N  
ATOM    848  CA  PRO A 112      35.608  36.790  81.973  1.00 30.59           C  
ATOM    849  C   PRO A 112      34.600  37.160  83.046  1.00 31.22           C  
ATOM    850  O   PRO A 112      34.589  38.312  83.561  1.00 31.09           O  
ATOM    851  CB  PRO A 112      36.941  36.350  82.599  1.00 31.20           C  
ATOM    852  CG  PRO A 112      37.984  36.921  81.757  1.00 30.26           C  
ATOM    853  CD  PRO A 112      37.404  38.260  81.310  1.00 29.86           C  
ATOM    854  N   ILE A 113      33.721  36.211  83.341  1.00 32.03           N  
ATOM    855  CA  ILE A 113      32.706  36.402  84.381  1.00 32.58           C  
ATOM    856  C   ILE A 113      33.121  35.467  85.531  1.00 34.35           C  
ATOM    857  O   ILE A 113      33.078  34.237  85.413  1.00 34.40           O  
ATOM    858  CB  ILE A 113      31.297  36.120  83.880  1.00 32.01           C  
ATOM    859  CG1 ILE A 113      30.867  37.123  82.814  1.00 29.85           C  
ATOM    860  CG2 ILE A 113      30.284  36.120  85.051  1.00 31.94           C  
ATOM    861  CD1 ILE A 113      29.488  36.735  82.196  1.00 30.96           C  
ATOM    862  N   SER A 114      33.606  36.074  86.601  1.00 36.05           N  
ATOM    863  CA  SER A 114      34.113  35.335  87.732  1.00 38.32           C  
ATOM    864  C   SER A 114      33.935  36.146  88.989  1.00 39.93           C  
ATOM    865  O   SER A 114      33.989  37.378  88.996  1.00 39.58           O  
ATOM    866  CB  SER A 114      35.604  35.038  87.574  1.00 38.30           C  
ATOM    867  OG  SER A 114      36.304  36.236  87.271  1.00 39.91           O  
ATOM    868  N   ARG A 115      33.731  35.424  90.067  1.00 41.87           N  
ATOM    869  CA  ARG A 115      33.897  36.010  91.366  1.00 43.38           C  
ATOM    870  C   ARG A 115      35.410  36.232  91.603  1.00 43.15           C  
ATOM    871  O   ARG A 115      36.257  35.474  91.097  1.00 42.42           O  
ATOM    872  CB  ARG A 115      33.271  35.082  92.385  1.00 44.26           C  
ATOM    873  CG  ARG A 115      32.998  35.719  93.676  1.00 49.38           C  
ATOM    874  CD  ARG A 115      31.816  36.672  93.639  1.00 53.58           C  
ATOM    875  NE  ARG A 115      31.543  37.155  95.006  1.00 56.16           N  
ATOM    876  CZ  ARG A 115      32.284  38.053  95.677  1.00 57.35           C  
ATOM    877  NH1 ARG A 115      33.372  38.605  95.124  1.00 57.01           N  
ATOM    878  NH2 ARG A 115      31.927  38.416  96.920  1.00 57.10           N  
ATOM    879  N   LYS A 116      35.732  37.305  92.333  1.00 43.11           N  
ATOM    880  CA  LYS A 116      37.118  37.634  92.723  1.00 43.14           C  
ATOM    881  C   LYS A 116      37.884  36.436  93.297  1.00 42.85           C  
ATOM    882  O   LYS A 116      37.493  35.887  94.322  1.00 42.15           O  
ATOM    883  CB  LYS A 116      37.122  38.759  93.776  1.00 43.23           C  
ATOM    884  CG  LYS A 116      38.510  39.344  94.081  1.00 43.41           C  
ATOM    885  CD  LYS A 116      38.436  40.671  94.903  1.00 43.41           C  
ATOM    886  CE  LYS A 116      38.650  40.493  96.420  1.00 43.48           C  
ATOM    887  NZ  LYS A 116      38.351  41.767  97.205  1.00 42.82           N  
ATOM    888  N   GLY A 117      38.978  36.054  92.635  1.00 42.74           N  
ATOM    889  CA  GLY A 117      39.824  34.936  93.090  1.00 42.49           C  
ATOM    890  C   GLY A 117      39.317  33.542  92.722  1.00 42.47           C  
ATOM    891  O   GLY A 117      39.821  32.542  93.233  1.00 41.92           O  
ATOM    892  N   GLU A 118      38.303  33.475  91.853  1.00 42.24           N  
ATOM    893  CA  GLU A 118      37.691  32.210  91.480  1.00 42.21           C  
ATOM    894  C   GLU A 118      37.696  32.022  89.997  1.00 40.45           C  
ATOM    895  O   GLU A 118      37.687  32.989  89.269  1.00 40.07           O  
ATOM    896  CB  GLU A 118      36.242  32.139  91.936  1.00 42.27           C  
ATOM    897  CG  GLU A 118      36.112  31.681  93.342  1.00 44.47           C  
ATOM    898  CD  GLU A 118      34.730  31.928  93.895  1.00 44.65           C  
ATOM    899  OE1 GLU A 118      33.750  31.711  93.117  1.00 50.53           O  
ATOM    900  OE2 GLU A 118      34.647  32.351  95.076  1.00 45.25           O  
ATOM    901  N   PRO A 119      37.659  30.754  89.563  1.00 39.25           N  
ATOM    902  CA  PRO A 119      37.734  30.476  88.157  1.00 38.38           C  
ATOM    903  C   PRO A 119      36.470  30.989  87.467  1.00 37.46           C  
ATOM    904  O   PRO A 119      35.391  30.885  88.019  1.00 37.47           O  
ATOM    905  CB  PRO A 119      37.850  28.935  88.078  1.00 38.68           C  
ATOM    906  CG  PRO A 119      37.854  28.413  89.501  1.00 38.80           C  
ATOM    907  CD  PRO A 119      37.504  29.533  90.400  1.00 39.21           C  
ATOM    908  N   PRO A 120      36.620  31.558  86.274  1.00 36.63           N  
ATOM    909  CA  PRO A 120      35.507  32.080  85.533  1.00 36.83           C  
ATOM    910  C   PRO A 120      34.518  30.996  85.194  1.00 36.16           C  
ATOM    911  O   PRO A 120      34.921  29.843  84.965  1.00 36.15           O  
ATOM    912  CB  PRO A 120      36.148  32.648  84.253  1.00 36.65           C  
ATOM    913  CG  PRO A 120      37.406  31.936  84.103  1.00 37.22           C  
ATOM    914  CD  PRO A 120      37.880  31.730  85.534  1.00 37.57           C  
ATOM    915  N   PHE A 121      33.247  31.382  85.201  1.00 35.22           N  
ATOM    916  CA  PHE A 121      32.177  30.486  84.810  1.00 35.19           C  
ATOM    917  C   PHE A 121      31.351  30.954  83.605  1.00 33.82           C  
ATOM    918  O   PHE A 121      30.334  30.329  83.268  1.00 31.66           O  
ATOM    919  CB  PHE A 121      31.288  30.130  86.007  1.00 36.59           C  
ATOM    920  CG  PHE A 121      30.703  31.303  86.735  1.00 38.31           C  
ATOM    921  CD1 PHE A 121      31.150  31.629  88.012  1.00 41.16           C  
ATOM    922  CD2 PHE A 121      29.670  32.023  86.201  1.00 39.81           C  
ATOM    923  CE1 PHE A 121      30.599  32.681  88.714  1.00 40.60           C  
ATOM    924  CE2 PHE A 121      29.116  33.075  86.908  1.00 40.67           C  
ATOM    925  CZ  PHE A 121      29.584  33.401  88.149  1.00 39.67           C  
ATOM    926  N   GLY A 122      31.848  32.012  82.956  1.00 33.14           N  
ATOM    927  CA  GLY A 122      31.289  32.560  81.741  1.00 32.94           C  
ATOM    928  C   GLY A 122      32.114  33.680  81.121  1.00 32.68           C  
ATOM    929  O   GLY A 122      33.160  34.059  81.638  1.00 32.30           O  
ATOM    930  N   ILE A 123      31.624  34.177  79.978  1.00 31.80           N  
ATOM    931  CA  ILE A 123      32.183  35.317  79.254  1.00 31.19           C  
ATOM    932  C   ILE A 123      31.100  36.375  78.916  1.00 29.58           C  
ATOM    933  O   ILE A 123      30.037  36.060  78.475  1.00 30.04           O  
ATOM    934  CB  ILE A 123      32.870  34.853  77.954  1.00 30.88           C  
ATOM    935  CG1 ILE A 123      34.098  33.978  78.295  1.00 33.49           C  
ATOM    936  CG2 ILE A 123      33.344  36.025  77.136  1.00 30.44           C  
ATOM    937  CD1 ILE A 123      35.274  34.716  79.041  1.00 31.44           C  
ATOM    938  N   LEU A 124      31.409  37.625  79.161  1.00 28.20           N  
ATOM    939  CA  LEU A 124      30.651  38.722  78.673  1.00 28.22           C  
ATOM    940  C   LEU A 124      31.375  39.211  77.424  1.00 27.91           C  
ATOM    941  O   LEU A 124      32.496  39.646  77.534  1.00 27.43           O  
ATOM    942  CB  LEU A 124      30.582  39.838  79.746  1.00 27.93           C  
ATOM    943  CG  LEU A 124      30.088  41.199  79.272  1.00 28.32           C  
ATOM    944  CD1 LEU A 124      28.635  41.057  78.717  1.00 26.46           C  
ATOM    945  CD2 LEU A 124      30.250  42.355  80.355  1.00 27.54           C  
ATOM    946  N   SER A 125      30.733  39.108  76.256  1.00 27.82           N  
ATOM    947  CA  SER A 125      31.303  39.516  74.960  1.00 28.77           C  
ATOM    948  C   SER A 125      30.548  40.727  74.469  1.00 29.05           C  
ATOM    949  O   SER A 125      29.327  40.720  74.490  1.00 28.54           O  
ATOM    950  CB  SER A 125      31.155  38.404  73.901  1.00 28.25           C  
ATOM    951  OG  SER A 125      31.562  37.118  74.400  1.00 29.99           O  
ATOM    952  N   VAL A 126      31.244  41.748  73.990  1.00 30.46           N  
ATOM    953  CA  VAL A 126      30.574  42.966  73.497  1.00 31.09           C  
ATOM    954  C   VAL A 126      31.173  43.485  72.196  1.00 32.37           C  
ATOM    955  O   VAL A 126      32.370  43.436  71.976  1.00 33.08           O  
ATOM    956  CB  VAL A 126      30.624  44.089  74.562  1.00 31.22           C  
ATOM    957  CG1 VAL A 126      29.977  43.606  75.853  1.00 32.74           C  
ATOM    958  CG2 VAL A 126      32.066  44.507  74.865  1.00 32.41           C  
ATOM    959  N   PHE A 127      30.326  44.052  71.357  1.00 33.38           N  
ATOM    960  CA  PHE A 127      30.701  44.394  69.985  1.00 33.61           C  
ATOM    961  C   PHE A 127      30.108  45.735  69.608  1.00 33.53           C  
ATOM    962  O   PHE A 127      28.970  45.989  69.877  1.00 34.53           O  
ATOM    963  CB  PHE A 127      30.138  43.340  69.037  1.00 32.24           C  
ATOM    964  CG  PHE A 127      30.511  41.944  69.401  1.00 33.31           C  
ATOM    965  CD1 PHE A 127      31.624  41.308  68.763  1.00 33.33           C  
ATOM    966  CD2 PHE A 127      29.761  41.233  70.357  1.00 30.33           C  
ATOM    967  CE1 PHE A 127      31.970  40.024  69.078  1.00 29.40           C  
ATOM    968  CE2 PHE A 127      30.109  39.959  70.675  1.00 29.68           C  
ATOM    969  CZ  PHE A 127      31.219  39.338  70.047  1.00 30.19           C  
ATOM    970  N   SER A 128      30.893  46.589  69.001  1.00 35.08           N  
ATOM    971  CA  SER A 128      30.381  47.792  68.359  1.00 36.31           C  
ATOM    972  C   SER A 128      30.520  47.664  66.821  1.00 37.05           C  
ATOM    973  O   SER A 128      31.582  47.384  66.325  1.00 35.59           O  
ATOM    974  CB  SER A 128      31.154  49.014  68.850  1.00 35.66           C  
ATOM    975  OG  SER A 128      30.802  50.177  68.127  1.00 34.32           O  
ATOM    976  N   ARG A 129      29.409  47.842  66.107  1.00 38.83           N  
ATOM    977  CA  ARG A 129      29.412  48.128  64.669  1.00 40.74           C  
ATOM    978  C   ARG A 129      29.497  49.644  64.387  1.00 41.40           C  
ATOM    979  O   ARG A 129      29.306  50.089  63.240  1.00 41.16           O  
ATOM    980  CB  ARG A 129      28.157  47.527  64.010  1.00 40.36           C  
ATOM    981  CG  ARG A 129      28.187  46.015  64.035  1.00 42.82           C  
ATOM    982  CD  ARG A 129      27.030  45.388  63.327  1.00 43.75           C  
ATOM    983  NE  ARG A 129      25.830  45.548  64.132  1.00 47.51           N  
ATOM    984  CZ  ARG A 129      25.315  44.627  64.949  1.00 49.13           C  
ATOM    985  NH1 ARG A 129      25.882  43.420  65.064  1.00 49.33           N  
ATOM    986  NH2 ARG A 129      24.193  44.917  65.631  1.00 49.41           N  
ATOM    987  N   THR A 130      29.810  50.420  65.427  1.00 42.39           N  
ATOM    988  CA  THR A 130      29.587  51.890  65.419  1.00 42.99           C  
ATOM    989  C   THR A 130      30.941  52.634  65.481  1.00 43.67           C  
ATOM    990  O   THR A 130      31.147  53.566  64.716  1.00 44.64           O  
ATOM    991  CB  THR A 130      28.625  52.364  66.614  1.00 43.70           C  
ATOM    992  OG1 THR A 130      27.419  51.566  66.665  1.00 43.50           O  
ATOM    993  CG2 THR A 130      28.254  53.873  66.507  1.00 42.31           C  
ATOM    994  N   ILE A 131      31.842  52.189  66.356  1.00 43.57           N  
ATOM    995  CA  ILE A 131      33.097  52.899  66.605  1.00 43.58           C  
ATOM    996  C   ILE A 131      34.298  51.973  66.837  1.00 43.83           C  
ATOM    997  O   ILE A 131      34.140  50.819  67.235  1.00 43.65           O  
ATOM    998  CB  ILE A 131      32.970  53.868  67.796  1.00 43.98           C  
ATOM    999  CG1 ILE A 131      33.501  55.252  67.417  1.00 45.26           C  
ATOM   1000  CG2 ILE A 131      33.710  53.322  69.008  1.00 42.54           C  
ATOM   1001  CD1 ILE A 131      34.099  55.317  66.029  1.00 45.32           C  
ATOM   1002  N   VAL A 132      35.496  52.498  66.581  1.00 44.06           N  
ATOM   1003  CA  VAL A 132      36.740  51.881  66.993  1.00 44.34           C  
ATOM   1004  C   VAL A 132      37.215  52.620  68.242  1.00 44.85           C  
ATOM   1005  O   VAL A 132      36.713  53.710  68.517  1.00 44.62           O  
ATOM   1006  CB  VAL A 132      37.830  51.941  65.856  1.00 44.79           C  
ATOM   1007  CG1 VAL A 132      37.332  51.218  64.573  1.00 43.74           C  
ATOM   1008  CG2 VAL A 132      38.276  53.387  65.555  1.00 42.59           C  
ATOM   1009  N   GLY A 133      38.120  51.991  69.007  1.00 44.58           N  
ATOM   1010  CA  GLY A 133      38.781  52.614  70.142  1.00 44.58           C  
ATOM   1011  C   GLY A 133      37.927  52.640  71.395  1.00 45.04           C  
ATOM   1012  O   GLY A 133      38.272  53.286  72.390  1.00 45.37           O  
ATOM   1013  N   LEU A 134      36.810  51.933  71.356  1.00 45.17           N  
ATOM   1014  CA  LEU A 134      35.806  51.971  72.451  1.00 45.16           C  
ATOM   1015  C   LEU A 134      36.449  51.563  73.770  1.00 44.15           C  
ATOM   1016  O   LEU A 134      36.109  52.074  74.843  1.00 44.91           O  
ATOM   1017  CB  LEU A 134      34.643  51.010  72.113  1.00 45.23           C  
ATOM   1018  CG  LEU A 134      33.259  51.400  72.579  1.00 47.81           C  
ATOM   1019  CD1 LEU A 134      32.116  50.700  71.813  1.00 48.74           C  
ATOM   1020  CD2 LEU A 134      33.174  51.078  74.016  1.00 51.34           C  
ATOM   1021  N   PHE A 135      37.384  50.627  73.686  1.00 42.95           N  
ATOM   1022  CA  PHE A 135      37.838  49.907  74.864  1.00 42.09           C  
ATOM   1023  C   PHE A 135      39.060  50.542  75.394  1.00 41.81           C  
ATOM   1024  O   PHE A 135      40.131  50.005  75.265  1.00 42.69           O  
ATOM   1025  CB  PHE A 135      38.053  48.433  74.505  1.00 41.67           C  
ATOM   1026  CG  PHE A 135      36.808  47.792  73.994  1.00 41.48           C  
ATOM   1027  CD1 PHE A 135      35.770  47.457  74.890  1.00 41.11           C  
ATOM   1028  CD2 PHE A 135      36.600  47.616  72.635  1.00 41.24           C  
ATOM   1029  CE1 PHE A 135      34.584  46.904  74.430  1.00 40.18           C  
ATOM   1030  CE2 PHE A 135      35.392  47.064  72.171  1.00 40.33           C  
ATOM   1031  CZ  PHE A 135      34.410  46.699  73.062  1.00 41.15           C  
ATOM   1032  N   ASN A 136      38.899  51.736  75.942  1.00 42.05           N  
ATOM   1033  CA  ASN A 136      39.950  52.349  76.743  1.00 42.03           C  
ATOM   1034  C   ASN A 136      39.827  51.801  78.149  1.00 41.37           C  
ATOM   1035  O   ASN A 136      38.872  51.099  78.451  1.00 41.67           O  
ATOM   1036  CB  ASN A 136      39.849  53.887  76.733  1.00 42.66           C  
ATOM   1037  CG  ASN A 136      38.466  54.412  77.154  1.00 43.86           C  
ATOM   1038  OD1 ASN A 136      37.676  53.748  77.842  1.00 45.81           O  
ATOM   1039  ND2 ASN A 136      38.178  55.613  76.728  1.00 44.41           N  
ATOM   1040  N   GLU A 137      40.785  52.114  79.007  1.00 41.11           N  
ATOM   1041  CA  GLU A 137      40.808  51.560  80.387  1.00 41.06           C  
ATOM   1042  C   GLU A 137      39.575  51.940  81.209  1.00 39.85           C  
ATOM   1043  O   GLU A 137      39.054  51.114  81.955  1.00 37.91           O  
ATOM   1044  CB  GLU A 137      42.058  51.995  81.159  1.00 41.70           C  
ATOM   1045  CG  GLU A 137      43.392  51.889  80.389  1.00 45.08           C  
ATOM   1046  CD  GLU A 137      43.976  50.473  80.316  1.00 49.44           C  
ATOM   1047  OE1 GLU A 137      43.246  49.557  79.870  1.00 50.53           O  
ATOM   1048  OE2 GLU A 137      45.188  50.303  80.677  1.00 50.75           O  
ATOM   1049  N   PRO A 138      39.119  53.213  81.108  1.00 39.89           N  
ATOM   1050  CA  PRO A 138      37.875  53.514  81.843  1.00 39.42           C  
ATOM   1051  C   PRO A 138      36.722  52.576  81.435  1.00 38.97           C  
ATOM   1052  O   PRO A 138      36.086  51.986  82.301  1.00 38.06           O  
ATOM   1053  CB  PRO A 138      37.565  54.964  81.482  1.00 39.96           C  
ATOM   1054  CG  PRO A 138      38.619  55.412  80.538  1.00 39.91           C  
ATOM   1055  CD  PRO A 138      39.684  54.393  80.431  1.00 39.60           C  
ATOM   1056  N   PHE A 139      36.495  52.384  80.132  1.00 38.11           N  
ATOM   1057  CA  PHE A 139      35.390  51.519  79.713  1.00 37.44           C  
ATOM   1058  C   PHE A 139      35.588  50.052  80.113  1.00 37.16           C  
ATOM   1059  O   PHE A 139      34.622  49.401  80.545  1.00 37.64           O  
ATOM   1060  CB  PHE A 139      35.129  51.646  78.223  1.00 37.62           C  
ATOM   1061  CG  PHE A 139      33.791  51.082  77.788  1.00 38.29           C  
ATOM   1062  CD1 PHE A 139      32.644  51.363  78.492  1.00 38.71           C  
ATOM   1063  CD2 PHE A 139      33.699  50.262  76.673  1.00 38.16           C  
ATOM   1064  CE1 PHE A 139      31.455  50.835  78.112  1.00 39.73           C  
ATOM   1065  CE2 PHE A 139      32.514  49.748  76.275  1.00 38.62           C  
ATOM   1066  CZ  PHE A 139      31.374  50.034  76.983  1.00 39.62           C  
ATOM   1067  N   LEU A 140      36.815  49.533  79.974  1.00 36.22           N  
ATOM   1068  CA  LEU A 140      37.166  48.203  80.471  1.00 35.74           C  
ATOM   1069  C   LEU A 140      36.936  48.089  81.986  1.00 36.23           C  
ATOM   1070  O   LEU A 140      36.551  47.023  82.473  1.00 36.61           O  
ATOM   1071  CB  LEU A 140      38.618  47.848  80.130  1.00 35.29           C  
ATOM   1072  CG  LEU A 140      38.940  47.567  78.640  1.00 35.16           C  
ATOM   1073  CD1 LEU A 140      40.442  47.497  78.376  1.00 33.08           C  
ATOM   1074  CD2 LEU A 140      38.259  46.324  78.083  1.00 32.19           C  
ATOM   1075  N   ASN A 141      37.170  49.178  82.731  1.00 35.87           N  
ATOM   1076  CA  ASN A 141      36.868  49.209  84.140  1.00 35.76           C  
ATOM   1077  C   ASN A 141      35.380  48.857  84.344  1.00 35.80           C  
ATOM   1078  O   ASN A 141      35.020  47.981  85.125  1.00 35.56           O  
ATOM   1079  CB  ASN A 141      37.124  50.619  84.711  1.00 36.35           C  
ATOM   1080  CG  ASN A 141      38.571  50.856  85.197  1.00 37.01           C  
ATOM   1081  OD1 ASN A 141      38.879  51.950  85.725  1.00 37.30           O  
ATOM   1082  ND2 ASN A 141      39.451  49.861  85.026  1.00 36.58           N  
ATOM   1083  N   LEU A 142      34.526  49.570  83.629  1.00 35.78           N  
ATOM   1084  CA  LEU A 142      33.105  49.466  83.799  1.00 35.92           C  
ATOM   1085  C   LEU A 142      32.597  48.074  83.390  1.00 35.72           C  
ATOM   1086  O   LEU A 142      31.741  47.506  84.070  1.00 34.97           O  
ATOM   1087  CB  LEU A 142      32.384  50.606  83.040  1.00 36.25           C  
ATOM   1088  CG  LEU A 142      30.844  50.552  82.981  1.00 37.03           C  
ATOM   1089  CD1 LEU A 142      30.162  51.913  83.209  1.00 39.36           C  
ATOM   1090  CD2 LEU A 142      30.340  49.944  81.652  1.00 35.88           C  
ATOM   1091  N   LEU A 143      33.165  47.509  82.322  1.00 35.64           N  
ATOM   1092  CA  LEU A 143      32.771  46.159  81.868  1.00 35.02           C  
ATOM   1093  C   LEU A 143      33.112  45.076  82.902  1.00 34.95           C  
ATOM   1094  O   LEU A 143      32.337  44.153  83.144  1.00 33.19           O  
ATOM   1095  CB  LEU A 143      33.415  45.841  80.512  1.00 33.86           C  
ATOM   1096  CG  LEU A 143      32.882  46.757  79.413  1.00 33.94           C  
ATOM   1097  CD1 LEU A 143      33.724  46.637  78.148  1.00 29.59           C  
ATOM   1098  CD2 LEU A 143      31.330  46.561  79.156  1.00 31.78           C  
ATOM   1099  N   GLU A 144      34.275  45.218  83.515  1.00 35.32           N  
ATOM   1100  CA  GLU A 144      34.684  44.314  84.561  1.00 36.87           C  
ATOM   1101  C   GLU A 144      33.786  44.492  85.770  1.00 35.81           C  
ATOM   1102  O   GLU A 144      33.501  43.525  86.478  1.00 35.46           O  
ATOM   1103  CB  GLU A 144      36.149  44.562  84.946  1.00 37.07           C  
ATOM   1104  CG  GLU A 144      37.089  44.102  83.876  1.00 37.63           C  
ATOM   1105  CD  GLU A 144      38.563  44.224  84.282  1.00 40.98           C  
ATOM   1106  OE1 GLU A 144      39.108  45.385  84.268  1.00 43.96           O  
ATOM   1107  OE2 GLU A 144      39.176  43.136  84.586  1.00 44.97           O  
ATOM   1108  N   SER A 145      33.308  45.707  86.008  1.00 35.86           N  
ATOM   1109  CA  SER A 145      32.350  45.886  87.123  1.00 36.14           C  
ATOM   1110  C   SER A 145      31.024  45.198  86.757  1.00 35.94           C  
ATOM   1111  O   SER A 145      30.469  44.407  87.535  1.00 36.87           O  
ATOM   1112  CB  SER A 145      32.090  47.359  87.462  1.00 35.48           C  
ATOM   1113  OG  SER A 145      33.190  47.924  88.120  1.00 35.12           O  
ATOM   1114  N   LEU A 146      30.532  45.478  85.565  1.00 35.00           N  
ATOM   1115  CA  LEU A 146      29.345  44.795  85.103  1.00 35.02           C  
ATOM   1116  C   LEU A 146      29.534  43.250  85.299  1.00 35.14           C  
ATOM   1117  O   LEU A 146      28.640  42.557  85.806  1.00 35.46           O  
ATOM   1118  CB  LEU A 146      29.063  45.173  83.624  1.00 35.00           C  
ATOM   1119  CG  LEU A 146      27.645  44.994  82.976  1.00 35.54           C  
ATOM   1120  CD1 LEU A 146      27.749  44.794  81.496  1.00 31.99           C  
ATOM   1121  CD2 LEU A 146      26.685  43.935  83.590  1.00 33.81           C  
ATOM   1122  N   ALA A 147      30.710  42.735  84.915  1.00 34.50           N  
ATOM   1123  CA  ALA A 147      30.965  41.280  84.840  1.00 34.19           C  
ATOM   1124  C   ALA A 147      30.958  40.667  86.245  1.00 34.22           C  
ATOM   1125  O   ALA A 147      30.453  39.527  86.455  1.00 33.85           O  
ATOM   1126  CB  ALA A 147      32.301  40.970  84.064  1.00 31.67           C  
ATOM   1127  N   GLY A 148      31.501  41.434  87.204  1.00 34.24           N  
ATOM   1128  CA  GLY A 148      31.509  41.026  88.595  1.00 33.76           C  
ATOM   1129  C   GLY A 148      30.126  40.954  89.221  1.00 33.78           C  
ATOM   1130  O   GLY A 148      29.853  40.076  90.056  1.00 32.52           O  
ATOM   1131  N   GLN A 149      29.258  41.888  88.822  1.00 34.26           N  
ATOM   1132  CA  GLN A 149      27.877  41.941  89.333  1.00 34.85           C  
ATOM   1133  C   GLN A 149      27.028  40.812  88.720  1.00 35.00           C  
ATOM   1134  O   GLN A 149      26.145  40.258  89.401  1.00 34.97           O  
ATOM   1135  CB  GLN A 149      27.245  43.316  89.094  1.00 34.55           C  
ATOM   1136  CG  GLN A 149      27.941  44.469  89.889  1.00 36.82           C  
ATOM   1137  CD  GLN A 149      27.005  45.640  90.217  1.00 37.35           C  
ATOM   1138  OE1 GLN A 149      27.411  46.666  90.829  1.00 39.42           O  
ATOM   1139  NE2 GLN A 149      25.735  45.493  89.820  1.00 38.28           N  
ATOM   1140  N   LEU A 150      27.333  40.450  87.460  1.00 34.88           N  
ATOM   1141  CA  LEU A 150      26.771  39.245  86.851  1.00 34.65           C  
ATOM   1142  C   LEU A 150      27.267  37.986  87.565  1.00 34.19           C  
ATOM   1143  O   LEU A 150      26.481  37.107  87.900  1.00 33.98           O  
ATOM   1144  CB  LEU A 150      27.109  39.173  85.346  1.00 34.89           C  
ATOM   1145  CG  LEU A 150      26.386  40.197  84.436  1.00 34.39           C  
ATOM   1146  CD1 LEU A 150      27.189  40.385  83.143  1.00 31.55           C  
ATOM   1147  CD2 LEU A 150      24.945  39.771  84.159  1.00 27.47           C  
ATOM   1148  N   ALA A 151      28.567  37.892  87.782  1.00 34.62           N  
ATOM   1149  CA  ALA A 151      29.125  36.739  88.496  1.00 35.58           C  
ATOM   1150  C   ALA A 151      28.426  36.532  89.855  1.00 36.73           C  
ATOM   1151  O   ALA A 151      28.081  35.386  90.277  1.00 35.94           O  
ATOM   1152  CB  ALA A 151      30.631  36.896  88.689  1.00 34.73           C  
ATOM   1153  N   GLN A 152      28.194  37.645  90.534  1.00 37.73           N  
ATOM   1154  CA  GLN A 152      27.551  37.563  91.816  1.00 39.08           C  
ATOM   1155  C   GLN A 152      26.152  36.981  91.704  1.00 39.46           C  
ATOM   1156  O   GLN A 152      25.785  36.072  92.473  1.00 39.55           O  
ATOM   1157  CB  GLN A 152      27.485  38.926  92.479  1.00 39.40           C  
ATOM   1158  CG  GLN A 152      27.034  38.845  93.905  1.00 41.70           C  
ATOM   1159  CD  GLN A 152      27.947  37.967  94.737  1.00 44.33           C  
ATOM   1160  OE1 GLN A 152      28.868  38.474  95.385  1.00 46.75           O  
ATOM   1161  NE2 GLN A 152      27.716  36.639  94.709  1.00 43.59           N  
ATOM   1162  N   ALA A 153      25.382  37.510  90.745  1.00 39.66           N  
ATOM   1163  CA  ALA A 153      23.986  37.117  90.555  1.00 39.58           C  
ATOM   1164  C   ALA A 153      23.855  35.631  90.205  1.00 40.41           C  
ATOM   1165  O   ALA A 153      22.926  34.962  90.656  1.00 41.01           O  
ATOM   1166  CB  ALA A 153      23.355  37.980  89.492  1.00 38.56           C  
ATOM   1167  N   VAL A 154      24.771  35.108  89.389  1.00 41.18           N  
ATOM   1168  CA  VAL A 154      24.746  33.680  89.019  1.00 41.63           C  
ATOM   1169  C   VAL A 154      24.976  32.781  90.243  1.00 42.49           C  
ATOM   1170  O   VAL A 154      24.181  31.864  90.535  1.00 42.67           O  
ATOM   1171  CB  VAL A 154      25.813  33.369  87.950  1.00 41.37           C  
ATOM   1172  CG1 VAL A 154      25.972  31.875  87.759  1.00 41.42           C  
ATOM   1173  CG2 VAL A 154      25.444  34.051  86.627  1.00 41.73           C  
ATOM   1174  N   LYS A 155      26.081  33.046  90.936  1.00 43.35           N  
ATOM   1175  CA  LYS A 155      26.408  32.376  92.181  1.00 44.07           C  
ATOM   1176  C   LYS A 155      25.226  32.367  93.167  1.00 44.75           C  
ATOM   1177  O   LYS A 155      24.968  31.335  93.792  1.00 44.28           O  
ATOM   1178  CB  LYS A 155      27.665  32.993  92.818  1.00 44.21           C  
ATOM   1179  CG  LYS A 155      28.935  32.111  92.669  1.00 44.98           C  
ATOM   1180  CD  LYS A 155      30.224  32.749  93.308  1.00 45.32           C  
ATOM   1181  CE  LYS A 155      30.321  32.628  94.840  1.00 44.45           C  
ATOM   1182  NZ  LYS A 155      31.063  33.784  95.357  1.00 42.74           N  
ATOM   1183  N   ILE A 156      24.509  33.491  93.297  1.00 45.60           N  
ATOM   1184  CA  ILE A 156      23.283  33.518  94.115  1.00 46.08           C  
ATOM   1185  C   ILE A 156      22.423  32.286  93.789  1.00 46.29           C  
ATOM   1186  O   ILE A 156      21.972  31.594  94.683  1.00 46.73           O  
ATOM   1187  CB  ILE A 156      22.436  34.853  93.951  1.00 46.43           C  
ATOM   1188  CG1 ILE A 156      23.039  36.010  94.774  1.00 47.49           C  
ATOM   1189  CG2 ILE A 156      20.966  34.654  94.435  1.00 46.20           C  
ATOM   1190  CD1 ILE A 156      22.956  37.390  94.079  1.00 46.79           C  
ATOM   1191  N   VAL A 157      22.198  32.020  92.510  1.00 46.81           N  
ATOM   1192  CA  VAL A 157      21.520  30.797  92.087  1.00 46.55           C  
ATOM   1193  C   VAL A 157      22.573  29.684  92.055  1.00 47.21           C  
ATOM   1194  O   VAL A 157      22.371  28.610  92.603  1.00 47.32           O  
ATOM   1195  CB  VAL A 157      20.890  30.935  90.685  1.00 46.80           C  
ATOM   1196  CG1 VAL A 157      20.003  29.737  90.408  1.00 45.91           C  
ATOM   1197  CG2 VAL A 157      20.112  32.249  90.551  1.00 44.48           C  
TER    1198      VAL A 157                                                      
END
MOLECULE T0412.pdb
ATOM      1  N   SER     1      17.559  26.951  92.213  1.00 54.32           N  
ATOM      2  CA  SER     1      16.245  27.299  92.853  1.00 53.09           C  
ATOM      3  C   SER     1      16.043  28.831  93.060  1.00 52.29           C  
ATOM      4  O   SER     1      15.077  29.281  93.761  1.00 50.93           O  
ATOM      5  CB  SER     1      16.073  26.547  94.152  1.00 52.87           C  
ATOM      6  OG  SER     1      14.779  26.777  94.666  1.00 52.80           O  
ATOM      7  N   ASN     2      16.948  29.599  92.427  1.00 50.24           N  
ATOM      8  CA  ASN     2      16.884  31.054  92.474  1.00 48.93           C  
ATOM      9  C   ASN     2      17.383  31.628  91.189  1.00 47.18           C  
ATOM     10  O   ASN     2      17.733  32.795  91.079  1.00 47.53           O  
ATOM     11  CB  ASN     2      17.619  31.623  93.683  1.00 49.45           C  
ATOM     12  CG  ASN     2      17.125  33.004  94.040  1.00 49.02           C  
ATOM     13  OD1 ASN     2      17.498  33.973  93.384  1.00 51.47           O  
ATOM     14  ND2 ASN     2      16.253  33.099  95.026  1.00 44.65           N  
ATOM     15  N   ALA     3      17.385  30.732  90.212  1.00 45.59           N  
ATOM     16  CA  ALA     3      17.756  30.926  88.865  1.00 42.81           C  
ATOM     17  C   ALA     3      17.150  32.162  88.216  1.00 42.42           C  
ATOM     18  O   ALA     3      17.817  32.797  87.411  1.00 43.10           O  
ATOM     19  CB  ALA     3      17.328  29.686  88.100  1.00 42.78           C  
ATOM     20  N   LEU     4      15.891  32.474  88.499  1.00 40.84           N  
ATOM     21  CA  LEU     4      15.175  33.549  87.776  1.00 41.08           C  
ATOM     22  C   LEU     4      15.595  34.992  88.193  1.00 41.73           C  
ATOM     23  O   LEU     4      15.795  35.891  87.336  1.00 40.99           O  
ATOM     24  CB  LEU     4      13.630  33.366  87.879  1.00 40.15           C  
ATOM     25  CG  LEU     4      13.042  32.123  87.172  1.00 39.13           C  
ATOM     26  CD1 LEU     4      11.515  32.115  87.181  1.00 37.64           C  
ATOM     27  CD2 LEU     4      13.561  32.029  85.757  1.00 33.72           C  
ATOM     28  N   PHE     5      15.747  35.183  89.503  1.00 42.10           N  
ATOM     29  CA  PHE     5      16.276  36.410  90.043  1.00 43.47           C  
ATOM     30  C   PHE     5      17.723  36.613  89.583  1.00 45.53           C  
ATOM     31  O   PHE     5      18.087  37.717  89.179  1.00 45.52           O  
ATOM     32  CB  PHE     5      16.153  36.419  91.539  1.00 41.53           C  
ATOM     33  CG  PHE     5      14.758  36.708  92.026  1.00 42.02           C  
ATOM     34  CD1 PHE     5      14.162  37.953  91.794  1.00 40.73           C  
ATOM     35  CD2 PHE     5      14.057  35.762  92.772  1.00 38.83           C  
ATOM     36  CE1 PHE     5      12.860  38.232  92.300  1.00 39.71           C  
ATOM     37  CE2 PHE     5      12.788  36.019  93.254  1.00 37.43           C  
ATOM     38  CZ  PHE     5      12.175  37.252  93.015  1.00 38.76           C  
ATOM     39  N   SER     6      18.539  35.567  89.550  1.00 47.47           N  
ATOM     40  CA  SER     6      19.873  35.786  88.935  1.00 50.67           C  
ATOM     41  C   SER     6      19.841  36.120  87.464  1.00 51.41           C  
ATOM     42  O   SER     6      20.662  36.934  87.018  1.00 52.33           O  
ATOM     43  CB  SER     6      20.860  34.630  89.193  1.00 50.07           C  
ATOM     44  OG  SER     6      20.888  34.394  90.613  1.00 55.00           O  
ATOM     45  N   SER     7      18.951  35.474  86.693  1.00 52.62           N  
ATOM     46  CA  SER     7      18.913  35.704  85.234  1.00 53.39           C  
ATOM     47  C   SER     7      18.502  37.146  85.049  1.00 53.99           C  
ATOM     48  O   SER     7      19.066  37.871  84.231  1.00 54.98           O  
ATOM     49  CB  SER     7      17.939  34.768  84.510  1.00 53.69           C  
ATOM     50  OG  SER     7      18.384  33.413  84.592  1.00 54.34           O  
ATOM     51  N   ARG     8      17.565  37.583  85.866  1.00 53.65           N  
ATOM     52  CA  ARG     8      17.066  38.939  85.755  1.00 54.53           C  
ATOM     53  C   ARG     8      18.164  39.964  86.086  1.00 54.58           C  
ATOM     54  O   ARG     8      18.327  40.920  85.341  1.00 55.96           O  
ATOM     55  CB  ARG     8      15.819  39.113  86.650  1.00 54.60           C  
ATOM     56  CG  ARG     8      15.233  40.467  86.595  1.00 56.13           C  
ATOM     57  CD  ARG     8      15.106  40.985  88.004  1.00 57.96           C  
ATOM     58  NE  ARG     8      13.696  41.145  88.342  1.00 62.03           N  
ATOM     59  CZ  ARG     8      13.204  41.195  89.577  1.00 61.99           C  
ATOM     60  NH1 ARG     8      11.897  41.360  89.749  1.00 61.14           N  
ATOM     61  NH2 ARG     8      14.011  41.073  90.627  1.00 62.55           N  
ATOM     62  N   ASP     9      18.908  39.772  87.183  1.00 54.12           N  
ATOM     63  CA  ASP     9      20.074  40.595  87.510  1.00 54.08           C  
ATOM     64  C   ASP     9      21.019  40.705  86.305  1.00 54.67           C  
ATOM     65  O   ASP     9      21.399  41.806  85.927  1.00 55.78           O  
ATOM     66  CB  ASP     9      20.870  39.989  88.667  1.00 53.61           C  
ATOM     67  CG  ASP     9      20.139  40.045  90.007  1.00 55.37           C  
ATOM     68  OD1 ASP     9      19.080  40.719  90.144  1.00 57.24           O  
ATOM     69  OD2 ASP     9      20.634  39.387  90.952  1.00 56.96           O  
ATOM     70  N   ILE    10      21.384  39.573  85.702  1.00 54.19           N  
ATOM     71  CA  ILE    10      22.284  39.552  84.544  1.00 54.42           C  
ATOM     72  C   ILE    10      21.722  40.293  83.315  1.00 55.29           C  
ATOM     73  O   ILE    10      22.394  41.116  82.712  1.00 55.62           O  
ATOM     74  CB  ILE    10      22.666  38.098  84.163  1.00 53.93           C  
ATOM     75  CG1 ILE    10      23.447  37.454  85.291  1.00 53.01           C  
ATOM     76  CG2 ILE    10      23.465  38.026  82.840  1.00 53.06           C  
ATOM     77  CD1 ILE    10      23.566  35.934  85.160  1.00 52.08           C  
ATOM     78  N   LEU    11      20.489  39.975  82.942  1.00 56.18           N  
ATOM     79  CA  LEU    11      19.816  40.679  81.877  1.00 56.38           C  
ATOM     80  C   LEU    11      19.798  42.184  82.141  1.00 57.20           C  
ATOM     81  O   LEU    11      20.038  42.959  81.229  1.00 58.40           O  
ATOM     82  CB  LEU    11      18.403  40.149  81.688  1.00 55.51           C  
ATOM     83  CG  LEU    11      17.694  40.821  80.522  1.00 55.16           C  
ATOM     84  CD1 LEU    11      18.433  40.553  79.200  1.00 52.86           C  
ATOM     85  CD2 LEU    11      16.261  40.337  80.481  1.00 49.81           C  
ATOM     86  N   GLU    12      19.507  42.620  83.360  1.00 57.38           N  
ATOM     87  CA  GLU    12      19.500  44.064  83.621  1.00 58.36           C  
ATOM     88  C   GLU    12      20.894  44.699  83.355  1.00 57.39           C  
ATOM     89  O   GLU    12      20.998  45.782  82.776  1.00 57.72           O  
ATOM     90  CB  GLU    12      19.034  44.374  85.047  1.00 57.74           C  
ATOM     91  CG  GLU    12      17.531  44.332  85.205  1.00 60.40           C  
ATOM     92  CD  GLU    12      17.043  44.331  86.701  1.00 61.88           C  
ATOM     93  OE1 GLU    12      17.873  44.459  87.671  1.00 62.94           O  
ATOM     94  OE2 GLU    12      15.796  44.191  86.887  1.00 66.26           O  
ATOM     95  N   VAL    13      21.957  44.040  83.792  1.00 55.98           N  
ATOM     96  CA  VAL    13      23.286  44.551  83.529  1.00 55.60           C  
ATOM     97  C   VAL    13      23.614  44.556  82.022  1.00 55.56           C  
ATOM     98  O   VAL    13      24.168  45.541  81.501  1.00 55.72           O  
ATOM     99  CB  VAL    13      24.357  43.769  84.292  1.00 55.14           C  
ATOM    100  CG1 VAL    13      25.722  44.167  83.806  1.00 54.07           C  
ATOM    101  CG2 VAL    13      24.239  44.064  85.750  1.00 54.66           C  
ATOM    102  N   LEU    14      23.268  43.472  81.339  1.00 55.24           N  
ATOM    103  CA  LEU    14      23.531  43.338  79.920  1.00 56.29           C  
ATOM    104  C   LEU    14      22.733  44.390  79.113  1.00 56.68           C  
ATOM    105  O   LEU    14      23.240  44.984  78.188  1.00 55.03           O  
ATOM    106  CB  LEU    14      23.190  41.918  79.489  1.00 56.15           C  
ATOM    107  CG  LEU    14      23.420  41.464  78.039  1.00 58.26           C  
ATOM    108  CD1 LEU    14      24.902  41.336  77.676  1.00 56.32           C  
ATOM    109  CD2 LEU    14      22.662  40.132  77.744  1.00 56.95           C  
ATOM    110  N   GLN    15      21.476  44.617  79.488  1.00 57.39           N  
ATOM    111  CA  GLN    15      20.712  45.698  78.920  1.00 58.53           C  
ATOM    112  C   GLN    15      21.356  47.067  79.131  1.00 58.92           C  
ATOM    113  O   GLN    15      21.273  47.906  78.234  1.00 59.03           O  
ATOM    114  CB  GLN    15      19.262  45.682  79.394  1.00 57.53           C  
ATOM    115  CG  GLN    15      18.490  44.721  78.582  1.00 60.66           C  
ATOM    116  CD  GLN    15      17.050  44.549  79.011  1.00 67.03           C  
ATOM    117  OE1 GLN    15      16.699  44.686  80.206  1.00 70.49           O  
ATOM    118  NE2 GLN    15      16.197  44.222  78.046  1.00 66.34           N  
ATOM    119  N   ASP    16      21.993  47.297  80.274  1.00 59.06           N  
ATOM    120  CA  ASP    16      22.670  48.569  80.467  1.00 61.14           C  
ATOM    121  C   ASP    16      23.854  48.786  79.522  1.00 60.80           C  
ATOM    122  O   ASP    16      24.084  49.885  79.037  1.00 62.19           O  
ATOM    123  CB  ASP    16      23.144  48.748  81.898  1.00 61.68           C  
ATOM    124  CG  ASP    16      22.232  49.623  82.672  1.00 68.11           C  
ATOM    125  OD1 ASP    16      21.178  49.073  83.077  1.00 74.84           O  
ATOM    126  OD2 ASP    16      22.526  50.864  82.858  1.00 74.19           O  
ATOM    127  N   ILE    17      24.610  47.746  79.266  1.00 59.31           N  
ATOM    128  CA  ILE    17      25.768  47.894  78.435  1.00 58.61           C  
ATOM    129  C   ILE    17      25.329  48.077  76.973  1.00 58.36           C  
ATOM    130  O   ILE    17      25.962  48.806  76.173  1.00 58.26           O  
ATOM    131  CB  ILE    17      26.776  46.737  78.709  1.00 58.41           C  
ATOM    132  CG1 ILE    17      27.396  47.016  80.102  1.00 59.02           C  
ATOM    133  CG2 ILE    17      27.855  46.699  77.673  1.00 55.26           C  
ATOM    134  CD1 ILE    17      27.730  45.783  80.928  1.00 58.25           C  
ATOM    135  N   HIS    18      24.204  47.478  76.654  1.00 57.90           N  
ATOM    136  CA  HIS    18      23.629  47.664  75.351  1.00 58.94           C  
ATOM    137  C   HIS    18      23.112  49.113  75.217  1.00 59.57           C  
ATOM    138  O   HIS    18      23.374  49.768  74.222  1.00 60.69           O  
ATOM    139  CB  HIS    18      22.526  46.645  75.090  1.00 57.67           C  
ATOM    140  CG  HIS    18      21.918  46.772  73.737  1.00 57.96           C  
ATOM    141  ND1 HIS    18      20.628  47.214  73.539  1.00 58.77           N  
ATOM    142  CD2 HIS    18      22.425  46.528  72.505  1.00 58.94           C  
ATOM    143  CE1 HIS    18      20.359  47.219  72.245  1.00 60.89           C  
ATOM    144  NE2 HIS    18      21.434  46.803  71.595  1.00 61.68           N  
ATOM    145  N   MET    19      22.406  49.635  76.201  1.00 60.21           N  
ATOM    146  CA  MET    19      21.950  51.024  76.073  1.00 61.55           C  
ATOM    147  C   MET    19      23.110  51.997  75.938  1.00 61.25           C  
ATOM    148  O   MET    19      23.060  52.863  75.066  1.00 61.91           O  
ATOM    149  CB  MET    19      21.069  51.463  77.232  1.00 62.10           C  
ATOM    150  CG  MET    19      19.700  50.779  77.275  1.00 67.35           C  
ATOM    151  SD  MET    19      18.646  50.737  75.611  0.70 78.76          SE  
ATOM    152  CE  MET    19      17.526  52.242  75.897  1.00 73.10           C  
ATOM    153  N   GLU    20      24.145  51.856  76.772  1.00 60.29           N  
ATOM    154  CA  GLU    20      25.248  52.795  76.767  1.00 60.15           C  
ATOM    155  C   GLU    20      26.152  52.649  75.538  1.00 60.05           C  
ATOM    156  O   GLU    20      26.716  53.622  75.082  1.00 61.14           O  
ATOM    157  CB  GLU    20      26.110  52.629  78.003  1.00 60.63           C  
ATOM    158  CG  GLU    20      25.379  52.438  79.286  1.00 63.50           C  
ATOM    159  CD  GLU    20      25.814  53.410  80.356  1.00 68.04           C  
ATOM    160  OE1 GLU    20      26.697  54.260  80.104  1.00 70.18           O  
ATOM    161  OE2 GLU    20      25.245  53.346  81.463  1.00 72.19           O  
ATOM    162  N   THR    21      26.292  51.453  74.989  1.00 58.97           N  
ATOM    163  CA  THR    21      27.239  51.263  73.902  1.00 58.25           C  
ATOM    164  C   THR    21      26.625  51.052  72.532  1.00 58.63           C  
ATOM    165  O   THR    21      27.294  51.276  71.547  1.00 59.56           O  
ATOM    166  CB  THR    21      28.229  50.062  74.160  1.00 57.95           C  
ATOM    167  OG1 THR    21      27.559  48.822  73.928  1.00 53.65           O  
ATOM    168  CG2 THR    21      28.813  50.091  75.593  1.00 57.31           C  
ATOM    169  N   GLY    22      25.388  50.561  72.458  1.00 59.40           N  
ATOM    170  CA  GLY    22      24.713  50.279  71.177  1.00 58.70           C  
ATOM    171  C   GLY    22      25.251  49.067  70.445  1.00 59.54           C  
ATOM    172  O   GLY    22      24.683  48.653  69.426  1.00 59.78           O  
ATOM    173  N   GLU    23      26.327  48.469  70.976  1.00 59.24           N  
ATOM    174  CA  GLU    23      26.980  47.302  70.367  1.00 58.58           C  
ATOM    175  C   GLU    23      26.200  45.998  70.555  1.00 58.88           C  
ATOM    176  O   GLU    23      25.259  45.959  71.333  1.00 58.65           O  
ATOM    177  CB  GLU    23      28.390  47.164  70.925  1.00 57.76           C  
ATOM    178  CG  GLU    23      29.214  48.414  70.770  1.00 58.46           C  
ATOM    179  CD  GLU    23      29.610  48.755  69.295  1.00 59.54           C  
ATOM    180  OE1 GLU    23      29.386  47.923  68.411  1.00 54.46           O  
ATOM    181  OE2 GLU    23      30.168  49.866  69.047  1.00 60.23           O  
ATOM    182  N   THR    24      26.562  44.942  69.806  1.00 59.29           N  
ATOM    183  CA  THR    24      26.049  43.581  70.074  1.00 59.56           C  
ATOM    184  C   THR    24      26.676  43.137  71.355  1.00 59.12           C  
ATOM    185  O   THR    24      27.906  43.220  71.551  1.00 59.04           O  
ATOM    186  CB  THR    24      26.459  42.569  68.998  1.00 59.44           C  
ATOM    187  OG1 THR    24      26.050  43.044  67.721  1.00 62.46           O  
ATOM    188  CG2 THR    24      25.755  41.242  69.199  1.00 60.40           C  
ATOM    189  N   VAL    25      25.836  42.700  72.267  1.00 58.81           N  
ATOM    190  CA  VAL    25      26.314  42.319  73.595  1.00 57.45           C  
ATOM    191  C   VAL    25      25.838  40.880  73.800  1.00 57.93           C  
ATOM    192  O   VAL    25      24.808  40.483  73.197  1.00 57.90           O  
ATOM    193  CB  VAL    25      25.819  43.293  74.708  1.00 57.29           C  
ATOM    194  CG1 VAL    25      26.282  44.692  74.424  1.00 57.65           C  
ATOM    195  CG2 VAL    25      24.329  43.310  74.816  1.00 58.67           C  
ATOM    196  N   ALA    26      26.564  40.088  74.618  1.00 57.17           N  
ATOM    197  CA  ALA    26      26.181  38.702  74.836  1.00 55.78           C  
ATOM    198  C   ALA    26      26.677  38.156  76.173  1.00 56.21           C  
ATOM    199  O   ALA    26      27.692  38.660  76.718  1.00 56.85           O  
ATOM    200  CB  ALA    26      26.707  37.843  73.700  1.00 55.84           C  
ATOM    201  N   ILE    27      25.957  37.134  76.666  1.00 54.82           N  
ATOM    202  CA  ILE    27      26.373  36.215  77.724  1.00 54.97           C  
ATOM    203  C   ILE    27      26.665  34.880  77.036  1.00 55.40           C  
ATOM    204  O   ILE    27      25.875  34.388  76.208  1.00 55.50           O  
ATOM    205  CB  ILE    27      25.204  35.998  78.727  1.00 54.89           C  
ATOM    206  CG1 ILE    27      24.675  37.364  79.201  1.00 58.42           C  
ATOM    207  CG2 ILE    27      25.620  35.224  79.941  1.00 54.79           C  
ATOM    208  CD1 ILE    27      25.763  38.300  79.861  1.00 56.11           C  
ATOM    209  N   ALA    28      27.814  34.304  77.343  1.00 56.24           N  
ATOM    210  CA  ALA    28      28.220  33.025  76.762  1.00 57.33           C  
ATOM    211  C   ALA    28      28.899  32.114  77.789  1.00 58.02           C  
ATOM    212  O   ALA    28      29.500  32.581  78.756  1.00 59.65           O  
ATOM    213  CB  ALA    28      29.165  33.270  75.595  1.00 57.05           C  
ATOM    214  N   THR    29      28.831  30.815  77.549  1.00 58.45           N  
ATOM    215  CA  THR    29      29.438  29.821  78.373  1.00 59.29           C  
ATOM    216  C   THR    29      30.122  28.796  77.461  1.00 60.09           C  
ATOM    217  O   THR    29      30.062  28.945  76.238  1.00 60.75           O  
ATOM    218  CB  THR    29      28.366  29.129  79.253  1.00 59.14           C  
ATOM    219  OG1 THR    29      29.027  28.212  80.107  1.00 62.44           O  
ATOM    220  CG2 THR    29      27.313  28.329  78.420  1.00 59.03           C  
ATOM    221  N   LYS    30      30.752  27.746  78.017  1.00 60.10           N  
ATOM    222  CA  LYS    30      31.294  26.714  77.138  1.00 60.17           C  
ATOM    223  C   LYS    30      30.503  25.423  77.045  1.00 60.24           C  
ATOM    224  O   LYS    30      29.848  24.988  77.989  1.00 60.38           O  
ATOM    225  CB  LYS    30      32.766  26.424  77.403  1.00 59.87           C  
ATOM    226  CG  LYS    30      33.091  25.799  78.698  1.00 58.67           C  
ATOM    227  CD  LYS    30      34.590  25.975  78.926  1.00 56.57           C  
ATOM    228  CE  LYS    30      34.916  25.743  80.373  1.00 62.17           C  
ATOM    229  NZ  LYS    30      34.346  24.439  80.917  1.00 61.02           N  
ATOM    230  N   ASN    31      30.566  24.829  75.867  1.00 60.09           N  
ATOM    231  CA  ASN    31      29.974  23.554  75.632  1.00 60.15           C  
ATOM    232  C   ASN    31      31.129  22.711  75.064  1.00 60.85           C  
ATOM    233  O   ASN    31      31.450  22.809  73.874  1.00 60.33           O  
ATOM    234  CB  ASN    31      28.809  23.697  74.659  1.00 59.81           C  
ATOM    235  CG  ASN    31      28.273  22.369  74.202  1.00 60.90           C  
ATOM    236  OD1 ASN    31      28.415  21.365  74.897  1.00 62.42           O  
ATOM    237  ND2 ASN    31      27.650  22.343  73.028  1.00 62.72           N  
ATOM    238  N   ASP    32      31.768  21.920  75.944  1.00 60.79           N  
ATOM    239  CA  ASP    32      32.969  21.138  75.588  1.00 60.54           C  
ATOM    240  C   ASP    32      34.075  22.119  75.089  1.00 59.98           C  
ATOM    241  O   ASP    32      34.582  22.895  75.888  1.00 61.62           O  
ATOM    242  CB  ASP    32      32.586  20.014  74.598  1.00 60.03           C  
ATOM    243  CG  ASP    32      33.770  19.211  74.127  1.00 61.08           C  
ATOM    244  OD1 ASP    32      34.747  19.094  74.899  1.00 61.78           O  
ATOM    245  OD2 ASP    32      33.727  18.690  72.982  1.00 60.46           O  
ATOM    246  N   ILE    33      34.429  22.136  73.811  1.00 58.31           N  
ATOM    247  CA  ILE    33      35.454  23.066  73.335  1.00 57.06           C  
ATOM    248  C   ILE    33      34.847  24.188  72.442  1.00 58.02           C  
ATOM    249  O   ILE    33      35.556  24.857  71.665  1.00 57.54           O  
ATOM    250  CB  ILE    33      36.537  22.325  72.532  1.00 56.55           C  
ATOM    251  CG1 ILE    33      35.932  21.627  71.325  1.00 53.36           C  
ATOM    252  CG2 ILE    33      37.325  21.324  73.397  1.00 55.34           C  
ATOM    253  CD1 ILE    33      36.969  21.338  70.290  1.00 56.07           C  
ATOM    254  N   TYR    34      33.531  24.347  72.532  1.00 58.02           N  
ATOM    255  CA  TYR    34      32.789  25.305  71.721  1.00 59.60           C  
ATOM    256  C   TYR    34      32.153  26.416  72.587  1.00 60.55           C  
ATOM    257  O   TYR    34      31.805  26.201  73.766  1.00 60.57           O  
ATOM    258  CB  TYR    34      31.702  24.615  70.881  1.00 58.70           C  
ATOM    259  CG  TYR    34      32.255  23.504  70.077  1.00 59.51           C  
ATOM    260  CD1 TYR    34      32.919  23.749  68.863  1.00 62.22           C  
ATOM    261  CD2 TYR    34      32.182  22.198  70.539  1.00 56.56           C  
ATOM    262  CE1 TYR    34      33.483  22.679  68.123  1.00 61.17           C  
ATOM    263  CE2 TYR    34      32.717  21.160  69.832  1.00 56.81           C  
ATOM    264  CZ  TYR    34      33.370  21.398  68.642  1.00 59.90           C  
ATOM    265  OH  TYR    34      33.887  20.328  67.971  1.00 62.06           O  
ATOM    266  N   LEU    35      31.982  27.581  71.980  1.00 60.82           N  
ATOM    267  CA  LEU    35      31.425  28.696  72.682  1.00 62.79           C  
ATOM    268  C   LEU    35      29.913  28.510  72.508  1.00 62.91           C  
ATOM    269  O   LEU    35      29.501  28.106  71.419  1.00 64.79           O  
ATOM    270  CB  LEU    35      31.945  30.022  72.105  1.00 62.74           C  
ATOM    271  CG  LEU    35      31.470  31.295  72.849  1.00 64.45           C  
ATOM    272  CD1 LEU    35      32.360  31.531  74.025  1.00 60.26           C  
ATOM    273  CD2 LEU    35      31.499  32.507  71.931  1.00 64.70           C  
ATOM    274  N   GLN    36      29.144  28.723  73.586  0.70 62.01           N  
ATOM    276  CA  GLN    36      27.698  28.652  73.584  0.70 61.91           C  
ATOM    278  C   GLN    36      27.186  30.009  74.064  0.70 62.05           C  
ATOM    280  O   GLN    36      27.602  30.512  75.114  0.70 60.93           O  
ATOM    282  CB  GLN    36      27.220  27.558  74.527  0.70 61.83           C  
ATOM    284  CG  GLN    36      25.819  27.041  74.247  0.70 63.49           C  
ATOM    286  CD  GLN    36      25.239  26.247  75.415  0.70 63.28           C  
ATOM    288  OE1 GLN    36      25.812  25.265  75.837  0.70 68.16           O  
ATOM    290  NE2 GLN    36      24.103  26.691  75.946  0.70 65.60           N  
ATOM    292  N   TYR    37      26.295  30.613  73.278  1.00 61.85           N  
ATOM    293  CA  TYR    37      25.624  31.862  73.670  1.00 61.15           C  
ATOM    294  C   TYR    37      24.399  31.593  74.494  1.00 59.84           C  
ATOM    295  O   TYR    37      23.619  30.759  74.123  1.00 60.44           O  
ATOM    296  CB  TYR    37      25.248  32.676  72.430  1.00 61.54           C  
ATOM    297  CG  TYR    37      26.466  33.251  71.790  1.00 62.86           C  
ATOM    298  CD1 TYR    37      27.216  34.220  72.442  1.00 60.43           C  
ATOM    299  CD2 TYR    37      26.901  32.809  70.537  1.00 65.34           C  
ATOM    300  CE1 TYR    37      28.366  34.738  71.876  1.00 60.87           C  
ATOM    301  CE2 TYR    37      28.061  33.346  69.965  1.00 62.90           C  
ATOM    302  CZ  TYR    37      28.768  34.301  70.635  1.00 63.13           C  
ATOM    303  OH  TYR    37      29.918  34.831  70.071  1.00 67.04           O  
ATOM    304  N   ILE    38      24.230  32.289  75.610  1.00 59.21           N  
ATOM    305  CA  ILE    38      23.013  32.139  76.463  1.00 58.20           C  
ATOM    306  C   ILE    38      21.998  33.234  76.094  1.00 57.77           C  
ATOM    307  O   ILE    38      20.779  33.008  76.118  1.00 58.35           O  
ATOM    308  CB  ILE    38      23.383  32.227  77.946  1.00 58.32           C  
ATOM    309  CG1 ILE    38      24.010  30.910  78.398  1.00 58.97           C  
ATOM    310  CG2 ILE    38      22.166  32.562  78.833  1.00 58.69           C  
ATOM    311  CD1 ILE    38      24.888  31.011  79.594  1.00 57.72           C  
ATOM    312  N   GLN    39      22.504  34.415  75.721  1.00 55.55           N  
ATOM    313  CA  GLN    39      21.666  35.556  75.381  1.00 54.01           C  
ATOM    314  C   GLN    39      22.493  36.510  74.615  1.00 53.04           C  
ATOM    315  O   GLN    39      23.646  36.769  74.994  1.00 54.10           O  
ATOM    316  CB  GLN    39      21.143  36.318  76.610  1.00 53.35           C  
ATOM    317  CG  GLN    39      20.273  37.518  76.256  1.00 51.78           C  
ATOM    318  CD  GLN    39      18.924  37.104  75.683  1.00 53.58           C  
ATOM    319  OE1 GLN    39      18.125  36.427  76.351  1.00 54.79           O  
ATOM    320  NE2 GLN    39      18.642  37.543  74.460  1.00 51.38           N  
ATOM    321  N   ILE    40      21.872  37.048  73.576  1.00 53.01           N  
ATOM    322  CA  ILE    40      22.460  37.999  72.648  1.00 54.32           C  
ATOM    323  C   ILE    40      21.443  39.089  72.532  1.00 54.45           C  
ATOM    324  O   ILE    40      20.241  38.802  72.387  1.00 53.13           O  
ATOM    325  CB  ILE    40      22.644  37.356  71.237  1.00 54.92           C  
ATOM    326  CG1 ILE    40      23.673  36.232  71.341  1.00 56.91           C  
ATOM    327  CG2 ILE    40      23.088  38.411  70.174  1.00 53.95           C  
ATOM    328  CD1 ILE    40      23.497  35.220  70.200  1.00 62.70           C  
ATOM    329  N   ILE    41      21.916  40.324  72.646  1.00 54.89           N  
ATOM    330  CA  ILE    41      21.146  41.479  72.242  1.00 56.47           C  
ATOM    331  C   ILE    41      21.851  42.189  71.064  1.00 57.24           C  
ATOM    332  O   ILE    41      23.010  42.600  71.162  1.00 56.09           O  
ATOM    333  CB  ILE    41      20.922  42.413  73.437  1.00 57.58           C  
ATOM    334  CG1 ILE    41      20.309  41.618  74.606  1.00 56.84           C  
ATOM    335  CG2 ILE    41      20.059  43.630  73.025  1.00 56.15           C  
ATOM    336  CD1 ILE    41      20.249  42.418  75.898  1.00 57.64           C  
ATOM    337  N   GLU    42      21.150  42.275  69.930  0.50 58.60           N  
ATOM    339  CA  GLU    42      21.737  42.779  68.677  0.50 59.91           C  
ATOM    341  C   GLU    42      21.887  44.290  68.699  0.50 59.38           C  
ATOM    343  O   GLU    42      21.031  45.008  69.225  0.50 60.09           O  
ATOM    345  CB  GLU    42      20.937  42.327  67.437  0.50 59.70           C  
ATOM    347  CG  GLU    42      21.709  42.516  66.084  0.50 61.58           C  
ATOM    349  CD  GLU    42      21.014  41.884  64.855  0.50 62.17           C  
ATOM    351  OE1 GLU    42      21.072  40.629  64.699  0.50 64.45           O  
ATOM    353  OE2 GLU    42      20.432  42.649  64.041  0.50 60.87           O  
ATOM    355  N   SER    43      23.002  44.740  68.141  1.00 59.25           N  
ATOM    356  CA  SER    43      23.355  46.133  67.959  1.00 58.50           C  
ATOM    357  C   SER    43      22.298  46.897  67.185  1.00 58.46           C  
ATOM    358  O   SER    43      21.519  46.314  66.445  1.00 59.01           O  
ATOM    359  CB  SER    43      24.674  46.202  67.167  1.00 57.90           C  
ATOM    360  OG  SER    43      25.051  47.555  66.994  1.00 59.25           O  
ATOM    361  N   VAL    44      22.286  48.217  67.359  1.00 58.06           N  
ATOM    362  CA  VAL    44      21.468  49.108  66.579  1.00 57.11           C  
ATOM    363  C   VAL    44      22.321  49.846  65.533  1.00 56.38           C  
ATOM    364  O   VAL    44      21.790  50.674  64.814  1.00 55.77           O  
ATOM    365  CB  VAL    44      20.806  50.149  67.484  1.00 57.90           C  
ATOM    366  CG1 VAL    44      19.692  49.471  68.322  1.00 59.20           C  
ATOM    367  CG2 VAL    44      21.886  50.864  68.405  1.00 56.67           C  
ATOM    368  N   HIS    45      23.625  49.575  65.457  1.00 54.20           N  
ATOM    369  CA  HIS    45      24.435  50.225  64.413  1.00 54.33           C  
ATOM    370  C   HIS    45      24.166  49.611  63.037  1.00 54.09           C  
ATOM    371  O   HIS    45      23.789  48.445  62.908  1.00 54.12           O  
ATOM    372  CB  HIS    45      25.929  50.109  64.736  1.00 53.49           C  
ATOM    373  CG  HIS    45      26.285  50.704  66.062  1.00 55.56           C  
ATOM    374  ND1 HIS    45      26.153  52.056  66.339  1.00 52.55           N  
ATOM    375  CD2 HIS    45      26.731  50.123  67.205  1.00 55.86           C  
ATOM    376  CE1 HIS    45      26.518  52.280  67.589  1.00 55.53           C  
ATOM    377  NE2 HIS    45      26.884  51.125  68.132  1.00 58.42           N  
ATOM    378  N   ALA    46      24.391  50.392  62.015  1.00 54.07           N  
ATOM    379  CA  ALA    46      24.227  49.917  60.652  1.00 55.35           C  
ATOM    380  C   ALA    46      25.188  48.734  60.377  1.00 55.86           C  
ATOM    381  O   ALA    46      24.779  47.633  59.972  1.00 55.11           O  
ATOM    382  CB  ALA    46      24.506  51.069  59.699  1.00 54.46           C  
ATOM    383  N   LEU    47      26.467  48.962  60.621  1.00 55.28           N  
ATOM    384  CA  LEU    47      27.377  47.918  60.442  1.00 56.25           C  
ATOM    385  C   LEU    47      27.511  47.148  61.767  1.00 57.03           C  
ATOM    386  O   LEU    47      28.034  47.672  62.734  1.00 57.57           O  
ATOM    387  CB  LEU    47      28.693  48.504  59.974  1.00 55.59           C  
ATOM    388  CG  LEU    47      29.831  47.494  59.835  1.00 57.97           C  
ATOM    389  CD1 LEU    47      29.449  46.359  58.803  1.00 54.62           C  
ATOM    390  CD2 LEU    47      31.099  48.273  59.426  1.00 55.91           C  
ATOM    391  N   ARG    48      27.074  45.897  61.817  1.00 58.29           N  
ATOM    392  CA  ARG    48      27.158  45.153  63.069  1.00 59.99           C  
ATOM    393  C   ARG    48      27.398  43.654  62.958  1.00 61.56           C  
ATOM    394  O   ARG    48      27.378  43.087  61.867  1.00 61.63           O  
ATOM    395  CB  ARG    48      25.875  45.345  63.836  1.00 60.62           C  
ATOM    396  CG  ARG    48      24.702  44.576  63.294  1.00 58.36           C  
ATOM    397  CD  ARG    48      23.538  45.335  63.769  1.00 62.40           C  
ATOM    398  NE  ARG    48      22.270  44.850  63.280  1.00 64.49           N  
ATOM    399  CZ  ARG    48      21.233  45.649  63.067  1.00 64.30           C  
ATOM    400  NH1 ARG    48      21.351  46.959  63.281  1.00 63.31           N  
ATOM    401  NH2 ARG    48      20.094  45.141  62.613  1.00 63.51           N  
ATOM    402  N   PHE    49      27.599  43.027  64.115  1.00 63.14           N  
ATOM    403  CA  PHE    49      27.646  41.567  64.221  1.00 65.24           C  
ATOM    404  C   PHE    49      26.239  41.014  64.215  1.00 65.96           C  
ATOM    405  O   PHE    49      25.409  41.464  65.015  1.00 66.23           O  
ATOM    406  CB  PHE    49      28.359  41.136  65.513  1.00 66.03           C  
ATOM    407  CG  PHE    49      29.859  41.075  65.381  1.00 68.58           C  
ATOM    408  CD1 PHE    49      30.680  41.662  66.330  1.00 70.90           C  
ATOM    409  CD2 PHE    49      30.452  40.445  64.290  1.00 70.05           C  
ATOM    410  CE1 PHE    49      32.091  41.589  66.235  1.00 72.91           C  
ATOM    411  CE2 PHE    49      31.845  40.399  64.170  1.00 73.92           C  
ATOM    412  CZ  PHE    49      32.672  40.974  65.173  1.00 70.09           C  
ATOM    413  N   HIS    50      25.962  40.103  63.284  1.00 66.85           N  
ATOM    414  CA  HIS    50      24.758  39.309  63.317  1.00 68.69           C  
ATOM    415  C   HIS    50      25.208  37.896  63.694  1.00 70.93           C  
ATOM    416  O   HIS    50      25.696  37.140  62.841  1.00 72.02           O  
ATOM    417  CB  HIS    50      24.075  39.262  61.959  1.00 68.34           C  
ATOM    418  CG  HIS    50      23.636  40.593  61.434  1.00 66.68           C  
ATOM    419  ND1 HIS    50      24.521  41.613  61.145  1.00 67.30           N  
ATOM    420  CD2 HIS    50      22.408  41.048  61.085  1.00 66.59           C  
ATOM    421  CE1 HIS    50      23.850  42.645  60.650  1.00 69.25           C  
ATOM    422  NE2 HIS    50      22.565  42.327  60.598  1.00 67.09           N  
ATOM    423  N   VAL    51      25.074  37.542  64.969  1.00 72.80           N  
ATOM    424  CA  VAL    51      25.490  36.225  65.440  1.00 74.54           C  
ATOM    425  C   VAL    51      24.566  35.166  64.884  1.00 76.64           C  
ATOM    426  O   VAL    51      23.370  35.197  65.174  1.00 78.19           O  
ATOM    427  CB  VAL    51      25.536  36.112  67.004  1.00 74.55           C  
ATOM    428  CG1 VAL    51      26.104  34.706  67.433  1.00 74.48           C  
ATOM    429  CG2 VAL    51      26.337  37.271  67.630  1.00 70.10           C  
ATOM    430  N   ASP    52      25.115  34.279  64.049  1.00 78.72           N  
ATOM    431  CA  ASP    52      24.439  33.061  63.575  1.00 81.20           C  
ATOM    432  C   ASP    52      24.609  31.950  64.617  1.00 82.80           C  
ATOM    433  O   ASP    52      25.737  31.513  64.892  1.00 83.06           O  
ATOM    434  CB  ASP    52      25.040  32.609  62.241  1.00 81.03           C  
ATOM    435  CG  ASP    52      24.673  31.184  61.876  1.00 83.02           C  
ATOM    436  OD1 ASP    52      23.734  30.577  62.458  1.00 84.81           O  
ATOM    437  OD2 ASP    52      25.347  30.655  60.982  1.00 84.60           O  
ATOM    438  N   GLU    53      23.492  31.484  65.176  1.00 84.68           N  
ATOM    439  CA  GLU    53      23.530  30.555  66.322  1.00 85.92           C  
ATOM    440  C   GLU    53      23.834  29.109  65.886  1.00 85.79           C  
ATOM    441  O   GLU    53      24.435  28.337  66.633  1.00 85.94           O  
ATOM    442  CB  GLU    53      22.220  30.629  67.119  1.00 86.63           C  
ATOM    443  CG  GLU    53      22.102  31.862  68.024  0.60 87.28           C  
ATOM    444  CD  GLU    53      20.726  32.513  67.933  0.60 89.75           C  
ATOM    445  OE1 GLU    53      19.709  31.792  67.794  0.60 90.02           O  
ATOM    446  OE2 GLU    53      20.658  33.760  68.016  0.60 91.66           O  
ATOM    447  N   ASN    54      23.439  28.755  64.670  1.00 85.26           N  
ATOM    448  CA  ASN    54      23.786  27.446  64.124  1.00 84.59           C  
ATOM    449  C   ASN    54      25.318  27.277  63.940  1.00 83.75           C  
ATOM    450  O   ASN    54      25.804  26.162  63.726  1.00 83.96           O  
ATOM    451  CB  ASN    54      23.039  27.208  62.800  0.60 84.69           C  
ATOM    452  CG  ASN    54      22.767  25.720  62.520  0.60 86.08           C  
ATOM    453  OD1 ASN    54      23.307  24.824  63.184  0.60 86.21           O  
ATOM    454  ND2 ASN    54      21.925  25.459  61.519  0.60 86.49           N  
ATOM    455  N   ALA    55      26.067  28.380  64.003  1.00 81.92           N  
ATOM    456  CA  ALA    55      27.524  28.342  63.826  1.00 80.70           C  
ATOM    457  C   ALA    55      28.178  27.586  64.984  1.00 79.23           C  
ATOM    458  O   ALA    55      27.803  27.762  66.133  1.00 79.82           O  
ATOM    459  CB  ALA    55      28.111  29.781  63.712  1.00 80.15           C  
ATOM    460  N   ILE    56      29.151  26.744  64.673  1.00 77.79           N  
ATOM    461  CA  ILE    56      29.908  25.989  65.678  1.00 75.90           C  
ATOM    462  C   ILE    56      31.181  26.767  65.873  1.00 74.50           C  
ATOM    463  O   ILE    56      31.910  26.976  64.913  1.00 74.29           O  
ATOM    464  CB  ILE    56      30.321  24.589  65.149  1.00 76.40           C  
ATOM    465  CG1 ILE    56      29.092  23.763  64.712  1.00 75.34           C  
ATOM    466  CG2 ILE    56      31.187  23.862  66.178  1.00 75.84           C  
ATOM    467  CD1 ILE    56      29.325  22.980  63.417  1.00 77.73           C  
ATOM    468  N   ARG    57      31.487  27.201  67.086  1.00 72.12           N  
ATOM    469  CA  ARG    57      32.693  27.987  67.183  1.00 69.90           C  
ATOM    470  C   ARG    57      33.635  27.565  68.274  1.00 66.50           C  
ATOM    471  O   ARG    57      33.315  27.693  69.445  1.00 66.81           O  
ATOM    472  CB  ARG    57      32.374  29.478  67.250  1.00 70.93           C  
ATOM    473  CG  ARG    57      31.240  29.833  68.125  1.00 76.49           C  
ATOM    474  CD  ARG    57      30.491  31.104  67.618  1.00 84.39           C  
ATOM    475  NE  ARG    57      29.043  30.863  67.752  1.00 89.80           N  
ATOM    476  CZ  ARG    57      28.082  31.417  67.016  1.00 91.00           C  
ATOM    477  NH1 ARG    57      28.343  32.318  66.062  1.00 89.27           N  
ATOM    478  NH2 ARG    57      26.837  31.055  67.262  1.00 94.92           N  
ATOM    479  N   PRO    58      34.812  27.064  67.894  1.00 63.24           N  
ATOM    480  CA  PRO    58      35.795  26.606  68.893  1.00 60.90           C  
ATOM    481  C   PRO    58      36.292  27.734  69.769  1.00 59.63           C  
ATOM    482  O   PRO    58      36.399  28.876  69.317  1.00 58.11           O  
ATOM    483  CB  PRO    58      36.936  26.041  68.045  1.00 60.40           C  
ATOM    484  CG  PRO    58      36.333  25.842  66.652  1.00 61.19           C  
ATOM    485  CD  PRO    58      35.270  26.871  66.507  1.00 62.00           C  
ATOM    486  N   LEU    59      36.609  27.414  71.019  1.00 59.37           N  
ATOM    487  CA  LEU    59      37.029  28.425  72.022  1.00 59.11           C  
ATOM    488  C   LEU    59      38.287  29.220  71.640  1.00 58.79           C  
ATOM    489  O   LEU    59      38.460  30.373  72.082  1.00 57.89           O  
ATOM    490  CB  LEU    59      37.198  27.794  73.415  1.00 58.49           C  
ATOM    491  CG  LEU    59      35.901  27.243  74.025  1.00 59.78           C  
ATOM    492  CD1 LEU    59      36.126  26.407  75.321  1.00 58.03           C  
ATOM    493  CD2 LEU    59      34.899  28.333  74.296  1.00 61.08           C  
ATOM    494  N   THR    60      39.165  28.627  70.834  1.00 58.42           N  
ATOM    495  CA  THR    60      40.355  29.358  70.385  1.00 59.36           C  
ATOM    496  C   THR    60      40.040  30.565  69.445  1.00 60.12           C  
ATOM    497  O   THR    60      40.906  31.385  69.165  1.00 60.01           O  
ATOM    498  CB  THR    60      41.361  28.430  69.673  1.00 59.36           C  
ATOM    499  OG1 THR    60      40.676  27.731  68.642  1.00 59.76           O  
ATOM    500  CG2 THR    60      42.023  27.433  70.630  1.00 56.72           C  
ATOM    501  N   MET    61      38.809  30.682  68.978  1.00 60.58           N  
ATOM    502  CA  MET    61      38.537  31.613  67.887  1.00 62.59           C  
ATOM    503  C   MET    61      37.882  32.922  68.305  1.00 62.66           C  
ATOM    504  O   MET    61      37.505  33.689  67.422  1.00 63.60           O  
ATOM    505  CB  MET    61      37.683  30.942  66.796  1.00 62.56           C  
ATOM    506  CG  MET    61      38.402  29.794  66.080  1.00 67.94           C  
ATOM    507  SD  MET    61      39.847  30.478  64.868  0.90 83.32          SE  
ATOM    508  CE  MET    61      38.659  31.285  63.505  1.00 77.45           C  
ATOM    509  N   SER    62      37.721  33.171  69.610  1.00 61.38           N  
ATOM    510  CA  SER    62      37.147  34.424  70.072  1.00 61.72           C  
ATOM    511  C   SER    62      37.695  34.811  71.425  1.00 62.10           C  
ATOM    512  O   SER    62      38.123  33.954  72.211  1.00 62.73           O  
ATOM    513  CB  SER    62      35.625  34.314  70.193  1.00 61.40           C  
ATOM    514  OG  SER    62      35.327  33.225  71.043  1.00 61.28           O  
ATOM    515  N   SER    63      37.680  36.107  71.713  1.00 62.25           N  
ATOM    516  CA  SER    63      38.120  36.572  73.022  1.00 61.90           C  
ATOM    517  C   SER    63      37.217  35.966  74.109  1.00 61.96           C  
ATOM    518  O   SER    63      37.692  35.658  75.202  1.00 62.43           O  
ATOM    519  CB  SER    63      38.114  38.099  73.078  1.00 61.78           C  
ATOM    520  OG  SER    63      36.778  38.581  72.922  1.00 63.32           O  
ATOM    521  N   ASN    64      35.928  35.765  73.825  1.00 62.05           N  
ATOM    522  CA  ASN    64      35.058  35.037  74.789  1.00 63.21           C  
ATOM    523  C   ASN    64      35.599  33.635  75.064  1.00 62.15           C  
ATOM    524  O   ASN    64      35.608  33.220  76.205  1.00 62.11           O  
ATOM    525  CB  ASN    64      33.632  34.858  74.260  1.00 65.22           C  
ATOM    526  CG  ASN    64      32.778  36.042  74.477  1.00 68.29           C  
ATOM    527  OD1 ASN    64      32.593  36.515  75.600  1.00 79.28           O  
ATOM    528  ND2 ASN    64      32.227  36.524  73.425  1.00 70.86           N  
ATOM    529  N   GLY    65      36.030  32.934  74.000  1.00 60.23           N  
ATOM    530  CA  GLY    65      36.699  31.675  74.116  1.00 60.81           C  
ATOM    531  C   GLY    65      37.903  31.664  75.057  1.00 60.68           C  
ATOM    532  O   GLY    65      37.973  30.840  75.976  1.00 60.10           O  
ATOM    533  N   TRP    66      38.835  32.588  74.856  1.00 60.85           N  
ATOM    534  CA  TRP    66      40.039  32.658  75.709  1.00 60.06           C  
ATOM    535  C   TRP    66      39.646  32.902  77.155  1.00 61.15           C  
ATOM    536  O   TRP    66      40.247  32.351  78.101  1.00 61.99           O  
ATOM    537  CB  TRP    66      40.997  33.752  75.215  1.00 59.30           C  
ATOM    538  CG  TRP    66      41.271  33.740  73.697  1.00 57.28           C  
ATOM    539  CD1 TRP    66      41.269  32.654  72.901  1.00 57.25           C  
ATOM    540  CD2 TRP    66      41.640  34.855  72.848  1.00 57.57           C  
ATOM    541  NE1 TRP    66      41.578  32.999  71.603  1.00 59.16           N  
ATOM    542  CE2 TRP    66      41.805  34.345  71.537  1.00 58.40           C  
ATOM    543  CE3 TRP    66      41.845  36.233  73.066  1.00 57.46           C  
ATOM    544  CZ2 TRP    66      42.141  35.160  70.434  1.00 58.20           C  
ATOM    545  CZ3 TRP    66      42.174  37.045  71.978  1.00 57.05           C  
ATOM    546  CH2 TRP    66      42.321  36.504  70.679  1.00 58.18           C  
ATOM    547  N   MET    67      38.620  33.721  77.354  1.00 61.67           N  
ATOM    548  CA  MET    67      38.196  34.034  78.730  1.00 61.56           C  
ATOM    549  C   MET    67      37.675  32.751  79.398  1.00 61.45           C  
ATOM    550  O   MET    67      38.030  32.471  80.533  1.00 60.34           O  
ATOM    551  CB  MET    67      37.128  35.144  78.733  1.00 62.34           C  
ATOM    552  CG  MET    67      36.847  35.786  80.055  1.00 62.83           C  
ATOM    553  SD  MET    67      38.278  37.022  80.632  0.85 76.26          SE  
ATOM    554  CE  MET    67      38.995  36.079  82.228  1.00 64.02           C  
ATOM    555  N   LEU    68      36.867  31.969  78.669  1.00 61.35           N  
ATOM    556  CA  LEU    68      36.327  30.715  79.196  1.00 61.71           C  
ATOM    557  C   LEU    68      37.367  29.609  79.436  1.00 62.43           C  
ATOM    558  O   LEU    68      37.310  28.891  80.449  1.00 62.05           O  
ATOM    559  CB  LEU    68      35.192  30.211  78.333  1.00 60.42           C  
ATOM    560  CG  LEU    68      34.014  31.190  78.339  1.00 59.67           C  
ATOM    561  CD1 LEU    68      33.203  31.009  77.111  1.00 53.38           C  
ATOM    562  CD2 LEU    68      33.125  31.045  79.587  1.00 56.87           C  
ATOM    563  N   MET    69      38.317  29.487  78.513  1.00 63.63           N  
ATOM    564  CA  MET    69      39.427  28.542  78.640  1.00 64.95           C  
ATOM    565  C   MET    69      40.298  28.887  79.821  1.00 63.85           C  
ATOM    566  O   MET    69      40.834  27.978  80.490  1.00 64.09           O  
ATOM    567  CB  MET    69      40.270  28.585  77.399  1.00 64.13           C  
ATOM    568  CG  MET    69      39.630  27.926  76.207  1.00 66.68           C  
ATOM    569  SD  MET    69      40.939  27.724  74.726  0.80 72.58          SE  
ATOM    570  CE  MET    69      40.747  29.457  73.987  1.00 62.11           C  
ATOM    571  N   SER    70      40.446  30.189  80.094  1.00 62.96           N  
ATOM    572  CA  SER    70      41.251  30.621  81.248  1.00 62.56           C  
ATOM    573  C   SER    70      40.745  30.049  82.590  1.00 61.84           C  
ATOM    574  O   SER    70      41.468  30.041  83.576  1.00 59.67           O  
ATOM    575  CB  SER    70      41.397  32.144  81.294  1.00 62.63           C  
ATOM    576  OG  SER    70      40.243  32.758  81.855  1.00 63.93           O  
ATOM    577  N   THR    71      39.523  29.517  82.591  1.00 62.19           N  
ATOM    578  CA  THR    71      38.983  28.859  83.794  1.00 63.14           C  
ATOM    579  C   THR    71      39.332  27.364  83.967  1.00 63.92           C  
ATOM    580  O   THR    71      39.199  26.839  85.071  1.00 62.99           O  
ATOM    581  CB  THR    71      37.458  29.064  83.955  1.00 62.41           C  
ATOM    582  OG1 THR    71      36.769  28.302  82.965  1.00 62.66           O  
ATOM    583  CG2 THR    71      37.098  30.522  83.810  1.00 61.93           C  
ATOM    584  N   MET    72      39.778  26.694  82.897  1.00 65.08           N  
ATOM    585  CA  MET    72      40.146  25.276  82.957  1.00 67.60           C  
ATOM    586  C   MET    72      41.548  25.007  83.593  1.00 66.23           C  
ATOM    587  O   MET    72      42.373  25.922  83.722  1.00 65.90           O  
ATOM    588  CB  MET    72      40.104  24.668  81.553  1.00 67.24           C  
ATOM    589  CG  MET    72      38.781  24.730  80.785  1.00 68.31           C  
ATOM    590  SD  MET    72      39.303  24.612  78.854  0.83 75.69          SE  
ATOM    591  CE  MET    72      37.549  24.486  78.022  1.00 70.38           C  
ATOM    592  N   ASN    73      41.822  23.756  83.975  1.00 65.62           N  
ATOM    593  CA  ASN    73      43.211  23.352  84.255  1.00 65.21           C  
ATOM    594  C   ASN    73      44.043  23.140  82.967  1.00 64.52           C  
ATOM    595  O   ASN    73      43.489  23.091  81.854  1.00 64.27           O  
ATOM    596  CB  ASN    73      43.283  22.131  85.181  1.00 65.82           C  
ATOM    597  CG  ASN    73      42.587  20.888  84.604  1.00 67.09           C  
ATOM    598  OD1 ASN    73      42.952  20.361  83.538  1.00 64.81           O  
ATOM    599  ND2 ASN    73      41.595  20.394  85.344  1.00 69.28           N  
ATOM    600  N   ASP    74      45.366  23.035  83.110  1.00 63.68           N  
ATOM    601  CA  ASP    74      46.261  23.053  81.935  1.00 63.28           C  
ATOM    602  C   ASP    74      46.104  21.827  81.067  1.00 62.96           C  
ATOM    603  O   ASP    74      46.128  21.926  79.841  1.00 62.13           O  
ATOM    604  CB  ASP    74      47.734  23.235  82.331  1.00 63.20           C  
ATOM    605  CG  ASP    74      48.018  24.603  82.948  1.00 62.80           C  
ATOM    606  OD1 ASP    74      47.344  25.614  82.582  1.00 57.50           O  
ATOM    607  OD2 ASP    74      48.943  24.654  83.805  1.00 63.27           O  
ATOM    608  N   LYS    75      45.951  20.669  81.716  1.00 63.12           N  
ATOM    609  CA  LYS    75      45.617  19.425  81.016  1.00 63.50           C  
ATOM    610  C   LYS    75      44.442  19.643  80.021  1.00 62.99           C  
ATOM    611  O   LYS    75      44.553  19.282  78.838  1.00 62.58           O  
ATOM    612  CB  LYS    75      45.302  18.311  82.018  1.00 64.00           C  
ATOM    613  CG  LYS    75      44.618  17.073  81.419  1.00 66.39           C  
ATOM    614  CD  LYS    75      45.609  16.170  80.682  1.00 68.66           C  
ATOM    615  CE  LYS    75      45.215  14.702  80.810  1.00 69.70           C  
ATOM    616  NZ  LYS    75      44.822  14.371  82.205  1.00 68.07           N  
ATOM    617  N   ALA    76      43.358  20.251  80.518  1.00 62.16           N  
ATOM    618  CA  ALA    76      42.173  20.555  79.738  1.00 61.81           C  
ATOM    619  C   ALA    76      42.404  21.654  78.702  1.00 61.74           C  
ATOM    620  O   ALA    76      41.778  21.620  77.655  1.00 62.13           O  
ATOM    621  CB  ALA    76      40.962  20.889  80.643  1.00 61.24           C  
ATOM    622  N   ILE    77      43.291  22.611  78.960  1.00 61.38           N  
ATOM    623  CA  ILE    77      43.527  23.668  77.966  1.00 61.49           C  
ATOM    624  C   ILE    77      44.270  23.122  76.741  1.00 61.52           C  
ATOM    625  O   ILE    77      43.900  23.431  75.582  1.00 61.15           O  
ATOM    626  CB  ILE    77      44.272  24.870  78.563  1.00 61.79           C  
ATOM    627  CG1 ILE    77      43.304  25.714  79.384  1.00 62.94           C  
ATOM    628  CG2 ILE    77      44.891  25.749  77.483  1.00 61.12           C  
ATOM    629  CD1 ILE    77      44.013  26.581  80.448  1.00 64.59           C  
ATOM    630  N   ASP    78      45.301  22.325  77.025  1.00 60.60           N  
ATOM    631  CA  ASP    78      46.123  21.617  76.035  1.00 60.87           C  
ATOM    632  C   ASP    78      45.265  20.716  75.162  1.00 60.02           C  
ATOM    633  O   ASP    78      45.365  20.782  73.944  1.00 60.82           O  
ATOM    634  CB  ASP    78      47.235  20.818  76.743  1.00 61.04           C  
ATOM    635  CG  ASP    78      48.164  20.069  75.768  1.00 63.40           C  
ATOM    636  OD1 ASP    78      49.198  20.665  75.346  1.00 64.85           O  
ATOM    637  OD2 ASP    78      47.897  18.863  75.476  1.00 63.02           O  
ATOM    638  N   ASN    79      44.386  19.920  75.764  1.00 58.88           N  
ATOM    639  CA  ASN    79      43.433  19.133  74.969  1.00 58.94           C  
ATOM    640  C   ASN    79      42.545  20.000  74.060  1.00 58.14           C  
ATOM    641  O   ASN    79      42.268  19.633  72.918  1.00 57.90           O  
ATOM    642  CB  ASN    79      42.566  18.223  75.848  1.00 59.09           C  
ATOM    643  CG  ASN    79      43.241  16.904  76.173  1.00 62.16           C  
ATOM    644  OD1 ASN    79      43.004  16.335  77.229  1.00 68.10           O  
ATOM    645  ND2 ASN    79      44.111  16.423  75.286  1.00 64.79           N  
ATOM    646  N   THR    80      42.128  21.144  74.586  1.00 56.98           N  
ATOM    647  CA  THR    80      41.215  22.041  73.923  1.00 56.94           C  
ATOM    648  C   THR    80      41.865  22.679  72.704  1.00 57.00           C  
ATOM    649  O   THR    80      41.270  22.741  71.660  1.00 56.26           O  
ATOM    650  CB  THR    80      40.747  23.142  74.904  1.00 56.98           C  
ATOM    651  OG1 THR    80      40.079  22.527  76.017  1.00 57.25           O  
ATOM    652  CG2 THR    80      39.822  24.144  74.210  1.00 54.70           C  
ATOM    653  N   VAL    81      43.106  23.121  72.845  1.00 57.77           N  
ATOM    654  CA  VAL    81      43.812  23.793  71.760  1.00 58.51           C  
ATOM    655  C   VAL    81      44.132  22.771  70.661  1.00 59.17           C  
ATOM    656  O   VAL    81      43.908  23.026  69.446  1.00 59.51           O  
ATOM    657  CB  VAL    81      45.077  24.485  72.298  1.00 58.47           C  
ATOM    658  CG1 VAL    81      45.956  25.012  71.173  1.00 59.77           C  
ATOM    659  CG2 VAL    81      44.667  25.627  73.229  1.00 58.29           C  
ATOM    660  N   ARG    82      44.650  21.625  71.097  1.00 58.86           N  
ATOM    661  CA  ARG    82      44.843  20.479  70.223  1.00 59.54           C  
ATOM    662  C   ARG    82      43.578  20.079  69.460  1.00 58.76           C  
ATOM    663  O   ARG    82      43.616  19.944  68.232  1.00 58.98           O  
ATOM    664  CB  ARG    82      45.336  19.280  71.016  1.00 59.66           C  
ATOM    665  CG  ARG    82      46.764  19.394  71.436  1.00 62.54           C  
ATOM    666  CD  ARG    82      47.353  18.008  71.689  1.00 68.17           C  
ATOM    667  NE  ARG    82      48.644  18.100  72.370  1.00 72.16           N  
ATOM    668  CZ  ARG    82      49.756  18.641  71.857  1.00 74.78           C  
ATOM    669  NH1 ARG    82      50.854  18.663  72.601  1.00 77.11           N  
ATOM    670  NH2 ARG    82      49.788  19.166  70.627  1.00 74.25           N  
ATOM    671  N   ARG    83      42.471  19.868  70.171  1.00 57.49           N  
ATOM    672  CA  ARG    83      41.263  19.414  69.504  1.00 56.42           C  
ATOM    673  C   ARG    83      40.747  20.521  68.593  1.00 57.09           C  
ATOM    674  O   ARG    83      40.403  20.291  67.422  1.00 57.36           O  
ATOM    675  CB  ARG    83      40.222  19.001  70.508  1.00 55.85           C  
ATOM    676  CG  ARG    83      40.414  17.634  71.086  1.00 52.71           C  
ATOM    677  CD  ARG    83      39.437  17.479  72.198  1.00 49.77           C  
ATOM    678  NE  ARG    83      38.088  17.644  71.693  1.00 50.59           N  
ATOM    679  CZ  ARG    83      36.995  17.770  72.437  1.00 51.09           C  
ATOM    680  NH1 ARG    83      35.796  17.947  71.861  1.00 52.66           N  
ATOM    681  NH2 ARG    83      37.089  17.758  73.743  1.00 48.77           N  
ATOM    682  N   ALA    84      40.759  21.740  69.114  1.00 56.57           N  
ATOM    683  CA  ALA    84      40.339  22.870  68.356  1.00 56.57           C  
ATOM    684  C   ALA    84      41.197  23.105  67.084  1.00 57.76           C  
ATOM    685  O   ALA    84      40.669  23.593  66.068  1.00 57.61           O  
ATOM    686  CB  ALA    84      40.286  24.127  69.264  1.00 55.96           C  
ATOM    687  N   ASN    85      42.490  22.782  67.118  1.00 58.24           N  
ATOM    688  CA  ASN    85      43.273  22.956  65.905  1.00 60.37           C  
ATOM    689  C   ASN    85      42.833  22.048  64.775  1.00 60.82           C  
ATOM    690  O   ASN    85      42.806  22.477  63.633  1.00 60.37           O  
ATOM    691  CB  ASN    85      44.775  22.831  66.141  1.00 60.47           C  
ATOM    692  CG  ASN    85      45.333  24.018  66.874  1.00 62.26           C  
ATOM    693  OD1 ASN    85      44.775  25.138  66.813  1.00 63.47           O  
ATOM    694  ND2 ASN    85      46.422  23.794  67.594  1.00 60.57           N  
ATOM    695  N   THR    86      42.459  20.806  65.091  1.00 61.75           N  
ATOM    696  CA  THR    86      42.035  19.873  64.035  1.00 62.30           C  
ATOM    697  C   THR    86      40.785  20.329  63.280  1.00 63.07           C  
ATOM    698  O   THR    86      40.472  19.804  62.212  1.00 63.65           O  
ATOM    699  CB  THR    86      41.828  18.456  64.559  1.00 62.23           C  
ATOM    700  OG1 THR    86      40.606  18.376  65.330  1.00 61.94           O  
ATOM    701  CG2 THR    86      43.042  18.049  65.370  1.00 60.63           C  
ATOM    702  N   ILE    87      40.077  21.290  63.854  1.00 63.43           N  
ATOM    703  CA  ILE    87      38.855  21.778  63.286  1.00 64.20           C  
ATOM    704  C   ILE    87      39.097  23.083  62.491  1.00 65.71           C  
ATOM    705  O   ILE    87      38.612  23.241  61.347  1.00 66.80           O  
ATOM    706  CB  ILE    87      37.839  22.037  64.409  1.00 64.04           C  
ATOM    707  CG1 ILE    87      37.428  20.720  65.060  1.00 64.25           C  
ATOM    708  CG2 ILE    87      36.622  22.825  63.896  1.00 61.32           C  
ATOM    709  CD1 ILE    87      36.579  20.902  66.315  1.00 64.40           C  
ATOM    710  N   THR    88      39.830  24.013  63.109  1.00 65.78           N  
ATOM    711  CA  THR    88      40.080  25.292  62.519  1.00 65.90           C  
ATOM    712  C   THR    88      41.104  25.172  61.410  1.00 67.94           C  
ATOM    713  O   THR    88      41.161  26.035  60.520  1.00 68.74           O  
ATOM    714  CB  THR    88      40.510  26.352  63.552  1.00 65.51           C  
ATOM    715  OG1 THR    88      41.762  26.000  64.153  1.00 62.03           O  
ATOM    716  CG2 THR    88      39.449  26.507  64.601  1.00 62.86           C  
ATOM    717  N   GLN    89      41.891  24.109  61.435  1.00 69.42           N  
ATOM    718  CA  GLN    89      42.896  23.928  60.401  1.00 72.17           C  
ATOM    719  C   GLN    89      42.322  23.397  59.095  1.00 73.16           C  
ATOM    720  O   GLN    89      43.009  23.403  58.065  1.00 73.16           O  
ATOM    721  CB  GLN    89      44.039  23.048  60.878  1.00 72.31           C  
ATOM    722  CG  GLN    89      43.839  21.604  60.590  1.00 74.64           C  
ATOM    723  CD  GLN    89      45.043  20.815  61.004  1.00 79.85           C  
ATOM    724  OE1 GLN    89      46.007  21.388  61.534  1.00 82.02           O  
ATOM    725  NE2 GLN    89      45.011  19.489  60.776  1.00 79.99           N  
ATOM    726  N   LYS    90      41.071  22.948  59.138  1.00 75.07           N  
ATOM    727  CA  LYS    90      40.334  22.613  57.916  1.00 76.91           C  
ATOM    728  C   LYS    90      40.078  23.899  57.120  1.00 77.20           C  
ATOM    729  O   LYS    90      39.646  23.844  55.972  1.00 77.61           O  
ATOM    730  CB  LYS    90      39.009  21.910  58.248  1.00 76.83           C  
ATOM    731  CG  LYS    90      39.163  20.447  58.696  1.00 78.58           C  
ATOM    732  CD  LYS    90      37.796  19.756  58.977  1.00 78.62           C  
ATOM    733  CE  LYS    90      37.079  20.337  60.220  1.00 80.18           C  
ATOM    734  NZ  LYS    90      36.280  19.307  60.970  1.00 78.76           N  
ATOM    735  N   ASP    91      40.348  25.045  57.747  1.00 77.44           N  
ATOM    736  CA  ASP    91      40.246  26.365  57.120  1.00 77.76           C  
ATOM    737  C   ASP    91      41.585  27.103  57.126  1.00 77.52           C  
ATOM    738  O   ASP    91      41.632  28.325  56.987  1.00 77.39           O  
ATOM    739  CB  ASP    91      39.208  27.222  57.867  1.00 78.38           C  
ATOM    740  CG  ASP    91      37.829  26.569  57.912  1.00 80.49           C  
ATOM    741  OD1 ASP    91      37.535  25.680  57.065  1.00 82.90           O  
ATOM    742  OD2 ASP    91      37.031  26.950  58.792  1.00 82.18           O  
ATOM    743  N   GLY    92      42.672  26.362  57.299  1.00 77.83           N  
ATOM    744  CA  GLY    92      44.023  26.940  57.329  1.00 78.14           C  
ATOM    745  C   GLY    92      44.409  27.771  58.555  1.00 78.53           C  
ATOM    746  O   GLY    92      45.425  28.465  58.523  1.00 79.06           O  
ATOM    747  N   ILE    93      43.619  27.708  59.627  1.00 78.12           N  
ATOM    748  CA  ILE    93      43.927  28.425  60.856  1.00 78.01           C  
ATOM    749  C   ILE    93      44.383  27.445  61.948  1.00 78.31           C  
ATOM    750  O   ILE    93      43.752  26.410  62.152  1.00 78.15           O  
ATOM    751  CB  ILE    93      42.682  29.204  61.341  1.00 78.66           C  
ATOM    752  CG1 ILE    93      42.101  30.093  60.211  1.00 78.35           C  
ATOM    753  CG2 ILE    93      42.945  29.921  62.713  1.00 76.93           C  
ATOM    754  CD1 ILE    93      43.079  31.140  59.608  1.00 81.98           C  
ATOM    755  N   ARG    94      45.467  27.756  62.653  1.00 78.39           N  
ATOM    756  CA  ARG    94      45.864  26.906  63.778  1.00 79.60           C  
ATOM    757  C   ARG    94      46.863  27.551  64.739  1.00 79.87           C  
ATOM    758  O   ARG    94      47.994  27.826  64.356  1.00 80.34           O  
ATOM    759  CB  ARG    94      46.404  25.546  63.289  1.00 79.45           C  
ATOM    760  CG  ARG    94      47.917  25.471  63.148  1.00 80.34           C  
ATOM    761  CD  ARG    94      48.417  24.130  62.626  1.00 80.98           C  
ATOM    762  NE  ARG    94      48.116  23.009  63.522  1.00 83.82           N  
ATOM    763  CZ  ARG    94      48.738  22.766  64.678  1.00 84.40           C  
ATOM    764  NH1 ARG    94      49.699  23.581  65.130  1.00 83.20           N  
ATOM    765  NH2 ARG    94      48.384  21.703  65.397  1.00 83.66           N  
ATOM    766  N   PHE    95      46.456  27.734  65.994  1.00 80.07           N  
ATOM    767  CA  PHE    95      47.285  28.366  67.031  1.00 80.20           C  
ATOM    768  C   PHE    95      48.290  27.422  67.702  1.00 80.50           C  
ATOM    769  O   PHE    95      47.963  26.281  68.021  1.00 80.42           O  
ATOM    770  CB  PHE    95      46.379  29.004  68.083  1.00 80.47           C  
ATOM    771  CG  PHE    95      45.260  29.821  67.488  1.00 80.99           C  
ATOM    772  CD1 PHE    95      45.473  31.141  67.111  1.00 81.79           C  
ATOM    773  CD2 PHE    95      44.012  29.254  67.261  1.00 80.65           C  
ATOM    774  CE1 PHE    95      44.448  31.894  66.533  1.00 83.00           C  
ATOM    775  CE2 PHE    95      42.980  29.995  66.685  1.00 82.25           C  
ATOM    776  CZ  PHE    95      43.192  31.318  66.327  1.00 82.26           C  
ATOM    777  N   GLU    96      49.522  27.882  67.905  1.00 80.58           N  
ATOM    778  CA  GLU    96      50.494  27.020  68.550  1.00 81.30           C  
ATOM    779  C   GLU    96      50.231  26.970  70.046  1.00 80.62           C  
ATOM    780  O   GLU    96      50.088  28.001  70.710  1.00 80.58           O  
ATOM    781  CB  GLU    96      51.942  27.422  68.240  1.00 82.00           C  
ATOM    782  CG  GLU    96      52.438  27.100  66.785  1.00 85.70           C  
ATOM    783  CD  GLU    96      52.380  25.603  66.391  1.00 88.37           C  
ATOM    784  OE1 GLU    96      53.160  24.794  66.957  1.00 87.64           O  
ATOM    785  OE2 GLU    96      51.555  25.257  65.500  1.00 89.69           O  
ATOM    786  N   VAL    97      50.152  25.751  70.559  1.00 80.00           N  
ATOM    787  CA  VAL    97      49.779  25.512  71.943  1.00 79.52           C  
ATOM    788  C   VAL    97      50.508  26.506  72.853  1.00 79.00           C  
ATOM    789  O   VAL    97      49.884  27.239  73.624  1.00 79.10           O  
ATOM    790  CB  VAL    97      50.003  24.009  72.319  1.00 79.44           C  
ATOM    791  CG1 VAL    97      51.460  23.558  72.020  1.00 81.14           C  
ATOM    792  CG2 VAL    97      49.593  23.714  73.766  1.00 78.94           C  
ATOM    793  N   ASP    98      51.826  26.549  72.704  1.00 78.35           N  
ATOM    794  CA  ASP    98      52.696  27.550  73.308  1.00 77.56           C  
ATOM    795  C   ASP    98      52.109  28.969  73.485  1.00 76.70           C  
ATOM    796  O   ASP    98      51.942  29.435  74.613  1.00 76.47           O  
ATOM    797  CB  ASP    98      53.966  27.631  72.460  0.60 77.75           C  
ATOM    798  CG  ASP    98      55.156  28.053  73.258  0.60 78.16           C  
ATOM    799  OD1 ASP    98      55.026  28.992  74.072  0.60 78.47           O  
ATOM    800  OD2 ASP    98      56.226  27.440  73.072  0.60 79.39           O  
ATOM    801  N   ASP    99      51.786  29.611  72.368  0.60 76.19           N  
ATOM    803  CA  ASP    99      51.334  30.997  72.340  0.60 75.94           C  
ATOM    805  C   ASP    99      49.880  31.178  72.794  0.60 75.52           C  
ATOM    807  O   ASP    99      49.511  32.196  73.385  0.60 75.43           O  
ATOM    809  CB  ASP    99      51.500  31.548  70.923  0.60 76.07           C  
ATOM    811  CG  ASP    99      52.906  31.364  70.386  0.60 76.52           C  
ATOM    813  OD1 ASP    99      53.090  31.409  69.148  0.60 77.25           O  
ATOM    815  OD2 ASP    99      53.830  31.168  71.201  0.60 77.63           O  
ATOM    817  N   MET   100      49.047  30.200  72.489  1.00 75.00           N  
ATOM    818  CA  MET   100      47.674  30.236  72.938  1.00 74.50           C  
ATOM    819  C   MET   100      47.674  30.109  74.478  1.00 73.72           C  
ATOM    820  O   MET   100      47.061  30.907  75.168  1.00 73.25           O  
ATOM    821  CB  MET   100      46.866  29.138  72.262  1.00 74.34           C  
ATOM    822  CG  MET   100      45.425  29.075  72.717  1.00 75.88           C  
ATOM    823  SD  MET   100      44.372  30.641  72.207  0.85 76.98          SE  
ATOM    824  CE  MET   100      44.151  31.437  73.926  1.00 75.18           C  
ATOM    825  N   MET   101      48.427  29.135  74.992  1.00 72.91           N  
ATOM    826  CA  MET   101      48.593  28.908  76.424  1.00 72.12           C  
ATOM    827  C   MET   101      49.163  30.128  77.135  1.00 71.11           C  
ATOM    828  O   MET   101      48.882  30.349  78.288  1.00 70.87           O  
ATOM    829  CB  MET   101      49.515  27.710  76.631  1.00 72.60           C  
ATOM    830  CG  MET   101      49.809  27.395  78.061  1.00 73.93           C  
ATOM    831  SD  MET   101      48.149  26.866  78.967  0.60 77.64          SE  
ATOM    832  CE  MET   101      48.324  24.912  78.642  1.00 75.16           C  
ATOM    833  N   ALA   102      49.978  30.897  76.422  1.00 70.44           N  
ATOM    834  CA  ALA   102      50.494  32.171  76.882  1.00 69.35           C  
ATOM    835  C   ALA   102      49.409  33.231  76.908  1.00 68.45           C  
ATOM    836  O   ALA   102      49.242  33.887  77.920  1.00 68.65           O  
ATOM    837  CB  ALA   102      51.652  32.613  76.008  1.00 69.18           C  
ATOM    838  N   ARG   103      48.670  33.396  75.810  1.00 68.30           N  
ATOM    839  CA  ARG   103      47.555  34.377  75.743  1.00 67.14           C  
ATOM    840  C   ARG   103      46.513  34.122  76.825  1.00 65.74           C  
ATOM    841  O   ARG   103      46.047  35.029  77.483  1.00 65.11           O  
ATOM    842  CB  ARG   103      46.894  34.389  74.352  1.00 67.51           C  
ATOM    843  CG  ARG   103      45.843  35.526  74.092  1.00 69.99           C  
ATOM    844  CD  ARG   103      46.368  36.997  74.358  1.00 77.43           C  
ATOM    845  NE  ARG   103      46.236  37.886  73.177  1.00 81.71           N  
ATOM    846  CZ  ARG   103      45.219  38.730  72.955  1.00 85.14           C  
ATOM    847  NH1 ARG   103      44.228  38.831  73.838  1.00 87.71           N  
ATOM    848  NH2 ARG   103      45.170  39.478  71.844  1.00 85.06           N  
ATOM    849  N   ILE   104      46.155  32.866  77.003  1.00 65.17           N  
ATOM    850  CA  ILE   104      45.250  32.469  78.072  1.00 64.96           C  
ATOM    851  C   ILE   104      45.767  32.813  79.462  1.00 64.64           C  
ATOM    852  O   ILE   104      45.010  33.294  80.291  1.00 64.83           O  
ATOM    853  CB  ILE   104      44.872  30.974  77.981  1.00 64.89           C  
ATOM    854  CG1 ILE   104      43.935  30.769  76.796  1.00 66.45           C  
ATOM    855  CG2 ILE   104      44.174  30.506  79.264  1.00 64.73           C  
ATOM    856  CD1 ILE   104      43.932  29.348  76.238  1.00 70.32           C  
ATOM    857  N   ARG   105      47.046  32.581  79.719  0.60 64.58           N  
ATOM    859  CA  ARG   105      47.571  32.898  81.044  0.60 64.64           C  
ATOM    861  C   ARG   105      47.507  34.418  81.296  0.60 65.04           C  
ATOM    863  O   ARG   105      47.146  34.856  82.401  0.60 65.11           O  
ATOM    865  CB  ARG   105      48.959  32.268  81.268  0.60 64.15           C  
ATOM    867  CG  ARG   105      49.019  30.745  80.916  0.60 62.26           C  
ATOM    869  CD  ARG   105      49.908  29.930  81.861  0.60 59.20           C  
ATOM    871  NE  ARG   105      50.733  28.913  81.192  0.60 56.19           N  
ATOM    873  CZ  ARG   105      50.648  27.599  81.405  0.60 53.93           C  
ATOM    875  NH1 ARG   105      51.453  26.771  80.766  0.60 52.55           N  
ATOM    877  NH2 ARG   105      49.757  27.107  82.249  0.60 52.59           N  
ATOM    879  N   GLN   106      47.782  35.202  80.250  1.00 65.19           N  
ATOM    880  CA  GLN   106      47.661  36.674  80.283  1.00 66.44           C  
ATOM    881  C   GLN   106      46.219  37.148  80.563  1.00 66.11           C  
ATOM    882  O   GLN   106      45.987  38.039  81.370  1.00 65.91           O  
ATOM    883  CB  GLN   106      48.139  37.258  78.936  1.00 66.21           C  
ATOM    884  CG  GLN   106      48.160  38.781  78.873  1.00 68.89           C  
ATOM    885  CD  GLN   106      48.161  39.330  77.451  1.00 69.30           C  
ATOM    886  OE1 GLN   106      47.230  39.099  76.691  1.00 78.30           O  
ATOM    887  NE2 GLN   106      49.198  40.075  77.094  1.00 73.54           N  
ATOM    888  N   VAL   107      45.251  36.538  79.892  1.00 66.18           N  
ATOM    889  CA  VAL   107      43.862  36.931  80.045  1.00 66.70           C  
ATOM    890  C   VAL   107      43.368  36.703  81.494  1.00 67.44           C  
ATOM    891  O   VAL   107      42.708  37.561  82.099  1.00 66.39           O  
ATOM    892  CB  VAL   107      43.007  36.198  79.002  1.00 66.50           C  
ATOM    893  CG1 VAL   107      41.573  35.994  79.503  1.00 66.31           C  
ATOM    894  CG2 VAL   107      43.053  36.959  77.686  1.00 64.13           C  
ATOM    895  N   ARG   108      43.711  35.531  82.025  1.00 68.65           N  
ATOM    896  CA  ARG   108      43.437  35.162  83.410  1.00 69.82           C  
ATOM    897  C   ARG   108      44.035  36.222  84.356  1.00 71.05           C  
ATOM    898  O   ARG   108      43.384  36.638  85.340  1.00 70.77           O  
ATOM    899  CB  ARG   108      43.991  33.751  83.721  1.00 69.62           C  
ATOM    900  CG  ARG   108      43.597  33.210  85.119  1.00 69.62           C  
ATOM    901  CD  ARG   108      44.401  31.981  85.533  1.00 68.90           C  
ATOM    902  NE  ARG   108      44.109  30.834  84.678  1.00 67.11           N  
ATOM    903  CZ  ARG   108      45.010  29.969  84.222  1.00 65.78           C  
ATOM    904  NH1 ARG   108      44.619  28.965  83.441  1.00 62.37           N  
ATOM    905  NH2 ARG   108      46.297  30.107  84.545  1.00 67.13           N  
ATOM    906  N   GLU   109      45.259  36.661  84.034  1.00 72.13           N  
ATOM    907  CA  GLU   109      45.939  37.716  84.794  1.00 73.60           C  
ATOM    908  C   GLU   109      45.204  39.061  84.741  1.00 73.35           C  
ATOM    909  O   GLU   109      44.693  39.530  85.763  1.00 73.58           O  
ATOM    910  CB  GLU   109      47.385  37.880  84.320  1.00 73.60           C  
ATOM    911  CG  GLU   109      48.345  38.293  85.440  1.00 74.84           C  
ATOM    912  CD  GLU   109      49.683  38.819  84.920  1.00 75.40           C  
ATOM    913  OE1 GLU   109      49.694  39.511  83.867  1.00 78.84           O  
ATOM    914  OE2 GLU   109      50.721  38.555  85.572  1.00 75.88           O  
ATOM    915  N   GLN   110      45.117  39.652  83.547  1.00 73.36           N  
ATOM    916  CA  GLN   110      44.529  40.995  83.375  1.00 72.79           C  
ATOM    917  C   GLN   110      43.013  41.152  83.647  1.00 71.55           C  
ATOM    918  O   GLN   110      42.564  42.291  83.828  1.00 71.83           O  
ATOM    919  CB  GLN   110      44.899  41.578  82.006  1.00 72.97           C  
ATOM    920  CG  GLN   110      44.154  40.900  80.880  1.00 74.32           C  
ATOM    921  CD  GLN   110      44.831  41.080  79.538  1.00 75.81           C  
ATOM    922  OE1 GLN   110      46.072  41.145  79.455  1.00 74.48           O  
ATOM    923  NE2 GLN   110      44.016  41.145  78.467  1.00 73.00           N  
ATOM    924  N   GLY   111      42.251  40.048  83.693  1.00 70.23           N  
ATOM    925  CA  GLY   111      40.821  40.054  84.127  1.00 68.74           C  
ATOM    926  C   GLY   111      39.765  40.105  83.019  1.00 68.41           C  
ATOM    927  O   GLY   111      38.535  40.009  83.267  1.00 67.72           O  
ATOM    928  N   TYR   112      40.237  40.245  81.785  1.00 67.60           N  
ATOM    929  CA  TYR   112      39.367  40.447  80.621  1.00 67.38           C  
ATOM    930  C   TYR   112      40.115  40.034  79.362  1.00 66.21           C  
ATOM    931  O   TYR   112      41.348  39.829  79.414  1.00 66.31           O  
ATOM    932  CB  TYR   112      39.012  41.939  80.477  1.00 68.34           C  
ATOM    933  CG  TYR   112      40.254  42.789  80.427  1.00 70.12           C  
ATOM    934  CD1 TYR   112      40.904  43.058  79.212  1.00 72.48           C  
ATOM    935  CD2 TYR   112      40.811  43.296  81.603  1.00 70.44           C  
ATOM    936  CE1 TYR   112      42.092  43.844  79.176  1.00 72.21           C  
ATOM    937  CE2 TYR   112      41.962  44.071  81.575  1.00 72.48           C  
ATOM    938  CZ  TYR   112      42.597  44.334  80.362  1.00 72.07           C  
ATOM    939  OH  TYR   112      43.740  45.103  80.381  1.00 73.81           O  
ATOM    940  N   ALA   113      39.396  39.973  78.232  1.00 63.62           N  
ATOM    941  CA  ALA   113      40.045  39.704  76.957  1.00 62.19           C  
ATOM    942  C   ALA   113      39.529  40.638  75.861  1.00 61.50           C  
ATOM    943  O   ALA   113      38.406  41.113  75.914  1.00 62.63           O  
ATOM    944  CB  ALA   113      39.874  38.221  76.557  1.00 61.70           C  
ATOM    945  N   SER   114      40.363  40.940  74.895  1.00 59.84           N  
ATOM    946  CA  SER   114      39.903  41.583  73.708  1.00 59.77           C  
ATOM    947  C   SER   114      40.680  41.049  72.491  1.00 59.17           C  
ATOM    948  O   SER   114      41.711  40.411  72.631  1.00 58.24           O  
ATOM    949  CB  SER   114      40.004  43.083  73.840  1.00 59.57           C  
ATOM    950  OG  SER   114      41.356  43.445  74.060  1.00 62.96           O  
ATOM    951  N   ALA   115      40.152  41.309  71.306  1.00 59.12           N  
ATOM    952  CA  ALA   115      40.660  40.719  70.093  1.00 59.65           C  
ATOM    953  C   ALA   115      40.253  41.616  68.966  1.00 60.51           C  
ATOM    954  O   ALA   115      39.161  42.214  68.986  1.00 60.26           O  
ATOM    955  CB  ALA   115      40.033  39.339  69.879  1.00 59.03           C  
ATOM    956  N   GLU   116      41.131  41.683  67.979  1.00 61.40           N  
ATOM    957  CA  GLU   116      40.941  42.411  66.748  1.00 62.48           C  
ATOM    958  C   GLU   116      40.932  41.386  65.627  1.00 61.94           C  
ATOM    959  O   GLU   116      41.831  40.534  65.562  1.00 61.71           O  
ATOM    960  CB  GLU   116      42.178  43.242  66.470  1.00 62.91           C  
ATOM    961  CG  GLU   116      42.362  44.501  67.253  1.00 64.87           C  
ATOM    962  CD  GLU   116      43.608  45.273  66.759  1.00 66.94           C  
ATOM    963  OE1 GLU   116      44.407  44.722  65.917  1.00 68.23           O  
ATOM    964  OE2 GLU   116      43.771  46.437  67.224  1.00 72.76           O  
ATOM    965  N   HIS   117      39.970  41.495  64.716  1.00 60.74           N  
ATOM    966  CA  HIS   117      39.988  40.687  63.512  1.00 60.71           C  
ATOM    967  C   HIS   117      39.903  39.218  63.820  1.00 60.41           C  
ATOM    968  O   HIS   117      40.269  38.431  62.958  1.00 60.05           O  
ATOM    969  CB  HIS   117      41.242  40.943  62.639  1.00 60.33           C  
ATOM    970  CG  HIS   117      41.425  42.375  62.226  1.00 62.23           C  
ATOM    971  ND1 HIS   117      40.464  43.092  61.535  1.00 61.62           N  
ATOM    972  CD2 HIS   117      42.476  43.214  62.375  1.00 62.71           C  
ATOM    973  CE1 HIS   117      40.911  44.310  61.292  1.00 62.55           C  
ATOM    974  NE2 HIS   117      42.131  44.410  61.787  1.00 63.71           N  
ATOM    975  N   ILE   118      39.426  38.847  65.023  1.00 60.21           N  
ATOM    976  CA  ILE   118      39.269  37.410  65.396  1.00 59.96           C  
ATOM    977  C   ILE   118      37.957  37.150  66.138  1.00 59.73           C  
ATOM    978  O   ILE   118      37.735  37.670  67.213  1.00 59.45           O  
ATOM    979  CB  ILE   118      40.476  36.841  66.252  1.00 60.60           C  
ATOM    980  CG1 ILE   118      41.818  37.029  65.538  1.00 59.99           C  
ATOM    981  CG2 ILE   118      40.294  35.302  66.526  1.00 60.37           C  
ATOM    982  CD1 ILE   118      43.051  36.832  66.477  1.00 59.96           C  
ATOM    983  N   PRO   119      37.076  36.328  65.576  1.00 59.63           N  
ATOM    984  CA  PRO   119      37.199  35.472  64.393  1.00 60.42           C  
ATOM    985  C   PRO   119      37.065  36.229  63.055  1.00 61.73           C  
ATOM    986  O   PRO   119      37.340  35.635  62.013  1.00 62.71           O  
ATOM    987  CB  PRO   119      36.018  34.497  64.547  1.00 59.89           C  
ATOM    988  CG  PRO   119      34.937  35.379  65.254  1.00 58.78           C  
ATOM    989  CD  PRO   119      35.720  36.306  66.159  1.00 59.32           C  
ATOM    990  N   PHE   120      36.657  37.504  63.051  1.00 61.12           N  
ATOM    991  CA  PHE   120      36.338  38.119  61.762  1.00 61.12           C  
ATOM    992  C   PHE   120      37.054  39.400  61.460  1.00 59.48           C  
ATOM    993  O   PHE   120      37.082  40.301  62.261  1.00 58.42           O  
ATOM    994  CB  PHE   120      34.828  38.341  61.622  1.00 62.74           C  
ATOM    995  CG  PHE   120      34.035  37.086  61.735  1.00 64.36           C  
ATOM    996  CD1 PHE   120      34.295  36.006  60.866  1.00 70.01           C  
ATOM    997  CD2 PHE   120      33.064  36.952  62.726  1.00 65.69           C  
ATOM    998  CE1 PHE   120      33.561  34.780  60.953  1.00 69.09           C  
ATOM    999  CE2 PHE   120      32.304  35.779  62.819  1.00 66.11           C  
ATOM   1000  CZ  PHE   120      32.553  34.681  61.937  1.00 66.98           C  
ATOM   1001  N   VAL   121      37.599  39.469  60.256  1.00 58.64           N  
ATOM   1002  CA  VAL   121      38.232  40.683  59.767  1.00 58.37           C  
ATOM   1003  C   VAL   121      37.274  41.873  59.847  1.00 56.99           C  
ATOM   1004  O   VAL   121      36.136  41.809  59.367  1.00 55.51           O  
ATOM   1005  CB  VAL   121      38.725  40.438  58.336  1.00 59.00           C  
ATOM   1006  CG1 VAL   121      39.244  41.673  57.723  1.00 59.59           C  
ATOM   1007  CG2 VAL   121      39.812  39.386  58.387  1.00 60.30           C  
ATOM   1008  N   GLY   122      37.746  42.924  60.514  1.00 56.40           N  
ATOM   1009  CA  GLY   122      37.050  44.197  60.644  1.00 55.08           C  
ATOM   1010  C   GLY   122      36.289  44.261  61.944  1.00 55.39           C  
ATOM   1011  O   GLY   122      35.644  45.275  62.246  1.00 54.99           O  
ATOM   1012  N   GLY   123      36.351  43.178  62.720  1.00 55.30           N  
ATOM   1013  CA  GLY   123      35.632  43.117  63.990  1.00 56.21           C  
ATOM   1014  C   GLY   123      36.539  43.368  65.186  1.00 57.60           C  
ATOM   1015  O   GLY   123      37.764  43.195  65.105  1.00 58.87           O  
ATOM   1016  N   GLY   124      35.937  43.769  66.299  1.00 57.60           N  
ATOM   1017  CA  GLY   124      36.615  43.964  67.568  1.00 56.76           C  
ATOM   1018  C   GLY   124      35.654  43.511  68.645  1.00 57.59           C  
ATOM   1019  O   GLY   124      34.438  43.674  68.502  1.00 58.68           O  
ATOM   1020  N   THR   125      36.195  42.917  69.702  1.00 57.57           N  
ATOM   1021  CA  THR   125      35.421  42.333  70.759  1.00 58.77           C  
ATOM   1022  C   THR   125      36.159  42.557  72.087  1.00 59.95           C  
ATOM   1023  O   THR   125      37.404  42.665  72.108  1.00 61.11           O  
ATOM   1024  CB  THR   125      35.226  40.815  70.555  1.00 58.50           C  
ATOM   1025  OG1 THR   125      36.504  40.198  70.631  1.00 60.10           O  
ATOM   1026  CG2 THR   125      34.581  40.477  69.179  1.00 57.20           C  
ATOM   1027  N   ILE   126      35.392  42.648  73.174  1.00 59.74           N  
ATOM   1028  CA  ILE   126      35.925  42.817  74.500  1.00 60.47           C  
ATOM   1029  C   ILE   126      35.014  42.026  75.389  1.00 60.96           C  
ATOM   1030  O   ILE   126      33.801  42.116  75.250  1.00 60.86           O  
ATOM   1031  CB  ILE   126      35.861  44.292  74.994  1.00 60.70           C  
ATOM   1032  CG1 ILE   126      36.457  45.265  73.965  1.00 60.18           C  
ATOM   1033  CG2 ILE   126      36.660  44.428  76.323  1.00 61.21           C  
ATOM   1034  CD1 ILE   126      36.173  46.739  74.252  1.00 60.30           C  
ATOM   1035  N   CYS   127      35.571  41.266  76.320  1.00 61.17           N  
ATOM   1036  CA  CYS   127      34.720  40.550  77.246  1.00 61.73           C  
ATOM   1037  C   CYS   127      35.336  40.353  78.631  1.00 60.76           C  
ATOM   1038  O   CYS   127      36.552  40.554  78.825  1.00 61.34           O  
ATOM   1039  CB  CYS   127      34.283  39.220  76.645  1.00 62.64           C  
ATOM   1040  SG  CYS   127      35.571  38.057  76.611  1.00 69.38           S  
ATOM   1041  N   VAL   128      34.479  39.997  79.585  1.00 58.72           N  
ATOM   1042  CA  VAL   128      34.880  39.777  80.954  1.00 57.06           C  
ATOM   1043  C   VAL   128      34.217  38.503  81.459  1.00 57.11           C  
ATOM   1044  O   VAL   128      33.236  38.000  80.900  1.00 56.65           O  
ATOM   1045  CB  VAL   128      34.464  40.968  81.850  1.00 57.55           C  
ATOM   1046  CG1 VAL   128      35.306  42.205  81.547  1.00 55.59           C  
ATOM   1047  CG2 VAL   128      32.963  41.291  81.663  1.00 56.91           C  
ATOM   1048  N   LEU   129      34.762  37.965  82.520  1.00 57.32           N  
ATOM   1049  CA  LEU   129      34.166  36.828  83.172  1.00 58.26           C  
ATOM   1050  C   LEU   129      33.140  37.298  84.224  1.00 58.72           C  
ATOM   1051  O   LEU   129      33.452  38.103  85.104  1.00 58.69           O  
ATOM   1052  CB  LEU   129      35.297  36.031  83.830  1.00 58.55           C  
ATOM   1053  CG  LEU   129      35.015  34.628  84.359  1.00 60.42           C  
ATOM   1054  CD1 LEU   129      34.662  33.655  83.226  1.00 57.69           C  
ATOM   1055  CD2 LEU   129      36.257  34.149  85.121  1.00 58.78           C  
ATOM   1056  N   LEU   130      31.924  36.779  84.156  1.00 59.63           N  
ATOM   1057  CA  LEU   130      30.970  37.026  85.231  1.00 61.00           C  
ATOM   1058  C   LEU   130      31.373  36.302  86.514  1.00 62.52           C  
ATOM   1059  O   LEU   130      32.068  35.286  86.451  1.00 63.24           O  
ATOM   1060  CB  LEU   130      29.555  36.661  84.806  1.00 60.61           C  
ATOM   1061  CG  LEU   130      29.064  37.484  83.618  1.00 58.70           C  
ATOM   1062  CD1 LEU   130      27.610  37.233  83.478  1.00 57.62           C  
ATOM   1063  CD2 LEU   130      29.312  38.951  83.901  1.00 58.50           C  
ATOM   1064  N   PRO   131      30.957  36.833  87.684  1.00 63.60           N  
ATOM   1065  CA  PRO   131      31.330  36.289  88.998  1.00 64.67           C  
ATOM   1066  C   PRO   131      30.677  34.948  89.331  1.00 65.20           C  
ATOM   1067  O   PRO   131      31.135  34.235  90.229  1.00 65.42           O  
ATOM   1068  CB  PRO   131      30.763  37.326  89.982  1.00 64.22           C  
ATOM   1069  CG  PRO   131      30.370  38.477  89.184  1.00 63.35           C  
ATOM   1070  CD  PRO   131      30.083  38.008  87.828  1.00 63.62           C  
ATOM   1071  N   MET   132      29.571  34.647  88.672  1.00 64.99           N  
ATOM   1072  CA  MET   132      28.877  33.427  88.993  1.00 65.15           C  
ATOM   1073  C   MET   132      28.979  32.403  87.850  1.00 64.14           C  
ATOM   1074  O   MET   132      29.414  32.717  86.758  1.00 64.03           O  
ATOM   1075  CB  MET   132      27.415  33.726  89.407  1.00 65.70           C  
ATOM   1076  CG  MET   132      26.390  33.794  88.263  1.00 67.04           C  
ATOM   1077  SD  MET   132      26.750  35.218  87.004  0.45 71.81          SE  
ATOM   1078  CE  MET   132      26.107  36.639  88.129  1.00 67.04           C  
ATOM   1079  N   THR   133      28.592  31.168  88.142  1.00 63.08           N  
ATOM   1080  CA  THR   133      28.539  30.109  87.173  1.00 61.87           C  
ATOM   1081  C   THR   133      27.079  29.821  86.836  1.00 62.29           C  
ATOM   1082  O   THR   133      26.172  30.146  87.590  1.00 62.69           O  
ATOM   1083  CB  THR   133      29.236  28.832  87.733  1.00 62.07           C  
ATOM   1084  OG1 THR   133      28.599  28.425  88.955  1.00 59.30           O  
ATOM   1085  CG2 THR   133      30.761  29.080  87.987  1.00 60.89           C  
ATOM   1086  N   ILE   134      26.850  29.216  85.690  1.00 63.11           N  
ATOM   1087  CA  ILE   134      25.523  28.799  85.289  1.00 64.44           C  
ATOM   1088  C   ILE   134      25.672  27.330  84.911  1.00 65.69           C  
ATOM   1089  O   ILE   134      26.460  26.969  84.044  1.00 66.09           O  
ATOM   1090  CB  ILE   134      24.963  29.704  84.146  1.00 64.14           C  
ATOM   1091  CG1 ILE   134      24.566  31.066  84.723  1.00 63.96           C  
ATOM   1092  CG2 ILE   134      23.773  29.071  83.433  1.00 64.15           C  
ATOM   1093  CD1 ILE   134      24.175  32.136  83.679  1.00 64.32           C  
ATOM   1094  N   GLN   135      24.961  26.482  85.641  1.00 67.44           N  
ATOM   1095  CA  GLN   135      25.018  25.030  85.464  1.00 68.27           C  
ATOM   1096  C   GLN   135      26.423  24.443  85.593  1.00 67.51           C  
ATOM   1097  O   GLN   135      26.840  23.603  84.787  1.00 67.63           O  
ATOM   1098  CB  GLN   135      24.338  24.630  84.142  1.00 69.11           C  
ATOM   1099  CG  GLN   135      22.813  24.426  84.322  1.00 72.21           C  
ATOM   1100  CD  GLN   135      22.075  24.392  83.000  1.00 75.06           C  
ATOM   1101  OE1 GLN   135      22.529  24.981  82.028  1.00 73.98           O  
ATOM   1102  NE2 GLN   135      20.923  23.708  82.961  1.00 76.23           N  
ATOM   1103  N   GLY   136      27.140  24.878  86.627  1.00 66.64           N  
ATOM   1104  CA  GLY   136      28.537  24.478  86.814  1.00 65.45           C  
ATOM   1105  C   GLY   136      29.529  25.084  85.834  1.00 64.78           C  
ATOM   1106  O   GLY   136      30.703  25.058  86.102  1.00 63.55           O  
ATOM   1107  N   GLN   137      29.053  25.633  84.708  1.00 65.31           N  
ATOM   1108  CA  GLN   137      29.912  26.263  83.691  1.00 65.72           C  
ATOM   1109  C   GLN   137      30.233  27.713  84.016  1.00 65.55           C  
ATOM   1110  O   GLN   137      29.358  28.463  84.439  1.00 65.69           O  
ATOM   1111  CB  GLN   137      29.245  26.244  82.302  1.00 66.04           C  
ATOM   1112  CG  GLN   137      29.320  24.909  81.507  1.00 68.78           C  
ATOM   1113  CD  GLN   137      30.440  23.996  82.042  1.00 73.24           C  
ATOM   1114  OE1 GLN   137      31.649  24.242  81.825  1.00 72.76           O  
ATOM   1115  NE2 GLN   137      30.031  22.931  82.759  1.00 73.95           N  
ATOM   1116  N   PRO   138      31.472  28.144  83.744  1.00 65.44           N  
ATOM   1117  CA  PRO   138      31.749  29.578  83.801  1.00 64.98           C  
ATOM   1118  C   PRO   138      31.014  30.351  82.669  1.00 64.36           C  
ATOM   1119  O   PRO   138      30.615  29.763  81.628  1.00 63.62           O  
ATOM   1120  CB  PRO   138      33.259  29.641  83.600  1.00 64.70           C  
ATOM   1121  CG  PRO   138      33.523  28.488  82.688  1.00 65.49           C  
ATOM   1122  CD  PRO   138      32.663  27.395  83.312  1.00 65.94           C  
ATOM   1123  N   VAL   139      30.836  31.652  82.906  1.00 63.46           N  
ATOM   1124  CA  VAL   139      30.024  32.527  82.076  1.00 63.27           C  
ATOM   1125  C   VAL   139      30.742  33.834  81.764  1.00 63.64           C  
ATOM   1126  O   VAL   139      31.472  34.407  82.580  1.00 63.82           O  
ATOM   1127  CB  VAL   139      28.685  32.877  82.751  1.00 63.26           C  
ATOM   1128  CG1 VAL   139      27.728  33.535  81.751  1.00 63.44           C  
ATOM   1129  CG2 VAL   139      28.037  31.626  83.319  1.00 63.48           C  
ATOM   1130  N   THR   140      30.473  34.346  80.581  1.00 63.49           N  
ATOM   1131  CA  THR   140      31.209  35.477  80.094  1.00 62.95           C  
ATOM   1132  C   THR   140      30.239  36.548  79.635  1.00 61.34           C  
ATOM   1133  O   THR   140      29.112  36.253  79.198  1.00 61.41           O  
ATOM   1134  CB  THR   140      32.197  34.962  78.979  1.00 64.09           C  
ATOM   1135  OG1 THR   140      33.315  35.835  78.864  1.00 68.35           O  
ATOM   1136  CG2 THR   140      31.527  34.750  77.625  1.00 61.92           C  
ATOM   1137  N   MET   141      30.651  37.795  79.749  1.00 59.52           N  
ATOM   1138  CA  MET   141      29.865  38.896  79.191  1.00 58.85           C  
ATOM   1139  C   MET   141      30.732  39.738  78.273  1.00 57.63           C  
ATOM   1140  O   MET   141      31.805  40.197  78.662  1.00 56.38           O  
ATOM   1141  CB  MET   141      29.254  39.781  80.295  1.00 58.22           C  
ATOM   1142  CG  MET   141      28.359  40.907  79.768  1.00 57.91           C  
ATOM   1143  SD  MET   141      27.439  41.893  81.189  0.70 63.01          SE  
ATOM   1144  CE  MET   141      29.033  42.290  82.338  1.00 57.79           C  
ATOM   1145  N   GLY   142      30.275  39.939  77.045  1.00 57.51           N  
ATOM   1146  CA  GLY   142      31.113  40.646  76.106  1.00 57.02           C  
ATOM   1147  C   GLY   142      30.376  41.500  75.131  1.00 57.66           C  
ATOM   1148  O   GLY   142      29.155  41.396  75.004  1.00 56.64           O  
ATOM   1149  N   LEU   143      31.124  42.363  74.442  1.00 58.30           N  
ATOM   1150  CA  LEU   143      30.546  43.151  73.380  1.00 58.79           C  
ATOM   1151  C   LEU   143      31.353  43.070  72.088  1.00 58.83           C  
ATOM   1152  O   LEU   143      32.559  42.905  72.119  1.00 58.80           O  
ATOM   1153  CB  LEU   143      30.325  44.594  73.858  1.00 58.35           C  
ATOM   1154  CG  LEU   143      31.521  45.419  74.287  1.00 60.18           C  
ATOM   1155  CD1 LEU   143      32.247  46.006  73.071  1.00 60.49           C  
ATOM   1156  CD2 LEU   143      31.061  46.519  75.206  1.00 59.31           C  
ATOM   1157  N   GLY   144      30.678  43.246  70.953  1.00 58.47           N  
ATOM   1158  CA  GLY   144      31.316  43.101  69.659  1.00 58.24           C  
ATOM   1159  C   GLY   144      30.811  44.138  68.683  1.00 57.94           C  
ATOM   1160  O   GLY   144      29.643  44.516  68.749  1.00 59.01           O  
ATOM   1161  N   GLY   145      31.667  44.613  67.784  1.00 56.39           N  
ATOM   1162  CA  GLY   145      31.205  45.540  66.745  1.00 55.65           C  
ATOM   1163  C   GLY   145      32.309  45.840  65.731  1.00 56.12           C  
ATOM   1164  O   GLY   145      33.329  45.104  65.659  1.00 56.23           O  
ATOM   1165  N   ALA   146      32.124  46.900  64.951  1.00 55.07           N  
ATOM   1166  CA  ALA   146      33.100  47.244  63.899  1.00 55.82           C  
ATOM   1167  C   ALA   146      34.349  47.728  64.624  1.00 56.96           C  
ATOM   1168  O   ALA   146      34.230  48.504  65.612  1.00 57.85           O  
ATOM   1169  CB  ALA   146      32.536  48.330  62.929  1.00 52.69           C  
ATOM   1170  N   LEU   147      35.522  47.281  64.155  1.00 57.64           N  
ATOM   1171  CA  LEU   147      36.793  47.504  64.859  1.00 58.41           C  
ATOM   1172  C   LEU   147      37.061  48.955  65.249  1.00 60.34           C  
ATOM   1173  O   LEU   147      37.500  49.227  66.372  1.00 61.03           O  
ATOM   1174  CB  LEU   147      37.975  46.973  64.060  1.00 58.18           C  
ATOM   1175  CG  LEU   147      39.327  46.949  64.806  1.00 58.18           C  
ATOM   1176  CD1 LEU   147      39.244  46.312  66.199  1.00 57.00           C  
ATOM   1177  CD2 LEU   147      40.342  46.197  64.003  1.00 56.44           C  
ATOM   1178  N   ASP   148      36.797  49.886  64.340  1.00 60.98           N  
ATOM   1179  CA  ASP   148      37.114  51.252  64.594  1.00 62.40           C  
ATOM   1180  C   ASP   148      36.348  51.837  65.779  1.00 62.77           C  
ATOM   1181  O   ASP   148      36.896  52.619  66.589  1.00 62.98           O  
ATOM   1182  CB  ASP   148      36.866  52.052  63.329  1.00 63.29           C  
ATOM   1183  CG  ASP   148      37.999  51.865  62.274  1.00 68.49           C  
ATOM   1184  OD1 ASP   148      39.067  51.262  62.588  1.00 73.90           O  
ATOM   1185  OD2 ASP   148      37.832  52.324  61.114  1.00 73.21           O  
ATOM   1186  N   ARG   149      35.081  51.456  65.871  1.00 62.83           N  
ATOM   1187  CA  ARG   149      34.149  51.928  66.902  1.00 62.86           C  
ATOM   1188  C   ARG   149      34.607  51.373  68.242  1.00 62.96           C  
ATOM   1189  O   ARG   149      34.489  52.006  69.274  1.00 63.58           O  
ATOM   1190  CB  ARG   149      32.755  51.373  66.561  1.00 63.17           C  
ATOM   1191  CG  ARG   149      31.541  52.118  67.062  1.00 62.50           C  
ATOM   1192  CD  ARG   149      30.276  51.705  66.243  1.00 62.20           C  
ATOM   1193  NE  ARG   149      29.948  50.271  66.331  1.00 61.59           N  
ATOM   1194  CZ  ARG   149      29.562  49.509  65.295  1.00 61.95           C  
ATOM   1195  NH1 ARG   149      29.438  50.037  64.069  1.00 61.84           N  
ATOM   1196  NH2 ARG   149      29.264  48.218  65.478  1.00 58.63           N  
ATOM   1197  N   ILE   150      35.138  50.168  68.190  1.00 62.84           N  
ATOM   1198  CA  ILE   150      35.667  49.472  69.337  1.00 62.99           C  
ATOM   1199  C   ILE   150      36.976  50.090  69.814  1.00 63.06           C  
ATOM   1200  O   ILE   150      37.093  50.383  70.996  1.00 63.45           O  
ATOM   1201  CB  ILE   150      35.841  47.972  68.975  1.00 62.89           C  
ATOM   1202  CG1 ILE   150      34.475  47.346  68.679  1.00 61.48           C  
ATOM   1203  CG2 ILE   150      36.605  47.214  70.033  1.00 63.63           C  
ATOM   1204  CD1 ILE   150      33.474  47.515  69.720  1.00 59.06           C  
ATOM   1205  N   LYS   151      37.934  50.291  68.898  1.00 63.12           N  
ATOM   1206  CA  LYS   151      39.214  50.921  69.175  1.00 63.61           C  
ATOM   1207  C   LYS   151      39.027  52.307  69.740  1.00 63.88           C  
ATOM   1208  O   LYS   151      39.786  52.735  70.630  1.00 63.74           O  
ATOM   1209  CB  LYS   151      40.053  51.086  67.903  1.00 64.07           C  
ATOM   1210  CG  LYS   151      40.913  49.913  67.566  1.00 65.79           C  
ATOM   1211  CD  LYS   151      41.621  50.162  66.241  1.00 70.75           C  
ATOM   1212  CE  LYS   151      42.944  49.392  66.164  1.00 71.73           C  
ATOM   1213  NZ  LYS   151      43.159  48.731  64.846  1.00 72.52           N  
ATOM   1214  N   GLN   152      38.044  53.040  69.233  1.00 63.75           N  
ATOM   1215  CA  GLN   152      37.961  54.403  69.698  1.00 64.40           C  
ATOM   1216  C   GLN   152      37.173  54.524  71.007  1.00 64.24           C  
ATOM   1217  O   GLN   152      37.196  55.571  71.640  1.00 64.77           O  
ATOM   1218  CB  GLN   152      37.532  55.387  68.592  1.00 64.61           C  
ATOM   1219  CG  GLN   152      36.062  55.680  68.472  1.00 66.54           C  
ATOM   1220  CD  GLN   152      35.799  57.155  68.274  1.00 69.16           C  
ATOM   1221  OE1 GLN   152      34.813  57.540  67.658  1.00 72.32           O  
ATOM   1222  NE2 GLN   152      36.667  57.994  68.821  1.00 71.10           N  
ATOM   1223  N   ASN   153      36.519  53.453  71.429  1.00 63.29           N  
ATOM   1224  CA  ASN   153      35.780  53.492  72.678  1.00 63.53           C  
ATOM   1225  C   ASN   153      36.295  52.514  73.708  1.00 63.79           C  
ATOM   1226  O   ASN   153      35.654  52.292  74.736  1.00 63.26           O  
ATOM   1227  CB  ASN   153      34.302  53.230  72.425  1.00 63.39           C  
ATOM   1228  CG  ASN   153      33.615  54.397  71.765  1.00 62.56           C  
ATOM   1229  OD1 ASN   153      33.481  55.477  72.343  1.00 61.47           O  
ATOM   1230  ND2 ASN   153      33.163  54.181  70.555  1.00 62.37           N  
ATOM   1231  N   TYR   154      37.468  51.959  73.424  1.00 64.35           N  
ATOM   1232  CA  TYR   154      38.021  50.830  74.154  1.00 64.87           C  
ATOM   1233  C   TYR   154      37.977  51.032  75.673  1.00 64.22           C  
ATOM   1234  O   TYR   154      37.372  50.243  76.398  1.00 65.11           O  
ATOM   1235  CB  TYR   154      39.449  50.536  73.666  1.00 65.57           C  
ATOM   1236  CG  TYR   154      40.047  49.273  74.243  1.00 67.42           C  
ATOM   1237  CD1 TYR   154      39.799  48.022  73.644  1.00 69.26           C  
ATOM   1238  CD2 TYR   154      40.871  49.312  75.385  1.00 67.48           C  
ATOM   1239  CE1 TYR   154      40.352  46.840  74.157  1.00 68.18           C  
ATOM   1240  CE2 TYR   154      41.416  48.131  75.928  1.00 67.78           C  
ATOM   1241  CZ  TYR   154      41.145  46.898  75.308  1.00 69.01           C  
ATOM   1242  OH  TYR   154      41.682  45.711  75.808  1.00 70.29           O  
ATOM   1243  N   ASP   155      38.599  52.082  76.167  1.00 63.00           N  
ATOM   1244  CA  ASP   155      38.617  52.284  77.612  1.00 62.08           C  
ATOM   1245  C   ASP   155      37.215  52.364  78.228  1.00 60.93           C  
ATOM   1246  O   ASP   155      36.955  51.704  79.230  1.00 61.07           O  
ATOM   1247  CB  ASP   155      39.532  53.449  78.004  1.00 62.11           C  
ATOM   1248  CG  ASP   155      41.007  53.150  77.710  1.00 63.68           C  
ATOM   1249  OD1 ASP   155      41.404  51.968  77.752  1.00 63.75           O  
ATOM   1250  OD2 ASP   155      41.782  54.096  77.444  1.00 66.92           O  
ATOM   1251  N   ARG   156      36.325  53.142  77.616  0.50 60.35           N  
ATOM   1253  CA  ARG   156      34.951  53.271  78.098  0.50 59.56           C  
ATOM   1255  C   ARG   156      34.210  51.922  78.085  0.50 59.33           C  
ATOM   1257  O   ARG   156      33.566  51.552  79.074  0.50 59.30           O  
ATOM   1259  CB  ARG   156      34.190  54.348  77.303  0.50 59.35           C  
ATOM   1261  CG  ARG   156      32.709  54.514  77.647  0.50 58.27           C  
ATOM   1263  CD  ARG   156      32.496  54.857  79.123  0.50 58.16           C  
ATOM   1265  NE  ARG   156      31.118  55.273  79.401  0.50 57.16           N  
ATOM   1267  CZ  ARG   156      30.603  55.439  80.621  0.50 53.83           C  
ATOM   1269  NH1 ARG   156      31.333  55.214  81.705  0.50 50.49           N  
ATOM   1271  NH2 ARG   156      29.342  55.825  80.748  0.50 53.96           N  
ATOM   1273  N   TYR   157      34.314  51.183  76.983  1.00 59.03           N  
ATOM   1274  CA  TYR   157      33.636  49.896  76.875  1.00 58.63           C  
ATOM   1275  C   TYR   157      34.152  48.951  77.942  1.00 58.96           C  
ATOM   1276  O   TYR   157      33.389  48.380  78.700  1.00 59.40           O  
ATOM   1277  CB  TYR   157      33.846  49.301  75.510  1.00 59.28           C  
ATOM   1278  CG  TYR   157      33.035  49.900  74.385  1.00 59.29           C  
ATOM   1279  CD1 TYR   157      32.203  51.014  74.566  1.00 57.89           C  
ATOM   1280  CD2 TYR   157      33.158  49.380  73.112  1.00 58.11           C  
ATOM   1281  CE1 TYR   157      31.473  51.549  73.483  1.00 57.38           C  
ATOM   1282  CE2 TYR   157      32.439  49.890  72.052  1.00 58.83           C  
ATOM   1283  CZ  TYR   157      31.606  50.972  72.234  1.00 59.78           C  
ATOM   1284  OH  TYR   157      30.926  51.438  71.110  1.00 62.74           O  
ATOM   1285  N   LEU   158      35.464  48.824  78.045  1.00 59.50           N  
ATOM   1286  CA  LEU   158      36.044  47.981  79.075  1.00 59.86           C  
ATOM   1287  C   LEU   158      35.524  48.348  80.462  1.00 60.16           C  
ATOM   1288  O   LEU   158      35.113  47.467  81.220  1.00 60.78           O  
ATOM   1289  CB  LEU   158      37.562  48.099  79.054  1.00 59.80           C  
ATOM   1290  CG  LEU   158      38.262  47.129  80.008  1.00 60.44           C  
ATOM   1291  CD1 LEU   158      37.858  45.663  79.707  1.00 56.36           C  
ATOM   1292  CD2 LEU   158      39.766  47.334  79.948  1.00 59.85           C  
ATOM   1293  N   GLU   159      35.562  49.641  80.781  1.00 59.61           N  
ATOM   1294  CA  GLU   159      35.161  50.153  82.078  1.00 59.73           C  
ATOM   1295  C   GLU   159      33.742  49.670  82.381  1.00 59.78           C  
ATOM   1296  O   GLU   159      33.489  49.106  83.453  1.00 59.87           O  
ATOM   1297  CB  GLU   159      35.214  51.679  82.056  1.00 59.34           C  
ATOM   1298  CG  GLU   159      35.126  52.335  83.418  1.00 61.40           C  
ATOM   1299  CD  GLU   159      34.879  53.857  83.357  0.70 60.72           C  
ATOM   1300  OE1 GLU   159      34.127  54.327  82.466  0.70 63.42           O  
ATOM   1301  OE2 GLU   159      35.421  54.578  84.219  0.70 58.79           O  
ATOM   1302  N   LEU   160      32.818  49.861  81.427  1.00 59.37           N  
ATOM   1303  CA  LEU   160      31.439  49.367  81.576  1.00 58.56           C  
ATOM   1304  C   LEU   160      31.356  47.856  81.818  1.00 58.29           C  
ATOM   1305  O   LEU   160      30.541  47.413  82.616  1.00 59.51           O  
ATOM   1306  CB  LEU   160      30.567  49.737  80.369  1.00 57.95           C  
ATOM   1307  CG  LEU   160      30.347  51.218  80.103  1.00 58.23           C  
ATOM   1308  CD1 LEU   160      29.702  51.460  78.758  1.00 55.29           C  
ATOM   1309  CD2 LEU   160      29.536  51.881  81.245  1.00 56.98           C  
ATOM   1310  N   LEU   161      32.179  47.053  81.159  1.00 56.85           N  
ATOM   1311  CA  LEU   161      32.064  45.623  81.399  1.00 56.27           C  
ATOM   1312  C   LEU   161      32.491  45.340  82.827  1.00 56.63           C  
ATOM   1313  O   LEU   161      31.767  44.702  83.568  1.00 56.98           O  
ATOM   1314  CB  LEU   161      32.873  44.788  80.391  1.00 55.23           C  
ATOM   1315  CG  LEU   161      32.396  44.835  78.945  1.00 53.59           C  
ATOM   1316  CD1 LEU   161      33.466  44.302  77.999  1.00 52.49           C  
ATOM   1317  CD2 LEU   161      31.076  44.077  78.777  1.00 50.92           C  
ATOM   1318  N   LEU   162      33.655  45.845  83.211  1.00 57.06           N  
ATOM   1319  CA  LEU   162      34.197  45.628  84.544  1.00 58.48           C  
ATOM   1320  C   LEU   162      33.282  46.096  85.667  1.00 59.61           C  
ATOM   1321  O   LEU   162      33.264  45.501  86.759  1.00 60.23           O  
ATOM   1322  CB  LEU   162      35.574  46.304  84.700  1.00 58.31           C  
ATOM   1323  CG  LEU   162      36.705  45.644  83.895  1.00 57.84           C  
ATOM   1324  CD1 LEU   162      37.997  46.389  84.102  1.00 58.59           C  
ATOM   1325  CD2 LEU   162      36.901  44.204  84.266  1.00 56.12           C  
ATOM   1326  N   ASN   163      32.542  47.169  85.410  1.00 60.54           N  
ATOM   1327  CA  ASN   163      31.690  47.749  86.439  1.00 62.01           C  
ATOM   1328  C   ASN   163      30.436  46.879  86.527  1.00 62.08           C  
ATOM   1329  O   ASN   163      29.830  46.747  87.593  1.00 61.71           O  
ATOM   1330  CB  ASN   163      31.438  49.239  86.125  1.00 62.45           C  
ATOM   1331  CG  ASN   163      30.150  49.787  86.734  1.00 65.09           C  
ATOM   1332  OD1 ASN   163      30.050  50.022  87.957  1.00 67.46           O  
ATOM   1333  ND2 ASN   163      29.168  50.061  85.862  1.00 65.90           N  
ATOM   1334  N   GLY   164      30.102  46.245  85.397  1.00 62.36           N  
ATOM   1335  CA  GLY   164      28.971  45.325  85.296  1.00 62.20           C  
ATOM   1336  C   GLY   164      29.216  44.094  86.143  1.00 62.33           C  
ATOM   1337  O   GLY   164      28.300  43.587  86.792  1.00 62.50           O  
ATOM   1338  N   VAL   165      30.462  43.636  86.155  1.00 61.66           N  
ATOM   1339  CA  VAL   165      30.900  42.586  87.044  1.00 61.93           C  
ATOM   1340  C   VAL   165      30.706  42.951  88.532  1.00 62.82           C  
ATOM   1341  O   VAL   165      30.158  42.160  89.306  1.00 63.03           O  
ATOM   1342  CB  VAL   165      32.356  42.271  86.742  1.00 61.88           C  
ATOM   1343  CG1 VAL   165      33.024  41.473  87.860  1.00 60.99           C  
ATOM   1344  CG2 VAL   165      32.431  41.557  85.416  1.00 62.26           C  
ATOM   1345  N   GLN   166      31.142  44.149  88.935  1.00 63.51           N  
ATOM   1346  CA  GLN   166      30.938  44.637  90.305  1.00 63.09           C  
ATOM   1347  C   GLN   166      29.471  44.671  90.704  1.00 63.81           C  
ATOM   1348  O   GLN   166      29.126  44.278  91.796  1.00 63.65           O  
ATOM   1349  CB  GLN   166      31.571  46.010  90.467  1.00 62.92           C  
ATOM   1350  CG  GLN   166      33.101  45.969  90.431  1.00 62.83           C  
ATOM   1351  CD  GLN   166      33.682  44.920  91.377  1.00 62.74           C  
ATOM   1352  OE1 GLN   166      34.438  44.038  90.958  1.00 62.14           O  
ATOM   1353  NE2 GLN   166      33.307  44.994  92.653  1.00 62.51           N  
ATOM   1354  N   GLN   167      28.601  45.105  89.800  1.00 64.97           N  
ATOM   1355  CA  GLN   167      27.177  45.100  90.066  1.00 66.64           C  
ATOM   1356  C   GLN   167      26.588  43.715  90.317  1.00 67.34           C  
ATOM   1357  O   GLN   167      25.554  43.602  90.948  1.00 67.90           O  
ATOM   1358  CB  GLN   167      26.417  45.751  88.924  1.00 66.61           C  
ATOM   1359  CG  GLN   167      26.627  47.230  88.784  1.00 68.71           C  
ATOM   1360  CD  GLN   167      25.849  47.782  87.591  1.00 73.66           C  
ATOM   1361  OE1 GLN   167      24.753  48.315  87.760  1.00 78.39           O  
ATOM   1362  NE2 GLN   167      26.397  47.636  86.379  1.00 73.07           N  
ATOM   1363  N   LEU   168      27.233  42.661  89.833  1.00 68.72           N  
ATOM   1364  CA  LEU   168      26.708  41.304  90.031  1.00 69.87           C  
ATOM   1365  C   LEU   168      27.356  40.466  91.131  1.00 71.95           C  
ATOM   1366  O   LEU   168      26.886  39.378  91.409  1.00 72.69           O  
ATOM   1367  CB  LEU   168      26.700  40.502  88.726  1.00 68.81           C  
ATOM   1368  CG  LEU   168      25.923  41.090  87.550  1.00 66.67           C  
ATOM   1369  CD1 LEU   168      26.472  40.555  86.247  1.00 64.39           C  
ATOM   1370  CD2 LEU   168      24.420  40.871  87.662  1.00 64.21           C  
ATOM   1371  N   LYS   169      28.415  40.929  91.769  1.00 74.46           N  
ATOM   1372  CA  LYS   169      28.913  40.198  92.949  1.00 77.56           C  
ATOM   1373  C   LYS   169      27.846  39.801  94.033  1.00 78.83           C  
ATOM   1374  O   LYS   169      28.141  38.998  94.938  1.00 79.44           O  
ATOM   1375  CB  LYS   169      30.106  40.933  93.577  1.00 77.52           C  
ATOM   1376  CG  LYS   169      31.403  40.740  92.790  1.00 78.50           C  
ATOM   1377  CD  LYS   169      32.633  41.233  93.555  1.00 78.42           C  
ATOM   1378  CE  LYS   169      33.945  40.723  92.918  1.00 80.07           C  
ATOM   1379  NZ  LYS   169      35.138  40.771  93.875  1.00 79.99           N  
ATOM   1380  N   LYS   170      26.634  40.359  93.952  0.50 79.57           N  
ATOM   1382  CA  LYS   170      25.538  39.973  94.871  0.50 80.11           C  
ATOM   1384  C   LYS   170      24.549  38.959  94.268  0.50 80.39           C  
ATOM   1386  O   LYS   170      23.591  38.551  94.934  0.50 80.15           O  
ATOM   1388  CB  LYS   170      24.781  41.207  95.387  0.50 80.17           C  
ATOM   1390  CG  LYS   170      25.323  41.807  96.689  0.50 80.36           C  
ATOM   1392  CD  LYS   170      25.130  43.323  96.702  0.50 80.64           C  
ATOM   1394  CE  LYS   170      26.132  43.993  95.748  0.50 81.04           C  
ATOM   1396  NZ  LYS   170      25.532  45.067  94.897  0.50 80.73           N  
ATOM   1398  N   SER   171      24.786  38.562  93.015  1.00 80.70           N  
ATOM   1399  CA  SER   171      23.954  37.549  92.335  1.00 81.42           C  
ATOM   1400  C   SER   171      24.465  36.097  92.432  1.00 81.92           C  
ATOM   1401  O   SER   171      25.649  35.814  92.203  1.00 82.04           O  
ATOM   1402  CB  SER   171      23.759  37.931  90.868  1.00 81.24           C  
ATOM   1403  OG  SER   171      23.207  39.226  90.791  1.00 81.58           O  
ATOM   1404  N   ASP   172      23.545  35.186  92.744  1.00 82.34           N  
ATOM   1405  CA  ASP   172      23.861  33.770  92.943  1.00 82.68           C  
ATOM   1406  C   ASP   172      24.277  33.041  91.674  1.00 82.52           C  
ATOM   1407  O   ASP   172      23.873  33.417  90.568  1.00 82.88           O  
ATOM   1408  CB  ASP   172      22.657  33.062  93.559  1.00 82.79           C  
ATOM   1409  CG  ASP   172      22.438  33.458  95.000  1.00 84.58           C  
ATOM   1410  OD1 ASP   172      23.450  33.670  95.718  1.00 85.73           O  
ATOM   1411  OD2 ASP   172      21.258  33.563  95.417  1.00 86.61           O  
ATOM   1412  N   SER   173      25.096  32.003  91.843  1.00 82.19           N  
ATOM   1413  CA  SER   173      25.301  31.003  90.800  1.00 81.94           C  
ATOM   1414  C   SER   173      24.071  30.069  90.794  1.00 81.85           C  
ATOM   1415  O   SER   173      23.403  29.904  91.826  1.00 81.43           O  
ATOM   1416  CB  SER   173      26.592  30.199  91.050  1.00 81.85           C  
ATOM   1417  OG  SER   173      27.686  31.033  91.420  1.00 81.39           O  
ATOM   1418  N   PHE   174      23.758  29.470  89.644  1.00 81.81           N  
ATOM   1419  CA  PHE   174      22.619  28.543  89.587  1.00 81.63           C  
ATOM   1420  C   PHE   174      22.810  27.343  88.654  1.00 81.91           C  
ATOM   1421  O   PHE   174      23.540  27.415  87.661  1.00 81.37           O  
ATOM   1422  CB  PHE   174      21.292  29.292  89.303  1.00 81.50           C  
ATOM   1423  CG  PHE   174      21.210  29.948  87.929  1.00 79.93           C  
ATOM   1424  CD1 PHE   174      20.686  29.252  86.839  1.00 78.93           C  
ATOM   1425  CD2 PHE   174      21.613  31.277  87.746  1.00 78.89           C  
ATOM   1426  CE1 PHE   174      20.590  29.866  85.571  1.00 79.10           C  
ATOM   1427  CE2 PHE   174      21.518  31.899  86.488  1.00 78.38           C  
ATOM   1428  CZ  PHE   174      21.009  31.192  85.402  1.00 79.22           C  
ATOM   1429  N   HIS   175      22.150  26.239  89.005  1.00 82.82           N  
ATOM   1430  CA  HIS   175      22.171  25.024  88.184  1.00 83.73           C  
ATOM   1431  C   HIS   175      20.784  24.647  87.647  1.00 83.73           C  
ATOM   1432  O   HIS   175      20.188  23.692  88.128  1.00 83.82           O  
ATOM   1433  CB  HIS   175      22.792  23.846  88.952  1.00 83.68           C  
ATOM   1434  CG  HIS   175      23.642  22.961  88.092  1.00 85.07           C  
ATOM   1435  ND1 HIS   175      25.007  22.846  88.258  1.00 86.20           N  
ATOM   1436  CD2 HIS   175      23.328  22.187  87.023  1.00 86.70           C  
ATOM   1437  CE1 HIS   175      25.491  22.015  87.347  1.00 86.84           C  
ATOM   1438  NE2 HIS   175      24.495  21.607  86.580  1.00 86.55           N  
ATOM   1439  N   GLN   176      20.311  25.384  86.631  1.00 84.15           N  
ATOM   1440  CA  GLN   176      18.948  25.260  86.075  1.00 83.95           C  
ATOM   1441  C   GLN   176      18.909  25.379  84.553  1.00 84.23           C  
ATOM   1442  O   GLN   176      17.994  24.871  83.896  1.00 84.64           O  
ATOM   1443  CB  GLN   176      18.045  26.337  86.670  1.00 83.77           C  
ATOM   1444  CG  GLN   176      16.990  25.824  87.634  1.00 83.19           C  
ATOM   1445  CD  GLN   176      17.544  25.260  88.942  1.00 82.37           C  
ATOM   1446  OE1 GLN   176      18.293  25.931  89.668  1.00 82.87           O  
ATOM   1447  NE2 GLN   176      17.149  24.024  89.261  1.00 80.86           N  
END
