
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  111 ( 1734),  selected  111 , name 2dgy_A
# Molecule2: number of CA atoms  103 (  801),  selected  103 , name T0409.pdb
# PARAMETERS: 2dgy_A.T0409.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    10_A      Y       1           -
LGA    S    11_A      R       2           -
LGA    -       -      G       3           -
LGA    -       -      P       4           -
LGA    -       -      E       5           -
LGA    -       -      A       6           -
LGA    S    12_A      F       7          4.841
LGA    G    13_A      L       8           #
LGA    -       -      K       9           -
LGA    -       -      L      10           -
LGA    -       -      P      11           -
LGA    -       -      K      12           -
LGA    -       -      D      13           -
LGA    -       -      L      14           -
LGA    -       -      K      15           -
LGA    -       -      D      16           -
LGA    -       -      R      17           -
LGA    -       -      E      18           -
LGA    -       -      A      19           -
LGA    -       -      L      20           -
LGA    -       -      Q      21           -
LGA    -       -      D      22           -
LGA    -       -      I      23           -
LGA    -       -      M      24           -
LGA    S    14_A      Q      25           #
LGA    -       -      D      26           -
LGA    S    15_A      I      27          4.911
LGA    -       -      G      28           -
LGA    G    16_A      N      29          5.392
LGA    E    17_A      -       -           -
LGA    H    18_A      -       -           -
LGA    I    19_A      -       -           -
LGA    V    20_A      -       -           -
LGA    P    21_A      S      30          2.741
LGA    S    22_A      D      31          2.709
LGA    N    23_A      -       -           -
LGA    Q    24_A      D      32          2.730
LGA    Q    25_A      I      33          2.239
LGA    Q    26_A      L      34          1.442
LGA    I    27_A      A      35          1.324
LGA    V    28_A      A      36          1.177
LGA    R    29_A      V      37          1.208
LGA    V    30_A      V      38          0.919
LGA    L    31_A      L      39          0.835
LGA    R    32_A      S      40          1.172
LGA    T    33_A      A      41          1.983
LGA    P    34_A      -       -           -
LGA    G    35_A      T      42          1.945
LGA    N    36_A      P      43          3.182
LGA    N    37_A      G      44          2.802
LGA    L    38_A      A      45          1.953
LGA    H    39_A      V      46          0.530
LGA    E    40_A      E      47          0.413
LGA    V    41_A      A      48          0.700
LGA    E    42_A      F      49          1.155
LGA    T    43_A      R      50          1.483
LGA    A    44_A      K      51          1.016
LGA    Q    45_A      N      52          1.669
LGA    G    46_A      G      53          1.044
LGA    Q    47_A      E      54          0.684
LGA    R    48_A      T      55          0.986
LGA    F    49_A      I      56          1.519
LGA    L    50_A      R      57          0.605
LGA    V    51_A      I      58          1.436
LGA    S    52_A      T      59          3.151
LGA    -       -      G      60           -
LGA    -       -      D      61           -
LGA    M    53_A      G      62          4.098
LGA    P    54_A      L      63          3.857
LGA    S    55_A      K      64          2.534
LGA    K    56_A      A      65          3.656
LGA    Y    57_A      A      66          3.672
LGA    R    58_A      H      67          3.335
LGA    K    59_A      R      68          2.331
LGA    N    60_A      F      69          3.872
LGA    I    61_A      L      70          4.413
LGA    -       -      S      71           -
LGA    -       -      N      72           -
LGA    -       -      D      73           -
LGA    -       -      P      74           -
LGA    -       -      K      75           -
LGA    -       -      I      76           -
LGA    -       -      G      77           -
LGA    -       -      E      78           -
LGA    -       -      K      79           -
LGA    W    62_A      R      80          0.657
LGA    I    63_A      I      81          0.828
LGA    K    64_A      R      82          1.949
LGA    R    65_A      P      83          1.470
LGA    G    66_A      G      84          1.991
LGA    D    67_A      A      85          1.710
LGA    F    68_A      L      86          1.675
LGA    L    69_A      I      87          1.053
LGA    I    70_A      R      88          1.033
LGA    V    71_A      V      89          0.717
LGA    D    72_A      K      90          0.912
LGA    P    73_A      K      91          0.574
LGA    I    74_A      T      92          1.959
LGA    E    75_A      E      93          2.955
LGA    E    76_A      K      94          3.372
LGA    G    77_A      G      95           #
LGA    E    78_A      -       -           -
LGA    K    79_A      -       -           -
LGA    V    80_A      -       -           -
LGA    K    81_A      S      96          3.320
LGA    A    82_A      W      97          0.495
LGA    E    83_A      Q      98          0.588
LGA    I    84_A      I      99          0.303
LGA    S    85_A      V     100          0.207
LGA    F    86_A      Q     101          2.497
LGA    V    87_A      L     102           #
LGA    L    88_A      -       -           -
LGA    C    89_A      -       -           -
LGA    K    90_A      -       -           -
LGA    D    91_A      -       -           -
LGA    H    92_A      P     103           #
LGA    V    93_A      -       -           -
LGA    R    94_A      -       -           -
LGA    S    95_A      -       -           -
LGA    L    96_A      -       -           -
LGA    Q    97_A      -       -           -
LGA    K    98_A      -       -           -
LGA    E    99_A      -       -           -
LGA    G   100_A      -       -           -
LGA    F   101_A      -       -           -
LGA    W   102_A      -       -           -
LGA    P   103_A      -       -           -
LGA    E   104_A      -       -           -
LGA    A   105_A      -       -           -
LGA    F   106_A      -       -           -
LGA    S   107_A      -       -           -
LGA    E   108_A      -       -           -
LGA    V   109_A      -       -           -
LGA    A   110_A      -       -           -
LGA    E   111_A      -       -           -
LGA    K   112_A      -       -           -
LGA    H   113_A      -       -           -
LGA    N   114_A      -       -           -
LGA    S   115_A      -       -           -
LGA    G   116_A      -       -           -
LGA    P   117_A      -       -           -
LGA    S   118_A      -       -           -
LGA    S   119_A      -       -           -
LGA    G   120_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  111  103    5.0     63    2.35    14.29     49.359     2.575

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.656420 * X  +  -0.645435 * Y  +  -0.390546 * Z  +  10.916929
  Y_new =   0.612548 * X  +  -0.153835 * Y  +  -0.775319 * Z  +   4.385790
  Z_new =   0.440339 * X  +  -0.748163 * Y  +   0.496340 * Z  +  15.187520 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.985050    2.156542  [ DEG:   -56.4392    123.5608 ]
  Theta =  -0.455976   -2.685617  [ DEG:   -26.1255   -153.8745 ]
  Phi   =   2.390754   -0.750839  [ DEG:   136.9801    -43.0199 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2dgy_A                                        
REMARK     2: T0409.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2dgy_A.T0409.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  111  103   5.0   63   2.35   14.29  49.359
REMARK  ---------------------------------------------------------- 
MOLECULE 2dgy_A
HEADER    TRANSLATION                             16-MAR-06   2DGY              
TITLE     SOLUTION STRUCTURE OF THE EUKARYOTIC INITIATION FACTOR 1A             
TITLE    2 IN MGC11102 PROTEIN                                                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MGC11102 PROTEIN;                                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: EUKARYOTIC INITIATION FACTOR 1A;                           
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: MGC11102;                                                      
SOURCE   5 EXPRESSION_SYSTEM: CELL FREE SYNTHESIS;                              
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: P050822-23;                               
SOURCE   8 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    EIF-1A, STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT ON              
KEYWDS   2 PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN                    
KEYWDS   3 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                      
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    C.ABE,Y.MUTO,M.INOUE,T.KIGAWA,T.TERADA,M.SHIROUZU,                    
AUTHOR   2 S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE           
AUTHOR   3 (RSGI)                                                               
REVDAT   1   16-SEP-06 2DGY    0                                                
JRNL        AUTH   C.ABE,Y.MUTO,M.INOUE,T.KIGAWA,T.TERADA,M.SHIROUZU,           
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF THE EUKARYOTIC INITIATION              
JRNL        TITL 2 FACTOR 1A IN MGC11102 PROTEIN                                
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2DGY A   17   114  UNP    Q9BSC1   Q9BSC1_HUMAN    16    114             
SEQRES   1 A  111  GLY SER SER GLY SER SER GLY GLU HIS ILE VAL PRO SER          
SEQRES   2 A  111  ASN GLN GLN GLN ILE VAL ARG VAL LEU ARG THR PRO GLY          
SEQRES   3 A  111  ASN ASN LEU HIS GLU VAL GLU THR ALA GLN GLY GLN ARG          
SEQRES   4 A  111  PHE LEU VAL SER MET PRO SER LYS TYR ARG LYS ASN ILE          
SEQRES   5 A  111  TRP ILE LYS ARG GLY ASP PHE LEU ILE VAL ASP PRO ILE          
SEQRES   6 A  111  GLU GLU GLY GLU LYS VAL LYS ALA GLU ILE SER PHE VAL          
SEQRES   7 A  111  LEU CYS LYS ASP HIS VAL ARG SER LEU GLN LYS GLU GLY          
SEQRES   8 A  111  PHE TRP PRO GLU ALA PHE SER GLU VAL ALA GLU LYS HIS          
SEQRES   9 A  111  ASN SER GLY PRO SER SER GLY                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A  10       5.303   0.883  41.308  1.00  0.00           N  
ATOM      2  CA  GLY A  10       5.886  -0.385  40.906  1.00  0.00           C  
ATOM      3  C   GLY A  10       5.172  -0.998  39.717  1.00  0.00           C  
ATOM      4  O   GLY A  10       4.454  -0.310  38.992  1.00  0.00           O  
ATOM      5  HA2 GLY A  10       6.922  -0.227  40.647  1.00  0.00           H  
ATOM      6  HA3 GLY A  10       5.832  -1.072  41.737  1.00  0.00           H  
ATOM      7  H1  GLY A  10       4.754   0.932  42.117  1.00  0.00           H  
ATOM      8  N   SER A  11       5.371  -2.298  39.516  1.00  0.00           N  
ATOM      9  CA  SER A  11       4.746  -3.003  38.404  1.00  0.00           C  
ATOM     10  C   SER A  11       4.845  -4.513  38.595  1.00  0.00           C  
ATOM     11  O   SER A  11       5.547  -4.993  39.484  1.00  0.00           O  
ATOM     12  CB  SER A  11       5.403  -2.600  37.082  1.00  0.00           C  
ATOM     13  OG  SER A  11       4.850  -1.395  36.583  1.00  0.00           O  
ATOM     14  H   SER A  11       5.955  -2.792  40.128  1.00  0.00           H  
ATOM     15  HA  SER A  11       3.703  -2.723  38.377  1.00  0.00           H  
ATOM     16  HB2 SER A  11       6.462  -2.460  37.238  1.00  0.00           H  
ATOM     17  HB3 SER A  11       5.249  -3.383  36.354  1.00  0.00           H  
ATOM     18  HG  SER A  11       4.924  -0.708  37.251  1.00  0.00           H  
ATOM     19  N   SER A  12       4.134  -5.258  37.753  1.00  0.00           N  
ATOM     20  CA  SER A  12       4.137  -6.714  37.830  1.00  0.00           C  
ATOM     21  C   SER A  12       5.151  -7.307  36.857  1.00  0.00           C  
ATOM     22  O   SER A  12       5.504  -6.686  35.855  1.00  0.00           O  
ATOM     23  CB  SER A  12       2.742  -7.265  37.530  1.00  0.00           C  
ATOM     24  OG  SER A  12       1.875  -7.090  38.638  1.00  0.00           O  
ATOM     25  H   SER A  12       3.592  -4.816  37.065  1.00  0.00           H  
ATOM     26  HA  SER A  12       4.416  -6.992  38.835  1.00  0.00           H  
ATOM     27  HB2 SER A  12       2.328  -6.746  36.679  1.00  0.00           H  
ATOM     28  HB3 SER A  12       2.815  -8.320  37.307  1.00  0.00           H  
ATOM     29  HG  SER A  12       2.389  -7.079  39.448  1.00  0.00           H  
ATOM     30  N   GLY A  13       5.615  -8.516  37.159  1.00  0.00           N  
ATOM     31  CA  GLY A  13       6.584  -9.173  36.302  1.00  0.00           C  
ATOM     32  C   GLY A  13       6.291  -8.967  34.830  1.00  0.00           C  
ATOM     33  O   GLY A  13       5.410  -9.618  34.269  1.00  0.00           O  
ATOM     34  H   GLY A  13       5.298  -8.963  37.972  1.00  0.00           H  
ATOM     35  HA2 GLY A  13       7.567  -8.783  36.521  1.00  0.00           H  
ATOM     36  HA3 GLY A  13       6.574 -10.233  36.514  1.00  0.00           H  
ATOM     37  N   SER A  14       7.029  -8.058  34.203  1.00  0.00           N  
ATOM     38  CA  SER A  14       6.840  -7.763  32.787  1.00  0.00           C  
ATOM     39  C   SER A  14       7.552  -8.795  31.917  1.00  0.00           C  
ATOM     40  O   SER A  14       8.558  -9.376  32.322  1.00  0.00           O  
ATOM     41  CB  SER A  14       7.359  -6.361  32.463  1.00  0.00           C  
ATOM     42  OG  SER A  14       6.579  -5.367  33.105  1.00  0.00           O  
ATOM     43  H   SER A  14       7.717  -7.572  34.705  1.00  0.00           H  
ATOM     44  HA  SER A  14       5.781  -7.803  32.579  1.00  0.00           H  
ATOM     45  HB2 SER A  14       8.381  -6.272  32.798  1.00  0.00           H  
ATOM     46  HB3 SER A  14       7.315  -6.202  31.395  1.00  0.00           H  
ATOM     47  HG  SER A  14       5.937  -5.013  32.484  1.00  0.00           H  
ATOM     48  N   SER A  15       7.021  -9.016  30.718  1.00  0.00           N  
ATOM     49  CA  SER A  15       7.602  -9.980  29.792  1.00  0.00           C  
ATOM     50  C   SER A  15       8.729  -9.345  28.983  1.00  0.00           C  
ATOM     51  O   SER A  15       8.617  -8.208  28.528  1.00  0.00           O  
ATOM     52  CB  SER A  15       6.527 -10.525  28.849  1.00  0.00           C  
ATOM     53  OG  SER A  15       5.431 -11.054  29.576  1.00  0.00           O  
ATOM     54  H   SER A  15       6.218  -8.521  30.454  1.00  0.00           H  
ATOM     55  HA  SER A  15       8.005 -10.796  30.372  1.00  0.00           H  
ATOM     56  HB2 SER A  15       6.171  -9.728  28.215  1.00  0.00           H  
ATOM     57  HB3 SER A  15       6.951 -11.309  28.239  1.00  0.00           H  
ATOM     58  HG  SER A  15       4.656 -10.509  29.429  1.00  0.00           H  
ATOM     59  N   GLY A  16       9.816 -10.091  28.809  1.00  0.00           N  
ATOM     60  CA  GLY A  16      10.949  -9.586  28.056  1.00  0.00           C  
ATOM     61  C   GLY A  16      11.891 -10.689  27.614  1.00  0.00           C  
ATOM     62  O   GLY A  16      13.104 -10.583  27.791  1.00  0.00           O  
ATOM     63  H   GLY A  16       9.849 -10.991  29.195  1.00  0.00           H  
ATOM     64  HA2 GLY A  16      10.584  -9.068  27.182  1.00  0.00           H  
ATOM     65  HA3 GLY A  16      11.495  -8.888  28.673  1.00  0.00           H  
ATOM     66  N   GLU A  17      11.331 -11.749  27.042  1.00  0.00           N  
ATOM     67  CA  GLU A  17      12.130 -12.877  26.578  1.00  0.00           C  
ATOM     68  C   GLU A  17      12.928 -12.502  25.332  1.00  0.00           C  
ATOM     69  O   GLU A  17      14.096 -12.869  25.196  1.00  0.00           O  
ATOM     70  CB  GLU A  17      11.231 -14.079  26.278  1.00  0.00           C  
ATOM     71  CG  GLU A  17      10.134 -13.781  25.270  1.00  0.00           C  
ATOM     72  CD  GLU A  17      10.568 -14.040  23.840  1.00  0.00           C  
ATOM     73  OE1 GLU A  17      11.554 -14.781  23.644  1.00  0.00           O  
ATOM     74  OE2 GLU A  17       9.922 -13.502  22.917  1.00  0.00           O  
ATOM     75  H   GLU A  17      10.357 -11.774  26.930  1.00  0.00           H  
ATOM     76  HA  GLU A  17      12.818 -13.141  27.365  1.00  0.00           H  
ATOM     77  HB2 GLU A  17      11.841 -14.881  25.889  1.00  0.00           H  
ATOM     78  HB3 GLU A  17      10.767 -14.404  27.197  1.00  0.00           H  
ATOM     79  HG2 GLU A  17       9.282 -14.407  25.489  1.00  0.00           H  
ATOM     80  HG3 GLU A  17       9.850 -12.743  25.361  1.00  0.00           H  
ATOM     81  N   HIS A  18      12.290 -11.769  24.425  1.00  0.00           N  
ATOM     82  CA  HIS A  18      12.939 -11.344  23.190  1.00  0.00           C  
ATOM     83  C   HIS A  18      12.814  -9.835  23.003  1.00  0.00           C  
ATOM     84  O   HIS A  18      12.096  -9.165  23.746  1.00  0.00           O  
ATOM     85  CB  HIS A  18      12.330 -12.071  21.992  1.00  0.00           C  
ATOM     86  CG  HIS A  18      13.097 -11.877  20.721  1.00  0.00           C  
ATOM     87  ND1 HIS A  18      12.732 -10.963  19.754  1.00  0.00           N  
ATOM     88  CD2 HIS A  18      14.215 -12.483  20.259  1.00  0.00           C  
ATOM     89  CE1 HIS A  18      13.592 -11.017  18.753  1.00  0.00           C  
ATOM     90  NE2 HIS A  18      14.502 -11.932  19.035  1.00  0.00           N  
ATOM     91  H   HIS A  18      11.360 -11.508  24.591  1.00  0.00           H  
ATOM     92  HA  HIS A  18      13.985 -11.599  23.263  1.00  0.00           H  
ATOM     93  HB2 HIS A  18      12.298 -13.130  22.201  1.00  0.00           H  
ATOM     94  HB3 HIS A  18      11.325 -11.710  21.833  1.00  0.00           H  
ATOM     95  HD1 HIS A  18      11.957 -10.364  19.796  1.00  0.00           H  
ATOM     96  HD2 HIS A  18      14.778 -13.260  20.761  1.00  0.00           H  
ATOM     97  HE1 HIS A  18      13.558 -10.415  17.857  1.00  0.00           H  
ATOM     98  HE2 HIS A  18      15.207 -12.234  18.425  1.00  0.00           H  
ATOM     99  N   ILE A  19      13.517  -9.308  22.006  1.00  0.00           N  
ATOM    100  CA  ILE A  19      13.483  -7.878  21.720  1.00  0.00           C  
ATOM    101  C   ILE A  19      12.048  -7.366  21.647  1.00  0.00           C  
ATOM    102  O   ILE A  19      11.356  -7.568  20.648  1.00  0.00           O  
ATOM    103  CB  ILE A  19      14.202  -7.551  20.399  1.00  0.00           C  
ATOM    104  CG1 ILE A  19      15.688  -7.899  20.501  1.00  0.00           C  
ATOM    105  CG2 ILE A  19      14.020  -6.082  20.047  1.00  0.00           C  
ATOM    106  CD1 ILE A  19      16.416  -7.838  19.176  1.00  0.00           C  
ATOM    107  H   ILE A  19      14.070  -9.893  21.449  1.00  0.00           H  
ATOM    108  HA  ILE A  19      13.996  -7.367  22.522  1.00  0.00           H  
ATOM    109  HB  ILE A  19      13.754  -8.143  19.615  1.00  0.00           H  
ATOM    110 HG12 ILE A  19      16.168  -7.207  21.174  1.00  0.00           H  
ATOM    111 HG13 ILE A  19      15.788  -8.903  20.891  1.00  0.00           H  
ATOM    112 HG21 ILE A  19      13.035  -5.932  19.628  1.00  0.00           H  
ATOM    113 HG22 ILE A  19      14.126  -5.482  20.938  1.00  0.00           H  
ATOM    114 HG23 ILE A  19      14.766  -5.789  19.324  1.00  0.00           H  
ATOM    115 HD11 ILE A  19      16.632  -8.841  18.839  1.00  0.00           H  
ATOM    116 HD12 ILE A  19      15.797  -7.338  18.448  1.00  0.00           H  
ATOM    117 HD13 ILE A  19      17.341  -7.293  19.299  1.00  0.00           H  
ATOM    118  N   VAL A  20      11.608  -6.700  22.709  1.00  0.00           N  
ATOM    119  CA  VAL A  20      10.256  -6.156  22.764  1.00  0.00           C  
ATOM    120  C   VAL A  20      10.279  -4.649  22.991  1.00  0.00           C  
ATOM    121  O   VAL A  20      11.075  -4.126  23.771  1.00  0.00           O  
ATOM    122  CB  VAL A  20       9.429  -6.820  23.881  1.00  0.00           C  
ATOM    123  CG1 VAL A  20       8.036  -6.211  23.948  1.00  0.00           C  
ATOM    124  CG2 VAL A  20       9.352  -8.324  23.665  1.00  0.00           C  
ATOM    125  H   VAL A  20      12.206  -6.571  23.475  1.00  0.00           H  
ATOM    126  HA  VAL A  20       9.775  -6.360  21.819  1.00  0.00           H  
ATOM    127  HB  VAL A  20       9.923  -6.638  24.824  1.00  0.00           H  
ATOM    128 HG11 VAL A  20       8.109  -5.137  23.851  1.00  0.00           H  
ATOM    129 HG12 VAL A  20       7.430  -6.606  23.146  1.00  0.00           H  
ATOM    130 HG13 VAL A  20       7.582  -6.455  24.897  1.00  0.00           H  
ATOM    131 HG21 VAL A  20       8.328  -8.651  23.777  1.00  0.00           H  
ATOM    132 HG22 VAL A  20       9.698  -8.563  22.669  1.00  0.00           H  
ATOM    133 HG23 VAL A  20       9.973  -8.825  24.392  1.00  0.00           H  
ATOM    134  N   PRO A  21       9.386  -3.931  22.295  1.00  0.00           N  
ATOM    135  CA  PRO A  21       9.283  -2.473  22.404  1.00  0.00           C  
ATOM    136  C   PRO A  21       9.254  -2.002  23.854  1.00  0.00           C  
ATOM    137  O   PRO A  21       8.393  -2.410  24.633  1.00  0.00           O  
ATOM    138  CB  PRO A  21       7.954  -2.158  21.713  1.00  0.00           C  
ATOM    139  CG  PRO A  21       7.752  -3.280  20.753  1.00  0.00           C  
ATOM    140  CD  PRO A  21       8.407  -4.489  21.347  1.00  0.00           C  
ATOM    141  HA  PRO A  21      10.089  -1.979  21.882  1.00  0.00           H  
ATOM    142  HB2 PRO A  21       7.163  -2.119  22.449  1.00  0.00           H  
ATOM    143  HB3 PRO A  21       8.025  -1.211  21.203  1.00  0.00           H  
ATOM    144  HG2 PRO A  21       6.696  -3.463  20.620  1.00  0.00           H  
ATOM    145  HG3 PRO A  21       8.215  -3.040  19.807  1.00  0.00           H  
ATOM    146  HD2 PRO A  21       7.675  -5.095  21.860  1.00  0.00           H  
ATOM    147  HD3 PRO A  21       8.900  -5.062  20.575  1.00  0.00           H  
ATOM    148  N   SER A  22      10.200  -1.138  24.210  1.00  0.00           N  
ATOM    149  CA  SER A  22      10.284  -0.613  25.568  1.00  0.00           C  
ATOM    150  C   SER A  22       9.103   0.303  25.871  1.00  0.00           C  
ATOM    151  O   SER A  22       8.203   0.466  25.047  1.00  0.00           O  
ATOM    152  CB  SER A  22      11.598   0.148  25.762  1.00  0.00           C  
ATOM    153  OG  SER A  22      11.852   0.382  27.136  1.00  0.00           O  
ATOM    154  H   SER A  22      10.858  -0.849  23.543  1.00  0.00           H  
ATOM    155  HA  SER A  22      10.260  -1.451  26.249  1.00  0.00           H  
ATOM    156  HB2 SER A  22      12.411  -0.431  25.351  1.00  0.00           H  
ATOM    157  HB3 SER A  22      11.539   1.098  25.251  1.00  0.00           H  
ATOM    158  HG  SER A  22      12.335  -0.360  27.504  1.00  0.00           H  
ATOM    159  N   ASN A  23       9.114   0.899  27.058  1.00  0.00           N  
ATOM    160  CA  ASN A  23       8.044   1.800  27.471  1.00  0.00           C  
ATOM    161  C   ASN A  23       8.016   3.050  26.597  1.00  0.00           C  
ATOM    162  O   ASN A  23       6.953   3.491  26.161  1.00  0.00           O  
ATOM    163  CB  ASN A  23       8.219   2.194  28.940  1.00  0.00           C  
ATOM    164  CG  ASN A  23       8.511   1.000  29.827  1.00  0.00           C  
ATOM    165  OD1 ASN A  23       9.659   0.575  29.959  1.00  0.00           O  
ATOM    166  ND2 ASN A  23       7.469   0.452  30.443  1.00  0.00           N  
ATOM    167  H   ASN A  23       9.860   0.731  27.671  1.00  0.00           H  
ATOM    168  HA  ASN A  23       7.107   1.274  27.358  1.00  0.00           H  
ATOM    169  HB2 ASN A  23       9.040   2.890  29.023  1.00  0.00           H  
ATOM    170  HB3 ASN A  23       7.315   2.668  29.289  1.00  0.00           H  
ATOM    171 HD21 ASN A  23       6.583   0.843  30.291  1.00  0.00           H  
ATOM    172 HD22 ASN A  23       7.630  -0.321  31.023  1.00  0.00           H  
ATOM    173  N   GLN A  24       9.192   3.615  26.345  1.00  0.00           N  
ATOM    174  CA  GLN A  24       9.302   4.815  25.524  1.00  0.00           C  
ATOM    175  C   GLN A  24       9.320   4.458  24.041  1.00  0.00           C  
ATOM    176  O   GLN A  24       8.771   5.185  23.213  1.00  0.00           O  
ATOM    177  CB  GLN A  24      10.568   5.594  25.888  1.00  0.00           C  
ATOM    178  CG  GLN A  24      10.367   6.578  27.029  1.00  0.00           C  
ATOM    179  CD  GLN A  24      11.474   7.612  27.109  1.00  0.00           C  
ATOM    180  OE1 GLN A  24      12.509   7.481  26.454  1.00  0.00           O  
ATOM    181  NE2 GLN A  24      11.262   8.646  27.914  1.00  0.00           N  
ATOM    182  H   GLN A  24      10.004   3.217  26.721  1.00  0.00           H  
ATOM    183  HA  GLN A  24       8.440   5.433  25.722  1.00  0.00           H  
ATOM    184  HB2 GLN A  24      11.337   4.894  26.176  1.00  0.00           H  
ATOM    185  HB3 GLN A  24      10.898   6.144  25.020  1.00  0.00           H  
ATOM    186  HG2 GLN A  24       9.428   7.090  26.886  1.00  0.00           H  
ATOM    187  HG3 GLN A  24      10.338   6.030  27.959  1.00  0.00           H  
ATOM    188 HE21 GLN A  24      10.413   8.683  28.405  1.00  0.00           H  
ATOM    189 HE22 GLN A  24      11.960   9.329  27.985  1.00  0.00           H  
ATOM    190  N   GLN A  25       9.955   3.337  23.714  1.00  0.00           N  
ATOM    191  CA  GLN A  25      10.044   2.886  22.331  1.00  0.00           C  
ATOM    192  C   GLN A  25       8.656   2.636  21.748  1.00  0.00           C  
ATOM    193  O   GLN A  25       7.688   2.456  22.486  1.00  0.00           O  
ATOM    194  CB  GLN A  25      10.885   1.611  22.240  1.00  0.00           C  
ATOM    195  CG  GLN A  25      12.372   1.875  22.062  1.00  0.00           C  
ATOM    196  CD  GLN A  25      13.232   0.739  22.579  1.00  0.00           C  
ATOM    197  OE1 GLN A  25      13.620   0.720  23.748  1.00  0.00           O  
ATOM    198  NE2 GLN A  25      13.535  -0.218  21.709  1.00  0.00           N  
ATOM    199  H   GLN A  25      10.373   2.802  24.419  1.00  0.00           H  
ATOM    200  HA  GLN A  25      10.525   3.665  21.758  1.00  0.00           H  
ATOM    201  HB2 GLN A  25      10.749   1.040  23.146  1.00  0.00           H  
ATOM    202  HB3 GLN A  25      10.542   1.027  21.400  1.00  0.00           H  
ATOM    203  HG2 GLN A  25      12.576   2.011  21.010  1.00  0.00           H  
ATOM    204  HG3 GLN A  25      12.631   2.777  22.597  1.00  0.00           H  
ATOM    205 HE21 GLN A  25      13.193  -0.136  20.794  1.00  0.00           H  
ATOM    206 HE22 GLN A  25      14.090  -0.963  22.016  1.00  0.00           H  
ATOM    207  N   GLN A  26       8.570   2.628  20.422  1.00  0.00           N  
ATOM    208  CA  GLN A  26       7.299   2.400  19.742  1.00  0.00           C  
ATOM    209  C   GLN A  26       7.524   1.830  18.346  1.00  0.00           C  
ATOM    210  O   GLN A  26       8.560   2.073  17.725  1.00  0.00           O  
ATOM    211  CB  GLN A  26       6.505   3.704  19.652  1.00  0.00           C  
ATOM    212  CG  GLN A  26       7.114   4.724  18.704  1.00  0.00           C  
ATOM    213  CD  GLN A  26       6.335   6.023  18.665  1.00  0.00           C  
ATOM    214  OE1 GLN A  26       5.424   6.190  17.854  1.00  0.00           O  
ATOM    215  NE2 GLN A  26       6.689   6.954  19.543  1.00  0.00           N  
ATOM    216  H   GLN A  26       9.377   2.777  19.889  1.00  0.00           H  
ATOM    217  HA  GLN A  26       6.736   1.685  20.322  1.00  0.00           H  
ATOM    218  HB2 GLN A  26       5.506   3.480  19.311  1.00  0.00           H  
ATOM    219  HB3 GLN A  26       6.450   4.147  20.636  1.00  0.00           H  
ATOM    220  HG2 GLN A  26       8.124   4.938  19.026  1.00  0.00           H  
ATOM    221  HG3 GLN A  26       7.137   4.305  17.710  1.00  0.00           H  
ATOM    222 HE21 GLN A  26       7.425   6.753  20.159  1.00  0.00           H  
ATOM    223 HE22 GLN A  26       6.202   7.804  19.540  1.00  0.00           H  
ATOM    224  N   ILE A  27       6.549   1.072  17.857  1.00  0.00           N  
ATOM    225  CA  ILE A  27       6.641   0.469  16.533  1.00  0.00           C  
ATOM    226  C   ILE A  27       5.949   1.333  15.486  1.00  0.00           C  
ATOM    227  O   ILE A  27       4.799   1.738  15.660  1.00  0.00           O  
ATOM    228  CB  ILE A  27       6.018  -0.940  16.512  1.00  0.00           C  
ATOM    229  CG1 ILE A  27       6.858  -1.906  17.349  1.00  0.00           C  
ATOM    230  CG2 ILE A  27       5.891  -1.441  15.082  1.00  0.00           C  
ATOM    231  CD1 ILE A  27       6.148  -3.201  17.674  1.00  0.00           C  
ATOM    232  H   ILE A  27       5.748   0.915  18.399  1.00  0.00           H  
ATOM    233  HA  ILE A  27       7.687   0.381  16.279  1.00  0.00           H  
ATOM    234  HB  ILE A  27       5.026  -0.878  16.935  1.00  0.00           H  
ATOM    235 HG12 ILE A  27       7.760  -2.150  16.809  1.00  0.00           H  
ATOM    236 HG13 ILE A  27       7.122  -1.427  18.282  1.00  0.00           H  
ATOM    237 HG21 ILE A  27       5.945  -2.520  15.073  1.00  0.00           H  
ATOM    238 HG22 ILE A  27       4.943  -1.126  14.672  1.00  0.00           H  
ATOM    239 HG23 ILE A  27       6.695  -1.036  14.485  1.00  0.00           H  
ATOM    240 HD11 ILE A  27       6.487  -3.568  18.631  1.00  0.00           H  
ATOM    241 HD12 ILE A  27       5.083  -3.028  17.711  1.00  0.00           H  
ATOM    242 HD13 ILE A  27       6.368  -3.933  16.911  1.00  0.00           H  
ATOM    243  N   VAL A  28       6.656   1.614  14.395  1.00  0.00           N  
ATOM    244  CA  VAL A  28       6.110   2.428  13.317  1.00  0.00           C  
ATOM    245  C   VAL A  28       6.370   1.788  11.959  1.00  0.00           C  
ATOM    246  O   VAL A  28       7.028   0.752  11.866  1.00  0.00           O  
ATOM    247  CB  VAL A  28       6.708   3.847  13.328  1.00  0.00           C  
ATOM    248  CG1 VAL A  28       6.376   4.558  14.630  1.00  0.00           C  
ATOM    249  CG2 VAL A  28       8.213   3.793  13.110  1.00  0.00           C  
ATOM    250  H   VAL A  28       7.568   1.263  14.315  1.00  0.00           H  
ATOM    251  HA  VAL A  28       5.043   2.510  13.468  1.00  0.00           H  
ATOM    252  HB  VAL A  28       6.269   4.408  12.515  1.00  0.00           H  
ATOM    253 HG11 VAL A  28       7.284   4.721  15.194  1.00  0.00           H  
ATOM    254 HG12 VAL A  28       5.910   5.509  14.415  1.00  0.00           H  
ATOM    255 HG13 VAL A  28       5.699   3.949  15.211  1.00  0.00           H  
ATOM    256 HG21 VAL A  28       8.647   3.070  13.784  1.00  0.00           H  
ATOM    257 HG22 VAL A  28       8.419   3.501  12.090  1.00  0.00           H  
ATOM    258 HG23 VAL A  28       8.641   4.766  13.299  1.00  0.00           H  
ATOM    259  N   ARG A  29       5.850   2.413  10.908  1.00  0.00           N  
ATOM    260  CA  ARG A  29       6.025   1.903   9.552  1.00  0.00           C  
ATOM    261  C   ARG A  29       6.679   2.953   8.658  1.00  0.00           C  
ATOM    262  O   ARG A  29       6.286   4.119   8.662  1.00  0.00           O  
ATOM    263  CB  ARG A  29       4.677   1.485   8.964  1.00  0.00           C  
ATOM    264  CG  ARG A  29       4.674   1.403   7.446  1.00  0.00           C  
ATOM    265  CD  ARG A  29       3.602   0.451   6.940  1.00  0.00           C  
ATOM    266  NE  ARG A  29       2.261   0.880   7.331  1.00  0.00           N  
ATOM    267  CZ  ARG A  29       1.147   0.353   6.834  1.00  0.00           C  
ATOM    268  NH1 ARG A  29       1.213  -0.618   5.934  1.00  0.00           N  
ATOM    269  NH2 ARG A  29      -0.036   0.798   7.239  1.00  0.00           N  
ATOM    270  H   ARG A  29       5.334   3.235  11.046  1.00  0.00           H  
ATOM    271  HA  ARG A  29       6.670   1.039   9.604  1.00  0.00           H  
ATOM    272  HB2 ARG A  29       4.413   0.512   9.354  1.00  0.00           H  
ATOM    273  HB3 ARG A  29       3.928   2.201   9.265  1.00  0.00           H  
ATOM    274  HG2 ARG A  29       4.485   2.388   7.042  1.00  0.00           H  
ATOM    275  HG3 ARG A  29       5.640   1.055   7.111  1.00  0.00           H  
ATOM    276  HD2 ARG A  29       3.655   0.408   5.863  1.00  0.00           H  
ATOM    277  HD3 ARG A  29       3.788  -0.530   7.350  1.00  0.00           H  
ATOM    278  HE  ARG A  29       2.190   1.597   7.995  1.00  0.00           H  
ATOM    279 HH11 ARG A  29       2.103  -0.955   5.628  1.00  0.00           H  
ATOM    280 HH12 ARG A  29       0.373  -1.013   5.562  1.00  0.00           H  
ATOM    281 HH21 ARG A  29      -0.089   1.529   7.918  1.00  0.00           H  
ATOM    282 HH22 ARG A  29      -0.872   0.401   6.865  1.00  0.00           H  
ATOM    283  N   VAL A  30       7.680   2.530   7.892  1.00  0.00           N  
ATOM    284  CA  VAL A  30       8.387   3.431   6.992  1.00  0.00           C  
ATOM    285  C   VAL A  30       7.509   3.834   5.813  1.00  0.00           C  
ATOM    286  O   VAL A  30       6.616   3.089   5.408  1.00  0.00           O  
ATOM    287  CB  VAL A  30       9.682   2.790   6.458  1.00  0.00           C  
ATOM    288  CG1 VAL A  30      10.390   3.734   5.499  1.00  0.00           C  
ATOM    289  CG2 VAL A  30      10.598   2.400   7.608  1.00  0.00           C  
ATOM    290  H   VAL A  30       7.947   1.588   7.933  1.00  0.00           H  
ATOM    291  HA  VAL A  30       8.654   4.318   7.549  1.00  0.00           H  
ATOM    292  HB  VAL A  30       9.419   1.893   5.916  1.00  0.00           H  
ATOM    293 HG11 VAL A  30       9.757   3.920   4.644  1.00  0.00           H  
ATOM    294 HG12 VAL A  30      10.602   4.666   6.001  1.00  0.00           H  
ATOM    295 HG13 VAL A  30      11.316   3.285   5.168  1.00  0.00           H  
ATOM    296 HG21 VAL A  30      11.538   2.920   7.510  1.00  0.00           H  
ATOM    297 HG22 VAL A  30      10.133   2.671   8.545  1.00  0.00           H  
ATOM    298 HG23 VAL A  30      10.771   1.335   7.587  1.00  0.00           H  
ATOM    299  N   LEU A  31       7.768   5.016   5.265  1.00  0.00           N  
ATOM    300  CA  LEU A  31       7.000   5.518   4.131  1.00  0.00           C  
ATOM    301  C   LEU A  31       7.923   5.917   2.983  1.00  0.00           C  
ATOM    302  O   LEU A  31       7.720   5.506   1.840  1.00  0.00           O  
ATOM    303  CB  LEU A  31       6.150   6.717   4.557  1.00  0.00           C  
ATOM    304  CG  LEU A  31       5.476   6.610   5.924  1.00  0.00           C  
ATOM    305  CD1 LEU A  31       4.695   7.877   6.236  1.00  0.00           C  
ATOM    306  CD2 LEU A  31       4.564   5.392   5.977  1.00  0.00           C  
ATOM    307  H   LEU A  31       8.492   5.565   5.632  1.00  0.00           H  
ATOM    308  HA  LEU A  31       6.349   4.725   3.795  1.00  0.00           H  
ATOM    309  HB2 LEU A  31       6.788   7.587   4.569  1.00  0.00           H  
ATOM    310  HB3 LEU A  31       5.375   6.851   3.815  1.00  0.00           H  
ATOM    311  HG  LEU A  31       6.237   6.492   6.685  1.00  0.00           H  
ATOM    312 HD11 LEU A  31       4.297   7.818   7.237  1.00  0.00           H  
ATOM    313 HD12 LEU A  31       3.884   7.981   5.531  1.00  0.00           H  
ATOM    314 HD13 LEU A  31       5.351   8.732   6.158  1.00  0.00           H  
ATOM    315 HD21 LEU A  31       3.787   5.557   6.708  1.00  0.00           H  
ATOM    316 HD22 LEU A  31       5.142   4.522   6.254  1.00  0.00           H  
ATOM    317 HD23 LEU A  31       4.118   5.235   5.006  1.00  0.00           H  
ATOM    318  N   ARG A  32       8.937   6.716   3.296  1.00  0.00           N  
ATOM    319  CA  ARG A  32       9.891   7.170   2.291  1.00  0.00           C  
ATOM    320  C   ARG A  32      11.129   7.774   2.949  1.00  0.00           C  
ATOM    321  O   ARG A  32      11.093   8.175   4.112  1.00  0.00           O  
ATOM    322  CB  ARG A  32       9.239   8.198   1.365  1.00  0.00           C  
ATOM    323  CG  ARG A  32       9.865   8.254  -0.019  1.00  0.00           C  
ATOM    324  CD  ARG A  32       9.250   9.359  -0.864  1.00  0.00           C  
ATOM    325  NE  ARG A  32       8.064   8.901  -1.583  1.00  0.00           N  
ATOM    326  CZ  ARG A  32       6.846   8.882  -1.053  1.00  0.00           C  
ATOM    327  NH1 ARG A  32       6.654   9.293   0.193  1.00  0.00           N  
ATOM    328  NH2 ARG A  32       5.815   8.452  -1.771  1.00  0.00           N  
ATOM    329  H   ARG A  32       9.045   7.010   4.225  1.00  0.00           H  
ATOM    330  HA  ARG A  32      10.190   6.312   1.708  1.00  0.00           H  
ATOM    331  HB2 ARG A  32       8.194   7.952   1.252  1.00  0.00           H  
ATOM    332  HB3 ARG A  32       9.326   9.175   1.815  1.00  0.00           H  
ATOM    333  HG2 ARG A  32      10.924   8.442   0.082  1.00  0.00           H  
ATOM    334  HG3 ARG A  32       9.711   7.306  -0.512  1.00  0.00           H  
ATOM    335  HD2 ARG A  32       8.974  10.177  -0.217  1.00  0.00           H  
ATOM    336  HD3 ARG A  32       9.984   9.698  -1.579  1.00  0.00           H  
ATOM    337  HE  ARG A  32       8.182   8.594  -2.505  1.00  0.00           H  
ATOM    338 HH11 ARG A  32       7.428   9.618   0.736  1.00  0.00           H  
ATOM    339 HH12 ARG A  32       5.736   9.278   0.588  1.00  0.00           H  
ATOM    340 HH21 ARG A  32       5.956   8.142  -2.711  1.00  0.00           H  
ATOM    341 HH22 ARG A  32       4.900   8.437  -1.371  1.00  0.00           H  
ATOM    342  N   THR A  33      12.222   7.834   2.197  1.00  0.00           N  
ATOM    343  CA  THR A  33      13.471   8.386   2.706  1.00  0.00           C  
ATOM    344  C   THR A  33      14.067   9.391   1.727  1.00  0.00           C  
ATOM    345  O   THR A  33      14.328   9.082   0.565  1.00  0.00           O  
ATOM    346  CB  THR A  33      14.505   7.279   2.981  1.00  0.00           C  
ATOM    347  OG1 THR A  33      13.885   6.191   3.675  1.00  0.00           O  
ATOM    348  CG2 THR A  33      15.667   7.816   3.803  1.00  0.00           C  
ATOM    349  H   THR A  33      12.188   7.497   1.277  1.00  0.00           H  
ATOM    350  HA  THR A  33      13.257   8.889   3.638  1.00  0.00           H  
ATOM    351  HB  THR A  33      14.887   6.922   2.036  1.00  0.00           H  
ATOM    352  HG1 THR A  33      13.198   6.530   4.254  1.00  0.00           H  
ATOM    353 HG21 THR A  33      15.659   8.895   3.778  1.00  0.00           H  
ATOM    354 HG22 THR A  33      16.597   7.453   3.392  1.00  0.00           H  
ATOM    355 HG23 THR A  33      15.570   7.479   4.825  1.00  0.00           H  
ATOM    356  N   PRO A  34      14.291  10.625   2.206  1.00  0.00           N  
ATOM    357  CA  PRO A  34      14.860  11.700   1.389  1.00  0.00           C  
ATOM    358  C   PRO A  34      16.328  11.458   1.055  1.00  0.00           C  
ATOM    359  O   PRO A  34      16.920  12.181   0.255  1.00  0.00           O  
ATOM    360  CB  PRO A  34      14.711  12.938   2.278  1.00  0.00           C  
ATOM    361  CG  PRO A  34      14.680  12.403   3.669  1.00  0.00           C  
ATOM    362  CD  PRO A  34      14.004  11.064   3.582  1.00  0.00           C  
ATOM    363  HA  PRO A  34      14.303  11.841   0.475  1.00  0.00           H  
ATOM    364  HB2 PRO A  34      15.554  13.597   2.126  1.00  0.00           H  
ATOM    365  HB3 PRO A  34      13.795  13.453   2.032  1.00  0.00           H  
ATOM    366  HG2 PRO A  34      15.686  12.293   4.042  1.00  0.00           H  
ATOM    367  HG3 PRO A  34      14.113  13.068   4.304  1.00  0.00           H  
ATOM    368  HD2 PRO A  34      14.430  10.379   4.302  1.00  0.00           H  
ATOM    369  HD3 PRO A  34      12.940  11.166   3.740  1.00  0.00           H  
ATOM    370  N   GLY A  35      16.911  10.435   1.673  1.00  0.00           N  
ATOM    371  CA  GLY A  35      18.305  10.116   1.427  1.00  0.00           C  
ATOM    372  C   GLY A  35      19.178  10.357   2.643  1.00  0.00           C  
ATOM    373  O   GLY A  35      20.002   9.516   2.999  1.00  0.00           O  
ATOM    374  H   GLY A  35      16.390   9.893   2.302  1.00  0.00           H  
ATOM    375  HA2 GLY A  35      18.381   9.078   1.142  1.00  0.00           H  
ATOM    376  HA3 GLY A  35      18.665  10.730   0.614  1.00  0.00           H  
ATOM    377  N   ASN A  36      18.998  11.509   3.280  1.00  0.00           N  
ATOM    378  CA  ASN A  36      19.778  11.859   4.462  1.00  0.00           C  
ATOM    379  C   ASN A  36      19.719  10.744   5.502  1.00  0.00           C  
ATOM    380  O   ASN A  36      19.153   9.681   5.255  1.00  0.00           O  
ATOM    381  CB  ASN A  36      19.264  13.166   5.070  1.00  0.00           C  
ATOM    382  CG  ASN A  36      19.761  14.387   4.320  1.00  0.00           C  
ATOM    383  OD1 ASN A  36      20.190  14.291   3.170  1.00  0.00           O  
ATOM    384  ND2 ASN A  36      19.705  15.544   4.971  1.00  0.00           N  
ATOM    385  H   ASN A  36      18.325  12.140   2.948  1.00  0.00           H  
ATOM    386  HA  ASN A  36      20.803  11.995   4.154  1.00  0.00           H  
ATOM    387  HB2 ASN A  36      18.184  13.167   5.044  1.00  0.00           H  
ATOM    388  HB3 ASN A  36      19.596  13.236   6.095  1.00  0.00           H  
ATOM    389 HD21 ASN A  36      19.351  15.544   5.884  1.00  0.00           H  
ATOM    390 HD22 ASN A  36      20.019  16.349   4.509  1.00  0.00           H  
ATOM    391  N   ASN A  37      20.310  10.997   6.666  1.00  0.00           N  
ATOM    392  CA  ASN A  37      20.325  10.014   7.744  1.00  0.00           C  
ATOM    393  C   ASN A  37      19.016  10.046   8.527  1.00  0.00           C  
ATOM    394  O   ASN A  37      19.012   9.945   9.754  1.00  0.00           O  
ATOM    395  CB  ASN A  37      21.502  10.277   8.685  1.00  0.00           C  
ATOM    396  CG  ASN A  37      21.472  11.676   9.270  1.00  0.00           C  
ATOM    397  OD1 ASN A  37      20.823  12.573   8.733  1.00  0.00           O  
ATOM    398  ND2 ASN A  37      22.178  11.868  10.379  1.00  0.00           N  
ATOM    399  H   ASN A  37      20.746  11.863   6.802  1.00  0.00           H  
ATOM    400  HA  ASN A  37      20.442   9.037   7.300  1.00  0.00           H  
ATOM    401  HB2 ASN A  37      21.471   9.567   9.498  1.00  0.00           H  
ATOM    402  HB3 ASN A  37      22.426  10.154   8.140  1.00  0.00           H  
ATOM    403 HD21 ASN A  37      22.671  11.108  10.752  1.00  0.00           H  
ATOM    404 HD22 ASN A  37      22.175  12.763  10.779  1.00  0.00           H  
ATOM    405  N   LEU A  38      17.907  10.186   7.809  1.00  0.00           N  
ATOM    406  CA  LEU A  38      16.591  10.230   8.436  1.00  0.00           C  
ATOM    407  C   LEU A  38      15.582   9.403   7.644  1.00  0.00           C  
ATOM    408  O   LEU A  38      15.828   9.041   6.493  1.00  0.00           O  
ATOM    409  CB  LEU A  38      16.106  11.676   8.548  1.00  0.00           C  
ATOM    410  CG  LEU A  38      17.045  12.645   9.266  1.00  0.00           C  
ATOM    411  CD1 LEU A  38      16.575  14.079   9.083  1.00  0.00           C  
ATOM    412  CD2 LEU A  38      17.143  12.298  10.745  1.00  0.00           C  
ATOM    413  H   LEU A  38      17.974  10.261   6.834  1.00  0.00           H  
ATOM    414  HA  LEU A  38      16.681   9.811   9.427  1.00  0.00           H  
ATOM    415  HB2 LEU A  38      15.946  12.050   7.549  1.00  0.00           H  
ATOM    416  HB3 LEU A  38      15.166  11.668   9.082  1.00  0.00           H  
ATOM    417  HG  LEU A  38      18.034  12.562   8.837  1.00  0.00           H  
ATOM    418 HD11 LEU A  38      16.211  14.461  10.026  1.00  0.00           H  
ATOM    419 HD12 LEU A  38      15.779  14.107   8.354  1.00  0.00           H  
ATOM    420 HD13 LEU A  38      17.399  14.689   8.742  1.00  0.00           H  
ATOM    421 HD21 LEU A  38      17.230  13.206  11.323  1.00  0.00           H  
ATOM    422 HD22 LEU A  38      18.014  11.680  10.912  1.00  0.00           H  
ATOM    423 HD23 LEU A  38      16.256  11.761  11.047  1.00  0.00           H  
ATOM    424  N   HIS A  39      14.446   9.109   8.268  1.00  0.00           N  
ATOM    425  CA  HIS A  39      13.398   8.328   7.620  1.00  0.00           C  
ATOM    426  C   HIS A  39      12.022   8.721   8.149  1.00  0.00           C  
ATOM    427  O   HIS A  39      11.853   8.966   9.342  1.00  0.00           O  
ATOM    428  CB  HIS A  39      13.636   6.835   7.841  1.00  0.00           C  
ATOM    429  CG  HIS A  39      14.972   6.363   7.357  1.00  0.00           C  
ATOM    430  ND1 HIS A  39      15.129   5.556   6.249  1.00  0.00           N  
ATOM    431  CD2 HIS A  39      16.218   6.589   7.834  1.00  0.00           C  
ATOM    432  CE1 HIS A  39      16.414   5.307   6.068  1.00  0.00           C  
ATOM    433  NE2 HIS A  39      17.096   5.921   7.018  1.00  0.00           N  
ATOM    434  H   HIS A  39      14.308   9.426   9.184  1.00  0.00           H  
ATOM    435  HA  HIS A  39      13.435   8.537   6.561  1.00  0.00           H  
ATOM    436  HB2 HIS A  39      13.572   6.620   8.897  1.00  0.00           H  
ATOM    437  HB3 HIS A  39      12.875   6.274   7.317  1.00  0.00           H  
ATOM    438  HD1 HIS A  39      14.407   5.216   5.681  1.00  0.00           H  
ATOM    439  HD2 HIS A  39      16.475   7.184   8.700  1.00  0.00           H  
ATOM    440  HE1 HIS A  39      16.835   4.701   5.279  1.00  0.00           H  
ATOM    441  HE2 HIS A  39      18.059   5.833   7.167  1.00  0.00           H  
ATOM    442  N   GLU A  40      11.042   8.778   7.252  1.00  0.00           N  
ATOM    443  CA  GLU A  40       9.682   9.142   7.629  1.00  0.00           C  
ATOM    444  C   GLU A  40       8.847   7.899   7.921  1.00  0.00           C  
ATOM    445  O   GLU A  40       8.755   6.990   7.094  1.00  0.00           O  
ATOM    446  CB  GLU A  40       9.023   9.963   6.519  1.00  0.00           C  
ATOM    447  CG  GLU A  40       7.669  10.535   6.907  1.00  0.00           C  
ATOM    448  CD  GLU A  40       6.973  11.222   5.748  1.00  0.00           C  
ATOM    449  OE1 GLU A  40       7.661  11.918   4.971  1.00  0.00           O  
ATOM    450  OE2 GLU A  40       5.741  11.065   5.618  1.00  0.00           O  
ATOM    451  H   GLU A  40      11.239   8.571   6.314  1.00  0.00           H  
ATOM    452  HA  GLU A  40       9.736   9.743   8.525  1.00  0.00           H  
ATOM    453  HB2 GLU A  40       9.676  10.783   6.259  1.00  0.00           H  
ATOM    454  HB3 GLU A  40       8.889   9.333   5.653  1.00  0.00           H  
ATOM    455  HG2 GLU A  40       7.040   9.729   7.258  1.00  0.00           H  
ATOM    456  HG3 GLU A  40       7.809  11.253   7.701  1.00  0.00           H  
ATOM    457  N   VAL A  41       8.240   7.864   9.104  1.00  0.00           N  
ATOM    458  CA  VAL A  41       7.413   6.733   9.505  1.00  0.00           C  
ATOM    459  C   VAL A  41       6.056   7.200  10.022  1.00  0.00           C  
ATOM    460  O   VAL A  41       5.802   8.400  10.126  1.00  0.00           O  
ATOM    461  CB  VAL A  41       8.103   5.892  10.596  1.00  0.00           C  
ATOM    462  CG1 VAL A  41       9.496   5.478  10.149  1.00  0.00           C  
ATOM    463  CG2 VAL A  41       8.161   6.663  11.906  1.00  0.00           C  
ATOM    464  H   VAL A  41       8.351   8.618   9.720  1.00  0.00           H  
ATOM    465  HA  VAL A  41       7.261   6.106   8.639  1.00  0.00           H  
ATOM    466  HB  VAL A  41       7.519   4.997  10.754  1.00  0.00           H  
ATOM    467 HG11 VAL A  41       9.717   4.492  10.531  1.00  0.00           H  
ATOM    468 HG12 VAL A  41       9.539   5.466   9.070  1.00  0.00           H  
ATOM    469 HG13 VAL A  41      10.221   6.182  10.531  1.00  0.00           H  
ATOM    470 HG21 VAL A  41       9.112   6.485  12.385  1.00  0.00           H  
ATOM    471 HG22 VAL A  41       8.049   7.719  11.707  1.00  0.00           H  
ATOM    472 HG23 VAL A  41       7.363   6.333  12.554  1.00  0.00           H  
ATOM    473  N   GLU A  42       5.190   6.245  10.343  1.00  0.00           N  
ATOM    474  CA  GLU A  42       3.859   6.560  10.848  1.00  0.00           C  
ATOM    475  C   GLU A  42       3.480   5.633  12.000  1.00  0.00           C  
ATOM    476  O   GLU A  42       3.801   4.443  11.987  1.00  0.00           O  
ATOM    477  CB  GLU A  42       2.824   6.446   9.727  1.00  0.00           C  
ATOM    478  CG  GLU A  42       2.342   5.026   9.485  1.00  0.00           C  
ATOM    479  CD  GLU A  42       1.154   4.965   8.544  1.00  0.00           C  
ATOM    480  OE1 GLU A  42       0.038   5.322   8.975  1.00  0.00           O  
ATOM    481  OE2 GLU A  42       1.341   4.561   7.378  1.00  0.00           O  
ATOM    482  H   GLU A  42       5.452   5.307  10.237  1.00  0.00           H  
ATOM    483  HA  GLU A  42       3.873   7.577  11.210  1.00  0.00           H  
ATOM    484  HB2 GLU A  42       1.969   7.056   9.979  1.00  0.00           H  
ATOM    485  HB3 GLU A  42       3.261   6.816   8.812  1.00  0.00           H  
ATOM    486  HG2 GLU A  42       3.150   4.453   9.056  1.00  0.00           H  
ATOM    487  HG3 GLU A  42       2.056   4.590  10.430  1.00  0.00           H  
ATOM    488  N   THR A  43       2.798   6.186  12.997  1.00  0.00           N  
ATOM    489  CA  THR A  43       2.377   5.412  14.158  1.00  0.00           C  
ATOM    490  C   THR A  43       1.034   4.737  13.911  1.00  0.00           C  
ATOM    491  O   THR A  43       0.392   4.966  12.886  1.00  0.00           O  
ATOM    492  CB  THR A  43       2.271   6.297  15.415  1.00  0.00           C  
ATOM    493  OG1 THR A  43       1.069   7.072  15.368  1.00  0.00           O  
ATOM    494  CG2 THR A  43       3.474   7.220  15.530  1.00  0.00           C  
ATOM    495  H   THR A  43       2.573   7.140  12.950  1.00  0.00           H  
ATOM    496  HA  THR A  43       3.123   4.652  14.341  1.00  0.00           H  
ATOM    497  HB  THR A  43       2.244   5.656  16.285  1.00  0.00           H  
ATOM    498  HG1 THR A  43       0.920   7.377  14.469  1.00  0.00           H  
ATOM    499 HG21 THR A  43       3.397   7.800  16.438  1.00  0.00           H  
ATOM    500 HG22 THR A  43       3.499   7.886  14.679  1.00  0.00           H  
ATOM    501 HG23 THR A  43       4.379   6.632  15.553  1.00  0.00           H  
ATOM    502  N   ALA A  44       0.613   3.903  14.856  1.00  0.00           N  
ATOM    503  CA  ALA A  44      -0.657   3.196  14.741  1.00  0.00           C  
ATOM    504  C   ALA A  44      -1.835   4.157  14.869  1.00  0.00           C  
ATOM    505  O   ALA A  44      -2.942   3.857  14.428  1.00  0.00           O  
ATOM    506  CB  ALA A  44      -0.750   2.103  15.796  1.00  0.00           C  
ATOM    507  H   ALA A  44       1.169   3.761  15.650  1.00  0.00           H  
ATOM    508  HA  ALA A  44      -0.691   2.727  13.769  1.00  0.00           H  
ATOM    509  HB1 ALA A  44      -1.129   1.198  15.343  1.00  0.00           H  
ATOM    510  HB2 ALA A  44       0.231   1.917  16.207  1.00  0.00           H  
ATOM    511  HB3 ALA A  44      -1.418   2.419  16.583  1.00  0.00           H  
ATOM    512  N   GLN A  45      -1.584   5.314  15.475  1.00  0.00           N  
ATOM    513  CA  GLN A  45      -2.625   6.318  15.661  1.00  0.00           C  
ATOM    514  C   GLN A  45      -2.655   7.294  14.489  1.00  0.00           C  
ATOM    515  O   GLN A  45      -3.101   8.432  14.628  1.00  0.00           O  
ATOM    516  CB  GLN A  45      -2.402   7.079  16.969  1.00  0.00           C  
ATOM    517  CG  GLN A  45      -2.731   6.265  18.209  1.00  0.00           C  
ATOM    518  CD  GLN A  45      -3.171   7.129  19.375  1.00  0.00           C  
ATOM    519  OE1 GLN A  45      -3.879   8.120  19.195  1.00  0.00           O  
ATOM    520  NE2 GLN A  45      -2.752   6.757  20.579  1.00  0.00           N  
ATOM    521  H   GLN A  45      -0.680   5.496  15.804  1.00  0.00           H  
ATOM    522  HA  GLN A  45      -3.575   5.806  15.710  1.00  0.00           H  
ATOM    523  HB2 GLN A  45      -1.366   7.378  17.025  1.00  0.00           H  
ATOM    524  HB3 GLN A  45      -3.024   7.962  16.969  1.00  0.00           H  
ATOM    525  HG2 GLN A  45      -3.528   5.576  17.972  1.00  0.00           H  
ATOM    526  HG3 GLN A  45      -1.852   5.710  18.503  1.00  0.00           H  
ATOM    527 HE21 GLN A  45      -2.188   5.957  20.646  1.00  0.00           H  
ATOM    528 HE22 GLN A  45      -3.020   7.298  21.350  1.00  0.00           H  
ATOM    529  N   GLY A  46      -2.176   6.841  13.335  1.00  0.00           N  
ATOM    530  CA  GLY A  46      -2.155   7.688  12.157  1.00  0.00           C  
ATOM    531  C   GLY A  46      -1.397   8.981  12.383  1.00  0.00           C  
ATOM    532  O   GLY A  46      -1.977  10.066  12.329  1.00  0.00           O  
ATOM    533  H   GLY A  46      -1.833   5.925  13.283  1.00  0.00           H  
ATOM    534  HA2 GLY A  46      -1.690   7.148  11.347  1.00  0.00           H  
ATOM    535  HA3 GLY A  46      -3.173   7.925  11.880  1.00  0.00           H  
ATOM    536  N   GLN A  47      -0.098   8.866  12.642  1.00  0.00           N  
ATOM    537  CA  GLN A  47       0.739  10.035  12.881  1.00  0.00           C  
ATOM    538  C   GLN A  47       2.049   9.934  12.107  1.00  0.00           C  
ATOM    539  O   GLN A  47       2.924   9.138  12.449  1.00  0.00           O  
ATOM    540  CB  GLN A  47       1.027  10.185  14.375  1.00  0.00           C  
ATOM    541  CG  GLN A  47       1.326  11.615  14.797  1.00  0.00           C  
ATOM    542  CD  GLN A  47       0.180  12.563  14.499  1.00  0.00           C  
ATOM    543  OE1 GLN A  47       0.114  13.157  13.423  1.00  0.00           O  
ATOM    544  NE2 GLN A  47      -0.730  12.710  15.456  1.00  0.00           N  
ATOM    545  H   GLN A  47       0.305   7.974  12.672  1.00  0.00           H  
ATOM    546  HA  GLN A  47       0.199  10.904  12.538  1.00  0.00           H  
ATOM    547  HB2 GLN A  47       0.168   9.841  14.932  1.00  0.00           H  
ATOM    548  HB3 GLN A  47       1.879   9.573  14.629  1.00  0.00           H  
ATOM    549  HG2 GLN A  47       1.519  11.631  15.859  1.00  0.00           H  
ATOM    550  HG3 GLN A  47       2.203  11.956  14.267  1.00  0.00           H  
ATOM    551 HE21 GLN A  47      -0.612  12.205  16.288  1.00  0.00           H  
ATOM    552 HE22 GLN A  47      -1.481  13.316  15.291  1.00  0.00           H  
ATOM    553  N   ARG A  48       2.177  10.744  11.062  1.00  0.00           N  
ATOM    554  CA  ARG A  48       3.380  10.744  10.238  1.00  0.00           C  
ATOM    555  C   ARG A  48       4.457  11.636  10.848  1.00  0.00           C  
ATOM    556  O   ARG A  48       4.165  12.716  11.364  1.00  0.00           O  
ATOM    557  CB  ARG A  48       3.052  11.219   8.820  1.00  0.00           C  
ATOM    558  CG  ARG A  48       1.969  10.400   8.138  1.00  0.00           C  
ATOM    559  CD  ARG A  48       2.156  10.374   6.629  1.00  0.00           C  
ATOM    560  NE  ARG A  48       0.926  10.012   5.932  1.00  0.00           N  
ATOM    561  CZ  ARG A  48      -0.166  10.768   5.927  1.00  0.00           C  
ATOM    562  NH1 ARG A  48      -0.180  11.923   6.580  1.00  0.00           N  
ATOM    563  NH2 ARG A  48      -1.248  10.371   5.268  1.00  0.00           N  
ATOM    564  H   ARG A  48       1.445  11.356  10.837  1.00  0.00           H  
ATOM    565  HA  ARG A  48       3.750   9.732  10.191  1.00  0.00           H  
ATOM    566  HB2 ARG A  48       2.723  12.246   8.864  1.00  0.00           H  
ATOM    567  HB3 ARG A  48       3.948  11.162   8.219  1.00  0.00           H  
ATOM    568  HG2 ARG A  48       2.007   9.386   8.512  1.00  0.00           H  
ATOM    569  HG3 ARG A  48       1.007  10.833   8.366  1.00  0.00           H  
ATOM    570  HD2 ARG A  48       2.469  11.354   6.303  1.00  0.00           H  
ATOM    571  HD3 ARG A  48       2.922   9.652   6.388  1.00  0.00           H  
ATOM    572  HE  ARG A  48       0.914   9.163   5.443  1.00  0.00           H  
ATOM    573 HH11 ARG A  48       0.634  12.225   7.076  1.00  0.00           H  
ATOM    574 HH12 ARG A  48      -1.004  12.491   6.574  1.00  0.00           H  
ATOM    575 HH21 ARG A  48      -1.241   9.502   4.776  1.00  0.00           H  
ATOM    576 HH22 ARG A  48      -2.069  10.941   5.266  1.00  0.00           H  
ATOM    577  N   PHE A  49       5.703  11.178  10.785  1.00  0.00           N  
ATOM    578  CA  PHE A  49       6.823  11.933  11.333  1.00  0.00           C  
ATOM    579  C   PHE A  49       8.149  11.408  10.793  1.00  0.00           C  
ATOM    580  O   PHE A  49       8.181  10.452  10.015  1.00  0.00           O  
ATOM    581  CB  PHE A  49       6.818  11.858  12.862  1.00  0.00           C  
ATOM    582  CG  PHE A  49       7.059  10.475  13.395  1.00  0.00           C  
ATOM    583  CD1 PHE A  49       6.036   9.540  13.421  1.00  0.00           C  
ATOM    584  CD2 PHE A  49       8.307  10.109  13.871  1.00  0.00           C  
ATOM    585  CE1 PHE A  49       6.255   8.267  13.911  1.00  0.00           C  
ATOM    586  CE2 PHE A  49       8.533   8.837  14.362  1.00  0.00           C  
ATOM    587  CZ  PHE A  49       7.505   7.915  14.382  1.00  0.00           C  
ATOM    588  H   PHE A  49       5.872  10.311  10.362  1.00  0.00           H  
ATOM    589  HA  PHE A  49       6.707  12.963  11.031  1.00  0.00           H  
ATOM    590  HB2 PHE A  49       7.592  12.503  13.249  1.00  0.00           H  
ATOM    591  HB3 PHE A  49       5.860  12.195  13.228  1.00  0.00           H  
ATOM    592  HD1 PHE A  49       5.058   9.814  13.053  1.00  0.00           H  
ATOM    593  HD2 PHE A  49       9.113  10.830  13.855  1.00  0.00           H  
ATOM    594  HE1 PHE A  49       5.450   7.548  13.926  1.00  0.00           H  
ATOM    595  HE2 PHE A  49       9.511   8.565  14.729  1.00  0.00           H  
ATOM    596  HZ  PHE A  49       7.678   6.921  14.766  1.00  0.00           H  
ATOM    597  N   LEU A  50       9.242  12.038  11.207  1.00  0.00           N  
ATOM    598  CA  LEU A  50      10.573  11.637  10.764  1.00  0.00           C  
ATOM    599  C   LEU A  50      11.384  11.069  11.924  1.00  0.00           C  
ATOM    600  O   LEU A  50      11.121  11.374  13.088  1.00  0.00           O  
ATOM    601  CB  LEU A  50      11.309  12.828  10.148  1.00  0.00           C  
ATOM    602  CG  LEU A  50      10.514  13.658   9.139  1.00  0.00           C  
ATOM    603  CD1 LEU A  50      11.134  15.038   8.977  1.00  0.00           C  
ATOM    604  CD2 LEU A  50      10.442  12.943   7.798  1.00  0.00           C  
ATOM    605  H   LEU A  50       9.154  12.794  11.825  1.00  0.00           H  
ATOM    606  HA  LEU A  50      10.454  10.869  10.014  1.00  0.00           H  
ATOM    607  HB2 LEU A  50      11.609  13.482  10.950  1.00  0.00           H  
ATOM    608  HB3 LEU A  50      12.187  12.449   9.646  1.00  0.00           H  
ATOM    609  HG  LEU A  50       9.504  13.787   9.505  1.00  0.00           H  
ATOM    610 HD11 LEU A  50      10.360  15.755   8.752  1.00  0.00           H  
ATOM    611 HD12 LEU A  50      11.851  15.017   8.171  1.00  0.00           H  
ATOM    612 HD13 LEU A  50      11.630  15.319   9.894  1.00  0.00           H  
ATOM    613 HD21 LEU A  50       9.764  13.472   7.145  1.00  0.00           H  
ATOM    614 HD22 LEU A  50      10.086  11.934   7.946  1.00  0.00           H  
ATOM    615 HD23 LEU A  50      11.424  12.917   7.351  1.00  0.00           H  
ATOM    616  N   VAL A  51      12.374  10.242  11.599  1.00  0.00           N  
ATOM    617  CA  VAL A  51      13.226   9.635  12.613  1.00  0.00           C  
ATOM    618  C   VAL A  51      14.699   9.750  12.235  1.00  0.00           C  
ATOM    619  O   VAL A  51      15.040   9.869  11.058  1.00  0.00           O  
ATOM    620  CB  VAL A  51      12.876   8.149  12.824  1.00  0.00           C  
ATOM    621  CG1 VAL A  51      11.461   8.005  13.364  1.00  0.00           C  
ATOM    622  CG2 VAL A  51      13.041   7.374  11.526  1.00  0.00           C  
ATOM    623  H   VAL A  51      12.535  10.038  10.654  1.00  0.00           H  
ATOM    624  HA  VAL A  51      13.061  10.157  13.545  1.00  0.00           H  
ATOM    625  HB  VAL A  51      13.559   7.738  13.552  1.00  0.00           H  
ATOM    626 HG11 VAL A  51      10.809   8.699  12.854  1.00  0.00           H  
ATOM    627 HG12 VAL A  51      11.115   6.996  13.201  1.00  0.00           H  
ATOM    628 HG13 VAL A  51      11.458   8.220  14.423  1.00  0.00           H  
ATOM    629 HG21 VAL A  51      13.616   7.963  10.826  1.00  0.00           H  
ATOM    630 HG22 VAL A  51      13.557   6.446  11.722  1.00  0.00           H  
ATOM    631 HG23 VAL A  51      12.069   7.164  11.106  1.00  0.00           H  
ATOM    632  N   SER A  52      15.567   9.712  13.241  1.00  0.00           N  
ATOM    633  CA  SER A  52      17.004   9.816  13.014  1.00  0.00           C  
ATOM    634  C   SER A  52      17.664   8.442  13.078  1.00  0.00           C  
ATOM    635  O   SER A  52      17.103   7.497  13.632  1.00  0.00           O  
ATOM    636  CB  SER A  52      17.639  10.749  14.047  1.00  0.00           C  
ATOM    637  OG  SER A  52      18.796  11.377  13.524  1.00  0.00           O  
ATOM    638  H   SER A  52      15.233   9.616  14.157  1.00  0.00           H  
ATOM    639  HA  SER A  52      17.155  10.229  12.028  1.00  0.00           H  
ATOM    640  HB2 SER A  52      16.926  11.510  14.326  1.00  0.00           H  
ATOM    641  HB3 SER A  52      17.916  10.177  14.921  1.00  0.00           H  
ATOM    642  HG  SER A  52      19.505  11.333  14.171  1.00  0.00           H  
ATOM    643  N   MET A  53      18.860   8.341  12.509  1.00  0.00           N  
ATOM    644  CA  MET A  53      19.599   7.083  12.503  1.00  0.00           C  
ATOM    645  C   MET A  53      20.600   7.035  13.653  1.00  0.00           C  
ATOM    646  O   MET A  53      21.383   7.960  13.865  1.00  0.00           O  
ATOM    647  CB  MET A  53      20.328   6.901  11.170  1.00  0.00           C  
ATOM    648  CG  MET A  53      20.671   5.454  10.857  1.00  0.00           C  
ATOM    649  SD  MET A  53      19.231   4.494  10.349  1.00  0.00           S  
ATOM    650  CE  MET A  53      19.626   2.895  11.054  1.00  0.00           C  
ATOM    651  H   MET A  53      19.257   9.129  12.083  1.00  0.00           H  
ATOM    652  HA  MET A  53      18.887   6.281  12.625  1.00  0.00           H  
ATOM    653  HB2 MET A  53      19.701   7.280  10.376  1.00  0.00           H  
ATOM    654  HB3 MET A  53      21.247   7.469  11.194  1.00  0.00           H  
ATOM    655  HG2 MET A  53      21.398   5.434  10.059  1.00  0.00           H  
ATOM    656  HG3 MET A  53      21.096   5.001  11.740  1.00  0.00           H  
ATOM    657  HE1 MET A  53      19.538   2.134  10.293  1.00  0.00           H  
ATOM    658  HE2 MET A  53      20.637   2.909  11.434  1.00  0.00           H  
ATOM    659  HE3 MET A  53      18.941   2.678  11.861  1.00  0.00           H  
ATOM    660  N   PRO A  54      20.574   5.930  14.414  1.00  0.00           N  
ATOM    661  CA  PRO A  54      21.473   5.735  15.555  1.00  0.00           C  
ATOM    662  C   PRO A  54      22.925   6.049  15.211  1.00  0.00           C  
ATOM    663  O   PRO A  54      23.405   5.707  14.130  1.00  0.00           O  
ATOM    664  CB  PRO A  54      21.311   4.249  15.884  1.00  0.00           C  
ATOM    665  CG  PRO A  54      19.950   3.898  15.390  1.00  0.00           C  
ATOM    666  CD  PRO A  54      19.666   4.787  14.219  1.00  0.00           C  
ATOM    667  HA  PRO A  54      21.170   6.329  16.406  1.00  0.00           H  
ATOM    668  HB2 PRO A  54      22.076   3.679  15.376  1.00  0.00           H  
ATOM    669  HB3 PRO A  54      21.393   4.101  16.950  1.00  0.00           H  
ATOM    670  HG2 PRO A  54      19.928   2.865  15.079  1.00  0.00           H  
ATOM    671  HG3 PRO A  54      19.221   4.073  16.168  1.00  0.00           H  
ATOM    672  HD2 PRO A  54      19.889   4.272  13.296  1.00  0.00           H  
ATOM    673  HD3 PRO A  54      18.635   5.108  14.235  1.00  0.00           H  
ATOM    674  N   SER A  55      23.620   6.702  16.136  1.00  0.00           N  
ATOM    675  CA  SER A  55      25.017   7.065  15.928  1.00  0.00           C  
ATOM    676  C   SER A  55      25.904   5.824  15.916  1.00  0.00           C  
ATOM    677  O   SER A  55      27.085   5.894  15.572  1.00  0.00           O  
ATOM    678  CB  SER A  55      25.484   8.029  17.021  1.00  0.00           C  
ATOM    679  OG  SER A  55      25.552   7.380  18.279  1.00  0.00           O  
ATOM    680  H   SER A  55      23.182   6.948  16.978  1.00  0.00           H  
ATOM    681  HA  SER A  55      25.093   7.557  14.970  1.00  0.00           H  
ATOM    682  HB2 SER A  55      26.463   8.406  16.771  1.00  0.00           H  
ATOM    683  HB3 SER A  55      24.788   8.853  17.091  1.00  0.00           H  
ATOM    684  HG  SER A  55      26.311   7.706  18.767  1.00  0.00           H  
ATOM    685  N   LYS A  56      25.329   4.689  16.295  1.00  0.00           N  
ATOM    686  CA  LYS A  56      26.064   3.430  16.327  1.00  0.00           C  
ATOM    687  C   LYS A  56      25.888   2.663  15.021  1.00  0.00           C  
ATOM    688  O   LYS A  56      26.744   1.865  14.638  1.00  0.00           O  
ATOM    689  CB  LYS A  56      25.595   2.571  17.503  1.00  0.00           C  
ATOM    690  CG  LYS A  56      24.125   2.194  17.432  1.00  0.00           C  
ATOM    691  CD  LYS A  56      23.540   1.967  18.817  1.00  0.00           C  
ATOM    692  CE  LYS A  56      22.352   1.019  18.770  1.00  0.00           C  
ATOM    693  NZ  LYS A  56      21.385   1.288  19.870  1.00  0.00           N  
ATOM    694  H   LYS A  56      24.384   4.696  16.558  1.00  0.00           H  
ATOM    695  HA  LYS A  56      27.111   3.661  16.456  1.00  0.00           H  
ATOM    696  HB2 LYS A  56      26.177   1.662  17.525  1.00  0.00           H  
ATOM    697  HB3 LYS A  56      25.761   3.117  18.421  1.00  0.00           H  
ATOM    698  HG2 LYS A  56      23.581   2.994  16.951  1.00  0.00           H  
ATOM    699  HG3 LYS A  56      24.023   1.287  16.854  1.00  0.00           H  
ATOM    700  HD2 LYS A  56      24.301   1.541  19.454  1.00  0.00           H  
ATOM    701  HD3 LYS A  56      23.217   2.915  19.222  1.00  0.00           H  
ATOM    702  HE2 LYS A  56      21.849   1.138  17.823  1.00  0.00           H  
ATOM    703  HE3 LYS A  56      22.714   0.004  18.861  1.00  0.00           H  
ATOM    704  HZ1 LYS A  56      20.500   0.767  19.703  1.00  0.00           H  
ATOM    705  HZ2 LYS A  56      21.172   2.304  19.917  1.00  0.00           H  
ATOM    706  HZ3 LYS A  56      21.786   0.985  20.781  1.00  0.00           H  
ATOM    707  N   TYR A  57      24.774   2.909  14.341  1.00  0.00           N  
ATOM    708  CA  TYR A  57      24.485   2.241  13.078  1.00  0.00           C  
ATOM    709  C   TYR A  57      25.098   3.002  11.906  1.00  0.00           C  
ATOM    710  O   TYR A  57      24.578   2.968  10.791  1.00  0.00           O  
ATOM    711  CB  TYR A  57      22.974   2.109  12.881  1.00  0.00           C  
ATOM    712  CG  TYR A  57      22.304   1.222  13.907  1.00  0.00           C  
ATOM    713  CD1 TYR A  57      23.054   0.530  14.851  1.00  0.00           C  
ATOM    714  CD2 TYR A  57      20.923   1.074  13.931  1.00  0.00           C  
ATOM    715  CE1 TYR A  57      22.447  -0.281  15.790  1.00  0.00           C  
ATOM    716  CE2 TYR A  57      20.308   0.265  14.867  1.00  0.00           C  
ATOM    717  CZ  TYR A  57      21.074  -0.410  15.794  1.00  0.00           C  
ATOM    718  OH  TYR A  57      20.465  -1.218  16.728  1.00  0.00           O  
ATOM    719  H   TYR A  57      24.129   3.555  14.698  1.00  0.00           H  
ATOM    720  HA  TYR A  57      24.921   1.253  13.119  1.00  0.00           H  
ATOM    721  HB2 TYR A  57      22.522   3.086  12.944  1.00  0.00           H  
ATOM    722  HB3 TYR A  57      22.781   1.690  11.904  1.00  0.00           H  
ATOM    723  HD1 TYR A  57      24.130   0.634  14.846  1.00  0.00           H  
ATOM    724  HD2 TYR A  57      20.326   1.604  13.204  1.00  0.00           H  
ATOM    725  HE1 TYR A  57      23.047  -0.810  16.516  1.00  0.00           H  
ATOM    726  HE2 TYR A  57      19.233   0.164  14.870  1.00  0.00           H  
ATOM    727  HH  TYR A  57      21.134  -1.633  17.276  1.00  0.00           H  
ATOM    728  N   ARG A  58      26.205   3.687  12.168  1.00  0.00           N  
ATOM    729  CA  ARG A  58      26.889   4.458  11.137  1.00  0.00           C  
ATOM    730  C   ARG A  58      27.297   3.562   9.971  1.00  0.00           C  
ATOM    731  O   ARG A  58      28.454   3.154   9.862  1.00  0.00           O  
ATOM    732  CB  ARG A  58      28.123   5.147  11.721  1.00  0.00           C  
ATOM    733  CG  ARG A  58      27.822   6.489  12.369  1.00  0.00           C  
ATOM    734  CD  ARG A  58      27.416   7.528  11.335  1.00  0.00           C  
ATOM    735  NE  ARG A  58      27.220   8.846  11.932  1.00  0.00           N  
ATOM    736  CZ  ARG A  58      26.989   9.947  11.224  1.00  0.00           C  
ATOM    737  NH1 ARG A  58      26.926   9.887   9.901  1.00  0.00           N  
ATOM    738  NH2 ARG A  58      26.822  11.110  11.839  1.00  0.00           N  
ATOM    739  H   ARG A  58      26.571   3.675  13.078  1.00  0.00           H  
ATOM    740  HA  ARG A  58      26.204   5.210  10.776  1.00  0.00           H  
ATOM    741  HB2 ARG A  58      28.563   4.503  12.467  1.00  0.00           H  
ATOM    742  HB3 ARG A  58      28.840   5.307  10.928  1.00  0.00           H  
ATOM    743  HG2 ARG A  58      27.016   6.364  13.074  1.00  0.00           H  
ATOM    744  HG3 ARG A  58      28.705   6.835  12.885  1.00  0.00           H  
ATOM    745  HD2 ARG A  58      28.190   7.593  10.585  1.00  0.00           H  
ATOM    746  HD3 ARG A  58      26.492   7.212  10.872  1.00  0.00           H  
ATOM    747  HE  ARG A  58      27.263   8.914  12.908  1.00  0.00           H  
ATOM    748 HH11 ARG A  58      27.050   9.011   9.435  1.00  0.00           H  
ATOM    749 HH12 ARG A  58      26.751  10.716   9.371  1.00  0.00           H  
ATOM    750 HH21 ARG A  58      26.870  11.159  12.837  1.00  0.00           H  
ATOM    751 HH22 ARG A  58      26.649  11.937  11.307  1.00  0.00           H  
ATOM    752  N   LYS A  59      26.340   3.260   9.100  1.00  0.00           N  
ATOM    753  CA  LYS A  59      26.598   2.414   7.941  1.00  0.00           C  
ATOM    754  C   LYS A  59      25.402   2.410   6.994  1.00  0.00           C  
ATOM    755  O   LYS A  59      24.385   3.049   7.260  1.00  0.00           O  
ATOM    756  CB  LYS A  59      26.913   0.984   8.388  1.00  0.00           C  
ATOM    757  CG  LYS A  59      25.782   0.325   9.157  1.00  0.00           C  
ATOM    758  CD  LYS A  59      26.222  -0.993   9.774  1.00  0.00           C  
ATOM    759  CE  LYS A  59      25.055  -1.956   9.925  1.00  0.00           C  
ATOM    760  NZ  LYS A  59      24.232  -1.646  11.127  1.00  0.00           N  
ATOM    761  H   LYS A  59      25.436   3.616   9.241  1.00  0.00           H  
ATOM    762  HA  LYS A  59      27.453   2.816   7.421  1.00  0.00           H  
ATOM    763  HB2 LYS A  59      27.124   0.386   7.514  1.00  0.00           H  
ATOM    764  HB3 LYS A  59      27.789   1.002   9.020  1.00  0.00           H  
ATOM    765  HG2 LYS A  59      25.459   0.988   9.945  1.00  0.00           H  
ATOM    766  HG3 LYS A  59      24.960   0.138   8.482  1.00  0.00           H  
ATOM    767  HD2 LYS A  59      26.968  -1.446   9.139  1.00  0.00           H  
ATOM    768  HD3 LYS A  59      26.646  -0.800  10.750  1.00  0.00           H  
ATOM    769  HE2 LYS A  59      24.433  -1.886   9.046  1.00  0.00           H  
ATOM    770  HE3 LYS A  59      25.443  -2.960  10.013  1.00  0.00           H  
ATOM    771  HZ1 LYS A  59      24.664  -2.070  11.974  1.00  0.00           H  
ATOM    772  HZ2 LYS A  59      23.273  -2.031  11.012  1.00  0.00           H  
ATOM    773  HZ3 LYS A  59      24.167  -0.617  11.261  1.00  0.00           H  
ATOM    774  N   ASN A  60      25.532   1.684   5.888  1.00  0.00           N  
ATOM    775  CA  ASN A  60      24.462   1.597   4.901  1.00  0.00           C  
ATOM    776  C   ASN A  60      23.533   0.426   5.209  1.00  0.00           C  
ATOM    777  O   ASN A  60      23.718  -0.678   4.694  1.00  0.00           O  
ATOM    778  CB  ASN A  60      25.046   1.444   3.496  1.00  0.00           C  
ATOM    779  CG  ASN A  60      25.457   2.772   2.893  1.00  0.00           C  
ATOM    780  OD1 ASN A  60      26.647   3.068   2.767  1.00  0.00           O  
ATOM    781  ND2 ASN A  60      24.475   3.581   2.517  1.00  0.00           N  
ATOM    782  H   ASN A  60      26.367   1.197   5.732  1.00  0.00           H  
ATOM    783  HA  ASN A  60      23.893   2.514   4.947  1.00  0.00           H  
ATOM    784  HB2 ASN A  60      25.918   0.806   3.543  1.00  0.00           H  
ATOM    785  HB3 ASN A  60      24.308   0.990   2.853  1.00  0.00           H  
ATOM    786 HD21 ASN A  60      23.550   3.280   2.647  1.00  0.00           H  
ATOM    787 HD22 ASN A  60      24.712   4.446   2.123  1.00  0.00           H  
ATOM    788  N   ILE A  61      22.535   0.675   6.051  1.00  0.00           N  
ATOM    789  CA  ILE A  61      21.577  -0.358   6.425  1.00  0.00           C  
ATOM    790  C   ILE A  61      20.497  -0.518   5.361  1.00  0.00           C  
ATOM    791  O   ILE A  61      20.107   0.451   4.709  1.00  0.00           O  
ATOM    792  CB  ILE A  61      20.909  -0.044   7.776  1.00  0.00           C  
ATOM    793  CG1 ILE A  61      21.914  -0.209   8.918  1.00  0.00           C  
ATOM    794  CG2 ILE A  61      19.701  -0.942   7.992  1.00  0.00           C  
ATOM    795  CD1 ILE A  61      21.265  -0.383  10.273  1.00  0.00           C  
ATOM    796  H   ILE A  61      22.441   1.574   6.428  1.00  0.00           H  
ATOM    797  HA  ILE A  61      22.114  -1.292   6.520  1.00  0.00           H  
ATOM    798  HB  ILE A  61      20.566   0.980   7.753  1.00  0.00           H  
ATOM    799 HG12 ILE A  61      22.523  -1.079   8.729  1.00  0.00           H  
ATOM    800 HG13 ILE A  61      22.546   0.666   8.961  1.00  0.00           H  
ATOM    801 HG21 ILE A  61      18.988  -0.783   7.196  1.00  0.00           H  
ATOM    802 HG22 ILE A  61      20.015  -1.975   7.990  1.00  0.00           H  
ATOM    803 HG23 ILE A  61      19.241  -0.707   8.940  1.00  0.00           H  
ATOM    804 HD11 ILE A  61      20.701  -1.305  10.288  1.00  0.00           H  
ATOM    805 HD12 ILE A  61      22.027  -0.414  11.037  1.00  0.00           H  
ATOM    806 HD13 ILE A  61      20.600   0.447  10.463  1.00  0.00           H  
ATOM    807  N   TRP A  62      20.016  -1.744   5.192  1.00  0.00           N  
ATOM    808  CA  TRP A  62      18.978  -2.030   4.209  1.00  0.00           C  
ATOM    809  C   TRP A  62      17.607  -1.612   4.726  1.00  0.00           C  
ATOM    810  O   TRP A  62      17.021  -2.286   5.573  1.00  0.00           O  
ATOM    811  CB  TRP A  62      18.973  -3.520   3.861  1.00  0.00           C  
ATOM    812  CG  TRP A  62      17.837  -3.917   2.968  1.00  0.00           C  
ATOM    813  CD1 TRP A  62      16.522  -4.038   3.318  1.00  0.00           C  
ATOM    814  CD2 TRP A  62      17.914  -4.247   1.577  1.00  0.00           C  
ATOM    815  NE1 TRP A  62      15.778  -4.424   2.230  1.00  0.00           N  
ATOM    816  CE2 TRP A  62      16.608  -4.558   1.150  1.00  0.00           C  
ATOM    817  CE3 TRP A  62      18.960  -4.309   0.651  1.00  0.00           C  
ATOM    818  CZ2 TRP A  62      16.323  -4.925  -0.164  1.00  0.00           C  
ATOM    819  CZ3 TRP A  62      18.675  -4.674  -0.651  1.00  0.00           C  
ATOM    820  CH2 TRP A  62      17.365  -4.977  -1.049  1.00  0.00           C  
ATOM    821  H   TRP A  62      20.367  -2.475   5.743  1.00  0.00           H  
ATOM    822  HA  TRP A  62      19.202  -1.463   3.317  1.00  0.00           H  
ATOM    823  HB2 TRP A  62      19.895  -3.770   3.357  1.00  0.00           H  
ATOM    824  HB3 TRP A  62      18.898  -4.094   4.773  1.00  0.00           H  
ATOM    825  HD1 TRP A  62      16.139  -3.857   4.311  1.00  0.00           H  
ATOM    826  HE1 TRP A  62      14.809  -4.576   2.228  1.00  0.00           H  
ATOM    827  HE3 TRP A  62      19.974  -4.078   0.939  1.00  0.00           H  
ATOM    828  HZ2 TRP A  62      15.320  -5.161  -0.486  1.00  0.00           H  
ATOM    829  HZ3 TRP A  62      19.469  -4.727  -1.381  1.00  0.00           H  
ATOM    830  HH2 TRP A  62      17.189  -5.257  -2.076  1.00  0.00           H  
ATOM    831  N   ILE A  63      17.101  -0.495   4.212  1.00  0.00           N  
ATOM    832  CA  ILE A  63      15.797   0.011   4.623  1.00  0.00           C  
ATOM    833  C   ILE A  63      14.881   0.211   3.421  1.00  0.00           C  
ATOM    834  O   ILE A  63      15.301   0.732   2.386  1.00  0.00           O  
ATOM    835  CB  ILE A  63      15.926   1.344   5.384  1.00  0.00           C  
ATOM    836  CG1 ILE A  63      16.848   1.180   6.594  1.00  0.00           C  
ATOM    837  CG2 ILE A  63      14.555   1.840   5.819  1.00  0.00           C  
ATOM    838  CD1 ILE A  63      17.395   2.489   7.119  1.00  0.00           C  
ATOM    839  H   ILE A  63      17.615  -0.002   3.541  1.00  0.00           H  
ATOM    840  HA  ILE A  63      15.351  -0.716   5.285  1.00  0.00           H  
ATOM    841  HB  ILE A  63      16.350   2.076   4.713  1.00  0.00           H  
ATOM    842 HG12 ILE A  63      16.302   0.705   7.392  1.00  0.00           H  
ATOM    843 HG13 ILE A  63      17.686   0.557   6.315  1.00  0.00           H  
ATOM    844 HG21 ILE A  63      14.425   2.865   5.503  1.00  0.00           H  
ATOM    845 HG22 ILE A  63      13.791   1.226   5.368  1.00  0.00           H  
ATOM    846 HG23 ILE A  63      14.476   1.782   6.894  1.00  0.00           H  
ATOM    847 HD11 ILE A  63      16.601   3.046   7.593  1.00  0.00           H  
ATOM    848 HD12 ILE A  63      18.176   2.291   7.837  1.00  0.00           H  
ATOM    849 HD13 ILE A  63      17.798   3.066   6.298  1.00  0.00           H  
ATOM    850  N   LYS A  64      13.628  -0.203   3.564  1.00  0.00           N  
ATOM    851  CA  LYS A  64      12.649  -0.068   2.491  1.00  0.00           C  
ATOM    852  C   LYS A  64      11.361   0.567   3.005  1.00  0.00           C  
ATOM    853  O   LYS A  64      11.238   0.868   4.193  1.00  0.00           O  
ATOM    854  CB  LYS A  64      12.346  -1.435   1.874  1.00  0.00           C  
ATOM    855  CG  LYS A  64      13.585  -2.191   1.431  1.00  0.00           C  
ATOM    856  CD  LYS A  64      13.921  -1.907  -0.024  1.00  0.00           C  
ATOM    857  CE  LYS A  64      14.879  -0.733  -0.155  1.00  0.00           C  
ATOM    858  NZ  LYS A  64      15.016  -0.284  -1.569  1.00  0.00           N  
ATOM    859  H   LYS A  64      13.353  -0.610   4.412  1.00  0.00           H  
ATOM    860  HA  LYS A  64      13.075   0.572   1.733  1.00  0.00           H  
ATOM    861  HB2 LYS A  64      11.824  -2.038   2.603  1.00  0.00           H  
ATOM    862  HB3 LYS A  64      11.708  -1.295   1.013  1.00  0.00           H  
ATOM    863  HG2 LYS A  64      14.419  -1.891   2.046  1.00  0.00           H  
ATOM    864  HG3 LYS A  64      13.411  -3.252   1.549  1.00  0.00           H  
ATOM    865  HD2 LYS A  64      14.382  -2.783  -0.456  1.00  0.00           H  
ATOM    866  HD3 LYS A  64      13.009  -1.679  -0.557  1.00  0.00           H  
ATOM    867  HE2 LYS A  64      14.506   0.087   0.439  1.00  0.00           H  
ATOM    868  HE3 LYS A  64      15.848  -1.034   0.214  1.00  0.00           H  
ATOM    869  HZ1 LYS A  64      14.110  -0.394  -2.068  1.00  0.00           H  
ATOM    870  HZ2 LYS A  64      15.737  -0.853  -2.055  1.00  0.00           H  
ATOM    871  HZ3 LYS A  64      15.299   0.716  -1.601  1.00  0.00           H  
ATOM    872  N   ARG A  65      10.404   0.767   2.106  1.00  0.00           N  
ATOM    873  CA  ARG A  65       9.126   1.365   2.469  1.00  0.00           C  
ATOM    874  C   ARG A  65       8.200   0.328   3.099  1.00  0.00           C  
ATOM    875  O   ARG A  65       8.156  -0.823   2.668  1.00  0.00           O  
ATOM    876  CB  ARG A  65       8.458   1.981   1.239  1.00  0.00           C  
ATOM    877  CG  ARG A  65       7.025   2.426   1.482  1.00  0.00           C  
ATOM    878  CD  ARG A  65       6.225   2.459   0.189  1.00  0.00           C  
ATOM    879  NE  ARG A  65       5.076   3.356   0.280  1.00  0.00           N  
ATOM    880  CZ  ARG A  65       4.309   3.673  -0.757  1.00  0.00           C  
ATOM    881  NH1 ARG A  65       4.564   3.167  -1.955  1.00  0.00           N  
ATOM    882  NH2 ARG A  65       3.280   4.497  -0.595  1.00  0.00           N  
ATOM    883  H   ARG A  65      10.561   0.505   1.174  1.00  0.00           H  
ATOM    884  HA  ARG A  65       9.319   2.144   3.192  1.00  0.00           H  
ATOM    885  HB2 ARG A  65       9.030   2.842   0.926  1.00  0.00           H  
ATOM    886  HB3 ARG A  65       8.455   1.252   0.443  1.00  0.00           H  
ATOM    887  HG2 ARG A  65       6.554   1.735   2.166  1.00  0.00           H  
ATOM    888  HG3 ARG A  65       7.034   3.415   1.916  1.00  0.00           H  
ATOM    889  HD2 ARG A  65       6.870   2.794  -0.609  1.00  0.00           H  
ATOM    890  HD3 ARG A  65       5.875   1.461  -0.027  1.00  0.00           H  
ATOM    891  HE  ARG A  65       4.869   3.742   1.156  1.00  0.00           H  
ATOM    892 HH11 ARG A  65       5.337   2.546  -2.080  1.00  0.00           H  
ATOM    893 HH12 ARG A  65       3.984   3.406  -2.734  1.00  0.00           H  
ATOM    894 HH21 ARG A  65       3.083   4.879   0.307  1.00  0.00           H  
ATOM    895 HH22 ARG A  65       2.703   4.734  -1.376  1.00  0.00           H  
ATOM    896  N   GLY A  66       7.460   0.746   4.122  1.00  0.00           N  
ATOM    897  CA  GLY A  66       6.546  -0.157   4.794  1.00  0.00           C  
ATOM    898  C   GLY A  66       7.208  -0.915   5.929  1.00  0.00           C  
ATOM    899  O   GLY A  66       6.543  -1.330   6.878  1.00  0.00           O  
ATOM    900  H   GLY A  66       7.537   1.676   4.423  1.00  0.00           H  
ATOM    901  HA2 GLY A  66       5.719   0.412   5.190  1.00  0.00           H  
ATOM    902  HA3 GLY A  66       6.167  -0.870   4.075  1.00  0.00           H  
ATOM    903  N   ASP A  67       8.520  -1.095   5.830  1.00  0.00           N  
ATOM    904  CA  ASP A  67       9.273  -1.808   6.856  1.00  0.00           C  
ATOM    905  C   ASP A  67       8.952  -1.262   8.244  1.00  0.00           C  
ATOM    906  O   ASP A  67       9.052  -0.059   8.488  1.00  0.00           O  
ATOM    907  CB  ASP A  67      10.775  -1.699   6.586  1.00  0.00           C  
ATOM    908  CG  ASP A  67      11.553  -2.864   7.165  1.00  0.00           C  
ATOM    909  OD1 ASP A  67      10.970  -3.630   7.960  1.00  0.00           O  
ATOM    910  OD2 ASP A  67      12.745  -3.009   6.822  1.00  0.00           O  
ATOM    911  H   ASP A  67       8.995  -0.740   5.050  1.00  0.00           H  
ATOM    912  HA  ASP A  67       8.985  -2.847   6.817  1.00  0.00           H  
ATOM    913  HB2 ASP A  67      10.941  -1.672   5.519  1.00  0.00           H  
ATOM    914  HB3 ASP A  67      11.147  -0.785   7.027  1.00  0.00           H  
ATOM    915  N   PHE A  68       8.563  -2.153   9.150  1.00  0.00           N  
ATOM    916  CA  PHE A  68       8.225  -1.760  10.513  1.00  0.00           C  
ATOM    917  C   PHE A  68       9.464  -1.766  11.404  1.00  0.00           C  
ATOM    918  O   PHE A  68      10.162  -2.775  11.511  1.00  0.00           O  
ATOM    919  CB  PHE A  68       7.165  -2.700  11.089  1.00  0.00           C  
ATOM    920  CG  PHE A  68       5.969  -2.874  10.196  1.00  0.00           C  
ATOM    921  CD1 PHE A  68       4.997  -1.890  10.119  1.00  0.00           C  
ATOM    922  CD2 PHE A  68       5.818  -4.021   9.434  1.00  0.00           C  
ATOM    923  CE1 PHE A  68       3.896  -2.047   9.299  1.00  0.00           C  
ATOM    924  CE2 PHE A  68       4.718  -4.184   8.612  1.00  0.00           C  
ATOM    925  CZ  PHE A  68       3.757  -3.195   8.544  1.00  0.00           C  
ATOM    926  H   PHE A  68       8.503  -3.098   8.895  1.00  0.00           H  
ATOM    927  HA  PHE A  68       7.826  -0.759  10.479  1.00  0.00           H  
ATOM    928  HB2 PHE A  68       7.604  -3.674  11.247  1.00  0.00           H  
ATOM    929  HB3 PHE A  68       6.821  -2.308  12.034  1.00  0.00           H  
ATOM    930  HD1 PHE A  68       5.104  -0.990  10.708  1.00  0.00           H  
ATOM    931  HD2 PHE A  68       6.570  -4.796   9.487  1.00  0.00           H  
ATOM    932  HE1 PHE A  68       3.145  -1.273   9.247  1.00  0.00           H  
ATOM    933  HE2 PHE A  68       4.613  -5.083   8.023  1.00  0.00           H  
ATOM    934  HZ  PHE A  68       2.897  -3.320   7.903  1.00  0.00           H  
ATOM    935  N   LEU A  69       9.732  -0.633  12.043  1.00  0.00           N  
ATOM    936  CA  LEU A  69      10.887  -0.506  12.925  1.00  0.00           C  
ATOM    937  C   LEU A  69      10.478   0.067  14.277  1.00  0.00           C  
ATOM    938  O   LEU A  69       9.391   0.629  14.422  1.00  0.00           O  
ATOM    939  CB  LEU A  69      11.949   0.387  12.280  1.00  0.00           C  
ATOM    940  CG  LEU A  69      12.222   0.141  10.796  1.00  0.00           C  
ATOM    941  CD1 LEU A  69      13.097   1.246  10.223  1.00  0.00           C  
ATOM    942  CD2 LEU A  69      12.876  -1.218  10.592  1.00  0.00           C  
ATOM    943  H   LEU A  69       9.139   0.138  11.918  1.00  0.00           H  
ATOM    944  HA  LEU A  69      11.300  -1.492  13.075  1.00  0.00           H  
ATOM    945  HB2 LEU A  69      11.632   1.412  12.392  1.00  0.00           H  
ATOM    946  HB3 LEU A  69      12.875   0.238  12.818  1.00  0.00           H  
ATOM    947  HG  LEU A  69      11.284   0.147  10.259  1.00  0.00           H  
ATOM    948 HD11 LEU A  69      12.487   1.925   9.647  1.00  0.00           H  
ATOM    949 HD12 LEU A  69      13.854   0.813   9.588  1.00  0.00           H  
ATOM    950 HD13 LEU A  69      13.570   1.784  11.032  1.00  0.00           H  
ATOM    951 HD21 LEU A  69      13.909  -1.171  10.903  1.00  0.00           H  
ATOM    952 HD22 LEU A  69      12.827  -1.487   9.547  1.00  0.00           H  
ATOM    953 HD23 LEU A  69      12.355  -1.960  11.180  1.00  0.00           H  
ATOM    954  N   ILE A  70      11.355  -0.077  15.265  1.00  0.00           N  
ATOM    955  CA  ILE A  70      11.087   0.429  16.605  1.00  0.00           C  
ATOM    956  C   ILE A  70      11.881   1.701  16.882  1.00  0.00           C  
ATOM    957  O   ILE A  70      13.107   1.670  16.990  1.00  0.00           O  
ATOM    958  CB  ILE A  70      11.426  -0.619  17.681  1.00  0.00           C  
ATOM    959  CG1 ILE A  70      10.413  -1.765  17.645  1.00  0.00           C  
ATOM    960  CG2 ILE A  70      11.453   0.026  19.059  1.00  0.00           C  
ATOM    961  CD1 ILE A  70      10.815  -2.952  18.491  1.00  0.00           C  
ATOM    962  H   ILE A  70      12.204  -0.533  15.087  1.00  0.00           H  
ATOM    963  HA  ILE A  70      10.032   0.655  16.671  1.00  0.00           H  
ATOM    964  HB  ILE A  70      12.410  -1.010  17.473  1.00  0.00           H  
ATOM    965 HG12 ILE A  70       9.461  -1.408  18.005  1.00  0.00           H  
ATOM    966 HG13 ILE A  70      10.304  -2.106  16.625  1.00  0.00           H  
ATOM    967 HG21 ILE A  70      12.294   0.702  19.122  1.00  0.00           H  
ATOM    968 HG22 ILE A  70      10.539   0.576  19.218  1.00  0.00           H  
ATOM    969 HG23 ILE A  70      11.550  -0.740  19.814  1.00  0.00           H  
ATOM    970 HD11 ILE A  70      10.171  -3.791  18.265  1.00  0.00           H  
ATOM    971 HD12 ILE A  70      11.839  -3.218  18.278  1.00  0.00           H  
ATOM    972 HD13 ILE A  70      10.718  -2.699  19.537  1.00  0.00           H  
ATOM    973  N   VAL A  71      11.174   2.821  16.998  1.00  0.00           N  
ATOM    974  CA  VAL A  71      11.812   4.104  17.267  1.00  0.00           C  
ATOM    975  C   VAL A  71      11.523   4.576  18.688  1.00  0.00           C  
ATOM    976  O   VAL A  71      10.510   4.205  19.282  1.00  0.00           O  
ATOM    977  CB  VAL A  71      11.341   5.183  16.273  1.00  0.00           C  
ATOM    978  CG1 VAL A  71      11.512   4.701  14.841  1.00  0.00           C  
ATOM    979  CG2 VAL A  71       9.894   5.564  16.548  1.00  0.00           C  
ATOM    980  H   VAL A  71      10.199   2.783  16.904  1.00  0.00           H  
ATOM    981  HA  VAL A  71      12.879   3.978  17.149  1.00  0.00           H  
ATOM    982  HB  VAL A  71      11.956   6.061  16.410  1.00  0.00           H  
ATOM    983 HG11 VAL A  71      10.783   5.187  14.210  1.00  0.00           H  
ATOM    984 HG12 VAL A  71      12.507   4.943  14.496  1.00  0.00           H  
ATOM    985 HG13 VAL A  71      11.367   3.632  14.802  1.00  0.00           H  
ATOM    986 HG21 VAL A  71       9.244   4.773  16.206  1.00  0.00           H  
ATOM    987 HG22 VAL A  71       9.756   5.712  17.609  1.00  0.00           H  
ATOM    988 HG23 VAL A  71       9.657   6.478  16.024  1.00  0.00           H  
ATOM    989  N   ASP A  72      12.419   5.396  19.226  1.00  0.00           N  
ATOM    990  CA  ASP A  72      12.260   5.920  20.577  1.00  0.00           C  
ATOM    991  C   ASP A  72      12.298   7.446  20.577  1.00  0.00           C  
ATOM    992  O   ASP A  72      13.139   8.069  19.929  1.00  0.00           O  
ATOM    993  CB  ASP A  72      13.354   5.371  21.493  1.00  0.00           C  
ATOM    994  CG  ASP A  72      13.200   5.841  22.926  1.00  0.00           C  
ATOM    995  OD1 ASP A  72      12.379   5.252  23.658  1.00  0.00           O  
ATOM    996  OD2 ASP A  72      13.901   6.799  23.315  1.00  0.00           O  
ATOM    997  H   ASP A  72      13.206   5.656  18.702  1.00  0.00           H  
ATOM    998  HA  ASP A  72      11.298   5.598  20.948  1.00  0.00           H  
ATOM    999  HB2 ASP A  72      13.315   4.291  21.483  1.00  0.00           H  
ATOM   1000  HB3 ASP A  72      14.317   5.697  21.127  1.00  0.00           H  
ATOM   1001  N   PRO A  73      11.365   8.062  21.317  1.00  0.00           N  
ATOM   1002  CA  PRO A  73      11.271   9.522  21.418  1.00  0.00           C  
ATOM   1003  C   PRO A  73      12.432  10.125  22.201  1.00  0.00           C  
ATOM   1004  O   PRO A  73      12.953   9.507  23.131  1.00  0.00           O  
ATOM   1005  CB  PRO A  73       9.952   9.741  22.163  1.00  0.00           C  
ATOM   1006  CG  PRO A  73       9.746   8.491  22.945  1.00  0.00           C  
ATOM   1007  CD  PRO A  73      10.331   7.382  22.114  1.00  0.00           C  
ATOM   1008  HA  PRO A  73      11.217   9.984  20.443  1.00  0.00           H  
ATOM   1009  HB2 PRO A  73      10.041  10.603  22.810  1.00  0.00           H  
ATOM   1010  HB3 PRO A  73       9.155   9.899  21.452  1.00  0.00           H  
ATOM   1011  HG2 PRO A  73      10.259   8.560  23.892  1.00  0.00           H  
ATOM   1012  HG3 PRO A  73       8.690   8.325  23.100  1.00  0.00           H  
ATOM   1013  HD2 PRO A  73      10.768   6.625  22.749  1.00  0.00           H  
ATOM   1014  HD3 PRO A  73       9.575   6.949  21.476  1.00  0.00           H  
ATOM   1015  N   ILE A  74      12.834  11.332  21.819  1.00  0.00           N  
ATOM   1016  CA  ILE A  74      13.932  12.019  22.488  1.00  0.00           C  
ATOM   1017  C   ILE A  74      13.453  13.304  23.154  1.00  0.00           C  
ATOM   1018  O   ILE A  74      12.433  13.872  22.767  1.00  0.00           O  
ATOM   1019  CB  ILE A  74      15.067  12.356  21.503  1.00  0.00           C  
ATOM   1020  CG1 ILE A  74      15.317  11.179  20.556  1.00  0.00           C  
ATOM   1021  CG2 ILE A  74      16.337  12.712  22.260  1.00  0.00           C  
ATOM   1022  CD1 ILE A  74      16.162  11.540  19.354  1.00  0.00           C  
ATOM   1023  H   ILE A  74      12.379  11.773  21.071  1.00  0.00           H  
ATOM   1024  HA  ILE A  74      14.325  11.357  23.247  1.00  0.00           H  
ATOM   1025  HB  ILE A  74      14.768  13.216  20.924  1.00  0.00           H  
ATOM   1026 HG12 ILE A  74      15.825  10.395  21.095  1.00  0.00           H  
ATOM   1027 HG13 ILE A  74      14.369  10.808  20.197  1.00  0.00           H  
ATOM   1028 HG21 ILE A  74      16.277  13.735  22.603  1.00  0.00           H  
ATOM   1029 HG22 ILE A  74      16.446  12.055  23.110  1.00  0.00           H  
ATOM   1030 HG23 ILE A  74      17.190  12.602  21.608  1.00  0.00           H  
ATOM   1031 HD11 ILE A  74      16.346  12.604  19.350  1.00  0.00           H  
ATOM   1032 HD12 ILE A  74      17.101  11.010  19.401  1.00  0.00           H  
ATOM   1033 HD13 ILE A  74      15.637  11.263  18.451  1.00  0.00           H  
ATOM   1034  N   GLU A  75      14.199  13.758  24.156  1.00  0.00           N  
ATOM   1035  CA  GLU A  75      13.851  14.978  24.875  1.00  0.00           C  
ATOM   1036  C   GLU A  75      13.924  16.192  23.954  1.00  0.00           C  
ATOM   1037  O   GLU A  75      14.192  16.063  22.760  1.00  0.00           O  
ATOM   1038  CB  GLU A  75      14.784  15.175  26.072  1.00  0.00           C  
ATOM   1039  CG  GLU A  75      16.258  15.145  25.706  1.00  0.00           C  
ATOM   1040  CD  GLU A  75      16.843  13.747  25.754  1.00  0.00           C  
ATOM   1041  OE1 GLU A  75      16.072  12.787  25.965  1.00  0.00           O  
ATOM   1042  OE2 GLU A  75      18.072  13.612  25.579  1.00  0.00           O  
ATOM   1043  H   GLU A  75      15.002  13.261  24.418  1.00  0.00           H  
ATOM   1044  HA  GLU A  75      12.838  14.873  25.234  1.00  0.00           H  
ATOM   1045  HB2 GLU A  75      14.566  16.129  26.529  1.00  0.00           H  
ATOM   1046  HB3 GLU A  75      14.597  14.390  26.790  1.00  0.00           H  
ATOM   1047  HG2 GLU A  75      16.375  15.534  24.706  1.00  0.00           H  
ATOM   1048  HG3 GLU A  75      16.801  15.770  26.399  1.00  0.00           H  
ATOM   1049  N   GLU A  76      13.682  17.371  24.518  1.00  0.00           N  
ATOM   1050  CA  GLU A  76      13.719  18.608  23.747  1.00  0.00           C  
ATOM   1051  C   GLU A  76      15.081  18.796  23.085  1.00  0.00           C  
ATOM   1052  O   GLU A  76      15.994  19.376  23.671  1.00  0.00           O  
ATOM   1053  CB  GLU A  76      13.408  19.806  24.648  1.00  0.00           C  
ATOM   1054  CG  GLU A  76      11.954  19.879  25.083  1.00  0.00           C  
ATOM   1055  CD  GLU A  76      11.510  18.646  25.845  1.00  0.00           C  
ATOM   1056  OE1 GLU A  76      12.237  18.225  26.769  1.00  0.00           O  
ATOM   1057  OE2 GLU A  76      10.437  18.100  25.516  1.00  0.00           O  
ATOM   1058  H   GLU A  76      13.473  17.410  25.475  1.00  0.00           H  
ATOM   1059  HA  GLU A  76      12.964  18.543  22.978  1.00  0.00           H  
ATOM   1060  HB2 GLU A  76      14.024  19.746  25.532  1.00  0.00           H  
ATOM   1061  HB3 GLU A  76      13.648  20.714  24.114  1.00  0.00           H  
ATOM   1062  HG2 GLU A  76      11.825  20.741  25.720  1.00  0.00           H  
ATOM   1063  HG3 GLU A  76      11.334  19.984  24.205  1.00  0.00           H  
ATOM   1064  N   GLY A  77      15.209  18.300  21.858  1.00  0.00           N  
ATOM   1065  CA  GLY A  77      16.462  18.422  21.135  1.00  0.00           C  
ATOM   1066  C   GLY A  77      16.265  18.897  19.709  1.00  0.00           C  
ATOM   1067  O   GLY A  77      15.741  19.986  19.479  1.00  0.00           O  
ATOM   1068  H   GLY A  77      14.447  17.847  21.440  1.00  0.00           H  
ATOM   1069  HA2 GLY A  77      17.097  19.124  21.654  1.00  0.00           H  
ATOM   1070  HA3 GLY A  77      16.949  17.458  21.118  1.00  0.00           H  
ATOM   1071  N   GLU A  78      16.687  18.079  18.751  1.00  0.00           N  
ATOM   1072  CA  GLU A  78      16.557  18.422  17.340  1.00  0.00           C  
ATOM   1073  C   GLU A  78      15.097  18.365  16.899  1.00  0.00           C  
ATOM   1074  O   GLU A  78      14.198  18.151  17.713  1.00  0.00           O  
ATOM   1075  CB  GLU A  78      17.398  17.477  16.481  1.00  0.00           C  
ATOM   1076  CG  GLU A  78      17.194  16.009  16.813  1.00  0.00           C  
ATOM   1077  CD  GLU A  78      18.151  15.513  17.880  1.00  0.00           C  
ATOM   1078  OE1 GLU A  78      18.939  16.333  18.396  1.00  0.00           O  
ATOM   1079  OE2 GLU A  78      18.111  14.306  18.200  1.00  0.00           O  
ATOM   1080  H   GLU A  78      17.097  17.223  18.999  1.00  0.00           H  
ATOM   1081  HA  GLU A  78      16.919  19.431  17.211  1.00  0.00           H  
ATOM   1082  HB2 GLU A  78      17.143  17.629  15.443  1.00  0.00           H  
ATOM   1083  HB3 GLU A  78      18.442  17.714  16.624  1.00  0.00           H  
ATOM   1084  HG2 GLU A  78      16.183  15.870  17.166  1.00  0.00           H  
ATOM   1085  HG3 GLU A  78      17.344  15.425  15.917  1.00  0.00           H  
ATOM   1086  N   LYS A  79      14.868  18.556  15.604  1.00  0.00           N  
ATOM   1087  CA  LYS A  79      13.519  18.526  15.053  1.00  0.00           C  
ATOM   1088  C   LYS A  79      13.077  17.092  14.775  1.00  0.00           C  
ATOM   1089  O   LYS A  79      12.163  16.856  13.985  1.00  0.00           O  
ATOM   1090  CB  LYS A  79      13.453  19.349  13.764  1.00  0.00           C  
ATOM   1091  CG  LYS A  79      12.045  19.769  13.381  1.00  0.00           C  
ATOM   1092  CD  LYS A  79      11.939  20.075  11.896  1.00  0.00           C  
ATOM   1093  CE  LYS A  79      11.904  18.802  11.066  1.00  0.00           C  
ATOM   1094  NZ  LYS A  79      12.376  19.034   9.673  1.00  0.00           N  
ATOM   1095  H   LYS A  79      15.626  18.722  15.005  1.00  0.00           H  
ATOM   1096  HA  LYS A  79      12.852  18.961  15.782  1.00  0.00           H  
ATOM   1097  HB2 LYS A  79      14.051  20.240  13.890  1.00  0.00           H  
ATOM   1098  HB3 LYS A  79      13.865  18.762  12.955  1.00  0.00           H  
ATOM   1099  HG2 LYS A  79      11.362  18.967  13.622  1.00  0.00           H  
ATOM   1100  HG3 LYS A  79      11.778  20.653  13.942  1.00  0.00           H  
ATOM   1101  HD2 LYS A  79      11.032  20.633  11.716  1.00  0.00           H  
ATOM   1102  HD3 LYS A  79      12.793  20.666  11.598  1.00  0.00           H  
ATOM   1103  HE2 LYS A  79      12.539  18.064  11.533  1.00  0.00           H  
ATOM   1104  HE3 LYS A  79      10.888  18.435  11.037  1.00  0.00           H  
ATOM   1105  HZ1 LYS A  79      11.914  18.365   9.023  1.00  0.00           H  
ATOM   1106  HZ2 LYS A  79      13.404  18.900   9.618  1.00  0.00           H  
ATOM   1107  HZ3 LYS A  79      12.146  20.004   9.376  1.00  0.00           H  
ATOM   1108  N   VAL A  80      13.731  16.138  15.431  1.00  0.00           N  
ATOM   1109  CA  VAL A  80      13.404  14.729  15.257  1.00  0.00           C  
ATOM   1110  C   VAL A  80      12.537  14.220  16.403  1.00  0.00           C  
ATOM   1111  O   VAL A  80      12.742  14.584  17.561  1.00  0.00           O  
ATOM   1112  CB  VAL A  80      14.675  13.864  15.167  1.00  0.00           C  
ATOM   1113  CG1 VAL A  80      14.321  12.386  15.210  1.00  0.00           C  
ATOM   1114  CG2 VAL A  80      15.455  14.196  13.904  1.00  0.00           C  
ATOM   1115  H   VAL A  80      14.449  16.390  16.047  1.00  0.00           H  
ATOM   1116  HA  VAL A  80      12.856  14.625  14.331  1.00  0.00           H  
ATOM   1117  HB  VAL A  80      15.299  14.087  16.019  1.00  0.00           H  
ATOM   1118 HG11 VAL A  80      14.846  11.867  14.421  1.00  0.00           H  
ATOM   1119 HG12 VAL A  80      14.607  11.974  16.166  1.00  0.00           H  
ATOM   1120 HG13 VAL A  80      13.256  12.267  15.071  1.00  0.00           H  
ATOM   1121 HG21 VAL A  80      16.438  13.751  13.960  1.00  0.00           H  
ATOM   1122 HG22 VAL A  80      14.933  13.805  13.042  1.00  0.00           H  
ATOM   1123 HG23 VAL A  80      15.550  15.269  13.810  1.00  0.00           H  
ATOM   1124  N   LYS A  81      11.567  13.374  16.073  1.00  0.00           N  
ATOM   1125  CA  LYS A  81      10.668  12.812  17.075  1.00  0.00           C  
ATOM   1126  C   LYS A  81      11.343  11.674  17.835  1.00  0.00           C  
ATOM   1127  O   LYS A  81      11.472  11.722  19.057  1.00  0.00           O  
ATOM   1128  CB  LYS A  81       9.384  12.306  16.413  1.00  0.00           C  
ATOM   1129  CG  LYS A  81       8.683  13.355  15.567  1.00  0.00           C  
ATOM   1130  CD  LYS A  81       8.376  14.606  16.372  1.00  0.00           C  
ATOM   1131  CE  LYS A  81       9.485  15.639  16.241  1.00  0.00           C  
ATOM   1132  NZ  LYS A  81       9.178  16.882  17.002  1.00  0.00           N  
ATOM   1133  H   LYS A  81      11.453  13.120  15.134  1.00  0.00           H  
ATOM   1134  HA  LYS A  81      10.417  13.596  17.773  1.00  0.00           H  
ATOM   1135  HB2 LYS A  81       9.628  11.466  15.778  1.00  0.00           H  
ATOM   1136  HB3 LYS A  81       8.701  11.978  17.182  1.00  0.00           H  
ATOM   1137  HG2 LYS A  81       9.320  13.621  14.737  1.00  0.00           H  
ATOM   1138  HG3 LYS A  81       7.757  12.941  15.194  1.00  0.00           H  
ATOM   1139  HD2 LYS A  81       7.453  15.038  16.013  1.00  0.00           H  
ATOM   1140  HD3 LYS A  81       8.269  14.337  17.414  1.00  0.00           H  
ATOM   1141  HE2 LYS A  81      10.402  15.213  16.617  1.00  0.00           H  
ATOM   1142  HE3 LYS A  81       9.605  15.887  15.196  1.00  0.00           H  
ATOM   1143  HZ1 LYS A  81       9.267  17.712  16.381  1.00  0.00           H  
ATOM   1144  HZ2 LYS A  81       9.841  16.986  17.797  1.00  0.00           H  
ATOM   1145  HZ3 LYS A  81       8.209  16.842  17.375  1.00  0.00           H  
ATOM   1146  N   ALA A  82      11.774  10.653  17.101  1.00  0.00           N  
ATOM   1147  CA  ALA A  82      12.438   9.505  17.705  1.00  0.00           C  
ATOM   1148  C   ALA A  82      13.545   8.973  16.801  1.00  0.00           C  
ATOM   1149  O   ALA A  82      13.771   9.494  15.710  1.00  0.00           O  
ATOM   1150  CB  ALA A  82      11.428   8.409  18.008  1.00  0.00           C  
ATOM   1151  H   ALA A  82      11.642  10.672  16.130  1.00  0.00           H  
ATOM   1152  HA  ALA A  82      12.875   9.826  18.641  1.00  0.00           H  
ATOM   1153  HB1 ALA A  82      10.705   8.356  17.207  1.00  0.00           H  
ATOM   1154  HB2 ALA A  82      11.939   7.461  18.095  1.00  0.00           H  
ATOM   1155  HB3 ALA A  82      10.923   8.632  18.935  1.00  0.00           H  
ATOM   1156  N   GLU A  83      14.231   7.931  17.263  1.00  0.00           N  
ATOM   1157  CA  GLU A  83      15.314   7.331  16.494  1.00  0.00           C  
ATOM   1158  C   GLU A  83      15.139   5.818  16.398  1.00  0.00           C  
ATOM   1159  O   GLU A  83      14.737   5.167  17.362  1.00  0.00           O  
ATOM   1160  CB  GLU A  83      16.666   7.658  17.134  1.00  0.00           C  
ATOM   1161  CG  GLU A  83      16.877   9.142  17.381  1.00  0.00           C  
ATOM   1162  CD  GLU A  83      18.337   9.545  17.297  1.00  0.00           C  
ATOM   1163  OE1 GLU A  83      19.065   8.964  16.464  1.00  0.00           O  
ATOM   1164  OE2 GLU A  83      18.752  10.439  18.063  1.00  0.00           O  
ATOM   1165  H   GLU A  83      14.003   7.560  18.140  1.00  0.00           H  
ATOM   1166  HA  GLU A  83      15.287   7.748  15.499  1.00  0.00           H  
ATOM   1167  HB2 GLU A  83      16.737   7.142  18.081  1.00  0.00           H  
ATOM   1168  HB3 GLU A  83      17.452   7.307  16.483  1.00  0.00           H  
ATOM   1169  HG2 GLU A  83      16.323   9.700  16.642  1.00  0.00           H  
ATOM   1170  HG3 GLU A  83      16.508   9.387  18.367  1.00  0.00           H  
ATOM   1171  N   ILE A  84      15.442   5.267  15.227  1.00  0.00           N  
ATOM   1172  CA  ILE A  84      15.318   3.832  15.004  1.00  0.00           C  
ATOM   1173  C   ILE A  84      16.072   3.043  16.069  1.00  0.00           C  
ATOM   1174  O   ILE A  84      17.141   3.453  16.519  1.00  0.00           O  
ATOM   1175  CB  ILE A  84      15.846   3.431  13.613  1.00  0.00           C  
ATOM   1176  CG1 ILE A  84      15.080   4.175  12.519  1.00  0.00           C  
ATOM   1177  CG2 ILE A  84      15.733   1.926  13.418  1.00  0.00           C  
ATOM   1178  CD1 ILE A  84      15.813   4.227  11.196  1.00  0.00           C  
ATOM   1179  H   ILE A  84      15.757   5.839  14.496  1.00  0.00           H  
ATOM   1180  HA  ILE A  84      14.270   3.576  15.056  1.00  0.00           H  
ATOM   1181  HB  ILE A  84      16.890   3.699  13.558  1.00  0.00           H  
ATOM   1182 HG12 ILE A  84      14.134   3.685  12.353  1.00  0.00           H  
ATOM   1183 HG13 ILE A  84      14.903   5.191  12.841  1.00  0.00           H  
ATOM   1184 HG21 ILE A  84      15.236   1.489  14.272  1.00  0.00           H  
ATOM   1185 HG22 ILE A  84      15.160   1.722  12.526  1.00  0.00           H  
ATOM   1186 HG23 ILE A  84      16.720   1.500  13.318  1.00  0.00           H  
ATOM   1187 HD11 ILE A  84      15.462   3.429  10.558  1.00  0.00           H  
ATOM   1188 HD12 ILE A  84      15.631   5.178  10.720  1.00  0.00           H  
ATOM   1189 HD13 ILE A  84      16.874   4.107  11.369  1.00  0.00           H  
ATOM   1190  N   SER A  85      15.507   1.907  16.467  1.00  0.00           N  
ATOM   1191  CA  SER A  85      16.125   1.061  17.481  1.00  0.00           C  
ATOM   1192  C   SER A  85      16.570  -0.270  16.880  1.00  0.00           C  
ATOM   1193  O   SER A  85      17.687  -0.729  17.120  1.00  0.00           O  
ATOM   1194  CB  SER A  85      15.148   0.812  18.632  1.00  0.00           C  
ATOM   1195  OG  SER A  85      14.742   2.032  19.229  1.00  0.00           O  
ATOM   1196  H   SER A  85      14.653   1.634  16.071  1.00  0.00           H  
ATOM   1197  HA  SER A  85      16.992   1.579  17.862  1.00  0.00           H  
ATOM   1198  HB2 SER A  85      14.275   0.302  18.256  1.00  0.00           H  
ATOM   1199  HB3 SER A  85      15.628   0.201  19.382  1.00  0.00           H  
ATOM   1200  HG  SER A  85      13.928   2.333  18.821  1.00  0.00           H  
ATOM   1201  N   PHE A  86      15.688  -0.883  16.099  1.00  0.00           N  
ATOM   1202  CA  PHE A  86      15.989  -2.161  15.464  1.00  0.00           C  
ATOM   1203  C   PHE A  86      15.124  -2.369  14.223  1.00  0.00           C  
ATOM   1204  O   PHE A  86      14.141  -1.658  14.013  1.00  0.00           O  
ATOM   1205  CB  PHE A  86      15.769  -3.309  16.451  1.00  0.00           C  
ATOM   1206  CG  PHE A  86      16.617  -3.208  17.686  1.00  0.00           C  
ATOM   1207  CD1 PHE A  86      17.941  -3.618  17.668  1.00  0.00           C  
ATOM   1208  CD2 PHE A  86      16.091  -2.705  18.865  1.00  0.00           C  
ATOM   1209  CE1 PHE A  86      18.724  -3.527  18.804  1.00  0.00           C  
ATOM   1210  CE2 PHE A  86      16.869  -2.612  20.003  1.00  0.00           C  
ATOM   1211  CZ  PHE A  86      18.188  -3.023  19.972  1.00  0.00           C  
ATOM   1212  H   PHE A  86      14.814  -0.466  15.945  1.00  0.00           H  
ATOM   1213  HA  PHE A  86      17.026  -2.147  15.167  1.00  0.00           H  
ATOM   1214  HB2 PHE A  86      14.734  -3.315  16.760  1.00  0.00           H  
ATOM   1215  HB3 PHE A  86      16.000  -4.243  15.963  1.00  0.00           H  
ATOM   1216  HD1 PHE A  86      18.361  -4.011  16.755  1.00  0.00           H  
ATOM   1217  HD2 PHE A  86      15.060  -2.383  18.890  1.00  0.00           H  
ATOM   1218  HE1 PHE A  86      19.754  -3.849  18.776  1.00  0.00           H  
ATOM   1219  HE2 PHE A  86      16.447  -2.217  20.916  1.00  0.00           H  
ATOM   1220  HZ  PHE A  86      18.797  -2.951  20.861  1.00  0.00           H  
ATOM   1221  N   VAL A  87      15.499  -3.347  13.406  1.00  0.00           N  
ATOM   1222  CA  VAL A  87      14.759  -3.649  12.185  1.00  0.00           C  
ATOM   1223  C   VAL A  87      13.969  -4.945  12.330  1.00  0.00           C  
ATOM   1224  O   VAL A  87      14.540  -6.036  12.343  1.00  0.00           O  
ATOM   1225  CB  VAL A  87      15.701  -3.767  10.973  1.00  0.00           C  
ATOM   1226  CG1 VAL A  87      14.913  -4.110   9.717  1.00  0.00           C  
ATOM   1227  CG2 VAL A  87      16.489  -2.480  10.783  1.00  0.00           C  
ATOM   1228  H   VAL A  87      16.292  -3.878  13.628  1.00  0.00           H  
ATOM   1229  HA  VAL A  87      14.071  -2.837  12.003  1.00  0.00           H  
ATOM   1230  HB  VAL A  87      16.400  -4.569  11.162  1.00  0.00           H  
ATOM   1231 HG11 VAL A  87      13.862  -4.170   9.957  1.00  0.00           H  
ATOM   1232 HG12 VAL A  87      15.072  -3.344   8.972  1.00  0.00           H  
ATOM   1233 HG13 VAL A  87      15.248  -5.062   9.332  1.00  0.00           H  
ATOM   1234 HG21 VAL A  87      15.832  -1.707  10.415  1.00  0.00           H  
ATOM   1235 HG22 VAL A  87      16.911  -2.173  11.730  1.00  0.00           H  
ATOM   1236 HG23 VAL A  87      17.285  -2.646  10.072  1.00  0.00           H  
ATOM   1237  N   LEU A  88      12.651  -4.818  12.438  1.00  0.00           N  
ATOM   1238  CA  LEU A  88      11.780  -5.980  12.581  1.00  0.00           C  
ATOM   1239  C   LEU A  88      11.723  -6.780  11.284  1.00  0.00           C  
ATOM   1240  O   LEU A  88      11.654  -6.212  10.194  1.00  0.00           O  
ATOM   1241  CB  LEU A  88      10.371  -5.539  12.983  1.00  0.00           C  
ATOM   1242  CG  LEU A  88      10.282  -4.585  14.174  1.00  0.00           C  
ATOM   1243  CD1 LEU A  88       8.918  -3.912  14.217  1.00  0.00           C  
ATOM   1244  CD2 LEU A  88      10.553  -5.326  15.474  1.00  0.00           C  
ATOM   1245  H   LEU A  88      12.254  -3.923  12.421  1.00  0.00           H  
ATOM   1246  HA  LEU A  88      12.188  -6.607  13.360  1.00  0.00           H  
ATOM   1247  HB2 LEU A  88       9.922  -5.050  12.133  1.00  0.00           H  
ATOM   1248  HB3 LEU A  88       9.805  -6.427  13.226  1.00  0.00           H  
ATOM   1249  HG  LEU A  88      11.031  -3.811  14.065  1.00  0.00           H  
ATOM   1250 HD11 LEU A  88       8.672  -3.533  13.236  1.00  0.00           H  
ATOM   1251 HD12 LEU A  88       8.942  -3.095  14.923  1.00  0.00           H  
ATOM   1252 HD13 LEU A  88       8.172  -4.630  14.524  1.00  0.00           H  
ATOM   1253 HD21 LEU A  88       9.618  -5.652  15.905  1.00  0.00           H  
ATOM   1254 HD22 LEU A  88      11.058  -4.667  16.166  1.00  0.00           H  
ATOM   1255 HD23 LEU A  88      11.177  -6.185  15.275  1.00  0.00           H  
ATOM   1256  N   CYS A  89      11.752  -8.103  11.409  1.00  0.00           N  
ATOM   1257  CA  CYS A  89      11.702  -8.983  10.247  1.00  0.00           C  
ATOM   1258  C   CYS A  89      10.370  -9.721  10.181  1.00  0.00           C  
ATOM   1259  O   CYS A  89       9.654  -9.825  11.176  1.00  0.00           O  
ATOM   1260  CB  CYS A  89      12.855  -9.988  10.293  1.00  0.00           C  
ATOM   1261  SG  CYS A  89      14.488  -9.249  10.060  1.00  0.00           S  
ATOM   1262  H   CYS A  89      11.808  -8.498  12.305  1.00  0.00           H  
ATOM   1263  HA  CYS A  89      11.805  -8.370   9.364  1.00  0.00           H  
ATOM   1264  HB2 CYS A  89      12.853 -10.483  11.253  1.00  0.00           H  
ATOM   1265  HB3 CYS A  89      12.711 -10.724   9.516  1.00  0.00           H  
ATOM   1266  HG  CYS A  89      14.942  -8.877  11.246  1.00  0.00           H  
ATOM   1267  N   LYS A  90      10.041 -10.231   8.998  1.00  0.00           N  
ATOM   1268  CA  LYS A  90       8.794 -10.960   8.800  1.00  0.00           C  
ATOM   1269  C   LYS A  90       8.452 -11.800  10.027  1.00  0.00           C  
ATOM   1270  O   LYS A  90       7.290 -11.895  10.422  1.00  0.00           O  
ATOM   1271  CB  LYS A  90       8.895 -11.860   7.566  1.00  0.00           C  
ATOM   1272  CG  LYS A  90       7.548 -12.277   7.005  1.00  0.00           C  
ATOM   1273  CD  LYS A  90       7.699 -13.041   5.700  1.00  0.00           C  
ATOM   1274  CE  LYS A  90       8.199 -14.458   5.939  1.00  0.00           C  
ATOM   1275  NZ  LYS A  90       8.244 -15.251   4.679  1.00  0.00           N  
ATOM   1276  H   LYS A  90      10.652 -10.115   8.240  1.00  0.00           H  
ATOM   1277  HA  LYS A  90       8.008 -10.237   8.643  1.00  0.00           H  
ATOM   1278  HB2 LYS A  90       9.435 -11.331   6.794  1.00  0.00           H  
ATOM   1279  HB3 LYS A  90       9.444 -12.753   7.830  1.00  0.00           H  
ATOM   1280  HG2 LYS A  90       7.048 -12.909   7.723  1.00  0.00           H  
ATOM   1281  HG3 LYS A  90       6.953 -11.393   6.825  1.00  0.00           H  
ATOM   1282  HD2 LYS A  90       6.739 -13.089   5.206  1.00  0.00           H  
ATOM   1283  HD3 LYS A  90       8.405 -12.522   5.068  1.00  0.00           H  
ATOM   1284  HE2 LYS A  90       9.192 -14.409   6.359  1.00  0.00           H  
ATOM   1285  HE3 LYS A  90       7.536 -14.946   6.638  1.00  0.00           H  
ATOM   1286  HZ1 LYS A  90       7.437 -15.001   4.072  1.00  0.00           H  
ATOM   1287  HZ2 LYS A  90       8.200 -16.267   4.895  1.00  0.00           H  
ATOM   1288  HZ3 LYS A  90       9.126 -15.054   4.164  1.00  0.00           H  
ATOM   1289  N   ASP A  91       9.472 -12.404  10.626  1.00  0.00           N  
ATOM   1290  CA  ASP A  91       9.281 -13.234  11.809  1.00  0.00           C  
ATOM   1291  C   ASP A  91       8.918 -12.378  13.020  1.00  0.00           C  
ATOM   1292  O   ASP A  91       7.831 -12.510  13.584  1.00  0.00           O  
ATOM   1293  CB  ASP A  91      10.545 -14.042  12.103  1.00  0.00           C  
ATOM   1294  CG  ASP A  91      11.025 -14.823  10.894  1.00  0.00           C  
ATOM   1295  OD1 ASP A  91      11.545 -14.193   9.949  1.00  0.00           O  
ATOM   1296  OD2 ASP A  91      10.883 -16.063  10.895  1.00  0.00           O  
ATOM   1297  H   ASP A  91      10.376 -12.289  10.264  1.00  0.00           H  
ATOM   1298  HA  ASP A  91       8.467 -13.915  11.610  1.00  0.00           H  
ATOM   1299  HB2 ASP A  91      11.332 -13.370  12.409  1.00  0.00           H  
ATOM   1300  HB3 ASP A  91      10.341 -14.740  12.902  1.00  0.00           H  
ATOM   1301  N   HIS A  92       9.836 -11.500  13.415  1.00  0.00           N  
ATOM   1302  CA  HIS A  92       9.613 -10.624  14.558  1.00  0.00           C  
ATOM   1303  C   HIS A  92       8.168 -10.134  14.594  1.00  0.00           C  
ATOM   1304  O   HIS A  92       7.422 -10.436  15.527  1.00  0.00           O  
ATOM   1305  CB  HIS A  92      10.567  -9.429  14.505  1.00  0.00           C  
ATOM   1306  CG  HIS A  92      10.830  -8.814  15.845  1.00  0.00           C  
ATOM   1307  ND1 HIS A  92      12.021  -8.201  16.170  1.00  0.00           N  
ATOM   1308  CD2 HIS A  92      10.046  -8.717  16.945  1.00  0.00           C  
ATOM   1309  CE1 HIS A  92      11.961  -7.756  17.412  1.00  0.00           C  
ATOM   1310  NE2 HIS A  92      10.773  -8.056  17.905  1.00  0.00           N  
ATOM   1311  H   HIS A  92      10.681 -11.442  12.924  1.00  0.00           H  
ATOM   1312  HA  HIS A  92       9.810 -11.191  15.455  1.00  0.00           H  
ATOM   1313  HB2 HIS A  92      11.513  -9.751  14.096  1.00  0.00           H  
ATOM   1314  HB3 HIS A  92      10.143  -8.668  13.866  1.00  0.00           H  
ATOM   1315  HD1 HIS A  92      12.797  -8.108  15.578  1.00  0.00           H  
ATOM   1316  HD2 HIS A  92       9.037  -9.091  17.049  1.00  0.00           H  
ATOM   1317  HE1 HIS A  92      12.748  -7.234  17.937  1.00  0.00           H  
ATOM   1318  HE2 HIS A  92      10.495  -7.916  18.833  1.00  0.00           H  
ATOM   1319  N   VAL A  93       7.779  -9.377  13.574  1.00  0.00           N  
ATOM   1320  CA  VAL A  93       6.423  -8.846  13.489  1.00  0.00           C  
ATOM   1321  C   VAL A  93       5.405  -9.854  14.010  1.00  0.00           C  
ATOM   1322  O   VAL A  93       4.630  -9.556  14.919  1.00  0.00           O  
ATOM   1323  CB  VAL A  93       6.059  -8.466  12.042  1.00  0.00           C  
ATOM   1324  CG1 VAL A  93       4.614  -8.001  11.959  1.00  0.00           C  
ATOM   1325  CG2 VAL A  93       7.003  -7.393  11.519  1.00  0.00           C  
ATOM   1326  H   VAL A  93       8.418  -9.170  12.861  1.00  0.00           H  
ATOM   1327  HA  VAL A  93       6.375  -7.954  14.096  1.00  0.00           H  
ATOM   1328  HB  VAL A  93       6.167  -9.344  11.422  1.00  0.00           H  
ATOM   1329 HG11 VAL A  93       3.988  -8.823  11.647  1.00  0.00           H  
ATOM   1330 HG12 VAL A  93       4.291  -7.650  12.929  1.00  0.00           H  
ATOM   1331 HG13 VAL A  93       4.534  -7.197  11.241  1.00  0.00           H  
ATOM   1332 HG21 VAL A  93       7.397  -7.698  10.561  1.00  0.00           H  
ATOM   1333 HG22 VAL A  93       6.467  -6.462  11.408  1.00  0.00           H  
ATOM   1334 HG23 VAL A  93       7.817  -7.258  12.216  1.00  0.00           H  
ATOM   1335  N   ARG A  94       5.412 -11.049  13.428  1.00  0.00           N  
ATOM   1336  CA  ARG A  94       4.489 -12.101  13.833  1.00  0.00           C  
ATOM   1337  C   ARG A  94       4.583 -12.359  15.334  1.00  0.00           C  
ATOM   1338  O   ARG A  94       3.567 -12.471  16.019  1.00  0.00           O  
ATOM   1339  CB  ARG A  94       4.782 -13.391  13.063  1.00  0.00           C  
ATOM   1340  CG  ARG A  94       4.036 -13.495  11.743  1.00  0.00           C  
ATOM   1341  CD  ARG A  94       4.738 -12.715  10.642  1.00  0.00           C  
ATOM   1342  NE  ARG A  94       3.840 -12.402   9.534  1.00  0.00           N  
ATOM   1343  CZ  ARG A  94       3.455 -13.292   8.625  1.00  0.00           C  
ATOM   1344  NH1 ARG A  94       3.889 -14.543   8.693  1.00  0.00           N  
ATOM   1345  NH2 ARG A  94       2.636 -12.930   7.647  1.00  0.00           N  
ATOM   1346  H   ARG A  94       6.054 -11.226  12.708  1.00  0.00           H  
ATOM   1347  HA  ARG A  94       3.488 -11.772  13.598  1.00  0.00           H  
ATOM   1348  HB2 ARG A  94       5.842 -13.440  12.857  1.00  0.00           H  
ATOM   1349  HB3 ARG A  94       4.503 -14.233  13.677  1.00  0.00           H  
ATOM   1350  HG2 ARG A  94       3.980 -14.534  11.453  1.00  0.00           H  
ATOM   1351  HG3 ARG A  94       3.039 -13.100  11.871  1.00  0.00           H  
ATOM   1352  HD2 ARG A  94       5.117 -11.794  11.058  1.00  0.00           H  
ATOM   1353  HD3 ARG A  94       5.560 -13.307  10.270  1.00  0.00           H  
ATOM   1354  HE  ARG A  94       3.507 -11.483   9.465  1.00  0.00           H  
ATOM   1355 HH11 ARG A  94       4.506 -14.818   9.430  1.00  0.00           H  
ATOM   1356 HH12 ARG A  94       3.597 -15.211   8.008  1.00  0.00           H  
ATOM   1357 HH21 ARG A  94       2.307 -11.988   7.593  1.00  0.00           H  
ATOM   1358 HH22 ARG A  94       2.347 -13.600   6.964  1.00  0.00           H  
ATOM   1359  N   SER A  95       5.809 -12.455  15.837  1.00  0.00           N  
ATOM   1360  CA  SER A  95       6.036 -12.704  17.256  1.00  0.00           C  
ATOM   1361  C   SER A  95       5.281 -11.693  18.112  1.00  0.00           C  
ATOM   1362  O   SER A  95       4.466 -12.065  18.958  1.00  0.00           O  
ATOM   1363  CB  SER A  95       7.532 -12.643  17.572  1.00  0.00           C  
ATOM   1364  OG  SER A  95       8.254 -13.593  16.809  1.00  0.00           O  
ATOM   1365  H   SER A  95       6.580 -12.357  15.238  1.00  0.00           H  
ATOM   1366  HA  SER A  95       5.670 -13.694  17.480  1.00  0.00           H  
ATOM   1367  HB2 SER A  95       7.906 -11.656  17.344  1.00  0.00           H  
ATOM   1368  HB3 SER A  95       7.684 -12.852  18.622  1.00  0.00           H  
ATOM   1369  HG  SER A  95       8.973 -13.948  17.337  1.00  0.00           H  
ATOM   1370  N   LEU A  96       5.558 -10.414  17.889  1.00  0.00           N  
ATOM   1371  CA  LEU A  96       4.905  -9.346  18.640  1.00  0.00           C  
ATOM   1372  C   LEU A  96       3.388  -9.501  18.598  1.00  0.00           C  
ATOM   1373  O   LEU A  96       2.703  -9.257  19.592  1.00  0.00           O  
ATOM   1374  CB  LEU A  96       5.305  -7.982  18.076  1.00  0.00           C  
ATOM   1375  CG  LEU A  96       6.741  -7.535  18.356  1.00  0.00           C  
ATOM   1376  CD1 LEU A  96       7.109  -6.345  17.485  1.00  0.00           C  
ATOM   1377  CD2 LEU A  96       6.917  -7.196  19.829  1.00  0.00           C  
ATOM   1378  H   LEU A  96       6.216 -10.179  17.202  1.00  0.00           H  
ATOM   1379  HA  LEU A  96       5.235  -9.415  19.666  1.00  0.00           H  
ATOM   1380  HB2 LEU A  96       5.171  -8.013  17.007  1.00  0.00           H  
ATOM   1381  HB3 LEU A  96       4.640  -7.242  18.500  1.00  0.00           H  
ATOM   1382  HG  LEU A  96       7.416  -8.345  18.116  1.00  0.00           H  
ATOM   1383 HD11 LEU A  96       6.366  -6.223  16.710  1.00  0.00           H  
ATOM   1384 HD12 LEU A  96       8.075  -6.514  17.033  1.00  0.00           H  
ATOM   1385 HD13 LEU A  96       7.147  -5.453  18.092  1.00  0.00           H  
ATOM   1386 HD21 LEU A  96       7.510  -7.962  20.306  1.00  0.00           H  
ATOM   1387 HD22 LEU A  96       5.948  -7.141  20.304  1.00  0.00           H  
ATOM   1388 HD23 LEU A  96       7.418  -6.244  19.921  1.00  0.00           H  
ATOM   1389  N   GLN A  97       2.871  -9.911  17.444  1.00  0.00           N  
ATOM   1390  CA  GLN A  97       1.435 -10.100  17.276  1.00  0.00           C  
ATOM   1391  C   GLN A  97       0.909 -11.160  18.237  1.00  0.00           C  
ATOM   1392  O   GLN A  97      -0.152 -10.995  18.841  1.00  0.00           O  
ATOM   1393  CB  GLN A  97       1.118 -10.500  15.834  1.00  0.00           C  
ATOM   1394  CG  GLN A  97       1.394  -9.399  14.823  1.00  0.00           C  
ATOM   1395  CD  GLN A  97       1.004  -9.791  13.412  1.00  0.00           C  
ATOM   1396  OE1 GLN A  97       1.432 -10.828  12.903  1.00  0.00           O  
ATOM   1397  NE2 GLN A  97       0.186  -8.964  12.771  1.00  0.00           N  
ATOM   1398  H   GLN A  97       3.469 -10.090  16.690  1.00  0.00           H  
ATOM   1399  HA  GLN A  97       0.949  -9.161  17.495  1.00  0.00           H  
ATOM   1400  HB2 GLN A  97       1.717 -11.359  15.572  1.00  0.00           H  
ATOM   1401  HB3 GLN A  97       0.073 -10.765  15.768  1.00  0.00           H  
ATOM   1402  HG2 GLN A  97       0.832  -8.520  15.103  1.00  0.00           H  
ATOM   1403  HG3 GLN A  97       2.449  -9.170  14.838  1.00  0.00           H  
ATOM   1404 HE21 GLN A  97      -0.114  -8.156  13.239  1.00  0.00           H  
ATOM   1405 HE22 GLN A  97      -0.081  -9.193  11.857  1.00  0.00           H  
ATOM   1406  N   LYS A  98       1.657 -12.249  18.377  1.00  0.00           N  
ATOM   1407  CA  LYS A  98       1.267 -13.337  19.266  1.00  0.00           C  
ATOM   1408  C   LYS A  98       1.410 -12.924  20.728  1.00  0.00           C  
ATOM   1409  O   LYS A  98       0.517 -13.162  21.539  1.00  0.00           O  
ATOM   1410  CB  LYS A  98       2.119 -14.579  18.990  1.00  0.00           C  
ATOM   1411  CG  LYS A  98       1.871 -15.194  17.624  1.00  0.00           C  
ATOM   1412  CD  LYS A  98       2.450 -16.597  17.531  1.00  0.00           C  
ATOM   1413  CE  LYS A  98       2.641 -17.026  16.085  1.00  0.00           C  
ATOM   1414  NZ  LYS A  98       3.768 -16.302  15.434  1.00  0.00           N  
ATOM   1415  H   LYS A  98       2.492 -12.323  17.869  1.00  0.00           H  
ATOM   1416  HA  LYS A  98       0.232 -13.570  19.070  1.00  0.00           H  
ATOM   1417  HB2 LYS A  98       3.162 -14.306  19.056  1.00  0.00           H  
ATOM   1418  HB3 LYS A  98       1.902 -15.323  19.742  1.00  0.00           H  
ATOM   1419  HG2 LYS A  98       0.806 -15.245  17.449  1.00  0.00           H  
ATOM   1420  HG3 LYS A  98       2.333 -14.574  16.869  1.00  0.00           H  
ATOM   1421  HD2 LYS A  98       3.408 -16.615  18.029  1.00  0.00           H  
ATOM   1422  HD3 LYS A  98       1.777 -17.287  18.018  1.00  0.00           H  
ATOM   1423  HE2 LYS A  98       2.845 -18.086  16.062  1.00  0.00           H  
ATOM   1424  HE3 LYS A  98       1.731 -16.822  15.540  1.00  0.00           H  
ATOM   1425  HZ1 LYS A  98       4.330 -15.799  16.152  1.00  0.00           H  
ATOM   1426  HZ2 LYS A  98       3.402 -15.609  14.751  1.00  0.00           H  
ATOM   1427  HZ3 LYS A  98       4.385 -16.974  14.935  1.00  0.00           H  
ATOM   1428  N   GLU A  99       2.539 -12.302  21.053  1.00  0.00           N  
ATOM   1429  CA  GLU A  99       2.798 -11.855  22.417  1.00  0.00           C  
ATOM   1430  C   GLU A  99       1.758 -10.829  22.860  1.00  0.00           C  
ATOM   1431  O   GLU A  99       1.524 -10.641  24.053  1.00  0.00           O  
ATOM   1432  CB  GLU A  99       4.200 -11.254  22.523  1.00  0.00           C  
ATOM   1433  CG  GLU A  99       5.307 -12.219  22.134  1.00  0.00           C  
ATOM   1434  CD  GLU A  99       6.685 -11.592  22.221  1.00  0.00           C  
ATOM   1435  OE1 GLU A  99       7.103 -10.941  21.241  1.00  0.00           O  
ATOM   1436  OE2 GLU A  99       7.346 -11.753  23.268  1.00  0.00           O  
ATOM   1437  H   GLU A  99       3.214 -12.141  20.362  1.00  0.00           H  
ATOM   1438  HA  GLU A  99       2.735 -12.716  23.065  1.00  0.00           H  
ATOM   1439  HB2 GLU A  99       4.259 -10.391  21.877  1.00  0.00           H  
ATOM   1440  HB3 GLU A  99       4.367 -10.940  23.544  1.00  0.00           H  
ATOM   1441  HG2 GLU A  99       5.274 -13.071  22.796  1.00  0.00           H  
ATOM   1442  HG3 GLU A  99       5.141 -12.547  21.118  1.00  0.00           H  
ATOM   1443  N   GLY A 100       1.135 -10.169  21.888  1.00  0.00           N  
ATOM   1444  CA  GLY A 100       0.128  -9.171  22.196  1.00  0.00           C  
ATOM   1445  C   GLY A 100       0.719  -7.784  22.363  1.00  0.00           C  
ATOM   1446  O   GLY A 100       0.469  -7.111  23.363  1.00  0.00           O  
ATOM   1447  H   GLY A 100       1.361 -10.362  20.954  1.00  0.00           H  
ATOM   1448  HA2 GLY A 100      -0.598  -9.148  21.398  1.00  0.00           H  
ATOM   1449  HA3 GLY A 100      -0.370  -9.450  23.114  1.00  0.00           H  
ATOM   1450  N   PHE A 101       1.504  -7.356  21.381  1.00  0.00           N  
ATOM   1451  CA  PHE A 101       2.135  -6.042  21.423  1.00  0.00           C  
ATOM   1452  C   PHE A 101       1.908  -5.288  20.117  1.00  0.00           C  
ATOM   1453  O   PHE A 101       1.650  -4.084  20.121  1.00  0.00           O  
ATOM   1454  CB  PHE A 101       3.635  -6.180  21.692  1.00  0.00           C  
ATOM   1455  CG  PHE A 101       3.952  -6.784  23.029  1.00  0.00           C  
ATOM   1456  CD1 PHE A 101       3.562  -6.153  24.199  1.00  0.00           C  
ATOM   1457  CD2 PHE A 101       4.639  -7.984  23.118  1.00  0.00           C  
ATOM   1458  CE1 PHE A 101       3.853  -6.706  25.432  1.00  0.00           C  
ATOM   1459  CE2 PHE A 101       4.932  -8.543  24.348  1.00  0.00           C  
ATOM   1460  CZ  PHE A 101       4.537  -7.903  25.506  1.00  0.00           C  
ATOM   1461  H   PHE A 101       1.666  -7.939  20.608  1.00  0.00           H  
ATOM   1462  HA  PHE A 101       1.683  -5.485  22.230  1.00  0.00           H  
ATOM   1463  HB2 PHE A 101       4.073  -6.811  20.932  1.00  0.00           H  
ATOM   1464  HB3 PHE A 101       4.092  -5.203  21.650  1.00  0.00           H  
ATOM   1465  HD1 PHE A 101       3.025  -5.217  24.143  1.00  0.00           H  
ATOM   1466  HD2 PHE A 101       4.948  -8.486  22.211  1.00  0.00           H  
ATOM   1467  HE1 PHE A 101       3.543  -6.204  26.337  1.00  0.00           H  
ATOM   1468  HE2 PHE A 101       5.468  -9.479  24.402  1.00  0.00           H  
ATOM   1469  HZ  PHE A 101       4.766  -8.338  26.469  1.00  0.00           H  
ATOM   1470  N   TRP A 102       2.006  -6.002  19.003  1.00  0.00           N  
ATOM   1471  CA  TRP A 102       1.812  -5.401  17.688  1.00  0.00           C  
ATOM   1472  C   TRP A 102       0.594  -4.483  17.684  1.00  0.00           C  
ATOM   1473  O   TRP A 102      -0.445  -4.789  18.269  1.00  0.00           O  
ATOM   1474  CB  TRP A 102       1.650  -6.489  16.626  1.00  0.00           C  
ATOM   1475  CG  TRP A 102       1.673  -5.958  15.224  1.00  0.00           C  
ATOM   1476  CD1 TRP A 102       0.595  -5.641  14.450  1.00  0.00           C  
ATOM   1477  CD2 TRP A 102       2.833  -5.686  14.431  1.00  0.00           C  
ATOM   1478  NE1 TRP A 102       1.014  -5.188  13.222  1.00  0.00           N  
ATOM   1479  CE2 TRP A 102       2.383  -5.205  13.186  1.00  0.00           C  
ATOM   1480  CE3 TRP A 102       4.209  -5.799  14.652  1.00  0.00           C  
ATOM   1481  CZ2 TRP A 102       3.260  -4.839  12.168  1.00  0.00           C  
ATOM   1482  CZ3 TRP A 102       5.077  -5.435  13.640  1.00  0.00           C  
ATOM   1483  CH2 TRP A 102       4.601  -4.960  12.412  1.00  0.00           C  
ATOM   1484  H   TRP A 102       2.214  -6.959  19.064  1.00  0.00           H  
ATOM   1485  HA  TRP A 102       2.691  -4.816  17.460  1.00  0.00           H  
ATOM   1486  HB2 TRP A 102       2.453  -7.203  16.725  1.00  0.00           H  
ATOM   1487  HB3 TRP A 102       0.705  -6.991  16.777  1.00  0.00           H  
ATOM   1488  HD1 TRP A 102      -0.432  -5.740  14.767  1.00  0.00           H  
ATOM   1489  HE1 TRP A 102       0.427  -4.898  12.492  1.00  0.00           H  
ATOM   1490  HE3 TRP A 102       4.596  -6.163  15.592  1.00  0.00           H  
ATOM   1491  HZ2 TRP A 102       2.908  -4.469  11.216  1.00  0.00           H  
ATOM   1492  HZ3 TRP A 102       6.144  -5.517  13.792  1.00  0.00           H  
ATOM   1493  HH2 TRP A 102       5.315  -4.688  11.650  1.00  0.00           H  
ATOM   1494  N   PRO A 103       0.723  -3.331  17.010  1.00  0.00           N  
ATOM   1495  CA  PRO A 103      -0.358  -2.346  16.913  1.00  0.00           C  
ATOM   1496  C   PRO A 103      -1.514  -2.837  16.049  1.00  0.00           C  
ATOM   1497  O   PRO A 103      -1.365  -3.782  15.277  1.00  0.00           O  
ATOM   1498  CB  PRO A 103       0.320  -1.137  16.264  1.00  0.00           C  
ATOM   1499  CG  PRO A 103       1.465  -1.710  15.501  1.00  0.00           C  
ATOM   1500  CD  PRO A 103       1.933  -2.902  16.290  1.00  0.00           C  
ATOM   1501  HA  PRO A 103      -0.732  -2.069  17.889  1.00  0.00           H  
ATOM   1502  HB2 PRO A 103      -0.380  -0.636  15.610  1.00  0.00           H  
ATOM   1503  HB3 PRO A 103       0.658  -0.454  17.029  1.00  0.00           H  
ATOM   1504  HG2 PRO A 103       1.136  -2.016  14.519  1.00  0.00           H  
ATOM   1505  HG3 PRO A 103       2.255  -0.978  15.421  1.00  0.00           H  
ATOM   1506  HD2 PRO A 103       2.284  -3.678  15.627  1.00  0.00           H  
ATOM   1507  HD3 PRO A 103       2.711  -2.614  16.981  1.00  0.00           H  
ATOM   1508  N   GLU A 104      -2.666  -2.187  16.184  1.00  0.00           N  
ATOM   1509  CA  GLU A 104      -3.847  -2.558  15.414  1.00  0.00           C  
ATOM   1510  C   GLU A 104      -3.841  -1.881  14.046  1.00  0.00           C  
ATOM   1511  O   GLU A 104      -4.125  -2.511  13.028  1.00  0.00           O  
ATOM   1512  CB  GLU A 104      -5.119  -2.181  16.176  1.00  0.00           C  
ATOM   1513  CG  GLU A 104      -6.388  -2.327  15.352  1.00  0.00           C  
ATOM   1514  CD  GLU A 104      -6.954  -3.734  15.396  1.00  0.00           C  
ATOM   1515  OE1 GLU A 104      -7.327  -4.189  16.498  1.00  0.00           O  
ATOM   1516  OE2 GLU A 104      -7.023  -4.379  14.330  1.00  0.00           O  
ATOM   1517  H   GLU A 104      -2.723  -1.440  16.816  1.00  0.00           H  
ATOM   1518  HA  GLU A 104      -3.828  -3.628  15.272  1.00  0.00           H  
ATOM   1519  HB2 GLU A 104      -5.204  -2.815  17.047  1.00  0.00           H  
ATOM   1520  HB3 GLU A 104      -5.041  -1.152  16.497  1.00  0.00           H  
ATOM   1521  HG2 GLU A 104      -7.132  -1.644  15.735  1.00  0.00           H  
ATOM   1522  HG3 GLU A 104      -6.166  -2.077  14.325  1.00  0.00           H  
ATOM   1523  N   ALA A 105      -3.516  -0.592  14.032  1.00  0.00           N  
ATOM   1524  CA  ALA A 105      -3.471   0.170  12.791  1.00  0.00           C  
ATOM   1525  C   ALA A 105      -2.683  -0.573  11.718  1.00  0.00           C  
ATOM   1526  O   ALA A 105      -2.915  -0.388  10.523  1.00  0.00           O  
ATOM   1527  CB  ALA A 105      -2.865   1.544  13.037  1.00  0.00           C  
ATOM   1528  H   ALA A 105      -3.300  -0.144  14.876  1.00  0.00           H  
ATOM   1529  HA  ALA A 105      -4.486   0.309  12.447  1.00  0.00           H  
ATOM   1530  HB1 ALA A 105      -3.555   2.306  12.705  1.00  0.00           H  
ATOM   1531  HB2 ALA A 105      -2.672   1.668  14.093  1.00  0.00           H  
ATOM   1532  HB3 ALA A 105      -1.938   1.632  12.489  1.00  0.00           H  
ATOM   1533  N   PHE A 106      -1.749  -1.414  12.151  1.00  0.00           N  
ATOM   1534  CA  PHE A 106      -0.926  -2.184  11.226  1.00  0.00           C  
ATOM   1535  C   PHE A 106      -1.399  -3.633  11.155  1.00  0.00           C  
ATOM   1536  O   PHE A 106      -1.310  -4.275  10.108  1.00  0.00           O  
ATOM   1537  CB  PHE A 106       0.542  -2.135  11.657  1.00  0.00           C  
ATOM   1538  CG  PHE A 106       1.050  -0.743  11.898  1.00  0.00           C  
ATOM   1539  CD1 PHE A 106       0.409   0.350  11.337  1.00  0.00           C  
ATOM   1540  CD2 PHE A 106       2.169  -0.527  12.685  1.00  0.00           C  
ATOM   1541  CE1 PHE A 106       0.873   1.633  11.557  1.00  0.00           C  
ATOM   1542  CE2 PHE A 106       2.639   0.754  12.909  1.00  0.00           C  
ATOM   1543  CZ  PHE A 106       1.990   1.835  12.344  1.00  0.00           C  
ATOM   1544  H   PHE A 106      -1.611  -1.518  13.116  1.00  0.00           H  
ATOM   1545  HA  PHE A 106      -1.021  -1.738  10.249  1.00  0.00           H  
ATOM   1546  HB2 PHE A 106       0.660  -2.694  12.572  1.00  0.00           H  
ATOM   1547  HB3 PHE A 106       1.150  -2.583  10.885  1.00  0.00           H  
ATOM   1548  HD1 PHE A 106      -0.466   0.193  10.722  1.00  0.00           H  
ATOM   1549  HD2 PHE A 106       2.678  -1.371  13.127  1.00  0.00           H  
ATOM   1550  HE1 PHE A 106       0.364   2.475  11.114  1.00  0.00           H  
ATOM   1551  HE2 PHE A 106       3.512   0.909  13.525  1.00  0.00           H  
ATOM   1552  HZ  PHE A 106       2.355   2.837  12.518  1.00  0.00           H  
ATOM   1553  N   SER A 107      -1.900  -4.142  12.276  1.00  0.00           N  
ATOM   1554  CA  SER A 107      -2.384  -5.516  12.342  1.00  0.00           C  
ATOM   1555  C   SER A 107      -3.164  -5.879  11.082  1.00  0.00           C  
ATOM   1556  O   SER A 107      -3.122  -7.020  10.621  1.00  0.00           O  
ATOM   1557  CB  SER A 107      -3.268  -5.709  13.576  1.00  0.00           C  
ATOM   1558  OG  SER A 107      -3.337  -7.075  13.945  1.00  0.00           O  
ATOM   1559  H   SER A 107      -1.945  -3.580  13.078  1.00  0.00           H  
ATOM   1560  HA  SER A 107      -1.525  -6.166  12.420  1.00  0.00           H  
ATOM   1561  HB2 SER A 107      -2.859  -5.145  14.400  1.00  0.00           H  
ATOM   1562  HB3 SER A 107      -4.267  -5.356  13.358  1.00  0.00           H  
ATOM   1563  HG  SER A 107      -4.115  -7.476  13.550  1.00  0.00           H  
ATOM   1564  N   GLU A 108      -3.874  -4.900  10.530  1.00  0.00           N  
ATOM   1565  CA  GLU A 108      -4.663  -5.117   9.324  1.00  0.00           C  
ATOM   1566  C   GLU A 108      -3.800  -4.968   8.074  1.00  0.00           C  
ATOM   1567  O   GLU A 108      -4.274  -4.521   7.029  1.00  0.00           O  
ATOM   1568  CB  GLU A 108      -5.833  -4.133   9.270  1.00  0.00           C  
ATOM   1569  CG  GLU A 108      -5.419  -2.684   9.469  1.00  0.00           C  
ATOM   1570  CD  GLU A 108      -6.568  -1.715   9.262  1.00  0.00           C  
ATOM   1571  OE1 GLU A 108      -7.700  -2.040   9.676  1.00  0.00           O  
ATOM   1572  OE2 GLU A 108      -6.333  -0.633   8.686  1.00  0.00           O  
ATOM   1573  H   GLU A 108      -3.866  -4.012  10.943  1.00  0.00           H  
ATOM   1574  HA  GLU A 108      -5.053  -6.123   9.359  1.00  0.00           H  
ATOM   1575  HB2 GLU A 108      -6.316  -4.218   8.307  1.00  0.00           H  
ATOM   1576  HB3 GLU A 108      -6.542  -4.392  10.042  1.00  0.00           H  
ATOM   1577  HG2 GLU A 108      -5.046  -2.565  10.476  1.00  0.00           H  
ATOM   1578  HG3 GLU A 108      -4.635  -2.446   8.765  1.00  0.00           H  
ATOM   1579  N   VAL A 109      -2.530  -5.344   8.191  1.00  0.00           N  
ATOM   1580  CA  VAL A 109      -1.600  -5.252   7.071  1.00  0.00           C  
ATOM   1581  C   VAL A 109      -1.022  -6.620   6.725  1.00  0.00           C  
ATOM   1582  O   VAL A 109      -1.064  -7.050   5.573  1.00  0.00           O  
ATOM   1583  CB  VAL A 109      -0.446  -4.282   7.379  1.00  0.00           C  
ATOM   1584  CG1 VAL A 109       0.649  -4.403   6.329  1.00  0.00           C  
ATOM   1585  CG2 VAL A 109      -0.960  -2.852   7.462  1.00  0.00           C  
ATOM   1586  H   VAL A 109      -2.212  -5.693   9.049  1.00  0.00           H  
ATOM   1587  HA  VAL A 109      -2.143  -4.876   6.216  1.00  0.00           H  
ATOM   1588  HB  VAL A 109      -0.024  -4.547   8.338  1.00  0.00           H  
ATOM   1589 HG11 VAL A 109       0.242  -4.163   5.357  1.00  0.00           H  
ATOM   1590 HG12 VAL A 109       1.450  -3.718   6.564  1.00  0.00           H  
ATOM   1591 HG13 VAL A 109       1.028  -5.414   6.321  1.00  0.00           H  
ATOM   1592 HG21 VAL A 109      -0.550  -2.275   6.648  1.00  0.00           H  
ATOM   1593 HG22 VAL A 109      -2.039  -2.853   7.396  1.00  0.00           H  
ATOM   1594 HG23 VAL A 109      -0.658  -2.414   8.402  1.00  0.00           H  
ATOM   1595  N   ALA A 110      -0.482  -7.301   7.732  1.00  0.00           N  
ATOM   1596  CA  ALA A 110       0.103  -8.620   7.535  1.00  0.00           C  
ATOM   1597  C   ALA A 110      -0.938  -9.613   7.028  1.00  0.00           C  
ATOM   1598  O   ALA A 110      -0.647 -10.447   6.172  1.00  0.00           O  
ATOM   1599  CB  ALA A 110       0.724  -9.121   8.830  1.00  0.00           C  
ATOM   1600  H   ALA A 110      -0.479  -6.905   8.628  1.00  0.00           H  
ATOM   1601  HA  ALA A 110       0.889  -8.530   6.799  1.00  0.00           H  
ATOM   1602  HB1 ALA A 110       0.735  -8.320   9.556  1.00  0.00           H  
ATOM   1603  HB2 ALA A 110       0.144  -9.947   9.212  1.00  0.00           H  
ATOM   1604  HB3 ALA A 110       1.735  -9.449   8.641  1.00  0.00           H  
ATOM   1605  N   GLU A 111      -2.151  -9.515   7.561  1.00  0.00           N  
ATOM   1606  CA  GLU A 111      -3.235 -10.406   7.162  1.00  0.00           C  
ATOM   1607  C   GLU A 111      -3.358 -10.466   5.643  1.00  0.00           C  
ATOM   1608  O   GLU A 111      -3.468 -11.544   5.059  1.00  0.00           O  
ATOM   1609  CB  GLU A 111      -4.558  -9.942   7.775  1.00  0.00           C  
ATOM   1610  CG  GLU A 111      -4.575  -9.987   9.293  1.00  0.00           C  
ATOM   1611  CD  GLU A 111      -4.878 -11.371   9.832  1.00  0.00           C  
ATOM   1612  OE1 GLU A 111      -4.313 -12.350   9.303  1.00  0.00           O  
ATOM   1613  OE2 GLU A 111      -5.679 -11.474  10.785  1.00  0.00           O  
ATOM   1614  H   GLU A 111      -2.322  -8.829   8.239  1.00  0.00           H  
ATOM   1615  HA  GLU A 111      -3.005 -11.393   7.532  1.00  0.00           H  
ATOM   1616  HB2 GLU A 111      -4.748  -8.925   7.463  1.00  0.00           H  
ATOM   1617  HB3 GLU A 111      -5.352 -10.575   7.407  1.00  0.00           H  
ATOM   1618  HG2 GLU A 111      -3.608  -9.677   9.661  1.00  0.00           H  
ATOM   1619  HG3 GLU A 111      -5.331  -9.304   9.653  1.00  0.00           H  
ATOM   1620  N   LYS A 112      -3.339  -9.299   5.007  1.00  0.00           N  
ATOM   1621  CA  LYS A 112      -3.448  -9.217   3.555  1.00  0.00           C  
ATOM   1622  C   LYS A 112      -2.124  -9.579   2.889  1.00  0.00           C  
ATOM   1623  O   LYS A 112      -2.081 -10.414   1.985  1.00  0.00           O  
ATOM   1624  CB  LYS A 112      -3.874  -7.808   3.134  1.00  0.00           C  
ATOM   1625  CG  LYS A 112      -5.379  -7.626   3.055  1.00  0.00           C  
ATOM   1626  CD  LYS A 112      -5.969  -8.363   1.864  1.00  0.00           C  
ATOM   1627  CE  LYS A 112      -5.667  -7.643   0.559  1.00  0.00           C  
ATOM   1628  NZ  LYS A 112      -6.446  -6.380   0.430  1.00  0.00           N  
ATOM   1629  H   LYS A 112      -3.249  -8.473   5.527  1.00  0.00           H  
ATOM   1630  HA  LYS A 112      -4.202  -9.921   3.238  1.00  0.00           H  
ATOM   1631  HB2 LYS A 112      -3.483  -7.098   3.849  1.00  0.00           H  
ATOM   1632  HB3 LYS A 112      -3.455  -7.594   2.162  1.00  0.00           H  
ATOM   1633  HG2 LYS A 112      -5.828  -8.011   3.960  1.00  0.00           H  
ATOM   1634  HG3 LYS A 112      -5.602  -6.572   2.961  1.00  0.00           H  
ATOM   1635  HD2 LYS A 112      -5.545  -9.356   1.820  1.00  0.00           H  
ATOM   1636  HD3 LYS A 112      -7.039  -8.432   1.988  1.00  0.00           H  
ATOM   1637  HE2 LYS A 112      -4.613  -7.411   0.525  1.00  0.00           H  
ATOM   1638  HE3 LYS A 112      -5.918  -8.296  -0.264  1.00  0.00           H  
ATOM   1639  HZ1 LYS A 112      -5.884  -5.664  -0.074  1.00  0.00           H  
ATOM   1640  HZ2 LYS A 112      -6.690  -6.013   1.372  1.00  0.00           H  
ATOM   1641  HZ3 LYS A 112      -7.323  -6.553  -0.101  1.00  0.00           H  
ATOM   1642  N   HIS A 113      -1.046  -8.947   3.342  1.00  0.00           N  
ATOM   1643  CA  HIS A 113       0.279  -9.205   2.791  1.00  0.00           C  
ATOM   1644  C   HIS A 113       0.555 -10.704   2.720  1.00  0.00           C  
ATOM   1645  O   HIS A 113       0.146 -11.462   3.597  1.00  0.00           O  
ATOM   1646  CB  HIS A 113       1.350  -8.516   3.638  1.00  0.00           C  
ATOM   1647  CG  HIS A 113       2.682  -8.425   2.960  1.00  0.00           C  
ATOM   1648  ND1 HIS A 113       2.984  -7.462   2.020  1.00  0.00           N  
ATOM   1649  CD2 HIS A 113       3.797  -9.183   3.091  1.00  0.00           C  
ATOM   1650  CE1 HIS A 113       4.226  -7.632   1.601  1.00  0.00           C  
ATOM   1651  NE2 HIS A 113       4.741  -8.670   2.236  1.00  0.00           N  
ATOM   1652  H   HIS A 113      -1.144  -8.292   4.064  1.00  0.00           H  
ATOM   1653  HA  HIS A 113       0.307  -8.799   1.791  1.00  0.00           H  
ATOM   1654  HB2 HIS A 113       1.026  -7.512   3.868  1.00  0.00           H  
ATOM   1655  HB3 HIS A 113       1.482  -9.067   4.558  1.00  0.00           H  
ATOM   1656  HD1 HIS A 113       2.379  -6.759   1.706  1.00  0.00           H  
ATOM   1657  HD2 HIS A 113       3.921 -10.033   3.746  1.00  0.00           H  
ATOM   1658  HE1 HIS A 113       4.734  -7.026   0.866  1.00  0.00           H  
ATOM   1659  HE2 HIS A 113       5.618  -9.065   2.052  1.00  0.00           H  
ATOM   1660  N   ASN A 114       1.252 -11.123   1.669  1.00  0.00           N  
ATOM   1661  CA  ASN A 114       1.582 -12.532   1.483  1.00  0.00           C  
ATOM   1662  C   ASN A 114       2.838 -12.689   0.630  1.00  0.00           C  
ATOM   1663  O   ASN A 114       3.203 -11.789  -0.127  1.00  0.00           O  
ATOM   1664  CB  ASN A 114       0.413 -13.269   0.828  1.00  0.00           C  
ATOM   1665  CG  ASN A 114       0.224 -12.877  -0.625  1.00  0.00           C  
ATOM   1666  OD1 ASN A 114       1.181 -12.530  -1.316  1.00  0.00           O  
ATOM   1667  ND2 ASN A 114      -1.017 -12.931  -1.096  1.00  0.00           N  
ATOM   1668  H   ASN A 114       1.552 -10.470   1.002  1.00  0.00           H  
ATOM   1669  HA  ASN A 114       1.767 -12.960   2.456  1.00  0.00           H  
ATOM   1670  HB2 ASN A 114       0.595 -14.333   0.873  1.00  0.00           H  
ATOM   1671  HB3 ASN A 114      -0.496 -13.041   1.364  1.00  0.00           H  
ATOM   1672 HD21 ASN A 114      -1.731 -13.217  -0.488  1.00  0.00           H  
ATOM   1673 HD22 ASN A 114      -1.168 -12.685  -2.032  1.00  0.00           H  
ATOM   1674  N   SER A 115       3.495 -13.837   0.761  1.00  0.00           N  
ATOM   1675  CA  SER A 115       4.712 -14.110   0.005  1.00  0.00           C  
ATOM   1676  C   SER A 115       4.413 -14.985  -1.209  1.00  0.00           C  
ATOM   1677  O   SER A 115       3.799 -16.043  -1.088  1.00  0.00           O  
ATOM   1678  CB  SER A 115       5.749 -14.795   0.898  1.00  0.00           C  
ATOM   1679  OG  SER A 115       6.533 -13.841   1.593  1.00  0.00           O  
ATOM   1680  H   SER A 115       3.155 -14.514   1.381  1.00  0.00           H  
ATOM   1681  HA  SER A 115       5.110 -13.166  -0.336  1.00  0.00           H  
ATOM   1682  HB2 SER A 115       5.244 -15.420   1.618  1.00  0.00           H  
ATOM   1683  HB3 SER A 115       6.401 -15.402   0.287  1.00  0.00           H  
ATOM   1684  HG  SER A 115       6.692 -14.147   2.488  1.00  0.00           H  
ATOM   1685  N   GLY A 116       4.854 -14.533  -2.379  1.00  0.00           N  
ATOM   1686  CA  GLY A 116       4.624 -15.286  -3.599  1.00  0.00           C  
ATOM   1687  C   GLY A 116       3.424 -14.779  -4.374  1.00  0.00           C  
ATOM   1688  O   GLY A 116       2.995 -13.636  -4.220  1.00  0.00           O  
ATOM   1689  H   GLY A 116       5.338 -13.681  -2.414  1.00  0.00           H  
ATOM   1690  HA2 GLY A 116       5.501 -15.213  -4.224  1.00  0.00           H  
ATOM   1691  HA3 GLY A 116       4.462 -16.322  -3.343  1.00  0.00           H  
ATOM   1692  N   PRO A 117       2.863 -15.643  -5.234  1.00  0.00           N  
ATOM   1693  CA  PRO A 117       1.699 -15.299  -6.055  1.00  0.00           C  
ATOM   1694  C   PRO A 117       0.428 -15.148  -5.225  1.00  0.00           C  
ATOM   1695  O   PRO A 117       0.087 -16.025  -4.430  1.00  0.00           O  
ATOM   1696  CB  PRO A 117       1.575 -16.489  -7.011  1.00  0.00           C  
ATOM   1697  CG  PRO A 117       2.213 -17.624  -6.287  1.00  0.00           C  
ATOM   1698  CD  PRO A 117       3.322 -17.022  -5.470  1.00  0.00           C  
ATOM   1699  HA  PRO A 117       1.866 -14.395  -6.622  1.00  0.00           H  
ATOM   1700  HB2 PRO A 117       0.531 -16.684  -7.213  1.00  0.00           H  
ATOM   1701  HB3 PRO A 117       2.090 -16.269  -7.934  1.00  0.00           H  
ATOM   1702  HG2 PRO A 117       1.490 -18.103  -5.645  1.00  0.00           H  
ATOM   1703  HG3 PRO A 117       2.614 -18.332  -6.997  1.00  0.00           H  
ATOM   1704  HD2 PRO A 117       3.436 -17.555  -4.537  1.00  0.00           H  
ATOM   1705  HD3 PRO A 117       4.248 -17.031  -6.026  1.00  0.00           H  
ATOM   1706  N   SER A 118      -0.268 -14.032  -5.415  1.00  0.00           N  
ATOM   1707  CA  SER A 118      -1.500 -13.766  -4.681  1.00  0.00           C  
ATOM   1708  C   SER A 118      -2.659 -14.575  -5.254  1.00  0.00           C  
ATOM   1709  O   SER A 118      -3.127 -14.313  -6.361  1.00  0.00           O  
ATOM   1710  CB  SER A 118      -1.833 -12.273  -4.728  1.00  0.00           C  
ATOM   1711  OG  SER A 118      -0.735 -11.492  -4.291  1.00  0.00           O  
ATOM   1712  H   SER A 118       0.055 -13.372  -6.063  1.00  0.00           H  
ATOM   1713  HA  SER A 118      -1.343 -14.059  -3.654  1.00  0.00           H  
ATOM   1714  HB2 SER A 118      -2.077 -11.993  -5.741  1.00  0.00           H  
ATOM   1715  HB3 SER A 118      -2.679 -12.076  -4.086  1.00  0.00           H  
ATOM   1716  HG  SER A 118      -0.209 -11.998  -3.668  1.00  0.00           H  
ATOM   1717  N   SER A 119      -3.118 -15.560  -4.488  1.00  0.00           N  
ATOM   1718  CA  SER A 119      -4.221 -16.412  -4.919  1.00  0.00           C  
ATOM   1719  C   SER A 119      -5.425 -15.573  -5.334  1.00  0.00           C  
ATOM   1720  O   SER A 119      -5.884 -15.646  -6.474  1.00  0.00           O  
ATOM   1721  CB  SER A 119      -4.618 -17.375  -3.799  1.00  0.00           C  
ATOM   1722  OG  SER A 119      -5.628 -18.271  -4.230  1.00  0.00           O  
ATOM   1723  H   SER A 119      -2.704 -15.720  -3.615  1.00  0.00           H  
ATOM   1724  HA  SER A 119      -3.885 -16.984  -5.772  1.00  0.00           H  
ATOM   1725  HB2 SER A 119      -3.754 -17.946  -3.495  1.00  0.00           H  
ATOM   1726  HB3 SER A 119      -4.989 -16.810  -2.957  1.00  0.00           H  
ATOM   1727  HG  SER A 119      -5.371 -19.170  -4.015  1.00  0.00           H  
ATOM   1728  N   GLY A 120      -5.934 -14.776  -4.399  1.00  0.00           N  
ATOM   1729  CA  GLY A 120      -7.081 -13.934  -4.686  1.00  0.00           C  
ATOM   1730  C   GLY A 120      -6.872 -13.069  -5.914  1.00  0.00           C  
ATOM   1731  O   GLY A 120      -7.603 -13.190  -6.897  1.00  0.00           O  
ATOM   1732  H   GLY A 120      -5.527 -14.759  -3.508  1.00  0.00           H  
ATOM   1733  HA2 GLY A 120      -7.945 -14.563  -4.844  1.00  0.00           H  
ATOM   1734  HA3 GLY A 120      -7.264 -13.294  -3.836  1.00  0.00           H  
TER    1735      GLY A 120                                                      
END
MOLECULE T0409.pdb
ATOM     14  N   TYR     1     -12.138  -6.437  34.342  1.00 26.71           N  
ATOM     15  CA  TYR     1     -10.769  -6.327  34.864  1.00 25.90           C  
ATOM     16  C   TYR     1     -10.498  -7.542  35.724  1.00 24.98           C  
ATOM     17  O   TYR     1     -11.355  -7.916  36.501  1.00 26.34           O  
ATOM     18  CB  TYR     1     -10.618  -5.047  35.686  1.00 24.63           C  
ATOM     19  CG  TYR     1      -9.168  -4.728  36.029  1.00 22.28           C  
ATOM     20  CD1 TYR     1      -8.285  -4.357  35.005  1.00 22.31           C  
ATOM     21  CD2 TYR     1      -8.664  -4.878  37.313  1.00 23.91           C  
ATOM     22  CE1 TYR     1      -6.951  -4.068  35.280  1.00 18.52           C  
ATOM     23  CE2 TYR     1      -7.324  -4.598  37.613  1.00 21.53           C  
ATOM     24  CZ  TYR     1      -6.480  -4.192  36.581  1.00 19.19           C  
ATOM     25  OH  TYR     1      -5.185  -3.925  36.888  1.00 18.14           O  
ATOM     26  N   ARG     2      -9.329  -8.164  35.541  1.00 24.27           N  
ATOM     27  CA  ARG     2      -8.922  -9.381  36.228  1.00 24.78           C  
ATOM     28  C   ARG     2      -7.920  -9.194  37.353  1.00 24.52           C  
ATOM     29  O   ARG     2      -7.621 -10.122  38.085  1.00 27.44           O  
ATOM     30  CB  ARG     2      -8.346 -10.374  35.215  1.00 23.92           C  
ATOM     31  CG  ARG     2      -9.347 -10.845  34.134  1.00 25.70           C  
ATOM     32  CD  ARG     2      -8.657 -11.765  33.135  1.00 25.52           C  
ATOM     33  NE  ARG     2      -7.696 -11.068  32.290  1.00 27.24           N  
ATOM     34  CZ  ARG     2      -8.028 -10.316  31.245  1.00 25.99           C  
ATOM     35  NH1 ARG     2      -7.092  -9.705  30.558  1.00 26.10           N  
ATOM     36  NH2 ARG     2      -9.305 -10.178  30.888  1.00 30.15           N  
ATOM     37  N   GLY     3      -7.404  -7.992  37.483  1.00 23.54           N  
ATOM     38  CA  GLY     3      -6.475  -7.700  38.540  1.00 21.96           C  
ATOM     39  C   GLY     3      -5.048  -7.714  38.006  1.00 20.01           C  
ATOM     40  O   GLY     3      -4.763  -8.208  36.927  1.00 19.98           O  
ATOM     41  N   PRO     4      -4.121  -7.183  38.794  1.00 18.75           N  
ATOM     42  CA  PRO     4      -2.718  -7.124  38.362  1.00 17.90           C  
ATOM     43  C   PRO     4      -2.069  -8.474  38.133  1.00 17.43           C  
ATOM     44  O   PRO     4      -2.332  -9.438  38.886  1.00 17.86           O  
ATOM     45  CB  PRO     4      -1.998  -6.462  39.555  1.00 17.83           C  
ATOM     46  CG  PRO     4      -3.078  -5.804  40.295  1.00 17.56           C  
ATOM     47  CD  PRO     4      -4.293  -6.604  40.137  1.00 20.04           C  
ATOM     48  N   GLU     5      -1.198  -8.523  37.136  1.00 16.41           N  
ATOM     49  CA  GLU     5      -0.494  -9.734  36.776  1.00 16.74           C  
ATOM     50  C   GLU     5       0.555 -10.210  37.794  1.00 15.28           C  
ATOM     51  O   GLU     5       0.894 -11.399  37.821  1.00 14.56           O  
ATOM     52  CB  GLU     5       0.179  -9.574  35.415  1.00 18.28           C  
ATOM     53  CG  GLU     5       1.357  -8.668  35.384  1.00 18.86           C  
ATOM     54  CD  GLU     5       1.641  -8.109  33.976  1.00 21.65           C  
ATOM     55  OE1 GLU     5       0.838  -7.287  33.462  1.00 19.17           O  
ATOM     56  OE2 GLU     5       2.690  -8.452  33.404  1.00 20.12           O  
ATOM     57  N   ALA     6       1.090  -9.262  38.551  1.00 14.75           N  
ATOM     58  CA  ALA     6       2.230  -9.503  39.408  1.00 12.91           C  
ATOM     59  C   ALA     6       2.286  -8.383  40.423  1.00 13.86           C  
ATOM     60  O   ALA     6       1.662  -7.340  40.252  1.00 14.07           O  
ATOM     61  CB  ALA     6       3.557  -9.555  38.607  1.00 14.41           C  
ATOM     62  N   PHE     7       3.056  -8.616  41.463  1.00 12.90           N  
ATOM     63  CA  PHE     7       3.312  -7.619  42.514  1.00 12.74           C  
ATOM     64  C   PHE     7       4.803  -7.561  42.789  1.00 14.31           C  
ATOM     65  O   PHE     7       5.426  -8.577  43.064  1.00 16.10           O  
ATOM     66  CB  PHE     7       2.558  -7.975  43.774  1.00 12.84           C  
ATOM     67  CG  PHE     7       1.061  -7.980  43.588  1.00 13.25           C  
ATOM     68  CD1 PHE     7       0.432  -9.083  43.089  1.00 12.42           C  
ATOM     69  CD2 PHE     7       0.284  -6.851  43.907  1.00 13.57           C  
ATOM     70  CE1 PHE     7      -0.949  -9.101  42.892  1.00 15.56           C  
ATOM     71  CE2 PHE     7      -1.084  -6.875  43.732  1.00 14.79           C  
ATOM     72  CZ  PHE     7      -1.682  -7.984  43.198  1.00 14.93           C  
ATOM     73  N   LEU     8       5.379  -6.378  42.730  1.00 13.78           N  
ATOM     74  CA  LEU     8       6.799  -6.166  43.031  1.00 14.87           C  
ATOM     75  C   LEU     8       6.959  -5.587  44.431  1.00 17.18           C  
ATOM     76  O   LEU     8       6.012  -5.033  45.021  1.00 18.46           O  
ATOM     77  CB  LEU     8       7.409  -5.253  41.997  1.00 14.89           C  
ATOM     78  CG  LEU     8       7.096  -5.514  40.532  1.00 15.32           C  
ATOM     79  CD1 LEU     8       7.647  -4.518  39.513  1.00 16.20           C  
ATOM     80  CD2 LEU     8       7.592  -6.945  40.214  1.00 16.59           C  
ATOM     81  N   LYS     9       8.127  -5.818  45.005  1.00 17.65           N  
ATOM     82  CA  LYS     9       8.421  -5.348  46.361  1.00 19.07           C  
ATOM     83  C   LYS     9       9.052  -3.955  46.263  1.00 17.92           C  
ATOM     84  O   LYS     9      10.150  -3.798  45.727  1.00 18.25           O  
ATOM     85  CB  LYS     9       9.373  -6.314  47.042  1.00 19.67           C  
ATOM     86  CG  LYS     9       9.591  -5.980  48.493  1.00 23.14           C  
ATOM     87  CD  LYS     9      10.639  -6.886  49.072  1.00 24.83           C  
ATOM     88  CE  LYS     9      10.121  -8.265  49.428  1.00 32.25           C  
ATOM     89  NZ  LYS     9      10.917  -8.817  50.575  1.00 34.79           N  
ATOM     90  N   LEU    10       8.369  -2.926  46.749  1.00 18.72           N  
ATOM     91  CA  LEU    10       8.826  -1.580  46.551  1.00 18.81           C  
ATOM     92  C   LEU    10       9.942  -1.228  47.554  1.00 19.68           C  
ATOM     93  O   LEU    10      10.009  -1.815  48.647  1.00 20.89           O  
ATOM     94  CB  LEU    10       7.717  -0.560  46.770  1.00 20.05           C  
ATOM     95  CG  LEU    10       6.533  -0.547  45.822  1.00 19.19           C  
ATOM     96  CD1 LEU    10       5.473   0.394  46.436  1.00 24.82           C  
ATOM     97  CD2 LEU    10       6.945  -0.115  44.440  1.00 21.53           C  
ATOM     98  N   PRO    11      10.774  -0.268  47.163  1.00 20.13           N  
ATOM     99  CA  PRO    11      11.661   0.375  48.167  1.00 21.78           C  
ATOM    100  C   PRO    11      10.838   1.323  49.071  1.00 22.52           C  
ATOM    101  O   PRO    11       9.740   1.732  48.679  1.00 23.44           O  
ATOM    102  CB  PRO    11      12.607   1.193  47.285  1.00 20.85           C  
ATOM    103  CG  PRO    11      11.779   1.545  46.072  1.00 22.93           C  
ATOM    104  CD  PRO    11      10.970   0.307  45.828  1.00 19.70           C  
ATOM    105  N   LYS    12      11.406   1.739  50.229  1.00 25.61           N  
ATOM    106  CA  LYS    12      10.808   2.820  51.069  1.00 26.86           C  
ATOM    107  C   LYS    12      10.655   4.134  50.323  1.00 28.24           C  
ATOM    108  O   LYS    12       9.621   4.815  50.414  1.00 30.07           O  
ATOM    109  CB  LYS    12      11.725   3.141  52.244  1.00 27.78           C  
ATOM    110  CG  LYS    12      11.297   2.660  53.597  1.00 29.19           C  
ATOM    111  CD  LYS    12      12.113   3.300  54.688  1.00 28.24           C  
ATOM    112  CE  LYS    12      11.543   4.613  55.215  1.00 28.46           C  
ATOM    113  NZ  LYS    12      12.177   4.939  56.553  1.00 29.49           N  
ATOM    114  N   ASP    13      11.716   4.525  49.615  1.00 29.01           N  
ATOM    115  CA  ASP    13      11.746   5.788  48.876  1.00 29.32           C  
ATOM    116  C   ASP    13      11.132   5.663  47.484  1.00 30.39           C  
ATOM    117  O   ASP    13      11.712   5.127  46.535  1.00 29.19           O  
ATOM    118  CB  ASP    13      13.189   6.371  48.893  1.00 29.16           C  
ATOM    119  CG  ASP    13      13.347   7.664  48.082  1.00 30.92           C  
ATOM    120  OD1 ASP    13      12.344   8.274  47.628  1.00 34.61           O  
ATOM    121  OD2 ASP    13      14.529   8.080  47.888  1.00 32.69           O  
ATOM    122  N   LEU    14       9.920   6.195  47.363  1.00 30.90           N  
ATOM    123  CA  LEU    14       9.172   6.157  46.124  1.00 30.71           C  
ATOM    124  C   LEU    14       9.608   7.149  45.049  1.00 30.84           C  
ATOM    125  O   LEU    14       9.020   7.178  43.964  1.00 31.55           O  
ATOM    126  CB  LEU    14       7.678   6.329  46.424  1.00 30.89           C  
ATOM    127  CG  LEU    14       7.124   5.332  47.440  1.00 30.54           C  
ATOM    128  CD1 LEU    14       5.711   5.725  47.765  1.00 33.63           C  
ATOM    129  CD2 LEU    14       7.169   3.889  46.924  1.00 35.44           C  
ATOM    130  N   LYS    15      10.614   7.983  45.348  1.00 30.72           N  
ATOM    131  CA  LYS    15      11.255   8.810  44.324  1.00 30.73           C  
ATOM    132  C   LYS    15      12.623   8.265  43.901  1.00 29.76           C  
ATOM    133  O   LYS    15      13.272   8.865  43.053  1.00 30.87           O  
ATOM    134  CB  LYS    15      11.408  10.266  44.806  1.00 32.76           C  
ATOM    135  CG  LYS    15      10.232  11.196  44.418  1.00 35.47           C  
ATOM    136  CD  LYS    15       9.079  11.039  45.367  1.00 37.91           C  
ATOM    137  CE  LYS    15       9.288  11.906  46.603  1.00 39.30           C  
ATOM    138  NZ  LYS    15       8.302  11.581  47.681  1.00 39.71           N  
ATOM    139  N   ASP    16      13.046   7.133  44.481  1.00 27.99           N  
ATOM    140  CA  ASP    16      14.328   6.493  44.094  1.00 26.78           C  
ATOM    141  C   ASP    16      14.118   5.763  42.782  1.00 25.11           C  
ATOM    142  O   ASP    16      13.741   4.600  42.764  1.00 24.88           O  
ATOM    143  CB  ASP    16      14.802   5.533  45.171  1.00 25.55           C  
ATOM    144  CG  ASP    16      16.217   4.970  44.893  1.00 26.06           C  
ATOM    145  OD1 ASP    16      16.650   5.014  43.729  1.00 25.61           O  
ATOM    146  OD2 ASP    16      16.861   4.472  45.830  1.00 25.02           O  
ATOM    147  N   ARG    17      14.360   6.449  41.680  1.00 25.11           N  
ATOM    148  CA  ARG    17      14.118   5.904  40.359  1.00 24.25           C  
ATOM    149  C   ARG    17      14.973   4.689  40.041  1.00 23.79           C  
ATOM    150  O   ARG    17      14.497   3.729  39.431  1.00 22.80           O  
ATOM    151  CB  ARG    17      14.276   6.978  39.293  1.00 26.64           C  
ATOM    152  CG  ARG    17      13.323   8.136  39.528  1.00 30.06           C  
ATOM    153  CD  ARG    17      12.985   8.820  38.245  1.00 37.41           C  
ATOM    154  NE  ARG    17      14.129   9.542  37.706  1.00 40.97           N  
ATOM    155  CZ  ARG    17      14.150  10.097  36.499  1.00 43.91           C  
ATOM    156  NH1 ARG    17      13.094   9.997  35.685  1.00 45.45           N  
ATOM    157  NH2 ARG    17      15.241  10.749  36.096  1.00 45.78           N  
ATOM    158  N   GLU    18      16.227   4.705  40.494  1.00 22.85           N  
ATOM    159  CA  GLU    18      17.123   3.549  40.277  1.00 22.70           C  
ATOM    160  C   GLU    18      16.572   2.269  40.913  1.00 20.63           C  
ATOM    161  O   GLU    18      16.555   1.211  40.278  1.00 19.78           O  
ATOM    162  CB  GLU    18      18.500   3.848  40.866  1.00 23.30           C  
ATOM    163  CG  GLU    18      19.549   2.754  40.681  1.00 24.01           C  
ATOM    164  CD  GLU    18      20.941   3.182  41.148  1.00 26.13           C  
ATOM    165  OE1 GLU    18      21.200   3.135  42.381  1.00 31.97           O  
ATOM    166  OE2 GLU    18      21.761   3.558  40.278  1.00 30.80           O  
ATOM    167  N   ALA    19      16.146   2.364  42.159  1.00 18.69           N  
ATOM    168  CA  ALA    19      15.569   1.237  42.865  1.00 18.72           C  
ATOM    169  C   ALA    19      14.286   0.741  42.184  1.00 18.42           C  
ATOM    170  O   ALA    19      14.079  -0.477  42.073  1.00 18.40           O  
ATOM    171  CB  ALA    19      15.248   1.627  44.285  1.00 19.53           C  
ATOM    172  N   LEU    20      13.438   1.683  41.764  1.00 18.86           N  
ATOM    173  CA  LEU    20      12.198   1.346  41.088  1.00 18.10           C  
ATOM    174  C   LEU    20      12.479   0.694  39.747  1.00 18.59           C  
ATOM    175  O   LEU    20      11.826  -0.289  39.383  1.00 18.02           O  
ATOM    176  CB  LEU    20      11.269   2.570  40.902  1.00 19.62           C  
ATOM    177  CG  LEU    20      10.779   3.123  42.243  1.00 19.47           C  
ATOM    178  CD1 LEU    20      10.171   4.490  42.063  1.00 25.48           C  
ATOM    179  CD2 LEU    20       9.776   2.141  42.919  1.00 20.59           C  
ATOM    180  N   GLN    21      13.439   1.212  38.971  1.00 17.08           N  
ATOM    181  CA  GLN    21      13.818   0.563  37.701  0.60 17.52           C  
ATOM    183  C   GLN    21      14.339  -0.838  37.961  1.00 17.89           C  
ATOM    184  O   GLN    21      14.076  -1.788  37.220  1.00 17.69           O  
ATOM    185  CB  GLN    21      14.943   1.338  36.986  0.60 18.21           C  
ATOM    187  CG  GLN    21      14.503   2.626  36.329  0.60 18.89           C  
ATOM    189  CD  GLN    21      13.515   2.472  35.158  0.60 20.48           C  
ATOM    191  OE1 GLN    21      13.254   1.364  34.619  0.60 23.97           O  
ATOM    193  NE2 GLN    21      12.980   3.610  34.738  0.60 22.78           N  
ATOM    195  N   ASP    22      15.104  -0.995  39.034  1.00 16.55           N  
ATOM    196  CA  ASP    22      15.680  -2.315  39.349  1.00 17.02           C  
ATOM    197  C   ASP    22      14.611  -3.356  39.634  1.00 16.63           C  
ATOM    198  O   ASP    22      14.714  -4.505  39.156  1.00 16.75           O  
ATOM    199  CB  ASP    22      16.632  -2.228  40.544  1.00 17.24           C  
ATOM    200  CG  ASP    22      18.015  -1.694  40.162  1.00 19.16           C  
ATOM    201  OD1 ASP    22      18.327  -1.439  38.960  1.00 22.10           O  
ATOM    202  OD2 ASP    22      18.789  -1.547  41.118  1.00 23.09           O  
ATOM    203  N   ILE    23      13.551  -2.982  40.363  1.00 15.22           N  
ATOM    204  CA  ILE    23      12.501  -4.017  40.667  1.00 15.44           C  
ATOM    205  C   ILE    23      11.696  -4.359  39.393  1.00 15.80           C  
ATOM    206  O   ILE    23      11.130  -5.448  39.328  1.00 16.91           O  
ATOM    207  CB  ILE    23      11.538  -3.666  41.812  1.00 14.93           C  
ATOM    208  CG1 ILE    23      10.715  -2.400  41.496  1.00 16.08           C  
ATOM    209  CG2 ILE    23      12.349  -3.420  43.109  1.00 16.92           C  
ATOM    210  CD1 ILE    23       9.662  -2.083  42.539  1.00 18.45           C  
ATOM    211  N   MET    24      11.693  -3.454  38.407  1.00 16.35           N  
ATOM    212  CA  MET    24      11.001  -3.635  37.136  1.00 16.51           C  
ATOM    213  C   MET    24      11.870  -4.256  36.047  1.00 16.28           C  
ATOM    214  O   MET    24      11.426  -4.374  34.907  1.00 16.01           O  
ATOM    215  CB  MET    24      10.471  -2.276  36.650  1.00 16.46           C  
ATOM    216  CG  MET    24       9.476  -1.622  37.540  1.00 17.64           C  
ATOM    217  SD  MET    24       8.685  -0.053  36.632  0.80 26.05          SE  
ATOM    218  CE  MET    24       7.421  -0.860  35.445  1.00 24.41           C  
ATOM    219  N   GLN    25      13.092  -4.631  36.388  1.00 16.67           N  
ATOM    220  CA  GLN    25      14.070  -4.998  35.365  1.00 17.43           C  
ATOM    221  C   GLN    25      13.592  -6.036  34.353  1.00 16.67           C  
ATOM    222  O   GLN    25      14.004  -5.969  33.198  1.00 17.33           O  
ATOM    223  CB  GLN    25      15.374  -5.433  36.005  1.00 18.09           C  
ATOM    224  CG  GLN    25      15.329  -6.698  36.777  1.00 20.57           C  
ATOM    225  CD  GLN    25      16.656  -7.030  37.461  1.00 24.40           C  
ATOM    226  OE1 GLN    25      17.683  -6.382  37.193  1.00 30.15           O  
ATOM    227  NE2 GLN    25      16.631  -8.020  38.370  1.00 29.33           N  
ATOM    228  N   ASP    26      12.790  -7.013  34.797  1.00 15.34           N  
ATOM    229  CA  ASP    26      12.390  -8.124  33.918  1.00 15.72           C  
ATOM    230  C   ASP    26      11.142  -7.834  33.073  1.00 16.03           C  
ATOM    231  O   ASP    26      10.876  -8.602  32.131  1.00 16.34           O  
ATOM    232  CB  ASP    26      12.120  -9.391  34.723  1.00 15.05           C  
ATOM    233  CG  ASP    26      13.409 -10.027  35.326  1.00 18.38           C  
ATOM    234  OD1 ASP    26      14.527  -9.715  34.833  1.00 21.09           O  
ATOM    235  OD2 ASP    26      13.261 -10.859  36.262  1.00 21.86           O  
ATOM    236  N   ILE    27      10.434  -6.762  33.392  1.00 16.05           N  
ATOM    237  CA  ILE    27       9.093  -6.467  32.882  0.60 17.18           C  
ATOM    239  C   ILE    27       9.116  -5.228  31.989  1.00 17.24           C  
ATOM    240  O   ILE    27       9.908  -4.318  32.214  1.00 16.86           O  
ATOM    241  CB  ILE    27       8.122  -6.210  34.080  0.60 17.87           C  
ATOM    243  CG1 ILE    27       8.158  -7.384  35.052  0.60 18.38           C  
ATOM    245  CG2 ILE    27       6.684  -5.914  33.601  0.60 18.73           C  
ATOM    247  CD1 ILE    27       7.986  -8.690  34.409  0.60 20.09           C  
ATOM    249  N   GLY    28       8.241  -5.184  31.003  1.00 17.82           N  
ATOM    250  CA  GLY    28       8.066  -3.945  30.257  1.00 18.09           C  
ATOM    251  C   GLY    28       9.221  -3.577  29.353  1.00 18.07           C  
ATOM    252  O   GLY    28       9.365  -2.424  28.950  1.00 18.91           O  
ATOM    253  N   ASN    29      10.036  -4.547  28.983  1.00 18.26           N  
ATOM    254  CA  ASN    29      11.290  -4.211  28.309  1.00 18.83           C  
ATOM    255  C   ASN    29      11.112  -3.765  26.859  1.00 19.92           C  
ATOM    256  O   ASN    29      12.054  -3.163  26.287  1.00 23.13           O  
ATOM    257  CB  ASN    29      12.315  -5.308  28.491  1.00 19.12           C  
ATOM    258  CG  ASN    29      12.920  -5.252  29.901  1.00 18.82           C  
ATOM    259  OD1 ASN    29      13.210  -4.141  30.417  1.00 20.59           O  
ATOM    260  ND2 ASN    29      13.068  -6.410  30.534  1.00 20.14           N  
ATOM    261  N   SER    30       9.940  -3.996  26.289  1.00 19.51           N  
ATOM    262  CA  SER    30       9.638  -3.436  24.946  1.00 19.62           C  
ATOM    263  C   SER    30       8.833  -2.162  25.064  1.00 19.59           C  
ATOM    264  O   SER    30       8.467  -1.576  24.052  1.00 20.08           O  
ATOM    265  CB  SER    30       8.915  -4.467  24.077  1.00 20.71           C  
ATOM    266  OG  SER    30       7.714  -4.851  24.696  1.00 25.23           O  
ATOM    267  N   ASP    31       8.554  -1.688  26.286  1.00 19.24           N  
ATOM    268  CA  ASP    31       7.719  -0.480  26.428  1.00 19.48           C  
ATOM    269  C   ASP    31       8.399   0.728  25.751  1.00 19.11           C  
ATOM    270  O   ASP    31       9.607   0.921  25.855  1.00 18.28           O  
ATOM    271  CB  ASP    31       7.472  -0.170  27.903  1.00 19.32           C  
ATOM    272  CG  ASP    31       6.382  -1.059  28.540  1.00 20.97           C  
ATOM    273  OD1 ASP    31       5.838  -1.957  27.861  1.00 20.12           O  
ATOM    274  OD2 ASP    31       6.130  -0.786  29.749  1.00 20.60           O  
ATOM    275  N   ASP    32       7.573   1.496  25.059  1.00 19.06           N  
ATOM    276  CA  ASP    32       7.966   2.731  24.373  1.00 20.14           C  
ATOM    277  C   ASP    32       8.776   2.490  23.102  1.00 19.79           C  
ATOM    278  O   ASP    32       9.198   3.461  22.447  1.00 19.91           O  
ATOM    279  CB  ASP    32       8.712   3.674  25.293  1.00 20.73           C  
ATOM    280  CG  ASP    32       7.963   3.948  26.635  1.00 23.39           C  
ATOM    281  OD1 ASP    32       6.803   4.403  26.542  1.00 25.24           O  
ATOM    282  OD2 ASP    32       8.564   3.719  27.723  1.00 25.94           O  
ATOM    283  N   ILE    33       8.996   1.235  22.770  1.00 19.89           N  
ATOM    284  CA  ILE    33       9.673   0.832  21.522  1.00 20.20           C  
ATOM    285  C   ILE    33       8.565   0.449  20.573  1.00 20.72           C  
ATOM    286  O   ILE    33       7.960  -0.632  20.700  1.00 22.37           O  
ATOM    287  CB  ILE    33      10.677  -0.334  21.711  1.00 19.45           C  
ATOM    288  CG1 ILE    33      11.758   0.114  22.689  1.00 21.44           C  
ATOM    289  CG2 ILE    33      11.304  -0.710  20.329  1.00 20.56           C  
ATOM    290  CD1 ILE    33      12.772  -0.956  23.051  1.00 22.94           C  
ATOM    291  N   LEU    34       8.299   1.342  19.626  1.00 19.25           N  
ATOM    292  CA  LEU    34       7.087   1.314  18.818  1.00 17.77           C  
ATOM    293  C   LEU    34       7.338   0.882  17.390  1.00 18.40           C  
ATOM    294  O   LEU    34       8.388   1.119  16.839  1.00 18.47           O  
ATOM    295  CB  LEU    34       6.469   2.701  18.781  1.00 18.47           C  
ATOM    296  CG  LEU    34       6.267   3.371  20.125  1.00 19.72           C  
ATOM    297  CD1 LEU    34       5.545   4.684  19.944  1.00 22.67           C  
ATOM    298  CD2 LEU    34       5.548   2.434  21.132  1.00 21.13           C  
ATOM    299  N   ALA    35       6.348   0.240  16.797  1.00 18.57           N  
ATOM    300  CA  ALA    35       6.435  -0.175  15.394  1.00 17.19           C  
ATOM    301  C   ALA    35       6.217   1.030  14.494  1.00 17.33           C  
ATOM    302  O   ALA    35       5.387   1.913  14.741  1.00 18.24           O  
ATOM    303  CB  ALA    35       5.390  -1.293  15.057  1.00 19.13           C  
ATOM    304  N   ALA    36       6.928   1.044  13.360  1.00 17.01           N  
ATOM    305  CA  ALA    36       6.674   2.049  12.357  1.00 15.71           C  
ATOM    306  C   ALA    36       7.034   1.462  10.990  1.00 16.78           C  
ATOM    307  O   ALA    36       7.901   0.604  10.879  1.00 18.10           O  
ATOM    308  CB  ALA    36       7.457   3.343  12.596  1.00 17.58           C  
ATOM    309  N   VAL    37       6.370   1.955   9.975  1.00 15.62           N  
ATOM    310  CA  VAL    37       6.682   1.549   8.602  0.50 15.71           C  
ATOM    312  C   VAL    37       7.312   2.714   7.873  1.00 14.23           C  
ATOM    313  O   VAL    37       6.779   3.823   7.872  1.00 15.68           O  
ATOM    314  CB  VAL    37       5.451   1.037   7.797  0.50 15.29           C  
ATOM    316  CG1 VAL    37       4.346   2.086   7.714  0.50 16.13           C  
ATOM    318  CG2 VAL    37       5.858   0.619   6.389  0.50 16.06           C  
ATOM    320  N   VAL    38       8.435   2.456   7.238  1.00 14.86           N  
ATOM    321  CA  VAL    38       9.172   3.493   6.517  1.00 14.41           C  
ATOM    322  C   VAL    38       8.438   3.924   5.239  1.00 15.45           C  
ATOM    323  O   VAL    38       7.986   3.077   4.449  1.00 14.72           O  
ATOM    324  CB  VAL    38      10.630   3.065   6.225  1.00 15.18           C  
ATOM    325  CG1 VAL    38      11.345   4.116   5.259  1.00 14.75           C  
ATOM    326  CG2 VAL    38      11.387   2.893   7.574  1.00 15.41           C  
ATOM    327  N   LEU    39       8.293   5.236   5.093  1.00 14.89           N  
ATOM    328  CA  LEU    39       7.728   5.844   3.883  1.00 15.30           C  
ATOM    329  C   LEU    39       8.802   6.367   2.923  1.00 16.16           C  
ATOM    330  O   LEU    39       8.618   6.337   1.717  1.00 17.32           O  
ATOM    331  CB  LEU    39       6.793   7.008   4.266  1.00 16.91           C  
ATOM    332  CG  LEU    39       5.696   6.599   5.252  1.00 17.60           C  
ATOM    333  CD1 LEU    39       4.796   7.809   5.545  1.00 21.11           C  
ATOM    334  CD2 LEU    39       4.876   5.379   4.818  1.00 20.56           C  
ATOM    335  N   SER    40       9.878   6.946   3.451  1.00 16.45           N  
ATOM    336  CA  SER    40      10.967   7.414   2.684  1.00 16.91           C  
ATOM    337  C   SER    40      12.241   7.291   3.490  1.00 16.85           C  
ATOM    338  O   SER    40      12.195   7.364   4.707  1.00 15.68           O  
ATOM    339  CB  SER    40      10.726   8.848   2.271  1.00 18.60           C  
ATOM    340  OG  SER    40      10.878   9.725   3.348  1.00 19.69           O  
ATOM    341  N   ALA    41      13.376   7.151   2.802  1.00 16.13           N  
ATOM    342  CA  ALA    41      14.666   7.013   3.492  1.00 16.24           C  
ATOM    343  C   ALA    41      15.808   7.516   2.678  1.00 17.06           C  
ATOM    344  O   ALA    41      15.937   7.212   1.489  1.00 17.44           O  
ATOM    345  CB  ALA    41      14.932   5.590   3.873  1.00 16.02           C  
ATOM    346  N   THR    42      16.603   8.346   3.317  1.00 17.62           N  
ATOM    347  CA  THR    42      17.909   8.824   2.826  1.00 18.26           C  
ATOM    348  C   THR    42      18.903   8.767   3.996  1.00 18.56           C  
ATOM    349  O   THR    42      18.496   8.630   5.155  1.00 16.63           O  
ATOM    350  CB  THR    42      17.820  10.268   2.317  1.00 18.38           C  
ATOM    351  OG1 THR    42      17.681  11.157   3.433  1.00 21.26           O  
ATOM    352  CG2 THR    42      16.634  10.457   1.330  1.00 21.04           C  
ATOM    353  N   PRO    43      20.207   8.983   3.741  1.00 18.87           N  
ATOM    354  CA  PRO    43      21.125   9.006   4.879  1.00 18.55           C  
ATOM    355  C   PRO    43      20.851  10.148   5.880  1.00 18.56           C  
ATOM    356  O   PRO    43      21.326  10.095   7.044  1.00 20.67           O  
ATOM    357  CB  PRO    43      22.499   9.197   4.201  1.00 19.88           C  
ATOM    358  CG  PRO    43      22.329   8.653   2.885  1.00 19.28           C  
ATOM    359  CD  PRO    43      20.938   9.070   2.467  1.00 20.45           C  
ATOM    360  N   GLY    44      20.139  11.170   5.431  1.00 16.96           N  
ATOM    361  CA  GLY    44      19.835  12.346   6.269  1.00 17.33           C  
ATOM    362  C   GLY    44      18.471  12.343   6.932  1.00 16.12           C  
ATOM    363  O   GLY    44      18.259  13.110   7.843  1.00 16.70           O  
ATOM    364  N   ALA    45      17.521  11.522   6.465  1.00 15.44           N  
ATOM    365  CA  ALA    45      16.194  11.546   7.049  1.00 16.18           C  
ATOM    366  C   ALA    45      15.409  10.293   6.680  1.00 16.57           C  
ATOM    367  O   ALA    45      15.433   9.862   5.536  1.00 16.49           O  
ATOM    368  CB  ALA    45      15.445  12.726   6.525  1.00 16.54           C  
ATOM    369  N   VAL    46      14.702   9.747   7.648  1.00 16.15           N  
ATOM    370  CA  VAL    46      13.752   8.676   7.432  1.00 15.46           C  
ATOM    371  C   VAL    46      12.395   9.193   7.901  1.00 16.21           C  
ATOM    372  O   VAL    46      12.272   9.685   9.044  1.00 15.82           O  
ATOM    373  CB  VAL    46      14.173   7.440   8.255  1.00 14.79           C  
ATOM    374  CG1 VAL    46      13.059   6.405   8.283  1.00 16.16           C  
ATOM    375  CG2 VAL    46      15.520   6.906   7.736  1.00 15.90           C  
ATOM    376  N   GLU    47      11.375   9.063   7.045  1.00 16.26           N  
ATOM    377  CA  GLU    47       9.987   9.338   7.431  1.00 17.37           C  
ATOM    378  C   GLU    47       9.318   7.985   7.648  1.00 17.25           C  
ATOM    379  O   GLU    47       9.447   7.094   6.805  1.00 16.35           O  
ATOM    380  CB  GLU    47       9.240  10.078   6.308  1.00 18.76           C  
ATOM    381  CG  GLU    47       9.768  11.459   6.058  1.00 22.56           C  
ATOM    382  CD  GLU    47       8.728  12.493   5.613  1.00 27.08           C  
ATOM    383  OE1 GLU    47       7.596  12.140   5.191  1.00 32.70           O  
ATOM    384  OE2 GLU    47       9.093  13.699   5.695  1.00 39.15           O  
ATOM    385  N   ALA    48       8.608   7.831   8.751  1.00 15.79           N  
ATOM    386  CA  ALA    48       7.954   6.581   9.088  1.00 16.62           C  
ATOM    387  C   ALA    48       6.568   6.823   9.690  1.00 16.84           C  
ATOM    388  O   ALA    48       6.358   7.839  10.370  1.00 19.46           O  
ATOM    389  CB  ALA    48       8.843   5.735  10.026  1.00 17.11           C  
ATOM    390  N   PHE    49       5.635   5.922   9.429  1.00 16.37           N  
ATOM    391  CA  PHE    49       4.267   5.991   9.929  1.00 17.59           C  
ATOM    392  C   PHE    49       4.122   5.056  11.129  1.00 18.32           C  
ATOM    393  O   PHE    49       4.501   3.899  11.058  1.00 17.79           O  
ATOM    394  CB  PHE    49       3.296   5.544   8.820  1.00 17.85           C  
ATOM    395  CG  PHE    49       1.842   5.641   9.191  1.00 18.30           C  
ATOM    396  CD1 PHE    49       1.144   6.802   8.933  1.00 21.76           C  
ATOM    397  CD2 PHE    49       1.164   4.553   9.695  1.00 20.75           C  
ATOM    398  CE1 PHE    49      -0.227   6.916   9.249  1.00 20.36           C  
ATOM    399  CE2 PHE    49      -0.206   4.656  10.047  1.00 19.72           C  
ATOM    400  CZ  PHE    49      -0.881   5.839   9.796  1.00 22.60           C  
ATOM    401  N   ARG    50       3.636   5.563  12.253  1.00 19.08           N  
ATOM    402  CA  ARG    50       3.464   4.703  13.441  1.00 20.23           C  
ATOM    403  C   ARG    50       1.972   4.382  13.686  1.00 21.07           C  
ATOM    404  O   ARG    50       1.117   4.995  13.106  1.00 20.64           O  
ATOM    405  CB  ARG    50       4.134   5.305  14.688  1.00 22.94           C  
ATOM    406  CG  ARG    50       3.763   6.662  15.046  1.00 23.31           C  
ATOM    407  CD  ARG    50       4.729   7.128  16.134  1.00 22.13           C  
ATOM    408  NE  ARG    50       4.369   8.344  16.762  1.00 24.32           N  
ATOM    409  CZ  ARG    50       3.791   8.440  17.969  1.00 23.15           C  
ATOM    410  NH1 ARG    50       3.443   7.362  18.655  1.00 26.13           N  
ATOM    411  NH2 ARG    50       3.534   9.622  18.479  1.00 24.48           N  
ATOM    412  N   LYS    51       1.701   3.437  14.570  1.00 21.95           N  
ATOM    413  CA  LYS    51       0.329   2.957  14.793  1.00 22.96           C  
ATOM    414  C   LYS    51      -0.644   4.022  15.207  1.00 23.88           C  
ATOM    415  O   LYS    51      -1.836   3.907  14.899  1.00 27.15           O  
ATOM    416  CB  LYS    51       0.344   1.884  15.880  1.00 24.30           C  
ATOM    417  CG  LYS    51       0.928   0.570  15.440  1.00 26.87           C  
ATOM    418  CD  LYS    51      -0.058  -0.226  14.582  1.00 29.44           C  
ATOM    419  CE  LYS    51      -1.205  -0.890  15.358  1.00 30.13           C  
ATOM    420  NZ  LYS    51      -1.944  -1.954  14.526  1.00 28.19           N  
ATOM    421  N   ASN    52      -0.193   5.045  15.923  1.00 23.72           N  
ATOM    422  CA  ASN    52      -1.125   6.100  16.359  1.00 24.26           C  
ATOM    423  C   ASN    52      -1.538   7.030  15.207  1.00 24.17           C  
ATOM    424  O   ASN    52      -2.323   7.978  15.409  1.00 25.42           O  
ATOM    425  CB  ASN    52      -0.554   6.871  17.558  1.00 25.03           C  
ATOM    426  CG  ASN    52       0.317   8.020  17.160  1.00 24.42           C  
ATOM    427  OD1 ASN    52       0.962   7.983  16.114  1.00 25.79           O  
ATOM    428  ND2 ASN    52       0.299   9.079  17.951  1.00 26.65           N  
ATOM    429  N   GLY    53      -1.017   6.768  14.005  1.00 23.35           N  
ATOM    430  CA  GLY    53      -1.366   7.494  12.812  1.00 23.25           C  
ATOM    431  C   GLY    53      -0.460   8.670  12.473  1.00 22.61           C  
ATOM    432  O   GLY    53      -0.703   9.373  11.499  1.00 24.10           O  
ATOM    433  N   GLU    54       0.538   8.935  13.311  1.00 22.55           N  
ATOM    434  CA  GLU    54       1.405  10.054  13.034  0.50 22.38           C  
ATOM    436  C   GLU    54       2.587   9.612  12.165  1.00 21.93           C  
ATOM    437  O   GLU    54       3.020   8.453  12.207  1.00 20.56           O  
ATOM    438  CB  GLU    54       1.816  10.735  14.347  0.50 22.86           C  
ATOM    440  CG  GLU    54       0.597  11.429  14.982  0.50 23.21           C  
ATOM    442  CD  GLU    54       0.817  12.068  16.340  0.50 25.13           C  
ATOM    444  OE1 GLU    54       1.708  11.658  17.107  0.50 26.68           O  
ATOM    446  OE2 GLU    54       0.037  12.995  16.648  0.50 28.52           O  
ATOM    448  N   THR    55       3.045  10.538  11.335  1.00 21.52           N  
ATOM    449  CA  THR    55       4.233  10.331  10.508  1.00 21.28           C  
ATOM    450  C   THR    55       5.336  11.097  11.229  1.00 21.26           C  
ATOM    451  O   THR    55       5.202  12.280  11.575  1.00 24.07           O  
ATOM    452  CB  THR    55       4.059  10.775   9.067  1.00 22.75           C  
ATOM    453  OG1 THR    55       3.020   9.997   8.430  1.00 23.47           O  
ATOM    454  CG2 THR    55       5.373  10.586   8.283  1.00 23.69           C  
ATOM    455  N   ILE    56       6.388  10.377  11.530  1.00 18.81           N  
ATOM    456  CA  ILE    56       7.560  10.946  12.221  1.00 17.71           C  
ATOM    457  C   ILE    56       8.734  11.049  11.242  1.00 16.62           C  
ATOM    458  O   ILE    56       8.769  10.351  10.240  1.00 15.72           O  
ATOM    459  CB  ILE    56       7.998  10.101  13.463  1.00 16.48           C  
ATOM    460  CG1 ILE    56       8.324   8.643  13.102  1.00 18.49           C  
ATOM    461  CG2 ILE    56       6.891  10.128  14.560  1.00 20.69           C  
ATOM    462  CD1 ILE    56       8.915   7.805  14.252  1.00 18.71           C  
ATOM    463  N   ARG    57       9.641  11.970  11.557  1.00 17.01           N  
ATOM    464  CA  ARG    57      10.857  12.170  10.790  1.00 16.90           C  
ATOM    465  C   ARG    57      12.059  11.961  11.712  1.00 18.52           C  
ATOM    466  O   ARG    57      12.203  12.700  12.712  1.00 18.30           O  
ATOM    467  CB  ARG    57      10.877  13.578  10.175  1.00 18.21           C  
ATOM    468  CG  ARG    57      11.843  13.767   9.044  1.00 22.16           C  
ATOM    469  CD  ARG    57      11.482  15.091   8.275  1.00 22.79           C  
ATOM    470  NE  ARG    57      12.260  15.266   7.076  1.00 30.28           N  
ATOM    471  CZ  ARG    57      13.426  15.885   7.007  1.00 29.98           C  
ATOM    472  NH1 ARG    57      14.012  16.421   8.094  1.00 33.28           N  
ATOM    473  NH2 ARG    57      14.032  15.957   5.829  1.00 32.68           N  
ATOM    474  N   ILE    58      12.936  11.028  11.349  1.00 15.91           N  
ATOM    475  CA  ILE    58      14.128  10.653  12.155  1.00 15.94           C  
ATOM    476  C   ILE    58      15.335  11.194  11.407  1.00 16.27           C  
ATOM    477  O   ILE    58      15.485  10.933  10.213  1.00 14.90           O  
ATOM    478  CB  ILE    58      14.242   9.140  12.377  1.00 16.25           C  
ATOM    479  CG1 ILE    58      12.926   8.623  13.001  1.00 20.10           C  
ATOM    480  CG2 ILE    58      15.455   8.775  13.294  1.00 16.57           C  
ATOM    481  CD1 ILE    58      12.483   7.265  12.468  1.00 23.93           C  
ATOM    482  N   THR    59      16.197  11.910  12.141  1.00 14.89           N  
ATOM    483  CA  THR    59      17.358  12.593  11.568  1.00 14.15           C  
ATOM    484  C   THR    59      18.504  12.573  12.586  1.00 14.35           C  
ATOM    485  O   THR    59      18.307  12.162  13.715  1.00 14.11           O  
ATOM    486  CB  THR    59      17.069  14.081  11.229  1.00 14.81           C  
ATOM    487  OG1 THR    59      16.779  14.818  12.442  1.00 13.82           O  
ATOM    488  CG2 THR    59      15.872  14.174  10.256  1.00 14.18           C  
ATOM    489  N   GLY    60      19.662  13.078  12.202  1.00 13.00           N  
ATOM    490  CA  GLY    60      20.785  13.294  13.142  1.00 14.55           C  
ATOM    491  C   GLY    60      21.076  12.078  14.032  1.00 15.23           C  
ATOM    492  O   GLY    60      21.268  10.956  13.557  1.00 15.55           O  
ATOM    493  N   ASP    61      21.107  12.333  15.323  1.00 14.66           N  
ATOM    494  CA  ASP    61      21.464  11.288  16.310  1.00 15.90           C  
ATOM    495  C   ASP    61      20.544  10.072  16.200  1.00 16.16           C  
ATOM    496  O   ASP    61      20.988   8.929  16.399  1.00 16.88           O  
ATOM    497  CB  ASP    61      21.390  11.842  17.714  1.00 16.78           C  
ATOM    498  CG  ASP    61      22.453  12.862  18.020  1.00 19.80           C  
ATOM    499  OD1 ASP    61      23.417  13.063  17.234  1.00 23.93           O  
ATOM    500  OD2 ASP    61      22.320  13.459  19.136  1.00 27.40           O  
ATOM    501  N   GLY    62      19.269  10.299  15.862  1.00 13.92           N  
ATOM    502  CA  GLY    62      18.296   9.222  15.746  1.00 15.21           C  
ATOM    503  C   GLY    62      18.607   8.184  14.692  1.00 15.36           C  
ATOM    504  O   GLY    62      18.053   7.093  14.739  1.00 16.47           O  
ATOM    505  N   LEU    63      19.447   8.530  13.705  1.00 15.12           N  
ATOM    506  CA  LEU    63      19.813   7.633  12.637  1.00 14.66           C  
ATOM    507  C   LEU    63      21.161   6.929  12.860  1.00 16.62           C  
ATOM    508  O   LEU    63      21.553   6.092  12.067  1.00 17.65           O  
ATOM    509  CB  LEU    63      19.895   8.412  11.307  1.00 14.91           C  
ATOM    510  CG  LEU    63      18.610   9.028  10.816  1.00 14.93           C  
ATOM    511  CD1 LEU    63      18.872   9.730   9.475  1.00 16.30           C  
ATOM    512  CD2 LEU    63      17.484   7.995  10.686  1.00 15.68           C  
ATOM    513  N   LYS    64      21.879   7.292  13.912  1.00 15.36           N  
ATOM    514  CA  LYS    64      23.251   6.825  14.127  0.50 17.84           C  
ATOM    516  C   LYS    64      23.350   5.313  14.202  1.00 17.93           C  
ATOM    517  O   LYS    64      24.201   4.683  13.539  1.00 18.87           O  
ATOM    518  CB  LYS    64      23.803   7.419  15.421  0.50 18.24           C  
ATOM    520  CG  LYS    64      24.118   8.919  15.346  0.50 18.90           C  
ATOM    522  CD  LYS    64      24.682   9.481  16.677  0.50 21.52           C  
ATOM    524  CE  LYS    64      26.140   9.169  16.864  0.50 25.23           C  
ATOM    526  NZ  LYS    64      26.990   9.892  15.880  0.50 27.58           N  
ATOM    528  N   ALA    65      22.489   4.723  15.032  1.00 19.45           N  
ATOM    529  CA  ALA    65      22.573   3.266  15.255  1.00 19.45           C  
ATOM    530  C   ALA    65      22.318   2.519  13.970  1.00 20.13           C  
ATOM    531  O   ALA    65      22.956   1.506  13.706  1.00 21.80           O  
ATOM    532  CB  ALA    65      21.609   2.832  16.300  1.00 20.20           C  
ATOM    533  N   ALA    66      21.444   3.053  13.127  1.00 19.24           N  
ATOM    534  CA  ALA    66      21.020   2.427  11.875  1.00 20.12           C  
ATOM    535  C   ALA    66      21.899   2.739  10.641  1.00 20.14           C  
ATOM    536  O   ALA    66      21.545   2.431   9.497  1.00 19.93           O  
ATOM    537  CB  ALA    66      19.537   2.784  11.608  1.00 19.17           C  
ATOM    538  N   HIS    67      23.032   3.414  10.876  1.00 20.96           N  
ATOM    539  CA  HIS    67      23.874   3.973   9.798  1.00 22.50           C  
ATOM    540  C   HIS    67      24.131   3.057   8.595  1.00 22.69           C  
ATOM    541  O   HIS    67      23.989   3.483   7.437  1.00 23.41           O  
ATOM    542  CB  HIS    67      25.197   4.541  10.372  1.00 23.45           C  
ATOM    543  CG  HIS    67      26.126   3.542  11.028  1.00 26.82           C  
ATOM    544  ND1 HIS    67      25.899   2.978  12.266  1.00 32.13           N  
ATOM    545  CD2 HIS    67      27.348   3.080  10.635  1.00 30.02           C  
ATOM    546  CE1 HIS    67      26.898   2.169  12.582  1.00 33.51           C  
ATOM    547  NE2 HIS    67      27.792   2.218  11.610  1.00 33.86           N  
ATOM    548  N   ARG    68      24.408   1.803   8.879  1.00 23.67           N  
ATOM    549  CA  ARG    68      24.853   0.871   7.842  1.00 25.02           C  
ATOM    550  C   ARG    68      23.705   0.512   6.938  1.00 22.30           C  
ATOM    551  O   ARG    68      23.901   0.185   5.787  1.00 22.56           O  
ATOM    552  CB  ARG    68      25.434  -0.344   8.498  1.00 24.82           C  
ATOM    553  CG  ARG    68      26.707   0.042   9.249  1.00 30.85           C  
ATOM    554  CD  ARG    68      27.251  -1.030  10.152  1.00 31.45           C  
ATOM    555  NE  ARG    68      27.030  -2.400   9.701  1.00 37.79           N  
ATOM    556  CZ  ARG    68      27.584  -2.962   8.632  1.00 38.95           C  
ATOM    557  NH1 ARG    68      28.387  -2.272   7.823  1.00 41.74           N  
ATOM    558  NH2 ARG    68      27.322  -4.240   8.369  1.00 39.77           N  
ATOM    559  N   PHE    69      22.504   0.595   7.497  1.00 19.79           N  
ATOM    560  CA  PHE    69      21.286   0.350   6.733  1.00 19.43           C  
ATOM    561  C   PHE    69      20.734   1.541   5.979  1.00 19.65           C  
ATOM    562  O   PHE    69      19.701   1.423   5.340  1.00 19.12           O  
ATOM    563  CB  PHE    69      20.253  -0.281   7.668  1.00 18.19           C  
ATOM    564  CG  PHE    69      20.676  -1.645   8.125  1.00 18.08           C  
ATOM    565  CD1 PHE    69      21.572  -1.808   9.173  1.00 20.24           C  
ATOM    566  CD2 PHE    69      20.239  -2.769   7.441  1.00 18.30           C  
ATOM    567  CE1 PHE    69      21.988  -3.089   9.532  1.00 18.89           C  
ATOM    568  CE2 PHE    69      20.661  -4.045   7.806  1.00 20.19           C  
ATOM    569  CZ  PHE    69      21.524  -4.186   8.845  1.00 19.83           C  
ATOM    570  N   LEU    70      21.457   2.669   6.005  1.00 20.27           N  
ATOM    571  CA  LEU    70      21.095   3.866   5.245  1.00 22.90           C  
ATOM    572  C   LEU    70      22.208   4.335   4.308  1.00 25.29           C  
ATOM    573  O   LEU    70      22.002   5.257   3.520  1.00 26.73           O  
ATOM    574  CB  LEU    70      20.781   5.012   6.233  1.00 23.31           C  
ATOM    575  CG  LEU    70      19.562   4.755   7.119  1.00 21.31           C  
ATOM    576  CD1 LEU    70      19.661   5.653   8.378  1.00 24.18           C  
ATOM    577  CD2 LEU    70      18.328   5.018   6.305  1.00 20.23           C  
ATOM    578  N   SER    71      23.353   3.653   4.356  1.00 26.45           N  
ATOM    579  CA  SER    71      24.587   4.095   3.688  1.00 27.55           C  
ATOM    580  C   SER    71      24.781   3.559   2.280  1.00 28.74           C  
ATOM    581  O   SER    71      25.758   3.970   1.601  1.00 29.80           O  
ATOM    582  CB  SER    71      25.772   3.565   4.472  1.00 28.48           C  
ATOM    583  OG  SER    71      25.814   2.132   4.350  1.00 29.58           O  
ATOM    584  N   ASN    72      23.919   2.637   1.840  1.00 27.09           N  
ATOM    585  CA  ASN    72      24.109   1.939   0.546  0.50 27.05           C  
ATOM    587  C   ASN    72      25.380   1.091   0.533  1.00 26.48           C  
ATOM    588  O   ASN    72      25.998   0.890  -0.495  1.00 25.99           O  
ATOM    589  CB  ASN    72      24.106   2.893  -0.675  0.50 27.83           C  
ATOM    591  CG  ASN    72      22.703   3.159  -1.234  0.50 28.59           C  
ATOM    593  OD1 ASN    72      21.791   2.300  -1.198  0.50 32.27           O  
ATOM    595  ND2 ASN    72      22.528   4.359  -1.773  0.50 29.54           N  
ATOM    597  N   ASP    73      25.749   0.542   1.686  1.00 25.43           N  
ATOM    598  CA  ASP    73      26.875  -0.421   1.798  1.00 24.74           C  
ATOM    599  C   ASP    73      26.488  -1.639   0.942  1.00 23.75           C  
ATOM    600  O   ASP    73      25.420  -2.208   1.157  1.00 20.54           O  
ATOM    601  CB  ASP    73      27.027  -0.835   3.265  1.00 25.17           C  
ATOM    602  CG  ASP    73      28.020  -1.980   3.495  1.00 26.12           C  
ATOM    603  OD1 ASP    73      28.691  -2.475   2.569  1.00 30.99           O  
ATOM    604  OD2 ASP    73      28.101  -2.401   4.667  1.00 35.81           O  
ATOM    605  N   PRO    74      27.323  -2.022  -0.030  1.00 23.57           N  
ATOM    606  CA  PRO    74      26.905  -3.122  -0.921  1.00 24.30           C  
ATOM    607  C   PRO    74      26.670  -4.459  -0.231  1.00 24.84           C  
ATOM    608  O   PRO    74      25.870  -5.256  -0.709  1.00 26.45           O  
ATOM    609  CB  PRO    74      28.062  -3.203  -1.942  1.00 23.95           C  
ATOM    610  CG  PRO    74      28.658  -1.821  -1.905  1.00 24.58           C  
ATOM    611  CD  PRO    74      28.629  -1.482  -0.450  1.00 24.00           C  
ATOM    612  N   LYS    75      27.332  -4.708   0.891  1.00 25.11           N  
ATOM    613  CA  LYS    75      27.130  -5.948   1.623  1.00 26.59           C  
ATOM    614  C   LYS    75      25.736  -6.045   2.221  1.00 25.93           C  
ATOM    615  O   LYS    75      25.200  -7.135   2.361  1.00 27.46           O  
ATOM    616  CB  LYS    75      28.133  -6.079   2.757  1.00 27.40           C  
ATOM    617  CG  LYS    75      29.571  -6.266   2.291  1.00 30.20           C  
ATOM    618  CD  LYS    75      30.541  -6.071   3.457  1.00 30.42           C  
ATOM    619  CE  LYS    75      31.984  -6.045   2.995  1.00 33.03           C  
ATOM    620  NZ  LYS    75      32.892  -6.078   4.194  1.00 35.70           N  
ATOM    621  N   ILE    76      25.166  -4.913   2.601  1.00 23.73           N  
ATOM    622  CA  ILE    76      23.809  -4.916   3.141  1.00 23.46           C  
ATOM    623  C   ILE    76      22.796  -5.053   1.994  1.00 22.14           C  
ATOM    624  O   ILE    76      21.798  -5.755   2.127  1.00 20.70           O  
ATOM    625  CB  ILE    76      23.584  -3.686   4.022  1.00 24.00           C  
ATOM    626  CG1 ILE    76      24.357  -3.908   5.328  1.00 27.47           C  
ATOM    627  CG2 ILE    76      22.078  -3.476   4.336  1.00 23.08           C  
ATOM    628  CD1 ILE    76      24.772  -2.697   5.964  1.00 30.61           C  
ATOM    629  N   GLY    77      23.054  -4.389   0.872  1.00 21.67           N  
ATOM    630  CA  GLY    77      22.162  -4.511  -0.299  1.00 23.17           C  
ATOM    631  C   GLY    77      20.722  -4.151   0.019  1.00 23.16           C  
ATOM    632  O   GLY    77      20.499  -3.202   0.757  1.00 21.68           O  
ATOM    633  N   GLU    78      19.732  -4.918  -0.484  1.00 23.84           N  
ATOM    634  CA  GLU    78      18.312  -4.590  -0.222  1.00 24.68           C  
ATOM    635  C   GLU    78      17.813  -4.974   1.181  1.00 24.33           C  
ATOM    636  O   GLU    78      16.629  -4.789   1.473  1.00 25.22           O  
ATOM    637  CB  GLU    78      17.364  -5.168  -1.302  1.00 26.64           C  
ATOM    638  CG  GLU    78      17.418  -4.480  -2.675  1.00 29.65           C  
ATOM    639  CD  GLU    78      16.578  -3.175  -2.782  1.00 33.89           C  
ATOM    640  OE1 GLU    78      15.333  -3.239  -3.075  1.00 31.41           O  
ATOM    641  OE2 GLU    78      17.177  -2.079  -2.589  1.00 40.88           O  
ATOM    642  N   LYS    79      18.700  -5.410   2.079  1.00 22.93           N  
ATOM    643  CA  LYS    79      18.361  -5.427   3.493  1.00 23.03           C  
ATOM    644  C   LYS    79      18.274  -4.017   4.070  1.00 20.63           C  
ATOM    645  O   LYS    79      17.859  -3.837   5.206  1.00 20.01           O  
ATOM    646  CB  LYS    79      19.393  -6.225   4.292  1.00 23.69           C  
ATOM    647  CG  LYS    79      19.299  -7.709   3.999  1.00 26.92           C  
ATOM    648  CD  LYS    79      20.379  -8.489   4.748  1.00 28.53           C  
ATOM    649  CE  LYS    79      20.377  -9.959   4.320  1.00 31.81           C  
ATOM    650  NZ  LYS    79      21.343 -10.239   3.217  1.00 34.09           N  
ATOM    651  N   ARG    80      18.704  -3.024   3.298  1.00 21.12           N  
ATOM    652  CA  ARG    80      18.705  -1.639   3.757  1.00 20.87           C  
ATOM    653  C   ARG    80      17.293  -1.138   4.068  1.00 19.89           C  
ATOM    654  O   ARG    80      16.315  -1.671   3.561  1.00 20.87           O  
ATOM    655  CB  ARG    80      19.366  -0.719   2.751  1.00 21.02           C  
ATOM    656  CG  ARG    80      18.562  -0.475   1.551  1.00 22.63           C  
ATOM    657  CD  ARG    80      19.314   0.371   0.508  1.00 25.39           C  
ATOM    658  NE  ARG    80      18.437   0.440  -0.642  1.00 29.73           N  
ATOM    659  CZ  ARG    80      17.483   1.357  -0.864  1.00 32.12           C  
ATOM    660  NH1 ARG    80      17.229   2.386  -0.014  1.00 34.12           N  
ATOM    661  NH2 ARG    80      16.751   1.230  -1.965  1.00 29.96           N  
ATOM    662  N   ILE    81      17.237  -0.105   4.874  1.00 18.86           N  
ATOM    663  CA  ILE    81      15.997   0.629   5.137  1.00 18.98           C  
ATOM    664  C   ILE    81      15.544   1.319   3.844  1.00 19.21           C  
ATOM    665  O   ILE    81      16.338   2.004   3.173  1.00 21.40           O  
ATOM    666  CB  ILE    81      16.197   1.625   6.256  1.00 19.16           C  
ATOM    667  CG1 ILE    81      16.408   0.857   7.574  1.00 18.53           C  
ATOM    668  CG2 ILE    81      15.006   2.601   6.364  1.00 19.73           C  
ATOM    669  CD1 ILE    81      17.055   1.628   8.701  1.00 20.65           C  
ATOM    670  N   ARG    82      14.274   1.128   3.504  1.00 18.22           N  
ATOM    671  CA  ARG    82      13.688   1.557   2.209  0.50 17.65           C  
ATOM    673  C   ARG    82      12.182   1.643   2.425  1.00 17.73           C  
ATOM    674  O   ARG    82      11.660   1.090   3.399  1.00 16.98           O  
ATOM    675  CB  ARG    82      14.008   0.561   1.075  0.50 18.23           C  
ATOM    677  CG  ARG    82      13.015  -0.649   0.888  0.50 16.80           C  
ATOM    679  CD  ARG    82      13.220  -1.403  -0.465  0.50 17.15           C  
ATOM    681  NE  ARG    82      12.162  -2.396  -0.723  0.50 17.23           N  
ATOM    683  CZ  ARG    82      12.274  -3.709  -0.531  0.50 15.45           C  
ATOM    685  NH1 ARG    82      13.430  -4.257  -0.164  0.50 15.77           N  
ATOM    687  NH2 ARG    82      11.228  -4.497  -0.780  0.50 15.69           N  
ATOM    689  N   PRO    83      11.445   2.300   1.510  1.00 17.33           N  
ATOM    690  CA  PRO    83      10.002   2.307   1.757  1.00 16.91           C  
ATOM    691  C   PRO    83       9.361   0.934   1.945  1.00 16.61           C  
ATOM    692  O   PRO    83       9.564   0.019   1.119  1.00 17.77           O  
ATOM    693  CB  PRO    83       9.439   3.036   0.539  1.00 17.58           C  
ATOM    694  CG  PRO    83      10.548   3.837   0.051  1.00 16.41           C  
ATOM    695  CD  PRO    83      11.804   3.087   0.325  1.00 17.89           C  
ATOM    696  N   GLY    84       8.588   0.809   3.007  1.00 14.86           N  
ATOM    697  CA  GLY    84       7.959  -0.434   3.420  1.00 15.67           C  
ATOM    698  C   GLY    84       8.674  -1.152   4.541  1.00 15.52           C  
ATOM    699  O   GLY    84       8.121  -2.067   5.126  1.00 17.23           O  
ATOM    700  N   ALA    85       9.898  -0.737   4.843  1.00 15.34           N  
ATOM    701  CA  ALA    85      10.636  -1.389   5.913  1.00 15.80           C  
ATOM    702  C   ALA    85       9.875  -1.233   7.211  1.00 15.88           C  
ATOM    703  O   ALA    85       9.489  -0.137   7.570  1.00 16.97           O  
ATOM    704  CB  ALA    85      12.004  -0.790   6.026  1.00 15.08           C  
ATOM    705  N   LEU    86       9.720  -2.344   7.924  1.00 18.25           N  
ATOM    706  CA  LEU    86       9.190  -2.359   9.282  1.00 17.93           C  
ATOM    707  C   LEU    86      10.353  -2.152  10.253  1.00 18.43           C  
ATOM    708  O   LEU    86      11.299  -2.955  10.332  1.00 18.46           O  
ATOM    709  CB  LEU    86       8.472  -3.697   9.575  1.00 18.48           C  
ATOM    710  CG  LEU    86       7.905  -3.859  10.985  1.00 20.15           C  
ATOM    711  CD1 LEU    86       6.882  -2.777  11.316  1.00 23.23           C  
ATOM    712  CD2 LEU    86       7.327  -5.271  11.129  1.00 20.48           C  
ATOM    713  N   ILE    87      10.281  -1.045  10.979  1.00 17.40           N  
ATOM    714  CA  ILE    87      11.304  -0.664  11.971  1.00 17.79           C  
ATOM    715  C   ILE    87      10.691  -0.466  13.315  1.00 16.97           C  
ATOM    716  O   ILE    87       9.466  -0.472  13.474  1.00 18.03           O  
ATOM    717  CB  ILE    87      12.079   0.611  11.522  1.00 16.69           C  
ATOM    718  CG1 ILE    87      11.141   1.799  11.307  1.00 17.19           C  
ATOM    719  CG2 ILE    87      12.872   0.270  10.190  1.00 18.98           C  
ATOM    720  CD1 ILE    87      11.823   3.133  11.188  1.00 18.86           C  
ATOM    721  N   ARG    88      11.546  -0.259  14.292  1.00 16.37           N  
ATOM    722  CA  ARG    88      11.104   0.101  15.626  1.00 15.89           C  
ATOM    723  C   ARG    88      11.725   1.441  15.956  1.00 16.06           C  
ATOM    724  O   ARG    88      12.890   1.704  15.645  1.00 15.92           O  
ATOM    725  CB  ARG    88      11.551  -0.950  16.656  1.00 16.91           C  
ATOM    726  CG  ARG    88      11.052  -2.363  16.313  1.00 19.48           C  
ATOM    727  CD  ARG    88       9.563  -2.596  16.597  1.00 22.43           C  
ATOM    728  NE  ARG    88       9.195  -3.877  16.014  1.00 25.15           N  
ATOM    729  CZ  ARG    88       8.005  -4.465  16.140  1.00 24.03           C  
ATOM    730  NH1 ARG    88       7.064  -3.921  16.884  1.00 22.87           N  
ATOM    731  NH2 ARG    88       7.794  -5.626  15.506  1.00 26.11           N  
ATOM    732  N   VAL    89      10.947   2.244  16.646  1.00 16.11           N  
ATOM    733  CA  VAL    89      11.362   3.602  17.021  1.00 15.28           C  
ATOM    734  C   VAL    89      11.067   3.919  18.472  1.00 16.66           C  
ATOM    735  O   VAL    89      10.122   3.363  19.062  1.00 17.18           O  
ATOM    736  CB  VAL    89      10.672   4.637  16.105  1.00 15.17           C  
ATOM    737  CG1 VAL    89      11.089   4.396  14.673  1.00 16.98           C  
ATOM    738  CG2 VAL    89       9.155   4.521  16.206  1.00 17.06           C  
ATOM    739  N   LYS    90      11.848   4.847  19.017  1.00 16.96           N  
ATOM    740  CA  LYS    90      11.616   5.305  20.380  1.00 17.78           C  
ATOM    741  C   LYS    90      11.880   6.822  20.433  1.00 18.76           C  
ATOM    742  O   LYS    90      12.876   7.285  19.874  1.00 18.51           O  
ATOM    743  CB  LYS    90      12.577   4.566  21.301  1.00 18.95           C  
ATOM    744  CG  LYS    90      12.395   4.805  22.797  1.00 19.52           C  
ATOM    745  CD  LYS    90      13.376   3.969  23.591  1.00 22.77           C  
ATOM    746  CE  LYS    90      13.408   4.296  25.059  1.00 29.12           C  
ATOM    747  NZ  LYS    90      12.162   4.691  25.679  1.00 35.66           N  
ATOM    748  N   LYS    91      11.107   7.510  21.260  1.00 18.93           N  
ATOM    749  CA  LYS    91      11.228   8.949  21.424  1.00 19.03           C  
ATOM    750  C   LYS    91      12.187   9.212  22.587  1.00 19.84           C  
ATOM    751  O   LYS    91      11.983   8.683  23.701  1.00 20.14           O  
ATOM    752  CB  LYS    91       9.854   9.552  21.671  1.00 19.81           C  
ATOM    753  CG  LYS    91       9.830  11.072  21.577  1.00 20.93           C  
ATOM    754  CD  LYS    91       8.439  11.593  21.854  1.00 23.85           C  
ATOM    755  CE  LYS    91       8.249  13.016  21.413  1.00 30.64           C  
ATOM    756  NZ  LYS    91       6.944  13.499  21.917  1.00 34.58           N  
ATOM    757  N   THR    92      13.230   9.996  22.360  1.00 19.44           N  
ATOM    758  CA  THR    92      14.153  10.312  23.424  1.00 19.60           C  
ATOM    759  C   THR    92      13.562  11.349  24.389  1.00 18.84           C  
ATOM    760  O   THR    92      12.549  11.999  24.103  1.00 18.25           O  
ATOM    761  CB  THR    92      15.444  10.856  22.895  1.00 19.73           C  
ATOM    762  OG1 THR    92      15.176  12.183  22.388  1.00 21.01           O  
ATOM    763  CG2 THR    92      16.053   9.941  21.791  1.00 19.35           C  
ATOM    764  N   GLU    93      14.205  11.539  25.548  0.50 20.13           N  
ATOM    766  CA  GLU    93      13.705  12.522  26.511  0.50 20.76           C  
ATOM    768  C   GLU    93      13.826  13.956  25.987  0.50 19.67           C  
ATOM    770  O   GLU    93      13.197  14.874  26.521  0.50 19.80           O  
ATOM    772  CB  GLU    93      14.469  12.430  27.835  0.50 21.32           C  
ATOM    774  CG  GLU    93      14.239  11.166  28.623  0.50 23.98           C  
ATOM    776  CD  GLU    93      15.125  11.081  29.854  0.50 24.53           C  
ATOM    778  OE1 GLU    93      15.518   9.957  30.231  0.50 30.98           O  
ATOM    780  OE2 GLU    93      15.430  12.143  30.451  0.50 29.16           O  
ATOM    782  N   LYS    94      14.686  14.166  25.000  1.00 19.01           N  
ATOM    783  CA  LYS    94      14.783  15.473  24.385  1.00 18.39           C  
ATOM    784  C   LYS    94      13.725  15.668  23.293  1.00 16.81           C  
ATOM    785  O   LYS    94      13.533  16.802  22.866  1.00 18.00           O  
ATOM    786  CB  LYS    94      16.183  15.730  23.832  1.00 19.18           C  
ATOM    787  CG  LYS    94      17.248  15.787  24.880  1.00 21.72           C  
ATOM    788  CD  LYS    94      18.600  15.805  24.281  1.00 23.57           C  
ATOM    789  CE  LYS    94      19.662  15.916  25.368  1.00 26.08           C  
ATOM    790  NZ  LYS    94      21.041  15.663  24.797  1.00 29.86           N  
ATOM    791  N   GLY    95      13.022  14.605  22.914  1.00 16.22           N  
ATOM    792  CA  GLY    95      11.841  14.750  22.040  1.00 16.18           C  
ATOM    793  C   GLY    95      11.987  14.255  20.618  1.00 16.84           C  
ATOM    794  O   GLY    95      11.006  14.237  19.886  1.00 17.83           O  
ATOM    795  N   SER    96      13.182  13.851  20.222  1.00 16.29           N  
ATOM    796  CA  SER    96      13.410  13.388  18.856  1.00 15.32           C  
ATOM    797  C   SER    96      13.264  11.874  18.837  1.00 16.22           C  
ATOM    798  O   SER    96      13.576  11.174  19.825  1.00 15.94           O  
ATOM    799  CB  SER    96      14.825  13.781  18.368  1.00 15.41           C  
ATOM    800  OG  SER    96      15.042  15.172  18.223  1.00 17.04           O  
ATOM    801  N   TRP    97      12.799  11.328  17.709  1.00 15.27           N  
ATOM    802  CA  TRP    97      12.673   9.906  17.534  1.00 15.15           C  
ATOM    803  C   TRP    97      13.984   9.306  17.090  1.00 15.23           C  
ATOM    804  O   TRP    97      14.751   9.940  16.370  1.00 15.34           O  
ATOM    805  CB  TRP    97      11.574   9.586  16.500  1.00 16.75           C  
ATOM    806  CG  TRP    97      10.188   9.910  17.049  1.00 17.02           C  
ATOM    807  CD1 TRP    97       9.539  11.094  16.962  1.00 19.56           C  
ATOM    808  CD2 TRP    97       9.317   9.038  17.788  1.00 17.19           C  
ATOM    809  NE1 TRP    97       8.330  11.038  17.621  1.00 18.92           N  
ATOM    810  CE2 TRP    97       8.159   9.773  18.106  1.00 19.29           C  
ATOM    811  CE3 TRP    97       9.412   7.721  18.226  1.00 18.37           C  
ATOM    812  CZ2 TRP    97       7.109   9.234  18.854  1.00 20.16           C  
ATOM    813  CZ3 TRP    97       8.337   7.178  18.931  1.00 17.75           C  
ATOM    814  CH2 TRP    97       7.222   7.945  19.254  1.00 19.63           C  
ATOM    815  N   GLN    98      14.221   8.054  17.494  1.00 15.53           N  
ATOM    816  CA  GLN    98      15.374   7.289  17.078  0.50 15.84           C  
ATOM    818  C   GLN    98      14.962   5.908  16.599  1.00 15.82           C  
ATOM    819  O   GLN    98      13.994   5.322  17.111  1.00 16.55           O  
ATOM    820  CB  GLN    98      16.352   7.171  18.259  0.50 16.46           C  
ATOM    822  CG  GLN    98      15.755   6.389  19.416  0.50 17.45           C  
ATOM    824  CD  GLN    98      16.493   6.471  20.731  0.50 18.58           C  
ATOM    826  OE1 GLN    98      15.872   6.257  21.781  0.50 19.21           O  
ATOM    828  NE2 GLN    98      17.791   6.726  20.694  0.50 20.26           N  
ATOM    830  N   ILE    99      15.703   5.374  15.626  1.00 15.21           N  
ATOM    831  CA  ILE    99      15.526   3.998  15.150  1.00 15.51           C  
ATOM    832  C   ILE    99      16.314   3.078  16.081  1.00 16.61           C  
ATOM    833  O   ILE    99      17.548   3.215  16.279  1.00 16.58           O  
ATOM    834  CB  ILE    99      15.998   3.819  13.727  1.00 16.25           C  
ATOM    835  CG1 ILE    99      15.225   4.730  12.764  1.00 16.91           C  
ATOM    836  CG2 ILE    99      15.907   2.332  13.370  1.00 18.24           C  
ATOM    837  CD1 ILE    99      15.645   4.639  11.292  1.00 16.52           C  
ATOM    838  N   VAL   100      15.562   2.173  16.680  1.00 17.39           N  
ATOM    839  CA  VAL   100      16.095   1.202  17.630  1.00 18.63           C  
ATOM    840  C   VAL   100      15.672  -0.230  17.234  1.00 19.15           C  
ATOM    841  O   VAL   100      15.194  -0.468  16.147  1.00 17.97           O  
ATOM    842  CB  VAL   100      15.581   1.541  19.043  1.00 18.73           C  
ATOM    843  CG1 VAL   100      16.085   2.916  19.465  1.00 18.33           C  
ATOM    844  CG2 VAL   100      14.053   1.456  19.153  1.00 21.54           C  
ATOM    845  N   GLN   101      15.841  -1.182  18.141  1.00 21.54           N  
ATOM    846  CA  GLN   101      15.350  -2.538  17.848  1.00 22.47           C  
ATOM    847  C   GLN   101      14.877  -3.189  19.126  1.00 23.43           C  
ATOM    848  O   GLN   101      15.243  -2.736  20.207  1.00 23.82           O  
ATOM    849  CB  GLN   101      16.395  -3.345  17.139  1.00 23.76           C  
ATOM    850  CG  GLN   101      17.643  -3.604  17.930  1.00 23.42           C  
ATOM    851  CD  GLN   101      18.756  -4.193  17.109  1.00 24.69           C  
ATOM    852  OE1 GLN   101      18.587  -4.586  15.951  1.00 25.77           O  
ATOM    853  NE2 GLN   101      19.941  -4.248  17.713  1.00 30.47           N  
ATOM    854  N   LEU   102      14.003  -4.177  19.000  1.00 25.80           N  
ATOM    855  CA  LEU   102      13.433  -4.833  20.175  1.00 29.29           C  
ATOM    856  C   LEU   102      14.548  -5.593  20.875  1.00 30.90           C  
ATOM    857  O   LEU   102      15.441  -6.127  20.212  1.00 30.78           O  
ATOM    858  CB  LEU   102      12.266  -5.755  19.791  1.00 29.31           C  
ATOM    859  CG  LEU   102      10.972  -5.020  19.413  1.00 30.58           C  
ATOM    860  CD1 LEU   102       9.988  -5.946  18.738  1.00 31.16           C  
ATOM    861  CD2 LEU   102      10.360  -4.260  20.587  1.00 31.70           C  
ATOM    862  N   PRO   103      14.502  -5.653  22.228  1.00 32.79           N  
ATOM    863  CA  PRO   103      15.587  -6.344  22.947  1.00 33.77           C  
ATOM    864  C   PRO   103      15.589  -7.835  22.604  1.00 35.69           C  
ATOM    865  O   PRO   103      14.522  -8.422  22.400  1.00 36.77           O  
ATOM    866  CB  PRO   103      15.235  -6.128  24.423  1.00 34.74           C  
ATOM    867  CG  PRO   103      13.758  -5.776  24.444  1.00 34.13           C  
ATOM    868  CD  PRO   103      13.465  -5.114  23.135  1.00 33.44           C  
ATOM    869  OXT PRO   103      16.642  -8.473  22.459  1.00 37.09           O  
END
