
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   63 (  472),  selected   63 , name 3cp0_A
# Molecule2: number of CA atoms  103 (  801),  selected  103 , name T0409.pdb
# PARAMETERS: 3cp0_A.T0409.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S    17_A      Y       1           -
LGA    P    18_A      R       2           -
LGA    R    19_A      G       3           -
LGA    A    20_A      P       4           -
LGA    L    21_A      E       5           -
LGA    -       -      A       6           -
LGA    -       -      F       7           -
LGA    -       -      L       8           -
LGA    -       -      K       9           -
LGA    -       -      L      10           -
LGA    -       -      P      11           -
LGA    -       -      K      12           -
LGA    -       -      D      13           -
LGA    -       -      L      14           -
LGA    -       -      K      15           -
LGA    -       -      D      16           -
LGA    -       -      R      17           -
LGA    -       -      E      18           -
LGA    -       -      A      19           -
LGA    -       -      L      20           -
LGA    -       -      Q      21           -
LGA    -       -      D      22           -
LGA    -       -      I      23           -
LGA    -       -      M      24           -
LGA    -       -      Q      25           -
LGA    -       -      D      26           -
LGA    -       -      I      27           -
LGA    -       -      G      28           -
LGA    -       -      N      29           -
LGA    -       -      S      30           -
LGA    -       -      D      31           -
LGA    V    22_A      D      32          3.020
LGA    G    23_A      I      33          0.639
LGA    H    24_A      L      34          0.654
LGA    R    25_A      A      35          0.922
LGA    A    26_A      A      36          0.614
LGA    E    27_A      V      37          0.642
LGA    V    28_A      V      38          0.523
LGA    L    29_A      L      39          0.782
LGA    E    30_A      S      40          0.779
LGA    D    31_A      A      41          0.961
LGA    V    32_A      T      42          5.276
LGA    G    33_A      P      43          3.582
LGA    A    34_A      -       -           -
LGA    T    35_A      G      44          2.437
LGA    S    36_A      A      45          0.904
LGA    G    37_A      V      46          1.201
LGA    Q    38_A      E      47          0.646
LGA    V    39_A      A      48          0.636
LGA    R    40_A      F      49          0.515
LGA    L    41_A      R      50          1.569
LGA    D    42_A      K      51          3.230
LGA    -       -      N      52           -
LGA    G    43_A      G      53          0.438
LGA    S    44_A      E      54          0.815
LGA    I    45_A      T      55          0.781
LGA    W    46_A      I      56          0.676
LGA    S    47_A      R      57          0.726
LGA    A    48_A      I      58          1.335
LGA    R    49_A      T      59          3.658
LGA    -       -      G      60           -
LGA    -       -      D      61           -
LGA    -       -      G      62           -
LGA    S    50_A      L      63          2.187
LGA    X    51_A      K      64          3.808
LGA    D    52_A      A      65          2.084
LGA    -       -      A      66           -
LGA    P    53_A      H      67          2.696
LGA    T    54_A      R      68          3.259
LGA    H    55_A      F      69          2.490
LGA    T    56_A      L      70          1.852
LGA    -       -      S      71           -
LGA    -       -      N      72           -
LGA    -       -      D      73           -
LGA    -       -      P      74           -
LGA    -       -      K      75           -
LGA    -       -      I      76           -
LGA    -       -      G      77           -
LGA    -       -      E      78           -
LGA    -       -      K      79           -
LGA    -       -      R      80           -
LGA    F    57_A      I      81          1.550
LGA    A    58_A      R      82          1.079
LGA    E    59_A      P      83          1.058
LGA    G    60_A      G      84          0.509
LGA    E    61_A      A      85          0.297
LGA    I    62_A      L      86          0.661
LGA    V    63_A      I      87          0.601
LGA    S    64_A      R      88          0.765
LGA    V    65_A      V      89          0.993
LGA    I    66_A      K      90          3.594
LGA    D    67_A      K      91          4.197
LGA    I    68_A      T      92          2.766
LGA    Q    69_A      E      93           #
LGA    G    70_A      K      94          4.224
LGA    T    71_A      G      95          4.257
LGA    T    72_A      S      96          2.883
LGA    A    73_A      W      97          1.399
LGA    I    74_A      Q      98          0.562
LGA    V    75_A      I      99          0.546
LGA    W    76_A      V     100          3.009
LGA    K    77_A      Q     101          4.281
LGA    E    78_A      -       -           -
LGA    A    79_A      L     102          2.869
LGA    -       -      P     103           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   63  103    5.0     55    2.23    10.91     43.046     2.360

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.915605 * X  +   0.358277 * Y  +  -0.182497 * Z  +  -2.253545
  Y_new =  -0.031908 * X  +  -0.387708 * Y  +  -0.921230 * Z  +  31.264881
  Z_new =  -0.400812 * X  +   0.849305 * Y  +  -0.343555 * Z  +  27.244320 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.955187   -1.186405  [ DEG:   112.0240    -67.9760 ]
  Theta =   0.412403    2.729190  [ DEG:    23.6289    156.3711 ]
  Phi   =  -0.034835    3.106758  [ DEG:    -1.9959    178.0041 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3cp0_A                                        
REMARK     2: T0409.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3cp0_A.T0409.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   63  103   5.0   55   2.23   10.91  43.046
REMARK  ---------------------------------------------------------- 
MOLECULE 3cp0_A
HEADER    MEMBRANE PROTEIN                        30-MAR-08   3CP0              
TITLE     CRYSTAL STRUCTURE OF THE SOLUBLE DOMAIN OF MEMBRANE PROTEIN           
TITLE    2 IMPLICATED IN REGULATION OF MEMBRANE PROTEASE ACTIVITY               
TITLE    3 FROM CORYNEBACTERIUM GLUTAMICUM                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MEMBRANE PROTEIN IMPLICATED IN REGULATION OF               
COMPND   3 MEMBRANE PROTEASE ACTIVITY;                                          
COMPND   4 CHAIN: A;                                                            
COMPND   5 FRAGMENT: CG1731 DOMAIN: RESIDUES 64-142;                            
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: CORYNEBACTERIUM GLUTAMICUM ATCC 13032;          
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: DSM 20300 / JCM 1318 / LMG 3730 / NCIMB 10025;               
SOURCE   5 ATCC: 13032;                                                         
SOURCE   6 GENE: CG1731;                                                        
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    BETA BARREL, STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE            
KEYWDS   2 INITIATIVE, MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG,            
KEYWDS   3 PROTEASE, MEMBRANE PROTEIN                                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.KIM,C.TESAR,J.ABDULLAH,A.JOACHIMIAK,MIDWEST CENTER FOR              
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   15-APR-08 3CP0    0                                                
JRNL        AUTH   Y.KIM,C.TESAR,J.ABDULLAH,A.JOACHIMIAK                        
JRNL        TITL   THE CRYSTAL STRUCTURE OF THE SOLUBLE DOMAIN OF               
JRNL        TITL 2 MEMBRANE PROTEIN IMPLICATED IN REGULATION OF                 
JRNL        TITL 3 MEMBRANE PROTEASE ACTIVITY FROM CORYNEBACTERIUM              
JRNL        TITL 4 GLUTAMICUM.                                                  
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.65 ANGSTROMS.                                          
DBREF  3CP0 A    1    79  UNP    Q6M555   Q6M555_CORGL    64    142             
SEQRES   1 A   82  SER ASN ALA ARG PRO ALA ILE ARG LYS ARG LEU LEU LYS          
SEQRES   2 A   82  PRO LYS VAL LEU ASP SER SER PRO ARG ALA LEU VAL GLY          
SEQRES   3 A   82  HIS ARG ALA GLU VAL LEU GLU ASP VAL GLY ALA THR SER          
SEQRES   4 A   82  GLY GLN VAL ARG LEU ASP GLY SER ILE TRP SER ALA ARG          
SEQRES   5 A   82  SER MSE ASP PRO THR HIS THR PHE ALA GLU GLY GLU ILE          
SEQRES   6 A   82  VAL SER VAL ILE ASP ILE GLN GLY THR THR ALA ILE VAL          
SEQRES   7 A   82  TRP LYS GLU ALA                                              
HET    MSE  A  51       8                                                       
HET     ZN  A 101       1                                                       
HET     ZN  A 102       1                                                       
HET     ZN  A 103       1                                                       
HET     CL  A 104       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      ZN ZINC ION                                                         
HETNAM      CL CHLORIDE ION                                                     
FORMUL   1  MSE    C5 H11 N O2 SE                                               
FORMUL   2   ZN    3(ZN 2+)                                                     
FORMUL   5   CL    CL 1-                                                        
FORMUL   6  HOH   *52(H2 O)                                                     
CRYST1   42.546   53.084   64.357  90.00  90.00  90.00 I 21 21 21    8          
ATOM      1  N   SER A  17       6.237  13.791  26.764  0.70 39.09           N  
ATOM      2  CA  SER A  17       5.262  12.712  26.443  0.70 38.48           C  
ATOM      3  C   SER A  17       5.656  11.951  25.189  0.70 37.51           C  
ATOM      4  O   SER A  17       5.254  10.797  25.041  0.70 38.12           O  
ATOM      5  CB  SER A  17       3.822  13.248  26.338  0.70 38.90           C  
ATOM      6  OG  SER A  17       3.680  14.189  25.283  0.70 39.96           O  
ATOM      7  N   PRO A  18       6.462  12.568  24.285  0.60 36.37           N  
ATOM      8  CA  PRO A  18       6.928  11.740  23.170  0.60 35.08           C  
ATOM      9  C   PRO A  18       7.674  10.482  23.648  0.60 33.73           C  
ATOM     10  O   PRO A  18       7.729   9.513  22.918  0.60 32.85           O  
ATOM     11  CB  PRO A  18       7.850  12.677  22.381  0.60 35.05           C  
ATOM     12  CG  PRO A  18       7.375  14.049  22.741  0.60 36.02           C  
ATOM     13  CD  PRO A  18       6.974  13.947  24.182  0.60 36.35           C  
ATOM     14  N   ARG A  19       8.194  10.538  24.877  0.50 33.69           N  
ATOM     16  CA  ARG A  19       8.843   9.416  25.582  0.50 33.09           C  
ATOM     18  C   ARG A  19       8.050   8.083  25.616  0.50 32.32           C  
ATOM     20  O   ARG A  19       8.650   7.001  25.701  0.50 32.03           O  
ATOM     22  CB  ARG A  19       9.138   9.856  27.017  0.50 33.36           C  
ATOM     24  CG  ARG A  19      10.448   9.354  27.621  0.50 34.77           C  
ATOM     26  CD  ARG A  19      11.671  10.108  27.069  0.50 34.04           C  
ATOM     28  NE  ARG A  19      12.722   9.144  26.779  0.50 33.03           N  
ATOM     30  CZ  ARG A  19      13.557   9.200  25.744  0.50 32.66           C  
ATOM     32  NH1 ARG A  19      13.514  10.209  24.879  0.50 27.57           N  
ATOM     34  NH2 ARG A  19      14.446   8.230  25.582  0.50 33.11           N  
ATOM     36  N   ALA A  20       6.715   8.173  25.584  1.00 30.94           N  
ATOM     37  CA  ALA A  20       5.807   6.992  25.592  1.00 29.69           C  
ATOM     38  C   ALA A  20       5.838   6.254  24.252  1.00 27.59           C  
ATOM     39  O   ALA A  20       5.376   5.106  24.156  1.00 29.27           O  
ATOM     40  CB  ALA A  20       4.390   7.408  25.905  1.00 30.99           C  
ATOM     41  N   LEU A  21       6.389   6.916  23.233  1.00 24.61           N  
ATOM     42  CA  LEU A  21       6.528   6.308  21.895  1.00 23.82           C  
ATOM     43  C   LEU A  21       7.701   5.303  21.809  1.00 21.60           C  
ATOM     44  O   LEU A  21       7.780   4.528  20.880  1.00 20.38           O  
ATOM     45  CB  LEU A  21       6.658   7.354  20.794  1.00 24.01           C  
ATOM     46  CG  LEU A  21       5.372   8.191  20.621  1.00 27.82           C  
ATOM     47  CD1 LEU A  21       5.628   9.247  19.589  1.00 30.59           C  
ATOM     48  CD2 LEU A  21       4.124   7.338  20.264  1.00 29.50           C  
ATOM     49  N   VAL A  22       8.588   5.336  22.797  1.00 19.27           N  
ATOM     50  CA  VAL A  22       9.774   4.495  22.717  1.00 19.71           C  
ATOM     51  C   VAL A  22       9.313   3.073  22.953  1.00 19.16           C  
ATOM     52  O   VAL A  22       8.603   2.809  23.906  1.00 21.21           O  
ATOM     53  CB  VAL A  22      10.809   4.973  23.739  1.00 21.62           C  
ATOM     54  CG1 VAL A  22      11.951   4.066  23.752  1.00 23.31           C  
ATOM     55  CG2 VAL A  22      11.243   6.408  23.371  1.00 21.83           C  
ATOM     56  N   GLY A  23       9.726   2.177  22.062  1.00 17.36           N  
ATOM     57  CA  GLY A  23       9.345   0.795  22.070  1.00 18.55           C  
ATOM     58  C   GLY A  23       8.279   0.519  21.013  1.00 19.12           C  
ATOM     59  O   GLY A  23       8.043  -0.654  20.688  1.00 21.50           O  
ATOM     60  N   HIS A  24       7.679   1.566  20.453  1.00 18.41           N  
ATOM     61  CA  HIS A  24       6.695   1.346  19.340  1.00 17.77           C  
ATOM     62  C   HIS A  24       7.409   0.936  18.065  1.00 18.05           C  
ATOM     63  O   HIS A  24       8.516   1.441  17.769  1.00 19.70           O  
ATOM     64  CB  HIS A  24       5.957   2.648  18.975  1.00 17.66           C  
ATOM     65  CG  HIS A  24       4.867   3.054  19.939  1.00 18.70           C  
ATOM     66  ND1 HIS A  24       4.965   2.921  21.317  1.00 18.68           N  
ATOM     67  CD2 HIS A  24       3.669   3.661  19.698  1.00 19.19           C  
ATOM     68  CE1 HIS A  24       3.870   3.419  21.875  1.00 22.19           C  
ATOM     69  NE2 HIS A  24       3.066   3.846  20.911  1.00 20.94           N  
ATOM     70  N   ARG A  25       6.762   0.109  17.256  1.00 18.61           N  
ATOM     71  CA  ARG A  25       7.212  -0.067  15.879  1.00 18.07           C  
ATOM     72  C   ARG A  25       6.729   1.076  14.983  1.00 19.35           C  
ATOM     73  O   ARG A  25       5.732   1.779  15.300  1.00 19.98           O  
ATOM     74  CB  ARG A  25       6.718  -1.398  15.376  1.00 18.59           C  
ATOM     75  CG  ARG A  25       7.500  -2.539  16.134  1.00 20.33           C  
ATOM     76  CD  ARG A  25       6.747  -3.780  15.977  1.00 24.99           C  
ATOM     77  NE  ARG A  25       7.404  -4.862  16.710  1.00 25.54           N  
ATOM     78  CZ  ARG A  25       7.214  -5.119  18.006  1.00 30.77           C  
ATOM     79  NH1 ARG A  25       6.356  -4.368  18.736  1.00 26.41           N  
ATOM     80  NH2 ARG A  25       7.852  -6.139  18.565  1.00 31.26           N  
ATOM     81  N   ALA A  26       7.360   1.221  13.823  1.00 18.47           N  
ATOM     82  CA  ALA A  26       6.941   2.263  12.867  1.00 19.20           C  
ATOM     83  C   ALA A  26       7.246   1.764  11.461  1.00 18.65           C  
ATOM     84  O   ALA A  26       8.195   0.994  11.256  1.00 19.90           O  
ATOM     85  CB  ALA A  26       7.697   3.565  13.151  1.00 19.33           C  
ATOM     86  N   GLU A  27       6.529   2.326  10.512  1.00 18.05           N  
ATOM     87  CA  GLU A  27       6.697   1.926   9.122  1.00 18.02           C  
ATOM     88  C   GLU A  27       7.428   3.033   8.371  1.00 18.55           C  
ATOM     89  O   GLU A  27       7.090   4.238   8.493  1.00 18.17           O  
ATOM     90  CB  GLU A  27       5.312   1.681   8.539  1.00 17.29           C  
ATOM     91  CG  GLU A  27       5.381   1.283   7.126  1.00 20.59           C  
ATOM     92  CD  GLU A  27       3.999   0.904   6.514  1.00 28.56           C  
ATOM     93  OE1 GLU A  27       2.936   0.952   7.207  1.00 31.03           O  
ATOM     94  OE2 GLU A  27       4.005   0.548   5.328  1.00 32.76           O  
ATOM     95  N   VAL A  28       8.497   2.655   7.672  1.00 17.73           N  
ATOM     96  CA  VAL A  28       9.312   3.676   6.987  1.00 18.20           C  
ATOM     97  C   VAL A  28       8.554   4.224   5.770  1.00 18.86           C  
ATOM     98  O   VAL A  28       8.087   3.457   4.914  1.00 18.74           O  
ATOM     99  CB  VAL A  28      10.682   3.142   6.558  1.00 18.87           C  
ATOM    100  CG1 VAL A  28      11.415   4.226   5.743  1.00 18.14           C  
ATOM    101  CG2 VAL A  28      11.545   2.680   7.816  1.00 17.98           C  
ATOM    102  N   LEU A  29       8.374   5.549   5.730  1.00 18.49           N  
ATOM    103  CA  LEU A  29       7.734   6.205   4.577  1.00 20.11           C  
ATOM    104  C   LEU A  29       8.713   6.833   3.617  1.00 20.55           C  
ATOM    105  O   LEU A  29       8.428   6.884   2.402  1.00 20.86           O  
ATOM    106  CB  LEU A  29       6.753   7.319   5.019  1.00 20.19           C  
ATOM    107  CG  LEU A  29       5.675   6.882   6.000  1.00 25.20           C  
ATOM    108  CD1 LEU A  29       4.821   8.068   6.387  1.00 28.32           C  
ATOM    109  CD2 LEU A  29       4.808   5.749   5.420  1.00 25.79           C  
ATOM    110  N   GLU A  30       9.782   7.427   4.144  0.50 20.28           N  
ATOM    112  CA  GLU A  30      10.897   7.874   3.309  0.50 20.55           C  
ATOM    114  C   GLU A  30      12.153   7.343   3.965  0.50 20.28           C  
ATOM    116  O   GLU A  30      12.269   7.348   5.208  0.50 19.50           O  
ATOM    118  CB  GLU A  30      10.950   9.393   3.224  0.50 21.00           C  
ATOM    120  CG  GLU A  30       9.623  10.064   2.945  0.50 23.43           C  
ATOM    122  CD  GLU A  30       9.174   9.988   1.487  0.50 30.69           C  
ATOM    124  OE1 GLU A  30       9.882   9.394   0.626  0.50 31.97           O  
ATOM    126  OE2 GLU A  30       8.087  10.546   1.205  0.50 32.86           O  
ATOM    128  N   ASP A  31      13.091   6.892   3.133  1.00 19.62           N  
ATOM    129  CA  ASP A  31      14.279   6.140   3.597  1.00 20.03           C  
ATOM    130  C   ASP A  31      14.950   6.825   4.780  1.00 20.63           C  
ATOM    131  O   ASP A  31      15.220   8.054   4.706  1.00 18.92           O  
ATOM    132  CB  ASP A  31      15.338   6.022   2.494  1.00 22.06           C  
ATOM    133  CG  ASP A  31      14.923   5.147   1.333  1.00 26.34           C  
ATOM    134  OD1 ASP A  31      13.752   4.697   1.230  1.00 28.79           O  
ATOM    135  OD2 ASP A  31      15.832   4.921   0.469  1.00 35.85           O  
ATOM    136  N   VAL A  32      15.208   6.042   5.820  1.00 19.39           N  
ATOM    137  CA  VAL A  32      15.765   6.553   7.078  1.00 19.57           C  
ATOM    138  C   VAL A  32      17.241   6.257   7.173  1.00 22.32           C  
ATOM    139  O   VAL A  32      17.647   5.092   7.165  1.00 23.73           O  
ATOM    140  CB  VAL A  32      15.070   5.927   8.311  1.00 18.86           C  
ATOM    141  CG1 VAL A  32      15.730   6.411   9.623  1.00 23.54           C  
ATOM    142  CG2 VAL A  32      13.584   6.247   8.300  1.00 18.57           C  
ATOM    143  N   GLY A  33      18.053   7.286   7.321  1.00 20.99           N  
ATOM    144  CA  GLY A  33      19.491   7.102   7.437  1.00 19.76           C  
ATOM    145  C   GLY A  33      20.062   8.091   8.430  1.00 22.25           C  
ATOM    146  O   GLY A  33      19.481   8.335   9.495  1.00 19.98           O  
ATOM    147  N   ALA A  34      21.259   8.592   8.102  1.00 22.69           N  
ATOM    148  CA  ALA A  34      22.012   9.400   9.068  1.00 25.85           C  
ATOM    149  C   ALA A  34      21.311  10.686   9.463  1.00 28.04           C  
ATOM    150  O   ALA A  34      21.322  11.032  10.652  1.00 30.81           O  
ATOM    151  CB  ALA A  34      23.417   9.725   8.536  1.00 23.75           C  
ATOM    152  N   THR A  35      20.731  11.382   8.479  0.60 28.87           N  
ATOM    154  CA  THR A  35      20.215  12.772   8.639  0.60 30.50           C  
ATOM    156  C   THR A  35      18.914  13.076   7.852  0.60 29.89           C  
ATOM    158  O   THR A  35      18.612  14.238   7.486  0.60 28.94           O  
ATOM    160  CB  THR A  35      21.274  13.823   8.272  0.60 30.18           C  
ATOM    162  OG1 THR A  35      21.618  13.701   6.884  0.60 33.85           O  
ATOM    164  CG2 THR A  35      22.536  13.664   9.149  0.60 30.62           C  
ATOM    166  N   SER A  36      18.124  12.032   7.621  1.00 28.86           N  
ATOM    167  CA  SER A  36      16.791  12.223   7.094  1.00 27.70           C  
ATOM    168  C   SER A  36      16.023  10.926   7.202  1.00 24.65           C  
ATOM    169  O   SER A  36      16.604   9.887   7.431  1.00 22.67           O  
ATOM    170  CB  SER A  36      16.819  12.739   5.661  1.00 28.76           C  
ATOM    171  OG  SER A  36      17.224  11.699   4.797  1.00 35.24           O  
ATOM    172  N   GLY A  37      14.695  11.017   7.089  1.00 21.71           N  
ATOM    173  CA  GLY A  37      13.850   9.842   7.162  1.00 19.42           C  
ATOM    174  C   GLY A  37      12.492  10.236   7.754  1.00 19.13           C  
ATOM    175  O   GLY A  37      12.372  11.230   8.484  1.00 18.24           O  
ATOM    176  N   GLN A  38      11.486   9.470   7.430  1.00 16.74           N  
ATOM    177  CA  GLN A  38      10.136   9.705   7.941  1.00 17.36           C  
ATOM    178  C   GLN A  38       9.493   8.358   8.156  1.00 17.21           C  
ATOM    179  O   GLN A  38       9.643   7.442   7.305  1.00 18.12           O  
ATOM    180  CB  GLN A  38       9.298  10.540   6.973  1.00 17.90           C  
ATOM    181  CG  GLN A  38       9.780  11.998   6.893  1.00 18.14           C  
ATOM    182  CD  GLN A  38       8.859  12.901   6.041  1.00 22.57           C  
ATOM    183  OE1 GLN A  38       7.719  12.537   5.682  1.00 28.32           O  
ATOM    184  NE2 GLN A  38       9.367  14.082   5.706  1.00 29.02           N  
ATOM    185  N   VAL A  39       8.774   8.261   9.265  1.00 16.92           N  
ATOM    186  CA  VAL A  39       8.061   7.001   9.553  1.00 16.67           C  
ATOM    187  C   VAL A  39       6.617   7.291   9.945  1.00 18.20           C  
ATOM    188  O   VAL A  39       6.292   8.404  10.370  1.00 17.77           O  
ATOM    189  CB  VAL A  39       8.742   6.216  10.726  1.00 17.92           C  
ATOM    190  CG1 VAL A  39      10.188   5.828  10.371  1.00 18.83           C  
ATOM    191  CG2 VAL A  39       8.699   7.064  12.061  1.00 18.65           C  
ATOM    192  N   ARG A  40       5.770   6.264   9.840  0.50 17.60           N  
ATOM    194  CA  ARG A  40       4.376   6.318  10.311  0.50 19.08           C  
ATOM    196  C   ARG A  40       4.274   5.651  11.696  0.50 18.59           C  
ATOM    198  O   ARG A  40       4.556   4.446  11.850  0.50 18.01           O  
ATOM    200  CB  ARG A  40       3.437   5.648   9.278  0.50 18.84           C  
ATOM    202  CG  ARG A  40       1.994   5.428   9.793  0.50 19.52           C  
ATOM    204  CD  ARG A  40       0.947   5.185   8.669  0.50 22.32           C  
ATOM    206  NE  ARG A  40       1.469   4.379   7.559  0.50 29.53           N  
ATOM    208  CZ  ARG A  40       0.860   4.199   6.390  0.50 31.05           C  
ATOM    210  NH1 ARG A  40      -0.319   4.761   6.134  0.50 32.57           N  
ATOM    212  NH2 ARG A  40       1.435   3.446   5.465  0.50 33.98           N  
ATOM    214  N   LEU A  41       3.888   6.430  12.699  1.00 18.52           N  
ATOM    215  CA  LEU A  41       3.970   6.029  14.108  1.00 20.06           C  
ATOM    216  C   LEU A  41       2.660   6.520  14.816  1.00 19.01           C  
ATOM    217  O   LEU A  41       2.369   7.738  14.825  1.00 18.32           O  
ATOM    218  CB  LEU A  41       5.242   6.695  14.731  1.00 21.29           C  
ATOM    219  CG  LEU A  41       5.428   6.549  16.240  1.00 21.78           C  
ATOM    220  CD1 LEU A  41       5.464   5.069  16.684  1.00 23.11           C  
ATOM    221  CD2 LEU A  41       6.793   7.237  16.534  1.00 21.51           C  
ATOM    222  N   ASP A  42       1.862   5.591  15.375  1.00 18.60           N  
ATOM    223  CA  ASP A  42       0.555   5.941  16.006  1.00 19.62           C  
ATOM    224  C   ASP A  42      -0.308   6.813  15.060  1.00 19.54           C  
ATOM    225  O   ASP A  42      -0.946   7.785  15.460  1.00 20.21           O  
ATOM    226  CB  ASP A  42       0.743   6.654  17.362  1.00 18.80           C  
ATOM    227  CG  ASP A  42       0.891   5.695  18.543  1.00 21.69           C  
ATOM    228  OD1 ASP A  42       0.987   4.456  18.328  1.00 18.78           O  
ATOM    229  OD2 ASP A  42       0.937   6.159  19.725  1.00 21.50           O  
ATOM    230  N   GLY A  43      -0.275   6.472  13.781  1.00 20.18           N  
ATOM    231  CA  GLY A  43      -1.172   7.102  12.822  1.00 20.38           C  
ATOM    232  C   GLY A  43      -0.707   8.457  12.301  1.00 21.19           C  
ATOM    233  O   GLY A  43      -1.428   9.118  11.515  1.00 23.58           O  
ATOM    234  N   SER A  44       0.467   8.898  12.752  0.50 19.94           N  
ATOM    236  CA  SER A  44       1.024  10.177  12.324  0.50 19.91           C  
ATOM    238  C   SER A  44       2.365  10.010  11.597  0.50 18.94           C  
ATOM    240  O   SER A  44       2.994   8.954  11.688  0.50 18.72           O  
ATOM    242  CB  SER A  44       1.218  11.095  13.533  0.50 20.86           C  
ATOM    244  OG  SER A  44      -0.022  11.576  14.040  0.50 23.47           O  
ATOM    246  N   ILE A  45       2.801  11.064  10.890  1.00 17.68           N  
ATOM    247  CA  ILE A  45       4.125  11.063  10.260  1.00 18.51           C  
ATOM    248  C   ILE A  45       5.125  11.755  11.191  1.00 18.54           C  
ATOM    249  O   ILE A  45       4.883  12.892  11.575  1.00 18.99           O  
ATOM    250  CB  ILE A  45       4.044  11.827   8.919  1.00 20.49           C  
ATOM    251  CG1 ILE A  45       3.099  11.035   7.995  1.00 21.41           C  
ATOM    252  CG2 ILE A  45       5.455  11.966   8.349  1.00 21.87           C  
ATOM    253  CD1 ILE A  45       2.981  11.644   6.593  1.00 28.21           C  
ATOM    254  N   TRP A  46       6.206  11.057  11.520  1.00 17.71           N  
ATOM    255  CA  TRP A  46       7.283  11.544  12.371  1.00 17.23           C  
ATOM    256  C   TRP A  46       8.596  11.547  11.599  1.00 15.93           C  
ATOM    257  O   TRP A  46       8.919  10.615  10.871  1.00 16.88           O  
ATOM    258  CB  TRP A  46       7.480  10.590  13.572  1.00 19.48           C  
ATOM    259  CG  TRP A  46       6.445  10.750  14.552  1.00 20.11           C  
ATOM    260  CD1 TRP A  46       5.136  10.345  14.459  1.00 23.78           C  
ATOM    261  CD2 TRP A  46       6.591  11.369  15.825  1.00 24.72           C  
ATOM    262  NE1 TRP A  46       4.458  10.683  15.626  1.00 25.02           N  
ATOM    263  CE2 TRP A  46       5.325  11.338  16.459  1.00 27.71           C  
ATOM    264  CE3 TRP A  46       7.668  11.964  16.476  1.00 28.08           C  
ATOM    265  CZ2 TRP A  46       5.107  11.899  17.736  1.00 29.61           C  
ATOM    266  CZ3 TRP A  46       7.468  12.500  17.748  1.00 29.46           C  
ATOM    267  CH2 TRP A  46       6.195  12.460  18.362  1.00 28.15           C  
ATOM    268  N   SER A  47       9.412  12.566  11.855  1.00 14.99           N  
ATOM    269  CA  SER A  47      10.819  12.516  11.427  1.00 15.95           C  
ATOM    270  C   SER A  47      11.521  11.369  12.112  1.00 15.47           C  
ATOM    271  O   SER A  47      11.260  11.063  13.293  1.00 16.75           O  
ATOM    272  CB  SER A  47      11.522  13.800  11.821  1.00 15.05           C  
ATOM    273  OG  SER A  47      10.978  14.926  11.077  1.00 15.61           O  
ATOM    274  N   ALA A  48      12.506  10.780  11.425  1.00 15.76           N  
ATOM    275  CA  ALA A  48      13.258   9.654  11.995  1.00 16.18           C  
ATOM    276  C   ALA A  48      14.704   9.662  11.507  1.00 17.83           C  
ATOM    277  O   ALA A  48      14.998  10.185  10.416  1.00 19.07           O  
ATOM    278  CB  ALA A  48      12.595   8.299  11.627  1.00 17.34           C  
ATOM    279  N   ARG A  49      15.592   9.143  12.346  0.50 17.62           N  
ATOM    281  CA  ARG A  49      17.010   8.979  12.013  0.50 17.55           C  
ATOM    283  C   ARG A  49      17.401   7.568  12.447  0.50 18.06           C  
ATOM    285  O   ARG A  49      16.799   6.997  13.357  0.50 17.38           O  
ATOM    287  CB  ARG A  49      17.871   9.974  12.809  0.50 17.85           C  
ATOM    289  CG  ARG A  49      17.754  11.446  12.363  0.50 20.40           C  
ATOM    291  CD  ARG A  49      17.578  11.668  10.856  0.50 20.01           C  
ATOM    293  NE  ARG A  49      17.290  13.086  10.551  0.50 24.97           N  
ATOM    295  CZ  ARG A  49      16.125  13.574  10.116  0.50 22.97           C  
ATOM    297  NH1 ARG A  49      15.066  12.809   9.873  0.50 17.22           N  
ATOM    299  NH2 ARG A  49      16.021  14.874   9.889  0.50 25.24           N  
ATOM    301  N   SER A  50      18.426   7.014  11.804  0.50 17.49           N  
ATOM    303  CA  SER A  50      18.904   5.690  12.214  0.50 19.13           C  
ATOM    305  C   SER A  50      19.697   5.803  13.502  0.50 18.33           C  
ATOM    307  O   SER A  50      20.357   6.818  13.752  0.50 18.99           O  
ATOM    309  CB  SER A  50      19.760   5.108  11.102  0.50 18.95           C  
ATOM    311  OG  SER A  50      18.909   4.827  10.020  0.50 22.25           O  
HETATM  313  N   MSE A  51      19.587   4.773  14.347  1.00 17.62           N  
HETATM  314  CA  MSE A  51      20.421   4.704  15.539  1.00 17.87           C  
HETATM  315  C   MSE A  51      21.929   4.640  15.172  1.00 18.94           C  
HETATM  316  O   MSE A  51      22.770   5.226  15.853  1.00 18.97           O  
HETATM  317  CB  MSE A  51      20.025   3.442  16.344  1.00 17.69           C  
HETATM  318  CG  MSE A  51      20.852   3.312  17.610  1.00 16.43           C  
HETATM  319 SE   MSE A  51      20.576   1.541  18.336  0.65 22.26          SE  
HETATM  320  CE  MSE A  51      21.811   0.678  17.128  1.00 21.08           C  
ATOM    321  N   ASP A  52      22.230   3.922  14.087  1.00 20.07           N  
ATOM    322  CA  ASP A  52      23.608   3.848  13.542  1.00 20.97           C  
ATOM    323  C   ASP A  52      23.555   4.541  12.182  1.00 21.62           C  
ATOM    324  O   ASP A  52      22.887   4.046  11.253  1.00 19.80           O  
ATOM    325  CB  ASP A  52      24.021   2.392  13.417  1.00 21.48           C  
ATOM    326  CG  ASP A  52      25.473   2.240  12.895  1.00 24.28           C  
ATOM    327  OD1 ASP A  52      25.951   3.104  12.115  1.00 25.28           O  
ATOM    328  OD2 ASP A  52      26.119   1.241  13.265  1.00 26.25           O  
ATOM    329  N   PRO A  53      24.223   5.690  12.052  1.00 21.68           N  
ATOM    330  CA  PRO A  53      24.081   6.464  10.808  1.00 23.38           C  
ATOM    331  C   PRO A  53      24.656   5.776   9.557  1.00 23.76           C  
ATOM    332  O   PRO A  53      24.491   6.311   8.453  1.00 26.34           O  
ATOM    333  CB  PRO A  53      24.892   7.742  11.094  1.00 23.83           C  
ATOM    334  CG  PRO A  53      25.949   7.286  12.086  1.00 25.65           C  
ATOM    335  CD  PRO A  53      25.130   6.373  13.006  1.00 23.66           C  
ATOM    336  N   THR A  54      25.342   4.646   9.693  1.00 20.07           N  
ATOM    337  CA  THR A  54      25.765   3.937   8.467  1.00 20.56           C  
ATOM    338  C   THR A  54      24.658   3.029   7.909  1.00 20.17           C  
ATOM    339  O   THR A  54      24.824   2.427   6.825  1.00 18.63           O  
ATOM    340  CB  THR A  54      27.042   3.133   8.679  1.00 21.27           C  
ATOM    341  OG1 THR A  54      26.782   2.070   9.606  1.00 24.73           O  
ATOM    342  CG2 THR A  54      28.124   4.013   9.294  1.00 23.44           C  
ATOM    343  N   HIS A  55      23.560   2.853   8.649  1.00 18.19           N  
ATOM    344  CA  HIS A  55      22.566   1.874   8.229  1.00 20.02           C  
ATOM    345  C   HIS A  55      21.332   2.580   7.701  1.00 21.79           C  
ATOM    346  O   HIS A  55      20.765   3.381   8.423  1.00 26.18           O  
ATOM    347  CB  HIS A  55      22.195   0.966   9.424  1.00 20.12           C  
ATOM    348  CG  HIS A  55      21.267  -0.154   9.082  1.00 20.85           C  
ATOM    349  ND1 HIS A  55      21.681  -1.453   9.030  1.00 20.21           N  
ATOM    350  CD2 HIS A  55      19.942  -0.183   8.782  1.00 19.47           C  
ATOM    351  CE1 HIS A  55      20.696  -2.254   8.690  0.50 14.05           C  
ATOM    352  NE2 HIS A  55      19.623  -1.507   8.517  1.00 19.37           N  
ATOM    353  N   THR A  56      20.893   2.268   6.487  1.00 20.59           N  
ATOM    354  CA  THR A  56      19.687   2.895   5.956  1.00 20.51           C  
ATOM    355  C   THR A  56      18.546   1.861   6.010  1.00 21.43           C  
ATOM    356  O   THR A  56      18.746   0.658   5.706  1.00 21.79           O  
ATOM    357  CB  THR A  56      19.935   3.318   4.481  1.00 23.58           C  
ATOM    358  OG1 THR A  56      20.936   4.346   4.463  1.00 25.05           O  
ATOM    359  CG2 THR A  56      18.680   3.882   3.846  1.00 25.57           C  
ATOM    360  N   PHE A  57      17.366   2.334   6.400  1.00 19.51           N  
ATOM    361  CA  PHE A  57      16.136   1.548   6.378  1.00 18.47           C  
ATOM    362  C   PHE A  57      15.315   2.044   5.204  1.00 19.66           C  
ATOM    363  O   PHE A  57      14.920   3.230   5.147  1.00 20.56           O  
ATOM    364  CB  PHE A  57      15.366   1.727   7.718  1.00 18.56           C  
ATOM    365  CG  PHE A  57      16.093   1.157   8.880  1.00 19.25           C  
ATOM    366  CD1 PHE A  57      16.048  -0.208   9.128  1.00 19.04           C  
ATOM    367  CD2 PHE A  57      16.812   1.989   9.737  1.00 18.36           C  
ATOM    368  CE1 PHE A  57      16.731  -0.765  10.225  1.00 23.31           C  
ATOM    369  CE2 PHE A  57      17.515   1.472  10.832  1.00 20.45           C  
ATOM    370  CZ  PHE A  57      17.457   0.096  11.080  1.00 20.25           C  
ATOM    371  N   ALA A  58      15.015   1.159   4.265  1.00 18.68           N  
ATOM    372  CA  ALA A  58      14.332   1.635   3.072  1.00 20.90           C  
ATOM    373  C   ALA A  58      12.803   1.760   3.292  1.00 20.74           C  
ATOM    374  O   ALA A  58      12.243   1.113   4.184  1.00 20.00           O  
ATOM    375  CB  ALA A  58      14.603   0.639   1.924  1.00 20.89           C  
ATOM    376  N   GLU A  59      12.151   2.589   2.469  0.50 20.73           N  
ATOM    378  CA  GLU A  59      10.697   2.710   2.444  0.50 20.83           C  
ATOM    380  C   GLU A  59      10.040   1.326   2.458  0.50 21.02           C  
ATOM    382  O   GLU A  59      10.412   0.443   1.659  0.50 20.96           O  
ATOM    384  CB  GLU A  59      10.239   3.462   1.183  0.50 21.06           C  
ATOM    386  CG  GLU A  59       8.733   3.693   1.131  0.50 20.81           C  
ATOM    388  CD  GLU A  59       8.215   4.107  -0.239  0.50 22.49           C  
ATOM    390  OE1 GLU A  59       9.000   4.199  -1.207  0.50 26.47           O  
ATOM    392  OE2 GLU A  59       7.000   4.329  -0.345  0.50 24.99           O  
ATOM    394  N   GLY A  60       9.054   1.174   3.344  1.00 21.02           N  
ATOM    395  CA  GLY A  60       8.298  -0.066   3.515  1.00 20.52           C  
ATOM    396  C   GLY A  60       8.834  -0.907   4.640  1.00 20.48           C  
ATOM    397  O   GLY A  60       8.110  -1.804   5.142  1.00 21.58           O  
ATOM    398  N   GLU A  61      10.071  -0.659   5.075  1.00 19.47           N  
ATOM    399  CA  GLU A  61      10.594  -1.476   6.194  1.00 21.63           C  
ATOM    400  C   GLU A  61       9.896  -1.137   7.505  1.00 20.70           C  
ATOM    401  O   GLU A  61       9.462   0.010   7.701  1.00 19.91           O  
ATOM    402  CB  GLU A  61      12.130  -1.357   6.364  1.00 21.72           C  
ATOM    403  CG  GLU A  61      12.905  -1.964   5.151  1.00 26.09           C  
ATOM    404  CD  GLU A  61      14.443  -1.860   5.305  1.00 28.50           C  
ATOM    405  OE1 GLU A  61      14.944  -1.975   6.448  1.00 34.05           O  
ATOM    406  OE2 GLU A  61      15.172  -1.679   4.292  1.00 35.42           O  
ATOM    407  N   ILE A  62       9.787  -2.147   8.379  1.00 18.57           N  
ATOM    408  CA  ILE A  62       9.299  -1.902   9.748  1.00 17.96           C  
ATOM    409  C   ILE A  62      10.496  -1.776  10.690  1.00 17.78           C  
ATOM    410  O   ILE A  62      11.414  -2.622  10.652  1.00 19.58           O  
ATOM    411  CB  ILE A  62       8.384  -3.075  10.249  1.00 18.38           C  
ATOM    412  CG1 ILE A  62       7.265  -3.381   9.235  1.00 19.96           C  
ATOM    413  CG2 ILE A  62       7.842  -2.694  11.655  1.00 19.11           C  
ATOM    414  CD1 ILE A  62       6.482  -2.139   8.782  1.00 20.28           C  
ATOM    415  N   VAL A  63      10.518  -0.691  11.484  1.00 17.18           N  
ATOM    416  CA  VAL A  63      11.582  -0.456  12.461  1.00 17.19           C  
ATOM    417  C   VAL A  63      10.990  -0.323  13.868  1.00 17.95           C  
ATOM    418  O   VAL A  63       9.746  -0.246  14.021  1.00 18.15           O  
ATOM    419  CB  VAL A  63      12.321   0.856  12.085  1.00 18.02           C  
ATOM    420  CG1 VAL A  63      12.989   0.629  10.714  1.00 16.93           C  
ATOM    421  CG2 VAL A  63      11.299   2.044  11.966  1.00 20.03           C  
ATOM    422  N   SER A  64      11.858  -0.314  14.875  1.00 17.46           N  
ATOM    423  CA  SER A  64      11.470  -0.114  16.263  1.00 18.04           C  
ATOM    424  C   SER A  64      12.022   1.245  16.696  1.00 18.62           C  
ATOM    425  O   SER A  64      13.207   1.577  16.429  1.00 19.99           O  
ATOM    426  CB  SER A  64      12.053  -1.226  17.175  1.00 21.02           C  
ATOM    427  OG  SER A  64      11.159  -2.359  17.121  1.00 22.82           O  
ATOM    428  N   VAL A  65      11.172   2.023  17.351  1.00 17.20           N  
ATOM    429  CA  VAL A  65      11.624   3.315  17.935  1.00 17.42           C  
ATOM    430  C   VAL A  65      12.349   3.016  19.239  1.00 17.30           C  
ATOM    431  O   VAL A  65      11.769   2.430  20.161  1.00 18.04           O  
ATOM    432  CB  VAL A  65      10.436   4.285  18.191  1.00 19.38           C  
ATOM    433  CG1 VAL A  65      10.949   5.587  18.809  1.00 18.78           C  
ATOM    434  CG2 VAL A  65       9.671   4.565  16.857  1.00 19.50           C  
ATOM    435  N   ILE A  66      13.637   3.342  19.292  1.00 16.86           N  
ATOM    436  CA  ILE A  66      14.413   3.052  20.510  1.00 15.35           C  
ATOM    437  C   ILE A  66      14.819   4.268  21.339  1.00 16.94           C  
ATOM    438  O   ILE A  66      15.391   4.166  22.395  1.00 17.19           O  
ATOM    439  CB  ILE A  66      15.632   2.059  20.188  1.00 18.46           C  
ATOM    440  CG1 ILE A  66      16.520   2.613  19.070  1.00 17.95           C  
ATOM    441  CG2 ILE A  66      15.094   0.703  19.777  1.00 20.47           C  
ATOM    442  CD1 ILE A  66      17.226   3.881  19.449  1.00 19.71           C  
ATOM    443  N   ASP A  67      14.514   5.428  20.801  1.00 16.34           N  
ATOM    444  CA  ASP A  67      14.771   6.701  21.498  1.00 16.85           C  
ATOM    445  C   ASP A  67      14.002   7.795  20.789  1.00 18.54           C  
ATOM    446  O   ASP A  67      13.577   7.641  19.669  1.00 17.99           O  
ATOM    447  CB  ASP A  67      16.270   6.987  21.504  1.00 16.62           C  
ATOM    448  CG  ASP A  67      16.641   8.100  22.509  1.00 23.29           C  
ATOM    449  OD1 ASP A  67      15.793   8.532  23.352  1.00 24.37           O  
ATOM    450  OD2 ASP A  67      17.781   8.579  22.340  1.00 26.95           O  
ATOM    451  N   ILE A  68      13.779   8.904  21.481  1.00 19.87           N  
ATOM    452  CA  ILE A  68      13.164  10.083  20.851  1.00 21.57           C  
ATOM    453  C   ILE A  68      14.076  11.225  21.264  1.00 22.94           C  
ATOM    454  O   ILE A  68      14.387  11.385  22.473  1.00 23.43           O  
ATOM    455  CB  ILE A  68      11.768  10.356  21.388  1.00 22.46           C  
ATOM    456  CG1 ILE A  68      10.740   9.287  20.993  1.00 25.87           C  
ATOM    457  CG2 ILE A  68      11.272  11.766  20.897  1.00 24.92           C  
ATOM    458  CD1 ILE A  68      10.059   9.408  19.638  1.00 29.27           C  
ATOM    459  N   GLN A  69      14.499  12.030  20.290  0.50 20.83           N  
ATOM    461  CA  GLN A  69      15.302  13.212  20.592  0.50 21.87           C  
ATOM    463  C   GLN A  69      14.527  14.444  20.107  0.50 20.61           C  
ATOM    465  O   GLN A  69      14.449  14.679  18.907  0.50 19.16           O  
ATOM    467  CB  GLN A  69      16.657  13.113  19.898  0.50 21.70           C  
ATOM    469  CG  GLN A  69      17.485  11.862  20.271  0.50 23.47           C  
ATOM    471  CD  GLN A  69      18.786  11.738  19.471  0.50 25.53           C  
ATOM    473  OE1 GLN A  69      19.043  12.504  18.531  0.50 29.90           O  
ATOM    475  NE2 GLN A  69      19.624  10.756  19.850  0.50 30.22           N  
ATOM    477  N   GLY A  70      13.945  15.210  21.032  1.00 19.37           N  
ATOM    478  CA  GLY A  70      12.990  16.322  20.655  1.00 19.07           C  
ATOM    479  C   GLY A  70      11.745  15.682  20.052  1.00 20.01           C  
ATOM    480  O   GLY A  70      10.965  15.030  20.760  1.00 20.51           O  
ATOM    481  N   THR A  71      11.550  15.825  18.743  1.00 16.73           N  
ATOM    482  CA  THR A  71      10.425  15.235  18.055  1.00 17.21           C  
ATOM    483  C   THR A  71      10.920  14.303  16.936  1.00 17.55           C  
ATOM    484  O   THR A  71      10.204  14.087  15.932  1.00 19.25           O  
ATOM    485  CB  THR A  71       9.469  16.260  17.483  1.00 17.52           C  
ATOM    486  OG1 THR A  71      10.193  17.308  16.800  1.00 15.90           O  
ATOM    487  CG2 THR A  71       8.631  16.895  18.607  1.00 18.82           C  
ATOM    488  N   THR A  72      12.140  13.796  17.107  1.00 17.13           N  
ATOM    489  CA  THR A  72      12.714  12.893  16.103  1.00 17.37           C  
ATOM    490  C   THR A  72      12.795  11.495  16.681  1.00 18.12           C  
ATOM    491  O   THR A  72      13.386  11.310  17.754  1.00 18.45           O  
ATOM    492  CB  THR A  72      14.167  13.331  15.760  1.00 18.39           C  
ATOM    493  OG1 THR A  72      14.105  14.671  15.264  1.00 19.22           O  
ATOM    494  CG2 THR A  72      14.773  12.447  14.685  1.00 20.40           C  
ATOM    495  N   ALA A  73      12.202  10.556  15.982  1.00 16.99           N  
ATOM    496  CA  ALA A  73      12.291   9.187  16.396  1.00 18.12           C  
ATOM    497  C   ALA A  73      13.660   8.617  15.967  1.00 20.05           C  
ATOM    498  O   ALA A  73      14.078   8.759  14.800  1.00 20.38           O  
ATOM    499  CB  ALA A  73      11.163   8.395  15.718  1.00 18.45           C  
ATOM    500  N   ILE A  74      14.338   7.956  16.896  1.00 17.11           N  
ATOM    501  CA  ILE A  74      15.573   7.273  16.553  1.00 16.65           C  
ATOM    502  C   ILE A  74      15.225   5.784  16.494  1.00 17.23           C  
ATOM    503  O   ILE A  74      14.687   5.185  17.461  1.00 17.44           O  
ATOM    504  CB  ILE A  74      16.681   7.474  17.642  1.00 16.67           C  
ATOM    505  CG1 ILE A  74      16.879   8.952  18.029  1.00 17.88           C  
ATOM    506  CG2 ILE A  74      18.052   6.918  17.206  1.00 18.45           C  
ATOM    507  CD1 ILE A  74      17.065   9.834  16.804  1.00 19.32           C  
ATOM    508  N   VAL A  75      15.515   5.218  15.346  1.00 17.14           N  
ATOM    509  CA  VAL A  75      15.014   3.848  15.034  1.00 16.75           C  
ATOM    510  C   VAL A  75      16.076   2.822  14.785  1.00 18.01           C  
ATOM    511  O   VAL A  75      17.224   3.132  14.352  1.00 17.17           O  
ATOM    512  CB  VAL A  75      14.038   3.889  13.839  1.00 16.90           C  
ATOM    513  CG1 VAL A  75      12.870   4.917  14.133  1.00 18.51           C  
ATOM    514  CG2 VAL A  75      14.733   4.248  12.539  1.00 18.45           C  
ATOM    515  N   TRP A  76      15.694   1.575  15.038  1.00 16.57           N  
ATOM    516  CA  TRP A  76      16.597   0.458  14.758  1.00 16.96           C  
ATOM    517  C   TRP A  76      15.790  -0.742  14.271  1.00 17.77           C  
ATOM    518  O   TRP A  76      14.587  -0.647  13.973  1.00 18.67           O  
ATOM    519  CB  TRP A  76      17.464   0.135  15.969  1.00 18.43           C  
ATOM    520  CG  TRP A  76      18.675  -0.742  15.659  1.00 19.90           C  
ATOM    521  CD1 TRP A  76      19.034  -1.915  16.271  1.00 22.13           C  
ATOM    522  CD2 TRP A  76      19.672  -0.485  14.647  1.00 17.81           C  
ATOM    523  NE1 TRP A  76      20.202  -2.434  15.680  1.00 20.88           N  
ATOM    524  CE2 TRP A  76      20.609  -1.570  14.692  1.00 21.12           C  
ATOM    525  CE3 TRP A  76      19.865   0.548  13.718  1.00 19.32           C  
ATOM    526  CZ2 TRP A  76      21.727  -1.643  13.818  1.00 20.92           C  
ATOM    527  CZ3 TRP A  76      20.979   0.446  12.833  1.00 20.87           C  
ATOM    528  CH2 TRP A  76      21.883  -0.617  12.925  1.00 20.95           C  
ATOM    529  N   LYS A  77      16.475  -1.865  14.128  1.00 19.30           N  
ATOM    530  CA  LYS A  77      15.876  -3.092  13.636  1.00 18.36           C  
ATOM    531  C   LYS A  77      14.672  -3.447  14.506  1.00 20.74           C  
ATOM    532  O   LYS A  77      14.701  -3.281  15.737  1.00 20.47           O  
ATOM    533  CB  LYS A  77      16.952  -4.179  13.713  1.00 18.84           C  
ATOM    534  CG  LYS A  77      18.051  -3.933  12.627  1.00 18.96           C  
ATOM    535  CD  LYS A  77      19.155  -4.969  12.789  1.00 22.93           C  
ATOM    536  CE  LYS A  77      20.291  -4.747  11.745  1.00 21.42           C  
ATOM    537  NZ  LYS A  77      21.204  -5.944  11.794  1.00 26.67           N  
ATOM    538  N   GLU A  78      13.650  -3.993  13.853  1.00 21.30           N  
ATOM    539  CA  GLU A  78      12.450  -4.355  14.565  1.00 23.99           C  
ATOM    540  C   GLU A  78      12.757  -5.407  15.625  1.00 26.91           C  
ATOM    541  O   GLU A  78      13.470  -6.403  15.380  1.00 25.69           O  
ATOM    542  CB  GLU A  78      11.401  -4.874  13.571  1.00 24.36           C  
ATOM    543  CG  GLU A  78      10.085  -4.992  14.202  1.00 23.01           C  
ATOM    544  CD  GLU A  78       9.041  -5.761  13.402  1.00 22.71           C  
ATOM    545  OE1 GLU A  78       9.302  -6.234  12.240  1.00 24.00           O  
ATOM    546  OE2 GLU A  78       7.936  -5.930  13.965  1.00 24.59           O  
ATOM    547  N   ALA A  79      12.251  -5.154  16.836  1.00 31.43           N  
ATOM    548  CA  ALA A  79      12.177  -6.132  17.947  1.00 35.01           C  
ATOM    549  C   ALA A  79      12.716  -5.479  19.181  1.00 37.34           C  
ATOM    550  O   ALA A  79      12.132  -4.486  19.604  1.00 40.97           O  
ATOM    551  CB  ALA A  79      12.895  -7.472  17.665  1.00 37.05           C  
TER     552      ALA A  79                                                      
END
MOLECULE T0409.pdb
ATOM     14  N   TYR     1     -12.138  -6.437  34.342  1.00 26.71           N  
ATOM     15  CA  TYR     1     -10.769  -6.327  34.864  1.00 25.90           C  
ATOM     16  C   TYR     1     -10.498  -7.542  35.724  1.00 24.98           C  
ATOM     17  O   TYR     1     -11.355  -7.916  36.501  1.00 26.34           O  
ATOM     18  CB  TYR     1     -10.618  -5.047  35.686  1.00 24.63           C  
ATOM     19  CG  TYR     1      -9.168  -4.728  36.029  1.00 22.28           C  
ATOM     20  CD1 TYR     1      -8.285  -4.357  35.005  1.00 22.31           C  
ATOM     21  CD2 TYR     1      -8.664  -4.878  37.313  1.00 23.91           C  
ATOM     22  CE1 TYR     1      -6.951  -4.068  35.280  1.00 18.52           C  
ATOM     23  CE2 TYR     1      -7.324  -4.598  37.613  1.00 21.53           C  
ATOM     24  CZ  TYR     1      -6.480  -4.192  36.581  1.00 19.19           C  
ATOM     25  OH  TYR     1      -5.185  -3.925  36.888  1.00 18.14           O  
ATOM     26  N   ARG     2      -9.329  -8.164  35.541  1.00 24.27           N  
ATOM     27  CA  ARG     2      -8.922  -9.381  36.228  1.00 24.78           C  
ATOM     28  C   ARG     2      -7.920  -9.194  37.353  1.00 24.52           C  
ATOM     29  O   ARG     2      -7.621 -10.122  38.085  1.00 27.44           O  
ATOM     30  CB  ARG     2      -8.346 -10.374  35.215  1.00 23.92           C  
ATOM     31  CG  ARG     2      -9.347 -10.845  34.134  1.00 25.70           C  
ATOM     32  CD  ARG     2      -8.657 -11.765  33.135  1.00 25.52           C  
ATOM     33  NE  ARG     2      -7.696 -11.068  32.290  1.00 27.24           N  
ATOM     34  CZ  ARG     2      -8.028 -10.316  31.245  1.00 25.99           C  
ATOM     35  NH1 ARG     2      -7.092  -9.705  30.558  1.00 26.10           N  
ATOM     36  NH2 ARG     2      -9.305 -10.178  30.888  1.00 30.15           N  
ATOM     37  N   GLY     3      -7.404  -7.992  37.483  1.00 23.54           N  
ATOM     38  CA  GLY     3      -6.475  -7.700  38.540  1.00 21.96           C  
ATOM     39  C   GLY     3      -5.048  -7.714  38.006  1.00 20.01           C  
ATOM     40  O   GLY     3      -4.763  -8.208  36.927  1.00 19.98           O  
ATOM     41  N   PRO     4      -4.121  -7.183  38.794  1.00 18.75           N  
ATOM     42  CA  PRO     4      -2.718  -7.124  38.362  1.00 17.90           C  
ATOM     43  C   PRO     4      -2.069  -8.474  38.133  1.00 17.43           C  
ATOM     44  O   PRO     4      -2.332  -9.438  38.886  1.00 17.86           O  
ATOM     45  CB  PRO     4      -1.998  -6.462  39.555  1.00 17.83           C  
ATOM     46  CG  PRO     4      -3.078  -5.804  40.295  1.00 17.56           C  
ATOM     47  CD  PRO     4      -4.293  -6.604  40.137  1.00 20.04           C  
ATOM     48  N   GLU     5      -1.198  -8.523  37.136  1.00 16.41           N  
ATOM     49  CA  GLU     5      -0.494  -9.734  36.776  1.00 16.74           C  
ATOM     50  C   GLU     5       0.555 -10.210  37.794  1.00 15.28           C  
ATOM     51  O   GLU     5       0.894 -11.399  37.821  1.00 14.56           O  
ATOM     52  CB  GLU     5       0.179  -9.574  35.415  1.00 18.28           C  
ATOM     53  CG  GLU     5       1.357  -8.668  35.384  1.00 18.86           C  
ATOM     54  CD  GLU     5       1.641  -8.109  33.976  1.00 21.65           C  
ATOM     55  OE1 GLU     5       0.838  -7.287  33.462  1.00 19.17           O  
ATOM     56  OE2 GLU     5       2.690  -8.452  33.404  1.00 20.12           O  
ATOM     57  N   ALA     6       1.090  -9.262  38.551  1.00 14.75           N  
ATOM     58  CA  ALA     6       2.230  -9.503  39.408  1.00 12.91           C  
ATOM     59  C   ALA     6       2.286  -8.383  40.423  1.00 13.86           C  
ATOM     60  O   ALA     6       1.662  -7.340  40.252  1.00 14.07           O  
ATOM     61  CB  ALA     6       3.557  -9.555  38.607  1.00 14.41           C  
ATOM     62  N   PHE     7       3.056  -8.616  41.463  1.00 12.90           N  
ATOM     63  CA  PHE     7       3.312  -7.619  42.514  1.00 12.74           C  
ATOM     64  C   PHE     7       4.803  -7.561  42.789  1.00 14.31           C  
ATOM     65  O   PHE     7       5.426  -8.577  43.064  1.00 16.10           O  
ATOM     66  CB  PHE     7       2.558  -7.975  43.774  1.00 12.84           C  
ATOM     67  CG  PHE     7       1.061  -7.980  43.588  1.00 13.25           C  
ATOM     68  CD1 PHE     7       0.432  -9.083  43.089  1.00 12.42           C  
ATOM     69  CD2 PHE     7       0.284  -6.851  43.907  1.00 13.57           C  
ATOM     70  CE1 PHE     7      -0.949  -9.101  42.892  1.00 15.56           C  
ATOM     71  CE2 PHE     7      -1.084  -6.875  43.732  1.00 14.79           C  
ATOM     72  CZ  PHE     7      -1.682  -7.984  43.198  1.00 14.93           C  
ATOM     73  N   LEU     8       5.379  -6.378  42.730  1.00 13.78           N  
ATOM     74  CA  LEU     8       6.799  -6.166  43.031  1.00 14.87           C  
ATOM     75  C   LEU     8       6.959  -5.587  44.431  1.00 17.18           C  
ATOM     76  O   LEU     8       6.012  -5.033  45.021  1.00 18.46           O  
ATOM     77  CB  LEU     8       7.409  -5.253  41.997  1.00 14.89           C  
ATOM     78  CG  LEU     8       7.096  -5.514  40.532  1.00 15.32           C  
ATOM     79  CD1 LEU     8       7.647  -4.518  39.513  1.00 16.20           C  
ATOM     80  CD2 LEU     8       7.592  -6.945  40.214  1.00 16.59           C  
ATOM     81  N   LYS     9       8.127  -5.818  45.005  1.00 17.65           N  
ATOM     82  CA  LYS     9       8.421  -5.348  46.361  1.00 19.07           C  
ATOM     83  C   LYS     9       9.052  -3.955  46.263  1.00 17.92           C  
ATOM     84  O   LYS     9      10.150  -3.798  45.727  1.00 18.25           O  
ATOM     85  CB  LYS     9       9.373  -6.314  47.042  1.00 19.67           C  
ATOM     86  CG  LYS     9       9.591  -5.980  48.493  1.00 23.14           C  
ATOM     87  CD  LYS     9      10.639  -6.886  49.072  1.00 24.83           C  
ATOM     88  CE  LYS     9      10.121  -8.265  49.428  1.00 32.25           C  
ATOM     89  NZ  LYS     9      10.917  -8.817  50.575  1.00 34.79           N  
ATOM     90  N   LEU    10       8.369  -2.926  46.749  1.00 18.72           N  
ATOM     91  CA  LEU    10       8.826  -1.580  46.551  1.00 18.81           C  
ATOM     92  C   LEU    10       9.942  -1.228  47.554  1.00 19.68           C  
ATOM     93  O   LEU    10      10.009  -1.815  48.647  1.00 20.89           O  
ATOM     94  CB  LEU    10       7.717  -0.560  46.770  1.00 20.05           C  
ATOM     95  CG  LEU    10       6.533  -0.547  45.822  1.00 19.19           C  
ATOM     96  CD1 LEU    10       5.473   0.394  46.436  1.00 24.82           C  
ATOM     97  CD2 LEU    10       6.945  -0.115  44.440  1.00 21.53           C  
ATOM     98  N   PRO    11      10.774  -0.268  47.163  1.00 20.13           N  
ATOM     99  CA  PRO    11      11.661   0.375  48.167  1.00 21.78           C  
ATOM    100  C   PRO    11      10.838   1.323  49.071  1.00 22.52           C  
ATOM    101  O   PRO    11       9.740   1.732  48.679  1.00 23.44           O  
ATOM    102  CB  PRO    11      12.607   1.193  47.285  1.00 20.85           C  
ATOM    103  CG  PRO    11      11.779   1.545  46.072  1.00 22.93           C  
ATOM    104  CD  PRO    11      10.970   0.307  45.828  1.00 19.70           C  
ATOM    105  N   LYS    12      11.406   1.739  50.229  1.00 25.61           N  
ATOM    106  CA  LYS    12      10.808   2.820  51.069  1.00 26.86           C  
ATOM    107  C   LYS    12      10.655   4.134  50.323  1.00 28.24           C  
ATOM    108  O   LYS    12       9.621   4.815  50.414  1.00 30.07           O  
ATOM    109  CB  LYS    12      11.725   3.141  52.244  1.00 27.78           C  
ATOM    110  CG  LYS    12      11.297   2.660  53.597  1.00 29.19           C  
ATOM    111  CD  LYS    12      12.113   3.300  54.688  1.00 28.24           C  
ATOM    112  CE  LYS    12      11.543   4.613  55.215  1.00 28.46           C  
ATOM    113  NZ  LYS    12      12.177   4.939  56.553  1.00 29.49           N  
ATOM    114  N   ASP    13      11.716   4.525  49.615  1.00 29.01           N  
ATOM    115  CA  ASP    13      11.746   5.788  48.876  1.00 29.32           C  
ATOM    116  C   ASP    13      11.132   5.663  47.484  1.00 30.39           C  
ATOM    117  O   ASP    13      11.712   5.127  46.535  1.00 29.19           O  
ATOM    118  CB  ASP    13      13.189   6.371  48.893  1.00 29.16           C  
ATOM    119  CG  ASP    13      13.347   7.664  48.082  1.00 30.92           C  
ATOM    120  OD1 ASP    13      12.344   8.274  47.628  1.00 34.61           O  
ATOM    121  OD2 ASP    13      14.529   8.080  47.888  1.00 32.69           O  
ATOM    122  N   LEU    14       9.920   6.195  47.363  1.00 30.90           N  
ATOM    123  CA  LEU    14       9.172   6.157  46.124  1.00 30.71           C  
ATOM    124  C   LEU    14       9.608   7.149  45.049  1.00 30.84           C  
ATOM    125  O   LEU    14       9.020   7.178  43.964  1.00 31.55           O  
ATOM    126  CB  LEU    14       7.678   6.329  46.424  1.00 30.89           C  
ATOM    127  CG  LEU    14       7.124   5.332  47.440  1.00 30.54           C  
ATOM    128  CD1 LEU    14       5.711   5.725  47.765  1.00 33.63           C  
ATOM    129  CD2 LEU    14       7.169   3.889  46.924  1.00 35.44           C  
ATOM    130  N   LYS    15      10.614   7.983  45.348  1.00 30.72           N  
ATOM    131  CA  LYS    15      11.255   8.810  44.324  1.00 30.73           C  
ATOM    132  C   LYS    15      12.623   8.265  43.901  1.00 29.76           C  
ATOM    133  O   LYS    15      13.272   8.865  43.053  1.00 30.87           O  
ATOM    134  CB  LYS    15      11.408  10.266  44.806  1.00 32.76           C  
ATOM    135  CG  LYS    15      10.232  11.196  44.418  1.00 35.47           C  
ATOM    136  CD  LYS    15       9.079  11.039  45.367  1.00 37.91           C  
ATOM    137  CE  LYS    15       9.288  11.906  46.603  1.00 39.30           C  
ATOM    138  NZ  LYS    15       8.302  11.581  47.681  1.00 39.71           N  
ATOM    139  N   ASP    16      13.046   7.133  44.481  1.00 27.99           N  
ATOM    140  CA  ASP    16      14.328   6.493  44.094  1.00 26.78           C  
ATOM    141  C   ASP    16      14.118   5.763  42.782  1.00 25.11           C  
ATOM    142  O   ASP    16      13.741   4.600  42.764  1.00 24.88           O  
ATOM    143  CB  ASP    16      14.802   5.533  45.171  1.00 25.55           C  
ATOM    144  CG  ASP    16      16.217   4.970  44.893  1.00 26.06           C  
ATOM    145  OD1 ASP    16      16.650   5.014  43.729  1.00 25.61           O  
ATOM    146  OD2 ASP    16      16.861   4.472  45.830  1.00 25.02           O  
ATOM    147  N   ARG    17      14.360   6.449  41.680  1.00 25.11           N  
ATOM    148  CA  ARG    17      14.118   5.904  40.359  1.00 24.25           C  
ATOM    149  C   ARG    17      14.973   4.689  40.041  1.00 23.79           C  
ATOM    150  O   ARG    17      14.497   3.729  39.431  1.00 22.80           O  
ATOM    151  CB  ARG    17      14.276   6.978  39.293  1.00 26.64           C  
ATOM    152  CG  ARG    17      13.323   8.136  39.528  1.00 30.06           C  
ATOM    153  CD  ARG    17      12.985   8.820  38.245  1.00 37.41           C  
ATOM    154  NE  ARG    17      14.129   9.542  37.706  1.00 40.97           N  
ATOM    155  CZ  ARG    17      14.150  10.097  36.499  1.00 43.91           C  
ATOM    156  NH1 ARG    17      13.094   9.997  35.685  1.00 45.45           N  
ATOM    157  NH2 ARG    17      15.241  10.749  36.096  1.00 45.78           N  
ATOM    158  N   GLU    18      16.227   4.705  40.494  1.00 22.85           N  
ATOM    159  CA  GLU    18      17.123   3.549  40.277  1.00 22.70           C  
ATOM    160  C   GLU    18      16.572   2.269  40.913  1.00 20.63           C  
ATOM    161  O   GLU    18      16.555   1.211  40.278  1.00 19.78           O  
ATOM    162  CB  GLU    18      18.500   3.848  40.866  1.00 23.30           C  
ATOM    163  CG  GLU    18      19.549   2.754  40.681  1.00 24.01           C  
ATOM    164  CD  GLU    18      20.941   3.182  41.148  1.00 26.13           C  
ATOM    165  OE1 GLU    18      21.200   3.135  42.381  1.00 31.97           O  
ATOM    166  OE2 GLU    18      21.761   3.558  40.278  1.00 30.80           O  
ATOM    167  N   ALA    19      16.146   2.364  42.159  1.00 18.69           N  
ATOM    168  CA  ALA    19      15.569   1.237  42.865  1.00 18.72           C  
ATOM    169  C   ALA    19      14.286   0.741  42.184  1.00 18.42           C  
ATOM    170  O   ALA    19      14.079  -0.477  42.073  1.00 18.40           O  
ATOM    171  CB  ALA    19      15.248   1.627  44.285  1.00 19.53           C  
ATOM    172  N   LEU    20      13.438   1.683  41.764  1.00 18.86           N  
ATOM    173  CA  LEU    20      12.198   1.346  41.088  1.00 18.10           C  
ATOM    174  C   LEU    20      12.479   0.694  39.747  1.00 18.59           C  
ATOM    175  O   LEU    20      11.826  -0.289  39.383  1.00 18.02           O  
ATOM    176  CB  LEU    20      11.269   2.570  40.902  1.00 19.62           C  
ATOM    177  CG  LEU    20      10.779   3.123  42.243  1.00 19.47           C  
ATOM    178  CD1 LEU    20      10.171   4.490  42.063  1.00 25.48           C  
ATOM    179  CD2 LEU    20       9.776   2.141  42.919  1.00 20.59           C  
ATOM    180  N   GLN    21      13.439   1.212  38.971  1.00 17.08           N  
ATOM    181  CA  GLN    21      13.818   0.563  37.701  0.60 17.52           C  
ATOM    183  C   GLN    21      14.339  -0.838  37.961  1.00 17.89           C  
ATOM    184  O   GLN    21      14.076  -1.788  37.220  1.00 17.69           O  
ATOM    185  CB  GLN    21      14.943   1.338  36.986  0.60 18.21           C  
ATOM    187  CG  GLN    21      14.503   2.626  36.329  0.60 18.89           C  
ATOM    189  CD  GLN    21      13.515   2.472  35.158  0.60 20.48           C  
ATOM    191  OE1 GLN    21      13.254   1.364  34.619  0.60 23.97           O  
ATOM    193  NE2 GLN    21      12.980   3.610  34.738  0.60 22.78           N  
ATOM    195  N   ASP    22      15.104  -0.995  39.034  1.00 16.55           N  
ATOM    196  CA  ASP    22      15.680  -2.315  39.349  1.00 17.02           C  
ATOM    197  C   ASP    22      14.611  -3.356  39.634  1.00 16.63           C  
ATOM    198  O   ASP    22      14.714  -4.505  39.156  1.00 16.75           O  
ATOM    199  CB  ASP    22      16.632  -2.228  40.544  1.00 17.24           C  
ATOM    200  CG  ASP    22      18.015  -1.694  40.162  1.00 19.16           C  
ATOM    201  OD1 ASP    22      18.327  -1.439  38.960  1.00 22.10           O  
ATOM    202  OD2 ASP    22      18.789  -1.547  41.118  1.00 23.09           O  
ATOM    203  N   ILE    23      13.551  -2.982  40.363  1.00 15.22           N  
ATOM    204  CA  ILE    23      12.501  -4.017  40.667  1.00 15.44           C  
ATOM    205  C   ILE    23      11.696  -4.359  39.393  1.00 15.80           C  
ATOM    206  O   ILE    23      11.130  -5.448  39.328  1.00 16.91           O  
ATOM    207  CB  ILE    23      11.538  -3.666  41.812  1.00 14.93           C  
ATOM    208  CG1 ILE    23      10.715  -2.400  41.496  1.00 16.08           C  
ATOM    209  CG2 ILE    23      12.349  -3.420  43.109  1.00 16.92           C  
ATOM    210  CD1 ILE    23       9.662  -2.083  42.539  1.00 18.45           C  
ATOM    211  N   MET    24      11.693  -3.454  38.407  1.00 16.35           N  
ATOM    212  CA  MET    24      11.001  -3.635  37.136  1.00 16.51           C  
ATOM    213  C   MET    24      11.870  -4.256  36.047  1.00 16.28           C  
ATOM    214  O   MET    24      11.426  -4.374  34.907  1.00 16.01           O  
ATOM    215  CB  MET    24      10.471  -2.276  36.650  1.00 16.46           C  
ATOM    216  CG  MET    24       9.476  -1.622  37.540  1.00 17.64           C  
ATOM    217  SD  MET    24       8.685  -0.053  36.632  0.80 26.05          SE  
ATOM    218  CE  MET    24       7.421  -0.860  35.445  1.00 24.41           C  
ATOM    219  N   GLN    25      13.092  -4.631  36.388  1.00 16.67           N  
ATOM    220  CA  GLN    25      14.070  -4.998  35.365  1.00 17.43           C  
ATOM    221  C   GLN    25      13.592  -6.036  34.353  1.00 16.67           C  
ATOM    222  O   GLN    25      14.004  -5.969  33.198  1.00 17.33           O  
ATOM    223  CB  GLN    25      15.374  -5.433  36.005  1.00 18.09           C  
ATOM    224  CG  GLN    25      15.329  -6.698  36.777  1.00 20.57           C  
ATOM    225  CD  GLN    25      16.656  -7.030  37.461  1.00 24.40           C  
ATOM    226  OE1 GLN    25      17.683  -6.382  37.193  1.00 30.15           O  
ATOM    227  NE2 GLN    25      16.631  -8.020  38.370  1.00 29.33           N  
ATOM    228  N   ASP    26      12.790  -7.013  34.797  1.00 15.34           N  
ATOM    229  CA  ASP    26      12.390  -8.124  33.918  1.00 15.72           C  
ATOM    230  C   ASP    26      11.142  -7.834  33.073  1.00 16.03           C  
ATOM    231  O   ASP    26      10.876  -8.602  32.131  1.00 16.34           O  
ATOM    232  CB  ASP    26      12.120  -9.391  34.723  1.00 15.05           C  
ATOM    233  CG  ASP    26      13.409 -10.027  35.326  1.00 18.38           C  
ATOM    234  OD1 ASP    26      14.527  -9.715  34.833  1.00 21.09           O  
ATOM    235  OD2 ASP    26      13.261 -10.859  36.262  1.00 21.86           O  
ATOM    236  N   ILE    27      10.434  -6.762  33.392  1.00 16.05           N  
ATOM    237  CA  ILE    27       9.093  -6.467  32.882  0.60 17.18           C  
ATOM    239  C   ILE    27       9.116  -5.228  31.989  1.00 17.24           C  
ATOM    240  O   ILE    27       9.908  -4.318  32.214  1.00 16.86           O  
ATOM    241  CB  ILE    27       8.122  -6.210  34.080  0.60 17.87           C  
ATOM    243  CG1 ILE    27       8.158  -7.384  35.052  0.60 18.38           C  
ATOM    245  CG2 ILE    27       6.684  -5.914  33.601  0.60 18.73           C  
ATOM    247  CD1 ILE    27       7.986  -8.690  34.409  0.60 20.09           C  
ATOM    249  N   GLY    28       8.241  -5.184  31.003  1.00 17.82           N  
ATOM    250  CA  GLY    28       8.066  -3.945  30.257  1.00 18.09           C  
ATOM    251  C   GLY    28       9.221  -3.577  29.353  1.00 18.07           C  
ATOM    252  O   GLY    28       9.365  -2.424  28.950  1.00 18.91           O  
ATOM    253  N   ASN    29      10.036  -4.547  28.983  1.00 18.26           N  
ATOM    254  CA  ASN    29      11.290  -4.211  28.309  1.00 18.83           C  
ATOM    255  C   ASN    29      11.112  -3.765  26.859  1.00 19.92           C  
ATOM    256  O   ASN    29      12.054  -3.163  26.287  1.00 23.13           O  
ATOM    257  CB  ASN    29      12.315  -5.308  28.491  1.00 19.12           C  
ATOM    258  CG  ASN    29      12.920  -5.252  29.901  1.00 18.82           C  
ATOM    259  OD1 ASN    29      13.210  -4.141  30.417  1.00 20.59           O  
ATOM    260  ND2 ASN    29      13.068  -6.410  30.534  1.00 20.14           N  
ATOM    261  N   SER    30       9.940  -3.996  26.289  1.00 19.51           N  
ATOM    262  CA  SER    30       9.638  -3.436  24.946  1.00 19.62           C  
ATOM    263  C   SER    30       8.833  -2.162  25.064  1.00 19.59           C  
ATOM    264  O   SER    30       8.467  -1.576  24.052  1.00 20.08           O  
ATOM    265  CB  SER    30       8.915  -4.467  24.077  1.00 20.71           C  
ATOM    266  OG  SER    30       7.714  -4.851  24.696  1.00 25.23           O  
ATOM    267  N   ASP    31       8.554  -1.688  26.286  1.00 19.24           N  
ATOM    268  CA  ASP    31       7.719  -0.480  26.428  1.00 19.48           C  
ATOM    269  C   ASP    31       8.399   0.728  25.751  1.00 19.11           C  
ATOM    270  O   ASP    31       9.607   0.921  25.855  1.00 18.28           O  
ATOM    271  CB  ASP    31       7.472  -0.170  27.903  1.00 19.32           C  
ATOM    272  CG  ASP    31       6.382  -1.059  28.540  1.00 20.97           C  
ATOM    273  OD1 ASP    31       5.838  -1.957  27.861  1.00 20.12           O  
ATOM    274  OD2 ASP    31       6.130  -0.786  29.749  1.00 20.60           O  
ATOM    275  N   ASP    32       7.573   1.496  25.059  1.00 19.06           N  
ATOM    276  CA  ASP    32       7.966   2.731  24.373  1.00 20.14           C  
ATOM    277  C   ASP    32       8.776   2.490  23.102  1.00 19.79           C  
ATOM    278  O   ASP    32       9.198   3.461  22.447  1.00 19.91           O  
ATOM    279  CB  ASP    32       8.712   3.674  25.293  1.00 20.73           C  
ATOM    280  CG  ASP    32       7.963   3.948  26.635  1.00 23.39           C  
ATOM    281  OD1 ASP    32       6.803   4.403  26.542  1.00 25.24           O  
ATOM    282  OD2 ASP    32       8.564   3.719  27.723  1.00 25.94           O  
ATOM    283  N   ILE    33       8.996   1.235  22.770  1.00 19.89           N  
ATOM    284  CA  ILE    33       9.673   0.832  21.522  1.00 20.20           C  
ATOM    285  C   ILE    33       8.565   0.449  20.573  1.00 20.72           C  
ATOM    286  O   ILE    33       7.960  -0.632  20.700  1.00 22.37           O  
ATOM    287  CB  ILE    33      10.677  -0.334  21.711  1.00 19.45           C  
ATOM    288  CG1 ILE    33      11.758   0.114  22.689  1.00 21.44           C  
ATOM    289  CG2 ILE    33      11.304  -0.710  20.329  1.00 20.56           C  
ATOM    290  CD1 ILE    33      12.772  -0.956  23.051  1.00 22.94           C  
ATOM    291  N   LEU    34       8.299   1.342  19.626  1.00 19.25           N  
ATOM    292  CA  LEU    34       7.087   1.314  18.818  1.00 17.77           C  
ATOM    293  C   LEU    34       7.338   0.882  17.390  1.00 18.40           C  
ATOM    294  O   LEU    34       8.388   1.119  16.839  1.00 18.47           O  
ATOM    295  CB  LEU    34       6.469   2.701  18.781  1.00 18.47           C  
ATOM    296  CG  LEU    34       6.267   3.371  20.125  1.00 19.72           C  
ATOM    297  CD1 LEU    34       5.545   4.684  19.944  1.00 22.67           C  
ATOM    298  CD2 LEU    34       5.548   2.434  21.132  1.00 21.13           C  
ATOM    299  N   ALA    35       6.348   0.240  16.797  1.00 18.57           N  
ATOM    300  CA  ALA    35       6.435  -0.175  15.394  1.00 17.19           C  
ATOM    301  C   ALA    35       6.217   1.030  14.494  1.00 17.33           C  
ATOM    302  O   ALA    35       5.387   1.913  14.741  1.00 18.24           O  
ATOM    303  CB  ALA    35       5.390  -1.293  15.057  1.00 19.13           C  
ATOM    304  N   ALA    36       6.928   1.044  13.360  1.00 17.01           N  
ATOM    305  CA  ALA    36       6.674   2.049  12.357  1.00 15.71           C  
ATOM    306  C   ALA    36       7.034   1.462  10.990  1.00 16.78           C  
ATOM    307  O   ALA    36       7.901   0.604  10.879  1.00 18.10           O  
ATOM    308  CB  ALA    36       7.457   3.343  12.596  1.00 17.58           C  
ATOM    309  N   VAL    37       6.370   1.955   9.975  1.00 15.62           N  
ATOM    310  CA  VAL    37       6.682   1.549   8.602  0.50 15.71           C  
ATOM    312  C   VAL    37       7.312   2.714   7.873  1.00 14.23           C  
ATOM    313  O   VAL    37       6.779   3.823   7.872  1.00 15.68           O  
ATOM    314  CB  VAL    37       5.451   1.037   7.797  0.50 15.29           C  
ATOM    316  CG1 VAL    37       4.346   2.086   7.714  0.50 16.13           C  
ATOM    318  CG2 VAL    37       5.858   0.619   6.389  0.50 16.06           C  
ATOM    320  N   VAL    38       8.435   2.456   7.238  1.00 14.86           N  
ATOM    321  CA  VAL    38       9.172   3.493   6.517  1.00 14.41           C  
ATOM    322  C   VAL    38       8.438   3.924   5.239  1.00 15.45           C  
ATOM    323  O   VAL    38       7.986   3.077   4.449  1.00 14.72           O  
ATOM    324  CB  VAL    38      10.630   3.065   6.225  1.00 15.18           C  
ATOM    325  CG1 VAL    38      11.345   4.116   5.259  1.00 14.75           C  
ATOM    326  CG2 VAL    38      11.387   2.893   7.574  1.00 15.41           C  
ATOM    327  N   LEU    39       8.293   5.236   5.093  1.00 14.89           N  
ATOM    328  CA  LEU    39       7.728   5.844   3.883  1.00 15.30           C  
ATOM    329  C   LEU    39       8.802   6.367   2.923  1.00 16.16           C  
ATOM    330  O   LEU    39       8.618   6.337   1.717  1.00 17.32           O  
ATOM    331  CB  LEU    39       6.793   7.008   4.266  1.00 16.91           C  
ATOM    332  CG  LEU    39       5.696   6.599   5.252  1.00 17.60           C  
ATOM    333  CD1 LEU    39       4.796   7.809   5.545  1.00 21.11           C  
ATOM    334  CD2 LEU    39       4.876   5.379   4.818  1.00 20.56           C  
ATOM    335  N   SER    40       9.878   6.946   3.451  1.00 16.45           N  
ATOM    336  CA  SER    40      10.967   7.414   2.684  1.00 16.91           C  
ATOM    337  C   SER    40      12.241   7.291   3.490  1.00 16.85           C  
ATOM    338  O   SER    40      12.195   7.364   4.707  1.00 15.68           O  
ATOM    339  CB  SER    40      10.726   8.848   2.271  1.00 18.60           C  
ATOM    340  OG  SER    40      10.878   9.725   3.348  1.00 19.69           O  
ATOM    341  N   ALA    41      13.376   7.151   2.802  1.00 16.13           N  
ATOM    342  CA  ALA    41      14.666   7.013   3.492  1.00 16.24           C  
ATOM    343  C   ALA    41      15.808   7.516   2.678  1.00 17.06           C  
ATOM    344  O   ALA    41      15.937   7.212   1.489  1.00 17.44           O  
ATOM    345  CB  ALA    41      14.932   5.590   3.873  1.00 16.02           C  
ATOM    346  N   THR    42      16.603   8.346   3.317  1.00 17.62           N  
ATOM    347  CA  THR    42      17.909   8.824   2.826  1.00 18.26           C  
ATOM    348  C   THR    42      18.903   8.767   3.996  1.00 18.56           C  
ATOM    349  O   THR    42      18.496   8.630   5.155  1.00 16.63           O  
ATOM    350  CB  THR    42      17.820  10.268   2.317  1.00 18.38           C  
ATOM    351  OG1 THR    42      17.681  11.157   3.433  1.00 21.26           O  
ATOM    352  CG2 THR    42      16.634  10.457   1.330  1.00 21.04           C  
ATOM    353  N   PRO    43      20.207   8.983   3.741  1.00 18.87           N  
ATOM    354  CA  PRO    43      21.125   9.006   4.879  1.00 18.55           C  
ATOM    355  C   PRO    43      20.851  10.148   5.880  1.00 18.56           C  
ATOM    356  O   PRO    43      21.326  10.095   7.044  1.00 20.67           O  
ATOM    357  CB  PRO    43      22.499   9.197   4.201  1.00 19.88           C  
ATOM    358  CG  PRO    43      22.329   8.653   2.885  1.00 19.28           C  
ATOM    359  CD  PRO    43      20.938   9.070   2.467  1.00 20.45           C  
ATOM    360  N   GLY    44      20.139  11.170   5.431  1.00 16.96           N  
ATOM    361  CA  GLY    44      19.835  12.346   6.269  1.00 17.33           C  
ATOM    362  C   GLY    44      18.471  12.343   6.932  1.00 16.12           C  
ATOM    363  O   GLY    44      18.259  13.110   7.843  1.00 16.70           O  
ATOM    364  N   ALA    45      17.521  11.522   6.465  1.00 15.44           N  
ATOM    365  CA  ALA    45      16.194  11.546   7.049  1.00 16.18           C  
ATOM    366  C   ALA    45      15.409  10.293   6.680  1.00 16.57           C  
ATOM    367  O   ALA    45      15.433   9.862   5.536  1.00 16.49           O  
ATOM    368  CB  ALA    45      15.445  12.726   6.525  1.00 16.54           C  
ATOM    369  N   VAL    46      14.702   9.747   7.648  1.00 16.15           N  
ATOM    370  CA  VAL    46      13.752   8.676   7.432  1.00 15.46           C  
ATOM    371  C   VAL    46      12.395   9.193   7.901  1.00 16.21           C  
ATOM    372  O   VAL    46      12.272   9.685   9.044  1.00 15.82           O  
ATOM    373  CB  VAL    46      14.173   7.440   8.255  1.00 14.79           C  
ATOM    374  CG1 VAL    46      13.059   6.405   8.283  1.00 16.16           C  
ATOM    375  CG2 VAL    46      15.520   6.906   7.736  1.00 15.90           C  
ATOM    376  N   GLU    47      11.375   9.063   7.045  1.00 16.26           N  
ATOM    377  CA  GLU    47       9.987   9.338   7.431  1.00 17.37           C  
ATOM    378  C   GLU    47       9.318   7.985   7.648  1.00 17.25           C  
ATOM    379  O   GLU    47       9.447   7.094   6.805  1.00 16.35           O  
ATOM    380  CB  GLU    47       9.240  10.078   6.308  1.00 18.76           C  
ATOM    381  CG  GLU    47       9.768  11.459   6.058  1.00 22.56           C  
ATOM    382  CD  GLU    47       8.728  12.493   5.613  1.00 27.08           C  
ATOM    383  OE1 GLU    47       7.596  12.140   5.191  1.00 32.70           O  
ATOM    384  OE2 GLU    47       9.093  13.699   5.695  1.00 39.15           O  
ATOM    385  N   ALA    48       8.608   7.831   8.751  1.00 15.79           N  
ATOM    386  CA  ALA    48       7.954   6.581   9.088  1.00 16.62           C  
ATOM    387  C   ALA    48       6.568   6.823   9.690  1.00 16.84           C  
ATOM    388  O   ALA    48       6.358   7.839  10.370  1.00 19.46           O  
ATOM    389  CB  ALA    48       8.843   5.735  10.026  1.00 17.11           C  
ATOM    390  N   PHE    49       5.635   5.922   9.429  1.00 16.37           N  
ATOM    391  CA  PHE    49       4.267   5.991   9.929  1.00 17.59           C  
ATOM    392  C   PHE    49       4.122   5.056  11.129  1.00 18.32           C  
ATOM    393  O   PHE    49       4.501   3.899  11.058  1.00 17.79           O  
ATOM    394  CB  PHE    49       3.296   5.544   8.820  1.00 17.85           C  
ATOM    395  CG  PHE    49       1.842   5.641   9.191  1.00 18.30           C  
ATOM    396  CD1 PHE    49       1.144   6.802   8.933  1.00 21.76           C  
ATOM    397  CD2 PHE    49       1.164   4.553   9.695  1.00 20.75           C  
ATOM    398  CE1 PHE    49      -0.227   6.916   9.249  1.00 20.36           C  
ATOM    399  CE2 PHE    49      -0.206   4.656  10.047  1.00 19.72           C  
ATOM    400  CZ  PHE    49      -0.881   5.839   9.796  1.00 22.60           C  
ATOM    401  N   ARG    50       3.636   5.563  12.253  1.00 19.08           N  
ATOM    402  CA  ARG    50       3.464   4.703  13.441  1.00 20.23           C  
ATOM    403  C   ARG    50       1.972   4.382  13.686  1.00 21.07           C  
ATOM    404  O   ARG    50       1.117   4.995  13.106  1.00 20.64           O  
ATOM    405  CB  ARG    50       4.134   5.305  14.688  1.00 22.94           C  
ATOM    406  CG  ARG    50       3.763   6.662  15.046  1.00 23.31           C  
ATOM    407  CD  ARG    50       4.729   7.128  16.134  1.00 22.13           C  
ATOM    408  NE  ARG    50       4.369   8.344  16.762  1.00 24.32           N  
ATOM    409  CZ  ARG    50       3.791   8.440  17.969  1.00 23.15           C  
ATOM    410  NH1 ARG    50       3.443   7.362  18.655  1.00 26.13           N  
ATOM    411  NH2 ARG    50       3.534   9.622  18.479  1.00 24.48           N  
ATOM    412  N   LYS    51       1.701   3.437  14.570  1.00 21.95           N  
ATOM    413  CA  LYS    51       0.329   2.957  14.793  1.00 22.96           C  
ATOM    414  C   LYS    51      -0.644   4.022  15.207  1.00 23.88           C  
ATOM    415  O   LYS    51      -1.836   3.907  14.899  1.00 27.15           O  
ATOM    416  CB  LYS    51       0.344   1.884  15.880  1.00 24.30           C  
ATOM    417  CG  LYS    51       0.928   0.570  15.440  1.00 26.87           C  
ATOM    418  CD  LYS    51      -0.058  -0.226  14.582  1.00 29.44           C  
ATOM    419  CE  LYS    51      -1.205  -0.890  15.358  1.00 30.13           C  
ATOM    420  NZ  LYS    51      -1.944  -1.954  14.526  1.00 28.19           N  
ATOM    421  N   ASN    52      -0.193   5.045  15.923  1.00 23.72           N  
ATOM    422  CA  ASN    52      -1.125   6.100  16.359  1.00 24.26           C  
ATOM    423  C   ASN    52      -1.538   7.030  15.207  1.00 24.17           C  
ATOM    424  O   ASN    52      -2.323   7.978  15.409  1.00 25.42           O  
ATOM    425  CB  ASN    52      -0.554   6.871  17.558  1.00 25.03           C  
ATOM    426  CG  ASN    52       0.317   8.020  17.160  1.00 24.42           C  
ATOM    427  OD1 ASN    52       0.962   7.983  16.114  1.00 25.79           O  
ATOM    428  ND2 ASN    52       0.299   9.079  17.951  1.00 26.65           N  
ATOM    429  N   GLY    53      -1.017   6.768  14.005  1.00 23.35           N  
ATOM    430  CA  GLY    53      -1.366   7.494  12.812  1.00 23.25           C  
ATOM    431  C   GLY    53      -0.460   8.670  12.473  1.00 22.61           C  
ATOM    432  O   GLY    53      -0.703   9.373  11.499  1.00 24.10           O  
ATOM    433  N   GLU    54       0.538   8.935  13.311  1.00 22.55           N  
ATOM    434  CA  GLU    54       1.405  10.054  13.034  0.50 22.38           C  
ATOM    436  C   GLU    54       2.587   9.612  12.165  1.00 21.93           C  
ATOM    437  O   GLU    54       3.020   8.453  12.207  1.00 20.56           O  
ATOM    438  CB  GLU    54       1.816  10.735  14.347  0.50 22.86           C  
ATOM    440  CG  GLU    54       0.597  11.429  14.982  0.50 23.21           C  
ATOM    442  CD  GLU    54       0.817  12.068  16.340  0.50 25.13           C  
ATOM    444  OE1 GLU    54       1.708  11.658  17.107  0.50 26.68           O  
ATOM    446  OE2 GLU    54       0.037  12.995  16.648  0.50 28.52           O  
ATOM    448  N   THR    55       3.045  10.538  11.335  1.00 21.52           N  
ATOM    449  CA  THR    55       4.233  10.331  10.508  1.00 21.28           C  
ATOM    450  C   THR    55       5.336  11.097  11.229  1.00 21.26           C  
ATOM    451  O   THR    55       5.202  12.280  11.575  1.00 24.07           O  
ATOM    452  CB  THR    55       4.059  10.775   9.067  1.00 22.75           C  
ATOM    453  OG1 THR    55       3.020   9.997   8.430  1.00 23.47           O  
ATOM    454  CG2 THR    55       5.373  10.586   8.283  1.00 23.69           C  
ATOM    455  N   ILE    56       6.388  10.377  11.530  1.00 18.81           N  
ATOM    456  CA  ILE    56       7.560  10.946  12.221  1.00 17.71           C  
ATOM    457  C   ILE    56       8.734  11.049  11.242  1.00 16.62           C  
ATOM    458  O   ILE    56       8.769  10.351  10.240  1.00 15.72           O  
ATOM    459  CB  ILE    56       7.998  10.101  13.463  1.00 16.48           C  
ATOM    460  CG1 ILE    56       8.324   8.643  13.102  1.00 18.49           C  
ATOM    461  CG2 ILE    56       6.891  10.128  14.560  1.00 20.69           C  
ATOM    462  CD1 ILE    56       8.915   7.805  14.252  1.00 18.71           C  
ATOM    463  N   ARG    57       9.641  11.970  11.557  1.00 17.01           N  
ATOM    464  CA  ARG    57      10.857  12.170  10.790  1.00 16.90           C  
ATOM    465  C   ARG    57      12.059  11.961  11.712  1.00 18.52           C  
ATOM    466  O   ARG    57      12.203  12.700  12.712  1.00 18.30           O  
ATOM    467  CB  ARG    57      10.877  13.578  10.175  1.00 18.21           C  
ATOM    468  CG  ARG    57      11.843  13.767   9.044  1.00 22.16           C  
ATOM    469  CD  ARG    57      11.482  15.091   8.275  1.00 22.79           C  
ATOM    470  NE  ARG    57      12.260  15.266   7.076  1.00 30.28           N  
ATOM    471  CZ  ARG    57      13.426  15.885   7.007  1.00 29.98           C  
ATOM    472  NH1 ARG    57      14.012  16.421   8.094  1.00 33.28           N  
ATOM    473  NH2 ARG    57      14.032  15.957   5.829  1.00 32.68           N  
ATOM    474  N   ILE    58      12.936  11.028  11.349  1.00 15.91           N  
ATOM    475  CA  ILE    58      14.128  10.653  12.155  1.00 15.94           C  
ATOM    476  C   ILE    58      15.335  11.194  11.407  1.00 16.27           C  
ATOM    477  O   ILE    58      15.485  10.933  10.213  1.00 14.90           O  
ATOM    478  CB  ILE    58      14.242   9.140  12.377  1.00 16.25           C  
ATOM    479  CG1 ILE    58      12.926   8.623  13.001  1.00 20.10           C  
ATOM    480  CG2 ILE    58      15.455   8.775  13.294  1.00 16.57           C  
ATOM    481  CD1 ILE    58      12.483   7.265  12.468  1.00 23.93           C  
ATOM    482  N   THR    59      16.197  11.910  12.141  1.00 14.89           N  
ATOM    483  CA  THR    59      17.358  12.593  11.568  1.00 14.15           C  
ATOM    484  C   THR    59      18.504  12.573  12.586  1.00 14.35           C  
ATOM    485  O   THR    59      18.307  12.162  13.715  1.00 14.11           O  
ATOM    486  CB  THR    59      17.069  14.081  11.229  1.00 14.81           C  
ATOM    487  OG1 THR    59      16.779  14.818  12.442  1.00 13.82           O  
ATOM    488  CG2 THR    59      15.872  14.174  10.256  1.00 14.18           C  
ATOM    489  N   GLY    60      19.662  13.078  12.202  1.00 13.00           N  
ATOM    490  CA  GLY    60      20.785  13.294  13.142  1.00 14.55           C  
ATOM    491  C   GLY    60      21.076  12.078  14.032  1.00 15.23           C  
ATOM    492  O   GLY    60      21.268  10.956  13.557  1.00 15.55           O  
ATOM    493  N   ASP    61      21.107  12.333  15.323  1.00 14.66           N  
ATOM    494  CA  ASP    61      21.464  11.288  16.310  1.00 15.90           C  
ATOM    495  C   ASP    61      20.544  10.072  16.200  1.00 16.16           C  
ATOM    496  O   ASP    61      20.988   8.929  16.399  1.00 16.88           O  
ATOM    497  CB  ASP    61      21.390  11.842  17.714  1.00 16.78           C  
ATOM    498  CG  ASP    61      22.453  12.862  18.020  1.00 19.80           C  
ATOM    499  OD1 ASP    61      23.417  13.063  17.234  1.00 23.93           O  
ATOM    500  OD2 ASP    61      22.320  13.459  19.136  1.00 27.40           O  
ATOM    501  N   GLY    62      19.269  10.299  15.862  1.00 13.92           N  
ATOM    502  CA  GLY    62      18.296   9.222  15.746  1.00 15.21           C  
ATOM    503  C   GLY    62      18.607   8.184  14.692  1.00 15.36           C  
ATOM    504  O   GLY    62      18.053   7.093  14.739  1.00 16.47           O  
ATOM    505  N   LEU    63      19.447   8.530  13.705  1.00 15.12           N  
ATOM    506  CA  LEU    63      19.813   7.633  12.637  1.00 14.66           C  
ATOM    507  C   LEU    63      21.161   6.929  12.860  1.00 16.62           C  
ATOM    508  O   LEU    63      21.553   6.092  12.067  1.00 17.65           O  
ATOM    509  CB  LEU    63      19.895   8.412  11.307  1.00 14.91           C  
ATOM    510  CG  LEU    63      18.610   9.028  10.816  1.00 14.93           C  
ATOM    511  CD1 LEU    63      18.872   9.730   9.475  1.00 16.30           C  
ATOM    512  CD2 LEU    63      17.484   7.995  10.686  1.00 15.68           C  
ATOM    513  N   LYS    64      21.879   7.292  13.912  1.00 15.36           N  
ATOM    514  CA  LYS    64      23.251   6.825  14.127  0.50 17.84           C  
ATOM    516  C   LYS    64      23.350   5.313  14.202  1.00 17.93           C  
ATOM    517  O   LYS    64      24.201   4.683  13.539  1.00 18.87           O  
ATOM    518  CB  LYS    64      23.803   7.419  15.421  0.50 18.24           C  
ATOM    520  CG  LYS    64      24.118   8.919  15.346  0.50 18.90           C  
ATOM    522  CD  LYS    64      24.682   9.481  16.677  0.50 21.52           C  
ATOM    524  CE  LYS    64      26.140   9.169  16.864  0.50 25.23           C  
ATOM    526  NZ  LYS    64      26.990   9.892  15.880  0.50 27.58           N  
ATOM    528  N   ALA    65      22.489   4.723  15.032  1.00 19.45           N  
ATOM    529  CA  ALA    65      22.573   3.266  15.255  1.00 19.45           C  
ATOM    530  C   ALA    65      22.318   2.519  13.970  1.00 20.13           C  
ATOM    531  O   ALA    65      22.956   1.506  13.706  1.00 21.80           O  
ATOM    532  CB  ALA    65      21.609   2.832  16.300  1.00 20.20           C  
ATOM    533  N   ALA    66      21.444   3.053  13.127  1.00 19.24           N  
ATOM    534  CA  ALA    66      21.020   2.427  11.875  1.00 20.12           C  
ATOM    535  C   ALA    66      21.899   2.739  10.641  1.00 20.14           C  
ATOM    536  O   ALA    66      21.545   2.431   9.497  1.00 19.93           O  
ATOM    537  CB  ALA    66      19.537   2.784  11.608  1.00 19.17           C  
ATOM    538  N   HIS    67      23.032   3.414  10.876  1.00 20.96           N  
ATOM    539  CA  HIS    67      23.874   3.973   9.798  1.00 22.50           C  
ATOM    540  C   HIS    67      24.131   3.057   8.595  1.00 22.69           C  
ATOM    541  O   HIS    67      23.989   3.483   7.437  1.00 23.41           O  
ATOM    542  CB  HIS    67      25.197   4.541  10.372  1.00 23.45           C  
ATOM    543  CG  HIS    67      26.126   3.542  11.028  1.00 26.82           C  
ATOM    544  ND1 HIS    67      25.899   2.978  12.266  1.00 32.13           N  
ATOM    545  CD2 HIS    67      27.348   3.080  10.635  1.00 30.02           C  
ATOM    546  CE1 HIS    67      26.898   2.169  12.582  1.00 33.51           C  
ATOM    547  NE2 HIS    67      27.792   2.218  11.610  1.00 33.86           N  
ATOM    548  N   ARG    68      24.408   1.803   8.879  1.00 23.67           N  
ATOM    549  CA  ARG    68      24.853   0.871   7.842  1.00 25.02           C  
ATOM    550  C   ARG    68      23.705   0.512   6.938  1.00 22.30           C  
ATOM    551  O   ARG    68      23.901   0.185   5.787  1.00 22.56           O  
ATOM    552  CB  ARG    68      25.434  -0.344   8.498  1.00 24.82           C  
ATOM    553  CG  ARG    68      26.707   0.042   9.249  1.00 30.85           C  
ATOM    554  CD  ARG    68      27.251  -1.030  10.152  1.00 31.45           C  
ATOM    555  NE  ARG    68      27.030  -2.400   9.701  1.00 37.79           N  
ATOM    556  CZ  ARG    68      27.584  -2.962   8.632  1.00 38.95           C  
ATOM    557  NH1 ARG    68      28.387  -2.272   7.823  1.00 41.74           N  
ATOM    558  NH2 ARG    68      27.322  -4.240   8.369  1.00 39.77           N  
ATOM    559  N   PHE    69      22.504   0.595   7.497  1.00 19.79           N  
ATOM    560  CA  PHE    69      21.286   0.350   6.733  1.00 19.43           C  
ATOM    561  C   PHE    69      20.734   1.541   5.979  1.00 19.65           C  
ATOM    562  O   PHE    69      19.701   1.423   5.340  1.00 19.12           O  
ATOM    563  CB  PHE    69      20.253  -0.281   7.668  1.00 18.19           C  
ATOM    564  CG  PHE    69      20.676  -1.645   8.125  1.00 18.08           C  
ATOM    565  CD1 PHE    69      21.572  -1.808   9.173  1.00 20.24           C  
ATOM    566  CD2 PHE    69      20.239  -2.769   7.441  1.00 18.30           C  
ATOM    567  CE1 PHE    69      21.988  -3.089   9.532  1.00 18.89           C  
ATOM    568  CE2 PHE    69      20.661  -4.045   7.806  1.00 20.19           C  
ATOM    569  CZ  PHE    69      21.524  -4.186   8.845  1.00 19.83           C  
ATOM    570  N   LEU    70      21.457   2.669   6.005  1.00 20.27           N  
ATOM    571  CA  LEU    70      21.095   3.866   5.245  1.00 22.90           C  
ATOM    572  C   LEU    70      22.208   4.335   4.308  1.00 25.29           C  
ATOM    573  O   LEU    70      22.002   5.257   3.520  1.00 26.73           O  
ATOM    574  CB  LEU    70      20.781   5.012   6.233  1.00 23.31           C  
ATOM    575  CG  LEU    70      19.562   4.755   7.119  1.00 21.31           C  
ATOM    576  CD1 LEU    70      19.661   5.653   8.378  1.00 24.18           C  
ATOM    577  CD2 LEU    70      18.328   5.018   6.305  1.00 20.23           C  
ATOM    578  N   SER    71      23.353   3.653   4.356  1.00 26.45           N  
ATOM    579  CA  SER    71      24.587   4.095   3.688  1.00 27.55           C  
ATOM    580  C   SER    71      24.781   3.559   2.280  1.00 28.74           C  
ATOM    581  O   SER    71      25.758   3.970   1.601  1.00 29.80           O  
ATOM    582  CB  SER    71      25.772   3.565   4.472  1.00 28.48           C  
ATOM    583  OG  SER    71      25.814   2.132   4.350  1.00 29.58           O  
ATOM    584  N   ASN    72      23.919   2.637   1.840  1.00 27.09           N  
ATOM    585  CA  ASN    72      24.109   1.939   0.546  0.50 27.05           C  
ATOM    587  C   ASN    72      25.380   1.091   0.533  1.00 26.48           C  
ATOM    588  O   ASN    72      25.998   0.890  -0.495  1.00 25.99           O  
ATOM    589  CB  ASN    72      24.106   2.893  -0.675  0.50 27.83           C  
ATOM    591  CG  ASN    72      22.703   3.159  -1.234  0.50 28.59           C  
ATOM    593  OD1 ASN    72      21.791   2.300  -1.198  0.50 32.27           O  
ATOM    595  ND2 ASN    72      22.528   4.359  -1.773  0.50 29.54           N  
ATOM    597  N   ASP    73      25.749   0.542   1.686  1.00 25.43           N  
ATOM    598  CA  ASP    73      26.875  -0.421   1.798  1.00 24.74           C  
ATOM    599  C   ASP    73      26.488  -1.639   0.942  1.00 23.75           C  
ATOM    600  O   ASP    73      25.420  -2.208   1.157  1.00 20.54           O  
ATOM    601  CB  ASP    73      27.027  -0.835   3.265  1.00 25.17           C  
ATOM    602  CG  ASP    73      28.020  -1.980   3.495  1.00 26.12           C  
ATOM    603  OD1 ASP    73      28.691  -2.475   2.569  1.00 30.99           O  
ATOM    604  OD2 ASP    73      28.101  -2.401   4.667  1.00 35.81           O  
ATOM    605  N   PRO    74      27.323  -2.022  -0.030  1.00 23.57           N  
ATOM    606  CA  PRO    74      26.905  -3.122  -0.921  1.00 24.30           C  
ATOM    607  C   PRO    74      26.670  -4.459  -0.231  1.00 24.84           C  
ATOM    608  O   PRO    74      25.870  -5.256  -0.709  1.00 26.45           O  
ATOM    609  CB  PRO    74      28.062  -3.203  -1.942  1.00 23.95           C  
ATOM    610  CG  PRO    74      28.658  -1.821  -1.905  1.00 24.58           C  
ATOM    611  CD  PRO    74      28.629  -1.482  -0.450  1.00 24.00           C  
ATOM    612  N   LYS    75      27.332  -4.708   0.891  1.00 25.11           N  
ATOM    613  CA  LYS    75      27.130  -5.948   1.623  1.00 26.59           C  
ATOM    614  C   LYS    75      25.736  -6.045   2.221  1.00 25.93           C  
ATOM    615  O   LYS    75      25.200  -7.135   2.361  1.00 27.46           O  
ATOM    616  CB  LYS    75      28.133  -6.079   2.757  1.00 27.40           C  
ATOM    617  CG  LYS    75      29.571  -6.266   2.291  1.00 30.20           C  
ATOM    618  CD  LYS    75      30.541  -6.071   3.457  1.00 30.42           C  
ATOM    619  CE  LYS    75      31.984  -6.045   2.995  1.00 33.03           C  
ATOM    620  NZ  LYS    75      32.892  -6.078   4.194  1.00 35.70           N  
ATOM    621  N   ILE    76      25.166  -4.913   2.601  1.00 23.73           N  
ATOM    622  CA  ILE    76      23.809  -4.916   3.141  1.00 23.46           C  
ATOM    623  C   ILE    76      22.796  -5.053   1.994  1.00 22.14           C  
ATOM    624  O   ILE    76      21.798  -5.755   2.127  1.00 20.70           O  
ATOM    625  CB  ILE    76      23.584  -3.686   4.022  1.00 24.00           C  
ATOM    626  CG1 ILE    76      24.357  -3.908   5.328  1.00 27.47           C  
ATOM    627  CG2 ILE    76      22.078  -3.476   4.336  1.00 23.08           C  
ATOM    628  CD1 ILE    76      24.772  -2.697   5.964  1.00 30.61           C  
ATOM    629  N   GLY    77      23.054  -4.389   0.872  1.00 21.67           N  
ATOM    630  CA  GLY    77      22.162  -4.511  -0.299  1.00 23.17           C  
ATOM    631  C   GLY    77      20.722  -4.151   0.019  1.00 23.16           C  
ATOM    632  O   GLY    77      20.499  -3.202   0.757  1.00 21.68           O  
ATOM    633  N   GLU    78      19.732  -4.918  -0.484  1.00 23.84           N  
ATOM    634  CA  GLU    78      18.312  -4.590  -0.222  1.00 24.68           C  
ATOM    635  C   GLU    78      17.813  -4.974   1.181  1.00 24.33           C  
ATOM    636  O   GLU    78      16.629  -4.789   1.473  1.00 25.22           O  
ATOM    637  CB  GLU    78      17.364  -5.168  -1.302  1.00 26.64           C  
ATOM    638  CG  GLU    78      17.418  -4.480  -2.675  1.00 29.65           C  
ATOM    639  CD  GLU    78      16.578  -3.175  -2.782  1.00 33.89           C  
ATOM    640  OE1 GLU    78      15.333  -3.239  -3.075  1.00 31.41           O  
ATOM    641  OE2 GLU    78      17.177  -2.079  -2.589  1.00 40.88           O  
ATOM    642  N   LYS    79      18.700  -5.410   2.079  1.00 22.93           N  
ATOM    643  CA  LYS    79      18.361  -5.427   3.493  1.00 23.03           C  
ATOM    644  C   LYS    79      18.274  -4.017   4.070  1.00 20.63           C  
ATOM    645  O   LYS    79      17.859  -3.837   5.206  1.00 20.01           O  
ATOM    646  CB  LYS    79      19.393  -6.225   4.292  1.00 23.69           C  
ATOM    647  CG  LYS    79      19.299  -7.709   3.999  1.00 26.92           C  
ATOM    648  CD  LYS    79      20.379  -8.489   4.748  1.00 28.53           C  
ATOM    649  CE  LYS    79      20.377  -9.959   4.320  1.00 31.81           C  
ATOM    650  NZ  LYS    79      21.343 -10.239   3.217  1.00 34.09           N  
ATOM    651  N   ARG    80      18.704  -3.024   3.298  1.00 21.12           N  
ATOM    652  CA  ARG    80      18.705  -1.639   3.757  1.00 20.87           C  
ATOM    653  C   ARG    80      17.293  -1.138   4.068  1.00 19.89           C  
ATOM    654  O   ARG    80      16.315  -1.671   3.561  1.00 20.87           O  
ATOM    655  CB  ARG    80      19.366  -0.719   2.751  1.00 21.02           C  
ATOM    656  CG  ARG    80      18.562  -0.475   1.551  1.00 22.63           C  
ATOM    657  CD  ARG    80      19.314   0.371   0.508  1.00 25.39           C  
ATOM    658  NE  ARG    80      18.437   0.440  -0.642  1.00 29.73           N  
ATOM    659  CZ  ARG    80      17.483   1.357  -0.864  1.00 32.12           C  
ATOM    660  NH1 ARG    80      17.229   2.386  -0.014  1.00 34.12           N  
ATOM    661  NH2 ARG    80      16.751   1.230  -1.965  1.00 29.96           N  
ATOM    662  N   ILE    81      17.237  -0.105   4.874  1.00 18.86           N  
ATOM    663  CA  ILE    81      15.997   0.629   5.137  1.00 18.98           C  
ATOM    664  C   ILE    81      15.544   1.319   3.844  1.00 19.21           C  
ATOM    665  O   ILE    81      16.338   2.004   3.173  1.00 21.40           O  
ATOM    666  CB  ILE    81      16.197   1.625   6.256  1.00 19.16           C  
ATOM    667  CG1 ILE    81      16.408   0.857   7.574  1.00 18.53           C  
ATOM    668  CG2 ILE    81      15.006   2.601   6.364  1.00 19.73           C  
ATOM    669  CD1 ILE    81      17.055   1.628   8.701  1.00 20.65           C  
ATOM    670  N   ARG    82      14.274   1.128   3.504  1.00 18.22           N  
ATOM    671  CA  ARG    82      13.688   1.557   2.209  0.50 17.65           C  
ATOM    673  C   ARG    82      12.182   1.643   2.425  1.00 17.73           C  
ATOM    674  O   ARG    82      11.660   1.090   3.399  1.00 16.98           O  
ATOM    675  CB  ARG    82      14.008   0.561   1.075  0.50 18.23           C  
ATOM    677  CG  ARG    82      13.015  -0.649   0.888  0.50 16.80           C  
ATOM    679  CD  ARG    82      13.220  -1.403  -0.465  0.50 17.15           C  
ATOM    681  NE  ARG    82      12.162  -2.396  -0.723  0.50 17.23           N  
ATOM    683  CZ  ARG    82      12.274  -3.709  -0.531  0.50 15.45           C  
ATOM    685  NH1 ARG    82      13.430  -4.257  -0.164  0.50 15.77           N  
ATOM    687  NH2 ARG    82      11.228  -4.497  -0.780  0.50 15.69           N  
ATOM    689  N   PRO    83      11.445   2.300   1.510  1.00 17.33           N  
ATOM    690  CA  PRO    83      10.002   2.307   1.757  1.00 16.91           C  
ATOM    691  C   PRO    83       9.361   0.934   1.945  1.00 16.61           C  
ATOM    692  O   PRO    83       9.564   0.019   1.119  1.00 17.77           O  
ATOM    693  CB  PRO    83       9.439   3.036   0.539  1.00 17.58           C  
ATOM    694  CG  PRO    83      10.548   3.837   0.051  1.00 16.41           C  
ATOM    695  CD  PRO    83      11.804   3.087   0.325  1.00 17.89           C  
ATOM    696  N   GLY    84       8.588   0.809   3.007  1.00 14.86           N  
ATOM    697  CA  GLY    84       7.959  -0.434   3.420  1.00 15.67           C  
ATOM    698  C   GLY    84       8.674  -1.152   4.541  1.00 15.52           C  
ATOM    699  O   GLY    84       8.121  -2.067   5.126  1.00 17.23           O  
ATOM    700  N   ALA    85       9.898  -0.737   4.843  1.00 15.34           N  
ATOM    701  CA  ALA    85      10.636  -1.389   5.913  1.00 15.80           C  
ATOM    702  C   ALA    85       9.875  -1.233   7.211  1.00 15.88           C  
ATOM    703  O   ALA    85       9.489  -0.137   7.570  1.00 16.97           O  
ATOM    704  CB  ALA    85      12.004  -0.790   6.026  1.00 15.08           C  
ATOM    705  N   LEU    86       9.720  -2.344   7.924  1.00 18.25           N  
ATOM    706  CA  LEU    86       9.190  -2.359   9.282  1.00 17.93           C  
ATOM    707  C   LEU    86      10.353  -2.152  10.253  1.00 18.43           C  
ATOM    708  O   LEU    86      11.299  -2.955  10.332  1.00 18.46           O  
ATOM    709  CB  LEU    86       8.472  -3.697   9.575  1.00 18.48           C  
ATOM    710  CG  LEU    86       7.905  -3.859  10.985  1.00 20.15           C  
ATOM    711  CD1 LEU    86       6.882  -2.777  11.316  1.00 23.23           C  
ATOM    712  CD2 LEU    86       7.327  -5.271  11.129  1.00 20.48           C  
ATOM    713  N   ILE    87      10.281  -1.045  10.979  1.00 17.40           N  
ATOM    714  CA  ILE    87      11.304  -0.664  11.971  1.00 17.79           C  
ATOM    715  C   ILE    87      10.691  -0.466  13.315  1.00 16.97           C  
ATOM    716  O   ILE    87       9.466  -0.472  13.474  1.00 18.03           O  
ATOM    717  CB  ILE    87      12.079   0.611  11.522  1.00 16.69           C  
ATOM    718  CG1 ILE    87      11.141   1.799  11.307  1.00 17.19           C  
ATOM    719  CG2 ILE    87      12.872   0.270  10.190  1.00 18.98           C  
ATOM    720  CD1 ILE    87      11.823   3.133  11.188  1.00 18.86           C  
ATOM    721  N   ARG    88      11.546  -0.259  14.292  1.00 16.37           N  
ATOM    722  CA  ARG    88      11.104   0.101  15.626  1.00 15.89           C  
ATOM    723  C   ARG    88      11.725   1.441  15.956  1.00 16.06           C  
ATOM    724  O   ARG    88      12.890   1.704  15.645  1.00 15.92           O  
ATOM    725  CB  ARG    88      11.551  -0.950  16.656  1.00 16.91           C  
ATOM    726  CG  ARG    88      11.052  -2.363  16.313  1.00 19.48           C  
ATOM    727  CD  ARG    88       9.563  -2.596  16.597  1.00 22.43           C  
ATOM    728  NE  ARG    88       9.195  -3.877  16.014  1.00 25.15           N  
ATOM    729  CZ  ARG    88       8.005  -4.465  16.140  1.00 24.03           C  
ATOM    730  NH1 ARG    88       7.064  -3.921  16.884  1.00 22.87           N  
ATOM    731  NH2 ARG    88       7.794  -5.626  15.506  1.00 26.11           N  
ATOM    732  N   VAL    89      10.947   2.244  16.646  1.00 16.11           N  
ATOM    733  CA  VAL    89      11.362   3.602  17.021  1.00 15.28           C  
ATOM    734  C   VAL    89      11.067   3.919  18.472  1.00 16.66           C  
ATOM    735  O   VAL    89      10.122   3.363  19.062  1.00 17.18           O  
ATOM    736  CB  VAL    89      10.672   4.637  16.105  1.00 15.17           C  
ATOM    737  CG1 VAL    89      11.089   4.396  14.673  1.00 16.98           C  
ATOM    738  CG2 VAL    89       9.155   4.521  16.206  1.00 17.06           C  
ATOM    739  N   LYS    90      11.848   4.847  19.017  1.00 16.96           N  
ATOM    740  CA  LYS    90      11.616   5.305  20.380  1.00 17.78           C  
ATOM    741  C   LYS    90      11.880   6.822  20.433  1.00 18.76           C  
ATOM    742  O   LYS    90      12.876   7.285  19.874  1.00 18.51           O  
ATOM    743  CB  LYS    90      12.577   4.566  21.301  1.00 18.95           C  
ATOM    744  CG  LYS    90      12.395   4.805  22.797  1.00 19.52           C  
ATOM    745  CD  LYS    90      13.376   3.969  23.591  1.00 22.77           C  
ATOM    746  CE  LYS    90      13.408   4.296  25.059  1.00 29.12           C  
ATOM    747  NZ  LYS    90      12.162   4.691  25.679  1.00 35.66           N  
ATOM    748  N   LYS    91      11.107   7.510  21.260  1.00 18.93           N  
ATOM    749  CA  LYS    91      11.228   8.949  21.424  1.00 19.03           C  
ATOM    750  C   LYS    91      12.187   9.212  22.587  1.00 19.84           C  
ATOM    751  O   LYS    91      11.983   8.683  23.701  1.00 20.14           O  
ATOM    752  CB  LYS    91       9.854   9.552  21.671  1.00 19.81           C  
ATOM    753  CG  LYS    91       9.830  11.072  21.577  1.00 20.93           C  
ATOM    754  CD  LYS    91       8.439  11.593  21.854  1.00 23.85           C  
ATOM    755  CE  LYS    91       8.249  13.016  21.413  1.00 30.64           C  
ATOM    756  NZ  LYS    91       6.944  13.499  21.917  1.00 34.58           N  
ATOM    757  N   THR    92      13.230   9.996  22.360  1.00 19.44           N  
ATOM    758  CA  THR    92      14.153  10.312  23.424  1.00 19.60           C  
ATOM    759  C   THR    92      13.562  11.349  24.389  1.00 18.84           C  
ATOM    760  O   THR    92      12.549  11.999  24.103  1.00 18.25           O  
ATOM    761  CB  THR    92      15.444  10.856  22.895  1.00 19.73           C  
ATOM    762  OG1 THR    92      15.176  12.183  22.388  1.00 21.01           O  
ATOM    763  CG2 THR    92      16.053   9.941  21.791  1.00 19.35           C  
ATOM    764  N   GLU    93      14.205  11.539  25.548  0.50 20.13           N  
ATOM    766  CA  GLU    93      13.705  12.522  26.511  0.50 20.76           C  
ATOM    768  C   GLU    93      13.826  13.956  25.987  0.50 19.67           C  
ATOM    770  O   GLU    93      13.197  14.874  26.521  0.50 19.80           O  
ATOM    772  CB  GLU    93      14.469  12.430  27.835  0.50 21.32           C  
ATOM    774  CG  GLU    93      14.239  11.166  28.623  0.50 23.98           C  
ATOM    776  CD  GLU    93      15.125  11.081  29.854  0.50 24.53           C  
ATOM    778  OE1 GLU    93      15.518   9.957  30.231  0.50 30.98           O  
ATOM    780  OE2 GLU    93      15.430  12.143  30.451  0.50 29.16           O  
ATOM    782  N   LYS    94      14.686  14.166  25.000  1.00 19.01           N  
ATOM    783  CA  LYS    94      14.783  15.473  24.385  1.00 18.39           C  
ATOM    784  C   LYS    94      13.725  15.668  23.293  1.00 16.81           C  
ATOM    785  O   LYS    94      13.533  16.802  22.866  1.00 18.00           O  
ATOM    786  CB  LYS    94      16.183  15.730  23.832  1.00 19.18           C  
ATOM    787  CG  LYS    94      17.248  15.787  24.880  1.00 21.72           C  
ATOM    788  CD  LYS    94      18.600  15.805  24.281  1.00 23.57           C  
ATOM    789  CE  LYS    94      19.662  15.916  25.368  1.00 26.08           C  
ATOM    790  NZ  LYS    94      21.041  15.663  24.797  1.00 29.86           N  
ATOM    791  N   GLY    95      13.022  14.605  22.914  1.00 16.22           N  
ATOM    792  CA  GLY    95      11.841  14.750  22.040  1.00 16.18           C  
ATOM    793  C   GLY    95      11.987  14.255  20.618  1.00 16.84           C  
ATOM    794  O   GLY    95      11.006  14.237  19.886  1.00 17.83           O  
ATOM    795  N   SER    96      13.182  13.851  20.222  1.00 16.29           N  
ATOM    796  CA  SER    96      13.410  13.388  18.856  1.00 15.32           C  
ATOM    797  C   SER    96      13.264  11.874  18.837  1.00 16.22           C  
ATOM    798  O   SER    96      13.576  11.174  19.825  1.00 15.94           O  
ATOM    799  CB  SER    96      14.825  13.781  18.368  1.00 15.41           C  
ATOM    800  OG  SER    96      15.042  15.172  18.223  1.00 17.04           O  
ATOM    801  N   TRP    97      12.799  11.328  17.709  1.00 15.27           N  
ATOM    802  CA  TRP    97      12.673   9.906  17.534  1.00 15.15           C  
ATOM    803  C   TRP    97      13.984   9.306  17.090  1.00 15.23           C  
ATOM    804  O   TRP    97      14.751   9.940  16.370  1.00 15.34           O  
ATOM    805  CB  TRP    97      11.574   9.586  16.500  1.00 16.75           C  
ATOM    806  CG  TRP    97      10.188   9.910  17.049  1.00 17.02           C  
ATOM    807  CD1 TRP    97       9.539  11.094  16.962  1.00 19.56           C  
ATOM    808  CD2 TRP    97       9.317   9.038  17.788  1.00 17.19           C  
ATOM    809  NE1 TRP    97       8.330  11.038  17.621  1.00 18.92           N  
ATOM    810  CE2 TRP    97       8.159   9.773  18.106  1.00 19.29           C  
ATOM    811  CE3 TRP    97       9.412   7.721  18.226  1.00 18.37           C  
ATOM    812  CZ2 TRP    97       7.109   9.234  18.854  1.00 20.16           C  
ATOM    813  CZ3 TRP    97       8.337   7.178  18.931  1.00 17.75           C  
ATOM    814  CH2 TRP    97       7.222   7.945  19.254  1.00 19.63           C  
ATOM    815  N   GLN    98      14.221   8.054  17.494  1.00 15.53           N  
ATOM    816  CA  GLN    98      15.374   7.289  17.078  0.50 15.84           C  
ATOM    818  C   GLN    98      14.962   5.908  16.599  1.00 15.82           C  
ATOM    819  O   GLN    98      13.994   5.322  17.111  1.00 16.55           O  
ATOM    820  CB  GLN    98      16.352   7.171  18.259  0.50 16.46           C  
ATOM    822  CG  GLN    98      15.755   6.389  19.416  0.50 17.45           C  
ATOM    824  CD  GLN    98      16.493   6.471  20.731  0.50 18.58           C  
ATOM    826  OE1 GLN    98      15.872   6.257  21.781  0.50 19.21           O  
ATOM    828  NE2 GLN    98      17.791   6.726  20.694  0.50 20.26           N  
ATOM    830  N   ILE    99      15.703   5.374  15.626  1.00 15.21           N  
ATOM    831  CA  ILE    99      15.526   3.998  15.150  1.00 15.51           C  
ATOM    832  C   ILE    99      16.314   3.078  16.081  1.00 16.61           C  
ATOM    833  O   ILE    99      17.548   3.215  16.279  1.00 16.58           O  
ATOM    834  CB  ILE    99      15.998   3.819  13.727  1.00 16.25           C  
ATOM    835  CG1 ILE    99      15.225   4.730  12.764  1.00 16.91           C  
ATOM    836  CG2 ILE    99      15.907   2.332  13.370  1.00 18.24           C  
ATOM    837  CD1 ILE    99      15.645   4.639  11.292  1.00 16.52           C  
ATOM    838  N   VAL   100      15.562   2.173  16.680  1.00 17.39           N  
ATOM    839  CA  VAL   100      16.095   1.202  17.630  1.00 18.63           C  
ATOM    840  C   VAL   100      15.672  -0.230  17.234  1.00 19.15           C  
ATOM    841  O   VAL   100      15.194  -0.468  16.147  1.00 17.97           O  
ATOM    842  CB  VAL   100      15.581   1.541  19.043  1.00 18.73           C  
ATOM    843  CG1 VAL   100      16.085   2.916  19.465  1.00 18.33           C  
ATOM    844  CG2 VAL   100      14.053   1.456  19.153  1.00 21.54           C  
ATOM    845  N   GLN   101      15.841  -1.182  18.141  1.00 21.54           N  
ATOM    846  CA  GLN   101      15.350  -2.538  17.848  1.00 22.47           C  
ATOM    847  C   GLN   101      14.877  -3.189  19.126  1.00 23.43           C  
ATOM    848  O   GLN   101      15.243  -2.736  20.207  1.00 23.82           O  
ATOM    849  CB  GLN   101      16.395  -3.345  17.139  1.00 23.76           C  
ATOM    850  CG  GLN   101      17.643  -3.604  17.930  1.00 23.42           C  
ATOM    851  CD  GLN   101      18.756  -4.193  17.109  1.00 24.69           C  
ATOM    852  OE1 GLN   101      18.587  -4.586  15.951  1.00 25.77           O  
ATOM    853  NE2 GLN   101      19.941  -4.248  17.713  1.00 30.47           N  
ATOM    854  N   LEU   102      14.003  -4.177  19.000  1.00 25.80           N  
ATOM    855  CA  LEU   102      13.433  -4.833  20.175  1.00 29.29           C  
ATOM    856  C   LEU   102      14.548  -5.593  20.875  1.00 30.90           C  
ATOM    857  O   LEU   102      15.441  -6.127  20.212  1.00 30.78           O  
ATOM    858  CB  LEU   102      12.266  -5.755  19.791  1.00 29.31           C  
ATOM    859  CG  LEU   102      10.972  -5.020  19.413  1.00 30.58           C  
ATOM    860  CD1 LEU   102       9.988  -5.946  18.738  1.00 31.16           C  
ATOM    861  CD2 LEU   102      10.360  -4.260  20.587  1.00 31.70           C  
ATOM    862  N   PRO   103      14.502  -5.653  22.228  1.00 32.79           N  
ATOM    863  CA  PRO   103      15.587  -6.344  22.947  1.00 33.77           C  
ATOM    864  C   PRO   103      15.589  -7.835  22.604  1.00 35.69           C  
ATOM    865  O   PRO   103      14.522  -8.422  22.400  1.00 36.77           O  
ATOM    866  CB  PRO   103      15.235  -6.128  24.423  1.00 34.74           C  
ATOM    867  CG  PRO   103      13.758  -5.776  24.444  1.00 34.13           C  
ATOM    868  CD  PRO   103      13.465  -5.114  23.135  1.00 33.44           C  
ATOM    869  OXT PRO   103      16.642  -8.473  22.459  1.00 37.09           O  
END
