
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   67 (  500),  selected   67 , name 1fr3_F
# Molecule2: number of CA atoms  103 (  801),  selected  103 , name T0409.pdb
# PARAMETERS: 1fr3_F.T0409.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_F      Y       1           -
LGA    -       -      R       2           -
LGA    -       -      G       3           -
LGA    -       -      P       4           -
LGA    -       -      E       5           -
LGA    -       -      A       6           -
LGA    -       -      F       7           -
LGA    -       -      L       8           -
LGA    -       -      K       9           -
LGA    -       -      L      10           -
LGA    -       -      P      11           -
LGA    -       -      K      12           -
LGA    -       -      D      13           -
LGA    -       -      L      14           -
LGA    -       -      K      15           -
LGA    -       -      D      16           -
LGA    -       -      R      17           -
LGA    -       -      E      18           -
LGA    -       -      A      19           -
LGA    -       -      L      20           -
LGA    -       -      Q      21           -
LGA    -       -      D      22           -
LGA    -       -      I      23           -
LGA    -       -      M      24           -
LGA    -       -      Q      25           -
LGA    -       -      D      26           -
LGA    K     2_F      I      27           #
LGA    -       -      G      28           -
LGA    -       -      N      29           -
LGA    I     3_F      S      30          6.147
LGA    S     4_F      -       -           -
LGA    G     5_F      -       -           -
LGA    R     6_F      D      31          4.740
LGA    N     7_F      D      32          2.041
LGA    K     8_F      I      33          1.831
LGA    L     9_F      L      34          1.897
LGA    E    10_F      A      35          0.857
LGA    A    11_F      A      36          0.777
LGA    T    12_F      V      37          0.103
LGA    V    13_F      V      38          0.471
LGA    K    14_F      L      39          0.616
LGA    E    15_F      S      40          0.374
LGA    I    16_F      A      41          0.560
LGA    V    17_F      T      42          1.740
LGA    K    18_F      P      43          2.156
LGA    G    19_F      -       -           -
LGA    T    20_F      -       -           -
LGA    V    21_F      -       -           -
LGA    M    22_F      -       -           -
LGA    A    23_F      G      44          2.405
LGA    K    24_F      A      45          0.506
LGA    I    25_F      V      46          0.804
LGA    V    26_F      E      47          0.533
LGA    M    27_F      A      48          0.272
LGA    D    28_F      F      49          0.865
LGA    Y    29_F      R      50          1.363
LGA    K    30_F      K      51          3.158
LGA    -       -      N      52           -
LGA    G    31_F      G      53          2.877
LGA    T    32_F      E      54          1.507
LGA    E    33_F      T      55          0.685
LGA    L    34_F      I      56          0.695
LGA    V    35_F      R      57          0.680
LGA    A    36_F      I      58          0.706
LGA    A    37_F      T      59          1.175
LGA    -       -      G      60           -
LGA    -       -      D      61           -
LGA    -       -      G      62           -
LGA    I    38_F      L      63          1.161
LGA    T    39_F      K      64          3.349
LGA    I    40_F      A      65           -
LGA    D    41_F      -       -           -
LGA    S    42_F      A      66          2.074
LGA    V    43_F      H      67          3.861
LGA    A    44_F      R      68          2.081
LGA    D    45_F      F      69          4.255
LGA    L    46_F      L      70           -
LGA    -       -      S      71           -
LGA    -       -      N      72           -
LGA    -       -      D      73           -
LGA    -       -      P      74           -
LGA    -       -      K      75           -
LGA    -       -      I      76           -
LGA    -       -      G      77           -
LGA    -       -      E      78           -
LGA    D    47_F      K      79          4.052
LGA    L    48_F      R      80          3.465
LGA    V    49_F      I      81          2.521
LGA    -       -      R      82           -
LGA    P    50_F      P      83          1.357
LGA    G    51_F      G      84          0.561
LGA    D    52_F      A      85          0.809
LGA    K    53_F      L      86          0.824
LGA    V    54_F      I      87          0.957
LGA    T    55_F      R      88          0.888
LGA    A    56_F      V      89          0.838
LGA    L    57_F      K      90          1.402
LGA    V    58_F      K      91          2.185
LGA    K    59_F      T      92          3.515
LGA    A    60_F      -       -           -
LGA    T    61_F      E      93          2.801
LGA    E    62_F      K      94          2.949
LGA    M    63_F      G      95          3.913
LGA    E    64_F      S      96           -
LGA    V    65_F      W      97           -
LGA    L    66_F      Q      98           -
LGA    K    67_F      I      99           -
LGA    -       -      V     100           -
LGA    -       -      Q     101           -
LGA    -       -      L     102           -
LGA    -       -      P     103           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   67  103    5.0     51    2.26    13.73     42.900     2.160

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.012436 * X  +  -0.613445 * Y  +  -0.789640 * Z  +  40.969410
  Y_new =   0.563818 * X  +  -0.647887 * Y  +   0.512202 * Z  +   3.191833
  Z_new =  -0.825805 * X  +  -0.451583 * Y  +   0.337814 * Z  +  85.581993 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.928534    2.213058  [ DEG:   -53.2011    126.7989 ]
  Theta =   0.971628    2.169964  [ DEG:    55.6702    124.3298 ]
  Phi   =   1.548743   -1.592850  [ DEG:    88.7364    -91.2636 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1fr3_F                                        
REMARK     2: T0409.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1fr3_F.T0409.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   67  103   5.0   51   2.26   13.73  42.900
REMARK  ---------------------------------------------------------- 
MOLECULE 1fr3_F
HEADER    METAL BINDING PROTEIN                   07-SEP-00   1FR3              
TITLE     THE HIGH RESOLUTION STRUCTURE OF A MOLYBDATE BINDING                  
TITLE    2 PROTEIN FROM SPOROMUSA OVATA                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MOLYBDATE/TUNGSTATE BINDING PROTEIN;                       
COMPND   3 CHAIN: A, B, C, D, E, F, G, H, I, J, K, L;                           
COMPND   4 SYNONYM: MOP                                                         
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SPOROMUSA OVATA;                                
SOURCE   3 ORGANISM_COMMON: BACTERIA                                            
KEYWDS    MOLYBDATE, TUNGSTATE, MOLYBDATE HOMEOSTASIS                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    U.G.WAGNER,E.STUPPERICH,C.KRATKY                                      
REVDAT   1   06-DEC-00 1FR3    0                                                
JRNL        AUTH   U.G.WAGNER,E.STUPPERICH,C.KRATKY                             
JRNL        TITL   STRUCTURE OF THE MOLYBDATE/TUNGSTATE BINDING                 
JRNL        TITL 2 PROTEIN MOP FROM SPOROMUSA OVATA.                            
JRNL        REF    STRUCTURE FOLD.DES.           V.   8  1127 2000              
JRNL        REFN   ASTM FODEFH  UK ISSN 1359-0278                               
REMARK   2 RESOLUTION. 1.50 ANGSTROMS.                                          
DBREF  1FR3 A    1    67  UNP    Q7SIF7   Q7SIF7_9FIRM     1     67             
DBREF  1FR3 B    1    67  UNP    Q7SIF7   Q7SIF7_9FIRM     1     67             
DBREF  1FR3 C    1    67  UNP    Q7SIF7   Q7SIF7_9FIRM     1     67             
DBREF  1FR3 D    1    67  UNP    Q7SIF7   Q7SIF7_9FIRM     1     67             
DBREF  1FR3 E    1    67  UNP    Q7SIF7   Q7SIF7_9FIRM     1     67             
DBREF  1FR3 F    1    67  UNP    Q7SIF7   Q7SIF7_9FIRM     1     67             
DBREF  1FR3 G    1    67  UNP    Q7SIF7   Q7SIF7_9FIRM     1     67             
DBREF  1FR3 H    1    67  UNP    Q7SIF7   Q7SIF7_9FIRM     1     67             
DBREF  1FR3 I    1    67  UNP    Q7SIF7   Q7SIF7_9FIRM     1     67             
DBREF  1FR3 J    1    67  UNP    Q7SIF7   Q7SIF7_9FIRM     1     67             
DBREF  1FR3 K    1    67  UNP    Q7SIF7   Q7SIF7_9FIRM     1     67             
DBREF  1FR3 L    1    67  UNP    Q7SIF7   Q7SIF7_9FIRM     1     67             
SEQRES   1 A   67  MET LYS ILE SER GLY ARG ASN LYS LEU GLU ALA THR VAL          
SEQRES   2 A   67  LYS GLU ILE VAL LYS GLY THR VAL MET ALA LYS ILE VAL          
SEQRES   3 A   67  MET ASP TYR LYS GLY THR GLU LEU VAL ALA ALA ILE THR          
SEQRES   4 A   67  ILE ASP SER VAL ALA ASP LEU ASP LEU VAL PRO GLY ASP          
SEQRES   5 A   67  LYS VAL THR ALA LEU VAL LYS ALA THR GLU MET GLU VAL          
SEQRES   6 A   67  LEU LYS                                                      
SEQRES   1 B   67  MET LYS ILE SER GLY ARG ASN LYS LEU GLU ALA THR VAL          
SEQRES   2 B   67  LYS GLU ILE VAL LYS GLY THR VAL MET ALA LYS ILE VAL          
SEQRES   3 B   67  MET ASP TYR LYS GLY THR GLU LEU VAL ALA ALA ILE THR          
SEQRES   4 B   67  ILE ASP SER VAL ALA ASP LEU ASP LEU VAL PRO GLY ASP          
SEQRES   5 B   67  LYS VAL THR ALA LEU VAL LYS ALA THR GLU MET GLU VAL          
SEQRES   6 B   67  LEU LYS                                                      
SEQRES   1 C   67  MET LYS ILE SER GLY ARG ASN LYS LEU GLU ALA THR VAL          
SEQRES   2 C   67  LYS GLU ILE VAL LYS GLY THR VAL MET ALA LYS ILE VAL          
SEQRES   3 C   67  MET ASP TYR LYS GLY THR GLU LEU VAL ALA ALA ILE THR          
SEQRES   4 C   67  ILE ASP SER VAL ALA ASP LEU ASP LEU VAL PRO GLY ASP          
SEQRES   5 C   67  LYS VAL THR ALA LEU VAL LYS ALA THR GLU MET GLU VAL          
SEQRES   6 C   67  LEU LYS                                                      
SEQRES   1 D   67  MET LYS ILE SER GLY ARG ASN LYS LEU GLU ALA THR VAL          
SEQRES   2 D   67  LYS GLU ILE VAL LYS GLY THR VAL MET ALA LYS ILE VAL          
SEQRES   3 D   67  MET ASP TYR LYS GLY THR GLU LEU VAL ALA ALA ILE THR          
SEQRES   4 D   67  ILE ASP SER VAL ALA ASP LEU ASP LEU VAL PRO GLY ASP          
SEQRES   5 D   67  LYS VAL THR ALA LEU VAL LYS ALA THR GLU MET GLU VAL          
SEQRES   6 D   67  LEU LYS                                                      
SEQRES   1 E   67  MET LYS ILE SER GLY ARG ASN LYS LEU GLU ALA THR VAL          
SEQRES   2 E   67  LYS GLU ILE VAL LYS GLY THR VAL MET ALA LYS ILE VAL          
SEQRES   3 E   67  MET ASP TYR LYS GLY THR GLU LEU VAL ALA ALA ILE THR          
SEQRES   4 E   67  ILE ASP SER VAL ALA ASP LEU ASP LEU VAL PRO GLY ASP          
SEQRES   5 E   67  LYS VAL THR ALA LEU VAL LYS ALA THR GLU MET GLU VAL          
SEQRES   6 E   67  LEU LYS                                                      
SEQRES   1 F   67  MET LYS ILE SER GLY ARG ASN LYS LEU GLU ALA THR VAL          
SEQRES   2 F   67  LYS GLU ILE VAL LYS GLY THR VAL MET ALA LYS ILE VAL          
SEQRES   3 F   67  MET ASP TYR LYS GLY THR GLU LEU VAL ALA ALA ILE THR          
SEQRES   4 F   67  ILE ASP SER VAL ALA ASP LEU ASP LEU VAL PRO GLY ASP          
SEQRES   5 F   67  LYS VAL THR ALA LEU VAL LYS ALA THR GLU MET GLU VAL          
SEQRES   6 F   67  LEU LYS                                                      
SEQRES   1 G   67  MET LYS ILE SER GLY ARG ASN LYS LEU GLU ALA THR VAL          
SEQRES   2 G   67  LYS GLU ILE VAL LYS GLY THR VAL MET ALA LYS ILE VAL          
SEQRES   3 G   67  MET ASP TYR LYS GLY THR GLU LEU VAL ALA ALA ILE THR          
SEQRES   4 G   67  ILE ASP SER VAL ALA ASP LEU ASP LEU VAL PRO GLY ASP          
SEQRES   5 G   67  LYS VAL THR ALA LEU VAL LYS ALA THR GLU MET GLU VAL          
SEQRES   6 G   67  LEU LYS                                                      
SEQRES   1 H   67  MET LYS ILE SER GLY ARG ASN LYS LEU GLU ALA THR VAL          
SEQRES   2 H   67  LYS GLU ILE VAL LYS GLY THR VAL MET ALA LYS ILE VAL          
SEQRES   3 H   67  MET ASP TYR LYS GLY THR GLU LEU VAL ALA ALA ILE THR          
SEQRES   4 H   67  ILE ASP SER VAL ALA ASP LEU ASP LEU VAL PRO GLY ASP          
SEQRES   5 H   67  LYS VAL THR ALA LEU VAL LYS ALA THR GLU MET GLU VAL          
SEQRES   6 H   67  LEU LYS                                                      
SEQRES   1 I   67  MET LYS ILE SER GLY ARG ASN LYS LEU GLU ALA THR VAL          
SEQRES   2 I   67  LYS GLU ILE VAL LYS GLY THR VAL MET ALA LYS ILE VAL          
SEQRES   3 I   67  MET ASP TYR LYS GLY THR GLU LEU VAL ALA ALA ILE THR          
SEQRES   4 I   67  ILE ASP SER VAL ALA ASP LEU ASP LEU VAL PRO GLY ASP          
SEQRES   5 I   67  LYS VAL THR ALA LEU VAL LYS ALA THR GLU MET GLU VAL          
SEQRES   6 I   67  LEU LYS                                                      
SEQRES   1 J   67  MET LYS ILE SER GLY ARG ASN LYS LEU GLU ALA THR VAL          
SEQRES   2 J   67  LYS GLU ILE VAL LYS GLY THR VAL MET ALA LYS ILE VAL          
SEQRES   3 J   67  MET ASP TYR LYS GLY THR GLU LEU VAL ALA ALA ILE THR          
SEQRES   4 J   67  ILE ASP SER VAL ALA ASP LEU ASP LEU VAL PRO GLY ASP          
SEQRES   5 J   67  LYS VAL THR ALA LEU VAL LYS ALA THR GLU MET GLU VAL          
SEQRES   6 J   67  LEU LYS                                                      
SEQRES   1 K   67  MET LYS ILE SER GLY ARG ASN LYS LEU GLU ALA THR VAL          
SEQRES   2 K   67  LYS GLU ILE VAL LYS GLY THR VAL MET ALA LYS ILE VAL          
SEQRES   3 K   67  MET ASP TYR LYS GLY THR GLU LEU VAL ALA ALA ILE THR          
SEQRES   4 K   67  ILE ASP SER VAL ALA ASP LEU ASP LEU VAL PRO GLY ASP          
SEQRES   5 K   67  LYS VAL THR ALA LEU VAL LYS ALA THR GLU MET GLU VAL          
SEQRES   6 K   67  LEU LYS                                                      
SEQRES   1 L   67  MET LYS ILE SER GLY ARG ASN LYS LEU GLU ALA THR VAL          
SEQRES   2 L   67  LYS GLU ILE VAL LYS GLY THR VAL MET ALA LYS ILE VAL          
SEQRES   3 L   67  MET ASP TYR LYS GLY THR GLU LEU VAL ALA ALA ILE THR          
SEQRES   4 L   67  ILE ASP SER VAL ALA ASP LEU ASP LEU VAL PRO GLY ASP          
SEQRES   5 L   67  LYS VAL THR ALA LEU VAL LYS ALA THR GLU MET GLU VAL          
SEQRES   6 L   67  LEU LYS                                                      
HET    WO4    401       5                                                       
HET    WO4    402       5                                                       
HET    WO4    403       5                                                       
HET    WO4    404       5                                                       
HET    WO4    405       5                                                       
HET    WO4    406       5                                                       
HET    WO4    407       5                                                       
HET    WO4    408       5                                                       
HET    WO4    409       5                                                       
HET    WO4    410       5                                                       
HET    WO4    411       5                                                       
HET    WO4    412       5                                                       
HET    WO4    413       5                                                       
HET    WO4    414       5                                                       
HET    WO4    415       5                                                       
HET    WO4    416       5                                                       
HETNAM     WO4 TUNGSTATE(VI)ION                                                 
FORMUL  13  WO4    16(O4 W 2-)                                                  
FORMUL  29  HOH   *380(H2 O)                                                    
CRYST1  109.724  138.328  110.368  90.00  90.00  90.00 C 2 2 21     96          
ATOM   2506  N   MET F   1      16.809  -8.669  23.811  1.00 22.49           N  
ATOM   2507  CA  MET F   1      17.089  -7.883  25.038  1.00 21.50           C  
ATOM   2508  C   MET F   1      15.977  -6.861  25.297  1.00 19.64           C  
ATOM   2509  O   MET F   1      15.412  -6.317  24.344  1.00 20.80           O  
ATOM   2510  CB  MET F   1      18.407  -7.121  24.962  1.00 23.06           C  
ATOM   2511  CG  MET F   1      19.705  -7.862  24.749  1.00 24.81           C  
ATOM   2512  SD  MET F   1      21.150  -6.775  24.824  1.00 26.70           S  
ATOM   2513  CE  MET F   1      20.840  -5.679  23.444  1.00 26.13           C  
ATOM   2514  N   LYS F   2      15.682  -6.601  26.566  1.00 16.51           N  
ATOM   2515  CA  LYS F   2      14.717  -5.545  26.890  1.00 14.43           C  
ATOM   2516  C   LYS F   2      15.493  -4.227  26.815  1.00 12.67           C  
ATOM   2517  O   LYS F   2      16.704  -4.215  27.038  1.00 12.07           O  
ATOM   2518  CB  LYS F   2      14.071  -5.729  28.251  1.00 14.75           C  
ATOM   2519  CG  LYS F   2      12.948  -6.753  28.287  1.00 15.54           C  
ATOM   2520  CD  LYS F   2      12.313  -6.864  29.663  1.00 15.47           C  
ATOM   2521  CE  LYS F   2      11.060  -7.725  29.639  1.00 16.25           C  
ATOM   2522  NZ  LYS F   2      10.360  -7.713  30.957  1.00 16.93           N  
ATOM   2523  N   ILE F   3      14.811  -3.141  26.501  1.00 11.32           N  
ATOM   2524  CA  ILE F   3      15.403  -1.822  26.341  1.00 10.77           C  
ATOM   2525  C   ILE F   3      14.800  -0.829  27.323  1.00  9.04           C  
ATOM   2526  O   ILE F   3      13.573  -0.723  27.389  1.00  8.23           O  
ATOM   2527  CB  ILE F   3      15.145  -1.322  24.899  1.00 12.05           C  
ATOM   2528  CG1 ILE F   3      15.652  -2.349  23.880  1.00 13.57           C  
ATOM   2529  CG2 ILE F   3      15.790   0.039  24.680  1.00 13.31           C  
ATOM   2530  CD1 ILE F   3      14.946  -2.242  22.541  1.00 13.21           C  
ATOM   2531  N   SER F   4      15.616  -0.069  28.050  1.00  8.03           N  
ATOM   2532  CA  SER F   4      15.050   0.907  28.978  1.00  6.93           C  
ATOM   2533  C   SER F   4      14.265   1.978  28.222  1.00  6.90           C  
ATOM   2534  O   SER F   4      13.244   2.412  28.770  1.00  7.04           O  
ATOM   2535  CB  SER F   4      16.120   1.516  29.871  1.00  7.00           C  
ATOM   2536  OG  SER F   4      16.938   2.441  29.169  1.00  6.62           O  
ATOM   2537  N   GLY F   5      14.676   2.381  27.018  1.00  5.45           N  
ATOM   2538  CA  GLY F   5      13.912   3.390  26.275  1.00  6.61           C  
ATOM   2539  C   GLY F   5      12.427   3.022  26.308  1.00  5.72           C  
ATOM   2540  O   GLY F   5      12.045   2.005  25.729  1.00  6.30           O  
ATOM   2541  N   ARG F   6      11.620   3.845  26.981  1.00  5.89           N  
ATOM   2542  CA  ARG F   6      10.226   3.472  27.176  1.00  6.08           C  
ATOM   2543  C   ARG F   6       9.293   3.563  25.985  1.00  5.94           C  
ATOM   2544  O   ARG F   6       8.299   2.830  25.989  1.00  6.15           O  
ATOM   2545  CB  ARG F   6       9.615   4.290  28.328  1.00  6.03           C  
ATOM   2546  CG  ARG F   6      10.212   4.020  29.694  1.00  6.48           C  
ATOM   2547  CD  ARG F   6       9.892   2.652  30.254  1.00  7.64           C  
ATOM   2548  NE  ARG F   6      10.706   1.554  29.754  1.00  7.83           N  
ATOM   2549  CZ  ARG F   6      10.412   0.266  29.891  1.00  8.73           C  
ATOM   2550  NH1 ARG F   6       9.293  -0.120  30.493  1.00  8.57           N  
ATOM   2551  NH2 ARG F   6      11.236  -0.653  29.404  1.00  8.68           N  
ATOM   2552  N   ASN F   7       9.524   4.457  25.036  1.00  6.03           N  
ATOM   2553  CA  ASN F   7       8.584   4.626  23.934  1.00  6.33           C  
ATOM   2554  C   ASN F   7       8.935   3.798  22.711  1.00  5.84           C  
ATOM   2555  O   ASN F   7       9.966   4.041  22.076  1.00  6.20           O  
ATOM   2556  CB  ASN F   7       8.500   6.124  23.598  1.00  5.81           C  
ATOM   2557  CG  ASN F   7       8.077   6.889  24.848  1.00  6.43           C  
ATOM   2558  OD1 ASN F   7       6.899   6.818  25.207  1.00  6.56           O  
ATOM   2559  ND2 ASN F   7       9.017   7.573  25.484  1.00  6.00           N  
ATOM   2560  N   LYS F   8       8.104   2.817  22.406  1.00  5.95           N  
ATOM   2561  CA  LYS F   8       8.257   1.960  21.245  1.00  6.59           C  
ATOM   2562  C   LYS F   8       7.071   2.199  20.306  1.00  7.34           C  
ATOM   2563  O   LYS F   8       5.917   2.018  20.716  1.00  8.52           O  
ATOM   2564  CB  LYS F   8       8.296   0.470  21.590  1.00  7.51           C  
ATOM   2565  CG  LYS F   8       9.595  -0.055  22.163  1.00  8.41           C  
ATOM   2566  CD  LYS F   8       9.690   0.125  23.668  1.00  9.36           C  
ATOM   2567  CE  LYS F   8      10.810  -0.722  24.255  1.00  9.36           C  
ATOM   2568  NZ  LYS F   8      11.006  -0.452  25.705  1.00  9.04           N  
ATOM   2569  N   LEU F   9       7.327   2.614  19.077  1.00  8.02           N  
ATOM   2570  CA  LEU F   9       6.269   2.872  18.110  1.00  9.05           C  
ATOM   2571  C   LEU F   9       6.468   1.963  16.895  1.00  9.54           C  
ATOM   2572  O   LEU F   9       7.460   2.101  16.181  1.00  8.99           O  
ATOM   2573  CB  LEU F   9       6.267   4.337  17.664  1.00 11.34           C  
ATOM   2574  CG  LEU F   9       6.481   5.398  18.745  1.00 13.52           C  
ATOM   2575  CD1 LEU F   9       6.294   6.794  18.160  1.00 13.97           C  
ATOM   2576  CD2 LEU F   9       5.534   5.206  19.916  1.00 14.84           C  
ATOM   2577  N   GLU F  10       5.534   1.043  16.713  1.00 10.07           N  
ATOM   2578  CA  GLU F  10       5.648   0.107  15.584  1.00 10.41           C  
ATOM   2579  C   GLU F  10       5.214   0.833  14.316  1.00  9.84           C  
ATOM   2580  O   GLU F  10       4.038   1.133  14.145  1.00 10.79           O  
ATOM   2581  CB  GLU F  10       4.852  -1.160  15.860  1.00 13.26           C  
ATOM   2582  CG  GLU F  10       5.409  -1.959  17.034  1.00 17.20           C  
ATOM   2583  CD  GLU F  10       4.822  -3.354  17.119  1.00 19.63           C  
ATOM   2584  OE1 GLU F  10       3.583  -3.467  17.043  1.00 21.96           O  
ATOM   2585  OE2 GLU F  10       5.593  -4.325  17.248  1.00 22.01           O  
ATOM   2586  N   ALA F  11       6.189   1.157  13.468  1.00  9.65           N  
ATOM   2587  CA  ALA F  11       5.916   1.909  12.254  1.00  9.65           C  
ATOM   2588  C   ALA F  11       6.465   1.274  10.982  1.00  9.47           C  
ATOM   2589  O   ALA F  11       7.068   0.201  11.017  1.00  8.67           O  
ATOM   2590  CB  ALA F  11       6.506   3.309  12.423  1.00  9.82           C  
ATOM   2591  N   THR F  12       6.228   1.931   9.857  1.00  9.56           N  
ATOM   2592  CA  THR F  12       6.690   1.456   8.559  1.00 10.51           C  
ATOM   2593  C   THR F  12       7.510   2.549   7.885  1.00  9.82           C  
ATOM   2594  O   THR F  12       7.075   3.700   7.858  1.00 10.93           O  
ATOM   2595  CB  THR F  12       5.503   1.068   7.658  1.00 10.92           C  
ATOM   2596  OG1 THR F  12       4.742   0.037   8.300  1.00 11.68           O  
ATOM   2597  CG2 THR F  12       5.941   0.568   6.287  1.00 11.66           C  
ATOM   2598  N   VAL F  13       8.676   2.194   7.355  1.00 10.17           N  
ATOM   2599  CA  VAL F  13       9.497   3.179   6.650  1.00 10.30           C  
ATOM   2600  C   VAL F  13       8.832   3.587   5.335  1.00 10.35           C  
ATOM   2601  O   VAL F  13       8.447   2.716   4.550  1.00 10.43           O  
ATOM   2602  CB  VAL F  13      10.904   2.622   6.364  1.00 10.61           C  
ATOM   2603  CG1 VAL F  13      11.765   3.622   5.607  1.00  9.90           C  
ATOM   2604  CG2 VAL F  13      11.580   2.227   7.670  1.00 10.74           C  
ATOM   2605  N   LYS F  14       8.700   4.888   5.098  1.00 10.64           N  
ATOM   2606  CA  LYS F  14       8.137   5.384   3.852  1.00 11.61           C  
ATOM   2607  C   LYS F  14       9.224   5.892   2.899  1.00 11.50           C  
ATOM   2608  O   LYS F  14       9.118   5.728   1.683  1.00 12.63           O  
ATOM   2609  CB  LYS F  14       7.163   6.546   4.055  1.00 13.13           C  
ATOM   2610  CG  LYS F  14       5.982   6.289   4.973  1.00 14.95           C  
ATOM   2611  CD  LYS F  14       4.894   7.338   4.760  1.00 15.72           C  
ATOM   2612  CE  LYS F  14       5.253   8.684   5.355  1.00 16.14           C  
ATOM   2613  NZ  LYS F  14       4.143   9.673   5.245  1.00 15.78           N  
ATOM   2614  N   GLU F  15      10.224   6.557   3.447  1.00 10.97           N  
ATOM   2615  CA  GLU F  15      11.271   7.196   2.662  1.00 11.28           C  
ATOM   2616  C   GLU F  15      12.558   7.359   3.458  1.00 11.11           C  
ATOM   2617  O   GLU F  15      12.496   7.580   4.671  1.00 10.37           O  
ATOM   2618  CB  GLU F  15      10.741   8.582   2.266  1.00 12.77           C  
ATOM   2619  CG  GLU F  15      11.709   9.491   1.543  1.00 14.78           C  
ATOM   2620  CD  GLU F  15      11.206  10.908   1.359  1.00 16.24           C  
ATOM   2621  OE1 GLU F  15      10.266  11.332   2.067  1.00 17.37           O  
ATOM   2622  OE2 GLU F  15      11.770  11.621   0.497  1.00 17.70           O  
ATOM   2623  N   ILE F  16      13.689   7.276   2.777  1.00 11.05           N  
ATOM   2624  CA  ILE F  16      15.004   7.446   3.379  1.00 10.86           C  
ATOM   2625  C   ILE F  16      15.823   8.411   2.525  1.00 11.36           C  
ATOM   2626  O   ILE F  16      15.930   8.227   1.310  1.00 12.00           O  
ATOM   2627  CB  ILE F  16      15.779   6.118   3.498  1.00 11.37           C  
ATOM   2628  CG1 ILE F  16      15.017   5.161   4.420  1.00 11.64           C  
ATOM   2629  CG2 ILE F  16      17.197   6.343   4.011  1.00 11.13           C  
ATOM   2630  CD1 ILE F  16      15.531   3.737   4.426  1.00 12.33           C  
ATOM   2631  N   VAL F  17      16.403   9.427   3.144  1.00 10.90           N  
ATOM   2632  CA  VAL F  17      17.247  10.387   2.446  1.00 11.51           C  
ATOM   2633  C   VAL F  17      18.628  10.332   3.104  1.00 11.88           C  
ATOM   2634  O   VAL F  17      18.750  10.625   4.291  1.00 10.78           O  
ATOM   2635  CB  VAL F  17      16.719  11.826   2.453  1.00 11.40           C  
ATOM   2636  CG1 VAL F  17      17.722  12.763   1.783  1.00 11.36           C  
ATOM   2637  CG2 VAL F  17      15.371  11.898   1.752  1.00 12.57           C  
ATOM   2638  N   LYS F  18      19.641   9.938   2.342  1.00 12.79           N  
ATOM   2639  CA  LYS F  18      20.985   9.811   2.884  1.00 14.49           C  
ATOM   2640  C   LYS F  18      21.850  11.037   2.626  1.00 15.17           C  
ATOM   2641  O   LYS F  18      21.994  11.486   1.492  1.00 16.15           O  
ATOM   2642  CB  LYS F  18      21.680   8.588   2.270  1.00 15.82           C  
ATOM   2643  CG  LYS F  18      20.923   7.283   2.469  1.00 17.17           C  
ATOM   2644  CD  LYS F  18      21.550   6.161   1.654  1.00 18.41           C  
ATOM   2645  CE  LYS F  18      20.670   4.919   1.663  1.00 19.42           C  
ATOM   2646  NZ  LYS F  18      21.151   3.941   0.638  1.00 19.92           N  
ATOM   2647  N   GLY F  19      22.450  11.552   3.694  1.00 15.35           N  
ATOM   2648  CA  GLY F  19      23.372  12.682   3.595  1.00 15.49           C  
ATOM   2649  C   GLY F  19      24.795  12.126   3.735  1.00 15.56           C  
ATOM   2650  O   GLY F  19      24.990  10.915   3.624  1.00 15.43           O  
ATOM   2651  N   THR F  20      25.764  12.998   3.986  1.00 16.42           N  
ATOM   2652  CA  THR F  20      27.147  12.543   4.136  1.00 16.36           C  
ATOM   2653  C   THR F  20      27.364  11.822   5.462  1.00 15.05           C  
ATOM   2654  O   THR F  20      28.162  10.893   5.572  1.00 15.36           O  
ATOM   2655  CB  THR F  20      28.126  13.732   4.063  1.00 17.82           C  
ATOM   2656  OG1 THR F  20      27.866  14.478   2.869  1.00 19.89           O  
ATOM   2657  CG2 THR F  20      29.574  13.269   4.065  1.00 18.69           C  
ATOM   2658  N   VAL F  21      26.653  12.288   6.483  1.00 14.00           N  
ATOM   2659  CA  VAL F  21      26.777  11.734   7.826  1.00 12.01           C  
ATOM   2660  C   VAL F  21      25.447  11.241   8.372  1.00 11.09           C  
ATOM   2661  O   VAL F  21      25.378  10.152   8.938  1.00 10.23           O  
ATOM   2662  CB  VAL F  21      27.356  12.818   8.761  1.00 12.32           C  
ATOM   2663  CG1 VAL F  21      27.338  12.389  10.219  1.00 12.41           C  
ATOM   2664  CG2 VAL F  21      28.775  13.168   8.317  1.00 12.41           C  
ATOM   2665  N   MET F  22      24.416  12.071   8.230  1.00 11.08           N  
ATOM   2666  CA  MET F  22      23.102  11.712   8.758  1.00  9.85           C  
ATOM   2667  C   MET F  22      22.153  11.245   7.666  1.00 10.23           C  
ATOM   2668  O   MET F  22      22.368  11.513   6.492  1.00  9.52           O  
ATOM   2669  CB  MET F  22      22.482  12.912   9.482  1.00 11.01           C  
ATOM   2670  CG  MET F  22      23.327  13.482  10.614  1.00 11.28           C  
ATOM   2671  SD  MET F  22      23.554  12.305  11.952  1.00 10.30           S  
ATOM   2672  CE  MET F  22      21.863  12.132  12.538  1.00 11.90           C  
ATOM   2673  N   ALA F  23      21.082  10.583   8.077  1.00  9.04           N  
ATOM   2674  CA  ALA F  23      20.023  10.136   7.199  1.00  8.46           C  
ATOM   2675  C   ALA F  23      18.658  10.491   7.801  1.00  8.03           C  
ATOM   2676  O   ALA F  23      18.462  10.414   9.017  1.00  7.83           O  
ATOM   2677  CB  ALA F  23      20.071   8.632   6.972  1.00  8.89           C  
ATOM   2678  N   LYS F  24      17.749  10.892   6.924  1.00  7.12           N  
ATOM   2679  CA  LYS F  24      16.377  11.169   7.332  1.00  7.48           C  
ATOM   2680  C   LYS F  24      15.555   9.904   7.083  1.00  7.84           C  
ATOM   2681  O   LYS F  24      15.543   9.375   5.971  1.00  8.02           O  
ATOM   2682  CB  LYS F  24      15.759  12.340   6.574  1.00  8.47           C  
ATOM   2683  CG  LYS F  24      14.293  12.560   6.935  1.00  9.94           C  
ATOM   2684  CD  LYS F  24      13.678  13.761   6.252  1.00 10.81           C  
ATOM   2685  CE  LYS F  24      13.686  13.637   4.738  1.00 11.51           C  
ATOM   2686  NZ  LYS F  24      12.843  14.703   4.118  1.00 13.09           N  
ATOM   2687  N   ILE F  25      14.894   9.414   8.121  1.00  7.46           N  
ATOM   2688  CA  ILE F  25      14.050   8.236   8.035  1.00  7.74           C  
ATOM   2689  C   ILE F  25      12.602   8.690   8.227  1.00  8.16           C  
ATOM   2690  O   ILE F  25      12.259   9.158   9.315  1.00  8.41           O  
ATOM   2691  CB  ILE F  25      14.374   7.174   9.101  1.00  8.00           C  
ATOM   2692  CG1 ILE F  25      15.877   6.945   9.272  1.00  7.28           C  
ATOM   2693  CG2 ILE F  25      13.663   5.862   8.800  1.00  8.39           C  
ATOM   2694  CD1 ILE F  25      16.630   6.549   8.018  1.00  7.83           C  
ATOM   2695  N   VAL F  26      11.800   8.647   7.170  1.00  7.84           N  
ATOM   2696  CA  VAL F  26      10.405   9.063   7.248  1.00  8.82           C  
ATOM   2697  C   VAL F  26       9.557   7.810   7.435  1.00  8.47           C  
ATOM   2698  O   VAL F  26       9.711   6.853   6.678  1.00  8.21           O  
ATOM   2699  CB  VAL F  26       9.940   9.822   5.994  1.00  8.91           C  
ATOM   2700  CG1 VAL F  26       8.528  10.354   6.203  1.00  9.50           C  
ATOM   2701  CG2 VAL F  26      10.895  10.950   5.636  1.00  9.38           C  
ATOM   2702  N   MET F  27       8.760   7.776   8.497  1.00  8.74           N  
ATOM   2703  CA  MET F  27       7.950   6.611   8.818  1.00  8.29           C  
ATOM   2704  C   MET F  27       6.471   6.951   8.982  1.00  9.41           C  
ATOM   2705  O   MET F  27       6.092   8.100   9.202  1.00  9.32           O  
ATOM   2706  CB  MET F  27       8.452   5.950  10.114  1.00  8.02           C  
ATOM   2707  CG  MET F  27       9.877   5.429  10.010  1.00  7.57           C  
ATOM   2708  SD  MET F  27      10.585   5.068  11.635  1.00  7.25           S  
ATOM   2709  CE  MET F  27      11.049   6.721  12.149  1.00  8.26           C  
ATOM   2710  N   ASP F  28       5.643   5.922   8.850  1.00  9.93           N  
ATOM   2711  CA  ASP F  28       4.211   6.058   9.069  1.00 11.33           C  
ATOM   2712  C   ASP F  28       3.866   5.311  10.358  1.00 11.16           C  
ATOM   2713  O   ASP F  28       4.218   4.146  10.521  1.00  9.69           O  
ATOM   2714  CB  ASP F  28       3.370   5.505   7.923  1.00 13.39           C  
ATOM   2715  CG  ASP F  28       1.885   5.540   8.239  1.00 15.27           C  
ATOM   2716  OD1 ASP F  28       1.310   6.641   8.274  1.00 16.71           O  
ATOM   2717  OD2 ASP F  28       1.286   4.467   8.460  1.00 17.98           O  
ATOM   2718  N   TYR F  29       3.161   6.006  11.248  1.00 12.04           N  
ATOM   2719  CA  TYR F  29       2.750   5.382  12.499  1.00 13.99           C  
ATOM   2720  C   TYR F  29       1.245   5.577  12.667  1.00 14.33           C  
ATOM   2721  O   TYR F  29       0.803   6.652  13.056  1.00 14.49           O  
ATOM   2722  CB  TYR F  29       3.554   5.950  13.657  1.00 15.54           C  
ATOM   2723  CG  TYR F  29       3.275   5.327  15.001  1.00 17.49           C  
ATOM   2724  CD1 TYR F  29       3.092   3.961  15.155  1.00 18.35           C  
ATOM   2725  CD2 TYR F  29       3.229   6.132  16.135  1.00 18.57           C  
ATOM   2726  CE1 TYR F  29       2.837   3.407  16.395  1.00 18.84           C  
ATOM   2727  CE2 TYR F  29       2.983   5.577  17.380  1.00 19.23           C  
ATOM   2728  CZ  TYR F  29       2.783   4.225  17.505  1.00 19.41           C  
ATOM   2729  OH  TYR F  29       2.536   3.705  18.755  1.00 19.58           O  
ATOM   2730  N   LYS F  30       0.499   4.541  12.305  1.00 14.98           N  
ATOM   2731  CA  LYS F  30      -0.958   4.570  12.402  1.00 16.83           C  
ATOM   2732  C   LYS F  30      -1.519   5.852  11.814  1.00 17.01           C  
ATOM   2733  O   LYS F  30      -2.399   6.504  12.374  1.00 18.04           O  
ATOM   2734  CB  LYS F  30      -1.380   4.330  13.857  1.00 17.43           C  
ATOM   2735  CG  LYS F  30      -1.099   2.903  14.304  1.00 18.80           C  
ATOM   2736  CD  LYS F  30      -1.677   2.546  15.654  1.00 19.62           C  
ATOM   2737  CE  LYS F  30      -0.767   2.889  16.820  1.00 20.52           C  
ATOM   2738  NZ  LYS F  30      -1.176   2.178  18.070  1.00 21.06           N  
ATOM   2739  N   GLY F  31      -0.985   6.240  10.659  1.00 17.39           N  
ATOM   2740  CA  GLY F  31      -1.432   7.410   9.937  1.00 16.88           C  
ATOM   2741  C   GLY F  31      -0.692   8.697  10.238  1.00 16.53           C  
ATOM   2742  O   GLY F  31      -0.908   9.681   9.519  1.00 17.77           O  
ATOM   2743  N   THR F  32       0.128   8.730  11.282  1.00 14.75           N  
ATOM   2744  CA  THR F  32       0.880   9.933  11.627  1.00 13.75           C  
ATOM   2745  C   THR F  32       2.305   9.791  11.091  1.00 12.60           C  
ATOM   2746  O   THR F  32       2.899   8.720  11.236  1.00 12.79           O  
ATOM   2747  CB  THR F  32       0.927  10.189  13.140  1.00 14.43           C  
ATOM   2748  OG1 THR F  32      -0.389  10.501  13.631  1.00 15.11           O  
ATOM   2749  CG2 THR F  32       1.856  11.339  13.508  1.00 14.73           C  
ATOM   2750  N   GLU F  33       2.838  10.843  10.482  1.00 10.91           N  
ATOM   2751  CA  GLU F  33       4.203  10.749   9.966  1.00  9.53           C  
ATOM   2752  C   GLU F  33       5.229  11.006  11.066  1.00  9.15           C  
ATOM   2753  O   GLU F  33       5.091  11.958  11.824  1.00  8.95           O  
ATOM   2754  CB  GLU F  33       4.406  11.741   8.820  1.00 10.19           C  
ATOM   2755  CG  GLU F  33       5.808  11.711   8.216  1.00 11.23           C  
ATOM   2756  CD  GLU F  33       5.865  12.491   6.910  1.00 12.13           C  
ATOM   2757  OE1 GLU F  33       6.458  13.582   6.905  1.00 13.44           O  
ATOM   2758  OE2 GLU F  33       5.305  12.015   5.900  1.00 13.28           O  
ATOM   2759  N   LEU F  34       6.248  10.159  11.127  1.00  8.63           N  
ATOM   2760  CA  LEU F  34       7.364  10.301  12.049  1.00  8.22           C  
ATOM   2761  C   LEU F  34       8.635  10.623  11.254  1.00  8.30           C  
ATOM   2762  O   LEU F  34       8.758  10.215  10.091  1.00  8.25           O  
ATOM   2763  CB  LEU F  34       7.595   9.026  12.857  1.00  8.56           C  
ATOM   2764  CG  LEU F  34       6.449   8.456  13.696  1.00  8.57           C  
ATOM   2765  CD1 LEU F  34       6.873   7.190  14.432  1.00  8.80           C  
ATOM   2766  CD2 LEU F  34       5.950   9.474  14.717  1.00  9.16           C  
ATOM   2767  N   VAL F  35       9.592  11.320  11.860  1.00  6.86           N  
ATOM   2768  CA  VAL F  35      10.852  11.634  11.208  1.00  7.59           C  
ATOM   2769  C   VAL F  35      11.990  11.430  12.214  1.00  7.63           C  
ATOM   2770  O   VAL F  35      12.024  12.057  13.271  1.00  7.36           O  
ATOM   2771  CB  VAL F  35      10.956  13.056  10.632  1.00  7.38           C  
ATOM   2772  CG1 VAL F  35      12.297  13.276   9.947  1.00  7.91           C  
ATOM   2773  CG2 VAL F  35       9.819  13.334   9.652  1.00  8.52           C  
ATOM   2774  N   ALA F  36      12.887  10.515  11.872  1.00  7.62           N  
ATOM   2775  CA  ALA F  36      14.044  10.223  12.708  1.00  7.13           C  
ATOM   2776  C   ALA F  36      15.290  10.646  11.927  1.00  7.37           C  
ATOM   2777  O   ALA F  36      15.324  10.465  10.703  1.00  8.24           O  
ATOM   2778  CB  ALA F  36      14.149   8.752  13.061  1.00  7.92           C  
ATOM   2779  N   ALA F  37      16.283  11.164  12.617  1.00  6.45           N  
ATOM   2780  CA  ALA F  37      17.561  11.524  12.009  1.00  7.11           C  
ATOM   2781  C   ALA F  37      18.611  10.661  12.710  1.00  7.96           C  
ATOM   2782  O   ALA F  37      18.834  10.793  13.914  1.00  7.74           O  
ATOM   2783  CB  ALA F  37      17.835  13.002  12.129  1.00  7.64           C  
ATOM   2784  N   ILE F  38      19.138   9.689  11.976  1.00  7.35           N  
ATOM   2785  CA  ILE F  38      20.124   8.739  12.473  1.00  8.09           C  
ATOM   2786  C   ILE F  38      21.343   8.731  11.555  1.00  8.36           C  
ATOM   2787  O   ILE F  38      21.312   9.435  10.540  1.00  8.43           O  
ATOM   2788  CB  ILE F  38      19.517   7.329  12.562  1.00  6.89           C  
ATOM   2789  CG1 ILE F  38      19.084   6.826  11.175  1.00  6.68           C  
ATOM   2790  CG2 ILE F  38      18.331   7.296  13.533  1.00  7.32           C  
ATOM   2791  CD1 ILE F  38      18.687   5.365  11.140  1.00  7.47           C  
ATOM   2792  N   THR F  39      22.418   8.023  11.893  1.00  7.17           N  
ATOM   2793  CA  THR F  39      23.598   8.042  11.027  1.00  7.45           C  
ATOM   2794  C   THR F  39      23.396   7.151   9.800  1.00  7.46           C  
ATOM   2795  O   THR F  39      22.633   6.191   9.835  1.00  7.21           O  
ATOM   2796  CB  THR F  39      24.856   7.554  11.768  1.00  7.26           C  
ATOM   2797  OG1 THR F  39      24.636   6.199  12.185  1.00  8.19           O  
ATOM   2798  CG2 THR F  39      25.142   8.400  13.000  1.00  7.94           C  
ATOM   2799  N   ILE F  40      24.124   7.489   8.726  1.00  7.94           N  
ATOM   2800  CA  ILE F  40      24.023   6.640   7.529  1.00  8.59           C  
ATOM   2801  C   ILE F  40      24.579   5.252   7.846  1.00  8.19           C  
ATOM   2802  O   ILE F  40      24.158   4.258   7.253  1.00  8.40           O  
ATOM   2803  CB  ILE F  40      24.695   7.222   6.282  1.00 10.04           C  
ATOM   2804  CG1 ILE F  40      26.175   7.519   6.528  1.00 10.50           C  
ATOM   2805  CG2 ILE F  40      23.964   8.478   5.821  1.00 10.09           C  
ATOM   2806  CD1 ILE F  40      26.977   7.722   5.256  1.00 11.43           C  
ATOM   2807  N   ASP F  41      25.472   5.181   8.827  1.00  8.82           N  
ATOM   2808  CA  ASP F  41      26.050   3.923   9.280  1.00  9.81           C  
ATOM   2809  C   ASP F  41      24.954   2.964   9.737  1.00  9.47           C  
ATOM   2810  O   ASP F  41      24.975   1.773   9.443  1.00  9.30           O  
ATOM   2811  CB  ASP F  41      27.049   4.167  10.420  1.00 11.57           C  
ATOM   2812  CG  ASP F  41      28.089   5.194   9.998  1.00 13.18           C  
ATOM   2813  OD1 ASP F  41      27.706   6.349   9.716  1.00 14.33           O  
ATOM   2814  OD2 ASP F  41      29.286   4.860   9.933  1.00 14.58           O  
ATOM   2815  N   SER F  42      23.977   3.501  10.465  1.00  8.90           N  
ATOM   2816  CA  SER F  42      22.849   2.716  10.941  1.00  8.91           C  
ATOM   2817  C   SER F  42      21.924   2.264   9.822  1.00  9.33           C  
ATOM   2818  O   SER F  42      21.391   1.156   9.881  1.00  9.46           O  
ATOM   2819  CB  SER F  42      22.052   3.551  11.965  1.00  9.01           C  
ATOM   2820  OG  SER F  42      22.851   3.702  13.119  1.00 10.49           O  
ATOM   2821  N   VAL F  43      21.730   3.123   8.819  1.00  9.24           N  
ATOM   2822  CA  VAL F  43      20.894   2.729   7.681  1.00  9.50           C  
ATOM   2823  C   VAL F  43      21.505   1.491   7.020  1.00  9.68           C  
ATOM   2824  O   VAL F  43      20.802   0.548   6.656  1.00  9.97           O  
ATOM   2825  CB  VAL F  43      20.704   3.854   6.666  1.00 10.16           C  
ATOM   2826  CG1 VAL F  43      19.922   3.406   5.436  1.00 10.35           C  
ATOM   2827  CG2 VAL F  43      19.949   5.023   7.298  1.00  9.64           C  
ATOM   2828  N   ALA F  44      22.826   1.505   6.891  1.00  9.93           N  
ATOM   2829  CA  ALA F  44      23.550   0.385   6.294  1.00 10.77           C  
ATOM   2830  C   ALA F  44      23.508  -0.848   7.186  1.00 10.66           C  
ATOM   2831  O   ALA F  44      23.241  -1.964   6.735  1.00 10.93           O  
ATOM   2832  CB  ALA F  44      24.991   0.808   6.019  1.00 11.23           C  
ATOM   2833  N   ASP F  45      23.794  -0.665   8.473  1.00 10.62           N  
ATOM   2834  CA  ASP F  45      23.811  -1.783   9.412  1.00 10.79           C  
ATOM   2835  C   ASP F  45      22.469  -2.493   9.488  1.00 10.58           C  
ATOM   2836  O   ASP F  45      22.397  -3.726   9.490  1.00 11.28           O  
ATOM   2837  CB  ASP F  45      24.244  -1.267  10.783  1.00 11.53           C  
ATOM   2838  CG  ASP F  45      24.486  -2.353  11.806  1.00 12.66           C  
ATOM   2839  OD1 ASP F  45      24.844  -3.485  11.416  1.00 13.48           O  
ATOM   2840  OD2 ASP F  45      24.323  -2.075  13.016  1.00 12.81           O  
ATOM   2841  N   LEU F  46      21.391  -1.725   9.562  1.00  9.63           N  
ATOM   2842  CA  LEU F  46      20.042  -2.254   9.651  1.00  9.86           C  
ATOM   2843  C   LEU F  46      19.454  -2.591   8.284  1.00 10.02           C  
ATOM   2844  O   LEU F  46      18.381  -3.188   8.198  1.00 10.16           O  
ATOM   2845  CB  LEU F  46      19.133  -1.229  10.355  1.00 10.22           C  
ATOM   2846  CG  LEU F  46      19.101  -1.287  11.884  1.00 10.35           C  
ATOM   2847  CD1 LEU F  46      20.478  -1.058  12.498  1.00 10.52           C  
ATOM   2848  CD2 LEU F  46      18.113  -0.265  12.436  1.00 10.84           C  
ATOM   2849  N   ASP F  47      20.166  -2.208   7.230  1.00 10.65           N  
ATOM   2850  CA  ASP F  47      19.687  -2.422   5.867  1.00 11.50           C  
ATOM   2851  C   ASP F  47      18.271  -1.881   5.718  1.00 10.98           C  
ATOM   2852  O   ASP F  47      17.351  -2.514   5.211  1.00 11.28           O  
ATOM   2853  CB  ASP F  47      19.783  -3.900   5.480  1.00 12.61           C  
ATOM   2854  CG  ASP F  47      21.206  -4.286   5.122  1.00 14.13           C  
ATOM   2855  OD1 ASP F  47      21.725  -3.741   4.123  1.00 15.03           O  
ATOM   2856  OD2 ASP F  47      21.805  -5.104   5.843  1.00 15.55           O  
ATOM   2857  N   LEU F  48      18.098  -0.635   6.178  1.00 10.42           N  
ATOM   2858  CA  LEU F  48      16.795   0.014   6.129  1.00 10.55           C  
ATOM   2859  C   LEU F  48      16.383   0.386   4.708  1.00 10.28           C  
ATOM   2860  O   LEU F  48      17.144   1.012   3.973  1.00 10.14           O  
ATOM   2861  CB  LEU F  48      16.767   1.283   6.987  1.00 11.04           C  
ATOM   2862  CG  LEU F  48      16.850   1.112   8.501  1.00 11.36           C  
ATOM   2863  CD1 LEU F  48      16.831   2.485   9.171  1.00 11.65           C  
ATOM   2864  CD2 LEU F  48      15.720   0.251   9.036  1.00 10.32           C  
ATOM   2865  N   VAL F  49      15.147   0.053   4.359  1.00 10.15           N  
ATOM   2866  CA  VAL F  49      14.590   0.398   3.057  1.00 10.79           C  
ATOM   2867  C   VAL F  49      13.100   0.702   3.204  1.00 10.88           C  
ATOM   2868  O   VAL F  49      12.439   0.223   4.130  1.00 11.22           O  
ATOM   2869  CB  VAL F  49      14.765  -0.710   2.005  1.00 10.97           C  
ATOM   2870  CG1 VAL F  49      16.240  -1.011   1.780  1.00 11.31           C  
ATOM   2871  CG2 VAL F  49      14.019  -1.975   2.404  1.00 10.76           C  
ATOM   2872  N   PRO F  50      12.552   1.463   2.278  1.00 11.05           N  
ATOM   2873  CA  PRO F  50      11.130   1.785   2.300  1.00 11.36           C  
ATOM   2874  C   PRO F  50      10.316   0.503   2.332  1.00 12.00           C  
ATOM   2875  O   PRO F  50      10.620  -0.466   1.628  1.00 12.47           O  
ATOM   2876  CB  PRO F  50      10.933   2.607   1.037  1.00 11.41           C  
ATOM   2877  CG  PRO F  50      12.275   3.183   0.750  1.00 11.90           C  
ATOM   2878  CD  PRO F  50      13.258   2.100   1.139  1.00 11.85           C  
ATOM   2879  N   GLY F  51       9.298   0.454   3.186  1.00 11.77           N  
ATOM   2880  CA  GLY F  51       8.441  -0.706   3.332  1.00 11.04           C  
ATOM   2881  C   GLY F  51       8.796  -1.525   4.567  1.00 10.79           C  
ATOM   2882  O   GLY F  51       7.995  -2.343   5.023  1.00 11.33           O  
ATOM   2883  N   ASP F  52       9.991  -1.318   5.115  1.00  9.99           N  
ATOM   2884  CA  ASP F  52      10.400  -2.064   6.293  1.00  9.84           C  
ATOM   2885  C   ASP F  52       9.529  -1.757   7.515  1.00  9.95           C  
ATOM   2886  O   ASP F  52       9.246  -0.595   7.784  1.00 10.49           O  
ATOM   2887  CB  ASP F  52      11.840  -1.748   6.691  1.00 10.14           C  
ATOM   2888  CG  ASP F  52      12.896  -2.535   5.942  1.00 10.38           C  
ATOM   2889  OD1 ASP F  52      12.545  -3.475   5.201  1.00 11.89           O  
ATOM   2890  OD2 ASP F  52      14.087  -2.195   6.110  1.00 11.20           O  
ATOM   2891  N   LYS F  53       9.172  -2.815   8.229  1.00 10.03           N  
ATOM   2892  CA  LYS F  53       8.454  -2.659   9.497  1.00 10.99           C  
ATOM   2893  C   LYS F  53       9.554  -2.460  10.541  1.00 10.29           C  
ATOM   2894  O   LYS F  53      10.504  -3.241  10.627  1.00 10.96           O  
ATOM   2895  CB  LYS F  53       7.569  -3.855   9.807  1.00 13.01           C  
ATOM   2896  CG  LYS F  53       6.520  -4.114   8.733  1.00 15.46           C  
ATOM   2897  CD  LYS F  53       5.471  -3.017   8.676  1.00 17.71           C  
ATOM   2898  CE  LYS F  53       4.471  -3.251   7.557  1.00 19.05           C  
ATOM   2899  NZ  LYS F  53       3.612  -2.067   7.281  1.00 20.28           N  
ATOM   2900  N   VAL F  54       9.452  -1.377  11.298  1.00  9.44           N  
ATOM   2901  CA  VAL F  54      10.482  -1.050  12.274  1.00  8.39           C  
ATOM   2902  C   VAL F  54       9.857  -0.568  13.576  1.00  8.23           C  
ATOM   2903  O   VAL F  54       8.639  -0.400  13.665  1.00  7.99           O  
ATOM   2904  CB  VAL F  54      11.405   0.066  11.750  1.00  8.74           C  
ATOM   2905  CG1 VAL F  54      12.091  -0.368  10.460  1.00  8.92           C  
ATOM   2906  CG2 VAL F  54      10.629   1.359  11.526  1.00  9.31           C  
ATOM   2907  N   THR F  55      10.718  -0.372  14.564  1.00  7.36           N  
ATOM   2908  CA  THR F  55      10.243   0.172  15.832  1.00  8.19           C  
ATOM   2909  C   THR F  55      10.962   1.496  16.058  1.00  7.31           C  
ATOM   2910  O   THR F  55      12.194   1.500  16.130  1.00  7.55           O  
ATOM   2911  CB  THR F  55      10.492  -0.765  17.019  1.00  8.59           C  
ATOM   2912  OG1 THR F  55       9.722  -1.962  16.852  1.00 10.57           O  
ATOM   2913  CG2 THR F  55      10.076  -0.079  18.319  1.00  9.95           C  
ATOM   2914  N   ALA F  56      10.216   2.597  16.104  1.00  6.71           N  
ATOM   2915  CA  ALA F  56      10.818   3.883  16.448  1.00  7.54           C  
ATOM   2916  C   ALA F  56      10.991   3.891  17.964  1.00  7.56           C  
ATOM   2917  O   ALA F  56      10.084   3.450  18.680  1.00  7.95           O  
ATOM   2918  CB  ALA F  56       9.964   5.038  15.971  1.00  6.93           C  
ATOM   2919  N   LEU F  57      12.153   4.302  18.453  1.00  6.12           N  
ATOM   2920  CA  LEU F  57      12.411   4.259  19.892  1.00  6.57           C  
ATOM   2921  C   LEU F  57      12.781   5.614  20.471  1.00  5.96           C  
ATOM   2922  O   LEU F  57      13.644   6.303  19.924  1.00  6.01           O  
ATOM   2923  CB  LEU F  57      13.525   3.239  20.160  1.00  7.02           C  
ATOM   2924  CG  LEU F  57      14.013   3.117  21.607  1.00  7.97           C  
ATOM   2925  CD1 LEU F  57      12.995   2.367  22.456  1.00  9.12           C  
ATOM   2926  CD2 LEU F  57      15.385   2.447  21.674  1.00  9.26           C  
ATOM   2927  N   VAL F  58      12.132   5.997  21.571  1.00  5.50           N  
ATOM   2928  CA  VAL F  58      12.422   7.286  22.186  1.00  5.22           C  
ATOM   2929  C   VAL F  58      12.553   7.147  23.699  1.00  4.83           C  
ATOM   2930  O   VAL F  58      11.649   6.604  24.343  1.00  5.80           O  
ATOM   2931  CB  VAL F  58      11.330   8.339  21.897  1.00  4.97           C  
ATOM   2932  CG1 VAL F  58      11.702   9.670  22.521  1.00  5.35           C  
ATOM   2933  CG2 VAL F  58      11.125   8.484  20.389  1.00  5.74           C  
ATOM   2934  N   LYS F  59      13.651   7.657  24.230  1.00  4.57           N  
ATOM   2935  CA  LYS F  59      13.900   7.618  25.668  1.00  4.61           C  
ATOM   2936  C   LYS F  59      12.904   8.549  26.364  1.00  4.64           C  
ATOM   2937  O   LYS F  59      12.643   9.644  25.879  1.00  5.14           O  
ATOM   2938  CB  LYS F  59      15.335   8.047  25.977  1.00  5.26           C  
ATOM   2939  CG  LYS F  59      15.785   7.625  27.375  1.00  4.86           C  
ATOM   2940  CD  LYS F  59      17.248   7.946  27.631  1.00  5.37           C  
ATOM   2941  CE  LYS F  59      17.677   7.381  28.988  1.00  6.00           C  
ATOM   2942  NZ  LYS F  59      17.129   8.187  30.114  1.00  5.98           N  
ATOM   2943  N   ALA F  60      12.400   8.118  27.525  1.00  5.12           N  
ATOM   2944  CA  ALA F  60      11.406   8.926  28.233  1.00  5.29           C  
ATOM   2945  C   ALA F  60      11.869  10.343  28.524  1.00  5.48           C  
ATOM   2946  O   ALA F  60      11.089  11.306  28.441  1.00  5.53           O  
ATOM   2947  CB  ALA F  60      11.015   8.244  29.548  1.00  5.91           C  
ATOM   2948  N   THR F  61      13.137  10.490  28.889  1.00  5.54           N  
ATOM   2949  CA  THR F  61      13.693  11.799  29.217  1.00  6.26           C  
ATOM   2950  C   THR F  61      13.834  12.712  28.008  1.00  6.50           C  
ATOM   2951  O   THR F  61      14.174  13.888  28.195  1.00  6.29           O  
ATOM   2952  CB  THR F  61      15.068  11.624  29.900  1.00  6.83           C  
ATOM   2953  OG1 THR F  61      15.866  10.778  29.066  1.00  6.53           O  
ATOM   2954  CG2 THR F  61      14.895  10.969  31.263  1.00  7.07           C  
ATOM   2955  N   GLU F  62      13.625  12.181  26.808  1.00  7.28           N  
ATOM   2956  CA  GLU F  62      13.753  12.992  25.600  1.00  8.67           C  
ATOM   2957  C   GLU F  62      12.408  13.320  24.979  1.00  9.29           C  
ATOM   2958  O   GLU F  62      12.353  13.764  23.833  1.00 11.48           O  
ATOM   2959  CB  GLU F  62      14.643  12.268  24.569  1.00 10.49           C  
ATOM   2960  CG  GLU F  62      16.112  12.315  24.967  1.00 15.01           C  
ATOM   2961  CD  GLU F  62      16.978  11.257  24.324  1.00 17.03           C  
ATOM   2962  OE1 GLU F  62      16.593  10.661  23.302  1.00 18.68           O  
ATOM   2963  OE2 GLU F  62      18.073  10.995  24.878  1.00 19.71           O  
ATOM   2964  N   MET F  63      11.322  13.063  25.703  1.00  6.75           N  
ATOM   2965  CA  MET F  63       9.982  13.359  25.190  1.00  6.73           C  
ATOM   2966  C   MET F  63       9.363  14.517  25.947  1.00  6.39           C  
ATOM   2967  O   MET F  63       9.257  14.452  27.178  1.00  6.09           O  
ATOM   2968  CB  MET F  63       9.099  12.110  25.264  1.00  6.12           C  
ATOM   2969  CG  MET F  63       7.673  12.323  24.755  1.00  5.76           C  
ATOM   2970  SD  MET F  63       6.669  10.825  24.832  1.00  5.04           S  
ATOM   2971  CE  MET F  63       7.285   9.986  23.360  1.00  5.70           C  
ATOM   2972  N   GLU F  64       8.994  15.584  25.246  1.00  5.84           N  
ATOM   2973  CA  GLU F  64       8.333  16.723  25.872  1.00  4.69           C  
ATOM   2974  C   GLU F  64       6.823  16.553  25.724  1.00  4.39           C  
ATOM   2975  O   GLU F  64       6.318  15.728  24.970  1.00  4.60           O  
ATOM   2976  CB  GLU F  64       8.804  18.045  25.248  1.00  3.75           C  
ATOM   2977  CG  GLU F  64      10.267  18.314  25.574  1.00  4.55           C  
ATOM   2978  CD  GLU F  64      10.909  19.570  25.053  1.00  2.00           C  
ATOM   2979  OE1 GLU F  64      10.181  20.349  24.502  1.00  4.32           O  
ATOM   2980  OE2 GLU F  64      12.136  19.823  25.124  1.00 12.28           O  
ATOM   2981  N   VAL F  65       6.108  17.337  26.540  1.00  5.27           N  
ATOM   2982  CA  VAL F  65       4.649  17.356  26.509  1.00  5.74           C  
ATOM   2983  C   VAL F  65       4.207  18.806  26.265  1.00  5.67           C  
ATOM   2984  O   VAL F  65       4.751  19.706  26.901  1.00  5.64           O  
ATOM   2985  CB  VAL F  65       4.045  16.830  27.815  1.00  6.32           C  
ATOM   2986  CG1 VAL F  65       2.521  16.845  27.779  1.00  7.48           C  
ATOM   2987  CG2 VAL F  65       4.570  15.427  28.103  1.00  6.43           C  
ATOM   2988  N   LEU F  66       3.279  18.978  25.328  1.00  5.93           N  
ATOM   2989  CA  LEU F  66       2.745  20.294  25.009  1.00  7.21           C  
ATOM   2990  C   LEU F  66       1.242  20.334  25.321  1.00  6.85           C  
ATOM   2991  O   LEU F  66       0.541  19.358  25.061  1.00  7.19           O  
ATOM   2992  CB  LEU F  66       2.906  20.593  23.523  1.00  8.46           C  
ATOM   2993  CG  LEU F  66       4.230  21.012  22.902  1.00 11.79           C  
ATOM   2994  CD1 LEU F  66       5.440  20.419  23.589  1.00 11.73           C  
ATOM   2995  CD2 LEU F  66       4.228  20.670  21.412  1.00 11.94           C  
ATOM   2996  N   LYS F  67       0.758  21.447  25.854  1.00  7.42           N  
ATOM   2997  CA  LYS F  67      -0.670  21.612  26.098  1.00  6.98           C  
ATOM   2998  C   LYS F  67      -0.985  23.118  26.042  1.00  7.80           C  
ATOM   2999  O   LYS F  67      -0.378  23.855  26.833  1.00  8.83           O  
ATOM   3000  CB  LYS F  67      -1.199  21.024  27.406  1.00  7.58           C  
ATOM   3001  CG  LYS F  67      -2.725  21.166  27.477  1.00  7.62           C  
ATOM   3002  CD  LYS F  67      -3.295  20.566  28.746  1.00  8.04           C  
ATOM   3003  CE  LYS F  67      -4.807  20.747  28.815  1.00  8.14           C  
ATOM   3004  NZ  LYS F  67      -5.150  22.137  29.243  1.00 10.16           N  
ATOM   3005  OXT LYS F  67      -1.828  23.477  25.193  1.00 10.14           O  
TER    3006      LYS F  67                                                      
END
MOLECULE T0409.pdb
ATOM     14  N   TYR     1     -12.138  -6.437  34.342  1.00 26.71           N  
ATOM     15  CA  TYR     1     -10.769  -6.327  34.864  1.00 25.90           C  
ATOM     16  C   TYR     1     -10.498  -7.542  35.724  1.00 24.98           C  
ATOM     17  O   TYR     1     -11.355  -7.916  36.501  1.00 26.34           O  
ATOM     18  CB  TYR     1     -10.618  -5.047  35.686  1.00 24.63           C  
ATOM     19  CG  TYR     1      -9.168  -4.728  36.029  1.00 22.28           C  
ATOM     20  CD1 TYR     1      -8.285  -4.357  35.005  1.00 22.31           C  
ATOM     21  CD2 TYR     1      -8.664  -4.878  37.313  1.00 23.91           C  
ATOM     22  CE1 TYR     1      -6.951  -4.068  35.280  1.00 18.52           C  
ATOM     23  CE2 TYR     1      -7.324  -4.598  37.613  1.00 21.53           C  
ATOM     24  CZ  TYR     1      -6.480  -4.192  36.581  1.00 19.19           C  
ATOM     25  OH  TYR     1      -5.185  -3.925  36.888  1.00 18.14           O  
ATOM     26  N   ARG     2      -9.329  -8.164  35.541  1.00 24.27           N  
ATOM     27  CA  ARG     2      -8.922  -9.381  36.228  1.00 24.78           C  
ATOM     28  C   ARG     2      -7.920  -9.194  37.353  1.00 24.52           C  
ATOM     29  O   ARG     2      -7.621 -10.122  38.085  1.00 27.44           O  
ATOM     30  CB  ARG     2      -8.346 -10.374  35.215  1.00 23.92           C  
ATOM     31  CG  ARG     2      -9.347 -10.845  34.134  1.00 25.70           C  
ATOM     32  CD  ARG     2      -8.657 -11.765  33.135  1.00 25.52           C  
ATOM     33  NE  ARG     2      -7.696 -11.068  32.290  1.00 27.24           N  
ATOM     34  CZ  ARG     2      -8.028 -10.316  31.245  1.00 25.99           C  
ATOM     35  NH1 ARG     2      -7.092  -9.705  30.558  1.00 26.10           N  
ATOM     36  NH2 ARG     2      -9.305 -10.178  30.888  1.00 30.15           N  
ATOM     37  N   GLY     3      -7.404  -7.992  37.483  1.00 23.54           N  
ATOM     38  CA  GLY     3      -6.475  -7.700  38.540  1.00 21.96           C  
ATOM     39  C   GLY     3      -5.048  -7.714  38.006  1.00 20.01           C  
ATOM     40  O   GLY     3      -4.763  -8.208  36.927  1.00 19.98           O  
ATOM     41  N   PRO     4      -4.121  -7.183  38.794  1.00 18.75           N  
ATOM     42  CA  PRO     4      -2.718  -7.124  38.362  1.00 17.90           C  
ATOM     43  C   PRO     4      -2.069  -8.474  38.133  1.00 17.43           C  
ATOM     44  O   PRO     4      -2.332  -9.438  38.886  1.00 17.86           O  
ATOM     45  CB  PRO     4      -1.998  -6.462  39.555  1.00 17.83           C  
ATOM     46  CG  PRO     4      -3.078  -5.804  40.295  1.00 17.56           C  
ATOM     47  CD  PRO     4      -4.293  -6.604  40.137  1.00 20.04           C  
ATOM     48  N   GLU     5      -1.198  -8.523  37.136  1.00 16.41           N  
ATOM     49  CA  GLU     5      -0.494  -9.734  36.776  1.00 16.74           C  
ATOM     50  C   GLU     5       0.555 -10.210  37.794  1.00 15.28           C  
ATOM     51  O   GLU     5       0.894 -11.399  37.821  1.00 14.56           O  
ATOM     52  CB  GLU     5       0.179  -9.574  35.415  1.00 18.28           C  
ATOM     53  CG  GLU     5       1.357  -8.668  35.384  1.00 18.86           C  
ATOM     54  CD  GLU     5       1.641  -8.109  33.976  1.00 21.65           C  
ATOM     55  OE1 GLU     5       0.838  -7.287  33.462  1.00 19.17           O  
ATOM     56  OE2 GLU     5       2.690  -8.452  33.404  1.00 20.12           O  
ATOM     57  N   ALA     6       1.090  -9.262  38.551  1.00 14.75           N  
ATOM     58  CA  ALA     6       2.230  -9.503  39.408  1.00 12.91           C  
ATOM     59  C   ALA     6       2.286  -8.383  40.423  1.00 13.86           C  
ATOM     60  O   ALA     6       1.662  -7.340  40.252  1.00 14.07           O  
ATOM     61  CB  ALA     6       3.557  -9.555  38.607  1.00 14.41           C  
ATOM     62  N   PHE     7       3.056  -8.616  41.463  1.00 12.90           N  
ATOM     63  CA  PHE     7       3.312  -7.619  42.514  1.00 12.74           C  
ATOM     64  C   PHE     7       4.803  -7.561  42.789  1.00 14.31           C  
ATOM     65  O   PHE     7       5.426  -8.577  43.064  1.00 16.10           O  
ATOM     66  CB  PHE     7       2.558  -7.975  43.774  1.00 12.84           C  
ATOM     67  CG  PHE     7       1.061  -7.980  43.588  1.00 13.25           C  
ATOM     68  CD1 PHE     7       0.432  -9.083  43.089  1.00 12.42           C  
ATOM     69  CD2 PHE     7       0.284  -6.851  43.907  1.00 13.57           C  
ATOM     70  CE1 PHE     7      -0.949  -9.101  42.892  1.00 15.56           C  
ATOM     71  CE2 PHE     7      -1.084  -6.875  43.732  1.00 14.79           C  
ATOM     72  CZ  PHE     7      -1.682  -7.984  43.198  1.00 14.93           C  
ATOM     73  N   LEU     8       5.379  -6.378  42.730  1.00 13.78           N  
ATOM     74  CA  LEU     8       6.799  -6.166  43.031  1.00 14.87           C  
ATOM     75  C   LEU     8       6.959  -5.587  44.431  1.00 17.18           C  
ATOM     76  O   LEU     8       6.012  -5.033  45.021  1.00 18.46           O  
ATOM     77  CB  LEU     8       7.409  -5.253  41.997  1.00 14.89           C  
ATOM     78  CG  LEU     8       7.096  -5.514  40.532  1.00 15.32           C  
ATOM     79  CD1 LEU     8       7.647  -4.518  39.513  1.00 16.20           C  
ATOM     80  CD2 LEU     8       7.592  -6.945  40.214  1.00 16.59           C  
ATOM     81  N   LYS     9       8.127  -5.818  45.005  1.00 17.65           N  
ATOM     82  CA  LYS     9       8.421  -5.348  46.361  1.00 19.07           C  
ATOM     83  C   LYS     9       9.052  -3.955  46.263  1.00 17.92           C  
ATOM     84  O   LYS     9      10.150  -3.798  45.727  1.00 18.25           O  
ATOM     85  CB  LYS     9       9.373  -6.314  47.042  1.00 19.67           C  
ATOM     86  CG  LYS     9       9.591  -5.980  48.493  1.00 23.14           C  
ATOM     87  CD  LYS     9      10.639  -6.886  49.072  1.00 24.83           C  
ATOM     88  CE  LYS     9      10.121  -8.265  49.428  1.00 32.25           C  
ATOM     89  NZ  LYS     9      10.917  -8.817  50.575  1.00 34.79           N  
ATOM     90  N   LEU    10       8.369  -2.926  46.749  1.00 18.72           N  
ATOM     91  CA  LEU    10       8.826  -1.580  46.551  1.00 18.81           C  
ATOM     92  C   LEU    10       9.942  -1.228  47.554  1.00 19.68           C  
ATOM     93  O   LEU    10      10.009  -1.815  48.647  1.00 20.89           O  
ATOM     94  CB  LEU    10       7.717  -0.560  46.770  1.00 20.05           C  
ATOM     95  CG  LEU    10       6.533  -0.547  45.822  1.00 19.19           C  
ATOM     96  CD1 LEU    10       5.473   0.394  46.436  1.00 24.82           C  
ATOM     97  CD2 LEU    10       6.945  -0.115  44.440  1.00 21.53           C  
ATOM     98  N   PRO    11      10.774  -0.268  47.163  1.00 20.13           N  
ATOM     99  CA  PRO    11      11.661   0.375  48.167  1.00 21.78           C  
ATOM    100  C   PRO    11      10.838   1.323  49.071  1.00 22.52           C  
ATOM    101  O   PRO    11       9.740   1.732  48.679  1.00 23.44           O  
ATOM    102  CB  PRO    11      12.607   1.193  47.285  1.00 20.85           C  
ATOM    103  CG  PRO    11      11.779   1.545  46.072  1.00 22.93           C  
ATOM    104  CD  PRO    11      10.970   0.307  45.828  1.00 19.70           C  
ATOM    105  N   LYS    12      11.406   1.739  50.229  1.00 25.61           N  
ATOM    106  CA  LYS    12      10.808   2.820  51.069  1.00 26.86           C  
ATOM    107  C   LYS    12      10.655   4.134  50.323  1.00 28.24           C  
ATOM    108  O   LYS    12       9.621   4.815  50.414  1.00 30.07           O  
ATOM    109  CB  LYS    12      11.725   3.141  52.244  1.00 27.78           C  
ATOM    110  CG  LYS    12      11.297   2.660  53.597  1.00 29.19           C  
ATOM    111  CD  LYS    12      12.113   3.300  54.688  1.00 28.24           C  
ATOM    112  CE  LYS    12      11.543   4.613  55.215  1.00 28.46           C  
ATOM    113  NZ  LYS    12      12.177   4.939  56.553  1.00 29.49           N  
ATOM    114  N   ASP    13      11.716   4.525  49.615  1.00 29.01           N  
ATOM    115  CA  ASP    13      11.746   5.788  48.876  1.00 29.32           C  
ATOM    116  C   ASP    13      11.132   5.663  47.484  1.00 30.39           C  
ATOM    117  O   ASP    13      11.712   5.127  46.535  1.00 29.19           O  
ATOM    118  CB  ASP    13      13.189   6.371  48.893  1.00 29.16           C  
ATOM    119  CG  ASP    13      13.347   7.664  48.082  1.00 30.92           C  
ATOM    120  OD1 ASP    13      12.344   8.274  47.628  1.00 34.61           O  
ATOM    121  OD2 ASP    13      14.529   8.080  47.888  1.00 32.69           O  
ATOM    122  N   LEU    14       9.920   6.195  47.363  1.00 30.90           N  
ATOM    123  CA  LEU    14       9.172   6.157  46.124  1.00 30.71           C  
ATOM    124  C   LEU    14       9.608   7.149  45.049  1.00 30.84           C  
ATOM    125  O   LEU    14       9.020   7.178  43.964  1.00 31.55           O  
ATOM    126  CB  LEU    14       7.678   6.329  46.424  1.00 30.89           C  
ATOM    127  CG  LEU    14       7.124   5.332  47.440  1.00 30.54           C  
ATOM    128  CD1 LEU    14       5.711   5.725  47.765  1.00 33.63           C  
ATOM    129  CD2 LEU    14       7.169   3.889  46.924  1.00 35.44           C  
ATOM    130  N   LYS    15      10.614   7.983  45.348  1.00 30.72           N  
ATOM    131  CA  LYS    15      11.255   8.810  44.324  1.00 30.73           C  
ATOM    132  C   LYS    15      12.623   8.265  43.901  1.00 29.76           C  
ATOM    133  O   LYS    15      13.272   8.865  43.053  1.00 30.87           O  
ATOM    134  CB  LYS    15      11.408  10.266  44.806  1.00 32.76           C  
ATOM    135  CG  LYS    15      10.232  11.196  44.418  1.00 35.47           C  
ATOM    136  CD  LYS    15       9.079  11.039  45.367  1.00 37.91           C  
ATOM    137  CE  LYS    15       9.288  11.906  46.603  1.00 39.30           C  
ATOM    138  NZ  LYS    15       8.302  11.581  47.681  1.00 39.71           N  
ATOM    139  N   ASP    16      13.046   7.133  44.481  1.00 27.99           N  
ATOM    140  CA  ASP    16      14.328   6.493  44.094  1.00 26.78           C  
ATOM    141  C   ASP    16      14.118   5.763  42.782  1.00 25.11           C  
ATOM    142  O   ASP    16      13.741   4.600  42.764  1.00 24.88           O  
ATOM    143  CB  ASP    16      14.802   5.533  45.171  1.00 25.55           C  
ATOM    144  CG  ASP    16      16.217   4.970  44.893  1.00 26.06           C  
ATOM    145  OD1 ASP    16      16.650   5.014  43.729  1.00 25.61           O  
ATOM    146  OD2 ASP    16      16.861   4.472  45.830  1.00 25.02           O  
ATOM    147  N   ARG    17      14.360   6.449  41.680  1.00 25.11           N  
ATOM    148  CA  ARG    17      14.118   5.904  40.359  1.00 24.25           C  
ATOM    149  C   ARG    17      14.973   4.689  40.041  1.00 23.79           C  
ATOM    150  O   ARG    17      14.497   3.729  39.431  1.00 22.80           O  
ATOM    151  CB  ARG    17      14.276   6.978  39.293  1.00 26.64           C  
ATOM    152  CG  ARG    17      13.323   8.136  39.528  1.00 30.06           C  
ATOM    153  CD  ARG    17      12.985   8.820  38.245  1.00 37.41           C  
ATOM    154  NE  ARG    17      14.129   9.542  37.706  1.00 40.97           N  
ATOM    155  CZ  ARG    17      14.150  10.097  36.499  1.00 43.91           C  
ATOM    156  NH1 ARG    17      13.094   9.997  35.685  1.00 45.45           N  
ATOM    157  NH2 ARG    17      15.241  10.749  36.096  1.00 45.78           N  
ATOM    158  N   GLU    18      16.227   4.705  40.494  1.00 22.85           N  
ATOM    159  CA  GLU    18      17.123   3.549  40.277  1.00 22.70           C  
ATOM    160  C   GLU    18      16.572   2.269  40.913  1.00 20.63           C  
ATOM    161  O   GLU    18      16.555   1.211  40.278  1.00 19.78           O  
ATOM    162  CB  GLU    18      18.500   3.848  40.866  1.00 23.30           C  
ATOM    163  CG  GLU    18      19.549   2.754  40.681  1.00 24.01           C  
ATOM    164  CD  GLU    18      20.941   3.182  41.148  1.00 26.13           C  
ATOM    165  OE1 GLU    18      21.200   3.135  42.381  1.00 31.97           O  
ATOM    166  OE2 GLU    18      21.761   3.558  40.278  1.00 30.80           O  
ATOM    167  N   ALA    19      16.146   2.364  42.159  1.00 18.69           N  
ATOM    168  CA  ALA    19      15.569   1.237  42.865  1.00 18.72           C  
ATOM    169  C   ALA    19      14.286   0.741  42.184  1.00 18.42           C  
ATOM    170  O   ALA    19      14.079  -0.477  42.073  1.00 18.40           O  
ATOM    171  CB  ALA    19      15.248   1.627  44.285  1.00 19.53           C  
ATOM    172  N   LEU    20      13.438   1.683  41.764  1.00 18.86           N  
ATOM    173  CA  LEU    20      12.198   1.346  41.088  1.00 18.10           C  
ATOM    174  C   LEU    20      12.479   0.694  39.747  1.00 18.59           C  
ATOM    175  O   LEU    20      11.826  -0.289  39.383  1.00 18.02           O  
ATOM    176  CB  LEU    20      11.269   2.570  40.902  1.00 19.62           C  
ATOM    177  CG  LEU    20      10.779   3.123  42.243  1.00 19.47           C  
ATOM    178  CD1 LEU    20      10.171   4.490  42.063  1.00 25.48           C  
ATOM    179  CD2 LEU    20       9.776   2.141  42.919  1.00 20.59           C  
ATOM    180  N   GLN    21      13.439   1.212  38.971  1.00 17.08           N  
ATOM    181  CA  GLN    21      13.818   0.563  37.701  0.60 17.52           C  
ATOM    183  C   GLN    21      14.339  -0.838  37.961  1.00 17.89           C  
ATOM    184  O   GLN    21      14.076  -1.788  37.220  1.00 17.69           O  
ATOM    185  CB  GLN    21      14.943   1.338  36.986  0.60 18.21           C  
ATOM    187  CG  GLN    21      14.503   2.626  36.329  0.60 18.89           C  
ATOM    189  CD  GLN    21      13.515   2.472  35.158  0.60 20.48           C  
ATOM    191  OE1 GLN    21      13.254   1.364  34.619  0.60 23.97           O  
ATOM    193  NE2 GLN    21      12.980   3.610  34.738  0.60 22.78           N  
ATOM    195  N   ASP    22      15.104  -0.995  39.034  1.00 16.55           N  
ATOM    196  CA  ASP    22      15.680  -2.315  39.349  1.00 17.02           C  
ATOM    197  C   ASP    22      14.611  -3.356  39.634  1.00 16.63           C  
ATOM    198  O   ASP    22      14.714  -4.505  39.156  1.00 16.75           O  
ATOM    199  CB  ASP    22      16.632  -2.228  40.544  1.00 17.24           C  
ATOM    200  CG  ASP    22      18.015  -1.694  40.162  1.00 19.16           C  
ATOM    201  OD1 ASP    22      18.327  -1.439  38.960  1.00 22.10           O  
ATOM    202  OD2 ASP    22      18.789  -1.547  41.118  1.00 23.09           O  
ATOM    203  N   ILE    23      13.551  -2.982  40.363  1.00 15.22           N  
ATOM    204  CA  ILE    23      12.501  -4.017  40.667  1.00 15.44           C  
ATOM    205  C   ILE    23      11.696  -4.359  39.393  1.00 15.80           C  
ATOM    206  O   ILE    23      11.130  -5.448  39.328  1.00 16.91           O  
ATOM    207  CB  ILE    23      11.538  -3.666  41.812  1.00 14.93           C  
ATOM    208  CG1 ILE    23      10.715  -2.400  41.496  1.00 16.08           C  
ATOM    209  CG2 ILE    23      12.349  -3.420  43.109  1.00 16.92           C  
ATOM    210  CD1 ILE    23       9.662  -2.083  42.539  1.00 18.45           C  
ATOM    211  N   MET    24      11.693  -3.454  38.407  1.00 16.35           N  
ATOM    212  CA  MET    24      11.001  -3.635  37.136  1.00 16.51           C  
ATOM    213  C   MET    24      11.870  -4.256  36.047  1.00 16.28           C  
ATOM    214  O   MET    24      11.426  -4.374  34.907  1.00 16.01           O  
ATOM    215  CB  MET    24      10.471  -2.276  36.650  1.00 16.46           C  
ATOM    216  CG  MET    24       9.476  -1.622  37.540  1.00 17.64           C  
ATOM    217  SD  MET    24       8.685  -0.053  36.632  0.80 26.05          SE  
ATOM    218  CE  MET    24       7.421  -0.860  35.445  1.00 24.41           C  
ATOM    219  N   GLN    25      13.092  -4.631  36.388  1.00 16.67           N  
ATOM    220  CA  GLN    25      14.070  -4.998  35.365  1.00 17.43           C  
ATOM    221  C   GLN    25      13.592  -6.036  34.353  1.00 16.67           C  
ATOM    222  O   GLN    25      14.004  -5.969  33.198  1.00 17.33           O  
ATOM    223  CB  GLN    25      15.374  -5.433  36.005  1.00 18.09           C  
ATOM    224  CG  GLN    25      15.329  -6.698  36.777  1.00 20.57           C  
ATOM    225  CD  GLN    25      16.656  -7.030  37.461  1.00 24.40           C  
ATOM    226  OE1 GLN    25      17.683  -6.382  37.193  1.00 30.15           O  
ATOM    227  NE2 GLN    25      16.631  -8.020  38.370  1.00 29.33           N  
ATOM    228  N   ASP    26      12.790  -7.013  34.797  1.00 15.34           N  
ATOM    229  CA  ASP    26      12.390  -8.124  33.918  1.00 15.72           C  
ATOM    230  C   ASP    26      11.142  -7.834  33.073  1.00 16.03           C  
ATOM    231  O   ASP    26      10.876  -8.602  32.131  1.00 16.34           O  
ATOM    232  CB  ASP    26      12.120  -9.391  34.723  1.00 15.05           C  
ATOM    233  CG  ASP    26      13.409 -10.027  35.326  1.00 18.38           C  
ATOM    234  OD1 ASP    26      14.527  -9.715  34.833  1.00 21.09           O  
ATOM    235  OD2 ASP    26      13.261 -10.859  36.262  1.00 21.86           O  
ATOM    236  N   ILE    27      10.434  -6.762  33.392  1.00 16.05           N  
ATOM    237  CA  ILE    27       9.093  -6.467  32.882  0.60 17.18           C  
ATOM    239  C   ILE    27       9.116  -5.228  31.989  1.00 17.24           C  
ATOM    240  O   ILE    27       9.908  -4.318  32.214  1.00 16.86           O  
ATOM    241  CB  ILE    27       8.122  -6.210  34.080  0.60 17.87           C  
ATOM    243  CG1 ILE    27       8.158  -7.384  35.052  0.60 18.38           C  
ATOM    245  CG2 ILE    27       6.684  -5.914  33.601  0.60 18.73           C  
ATOM    247  CD1 ILE    27       7.986  -8.690  34.409  0.60 20.09           C  
ATOM    249  N   GLY    28       8.241  -5.184  31.003  1.00 17.82           N  
ATOM    250  CA  GLY    28       8.066  -3.945  30.257  1.00 18.09           C  
ATOM    251  C   GLY    28       9.221  -3.577  29.353  1.00 18.07           C  
ATOM    252  O   GLY    28       9.365  -2.424  28.950  1.00 18.91           O  
ATOM    253  N   ASN    29      10.036  -4.547  28.983  1.00 18.26           N  
ATOM    254  CA  ASN    29      11.290  -4.211  28.309  1.00 18.83           C  
ATOM    255  C   ASN    29      11.112  -3.765  26.859  1.00 19.92           C  
ATOM    256  O   ASN    29      12.054  -3.163  26.287  1.00 23.13           O  
ATOM    257  CB  ASN    29      12.315  -5.308  28.491  1.00 19.12           C  
ATOM    258  CG  ASN    29      12.920  -5.252  29.901  1.00 18.82           C  
ATOM    259  OD1 ASN    29      13.210  -4.141  30.417  1.00 20.59           O  
ATOM    260  ND2 ASN    29      13.068  -6.410  30.534  1.00 20.14           N  
ATOM    261  N   SER    30       9.940  -3.996  26.289  1.00 19.51           N  
ATOM    262  CA  SER    30       9.638  -3.436  24.946  1.00 19.62           C  
ATOM    263  C   SER    30       8.833  -2.162  25.064  1.00 19.59           C  
ATOM    264  O   SER    30       8.467  -1.576  24.052  1.00 20.08           O  
ATOM    265  CB  SER    30       8.915  -4.467  24.077  1.00 20.71           C  
ATOM    266  OG  SER    30       7.714  -4.851  24.696  1.00 25.23           O  
ATOM    267  N   ASP    31       8.554  -1.688  26.286  1.00 19.24           N  
ATOM    268  CA  ASP    31       7.719  -0.480  26.428  1.00 19.48           C  
ATOM    269  C   ASP    31       8.399   0.728  25.751  1.00 19.11           C  
ATOM    270  O   ASP    31       9.607   0.921  25.855  1.00 18.28           O  
ATOM    271  CB  ASP    31       7.472  -0.170  27.903  1.00 19.32           C  
ATOM    272  CG  ASP    31       6.382  -1.059  28.540  1.00 20.97           C  
ATOM    273  OD1 ASP    31       5.838  -1.957  27.861  1.00 20.12           O  
ATOM    274  OD2 ASP    31       6.130  -0.786  29.749  1.00 20.60           O  
ATOM    275  N   ASP    32       7.573   1.496  25.059  1.00 19.06           N  
ATOM    276  CA  ASP    32       7.966   2.731  24.373  1.00 20.14           C  
ATOM    277  C   ASP    32       8.776   2.490  23.102  1.00 19.79           C  
ATOM    278  O   ASP    32       9.198   3.461  22.447  1.00 19.91           O  
ATOM    279  CB  ASP    32       8.712   3.674  25.293  1.00 20.73           C  
ATOM    280  CG  ASP    32       7.963   3.948  26.635  1.00 23.39           C  
ATOM    281  OD1 ASP    32       6.803   4.403  26.542  1.00 25.24           O  
ATOM    282  OD2 ASP    32       8.564   3.719  27.723  1.00 25.94           O  
ATOM    283  N   ILE    33       8.996   1.235  22.770  1.00 19.89           N  
ATOM    284  CA  ILE    33       9.673   0.832  21.522  1.00 20.20           C  
ATOM    285  C   ILE    33       8.565   0.449  20.573  1.00 20.72           C  
ATOM    286  O   ILE    33       7.960  -0.632  20.700  1.00 22.37           O  
ATOM    287  CB  ILE    33      10.677  -0.334  21.711  1.00 19.45           C  
ATOM    288  CG1 ILE    33      11.758   0.114  22.689  1.00 21.44           C  
ATOM    289  CG2 ILE    33      11.304  -0.710  20.329  1.00 20.56           C  
ATOM    290  CD1 ILE    33      12.772  -0.956  23.051  1.00 22.94           C  
ATOM    291  N   LEU    34       8.299   1.342  19.626  1.00 19.25           N  
ATOM    292  CA  LEU    34       7.087   1.314  18.818  1.00 17.77           C  
ATOM    293  C   LEU    34       7.338   0.882  17.390  1.00 18.40           C  
ATOM    294  O   LEU    34       8.388   1.119  16.839  1.00 18.47           O  
ATOM    295  CB  LEU    34       6.469   2.701  18.781  1.00 18.47           C  
ATOM    296  CG  LEU    34       6.267   3.371  20.125  1.00 19.72           C  
ATOM    297  CD1 LEU    34       5.545   4.684  19.944  1.00 22.67           C  
ATOM    298  CD2 LEU    34       5.548   2.434  21.132  1.00 21.13           C  
ATOM    299  N   ALA    35       6.348   0.240  16.797  1.00 18.57           N  
ATOM    300  CA  ALA    35       6.435  -0.175  15.394  1.00 17.19           C  
ATOM    301  C   ALA    35       6.217   1.030  14.494  1.00 17.33           C  
ATOM    302  O   ALA    35       5.387   1.913  14.741  1.00 18.24           O  
ATOM    303  CB  ALA    35       5.390  -1.293  15.057  1.00 19.13           C  
ATOM    304  N   ALA    36       6.928   1.044  13.360  1.00 17.01           N  
ATOM    305  CA  ALA    36       6.674   2.049  12.357  1.00 15.71           C  
ATOM    306  C   ALA    36       7.034   1.462  10.990  1.00 16.78           C  
ATOM    307  O   ALA    36       7.901   0.604  10.879  1.00 18.10           O  
ATOM    308  CB  ALA    36       7.457   3.343  12.596  1.00 17.58           C  
ATOM    309  N   VAL    37       6.370   1.955   9.975  1.00 15.62           N  
ATOM    310  CA  VAL    37       6.682   1.549   8.602  0.50 15.71           C  
ATOM    312  C   VAL    37       7.312   2.714   7.873  1.00 14.23           C  
ATOM    313  O   VAL    37       6.779   3.823   7.872  1.00 15.68           O  
ATOM    314  CB  VAL    37       5.451   1.037   7.797  0.50 15.29           C  
ATOM    316  CG1 VAL    37       4.346   2.086   7.714  0.50 16.13           C  
ATOM    318  CG2 VAL    37       5.858   0.619   6.389  0.50 16.06           C  
ATOM    320  N   VAL    38       8.435   2.456   7.238  1.00 14.86           N  
ATOM    321  CA  VAL    38       9.172   3.493   6.517  1.00 14.41           C  
ATOM    322  C   VAL    38       8.438   3.924   5.239  1.00 15.45           C  
ATOM    323  O   VAL    38       7.986   3.077   4.449  1.00 14.72           O  
ATOM    324  CB  VAL    38      10.630   3.065   6.225  1.00 15.18           C  
ATOM    325  CG1 VAL    38      11.345   4.116   5.259  1.00 14.75           C  
ATOM    326  CG2 VAL    38      11.387   2.893   7.574  1.00 15.41           C  
ATOM    327  N   LEU    39       8.293   5.236   5.093  1.00 14.89           N  
ATOM    328  CA  LEU    39       7.728   5.844   3.883  1.00 15.30           C  
ATOM    329  C   LEU    39       8.802   6.367   2.923  1.00 16.16           C  
ATOM    330  O   LEU    39       8.618   6.337   1.717  1.00 17.32           O  
ATOM    331  CB  LEU    39       6.793   7.008   4.266  1.00 16.91           C  
ATOM    332  CG  LEU    39       5.696   6.599   5.252  1.00 17.60           C  
ATOM    333  CD1 LEU    39       4.796   7.809   5.545  1.00 21.11           C  
ATOM    334  CD2 LEU    39       4.876   5.379   4.818  1.00 20.56           C  
ATOM    335  N   SER    40       9.878   6.946   3.451  1.00 16.45           N  
ATOM    336  CA  SER    40      10.967   7.414   2.684  1.00 16.91           C  
ATOM    337  C   SER    40      12.241   7.291   3.490  1.00 16.85           C  
ATOM    338  O   SER    40      12.195   7.364   4.707  1.00 15.68           O  
ATOM    339  CB  SER    40      10.726   8.848   2.271  1.00 18.60           C  
ATOM    340  OG  SER    40      10.878   9.725   3.348  1.00 19.69           O  
ATOM    341  N   ALA    41      13.376   7.151   2.802  1.00 16.13           N  
ATOM    342  CA  ALA    41      14.666   7.013   3.492  1.00 16.24           C  
ATOM    343  C   ALA    41      15.808   7.516   2.678  1.00 17.06           C  
ATOM    344  O   ALA    41      15.937   7.212   1.489  1.00 17.44           O  
ATOM    345  CB  ALA    41      14.932   5.590   3.873  1.00 16.02           C  
ATOM    346  N   THR    42      16.603   8.346   3.317  1.00 17.62           N  
ATOM    347  CA  THR    42      17.909   8.824   2.826  1.00 18.26           C  
ATOM    348  C   THR    42      18.903   8.767   3.996  1.00 18.56           C  
ATOM    349  O   THR    42      18.496   8.630   5.155  1.00 16.63           O  
ATOM    350  CB  THR    42      17.820  10.268   2.317  1.00 18.38           C  
ATOM    351  OG1 THR    42      17.681  11.157   3.433  1.00 21.26           O  
ATOM    352  CG2 THR    42      16.634  10.457   1.330  1.00 21.04           C  
ATOM    353  N   PRO    43      20.207   8.983   3.741  1.00 18.87           N  
ATOM    354  CA  PRO    43      21.125   9.006   4.879  1.00 18.55           C  
ATOM    355  C   PRO    43      20.851  10.148   5.880  1.00 18.56           C  
ATOM    356  O   PRO    43      21.326  10.095   7.044  1.00 20.67           O  
ATOM    357  CB  PRO    43      22.499   9.197   4.201  1.00 19.88           C  
ATOM    358  CG  PRO    43      22.329   8.653   2.885  1.00 19.28           C  
ATOM    359  CD  PRO    43      20.938   9.070   2.467  1.00 20.45           C  
ATOM    360  N   GLY    44      20.139  11.170   5.431  1.00 16.96           N  
ATOM    361  CA  GLY    44      19.835  12.346   6.269  1.00 17.33           C  
ATOM    362  C   GLY    44      18.471  12.343   6.932  1.00 16.12           C  
ATOM    363  O   GLY    44      18.259  13.110   7.843  1.00 16.70           O  
ATOM    364  N   ALA    45      17.521  11.522   6.465  1.00 15.44           N  
ATOM    365  CA  ALA    45      16.194  11.546   7.049  1.00 16.18           C  
ATOM    366  C   ALA    45      15.409  10.293   6.680  1.00 16.57           C  
ATOM    367  O   ALA    45      15.433   9.862   5.536  1.00 16.49           O  
ATOM    368  CB  ALA    45      15.445  12.726   6.525  1.00 16.54           C  
ATOM    369  N   VAL    46      14.702   9.747   7.648  1.00 16.15           N  
ATOM    370  CA  VAL    46      13.752   8.676   7.432  1.00 15.46           C  
ATOM    371  C   VAL    46      12.395   9.193   7.901  1.00 16.21           C  
ATOM    372  O   VAL    46      12.272   9.685   9.044  1.00 15.82           O  
ATOM    373  CB  VAL    46      14.173   7.440   8.255  1.00 14.79           C  
ATOM    374  CG1 VAL    46      13.059   6.405   8.283  1.00 16.16           C  
ATOM    375  CG2 VAL    46      15.520   6.906   7.736  1.00 15.90           C  
ATOM    376  N   GLU    47      11.375   9.063   7.045  1.00 16.26           N  
ATOM    377  CA  GLU    47       9.987   9.338   7.431  1.00 17.37           C  
ATOM    378  C   GLU    47       9.318   7.985   7.648  1.00 17.25           C  
ATOM    379  O   GLU    47       9.447   7.094   6.805  1.00 16.35           O  
ATOM    380  CB  GLU    47       9.240  10.078   6.308  1.00 18.76           C  
ATOM    381  CG  GLU    47       9.768  11.459   6.058  1.00 22.56           C  
ATOM    382  CD  GLU    47       8.728  12.493   5.613  1.00 27.08           C  
ATOM    383  OE1 GLU    47       7.596  12.140   5.191  1.00 32.70           O  
ATOM    384  OE2 GLU    47       9.093  13.699   5.695  1.00 39.15           O  
ATOM    385  N   ALA    48       8.608   7.831   8.751  1.00 15.79           N  
ATOM    386  CA  ALA    48       7.954   6.581   9.088  1.00 16.62           C  
ATOM    387  C   ALA    48       6.568   6.823   9.690  1.00 16.84           C  
ATOM    388  O   ALA    48       6.358   7.839  10.370  1.00 19.46           O  
ATOM    389  CB  ALA    48       8.843   5.735  10.026  1.00 17.11           C  
ATOM    390  N   PHE    49       5.635   5.922   9.429  1.00 16.37           N  
ATOM    391  CA  PHE    49       4.267   5.991   9.929  1.00 17.59           C  
ATOM    392  C   PHE    49       4.122   5.056  11.129  1.00 18.32           C  
ATOM    393  O   PHE    49       4.501   3.899  11.058  1.00 17.79           O  
ATOM    394  CB  PHE    49       3.296   5.544   8.820  1.00 17.85           C  
ATOM    395  CG  PHE    49       1.842   5.641   9.191  1.00 18.30           C  
ATOM    396  CD1 PHE    49       1.144   6.802   8.933  1.00 21.76           C  
ATOM    397  CD2 PHE    49       1.164   4.553   9.695  1.00 20.75           C  
ATOM    398  CE1 PHE    49      -0.227   6.916   9.249  1.00 20.36           C  
ATOM    399  CE2 PHE    49      -0.206   4.656  10.047  1.00 19.72           C  
ATOM    400  CZ  PHE    49      -0.881   5.839   9.796  1.00 22.60           C  
ATOM    401  N   ARG    50       3.636   5.563  12.253  1.00 19.08           N  
ATOM    402  CA  ARG    50       3.464   4.703  13.441  1.00 20.23           C  
ATOM    403  C   ARG    50       1.972   4.382  13.686  1.00 21.07           C  
ATOM    404  O   ARG    50       1.117   4.995  13.106  1.00 20.64           O  
ATOM    405  CB  ARG    50       4.134   5.305  14.688  1.00 22.94           C  
ATOM    406  CG  ARG    50       3.763   6.662  15.046  1.00 23.31           C  
ATOM    407  CD  ARG    50       4.729   7.128  16.134  1.00 22.13           C  
ATOM    408  NE  ARG    50       4.369   8.344  16.762  1.00 24.32           N  
ATOM    409  CZ  ARG    50       3.791   8.440  17.969  1.00 23.15           C  
ATOM    410  NH1 ARG    50       3.443   7.362  18.655  1.00 26.13           N  
ATOM    411  NH2 ARG    50       3.534   9.622  18.479  1.00 24.48           N  
ATOM    412  N   LYS    51       1.701   3.437  14.570  1.00 21.95           N  
ATOM    413  CA  LYS    51       0.329   2.957  14.793  1.00 22.96           C  
ATOM    414  C   LYS    51      -0.644   4.022  15.207  1.00 23.88           C  
ATOM    415  O   LYS    51      -1.836   3.907  14.899  1.00 27.15           O  
ATOM    416  CB  LYS    51       0.344   1.884  15.880  1.00 24.30           C  
ATOM    417  CG  LYS    51       0.928   0.570  15.440  1.00 26.87           C  
ATOM    418  CD  LYS    51      -0.058  -0.226  14.582  1.00 29.44           C  
ATOM    419  CE  LYS    51      -1.205  -0.890  15.358  1.00 30.13           C  
ATOM    420  NZ  LYS    51      -1.944  -1.954  14.526  1.00 28.19           N  
ATOM    421  N   ASN    52      -0.193   5.045  15.923  1.00 23.72           N  
ATOM    422  CA  ASN    52      -1.125   6.100  16.359  1.00 24.26           C  
ATOM    423  C   ASN    52      -1.538   7.030  15.207  1.00 24.17           C  
ATOM    424  O   ASN    52      -2.323   7.978  15.409  1.00 25.42           O  
ATOM    425  CB  ASN    52      -0.554   6.871  17.558  1.00 25.03           C  
ATOM    426  CG  ASN    52       0.317   8.020  17.160  1.00 24.42           C  
ATOM    427  OD1 ASN    52       0.962   7.983  16.114  1.00 25.79           O  
ATOM    428  ND2 ASN    52       0.299   9.079  17.951  1.00 26.65           N  
ATOM    429  N   GLY    53      -1.017   6.768  14.005  1.00 23.35           N  
ATOM    430  CA  GLY    53      -1.366   7.494  12.812  1.00 23.25           C  
ATOM    431  C   GLY    53      -0.460   8.670  12.473  1.00 22.61           C  
ATOM    432  O   GLY    53      -0.703   9.373  11.499  1.00 24.10           O  
ATOM    433  N   GLU    54       0.538   8.935  13.311  1.00 22.55           N  
ATOM    434  CA  GLU    54       1.405  10.054  13.034  0.50 22.38           C  
ATOM    436  C   GLU    54       2.587   9.612  12.165  1.00 21.93           C  
ATOM    437  O   GLU    54       3.020   8.453  12.207  1.00 20.56           O  
ATOM    438  CB  GLU    54       1.816  10.735  14.347  0.50 22.86           C  
ATOM    440  CG  GLU    54       0.597  11.429  14.982  0.50 23.21           C  
ATOM    442  CD  GLU    54       0.817  12.068  16.340  0.50 25.13           C  
ATOM    444  OE1 GLU    54       1.708  11.658  17.107  0.50 26.68           O  
ATOM    446  OE2 GLU    54       0.037  12.995  16.648  0.50 28.52           O  
ATOM    448  N   THR    55       3.045  10.538  11.335  1.00 21.52           N  
ATOM    449  CA  THR    55       4.233  10.331  10.508  1.00 21.28           C  
ATOM    450  C   THR    55       5.336  11.097  11.229  1.00 21.26           C  
ATOM    451  O   THR    55       5.202  12.280  11.575  1.00 24.07           O  
ATOM    452  CB  THR    55       4.059  10.775   9.067  1.00 22.75           C  
ATOM    453  OG1 THR    55       3.020   9.997   8.430  1.00 23.47           O  
ATOM    454  CG2 THR    55       5.373  10.586   8.283  1.00 23.69           C  
ATOM    455  N   ILE    56       6.388  10.377  11.530  1.00 18.81           N  
ATOM    456  CA  ILE    56       7.560  10.946  12.221  1.00 17.71           C  
ATOM    457  C   ILE    56       8.734  11.049  11.242  1.00 16.62           C  
ATOM    458  O   ILE    56       8.769  10.351  10.240  1.00 15.72           O  
ATOM    459  CB  ILE    56       7.998  10.101  13.463  1.00 16.48           C  
ATOM    460  CG1 ILE    56       8.324   8.643  13.102  1.00 18.49           C  
ATOM    461  CG2 ILE    56       6.891  10.128  14.560  1.00 20.69           C  
ATOM    462  CD1 ILE    56       8.915   7.805  14.252  1.00 18.71           C  
ATOM    463  N   ARG    57       9.641  11.970  11.557  1.00 17.01           N  
ATOM    464  CA  ARG    57      10.857  12.170  10.790  1.00 16.90           C  
ATOM    465  C   ARG    57      12.059  11.961  11.712  1.00 18.52           C  
ATOM    466  O   ARG    57      12.203  12.700  12.712  1.00 18.30           O  
ATOM    467  CB  ARG    57      10.877  13.578  10.175  1.00 18.21           C  
ATOM    468  CG  ARG    57      11.843  13.767   9.044  1.00 22.16           C  
ATOM    469  CD  ARG    57      11.482  15.091   8.275  1.00 22.79           C  
ATOM    470  NE  ARG    57      12.260  15.266   7.076  1.00 30.28           N  
ATOM    471  CZ  ARG    57      13.426  15.885   7.007  1.00 29.98           C  
ATOM    472  NH1 ARG    57      14.012  16.421   8.094  1.00 33.28           N  
ATOM    473  NH2 ARG    57      14.032  15.957   5.829  1.00 32.68           N  
ATOM    474  N   ILE    58      12.936  11.028  11.349  1.00 15.91           N  
ATOM    475  CA  ILE    58      14.128  10.653  12.155  1.00 15.94           C  
ATOM    476  C   ILE    58      15.335  11.194  11.407  1.00 16.27           C  
ATOM    477  O   ILE    58      15.485  10.933  10.213  1.00 14.90           O  
ATOM    478  CB  ILE    58      14.242   9.140  12.377  1.00 16.25           C  
ATOM    479  CG1 ILE    58      12.926   8.623  13.001  1.00 20.10           C  
ATOM    480  CG2 ILE    58      15.455   8.775  13.294  1.00 16.57           C  
ATOM    481  CD1 ILE    58      12.483   7.265  12.468  1.00 23.93           C  
ATOM    482  N   THR    59      16.197  11.910  12.141  1.00 14.89           N  
ATOM    483  CA  THR    59      17.358  12.593  11.568  1.00 14.15           C  
ATOM    484  C   THR    59      18.504  12.573  12.586  1.00 14.35           C  
ATOM    485  O   THR    59      18.307  12.162  13.715  1.00 14.11           O  
ATOM    486  CB  THR    59      17.069  14.081  11.229  1.00 14.81           C  
ATOM    487  OG1 THR    59      16.779  14.818  12.442  1.00 13.82           O  
ATOM    488  CG2 THR    59      15.872  14.174  10.256  1.00 14.18           C  
ATOM    489  N   GLY    60      19.662  13.078  12.202  1.00 13.00           N  
ATOM    490  CA  GLY    60      20.785  13.294  13.142  1.00 14.55           C  
ATOM    491  C   GLY    60      21.076  12.078  14.032  1.00 15.23           C  
ATOM    492  O   GLY    60      21.268  10.956  13.557  1.00 15.55           O  
ATOM    493  N   ASP    61      21.107  12.333  15.323  1.00 14.66           N  
ATOM    494  CA  ASP    61      21.464  11.288  16.310  1.00 15.90           C  
ATOM    495  C   ASP    61      20.544  10.072  16.200  1.00 16.16           C  
ATOM    496  O   ASP    61      20.988   8.929  16.399  1.00 16.88           O  
ATOM    497  CB  ASP    61      21.390  11.842  17.714  1.00 16.78           C  
ATOM    498  CG  ASP    61      22.453  12.862  18.020  1.00 19.80           C  
ATOM    499  OD1 ASP    61      23.417  13.063  17.234  1.00 23.93           O  
ATOM    500  OD2 ASP    61      22.320  13.459  19.136  1.00 27.40           O  
ATOM    501  N   GLY    62      19.269  10.299  15.862  1.00 13.92           N  
ATOM    502  CA  GLY    62      18.296   9.222  15.746  1.00 15.21           C  
ATOM    503  C   GLY    62      18.607   8.184  14.692  1.00 15.36           C  
ATOM    504  O   GLY    62      18.053   7.093  14.739  1.00 16.47           O  
ATOM    505  N   LEU    63      19.447   8.530  13.705  1.00 15.12           N  
ATOM    506  CA  LEU    63      19.813   7.633  12.637  1.00 14.66           C  
ATOM    507  C   LEU    63      21.161   6.929  12.860  1.00 16.62           C  
ATOM    508  O   LEU    63      21.553   6.092  12.067  1.00 17.65           O  
ATOM    509  CB  LEU    63      19.895   8.412  11.307  1.00 14.91           C  
ATOM    510  CG  LEU    63      18.610   9.028  10.816  1.00 14.93           C  
ATOM    511  CD1 LEU    63      18.872   9.730   9.475  1.00 16.30           C  
ATOM    512  CD2 LEU    63      17.484   7.995  10.686  1.00 15.68           C  
ATOM    513  N   LYS    64      21.879   7.292  13.912  1.00 15.36           N  
ATOM    514  CA  LYS    64      23.251   6.825  14.127  0.50 17.84           C  
ATOM    516  C   LYS    64      23.350   5.313  14.202  1.00 17.93           C  
ATOM    517  O   LYS    64      24.201   4.683  13.539  1.00 18.87           O  
ATOM    518  CB  LYS    64      23.803   7.419  15.421  0.50 18.24           C  
ATOM    520  CG  LYS    64      24.118   8.919  15.346  0.50 18.90           C  
ATOM    522  CD  LYS    64      24.682   9.481  16.677  0.50 21.52           C  
ATOM    524  CE  LYS    64      26.140   9.169  16.864  0.50 25.23           C  
ATOM    526  NZ  LYS    64      26.990   9.892  15.880  0.50 27.58           N  
ATOM    528  N   ALA    65      22.489   4.723  15.032  1.00 19.45           N  
ATOM    529  CA  ALA    65      22.573   3.266  15.255  1.00 19.45           C  
ATOM    530  C   ALA    65      22.318   2.519  13.970  1.00 20.13           C  
ATOM    531  O   ALA    65      22.956   1.506  13.706  1.00 21.80           O  
ATOM    532  CB  ALA    65      21.609   2.832  16.300  1.00 20.20           C  
ATOM    533  N   ALA    66      21.444   3.053  13.127  1.00 19.24           N  
ATOM    534  CA  ALA    66      21.020   2.427  11.875  1.00 20.12           C  
ATOM    535  C   ALA    66      21.899   2.739  10.641  1.00 20.14           C  
ATOM    536  O   ALA    66      21.545   2.431   9.497  1.00 19.93           O  
ATOM    537  CB  ALA    66      19.537   2.784  11.608  1.00 19.17           C  
ATOM    538  N   HIS    67      23.032   3.414  10.876  1.00 20.96           N  
ATOM    539  CA  HIS    67      23.874   3.973   9.798  1.00 22.50           C  
ATOM    540  C   HIS    67      24.131   3.057   8.595  1.00 22.69           C  
ATOM    541  O   HIS    67      23.989   3.483   7.437  1.00 23.41           O  
ATOM    542  CB  HIS    67      25.197   4.541  10.372  1.00 23.45           C  
ATOM    543  CG  HIS    67      26.126   3.542  11.028  1.00 26.82           C  
ATOM    544  ND1 HIS    67      25.899   2.978  12.266  1.00 32.13           N  
ATOM    545  CD2 HIS    67      27.348   3.080  10.635  1.00 30.02           C  
ATOM    546  CE1 HIS    67      26.898   2.169  12.582  1.00 33.51           C  
ATOM    547  NE2 HIS    67      27.792   2.218  11.610  1.00 33.86           N  
ATOM    548  N   ARG    68      24.408   1.803   8.879  1.00 23.67           N  
ATOM    549  CA  ARG    68      24.853   0.871   7.842  1.00 25.02           C  
ATOM    550  C   ARG    68      23.705   0.512   6.938  1.00 22.30           C  
ATOM    551  O   ARG    68      23.901   0.185   5.787  1.00 22.56           O  
ATOM    552  CB  ARG    68      25.434  -0.344   8.498  1.00 24.82           C  
ATOM    553  CG  ARG    68      26.707   0.042   9.249  1.00 30.85           C  
ATOM    554  CD  ARG    68      27.251  -1.030  10.152  1.00 31.45           C  
ATOM    555  NE  ARG    68      27.030  -2.400   9.701  1.00 37.79           N  
ATOM    556  CZ  ARG    68      27.584  -2.962   8.632  1.00 38.95           C  
ATOM    557  NH1 ARG    68      28.387  -2.272   7.823  1.00 41.74           N  
ATOM    558  NH2 ARG    68      27.322  -4.240   8.369  1.00 39.77           N  
ATOM    559  N   PHE    69      22.504   0.595   7.497  1.00 19.79           N  
ATOM    560  CA  PHE    69      21.286   0.350   6.733  1.00 19.43           C  
ATOM    561  C   PHE    69      20.734   1.541   5.979  1.00 19.65           C  
ATOM    562  O   PHE    69      19.701   1.423   5.340  1.00 19.12           O  
ATOM    563  CB  PHE    69      20.253  -0.281   7.668  1.00 18.19           C  
ATOM    564  CG  PHE    69      20.676  -1.645   8.125  1.00 18.08           C  
ATOM    565  CD1 PHE    69      21.572  -1.808   9.173  1.00 20.24           C  
ATOM    566  CD2 PHE    69      20.239  -2.769   7.441  1.00 18.30           C  
ATOM    567  CE1 PHE    69      21.988  -3.089   9.532  1.00 18.89           C  
ATOM    568  CE2 PHE    69      20.661  -4.045   7.806  1.00 20.19           C  
ATOM    569  CZ  PHE    69      21.524  -4.186   8.845  1.00 19.83           C  
ATOM    570  N   LEU    70      21.457   2.669   6.005  1.00 20.27           N  
ATOM    571  CA  LEU    70      21.095   3.866   5.245  1.00 22.90           C  
ATOM    572  C   LEU    70      22.208   4.335   4.308  1.00 25.29           C  
ATOM    573  O   LEU    70      22.002   5.257   3.520  1.00 26.73           O  
ATOM    574  CB  LEU    70      20.781   5.012   6.233  1.00 23.31           C  
ATOM    575  CG  LEU    70      19.562   4.755   7.119  1.00 21.31           C  
ATOM    576  CD1 LEU    70      19.661   5.653   8.378  1.00 24.18           C  
ATOM    577  CD2 LEU    70      18.328   5.018   6.305  1.00 20.23           C  
ATOM    578  N   SER    71      23.353   3.653   4.356  1.00 26.45           N  
ATOM    579  CA  SER    71      24.587   4.095   3.688  1.00 27.55           C  
ATOM    580  C   SER    71      24.781   3.559   2.280  1.00 28.74           C  
ATOM    581  O   SER    71      25.758   3.970   1.601  1.00 29.80           O  
ATOM    582  CB  SER    71      25.772   3.565   4.472  1.00 28.48           C  
ATOM    583  OG  SER    71      25.814   2.132   4.350  1.00 29.58           O  
ATOM    584  N   ASN    72      23.919   2.637   1.840  1.00 27.09           N  
ATOM    585  CA  ASN    72      24.109   1.939   0.546  0.50 27.05           C  
ATOM    587  C   ASN    72      25.380   1.091   0.533  1.00 26.48           C  
ATOM    588  O   ASN    72      25.998   0.890  -0.495  1.00 25.99           O  
ATOM    589  CB  ASN    72      24.106   2.893  -0.675  0.50 27.83           C  
ATOM    591  CG  ASN    72      22.703   3.159  -1.234  0.50 28.59           C  
ATOM    593  OD1 ASN    72      21.791   2.300  -1.198  0.50 32.27           O  
ATOM    595  ND2 ASN    72      22.528   4.359  -1.773  0.50 29.54           N  
ATOM    597  N   ASP    73      25.749   0.542   1.686  1.00 25.43           N  
ATOM    598  CA  ASP    73      26.875  -0.421   1.798  1.00 24.74           C  
ATOM    599  C   ASP    73      26.488  -1.639   0.942  1.00 23.75           C  
ATOM    600  O   ASP    73      25.420  -2.208   1.157  1.00 20.54           O  
ATOM    601  CB  ASP    73      27.027  -0.835   3.265  1.00 25.17           C  
ATOM    602  CG  ASP    73      28.020  -1.980   3.495  1.00 26.12           C  
ATOM    603  OD1 ASP    73      28.691  -2.475   2.569  1.00 30.99           O  
ATOM    604  OD2 ASP    73      28.101  -2.401   4.667  1.00 35.81           O  
ATOM    605  N   PRO    74      27.323  -2.022  -0.030  1.00 23.57           N  
ATOM    606  CA  PRO    74      26.905  -3.122  -0.921  1.00 24.30           C  
ATOM    607  C   PRO    74      26.670  -4.459  -0.231  1.00 24.84           C  
ATOM    608  O   PRO    74      25.870  -5.256  -0.709  1.00 26.45           O  
ATOM    609  CB  PRO    74      28.062  -3.203  -1.942  1.00 23.95           C  
ATOM    610  CG  PRO    74      28.658  -1.821  -1.905  1.00 24.58           C  
ATOM    611  CD  PRO    74      28.629  -1.482  -0.450  1.00 24.00           C  
ATOM    612  N   LYS    75      27.332  -4.708   0.891  1.00 25.11           N  
ATOM    613  CA  LYS    75      27.130  -5.948   1.623  1.00 26.59           C  
ATOM    614  C   LYS    75      25.736  -6.045   2.221  1.00 25.93           C  
ATOM    615  O   LYS    75      25.200  -7.135   2.361  1.00 27.46           O  
ATOM    616  CB  LYS    75      28.133  -6.079   2.757  1.00 27.40           C  
ATOM    617  CG  LYS    75      29.571  -6.266   2.291  1.00 30.20           C  
ATOM    618  CD  LYS    75      30.541  -6.071   3.457  1.00 30.42           C  
ATOM    619  CE  LYS    75      31.984  -6.045   2.995  1.00 33.03           C  
ATOM    620  NZ  LYS    75      32.892  -6.078   4.194  1.00 35.70           N  
ATOM    621  N   ILE    76      25.166  -4.913   2.601  1.00 23.73           N  
ATOM    622  CA  ILE    76      23.809  -4.916   3.141  1.00 23.46           C  
ATOM    623  C   ILE    76      22.796  -5.053   1.994  1.00 22.14           C  
ATOM    624  O   ILE    76      21.798  -5.755   2.127  1.00 20.70           O  
ATOM    625  CB  ILE    76      23.584  -3.686   4.022  1.00 24.00           C  
ATOM    626  CG1 ILE    76      24.357  -3.908   5.328  1.00 27.47           C  
ATOM    627  CG2 ILE    76      22.078  -3.476   4.336  1.00 23.08           C  
ATOM    628  CD1 ILE    76      24.772  -2.697   5.964  1.00 30.61           C  
ATOM    629  N   GLY    77      23.054  -4.389   0.872  1.00 21.67           N  
ATOM    630  CA  GLY    77      22.162  -4.511  -0.299  1.00 23.17           C  
ATOM    631  C   GLY    77      20.722  -4.151   0.019  1.00 23.16           C  
ATOM    632  O   GLY    77      20.499  -3.202   0.757  1.00 21.68           O  
ATOM    633  N   GLU    78      19.732  -4.918  -0.484  1.00 23.84           N  
ATOM    634  CA  GLU    78      18.312  -4.590  -0.222  1.00 24.68           C  
ATOM    635  C   GLU    78      17.813  -4.974   1.181  1.00 24.33           C  
ATOM    636  O   GLU    78      16.629  -4.789   1.473  1.00 25.22           O  
ATOM    637  CB  GLU    78      17.364  -5.168  -1.302  1.00 26.64           C  
ATOM    638  CG  GLU    78      17.418  -4.480  -2.675  1.00 29.65           C  
ATOM    639  CD  GLU    78      16.578  -3.175  -2.782  1.00 33.89           C  
ATOM    640  OE1 GLU    78      15.333  -3.239  -3.075  1.00 31.41           O  
ATOM    641  OE2 GLU    78      17.177  -2.079  -2.589  1.00 40.88           O  
ATOM    642  N   LYS    79      18.700  -5.410   2.079  1.00 22.93           N  
ATOM    643  CA  LYS    79      18.361  -5.427   3.493  1.00 23.03           C  
ATOM    644  C   LYS    79      18.274  -4.017   4.070  1.00 20.63           C  
ATOM    645  O   LYS    79      17.859  -3.837   5.206  1.00 20.01           O  
ATOM    646  CB  LYS    79      19.393  -6.225   4.292  1.00 23.69           C  
ATOM    647  CG  LYS    79      19.299  -7.709   3.999  1.00 26.92           C  
ATOM    648  CD  LYS    79      20.379  -8.489   4.748  1.00 28.53           C  
ATOM    649  CE  LYS    79      20.377  -9.959   4.320  1.00 31.81           C  
ATOM    650  NZ  LYS    79      21.343 -10.239   3.217  1.00 34.09           N  
ATOM    651  N   ARG    80      18.704  -3.024   3.298  1.00 21.12           N  
ATOM    652  CA  ARG    80      18.705  -1.639   3.757  1.00 20.87           C  
ATOM    653  C   ARG    80      17.293  -1.138   4.068  1.00 19.89           C  
ATOM    654  O   ARG    80      16.315  -1.671   3.561  1.00 20.87           O  
ATOM    655  CB  ARG    80      19.366  -0.719   2.751  1.00 21.02           C  
ATOM    656  CG  ARG    80      18.562  -0.475   1.551  1.00 22.63           C  
ATOM    657  CD  ARG    80      19.314   0.371   0.508  1.00 25.39           C  
ATOM    658  NE  ARG    80      18.437   0.440  -0.642  1.00 29.73           N  
ATOM    659  CZ  ARG    80      17.483   1.357  -0.864  1.00 32.12           C  
ATOM    660  NH1 ARG    80      17.229   2.386  -0.014  1.00 34.12           N  
ATOM    661  NH2 ARG    80      16.751   1.230  -1.965  1.00 29.96           N  
ATOM    662  N   ILE    81      17.237  -0.105   4.874  1.00 18.86           N  
ATOM    663  CA  ILE    81      15.997   0.629   5.137  1.00 18.98           C  
ATOM    664  C   ILE    81      15.544   1.319   3.844  1.00 19.21           C  
ATOM    665  O   ILE    81      16.338   2.004   3.173  1.00 21.40           O  
ATOM    666  CB  ILE    81      16.197   1.625   6.256  1.00 19.16           C  
ATOM    667  CG1 ILE    81      16.408   0.857   7.574  1.00 18.53           C  
ATOM    668  CG2 ILE    81      15.006   2.601   6.364  1.00 19.73           C  
ATOM    669  CD1 ILE    81      17.055   1.628   8.701  1.00 20.65           C  
ATOM    670  N   ARG    82      14.274   1.128   3.504  1.00 18.22           N  
ATOM    671  CA  ARG    82      13.688   1.557   2.209  0.50 17.65           C  
ATOM    673  C   ARG    82      12.182   1.643   2.425  1.00 17.73           C  
ATOM    674  O   ARG    82      11.660   1.090   3.399  1.00 16.98           O  
ATOM    675  CB  ARG    82      14.008   0.561   1.075  0.50 18.23           C  
ATOM    677  CG  ARG    82      13.015  -0.649   0.888  0.50 16.80           C  
ATOM    679  CD  ARG    82      13.220  -1.403  -0.465  0.50 17.15           C  
ATOM    681  NE  ARG    82      12.162  -2.396  -0.723  0.50 17.23           N  
ATOM    683  CZ  ARG    82      12.274  -3.709  -0.531  0.50 15.45           C  
ATOM    685  NH1 ARG    82      13.430  -4.257  -0.164  0.50 15.77           N  
ATOM    687  NH2 ARG    82      11.228  -4.497  -0.780  0.50 15.69           N  
ATOM    689  N   PRO    83      11.445   2.300   1.510  1.00 17.33           N  
ATOM    690  CA  PRO    83      10.002   2.307   1.757  1.00 16.91           C  
ATOM    691  C   PRO    83       9.361   0.934   1.945  1.00 16.61           C  
ATOM    692  O   PRO    83       9.564   0.019   1.119  1.00 17.77           O  
ATOM    693  CB  PRO    83       9.439   3.036   0.539  1.00 17.58           C  
ATOM    694  CG  PRO    83      10.548   3.837   0.051  1.00 16.41           C  
ATOM    695  CD  PRO    83      11.804   3.087   0.325  1.00 17.89           C  
ATOM    696  N   GLY    84       8.588   0.809   3.007  1.00 14.86           N  
ATOM    697  CA  GLY    84       7.959  -0.434   3.420  1.00 15.67           C  
ATOM    698  C   GLY    84       8.674  -1.152   4.541  1.00 15.52           C  
ATOM    699  O   GLY    84       8.121  -2.067   5.126  1.00 17.23           O  
ATOM    700  N   ALA    85       9.898  -0.737   4.843  1.00 15.34           N  
ATOM    701  CA  ALA    85      10.636  -1.389   5.913  1.00 15.80           C  
ATOM    702  C   ALA    85       9.875  -1.233   7.211  1.00 15.88           C  
ATOM    703  O   ALA    85       9.489  -0.137   7.570  1.00 16.97           O  
ATOM    704  CB  ALA    85      12.004  -0.790   6.026  1.00 15.08           C  
ATOM    705  N   LEU    86       9.720  -2.344   7.924  1.00 18.25           N  
ATOM    706  CA  LEU    86       9.190  -2.359   9.282  1.00 17.93           C  
ATOM    707  C   LEU    86      10.353  -2.152  10.253  1.00 18.43           C  
ATOM    708  O   LEU    86      11.299  -2.955  10.332  1.00 18.46           O  
ATOM    709  CB  LEU    86       8.472  -3.697   9.575  1.00 18.48           C  
ATOM    710  CG  LEU    86       7.905  -3.859  10.985  1.00 20.15           C  
ATOM    711  CD1 LEU    86       6.882  -2.777  11.316  1.00 23.23           C  
ATOM    712  CD2 LEU    86       7.327  -5.271  11.129  1.00 20.48           C  
ATOM    713  N   ILE    87      10.281  -1.045  10.979  1.00 17.40           N  
ATOM    714  CA  ILE    87      11.304  -0.664  11.971  1.00 17.79           C  
ATOM    715  C   ILE    87      10.691  -0.466  13.315  1.00 16.97           C  
ATOM    716  O   ILE    87       9.466  -0.472  13.474  1.00 18.03           O  
ATOM    717  CB  ILE    87      12.079   0.611  11.522  1.00 16.69           C  
ATOM    718  CG1 ILE    87      11.141   1.799  11.307  1.00 17.19           C  
ATOM    719  CG2 ILE    87      12.872   0.270  10.190  1.00 18.98           C  
ATOM    720  CD1 ILE    87      11.823   3.133  11.188  1.00 18.86           C  
ATOM    721  N   ARG    88      11.546  -0.259  14.292  1.00 16.37           N  
ATOM    722  CA  ARG    88      11.104   0.101  15.626  1.00 15.89           C  
ATOM    723  C   ARG    88      11.725   1.441  15.956  1.00 16.06           C  
ATOM    724  O   ARG    88      12.890   1.704  15.645  1.00 15.92           O  
ATOM    725  CB  ARG    88      11.551  -0.950  16.656  1.00 16.91           C  
ATOM    726  CG  ARG    88      11.052  -2.363  16.313  1.00 19.48           C  
ATOM    727  CD  ARG    88       9.563  -2.596  16.597  1.00 22.43           C  
ATOM    728  NE  ARG    88       9.195  -3.877  16.014  1.00 25.15           N  
ATOM    729  CZ  ARG    88       8.005  -4.465  16.140  1.00 24.03           C  
ATOM    730  NH1 ARG    88       7.064  -3.921  16.884  1.00 22.87           N  
ATOM    731  NH2 ARG    88       7.794  -5.626  15.506  1.00 26.11           N  
ATOM    732  N   VAL    89      10.947   2.244  16.646  1.00 16.11           N  
ATOM    733  CA  VAL    89      11.362   3.602  17.021  1.00 15.28           C  
ATOM    734  C   VAL    89      11.067   3.919  18.472  1.00 16.66           C  
ATOM    735  O   VAL    89      10.122   3.363  19.062  1.00 17.18           O  
ATOM    736  CB  VAL    89      10.672   4.637  16.105  1.00 15.17           C  
ATOM    737  CG1 VAL    89      11.089   4.396  14.673  1.00 16.98           C  
ATOM    738  CG2 VAL    89       9.155   4.521  16.206  1.00 17.06           C  
ATOM    739  N   LYS    90      11.848   4.847  19.017  1.00 16.96           N  
ATOM    740  CA  LYS    90      11.616   5.305  20.380  1.00 17.78           C  
ATOM    741  C   LYS    90      11.880   6.822  20.433  1.00 18.76           C  
ATOM    742  O   LYS    90      12.876   7.285  19.874  1.00 18.51           O  
ATOM    743  CB  LYS    90      12.577   4.566  21.301  1.00 18.95           C  
ATOM    744  CG  LYS    90      12.395   4.805  22.797  1.00 19.52           C  
ATOM    745  CD  LYS    90      13.376   3.969  23.591  1.00 22.77           C  
ATOM    746  CE  LYS    90      13.408   4.296  25.059  1.00 29.12           C  
ATOM    747  NZ  LYS    90      12.162   4.691  25.679  1.00 35.66           N  
ATOM    748  N   LYS    91      11.107   7.510  21.260  1.00 18.93           N  
ATOM    749  CA  LYS    91      11.228   8.949  21.424  1.00 19.03           C  
ATOM    750  C   LYS    91      12.187   9.212  22.587  1.00 19.84           C  
ATOM    751  O   LYS    91      11.983   8.683  23.701  1.00 20.14           O  
ATOM    752  CB  LYS    91       9.854   9.552  21.671  1.00 19.81           C  
ATOM    753  CG  LYS    91       9.830  11.072  21.577  1.00 20.93           C  
ATOM    754  CD  LYS    91       8.439  11.593  21.854  1.00 23.85           C  
ATOM    755  CE  LYS    91       8.249  13.016  21.413  1.00 30.64           C  
ATOM    756  NZ  LYS    91       6.944  13.499  21.917  1.00 34.58           N  
ATOM    757  N   THR    92      13.230   9.996  22.360  1.00 19.44           N  
ATOM    758  CA  THR    92      14.153  10.312  23.424  1.00 19.60           C  
ATOM    759  C   THR    92      13.562  11.349  24.389  1.00 18.84           C  
ATOM    760  O   THR    92      12.549  11.999  24.103  1.00 18.25           O  
ATOM    761  CB  THR    92      15.444  10.856  22.895  1.00 19.73           C  
ATOM    762  OG1 THR    92      15.176  12.183  22.388  1.00 21.01           O  
ATOM    763  CG2 THR    92      16.053   9.941  21.791  1.00 19.35           C  
ATOM    764  N   GLU    93      14.205  11.539  25.548  0.50 20.13           N  
ATOM    766  CA  GLU    93      13.705  12.522  26.511  0.50 20.76           C  
ATOM    768  C   GLU    93      13.826  13.956  25.987  0.50 19.67           C  
ATOM    770  O   GLU    93      13.197  14.874  26.521  0.50 19.80           O  
ATOM    772  CB  GLU    93      14.469  12.430  27.835  0.50 21.32           C  
ATOM    774  CG  GLU    93      14.239  11.166  28.623  0.50 23.98           C  
ATOM    776  CD  GLU    93      15.125  11.081  29.854  0.50 24.53           C  
ATOM    778  OE1 GLU    93      15.518   9.957  30.231  0.50 30.98           O  
ATOM    780  OE2 GLU    93      15.430  12.143  30.451  0.50 29.16           O  
ATOM    782  N   LYS    94      14.686  14.166  25.000  1.00 19.01           N  
ATOM    783  CA  LYS    94      14.783  15.473  24.385  1.00 18.39           C  
ATOM    784  C   LYS    94      13.725  15.668  23.293  1.00 16.81           C  
ATOM    785  O   LYS    94      13.533  16.802  22.866  1.00 18.00           O  
ATOM    786  CB  LYS    94      16.183  15.730  23.832  1.00 19.18           C  
ATOM    787  CG  LYS    94      17.248  15.787  24.880  1.00 21.72           C  
ATOM    788  CD  LYS    94      18.600  15.805  24.281  1.00 23.57           C  
ATOM    789  CE  LYS    94      19.662  15.916  25.368  1.00 26.08           C  
ATOM    790  NZ  LYS    94      21.041  15.663  24.797  1.00 29.86           N  
ATOM    791  N   GLY    95      13.022  14.605  22.914  1.00 16.22           N  
ATOM    792  CA  GLY    95      11.841  14.750  22.040  1.00 16.18           C  
ATOM    793  C   GLY    95      11.987  14.255  20.618  1.00 16.84           C  
ATOM    794  O   GLY    95      11.006  14.237  19.886  1.00 17.83           O  
ATOM    795  N   SER    96      13.182  13.851  20.222  1.00 16.29           N  
ATOM    796  CA  SER    96      13.410  13.388  18.856  1.00 15.32           C  
ATOM    797  C   SER    96      13.264  11.874  18.837  1.00 16.22           C  
ATOM    798  O   SER    96      13.576  11.174  19.825  1.00 15.94           O  
ATOM    799  CB  SER    96      14.825  13.781  18.368  1.00 15.41           C  
ATOM    800  OG  SER    96      15.042  15.172  18.223  1.00 17.04           O  
ATOM    801  N   TRP    97      12.799  11.328  17.709  1.00 15.27           N  
ATOM    802  CA  TRP    97      12.673   9.906  17.534  1.00 15.15           C  
ATOM    803  C   TRP    97      13.984   9.306  17.090  1.00 15.23           C  
ATOM    804  O   TRP    97      14.751   9.940  16.370  1.00 15.34           O  
ATOM    805  CB  TRP    97      11.574   9.586  16.500  1.00 16.75           C  
ATOM    806  CG  TRP    97      10.188   9.910  17.049  1.00 17.02           C  
ATOM    807  CD1 TRP    97       9.539  11.094  16.962  1.00 19.56           C  
ATOM    808  CD2 TRP    97       9.317   9.038  17.788  1.00 17.19           C  
ATOM    809  NE1 TRP    97       8.330  11.038  17.621  1.00 18.92           N  
ATOM    810  CE2 TRP    97       8.159   9.773  18.106  1.00 19.29           C  
ATOM    811  CE3 TRP    97       9.412   7.721  18.226  1.00 18.37           C  
ATOM    812  CZ2 TRP    97       7.109   9.234  18.854  1.00 20.16           C  
ATOM    813  CZ3 TRP    97       8.337   7.178  18.931  1.00 17.75           C  
ATOM    814  CH2 TRP    97       7.222   7.945  19.254  1.00 19.63           C  
ATOM    815  N   GLN    98      14.221   8.054  17.494  1.00 15.53           N  
ATOM    816  CA  GLN    98      15.374   7.289  17.078  0.50 15.84           C  
ATOM    818  C   GLN    98      14.962   5.908  16.599  1.00 15.82           C  
ATOM    819  O   GLN    98      13.994   5.322  17.111  1.00 16.55           O  
ATOM    820  CB  GLN    98      16.352   7.171  18.259  0.50 16.46           C  
ATOM    822  CG  GLN    98      15.755   6.389  19.416  0.50 17.45           C  
ATOM    824  CD  GLN    98      16.493   6.471  20.731  0.50 18.58           C  
ATOM    826  OE1 GLN    98      15.872   6.257  21.781  0.50 19.21           O  
ATOM    828  NE2 GLN    98      17.791   6.726  20.694  0.50 20.26           N  
ATOM    830  N   ILE    99      15.703   5.374  15.626  1.00 15.21           N  
ATOM    831  CA  ILE    99      15.526   3.998  15.150  1.00 15.51           C  
ATOM    832  C   ILE    99      16.314   3.078  16.081  1.00 16.61           C  
ATOM    833  O   ILE    99      17.548   3.215  16.279  1.00 16.58           O  
ATOM    834  CB  ILE    99      15.998   3.819  13.727  1.00 16.25           C  
ATOM    835  CG1 ILE    99      15.225   4.730  12.764  1.00 16.91           C  
ATOM    836  CG2 ILE    99      15.907   2.332  13.370  1.00 18.24           C  
ATOM    837  CD1 ILE    99      15.645   4.639  11.292  1.00 16.52           C  
ATOM    838  N   VAL   100      15.562   2.173  16.680  1.00 17.39           N  
ATOM    839  CA  VAL   100      16.095   1.202  17.630  1.00 18.63           C  
ATOM    840  C   VAL   100      15.672  -0.230  17.234  1.00 19.15           C  
ATOM    841  O   VAL   100      15.194  -0.468  16.147  1.00 17.97           O  
ATOM    842  CB  VAL   100      15.581   1.541  19.043  1.00 18.73           C  
ATOM    843  CG1 VAL   100      16.085   2.916  19.465  1.00 18.33           C  
ATOM    844  CG2 VAL   100      14.053   1.456  19.153  1.00 21.54           C  
ATOM    845  N   GLN   101      15.841  -1.182  18.141  1.00 21.54           N  
ATOM    846  CA  GLN   101      15.350  -2.538  17.848  1.00 22.47           C  
ATOM    847  C   GLN   101      14.877  -3.189  19.126  1.00 23.43           C  
ATOM    848  O   GLN   101      15.243  -2.736  20.207  1.00 23.82           O  
ATOM    849  CB  GLN   101      16.395  -3.345  17.139  1.00 23.76           C  
ATOM    850  CG  GLN   101      17.643  -3.604  17.930  1.00 23.42           C  
ATOM    851  CD  GLN   101      18.756  -4.193  17.109  1.00 24.69           C  
ATOM    852  OE1 GLN   101      18.587  -4.586  15.951  1.00 25.77           O  
ATOM    853  NE2 GLN   101      19.941  -4.248  17.713  1.00 30.47           N  
ATOM    854  N   LEU   102      14.003  -4.177  19.000  1.00 25.80           N  
ATOM    855  CA  LEU   102      13.433  -4.833  20.175  1.00 29.29           C  
ATOM    856  C   LEU   102      14.548  -5.593  20.875  1.00 30.90           C  
ATOM    857  O   LEU   102      15.441  -6.127  20.212  1.00 30.78           O  
ATOM    858  CB  LEU   102      12.266  -5.755  19.791  1.00 29.31           C  
ATOM    859  CG  LEU   102      10.972  -5.020  19.413  1.00 30.58           C  
ATOM    860  CD1 LEU   102       9.988  -5.946  18.738  1.00 31.16           C  
ATOM    861  CD2 LEU   102      10.360  -4.260  20.587  1.00 31.70           C  
ATOM    862  N   PRO   103      14.502  -5.653  22.228  1.00 32.79           N  
ATOM    863  CA  PRO   103      15.587  -6.344  22.947  1.00 33.77           C  
ATOM    864  C   PRO   103      15.589  -7.835  22.604  1.00 35.69           C  
ATOM    865  O   PRO   103      14.522  -8.422  22.400  1.00 36.77           O  
ATOM    866  CB  PRO   103      15.235  -6.128  24.423  1.00 34.74           C  
ATOM    867  CG  PRO   103      13.758  -5.776  24.444  1.00 34.13           C  
ATOM    868  CD  PRO   103      13.465  -5.114  23.135  1.00 33.44           C  
ATOM    869  OXT PRO   103      16.642  -8.473  22.459  1.00 37.09           O  
END
