
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   94 (  704),  selected   94 , name 3bey_D
# Molecule2: number of CA atoms   98 (  717),  selected   98 , name T0408.pdb
# PARAMETERS: 3bey_D.T0408.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     2_D      F       7          6.053
LGA    T     3_D      G       8           #
LGA    G     4_D      E       9          3.538
LGA    A     5_D      G      10          1.378
LGA    -       -      M      11           -
LGA    D     6_D      K      12          0.789
LGA    R     7_D      V      13          1.377
LGA    F     8_D      V      14          1.870
LGA    L     9_D      K      15          1.667
LGA    E    10_D      E      16          1.177
LGA    E    11_D      K      17          1.021
LGA    L    12_D      Y      18          1.220
LGA    P    13_D      P      19          1.329
LGA    E    14_D      D      20          1.627
LGA    V    15_D      L      21          1.491
LGA    A    16_D      Y      22          2.017
LGA    E    17_D      D      23          1.517
LGA    S    18_D      I      24          0.713
LGA    F    19_D      I      25          1.177
LGA    K    20_D      V      26          1.420
LGA    N    21_D      K      27          0.995
LGA    F    22_D      L      28          0.647
LGA    R    23_D      N      29          1.009
LGA    E    24_D      D      30          1.019
LGA    A    25_D      T      31          0.514
LGA    V    26_D      V      32          0.518
LGA    R    27_D      F      33          1.289
LGA    S    28_D      T      34          1.945
LGA    E    29_D      G      35          1.906
LGA    G    30_D      K      36          2.816
LGA    K    31_D      T      37          2.132
LGA    L    32_D      L      38          0.633
LGA    T    33_D      D      39          1.297
LGA    E    34_D      Y      40          1.968
LGA    R    35_D      K      41          2.104
LGA    E    36_D      T      42          0.824
LGA    K    37_D      Q      43          0.936
LGA    L    38_D      K      44          1.764
LGA    L    39_D      L      45          0.979
LGA    I    40_D      I      46          0.735
LGA    S    41_D      A      47          1.325
LGA    V    42_D      I      48          0.979
LGA    A    43_D      G      49          1.029
LGA    C    44_D      I      50          1.057
LGA    S    45_D      V      51          1.233
LGA    V    46_D      A      52          0.308
LGA    A    47_D      S      53          0.868
LGA    V    48_D      R      54          2.262
LGA    R    49_D      C      55          2.367
LGA    C    50_D      D      56          2.051
LGA    D    51_D      E      57          1.956
LGA    A    52_D      V      58          2.315
LGA    C    53_D      A      59          2.225
LGA    T    54_D      I      60          1.773
LGA    R    55_D      E      61          1.864
LGA    R    56_D      K      62          2.021
LGA    H    57_D      Q      63          1.969
LGA    A    58_D      M      64          1.302
LGA    E    59_D      K      65          2.166
LGA    E    60_D      S      66          2.830
LGA    A    61_D      A      67          2.190
LGA    L    62_D      M      68          1.549
LGA    E    63_D      K      69          2.731
LGA    -       -      E      70           -
LGA    A    64_D      L      71          1.871
LGA    G    65_D      G      72          2.418
LGA    I    66_D      I      73          1.974
LGA    T    67_D      T      74          1.383
LGA    E    68_D      K      75          0.418
LGA    G    69_D      E      76          1.272
LGA    E    70_D      E      77          1.456
LGA    L    71_D      I      78          0.203
LGA    A    72_D      A      79          1.321
LGA    E    73_D      D      80          1.709
LGA    A    74_D      V      81          0.442
LGA    A    75_D      L      82          1.823
LGA    A    76_D      R      83          2.347
LGA    V    77_D      V      84          0.927
LGA    A    78_D      V      85          1.604
LGA    A    79_D      L      86          2.492
LGA    L    80_D      L      87          1.557
LGA    I    81_D      T      88          0.799
LGA    R    82_D      S      89          1.255
LGA    A    83_D      G      90          3.499
LGA    G    84_D      M      91           -
LGA    S    85_D      P      92           -
LGA    A    86_D      A      93           -
LGA    X    87_D      F      94           -
LGA    N    88_D      T      95           -
LGA    T    89_D      K      96           -
LGA    A    90_D      A      97           -
LGA    S    91_D      M      98           -
LGA    A    92_D      K      99           -
LGA    I    93_D      I     100           -
LGA    F    94_D      L     101           -
LGA    R    95_D      E     102           -
LGA    -       -      K     103           -
LGA    -       -      L     104           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   94   98    5.0     81    1.80    17.28     75.376     4.266

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.472045 * X  +  -0.639915 * Y  +  -0.606368 * Z  +   6.849589
  Y_new =   0.410973 * X  +  -0.448774 * Y  +   0.793538 * Z  +  42.394451
  Z_new =  -0.779919 * X  +  -0.623787 * Y  +   0.051146 * Z  +  33.704922 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.488986    1.652606  [ DEG:   -85.3126     94.6874 ]
  Theta =   0.894537    2.247056  [ DEG:    51.2532    128.7468 ]
  Phi   =   0.716345   -2.425247  [ DEG:    41.0436   -138.9564 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3bey_D                                        
REMARK     2: T0408.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3bey_D.T0408.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   94   98   5.0   81   1.80   17.28  75.376
REMARK  ---------------------------------------------------------- 
MOLECULE 3bey_D
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   20-NOV-07   3BEY              
TITLE     CRYSTAL STRUCTURE OF THE PROTEIN O27018 FROM                          
TITLE    2 METHANOBACTERIUM THERMOAUTOTROPHICUM. NORTHEAST STRUCTURAL           
TITLE    3 GENOMICS CONSORTIUM TARGET TT217                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CONSERVED PROTEIN O27018;                                  
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: METHANOTHERMOBACTER                             
SOURCE   3 THERMAUTOTROPHICUS STR. DELTA H;                                     
SOURCE   4 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   5 STRAIN: DELTA H;                                                     
SOURCE   6 GENE: MTH935;                                                        
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI                                  
KEYWDS    O27018, X-RAY, TT217, MT935, NESG, STRUCTURAL GENOMICS, PSI-          
KEYWDS   2 2, PROTEIN STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL                
KEYWDS   3 GENOMICS CONSORTIUM, STRUCTURAL GENOMICS, UNKNOWN FUNCTION           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.P.KUZIN,J.GU,X.XU,H.NEELY,F.FOROUHAR,L.OWENS,L.MAO,R.XIAO,          
AUTHOR   2 J.LIU,M.C.BARAN,T.B.ACTON,ROST B.,G.T.MONTELIONE,L.TONG,             
AUTHOR   3 NORTHEAST STRUCTURAL GENOMICS CONSORTIUM (NESG)                      
REVDAT   1   18-DEC-07 3BEY    0                                                
JRNL        AUTH   A.P.KUZIN,J.GU,X.XU,H.NEELY,F.FOROUHAR,L.OWENS,              
JRNL        AUTH 2 L.MAO,R.XIAO,J.LIU,M.C.BARAN,T.B.ACTON,B.ROST,               
JRNL        AUTH 3 G.T.MONTELIONE,L.TONG                                        
JRNL        TITL   CRYSTAL STRUCTURE OF THE PROTEIN O27018 FROM                 
JRNL        TITL 2 METHANOBACTERIUM THERMOAUTOTROPHICUM.                        
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.40 ANGSTROMS.                                          
DBREF  3BEY A    1    96  UNP    O27018   O27018_METTH     1     96             
DBREF  3BEY B    1    96  UNP    O27018   O27018_METTH     1     96             
DBREF  3BEY C    1    96  UNP    O27018   O27018_METTH     1     96             
DBREF  3BEY D    1    96  UNP    O27018   O27018_METTH     1     96             
DBREF  3BEY E    1    96  UNP    O27018   O27018_METTH     1     96             
DBREF  3BEY F    1    96  UNP    O27018   O27018_METTH     1     96             
SEQRES   1 A   96  MSE LYS THR GLY ALA ASP ARG PHE LEU GLU GLU LEU PRO          
SEQRES   2 A   96  GLU VAL ALA GLU SER PHE LYS ASN PHE ARG GLU ALA VAL          
SEQRES   3 A   96  ARG SER GLU GLY LYS LEU THR GLU ARG GLU LYS LEU LEU          
SEQRES   4 A   96  ILE SER VAL ALA CYS SER VAL ALA VAL ARG CYS ASP ALA          
SEQRES   5 A   96  CYS THR ARG ARG HIS ALA GLU GLU ALA LEU GLU ALA GLY          
SEQRES   6 A   96  ILE THR GLU GLY GLU LEU ALA GLU ALA ALA ALA VAL ALA          
SEQRES   7 A   96  ALA LEU ILE ARG ALA GLY SER ALA MSE ASN THR ALA SER          
SEQRES   8 A   96  ALA ILE PHE ARG ASP                                          
SEQRES   1 B   96  MSE LYS THR GLY ALA ASP ARG PHE LEU GLU GLU LEU PRO          
SEQRES   2 B   96  GLU VAL ALA GLU SER PHE LYS ASN PHE ARG GLU ALA VAL          
SEQRES   3 B   96  ARG SER GLU GLY LYS LEU THR GLU ARG GLU LYS LEU LEU          
SEQRES   4 B   96  ILE SER VAL ALA CYS SER VAL ALA VAL ARG CYS ASP ALA          
SEQRES   5 B   96  CYS THR ARG ARG HIS ALA GLU GLU ALA LEU GLU ALA GLY          
SEQRES   6 B   96  ILE THR GLU GLY GLU LEU ALA GLU ALA ALA ALA VAL ALA          
SEQRES   7 B   96  ALA LEU ILE ARG ALA GLY SER ALA MSE ASN THR ALA SER          
SEQRES   8 B   96  ALA ILE PHE ARG ASP                                          
SEQRES   1 C   96  MSE LYS THR GLY ALA ASP ARG PHE LEU GLU GLU LEU PRO          
SEQRES   2 C   96  GLU VAL ALA GLU SER PHE LYS ASN PHE ARG GLU ALA VAL          
SEQRES   3 C   96  ARG SER GLU GLY LYS LEU THR GLU ARG GLU LYS LEU LEU          
SEQRES   4 C   96  ILE SER VAL ALA CYS SER VAL ALA VAL ARG CYS ASP ALA          
SEQRES   5 C   96  CYS THR ARG ARG HIS ALA GLU GLU ALA LEU GLU ALA GLY          
SEQRES   6 C   96  ILE THR GLU GLY GLU LEU ALA GLU ALA ALA ALA VAL ALA          
SEQRES   7 C   96  ALA LEU ILE ARG ALA GLY SER ALA MSE ASN THR ALA SER          
SEQRES   8 C   96  ALA ILE PHE ARG ASP                                          
SEQRES   1 D   96  MSE LYS THR GLY ALA ASP ARG PHE LEU GLU GLU LEU PRO          
SEQRES   2 D   96  GLU VAL ALA GLU SER PHE LYS ASN PHE ARG GLU ALA VAL          
SEQRES   3 D   96  ARG SER GLU GLY LYS LEU THR GLU ARG GLU LYS LEU LEU          
SEQRES   4 D   96  ILE SER VAL ALA CYS SER VAL ALA VAL ARG CYS ASP ALA          
SEQRES   5 D   96  CYS THR ARG ARG HIS ALA GLU GLU ALA LEU GLU ALA GLY          
SEQRES   6 D   96  ILE THR GLU GLY GLU LEU ALA GLU ALA ALA ALA VAL ALA          
SEQRES   7 D   96  ALA LEU ILE ARG ALA GLY SER ALA MSE ASN THR ALA SER          
SEQRES   8 D   96  ALA ILE PHE ARG ASP                                          
SEQRES   1 E   96  MSE LYS THR GLY ALA ASP ARG PHE LEU GLU GLU LEU PRO          
SEQRES   2 E   96  GLU VAL ALA GLU SER PHE LYS ASN PHE ARG GLU ALA VAL          
SEQRES   3 E   96  ARG SER GLU GLY LYS LEU THR GLU ARG GLU LYS LEU LEU          
SEQRES   4 E   96  ILE SER VAL ALA CYS SER VAL ALA VAL ARG CYS ASP ALA          
SEQRES   5 E   96  CYS THR ARG ARG HIS ALA GLU GLU ALA LEU GLU ALA GLY          
SEQRES   6 E   96  ILE THR GLU GLY GLU LEU ALA GLU ALA ALA ALA VAL ALA          
SEQRES   7 E   96  ALA LEU ILE ARG ALA GLY SER ALA MSE ASN THR ALA SER          
SEQRES   8 E   96  ALA ILE PHE ARG ASP                                          
SEQRES   1 F   96  MSE LYS THR GLY ALA ASP ARG PHE LEU GLU GLU LEU PRO          
SEQRES   2 F   96  GLU VAL ALA GLU SER PHE LYS ASN PHE ARG GLU ALA VAL          
SEQRES   3 F   96  ARG SER GLU GLY LYS LEU THR GLU ARG GLU LYS LEU LEU          
SEQRES   4 F   96  ILE SER VAL ALA CYS SER VAL ALA VAL ARG CYS ASP ALA          
SEQRES   5 F   96  CYS THR ARG ARG HIS ALA GLU GLU ALA LEU GLU ALA GLY          
SEQRES   6 F   96  ILE THR GLU GLY GLU LEU ALA GLU ALA ALA ALA VAL ALA          
SEQRES   7 F   96  ALA LEU ILE ARG ALA GLY SER ALA MSE ASN THR ALA SER          
SEQRES   8 F   96  ALA ILE PHE ARG ASP                                          
HET    MSE  A  87       8                                                       
HET    MSE  B  87       8                                                       
HET    MSE  C  87       8                                                       
HET    MSE  D  87       8                                                       
HET    MSE  E  87       8                                                       
HET    MSE  F  87       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   7  HOH   *14(H2 O)                                                     
CRYST1   59.528   71.985   61.418  90.00  99.08  90.00 P 1 21 1     12          
ATOM   2031  N   LYS D   2      14.608  77.794  39.485  1.00 83.08           N  
ATOM   2032  CA  LYS D   2      14.748  76.829  38.357  1.00 83.27           C  
ATOM   2033  C   LYS D   2      15.830  77.298  37.384  1.00 83.24           C  
ATOM   2034  O   LYS D   2      15.540  77.993  36.415  1.00 83.58           O  
ATOM   2035  CB  LYS D   2      13.412  76.697  37.616  1.00 83.30           C  
ATOM   2036  CG  LYS D   2      12.250  76.224  38.476  1.00 82.86           C  
ATOM   2037  CD  LYS D   2      10.946  76.266  37.695  1.00 83.46           C  
ATOM   2038  CE  LYS D   2       9.761  75.821  38.543  1.00 83.43           C  
ATOM   2039  NZ  LYS D   2       9.867  74.396  38.962  1.00 83.00           N  
ATOM   2040  N   THR D   3      17.077  76.916  37.643  1.00 83.32           N  
ATOM   2041  CA  THR D   3      18.180  77.316  36.775  1.00 83.44           C  
ATOM   2042  C   THR D   3      17.977  76.816  35.345  1.00 83.11           C  
ATOM   2043  O   THR D   3      18.496  77.398  34.391  1.00 82.37           O  
ATOM   2044  CB  THR D   3      19.525  76.777  37.291  1.00 84.11           C  
ATOM   2045  OG1 THR D   3      20.584  77.247  36.445  1.00 84.35           O  
ATOM   2046  CG2 THR D   3      19.523  75.250  37.294  1.00 84.03           C  
ATOM   2047  N   GLY D   4      17.220  75.732  35.203  1.00 83.03           N  
ATOM   2048  CA  GLY D   4      16.972  75.175  33.888  1.00 82.49           C  
ATOM   2049  C   GLY D   4      15.756  75.767  33.204  1.00 82.25           C  
ATOM   2050  O   GLY D   4      15.736  75.906  31.981  1.00 82.23           O  
ATOM   2051  N   ALA D   5      14.745  76.124  33.991  1.00 82.05           N  
ATOM   2052  CA  ALA D   5      13.514  76.696  33.450  1.00 82.10           C  
ATOM   2053  C   ALA D   5      13.590  78.213  33.284  1.00 81.98           C  
ATOM   2054  O   ALA D   5      12.889  78.791  32.454  1.00 82.47           O  
ATOM   2055  CB  ALA D   5      12.336  76.330  34.346  1.00 82.55           C  
ATOM   2056  N   ASP D   6      14.435  78.857  34.080  1.00 81.44           N  
ATOM   2057  CA  ASP D   6      14.591  80.299  33.992  1.00 80.69           C  
ATOM   2058  C   ASP D   6      15.633  80.619  32.930  1.00 79.99           C  
ATOM   2059  O   ASP D   6      15.744  81.755  32.471  1.00 79.87           O  
ATOM   2060  CB  ASP D   6      14.996  80.874  35.352  1.00 81.05           C  
ATOM   2061  CG  ASP D   6      13.870  80.792  36.372  1.00 81.61           C  
ATOM   2062  OD1 ASP D   6      12.771  81.316  36.087  1.00 82.20           O  
ATOM   2063  OD2 ASP D   6      14.080  80.205  37.456  1.00 81.65           O  
ATOM   2064  N   ARG D   7      16.393  79.601  32.542  1.00 78.93           N  
ATOM   2065  CA  ARG D   7      17.407  79.753  31.508  1.00 78.08           C  
ATOM   2066  C   ARG D   7      16.639  79.789  30.188  1.00 77.21           C  
ATOM   2067  O   ARG D   7      17.161  80.186  29.144  1.00 76.43           O  
ATOM   2068  CB  ARG D   7      18.368  78.565  31.545  1.00 79.20           C  
ATOM   2069  CG  ARG D   7      19.587  78.712  30.656  1.00 80.25           C  
ATOM   2070  CD  ARG D   7      20.646  77.681  31.023  1.00 81.73           C  
ATOM   2071  NE  ARG D   7      21.080  77.817  32.415  1.00 83.02           N  
ATOM   2072  CZ  ARG D   7      22.055  77.103  32.974  1.00 83.44           C  
ATOM   2073  NH1 ARG D   7      22.712  76.195  32.263  1.00 83.24           N  
ATOM   2074  NH2 ARG D   7      22.375  77.298  34.247  1.00 83.72           N  
ATOM   2075  N   PHE D   8      15.380  79.370  30.268  1.00 76.01           N  
ATOM   2076  CA  PHE D   8      14.466  79.352  29.135  1.00 74.35           C  
ATOM   2077  C   PHE D   8      13.891  80.761  29.035  1.00 73.12           C  
ATOM   2078  O   PHE D   8      13.603  81.261  27.945  1.00 73.12           O  
ATOM   2079  CB  PHE D   8      13.358  78.327  29.403  1.00 74.01           C  
ATOM   2080  CG  PHE D   8      12.366  78.179  28.284  1.00 73.67           C  
ATOM   2081  CD1 PHE D   8      11.339  79.104  28.113  1.00 73.53           C  
ATOM   2082  CD2 PHE D   8      12.440  77.092  27.418  1.00 73.09           C  
ATOM   2083  CE1 PHE D   8      10.398  78.943  27.093  1.00 73.10           C  
ATOM   2084  CE2 PHE D   8      11.504  76.926  26.400  1.00 73.06           C  
ATOM   2085  CZ  PHE D   8      10.484  77.852  26.239  1.00 72.92           C  
ATOM   2086  N   LEU D   9      13.723  81.392  30.194  1.00 71.76           N  
ATOM   2087  CA  LEU D   9      13.214  82.757  30.269  1.00 70.36           C  
ATOM   2088  C   LEU D   9      14.263  83.649  29.614  1.00 69.73           C  
ATOM   2089  O   LEU D   9      13.938  84.659  28.991  1.00 69.21           O  
ATOM   2090  CB  LEU D   9      13.019  83.160  31.735  1.00 69.36           C  
ATOM   2091  CG  LEU D   9      12.551  84.582  32.063  1.00 68.46           C  
ATOM   2092  CD1 LEU D   9      11.170  84.823  31.490  1.00 68.90           C  
ATOM   2093  CD2 LEU D   9      12.528  84.773  33.569  1.00 68.63           C  
ATOM   2094  N   GLU D  10      15.524  83.247  29.754  1.00 69.37           N  
ATOM   2095  CA  GLU D  10      16.651  83.983  29.188  1.00 69.63           C  
ATOM   2096  C   GLU D  10      16.696  83.874  27.665  1.00 68.30           C  
ATOM   2097  O   GLU D  10      17.138  84.798  26.988  1.00 67.84           O  
ATOM   2098  CB  GLU D  10      17.976  83.447  29.751  1.00 71.56           C  
ATOM   2099  CG  GLU D  10      18.122  83.491  31.270  1.00 74.05           C  
ATOM   2100  CD  GLU D  10      18.192  84.903  31.817  1.00 76.21           C  
ATOM   2101  OE1 GLU D  10      19.087  85.665  31.394  1.00 77.34           O  
ATOM   2102  OE2 GLU D  10      17.353  85.250  32.676  1.00 77.92           O  
ATOM   2103  N   GLU D  11      16.239  82.740  27.136  1.00 67.21           N  
ATOM   2104  CA  GLU D  11      16.256  82.488  25.697  1.00 65.73           C  
ATOM   2105  C   GLU D  11      15.051  83.017  24.933  1.00 65.19           C  
ATOM   2106  O   GLU D  11      15.187  83.468  23.797  1.00 65.25           O  
ATOM   2107  CB  GLU D  11      16.385  80.988  25.424  1.00 66.11           C  
ATOM   2108  CG  GLU D  11      17.600  80.325  26.051  1.00 65.29           C  
ATOM   2109  CD  GLU D  11      18.902  80.936  25.586  1.00 65.45           C  
ATOM   2110  OE1 GLU D  11      19.114  81.026  24.358  1.00 64.32           O  
ATOM   2111  OE2 GLU D  11      19.716  81.321  26.452  1.00 66.15           O  
ATOM   2112  N   LEU D  12      13.873  82.945  25.543  1.00 64.90           N  
ATOM   2113  CA  LEU D  12      12.650  83.423  24.902  1.00 65.11           C  
ATOM   2114  C   LEU D  12      11.830  84.231  25.890  1.00 64.95           C  
ATOM   2115  O   LEU D  12      10.887  83.715  26.488  1.00 64.84           O  
ATOM   2116  CB  LEU D  12      11.800  82.250  24.411  1.00 65.32           C  
ATOM   2117  CG  LEU D  12      12.360  81.325  23.331  1.00 65.37           C  
ATOM   2118  CD1 LEU D  12      11.352  80.221  23.075  1.00 66.04           C  
ATOM   2119  CD2 LEU D  12      12.641  82.106  22.056  1.00 65.22           C  
ATOM   2120  N   PRO D  13      12.175  85.512  26.068  1.00 64.49           N  
ATOM   2121  CA  PRO D  13      11.452  86.377  26.999  1.00 64.16           C  
ATOM   2122  C   PRO D  13      10.007  86.653  26.587  1.00 64.02           C  
ATOM   2123  O   PRO D  13       9.126  86.783  27.439  1.00 64.25           O  
ATOM   2124  CB  PRO D  13      12.306  87.640  27.017  1.00 64.05           C  
ATOM   2125  CG  PRO D  13      12.808  87.700  25.618  1.00 64.27           C  
ATOM   2126  CD  PRO D  13      13.221  86.269  25.362  1.00 64.23           C  
ATOM   2127  N   GLU D  14       9.761  86.738  25.284  1.00 63.15           N  
ATOM   2128  CA  GLU D  14       8.416  87.013  24.799  1.00 62.10           C  
ATOM   2129  C   GLU D  14       7.434  85.880  25.107  1.00 60.85           C  
ATOM   2130  O   GLU D  14       6.335  86.133  25.605  1.00 61.35           O  
ATOM   2131  CB  GLU D  14       8.442  87.292  23.291  1.00 63.99           C  
ATOM   2132  CG  GLU D  14       7.133  87.859  22.732  1.00 65.91           C  
ATOM   2133  CD  GLU D  14       7.313  89.209  22.032  1.00 67.69           C  
ATOM   2134  OE1 GLU D  14       6.313  89.742  21.495  1.00 66.76           O  
ATOM   2135  OE2 GLU D  14       8.450  89.738  22.019  1.00 67.49           O  
ATOM   2136  N   VAL D  15       7.823  84.635  24.831  1.00 57.85           N  
ATOM   2137  CA  VAL D  15       6.921  83.511  25.085  1.00 55.37           C  
ATOM   2138  C   VAL D  15       6.886  83.039  26.539  1.00 52.93           C  
ATOM   2139  O   VAL D  15       5.818  82.749  27.070  1.00 50.83           O  
ATOM   2140  CB  VAL D  15       7.237  82.299  24.166  1.00 54.75           C  
ATOM   2141  CG1 VAL D  15       7.301  82.753  22.722  1.00 55.13           C  
ATOM   2142  CG2 VAL D  15       8.526  81.633  24.586  1.00 54.85           C  
ATOM   2143  N   ALA D  16       8.048  82.967  27.177  1.00 51.91           N  
ATOM   2144  CA  ALA D  16       8.124  82.526  28.566  1.00 52.28           C  
ATOM   2145  C   ALA D  16       7.298  83.441  29.458  1.00 52.39           C  
ATOM   2146  O   ALA D  16       6.667  82.994  30.419  1.00 53.45           O  
ATOM   2147  CB  ALA D  16       9.576  82.511  29.039  1.00 51.62           C  
ATOM   2148  N   GLU D  17       7.306  84.728  29.131  1.00 51.73           N  
ATOM   2149  CA  GLU D  17       6.563  85.712  29.897  1.00 50.32           C  
ATOM   2150  C   GLU D  17       5.072  85.487  29.689  1.00 48.61           C  
ATOM   2151  O   GLU D  17       4.316  85.413  30.657  1.00 48.31           O  
ATOM   2152  CB  GLU D  17       6.977  87.120  29.460  1.00 53.08           C  
ATOM   2153  CG  GLU D  17       6.351  88.265  30.237  1.00 56.34           C  
ATOM   2154  CD  GLU D  17       5.229  88.934  29.470  1.00 59.79           C  
ATOM   2155  OE1 GLU D  17       5.366  89.081  28.231  1.00 61.24           O  
ATOM   2156  OE2 GLU D  17       4.220  89.325  30.100  1.00 61.17           O  
ATOM   2157  N   SER D  18       4.648  85.358  28.432  1.00 46.34           N  
ATOM   2158  CA  SER D  18       3.231  85.129  28.146  1.00 45.48           C  
ATOM   2159  C   SER D  18       2.774  83.845  28.840  1.00 45.56           C  
ATOM   2160  O   SER D  18       1.611  83.708  29.219  1.00 45.06           O  
ATOM   2161  CB  SER D  18       2.987  85.001  26.643  1.00 42.56           C  
ATOM   2162  OG  SER D  18       3.387  83.729  26.175  1.00 41.65           O  
ATOM   2163  N   PHE D  19       3.699  82.905  29.000  1.00 45.50           N  
ATOM   2164  CA  PHE D  19       3.378  81.653  29.655  1.00 46.58           C  
ATOM   2165  C   PHE D  19       3.232  81.867  31.152  1.00 45.78           C  
ATOM   2166  O   PHE D  19       2.341  81.297  31.782  1.00 45.28           O  
ATOM   2167  CB  PHE D  19       4.459  80.604  29.401  1.00 48.04           C  
ATOM   2168  CG  PHE D  19       4.133  79.259  29.997  1.00 49.49           C  
ATOM   2169  CD1 PHE D  19       3.069  78.504  29.502  1.00 49.41           C  
ATOM   2170  CD2 PHE D  19       4.856  78.768  31.080  1.00 48.63           C  
ATOM   2171  CE1 PHE D  19       2.731  77.275  30.077  1.00 49.01           C  
ATOM   2172  CE2 PHE D  19       4.524  77.544  31.659  1.00 49.82           C  
ATOM   2173  CZ  PHE D  19       3.458  76.800  31.154  1.00 49.97           C  
ATOM   2174  N   LYS D  20       4.121  82.674  31.725  1.00 46.09           N  
ATOM   2175  CA  LYS D  20       4.053  82.958  33.151  1.00 45.85           C  
ATOM   2176  C   LYS D  20       2.735  83.659  33.453  1.00 44.60           C  
ATOM   2177  O   LYS D  20       2.165  83.494  34.526  1.00 44.65           O  
ATOM   2178  CB  LYS D  20       5.239  83.826  33.590  1.00 47.19           C  
ATOM   2179  CG  LYS D  20       6.589  83.111  33.494  1.00 50.50           C  
ATOM   2180  CD  LYS D  20       7.711  83.903  34.163  1.00 54.04           C  
ATOM   2181  CE  LYS D  20       9.088  83.259  33.945  1.00 56.22           C  
ATOM   2182  NZ  LYS D  20       9.195  81.853  34.451  1.00 56.46           N  
ATOM   2183  N   ASN D  21       2.240  84.424  32.486  1.00 45.04           N  
ATOM   2184  CA  ASN D  21       0.975  85.134  32.655  1.00 45.55           C  
ATOM   2185  C   ASN D  21      -0.177  84.138  32.576  1.00 44.54           C  
ATOM   2186  O   ASN D  21      -1.162  84.253  33.312  1.00 43.44           O  
ATOM   2187  CB  ASN D  21       0.822  86.222  31.582  1.00 47.90           C  
ATOM   2188  CG  ASN D  21       1.645  87.473  31.897  1.00 50.89           C  
ATOM   2189  OD1 ASN D  21       1.752  88.383  31.075  1.00 51.97           O  
ATOM   2190  ND2 ASN D  21       2.222  87.522  33.099  1.00 51.57           N  
ATOM   2191  N   PHE D  22      -0.047  83.160  31.684  1.00 42.38           N  
ATOM   2192  CA  PHE D  22      -1.065  82.135  31.544  1.00 40.15           C  
ATOM   2193  C   PHE D  22      -1.097  81.354  32.844  1.00 41.23           C  
ATOM   2194  O   PHE D  22      -2.169  81.079  33.389  1.00 40.08           O  
ATOM   2195  CB  PHE D  22      -0.732  81.197  30.380  1.00 38.29           C  
ATOM   2196  CG  PHE D  22      -1.578  79.946  30.343  1.00 35.49           C  
ATOM   2197  CD1 PHE D  22      -1.009  78.701  30.581  1.00 33.58           C  
ATOM   2198  CD2 PHE D  22      -2.946  80.016  30.092  1.00 34.81           C  
ATOM   2199  CE1 PHE D  22      -1.791  77.539  30.567  1.00 33.92           C  
ATOM   2200  CE2 PHE D  22      -3.735  78.859  30.077  1.00 34.22           C  
ATOM   2201  CZ  PHE D  22      -3.158  77.621  30.316  1.00 32.69           C  
ATOM   2202  N   ARG D  23       0.085  81.012  33.349  1.00 41.99           N  
ATOM   2203  CA  ARG D  23       0.170  80.253  34.586  1.00 43.76           C  
ATOM   2204  C   ARG D  23      -0.506  81.020  35.701  1.00 43.72           C  
ATOM   2205  O   ARG D  23      -1.265  80.449  36.480  1.00 44.55           O  
ATOM   2206  CB  ARG D  23       1.630  79.972  34.972  1.00 45.34           C  
ATOM   2207  CG  ARG D  23       1.767  78.873  36.029  1.00 47.32           C  
ATOM   2208  CD  ARG D  23       2.747  79.232  37.141  1.00 50.24           C  
ATOM   2209  NE  ARG D  23       4.141  79.271  36.704  1.00 51.60           N  
ATOM   2210  CZ  ARG D  23       5.137  79.776  37.434  1.00 54.66           C  
ATOM   2211  NH1 ARG D  23       4.891  80.285  38.639  1.00 53.69           N  
ATOM   2212  NH2 ARG D  23       6.383  79.772  36.962  1.00 53.65           N  
ATOM   2213  N   GLU D  24      -0.236  82.319  35.776  1.00 45.01           N  
ATOM   2214  CA  GLU D  24      -0.821  83.149  36.823  1.00 45.67           C  
ATOM   2215  C   GLU D  24      -2.333  83.323  36.711  1.00 43.87           C  
ATOM   2216  O   GLU D  24      -3.035  83.349  37.725  1.00 42.96           O  
ATOM   2217  CB  GLU D  24      -0.123  84.513  36.871  1.00 48.27           C  
ATOM   2218  CG  GLU D  24       1.163  84.492  37.704  1.00 52.68           C  
ATOM   2219  CD  GLU D  24       0.895  84.255  39.193  1.00 55.19           C  
ATOM   2220  OE1 GLU D  24       1.839  83.875  39.920  1.00 55.36           O  
ATOM   2221  OE2 GLU D  24      -0.259  84.456  39.642  1.00 55.55           O  
ATOM   2222  N   ALA D  25      -2.835  83.437  35.488  1.00 42.74           N  
ATOM   2223  CA  ALA D  25      -4.269  83.591  35.289  1.00 43.75           C  
ATOM   2224  C   ALA D  25      -4.977  82.357  35.836  1.00 45.04           C  
ATOM   2225  O   ALA D  25      -5.904  82.458  36.636  1.00 46.39           O  
ATOM   2226  CB  ALA D  25      -4.583  83.758  33.812  1.00 41.91           C  
ATOM   2227  N   VAL D  26      -4.528  81.185  35.410  1.00 46.41           N  
ATOM   2228  CA  VAL D  26      -5.137  79.944  35.861  1.00 48.64           C  
ATOM   2229  C   VAL D  26      -4.839  79.687  37.333  1.00 48.93           C  
ATOM   2230  O   VAL D  26      -5.586  78.983  38.009  1.00 49.91           O  
ATOM   2231  CB  VAL D  26      -4.638  78.736  35.026  1.00 48.77           C  
ATOM   2232  CG1 VAL D  26      -4.790  79.030  33.547  1.00 47.39           C  
ATOM   2233  CG2 VAL D  26      -3.200  78.431  35.358  1.00 49.85           C  
ATOM   2234  N   ARG D  27      -3.749  80.266  37.825  1.00 49.00           N  
ATOM   2235  CA  ARG D  27      -3.348  80.097  39.216  1.00 49.49           C  
ATOM   2236  C   ARG D  27      -4.146  80.989  40.164  1.00 49.16           C  
ATOM   2237  O   ARG D  27      -4.317  80.662  41.335  1.00 49.82           O  
ATOM   2238  CB  ARG D  27      -1.856  80.406  39.366  1.00 52.17           C  
ATOM   2239  CG  ARG D  27      -1.242  79.963  40.688  1.00 54.87           C  
ATOM   2240  CD  ARG D  27       0.201  80.448  40.808  1.00 58.00           C  
ATOM   2241  NE  ARG D  27       0.936  79.743  41.855  1.00 59.69           N  
ATOM   2242  CZ  ARG D  27       1.262  78.454  41.798  1.00 59.78           C  
ATOM   2243  NH1 ARG D  27       0.919  77.730  40.741  1.00 60.42           N  
ATOM   2244  NH2 ARG D  27       1.928  77.889  42.793  1.00 59.12           N  
ATOM   2245  N   SER D  28      -4.643  82.111  39.662  1.00 48.60           N  
ATOM   2246  CA  SER D  28      -5.400  83.028  40.506  1.00 48.77           C  
ATOM   2247  C   SER D  28      -6.904  83.100  40.209  1.00 48.50           C  
ATOM   2248  O   SER D  28      -7.584  84.004  40.691  1.00 47.92           O  
ATOM   2249  CB  SER D  28      -4.802  84.432  40.400  1.00 47.71           C  
ATOM   2250  OG  SER D  28      -4.933  84.931  39.080  1.00 48.69           O  
ATOM   2251  N   GLU D  29      -7.421  82.167  39.417  1.00 48.87           N  
ATOM   2252  CA  GLU D  29      -8.849  82.165  39.089  1.00 48.85           C  
ATOM   2253  C   GLU D  29      -9.663  82.129  40.379  1.00 48.38           C  
ATOM   2254  O   GLU D  29      -9.231  81.540  41.377  1.00 49.41           O  
ATOM   2255  CB  GLU D  29      -9.199  80.949  38.228  1.00 49.74           C  
ATOM   2256  CG  GLU D  29     -10.683  80.792  37.917  1.00 53.24           C  
ATOM   2257  CD  GLU D  29     -11.133  81.640  36.749  1.00 56.84           C  
ATOM   2258  OE1 GLU D  29     -10.284  81.933  35.879  1.00 58.76           O  
ATOM   2259  OE2 GLU D  29     -12.334  81.994  36.688  1.00 57.56           O  
ATOM   2260  N   GLY D  30     -10.841  82.749  40.353  1.00 46.50           N  
ATOM   2261  CA  GLY D  30     -11.683  82.791  41.536  1.00 44.54           C  
ATOM   2262  C   GLY D  30     -12.662  81.647  41.688  1.00 43.72           C  
ATOM   2263  O   GLY D  30     -13.231  81.463  42.764  1.00 44.89           O  
ATOM   2264  N   LYS D  31     -12.863  80.878  40.622  1.00 43.51           N  
ATOM   2265  CA  LYS D  31     -13.790  79.748  40.653  1.00 41.20           C  
ATOM   2266  C   LYS D  31     -13.449  78.750  41.760  1.00 38.92           C  
ATOM   2267  O   LYS D  31     -14.337  78.258  42.455  1.00 39.02           O  
ATOM   2268  CB  LYS D  31     -13.796  79.026  39.298  1.00 43.00           C  
ATOM   2269  CG  LYS D  31     -14.551  79.739  38.182  1.00 44.01           C  
ATOM   2270  CD  LYS D  31     -16.028  79.890  38.511  1.00 46.44           C  
ATOM   2271  CE  LYS D  31     -16.812  80.458  37.330  1.00 48.23           C  
ATOM   2272  NZ  LYS D  31     -16.281  81.772  36.878  1.00 47.29           N  
ATOM   2273  N   LEU D  32     -12.165  78.448  41.919  1.00 36.07           N  
ATOM   2274  CA  LEU D  32     -11.733  77.508  42.946  1.00 35.69           C  
ATOM   2275  C   LEU D  32     -10.864  78.186  44.010  1.00 34.81           C  
ATOM   2276  O   LEU D  32     -10.195  79.185  43.738  1.00 32.59           O  
ATOM   2277  CB  LEU D  32     -10.933  76.350  42.332  1.00 33.78           C  
ATOM   2278  CG  LEU D  32     -11.525  75.483  41.222  1.00 36.40           C  
ATOM   2279  CD1 LEU D  32     -10.542  74.356  40.909  1.00 35.08           C  
ATOM   2280  CD2 LEU D  32     -12.869  74.904  41.651  1.00 36.59           C  
ATOM   2281  N   THR D  33     -10.876  77.615  45.210  1.00 34.26           N  
ATOM   2282  CA  THR D  33     -10.085  78.118  46.321  1.00 35.50           C  
ATOM   2283  C   THR D  33      -8.634  77.700  46.106  1.00 38.14           C  
ATOM   2284  O   THR D  33      -8.353  76.727  45.394  1.00 38.77           O  
ATOM   2285  CB  THR D  33     -10.544  77.512  47.656  1.00 35.72           C  
ATOM   2286  OG1 THR D  33     -10.152  76.133  47.712  1.00 35.10           O  
ATOM   2287  CG2 THR D  33     -12.068  77.608  47.800  1.00 34.61           C  
ATOM   2288  N   GLU D  34      -7.717  78.436  46.728  1.00 37.90           N  
ATOM   2289  CA  GLU D  34      -6.292  78.155  46.629  1.00 38.45           C  
ATOM   2290  C   GLU D  34      -5.998  76.713  47.061  1.00 36.62           C  
ATOM   2291  O   GLU D  34      -5.113  76.051  46.525  1.00 36.88           O  
ATOM   2292  CB  GLU D  34      -5.519  79.123  47.530  1.00 42.79           C  
ATOM   2293  CG  GLU D  34      -4.010  79.089  47.350  1.00 48.15           C  
ATOM   2294  CD  GLU D  34      -3.274  79.757  48.498  1.00 51.63           C  
ATOM   2295  OE1 GLU D  34      -2.091  80.122  48.316  1.00 53.36           O  
ATOM   2296  OE2 GLU D  34      -3.875  79.906  49.587  1.00 54.21           O  
ATOM   2297  N   ARG D  35      -6.741  76.234  48.044  1.00 34.96           N  
ATOM   2298  CA  ARG D  35      -6.548  74.885  48.533  1.00 34.65           C  
ATOM   2299  C   ARG D  35      -6.825  73.867  47.423  1.00 33.39           C  
ATOM   2300  O   ARG D  35      -6.026  72.966  47.173  1.00 31.39           O  
ATOM   2301  CB  ARG D  35      -7.481  74.633  49.720  1.00 33.96           C  
ATOM   2302  CG  ARG D  35      -7.489  73.207  50.210  1.00 36.53           C  
ATOM   2303  CD  ARG D  35      -8.422  73.049  51.393  1.00 40.67           C  
ATOM   2304  NE  ARG D  35      -8.678  71.643  51.700  1.00 44.86           N  
ATOM   2305  CZ  ARG D  35      -7.850  70.854  52.375  1.00 45.55           C  
ATOM   2306  NH1 ARG D  35      -8.181  69.588  52.591  1.00 46.91           N  
ATOM   2307  NH2 ARG D  35      -6.707  71.330  52.852  1.00 44.98           N  
ATOM   2308  N   GLU D  36      -7.962  74.025  46.757  1.00 31.97           N  
ATOM   2309  CA  GLU D  36      -8.355  73.109  45.702  1.00 31.41           C  
ATOM   2310  C   GLU D  36      -7.374  73.119  44.531  1.00 29.94           C  
ATOM   2311  O   GLU D  36      -6.975  72.062  44.046  1.00 28.05           O  
ATOM   2312  CB  GLU D  36      -9.778  73.444  45.257  1.00 32.36           C  
ATOM   2313  CG  GLU D  36     -10.748  73.434  46.434  1.00 35.48           C  
ATOM   2314  CD  GLU D  36     -12.106  74.033  46.109  1.00 39.33           C  
ATOM   2315  OE1 GLU D  36     -12.152  75.086  45.429  1.00 39.88           O  
ATOM   2316  OE2 GLU D  36     -13.129  73.457  46.550  1.00 41.87           O  
ATOM   2317  N   LYS D  37      -6.965  74.308  44.101  1.00 29.37           N  
ATOM   2318  CA  LYS D  37      -6.010  74.424  43.002  1.00 29.51           C  
ATOM   2319  C   LYS D  37      -4.647  73.805  43.341  1.00 28.98           C  
ATOM   2320  O   LYS D  37      -3.972  73.263  42.464  1.00 30.52           O  
ATOM   2321  CB  LYS D  37      -5.854  75.888  42.596  1.00 28.76           C  
ATOM   2322  CG  LYS D  37      -7.107  76.450  41.916  1.00 31.38           C  
ATOM   2323  CD  LYS D  37      -7.059  77.968  41.783  1.00 33.77           C  
ATOM   2324  CE  LYS D  37      -7.166  78.645  43.150  1.00 33.14           C  
ATOM   2325  NZ  LYS D  37      -7.216  80.118  43.045  1.00 33.73           N  
ATOM   2326  N   LEU D  38      -4.252  73.868  44.608  1.00 27.52           N  
ATOM   2327  CA  LEU D  38      -2.980  73.291  45.035  1.00 27.39           C  
ATOM   2328  C   LEU D  38      -3.055  71.763  44.998  1.00 26.61           C  
ATOM   2329  O   LEU D  38      -2.161  71.110  44.466  1.00 27.70           O  
ATOM   2330  CB  LEU D  38      -2.614  73.764  46.450  1.00 27.31           C  
ATOM   2331  CG  LEU D  38      -2.147  75.221  46.551  1.00 29.72           C  
ATOM   2332  CD1 LEU D  38      -2.039  75.627  48.008  1.00 28.07           C  
ATOM   2333  CD2 LEU D  38      -0.806  75.387  45.847  1.00 28.77           C  
ATOM   2334  N   LEU D  39      -4.112  71.199  45.571  1.00 23.69           N  
ATOM   2335  CA  LEU D  39      -4.292  69.754  45.548  1.00 23.86           C  
ATOM   2336  C   LEU D  39      -4.375  69.281  44.090  1.00 24.33           C  
ATOM   2337  O   LEU D  39      -3.749  68.293  43.703  1.00 25.69           O  
ATOM   2338  CB  LEU D  39      -5.574  69.363  46.287  1.00 21.36           C  
ATOM   2339  CG  LEU D  39      -5.602  69.571  47.806  1.00 20.03           C  
ATOM   2340  CD1 LEU D  39      -7.037  69.648  48.276  1.00 14.89           C  
ATOM   2341  CD2 LEU D  39      -4.834  68.427  48.501  1.00 16.75           C  
ATOM   2342  N   ILE D  40      -5.143  69.994  43.278  1.00 23.18           N  
ATOM   2343  CA  ILE D  40      -5.282  69.624  41.881  1.00 24.43           C  
ATOM   2344  C   ILE D  40      -3.934  69.642  41.153  1.00 24.61           C  
ATOM   2345  O   ILE D  40      -3.655  68.745  40.360  1.00 23.52           O  
ATOM   2346  CB  ILE D  40      -6.300  70.550  41.175  1.00 23.27           C  
ATOM   2347  CG1 ILE D  40      -7.697  70.276  41.733  1.00 21.76           C  
ATOM   2348  CG2 ILE D  40      -6.316  70.301  39.671  1.00 21.24           C  
ATOM   2349  CD1 ILE D  40      -8.698  71.305  41.313  1.00 24.41           C  
ATOM   2350  N   SER D  41      -3.103  70.651  41.437  1.00 24.60           N  
ATOM   2351  CA  SER D  41      -1.785  70.773  40.810  1.00 22.96           C  
ATOM   2352  C   SER D  41      -0.889  69.601  41.147  1.00 21.85           C  
ATOM   2353  O   SER D  41      -0.108  69.142  40.312  1.00 23.13           O  
ATOM   2354  CB  SER D  41      -1.064  72.040  41.263  1.00 21.58           C  
ATOM   2355  OG  SER D  41      -1.701  73.203  40.793  1.00 28.10           O  
ATOM   2356  N   VAL D  42      -0.979  69.133  42.381  1.00 19.59           N  
ATOM   2357  CA  VAL D  42      -0.151  68.026  42.788  1.00 21.43           C  
ATOM   2358  C   VAL D  42      -0.637  66.743  42.124  1.00 22.46           C  
ATOM   2359  O   VAL D  42       0.142  66.050  41.468  1.00 21.26           O  
ATOM   2360  CB  VAL D  42      -0.149  67.872  44.327  1.00 23.05           C  
ATOM   2361  CG1 VAL D  42       0.560  66.576  44.724  1.00 23.56           C  
ATOM   2362  CG2 VAL D  42       0.545  69.069  44.959  1.00 20.17           C  
ATOM   2363  N   ALA D  43      -1.926  66.449  42.274  1.00 23.11           N  
ATOM   2364  CA  ALA D  43      -2.510  65.246  41.693  1.00 23.06           C  
ATOM   2365  C   ALA D  43      -2.273  65.154  40.183  1.00 23.90           C  
ATOM   2366  O   ALA D  43      -2.008  64.071  39.664  1.00 24.88           O  
ATOM   2367  CB  ALA D  43      -3.991  65.191  42.000  1.00 22.28           C  
ATOM   2368  N   CYS D  44      -2.370  66.281  39.481  1.00 23.86           N  
ATOM   2369  CA  CYS D  44      -2.141  66.303  38.036  1.00 23.68           C  
ATOM   2370  C   CYS D  44      -0.674  66.072  37.689  1.00 24.19           C  
ATOM   2371  O   CYS D  44      -0.358  65.445  36.674  1.00 24.13           O  
ATOM   2372  CB  CYS D  44      -2.592  67.636  37.441  1.00 24.89           C  
ATOM   2373  SG  CYS D  44      -4.354  67.728  37.128  1.00 26.75           S  
ATOM   2374  N   SER D  45       0.220  66.589  38.531  1.00 23.19           N  
ATOM   2375  CA  SER D  45       1.659  66.413  38.329  1.00 23.25           C  
ATOM   2376  C   SER D  45       1.973  64.932  38.386  1.00 22.57           C  
ATOM   2377  O   SER D  45       2.812  64.435  37.634  1.00 21.11           O  
ATOM   2378  CB  SER D  45       2.461  67.116  39.429  1.00 22.14           C  
ATOM   2379  OG  SER D  45       2.212  68.508  39.431  1.00 26.55           O  
ATOM   2380  N   VAL D  46       1.284  64.245  39.295  1.00 21.27           N  
ATOM   2381  CA  VAL D  46       1.463  62.820  39.501  1.00 22.12           C  
ATOM   2382  C   VAL D  46       0.880  62.008  38.344  1.00 23.32           C  
ATOM   2383  O   VAL D  46       1.511  61.062  37.871  1.00 24.18           O  
ATOM   2384  CB  VAL D  46       0.809  62.378  40.843  1.00 21.87           C  
ATOM   2385  CG1 VAL D  46       0.741  60.852  40.945  1.00 20.29           C  
ATOM   2386  CG2 VAL D  46       1.623  62.937  42.004  1.00 21.28           C  
ATOM   2387  N   ALA D  47      -0.317  62.390  37.897  1.00 23.71           N  
ATOM   2388  CA  ALA D  47      -1.008  61.707  36.809  1.00 24.96           C  
ATOM   2389  C   ALA D  47      -0.204  61.785  35.520  1.00 26.56           C  
ATOM   2390  O   ALA D  47      -0.177  60.845  34.732  1.00 27.57           O  
ATOM   2391  CB  ALA D  47      -2.380  62.325  36.597  1.00 25.52           C  
ATOM   2392  N   VAL D  48       0.447  62.921  35.321  1.00 26.75           N  
ATOM   2393  CA  VAL D  48       1.265  63.163  34.145  1.00 25.95           C  
ATOM   2394  C   VAL D  48       2.691  62.635  34.365  1.00 25.94           C  
ATOM   2395  O   VAL D  48       3.530  62.667  33.473  1.00 25.73           O  
ATOM   2396  CB  VAL D  48       1.235  64.679  33.846  1.00 26.32           C  
ATOM   2397  CG1 VAL D  48       2.567  65.177  33.367  1.00 27.70           C  
ATOM   2398  CG2 VAL D  48       0.139  64.959  32.833  1.00 25.19           C  
ATOM   2399  N   ARG D  49       2.944  62.122  35.561  1.00 27.58           N  
ATOM   2400  CA  ARG D  49       4.248  61.565  35.925  1.00 29.90           C  
ATOM   2401  C   ARG D  49       5.454  62.489  35.718  1.00 30.80           C  
ATOM   2402  O   ARG D  49       6.445  62.119  35.087  1.00 27.59           O  
ATOM   2403  CB  ARG D  49       4.465  60.217  35.208  1.00 31.92           C  
ATOM   2404  CG  ARG D  49       3.858  59.023  35.962  1.00 34.77           C  
ATOM   2405  CD  ARG D  49       3.999  57.671  35.234  1.00 36.34           C  
ATOM   2406  NE  ARG D  49       5.349  57.398  34.729  1.00 40.39           N  
ATOM   2407  CZ  ARG D  49       6.435  57.251  35.485  1.00 40.88           C  
ATOM   2408  NH1 ARG D  49       7.608  57.015  34.915  1.00 40.91           N  
ATOM   2409  NH2 ARG D  49       6.352  57.335  36.806  1.00 43.05           N  
ATOM   2410  N   CYS D  50       5.360  63.705  36.249  1.00 32.00           N  
ATOM   2411  CA  CYS D  50       6.462  64.650  36.160  1.00 34.40           C  
ATOM   2412  C   CYS D  50       6.991  64.852  37.572  1.00 34.74           C  
ATOM   2413  O   CYS D  50       6.375  65.546  38.378  1.00 37.41           O  
ATOM   2414  CB  CYS D  50       6.009  65.989  35.564  1.00 35.91           C  
ATOM   2415  SG  CYS D  50       7.214  67.319  35.867  1.00 37.07           S  
ATOM   2416  N   ASP D  51       8.132  64.236  37.860  1.00 35.93           N  
ATOM   2417  CA  ASP D  51       8.767  64.297  39.176  1.00 36.87           C  
ATOM   2418  C   ASP D  51       9.088  65.699  39.709  1.00 35.63           C  
ATOM   2419  O   ASP D  51       8.806  66.001  40.866  1.00 33.72           O  
ATOM   2420  CB  ASP D  51      10.045  63.455  39.168  1.00 40.25           C  
ATOM   2421  CG  ASP D  51      10.713  63.401  40.524  1.00 45.78           C  
ATOM   2422  OD1 ASP D  51      10.133  62.783  41.445  1.00 50.10           O  
ATOM   2423  OD2 ASP D  51      11.815  63.984  40.677  1.00 47.30           O  
ATOM   2424  N   ALA D  52       9.674  66.552  38.879  1.00 34.13           N  
ATOM   2425  CA  ALA D  52      10.012  67.899  39.325  1.00 33.79           C  
ATOM   2426  C   ALA D  52       8.749  68.703  39.615  1.00 34.07           C  
ATOM   2427  O   ALA D  52       8.683  69.428  40.608  1.00 32.97           O  
ATOM   2428  CB  ALA D  52      10.857  68.608  38.270  1.00 32.76           C  
ATOM   2429  N   CYS D  53       7.747  68.569  38.749  1.00 33.11           N  
ATOM   2430  CA  CYS D  53       6.495  69.288  38.921  1.00 33.79           C  
ATOM   2431  C   CYS D  53       5.829  68.887  40.221  1.00 32.53           C  
ATOM   2432  O   CYS D  53       5.225  69.705  40.907  1.00 32.64           O  
ATOM   2433  CB  CYS D  53       5.507  68.965  37.805  1.00 37.09           C  
ATOM   2434  SG  CYS D  53       6.080  69.012  36.082  1.00 46.84           S  
ATOM   2435  N   THR D  54       5.914  67.605  40.537  1.00 32.49           N  
ATOM   2436  CA  THR D  54       5.296  67.082  41.743  1.00 31.79           C  
ATOM   2437  C   THR D  54       5.949  67.671  42.985  1.00 32.10           C  
ATOM   2438  O   THR D  54       5.265  68.215  43.852  1.00 31.20           O  
ATOM   2439  CB  THR D  54       5.379  65.535  41.766  1.00 32.54           C  
ATOM   2440  OG1 THR D  54       4.661  65.011  40.642  1.00 28.79           O  
ATOM   2441  CG2 THR D  54       4.788  64.975  43.056  1.00 31.03           C  
ATOM   2442  N   ARG D  55       7.273  67.578  43.058  1.00 33.04           N  
ATOM   2443  CA  ARG D  55       8.025  68.106  44.191  1.00 35.24           C  
ATOM   2444  C   ARG D  55       7.738  69.592  44.380  1.00 33.52           C  
ATOM   2445  O   ARG D  55       7.490  70.054  45.497  1.00 33.10           O  
ATOM   2446  CB  ARG D  55       9.527  67.880  43.975  1.00 37.74           C  
ATOM   2447  CG  ARG D  55      10.407  68.383  45.108  1.00 44.19           C  
ATOM   2448  CD  ARG D  55      11.860  67.944  44.927  1.00 52.80           C  
ATOM   2449  NE  ARG D  55      12.365  68.194  43.572  1.00 58.32           N  
ATOM   2450  CZ  ARG D  55      12.468  69.398  43.011  1.00 60.88           C  
ATOM   2451  NH1 ARG D  55      12.102  70.486  43.687  1.00 60.29           N  
ATOM   2452  NH2 ARG D  55      12.929  69.514  41.766  1.00 60.10           N  
ATOM   2453  N   ARG D  56       7.755  70.322  43.271  1.00 31.85           N  
ATOM   2454  CA  ARG D  56       7.511  71.760  43.253  1.00 32.39           C  
ATOM   2455  C   ARG D  56       6.112  72.134  43.764  1.00 30.74           C  
ATOM   2456  O   ARG D  56       5.975  72.963  44.665  1.00 30.29           O  
ATOM   2457  CB  ARG D  56       7.731  72.276  41.823  1.00 34.47           C  
ATOM   2458  CG  ARG D  56       7.842  73.786  41.672  1.00 40.80           C  
ATOM   2459  CD  ARG D  56       6.511  74.423  41.275  1.00 46.65           C  
ATOM   2460  NE  ARG D  56       6.688  75.417  40.215  1.00 50.73           N  
ATOM   2461  CZ  ARG D  56       5.728  76.222  39.768  1.00 53.22           C  
ATOM   2462  NH1 ARG D  56       5.987  77.092  38.797  1.00 53.30           N  
ATOM   2463  NH2 ARG D  56       4.511  76.166  40.295  1.00 54.36           N  
ATOM   2464  N   HIS D  57       5.073  71.524  43.206  1.00 28.79           N  
ATOM   2465  CA  HIS D  57       3.722  71.832  43.658  1.00 28.71           C  
ATOM   2466  C   HIS D  57       3.455  71.301  45.061  1.00 27.47           C  
ATOM   2467  O   HIS D  57       2.654  71.859  45.802  1.00 27.72           O  
ATOM   2468  CB  HIS D  57       2.702  71.301  42.651  1.00 28.73           C  
ATOM   2469  CG  HIS D  57       2.815  71.944  41.308  1.00 30.37           C  
ATOM   2470  ND1 HIS D  57       2.684  73.310  41.122  1.00 32.72           N  
ATOM   2471  CD2 HIS D  57       3.107  71.436  40.088  1.00 31.11           C  
ATOM   2472  CE1 HIS D  57       2.890  73.606  39.856  1.00 32.12           C  
ATOM   2473  NE2 HIS D  57       3.150  72.482  39.203  1.00 33.28           N  
ATOM   2474  N   ALA D  58       4.144  70.235  45.440  1.00 28.86           N  
ATOM   2475  CA  ALA D  58       3.965  69.686  46.781  1.00 30.06           C  
ATOM   2476  C   ALA D  58       4.468  70.705  47.805  1.00 31.46           C  
ATOM   2477  O   ALA D  58       3.843  70.926  48.841  1.00 31.18           O  
ATOM   2478  CB  ALA D  58       4.731  68.373  46.928  1.00 26.66           C  
ATOM   2479  N   GLU D  59       5.602  71.328  47.506  1.00 34.23           N  
ATOM   2480  CA  GLU D  59       6.164  72.308  48.414  1.00 37.54           C  
ATOM   2481  C   GLU D  59       5.247  73.509  48.618  1.00 38.66           C  
ATOM   2482  O   GLU D  59       4.986  73.913  49.760  1.00 37.93           O  
ATOM   2483  CB  GLU D  59       7.529  72.766  47.919  1.00 40.35           C  
ATOM   2484  CG  GLU D  59       8.661  72.018  48.578  1.00 44.56           C  
ATOM   2485  CD  GLU D  59       8.560  72.057  50.095  1.00 47.12           C  
ATOM   2486  OE1 GLU D  59       8.561  73.165  50.674  1.00 49.09           O  
ATOM   2487  OE2 GLU D  59       8.484  70.975  50.712  1.00 49.05           O  
ATOM   2488  N   GLU D  60       4.750  74.074  47.520  1.00 38.14           N  
ATOM   2489  CA  GLU D  60       3.850  75.218  47.616  1.00 38.21           C  
ATOM   2490  C   GLU D  60       2.593  74.811  48.370  1.00 37.23           C  
ATOM   2491  O   GLU D  60       1.987  75.626  49.056  1.00 38.10           O  
ATOM   2492  CB  GLU D  60       3.502  75.738  46.221  1.00 38.84           C  
ATOM   2493  CG  GLU D  60       4.734  76.167  45.444  1.00 42.81           C  
ATOM   2494  CD  GLU D  60       4.448  76.535  44.005  1.00 44.95           C  
ATOM   2495  OE1 GLU D  60       3.780  75.742  43.304  1.00 46.52           O  
ATOM   2496  OE2 GLU D  60       4.911  77.611  43.569  1.00 46.70           O  
ATOM   2497  N   ALA D  61       2.213  73.543  48.255  1.00 37.53           N  
ATOM   2498  CA  ALA D  61       1.033  73.045  48.950  1.00 38.73           C  
ATOM   2499  C   ALA D  61       1.332  72.903  50.445  1.00 38.77           C  
ATOM   2500  O   ALA D  61       0.470  73.153  51.293  1.00 38.23           O  
ATOM   2501  CB  ALA D  61       0.600  71.703  48.366  1.00 37.86           C  
ATOM   2502  N   LEU D  62       2.556  72.488  50.759  1.00 38.81           N  
ATOM   2503  CA  LEU D  62       2.982  72.339  52.146  1.00 40.32           C  
ATOM   2504  C   LEU D  62       3.167  73.723  52.766  1.00 39.91           C  
ATOM   2505  O   LEU D  62       2.766  73.966  53.897  1.00 38.86           O  
ATOM   2506  CB  LEU D  62       4.300  71.565  52.217  1.00 39.81           C  
ATOM   2507  CG  LEU D  62       4.255  70.071  52.525  1.00 39.27           C  
ATOM   2508  CD1 LEU D  62       2.968  69.471  52.020  1.00 41.45           C  
ATOM   2509  CD2 LEU D  62       5.462  69.395  51.888  1.00 39.89           C  
ATOM   2510  N   GLU D  63       3.769  74.628  52.005  1.00 41.59           N  
ATOM   2511  CA  GLU D  63       4.001  75.977  52.487  1.00 44.70           C  
ATOM   2512  C   GLU D  63       2.683  76.737  52.598  1.00 45.66           C  
ATOM   2513  O   GLU D  63       2.633  77.865  53.107  1.00 46.62           O  
ATOM   2514  CB  GLU D  63       4.985  76.686  51.557  1.00 46.29           C  
ATOM   2515  CG  GLU D  63       6.297  75.910  51.441  1.00 52.32           C  
ATOM   2516  CD  GLU D  63       7.347  76.596  50.594  1.00 54.36           C  
ATOM   2517  OE1 GLU D  63       7.035  76.983  49.447  1.00 56.35           O  
ATOM   2518  OE2 GLU D  63       8.495  76.730  51.075  1.00 56.48           O  
ATOM   2519  N   ALA D  64       1.613  76.095  52.136  1.00 45.00           N  
ATOM   2520  CA  ALA D  64       0.275  76.674  52.186  1.00 43.95           C  
ATOM   2521  C   ALA D  64      -0.526  76.015  53.299  1.00 42.23           C  
ATOM   2522  O   ALA D  64      -1.703  76.312  53.489  1.00 41.84           O  
ATOM   2523  CB  ALA D  64      -0.436  76.480  50.852  1.00 45.99           C  
ATOM   2524  N   GLY D  65       0.110  75.094  54.015  1.00 40.19           N  
ATOM   2525  CA  GLY D  65      -0.562  74.446  55.121  1.00 38.64           C  
ATOM   2526  C   GLY D  65      -1.272  73.145  54.842  1.00 38.75           C  
ATOM   2527  O   GLY D  65      -2.023  72.662  55.688  1.00 37.77           O  
ATOM   2528  N   ILE D  66      -1.050  72.568  53.668  1.00 39.18           N  
ATOM   2529  CA  ILE D  66      -1.682  71.300  53.340  1.00 39.06           C  
ATOM   2530  C   ILE D  66      -0.762  70.168  53.801  1.00 40.04           C  
ATOM   2531  O   ILE D  66       0.443  70.205  53.559  1.00 41.74           O  
ATOM   2532  CB  ILE D  66      -1.946  71.195  51.815  1.00 39.10           C  
ATOM   2533  CG1 ILE D  66      -2.880  72.333  51.388  1.00 37.17           C  
ATOM   2534  CG2 ILE D  66      -2.554  69.837  51.472  1.00 35.10           C  
ATOM   2535  CD1 ILE D  66      -3.301  72.293  49.942  1.00 37.02           C  
ATOM   2536  N   THR D  67      -1.328  69.172  54.473  1.00 41.28           N  
ATOM   2537  CA  THR D  67      -0.549  68.041  54.978  1.00 43.56           C  
ATOM   2538  C   THR D  67      -0.177  67.032  53.897  1.00 44.47           C  
ATOM   2539  O   THR D  67      -0.800  66.989  52.832  1.00 44.85           O  
ATOM   2540  CB  THR D  67      -1.316  67.279  56.070  1.00 45.11           C  
ATOM   2541  OG1 THR D  67      -0.506  66.202  56.564  1.00 49.44           O  
ATOM   2542  CG2 THR D  67      -2.601  66.702  55.507  1.00 44.62           C  
ATOM   2543  N   GLU D  68       0.836  66.214  54.181  1.00 44.02           N  
ATOM   2544  CA  GLU D  68       1.278  65.196  53.240  1.00 44.33           C  
ATOM   2545  C   GLU D  68       0.194  64.132  53.121  1.00 43.06           C  
ATOM   2546  O   GLU D  68       0.138  63.393  52.140  1.00 43.66           O  
ATOM   2547  CB  GLU D  68       2.579  64.545  53.720  1.00 47.24           C  
ATOM   2548  CG  GLU D  68       3.739  65.514  53.890  1.00 50.94           C  
ATOM   2549  CD  GLU D  68       5.017  64.828  54.342  1.00 52.73           C  
ATOM   2550  OE1 GLU D  68       4.980  64.129  55.378  1.00 54.78           O  
ATOM   2551  OE2 GLU D  68       6.058  64.991  53.666  1.00 54.30           O  
ATOM   2552  N   GLY D  69      -0.669  64.064  54.127  1.00 40.53           N  
ATOM   2553  CA  GLY D  69      -1.734  63.082  54.114  1.00 39.50           C  
ATOM   2554  C   GLY D  69      -2.794  63.411  53.086  1.00 39.13           C  
ATOM   2555  O   GLY D  69      -3.273  62.533  52.366  1.00 39.47           O  
ATOM   2556  N   GLU D  70      -3.175  64.679  53.015  1.00 36.81           N  
ATOM   2557  CA  GLU D  70      -4.181  65.097  52.060  1.00 35.36           C  
ATOM   2558  C   GLU D  70      -3.572  65.042  50.665  1.00 33.52           C  
ATOM   2559  O   GLU D  70      -4.250  64.763  49.682  1.00 33.68           O  
ATOM   2560  CB  GLU D  70      -4.658  66.509  52.400  1.00 36.91           C  
ATOM   2561  CG  GLU D  70      -5.346  66.586  53.767  1.00 41.06           C  
ATOM   2562  CD  GLU D  70      -5.554  68.013  54.263  1.00 42.78           C  
ATOM   2563  OE1 GLU D  70      -4.544  68.723  54.481  1.00 41.53           O  
ATOM   2564  OE2 GLU D  70      -6.728  68.422  54.435  1.00 44.53           O  
ATOM   2565  N   LEU D  71      -2.273  65.292  50.595  1.00 32.43           N  
ATOM   2566  CA  LEU D  71      -1.552  65.272  49.341  1.00 31.16           C  
ATOM   2567  C   LEU D  71      -1.457  63.842  48.795  1.00 31.77           C  
ATOM   2568  O   LEU D  71      -1.601  63.614  47.589  1.00 30.19           O  
ATOM   2569  CB  LEU D  71      -0.160  65.854  49.562  1.00 31.39           C  
ATOM   2570  CG  LEU D  71       0.246  67.066  48.729  1.00 33.22           C  
ATOM   2571  CD1 LEU D  71      -0.891  68.078  48.643  1.00 32.06           C  
ATOM   2572  CD2 LEU D  71       1.488  67.688  49.355  1.00 35.34           C  
ATOM   2573  N   ALA D  72      -1.224  62.878  49.685  1.00 31.51           N  
ATOM   2574  CA  ALA D  72      -1.116  61.483  49.272  1.00 30.05           C  
ATOM   2575  C   ALA D  72      -2.440  60.985  48.708  1.00 30.74           C  
ATOM   2576  O   ALA D  72      -2.463  60.099  47.854  1.00 30.70           O  
ATOM   2577  CB  ALA D  72      -0.691  60.616  50.443  1.00 30.45           C  
ATOM   2578  N   GLU D  73      -3.541  61.553  49.199  1.00 30.71           N  
ATOM   2579  CA  GLU D  73      -4.879  61.185  48.743  1.00 30.74           C  
ATOM   2580  C   GLU D  73      -5.111  61.766  47.359  1.00 29.53           C  
ATOM   2581  O   GLU D  73      -5.785  61.159  46.531  1.00 31.46           O  
ATOM   2582  CB  GLU D  73      -5.932  61.715  49.716  1.00 31.60           C  
ATOM   2583  CG  GLU D  73      -7.367  61.705  49.189  1.00 33.33           C  
ATOM   2584  CD  GLU D  73      -7.870  60.314  48.816  1.00 35.08           C  
ATOM   2585  OE1 GLU D  73      -7.137  59.320  49.030  1.00 34.89           O  
ATOM   2586  OE2 GLU D  73      -9.006  60.227  48.304  1.00 33.42           O  
ATOM   2587  N   ALA D  74      -4.552  62.948  47.123  1.00 28.58           N  
ATOM   2588  CA  ALA D  74      -4.666  63.611  45.836  1.00 27.28           C  
ATOM   2589  C   ALA D  74      -3.981  62.731  44.802  1.00 27.23           C  
ATOM   2590  O   ALA D  74      -4.503  62.521  43.714  1.00 27.06           O  
ATOM   2591  CB  ALA D  74      -3.994  64.980  45.886  1.00 26.52           C  
ATOM   2592  N   ALA D  75      -2.806  62.218  45.149  1.00 26.57           N  
ATOM   2593  CA  ALA D  75      -2.060  61.348  44.245  1.00 26.16           C  
ATOM   2594  C   ALA D  75      -2.829  60.054  44.020  1.00 25.00           C  
ATOM   2595  O   ALA D  75      -2.944  59.577  42.889  1.00 25.65           O  
ATOM   2596  CB  ALA D  75      -0.677  61.037  44.822  1.00 25.68           C  
ATOM   2597  N   ALA D  76      -3.346  59.491  45.106  1.00 23.39           N  
ATOM   2598  CA  ALA D  76      -4.116  58.255  45.054  1.00 22.31           C  
ATOM   2599  C   ALA D  76      -5.232  58.338  44.012  1.00 21.06           C  
ATOM   2600  O   ALA D  76      -5.543  57.349  43.344  1.00 19.37           O  
ATOM   2601  CB  ALA D  76      -4.706  57.954  46.419  1.00 23.88           C  
ATOM   2602  N   VAL D  77      -5.841  59.513  43.884  1.00 18.17           N  
ATOM   2603  CA  VAL D  77      -6.905  59.699  42.907  1.00 19.02           C  
ATOM   2604  C   VAL D  77      -6.292  59.725  41.502  1.00 20.43           C  
ATOM   2605  O   VAL D  77      -6.911  59.269  40.536  1.00 20.10           O  
ATOM   2606  CB  VAL D  77      -7.684  61.018  43.163  1.00 18.09           C  
ATOM   2607  CG1 VAL D  77      -8.738  61.224  42.079  1.00 19.07           C  
ATOM   2608  CG2 VAL D  77      -8.350  60.970  44.533  1.00 17.03           C  
ATOM   2609  N   ALA D  78      -5.079  60.266  41.392  1.00 19.23           N  
ATOM   2610  CA  ALA D  78      -4.403  60.316  40.105  1.00 21.00           C  
ATOM   2611  C   ALA D  78      -4.149  58.882  39.658  1.00 21.51           C  
ATOM   2612  O   ALA D  78      -4.313  58.549  38.486  1.00 21.82           O  
ATOM   2613  CB  ALA D  78      -3.074  61.070  40.220  1.00 20.41           C  
ATOM   2614  N   ALA D  79      -3.748  58.044  40.612  1.00 21.32           N  
ATOM   2615  CA  ALA D  79      -3.455  56.642  40.355  1.00 21.03           C  
ATOM   2616  C   ALA D  79      -4.709  55.898  39.896  1.00 20.95           C  
ATOM   2617  O   ALA D  79      -4.666  55.093  38.965  1.00 19.12           O  
ATOM   2618  CB  ALA D  79      -2.896  56.002  41.614  1.00 20.70           C  
ATOM   2619  N   LEU D  80      -5.818  56.184  40.561  1.00 20.19           N  
ATOM   2620  CA  LEU D  80      -7.108  55.578  40.246  1.00 22.12           C  
ATOM   2621  C   LEU D  80      -7.547  55.931  38.828  1.00 21.93           C  
ATOM   2622  O   LEU D  80      -7.998  55.070  38.071  1.00 22.11           O  
ATOM   2623  CB  LEU D  80      -8.167  56.067  41.241  1.00 22.56           C  
ATOM   2624  CG  LEU D  80      -9.589  55.547  41.034  1.00 23.99           C  
ATOM   2625  CD1 LEU D  80      -9.650  54.067  41.394  1.00 24.70           C  
ATOM   2626  CD2 LEU D  80     -10.557  56.340  41.896  1.00 22.10           C  
ATOM   2627  N   ILE D  81      -7.421  57.203  38.478  1.00 21.63           N  
ATOM   2628  CA  ILE D  81      -7.793  57.666  37.146  1.00 22.95           C  
ATOM   2629  C   ILE D  81      -6.843  57.084  36.095  1.00 23.22           C  
ATOM   2630  O   ILE D  81      -7.225  56.850  34.943  1.00 20.35           O  
ATOM   2631  CB  ILE D  81      -7.751  59.203  37.065  1.00 21.50           C  
ATOM   2632  CG1 ILE D  81      -8.795  59.790  38.007  1.00 24.52           C  
ATOM   2633  CG2 ILE D  81      -8.026  59.663  35.663  1.00 22.33           C  
ATOM   2634  CD1 ILE D  81     -10.188  59.249  37.793  1.00 27.52           C  
ATOM   2635  N   ARG D  82      -5.607  56.859  36.513  1.00 23.28           N  
ATOM   2636  CA  ARG D  82      -4.581  56.301  35.647  1.00 25.00           C  
ATOM   2637  C   ARG D  82      -5.010  54.892  35.219  1.00 24.77           C  
ATOM   2638  O   ARG D  82      -4.948  54.534  34.037  1.00 23.74           O  
ATOM   2639  CB  ARG D  82      -3.277  56.219  36.427  1.00 29.62           C  
ATOM   2640  CG  ARG D  82      -2.045  56.365  35.596  1.00 36.53           C  
ATOM   2641  CD  ARG D  82      -1.678  57.823  35.404  1.00 39.20           C  
ATOM   2642  NE  ARG D  82      -0.943  57.999  34.155  1.00 43.56           N  
ATOM   2643  CZ  ARG D  82       0.181  57.363  33.847  1.00 43.32           C  
ATOM   2644  NH1 ARG D  82       0.764  57.591  32.680  1.00 45.73           N  
ATOM   2645  NH2 ARG D  82       0.729  56.514  34.706  1.00 44.01           N  
ATOM   2646  N   ALA D  83      -5.447  54.101  36.200  1.00 23.49           N  
ATOM   2647  CA  ALA D  83      -5.889  52.732  35.962  1.00 24.59           C  
ATOM   2648  C   ALA D  83      -7.254  52.697  35.285  1.00 24.19           C  
ATOM   2649  O   ALA D  83      -7.482  51.900  34.390  1.00 24.75           O  
ATOM   2650  CB  ALA D  83      -5.937  51.965  37.274  1.00 22.87           C  
ATOM   2651  N   GLY D  84      -8.157  53.569  35.715  1.00 25.54           N  
ATOM   2652  CA  GLY D  84      -9.481  53.611  35.129  1.00 25.12           C  
ATOM   2653  C   GLY D  84      -9.456  53.942  33.649  1.00 26.50           C  
ATOM   2654  O   GLY D  84     -10.205  53.351  32.877  1.00 26.96           O  
ATOM   2655  N   SER D  85      -8.598  54.876  33.248  1.00 26.65           N  
ATOM   2656  CA  SER D  85      -8.509  55.274  31.849  1.00 29.32           C  
ATOM   2657  C   SER D  85      -8.055  54.105  30.979  1.00 30.16           C  
ATOM   2658  O   SER D  85      -8.530  53.934  29.858  1.00 33.51           O  
ATOM   2659  CB  SER D  85      -7.545  56.458  31.687  1.00 29.52           C  
ATOM   2660  OG  SER D  85      -6.214  56.096  32.036  1.00 31.47           O  
ATOM   2661  N   ALA D  86      -7.142  53.296  31.500  1.00 29.67           N  
ATOM   2662  CA  ALA D  86      -6.656  52.138  30.765  1.00 29.22           C  
ATOM   2663  C   ALA D  86      -7.811  51.184  30.483  1.00 30.45           C  
ATOM   2664  O   ALA D  86      -8.006  50.744  29.350  1.00 31.42           O  
ATOM   2665  CB  ALA D  86      -5.573  51.425  31.571  1.00 27.80           C  
HETATM 2666  N   MSE D  87      -8.576  50.870  31.522  1.00 31.54           N  
HETATM 2667  CA  MSE D  87      -9.714  49.966  31.402  1.00 34.70           C  
HETATM 2668  C   MSE D  87     -10.741  50.464  30.407  1.00 33.16           C  
HETATM 2669  O   MSE D  87     -11.498  49.686  29.836  1.00 31.29           O  
HETATM 2670  CB  MSE D  87     -10.384  49.798  32.753  1.00 41.95           C  
HETATM 2671  CG  MSE D  87      -9.394  49.486  33.842  1.00 52.53           C  
HETATM 2672 SE   MSE D  87     -10.262  49.152  35.497  1.00 67.53          SE  
HETATM 2673  CE  MSE D  87      -8.926  47.996  36.301  1.00 60.29           C  
ATOM   2674  N   ASN D  88     -10.782  51.773  30.214  1.00 31.37           N  
ATOM   2675  CA  ASN D  88     -11.720  52.317  29.266  1.00 30.14           C  
ATOM   2676  C   ASN D  88     -11.213  51.928  27.873  1.00 28.05           C  
ATOM   2677  O   ASN D  88     -11.993  51.553  27.001  1.00 27.22           O  
ATOM   2678  CB  ASN D  88     -11.816  53.838  29.425  1.00 30.86           C  
ATOM   2679  CG  ASN D  88     -12.740  54.461  28.410  1.00 32.91           C  
ATOM   2680  OD1 ASN D  88     -13.937  54.173  28.384  1.00 32.15           O  
ATOM   2681  ND2 ASN D  88     -12.183  55.312  27.547  1.00 34.70           N  
ATOM   2682  N   THR D  89      -9.904  52.006  27.669  1.00 25.98           N  
ATOM   2683  CA  THR D  89      -9.329  51.631  26.383  1.00 27.36           C  
ATOM   2684  C   THR D  89      -9.498  50.134  26.172  1.00 27.13           C  
ATOM   2685  O   THR D  89      -9.633  49.671  25.045  1.00 26.18           O  
ATOM   2686  CB  THR D  89      -7.823  51.939  26.313  1.00 26.88           C  
ATOM   2687  OG1 THR D  89      -7.615  53.351  26.414  1.00 28.88           O  
ATOM   2688  CG2 THR D  89      -7.243  51.428  25.002  1.00 22.69           C  
ATOM   2689  N   ALA D  90      -9.484  49.389  27.277  1.00 28.08           N  
ATOM   2690  CA  ALA D  90      -9.623  47.937  27.260  1.00 28.88           C  
ATOM   2691  C   ALA D  90     -10.956  47.426  26.695  1.00 30.41           C  
ATOM   2692  O   ALA D  90     -11.028  46.293  26.203  1.00 29.84           O  
ATOM   2693  CB  ALA D  90      -9.413  47.385  28.671  1.00 26.86           C  
ATOM   2694  N   SER D  91     -12.004  48.240  26.766  1.00 29.40           N  
ATOM   2695  CA  SER D  91     -13.295  47.801  26.258  1.00 33.40           C  
ATOM   2696  C   SER D  91     -13.237  47.565  24.757  1.00 33.67           C  
ATOM   2697  O   SER D  91     -14.109  46.902  24.192  1.00 34.21           O  
ATOM   2698  CB  SER D  91     -14.399  48.813  26.601  1.00 34.85           C  
ATOM   2699  OG  SER D  91     -14.248  50.036  25.900  1.00 37.58           O  
ATOM   2700  N   ALA D  92     -12.198  48.096  24.117  1.00 35.54           N  
ATOM   2701  CA  ALA D  92     -12.010  47.933  22.672  1.00 38.01           C  
ATOM   2702  C   ALA D  92     -11.689  46.479  22.339  1.00 39.84           C  
ATOM   2703  O   ALA D  92     -11.705  46.073  21.173  1.00 40.00           O  
ATOM   2704  CB  ALA D  92     -10.886  48.841  22.184  1.00 37.28           C  
ATOM   2705  N   ILE D  93     -11.388  45.707  23.379  1.00 41.90           N  
ATOM   2706  CA  ILE D  93     -11.076  44.297  23.242  1.00 43.29           C  
ATOM   2707  C   ILE D  93     -12.349  43.532  22.901  1.00 45.36           C  
ATOM   2708  O   ILE D  93     -12.368  42.719  21.982  1.00 46.86           O  
ATOM   2709  CB  ILE D  93     -10.507  43.727  24.565  1.00 42.95           C  
ATOM   2710  CG1 ILE D  93      -9.116  44.302  24.830  1.00 42.11           C  
ATOM   2711  CG2 ILE D  93     -10.451  42.208  24.510  1.00 43.58           C  
ATOM   2712  CD1 ILE D  93      -8.559  43.892  26.183  1.00 40.02           C  
ATOM   2713  N   PHE D  94     -13.415  43.816  23.637  1.00 47.14           N  
ATOM   2714  CA  PHE D  94     -14.684  43.122  23.447  1.00 49.72           C  
ATOM   2715  C   PHE D  94     -15.535  43.587  22.274  1.00 51.75           C  
ATOM   2716  O   PHE D  94     -16.000  44.730  22.224  1.00 51.50           O  
ATOM   2717  CB  PHE D  94     -15.503  43.204  24.731  1.00 47.65           C  
ATOM   2718  CG  PHE D  94     -14.688  42.978  25.964  1.00 47.65           C  
ATOM   2719  CD1 PHE D  94     -14.111  44.051  26.639  1.00 47.31           C  
ATOM   2720  CD2 PHE D  94     -14.461  41.687  26.434  1.00 47.40           C  
ATOM   2721  CE1 PHE D  94     -13.311  43.839  27.764  1.00 48.35           C  
ATOM   2722  CE2 PHE D  94     -13.663  41.466  27.557  1.00 48.29           C  
ATOM   2723  CZ  PHE D  94     -13.090  42.543  28.224  1.00 48.28           C  
ATOM   2724  N   ARG D  95     -15.744  42.667  21.340  1.00 54.41           N  
ATOM   2725  CA  ARG D  95     -16.545  42.923  20.151  1.00 56.20           C  
ATOM   2726  C   ARG D  95     -17.775  42.022  20.186  1.00 55.82           C  
ATOM   2727  O   ARG D  95     -17.694  40.962  20.840  1.00 55.60           O  
ATOM   2728  CB  ARG D  95     -15.710  42.636  18.895  1.00 57.45           C  
ATOM   2729  CG  ARG D  95     -14.739  41.458  19.046  1.00 57.55           C  
ATOM   2730  CD  ARG D  95     -13.976  41.160  17.753  1.00 58.16           C  
ATOM   2731  NE  ARG D  95     -13.352  42.341  17.152  1.00 59.08           N  
ATOM   2732  CZ  ARG D  95     -12.416  43.097  17.728  1.00 59.59           C  
ATOM   2733  NH1 ARG D  95     -11.965  42.821  18.947  1.00 57.37           N  
ATOM   2734  NH2 ARG D  95     -11.923  44.139  17.072  1.00 59.69           N  
TER    2735      ARG D  95                                                      
END
MOLECULE T0408.pdb
ATOM    769  N   PHE     7       8.970  79.991  40.219  1.00 59.01           N  
ATOM    770  CA  PHE     7       9.121  78.887  39.220  1.00 58.55           C  
ATOM    771  C   PHE     7      10.525  78.270  39.318  1.00 57.17           C  
ATOM    772  O   PHE     7      11.448  78.885  39.884  1.00 59.33           O  
ATOM    773  CB  PHE     7       8.894  79.403  37.792  1.00 59.50           C  
ATOM    774  CG  PHE     7       7.630  80.211  37.607  1.00 59.88           C  
ATOM    775  CD1 PHE     7       7.640  81.590  37.779  1.00 59.55           C  
ATOM    776  CD2 PHE     7       6.441  79.594  37.219  1.00 60.26           C  
ATOM    777  CE1 PHE     7       6.481  82.338  37.600  1.00 63.27           C  
ATOM    778  CE2 PHE     7       5.280  80.335  37.027  1.00 57.96           C  
ATOM    779  CZ  PHE     7       5.299  81.709  37.222  1.00 60.10           C  
ATOM    780  N   GLY     8      10.693  77.077  38.739  1.00 51.97           N  
ATOM    781  CA  GLY     8      11.946  76.308  38.864  1.00 47.06           C  
ATOM    782  C   GLY     8      13.010  76.644  37.842  1.00 42.74           C  
ATOM    783  O   GLY     8      12.960  77.691  37.199  1.00 40.60           O  
ATOM    784  N   GLU     9      13.969  75.734  37.690  1.00 39.01           N  
ATOM    785  CA  GLU     9      15.125  75.924  36.812  1.00 38.04           C  
ATOM    786  C   GLU     9      14.737  76.079  35.344  1.00 34.61           C  
ATOM    787  O   GLU     9      15.312  76.893  34.624  1.00 33.70           O  
ATOM    788  CB  GLU     9      16.093  74.746  36.964  1.00 38.65           C  
ATOM    789  N   GLY    10      13.750  75.287  34.915  1.00 34.19           N  
ATOM    790  CA  GLY    10      13.250  75.348  33.551  1.00 31.10           C  
ATOM    791  C   GLY    10      12.790  76.744  33.220  1.00 25.97           C  
ATOM    792  O   GLY    10      13.200  77.304  32.203  1.00 24.44           O  
ATOM    793  N   MET    11      11.958  77.314  34.091  1.00 26.78           N  
ATOM    794  CA  MET    11      11.453  78.679  33.871  1.00 26.99           C  
ATOM    795  C   MET    11      12.547  79.734  33.936  1.00 24.54           C  
ATOM    796  O   MET    11      12.436  80.750  33.237  1.00 22.59           O  
ATOM    797  CB  MET    11      10.298  79.036  34.809  1.00 26.96           C  
ATOM    798  CG  MET    11       8.956  78.424  34.384  1.00 30.81           C  
ATOM    799  SD  MET    11       8.363  79.163  32.682  0.75 32.36          SE  
ATOM    800  CE  MET    11       7.641  80.815  33.439  1.00 38.14           C  
ATOM    801  N   LYS    12      13.587  79.531  34.749  1.00 22.58           N  
ATOM    802  CA  LYS    12      14.709  80.488  34.749  1.00 22.98           C  
ATOM    803  C   LYS    12      15.471  80.468  33.411  1.00 20.97           C  
ATOM    804  O   LYS    12      15.931  81.507  32.944  1.00 22.83           O  
ATOM    805  CB  LYS    12      15.656  80.233  35.932  1.00 24.68           C  
ATOM    806  CG  LYS    12      14.987  80.568  37.290  1.00 26.05           C  
ATOM    807  CD  LYS    12      15.724  79.996  38.524  1.00 31.53           C  
ATOM    808  CE  LYS    12      17.178  80.177  38.487  1.00 33.33           C  
ATOM    809  NZ  LYS    12      17.857  79.899  39.811  1.00 35.75           N  
ATOM    810  N   VAL    13      15.558  79.292  32.784  1.00 23.05           N  
ATOM    811  CA  VAL    13      16.174  79.143  31.455  1.00 22.27           C  
ATOM    812  C   VAL    13      15.338  79.931  30.437  1.00 19.87           C  
ATOM    813  O   VAL    13      15.870  80.675  29.599  1.00 19.37           O  
ATOM    814  CB  VAL    13      16.227  77.631  31.026  1.00 24.12           C  
ATOM    815  CG1 VAL    13      16.716  77.489  29.584  1.00 25.29           C  
ATOM    816  CG2 VAL    13      17.136  76.836  31.979  1.00 30.23           C  
ATOM    817  N   VAL    14      14.032  79.817  30.576  1.00 20.72           N  
ATOM    818  CA  VAL    14      13.119  80.535  29.668  1.00 22.65           C  
ATOM    819  C   VAL    14      13.274  82.037  29.865  1.00 19.62           C  
ATOM    820  O   VAL    14      13.348  82.784  28.895  1.00 20.37           O  
ATOM    821  CB  VAL    14      11.657  80.121  29.823  1.00 21.69           C  
ATOM    822  CG1 VAL    14      10.788  80.938  28.849  1.00 21.74           C  
ATOM    823  CG2 VAL    14      11.465  78.585  29.542  1.00 26.25           C  
ATOM    824  N   LYS    15      13.332  82.483  31.131  1.00 21.22           N  
ATOM    825  CA  LYS    15      13.580  83.912  31.414  1.00 18.46           C  
ATOM    826  C   LYS    15      14.866  84.401  30.767  1.00 19.65           C  
ATOM    827  O   LYS    15      14.894  85.480  30.187  1.00 22.14           O  
ATOM    828  CB  LYS    15      13.617  84.181  32.921  1.00 18.27           C  
ATOM    829  N   GLU    16      15.918  83.608  30.857  1.00 21.08           N  
ATOM    830  CA  GLU    16      17.202  83.950  30.227  1.00 22.56           C  
ATOM    831  C   GLU    16      17.144  83.974  28.678  1.00 22.82           C  
ATOM    832  O   GLU    16      17.665  84.891  28.042  1.00 28.47           O  
ATOM    833  CB  GLU    16      18.277  82.981  30.693  1.00 24.31           C  
ATOM    834  N   LYS    17      16.521  82.963  28.097  1.00 21.86           N  
ATOM    835  CA  LYS    17      16.542  82.770  26.636  1.00 22.20           C  
ATOM    836  C   LYS    17      15.493  83.586  25.851  1.00 21.86           C  
ATOM    837  O   LYS    17      15.808  84.146  24.776  1.00 23.86           O  
ATOM    838  CB  LYS    17      16.365  81.277  26.315  1.00 21.29           C  
ATOM    839  N   TYR    18      14.290  83.672  26.407  1.00 22.99           N  
ATOM    840  CA  TYR    18      13.084  84.212  25.724  1.00 24.08           C  
ATOM    841  C   TYR    18      12.235  85.030  26.691  1.00 21.96           C  
ATOM    842  O   TYR    18      11.217  84.579  27.196  1.00 21.62           O  
ATOM    843  CB  TYR    18      12.270  83.071  25.102  1.00 23.86           C  
ATOM    844  CG  TYR    18      13.142  82.276  24.153  1.00 25.16           C  
ATOM    845  CD1 TYR    18      13.658  82.867  23.007  1.00 22.60           C  
ATOM    846  CD2 TYR    18      13.503  80.967  24.432  1.00 27.55           C  
ATOM    847  CE1 TYR    18      14.496  82.174  22.142  1.00 26.49           C  
ATOM    848  CE2 TYR    18      14.364  80.270  23.576  1.00 26.29           C  
ATOM    849  CZ  TYR    18      14.846  80.874  22.433  1.00 25.54           C  
ATOM    850  OH  TYR    18      15.686  80.188  21.581  1.00 26.16           O  
ATOM    851  N   PRO    19      12.703  86.256  26.994  1.00 22.95           N  
ATOM    852  CA  PRO    19      12.008  87.103  27.963  1.00 20.97           C  
ATOM    853  C   PRO    19      10.540  87.377  27.666  1.00 23.47           C  
ATOM    854  O   PRO    19       9.729  87.342  28.598  1.00 22.73           O  
ATOM    855  CB  PRO    19      12.823  88.395  27.933  1.00 22.49           C  
ATOM    856  CG  PRO    19      14.111  88.033  27.370  1.00 24.22           C  
ATOM    857  CD  PRO    19      13.956  86.869  26.528  1.00 23.77           C  
ATOM    858  N   ASP    20      10.175  87.629  26.413  1.00 23.93           N  
ATOM    859  CA  ASP    20       8.772  87.917  26.104  1.00 28.48           C  
ATOM    860  C   ASP    20       7.908  86.671  26.266  1.00 26.25           C  
ATOM    861  O   ASP    20       6.756  86.723  26.775  1.00 26.13           O  
ATOM    862  CB  ASP    20       8.618  88.482  24.690  1.00 30.80           C  
ATOM    863  CG  ASP    20       9.052  89.954  24.570  1.00 38.16           C  
ATOM    864  OD1 ASP    20       9.402  90.617  25.580  1.00 42.94           O  
ATOM    865  OD2 ASP    20       9.033  90.451  23.426  1.00 46.06           O  
ATOM    866  N   LEU    21       8.444  85.524  25.878  1.00 24.97           N  
ATOM    867  CA  LEU    21       7.721  84.269  26.090  1.00 23.54           C  
ATOM    868  C   LEU    21       7.555  83.994  27.575  1.00 22.52           C  
ATOM    869  O   LEU    21       6.474  83.604  28.042  1.00 24.44           O  
ATOM    870  CB  LEU    21       8.447  83.115  25.385  1.00 23.74           C  
ATOM    871  CG  LEU    21       7.857  81.731  25.468  1.00 25.87           C  
ATOM    872  CD1 LEU    21       6.373  81.718  24.990  1.00 25.00           C  
ATOM    873  CD2 LEU    21       8.754  80.756  24.680  1.00 23.70           C  
ATOM    874  N   TYR    22       8.626  84.193  28.326  1.00 22.41           N  
ATOM    875  CA  TYR    22       8.584  84.070  29.780  1.00 22.77           C  
ATOM    876  C   TYR    22       7.435  84.913  30.380  1.00 22.67           C  
ATOM    877  O   TYR    22       6.627  84.425  31.175  1.00 23.91           O  
ATOM    878  CB  TYR    22       9.912  84.494  30.385  1.00 23.66           C  
ATOM    879  CG  TYR    22       9.886  84.492  31.893  1.00 22.50           C  
ATOM    880  CD1 TYR    22      10.074  83.325  32.604  1.00 23.27           C  
ATOM    881  CD2 TYR    22       9.660  85.671  32.602  1.00 25.67           C  
ATOM    882  CE1 TYR    22      10.047  83.327  33.987  1.00 21.18           C  
ATOM    883  CE2 TYR    22       9.622  85.671  33.963  1.00 25.00           C  
ATOM    884  CZ  TYR    22       9.808  84.488  34.647  1.00 23.45           C  
ATOM    885  OH  TYR    22       9.784  84.487  35.999  1.00 27.44           O  
ATOM    886  N   ASP    23       7.378  86.174  29.980  1.00 23.82           N  
ATOM    887  CA  ASP    23       6.360  87.088  30.502  1.00 24.16           C  
ATOM    888  C   ASP    23       4.927  86.625  30.205  1.00 25.07           C  
ATOM    889  O   ASP    23       4.046  86.754  31.064  1.00 23.28           O  
ATOM    890  CB  ASP    23       6.577  88.482  29.910  1.00 24.42           C  
ATOM    891  CG  ASP    23       7.742  89.194  30.505  1.00 33.39           C  
ATOM    892  OD1 ASP    23       8.216  88.809  31.607  1.00 34.11           O  
ATOM    893  OD2 ASP    23       8.170  90.189  29.868  1.00 37.66           O  
ATOM    894  N   ILE    24       4.693  86.066  29.019  1.00 23.65           N  
ATOM    895  CA  ILE    24       3.350  85.619  28.651  1.00 24.84           C  
ATOM    896  C   ILE    24       3.018  84.370  29.489  1.00 23.61           C  
ATOM    897  O   ILE    24       1.899  84.210  29.967  1.00 24.22           O  
ATOM    898  CB  ILE    24       3.222  85.316  27.150  1.00 27.79           C  
ATOM    899  CG1 ILE    24       3.448  86.587  26.329  1.00 32.72           C  
ATOM    900  CG2 ILE    24       1.848  84.746  26.841  1.00 30.67           C  
ATOM    901  CD1 ILE    24       3.838  86.311  24.854  1.00 35.16           C  
ATOM    902  N   ILE    25       4.024  83.514  29.707  1.00 24.35           N  
ATOM    903  CA  ILE    25       3.817  82.316  30.523  1.00 24.21           C  
ATOM    904  C   ILE    25       3.445  82.707  31.965  1.00 23.22           C  
ATOM    905  O   ILE    25       2.509  82.132  32.562  1.00 25.47           O  
ATOM    906  CB  ILE    25       5.047  81.338  30.493  1.00 24.22           C  
ATOM    907  CG1 ILE    25       5.238  80.729  29.103  1.00 23.74           C  
ATOM    908  CG2 ILE    25       4.856  80.188  31.494  1.00 29.35           C  
ATOM    909  CD1 ILE    25       6.631  80.075  28.922  1.00 23.35           C  
ATOM    910  N   VAL    26       4.144  83.697  32.511  1.00 24.58           N  
ATOM    911  CA  VAL    26       3.846  84.171  33.859  1.00 26.19           C  
ATOM    912  C   VAL    26       2.405  84.710  33.937  1.00 24.90           C  
ATOM    913  O   VAL    26       1.639  84.349  34.854  1.00 24.16           O  
ATOM    914  CB  VAL    26       4.836  85.230  34.313  1.00 28.22           C  
ATOM    915  CG1 VAL    26       4.301  85.976  35.531  1.00 28.71           C  
ATOM    916  CG2 VAL    26       6.242  84.589  34.603  1.00 26.39           C  
ATOM    917  N   LYS    27       2.006  85.523  32.967  1.00 23.37           N  
ATOM    918  CA  LYS    27       0.622  86.024  32.925  0.50 23.88           C  
ATOM    920  C   LYS    27      -0.377  84.879  32.823  1.00 24.17           C  
ATOM    921  O   LYS    27      -1.387  84.886  33.498  1.00 24.41           O  
ATOM    922  CB  LYS    27       0.414  87.028  31.779  0.50 24.31           C  
ATOM    924  CG  LYS    27       1.172  88.334  31.934  0.50 20.98           C  
ATOM    926  N   LEU    28      -0.091  83.873  31.981  1.00 23.31           N  
ATOM    927  CA  LEU    28      -0.962  82.705  31.832  1.00 25.23           C  
ATOM    928  C   LEU    28      -1.121  81.995  33.180  1.00 25.13           C  
ATOM    929  O   LEU    28      -2.231  81.653  33.640  1.00 24.63           O  
ATOM    930  CB  LEU    28      -0.374  81.739  30.788  1.00 23.04           C  
ATOM    931  CG  LEU    28      -1.148  80.428  30.624  1.00 24.78           C  
ATOM    932  CD1 LEU    28      -2.545  80.697  30.079  1.00 32.09           C  
ATOM    933  CD2 LEU    28      -0.369  79.493  29.738  1.00 28.12           C  
ATOM    934  N   ASN    29       0.023  81.773  33.828  1.00 22.56           N  
ATOM    935  CA  ASN    29       0.048  81.101  35.117  1.00 24.38           C  
ATOM    936  C   ASN    29      -0.813  81.844  36.140  1.00 22.89           C  
ATOM    937  O   ASN    29      -1.651  81.255  36.839  1.00 26.79           O  
ATOM    938  CB  ASN    29       1.491  80.993  35.606  1.00 27.63           C  
ATOM    939  CG  ASN    29       1.585  80.340  36.962  1.00 33.82           C  
ATOM    940  OD1 ASN    29       1.667  79.126  37.053  1.00 33.33           O  
ATOM    941  ND2 ASN    29       1.566  81.143  38.011  1.00 35.43           N  
ATOM    942  N   ASP    30      -0.596  83.141  36.234  1.00 22.88           N  
ATOM    943  CA  ASP    30      -1.285  83.973  37.203  1.00 24.82           C  
ATOM    944  C   ASP    30      -2.797  84.034  36.943  1.00 25.07           C  
ATOM    945  O   ASP    30      -3.601  84.001  37.880  1.00 26.99           O  
ATOM    946  CB  ASP    30      -0.694  85.365  37.193  1.00 26.68           C  
ATOM    947  CG  ASP    30       0.726  85.408  37.720  1.00 28.43           C  
ATOM    948  OD1 ASP    30       1.234  84.358  38.174  1.00 35.44           O  
ATOM    949  OD2 ASP    30       1.331  86.499  37.649  1.00 29.80           O  
ATOM    950  N   THR    31      -3.173  84.070  35.675  1.00 22.79           N  
ATOM    951  CA  THR    31      -4.600  83.984  35.289  1.00 24.26           C  
ATOM    952  C   THR    31      -5.213  82.620  35.540  1.00 23.93           C  
ATOM    953  O   THR    31      -6.339  82.515  36.082  1.00 24.83           O  
ATOM    954  CB  THR    31      -4.809  84.366  33.824  1.00 22.72           C  
ATOM    955  OG1 THR    31      -4.260  85.683  33.614  1.00 30.25           O  
ATOM    956  CG2 THR    31      -6.307  84.307  33.460  1.00 24.57           C  
ATOM    957  N   VAL    32      -4.509  81.554  35.146  1.00 22.77           N  
ATOM    958  CA  VAL    32      -4.974  80.194  35.438  1.00 24.03           C  
ATOM    959  C   VAL    32      -5.286  80.043  36.936  1.00 23.77           C  
ATOM    960  O   VAL    32      -6.329  79.469  37.304  1.00 25.63           O  
ATOM    961  CB  VAL    32      -3.924  79.174  34.994  1.00 23.98           C  
ATOM    962  CG1 VAL    32      -4.033  77.835  35.796  1.00 24.54           C  
ATOM    963  CG2 VAL    32      -4.012  78.986  33.460  1.00 22.05           C  
ATOM    964  N   PHE    33      -4.431  80.590  37.799  1.00 23.43           N  
ATOM    965  CA  PHE    33      -4.601  80.397  39.246  1.00 25.33           C  
ATOM    966  C   PHE    33      -5.403  81.502  39.922  1.00 27.87           C  
ATOM    967  O   PHE    33      -5.384  81.637  41.159  1.00 27.20           O  
ATOM    968  CB  PHE    33      -3.266  80.181  39.951  1.00 27.45           C  
ATOM    969  CG  PHE    33      -2.688  78.829  39.709  1.00 26.58           C  
ATOM    970  CD1 PHE    33      -3.361  77.688  40.124  1.00 26.58           C  
ATOM    971  CD2 PHE    33      -1.487  78.692  39.040  1.00 27.16           C  
ATOM    972  CE1 PHE    33      -2.844  76.433  39.875  1.00 26.69           C  
ATOM    973  CE2 PHE    33      -0.960  77.444  38.790  1.00 25.47           C  
ATOM    974  CZ  PHE    33      -1.643  76.315  39.204  1.00 28.16           C  
ATOM    975  N   THR    34      -6.104  82.288  39.114  1.00 28.08           N  
ATOM    976  CA  THR    34      -7.123  83.205  39.620  1.00 27.68           C  
ATOM    977  C   THR    34      -8.472  82.607  39.227  1.00 26.27           C  
ATOM    978  O   THR    34      -9.079  82.991  38.223  1.00 24.59           O  
ATOM    979  CB  THR    34      -6.912  84.630  39.078  1.00 29.15           C  
ATOM    980  OG1 THR    34      -5.572  85.039  39.354  1.00 27.52           O  
ATOM    981  CG2 THR    34      -7.858  85.624  39.752  1.00 27.57           C  
ATOM    982  N   GLY    35      -8.916  81.627  40.013  1.00 23.37           N  
ATOM    983  CA  GLY    35     -10.169  80.966  39.763  1.00 26.15           C  
ATOM    984  C   GLY    35     -11.353  81.880  40.008  1.00 26.00           C  
ATOM    985  O   GLY    35     -11.261  82.862  40.761  1.00 26.21           O  
ATOM    986  N   LYS    36     -12.466  81.593  39.353  1.00 26.20           N  
ATOM    987  CA  LYS    36     -13.707  82.364  39.626  1.00 25.52           C  
ATOM    988  C   LYS    36     -14.401  81.918  40.902  1.00 25.59           C  
ATOM    989  O   LYS    36     -15.013  82.749  41.608  1.00 24.82           O  
ATOM    990  CB  LYS    36     -14.650  82.280  38.433  1.00 23.76           C  
ATOM    991  CG  LYS    36     -14.018  82.839  37.170  1.00 27.92           C  
ATOM    992  CD  LYS    36     -13.636  84.274  37.261  1.00 33.79           C  
ATOM    993  CE  LYS    36     -13.123  84.756  35.913  1.00 33.74           C  
ATOM    994  NZ  LYS    36     -12.672  86.191  35.921  1.00 36.41           N  
ATOM    995  N   THR    37     -14.305  80.634  41.224  1.00 26.34           N  
ATOM    996  CA  THR    37     -14.895  80.088  42.444  1.00 27.40           C  
ATOM    997  C   THR    37     -13.901  79.304  43.281  1.00 28.68           C  
ATOM    998  O   THR    37     -13.830  79.501  44.486  1.00 28.44           O  
ATOM    999  CB  THR    37     -16.085  79.125  42.147  1.00 30.61           C  
ATOM   1000  OG1 THR    37     -17.140  79.845  41.507  1.00 34.12           O  
ATOM   1001  CG2 THR    37     -16.683  78.562  43.442  1.00 27.91           C  
ATOM   1002  N   LEU    38     -13.154  78.398  42.652  1.00 24.44           N  
ATOM   1003  CA  LEU    38     -12.190  77.556  43.382  1.00 24.53           C  
ATOM   1004  C   LEU    38     -11.018  78.408  43.841  1.00 26.73           C  
ATOM   1005  O   LEU    38     -10.561  79.304  43.117  1.00 26.13           O  
ATOM   1006  CB  LEU    38     -11.682  76.416  42.494  1.00 24.24           C  
ATOM   1007  CG  LEU    38     -12.721  75.446  41.996  1.00 25.01           C  
ATOM   1008  CD1 LEU    38     -12.043  74.310  41.217  1.00 23.26           C  
ATOM   1009  CD2 LEU    38     -13.555  74.919  43.151  1.00 22.80           C  
ATOM   1010  N   ASP    39     -10.539  78.150  45.053  1.00 25.77           N  
ATOM   1011  CA  ASP    39      -9.405  78.915  45.556  1.00 26.59           C  
ATOM   1012  C   ASP    39      -8.085  78.324  45.076  1.00 26.80           C  
ATOM   1013  O   ASP    39      -8.046  77.280  44.439  1.00 24.07           O  
ATOM   1014  CB  ASP    39      -9.484  79.093  47.084  1.00 27.84           C  
ATOM   1015  CG  ASP    39      -9.352  77.804  47.861  1.00 31.36           C  
ATOM   1016  OD1 ASP    39      -8.887  76.754  47.351  1.00 28.62           O  
ATOM   1017  OD2 ASP    39      -9.729  77.848  49.052  1.00 33.78           O  
ATOM   1018  N   TYR    40      -7.011  79.046  45.327  1.00 25.33           N  
ATOM   1019  CA  TYR    40      -5.703  78.664  44.822  1.00 24.51           C  
ATOM   1020  C   TYR    40      -5.243  77.312  45.372  1.00 25.46           C  
ATOM   1021  O   TYR    40      -4.698  76.478  44.641  1.00 24.60           O  
ATOM   1022  CB  TYR    40      -4.723  79.753  45.247  1.00 28.58           C  
ATOM   1023  CG  TYR    40      -3.320  79.640  44.733  1.00 27.35           C  
ATOM   1024  CD1 TYR    40      -3.051  79.264  43.426  1.00 42.63           C  
ATOM   1025  CD2 TYR    40      -2.241  79.981  45.555  1.00 35.86           C  
ATOM   1026  CE1 TYR    40      -1.744  79.202  42.958  1.00 45.32           C  
ATOM   1027  CE2 TYR    40      -0.946  79.919  45.099  1.00 36.50           C  
ATOM   1028  CZ  TYR    40      -0.701  79.543  43.803  1.00 41.69           C  
ATOM   1029  OH  TYR    40       0.596  79.495  43.344  1.00 43.10           O  
ATOM   1030  N   LYS    41      -5.466  77.097  46.659  1.00 24.17           N  
ATOM   1031  CA  LYS    41      -5.137  75.787  47.259  1.00 26.03           C  
ATOM   1032  C   LYS    41      -5.786  74.622  46.516  1.00 24.80           C  
ATOM   1033  O   LYS    41      -5.121  73.627  46.222  1.00 24.41           O  
ATOM   1034  CB  LYS    41      -5.525  75.756  48.725  1.00 26.17           C  
ATOM   1035  CG  LYS    41      -5.211  74.458  49.459  1.00 31.58           C  
ATOM   1036  CD  LYS    41      -5.774  74.499  50.886  1.00 33.11           C  
ATOM   1037  CE  LYS    41      -5.347  73.283  51.704  1.00 42.88           C  
ATOM   1038  NZ  LYS    41      -5.846  73.354  53.109  1.00 41.08           N  
ATOM   1039  N   THR    42      -7.074  74.738  46.237  1.00 24.70           N  
ATOM   1040  CA  THR    42      -7.798  73.688  45.520  1.00 23.81           C  
ATOM   1041  C   THR    42      -7.217  73.448  44.133  1.00 24.23           C  
ATOM   1042  O   THR    42      -7.022  72.317  43.719  1.00 23.25           O  
ATOM   1043  CB  THR    42      -9.301  73.985  45.416  1.00 24.82           C  
ATOM   1044  OG1 THR    42      -9.845  74.084  46.733  1.00 25.22           O  
ATOM   1045  CG2 THR    42     -10.038  72.883  44.667  1.00 25.77           C  
ATOM   1046  N   GLN    43      -6.933  74.527  43.418  1.00 23.43           N  
ATOM   1047  CA  GLN    43      -6.319  74.414  42.118  1.00 22.86           C  
ATOM   1048  C   GLN    43      -4.922  73.781  42.157  1.00 23.94           C  
ATOM   1049  O   GLN    43      -4.585  73.025  41.268  1.00 22.91           O  
ATOM   1050  CB  GLN    43      -6.246  75.772  41.437  1.00 24.01           C  
ATOM   1051  CG  GLN    43      -7.565  76.328  41.029  1.00 22.72           C  
ATOM   1052  CD  GLN    43      -7.399  77.608  40.263  1.00 23.02           C  
ATOM   1053  OE1 GLN    43      -6.876  78.573  40.809  1.00 25.62           O  
ATOM   1054  NE2 GLN    43      -7.853  77.631  39.000  1.00 24.23           N  
ATOM   1055  N   LYS    44      -4.119  74.119  43.152  1.00 23.49           N  
ATOM   1056  CA  LYS    44      -2.798  73.504  43.293  1.00 22.94           C  
ATOM   1057  C   LYS    44      -2.885  72.010  43.618  1.00 23.73           C  
ATOM   1058  O   LYS    44      -2.073  71.231  43.139  1.00 23.97           O  
ATOM   1059  CB  LYS    44      -1.964  74.236  44.353  1.00 26.12           C  
ATOM   1060  CG  LYS    44      -1.383  75.517  43.796  1.00 37.14           C  
ATOM   1061  CD  LYS    44      -0.199  75.250  42.854  1.00 40.63           C  
ATOM   1062  CE  LYS    44       0.270  76.569  42.238  1.00 46.64           C  
ATOM   1063  NZ  LYS    44       1.409  76.414  41.283  1.00 41.05           N  
ATOM   1064  N   LEU    45      -3.875  71.626  44.416  1.00 22.77           N  
ATOM   1065  CA  LEU    45      -4.158  70.192  44.683  1.00 22.94           C  
ATOM   1066  C   LEU    45      -4.528  69.448  43.403  1.00 20.00           C  
ATOM   1067  O   LEU    45      -4.064  68.333  43.149  1.00 21.82           O  
ATOM   1068  CB  LEU    45      -5.255  70.034  45.759  1.00 24.89           C  
ATOM   1069  CG  LEU    45      -4.872  70.484  47.179  1.00 24.96           C  
ATOM   1070  CD1 LEU    45      -6.093  70.532  48.099  1.00 25.24           C  
ATOM   1071  CD2 LEU    45      -3.795  69.570  47.786  1.00 26.64           C  
ATOM   1072  N   ILE    46      -5.331  70.092  42.557  1.00 20.74           N  
ATOM   1073  CA  ILE    46      -5.651  69.564  41.249  1.00 21.62           C  
ATOM   1074  C   ILE    46      -4.391  69.407  40.390  1.00 20.78           C  
ATOM   1075  O   ILE    46      -4.202  68.383  39.737  1.00 21.91           O  
ATOM   1076  CB  ILE    46      -6.704  70.453  40.547  1.00 22.08           C  
ATOM   1077  CG1 ILE    46      -8.055  70.378  41.275  1.00 24.84           C  
ATOM   1078  CG2 ILE    46      -6.892  70.056  39.052  1.00 22.38           C  
ATOM   1079  CD1 ILE    46      -9.010  71.552  40.931  1.00 22.86           C  
ATOM   1080  N   ALA    47      -3.523  70.426  40.416  1.00 21.87           N  
ATOM   1081  CA  ALA    47      -2.279  70.384  39.643  1.00 21.24           C  
ATOM   1082  C   ALA    47      -1.416  69.194  40.090  1.00 21.15           C  
ATOM   1083  O   ALA    47      -0.852  68.486  39.264  1.00 23.10           O  
ATOM   1084  CB  ALA    47      -1.507  71.727  39.768  1.00 21.67           C  
ATOM   1085  N   ILE    48      -1.326  68.971  41.401  1.00 23.22           N  
ATOM   1086  CA  ILE    48      -0.581  67.815  41.934  1.00 23.42           C  
ATOM   1087  C   ILE    48      -1.151  66.535  41.379  1.00 22.45           C  
ATOM   1088  O   ILE    48      -0.412  65.683  40.917  1.00 22.38           O  
ATOM   1089  CB  ILE    48      -0.565  67.783  43.480  1.00 22.22           C  
ATOM   1090  CG1 ILE    48       0.257  68.942  44.048  1.00 26.05           C  
ATOM   1091  CG2 ILE    48       0.049  66.452  44.023  1.00 25.18           C  
ATOM   1092  CD1 ILE    48      -0.059  69.242  45.504  1.00 25.14           C  
ATOM   1093  N   GLY    49      -2.485  66.395  41.436  1.00 23.64           N  
ATOM   1094  CA  GLY    49      -3.152  65.223  40.890  1.00 22.69           C  
ATOM   1095  C   GLY    49      -2.810  64.948  39.439  1.00 22.13           C  
ATOM   1096  O   GLY    49      -2.514  63.817  39.044  1.00 22.25           O  
ATOM   1097  N   ILE    50      -2.858  65.995  38.620  1.00 21.97           N  
ATOM   1098  CA  ILE    50      -2.611  65.842  37.209  1.00 23.22           C  
ATOM   1099  C   ILE    50      -1.179  65.410  36.958  1.00 20.30           C  
ATOM   1100  O   ILE    50      -0.936  64.483  36.198  1.00 22.58           O  
ATOM   1101  CB  ILE    50      -2.928  67.132  36.415  1.00 23.33           C  
ATOM   1102  CG1 ILE    50      -4.446  67.402  36.425  1.00 25.36           C  
ATOM   1103  CG2 ILE    50      -2.410  67.043  34.958  1.00 25.70           C  
ATOM   1104  CD1 ILE    50      -4.873  68.780  35.946  1.00 23.40           C  
ATOM   1105  N   VAL    51      -0.226  66.112  37.554  1.00 22.13           N  
ATOM   1106  CA  VAL    51       1.198  65.805  37.361  0.50 22.96           C  
ATOM   1108  C   VAL    51       1.534  64.410  37.901  1.00 22.59           C  
ATOM   1109  O   VAL    51       2.294  63.639  37.290  1.00 23.85           O  
ATOM   1110  CB  VAL    51       2.072  66.864  38.052  0.50 23.96           C  
ATOM   1112  CG1 VAL    51       3.558  66.521  37.912  0.50 22.52           C  
ATOM   1114  CG2 VAL    51       1.793  68.268  37.453  0.50 24.56           C  
ATOM   1116  N   ALA    52       0.940  64.069  39.051  1.00 21.97           N  
ATOM   1117  CA  ALA    52       1.198  62.761  39.646  1.00 22.83           C  
ATOM   1118  C   ALA    52       0.615  61.626  38.821  1.00 24.96           C  
ATOM   1119  O   ALA    52       1.057  60.489  38.972  1.00 27.05           O  
ATOM   1120  CB  ALA    52       0.708  62.681  41.110  1.00 22.19           C  
ATOM   1121  N   SER    53      -0.366  61.908  37.962  1.00 23.44           N  
ATOM   1122  CA  SER    53      -0.993  60.900  37.128  0.50 24.03           C  
ATOM   1124  C   SER    53      -0.070  60.482  35.984  1.00 28.22           C  
ATOM   1125  O   SER    53      -0.306  59.463  35.352  1.00 29.44           O  
ATOM   1126  CB  SER    53      -2.358  61.369  36.590  0.50 24.46           C  
ATOM   1128  OG  SER    53      -2.273  62.367  35.572  0.50 17.33           O  
ATOM   1130  N   ARG    54       0.967  61.288  35.750  1.00 27.88           N  
ATOM   1131  CA  ARG    54       1.961  61.079  34.686  1.00 36.49           C  
ATOM   1132  C   ARG    54       3.323  60.666  35.269  1.00 42.51           C  
ATOM   1133  O   ARG    54       3.434  60.416  36.472  1.00 42.98           O  
ATOM   1134  CB  ARG    54       2.061  62.360  33.864  1.00 36.62           C  
ATOM   1135  CG  ARG    54       0.682  62.788  33.371  1.00 36.07           C  
ATOM   1136  CD  ARG    54       0.720  63.747  32.220  1.00 46.03           C  
ATOM   1137  NE  ARG    54       1.186  65.048  32.671  1.00 47.58           N  
ATOM   1138  CZ  ARG    54       0.593  66.218  32.427  1.00 48.31           C  
ATOM   1139  NH1 ARG    54      -0.539  66.301  31.716  1.00 41.50           N  
ATOM   1140  NH2 ARG    54       1.152  67.314  32.919  1.00 45.55           N  
ATOM   1141  N   CYS    55       4.364  60.567  34.441  1.00 47.81           N  
ATOM   1142  CA  CYS    55       5.609  59.917  34.908  1.00 53.06           C  
ATOM   1143  C   CYS    55       6.714  60.870  35.342  1.00 53.53           C  
ATOM   1144  O   CYS    55       7.760  60.423  35.818  1.00 55.63           O  
ATOM   1145  CB  CYS    55       6.175  58.963  33.844  1.00 54.41           C  
ATOM   1146  SG  CYS    55       4.966  57.829  33.125  1.00 70.70           S  
ATOM   1147  N   ASP    56       6.510  62.170  35.183  1.00 51.11           N  
ATOM   1148  CA  ASP    56       7.593  63.097  35.442  1.00 50.75           C  
ATOM   1149  C   ASP    56       7.796  63.237  36.966  1.00 47.60           C  
ATOM   1150  O   ASP    56       7.187  64.093  37.608  1.00 47.73           O  
ATOM   1151  CB  ASP    56       7.335  64.451  34.744  1.00 51.45           C  
ATOM   1152  CG  ASP    56       8.549  65.360  34.751  1.00 55.00           C  
ATOM   1153  OD1 ASP    56       9.598  64.950  35.298  1.00 59.75           O  
ATOM   1154  OD2 ASP    56       8.445  66.490  34.211  1.00 56.95           O  
ATOM   1155  N   GLU    57       8.662  62.376  37.505  1.00 44.76           N  
ATOM   1156  CA  GLU    57       9.079  62.384  38.919  1.00 44.68           C  
ATOM   1157  C   GLU    57       9.555  63.747  39.434  1.00 43.54           C  
ATOM   1158  O   GLU    57       9.225  64.151  40.554  1.00 39.20           O  
ATOM   1159  CB  GLU    57      10.193  61.362  39.121  1.00 44.24           C  
ATOM   1160  CG  GLU    57      10.658  61.181  40.556  1.00 49.33           C  
ATOM   1161  N   VAL    58      10.342  64.453  38.623  1.00 44.25           N  
ATOM   1162  CA  VAL    58      10.846  65.761  39.019  1.00 41.66           C  
ATOM   1163  C   VAL    58       9.712  66.771  39.079  1.00 39.99           C  
ATOM   1164  O   VAL    58       9.637  67.563  40.023  1.00 40.88           O  
ATOM   1165  CB  VAL    58      12.003  66.255  38.076  1.00 44.98           C  
ATOM   1166  N   ALA    59       8.820  66.732  38.092  1.00 36.00           N  
ATOM   1167  CA  ALA    59       7.624  67.563  38.085  1.00 36.40           C  
ATOM   1168  C   ALA    59       6.746  67.291  39.314  1.00 34.21           C  
ATOM   1169  O   ALA    59       6.208  68.222  39.935  1.00 33.66           O  
ATOM   1170  CB  ALA    59       6.840  67.324  36.816  1.00 37.99           C  
ATOM   1171  N   ILE    60       6.614  66.013  39.667  1.00 31.22           N  
ATOM   1172  CA  ILE    60       5.812  65.647  40.839  1.00 28.82           C  
ATOM   1173  C   ILE    60       6.454  66.198  42.119  1.00 27.71           C  
ATOM   1174  O   ILE    60       5.781  66.867  42.913  1.00 27.90           O  
ATOM   1175  CB  ILE    60       5.613  64.129  40.959  1.00 27.95           C  
ATOM   1176  CG1 ILE    60       4.862  63.584  39.742  1.00 27.51           C  
ATOM   1177  CG2 ILE    60       4.812  63.808  42.224  1.00 26.18           C  
ATOM   1178  CD1 ILE    60       4.987  62.071  39.545  1.00 25.07           C  
ATOM   1179  N   GLU    61       7.741  65.915  42.319  1.00 30.04           N  
ATOM   1180  CA  GLU    61       8.460  66.430  43.501  1.00 32.80           C  
ATOM   1181  C   GLU    61       8.345  67.964  43.626  1.00 35.05           C  
ATOM   1182  O   GLU    61       8.090  68.492  44.715  1.00 33.59           O  
ATOM   1183  CB  GLU    61       9.925  65.988  43.468  1.00 33.45           C  
ATOM   1184  CG  GLU    61      10.720  66.333  44.743  1.00 36.55           C  
ATOM   1185  N   LYS    62       8.492  68.665  42.503  1.00 38.76           N  
ATOM   1186  CA  LYS    62       8.430  70.135  42.479  1.00 39.30           C  
ATOM   1187  C   LYS    62       7.040  70.681  42.772  1.00 38.68           C  
ATOM   1188  O   LYS    62       6.906  71.655  43.526  1.00 36.68           O  
ATOM   1189  CB  LYS    62       8.919  70.670  41.123  1.00 42.11           C  
ATOM   1190  N   GLN    63       5.995  70.076  42.198  1.00 35.90           N  
ATOM   1191  CA  GLN    63       4.635  70.517  42.512  1.00 36.26           C  
ATOM   1192  C   GLN    63       4.355  70.313  43.989  1.00 33.33           C  
ATOM   1193  O   GLN    63       3.755  71.165  44.626  1.00 33.91           O  
ATOM   1194  CB  GLN    63       3.548  69.798  41.676  1.00 39.20           C  
ATOM   1195  CG  GLN    63       3.160  70.466  40.335  1.00 44.45           C  
ATOM   1196  CD  GLN    63       2.333  71.749  40.478  1.00 44.95           C  
ATOM   1197  OE1 GLN    63       1.712  72.008  41.510  1.00 62.12           O  
ATOM   1198  NE2 GLN    63       2.315  72.547  39.425  1.00 63.66           N  
ATOM   1199  N   MET    64       4.752  69.161  44.531  1.00 30.47           N  
ATOM   1200  CA  MET    64       4.471  68.856  45.916  1.00 26.68           C  
ATOM   1201  C   MET    64       5.225  69.810  46.838  1.00 29.86           C  
ATOM   1202  O   MET    64       4.645  70.361  47.788  1.00 28.23           O  
ATOM   1203  CB  MET    64       4.864  67.412  46.233  1.00 23.18           C  
ATOM   1204  CG  MET    64       3.918  66.370  45.589  1.00 22.57           C  
ATOM   1205  SD  MET    64       4.418  64.644  46.195  0.75 22.23          SE  
ATOM   1206  CE  MET    64       3.056  63.632  45.253  1.00 22.00           C  
ATOM   1207  N   LYS    65       6.514  69.998  46.544  1.00 32.32           N  
ATOM   1208  CA  LYS    65       7.386  70.856  47.371  1.00 34.88           C  
ATOM   1209  C   LYS    65       6.857  72.284  47.412  1.00 34.19           C  
ATOM   1210  O   LYS    65       6.702  72.863  48.483  1.00 35.31           O  
ATOM   1211  CB  LYS    65       8.826  70.843  46.843  1.00 35.46           C  
ATOM   1212  CG  LYS    65       9.625  69.629  47.243  1.00 40.38           C  
ATOM   1213  N   SER    66       6.564  72.836  46.245  1.00 36.71           N  
ATOM   1214  CA  SER    66       6.041  74.200  46.142  0.50 37.97           C  
ATOM   1216  C   SER    66       4.709  74.361  46.864  1.00 39.15           C  
ATOM   1217  O   SER    66       4.486  75.342  47.552  1.00 40.37           O  
ATOM   1218  CB  SER    66       5.895  74.618  44.676  0.50 38.61           C  
ATOM   1220  OG  SER    66       5.090  73.703  43.950  0.50 37.08           O  
ATOM   1222  N   ALA    67       3.815  73.392  46.707  1.00 37.33           N  
ATOM   1223  CA  ALA    67       2.536  73.447  47.409  1.00 35.90           C  
ATOM   1224  C   ALA    67       2.708  73.505  48.921  1.00 33.63           C  
ATOM   1225  O   ALA    67       2.000  74.242  49.614  1.00 33.38           O  
ATOM   1226  CB  ALA    67       1.675  72.239  47.036  1.00 35.08           C  
ATOM   1227  N   MET    68       3.620  72.690  49.440  1.00 32.12           N  
ATOM   1228  CA  MET    68       3.809  72.592  50.861  1.00 32.59           C  
ATOM   1229  C   MET    68       4.455  73.891  51.335  1.00 33.83           C  
ATOM   1230  O   MET    68       4.036  74.457  52.332  1.00 35.23           O  
ATOM   1231  CB  MET    68       4.684  71.396  51.205  1.00 33.38           C  
ATOM   1232  CG  MET    68       4.027  70.041  50.923  1.00 33.32           C  
ATOM   1233  SD  MET    68       5.192  68.597  51.472  0.75 34.95          SE  
ATOM   1234  CE  MET    68       4.864  68.765  53.369  1.00 39.85           C  
ATOM   1235  N   LYS    69       5.428  74.370  50.567  1.00 35.03           N  
ATOM   1236  CA  LYS    69       6.210  75.565  50.936  1.00 37.33           C  
ATOM   1237  C   LYS    69       5.376  76.830  50.796  1.00 38.14           C  
ATOM   1238  O   LYS    69       5.218  77.585  51.764  1.00 42.29           O  
ATOM   1239  CB  LYS    69       7.470  75.676  50.075  1.00 36.02           C  
ATOM   1240  N   GLU    70       4.833  77.048  49.606  1.00 39.17           N  
ATOM   1241  CA  GLU    70       4.066  78.262  49.302  1.00 40.19           C  
ATOM   1242  C   GLU    70       2.697  78.317  49.975  1.00 40.34           C  
ATOM   1243  O   GLU    70       2.343  79.342  50.543  1.00 42.02           O  
ATOM   1244  CB  GLU    70       3.909  78.452  47.786  1.00 39.25           C  
ATOM   1245  N   LEU    71       1.936  77.226  49.937  1.00 39.71           N  
ATOM   1246  CA  LEU    71       0.552  77.239  50.424  1.00 38.07           C  
ATOM   1247  C   LEU    71       0.339  76.549  51.771  1.00 34.95           C  
ATOM   1248  O   LEU    71      -0.765  76.565  52.307  1.00 37.25           O  
ATOM   1249  CB  LEU    71      -0.380  76.601  49.371  1.00 39.04           C  
ATOM   1250  CG  LEU    71      -0.453  77.252  47.981  1.00 43.95           C  
ATOM   1251  CD1 LEU    71       0.756  76.880  47.115  1.00 50.69           C  
ATOM   1252  CD2 LEU    71      -1.736  76.876  47.251  1.00 39.57           C  
ATOM   1253  N   GLY    72       1.355  75.907  52.325  1.00 31.62           N  
ATOM   1254  CA  GLY    72       1.147  75.169  53.571  1.00 31.33           C  
ATOM   1255  C   GLY    72       0.288  73.914  53.427  1.00 30.39           C  
ATOM   1256  O   GLY    72      -0.302  73.424  54.405  1.00 31.58           O  
ATOM   1257  N   ILE    73       0.217  73.377  52.213  1.00 32.06           N  
ATOM   1258  CA  ILE    73      -0.496  72.104  51.983  1.00 28.57           C  
ATOM   1259  C   ILE    73       0.221  70.989  52.779  1.00 29.16           C  
ATOM   1260  O   ILE    73       1.450  70.986  52.850  1.00 29.32           O  
ATOM   1261  CB  ILE    73      -0.621  71.840  50.468  1.00 30.50           C  
ATOM   1262  CG1 ILE    73      -1.744  72.732  49.891  1.00 27.84           C  
ATOM   1263  CG2 ILE    73      -0.867  70.336  50.174  1.00 25.19           C  
ATOM   1264  CD1 ILE    73      -1.816  72.820  48.371  1.00 30.38           C  
ATOM   1265  N   THR    74      -0.530  70.088  53.420  1.00 27.36           N  
ATOM   1266  CA  THR    74       0.088  69.024  54.242  1.00 27.26           C  
ATOM   1267  C   THR    74       0.356  67.745  53.462  1.00 27.58           C  
ATOM   1268  O   THR    74      -0.238  67.522  52.416  1.00 24.17           O  
ATOM   1269  CB  THR    74      -0.757  68.627  55.460  1.00 29.19           C  
ATOM   1270  OG1 THR    74      -2.004  68.099  55.031  1.00 28.81           O  
ATOM   1271  CG2 THR    74      -0.971  69.880  56.480  1.00 28.98           C  
ATOM   1272  N   LYS    75       1.211  66.876  53.997  1.00 26.69           N  
ATOM   1273  CA  LYS    75       1.408  65.575  53.357  1.00 24.94           C  
ATOM   1274  C   LYS    75       0.105  64.766  53.394  1.00 24.97           C  
ATOM   1275  O   LYS    75      -0.183  64.049  52.430  1.00 24.26           O  
ATOM   1276  CB  LYS    75       2.547  64.787  54.001  1.00 25.92           C  
ATOM   1277  CG  LYS    75       3.941  65.377  53.781  1.00 25.04           C  
ATOM   1278  CD  LYS    75       5.016  64.369  54.207  1.00 27.40           C  
ATOM   1279  CE  LYS    75       6.395  64.744  53.675  1.00 30.74           C  
ATOM   1280  NZ  LYS    75       7.337  63.582  53.770  1.00 29.47           N  
ATOM   1281  N   GLU    76      -0.705  64.923  54.456  1.00 23.62           N  
ATOM   1282  CA  GLU    76      -2.006  64.250  54.537  1.00 27.19           C  
ATOM   1283  C   GLU    76      -2.963  64.703  53.418  1.00 22.94           C  
ATOM   1284  O   GLU    76      -3.670  63.897  52.828  1.00 25.59           O  
ATOM   1285  CB  GLU    76      -2.676  64.495  55.897  1.00 28.02           C  
ATOM   1286  CG  GLU    76      -3.944  63.646  56.101  1.00 35.01           C  
ATOM   1287  CD  GLU    76      -4.602  63.869  57.467  1.00 37.01           C  
ATOM   1288  OE1 GLU    76      -4.541  65.017  57.990  1.00 52.64           O  
ATOM   1289  OE2 GLU    76      -5.167  62.883  58.002  1.00 48.87           O  
ATOM   1290  N   GLU    77      -2.974  65.994  53.116  1.00 24.57           N  
ATOM   1291  CA  GLU    77      -3.774  66.494  52.000  1.00 24.63           C  
ATOM   1292  C   GLU    77      -3.272  65.945  50.656  1.00 24.30           C  
ATOM   1293  O   GLU    77      -4.068  65.546  49.803  1.00 23.45           O  
ATOM   1294  CB  GLU    77      -3.785  68.017  51.965  1.00 25.09           C  
ATOM   1295  CG  GLU    77      -4.555  68.632  53.117  1.00 28.85           C  
ATOM   1296  CD  GLU    77      -4.410  70.153  53.229  1.00 30.84           C  
ATOM   1297  OE1 GLU    77      -3.353  70.735  52.878  1.00 33.27           O  
ATOM   1298  OE2 GLU    77      -5.388  70.777  53.674  1.00 33.37           O  
ATOM   1299  N   ILE    78      -1.955  65.938  50.475  1.00 24.49           N  
ATOM   1300  CA  ILE    78      -1.378  65.340  49.262  1.00 23.04           C  
ATOM   1301  C   ILE    78      -1.725  63.851  49.134  1.00 21.63           C  
ATOM   1302  O   ILE    78      -2.100  63.380  48.059  1.00 21.32           O  
ATOM   1303  CB  ILE    78       0.162  65.600  49.123  1.00 22.33           C  
ATOM   1304  CG1 ILE    78       0.452  67.103  49.059  1.00 25.20           C  
ATOM   1305  CG2 ILE    78       0.697  64.957  47.836  1.00 21.31           C  
ATOM   1306  CD1 ILE    78       1.911  67.437  49.205  1.00 24.12           C  
ATOM   1307  N   ALA    79      -1.679  63.116  50.236  1.00 22.41           N  
ATOM   1308  CA  ALA    79      -2.026  61.718  50.200  1.00 20.30           C  
ATOM   1309  C   ALA    79      -3.467  61.520  49.727  1.00 21.42           C  
ATOM   1310  O   ALA    79      -3.749  60.611  48.966  1.00 20.43           O  
ATOM   1311  CB  ALA    79      -1.797  61.071  51.552  1.00 22.66           C  
ATOM   1312  N   ASP    80      -4.374  62.409  50.130  1.00 20.93           N  
ATOM   1313  CA  ASP    80      -5.762  62.331  49.652  1.00 20.26           C  
ATOM   1314  C   ASP    80      -5.885  62.593  48.155  1.00 22.81           C  
ATOM   1315  O   ASP    80      -6.734  62.009  47.494  1.00 22.27           O  
ATOM   1316  CB  ASP    80      -6.667  63.310  50.395  1.00 20.14           C  
ATOM   1317  CG  ASP    80      -7.045  62.853  51.807  1.00 23.19           C  
ATOM   1318  OD1 ASP    80      -6.928  61.652  52.156  1.00 25.42           O  
ATOM   1319  OD2 ASP    80      -7.525  63.728  52.549  1.00 28.27           O  
ATOM   1320  N   VAL    81      -5.043  63.483  47.619  1.00 21.25           N  
ATOM   1321  CA  VAL    81      -4.939  63.659  46.181  1.00 22.27           C  
ATOM   1322  C   VAL    81      -4.492  62.341  45.520  1.00 20.03           C  
ATOM   1323  O   VAL    81      -5.078  61.898  44.508  1.00 19.50           O  
ATOM   1324  CB  VAL    81      -3.963  64.805  45.817  1.00 20.90           C  
ATOM   1325  CG1 VAL    81      -3.757  64.895  44.302  1.00 22.88           C  
ATOM   1326  CG2 VAL    81      -4.425  66.168  46.443  1.00 20.83           C  
ATOM   1327  N   LEU    82      -3.519  61.673  46.131  1.00 20.16           N  
ATOM   1328  CA  LEU    82      -2.954  60.455  45.560  1.00 19.84           C  
ATOM   1329  C   LEU    82      -3.955  59.291  45.560  1.00 18.54           C  
ATOM   1330  O   LEU    82      -3.913  58.425  44.676  1.00 19.11           O  
ATOM   1331  CB  LEU    82      -1.666  60.090  46.263  1.00 20.98           C  
ATOM   1332  CG  LEU    82      -0.551  61.135  46.146  1.00 20.66           C  
ATOM   1333  CD1 LEU    82       0.766  60.558  46.671  1.00 21.28           C  
ATOM   1334  CD2 LEU    82      -0.392  61.639  44.674  1.00 22.33           C  
ATOM   1335  N   ARG    83      -4.911  59.309  46.495  1.00 20.31           N  
ATOM   1336  CA  ARG    83      -5.991  58.304  46.463  1.00 21.39           C  
ATOM   1337  C   ARG    83      -6.744  58.386  45.139  1.00 20.18           C  
ATOM   1338  O   ARG    83      -7.025  57.394  44.468  1.00 19.30           O  
ATOM   1339  CB  ARG    83      -6.940  58.521  47.643  1.00 22.29           C  
ATOM   1340  CG  ARG    83      -6.321  58.269  48.999  1.00 22.30           C  
ATOM   1341  CD  ARG    83      -7.215  58.747  50.124  1.00 28.97           C  
ATOM   1342  NE  ARG    83      -8.051  57.695  50.628  1.00 33.52           N  
ATOM   1343  CZ  ARG    83      -7.790  56.938  51.696  1.00 23.68           C  
ATOM   1344  NH1 ARG    83      -6.703  57.064  52.438  1.00 32.40           N  
ATOM   1345  NH2 ARG    83      -8.646  56.031  52.018  1.00 24.82           N  
ATOM   1346  N   VAL    84      -7.007  59.612  44.712  1.00 19.60           N  
ATOM   1347  CA  VAL    84      -7.659  59.856  43.423  1.00 20.32           C  
ATOM   1348  C   VAL    84      -6.772  59.472  42.241  1.00 20.03           C  
ATOM   1349  O   VAL    84      -7.255  58.901  41.275  1.00 20.48           O  
ATOM   1350  CB  VAL    84      -8.137  61.322  43.296  1.00 21.39           C  
ATOM   1351  CG1 VAL    84      -8.987  61.511  41.998  1.00 22.27           C  
ATOM   1352  CG2 VAL    84      -8.967  61.726  44.539  1.00 22.62           C  
ATOM   1353  N   VAL    85      -5.467  59.765  42.311  1.00 19.59           N  
ATOM   1354  CA  VAL    85      -4.526  59.262  41.308  1.00 19.33           C  
ATOM   1355  C   VAL    85      -4.607  57.748  41.150  1.00 19.40           C  
ATOM   1356  O   VAL    85      -4.616  57.261  40.035  1.00 20.61           O  
ATOM   1357  CB  VAL    85      -3.073  59.710  41.615  1.00 19.39           C  
ATOM   1358  CG1 VAL    85      -2.070  59.082  40.659  1.00 17.94           C  
ATOM   1359  CG2 VAL    85      -2.997  61.250  41.539  1.00 21.42           C  
ATOM   1360  N   LEU    86      -4.650  56.998  42.252  1.00 19.33           N  
ATOM   1361  CA  LEU    86      -4.777  55.548  42.161  1.00 19.79           C  
ATOM   1362  C   LEU    86      -6.014  55.159  41.363  1.00 18.98           C  
ATOM   1363  O   LEU    86      -5.940  54.357  40.454  1.00 20.03           O  
ATOM   1364  CB  LEU    86      -4.858  54.924  43.555  1.00 21.20           C  
ATOM   1365  CG  LEU    86      -5.184  53.439  43.651  1.00 21.99           C  
ATOM   1366  CD1 LEU    86      -4.133  52.600  42.959  1.00 24.06           C  
ATOM   1367  CD2 LEU    86      -5.310  53.065  45.156  1.00 20.62           C  
ATOM   1368  N   LEU    87      -7.154  55.734  41.711  1.00 20.94           N  
ATOM   1369  CA  LEU    87      -8.412  55.347  41.065  1.00 21.06           C  
ATOM   1370  C   LEU    87      -8.447  55.701  39.591  1.00 21.01           C  
ATOM   1371  O   LEU    87      -8.981  54.948  38.793  1.00 22.38           O  
ATOM   1372  CB  LEU    87      -9.577  56.046  41.769  1.00 23.55           C  
ATOM   1373  CG  LEU    87     -10.992  55.596  41.405  1.00 25.01           C  
ATOM   1374  CD1 LEU    87     -11.291  54.169  41.742  1.00 30.38           C  
ATOM   1375  CD2 LEU    87     -11.944  56.517  42.180  1.00 27.84           C  
ATOM   1376  N   THR    88      -7.906  56.874  39.258  1.00 21.25           N  
ATOM   1377  CA  THR    88      -7.927  57.375  37.879  1.00 21.88           C  
ATOM   1378  C   THR    88      -6.816  56.833  36.983  1.00 22.77           C  
ATOM   1379  O   THR    88      -6.931  56.837  35.762  1.00 23.28           O  
ATOM   1380  CB  THR    88      -7.874  58.903  37.853  1.00 21.84           C  
ATOM   1381  OG1 THR    88      -6.644  59.350  38.431  1.00 22.90           O  
ATOM   1382  CG2 THR    88      -9.066  59.477  38.541  1.00 25.52           C  
ATOM   1383  N   SER    89      -5.735  56.386  37.602  1.00 20.63           N  
ATOM   1384  CA  SER    89      -4.483  56.227  36.896  1.00 21.58           C  
ATOM   1385  C   SER    89      -3.720  54.942  37.169  1.00 21.03           C  
ATOM   1386  O   SER    89      -2.772  54.629  36.425  1.00 23.05           O  
ATOM   1387  CB  SER    89      -3.575  57.459  37.151  1.00 25.09           C  
ATOM   1388  OG  SER    89      -4.281  58.671  36.880  1.00 24.41           O  
ATOM   1389  N   GLY    90      -4.063  54.215  38.234  1.00 21.98           N  
ATOM   1390  CA  GLY    90      -3.467  52.905  38.482  1.00 20.22           C  
ATOM   1391  C   GLY    90      -2.363  52.897  39.536  1.00 20.13           C  
ATOM   1392  O   GLY    90      -1.942  53.955  40.033  1.00 19.52           O  
ATOM   1393  N   MET    91      -1.913  51.694  39.856  1.00 20.97           N  
ATOM   1394  CA  MET    91      -0.890  51.427  40.886  0.40 24.63           C  
ATOM   1396  C   MET    91       0.459  52.100  40.604  1.00 21.70           C  
ATOM   1397  O   MET    91       1.059  52.724  41.502  1.00 23.86           O  
ATOM   1398  CB  MET    91      -0.619  49.917  41.035  0.40 26.41           C  
ATOM   1400  CG  MET    91      -1.632  49.085  41.765  0.40 29.31           C  
ATOM   1402  SD  MET    91      -0.711  47.905  43.072  0.28 35.75          SE  
ATOM   1404  CE  MET    91      -0.457  49.469  44.218  0.40 21.93           C  
ATOM   1406  N   PRO    92       0.980  51.963  39.373  1.00 21.05           N  
ATOM   1407  CA  PRO    92       2.311  52.563  39.147  1.00 19.88           C  
ATOM   1408  C   PRO    92       2.408  54.050  39.498  1.00 21.02           C  
ATOM   1409  O   PRO    92       3.356  54.485  40.177  1.00 20.96           O  
ATOM   1410  CB  PRO    92       2.572  52.299  37.663  1.00 22.51           C  
ATOM   1411  CG  PRO    92       1.788  51.073  37.374  1.00 20.16           C  
ATOM   1412  CD  PRO    92       0.530  51.210  38.184  1.00 21.39           C  
ATOM   1413  N   ALA    93       1.434  54.836  39.065  1.00 19.14           N  
ATOM   1414  CA  ALA    93       1.460  56.257  39.340  1.00 19.96           C  
ATOM   1415  C   ALA    93       1.300  56.530  40.843  1.00 19.93           C  
ATOM   1416  O   ALA    93       1.977  57.400  41.418  1.00 20.12           O  
ATOM   1417  CB  ALA    93       0.324  56.953  38.551  1.00 22.71           C  
ATOM   1418  N   PHE    94       0.374  55.804  41.457  1.00 18.44           N  
ATOM   1419  CA  PHE    94       0.116  55.937  42.882  1.00 18.79           C  
ATOM   1420  C   PHE    94       1.380  55.638  43.705  1.00 20.05           C  
ATOM   1421  O   PHE    94       1.763  56.426  44.594  1.00 19.06           O  
ATOM   1422  CB  PHE    94      -0.966  54.949  43.301  1.00 20.10           C  
ATOM   1423  CG  PHE    94      -1.232  54.947  44.799  1.00 20.32           C  
ATOM   1424  CD1 PHE    94      -1.802  56.035  45.406  1.00 19.60           C  
ATOM   1425  CD2 PHE    94      -0.904  53.846  45.583  1.00 23.76           C  
ATOM   1426  CE1 PHE    94      -2.066  56.050  46.776  1.00 22.96           C  
ATOM   1427  CE2 PHE    94      -1.154  53.856  46.964  1.00 22.72           C  
ATOM   1428  CZ  PHE    94      -1.722  54.954  47.559  1.00 26.09           C  
ATOM   1429  N   THR    95       2.013  54.508  43.431  1.00 20.55           N  
ATOM   1430  CA  THR    95       3.135  54.077  44.284  1.00 20.94           C  
ATOM   1431  C   THR    95       4.339  55.000  44.073  1.00 20.73           C  
ATOM   1432  O   THR    95       5.018  55.353  45.038  1.00 20.28           O  
ATOM   1433  CB  THR    95       3.494  52.592  44.055  1.00 23.86           C  
ATOM   1434  OG1 THR    95       3.863  52.424  42.701  1.00 24.63           O  
ATOM   1435  CG2 THR    95       2.314  51.685  44.356  1.00 21.43           C  
ATOM   1436  N   LYS    96       4.586  55.442  42.833  1.00 20.08           N  
ATOM   1437  CA  LYS    96       5.679  56.370  42.546  0.50 21.50           C  
ATOM   1439  C   LYS    96       5.460  57.655  43.335  1.00 20.81           C  
ATOM   1440  O   LYS    96       6.378  58.161  43.984  1.00 23.01           O  
ATOM   1441  CB  LYS    96       5.748  56.674  41.040  0.50 23.02           C  
ATOM   1443  CG  LYS    96       6.843  57.658  40.621  0.50 23.87           C  
ATOM   1445  CD  LYS    96       7.014  57.722  39.092  0.50 25.49           C  
ATOM   1447  CE  LYS    96       8.452  58.030  38.704  0.50 32.66           C  
ATOM   1449  NZ  LYS    96       9.333  56.844  38.868  0.50 30.31           N  
ATOM   1451  N   ALA    97       4.244  58.190  43.262  1.00 19.16           N  
ATOM   1452  CA  ALA    97       3.898  59.469  43.921  1.00 19.50           C  
ATOM   1453  C   ALA    97       3.968  59.374  45.441  1.00 20.63           C  
ATOM   1454  O   ALA    97       4.463  60.306  46.135  1.00 20.71           O  
ATOM   1455  CB  ALA    97       2.498  59.945  43.472  1.00 19.41           C  
ATOM   1456  N   MET    98       3.499  58.244  45.974  1.00 19.58           N  
ATOM   1457  CA  MET    98       3.518  58.034  47.406  1.00 20.80           C  
ATOM   1458  C   MET    98       4.949  58.016  47.898  1.00 21.43           C  
ATOM   1459  O   MET    98       5.235  58.574  48.952  1.00 21.18           O  
ATOM   1460  CB  MET    98       2.812  56.740  47.834  1.00 22.05           C  
ATOM   1461  CG  MET    98       1.348  56.831  48.010  1.00 30.57           C  
ATOM   1462  SD  MET    98       0.764  58.016  49.491  0.75 32.27          SE  
ATOM   1463  CE  MET    98       1.937  58.044  50.314  1.00  8.65           C  
ATOM   1464  N   LYS    99       5.840  57.362  47.159  1.00 20.17           N  
ATOM   1465  CA  LYS    99       7.263  57.318  47.526  1.00 20.82           C  
ATOM   1466  C   LYS    99       7.928  58.695  47.534  1.00 21.61           C  
ATOM   1467  O   LYS    99       8.729  59.015  48.429  1.00 22.41           O  
ATOM   1468  CB  LYS    99       8.015  56.361  46.599  1.00 19.98           C  
ATOM   1469  CG  LYS    99       9.522  56.268  46.893  1.00 23.11           C  
ATOM   1470  N   ILE   100       7.602  59.501  46.536  1.00 22.47           N  
ATOM   1471  CA  ILE   100       8.072  60.874  46.456  1.00 23.27           C  
ATOM   1472  C   ILE   100       7.553  61.687  47.656  1.00 24.13           C  
ATOM   1473  O   ILE   100       8.325  62.413  48.299  1.00 23.84           O  
ATOM   1474  CB  ILE   100       7.652  61.544  45.136  1.00 22.91           C  
ATOM   1475  CG1 ILE   100       8.324  60.868  43.926  1.00 22.73           C  
ATOM   1476  CG2 ILE   100       7.973  63.043  45.152  1.00 21.99           C  
ATOM   1477  CD1 ILE   100       7.717  61.279  42.573  1.00 25.00           C  
ATOM   1478  N   LEU   101       6.269  61.540  47.970  1.00 21.64           N  
ATOM   1479  CA  LEU   101       5.660  62.247  49.106  1.00 23.29           C  
ATOM   1480  C   LEU   101       6.347  61.878  50.406  1.00 23.75           C  
ATOM   1481  O   LEU   101       6.624  62.756  51.240  1.00 22.26           O  
ATOM   1482  CB  LEU   101       4.155  61.935  49.207  1.00 22.94           C  
ATOM   1483  CG  LEU   101       3.386  62.589  50.364  1.00 23.09           C  
ATOM   1484  CD1 LEU   101       3.489  64.134  50.332  1.00 23.78           C  
ATOM   1485  CD2 LEU   101       1.946  62.145  50.275  1.00 22.66           C  
ATOM   1486  N   GLU   102       6.611  60.583  50.578  1.00 22.09           N  
ATOM   1487  CA  GLU   102       7.262  60.059  51.770  1.00 27.09           C  
ATOM   1488  C   GLU   102       8.642  60.680  51.965  1.00 25.97           C  
ATOM   1489  O   GLU   102       9.018  61.019  53.083  1.00 27.53           O  
ATOM   1490  CB  GLU   102       7.399  58.543  51.675  1.00 27.36           C  
ATOM   1491  CG  GLU   102       6.073  57.805  51.782  1.00 34.71           C  
ATOM   1492  CD  GLU   102       6.120  56.363  51.242  1.00 36.54           C  
ATOM   1493  OE1 GLU   102       7.234  55.820  51.027  1.00 45.78           O  
ATOM   1494  OE2 GLU   102       5.022  55.775  51.058  1.00 44.93           O  
ATOM   1495  N   LYS   103       9.388  60.834  50.880  1.00 25.11           N  
ATOM   1496  CA  LYS   103      10.773  61.333  50.951  1.00 28.56           C  
ATOM   1497  C   LYS   103      10.847  62.862  51.111  1.00 31.51           C  
ATOM   1498  O   LYS   103      11.911  63.419  51.414  1.00 33.51           O  
ATOM   1499  CB  LYS   103      11.571  60.887  49.714  1.00 29.59           C  
ATOM   1500  CG  LYS   103      11.820  59.386  49.621  1.00 32.01           C  
ATOM   1501  N   LEU   104       9.727  63.543  50.933  1.00 31.51           N  
ATOM   1502  CA  LEU   104       9.711  64.997  51.021  1.00 35.23           C  
ATOM   1503  C   LEU   104       9.855  65.493  52.451  1.00 36.78           C  
ATOM   1504  O   LEU   104       9.406  64.849  53.400  1.00 36.92           O  
ATOM   1505  CB  LEU   104       8.441  65.570  50.389  1.00 34.06           C  
ATOM   1506  CG  LEU   104       8.572  65.835  48.898  1.00 34.04           C  
ATOM   1507  CD1 LEU   104       7.311  66.503  48.411  1.00 34.11           C  
ATOM   1508  CD2 LEU   104       9.796  66.702  48.620  1.00 38.61           C  
ATOM   1509  OXT LEU   104      10.441  66.563  52.661  1.00 40.57           O  
END
