
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   89 (  671),  selected   89 , name 3bey_A
# Molecule2: number of CA atoms   98 (  717),  selected   98 , name T0408.pdb
# PARAMETERS: 3bey_A.T0408.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      F       7           -
LGA    -       -      G       8           -
LGA    -       -      E       9           -
LGA    -       -      G      10           -
LGA    -       -      M      11           -
LGA    R     7_A      K      12          4.098
LGA    F     8_A      V      13          2.800
LGA    L     9_A      V      14          0.584
LGA    E    10_A      K      15          3.057
LGA    -       -      E      16           -
LGA    E    11_A      K      17          1.410
LGA    L    12_A      Y      18          1.453
LGA    P    13_A      P      19          1.801
LGA    E    14_A      D      20          1.769
LGA    V    15_A      L      21          1.524
LGA    A    16_A      Y      22          1.496
LGA    E    17_A      D      23          1.218
LGA    S    18_A      I      24          0.885
LGA    F    19_A      I      25          1.046
LGA    K    20_A      V      26          1.201
LGA    N    21_A      K      27          0.917
LGA    F    22_A      L      28          0.634
LGA    R    23_A      N      29          0.873
LGA    E    24_A      D      30          1.010
LGA    A    25_A      T      31          0.754
LGA    V    26_A      V      32          0.567
LGA    R    27_A      F      33          1.352
LGA    S    28_A      T      34          2.121
LGA    E    29_A      G      35          2.219
LGA    G    30_A      K      36          3.072
LGA    K    31_A      T      37          1.954
LGA    L    32_A      L      38          0.788
LGA    T    33_A      D      39          1.194
LGA    E    34_A      Y      40          2.087
LGA    R    35_A      K      41          2.039
LGA    E    36_A      T      42          0.723
LGA    K    37_A      Q      43          1.018
LGA    L    38_A      K      44          1.591
LGA    L    39_A      L      45          0.918
LGA    I    40_A      I      46          0.862
LGA    S    41_A      A      47          1.387
LGA    V    42_A      I      48          1.019
LGA    A    43_A      G      49          0.849
LGA    C    44_A      I      50          1.020
LGA    S    45_A      V      51          1.303
LGA    V    46_A      A      52          0.403
LGA    A    47_A      S      53          0.938
LGA    V    48_A      R      54          2.010
LGA    R    49_A      C      55          2.205
LGA    C    50_A      D      56          1.961
LGA    D    51_A      E      57          2.083
LGA    A    52_A      V      58          2.368
LGA    C    53_A      A      59          2.191
LGA    T    54_A      I      60          1.771
LGA    R    55_A      E      61          1.880
LGA    R    56_A      K      62          2.208
LGA    H    57_A      Q      63          2.009
LGA    A    58_A      M      64          1.255
LGA    E    59_A      K      65          2.143
LGA    E    60_A      S      66          2.543
LGA    A    61_A      A      67          2.288
LGA    L    62_A      M      68          1.826
LGA    E    63_A      K      69          3.151
LGA    -       -      E      70           -
LGA    A    64_A      L      71          2.397
LGA    G    65_A      G      72          3.079
LGA    I    66_A      I      73          2.163
LGA    T    67_A      T      74          1.631
LGA    E    68_A      K      75          0.673
LGA    G    69_A      E      76          1.671
LGA    E    70_A      E      77          1.535
LGA    L    71_A      I      78          0.395
LGA    A    72_A      A      79          1.268
LGA    E    73_A      D      80          1.705
LGA    A    74_A      V      81          0.466
LGA    A    75_A      L      82          1.571
LGA    A    76_A      R      83          2.206
LGA    V    77_A      V      84          0.971
LGA    A    78_A      V      85          1.542
LGA    A    79_A      L      86          2.482
LGA    L    80_A      L      87          1.706
LGA    I    81_A      T      88          1.033
LGA    R    82_A      S      89          1.464
LGA    A    83_A      G      90          3.247
LGA    G    84_A      M      91           -
LGA    S    85_A      P      92           -
LGA    A    86_A      A      93           -
LGA    X    87_A      F      94           -
LGA    N    88_A      T      95           -
LGA    T    89_A      K      96           -
LGA    A    90_A      A      97           -
LGA    S    91_A      M      98           -
LGA    A    92_A      K      99           -
LGA    I    93_A      I     100           -
LGA    F    94_A      L     101           -
LGA    R    95_A      E     102           -
LGA    -       -      K     103           -
LGA    -       -      L     104           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   89   98    5.0     77    1.79    16.88     71.151     4.072

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.527125 * X  +   0.704491 * Y  +   0.475219 * Z  +  -0.749854
  Y_new =   0.312465 * X  +  -0.359362 * Y  +   0.879332 * Z  +  41.843094
  Z_new =   0.790256 * X  +   0.612007 * Y  +  -0.030700 * Z  +  21.745184 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.620918   -1.520675  [ DEG:    92.8718    -87.1282 ]
  Theta =  -0.911227   -2.230365  [ DEG:   -52.2095   -127.7905 ]
  Phi   =   2.606504   -0.535089  [ DEG:   149.3417    -30.6583 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3bey_A                                        
REMARK     2: T0408.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3bey_A.T0408.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   89   98   5.0   77   1.79   16.88  71.151
REMARK  ---------------------------------------------------------- 
MOLECULE 3bey_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   20-NOV-07   3BEY              
TITLE     CRYSTAL STRUCTURE OF THE PROTEIN O27018 FROM                          
TITLE    2 METHANOBACTERIUM THERMOAUTOTROPHICUM. NORTHEAST STRUCTURAL           
TITLE    3 GENOMICS CONSORTIUM TARGET TT217                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CONSERVED PROTEIN O27018;                                  
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: METHANOTHERMOBACTER                             
SOURCE   3 THERMAUTOTROPHICUS STR. DELTA H;                                     
SOURCE   4 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   5 STRAIN: DELTA H;                                                     
SOURCE   6 GENE: MTH935;                                                        
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI                                  
KEYWDS    O27018, X-RAY, TT217, MT935, NESG, STRUCTURAL GENOMICS, PSI-          
KEYWDS   2 2, PROTEIN STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL                
KEYWDS   3 GENOMICS CONSORTIUM, STRUCTURAL GENOMICS, UNKNOWN FUNCTION           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.P.KUZIN,J.GU,X.XU,H.NEELY,F.FOROUHAR,L.OWENS,L.MAO,R.XIAO,          
AUTHOR   2 J.LIU,M.C.BARAN,T.B.ACTON,ROST B.,G.T.MONTELIONE,L.TONG,             
AUTHOR   3 NORTHEAST STRUCTURAL GENOMICS CONSORTIUM (NESG)                      
REVDAT   1   18-DEC-07 3BEY    0                                                
JRNL        AUTH   A.P.KUZIN,J.GU,X.XU,H.NEELY,F.FOROUHAR,L.OWENS,              
JRNL        AUTH 2 L.MAO,R.XIAO,J.LIU,M.C.BARAN,T.B.ACTON,B.ROST,               
JRNL        AUTH 3 G.T.MONTELIONE,L.TONG                                        
JRNL        TITL   CRYSTAL STRUCTURE OF THE PROTEIN O27018 FROM                 
JRNL        TITL 2 METHANOBACTERIUM THERMOAUTOTROPHICUM.                        
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.40 ANGSTROMS.                                          
DBREF  3BEY A    1    96  UNP    O27018   O27018_METTH     1     96             
DBREF  3BEY B    1    96  UNP    O27018   O27018_METTH     1     96             
DBREF  3BEY C    1    96  UNP    O27018   O27018_METTH     1     96             
DBREF  3BEY D    1    96  UNP    O27018   O27018_METTH     1     96             
DBREF  3BEY E    1    96  UNP    O27018   O27018_METTH     1     96             
DBREF  3BEY F    1    96  UNP    O27018   O27018_METTH     1     96             
SEQRES   1 A   96  MSE LYS THR GLY ALA ASP ARG PHE LEU GLU GLU LEU PRO          
SEQRES   2 A   96  GLU VAL ALA GLU SER PHE LYS ASN PHE ARG GLU ALA VAL          
SEQRES   3 A   96  ARG SER GLU GLY LYS LEU THR GLU ARG GLU LYS LEU LEU          
SEQRES   4 A   96  ILE SER VAL ALA CYS SER VAL ALA VAL ARG CYS ASP ALA          
SEQRES   5 A   96  CYS THR ARG ARG HIS ALA GLU GLU ALA LEU GLU ALA GLY          
SEQRES   6 A   96  ILE THR GLU GLY GLU LEU ALA GLU ALA ALA ALA VAL ALA          
SEQRES   7 A   96  ALA LEU ILE ARG ALA GLY SER ALA MSE ASN THR ALA SER          
SEQRES   8 A   96  ALA ILE PHE ARG ASP                                          
SEQRES   1 B   96  MSE LYS THR GLY ALA ASP ARG PHE LEU GLU GLU LEU PRO          
SEQRES   2 B   96  GLU VAL ALA GLU SER PHE LYS ASN PHE ARG GLU ALA VAL          
SEQRES   3 B   96  ARG SER GLU GLY LYS LEU THR GLU ARG GLU LYS LEU LEU          
SEQRES   4 B   96  ILE SER VAL ALA CYS SER VAL ALA VAL ARG CYS ASP ALA          
SEQRES   5 B   96  CYS THR ARG ARG HIS ALA GLU GLU ALA LEU GLU ALA GLY          
SEQRES   6 B   96  ILE THR GLU GLY GLU LEU ALA GLU ALA ALA ALA VAL ALA          
SEQRES   7 B   96  ALA LEU ILE ARG ALA GLY SER ALA MSE ASN THR ALA SER          
SEQRES   8 B   96  ALA ILE PHE ARG ASP                                          
SEQRES   1 C   96  MSE LYS THR GLY ALA ASP ARG PHE LEU GLU GLU LEU PRO          
SEQRES   2 C   96  GLU VAL ALA GLU SER PHE LYS ASN PHE ARG GLU ALA VAL          
SEQRES   3 C   96  ARG SER GLU GLY LYS LEU THR GLU ARG GLU LYS LEU LEU          
SEQRES   4 C   96  ILE SER VAL ALA CYS SER VAL ALA VAL ARG CYS ASP ALA          
SEQRES   5 C   96  CYS THR ARG ARG HIS ALA GLU GLU ALA LEU GLU ALA GLY          
SEQRES   6 C   96  ILE THR GLU GLY GLU LEU ALA GLU ALA ALA ALA VAL ALA          
SEQRES   7 C   96  ALA LEU ILE ARG ALA GLY SER ALA MSE ASN THR ALA SER          
SEQRES   8 C   96  ALA ILE PHE ARG ASP                                          
SEQRES   1 D   96  MSE LYS THR GLY ALA ASP ARG PHE LEU GLU GLU LEU PRO          
SEQRES   2 D   96  GLU VAL ALA GLU SER PHE LYS ASN PHE ARG GLU ALA VAL          
SEQRES   3 D   96  ARG SER GLU GLY LYS LEU THR GLU ARG GLU LYS LEU LEU          
SEQRES   4 D   96  ILE SER VAL ALA CYS SER VAL ALA VAL ARG CYS ASP ALA          
SEQRES   5 D   96  CYS THR ARG ARG HIS ALA GLU GLU ALA LEU GLU ALA GLY          
SEQRES   6 D   96  ILE THR GLU GLY GLU LEU ALA GLU ALA ALA ALA VAL ALA          
SEQRES   7 D   96  ALA LEU ILE ARG ALA GLY SER ALA MSE ASN THR ALA SER          
SEQRES   8 D   96  ALA ILE PHE ARG ASP                                          
SEQRES   1 E   96  MSE LYS THR GLY ALA ASP ARG PHE LEU GLU GLU LEU PRO          
SEQRES   2 E   96  GLU VAL ALA GLU SER PHE LYS ASN PHE ARG GLU ALA VAL          
SEQRES   3 E   96  ARG SER GLU GLY LYS LEU THR GLU ARG GLU LYS LEU LEU          
SEQRES   4 E   96  ILE SER VAL ALA CYS SER VAL ALA VAL ARG CYS ASP ALA          
SEQRES   5 E   96  CYS THR ARG ARG HIS ALA GLU GLU ALA LEU GLU ALA GLY          
SEQRES   6 E   96  ILE THR GLU GLY GLU LEU ALA GLU ALA ALA ALA VAL ALA          
SEQRES   7 E   96  ALA LEU ILE ARG ALA GLY SER ALA MSE ASN THR ALA SER          
SEQRES   8 E   96  ALA ILE PHE ARG ASP                                          
SEQRES   1 F   96  MSE LYS THR GLY ALA ASP ARG PHE LEU GLU GLU LEU PRO          
SEQRES   2 F   96  GLU VAL ALA GLU SER PHE LYS ASN PHE ARG GLU ALA VAL          
SEQRES   3 F   96  ARG SER GLU GLY LYS LEU THR GLU ARG GLU LYS LEU LEU          
SEQRES   4 F   96  ILE SER VAL ALA CYS SER VAL ALA VAL ARG CYS ASP ALA          
SEQRES   5 F   96  CYS THR ARG ARG HIS ALA GLU GLU ALA LEU GLU ALA GLY          
SEQRES   6 F   96  ILE THR GLU GLY GLU LEU ALA GLU ALA ALA ALA VAL ALA          
SEQRES   7 F   96  ALA LEU ILE ARG ALA GLY SER ALA MSE ASN THR ALA SER          
SEQRES   8 F   96  ALA ILE PHE ARG ASP                                          
HET    MSE  A  87       8                                                       
HET    MSE  B  87       8                                                       
HET    MSE  C  87       8                                                       
HET    MSE  D  87       8                                                       
HET    MSE  E  87       8                                                       
HET    MSE  F  87       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   7  HOH   *14(H2 O)                                                     
CRYST1   59.528   71.985   61.418  90.00  99.08  90.00 P 1 21 1     12          
ATOM      1  N   ARG A   7      16.597  80.588  32.429  1.00 70.81           N  
ATOM      2  CA  ARG A   7      17.367  79.474  31.799  1.00 71.47           C  
ATOM      3  C   ARG A   7      16.736  79.139  30.452  1.00 70.37           C  
ATOM      4  O   ARG A   7      17.096  79.721  29.426  1.00 70.19           O  
ATOM      5  CB  ARG A   7      17.351  78.249  32.722  1.00 72.99           C  
ATOM      6  CG  ARG A   7      18.175  77.065  32.234  1.00 74.53           C  
ATOM      7  CD  ARG A   7      18.591  76.170  33.402  1.00 75.43           C  
ATOM      8  NE  ARG A   7      19.587  76.820  34.257  1.00 75.45           N  
ATOM      9  CZ  ARG A   7      19.981  76.363  35.444  1.00 75.31           C  
ATOM     10  NH1 ARG A   7      19.461  75.247  35.933  1.00 74.43           N  
ATOM     11  NH2 ARG A   7      20.900  77.020  36.140  1.00 74.62           N  
ATOM     12  N   PHE A   8      15.797  78.200  30.452  1.00 68.83           N  
ATOM     13  CA  PHE A   8      15.114  77.828  29.222  1.00 66.91           C  
ATOM     14  C   PHE A   8      14.243  79.010  28.801  1.00 66.84           C  
ATOM     15  O   PHE A   8      14.288  79.454  27.653  1.00 66.27           O  
ATOM     16  CB  PHE A   8      14.239  76.598  29.456  1.00 65.49           C  
ATOM     17  CG  PHE A   8      13.350  76.264  28.296  1.00 64.60           C  
ATOM     18  CD1 PHE A   8      13.889  75.827  27.091  1.00 63.90           C  
ATOM     19  CD2 PHE A   8      11.968  76.408  28.400  1.00 63.88           C  
ATOM     20  CE1 PHE A   8      13.059  75.538  26.003  1.00 64.17           C  
ATOM     21  CE2 PHE A   8      11.135  76.122  27.317  1.00 62.72           C  
ATOM     22  CZ  PHE A   8      11.680  75.687  26.120  1.00 62.93           C  
ATOM     23  N   LEU A   9      13.446  79.507  29.744  1.00 66.61           N  
ATOM     24  CA  LEU A   9      12.572  80.648  29.498  1.00 66.05           C  
ATOM     25  C   LEU A   9      13.414  81.793  28.947  1.00 65.37           C  
ATOM     26  O   LEU A   9      13.036  82.461  27.985  1.00 64.79           O  
ATOM     27  CB  LEU A   9      11.904  81.088  30.803  1.00 65.68           C  
ATOM     28  CG  LEU A   9      10.973  80.097  31.506  1.00 65.26           C  
ATOM     29  CD1 LEU A   9      10.591  80.633  32.875  1.00 64.56           C  
ATOM     30  CD2 LEU A   9       9.734  79.868  30.657  1.00 65.42           C  
ATOM     31  N   GLU A  10      14.565  81.996  29.576  1.00 65.29           N  
ATOM     32  CA  GLU A  10      15.512  83.043  29.211  1.00 65.16           C  
ATOM     33  C   GLU A  10      15.788  83.137  27.707  1.00 64.08           C  
ATOM     34  O   GLU A  10      15.953  84.230  27.167  1.00 63.56           O  
ATOM     35  CB  GLU A  10      16.819  82.807  29.970  1.00 66.06           C  
ATOM     36  CG  GLU A  10      17.904  83.830  29.720  1.00 68.34           C  
ATOM     37  CD  GLU A  10      19.173  83.512  30.491  1.00 69.71           C  
ATOM     38  OE1 GLU A  10      19.143  83.561  31.741  1.00 70.22           O  
ATOM     39  OE2 GLU A  10      20.197  83.202  29.847  1.00 69.43           O  
ATOM     40  N   GLU A  11      15.831  81.989  27.041  1.00 63.61           N  
ATOM     41  CA  GLU A  11      16.091  81.924  25.602  1.00 62.26           C  
ATOM     42  C   GLU A  11      15.036  82.634  24.762  1.00 61.10           C  
ATOM     43  O   GLU A  11      15.304  83.068  23.642  1.00 60.22           O  
ATOM     44  CB  GLU A  11      16.169  80.462  25.152  1.00 63.40           C  
ATOM     45  CG  GLU A  11      17.397  79.711  25.635  1.00 65.08           C  
ATOM     46  CD  GLU A  11      18.653  80.124  24.896  1.00 65.27           C  
ATOM     47  OE1 GLU A  11      18.628  80.093  23.649  1.00 64.32           O  
ATOM     48  OE2 GLU A  11      19.660  80.469  25.556  1.00 66.63           O  
ATOM     49  N   LEU A  12      13.830  82.740  25.302  1.00 60.43           N  
ATOM     50  CA  LEU A  12      12.740  83.379  24.585  1.00 60.19           C  
ATOM     51  C   LEU A  12      11.991  84.339  25.504  1.00 59.86           C  
ATOM     52  O   LEU A  12      11.133  83.921  26.276  1.00 59.88           O  
ATOM     53  CB  LEU A  12      11.787  82.304  24.059  1.00 59.97           C  
ATOM     54  CG  LEU A  12      12.439  81.161  23.275  1.00 59.38           C  
ATOM     55  CD1 LEU A  12      11.454  80.020  23.114  1.00 58.62           C  
ATOM     56  CD2 LEU A  12      12.913  81.670  21.922  1.00 59.08           C  
ATOM     57  N   PRO A  13      12.306  85.641  25.424  1.00 59.50           N  
ATOM     58  CA  PRO A  13      11.676  86.683  26.244  1.00 59.11           C  
ATOM     59  C   PRO A  13      10.145  86.768  26.132  1.00 58.67           C  
ATOM     60  O   PRO A  13       9.434  86.684  27.136  1.00 57.68           O  
ATOM     61  CB  PRO A  13      12.354  87.959  25.753  1.00 59.02           C  
ATOM     62  CG  PRO A  13      13.705  87.478  25.318  1.00 59.26           C  
ATOM     63  CD  PRO A  13      13.364  86.218  24.576  1.00 59.50           C  
ATOM     64  N   GLU A  14       9.652  86.938  24.909  1.00 58.04           N  
ATOM     65  CA  GLU A  14       8.216  87.054  24.663  1.00 57.56           C  
ATOM     66  C   GLU A  14       7.388  85.857  25.137  1.00 55.79           C  
ATOM     67  O   GLU A  14       6.463  86.012  25.938  1.00 55.81           O  
ATOM     68  CB  GLU A  14       7.958  87.283  23.169  1.00 60.12           C  
ATOM     69  CG  GLU A  14       8.567  88.566  22.593  1.00 64.27           C  
ATOM     70  CD  GLU A  14       7.692  89.802  22.795  1.00 66.48           C  
ATOM     71  OE1 GLU A  14       6.553  89.817  22.272  1.00 66.74           O  
ATOM     72  OE2 GLU A  14       8.145  90.756  23.470  1.00 67.17           O  
ATOM     73  N   VAL A  15       7.711  84.663  24.652  1.00 53.16           N  
ATOM     74  CA  VAL A  15       6.948  83.482  25.038  1.00 50.05           C  
ATOM     75  C   VAL A  15       7.040  83.201  26.534  1.00 47.97           C  
ATOM     76  O   VAL A  15       6.063  82.757  27.142  1.00 47.32           O  
ATOM     77  CB  VAL A  15       7.397  82.227  24.248  1.00 49.50           C  
ATOM     78  CG1 VAL A  15       7.584  82.578  22.781  1.00 47.56           C  
ATOM     79  CG2 VAL A  15       8.670  81.669  24.830  1.00 50.61           C  
ATOM     80  N   ALA A  16       8.205  83.463  27.124  1.00 45.27           N  
ATOM     81  CA  ALA A  16       8.393  83.236  28.552  1.00 44.69           C  
ATOM     82  C   ALA A  16       7.482  84.158  29.343  1.00 44.97           C  
ATOM     83  O   ALA A  16       6.925  83.770  30.368  1.00 43.10           O  
ATOM     84  CB  ALA A  16       9.841  83.478  28.946  1.00 43.70           C  
ATOM     85  N   GLU A  17       7.335  85.388  28.865  1.00 46.18           N  
ATOM     86  CA  GLU A  17       6.478  86.349  29.541  1.00 47.96           C  
ATOM     87  C   GLU A  17       5.015  85.925  29.387  1.00 47.41           C  
ATOM     88  O   GLU A  17       4.253  85.927  30.361  1.00 48.21           O  
ATOM     89  CB  GLU A  17       6.684  87.754  28.966  1.00 49.44           C  
ATOM     90  CG  GLU A  17       5.895  88.827  29.703  1.00 54.57           C  
ATOM     91  CD  GLU A  17       6.261  88.905  31.179  1.00 57.75           C  
ATOM     92  OE1 GLU A  17       7.407  89.300  31.493  1.00 60.21           O  
ATOM     93  OE2 GLU A  17       5.406  88.564  32.027  1.00 59.45           O  
ATOM     94  N   SER A  18       4.628  85.554  28.169  1.00 44.27           N  
ATOM     95  CA  SER A  18       3.261  85.122  27.924  1.00 43.18           C  
ATOM     96  C   SER A  18       2.967  83.911  28.806  1.00 42.38           C  
ATOM     97  O   SER A  18       1.930  83.838  29.462  1.00 42.67           O  
ATOM     98  CB  SER A  18       3.074  84.743  26.452  1.00 44.74           C  
ATOM     99  OG  SER A  18       3.653  83.477  26.171  1.00 45.76           O  
ATOM    100  N   PHE A  19       3.894  82.960  28.829  1.00 40.79           N  
ATOM    101  CA  PHE A  19       3.707  81.768  29.639  1.00 39.57           C  
ATOM    102  C   PHE A  19       3.526  82.109  31.112  1.00 40.20           C  
ATOM    103  O   PHE A  19       2.674  81.538  31.793  1.00 39.46           O  
ATOM    104  CB  PHE A  19       4.894  80.827  29.489  1.00 37.07           C  
ATOM    105  CG  PHE A  19       4.797  79.612  30.358  1.00 36.05           C  
ATOM    106  CD1 PHE A  19       3.832  78.638  30.107  1.00 34.05           C  
ATOM    107  CD2 PHE A  19       5.630  79.461  31.460  1.00 34.18           C  
ATOM    108  CE1 PHE A  19       3.696  77.532  30.950  1.00 33.40           C  
ATOM    109  CE2 PHE A  19       5.501  78.355  32.304  1.00 34.56           C  
ATOM    110  CZ  PHE A  19       4.531  77.395  32.045  1.00 34.33           C  
ATOM    111  N   LYS A  20       4.349  83.032  31.602  1.00 42.86           N  
ATOM    112  CA  LYS A  20       4.281  83.462  32.992  1.00 44.35           C  
ATOM    113  C   LYS A  20       2.871  83.996  33.271  1.00 44.33           C  
ATOM    114  O   LYS A  20       2.277  83.715  34.312  1.00 43.73           O  
ATOM    115  CB  LYS A  20       5.308  84.570  33.247  1.00 47.51           C  
ATOM    116  CG  LYS A  20       5.661  84.771  34.713  1.00 49.84           C  
ATOM    117  CD  LYS A  20       6.675  83.725  35.165  1.00 52.34           C  
ATOM    118  CE  LYS A  20       6.610  83.475  36.673  1.00 52.79           C  
ATOM    119  NZ  LYS A  20       5.373  82.726  37.064  1.00 52.77           N  
ATOM    120  N   ASN A  21       2.344  84.764  32.324  1.00 43.99           N  
ATOM    121  CA  ASN A  21       1.013  85.347  32.445  1.00 44.56           C  
ATOM    122  C   ASN A  21      -0.066  84.271  32.423  1.00 44.66           C  
ATOM    123  O   ASN A  21      -1.022  84.323  33.200  1.00 44.41           O  
ATOM    124  CB  ASN A  21       0.781  86.350  31.312  1.00 44.98           C  
ATOM    125  CG  ASN A  21       1.559  87.644  31.505  1.00 45.44           C  
ATOM    126  OD1 ASN A  21       1.821  88.371  30.543  1.00 42.86           O  
ATOM    127  ND2 ASN A  21       1.923  87.944  32.758  1.00 44.04           N  
ATOM    128  N   PHE A  22       0.085  83.302  31.527  1.00 44.28           N  
ATOM    129  CA  PHE A  22      -0.873  82.211  31.445  1.00 43.51           C  
ATOM    130  C   PHE A  22      -0.882  81.423  32.753  1.00 42.80           C  
ATOM    131  O   PHE A  22      -1.930  80.991  33.220  1.00 41.98           O  
ATOM    132  CB  PHE A  22      -0.520  81.281  30.285  1.00 43.21           C  
ATOM    133  CG  PHE A  22      -1.213  79.952  30.349  1.00 42.78           C  
ATOM    134  CD1 PHE A  22      -0.505  78.799  30.665  1.00 41.79           C  
ATOM    135  CD2 PHE A  22      -2.578  79.853  30.117  1.00 41.67           C  
ATOM    136  CE1 PHE A  22      -1.150  77.572  30.747  1.00 39.40           C  
ATOM    137  CE2 PHE A  22      -3.226  78.629  30.198  1.00 40.53           C  
ATOM    138  CZ  PHE A  22      -2.508  77.492  30.514  1.00 39.54           C  
ATOM    139  N   ARG A  23       0.295  81.233  33.335  1.00 43.25           N  
ATOM    140  CA  ARG A  23       0.407  80.505  34.589  1.00 45.15           C  
ATOM    141  C   ARG A  23      -0.238  81.269  35.738  1.00 45.30           C  
ATOM    142  O   ARG A  23      -0.969  80.697  36.534  1.00 45.72           O  
ATOM    143  CB  ARG A  23       1.878  80.224  34.910  1.00 45.58           C  
ATOM    144  CG  ARG A  23       2.136  79.749  36.331  1.00 48.08           C  
ATOM    145  CD  ARG A  23       3.515  79.117  36.450  1.00 50.67           C  
ATOM    146  NE  ARG A  23       4.574  79.976  35.927  1.00 54.38           N  
ATOM    147  CZ  ARG A  23       5.749  79.528  35.483  1.00 56.22           C  
ATOM    148  NH1 ARG A  23       6.015  78.223  35.496  1.00 55.81           N  
ATOM    149  NH2 ARG A  23       6.655  80.384  35.017  1.00 55.84           N  
ATOM    150  N   GLU A  24       0.031  82.563  35.820  1.00 46.15           N  
ATOM    151  CA  GLU A  24      -0.536  83.374  36.886  1.00 47.15           C  
ATOM    152  C   GLU A  24      -2.051  83.483  36.735  1.00 46.50           C  
ATOM    153  O   GLU A  24      -2.778  83.542  37.724  1.00 46.15           O  
ATOM    154  CB  GLU A  24       0.087  84.768  36.874  1.00 50.11           C  
ATOM    155  CG  GLU A  24      -0.148  85.558  38.155  1.00 54.51           C  
ATOM    156  CD  GLU A  24       0.474  84.891  39.376  1.00 57.42           C  
ATOM    157  OE1 GLU A  24       0.026  83.782  39.755  1.00 57.12           O  
ATOM    158  OE2 GLU A  24       1.418  85.479  39.956  1.00 59.14           O  
ATOM    159  N   ALA A  25      -2.523  83.509  35.494  1.00 45.89           N  
ATOM    160  CA  ALA A  25      -3.952  83.605  35.226  1.00 45.62           C  
ATOM    161  C   ALA A  25      -4.696  82.404  35.781  1.00 46.19           C  
ATOM    162  O   ALA A  25      -5.697  82.555  36.479  1.00 46.69           O  
ATOM    163  CB  ALA A  25      -4.206  83.719  33.724  1.00 46.21           C  
ATOM    164  N   VAL A  26      -4.219  81.204  35.478  1.00 46.17           N  
ATOM    165  CA  VAL A  26      -4.903  80.022  35.974  1.00 47.93           C  
ATOM    166  C   VAL A  26      -4.704  79.881  37.481  1.00 48.05           C  
ATOM    167  O   VAL A  26      -5.549  79.322  38.186  1.00 47.79           O  
ATOM    168  CB  VAL A  26      -4.417  78.732  35.254  1.00 47.50           C  
ATOM    169  CG1 VAL A  26      -4.434  78.939  33.751  1.00 47.38           C  
ATOM    170  CG2 VAL A  26      -3.042  78.354  35.725  1.00 49.25           C  
ATOM    171  N   ARG A  27      -3.591  80.415  37.967  1.00 47.76           N  
ATOM    172  CA  ARG A  27      -3.257  80.349  39.380  1.00 49.61           C  
ATOM    173  C   ARG A  27      -4.086  81.359  40.180  1.00 50.19           C  
ATOM    174  O   ARG A  27      -4.486  81.088  41.312  1.00 48.77           O  
ATOM    175  CB  ARG A  27      -1.758  80.624  39.543  1.00 51.39           C  
ATOM    176  CG  ARG A  27      -1.101  80.031  40.780  1.00 55.24           C  
ATOM    177  CD  ARG A  27       0.410  80.289  40.741  1.00 57.21           C  
ATOM    178  NE  ARG A  27       1.112  79.861  41.952  1.00 58.78           N  
ATOM    179  CZ  ARG A  27       1.403  78.599  42.259  1.00 60.18           C  
ATOM    180  NH1 ARG A  27       1.056  77.609  41.447  1.00 60.89           N  
ATOM    181  NH2 ARG A  27       2.053  78.326  43.382  1.00 61.07           N  
ATOM    182  N   SER A  28      -4.348  82.517  39.579  1.00 51.69           N  
ATOM    183  CA  SER A  28      -5.125  83.572  40.230  1.00 53.35           C  
ATOM    184  C   SER A  28      -6.594  83.532  39.838  1.00 54.00           C  
ATOM    185  O   SER A  28      -7.276  84.556  39.866  1.00 54.44           O  
ATOM    186  CB  SER A  28      -4.567  84.950  39.870  1.00 53.58           C  
ATOM    187  OG  SER A  28      -3.216  85.088  40.270  1.00 59.13           O  
ATOM    188  N   GLU A  29      -7.085  82.361  39.460  1.00 54.22           N  
ATOM    189  CA  GLU A  29      -8.484  82.236  39.076  1.00 54.53           C  
ATOM    190  C   GLU A  29      -9.329  82.207  40.355  1.00 53.48           C  
ATOM    191  O   GLU A  29      -8.939  81.600  41.356  1.00 52.36           O  
ATOM    192  CB  GLU A  29      -8.679  80.961  38.252  1.00 56.34           C  
ATOM    193  CG  GLU A  29      -9.884  80.979  37.331  1.00 59.96           C  
ATOM    194  CD  GLU A  29     -11.189  80.775  38.068  1.00 62.85           C  
ATOM    195  OE1 GLU A  29     -11.314  79.755  38.784  1.00 64.39           O  
ATOM    196  OE2 GLU A  29     -12.089  81.630  37.927  1.00 64.03           O  
ATOM    197  N   GLY A  30     -10.486  82.864  40.317  1.00 51.58           N  
ATOM    198  CA  GLY A  30     -11.334  82.932  41.493  1.00 49.24           C  
ATOM    199  C   GLY A  30     -12.442  81.917  41.691  1.00 47.80           C  
ATOM    200  O   GLY A  30     -13.106  81.948  42.722  1.00 48.04           O  
ATOM    201  N   LYS A  31     -12.658  81.022  40.735  1.00 46.58           N  
ATOM    202  CA  LYS A  31     -13.711  80.026  40.891  1.00 45.33           C  
ATOM    203  C   LYS A  31     -13.329  78.927  41.876  1.00 44.46           C  
ATOM    204  O   LYS A  31     -14.191  78.324  42.502  1.00 44.49           O  
ATOM    205  CB  LYS A  31     -14.069  79.404  39.539  1.00 45.30           C  
ATOM    206  CG  LYS A  31     -14.621  80.399  38.544  1.00 46.08           C  
ATOM    207  CD  LYS A  31     -15.124  79.716  37.293  1.00 46.36           C  
ATOM    208  CE  LYS A  31     -15.524  80.739  36.248  1.00 47.22           C  
ATOM    209  NZ  LYS A  31     -16.562  81.676  36.751  1.00 47.07           N  
ATOM    210  N   LEU A  32     -12.034  78.663  42.007  1.00 44.26           N  
ATOM    211  CA  LEU A  32     -11.559  77.628  42.915  1.00 43.41           C  
ATOM    212  C   LEU A  32     -10.653  78.217  43.986  1.00 43.75           C  
ATOM    213  O   LEU A  32      -9.839  79.097  43.703  1.00 44.38           O  
ATOM    214  CB  LEU A  32     -10.783  76.555  42.147  1.00 42.71           C  
ATOM    215  CG  LEU A  32     -11.486  75.752  41.051  1.00 42.87           C  
ATOM    216  CD1 LEU A  32     -10.557  74.633  40.604  1.00 43.28           C  
ATOM    217  CD2 LEU A  32     -12.793  75.165  41.557  1.00 41.68           C  
ATOM    218  N   THR A  33     -10.790  77.725  45.213  1.00 43.94           N  
ATOM    219  CA  THR A  33      -9.970  78.198  46.326  1.00 44.22           C  
ATOM    220  C   THR A  33      -8.502  77.860  46.081  1.00 44.38           C  
ATOM    221  O   THR A  33      -8.177  77.094  45.172  1.00 43.95           O  
ATOM    222  CB  THR A  33     -10.380  77.535  47.652  1.00 44.08           C  
ATOM    223  OG1 THR A  33      -9.995  76.157  47.632  1.00 43.95           O  
ATOM    224  CG2 THR A  33     -11.883  77.625  47.858  1.00 45.69           C  
ATOM    225  N   GLU A  34      -7.623  78.433  46.900  1.00 44.96           N  
ATOM    226  CA  GLU A  34      -6.184  78.191  46.796  1.00 44.75           C  
ATOM    227  C   GLU A  34      -5.888  76.719  47.101  1.00 43.70           C  
ATOM    228  O   GLU A  34      -5.112  76.067  46.400  1.00 42.27           O  
ATOM    229  CB  GLU A  34      -5.439  79.089  47.788  1.00 46.37           C  
ATOM    230  CG  GLU A  34      -3.931  78.892  47.816  1.00 51.82           C  
ATOM    231  CD  GLU A  34      -3.237  79.362  46.542  1.00 54.76           C  
ATOM    232  OE1 GLU A  34      -3.635  78.924  45.438  1.00 55.75           O  
ATOM    233  OE2 GLU A  34      -2.283  80.164  46.652  1.00 56.55           O  
ATOM    234  N   ARG A  35      -6.530  76.209  48.148  1.00 43.34           N  
ATOM    235  CA  ARG A  35      -6.360  74.830  48.580  1.00 42.93           C  
ATOM    236  C   ARG A  35      -6.719  73.801  47.512  1.00 41.74           C  
ATOM    237  O   ARG A  35      -6.043  72.779  47.371  1.00 40.95           O  
ATOM    238  CB  ARG A  35      -7.192  74.582  49.843  1.00 45.15           C  
ATOM    239  CG  ARG A  35      -7.155  73.151  50.354  1.00 47.07           C  
ATOM    240  CD  ARG A  35      -7.095  73.121  51.876  1.00 50.82           C  
ATOM    241  NE  ARG A  35      -7.118  71.756  52.395  1.00 50.91           N  
ATOM    242  CZ  ARG A  35      -8.188  70.973  52.358  1.00 52.03           C  
ATOM    243  NH1 ARG A  35      -8.134  69.739  52.845  1.00 52.28           N  
ATOM    244  NH2 ARG A  35      -9.322  71.433  51.847  1.00 51.19           N  
ATOM    245  N   GLU A  36      -7.781  74.060  46.761  1.00 40.19           N  
ATOM    246  CA  GLU A  36      -8.200  73.122  45.722  1.00 39.24           C  
ATOM    247  C   GLU A  36      -7.260  73.151  44.515  1.00 36.59           C  
ATOM    248  O   GLU A  36      -6.971  72.117  43.924  1.00 34.28           O  
ATOM    249  CB  GLU A  36      -9.639  73.427  45.273  1.00 41.66           C  
ATOM    250  CG  GLU A  36     -10.670  73.423  46.403  1.00 42.47           C  
ATOM    251  CD  GLU A  36     -12.054  73.848  45.931  1.00 45.89           C  
ATOM    252  OE1 GLU A  36     -12.150  74.873  45.210  1.00 44.77           O  
ATOM    253  OE2 GLU A  36     -13.046  73.167  46.284  1.00 47.17           O  
ATOM    254  N   LYS A  37      -6.776  74.337  44.164  1.00 35.66           N  
ATOM    255  CA  LYS A  37      -5.874  74.492  43.030  1.00 35.95           C  
ATOM    256  C   LYS A  37      -4.488  73.881  43.279  1.00 35.49           C  
ATOM    257  O   LYS A  37      -3.876  73.309  42.375  1.00 33.85           O  
ATOM    258  CB  LYS A  37      -5.762  75.978  42.666  1.00 35.05           C  
ATOM    259  CG  LYS A  37      -7.052  76.529  42.066  1.00 37.20           C  
ATOM    260  CD  LYS A  37      -6.920  77.958  41.593  1.00 36.50           C  
ATOM    261  CE  LYS A  37      -6.825  78.913  42.762  1.00 38.57           C  
ATOM    262  NZ  LYS A  37      -6.708  80.312  42.270  1.00 40.64           N  
ATOM    263  N   LEU A  38      -4.004  74.006  44.507  1.00 35.12           N  
ATOM    264  CA  LEU A  38      -2.709  73.460  44.881  1.00 34.48           C  
ATOM    265  C   LEU A  38      -2.827  71.936  44.925  1.00 35.08           C  
ATOM    266  O   LEU A  38      -1.942  71.209  44.468  1.00 35.49           O  
ATOM    267  CB  LEU A  38      -2.319  73.990  46.256  1.00 33.46           C  
ATOM    268  CG  LEU A  38      -1.057  74.835  46.426  1.00 33.87           C  
ATOM    269  CD1 LEU A  38      -0.870  75.817  45.277  1.00 34.63           C  
ATOM    270  CD2 LEU A  38      -1.173  75.565  47.752  1.00 34.43           C  
ATOM    271  N   LEU A  39      -3.945  71.465  45.464  1.00 34.14           N  
ATOM    272  CA  LEU A  39      -4.207  70.040  45.587  1.00 33.24           C  
ATOM    273  C   LEU A  39      -4.361  69.385  44.201  1.00 32.32           C  
ATOM    274  O   LEU A  39      -4.002  68.222  43.997  1.00 31.33           O  
ATOM    275  CB  LEU A  39      -5.470  69.848  46.428  1.00 33.43           C  
ATOM    276  CG  LEU A  39      -5.464  68.810  47.552  1.00 34.83           C  
ATOM    277  CD1 LEU A  39      -4.223  68.937  48.407  1.00 33.10           C  
ATOM    278  CD2 LEU A  39      -6.719  69.007  48.402  1.00 36.62           C  
ATOM    279  N   ILE A  40      -4.888  70.151  43.256  1.00 31.13           N  
ATOM    280  CA  ILE A  40      -5.090  69.681  41.893  1.00 30.67           C  
ATOM    281  C   ILE A  40      -3.764  69.640  41.145  1.00 29.80           C  
ATOM    282  O   ILE A  40      -3.526  68.727  40.360  1.00 29.89           O  
ATOM    283  CB  ILE A  40      -6.073  70.600  41.143  1.00 30.89           C  
ATOM    284  CG1 ILE A  40      -7.470  70.438  41.741  1.00 30.00           C  
ATOM    285  CG2 ILE A  40      -6.064  70.284  39.653  1.00 31.52           C  
ATOM    286  CD1 ILE A  40      -8.497  71.378  41.171  1.00 32.19           C  
ATOM    287  N   SER A  41      -2.910  70.631  41.406  1.00 29.23           N  
ATOM    288  CA  SER A  41      -1.583  70.732  40.791  1.00 29.01           C  
ATOM    289  C   SER A  41      -0.721  69.532  41.133  1.00 28.68           C  
ATOM    290  O   SER A  41       0.030  69.038  40.302  1.00 30.13           O  
ATOM    291  CB  SER A  41      -0.869  72.001  41.258  1.00 29.41           C  
ATOM    292  OG  SER A  41      -1.512  73.149  40.745  1.00 30.08           O  
ATOM    293  N   VAL A  42      -0.824  69.077  42.371  1.00 28.65           N  
ATOM    294  CA  VAL A  42      -0.075  67.920  42.813  1.00 26.35           C  
ATOM    295  C   VAL A  42      -0.611  66.677  42.102  1.00 26.18           C  
ATOM    296  O   VAL A  42       0.157  65.888  41.549  1.00 26.12           O  
ATOM    297  CB  VAL A  42      -0.202  67.730  44.338  1.00 25.37           C  
ATOM    298  CG1 VAL A  42       0.467  66.444  44.755  1.00 25.99           C  
ATOM    299  CG2 VAL A  42       0.431  68.899  45.060  1.00 22.77           C  
ATOM    300  N   ALA A  43      -1.929  66.507  42.107  1.00 25.51           N  
ATOM    301  CA  ALA A  43      -2.536  65.338  41.463  1.00 24.45           C  
ATOM    302  C   ALA A  43      -2.173  65.237  39.968  1.00 23.58           C  
ATOM    303  O   ALA A  43      -1.797  64.174  39.492  1.00 19.89           O  
ATOM    304  CB  ALA A  43      -4.059  65.367  41.639  1.00 22.33           C  
ATOM    305  N   CYS A  44      -2.293  66.342  39.235  1.00 24.48           N  
ATOM    306  CA  CYS A  44      -1.965  66.353  37.811  1.00 24.37           C  
ATOM    307  C   CYS A  44      -0.492  66.057  37.575  1.00 24.94           C  
ATOM    308  O   CYS A  44      -0.135  65.356  36.623  1.00 23.54           O  
ATOM    309  CB  CYS A  44      -2.322  67.704  37.191  1.00 25.29           C  
ATOM    310  SG  CYS A  44      -4.103  67.967  37.047  1.00 28.60           S  
ATOM    311  N   SER A  45       0.357  66.593  38.450  1.00 25.14           N  
ATOM    312  CA  SER A  45       1.798  66.383  38.363  1.00 24.79           C  
ATOM    313  C   SER A  45       2.089  64.901  38.470  1.00 23.22           C  
ATOM    314  O   SER A  45       2.891  64.352  37.720  1.00 23.04           O  
ATOM    315  CB  SER A  45       2.510  67.130  39.493  1.00 24.37           C  
ATOM    316  OG  SER A  45       2.441  68.530  39.288  1.00 29.50           O  
ATOM    317  N   VAL A  46       1.423  64.260  39.418  1.00 23.50           N  
ATOM    318  CA  VAL A  46       1.593  62.837  39.638  1.00 22.79           C  
ATOM    319  C   VAL A  46       0.995  62.042  38.486  1.00 24.04           C  
ATOM    320  O   VAL A  46       1.584  61.070  38.032  1.00 23.02           O  
ATOM    321  CB  VAL A  46       0.927  62.414  40.959  1.00 21.43           C  
ATOM    322  CG1 VAL A  46       0.941  60.901  41.104  1.00 21.84           C  
ATOM    323  CG2 VAL A  46       1.669  63.045  42.125  1.00 19.61           C  
ATOM    324  N   ALA A  47      -0.169  62.480  38.009  1.00 24.56           N  
ATOM    325  CA  ALA A  47      -0.862  61.807  36.927  1.00 25.44           C  
ATOM    326  C   ALA A  47      -0.073  61.818  35.618  1.00 26.74           C  
ATOM    327  O   ALA A  47      -0.175  60.883  34.823  1.00 26.82           O  
ATOM    328  CB  ALA A  47      -2.243  62.441  36.716  1.00 21.83           C  
ATOM    329  N   VAL A  48       0.708  62.867  35.392  1.00 26.93           N  
ATOM    330  CA  VAL A  48       1.481  62.960  34.166  1.00 27.74           C  
ATOM    331  C   VAL A  48       2.939  62.523  34.397  1.00 27.62           C  
ATOM    332  O   VAL A  48       3.779  62.620  33.513  1.00 24.94           O  
ATOM    333  CB  VAL A  48       1.395  64.400  33.581  1.00 28.73           C  
ATOM    334  CG1 VAL A  48       2.367  65.328  34.280  1.00 29.13           C  
ATOM    335  CG2 VAL A  48       1.642  64.362  32.082  1.00 33.33           C  
ATOM    336  N   ARG A  49       3.215  62.023  35.599  1.00 28.84           N  
ATOM    337  CA  ARG A  49       4.537  61.521  35.976  1.00 31.77           C  
ATOM    338  C   ARG A  49       5.720  62.474  35.812  1.00 32.61           C  
ATOM    339  O   ARG A  49       6.745  62.102  35.260  1.00 33.14           O  
ATOM    340  CB  ARG A  49       4.842  60.213  35.220  1.00 33.06           C  
ATOM    341  CG  ARG A  49       4.073  58.981  35.716  1.00 35.40           C  
ATOM    342  CD  ARG A  49       4.424  57.715  34.912  1.00 39.24           C  
ATOM    343  NE  ARG A  49       5.868  57.550  34.705  1.00 43.22           N  
ATOM    344  CZ  ARG A  49       6.764  57.449  35.684  1.00 44.02           C  
ATOM    345  NH1 ARG A  49       8.051  57.306  35.392  1.00 44.60           N  
ATOM    346  NH2 ARG A  49       6.382  57.487  36.957  1.00 43.69           N  
ATOM    347  N   CYS A  50       5.580  63.704  36.280  1.00 34.33           N  
ATOM    348  CA  CYS A  50       6.684  64.655  36.209  1.00 35.67           C  
ATOM    349  C   CYS A  50       7.147  64.897  37.653  1.00 35.66           C  
ATOM    350  O   CYS A  50       6.477  65.581  38.424  1.00 31.60           O  
ATOM    351  CB  CYS A  50       6.241  65.973  35.542  1.00 36.43           C  
ATOM    352  SG  CYS A  50       7.387  67.359  35.848  1.00 37.03           S  
ATOM    353  N   ASP A  51       8.284  64.301  38.007  1.00 37.23           N  
ATOM    354  CA  ASP A  51       8.848  64.409  39.351  1.00 40.24           C  
ATOM    355  C   ASP A  51       9.192  65.842  39.770  1.00 40.72           C  
ATOM    356  O   ASP A  51       8.959  66.234  40.917  1.00 39.69           O  
ATOM    357  CB  ASP A  51      10.094  63.513  39.471  1.00 42.86           C  
ATOM    358  CG  ASP A  51       9.750  62.024  39.479  1.00 47.87           C  
ATOM    359  OD1 ASP A  51       9.127  61.535  38.507  1.00 49.98           O  
ATOM    360  OD2 ASP A  51      10.096  61.336  40.468  1.00 51.26           O  
ATOM    361  N   ALA A  52       9.735  66.624  38.839  1.00 40.13           N  
ATOM    362  CA  ALA A  52      10.095  68.005  39.126  1.00 39.37           C  
ATOM    363  C   ALA A  52       8.848  68.829  39.435  1.00 38.84           C  
ATOM    364  O   ALA A  52       8.853  69.681  40.332  1.00 38.10           O  
ATOM    365  CB  ALA A  52      10.831  68.604  37.940  1.00 39.22           C  
ATOM    366  N   CYS A  53       7.783  68.571  38.684  1.00 36.66           N  
ATOM    367  CA  CYS A  53       6.528  69.291  38.866  1.00 37.75           C  
ATOM    368  C   CYS A  53       5.875  68.915  40.196  1.00 36.59           C  
ATOM    369  O   CYS A  53       5.404  69.769  40.941  1.00 35.33           O  
ATOM    370  CB  CYS A  53       5.551  68.951  37.740  1.00 39.80           C  
ATOM    371  SG  CYS A  53       6.170  69.001  36.015  1.00 46.49           S  
ATOM    372  N   THR A  54       5.850  67.618  40.476  1.00 35.61           N  
ATOM    373  CA  THR A  54       5.258  67.094  41.695  1.00 36.57           C  
ATOM    374  C   THR A  54       5.930  67.645  42.953  1.00 36.38           C  
ATOM    375  O   THR A  54       5.261  68.011  43.914  1.00 36.02           O  
ATOM    376  CB  THR A  54       5.344  65.555  41.703  1.00 36.34           C  
ATOM    377  OG1 THR A  54       4.589  65.037  40.602  1.00 35.33           O  
ATOM    378  CG2 THR A  54       4.794  64.992  42.998  1.00 37.28           C  
ATOM    379  N   ARG A  55       7.256  67.696  42.927  1.00 38.24           N  
ATOM    380  CA  ARG A  55       8.067  68.188  44.040  1.00 39.93           C  
ATOM    381  C   ARG A  55       7.750  69.652  44.353  1.00 39.40           C  
ATOM    382  O   ARG A  55       7.448  70.012  45.492  1.00 36.84           O  
ATOM    383  CB  ARG A  55       9.550  68.055  43.677  1.00 42.32           C  
ATOM    384  CG  ARG A  55      10.460  67.590  44.800  1.00 47.86           C  
ATOM    385  CD  ARG A  55      11.916  67.780  44.417  1.00 51.79           C  
ATOM    386  NE  ARG A  55      12.154  67.455  43.010  1.00 56.05           N  
ATOM    387  CZ  ARG A  55      12.037  66.239  42.483  1.00 58.37           C  
ATOM    388  NH1 ARG A  55      11.685  65.210  43.246  1.00 58.45           N  
ATOM    389  NH2 ARG A  55      12.269  66.053  41.187  1.00 60.17           N  
ATOM    390  N   ARG A  56       7.827  70.490  43.325  1.00 40.16           N  
ATOM    391  CA  ARG A  56       7.562  71.914  43.456  1.00 41.20           C  
ATOM    392  C   ARG A  56       6.152  72.214  43.951  1.00 39.18           C  
ATOM    393  O   ARG A  56       5.970  73.000  44.877  1.00 40.78           O  
ATOM    394  CB  ARG A  56       7.819  72.606  42.108  1.00 44.19           C  
ATOM    395  CG  ARG A  56       7.114  73.947  41.907  1.00 50.82           C  
ATOM    396  CD  ARG A  56       7.574  75.043  42.880  1.00 56.17           C  
ATOM    397  NE  ARG A  56       8.951  75.472  42.647  1.00 60.28           N  
ATOM    398  CZ  ARG A  56       9.472  76.603  43.116  1.00 61.42           C  
ATOM    399  NH1 ARG A  56      10.739  76.914  42.858  1.00 62.02           N  
ATOM    400  NH2 ARG A  56       8.723  77.431  43.834  1.00 61.38           N  
ATOM    401  N   HIS A  57       5.151  71.589  43.346  1.00 37.77           N  
ATOM    402  CA  HIS A  57       3.773  71.839  43.755  1.00 36.43           C  
ATOM    403  C   HIS A  57       3.443  71.246  45.120  1.00 36.17           C  
ATOM    404  O   HIS A  57       2.585  71.764  45.838  1.00 35.88           O  
ATOM    405  CB  HIS A  57       2.801  71.306  42.705  1.00 35.58           C  
ATOM    406  CG  HIS A  57       2.896  72.007  41.390  1.00 36.67           C  
ATOM    407  ND1 HIS A  57       2.791  73.380  41.271  1.00 38.54           N  
ATOM    408  CD2 HIS A  57       3.101  71.542  40.135  1.00 37.29           C  
ATOM    409  CE1 HIS A  57       2.927  73.724  40.006  1.00 36.91           C  
ATOM    410  NE2 HIS A  57       3.117  72.626  39.292  1.00 37.20           N  
ATOM    411  N   ALA A  58       4.109  70.156  45.480  1.00 34.71           N  
ATOM    412  CA  ALA A  58       3.861  69.538  46.775  1.00 37.26           C  
ATOM    413  C   ALA A  58       4.355  70.458  47.895  1.00 37.73           C  
ATOM    414  O   ALA A  58       3.652  70.688  48.886  1.00 36.61           O  
ATOM    415  CB  ALA A  58       4.556  68.183  46.862  1.00 35.23           C  
ATOM    416  N   GLU A  59       5.562  70.988  47.738  1.00 38.70           N  
ATOM    417  CA  GLU A  59       6.105  71.878  48.752  1.00 41.72           C  
ATOM    418  C   GLU A  59       5.356  73.201  48.752  1.00 42.85           C  
ATOM    419  O   GLU A  59       5.261  73.851  49.792  1.00 43.36           O  
ATOM    420  CB  GLU A  59       7.611  72.085  48.551  1.00 41.83           C  
ATOM    421  CG  GLU A  59       8.039  72.340  47.137  1.00 43.64           C  
ATOM    422  CD  GLU A  59       9.516  72.081  46.945  1.00 45.35           C  
ATOM    423  OE1 GLU A  59       9.987  71.007  47.380  1.00 44.75           O  
ATOM    424  OE2 GLU A  59      10.206  72.941  46.351  1.00 47.83           O  
ATOM    425  N   GLU A  60       4.808  73.596  47.602  1.00 43.21           N  
ATOM    426  CA  GLU A  60       4.022  74.830  47.555  1.00 45.16           C  
ATOM    427  C   GLU A  60       2.756  74.605  48.382  1.00 44.78           C  
ATOM    428  O   GLU A  60       2.252  75.518  49.030  1.00 44.93           O  
ATOM    429  CB  GLU A  60       3.610  75.189  46.118  1.00 46.82           C  
ATOM    430  CG  GLU A  60       4.683  75.893  45.281  1.00 51.42           C  
ATOM    431  CD  GLU A  60       4.183  76.304  43.894  1.00 53.46           C  
ATOM    432  OE1 GLU A  60       4.941  76.978  43.163  1.00 54.18           O  
ATOM    433  OE2 GLU A  60       3.035  75.960  43.529  1.00 54.42           O  
ATOM    434  N   ALA A  61       2.251  73.375  48.356  1.00 44.63           N  
ATOM    435  CA  ALA A  61       1.043  73.024  49.091  1.00 45.11           C  
ATOM    436  C   ALA A  61       1.316  72.786  50.574  1.00 45.22           C  
ATOM    437  O   ALA A  61       0.488  73.113  51.428  1.00 45.19           O  
ATOM    438  CB  ALA A  61       0.403  71.787  48.471  1.00 45.22           C  
ATOM    439  N   LEU A  62       2.475  72.213  50.880  1.00 45.51           N  
ATOM    440  CA  LEU A  62       2.844  71.941  52.268  1.00 44.84           C  
ATOM    441  C   LEU A  62       3.045  73.234  53.047  1.00 45.44           C  
ATOM    442  O   LEU A  62       2.725  73.316  54.238  1.00 43.99           O  
ATOM    443  CB  LEU A  62       4.121  71.113  52.316  1.00 43.84           C  
ATOM    444  CG  LEU A  62       3.972  69.664  51.862  1.00 44.38           C  
ATOM    445  CD1 LEU A  62       5.338  68.999  51.763  1.00 42.20           C  
ATOM    446  CD2 LEU A  62       3.083  68.934  52.848  1.00 44.20           C  
ATOM    447  N   GLU A  63       3.573  74.243  52.364  1.00 45.41           N  
ATOM    448  CA  GLU A  63       3.818  75.534  52.987  1.00 45.62           C  
ATOM    449  C   GLU A  63       2.560  76.398  52.970  1.00 46.23           C  
ATOM    450  O   GLU A  63       2.611  77.605  53.215  1.00 46.81           O  
ATOM    451  CB  GLU A  63       4.975  76.245  52.280  1.00 45.98           C  
ATOM    452  CG  GLU A  63       4.709  76.643  50.844  1.00 45.99           C  
ATOM    453  CD  GLU A  63       5.971  77.095  50.133  1.00 46.87           C  
ATOM    454  OE1 GLU A  63       6.898  76.266  49.991  1.00 46.27           O  
ATOM    455  OE2 GLU A  63       6.038  78.275  49.724  1.00 46.14           O  
ATOM    456  N   ALA A  64       1.428  75.771  52.680  1.00 45.41           N  
ATOM    457  CA  ALA A  64       0.154  76.473  52.660  1.00 45.01           C  
ATOM    458  C   ALA A  64      -0.824  75.742  53.574  1.00 45.52           C  
ATOM    459  O   ALA A  64      -2.037  75.899  53.461  1.00 46.46           O  
ATOM    460  CB  ALA A  64      -0.392  76.540  51.244  1.00 43.59           C  
ATOM    461  N   GLY A  65      -0.284  74.928  54.474  1.00 46.04           N  
ATOM    462  CA  GLY A  65      -1.128  74.194  55.402  1.00 46.37           C  
ATOM    463  C   GLY A  65      -1.518  72.776  55.016  1.00 46.58           C  
ATOM    464  O   GLY A  65      -1.771  71.959  55.901  1.00 47.98           O  
ATOM    465  N   ILE A  66      -1.574  72.475  53.718  1.00 45.89           N  
ATOM    466  CA  ILE A  66      -1.956  71.140  53.256  1.00 44.38           C  
ATOM    467  C   ILE A  66      -1.038  70.063  53.830  1.00 43.83           C  
ATOM    468  O   ILE A  66       0.186  70.190  53.791  1.00 44.72           O  
ATOM    469  CB  ILE A  66      -1.940  71.070  51.708  1.00 44.17           C  
ATOM    470  CG1 ILE A  66      -2.920  72.094  51.143  1.00 44.72           C  
ATOM    471  CG2 ILE A  66      -2.324  69.682  51.229  1.00 41.48           C  
ATOM    472  CD1 ILE A  66      -2.965  72.122  49.624  1.00 47.08           C  
ATOM    473  N   THR A  67      -1.633  68.999  54.355  1.00 42.57           N  
ATOM    474  CA  THR A  67      -0.864  67.916  54.967  1.00 44.78           C  
ATOM    475  C   THR A  67      -0.445  66.775  54.032  1.00 45.15           C  
ATOM    476  O   THR A  67      -1.117  66.491  53.035  1.00 45.48           O  
ATOM    477  CB  THR A  67      -1.654  67.298  56.121  1.00 44.94           C  
ATOM    478  OG1 THR A  67      -2.842  66.681  55.603  1.00 45.84           O  
ATOM    479  CG2 THR A  67      -2.051  68.368  57.117  1.00 44.33           C  
ATOM    480  N   GLU A  68       0.663  66.116  54.378  1.00 44.18           N  
ATOM    481  CA  GLU A  68       1.185  64.989  53.600  1.00 43.79           C  
ATOM    482  C   GLU A  68       0.100  63.964  53.277  1.00 42.63           C  
ATOM    483  O   GLU A  68      -0.011  63.502  52.139  1.00 42.71           O  
ATOM    484  CB  GLU A  68       2.319  64.296  54.362  1.00 44.20           C  
ATOM    485  CG  GLU A  68       3.690  64.901  54.123  1.00 47.24           C  
ATOM    486  CD  GLU A  68       4.723  64.441  55.139  1.00 49.48           C  
ATOM    487  OE1 GLU A  68       4.773  63.221  55.427  1.00 50.39           O  
ATOM    488  OE2 GLU A  68       5.488  65.301  55.641  1.00 49.24           O  
ATOM    489  N   GLY A  69      -0.693  63.611  54.286  1.00 41.41           N  
ATOM    490  CA  GLY A  69      -1.768  62.655  54.100  1.00 38.23           C  
ATOM    491  C   GLY A  69      -2.766  63.123  53.059  1.00 38.16           C  
ATOM    492  O   GLY A  69      -3.305  62.312  52.302  1.00 37.18           O  
ATOM    493  N   GLU A  70      -3.018  64.429  53.015  1.00 37.27           N  
ATOM    494  CA  GLU A  70      -3.953  64.970  52.041  1.00 36.46           C  
ATOM    495  C   GLU A  70      -3.356  64.893  50.629  1.00 35.53           C  
ATOM    496  O   GLU A  70      -4.081  64.687  49.658  1.00 32.11           O  
ATOM    497  CB  GLU A  70      -4.333  66.410  52.410  1.00 38.05           C  
ATOM    498  CG  GLU A  70      -5.017  66.513  53.779  1.00 41.85           C  
ATOM    499  CD  GLU A  70      -5.494  67.923  54.126  1.00 42.44           C  
ATOM    500  OE1 GLU A  70      -4.706  68.878  53.969  1.00 42.01           O  
ATOM    501  OE2 GLU A  70      -6.657  68.070  54.569  1.00 43.49           O  
ATOM    502  N   LEU A  71      -2.036  65.044  50.519  1.00 34.40           N  
ATOM    503  CA  LEU A  71      -1.383  64.947  49.216  1.00 34.20           C  
ATOM    504  C   LEU A  71      -1.358  63.488  48.753  1.00 32.96           C  
ATOM    505  O   LEU A  71      -1.412  63.205  47.556  1.00 32.63           O  
ATOM    506  CB  LEU A  71       0.048  65.492  49.267  1.00 33.36           C  
ATOM    507  CG  LEU A  71       0.205  67.003  49.450  1.00 33.19           C  
ATOM    508  CD1 LEU A  71       1.673  67.365  49.377  1.00 32.88           C  
ATOM    509  CD2 LEU A  71      -0.581  67.742  48.379  1.00 32.52           C  
ATOM    510  N   ALA A  72      -1.278  62.563  49.705  1.00 30.60           N  
ATOM    511  CA  ALA A  72      -1.260  61.148  49.365  1.00 27.19           C  
ATOM    512  C   ALA A  72      -2.615  60.758  48.786  1.00 26.35           C  
ATOM    513  O   ALA A  72      -2.697  59.947  47.870  1.00 28.94           O  
ATOM    514  CB  ALA A  72      -0.956  60.322  50.588  1.00 26.66           C  
ATOM    515  N   GLU A  73      -3.682  61.338  49.316  1.00 25.16           N  
ATOM    516  CA  GLU A  73      -5.017  61.045  48.817  1.00 23.90           C  
ATOM    517  C   GLU A  73      -5.170  61.629  47.416  1.00 24.01           C  
ATOM    518  O   GLU A  73      -5.824  61.032  46.554  1.00 24.38           O  
ATOM    519  CB  GLU A  73      -6.071  61.633  49.751  1.00 21.44           C  
ATOM    520  CG  GLU A  73      -7.483  61.596  49.200  1.00 24.06           C  
ATOM    521  CD  GLU A  73      -7.933  60.198  48.806  1.00 28.24           C  
ATOM    522  OE1 GLU A  73      -7.294  59.207  49.242  1.00 29.41           O  
ATOM    523  OE2 GLU A  73      -8.939  60.094  48.070  1.00 27.38           O  
ATOM    524  N   ALA A  74      -4.586  62.804  47.203  1.00 22.76           N  
ATOM    525  CA  ALA A  74      -4.631  63.452  45.900  1.00 25.03           C  
ATOM    526  C   ALA A  74      -3.877  62.539  44.943  1.00 25.24           C  
ATOM    527  O   ALA A  74      -4.324  62.282  43.830  1.00 27.12           O  
ATOM    528  CB  ALA A  74      -3.957  64.826  45.955  1.00 24.30           C  
ATOM    529  N   ALA A  75      -2.732  62.042  45.394  1.00 26.02           N  
ATOM    530  CA  ALA A  75      -1.923  61.135  44.589  1.00 27.20           C  
ATOM    531  C   ALA A  75      -2.735  59.871  44.274  1.00 26.93           C  
ATOM    532  O   ALA A  75      -2.733  59.391  43.140  1.00 27.64           O  
ATOM    533  CB  ALA A  75      -0.646  60.771  45.339  1.00 23.75           C  
ATOM    534  N   ALA A  76      -3.429  59.350  45.281  1.00 26.38           N  
ATOM    535  CA  ALA A  76      -4.246  58.149  45.122  1.00 25.59           C  
ATOM    536  C   ALA A  76      -5.249  58.281  43.971  1.00 24.26           C  
ATOM    537  O   ALA A  76      -5.400  57.373  43.163  1.00 23.17           O  
ATOM    538  CB  ALA A  76      -4.983  57.845  46.423  1.00 26.19           C  
ATOM    539  N   VAL A  77      -5.929  59.417  43.901  1.00 25.03           N  
ATOM    540  CA  VAL A  77      -6.907  59.656  42.843  1.00 24.92           C  
ATOM    541  C   VAL A  77      -6.218  59.607  41.485  1.00 24.10           C  
ATOM    542  O   VAL A  77      -6.729  59.011  40.537  1.00 24.01           O  
ATOM    543  CB  VAL A  77      -7.596  61.040  43.008  1.00 25.05           C  
ATOM    544  CG1 VAL A  77      -8.579  61.278  41.873  1.00 24.82           C  
ATOM    545  CG2 VAL A  77      -8.330  61.090  44.332  1.00 26.16           C  
ATOM    546  N   ALA A  78      -5.056  60.238  41.394  1.00 23.97           N  
ATOM    547  CA  ALA A  78      -4.312  60.249  40.142  1.00 24.96           C  
ATOM    548  C   ALA A  78      -3.996  58.819  39.707  1.00 24.09           C  
ATOM    549  O   ALA A  78      -4.061  58.497  38.520  1.00 23.73           O  
ATOM    550  CB  ALA A  78      -3.017  61.060  40.298  1.00 23.02           C  
ATOM    551  N   ALA A  79      -3.665  57.974  40.678  1.00 21.56           N  
ATOM    552  CA  ALA A  79      -3.331  56.579  40.428  1.00 22.51           C  
ATOM    553  C   ALA A  79      -4.557  55.807  39.984  1.00 23.14           C  
ATOM    554  O   ALA A  79      -4.466  54.863  39.192  1.00 22.30           O  
ATOM    555  CB  ALA A  79      -2.742  55.934  41.707  1.00 21.52           C  
ATOM    556  N   LEU A  80      -5.701  56.197  40.529  1.00 24.07           N  
ATOM    557  CA  LEU A  80      -6.956  55.556  40.200  1.00 25.44           C  
ATOM    558  C   LEU A  80      -7.324  55.887  38.760  1.00 26.82           C  
ATOM    559  O   LEU A  80      -7.810  55.026  38.021  1.00 26.26           O  
ATOM    560  CB  LEU A  80      -8.063  56.040  41.140  1.00 24.91           C  
ATOM    561  CG  LEU A  80      -9.460  55.535  40.764  1.00 24.65           C  
ATOM    562  CD1 LEU A  80      -9.470  54.006  40.869  1.00 24.25           C  
ATOM    563  CD2 LEU A  80     -10.517  56.152  41.677  1.00 23.01           C  
ATOM    564  N   ILE A  81      -7.080  57.137  38.370  1.00 26.57           N  
ATOM    565  CA  ILE A  81      -7.387  57.588  37.024  1.00 29.07           C  
ATOM    566  C   ILE A  81      -6.442  56.948  36.004  1.00 30.51           C  
ATOM    567  O   ILE A  81      -6.856  56.649  34.884  1.00 29.75           O  
ATOM    568  CB  ILE A  81      -7.298  59.135  36.916  1.00 30.80           C  
ATOM    569  CG1 ILE A  81      -8.259  59.786  37.916  1.00 30.05           C  
ATOM    570  CG2 ILE A  81      -7.622  59.584  35.497  1.00 32.18           C  
ATOM    571  CD1 ILE A  81      -9.681  59.295  37.824  1.00 29.05           C  
ATOM    572  N   ARG A  82      -5.176  56.744  36.379  1.00 30.75           N  
ATOM    573  CA  ARG A  82      -4.233  56.109  35.459  1.00 31.38           C  
ATOM    574  C   ARG A  82      -4.688  54.671  35.209  1.00 31.41           C  
ATOM    575  O   ARG A  82      -4.584  54.166  34.090  1.00 31.52           O  
ATOM    576  CB  ARG A  82      -2.806  56.090  36.018  1.00 33.57           C  
ATOM    577  CG  ARG A  82      -2.134  57.452  36.177  1.00 39.44           C  
ATOM    578  CD  ARG A  82      -0.635  57.357  35.895  1.00 42.82           C  
ATOM    579  NE  ARG A  82      -0.383  57.168  34.465  1.00 46.00           N  
ATOM    580  CZ  ARG A  82       0.751  56.701  33.951  1.00 46.67           C  
ATOM    581  NH1 ARG A  82       0.879  56.571  32.637  1.00 48.02           N  
ATOM    582  NH2 ARG A  82       1.751  56.350  34.745  1.00 46.03           N  
ATOM    583  N   ALA A  83      -5.190  54.010  36.250  1.00 29.82           N  
ATOM    584  CA  ALA A  83      -5.666  52.639  36.108  1.00 30.51           C  
ATOM    585  C   ALA A  83      -7.031  52.620  35.414  1.00 31.89           C  
ATOM    586  O   ALA A  83      -7.304  51.752  34.577  1.00 31.74           O  
ATOM    587  CB  ALA A  83      -5.756  51.962  37.471  1.00 27.89           C  
ATOM    588  N   GLY A  84      -7.878  53.586  35.765  1.00 31.49           N  
ATOM    589  CA  GLY A  84      -9.199  53.674  35.171  1.00 30.38           C  
ATOM    590  C   GLY A  84      -9.118  53.932  33.681  1.00 30.99           C  
ATOM    591  O   GLY A  84      -9.818  53.294  32.891  1.00 30.27           O  
ATOM    592  N   SER A  85      -8.259  54.864  33.286  1.00 30.57           N  
ATOM    593  CA  SER A  85      -8.106  55.168  31.872  1.00 31.37           C  
ATOM    594  C   SER A  85      -7.678  53.930  31.074  1.00 31.42           C  
ATOM    595  O   SER A  85      -8.147  53.719  29.959  1.00 30.63           O  
ATOM    596  CB  SER A  85      -7.111  56.322  31.667  1.00 31.11           C  
ATOM    597  OG  SER A  85      -5.870  56.091  32.314  1.00 32.75           O  
ATOM    598  N   ALA A  86      -6.809  53.103  31.647  1.00 31.37           N  
ATOM    599  CA  ALA A  86      -6.369  51.893  30.958  1.00 33.38           C  
ATOM    600  C   ALA A  86      -7.520  50.892  30.888  1.00 35.20           C  
ATOM    601  O   ALA A  86      -7.648  50.149  29.916  1.00 35.75           O  
ATOM    602  CB  ALA A  86      -5.179  51.275  31.678  1.00 33.53           C  
HETATM  603  N   MSE A  87      -8.357  50.875  31.921  1.00 37.33           N  
HETATM  604  CA  MSE A  87      -9.512  49.979  31.955  1.00 40.38           C  
HETATM  605  C   MSE A  87     -10.394  50.272  30.748  1.00 37.29           C  
HETATM  606  O   MSE A  87     -10.889  49.362  30.091  1.00 37.06           O  
HETATM  607  CB  MSE A  87     -10.339  50.206  33.222  1.00 48.74           C  
HETATM  608  CG  MSE A  87      -9.577  50.070  34.529  1.00 60.99           C  
HETATM  609 SE   MSE A  87      -9.145  48.244  35.019  1.00 79.49          SE  
HETATM  610  CE  MSE A  87     -10.696  47.838  36.099  1.00 73.69           C  
ATOM    611  N   ASN A  88     -10.594  51.552  30.471  1.00 34.33           N  
ATOM    612  CA  ASN A  88     -11.422  51.982  29.350  1.00 33.27           C  
ATOM    613  C   ASN A  88     -10.879  51.463  28.015  1.00 30.98           C  
ATOM    614  O   ASN A  88     -11.634  51.009  27.162  1.00 30.32           O  
ATOM    615  CB  ASN A  88     -11.503  53.512  29.327  1.00 35.15           C  
ATOM    616  CG  ASN A  88     -12.375  54.032  28.209  1.00 36.52           C  
ATOM    617  OD1 ASN A  88     -13.565  53.732  28.152  1.00 36.92           O  
ATOM    618  ND2 ASN A  88     -11.787  54.815  27.309  1.00 37.70           N  
ATOM    619  N   THR A  89      -9.564  51.539  27.847  1.00 28.58           N  
ATOM    620  CA  THR A  89      -8.902  51.067  26.638  1.00 25.85           C  
ATOM    621  C   THR A  89      -9.048  49.546  26.546  1.00 26.06           C  
ATOM    622  O   THR A  89      -9.220  48.981  25.458  1.00 23.06           O  
ATOM    623  CB  THR A  89      -7.393  51.387  26.676  1.00 25.32           C  
ATOM    624  OG1 THR A  89      -7.198  52.748  27.079  1.00 26.46           O  
ATOM    625  CG2 THR A  89      -6.767  51.166  25.301  1.00 23.01           C  
ATOM    626  N   ALA A  90      -8.974  48.897  27.707  1.00 25.37           N  
ATOM    627  CA  ALA A  90      -9.067  47.444  27.807  1.00 24.65           C  
ATOM    628  C   ALA A  90     -10.376  46.862  27.282  1.00 24.42           C  
ATOM    629  O   ALA A  90     -10.435  45.680  26.932  1.00 24.86           O  
ATOM    630  CB  ALA A  90      -8.833  47.008  29.253  1.00 22.19           C  
ATOM    631  N   SER A  91     -11.424  47.672  27.210  1.00 25.50           N  
ATOM    632  CA  SER A  91     -12.693  47.155  26.694  1.00 27.51           C  
ATOM    633  C   SER A  91     -12.561  46.873  25.184  1.00 27.59           C  
ATOM    634  O   SER A  91     -13.378  46.159  24.601  1.00 27.80           O  
ATOM    635  CB  SER A  91     -13.810  48.163  26.921  1.00 25.73           C  
ATOM    636  OG  SER A  91     -13.668  49.223  26.006  1.00 29.42           O  
ATOM    637  N   ALA A  92     -11.527  47.434  24.564  1.00 26.80           N  
ATOM    638  CA  ALA A  92     -11.277  47.238  23.141  1.00 28.20           C  
ATOM    639  C   ALA A  92     -10.713  45.859  22.806  1.00 29.64           C  
ATOM    640  O   ALA A  92     -10.411  45.588  21.643  1.00 29.84           O  
ATOM    641  CB  ALA A  92     -10.335  48.312  22.620  1.00 26.82           C  
ATOM    642  N   ILE A  93     -10.548  44.992  23.804  1.00 30.78           N  
ATOM    643  CA  ILE A  93     -10.039  43.651  23.523  1.00 31.28           C  
ATOM    644  C   ILE A  93     -11.193  42.797  23.005  1.00 31.63           C  
ATOM    645  O   ILE A  93     -10.976  41.708  22.465  1.00 33.40           O  
ATOM    646  CB  ILE A  93      -9.428  42.932  24.775  1.00 31.40           C  
ATOM    647  CG1 ILE A  93     -10.493  42.737  25.855  1.00 32.30           C  
ATOM    648  CG2 ILE A  93      -8.238  43.699  25.303  1.00 31.02           C  
ATOM    649  CD1 ILE A  93     -10.021  41.878  27.016  1.00 30.64           C  
ATOM    650  N   PHE A  94     -12.415  43.295  23.176  1.00 30.31           N  
ATOM    651  CA  PHE A  94     -13.604  42.583  22.716  1.00 32.47           C  
ATOM    652  C   PHE A  94     -13.976  43.012  21.301  1.00 33.36           C  
ATOM    653  O   PHE A  94     -13.663  44.128  20.876  1.00 33.74           O  
ATOM    654  CB  PHE A  94     -14.785  42.832  23.663  1.00 29.15           C  
ATOM    655  CG  PHE A  94     -14.524  42.386  25.068  1.00 29.10           C  
ATOM    656  CD1 PHE A  94     -14.203  43.304  26.062  1.00 28.07           C  
ATOM    657  CD2 PHE A  94     -14.521  41.036  25.388  1.00 28.73           C  
ATOM    658  CE1 PHE A  94     -13.879  42.882  27.349  1.00 26.20           C  
ATOM    659  CE2 PHE A  94     -14.195  40.608  26.676  1.00 26.68           C  
ATOM    660  CZ  PHE A  94     -13.874  41.536  27.652  1.00 28.01           C  
ATOM    661  N   ARG A  95     -14.650  42.118  20.581  1.00 36.28           N  
ATOM    662  CA  ARG A  95     -15.062  42.367  19.199  1.00 37.05           C  
ATOM    663  C   ARG A  95     -16.172  43.408  19.000  1.00 36.76           C  
ATOM    664  O   ARG A  95     -17.019  43.602  19.905  1.00 35.31           O  
ATOM    665  CB  ARG A  95     -15.489  41.049  18.547  1.00 37.26           C  
ATOM    666  CG  ARG A  95     -14.373  40.014  18.448  1.00 38.54           C  
ATOM    667  CD  ARG A  95     -14.618  39.106  17.251  1.00 39.88           C  
ATOM    668  NE  ARG A  95     -13.411  38.410  16.816  1.00 39.59           N  
ATOM    669  CZ  ARG A  95     -12.958  37.281  17.346  1.00 38.04           C  
ATOM    670  NH1 ARG A  95     -13.613  36.701  18.342  1.00 34.70           N  
ATOM    671  NH2 ARG A  95     -11.837  36.743  16.880  1.00 37.62           N  
TER     672      ARG A  95                                                      
END
MOLECULE T0408.pdb
ATOM    769  N   PHE     7       8.970  79.991  40.219  1.00 59.01           N  
ATOM    770  CA  PHE     7       9.121  78.887  39.220  1.00 58.55           C  
ATOM    771  C   PHE     7      10.525  78.270  39.318  1.00 57.17           C  
ATOM    772  O   PHE     7      11.448  78.885  39.884  1.00 59.33           O  
ATOM    773  CB  PHE     7       8.894  79.403  37.792  1.00 59.50           C  
ATOM    774  CG  PHE     7       7.630  80.211  37.607  1.00 59.88           C  
ATOM    775  CD1 PHE     7       7.640  81.590  37.779  1.00 59.55           C  
ATOM    776  CD2 PHE     7       6.441  79.594  37.219  1.00 60.26           C  
ATOM    777  CE1 PHE     7       6.481  82.338  37.600  1.00 63.27           C  
ATOM    778  CE2 PHE     7       5.280  80.335  37.027  1.00 57.96           C  
ATOM    779  CZ  PHE     7       5.299  81.709  37.222  1.00 60.10           C  
ATOM    780  N   GLY     8      10.693  77.077  38.739  1.00 51.97           N  
ATOM    781  CA  GLY     8      11.946  76.308  38.864  1.00 47.06           C  
ATOM    782  C   GLY     8      13.010  76.644  37.842  1.00 42.74           C  
ATOM    783  O   GLY     8      12.960  77.691  37.199  1.00 40.60           O  
ATOM    784  N   GLU     9      13.969  75.734  37.690  1.00 39.01           N  
ATOM    785  CA  GLU     9      15.125  75.924  36.812  1.00 38.04           C  
ATOM    786  C   GLU     9      14.737  76.079  35.344  1.00 34.61           C  
ATOM    787  O   GLU     9      15.312  76.893  34.624  1.00 33.70           O  
ATOM    788  CB  GLU     9      16.093  74.746  36.964  1.00 38.65           C  
ATOM    789  N   GLY    10      13.750  75.287  34.915  1.00 34.19           N  
ATOM    790  CA  GLY    10      13.250  75.348  33.551  1.00 31.10           C  
ATOM    791  C   GLY    10      12.790  76.744  33.220  1.00 25.97           C  
ATOM    792  O   GLY    10      13.200  77.304  32.203  1.00 24.44           O  
ATOM    793  N   MET    11      11.958  77.314  34.091  1.00 26.78           N  
ATOM    794  CA  MET    11      11.453  78.679  33.871  1.00 26.99           C  
ATOM    795  C   MET    11      12.547  79.734  33.936  1.00 24.54           C  
ATOM    796  O   MET    11      12.436  80.750  33.237  1.00 22.59           O  
ATOM    797  CB  MET    11      10.298  79.036  34.809  1.00 26.96           C  
ATOM    798  CG  MET    11       8.956  78.424  34.384  1.00 30.81           C  
ATOM    799  SD  MET    11       8.363  79.163  32.682  0.75 32.36          SE  
ATOM    800  CE  MET    11       7.641  80.815  33.439  1.00 38.14           C  
ATOM    801  N   LYS    12      13.587  79.531  34.749  1.00 22.58           N  
ATOM    802  CA  LYS    12      14.709  80.488  34.749  1.00 22.98           C  
ATOM    803  C   LYS    12      15.471  80.468  33.411  1.00 20.97           C  
ATOM    804  O   LYS    12      15.931  81.507  32.944  1.00 22.83           O  
ATOM    805  CB  LYS    12      15.656  80.233  35.932  1.00 24.68           C  
ATOM    806  CG  LYS    12      14.987  80.568  37.290  1.00 26.05           C  
ATOM    807  CD  LYS    12      15.724  79.996  38.524  1.00 31.53           C  
ATOM    808  CE  LYS    12      17.178  80.177  38.487  1.00 33.33           C  
ATOM    809  NZ  LYS    12      17.857  79.899  39.811  1.00 35.75           N  
ATOM    810  N   VAL    13      15.558  79.292  32.784  1.00 23.05           N  
ATOM    811  CA  VAL    13      16.174  79.143  31.455  1.00 22.27           C  
ATOM    812  C   VAL    13      15.338  79.931  30.437  1.00 19.87           C  
ATOM    813  O   VAL    13      15.870  80.675  29.599  1.00 19.37           O  
ATOM    814  CB  VAL    13      16.227  77.631  31.026  1.00 24.12           C  
ATOM    815  CG1 VAL    13      16.716  77.489  29.584  1.00 25.29           C  
ATOM    816  CG2 VAL    13      17.136  76.836  31.979  1.00 30.23           C  
ATOM    817  N   VAL    14      14.032  79.817  30.576  1.00 20.72           N  
ATOM    818  CA  VAL    14      13.119  80.535  29.668  1.00 22.65           C  
ATOM    819  C   VAL    14      13.274  82.037  29.865  1.00 19.62           C  
ATOM    820  O   VAL    14      13.348  82.784  28.895  1.00 20.37           O  
ATOM    821  CB  VAL    14      11.657  80.121  29.823  1.00 21.69           C  
ATOM    822  CG1 VAL    14      10.788  80.938  28.849  1.00 21.74           C  
ATOM    823  CG2 VAL    14      11.465  78.585  29.542  1.00 26.25           C  
ATOM    824  N   LYS    15      13.332  82.483  31.131  1.00 21.22           N  
ATOM    825  CA  LYS    15      13.580  83.912  31.414  1.00 18.46           C  
ATOM    826  C   LYS    15      14.866  84.401  30.767  1.00 19.65           C  
ATOM    827  O   LYS    15      14.894  85.480  30.187  1.00 22.14           O  
ATOM    828  CB  LYS    15      13.617  84.181  32.921  1.00 18.27           C  
ATOM    829  N   GLU    16      15.918  83.608  30.857  1.00 21.08           N  
ATOM    830  CA  GLU    16      17.202  83.950  30.227  1.00 22.56           C  
ATOM    831  C   GLU    16      17.144  83.974  28.678  1.00 22.82           C  
ATOM    832  O   GLU    16      17.665  84.891  28.042  1.00 28.47           O  
ATOM    833  CB  GLU    16      18.277  82.981  30.693  1.00 24.31           C  
ATOM    834  N   LYS    17      16.521  82.963  28.097  1.00 21.86           N  
ATOM    835  CA  LYS    17      16.542  82.770  26.636  1.00 22.20           C  
ATOM    836  C   LYS    17      15.493  83.586  25.851  1.00 21.86           C  
ATOM    837  O   LYS    17      15.808  84.146  24.776  1.00 23.86           O  
ATOM    838  CB  LYS    17      16.365  81.277  26.315  1.00 21.29           C  
ATOM    839  N   TYR    18      14.290  83.672  26.407  1.00 22.99           N  
ATOM    840  CA  TYR    18      13.084  84.212  25.724  1.00 24.08           C  
ATOM    841  C   TYR    18      12.235  85.030  26.691  1.00 21.96           C  
ATOM    842  O   TYR    18      11.217  84.579  27.196  1.00 21.62           O  
ATOM    843  CB  TYR    18      12.270  83.071  25.102  1.00 23.86           C  
ATOM    844  CG  TYR    18      13.142  82.276  24.153  1.00 25.16           C  
ATOM    845  CD1 TYR    18      13.658  82.867  23.007  1.00 22.60           C  
ATOM    846  CD2 TYR    18      13.503  80.967  24.432  1.00 27.55           C  
ATOM    847  CE1 TYR    18      14.496  82.174  22.142  1.00 26.49           C  
ATOM    848  CE2 TYR    18      14.364  80.270  23.576  1.00 26.29           C  
ATOM    849  CZ  TYR    18      14.846  80.874  22.433  1.00 25.54           C  
ATOM    850  OH  TYR    18      15.686  80.188  21.581  1.00 26.16           O  
ATOM    851  N   PRO    19      12.703  86.256  26.994  1.00 22.95           N  
ATOM    852  CA  PRO    19      12.008  87.103  27.963  1.00 20.97           C  
ATOM    853  C   PRO    19      10.540  87.377  27.666  1.00 23.47           C  
ATOM    854  O   PRO    19       9.729  87.342  28.598  1.00 22.73           O  
ATOM    855  CB  PRO    19      12.823  88.395  27.933  1.00 22.49           C  
ATOM    856  CG  PRO    19      14.111  88.033  27.370  1.00 24.22           C  
ATOM    857  CD  PRO    19      13.956  86.869  26.528  1.00 23.77           C  
ATOM    858  N   ASP    20      10.175  87.629  26.413  1.00 23.93           N  
ATOM    859  CA  ASP    20       8.772  87.917  26.104  1.00 28.48           C  
ATOM    860  C   ASP    20       7.908  86.671  26.266  1.00 26.25           C  
ATOM    861  O   ASP    20       6.756  86.723  26.775  1.00 26.13           O  
ATOM    862  CB  ASP    20       8.618  88.482  24.690  1.00 30.80           C  
ATOM    863  CG  ASP    20       9.052  89.954  24.570  1.00 38.16           C  
ATOM    864  OD1 ASP    20       9.402  90.617  25.580  1.00 42.94           O  
ATOM    865  OD2 ASP    20       9.033  90.451  23.426  1.00 46.06           O  
ATOM    866  N   LEU    21       8.444  85.524  25.878  1.00 24.97           N  
ATOM    867  CA  LEU    21       7.721  84.269  26.090  1.00 23.54           C  
ATOM    868  C   LEU    21       7.555  83.994  27.575  1.00 22.52           C  
ATOM    869  O   LEU    21       6.474  83.604  28.042  1.00 24.44           O  
ATOM    870  CB  LEU    21       8.447  83.115  25.385  1.00 23.74           C  
ATOM    871  CG  LEU    21       7.857  81.731  25.468  1.00 25.87           C  
ATOM    872  CD1 LEU    21       6.373  81.718  24.990  1.00 25.00           C  
ATOM    873  CD2 LEU    21       8.754  80.756  24.680  1.00 23.70           C  
ATOM    874  N   TYR    22       8.626  84.193  28.326  1.00 22.41           N  
ATOM    875  CA  TYR    22       8.584  84.070  29.780  1.00 22.77           C  
ATOM    876  C   TYR    22       7.435  84.913  30.380  1.00 22.67           C  
ATOM    877  O   TYR    22       6.627  84.425  31.175  1.00 23.91           O  
ATOM    878  CB  TYR    22       9.912  84.494  30.385  1.00 23.66           C  
ATOM    879  CG  TYR    22       9.886  84.492  31.893  1.00 22.50           C  
ATOM    880  CD1 TYR    22      10.074  83.325  32.604  1.00 23.27           C  
ATOM    881  CD2 TYR    22       9.660  85.671  32.602  1.00 25.67           C  
ATOM    882  CE1 TYR    22      10.047  83.327  33.987  1.00 21.18           C  
ATOM    883  CE2 TYR    22       9.622  85.671  33.963  1.00 25.00           C  
ATOM    884  CZ  TYR    22       9.808  84.488  34.647  1.00 23.45           C  
ATOM    885  OH  TYR    22       9.784  84.487  35.999  1.00 27.44           O  
ATOM    886  N   ASP    23       7.378  86.174  29.980  1.00 23.82           N  
ATOM    887  CA  ASP    23       6.360  87.088  30.502  1.00 24.16           C  
ATOM    888  C   ASP    23       4.927  86.625  30.205  1.00 25.07           C  
ATOM    889  O   ASP    23       4.046  86.754  31.064  1.00 23.28           O  
ATOM    890  CB  ASP    23       6.577  88.482  29.910  1.00 24.42           C  
ATOM    891  CG  ASP    23       7.742  89.194  30.505  1.00 33.39           C  
ATOM    892  OD1 ASP    23       8.216  88.809  31.607  1.00 34.11           O  
ATOM    893  OD2 ASP    23       8.170  90.189  29.868  1.00 37.66           O  
ATOM    894  N   ILE    24       4.693  86.066  29.019  1.00 23.65           N  
ATOM    895  CA  ILE    24       3.350  85.619  28.651  1.00 24.84           C  
ATOM    896  C   ILE    24       3.018  84.370  29.489  1.00 23.61           C  
ATOM    897  O   ILE    24       1.899  84.210  29.967  1.00 24.22           O  
ATOM    898  CB  ILE    24       3.222  85.316  27.150  1.00 27.79           C  
ATOM    899  CG1 ILE    24       3.448  86.587  26.329  1.00 32.72           C  
ATOM    900  CG2 ILE    24       1.848  84.746  26.841  1.00 30.67           C  
ATOM    901  CD1 ILE    24       3.838  86.311  24.854  1.00 35.16           C  
ATOM    902  N   ILE    25       4.024  83.514  29.707  1.00 24.35           N  
ATOM    903  CA  ILE    25       3.817  82.316  30.523  1.00 24.21           C  
ATOM    904  C   ILE    25       3.445  82.707  31.965  1.00 23.22           C  
ATOM    905  O   ILE    25       2.509  82.132  32.562  1.00 25.47           O  
ATOM    906  CB  ILE    25       5.047  81.338  30.493  1.00 24.22           C  
ATOM    907  CG1 ILE    25       5.238  80.729  29.103  1.00 23.74           C  
ATOM    908  CG2 ILE    25       4.856  80.188  31.494  1.00 29.35           C  
ATOM    909  CD1 ILE    25       6.631  80.075  28.922  1.00 23.35           C  
ATOM    910  N   VAL    26       4.144  83.697  32.511  1.00 24.58           N  
ATOM    911  CA  VAL    26       3.846  84.171  33.859  1.00 26.19           C  
ATOM    912  C   VAL    26       2.405  84.710  33.937  1.00 24.90           C  
ATOM    913  O   VAL    26       1.639  84.349  34.854  1.00 24.16           O  
ATOM    914  CB  VAL    26       4.836  85.230  34.313  1.00 28.22           C  
ATOM    915  CG1 VAL    26       4.301  85.976  35.531  1.00 28.71           C  
ATOM    916  CG2 VAL    26       6.242  84.589  34.603  1.00 26.39           C  
ATOM    917  N   LYS    27       2.006  85.523  32.967  1.00 23.37           N  
ATOM    918  CA  LYS    27       0.622  86.024  32.925  0.50 23.88           C  
ATOM    920  C   LYS    27      -0.377  84.879  32.823  1.00 24.17           C  
ATOM    921  O   LYS    27      -1.387  84.886  33.498  1.00 24.41           O  
ATOM    922  CB  LYS    27       0.414  87.028  31.779  0.50 24.31           C  
ATOM    924  CG  LYS    27       1.172  88.334  31.934  0.50 20.98           C  
ATOM    926  N   LEU    28      -0.091  83.873  31.981  1.00 23.31           N  
ATOM    927  CA  LEU    28      -0.962  82.705  31.832  1.00 25.23           C  
ATOM    928  C   LEU    28      -1.121  81.995  33.180  1.00 25.13           C  
ATOM    929  O   LEU    28      -2.231  81.653  33.640  1.00 24.63           O  
ATOM    930  CB  LEU    28      -0.374  81.739  30.788  1.00 23.04           C  
ATOM    931  CG  LEU    28      -1.148  80.428  30.624  1.00 24.78           C  
ATOM    932  CD1 LEU    28      -2.545  80.697  30.079  1.00 32.09           C  
ATOM    933  CD2 LEU    28      -0.369  79.493  29.738  1.00 28.12           C  
ATOM    934  N   ASN    29       0.023  81.773  33.828  1.00 22.56           N  
ATOM    935  CA  ASN    29       0.048  81.101  35.117  1.00 24.38           C  
ATOM    936  C   ASN    29      -0.813  81.844  36.140  1.00 22.89           C  
ATOM    937  O   ASN    29      -1.651  81.255  36.839  1.00 26.79           O  
ATOM    938  CB  ASN    29       1.491  80.993  35.606  1.00 27.63           C  
ATOM    939  CG  ASN    29       1.585  80.340  36.962  1.00 33.82           C  
ATOM    940  OD1 ASN    29       1.667  79.126  37.053  1.00 33.33           O  
ATOM    941  ND2 ASN    29       1.566  81.143  38.011  1.00 35.43           N  
ATOM    942  N   ASP    30      -0.596  83.141  36.234  1.00 22.88           N  
ATOM    943  CA  ASP    30      -1.285  83.973  37.203  1.00 24.82           C  
ATOM    944  C   ASP    30      -2.797  84.034  36.943  1.00 25.07           C  
ATOM    945  O   ASP    30      -3.601  84.001  37.880  1.00 26.99           O  
ATOM    946  CB  ASP    30      -0.694  85.365  37.193  1.00 26.68           C  
ATOM    947  CG  ASP    30       0.726  85.408  37.720  1.00 28.43           C  
ATOM    948  OD1 ASP    30       1.234  84.358  38.174  1.00 35.44           O  
ATOM    949  OD2 ASP    30       1.331  86.499  37.649  1.00 29.80           O  
ATOM    950  N   THR    31      -3.173  84.070  35.675  1.00 22.79           N  
ATOM    951  CA  THR    31      -4.600  83.984  35.289  1.00 24.26           C  
ATOM    952  C   THR    31      -5.213  82.620  35.540  1.00 23.93           C  
ATOM    953  O   THR    31      -6.339  82.515  36.082  1.00 24.83           O  
ATOM    954  CB  THR    31      -4.809  84.366  33.824  1.00 22.72           C  
ATOM    955  OG1 THR    31      -4.260  85.683  33.614  1.00 30.25           O  
ATOM    956  CG2 THR    31      -6.307  84.307  33.460  1.00 24.57           C  
ATOM    957  N   VAL    32      -4.509  81.554  35.146  1.00 22.77           N  
ATOM    958  CA  VAL    32      -4.974  80.194  35.438  1.00 24.03           C  
ATOM    959  C   VAL    32      -5.286  80.043  36.936  1.00 23.77           C  
ATOM    960  O   VAL    32      -6.329  79.469  37.304  1.00 25.63           O  
ATOM    961  CB  VAL    32      -3.924  79.174  34.994  1.00 23.98           C  
ATOM    962  CG1 VAL    32      -4.033  77.835  35.796  1.00 24.54           C  
ATOM    963  CG2 VAL    32      -4.012  78.986  33.460  1.00 22.05           C  
ATOM    964  N   PHE    33      -4.431  80.590  37.799  1.00 23.43           N  
ATOM    965  CA  PHE    33      -4.601  80.397  39.246  1.00 25.33           C  
ATOM    966  C   PHE    33      -5.403  81.502  39.922  1.00 27.87           C  
ATOM    967  O   PHE    33      -5.384  81.637  41.159  1.00 27.20           O  
ATOM    968  CB  PHE    33      -3.266  80.181  39.951  1.00 27.45           C  
ATOM    969  CG  PHE    33      -2.688  78.829  39.709  1.00 26.58           C  
ATOM    970  CD1 PHE    33      -3.361  77.688  40.124  1.00 26.58           C  
ATOM    971  CD2 PHE    33      -1.487  78.692  39.040  1.00 27.16           C  
ATOM    972  CE1 PHE    33      -2.844  76.433  39.875  1.00 26.69           C  
ATOM    973  CE2 PHE    33      -0.960  77.444  38.790  1.00 25.47           C  
ATOM    974  CZ  PHE    33      -1.643  76.315  39.204  1.00 28.16           C  
ATOM    975  N   THR    34      -6.104  82.288  39.114  1.00 28.08           N  
ATOM    976  CA  THR    34      -7.123  83.205  39.620  1.00 27.68           C  
ATOM    977  C   THR    34      -8.472  82.607  39.227  1.00 26.27           C  
ATOM    978  O   THR    34      -9.079  82.991  38.223  1.00 24.59           O  
ATOM    979  CB  THR    34      -6.912  84.630  39.078  1.00 29.15           C  
ATOM    980  OG1 THR    34      -5.572  85.039  39.354  1.00 27.52           O  
ATOM    981  CG2 THR    34      -7.858  85.624  39.752  1.00 27.57           C  
ATOM    982  N   GLY    35      -8.916  81.627  40.013  1.00 23.37           N  
ATOM    983  CA  GLY    35     -10.169  80.966  39.763  1.00 26.15           C  
ATOM    984  C   GLY    35     -11.353  81.880  40.008  1.00 26.00           C  
ATOM    985  O   GLY    35     -11.261  82.862  40.761  1.00 26.21           O  
ATOM    986  N   LYS    36     -12.466  81.593  39.353  1.00 26.20           N  
ATOM    987  CA  LYS    36     -13.707  82.364  39.626  1.00 25.52           C  
ATOM    988  C   LYS    36     -14.401  81.918  40.902  1.00 25.59           C  
ATOM    989  O   LYS    36     -15.013  82.749  41.608  1.00 24.82           O  
ATOM    990  CB  LYS    36     -14.650  82.280  38.433  1.00 23.76           C  
ATOM    991  CG  LYS    36     -14.018  82.839  37.170  1.00 27.92           C  
ATOM    992  CD  LYS    36     -13.636  84.274  37.261  1.00 33.79           C  
ATOM    993  CE  LYS    36     -13.123  84.756  35.913  1.00 33.74           C  
ATOM    994  NZ  LYS    36     -12.672  86.191  35.921  1.00 36.41           N  
ATOM    995  N   THR    37     -14.305  80.634  41.224  1.00 26.34           N  
ATOM    996  CA  THR    37     -14.895  80.088  42.444  1.00 27.40           C  
ATOM    997  C   THR    37     -13.901  79.304  43.281  1.00 28.68           C  
ATOM    998  O   THR    37     -13.830  79.501  44.486  1.00 28.44           O  
ATOM    999  CB  THR    37     -16.085  79.125  42.147  1.00 30.61           C  
ATOM   1000  OG1 THR    37     -17.140  79.845  41.507  1.00 34.12           O  
ATOM   1001  CG2 THR    37     -16.683  78.562  43.442  1.00 27.91           C  
ATOM   1002  N   LEU    38     -13.154  78.398  42.652  1.00 24.44           N  
ATOM   1003  CA  LEU    38     -12.190  77.556  43.382  1.00 24.53           C  
ATOM   1004  C   LEU    38     -11.018  78.408  43.841  1.00 26.73           C  
ATOM   1005  O   LEU    38     -10.561  79.304  43.117  1.00 26.13           O  
ATOM   1006  CB  LEU    38     -11.682  76.416  42.494  1.00 24.24           C  
ATOM   1007  CG  LEU    38     -12.721  75.446  41.996  1.00 25.01           C  
ATOM   1008  CD1 LEU    38     -12.043  74.310  41.217  1.00 23.26           C  
ATOM   1009  CD2 LEU    38     -13.555  74.919  43.151  1.00 22.80           C  
ATOM   1010  N   ASP    39     -10.539  78.150  45.053  1.00 25.77           N  
ATOM   1011  CA  ASP    39      -9.405  78.915  45.556  1.00 26.59           C  
ATOM   1012  C   ASP    39      -8.085  78.324  45.076  1.00 26.80           C  
ATOM   1013  O   ASP    39      -8.046  77.280  44.439  1.00 24.07           O  
ATOM   1014  CB  ASP    39      -9.484  79.093  47.084  1.00 27.84           C  
ATOM   1015  CG  ASP    39      -9.352  77.804  47.861  1.00 31.36           C  
ATOM   1016  OD1 ASP    39      -8.887  76.754  47.351  1.00 28.62           O  
ATOM   1017  OD2 ASP    39      -9.729  77.848  49.052  1.00 33.78           O  
ATOM   1018  N   TYR    40      -7.011  79.046  45.327  1.00 25.33           N  
ATOM   1019  CA  TYR    40      -5.703  78.664  44.822  1.00 24.51           C  
ATOM   1020  C   TYR    40      -5.243  77.312  45.372  1.00 25.46           C  
ATOM   1021  O   TYR    40      -4.698  76.478  44.641  1.00 24.60           O  
ATOM   1022  CB  TYR    40      -4.723  79.753  45.247  1.00 28.58           C  
ATOM   1023  CG  TYR    40      -3.320  79.640  44.733  1.00 27.35           C  
ATOM   1024  CD1 TYR    40      -3.051  79.264  43.426  1.00 42.63           C  
ATOM   1025  CD2 TYR    40      -2.241  79.981  45.555  1.00 35.86           C  
ATOM   1026  CE1 TYR    40      -1.744  79.202  42.958  1.00 45.32           C  
ATOM   1027  CE2 TYR    40      -0.946  79.919  45.099  1.00 36.50           C  
ATOM   1028  CZ  TYR    40      -0.701  79.543  43.803  1.00 41.69           C  
ATOM   1029  OH  TYR    40       0.596  79.495  43.344  1.00 43.10           O  
ATOM   1030  N   LYS    41      -5.466  77.097  46.659  1.00 24.17           N  
ATOM   1031  CA  LYS    41      -5.137  75.787  47.259  1.00 26.03           C  
ATOM   1032  C   LYS    41      -5.786  74.622  46.516  1.00 24.80           C  
ATOM   1033  O   LYS    41      -5.121  73.627  46.222  1.00 24.41           O  
ATOM   1034  CB  LYS    41      -5.525  75.756  48.725  1.00 26.17           C  
ATOM   1035  CG  LYS    41      -5.211  74.458  49.459  1.00 31.58           C  
ATOM   1036  CD  LYS    41      -5.774  74.499  50.886  1.00 33.11           C  
ATOM   1037  CE  LYS    41      -5.347  73.283  51.704  1.00 42.88           C  
ATOM   1038  NZ  LYS    41      -5.846  73.354  53.109  1.00 41.08           N  
ATOM   1039  N   THR    42      -7.074  74.738  46.237  1.00 24.70           N  
ATOM   1040  CA  THR    42      -7.798  73.688  45.520  1.00 23.81           C  
ATOM   1041  C   THR    42      -7.217  73.448  44.133  1.00 24.23           C  
ATOM   1042  O   THR    42      -7.022  72.317  43.719  1.00 23.25           O  
ATOM   1043  CB  THR    42      -9.301  73.985  45.416  1.00 24.82           C  
ATOM   1044  OG1 THR    42      -9.845  74.084  46.733  1.00 25.22           O  
ATOM   1045  CG2 THR    42     -10.038  72.883  44.667  1.00 25.77           C  
ATOM   1046  N   GLN    43      -6.933  74.527  43.418  1.00 23.43           N  
ATOM   1047  CA  GLN    43      -6.319  74.414  42.118  1.00 22.86           C  
ATOM   1048  C   GLN    43      -4.922  73.781  42.157  1.00 23.94           C  
ATOM   1049  O   GLN    43      -4.585  73.025  41.268  1.00 22.91           O  
ATOM   1050  CB  GLN    43      -6.246  75.772  41.437  1.00 24.01           C  
ATOM   1051  CG  GLN    43      -7.565  76.328  41.029  1.00 22.72           C  
ATOM   1052  CD  GLN    43      -7.399  77.608  40.263  1.00 23.02           C  
ATOM   1053  OE1 GLN    43      -6.876  78.573  40.809  1.00 25.62           O  
ATOM   1054  NE2 GLN    43      -7.853  77.631  39.000  1.00 24.23           N  
ATOM   1055  N   LYS    44      -4.119  74.119  43.152  1.00 23.49           N  
ATOM   1056  CA  LYS    44      -2.798  73.504  43.293  1.00 22.94           C  
ATOM   1057  C   LYS    44      -2.885  72.010  43.618  1.00 23.73           C  
ATOM   1058  O   LYS    44      -2.073  71.231  43.139  1.00 23.97           O  
ATOM   1059  CB  LYS    44      -1.964  74.236  44.353  1.00 26.12           C  
ATOM   1060  CG  LYS    44      -1.383  75.517  43.796  1.00 37.14           C  
ATOM   1061  CD  LYS    44      -0.199  75.250  42.854  1.00 40.63           C  
ATOM   1062  CE  LYS    44       0.270  76.569  42.238  1.00 46.64           C  
ATOM   1063  NZ  LYS    44       1.409  76.414  41.283  1.00 41.05           N  
ATOM   1064  N   LEU    45      -3.875  71.626  44.416  1.00 22.77           N  
ATOM   1065  CA  LEU    45      -4.158  70.192  44.683  1.00 22.94           C  
ATOM   1066  C   LEU    45      -4.528  69.448  43.403  1.00 20.00           C  
ATOM   1067  O   LEU    45      -4.064  68.333  43.149  1.00 21.82           O  
ATOM   1068  CB  LEU    45      -5.255  70.034  45.759  1.00 24.89           C  
ATOM   1069  CG  LEU    45      -4.872  70.484  47.179  1.00 24.96           C  
ATOM   1070  CD1 LEU    45      -6.093  70.532  48.099  1.00 25.24           C  
ATOM   1071  CD2 LEU    45      -3.795  69.570  47.786  1.00 26.64           C  
ATOM   1072  N   ILE    46      -5.331  70.092  42.557  1.00 20.74           N  
ATOM   1073  CA  ILE    46      -5.651  69.564  41.249  1.00 21.62           C  
ATOM   1074  C   ILE    46      -4.391  69.407  40.390  1.00 20.78           C  
ATOM   1075  O   ILE    46      -4.202  68.383  39.737  1.00 21.91           O  
ATOM   1076  CB  ILE    46      -6.704  70.453  40.547  1.00 22.08           C  
ATOM   1077  CG1 ILE    46      -8.055  70.378  41.275  1.00 24.84           C  
ATOM   1078  CG2 ILE    46      -6.892  70.056  39.052  1.00 22.38           C  
ATOM   1079  CD1 ILE    46      -9.010  71.552  40.931  1.00 22.86           C  
ATOM   1080  N   ALA    47      -3.523  70.426  40.416  1.00 21.87           N  
ATOM   1081  CA  ALA    47      -2.279  70.384  39.643  1.00 21.24           C  
ATOM   1082  C   ALA    47      -1.416  69.194  40.090  1.00 21.15           C  
ATOM   1083  O   ALA    47      -0.852  68.486  39.264  1.00 23.10           O  
ATOM   1084  CB  ALA    47      -1.507  71.727  39.768  1.00 21.67           C  
ATOM   1085  N   ILE    48      -1.326  68.971  41.401  1.00 23.22           N  
ATOM   1086  CA  ILE    48      -0.581  67.815  41.934  1.00 23.42           C  
ATOM   1087  C   ILE    48      -1.151  66.535  41.379  1.00 22.45           C  
ATOM   1088  O   ILE    48      -0.412  65.683  40.917  1.00 22.38           O  
ATOM   1089  CB  ILE    48      -0.565  67.783  43.480  1.00 22.22           C  
ATOM   1090  CG1 ILE    48       0.257  68.942  44.048  1.00 26.05           C  
ATOM   1091  CG2 ILE    48       0.049  66.452  44.023  1.00 25.18           C  
ATOM   1092  CD1 ILE    48      -0.059  69.242  45.504  1.00 25.14           C  
ATOM   1093  N   GLY    49      -2.485  66.395  41.436  1.00 23.64           N  
ATOM   1094  CA  GLY    49      -3.152  65.223  40.890  1.00 22.69           C  
ATOM   1095  C   GLY    49      -2.810  64.948  39.439  1.00 22.13           C  
ATOM   1096  O   GLY    49      -2.514  63.817  39.044  1.00 22.25           O  
ATOM   1097  N   ILE    50      -2.858  65.995  38.620  1.00 21.97           N  
ATOM   1098  CA  ILE    50      -2.611  65.842  37.209  1.00 23.22           C  
ATOM   1099  C   ILE    50      -1.179  65.410  36.958  1.00 20.30           C  
ATOM   1100  O   ILE    50      -0.936  64.483  36.198  1.00 22.58           O  
ATOM   1101  CB  ILE    50      -2.928  67.132  36.415  1.00 23.33           C  
ATOM   1102  CG1 ILE    50      -4.446  67.402  36.425  1.00 25.36           C  
ATOM   1103  CG2 ILE    50      -2.410  67.043  34.958  1.00 25.70           C  
ATOM   1104  CD1 ILE    50      -4.873  68.780  35.946  1.00 23.40           C  
ATOM   1105  N   VAL    51      -0.226  66.112  37.554  1.00 22.13           N  
ATOM   1106  CA  VAL    51       1.198  65.805  37.361  0.50 22.96           C  
ATOM   1108  C   VAL    51       1.534  64.410  37.901  1.00 22.59           C  
ATOM   1109  O   VAL    51       2.294  63.639  37.290  1.00 23.85           O  
ATOM   1110  CB  VAL    51       2.072  66.864  38.052  0.50 23.96           C  
ATOM   1112  CG1 VAL    51       3.558  66.521  37.912  0.50 22.52           C  
ATOM   1114  CG2 VAL    51       1.793  68.268  37.453  0.50 24.56           C  
ATOM   1116  N   ALA    52       0.940  64.069  39.051  1.00 21.97           N  
ATOM   1117  CA  ALA    52       1.198  62.761  39.646  1.00 22.83           C  
ATOM   1118  C   ALA    52       0.615  61.626  38.821  1.00 24.96           C  
ATOM   1119  O   ALA    52       1.057  60.489  38.972  1.00 27.05           O  
ATOM   1120  CB  ALA    52       0.708  62.681  41.110  1.00 22.19           C  
ATOM   1121  N   SER    53      -0.366  61.908  37.962  1.00 23.44           N  
ATOM   1122  CA  SER    53      -0.993  60.900  37.128  0.50 24.03           C  
ATOM   1124  C   SER    53      -0.070  60.482  35.984  1.00 28.22           C  
ATOM   1125  O   SER    53      -0.306  59.463  35.352  1.00 29.44           O  
ATOM   1126  CB  SER    53      -2.358  61.369  36.590  0.50 24.46           C  
ATOM   1128  OG  SER    53      -2.273  62.367  35.572  0.50 17.33           O  
ATOM   1130  N   ARG    54       0.967  61.288  35.750  1.00 27.88           N  
ATOM   1131  CA  ARG    54       1.961  61.079  34.686  1.00 36.49           C  
ATOM   1132  C   ARG    54       3.323  60.666  35.269  1.00 42.51           C  
ATOM   1133  O   ARG    54       3.434  60.416  36.472  1.00 42.98           O  
ATOM   1134  CB  ARG    54       2.061  62.360  33.864  1.00 36.62           C  
ATOM   1135  CG  ARG    54       0.682  62.788  33.371  1.00 36.07           C  
ATOM   1136  CD  ARG    54       0.720  63.747  32.220  1.00 46.03           C  
ATOM   1137  NE  ARG    54       1.186  65.048  32.671  1.00 47.58           N  
ATOM   1138  CZ  ARG    54       0.593  66.218  32.427  1.00 48.31           C  
ATOM   1139  NH1 ARG    54      -0.539  66.301  31.716  1.00 41.50           N  
ATOM   1140  NH2 ARG    54       1.152  67.314  32.919  1.00 45.55           N  
ATOM   1141  N   CYS    55       4.364  60.567  34.441  1.00 47.81           N  
ATOM   1142  CA  CYS    55       5.609  59.917  34.908  1.00 53.06           C  
ATOM   1143  C   CYS    55       6.714  60.870  35.342  1.00 53.53           C  
ATOM   1144  O   CYS    55       7.760  60.423  35.818  1.00 55.63           O  
ATOM   1145  CB  CYS    55       6.175  58.963  33.844  1.00 54.41           C  
ATOM   1146  SG  CYS    55       4.966  57.829  33.125  1.00 70.70           S  
ATOM   1147  N   ASP    56       6.510  62.170  35.183  1.00 51.11           N  
ATOM   1148  CA  ASP    56       7.593  63.097  35.442  1.00 50.75           C  
ATOM   1149  C   ASP    56       7.796  63.237  36.966  1.00 47.60           C  
ATOM   1150  O   ASP    56       7.187  64.093  37.608  1.00 47.73           O  
ATOM   1151  CB  ASP    56       7.335  64.451  34.744  1.00 51.45           C  
ATOM   1152  CG  ASP    56       8.549  65.360  34.751  1.00 55.00           C  
ATOM   1153  OD1 ASP    56       9.598  64.950  35.298  1.00 59.75           O  
ATOM   1154  OD2 ASP    56       8.445  66.490  34.211  1.00 56.95           O  
ATOM   1155  N   GLU    57       8.662  62.376  37.505  1.00 44.76           N  
ATOM   1156  CA  GLU    57       9.079  62.384  38.919  1.00 44.68           C  
ATOM   1157  C   GLU    57       9.555  63.747  39.434  1.00 43.54           C  
ATOM   1158  O   GLU    57       9.225  64.151  40.554  1.00 39.20           O  
ATOM   1159  CB  GLU    57      10.193  61.362  39.121  1.00 44.24           C  
ATOM   1160  CG  GLU    57      10.658  61.181  40.556  1.00 49.33           C  
ATOM   1161  N   VAL    58      10.342  64.453  38.623  1.00 44.25           N  
ATOM   1162  CA  VAL    58      10.846  65.761  39.019  1.00 41.66           C  
ATOM   1163  C   VAL    58       9.712  66.771  39.079  1.00 39.99           C  
ATOM   1164  O   VAL    58       9.637  67.563  40.023  1.00 40.88           O  
ATOM   1165  CB  VAL    58      12.003  66.255  38.076  1.00 44.98           C  
ATOM   1166  N   ALA    59       8.820  66.732  38.092  1.00 36.00           N  
ATOM   1167  CA  ALA    59       7.624  67.563  38.085  1.00 36.40           C  
ATOM   1168  C   ALA    59       6.746  67.291  39.314  1.00 34.21           C  
ATOM   1169  O   ALA    59       6.208  68.222  39.935  1.00 33.66           O  
ATOM   1170  CB  ALA    59       6.840  67.324  36.816  1.00 37.99           C  
ATOM   1171  N   ILE    60       6.614  66.013  39.667  1.00 31.22           N  
ATOM   1172  CA  ILE    60       5.812  65.647  40.839  1.00 28.82           C  
ATOM   1173  C   ILE    60       6.454  66.198  42.119  1.00 27.71           C  
ATOM   1174  O   ILE    60       5.781  66.867  42.913  1.00 27.90           O  
ATOM   1175  CB  ILE    60       5.613  64.129  40.959  1.00 27.95           C  
ATOM   1176  CG1 ILE    60       4.862  63.584  39.742  1.00 27.51           C  
ATOM   1177  CG2 ILE    60       4.812  63.808  42.224  1.00 26.18           C  
ATOM   1178  CD1 ILE    60       4.987  62.071  39.545  1.00 25.07           C  
ATOM   1179  N   GLU    61       7.741  65.915  42.319  1.00 30.04           N  
ATOM   1180  CA  GLU    61       8.460  66.430  43.501  1.00 32.80           C  
ATOM   1181  C   GLU    61       8.345  67.964  43.626  1.00 35.05           C  
ATOM   1182  O   GLU    61       8.090  68.492  44.715  1.00 33.59           O  
ATOM   1183  CB  GLU    61       9.925  65.988  43.468  1.00 33.45           C  
ATOM   1184  CG  GLU    61      10.720  66.333  44.743  1.00 36.55           C  
ATOM   1185  N   LYS    62       8.492  68.665  42.503  1.00 38.76           N  
ATOM   1186  CA  LYS    62       8.430  70.135  42.479  1.00 39.30           C  
ATOM   1187  C   LYS    62       7.040  70.681  42.772  1.00 38.68           C  
ATOM   1188  O   LYS    62       6.906  71.655  43.526  1.00 36.68           O  
ATOM   1189  CB  LYS    62       8.919  70.670  41.123  1.00 42.11           C  
ATOM   1190  N   GLN    63       5.995  70.076  42.198  1.00 35.90           N  
ATOM   1191  CA  GLN    63       4.635  70.517  42.512  1.00 36.26           C  
ATOM   1192  C   GLN    63       4.355  70.313  43.989  1.00 33.33           C  
ATOM   1193  O   GLN    63       3.755  71.165  44.626  1.00 33.91           O  
ATOM   1194  CB  GLN    63       3.548  69.798  41.676  1.00 39.20           C  
ATOM   1195  CG  GLN    63       3.160  70.466  40.335  1.00 44.45           C  
ATOM   1196  CD  GLN    63       2.333  71.749  40.478  1.00 44.95           C  
ATOM   1197  OE1 GLN    63       1.712  72.008  41.510  1.00 62.12           O  
ATOM   1198  NE2 GLN    63       2.315  72.547  39.425  1.00 63.66           N  
ATOM   1199  N   MET    64       4.752  69.161  44.531  1.00 30.47           N  
ATOM   1200  CA  MET    64       4.471  68.856  45.916  1.00 26.68           C  
ATOM   1201  C   MET    64       5.225  69.810  46.838  1.00 29.86           C  
ATOM   1202  O   MET    64       4.645  70.361  47.788  1.00 28.23           O  
ATOM   1203  CB  MET    64       4.864  67.412  46.233  1.00 23.18           C  
ATOM   1204  CG  MET    64       3.918  66.370  45.589  1.00 22.57           C  
ATOM   1205  SD  MET    64       4.418  64.644  46.195  0.75 22.23          SE  
ATOM   1206  CE  MET    64       3.056  63.632  45.253  1.00 22.00           C  
ATOM   1207  N   LYS    65       6.514  69.998  46.544  1.00 32.32           N  
ATOM   1208  CA  LYS    65       7.386  70.856  47.371  1.00 34.88           C  
ATOM   1209  C   LYS    65       6.857  72.284  47.412  1.00 34.19           C  
ATOM   1210  O   LYS    65       6.702  72.863  48.483  1.00 35.31           O  
ATOM   1211  CB  LYS    65       8.826  70.843  46.843  1.00 35.46           C  
ATOM   1212  CG  LYS    65       9.625  69.629  47.243  1.00 40.38           C  
ATOM   1213  N   SER    66       6.564  72.836  46.245  1.00 36.71           N  
ATOM   1214  CA  SER    66       6.041  74.200  46.142  0.50 37.97           C  
ATOM   1216  C   SER    66       4.709  74.361  46.864  1.00 39.15           C  
ATOM   1217  O   SER    66       4.486  75.342  47.552  1.00 40.37           O  
ATOM   1218  CB  SER    66       5.895  74.618  44.676  0.50 38.61           C  
ATOM   1220  OG  SER    66       5.090  73.703  43.950  0.50 37.08           O  
ATOM   1222  N   ALA    67       3.815  73.392  46.707  1.00 37.33           N  
ATOM   1223  CA  ALA    67       2.536  73.447  47.409  1.00 35.90           C  
ATOM   1224  C   ALA    67       2.708  73.505  48.921  1.00 33.63           C  
ATOM   1225  O   ALA    67       2.000  74.242  49.614  1.00 33.38           O  
ATOM   1226  CB  ALA    67       1.675  72.239  47.036  1.00 35.08           C  
ATOM   1227  N   MET    68       3.620  72.690  49.440  1.00 32.12           N  
ATOM   1228  CA  MET    68       3.809  72.592  50.861  1.00 32.59           C  
ATOM   1229  C   MET    68       4.455  73.891  51.335  1.00 33.83           C  
ATOM   1230  O   MET    68       4.036  74.457  52.332  1.00 35.23           O  
ATOM   1231  CB  MET    68       4.684  71.396  51.205  1.00 33.38           C  
ATOM   1232  CG  MET    68       4.027  70.041  50.923  1.00 33.32           C  
ATOM   1233  SD  MET    68       5.192  68.597  51.472  0.75 34.95          SE  
ATOM   1234  CE  MET    68       4.864  68.765  53.369  1.00 39.85           C  
ATOM   1235  N   LYS    69       5.428  74.370  50.567  1.00 35.03           N  
ATOM   1236  CA  LYS    69       6.210  75.565  50.936  1.00 37.33           C  
ATOM   1237  C   LYS    69       5.376  76.830  50.796  1.00 38.14           C  
ATOM   1238  O   LYS    69       5.218  77.585  51.764  1.00 42.29           O  
ATOM   1239  CB  LYS    69       7.470  75.676  50.075  1.00 36.02           C  
ATOM   1240  N   GLU    70       4.833  77.048  49.606  1.00 39.17           N  
ATOM   1241  CA  GLU    70       4.066  78.262  49.302  1.00 40.19           C  
ATOM   1242  C   GLU    70       2.697  78.317  49.975  1.00 40.34           C  
ATOM   1243  O   GLU    70       2.343  79.342  50.543  1.00 42.02           O  
ATOM   1244  CB  GLU    70       3.909  78.452  47.786  1.00 39.25           C  
ATOM   1245  N   LEU    71       1.936  77.226  49.937  1.00 39.71           N  
ATOM   1246  CA  LEU    71       0.552  77.239  50.424  1.00 38.07           C  
ATOM   1247  C   LEU    71       0.339  76.549  51.771  1.00 34.95           C  
ATOM   1248  O   LEU    71      -0.765  76.565  52.307  1.00 37.25           O  
ATOM   1249  CB  LEU    71      -0.380  76.601  49.371  1.00 39.04           C  
ATOM   1250  CG  LEU    71      -0.453  77.252  47.981  1.00 43.95           C  
ATOM   1251  CD1 LEU    71       0.756  76.880  47.115  1.00 50.69           C  
ATOM   1252  CD2 LEU    71      -1.736  76.876  47.251  1.00 39.57           C  
ATOM   1253  N   GLY    72       1.355  75.907  52.325  1.00 31.62           N  
ATOM   1254  CA  GLY    72       1.147  75.169  53.571  1.00 31.33           C  
ATOM   1255  C   GLY    72       0.288  73.914  53.427  1.00 30.39           C  
ATOM   1256  O   GLY    72      -0.302  73.424  54.405  1.00 31.58           O  
ATOM   1257  N   ILE    73       0.217  73.377  52.213  1.00 32.06           N  
ATOM   1258  CA  ILE    73      -0.496  72.104  51.983  1.00 28.57           C  
ATOM   1259  C   ILE    73       0.221  70.989  52.779  1.00 29.16           C  
ATOM   1260  O   ILE    73       1.450  70.986  52.850  1.00 29.32           O  
ATOM   1261  CB  ILE    73      -0.621  71.840  50.468  1.00 30.50           C  
ATOM   1262  CG1 ILE    73      -1.744  72.732  49.891  1.00 27.84           C  
ATOM   1263  CG2 ILE    73      -0.867  70.336  50.174  1.00 25.19           C  
ATOM   1264  CD1 ILE    73      -1.816  72.820  48.371  1.00 30.38           C  
ATOM   1265  N   THR    74      -0.530  70.088  53.420  1.00 27.36           N  
ATOM   1266  CA  THR    74       0.088  69.024  54.242  1.00 27.26           C  
ATOM   1267  C   THR    74       0.356  67.745  53.462  1.00 27.58           C  
ATOM   1268  O   THR    74      -0.238  67.522  52.416  1.00 24.17           O  
ATOM   1269  CB  THR    74      -0.757  68.627  55.460  1.00 29.19           C  
ATOM   1270  OG1 THR    74      -2.004  68.099  55.031  1.00 28.81           O  
ATOM   1271  CG2 THR    74      -0.971  69.880  56.480  1.00 28.98           C  
ATOM   1272  N   LYS    75       1.211  66.876  53.997  1.00 26.69           N  
ATOM   1273  CA  LYS    75       1.408  65.575  53.357  1.00 24.94           C  
ATOM   1274  C   LYS    75       0.105  64.766  53.394  1.00 24.97           C  
ATOM   1275  O   LYS    75      -0.183  64.049  52.430  1.00 24.26           O  
ATOM   1276  CB  LYS    75       2.547  64.787  54.001  1.00 25.92           C  
ATOM   1277  CG  LYS    75       3.941  65.377  53.781  1.00 25.04           C  
ATOM   1278  CD  LYS    75       5.016  64.369  54.207  1.00 27.40           C  
ATOM   1279  CE  LYS    75       6.395  64.744  53.675  1.00 30.74           C  
ATOM   1280  NZ  LYS    75       7.337  63.582  53.770  1.00 29.47           N  
ATOM   1281  N   GLU    76      -0.705  64.923  54.456  1.00 23.62           N  
ATOM   1282  CA  GLU    76      -2.006  64.250  54.537  1.00 27.19           C  
ATOM   1283  C   GLU    76      -2.963  64.703  53.418  1.00 22.94           C  
ATOM   1284  O   GLU    76      -3.670  63.897  52.828  1.00 25.59           O  
ATOM   1285  CB  GLU    76      -2.676  64.495  55.897  1.00 28.02           C  
ATOM   1286  CG  GLU    76      -3.944  63.646  56.101  1.00 35.01           C  
ATOM   1287  CD  GLU    76      -4.602  63.869  57.467  1.00 37.01           C  
ATOM   1288  OE1 GLU    76      -4.541  65.017  57.990  1.00 52.64           O  
ATOM   1289  OE2 GLU    76      -5.167  62.883  58.002  1.00 48.87           O  
ATOM   1290  N   GLU    77      -2.974  65.994  53.116  1.00 24.57           N  
ATOM   1291  CA  GLU    77      -3.774  66.494  52.000  1.00 24.63           C  
ATOM   1292  C   GLU    77      -3.272  65.945  50.656  1.00 24.30           C  
ATOM   1293  O   GLU    77      -4.068  65.546  49.803  1.00 23.45           O  
ATOM   1294  CB  GLU    77      -3.785  68.017  51.965  1.00 25.09           C  
ATOM   1295  CG  GLU    77      -4.555  68.632  53.117  1.00 28.85           C  
ATOM   1296  CD  GLU    77      -4.410  70.153  53.229  1.00 30.84           C  
ATOM   1297  OE1 GLU    77      -3.353  70.735  52.878  1.00 33.27           O  
ATOM   1298  OE2 GLU    77      -5.388  70.777  53.674  1.00 33.37           O  
ATOM   1299  N   ILE    78      -1.955  65.938  50.475  1.00 24.49           N  
ATOM   1300  CA  ILE    78      -1.378  65.340  49.262  1.00 23.04           C  
ATOM   1301  C   ILE    78      -1.725  63.851  49.134  1.00 21.63           C  
ATOM   1302  O   ILE    78      -2.100  63.380  48.059  1.00 21.32           O  
ATOM   1303  CB  ILE    78       0.162  65.600  49.123  1.00 22.33           C  
ATOM   1304  CG1 ILE    78       0.452  67.103  49.059  1.00 25.20           C  
ATOM   1305  CG2 ILE    78       0.697  64.957  47.836  1.00 21.31           C  
ATOM   1306  CD1 ILE    78       1.911  67.437  49.205  1.00 24.12           C  
ATOM   1307  N   ALA    79      -1.679  63.116  50.236  1.00 22.41           N  
ATOM   1308  CA  ALA    79      -2.026  61.718  50.200  1.00 20.30           C  
ATOM   1309  C   ALA    79      -3.467  61.520  49.727  1.00 21.42           C  
ATOM   1310  O   ALA    79      -3.749  60.611  48.966  1.00 20.43           O  
ATOM   1311  CB  ALA    79      -1.797  61.071  51.552  1.00 22.66           C  
ATOM   1312  N   ASP    80      -4.374  62.409  50.130  1.00 20.93           N  
ATOM   1313  CA  ASP    80      -5.762  62.331  49.652  1.00 20.26           C  
ATOM   1314  C   ASP    80      -5.885  62.593  48.155  1.00 22.81           C  
ATOM   1315  O   ASP    80      -6.734  62.009  47.494  1.00 22.27           O  
ATOM   1316  CB  ASP    80      -6.667  63.310  50.395  1.00 20.14           C  
ATOM   1317  CG  ASP    80      -7.045  62.853  51.807  1.00 23.19           C  
ATOM   1318  OD1 ASP    80      -6.928  61.652  52.156  1.00 25.42           O  
ATOM   1319  OD2 ASP    80      -7.525  63.728  52.549  1.00 28.27           O  
ATOM   1320  N   VAL    81      -5.043  63.483  47.619  1.00 21.25           N  
ATOM   1321  CA  VAL    81      -4.939  63.659  46.181  1.00 22.27           C  
ATOM   1322  C   VAL    81      -4.492  62.341  45.520  1.00 20.03           C  
ATOM   1323  O   VAL    81      -5.078  61.898  44.508  1.00 19.50           O  
ATOM   1324  CB  VAL    81      -3.963  64.805  45.817  1.00 20.90           C  
ATOM   1325  CG1 VAL    81      -3.757  64.895  44.302  1.00 22.88           C  
ATOM   1326  CG2 VAL    81      -4.425  66.168  46.443  1.00 20.83           C  
ATOM   1327  N   LEU    82      -3.519  61.673  46.131  1.00 20.16           N  
ATOM   1328  CA  LEU    82      -2.954  60.455  45.560  1.00 19.84           C  
ATOM   1329  C   LEU    82      -3.955  59.291  45.560  1.00 18.54           C  
ATOM   1330  O   LEU    82      -3.913  58.425  44.676  1.00 19.11           O  
ATOM   1331  CB  LEU    82      -1.666  60.090  46.263  1.00 20.98           C  
ATOM   1332  CG  LEU    82      -0.551  61.135  46.146  1.00 20.66           C  
ATOM   1333  CD1 LEU    82       0.766  60.558  46.671  1.00 21.28           C  
ATOM   1334  CD2 LEU    82      -0.392  61.639  44.674  1.00 22.33           C  
ATOM   1335  N   ARG    83      -4.911  59.309  46.495  1.00 20.31           N  
ATOM   1336  CA  ARG    83      -5.991  58.304  46.463  1.00 21.39           C  
ATOM   1337  C   ARG    83      -6.744  58.386  45.139  1.00 20.18           C  
ATOM   1338  O   ARG    83      -7.025  57.394  44.468  1.00 19.30           O  
ATOM   1339  CB  ARG    83      -6.940  58.521  47.643  1.00 22.29           C  
ATOM   1340  CG  ARG    83      -6.321  58.269  48.999  1.00 22.30           C  
ATOM   1341  CD  ARG    83      -7.215  58.747  50.124  1.00 28.97           C  
ATOM   1342  NE  ARG    83      -8.051  57.695  50.628  1.00 33.52           N  
ATOM   1343  CZ  ARG    83      -7.790  56.938  51.696  1.00 23.68           C  
ATOM   1344  NH1 ARG    83      -6.703  57.064  52.438  1.00 32.40           N  
ATOM   1345  NH2 ARG    83      -8.646  56.031  52.018  1.00 24.82           N  
ATOM   1346  N   VAL    84      -7.007  59.612  44.712  1.00 19.60           N  
ATOM   1347  CA  VAL    84      -7.659  59.856  43.423  1.00 20.32           C  
ATOM   1348  C   VAL    84      -6.772  59.472  42.241  1.00 20.03           C  
ATOM   1349  O   VAL    84      -7.255  58.901  41.275  1.00 20.48           O  
ATOM   1350  CB  VAL    84      -8.137  61.322  43.296  1.00 21.39           C  
ATOM   1351  CG1 VAL    84      -8.987  61.511  41.998  1.00 22.27           C  
ATOM   1352  CG2 VAL    84      -8.967  61.726  44.539  1.00 22.62           C  
ATOM   1353  N   VAL    85      -5.467  59.765  42.311  1.00 19.59           N  
ATOM   1354  CA  VAL    85      -4.526  59.262  41.308  1.00 19.33           C  
ATOM   1355  C   VAL    85      -4.607  57.748  41.150  1.00 19.40           C  
ATOM   1356  O   VAL    85      -4.616  57.261  40.035  1.00 20.61           O  
ATOM   1357  CB  VAL    85      -3.073  59.710  41.615  1.00 19.39           C  
ATOM   1358  CG1 VAL    85      -2.070  59.082  40.659  1.00 17.94           C  
ATOM   1359  CG2 VAL    85      -2.997  61.250  41.539  1.00 21.42           C  
ATOM   1360  N   LEU    86      -4.650  56.998  42.252  1.00 19.33           N  
ATOM   1361  CA  LEU    86      -4.777  55.548  42.161  1.00 19.79           C  
ATOM   1362  C   LEU    86      -6.014  55.159  41.363  1.00 18.98           C  
ATOM   1363  O   LEU    86      -5.940  54.357  40.454  1.00 20.03           O  
ATOM   1364  CB  LEU    86      -4.858  54.924  43.555  1.00 21.20           C  
ATOM   1365  CG  LEU    86      -5.184  53.439  43.651  1.00 21.99           C  
ATOM   1366  CD1 LEU    86      -4.133  52.600  42.959  1.00 24.06           C  
ATOM   1367  CD2 LEU    86      -5.310  53.065  45.156  1.00 20.62           C  
ATOM   1368  N   LEU    87      -7.154  55.734  41.711  1.00 20.94           N  
ATOM   1369  CA  LEU    87      -8.412  55.347  41.065  1.00 21.06           C  
ATOM   1370  C   LEU    87      -8.447  55.701  39.591  1.00 21.01           C  
ATOM   1371  O   LEU    87      -8.981  54.948  38.793  1.00 22.38           O  
ATOM   1372  CB  LEU    87      -9.577  56.046  41.769  1.00 23.55           C  
ATOM   1373  CG  LEU    87     -10.992  55.596  41.405  1.00 25.01           C  
ATOM   1374  CD1 LEU    87     -11.291  54.169  41.742  1.00 30.38           C  
ATOM   1375  CD2 LEU    87     -11.944  56.517  42.180  1.00 27.84           C  
ATOM   1376  N   THR    88      -7.906  56.874  39.258  1.00 21.25           N  
ATOM   1377  CA  THR    88      -7.927  57.375  37.879  1.00 21.88           C  
ATOM   1378  C   THR    88      -6.816  56.833  36.983  1.00 22.77           C  
ATOM   1379  O   THR    88      -6.931  56.837  35.762  1.00 23.28           O  
ATOM   1380  CB  THR    88      -7.874  58.903  37.853  1.00 21.84           C  
ATOM   1381  OG1 THR    88      -6.644  59.350  38.431  1.00 22.90           O  
ATOM   1382  CG2 THR    88      -9.066  59.477  38.541  1.00 25.52           C  
ATOM   1383  N   SER    89      -5.735  56.386  37.602  1.00 20.63           N  
ATOM   1384  CA  SER    89      -4.483  56.227  36.896  1.00 21.58           C  
ATOM   1385  C   SER    89      -3.720  54.942  37.169  1.00 21.03           C  
ATOM   1386  O   SER    89      -2.772  54.629  36.425  1.00 23.05           O  
ATOM   1387  CB  SER    89      -3.575  57.459  37.151  1.00 25.09           C  
ATOM   1388  OG  SER    89      -4.281  58.671  36.880  1.00 24.41           O  
ATOM   1389  N   GLY    90      -4.063  54.215  38.234  1.00 21.98           N  
ATOM   1390  CA  GLY    90      -3.467  52.905  38.482  1.00 20.22           C  
ATOM   1391  C   GLY    90      -2.363  52.897  39.536  1.00 20.13           C  
ATOM   1392  O   GLY    90      -1.942  53.955  40.033  1.00 19.52           O  
ATOM   1393  N   MET    91      -1.913  51.694  39.856  1.00 20.97           N  
ATOM   1394  CA  MET    91      -0.890  51.427  40.886  0.40 24.63           C  
ATOM   1396  C   MET    91       0.459  52.100  40.604  1.00 21.70           C  
ATOM   1397  O   MET    91       1.059  52.724  41.502  1.00 23.86           O  
ATOM   1398  CB  MET    91      -0.619  49.917  41.035  0.40 26.41           C  
ATOM   1400  CG  MET    91      -1.632  49.085  41.765  0.40 29.31           C  
ATOM   1402  SD  MET    91      -0.711  47.905  43.072  0.28 35.75          SE  
ATOM   1404  CE  MET    91      -0.457  49.469  44.218  0.40 21.93           C  
ATOM   1406  N   PRO    92       0.980  51.963  39.373  1.00 21.05           N  
ATOM   1407  CA  PRO    92       2.311  52.563  39.147  1.00 19.88           C  
ATOM   1408  C   PRO    92       2.408  54.050  39.498  1.00 21.02           C  
ATOM   1409  O   PRO    92       3.356  54.485  40.177  1.00 20.96           O  
ATOM   1410  CB  PRO    92       2.572  52.299  37.663  1.00 22.51           C  
ATOM   1411  CG  PRO    92       1.788  51.073  37.374  1.00 20.16           C  
ATOM   1412  CD  PRO    92       0.530  51.210  38.184  1.00 21.39           C  
ATOM   1413  N   ALA    93       1.434  54.836  39.065  1.00 19.14           N  
ATOM   1414  CA  ALA    93       1.460  56.257  39.340  1.00 19.96           C  
ATOM   1415  C   ALA    93       1.300  56.530  40.843  1.00 19.93           C  
ATOM   1416  O   ALA    93       1.977  57.400  41.418  1.00 20.12           O  
ATOM   1417  CB  ALA    93       0.324  56.953  38.551  1.00 22.71           C  
ATOM   1418  N   PHE    94       0.374  55.804  41.457  1.00 18.44           N  
ATOM   1419  CA  PHE    94       0.116  55.937  42.882  1.00 18.79           C  
ATOM   1420  C   PHE    94       1.380  55.638  43.705  1.00 20.05           C  
ATOM   1421  O   PHE    94       1.763  56.426  44.594  1.00 19.06           O  
ATOM   1422  CB  PHE    94      -0.966  54.949  43.301  1.00 20.10           C  
ATOM   1423  CG  PHE    94      -1.232  54.947  44.799  1.00 20.32           C  
ATOM   1424  CD1 PHE    94      -1.802  56.035  45.406  1.00 19.60           C  
ATOM   1425  CD2 PHE    94      -0.904  53.846  45.583  1.00 23.76           C  
ATOM   1426  CE1 PHE    94      -2.066  56.050  46.776  1.00 22.96           C  
ATOM   1427  CE2 PHE    94      -1.154  53.856  46.964  1.00 22.72           C  
ATOM   1428  CZ  PHE    94      -1.722  54.954  47.559  1.00 26.09           C  
ATOM   1429  N   THR    95       2.013  54.508  43.431  1.00 20.55           N  
ATOM   1430  CA  THR    95       3.135  54.077  44.284  1.00 20.94           C  
ATOM   1431  C   THR    95       4.339  55.000  44.073  1.00 20.73           C  
ATOM   1432  O   THR    95       5.018  55.353  45.038  1.00 20.28           O  
ATOM   1433  CB  THR    95       3.494  52.592  44.055  1.00 23.86           C  
ATOM   1434  OG1 THR    95       3.863  52.424  42.701  1.00 24.63           O  
ATOM   1435  CG2 THR    95       2.314  51.685  44.356  1.00 21.43           C  
ATOM   1436  N   LYS    96       4.586  55.442  42.833  1.00 20.08           N  
ATOM   1437  CA  LYS    96       5.679  56.370  42.546  0.50 21.50           C  
ATOM   1439  C   LYS    96       5.460  57.655  43.335  1.00 20.81           C  
ATOM   1440  O   LYS    96       6.378  58.161  43.984  1.00 23.01           O  
ATOM   1441  CB  LYS    96       5.748  56.674  41.040  0.50 23.02           C  
ATOM   1443  CG  LYS    96       6.843  57.658  40.621  0.50 23.87           C  
ATOM   1445  CD  LYS    96       7.014  57.722  39.092  0.50 25.49           C  
ATOM   1447  CE  LYS    96       8.452  58.030  38.704  0.50 32.66           C  
ATOM   1449  NZ  LYS    96       9.333  56.844  38.868  0.50 30.31           N  
ATOM   1451  N   ALA    97       4.244  58.190  43.262  1.00 19.16           N  
ATOM   1452  CA  ALA    97       3.898  59.469  43.921  1.00 19.50           C  
ATOM   1453  C   ALA    97       3.968  59.374  45.441  1.00 20.63           C  
ATOM   1454  O   ALA    97       4.463  60.306  46.135  1.00 20.71           O  
ATOM   1455  CB  ALA    97       2.498  59.945  43.472  1.00 19.41           C  
ATOM   1456  N   MET    98       3.499  58.244  45.974  1.00 19.58           N  
ATOM   1457  CA  MET    98       3.518  58.034  47.406  1.00 20.80           C  
ATOM   1458  C   MET    98       4.949  58.016  47.898  1.00 21.43           C  
ATOM   1459  O   MET    98       5.235  58.574  48.952  1.00 21.18           O  
ATOM   1460  CB  MET    98       2.812  56.740  47.834  1.00 22.05           C  
ATOM   1461  CG  MET    98       1.348  56.831  48.010  1.00 30.57           C  
ATOM   1462  SD  MET    98       0.764  58.016  49.491  0.75 32.27          SE  
ATOM   1463  CE  MET    98       1.937  58.044  50.314  1.00  8.65           C  
ATOM   1464  N   LYS    99       5.840  57.362  47.159  1.00 20.17           N  
ATOM   1465  CA  LYS    99       7.263  57.318  47.526  1.00 20.82           C  
ATOM   1466  C   LYS    99       7.928  58.695  47.534  1.00 21.61           C  
ATOM   1467  O   LYS    99       8.729  59.015  48.429  1.00 22.41           O  
ATOM   1468  CB  LYS    99       8.015  56.361  46.599  1.00 19.98           C  
ATOM   1469  CG  LYS    99       9.522  56.268  46.893  1.00 23.11           C  
ATOM   1470  N   ILE   100       7.602  59.501  46.536  1.00 22.47           N  
ATOM   1471  CA  ILE   100       8.072  60.874  46.456  1.00 23.27           C  
ATOM   1472  C   ILE   100       7.553  61.687  47.656  1.00 24.13           C  
ATOM   1473  O   ILE   100       8.325  62.413  48.299  1.00 23.84           O  
ATOM   1474  CB  ILE   100       7.652  61.544  45.136  1.00 22.91           C  
ATOM   1475  CG1 ILE   100       8.324  60.868  43.926  1.00 22.73           C  
ATOM   1476  CG2 ILE   100       7.973  63.043  45.152  1.00 21.99           C  
ATOM   1477  CD1 ILE   100       7.717  61.279  42.573  1.00 25.00           C  
ATOM   1478  N   LEU   101       6.269  61.540  47.970  1.00 21.64           N  
ATOM   1479  CA  LEU   101       5.660  62.247  49.106  1.00 23.29           C  
ATOM   1480  C   LEU   101       6.347  61.878  50.406  1.00 23.75           C  
ATOM   1481  O   LEU   101       6.624  62.756  51.240  1.00 22.26           O  
ATOM   1482  CB  LEU   101       4.155  61.935  49.207  1.00 22.94           C  
ATOM   1483  CG  LEU   101       3.386  62.589  50.364  1.00 23.09           C  
ATOM   1484  CD1 LEU   101       3.489  64.134  50.332  1.00 23.78           C  
ATOM   1485  CD2 LEU   101       1.946  62.145  50.275  1.00 22.66           C  
ATOM   1486  N   GLU   102       6.611  60.583  50.578  1.00 22.09           N  
ATOM   1487  CA  GLU   102       7.262  60.059  51.770  1.00 27.09           C  
ATOM   1488  C   GLU   102       8.642  60.680  51.965  1.00 25.97           C  
ATOM   1489  O   GLU   102       9.018  61.019  53.083  1.00 27.53           O  
ATOM   1490  CB  GLU   102       7.399  58.543  51.675  1.00 27.36           C  
ATOM   1491  CG  GLU   102       6.073  57.805  51.782  1.00 34.71           C  
ATOM   1492  CD  GLU   102       6.120  56.363  51.242  1.00 36.54           C  
ATOM   1493  OE1 GLU   102       7.234  55.820  51.027  1.00 45.78           O  
ATOM   1494  OE2 GLU   102       5.022  55.775  51.058  1.00 44.93           O  
ATOM   1495  N   LYS   103       9.388  60.834  50.880  1.00 25.11           N  
ATOM   1496  CA  LYS   103      10.773  61.333  50.951  1.00 28.56           C  
ATOM   1497  C   LYS   103      10.847  62.862  51.111  1.00 31.51           C  
ATOM   1498  O   LYS   103      11.911  63.419  51.414  1.00 33.51           O  
ATOM   1499  CB  LYS   103      11.571  60.887  49.714  1.00 29.59           C  
ATOM   1500  CG  LYS   103      11.820  59.386  49.621  1.00 32.01           C  
ATOM   1501  N   LEU   104       9.727  63.543  50.933  1.00 31.51           N  
ATOM   1502  CA  LEU   104       9.711  64.997  51.021  1.00 35.23           C  
ATOM   1503  C   LEU   104       9.855  65.493  52.451  1.00 36.78           C  
ATOM   1504  O   LEU   104       9.406  64.849  53.400  1.00 36.92           O  
ATOM   1505  CB  LEU   104       8.441  65.570  50.389  1.00 34.06           C  
ATOM   1506  CG  LEU   104       8.572  65.835  48.898  1.00 34.04           C  
ATOM   1507  CD1 LEU   104       7.311  66.503  48.411  1.00 34.11           C  
ATOM   1508  CD2 LEU   104       9.796  66.702  48.620  1.00 38.61           C  
ATOM   1509  OXT LEU   104      10.441  66.563  52.661  1.00 40.57           O  
END
