
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  136 ( 1005),  selected  136 , name 2ouw_B
# Molecule2: number of CA atoms   98 (  717),  selected   98 , name T0408.pdb
# PARAMETERS: 2ouw_B.T0408.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     0_B      F       7           -
LGA    X     1_B      -       -           -
LGA    A     2_B      -       -           -
LGA    T     3_B      -       -           -
LGA    V     4_B      -       -           -
LGA    R     5_B      -       -           -
LGA    L     6_B      -       -           -
LGA    L     7_B      -       -           -
LGA    D     8_B      -       -           -
LGA    D     9_B      -       -           -
LGA    A    10_B      -       -           -
LGA    E    11_B      -       -           -
LGA    I    12_B      -       -           -
LGA    S    13_B      -       -           -
LGA    T    14_B      -       -           -
LGA    L    15_B      -       -           -
LGA    P    16_B      -       -           -
LGA    E    17_B      -       -           -
LGA    V    18_B      -       -           -
LGA    K    19_B      -       -           -
LGA    A    20_B      -       -           -
LGA    V    21_B      -       -           -
LGA    F    22_B      -       -           -
LGA    D    23_B      -       -           -
LGA    D    24_B      -       -           -
LGA    I    25_B      -       -           -
LGA    R    26_B      -       -           -
LGA    A    27_B      -       -           -
LGA    T    28_B      -       -           -
LGA    R    29_B      -       -           -
LGA    G    30_B      -       -           -
LGA    S    31_B      -       -           -
LGA    D    32_B      -       -           -
LGA    F    33_B      -       -           -
LGA    V    34_B      -       -           -
LGA    N    35_B      G       8          2.581
LGA    N    36_B      E       9          1.261
LGA    I    37_B      G      10          2.511
LGA    W    38_B      M      11          1.706
LGA    R    39_B      K      12          0.803
LGA    G    40_B      V      13          1.660
LGA    L    41_B      V      14          1.330
LGA    A    42_B      K      15          1.691
LGA    -       -      E      16           -
LGA    N    43_B      K      17          1.047
LGA    D    44_B      Y      18          1.265
LGA    P    45_B      P      19          1.576
LGA    A    46_B      D      20          2.450
LGA    L    47_B      L      21          1.867
LGA    L    48_B      Y      22          0.894
LGA    K    49_B      D      23          1.438
LGA    R    50_B      I      24          1.772
LGA    T    51_B      I      25          1.099
LGA    W    52_B      V      26          0.910
LGA    E    53_B      K      27          0.905
LGA    Q    54_B      L      28          0.518
LGA    V    55_B      N      29          0.346
LGA    K    56_B      D      30          0.814
LGA    T    57_B      T      31          0.752
LGA    V    58_B      V      32          1.066
LGA    X    59_B      F      33          1.339
LGA    V    60_B      T      34          4.075
LGA    G    61_B      G      35          6.671
LGA    E    62_B      -       -           -
LGA    G    63_B      K      36          2.678
LGA    A    64_B      T      37          1.500
LGA    L    65_B      L      38          0.814
LGA    D    66_B      D      39          1.246
LGA    P    67_B      Y      40          1.036
LGA    L    68_B      K      41          1.077
LGA    T    69_B      T      42          0.889
LGA    R    70_B      Q      43          0.621
LGA    E    71_B      K      44          0.636
LGA    X    72_B      L      45          1.036
LGA    I    73_B      I      46          0.826
LGA    Y    74_B      A      47          0.792
LGA    L    75_B      I      48          1.152
LGA    A    76_B      G      49          1.347
LGA    V    77_B      I      50          1.282
LGA    S    78_B      V      51          1.342
LGA    T    79_B      A      52          1.989
LGA    A    80_B      S      53          2.249
LGA    N    81_B      R      54          3.165
LGA    S    82_B      C      55          2.052
LGA    C    83_B      D      56          2.236
LGA    S    84_B      E      57          2.523
LGA    Y    85_B      V      58          2.581
LGA    C    86_B      A      59          1.779
LGA    A    87_B      I      60          0.815
LGA    H    88_B      E      61          1.766
LGA    S    89_B      K      62          1.812
LGA    H    90_B      Q      63          1.112
LGA    T    91_B      M      64          0.438
LGA    A    92_B      K      65          1.578
LGA    A    93_B      S      66          2.348
LGA    A    94_B      A      67          1.967
LGA    R    95_B      M      68          1.194
LGA    A    96_B      K      69          2.989
LGA    -       -      E      70           -
LGA    K    97_B      L      71          1.254
LGA    G    98_B      G      72          2.557
LGA    X    99_B      I      73          1.607
LGA    T   100_B      T      74          1.899
LGA    P   101_B      K      75          2.537
LGA    A   102_B      E      76          1.924
LGA    Q   103_B      E      77          1.125
LGA    H   104_B      I      78          1.443
LGA    A   105_B      A      79          1.276
LGA    E   106_B      D      80          0.968
LGA    V   107_B      V      81          0.928
LGA    L   108_B      L      82          1.177
LGA    A   109_B      R      83          1.443
LGA    I   110_B      V      84          1.158
LGA    I   111_B      V      85          0.680
LGA    G   112_B      L      86          1.484
LGA    L   113_B      L      87          1.759
LGA    A   114_B      T      88          1.153
LGA    A   115_B      S      89          0.678
LGA    Q   116_B      G      90          2.750
LGA    T   117_B      M      91           -
LGA    N   118_B      P      92           -
LGA    A   119_B      A      93           -
LGA    L   120_B      F      94           -
LGA    V   121_B      T      95           -
LGA    T   122_B      K      96           -
LGA    A   123_B      A      97           -
LGA    X   124_B      M      98           -
LGA    Q   125_B      K      99           -
LGA    I   126_B      I     100           -
LGA    P   127_B      L     101           -
LGA    V   128_B      E     102           -
LGA    D   129_B      K     103           -
LGA    E   130_B      L     104           -
LGA    A   131_B      -       -           -
LGA    F   132_B      -       -           -
LGA    L   133_B      -       -           -
LGA    V   134_B      -       -           -
LGA    D   135_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  136   98    5.0     81    1.81    19.75     74.687     4.241

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.422682 * X  +  -0.262202 * Y  +  -0.867519 * Z  +  24.707962
  Y_new =  -0.691016 * X  +  -0.712588 * Y  +  -0.121309 * Z  +  62.388031
  Z_new =  -0.586377 * X  +   0.650744 * Y  +  -0.482384 * Z  +  41.259899 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.208693   -0.932899  [ DEG:   126.5488    -53.4512 ]
  Theta =   0.626578    2.515014  [ DEG:    35.9003    144.0997 ]
  Phi   =  -1.021831    2.119761  [ DEG:   -58.5466    121.4534 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ouw_B                                        
REMARK     2: T0408.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ouw_B.T0408.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  136   98   5.0   81   1.81   19.75  74.687
REMARK  ---------------------------------------------------------- 
MOLECULE 2ouw_B
HEADER    OXIDOREDUCTASE                          12-FEB-07   2OUW              
TITLE     CRYSTAL STRUCTURE OF ALKYLHYDROPEROXIDASE AHPD CORE                   
TITLE    2 (YP_425393.1) FROM RHODOSPIRILLUM RUBRUM ATCC 11170 AT               
TITLE    3 1.95 A RESOLUTION                                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ALKYLHYDROPEROXIDASE AHPD CORE;                            
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 EC: 1.-.-.-;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RHODOSPIRILLUM RUBRUM;                          
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: NCIB 8255;                                                   
SOURCE   5 ATCC: 11170;                                                         
SOURCE   6 GENE: YP_425393.1, RRU_A0301;                                        
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    YP_425393.1, CARBOXYMUCONOLACTONE DECARBOXYLASE FAMILY,               
KEYWDS   2 ALKYLHYDROPEROXIDASE AHPD CORE, STRUCTURAL GENOMICS, JOINT           
KEYWDS   3 CENTER FOR STRUCTURAL GENOMICS, JCSG, PROTEIN STRUCTURE              
KEYWDS   4 INITIATIVE, PSI-2                                                    
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   06-MAR-07 2OUW    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF ALKYLHYDROPEROXIDASE AHPD               
JRNL        TITL 2 CORE (YP_425393.1) FROM RHODOSPIRILLUM RUBRUM ATCC           
JRNL        TITL 3 11170 AT 1.95 A RESOLUTION                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.95 ANGSTROMS.                                          
DBREF  2OUW A    1   137  UNP    Q2RXN9   Q2RXN9_RHORT     1    137             
DBREF  2OUW B    1   137  UNP    Q2RXN9   Q2RXN9_RHORT     1    137             
SEQRES   1 A  138  GLY MSE ALA THR VAL ARG LEU LEU ASP ASP ALA GLU ILE          
SEQRES   2 A  138  SER THR LEU PRO GLU VAL LYS ALA VAL PHE ASP ASP ILE          
SEQRES   3 A  138  ARG ALA THR ARG GLY SER ASP PHE VAL ASN ASN ILE TRP          
SEQRES   4 A  138  ARG GLY LEU ALA ASN ASP PRO ALA LEU LEU LYS ARG THR          
SEQRES   5 A  138  TRP GLU GLN VAL LYS THR VAL MSE VAL GLY GLU GLY ALA          
SEQRES   6 A  138  LEU ASP PRO LEU THR ARG GLU MSE ILE TYR LEU ALA VAL          
SEQRES   7 A  138  SER THR ALA ASN SER CYS SER TYR CYS ALA HIS SER HIS          
SEQRES   8 A  138  THR ALA ALA ALA ARG ALA LYS GLY MSE THR PRO ALA GLN          
SEQRES   9 A  138  HIS ALA GLU VAL LEU ALA ILE ILE GLY LEU ALA ALA GLN          
SEQRES  10 A  138  THR ASN ALA LEU VAL THR ALA MSE GLN ILE PRO VAL ASP          
SEQRES  11 A  138  GLU ALA PHE LEU VAL ASP GLY LYS                              
SEQRES   1 B  138  GLY MSE ALA THR VAL ARG LEU LEU ASP ASP ALA GLU ILE          
SEQRES   2 B  138  SER THR LEU PRO GLU VAL LYS ALA VAL PHE ASP ASP ILE          
SEQRES   3 B  138  ARG ALA THR ARG GLY SER ASP PHE VAL ASN ASN ILE TRP          
SEQRES   4 B  138  ARG GLY LEU ALA ASN ASP PRO ALA LEU LEU LYS ARG THR          
SEQRES   5 B  138  TRP GLU GLN VAL LYS THR VAL MSE VAL GLY GLU GLY ALA          
SEQRES   6 B  138  LEU ASP PRO LEU THR ARG GLU MSE ILE TYR LEU ALA VAL          
SEQRES   7 B  138  SER THR ALA ASN SER CYS SER TYR CYS ALA HIS SER HIS          
SEQRES   8 B  138  THR ALA ALA ALA ARG ALA LYS GLY MSE THR PRO ALA GLN          
SEQRES   9 B  138  HIS ALA GLU VAL LEU ALA ILE ILE GLY LEU ALA ALA GLN          
SEQRES  10 B  138  THR ASN ALA LEU VAL THR ALA MSE GLN ILE PRO VAL ASP          
SEQRES  11 B  138  GLU ALA PHE LEU VAL ASP GLY LYS                              
HET    MSE  A   1       8                                                       
HET    MSE  A  59       8                                                       
HET    MSE  A  72       8                                                       
HET    MSE  A  99       8                                                       
HET    MSE  A 124       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  59       8                                                       
HET    MSE  B  72       8                                                       
HET    MSE  B  99       8                                                       
HET    MSE  B 124       8                                                       
HET     NA      7       1                                                       
HET    UNL      1       5                                                       
HET    UNL      2       8                                                       
HET    ACY      3       4                                                       
HET    ACY      4       4                                                       
HET    ACY      5       4                                                       
HET    ACY      6       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      NA SODIUM ION                                                       
HETNAM     UNL UNKNOWN LIGAND                                                   
HETNAM     ACY ACETIC ACID                                                      
FORMUL   1  MSE    10(C5 H11 N O2 SE)                                           
FORMUL   3   NA    NA 1+                                                        
FORMUL   6  ACY    4(C2 H4 O2)                                                  
FORMUL  10  HOH   *141(H2 O)                                                    
CRYST1   62.683   62.683  216.707  90.00  90.00 120.00 P 63 2 2     24          
ATOM   1012  N   GLY B   0      25.142  71.704  31.436  1.00 53.90           N  
ATOM   1013  CA  GLY B   0      24.453  71.353  32.713  1.00 53.15           C  
ATOM   1014  C   GLY B   0      23.557  70.183  32.428  1.00 52.48           C  
ATOM   1015  O   GLY B   0      23.824  69.430  31.493  1.00 53.78           O  
HETATM 1016  N   MSE B   1      22.477  70.045  33.194  1.00 50.41           N  
HETATM 1017  CA  MSE B   1      21.554  68.919  33.003  1.00 48.92           C  
HETATM 1018  C   MSE B   1      20.307  69.229  32.217  1.00 44.53           C  
HETATM 1019  O   MSE B   1      19.624  68.315  31.770  1.00 42.61           O  
HETATM 1020  CB  MSE B   1      21.110  68.383  34.339  1.00 51.05           C  
HETATM 1021  CG  MSE B   1      22.232  67.811  35.158  1.00 62.27           C  
HETATM 1022 SE   MSE B   1      21.640  67.881  36.996  0.75 84.21          SE  
HETATM 1023  CE  MSE B   1      21.997  69.901  37.358  1.00 65.36           C  
ATOM   1024  N   ALA B   2      19.960  70.506  32.106  1.00 41.09           N  
ATOM   1025  CA  ALA B   2      18.871  70.893  31.228  1.00 37.61           C  
ATOM   1026  C   ALA B   2      19.424  70.966  29.801  1.00 37.00           C  
ATOM   1027  O   ALA B   2      20.643  71.079  29.592  1.00 32.54           O  
ATOM   1028  CB  ALA B   2      18.288  72.204  31.653  1.00 38.02           C  
ATOM   1029  N   THR B   3      18.528  70.911  28.820  1.00 34.92           N  
ATOM   1030  CA  THR B   3      18.910  70.979  27.412  1.00 35.36           C  
ATOM   1031  C   THR B   3      19.020  72.423  27.016  1.00 37.91           C  
ATOM   1032  O   THR B   3      19.322  72.723  25.872  1.00 39.23           O  
ATOM   1033  CB  THR B   3      17.854  70.354  26.495  1.00 36.44           C  
ATOM   1034  OG1 THR B   3      16.610  71.010  26.719  1.00 36.02           O  
ATOM   1035  CG2 THR B   3      17.675  68.903  26.786  1.00 34.95           C  
ATOM   1036  N   VAL B   4      18.770  73.320  27.968  1.00 39.31           N  
ATOM   1037  CA  VAL B   4      18.907  74.742  27.754  1.00 39.48           C  
ATOM   1038  C   VAL B   4      19.666  75.285  28.938  1.00 40.98           C  
ATOM   1039  O   VAL B   4      19.733  74.657  29.998  1.00 41.84           O  
ATOM   1040  CB  VAL B   4      17.516  75.468  27.650  1.00 40.99           C  
ATOM   1041  CG1 VAL B   4      16.695  74.910  26.505  1.00 40.68           C  
ATOM   1042  CG2 VAL B   4      16.725  75.376  28.965  1.00 39.68           C  
ATOM   1043  N   ARG B   5      20.208  76.474  28.753  1.00 39.63           N  
ATOM   1044  CA  ARG B   5      20.906  77.166  29.811  1.00 42.30           C  
ATOM   1045  C   ARG B   5      19.904  77.630  30.867  1.00 41.99           C  
ATOM   1046  O   ARG B   5      18.779  78.004  30.523  1.00 40.98           O  
ATOM   1047  CB  ARG B   5      21.639  78.364  29.218  1.00 45.13           C  
ATOM   1048  CG  ARG B   5      23.113  78.408  29.509  1.00 52.55           C  
ATOM   1049  CD  ARG B   5      23.869  79.149  28.407  1.00 52.90           C  
ATOM   1050  NE  ARG B   5      23.181  80.374  28.003  1.00 52.46           N  
ATOM   1051  CZ  ARG B   5      23.090  81.472  28.742  1.00 50.72           C  
ATOM   1052  NH1 ARG B   5      23.651  81.538  29.950  1.00 52.41           N  
ATOM   1053  NH2 ARG B   5      22.434  82.518  28.264  1.00 54.25           N  
ATOM   1054  N   LEU B   6      20.309  77.602  32.140  1.00 39.50           N  
ATOM   1055  CA  LEU B   6      19.505  78.175  33.220  1.00 38.96           C  
ATOM   1056  C   LEU B   6      20.070  79.529  33.625  1.00 38.62           C  
ATOM   1057  O   LEU B   6      21.176  79.603  34.163  1.00 38.71           O  
ATOM   1058  CB  LEU B   6      19.471  77.249  34.427  1.00 38.54           C  
ATOM   1059  CG  LEU B   6      18.913  75.847  34.211  1.00 39.81           C  
ATOM   1060  CD1 LEU B   6      18.786  75.180  35.573  1.00 42.03           C  
ATOM   1061  CD2 LEU B   6      17.588  75.835  33.489  1.00 36.56           C  
ATOM   1062  N   LEU B   7      19.325  80.592  33.356  1.00 36.95           N  
ATOM   1063  CA  LEU B   7      19.832  81.952  33.529  1.00 38.52           C  
ATOM   1064  C   LEU B   7      19.882  82.329  35.006  1.00 39.36           C  
ATOM   1065  O   LEU B   7      18.934  82.060  35.734  1.00 38.03           O  
ATOM   1066  CB  LEU B   7      18.965  82.950  32.756  1.00 39.74           C  
ATOM   1067  CG  LEU B   7      19.345  83.167  31.282  1.00 43.11           C  
ATOM   1068  CD1 LEU B   7      19.124  81.946  30.439  1.00 44.35           C  
ATOM   1069  CD2 LEU B   7      18.607  84.374  30.684  1.00 45.12           C  
ATOM   1070  N   ASP B   8      20.993  82.932  35.440  1.00 39.09           N  
ATOM   1071  CA  ASP B   8      21.167  83.365  36.826  0.50 39.37           C  
ATOM   1073  C   ASP B   8      20.709  84.800  36.970  1.00 38.70           C  
ATOM   1074  O   ASP B   8      20.491  85.491  35.973  1.00 38.35           O  
ATOM   1075  CB  ASP B   8      22.627  83.212  37.317  0.50 39.23           C  
ATOM   1077  CG  ASP B   8      23.625  84.123  36.592  0.50 41.92           C  
ATOM   1079  OD1 ASP B   8      23.260  85.194  36.051  0.50 39.84           O  
ATOM   1081  OD2 ASP B   8      24.817  83.749  36.567  0.50 47.39           O  
ATOM   1083  N   ASP B   9      20.570  85.241  38.213  1.00 40.70           N  
ATOM   1084  CA  ASP B   9      20.096  86.603  38.497  1.00 41.39           C  
ATOM   1085  C   ASP B   9      20.980  87.686  37.906  1.00 41.64           C  
ATOM   1086  O   ASP B   9      20.484  88.713  37.409  1.00 42.55           O  
ATOM   1087  CB  ASP B   9      19.925  86.796  40.004  1.00 40.28           C  
ATOM   1088  CG  ASP B   9      18.778  85.966  40.568  1.00 42.49           C  
ATOM   1089  OD1 ASP B   9      17.885  85.557  39.792  1.00 41.11           O  
ATOM   1090  OD2 ASP B   9      18.743  85.740  41.795  1.00 38.38           O  
ATOM   1091  N   ALA B  10      22.291  87.456  37.918  1.00 43.15           N  
ATOM   1092  CA  ALA B  10      23.221  88.462  37.408  1.00 42.87           C  
ATOM   1093  C   ALA B  10      22.976  88.757  35.938  1.00 42.32           C  
ATOM   1094  O   ALA B  10      22.919  89.914  35.545  1.00 44.46           O  
ATOM   1095  CB  ALA B  10      24.626  88.039  37.630  1.00 43.22           C  
ATOM   1096  N   GLU B  11      22.816  87.711  35.145  1.00 43.54           N  
ATOM   1097  CA  GLU B  11      22.531  87.847  33.718  1.00 44.72           C  
ATOM   1098  C   GLU B  11      21.163  88.432  33.476  1.00 45.19           C  
ATOM   1099  O   GLU B  11      20.996  89.294  32.598  1.00 47.10           O  
ATOM   1100  CB  GLU B  11      22.608  86.488  33.009  1.00 45.44           C  
ATOM   1101  CG  GLU B  11      22.239  86.562  31.509  1.00 45.96           C  
ATOM   1102  CD  GLU B  11      22.497  85.278  30.738  1.00 49.27           C  
ATOM   1103  OE1 GLU B  11      22.937  84.274  31.353  1.00 45.54           O  
ATOM   1104  OE2 GLU B  11      22.253  85.290  29.501  1.00 48.85           O  
ATOM   1105  N   ILE B  12      20.179  87.953  34.237  1.00 44.86           N  
ATOM   1106  CA  ILE B  12      18.801  88.433  34.100  1.00 43.15           C  
ATOM   1107  C   ILE B  12      18.689  89.945  34.353  1.00 41.24           C  
ATOM   1108  O   ILE B  12      17.931  90.618  33.665  1.00 39.30           O  
ATOM   1109  CB  ILE B  12      17.834  87.637  35.019  1.00 42.32           C  
ATOM   1110  CG1 ILE B  12      17.648  86.216  34.470  1.00 41.76           C  
ATOM   1111  CG2 ILE B  12      16.481  88.372  35.203  1.00 40.48           C  
ATOM   1112  CD1 ILE B  12      17.039  85.273  35.449  1.00 41.18           C  
ATOM   1113  N   SER B  13      19.432  90.488  35.305  1.00 41.85           N  
ATOM   1114  CA  SER B  13      19.371  91.932  35.524  1.00 46.52           C  
ATOM   1115  C   SER B  13      19.835  92.761  34.305  1.00 47.13           C  
ATOM   1116  O   SER B  13      19.462  93.925  34.167  1.00 48.85           O  
ATOM   1117  CB  SER B  13      20.129  92.357  36.788  1.00 47.47           C  
ATOM   1118  OG  SER B  13      21.457  91.881  36.778  1.00 54.18           O  
ATOM   1119  N   THR B  14      20.602  92.154  33.414  1.00 48.08           N  
ATOM   1120  CA  THR B  14      20.985  92.815  32.163  1.00 49.56           C  
ATOM   1121  C   THR B  14      19.921  92.667  31.076  1.00 48.70           C  
ATOM   1122  O   THR B  14      20.070  93.230  29.993  1.00 47.40           O  
ATOM   1123  CB  THR B  14      22.319  92.246  31.595  1.00 48.89           C  
ATOM   1124  OG1 THR B  14      22.102  90.974  30.962  1.00 51.71           O  
ATOM   1125  CG2 THR B  14      23.354  92.085  32.712  1.00 52.95           C  
ATOM   1126  N   LEU B  15      18.871  91.896  31.345  1.00 46.94           N  
ATOM   1127  CA  LEU B  15      17.867  91.565  30.340  1.00 44.94           C  
ATOM   1128  C   LEU B  15      16.514  92.073  30.814  1.00 45.45           C  
ATOM   1129  O   LEU B  15      15.742  91.325  31.386  1.00 42.65           O  
ATOM   1130  CB  LEU B  15      17.811  90.046  30.136  1.00 44.74           C  
ATOM   1131  CG  LEU B  15      19.070  89.372  29.607  1.00 45.13           C  
ATOM   1132  CD1 LEU B  15      18.865  87.879  29.576  1.00 41.34           C  
ATOM   1133  CD2 LEU B  15      19.442  89.915  28.203  1.00 43.74           C  
ATOM   1134  N   PRO B  16      16.244  93.364  30.613  1.00 46.58           N  
ATOM   1135  CA  PRO B  16      15.009  94.001  31.053  1.00 45.85           C  
ATOM   1136  C   PRO B  16      13.715  93.219  30.871  1.00 43.23           C  
ATOM   1137  O   PRO B  16      12.924  93.163  31.807  1.00 40.60           O  
ATOM   1138  CB  PRO B  16      14.977  95.279  30.212  1.00 47.87           C  
ATOM   1139  CG  PRO B  16      16.388  95.627  30.074  1.00 46.40           C  
ATOM   1140  CD  PRO B  16      17.155  94.345  29.999  1.00 44.87           C  
ATOM   1141  N   GLU B  17      13.492  92.620  29.706  1.00 41.55           N  
ATOM   1142  CA  GLU B  17      12.267  91.868  29.490  1.00 41.68           C  
ATOM   1143  C   GLU B  17      12.163  90.723  30.517  1.00 42.02           C  
ATOM   1144  O   GLU B  17      11.080  90.444  31.053  1.00 39.16           O  
ATOM   1145  CB  GLU B  17      12.187  91.284  28.065  1.00 43.64           C  
ATOM   1146  CG  GLU B  17      11.646  92.224  26.990  1.00 48.48           C  
ATOM   1147  N   VAL B  18      13.300  90.082  30.796  1.00 41.20           N  
ATOM   1148  CA  VAL B  18      13.331  88.889  31.632  1.00 38.07           C  
ATOM   1149  C   VAL B  18      13.288  89.311  33.084  1.00 38.16           C  
ATOM   1150  O   VAL B  18      12.596  88.690  33.891  1.00 35.73           O  
ATOM   1151  CB  VAL B  18      14.576  88.043  31.357  1.00 37.20           C  
ATOM   1152  CG1 VAL B  18      14.627  86.827  32.288  1.00 38.58           C  
ATOM   1153  CG2 VAL B  18      14.616  87.626  29.902  1.00 36.74           C  
ATOM   1154  N   LYS B  19      14.008  90.377  33.414  1.00 36.39           N  
ATOM   1155  CA  LYS B  19      13.975  90.907  34.770  1.00 37.06           C  
ATOM   1156  C   LYS B  19      12.592  91.367  35.195  1.00 35.59           C  
ATOM   1157  O   LYS B  19      12.188  91.086  36.304  1.00 33.55           O  
ATOM   1158  CB  LYS B  19      14.973  92.032  34.987  1.00 38.54           C  
ATOM   1159  CG  LYS B  19      14.962  92.487  36.429  1.00 37.18           C  
ATOM   1160  CD  LYS B  19      16.245  93.158  36.833  1.00 44.23           C  
ATOM   1161  CE  LYS B  19      16.008  94.239  37.889  1.00 49.09           C  
ATOM   1162  NZ  LYS B  19      15.338  93.660  39.091  1.00 45.26           N  
ATOM   1163  N   ALA B  20      11.880  92.063  34.315  1.00 36.15           N  
ATOM   1164  CA  ALA B  20      10.473  92.418  34.570  1.00 37.60           C  
ATOM   1165  C   ALA B  20       9.622  91.205  35.007  1.00 35.86           C  
ATOM   1166  O   ALA B  20       8.861  91.276  35.975  1.00 33.61           O  
ATOM   1167  CB  ALA B  20       9.877  93.035  33.343  1.00 37.80           C  
ATOM   1168  N   VAL B  21       9.747  90.098  34.288  1.00 35.66           N  
ATOM   1169  CA  VAL B  21       8.974  88.881  34.583  1.00 36.03           C  
ATOM   1170  C   VAL B  21       9.395  88.297  35.941  1.00 35.61           C  
ATOM   1171  O   VAL B  21       8.556  87.987  36.788  1.00 36.32           O  
ATOM   1172  CB  VAL B  21       9.143  87.787  33.457  1.00 37.80           C  
ATOM   1173  CG1 VAL B  21       8.539  86.470  33.892  1.00 38.47           C  
ATOM   1174  CG2 VAL B  21       8.524  88.236  32.145  1.00 33.83           C  
ATOM   1175  N   PHE B  22      10.696  88.166  36.150  1.00 35.44           N  
ATOM   1176  CA  PHE B  22      11.218  87.590  37.392  1.00 35.44           C  
ATOM   1177  C   PHE B  22      10.846  88.405  38.613  1.00 36.95           C  
ATOM   1178  O   PHE B  22      10.542  87.854  39.668  1.00 37.01           O  
ATOM   1179  CB  PHE B  22      12.738  87.402  37.330  1.00 36.81           C  
ATOM   1180  CG  PHE B  22      13.150  86.057  36.820  1.00 36.34           C  
ATOM   1181  CD1 PHE B  22      12.848  85.678  35.536  1.00 39.18           C  
ATOM   1182  CD2 PHE B  22      13.850  85.171  37.623  1.00 38.14           C  
ATOM   1183  CE1 PHE B  22      13.206  84.415  35.063  1.00 39.65           C  
ATOM   1184  CE2 PHE B  22      14.211  83.911  37.151  1.00 34.06           C  
ATOM   1185  CZ  PHE B  22      13.917  83.553  35.867  1.00 37.67           C  
ATOM   1186  N   ASP B  23      10.866  89.723  38.486  1.00 36.06           N  
ATOM   1187  CA  ASP B  23      10.466  90.556  39.605  1.00 36.03           C  
ATOM   1188  C   ASP B  23       8.987  90.459  39.890  1.00 34.42           C  
ATOM   1189  O   ASP B  23       8.601  90.508  41.030  1.00 39.39           O  
ATOM   1190  CB  ASP B  23      10.879  91.998  39.363  1.00 36.36           C  
ATOM   1191  CG  ASP B  23      12.365  92.199  39.546  1.00 38.20           C  
ATOM   1192  OD1 ASP B  23      13.033  91.327  40.158  1.00 41.44           O  
ATOM   1193  OD2 ASP B  23      12.861  93.226  39.058  1.00 39.52           O  
ATOM   1194  N   ASP B  24       8.171  90.329  38.856  1.00 32.97           N  
ATOM   1195  CA  ASP B  24       6.738  90.079  39.013  1.00 34.15           C  
ATOM   1196  C   ASP B  24       6.460  88.715  39.695  1.00 32.56           C  
ATOM   1197  O   ASP B  24       5.627  88.626  40.585  1.00 30.81           O  
ATOM   1198  CB  ASP B  24       6.038  90.134  37.656  1.00 33.14           C  
ATOM   1199  CG  ASP B  24       4.530  90.330  37.789  1.00 39.68           C  
ATOM   1200  OD1 ASP B  24       4.125  91.154  38.616  1.00 42.88           O  
ATOM   1201  OD2 ASP B  24       3.755  89.688  37.066  1.00 41.91           O  
ATOM   1202  N   ILE B  25       7.163  87.667  39.284  1.00 33.37           N  
ATOM   1203  CA  ILE B  25       7.085  86.377  39.995  1.00 34.27           C  
ATOM   1204  C   ILE B  25       7.390  86.544  41.482  1.00 32.81           C  
ATOM   1205  O   ILE B  25       6.664  86.050  42.322  1.00 31.94           O  
ATOM   1206  CB  ILE B  25       8.028  85.305  39.409  1.00 34.62           C  
ATOM   1207  CG1 ILE B  25       7.615  84.994  37.965  1.00 33.92           C  
ATOM   1208  CG2 ILE B  25       7.985  84.030  40.329  1.00 37.58           C  
ATOM   1209  CD1 ILE B  25       8.566  84.114  37.155  1.00 34.76           C  
ATOM   1210  N   ARG B  26       8.458  87.252  41.802  1.00 32.79           N  
ATOM   1211  CA  ARG B  26       8.832  87.451  43.179  1.00 34.63           C  
ATOM   1212  C   ARG B  26       7.809  88.287  43.924  1.00 34.59           C  
ATOM   1213  O   ARG B  26       7.515  88.019  45.084  1.00 34.83           O  
ATOM   1214  CB  ARG B  26      10.189  88.133  43.280  1.00 35.11           C  
ATOM   1215  CG  ARG B  26      11.318  87.273  42.827  1.00 36.28           C  
ATOM   1216  CD  ARG B  26      12.629  88.021  43.016  1.00 36.31           C  
ATOM   1217  NE  ARG B  26      13.730  87.138  42.669  1.00 40.65           N  
ATOM   1218  CZ  ARG B  26      14.468  87.216  41.562  1.00 41.57           C  
ATOM   1219  NH1 ARG B  26      14.319  88.215  40.679  1.00 40.91           N  
ATOM   1220  NH2 ARG B  26      15.407  86.298  41.374  1.00 40.53           N  
ATOM   1221  N   ALA B  27       7.262  89.308  43.264  1.00 37.27           N  
ATOM   1222  CA  ALA B  27       6.293  90.188  43.918  1.00 38.44           C  
ATOM   1223  C   ALA B  27       5.009  89.424  44.157  1.00 38.67           C  
ATOM   1224  O   ALA B  27       4.387  89.581  45.179  1.00 40.06           O  
ATOM   1225  CB  ALA B  27       6.028  91.448  43.066  1.00 37.94           C  
ATOM   1226  N   THR B  28       4.643  88.588  43.194  1.00 39.64           N  
ATOM   1227  CA  THR B  28       3.402  87.827  43.219  1.00 39.42           C  
ATOM   1228  C   THR B  28       3.455  86.742  44.280  1.00 41.40           C  
ATOM   1229  O   THR B  28       2.526  86.597  45.070  1.00 41.43           O  
ATOM   1230  CB  THR B  28       3.149  87.168  41.854  1.00 39.51           C  
ATOM   1231  OG1 THR B  28       2.965  88.174  40.858  1.00 37.96           O  
ATOM   1232  CG2 THR B  28       1.948  86.267  41.879  1.00 40.44           C  
ATOM   1233  N   ARG B  29       4.557  86.004  44.301  1.00 41.75           N  
ATOM   1234  CA  ARG B  29       4.736  84.879  45.204  1.00 43.75           C  
ATOM   1235  C   ARG B  29       5.174  85.273  46.595  1.00 44.34           C  
ATOM   1236  O   ARG B  29       5.074  84.483  47.517  1.00 44.60           O  
ATOM   1237  CB  ARG B  29       5.751  83.897  44.614  1.00 43.39           C  
ATOM   1238  CG  ARG B  29       5.217  83.210  43.399  1.00 44.53           C  
ATOM   1239  CD  ARG B  29       6.096  82.074  42.941  1.00 50.82           C  
ATOM   1240  NE  ARG B  29       5.425  81.386  41.840  1.00 54.44           N  
ATOM   1241  CZ  ARG B  29       5.961  80.412  41.102  1.00 52.47           C  
ATOM   1242  NH1 ARG B  29       7.195  79.997  41.312  1.00 52.89           N  
ATOM   1243  NH2 ARG B  29       5.250  79.864  40.125  1.00 53.24           N  
ATOM   1244  N   GLY B  30       5.661  86.489  46.760  1.00 43.72           N  
ATOM   1245  CA  GLY B  30       6.058  86.951  48.089  1.00 45.68           C  
ATOM   1246  C   GLY B  30       7.361  86.350  48.578  1.00 46.53           C  
ATOM   1247  O   GLY B  30       7.607  86.222  49.776  1.00 45.21           O  
ATOM   1248  N   SER B  31       8.216  86.012  47.634  1.00 45.93           N  
ATOM   1249  CA  SER B  31       9.480  85.382  47.936  1.00 46.93           C  
ATOM   1250  C   SER B  31      10.472  85.777  46.863  1.00 44.91           C  
ATOM   1251  O   SER B  31      10.076  85.946  45.717  1.00 43.09           O  
ATOM   1252  CB  SER B  31       9.263  83.873  47.915  1.00 48.52           C  
ATOM   1253  OG  SER B  31      10.484  83.198  47.803  1.00 50.45           O  
ATOM   1254  N   ASP B  32      11.747  85.903  47.221  1.00 43.55           N  
ATOM   1255  CA  ASP B  32      12.801  86.170  46.234  1.00 44.47           C  
ATOM   1256  C   ASP B  32      13.236  84.906  45.454  1.00 41.95           C  
ATOM   1257  O   ASP B  32      13.917  85.004  44.443  1.00 41.01           O  
ATOM   1258  CB  ASP B  32      14.015  86.862  46.885  1.00 43.54           C  
ATOM   1259  CG  ASP B  32      13.806  88.380  47.064  1.00 46.08           C  
ATOM   1260  N   PHE B  33      12.821  83.730  45.903  1.00 40.24           N  
ATOM   1261  CA  PHE B  33      13.172  82.477  45.222  1.00 40.57           C  
ATOM   1262  C   PHE B  33      12.367  82.292  43.964  1.00 39.77           C  
ATOM   1263  O   PHE B  33      11.156  82.243  44.021  1.00 42.56           O  
ATOM   1264  CB  PHE B  33      12.906  81.276  46.157  1.00 41.60           C  
ATOM   1265  CG  PHE B  33      13.075  79.928  45.494  1.00 44.52           C  
ATOM   1266  CD1 PHE B  33      14.319  79.503  45.039  1.00 48.56           C  
ATOM   1267  CD2 PHE B  33      11.983  79.089  45.305  1.00 50.23           C  
ATOM   1268  CE1 PHE B  33      14.467  78.259  44.420  1.00 47.76           C  
ATOM   1269  CE2 PHE B  33      12.132  77.842  44.688  1.00 49.84           C  
ATOM   1270  CZ  PHE B  33      13.357  77.440  44.239  1.00 39.59           C  
ATOM   1271  N   VAL B  34      13.025  82.126  42.830  1.00 39.26           N  
ATOM   1272  CA  VAL B  34      12.334  81.798  41.567  1.00 39.05           C  
ATOM   1273  C   VAL B  34      12.930  80.473  41.086  1.00 38.56           C  
ATOM   1274  O   VAL B  34      14.132  80.361  40.942  1.00 40.03           O  
ATOM   1275  CB  VAL B  34      12.553  82.883  40.484  1.00 39.55           C  
ATOM   1276  CG1 VAL B  34      11.813  82.526  39.203  1.00 40.62           C  
ATOM   1277  CG2 VAL B  34      12.180  84.293  41.008  1.00 39.31           C  
ATOM   1278  N   ASN B  35      12.098  79.481  40.855  1.00 38.85           N  
ATOM   1279  CA  ASN B  35      12.586  78.148  40.557  1.00 39.03           C  
ATOM   1280  C   ASN B  35      12.995  77.957  39.100  1.00 37.92           C  
ATOM   1281  O   ASN B  35      12.666  78.764  38.243  1.00 34.65           O  
ATOM   1282  CB  ASN B  35      11.592  77.068  41.002  1.00 41.17           C  
ATOM   1283  CG  ASN B  35      10.212  77.287  40.478  1.00 42.00           C  
ATOM   1284  OD1 ASN B  35       9.669  78.372  40.610  1.00 47.13           O  
ATOM   1285  ND2 ASN B  35       9.612  76.240  39.901  1.00 48.58           N  
ATOM   1286  N   ASN B  36      13.749  76.886  38.867  1.00 37.13           N  
ATOM   1287  CA  ASN B  36      14.452  76.629  37.613  1.00 34.79           C  
ATOM   1288  C   ASN B  36      13.653  76.662  36.322  1.00 35.54           C  
ATOM   1289  O   ASN B  36      14.194  77.020  35.260  1.00 35.21           O  
ATOM   1290  CB  ASN B  36      15.178  75.285  37.720  1.00 35.28           C  
ATOM   1291  CG  ASN B  36      16.366  75.352  38.653  1.00 36.76           C  
ATOM   1292  OD1 ASN B  36      16.932  76.428  38.869  1.00 38.44           O  
ATOM   1293  ND2 ASN B  36      16.765  74.202  39.201  1.00 34.11           N  
ATOM   1294  N   ILE B  37      12.394  76.245  36.383  1.00 34.83           N  
ATOM   1295  CA  ILE B  37      11.574  76.271  35.177  1.00 36.23           C  
ATOM   1296  C   ILE B  37      11.704  77.650  34.532  1.00 34.97           C  
ATOM   1297  O   ILE B  37      11.923  77.747  33.310  1.00 34.40           O  
ATOM   1298  CB  ILE B  37      10.121  75.858  35.408  1.00 34.78           C  
ATOM   1299  CG1 ILE B  37       9.367  75.835  34.060  1.00 38.59           C  
ATOM   1300  CG2 ILE B  37       9.394  76.767  36.386  1.00 40.94           C  
ATOM   1301  CD1 ILE B  37       7.905  75.613  34.169  1.00 40.61           C  
ATOM   1302  N   TRP B  38      11.638  78.708  35.354  1.00 34.55           N  
ATOM   1303  CA  TRP B  38      11.620  80.085  34.822  1.00 35.84           C  
ATOM   1304  C   TRP B  38      12.959  80.500  34.215  1.00 34.61           C  
ATOM   1305  O   TRP B  38      13.016  81.270  33.254  1.00 34.38           O  
ATOM   1306  CB  TRP B  38      11.127  81.082  35.900  1.00 36.41           C  
ATOM   1307  CG  TRP B  38       9.779  80.687  36.424  1.00 35.52           C  
ATOM   1308  CD1 TRP B  38       9.501  80.137  37.652  1.00 37.62           C  
ATOM   1309  CD2 TRP B  38       8.533  80.720  35.717  1.00 38.28           C  
ATOM   1310  NE1 TRP B  38       8.154  79.840  37.749  1.00 38.44           N  
ATOM   1311  CE2 TRP B  38       7.538  80.205  36.587  1.00 38.85           C  
ATOM   1312  CE3 TRP B  38       8.148  81.171  34.452  1.00 38.58           C  
ATOM   1313  CZ2 TRP B  38       6.186  80.111  36.211  1.00 41.61           C  
ATOM   1314  CZ3 TRP B  38       6.805  81.072  34.085  1.00 37.42           C  
ATOM   1315  CH2 TRP B  38       5.849  80.546  34.962  1.00 38.47           C  
ATOM   1316  N   ARG B  39      14.026  79.948  34.779  1.00 37.26           N  
ATOM   1317  CA  ARG B  39      15.374  80.220  34.387  1.00 35.87           C  
ATOM   1318  C   ARG B  39      15.725  79.572  33.046  1.00 35.04           C  
ATOM   1319  O   ARG B  39      16.593  80.058  32.353  1.00 35.92           O  
ATOM   1320  CB  ARG B  39      16.329  79.733  35.478  1.00 36.55           C  
ATOM   1321  CG  ARG B  39      16.141  80.492  36.791  1.00 36.57           C  
ATOM   1322  CD  ARG B  39      17.235  80.254  37.804  1.00 39.06           C  
ATOM   1323  NE  ARG B  39      16.947  81.002  39.028  1.00 41.78           N  
ATOM   1324  CZ  ARG B  39      17.186  82.300  39.208  1.00 37.64           C  
ATOM   1325  NH1 ARG B  39      17.740  83.050  38.260  1.00 35.04           N  
ATOM   1326  NH2 ARG B  39      16.857  82.851  40.368  1.00 42.45           N  
ATOM   1327  N   GLY B  40      15.048  78.482  32.715  1.00 37.71           N  
ATOM   1328  CA  GLY B  40      15.125  77.857  31.410  1.00 38.81           C  
ATOM   1329  C   GLY B  40      14.224  78.546  30.392  1.00 38.70           C  
ATOM   1330  O   GLY B  40      14.634  78.758  29.235  1.00 36.84           O  
ATOM   1331  N   LEU B  41      12.996  78.896  30.786  1.00 39.14           N  
ATOM   1332  CA  LEU B  41      12.125  79.680  29.889  1.00 37.19           C  
ATOM   1333  C   LEU B  41      12.747  81.025  29.546  1.00 37.05           C  
ATOM   1334  O   LEU B  41      12.522  81.551  28.466  1.00 37.22           O  
ATOM   1335  CB  LEU B  41      10.735  79.876  30.475  1.00 37.72           C  
ATOM   1336  CG  LEU B  41       9.908  78.597  30.684  1.00 38.20           C  
ATOM   1337  CD1 LEU B  41       8.686  78.873  31.506  1.00 34.59           C  
ATOM   1338  CD2 LEU B  41       9.524  77.982  29.358  1.00 41.05           C  
ATOM   1339  N   ALA B  42      13.568  81.567  30.447  1.00 37.22           N  
ATOM   1340  CA  ALA B  42      14.212  82.862  30.250  1.00 35.36           C  
ATOM   1341  C   ALA B  42      15.058  82.996  28.979  1.00 37.50           C  
ATOM   1342  O   ALA B  42      15.354  84.126  28.552  1.00 37.22           O  
ATOM   1343  CB  ALA B  42      15.065  83.209  31.489  1.00 34.84           C  
ATOM   1344  N   ASN B  43      15.473  81.872  28.396  1.00 36.72           N  
ATOM   1345  CA  ASN B  43      16.172  81.908  27.102  1.00 38.80           C  
ATOM   1346  C   ASN B  43      15.324  82.487  25.963  1.00 39.87           C  
ATOM   1347  O   ASN B  43      15.865  82.953  24.976  1.00 40.50           O  
ATOM   1348  CB  ASN B  43      16.637  80.516  26.691  1.00 36.80           C  
ATOM   1349  CG  ASN B  43      17.721  79.996  27.579  1.00 36.26           C  
ATOM   1350  OD1 ASN B  43      18.867  80.388  27.443  1.00 39.44           O  
ATOM   1351  ND2 ASN B  43      17.369  79.116  28.505  1.00 35.05           N  
ATOM   1352  N   ASP B  44      14.003  82.424  26.097  1.00 40.93           N  
ATOM   1353  CA  ASP B  44      13.100  83.074  25.172  1.00 41.84           C  
ATOM   1354  C   ASP B  44      12.141  83.992  25.917  1.00 39.73           C  
ATOM   1355  O   ASP B  44      11.115  83.529  26.399  1.00 39.18           O  
ATOM   1356  CB  ASP B  44      12.267  82.027  24.426  1.00 44.03           C  
ATOM   1357  CG  ASP B  44      11.411  82.652  23.338  1.00 48.82           C  
ATOM   1358  OD1 ASP B  44      11.940  83.533  22.641  1.00 48.87           O  
ATOM   1359  OD2 ASP B  44      10.244  82.261  23.167  1.00 54.20           O  
ATOM   1360  N   PRO B  45      12.458  85.294  26.010  1.00 38.90           N  
ATOM   1361  CA  PRO B  45      11.591  86.227  26.721  1.00 38.47           C  
ATOM   1362  C   PRO B  45      10.117  86.156  26.373  1.00 38.95           C  
ATOM   1363  O   PRO B  45       9.288  86.233  27.272  1.00 40.01           O  
ATOM   1364  CB  PRO B  45      12.173  87.587  26.355  1.00 41.18           C  
ATOM   1365  CG  PRO B  45      13.613  87.309  26.201  1.00 42.28           C  
ATOM   1366  CD  PRO B  45      13.664  85.970  25.506  1.00 39.36           C  
ATOM   1367  N   ALA B  46       9.785  85.979  25.103  1.00 37.21           N  
ATOM   1368  CA  ALA B  46       8.373  85.962  24.683  1.00 37.99           C  
ATOM   1369  C   ALA B  46       7.620  84.778  25.256  1.00 39.55           C  
ATOM   1370  O   ALA B  46       6.481  84.910  25.722  1.00 39.81           O  
ATOM   1371  CB  ALA B  46       8.258  85.979  23.172  1.00 37.79           C  
ATOM   1372  N   LEU B  47       8.260  83.613  25.219  1.00 39.44           N  
ATOM   1373  CA  LEU B  47       7.676  82.427  25.794  1.00 40.18           C  
ATOM   1374  C   LEU B  47       7.589  82.543  27.315  1.00 39.18           C  
ATOM   1375  O   LEU B  47       6.606  82.114  27.938  1.00 39.43           O  
ATOM   1376  CB  LEU B  47       8.512  81.204  25.385  1.00 40.88           C  
ATOM   1377  CG  LEU B  47       8.114  79.846  25.948  1.00 41.06           C  
ATOM   1378  CD1 LEU B  47       6.668  79.502  25.609  1.00 42.85           C  
ATOM   1379  CD2 LEU B  47       9.050  78.800  25.369  1.00 48.24           C  
ATOM   1380  N   LEU B  48       8.645  83.083  27.915  1.00 38.49           N  
ATOM   1381  CA  LEU B  48       8.666  83.289  29.351  1.00 38.19           C  
ATOM   1382  C   LEU B  48       7.473  84.099  29.822  1.00 37.75           C  
ATOM   1383  O   LEU B  48       6.826  83.707  30.771  1.00 37.89           O  
ATOM   1384  CB  LEU B  48       9.964  83.973  29.784  1.00 37.23           C  
ATOM   1385  CG  LEU B  48      10.060  84.468  31.237  1.00 38.12           C  
ATOM   1386  CD1 LEU B  48      10.204  83.344  32.266  1.00 41.71           C  
ATOM   1387  CD2 LEU B  48      11.211  85.392  31.375  1.00 36.91           C  
ATOM   1388  N   LYS B  49       7.200  85.223  29.161  1.00 37.68           N  
ATOM   1389  CA  LYS B  49       6.078  86.093  29.503  1.00 36.58           C  
ATOM   1390  C   LYS B  49       4.732  85.468  29.204  1.00 37.65           C  
ATOM   1391  O   LYS B  49       3.818  85.606  29.998  1.00 38.17           O  
ATOM   1392  CB  LYS B  49       6.181  87.443  28.796  1.00 38.20           C  
ATOM   1393  N   ARG B  50       4.591  84.763  28.088  1.00 37.00           N  
ATOM   1394  CA  ARG B  50       3.322  84.061  27.807  1.00 38.36           C  
ATOM   1395  C   ARG B  50       2.988  83.011  28.870  1.00 38.75           C  
ATOM   1396  O   ARG B  50       1.831  82.780  29.205  1.00 40.91           O  
ATOM   1397  CB  ARG B  50       3.373  83.343  26.452  1.00 39.48           C  
ATOM   1398  CG  ARG B  50       3.122  84.185  25.242  1.00 43.81           C  
ATOM   1399  CD  ARG B  50       2.672  83.337  24.059  1.00 45.23           C  
ATOM   1400  NE  ARG B  50       3.608  82.262  23.724  1.00 45.98           N  
ATOM   1401  CZ  ARG B  50       4.751  82.419  23.044  1.00 47.60           C  
ATOM   1402  NH1 ARG B  50       5.142  83.616  22.604  1.00 39.46           N  
ATOM   1403  NH2 ARG B  50       5.507  81.354  22.792  1.00 47.81           N  
ATOM   1404  N   THR B  51       4.013  82.311  29.339  1.00 38.70           N  
ATOM   1405  CA  THR B  51       3.817  81.242  30.288  1.00 38.26           C  
ATOM   1406  C   THR B  51       3.488  81.847  31.651  1.00 39.21           C  
ATOM   1407  O   THR B  51       2.495  81.481  32.295  1.00 38.25           O  
ATOM   1408  CB  THR B  51       5.068  80.362  30.394  1.00 38.35           C  
ATOM   1409  OG1 THR B  51       5.497  79.941  29.084  1.00 36.97           O  
ATOM   1410  CG2 THR B  51       4.770  79.153  31.264  1.00 36.95           C  
ATOM   1411  N   TRP B  52       4.314  82.792  32.086  1.00 38.76           N  
ATOM   1412  CA  TRP B  52       4.052  83.449  33.344  1.00 38.08           C  
ATOM   1413  C   TRP B  52       2.690  84.125  33.369  1.00 38.30           C  
ATOM   1414  O   TRP B  52       1.985  83.998  34.372  1.00 37.35           O  
ATOM   1415  CB  TRP B  52       5.124  84.445  33.701  1.00 37.14           C  
ATOM   1416  CG  TRP B  52       4.765  85.266  34.894  1.00 34.87           C  
ATOM   1417  CD1 TRP B  52       4.635  86.603  34.927  1.00 33.50           C  
ATOM   1418  CD2 TRP B  52       4.457  84.794  36.221  1.00 34.68           C  
ATOM   1419  NE1 TRP B  52       4.295  87.012  36.191  1.00 36.43           N  
ATOM   1420  CE2 TRP B  52       4.182  85.922  37.004  1.00 34.93           C  
ATOM   1421  CE3 TRP B  52       4.413  83.532  36.821  1.00 35.17           C  
ATOM   1422  CZ2 TRP B  52       3.852  85.837  38.349  1.00 36.80           C  
ATOM   1423  CZ3 TRP B  52       4.108  83.441  38.151  1.00 32.29           C  
ATOM   1424  CH2 TRP B  52       3.817  84.596  38.909  1.00 34.57           C  
ATOM   1425  N   GLU B  53       2.297  84.807  32.292  1.00 37.94           N  
ATOM   1426  CA  GLU B  53       0.997  85.478  32.308  1.00 39.19           C  
ATOM   1427  C   GLU B  53      -0.158  84.482  32.502  1.00 40.88           C  
ATOM   1428  O   GLU B  53      -1.119  84.773  33.244  1.00 37.16           O  
ATOM   1429  CB  GLU B  53       0.774  86.360  31.074  1.00 38.51           C  
ATOM   1430  CG  GLU B  53       1.623  87.683  31.019  1.00 46.99           C  
ATOM   1431  CD  GLU B  53       1.498  88.613  32.253  1.00 59.97           C  
ATOM   1432  OE1 GLU B  53       0.372  88.764  32.784  1.00 69.98           O  
ATOM   1433  OE2 GLU B  53       2.526  89.215  32.682  1.00 62.13           O  
ATOM   1434  N   GLN B  54      -0.068  83.315  31.851  1.00 40.53           N  
ATOM   1435  CA  GLN B  54      -1.058  82.257  32.072  1.00 42.37           C  
ATOM   1436  C   GLN B  54      -1.083  81.770  33.500  1.00 41.33           C  
ATOM   1437  O   GLN B  54      -2.144  81.636  34.103  1.00 42.06           O  
ATOM   1438  CB  GLN B  54      -0.785  81.056  31.186  1.00 43.20           C  
ATOM   1439  CG  GLN B  54      -1.349  81.183  29.828  1.00 42.46           C  
ATOM   1440  CD  GLN B  54      -0.936  80.021  28.962  1.00 50.86           C  
ATOM   1441  OE1 GLN B  54      -1.679  79.022  28.855  1.00 37.84           O  
ATOM   1442  NE2 GLN B  54       0.277  80.115  28.366  1.00 42.79           N  
ATOM   1443  N   VAL B  55       0.099  81.472  34.023  1.00 42.39           N  
ATOM   1444  CA  VAL B  55       0.214  80.932  35.369  1.00 42.28           C  
ATOM   1445  C   VAL B  55      -0.405  81.921  36.363  1.00 45.63           C  
ATOM   1446  O   VAL B  55      -1.223  81.546  37.225  1.00 45.76           O  
ATOM   1447  CB  VAL B  55       1.679  80.610  35.685  1.00 42.85           C  
ATOM   1448  CG1 VAL B  55       1.886  80.359  37.147  1.00 39.58           C  
ATOM   1449  CG2 VAL B  55       2.111  79.415  34.852  1.00 43.27           C  
ATOM   1450  N   LYS B  56      -0.046  83.188  36.195  1.00 45.50           N  
ATOM   1451  CA  LYS B  56      -0.532  84.251  37.070  0.50 45.66           C  
ATOM   1453  C   LYS B  56      -2.061  84.352  36.982  1.00 45.65           C  
ATOM   1454  O   LYS B  56      -2.737  84.431  38.006  1.00 48.57           O  
ATOM   1455  CB  LYS B  56       0.155  85.579  36.715  0.50 45.96           C  
ATOM   1457  CG  LYS B  56       0.053  86.656  37.778  0.50 46.34           C  
ATOM   1459  CD  LYS B  56       0.577  87.994  37.268  0.50 48.16           C  
ATOM   1461  CE  LYS B  56       0.072  89.168  38.118  0.50 52.29           C  
ATOM   1463  NZ  LYS B  56       0.580  89.173  39.529  0.50 51.27           N  
ATOM   1465  N   THR B  57      -2.621  84.298  35.776  1.00 43.07           N  
ATOM   1466  CA  THR B  57      -4.071  84.418  35.601  1.00 43.07           C  
ATOM   1467  C   THR B  57      -4.856  83.250  36.164  1.00 43.88           C  
ATOM   1468  O   THR B  57      -5.909  83.438  36.776  1.00 42.47           O  
ATOM   1469  CB  THR B  57      -4.442  84.529  34.110  1.00 43.99           C  
ATOM   1470  OG1 THR B  57      -3.922  85.755  33.592  1.00 41.05           O  
ATOM   1471  CG2 THR B  57      -5.964  84.496  33.887  1.00 46.72           C  
ATOM   1472  N   VAL B  58      -4.366  82.043  35.921  1.00 42.78           N  
ATOM   1473  CA  VAL B  58      -5.075  80.826  36.291  1.00 40.90           C  
ATOM   1474  C   VAL B  58      -4.899  80.459  37.754  1.00 41.15           C  
ATOM   1475  O   VAL B  58      -5.846  80.028  38.386  1.00 41.82           O  
ATOM   1476  CB  VAL B  58      -4.651  79.659  35.364  1.00 41.68           C  
ATOM   1477  CG1 VAL B  58      -5.258  78.311  35.822  1.00 44.10           C  
ATOM   1478  CG2 VAL B  58      -5.083  79.966  33.957  1.00 38.81           C  
HETATM 1479  N   MSE B  59      -3.705  80.662  38.299  1.00 38.34           N  
HETATM 1480  CA  MSE B  59      -3.340  80.132  39.609  1.00 43.10           C  
HETATM 1481  C   MSE B  59      -3.338  81.166  40.727  1.00 47.33           C  
HETATM 1482  O   MSE B  59      -3.170  80.797  41.892  1.00 50.94           O  
HETATM 1483  CB  MSE B  59      -1.935  79.522  39.544  1.00 42.01           C  
HETATM 1484  CG  MSE B  59      -1.785  78.429  38.485  1.00 44.42           C  
HETATM 1485 SE   MSE B  59      -2.960  76.927  38.922  0.75 38.00          SE  
HETATM 1486  CE  MSE B  59      -1.799  76.342  40.407  1.00 39.50           C  
ATOM   1487  N   VAL B  60      -3.510  82.444  40.378  1.00 49.54           N  
ATOM   1488  CA  VAL B  60      -3.443  83.550  41.336  1.00 49.31           C  
ATOM   1489  C   VAL B  60      -4.682  84.425  41.248  1.00 50.41           C  
ATOM   1490  O   VAL B  60      -5.175  84.770  40.170  1.00 48.93           O  
ATOM   1491  CB  VAL B  60      -2.174  84.425  41.113  1.00 50.71           C  
ATOM   1492  CG1 VAL B  60      -2.042  85.486  42.190  1.00 53.13           C  
ATOM   1493  CG2 VAL B  60      -0.919  83.556  41.069  1.00 49.08           C  
ATOM   1494  N   GLY B  61      -5.192  84.785  42.413  1.00 53.52           N  
ATOM   1495  CA  GLY B  61      -6.331  85.688  42.498  1.00 56.27           C  
ATOM   1496  C   GLY B  61      -7.609  84.944  42.789  1.00 57.31           C  
ATOM   1497  O   GLY B  61      -7.616  83.709  42.809  1.00 57.42           O  
ATOM   1498  N   GLU B  62      -8.684  85.699  43.028  1.00 57.60           N  
ATOM   1499  CA  GLU B  62      -9.994  85.111  43.287  1.00 58.60           C  
ATOM   1500  C   GLU B  62     -10.436  84.325  42.041  1.00 58.66           C  
ATOM   1501  O   GLU B  62     -10.099  84.676  40.897  1.00 60.46           O  
ATOM   1502  CB  GLU B  62     -11.028  86.186  43.675  1.00 58.21           C  
ATOM   1503  N   GLY B  63     -11.170  83.249  42.285  1.00 56.31           N  
ATOM   1504  CA  GLY B  63     -11.569  82.327  41.238  1.00 53.81           C  
ATOM   1505  C   GLY B  63     -12.454  81.274  41.863  1.00 52.91           C  
ATOM   1506  O   GLY B  63     -12.709  81.318  43.070  1.00 53.04           O  
ATOM   1507  N   ALA B  64     -12.917  80.323  41.056  1.00 51.08           N  
ATOM   1508  CA  ALA B  64     -13.961  79.400  41.493  1.00 50.36           C  
ATOM   1509  C   ALA B  64     -13.455  78.334  42.480  1.00 48.28           C  
ATOM   1510  O   ALA B  64     -14.267  77.701  43.196  1.00 49.03           O  
ATOM   1511  CB  ALA B  64     -14.621  78.746  40.280  1.00 51.97           C  
ATOM   1512  N   LEU B  65     -12.134  78.165  42.527  1.00 42.45           N  
ATOM   1513  CA  LEU B  65     -11.498  77.130  43.340  1.00 44.04           C  
ATOM   1514  C   LEU B  65     -10.447  77.782  44.216  1.00 44.75           C  
ATOM   1515  O   LEU B  65      -9.799  78.703  43.768  1.00 43.12           O  
ATOM   1516  CB  LEU B  65     -10.768  76.101  42.442  1.00 43.20           C  
ATOM   1517  CG  LEU B  65     -11.540  75.312  41.384  1.00 40.45           C  
ATOM   1518  CD1 LEU B  65     -10.592  74.363  40.697  1.00 38.23           C  
ATOM   1519  CD2 LEU B  65     -12.752  74.565  41.971  1.00 44.41           C  
ATOM   1520  N   ASP B  66     -10.224  77.290  45.434  1.00 46.07           N  
ATOM   1521  CA  ASP B  66      -9.186  77.919  46.271  1.00 47.27           C  
ATOM   1522  C   ASP B  66      -7.786  77.539  45.791  1.00 44.86           C  
ATOM   1523  O   ASP B  66      -7.623  76.564  45.066  1.00 44.76           O  
ATOM   1524  CB  ASP B  66      -9.415  77.698  47.782  1.00 49.23           C  
ATOM   1525  CG  ASP B  66      -9.365  76.242  48.204  1.00 49.61           C  
ATOM   1526  OD1 ASP B  66      -8.539  75.477  47.685  1.00 48.87           O  
ATOM   1527  OD2 ASP B  66     -10.148  75.877  49.114  1.00 66.75           O  
ATOM   1528  N   PRO B  67      -6.773  78.342  46.153  1.00 45.48           N  
ATOM   1529  CA  PRO B  67      -5.431  78.116  45.659  1.00 45.54           C  
ATOM   1530  C   PRO B  67      -4.866  76.743  45.925  1.00 44.52           C  
ATOM   1531  O   PRO B  67      -4.129  76.238  45.098  1.00 43.61           O  
ATOM   1532  CB  PRO B  67      -4.613  79.192  46.391  1.00 46.35           C  
ATOM   1533  CG  PRO B  67      -5.564  80.273  46.581  1.00 46.84           C  
ATOM   1534  CD  PRO B  67      -6.818  79.554  46.993  1.00 47.50           C  
ATOM   1535  N   LEU B  68      -5.181  76.156  47.078  1.00 44.61           N  
ATOM   1536  CA  LEU B  68      -4.667  74.830  47.410  1.00 44.18           C  
ATOM   1537  C   LEU B  68      -5.291  73.795  46.493  1.00 41.41           C  
ATOM   1538  O   LEU B  68      -4.618  72.916  45.994  1.00 43.05           O  
ATOM   1539  CB  LEU B  68      -4.942  74.472  48.882  1.00 43.94           C  
ATOM   1540  CG  LEU B  68      -4.525  73.055  49.302  1.00 44.81           C  
ATOM   1541  CD1 LEU B  68      -3.061  72.787  48.946  1.00 43.13           C  
ATOM   1542  CD2 LEU B  68      -4.756  72.828  50.769  1.00 45.16           C  
ATOM   1543  N   THR B  69      -6.594  73.897  46.280  1.00 40.67           N  
ATOM   1544  CA  THR B  69      -7.273  72.985  45.380  1.00 39.17           C  
ATOM   1545  C   THR B  69      -6.640  73.038  43.982  1.00 38.49           C  
ATOM   1546  O   THR B  69      -6.348  72.006  43.389  1.00 40.42           O  
ATOM   1547  CB  THR B  69      -8.784  73.305  45.353  1.00 39.32           C  
ATOM   1548  OG1 THR B  69      -9.296  73.222  46.698  1.00 41.57           O  
ATOM   1549  CG2 THR B  69      -9.544  72.342  44.466  1.00 39.48           C  
ATOM   1550  N   ARG B  70      -6.378  74.240  43.490  1.00 37.51           N  
ATOM   1551  CA  ARG B  70      -5.702  74.419  42.189  1.00 39.00           C  
ATOM   1552  C   ARG B  70      -4.361  73.741  42.106  1.00 40.35           C  
ATOM   1553  O   ARG B  70      -4.036  73.141  41.094  1.00 41.23           O  
ATOM   1554  CB  ARG B  70      -5.495  75.888  41.882  1.00 38.41           C  
ATOM   1555  CG  ARG B  70      -6.770  76.694  41.828  1.00 37.90           C  
ATOM   1556  CD  ARG B  70      -6.423  78.159  41.685  1.00 42.65           C  
ATOM   1557  NE  ARG B  70      -7.615  78.971  41.843  1.00 51.01           N  
ATOM   1558  CZ  ARG B  70      -7.603  80.297  41.861  1.00 51.13           C  
ATOM   1559  NH1 ARG B  70      -6.462  80.948  41.724  1.00 56.19           N  
ATOM   1560  NH2 ARG B  70      -8.730  80.969  41.993  1.00 57.16           N  
ATOM   1561  N   GLU B  71      -3.563  73.840  43.173  1.00 40.53           N  
ATOM   1562  CA  GLU B  71      -2.266  73.169  43.193  1.00 40.12           C  
ATOM   1563  C   GLU B  71      -2.396  71.649  43.243  1.00 40.69           C  
ATOM   1564  O   GLU B  71      -1.569  70.935  42.681  1.00 39.83           O  
ATOM   1565  CB  GLU B  71      -1.401  73.618  44.373  1.00 40.65           C  
ATOM   1566  CG  GLU B  71      -0.562  74.849  44.130  1.00 47.04           C  
ATOM   1567  CD  GLU B  71       0.350  74.787  42.905  1.00 48.40           C  
ATOM   1568  OE1 GLU B  71       0.813  73.696  42.498  1.00 49.04           O  
ATOM   1569  OE2 GLU B  71       0.610  75.870  42.356  1.00 49.35           O  
HETATM 1570  N   MSE B  72      -3.425  71.138  43.909  1.00 42.18           N  
HETATM 1571  CA  MSE B  72      -3.569  69.677  44.004  1.00 41.78           C  
HETATM 1572  C   MSE B  72      -3.968  69.119  42.643  1.00 42.12           C  
HETATM 1573  O   MSE B  72      -3.485  68.079  42.225  1.00 41.90           O  
HETATM 1574  CB  MSE B  72      -4.583  69.315  45.081  1.00 44.27           C  
HETATM 1575  CG  MSE B  72      -4.118  69.741  46.462  1.00 42.53           C  
HETATM 1576 SE   MSE B  72      -5.302  69.212  47.906  1.00 54.11          SE  
HETATM 1577  CE  MSE B  72      -7.020  69.097  46.996  1.00 50.08           C  
ATOM   1578  N   ILE B  73      -4.828  69.837  41.934  1.00 40.66           N  
ATOM   1579  CA  ILE B  73      -5.166  69.434  40.593  1.00 41.10           C  
ATOM   1580  C   ILE B  73      -3.901  69.472  39.716  1.00 40.69           C  
ATOM   1581  O   ILE B  73      -3.612  68.507  38.988  1.00 39.43           O  
ATOM   1582  CB  ILE B  73      -6.238  70.323  39.992  1.00 40.11           C  
ATOM   1583  CG1 ILE B  73      -7.584  70.084  40.673  1.00 41.10           C  
ATOM   1584  CG2 ILE B  73      -6.391  70.036  38.515  1.00 43.00           C  
ATOM   1585  CD1 ILE B  73      -8.612  71.187  40.402  1.00 36.59           C  
ATOM   1586  N   TYR B  74      -3.132  70.554  39.811  1.00 41.84           N  
ATOM   1587  CA  TYR B  74      -1.877  70.701  39.039  1.00 41.14           C  
ATOM   1588  C   TYR B  74      -0.908  69.567  39.318  1.00 42.16           C  
ATOM   1589  O   TYR B  74      -0.227  69.059  38.416  1.00 42.17           O  
ATOM   1590  CB  TYR B  74      -1.211  72.035  39.356  1.00 41.31           C  
ATOM   1591  CG  TYR B  74      -0.532  72.761  38.196  1.00 39.89           C  
ATOM   1592  CD1 TYR B  74       0.613  72.259  37.600  1.00 44.78           C  
ATOM   1593  CD2 TYR B  74      -1.016  73.976  37.738  1.00 39.30           C  
ATOM   1594  CE1 TYR B  74       1.257  72.960  36.569  1.00 40.22           C  
ATOM   1595  CE2 TYR B  74      -0.384  74.671  36.715  1.00 39.85           C  
ATOM   1596  CZ  TYR B  74       0.752  74.159  36.139  1.00 41.27           C  
ATOM   1597  OH  TYR B  74       1.392  74.847  35.120  1.00 44.22           O  
ATOM   1598  N   LEU B  75      -0.847  69.165  40.578  1.00 43.48           N  
ATOM   1599  CA  LEU B  75       0.014  68.078  40.983  1.00 41.28           C  
ATOM   1600  C   LEU B  75      -0.444  66.755  40.420  1.00 40.86           C  
ATOM   1601  O   LEU B  75       0.370  65.962  39.942  1.00 41.80           O  
ATOM   1602  CB  LEU B  75       0.122  68.030  42.504  1.00 42.81           C  
ATOM   1603  CG  LEU B  75       0.770  66.800  43.137  1.00 42.43           C  
ATOM   1604  CD1 LEU B  75       2.211  66.642  42.666  1.00 46.27           C  
ATOM   1605  CD2 LEU B  75       0.686  66.913  44.631  1.00 46.23           C  
ATOM   1606  N   ALA B  76      -1.751  66.491  40.458  1.00 43.01           N  
ATOM   1607  CA  ALA B  76      -2.258  65.248  39.883  1.00 43.05           C  
ATOM   1608  C   ALA B  76      -2.003  65.179  38.373  1.00 44.05           C  
ATOM   1609  O   ALA B  76      -1.639  64.129  37.847  1.00 42.31           O  
ATOM   1610  CB  ALA B  76      -3.724  65.088  40.166  1.00 41.44           C  
ATOM   1611  N   VAL B  77      -2.206  66.306  37.676  1.00 44.85           N  
ATOM   1612  CA  VAL B  77      -1.960  66.364  36.236  1.00 42.00           C  
ATOM   1613  C   VAL B  77      -0.501  66.130  35.954  1.00 39.73           C  
ATOM   1614  O   VAL B  77      -0.152  65.336  35.084  1.00 40.94           O  
ATOM   1615  CB  VAL B  77      -2.460  67.677  35.603  1.00 42.67           C  
ATOM   1616  CG1 VAL B  77      -2.165  67.710  34.113  1.00 43.92           C  
ATOM   1617  CG2 VAL B  77      -3.952  67.763  35.790  1.00 40.49           C  
ATOM   1618  N   SER B  78       0.373  66.787  36.731  1.00 39.59           N  
ATOM   1619  CA  SER B  78       1.802  66.657  36.518  1.00 39.31           C  
ATOM   1620  C   SER B  78       2.226  65.197  36.624  1.00 40.58           C  
ATOM   1621  O   SER B  78       3.110  64.735  35.895  1.00 41.11           O  
ATOM   1622  CB  SER B  78       2.543  67.571  37.502  1.00 39.16           C  
ATOM   1623  OG  SER B  78       2.150  68.939  37.275  1.00 36.60           O  
ATOM   1624  N   THR B  79       1.579  64.479  37.537  1.00 41.26           N  
ATOM   1625  CA  THR B  79       1.893  63.085  37.811  1.00 42.20           C  
ATOM   1626  C   THR B  79       1.469  62.217  36.675  1.00 40.13           C  
ATOM   1627  O   THR B  79       2.233  61.359  36.244  1.00 40.23           O  
ATOM   1628  CB  THR B  79       1.206  62.582  39.113  1.00 43.26           C  
ATOM   1629  OG1 THR B  79       1.761  63.268  40.220  1.00 43.75           O  
ATOM   1630  CG2 THR B  79       1.405  61.073  39.319  1.00 48.38           C  
ATOM   1631  N   ALA B  80       0.248  62.445  36.176  1.00 40.95           N  
ATOM   1632  CA  ALA B  80      -0.296  61.631  35.119  1.00 42.08           C  
ATOM   1633  C   ALA B  80       0.493  61.868  33.832  1.00 45.75           C  
ATOM   1634  O   ALA B  80       0.627  60.956  33.019  1.00 46.36           O  
ATOM   1635  CB  ALA B  80      -1.798  61.959  34.900  1.00 40.78           C  
ATOM   1636  N   ASN B  81       1.027  63.085  33.667  1.00 45.01           N  
ATOM   1637  CA  ASN B  81       1.934  63.415  32.550  1.00 44.99           C  
ATOM   1638  C   ASN B  81       3.394  62.968  32.757  1.00 45.94           C  
ATOM   1639  O   ASN B  81       4.257  63.230  31.914  1.00 48.33           O  
ATOM   1640  CB  ASN B  81       1.841  64.930  32.253  1.00 44.53           C  
ATOM   1641  CG  ASN B  81       0.480  65.318  31.688  1.00 48.03           C  
ATOM   1642  OD1 ASN B  81      -0.154  64.496  31.055  1.00 57.18           O  
ATOM   1643  ND2 ASN B  81       0.035  66.563  31.910  1.00 44.06           N  
ATOM   1644  N   SER B  82       3.638  62.256  33.859  0.50 43.72           N  
ATOM   1646  CA  SER B  82       4.973  61.778  34.322  0.50 44.45           C  
ATOM   1648  C   SER B  82       6.143  62.780  34.256  0.50 43.72           C  
ATOM   1650  O   SER B  82       7.292  62.407  33.960  0.50 44.38           O  
ATOM   1652  CB  SER B  82       5.359  60.437  33.671  0.50 45.13           C  
ATOM   1654  OG  SER B  82       6.344  59.761  34.457  0.50 47.78           O  
ATOM   1656  N   CYS B  83       5.860  64.032  34.608  1.00 41.95           N  
ATOM   1657  CA  CYS B  83       6.885  65.074  34.673  1.00 39.58           C  
ATOM   1658  C   CYS B  83       7.478  65.071  36.075  1.00 37.49           C  
ATOM   1659  O   CYS B  83       6.839  65.531  37.031  1.00 37.02           O  
ATOM   1660  CB  CYS B  83       6.272  66.455  34.377  1.00 39.10           C  
ATOM   1661  SG  CYS B  83       7.485  67.772  34.572  1.00 41.49           S  
ATOM   1662  N   SER B  84       8.712  64.593  36.203  1.00 39.51           N  
ATOM   1663  CA  SER B  84       9.362  64.459  37.512  0.50 39.70           C  
ATOM   1665  C   SER B  84       9.600  65.786  38.214  1.00 40.98           C  
ATOM   1666  O   SER B  84       9.339  65.919  39.423  1.00 39.04           O  
ATOM   1667  CB  SER B  84      10.712  63.768  37.390  0.50 40.04           C  
ATOM   1669  OG  SER B  84      11.539  64.136  38.482  0.50 42.51           O  
ATOM   1671  N   TYR B  85      10.120  66.760  37.468  1.00 37.80           N  
ATOM   1672  CA  TYR B  85      10.338  68.087  38.022  1.00 39.02           C  
ATOM   1673  C   TYR B  85       9.008  68.665  38.517  1.00 39.15           C  
ATOM   1674  O   TYR B  85       8.930  69.238  39.587  1.00 41.99           O  
ATOM   1675  CB  TYR B  85      10.981  69.012  36.963  1.00 38.66           C  
ATOM   1676  CG  TYR B  85      11.173  70.413  37.449  1.00 36.39           C  
ATOM   1677  CD1 TYR B  85      10.141  71.358  37.369  1.00 37.97           C  
ATOM   1678  CD2 TYR B  85      12.358  70.789  38.048  1.00 38.44           C  
ATOM   1679  CE1 TYR B  85      10.317  72.634  37.847  1.00 36.64           C  
ATOM   1680  CE2 TYR B  85      12.538  72.066  38.533  1.00 32.45           C  
ATOM   1681  CZ  TYR B  85      11.530  72.985  38.429  1.00 37.62           C  
ATOM   1682  OH  TYR B  85      11.708  74.249  38.929  1.00 39.62           O  
ATOM   1683  N   CYS B  86       7.955  68.490  37.733  1.00 38.12           N  
ATOM   1684  CA  CYS B  86       6.654  69.055  38.068  1.00 38.58           C  
ATOM   1685  C   CYS B  86       6.039  68.411  39.302  1.00 37.83           C  
ATOM   1686  O   CYS B  86       5.308  69.066  40.055  1.00 36.48           O  
ATOM   1687  CB  CYS B  86       5.715  68.916  36.872  1.00 40.35           C  
ATOM   1688  SG  CYS B  86       6.458  69.441  35.299  1.00 45.70           S  
ATOM   1689  N   ALA B  87       6.321  67.128  39.515  1.00 38.54           N  
ATOM   1690  CA  ALA B  87       5.884  66.452  40.741  1.00 39.19           C  
ATOM   1691  C   ALA B  87       6.517  67.113  41.978  1.00 38.42           C  
ATOM   1692  O   ALA B  87       5.849  67.363  42.969  1.00 37.19           O  
ATOM   1693  CB  ALA B  87       6.238  64.974  40.688  1.00 38.11           C  
ATOM   1694  N   HIS B  88       7.817  67.377  41.906  1.00 38.08           N  
ATOM   1695  CA  HIS B  88       8.499  68.109  42.956  1.00 38.26           C  
ATOM   1696  C   HIS B  88       7.990  69.536  43.184  1.00 37.86           C  
ATOM   1697  O   HIS B  88       7.591  69.895  44.303  1.00 34.36           O  
ATOM   1698  CB  HIS B  88       9.983  68.199  42.674  1.00 39.86           C  
ATOM   1699  CG  HIS B  88      10.731  66.950  42.965  1.00 38.25           C  
ATOM   1700  ND1 HIS B  88      11.132  66.611  44.235  1.00 40.76           N  
ATOM   1701  CD2 HIS B  88      11.174  65.962  42.148  1.00 42.98           C  
ATOM   1702  CE1 HIS B  88      11.789  65.468  44.192  1.00 41.82           C  
ATOM   1703  NE2 HIS B  88      11.833  65.058  42.938  1.00 39.13           N  
ATOM   1704  N   SER B  89       8.008  70.352  42.139  1.00 38.45           N  
ATOM   1705  CA  SER B  89       7.628  71.750  42.300  1.00 38.17           C  
ATOM   1706  C   SER B  89       6.202  71.911  42.777  1.00 39.72           C  
ATOM   1707  O   SER B  89       5.937  72.746  43.643  1.00 41.16           O  
ATOM   1708  CB  SER B  89       7.863  72.575  41.032  1.00 40.34           C  
ATOM   1709  OG  SER B  89       6.968  72.214  39.987  1.00 43.02           O  
ATOM   1710  N   HIS B  90       5.264  71.146  42.230  1.00 38.67           N  
ATOM   1711  CA  HIS B  90       3.874  71.314  42.667  1.00 38.78           C  
ATOM   1712  C   HIS B  90       3.521  70.634  43.976  1.00 37.52           C  
ATOM   1713  O   HIS B  90       2.510  70.985  44.608  1.00 36.84           O  
ATOM   1714  CB  HIS B  90       2.918  70.957  41.553  1.00 39.09           C  
ATOM   1715  CG  HIS B  90       3.056  71.878  40.395  1.00 39.74           C  
ATOM   1716  ND1 HIS B  90       2.457  73.114  40.379  1.00 40.28           N  
ATOM   1717  CD2 HIS B  90       3.811  71.806  39.275  1.00 43.05           C  
ATOM   1718  CE1 HIS B  90       2.808  73.752  39.277  1.00 46.63           C  
ATOM   1719  NE2 HIS B  90       3.604  72.971  38.574  1.00 40.76           N  
ATOM   1720  N   THR B  91       4.363  69.704  44.419  1.00 36.66           N  
ATOM   1721  CA  THR B  91       4.193  69.164  45.776  1.00 37.29           C  
ATOM   1722  C   THR B  91       4.685  70.247  46.774  1.00 39.51           C  
ATOM   1723  O   THR B  91       4.077  70.478  47.825  1.00 38.74           O  
ATOM   1724  CB  THR B  91       4.915  67.797  45.950  1.00 38.36           C  
ATOM   1725  OG1 THR B  91       4.376  66.835  45.010  1.00 33.32           O  
ATOM   1726  CG2 THR B  91       4.732  67.295  47.324  1.00 35.61           C  
ATOM   1727  N   ALA B  92       5.768  70.932  46.418  1.00 37.60           N  
ATOM   1728  CA  ALA B  92       6.288  71.985  47.269  1.00 39.27           C  
ATOM   1729  C   ALA B  92       5.281  73.130  47.339  1.00 41.04           C  
ATOM   1730  O   ALA B  92       5.011  73.650  48.417  1.00 42.62           O  
ATOM   1731  CB  ALA B  92       7.628  72.479  46.763  1.00 39.12           C  
ATOM   1732  N   ALA B  93       4.712  73.493  46.194  1.00 42.02           N  
ATOM   1733  CA  ALA B  93       3.720  74.553  46.112  1.00 41.11           C  
ATOM   1734  C   ALA B  93       2.440  74.212  46.858  1.00 43.29           C  
ATOM   1735  O   ALA B  93       1.854  75.073  47.502  1.00 44.26           O  
ATOM   1736  CB  ALA B  93       3.409  74.853  44.657  1.00 41.05           C  
ATOM   1737  N   ALA B  94       1.977  72.968  46.743  1.00 43.00           N  
ATOM   1738  CA  ALA B  94       0.816  72.500  47.517  1.00 42.35           C  
ATOM   1739  C   ALA B  94       1.080  72.615  49.022  1.00 42.66           C  
ATOM   1740  O   ALA B  94       0.212  73.076  49.770  1.00 43.22           O  
ATOM   1741  CB  ALA B  94       0.453  71.058  47.136  1.00 42.01           C  
ATOM   1742  N   ARG B  95       2.278  72.209  49.459  1.00 39.29           N  
ATOM   1743  CA  ARG B  95       2.652  72.296  50.878  1.00 40.95           C  
ATOM   1744  C   ARG B  95       2.659  73.735  51.351  1.00 40.76           C  
ATOM   1745  O   ARG B  95       2.175  74.035  52.437  1.00 37.68           O  
ATOM   1746  CB  ARG B  95       4.026  71.672  51.136  1.00 40.05           C  
ATOM   1747  CG  ARG B  95       4.008  70.162  51.089  1.00 43.31           C  
ATOM   1748  CD  ARG B  95       5.251  69.579  51.700  1.00 48.02           C  
ATOM   1749  NE  ARG B  95       5.162  68.124  51.662  1.00 57.13           N  
ATOM   1750  CZ  ARG B  95       5.966  67.300  50.981  1.00 53.76           C  
ATOM   1751  NH1 ARG B  95       6.999  67.748  50.279  1.00 53.26           N  
ATOM   1752  NH2 ARG B  95       5.741  65.995  51.044  1.00 50.06           N  
ATOM   1753  N   ALA B  96       3.215  74.613  50.517  1.00 40.51           N  
ATOM   1754  CA  ALA B  96       3.259  76.027  50.812  1.00 40.17           C  
ATOM   1755  C   ALA B  96       1.833  76.566  50.892  1.00 40.98           C  
ATOM   1756  O   ALA B  96       1.546  77.399  51.728  1.00 41.95           O  
ATOM   1757  CB  ALA B  96       4.078  76.768  49.774  1.00 39.42           C  
ATOM   1758  N   LYS B  97       0.910  76.061  50.087  1.00 40.00           N  
ATOM   1759  CA  LYS B  97      -0.461  76.532  50.210  1.00 40.22           C  
ATOM   1760  C   LYS B  97      -1.296  75.816  51.295  1.00 40.64           C  
ATOM   1761  O   LYS B  97      -2.525  75.927  51.313  1.00 45.43           O  
ATOM   1762  CB  LYS B  97      -1.123  76.589  48.814  1.00 42.74           C  
ATOM   1763  CG  LYS B  97      -0.499  77.731  47.927  1.00 45.64           C  
ATOM   1764  CD  LYS B  97      -0.764  77.562  46.412  1.00 55.97           C  
ATOM   1765  CE  LYS B  97       0.338  78.204  45.488  1.00 58.84           C  
ATOM   1766  NZ  LYS B  97       0.066  78.067  43.972  1.00 47.59           N  
ATOM   1767  N   GLY B  98      -0.640  75.114  52.219  1.00 37.15           N  
ATOM   1768  CA  GLY B  98      -1.314  74.505  53.374  1.00 37.48           C  
ATOM   1769  C   GLY B  98      -1.640  73.014  53.333  1.00 37.85           C  
ATOM   1770  O   GLY B  98      -2.264  72.490  54.260  1.00 35.52           O  
HETATM 1771  N   MSE B  99      -1.224  72.307  52.279  1.00 38.20           N  
HETATM 1772  CA  MSE B  99      -1.498  70.867  52.197  1.00 37.69           C  
HETATM 1773  C   MSE B  99      -0.919  70.145  53.406  1.00 37.40           C  
HETATM 1774  O   MSE B  99       0.267  70.275  53.716  1.00 38.07           O  
HETATM 1775  CB  MSE B  99      -0.933  70.265  50.912  1.00 39.08           C  
HETATM 1776  CG  MSE B  99      -1.408  68.834  50.686  1.00 35.01           C  
HETATM 1777 SE   MSE B  99      -0.853  68.120  49.030  0.75 32.99          SE  
HETATM 1778  CE  MSE B  99       1.051  68.217  49.518  1.00 28.42           C  
ATOM   1779  N   THR B 100      -1.802  69.452  54.117  1.00 38.35           N  
ATOM   1780  CA  THR B 100      -1.467  68.614  55.253  1.00 36.72           C  
ATOM   1781  C   THR B 100      -1.019  67.224  54.770  1.00 37.92           C  
ATOM   1782  O   THR B 100      -1.296  66.833  53.623  1.00 38.49           O  
ATOM   1783  CB  THR B 100      -2.680  68.442  56.193  1.00 35.84           C  
ATOM   1784  OG1 THR B 100      -3.734  67.742  55.517  1.00 39.02           O  
ATOM   1785  CG2 THR B 100      -3.189  69.798  56.703  1.00 38.39           C  
ATOM   1786  N   PRO B 101      -0.296  66.481  55.631  1.00 38.69           N  
ATOM   1787  CA  PRO B 101      -0.024  65.058  55.386  1.00 38.37           C  
ATOM   1788  C   PRO B 101      -1.254  64.247  55.014  1.00 39.14           C  
ATOM   1789  O   PRO B 101      -1.218  63.472  54.050  1.00 38.83           O  
ATOM   1790  CB  PRO B 101       0.540  64.581  56.720  1.00 36.65           C  
ATOM   1791  CG  PRO B 101       1.232  65.769  57.251  1.00 40.40           C  
ATOM   1792  CD  PRO B 101       0.380  66.955  56.847  1.00 37.87           C  
ATOM   1793  N   ALA B 102      -2.326  64.406  55.789  1.00 38.63           N  
ATOM   1794  CA  ALA B 102      -3.593  63.738  55.496  1.00 37.82           C  
ATOM   1795  C   ALA B 102      -4.114  64.063  54.076  1.00 37.79           C  
ATOM   1796  O   ALA B 102      -4.555  63.173  53.339  1.00 37.38           O  
ATOM   1797  CB  ALA B 102      -4.602  64.142  56.514  1.00 37.40           C  
ATOM   1798  N   GLN B 103      -4.068  65.343  53.708  1.00 36.40           N  
ATOM   1799  CA  GLN B 103      -4.540  65.773  52.398  1.00 35.64           C  
ATOM   1800  C   GLN B 103      -3.652  65.210  51.291  1.00 34.98           C  
ATOM   1801  O   GLN B 103      -4.150  64.726  50.290  1.00 33.77           O  
ATOM   1802  CB  GLN B 103      -4.594  67.301  52.306  1.00 37.35           C  
ATOM   1803  CG  GLN B 103      -5.731  67.928  53.117  1.00 37.69           C  
ATOM   1804  CD  GLN B 103      -5.632  69.435  53.168  1.00 39.24           C  
ATOM   1805  OE1 GLN B 103      -4.547  70.000  53.270  1.00 39.50           O  
ATOM   1806  NE2 GLN B 103      -6.775  70.097  53.102  1.00 41.81           N  
ATOM   1807  N   HIS B 104      -2.342  65.258  51.503  1.00 36.10           N  
ATOM   1808  CA  HIS B 104      -1.374  64.701  50.556  1.00 35.00           C  
ATOM   1809  C   HIS B 104      -1.617  63.222  50.297  1.00 33.66           C  
ATOM   1810  O   HIS B 104      -1.583  62.763  49.154  1.00 35.12           O  
ATOM   1811  CB  HIS B 104       0.056  64.919  51.098  1.00 36.96           C  
ATOM   1812  CG  HIS B 104       1.126  64.703  50.072  1.00 36.18           C  
ATOM   1813  ND1 HIS B 104       2.459  64.640  50.394  1.00 38.58           N  
ATOM   1814  CD2 HIS B 104       1.057  64.541  48.728  1.00 39.25           C  
ATOM   1815  CE1 HIS B 104       3.169  64.464  49.293  1.00 40.79           C  
ATOM   1816  NE2 HIS B 104       2.344  64.400  48.265  1.00 34.40           N  
ATOM   1817  N   ALA B 105      -1.883  62.481  51.366  1.00 36.00           N  
ATOM   1818  CA  ALA B 105      -2.080  61.047  51.284  1.00 35.60           C  
ATOM   1819  C   ALA B 105      -3.320  60.751  50.446  1.00 37.10           C  
ATOM   1820  O   ALA B 105      -3.320  59.847  49.603  1.00 37.33           O  
ATOM   1821  CB  ALA B 105      -2.206  60.468  52.651  1.00 35.80           C  
ATOM   1822  N   GLU B 106      -4.370  61.541  50.657  1.00 38.01           N  
ATOM   1823  CA  GLU B 106      -5.609  61.405  49.890  1.00 39.33           C  
ATOM   1824  C   GLU B 106      -5.414  61.760  48.412  1.00 38.27           C  
ATOM   1825  O   GLU B 106      -5.902  61.052  47.543  1.00 39.70           O  
ATOM   1826  CB  GLU B 106      -6.735  62.233  50.549  1.00 39.76           C  
ATOM   1827  CG  GLU B 106      -8.049  62.301  49.775  1.00 48.00           C  
ATOM   1828  CD  GLU B 106      -8.817  60.989  49.736  1.00 55.57           C  
ATOM   1829  OE1 GLU B 106      -8.432  60.019  50.422  1.00 57.47           O  
ATOM   1830  OE2 GLU B 106      -9.827  60.920  48.999  1.00 61.40           O  
ATOM   1831  N   VAL B 107      -4.664  62.822  48.122  1.00 38.09           N  
ATOM   1832  CA  VAL B 107      -4.353  63.186  46.722  1.00 37.32           C  
ATOM   1833  C   VAL B 107      -3.657  62.020  46.025  1.00 36.83           C  
ATOM   1834  O   VAL B 107      -4.029  61.624  44.922  1.00 36.93           O  
ATOM   1835  CB  VAL B 107      -3.465  64.459  46.624  1.00 35.79           C  
ATOM   1836  CG1 VAL B 107      -3.025  64.691  45.188  1.00 41.51           C  
ATOM   1837  CG2 VAL B 107      -4.195  65.676  47.142  1.00 34.84           C  
ATOM   1838  N   LEU B 108      -2.675  61.443  46.705  1.00 36.47           N  
ATOM   1839  CA  LEU B 108      -1.967  60.275  46.175  1.00 37.84           C  
ATOM   1840  C   LEU B 108      -2.888  59.115  45.924  1.00 38.88           C  
ATOM   1841  O   LEU B 108      -2.860  58.488  44.842  1.00 36.62           O  
ATOM   1842  CB  LEU B 108      -0.851  59.841  47.131  1.00 40.51           C  
ATOM   1843  CG  LEU B 108       0.382  60.750  47.180  1.00 38.76           C  
ATOM   1844  CD1 LEU B 108       1.387  60.251  48.198  1.00 42.65           C  
ATOM   1845  CD2 LEU B 108       1.065  60.832  45.900  1.00 42.03           C  
ATOM   1846  N   ALA B 109      -3.714  58.836  46.919  1.00 38.38           N  
ATOM   1847  CA  ALA B 109      -4.697  57.766  46.807  1.00 39.34           C  
ATOM   1848  C   ALA B 109      -5.604  57.915  45.581  1.00 37.61           C  
ATOM   1849  O   ALA B 109      -5.896  56.931  44.884  1.00 38.73           O  
ATOM   1850  CB  ALA B 109      -5.542  57.673  48.112  1.00 39.34           C  
ATOM   1851  N   ILE B 110      -6.054  59.137  45.326  1.00 37.89           N  
ATOM   1852  CA  ILE B 110      -6.908  59.404  44.180  1.00 39.16           C  
ATOM   1853  C   ILE B 110      -6.128  59.225  42.883  1.00 38.95           C  
ATOM   1854  O   ILE B 110      -6.640  58.659  41.929  1.00 38.61           O  
ATOM   1855  CB  ILE B 110      -7.478  60.817  44.243  1.00 42.00           C  
ATOM   1856  CG1 ILE B 110      -8.416  60.948  45.447  1.00 42.96           C  
ATOM   1857  CG2 ILE B 110      -8.222  61.161  42.947  1.00 38.71           C  
ATOM   1858  CD1 ILE B 110      -8.779  62.361  45.761  1.00 46.11           C  
ATOM   1859  N   ILE B 111      -4.893  59.716  42.850  1.00 39.18           N  
ATOM   1860  CA  ILE B 111      -4.066  59.626  41.651  1.00 40.38           C  
ATOM   1861  C   ILE B 111      -3.843  58.138  41.325  1.00 40.52           C  
ATOM   1862  O   ILE B 111      -4.061  57.713  40.194  1.00 41.37           O  
ATOM   1863  CB  ILE B 111      -2.729  60.360  41.835  1.00 39.59           C  
ATOM   1864  CG1 ILE B 111      -2.926  61.888  41.902  1.00 37.96           C  
ATOM   1865  CG2 ILE B 111      -1.765  59.997  40.734  1.00 45.79           C  
ATOM   1866  CD1 ILE B 111      -1.694  62.620  42.535  1.00 46.27           C  
ATOM   1867  N   GLY B 112      -3.480  57.335  42.324  1.00 41.23           N  
ATOM   1868  CA  GLY B 112      -3.332  55.881  42.115  1.00 39.71           C  
ATOM   1869  C   GLY B 112      -4.601  55.175  41.641  1.00 40.72           C  
ATOM   1870  O   GLY B 112      -4.574  54.378  40.693  1.00 43.10           O  
ATOM   1871  N   LEU B 113      -5.717  55.457  42.297  1.00 40.51           N  
ATOM   1872  CA  LEU B 113      -6.988  54.826  41.957  1.00 40.53           C  
ATOM   1873  C   LEU B 113      -7.432  55.214  40.572  1.00 41.13           C  
ATOM   1874  O   LEU B 113      -7.831  54.353  39.782  1.00 43.14           O  
ATOM   1875  CB  LEU B 113      -8.046  55.206  42.973  1.00 38.42           C  
ATOM   1876  CG  LEU B 113      -9.452  54.640  42.787  1.00 42.95           C  
ATOM   1877  CD1 LEU B 113      -9.416  53.124  42.646  1.00 44.53           C  
ATOM   1878  CD2 LEU B 113     -10.312  55.081  43.967  1.00 45.83           C  
ATOM   1879  N   ALA B 114      -7.355  56.505  40.257  1.00 41.15           N  
ATOM   1880  CA  ALA B 114      -7.729  56.981  38.944  1.00 40.29           C  
ATOM   1881  C   ALA B 114      -6.879  56.354  37.862  1.00 38.73           C  
ATOM   1882  O   ALA B 114      -7.378  55.995  36.838  1.00 43.05           O  
ATOM   1883  CB  ALA B 114      -7.634  58.515  38.875  1.00 42.18           C  
ATOM   1884  N   ALA B 115      -5.579  56.214  38.090  1.00 40.27           N  
ATOM   1885  CA  ALA B 115      -4.706  55.616  37.086  1.00 38.24           C  
ATOM   1886  C   ALA B 115      -5.163  54.175  36.836  1.00 39.36           C  
ATOM   1887  O   ALA B 115      -5.198  53.711  35.658  1.00 40.98           O  
ATOM   1888  CB  ALA B 115      -3.251  55.666  37.564  1.00 38.88           C  
ATOM   1889  N   GLN B 116      -5.537  53.478  37.924  1.00 36.11           N  
ATOM   1890  CA  GLN B 116      -6.021  52.109  37.845  1.00 35.90           C  
ATOM   1891  C   GLN B 116      -7.317  51.991  37.031  1.00 36.01           C  
ATOM   1892  O   GLN B 116      -7.406  51.184  36.110  1.00 34.77           O  
ATOM   1893  CB  GLN B 116      -6.284  51.573  39.238  1.00 38.84           C  
ATOM   1894  CG  GLN B 116      -6.758  50.118  39.293  1.00 41.99           C  
ATOM   1895  CD  GLN B 116      -6.521  49.496  40.671  1.00 43.32           C  
ATOM   1896  OE1 GLN B 116      -7.423  49.404  41.503  1.00 46.22           O  
ATOM   1897  NE2 GLN B 116      -5.309  49.096  40.916  1.00 44.87           N  
ATOM   1898  N   THR B 117      -8.327  52.748  37.416  1.00 38.96           N  
ATOM   1899  CA  THR B 117      -9.613  52.638  36.721  1.00 41.20           C  
ATOM   1900  C   THR B 117      -9.513  53.125  35.288  1.00 39.33           C  
ATOM   1901  O   THR B 117     -10.231  52.614  34.379  1.00 39.78           O  
ATOM   1902  CB  THR B 117     -10.778  53.312  37.488  1.00 41.31           C  
ATOM   1903  OG1 THR B 117     -10.581  54.724  37.599  1.00 43.37           O  
ATOM   1904  CG2 THR B 117     -10.909  52.719  38.866  1.00 46.07           C  
ATOM   1905  N   ASN B 118      -8.672  54.134  35.056  1.00 39.55           N  
ATOM   1906  CA  ASN B 118      -8.486  54.617  33.679  1.00 39.72           C  
ATOM   1907  C   ASN B 118      -7.925  53.478  32.792  1.00 39.26           C  
ATOM   1908  O   ASN B 118      -8.396  53.241  31.669  1.00 36.46           O  
ATOM   1909  CB  ASN B 118      -7.551  55.819  33.572  1.00 40.98           C  
ATOM   1910  CG  ASN B 118      -8.062  57.105  34.255  1.00 42.43           C  
ATOM   1911  OD1 ASN B 118      -7.278  58.033  34.404  1.00 41.07           O  
ATOM   1912  ND2 ASN B 118      -9.329  57.173  34.650  1.00 37.14           N  
ATOM   1913  N   ALA B 119      -6.906  52.794  33.307  1.00 37.98           N  
ATOM   1914  CA  ALA B 119      -6.263  51.662  32.609  1.00 39.06           C  
ATOM   1915  C   ALA B 119      -7.226  50.492  32.332  1.00 39.93           C  
ATOM   1916  O   ALA B 119      -7.295  49.963  31.202  1.00 39.63           O  
ATOM   1917  CB  ALA B 119      -5.039  51.195  33.423  1.00 39.50           C  
ATOM   1918  N   LEU B 120      -8.008  50.135  33.359  1.00 41.66           N  
ATOM   1919  CA  LEU B 120      -9.041  49.102  33.255  1.00 40.76           C  
ATOM   1920  C   LEU B 120     -10.103  49.452  32.231  1.00 39.83           C  
ATOM   1921  O   LEU B 120     -10.424  48.632  31.377  1.00 39.37           O  
ATOM   1922  CB  LEU B 120      -9.682  48.845  34.615  1.00 44.32           C  
ATOM   1923  CG  LEU B 120      -8.779  48.197  35.664  1.00 37.92           C  
ATOM   1924  CD1 LEU B 120      -9.400  48.206  37.050  1.00 40.17           C  
ATOM   1925  CD2 LEU B 120      -8.400  46.773  35.233  1.00 43.91           C  
ATOM   1926  N   VAL B 121     -10.620  50.682  32.282  1.00 39.23           N  
ATOM   1927  CA  VAL B 121     -11.592  51.137  31.287  1.00 40.58           C  
ATOM   1928  C   VAL B 121     -11.000  51.049  29.865  1.00 39.52           C  
ATOM   1929  O   VAL B 121     -11.660  50.629  28.936  1.00 39.27           O  
ATOM   1930  CB  VAL B 121     -12.049  52.562  31.591  1.00 41.86           C  
ATOM   1931  CG1 VAL B 121     -12.851  53.140  30.422  1.00 40.37           C  
ATOM   1932  CG2 VAL B 121     -12.872  52.578  32.869  1.00 40.70           C  
ATOM   1933  N   THR B 122      -9.741  51.411  29.724  1.00 38.98           N  
ATOM   1934  CA  THR B 122      -9.110  51.435  28.418  1.00 39.52           C  
ATOM   1935  C   THR B 122      -8.920  50.028  27.906  1.00 39.98           C  
ATOM   1936  O   THR B 122      -9.152  49.759  26.738  1.00 43.17           O  
ATOM   1937  CB  THR B 122      -7.773  52.205  28.503  1.00 39.77           C  
ATOM   1938  OG1 THR B 122      -8.072  53.547  28.863  1.00 39.84           O  
ATOM   1939  CG2 THR B 122      -7.048  52.210  27.217  1.00 40.94           C  
ATOM   1940  N   ALA B 123      -8.529  49.117  28.784  1.00 39.93           N  
ATOM   1941  CA  ALA B 123      -8.356  47.731  28.377  1.00 39.87           C  
ATOM   1942  C   ALA B 123      -9.695  47.076  27.996  1.00 43.37           C  
ATOM   1943  O   ALA B 123      -9.744  46.228  27.092  1.00 43.05           O  
ATOM   1944  CB  ALA B 123      -7.693  46.961  29.474  1.00 41.12           C  
HETATM 1945  N   MSE B 124     -10.772  47.465  28.683  1.00 40.73           N  
HETATM 1946  CA  MSE B 124     -12.116  46.919  28.430  1.00 41.59           C  
HETATM 1947  C   MSE B 124     -12.874  47.631  27.301  1.00 39.31           C  
HETATM 1948  O   MSE B 124     -13.907  47.131  26.827  1.00 42.41           O  
HETATM 1949  CB  MSE B 124     -12.951  46.960  29.721  1.00 42.64           C  
HETATM 1950  CG  MSE B 124     -12.432  46.007  30.784  1.00 41.80           C  
HETATM 1951 SE   MSE B 124     -13.513  45.915  32.361  0.75 37.23          SE  
HETATM 1952  CE  MSE B 124     -13.305  47.709  33.001  1.00 39.63           C  
ATOM   1953  N   GLN B 125     -12.374  48.794  26.897  1.00 37.97           N  
ATOM   1954  CA  GLN B 125     -12.993  49.635  25.901  1.00 39.37           C  
ATOM   1955  C   GLN B 125     -14.473  49.874  26.224  1.00 38.44           C  
ATOM   1956  O   GLN B 125     -15.343  49.772  25.350  1.00 37.27           O  
ATOM   1957  CB  GLN B 125     -12.811  49.016  24.506  1.00 42.17           C  
ATOM   1958  CG  GLN B 125     -11.403  49.108  23.991  1.00 42.06           C  
ATOM   1959  CD  GLN B 125     -11.039  50.518  23.694  1.00 41.90           C  
ATOM   1960  OE1 GLN B 125     -11.606  51.119  22.785  1.00 48.29           O  
ATOM   1961  NE2 GLN B 125     -10.108  51.075  24.459  1.00 38.95           N  
ATOM   1962  N   ILE B 126     -14.732  50.210  27.488  1.00 38.75           N  
ATOM   1963  CA  ILE B 126     -16.082  50.456  27.973  1.00 37.52           C  
ATOM   1964  C   ILE B 126     -16.663  51.590  27.147  1.00 38.27           C  
ATOM   1965  O   ILE B 126     -16.060  52.659  27.081  1.00 35.93           O  
ATOM   1966  CB  ILE B 126     -16.141  50.908  29.482  1.00 37.55           C  
ATOM   1967  CG1 ILE B 126     -15.441  49.916  30.420  1.00 37.29           C  
ATOM   1968  CG2 ILE B 126     -17.615  51.082  29.910  1.00 37.54           C  
ATOM   1969  CD1 ILE B 126     -16.023  48.486  30.395  1.00 39.00           C  
ATOM   1970  N   PRO B 127     -17.824  51.365  26.511  1.00 34.29           N  
ATOM   1971  CA  PRO B 127     -18.505  52.444  25.823  1.00 36.67           C  
ATOM   1972  C   PRO B 127     -19.258  53.394  26.761  1.00 38.15           C  
ATOM   1973  O   PRO B 127     -19.784  52.959  27.796  1.00 36.32           O  
ATOM   1974  CB  PRO B 127     -19.515  51.708  24.944  1.00 35.80           C  
ATOM   1975  CG  PRO B 127     -19.823  50.502  25.710  1.00 38.63           C  
ATOM   1976  CD  PRO B 127     -18.579  50.102  26.405  1.00 36.73           C  
ATOM   1977  N   VAL B 128     -19.335  54.663  26.355  1.00 38.98           N  
ATOM   1978  CA  VAL B 128     -19.943  55.722  27.138  1.00 40.75           C  
ATOM   1979  C   VAL B 128     -21.427  55.435  27.324  1.00 38.62           C  
ATOM   1980  O   VAL B 128     -22.158  55.235  26.355  1.00 42.29           O  
ATOM   1981  CB  VAL B 128     -19.764  57.096  26.456  1.00 42.47           C  
ATOM   1982  CG1 VAL B 128     -20.413  58.221  27.279  1.00 45.77           C  
ATOM   1983  CG2 VAL B 128     -18.276  57.397  26.249  1.00 41.83           C  
ATOM   1984  N   ASP B 129     -21.852  55.407  28.586  1.00 38.48           N  
ATOM   1985  CA  ASP B 129     -23.247  55.210  28.936  1.00 38.94           C  
ATOM   1986  C   ASP B 129     -24.106  56.278  28.287  1.00 38.69           C  
ATOM   1987  O   ASP B 129     -23.759  57.454  28.281  1.00 39.63           O  
ATOM   1988  CB  ASP B 129     -23.454  55.295  30.447  1.00 39.92           C  
ATOM   1989  CG  ASP B 129     -22.623  54.293  31.210  1.00 37.95           C  
ATOM   1990  OD1 ASP B 129     -21.388  54.477  31.290  1.00 39.95           O  
ATOM   1991  OD2 ASP B 129     -23.202  53.335  31.746  1.00 36.43           O  
ATOM   1992  N   GLU B 130     -25.265  55.878  27.781  1.00 39.56           N  
ATOM   1993  CA  GLU B 130     -26.122  56.828  27.089  0.50 38.62           C  
ATOM   1995  C   GLU B 130     -26.600  57.907  28.074  1.00 39.08           C  
ATOM   1996  O   GLU B 130     -26.833  59.045  27.673  1.00 35.95           O  
ATOM   1997  CB  GLU B 130     -27.276  56.133  26.340  0.50 39.50           C  
ATOM   1999  CG  GLU B 130     -27.725  54.795  26.918  0.50 36.22           C  
ATOM   2001  CD  GLU B 130     -26.821  53.615  26.547  0.50 36.34           C  
ATOM   2003  OE1 GLU B 130     -27.058  53.016  25.479  0.50 28.46           O  
ATOM   2005  OE2 GLU B 130     -25.904  53.259  27.347  0.50 25.80           O  
ATOM   2007  N   ALA B 131     -26.692  57.549  29.356  1.00 41.27           N  
ATOM   2008  CA  ALA B 131     -27.082  58.485  30.408  1.00 41.93           C  
ATOM   2009  C   ALA B 131     -26.094  59.625  30.525  1.00 42.04           C  
ATOM   2010  O   ALA B 131     -26.485  60.731  30.882  1.00 43.85           O  
ATOM   2011  CB  ALA B 131     -27.221  57.767  31.747  1.00 42.35           C  
ATOM   2012  N   PHE B 132     -24.827  59.379  30.205  1.00 43.62           N  
ATOM   2013  CA  PHE B 132     -23.839  60.471  30.146  1.00 45.00           C  
ATOM   2014  C   PHE B 132     -24.039  61.419  28.943  1.00 46.62           C  
ATOM   2015  O   PHE B 132     -23.467  62.500  28.936  1.00 47.82           O  
ATOM   2016  CB  PHE B 132     -22.375  59.965  30.160  1.00 44.33           C  
ATOM   2017  CG  PHE B 132     -21.990  59.181  31.396  1.00 44.92           C  
ATOM   2018  CD1 PHE B 132     -22.509  59.493  32.647  1.00 45.79           C  
ATOM   2019  CD2 PHE B 132     -21.078  58.130  31.303  1.00 44.17           C  
ATOM   2020  CE1 PHE B 132     -22.144  58.761  33.783  1.00 38.97           C  
ATOM   2021  CE2 PHE B 132     -20.709  57.393  32.421  1.00 45.01           C  
ATOM   2022  CZ  PHE B 132     -21.247  57.699  33.663  1.00 44.01           C  
ATOM   2023  N   LEU B 133     -24.860  61.053  27.954  1.00 47.77           N  
ATOM   2024  CA  LEU B 133     -24.942  61.835  26.705  1.00 47.58           C  
ATOM   2025  C   LEU B 133     -26.196  62.688  26.590  1.00 49.62           C  
ATOM   2026  O   LEU B 133     -26.371  63.413  25.603  1.00 52.35           O  
ATOM   2027  CB  LEU B 133     -24.817  60.908  25.484  1.00 46.75           C  
ATOM   2028  CG  LEU B 133     -23.529  60.074  25.389  1.00 49.43           C  
ATOM   2029  CD1 LEU B 133     -23.627  59.064  24.256  1.00 50.89           C  
ATOM   2030  CD2 LEU B 133     -22.272  60.954  25.218  1.00 49.34           C  
ATOM   2031  N   VAL B 134     -27.072  62.618  27.587  1.00 50.19           N  
ATOM   2032  CA  VAL B 134     -28.264  63.459  27.582  1.00 51.17           C  
ATOM   2033  C   VAL B 134     -27.927  64.958  27.846  1.00 52.73           C  
ATOM   2034  O   VAL B 134     -27.118  65.282  28.724  1.00 52.55           O  
ATOM   2035  CB  VAL B 134     -29.325  62.910  28.559  1.00 49.99           C  
ATOM   2036  CG1 VAL B 134     -30.547  63.833  28.594  1.00 53.10           C  
ATOM   2037  CG2 VAL B 134     -29.713  61.489  28.152  1.00 45.78           C  
ATOM   2038  N   ASP B 135     -28.554  65.853  27.069  1.00 54.60           N  
ATOM   2039  CA  ASP B 135     -28.225  67.288  27.083  1.00 56.24           C  
ATOM   2040  C   ASP B 135     -28.709  67.964  28.365  1.00 57.97           C  
ATOM   2041  O   ASP B 135     -27.895  68.431  29.170  1.00 59.33           O  
ATOM   2042  CB  ASP B 135     -28.801  68.016  25.855  1.00 54.66           C  
TER    2043      ASP B 135                                                      
END
MOLECULE T0408.pdb
ATOM    769  N   PHE     7       8.970  79.991  40.219  1.00 59.01           N  
ATOM    770  CA  PHE     7       9.121  78.887  39.220  1.00 58.55           C  
ATOM    771  C   PHE     7      10.525  78.270  39.318  1.00 57.17           C  
ATOM    772  O   PHE     7      11.448  78.885  39.884  1.00 59.33           O  
ATOM    773  CB  PHE     7       8.894  79.403  37.792  1.00 59.50           C  
ATOM    774  CG  PHE     7       7.630  80.211  37.607  1.00 59.88           C  
ATOM    775  CD1 PHE     7       7.640  81.590  37.779  1.00 59.55           C  
ATOM    776  CD2 PHE     7       6.441  79.594  37.219  1.00 60.26           C  
ATOM    777  CE1 PHE     7       6.481  82.338  37.600  1.00 63.27           C  
ATOM    778  CE2 PHE     7       5.280  80.335  37.027  1.00 57.96           C  
ATOM    779  CZ  PHE     7       5.299  81.709  37.222  1.00 60.10           C  
ATOM    780  N   GLY     8      10.693  77.077  38.739  1.00 51.97           N  
ATOM    781  CA  GLY     8      11.946  76.308  38.864  1.00 47.06           C  
ATOM    782  C   GLY     8      13.010  76.644  37.842  1.00 42.74           C  
ATOM    783  O   GLY     8      12.960  77.691  37.199  1.00 40.60           O  
ATOM    784  N   GLU     9      13.969  75.734  37.690  1.00 39.01           N  
ATOM    785  CA  GLU     9      15.125  75.924  36.812  1.00 38.04           C  
ATOM    786  C   GLU     9      14.737  76.079  35.344  1.00 34.61           C  
ATOM    787  O   GLU     9      15.312  76.893  34.624  1.00 33.70           O  
ATOM    788  CB  GLU     9      16.093  74.746  36.964  1.00 38.65           C  
ATOM    789  N   GLY    10      13.750  75.287  34.915  1.00 34.19           N  
ATOM    790  CA  GLY    10      13.250  75.348  33.551  1.00 31.10           C  
ATOM    791  C   GLY    10      12.790  76.744  33.220  1.00 25.97           C  
ATOM    792  O   GLY    10      13.200  77.304  32.203  1.00 24.44           O  
ATOM    793  N   MET    11      11.958  77.314  34.091  1.00 26.78           N  
ATOM    794  CA  MET    11      11.453  78.679  33.871  1.00 26.99           C  
ATOM    795  C   MET    11      12.547  79.734  33.936  1.00 24.54           C  
ATOM    796  O   MET    11      12.436  80.750  33.237  1.00 22.59           O  
ATOM    797  CB  MET    11      10.298  79.036  34.809  1.00 26.96           C  
ATOM    798  CG  MET    11       8.956  78.424  34.384  1.00 30.81           C  
ATOM    799  SD  MET    11       8.363  79.163  32.682  0.75 32.36          SE  
ATOM    800  CE  MET    11       7.641  80.815  33.439  1.00 38.14           C  
ATOM    801  N   LYS    12      13.587  79.531  34.749  1.00 22.58           N  
ATOM    802  CA  LYS    12      14.709  80.488  34.749  1.00 22.98           C  
ATOM    803  C   LYS    12      15.471  80.468  33.411  1.00 20.97           C  
ATOM    804  O   LYS    12      15.931  81.507  32.944  1.00 22.83           O  
ATOM    805  CB  LYS    12      15.656  80.233  35.932  1.00 24.68           C  
ATOM    806  CG  LYS    12      14.987  80.568  37.290  1.00 26.05           C  
ATOM    807  CD  LYS    12      15.724  79.996  38.524  1.00 31.53           C  
ATOM    808  CE  LYS    12      17.178  80.177  38.487  1.00 33.33           C  
ATOM    809  NZ  LYS    12      17.857  79.899  39.811  1.00 35.75           N  
ATOM    810  N   VAL    13      15.558  79.292  32.784  1.00 23.05           N  
ATOM    811  CA  VAL    13      16.174  79.143  31.455  1.00 22.27           C  
ATOM    812  C   VAL    13      15.338  79.931  30.437  1.00 19.87           C  
ATOM    813  O   VAL    13      15.870  80.675  29.599  1.00 19.37           O  
ATOM    814  CB  VAL    13      16.227  77.631  31.026  1.00 24.12           C  
ATOM    815  CG1 VAL    13      16.716  77.489  29.584  1.00 25.29           C  
ATOM    816  CG2 VAL    13      17.136  76.836  31.979  1.00 30.23           C  
ATOM    817  N   VAL    14      14.032  79.817  30.576  1.00 20.72           N  
ATOM    818  CA  VAL    14      13.119  80.535  29.668  1.00 22.65           C  
ATOM    819  C   VAL    14      13.274  82.037  29.865  1.00 19.62           C  
ATOM    820  O   VAL    14      13.348  82.784  28.895  1.00 20.37           O  
ATOM    821  CB  VAL    14      11.657  80.121  29.823  1.00 21.69           C  
ATOM    822  CG1 VAL    14      10.788  80.938  28.849  1.00 21.74           C  
ATOM    823  CG2 VAL    14      11.465  78.585  29.542  1.00 26.25           C  
ATOM    824  N   LYS    15      13.332  82.483  31.131  1.00 21.22           N  
ATOM    825  CA  LYS    15      13.580  83.912  31.414  1.00 18.46           C  
ATOM    826  C   LYS    15      14.866  84.401  30.767  1.00 19.65           C  
ATOM    827  O   LYS    15      14.894  85.480  30.187  1.00 22.14           O  
ATOM    828  CB  LYS    15      13.617  84.181  32.921  1.00 18.27           C  
ATOM    829  N   GLU    16      15.918  83.608  30.857  1.00 21.08           N  
ATOM    830  CA  GLU    16      17.202  83.950  30.227  1.00 22.56           C  
ATOM    831  C   GLU    16      17.144  83.974  28.678  1.00 22.82           C  
ATOM    832  O   GLU    16      17.665  84.891  28.042  1.00 28.47           O  
ATOM    833  CB  GLU    16      18.277  82.981  30.693  1.00 24.31           C  
ATOM    834  N   LYS    17      16.521  82.963  28.097  1.00 21.86           N  
ATOM    835  CA  LYS    17      16.542  82.770  26.636  1.00 22.20           C  
ATOM    836  C   LYS    17      15.493  83.586  25.851  1.00 21.86           C  
ATOM    837  O   LYS    17      15.808  84.146  24.776  1.00 23.86           O  
ATOM    838  CB  LYS    17      16.365  81.277  26.315  1.00 21.29           C  
ATOM    839  N   TYR    18      14.290  83.672  26.407  1.00 22.99           N  
ATOM    840  CA  TYR    18      13.084  84.212  25.724  1.00 24.08           C  
ATOM    841  C   TYR    18      12.235  85.030  26.691  1.00 21.96           C  
ATOM    842  O   TYR    18      11.217  84.579  27.196  1.00 21.62           O  
ATOM    843  CB  TYR    18      12.270  83.071  25.102  1.00 23.86           C  
ATOM    844  CG  TYR    18      13.142  82.276  24.153  1.00 25.16           C  
ATOM    845  CD1 TYR    18      13.658  82.867  23.007  1.00 22.60           C  
ATOM    846  CD2 TYR    18      13.503  80.967  24.432  1.00 27.55           C  
ATOM    847  CE1 TYR    18      14.496  82.174  22.142  1.00 26.49           C  
ATOM    848  CE2 TYR    18      14.364  80.270  23.576  1.00 26.29           C  
ATOM    849  CZ  TYR    18      14.846  80.874  22.433  1.00 25.54           C  
ATOM    850  OH  TYR    18      15.686  80.188  21.581  1.00 26.16           O  
ATOM    851  N   PRO    19      12.703  86.256  26.994  1.00 22.95           N  
ATOM    852  CA  PRO    19      12.008  87.103  27.963  1.00 20.97           C  
ATOM    853  C   PRO    19      10.540  87.377  27.666  1.00 23.47           C  
ATOM    854  O   PRO    19       9.729  87.342  28.598  1.00 22.73           O  
ATOM    855  CB  PRO    19      12.823  88.395  27.933  1.00 22.49           C  
ATOM    856  CG  PRO    19      14.111  88.033  27.370  1.00 24.22           C  
ATOM    857  CD  PRO    19      13.956  86.869  26.528  1.00 23.77           C  
ATOM    858  N   ASP    20      10.175  87.629  26.413  1.00 23.93           N  
ATOM    859  CA  ASP    20       8.772  87.917  26.104  1.00 28.48           C  
ATOM    860  C   ASP    20       7.908  86.671  26.266  1.00 26.25           C  
ATOM    861  O   ASP    20       6.756  86.723  26.775  1.00 26.13           O  
ATOM    862  CB  ASP    20       8.618  88.482  24.690  1.00 30.80           C  
ATOM    863  CG  ASP    20       9.052  89.954  24.570  1.00 38.16           C  
ATOM    864  OD1 ASP    20       9.402  90.617  25.580  1.00 42.94           O  
ATOM    865  OD2 ASP    20       9.033  90.451  23.426  1.00 46.06           O  
ATOM    866  N   LEU    21       8.444  85.524  25.878  1.00 24.97           N  
ATOM    867  CA  LEU    21       7.721  84.269  26.090  1.00 23.54           C  
ATOM    868  C   LEU    21       7.555  83.994  27.575  1.00 22.52           C  
ATOM    869  O   LEU    21       6.474  83.604  28.042  1.00 24.44           O  
ATOM    870  CB  LEU    21       8.447  83.115  25.385  1.00 23.74           C  
ATOM    871  CG  LEU    21       7.857  81.731  25.468  1.00 25.87           C  
ATOM    872  CD1 LEU    21       6.373  81.718  24.990  1.00 25.00           C  
ATOM    873  CD2 LEU    21       8.754  80.756  24.680  1.00 23.70           C  
ATOM    874  N   TYR    22       8.626  84.193  28.326  1.00 22.41           N  
ATOM    875  CA  TYR    22       8.584  84.070  29.780  1.00 22.77           C  
ATOM    876  C   TYR    22       7.435  84.913  30.380  1.00 22.67           C  
ATOM    877  O   TYR    22       6.627  84.425  31.175  1.00 23.91           O  
ATOM    878  CB  TYR    22       9.912  84.494  30.385  1.00 23.66           C  
ATOM    879  CG  TYR    22       9.886  84.492  31.893  1.00 22.50           C  
ATOM    880  CD1 TYR    22      10.074  83.325  32.604  1.00 23.27           C  
ATOM    881  CD2 TYR    22       9.660  85.671  32.602  1.00 25.67           C  
ATOM    882  CE1 TYR    22      10.047  83.327  33.987  1.00 21.18           C  
ATOM    883  CE2 TYR    22       9.622  85.671  33.963  1.00 25.00           C  
ATOM    884  CZ  TYR    22       9.808  84.488  34.647  1.00 23.45           C  
ATOM    885  OH  TYR    22       9.784  84.487  35.999  1.00 27.44           O  
ATOM    886  N   ASP    23       7.378  86.174  29.980  1.00 23.82           N  
ATOM    887  CA  ASP    23       6.360  87.088  30.502  1.00 24.16           C  
ATOM    888  C   ASP    23       4.927  86.625  30.205  1.00 25.07           C  
ATOM    889  O   ASP    23       4.046  86.754  31.064  1.00 23.28           O  
ATOM    890  CB  ASP    23       6.577  88.482  29.910  1.00 24.42           C  
ATOM    891  CG  ASP    23       7.742  89.194  30.505  1.00 33.39           C  
ATOM    892  OD1 ASP    23       8.216  88.809  31.607  1.00 34.11           O  
ATOM    893  OD2 ASP    23       8.170  90.189  29.868  1.00 37.66           O  
ATOM    894  N   ILE    24       4.693  86.066  29.019  1.00 23.65           N  
ATOM    895  CA  ILE    24       3.350  85.619  28.651  1.00 24.84           C  
ATOM    896  C   ILE    24       3.018  84.370  29.489  1.00 23.61           C  
ATOM    897  O   ILE    24       1.899  84.210  29.967  1.00 24.22           O  
ATOM    898  CB  ILE    24       3.222  85.316  27.150  1.00 27.79           C  
ATOM    899  CG1 ILE    24       3.448  86.587  26.329  1.00 32.72           C  
ATOM    900  CG2 ILE    24       1.848  84.746  26.841  1.00 30.67           C  
ATOM    901  CD1 ILE    24       3.838  86.311  24.854  1.00 35.16           C  
ATOM    902  N   ILE    25       4.024  83.514  29.707  1.00 24.35           N  
ATOM    903  CA  ILE    25       3.817  82.316  30.523  1.00 24.21           C  
ATOM    904  C   ILE    25       3.445  82.707  31.965  1.00 23.22           C  
ATOM    905  O   ILE    25       2.509  82.132  32.562  1.00 25.47           O  
ATOM    906  CB  ILE    25       5.047  81.338  30.493  1.00 24.22           C  
ATOM    907  CG1 ILE    25       5.238  80.729  29.103  1.00 23.74           C  
ATOM    908  CG2 ILE    25       4.856  80.188  31.494  1.00 29.35           C  
ATOM    909  CD1 ILE    25       6.631  80.075  28.922  1.00 23.35           C  
ATOM    910  N   VAL    26       4.144  83.697  32.511  1.00 24.58           N  
ATOM    911  CA  VAL    26       3.846  84.171  33.859  1.00 26.19           C  
ATOM    912  C   VAL    26       2.405  84.710  33.937  1.00 24.90           C  
ATOM    913  O   VAL    26       1.639  84.349  34.854  1.00 24.16           O  
ATOM    914  CB  VAL    26       4.836  85.230  34.313  1.00 28.22           C  
ATOM    915  CG1 VAL    26       4.301  85.976  35.531  1.00 28.71           C  
ATOM    916  CG2 VAL    26       6.242  84.589  34.603  1.00 26.39           C  
ATOM    917  N   LYS    27       2.006  85.523  32.967  1.00 23.37           N  
ATOM    918  CA  LYS    27       0.622  86.024  32.925  0.50 23.88           C  
ATOM    920  C   LYS    27      -0.377  84.879  32.823  1.00 24.17           C  
ATOM    921  O   LYS    27      -1.387  84.886  33.498  1.00 24.41           O  
ATOM    922  CB  LYS    27       0.414  87.028  31.779  0.50 24.31           C  
ATOM    924  CG  LYS    27       1.172  88.334  31.934  0.50 20.98           C  
ATOM    926  N   LEU    28      -0.091  83.873  31.981  1.00 23.31           N  
ATOM    927  CA  LEU    28      -0.962  82.705  31.832  1.00 25.23           C  
ATOM    928  C   LEU    28      -1.121  81.995  33.180  1.00 25.13           C  
ATOM    929  O   LEU    28      -2.231  81.653  33.640  1.00 24.63           O  
ATOM    930  CB  LEU    28      -0.374  81.739  30.788  1.00 23.04           C  
ATOM    931  CG  LEU    28      -1.148  80.428  30.624  1.00 24.78           C  
ATOM    932  CD1 LEU    28      -2.545  80.697  30.079  1.00 32.09           C  
ATOM    933  CD2 LEU    28      -0.369  79.493  29.738  1.00 28.12           C  
ATOM    934  N   ASN    29       0.023  81.773  33.828  1.00 22.56           N  
ATOM    935  CA  ASN    29       0.048  81.101  35.117  1.00 24.38           C  
ATOM    936  C   ASN    29      -0.813  81.844  36.140  1.00 22.89           C  
ATOM    937  O   ASN    29      -1.651  81.255  36.839  1.00 26.79           O  
ATOM    938  CB  ASN    29       1.491  80.993  35.606  1.00 27.63           C  
ATOM    939  CG  ASN    29       1.585  80.340  36.962  1.00 33.82           C  
ATOM    940  OD1 ASN    29       1.667  79.126  37.053  1.00 33.33           O  
ATOM    941  ND2 ASN    29       1.566  81.143  38.011  1.00 35.43           N  
ATOM    942  N   ASP    30      -0.596  83.141  36.234  1.00 22.88           N  
ATOM    943  CA  ASP    30      -1.285  83.973  37.203  1.00 24.82           C  
ATOM    944  C   ASP    30      -2.797  84.034  36.943  1.00 25.07           C  
ATOM    945  O   ASP    30      -3.601  84.001  37.880  1.00 26.99           O  
ATOM    946  CB  ASP    30      -0.694  85.365  37.193  1.00 26.68           C  
ATOM    947  CG  ASP    30       0.726  85.408  37.720  1.00 28.43           C  
ATOM    948  OD1 ASP    30       1.234  84.358  38.174  1.00 35.44           O  
ATOM    949  OD2 ASP    30       1.331  86.499  37.649  1.00 29.80           O  
ATOM    950  N   THR    31      -3.173  84.070  35.675  1.00 22.79           N  
ATOM    951  CA  THR    31      -4.600  83.984  35.289  1.00 24.26           C  
ATOM    952  C   THR    31      -5.213  82.620  35.540  1.00 23.93           C  
ATOM    953  O   THR    31      -6.339  82.515  36.082  1.00 24.83           O  
ATOM    954  CB  THR    31      -4.809  84.366  33.824  1.00 22.72           C  
ATOM    955  OG1 THR    31      -4.260  85.683  33.614  1.00 30.25           O  
ATOM    956  CG2 THR    31      -6.307  84.307  33.460  1.00 24.57           C  
ATOM    957  N   VAL    32      -4.509  81.554  35.146  1.00 22.77           N  
ATOM    958  CA  VAL    32      -4.974  80.194  35.438  1.00 24.03           C  
ATOM    959  C   VAL    32      -5.286  80.043  36.936  1.00 23.77           C  
ATOM    960  O   VAL    32      -6.329  79.469  37.304  1.00 25.63           O  
ATOM    961  CB  VAL    32      -3.924  79.174  34.994  1.00 23.98           C  
ATOM    962  CG1 VAL    32      -4.033  77.835  35.796  1.00 24.54           C  
ATOM    963  CG2 VAL    32      -4.012  78.986  33.460  1.00 22.05           C  
ATOM    964  N   PHE    33      -4.431  80.590  37.799  1.00 23.43           N  
ATOM    965  CA  PHE    33      -4.601  80.397  39.246  1.00 25.33           C  
ATOM    966  C   PHE    33      -5.403  81.502  39.922  1.00 27.87           C  
ATOM    967  O   PHE    33      -5.384  81.637  41.159  1.00 27.20           O  
ATOM    968  CB  PHE    33      -3.266  80.181  39.951  1.00 27.45           C  
ATOM    969  CG  PHE    33      -2.688  78.829  39.709  1.00 26.58           C  
ATOM    970  CD1 PHE    33      -3.361  77.688  40.124  1.00 26.58           C  
ATOM    971  CD2 PHE    33      -1.487  78.692  39.040  1.00 27.16           C  
ATOM    972  CE1 PHE    33      -2.844  76.433  39.875  1.00 26.69           C  
ATOM    973  CE2 PHE    33      -0.960  77.444  38.790  1.00 25.47           C  
ATOM    974  CZ  PHE    33      -1.643  76.315  39.204  1.00 28.16           C  
ATOM    975  N   THR    34      -6.104  82.288  39.114  1.00 28.08           N  
ATOM    976  CA  THR    34      -7.123  83.205  39.620  1.00 27.68           C  
ATOM    977  C   THR    34      -8.472  82.607  39.227  1.00 26.27           C  
ATOM    978  O   THR    34      -9.079  82.991  38.223  1.00 24.59           O  
ATOM    979  CB  THR    34      -6.912  84.630  39.078  1.00 29.15           C  
ATOM    980  OG1 THR    34      -5.572  85.039  39.354  1.00 27.52           O  
ATOM    981  CG2 THR    34      -7.858  85.624  39.752  1.00 27.57           C  
ATOM    982  N   GLY    35      -8.916  81.627  40.013  1.00 23.37           N  
ATOM    983  CA  GLY    35     -10.169  80.966  39.763  1.00 26.15           C  
ATOM    984  C   GLY    35     -11.353  81.880  40.008  1.00 26.00           C  
ATOM    985  O   GLY    35     -11.261  82.862  40.761  1.00 26.21           O  
ATOM    986  N   LYS    36     -12.466  81.593  39.353  1.00 26.20           N  
ATOM    987  CA  LYS    36     -13.707  82.364  39.626  1.00 25.52           C  
ATOM    988  C   LYS    36     -14.401  81.918  40.902  1.00 25.59           C  
ATOM    989  O   LYS    36     -15.013  82.749  41.608  1.00 24.82           O  
ATOM    990  CB  LYS    36     -14.650  82.280  38.433  1.00 23.76           C  
ATOM    991  CG  LYS    36     -14.018  82.839  37.170  1.00 27.92           C  
ATOM    992  CD  LYS    36     -13.636  84.274  37.261  1.00 33.79           C  
ATOM    993  CE  LYS    36     -13.123  84.756  35.913  1.00 33.74           C  
ATOM    994  NZ  LYS    36     -12.672  86.191  35.921  1.00 36.41           N  
ATOM    995  N   THR    37     -14.305  80.634  41.224  1.00 26.34           N  
ATOM    996  CA  THR    37     -14.895  80.088  42.444  1.00 27.40           C  
ATOM    997  C   THR    37     -13.901  79.304  43.281  1.00 28.68           C  
ATOM    998  O   THR    37     -13.830  79.501  44.486  1.00 28.44           O  
ATOM    999  CB  THR    37     -16.085  79.125  42.147  1.00 30.61           C  
ATOM   1000  OG1 THR    37     -17.140  79.845  41.507  1.00 34.12           O  
ATOM   1001  CG2 THR    37     -16.683  78.562  43.442  1.00 27.91           C  
ATOM   1002  N   LEU    38     -13.154  78.398  42.652  1.00 24.44           N  
ATOM   1003  CA  LEU    38     -12.190  77.556  43.382  1.00 24.53           C  
ATOM   1004  C   LEU    38     -11.018  78.408  43.841  1.00 26.73           C  
ATOM   1005  O   LEU    38     -10.561  79.304  43.117  1.00 26.13           O  
ATOM   1006  CB  LEU    38     -11.682  76.416  42.494  1.00 24.24           C  
ATOM   1007  CG  LEU    38     -12.721  75.446  41.996  1.00 25.01           C  
ATOM   1008  CD1 LEU    38     -12.043  74.310  41.217  1.00 23.26           C  
ATOM   1009  CD2 LEU    38     -13.555  74.919  43.151  1.00 22.80           C  
ATOM   1010  N   ASP    39     -10.539  78.150  45.053  1.00 25.77           N  
ATOM   1011  CA  ASP    39      -9.405  78.915  45.556  1.00 26.59           C  
ATOM   1012  C   ASP    39      -8.085  78.324  45.076  1.00 26.80           C  
ATOM   1013  O   ASP    39      -8.046  77.280  44.439  1.00 24.07           O  
ATOM   1014  CB  ASP    39      -9.484  79.093  47.084  1.00 27.84           C  
ATOM   1015  CG  ASP    39      -9.352  77.804  47.861  1.00 31.36           C  
ATOM   1016  OD1 ASP    39      -8.887  76.754  47.351  1.00 28.62           O  
ATOM   1017  OD2 ASP    39      -9.729  77.848  49.052  1.00 33.78           O  
ATOM   1018  N   TYR    40      -7.011  79.046  45.327  1.00 25.33           N  
ATOM   1019  CA  TYR    40      -5.703  78.664  44.822  1.00 24.51           C  
ATOM   1020  C   TYR    40      -5.243  77.312  45.372  1.00 25.46           C  
ATOM   1021  O   TYR    40      -4.698  76.478  44.641  1.00 24.60           O  
ATOM   1022  CB  TYR    40      -4.723  79.753  45.247  1.00 28.58           C  
ATOM   1023  CG  TYR    40      -3.320  79.640  44.733  1.00 27.35           C  
ATOM   1024  CD1 TYR    40      -3.051  79.264  43.426  1.00 42.63           C  
ATOM   1025  CD2 TYR    40      -2.241  79.981  45.555  1.00 35.86           C  
ATOM   1026  CE1 TYR    40      -1.744  79.202  42.958  1.00 45.32           C  
ATOM   1027  CE2 TYR    40      -0.946  79.919  45.099  1.00 36.50           C  
ATOM   1028  CZ  TYR    40      -0.701  79.543  43.803  1.00 41.69           C  
ATOM   1029  OH  TYR    40       0.596  79.495  43.344  1.00 43.10           O  
ATOM   1030  N   LYS    41      -5.466  77.097  46.659  1.00 24.17           N  
ATOM   1031  CA  LYS    41      -5.137  75.787  47.259  1.00 26.03           C  
ATOM   1032  C   LYS    41      -5.786  74.622  46.516  1.00 24.80           C  
ATOM   1033  O   LYS    41      -5.121  73.627  46.222  1.00 24.41           O  
ATOM   1034  CB  LYS    41      -5.525  75.756  48.725  1.00 26.17           C  
ATOM   1035  CG  LYS    41      -5.211  74.458  49.459  1.00 31.58           C  
ATOM   1036  CD  LYS    41      -5.774  74.499  50.886  1.00 33.11           C  
ATOM   1037  CE  LYS    41      -5.347  73.283  51.704  1.00 42.88           C  
ATOM   1038  NZ  LYS    41      -5.846  73.354  53.109  1.00 41.08           N  
ATOM   1039  N   THR    42      -7.074  74.738  46.237  1.00 24.70           N  
ATOM   1040  CA  THR    42      -7.798  73.688  45.520  1.00 23.81           C  
ATOM   1041  C   THR    42      -7.217  73.448  44.133  1.00 24.23           C  
ATOM   1042  O   THR    42      -7.022  72.317  43.719  1.00 23.25           O  
ATOM   1043  CB  THR    42      -9.301  73.985  45.416  1.00 24.82           C  
ATOM   1044  OG1 THR    42      -9.845  74.084  46.733  1.00 25.22           O  
ATOM   1045  CG2 THR    42     -10.038  72.883  44.667  1.00 25.77           C  
ATOM   1046  N   GLN    43      -6.933  74.527  43.418  1.00 23.43           N  
ATOM   1047  CA  GLN    43      -6.319  74.414  42.118  1.00 22.86           C  
ATOM   1048  C   GLN    43      -4.922  73.781  42.157  1.00 23.94           C  
ATOM   1049  O   GLN    43      -4.585  73.025  41.268  1.00 22.91           O  
ATOM   1050  CB  GLN    43      -6.246  75.772  41.437  1.00 24.01           C  
ATOM   1051  CG  GLN    43      -7.565  76.328  41.029  1.00 22.72           C  
ATOM   1052  CD  GLN    43      -7.399  77.608  40.263  1.00 23.02           C  
ATOM   1053  OE1 GLN    43      -6.876  78.573  40.809  1.00 25.62           O  
ATOM   1054  NE2 GLN    43      -7.853  77.631  39.000  1.00 24.23           N  
ATOM   1055  N   LYS    44      -4.119  74.119  43.152  1.00 23.49           N  
ATOM   1056  CA  LYS    44      -2.798  73.504  43.293  1.00 22.94           C  
ATOM   1057  C   LYS    44      -2.885  72.010  43.618  1.00 23.73           C  
ATOM   1058  O   LYS    44      -2.073  71.231  43.139  1.00 23.97           O  
ATOM   1059  CB  LYS    44      -1.964  74.236  44.353  1.00 26.12           C  
ATOM   1060  CG  LYS    44      -1.383  75.517  43.796  1.00 37.14           C  
ATOM   1061  CD  LYS    44      -0.199  75.250  42.854  1.00 40.63           C  
ATOM   1062  CE  LYS    44       0.270  76.569  42.238  1.00 46.64           C  
ATOM   1063  NZ  LYS    44       1.409  76.414  41.283  1.00 41.05           N  
ATOM   1064  N   LEU    45      -3.875  71.626  44.416  1.00 22.77           N  
ATOM   1065  CA  LEU    45      -4.158  70.192  44.683  1.00 22.94           C  
ATOM   1066  C   LEU    45      -4.528  69.448  43.403  1.00 20.00           C  
ATOM   1067  O   LEU    45      -4.064  68.333  43.149  1.00 21.82           O  
ATOM   1068  CB  LEU    45      -5.255  70.034  45.759  1.00 24.89           C  
ATOM   1069  CG  LEU    45      -4.872  70.484  47.179  1.00 24.96           C  
ATOM   1070  CD1 LEU    45      -6.093  70.532  48.099  1.00 25.24           C  
ATOM   1071  CD2 LEU    45      -3.795  69.570  47.786  1.00 26.64           C  
ATOM   1072  N   ILE    46      -5.331  70.092  42.557  1.00 20.74           N  
ATOM   1073  CA  ILE    46      -5.651  69.564  41.249  1.00 21.62           C  
ATOM   1074  C   ILE    46      -4.391  69.407  40.390  1.00 20.78           C  
ATOM   1075  O   ILE    46      -4.202  68.383  39.737  1.00 21.91           O  
ATOM   1076  CB  ILE    46      -6.704  70.453  40.547  1.00 22.08           C  
ATOM   1077  CG1 ILE    46      -8.055  70.378  41.275  1.00 24.84           C  
ATOM   1078  CG2 ILE    46      -6.892  70.056  39.052  1.00 22.38           C  
ATOM   1079  CD1 ILE    46      -9.010  71.552  40.931  1.00 22.86           C  
ATOM   1080  N   ALA    47      -3.523  70.426  40.416  1.00 21.87           N  
ATOM   1081  CA  ALA    47      -2.279  70.384  39.643  1.00 21.24           C  
ATOM   1082  C   ALA    47      -1.416  69.194  40.090  1.00 21.15           C  
ATOM   1083  O   ALA    47      -0.852  68.486  39.264  1.00 23.10           O  
ATOM   1084  CB  ALA    47      -1.507  71.727  39.768  1.00 21.67           C  
ATOM   1085  N   ILE    48      -1.326  68.971  41.401  1.00 23.22           N  
ATOM   1086  CA  ILE    48      -0.581  67.815  41.934  1.00 23.42           C  
ATOM   1087  C   ILE    48      -1.151  66.535  41.379  1.00 22.45           C  
ATOM   1088  O   ILE    48      -0.412  65.683  40.917  1.00 22.38           O  
ATOM   1089  CB  ILE    48      -0.565  67.783  43.480  1.00 22.22           C  
ATOM   1090  CG1 ILE    48       0.257  68.942  44.048  1.00 26.05           C  
ATOM   1091  CG2 ILE    48       0.049  66.452  44.023  1.00 25.18           C  
ATOM   1092  CD1 ILE    48      -0.059  69.242  45.504  1.00 25.14           C  
ATOM   1093  N   GLY    49      -2.485  66.395  41.436  1.00 23.64           N  
ATOM   1094  CA  GLY    49      -3.152  65.223  40.890  1.00 22.69           C  
ATOM   1095  C   GLY    49      -2.810  64.948  39.439  1.00 22.13           C  
ATOM   1096  O   GLY    49      -2.514  63.817  39.044  1.00 22.25           O  
ATOM   1097  N   ILE    50      -2.858  65.995  38.620  1.00 21.97           N  
ATOM   1098  CA  ILE    50      -2.611  65.842  37.209  1.00 23.22           C  
ATOM   1099  C   ILE    50      -1.179  65.410  36.958  1.00 20.30           C  
ATOM   1100  O   ILE    50      -0.936  64.483  36.198  1.00 22.58           O  
ATOM   1101  CB  ILE    50      -2.928  67.132  36.415  1.00 23.33           C  
ATOM   1102  CG1 ILE    50      -4.446  67.402  36.425  1.00 25.36           C  
ATOM   1103  CG2 ILE    50      -2.410  67.043  34.958  1.00 25.70           C  
ATOM   1104  CD1 ILE    50      -4.873  68.780  35.946  1.00 23.40           C  
ATOM   1105  N   VAL    51      -0.226  66.112  37.554  1.00 22.13           N  
ATOM   1106  CA  VAL    51       1.198  65.805  37.361  0.50 22.96           C  
ATOM   1108  C   VAL    51       1.534  64.410  37.901  1.00 22.59           C  
ATOM   1109  O   VAL    51       2.294  63.639  37.290  1.00 23.85           O  
ATOM   1110  CB  VAL    51       2.072  66.864  38.052  0.50 23.96           C  
ATOM   1112  CG1 VAL    51       3.558  66.521  37.912  0.50 22.52           C  
ATOM   1114  CG2 VAL    51       1.793  68.268  37.453  0.50 24.56           C  
ATOM   1116  N   ALA    52       0.940  64.069  39.051  1.00 21.97           N  
ATOM   1117  CA  ALA    52       1.198  62.761  39.646  1.00 22.83           C  
ATOM   1118  C   ALA    52       0.615  61.626  38.821  1.00 24.96           C  
ATOM   1119  O   ALA    52       1.057  60.489  38.972  1.00 27.05           O  
ATOM   1120  CB  ALA    52       0.708  62.681  41.110  1.00 22.19           C  
ATOM   1121  N   SER    53      -0.366  61.908  37.962  1.00 23.44           N  
ATOM   1122  CA  SER    53      -0.993  60.900  37.128  0.50 24.03           C  
ATOM   1124  C   SER    53      -0.070  60.482  35.984  1.00 28.22           C  
ATOM   1125  O   SER    53      -0.306  59.463  35.352  1.00 29.44           O  
ATOM   1126  CB  SER    53      -2.358  61.369  36.590  0.50 24.46           C  
ATOM   1128  OG  SER    53      -2.273  62.367  35.572  0.50 17.33           O  
ATOM   1130  N   ARG    54       0.967  61.288  35.750  1.00 27.88           N  
ATOM   1131  CA  ARG    54       1.961  61.079  34.686  1.00 36.49           C  
ATOM   1132  C   ARG    54       3.323  60.666  35.269  1.00 42.51           C  
ATOM   1133  O   ARG    54       3.434  60.416  36.472  1.00 42.98           O  
ATOM   1134  CB  ARG    54       2.061  62.360  33.864  1.00 36.62           C  
ATOM   1135  CG  ARG    54       0.682  62.788  33.371  1.00 36.07           C  
ATOM   1136  CD  ARG    54       0.720  63.747  32.220  1.00 46.03           C  
ATOM   1137  NE  ARG    54       1.186  65.048  32.671  1.00 47.58           N  
ATOM   1138  CZ  ARG    54       0.593  66.218  32.427  1.00 48.31           C  
ATOM   1139  NH1 ARG    54      -0.539  66.301  31.716  1.00 41.50           N  
ATOM   1140  NH2 ARG    54       1.152  67.314  32.919  1.00 45.55           N  
ATOM   1141  N   CYS    55       4.364  60.567  34.441  1.00 47.81           N  
ATOM   1142  CA  CYS    55       5.609  59.917  34.908  1.00 53.06           C  
ATOM   1143  C   CYS    55       6.714  60.870  35.342  1.00 53.53           C  
ATOM   1144  O   CYS    55       7.760  60.423  35.818  1.00 55.63           O  
ATOM   1145  CB  CYS    55       6.175  58.963  33.844  1.00 54.41           C  
ATOM   1146  SG  CYS    55       4.966  57.829  33.125  1.00 70.70           S  
ATOM   1147  N   ASP    56       6.510  62.170  35.183  1.00 51.11           N  
ATOM   1148  CA  ASP    56       7.593  63.097  35.442  1.00 50.75           C  
ATOM   1149  C   ASP    56       7.796  63.237  36.966  1.00 47.60           C  
ATOM   1150  O   ASP    56       7.187  64.093  37.608  1.00 47.73           O  
ATOM   1151  CB  ASP    56       7.335  64.451  34.744  1.00 51.45           C  
ATOM   1152  CG  ASP    56       8.549  65.360  34.751  1.00 55.00           C  
ATOM   1153  OD1 ASP    56       9.598  64.950  35.298  1.00 59.75           O  
ATOM   1154  OD2 ASP    56       8.445  66.490  34.211  1.00 56.95           O  
ATOM   1155  N   GLU    57       8.662  62.376  37.505  1.00 44.76           N  
ATOM   1156  CA  GLU    57       9.079  62.384  38.919  1.00 44.68           C  
ATOM   1157  C   GLU    57       9.555  63.747  39.434  1.00 43.54           C  
ATOM   1158  O   GLU    57       9.225  64.151  40.554  1.00 39.20           O  
ATOM   1159  CB  GLU    57      10.193  61.362  39.121  1.00 44.24           C  
ATOM   1160  CG  GLU    57      10.658  61.181  40.556  1.00 49.33           C  
ATOM   1161  N   VAL    58      10.342  64.453  38.623  1.00 44.25           N  
ATOM   1162  CA  VAL    58      10.846  65.761  39.019  1.00 41.66           C  
ATOM   1163  C   VAL    58       9.712  66.771  39.079  1.00 39.99           C  
ATOM   1164  O   VAL    58       9.637  67.563  40.023  1.00 40.88           O  
ATOM   1165  CB  VAL    58      12.003  66.255  38.076  1.00 44.98           C  
ATOM   1166  N   ALA    59       8.820  66.732  38.092  1.00 36.00           N  
ATOM   1167  CA  ALA    59       7.624  67.563  38.085  1.00 36.40           C  
ATOM   1168  C   ALA    59       6.746  67.291  39.314  1.00 34.21           C  
ATOM   1169  O   ALA    59       6.208  68.222  39.935  1.00 33.66           O  
ATOM   1170  CB  ALA    59       6.840  67.324  36.816  1.00 37.99           C  
ATOM   1171  N   ILE    60       6.614  66.013  39.667  1.00 31.22           N  
ATOM   1172  CA  ILE    60       5.812  65.647  40.839  1.00 28.82           C  
ATOM   1173  C   ILE    60       6.454  66.198  42.119  1.00 27.71           C  
ATOM   1174  O   ILE    60       5.781  66.867  42.913  1.00 27.90           O  
ATOM   1175  CB  ILE    60       5.613  64.129  40.959  1.00 27.95           C  
ATOM   1176  CG1 ILE    60       4.862  63.584  39.742  1.00 27.51           C  
ATOM   1177  CG2 ILE    60       4.812  63.808  42.224  1.00 26.18           C  
ATOM   1178  CD1 ILE    60       4.987  62.071  39.545  1.00 25.07           C  
ATOM   1179  N   GLU    61       7.741  65.915  42.319  1.00 30.04           N  
ATOM   1180  CA  GLU    61       8.460  66.430  43.501  1.00 32.80           C  
ATOM   1181  C   GLU    61       8.345  67.964  43.626  1.00 35.05           C  
ATOM   1182  O   GLU    61       8.090  68.492  44.715  1.00 33.59           O  
ATOM   1183  CB  GLU    61       9.925  65.988  43.468  1.00 33.45           C  
ATOM   1184  CG  GLU    61      10.720  66.333  44.743  1.00 36.55           C  
ATOM   1185  N   LYS    62       8.492  68.665  42.503  1.00 38.76           N  
ATOM   1186  CA  LYS    62       8.430  70.135  42.479  1.00 39.30           C  
ATOM   1187  C   LYS    62       7.040  70.681  42.772  1.00 38.68           C  
ATOM   1188  O   LYS    62       6.906  71.655  43.526  1.00 36.68           O  
ATOM   1189  CB  LYS    62       8.919  70.670  41.123  1.00 42.11           C  
ATOM   1190  N   GLN    63       5.995  70.076  42.198  1.00 35.90           N  
ATOM   1191  CA  GLN    63       4.635  70.517  42.512  1.00 36.26           C  
ATOM   1192  C   GLN    63       4.355  70.313  43.989  1.00 33.33           C  
ATOM   1193  O   GLN    63       3.755  71.165  44.626  1.00 33.91           O  
ATOM   1194  CB  GLN    63       3.548  69.798  41.676  1.00 39.20           C  
ATOM   1195  CG  GLN    63       3.160  70.466  40.335  1.00 44.45           C  
ATOM   1196  CD  GLN    63       2.333  71.749  40.478  1.00 44.95           C  
ATOM   1197  OE1 GLN    63       1.712  72.008  41.510  1.00 62.12           O  
ATOM   1198  NE2 GLN    63       2.315  72.547  39.425  1.00 63.66           N  
ATOM   1199  N   MET    64       4.752  69.161  44.531  1.00 30.47           N  
ATOM   1200  CA  MET    64       4.471  68.856  45.916  1.00 26.68           C  
ATOM   1201  C   MET    64       5.225  69.810  46.838  1.00 29.86           C  
ATOM   1202  O   MET    64       4.645  70.361  47.788  1.00 28.23           O  
ATOM   1203  CB  MET    64       4.864  67.412  46.233  1.00 23.18           C  
ATOM   1204  CG  MET    64       3.918  66.370  45.589  1.00 22.57           C  
ATOM   1205  SD  MET    64       4.418  64.644  46.195  0.75 22.23          SE  
ATOM   1206  CE  MET    64       3.056  63.632  45.253  1.00 22.00           C  
ATOM   1207  N   LYS    65       6.514  69.998  46.544  1.00 32.32           N  
ATOM   1208  CA  LYS    65       7.386  70.856  47.371  1.00 34.88           C  
ATOM   1209  C   LYS    65       6.857  72.284  47.412  1.00 34.19           C  
ATOM   1210  O   LYS    65       6.702  72.863  48.483  1.00 35.31           O  
ATOM   1211  CB  LYS    65       8.826  70.843  46.843  1.00 35.46           C  
ATOM   1212  CG  LYS    65       9.625  69.629  47.243  1.00 40.38           C  
ATOM   1213  N   SER    66       6.564  72.836  46.245  1.00 36.71           N  
ATOM   1214  CA  SER    66       6.041  74.200  46.142  0.50 37.97           C  
ATOM   1216  C   SER    66       4.709  74.361  46.864  1.00 39.15           C  
ATOM   1217  O   SER    66       4.486  75.342  47.552  1.00 40.37           O  
ATOM   1218  CB  SER    66       5.895  74.618  44.676  0.50 38.61           C  
ATOM   1220  OG  SER    66       5.090  73.703  43.950  0.50 37.08           O  
ATOM   1222  N   ALA    67       3.815  73.392  46.707  1.00 37.33           N  
ATOM   1223  CA  ALA    67       2.536  73.447  47.409  1.00 35.90           C  
ATOM   1224  C   ALA    67       2.708  73.505  48.921  1.00 33.63           C  
ATOM   1225  O   ALA    67       2.000  74.242  49.614  1.00 33.38           O  
ATOM   1226  CB  ALA    67       1.675  72.239  47.036  1.00 35.08           C  
ATOM   1227  N   MET    68       3.620  72.690  49.440  1.00 32.12           N  
ATOM   1228  CA  MET    68       3.809  72.592  50.861  1.00 32.59           C  
ATOM   1229  C   MET    68       4.455  73.891  51.335  1.00 33.83           C  
ATOM   1230  O   MET    68       4.036  74.457  52.332  1.00 35.23           O  
ATOM   1231  CB  MET    68       4.684  71.396  51.205  1.00 33.38           C  
ATOM   1232  CG  MET    68       4.027  70.041  50.923  1.00 33.32           C  
ATOM   1233  SD  MET    68       5.192  68.597  51.472  0.75 34.95          SE  
ATOM   1234  CE  MET    68       4.864  68.765  53.369  1.00 39.85           C  
ATOM   1235  N   LYS    69       5.428  74.370  50.567  1.00 35.03           N  
ATOM   1236  CA  LYS    69       6.210  75.565  50.936  1.00 37.33           C  
ATOM   1237  C   LYS    69       5.376  76.830  50.796  1.00 38.14           C  
ATOM   1238  O   LYS    69       5.218  77.585  51.764  1.00 42.29           O  
ATOM   1239  CB  LYS    69       7.470  75.676  50.075  1.00 36.02           C  
ATOM   1240  N   GLU    70       4.833  77.048  49.606  1.00 39.17           N  
ATOM   1241  CA  GLU    70       4.066  78.262  49.302  1.00 40.19           C  
ATOM   1242  C   GLU    70       2.697  78.317  49.975  1.00 40.34           C  
ATOM   1243  O   GLU    70       2.343  79.342  50.543  1.00 42.02           O  
ATOM   1244  CB  GLU    70       3.909  78.452  47.786  1.00 39.25           C  
ATOM   1245  N   LEU    71       1.936  77.226  49.937  1.00 39.71           N  
ATOM   1246  CA  LEU    71       0.552  77.239  50.424  1.00 38.07           C  
ATOM   1247  C   LEU    71       0.339  76.549  51.771  1.00 34.95           C  
ATOM   1248  O   LEU    71      -0.765  76.565  52.307  1.00 37.25           O  
ATOM   1249  CB  LEU    71      -0.380  76.601  49.371  1.00 39.04           C  
ATOM   1250  CG  LEU    71      -0.453  77.252  47.981  1.00 43.95           C  
ATOM   1251  CD1 LEU    71       0.756  76.880  47.115  1.00 50.69           C  
ATOM   1252  CD2 LEU    71      -1.736  76.876  47.251  1.00 39.57           C  
ATOM   1253  N   GLY    72       1.355  75.907  52.325  1.00 31.62           N  
ATOM   1254  CA  GLY    72       1.147  75.169  53.571  1.00 31.33           C  
ATOM   1255  C   GLY    72       0.288  73.914  53.427  1.00 30.39           C  
ATOM   1256  O   GLY    72      -0.302  73.424  54.405  1.00 31.58           O  
ATOM   1257  N   ILE    73       0.217  73.377  52.213  1.00 32.06           N  
ATOM   1258  CA  ILE    73      -0.496  72.104  51.983  1.00 28.57           C  
ATOM   1259  C   ILE    73       0.221  70.989  52.779  1.00 29.16           C  
ATOM   1260  O   ILE    73       1.450  70.986  52.850  1.00 29.32           O  
ATOM   1261  CB  ILE    73      -0.621  71.840  50.468  1.00 30.50           C  
ATOM   1262  CG1 ILE    73      -1.744  72.732  49.891  1.00 27.84           C  
ATOM   1263  CG2 ILE    73      -0.867  70.336  50.174  1.00 25.19           C  
ATOM   1264  CD1 ILE    73      -1.816  72.820  48.371  1.00 30.38           C  
ATOM   1265  N   THR    74      -0.530  70.088  53.420  1.00 27.36           N  
ATOM   1266  CA  THR    74       0.088  69.024  54.242  1.00 27.26           C  
ATOM   1267  C   THR    74       0.356  67.745  53.462  1.00 27.58           C  
ATOM   1268  O   THR    74      -0.238  67.522  52.416  1.00 24.17           O  
ATOM   1269  CB  THR    74      -0.757  68.627  55.460  1.00 29.19           C  
ATOM   1270  OG1 THR    74      -2.004  68.099  55.031  1.00 28.81           O  
ATOM   1271  CG2 THR    74      -0.971  69.880  56.480  1.00 28.98           C  
ATOM   1272  N   LYS    75       1.211  66.876  53.997  1.00 26.69           N  
ATOM   1273  CA  LYS    75       1.408  65.575  53.357  1.00 24.94           C  
ATOM   1274  C   LYS    75       0.105  64.766  53.394  1.00 24.97           C  
ATOM   1275  O   LYS    75      -0.183  64.049  52.430  1.00 24.26           O  
ATOM   1276  CB  LYS    75       2.547  64.787  54.001  1.00 25.92           C  
ATOM   1277  CG  LYS    75       3.941  65.377  53.781  1.00 25.04           C  
ATOM   1278  CD  LYS    75       5.016  64.369  54.207  1.00 27.40           C  
ATOM   1279  CE  LYS    75       6.395  64.744  53.675  1.00 30.74           C  
ATOM   1280  NZ  LYS    75       7.337  63.582  53.770  1.00 29.47           N  
ATOM   1281  N   GLU    76      -0.705  64.923  54.456  1.00 23.62           N  
ATOM   1282  CA  GLU    76      -2.006  64.250  54.537  1.00 27.19           C  
ATOM   1283  C   GLU    76      -2.963  64.703  53.418  1.00 22.94           C  
ATOM   1284  O   GLU    76      -3.670  63.897  52.828  1.00 25.59           O  
ATOM   1285  CB  GLU    76      -2.676  64.495  55.897  1.00 28.02           C  
ATOM   1286  CG  GLU    76      -3.944  63.646  56.101  1.00 35.01           C  
ATOM   1287  CD  GLU    76      -4.602  63.869  57.467  1.00 37.01           C  
ATOM   1288  OE1 GLU    76      -4.541  65.017  57.990  1.00 52.64           O  
ATOM   1289  OE2 GLU    76      -5.167  62.883  58.002  1.00 48.87           O  
ATOM   1290  N   GLU    77      -2.974  65.994  53.116  1.00 24.57           N  
ATOM   1291  CA  GLU    77      -3.774  66.494  52.000  1.00 24.63           C  
ATOM   1292  C   GLU    77      -3.272  65.945  50.656  1.00 24.30           C  
ATOM   1293  O   GLU    77      -4.068  65.546  49.803  1.00 23.45           O  
ATOM   1294  CB  GLU    77      -3.785  68.017  51.965  1.00 25.09           C  
ATOM   1295  CG  GLU    77      -4.555  68.632  53.117  1.00 28.85           C  
ATOM   1296  CD  GLU    77      -4.410  70.153  53.229  1.00 30.84           C  
ATOM   1297  OE1 GLU    77      -3.353  70.735  52.878  1.00 33.27           O  
ATOM   1298  OE2 GLU    77      -5.388  70.777  53.674  1.00 33.37           O  
ATOM   1299  N   ILE    78      -1.955  65.938  50.475  1.00 24.49           N  
ATOM   1300  CA  ILE    78      -1.378  65.340  49.262  1.00 23.04           C  
ATOM   1301  C   ILE    78      -1.725  63.851  49.134  1.00 21.63           C  
ATOM   1302  O   ILE    78      -2.100  63.380  48.059  1.00 21.32           O  
ATOM   1303  CB  ILE    78       0.162  65.600  49.123  1.00 22.33           C  
ATOM   1304  CG1 ILE    78       0.452  67.103  49.059  1.00 25.20           C  
ATOM   1305  CG2 ILE    78       0.697  64.957  47.836  1.00 21.31           C  
ATOM   1306  CD1 ILE    78       1.911  67.437  49.205  1.00 24.12           C  
ATOM   1307  N   ALA    79      -1.679  63.116  50.236  1.00 22.41           N  
ATOM   1308  CA  ALA    79      -2.026  61.718  50.200  1.00 20.30           C  
ATOM   1309  C   ALA    79      -3.467  61.520  49.727  1.00 21.42           C  
ATOM   1310  O   ALA    79      -3.749  60.611  48.966  1.00 20.43           O  
ATOM   1311  CB  ALA    79      -1.797  61.071  51.552  1.00 22.66           C  
ATOM   1312  N   ASP    80      -4.374  62.409  50.130  1.00 20.93           N  
ATOM   1313  CA  ASP    80      -5.762  62.331  49.652  1.00 20.26           C  
ATOM   1314  C   ASP    80      -5.885  62.593  48.155  1.00 22.81           C  
ATOM   1315  O   ASP    80      -6.734  62.009  47.494  1.00 22.27           O  
ATOM   1316  CB  ASP    80      -6.667  63.310  50.395  1.00 20.14           C  
ATOM   1317  CG  ASP    80      -7.045  62.853  51.807  1.00 23.19           C  
ATOM   1318  OD1 ASP    80      -6.928  61.652  52.156  1.00 25.42           O  
ATOM   1319  OD2 ASP    80      -7.525  63.728  52.549  1.00 28.27           O  
ATOM   1320  N   VAL    81      -5.043  63.483  47.619  1.00 21.25           N  
ATOM   1321  CA  VAL    81      -4.939  63.659  46.181  1.00 22.27           C  
ATOM   1322  C   VAL    81      -4.492  62.341  45.520  1.00 20.03           C  
ATOM   1323  O   VAL    81      -5.078  61.898  44.508  1.00 19.50           O  
ATOM   1324  CB  VAL    81      -3.963  64.805  45.817  1.00 20.90           C  
ATOM   1325  CG1 VAL    81      -3.757  64.895  44.302  1.00 22.88           C  
ATOM   1326  CG2 VAL    81      -4.425  66.168  46.443  1.00 20.83           C  
ATOM   1327  N   LEU    82      -3.519  61.673  46.131  1.00 20.16           N  
ATOM   1328  CA  LEU    82      -2.954  60.455  45.560  1.00 19.84           C  
ATOM   1329  C   LEU    82      -3.955  59.291  45.560  1.00 18.54           C  
ATOM   1330  O   LEU    82      -3.913  58.425  44.676  1.00 19.11           O  
ATOM   1331  CB  LEU    82      -1.666  60.090  46.263  1.00 20.98           C  
ATOM   1332  CG  LEU    82      -0.551  61.135  46.146  1.00 20.66           C  
ATOM   1333  CD1 LEU    82       0.766  60.558  46.671  1.00 21.28           C  
ATOM   1334  CD2 LEU    82      -0.392  61.639  44.674  1.00 22.33           C  
ATOM   1335  N   ARG    83      -4.911  59.309  46.495  1.00 20.31           N  
ATOM   1336  CA  ARG    83      -5.991  58.304  46.463  1.00 21.39           C  
ATOM   1337  C   ARG    83      -6.744  58.386  45.139  1.00 20.18           C  
ATOM   1338  O   ARG    83      -7.025  57.394  44.468  1.00 19.30           O  
ATOM   1339  CB  ARG    83      -6.940  58.521  47.643  1.00 22.29           C  
ATOM   1340  CG  ARG    83      -6.321  58.269  48.999  1.00 22.30           C  
ATOM   1341  CD  ARG    83      -7.215  58.747  50.124  1.00 28.97           C  
ATOM   1342  NE  ARG    83      -8.051  57.695  50.628  1.00 33.52           N  
ATOM   1343  CZ  ARG    83      -7.790  56.938  51.696  1.00 23.68           C  
ATOM   1344  NH1 ARG    83      -6.703  57.064  52.438  1.00 32.40           N  
ATOM   1345  NH2 ARG    83      -8.646  56.031  52.018  1.00 24.82           N  
ATOM   1346  N   VAL    84      -7.007  59.612  44.712  1.00 19.60           N  
ATOM   1347  CA  VAL    84      -7.659  59.856  43.423  1.00 20.32           C  
ATOM   1348  C   VAL    84      -6.772  59.472  42.241  1.00 20.03           C  
ATOM   1349  O   VAL    84      -7.255  58.901  41.275  1.00 20.48           O  
ATOM   1350  CB  VAL    84      -8.137  61.322  43.296  1.00 21.39           C  
ATOM   1351  CG1 VAL    84      -8.987  61.511  41.998  1.00 22.27           C  
ATOM   1352  CG2 VAL    84      -8.967  61.726  44.539  1.00 22.62           C  
ATOM   1353  N   VAL    85      -5.467  59.765  42.311  1.00 19.59           N  
ATOM   1354  CA  VAL    85      -4.526  59.262  41.308  1.00 19.33           C  
ATOM   1355  C   VAL    85      -4.607  57.748  41.150  1.00 19.40           C  
ATOM   1356  O   VAL    85      -4.616  57.261  40.035  1.00 20.61           O  
ATOM   1357  CB  VAL    85      -3.073  59.710  41.615  1.00 19.39           C  
ATOM   1358  CG1 VAL    85      -2.070  59.082  40.659  1.00 17.94           C  
ATOM   1359  CG2 VAL    85      -2.997  61.250  41.539  1.00 21.42           C  
ATOM   1360  N   LEU    86      -4.650  56.998  42.252  1.00 19.33           N  
ATOM   1361  CA  LEU    86      -4.777  55.548  42.161  1.00 19.79           C  
ATOM   1362  C   LEU    86      -6.014  55.159  41.363  1.00 18.98           C  
ATOM   1363  O   LEU    86      -5.940  54.357  40.454  1.00 20.03           O  
ATOM   1364  CB  LEU    86      -4.858  54.924  43.555  1.00 21.20           C  
ATOM   1365  CG  LEU    86      -5.184  53.439  43.651  1.00 21.99           C  
ATOM   1366  CD1 LEU    86      -4.133  52.600  42.959  1.00 24.06           C  
ATOM   1367  CD2 LEU    86      -5.310  53.065  45.156  1.00 20.62           C  
ATOM   1368  N   LEU    87      -7.154  55.734  41.711  1.00 20.94           N  
ATOM   1369  CA  LEU    87      -8.412  55.347  41.065  1.00 21.06           C  
ATOM   1370  C   LEU    87      -8.447  55.701  39.591  1.00 21.01           C  
ATOM   1371  O   LEU    87      -8.981  54.948  38.793  1.00 22.38           O  
ATOM   1372  CB  LEU    87      -9.577  56.046  41.769  1.00 23.55           C  
ATOM   1373  CG  LEU    87     -10.992  55.596  41.405  1.00 25.01           C  
ATOM   1374  CD1 LEU    87     -11.291  54.169  41.742  1.00 30.38           C  
ATOM   1375  CD2 LEU    87     -11.944  56.517  42.180  1.00 27.84           C  
ATOM   1376  N   THR    88      -7.906  56.874  39.258  1.00 21.25           N  
ATOM   1377  CA  THR    88      -7.927  57.375  37.879  1.00 21.88           C  
ATOM   1378  C   THR    88      -6.816  56.833  36.983  1.00 22.77           C  
ATOM   1379  O   THR    88      -6.931  56.837  35.762  1.00 23.28           O  
ATOM   1380  CB  THR    88      -7.874  58.903  37.853  1.00 21.84           C  
ATOM   1381  OG1 THR    88      -6.644  59.350  38.431  1.00 22.90           O  
ATOM   1382  CG2 THR    88      -9.066  59.477  38.541  1.00 25.52           C  
ATOM   1383  N   SER    89      -5.735  56.386  37.602  1.00 20.63           N  
ATOM   1384  CA  SER    89      -4.483  56.227  36.896  1.00 21.58           C  
ATOM   1385  C   SER    89      -3.720  54.942  37.169  1.00 21.03           C  
ATOM   1386  O   SER    89      -2.772  54.629  36.425  1.00 23.05           O  
ATOM   1387  CB  SER    89      -3.575  57.459  37.151  1.00 25.09           C  
ATOM   1388  OG  SER    89      -4.281  58.671  36.880  1.00 24.41           O  
ATOM   1389  N   GLY    90      -4.063  54.215  38.234  1.00 21.98           N  
ATOM   1390  CA  GLY    90      -3.467  52.905  38.482  1.00 20.22           C  
ATOM   1391  C   GLY    90      -2.363  52.897  39.536  1.00 20.13           C  
ATOM   1392  O   GLY    90      -1.942  53.955  40.033  1.00 19.52           O  
ATOM   1393  N   MET    91      -1.913  51.694  39.856  1.00 20.97           N  
ATOM   1394  CA  MET    91      -0.890  51.427  40.886  0.40 24.63           C  
ATOM   1396  C   MET    91       0.459  52.100  40.604  1.00 21.70           C  
ATOM   1397  O   MET    91       1.059  52.724  41.502  1.00 23.86           O  
ATOM   1398  CB  MET    91      -0.619  49.917  41.035  0.40 26.41           C  
ATOM   1400  CG  MET    91      -1.632  49.085  41.765  0.40 29.31           C  
ATOM   1402  SD  MET    91      -0.711  47.905  43.072  0.28 35.75          SE  
ATOM   1404  CE  MET    91      -0.457  49.469  44.218  0.40 21.93           C  
ATOM   1406  N   PRO    92       0.980  51.963  39.373  1.00 21.05           N  
ATOM   1407  CA  PRO    92       2.311  52.563  39.147  1.00 19.88           C  
ATOM   1408  C   PRO    92       2.408  54.050  39.498  1.00 21.02           C  
ATOM   1409  O   PRO    92       3.356  54.485  40.177  1.00 20.96           O  
ATOM   1410  CB  PRO    92       2.572  52.299  37.663  1.00 22.51           C  
ATOM   1411  CG  PRO    92       1.788  51.073  37.374  1.00 20.16           C  
ATOM   1412  CD  PRO    92       0.530  51.210  38.184  1.00 21.39           C  
ATOM   1413  N   ALA    93       1.434  54.836  39.065  1.00 19.14           N  
ATOM   1414  CA  ALA    93       1.460  56.257  39.340  1.00 19.96           C  
ATOM   1415  C   ALA    93       1.300  56.530  40.843  1.00 19.93           C  
ATOM   1416  O   ALA    93       1.977  57.400  41.418  1.00 20.12           O  
ATOM   1417  CB  ALA    93       0.324  56.953  38.551  1.00 22.71           C  
ATOM   1418  N   PHE    94       0.374  55.804  41.457  1.00 18.44           N  
ATOM   1419  CA  PHE    94       0.116  55.937  42.882  1.00 18.79           C  
ATOM   1420  C   PHE    94       1.380  55.638  43.705  1.00 20.05           C  
ATOM   1421  O   PHE    94       1.763  56.426  44.594  1.00 19.06           O  
ATOM   1422  CB  PHE    94      -0.966  54.949  43.301  1.00 20.10           C  
ATOM   1423  CG  PHE    94      -1.232  54.947  44.799  1.00 20.32           C  
ATOM   1424  CD1 PHE    94      -1.802  56.035  45.406  1.00 19.60           C  
ATOM   1425  CD2 PHE    94      -0.904  53.846  45.583  1.00 23.76           C  
ATOM   1426  CE1 PHE    94      -2.066  56.050  46.776  1.00 22.96           C  
ATOM   1427  CE2 PHE    94      -1.154  53.856  46.964  1.00 22.72           C  
ATOM   1428  CZ  PHE    94      -1.722  54.954  47.559  1.00 26.09           C  
ATOM   1429  N   THR    95       2.013  54.508  43.431  1.00 20.55           N  
ATOM   1430  CA  THR    95       3.135  54.077  44.284  1.00 20.94           C  
ATOM   1431  C   THR    95       4.339  55.000  44.073  1.00 20.73           C  
ATOM   1432  O   THR    95       5.018  55.353  45.038  1.00 20.28           O  
ATOM   1433  CB  THR    95       3.494  52.592  44.055  1.00 23.86           C  
ATOM   1434  OG1 THR    95       3.863  52.424  42.701  1.00 24.63           O  
ATOM   1435  CG2 THR    95       2.314  51.685  44.356  1.00 21.43           C  
ATOM   1436  N   LYS    96       4.586  55.442  42.833  1.00 20.08           N  
ATOM   1437  CA  LYS    96       5.679  56.370  42.546  0.50 21.50           C  
ATOM   1439  C   LYS    96       5.460  57.655  43.335  1.00 20.81           C  
ATOM   1440  O   LYS    96       6.378  58.161  43.984  1.00 23.01           O  
ATOM   1441  CB  LYS    96       5.748  56.674  41.040  0.50 23.02           C  
ATOM   1443  CG  LYS    96       6.843  57.658  40.621  0.50 23.87           C  
ATOM   1445  CD  LYS    96       7.014  57.722  39.092  0.50 25.49           C  
ATOM   1447  CE  LYS    96       8.452  58.030  38.704  0.50 32.66           C  
ATOM   1449  NZ  LYS    96       9.333  56.844  38.868  0.50 30.31           N  
ATOM   1451  N   ALA    97       4.244  58.190  43.262  1.00 19.16           N  
ATOM   1452  CA  ALA    97       3.898  59.469  43.921  1.00 19.50           C  
ATOM   1453  C   ALA    97       3.968  59.374  45.441  1.00 20.63           C  
ATOM   1454  O   ALA    97       4.463  60.306  46.135  1.00 20.71           O  
ATOM   1455  CB  ALA    97       2.498  59.945  43.472  1.00 19.41           C  
ATOM   1456  N   MET    98       3.499  58.244  45.974  1.00 19.58           N  
ATOM   1457  CA  MET    98       3.518  58.034  47.406  1.00 20.80           C  
ATOM   1458  C   MET    98       4.949  58.016  47.898  1.00 21.43           C  
ATOM   1459  O   MET    98       5.235  58.574  48.952  1.00 21.18           O  
ATOM   1460  CB  MET    98       2.812  56.740  47.834  1.00 22.05           C  
ATOM   1461  CG  MET    98       1.348  56.831  48.010  1.00 30.57           C  
ATOM   1462  SD  MET    98       0.764  58.016  49.491  0.75 32.27          SE  
ATOM   1463  CE  MET    98       1.937  58.044  50.314  1.00  8.65           C  
ATOM   1464  N   LYS    99       5.840  57.362  47.159  1.00 20.17           N  
ATOM   1465  CA  LYS    99       7.263  57.318  47.526  1.00 20.82           C  
ATOM   1466  C   LYS    99       7.928  58.695  47.534  1.00 21.61           C  
ATOM   1467  O   LYS    99       8.729  59.015  48.429  1.00 22.41           O  
ATOM   1468  CB  LYS    99       8.015  56.361  46.599  1.00 19.98           C  
ATOM   1469  CG  LYS    99       9.522  56.268  46.893  1.00 23.11           C  
ATOM   1470  N   ILE   100       7.602  59.501  46.536  1.00 22.47           N  
ATOM   1471  CA  ILE   100       8.072  60.874  46.456  1.00 23.27           C  
ATOM   1472  C   ILE   100       7.553  61.687  47.656  1.00 24.13           C  
ATOM   1473  O   ILE   100       8.325  62.413  48.299  1.00 23.84           O  
ATOM   1474  CB  ILE   100       7.652  61.544  45.136  1.00 22.91           C  
ATOM   1475  CG1 ILE   100       8.324  60.868  43.926  1.00 22.73           C  
ATOM   1476  CG2 ILE   100       7.973  63.043  45.152  1.00 21.99           C  
ATOM   1477  CD1 ILE   100       7.717  61.279  42.573  1.00 25.00           C  
ATOM   1478  N   LEU   101       6.269  61.540  47.970  1.00 21.64           N  
ATOM   1479  CA  LEU   101       5.660  62.247  49.106  1.00 23.29           C  
ATOM   1480  C   LEU   101       6.347  61.878  50.406  1.00 23.75           C  
ATOM   1481  O   LEU   101       6.624  62.756  51.240  1.00 22.26           O  
ATOM   1482  CB  LEU   101       4.155  61.935  49.207  1.00 22.94           C  
ATOM   1483  CG  LEU   101       3.386  62.589  50.364  1.00 23.09           C  
ATOM   1484  CD1 LEU   101       3.489  64.134  50.332  1.00 23.78           C  
ATOM   1485  CD2 LEU   101       1.946  62.145  50.275  1.00 22.66           C  
ATOM   1486  N   GLU   102       6.611  60.583  50.578  1.00 22.09           N  
ATOM   1487  CA  GLU   102       7.262  60.059  51.770  1.00 27.09           C  
ATOM   1488  C   GLU   102       8.642  60.680  51.965  1.00 25.97           C  
ATOM   1489  O   GLU   102       9.018  61.019  53.083  1.00 27.53           O  
ATOM   1490  CB  GLU   102       7.399  58.543  51.675  1.00 27.36           C  
ATOM   1491  CG  GLU   102       6.073  57.805  51.782  1.00 34.71           C  
ATOM   1492  CD  GLU   102       6.120  56.363  51.242  1.00 36.54           C  
ATOM   1493  OE1 GLU   102       7.234  55.820  51.027  1.00 45.78           O  
ATOM   1494  OE2 GLU   102       5.022  55.775  51.058  1.00 44.93           O  
ATOM   1495  N   LYS   103       9.388  60.834  50.880  1.00 25.11           N  
ATOM   1496  CA  LYS   103      10.773  61.333  50.951  1.00 28.56           C  
ATOM   1497  C   LYS   103      10.847  62.862  51.111  1.00 31.51           C  
ATOM   1498  O   LYS   103      11.911  63.419  51.414  1.00 33.51           O  
ATOM   1499  CB  LYS   103      11.571  60.887  49.714  1.00 29.59           C  
ATOM   1500  CG  LYS   103      11.820  59.386  49.621  1.00 32.01           C  
ATOM   1501  N   LEU   104       9.727  63.543  50.933  1.00 31.51           N  
ATOM   1502  CA  LEU   104       9.711  64.997  51.021  1.00 35.23           C  
ATOM   1503  C   LEU   104       9.855  65.493  52.451  1.00 36.78           C  
ATOM   1504  O   LEU   104       9.406  64.849  53.400  1.00 36.92           O  
ATOM   1505  CB  LEU   104       8.441  65.570  50.389  1.00 34.06           C  
ATOM   1506  CG  LEU   104       8.572  65.835  48.898  1.00 34.04           C  
ATOM   1507  CD1 LEU   104       7.311  66.503  48.411  1.00 34.11           C  
ATOM   1508  CD2 LEU   104       9.796  66.702  48.620  1.00 38.61           C  
ATOM   1509  OXT LEU   104      10.441  66.563  52.661  1.00 40.57           O  
END
