
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  122 (  935),  selected  122 , name 2af7_D
# Molecule2: number of CA atoms   98 (  717),  selected   98 , name T0408.pdb
# PARAMETERS: 2af7_D.T0408.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_D      -       -           -
LGA    E     2_D      -       -           -
LGA    R     3_D      -       -           -
LGA    Y     4_D      -       -           -
LGA    R     5_D      -       -           -
LGA    R     6_D      -       -           -
LGA    G     7_D      -       -           -
LGA    X     8_D      -       -           -
LGA    E     9_D      -       -           -
LGA    I    10_D      -       -           -
LGA    L    11_D      -       -           -
LGA    N    12_D      -       -           -
LGA    R    13_D      -       -           -
LGA    X    14_D      -       -           -
LGA    N    15_D      -       -           -
LGA    R    16_D      -       -           -
LGA    K    17_D      -       -           -
LGA    S    18_D      F       7          3.285
LGA    Y    19_D      G       8          4.626
LGA    T    20_D      E       9           #
LGA    A    21_D      G      10           #
LGA    I    22_D      M      11          2.766
LGA    R    23_D      K      12          1.370
LGA    D    24_D      V      13          3.603
LGA    E    25_D      V      14          4.259
LGA    L    26_D      K      15          3.647
LGA    E    27_D      E      16          4.049
LGA    D    28_D      -       -           -
LGA    V    29_D      -       -           -
LGA    A    30_D      K      17          3.765
LGA    P    31_D      Y      18          3.120
LGA    D    32_D      P      19          4.416
LGA    -       -      D      20           -
LGA    L    33_D      L      21          4.471
LGA    A    34_D      Y      22          3.379
LGA    R    35_D      D      23          2.708
LGA    F    36_D      I      24          3.217
LGA    V    37_D      I      25          2.801
LGA    A    38_D      V      26          1.323
LGA    E    39_D      K      27          1.477
LGA    F    40_D      L      28          0.465
LGA    A    41_D      N      29          1.893
LGA    Y    42_D      D      30          1.946
LGA    G    43_D      -       -           -
LGA    D    44_D      T      31          1.469
LGA    V    45_D      V      32          1.287
LGA    Y    46_D      F      33          0.595
LGA    S    47_D      T      34          1.607
LGA    R    48_D      G      35          2.670
LGA    G    49_D      K      36          2.755
LGA    V    50_D      T      37          0.753
LGA    L    51_D      L      38          0.791
LGA    D    52_D      D      39          1.237
LGA    L    53_D      Y      40          1.201
LGA    K    54_D      K      41          1.043
LGA    T    55_D      T      42          0.625
LGA    R    56_D      Q      43          0.982
LGA    E    57_D      K      44          0.899
LGA    L    58_D      L      45          0.293
LGA    L    59_D      I      46          0.397
LGA    T    60_D      A      47          0.277
LGA    L    61_D      I      48          0.529
LGA    A    62_D      G      49          0.601
LGA    A    63_D      I      50          0.587
LGA    L    64_D      V      51          0.490
LGA    T    65_D      A      52          1.309
LGA    V    66_D      S      53          1.464
LGA    L    67_D      R      54          2.028
LGA    R    68_D      C      55          2.114
LGA    A    69_D      D      56          2.365
LGA    D    70_D      E      57          1.944
LGA    D    71_D      V      58          1.954
LGA    Q    72_D      A      59          2.027
LGA    L    73_D      I      60          1.577
LGA    K    74_D      E      61          1.436
LGA    S    75_D      K      62          1.514
LGA    H    76_D      Q      63          1.526
LGA    V    77_D      M      64          0.865
LGA    R    78_D      K      65          1.996
LGA    G    79_D      S      66          2.279
LGA    A    80_D      A      67          1.525
LGA    L    81_D      M      68          1.037
LGA    N    82_D      K      69          2.968
LGA    -       -      E      70           -
LGA    A    83_D      L      71          0.858
LGA    G    84_D      G      72          2.456
LGA    C    85_D      I      73          1.326
LGA    S    86_D      T      74          0.894
LGA    K    87_D      K      75          0.922
LGA    D    88_D      E      76          0.489
LGA    E    89_D      E      77          0.672
LGA    I    90_D      I      78          0.536
LGA    I    91_D      A      79          1.466
LGA    E    92_D      D      80          1.591
LGA    V    93_D      V      81          0.946
LGA    X    94_D      L      82          1.004
LGA    I    95_D      R      83          2.632
LGA    Q    96_D      V      84          2.442
LGA    X    97_D      V      85          1.098
LGA    A    98_D      L      86          1.079
LGA    V    99_D      L      87          1.322
LGA    Y   100_D      T      88          1.139
LGA    A   101_D      S      89          0.359
LGA    G   102_D      G      90          0.679
LGA    F   103_D      M      91          0.519
LGA    P   104_D      P      92          0.271
LGA    A   105_D      A      93          0.558
LGA    A   106_D      F      94          0.844
LGA    I   107_D      T      95          1.146
LGA    N   108_D      K      96          1.375
LGA    A   109_D      A      97          1.649
LGA    V   110_D      M      98          1.923
LGA    L   111_D      K      99          1.993
LGA    A   112_D      I     100          2.289
LGA    A   113_D      L     101          2.302
LGA    K   114_D      E     102          2.677
LGA    E   115_D      K     103          3.159
LGA    V   116_D      L     104          3.057
LGA    F   117_D      -       -           -
LGA    T   118_D      -       -           -
LGA    E   119_D      -       -           -
LGA    N   120_D      -       -           -
LGA    D   121_D      -       -           -
LGA    P   122_D      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  122   98    5.0     94    2.05    19.15     84.022     4.375

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.558820 * X  +  -0.754502 * Y  +   0.344162 * Z  + -142.428986
  Y_new =   0.643024 * X  +   0.656298 * Y  +   0.394706 * Z  + -109.797401
  Z_new =  -0.523679 * X  +   0.000734 * Y  +   0.851915 * Z  +  32.885197 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.000862   -3.140731  [ DEG:     0.0494   -179.9506 ]
  Theta =   0.551164    2.590429  [ DEG:    31.5794    148.4206 ]
  Phi   =   0.855346   -2.286247  [ DEG:    49.0077   -130.9923 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2af7_D                                        
REMARK     2: T0408.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2af7_D.T0408.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  122   98   5.0   94   2.05   19.15  84.022
REMARK  ---------------------------------------------------------- 
MOLECULE 2af7_D
HEADER    LYASE                                   25-JUL-05   2AF7              
TITLE     CRYSTAL STRUCTURE OF THE GAMMA-CARBOXYMUCONOLACTONE                   
TITLE    2 DECARBOXYLASE FROM METHANOBACTERIUM THERMOAUTOTROPHICUM.             
TITLE    3 NORTHEAST STRUCTURAL GENOMICS CONSORTIUM TARGET TT747.               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GAMMA-CARBOXYMUCONOLACTONE DECARBOXYLASE;                  
COMPND   3 CHAIN: A, C, D, E, I, F, B, G, H;                                    
COMPND   4 EC: 4.1.1.44;                                                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: METHANOBACTERIUM THERMOAUTOTROPHICUM;           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: MTH234;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)+MAGIC;                           
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    GAMMA-CARBOXYMUCONOLACTONE DECARBOXYLASE, O26336_METTH,               
KEYWDS   2 NESG, TT747, STRUCTURAL GENOMICS, PSI, PROTEIN STRUCTURE             
KEYWDS   3 INITIATIVE, NORTHEAST STRUCTURAL GENOMICS CONSORTIUM                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.M.VOROBIEV,A.KUZIN,T.SKARINA,A.SAVCHENKO,A.SEMESI,                  
AUTHOR   2 C.ARROWSMITH,A.EDWARDS,G.T.MONTELIONE,L.TONG,NORTHEAST               
AUTHOR   3 STRUCTURAL GENOMICS CONSORTIUM (NESG)                                
REVDAT   1   09-AUG-05 2AF7    0                                                
JRNL        AUTH   S.M.VOROBIEV,A.KUZIN,T.SKARINA,A.SAVCHENKO,                  
JRNL        AUTH 2 A.SEMESI,C.ARROWSMITH,A.EDWARDS,G.T.MONTELIONE,              
JRNL        AUTH 3 L.TONG                                                       
JRNL        TITL   CRYSTAL STRUCTURE OF THE                                     
JRNL        TITL 2 GAMMA-CARBOXYMUCONOLACTONE DECARBOXYLASE FROM                
JRNL        TITL 3 METHANOBACTERIUM THERMOAUTOTROPHICUM.                        
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.81 ANGSTROMS.                                          
DBREF  2AF7 A    1   125  UNP    O26336   O26336_METTH     1    125             
DBREF  2AF7 B    1   125  UNP    O26336   O26336_METTH     1    125             
DBREF  2AF7 C    1   125  UNP    O26336   O26336_METTH     1    125             
DBREF  2AF7 D    1   125  UNP    O26336   O26336_METTH     1    125             
DBREF  2AF7 E    1   125  UNP    O26336   O26336_METTH     1    125             
DBREF  2AF7 F    1   125  UNP    O26336   O26336_METTH     1    125             
DBREF  2AF7 G    1   125  UNP    O26336   O26336_METTH     1    125             
DBREF  2AF7 H    1   125  UNP    O26336   O26336_METTH     1    125             
DBREF  2AF7 I    1   125  UNP    O26336   O26336_METTH     1    125             
SEQRES   1 A  125  MSE GLU ARG TYR ARG ARG GLY MSE GLU ILE LEU ASN ARG          
SEQRES   2 A  125  MSE ASN ARG LYS SER TYR THR ALA ILE ARG ASP GLU LEU          
SEQRES   3 A  125  GLU ASP VAL ALA PRO ASP LEU ALA ARG PHE VAL ALA GLU          
SEQRES   4 A  125  PHE ALA TYR GLY ASP VAL TYR SER ARG GLY VAL LEU ASP          
SEQRES   5 A  125  LEU LYS THR ARG GLU LEU LEU THR LEU ALA ALA LEU THR          
SEQRES   6 A  125  VAL LEU ARG ALA ASP ASP GLN LEU LYS SER HIS VAL ARG          
SEQRES   7 A  125  GLY ALA LEU ASN ALA GLY CYS SER LYS ASP GLU ILE ILE          
SEQRES   8 A  125  GLU VAL MSE ILE GLN MSE ALA VAL TYR ALA GLY PHE PRO          
SEQRES   9 A  125  ALA ALA ILE ASN ALA VAL LEU ALA ALA LYS GLU VAL PHE          
SEQRES  10 A  125  THR GLU ASN ASP PRO ALA GLU VAL                              
SEQRES   1 C  125  MSE GLU ARG TYR ARG ARG GLY MSE GLU ILE LEU ASN ARG          
SEQRES   2 C  125  MSE ASN ARG LYS SER TYR THR ALA ILE ARG ASP GLU LEU          
SEQRES   3 C  125  GLU ASP VAL ALA PRO ASP LEU ALA ARG PHE VAL ALA GLU          
SEQRES   4 C  125  PHE ALA TYR GLY ASP VAL TYR SER ARG GLY VAL LEU ASP          
SEQRES   5 C  125  LEU LYS THR ARG GLU LEU LEU THR LEU ALA ALA LEU THR          
SEQRES   6 C  125  VAL LEU ARG ALA ASP ASP GLN LEU LYS SER HIS VAL ARG          
SEQRES   7 C  125  GLY ALA LEU ASN ALA GLY CYS SER LYS ASP GLU ILE ILE          
SEQRES   8 C  125  GLU VAL MSE ILE GLN MSE ALA VAL TYR ALA GLY PHE PRO          
SEQRES   9 C  125  ALA ALA ILE ASN ALA VAL LEU ALA ALA LYS GLU VAL PHE          
SEQRES  10 C  125  THR GLU ASN ASP PRO ALA GLU VAL                              
SEQRES   1 D  125  MSE GLU ARG TYR ARG ARG GLY MSE GLU ILE LEU ASN ARG          
SEQRES   2 D  125  MSE ASN ARG LYS SER TYR THR ALA ILE ARG ASP GLU LEU          
SEQRES   3 D  125  GLU ASP VAL ALA PRO ASP LEU ALA ARG PHE VAL ALA GLU          
SEQRES   4 D  125  PHE ALA TYR GLY ASP VAL TYR SER ARG GLY VAL LEU ASP          
SEQRES   5 D  125  LEU LYS THR ARG GLU LEU LEU THR LEU ALA ALA LEU THR          
SEQRES   6 D  125  VAL LEU ARG ALA ASP ASP GLN LEU LYS SER HIS VAL ARG          
SEQRES   7 D  125  GLY ALA LEU ASN ALA GLY CYS SER LYS ASP GLU ILE ILE          
SEQRES   8 D  125  GLU VAL MSE ILE GLN MSE ALA VAL TYR ALA GLY PHE PRO          
SEQRES   9 D  125  ALA ALA ILE ASN ALA VAL LEU ALA ALA LYS GLU VAL PHE          
SEQRES  10 D  125  THR GLU ASN ASP PRO ALA GLU VAL                              
SEQRES   1 E  125  MSE GLU ARG TYR ARG ARG GLY MSE GLU ILE LEU ASN ARG          
SEQRES   2 E  125  MSE ASN ARG LYS SER TYR THR ALA ILE ARG ASP GLU LEU          
SEQRES   3 E  125  GLU ASP VAL ALA PRO ASP LEU ALA ARG PHE VAL ALA GLU          
SEQRES   4 E  125  PHE ALA TYR GLY ASP VAL TYR SER ARG GLY VAL LEU ASP          
SEQRES   5 E  125  LEU LYS THR ARG GLU LEU LEU THR LEU ALA ALA LEU THR          
SEQRES   6 E  125  VAL LEU ARG ALA ASP ASP GLN LEU LYS SER HIS VAL ARG          
SEQRES   7 E  125  GLY ALA LEU ASN ALA GLY CYS SER LYS ASP GLU ILE ILE          
SEQRES   8 E  125  GLU VAL MSE ILE GLN MSE ALA VAL TYR ALA GLY PHE PRO          
SEQRES   9 E  125  ALA ALA ILE ASN ALA VAL LEU ALA ALA LYS GLU VAL PHE          
SEQRES  10 E  125  THR GLU ASN ASP PRO ALA GLU VAL                              
SEQRES   1 I  125  MSE GLU ARG TYR ARG ARG GLY MSE GLU ILE LEU ASN ARG          
SEQRES   2 I  125  MSE ASN ARG LYS SER TYR THR ALA ILE ARG ASP GLU LEU          
SEQRES   3 I  125  GLU ASP VAL ALA PRO ASP LEU ALA ARG PHE VAL ALA GLU          
SEQRES   4 I  125  PHE ALA TYR GLY ASP VAL TYR SER ARG GLY VAL LEU ASP          
SEQRES   5 I  125  LEU LYS THR ARG GLU LEU LEU THR LEU ALA ALA LEU THR          
SEQRES   6 I  125  VAL LEU ARG ALA ASP ASP GLN LEU LYS SER HIS VAL ARG          
SEQRES   7 I  125  GLY ALA LEU ASN ALA GLY CYS SER LYS ASP GLU ILE ILE          
SEQRES   8 I  125  GLU VAL MSE ILE GLN MSE ALA VAL TYR ALA GLY PHE PRO          
SEQRES   9 I  125  ALA ALA ILE ASN ALA VAL LEU ALA ALA LYS GLU VAL PHE          
SEQRES  10 I  125  THR GLU ASN ASP PRO ALA GLU VAL                              
SEQRES   1 F  125  MSE GLU ARG TYR ARG ARG GLY MSE GLU ILE LEU ASN ARG          
SEQRES   2 F  125  MSE ASN ARG LYS SER TYR THR ALA ILE ARG ASP GLU LEU          
SEQRES   3 F  125  GLU ASP VAL ALA PRO ASP LEU ALA ARG PHE VAL ALA GLU          
SEQRES   4 F  125  PHE ALA TYR GLY ASP VAL TYR SER ARG GLY VAL LEU ASP          
SEQRES   5 F  125  LEU LYS THR ARG GLU LEU LEU THR LEU ALA ALA LEU THR          
SEQRES   6 F  125  VAL LEU ARG ALA ASP ASP GLN LEU LYS SER HIS VAL ARG          
SEQRES   7 F  125  GLY ALA LEU ASN ALA GLY CYS SER LYS ASP GLU ILE ILE          
SEQRES   8 F  125  GLU VAL MSE ILE GLN MSE ALA VAL TYR ALA GLY PHE PRO          
SEQRES   9 F  125  ALA ALA ILE ASN ALA VAL LEU ALA ALA LYS GLU VAL PHE          
SEQRES  10 F  125  THR GLU ASN ASP PRO ALA GLU VAL                              
SEQRES   1 B  125  MSE GLU ARG TYR ARG ARG GLY MSE GLU ILE LEU ASN ARG          
SEQRES   2 B  125  MSE ASN ARG LYS SER TYR THR ALA ILE ARG ASP GLU LEU          
SEQRES   3 B  125  GLU ASP VAL ALA PRO ASP LEU ALA ARG PHE VAL ALA GLU          
SEQRES   4 B  125  PHE ALA TYR GLY ASP VAL TYR SER ARG GLY VAL LEU ASP          
SEQRES   5 B  125  LEU LYS THR ARG GLU LEU LEU THR LEU ALA ALA LEU THR          
SEQRES   6 B  125  VAL LEU ARG ALA ASP ASP GLN LEU LYS SER HIS VAL ARG          
SEQRES   7 B  125  GLY ALA LEU ASN ALA GLY CYS SER LYS ASP GLU ILE ILE          
SEQRES   8 B  125  GLU VAL MSE ILE GLN MSE ALA VAL TYR ALA GLY PHE PRO          
SEQRES   9 B  125  ALA ALA ILE ASN ALA VAL LEU ALA ALA LYS GLU VAL PHE          
SEQRES  10 B  125  THR GLU ASN ASP PRO ALA GLU VAL                              
SEQRES   1 G  125  MSE GLU ARG TYR ARG ARG GLY MSE GLU ILE LEU ASN ARG          
SEQRES   2 G  125  MSE ASN ARG LYS SER TYR THR ALA ILE ARG ASP GLU LEU          
SEQRES   3 G  125  GLU ASP VAL ALA PRO ASP LEU ALA ARG PHE VAL ALA GLU          
SEQRES   4 G  125  PHE ALA TYR GLY ASP VAL TYR SER ARG GLY VAL LEU ASP          
SEQRES   5 G  125  LEU LYS THR ARG GLU LEU LEU THR LEU ALA ALA LEU THR          
SEQRES   6 G  125  VAL LEU ARG ALA ASP ASP GLN LEU LYS SER HIS VAL ARG          
SEQRES   7 G  125  GLY ALA LEU ASN ALA GLY CYS SER LYS ASP GLU ILE ILE          
SEQRES   8 G  125  GLU VAL MSE ILE GLN MSE ALA VAL TYR ALA GLY PHE PRO          
SEQRES   9 G  125  ALA ALA ILE ASN ALA VAL LEU ALA ALA LYS GLU VAL PHE          
SEQRES  10 G  125  THR GLU ASN ASP PRO ALA GLU VAL                              
SEQRES   1 H  125  MSE GLU ARG TYR ARG ARG GLY MSE GLU ILE LEU ASN ARG          
SEQRES   2 H  125  MSE ASN ARG LYS SER TYR THR ALA ILE ARG ASP GLU LEU          
SEQRES   3 H  125  GLU ASP VAL ALA PRO ASP LEU ALA ARG PHE VAL ALA GLU          
SEQRES   4 H  125  PHE ALA TYR GLY ASP VAL TYR SER ARG GLY VAL LEU ASP          
SEQRES   5 H  125  LEU LYS THR ARG GLU LEU LEU THR LEU ALA ALA LEU THR          
SEQRES   6 H  125  VAL LEU ARG ALA ASP ASP GLN LEU LYS SER HIS VAL ARG          
SEQRES   7 H  125  GLY ALA LEU ASN ALA GLY CYS SER LYS ASP GLU ILE ILE          
SEQRES   8 H  125  GLU VAL MSE ILE GLN MSE ALA VAL TYR ALA GLY PHE PRO          
SEQRES   9 H  125  ALA ALA ILE ASN ALA VAL LEU ALA ALA LYS GLU VAL PHE          
SEQRES  10 H  125  THR GLU ASN ASP PRO ALA GLU VAL                              
HET    MSE  A   1       8                                                       
HET    MSE  A   8       8                                                       
HET    MSE  A  14       8                                                       
HET    MSE  A  94       8                                                       
HET    MSE  A  97       8                                                       
HET    MSE  B   8       8                                                       
HET    MSE  B  14       8                                                       
HET    MSE  B  94       8                                                       
HET    MSE  B  97       8                                                       
HET    MSE  C   8       8                                                       
HET    MSE  C  14       8                                                       
HET    MSE  C  94       8                                                       
HET    MSE  C  97       8                                                       
HET    MSE  D   1       8                                                       
HET    MSE  D   8       8                                                       
HET    MSE  D  14       8                                                       
HET    MSE  D  94       8                                                       
HET    MSE  D  97       8                                                       
HET    MSE  E   1       8                                                       
HET    MSE  E   8       8                                                       
HET    MSE  E  14       8                                                       
HET    MSE  E  94       8                                                       
HET    MSE  E  97       8                                                       
HET    MSE  F   8       8                                                       
HET    MSE  F  14       8                                                       
HET    MSE  F  94       8                                                       
HET    MSE  F  97       8                                                       
HET    MSE  G   8       8                                                       
HET    MSE  G  14       8                                                       
HET    MSE  G  94       8                                                       
HET    MSE  G  97       8                                                       
HET    MSE  H   8       8                                                       
HET    MSE  H  14       8                                                       
HET    MSE  H  94       8                                                       
HET    MSE  H  97       8                                                       
HET    MSE  I   8       8                                                       
HET    MSE  I  14       8                                                       
HET    MSE  I  94       8                                                       
HET    MSE  I  97       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    39(C5 H11 N O2 SE)                                           
FORMUL  10  HOH   *94(H2 O)                                                     
CRYST1  183.306  119.109   73.620  90.00 102.80  90.00 C 1 2 1      36          
HETATM 1822  N   MSE D   1       0.902  92.227  28.029  1.00102.21           N  
HETATM 1823  CA  MSE D   1       1.536  93.566  28.236  1.00102.21           C  
HETATM 1824  C   MSE D   1       2.305  93.552  29.503  1.00102.21           C  
HETATM 1825  O   MSE D   1       3.530  93.365  29.600  1.00102.21           O  
HETATM 1826  CB  MSE D   1       0.455  94.627  28.412  1.00102.21           C  
HETATM 1827  CG  MSE D   1       0.003  95.272  27.143  1.00102.21           C  
HETATM 1828 SE   MSE D   1      -1.380  96.472  27.627  1.00102.21          SE  
HETATM 1829  CE  MSE D   1      -2.700  96.090  26.259  1.00102.21           C  
ATOM   1830  N   GLU D   2       1.505  93.880  30.490  1.00102.21           N  
ATOM   1831  CA  GLU D   2       1.926  93.893  31.838  1.00102.21           C  
ATOM   1832  C   GLU D   2       0.711  93.506  32.640  1.00102.20           C  
ATOM   1833  O   GLU D   2      -0.234  94.255  32.784  1.00102.21           O  
ATOM   1834  CB  GLU D   2       2.484  95.337  32.311  1.00102.21           C  
ATOM   1835  N   ARG D   3       0.759  92.317  33.188  1.00 60.94           N  
ATOM   1836  CA  ARG D   3      -0.291  91.857  34.064  1.00 60.95           C  
ATOM   1837  C   ARG D   3       0.545  90.790  34.702  1.00 60.94           C  
ATOM   1838  O   ARG D   3       0.200  90.241  35.730  1.00 60.93           O  
ATOM   1839  CB  ARG D   3      -1.420  91.235  33.285  1.00102.20           C  
ATOM   1840  CG  ARG D   3      -1.180  89.770  32.962  1.00102.21           C  
ATOM   1841  CD  ARG D   3      -1.852  89.419  31.652  1.00102.21           C  
ATOM   1842  NE  ARG D   3      -1.820  87.990  31.333  1.00102.21           N  
ATOM   1843  CZ  ARG D   3      -2.139  87.498  30.138  1.00102.21           C  
ATOM   1844  NH1 ARG D   3      -2.500  88.325  29.177  1.00102.21           N  
ATOM   1845  NH2 ARG D   3      -2.116  86.192  29.897  1.00102.21           N  
ATOM   1846  N   TYR D   4       1.644  90.497  34.005  1.00 76.47           N  
ATOM   1847  CA  TYR D   4       2.671  89.554  34.395  1.00 76.47           C  
ATOM   1848  C   TYR D   4       2.605  89.456  35.915  1.00 76.47           C  
ATOM   1849  O   TYR D   4       2.448  88.368  36.476  1.00 76.47           O  
ATOM   1850  CB  TYR D   4       4.009  90.133  33.898  1.00 83.32           C  
ATOM   1851  CG  TYR D   4       5.293  89.596  34.494  1.00 83.32           C  
ATOM   1852  CD1 TYR D   4       5.932  88.488  33.949  1.00 83.33           C  
ATOM   1853  CD2 TYR D   4       5.895  90.231  35.583  1.00 83.34           C  
ATOM   1854  CE1 TYR D   4       7.144  88.024  34.470  1.00 83.33           C  
ATOM   1855  CE2 TYR D   4       7.106  89.777  36.115  1.00 83.33           C  
ATOM   1856  CZ  TYR D   4       7.725  88.672  35.556  1.00 83.33           C  
ATOM   1857  OH  TYR D   4       8.910  88.208  36.094  1.00 83.34           O  
ATOM   1858  N   ARG D   5       2.658  90.620  36.560  1.00 60.50           N  
ATOM   1859  CA  ARG D   5       2.619  90.756  38.015  1.00 60.52           C  
ATOM   1860  C   ARG D   5       1.337  90.253  38.678  1.00 60.52           C  
ATOM   1861  O   ARG D   5       1.383  89.710  39.780  1.00 60.51           O  
ATOM   1862  CB  ARG D   5       2.829  92.218  38.396  1.00102.20           C  
ATOM   1863  CG  ARG D   5       3.177  92.434  39.862  1.00102.21           C  
ATOM   1864  CD  ARG D   5       4.617  92.012  40.142  1.00102.21           C  
ATOM   1865  NE  ARG D   5       5.061  92.377  41.485  1.00102.21           N  
ATOM   1866  CZ  ARG D   5       6.336  92.429  41.866  1.00102.21           C  
ATOM   1867  NH1 ARG D   5       7.305  92.138  41.005  1.00102.21           N  
ATOM   1868  NH2 ARG D   5       6.643  92.781  43.108  1.00102.21           N  
ATOM   1869  N   ARG D   6       0.202  90.465  38.016  1.00102.20           N  
ATOM   1870  CA  ARG D   6      -1.112  90.028  38.503  1.00102.20           C  
ATOM   1871  C   ARG D   6      -1.029  88.556  38.893  1.00102.20           C  
ATOM   1872  O   ARG D   6      -1.768  88.079  39.764  1.00102.21           O  
ATOM   1873  CB  ARG D   6      -2.149  90.267  37.389  1.00102.21           C  
ATOM   1874  CG  ARG D   6      -3.375  89.356  37.299  1.00102.21           C  
ATOM   1875  CD  ARG D   6      -3.968  89.537  35.893  1.00102.21           C  
ATOM   1876  NE  ARG D   6      -5.293  88.954  35.691  1.00102.21           N  
ATOM   1877  CZ  ARG D   6      -5.854  88.776  34.496  1.00102.21           C  
ATOM   1878  NH1 ARG D   6      -5.207  89.129  33.390  1.00102.21           N  
ATOM   1879  NH2 ARG D   6      -7.067  88.251  34.399  1.00102.21           N  
ATOM   1880  N   GLY D   7      -0.096  87.855  38.253  1.00 63.09           N  
ATOM   1881  CA  GLY D   7       0.097  86.447  38.531  1.00 63.08           C  
ATOM   1882  C   GLY D   7       1.416  86.178  39.220  1.00 63.07           C  
ATOM   1883  O   GLY D   7       1.717  85.044  39.583  1.00 63.07           O  
HETATM 1884  N   MSE D   8       2.203  87.222  39.419  1.00 64.46           N  
HETATM 1885  CA  MSE D   8       3.500  87.065  40.062  1.00 64.44           C  
HETATM 1886  C   MSE D   8       3.475  87.202  41.585  1.00 64.44           C  
HETATM 1887  O   MSE D   8       4.158  86.453  42.282  1.00 64.43           O  
HETATM 1888  CB  MSE D   8       4.483  88.077  39.495  1.00102.20           C  
HETATM 1889  CG  MSE D   8       5.920  87.696  39.715  1.00102.21           C  
HETATM 1890 SE   MSE D   8       6.514  86.416  38.420  1.00102.21          SE  
HETATM 1891  CE  MSE D   8       8.212  86.036  39.238  1.00102.21           C  
ATOM   1892  N   GLU D   9       2.718  88.163  42.107  1.00 74.96           N  
ATOM   1893  CA  GLU D   9       2.652  88.323  43.555  1.00 74.97           C  
ATOM   1894  C   GLU D   9       2.266  86.950  44.086  1.00 74.94           C  
ATOM   1895  O   GLU D   9       2.656  86.557  45.193  1.00 74.94           O  
ATOM   1896  CB  GLU D   9       1.609  89.379  43.937  1.00102.20           C  
ATOM   1897  CG  GLU D   9       0.195  89.080  43.478  1.00102.21           C  
ATOM   1898  CD  GLU D   9      -0.652  88.457  44.564  1.00102.21           C  
ATOM   1899  OE1 GLU D   9      -1.821  88.131  44.282  1.00102.21           O  
ATOM   1900  OE2 GLU D   9      -0.157  88.299  45.698  1.00102.21           O  
ATOM   1901  N   ILE D  10       1.516  86.222  43.256  1.00 66.35           N  
ATOM   1902  CA  ILE D  10       1.065  84.866  43.559  1.00 66.33           C  
ATOM   1903  C   ILE D  10       2.294  83.977  43.605  1.00 66.37           C  
ATOM   1904  O   ILE D  10       2.708  83.494  44.654  1.00 66.37           O  
ATOM   1905  CB  ILE D  10       0.193  84.271  42.434  1.00 23.42           C  
ATOM   1906  CG1 ILE D  10      -0.896  85.239  41.977  1.00 23.41           C  
ATOM   1907  CG2 ILE D  10      -0.439  83.005  42.921  1.00 23.41           C  
ATOM   1908  CD1 ILE D  10      -1.917  85.557  43.045  1.00 54.13           C  
ATOM   1909  N   LEU D  11       2.860  83.769  42.424  1.00 96.03           N  
ATOM   1910  CA  LEU D  11       4.032  82.937  42.246  1.00 96.04           C  
ATOM   1911  C   LEU D  11       5.096  83.229  43.299  1.00 96.04           C  
ATOM   1912  O   LEU D  11       5.482  82.343  44.061  1.00 96.04           O  
ATOM   1913  CB  LEU D  11       4.586  83.149  40.833  1.00 67.53           C  
ATOM   1914  CG  LEU D  11       5.336  81.986  40.183  1.00 67.52           C  
ATOM   1915  CD1 LEU D  11       4.582  80.693  40.416  1.00 67.54           C  
ATOM   1916  CD2 LEU D  11       5.483  82.243  38.701  1.00 67.54           C  
ATOM   1917  N   ASN D  12       5.549  84.477  43.353  1.00102.21           N  
ATOM   1918  CA  ASN D  12       6.579  84.893  44.301  1.00102.21           C  
ATOM   1919  C   ASN D  12       6.172  84.668  45.759  1.00102.21           C  
ATOM   1920  O   ASN D  12       6.985  84.833  46.671  1.00102.21           O  
ATOM   1921  CB  ASN D  12       6.915  86.367  44.075  1.00 95.73           C  
ATOM   1922  CG  ASN D  12       8.403  86.639  44.126  1.00 95.73           C  
ATOM   1923  OD1 ASN D  12       9.037  86.501  45.172  1.00 95.73           O  
ATOM   1924  ND2 ASN D  12       8.974  87.024  42.989  1.00 95.73           N  
ATOM   1925  N   ARG D  13       4.913  84.281  45.958  1.00102.21           N  
ATOM   1926  CA  ARG D  13       4.340  84.018  47.284  1.00102.21           C  
ATOM   1927  C   ARG D  13       4.405  82.550  47.709  1.00102.21           C  
ATOM   1928  O   ARG D  13       4.905  82.221  48.786  1.00102.21           O  
ATOM   1929  CB  ARG D  13       2.868  84.415  47.299  1.00102.21           C  
ATOM   1930  CG  ARG D  13       2.517  85.706  47.983  1.00102.21           C  
ATOM   1931  CD  ARG D  13       1.020  85.964  47.821  1.00102.21           C  
ATOM   1932  NE  ARG D  13       0.252  84.727  47.665  1.00102.21           N  
ATOM   1933  CZ  ARG D  13      -1.067  84.679  47.491  1.00102.21           C  
ATOM   1934  NH1 ARG D  13      -1.774  85.798  47.455  1.00102.21           N  
ATOM   1935  NH2 ARG D  13      -1.680  83.513  47.345  1.00102.21           N  
HETATM 1936  N   MSE D  14       3.860  81.686  46.855  1.00102.21           N  
HETATM 1937  CA  MSE D  14       3.781  80.246  47.091  1.00102.21           C  
HETATM 1938  C   MSE D  14       5.040  79.466  46.830  1.00102.21           C  
HETATM 1939  O   MSE D  14       5.575  78.773  47.690  1.00102.21           O  
HETATM 1940  CB  MSE D  14       2.783  79.601  46.161  1.00102.21           C  
HETATM 1941  CG  MSE D  14       1.507  80.305  45.914  1.00102.21           C  
HETATM 1942 SE   MSE D  14       0.813  79.196  44.492  1.00 17.43          SE  
HETATM 1943  CE  MSE D  14       0.708  77.531  45.511  1.00102.21           C  
ATOM   1944  N   ASN D  15       5.467  79.567  45.585  1.00102.21           N  
ATOM   1945  CA  ASN D  15       6.594  78.827  45.087  1.00102.21           C  
ATOM   1946  C   ASN D  15       7.591  79.761  44.435  1.00102.21           C  
ATOM   1947  O   ASN D  15       7.979  79.550  43.288  1.00102.21           O  
ATOM   1948  CB  ASN D  15       6.038  77.853  44.066  1.00 80.96           C  
ATOM   1949  CG  ASN D  15       6.749  76.544  44.054  1.00 80.95           C  
ATOM   1950  OD1 ASN D  15       6.239  75.574  43.493  1.00 80.95           O  
ATOM   1951  ND2 ASN D  15       7.933  76.491  44.657  1.00 80.95           N  
ATOM   1952  N   ARG D  16       7.989  80.805  45.147  1.00102.21           N  
ATOM   1953  CA  ARG D  16       8.953  81.730  44.584  1.00102.21           C  
ATOM   1954  C   ARG D  16      10.194  80.959  44.159  1.00102.21           C  
ATOM   1955  O   ARG D  16      10.579  80.988  42.988  1.00102.21           O  
ATOM   1956  CB  ARG D  16       9.269  82.836  45.578  1.00102.21           C  
ATOM   1957  N   LYS D  17      10.810  80.263  45.111  1.00102.21           N  
ATOM   1958  CA  LYS D  17      12.003  79.473  44.828  1.00102.21           C  
ATOM   1959  C   LYS D  17      11.875  78.781  43.478  1.00102.20           C  
ATOM   1960  O   LYS D  17      12.836  78.712  42.716  1.00102.21           O  
ATOM   1961  CB  LYS D  17      12.247  78.453  45.942  1.00102.21           C  
ATOM   1962  CG  LYS D  17      12.453  79.071  47.315  1.00 20.31           C  
ATOM   1963  CD  LYS D  17      12.928  78.035  48.321  1.00 20.31           C  
ATOM   1964  CE  LYS D  17      13.134  78.652  49.694  1.00 20.31           C  
ATOM   1965  NZ  LYS D  17      13.599  77.649  50.691  1.00 20.31           N  
ATOM   1966  N   SER D  18      10.684  78.269  43.181  1.00 77.26           N  
ATOM   1967  CA  SER D  18      10.479  77.586  41.914  1.00 77.26           C  
ATOM   1968  C   SER D  18      10.552  78.474  40.678  1.00 77.23           C  
ATOM   1969  O   SER D  18      11.388  78.230  39.813  1.00 77.23           O  
ATOM   1970  CB  SER D  18       9.166  76.813  41.926  1.00102.20           C  
ATOM   1971  OG  SER D  18       9.424  75.441  42.175  1.00102.21           O  
ATOM   1972  N   TYR D  19       9.697  79.491  40.570  1.00 75.71           N  
ATOM   1973  CA  TYR D  19       9.765  80.354  39.390  1.00 75.72           C  
ATOM   1974  C   TYR D  19      11.222  80.752  39.156  1.00 75.72           C  
ATOM   1975  O   TYR D  19      11.698  80.783  38.018  1.00 75.72           O  
ATOM   1976  CB  TYR D  19       8.921  81.622  39.557  1.00 80.07           C  
ATOM   1977  CG  TYR D  19       9.027  82.558  38.363  1.00 80.07           C  
ATOM   1978  CD1 TYR D  19       8.303  82.320  37.190  1.00 80.08           C  
ATOM   1979  CD2 TYR D  19       9.894  83.649  38.387  1.00 80.09           C  
ATOM   1980  CE1 TYR D  19       8.443  83.149  36.071  1.00 80.08           C  
ATOM   1981  CE2 TYR D  19      10.042  84.482  37.276  1.00 80.09           C  
ATOM   1982  CZ  TYR D  19       9.318  84.226  36.123  1.00 80.09           C  
ATOM   1983  OH  TYR D  19       9.486  85.035  35.018  1.00 80.09           O  
ATOM   1984  N   THR D  20      11.923  81.061  40.244  1.00 51.37           N  
ATOM   1985  CA  THR D  20      13.331  81.434  40.162  1.00 51.37           C  
ATOM   1986  C   THR D  20      14.107  80.314  39.473  1.00 51.39           C  
ATOM   1987  O   THR D  20      14.800  80.542  38.482  1.00 51.38           O  
ATOM   1988  CB  THR D  20      13.950  81.660  41.565  1.00 77.06           C  
ATOM   1989  OG1 THR D  20      12.980  81.372  42.578  1.00 77.06           O  
ATOM   1990  CG2 THR D  20      14.430  83.098  41.707  1.00 77.06           C  
ATOM   1991  N   ALA D  21      13.978  79.105  40.008  1.00 75.41           N  
ATOM   1992  CA  ALA D  21      14.654  77.935  39.468  1.00 75.42           C  
ATOM   1993  C   ALA D  21      14.478  77.814  37.959  1.00 75.42           C  
ATOM   1994  O   ALA D  21      15.399  77.397  37.258  1.00 75.41           O  
ATOM   1995  CB  ALA D  21      14.141  76.674  40.156  1.00100.19           C  
ATOM   1996  N   ILE D  22      13.303  78.175  37.454  1.00 87.70           N  
ATOM   1997  CA  ILE D  22      13.081  78.073  36.024  1.00 87.69           C  
ATOM   1998  C   ILE D  22      13.539  79.292  35.236  1.00 87.67           C  
ATOM   1999  O   ILE D  22      13.867  79.170  34.054  1.00 87.69           O  
ATOM   2000  CB  ILE D  22      11.623  77.716  35.710  1.00 60.76           C  
ATOM   2001  CG1 ILE D  22      11.460  76.196  35.821  1.00 60.75           C  
ATOM   2002  CG2 ILE D  22      11.242  78.198  34.323  1.00 60.76           C  
ATOM   2003  CD1 ILE D  22      10.223  75.647  35.149  1.00 54.13           C  
ATOM   2004  N   ARG D  23      13.562  80.463  35.870  1.00 34.24           N  
ATOM   2005  CA  ARG D  23      14.090  81.629  35.189  1.00 34.23           C  
ATOM   2006  C   ARG D  23      15.495  81.202  34.747  1.00 34.22           C  
ATOM   2007  O   ARG D  23      16.132  81.871  33.981  1.00 34.21           O  
ATOM   2008  CB  ARG D  23      14.213  82.827  36.134  1.00102.19           C  
ATOM   2009  CG  ARG D  23      12.980  83.690  36.221  1.00102.20           C  
ATOM   2010  CD  ARG D  23      13.128  84.801  37.269  1.00102.21           C  
ATOM   2011  NE  ARG D  23      14.271  85.683  37.035  1.00102.21           N  
ATOM   2012  CZ  ARG D  23      15.503  85.466  37.496  1.00102.21           C  
ATOM   2013  NH1 ARG D  23      15.766  84.387  38.230  1.00102.21           N  
ATOM   2014  NH2 ARG D  23      16.479  86.325  37.211  1.00102.21           N  
ATOM   2015  N   ASP D  24      15.973  80.064  35.214  1.00 35.63           N  
ATOM   2016  CA  ASP D  24      17.297  79.568  34.853  1.00 35.64           C  
ATOM   2017  C   ASP D  24      17.310  78.687  33.566  1.00 35.64           C  
ATOM   2018  O   ASP D  24      18.046  77.693  33.448  1.00 35.63           O  
ATOM   2019  CB  ASP D  24      17.798  78.754  36.019  1.00102.19           C  
ATOM   2020  CG  ASP D  24      17.860  79.546  37.308  1.00102.21           C  
ATOM   2021  OD1 ASP D  24      18.374  80.687  37.300  1.00102.21           O  
ATOM   2022  OD2 ASP D  24      17.421  79.003  38.345  1.00102.21           O  
ATOM   2023  N   GLU D  25      16.415  78.999  32.647  1.00 83.45           N  
ATOM   2024  CA  GLU D  25      16.345  78.327  31.358  1.00 83.46           C  
ATOM   2025  C   GLU D  25      16.264  79.606  30.530  1.00 83.49           C  
ATOM   2026  O   GLU D  25      15.886  79.625  29.359  1.00 83.49           O  
ATOM   2027  CB  GLU D  25      15.060  77.533  31.243  1.00 63.26           C  
ATOM   2028  CG  GLU D  25      13.867  78.410  31.225  1.00 63.25           C  
ATOM   2029  CD  GLU D  25      12.611  77.622  31.299  1.00 63.25           C  
ATOM   2030  OE1 GLU D  25      12.558  76.717  32.147  1.00 63.25           O  
ATOM   2031  OE2 GLU D  25      11.675  77.900  30.526  1.00 63.25           O  
ATOM   2032  N   LEU D  26      16.621  80.682  31.223  1.00 68.37           N  
ATOM   2033  CA  LEU D  26      16.636  82.044  30.726  1.00 68.37           C  
ATOM   2034  C   LEU D  26      17.623  82.181  29.591  1.00 68.37           C  
ATOM   2035  O   LEU D  26      17.653  83.203  28.925  1.00 68.38           O  
ATOM   2036  CB  LEU D  26      17.040  82.955  31.889  1.00102.20           C  
ATOM   2037  CG  LEU D  26      17.082  84.476  31.968  1.00102.21           C  
ATOM   2038  CD1 LEU D  26      16.836  84.892  33.423  1.00102.21           C  
ATOM   2039  CD2 LEU D  26      18.432  84.965  31.502  1.00102.21           C  
ATOM   2040  N   GLU D  27      18.408  81.134  29.351  1.00 68.52           N  
ATOM   2041  CA  GLU D  27      19.445  81.167  28.324  1.00 68.53           C  
ATOM   2042  C   GLU D  27      19.204  80.056  27.290  1.00 68.53           C  
ATOM   2043  O   GLU D  27      18.872  80.397  26.140  1.00 68.53           O  
ATOM   2044  CB  GLU D  27      20.813  80.990  28.990  1.00102.20           C  
ATOM   2045  N   ASP D  28      19.386  78.767  27.738  1.00102.20           N  
ATOM   2046  CA  ASP D  28      19.234  77.529  26.944  1.00102.20           C  
ATOM   2047  C   ASP D  28      17.952  77.702  26.098  1.00102.20           C  
ATOM   2048  O   ASP D  28      17.979  77.402  24.902  1.00102.21           O  
ATOM   2049  CB  ASP D  28      19.328  76.290  27.764  1.00 94.70           C  
ATOM   2050  N   VAL D  29      16.907  78.366  26.585  1.00 51.20           N  
ATOM   2051  CA  VAL D  29      16.118  79.045  25.498  1.00 51.20           C  
ATOM   2052  C   VAL D  29      15.229  80.251  25.830  1.00 51.19           C  
ATOM   2053  O   VAL D  29      15.491  81.020  26.732  1.00 51.17           O  
ATOM   2054  CB  VAL D  29      15.353  78.176  24.600  1.00102.20           C  
ATOM   2055  N   ALA D  30      14.062  80.309  25.200  1.00 80.31           N  
ATOM   2056  CA  ALA D  30      13.220  81.459  25.441  1.00 80.32           C  
ATOM   2057  C   ALA D  30      12.609  81.818  26.779  1.00 80.34           C  
ATOM   2058  O   ALA D  30      11.643  81.204  27.219  1.00 80.34           O  
ATOM   2059  CB  ALA D  30      12.165  81.521  24.382  1.00  9.02           C  
ATOM   2060  N   PRO D  31      13.162  82.862  27.424  1.00102.20           N  
ATOM   2061  CA  PRO D  31      12.693  83.376  28.704  1.00102.20           C  
ATOM   2062  C   PRO D  31      11.195  83.411  28.394  1.00102.20           C  
ATOM   2063  O   PRO D  31      10.360  83.110  29.245  1.00102.21           O  
ATOM   2064  CB  PRO D  31      13.367  84.751  28.768  1.00102.21           C  
ATOM   2065  CG  PRO D  31      14.707  84.443  28.186  1.00102.21           C  
ATOM   2066  CD  PRO D  31      14.392  83.549  27.001  1.00102.21           C  
ATOM   2067  N   ASP D  32      10.896  83.680  27.118  1.00 51.80           N  
ATOM   2068  CA  ASP D  32       9.533  83.712  26.591  1.00 51.79           C  
ATOM   2069  C   ASP D  32       8.647  82.587  27.138  1.00 51.78           C  
ATOM   2070  O   ASP D  32       7.435  82.748  27.205  1.00 51.76           O  
ATOM   2071  CB  ASP D  32       9.552  83.641  25.059  1.00 83.72           C  
ATOM   2072  CG  ASP D  32       9.693  85.006  24.407  1.00 83.74           C  
ATOM   2073  OD1 ASP D  32       8.778  85.845  24.558  1.00 83.74           O  
ATOM   2074  OD2 ASP D  32      10.718  85.240  23.738  1.00 83.74           O  
ATOM   2075  N   LEU D  33       9.244  81.458  27.521  1.00 59.01           N  
ATOM   2076  CA  LEU D  33       8.486  80.333  28.068  1.00 58.99           C  
ATOM   2077  C   LEU D  33       8.189  80.612  29.528  1.00 58.99           C  
ATOM   2078  O   LEU D  33       7.055  80.477  29.968  1.00 59.01           O  
ATOM   2079  CB  LEU D  33       9.269  79.017  27.935  1.00 25.95           C  
ATOM   2080  CG  LEU D  33       8.558  77.695  28.285  1.00 25.95           C  
ATOM   2081  CD1 LEU D  33       7.117  77.668  27.734  1.00 25.94           C  
ATOM   2082  CD2 LEU D  33       9.382  76.550  27.704  1.00 25.94           C  
ATOM   2083  N   ALA D  34       9.206  80.997  30.289  1.00 24.71           N  
ATOM   2084  CA  ALA D  34       8.983  81.316  31.696  1.00 24.70           C  
ATOM   2085  C   ALA D  34       8.039  82.526  31.772  1.00 24.70           C  
ATOM   2086  O   ALA D  34       7.330  82.709  32.762  1.00 24.70           O  
ATOM   2087  CB  ALA D  34      10.300  81.621  32.398  1.00 38.66           C  
ATOM   2088  N   ARG D  35       8.019  83.341  30.718  1.00 63.52           N  
ATOM   2089  CA  ARG D  35       7.136  84.500  30.685  1.00 63.53           C  
ATOM   2090  C   ARG D  35       5.703  83.973  30.662  1.00 63.53           C  
ATOM   2091  O   ARG D  35       4.919  84.271  31.563  1.00 63.53           O  
ATOM   2092  CB  ARG D  35       7.398  85.349  29.437  1.00102.20           C  
ATOM   2093  CG  ARG D  35       6.728  86.727  29.467  1.00102.21           C  
ATOM   2094  CD  ARG D  35       6.920  87.510  28.161  1.00102.21           C  
ATOM   2095  NE  ARG D  35       6.157  86.953  27.040  1.00102.21           N  
ATOM   2096  CZ  ARG D  35       6.178  87.442  25.802  1.00102.21           C  
ATOM   2097  NH1 ARG D  35       6.925  88.503  25.516  1.00102.21           N  
ATOM   2098  NH2 ARG D  35       5.456  86.872  24.843  1.00102.21           N  
ATOM   2099  N   PHE D  36       5.376  83.180  29.638  1.00 37.16           N  
ATOM   2100  CA  PHE D  36       4.036  82.591  29.492  1.00 37.16           C  
ATOM   2101  C   PHE D  36       3.564  81.854  30.757  1.00 37.15           C  
ATOM   2102  O   PHE D  36       2.361  81.698  30.968  1.00 37.14           O  
ATOM   2103  CB  PHE D  36       3.973  81.600  28.317  1.00 39.51           C  
ATOM   2104  CG  PHE D  36       4.320  82.195  26.981  1.00 39.52           C  
ATOM   2105  CD1 PHE D  36       3.787  83.412  26.575  1.00 39.52           C  
ATOM   2106  CD2 PHE D  36       5.173  81.515  26.112  1.00 39.52           C  
ATOM   2107  CE1 PHE D  36       4.101  83.948  25.326  1.00 39.51           C  
ATOM   2108  CE2 PHE D  36       5.493  82.043  24.860  1.00 39.52           C  
ATOM   2109  CZ  PHE D  36       4.951  83.264  24.471  1.00 39.52           C  
ATOM   2110  N   VAL D  37       4.487  81.380  31.590  1.00 29.35           N  
ATOM   2111  CA  VAL D  37       4.055  80.700  32.799  1.00 29.35           C  
ATOM   2112  C   VAL D  37       3.342  81.715  33.659  1.00 29.35           C  
ATOM   2113  O   VAL D  37       2.130  81.663  33.827  1.00 29.35           O  
ATOM   2114  CB  VAL D  37       5.230  80.114  33.624  1.00 30.33           C  
ATOM   2115  CG1 VAL D  37       4.834  79.988  35.091  1.00 30.34           C  
ATOM   2116  CG2 VAL D  37       5.579  78.742  33.119  1.00 30.34           C  
ATOM   2117  N   ALA D  38       4.116  82.652  34.189  1.00 26.59           N  
ATOM   2118  CA  ALA D  38       3.596  83.688  35.065  1.00 26.60           C  
ATOM   2119  C   ALA D  38       2.532  84.524  34.362  1.00 26.59           C  
ATOM   2120  O   ALA D  38       1.566  84.984  34.966  1.00 26.59           O  
ATOM   2121  CB  ALA D  38       4.747  84.580  35.518  1.00 47.54           C  
ATOM   2122  N   GLU D  39       2.712  84.680  33.065  1.00 42.08           N  
ATOM   2123  CA  GLU D  39       1.830  85.487  32.267  1.00 42.09           C  
ATOM   2124  C   GLU D  39       0.562  84.836  31.714  1.00 42.09           C  
ATOM   2125  O   GLU D  39      -0.218  85.516  31.057  1.00 42.08           O  
ATOM   2126  CB  GLU D  39       2.642  86.047  31.125  1.00 87.24           C  
ATOM   2127  CG  GLU D  39       2.240  87.411  30.706  1.00 87.25           C  
ATOM   2128  CD  GLU D  39       3.167  87.942  29.647  1.00 87.27           C  
ATOM   2129  OE1 GLU D  39       3.223  87.322  28.562  1.00 87.27           O  
ATOM   2130  OE2 GLU D  39       3.845  88.963  29.899  1.00 87.27           O  
ATOM   2131  N   PHE D  40       0.338  83.544  31.947  1.00 39.42           N  
ATOM   2132  CA  PHE D  40      -0.865  82.894  31.419  1.00 39.42           C  
ATOM   2133  C   PHE D  40      -1.396  81.846  32.376  1.00 39.43           C  
ATOM   2134  O   PHE D  40      -2.603  81.746  32.612  1.00 39.42           O  
ATOM   2135  CB  PHE D  40      -0.565  82.227  30.072  1.00 54.73           C  
ATOM   2136  CG  PHE D  40      -1.715  81.428  29.514  1.00 54.73           C  
ATOM   2137  CD1 PHE D  40      -2.803  82.062  28.926  1.00 54.73           C  
ATOM   2138  CD2 PHE D  40      -1.703  80.034  29.574  1.00 54.72           C  
ATOM   2139  CE1 PHE D  40      -3.868  81.327  28.406  1.00 54.73           C  
ATOM   2140  CE2 PHE D  40      -2.766  79.287  29.058  1.00 54.73           C  
ATOM   2141  CZ  PHE D  40      -3.852  79.940  28.469  1.00 54.73           C  
ATOM   2142  N   ALA D  41      -0.473  81.055  32.913  1.00 47.40           N  
ATOM   2143  CA  ALA D  41      -0.806  79.993  33.842  1.00 47.41           C  
ATOM   2144  C   ALA D  41      -1.279  80.643  35.120  1.00 47.42           C  
ATOM   2145  O   ALA D  41      -2.410  80.440  35.558  1.00 47.41           O  
ATOM   2146  CB  ALA D  41       0.425  79.128  34.110  1.00 48.00           C  
ATOM   2147  N   TYR D  42      -0.399  81.431  35.713  1.00 63.71           N  
ATOM   2148  CA  TYR D  42      -0.725  82.129  36.932  1.00 63.72           C  
ATOM   2149  C   TYR D  42      -1.343  83.486  36.602  1.00 63.72           C  
ATOM   2150  O   TYR D  42      -1.988  84.119  37.442  1.00 63.73           O  
ATOM   2151  CB  TYR D  42       0.532  82.307  37.767  1.00 32.95           C  
ATOM   2152  CG  TYR D  42       1.033  81.019  38.350  1.00 32.95           C  
ATOM   2153  CD1 TYR D  42       1.845  80.159  37.615  1.00 32.93           C  
ATOM   2154  CD2 TYR D  42       0.666  80.639  39.633  1.00 32.93           C  
ATOM   2155  CE1 TYR D  42       2.275  78.947  38.153  1.00 32.93           C  
ATOM   2156  CE2 TYR D  42       1.083  79.435  40.179  1.00 32.93           C  
ATOM   2157  CZ  TYR D  42       1.885  78.590  39.436  1.00 32.93           C  
ATOM   2158  OH  TYR D  42       2.265  77.383  39.984  1.00 32.94           O  
ATOM   2159  N   GLY D  43      -1.155  83.926  35.365  1.00 71.02           N  
ATOM   2160  CA  GLY D  43      -1.694  85.206  34.964  1.00 71.02           C  
ATOM   2161  C   GLY D  43      -3.202  85.255  34.842  1.00 71.01           C  
ATOM   2162  O   GLY D  43      -3.836  86.170  35.354  1.00 71.02           O  
ATOM   2163  N   ASP D  44      -3.797  84.269  34.188  1.00 54.14           N  
ATOM   2164  CA  ASP D  44      -5.231  84.310  34.003  1.00 54.13           C  
ATOM   2165  C   ASP D  44      -6.002  83.118  34.483  1.00 54.15           C  
ATOM   2166  O   ASP D  44      -7.225  83.186  34.600  1.00 54.13           O  
ATOM   2167  CB  ASP D  44      -5.564  84.497  32.531  1.00 61.39           C  
ATOM   2168  CG  ASP D  44      -4.802  85.626  31.907  1.00 61.39           C  
ATOM   2169  OD1 ASP D  44      -4.679  86.683  32.560  1.00 61.39           O  
ATOM   2170  OD2 ASP D  44      -4.336  85.457  30.760  1.00 61.38           O  
ATOM   2171  N   VAL D  45      -5.320  82.016  34.752  1.00 36.74           N  
ATOM   2172  CA  VAL D  45      -6.052  80.846  35.176  1.00 36.73           C  
ATOM   2173  C   VAL D  45      -6.121  80.718  36.687  1.00 36.74           C  
ATOM   2174  O   VAL D  45      -7.212  80.601  37.233  1.00 36.75           O  
ATOM   2175  CB  VAL D  45      -5.473  79.577  34.506  1.00 29.77           C  
ATOM   2176  CG1 VAL D  45      -6.315  78.353  34.876  1.00 29.77           C  
ATOM   2177  CG2 VAL D  45      -5.466  79.760  32.984  1.00 29.77           C  
ATOM   2178  N   TYR D  46      -4.976  80.759  37.367  1.00 26.00           N  
ATOM   2179  CA  TYR D  46      -4.948  80.650  38.834  1.00 25.99           C  
ATOM   2180  C   TYR D  46      -5.563  81.871  39.509  1.00 25.98           C  
ATOM   2181  O   TYR D  46      -6.182  81.769  40.566  1.00 25.97           O  
ATOM   2182  CB  TYR D  46      -3.517  80.495  39.340  1.00 79.02           C  
ATOM   2183  CG  TYR D  46      -3.051  79.072  39.492  1.00 79.03           C  
ATOM   2184  CD1 TYR D  46      -2.904  78.240  38.383  1.00 79.04           C  
ATOM   2185  CD2 TYR D  46      -2.728  78.562  40.749  1.00 79.05           C  
ATOM   2186  CE1 TYR D  46      -2.437  76.930  38.525  1.00 79.04           C  
ATOM   2187  CE2 TYR D  46      -2.261  77.255  40.902  1.00 79.05           C  
ATOM   2188  CZ  TYR D  46      -2.118  76.446  39.788  1.00 79.05           C  
ATOM   2189  OH  TYR D  46      -1.648  75.162  39.943  1.00 79.04           O  
ATOM   2190  N   SER D  47      -5.376  83.035  38.905  1.00 45.25           N  
ATOM   2191  CA  SER D  47      -5.917  84.256  39.473  1.00 45.25           C  
ATOM   2192  C   SER D  47      -7.431  84.180  39.597  1.00 45.25           C  
ATOM   2193  O   SER D  47      -7.999  84.738  40.526  1.00 45.25           O  
ATOM   2194  CB  SER D  47      -5.495  85.464  38.629  1.00 52.12           C  
ATOM   2195  OG  SER D  47      -5.548  85.180  37.239  1.00 52.12           O  
ATOM   2196  N   ARG D  48      -8.070  83.475  38.666  1.00 39.98           N  
ATOM   2197  CA  ARG D  48      -9.526  83.311  38.660  1.00 39.99           C  
ATOM   2198  C   ARG D  48     -10.071  82.990  40.047  1.00 40.00           C  
ATOM   2199  O   ARG D  48      -9.344  82.501  40.913  1.00 40.00           O  
ATOM   2200  CB  ARG D  48      -9.926  82.216  37.670  1.00 52.00           C  
ATOM   2201  CG  ARG D  48     -10.314  82.739  36.304  1.00 52.00           C  
ATOM   2202  CD  ARG D  48     -10.257  81.647  35.252  1.00 52.00           C  
ATOM   2203  NE  ARG D  48     -11.048  81.987  34.072  1.00 52.00           N  
ATOM   2204  CZ  ARG D  48     -12.370  81.880  34.009  1.00 52.00           C  
ATOM   2205  NH1 ARG D  48     -13.055  81.439  35.056  1.00 51.99           N  
ATOM   2206  NH2 ARG D  48     -13.015  82.214  32.905  1.00 52.00           N  
ATOM   2207  N   GLY D  49     -11.354  83.245  40.266  1.00 77.33           N  
ATOM   2208  CA  GLY D  49     -11.884  82.997  41.592  1.00 77.34           C  
ATOM   2209  C   GLY D  49     -13.165  82.216  41.798  1.00 77.34           C  
ATOM   2210  O   GLY D  49     -14.272  82.753  41.691  1.00 77.34           O  
ATOM   2211  N   VAL D  50     -13.010  80.939  42.114  1.00 83.18           N  
ATOM   2212  CA  VAL D  50     -14.143  80.074  42.397  1.00 83.14           C  
ATOM   2213  C   VAL D  50     -13.574  78.917  43.200  1.00 83.14           C  
ATOM   2214  O   VAL D  50     -14.296  78.191  43.884  1.00 83.16           O  
ATOM   2215  CB  VAL D  50     -14.797  79.511  41.120  1.00 33.49           C  
ATOM   2216  CG1 VAL D  50     -15.987  78.638  41.507  1.00 33.48           C  
ATOM   2217  CG2 VAL D  50     -15.235  80.644  40.188  1.00 33.48           C  
ATOM   2218  N   LEU D  51     -12.256  78.774  43.113  1.00 37.29           N  
ATOM   2219  CA  LEU D  51     -11.535  77.718  43.795  1.00 37.28           C  
ATOM   2220  C   LEU D  51     -10.372  78.328  44.536  1.00 37.28           C  
ATOM   2221  O   LEU D  51      -9.645  79.142  43.979  1.00 37.27           O  
ATOM   2222  CB  LEU D  51     -11.015  76.712  42.773  1.00 59.57           C  
ATOM   2223  CG  LEU D  51     -12.124  75.949  42.058  1.00 59.57           C  
ATOM   2224  CD1 LEU D  51     -11.684  75.504  40.677  1.00 59.59           C  
ATOM   2225  CD2 LEU D  51     -12.509  74.780  42.925  1.00 59.59           C  
ATOM   2226  N   ASP D  52     -10.206  77.924  45.793  1.00 44.61           N  
ATOM   2227  CA  ASP D  52      -9.129  78.410  46.651  1.00 44.63           C  
ATOM   2228  C   ASP D  52      -7.766  77.986  46.098  1.00 44.63           C  
ATOM   2229  O   ASP D  52      -7.663  77.008  45.364  1.00 44.63           O  
ATOM   2230  CB  ASP D  52      -9.323  77.869  48.071  1.00 28.81           C  
ATOM   2231  N   LEU D  53      -6.718  78.723  46.438  1.00 47.48           N  
ATOM   2232  CA  LEU D  53      -5.390  78.378  45.946  1.00 47.48           C  
ATOM   2233  C   LEU D  53      -5.016  76.985  46.433  1.00 47.48           C  
ATOM   2234  O   LEU D  53      -4.426  76.194  45.694  1.00 47.48           O  
ATOM   2235  CB  LEU D  53      -4.344  79.393  46.421  1.00 51.83           C  
ATOM   2236  CG  LEU D  53      -2.899  79.161  45.945  1.00 51.83           C  
ATOM   2237  CD1 LEU D  53      -2.819  79.274  44.437  1.00 51.83           C  
ATOM   2238  CD2 LEU D  53      -1.960  80.184  46.570  1.00 51.83           C  
ATOM   2239  N   LYS D  54      -5.363  76.677  47.677  1.00 32.43           N  
ATOM   2240  CA  LYS D  54      -5.045  75.372  48.211  1.00 32.44           C  
ATOM   2241  C   LYS D  54      -5.692  74.327  47.327  1.00 32.43           C  
ATOM   2242  O   LYS D  54      -5.063  73.338  46.954  1.00 32.42           O  
ATOM   2243  CB  LYS D  54      -5.537  75.228  49.656  1.00102.19           C  
ATOM   2244  CG  LYS D  54      -4.676  75.965  50.669  1.00102.20           C  
ATOM   2245  CD  LYS D  54      -4.944  75.498  52.093  1.00102.21           C  
ATOM   2246  CE  LYS D  54      -6.357  75.829  52.545  1.00102.21           C  
ATOM   2247  NZ  LYS D  54      -6.598  75.388  53.945  1.00102.21           N  
ATOM   2248  N   THR D  55      -6.947  74.571  46.975  1.00 54.98           N  
ATOM   2249  CA  THR D  55      -7.705  73.652  46.137  1.00 54.99           C  
ATOM   2250  C   THR D  55      -7.118  73.514  44.733  1.00 54.99           C  
ATOM   2251  O   THR D  55      -7.332  72.505  44.069  1.00 55.00           O  
ATOM   2252  CB  THR D  55      -9.192  74.102  46.046  1.00 44.85           C  
ATOM   2253  OG1 THR D  55      -9.803  73.997  47.340  1.00 44.84           O  
ATOM   2254  CG2 THR D  55      -9.964  73.249  45.051  1.00 44.84           C  
ATOM   2255  N   ARG D  56      -6.372  74.518  44.281  1.00 42.28           N  
ATOM   2256  CA  ARG D  56      -5.790  74.451  42.945  1.00 42.25           C  
ATOM   2257  C   ARG D  56      -4.451  73.730  42.934  1.00 42.26           C  
ATOM   2258  O   ARG D  56      -4.146  73.023  41.979  1.00 42.26           O  
ATOM   2259  CB  ARG D  56      -5.641  75.850  42.330  1.00 22.18           C  
ATOM   2260  CG  ARG D  56      -6.951  76.479  41.848  1.00 22.17           C  
ATOM   2261  CD  ARG D  56      -6.665  77.794  41.159  1.00 22.17           C  
ATOM   2262  NE  ARG D  56      -7.852  78.565  40.770  1.00 22.16           N  
ATOM   2263  CZ  ARG D  56      -8.452  78.497  39.578  1.00 22.16           C  
ATOM   2264  NH1 ARG D  56      -7.994  77.674  38.633  1.00 22.16           N  
ATOM   2265  NH2 ARG D  56      -9.480  79.292  39.306  1.00 22.16           N  
ATOM   2266  N   GLU D  57      -3.652  73.897  43.982  1.00 57.60           N  
ATOM   2267  CA  GLU D  57      -2.363  73.219  44.027  1.00 57.60           C  
ATOM   2268  C   GLU D  57      -2.587  71.752  44.268  1.00 57.59           C  
ATOM   2269  O   GLU D  57      -1.676  70.947  44.114  1.00 57.59           O  
ATOM   2270  CB  GLU D  57      -1.473  73.772  45.136  1.00 72.47           C  
ATOM   2271  CG  GLU D  57      -0.641  74.955  44.713  1.00 72.48           C  
ATOM   2272  CD  GLU D  57       0.076  74.738  43.389  1.00 72.49           C  
ATOM   2273  OE1 GLU D  57       0.780  73.714  43.234  1.00 72.49           O  
ATOM   2274  OE2 GLU D  57      -0.063  75.604  42.499  1.00 72.49           O  
ATOM   2275  N   LEU D  58      -3.809  71.407  44.651  1.00 47.79           N  
ATOM   2276  CA  LEU D  58      -4.157  70.025  44.924  1.00 47.78           C  
ATOM   2277  C   LEU D  58      -4.680  69.395  43.632  1.00 47.78           C  
ATOM   2278  O   LEU D  58      -4.490  68.202  43.392  1.00 47.78           O  
ATOM   2279  CB  LEU D  58      -5.202  69.974  46.048  1.00 22.76           C  
ATOM   2280  CG  LEU D  58      -4.929  68.979  47.191  1.00 22.77           C  
ATOM   2281  CD1 LEU D  58      -3.529  69.195  47.755  1.00 22.76           C  
ATOM   2282  CD2 LEU D  58      -5.974  69.120  48.280  1.00 22.76           C  
ATOM   2283  N   LEU D  59      -5.318  70.219  42.798  1.00 34.46           N  
ATOM   2284  CA  LEU D  59      -5.857  69.782  41.509  1.00 34.45           C  
ATOM   2285  C   LEU D  59      -4.760  69.712  40.447  1.00 34.45           C  
ATOM   2286  O   LEU D  59      -4.912  69.029  39.433  1.00 34.45           O  
ATOM   2287  CB  LEU D  59      -6.955  70.733  41.030  1.00 31.52           C  
ATOM   2288  CG  LEU D  59      -8.382  70.521  41.542  1.00 31.52           C  
ATOM   2289  CD1 LEU D  59      -9.248  71.712  41.210  1.00 31.52           C  
ATOM   2290  CD2 LEU D  59      -8.953  69.277  40.908  1.00 31.52           C  
ATOM   2291  N   THR D  60      -3.660  70.431  40.676  1.00 30.03           N  
ATOM   2292  CA  THR D  60      -2.534  70.424  39.743  1.00 30.03           C  
ATOM   2293  C   THR D  60      -1.749  69.113  39.944  1.00 30.02           C  
ATOM   2294  O   THR D  60      -1.355  68.454  38.978  1.00 30.01           O  
ATOM   2295  CB  THR D  60      -1.611  71.668  39.975  1.00 37.50           C  
ATOM   2296  OG1 THR D  60      -0.658  71.785  38.915  1.00 37.50           O  
ATOM   2297  CG2 THR D  60      -0.848  71.533  41.270  1.00 37.51           C  
ATOM   2298  N   LEU D  61      -1.557  68.742  41.211  1.00 25.66           N  
ATOM   2299  CA  LEU D  61      -0.842  67.522  41.580  1.00 25.67           C  
ATOM   2300  C   LEU D  61      -1.462  66.277  40.934  1.00 25.67           C  
ATOM   2301  O   LEU D  61      -0.750  65.440  40.365  1.00 25.66           O  
ATOM   2302  CB  LEU D  61      -0.830  67.355  43.101  1.00 34.50           C  
ATOM   2303  CG  LEU D  61      -0.050  68.411  43.885  1.00 34.51           C  
ATOM   2304  CD1 LEU D  61      -0.064  68.093  45.376  1.00 34.52           C  
ATOM   2305  CD2 LEU D  61       1.372  68.445  43.375  1.00 34.51           C  
ATOM   2306  N   ALA D  62      -2.787  66.166  41.018  1.00 43.37           N  
ATOM   2307  CA  ALA D  62      -3.507  65.037  40.443  1.00 43.39           C  
ATOM   2308  C   ALA D  62      -3.174  64.850  38.980  1.00 43.39           C  
ATOM   2309  O   ALA D  62      -2.817  63.752  38.554  1.00 43.40           O  
ATOM   2310  CB  ALA D  62      -4.998  65.235  40.588  1.00  9.01           C  
ATOM   2311  N   ALA D  63      -3.311  65.922  38.207  1.00 31.97           N  
ATOM   2312  CA  ALA D  63      -3.017  65.857  36.786  1.00 31.97           C  
ATOM   2313  C   ALA D  63      -1.568  65.412  36.547  1.00 31.98           C  
ATOM   2314  O   ALA D  63      -1.295  64.543  35.710  1.00 31.96           O  
ATOM   2315  CB  ALA D  63      -3.268  67.200  36.151  1.00  9.01           C  
ATOM   2316  N   LEU D  64      -0.644  65.995  37.304  1.00 53.88           N  
ATOM   2317  CA  LEU D  64       0.766  65.672  37.171  1.00 53.87           C  
ATOM   2318  C   LEU D  64       1.100  64.230  37.554  1.00 53.87           C  
ATOM   2319  O   LEU D  64       2.131  63.698  37.147  1.00 53.88           O  
ATOM   2320  CB  LEU D  64       1.594  66.658  37.996  1.00 35.35           C  
ATOM   2321  CG  LEU D  64       1.556  68.109  37.490  1.00 35.34           C  
ATOM   2322  CD1 LEU D  64       2.416  68.971  38.370  1.00 35.34           C  
ATOM   2323  CD2 LEU D  64       2.055  68.185  36.062  1.00 35.34           C  
ATOM   2324  N   THR D  65       0.230  63.601  38.339  1.00 24.89           N  
ATOM   2325  CA  THR D  65       0.416  62.210  38.753  1.00 24.88           C  
ATOM   2326  C   THR D  65       0.148  61.306  37.565  1.00 24.88           C  
ATOM   2327  O   THR D  65       0.903  60.386  37.279  1.00 24.88           O  
ATOM   2328  CB  THR D  65      -0.564  61.825  39.856  1.00 24.90           C  
ATOM   2329  OG1 THR D  65      -0.200  62.486  41.068  1.00 24.90           O  
ATOM   2330  CG2 THR D  65      -0.541  60.347  40.087  1.00 24.90           C  
ATOM   2331  N   VAL D  66      -0.951  61.590  36.881  1.00 14.94           N  
ATOM   2332  CA  VAL D  66      -1.358  60.834  35.712  1.00 14.93           C  
ATOM   2333  C   VAL D  66      -0.310  60.928  34.612  1.00 14.92           C  
ATOM   2334  O   VAL D  66       0.011  59.925  33.988  1.00 14.93           O  
ATOM   2335  CB  VAL D  66      -2.705  61.361  35.193  1.00 19.84           C  
ATOM   2336  CG1 VAL D  66      -3.206  60.512  34.038  1.00 19.84           C  
ATOM   2337  CG2 VAL D  66      -3.713  61.373  36.332  1.00 19.84           C  
ATOM   2338  N   LEU D  67       0.211  62.138  34.393  1.00 23.84           N  
ATOM   2339  CA  LEU D  67       1.228  62.439  33.372  1.00 23.83           C  
ATOM   2340  C   LEU D  67       2.618  61.991  33.796  1.00 23.82           C  
ATOM   2341  O   LEU D  67       3.562  62.042  33.010  1.00 23.83           O  
ATOM   2342  CB  LEU D  67       1.292  63.941  33.107  1.00 18.45           C  
ATOM   2343  CG  LEU D  67       0.131  64.683  32.452  1.00 18.45           C  
ATOM   2344  CD1 LEU D  67       0.243  66.160  32.778  1.00 18.44           C  
ATOM   2345  CD2 LEU D  67       0.139  64.465  30.950  1.00 18.44           C  
ATOM   2346  N   ARG D  68       2.736  61.572  35.050  1.00 29.47           N  
ATOM   2347  CA  ARG D  68       4.005  61.108  35.601  1.00 29.47           C  
ATOM   2348  C   ARG D  68       5.089  62.168  35.442  1.00 29.47           C  
ATOM   2349  O   ARG D  68       6.268  61.832  35.317  1.00 29.47           O  
ATOM   2350  CB  ARG D  68       4.479  59.821  34.898  1.00 22.84           C  
ATOM   2351  CG  ARG D  68       3.621  58.559  35.048  1.00 22.83           C  
ATOM   2352  CD  ARG D  68       4.285  57.391  34.288  1.00 22.83           C  
ATOM   2353  NE  ARG D  68       5.507  56.892  34.934  1.00 22.84           N  
ATOM   2354  CZ  ARG D  68       5.522  55.993  35.918  1.00 22.83           C  
ATOM   2355  NH1 ARG D  68       4.392  55.474  36.373  1.00 22.83           N  
ATOM   2356  NH2 ARG D  68       6.663  55.622  36.464  1.00 22.83           N  
ATOM   2357  N   ALA D  69       4.709  63.441  35.437  1.00 28.69           N  
ATOM   2358  CA  ALA D  69       5.700  64.506  35.282  1.00 28.71           C  
ATOM   2359  C   ALA D  69       6.452  64.735  36.588  1.00 28.72           C  
ATOM   2360  O   ALA D  69       6.156  65.674  37.330  1.00 28.71           O  
ATOM   2361  CB  ALA D  69       5.028  65.787  34.840  1.00  9.01           C  
ATOM   2362  N   ASP D  70       7.434  63.874  36.845  1.00 48.19           N  
ATOM   2363  CA  ASP D  70       8.255  63.920  38.057  1.00 48.20           C  
ATOM   2364  C   ASP D  70       8.732  65.281  38.540  1.00 48.23           C  
ATOM   2365  O   ASP D  70       8.415  65.680  39.658  1.00 48.22           O  
ATOM   2366  CB  ASP D  70       9.467  62.995  37.903  1.00 80.49           C  
ATOM   2367  CG  ASP D  70       9.141  61.547  38.218  1.00 80.50           C  
ATOM   2368  OD1 ASP D  70       9.998  60.672  37.970  1.00 80.50           O  
ATOM   2369  OD2 ASP D  70       8.029  61.284  38.721  1.00 80.50           O  
ATOM   2370  N   ASP D  71       9.505  65.987  37.723  1.00 96.67           N  
ATOM   2371  CA  ASP D  71      10.017  67.291  38.130  1.00 96.67           C  
ATOM   2372  C   ASP D  71       8.914  68.260  38.547  1.00 96.67           C  
ATOM   2373  O   ASP D  71       8.902  68.746  39.679  1.00 96.68           O  
ATOM   2374  CB  ASP D  71      10.864  67.898  37.011  1.00 98.99           C  
ATOM   2375  CG  ASP D  71      12.159  67.137  36.788  1.00 99.00           C  
ATOM   2376  OD1 ASP D  71      12.915  66.948  37.766  1.00 99.00           O  
ATOM   2377  OD2 ASP D  71      12.420  66.728  35.637  1.00 99.01           O  
ATOM   2378  N   GLN D  72       7.987  68.533  37.634  1.00 32.49           N  
ATOM   2379  CA  GLN D  72       6.874  69.438  37.907  1.00 32.46           C  
ATOM   2380  C   GLN D  72       6.052  68.959  39.104  1.00 32.44           C  
ATOM   2381  O   GLN D  72       5.282  69.715  39.685  1.00 32.45           O  
ATOM   2382  CB  GLN D  72       5.970  69.558  36.673  1.00 30.54           C  
ATOM   2383  CG  GLN D  72       6.637  70.195  35.459  1.00 30.53           C  
ATOM   2384  CD  GLN D  72       7.692  69.306  34.798  1.00 30.53           C  
ATOM   2385  OE1 GLN D  72       8.618  69.806  34.152  1.00 30.54           O  
ATOM   2386  NE2 GLN D  72       7.548  67.987  34.941  1.00 30.53           N  
ATOM   2387  N   LEU D  73       6.212  67.699  39.476  1.00 35.86           N  
ATOM   2388  CA  LEU D  73       5.477  67.170  40.606  1.00 35.85           C  
ATOM   2389  C   LEU D  73       6.086  67.660  41.905  1.00 35.85           C  
ATOM   2390  O   LEU D  73       5.404  68.267  42.729  1.00 35.86           O  
ATOM   2391  CB  LEU D  73       5.510  65.651  40.607  1.00 19.33           C  
ATOM   2392  CG  LEU D  73       4.523  65.075  41.612  1.00 19.32           C  
ATOM   2393  CD1 LEU D  73       3.116  65.231  41.053  1.00 19.31           C  
ATOM   2394  CD2 LEU D  73       4.838  63.620  41.864  1.00 19.32           C  
ATOM   2395  N   LYS D  74       7.372  67.381  42.091  1.00 45.07           N  
ATOM   2396  CA  LYS D  74       8.063  67.796  43.303  1.00 45.07           C  
ATOM   2397  C   LYS D  74       7.824  69.279  43.500  1.00 45.07           C  
ATOM   2398  O   LYS D  74       7.580  69.740  44.612  1.00 45.07           O  
ATOM   2399  CB  LYS D  74       9.569  67.553  43.191  1.00 23.28           C  
ATOM   2400  CG  LYS D  74       9.989  66.136  42.890  1.00 23.28           C  
ATOM   2401  CD  LYS D  74      11.506  66.095  42.697  1.00 23.28           C  
ATOM   2402  CE  LYS D  74      12.008  64.800  42.030  1.00 23.28           C  
ATOM   2403  NZ  LYS D  74      11.868  63.552  42.847  1.00 23.28           N  
ATOM   2404  N   SER D  75       7.888  70.019  42.403  1.00 52.44           N  
ATOM   2405  CA  SER D  75       7.697  71.459  42.433  1.00 52.46           C  
ATOM   2406  C   SER D  75       6.384  71.884  43.082  1.00 52.46           C  
ATOM   2407  O   SER D  75       6.367  72.611  44.076  1.00 52.46           O  
ATOM   2408  CB  SER D  75       7.777  72.016  41.015  1.00 46.94           C  
ATOM   2409  OG  SER D  75       7.435  73.383  40.994  1.00 46.95           O  
ATOM   2410  N   HIS D  76       5.277  71.428  42.522  1.00 52.58           N  
ATOM   2411  CA  HIS D  76       3.993  71.782  43.074  1.00 52.58           C  
ATOM   2412  C   HIS D  76       3.760  71.149  44.420  1.00 52.58           C  
ATOM   2413  O   HIS D  76       2.773  71.445  45.067  1.00 52.59           O  
ATOM   2414  CB  HIS D  76       2.892  71.390  42.121  1.00 35.97           C  
ATOM   2415  CG  HIS D  76       2.881  72.226  40.870  1.00 35.96           C  
ATOM   2416  ND1 HIS D  76       2.265  73.426  40.809  1.00 35.96           N  
ATOM   2417  CD2 HIS D  76       3.467  71.989  39.667  1.00 35.96           C  
ATOM   2418  CE1 HIS D  76       2.456  73.946  39.578  1.00 35.96           C  
ATOM   2419  NE2 HIS D  76       3.169  73.099  38.894  1.00 35.95           N  
ATOM   2420  N   VAL D  77       4.650  70.268  44.854  1.00 41.18           N  
ATOM   2421  CA  VAL D  77       4.450  69.683  46.167  1.00 41.17           C  
ATOM   2422  C   VAL D  77       4.890  70.741  47.152  1.00 41.18           C  
ATOM   2423  O   VAL D  77       4.326  70.873  48.244  1.00 41.18           O  
ATOM   2424  CB  VAL D  77       5.281  68.438  46.383  1.00 29.98           C  
ATOM   2425  CG1 VAL D  77       4.943  67.831  47.740  1.00 29.97           C  
ATOM   2426  CG2 VAL D  77       4.997  67.456  45.288  1.00 29.97           C  
ATOM   2427  N   ARG D  78       5.902  71.503  46.754  1.00 64.08           N  
ATOM   2428  CA  ARG D  78       6.402  72.579  47.592  1.00 64.09           C  
ATOM   2429  C   ARG D  78       5.296  73.622  47.557  1.00 64.08           C  
ATOM   2430  O   ARG D  78       4.744  74.009  48.592  1.00 64.10           O  
ATOM   2431  CB  ARG D  78       7.700  73.152  47.012  1.00 49.85           C  
ATOM   2432  CG  ARG D  78       8.691  72.084  46.580  1.00 49.84           C  
ATOM   2433  CD  ARG D  78      10.110  72.608  46.571  1.00 49.84           C  
ATOM   2434  NE  ARG D  78      11.055  71.587  46.137  1.00 49.83           N  
ATOM   2435  CZ  ARG D  78      11.360  71.351  44.868  1.00 49.84           C  
ATOM   2436  NH1 ARG D  78      10.801  72.070  43.902  1.00 49.84           N  
ATOM   2437  NH2 ARG D  78      12.215  70.384  44.565  1.00 49.83           N  
ATOM   2438  N   GLY D  79       4.967  74.050  46.343  1.00 34.65           N  
ATOM   2439  CA  GLY D  79       3.918  75.028  46.165  1.00 34.65           C  
ATOM   2440  C   GLY D  79       2.661  74.701  46.953  1.00 34.65           C  
ATOM   2441  O   GLY D  79       2.007  75.596  47.485  1.00 34.64           O  
ATOM   2442  N   ALA D  80       2.311  73.423  47.041  1.00 43.92           N  
ATOM   2443  CA  ALA D  80       1.114  73.034  47.773  1.00 43.94           C  
ATOM   2444  C   ALA D  80       1.369  73.131  49.261  1.00 43.94           C  
ATOM   2445  O   ALA D  80       0.565  73.695  49.991  1.00 43.94           O  
ATOM   2446  CB  ALA D  80       0.702  71.624  47.407  1.00 32.72           C  
ATOM   2447  N   LEU D  81       2.484  72.574  49.717  1.00 47.29           N  
ATOM   2448  CA  LEU D  81       2.809  72.643  51.132  1.00 47.29           C  
ATOM   2449  C   LEU D  81       2.778  74.114  51.544  1.00 47.29           C  
ATOM   2450  O   LEU D  81       2.276  74.464  52.618  1.00 47.30           O  
ATOM   2451  CB  LEU D  81       4.207  72.069  51.397  1.00 27.00           C  
ATOM   2452  CG  LEU D  81       4.528  70.572  51.270  1.00 26.99           C  
ATOM   2453  CD1 LEU D  81       6.023  70.383  51.399  1.00 26.98           C  
ATOM   2454  CD2 LEU D  81       3.821  69.763  52.331  1.00 26.98           C  
ATOM   2455  N   ASN D  82       3.305  74.969  50.666  1.00 44.67           N  
ATOM   2456  CA  ASN D  82       3.363  76.405  50.915  1.00 44.67           C  
ATOM   2457  C   ASN D  82       2.017  77.113  51.105  1.00 44.66           C  
ATOM   2458  O   ASN D  82       1.893  77.994  51.947  1.00 44.66           O  
ATOM   2459  CB  ASN D  82       4.152  77.109  49.797  1.00 58.55           C  
ATOM   2460  CG  ASN D  82       5.628  76.738  49.794  1.00 58.56           C  
ATOM   2461  OD1 ASN D  82       6.197  76.404  50.833  1.00 58.57           O  
ATOM   2462  ND2 ASN D  82       6.259  76.812  48.627  1.00 58.56           N  
ATOM   2463  N   ALA D  83       1.011  76.744  50.328  1.00 33.48           N  
ATOM   2464  CA  ALA D  83      -0.292  77.388  50.447  1.00 33.48           C  
ATOM   2465  C   ALA D  83      -1.085  76.928  51.668  1.00 33.48           C  
ATOM   2466  O   ALA D  83      -2.124  77.503  51.984  1.00 33.48           O  
ATOM   2467  CB  ALA D  83      -1.106  77.156  49.183  1.00102.19           C  
ATOM   2468  N   GLY D  84      -0.603  75.889  52.341  1.00 54.98           N  
ATOM   2469  CA  GLY D  84      -1.297  75.405  53.518  1.00 54.97           C  
ATOM   2470  C   GLY D  84      -1.609  73.923  53.525  1.00 54.97           C  
ATOM   2471  O   GLY D  84      -1.993  73.376  54.558  1.00 54.98           O  
ATOM   2472  N   CYS D  85      -1.454  73.256  52.389  1.00 79.07           N  
ATOM   2473  CA  CYS D  85      -1.744  71.831  52.338  1.00 79.07           C  
ATOM   2474  C   CYS D  85      -0.796  71.013  53.194  1.00 79.08           C  
ATOM   2475  O   CYS D  85       0.411  71.239  53.192  1.00 79.08           O  
ATOM   2476  CB  CYS D  85      -1.711  71.333  50.897  1.00 46.65           C  
ATOM   2477  SG  CYS D  85      -3.191  71.770  49.997  1.00 46.66           S  
ATOM   2478  N   SER D  86      -1.360  70.060  53.927  1.00 70.53           N  
ATOM   2479  CA  SER D  86      -0.585  69.196  54.804  1.00 70.52           C  
ATOM   2480  C   SER D  86      -0.195  67.902  54.105  1.00 70.52           C  
ATOM   2481  O   SER D  86      -0.689  67.597  53.018  1.00 70.51           O  
ATOM   2482  CB  SER D  86      -1.400  68.854  56.046  1.00 69.88           C  
ATOM   2483  OG  SER D  86      -2.444  67.949  55.729  1.00 69.88           O  
ATOM   2484  N   LYS D  87       0.698  67.145  54.737  1.00 42.94           N  
ATOM   2485  CA  LYS D  87       1.140  65.872  54.188  1.00 42.93           C  
ATOM   2486  C   LYS D  87      -0.092  65.024  53.883  1.00 42.93           C  
ATOM   2487  O   LYS D  87      -0.370  64.718  52.721  1.00 42.93           O  
ATOM   2488  CB  LYS D  87       2.012  65.132  55.197  1.00 29.80           C  
ATOM   2489  CG  LYS D  87       3.173  65.929  55.727  1.00 29.80           C  
ATOM   2490  CD  LYS D  87       4.117  66.296  54.635  1.00 29.80           C  
ATOM   2491  CE  LYS D  87       5.410  66.770  55.215  1.00 29.80           C  
ATOM   2492  NZ  LYS D  87       5.910  65.807  56.229  1.00 29.80           N  
ATOM   2493  N   ASP D  88      -0.829  64.665  54.937  1.00 48.52           N  
ATOM   2494  CA  ASP D  88      -2.026  63.843  54.807  1.00 48.52           C  
ATOM   2495  C   ASP D  88      -2.822  64.168  53.541  1.00 48.54           C  
ATOM   2496  O   ASP D  88      -3.350  63.269  52.903  1.00 48.54           O  
ATOM   2497  CB  ASP D  88      -2.919  63.984  56.063  1.00 30.25           C  
ATOM   2498  CG  ASP D  88      -2.545  62.976  57.195  1.00 17.45           C  
ATOM   2499  OD1 ASP D  88      -1.523  62.239  57.043  1.00 17.45           O  
ATOM   2500  OD2 ASP D  88      -3.270  62.917  58.244  1.00 17.45           O  
ATOM   2501  N   GLU D  89      -2.885  65.438  53.156  1.00 50.21           N  
ATOM   2502  CA  GLU D  89      -3.639  65.837  51.961  1.00 50.23           C  
ATOM   2503  C   GLU D  89      -2.950  65.516  50.649  1.00 50.21           C  
ATOM   2504  O   GLU D  89      -3.533  64.884  49.778  1.00 50.22           O  
ATOM   2505  CB  GLU D  89      -3.939  67.335  51.983  1.00 48.79           C  
ATOM   2506  CG  GLU D  89      -4.774  67.787  53.167  1.00 48.80           C  
ATOM   2507  CD  GLU D  89      -4.849  69.299  53.285  1.00 48.81           C  
ATOM   2508  OE1 GLU D  89      -3.819  69.974  53.061  1.00 48.81           O  
ATOM   2509  OE2 GLU D  89      -5.934  69.814  53.616  1.00 48.81           O  
ATOM   2510  N   ILE D  90      -1.720  65.979  50.491  1.00 48.36           N  
ATOM   2511  CA  ILE D  90      -0.994  65.714  49.261  1.00 48.36           C  
ATOM   2512  C   ILE D  90      -1.005  64.216  48.972  1.00 48.35           C  
ATOM   2513  O   ILE D  90      -1.312  63.775  47.868  1.00 48.35           O  
ATOM   2514  CB  ILE D  90       0.468  66.216  49.361  1.00 46.08           C  
ATOM   2515  CG1 ILE D  90       0.502  67.746  49.255  1.00 46.09           C  
ATOM   2516  CG2 ILE D  90       1.317  65.571  48.279  1.00 46.09           C  
ATOM   2517  CD1 ILE D  90       1.875  68.350  49.447  1.00 54.13           C  
ATOM   2518  N   ILE D  91      -0.686  63.436  49.988  1.00 41.36           N  
ATOM   2519  CA  ILE D  91      -0.634  61.999  49.837  1.00 41.36           C  
ATOM   2520  C   ILE D  91      -2.001  61.343  49.651  1.00 41.36           C  
ATOM   2521  O   ILE D  91      -2.093  60.185  49.230  1.00 41.36           O  
ATOM   2522  CB  ILE D  91       0.110  61.393  51.029  1.00 25.66           C  
ATOM   2523  CG1 ILE D  91       1.588  61.751  50.913  1.00 25.66           C  
ATOM   2524  CG2 ILE D  91      -0.053  59.883  51.058  1.00 25.65           C  
ATOM   2525  CD1 ILE D  91       2.376  61.539  52.183  1.00 54.13           C  
ATOM   2526  N   GLU D  92      -3.066  62.073  49.951  1.00 49.44           N  
ATOM   2527  CA  GLU D  92      -4.400  61.519  49.778  1.00 49.47           C  
ATOM   2528  C   GLU D  92      -4.817  61.541  48.322  1.00 49.46           C  
ATOM   2529  O   GLU D  92      -5.440  60.602  47.843  1.00 49.46           O  
ATOM   2530  CB  GLU D  92      -5.424  62.289  50.600  1.00 73.99           C  
ATOM   2531  CG  GLU D  92      -5.606  61.731  51.982  1.00 73.99           C  
ATOM   2532  CD  GLU D  92      -5.895  60.244  51.963  1.00 74.01           C  
ATOM   2533  OE1 GLU D  92      -6.881  59.840  51.310  1.00 74.00           O  
ATOM   2534  OE2 GLU D  92      -5.133  59.484  52.601  1.00 74.00           O  
ATOM   2535  N   VAL D  93      -4.476  62.612  47.617  1.00 32.73           N  
ATOM   2536  CA  VAL D  93      -4.838  62.719  46.212  1.00 32.71           C  
ATOM   2537  C   VAL D  93      -4.085  61.681  45.395  1.00 32.71           C  
ATOM   2538  O   VAL D  93      -4.603  61.154  44.399  1.00 32.72           O  
ATOM   2539  CB  VAL D  93      -4.511  64.108  45.635  1.00 28.28           C  
ATOM   2540  CG1 VAL D  93      -4.733  65.177  46.697  1.00 28.28           C  
ATOM   2541  CG2 VAL D  93      -3.101  64.139  45.131  1.00 28.28           C  
HETATM 2542  N   MSE D  94      -2.864  61.381  45.818  1.00 35.03           N  
HETATM 2543  CA  MSE D  94      -2.064  60.416  45.096  1.00 35.02           C  
HETATM 2544  C   MSE D  94      -2.665  59.042  45.289  1.00 35.02           C  
HETATM 2545  O   MSE D  94      -2.912  58.323  44.325  1.00 35.02           O  
HETATM 2546  CB  MSE D  94      -0.621  60.494  45.567  1.00 68.00           C  
HETATM 2547  CG  MSE D  94      -0.067  61.888  45.344  1.00 68.01           C  
HETATM 2548 SE   MSE D  94       1.684  62.157  46.044  1.00 67.99          SE  
HETATM 2549  CE  MSE D  94       2.396  63.336  44.706  1.00 68.01           C  
ATOM   2550  N   ILE D  95      -2.939  58.684  46.534  1.00 26.98           N  
ATOM   2551  CA  ILE D  95      -3.545  57.390  46.793  1.00 26.98           C  
ATOM   2552  C   ILE D  95      -4.813  57.282  45.973  1.00 26.98           C  
ATOM   2553  O   ILE D  95      -5.086  56.240  45.399  1.00 26.98           O  
ATOM   2554  CB  ILE D  95      -3.890  57.210  48.279  1.00 32.74           C  
ATOM   2555  CG1 ILE D  95      -2.601  56.941  49.068  1.00 32.75           C  
ATOM   2556  CG2 ILE D  95      -4.896  56.088  48.443  1.00 32.74           C  
ATOM   2557  CD1 ILE D  95      -2.754  57.006  50.558  1.00 54.13           C  
ATOM   2558  N   GLN D  96      -5.580  58.362  45.894  1.00 64.03           N  
ATOM   2559  CA  GLN D  96      -6.805  58.319  45.118  1.00 64.03           C  
ATOM   2560  C   GLN D  96      -6.519  58.122  43.631  1.00 64.05           C  
ATOM   2561  O   GLN D  96      -7.347  57.582  42.902  1.00 64.05           O  
ATOM   2562  CB  GLN D  96      -7.638  59.590  45.322  1.00 30.40           C  
ATOM   2563  CG  GLN D  96      -8.929  59.562  44.505  1.00 30.40           C  
ATOM   2564  CD  GLN D  96     -10.037  60.463  45.032  1.00 30.38           C  
ATOM   2565  OE1 GLN D  96     -10.480  60.322  46.176  1.00 30.38           O  
ATOM   2566  NE2 GLN D  96     -10.505  61.382  44.189  1.00 30.38           N  
HETATM 2567  N   MSE D  97      -5.345  58.538  43.176  1.00 53.94           N  
HETATM 2568  CA  MSE D  97      -5.014  58.390  41.763  1.00 53.93           C  
HETATM 2569  C   MSE D  97      -4.705  56.956  41.306  1.00 53.93           C  
HETATM 2570  O   MSE D  97      -4.632  56.689  40.109  1.00 53.93           O  
HETATM 2571  CB  MSE D  97      -3.863  59.329  41.404  1.00 52.88           C  
HETATM 2572  CG  MSE D  97      -4.257  60.800  41.429  1.00 52.88           C  
HETATM 2573 SE   MSE D  97      -5.663  61.268  40.149  1.00 52.86          SE  
HETATM 2574  CE  MSE D  97      -7.220  61.173  41.294  1.00 52.87           C  
ATOM   2575  N   ALA D  98      -4.519  56.037  42.250  1.00 39.26           N  
ATOM   2576  CA  ALA D  98      -4.253  54.641  41.901  1.00 39.25           C  
ATOM   2577  C   ALA D  98      -5.524  54.070  41.281  1.00 39.25           C  
ATOM   2578  O   ALA D  98      -5.477  53.211  40.401  1.00 39.25           O  
ATOM   2579  CB  ALA D  98      -3.881  53.836  43.142  1.00  9.01           C  
ATOM   2580  N   VAL D  99      -6.664  54.553  41.760  1.00 22.77           N  
ATOM   2581  CA  VAL D  99      -7.954  54.121  41.248  1.00 22.77           C  
ATOM   2582  C   VAL D  99      -8.222  54.541  39.802  1.00 22.77           C  
ATOM   2583  O   VAL D  99      -8.695  53.746  39.010  1.00 22.77           O  
ATOM   2584  CB  VAL D  99      -9.100  54.657  42.134  1.00 22.97           C  
ATOM   2585  CG1 VAL D  99     -10.424  54.545  41.413  1.00 22.98           C  
ATOM   2586  CG2 VAL D  99      -9.167  53.865  43.415  1.00 22.98           C  
ATOM   2587  N   TYR D 100      -7.903  55.780  39.455  1.00 37.59           N  
ATOM   2588  CA  TYR D 100      -8.172  56.288  38.117  1.00 37.60           C  
ATOM   2589  C   TYR D 100      -7.046  56.243  37.094  1.00 37.59           C  
ATOM   2590  O   TYR D 100      -7.308  56.054  35.901  1.00 37.59           O  
ATOM   2591  CB  TYR D 100      -8.683  57.714  38.233  1.00 47.15           C  
ATOM   2592  CG  TYR D 100      -9.879  57.819  39.136  1.00 47.16           C  
ATOM   2593  CD1 TYR D 100     -11.117  57.329  38.735  1.00 47.16           C  
ATOM   2594  CD2 TYR D 100      -9.768  58.373  40.407  1.00 47.16           C  
ATOM   2595  CE1 TYR D 100     -12.220  57.382  39.576  1.00 47.17           C  
ATOM   2596  CE2 TYR D 100     -10.865  58.436  41.263  1.00 47.16           C  
ATOM   2597  CZ  TYR D 100     -12.088  57.938  40.836  1.00 47.17           C  
ATOM   2598  OH  TYR D 100     -13.191  58.000  41.655  1.00 47.17           O  
ATOM   2599  N   ALA D 101      -5.805  56.418  37.545  1.00 20.50           N  
ATOM   2600  CA  ALA D 101      -4.652  56.419  36.643  1.00 20.50           C  
ATOM   2601  C   ALA D 101      -3.745  55.200  36.778  1.00 20.50           C  
ATOM   2602  O   ALA D 101      -2.722  55.118  36.105  1.00 20.49           O  
ATOM   2603  CB  ALA D 101      -3.838  57.687  36.859  1.00 63.50           C  
ATOM   2604  N   GLY D 102      -4.110  54.263  37.649  1.00 22.48           N  
ATOM   2605  CA  GLY D 102      -3.307  53.061  37.840  1.00 22.49           C  
ATOM   2606  C   GLY D 102      -2.328  53.068  39.005  1.00 22.49           C  
ATOM   2607  O   GLY D 102      -1.775  54.108  39.344  1.00 22.49           O  
ATOM   2608  N   PHE D 103      -2.092  51.907  39.617  1.00 16.02           N  
ATOM   2609  CA  PHE D 103      -1.159  51.848  40.747  1.00 16.01           C  
ATOM   2610  C   PHE D 103       0.246  52.358  40.439  1.00 16.01           C  
ATOM   2611  O   PHE D 103       0.835  53.089  41.235  1.00 16.01           O  
ATOM   2612  CB  PHE D 103      -1.078  50.435  41.337  1.00 23.28           C  
ATOM   2613  CG  PHE D 103      -2.104  50.170  42.412  1.00 23.28           C  
ATOM   2614  CD1 PHE D 103      -3.443  49.979  42.093  1.00 23.28           C  
ATOM   2615  CD2 PHE D 103      -1.728  50.139  43.752  1.00 23.28           C  
ATOM   2616  CE1 PHE D 103      -4.387  49.781  43.091  1.00 23.28           C  
ATOM   2617  CE2 PHE D 103      -2.668  49.941  44.758  1.00 23.27           C  
ATOM   2618  CZ  PHE D 103      -3.994  49.758  44.429  1.00 23.27           C  
ATOM   2619  N   PRO D 104       0.810  51.991  39.285  1.00 42.36           N  
ATOM   2620  CA  PRO D 104       2.151  52.466  38.951  1.00 42.36           C  
ATOM   2621  C   PRO D 104       2.305  53.984  39.029  1.00 42.36           C  
ATOM   2622  O   PRO D 104       3.394  54.481  39.282  1.00 42.36           O  
ATOM   2623  CB  PRO D 104       2.347  51.941  37.539  1.00 11.43           C  
ATOM   2624  CG  PRO D 104       1.685  50.645  37.605  1.00 11.43           C  
ATOM   2625  CD  PRO D 104       0.392  50.948  38.340  1.00 11.43           C  
ATOM   2626  N   ALA D 105       1.209  54.710  38.819  1.00 23.07           N  
ATOM   2627  CA  ALA D 105       1.219  56.170  38.844  1.00 23.07           C  
ATOM   2628  C   ALA D 105       1.102  56.735  40.239  1.00 23.07           C  
ATOM   2629  O   ALA D 105       1.742  57.719  40.558  1.00 23.07           O  
ATOM   2630  CB  ALA D 105       0.095  56.731  37.976  1.00  9.01           C  
ATOM   2631  N   ALA D 106       0.280  56.131  41.073  1.00 36.51           N  
ATOM   2632  CA  ALA D 106       0.128  56.640  42.415  1.00 36.51           C  
ATOM   2633  C   ALA D 106       1.396  56.370  43.213  1.00 36.51           C  
ATOM   2634  O   ALA D 106       1.745  57.123  44.123  1.00 36.52           O  
ATOM   2635  CB  ALA D 106      -1.065  55.996  43.079  1.00 29.03           C  
ATOM   2636  N   ILE D 107       2.090  55.293  42.872  1.00 22.50           N  
ATOM   2637  CA  ILE D 107       3.319  54.953  43.569  1.00 22.47           C  
ATOM   2638  C   ILE D 107       4.421  55.910  43.129  1.00 22.48           C  
ATOM   2639  O   ILE D 107       5.057  56.545  43.958  1.00 22.48           O  
ATOM   2640  CB  ILE D 107       3.767  53.506  43.265  1.00 16.02           C  
ATOM   2641  CG1 ILE D 107       2.763  52.480  43.822  1.00 16.02           C  
ATOM   2642  CG2 ILE D 107       5.134  53.275  43.832  1.00 16.01           C  
ATOM   2643  CD1 ILE D 107       2.845  52.256  45.303  1.00 54.13           C  
ATOM   2644  N   ASN D 108       4.638  56.019  41.822  1.00 35.93           N  
ATOM   2645  CA  ASN D 108       5.675  56.900  41.278  1.00 35.93           C  
ATOM   2646  C   ASN D 108       5.655  58.329  41.819  1.00 35.93           C  
ATOM   2647  O   ASN D 108       6.700  58.922  42.049  1.00 35.93           O  
ATOM   2648  CB  ASN D 108       5.568  56.961  39.762  1.00 25.19           C  
ATOM   2649  CG  ASN D 108       6.632  57.829  39.146  1.00 25.19           C  
ATOM   2650  OD1 ASN D 108       6.334  58.796  38.437  1.00 25.19           O  
ATOM   2651  ND2 ASN D 108       7.887  57.491  39.404  1.00 25.19           N  
ATOM   2652  N   ALA D 109       4.464  58.883  42.012  1.00 32.63           N  
ATOM   2653  CA  ALA D 109       4.310  60.242  42.524  1.00 32.65           C  
ATOM   2654  C   ALA D 109       4.519  60.355  44.042  1.00 32.65           C  
ATOM   2655  O   ALA D 109       5.087  61.332  44.522  1.00 32.64           O  
ATOM   2656  CB  ALA D 109       2.936  60.769  42.151  1.00 72.44           C  
ATOM   2657  N   VAL D 110       4.050  59.369  44.798  1.00 39.03           N  
ATOM   2658  CA  VAL D 110       4.206  59.403  46.244  1.00 39.03           C  
ATOM   2659  C   VAL D 110       5.681  59.470  46.592  1.00 39.03           C  
ATOM   2660  O   VAL D 110       6.079  60.267  47.435  1.00 39.04           O  
ATOM   2661  CB  VAL D 110       3.549  58.166  46.917  1.00 23.85           C  
ATOM   2662  CG1 VAL D 110       4.440  57.597  47.993  1.00 23.84           C  
ATOM   2663  CG2 VAL D 110       2.226  58.575  47.545  1.00 23.84           C  
ATOM   2664  N   LEU D 111       6.486  58.639  45.937  1.00 25.18           N  
ATOM   2665  CA  LEU D 111       7.931  58.611  46.165  1.00 25.16           C  
ATOM   2666  C   LEU D 111       8.547  59.990  45.883  1.00 25.15           C  
ATOM   2667  O   LEU D 111       9.453  60.438  46.585  1.00 25.16           O  
ATOM   2668  CB  LEU D 111       8.596  57.558  45.255  1.00 20.64           C  
ATOM   2669  CG  LEU D 111       8.251  56.085  45.489  1.00 20.63           C  
ATOM   2670  CD1 LEU D 111       8.812  55.188  44.389  1.00 20.63           C  
ATOM   2671  CD2 LEU D 111       8.822  55.684  46.828  1.00 20.64           C  
ATOM   2672  N   ALA D 112       8.061  60.658  44.846  1.00 27.71           N  
ATOM   2673  CA  ALA D 112       8.590  61.964  44.511  1.00 27.72           C  
ATOM   2674  C   ALA D 112       8.195  62.933  45.608  1.00 27.72           C  
ATOM   2675  O   ALA D 112       8.850  63.954  45.807  1.00 27.71           O  
ATOM   2676  CB  ALA D 112       8.040  62.428  43.167  1.00 44.40           C  
ATOM   2677  N   ALA D 113       7.115  62.611  46.313  1.00 42.35           N  
ATOM   2678  CA  ALA D 113       6.632  63.446  47.398  1.00 42.37           C  
ATOM   2679  C   ALA D 113       7.503  63.214  48.611  1.00 42.37           C  
ATOM   2680  O   ALA D 113       7.904  64.143  49.295  1.00 42.37           O  
ATOM   2681  CB  ALA D 113       5.217  63.091  47.726  1.00  9.01           C  
ATOM   2682  N   LYS D 114       7.785  61.948  48.872  1.00 39.50           N  
ATOM   2683  CA  LYS D 114       8.607  61.550  50.000  1.00 39.52           C  
ATOM   2684  C   LYS D 114       9.952  62.260  49.935  1.00 39.52           C  
ATOM   2685  O   LYS D 114      10.528  62.603  50.970  1.00 39.51           O  
ATOM   2686  CB  LYS D 114       8.782  60.030  49.980  1.00 74.01           C  
ATOM   2687  CG  LYS D 114       9.697  59.445  51.032  1.00 74.03           C  
ATOM   2688  CD  LYS D 114       9.540  57.929  51.046  1.00 74.03           C  
ATOM   2689  CE  LYS D 114      10.677  57.221  51.764  1.00 74.04           C  
ATOM   2690  NZ  LYS D 114      11.992  57.382  51.080  1.00 74.04           N  
ATOM   2691  N   GLU D 115      10.451  62.494  48.725  1.00 54.90           N  
ATOM   2692  CA  GLU D 115      11.722  63.183  48.574  1.00 54.91           C  
ATOM   2693  C   GLU D 115      11.586  64.646  48.979  1.00 54.90           C  
ATOM   2694  O   GLU D 115      12.283  65.116  49.878  1.00 54.89           O  
ATOM   2695  CB  GLU D 115      12.239  63.083  47.134  1.00102.20           C  
ATOM   2696  CG  GLU D 115      13.107  61.852  46.861  1.00102.21           C  
ATOM   2697  CD  GLU D 115      14.401  61.827  47.683  1.00102.21           C  
ATOM   2698  OE1 GLU D 115      15.150  60.826  47.594  1.00102.21           O  
ATOM   2699  OE2 GLU D 115      14.677  62.802  48.417  1.00102.21           O  
ATOM   2700  N   VAL D 116      10.683  65.367  48.328  1.00 63.12           N  
ATOM   2701  CA  VAL D 116      10.497  66.768  48.657  1.00 63.12           C  
ATOM   2702  C   VAL D 116      10.288  66.916  50.166  1.00 63.12           C  
ATOM   2703  O   VAL D 116      10.832  67.828  50.781  1.00 63.12           O  
ATOM   2704  CB  VAL D 116       9.319  67.377  47.861  1.00 65.67           C  
ATOM   2705  CG1 VAL D 116       8.040  66.691  48.230  1.00 65.67           C  
ATOM   2706  CG2 VAL D 116       9.229  68.872  48.110  1.00 65.67           C  
ATOM   2707  N   PHE D 117       9.525  66.009  50.766  1.00 39.45           N  
ATOM   2708  CA  PHE D 117       9.303  66.045  52.213  1.00 39.46           C  
ATOM   2709  C   PHE D 117      10.629  65.806  52.938  1.00 39.46           C  
ATOM   2710  O   PHE D 117      10.699  65.010  53.872  1.00 39.47           O  
ATOM   2711  CB  PHE D 117       8.327  64.950  52.661  1.00 37.63           C  
ATOM   2712  CG  PHE D 117       6.912  65.125  52.171  1.00 37.63           C  
ATOM   2713  CD1 PHE D 117       6.555  66.200  51.366  1.00 37.63           C  
ATOM   2714  CD2 PHE D 117       5.940  64.182  52.499  1.00 37.63           C  
ATOM   2715  CE1 PHE D 117       5.248  66.332  50.890  1.00 37.62           C  
ATOM   2716  CE2 PHE D 117       4.639  64.303  52.032  1.00 37.63           C  
ATOM   2717  CZ  PHE D 117       4.293  65.383  51.223  1.00 37.63           C  
ATOM   2718  N   THR D 118      11.684  66.475  52.494  1.00 82.89           N  
ATOM   2719  CA  THR D 118      13.000  66.335  53.108  1.00 82.88           C  
ATOM   2720  C   THR D 118      13.834  67.553  52.715  1.00 82.92           C  
ATOM   2721  O   THR D 118      14.370  67.633  51.608  1.00 82.91           O  
ATOM   2722  CB  THR D 118      13.712  65.024  52.651  1.00 59.29           C  
ATOM   2723  OG1 THR D 118      12.999  63.881  53.154  1.00 59.28           O  
ATOM   2724  CG2 THR D 118      15.157  64.993  53.161  1.00 59.29           C  
ATOM   2725  N   GLU D 119      13.927  68.503  53.641  1.00102.20           N  
ATOM   2726  CA  GLU D 119      14.659  69.743  53.416  1.00102.21           C  
ATOM   2727  C   GLU D 119      15.954  69.790  54.208  1.00102.21           C  
ATOM   2728  O   GLU D 119      17.046  69.777  53.643  1.00102.21           O  
ATOM   2729  CB  GLU D 119      13.773  70.927  53.808  1.00102.21           C  
ATOM   2730  CG  GLU D 119      14.335  72.295  53.476  1.00102.21           C  
ATOM   2731  CD  GLU D 119      13.345  73.411  53.787  1.00102.21           C  
ATOM   2732  OE1 GLU D 119      12.231  73.400  53.217  1.00102.21           O  
ATOM   2733  OE2 GLU D 119      13.674  74.298  54.605  1.00102.21           O  
ATOM   2734  N   ASN D 120      15.817  69.845  55.526  1.00102.21           N  
ATOM   2735  CA  ASN D 120      16.969  69.905  56.416  1.00102.21           C  
ATOM   2736  C   ASN D 120      16.861  68.892  57.547  1.00102.21           C  
ATOM   2737  O   ASN D 120      17.347  69.127  58.655  1.00102.21           O  
ATOM   2738  CB  ASN D 120      17.103  71.314  57.001  1.00102.21           C  
ATOM   2739  CG  ASN D 120      17.581  72.329  55.976  1.00102.21           C  
ATOM   2740  OD1 ASN D 120      17.076  72.381  54.849  1.00102.21           O  
ATOM   2741  ND2 ASN D 120      18.558  73.149  56.368  1.00102.21           N  
ATOM   2742  N   ASP D 121      16.213  67.765  57.268  1.00102.21           N  
ATOM   2743  CA  ASP D 121      16.065  66.724  58.275  1.00102.21           C  
ATOM   2744  C   ASP D 121      17.434  66.128  58.603  1.00102.21           C  
ATOM   2745  O   ASP D 121      17.730  65.848  59.761  1.00102.21           O  
ATOM   2746  CB  ASP D 121      15.110  65.628  57.782  1.00 98.27           C  
ATOM   2747  CG  ASP D 121      13.661  66.102  57.700  1.00 98.27           C  
ATOM   2748  OD1 ASP D 121      13.069  66.433  58.751  1.00 98.27           O  
ATOM   2749  OD2 ASP D 121      13.114  66.144  56.580  1.00 98.27           O  
ATOM   2750  N   PRO D 122      18.287  65.930  57.582  1.00101.36           N  
ATOM   2751  CA  PRO D 122      19.627  65.367  57.784  1.00101.36           C  
ATOM   2752  C   PRO D 122      20.692  66.447  57.956  1.00101.36           C  
ATOM   2753  O   PRO D 122      21.519  66.319  58.885  1.00102.21           O  
ATOM   2754  CB  PRO D 122      19.843  64.559  56.516  1.00102.21           C  
ATOM   2755  CG  PRO D 122      19.241  65.467  55.486  1.00102.21           C  
ATOM   2756  CD  PRO D 122      17.945  65.938  56.144  1.00102.21           C  
TER    2757      PRO D 122                                                      
END
MOLECULE T0408.pdb
ATOM    769  N   PHE     7       8.970  79.991  40.219  1.00 59.01           N  
ATOM    770  CA  PHE     7       9.121  78.887  39.220  1.00 58.55           C  
ATOM    771  C   PHE     7      10.525  78.270  39.318  1.00 57.17           C  
ATOM    772  O   PHE     7      11.448  78.885  39.884  1.00 59.33           O  
ATOM    773  CB  PHE     7       8.894  79.403  37.792  1.00 59.50           C  
ATOM    774  CG  PHE     7       7.630  80.211  37.607  1.00 59.88           C  
ATOM    775  CD1 PHE     7       7.640  81.590  37.779  1.00 59.55           C  
ATOM    776  CD2 PHE     7       6.441  79.594  37.219  1.00 60.26           C  
ATOM    777  CE1 PHE     7       6.481  82.338  37.600  1.00 63.27           C  
ATOM    778  CE2 PHE     7       5.280  80.335  37.027  1.00 57.96           C  
ATOM    779  CZ  PHE     7       5.299  81.709  37.222  1.00 60.10           C  
ATOM    780  N   GLY     8      10.693  77.077  38.739  1.00 51.97           N  
ATOM    781  CA  GLY     8      11.946  76.308  38.864  1.00 47.06           C  
ATOM    782  C   GLY     8      13.010  76.644  37.842  1.00 42.74           C  
ATOM    783  O   GLY     8      12.960  77.691  37.199  1.00 40.60           O  
ATOM    784  N   GLU     9      13.969  75.734  37.690  1.00 39.01           N  
ATOM    785  CA  GLU     9      15.125  75.924  36.812  1.00 38.04           C  
ATOM    786  C   GLU     9      14.737  76.079  35.344  1.00 34.61           C  
ATOM    787  O   GLU     9      15.312  76.893  34.624  1.00 33.70           O  
ATOM    788  CB  GLU     9      16.093  74.746  36.964  1.00 38.65           C  
ATOM    789  N   GLY    10      13.750  75.287  34.915  1.00 34.19           N  
ATOM    790  CA  GLY    10      13.250  75.348  33.551  1.00 31.10           C  
ATOM    791  C   GLY    10      12.790  76.744  33.220  1.00 25.97           C  
ATOM    792  O   GLY    10      13.200  77.304  32.203  1.00 24.44           O  
ATOM    793  N   MET    11      11.958  77.314  34.091  1.00 26.78           N  
ATOM    794  CA  MET    11      11.453  78.679  33.871  1.00 26.99           C  
ATOM    795  C   MET    11      12.547  79.734  33.936  1.00 24.54           C  
ATOM    796  O   MET    11      12.436  80.750  33.237  1.00 22.59           O  
ATOM    797  CB  MET    11      10.298  79.036  34.809  1.00 26.96           C  
ATOM    798  CG  MET    11       8.956  78.424  34.384  1.00 30.81           C  
ATOM    799  SD  MET    11       8.363  79.163  32.682  0.75 32.36          SE  
ATOM    800  CE  MET    11       7.641  80.815  33.439  1.00 38.14           C  
ATOM    801  N   LYS    12      13.587  79.531  34.749  1.00 22.58           N  
ATOM    802  CA  LYS    12      14.709  80.488  34.749  1.00 22.98           C  
ATOM    803  C   LYS    12      15.471  80.468  33.411  1.00 20.97           C  
ATOM    804  O   LYS    12      15.931  81.507  32.944  1.00 22.83           O  
ATOM    805  CB  LYS    12      15.656  80.233  35.932  1.00 24.68           C  
ATOM    806  CG  LYS    12      14.987  80.568  37.290  1.00 26.05           C  
ATOM    807  CD  LYS    12      15.724  79.996  38.524  1.00 31.53           C  
ATOM    808  CE  LYS    12      17.178  80.177  38.487  1.00 33.33           C  
ATOM    809  NZ  LYS    12      17.857  79.899  39.811  1.00 35.75           N  
ATOM    810  N   VAL    13      15.558  79.292  32.784  1.00 23.05           N  
ATOM    811  CA  VAL    13      16.174  79.143  31.455  1.00 22.27           C  
ATOM    812  C   VAL    13      15.338  79.931  30.437  1.00 19.87           C  
ATOM    813  O   VAL    13      15.870  80.675  29.599  1.00 19.37           O  
ATOM    814  CB  VAL    13      16.227  77.631  31.026  1.00 24.12           C  
ATOM    815  CG1 VAL    13      16.716  77.489  29.584  1.00 25.29           C  
ATOM    816  CG2 VAL    13      17.136  76.836  31.979  1.00 30.23           C  
ATOM    817  N   VAL    14      14.032  79.817  30.576  1.00 20.72           N  
ATOM    818  CA  VAL    14      13.119  80.535  29.668  1.00 22.65           C  
ATOM    819  C   VAL    14      13.274  82.037  29.865  1.00 19.62           C  
ATOM    820  O   VAL    14      13.348  82.784  28.895  1.00 20.37           O  
ATOM    821  CB  VAL    14      11.657  80.121  29.823  1.00 21.69           C  
ATOM    822  CG1 VAL    14      10.788  80.938  28.849  1.00 21.74           C  
ATOM    823  CG2 VAL    14      11.465  78.585  29.542  1.00 26.25           C  
ATOM    824  N   LYS    15      13.332  82.483  31.131  1.00 21.22           N  
ATOM    825  CA  LYS    15      13.580  83.912  31.414  1.00 18.46           C  
ATOM    826  C   LYS    15      14.866  84.401  30.767  1.00 19.65           C  
ATOM    827  O   LYS    15      14.894  85.480  30.187  1.00 22.14           O  
ATOM    828  CB  LYS    15      13.617  84.181  32.921  1.00 18.27           C  
ATOM    829  N   GLU    16      15.918  83.608  30.857  1.00 21.08           N  
ATOM    830  CA  GLU    16      17.202  83.950  30.227  1.00 22.56           C  
ATOM    831  C   GLU    16      17.144  83.974  28.678  1.00 22.82           C  
ATOM    832  O   GLU    16      17.665  84.891  28.042  1.00 28.47           O  
ATOM    833  CB  GLU    16      18.277  82.981  30.693  1.00 24.31           C  
ATOM    834  N   LYS    17      16.521  82.963  28.097  1.00 21.86           N  
ATOM    835  CA  LYS    17      16.542  82.770  26.636  1.00 22.20           C  
ATOM    836  C   LYS    17      15.493  83.586  25.851  1.00 21.86           C  
ATOM    837  O   LYS    17      15.808  84.146  24.776  1.00 23.86           O  
ATOM    838  CB  LYS    17      16.365  81.277  26.315  1.00 21.29           C  
ATOM    839  N   TYR    18      14.290  83.672  26.407  1.00 22.99           N  
ATOM    840  CA  TYR    18      13.084  84.212  25.724  1.00 24.08           C  
ATOM    841  C   TYR    18      12.235  85.030  26.691  1.00 21.96           C  
ATOM    842  O   TYR    18      11.217  84.579  27.196  1.00 21.62           O  
ATOM    843  CB  TYR    18      12.270  83.071  25.102  1.00 23.86           C  
ATOM    844  CG  TYR    18      13.142  82.276  24.153  1.00 25.16           C  
ATOM    845  CD1 TYR    18      13.658  82.867  23.007  1.00 22.60           C  
ATOM    846  CD2 TYR    18      13.503  80.967  24.432  1.00 27.55           C  
ATOM    847  CE1 TYR    18      14.496  82.174  22.142  1.00 26.49           C  
ATOM    848  CE2 TYR    18      14.364  80.270  23.576  1.00 26.29           C  
ATOM    849  CZ  TYR    18      14.846  80.874  22.433  1.00 25.54           C  
ATOM    850  OH  TYR    18      15.686  80.188  21.581  1.00 26.16           O  
ATOM    851  N   PRO    19      12.703  86.256  26.994  1.00 22.95           N  
ATOM    852  CA  PRO    19      12.008  87.103  27.963  1.00 20.97           C  
ATOM    853  C   PRO    19      10.540  87.377  27.666  1.00 23.47           C  
ATOM    854  O   PRO    19       9.729  87.342  28.598  1.00 22.73           O  
ATOM    855  CB  PRO    19      12.823  88.395  27.933  1.00 22.49           C  
ATOM    856  CG  PRO    19      14.111  88.033  27.370  1.00 24.22           C  
ATOM    857  CD  PRO    19      13.956  86.869  26.528  1.00 23.77           C  
ATOM    858  N   ASP    20      10.175  87.629  26.413  1.00 23.93           N  
ATOM    859  CA  ASP    20       8.772  87.917  26.104  1.00 28.48           C  
ATOM    860  C   ASP    20       7.908  86.671  26.266  1.00 26.25           C  
ATOM    861  O   ASP    20       6.756  86.723  26.775  1.00 26.13           O  
ATOM    862  CB  ASP    20       8.618  88.482  24.690  1.00 30.80           C  
ATOM    863  CG  ASP    20       9.052  89.954  24.570  1.00 38.16           C  
ATOM    864  OD1 ASP    20       9.402  90.617  25.580  1.00 42.94           O  
ATOM    865  OD2 ASP    20       9.033  90.451  23.426  1.00 46.06           O  
ATOM    866  N   LEU    21       8.444  85.524  25.878  1.00 24.97           N  
ATOM    867  CA  LEU    21       7.721  84.269  26.090  1.00 23.54           C  
ATOM    868  C   LEU    21       7.555  83.994  27.575  1.00 22.52           C  
ATOM    869  O   LEU    21       6.474  83.604  28.042  1.00 24.44           O  
ATOM    870  CB  LEU    21       8.447  83.115  25.385  1.00 23.74           C  
ATOM    871  CG  LEU    21       7.857  81.731  25.468  1.00 25.87           C  
ATOM    872  CD1 LEU    21       6.373  81.718  24.990  1.00 25.00           C  
ATOM    873  CD2 LEU    21       8.754  80.756  24.680  1.00 23.70           C  
ATOM    874  N   TYR    22       8.626  84.193  28.326  1.00 22.41           N  
ATOM    875  CA  TYR    22       8.584  84.070  29.780  1.00 22.77           C  
ATOM    876  C   TYR    22       7.435  84.913  30.380  1.00 22.67           C  
ATOM    877  O   TYR    22       6.627  84.425  31.175  1.00 23.91           O  
ATOM    878  CB  TYR    22       9.912  84.494  30.385  1.00 23.66           C  
ATOM    879  CG  TYR    22       9.886  84.492  31.893  1.00 22.50           C  
ATOM    880  CD1 TYR    22      10.074  83.325  32.604  1.00 23.27           C  
ATOM    881  CD2 TYR    22       9.660  85.671  32.602  1.00 25.67           C  
ATOM    882  CE1 TYR    22      10.047  83.327  33.987  1.00 21.18           C  
ATOM    883  CE2 TYR    22       9.622  85.671  33.963  1.00 25.00           C  
ATOM    884  CZ  TYR    22       9.808  84.488  34.647  1.00 23.45           C  
ATOM    885  OH  TYR    22       9.784  84.487  35.999  1.00 27.44           O  
ATOM    886  N   ASP    23       7.378  86.174  29.980  1.00 23.82           N  
ATOM    887  CA  ASP    23       6.360  87.088  30.502  1.00 24.16           C  
ATOM    888  C   ASP    23       4.927  86.625  30.205  1.00 25.07           C  
ATOM    889  O   ASP    23       4.046  86.754  31.064  1.00 23.28           O  
ATOM    890  CB  ASP    23       6.577  88.482  29.910  1.00 24.42           C  
ATOM    891  CG  ASP    23       7.742  89.194  30.505  1.00 33.39           C  
ATOM    892  OD1 ASP    23       8.216  88.809  31.607  1.00 34.11           O  
ATOM    893  OD2 ASP    23       8.170  90.189  29.868  1.00 37.66           O  
ATOM    894  N   ILE    24       4.693  86.066  29.019  1.00 23.65           N  
ATOM    895  CA  ILE    24       3.350  85.619  28.651  1.00 24.84           C  
ATOM    896  C   ILE    24       3.018  84.370  29.489  1.00 23.61           C  
ATOM    897  O   ILE    24       1.899  84.210  29.967  1.00 24.22           O  
ATOM    898  CB  ILE    24       3.222  85.316  27.150  1.00 27.79           C  
ATOM    899  CG1 ILE    24       3.448  86.587  26.329  1.00 32.72           C  
ATOM    900  CG2 ILE    24       1.848  84.746  26.841  1.00 30.67           C  
ATOM    901  CD1 ILE    24       3.838  86.311  24.854  1.00 35.16           C  
ATOM    902  N   ILE    25       4.024  83.514  29.707  1.00 24.35           N  
ATOM    903  CA  ILE    25       3.817  82.316  30.523  1.00 24.21           C  
ATOM    904  C   ILE    25       3.445  82.707  31.965  1.00 23.22           C  
ATOM    905  O   ILE    25       2.509  82.132  32.562  1.00 25.47           O  
ATOM    906  CB  ILE    25       5.047  81.338  30.493  1.00 24.22           C  
ATOM    907  CG1 ILE    25       5.238  80.729  29.103  1.00 23.74           C  
ATOM    908  CG2 ILE    25       4.856  80.188  31.494  1.00 29.35           C  
ATOM    909  CD1 ILE    25       6.631  80.075  28.922  1.00 23.35           C  
ATOM    910  N   VAL    26       4.144  83.697  32.511  1.00 24.58           N  
ATOM    911  CA  VAL    26       3.846  84.171  33.859  1.00 26.19           C  
ATOM    912  C   VAL    26       2.405  84.710  33.937  1.00 24.90           C  
ATOM    913  O   VAL    26       1.639  84.349  34.854  1.00 24.16           O  
ATOM    914  CB  VAL    26       4.836  85.230  34.313  1.00 28.22           C  
ATOM    915  CG1 VAL    26       4.301  85.976  35.531  1.00 28.71           C  
ATOM    916  CG2 VAL    26       6.242  84.589  34.603  1.00 26.39           C  
ATOM    917  N   LYS    27       2.006  85.523  32.967  1.00 23.37           N  
ATOM    918  CA  LYS    27       0.622  86.024  32.925  0.50 23.88           C  
ATOM    920  C   LYS    27      -0.377  84.879  32.823  1.00 24.17           C  
ATOM    921  O   LYS    27      -1.387  84.886  33.498  1.00 24.41           O  
ATOM    922  CB  LYS    27       0.414  87.028  31.779  0.50 24.31           C  
ATOM    924  CG  LYS    27       1.172  88.334  31.934  0.50 20.98           C  
ATOM    926  N   LEU    28      -0.091  83.873  31.981  1.00 23.31           N  
ATOM    927  CA  LEU    28      -0.962  82.705  31.832  1.00 25.23           C  
ATOM    928  C   LEU    28      -1.121  81.995  33.180  1.00 25.13           C  
ATOM    929  O   LEU    28      -2.231  81.653  33.640  1.00 24.63           O  
ATOM    930  CB  LEU    28      -0.374  81.739  30.788  1.00 23.04           C  
ATOM    931  CG  LEU    28      -1.148  80.428  30.624  1.00 24.78           C  
ATOM    932  CD1 LEU    28      -2.545  80.697  30.079  1.00 32.09           C  
ATOM    933  CD2 LEU    28      -0.369  79.493  29.738  1.00 28.12           C  
ATOM    934  N   ASN    29       0.023  81.773  33.828  1.00 22.56           N  
ATOM    935  CA  ASN    29       0.048  81.101  35.117  1.00 24.38           C  
ATOM    936  C   ASN    29      -0.813  81.844  36.140  1.00 22.89           C  
ATOM    937  O   ASN    29      -1.651  81.255  36.839  1.00 26.79           O  
ATOM    938  CB  ASN    29       1.491  80.993  35.606  1.00 27.63           C  
ATOM    939  CG  ASN    29       1.585  80.340  36.962  1.00 33.82           C  
ATOM    940  OD1 ASN    29       1.667  79.126  37.053  1.00 33.33           O  
ATOM    941  ND2 ASN    29       1.566  81.143  38.011  1.00 35.43           N  
ATOM    942  N   ASP    30      -0.596  83.141  36.234  1.00 22.88           N  
ATOM    943  CA  ASP    30      -1.285  83.973  37.203  1.00 24.82           C  
ATOM    944  C   ASP    30      -2.797  84.034  36.943  1.00 25.07           C  
ATOM    945  O   ASP    30      -3.601  84.001  37.880  1.00 26.99           O  
ATOM    946  CB  ASP    30      -0.694  85.365  37.193  1.00 26.68           C  
ATOM    947  CG  ASP    30       0.726  85.408  37.720  1.00 28.43           C  
ATOM    948  OD1 ASP    30       1.234  84.358  38.174  1.00 35.44           O  
ATOM    949  OD2 ASP    30       1.331  86.499  37.649  1.00 29.80           O  
ATOM    950  N   THR    31      -3.173  84.070  35.675  1.00 22.79           N  
ATOM    951  CA  THR    31      -4.600  83.984  35.289  1.00 24.26           C  
ATOM    952  C   THR    31      -5.213  82.620  35.540  1.00 23.93           C  
ATOM    953  O   THR    31      -6.339  82.515  36.082  1.00 24.83           O  
ATOM    954  CB  THR    31      -4.809  84.366  33.824  1.00 22.72           C  
ATOM    955  OG1 THR    31      -4.260  85.683  33.614  1.00 30.25           O  
ATOM    956  CG2 THR    31      -6.307  84.307  33.460  1.00 24.57           C  
ATOM    957  N   VAL    32      -4.509  81.554  35.146  1.00 22.77           N  
ATOM    958  CA  VAL    32      -4.974  80.194  35.438  1.00 24.03           C  
ATOM    959  C   VAL    32      -5.286  80.043  36.936  1.00 23.77           C  
ATOM    960  O   VAL    32      -6.329  79.469  37.304  1.00 25.63           O  
ATOM    961  CB  VAL    32      -3.924  79.174  34.994  1.00 23.98           C  
ATOM    962  CG1 VAL    32      -4.033  77.835  35.796  1.00 24.54           C  
ATOM    963  CG2 VAL    32      -4.012  78.986  33.460  1.00 22.05           C  
ATOM    964  N   PHE    33      -4.431  80.590  37.799  1.00 23.43           N  
ATOM    965  CA  PHE    33      -4.601  80.397  39.246  1.00 25.33           C  
ATOM    966  C   PHE    33      -5.403  81.502  39.922  1.00 27.87           C  
ATOM    967  O   PHE    33      -5.384  81.637  41.159  1.00 27.20           O  
ATOM    968  CB  PHE    33      -3.266  80.181  39.951  1.00 27.45           C  
ATOM    969  CG  PHE    33      -2.688  78.829  39.709  1.00 26.58           C  
ATOM    970  CD1 PHE    33      -3.361  77.688  40.124  1.00 26.58           C  
ATOM    971  CD2 PHE    33      -1.487  78.692  39.040  1.00 27.16           C  
ATOM    972  CE1 PHE    33      -2.844  76.433  39.875  1.00 26.69           C  
ATOM    973  CE2 PHE    33      -0.960  77.444  38.790  1.00 25.47           C  
ATOM    974  CZ  PHE    33      -1.643  76.315  39.204  1.00 28.16           C  
ATOM    975  N   THR    34      -6.104  82.288  39.114  1.00 28.08           N  
ATOM    976  CA  THR    34      -7.123  83.205  39.620  1.00 27.68           C  
ATOM    977  C   THR    34      -8.472  82.607  39.227  1.00 26.27           C  
ATOM    978  O   THR    34      -9.079  82.991  38.223  1.00 24.59           O  
ATOM    979  CB  THR    34      -6.912  84.630  39.078  1.00 29.15           C  
ATOM    980  OG1 THR    34      -5.572  85.039  39.354  1.00 27.52           O  
ATOM    981  CG2 THR    34      -7.858  85.624  39.752  1.00 27.57           C  
ATOM    982  N   GLY    35      -8.916  81.627  40.013  1.00 23.37           N  
ATOM    983  CA  GLY    35     -10.169  80.966  39.763  1.00 26.15           C  
ATOM    984  C   GLY    35     -11.353  81.880  40.008  1.00 26.00           C  
ATOM    985  O   GLY    35     -11.261  82.862  40.761  1.00 26.21           O  
ATOM    986  N   LYS    36     -12.466  81.593  39.353  1.00 26.20           N  
ATOM    987  CA  LYS    36     -13.707  82.364  39.626  1.00 25.52           C  
ATOM    988  C   LYS    36     -14.401  81.918  40.902  1.00 25.59           C  
ATOM    989  O   LYS    36     -15.013  82.749  41.608  1.00 24.82           O  
ATOM    990  CB  LYS    36     -14.650  82.280  38.433  1.00 23.76           C  
ATOM    991  CG  LYS    36     -14.018  82.839  37.170  1.00 27.92           C  
ATOM    992  CD  LYS    36     -13.636  84.274  37.261  1.00 33.79           C  
ATOM    993  CE  LYS    36     -13.123  84.756  35.913  1.00 33.74           C  
ATOM    994  NZ  LYS    36     -12.672  86.191  35.921  1.00 36.41           N  
ATOM    995  N   THR    37     -14.305  80.634  41.224  1.00 26.34           N  
ATOM    996  CA  THR    37     -14.895  80.088  42.444  1.00 27.40           C  
ATOM    997  C   THR    37     -13.901  79.304  43.281  1.00 28.68           C  
ATOM    998  O   THR    37     -13.830  79.501  44.486  1.00 28.44           O  
ATOM    999  CB  THR    37     -16.085  79.125  42.147  1.00 30.61           C  
ATOM   1000  OG1 THR    37     -17.140  79.845  41.507  1.00 34.12           O  
ATOM   1001  CG2 THR    37     -16.683  78.562  43.442  1.00 27.91           C  
ATOM   1002  N   LEU    38     -13.154  78.398  42.652  1.00 24.44           N  
ATOM   1003  CA  LEU    38     -12.190  77.556  43.382  1.00 24.53           C  
ATOM   1004  C   LEU    38     -11.018  78.408  43.841  1.00 26.73           C  
ATOM   1005  O   LEU    38     -10.561  79.304  43.117  1.00 26.13           O  
ATOM   1006  CB  LEU    38     -11.682  76.416  42.494  1.00 24.24           C  
ATOM   1007  CG  LEU    38     -12.721  75.446  41.996  1.00 25.01           C  
ATOM   1008  CD1 LEU    38     -12.043  74.310  41.217  1.00 23.26           C  
ATOM   1009  CD2 LEU    38     -13.555  74.919  43.151  1.00 22.80           C  
ATOM   1010  N   ASP    39     -10.539  78.150  45.053  1.00 25.77           N  
ATOM   1011  CA  ASP    39      -9.405  78.915  45.556  1.00 26.59           C  
ATOM   1012  C   ASP    39      -8.085  78.324  45.076  1.00 26.80           C  
ATOM   1013  O   ASP    39      -8.046  77.280  44.439  1.00 24.07           O  
ATOM   1014  CB  ASP    39      -9.484  79.093  47.084  1.00 27.84           C  
ATOM   1015  CG  ASP    39      -9.352  77.804  47.861  1.00 31.36           C  
ATOM   1016  OD1 ASP    39      -8.887  76.754  47.351  1.00 28.62           O  
ATOM   1017  OD2 ASP    39      -9.729  77.848  49.052  1.00 33.78           O  
ATOM   1018  N   TYR    40      -7.011  79.046  45.327  1.00 25.33           N  
ATOM   1019  CA  TYR    40      -5.703  78.664  44.822  1.00 24.51           C  
ATOM   1020  C   TYR    40      -5.243  77.312  45.372  1.00 25.46           C  
ATOM   1021  O   TYR    40      -4.698  76.478  44.641  1.00 24.60           O  
ATOM   1022  CB  TYR    40      -4.723  79.753  45.247  1.00 28.58           C  
ATOM   1023  CG  TYR    40      -3.320  79.640  44.733  1.00 27.35           C  
ATOM   1024  CD1 TYR    40      -3.051  79.264  43.426  1.00 42.63           C  
ATOM   1025  CD2 TYR    40      -2.241  79.981  45.555  1.00 35.86           C  
ATOM   1026  CE1 TYR    40      -1.744  79.202  42.958  1.00 45.32           C  
ATOM   1027  CE2 TYR    40      -0.946  79.919  45.099  1.00 36.50           C  
ATOM   1028  CZ  TYR    40      -0.701  79.543  43.803  1.00 41.69           C  
ATOM   1029  OH  TYR    40       0.596  79.495  43.344  1.00 43.10           O  
ATOM   1030  N   LYS    41      -5.466  77.097  46.659  1.00 24.17           N  
ATOM   1031  CA  LYS    41      -5.137  75.787  47.259  1.00 26.03           C  
ATOM   1032  C   LYS    41      -5.786  74.622  46.516  1.00 24.80           C  
ATOM   1033  O   LYS    41      -5.121  73.627  46.222  1.00 24.41           O  
ATOM   1034  CB  LYS    41      -5.525  75.756  48.725  1.00 26.17           C  
ATOM   1035  CG  LYS    41      -5.211  74.458  49.459  1.00 31.58           C  
ATOM   1036  CD  LYS    41      -5.774  74.499  50.886  1.00 33.11           C  
ATOM   1037  CE  LYS    41      -5.347  73.283  51.704  1.00 42.88           C  
ATOM   1038  NZ  LYS    41      -5.846  73.354  53.109  1.00 41.08           N  
ATOM   1039  N   THR    42      -7.074  74.738  46.237  1.00 24.70           N  
ATOM   1040  CA  THR    42      -7.798  73.688  45.520  1.00 23.81           C  
ATOM   1041  C   THR    42      -7.217  73.448  44.133  1.00 24.23           C  
ATOM   1042  O   THR    42      -7.022  72.317  43.719  1.00 23.25           O  
ATOM   1043  CB  THR    42      -9.301  73.985  45.416  1.00 24.82           C  
ATOM   1044  OG1 THR    42      -9.845  74.084  46.733  1.00 25.22           O  
ATOM   1045  CG2 THR    42     -10.038  72.883  44.667  1.00 25.77           C  
ATOM   1046  N   GLN    43      -6.933  74.527  43.418  1.00 23.43           N  
ATOM   1047  CA  GLN    43      -6.319  74.414  42.118  1.00 22.86           C  
ATOM   1048  C   GLN    43      -4.922  73.781  42.157  1.00 23.94           C  
ATOM   1049  O   GLN    43      -4.585  73.025  41.268  1.00 22.91           O  
ATOM   1050  CB  GLN    43      -6.246  75.772  41.437  1.00 24.01           C  
ATOM   1051  CG  GLN    43      -7.565  76.328  41.029  1.00 22.72           C  
ATOM   1052  CD  GLN    43      -7.399  77.608  40.263  1.00 23.02           C  
ATOM   1053  OE1 GLN    43      -6.876  78.573  40.809  1.00 25.62           O  
ATOM   1054  NE2 GLN    43      -7.853  77.631  39.000  1.00 24.23           N  
ATOM   1055  N   LYS    44      -4.119  74.119  43.152  1.00 23.49           N  
ATOM   1056  CA  LYS    44      -2.798  73.504  43.293  1.00 22.94           C  
ATOM   1057  C   LYS    44      -2.885  72.010  43.618  1.00 23.73           C  
ATOM   1058  O   LYS    44      -2.073  71.231  43.139  1.00 23.97           O  
ATOM   1059  CB  LYS    44      -1.964  74.236  44.353  1.00 26.12           C  
ATOM   1060  CG  LYS    44      -1.383  75.517  43.796  1.00 37.14           C  
ATOM   1061  CD  LYS    44      -0.199  75.250  42.854  1.00 40.63           C  
ATOM   1062  CE  LYS    44       0.270  76.569  42.238  1.00 46.64           C  
ATOM   1063  NZ  LYS    44       1.409  76.414  41.283  1.00 41.05           N  
ATOM   1064  N   LEU    45      -3.875  71.626  44.416  1.00 22.77           N  
ATOM   1065  CA  LEU    45      -4.158  70.192  44.683  1.00 22.94           C  
ATOM   1066  C   LEU    45      -4.528  69.448  43.403  1.00 20.00           C  
ATOM   1067  O   LEU    45      -4.064  68.333  43.149  1.00 21.82           O  
ATOM   1068  CB  LEU    45      -5.255  70.034  45.759  1.00 24.89           C  
ATOM   1069  CG  LEU    45      -4.872  70.484  47.179  1.00 24.96           C  
ATOM   1070  CD1 LEU    45      -6.093  70.532  48.099  1.00 25.24           C  
ATOM   1071  CD2 LEU    45      -3.795  69.570  47.786  1.00 26.64           C  
ATOM   1072  N   ILE    46      -5.331  70.092  42.557  1.00 20.74           N  
ATOM   1073  CA  ILE    46      -5.651  69.564  41.249  1.00 21.62           C  
ATOM   1074  C   ILE    46      -4.391  69.407  40.390  1.00 20.78           C  
ATOM   1075  O   ILE    46      -4.202  68.383  39.737  1.00 21.91           O  
ATOM   1076  CB  ILE    46      -6.704  70.453  40.547  1.00 22.08           C  
ATOM   1077  CG1 ILE    46      -8.055  70.378  41.275  1.00 24.84           C  
ATOM   1078  CG2 ILE    46      -6.892  70.056  39.052  1.00 22.38           C  
ATOM   1079  CD1 ILE    46      -9.010  71.552  40.931  1.00 22.86           C  
ATOM   1080  N   ALA    47      -3.523  70.426  40.416  1.00 21.87           N  
ATOM   1081  CA  ALA    47      -2.279  70.384  39.643  1.00 21.24           C  
ATOM   1082  C   ALA    47      -1.416  69.194  40.090  1.00 21.15           C  
ATOM   1083  O   ALA    47      -0.852  68.486  39.264  1.00 23.10           O  
ATOM   1084  CB  ALA    47      -1.507  71.727  39.768  1.00 21.67           C  
ATOM   1085  N   ILE    48      -1.326  68.971  41.401  1.00 23.22           N  
ATOM   1086  CA  ILE    48      -0.581  67.815  41.934  1.00 23.42           C  
ATOM   1087  C   ILE    48      -1.151  66.535  41.379  1.00 22.45           C  
ATOM   1088  O   ILE    48      -0.412  65.683  40.917  1.00 22.38           O  
ATOM   1089  CB  ILE    48      -0.565  67.783  43.480  1.00 22.22           C  
ATOM   1090  CG1 ILE    48       0.257  68.942  44.048  1.00 26.05           C  
ATOM   1091  CG2 ILE    48       0.049  66.452  44.023  1.00 25.18           C  
ATOM   1092  CD1 ILE    48      -0.059  69.242  45.504  1.00 25.14           C  
ATOM   1093  N   GLY    49      -2.485  66.395  41.436  1.00 23.64           N  
ATOM   1094  CA  GLY    49      -3.152  65.223  40.890  1.00 22.69           C  
ATOM   1095  C   GLY    49      -2.810  64.948  39.439  1.00 22.13           C  
ATOM   1096  O   GLY    49      -2.514  63.817  39.044  1.00 22.25           O  
ATOM   1097  N   ILE    50      -2.858  65.995  38.620  1.00 21.97           N  
ATOM   1098  CA  ILE    50      -2.611  65.842  37.209  1.00 23.22           C  
ATOM   1099  C   ILE    50      -1.179  65.410  36.958  1.00 20.30           C  
ATOM   1100  O   ILE    50      -0.936  64.483  36.198  1.00 22.58           O  
ATOM   1101  CB  ILE    50      -2.928  67.132  36.415  1.00 23.33           C  
ATOM   1102  CG1 ILE    50      -4.446  67.402  36.425  1.00 25.36           C  
ATOM   1103  CG2 ILE    50      -2.410  67.043  34.958  1.00 25.70           C  
ATOM   1104  CD1 ILE    50      -4.873  68.780  35.946  1.00 23.40           C  
ATOM   1105  N   VAL    51      -0.226  66.112  37.554  1.00 22.13           N  
ATOM   1106  CA  VAL    51       1.198  65.805  37.361  0.50 22.96           C  
ATOM   1108  C   VAL    51       1.534  64.410  37.901  1.00 22.59           C  
ATOM   1109  O   VAL    51       2.294  63.639  37.290  1.00 23.85           O  
ATOM   1110  CB  VAL    51       2.072  66.864  38.052  0.50 23.96           C  
ATOM   1112  CG1 VAL    51       3.558  66.521  37.912  0.50 22.52           C  
ATOM   1114  CG2 VAL    51       1.793  68.268  37.453  0.50 24.56           C  
ATOM   1116  N   ALA    52       0.940  64.069  39.051  1.00 21.97           N  
ATOM   1117  CA  ALA    52       1.198  62.761  39.646  1.00 22.83           C  
ATOM   1118  C   ALA    52       0.615  61.626  38.821  1.00 24.96           C  
ATOM   1119  O   ALA    52       1.057  60.489  38.972  1.00 27.05           O  
ATOM   1120  CB  ALA    52       0.708  62.681  41.110  1.00 22.19           C  
ATOM   1121  N   SER    53      -0.366  61.908  37.962  1.00 23.44           N  
ATOM   1122  CA  SER    53      -0.993  60.900  37.128  0.50 24.03           C  
ATOM   1124  C   SER    53      -0.070  60.482  35.984  1.00 28.22           C  
ATOM   1125  O   SER    53      -0.306  59.463  35.352  1.00 29.44           O  
ATOM   1126  CB  SER    53      -2.358  61.369  36.590  0.50 24.46           C  
ATOM   1128  OG  SER    53      -2.273  62.367  35.572  0.50 17.33           O  
ATOM   1130  N   ARG    54       0.967  61.288  35.750  1.00 27.88           N  
ATOM   1131  CA  ARG    54       1.961  61.079  34.686  1.00 36.49           C  
ATOM   1132  C   ARG    54       3.323  60.666  35.269  1.00 42.51           C  
ATOM   1133  O   ARG    54       3.434  60.416  36.472  1.00 42.98           O  
ATOM   1134  CB  ARG    54       2.061  62.360  33.864  1.00 36.62           C  
ATOM   1135  CG  ARG    54       0.682  62.788  33.371  1.00 36.07           C  
ATOM   1136  CD  ARG    54       0.720  63.747  32.220  1.00 46.03           C  
ATOM   1137  NE  ARG    54       1.186  65.048  32.671  1.00 47.58           N  
ATOM   1138  CZ  ARG    54       0.593  66.218  32.427  1.00 48.31           C  
ATOM   1139  NH1 ARG    54      -0.539  66.301  31.716  1.00 41.50           N  
ATOM   1140  NH2 ARG    54       1.152  67.314  32.919  1.00 45.55           N  
ATOM   1141  N   CYS    55       4.364  60.567  34.441  1.00 47.81           N  
ATOM   1142  CA  CYS    55       5.609  59.917  34.908  1.00 53.06           C  
ATOM   1143  C   CYS    55       6.714  60.870  35.342  1.00 53.53           C  
ATOM   1144  O   CYS    55       7.760  60.423  35.818  1.00 55.63           O  
ATOM   1145  CB  CYS    55       6.175  58.963  33.844  1.00 54.41           C  
ATOM   1146  SG  CYS    55       4.966  57.829  33.125  1.00 70.70           S  
ATOM   1147  N   ASP    56       6.510  62.170  35.183  1.00 51.11           N  
ATOM   1148  CA  ASP    56       7.593  63.097  35.442  1.00 50.75           C  
ATOM   1149  C   ASP    56       7.796  63.237  36.966  1.00 47.60           C  
ATOM   1150  O   ASP    56       7.187  64.093  37.608  1.00 47.73           O  
ATOM   1151  CB  ASP    56       7.335  64.451  34.744  1.00 51.45           C  
ATOM   1152  CG  ASP    56       8.549  65.360  34.751  1.00 55.00           C  
ATOM   1153  OD1 ASP    56       9.598  64.950  35.298  1.00 59.75           O  
ATOM   1154  OD2 ASP    56       8.445  66.490  34.211  1.00 56.95           O  
ATOM   1155  N   GLU    57       8.662  62.376  37.505  1.00 44.76           N  
ATOM   1156  CA  GLU    57       9.079  62.384  38.919  1.00 44.68           C  
ATOM   1157  C   GLU    57       9.555  63.747  39.434  1.00 43.54           C  
ATOM   1158  O   GLU    57       9.225  64.151  40.554  1.00 39.20           O  
ATOM   1159  CB  GLU    57      10.193  61.362  39.121  1.00 44.24           C  
ATOM   1160  CG  GLU    57      10.658  61.181  40.556  1.00 49.33           C  
ATOM   1161  N   VAL    58      10.342  64.453  38.623  1.00 44.25           N  
ATOM   1162  CA  VAL    58      10.846  65.761  39.019  1.00 41.66           C  
ATOM   1163  C   VAL    58       9.712  66.771  39.079  1.00 39.99           C  
ATOM   1164  O   VAL    58       9.637  67.563  40.023  1.00 40.88           O  
ATOM   1165  CB  VAL    58      12.003  66.255  38.076  1.00 44.98           C  
ATOM   1166  N   ALA    59       8.820  66.732  38.092  1.00 36.00           N  
ATOM   1167  CA  ALA    59       7.624  67.563  38.085  1.00 36.40           C  
ATOM   1168  C   ALA    59       6.746  67.291  39.314  1.00 34.21           C  
ATOM   1169  O   ALA    59       6.208  68.222  39.935  1.00 33.66           O  
ATOM   1170  CB  ALA    59       6.840  67.324  36.816  1.00 37.99           C  
ATOM   1171  N   ILE    60       6.614  66.013  39.667  1.00 31.22           N  
ATOM   1172  CA  ILE    60       5.812  65.647  40.839  1.00 28.82           C  
ATOM   1173  C   ILE    60       6.454  66.198  42.119  1.00 27.71           C  
ATOM   1174  O   ILE    60       5.781  66.867  42.913  1.00 27.90           O  
ATOM   1175  CB  ILE    60       5.613  64.129  40.959  1.00 27.95           C  
ATOM   1176  CG1 ILE    60       4.862  63.584  39.742  1.00 27.51           C  
ATOM   1177  CG2 ILE    60       4.812  63.808  42.224  1.00 26.18           C  
ATOM   1178  CD1 ILE    60       4.987  62.071  39.545  1.00 25.07           C  
ATOM   1179  N   GLU    61       7.741  65.915  42.319  1.00 30.04           N  
ATOM   1180  CA  GLU    61       8.460  66.430  43.501  1.00 32.80           C  
ATOM   1181  C   GLU    61       8.345  67.964  43.626  1.00 35.05           C  
ATOM   1182  O   GLU    61       8.090  68.492  44.715  1.00 33.59           O  
ATOM   1183  CB  GLU    61       9.925  65.988  43.468  1.00 33.45           C  
ATOM   1184  CG  GLU    61      10.720  66.333  44.743  1.00 36.55           C  
ATOM   1185  N   LYS    62       8.492  68.665  42.503  1.00 38.76           N  
ATOM   1186  CA  LYS    62       8.430  70.135  42.479  1.00 39.30           C  
ATOM   1187  C   LYS    62       7.040  70.681  42.772  1.00 38.68           C  
ATOM   1188  O   LYS    62       6.906  71.655  43.526  1.00 36.68           O  
ATOM   1189  CB  LYS    62       8.919  70.670  41.123  1.00 42.11           C  
ATOM   1190  N   GLN    63       5.995  70.076  42.198  1.00 35.90           N  
ATOM   1191  CA  GLN    63       4.635  70.517  42.512  1.00 36.26           C  
ATOM   1192  C   GLN    63       4.355  70.313  43.989  1.00 33.33           C  
ATOM   1193  O   GLN    63       3.755  71.165  44.626  1.00 33.91           O  
ATOM   1194  CB  GLN    63       3.548  69.798  41.676  1.00 39.20           C  
ATOM   1195  CG  GLN    63       3.160  70.466  40.335  1.00 44.45           C  
ATOM   1196  CD  GLN    63       2.333  71.749  40.478  1.00 44.95           C  
ATOM   1197  OE1 GLN    63       1.712  72.008  41.510  1.00 62.12           O  
ATOM   1198  NE2 GLN    63       2.315  72.547  39.425  1.00 63.66           N  
ATOM   1199  N   MET    64       4.752  69.161  44.531  1.00 30.47           N  
ATOM   1200  CA  MET    64       4.471  68.856  45.916  1.00 26.68           C  
ATOM   1201  C   MET    64       5.225  69.810  46.838  1.00 29.86           C  
ATOM   1202  O   MET    64       4.645  70.361  47.788  1.00 28.23           O  
ATOM   1203  CB  MET    64       4.864  67.412  46.233  1.00 23.18           C  
ATOM   1204  CG  MET    64       3.918  66.370  45.589  1.00 22.57           C  
ATOM   1205  SD  MET    64       4.418  64.644  46.195  0.75 22.23          SE  
ATOM   1206  CE  MET    64       3.056  63.632  45.253  1.00 22.00           C  
ATOM   1207  N   LYS    65       6.514  69.998  46.544  1.00 32.32           N  
ATOM   1208  CA  LYS    65       7.386  70.856  47.371  1.00 34.88           C  
ATOM   1209  C   LYS    65       6.857  72.284  47.412  1.00 34.19           C  
ATOM   1210  O   LYS    65       6.702  72.863  48.483  1.00 35.31           O  
ATOM   1211  CB  LYS    65       8.826  70.843  46.843  1.00 35.46           C  
ATOM   1212  CG  LYS    65       9.625  69.629  47.243  1.00 40.38           C  
ATOM   1213  N   SER    66       6.564  72.836  46.245  1.00 36.71           N  
ATOM   1214  CA  SER    66       6.041  74.200  46.142  0.50 37.97           C  
ATOM   1216  C   SER    66       4.709  74.361  46.864  1.00 39.15           C  
ATOM   1217  O   SER    66       4.486  75.342  47.552  1.00 40.37           O  
ATOM   1218  CB  SER    66       5.895  74.618  44.676  0.50 38.61           C  
ATOM   1220  OG  SER    66       5.090  73.703  43.950  0.50 37.08           O  
ATOM   1222  N   ALA    67       3.815  73.392  46.707  1.00 37.33           N  
ATOM   1223  CA  ALA    67       2.536  73.447  47.409  1.00 35.90           C  
ATOM   1224  C   ALA    67       2.708  73.505  48.921  1.00 33.63           C  
ATOM   1225  O   ALA    67       2.000  74.242  49.614  1.00 33.38           O  
ATOM   1226  CB  ALA    67       1.675  72.239  47.036  1.00 35.08           C  
ATOM   1227  N   MET    68       3.620  72.690  49.440  1.00 32.12           N  
ATOM   1228  CA  MET    68       3.809  72.592  50.861  1.00 32.59           C  
ATOM   1229  C   MET    68       4.455  73.891  51.335  1.00 33.83           C  
ATOM   1230  O   MET    68       4.036  74.457  52.332  1.00 35.23           O  
ATOM   1231  CB  MET    68       4.684  71.396  51.205  1.00 33.38           C  
ATOM   1232  CG  MET    68       4.027  70.041  50.923  1.00 33.32           C  
ATOM   1233  SD  MET    68       5.192  68.597  51.472  0.75 34.95          SE  
ATOM   1234  CE  MET    68       4.864  68.765  53.369  1.00 39.85           C  
ATOM   1235  N   LYS    69       5.428  74.370  50.567  1.00 35.03           N  
ATOM   1236  CA  LYS    69       6.210  75.565  50.936  1.00 37.33           C  
ATOM   1237  C   LYS    69       5.376  76.830  50.796  1.00 38.14           C  
ATOM   1238  O   LYS    69       5.218  77.585  51.764  1.00 42.29           O  
ATOM   1239  CB  LYS    69       7.470  75.676  50.075  1.00 36.02           C  
ATOM   1240  N   GLU    70       4.833  77.048  49.606  1.00 39.17           N  
ATOM   1241  CA  GLU    70       4.066  78.262  49.302  1.00 40.19           C  
ATOM   1242  C   GLU    70       2.697  78.317  49.975  1.00 40.34           C  
ATOM   1243  O   GLU    70       2.343  79.342  50.543  1.00 42.02           O  
ATOM   1244  CB  GLU    70       3.909  78.452  47.786  1.00 39.25           C  
ATOM   1245  N   LEU    71       1.936  77.226  49.937  1.00 39.71           N  
ATOM   1246  CA  LEU    71       0.552  77.239  50.424  1.00 38.07           C  
ATOM   1247  C   LEU    71       0.339  76.549  51.771  1.00 34.95           C  
ATOM   1248  O   LEU    71      -0.765  76.565  52.307  1.00 37.25           O  
ATOM   1249  CB  LEU    71      -0.380  76.601  49.371  1.00 39.04           C  
ATOM   1250  CG  LEU    71      -0.453  77.252  47.981  1.00 43.95           C  
ATOM   1251  CD1 LEU    71       0.756  76.880  47.115  1.00 50.69           C  
ATOM   1252  CD2 LEU    71      -1.736  76.876  47.251  1.00 39.57           C  
ATOM   1253  N   GLY    72       1.355  75.907  52.325  1.00 31.62           N  
ATOM   1254  CA  GLY    72       1.147  75.169  53.571  1.00 31.33           C  
ATOM   1255  C   GLY    72       0.288  73.914  53.427  1.00 30.39           C  
ATOM   1256  O   GLY    72      -0.302  73.424  54.405  1.00 31.58           O  
ATOM   1257  N   ILE    73       0.217  73.377  52.213  1.00 32.06           N  
ATOM   1258  CA  ILE    73      -0.496  72.104  51.983  1.00 28.57           C  
ATOM   1259  C   ILE    73       0.221  70.989  52.779  1.00 29.16           C  
ATOM   1260  O   ILE    73       1.450  70.986  52.850  1.00 29.32           O  
ATOM   1261  CB  ILE    73      -0.621  71.840  50.468  1.00 30.50           C  
ATOM   1262  CG1 ILE    73      -1.744  72.732  49.891  1.00 27.84           C  
ATOM   1263  CG2 ILE    73      -0.867  70.336  50.174  1.00 25.19           C  
ATOM   1264  CD1 ILE    73      -1.816  72.820  48.371  1.00 30.38           C  
ATOM   1265  N   THR    74      -0.530  70.088  53.420  1.00 27.36           N  
ATOM   1266  CA  THR    74       0.088  69.024  54.242  1.00 27.26           C  
ATOM   1267  C   THR    74       0.356  67.745  53.462  1.00 27.58           C  
ATOM   1268  O   THR    74      -0.238  67.522  52.416  1.00 24.17           O  
ATOM   1269  CB  THR    74      -0.757  68.627  55.460  1.00 29.19           C  
ATOM   1270  OG1 THR    74      -2.004  68.099  55.031  1.00 28.81           O  
ATOM   1271  CG2 THR    74      -0.971  69.880  56.480  1.00 28.98           C  
ATOM   1272  N   LYS    75       1.211  66.876  53.997  1.00 26.69           N  
ATOM   1273  CA  LYS    75       1.408  65.575  53.357  1.00 24.94           C  
ATOM   1274  C   LYS    75       0.105  64.766  53.394  1.00 24.97           C  
ATOM   1275  O   LYS    75      -0.183  64.049  52.430  1.00 24.26           O  
ATOM   1276  CB  LYS    75       2.547  64.787  54.001  1.00 25.92           C  
ATOM   1277  CG  LYS    75       3.941  65.377  53.781  1.00 25.04           C  
ATOM   1278  CD  LYS    75       5.016  64.369  54.207  1.00 27.40           C  
ATOM   1279  CE  LYS    75       6.395  64.744  53.675  1.00 30.74           C  
ATOM   1280  NZ  LYS    75       7.337  63.582  53.770  1.00 29.47           N  
ATOM   1281  N   GLU    76      -0.705  64.923  54.456  1.00 23.62           N  
ATOM   1282  CA  GLU    76      -2.006  64.250  54.537  1.00 27.19           C  
ATOM   1283  C   GLU    76      -2.963  64.703  53.418  1.00 22.94           C  
ATOM   1284  O   GLU    76      -3.670  63.897  52.828  1.00 25.59           O  
ATOM   1285  CB  GLU    76      -2.676  64.495  55.897  1.00 28.02           C  
ATOM   1286  CG  GLU    76      -3.944  63.646  56.101  1.00 35.01           C  
ATOM   1287  CD  GLU    76      -4.602  63.869  57.467  1.00 37.01           C  
ATOM   1288  OE1 GLU    76      -4.541  65.017  57.990  1.00 52.64           O  
ATOM   1289  OE2 GLU    76      -5.167  62.883  58.002  1.00 48.87           O  
ATOM   1290  N   GLU    77      -2.974  65.994  53.116  1.00 24.57           N  
ATOM   1291  CA  GLU    77      -3.774  66.494  52.000  1.00 24.63           C  
ATOM   1292  C   GLU    77      -3.272  65.945  50.656  1.00 24.30           C  
ATOM   1293  O   GLU    77      -4.068  65.546  49.803  1.00 23.45           O  
ATOM   1294  CB  GLU    77      -3.785  68.017  51.965  1.00 25.09           C  
ATOM   1295  CG  GLU    77      -4.555  68.632  53.117  1.00 28.85           C  
ATOM   1296  CD  GLU    77      -4.410  70.153  53.229  1.00 30.84           C  
ATOM   1297  OE1 GLU    77      -3.353  70.735  52.878  1.00 33.27           O  
ATOM   1298  OE2 GLU    77      -5.388  70.777  53.674  1.00 33.37           O  
ATOM   1299  N   ILE    78      -1.955  65.938  50.475  1.00 24.49           N  
ATOM   1300  CA  ILE    78      -1.378  65.340  49.262  1.00 23.04           C  
ATOM   1301  C   ILE    78      -1.725  63.851  49.134  1.00 21.63           C  
ATOM   1302  O   ILE    78      -2.100  63.380  48.059  1.00 21.32           O  
ATOM   1303  CB  ILE    78       0.162  65.600  49.123  1.00 22.33           C  
ATOM   1304  CG1 ILE    78       0.452  67.103  49.059  1.00 25.20           C  
ATOM   1305  CG2 ILE    78       0.697  64.957  47.836  1.00 21.31           C  
ATOM   1306  CD1 ILE    78       1.911  67.437  49.205  1.00 24.12           C  
ATOM   1307  N   ALA    79      -1.679  63.116  50.236  1.00 22.41           N  
ATOM   1308  CA  ALA    79      -2.026  61.718  50.200  1.00 20.30           C  
ATOM   1309  C   ALA    79      -3.467  61.520  49.727  1.00 21.42           C  
ATOM   1310  O   ALA    79      -3.749  60.611  48.966  1.00 20.43           O  
ATOM   1311  CB  ALA    79      -1.797  61.071  51.552  1.00 22.66           C  
ATOM   1312  N   ASP    80      -4.374  62.409  50.130  1.00 20.93           N  
ATOM   1313  CA  ASP    80      -5.762  62.331  49.652  1.00 20.26           C  
ATOM   1314  C   ASP    80      -5.885  62.593  48.155  1.00 22.81           C  
ATOM   1315  O   ASP    80      -6.734  62.009  47.494  1.00 22.27           O  
ATOM   1316  CB  ASP    80      -6.667  63.310  50.395  1.00 20.14           C  
ATOM   1317  CG  ASP    80      -7.045  62.853  51.807  1.00 23.19           C  
ATOM   1318  OD1 ASP    80      -6.928  61.652  52.156  1.00 25.42           O  
ATOM   1319  OD2 ASP    80      -7.525  63.728  52.549  1.00 28.27           O  
ATOM   1320  N   VAL    81      -5.043  63.483  47.619  1.00 21.25           N  
ATOM   1321  CA  VAL    81      -4.939  63.659  46.181  1.00 22.27           C  
ATOM   1322  C   VAL    81      -4.492  62.341  45.520  1.00 20.03           C  
ATOM   1323  O   VAL    81      -5.078  61.898  44.508  1.00 19.50           O  
ATOM   1324  CB  VAL    81      -3.963  64.805  45.817  1.00 20.90           C  
ATOM   1325  CG1 VAL    81      -3.757  64.895  44.302  1.00 22.88           C  
ATOM   1326  CG2 VAL    81      -4.425  66.168  46.443  1.00 20.83           C  
ATOM   1327  N   LEU    82      -3.519  61.673  46.131  1.00 20.16           N  
ATOM   1328  CA  LEU    82      -2.954  60.455  45.560  1.00 19.84           C  
ATOM   1329  C   LEU    82      -3.955  59.291  45.560  1.00 18.54           C  
ATOM   1330  O   LEU    82      -3.913  58.425  44.676  1.00 19.11           O  
ATOM   1331  CB  LEU    82      -1.666  60.090  46.263  1.00 20.98           C  
ATOM   1332  CG  LEU    82      -0.551  61.135  46.146  1.00 20.66           C  
ATOM   1333  CD1 LEU    82       0.766  60.558  46.671  1.00 21.28           C  
ATOM   1334  CD2 LEU    82      -0.392  61.639  44.674  1.00 22.33           C  
ATOM   1335  N   ARG    83      -4.911  59.309  46.495  1.00 20.31           N  
ATOM   1336  CA  ARG    83      -5.991  58.304  46.463  1.00 21.39           C  
ATOM   1337  C   ARG    83      -6.744  58.386  45.139  1.00 20.18           C  
ATOM   1338  O   ARG    83      -7.025  57.394  44.468  1.00 19.30           O  
ATOM   1339  CB  ARG    83      -6.940  58.521  47.643  1.00 22.29           C  
ATOM   1340  CG  ARG    83      -6.321  58.269  48.999  1.00 22.30           C  
ATOM   1341  CD  ARG    83      -7.215  58.747  50.124  1.00 28.97           C  
ATOM   1342  NE  ARG    83      -8.051  57.695  50.628  1.00 33.52           N  
ATOM   1343  CZ  ARG    83      -7.790  56.938  51.696  1.00 23.68           C  
ATOM   1344  NH1 ARG    83      -6.703  57.064  52.438  1.00 32.40           N  
ATOM   1345  NH2 ARG    83      -8.646  56.031  52.018  1.00 24.82           N  
ATOM   1346  N   VAL    84      -7.007  59.612  44.712  1.00 19.60           N  
ATOM   1347  CA  VAL    84      -7.659  59.856  43.423  1.00 20.32           C  
ATOM   1348  C   VAL    84      -6.772  59.472  42.241  1.00 20.03           C  
ATOM   1349  O   VAL    84      -7.255  58.901  41.275  1.00 20.48           O  
ATOM   1350  CB  VAL    84      -8.137  61.322  43.296  1.00 21.39           C  
ATOM   1351  CG1 VAL    84      -8.987  61.511  41.998  1.00 22.27           C  
ATOM   1352  CG2 VAL    84      -8.967  61.726  44.539  1.00 22.62           C  
ATOM   1353  N   VAL    85      -5.467  59.765  42.311  1.00 19.59           N  
ATOM   1354  CA  VAL    85      -4.526  59.262  41.308  1.00 19.33           C  
ATOM   1355  C   VAL    85      -4.607  57.748  41.150  1.00 19.40           C  
ATOM   1356  O   VAL    85      -4.616  57.261  40.035  1.00 20.61           O  
ATOM   1357  CB  VAL    85      -3.073  59.710  41.615  1.00 19.39           C  
ATOM   1358  CG1 VAL    85      -2.070  59.082  40.659  1.00 17.94           C  
ATOM   1359  CG2 VAL    85      -2.997  61.250  41.539  1.00 21.42           C  
ATOM   1360  N   LEU    86      -4.650  56.998  42.252  1.00 19.33           N  
ATOM   1361  CA  LEU    86      -4.777  55.548  42.161  1.00 19.79           C  
ATOM   1362  C   LEU    86      -6.014  55.159  41.363  1.00 18.98           C  
ATOM   1363  O   LEU    86      -5.940  54.357  40.454  1.00 20.03           O  
ATOM   1364  CB  LEU    86      -4.858  54.924  43.555  1.00 21.20           C  
ATOM   1365  CG  LEU    86      -5.184  53.439  43.651  1.00 21.99           C  
ATOM   1366  CD1 LEU    86      -4.133  52.600  42.959  1.00 24.06           C  
ATOM   1367  CD2 LEU    86      -5.310  53.065  45.156  1.00 20.62           C  
ATOM   1368  N   LEU    87      -7.154  55.734  41.711  1.00 20.94           N  
ATOM   1369  CA  LEU    87      -8.412  55.347  41.065  1.00 21.06           C  
ATOM   1370  C   LEU    87      -8.447  55.701  39.591  1.00 21.01           C  
ATOM   1371  O   LEU    87      -8.981  54.948  38.793  1.00 22.38           O  
ATOM   1372  CB  LEU    87      -9.577  56.046  41.769  1.00 23.55           C  
ATOM   1373  CG  LEU    87     -10.992  55.596  41.405  1.00 25.01           C  
ATOM   1374  CD1 LEU    87     -11.291  54.169  41.742  1.00 30.38           C  
ATOM   1375  CD2 LEU    87     -11.944  56.517  42.180  1.00 27.84           C  
ATOM   1376  N   THR    88      -7.906  56.874  39.258  1.00 21.25           N  
ATOM   1377  CA  THR    88      -7.927  57.375  37.879  1.00 21.88           C  
ATOM   1378  C   THR    88      -6.816  56.833  36.983  1.00 22.77           C  
ATOM   1379  O   THR    88      -6.931  56.837  35.762  1.00 23.28           O  
ATOM   1380  CB  THR    88      -7.874  58.903  37.853  1.00 21.84           C  
ATOM   1381  OG1 THR    88      -6.644  59.350  38.431  1.00 22.90           O  
ATOM   1382  CG2 THR    88      -9.066  59.477  38.541  1.00 25.52           C  
ATOM   1383  N   SER    89      -5.735  56.386  37.602  1.00 20.63           N  
ATOM   1384  CA  SER    89      -4.483  56.227  36.896  1.00 21.58           C  
ATOM   1385  C   SER    89      -3.720  54.942  37.169  1.00 21.03           C  
ATOM   1386  O   SER    89      -2.772  54.629  36.425  1.00 23.05           O  
ATOM   1387  CB  SER    89      -3.575  57.459  37.151  1.00 25.09           C  
ATOM   1388  OG  SER    89      -4.281  58.671  36.880  1.00 24.41           O  
ATOM   1389  N   GLY    90      -4.063  54.215  38.234  1.00 21.98           N  
ATOM   1390  CA  GLY    90      -3.467  52.905  38.482  1.00 20.22           C  
ATOM   1391  C   GLY    90      -2.363  52.897  39.536  1.00 20.13           C  
ATOM   1392  O   GLY    90      -1.942  53.955  40.033  1.00 19.52           O  
ATOM   1393  N   MET    91      -1.913  51.694  39.856  1.00 20.97           N  
ATOM   1394  CA  MET    91      -0.890  51.427  40.886  0.40 24.63           C  
ATOM   1396  C   MET    91       0.459  52.100  40.604  1.00 21.70           C  
ATOM   1397  O   MET    91       1.059  52.724  41.502  1.00 23.86           O  
ATOM   1398  CB  MET    91      -0.619  49.917  41.035  0.40 26.41           C  
ATOM   1400  CG  MET    91      -1.632  49.085  41.765  0.40 29.31           C  
ATOM   1402  SD  MET    91      -0.711  47.905  43.072  0.28 35.75          SE  
ATOM   1404  CE  MET    91      -0.457  49.469  44.218  0.40 21.93           C  
ATOM   1406  N   PRO    92       0.980  51.963  39.373  1.00 21.05           N  
ATOM   1407  CA  PRO    92       2.311  52.563  39.147  1.00 19.88           C  
ATOM   1408  C   PRO    92       2.408  54.050  39.498  1.00 21.02           C  
ATOM   1409  O   PRO    92       3.356  54.485  40.177  1.00 20.96           O  
ATOM   1410  CB  PRO    92       2.572  52.299  37.663  1.00 22.51           C  
ATOM   1411  CG  PRO    92       1.788  51.073  37.374  1.00 20.16           C  
ATOM   1412  CD  PRO    92       0.530  51.210  38.184  1.00 21.39           C  
ATOM   1413  N   ALA    93       1.434  54.836  39.065  1.00 19.14           N  
ATOM   1414  CA  ALA    93       1.460  56.257  39.340  1.00 19.96           C  
ATOM   1415  C   ALA    93       1.300  56.530  40.843  1.00 19.93           C  
ATOM   1416  O   ALA    93       1.977  57.400  41.418  1.00 20.12           O  
ATOM   1417  CB  ALA    93       0.324  56.953  38.551  1.00 22.71           C  
ATOM   1418  N   PHE    94       0.374  55.804  41.457  1.00 18.44           N  
ATOM   1419  CA  PHE    94       0.116  55.937  42.882  1.00 18.79           C  
ATOM   1420  C   PHE    94       1.380  55.638  43.705  1.00 20.05           C  
ATOM   1421  O   PHE    94       1.763  56.426  44.594  1.00 19.06           O  
ATOM   1422  CB  PHE    94      -0.966  54.949  43.301  1.00 20.10           C  
ATOM   1423  CG  PHE    94      -1.232  54.947  44.799  1.00 20.32           C  
ATOM   1424  CD1 PHE    94      -1.802  56.035  45.406  1.00 19.60           C  
ATOM   1425  CD2 PHE    94      -0.904  53.846  45.583  1.00 23.76           C  
ATOM   1426  CE1 PHE    94      -2.066  56.050  46.776  1.00 22.96           C  
ATOM   1427  CE2 PHE    94      -1.154  53.856  46.964  1.00 22.72           C  
ATOM   1428  CZ  PHE    94      -1.722  54.954  47.559  1.00 26.09           C  
ATOM   1429  N   THR    95       2.013  54.508  43.431  1.00 20.55           N  
ATOM   1430  CA  THR    95       3.135  54.077  44.284  1.00 20.94           C  
ATOM   1431  C   THR    95       4.339  55.000  44.073  1.00 20.73           C  
ATOM   1432  O   THR    95       5.018  55.353  45.038  1.00 20.28           O  
ATOM   1433  CB  THR    95       3.494  52.592  44.055  1.00 23.86           C  
ATOM   1434  OG1 THR    95       3.863  52.424  42.701  1.00 24.63           O  
ATOM   1435  CG2 THR    95       2.314  51.685  44.356  1.00 21.43           C  
ATOM   1436  N   LYS    96       4.586  55.442  42.833  1.00 20.08           N  
ATOM   1437  CA  LYS    96       5.679  56.370  42.546  0.50 21.50           C  
ATOM   1439  C   LYS    96       5.460  57.655  43.335  1.00 20.81           C  
ATOM   1440  O   LYS    96       6.378  58.161  43.984  1.00 23.01           O  
ATOM   1441  CB  LYS    96       5.748  56.674  41.040  0.50 23.02           C  
ATOM   1443  CG  LYS    96       6.843  57.658  40.621  0.50 23.87           C  
ATOM   1445  CD  LYS    96       7.014  57.722  39.092  0.50 25.49           C  
ATOM   1447  CE  LYS    96       8.452  58.030  38.704  0.50 32.66           C  
ATOM   1449  NZ  LYS    96       9.333  56.844  38.868  0.50 30.31           N  
ATOM   1451  N   ALA    97       4.244  58.190  43.262  1.00 19.16           N  
ATOM   1452  CA  ALA    97       3.898  59.469  43.921  1.00 19.50           C  
ATOM   1453  C   ALA    97       3.968  59.374  45.441  1.00 20.63           C  
ATOM   1454  O   ALA    97       4.463  60.306  46.135  1.00 20.71           O  
ATOM   1455  CB  ALA    97       2.498  59.945  43.472  1.00 19.41           C  
ATOM   1456  N   MET    98       3.499  58.244  45.974  1.00 19.58           N  
ATOM   1457  CA  MET    98       3.518  58.034  47.406  1.00 20.80           C  
ATOM   1458  C   MET    98       4.949  58.016  47.898  1.00 21.43           C  
ATOM   1459  O   MET    98       5.235  58.574  48.952  1.00 21.18           O  
ATOM   1460  CB  MET    98       2.812  56.740  47.834  1.00 22.05           C  
ATOM   1461  CG  MET    98       1.348  56.831  48.010  1.00 30.57           C  
ATOM   1462  SD  MET    98       0.764  58.016  49.491  0.75 32.27          SE  
ATOM   1463  CE  MET    98       1.937  58.044  50.314  1.00  8.65           C  
ATOM   1464  N   LYS    99       5.840  57.362  47.159  1.00 20.17           N  
ATOM   1465  CA  LYS    99       7.263  57.318  47.526  1.00 20.82           C  
ATOM   1466  C   LYS    99       7.928  58.695  47.534  1.00 21.61           C  
ATOM   1467  O   LYS    99       8.729  59.015  48.429  1.00 22.41           O  
ATOM   1468  CB  LYS    99       8.015  56.361  46.599  1.00 19.98           C  
ATOM   1469  CG  LYS    99       9.522  56.268  46.893  1.00 23.11           C  
ATOM   1470  N   ILE   100       7.602  59.501  46.536  1.00 22.47           N  
ATOM   1471  CA  ILE   100       8.072  60.874  46.456  1.00 23.27           C  
ATOM   1472  C   ILE   100       7.553  61.687  47.656  1.00 24.13           C  
ATOM   1473  O   ILE   100       8.325  62.413  48.299  1.00 23.84           O  
ATOM   1474  CB  ILE   100       7.652  61.544  45.136  1.00 22.91           C  
ATOM   1475  CG1 ILE   100       8.324  60.868  43.926  1.00 22.73           C  
ATOM   1476  CG2 ILE   100       7.973  63.043  45.152  1.00 21.99           C  
ATOM   1477  CD1 ILE   100       7.717  61.279  42.573  1.00 25.00           C  
ATOM   1478  N   LEU   101       6.269  61.540  47.970  1.00 21.64           N  
ATOM   1479  CA  LEU   101       5.660  62.247  49.106  1.00 23.29           C  
ATOM   1480  C   LEU   101       6.347  61.878  50.406  1.00 23.75           C  
ATOM   1481  O   LEU   101       6.624  62.756  51.240  1.00 22.26           O  
ATOM   1482  CB  LEU   101       4.155  61.935  49.207  1.00 22.94           C  
ATOM   1483  CG  LEU   101       3.386  62.589  50.364  1.00 23.09           C  
ATOM   1484  CD1 LEU   101       3.489  64.134  50.332  1.00 23.78           C  
ATOM   1485  CD2 LEU   101       1.946  62.145  50.275  1.00 22.66           C  
ATOM   1486  N   GLU   102       6.611  60.583  50.578  1.00 22.09           N  
ATOM   1487  CA  GLU   102       7.262  60.059  51.770  1.00 27.09           C  
ATOM   1488  C   GLU   102       8.642  60.680  51.965  1.00 25.97           C  
ATOM   1489  O   GLU   102       9.018  61.019  53.083  1.00 27.53           O  
ATOM   1490  CB  GLU   102       7.399  58.543  51.675  1.00 27.36           C  
ATOM   1491  CG  GLU   102       6.073  57.805  51.782  1.00 34.71           C  
ATOM   1492  CD  GLU   102       6.120  56.363  51.242  1.00 36.54           C  
ATOM   1493  OE1 GLU   102       7.234  55.820  51.027  1.00 45.78           O  
ATOM   1494  OE2 GLU   102       5.022  55.775  51.058  1.00 44.93           O  
ATOM   1495  N   LYS   103       9.388  60.834  50.880  1.00 25.11           N  
ATOM   1496  CA  LYS   103      10.773  61.333  50.951  1.00 28.56           C  
ATOM   1497  C   LYS   103      10.847  62.862  51.111  1.00 31.51           C  
ATOM   1498  O   LYS   103      11.911  63.419  51.414  1.00 33.51           O  
ATOM   1499  CB  LYS   103      11.571  60.887  49.714  1.00 29.59           C  
ATOM   1500  CG  LYS   103      11.820  59.386  49.621  1.00 32.01           C  
ATOM   1501  N   LEU   104       9.727  63.543  50.933  1.00 31.51           N  
ATOM   1502  CA  LEU   104       9.711  64.997  51.021  1.00 35.23           C  
ATOM   1503  C   LEU   104       9.855  65.493  52.451  1.00 36.78           C  
ATOM   1504  O   LEU   104       9.406  64.849  53.400  1.00 36.92           O  
ATOM   1505  CB  LEU   104       8.441  65.570  50.389  1.00 34.06           C  
ATOM   1506  CG  LEU   104       8.572  65.835  48.898  1.00 34.04           C  
ATOM   1507  CD1 LEU   104       7.311  66.503  48.411  1.00 34.11           C  
ATOM   1508  CD2 LEU   104       9.796  66.702  48.620  1.00 38.61           C  
ATOM   1509  OXT LEU   104      10.441  66.563  52.661  1.00 40.57           O  
END
