
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  101 (  785),  selected  101 , name 1vke_D
# Molecule2: number of CA atoms   98 (  717),  selected   98 , name T0408.pdb
# PARAMETERS: 1vke_D.T0408.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      F       7           -
LGA    -       -      G       8           -
LGA    -       -      E       9           -
LGA    -       -      G      10           -
LGA    -       -      M      11           -
LGA    -       -      K      12           -
LGA    -       -      V      13           -
LGA    -       -      V      14           -
LGA    -       -      K      15           -
LGA    S    19_D      E      16          5.111
LGA    R    20_D      K      17          0.762
LGA    G    21_D      Y      18          2.817
LGA    T    22_D      P      19           #
LGA    L    23_D      D      20          2.456
LGA    N    24_D      L      21          3.262
LGA    T    25_D      Y      22          4.659
LGA    K    26_D      D      23          3.610
LGA    R    27_D      I      24          1.101
LGA    F    28_D      I      25          2.468
LGA    F    29_D      V      26          4.300
LGA    N    30_D      K      27          3.517
LGA    L    31_D      L      28          1.227
LGA    D    32_D      N      29          2.759
LGA    S    33_D      D      30          4.220
LGA    A    34_D      T      31          3.435
LGA    V    35_D      V      32          1.463
LGA    Y    36_D      F      33          2.446
LGA    R    37_D      T      34          3.793
LGA    P    38_D      G      35          4.962
LGA    G    39_D      K      36          4.034
LGA    K    40_D      T      37          1.530
LGA    L    41_D      L      38          0.951
LGA    D    42_D      D      39          1.182
LGA    V    43_D      Y      40          1.518
LGA    K    44_D      K      41          1.236
LGA    T    45_D      T      42          0.607
LGA    K    46_D      Q      43          0.952
LGA    E    47_D      K      44          0.909
LGA    L    48_D      L      45          0.388
LGA    M    49_D      I      46          0.620
LGA    G    50_D      A      47          0.820
LGA    L    51_D      I      48          0.388
LGA    V    52_D      G      49          0.366
LGA    A    53_D      I      50          0.793
LGA    S    54_D      V      51          0.779
LGA    T    55_D      A      52          0.394
LGA    V    56_D      S      53          0.681
LGA    L    57_D      R      54          2.056
LGA    R    58_D      C      55          2.361
LGA    C    59_D      D      56          2.135
LGA    D    60_D      E      57          2.277
LGA    D    61_D      V      58          2.728
LGA    C    62_D      A      59          2.446
LGA    I    63_D      I      60          1.805
LGA    R    64_D      E      61          2.182
LGA    Y    65_D      K      62          2.611
LGA    H    66_D      Q      63          2.285
LGA    L    67_D      M      64          1.425
LGA    V    68_D      K      65          2.439
LGA    R    69_D      S      66          3.436
LGA    C    70_D      A      67          2.895
LGA    V    71_D      M      68          2.061
LGA    Q    72_D      K      69          3.638
LGA    -       -      E      70           -
LGA    E    73_D      L      71          1.969
LGA    G    74_D      G      72          3.139
LGA    A    75_D      I      73          2.758
LGA    S    76_D      T      74          3.261
LGA    D    77_D      K      75          2.975
LGA    E    78_D      E      76          2.646
LGA    E    79_D      E      77          2.025
LGA    I    80_D      I      78          1.481
LGA    F    81_D      A      79          1.052
LGA    E    82_D      D      80          1.149
LGA    A    83_D      V      81          0.702
LGA    L    84_D      L      82          0.882
LGA    D    85_D      R      83          1.022
LGA    I    86_D      V      84          0.515
LGA    A    87_D      V      85          1.201
LGA    L    88_D      L      86          1.944
LGA    V    89_D      L      87          1.799
LGA    V    90_D      T      88          0.931
LGA    G    91_D      S      89          1.536
LGA    G    92_D      G      90          1.599
LGA    S    93_D      M      91          2.027
LGA    I    94_D      P      92          2.662
LGA    V    95_D      A      93          0.914
LGA    I    96_D      F      94          3.824
LGA    P    97_D      T      95          4.893
LGA    H    98_D      K      96          2.712
LGA    L    99_D      A      97          1.104
LGA    R   100_D      M      98          3.255
LGA    R   101_D      K      99          3.382
LGA    A   102_D      I     100          2.464
LGA    V   103_D      L     101          1.713
LGA    G   104_D      E     102          2.171
LGA    -       -      K     103           -
LGA    F   105_D      L     104          1.466
LGA    L   106_D      -       -           -
LGA    E   107_D      -       -           -
LGA    E   108_D      -       -           -
LGA    L   109_D      -       -           -
LGA    R   110_D      -       -           -
LGA    E   111_D      -       -           -
LGA    M   112_D      -       -           -
LGA    E   113_D      -       -           -
LGA    K   114_D      -       -           -
LGA    N   115_D      -       -           -
LGA    G   116_D      -       -           -
LGA    E   117_D      -       -           -
LGA    T   118_D      -       -           -
LGA    I   119_D      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  101   98    5.0     86    2.43    17.44     70.734     3.394

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.098585 * X  +   0.619017 * Y  +   0.779166 * Z  + -17.212490
  Y_new =   0.092030 * X  +   0.785296 * Y  +  -0.612242 * Z  +  73.865158
  Z_new =  -0.990864 * X  +   0.011349 * Y  +  -0.134387 * Z  +  43.537319 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   3.057344   -0.084248  [ DEG:   175.1729     -4.8271 ]
  Theta =   1.435519    1.706074  [ DEG:    82.2492     97.7508 ]
  Phi   =   2.390570   -0.751023  [ DEG:   136.9696    -43.0304 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1vke_D                                        
REMARK     2: T0408.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1vke_D.T0408.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  101   98   5.0   86   2.43   17.44  70.734
REMARK  ---------------------------------------------------------- 
MOLECULE 1vke_D
HEADER    LYASE                                   13-MAY-04   1VKE              
TITLE     CRYSTAL STRUCTURE OF CARBOXYMUCONOLACTONE DECARBOXYLASE               
TITLE    2 FAMILY PROTEIN POSSIBLY INVOLVED IN ANTIOXIDATIVE RESPONSE           
TITLE    3 (TM1620) FROM THERMOTOGA MARITIMA AT 1.56 A RESOLUTION               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CARBOXYMUCONOLACTONE DECARBOXYLASE FAMILY                  
COMPND   3 PROTEIN;                                                             
COMPND   4 CHAIN: A, B, C, D, E, F;                                             
COMPND   5 EC: 4.1.-.-;                                                         
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 OTHER_DETAILS: POSSIBLY INVOLVED IN ANTIOXIDATIVE RESPONSE           
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMOTOGA MARITIMA MSB8;                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: TM1620;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    TM1620, CARBOXYMUCONOLACTONE DECARBOXYLASE FAMILY PROTEIN             
KEYWDS   2 POSSIBLY INVOLVED IN ANTIOXIDATIVE RESPONSE, STRUCTURAL              
KEYWDS   3 GENOMICS, JCSG, PROTEIN STRUCTURE INITIATIVE, PSI, JOINT             
KEYWDS   4 CENTER FOR STRUCTURAL GENOMICS                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   5   28-MAR-06 1VKE    1       JRNL                                     
REVDAT   4   18-JAN-05 1VKE    1       AUTHOR KEYWDS REMARK                     
REVDAT   3   17-AUG-04 1VKE    1       COMPND HEADER KEYWDS                     
REVDAT   2   10-AUG-04 1VKE    1       JRNL   TITLE  COMPND KEYWDS              
REVDAT   1   08-JUN-04 1VKE    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF CARBOXYMUCONOLACTONE                    
JRNL        TITL 2 DECARBOXYLASE FAMILY PROTEIN POSSIBLY INVOLVED IN            
JRNL        TITL 3 ANTIOXIDATIVE RESPONSE (TM1620) FROM THERMOTOGA              
JRNL        TITL 4 MARITIMA AT 1.56 A RESOLUTION                                
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.56 ANGSTROMS.                                          
DBREF  1VKE A    1   121  UNP    Q9X1V5   Q9X1V5_THEMA     1    121             
DBREF  1VKE B    1   121  UNP    Q9X1V5   Q9X1V5_THEMA     1    121             
DBREF  1VKE C    1   121  UNP    Q9X1V5   Q9X1V5_THEMA     1    121             
DBREF  1VKE D    1   121  UNP    Q9X1V5   Q9X1V5_THEMA     1    121             
DBREF  1VKE E    1   121  UNP    Q9X1V5   Q9X1V5_THEMA     1    121             
DBREF  1VKE F    1   121  UNP    Q9X1V5   Q9X1V5_THEMA     1    121             
SEQRES   1 A  133  MET GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS MET          
SEQRES   2 A  133  GLU TYR LYS LYS PHE VAL GLU ALA ARG ARG GLU LEU ASN          
SEQRES   3 A  133  GLU LYS VAL LEU SER ARG GLY THR LEU ASN THR LYS ARG          
SEQRES   4 A  133  PHE PHE ASN LEU ASP SER ALA VAL TYR ARG PRO GLY LYS          
SEQRES   5 A  133  LEU ASP VAL LYS THR LYS GLU LEU MET GLY LEU VAL ALA          
SEQRES   6 A  133  SER THR VAL LEU ARG CYS ASP ASP CYS ILE ARG TYR HIS          
SEQRES   7 A  133  LEU VAL ARG CYS VAL GLN GLU GLY ALA SER ASP GLU GLU          
SEQRES   8 A  133  ILE PHE GLU ALA LEU ASP ILE ALA LEU VAL VAL GLY GLY          
SEQRES   9 A  133  SER ILE VAL ILE PRO HIS LEU ARG ARG ALA VAL GLY PHE          
SEQRES  10 A  133  LEU GLU GLU LEU ARG GLU MET GLU LYS ASN GLY GLU THR          
SEQRES  11 A  133  ILE SER LEU                                                  
SEQRES   1 B  133  MET GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS MET          
SEQRES   2 B  133  GLU TYR LYS LYS PHE VAL GLU ALA ARG ARG GLU LEU ASN          
SEQRES   3 B  133  GLU LYS VAL LEU SER ARG GLY THR LEU ASN THR LYS ARG          
SEQRES   4 B  133  PHE PHE ASN LEU ASP SER ALA VAL TYR ARG PRO GLY LYS          
SEQRES   5 B  133  LEU ASP VAL LYS THR LYS GLU LEU MET GLY LEU VAL ALA          
SEQRES   6 B  133  SER THR VAL LEU ARG CYS ASP ASP CYS ILE ARG TYR HIS          
SEQRES   7 B  133  LEU VAL ARG CYS VAL GLN GLU GLY ALA SER ASP GLU GLU          
SEQRES   8 B  133  ILE PHE GLU ALA LEU ASP ILE ALA LEU VAL VAL GLY GLY          
SEQRES   9 B  133  SER ILE VAL ILE PRO HIS LEU ARG ARG ALA VAL GLY PHE          
SEQRES  10 B  133  LEU GLU GLU LEU ARG GLU MET GLU LYS ASN GLY GLU THR          
SEQRES  11 B  133  ILE SER LEU                                                  
SEQRES   1 C  133  MET GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS MET          
SEQRES   2 C  133  GLU TYR LYS LYS PHE VAL GLU ALA ARG ARG GLU LEU ASN          
SEQRES   3 C  133  GLU LYS VAL LEU SER ARG GLY THR LEU ASN THR LYS ARG          
SEQRES   4 C  133  PHE PHE ASN LEU ASP SER ALA VAL TYR ARG PRO GLY LYS          
SEQRES   5 C  133  LEU ASP VAL LYS THR LYS GLU LEU MET GLY LEU VAL ALA          
SEQRES   6 C  133  SER THR VAL LEU ARG CYS ASP ASP CYS ILE ARG TYR HIS          
SEQRES   7 C  133  LEU VAL ARG CYS VAL GLN GLU GLY ALA SER ASP GLU GLU          
SEQRES   8 C  133  ILE PHE GLU ALA LEU ASP ILE ALA LEU VAL VAL GLY GLY          
SEQRES   9 C  133  SER ILE VAL ILE PRO HIS LEU ARG ARG ALA VAL GLY PHE          
SEQRES  10 C  133  LEU GLU GLU LEU ARG GLU MET GLU LYS ASN GLY GLU THR          
SEQRES  11 C  133  ILE SER LEU                                                  
SEQRES   1 D  133  MET GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS MET          
SEQRES   2 D  133  GLU TYR LYS LYS PHE VAL GLU ALA ARG ARG GLU LEU ASN          
SEQRES   3 D  133  GLU LYS VAL LEU SER ARG GLY THR LEU ASN THR LYS ARG          
SEQRES   4 D  133  PHE PHE ASN LEU ASP SER ALA VAL TYR ARG PRO GLY LYS          
SEQRES   5 D  133  LEU ASP VAL LYS THR LYS GLU LEU MET GLY LEU VAL ALA          
SEQRES   6 D  133  SER THR VAL LEU ARG CYS ASP ASP CYS ILE ARG TYR HIS          
SEQRES   7 D  133  LEU VAL ARG CYS VAL GLN GLU GLY ALA SER ASP GLU GLU          
SEQRES   8 D  133  ILE PHE GLU ALA LEU ASP ILE ALA LEU VAL VAL GLY GLY          
SEQRES   9 D  133  SER ILE VAL ILE PRO HIS LEU ARG ARG ALA VAL GLY PHE          
SEQRES  10 D  133  LEU GLU GLU LEU ARG GLU MET GLU LYS ASN GLY GLU THR          
SEQRES  11 D  133  ILE SER LEU                                                  
SEQRES   1 E  133  MET GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS MET          
SEQRES   2 E  133  GLU TYR LYS LYS PHE VAL GLU ALA ARG ARG GLU LEU ASN          
SEQRES   3 E  133  GLU LYS VAL LEU SER ARG GLY THR LEU ASN THR LYS ARG          
SEQRES   4 E  133  PHE PHE ASN LEU ASP SER ALA VAL TYR ARG PRO GLY LYS          
SEQRES   5 E  133  LEU ASP VAL LYS THR LYS GLU LEU MET GLY LEU VAL ALA          
SEQRES   6 E  133  SER THR VAL LEU ARG CYS ASP ASP CYS ILE ARG TYR HIS          
SEQRES   7 E  133  LEU VAL ARG CYS VAL GLN GLU GLY ALA SER ASP GLU GLU          
SEQRES   8 E  133  ILE PHE GLU ALA LEU ASP ILE ALA LEU VAL VAL GLY GLY          
SEQRES   9 E  133  SER ILE VAL ILE PRO HIS LEU ARG ARG ALA VAL GLY PHE          
SEQRES  10 E  133  LEU GLU GLU LEU ARG GLU MET GLU LYS ASN GLY GLU THR          
SEQRES  11 E  133  ILE SER LEU                                                  
SEQRES   1 F  133  MET GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS MET          
SEQRES   2 F  133  GLU TYR LYS LYS PHE VAL GLU ALA ARG ARG GLU LEU ASN          
SEQRES   3 F  133  GLU LYS VAL LEU SER ARG GLY THR LEU ASN THR LYS ARG          
SEQRES   4 F  133  PHE PHE ASN LEU ASP SER ALA VAL TYR ARG PRO GLY LYS          
SEQRES   5 F  133  LEU ASP VAL LYS THR LYS GLU LEU MET GLY LEU VAL ALA          
SEQRES   6 F  133  SER THR VAL LEU ARG CYS ASP ASP CYS ILE ARG TYR HIS          
SEQRES   7 F  133  LEU VAL ARG CYS VAL GLN GLU GLY ALA SER ASP GLU GLU          
SEQRES   8 F  133  ILE PHE GLU ALA LEU ASP ILE ALA LEU VAL VAL GLY GLY          
SEQRES   9 F  133  SER ILE VAL ILE PRO HIS LEU ARG ARG ALA VAL GLY PHE          
SEQRES  10 F  133  LEU GLU GLU LEU ARG GLU MET GLU LYS ASN GLY GLU THR          
SEQRES  11 F  133  ILE SER LEU                                                  
HET    UNL      2       6                                                       
HET    UNL      3       6                                                       
HET    UNL      4       6                                                       
HET    UNL      5       6                                                       
HET    UNL      6       6                                                       
HET    UNL      7       6                                                       
HET    UNL      8       6                                                       
HET    UNL      9       6                                                       
HET    UNL     10       2                                                       
HET    UNL     11       3                                                       
HET    UNL     12       3                                                       
HET    UNL     13       4                                                       
HET    MPD      1       8                                                       
HETNAM     UNL UNKNOWN LIGAND                                                   
HETNAM     MPD (4S)-2-METHYL-2,4-PENTANEDIOL                                    
FORMUL  19  MPD    C6 H14 O2                                                    
FORMUL  20  HOH   *435(H2 O)                                                    
CRYST1   67.922   67.975   90.077  90.00  97.52  90.00 P 1 21 1     12          
ATOM   2496  N   SER D  19      17.319  86.085  25.513  1.00 30.93           N  
ATOM   2497  CA  SER D  19      18.477  85.108  25.415  1.00 30.99           C  
ATOM   2498  C   SER D  19      18.028  83.630  25.468  1.00 27.68           C  
ATOM   2499  O   SER D  19      18.669  82.745  24.867  1.00 25.70           O  
ATOM   2500  CB  SER D  19      19.517  85.369  26.525  1.00 30.18           C  
ATOM   2501  N   ARG D  20      16.985  83.380  26.255  1.00 26.11           N  
ATOM   2502  CA  ARG D  20      16.355  82.088  26.353  1.00 23.95           C  
ATOM   2503  C   ARG D  20      14.876  82.292  26.019  1.00 23.74           C  
ATOM   2504  O   ARG D  20      14.135  82.989  26.737  1.00 27.73           O  
ATOM   2505  CB  ARG D  20      16.486  81.518  27.755  1.00 22.68           C  
ATOM   2506  CG  ARG D  20      17.916  81.367  28.225  1.00 23.13           C  
ATOM   2507  CD  ARG D  20      18.014  80.836  29.662  1.00 29.16           C  
ATOM   2508  NE  ARG D  20      19.381  80.866  30.180  1.00 33.68           N  
ATOM   2509  CZ  ARG D  20      19.730  80.658  31.456  1.00 40.42           C  
ATOM   2510  NH1 ARG D  20      18.815  80.418  32.396  1.00 42.53           N  
ATOM   2511  NH2 ARG D  20      21.019  80.710  31.798  1.00 41.18           N  
ATOM   2512  N   GLY D  21      14.468  81.701  24.925  1.00 19.95           N  
ATOM   2513  CA  GLY D  21      13.083  81.659  24.534  1.00 17.24           C  
ATOM   2514  C   GLY D  21      12.681  82.900  23.776  1.00 16.42           C  
ATOM   2515  O   GLY D  21      13.509  83.706  23.340  1.00 17.61           O  
ATOM   2516  N   THR D  22      11.375  83.044  23.665  1.00 11.70           N  
ATOM   2517  CA  THR D  22      10.764  84.172  23.014  1.00 12.69           C  
ATOM   2518  C   THR D  22       9.781  84.843  23.936  1.00 13.02           C  
ATOM   2519  O   THR D  22       9.522  84.377  25.036  1.00 12.64           O  
ATOM   2520  CB  THR D  22      10.003  83.707  21.776  1.00 12.04           C  
ATOM   2521  OG1 THR D  22       8.802  83.035  22.190  1.00 14.38           O  
ATOM   2522  CG2 THR D  22      10.811  82.689  20.970  1.00 14.33           C  
ATOM   2523  N   LEU D  23       9.178  85.917  23.446  1.00 12.94           N  
ATOM   2524  CA  LEU D  23       8.086  86.567  24.170  1.00 12.50           C  
ATOM   2525  C   LEU D  23       6.918  85.616  24.418  1.00 13.61           C  
ATOM   2526  O   LEU D  23       6.252  85.671  25.462  1.00 12.70           O  
ATOM   2527  CB  LEU D  23       7.602  87.810  23.433  0.65 14.58           C  
ATOM   2529  CG  LEU D  23       6.672  88.716  24.221  0.65 17.60           C  
ATOM   2531  CD1 LEU D  23       7.156  88.989  25.650  0.65 24.87           C  
ATOM   2533  CD2 LEU D  23       6.520  90.026  23.465  0.65 21.95           C  
ATOM   2535  N   ASN D  24       6.681  84.706  23.476  1.00 11.14           N  
ATOM   2536  CA  ASN D  24       5.638  83.700  23.646  1.00 11.01           C  
ATOM   2537  C   ASN D  24       5.963  82.732  24.786  1.00 10.68           C  
ATOM   2538  O   ASN D  24       5.087  82.371  25.543  1.00 11.62           O  
ATOM   2539  CB  ASN D  24       5.366  82.935  22.330  1.00 11.64           C  
ATOM   2540  CG  ASN D  24       4.739  83.837  21.256  1.00 14.95           C  
ATOM   2541  OD1 ASN D  24       3.949  84.726  21.583  1.00 16.75           O  
ATOM   2542  ND2 ASN D  24       5.131  83.629  19.981  1.00 11.79           N  
ATOM   2543  N   THR D  25       7.230  82.357  24.938  1.00 11.17           N  
ATOM   2544  CA  THR D  25       7.617  81.499  26.017  1.00 11.18           C  
ATOM   2545  C   THR D  25       7.315  82.161  27.337  1.00 10.30           C  
ATOM   2546  O   THR D  25       6.790  81.540  28.262  1.00 11.72           O  
ATOM   2547  CB  THR D  25       9.105  81.156  25.977  1.00 12.22           C  
ATOM   2548  OG1 THR D  25       9.539  81.032  24.629  1.00 11.98           O  
ATOM   2549  CG2 THR D  25       9.333  79.804  26.598  1.00 15.01           C  
ATOM   2550  N   LYS D  26       7.679  83.442  27.433  1.00 10.65           N  
ATOM   2551  CA  LYS D  26       7.483  84.187  28.670  1.00 11.54           C  
ATOM   2552  C   LYS D  26       5.999  84.290  29.010  1.00 11.94           C  
ATOM   2553  O   LYS D  26       5.575  84.079  30.133  1.00 12.60           O  
ATOM   2554  CB  LYS D  26       8.116  85.581  28.534  1.00 14.16           C  
ATOM   2555  CG  LYS D  26       8.030  86.395  29.816  1.00 18.45           C  
ATOM   2556  CD  LYS D  26       8.401  87.851  29.599  1.00 28.24           C  
ATOM   2557  N   ARG D  27       5.188  84.562  28.008  1.00 11.29           N  
ATOM   2558  CA  ARG D  27       3.769  84.684  28.250  1.00 10.57           C  
ATOM   2559  C   ARG D  27       3.172  83.365  28.696  1.00 11.31           C  
ATOM   2560  O   ARG D  27       2.292  83.303  29.556  1.00 12.79           O  
ATOM   2561  CB  ARG D  27       3.075  85.244  26.998  1.00 12.21           C  
ATOM   2562  CG  ARG D  27       3.423  86.705  26.738  1.00 17.80           C  
ATOM   2563  CD  ARG D  27       2.529  87.334  25.708  1.00 33.11           C  
ATOM   2564  NE  ARG D  27       3.244  87.644  24.478  1.00 48.33           N  
ATOM   2565  CZ  ARG D  27       3.250  88.835  23.863  1.00 47.46           C  
ATOM   2566  NH1 ARG D  27       2.572  89.876  24.337  1.00 49.36           N  
ATOM   2567  NH2 ARG D  27       3.945  88.974  22.741  1.00 53.03           N  
ATOM   2568  N   PHE D  28       3.669  82.267  28.142  1.00 10.28           N  
ATOM   2569  CA  PHE D  28       3.169  80.981  28.552  1.00  9.91           C  
ATOM   2570  C   PHE D  28       3.524  80.610  29.991  1.00 10.27           C  
ATOM   2571  O   PHE D  28       2.663  80.136  30.753  1.00 13.53           O  
ATOM   2572  CB  PHE D  28       3.713  79.874  27.648  1.00 12.95           C  
ATOM   2573  CG  PHE D  28       2.914  78.627  27.721  1.00 15.07           C  
ATOM   2574  CD1 PHE D  28       3.190  77.671  28.648  1.00 13.87           C  
ATOM   2575  CD2 PHE D  28       1.831  78.456  26.861  1.00 16.14           C  
ATOM   2576  CE1 PHE D  28       2.371  76.474  28.714  1.00 14.29           C  
ATOM   2577  CE2 PHE D  28       1.017  77.306  26.921  1.00 20.34           C  
ATOM   2578  CZ  PHE D  28       1.325  76.321  27.831  1.00 15.45           C  
ATOM   2579  N   PHE D  29       4.772  80.842  30.382  1.00 11.65           N  
ATOM   2580  CA  PHE D  29       5.161  80.647  31.773  1.00 10.92           C  
ATOM   2581  C   PHE D  29       4.297  81.493  32.722  1.00 12.95           C  
ATOM   2582  O   PHE D  29       3.910  81.042  33.796  1.00 14.01           O  
ATOM   2583  CB  PHE D  29       6.659  80.954  31.972  1.00 11.64           C  
ATOM   2584  CG  PHE D  29       7.594  79.841  31.562  1.00 12.20           C  
ATOM   2585  CD1 PHE D  29       7.511  79.223  30.325  1.00 14.00           C  
ATOM   2586  CD2 PHE D  29       8.592  79.418  32.446  1.00 16.03           C  
ATOM   2587  CE1 PHE D  29       8.383  78.203  29.981  1.00 15.90           C  
ATOM   2588  CE2 PHE D  29       9.484  78.418  32.092  1.00 16.19           C  
ATOM   2589  CZ  PHE D  29       9.397  77.823  30.861  1.00 16.25           C  
ATOM   2590  N   ASN D  30       4.021  82.744  32.349  1.00 12.83           N  
ATOM   2591  CA  ASN D  30       3.168  83.608  33.152  1.00 14.69           C  
ATOM   2592  C   ASN D  30       1.756  83.053  33.321  1.00 15.90           C  
ATOM   2593  O   ASN D  30       1.166  83.152  34.397  1.00 15.90           O  
ATOM   2594  CB  ASN D  30       3.104  85.005  32.543  1.00 16.20           C  
ATOM   2595  CG  ASN D  30       4.390  85.807  32.760  1.00 18.68           C  
ATOM   2596  OD1 ASN D  30       5.229  85.480  33.625  1.00 23.48           O  
ATOM   2597  ND2 ASN D  30       4.541  86.867  31.984  1.00 19.84           N  
ATOM   2598  N   LEU D  31       1.230  82.477  32.243  1.00 14.26           N  
ATOM   2599  CA  LEU D  31      -0.125  81.910  32.247  1.00 14.25           C  
ATOM   2600  C   LEU D  31      -0.139  80.685  33.161  1.00 13.00           C  
ATOM   2601  O   LEU D  31      -1.120  80.460  33.903  1.00 14.13           O  
ATOM   2602  CB  LEU D  31      -0.545  81.558  30.817  1.00 13.97           C  
ATOM   2603  CG  LEU D  31      -1.853  80.860  30.632  1.00 19.20           C  
ATOM   2604  CD1 LEU D  31      -2.962  81.765  31.132  1.00 18.30           C  
ATOM   2605  CD2 LEU D  31      -2.019  80.585  29.164  1.00 18.27           C  
ATOM   2606  N   ASP D  32       0.924  79.890  33.128  1.00 12.93           N  
ATOM   2607  CA  ASP D  32       1.042  78.762  34.043  1.00 13.88           C  
ATOM   2608  C   ASP D  32       0.991  79.209  35.523  1.00 15.82           C  
ATOM   2609  O   ASP D  32       0.333  78.551  36.333  1.00 17.26           O  
ATOM   2610  CB  ASP D  32       2.299  77.976  33.685  1.00 13.95           C  
ATOM   2611  CG  ASP D  32       2.454  76.651  34.464  1.00 19.05           C  
ATOM   2612  OD1 ASP D  32       1.541  75.797  34.549  1.00 19.92           O  
ATOM   2613  OD2 ASP D  32       3.506  76.361  34.967  1.00 20.48           O  
ATOM   2614  N   SER D  33       1.664  80.301  35.888  1.00 13.29           N  
ATOM   2615  CA  SER D  33       1.534  80.833  37.252  1.00 14.46           C  
ATOM   2616  C   SER D  33       0.109  81.312  37.513  1.00 12.28           C  
ATOM   2617  O   SER D  33      -0.453  81.059  38.574  1.00 13.31           O  
ATOM   2618  CB  SER D  33       2.496  81.978  37.491  1.00 16.38           C  
ATOM   2619  OG  SER D  33       3.822  81.508  37.355  1.00 26.50           O  
ATOM   2620  N   ALA D  34      -0.479  82.013  36.534  1.00 14.25           N  
ATOM   2621  CA  ALA D  34      -1.768  82.663  36.716  1.00 14.15           C  
ATOM   2622  C   ALA D  34      -2.919  81.711  36.977  1.00 12.38           C  
ATOM   2623  O   ALA D  34      -3.824  82.023  37.773  1.00 14.28           O  
ATOM   2624  CB  ALA D  34      -2.091  83.492  35.471  1.00 16.22           C  
ATOM   2625  N   VAL D  35      -2.903  80.540  36.352  1.00 13.29           N  
ATOM   2626  CA  VAL D  35      -4.084  79.647  36.463  1.00 14.37           C  
ATOM   2627  C   VAL D  35      -4.186  79.039  37.884  1.00 15.03           C  
ATOM   2628  O   VAL D  35      -5.185  78.468  38.220  1.00 15.18           O  
ATOM   2629  CB  VAL D  35      -4.125  78.511  35.418  1.00 14.45           C  
ATOM   2630  CG1 VAL D  35      -4.345  79.075  34.022  1.00 21.61           C  
ATOM   2631  CG2 VAL D  35      -2.864  77.543  35.540  1.00 14.40           C  
ATOM   2632  N   TYR D  36      -3.118  79.156  38.676  1.00 13.85           N  
ATOM   2633  CA  TYR D  36      -3.114  78.645  40.083  1.00 12.03           C  
ATOM   2634  C   TYR D  36      -3.456  79.742  41.119  1.00 14.85           C  
ATOM   2635  O   TYR D  36      -3.543  79.452  42.333  1.00 15.68           O  
ATOM   2636  CB  TYR D  36      -1.794  77.925  40.422  1.00 13.28           C  
ATOM   2637  CG  TYR D  36      -1.599  76.642  39.655  1.00 12.17           C  
ATOM   2638  CD1 TYR D  36      -2.292  75.469  39.990  1.00 10.73           C  
ATOM   2639  CD2 TYR D  36      -0.757  76.597  38.535  1.00 12.59           C  
ATOM   2640  CE1 TYR D  36      -2.095  74.281  39.267  1.00 14.84           C  
ATOM   2641  CE2 TYR D  36      -0.570  75.436  37.814  1.00 14.80           C  
ATOM   2642  CZ  TYR D  36      -1.236  74.280  38.167  1.00 11.00           C  
ATOM   2643  OH  TYR D  36      -1.075  73.113  37.487  1.00 15.07           O  
ATOM   2644  N   ARG D  37      -3.686  80.986  40.669  1.00 13.71           N  
ATOM   2645  CA  ARG D  37      -4.099  82.025  41.582  1.00 14.63           C  
ATOM   2646  C   ARG D  37      -5.571  81.840  41.944  1.00 13.96           C  
ATOM   2647  O   ARG D  37      -6.355  81.353  41.146  1.00 15.45           O  
ATOM   2648  CB  ARG D  37      -3.857  83.409  40.991  1.00 16.59           C  
ATOM   2649  CG  ARG D  37      -2.410  83.621  40.706  1.00 22.96           C  
ATOM   2650  CD  ARG D  37      -2.015  85.042  40.476  1.00 34.95           C  
ATOM   2651  NE  ARG D  37      -0.555  85.126  40.397  1.00 40.66           N  
ATOM   2652  CZ  ARG D  37       0.156  85.286  39.284  1.00 40.55           C  
ATOM   2653  NH1 ARG D  37      -0.435  85.433  38.100  1.00 37.53           N  
ATOM   2654  NH2 ARG D  37       1.480  85.331  39.366  1.00 43.29           N  
ATOM   2655  N   PRO D  38      -5.921  82.236  43.152  1.00 18.99           N  
ATOM   2656  CA  PRO D  38      -7.248  81.925  43.658  1.00 20.00           C  
ATOM   2657  C   PRO D  38      -8.310  82.716  42.933  1.00 18.45           C  
ATOM   2658  O   PRO D  38      -8.062  83.830  42.449  1.00 16.58           O  
ATOM   2659  CB  PRO D  38      -7.166  82.275  45.134  1.00 21.21           C  
ATOM   2660  CG  PRO D  38      -6.061  83.283  45.249  1.00 20.26           C  
ATOM   2661  CD  PRO D  38      -5.117  83.021  44.114  1.00 19.64           C  
ATOM   2662  N   GLY D  39      -9.471  82.089  42.810  1.00 16.55           N  
ATOM   2663  CA  GLY D  39     -10.663  82.720  42.249  1.00 15.31           C  
ATOM   2664  C   GLY D  39     -11.793  82.196  43.096  1.00 16.02           C  
ATOM   2665  O   GLY D  39     -11.728  82.236  44.342  1.00 15.28           O  
ATOM   2666  N   LYS D  40     -12.821  81.666  42.445  1.00 13.45           N  
ATOM   2667  CA  LYS D  40     -13.852  80.938  43.174  1.00 11.86           C  
ATOM   2668  C   LYS D  40     -13.339  79.681  43.839  1.00 10.57           C  
ATOM   2669  O   LYS D  40     -13.858  79.311  44.908  1.00 14.17           O  
ATOM   2670  CB  LYS D  40     -15.015  80.603  42.253  1.00 14.41           C  
ATOM   2671  CG  LYS D  40     -15.725  81.825  41.746  1.00 17.94           C  
ATOM   2672  CD  LYS D  40     -16.354  82.645  42.896  1.00 20.80           C  
ATOM   2673  CE  LYS D  40     -17.252  83.754  42.380  1.00 29.92           C  
ATOM   2674  NZ  LYS D  40     -16.464  84.723  41.578  1.00 30.49           N  
ATOM   2675  N   LEU D  41     -12.291  79.072  43.268  1.00 11.71           N  
ATOM   2676  CA  LEU D  41     -11.564  78.012  43.934  1.00 13.04           C  
ATOM   2677  C   LEU D  41     -10.402  78.611  44.682  1.00 11.19           C  
ATOM   2678  O   LEU D  41      -9.701  79.477  44.162  1.00 13.50           O  
ATOM   2679  CB  LEU D  41     -11.004  77.012  42.942  1.00 12.83           C  
ATOM   2680  CG  LEU D  41     -12.015  76.232  42.107  1.00 14.16           C  
ATOM   2681  CD1 LEU D  41     -11.237  75.323  41.153  1.00 19.85           C  
ATOM   2682  CD2 LEU D  41     -12.973  75.426  42.997  1.00 13.04           C  
ATOM   2683  N   ASP D  42     -10.210  78.178  45.908  1.00 12.13           N  
ATOM   2684  CA  ASP D  42      -9.103  78.702  46.679  1.00 14.58           C  
ATOM   2685  C   ASP D  42      -7.755  78.137  46.247  1.00 12.15           C  
ATOM   2686  O   ASP D  42      -7.668  77.143  45.493  1.00 13.46           O  
ATOM   2687  CB  ASP D  42      -9.339  78.589  48.200  1.00 16.81           C  
ATOM   2688  CG  ASP D  42      -9.389  77.172  48.726  1.00 24.19           C  
ATOM   2689  OD1 ASP D  42      -8.841  76.217  48.150  1.00 17.14           O  
ATOM   2690  OD2 ASP D  42      -9.939  76.938  49.820  1.00 30.82           O  
ATOM   2691  N   VAL D  43      -6.685  78.796  46.706  1.00 13.58           N  
ATOM   2692  CA  VAL D  43      -5.340  78.422  46.276  1.00 10.06           C  
ATOM   2693  C   VAL D  43      -4.981  76.991  46.696  1.00 12.11           C  
ATOM   2694  O   VAL D  43      -4.309  76.269  45.928  1.00 10.59           O  
ATOM   2695  CB  VAL D  43      -4.249  79.401  46.777  1.00 11.43           C  
ATOM   2696  CG1 VAL D  43      -4.109  79.315  48.301  1.00 18.66           C  
ATOM   2697  CG2 VAL D  43      -2.942  79.166  46.081  1.00 14.60           C  
ATOM   2698  N   LYS D  44      -5.398  76.566  47.894  1.00 13.55           N  
ATOM   2699  CA  LYS D  44      -5.051  75.200  48.343  1.00 14.20           C  
ATOM   2700  C   LYS D  44      -5.658  74.175  47.378  1.00 12.43           C  
ATOM   2701  O   LYS D  44      -5.005  73.200  46.939  1.00 12.76           O  
ATOM   2702  CB  LYS D  44      -5.515  74.942  49.794  1.00 16.61           C  
ATOM   2703  CG  LYS D  44      -5.352  73.507  50.206  1.00 18.66           C  
ATOM   2704  CD  LYS D  44      -5.669  73.238  51.665  1.00 22.03           C  
ATOM   2705  CE  LYS D  44      -7.121  73.365  52.005  1.00 31.68           C  
ATOM   2706  NZ  LYS D  44      -7.271  72.890  53.422  1.00 31.46           N  
ATOM   2707  N   THR D  45      -6.921  74.405  47.004  1.00 10.50           N  
ATOM   2708  CA  THR D  45      -7.612  73.527  46.075  1.00 12.89           C  
ATOM   2709  C   THR D  45      -6.897  73.486  44.713  1.00 10.24           C  
ATOM   2710  O   THR D  45      -6.654  72.429  44.109  1.00 12.68           O  
ATOM   2711  CB  THR D  45      -9.030  74.006  45.882  1.00 14.76           C  
ATOM   2712  OG1 THR D  45      -9.760  73.852  47.116  1.00 17.36           O  
ATOM   2713  CG2 THR D  45      -9.753  73.166  44.879  1.00 14.26           C  
ATOM   2714  N   LYS D  46      -6.564  74.666  44.200  1.00 11.79           N  
ATOM   2715  CA  LYS D  46      -5.864  74.712  42.899  1.00 10.67           C  
ATOM   2716  C   LYS D  46      -4.503  74.051  42.935  1.00  9.55           C  
ATOM   2717  O   LYS D  46      -4.094  73.380  41.980  1.00 11.32           O  
ATOM   2718  CB  LYS D  46      -5.725  76.155  42.383  1.00 12.03           C  
ATOM   2719  CG  LYS D  46      -7.056  76.816  42.055  1.00  8.12           C  
ATOM   2720  CD  LYS D  46      -6.905  78.086  41.234  1.00 14.29           C  
ATOM   2721  CE  LYS D  46      -8.243  78.702  40.940  1.00 12.90           C  
ATOM   2722  NZ  LYS D  46      -8.146  79.822  39.952  1.00  9.90           N  
ATOM   2723  N   GLU D  47      -3.762  74.185  44.044  1.00  9.84           N  
ATOM   2724  CA  GLU D  47      -2.427  73.549  44.122  1.00 11.01           C  
ATOM   2725  C   GLU D  47      -2.573  72.023  44.281  1.00 10.37           C  
ATOM   2726  O   GLU D  47      -1.799  71.243  43.690  1.00 11.45           O  
ATOM   2727  CB  GLU D  47      -1.605  74.170  45.239  1.00 12.25           C  
ATOM   2728  CG  GLU D  47      -1.208  75.603  44.969  1.00 10.88           C  
ATOM   2729  CD  GLU D  47      -0.193  75.797  43.843  1.00 11.84           C  
ATOM   2730  OE1 GLU D  47       0.379  74.818  43.368  1.00 13.62           O  
ATOM   2731  OE2 GLU D  47       0.119  76.970  43.467  1.00 16.83           O  
ATOM   2732  N   LEU D  48      -3.623  71.574  44.980  1.00 12.00           N  
ATOM   2733  CA  LEU D  48      -3.967  70.145  45.018  1.00 11.70           C  
ATOM   2734  C   LEU D  48      -4.324  69.648  43.613  1.00 10.06           C  
ATOM   2735  O   LEU D  48      -3.912  68.546  43.217  1.00 12.30           O  
ATOM   2736  CB  LEU D  48      -5.071  69.880  46.044  1.00 11.57           C  
ATOM   2737  CG  LEU D  48      -4.637  69.937  47.525  1.00 12.97           C  
ATOM   2738  CD1 LEU D  48      -5.880  70.035  48.442  1.00 12.08           C  
ATOM   2739  CD2 LEU D  48      -3.795  68.729  47.948  1.00 13.72           C  
ATOM   2740  N   MET D  49      -5.035  70.463  42.819  1.00 12.11           N  
ATOM   2741  CA  MET D  49      -5.319  70.056  41.427  1.00 11.59           C  
ATOM   2742  C   MET D  49      -4.046  69.975  40.612  1.00 12.96           C  
ATOM   2743  O   MET D  49      -3.857  69.059  39.799  1.00 12.91           O  
ATOM   2744  CB  MET D  49      -6.281  71.028  40.787  1.00 11.80           C  
ATOM   2745  CG  MET D  49      -7.604  70.949  41.387  1.00 14.49           C  
ATOM   2746  SD  MET D  49      -8.686  72.256  40.812  1.00 14.89           S  
ATOM   2747  CE  MET D  49     -10.267  71.573  41.229  1.00 17.53           C  
ATOM   2748  N   GLY D  50      -3.157  70.938  40.797  1.00 10.09           N  
ATOM   2749  CA  GLY D  50      -1.829  70.857  40.139  1.00  9.92           C  
ATOM   2750  C   GLY D  50      -1.059  69.599  40.527  1.00 12.36           C  
ATOM   2751  O   GLY D  50      -0.428  68.939  39.705  1.00 11.13           O  
ATOM   2752  N   LEU D  51      -1.150  69.231  41.807  1.00 11.92           N  
ATOM   2753  CA  LEU D  51      -0.566  67.997  42.277  1.00 12.51           C  
ATOM   2754  C   LEU D  51      -1.150  66.774  41.565  1.00 10.52           C  
ATOM   2755  O   LEU D  51      -0.401  65.868  41.107  1.00 10.88           O  
ATOM   2756  CB  LEU D  51      -0.746  67.840  43.799  1.00 11.70           C  
ATOM   2757  CG  LEU D  51      -0.087  66.604  44.411  1.00 13.38           C  
ATOM   2758  CD1 LEU D  51       1.440  66.506  44.231  1.00 14.49           C  
ATOM   2759  CD2 LEU D  51      -0.429  66.558  45.909  1.00 12.75           C  
ATOM   2760  N   VAL D  52      -2.459  66.718  41.475  1.00 10.82           N  
ATOM   2761  CA  VAL D  52      -3.147  65.586  40.846  1.00 10.64           C  
ATOM   2762  C   VAL D  52      -2.712  65.475  39.364  1.00  9.64           C  
ATOM   2763  O   VAL D  52      -2.367  64.406  38.858  1.00 10.75           O  
ATOM   2764  CB  VAL D  52      -4.693  65.721  40.959  1.00 11.24           C  
ATOM   2765  CG1 VAL D  52      -5.392  64.704  40.046  1.00 12.59           C  
ATOM   2766  CG2 VAL D  52      -5.149  65.534  42.375  1.00 10.39           C  
ATOM   2767  N   ALA D  53      -2.733  66.601  38.664  1.00 10.23           N  
ATOM   2768  CA  ALA D  53      -2.391  66.604  37.237  1.00 11.52           C  
ATOM   2769  C   ALA D  53      -0.928  66.194  37.026  1.00 12.02           C  
ATOM   2770  O   ALA D  53      -0.603  65.389  36.138  1.00 13.06           O  
ATOM   2771  CB  ALA D  53      -2.685  67.978  36.602  1.00 11.88           C  
ATOM   2772  N   SER D  54      -0.051  66.711  37.882  1.00 10.16           N  
ATOM   2773  CA  SER D  54       1.385  66.417  37.805  1.00 12.15           C  
ATOM   2774  C   SER D  54       1.671  64.958  38.081  1.00 12.89           C  
ATOM   2775  O   SER D  54       2.592  64.383  37.499  1.00 10.61           O  
ATOM   2776  CB  SER D  54       2.142  67.274  38.814  1.00 14.62           C  
ATOM   2777  OG  SER D  54       2.063  68.635  38.461  1.00 14.58           O  
ATOM   2778  N   THR D  55       0.893  64.332  38.974  1.00 11.06           N  
ATOM   2779  CA  THR D  55       1.063  62.927  39.315  1.00 11.96           C  
ATOM   2780  C   THR D  55       0.552  61.994  38.234  1.00  9.53           C  
ATOM   2781  O   THR D  55       1.268  61.114  37.775  1.00 11.02           O  
ATOM   2782  CB  THR D  55       0.399  62.656  40.676  1.00 11.32           C  
ATOM   2783  OG1 THR D  55       0.963  63.509  41.669  1.00 11.40           O  
ATOM   2784  CG2 THR D  55       0.686  61.232  41.127  1.00 15.48           C  
ATOM   2785  N   VAL D  56      -0.667  62.221  37.720  1.00 10.02           N  
ATOM   2786  CA  VAL D  56      -1.168  61.339  36.639  1.00  8.81           C  
ATOM   2787  C   VAL D  56      -0.330  61.433  35.355  1.00  9.60           C  
ATOM   2788  O   VAL D  56      -0.249  60.499  34.589  1.00 10.68           O  
ATOM   2789  CB  VAL D  56      -2.715  61.540  36.270  1.00 11.59           C  
ATOM   2790  CG1 VAL D  56      -3.614  61.265  37.452  1.00 13.99           C  
ATOM   2791  CG2 VAL D  56      -3.019  62.865  35.647  1.00 10.47           C  
ATOM   2792  N   LEU D  57       0.280  62.606  35.120  1.00  9.70           N  
ATOM   2793  CA  LEU D  57       1.178  62.847  33.987  1.00  9.47           C  
ATOM   2794  C   LEU D  57       2.633  62.499  34.297  1.00 10.72           C  
ATOM   2795  O   LEU D  57       3.463  62.567  33.399  1.00 11.66           O  
ATOM   2796  CB  LEU D  57       1.055  64.278  33.481  1.00 11.43           C  
ATOM   2797  CG  LEU D  57      -0.291  64.656  32.857  1.00 14.98           C  
ATOM   2798  CD1 LEU D  57      -0.361  66.147  32.604  1.00 16.84           C  
ATOM   2799  CD2 LEU D  57      -0.618  63.865  31.615  1.00 18.74           C  
ATOM   2800  N   ARG D  58       2.911  62.116  35.524  1.00 10.47           N  
ATOM   2801  CA  ARG D  58       4.202  61.537  35.893  1.00  8.40           C  
ATOM   2802  C   ARG D  58       5.377  62.478  35.618  1.00 10.30           C  
ATOM   2803  O   ARG D  58       6.388  62.076  35.020  1.00 12.46           O  
ATOM   2804  CB  ARG D  58       4.372  60.169  35.266  1.00  8.80           C  
ATOM   2805  CG  ARG D  58       3.419  59.181  35.797  1.00 10.49           C  
ATOM   2806  CD  ARG D  58       3.778  57.790  35.359  1.00 19.82           C  
ATOM   2807  NE  ARG D  58       3.407  57.612  33.992  1.00 16.27           N  
ATOM   2808  CZ  ARG D  58       4.150  56.974  33.006  1.00 11.24           C  
ATOM   2809  NH1 ARG D  58       5.398  56.487  33.140  1.00 14.78           N  
ATOM   2810  NH2 ARG D  58       3.573  56.891  31.828  1.00 15.71           N  
ATOM   2811  N   CYS D  59       5.272  63.696  36.159  1.00 12.07           N  
ATOM   2812  CA  CYS D  59       6.342  64.702  36.090  1.00 11.75           C  
ATOM   2813  C   CYS D  59       6.863  64.980  37.497  1.00 11.95           C  
ATOM   2814  O   CYS D  59       6.217  65.628  38.308  1.00 10.93           O  
ATOM   2815  CB  CYS D  59       5.808  65.998  35.468  1.00 14.79           C  
ATOM   2816  SG  CYS D  59       6.985  67.373  35.572  1.00 16.03           S  
ATOM   2817  N   ASP D  60       8.024  64.449  37.827  1.00 11.04           N  
ATOM   2818  CA  ASP D  60       8.544  64.582  39.178  1.00 11.28           C  
ATOM   2819  C   ASP D  60       8.812  66.010  39.614  1.00 11.97           C  
ATOM   2820  O   ASP D  60       8.532  66.355  40.749  1.00 13.34           O  
ATOM   2821  CB  ASP D  60       9.816  63.739  39.373  1.00 13.01           C  
ATOM   2822  CG  ASP D  60       9.514  62.267  39.542  1.00 24.78           C  
ATOM   2823  OD1 ASP D  60       8.447  61.917  40.114  1.00 30.25           O  
ATOM   2824  OD2 ASP D  60      10.289  61.404  39.106  1.00 25.63           O  
ATOM   2825  N   ASP D  61       9.402  66.833  38.750  1.00 12.11           N  
ATOM   2826  CA  ASP D  61       9.674  68.221  39.154  1.00 11.82           C  
ATOM   2827  C   ASP D  61       8.380  68.980  39.428  1.00 11.99           C  
ATOM   2828  O   ASP D  61       8.279  69.810  40.358  1.00 12.93           O  
ATOM   2829  CB  ASP D  61      10.470  68.948  38.093  1.00 14.01           C  
ATOM   2830  CG  ASP D  61      11.945  68.619  38.107  1.00 23.57           C  
ATOM   2831  OD1 ASP D  61      12.433  67.848  38.969  1.00 23.34           O  
ATOM   2832  OD2 ASP D  61      12.709  69.129  37.268  1.00 30.95           O  
ATOM   2833  N   CYS D  62       7.357  68.656  38.640  1.00 14.06           N  
ATOM   2834  CA  CYS D  62       6.048  69.298  38.783  1.00 11.48           C  
ATOM   2835  C   CYS D  62       5.382  68.849  40.095  1.00 12.72           C  
ATOM   2836  O   CYS D  62       4.770  69.647  40.826  1.00 12.11           O  
ATOM   2837  CB  CYS D  62       5.129  68.918  37.624  1.00 13.73           C  
ATOM   2838  SG  CYS D  62       5.825  69.124  35.975  1.00 18.42           S  
ATOM   2839  N   ILE D  63       5.465  67.559  40.377  1.00 11.63           N  
ATOM   2840  CA  ILE D  63       4.942  67.017  41.631  1.00 12.28           C  
ATOM   2841  C   ILE D  63       5.604  67.709  42.804  1.00 12.77           C  
ATOM   2842  O   ILE D  63       4.924  68.159  43.714  1.00 13.17           O  
ATOM   2843  CB  ILE D  63       5.134  65.489  41.689  1.00 13.15           C  
ATOM   2844  CG1 ILE D  63       4.246  64.776  40.683  1.00 11.55           C  
ATOM   2845  CG2 ILE D  63       4.895  64.973  43.094  1.00 15.17           C  
ATOM   2846  CD1 ILE D  63       4.652  63.336  40.417  1.00 15.01           C  
ATOM   2847  N   ARG D  64       6.932  67.789  42.795  1.00 11.14           N  
ATOM   2848  CA  ARG D  64       7.675  68.425  43.906  1.00 13.94           C  
ATOM   2849  C   ARG D  64       7.286  69.875  44.098  1.00 12.35           C  
ATOM   2850  O   ARG D  64       7.078  70.330  45.226  1.00 12.48           O  
ATOM   2851  CB  ARG D  64       9.149  68.350  43.639  1.00 14.82           C  
ATOM   2852  CG  ARG D  64       9.681  66.930  43.769  1.00 22.33           C  
ATOM   2853  CD  ARG D  64      11.088  66.782  43.221  1.00 35.81           C  
ATOM   2854  NE  ARG D  64      12.029  67.494  44.062  1.00 36.75           N  
ATOM   2855  CZ  ARG D  64      12.575  66.995  45.172  1.00 44.27           C  
ATOM   2856  NH1 ARG D  64      12.266  65.772  45.596  1.00 47.06           N  
ATOM   2857  NH2 ARG D  64      13.433  67.729  45.868  1.00 44.21           N  
ATOM   2858  N   TYR D  65       7.154  70.609  42.982  1.00 11.03           N  
ATOM   2859  CA  TYR D  65       6.723  72.026  43.050  1.00 10.56           C  
ATOM   2860  C   TYR D  65       5.336  72.150  43.725  1.00 10.15           C  
ATOM   2861  O   TYR D  65       5.124  72.933  44.688  1.00 11.54           O  
ATOM   2862  CB  TYR D  65       6.672  72.625  41.625  1.00 13.87           C  
ATOM   2863  CG  TYR D  65       6.069  74.019  41.644  1.00 12.53           C  
ATOM   2864  CD1 TYR D  65       6.830  75.117  41.981  1.00 19.86           C  
ATOM   2865  CD2 TYR D  65       4.714  74.224  41.365  1.00 14.96           C  
ATOM   2866  CE1 TYR D  65       6.240  76.406  42.059  1.00 16.12           C  
ATOM   2867  CE2 TYR D  65       4.142  75.487  41.446  1.00 16.85           C  
ATOM   2868  CZ  TYR D  65       4.901  76.560  41.779  1.00 20.10           C  
ATOM   2869  OH  TYR D  65       4.363  77.824  41.870  1.00 20.74           O  
ATOM   2870  N   HIS D  66       4.362  71.393  43.218  1.00 11.28           N  
ATOM   2871  CA  HIS D  66       3.008  71.503  43.779  1.00 12.01           C  
ATOM   2872  C   HIS D  66       2.924  70.928  45.206  1.00 13.62           C  
ATOM   2873  O   HIS D  66       2.169  71.468  46.004  1.00 12.48           O  
ATOM   2874  CB  HIS D  66       1.945  70.921  42.861  1.00 12.75           C  
ATOM   2875  CG  HIS D  66       1.761  71.731  41.624  1.00 14.06           C  
ATOM   2876  ND1 HIS D  66       1.226  73.006  41.630  1.00 14.93           N  
ATOM   2877  CD2 HIS D  66       2.064  71.453  40.333  1.00 16.23           C  
ATOM   2878  CE1 HIS D  66       1.212  73.474  40.396  1.00 18.03           C  
ATOM   2879  NE2 HIS D  66       1.737  72.558  39.592  1.00 15.89           N  
ATOM   2880  N   LEU D  67       3.732  69.931  45.568  1.00 12.55           N  
ATOM   2881  CA  LEU D  67       3.749  69.490  46.968  1.00 14.29           C  
ATOM   2882  C   LEU D  67       4.187  70.619  47.879  1.00 14.68           C  
ATOM   2883  O   LEU D  67       3.575  70.852  48.937  1.00 14.83           O  
ATOM   2884  CB  LEU D  67       4.673  68.303  47.218  1.00 17.00           C  
ATOM   2885  CG  LEU D  67       4.083  66.920  47.114  1.00 23.59           C  
ATOM   2886  CD1 LEU D  67       5.207  65.871  47.302  1.00 24.53           C  
ATOM   2887  CD2 LEU D  67       2.970  66.692  48.103  1.00 19.61           C  
ATOM   2888  N   VAL D  68       5.298  71.277  47.529  1.00 10.69           N  
ATOM   2889  CA  VAL D  68       5.763  72.428  48.289  1.00 10.41           C  
ATOM   2890  C   VAL D  68       4.622  73.445  48.442  1.00 10.68           C  
ATOM   2891  O   VAL D  68       4.343  73.910  49.558  1.00 12.00           O  
ATOM   2892  CB  VAL D  68       6.979  73.120  47.647  1.00 11.99           C  
ATOM   2893  CG1 VAL D  68       7.302  74.434  48.328  1.00 15.79           C  
ATOM   2894  CG2 VAL D  68       8.190  72.235  47.761  1.00 13.42           C  
ATOM   2895  N   ARG D  69       3.981  73.818  47.321  1.00 12.54           N  
ATOM   2896  CA  ARG D  69       2.887  74.787  47.373  1.00 11.76           C  
ATOM   2897  C   ARG D  69       1.734  74.330  48.255  1.00 10.47           C  
ATOM   2898  O   ARG D  69       1.187  75.123  49.036  1.00 11.36           O  
ATOM   2899  CB  ARG D  69       2.364  75.068  45.985  1.00  9.57           C  
ATOM   2900  CG  ARG D  69       3.380  75.739  45.075  1.00 10.52           C  
ATOM   2901  CD  ARG D  69       3.632  77.224  45.407  1.00 14.14           C  
ATOM   2902  NE  ARG D  69       2.377  77.964  45.427  1.00 15.60           N  
ATOM   2903  CZ  ARG D  69       1.815  78.597  46.474  1.00 15.36           C  
ATOM   2904  NH1 ARG D  69       2.371  78.613  47.680  1.00 14.53           N  
ATOM   2905  NH2 ARG D  69       0.644  79.197  46.300  1.00 22.12           N  
ATOM   2906  N   CYS D  70       1.407  73.035  48.182  1.00 10.07           N  
ATOM   2907  CA  CYS D  70       0.315  72.501  49.006  1.00 11.33           C  
ATOM   2908  C   CYS D  70       0.630  72.675  50.486  1.00 10.28           C  
ATOM   2909  O   CYS D  70      -0.213  73.078  51.257  1.00 11.11           O  
ATOM   2910  CB  CYS D  70       0.039  71.025  48.672  1.00 11.60           C  
ATOM   2911  SG  CYS D  70      -0.872  70.790  47.116  1.00 13.48           S  
ATOM   2912  N   VAL D  71       1.856  72.354  50.864  1.00  9.26           N  
ATOM   2913  CA  VAL D  71       2.295  72.475  52.254  1.00 11.11           C  
ATOM   2914  C   VAL D  71       2.275  73.938  52.661  1.00 11.11           C  
ATOM   2915  O   VAL D  71       1.758  74.299  53.742  1.00 11.81           O  
ATOM   2916  CB  VAL D  71       3.671  71.837  52.461  1.00 12.71           C  
ATOM   2917  CG1 VAL D  71       4.236  72.204  53.816  1.00 14.80           C  
ATOM   2918  CG2 VAL D  71       3.563  70.275  52.341  1.00 13.46           C  
ATOM   2919  N   GLN D  72       2.837  74.795  51.814  1.00  8.36           N  
ATOM   2920  CA  GLN D  72       2.824  76.257  52.072  1.00  9.83           C  
ATOM   2921  C   GLN D  72       1.429  76.845  52.302  1.00  9.98           C  
ATOM   2922  O   GLN D  72       1.265  77.697  53.175  1.00 10.88           O  
ATOM   2923  CB  GLN D  72       3.515  77.028  50.954  1.00  9.24           C  
ATOM   2924  CG  GLN D  72       5.020  76.811  50.880  1.00 12.53           C  
ATOM   2925  CD  GLN D  72       5.632  77.538  49.663  1.00  9.77           C  
ATOM   2926  OE1 GLN D  72       4.984  77.686  48.623  1.00 13.17           O  
ATOM   2927  NE2 GLN D  72       6.835  78.049  49.833  1.00 16.25           N  
ATOM   2928  N   GLU D  73       0.458  76.365  51.530  1.00 10.49           N  
ATOM   2929  CA  GLU D  73      -0.932  76.805  51.643  1.00 12.61           C  
ATOM   2930  C   GLU D  73      -1.765  76.052  52.700  1.00 13.60           C  
ATOM   2931  O   GLU D  73      -2.978  76.242  52.788  1.00 15.30           O  
ATOM   2932  CB  GLU D  73      -1.608  76.726  50.266  1.00 13.63           C  
ATOM   2933  CG  GLU D  73      -0.970  77.609  49.198  1.00 13.94           C  
ATOM   2934  CD  GLU D  73      -1.039  79.114  49.502  1.00 11.78           C  
ATOM   2935  OE1 GLU D  73      -1.721  79.547  50.469  1.00 11.66           O  
ATOM   2936  OE2 GLU D  73      -0.406  79.851  48.730  1.00 15.23           O  
ATOM   2937  N   GLY D  74      -1.090  75.272  53.550  1.00 12.58           N  
ATOM   2938  CA  GLY D  74      -1.728  74.650  54.717  1.00 11.70           C  
ATOM   2939  C   GLY D  74      -2.522  73.385  54.501  1.00 12.96           C  
ATOM   2940  O   GLY D  74      -3.310  72.995  55.371  1.00 14.07           O  
ATOM   2941  N   ALA D  75      -2.291  72.693  53.377  1.00  9.83           N  
ATOM   2942  CA  ALA D  75      -2.873  71.381  53.181  1.00 10.72           C  
ATOM   2943  C   ALA D  75      -2.343  70.412  54.225  1.00 12.49           C  
ATOM   2944  O   ALA D  75      -1.164  70.437  54.538  1.00 13.48           O  
ATOM   2945  CB  ALA D  75      -2.553  70.857  51.803  1.00 12.61           C  
ATOM   2946  N   SER D  76      -3.213  69.530  54.712  1.00 12.63           N  
ATOM   2947  CA  SER D  76      -2.809  68.471  55.634  1.00 10.13           C  
ATOM   2948  C   SER D  76      -2.290  67.281  54.829  1.00  9.38           C  
ATOM   2949  O   SER D  76      -2.581  67.125  53.645  1.00 10.53           O  
ATOM   2950  CB  SER D  76      -4.004  68.050  56.468  1.00 12.51           C  
ATOM   2951  OG  SER D  76      -4.996  67.398  55.676  1.00 10.66           O  
ATOM   2952  N   ASP D  77      -1.554  66.400  55.511  1.00 10.57           N  
ATOM   2953  CA  ASP D  77      -1.111  65.176  54.889  1.00  9.20           C  
ATOM   2954  C   ASP D  77      -2.300  64.379  54.385  1.00 11.10           C  
ATOM   2955  O   ASP D  77      -2.237  63.818  53.318  1.00 10.54           O  
ATOM   2956  CB  ASP D  77      -0.372  64.296  55.860  1.00  7.93           C  
ATOM   2957  CG  ASP D  77       1.023  64.756  56.141  1.00 16.76           C  
ATOM   2958  OD1 ASP D  77       1.471  65.759  55.549  1.00 15.74           O  
ATOM   2959  OD2 ASP D  77       1.745  64.122  56.968  1.00 17.10           O  
ATOM   2960  N   GLU D  78      -3.386  64.360  55.156  1.00 11.21           N  
ATOM   2961  CA  GLU D  78      -4.568  63.609  54.709  1.00 10.60           C  
ATOM   2962  C   GLU D  78      -5.201  64.184  53.431  1.00 10.46           C  
ATOM   2963  O   GLU D  78      -5.593  63.453  52.552  1.00 11.01           O  
ATOM   2964  CB  GLU D  78      -5.626  63.548  55.804  1.00 11.78           C  
ATOM   2965  CG  GLU D  78      -6.915  62.818  55.408  1.00 10.90           C  
ATOM   2966  CD  GLU D  78      -6.737  61.352  55.091  1.00 15.91           C  
ATOM   2967  OE1 GLU D  78      -5.764  60.730  55.564  1.00 15.26           O  
ATOM   2968  OE2 GLU D  78      -7.621  60.799  54.385  1.00 14.98           O  
ATOM   2969  N   GLU D  79      -5.283  65.497  53.346  1.00  8.47           N  
ATOM   2970  CA  GLU D  79      -5.764  66.128  52.090  1.00 10.70           C  
ATOM   2971  C   GLU D  79      -4.862  65.728  50.939  1.00 11.09           C  
ATOM   2972  O   GLU D  79      -5.337  65.349  49.872  1.00 10.25           O  
ATOM   2973  CB  GLU D  79      -5.800  67.626  52.281  1.00  8.89           C  
ATOM   2974  CG  GLU D  79      -7.005  68.100  53.094  1.00 10.79           C  
ATOM   2975  CD  GLU D  79      -6.947  69.605  53.387  1.00 17.71           C  
ATOM   2976  OE1 GLU D  79      -5.858  70.138  53.696  1.00 12.45           O  
ATOM   2977  OE2 GLU D  79      -8.002  70.271  53.315  1.00 16.72           O  
ATOM   2978  N   ILE D  80      -3.547  65.772  51.149  1.00 11.07           N  
ATOM   2979  CA  ILE D  80      -2.608  65.412  50.082  1.00 12.00           C  
ATOM   2980  C   ILE D  80      -2.761  63.931  49.701  1.00 12.13           C  
ATOM   2981  O   ILE D  80      -2.773  63.553  48.518  1.00 12.07           O  
ATOM   2982  CB  ILE D  80      -1.183  65.763  50.534  1.00  9.97           C  
ATOM   2983  CG1 ILE D  80      -1.009  67.277  50.595  1.00 13.12           C  
ATOM   2984  CG2 ILE D  80      -0.134  65.162  49.613  1.00 13.19           C  
ATOM   2985  CD1 ILE D  80       0.193  67.771  51.405  1.00 13.96           C  
ATOM   2986  N   PHE D  81      -2.869  63.070  50.716  1.00  9.44           N  
ATOM   2987  CA  PHE D  81      -3.050  61.644  50.433  1.00  9.81           C  
ATOM   2988  C   PHE D  81      -4.329  61.331  49.632  1.00 10.65           C  
ATOM   2989  O   PHE D  81      -4.342  60.474  48.743  1.00 11.30           O  
ATOM   2990  CB  PHE D  81      -3.059  60.767  51.691  1.00 11.94           C  
ATOM   2991  CG  PHE D  81      -1.781  60.824  52.508  1.00 12.11           C  
ATOM   2992  CD1 PHE D  81      -0.553  61.007  51.902  1.00 12.93           C  
ATOM   2993  CD2 PHE D  81      -1.804  60.621  53.897  1.00 12.65           C  
ATOM   2994  CE1 PHE D  81       0.611  61.031  52.638  1.00 18.59           C  
ATOM   2995  CE2 PHE D  81      -0.621  60.652  54.639  1.00 16.11           C  
ATOM   2996  CZ  PHE D  81       0.573  60.860  54.008  1.00 16.75           C  
ATOM   2997  N   GLU D  82      -5.425  61.983  50.002  1.00 11.70           N  
ATOM   2998  CA  GLU D  82      -6.690  61.736  49.331  1.00 11.71           C  
ATOM   2999  C   GLU D  82      -6.592  62.198  47.885  1.00 11.78           C  
ATOM   3000  O   GLU D  82      -7.158  61.573  46.978  1.00 13.03           O  
ATOM   3001  CB  GLU D  82      -7.830  62.430  50.049  1.00 13.26           C  
ATOM   3002  CG  GLU D  82      -8.163  61.783  51.393  1.00 13.59           C  
ATOM   3003  CD  GLU D  82      -9.280  62.463  52.172  1.00 14.65           C  
ATOM   3004  OE1 GLU D  82     -10.124  63.157  51.559  1.00 15.96           O  
ATOM   3005  OE2 GLU D  82      -9.305  62.342  53.429  1.00 13.44           O  
ATOM   3006  N   ALA D  83      -5.888  63.305  47.656  1.00 10.81           N  
ATOM   3007  CA  ALA D  83      -5.630  63.747  46.267  1.00 11.54           C  
ATOM   3008  C   ALA D  83      -4.782  62.771  45.479  1.00 12.87           C  
ATOM   3009  O   ALA D  83      -5.106  62.436  44.338  1.00 13.48           O  
ATOM   3010  CB  ALA D  83      -5.005  65.137  46.231  1.00 14.73           C  
ATOM   3011  N   LEU D  84      -3.702  62.315  46.100  1.00 12.42           N  
ATOM   3012  CA  LEU D  84      -2.805  61.321  45.492  1.00 11.80           C  
ATOM   3013  C   LEU D  84      -3.555  60.032  45.177  1.00 12.00           C  
ATOM   3014  O   LEU D  84      -3.274  59.436  44.123  1.00 13.83           O  
ATOM   3015  CB  LEU D  84      -1.545  61.049  46.350  1.00 12.33           C  
ATOM   3016  CG  LEU D  84      -0.569  62.243  46.415  1.00 12.53           C  
ATOM   3017  CD1 LEU D  84       0.544  61.940  47.434  1.00 16.67           C  
ATOM   3018  CD2 LEU D  84       0.024  62.537  45.029  1.00 17.35           C  
ATOM   3019  N   ASP D  85      -4.494  59.589  46.021  1.00 12.12           N  
ATOM   3020  CA  ASP D  85      -5.282  58.396  45.734  1.00 11.36           C  
ATOM   3021  C   ASP D  85      -6.101  58.524  44.446  1.00 13.46           C  
ATOM   3022  O   ASP D  85      -6.299  57.560  43.698  1.00 12.65           O  
ATOM   3023  CB  ASP D  85      -6.259  58.076  46.862  1.00 11.15           C  
ATOM   3024  CG  ASP D  85      -5.605  57.379  48.044  1.00 13.46           C  
ATOM   3025  OD1 ASP D  85      -4.458  56.876  47.894  1.00 17.61           O  
ATOM   3026  OD2 ASP D  85      -6.188  57.290  49.147  1.00 15.84           O  
ATOM   3027  N   ILE D  86      -6.633  59.704  44.209  1.00 11.71           N  
ATOM   3028  CA  ILE D  86      -7.422  59.954  42.977  1.00 12.37           C  
ATOM   3029  C   ILE D  86      -6.486  59.845  41.795  1.00 12.59           C  
ATOM   3030  O   ILE D  86      -6.776  59.181  40.791  1.00 13.65           O  
ATOM   3031  CB  ILE D  86      -8.155  61.333  43.033  1.00 13.26           C  
ATOM   3032  CG1 ILE D  86      -9.294  61.277  44.043  1.00 14.36           C  
ATOM   3033  CG2 ILE D  86      -8.616  61.763  41.609  1.00 15.45           C  
ATOM   3034  CD1 ILE D  86      -9.833  62.674  44.430  1.00 13.81           C  
ATOM   3035  N   ALA D  87      -5.302  60.476  41.900  1.00 11.36           N  
ATOM   3036  CA  ALA D  87      -4.309  60.337  40.818  1.00 12.25           C  
ATOM   3037  C   ALA D  87      -3.883  58.881  40.561  1.00 13.39           C  
ATOM   3038  O   ALA D  87      -3.706  58.454  39.425  1.00 12.73           O  
ATOM   3039  CB  ALA D  87      -3.057  61.181  41.123  1.00 12.30           C  
ATOM   3040  N   LEU D  88      -3.726  58.125  41.639  1.00 10.46           N  
ATOM   3041  CA  LEU D  88      -3.334  56.699  41.550  1.00 12.62           C  
ATOM   3042  C   LEU D  88      -4.358  55.878  40.804  1.00 13.83           C  
ATOM   3043  O   LEU D  88      -3.998  55.090  39.924  1.00 14.86           O  
ATOM   3044  CB  LEU D  88      -3.096  56.138  42.979  1.00 13.20           C  
ATOM   3045  CG  LEU D  88      -2.695  54.668  43.113  1.00 14.47           C  
ATOM   3046  CD1 LEU D  88      -1.390  54.358  42.372  1.00 16.20           C  
ATOM   3047  CD2 LEU D  88      -2.583  54.365  44.598  1.00 14.05           C  
ATOM   3048  N   VAL D  89      -5.636  56.049  41.142  1.00 14.13           N  
ATOM   3049  CA  VAL D  89      -6.714  55.294  40.475  1.00 15.25           C  
ATOM   3050  C   VAL D  89      -6.941  55.731  39.028  1.00 16.22           C  
ATOM   3051  O   VAL D  89      -7.104  54.890  38.151  1.00 16.64           O  
ATOM   3052  CB  VAL D  89      -8.007  55.353  41.327  1.00 17.46           C  
ATOM   3053  CG1 VAL D  89      -9.143  54.648  40.624  1.00 22.70           C  
ATOM   3054  CG2 VAL D  89      -7.788  54.664  42.639  1.00 18.58           C  
ATOM   3055  N   VAL D  90      -6.964  57.028  38.775  1.00 14.25           N  
ATOM   3056  CA  VAL D  90      -7.129  57.535  37.426  1.00 14.37           C  
ATOM   3057  C   VAL D  90      -5.918  57.169  36.540  1.00 16.21           C  
ATOM   3058  O   VAL D  90      -6.061  56.733  35.391  1.00 13.70           O  
ATOM   3059  CB  VAL D  90      -7.399  59.091  37.434  1.00 16.34           C  
ATOM   3060  CG1 VAL D  90      -7.496  59.621  36.027  1.00 19.02           C  
ATOM   3061  CG2 VAL D  90      -8.697  59.409  38.165  1.00 18.06           C  
ATOM   3062  N   GLY D  91      -4.723  57.408  37.041  1.00 14.44           N  
ATOM   3063  CA  GLY D  91      -3.512  57.237  36.265  1.00 15.43           C  
ATOM   3064  C   GLY D  91      -2.883  55.875  36.250  1.00 16.23           C  
ATOM   3065  O   GLY D  91      -1.997  55.634  35.445  1.00 17.35           O  
ATOM   3066  N   GLY D  92      -3.291  54.997  37.167  1.00 13.75           N  
ATOM   3067  CA  GLY D  92      -2.863  53.626  37.189  1.00 13.65           C  
ATOM   3068  C   GLY D  92      -1.679  53.342  38.065  1.00 14.07           C  
ATOM   3069  O   GLY D  92      -1.011  54.258  38.530  1.00 14.02           O  
ATOM   3070  N   SER D  93      -1.394  52.057  38.234  1.00 11.85           N  
ATOM   3071  CA  SER D  93      -0.218  51.585  38.980  1.00 13.67           C  
ATOM   3072  C   SER D  93       1.133  52.059  38.402  1.00 11.69           C  
ATOM   3073  O   SER D  93       2.149  52.128  39.116  1.00 11.70           O  
ATOM   3074  CB  SER D  93      -0.261  50.070  39.179  1.00 14.90           C  
ATOM   3075  OG  SER D  93       0.125  49.359  38.033  1.00 15.69           O  
ATOM   3076  N   ILE D  94       1.128  52.482  37.145  1.00 12.83           N  
ATOM   3077  CA  ILE D  94       2.296  53.088  36.537  1.00 10.75           C  
ATOM   3078  C   ILE D  94       2.767  54.345  37.294  1.00 13.75           C  
ATOM   3079  O   ILE D  94       3.928  54.748  37.226  1.00 16.33           O  
ATOM   3080  CB  ILE D  94       1.961  53.394  35.020  1.00 10.61           C  
ATOM   3081  CG1 ILE D  94       3.243  53.564  34.221  1.00 12.99           C  
ATOM   3082  CG2 ILE D  94       1.019  54.543  34.849  1.00 12.06           C  
ATOM   3083  CD1 ILE D  94       3.839  52.283  33.910  1.00 11.71           C  
ATOM   3084  N   VAL D  95       1.865  54.960  38.051  1.00 11.01           N  
ATOM   3085  CA  VAL D  95       2.214  56.144  38.837  1.00 13.98           C  
ATOM   3086  C   VAL D  95       2.895  55.829  40.182  1.00 13.47           C  
ATOM   3087  O   VAL D  95       3.465  56.733  40.821  1.00 14.23           O  
ATOM   3088  CB  VAL D  95       1.036  57.139  39.027  1.00 15.63           C  
ATOM   3089  CG1 VAL D  95       0.251  57.390  37.739  1.00 17.65           C  
ATOM   3090  CG2 VAL D  95       0.132  56.740  40.096  1.00 20.94           C  
ATOM   3091  N   ILE D  96       2.890  54.563  40.589  1.00 14.12           N  
ATOM   3092  CA  ILE D  96       3.385  54.200  41.924  1.00 13.06           C  
ATOM   3093  C   ILE D  96       4.803  54.740  42.250  1.00 13.34           C  
ATOM   3094  O   ILE D  96       4.983  55.340  43.314  1.00 14.71           O  
ATOM   3095  CB  ILE D  96       3.225  52.689  42.175  1.00 12.15           C  
ATOM   3096  CG1 ILE D  96       1.760  52.398  42.501  1.00 11.03           C  
ATOM   3097  CG2 ILE D  96       4.134  52.225  43.292  1.00 15.68           C  
ATOM   3098  CD1 ILE D  96       1.417  50.945  42.655  1.00 15.19           C  
ATOM   3099  N   PRO D  97       5.801  54.590  41.376  1.00 13.38           N  
ATOM   3100  CA  PRO D  97       7.143  55.139  41.687  1.00 12.38           C  
ATOM   3101  C   PRO D  97       7.140  56.643  41.955  1.00 13.72           C  
ATOM   3102  O   PRO D  97       7.867  57.108  42.831  1.00 15.53           O  
ATOM   3103  CB  PRO D  97       7.970  54.780  40.447  1.00 13.19           C  
ATOM   3104  CG  PRO D  97       7.247  53.570  39.867  1.00 12.62           C  
ATOM   3105  CD  PRO D  97       5.804  53.860  40.083  1.00 14.08           C  
ATOM   3106  N   HIS D  98       6.295  57.390  41.251  1.00 12.61           N  
ATOM   3107  CA  HIS D  98       6.168  58.818  41.487  1.00 14.96           C  
ATOM   3108  C   HIS D  98       5.456  59.119  42.805  1.00 17.54           C  
ATOM   3109  O   HIS D  98       5.834  60.045  43.528  1.00 18.46           O  
ATOM   3110  CB  HIS D  98       5.436  59.458  40.334  1.00 14.90           C  
ATOM   3111  CG  HIS D  98       6.192  59.388  39.058  1.00 15.41           C  
ATOM   3112  ND1 HIS D  98       7.067  60.365  38.656  1.00 24.41           N  
ATOM   3113  CD2 HIS D  98       6.219  58.436  38.101  1.00 16.58           C  
ATOM   3114  CE1 HIS D  98       7.600  60.018  37.501  1.00 18.52           C  
ATOM   3115  NE2 HIS D  98       7.114  58.841  37.150  1.00 23.22           N  
ATOM   3116  N   LEU D  99       4.416  58.343  43.097  1.00 17.40           N  
ATOM   3117  CA  LEU D  99       3.683  58.476  44.355  1.00 21.86           C  
ATOM   3118  C   LEU D  99       4.601  58.252  45.543  1.00 20.54           C  
ATOM   3119  O   LEU D  99       4.553  58.998  46.548  1.00 21.30           O  
ATOM   3120  CB  LEU D  99       2.519  57.483  44.356  1.00 21.45           C  
ATOM   3121  CG  LEU D  99       1.783  57.243  45.657  1.00 32.82           C  
ATOM   3122  CD1 LEU D  99       1.212  58.517  46.122  1.00 34.14           C  
ATOM   3123  CD2 LEU D  99       0.696  56.227  45.428  1.00 43.01           C  
ATOM   3124  N   ARG D 100       5.432  57.222  45.438  1.00 20.35           N  
ATOM   3125  CA  ARG D 100       6.416  56.884  46.471  1.00 21.76           C  
ATOM   3126  C   ARG D 100       7.397  58.021  46.731  1.00 22.18           C  
ATOM   3127  O   ARG D 100       7.688  58.383  47.903  1.00 18.52           O  
ATOM   3128  CB  ARG D 100       7.206  55.616  46.103  1.00 23.39           C  
ATOM   3129  CG  ARG D 100       6.450  54.305  46.285  1.00 27.41           C  
ATOM   3130  CD  ARG D 100       7.319  53.046  46.059  1.00 26.01           C  
ATOM   3131  N   ARG D 101       7.924  58.572  45.645  1.00 19.05           N  
ATOM   3132  CA  ARG D 101       8.809  59.730  45.728  1.00 20.56           C  
ATOM   3133  C   ARG D 101       8.123  60.957  46.335  1.00 17.03           C  
ATOM   3134  O   ARG D 101       8.753  61.703  47.136  1.00 17.16           O  
ATOM   3135  CB  ARG D 101       9.401  60.065  44.358  1.00 20.67           C  
ATOM   3136  CG  ARG D 101      10.436  59.061  43.931  1.00 27.42           C  
ATOM   3137  CD  ARG D 101      11.306  59.544  42.798  1.00 37.69           C  
ATOM   3138  NE  ARG D 101      10.585  59.460  41.544  1.00 43.50           N  
ATOM   3139  CZ  ARG D 101      10.507  58.368  40.772  1.00 43.48           C  
ATOM   3140  NH1 ARG D 101      11.109  57.225  41.105  1.00 42.00           N  
ATOM   3141  NH2 ARG D 101       9.802  58.432  39.653  1.00 33.47           N  
ATOM   3142  N   ALA D 102       6.855  61.176  45.956  1.00 16.14           N  
ATOM   3143  CA  ALA D 102       6.048  62.278  46.497  1.00 14.79           C  
ATOM   3144  C   ALA D 102       5.901  62.150  48.023  1.00 16.04           C  
ATOM   3145  O   ALA D 102       6.054  63.132  48.759  1.00 16.51           O  
ATOM   3146  CB  ALA D 102       4.714  62.298  45.854  1.00 17.42           C  
ATOM   3147  N   VAL D 103       5.544  60.962  48.492  1.00 14.41           N  
ATOM   3148  CA  VAL D 103       5.335  60.786  49.939  1.00 14.85           C  
ATOM   3149  C   VAL D 103       6.666  60.977  50.674  1.00 16.36           C  
ATOM   3150  O   VAL D 103       6.710  61.580  51.753  1.00 15.14           O  
ATOM   3151  CB  VAL D 103       4.678  59.424  50.261  1.00 16.31           C  
ATOM   3152  CG1 VAL D 103       4.557  59.227  51.786  1.00 21.68           C  
ATOM   3153  CG2 VAL D 103       3.308  59.378  49.655  1.00 18.38           C  
ATOM   3154  N   GLY D 104       7.764  60.485  50.106  1.00 16.23           N  
ATOM   3155  CA  GLY D 104       9.062  60.693  50.734  1.00 16.92           C  
ATOM   3156  C   GLY D 104       9.449  62.163  50.832  1.00 17.06           C  
ATOM   3157  O   GLY D 104      10.024  62.616  51.843  1.00 17.24           O  
ATOM   3158  N   PHE D 105       9.161  62.908  49.776  1.00 14.79           N  
ATOM   3159  CA  PHE D 105       9.462  64.334  49.737  1.00 14.77           C  
ATOM   3160  C   PHE D 105       8.583  65.097  50.724  1.00 15.55           C  
ATOM   3161  O   PHE D 105       9.073  65.999  51.418  1.00 17.15           O  
ATOM   3162  CB  PHE D 105       9.295  64.888  48.318  1.00 15.90           C  
ATOM   3163  CG  PHE D 105       9.732  66.317  48.159  1.00 15.93           C  
ATOM   3164  CD1 PHE D 105      11.021  66.715  48.482  1.00 24.20           C  
ATOM   3165  CD2 PHE D 105       8.849  67.268  47.711  1.00 17.82           C  
ATOM   3166  CE1 PHE D 105      11.402  68.054  48.342  1.00 24.41           C  
ATOM   3167  CE2 PHE D 105       9.235  68.582  47.551  1.00 21.87           C  
ATOM   3168  CZ  PHE D 105      10.494  68.979  47.874  1.00 24.59           C  
ATOM   3169  N   LEU D 106       7.304  64.726  50.826  1.00 12.97           N  
ATOM   3170  CA  LEU D 106       6.423  65.330  51.827  1.00 13.02           C  
ATOM   3171  C   LEU D 106       6.999  65.137  53.243  1.00 12.66           C  
ATOM   3172  O   LEU D 106       6.999  66.043  54.074  1.00 15.22           O  
ATOM   3173  CB  LEU D 106       5.020  64.712  51.736  1.00 11.85           C  
ATOM   3174  CG  LEU D 106       3.977  65.185  52.763  1.00 13.73           C  
ATOM   3175  CD1 LEU D 106       3.779  66.662  52.711  1.00 15.30           C  
ATOM   3176  CD2 LEU D 106       2.674  64.431  52.511  1.00 15.86           C  
ATOM   3177  N   GLU D 107       7.528  63.956  53.523  1.00 13.26           N  
ATOM   3178  CA  GLU D 107       8.089  63.700  54.855  1.00 14.41           C  
ATOM   3179  C   GLU D 107       9.281  64.602  55.121  1.00 15.84           C  
ATOM   3180  O   GLU D 107       9.445  65.106  56.241  1.00 15.96           O  
ATOM   3181  CB  GLU D 107       8.479  62.229  55.009  1.00 14.91           C  
ATOM   3182  CG  GLU D 107       7.220  61.391  55.070  1.00 18.41           C  
ATOM   3183  CD  GLU D 107       7.461  59.906  55.193  1.00 27.57           C  
ATOM   3184  OE1 GLU D 107       8.641  59.478  55.262  1.00 31.29           O  
ATOM   3185  OE2 GLU D 107       6.440  59.180  55.229  1.00 24.04           O  
ATOM   3186  N   GLU D 108      10.107  64.834  54.102  1.00 14.24           N  
ATOM   3187  CA  GLU D 108      11.186  65.819  54.262  1.00 17.32           C  
ATOM   3188  C   GLU D 108      10.648  67.211  54.576  1.00 16.01           C  
ATOM   3189  O   GLU D 108      11.219  67.924  55.402  1.00 16.24           O  
ATOM   3190  CB  GLU D 108      12.056  65.947  53.012  1.00 16.93           C  
ATOM   3191  CG  GLU D 108      12.782  64.695  52.569  1.00 25.85           C  
ATOM   3192  CD  GLU D 108      13.382  64.866  51.162  1.00 28.25           C  
ATOM   3193  OE1 GLU D 108      13.983  65.945  50.894  1.00 45.48           O  
ATOM   3194  OE2 GLU D 108      13.248  63.935  50.327  1.00 43.88           O  
ATOM   3195  N   LEU D 109       9.565  67.608  53.894  1.00 13.82           N  
ATOM   3196  CA  LEU D 109       9.000  68.939  54.125  1.00 14.47           C  
ATOM   3197  C   LEU D 109       8.487  69.074  55.560  1.00 14.45           C  
ATOM   3198  O   LEU D 109       8.681  70.121  56.203  1.00 16.21           O  
ATOM   3199  CB  LEU D 109       7.899  69.243  53.108  1.00 14.39           C  
ATOM   3200  CG  LEU D 109       8.350  69.336  51.639  1.00 14.97           C  
ATOM   3201  CD1 LEU D 109       7.160  69.562  50.657  1.00 19.67           C  
ATOM   3202  CD2 LEU D 109       9.420  70.427  51.443  1.00 22.00           C  
ATOM   3203  N   ARG D 110       7.862  68.019  56.076  1.00 12.90           N  
ATOM   3204  CA  ARG D 110       7.322  68.071  57.440  1.00 12.84           C  
ATOM   3205  C   ARG D 110       8.437  68.159  58.473  1.00 14.91           C  
ATOM   3206  O   ARG D 110       8.302  68.848  59.500  1.00 15.66           O  
ATOM   3207  CB  ARG D 110       6.463  66.854  57.723  1.00 13.25           C  
ATOM   3208  CG  ARG D 110       5.217  66.819  56.875  1.00 12.43           C  
ATOM   3209  CD  ARG D 110       4.362  68.071  56.981  1.00 13.32           C  
ATOM   3210  NE  ARG D 110       3.086  67.879  56.294  1.00 12.37           N  
ATOM   3211  CZ  ARG D 110       2.223  68.860  56.017  1.00 15.41           C  
ATOM   3212  NH1 ARG D 110       2.498  70.114  56.367  1.00 13.65           N  
ATOM   3213  NH2 ARG D 110       1.082  68.595  55.352  1.00 12.88           N  
ATOM   3214  N   GLU D 111       9.532  67.466  58.198  1.00 16.64           N  
ATOM   3215  CA  GLU D 111      10.714  67.523  59.088  1.00 19.36           C  
ATOM   3216  C   GLU D 111      11.300  68.935  59.123  1.00 19.90           C  
ATOM   3217  O   GLU D 111      11.601  69.455  60.190  1.00 19.09           O  
ATOM   3218  CB  GLU D 111      11.756  66.503  58.644  1.00 17.92           C  
ATOM   3219  CG  GLU D 111      12.887  66.302  59.639  1.00 24.35           C  
ATOM   3220  CD  GLU D 111      13.804  65.148  59.260  1.00 26.40           C  
ATOM   3221  OE1 GLU D 111      13.616  64.539  58.177  1.00 47.44           O  
ATOM   3222  OE2 GLU D 111      14.727  64.853  60.049  1.00 44.47           O  
ATOM   3223  N   MET D 112      11.441  69.565  57.963  1.00 18.32           N  
ATOM   3224  CA  MET D 112      11.877  70.960  57.915  1.00 22.30           C  
ATOM   3225  C   MET D 112      10.967  71.841  58.766  1.00 23.25           C  
ATOM   3226  O   MET D 112      11.436  72.645  59.571  1.00 21.47           O  
ATOM   3227  CB  MET D 112      11.865  71.481  56.472  1.00 22.13           C  
ATOM   3228  CG  MET D 112      12.931  70.881  55.576  1.00 22.93           C  
ATOM   3229  SD  MET D 112      12.797  71.470  53.858  1.00 29.64           S  
ATOM   3230  CE  MET D 112      13.290  73.194  54.056  1.00 35.88           C  
ATOM   3231  N   GLU D 113       9.658  71.690  58.585  1.00 24.04           N  
ATOM   3232  CA  GLU D 113       8.677  72.417  59.393  1.00 26.67           C  
ATOM   3233  C   GLU D 113       8.912  72.239  60.888  1.00 28.09           C  
ATOM   3234  O   GLU D 113       8.925  73.226  61.636  1.00 30.12           O  
ATOM   3235  CB  GLU D 113       7.256  71.971  59.065  1.00 27.25           C  
ATOM   3236  CG  GLU D 113       6.584  72.776  57.984  1.00 31.46           C  
ATOM   3237  CD  GLU D 113       5.108  72.421  57.853  1.00 41.83           C  
ATOM   3238  OE1 GLU D 113       4.749  71.229  58.018  1.00 24.69           O  
ATOM   3239  OE2 GLU D 113       4.300  73.341  57.599  1.00 48.16           O  
ATOM   3240  N   LYS D 114       9.098  70.996  61.329  1.00 26.90           N  
ATOM   3241  CA  LYS D 114       9.346  70.740  62.749  1.00 28.15           C  
ATOM   3242  C   LYS D 114      10.651  71.364  63.232  1.00 29.88           C  
ATOM   3243  O   LYS D 114      10.748  71.727  64.407  1.00 31.79           O  
ATOM   3244  CB  LYS D 114       9.309  69.249  63.080  1.00 27.29           C  
ATOM   3245  CG  LYS D 114       7.890  68.704  63.057  1.00 28.81           C  
ATOM   3246  CD  LYS D 114       7.856  67.213  63.289  1.00 34.08           C  
ATOM   3247  CE  LYS D 114       6.485  66.648  62.940  1.00 38.41           C  
ATOM   3248  NZ  LYS D 114       5.507  67.144  63.916  1.00 23.28           N  
ATOM   3249  N   ASN D 115      11.634  71.502  62.340  1.00 30.49           N  
ATOM   3250  CA  ASN D 115      12.920  72.152  62.675  1.00 31.67           C  
ATOM   3251  C   ASN D 115      12.915  73.672  62.450  1.00 32.54           C  
ATOM   3252  O   ASN D 115      13.963  74.320  62.548  1.00 31.57           O  
ATOM   3253  CB  ASN D 115      14.063  71.554  61.854  1.00 30.47           C  
ATOM   3254  CG  ASN D 115      14.218  70.068  62.051  1.00 39.79           C  
ATOM   3255  OD1 ASN D 115      14.930  69.406  61.288  1.00 52.61           O  
ATOM   3256  ND2 ASN D 115      13.564  69.527  63.077  1.00 49.53           N  
ATOM   3257  N   GLY D 116      11.755  74.229  62.120  1.00 33.36           N  
ATOM   3258  CA  GLY D 116      11.602  75.673  61.948  1.00 33.54           C  
ATOM   3259  C   GLY D 116      12.268  76.273  60.723  1.00 34.07           C  
ATOM   3260  O   GLY D 116      12.479  77.483  60.668  1.00 32.87           O  
ATOM   3261  N   GLU D 117      12.597  75.437  59.738  1.00 33.51           N  
ATOM   3262  CA  GLU D 117      13.181  75.909  58.488  1.00 34.69           C  
ATOM   3263  C   GLU D 117      12.082  76.428  57.572  1.00 36.12           C  
ATOM   3264  O   GLU D 117      10.973  75.873  57.524  1.00 37.39           O  
ATOM   3265  CB  GLU D 117      13.953  74.785  57.785  1.00 34.50           C  
ATOM   3266  CG  GLU D 117      15.166  74.282  58.562  1.00 39.47           C  
ATOM   3267  CD  GLU D 117      15.615  72.895  58.128  1.00 42.80           C  
ATOM   3268  OE1 GLU D 117      15.926  72.696  56.929  1.00 43.85           O  
ATOM   3269  OE2 GLU D 117      15.656  71.998  58.996  1.00 51.92           O  
ATOM   3270  N   THR D 118      12.396  77.499  56.850  1.00 36.80           N  
ATOM   3271  CA  THR D 118      11.451  78.116  55.920  1.00 36.91           C  
ATOM   3272  C   THR D 118      11.427  77.263  54.656  1.00 36.47           C  
ATOM   3273  O   THR D 118      12.470  76.810  54.183  1.00 36.02           O  
ATOM   3274  CB  THR D 118      11.860  79.587  55.608  1.00 37.83           C  
ATOM   3275  OG1 THR D 118      11.915  80.364  56.826  1.00 34.83           O  
ATOM   3276  CG2 THR D 118      10.803  80.291  54.742  1.00 35.83           C  
ATOM   3277  N   ILE D 119      10.225  77.047  54.122  1.00 36.63           N  
ATOM   3278  CA  ILE D 119      10.006  76.051  53.072  1.00 35.64           C  
ATOM   3279  C   ILE D 119      10.313  76.579  51.650  1.00 38.59           C  
ATOM   3280  O   ILE D 119      10.296  77.790  51.369  1.00 39.43           O  
ATOM   3281  CB  ILE D 119       8.558  75.514  53.188  1.00 33.34           C  
ATOM   3282  CG1 ILE D 119       8.326  74.775  54.512  1.00 33.40           C  
ATOM   3283  CG2 ILE D 119       8.208  74.582  52.037  1.00 31.07           C  
ATOM   3284  CD1 ILE D 119       8.974  73.424  54.625  1.00 34.64           C  
TER    3285      ILE D 119                                                      
END
MOLECULE T0408.pdb
ATOM    769  N   PHE     7       8.970  79.991  40.219  1.00 59.01           N  
ATOM    770  CA  PHE     7       9.121  78.887  39.220  1.00 58.55           C  
ATOM    771  C   PHE     7      10.525  78.270  39.318  1.00 57.17           C  
ATOM    772  O   PHE     7      11.448  78.885  39.884  1.00 59.33           O  
ATOM    773  CB  PHE     7       8.894  79.403  37.792  1.00 59.50           C  
ATOM    774  CG  PHE     7       7.630  80.211  37.607  1.00 59.88           C  
ATOM    775  CD1 PHE     7       7.640  81.590  37.779  1.00 59.55           C  
ATOM    776  CD2 PHE     7       6.441  79.594  37.219  1.00 60.26           C  
ATOM    777  CE1 PHE     7       6.481  82.338  37.600  1.00 63.27           C  
ATOM    778  CE2 PHE     7       5.280  80.335  37.027  1.00 57.96           C  
ATOM    779  CZ  PHE     7       5.299  81.709  37.222  1.00 60.10           C  
ATOM    780  N   GLY     8      10.693  77.077  38.739  1.00 51.97           N  
ATOM    781  CA  GLY     8      11.946  76.308  38.864  1.00 47.06           C  
ATOM    782  C   GLY     8      13.010  76.644  37.842  1.00 42.74           C  
ATOM    783  O   GLY     8      12.960  77.691  37.199  1.00 40.60           O  
ATOM    784  N   GLU     9      13.969  75.734  37.690  1.00 39.01           N  
ATOM    785  CA  GLU     9      15.125  75.924  36.812  1.00 38.04           C  
ATOM    786  C   GLU     9      14.737  76.079  35.344  1.00 34.61           C  
ATOM    787  O   GLU     9      15.312  76.893  34.624  1.00 33.70           O  
ATOM    788  CB  GLU     9      16.093  74.746  36.964  1.00 38.65           C  
ATOM    789  N   GLY    10      13.750  75.287  34.915  1.00 34.19           N  
ATOM    790  CA  GLY    10      13.250  75.348  33.551  1.00 31.10           C  
ATOM    791  C   GLY    10      12.790  76.744  33.220  1.00 25.97           C  
ATOM    792  O   GLY    10      13.200  77.304  32.203  1.00 24.44           O  
ATOM    793  N   MET    11      11.958  77.314  34.091  1.00 26.78           N  
ATOM    794  CA  MET    11      11.453  78.679  33.871  1.00 26.99           C  
ATOM    795  C   MET    11      12.547  79.734  33.936  1.00 24.54           C  
ATOM    796  O   MET    11      12.436  80.750  33.237  1.00 22.59           O  
ATOM    797  CB  MET    11      10.298  79.036  34.809  1.00 26.96           C  
ATOM    798  CG  MET    11       8.956  78.424  34.384  1.00 30.81           C  
ATOM    799  SD  MET    11       8.363  79.163  32.682  0.75 32.36          SE  
ATOM    800  CE  MET    11       7.641  80.815  33.439  1.00 38.14           C  
ATOM    801  N   LYS    12      13.587  79.531  34.749  1.00 22.58           N  
ATOM    802  CA  LYS    12      14.709  80.488  34.749  1.00 22.98           C  
ATOM    803  C   LYS    12      15.471  80.468  33.411  1.00 20.97           C  
ATOM    804  O   LYS    12      15.931  81.507  32.944  1.00 22.83           O  
ATOM    805  CB  LYS    12      15.656  80.233  35.932  1.00 24.68           C  
ATOM    806  CG  LYS    12      14.987  80.568  37.290  1.00 26.05           C  
ATOM    807  CD  LYS    12      15.724  79.996  38.524  1.00 31.53           C  
ATOM    808  CE  LYS    12      17.178  80.177  38.487  1.00 33.33           C  
ATOM    809  NZ  LYS    12      17.857  79.899  39.811  1.00 35.75           N  
ATOM    810  N   VAL    13      15.558  79.292  32.784  1.00 23.05           N  
ATOM    811  CA  VAL    13      16.174  79.143  31.455  1.00 22.27           C  
ATOM    812  C   VAL    13      15.338  79.931  30.437  1.00 19.87           C  
ATOM    813  O   VAL    13      15.870  80.675  29.599  1.00 19.37           O  
ATOM    814  CB  VAL    13      16.227  77.631  31.026  1.00 24.12           C  
ATOM    815  CG1 VAL    13      16.716  77.489  29.584  1.00 25.29           C  
ATOM    816  CG2 VAL    13      17.136  76.836  31.979  1.00 30.23           C  
ATOM    817  N   VAL    14      14.032  79.817  30.576  1.00 20.72           N  
ATOM    818  CA  VAL    14      13.119  80.535  29.668  1.00 22.65           C  
ATOM    819  C   VAL    14      13.274  82.037  29.865  1.00 19.62           C  
ATOM    820  O   VAL    14      13.348  82.784  28.895  1.00 20.37           O  
ATOM    821  CB  VAL    14      11.657  80.121  29.823  1.00 21.69           C  
ATOM    822  CG1 VAL    14      10.788  80.938  28.849  1.00 21.74           C  
ATOM    823  CG2 VAL    14      11.465  78.585  29.542  1.00 26.25           C  
ATOM    824  N   LYS    15      13.332  82.483  31.131  1.00 21.22           N  
ATOM    825  CA  LYS    15      13.580  83.912  31.414  1.00 18.46           C  
ATOM    826  C   LYS    15      14.866  84.401  30.767  1.00 19.65           C  
ATOM    827  O   LYS    15      14.894  85.480  30.187  1.00 22.14           O  
ATOM    828  CB  LYS    15      13.617  84.181  32.921  1.00 18.27           C  
ATOM    829  N   GLU    16      15.918  83.608  30.857  1.00 21.08           N  
ATOM    830  CA  GLU    16      17.202  83.950  30.227  1.00 22.56           C  
ATOM    831  C   GLU    16      17.144  83.974  28.678  1.00 22.82           C  
ATOM    832  O   GLU    16      17.665  84.891  28.042  1.00 28.47           O  
ATOM    833  CB  GLU    16      18.277  82.981  30.693  1.00 24.31           C  
ATOM    834  N   LYS    17      16.521  82.963  28.097  1.00 21.86           N  
ATOM    835  CA  LYS    17      16.542  82.770  26.636  1.00 22.20           C  
ATOM    836  C   LYS    17      15.493  83.586  25.851  1.00 21.86           C  
ATOM    837  O   LYS    17      15.808  84.146  24.776  1.00 23.86           O  
ATOM    838  CB  LYS    17      16.365  81.277  26.315  1.00 21.29           C  
ATOM    839  N   TYR    18      14.290  83.672  26.407  1.00 22.99           N  
ATOM    840  CA  TYR    18      13.084  84.212  25.724  1.00 24.08           C  
ATOM    841  C   TYR    18      12.235  85.030  26.691  1.00 21.96           C  
ATOM    842  O   TYR    18      11.217  84.579  27.196  1.00 21.62           O  
ATOM    843  CB  TYR    18      12.270  83.071  25.102  1.00 23.86           C  
ATOM    844  CG  TYR    18      13.142  82.276  24.153  1.00 25.16           C  
ATOM    845  CD1 TYR    18      13.658  82.867  23.007  1.00 22.60           C  
ATOM    846  CD2 TYR    18      13.503  80.967  24.432  1.00 27.55           C  
ATOM    847  CE1 TYR    18      14.496  82.174  22.142  1.00 26.49           C  
ATOM    848  CE2 TYR    18      14.364  80.270  23.576  1.00 26.29           C  
ATOM    849  CZ  TYR    18      14.846  80.874  22.433  1.00 25.54           C  
ATOM    850  OH  TYR    18      15.686  80.188  21.581  1.00 26.16           O  
ATOM    851  N   PRO    19      12.703  86.256  26.994  1.00 22.95           N  
ATOM    852  CA  PRO    19      12.008  87.103  27.963  1.00 20.97           C  
ATOM    853  C   PRO    19      10.540  87.377  27.666  1.00 23.47           C  
ATOM    854  O   PRO    19       9.729  87.342  28.598  1.00 22.73           O  
ATOM    855  CB  PRO    19      12.823  88.395  27.933  1.00 22.49           C  
ATOM    856  CG  PRO    19      14.111  88.033  27.370  1.00 24.22           C  
ATOM    857  CD  PRO    19      13.956  86.869  26.528  1.00 23.77           C  
ATOM    858  N   ASP    20      10.175  87.629  26.413  1.00 23.93           N  
ATOM    859  CA  ASP    20       8.772  87.917  26.104  1.00 28.48           C  
ATOM    860  C   ASP    20       7.908  86.671  26.266  1.00 26.25           C  
ATOM    861  O   ASP    20       6.756  86.723  26.775  1.00 26.13           O  
ATOM    862  CB  ASP    20       8.618  88.482  24.690  1.00 30.80           C  
ATOM    863  CG  ASP    20       9.052  89.954  24.570  1.00 38.16           C  
ATOM    864  OD1 ASP    20       9.402  90.617  25.580  1.00 42.94           O  
ATOM    865  OD2 ASP    20       9.033  90.451  23.426  1.00 46.06           O  
ATOM    866  N   LEU    21       8.444  85.524  25.878  1.00 24.97           N  
ATOM    867  CA  LEU    21       7.721  84.269  26.090  1.00 23.54           C  
ATOM    868  C   LEU    21       7.555  83.994  27.575  1.00 22.52           C  
ATOM    869  O   LEU    21       6.474  83.604  28.042  1.00 24.44           O  
ATOM    870  CB  LEU    21       8.447  83.115  25.385  1.00 23.74           C  
ATOM    871  CG  LEU    21       7.857  81.731  25.468  1.00 25.87           C  
ATOM    872  CD1 LEU    21       6.373  81.718  24.990  1.00 25.00           C  
ATOM    873  CD2 LEU    21       8.754  80.756  24.680  1.00 23.70           C  
ATOM    874  N   TYR    22       8.626  84.193  28.326  1.00 22.41           N  
ATOM    875  CA  TYR    22       8.584  84.070  29.780  1.00 22.77           C  
ATOM    876  C   TYR    22       7.435  84.913  30.380  1.00 22.67           C  
ATOM    877  O   TYR    22       6.627  84.425  31.175  1.00 23.91           O  
ATOM    878  CB  TYR    22       9.912  84.494  30.385  1.00 23.66           C  
ATOM    879  CG  TYR    22       9.886  84.492  31.893  1.00 22.50           C  
ATOM    880  CD1 TYR    22      10.074  83.325  32.604  1.00 23.27           C  
ATOM    881  CD2 TYR    22       9.660  85.671  32.602  1.00 25.67           C  
ATOM    882  CE1 TYR    22      10.047  83.327  33.987  1.00 21.18           C  
ATOM    883  CE2 TYR    22       9.622  85.671  33.963  1.00 25.00           C  
ATOM    884  CZ  TYR    22       9.808  84.488  34.647  1.00 23.45           C  
ATOM    885  OH  TYR    22       9.784  84.487  35.999  1.00 27.44           O  
ATOM    886  N   ASP    23       7.378  86.174  29.980  1.00 23.82           N  
ATOM    887  CA  ASP    23       6.360  87.088  30.502  1.00 24.16           C  
ATOM    888  C   ASP    23       4.927  86.625  30.205  1.00 25.07           C  
ATOM    889  O   ASP    23       4.046  86.754  31.064  1.00 23.28           O  
ATOM    890  CB  ASP    23       6.577  88.482  29.910  1.00 24.42           C  
ATOM    891  CG  ASP    23       7.742  89.194  30.505  1.00 33.39           C  
ATOM    892  OD1 ASP    23       8.216  88.809  31.607  1.00 34.11           O  
ATOM    893  OD2 ASP    23       8.170  90.189  29.868  1.00 37.66           O  
ATOM    894  N   ILE    24       4.693  86.066  29.019  1.00 23.65           N  
ATOM    895  CA  ILE    24       3.350  85.619  28.651  1.00 24.84           C  
ATOM    896  C   ILE    24       3.018  84.370  29.489  1.00 23.61           C  
ATOM    897  O   ILE    24       1.899  84.210  29.967  1.00 24.22           O  
ATOM    898  CB  ILE    24       3.222  85.316  27.150  1.00 27.79           C  
ATOM    899  CG1 ILE    24       3.448  86.587  26.329  1.00 32.72           C  
ATOM    900  CG2 ILE    24       1.848  84.746  26.841  1.00 30.67           C  
ATOM    901  CD1 ILE    24       3.838  86.311  24.854  1.00 35.16           C  
ATOM    902  N   ILE    25       4.024  83.514  29.707  1.00 24.35           N  
ATOM    903  CA  ILE    25       3.817  82.316  30.523  1.00 24.21           C  
ATOM    904  C   ILE    25       3.445  82.707  31.965  1.00 23.22           C  
ATOM    905  O   ILE    25       2.509  82.132  32.562  1.00 25.47           O  
ATOM    906  CB  ILE    25       5.047  81.338  30.493  1.00 24.22           C  
ATOM    907  CG1 ILE    25       5.238  80.729  29.103  1.00 23.74           C  
ATOM    908  CG2 ILE    25       4.856  80.188  31.494  1.00 29.35           C  
ATOM    909  CD1 ILE    25       6.631  80.075  28.922  1.00 23.35           C  
ATOM    910  N   VAL    26       4.144  83.697  32.511  1.00 24.58           N  
ATOM    911  CA  VAL    26       3.846  84.171  33.859  1.00 26.19           C  
ATOM    912  C   VAL    26       2.405  84.710  33.937  1.00 24.90           C  
ATOM    913  O   VAL    26       1.639  84.349  34.854  1.00 24.16           O  
ATOM    914  CB  VAL    26       4.836  85.230  34.313  1.00 28.22           C  
ATOM    915  CG1 VAL    26       4.301  85.976  35.531  1.00 28.71           C  
ATOM    916  CG2 VAL    26       6.242  84.589  34.603  1.00 26.39           C  
ATOM    917  N   LYS    27       2.006  85.523  32.967  1.00 23.37           N  
ATOM    918  CA  LYS    27       0.622  86.024  32.925  0.50 23.88           C  
ATOM    920  C   LYS    27      -0.377  84.879  32.823  1.00 24.17           C  
ATOM    921  O   LYS    27      -1.387  84.886  33.498  1.00 24.41           O  
ATOM    922  CB  LYS    27       0.414  87.028  31.779  0.50 24.31           C  
ATOM    924  CG  LYS    27       1.172  88.334  31.934  0.50 20.98           C  
ATOM    926  N   LEU    28      -0.091  83.873  31.981  1.00 23.31           N  
ATOM    927  CA  LEU    28      -0.962  82.705  31.832  1.00 25.23           C  
ATOM    928  C   LEU    28      -1.121  81.995  33.180  1.00 25.13           C  
ATOM    929  O   LEU    28      -2.231  81.653  33.640  1.00 24.63           O  
ATOM    930  CB  LEU    28      -0.374  81.739  30.788  1.00 23.04           C  
ATOM    931  CG  LEU    28      -1.148  80.428  30.624  1.00 24.78           C  
ATOM    932  CD1 LEU    28      -2.545  80.697  30.079  1.00 32.09           C  
ATOM    933  CD2 LEU    28      -0.369  79.493  29.738  1.00 28.12           C  
ATOM    934  N   ASN    29       0.023  81.773  33.828  1.00 22.56           N  
ATOM    935  CA  ASN    29       0.048  81.101  35.117  1.00 24.38           C  
ATOM    936  C   ASN    29      -0.813  81.844  36.140  1.00 22.89           C  
ATOM    937  O   ASN    29      -1.651  81.255  36.839  1.00 26.79           O  
ATOM    938  CB  ASN    29       1.491  80.993  35.606  1.00 27.63           C  
ATOM    939  CG  ASN    29       1.585  80.340  36.962  1.00 33.82           C  
ATOM    940  OD1 ASN    29       1.667  79.126  37.053  1.00 33.33           O  
ATOM    941  ND2 ASN    29       1.566  81.143  38.011  1.00 35.43           N  
ATOM    942  N   ASP    30      -0.596  83.141  36.234  1.00 22.88           N  
ATOM    943  CA  ASP    30      -1.285  83.973  37.203  1.00 24.82           C  
ATOM    944  C   ASP    30      -2.797  84.034  36.943  1.00 25.07           C  
ATOM    945  O   ASP    30      -3.601  84.001  37.880  1.00 26.99           O  
ATOM    946  CB  ASP    30      -0.694  85.365  37.193  1.00 26.68           C  
ATOM    947  CG  ASP    30       0.726  85.408  37.720  1.00 28.43           C  
ATOM    948  OD1 ASP    30       1.234  84.358  38.174  1.00 35.44           O  
ATOM    949  OD2 ASP    30       1.331  86.499  37.649  1.00 29.80           O  
ATOM    950  N   THR    31      -3.173  84.070  35.675  1.00 22.79           N  
ATOM    951  CA  THR    31      -4.600  83.984  35.289  1.00 24.26           C  
ATOM    952  C   THR    31      -5.213  82.620  35.540  1.00 23.93           C  
ATOM    953  O   THR    31      -6.339  82.515  36.082  1.00 24.83           O  
ATOM    954  CB  THR    31      -4.809  84.366  33.824  1.00 22.72           C  
ATOM    955  OG1 THR    31      -4.260  85.683  33.614  1.00 30.25           O  
ATOM    956  CG2 THR    31      -6.307  84.307  33.460  1.00 24.57           C  
ATOM    957  N   VAL    32      -4.509  81.554  35.146  1.00 22.77           N  
ATOM    958  CA  VAL    32      -4.974  80.194  35.438  1.00 24.03           C  
ATOM    959  C   VAL    32      -5.286  80.043  36.936  1.00 23.77           C  
ATOM    960  O   VAL    32      -6.329  79.469  37.304  1.00 25.63           O  
ATOM    961  CB  VAL    32      -3.924  79.174  34.994  1.00 23.98           C  
ATOM    962  CG1 VAL    32      -4.033  77.835  35.796  1.00 24.54           C  
ATOM    963  CG2 VAL    32      -4.012  78.986  33.460  1.00 22.05           C  
ATOM    964  N   PHE    33      -4.431  80.590  37.799  1.00 23.43           N  
ATOM    965  CA  PHE    33      -4.601  80.397  39.246  1.00 25.33           C  
ATOM    966  C   PHE    33      -5.403  81.502  39.922  1.00 27.87           C  
ATOM    967  O   PHE    33      -5.384  81.637  41.159  1.00 27.20           O  
ATOM    968  CB  PHE    33      -3.266  80.181  39.951  1.00 27.45           C  
ATOM    969  CG  PHE    33      -2.688  78.829  39.709  1.00 26.58           C  
ATOM    970  CD1 PHE    33      -3.361  77.688  40.124  1.00 26.58           C  
ATOM    971  CD2 PHE    33      -1.487  78.692  39.040  1.00 27.16           C  
ATOM    972  CE1 PHE    33      -2.844  76.433  39.875  1.00 26.69           C  
ATOM    973  CE2 PHE    33      -0.960  77.444  38.790  1.00 25.47           C  
ATOM    974  CZ  PHE    33      -1.643  76.315  39.204  1.00 28.16           C  
ATOM    975  N   THR    34      -6.104  82.288  39.114  1.00 28.08           N  
ATOM    976  CA  THR    34      -7.123  83.205  39.620  1.00 27.68           C  
ATOM    977  C   THR    34      -8.472  82.607  39.227  1.00 26.27           C  
ATOM    978  O   THR    34      -9.079  82.991  38.223  1.00 24.59           O  
ATOM    979  CB  THR    34      -6.912  84.630  39.078  1.00 29.15           C  
ATOM    980  OG1 THR    34      -5.572  85.039  39.354  1.00 27.52           O  
ATOM    981  CG2 THR    34      -7.858  85.624  39.752  1.00 27.57           C  
ATOM    982  N   GLY    35      -8.916  81.627  40.013  1.00 23.37           N  
ATOM    983  CA  GLY    35     -10.169  80.966  39.763  1.00 26.15           C  
ATOM    984  C   GLY    35     -11.353  81.880  40.008  1.00 26.00           C  
ATOM    985  O   GLY    35     -11.261  82.862  40.761  1.00 26.21           O  
ATOM    986  N   LYS    36     -12.466  81.593  39.353  1.00 26.20           N  
ATOM    987  CA  LYS    36     -13.707  82.364  39.626  1.00 25.52           C  
ATOM    988  C   LYS    36     -14.401  81.918  40.902  1.00 25.59           C  
ATOM    989  O   LYS    36     -15.013  82.749  41.608  1.00 24.82           O  
ATOM    990  CB  LYS    36     -14.650  82.280  38.433  1.00 23.76           C  
ATOM    991  CG  LYS    36     -14.018  82.839  37.170  1.00 27.92           C  
ATOM    992  CD  LYS    36     -13.636  84.274  37.261  1.00 33.79           C  
ATOM    993  CE  LYS    36     -13.123  84.756  35.913  1.00 33.74           C  
ATOM    994  NZ  LYS    36     -12.672  86.191  35.921  1.00 36.41           N  
ATOM    995  N   THR    37     -14.305  80.634  41.224  1.00 26.34           N  
ATOM    996  CA  THR    37     -14.895  80.088  42.444  1.00 27.40           C  
ATOM    997  C   THR    37     -13.901  79.304  43.281  1.00 28.68           C  
ATOM    998  O   THR    37     -13.830  79.501  44.486  1.00 28.44           O  
ATOM    999  CB  THR    37     -16.085  79.125  42.147  1.00 30.61           C  
ATOM   1000  OG1 THR    37     -17.140  79.845  41.507  1.00 34.12           O  
ATOM   1001  CG2 THR    37     -16.683  78.562  43.442  1.00 27.91           C  
ATOM   1002  N   LEU    38     -13.154  78.398  42.652  1.00 24.44           N  
ATOM   1003  CA  LEU    38     -12.190  77.556  43.382  1.00 24.53           C  
ATOM   1004  C   LEU    38     -11.018  78.408  43.841  1.00 26.73           C  
ATOM   1005  O   LEU    38     -10.561  79.304  43.117  1.00 26.13           O  
ATOM   1006  CB  LEU    38     -11.682  76.416  42.494  1.00 24.24           C  
ATOM   1007  CG  LEU    38     -12.721  75.446  41.996  1.00 25.01           C  
ATOM   1008  CD1 LEU    38     -12.043  74.310  41.217  1.00 23.26           C  
ATOM   1009  CD2 LEU    38     -13.555  74.919  43.151  1.00 22.80           C  
ATOM   1010  N   ASP    39     -10.539  78.150  45.053  1.00 25.77           N  
ATOM   1011  CA  ASP    39      -9.405  78.915  45.556  1.00 26.59           C  
ATOM   1012  C   ASP    39      -8.085  78.324  45.076  1.00 26.80           C  
ATOM   1013  O   ASP    39      -8.046  77.280  44.439  1.00 24.07           O  
ATOM   1014  CB  ASP    39      -9.484  79.093  47.084  1.00 27.84           C  
ATOM   1015  CG  ASP    39      -9.352  77.804  47.861  1.00 31.36           C  
ATOM   1016  OD1 ASP    39      -8.887  76.754  47.351  1.00 28.62           O  
ATOM   1017  OD2 ASP    39      -9.729  77.848  49.052  1.00 33.78           O  
ATOM   1018  N   TYR    40      -7.011  79.046  45.327  1.00 25.33           N  
ATOM   1019  CA  TYR    40      -5.703  78.664  44.822  1.00 24.51           C  
ATOM   1020  C   TYR    40      -5.243  77.312  45.372  1.00 25.46           C  
ATOM   1021  O   TYR    40      -4.698  76.478  44.641  1.00 24.60           O  
ATOM   1022  CB  TYR    40      -4.723  79.753  45.247  1.00 28.58           C  
ATOM   1023  CG  TYR    40      -3.320  79.640  44.733  1.00 27.35           C  
ATOM   1024  CD1 TYR    40      -3.051  79.264  43.426  1.00 42.63           C  
ATOM   1025  CD2 TYR    40      -2.241  79.981  45.555  1.00 35.86           C  
ATOM   1026  CE1 TYR    40      -1.744  79.202  42.958  1.00 45.32           C  
ATOM   1027  CE2 TYR    40      -0.946  79.919  45.099  1.00 36.50           C  
ATOM   1028  CZ  TYR    40      -0.701  79.543  43.803  1.00 41.69           C  
ATOM   1029  OH  TYR    40       0.596  79.495  43.344  1.00 43.10           O  
ATOM   1030  N   LYS    41      -5.466  77.097  46.659  1.00 24.17           N  
ATOM   1031  CA  LYS    41      -5.137  75.787  47.259  1.00 26.03           C  
ATOM   1032  C   LYS    41      -5.786  74.622  46.516  1.00 24.80           C  
ATOM   1033  O   LYS    41      -5.121  73.627  46.222  1.00 24.41           O  
ATOM   1034  CB  LYS    41      -5.525  75.756  48.725  1.00 26.17           C  
ATOM   1035  CG  LYS    41      -5.211  74.458  49.459  1.00 31.58           C  
ATOM   1036  CD  LYS    41      -5.774  74.499  50.886  1.00 33.11           C  
ATOM   1037  CE  LYS    41      -5.347  73.283  51.704  1.00 42.88           C  
ATOM   1038  NZ  LYS    41      -5.846  73.354  53.109  1.00 41.08           N  
ATOM   1039  N   THR    42      -7.074  74.738  46.237  1.00 24.70           N  
ATOM   1040  CA  THR    42      -7.798  73.688  45.520  1.00 23.81           C  
ATOM   1041  C   THR    42      -7.217  73.448  44.133  1.00 24.23           C  
ATOM   1042  O   THR    42      -7.022  72.317  43.719  1.00 23.25           O  
ATOM   1043  CB  THR    42      -9.301  73.985  45.416  1.00 24.82           C  
ATOM   1044  OG1 THR    42      -9.845  74.084  46.733  1.00 25.22           O  
ATOM   1045  CG2 THR    42     -10.038  72.883  44.667  1.00 25.77           C  
ATOM   1046  N   GLN    43      -6.933  74.527  43.418  1.00 23.43           N  
ATOM   1047  CA  GLN    43      -6.319  74.414  42.118  1.00 22.86           C  
ATOM   1048  C   GLN    43      -4.922  73.781  42.157  1.00 23.94           C  
ATOM   1049  O   GLN    43      -4.585  73.025  41.268  1.00 22.91           O  
ATOM   1050  CB  GLN    43      -6.246  75.772  41.437  1.00 24.01           C  
ATOM   1051  CG  GLN    43      -7.565  76.328  41.029  1.00 22.72           C  
ATOM   1052  CD  GLN    43      -7.399  77.608  40.263  1.00 23.02           C  
ATOM   1053  OE1 GLN    43      -6.876  78.573  40.809  1.00 25.62           O  
ATOM   1054  NE2 GLN    43      -7.853  77.631  39.000  1.00 24.23           N  
ATOM   1055  N   LYS    44      -4.119  74.119  43.152  1.00 23.49           N  
ATOM   1056  CA  LYS    44      -2.798  73.504  43.293  1.00 22.94           C  
ATOM   1057  C   LYS    44      -2.885  72.010  43.618  1.00 23.73           C  
ATOM   1058  O   LYS    44      -2.073  71.231  43.139  1.00 23.97           O  
ATOM   1059  CB  LYS    44      -1.964  74.236  44.353  1.00 26.12           C  
ATOM   1060  CG  LYS    44      -1.383  75.517  43.796  1.00 37.14           C  
ATOM   1061  CD  LYS    44      -0.199  75.250  42.854  1.00 40.63           C  
ATOM   1062  CE  LYS    44       0.270  76.569  42.238  1.00 46.64           C  
ATOM   1063  NZ  LYS    44       1.409  76.414  41.283  1.00 41.05           N  
ATOM   1064  N   LEU    45      -3.875  71.626  44.416  1.00 22.77           N  
ATOM   1065  CA  LEU    45      -4.158  70.192  44.683  1.00 22.94           C  
ATOM   1066  C   LEU    45      -4.528  69.448  43.403  1.00 20.00           C  
ATOM   1067  O   LEU    45      -4.064  68.333  43.149  1.00 21.82           O  
ATOM   1068  CB  LEU    45      -5.255  70.034  45.759  1.00 24.89           C  
ATOM   1069  CG  LEU    45      -4.872  70.484  47.179  1.00 24.96           C  
ATOM   1070  CD1 LEU    45      -6.093  70.532  48.099  1.00 25.24           C  
ATOM   1071  CD2 LEU    45      -3.795  69.570  47.786  1.00 26.64           C  
ATOM   1072  N   ILE    46      -5.331  70.092  42.557  1.00 20.74           N  
ATOM   1073  CA  ILE    46      -5.651  69.564  41.249  1.00 21.62           C  
ATOM   1074  C   ILE    46      -4.391  69.407  40.390  1.00 20.78           C  
ATOM   1075  O   ILE    46      -4.202  68.383  39.737  1.00 21.91           O  
ATOM   1076  CB  ILE    46      -6.704  70.453  40.547  1.00 22.08           C  
ATOM   1077  CG1 ILE    46      -8.055  70.378  41.275  1.00 24.84           C  
ATOM   1078  CG2 ILE    46      -6.892  70.056  39.052  1.00 22.38           C  
ATOM   1079  CD1 ILE    46      -9.010  71.552  40.931  1.00 22.86           C  
ATOM   1080  N   ALA    47      -3.523  70.426  40.416  1.00 21.87           N  
ATOM   1081  CA  ALA    47      -2.279  70.384  39.643  1.00 21.24           C  
ATOM   1082  C   ALA    47      -1.416  69.194  40.090  1.00 21.15           C  
ATOM   1083  O   ALA    47      -0.852  68.486  39.264  1.00 23.10           O  
ATOM   1084  CB  ALA    47      -1.507  71.727  39.768  1.00 21.67           C  
ATOM   1085  N   ILE    48      -1.326  68.971  41.401  1.00 23.22           N  
ATOM   1086  CA  ILE    48      -0.581  67.815  41.934  1.00 23.42           C  
ATOM   1087  C   ILE    48      -1.151  66.535  41.379  1.00 22.45           C  
ATOM   1088  O   ILE    48      -0.412  65.683  40.917  1.00 22.38           O  
ATOM   1089  CB  ILE    48      -0.565  67.783  43.480  1.00 22.22           C  
ATOM   1090  CG1 ILE    48       0.257  68.942  44.048  1.00 26.05           C  
ATOM   1091  CG2 ILE    48       0.049  66.452  44.023  1.00 25.18           C  
ATOM   1092  CD1 ILE    48      -0.059  69.242  45.504  1.00 25.14           C  
ATOM   1093  N   GLY    49      -2.485  66.395  41.436  1.00 23.64           N  
ATOM   1094  CA  GLY    49      -3.152  65.223  40.890  1.00 22.69           C  
ATOM   1095  C   GLY    49      -2.810  64.948  39.439  1.00 22.13           C  
ATOM   1096  O   GLY    49      -2.514  63.817  39.044  1.00 22.25           O  
ATOM   1097  N   ILE    50      -2.858  65.995  38.620  1.00 21.97           N  
ATOM   1098  CA  ILE    50      -2.611  65.842  37.209  1.00 23.22           C  
ATOM   1099  C   ILE    50      -1.179  65.410  36.958  1.00 20.30           C  
ATOM   1100  O   ILE    50      -0.936  64.483  36.198  1.00 22.58           O  
ATOM   1101  CB  ILE    50      -2.928  67.132  36.415  1.00 23.33           C  
ATOM   1102  CG1 ILE    50      -4.446  67.402  36.425  1.00 25.36           C  
ATOM   1103  CG2 ILE    50      -2.410  67.043  34.958  1.00 25.70           C  
ATOM   1104  CD1 ILE    50      -4.873  68.780  35.946  1.00 23.40           C  
ATOM   1105  N   VAL    51      -0.226  66.112  37.554  1.00 22.13           N  
ATOM   1106  CA  VAL    51       1.198  65.805  37.361  0.50 22.96           C  
ATOM   1108  C   VAL    51       1.534  64.410  37.901  1.00 22.59           C  
ATOM   1109  O   VAL    51       2.294  63.639  37.290  1.00 23.85           O  
ATOM   1110  CB  VAL    51       2.072  66.864  38.052  0.50 23.96           C  
ATOM   1112  CG1 VAL    51       3.558  66.521  37.912  0.50 22.52           C  
ATOM   1114  CG2 VAL    51       1.793  68.268  37.453  0.50 24.56           C  
ATOM   1116  N   ALA    52       0.940  64.069  39.051  1.00 21.97           N  
ATOM   1117  CA  ALA    52       1.198  62.761  39.646  1.00 22.83           C  
ATOM   1118  C   ALA    52       0.615  61.626  38.821  1.00 24.96           C  
ATOM   1119  O   ALA    52       1.057  60.489  38.972  1.00 27.05           O  
ATOM   1120  CB  ALA    52       0.708  62.681  41.110  1.00 22.19           C  
ATOM   1121  N   SER    53      -0.366  61.908  37.962  1.00 23.44           N  
ATOM   1122  CA  SER    53      -0.993  60.900  37.128  0.50 24.03           C  
ATOM   1124  C   SER    53      -0.070  60.482  35.984  1.00 28.22           C  
ATOM   1125  O   SER    53      -0.306  59.463  35.352  1.00 29.44           O  
ATOM   1126  CB  SER    53      -2.358  61.369  36.590  0.50 24.46           C  
ATOM   1128  OG  SER    53      -2.273  62.367  35.572  0.50 17.33           O  
ATOM   1130  N   ARG    54       0.967  61.288  35.750  1.00 27.88           N  
ATOM   1131  CA  ARG    54       1.961  61.079  34.686  1.00 36.49           C  
ATOM   1132  C   ARG    54       3.323  60.666  35.269  1.00 42.51           C  
ATOM   1133  O   ARG    54       3.434  60.416  36.472  1.00 42.98           O  
ATOM   1134  CB  ARG    54       2.061  62.360  33.864  1.00 36.62           C  
ATOM   1135  CG  ARG    54       0.682  62.788  33.371  1.00 36.07           C  
ATOM   1136  CD  ARG    54       0.720  63.747  32.220  1.00 46.03           C  
ATOM   1137  NE  ARG    54       1.186  65.048  32.671  1.00 47.58           N  
ATOM   1138  CZ  ARG    54       0.593  66.218  32.427  1.00 48.31           C  
ATOM   1139  NH1 ARG    54      -0.539  66.301  31.716  1.00 41.50           N  
ATOM   1140  NH2 ARG    54       1.152  67.314  32.919  1.00 45.55           N  
ATOM   1141  N   CYS    55       4.364  60.567  34.441  1.00 47.81           N  
ATOM   1142  CA  CYS    55       5.609  59.917  34.908  1.00 53.06           C  
ATOM   1143  C   CYS    55       6.714  60.870  35.342  1.00 53.53           C  
ATOM   1144  O   CYS    55       7.760  60.423  35.818  1.00 55.63           O  
ATOM   1145  CB  CYS    55       6.175  58.963  33.844  1.00 54.41           C  
ATOM   1146  SG  CYS    55       4.966  57.829  33.125  1.00 70.70           S  
ATOM   1147  N   ASP    56       6.510  62.170  35.183  1.00 51.11           N  
ATOM   1148  CA  ASP    56       7.593  63.097  35.442  1.00 50.75           C  
ATOM   1149  C   ASP    56       7.796  63.237  36.966  1.00 47.60           C  
ATOM   1150  O   ASP    56       7.187  64.093  37.608  1.00 47.73           O  
ATOM   1151  CB  ASP    56       7.335  64.451  34.744  1.00 51.45           C  
ATOM   1152  CG  ASP    56       8.549  65.360  34.751  1.00 55.00           C  
ATOM   1153  OD1 ASP    56       9.598  64.950  35.298  1.00 59.75           O  
ATOM   1154  OD2 ASP    56       8.445  66.490  34.211  1.00 56.95           O  
ATOM   1155  N   GLU    57       8.662  62.376  37.505  1.00 44.76           N  
ATOM   1156  CA  GLU    57       9.079  62.384  38.919  1.00 44.68           C  
ATOM   1157  C   GLU    57       9.555  63.747  39.434  1.00 43.54           C  
ATOM   1158  O   GLU    57       9.225  64.151  40.554  1.00 39.20           O  
ATOM   1159  CB  GLU    57      10.193  61.362  39.121  1.00 44.24           C  
ATOM   1160  CG  GLU    57      10.658  61.181  40.556  1.00 49.33           C  
ATOM   1161  N   VAL    58      10.342  64.453  38.623  1.00 44.25           N  
ATOM   1162  CA  VAL    58      10.846  65.761  39.019  1.00 41.66           C  
ATOM   1163  C   VAL    58       9.712  66.771  39.079  1.00 39.99           C  
ATOM   1164  O   VAL    58       9.637  67.563  40.023  1.00 40.88           O  
ATOM   1165  CB  VAL    58      12.003  66.255  38.076  1.00 44.98           C  
ATOM   1166  N   ALA    59       8.820  66.732  38.092  1.00 36.00           N  
ATOM   1167  CA  ALA    59       7.624  67.563  38.085  1.00 36.40           C  
ATOM   1168  C   ALA    59       6.746  67.291  39.314  1.00 34.21           C  
ATOM   1169  O   ALA    59       6.208  68.222  39.935  1.00 33.66           O  
ATOM   1170  CB  ALA    59       6.840  67.324  36.816  1.00 37.99           C  
ATOM   1171  N   ILE    60       6.614  66.013  39.667  1.00 31.22           N  
ATOM   1172  CA  ILE    60       5.812  65.647  40.839  1.00 28.82           C  
ATOM   1173  C   ILE    60       6.454  66.198  42.119  1.00 27.71           C  
ATOM   1174  O   ILE    60       5.781  66.867  42.913  1.00 27.90           O  
ATOM   1175  CB  ILE    60       5.613  64.129  40.959  1.00 27.95           C  
ATOM   1176  CG1 ILE    60       4.862  63.584  39.742  1.00 27.51           C  
ATOM   1177  CG2 ILE    60       4.812  63.808  42.224  1.00 26.18           C  
ATOM   1178  CD1 ILE    60       4.987  62.071  39.545  1.00 25.07           C  
ATOM   1179  N   GLU    61       7.741  65.915  42.319  1.00 30.04           N  
ATOM   1180  CA  GLU    61       8.460  66.430  43.501  1.00 32.80           C  
ATOM   1181  C   GLU    61       8.345  67.964  43.626  1.00 35.05           C  
ATOM   1182  O   GLU    61       8.090  68.492  44.715  1.00 33.59           O  
ATOM   1183  CB  GLU    61       9.925  65.988  43.468  1.00 33.45           C  
ATOM   1184  CG  GLU    61      10.720  66.333  44.743  1.00 36.55           C  
ATOM   1185  N   LYS    62       8.492  68.665  42.503  1.00 38.76           N  
ATOM   1186  CA  LYS    62       8.430  70.135  42.479  1.00 39.30           C  
ATOM   1187  C   LYS    62       7.040  70.681  42.772  1.00 38.68           C  
ATOM   1188  O   LYS    62       6.906  71.655  43.526  1.00 36.68           O  
ATOM   1189  CB  LYS    62       8.919  70.670  41.123  1.00 42.11           C  
ATOM   1190  N   GLN    63       5.995  70.076  42.198  1.00 35.90           N  
ATOM   1191  CA  GLN    63       4.635  70.517  42.512  1.00 36.26           C  
ATOM   1192  C   GLN    63       4.355  70.313  43.989  1.00 33.33           C  
ATOM   1193  O   GLN    63       3.755  71.165  44.626  1.00 33.91           O  
ATOM   1194  CB  GLN    63       3.548  69.798  41.676  1.00 39.20           C  
ATOM   1195  CG  GLN    63       3.160  70.466  40.335  1.00 44.45           C  
ATOM   1196  CD  GLN    63       2.333  71.749  40.478  1.00 44.95           C  
ATOM   1197  OE1 GLN    63       1.712  72.008  41.510  1.00 62.12           O  
ATOM   1198  NE2 GLN    63       2.315  72.547  39.425  1.00 63.66           N  
ATOM   1199  N   MET    64       4.752  69.161  44.531  1.00 30.47           N  
ATOM   1200  CA  MET    64       4.471  68.856  45.916  1.00 26.68           C  
ATOM   1201  C   MET    64       5.225  69.810  46.838  1.00 29.86           C  
ATOM   1202  O   MET    64       4.645  70.361  47.788  1.00 28.23           O  
ATOM   1203  CB  MET    64       4.864  67.412  46.233  1.00 23.18           C  
ATOM   1204  CG  MET    64       3.918  66.370  45.589  1.00 22.57           C  
ATOM   1205  SD  MET    64       4.418  64.644  46.195  0.75 22.23          SE  
ATOM   1206  CE  MET    64       3.056  63.632  45.253  1.00 22.00           C  
ATOM   1207  N   LYS    65       6.514  69.998  46.544  1.00 32.32           N  
ATOM   1208  CA  LYS    65       7.386  70.856  47.371  1.00 34.88           C  
ATOM   1209  C   LYS    65       6.857  72.284  47.412  1.00 34.19           C  
ATOM   1210  O   LYS    65       6.702  72.863  48.483  1.00 35.31           O  
ATOM   1211  CB  LYS    65       8.826  70.843  46.843  1.00 35.46           C  
ATOM   1212  CG  LYS    65       9.625  69.629  47.243  1.00 40.38           C  
ATOM   1213  N   SER    66       6.564  72.836  46.245  1.00 36.71           N  
ATOM   1214  CA  SER    66       6.041  74.200  46.142  0.50 37.97           C  
ATOM   1216  C   SER    66       4.709  74.361  46.864  1.00 39.15           C  
ATOM   1217  O   SER    66       4.486  75.342  47.552  1.00 40.37           O  
ATOM   1218  CB  SER    66       5.895  74.618  44.676  0.50 38.61           C  
ATOM   1220  OG  SER    66       5.090  73.703  43.950  0.50 37.08           O  
ATOM   1222  N   ALA    67       3.815  73.392  46.707  1.00 37.33           N  
ATOM   1223  CA  ALA    67       2.536  73.447  47.409  1.00 35.90           C  
ATOM   1224  C   ALA    67       2.708  73.505  48.921  1.00 33.63           C  
ATOM   1225  O   ALA    67       2.000  74.242  49.614  1.00 33.38           O  
ATOM   1226  CB  ALA    67       1.675  72.239  47.036  1.00 35.08           C  
ATOM   1227  N   MET    68       3.620  72.690  49.440  1.00 32.12           N  
ATOM   1228  CA  MET    68       3.809  72.592  50.861  1.00 32.59           C  
ATOM   1229  C   MET    68       4.455  73.891  51.335  1.00 33.83           C  
ATOM   1230  O   MET    68       4.036  74.457  52.332  1.00 35.23           O  
ATOM   1231  CB  MET    68       4.684  71.396  51.205  1.00 33.38           C  
ATOM   1232  CG  MET    68       4.027  70.041  50.923  1.00 33.32           C  
ATOM   1233  SD  MET    68       5.192  68.597  51.472  0.75 34.95          SE  
ATOM   1234  CE  MET    68       4.864  68.765  53.369  1.00 39.85           C  
ATOM   1235  N   LYS    69       5.428  74.370  50.567  1.00 35.03           N  
ATOM   1236  CA  LYS    69       6.210  75.565  50.936  1.00 37.33           C  
ATOM   1237  C   LYS    69       5.376  76.830  50.796  1.00 38.14           C  
ATOM   1238  O   LYS    69       5.218  77.585  51.764  1.00 42.29           O  
ATOM   1239  CB  LYS    69       7.470  75.676  50.075  1.00 36.02           C  
ATOM   1240  N   GLU    70       4.833  77.048  49.606  1.00 39.17           N  
ATOM   1241  CA  GLU    70       4.066  78.262  49.302  1.00 40.19           C  
ATOM   1242  C   GLU    70       2.697  78.317  49.975  1.00 40.34           C  
ATOM   1243  O   GLU    70       2.343  79.342  50.543  1.00 42.02           O  
ATOM   1244  CB  GLU    70       3.909  78.452  47.786  1.00 39.25           C  
ATOM   1245  N   LEU    71       1.936  77.226  49.937  1.00 39.71           N  
ATOM   1246  CA  LEU    71       0.552  77.239  50.424  1.00 38.07           C  
ATOM   1247  C   LEU    71       0.339  76.549  51.771  1.00 34.95           C  
ATOM   1248  O   LEU    71      -0.765  76.565  52.307  1.00 37.25           O  
ATOM   1249  CB  LEU    71      -0.380  76.601  49.371  1.00 39.04           C  
ATOM   1250  CG  LEU    71      -0.453  77.252  47.981  1.00 43.95           C  
ATOM   1251  CD1 LEU    71       0.756  76.880  47.115  1.00 50.69           C  
ATOM   1252  CD2 LEU    71      -1.736  76.876  47.251  1.00 39.57           C  
ATOM   1253  N   GLY    72       1.355  75.907  52.325  1.00 31.62           N  
ATOM   1254  CA  GLY    72       1.147  75.169  53.571  1.00 31.33           C  
ATOM   1255  C   GLY    72       0.288  73.914  53.427  1.00 30.39           C  
ATOM   1256  O   GLY    72      -0.302  73.424  54.405  1.00 31.58           O  
ATOM   1257  N   ILE    73       0.217  73.377  52.213  1.00 32.06           N  
ATOM   1258  CA  ILE    73      -0.496  72.104  51.983  1.00 28.57           C  
ATOM   1259  C   ILE    73       0.221  70.989  52.779  1.00 29.16           C  
ATOM   1260  O   ILE    73       1.450  70.986  52.850  1.00 29.32           O  
ATOM   1261  CB  ILE    73      -0.621  71.840  50.468  1.00 30.50           C  
ATOM   1262  CG1 ILE    73      -1.744  72.732  49.891  1.00 27.84           C  
ATOM   1263  CG2 ILE    73      -0.867  70.336  50.174  1.00 25.19           C  
ATOM   1264  CD1 ILE    73      -1.816  72.820  48.371  1.00 30.38           C  
ATOM   1265  N   THR    74      -0.530  70.088  53.420  1.00 27.36           N  
ATOM   1266  CA  THR    74       0.088  69.024  54.242  1.00 27.26           C  
ATOM   1267  C   THR    74       0.356  67.745  53.462  1.00 27.58           C  
ATOM   1268  O   THR    74      -0.238  67.522  52.416  1.00 24.17           O  
ATOM   1269  CB  THR    74      -0.757  68.627  55.460  1.00 29.19           C  
ATOM   1270  OG1 THR    74      -2.004  68.099  55.031  1.00 28.81           O  
ATOM   1271  CG2 THR    74      -0.971  69.880  56.480  1.00 28.98           C  
ATOM   1272  N   LYS    75       1.211  66.876  53.997  1.00 26.69           N  
ATOM   1273  CA  LYS    75       1.408  65.575  53.357  1.00 24.94           C  
ATOM   1274  C   LYS    75       0.105  64.766  53.394  1.00 24.97           C  
ATOM   1275  O   LYS    75      -0.183  64.049  52.430  1.00 24.26           O  
ATOM   1276  CB  LYS    75       2.547  64.787  54.001  1.00 25.92           C  
ATOM   1277  CG  LYS    75       3.941  65.377  53.781  1.00 25.04           C  
ATOM   1278  CD  LYS    75       5.016  64.369  54.207  1.00 27.40           C  
ATOM   1279  CE  LYS    75       6.395  64.744  53.675  1.00 30.74           C  
ATOM   1280  NZ  LYS    75       7.337  63.582  53.770  1.00 29.47           N  
ATOM   1281  N   GLU    76      -0.705  64.923  54.456  1.00 23.62           N  
ATOM   1282  CA  GLU    76      -2.006  64.250  54.537  1.00 27.19           C  
ATOM   1283  C   GLU    76      -2.963  64.703  53.418  1.00 22.94           C  
ATOM   1284  O   GLU    76      -3.670  63.897  52.828  1.00 25.59           O  
ATOM   1285  CB  GLU    76      -2.676  64.495  55.897  1.00 28.02           C  
ATOM   1286  CG  GLU    76      -3.944  63.646  56.101  1.00 35.01           C  
ATOM   1287  CD  GLU    76      -4.602  63.869  57.467  1.00 37.01           C  
ATOM   1288  OE1 GLU    76      -4.541  65.017  57.990  1.00 52.64           O  
ATOM   1289  OE2 GLU    76      -5.167  62.883  58.002  1.00 48.87           O  
ATOM   1290  N   GLU    77      -2.974  65.994  53.116  1.00 24.57           N  
ATOM   1291  CA  GLU    77      -3.774  66.494  52.000  1.00 24.63           C  
ATOM   1292  C   GLU    77      -3.272  65.945  50.656  1.00 24.30           C  
ATOM   1293  O   GLU    77      -4.068  65.546  49.803  1.00 23.45           O  
ATOM   1294  CB  GLU    77      -3.785  68.017  51.965  1.00 25.09           C  
ATOM   1295  CG  GLU    77      -4.555  68.632  53.117  1.00 28.85           C  
ATOM   1296  CD  GLU    77      -4.410  70.153  53.229  1.00 30.84           C  
ATOM   1297  OE1 GLU    77      -3.353  70.735  52.878  1.00 33.27           O  
ATOM   1298  OE2 GLU    77      -5.388  70.777  53.674  1.00 33.37           O  
ATOM   1299  N   ILE    78      -1.955  65.938  50.475  1.00 24.49           N  
ATOM   1300  CA  ILE    78      -1.378  65.340  49.262  1.00 23.04           C  
ATOM   1301  C   ILE    78      -1.725  63.851  49.134  1.00 21.63           C  
ATOM   1302  O   ILE    78      -2.100  63.380  48.059  1.00 21.32           O  
ATOM   1303  CB  ILE    78       0.162  65.600  49.123  1.00 22.33           C  
ATOM   1304  CG1 ILE    78       0.452  67.103  49.059  1.00 25.20           C  
ATOM   1305  CG2 ILE    78       0.697  64.957  47.836  1.00 21.31           C  
ATOM   1306  CD1 ILE    78       1.911  67.437  49.205  1.00 24.12           C  
ATOM   1307  N   ALA    79      -1.679  63.116  50.236  1.00 22.41           N  
ATOM   1308  CA  ALA    79      -2.026  61.718  50.200  1.00 20.30           C  
ATOM   1309  C   ALA    79      -3.467  61.520  49.727  1.00 21.42           C  
ATOM   1310  O   ALA    79      -3.749  60.611  48.966  1.00 20.43           O  
ATOM   1311  CB  ALA    79      -1.797  61.071  51.552  1.00 22.66           C  
ATOM   1312  N   ASP    80      -4.374  62.409  50.130  1.00 20.93           N  
ATOM   1313  CA  ASP    80      -5.762  62.331  49.652  1.00 20.26           C  
ATOM   1314  C   ASP    80      -5.885  62.593  48.155  1.00 22.81           C  
ATOM   1315  O   ASP    80      -6.734  62.009  47.494  1.00 22.27           O  
ATOM   1316  CB  ASP    80      -6.667  63.310  50.395  1.00 20.14           C  
ATOM   1317  CG  ASP    80      -7.045  62.853  51.807  1.00 23.19           C  
ATOM   1318  OD1 ASP    80      -6.928  61.652  52.156  1.00 25.42           O  
ATOM   1319  OD2 ASP    80      -7.525  63.728  52.549  1.00 28.27           O  
ATOM   1320  N   VAL    81      -5.043  63.483  47.619  1.00 21.25           N  
ATOM   1321  CA  VAL    81      -4.939  63.659  46.181  1.00 22.27           C  
ATOM   1322  C   VAL    81      -4.492  62.341  45.520  1.00 20.03           C  
ATOM   1323  O   VAL    81      -5.078  61.898  44.508  1.00 19.50           O  
ATOM   1324  CB  VAL    81      -3.963  64.805  45.817  1.00 20.90           C  
ATOM   1325  CG1 VAL    81      -3.757  64.895  44.302  1.00 22.88           C  
ATOM   1326  CG2 VAL    81      -4.425  66.168  46.443  1.00 20.83           C  
ATOM   1327  N   LEU    82      -3.519  61.673  46.131  1.00 20.16           N  
ATOM   1328  CA  LEU    82      -2.954  60.455  45.560  1.00 19.84           C  
ATOM   1329  C   LEU    82      -3.955  59.291  45.560  1.00 18.54           C  
ATOM   1330  O   LEU    82      -3.913  58.425  44.676  1.00 19.11           O  
ATOM   1331  CB  LEU    82      -1.666  60.090  46.263  1.00 20.98           C  
ATOM   1332  CG  LEU    82      -0.551  61.135  46.146  1.00 20.66           C  
ATOM   1333  CD1 LEU    82       0.766  60.558  46.671  1.00 21.28           C  
ATOM   1334  CD2 LEU    82      -0.392  61.639  44.674  1.00 22.33           C  
ATOM   1335  N   ARG    83      -4.911  59.309  46.495  1.00 20.31           N  
ATOM   1336  CA  ARG    83      -5.991  58.304  46.463  1.00 21.39           C  
ATOM   1337  C   ARG    83      -6.744  58.386  45.139  1.00 20.18           C  
ATOM   1338  O   ARG    83      -7.025  57.394  44.468  1.00 19.30           O  
ATOM   1339  CB  ARG    83      -6.940  58.521  47.643  1.00 22.29           C  
ATOM   1340  CG  ARG    83      -6.321  58.269  48.999  1.00 22.30           C  
ATOM   1341  CD  ARG    83      -7.215  58.747  50.124  1.00 28.97           C  
ATOM   1342  NE  ARG    83      -8.051  57.695  50.628  1.00 33.52           N  
ATOM   1343  CZ  ARG    83      -7.790  56.938  51.696  1.00 23.68           C  
ATOM   1344  NH1 ARG    83      -6.703  57.064  52.438  1.00 32.40           N  
ATOM   1345  NH2 ARG    83      -8.646  56.031  52.018  1.00 24.82           N  
ATOM   1346  N   VAL    84      -7.007  59.612  44.712  1.00 19.60           N  
ATOM   1347  CA  VAL    84      -7.659  59.856  43.423  1.00 20.32           C  
ATOM   1348  C   VAL    84      -6.772  59.472  42.241  1.00 20.03           C  
ATOM   1349  O   VAL    84      -7.255  58.901  41.275  1.00 20.48           O  
ATOM   1350  CB  VAL    84      -8.137  61.322  43.296  1.00 21.39           C  
ATOM   1351  CG1 VAL    84      -8.987  61.511  41.998  1.00 22.27           C  
ATOM   1352  CG2 VAL    84      -8.967  61.726  44.539  1.00 22.62           C  
ATOM   1353  N   VAL    85      -5.467  59.765  42.311  1.00 19.59           N  
ATOM   1354  CA  VAL    85      -4.526  59.262  41.308  1.00 19.33           C  
ATOM   1355  C   VAL    85      -4.607  57.748  41.150  1.00 19.40           C  
ATOM   1356  O   VAL    85      -4.616  57.261  40.035  1.00 20.61           O  
ATOM   1357  CB  VAL    85      -3.073  59.710  41.615  1.00 19.39           C  
ATOM   1358  CG1 VAL    85      -2.070  59.082  40.659  1.00 17.94           C  
ATOM   1359  CG2 VAL    85      -2.997  61.250  41.539  1.00 21.42           C  
ATOM   1360  N   LEU    86      -4.650  56.998  42.252  1.00 19.33           N  
ATOM   1361  CA  LEU    86      -4.777  55.548  42.161  1.00 19.79           C  
ATOM   1362  C   LEU    86      -6.014  55.159  41.363  1.00 18.98           C  
ATOM   1363  O   LEU    86      -5.940  54.357  40.454  1.00 20.03           O  
ATOM   1364  CB  LEU    86      -4.858  54.924  43.555  1.00 21.20           C  
ATOM   1365  CG  LEU    86      -5.184  53.439  43.651  1.00 21.99           C  
ATOM   1366  CD1 LEU    86      -4.133  52.600  42.959  1.00 24.06           C  
ATOM   1367  CD2 LEU    86      -5.310  53.065  45.156  1.00 20.62           C  
ATOM   1368  N   LEU    87      -7.154  55.734  41.711  1.00 20.94           N  
ATOM   1369  CA  LEU    87      -8.412  55.347  41.065  1.00 21.06           C  
ATOM   1370  C   LEU    87      -8.447  55.701  39.591  1.00 21.01           C  
ATOM   1371  O   LEU    87      -8.981  54.948  38.793  1.00 22.38           O  
ATOM   1372  CB  LEU    87      -9.577  56.046  41.769  1.00 23.55           C  
ATOM   1373  CG  LEU    87     -10.992  55.596  41.405  1.00 25.01           C  
ATOM   1374  CD1 LEU    87     -11.291  54.169  41.742  1.00 30.38           C  
ATOM   1375  CD2 LEU    87     -11.944  56.517  42.180  1.00 27.84           C  
ATOM   1376  N   THR    88      -7.906  56.874  39.258  1.00 21.25           N  
ATOM   1377  CA  THR    88      -7.927  57.375  37.879  1.00 21.88           C  
ATOM   1378  C   THR    88      -6.816  56.833  36.983  1.00 22.77           C  
ATOM   1379  O   THR    88      -6.931  56.837  35.762  1.00 23.28           O  
ATOM   1380  CB  THR    88      -7.874  58.903  37.853  1.00 21.84           C  
ATOM   1381  OG1 THR    88      -6.644  59.350  38.431  1.00 22.90           O  
ATOM   1382  CG2 THR    88      -9.066  59.477  38.541  1.00 25.52           C  
ATOM   1383  N   SER    89      -5.735  56.386  37.602  1.00 20.63           N  
ATOM   1384  CA  SER    89      -4.483  56.227  36.896  1.00 21.58           C  
ATOM   1385  C   SER    89      -3.720  54.942  37.169  1.00 21.03           C  
ATOM   1386  O   SER    89      -2.772  54.629  36.425  1.00 23.05           O  
ATOM   1387  CB  SER    89      -3.575  57.459  37.151  1.00 25.09           C  
ATOM   1388  OG  SER    89      -4.281  58.671  36.880  1.00 24.41           O  
ATOM   1389  N   GLY    90      -4.063  54.215  38.234  1.00 21.98           N  
ATOM   1390  CA  GLY    90      -3.467  52.905  38.482  1.00 20.22           C  
ATOM   1391  C   GLY    90      -2.363  52.897  39.536  1.00 20.13           C  
ATOM   1392  O   GLY    90      -1.942  53.955  40.033  1.00 19.52           O  
ATOM   1393  N   MET    91      -1.913  51.694  39.856  1.00 20.97           N  
ATOM   1394  CA  MET    91      -0.890  51.427  40.886  0.40 24.63           C  
ATOM   1396  C   MET    91       0.459  52.100  40.604  1.00 21.70           C  
ATOM   1397  O   MET    91       1.059  52.724  41.502  1.00 23.86           O  
ATOM   1398  CB  MET    91      -0.619  49.917  41.035  0.40 26.41           C  
ATOM   1400  CG  MET    91      -1.632  49.085  41.765  0.40 29.31           C  
ATOM   1402  SD  MET    91      -0.711  47.905  43.072  0.28 35.75          SE  
ATOM   1404  CE  MET    91      -0.457  49.469  44.218  0.40 21.93           C  
ATOM   1406  N   PRO    92       0.980  51.963  39.373  1.00 21.05           N  
ATOM   1407  CA  PRO    92       2.311  52.563  39.147  1.00 19.88           C  
ATOM   1408  C   PRO    92       2.408  54.050  39.498  1.00 21.02           C  
ATOM   1409  O   PRO    92       3.356  54.485  40.177  1.00 20.96           O  
ATOM   1410  CB  PRO    92       2.572  52.299  37.663  1.00 22.51           C  
ATOM   1411  CG  PRO    92       1.788  51.073  37.374  1.00 20.16           C  
ATOM   1412  CD  PRO    92       0.530  51.210  38.184  1.00 21.39           C  
ATOM   1413  N   ALA    93       1.434  54.836  39.065  1.00 19.14           N  
ATOM   1414  CA  ALA    93       1.460  56.257  39.340  1.00 19.96           C  
ATOM   1415  C   ALA    93       1.300  56.530  40.843  1.00 19.93           C  
ATOM   1416  O   ALA    93       1.977  57.400  41.418  1.00 20.12           O  
ATOM   1417  CB  ALA    93       0.324  56.953  38.551  1.00 22.71           C  
ATOM   1418  N   PHE    94       0.374  55.804  41.457  1.00 18.44           N  
ATOM   1419  CA  PHE    94       0.116  55.937  42.882  1.00 18.79           C  
ATOM   1420  C   PHE    94       1.380  55.638  43.705  1.00 20.05           C  
ATOM   1421  O   PHE    94       1.763  56.426  44.594  1.00 19.06           O  
ATOM   1422  CB  PHE    94      -0.966  54.949  43.301  1.00 20.10           C  
ATOM   1423  CG  PHE    94      -1.232  54.947  44.799  1.00 20.32           C  
ATOM   1424  CD1 PHE    94      -1.802  56.035  45.406  1.00 19.60           C  
ATOM   1425  CD2 PHE    94      -0.904  53.846  45.583  1.00 23.76           C  
ATOM   1426  CE1 PHE    94      -2.066  56.050  46.776  1.00 22.96           C  
ATOM   1427  CE2 PHE    94      -1.154  53.856  46.964  1.00 22.72           C  
ATOM   1428  CZ  PHE    94      -1.722  54.954  47.559  1.00 26.09           C  
ATOM   1429  N   THR    95       2.013  54.508  43.431  1.00 20.55           N  
ATOM   1430  CA  THR    95       3.135  54.077  44.284  1.00 20.94           C  
ATOM   1431  C   THR    95       4.339  55.000  44.073  1.00 20.73           C  
ATOM   1432  O   THR    95       5.018  55.353  45.038  1.00 20.28           O  
ATOM   1433  CB  THR    95       3.494  52.592  44.055  1.00 23.86           C  
ATOM   1434  OG1 THR    95       3.863  52.424  42.701  1.00 24.63           O  
ATOM   1435  CG2 THR    95       2.314  51.685  44.356  1.00 21.43           C  
ATOM   1436  N   LYS    96       4.586  55.442  42.833  1.00 20.08           N  
ATOM   1437  CA  LYS    96       5.679  56.370  42.546  0.50 21.50           C  
ATOM   1439  C   LYS    96       5.460  57.655  43.335  1.00 20.81           C  
ATOM   1440  O   LYS    96       6.378  58.161  43.984  1.00 23.01           O  
ATOM   1441  CB  LYS    96       5.748  56.674  41.040  0.50 23.02           C  
ATOM   1443  CG  LYS    96       6.843  57.658  40.621  0.50 23.87           C  
ATOM   1445  CD  LYS    96       7.014  57.722  39.092  0.50 25.49           C  
ATOM   1447  CE  LYS    96       8.452  58.030  38.704  0.50 32.66           C  
ATOM   1449  NZ  LYS    96       9.333  56.844  38.868  0.50 30.31           N  
ATOM   1451  N   ALA    97       4.244  58.190  43.262  1.00 19.16           N  
ATOM   1452  CA  ALA    97       3.898  59.469  43.921  1.00 19.50           C  
ATOM   1453  C   ALA    97       3.968  59.374  45.441  1.00 20.63           C  
ATOM   1454  O   ALA    97       4.463  60.306  46.135  1.00 20.71           O  
ATOM   1455  CB  ALA    97       2.498  59.945  43.472  1.00 19.41           C  
ATOM   1456  N   MET    98       3.499  58.244  45.974  1.00 19.58           N  
ATOM   1457  CA  MET    98       3.518  58.034  47.406  1.00 20.80           C  
ATOM   1458  C   MET    98       4.949  58.016  47.898  1.00 21.43           C  
ATOM   1459  O   MET    98       5.235  58.574  48.952  1.00 21.18           O  
ATOM   1460  CB  MET    98       2.812  56.740  47.834  1.00 22.05           C  
ATOM   1461  CG  MET    98       1.348  56.831  48.010  1.00 30.57           C  
ATOM   1462  SD  MET    98       0.764  58.016  49.491  0.75 32.27          SE  
ATOM   1463  CE  MET    98       1.937  58.044  50.314  1.00  8.65           C  
ATOM   1464  N   LYS    99       5.840  57.362  47.159  1.00 20.17           N  
ATOM   1465  CA  LYS    99       7.263  57.318  47.526  1.00 20.82           C  
ATOM   1466  C   LYS    99       7.928  58.695  47.534  1.00 21.61           C  
ATOM   1467  O   LYS    99       8.729  59.015  48.429  1.00 22.41           O  
ATOM   1468  CB  LYS    99       8.015  56.361  46.599  1.00 19.98           C  
ATOM   1469  CG  LYS    99       9.522  56.268  46.893  1.00 23.11           C  
ATOM   1470  N   ILE   100       7.602  59.501  46.536  1.00 22.47           N  
ATOM   1471  CA  ILE   100       8.072  60.874  46.456  1.00 23.27           C  
ATOM   1472  C   ILE   100       7.553  61.687  47.656  1.00 24.13           C  
ATOM   1473  O   ILE   100       8.325  62.413  48.299  1.00 23.84           O  
ATOM   1474  CB  ILE   100       7.652  61.544  45.136  1.00 22.91           C  
ATOM   1475  CG1 ILE   100       8.324  60.868  43.926  1.00 22.73           C  
ATOM   1476  CG2 ILE   100       7.973  63.043  45.152  1.00 21.99           C  
ATOM   1477  CD1 ILE   100       7.717  61.279  42.573  1.00 25.00           C  
ATOM   1478  N   LEU   101       6.269  61.540  47.970  1.00 21.64           N  
ATOM   1479  CA  LEU   101       5.660  62.247  49.106  1.00 23.29           C  
ATOM   1480  C   LEU   101       6.347  61.878  50.406  1.00 23.75           C  
ATOM   1481  O   LEU   101       6.624  62.756  51.240  1.00 22.26           O  
ATOM   1482  CB  LEU   101       4.155  61.935  49.207  1.00 22.94           C  
ATOM   1483  CG  LEU   101       3.386  62.589  50.364  1.00 23.09           C  
ATOM   1484  CD1 LEU   101       3.489  64.134  50.332  1.00 23.78           C  
ATOM   1485  CD2 LEU   101       1.946  62.145  50.275  1.00 22.66           C  
ATOM   1486  N   GLU   102       6.611  60.583  50.578  1.00 22.09           N  
ATOM   1487  CA  GLU   102       7.262  60.059  51.770  1.00 27.09           C  
ATOM   1488  C   GLU   102       8.642  60.680  51.965  1.00 25.97           C  
ATOM   1489  O   GLU   102       9.018  61.019  53.083  1.00 27.53           O  
ATOM   1490  CB  GLU   102       7.399  58.543  51.675  1.00 27.36           C  
ATOM   1491  CG  GLU   102       6.073  57.805  51.782  1.00 34.71           C  
ATOM   1492  CD  GLU   102       6.120  56.363  51.242  1.00 36.54           C  
ATOM   1493  OE1 GLU   102       7.234  55.820  51.027  1.00 45.78           O  
ATOM   1494  OE2 GLU   102       5.022  55.775  51.058  1.00 44.93           O  
ATOM   1495  N   LYS   103       9.388  60.834  50.880  1.00 25.11           N  
ATOM   1496  CA  LYS   103      10.773  61.333  50.951  1.00 28.56           C  
ATOM   1497  C   LYS   103      10.847  62.862  51.111  1.00 31.51           C  
ATOM   1498  O   LYS   103      11.911  63.419  51.414  1.00 33.51           O  
ATOM   1499  CB  LYS   103      11.571  60.887  49.714  1.00 29.59           C  
ATOM   1500  CG  LYS   103      11.820  59.386  49.621  1.00 32.01           C  
ATOM   1501  N   LEU   104       9.727  63.543  50.933  1.00 31.51           N  
ATOM   1502  CA  LEU   104       9.711  64.997  51.021  1.00 35.23           C  
ATOM   1503  C   LEU   104       9.855  65.493  52.451  1.00 36.78           C  
ATOM   1504  O   LEU   104       9.406  64.849  53.400  1.00 36.92           O  
ATOM   1505  CB  LEU   104       8.441  65.570  50.389  1.00 34.06           C  
ATOM   1506  CG  LEU   104       8.572  65.835  48.898  1.00 34.04           C  
ATOM   1507  CD1 LEU   104       7.311  66.503  48.411  1.00 34.11           C  
ATOM   1508  CD2 LEU   104       9.796  66.702  48.620  1.00 38.61           C  
ATOM   1509  OXT LEU   104      10.441  66.563  52.661  1.00 40.57           O  
END
