
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  111 (  878),  selected  111 , name 1p8c_A
# Molecule2: number of CA atoms   98 (  717),  selected   98 , name T0408.pdb
# PARAMETERS: 1p8c_A.T0408.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      F       7           -
LGA    R    10_A      G       8          4.086
LGA    R    11_A      E       9          3.744
LGA    E    12_A      G      10           #
LGA    L    13_A      -       -           -
LGA    N    14_A      M      11          2.074
LGA    E    15_A      K      12          2.000
LGA    K    16_A      V      13          2.129
LGA    V    17_A      V      14          1.916
LGA    L    18_A      K      15          2.436
LGA    S    19_A      E      16          1.864
LGA    R    20_A      K      17          1.021
LGA    G    21_A      Y      18          2.123
LGA    T    22_A      P      19           #
LGA    L    23_A      D      20          3.085
LGA    N    24_A      L      21          3.495
LGA    T    25_A      Y      22          4.860
LGA    K    26_A      D      23          3.768
LGA    R    27_A      I      24          1.546
LGA    F    28_A      I      25          2.879
LGA    F    29_A      V      26          4.286
LGA    N    30_A      K      27          3.287
LGA    L    31_A      L      28          1.439
LGA    D    32_A      N      29          2.921
LGA    S    33_A      D      30          4.155
LGA    A    34_A      T      31          3.388
LGA    V    35_A      V      32          1.397
LGA    Y    36_A      F      33          2.254
LGA    R    37_A      T      34          3.909
LGA    P    38_A      G      35          5.354
LGA    G    39_A      K      36          4.125
LGA    K    40_A      T      37          1.289
LGA    L    41_A      L      38          0.860
LGA    D    42_A      D      39          1.039
LGA    V    43_A      Y      40          1.530
LGA    K    44_A      K      41          1.319
LGA    T    45_A      T      42          0.707
LGA    K    46_A      Q      43          0.971
LGA    E    47_A      K      44          0.802
LGA    L    48_A      L      45          0.483
LGA    M    49_A      I      46          0.608
LGA    G    50_A      A      47          0.698
LGA    L    51_A      I      48          0.358
LGA    V    52_A      G      49          0.493
LGA    A    53_A      I      50          0.748
LGA    S    54_A      V      51          0.639
LGA    T    55_A      A      52          0.602
LGA    V    56_A      S      53          0.826
LGA    L    57_A      R      54          2.192
LGA    R    58_A      C      55          2.623
LGA    C    59_A      D      56          2.234
LGA    D    60_A      E      57          2.401
LGA    D    61_A      V      58          2.884
LGA    C    62_A      A      59          2.593
LGA    I    63_A      I      60          1.900
LGA    R    64_A      E      61          2.166
LGA    Y    65_A      K      62          2.547
LGA    H    66_A      Q      63          2.118
LGA    L    67_A      M      64          1.351
LGA    V    68_A      K      65          2.522
LGA    R    69_A      S      66          3.400
LGA    C    70_A      A      67          2.814
LGA    V    71_A      M      68          1.941
LGA    Q    72_A      K      69          3.399
LGA    -       -      E      70           -
LGA    E    73_A      L      71          1.705
LGA    G    74_A      G      72          3.387
LGA    A    75_A      I      73          2.801
LGA    S    76_A      T      74          2.681
LGA    D    77_A      K      75          2.556
LGA    E    78_A      E      76          2.468
LGA    E    79_A      E      77          2.085
LGA    I    80_A      I      78          1.615
LGA    F    81_A      A      79          1.090
LGA    E    82_A      D      80          1.105
LGA    A    83_A      V      81          0.798
LGA    L    84_A      L      82          0.963
LGA    D    85_A      R      83          0.996
LGA    I    86_A      V      84          0.430
LGA    A    87_A      V      85          1.159
LGA    L    88_A      L      86          1.928
LGA    V    89_A      L      87          1.823
LGA    V    90_A      T      88          0.793
LGA    G    91_A      S      89          1.543
LGA    G    92_A      G      90          1.482
LGA    S    93_A      M      91          2.237
LGA    I    94_A      P      92          2.653
LGA    V    95_A      A      93          0.863
LGA    I    96_A      F      94          3.637
LGA    P    97_A      T      95          4.742
LGA    H    98_A      K      96          2.639
LGA    L    99_A      A      97          1.320
LGA    R   100_A      M      98          3.620
LGA    R   101_A      K      99          3.614
LGA    A   102_A      I     100          2.327
LGA    V   103_A      L     101          1.752
LGA    G   104_A      E     102          2.434
LGA    -       -      K     103           -
LGA    F   105_A      L     104          1.755
LGA    L   106_A      -       -           -
LGA    E   107_A      -       -           -
LGA    E   108_A      -       -           -
LGA    L   109_A      -       -           -
LGA    R   110_A      -       -           -
LGA    E   111_A      -       -           -
LGA    M   112_A      -       -           -
LGA    E   113_A      -       -           -
LGA    K   114_A      -       -           -
LGA    N   115_A      -       -           -
LGA    G   116_A      -       -           -
LGA    E   117_A      -       -           -
LGA    T   118_A      -       -           -
LGA    I   119_A      -       -           -
LGA    S   120_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  111   98    5.0     93    2.43    17.20     73.230     3.672

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.584653 * X  +   0.811047 * Y  +   0.019593 * Z  + -20.905697
  Y_new =   0.802845 * X  +   0.574929 * Y  +   0.157787 * Z  +  21.885920
  Z_new =   0.116708 * X  +   0.107981 * Y  +  -0.987279 * Z  +  39.861469 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   3.032654   -0.108939  [ DEG:   173.7583     -6.2417 ]
  Theta =  -0.116975   -3.024618  [ DEG:    -6.7022   -173.2978 ]
  Phi   =   2.200216   -0.941377  [ DEG:   126.0631    -53.9369 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1p8c_A                                        
REMARK     2: T0408.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1p8c_A.T0408.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  111   98   5.0   93   2.43   17.20  73.230
REMARK  ---------------------------------------------------------- 
MOLECULE 1p8c_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   06-MAY-03   1P8C              
TITLE     CRYSTAL STRUCTURE OF TM1620 (APC4843) FROM THERMOTOGA                 
TITLE    2 MARITIMA                                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CONSERVED HYPOTHETICAL PROTEIN;                            
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 SYNONYM: TM1620 (APC4843);                                           
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMOTOGA MARITIMA;                            
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    CONSERVED HYPOTHETICAL PROTEIN, STRUCTURAL GENOMICS, PSI,             
KEYWDS   2 PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL          
KEYWDS   3 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.KIM,A.JOACHIMIAK,J.S.BRUNZELLE,S.V.KOROLEV,A.EDWARDS,X.XU,          
AUTHOR   2 A.SAVCHENKO,MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)            
REVDAT   2   18-JAN-05 1P8C    1       AUTHOR KEYWDS REMARK                     
REVDAT   1   23-SEP-03 1P8C    0                                                
JRNL        AUTH   Y.KIM,A.JOACHIMIAK,J.S.BRUNZELLE,S.V.KOROLEV,                
JRNL        AUTH 2 A.EDWARDS,X.XU,A.SAVCHENKO                                   
JRNL        TITL   CRYSTAL STRUCTURE ANALYSIS OF THERMOTOGA MARITIMA            
JRNL        TITL 2 PROTEIN TM1620 (APC4843)                                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.30 ANGSTROMS.                                          
DBREF  1P8C A    1   121  UNP    Q9X1V5   Q9X1V5_THEMA     1    121             
DBREF  1P8C B    1   121  UNP    Q9X1V5   Q9X1V5_THEMA     1    121             
DBREF  1P8C C    1   121  UNP    Q9X1V5   Q9X1V5_THEMA     1    121             
DBREF  1P8C D    1   121  UNP    Q9X1V5   Q9X1V5_THEMA     1    121             
DBREF  1P8C E    1   121  UNP    Q9X1V5   Q9X1V5_THEMA     1    121             
DBREF  1P8C F    1   121  UNP    Q9X1V5   Q9X1V5_THEMA     1    121             
SEQRES   1 A  145  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 A  145  ARG GLU ASN LEU TYR PHE GLN GLY HIS MET GLU TYR LYS          
SEQRES   3 A  145  LYS PHE VAL GLU ALA ARG ARG GLU LEU ASN GLU LYS VAL          
SEQRES   4 A  145  LEU SER ARG GLY THR LEU ASN THR LYS ARG PHE PHE ASN          
SEQRES   5 A  145  LEU ASP SER ALA VAL TYR ARG PRO GLY LYS LEU ASP VAL          
SEQRES   6 A  145  LYS THR LYS GLU LEU MET GLY LEU VAL ALA SER THR VAL          
SEQRES   7 A  145  LEU ARG CYS ASP ASP CYS ILE ARG TYR HIS LEU VAL ARG          
SEQRES   8 A  145  CYS VAL GLN GLU GLY ALA SER ASP GLU GLU ILE PHE GLU          
SEQRES   9 A  145  ALA LEU ASP ILE ALA LEU VAL VAL GLY GLY SER ILE VAL          
SEQRES  10 A  145  ILE PRO HIS LEU ARG ARG ALA VAL GLY PHE LEU GLU GLU          
SEQRES  11 A  145  LEU ARG GLU MET GLU LYS ASN GLY GLU THR ILE SER LEU          
SEQRES  12 A  145  GLY SER                                                      
SEQRES   1 B  145  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 B  145  ARG GLU ASN LEU TYR PHE GLN GLY HIS MET GLU TYR LYS          
SEQRES   3 B  145  LYS PHE VAL GLU ALA ARG ARG GLU LEU ASN GLU LYS VAL          
SEQRES   4 B  145  LEU SER ARG GLY THR LEU ASN THR LYS ARG PHE PHE ASN          
SEQRES   5 B  145  LEU ASP SER ALA VAL TYR ARG PRO GLY LYS LEU ASP VAL          
SEQRES   6 B  145  LYS THR LYS GLU LEU MET GLY LEU VAL ALA SER THR VAL          
SEQRES   7 B  145  LEU ARG CYS ASP ASP CYS ILE ARG TYR HIS LEU VAL ARG          
SEQRES   8 B  145  CYS VAL GLN GLU GLY ALA SER ASP GLU GLU ILE PHE GLU          
SEQRES   9 B  145  ALA LEU ASP ILE ALA LEU VAL VAL GLY GLY SER ILE VAL          
SEQRES  10 B  145  ILE PRO HIS LEU ARG ARG ALA VAL GLY PHE LEU GLU GLU          
SEQRES  11 B  145  LEU ARG GLU MET GLU LYS ASN GLY GLU THR ILE SER LEU          
SEQRES  12 B  145  GLY SER                                                      
SEQRES   1 C  145  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 C  145  ARG GLU ASN LEU TYR PHE GLN GLY HIS MET GLU TYR LYS          
SEQRES   3 C  145  LYS PHE VAL GLU ALA ARG ARG GLU LEU ASN GLU LYS VAL          
SEQRES   4 C  145  LEU SER ARG GLY THR LEU ASN THR LYS ARG PHE PHE ASN          
SEQRES   5 C  145  LEU ASP SER ALA VAL TYR ARG PRO GLY LYS LEU ASP VAL          
SEQRES   6 C  145  LYS THR LYS GLU LEU MET GLY LEU VAL ALA SER THR VAL          
SEQRES   7 C  145  LEU ARG CYS ASP ASP CYS ILE ARG TYR HIS LEU VAL ARG          
SEQRES   8 C  145  CYS VAL GLN GLU GLY ALA SER ASP GLU GLU ILE PHE GLU          
SEQRES   9 C  145  ALA LEU ASP ILE ALA LEU VAL VAL GLY GLY SER ILE VAL          
SEQRES  10 C  145  ILE PRO HIS LEU ARG ARG ALA VAL GLY PHE LEU GLU GLU          
SEQRES  11 C  145  LEU ARG GLU MET GLU LYS ASN GLY GLU THR ILE SER LEU          
SEQRES  12 C  145  GLY SER                                                      
SEQRES   1 D  145  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 D  145  ARG GLU ASN LEU TYR PHE GLN GLY HIS MET GLU TYR LYS          
SEQRES   3 D  145  LYS PHE VAL GLU ALA ARG ARG GLU LEU ASN GLU LYS VAL          
SEQRES   4 D  145  LEU SER ARG GLY THR LEU ASN THR LYS ARG PHE PHE ASN          
SEQRES   5 D  145  LEU ASP SER ALA VAL TYR ARG PRO GLY LYS LEU ASP VAL          
SEQRES   6 D  145  LYS THR LYS GLU LEU MET GLY LEU VAL ALA SER THR VAL          
SEQRES   7 D  145  LEU ARG CYS ASP ASP CYS ILE ARG TYR HIS LEU VAL ARG          
SEQRES   8 D  145  CYS VAL GLN GLU GLY ALA SER ASP GLU GLU ILE PHE GLU          
SEQRES   9 D  145  ALA LEU ASP ILE ALA LEU VAL VAL GLY GLY SER ILE VAL          
SEQRES  10 D  145  ILE PRO HIS LEU ARG ARG ALA VAL GLY PHE LEU GLU GLU          
SEQRES  11 D  145  LEU ARG GLU MET GLU LYS ASN GLY GLU THR ILE SER LEU          
SEQRES  12 D  145  GLY SER                                                      
SEQRES   1 E  145  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 E  145  ARG GLU ASN LEU TYR PHE GLN GLY HIS MET GLU TYR LYS          
SEQRES   3 E  145  LYS PHE VAL GLU ALA ARG ARG GLU LEU ASN GLU LYS VAL          
SEQRES   4 E  145  LEU SER ARG GLY THR LEU ASN THR LYS ARG PHE PHE ASN          
SEQRES   5 E  145  LEU ASP SER ALA VAL TYR ARG PRO GLY LYS LEU ASP VAL          
SEQRES   6 E  145  LYS THR LYS GLU LEU MET GLY LEU VAL ALA SER THR VAL          
SEQRES   7 E  145  LEU ARG CYS ASP ASP CYS ILE ARG TYR HIS LEU VAL ARG          
SEQRES   8 E  145  CYS VAL GLN GLU GLY ALA SER ASP GLU GLU ILE PHE GLU          
SEQRES   9 E  145  ALA LEU ASP ILE ALA LEU VAL VAL GLY GLY SER ILE VAL          
SEQRES  10 E  145  ILE PRO HIS LEU ARG ARG ALA VAL GLY PHE LEU GLU GLU          
SEQRES  11 E  145  LEU ARG GLU MET GLU LYS ASN GLY GLU THR ILE SER LEU          
SEQRES  12 E  145  GLY SER                                                      
SEQRES   1 F  145  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 F  145  ARG GLU ASN LEU TYR PHE GLN GLY HIS MET GLU TYR LYS          
SEQRES   3 F  145  LYS PHE VAL GLU ALA ARG ARG GLU LEU ASN GLU LYS VAL          
SEQRES   4 F  145  LEU SER ARG GLY THR LEU ASN THR LYS ARG PHE PHE ASN          
SEQRES   5 F  145  LEU ASP SER ALA VAL TYR ARG PRO GLY LYS LEU ASP VAL          
SEQRES   6 F  145  LYS THR LYS GLU LEU MET GLY LEU VAL ALA SER THR VAL          
SEQRES   7 F  145  LEU ARG CYS ASP ASP CYS ILE ARG TYR HIS LEU VAL ARG          
SEQRES   8 F  145  CYS VAL GLN GLU GLY ALA SER ASP GLU GLU ILE PHE GLU          
SEQRES   9 F  145  ALA LEU ASP ILE ALA LEU VAL VAL GLY GLY SER ILE VAL          
SEQRES  10 F  145  ILE PRO HIS LEU ARG ARG ALA VAL GLY PHE LEU GLU GLU          
SEQRES  11 F  145  LEU ARG GLU MET GLU LYS ASN GLY GLU THR ILE SER LEU          
SEQRES  12 F  145  GLY SER                                                      
FORMUL   7  HOH   *87(H2 O)                                                     
CRYST1   65.819   82.541  135.397  90.00  90.00  90.00 P 21 21 21   24          
ATOM      1  N   ARG A  10      17.207  74.842  38.939  1.00 80.46           N  
ATOM      2  CA  ARG A  10      15.739  74.801  38.675  1.00 80.74           C  
ATOM      3  C   ARG A  10      15.183  76.218  38.535  1.00 80.05           C  
ATOM      4  O   ARG A  10      15.046  76.745  37.422  1.00 78.47           O  
ATOM      5  CB  ARG A  10      15.019  74.091  39.823  1.00140.83           C  
ATOM      6  CG  ARG A  10      15.331  72.612  39.950  1.00141.69           C  
ATOM      7  CD  ARG A  10      14.901  72.081  41.312  1.00141.62           C  
ATOM      8  NE  ARG A  10      15.755  72.580  42.389  1.00141.34           N  
ATOM      9  CZ  ARG A  10      15.576  72.300  43.677  1.00140.91           C  
ATOM     10  NH1 ARG A  10      14.570  71.525  44.052  1.00140.12           N  
ATOM     11  NH2 ARG A  10      16.409  72.787  44.587  1.00141.19           N  
ATOM     12  N   ARG A  11      14.857  76.826  39.674  1.00122.98           N  
ATOM     13  CA  ARG A  11      14.320  78.180  39.689  1.00123.46           C  
ATOM     14  C   ARG A  11      15.142  79.061  38.753  1.00121.91           C  
ATOM     15  O   ARG A  11      14.611  79.954  38.091  1.00121.24           O  
ATOM     16  CB  ARG A  11      14.341  78.734  41.120  1.00142.52           C  
ATOM     17  CG  ARG A  11      15.701  78.692  41.820  1.00144.77           C  
ATOM     18  CD  ARG A  11      16.610  79.852  41.402  1.00145.89           C  
ATOM     19  NE  ARG A  11      17.777  79.995  42.277  1.00146.63           N  
ATOM     20  CZ  ARG A  11      18.689  80.962  42.171  1.00146.61           C  
ATOM     21  NH1 ARG A  11      18.581  81.883  41.222  1.00147.19           N  
ATOM     22  NH2 ARG A  11      19.707  81.012  43.022  1.00147.52           N  
ATOM     23  N   GLU A  12      16.439  78.781  38.696  1.00128.39           N  
ATOM     24  CA  GLU A  12      17.359  79.523  37.846  1.00127.08           C  
ATOM     25  C   GLU A  12      17.192  79.067  36.403  1.00124.76           C  
ATOM     26  O   GLU A  12      17.233  79.876  35.476  1.00124.64           O  
ATOM     27  CB  GLU A  12      18.804  79.292  38.313  1.00164.31           C  
ATOM     28  CG  GLU A  12      19.877  80.108  37.584  1.00166.47           C  
ATOM     29  CD  GLU A  12      20.433  79.415  36.347  1.00167.71           C  
ATOM     30  OE1 GLU A  12      19.697  79.268  35.350  1.00167.41           O  
ATOM     31  OE2 GLU A  12      21.616  79.014  36.375  1.00167.73           O  
ATOM     32  N   LEU A  13      17.000  77.764  36.219  1.00124.37           N  
ATOM     33  CA  LEU A  13      16.830  77.210  34.886  1.00121.45           C  
ATOM     34  C   LEU A  13      15.666  77.864  34.147  1.00118.57           C  
ATOM     35  O   LEU A  13      15.709  78.005  32.922  1.00118.86           O  
ATOM     36  CB  LEU A  13      16.628  75.693  34.963  1.00120.67           C  
ATOM     37  CG  LEU A  13      17.856  74.872  35.373  1.00121.05           C  
ATOM     38  CD1 LEU A  13      17.492  73.399  35.438  1.00120.88           C  
ATOM     39  CD2 LEU A  13      18.984  75.100  34.373  1.00121.97           C  
ATOM     40  N   ASN A  14      14.633  78.269  34.885  1.00 77.91           N  
ATOM     41  CA  ASN A  14      13.474  78.919  34.272  1.00 74.37           C  
ATOM     42  C   ASN A  14      13.888  80.276  33.724  1.00 72.25           C  
ATOM     43  O   ASN A  14      13.253  80.821  32.810  1.00 71.48           O  
ATOM     44  CB  ASN A  14      12.357  79.081  35.296  1.00 72.46           C  
ATOM     45  CG  ASN A  14      11.845  77.750  35.804  1.00 71.91           C  
ATOM     46  OD1 ASN A  14      11.164  77.012  35.085  1.00 70.81           O  
ATOM     47  ND2 ASN A  14      12.186  77.426  37.045  1.00 72.96           N  
ATOM     48  N   GLU A  15      14.960  80.819  34.300  1.00 82.31           N  
ATOM     49  CA  GLU A  15      15.503  82.096  33.863  1.00 81.15           C  
ATOM     50  C   GLU A  15      16.176  81.815  32.527  1.00 76.86           C  
ATOM     51  O   GLU A  15      15.840  82.428  31.513  1.00 75.61           O  
ATOM     52  CB  GLU A  15      16.524  82.617  34.876  1.00151.40           C  
ATOM     53  CG  GLU A  15      15.962  82.792  36.278  1.00156.24           C  
ATOM     54  CD  GLU A  15      17.005  83.264  37.274  1.00159.32           C  
ATOM     55  OE1 GLU A  15      17.609  84.331  37.041  1.00159.53           O  
ATOM     56  OE2 GLU A  15      17.221  82.569  38.289  1.00159.30           O  
ATOM     57  N   LYS A  16      17.115  80.872  32.526  1.00 70.13           N  
ATOM     58  CA  LYS A  16      17.807  80.500  31.300  1.00 68.39           C  
ATOM     59  C   LYS A  16      16.806  80.175  30.201  1.00 65.66           C  
ATOM     60  O   LYS A  16      17.088  80.354  29.016  1.00 64.99           O  
ATOM     61  CB  LYS A  16      18.717  79.288  31.525  1.00 99.92           C  
ATOM     62  CG  LYS A  16      20.184  79.641  31.708  1.00102.95           C  
ATOM     63  CD  LYS A  16      21.032  78.402  31.898  1.00104.18           C  
ATOM     64  CE  LYS A  16      22.463  78.773  32.228  1.00105.22           C  
ATOM     65  NZ  LYS A  16      23.287  77.573  32.550  1.00108.85           N  
ATOM     66  N   VAL A  17      15.624  79.709  30.585  1.00 56.37           N  
ATOM     67  CA  VAL A  17      14.633  79.363  29.582  1.00 54.12           C  
ATOM     68  C   VAL A  17      13.895  80.584  29.061  1.00 53.38           C  
ATOM     69  O   VAL A  17      13.818  80.797  27.844  1.00 49.80           O  
ATOM     70  CB  VAL A  17      13.632  78.317  30.119  1.00 46.15           C  
ATOM     71  CG1 VAL A  17      12.634  77.966  29.032  1.00 43.92           C  
ATOM     72  CG2 VAL A  17      14.391  77.061  30.572  1.00 43.64           C  
ATOM     73  N   LEU A  18      13.357  81.387  29.972  1.00 95.09           N  
ATOM     74  CA  LEU A  18      12.652  82.600  29.584  1.00 96.67           C  
ATOM     75  C   LEU A  18      13.641  83.528  28.890  1.00 97.17           C  
ATOM     76  O   LEU A  18      13.304  84.223  27.924  1.00 98.23           O  
ATOM     77  CB  LEU A  18      12.083  83.283  30.819  1.00 90.04           C  
ATOM     78  CG  LEU A  18      10.860  82.608  31.425  1.00 90.81           C  
ATOM     79  CD1 LEU A  18      10.603  83.170  32.810  1.00 89.89           C  
ATOM     80  CD2 LEU A  18       9.661  82.826  30.504  1.00 91.05           C  
ATOM     81  N   SER A  19      14.867  83.520  29.406  1.00 74.71           N  
ATOM     82  CA  SER A  19      15.961  84.329  28.889  1.00 74.61           C  
ATOM     83  C   SER A  19      16.222  84.011  27.420  1.00 75.07           C  
ATOM     84  O   SER A  19      16.103  84.888  26.558  1.00 75.93           O  
ATOM     85  CB  SER A  19      17.221  84.072  29.725  1.00 65.56           C  
ATOM     86  OG  SER A  19      18.388  84.497  29.054  1.00 66.16           O  
ATOM     87  N   ARG A  20      16.580  82.756  27.146  1.00 64.50           N  
ATOM     88  CA  ARG A  20      16.848  82.302  25.782  1.00 64.87           C  
ATOM     89  C   ARG A  20      15.516  82.137  25.046  1.00 61.73           C  
ATOM     90  O   ARG A  20      15.476  81.882  23.840  1.00 60.18           O  
ATOM     91  CB  ARG A  20      17.579  80.954  25.807  1.00122.97           C  
ATOM     92  CG  ARG A  20      18.982  80.990  26.390  1.00128.87           C  
ATOM     93  CD  ARG A  20      19.938  81.713  25.462  1.00132.87           C  
ATOM     94  NE  ARG A  20      21.308  81.713  25.969  1.00137.77           N  
ATOM     95  CZ  ARG A  20      22.325  82.325  25.370  1.00139.44           C  
ATOM     96  NH1 ARG A  20      22.128  82.988  24.236  1.00140.59           N  
ATOM     97  NH2 ARG A  20      23.540  82.281  25.902  1.00140.55           N  
ATOM     98  N   GLY A  21      14.434  82.307  25.800  1.00 70.49           N  
ATOM     99  CA  GLY A  21      13.092  82.137  25.278  1.00 67.16           C  
ATOM    100  C   GLY A  21      12.553  83.047  24.201  1.00 63.64           C  
ATOM    101  O   GLY A  21      13.290  83.654  23.436  1.00 63.93           O  
ATOM    102  N   THR A  22      11.227  83.109  24.166  1.00 47.44           N  
ATOM    103  CA  THR A  22      10.466  83.897  23.206  1.00 46.02           C  
ATOM    104  C   THR A  22       9.388  84.673  23.954  1.00 45.42           C  
ATOM    105  O   THR A  22       9.248  84.544  25.171  1.00 43.20           O  
ATOM    106  CB  THR A  22       9.806  82.959  22.171  1.00 62.55           C  
ATOM    107  OG1 THR A  22      10.776  82.587  21.186  1.00 63.02           O  
ATOM    108  CG2 THR A  22       8.625  83.614  21.484  1.00 64.69           C  
ATOM    109  N   LEU A  23       8.656  85.504  23.218  1.00 51.62           N  
ATOM    110  CA  LEU A  23       7.578  86.294  23.769  1.00 53.06           C  
ATOM    111  C   LEU A  23       6.543  85.265  24.210  1.00 53.46           C  
ATOM    112  O   LEU A  23       5.934  85.392  25.274  1.00 52.81           O  
ATOM    113  CB  LEU A  23       6.980  87.205  22.691  1.00103.25           C  
ATOM    114  CG  LEU A  23       7.921  88.061  21.826  1.00108.43           C  
ATOM    115  CD1 LEU A  23       8.769  88.963  22.716  1.00110.34           C  
ATOM    116  CD2 LEU A  23       8.812  87.162  20.965  1.00107.87           C  
ATOM    117  N   ASN A  24       6.366  84.226  23.398  1.00 69.94           N  
ATOM    118  CA  ASN A  24       5.394  83.193  23.715  1.00 69.15           C  
ATOM    119  C   ASN A  24       5.827  82.312  24.862  1.00 67.60           C  
ATOM    120  O   ASN A  24       5.002  81.923  25.678  1.00 67.41           O  
ATOM    121  CB  ASN A  24       5.104  82.336  22.493  1.00 58.57           C  
ATOM    122  CG  ASN A  24       4.549  83.141  21.357  1.00 58.54           C  
ATOM    123  OD1 ASN A  24       3.742  84.043  21.569  1.00 59.64           O  
ATOM    124  ND2 ASN A  24       4.967  82.819  20.135  1.00 59.86           N  
ATOM    125  N   THR A  25       7.114  81.996  24.929  1.00 51.50           N  
ATOM    126  CA  THR A  25       7.605  81.156  26.016  1.00 50.66           C  
ATOM    127  C   THR A  25       7.254  81.823  27.344  1.00 52.48           C  
ATOM    128  O   THR A  25       6.927  81.159  28.331  1.00 52.71           O  
ATOM    129  CB  THR A  25       9.131  81.001  25.972  1.00 47.62           C  
ATOM    130  OG1 THR A  25       9.567  80.928  24.611  1.00 44.64           O  
ATOM    131  CG2 THR A  25       9.557  79.739  26.711  1.00 45.21           C  
ATOM    132  N   LYS A  26       7.337  83.151  27.358  1.00 52.92           N  
ATOM    133  CA  LYS A  26       7.065  83.940  28.556  1.00 54.96           C  
ATOM    134  C   LYS A  26       5.566  84.010  28.792  1.00 53.29           C  
ATOM    135  O   LYS A  26       5.107  83.823  29.916  1.00 50.97           O  
ATOM    136  CB  LYS A  26       7.686  85.334  28.402  1.00 96.82           C  
ATOM    137  CG  LYS A  26       9.210  85.267  28.212  1.00102.88           C  
ATOM    138  CD  LYS A  26       9.823  86.562  27.685  1.00106.31           C  
ATOM    139  CE  LYS A  26      11.305  86.369  27.344  1.00108.21           C  
ATOM    140  NZ  LYS A  26      11.924  87.572  26.711  1.00110.52           N  
ATOM    141  N   ARG A  27       4.802  84.235  27.727  1.00 56.72           N  
ATOM    142  CA  ARG A  27       3.358  84.295  27.853  1.00 59.44           C  
ATOM    143  C   ARG A  27       2.801  82.963  28.357  1.00 59.47           C  
ATOM    144  O   ARG A  27       1.843  82.946  29.121  1.00 59.61           O  
ATOM    145  CB  ARG A  27       2.719  84.689  26.525  1.00 91.55           C  
ATOM    146  CG  ARG A  27       2.999  86.134  26.174  1.00 97.97           C  
ATOM    147  CD  ARG A  27       1.970  86.717  25.220  1.00101.88           C  
ATOM    148  NE  ARG A  27       2.051  88.177  25.207  1.00105.65           N  
ATOM    149  CZ  ARG A  27       1.250  88.974  24.507  1.00105.96           C  
ATOM    150  NH1 ARG A  27       0.292  88.461  23.747  1.00105.59           N  
ATOM    151  NH2 ARG A  27       1.408  90.289  24.571  1.00107.12           N  
ATOM    152  N   PHE A  28       3.403  81.848  27.940  1.00 58.47           N  
ATOM    153  CA  PHE A  28       2.948  80.556  28.417  1.00 56.21           C  
ATOM    154  C   PHE A  28       3.307  80.394  29.896  1.00 55.05           C  
ATOM    155  O   PHE A  28       2.497  79.907  30.682  1.00 54.04           O  
ATOM    156  CB  PHE A  28       3.576  79.391  27.646  1.00 54.51           C  
ATOM    157  CG  PHE A  28       3.163  78.041  28.191  1.00 56.52           C  
ATOM    158  CD1 PHE A  28       2.007  77.409  27.725  1.00 55.65           C  
ATOM    159  CD2 PHE A  28       3.851  77.475  29.273  1.00 56.71           C  
ATOM    160  CE1 PHE A  28       1.535  76.243  28.334  1.00 57.46           C  
ATOM    161  CE2 PHE A  28       3.389  76.309  29.896  1.00 58.16           C  
ATOM    162  CZ  PHE A  28       2.228  75.691  29.429  1.00 57.71           C  
ATOM    163  N   PHE A  29       4.526  80.781  30.270  1.00 45.67           N  
ATOM    164  CA  PHE A  29       4.961  80.663  31.663  1.00 45.41           C  
ATOM    165  C   PHE A  29       4.101  81.485  32.606  1.00 44.62           C  
ATOM    166  O   PHE A  29       4.036  81.200  33.801  1.00 39.90           O  
ATOM    167  CB  PHE A  29       6.402  81.125  31.823  1.00 55.76           C  
ATOM    168  CG  PHE A  29       7.404  80.026  31.724  1.00 55.47           C  
ATOM    169  CD1 PHE A  29       7.510  79.268  30.564  1.00 52.76           C  
ATOM    170  CD2 PHE A  29       8.270  79.772  32.784  1.00 54.98           C  
ATOM    171  CE1 PHE A  29       8.463  78.275  30.459  1.00 53.36           C  
ATOM    172  CE2 PHE A  29       9.231  78.777  32.686  1.00 55.39           C  
ATOM    173  CZ  PHE A  29       9.327  78.026  31.519  1.00 53.94           C  
ATOM    174  N   ASN A  30       3.481  82.527  32.055  1.00 74.04           N  
ATOM    175  CA  ASN A  30       2.611  83.410  32.817  1.00 76.42           C  
ATOM    176  C   ASN A  30       1.339  82.666  33.160  1.00 75.51           C  
ATOM    177  O   ASN A  30       0.998  82.548  34.332  1.00 76.19           O  
ATOM    178  CB  ASN A  30       2.272  84.663  32.010  1.00126.65           C  
ATOM    179  CG  ASN A  30       3.431  85.638  31.934  1.00132.64           C  
ATOM    180  OD1 ASN A  30       3.334  86.690  31.297  1.00134.24           O  
ATOM    181  ND2 ASN A  30       4.537  85.294  32.587  1.00133.92           N  
ATOM    182  N   LEU A  31       0.644  82.167  32.137  1.00 59.77           N  
ATOM    183  CA  LEU A  31      -0.590  81.411  32.339  1.00 59.48           C  
ATOM    184  C   LEU A  31      -0.381  80.332  33.401  1.00 58.21           C  
ATOM    185  O   LEU A  31      -1.168  80.192  34.332  1.00 58.95           O  
ATOM    186  CB  LEU A  31      -1.038  80.737  31.039  1.00 58.24           C  
ATOM    187  CG  LEU A  31      -2.043  81.375  30.067  1.00 59.07           C  
ATOM    188  CD1 LEU A  31      -2.923  82.363  30.817  1.00 57.17           C  
ATOM    189  CD2 LEU A  31      -1.315  82.052  28.918  1.00 59.67           C  
ATOM    190  N   ASP A  32       0.694  79.574  33.257  1.00 54.37           N  
ATOM    191  CA  ASP A  32       1.014  78.505  34.190  1.00 52.88           C  
ATOM    192  C   ASP A  32       1.117  78.964  35.652  1.00 51.52           C  
ATOM    193  O   ASP A  32       1.061  78.155  36.588  1.00 49.26           O  
ATOM    194  CB  ASP A  32       2.318  77.839  33.762  1.00 50.86           C  
ATOM    195  CG  ASP A  32       2.708  76.714  34.666  1.00 50.28           C  
ATOM    196  OD1 ASP A  32       1.900  75.768  34.824  1.00 52.61           O  
ATOM    197  OD2 ASP A  32       3.817  76.777  35.219  1.00 50.23           O  
ATOM    198  N   SER A  33       1.284  80.262  35.851  1.00 56.42           N  
ATOM    199  CA  SER A  33       1.392  80.795  37.203  1.00 57.60           C  
ATOM    200  C   SER A  33       0.055  81.430  37.569  1.00 57.48           C  
ATOM    201  O   SER A  33      -0.435  81.282  38.690  1.00 58.23           O  
ATOM    202  CB  SER A  33       2.516  81.832  37.269  1.00 58.51           C  
ATOM    203  OG  SER A  33       2.968  82.010  38.598  1.00 60.93           O  
ATOM    204  N   ALA A  34      -0.533  82.132  36.608  1.00 51.72           N  
ATOM    205  CA  ALA A  34      -1.814  82.789  36.802  1.00 51.50           C  
ATOM    206  C   ALA A  34      -2.850  81.751  37.213  1.00 53.19           C  
ATOM    207  O   ALA A  34      -3.364  81.760  38.330  1.00 54.77           O  
ATOM    208  CB  ALA A  34      -2.250  83.466  35.503  1.00 34.27           C  
ATOM    209  N   VAL A  35      -3.145  80.856  36.278  1.00 57.05           N  
ATOM    210  CA  VAL A  35      -4.105  79.779  36.450  1.00 54.42           C  
ATOM    211  C   VAL A  35      -4.213  79.202  37.886  1.00 53.31           C  
ATOM    212  O   VAL A  35      -5.239  78.616  38.226  1.00 54.24           O  
ATOM    213  CB  VAL A  35      -3.777  78.669  35.403  1.00 48.33           C  
ATOM    214  CG1 VAL A  35      -2.806  77.657  35.976  1.00 46.50           C  
ATOM    215  CG2 VAL A  35      -5.039  78.030  34.898  1.00 49.58           C  
ATOM    216  N   TYR A  36      -3.191  79.398  38.733  1.00 44.50           N  
ATOM    217  CA  TYR A  36      -3.187  78.872  40.117  1.00 45.18           C  
ATOM    218  C   TYR A  36      -3.437  79.878  41.256  1.00 48.04           C  
ATOM    219  O   TYR A  36      -3.179  79.578  42.437  1.00 44.79           O  
ATOM    220  CB  TYR A  36      -1.867  78.176  40.418  1.00 47.56           C  
ATOM    221  CG  TYR A  36      -1.665  76.876  39.691  1.00 50.17           C  
ATOM    222  CD1 TYR A  36      -2.354  75.717  40.068  1.00 48.97           C  
ATOM    223  CD2 TYR A  36      -0.757  76.791  38.642  1.00 49.28           C  
ATOM    224  CE1 TYR A  36      -2.132  74.523  39.426  1.00 48.30           C  
ATOM    225  CE2 TYR A  36      -0.535  75.606  37.990  1.00 50.98           C  
ATOM    226  CZ  TYR A  36      -1.216  74.473  38.379  1.00 51.03           C  
ATOM    227  OH  TYR A  36      -0.961  73.303  37.704  1.00 51.07           O  
ATOM    228  N   ARG A  37      -3.910  81.067  40.914  1.00 63.76           N  
ATOM    229  CA  ARG A  37      -4.179  82.069  41.927  1.00 67.94           C  
ATOM    230  C   ARG A  37      -5.630  81.895  42.355  1.00 68.49           C  
ATOM    231  O   ARG A  37      -6.457  81.408  41.581  1.00 70.00           O  
ATOM    232  CB  ARG A  37      -3.964  83.461  41.346  1.00 73.29           C  
ATOM    233  CG  ARG A  37      -2.550  83.735  40.860  1.00 76.93           C  
ATOM    234  CD  ARG A  37      -2.557  84.937  39.923  1.00 81.75           C  
ATOM    235  NE  ARG A  37      -1.234  85.279  39.406  1.00 85.81           N  
ATOM    236  CZ  ARG A  37      -1.032  86.120  38.396  1.00 86.35           C  
ATOM    237  NH1 ARG A  37       0.201  86.382  37.983  1.00 88.48           N  
ATOM    238  NH2 ARG A  37      -2.069  86.691  37.791  1.00 86.73           N  
ATOM    239  N   PRO A  38      -5.960  82.284  43.595  1.00 55.48           N  
ATOM    240  CA  PRO A  38      -7.323  82.171  44.135  1.00 53.04           C  
ATOM    241  C   PRO A  38      -8.377  82.795  43.228  1.00 50.56           C  
ATOM    242  O   PRO A  38      -8.140  83.818  42.589  1.00 51.10           O  
ATOM    243  CB  PRO A  38      -7.230  82.903  45.471  1.00 72.45           C  
ATOM    244  CG  PRO A  38      -5.805  82.718  45.864  1.00 74.36           C  
ATOM    245  CD  PRO A  38      -5.068  82.940  44.566  1.00 75.20           C  
ATOM    246  N   GLY A  39      -9.543  82.173  43.178  1.00 42.87           N  
ATOM    247  CA  GLY A  39     -10.640  82.678  42.366  1.00 42.93           C  
ATOM    248  C   GLY A  39     -11.906  82.117  42.996  1.00 43.94           C  
ATOM    249  O   GLY A  39     -12.046  82.158  44.219  1.00 40.78           O  
ATOM    250  N   LYS A  40     -12.826  81.588  42.194  1.00 58.08           N  
ATOM    251  CA  LYS A  40     -14.026  80.983  42.769  1.00 59.95           C  
ATOM    252  C   LYS A  40     -13.516  79.819  43.648  1.00 59.08           C  
ATOM    253  O   LYS A  40     -14.089  79.518  44.692  1.00 58.02           O  
ATOM    254  CB  LYS A  40     -14.949  80.463  41.667  1.00 85.34           C  
ATOM    255  CG  LYS A  40     -16.333  80.074  42.146  1.00 91.84           C  
ATOM    256  CD  LYS A  40     -17.108  81.270  42.678  1.00 95.97           C  
ATOM    257  CE  LYS A  40     -18.515  80.860  43.097  1.00 98.16           C  
ATOM    258  NZ  LYS A  40     -19.330  82.025  43.549  1.00 99.29           N  
ATOM    259  N   LEU A  41     -12.430  79.180  43.200  1.00 52.24           N  
ATOM    260  CA  LEU A  41     -11.774  78.084  43.919  1.00 51.26           C  
ATOM    261  C   LEU A  41     -10.633  78.756  44.654  1.00 52.10           C  
ATOM    262  O   LEU A  41     -10.148  79.785  44.203  1.00 53.89           O  
ATOM    263  CB  LEU A  41     -11.183  77.050  42.943  1.00 46.23           C  
ATOM    264  CG  LEU A  41     -12.050  75.946  42.317  1.00 45.98           C  
ATOM    265  CD1 LEU A  41     -11.320  75.292  41.165  1.00 43.88           C  
ATOM    266  CD2 LEU A  41     -12.377  74.907  43.368  1.00 46.20           C  
ATOM    267  N   ASP A  42     -10.200  78.186  45.771  1.00 60.72           N  
ATOM    268  CA  ASP A  42      -9.097  78.766  46.537  1.00 62.51           C  
ATOM    269  C   ASP A  42      -7.734  78.223  46.086  1.00 62.27           C  
ATOM    270  O   ASP A  42      -7.661  77.301  45.276  1.00 61.54           O  
ATOM    271  CB  ASP A  42      -9.292  78.497  48.034  1.00 73.75           C  
ATOM    272  CG  ASP A  42      -9.550  77.031  48.341  1.00 78.69           C  
ATOM    273  OD1 ASP A  42     -10.594  76.499  47.893  1.00 79.34           O  
ATOM    274  OD2 ASP A  42      -8.710  76.411  49.031  1.00 81.37           O  
ATOM    275  N   VAL A  43      -6.659  78.796  46.623  1.00 59.40           N  
ATOM    276  CA  VAL A  43      -5.308  78.367  46.270  1.00 59.36           C  
ATOM    277  C   VAL A  43      -4.984  76.948  46.707  1.00 57.83           C  
ATOM    278  O   VAL A  43      -4.402  76.181  45.936  1.00 56.18           O  
ATOM    279  CB  VAL A  43      -4.225  79.289  46.876  1.00 67.58           C  
ATOM    280  CG1 VAL A  43      -3.550  80.078  45.776  1.00 67.27           C  
ATOM    281  CG2 VAL A  43      -4.844  80.211  47.929  1.00 68.95           C  
ATOM    282  N   LYS A  44      -5.343  76.608  47.944  1.00 55.54           N  
ATOM    283  CA  LYS A  44      -5.072  75.275  48.473  1.00 55.56           C  
ATOM    284  C   LYS A  44      -5.617  74.204  47.516  1.00 56.17           C  
ATOM    285  O   LYS A  44      -4.924  73.228  47.199  1.00 53.16           O  
ATOM    286  CB  LYS A  44      -5.706  75.123  49.864  1.00 57.91           C  
ATOM    287  CG  LYS A  44      -5.417  73.797  50.584  1.00 59.53           C  
ATOM    288  CD  LYS A  44      -6.703  73.038  50.904  1.00 62.36           C  
ATOM    289  CE  LYS A  44      -7.432  73.596  52.125  1.00 63.15           C  
ATOM    290  NZ  LYS A  44      -6.772  73.148  53.397  1.00 65.36           N  
ATOM    291  N   THR A  45      -6.850  74.416  47.052  1.00 49.40           N  
ATOM    292  CA  THR A  45      -7.538  73.495  46.149  1.00 48.24           C  
ATOM    293  C   THR A  45      -6.851  73.424  44.787  1.00 48.25           C  
ATOM    294  O   THR A  45      -6.578  72.340  44.255  1.00 46.67           O  
ATOM    295  CB  THR A  45      -9.016  73.937  45.947  1.00 49.84           C  
ATOM    296  OG1 THR A  45      -9.705  73.871  47.201  1.00 49.91           O  
ATOM    297  CG2 THR A  45      -9.730  73.052  44.930  1.00 50.21           C  
ATOM    298  N   LYS A  46      -6.577  74.602  44.237  1.00 61.50           N  
ATOM    299  CA  LYS A  46      -5.929  74.738  42.947  1.00 59.99           C  
ATOM    300  C   LYS A  46      -4.595  74.050  42.907  1.00 60.20           C  
ATOM    301  O   LYS A  46      -4.253  73.416  41.917  1.00 61.80           O  
ATOM    302  CB  LYS A  46      -5.754  76.205  42.616  1.00 40.89           C  
ATOM    303  CG  LYS A  46      -7.086  76.909  42.449  1.00 41.02           C  
ATOM    304  CD  LYS A  46      -7.057  77.843  41.260  1.00 38.00           C  
ATOM    305  CE  LYS A  46      -8.359  78.584  41.118  1.00 39.31           C  
ATOM    306  NZ  LYS A  46      -8.312  79.459  39.919  1.00 41.22           N  
ATOM    307  N   GLU A  47      -3.841  74.171  43.987  1.00 50.02           N  
ATOM    308  CA  GLU A  47      -2.534  73.547  44.049  1.00 51.45           C  
ATOM    309  C   GLU A  47      -2.641  72.034  44.198  1.00 50.75           C  
ATOM    310  O   GLU A  47      -1.791  71.304  43.693  1.00 50.31           O  
ATOM    311  CB  GLU A  47      -1.701  74.142  45.192  1.00 52.42           C  
ATOM    312  CG  GLU A  47      -1.178  75.569  44.931  1.00 55.71           C  
ATOM    313  CD  GLU A  47      -0.240  75.674  43.707  1.00 58.90           C  
ATOM    314  OE1 GLU A  47       0.643  74.793  43.541  1.00 56.49           O  
ATOM    315  OE2 GLU A  47      -0.387  76.646  42.924  1.00 57.99           O  
ATOM    316  N   LEU A  48      -3.677  71.562  44.889  1.00 53.09           N  
ATOM    317  CA  LEU A  48      -3.861  70.121  45.056  1.00 50.19           C  
ATOM    318  C   LEU A  48      -4.265  69.552  43.706  1.00 50.42           C  
ATOM    319  O   LEU A  48      -3.999  68.395  43.405  1.00 52.48           O  
ATOM    320  CB  LEU A  48      -4.930  69.813  46.119  1.00 34.52           C  
ATOM    321  CG  LEU A  48      -4.391  70.017  47.539  1.00 36.21           C  
ATOM    322  CD1 LEU A  48      -5.549  70.353  48.478  1.00 35.12           C  
ATOM    323  CD2 LEU A  48      -3.598  68.779  48.005  1.00 33.83           C  
ATOM    324  N   MET A  49      -4.906  70.376  42.892  1.00 45.30           N  
ATOM    325  CA  MET A  49      -5.313  69.957  41.567  1.00 44.91           C  
ATOM    326  C   MET A  49      -4.083  69.861  40.681  1.00 44.77           C  
ATOM    327  O   MET A  49      -3.993  68.983  39.820  1.00 46.00           O  
ATOM    328  CB  MET A  49      -6.290  70.955  40.968  1.00 44.54           C  
ATOM    329  CG  MET A  49      -7.537  71.121  41.798  1.00 46.61           C  
ATOM    330  SD  MET A  49      -8.768  72.044  40.930  1.00 49.85           S  
ATOM    331  CE  MET A  49     -10.222  71.241  41.551  1.00 49.97           C  
ATOM    332  N   GLY A  50      -3.145  70.784  40.886  1.00 40.86           N  
ATOM    333  CA  GLY A  50      -1.931  70.769  40.109  1.00 36.64           C  
ATOM    334  C   GLY A  50      -1.185  69.516  40.505  1.00 35.18           C  
ATOM    335  O   GLY A  50      -0.523  68.888  39.684  1.00 33.71           O  
ATOM    336  N   LEU A  51      -1.293  69.144  41.777  1.00 35.22           N  
ATOM    337  CA  LEU A  51      -0.610  67.957  42.261  1.00 35.47           C  
ATOM    338  C   LEU A  51      -1.221  66.757  41.514  1.00 36.58           C  
ATOM    339  O   LEU A  51      -0.510  65.881  41.036  1.00 37.46           O  
ATOM    340  CB  LEU A  51      -0.831  67.812  43.762  1.00 35.86           C  
ATOM    341  CG  LEU A  51      -0.263  66.570  44.444  1.00 34.60           C  
ATOM    342  CD1 LEU A  51       1.241  66.439  44.185  1.00 34.76           C  
ATOM    343  CD2 LEU A  51      -0.532  66.698  45.913  1.00 37.12           C  
ATOM    344  N   VAL A  52      -2.546  66.743  41.427  1.00 34.13           N  
ATOM    345  CA  VAL A  52      -3.265  65.683  40.754  1.00 35.83           C  
ATOM    346  C   VAL A  52      -2.797  65.536  39.304  1.00 35.67           C  
ATOM    347  O   VAL A  52      -2.239  64.508  38.934  1.00 34.03           O  
ATOM    348  CB  VAL A  52      -4.796  65.956  40.742  1.00 31.70           C  
ATOM    349  CG1 VAL A  52      -5.489  64.915  39.882  1.00 33.35           C  
ATOM    350  CG2 VAL A  52      -5.375  65.898  42.167  1.00 32.43           C  
ATOM    351  N   ALA A  53      -3.044  66.575  38.503  1.00 30.75           N  
ATOM    352  CA  ALA A  53      -2.691  66.578  37.105  1.00 32.52           C  
ATOM    353  C   ALA A  53      -1.271  66.114  36.902  1.00 33.59           C  
ATOM    354  O   ALA A  53      -1.026  65.261  36.055  1.00 35.78           O  
ATOM    355  CB  ALA A  53      -2.887  67.974  36.494  1.00 23.08           C  
ATOM    356  N   SER A  54      -0.362  66.660  37.704  1.00 33.26           N  
ATOM    357  CA  SER A  54       1.067  66.370  37.628  1.00 34.15           C  
ATOM    358  C   SER A  54       1.416  64.951  38.044  1.00 34.27           C  
ATOM    359  O   SER A  54       2.489  64.433  37.710  1.00 32.47           O  
ATOM    360  CB  SER A  54       1.865  67.350  38.522  1.00 37.47           C  
ATOM    361  OG  SER A  54       1.680  68.708  38.140  1.00 37.66           O  
ATOM    362  N   THR A  55       0.538  64.334  38.816  1.00 36.88           N  
ATOM    363  CA  THR A  55       0.792  62.981  39.259  1.00 37.15           C  
ATOM    364  C   THR A  55       0.298  62.022  38.179  1.00 37.25           C  
ATOM    365  O   THR A  55       0.981  61.064  37.854  1.00 38.80           O  
ATOM    366  CB  THR A  55       0.104  62.704  40.628  1.00 44.20           C  
ATOM    367  OG1 THR A  55       0.602  63.631  41.605  1.00 47.26           O  
ATOM    368  CG2 THR A  55       0.407  61.293  41.113  1.00 43.54           C  
ATOM    369  N   VAL A  56      -0.863  62.287  37.594  1.00 36.36           N  
ATOM    370  CA  VAL A  56      -1.355  61.384  36.566  1.00 37.44           C  
ATOM    371  C   VAL A  56      -0.492  61.522  35.324  1.00 39.83           C  
ATOM    372  O   VAL A  56      -0.361  60.574  34.550  1.00 40.16           O  
ATOM    373  CB  VAL A  56      -2.831  61.658  36.161  1.00 25.46           C  
ATOM    374  CG1 VAL A  56      -3.753  61.451  37.333  1.00 22.56           C  
ATOM    375  CG2 VAL A  56      -2.980  63.066  35.639  1.00 27.71           C  
ATOM    376  N   LEU A  57       0.109  62.694  35.125  1.00 34.56           N  
ATOM    377  CA  LEU A  57       0.924  62.861  33.942  1.00 36.17           C  
ATOM    378  C   LEU A  57       2.339  62.423  34.249  1.00 37.44           C  
ATOM    379  O   LEU A  57       3.161  62.337  33.355  1.00 38.29           O  
ATOM    380  CB  LEU A  57       0.869  64.304  33.436  1.00 40.65           C  
ATOM    381  CG  LEU A  57      -0.470  64.705  32.814  1.00 41.74           C  
ATOM    382  CD1 LEU A  57      -0.642  66.196  32.909  1.00 42.45           C  
ATOM    383  CD2 LEU A  57      -0.549  64.270  31.370  1.00 39.14           C  
ATOM    384  N   ARG A  58       2.615  62.135  35.518  1.00 41.93           N  
ATOM    385  CA  ARG A  58       3.932  61.644  35.950  1.00 42.61           C  
ATOM    386  C   ARG A  58       5.141  62.551  35.688  1.00 44.93           C  
ATOM    387  O   ARG A  58       6.131  62.149  35.052  1.00 44.53           O  
ATOM    388  CB  ARG A  58       4.214  60.257  35.333  1.00 41.39           C  
ATOM    389  CG  ARG A  58       3.362  59.118  35.869  1.00 41.00           C  
ATOM    390  CD  ARG A  58       3.741  57.823  35.182  1.00 40.57           C  
ATOM    391  NE  ARG A  58       3.155  57.709  33.848  1.00 37.05           N  
ATOM    392  CZ  ARG A  58       3.781  57.161  32.807  1.00 36.58           C  
ATOM    393  NH1 ARG A  58       5.020  56.688  32.948  1.00 32.32           N  
ATOM    394  NH2 ARG A  58       3.160  57.056  31.636  1.00 35.45           N  
ATOM    395  N   CYS A  59       5.055  63.778  36.168  1.00 38.47           N  
ATOM    396  CA  CYS A  59       6.165  64.705  36.045  1.00 41.55           C  
ATOM    397  C   CYS A  59       6.625  64.947  37.490  1.00 41.73           C  
ATOM    398  O   CYS A  59       5.910  65.555  38.273  1.00 39.08           O  
ATOM    399  CB  CYS A  59       5.709  66.010  35.359  1.00 50.99           C  
ATOM    400  SG  CYS A  59       6.801  67.434  35.679  1.00 55.06           S  
ATOM    401  N   ASP A  60       7.793  64.434  37.857  1.00 63.41           N  
ATOM    402  CA  ASP A  60       8.282  64.628  39.218  1.00 67.77           C  
ATOM    403  C   ASP A  60       8.556  66.088  39.582  1.00 68.91           C  
ATOM    404  O   ASP A  60       8.241  66.516  40.692  1.00 70.38           O  
ATOM    405  CB  ASP A  60       9.528  63.778  39.472  1.00 58.93           C  
ATOM    406  CG  ASP A  60       9.182  62.342  39.835  1.00 60.46           C  
ATOM    407  OD1 ASP A  60       8.284  62.143  40.697  1.00 62.28           O  
ATOM    408  OD2 ASP A  60       9.800  61.416  39.272  1.00 58.45           O  
ATOM    409  N   ASP A  61       9.141  66.848  38.655  1.00 61.65           N  
ATOM    410  CA  ASP A  61       9.420  68.265  38.892  1.00 61.72           C  
ATOM    411  C   ASP A  61       8.112  69.009  39.139  1.00 58.62           C  
ATOM    412  O   ASP A  61       8.026  69.832  40.045  1.00 59.33           O  
ATOM    413  CB  ASP A  61      10.143  68.898  37.698  1.00 85.87           C  
ATOM    414  CG  ASP A  61      11.645  68.967  37.898  1.00 90.96           C  
ATOM    415  OD1 ASP A  61      12.090  69.525  38.925  1.00 91.89           O  
ATOM    416  OD2 ASP A  61      12.386  68.471  37.028  1.00 94.19           O  
ATOM    417  N   CYS A  62       7.095  68.724  38.329  1.00 42.19           N  
ATOM    418  CA  CYS A  62       5.808  69.364  38.511  1.00 40.18           C  
ATOM    419  C   CYS A  62       5.202  68.905  39.842  1.00 38.02           C  
ATOM    420  O   CYS A  62       4.626  69.712  40.568  1.00 36.85           O  
ATOM    421  CB  CYS A  62       4.863  69.029  37.362  1.00 47.28           C  
ATOM    422  SG  CYS A  62       5.565  69.079  35.674  1.00 49.84           S  
ATOM    423  N   ILE A  63       5.350  67.631  40.186  1.00 47.66           N  
ATOM    424  CA  ILE A  63       4.798  67.131  41.454  1.00 50.47           C  
ATOM    425  C   ILE A  63       5.448  67.803  42.675  1.00 52.20           C  
ATOM    426  O   ILE A  63       4.756  68.328  43.557  1.00 51.14           O  
ATOM    427  CB  ILE A  63       4.985  65.601  41.589  1.00 46.59           C  
ATOM    428  CG1 ILE A  63       4.024  64.867  40.652  1.00 43.49           C  
ATOM    429  CG2 ILE A  63       4.785  65.173  43.046  1.00 45.32           C  
ATOM    430  CD1 ILE A  63       4.295  63.365  40.575  1.00 38.65           C  
ATOM    431  N   ARG A  64       6.778  67.766  42.717  1.00 58.79           N  
ATOM    432  CA  ARG A  64       7.534  68.364  43.809  1.00 61.68           C  
ATOM    433  C   ARG A  64       7.137  69.823  44.010  1.00 61.74           C  
ATOM    434  O   ARG A  64       6.787  70.232  45.117  1.00 61.77           O  
ATOM    435  CB  ARG A  64       9.023  68.243  43.523  1.00 72.69           C  
ATOM    436  CG  ARG A  64       9.519  66.837  43.729  1.00 78.49           C  
ATOM    437  CD  ARG A  64      10.860  66.591  43.070  1.00 81.10           C  
ATOM    438  NE  ARG A  64      11.316  65.230  43.341  1.00 84.53           N  
ATOM    439  CZ  ARG A  64      12.215  64.580  42.609  1.00 85.85           C  
ATOM    440  NH1 ARG A  64      12.758  65.165  41.547  1.00 87.22           N  
ATOM    441  NH2 ARG A  64      12.576  63.345  42.938  1.00 86.48           N  
ATOM    442  N   TYR A  65       7.168  70.602  42.936  1.00 56.48           N  
ATOM    443  CA  TYR A  65       6.791  72.005  43.033  1.00 55.69           C  
ATOM    444  C   TYR A  65       5.396  72.158  43.616  1.00 52.75           C  
ATOM    445  O   TYR A  65       5.159  73.001  44.479  1.00 52.69           O  
ATOM    446  CB  TYR A  65       6.824  72.669  41.663  1.00 60.05           C  
ATOM    447  CG  TYR A  65       6.125  74.004  41.646  1.00 64.04           C  
ATOM    448  CD1 TYR A  65       6.700  75.127  42.241  1.00 64.39           C  
ATOM    449  CD2 TYR A  65       4.871  74.141  41.054  1.00 65.40           C  
ATOM    450  CE1 TYR A  65       6.041  76.362  42.243  1.00 65.22           C  
ATOM    451  CE2 TYR A  65       4.205  75.367  41.049  1.00 67.26           C  
ATOM    452  CZ  TYR A  65       4.794  76.475  41.643  1.00 66.43           C  
ATOM    453  OH  TYR A  65       4.127  77.685  41.619  1.00 65.58           O  
ATOM    454  N   HIS A  66       4.459  71.358  43.132  1.00 46.74           N  
ATOM    455  CA  HIS A  66       3.107  71.448  43.646  1.00 45.49           C  
ATOM    456  C   HIS A  66       2.982  70.944  45.068  1.00 45.75           C  
ATOM    457  O   HIS A  66       2.105  71.398  45.784  1.00 46.86           O  
ATOM    458  CB  HIS A  66       2.135  70.725  42.727  1.00 47.64           C  
ATOM    459  CG  HIS A  66       1.820  71.499  41.495  1.00 45.48           C  
ATOM    460  ND1 HIS A  66       1.119  72.684  41.530  1.00 45.33           N  
ATOM    461  CD2 HIS A  66       2.145  71.288  40.198  1.00 47.23           C  
ATOM    462  CE1 HIS A  66       1.021  73.171  40.305  1.00 49.05           C  
ATOM    463  NE2 HIS A  66       1.634  72.341  39.476  1.00 48.91           N  
ATOM    464  N   LEU A  67       3.844  70.019  45.488  1.00 45.09           N  
ATOM    465  CA  LEU A  67       3.786  69.541  46.858  1.00 47.87           C  
ATOM    466  C   LEU A  67       4.172  70.692  47.787  1.00 51.75           C  
ATOM    467  O   LEU A  67       3.488  70.953  48.787  1.00 50.60           O  
ATOM    468  CB  LEU A  67       4.755  68.388  47.101  1.00 51.82           C  
ATOM    469  CG  LEU A  67       4.285  66.972  46.808  1.00 54.77           C  
ATOM    470  CD1 LEU A  67       5.296  65.976  47.394  1.00 52.31           C  
ATOM    471  CD2 LEU A  67       2.908  66.756  47.421  1.00 52.25           C  
ATOM    472  N   VAL A  68       5.271  71.379  47.463  1.00 65.53           N  
ATOM    473  CA  VAL A  68       5.703  72.490  48.299  1.00 67.91           C  
ATOM    474  C   VAL A  68       4.571  73.505  48.410  1.00 68.53           C  
ATOM    475  O   VAL A  68       4.194  73.891  49.515  1.00 68.43           O  
ATOM    476  CB  VAL A  68       6.990  73.201  47.748  1.00 60.22           C  
ATOM    477  CG1 VAL A  68       8.000  72.165  47.300  1.00 59.64           C  
ATOM    478  CG2 VAL A  68       6.646  74.172  46.625  1.00 60.69           C  
ATOM    479  N   ARG A  69       4.011  73.922  47.278  1.00 62.81           N  
ATOM    480  CA  ARG A  69       2.927  74.886  47.324  1.00 64.21           C  
ATOM    481  C   ARG A  69       1.784  74.388  48.218  1.00 65.08           C  
ATOM    482  O   ARG A  69       1.248  75.153  49.015  1.00 65.47           O  
ATOM    483  CB  ARG A  69       2.421  75.207  45.910  1.00 50.09           C  
ATOM    484  CG  ARG A  69       3.373  76.117  45.120  1.00 50.76           C  
ATOM    485  CD  ARG A  69       2.689  77.387  44.670  1.00 49.25           C  
ATOM    486  NE  ARG A  69       1.972  78.020  45.777  1.00 53.83           N  
ATOM    487  CZ  ARG A  69       1.076  79.000  45.636  1.00 54.89           C  
ATOM    488  NH1 ARG A  69       0.770  79.483  44.429  1.00 55.14           N  
ATOM    489  NH2 ARG A  69       0.462  79.479  46.707  1.00 54.10           N  
ATOM    490  N   CYS A  70       1.417  73.112  48.108  1.00 60.15           N  
ATOM    491  CA  CYS A  70       0.337  72.588  48.939  1.00 61.75           C  
ATOM    492  C   CYS A  70       0.743  72.666  50.400  1.00 62.91           C  
ATOM    493  O   CYS A  70       0.024  73.237  51.228  1.00 61.10           O  
ATOM    494  CB  CYS A  70       0.015  71.133  48.588  1.00 66.38           C  
ATOM    495  SG  CYS A  70      -0.901  70.931  47.058  1.00 66.34           S  
ATOM    496  N   VAL A  71       1.898  72.088  50.713  1.00 62.36           N  
ATOM    497  CA  VAL A  71       2.380  72.095  52.078  1.00 64.87           C  
ATOM    498  C   VAL A  71       2.379  73.530  52.587  1.00 67.49           C  
ATOM    499  O   VAL A  71       1.847  73.813  53.668  1.00 67.91           O  
ATOM    500  CB  VAL A  71       3.807  71.517  52.171  1.00 66.53           C  
ATOM    501  CG1 VAL A  71       4.287  71.547  53.610  1.00 68.06           C  
ATOM    502  CG2 VAL A  71       3.834  70.095  51.641  1.00 65.83           C  
ATOM    503  N   GLN A  72       2.947  74.433  51.787  1.00 78.26           N  
ATOM    504  CA  GLN A  72       3.044  75.846  52.139  1.00 79.09           C  
ATOM    505  C   GLN A  72       1.711  76.581  52.040  1.00 78.45           C  
ATOM    506  O   GLN A  72       1.630  77.765  52.363  1.00 79.63           O  
ATOM    507  CB  GLN A  72       4.056  76.552  51.227  1.00 84.65           C  
ATOM    508  CG  GLN A  72       3.455  76.999  49.893  1.00 88.24           C  
ATOM    509  CD  GLN A  72       4.451  77.681  48.968  1.00 89.69           C  
ATOM    510  OE1 GLN A  72       4.091  78.126  47.874  1.00 89.65           O  
ATOM    511  NE2 GLN A  72       5.705  77.766  49.399  1.00 89.85           N  
ATOM    512  N   GLU A  73       0.665  75.898  51.593  1.00 56.07           N  
ATOM    513  CA  GLU A  73      -0.627  76.566  51.456  1.00 56.00           C  
ATOM    514  C   GLU A  73      -1.648  76.096  52.491  1.00 54.23           C  
ATOM    515  O   GLU A  73      -2.830  76.424  52.400  1.00 53.67           O  
ATOM    516  CB  GLU A  73      -1.184  76.349  50.047  1.00 85.86           C  
ATOM    517  CG  GLU A  73      -2.105  77.453  49.560  1.00 89.55           C  
ATOM    518  CD  GLU A  73      -1.386  78.781  49.425  1.00 92.02           C  
ATOM    519  OE1 GLU A  73      -1.953  79.706  48.807  1.00 92.16           O  
ATOM    520  OE2 GLU A  73      -0.252  78.902  49.939  1.00 92.46           O  
ATOM    521  N   GLY A  74      -1.195  75.315  53.465  1.00 61.76           N  
ATOM    522  CA  GLY A  74      -2.096  74.851  54.496  1.00 61.97           C  
ATOM    523  C   GLY A  74      -2.389  73.374  54.439  1.00 62.42           C  
ATOM    524  O   GLY A  74      -2.317  72.684  55.465  1.00 62.51           O  
ATOM    525  N   ALA A  75      -2.716  72.897  53.237  1.00 80.84           N  
ATOM    526  CA  ALA A  75      -3.036  71.494  52.992  1.00 78.69           C  
ATOM    527  C   ALA A  75      -2.262  70.555  53.899  1.00 77.41           C  
ATOM    528  O   ALA A  75      -1.060  70.711  54.095  1.00 79.21           O  
ATOM    529  CB  ALA A  75      -2.759  71.142  51.538  1.00 45.89           C  
ATOM    530  N   SER A  76      -2.962  69.578  54.456  1.00 57.64           N  
ATOM    531  CA  SER A  76      -2.326  68.607  55.331  1.00 55.55           C  
ATOM    532  C   SER A  76      -2.077  67.301  54.575  1.00 54.96           C  
ATOM    533  O   SER A  76      -2.718  67.028  53.557  1.00 54.44           O  
ATOM    534  CB  SER A  76      -3.225  68.317  56.529  1.00 45.72           C  
ATOM    535  OG  SER A  76      -4.417  67.674  56.106  1.00 44.02           O  
ATOM    536  N   ASP A  77      -1.152  66.496  55.079  1.00 52.96           N  
ATOM    537  CA  ASP A  77      -0.869  65.215  54.461  1.00 54.80           C  
ATOM    538  C   ASP A  77      -2.178  64.466  54.199  1.00 55.25           C  
ATOM    539  O   ASP A  77      -2.331  63.805  53.180  1.00 55.18           O  
ATOM    540  CB  ASP A  77       0.035  64.383  55.369  1.00 56.91           C  
ATOM    541  CG  ASP A  77       1.433  64.977  55.502  1.00 56.70           C  
ATOM    542  OD1 ASP A  77       1.659  66.109  55.009  1.00 54.32           O  
ATOM    543  OD2 ASP A  77       2.304  64.303  56.102  1.00 56.67           O  
ATOM    544  N   GLU A  78      -3.129  64.594  55.116  1.00 60.26           N  
ATOM    545  CA  GLU A  78      -4.414  63.927  54.972  1.00 60.88           C  
ATOM    546  C   GLU A  78      -5.068  64.352  53.669  1.00 57.57           C  
ATOM    547  O   GLU A  78      -5.456  63.516  52.870  1.00 56.83           O  
ATOM    548  CB  GLU A  78      -5.348  64.274  56.138  1.00123.75           C  
ATOM    549  CG  GLU A  78      -4.802  63.977  57.532  1.00131.71           C  
ATOM    550  CD  GLU A  78      -3.721  64.959  57.974  1.00134.75           C  
ATOM    551  OE1 GLU A  78      -2.565  64.839  57.519  1.00134.70           O  
ATOM    552  OE2 GLU A  78      -4.035  65.862  58.776  1.00136.53           O  
ATOM    553  N   GLU A  79      -5.194  65.656  53.460  1.00 50.93           N  
ATOM    554  CA  GLU A  79      -5.818  66.163  52.243  1.00 49.44           C  
ATOM    555  C   GLU A  79      -4.979  65.824  51.003  1.00 47.33           C  
ATOM    556  O   GLU A  79      -5.523  65.562  49.915  1.00 45.46           O  
ATOM    557  CB  GLU A  79      -5.990  67.668  52.338  1.00 52.49           C  
ATOM    558  CG  GLU A  79      -6.572  68.115  53.644  1.00 56.94           C  
ATOM    559  CD  GLU A  79      -6.478  69.599  53.800  1.00 59.40           C  
ATOM    560  OE1 GLU A  79      -7.437  70.312  53.417  1.00 58.61           O  
ATOM    561  OE2 GLU A  79      -5.416  70.046  54.283  1.00 62.38           O  
ATOM    562  N   ILE A  80      -3.659  65.843  51.184  1.00 39.59           N  
ATOM    563  CA  ILE A  80      -2.738  65.534  50.111  1.00 39.23           C  
ATOM    564  C   ILE A  80      -2.830  64.068  49.706  1.00 39.31           C  
ATOM    565  O   ILE A  80      -2.750  63.748  48.531  1.00 39.66           O  
ATOM    566  CB  ILE A  80      -1.291  65.886  50.502  1.00 41.17           C  
ATOM    567  CG1 ILE A  80      -1.119  67.411  50.498  1.00 39.22           C  
ATOM    568  CG2 ILE A  80      -0.309  65.237  49.539  1.00 38.85           C  
ATOM    569  CD1 ILE A  80       0.210  67.867  51.068  1.00 37.66           C  
ATOM    570  N   PHE A  81      -3.001  63.167  50.659  1.00 45.39           N  
ATOM    571  CA  PHE A  81      -3.112  61.784  50.263  1.00 47.91           C  
ATOM    572  C   PHE A  81      -4.452  61.523  49.605  1.00 46.16           C  
ATOM    573  O   PHE A  81      -4.543  60.721  48.683  1.00 48.18           O  
ATOM    574  CB  PHE A  81      -2.900  60.843  51.434  1.00 84.84           C  
ATOM    575  CG  PHE A  81      -1.668  60.013  51.289  1.00 93.33           C  
ATOM    576  CD1 PHE A  81      -0.415  60.559  51.541  1.00 95.66           C  
ATOM    577  CD2 PHE A  81      -1.750  58.707  50.819  1.00 96.58           C  
ATOM    578  CE1 PHE A  81       0.738  59.818  51.324  1.00 97.51           C  
ATOM    579  CE2 PHE A  81      -0.604  57.955  50.598  1.00 98.56           C  
ATOM    580  CZ  PHE A  81       0.643  58.509  50.850  1.00 99.16           C  
ATOM    581  N   GLU A  82      -5.491  62.212  50.058  1.00 46.39           N  
ATOM    582  CA  GLU A  82      -6.810  62.037  49.460  1.00 47.53           C  
ATOM    583  C   GLU A  82      -6.740  62.481  48.000  1.00 44.49           C  
ATOM    584  O   GLU A  82      -7.466  61.965  47.146  1.00 43.69           O  
ATOM    585  CB  GLU A  82      -7.884  62.840  50.227  1.00 45.00           C  
ATOM    586  CG  GLU A  82      -8.554  62.042  51.321  1.00 48.73           C  
ATOM    587  CD  GLU A  82      -9.526  62.869  52.158  1.00 52.13           C  
ATOM    588  OE1 GLU A  82     -10.468  63.475  51.581  1.00 53.40           O  
ATOM    589  OE2 GLU A  82      -9.345  62.906  53.399  1.00 50.49           O  
ATOM    590  N   ALA A  83      -5.853  63.430  47.720  1.00 38.84           N  
ATOM    591  CA  ALA A  83      -5.676  63.912  46.353  1.00 39.03           C  
ATOM    592  C   ALA A  83      -4.863  62.884  45.564  1.00 37.28           C  
ATOM    593  O   ALA A  83      -5.192  62.536  44.424  1.00 36.41           O  
ATOM    594  CB  ALA A  83      -4.954  65.255  46.356  1.00 55.23           C  
ATOM    595  N   LEU A  84      -3.811  62.383  46.189  1.00 38.67           N  
ATOM    596  CA  LEU A  84      -2.962  61.418  45.533  1.00 39.70           C  
ATOM    597  C   LEU A  84      -3.719  60.143  45.161  1.00 39.23           C  
ATOM    598  O   LEU A  84      -3.538  59.624  44.058  1.00 40.35           O  
ATOM    599  CB  LEU A  84      -1.720  61.122  46.412  1.00 39.38           C  
ATOM    600  CG  LEU A  84      -0.812  62.360  46.571  1.00 37.26           C  
ATOM    601  CD1 LEU A  84       0.428  62.043  47.376  1.00 38.85           C  
ATOM    602  CD2 LEU A  84      -0.400  62.848  45.205  1.00 36.85           C  
ATOM    603  N   ASP A  85      -4.575  59.638  46.050  1.00 34.83           N  
ATOM    604  CA  ASP A  85      -5.321  58.421  45.735  1.00 31.50           C  
ATOM    605  C   ASP A  85      -6.137  58.594  44.487  1.00 29.85           C  
ATOM    606  O   ASP A  85      -6.334  57.647  43.728  1.00 26.17           O  
ATOM    607  CB  ASP A  85      -6.271  58.012  46.865  1.00 46.48           C  
ATOM    608  CG  ASP A  85      -5.541  57.468  48.063  1.00 48.57           C  
ATOM    609  OD1 ASP A  85      -4.399  57.000  47.886  1.00 50.75           O  
ATOM    610  OD2 ASP A  85      -6.112  57.499  49.174  1.00 52.49           O  
ATOM    611  N   ILE A  86      -6.681  59.786  44.291  1.00 28.78           N  
ATOM    612  CA  ILE A  86      -7.445  60.002  43.079  1.00 29.13           C  
ATOM    613  C   ILE A  86      -6.501  59.825  41.858  1.00 28.68           C  
ATOM    614  O   ILE A  86      -6.818  59.132  40.877  1.00 26.73           O  
ATOM    615  CB  ILE A  86      -8.082  61.402  43.109  1.00 30.59           C  
ATOM    616  CG1 ILE A  86      -9.283  61.372  44.073  1.00 32.05           C  
ATOM    617  CG2 ILE A  86      -8.530  61.817  41.711  1.00 31.24           C  
ATOM    618  CD1 ILE A  86      -9.938  62.712  44.321  1.00 30.08           C  
ATOM    619  N   ALA A  87      -5.316  60.424  41.954  1.00 29.67           N  
ATOM    620  CA  ALA A  87      -4.348  60.330  40.893  1.00 30.45           C  
ATOM    621  C   ALA A  87      -3.957  58.892  40.666  1.00 32.60           C  
ATOM    622  O   ALA A  87      -3.837  58.488  39.537  1.00 31.60           O  
ATOM    623  CB  ALA A  87      -3.132  61.130  41.218  1.00 25.63           C  
ATOM    624  N   LEU A  88      -3.759  58.131  41.739  1.00 40.43           N  
ATOM    625  CA  LEU A  88      -3.347  56.732  41.640  1.00 41.48           C  
ATOM    626  C   LEU A  88      -4.332  55.886  40.857  1.00 43.36           C  
ATOM    627  O   LEU A  88      -3.956  55.119  39.972  1.00 45.58           O  
ATOM    628  CB  LEU A  88      -3.229  56.115  43.023  1.00 41.24           C  
ATOM    629  CG  LEU A  88      -2.126  55.089  43.320  1.00 45.18           C  
ATOM    630  CD1 LEU A  88      -2.520  54.337  44.605  1.00 42.49           C  
ATOM    631  CD2 LEU A  88      -1.909  54.129  42.177  1.00 44.15           C  
ATOM    632  N   VAL A  89      -5.599  56.019  41.207  1.00 37.98           N  
ATOM    633  CA  VAL A  89      -6.657  55.249  40.580  1.00 36.54           C  
ATOM    634  C   VAL A  89      -6.918  55.623  39.136  1.00 36.08           C  
ATOM    635  O   VAL A  89      -7.103  54.759  38.276  1.00 35.68           O  
ATOM    636  CB  VAL A  89      -7.963  55.411  41.368  1.00 36.49           C  
ATOM    637  CG1 VAL A  89      -9.119  54.780  40.611  1.00 37.67           C  
ATOM    638  CG2 VAL A  89      -7.807  54.767  42.740  1.00 36.50           C  
ATOM    639  N   VAL A  90      -6.963  56.920  38.876  1.00 32.27           N  
ATOM    640  CA  VAL A  90      -7.210  57.391  37.541  1.00 31.13           C  
ATOM    641  C   VAL A  90      -6.001  57.135  36.654  1.00 31.95           C  
ATOM    642  O   VAL A  90      -6.140  56.536  35.587  1.00 28.59           O  
ATOM    643  CB  VAL A  90      -7.569  58.866  37.583  1.00 33.66           C  
ATOM    644  CG1 VAL A  90      -7.787  59.407  36.177  1.00 28.74           C  
ATOM    645  CG2 VAL A  90      -8.839  59.008  38.397  1.00 31.57           C  
ATOM    646  N   GLY A  91      -4.819  57.550  37.125  1.00 38.87           N  
ATOM    647  CA  GLY A  91      -3.576  57.367  36.388  1.00 38.13           C  
ATOM    648  C   GLY A  91      -3.105  55.930  36.305  1.00 40.07           C  
ATOM    649  O   GLY A  91      -2.421  55.545  35.362  1.00 41.91           O  
ATOM    650  N   GLY A  92      -3.481  55.129  37.295  1.00 34.65           N  
ATOM    651  CA  GLY A  92      -3.096  53.729  37.307  1.00 31.58           C  
ATOM    652  C   GLY A  92      -1.803  53.413  38.034  1.00 31.56           C  
ATOM    653  O   GLY A  92      -1.105  54.292  38.533  1.00 32.66           O  
ATOM    654  N   SER A  93      -1.473  52.135  38.080  1.00 28.09           N  
ATOM    655  CA  SER A  93      -0.275  51.661  38.748  1.00 29.73           C  
ATOM    656  C   SER A  93       1.075  52.208  38.248  1.00 29.29           C  
ATOM    657  O   SER A  93       2.067  52.132  38.972  1.00 29.11           O  
ATOM    658  CB  SER A  93      -0.286  50.126  38.729  1.00 47.47           C  
ATOM    659  OG  SER A  93       0.975  49.595  38.396  1.00 56.51           O  
ATOM    660  N   ILE A  94       1.158  52.757  37.040  1.00 34.27           N  
ATOM    661  CA  ILE A  94       2.459  53.293  36.600  1.00 36.23           C  
ATOM    662  C   ILE A  94       2.838  54.527  37.384  1.00 37.03           C  
ATOM    663  O   ILE A  94       3.986  54.954  37.333  1.00 36.17           O  
ATOM    664  CB  ILE A  94       2.535  53.676  35.063  1.00 41.09           C  
ATOM    665  CG1 ILE A  94       1.165  54.082  34.543  1.00 38.33           C  
ATOM    666  CG2 ILE A  94       3.137  52.536  34.245  1.00 38.53           C  
ATOM    667  CD1 ILE A  94       0.777  55.438  34.915  1.00 40.22           C  
ATOM    668  N   VAL A  95       1.883  55.114  38.105  1.00 46.83           N  
ATOM    669  CA  VAL A  95       2.198  56.305  38.894  1.00 46.56           C  
ATOM    670  C   VAL A  95       2.797  55.960  40.253  1.00 47.81           C  
ATOM    671  O   VAL A  95       3.346  56.834  40.915  1.00 49.28           O  
ATOM    672  CB  VAL A  95       0.963  57.208  39.152  1.00 33.30           C  
ATOM    673  CG1 VAL A  95       0.054  57.237  37.924  1.00 29.56           C  
ATOM    674  CG2 VAL A  95       0.245  56.757  40.386  1.00 28.65           C  
ATOM    675  N   ILE A  96       2.686  54.697  40.668  1.00 40.90           N  
ATOM    676  CA  ILE A  96       3.214  54.270  41.958  1.00 41.46           C  
ATOM    677  C   ILE A  96       4.660  54.665  42.228  1.00 42.32           C  
ATOM    678  O   ILE A  96       5.003  55.020  43.349  1.00 44.55           O  
ATOM    679  CB  ILE A  96       3.102  52.752  42.152  1.00 36.24           C  
ATOM    680  CG1 ILE A  96       1.646  52.376  42.359  1.00 29.56           C  
ATOM    681  CG2 ILE A  96       3.980  52.308  43.333  1.00 35.75           C  
ATOM    682  CD1 ILE A  96       1.422  50.937  42.472  1.00 31.10           C  
ATOM    683  N   PRO A  97       5.532  54.597  41.216  1.00 45.69           N  
ATOM    684  CA  PRO A  97       6.901  54.994  41.553  1.00 45.67           C  
ATOM    685  C   PRO A  97       6.954  56.486  41.899  1.00 46.94           C  
ATOM    686  O   PRO A  97       7.693  56.909  42.801  1.00 46.88           O  
ATOM    687  CB  PRO A  97       7.681  54.656  40.282  1.00 37.00           C  
ATOM    688  CG  PRO A  97       6.881  53.487  39.703  1.00 36.90           C  
ATOM    689  CD  PRO A  97       5.470  53.973  39.881  1.00 36.17           C  
ATOM    690  N   HIS A  98       6.167  57.277  41.176  1.00 39.80           N  
ATOM    691  CA  HIS A  98       6.124  58.713  41.417  1.00 41.95           C  
ATOM    692  C   HIS A  98       5.342  59.013  42.686  1.00 42.32           C  
ATOM    693  O   HIS A  98       5.428  60.120  43.224  1.00 39.36           O  
ATOM    694  CB  HIS A  98       5.462  59.445  40.260  1.00 47.64           C  
ATOM    695  CG  HIS A  98       6.094  59.169  38.941  1.00 52.00           C  
ATOM    696  ND1 HIS A  98       6.076  57.918  38.357  1.00 51.86           N  
ATOM    697  CD2 HIS A  98       6.770  59.978  38.094  1.00 51.57           C  
ATOM    698  CE1 HIS A  98       6.719  57.971  37.206  1.00 56.84           C  
ATOM    699  NE2 HIS A  98       7.150  59.209  37.022  1.00 56.14           N  
ATOM    700  N   LEU A  99       4.541  58.046  43.128  1.00 41.47           N  
ATOM    701  CA  LEU A  99       3.771  58.227  44.350  1.00 44.55           C  
ATOM    702  C   LEU A  99       4.812  58.090  45.456  1.00 45.24           C  
ATOM    703  O   LEU A  99       4.864  58.890  46.381  1.00 43.35           O  
ATOM    704  CB  LEU A  99       2.693  57.152  44.486  1.00 50.40           C  
ATOM    705  CG  LEU A  99       1.743  57.370  45.660  1.00 52.26           C  
ATOM    706  CD1 LEU A  99       0.987  58.676  45.467  1.00 53.87           C  
ATOM    707  CD2 LEU A  99       0.779  56.202  45.756  1.00 53.64           C  
ATOM    708  N   ARG A 100       5.663  57.083  45.313  1.00 50.58           N  
ATOM    709  CA  ARG A 100       6.734  56.837  46.254  1.00 53.76           C  
ATOM    710  C   ARG A 100       7.503  58.122  46.497  1.00 54.14           C  
ATOM    711  O   ARG A 100       7.434  58.697  47.575  1.00 55.67           O  
ATOM    712  CB  ARG A 100       7.671  55.755  45.704  1.00 55.78           C  
ATOM    713  CG  ARG A 100       7.443  54.390  46.355  1.00 58.88           C  
ATOM    714  CD  ARG A 100       7.184  53.267  45.368  1.00 61.10           C  
ATOM    715  NE  ARG A 100       8.363  52.922  44.580  1.00 63.52           N  
ATOM    716  CZ  ARG A 100       8.409  51.887  43.751  1.00 63.53           C  
ATOM    717  NH1 ARG A 100       7.340  51.113  43.625  1.00 63.36           N  
ATOM    718  NH2 ARG A 100       9.505  51.638  43.039  1.00 65.04           N  
ATOM    719  N   ARG A 101       8.227  58.566  45.482  1.00 56.17           N  
ATOM    720  CA  ARG A 101       9.009  59.796  45.559  1.00 56.80           C  
ATOM    721  C   ARG A 101       8.216  61.031  46.007  1.00 56.60           C  
ATOM    722  O   ARG A 101       8.794  62.040  46.402  1.00 57.16           O  
ATOM    723  CB  ARG A 101       9.667  60.080  44.199  1.00 57.91           C  
ATOM    724  CG  ARG A 101      10.696  59.035  43.782  1.00 60.84           C  
ATOM    725  CD  ARG A 101      11.441  59.435  42.514  1.00 62.96           C  
ATOM    726  NE  ARG A 101      10.612  59.325  41.314  1.00 65.14           N  
ATOM    727  CZ  ARG A 101      10.369  58.188  40.665  1.00 65.49           C  
ATOM    728  NH1 ARG A 101      10.894  57.046  41.096  1.00 66.15           N  
ATOM    729  NH2 ARG A 101       9.599  58.191  39.583  1.00 65.19           N  
ATOM    730  N   ALA A 102       6.897  60.980  45.932  1.00 54.84           N  
ATOM    731  CA  ALA A 102       6.113  62.126  46.359  1.00 55.94           C  
ATOM    732  C   ALA A 102       6.006  62.072  47.875  1.00 58.07           C  
ATOM    733  O   ALA A 102       6.198  63.085  48.569  1.00 56.14           O  
ATOM    734  CB  ALA A 102       4.737  62.078  45.752  1.00 41.50           C  
ATOM    735  N   VAL A 103       5.688  60.878  48.373  1.00 65.05           N  
ATOM    736  CA  VAL A 103       5.548  60.641  49.798  1.00 66.33           C  
ATOM    737  C   VAL A 103       6.874  60.926  50.497  1.00 67.91           C  
ATOM    738  O   VAL A 103       6.906  61.611  51.517  1.00 69.25           O  
ATOM    739  CB  VAL A 103       5.101  59.187  50.065  1.00 56.18           C  
ATOM    740  CG1 VAL A 103       5.216  58.862  51.538  1.00 54.10           C  
ATOM    741  CG2 VAL A 103       3.649  58.995  49.594  1.00 54.70           C  
ATOM    742  N   GLY A 104       7.966  60.413  49.939  1.00 66.07           N  
ATOM    743  CA  GLY A 104       9.272  60.647  50.528  1.00 68.04           C  
ATOM    744  C   GLY A 104       9.637  62.123  50.543  1.00 70.51           C  
ATOM    745  O   GLY A 104      10.306  62.603  51.458  1.00 71.44           O  
ATOM    746  N   PHE A 105       9.193  62.855  49.530  1.00 71.13           N  
ATOM    747  CA  PHE A 105       9.482  64.284  49.433  1.00 73.42           C  
ATOM    748  C   PHE A 105       8.656  65.047  50.470  1.00 74.89           C  
ATOM    749  O   PHE A 105       9.166  65.930  51.163  1.00 74.99           O  
ATOM    750  CB  PHE A 105       9.124  64.785  48.032  1.00 77.05           C  
ATOM    751  CG  PHE A 105       9.609  66.182  47.727  1.00 77.63           C  
ATOM    752  CD1 PHE A 105      10.826  66.387  47.082  1.00 77.91           C  
ATOM    753  CD2 PHE A 105       8.835  67.291  48.052  1.00 78.00           C  
ATOM    754  CE1 PHE A 105      11.263  67.672  46.761  1.00 76.76           C  
ATOM    755  CE2 PHE A 105       9.267  68.582  47.735  1.00 76.88           C  
ATOM    756  CZ  PHE A 105      10.482  68.768  47.087  1.00 76.35           C  
ATOM    757  N   LEU A 106       7.378  64.692  50.575  1.00 68.63           N  
ATOM    758  CA  LEU A 106       6.470  65.368  51.500  1.00 69.56           C  
ATOM    759  C   LEU A 106       6.952  65.378  52.939  1.00 71.66           C  
ATOM    760  O   LEU A 106       7.056  66.443  53.536  1.00 70.15           O  
ATOM    761  CB  LEU A 106       5.073  64.748  51.438  1.00 47.27           C  
ATOM    762  CG  LEU A 106       4.002  65.371  52.346  1.00 46.59           C  
ATOM    763  CD1 LEU A 106       3.926  66.890  52.134  1.00 46.14           C  
ATOM    764  CD2 LEU A 106       2.655  64.726  52.045  1.00 45.42           C  
ATOM    765  N   GLU A 107       7.239  64.200  53.490  1.00115.79           N  
ATOM    766  CA  GLU A 107       7.702  64.095  54.872  1.00118.82           C  
ATOM    767  C   GLU A 107       9.077  64.729  55.038  1.00119.94           C  
ATOM    768  O   GLU A 107       9.569  64.901  56.153  1.00121.61           O  
ATOM    769  CB  GLU A 107       7.732  62.631  55.320  1.00103.37           C  
ATOM    770  CG  GLU A 107       8.840  61.789  54.727  1.00104.26           C  
ATOM    771  CD  GLU A 107       8.718  60.324  55.113  1.00105.43           C  
ATOM    772  OE1 GLU A 107       9.676  59.560  54.863  1.00105.85           O  
ATOM    773  OE2 GLU A 107       7.662  59.933  55.659  1.00103.22           O  
ATOM    774  N   GLU A 108       9.690  65.077  53.915  1.00 75.35           N  
ATOM    775  CA  GLU A 108      10.991  65.722  53.920  1.00 76.72           C  
ATOM    776  C   GLU A 108      10.730  67.212  54.140  1.00 75.93           C  
ATOM    777  O   GLU A 108      11.620  67.969  54.535  1.00 75.44           O  
ATOM    778  CB  GLU A 108      11.691  65.487  52.578  1.00115.38           C  
ATOM    779  CG  GLU A 108      13.173  65.822  52.564  1.00117.84           C  
ATOM    780  CD  GLU A 108      13.849  65.406  51.271  1.00120.15           C  
ATOM    781  OE1 GLU A 108      13.726  64.222  50.888  1.00120.34           O  
ATOM    782  OE2 GLU A 108      14.507  66.259  50.637  1.00120.82           O  
ATOM    783  N   LEU A 109       9.489  67.620  53.882  1.00 73.32           N  
ATOM    784  CA  LEU A 109       9.068  69.004  54.059  1.00 73.77           C  
ATOM    785  C   LEU A 109       8.411  69.163  55.426  1.00 75.58           C  
ATOM    786  O   LEU A 109       8.128  70.278  55.866  1.00 74.96           O  
ATOM    787  CB  LEU A 109       8.077  69.413  52.969  1.00 66.61           C  
ATOM    788  CG  LEU A 109       8.573  69.566  51.528  1.00 65.53           C  
ATOM    789  CD1 LEU A 109       7.378  69.872  50.624  1.00 64.36           C  
ATOM    790  CD2 LEU A 109       9.616  70.680  51.434  1.00 63.61           C  
ATOM    791  N   ARG A 110       8.156  68.037  56.086  1.00117.88           N  
ATOM    792  CA  ARG A 110       7.556  68.055  57.413  1.00119.65           C  
ATOM    793  C   ARG A 110       8.673  67.836  58.432  1.00123.14           C  
ATOM    794  O   ARG A 110       8.533  68.136  59.617  1.00123.91           O  
ATOM    795  CB  ARG A 110       6.462  66.984  57.519  1.00 72.35           C  
ATOM    796  CG  ARG A 110       5.263  67.273  56.614  1.00 68.52           C  
ATOM    797  CD  ARG A 110       4.858  68.760  56.675  1.00 65.47           C  
ATOM    798  NE  ARG A 110       3.724  69.083  55.809  1.00 62.89           N  
ATOM    799  CZ  ARG A 110       2.502  68.581  55.957  1.00 61.96           C  
ATOM    800  NH1 ARG A 110       2.256  67.732  56.946  1.00 62.53           N  
ATOM    801  NH2 ARG A 110       1.528  68.912  55.115  1.00 60.10           N  
ATOM    802  N   GLU A 111       9.790  67.314  57.938  1.00100.63           N  
ATOM    803  CA  GLU A 111      10.981  67.093  58.743  1.00103.57           C  
ATOM    804  C   GLU A 111      11.867  68.291  58.404  1.00104.77           C  
ATOM    805  O   GLU A 111      13.094  68.218  58.425  1.00106.36           O  
ATOM    806  CB  GLU A 111      11.660  65.780  58.331  1.00157.86           C  
ATOM    807  CG  GLU A 111      13.045  65.534  58.936  1.00160.14           C  
ATOM    808  CD  GLU A 111      13.041  65.484  60.454  1.00161.64           C  
ATOM    809  OE1 GLU A 111      12.725  66.513  61.089  1.00162.32           O  
ATOM    810  OE2 GLU A 111      13.360  64.413  61.013  1.00162.16           O  
ATOM    811  N   MET A 112      11.210  69.399  58.075  1.00 82.77           N  
ATOM    812  CA  MET A 112      11.893  70.630  57.712  1.00 84.88           C  
ATOM    813  C   MET A 112      11.076  71.838  58.148  1.00 86.37           C  
ATOM    814  O   MET A 112      11.593  72.717  58.836  1.00 86.37           O  
ATOM    815  CB  MET A 112      12.124  70.681  56.201  1.00110.55           C  
ATOM    816  CG  MET A 112      12.849  71.932  55.725  1.00111.07           C  
ATOM    817  SD  MET A 112      13.020  72.012  53.928  1.00113.01           S  
ATOM    818  CE  MET A 112      11.764  73.263  53.495  1.00112.03           C  
ATOM    819  N   GLU A 113       9.808  71.892  57.744  1.00121.90           N  
ATOM    820  CA  GLU A 113       8.953  73.012  58.125  1.00123.87           C  
ATOM    821  C   GLU A 113       8.768  72.951  59.637  1.00125.55           C  
ATOM    822  O   GLU A 113       8.465  73.961  60.276  1.00126.03           O  
ATOM    823  CB  GLU A 113       7.581  72.934  57.440  1.00 89.72           C  
ATOM    824  CG  GLU A 113       6.602  71.965  58.111  1.00 89.96           C  
ATOM    825  CD  GLU A 113       5.136  72.336  57.899  1.00 89.63           C  
ATOM    826  OE1 GLU A 113       4.264  71.658  58.489  1.00 89.50           O  
ATOM    827  OE2 GLU A 113       4.856  73.298  57.151  1.00 88.70           O  
ATOM    828  N   LYS A 114       8.945  71.755  60.195  1.00123.08           N  
ATOM    829  CA  LYS A 114       8.820  71.537  61.633  1.00124.46           C  
ATOM    830  C   LYS A 114       9.883  72.365  62.348  1.00125.12           C  
ATOM    831  O   LYS A 114       9.599  73.055  63.328  1.00125.36           O  
ATOM    832  CB  LYS A 114       9.001  70.048  61.960  1.00131.62           C  
ATOM    833  CG  LYS A 114       9.215  69.734  63.443  1.00132.19           C  
ATOM    834  CD  LYS A 114       7.995  70.047  64.312  1.00132.73           C  
ATOM    835  CE  LYS A 114       6.896  68.999  64.167  1.00133.00           C  
ATOM    836  NZ  LYS A 114       5.781  69.225  65.134  1.00131.75           N  
ATOM    837  N   ASN A 115      11.110  72.292  61.843  1.00122.48           N  
ATOM    838  CA  ASN A 115      12.220  73.037  62.417  1.00123.33           C  
ATOM    839  C   ASN A 115      12.247  74.452  61.855  1.00123.78           C  
ATOM    840  O   ASN A 115      13.314  75.017  61.621  1.00123.93           O  
ATOM    841  CB  ASN A 115      13.535  72.327  62.112  1.00129.92           C  
ATOM    842  CG  ASN A 115      13.604  70.950  62.732  1.00130.07           C  
ATOM    843  OD1 ASN A 115      12.756  70.095  62.471  1.00130.00           O  
ATOM    844  ND2 ASN A 115      14.616  70.727  63.561  1.00130.58           N  
ATOM    845  N   GLY A 116      11.058  75.010  61.638  1.00159.66           N  
ATOM    846  CA  GLY A 116      10.930  76.356  61.108  1.00159.88           C  
ATOM    847  C   GLY A 116      11.876  76.692  59.972  1.00159.84           C  
ATOM    848  O   GLY A 116      13.022  77.077  60.211  1.00160.66           O  
ATOM    849  N   GLU A 117      11.406  76.555  58.736  1.00131.90           N  
ATOM    850  CA  GLU A 117      12.239  76.862  57.580  1.00131.31           C  
ATOM    851  C   GLU A 117      11.412  77.281  56.363  1.00131.22           C  
ATOM    852  O   GLU A 117      10.389  76.669  56.051  1.00131.30           O  
ATOM    853  CB  GLU A 117      13.121  75.659  57.232  1.00111.80           C  
ATOM    854  CG  GLU A 117      14.261  75.996  56.278  1.00111.12           C  
ATOM    855  CD  GLU A 117      15.276  74.875  56.149  1.00111.33           C  
ATOM    856  OE1 GLU A 117      16.321  75.094  55.496  1.00111.90           O  
ATOM    857  OE2 GLU A 117      15.034  73.777  56.696  1.00111.44           O  
ATOM    858  N   THR A 118      11.871  78.332  55.686  1.00129.21           N  
ATOM    859  CA  THR A 118      11.197  78.870  54.507  1.00129.17           C  
ATOM    860  C   THR A 118      11.091  77.846  53.383  1.00128.45           C  
ATOM    861  O   THR A 118      11.875  76.899  53.308  1.00128.25           O  
ATOM    862  CB  THR A 118      11.933  80.127  53.962  1.00142.17           C  
ATOM    863  OG1 THR A 118      12.015  81.121  54.989  1.00142.35           O  
ATOM    864  CG2 THR A 118      11.190  80.718  52.768  1.00141.72           C  
ATOM    865  N   ILE A 119      10.109  78.053  52.512  1.00119.46           N  
ATOM    866  CA  ILE A 119       9.871  77.178  51.373  1.00118.64           C  
ATOM    867  C   ILE A 119       9.519  78.057  50.163  1.00119.26           C  
ATOM    868  O   ILE A 119       8.465  78.694  50.132  1.00118.72           O  
ATOM    869  CB  ILE A 119       8.716  76.186  51.687  1.00 78.37           C  
ATOM    870  CG1 ILE A 119       9.065  75.365  52.937  1.00 77.41           C  
ATOM    871  CG2 ILE A 119       8.491  75.252  50.504  1.00 78.42           C  
ATOM    872  CD1 ILE A 119       7.943  74.469  53.446  1.00 76.71           C  
ATOM    873  N   SER A 120      10.414  78.095  49.177  1.00153.06           N  
ATOM    874  CA  SER A 120      10.224  78.905  47.968  1.00153.74           C  
ATOM    875  C   SER A 120       8.932  78.586  47.212  1.00154.20           C  
ATOM    876  O   SER A 120       8.143  77.759  47.715  1.00154.16           O  
ATOM    877  CB  SER A 120      11.427  78.734  47.028  1.00139.56           C  
ATOM    878  OG  SER A 120      11.345  79.599  45.904  1.00139.46           O  
TER     879      SER A 120                                                      
END
MOLECULE T0408.pdb
ATOM    769  N   PHE     7       8.970  79.991  40.219  1.00 59.01           N  
ATOM    770  CA  PHE     7       9.121  78.887  39.220  1.00 58.55           C  
ATOM    771  C   PHE     7      10.525  78.270  39.318  1.00 57.17           C  
ATOM    772  O   PHE     7      11.448  78.885  39.884  1.00 59.33           O  
ATOM    773  CB  PHE     7       8.894  79.403  37.792  1.00 59.50           C  
ATOM    774  CG  PHE     7       7.630  80.211  37.607  1.00 59.88           C  
ATOM    775  CD1 PHE     7       7.640  81.590  37.779  1.00 59.55           C  
ATOM    776  CD2 PHE     7       6.441  79.594  37.219  1.00 60.26           C  
ATOM    777  CE1 PHE     7       6.481  82.338  37.600  1.00 63.27           C  
ATOM    778  CE2 PHE     7       5.280  80.335  37.027  1.00 57.96           C  
ATOM    779  CZ  PHE     7       5.299  81.709  37.222  1.00 60.10           C  
ATOM    780  N   GLY     8      10.693  77.077  38.739  1.00 51.97           N  
ATOM    781  CA  GLY     8      11.946  76.308  38.864  1.00 47.06           C  
ATOM    782  C   GLY     8      13.010  76.644  37.842  1.00 42.74           C  
ATOM    783  O   GLY     8      12.960  77.691  37.199  1.00 40.60           O  
ATOM    784  N   GLU     9      13.969  75.734  37.690  1.00 39.01           N  
ATOM    785  CA  GLU     9      15.125  75.924  36.812  1.00 38.04           C  
ATOM    786  C   GLU     9      14.737  76.079  35.344  1.00 34.61           C  
ATOM    787  O   GLU     9      15.312  76.893  34.624  1.00 33.70           O  
ATOM    788  CB  GLU     9      16.093  74.746  36.964  1.00 38.65           C  
ATOM    789  N   GLY    10      13.750  75.287  34.915  1.00 34.19           N  
ATOM    790  CA  GLY    10      13.250  75.348  33.551  1.00 31.10           C  
ATOM    791  C   GLY    10      12.790  76.744  33.220  1.00 25.97           C  
ATOM    792  O   GLY    10      13.200  77.304  32.203  1.00 24.44           O  
ATOM    793  N   MET    11      11.958  77.314  34.091  1.00 26.78           N  
ATOM    794  CA  MET    11      11.453  78.679  33.871  1.00 26.99           C  
ATOM    795  C   MET    11      12.547  79.734  33.936  1.00 24.54           C  
ATOM    796  O   MET    11      12.436  80.750  33.237  1.00 22.59           O  
ATOM    797  CB  MET    11      10.298  79.036  34.809  1.00 26.96           C  
ATOM    798  CG  MET    11       8.956  78.424  34.384  1.00 30.81           C  
ATOM    799  SD  MET    11       8.363  79.163  32.682  0.75 32.36          SE  
ATOM    800  CE  MET    11       7.641  80.815  33.439  1.00 38.14           C  
ATOM    801  N   LYS    12      13.587  79.531  34.749  1.00 22.58           N  
ATOM    802  CA  LYS    12      14.709  80.488  34.749  1.00 22.98           C  
ATOM    803  C   LYS    12      15.471  80.468  33.411  1.00 20.97           C  
ATOM    804  O   LYS    12      15.931  81.507  32.944  1.00 22.83           O  
ATOM    805  CB  LYS    12      15.656  80.233  35.932  1.00 24.68           C  
ATOM    806  CG  LYS    12      14.987  80.568  37.290  1.00 26.05           C  
ATOM    807  CD  LYS    12      15.724  79.996  38.524  1.00 31.53           C  
ATOM    808  CE  LYS    12      17.178  80.177  38.487  1.00 33.33           C  
ATOM    809  NZ  LYS    12      17.857  79.899  39.811  1.00 35.75           N  
ATOM    810  N   VAL    13      15.558  79.292  32.784  1.00 23.05           N  
ATOM    811  CA  VAL    13      16.174  79.143  31.455  1.00 22.27           C  
ATOM    812  C   VAL    13      15.338  79.931  30.437  1.00 19.87           C  
ATOM    813  O   VAL    13      15.870  80.675  29.599  1.00 19.37           O  
ATOM    814  CB  VAL    13      16.227  77.631  31.026  1.00 24.12           C  
ATOM    815  CG1 VAL    13      16.716  77.489  29.584  1.00 25.29           C  
ATOM    816  CG2 VAL    13      17.136  76.836  31.979  1.00 30.23           C  
ATOM    817  N   VAL    14      14.032  79.817  30.576  1.00 20.72           N  
ATOM    818  CA  VAL    14      13.119  80.535  29.668  1.00 22.65           C  
ATOM    819  C   VAL    14      13.274  82.037  29.865  1.00 19.62           C  
ATOM    820  O   VAL    14      13.348  82.784  28.895  1.00 20.37           O  
ATOM    821  CB  VAL    14      11.657  80.121  29.823  1.00 21.69           C  
ATOM    822  CG1 VAL    14      10.788  80.938  28.849  1.00 21.74           C  
ATOM    823  CG2 VAL    14      11.465  78.585  29.542  1.00 26.25           C  
ATOM    824  N   LYS    15      13.332  82.483  31.131  1.00 21.22           N  
ATOM    825  CA  LYS    15      13.580  83.912  31.414  1.00 18.46           C  
ATOM    826  C   LYS    15      14.866  84.401  30.767  1.00 19.65           C  
ATOM    827  O   LYS    15      14.894  85.480  30.187  1.00 22.14           O  
ATOM    828  CB  LYS    15      13.617  84.181  32.921  1.00 18.27           C  
ATOM    829  N   GLU    16      15.918  83.608  30.857  1.00 21.08           N  
ATOM    830  CA  GLU    16      17.202  83.950  30.227  1.00 22.56           C  
ATOM    831  C   GLU    16      17.144  83.974  28.678  1.00 22.82           C  
ATOM    832  O   GLU    16      17.665  84.891  28.042  1.00 28.47           O  
ATOM    833  CB  GLU    16      18.277  82.981  30.693  1.00 24.31           C  
ATOM    834  N   LYS    17      16.521  82.963  28.097  1.00 21.86           N  
ATOM    835  CA  LYS    17      16.542  82.770  26.636  1.00 22.20           C  
ATOM    836  C   LYS    17      15.493  83.586  25.851  1.00 21.86           C  
ATOM    837  O   LYS    17      15.808  84.146  24.776  1.00 23.86           O  
ATOM    838  CB  LYS    17      16.365  81.277  26.315  1.00 21.29           C  
ATOM    839  N   TYR    18      14.290  83.672  26.407  1.00 22.99           N  
ATOM    840  CA  TYR    18      13.084  84.212  25.724  1.00 24.08           C  
ATOM    841  C   TYR    18      12.235  85.030  26.691  1.00 21.96           C  
ATOM    842  O   TYR    18      11.217  84.579  27.196  1.00 21.62           O  
ATOM    843  CB  TYR    18      12.270  83.071  25.102  1.00 23.86           C  
ATOM    844  CG  TYR    18      13.142  82.276  24.153  1.00 25.16           C  
ATOM    845  CD1 TYR    18      13.658  82.867  23.007  1.00 22.60           C  
ATOM    846  CD2 TYR    18      13.503  80.967  24.432  1.00 27.55           C  
ATOM    847  CE1 TYR    18      14.496  82.174  22.142  1.00 26.49           C  
ATOM    848  CE2 TYR    18      14.364  80.270  23.576  1.00 26.29           C  
ATOM    849  CZ  TYR    18      14.846  80.874  22.433  1.00 25.54           C  
ATOM    850  OH  TYR    18      15.686  80.188  21.581  1.00 26.16           O  
ATOM    851  N   PRO    19      12.703  86.256  26.994  1.00 22.95           N  
ATOM    852  CA  PRO    19      12.008  87.103  27.963  1.00 20.97           C  
ATOM    853  C   PRO    19      10.540  87.377  27.666  1.00 23.47           C  
ATOM    854  O   PRO    19       9.729  87.342  28.598  1.00 22.73           O  
ATOM    855  CB  PRO    19      12.823  88.395  27.933  1.00 22.49           C  
ATOM    856  CG  PRO    19      14.111  88.033  27.370  1.00 24.22           C  
ATOM    857  CD  PRO    19      13.956  86.869  26.528  1.00 23.77           C  
ATOM    858  N   ASP    20      10.175  87.629  26.413  1.00 23.93           N  
ATOM    859  CA  ASP    20       8.772  87.917  26.104  1.00 28.48           C  
ATOM    860  C   ASP    20       7.908  86.671  26.266  1.00 26.25           C  
ATOM    861  O   ASP    20       6.756  86.723  26.775  1.00 26.13           O  
ATOM    862  CB  ASP    20       8.618  88.482  24.690  1.00 30.80           C  
ATOM    863  CG  ASP    20       9.052  89.954  24.570  1.00 38.16           C  
ATOM    864  OD1 ASP    20       9.402  90.617  25.580  1.00 42.94           O  
ATOM    865  OD2 ASP    20       9.033  90.451  23.426  1.00 46.06           O  
ATOM    866  N   LEU    21       8.444  85.524  25.878  1.00 24.97           N  
ATOM    867  CA  LEU    21       7.721  84.269  26.090  1.00 23.54           C  
ATOM    868  C   LEU    21       7.555  83.994  27.575  1.00 22.52           C  
ATOM    869  O   LEU    21       6.474  83.604  28.042  1.00 24.44           O  
ATOM    870  CB  LEU    21       8.447  83.115  25.385  1.00 23.74           C  
ATOM    871  CG  LEU    21       7.857  81.731  25.468  1.00 25.87           C  
ATOM    872  CD1 LEU    21       6.373  81.718  24.990  1.00 25.00           C  
ATOM    873  CD2 LEU    21       8.754  80.756  24.680  1.00 23.70           C  
ATOM    874  N   TYR    22       8.626  84.193  28.326  1.00 22.41           N  
ATOM    875  CA  TYR    22       8.584  84.070  29.780  1.00 22.77           C  
ATOM    876  C   TYR    22       7.435  84.913  30.380  1.00 22.67           C  
ATOM    877  O   TYR    22       6.627  84.425  31.175  1.00 23.91           O  
ATOM    878  CB  TYR    22       9.912  84.494  30.385  1.00 23.66           C  
ATOM    879  CG  TYR    22       9.886  84.492  31.893  1.00 22.50           C  
ATOM    880  CD1 TYR    22      10.074  83.325  32.604  1.00 23.27           C  
ATOM    881  CD2 TYR    22       9.660  85.671  32.602  1.00 25.67           C  
ATOM    882  CE1 TYR    22      10.047  83.327  33.987  1.00 21.18           C  
ATOM    883  CE2 TYR    22       9.622  85.671  33.963  1.00 25.00           C  
ATOM    884  CZ  TYR    22       9.808  84.488  34.647  1.00 23.45           C  
ATOM    885  OH  TYR    22       9.784  84.487  35.999  1.00 27.44           O  
ATOM    886  N   ASP    23       7.378  86.174  29.980  1.00 23.82           N  
ATOM    887  CA  ASP    23       6.360  87.088  30.502  1.00 24.16           C  
ATOM    888  C   ASP    23       4.927  86.625  30.205  1.00 25.07           C  
ATOM    889  O   ASP    23       4.046  86.754  31.064  1.00 23.28           O  
ATOM    890  CB  ASP    23       6.577  88.482  29.910  1.00 24.42           C  
ATOM    891  CG  ASP    23       7.742  89.194  30.505  1.00 33.39           C  
ATOM    892  OD1 ASP    23       8.216  88.809  31.607  1.00 34.11           O  
ATOM    893  OD2 ASP    23       8.170  90.189  29.868  1.00 37.66           O  
ATOM    894  N   ILE    24       4.693  86.066  29.019  1.00 23.65           N  
ATOM    895  CA  ILE    24       3.350  85.619  28.651  1.00 24.84           C  
ATOM    896  C   ILE    24       3.018  84.370  29.489  1.00 23.61           C  
ATOM    897  O   ILE    24       1.899  84.210  29.967  1.00 24.22           O  
ATOM    898  CB  ILE    24       3.222  85.316  27.150  1.00 27.79           C  
ATOM    899  CG1 ILE    24       3.448  86.587  26.329  1.00 32.72           C  
ATOM    900  CG2 ILE    24       1.848  84.746  26.841  1.00 30.67           C  
ATOM    901  CD1 ILE    24       3.838  86.311  24.854  1.00 35.16           C  
ATOM    902  N   ILE    25       4.024  83.514  29.707  1.00 24.35           N  
ATOM    903  CA  ILE    25       3.817  82.316  30.523  1.00 24.21           C  
ATOM    904  C   ILE    25       3.445  82.707  31.965  1.00 23.22           C  
ATOM    905  O   ILE    25       2.509  82.132  32.562  1.00 25.47           O  
ATOM    906  CB  ILE    25       5.047  81.338  30.493  1.00 24.22           C  
ATOM    907  CG1 ILE    25       5.238  80.729  29.103  1.00 23.74           C  
ATOM    908  CG2 ILE    25       4.856  80.188  31.494  1.00 29.35           C  
ATOM    909  CD1 ILE    25       6.631  80.075  28.922  1.00 23.35           C  
ATOM    910  N   VAL    26       4.144  83.697  32.511  1.00 24.58           N  
ATOM    911  CA  VAL    26       3.846  84.171  33.859  1.00 26.19           C  
ATOM    912  C   VAL    26       2.405  84.710  33.937  1.00 24.90           C  
ATOM    913  O   VAL    26       1.639  84.349  34.854  1.00 24.16           O  
ATOM    914  CB  VAL    26       4.836  85.230  34.313  1.00 28.22           C  
ATOM    915  CG1 VAL    26       4.301  85.976  35.531  1.00 28.71           C  
ATOM    916  CG2 VAL    26       6.242  84.589  34.603  1.00 26.39           C  
ATOM    917  N   LYS    27       2.006  85.523  32.967  1.00 23.37           N  
ATOM    918  CA  LYS    27       0.622  86.024  32.925  0.50 23.88           C  
ATOM    920  C   LYS    27      -0.377  84.879  32.823  1.00 24.17           C  
ATOM    921  O   LYS    27      -1.387  84.886  33.498  1.00 24.41           O  
ATOM    922  CB  LYS    27       0.414  87.028  31.779  0.50 24.31           C  
ATOM    924  CG  LYS    27       1.172  88.334  31.934  0.50 20.98           C  
ATOM    926  N   LEU    28      -0.091  83.873  31.981  1.00 23.31           N  
ATOM    927  CA  LEU    28      -0.962  82.705  31.832  1.00 25.23           C  
ATOM    928  C   LEU    28      -1.121  81.995  33.180  1.00 25.13           C  
ATOM    929  O   LEU    28      -2.231  81.653  33.640  1.00 24.63           O  
ATOM    930  CB  LEU    28      -0.374  81.739  30.788  1.00 23.04           C  
ATOM    931  CG  LEU    28      -1.148  80.428  30.624  1.00 24.78           C  
ATOM    932  CD1 LEU    28      -2.545  80.697  30.079  1.00 32.09           C  
ATOM    933  CD2 LEU    28      -0.369  79.493  29.738  1.00 28.12           C  
ATOM    934  N   ASN    29       0.023  81.773  33.828  1.00 22.56           N  
ATOM    935  CA  ASN    29       0.048  81.101  35.117  1.00 24.38           C  
ATOM    936  C   ASN    29      -0.813  81.844  36.140  1.00 22.89           C  
ATOM    937  O   ASN    29      -1.651  81.255  36.839  1.00 26.79           O  
ATOM    938  CB  ASN    29       1.491  80.993  35.606  1.00 27.63           C  
ATOM    939  CG  ASN    29       1.585  80.340  36.962  1.00 33.82           C  
ATOM    940  OD1 ASN    29       1.667  79.126  37.053  1.00 33.33           O  
ATOM    941  ND2 ASN    29       1.566  81.143  38.011  1.00 35.43           N  
ATOM    942  N   ASP    30      -0.596  83.141  36.234  1.00 22.88           N  
ATOM    943  CA  ASP    30      -1.285  83.973  37.203  1.00 24.82           C  
ATOM    944  C   ASP    30      -2.797  84.034  36.943  1.00 25.07           C  
ATOM    945  O   ASP    30      -3.601  84.001  37.880  1.00 26.99           O  
ATOM    946  CB  ASP    30      -0.694  85.365  37.193  1.00 26.68           C  
ATOM    947  CG  ASP    30       0.726  85.408  37.720  1.00 28.43           C  
ATOM    948  OD1 ASP    30       1.234  84.358  38.174  1.00 35.44           O  
ATOM    949  OD2 ASP    30       1.331  86.499  37.649  1.00 29.80           O  
ATOM    950  N   THR    31      -3.173  84.070  35.675  1.00 22.79           N  
ATOM    951  CA  THR    31      -4.600  83.984  35.289  1.00 24.26           C  
ATOM    952  C   THR    31      -5.213  82.620  35.540  1.00 23.93           C  
ATOM    953  O   THR    31      -6.339  82.515  36.082  1.00 24.83           O  
ATOM    954  CB  THR    31      -4.809  84.366  33.824  1.00 22.72           C  
ATOM    955  OG1 THR    31      -4.260  85.683  33.614  1.00 30.25           O  
ATOM    956  CG2 THR    31      -6.307  84.307  33.460  1.00 24.57           C  
ATOM    957  N   VAL    32      -4.509  81.554  35.146  1.00 22.77           N  
ATOM    958  CA  VAL    32      -4.974  80.194  35.438  1.00 24.03           C  
ATOM    959  C   VAL    32      -5.286  80.043  36.936  1.00 23.77           C  
ATOM    960  O   VAL    32      -6.329  79.469  37.304  1.00 25.63           O  
ATOM    961  CB  VAL    32      -3.924  79.174  34.994  1.00 23.98           C  
ATOM    962  CG1 VAL    32      -4.033  77.835  35.796  1.00 24.54           C  
ATOM    963  CG2 VAL    32      -4.012  78.986  33.460  1.00 22.05           C  
ATOM    964  N   PHE    33      -4.431  80.590  37.799  1.00 23.43           N  
ATOM    965  CA  PHE    33      -4.601  80.397  39.246  1.00 25.33           C  
ATOM    966  C   PHE    33      -5.403  81.502  39.922  1.00 27.87           C  
ATOM    967  O   PHE    33      -5.384  81.637  41.159  1.00 27.20           O  
ATOM    968  CB  PHE    33      -3.266  80.181  39.951  1.00 27.45           C  
ATOM    969  CG  PHE    33      -2.688  78.829  39.709  1.00 26.58           C  
ATOM    970  CD1 PHE    33      -3.361  77.688  40.124  1.00 26.58           C  
ATOM    971  CD2 PHE    33      -1.487  78.692  39.040  1.00 27.16           C  
ATOM    972  CE1 PHE    33      -2.844  76.433  39.875  1.00 26.69           C  
ATOM    973  CE2 PHE    33      -0.960  77.444  38.790  1.00 25.47           C  
ATOM    974  CZ  PHE    33      -1.643  76.315  39.204  1.00 28.16           C  
ATOM    975  N   THR    34      -6.104  82.288  39.114  1.00 28.08           N  
ATOM    976  CA  THR    34      -7.123  83.205  39.620  1.00 27.68           C  
ATOM    977  C   THR    34      -8.472  82.607  39.227  1.00 26.27           C  
ATOM    978  O   THR    34      -9.079  82.991  38.223  1.00 24.59           O  
ATOM    979  CB  THR    34      -6.912  84.630  39.078  1.00 29.15           C  
ATOM    980  OG1 THR    34      -5.572  85.039  39.354  1.00 27.52           O  
ATOM    981  CG2 THR    34      -7.858  85.624  39.752  1.00 27.57           C  
ATOM    982  N   GLY    35      -8.916  81.627  40.013  1.00 23.37           N  
ATOM    983  CA  GLY    35     -10.169  80.966  39.763  1.00 26.15           C  
ATOM    984  C   GLY    35     -11.353  81.880  40.008  1.00 26.00           C  
ATOM    985  O   GLY    35     -11.261  82.862  40.761  1.00 26.21           O  
ATOM    986  N   LYS    36     -12.466  81.593  39.353  1.00 26.20           N  
ATOM    987  CA  LYS    36     -13.707  82.364  39.626  1.00 25.52           C  
ATOM    988  C   LYS    36     -14.401  81.918  40.902  1.00 25.59           C  
ATOM    989  O   LYS    36     -15.013  82.749  41.608  1.00 24.82           O  
ATOM    990  CB  LYS    36     -14.650  82.280  38.433  1.00 23.76           C  
ATOM    991  CG  LYS    36     -14.018  82.839  37.170  1.00 27.92           C  
ATOM    992  CD  LYS    36     -13.636  84.274  37.261  1.00 33.79           C  
ATOM    993  CE  LYS    36     -13.123  84.756  35.913  1.00 33.74           C  
ATOM    994  NZ  LYS    36     -12.672  86.191  35.921  1.00 36.41           N  
ATOM    995  N   THR    37     -14.305  80.634  41.224  1.00 26.34           N  
ATOM    996  CA  THR    37     -14.895  80.088  42.444  1.00 27.40           C  
ATOM    997  C   THR    37     -13.901  79.304  43.281  1.00 28.68           C  
ATOM    998  O   THR    37     -13.830  79.501  44.486  1.00 28.44           O  
ATOM    999  CB  THR    37     -16.085  79.125  42.147  1.00 30.61           C  
ATOM   1000  OG1 THR    37     -17.140  79.845  41.507  1.00 34.12           O  
ATOM   1001  CG2 THR    37     -16.683  78.562  43.442  1.00 27.91           C  
ATOM   1002  N   LEU    38     -13.154  78.398  42.652  1.00 24.44           N  
ATOM   1003  CA  LEU    38     -12.190  77.556  43.382  1.00 24.53           C  
ATOM   1004  C   LEU    38     -11.018  78.408  43.841  1.00 26.73           C  
ATOM   1005  O   LEU    38     -10.561  79.304  43.117  1.00 26.13           O  
ATOM   1006  CB  LEU    38     -11.682  76.416  42.494  1.00 24.24           C  
ATOM   1007  CG  LEU    38     -12.721  75.446  41.996  1.00 25.01           C  
ATOM   1008  CD1 LEU    38     -12.043  74.310  41.217  1.00 23.26           C  
ATOM   1009  CD2 LEU    38     -13.555  74.919  43.151  1.00 22.80           C  
ATOM   1010  N   ASP    39     -10.539  78.150  45.053  1.00 25.77           N  
ATOM   1011  CA  ASP    39      -9.405  78.915  45.556  1.00 26.59           C  
ATOM   1012  C   ASP    39      -8.085  78.324  45.076  1.00 26.80           C  
ATOM   1013  O   ASP    39      -8.046  77.280  44.439  1.00 24.07           O  
ATOM   1014  CB  ASP    39      -9.484  79.093  47.084  1.00 27.84           C  
ATOM   1015  CG  ASP    39      -9.352  77.804  47.861  1.00 31.36           C  
ATOM   1016  OD1 ASP    39      -8.887  76.754  47.351  1.00 28.62           O  
ATOM   1017  OD2 ASP    39      -9.729  77.848  49.052  1.00 33.78           O  
ATOM   1018  N   TYR    40      -7.011  79.046  45.327  1.00 25.33           N  
ATOM   1019  CA  TYR    40      -5.703  78.664  44.822  1.00 24.51           C  
ATOM   1020  C   TYR    40      -5.243  77.312  45.372  1.00 25.46           C  
ATOM   1021  O   TYR    40      -4.698  76.478  44.641  1.00 24.60           O  
ATOM   1022  CB  TYR    40      -4.723  79.753  45.247  1.00 28.58           C  
ATOM   1023  CG  TYR    40      -3.320  79.640  44.733  1.00 27.35           C  
ATOM   1024  CD1 TYR    40      -3.051  79.264  43.426  1.00 42.63           C  
ATOM   1025  CD2 TYR    40      -2.241  79.981  45.555  1.00 35.86           C  
ATOM   1026  CE1 TYR    40      -1.744  79.202  42.958  1.00 45.32           C  
ATOM   1027  CE2 TYR    40      -0.946  79.919  45.099  1.00 36.50           C  
ATOM   1028  CZ  TYR    40      -0.701  79.543  43.803  1.00 41.69           C  
ATOM   1029  OH  TYR    40       0.596  79.495  43.344  1.00 43.10           O  
ATOM   1030  N   LYS    41      -5.466  77.097  46.659  1.00 24.17           N  
ATOM   1031  CA  LYS    41      -5.137  75.787  47.259  1.00 26.03           C  
ATOM   1032  C   LYS    41      -5.786  74.622  46.516  1.00 24.80           C  
ATOM   1033  O   LYS    41      -5.121  73.627  46.222  1.00 24.41           O  
ATOM   1034  CB  LYS    41      -5.525  75.756  48.725  1.00 26.17           C  
ATOM   1035  CG  LYS    41      -5.211  74.458  49.459  1.00 31.58           C  
ATOM   1036  CD  LYS    41      -5.774  74.499  50.886  1.00 33.11           C  
ATOM   1037  CE  LYS    41      -5.347  73.283  51.704  1.00 42.88           C  
ATOM   1038  NZ  LYS    41      -5.846  73.354  53.109  1.00 41.08           N  
ATOM   1039  N   THR    42      -7.074  74.738  46.237  1.00 24.70           N  
ATOM   1040  CA  THR    42      -7.798  73.688  45.520  1.00 23.81           C  
ATOM   1041  C   THR    42      -7.217  73.448  44.133  1.00 24.23           C  
ATOM   1042  O   THR    42      -7.022  72.317  43.719  1.00 23.25           O  
ATOM   1043  CB  THR    42      -9.301  73.985  45.416  1.00 24.82           C  
ATOM   1044  OG1 THR    42      -9.845  74.084  46.733  1.00 25.22           O  
ATOM   1045  CG2 THR    42     -10.038  72.883  44.667  1.00 25.77           C  
ATOM   1046  N   GLN    43      -6.933  74.527  43.418  1.00 23.43           N  
ATOM   1047  CA  GLN    43      -6.319  74.414  42.118  1.00 22.86           C  
ATOM   1048  C   GLN    43      -4.922  73.781  42.157  1.00 23.94           C  
ATOM   1049  O   GLN    43      -4.585  73.025  41.268  1.00 22.91           O  
ATOM   1050  CB  GLN    43      -6.246  75.772  41.437  1.00 24.01           C  
ATOM   1051  CG  GLN    43      -7.565  76.328  41.029  1.00 22.72           C  
ATOM   1052  CD  GLN    43      -7.399  77.608  40.263  1.00 23.02           C  
ATOM   1053  OE1 GLN    43      -6.876  78.573  40.809  1.00 25.62           O  
ATOM   1054  NE2 GLN    43      -7.853  77.631  39.000  1.00 24.23           N  
ATOM   1055  N   LYS    44      -4.119  74.119  43.152  1.00 23.49           N  
ATOM   1056  CA  LYS    44      -2.798  73.504  43.293  1.00 22.94           C  
ATOM   1057  C   LYS    44      -2.885  72.010  43.618  1.00 23.73           C  
ATOM   1058  O   LYS    44      -2.073  71.231  43.139  1.00 23.97           O  
ATOM   1059  CB  LYS    44      -1.964  74.236  44.353  1.00 26.12           C  
ATOM   1060  CG  LYS    44      -1.383  75.517  43.796  1.00 37.14           C  
ATOM   1061  CD  LYS    44      -0.199  75.250  42.854  1.00 40.63           C  
ATOM   1062  CE  LYS    44       0.270  76.569  42.238  1.00 46.64           C  
ATOM   1063  NZ  LYS    44       1.409  76.414  41.283  1.00 41.05           N  
ATOM   1064  N   LEU    45      -3.875  71.626  44.416  1.00 22.77           N  
ATOM   1065  CA  LEU    45      -4.158  70.192  44.683  1.00 22.94           C  
ATOM   1066  C   LEU    45      -4.528  69.448  43.403  1.00 20.00           C  
ATOM   1067  O   LEU    45      -4.064  68.333  43.149  1.00 21.82           O  
ATOM   1068  CB  LEU    45      -5.255  70.034  45.759  1.00 24.89           C  
ATOM   1069  CG  LEU    45      -4.872  70.484  47.179  1.00 24.96           C  
ATOM   1070  CD1 LEU    45      -6.093  70.532  48.099  1.00 25.24           C  
ATOM   1071  CD2 LEU    45      -3.795  69.570  47.786  1.00 26.64           C  
ATOM   1072  N   ILE    46      -5.331  70.092  42.557  1.00 20.74           N  
ATOM   1073  CA  ILE    46      -5.651  69.564  41.249  1.00 21.62           C  
ATOM   1074  C   ILE    46      -4.391  69.407  40.390  1.00 20.78           C  
ATOM   1075  O   ILE    46      -4.202  68.383  39.737  1.00 21.91           O  
ATOM   1076  CB  ILE    46      -6.704  70.453  40.547  1.00 22.08           C  
ATOM   1077  CG1 ILE    46      -8.055  70.378  41.275  1.00 24.84           C  
ATOM   1078  CG2 ILE    46      -6.892  70.056  39.052  1.00 22.38           C  
ATOM   1079  CD1 ILE    46      -9.010  71.552  40.931  1.00 22.86           C  
ATOM   1080  N   ALA    47      -3.523  70.426  40.416  1.00 21.87           N  
ATOM   1081  CA  ALA    47      -2.279  70.384  39.643  1.00 21.24           C  
ATOM   1082  C   ALA    47      -1.416  69.194  40.090  1.00 21.15           C  
ATOM   1083  O   ALA    47      -0.852  68.486  39.264  1.00 23.10           O  
ATOM   1084  CB  ALA    47      -1.507  71.727  39.768  1.00 21.67           C  
ATOM   1085  N   ILE    48      -1.326  68.971  41.401  1.00 23.22           N  
ATOM   1086  CA  ILE    48      -0.581  67.815  41.934  1.00 23.42           C  
ATOM   1087  C   ILE    48      -1.151  66.535  41.379  1.00 22.45           C  
ATOM   1088  O   ILE    48      -0.412  65.683  40.917  1.00 22.38           O  
ATOM   1089  CB  ILE    48      -0.565  67.783  43.480  1.00 22.22           C  
ATOM   1090  CG1 ILE    48       0.257  68.942  44.048  1.00 26.05           C  
ATOM   1091  CG2 ILE    48       0.049  66.452  44.023  1.00 25.18           C  
ATOM   1092  CD1 ILE    48      -0.059  69.242  45.504  1.00 25.14           C  
ATOM   1093  N   GLY    49      -2.485  66.395  41.436  1.00 23.64           N  
ATOM   1094  CA  GLY    49      -3.152  65.223  40.890  1.00 22.69           C  
ATOM   1095  C   GLY    49      -2.810  64.948  39.439  1.00 22.13           C  
ATOM   1096  O   GLY    49      -2.514  63.817  39.044  1.00 22.25           O  
ATOM   1097  N   ILE    50      -2.858  65.995  38.620  1.00 21.97           N  
ATOM   1098  CA  ILE    50      -2.611  65.842  37.209  1.00 23.22           C  
ATOM   1099  C   ILE    50      -1.179  65.410  36.958  1.00 20.30           C  
ATOM   1100  O   ILE    50      -0.936  64.483  36.198  1.00 22.58           O  
ATOM   1101  CB  ILE    50      -2.928  67.132  36.415  1.00 23.33           C  
ATOM   1102  CG1 ILE    50      -4.446  67.402  36.425  1.00 25.36           C  
ATOM   1103  CG2 ILE    50      -2.410  67.043  34.958  1.00 25.70           C  
ATOM   1104  CD1 ILE    50      -4.873  68.780  35.946  1.00 23.40           C  
ATOM   1105  N   VAL    51      -0.226  66.112  37.554  1.00 22.13           N  
ATOM   1106  CA  VAL    51       1.198  65.805  37.361  0.50 22.96           C  
ATOM   1108  C   VAL    51       1.534  64.410  37.901  1.00 22.59           C  
ATOM   1109  O   VAL    51       2.294  63.639  37.290  1.00 23.85           O  
ATOM   1110  CB  VAL    51       2.072  66.864  38.052  0.50 23.96           C  
ATOM   1112  CG1 VAL    51       3.558  66.521  37.912  0.50 22.52           C  
ATOM   1114  CG2 VAL    51       1.793  68.268  37.453  0.50 24.56           C  
ATOM   1116  N   ALA    52       0.940  64.069  39.051  1.00 21.97           N  
ATOM   1117  CA  ALA    52       1.198  62.761  39.646  1.00 22.83           C  
ATOM   1118  C   ALA    52       0.615  61.626  38.821  1.00 24.96           C  
ATOM   1119  O   ALA    52       1.057  60.489  38.972  1.00 27.05           O  
ATOM   1120  CB  ALA    52       0.708  62.681  41.110  1.00 22.19           C  
ATOM   1121  N   SER    53      -0.366  61.908  37.962  1.00 23.44           N  
ATOM   1122  CA  SER    53      -0.993  60.900  37.128  0.50 24.03           C  
ATOM   1124  C   SER    53      -0.070  60.482  35.984  1.00 28.22           C  
ATOM   1125  O   SER    53      -0.306  59.463  35.352  1.00 29.44           O  
ATOM   1126  CB  SER    53      -2.358  61.369  36.590  0.50 24.46           C  
ATOM   1128  OG  SER    53      -2.273  62.367  35.572  0.50 17.33           O  
ATOM   1130  N   ARG    54       0.967  61.288  35.750  1.00 27.88           N  
ATOM   1131  CA  ARG    54       1.961  61.079  34.686  1.00 36.49           C  
ATOM   1132  C   ARG    54       3.323  60.666  35.269  1.00 42.51           C  
ATOM   1133  O   ARG    54       3.434  60.416  36.472  1.00 42.98           O  
ATOM   1134  CB  ARG    54       2.061  62.360  33.864  1.00 36.62           C  
ATOM   1135  CG  ARG    54       0.682  62.788  33.371  1.00 36.07           C  
ATOM   1136  CD  ARG    54       0.720  63.747  32.220  1.00 46.03           C  
ATOM   1137  NE  ARG    54       1.186  65.048  32.671  1.00 47.58           N  
ATOM   1138  CZ  ARG    54       0.593  66.218  32.427  1.00 48.31           C  
ATOM   1139  NH1 ARG    54      -0.539  66.301  31.716  1.00 41.50           N  
ATOM   1140  NH2 ARG    54       1.152  67.314  32.919  1.00 45.55           N  
ATOM   1141  N   CYS    55       4.364  60.567  34.441  1.00 47.81           N  
ATOM   1142  CA  CYS    55       5.609  59.917  34.908  1.00 53.06           C  
ATOM   1143  C   CYS    55       6.714  60.870  35.342  1.00 53.53           C  
ATOM   1144  O   CYS    55       7.760  60.423  35.818  1.00 55.63           O  
ATOM   1145  CB  CYS    55       6.175  58.963  33.844  1.00 54.41           C  
ATOM   1146  SG  CYS    55       4.966  57.829  33.125  1.00 70.70           S  
ATOM   1147  N   ASP    56       6.510  62.170  35.183  1.00 51.11           N  
ATOM   1148  CA  ASP    56       7.593  63.097  35.442  1.00 50.75           C  
ATOM   1149  C   ASP    56       7.796  63.237  36.966  1.00 47.60           C  
ATOM   1150  O   ASP    56       7.187  64.093  37.608  1.00 47.73           O  
ATOM   1151  CB  ASP    56       7.335  64.451  34.744  1.00 51.45           C  
ATOM   1152  CG  ASP    56       8.549  65.360  34.751  1.00 55.00           C  
ATOM   1153  OD1 ASP    56       9.598  64.950  35.298  1.00 59.75           O  
ATOM   1154  OD2 ASP    56       8.445  66.490  34.211  1.00 56.95           O  
ATOM   1155  N   GLU    57       8.662  62.376  37.505  1.00 44.76           N  
ATOM   1156  CA  GLU    57       9.079  62.384  38.919  1.00 44.68           C  
ATOM   1157  C   GLU    57       9.555  63.747  39.434  1.00 43.54           C  
ATOM   1158  O   GLU    57       9.225  64.151  40.554  1.00 39.20           O  
ATOM   1159  CB  GLU    57      10.193  61.362  39.121  1.00 44.24           C  
ATOM   1160  CG  GLU    57      10.658  61.181  40.556  1.00 49.33           C  
ATOM   1161  N   VAL    58      10.342  64.453  38.623  1.00 44.25           N  
ATOM   1162  CA  VAL    58      10.846  65.761  39.019  1.00 41.66           C  
ATOM   1163  C   VAL    58       9.712  66.771  39.079  1.00 39.99           C  
ATOM   1164  O   VAL    58       9.637  67.563  40.023  1.00 40.88           O  
ATOM   1165  CB  VAL    58      12.003  66.255  38.076  1.00 44.98           C  
ATOM   1166  N   ALA    59       8.820  66.732  38.092  1.00 36.00           N  
ATOM   1167  CA  ALA    59       7.624  67.563  38.085  1.00 36.40           C  
ATOM   1168  C   ALA    59       6.746  67.291  39.314  1.00 34.21           C  
ATOM   1169  O   ALA    59       6.208  68.222  39.935  1.00 33.66           O  
ATOM   1170  CB  ALA    59       6.840  67.324  36.816  1.00 37.99           C  
ATOM   1171  N   ILE    60       6.614  66.013  39.667  1.00 31.22           N  
ATOM   1172  CA  ILE    60       5.812  65.647  40.839  1.00 28.82           C  
ATOM   1173  C   ILE    60       6.454  66.198  42.119  1.00 27.71           C  
ATOM   1174  O   ILE    60       5.781  66.867  42.913  1.00 27.90           O  
ATOM   1175  CB  ILE    60       5.613  64.129  40.959  1.00 27.95           C  
ATOM   1176  CG1 ILE    60       4.862  63.584  39.742  1.00 27.51           C  
ATOM   1177  CG2 ILE    60       4.812  63.808  42.224  1.00 26.18           C  
ATOM   1178  CD1 ILE    60       4.987  62.071  39.545  1.00 25.07           C  
ATOM   1179  N   GLU    61       7.741  65.915  42.319  1.00 30.04           N  
ATOM   1180  CA  GLU    61       8.460  66.430  43.501  1.00 32.80           C  
ATOM   1181  C   GLU    61       8.345  67.964  43.626  1.00 35.05           C  
ATOM   1182  O   GLU    61       8.090  68.492  44.715  1.00 33.59           O  
ATOM   1183  CB  GLU    61       9.925  65.988  43.468  1.00 33.45           C  
ATOM   1184  CG  GLU    61      10.720  66.333  44.743  1.00 36.55           C  
ATOM   1185  N   LYS    62       8.492  68.665  42.503  1.00 38.76           N  
ATOM   1186  CA  LYS    62       8.430  70.135  42.479  1.00 39.30           C  
ATOM   1187  C   LYS    62       7.040  70.681  42.772  1.00 38.68           C  
ATOM   1188  O   LYS    62       6.906  71.655  43.526  1.00 36.68           O  
ATOM   1189  CB  LYS    62       8.919  70.670  41.123  1.00 42.11           C  
ATOM   1190  N   GLN    63       5.995  70.076  42.198  1.00 35.90           N  
ATOM   1191  CA  GLN    63       4.635  70.517  42.512  1.00 36.26           C  
ATOM   1192  C   GLN    63       4.355  70.313  43.989  1.00 33.33           C  
ATOM   1193  O   GLN    63       3.755  71.165  44.626  1.00 33.91           O  
ATOM   1194  CB  GLN    63       3.548  69.798  41.676  1.00 39.20           C  
ATOM   1195  CG  GLN    63       3.160  70.466  40.335  1.00 44.45           C  
ATOM   1196  CD  GLN    63       2.333  71.749  40.478  1.00 44.95           C  
ATOM   1197  OE1 GLN    63       1.712  72.008  41.510  1.00 62.12           O  
ATOM   1198  NE2 GLN    63       2.315  72.547  39.425  1.00 63.66           N  
ATOM   1199  N   MET    64       4.752  69.161  44.531  1.00 30.47           N  
ATOM   1200  CA  MET    64       4.471  68.856  45.916  1.00 26.68           C  
ATOM   1201  C   MET    64       5.225  69.810  46.838  1.00 29.86           C  
ATOM   1202  O   MET    64       4.645  70.361  47.788  1.00 28.23           O  
ATOM   1203  CB  MET    64       4.864  67.412  46.233  1.00 23.18           C  
ATOM   1204  CG  MET    64       3.918  66.370  45.589  1.00 22.57           C  
ATOM   1205  SD  MET    64       4.418  64.644  46.195  0.75 22.23          SE  
ATOM   1206  CE  MET    64       3.056  63.632  45.253  1.00 22.00           C  
ATOM   1207  N   LYS    65       6.514  69.998  46.544  1.00 32.32           N  
ATOM   1208  CA  LYS    65       7.386  70.856  47.371  1.00 34.88           C  
ATOM   1209  C   LYS    65       6.857  72.284  47.412  1.00 34.19           C  
ATOM   1210  O   LYS    65       6.702  72.863  48.483  1.00 35.31           O  
ATOM   1211  CB  LYS    65       8.826  70.843  46.843  1.00 35.46           C  
ATOM   1212  CG  LYS    65       9.625  69.629  47.243  1.00 40.38           C  
ATOM   1213  N   SER    66       6.564  72.836  46.245  1.00 36.71           N  
ATOM   1214  CA  SER    66       6.041  74.200  46.142  0.50 37.97           C  
ATOM   1216  C   SER    66       4.709  74.361  46.864  1.00 39.15           C  
ATOM   1217  O   SER    66       4.486  75.342  47.552  1.00 40.37           O  
ATOM   1218  CB  SER    66       5.895  74.618  44.676  0.50 38.61           C  
ATOM   1220  OG  SER    66       5.090  73.703  43.950  0.50 37.08           O  
ATOM   1222  N   ALA    67       3.815  73.392  46.707  1.00 37.33           N  
ATOM   1223  CA  ALA    67       2.536  73.447  47.409  1.00 35.90           C  
ATOM   1224  C   ALA    67       2.708  73.505  48.921  1.00 33.63           C  
ATOM   1225  O   ALA    67       2.000  74.242  49.614  1.00 33.38           O  
ATOM   1226  CB  ALA    67       1.675  72.239  47.036  1.00 35.08           C  
ATOM   1227  N   MET    68       3.620  72.690  49.440  1.00 32.12           N  
ATOM   1228  CA  MET    68       3.809  72.592  50.861  1.00 32.59           C  
ATOM   1229  C   MET    68       4.455  73.891  51.335  1.00 33.83           C  
ATOM   1230  O   MET    68       4.036  74.457  52.332  1.00 35.23           O  
ATOM   1231  CB  MET    68       4.684  71.396  51.205  1.00 33.38           C  
ATOM   1232  CG  MET    68       4.027  70.041  50.923  1.00 33.32           C  
ATOM   1233  SD  MET    68       5.192  68.597  51.472  0.75 34.95          SE  
ATOM   1234  CE  MET    68       4.864  68.765  53.369  1.00 39.85           C  
ATOM   1235  N   LYS    69       5.428  74.370  50.567  1.00 35.03           N  
ATOM   1236  CA  LYS    69       6.210  75.565  50.936  1.00 37.33           C  
ATOM   1237  C   LYS    69       5.376  76.830  50.796  1.00 38.14           C  
ATOM   1238  O   LYS    69       5.218  77.585  51.764  1.00 42.29           O  
ATOM   1239  CB  LYS    69       7.470  75.676  50.075  1.00 36.02           C  
ATOM   1240  N   GLU    70       4.833  77.048  49.606  1.00 39.17           N  
ATOM   1241  CA  GLU    70       4.066  78.262  49.302  1.00 40.19           C  
ATOM   1242  C   GLU    70       2.697  78.317  49.975  1.00 40.34           C  
ATOM   1243  O   GLU    70       2.343  79.342  50.543  1.00 42.02           O  
ATOM   1244  CB  GLU    70       3.909  78.452  47.786  1.00 39.25           C  
ATOM   1245  N   LEU    71       1.936  77.226  49.937  1.00 39.71           N  
ATOM   1246  CA  LEU    71       0.552  77.239  50.424  1.00 38.07           C  
ATOM   1247  C   LEU    71       0.339  76.549  51.771  1.00 34.95           C  
ATOM   1248  O   LEU    71      -0.765  76.565  52.307  1.00 37.25           O  
ATOM   1249  CB  LEU    71      -0.380  76.601  49.371  1.00 39.04           C  
ATOM   1250  CG  LEU    71      -0.453  77.252  47.981  1.00 43.95           C  
ATOM   1251  CD1 LEU    71       0.756  76.880  47.115  1.00 50.69           C  
ATOM   1252  CD2 LEU    71      -1.736  76.876  47.251  1.00 39.57           C  
ATOM   1253  N   GLY    72       1.355  75.907  52.325  1.00 31.62           N  
ATOM   1254  CA  GLY    72       1.147  75.169  53.571  1.00 31.33           C  
ATOM   1255  C   GLY    72       0.288  73.914  53.427  1.00 30.39           C  
ATOM   1256  O   GLY    72      -0.302  73.424  54.405  1.00 31.58           O  
ATOM   1257  N   ILE    73       0.217  73.377  52.213  1.00 32.06           N  
ATOM   1258  CA  ILE    73      -0.496  72.104  51.983  1.00 28.57           C  
ATOM   1259  C   ILE    73       0.221  70.989  52.779  1.00 29.16           C  
ATOM   1260  O   ILE    73       1.450  70.986  52.850  1.00 29.32           O  
ATOM   1261  CB  ILE    73      -0.621  71.840  50.468  1.00 30.50           C  
ATOM   1262  CG1 ILE    73      -1.744  72.732  49.891  1.00 27.84           C  
ATOM   1263  CG2 ILE    73      -0.867  70.336  50.174  1.00 25.19           C  
ATOM   1264  CD1 ILE    73      -1.816  72.820  48.371  1.00 30.38           C  
ATOM   1265  N   THR    74      -0.530  70.088  53.420  1.00 27.36           N  
ATOM   1266  CA  THR    74       0.088  69.024  54.242  1.00 27.26           C  
ATOM   1267  C   THR    74       0.356  67.745  53.462  1.00 27.58           C  
ATOM   1268  O   THR    74      -0.238  67.522  52.416  1.00 24.17           O  
ATOM   1269  CB  THR    74      -0.757  68.627  55.460  1.00 29.19           C  
ATOM   1270  OG1 THR    74      -2.004  68.099  55.031  1.00 28.81           O  
ATOM   1271  CG2 THR    74      -0.971  69.880  56.480  1.00 28.98           C  
ATOM   1272  N   LYS    75       1.211  66.876  53.997  1.00 26.69           N  
ATOM   1273  CA  LYS    75       1.408  65.575  53.357  1.00 24.94           C  
ATOM   1274  C   LYS    75       0.105  64.766  53.394  1.00 24.97           C  
ATOM   1275  O   LYS    75      -0.183  64.049  52.430  1.00 24.26           O  
ATOM   1276  CB  LYS    75       2.547  64.787  54.001  1.00 25.92           C  
ATOM   1277  CG  LYS    75       3.941  65.377  53.781  1.00 25.04           C  
ATOM   1278  CD  LYS    75       5.016  64.369  54.207  1.00 27.40           C  
ATOM   1279  CE  LYS    75       6.395  64.744  53.675  1.00 30.74           C  
ATOM   1280  NZ  LYS    75       7.337  63.582  53.770  1.00 29.47           N  
ATOM   1281  N   GLU    76      -0.705  64.923  54.456  1.00 23.62           N  
ATOM   1282  CA  GLU    76      -2.006  64.250  54.537  1.00 27.19           C  
ATOM   1283  C   GLU    76      -2.963  64.703  53.418  1.00 22.94           C  
ATOM   1284  O   GLU    76      -3.670  63.897  52.828  1.00 25.59           O  
ATOM   1285  CB  GLU    76      -2.676  64.495  55.897  1.00 28.02           C  
ATOM   1286  CG  GLU    76      -3.944  63.646  56.101  1.00 35.01           C  
ATOM   1287  CD  GLU    76      -4.602  63.869  57.467  1.00 37.01           C  
ATOM   1288  OE1 GLU    76      -4.541  65.017  57.990  1.00 52.64           O  
ATOM   1289  OE2 GLU    76      -5.167  62.883  58.002  1.00 48.87           O  
ATOM   1290  N   GLU    77      -2.974  65.994  53.116  1.00 24.57           N  
ATOM   1291  CA  GLU    77      -3.774  66.494  52.000  1.00 24.63           C  
ATOM   1292  C   GLU    77      -3.272  65.945  50.656  1.00 24.30           C  
ATOM   1293  O   GLU    77      -4.068  65.546  49.803  1.00 23.45           O  
ATOM   1294  CB  GLU    77      -3.785  68.017  51.965  1.00 25.09           C  
ATOM   1295  CG  GLU    77      -4.555  68.632  53.117  1.00 28.85           C  
ATOM   1296  CD  GLU    77      -4.410  70.153  53.229  1.00 30.84           C  
ATOM   1297  OE1 GLU    77      -3.353  70.735  52.878  1.00 33.27           O  
ATOM   1298  OE2 GLU    77      -5.388  70.777  53.674  1.00 33.37           O  
ATOM   1299  N   ILE    78      -1.955  65.938  50.475  1.00 24.49           N  
ATOM   1300  CA  ILE    78      -1.378  65.340  49.262  1.00 23.04           C  
ATOM   1301  C   ILE    78      -1.725  63.851  49.134  1.00 21.63           C  
ATOM   1302  O   ILE    78      -2.100  63.380  48.059  1.00 21.32           O  
ATOM   1303  CB  ILE    78       0.162  65.600  49.123  1.00 22.33           C  
ATOM   1304  CG1 ILE    78       0.452  67.103  49.059  1.00 25.20           C  
ATOM   1305  CG2 ILE    78       0.697  64.957  47.836  1.00 21.31           C  
ATOM   1306  CD1 ILE    78       1.911  67.437  49.205  1.00 24.12           C  
ATOM   1307  N   ALA    79      -1.679  63.116  50.236  1.00 22.41           N  
ATOM   1308  CA  ALA    79      -2.026  61.718  50.200  1.00 20.30           C  
ATOM   1309  C   ALA    79      -3.467  61.520  49.727  1.00 21.42           C  
ATOM   1310  O   ALA    79      -3.749  60.611  48.966  1.00 20.43           O  
ATOM   1311  CB  ALA    79      -1.797  61.071  51.552  1.00 22.66           C  
ATOM   1312  N   ASP    80      -4.374  62.409  50.130  1.00 20.93           N  
ATOM   1313  CA  ASP    80      -5.762  62.331  49.652  1.00 20.26           C  
ATOM   1314  C   ASP    80      -5.885  62.593  48.155  1.00 22.81           C  
ATOM   1315  O   ASP    80      -6.734  62.009  47.494  1.00 22.27           O  
ATOM   1316  CB  ASP    80      -6.667  63.310  50.395  1.00 20.14           C  
ATOM   1317  CG  ASP    80      -7.045  62.853  51.807  1.00 23.19           C  
ATOM   1318  OD1 ASP    80      -6.928  61.652  52.156  1.00 25.42           O  
ATOM   1319  OD2 ASP    80      -7.525  63.728  52.549  1.00 28.27           O  
ATOM   1320  N   VAL    81      -5.043  63.483  47.619  1.00 21.25           N  
ATOM   1321  CA  VAL    81      -4.939  63.659  46.181  1.00 22.27           C  
ATOM   1322  C   VAL    81      -4.492  62.341  45.520  1.00 20.03           C  
ATOM   1323  O   VAL    81      -5.078  61.898  44.508  1.00 19.50           O  
ATOM   1324  CB  VAL    81      -3.963  64.805  45.817  1.00 20.90           C  
ATOM   1325  CG1 VAL    81      -3.757  64.895  44.302  1.00 22.88           C  
ATOM   1326  CG2 VAL    81      -4.425  66.168  46.443  1.00 20.83           C  
ATOM   1327  N   LEU    82      -3.519  61.673  46.131  1.00 20.16           N  
ATOM   1328  CA  LEU    82      -2.954  60.455  45.560  1.00 19.84           C  
ATOM   1329  C   LEU    82      -3.955  59.291  45.560  1.00 18.54           C  
ATOM   1330  O   LEU    82      -3.913  58.425  44.676  1.00 19.11           O  
ATOM   1331  CB  LEU    82      -1.666  60.090  46.263  1.00 20.98           C  
ATOM   1332  CG  LEU    82      -0.551  61.135  46.146  1.00 20.66           C  
ATOM   1333  CD1 LEU    82       0.766  60.558  46.671  1.00 21.28           C  
ATOM   1334  CD2 LEU    82      -0.392  61.639  44.674  1.00 22.33           C  
ATOM   1335  N   ARG    83      -4.911  59.309  46.495  1.00 20.31           N  
ATOM   1336  CA  ARG    83      -5.991  58.304  46.463  1.00 21.39           C  
ATOM   1337  C   ARG    83      -6.744  58.386  45.139  1.00 20.18           C  
ATOM   1338  O   ARG    83      -7.025  57.394  44.468  1.00 19.30           O  
ATOM   1339  CB  ARG    83      -6.940  58.521  47.643  1.00 22.29           C  
ATOM   1340  CG  ARG    83      -6.321  58.269  48.999  1.00 22.30           C  
ATOM   1341  CD  ARG    83      -7.215  58.747  50.124  1.00 28.97           C  
ATOM   1342  NE  ARG    83      -8.051  57.695  50.628  1.00 33.52           N  
ATOM   1343  CZ  ARG    83      -7.790  56.938  51.696  1.00 23.68           C  
ATOM   1344  NH1 ARG    83      -6.703  57.064  52.438  1.00 32.40           N  
ATOM   1345  NH2 ARG    83      -8.646  56.031  52.018  1.00 24.82           N  
ATOM   1346  N   VAL    84      -7.007  59.612  44.712  1.00 19.60           N  
ATOM   1347  CA  VAL    84      -7.659  59.856  43.423  1.00 20.32           C  
ATOM   1348  C   VAL    84      -6.772  59.472  42.241  1.00 20.03           C  
ATOM   1349  O   VAL    84      -7.255  58.901  41.275  1.00 20.48           O  
ATOM   1350  CB  VAL    84      -8.137  61.322  43.296  1.00 21.39           C  
ATOM   1351  CG1 VAL    84      -8.987  61.511  41.998  1.00 22.27           C  
ATOM   1352  CG2 VAL    84      -8.967  61.726  44.539  1.00 22.62           C  
ATOM   1353  N   VAL    85      -5.467  59.765  42.311  1.00 19.59           N  
ATOM   1354  CA  VAL    85      -4.526  59.262  41.308  1.00 19.33           C  
ATOM   1355  C   VAL    85      -4.607  57.748  41.150  1.00 19.40           C  
ATOM   1356  O   VAL    85      -4.616  57.261  40.035  1.00 20.61           O  
ATOM   1357  CB  VAL    85      -3.073  59.710  41.615  1.00 19.39           C  
ATOM   1358  CG1 VAL    85      -2.070  59.082  40.659  1.00 17.94           C  
ATOM   1359  CG2 VAL    85      -2.997  61.250  41.539  1.00 21.42           C  
ATOM   1360  N   LEU    86      -4.650  56.998  42.252  1.00 19.33           N  
ATOM   1361  CA  LEU    86      -4.777  55.548  42.161  1.00 19.79           C  
ATOM   1362  C   LEU    86      -6.014  55.159  41.363  1.00 18.98           C  
ATOM   1363  O   LEU    86      -5.940  54.357  40.454  1.00 20.03           O  
ATOM   1364  CB  LEU    86      -4.858  54.924  43.555  1.00 21.20           C  
ATOM   1365  CG  LEU    86      -5.184  53.439  43.651  1.00 21.99           C  
ATOM   1366  CD1 LEU    86      -4.133  52.600  42.959  1.00 24.06           C  
ATOM   1367  CD2 LEU    86      -5.310  53.065  45.156  1.00 20.62           C  
ATOM   1368  N   LEU    87      -7.154  55.734  41.711  1.00 20.94           N  
ATOM   1369  CA  LEU    87      -8.412  55.347  41.065  1.00 21.06           C  
ATOM   1370  C   LEU    87      -8.447  55.701  39.591  1.00 21.01           C  
ATOM   1371  O   LEU    87      -8.981  54.948  38.793  1.00 22.38           O  
ATOM   1372  CB  LEU    87      -9.577  56.046  41.769  1.00 23.55           C  
ATOM   1373  CG  LEU    87     -10.992  55.596  41.405  1.00 25.01           C  
ATOM   1374  CD1 LEU    87     -11.291  54.169  41.742  1.00 30.38           C  
ATOM   1375  CD2 LEU    87     -11.944  56.517  42.180  1.00 27.84           C  
ATOM   1376  N   THR    88      -7.906  56.874  39.258  1.00 21.25           N  
ATOM   1377  CA  THR    88      -7.927  57.375  37.879  1.00 21.88           C  
ATOM   1378  C   THR    88      -6.816  56.833  36.983  1.00 22.77           C  
ATOM   1379  O   THR    88      -6.931  56.837  35.762  1.00 23.28           O  
ATOM   1380  CB  THR    88      -7.874  58.903  37.853  1.00 21.84           C  
ATOM   1381  OG1 THR    88      -6.644  59.350  38.431  1.00 22.90           O  
ATOM   1382  CG2 THR    88      -9.066  59.477  38.541  1.00 25.52           C  
ATOM   1383  N   SER    89      -5.735  56.386  37.602  1.00 20.63           N  
ATOM   1384  CA  SER    89      -4.483  56.227  36.896  1.00 21.58           C  
ATOM   1385  C   SER    89      -3.720  54.942  37.169  1.00 21.03           C  
ATOM   1386  O   SER    89      -2.772  54.629  36.425  1.00 23.05           O  
ATOM   1387  CB  SER    89      -3.575  57.459  37.151  1.00 25.09           C  
ATOM   1388  OG  SER    89      -4.281  58.671  36.880  1.00 24.41           O  
ATOM   1389  N   GLY    90      -4.063  54.215  38.234  1.00 21.98           N  
ATOM   1390  CA  GLY    90      -3.467  52.905  38.482  1.00 20.22           C  
ATOM   1391  C   GLY    90      -2.363  52.897  39.536  1.00 20.13           C  
ATOM   1392  O   GLY    90      -1.942  53.955  40.033  1.00 19.52           O  
ATOM   1393  N   MET    91      -1.913  51.694  39.856  1.00 20.97           N  
ATOM   1394  CA  MET    91      -0.890  51.427  40.886  0.40 24.63           C  
ATOM   1396  C   MET    91       0.459  52.100  40.604  1.00 21.70           C  
ATOM   1397  O   MET    91       1.059  52.724  41.502  1.00 23.86           O  
ATOM   1398  CB  MET    91      -0.619  49.917  41.035  0.40 26.41           C  
ATOM   1400  CG  MET    91      -1.632  49.085  41.765  0.40 29.31           C  
ATOM   1402  SD  MET    91      -0.711  47.905  43.072  0.28 35.75          SE  
ATOM   1404  CE  MET    91      -0.457  49.469  44.218  0.40 21.93           C  
ATOM   1406  N   PRO    92       0.980  51.963  39.373  1.00 21.05           N  
ATOM   1407  CA  PRO    92       2.311  52.563  39.147  1.00 19.88           C  
ATOM   1408  C   PRO    92       2.408  54.050  39.498  1.00 21.02           C  
ATOM   1409  O   PRO    92       3.356  54.485  40.177  1.00 20.96           O  
ATOM   1410  CB  PRO    92       2.572  52.299  37.663  1.00 22.51           C  
ATOM   1411  CG  PRO    92       1.788  51.073  37.374  1.00 20.16           C  
ATOM   1412  CD  PRO    92       0.530  51.210  38.184  1.00 21.39           C  
ATOM   1413  N   ALA    93       1.434  54.836  39.065  1.00 19.14           N  
ATOM   1414  CA  ALA    93       1.460  56.257  39.340  1.00 19.96           C  
ATOM   1415  C   ALA    93       1.300  56.530  40.843  1.00 19.93           C  
ATOM   1416  O   ALA    93       1.977  57.400  41.418  1.00 20.12           O  
ATOM   1417  CB  ALA    93       0.324  56.953  38.551  1.00 22.71           C  
ATOM   1418  N   PHE    94       0.374  55.804  41.457  1.00 18.44           N  
ATOM   1419  CA  PHE    94       0.116  55.937  42.882  1.00 18.79           C  
ATOM   1420  C   PHE    94       1.380  55.638  43.705  1.00 20.05           C  
ATOM   1421  O   PHE    94       1.763  56.426  44.594  1.00 19.06           O  
ATOM   1422  CB  PHE    94      -0.966  54.949  43.301  1.00 20.10           C  
ATOM   1423  CG  PHE    94      -1.232  54.947  44.799  1.00 20.32           C  
ATOM   1424  CD1 PHE    94      -1.802  56.035  45.406  1.00 19.60           C  
ATOM   1425  CD2 PHE    94      -0.904  53.846  45.583  1.00 23.76           C  
ATOM   1426  CE1 PHE    94      -2.066  56.050  46.776  1.00 22.96           C  
ATOM   1427  CE2 PHE    94      -1.154  53.856  46.964  1.00 22.72           C  
ATOM   1428  CZ  PHE    94      -1.722  54.954  47.559  1.00 26.09           C  
ATOM   1429  N   THR    95       2.013  54.508  43.431  1.00 20.55           N  
ATOM   1430  CA  THR    95       3.135  54.077  44.284  1.00 20.94           C  
ATOM   1431  C   THR    95       4.339  55.000  44.073  1.00 20.73           C  
ATOM   1432  O   THR    95       5.018  55.353  45.038  1.00 20.28           O  
ATOM   1433  CB  THR    95       3.494  52.592  44.055  1.00 23.86           C  
ATOM   1434  OG1 THR    95       3.863  52.424  42.701  1.00 24.63           O  
ATOM   1435  CG2 THR    95       2.314  51.685  44.356  1.00 21.43           C  
ATOM   1436  N   LYS    96       4.586  55.442  42.833  1.00 20.08           N  
ATOM   1437  CA  LYS    96       5.679  56.370  42.546  0.50 21.50           C  
ATOM   1439  C   LYS    96       5.460  57.655  43.335  1.00 20.81           C  
ATOM   1440  O   LYS    96       6.378  58.161  43.984  1.00 23.01           O  
ATOM   1441  CB  LYS    96       5.748  56.674  41.040  0.50 23.02           C  
ATOM   1443  CG  LYS    96       6.843  57.658  40.621  0.50 23.87           C  
ATOM   1445  CD  LYS    96       7.014  57.722  39.092  0.50 25.49           C  
ATOM   1447  CE  LYS    96       8.452  58.030  38.704  0.50 32.66           C  
ATOM   1449  NZ  LYS    96       9.333  56.844  38.868  0.50 30.31           N  
ATOM   1451  N   ALA    97       4.244  58.190  43.262  1.00 19.16           N  
ATOM   1452  CA  ALA    97       3.898  59.469  43.921  1.00 19.50           C  
ATOM   1453  C   ALA    97       3.968  59.374  45.441  1.00 20.63           C  
ATOM   1454  O   ALA    97       4.463  60.306  46.135  1.00 20.71           O  
ATOM   1455  CB  ALA    97       2.498  59.945  43.472  1.00 19.41           C  
ATOM   1456  N   MET    98       3.499  58.244  45.974  1.00 19.58           N  
ATOM   1457  CA  MET    98       3.518  58.034  47.406  1.00 20.80           C  
ATOM   1458  C   MET    98       4.949  58.016  47.898  1.00 21.43           C  
ATOM   1459  O   MET    98       5.235  58.574  48.952  1.00 21.18           O  
ATOM   1460  CB  MET    98       2.812  56.740  47.834  1.00 22.05           C  
ATOM   1461  CG  MET    98       1.348  56.831  48.010  1.00 30.57           C  
ATOM   1462  SD  MET    98       0.764  58.016  49.491  0.75 32.27          SE  
ATOM   1463  CE  MET    98       1.937  58.044  50.314  1.00  8.65           C  
ATOM   1464  N   LYS    99       5.840  57.362  47.159  1.00 20.17           N  
ATOM   1465  CA  LYS    99       7.263  57.318  47.526  1.00 20.82           C  
ATOM   1466  C   LYS    99       7.928  58.695  47.534  1.00 21.61           C  
ATOM   1467  O   LYS    99       8.729  59.015  48.429  1.00 22.41           O  
ATOM   1468  CB  LYS    99       8.015  56.361  46.599  1.00 19.98           C  
ATOM   1469  CG  LYS    99       9.522  56.268  46.893  1.00 23.11           C  
ATOM   1470  N   ILE   100       7.602  59.501  46.536  1.00 22.47           N  
ATOM   1471  CA  ILE   100       8.072  60.874  46.456  1.00 23.27           C  
ATOM   1472  C   ILE   100       7.553  61.687  47.656  1.00 24.13           C  
ATOM   1473  O   ILE   100       8.325  62.413  48.299  1.00 23.84           O  
ATOM   1474  CB  ILE   100       7.652  61.544  45.136  1.00 22.91           C  
ATOM   1475  CG1 ILE   100       8.324  60.868  43.926  1.00 22.73           C  
ATOM   1476  CG2 ILE   100       7.973  63.043  45.152  1.00 21.99           C  
ATOM   1477  CD1 ILE   100       7.717  61.279  42.573  1.00 25.00           C  
ATOM   1478  N   LEU   101       6.269  61.540  47.970  1.00 21.64           N  
ATOM   1479  CA  LEU   101       5.660  62.247  49.106  1.00 23.29           C  
ATOM   1480  C   LEU   101       6.347  61.878  50.406  1.00 23.75           C  
ATOM   1481  O   LEU   101       6.624  62.756  51.240  1.00 22.26           O  
ATOM   1482  CB  LEU   101       4.155  61.935  49.207  1.00 22.94           C  
ATOM   1483  CG  LEU   101       3.386  62.589  50.364  1.00 23.09           C  
ATOM   1484  CD1 LEU   101       3.489  64.134  50.332  1.00 23.78           C  
ATOM   1485  CD2 LEU   101       1.946  62.145  50.275  1.00 22.66           C  
ATOM   1486  N   GLU   102       6.611  60.583  50.578  1.00 22.09           N  
ATOM   1487  CA  GLU   102       7.262  60.059  51.770  1.00 27.09           C  
ATOM   1488  C   GLU   102       8.642  60.680  51.965  1.00 25.97           C  
ATOM   1489  O   GLU   102       9.018  61.019  53.083  1.00 27.53           O  
ATOM   1490  CB  GLU   102       7.399  58.543  51.675  1.00 27.36           C  
ATOM   1491  CG  GLU   102       6.073  57.805  51.782  1.00 34.71           C  
ATOM   1492  CD  GLU   102       6.120  56.363  51.242  1.00 36.54           C  
ATOM   1493  OE1 GLU   102       7.234  55.820  51.027  1.00 45.78           O  
ATOM   1494  OE2 GLU   102       5.022  55.775  51.058  1.00 44.93           O  
ATOM   1495  N   LYS   103       9.388  60.834  50.880  1.00 25.11           N  
ATOM   1496  CA  LYS   103      10.773  61.333  50.951  1.00 28.56           C  
ATOM   1497  C   LYS   103      10.847  62.862  51.111  1.00 31.51           C  
ATOM   1498  O   LYS   103      11.911  63.419  51.414  1.00 33.51           O  
ATOM   1499  CB  LYS   103      11.571  60.887  49.714  1.00 29.59           C  
ATOM   1500  CG  LYS   103      11.820  59.386  49.621  1.00 32.01           C  
ATOM   1501  N   LEU   104       9.727  63.543  50.933  1.00 31.51           N  
ATOM   1502  CA  LEU   104       9.711  64.997  51.021  1.00 35.23           C  
ATOM   1503  C   LEU   104       9.855  65.493  52.451  1.00 36.78           C  
ATOM   1504  O   LEU   104       9.406  64.849  53.400  1.00 36.92           O  
ATOM   1505  CB  LEU   104       8.441  65.570  50.389  1.00 34.06           C  
ATOM   1506  CG  LEU   104       8.572  65.835  48.898  1.00 34.04           C  
ATOM   1507  CD1 LEU   104       7.311  66.503  48.411  1.00 34.11           C  
ATOM   1508  CD2 LEU   104       9.796  66.702  48.620  1.00 38.61           C  
ATOM   1509  OXT LEU   104      10.441  66.563  52.661  1.00 40.57           O  
END
