
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  147 ( 1167),  selected  147 , name 2gmy_F
# Molecule2: number of CA atoms   98 (  717),  selected   98 , name T0408.pdb
# PARAMETERS: 2gmy_F.T0408.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     2_F      F       7           -
LGA    -       -      G       8           -
LGA    T     3_F      E       9           #
LGA    R     4_F      -       -           -
LGA    I     5_F      G      10           #
LGA    N     6_F      M      11           #
LGA    -       -      K      12           -
LGA    -       -      V      13           -
LGA    Y     7_F      V      14          2.615
LGA    A     8_F      K      15          2.486
LGA    K     9_F      E      16          1.698
LGA    A    10_F      K      17          1.803
LGA    S    11_F      Y      18          1.303
LGA    P    12_F      P      19          1.531
LGA    E    13_F      D      20          1.276
LGA    A    14_F      L      21          1.263
LGA    F    15_F      Y      22          1.637
LGA    K    16_F      D      23          1.434
LGA    A    17_F      I      24          1.111
LGA    V    18_F      I      25          1.202
LGA    M    19_F      V      26          1.067
LGA    A    20_F      K      27          0.743
LGA    L    21_F      L      28          0.565
LGA    E    22_F      N      29          0.330
LGA    N    23_F      D      30          0.737
LGA    Y    24_F      T      31          0.593
LGA    V    25_F      V      32          1.890
LGA    Q    26_F      F      33          2.347
LGA    S    27_F      T      34          2.456
LGA    S    28_F      G      35          2.718
LGA    G    29_F      K      36          3.937
LGA    -       -      T      37           -
LGA    L    30_F      L      38          2.304
LGA    E    31_F      D      39          1.440
LGA    H    32_F      Y      40          2.321
LGA    R    33_F      K      41          2.753
LGA    F    34_F      T      42          1.721
LGA    I    35_F      Q      43          0.873
LGA    H    36_F      K      44          1.281
LGA    L    37_F      L      45          1.676
LGA    I    38_F      I      46          1.774
LGA    K    39_F      A      47          1.101
LGA    L    40_F      I      48          0.624
LGA    R    41_F      G      49          1.255
LGA    A    42_F      I      50          1.454
LGA    S    43_F      V      51          1.268
LGA    I    44_F      A      52          1.574
LGA    I    45_F      S      53          2.348
LGA    N    46_F      R      54          3.097
LGA    G    47_F      C      55          2.332
LGA    C    48_F      D      56          2.725
LGA    A    49_F      E      57          3.159
LGA    F    50_F      V      58          3.607
LGA    C    51_F      A      59          2.962
LGA    V    52_F      I      60          1.871
LGA    D    53_F      E      61          2.208
LGA    M    54_F      K      62          2.547
LGA    H    55_F      Q      63          1.933
LGA    V    56_F      M      64          0.940
LGA    K    57_F      K      65          1.998
LGA    E    58_F      S      66          3.130
LGA    S    59_F      A      67          2.765
LGA    R    60_F      M      68          2.021
LGA    H    61_F      K      69          3.582
LGA    -       -      E      70           -
LGA    -       -      L      71           -
LGA    D    62_F      G      72          2.396
LGA    G    63_F      I      73          3.342
LGA    L    64_F      T      74          3.085
LGA    S    65_F      -       -           -
LGA    E    66_F      K      75          1.164
LGA    Q    67_F      E      76          2.705
LGA    W    68_F      E      77          2.624
LGA    I    69_F      I      78          1.267
LGA    N    70_F      A      79          3.461
LGA    L    71_F      D      80          5.044
LGA    M    72_F      V      81          3.324
LGA    S    73_F      L      82          3.865
LGA    -       -      R      83           -
LGA    V    74_F      V      84           #
LGA    W    75_F      V      85          3.692
LGA    R    76_F      L      86          4.456
LGA    E    77_F      L      87          4.929
LGA    S    78_F      -       -           -
LGA    P    79_F      -       -           -
LGA    V    80_F      -       -           -
LGA    Y    81_F      -       -           -
LGA    T    82_F      -       -           -
LGA    E    83_F      -       -           -
LGA    Q    84_F      -       -           -
LGA    E    85_F      -       -           -
LGA    R    86_F      -       -           -
LGA    A    87_F      -       -           -
LGA    L    88_F      -       -           -
LGA    L    89_F      T      88           #
LGA    G    90_F      -       -           -
LGA    W    91_F      -       -           -
LGA    V    92_F      -       -           -
LGA    D    93_F      S      89           #
LGA    A    94_F      G      90           -
LGA    V    95_F      M      91           -
LGA    T    96_F      P      92           -
LGA    K    97_F      A      93           -
LGA    I    98_F      F      94           -
LGA    A    99_F      T      95           -
LGA    E   100_F      K      96           -
LGA    T   101_F      A      97           -
LGA    G   102_F      M      98           -
LGA    A   103_F      K      99           -
LGA    P   104_F      I     100           -
LGA    D   105_F      L     101           -
LGA    D   106_F      E     102           -
LGA    A   107_F      K     103           -
LGA    F   108_F      -       -           -
LGA    E   109_F      -       -           -
LGA    T   110_F      -       -           -
LGA    L   111_F      -       -           -
LGA    R   112_F      -       -           -
LGA    A   113_F      -       -           -
LGA    H   114_F      -       -           -
LGA    F   115_F      -       -           -
LGA    S   116_F      -       -           -
LGA    D   117_F      -       -           -
LGA    E   118_F      -       -           -
LGA    E   119_F      -       -           -
LGA    I   120_F      -       -           -
LGA    V   121_F      -       -           -
LGA    K   122_F      -       -           -
LGA    I   123_F      -       -           -
LGA    T   124_F      -       -           -
LGA    V   125_F      -       -           -
LGA    A   126_F      -       -           -
LGA    I   127_F      -       -           -
LGA    G   128_F      -       -           -
LGA    A   129_F      -       -           -
LGA    I   130_F      -       -           -
LGA    N   131_F      -       -           -
LGA    T   132_F      -       -           -
LGA    W   133_F      -       -           -
LGA    N   134_F      -       -           -
LGA    R   135_F      -       -           -
LGA    I   136_F      -       -           -
LGA    A   137_F      -       -           -
LGA    V   138_F      -       -           -
LGA    G   139_F      -       -           -
LGA    F   140_F      -       -           -
LGA    R   141_F      -       -           -
LGA    S   142_F      -       -           -
LGA    Q   143_F      -       -           -
LGA    H   144_F      -       -           -
LGA    P   145_F      -       -           -
LGA    V   146_F      -       -           -
LGA    E   147_F      L     104           #
LGA    A   148_F      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  147   98    5.0     69    2.40    11.59     54.550     2.757

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.046770 * X  +  -0.182690 * Y  +  -0.982058 * Z  +  22.524506
  Y_new =   0.998899 * X  +   0.012255 * Y  +   0.045292 * Z  +  30.241148
  Z_new =   0.003761 * X  +  -0.983094 * Y  +   0.183062 * Z  +  19.352301 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.386695    1.754898  [ DEG:   -79.4518    100.5482 ]
  Theta =  -0.003761   -3.137832  [ DEG:    -0.2155   -179.7845 ]
  Phi   =   1.524009   -1.617583  [ DEG:    87.3193    -92.6807 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2gmy_F                                        
REMARK     2: T0408.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2gmy_F.T0408.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  147   98   5.0   69   2.40   11.59  54.550
REMARK  ---------------------------------------------------------- 
MOLECULE 2gmy_F
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   07-APR-06   2GMY              
TITLE     CRYSTAL STRUCTURE OF A PROTEIN OF UNKNOWN FUNCTION ATU0492            
TITLE    2 FROM AGROBACTERIUM TUMEFACIENS, PUTATIVE ANTIOXIDANT                 
TITLE    3 DEFENCE PROTEIN AHPD                                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN ATU0492;                              
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AGROBACTERIUM TUMEFACIENS;                      
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: C58;                                                         
SOURCE   5 GENE: GI:17934405;                                                   
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    AGROBACTERIUM TUMEFACIENS, STRUCTURAL GENOMICS, PSI,                  
KEYWDS   2 PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL          
KEYWDS   3 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.ZHANG,X.XU,J.GU,A.SAVCHENKO,A.EDWARDS,A.JOACHIMIAK,                 
AUTHOR   2 MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)                        
REVDAT   1   09-MAY-06 2GMY    0                                                
JRNL        AUTH   R.ZHANG,X.XU,J.GU,A.SAVCHENKO,A.EDWARDS,                     
JRNL        AUTH 2 A.JOACHIMIAK                                                 
JRNL        TITL   THE CRYSTAL STRUCTURE OF A HYPOTHETICAL PROTEIN              
JRNL        TITL 2 ATU0492 FROM AGROBACTERIUM TUMEFACIENS                       
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.60 ANGSTROMS.                                          
DBREF  2GMY A    1   153  GB     17738839 AAL41511         1    153             
DBREF  2GMY B    1   153  GB     17738839 AAL41511         1    153             
DBREF  2GMY C    1   153  GB     17738839 AAL41511         1    153             
DBREF  2GMY D    1   153  GB     17738839 AAL41511         1    153             
DBREF  2GMY E    1   153  GB     17738839 AAL41511         1    153             
DBREF  2GMY F    1   153  GB     17738839 AAL41511         1    153             
SEQRES   1 A  153  MET LYS THR ARG ILE ASN TYR ALA LYS ALA SER PRO GLU          
SEQRES   2 A  153  ALA PHE LYS ALA VAL MET ALA LEU GLU ASN TYR VAL GLN          
SEQRES   3 A  153  SER SER GLY LEU GLU HIS ARG PHE ILE HIS LEU ILE LYS          
SEQRES   4 A  153  LEU ARG ALA SER ILE ILE ASN GLY CYS ALA PHE CYS VAL          
SEQRES   5 A  153  ASP MET HIS VAL LYS GLU SER ARG HIS ASP GLY LEU SER          
SEQRES   6 A  153  GLU GLN TRP ILE ASN LEU MET SER VAL TRP ARG GLU SER          
SEQRES   7 A  153  PRO VAL TYR THR GLU GLN GLU ARG ALA LEU LEU GLY TRP          
SEQRES   8 A  153  VAL ASP ALA VAL THR LYS ILE ALA GLU THR GLY ALA PRO          
SEQRES   9 A  153  ASP ASP ALA PHE GLU THR LEU ARG ALA HIS PHE SER ASP          
SEQRES  10 A  153  GLU GLU ILE VAL LYS ILE THR VAL ALA ILE GLY ALA ILE          
SEQRES  11 A  153  ASN THR TRP ASN ARG ILE ALA VAL GLY PHE ARG SER GLN          
SEQRES  12 A  153  HIS PRO VAL GLU ALA ALA ALA LYS ALA ALA                      
SEQRES   1 B  153  MET LYS THR ARG ILE ASN TYR ALA LYS ALA SER PRO GLU          
SEQRES   2 B  153  ALA PHE LYS ALA VAL MET ALA LEU GLU ASN TYR VAL GLN          
SEQRES   3 B  153  SER SER GLY LEU GLU HIS ARG PHE ILE HIS LEU ILE LYS          
SEQRES   4 B  153  LEU ARG ALA SER ILE ILE ASN GLY CYS ALA PHE CYS VAL          
SEQRES   5 B  153  ASP MET HIS VAL LYS GLU SER ARG HIS ASP GLY LEU SER          
SEQRES   6 B  153  GLU GLN TRP ILE ASN LEU MET SER VAL TRP ARG GLU SER          
SEQRES   7 B  153  PRO VAL TYR THR GLU GLN GLU ARG ALA LEU LEU GLY TRP          
SEQRES   8 B  153  VAL ASP ALA VAL THR LYS ILE ALA GLU THR GLY ALA PRO          
SEQRES   9 B  153  ASP ASP ALA PHE GLU THR LEU ARG ALA HIS PHE SER ASP          
SEQRES  10 B  153  GLU GLU ILE VAL LYS ILE THR VAL ALA ILE GLY ALA ILE          
SEQRES  11 B  153  ASN THR TRP ASN ARG ILE ALA VAL GLY PHE ARG SER GLN          
SEQRES  12 B  153  HIS PRO VAL GLU ALA ALA ALA LYS ALA ALA                      
SEQRES   1 C  153  MET LYS THR ARG ILE ASN TYR ALA LYS ALA SER PRO GLU          
SEQRES   2 C  153  ALA PHE LYS ALA VAL MET ALA LEU GLU ASN TYR VAL GLN          
SEQRES   3 C  153  SER SER GLY LEU GLU HIS ARG PHE ILE HIS LEU ILE LYS          
SEQRES   4 C  153  LEU ARG ALA SER ILE ILE ASN GLY CYS ALA PHE CYS VAL          
SEQRES   5 C  153  ASP MET HIS VAL LYS GLU SER ARG HIS ASP GLY LEU SER          
SEQRES   6 C  153  GLU GLN TRP ILE ASN LEU MET SER VAL TRP ARG GLU SER          
SEQRES   7 C  153  PRO VAL TYR THR GLU GLN GLU ARG ALA LEU LEU GLY TRP          
SEQRES   8 C  153  VAL ASP ALA VAL THR LYS ILE ALA GLU THR GLY ALA PRO          
SEQRES   9 C  153  ASP ASP ALA PHE GLU THR LEU ARG ALA HIS PHE SER ASP          
SEQRES  10 C  153  GLU GLU ILE VAL LYS ILE THR VAL ALA ILE GLY ALA ILE          
SEQRES  11 C  153  ASN THR TRP ASN ARG ILE ALA VAL GLY PHE ARG SER GLN          
SEQRES  12 C  153  HIS PRO VAL GLU ALA ALA ALA LYS ALA ALA                      
SEQRES   1 D  153  MET LYS THR ARG ILE ASN TYR ALA LYS ALA SER PRO GLU          
SEQRES   2 D  153  ALA PHE LYS ALA VAL MET ALA LEU GLU ASN TYR VAL GLN          
SEQRES   3 D  153  SER SER GLY LEU GLU HIS ARG PHE ILE HIS LEU ILE LYS          
SEQRES   4 D  153  LEU ARG ALA SER ILE ILE ASN GLY CYS ALA PHE CYS VAL          
SEQRES   5 D  153  ASP MET HIS VAL LYS GLU SER ARG HIS ASP GLY LEU SER          
SEQRES   6 D  153  GLU GLN TRP ILE ASN LEU MET SER VAL TRP ARG GLU SER          
SEQRES   7 D  153  PRO VAL TYR THR GLU GLN GLU ARG ALA LEU LEU GLY TRP          
SEQRES   8 D  153  VAL ASP ALA VAL THR LYS ILE ALA GLU THR GLY ALA PRO          
SEQRES   9 D  153  ASP ASP ALA PHE GLU THR LEU ARG ALA HIS PHE SER ASP          
SEQRES  10 D  153  GLU GLU ILE VAL LYS ILE THR VAL ALA ILE GLY ALA ILE          
SEQRES  11 D  153  ASN THR TRP ASN ARG ILE ALA VAL GLY PHE ARG SER GLN          
SEQRES  12 D  153  HIS PRO VAL GLU ALA ALA ALA LYS ALA ALA                      
SEQRES   1 E  153  MET LYS THR ARG ILE ASN TYR ALA LYS ALA SER PRO GLU          
SEQRES   2 E  153  ALA PHE LYS ALA VAL MET ALA LEU GLU ASN TYR VAL GLN          
SEQRES   3 E  153  SER SER GLY LEU GLU HIS ARG PHE ILE HIS LEU ILE LYS          
SEQRES   4 E  153  LEU ARG ALA SER ILE ILE ASN GLY CYS ALA PHE CYS VAL          
SEQRES   5 E  153  ASP MET HIS VAL LYS GLU SER ARG HIS ASP GLY LEU SER          
SEQRES   6 E  153  GLU GLN TRP ILE ASN LEU MET SER VAL TRP ARG GLU SER          
SEQRES   7 E  153  PRO VAL TYR THR GLU GLN GLU ARG ALA LEU LEU GLY TRP          
SEQRES   8 E  153  VAL ASP ALA VAL THR LYS ILE ALA GLU THR GLY ALA PRO          
SEQRES   9 E  153  ASP ASP ALA PHE GLU THR LEU ARG ALA HIS PHE SER ASP          
SEQRES  10 E  153  GLU GLU ILE VAL LYS ILE THR VAL ALA ILE GLY ALA ILE          
SEQRES  11 E  153  ASN THR TRP ASN ARG ILE ALA VAL GLY PHE ARG SER GLN          
SEQRES  12 E  153  HIS PRO VAL GLU ALA ALA ALA LYS ALA ALA                      
SEQRES   1 F  153  MET LYS THR ARG ILE ASN TYR ALA LYS ALA SER PRO GLU          
SEQRES   2 F  153  ALA PHE LYS ALA VAL MET ALA LEU GLU ASN TYR VAL GLN          
SEQRES   3 F  153  SER SER GLY LEU GLU HIS ARG PHE ILE HIS LEU ILE LYS          
SEQRES   4 F  153  LEU ARG ALA SER ILE ILE ASN GLY CYS ALA PHE CYS VAL          
SEQRES   5 F  153  ASP MET HIS VAL LYS GLU SER ARG HIS ASP GLY LEU SER          
SEQRES   6 F  153  GLU GLN TRP ILE ASN LEU MET SER VAL TRP ARG GLU SER          
SEQRES   7 F  153  PRO VAL TYR THR GLU GLN GLU ARG ALA LEU LEU GLY TRP          
SEQRES   8 F  153  VAL ASP ALA VAL THR LYS ILE ALA GLU THR GLY ALA PRO          
SEQRES   9 F  153  ASP ASP ALA PHE GLU THR LEU ARG ALA HIS PHE SER ASP          
SEQRES  10 F  153  GLU GLU ILE VAL LYS ILE THR VAL ALA ILE GLY ALA ILE          
SEQRES  11 F  153  ASN THR TRP ASN ARG ILE ALA VAL GLY PHE ARG SER GLN          
SEQRES  12 F  153  HIS PRO VAL GLU ALA ALA ALA LYS ALA ALA                      
FORMUL   7  HOH   *767(H2 O)                                                    
CRYST1   75.009   75.009  148.755  90.00  90.00 120.00 P 31         18          
ATOM   5802  N   LYS F   2      20.665  66.372  33.664  1.00 33.79           N  
ATOM   5803  CA  LYS F   2      21.154  67.610  32.986  1.00 33.69           C  
ATOM   5804  C   LYS F   2      20.063  68.316  32.167  1.00 33.00           C  
ATOM   5805  O   LYS F   2      19.334  67.685  31.393  1.00 33.19           O  
ATOM   5806  CB  LYS F   2      22.368  67.287  32.109  1.00 34.10           C  
ATOM   5807  CG  LYS F   2      23.177  68.496  31.669  1.00 35.82           C  
ATOM   5808  CD  LYS F   2      24.554  68.062  31.190  1.00 38.14           C  
ATOM   5809  CE  LYS F   2      25.102  69.010  30.139  1.00 39.06           C  
ATOM   5810  NZ  LYS F   2      26.287  68.413  29.462  1.00 39.51           N  
ATOM   5811  N   THR F   3      19.971  69.629  32.358  1.00 31.93           N  
ATOM   5812  CA  THR F   3      18.989  70.479  31.692  1.00 30.84           C  
ATOM   5813  C   THR F   3      19.334  70.626  30.204  1.00 29.98           C  
ATOM   5814  O   THR F   3      20.504  70.787  29.844  1.00 29.78           O  
ATOM   5815  CB  THR F   3      18.939  71.863  32.378  1.00 31.14           C  
ATOM   5816  OG1 THR F   3      18.628  71.691  33.769  1.00 31.74           O  
ATOM   5817  CG2 THR F   3      17.892  72.755  31.755  1.00 31.65           C  
ATOM   5818  N   ARG F   4      18.318  70.550  29.344  1.00 28.51           N  
ATOM   5819  CA  ARG F   4      18.505  70.718  27.899  1.00 27.39           C  
ATOM   5820  C   ARG F   4      18.622  72.181  27.488  1.00 27.63           C  
ATOM   5821  O   ARG F   4      19.540  72.552  26.756  1.00 27.30           O  
ATOM   5822  CB  ARG F   4      17.356  70.072  27.126  1.00 26.74           C  
ATOM   5823  CG  ARG F   4      17.468  68.576  26.985  1.00 25.30           C  
ATOM   5824  CD  ARG F   4      16.157  67.997  26.502  1.00 21.54           C  
ATOM   5825  NE  ARG F   4      16.255  66.558  26.331  1.00 20.31           N  
ATOM   5826  CZ  ARG F   4      15.220  65.757  26.111  1.00 20.70           C  
ATOM   5827  NH1 ARG F   4      13.988  66.260  26.056  1.00 19.27           N  
ATOM   5828  NH2 ARG F   4      15.420  64.457  25.954  1.00 19.60           N  
ATOM   5829  N   ILE F   5      17.679  73.000  27.949  1.00 28.10           N  
ATOM   5830  CA  ILE F   5      17.609  74.418  27.591  1.00 28.97           C  
ATOM   5831  C   ILE F   5      17.143  75.236  28.792  1.00 29.16           C  
ATOM   5832  O   ILE F   5      16.194  74.850  29.489  1.00 28.85           O  
ATOM   5833  CB  ILE F   5      16.622  74.674  26.399  1.00 28.91           C  
ATOM   5834  CG1 ILE F   5      17.064  73.932  25.130  1.00 29.74           C  
ATOM   5835  CG2 ILE F   5      16.476  76.171  26.113  1.00 29.56           C  
ATOM   5836  CD1 ILE F   5      16.056  74.002  23.986  1.00 29.25           C  
ATOM   5837  N   ASN F   6      17.820  76.356  29.036  1.00 30.11           N  
ATOM   5838  CA  ASN F   6      17.350  77.352  29.990  1.00 30.95           C  
ATOM   5839  C   ASN F   6      16.341  78.221  29.248  1.00 31.06           C  
ATOM   5840  O   ASN F   6      16.691  79.235  28.633  1.00 31.11           O  
ATOM   5841  CB  ASN F   6      18.517  78.181  30.545  1.00 31.59           C  
ATOM   5842  CG  ASN F   6      18.072  79.247  31.548  1.00 32.86           C  
ATOM   5843  OD1 ASN F   6      16.877  79.511  31.724  1.00 35.49           O  
ATOM   5844  ND2 ASN F   6      19.042  79.869  32.207  1.00 34.60           N  
ATOM   5845  N   TYR F   7      15.084  77.800  29.307  1.00 31.15           N  
ATOM   5846  CA  TYR F   7      14.029  78.387  28.486  1.00 31.35           C  
ATOM   5847  C   TYR F   7      13.687  79.835  28.847  1.00 31.35           C  
ATOM   5848  O   TYR F   7      13.311  80.617  27.975  1.00 31.22           O  
ATOM   5849  CB  TYR F   7      12.779  77.494  28.494  1.00 31.81           C  
ATOM   5850  CG  TYR F   7      12.211  77.219  29.873  1.00 32.10           C  
ATOM   5851  CD1 TYR F   7      11.217  78.037  30.408  1.00 32.25           C  
ATOM   5852  CD2 TYR F   7      12.656  76.131  30.635  1.00 32.59           C  
ATOM   5853  CE1 TYR F   7      10.687  77.797  31.664  1.00 33.39           C  
ATOM   5854  CE2 TYR F   7      12.130  75.879  31.905  1.00 33.18           C  
ATOM   5855  CZ  TYR F   7      11.142  76.722  32.410  1.00 33.20           C  
ATOM   5856  OH  TYR F   7      10.599  76.500  33.662  1.00 33.78           O  
ATOM   5857  N   ALA F   8      13.825  80.188  30.126  1.00 31.40           N  
ATOM   5858  CA  ALA F   8      13.642  81.573  30.574  1.00 31.64           C  
ATOM   5859  C   ALA F   8      14.681  82.513  29.947  1.00 31.98           C  
ATOM   5860  O   ALA F   8      14.387  83.687  29.691  1.00 32.24           O  
ATOM   5861  CB  ALA F   8      13.689  81.661  32.091  1.00 31.60           C  
ATOM   5862  N   LYS F   9      15.881  81.987  29.698  1.00 31.93           N  
ATOM   5863  CA  LYS F   9      16.962  82.742  29.059  1.00 32.47           C  
ATOM   5864  C   LYS F   9      16.855  82.708  27.536  1.00 31.77           C  
ATOM   5865  O   LYS F   9      17.050  83.729  26.870  1.00 32.05           O  
ATOM   5866  CB  LYS F   9      18.328  82.202  29.498  1.00 32.58           C  
ATOM   5867  CG  LYS F   9      19.523  83.048  29.031  1.00 34.02           C  
ATOM   5868  CD  LYS F   9      20.851  82.539  29.599  1.00 34.28           C  
ATOM   5869  CE  LYS F   9      21.304  81.240  28.932  1.00 37.32           C  
ATOM   5870  NZ  LYS F   9      22.567  80.717  29.536  1.00 38.68           N  
ATOM   5871  N   ALA F  10      16.545  81.533  26.992  1.00 30.95           N  
ATOM   5872  CA  ALA F  10      16.481  81.337  25.544  1.00 30.30           C  
ATOM   5873  C   ALA F  10      15.385  82.168  24.874  1.00 29.69           C  
ATOM   5874  O   ALA F  10      15.581  82.694  23.774  1.00 29.29           O  
ATOM   5875  CB  ALA F  10      16.308  79.858  25.219  1.00 30.15           C  
ATOM   5876  N   SER F  11      14.228  82.266  25.529  1.00 28.92           N  
ATOM   5877  CA  SER F  11      13.134  83.105  25.038  1.00 28.43           C  
ATOM   5878  C   SER F  11      12.363  83.764  26.184  1.00 27.97           C  
ATOM   5879  O   SER F  11      11.313  83.268  26.621  1.00 27.57           O  
ATOM   5880  CB  SER F  11      12.195  82.315  24.114  1.00 28.76           C  
ATOM   5881  OG  SER F  11      11.183  83.161  23.591  1.00 28.82           O  
ATOM   5882  N   PRO F  12      12.882  84.899  26.685  1.00 27.50           N  
ATOM   5883  CA  PRO F  12      12.232  85.599  27.789  1.00 26.90           C  
ATOM   5884  C   PRO F  12      10.759  85.905  27.535  1.00 26.41           C  
ATOM   5885  O   PRO F  12       9.946  85.738  28.440  1.00 25.91           O  
ATOM   5886  CB  PRO F  12      13.055  86.892  27.910  1.00 27.26           C  
ATOM   5887  CG  PRO F  12      14.406  86.502  27.415  1.00 27.44           C  
ATOM   5888  CD  PRO F  12      14.114  85.589  26.252  1.00 27.72           C  
ATOM   5889  N   GLU F  13      10.412  86.315  26.315  1.00 26.11           N  
ATOM   5890  CA  GLU F  13       9.028  86.673  25.981  1.00 26.27           C  
ATOM   5891  C   GLU F  13       8.070  85.471  26.050  1.00 25.21           C  
ATOM   5892  O   GLU F  13       6.963  85.591  26.564  1.00 25.03           O  
ATOM   5893  CB  GLU F  13       8.947  87.345  24.603  1.00 26.87           C  
ATOM   5894  CG  GLU F  13       9.743  88.648  24.480  1.00 30.25           C  
ATOM   5895  CD  GLU F  13      11.255  88.436  24.494  1.00 34.82           C  
ATOM   5896  OE1 GLU F  13      11.772  87.515  23.812  1.00 35.81           O  
ATOM   5897  OE2 GLU F  13      11.941  89.200  25.203  1.00 38.53           O  
ATOM   5898  N   ALA F  14       8.501  84.321  25.535  1.00 24.65           N  
ATOM   5899  CA  ALA F  14       7.700  83.091  25.635  1.00 23.78           C  
ATOM   5900  C   ALA F  14       7.472  82.698  27.093  1.00 23.42           C  
ATOM   5901  O   ALA F  14       6.344  82.359  27.486  1.00 23.46           O  
ATOM   5902  CB  ALA F  14       8.363  81.946  24.867  1.00 23.24           C  
ATOM   5903  N   PHE F  15       8.543  82.749  27.885  1.00 23.21           N  
ATOM   5904  CA  PHE F  15       8.473  82.501  29.324  1.00 23.20           C  
ATOM   5905  C   PHE F  15       7.458  83.423  29.995  1.00 22.67           C  
ATOM   5906  O   PHE F  15       6.610  82.969  30.764  1.00 22.39           O  
ATOM   5907  CB  PHE F  15       9.855  82.674  29.967  1.00 23.47           C  
ATOM   5908  CG  PHE F  15       9.864  82.485  31.465  1.00 25.02           C  
ATOM   5909  CD1 PHE F  15       9.722  81.217  32.022  1.00 25.23           C  
ATOM   5910  CD2 PHE F  15      10.016  83.580  32.318  1.00 25.21           C  
ATOM   5911  CE1 PHE F  15       9.738  81.038  33.406  1.00 26.11           C  
ATOM   5912  CE2 PHE F  15      10.031  83.413  33.703  1.00 26.40           C  
ATOM   5913  CZ  PHE F  15       9.890  82.136  34.247  1.00 25.83           C  
ATOM   5914  N   LYS F  16       7.532  84.717  29.679  1.00 21.97           N  
ATOM   5915  CA  LYS F  16       6.603  85.700  30.234  1.00 21.76           C  
ATOM   5916  C   LYS F  16       5.148  85.403  29.887  1.00 20.86           C  
ATOM   5917  O   LYS F  16       4.256  85.577  30.723  1.00 21.08           O  
ATOM   5918  CB  LYS F  16       6.971  87.110  29.764  1.00 22.17           C  
ATOM   5919  CG  LYS F  16       8.229  87.650  30.408  1.00 24.31           C  
ATOM   5920  CD  LYS F  16       8.631  88.980  29.784  1.00 28.22           C  
ATOM   5921  CE  LYS F  16      10.069  89.343  30.157  1.00 30.60           C  
ATOM   5922  NZ  LYS F  16      10.500  90.613  29.502  1.00 33.11           N  
ATOM   5923  N   ALA F  17       4.914  84.947  28.658  1.00 20.15           N  
ATOM   5924  CA  ALA F  17       3.566  84.624  28.206  1.00 19.61           C  
ATOM   5925  C   ALA F  17       2.953  83.475  29.013  1.00 19.47           C  
ATOM   5926  O   ALA F  17       1.778  83.538  29.407  1.00 18.96           O  
ATOM   5927  CB  ALA F  17       3.564  84.315  26.717  1.00 19.74           C  
ATOM   5928  N   VAL F  18       3.750  82.436  29.269  1.00 19.39           N  
ATOM   5929  CA  VAL F  18       3.284  81.322  30.106  1.00 19.50           C  
ATOM   5930  C   VAL F  18       3.083  81.795  31.551  1.00 19.02           C  
ATOM   5931  O   VAL F  18       2.093  81.438  32.197  1.00 18.82           O  
ATOM   5932  CB  VAL F  18       4.213  80.085  30.031  1.00 19.54           C  
ATOM   5933  CG1 VAL F  18       3.584  78.924  30.793  1.00 21.32           C  
ATOM   5934  CG2 VAL F  18       4.425  79.668  28.579  1.00 19.49           C  
ATOM   5935  N   MET F  19       3.988  82.642  32.040  1.00 19.30           N  
ATOM   5936  CA  MET F  19       3.841  83.217  33.382  1.00 19.34           C  
ATOM   5937  C   MET F  19       2.569  84.072  33.528  1.00 18.78           C  
ATOM   5938  O   MET F  19       1.959  84.101  34.598  1.00 18.99           O  
ATOM   5939  CB  MET F  19       5.084  84.022  33.790  1.00 20.01           C  
ATOM   5940  CG  MET F  19       6.291  83.179  34.236  1.00 22.23           C  
ATOM   5941  SD  MET F  19       6.033  81.981  35.598  1.00 24.52           S  
ATOM   5942  CE  MET F  19       4.898  82.793  36.712  1.00 28.08           C  
ATOM   5943  N   ALA F  20       2.167  84.754  32.454  1.00 18.38           N  
ATOM   5944  CA  ALA F  20       0.921  85.515  32.473  1.00 18.35           C  
ATOM   5945  C   ALA F  20      -0.308  84.595  32.650  1.00 18.03           C  
ATOM   5946  O   ALA F  20      -1.222  84.908  33.413  1.00 17.93           O  
ATOM   5947  CB  ALA F  20       0.795  86.382  31.222  1.00 18.67           C  
ATOM   5948  N   LEU F  21      -0.316  83.451  31.958  1.00 17.63           N  
ATOM   5949  CA  LEU F  21      -1.409  82.491  32.104  1.00 18.24           C  
ATOM   5950  C   LEU F  21      -1.439  81.947  33.527  1.00 17.65           C  
ATOM   5951  O   LEU F  21      -2.501  81.823  34.136  1.00 17.81           O  
ATOM   5952  CB  LEU F  21      -1.273  81.340  31.100  1.00 17.81           C  
ATOM   5953  CG  LEU F  21      -2.379  80.274  31.160  1.00 19.11           C  
ATOM   5954  CD1 LEU F  21      -3.781  80.865  31.051  1.00 19.15           C  
ATOM   5955  CD2 LEU F  21      -2.138  79.203  30.102  1.00 19.35           C  
ATOM   5956  N   GLU F  22      -0.253  81.630  34.044  1.00 18.50           N  
ATOM   5957  CA  GLU F  22      -0.076  81.167  35.416  1.00 19.05           C  
ATOM   5958  C   GLU F  22      -0.632  82.179  36.422  1.00 18.77           C  
ATOM   5959  O   GLU F  22      -1.316  81.817  37.384  1.00 17.89           O  
ATOM   5960  CB  GLU F  22       1.416  80.923  35.677  1.00 19.49           C  
ATOM   5961  CG  GLU F  22       1.750  80.361  37.045  1.00 22.52           C  
ATOM   5962  CD  GLU F  22       1.089  79.013  37.321  1.00 26.62           C  
ATOM   5963  OE1 GLU F  22       0.887  78.218  36.369  1.00 26.71           O  
ATOM   5964  OE2 GLU F  22       0.774  78.757  38.502  1.00 29.04           O  
ATOM   5965  N   ASN F  23      -0.342  83.457  36.173  1.00 18.71           N  
ATOM   5966  CA  ASN F  23      -0.838  84.528  37.016  1.00 19.17           C  
ATOM   5967  C   ASN F  23      -2.361  84.583  36.993  1.00 19.16           C  
ATOM   5968  O   ASN F  23      -3.000  84.771  38.033  1.00 19.41           O  
ATOM   5969  CB  ASN F  23      -0.230  85.863  36.557  1.00 19.00           C  
ATOM   5970  CG  ASN F  23      -0.554  87.025  37.498  1.00 20.89           C  
ATOM   5971  OD1 ASN F  23      -0.546  86.880  38.726  1.00 22.66           O  
ATOM   5972  ND2 ASN F  23      -0.813  88.194  36.917  1.00 20.22           N  
ATOM   5973  N   TYR F  24      -2.951  84.401  35.811  1.00 19.31           N  
ATOM   5974  CA  TYR F  24      -4.400  84.310  35.742  1.00 19.13           C  
ATOM   5975  C   TYR F  24      -4.950  83.174  36.605  1.00 18.90           C  
ATOM   5976  O   TYR F  24      -5.865  83.380  37.389  1.00 18.31           O  
ATOM   5977  CB  TYR F  24      -4.960  84.156  34.312  1.00 20.00           C  
ATOM   5978  CG  TYR F  24      -6.426  83.788  34.437  1.00 20.99           C  
ATOM   5979  CD1 TYR F  24      -7.369  84.757  34.783  1.00 22.50           C  
ATOM   5980  CD2 TYR F  24      -6.856  82.461  34.342  1.00 21.88           C  
ATOM   5981  CE1 TYR F  24      -8.693  84.437  34.981  1.00 23.77           C  
ATOM   5982  CE2 TYR F  24      -8.202  82.129  34.547  1.00 22.39           C  
ATOM   5983  CZ  TYR F  24      -9.107  83.130  34.857  1.00 23.20           C  
ATOM   5984  OH  TYR F  24     -10.443  82.844  35.062  1.00 24.53           O  
ATOM   5985  N   VAL F  25      -4.391  81.978  36.448  1.00 19.12           N  
ATOM   5986  CA  VAL F  25      -4.862  80.825  37.216  1.00 19.77           C  
ATOM   5987  C   VAL F  25      -4.795  81.114  38.723  1.00 20.83           C  
ATOM   5988  O   VAL F  25      -5.767  80.876  39.438  1.00 20.74           O  
ATOM   5989  CB  VAL F  25      -4.085  79.546  36.839  1.00 19.40           C  
ATOM   5990  CG1 VAL F  25      -4.387  78.402  37.816  1.00 19.21           C  
ATOM   5991  CG2 VAL F  25      -4.410  79.142  35.409  1.00 18.85           C  
ATOM   5992  N   GLN F  26      -3.670  81.658  39.187  1.00 22.39           N  
ATOM   5993  CA  GLN F  26      -3.476  81.931  40.620  1.00 24.38           C  
ATOM   5994  C   GLN F  26      -4.505  82.904  41.191  1.00 24.98           C  
ATOM   5995  O   GLN F  26      -4.897  82.800  42.359  1.00 25.79           O  
ATOM   5996  CB  GLN F  26      -2.067  82.468  40.892  1.00 24.80           C  
ATOM   5997  CG  GLN F  26      -0.944  81.455  40.720  1.00 28.06           C  
ATOM   5998  CD  GLN F  26      -1.023  80.258  41.677  1.00 32.48           C  
ATOM   5999  OE1 GLN F  26      -1.566  80.348  42.786  1.00 34.02           O  
ATOM   6000  NE2 GLN F  26      -0.468  79.127  41.244  1.00 34.56           N  
ATOM   6001  N   SER F  27      -4.935  83.851  40.367  1.00 25.41           N  
ATOM   6002  CA  SER F  27      -5.831  84.915  40.821  1.00 26.22           C  
ATOM   6003  C   SER F  27      -7.268  84.702  40.353  1.00 25.87           C  
ATOM   6004  O   SER F  27      -8.115  85.588  40.503  1.00 25.95           O  
ATOM   6005  CB  SER F  27      -5.317  86.263  40.315  1.00 26.55           C  
ATOM   6006  OG  SER F  27      -5.267  86.278  38.904  1.00 29.79           O  
ATOM   6007  N   SER F  28      -7.539  83.520  39.801  1.00 25.16           N  
ATOM   6008  CA  SER F  28      -8.814  83.240  39.144  1.00 24.97           C  
ATOM   6009  C   SER F  28     -10.022  83.231  40.079  1.00 24.86           C  
ATOM   6010  O   SER F  28     -11.146  83.463  39.634  1.00 25.41           O  
ATOM   6011  CB  SER F  28      -8.749  81.903  38.400  1.00 24.91           C  
ATOM   6012  OG  SER F  28      -8.630  80.827  39.309  1.00 25.03           O  
ATOM   6013  N   GLY F  29      -9.792  82.956  41.362  1.00 24.32           N  
ATOM   6014  CA  GLY F  29     -10.883  82.824  42.330  1.00 23.74           C  
ATOM   6015  C   GLY F  29     -11.110  81.396  42.818  1.00 23.75           C  
ATOM   6016  O   GLY F  29     -11.827  81.184  43.793  1.00 23.63           O  
ATOM   6017  N   LEU F  30     -10.519  80.412  42.135  1.00 23.70           N  
ATOM   6018  CA  LEU F  30     -10.592  79.016  42.591  1.00 23.93           C  
ATOM   6019  C   LEU F  30      -9.935  78.856  43.952  1.00 24.00           C  
ATOM   6020  O   LEU F  30      -8.917  79.501  44.214  1.00 24.48           O  
ATOM   6021  CB  LEU F  30      -9.896  78.078  41.601  1.00 23.99           C  
ATOM   6022  CG  LEU F  30     -10.585  77.725  40.292  1.00 24.95           C  
ATOM   6023  CD1 LEU F  30      -9.736  76.715  39.552  1.00 24.85           C  
ATOM   6024  CD2 LEU F  30     -11.978  77.160  40.546  1.00 24.45           C  
ATOM   6025  N   GLU F  31     -10.508  78.006  44.809  1.00 24.23           N  
ATOM   6026  CA  GLU F  31      -9.913  77.690  46.116  1.00 25.23           C  
ATOM   6027  C   GLU F  31      -8.486  77.210  45.870  1.00 24.37           C  
ATOM   6028  O   GLU F  31      -8.249  76.445  44.915  1.00 23.70           O  
ATOM   6029  CB  GLU F  31     -10.676  76.568  46.828  1.00 25.54           C  
ATOM   6030  CG  GLU F  31     -12.009  76.922  47.500  1.00 28.33           C  
ATOM   6031  CD  GLU F  31     -12.561  75.760  48.350  1.00 28.73           C  
ATOM   6032  OE1 GLU F  31     -11.760  74.916  48.829  1.00 34.05           O  
ATOM   6033  OE2 GLU F  31     -13.800  75.684  48.540  1.00 33.81           O  
ATOM   6034  N   HIS F  32      -7.544  77.646  46.712  1.00 23.34           N  
ATOM   6035  CA  HIS F  32      -6.135  77.226  46.592  1.00 22.86           C  
ATOM   6036  C   HIS F  32      -6.013  75.709  46.543  1.00 21.64           C  
ATOM   6037  O   HIS F  32      -5.234  75.158  45.764  1.00 20.81           O  
ATOM   6038  CB  HIS F  32      -5.234  77.831  47.699  1.00 23.88           C  
ATOM   6039  CG  HIS F  32      -5.356  77.173  49.047  1.00 26.85           C  
ATOM   6040  ND1 HIS F  32      -4.807  75.938  49.336  1.00 29.04           N  
ATOM   6041  CD2 HIS F  32      -5.924  77.605  50.200  1.00 30.13           C  
ATOM   6042  CE1 HIS F  32      -5.064  75.623  50.594  1.00 30.34           C  
ATOM   6043  NE2 HIS F  32      -5.740  76.618  51.141  1.00 31.33           N  
ATOM   6044  N   ARG F  33      -6.813  75.045  47.364  1.00 20.57           N  
ATOM   6045  CA  ARG F  33      -6.786  73.595  47.492  1.00 19.82           C  
ATOM   6046  C   ARG F  33      -7.047  72.914  46.157  1.00 18.73           C  
ATOM   6047  O   ARG F  33      -6.429  71.902  45.842  1.00 18.09           O  
ATOM   6048  CB  ARG F  33      -7.839  73.177  48.501  1.00 20.80           C  
ATOM   6049  CG  ARG F  33      -7.874  71.727  48.821  1.00 23.46           C  
ATOM   6050  CD  ARG F  33      -9.058  71.488  49.726  1.00 28.23           C  
ATOM   6051  NE  ARG F  33      -9.040  70.141  50.265  1.00 32.04           N  
ATOM   6052  CZ  ARG F  33      -8.596  69.820  51.477  1.00 33.51           C  
ATOM   6053  NH1 ARG F  33      -8.142  70.761  52.299  1.00 34.12           N  
ATOM   6054  NH2 ARG F  33      -8.629  68.556  51.872  1.00 34.12           N  
ATOM   6055  N   PHE F  34      -7.961  73.477  45.378  1.00 17.13           N  
ATOM   6056  CA  PHE F  34      -8.301  72.879  44.086  1.00 16.36           C  
ATOM   6057  C   PHE F  34      -7.219  73.166  43.070  1.00 15.81           C  
ATOM   6058  O   PHE F  34      -6.905  72.311  42.234  1.00 14.71           O  
ATOM   6059  CB  PHE F  34      -9.654  73.373  43.570  1.00 16.97           C  
ATOM   6060  CG  PHE F  34     -10.810  73.063  44.487  1.00 17.62           C  
ATOM   6061  CD1 PHE F  34     -10.898  71.842  45.160  1.00 19.24           C  
ATOM   6062  CD2 PHE F  34     -11.826  74.000  44.662  1.00 20.57           C  
ATOM   6063  CE1 PHE F  34     -11.974  71.564  46.012  1.00 20.83           C  
ATOM   6064  CE2 PHE F  34     -12.899  73.731  45.509  1.00 21.59           C  
ATOM   6065  CZ  PHE F  34     -12.976  72.505  46.174  1.00 20.66           C  
ATOM   6066  N   ILE F  35      -6.653  74.370  43.123  1.00 14.98           N  
ATOM   6067  CA  ILE F  35      -5.505  74.682  42.286  1.00 15.21           C  
ATOM   6068  C   ILE F  35      -4.328  73.719  42.544  1.00 14.15           C  
ATOM   6069  O   ILE F  35      -3.756  73.170  41.599  1.00 14.09           O  
ATOM   6070  CB  ILE F  35      -5.078  76.161  42.398  1.00 15.73           C  
ATOM   6071  CG1 ILE F  35      -6.213  77.055  41.869  1.00 17.46           C  
ATOM   6072  CG2 ILE F  35      -3.768  76.390  41.636  1.00 17.35           C  
ATOM   6073  CD1 ILE F  35      -6.073  78.526  42.236  1.00 19.55           C  
ATOM   6074  N   HIS F  36      -3.997  73.483  43.821  1.00 13.99           N  
ATOM   6075  CA  HIS F  36      -2.906  72.566  44.159  1.00 13.54           C  
ATOM   6076  C   HIS F  36      -3.206  71.156  43.653  1.00 13.28           C  
ATOM   6077  O   HIS F  36      -2.326  70.483  43.134  1.00 13.51           O  
ATOM   6078  CB  HIS F  36      -2.667  72.508  45.670  1.00 13.65           C  
ATOM   6079  CG  HIS F  36      -2.170  73.793  46.253  1.00 14.96           C  
ATOM   6080  ND1 HIS F  36      -1.097  74.482  45.737  1.00 17.53           N  
ATOM   6081  CD2 HIS F  36      -2.582  74.491  47.340  1.00 15.16           C  
ATOM   6082  CE1 HIS F  36      -0.877  75.564  46.469  1.00 17.89           C  
ATOM   6083  NE2 HIS F  36      -1.770  75.595  47.443  1.00 16.45           N  
ATOM   6084  N   LEU F  37      -4.447  70.717  43.845  1.00 12.75           N  
ATOM   6085  CA  LEU F  37      -4.872  69.379  43.403  1.00 12.25           C  
ATOM   6086  C   LEU F  37      -4.700  69.218  41.890  1.00 12.73           C  
ATOM   6087  O   LEU F  37      -4.153  68.216  41.400  1.00 11.91           O  
ATOM   6088  CB  LEU F  37      -6.329  69.138  43.802  1.00 12.30           C  
ATOM   6089  CG  LEU F  37      -6.943  67.779  43.456  1.00 13.14           C  
ATOM   6090  CD1 LEU F  37      -8.129  67.499  44.405  1.00 14.05           C  
ATOM   6091  CD2 LEU F  37      -7.398  67.717  42.004  1.00 12.64           C  
ATOM   6092  N   ILE F  38      -5.191  70.199  41.145  1.00 12.09           N  
ATOM   6093  CA  ILE F  38      -5.073  70.167  39.684  1.00 12.02           C  
ATOM   6094  C   ILE F  38      -3.612  70.071  39.264  1.00 11.79           C  
ATOM   6095  O   ILE F  38      -3.230  69.214  38.444  1.00 12.38           O  
ATOM   6096  CB  ILE F  38      -5.740  71.408  39.052  1.00 12.06           C  
ATOM   6097  CG1 ILE F  38      -7.272  71.331  39.209  1.00 12.73           C  
ATOM   6098  CG2 ILE F  38      -5.312  71.564  37.580  1.00 13.65           C  
ATOM   6099  CD1 ILE F  38      -7.990  72.661  38.996  1.00 13.26           C  
ATOM   6100  N   LYS F  39      -2.789  70.941  39.845  1.00 11.86           N  
ATOM   6101  CA  LYS F  39      -1.378  70.996  39.487  1.00 11.84           C  
ATOM   6102  C   LYS F  39      -0.630  69.723  39.883  1.00 11.70           C  
ATOM   6103  O   LYS F  39       0.163  69.201  39.091  1.00 11.71           O  
ATOM   6104  CB  LYS F  39      -0.722  72.226  40.116  1.00 12.02           C  
ATOM   6105  CG  LYS F  39      -1.189  73.542  39.481  1.00 14.12           C  
ATOM   6106  CD  LYS F  39      -0.442  74.704  40.123  1.00 19.48           C  
ATOM   6107  CE  LYS F  39      -1.029  76.066  39.749  1.00 23.15           C  
ATOM   6108  NZ  LYS F  39      -0.932  76.417  38.312  1.00 29.54           N  
ATOM   6109  N   LEU F  40      -0.866  69.222  41.091  1.00 11.92           N  
ATOM   6110  CA  LEU F  40      -0.143  68.043  41.552  1.00 11.66           C  
ATOM   6111  C   LEU F  40      -0.559  66.786  40.771  1.00 11.27           C  
ATOM   6112  O   LEU F  40       0.299  66.043  40.287  1.00 11.49           O  
ATOM   6113  CB  LEU F  40      -0.341  67.835  43.050  1.00 11.59           C  
ATOM   6114  CG  LEU F  40       0.357  66.646  43.716  1.00 12.02           C  
ATOM   6115  CD1 LEU F  40       1.861  66.582  43.422  1.00 12.56           C  
ATOM   6116  CD2 LEU F  40       0.127  66.732  45.217  1.00 12.08           C  
ATOM   6117  N   ARG F  41      -1.867  66.571  40.635  1.00 11.09           N  
ATOM   6118  CA  ARG F  41      -2.350  65.372  39.936  1.00 11.92           C  
ATOM   6119  C   ARG F  41      -1.898  65.335  38.467  1.00 11.51           C  
ATOM   6120  O   ARG F  41      -1.411  64.293  37.987  1.00 11.99           O  
ATOM   6121  CB  ARG F  41      -3.871  65.230  40.041  1.00 12.05           C  
ATOM   6122  CG  ARG F  41      -4.410  64.011  39.293  1.00 11.83           C  
ATOM   6123  CD  ARG F  41      -3.922  62.683  39.879  1.00 12.75           C  
ATOM   6124  NE  ARG F  41      -4.343  61.610  38.980  1.00 12.64           N  
ATOM   6125  CZ  ARG F  41      -3.819  60.393  38.967  1.00 14.47           C  
ATOM   6126  NH1 ARG F  41      -2.871  60.052  39.834  1.00 14.83           N  
ATOM   6127  NH2 ARG F  41      -4.263  59.505  38.079  1.00 14.64           N  
ATOM   6128  N   ALA F  42      -2.059  66.450  37.743  1.00 11.29           N  
ATOM   6129  CA  ALA F  42      -1.644  66.484  36.332  1.00 11.33           C  
ATOM   6130  C   ALA F  42      -0.149  66.237  36.178  1.00 11.31           C  
ATOM   6131  O   ALA F  42       0.277  65.504  35.285  1.00 11.88           O  
ATOM   6132  CB  ALA F  42      -2.046  67.810  35.646  1.00 11.65           C  
ATOM   6133  N   SER F  43       0.646  66.825  37.070  1.00 11.00           N  
ATOM   6134  CA  SER F  43       2.093  66.641  37.032  1.00 11.03           C  
ATOM   6135  C   SER F  43       2.491  65.166  37.241  1.00 11.08           C  
ATOM   6136  O   SER F  43       3.381  64.641  36.563  1.00 11.48           O  
ATOM   6137  CB  SER F  43       2.780  67.579  38.034  1.00 10.75           C  
ATOM   6138  OG  SER F  43       2.479  68.942  37.721  1.00 10.95           O  
ATOM   6139  N   ILE F  44       1.823  64.494  38.169  1.00 10.79           N  
ATOM   6140  CA  ILE F  44       2.060  63.073  38.367  1.00 11.07           C  
ATOM   6141  C   ILE F  44       1.720  62.285  37.102  1.00 11.44           C  
ATOM   6142  O   ILE F  44       2.532  61.487  36.637  1.00 11.41           O  
ATOM   6143  CB  ILE F  44       1.264  62.537  39.552  1.00 10.73           C  
ATOM   6144  CG1 ILE F  44       1.767  63.190  40.843  1.00 11.05           C  
ATOM   6145  CG2 ILE F  44       1.427  61.034  39.612  1.00 11.44           C  
ATOM   6146  CD1 ILE F  44       0.898  62.921  42.079  1.00 11.84           C  
ATOM   6147  N   ILE F  45       0.535  62.502  36.535  1.00 11.10           N  
ATOM   6148  CA  ILE F  45       0.169  61.787  35.290  1.00 11.44           C  
ATOM   6149  C   ILE F  45       1.221  62.001  34.212  1.00 11.43           C  
ATOM   6150  O   ILE F  45       1.620  61.052  33.505  1.00 11.51           O  
ATOM   6151  CB  ILE F  45      -1.205  62.251  34.751  1.00 11.45           C  
ATOM   6152  CG1 ILE F  45      -2.305  61.916  35.757  1.00 12.17           C  
ATOM   6153  CG2 ILE F  45      -1.491  61.641  33.347  1.00 11.99           C  
ATOM   6154  CD1 ILE F  45      -3.619  62.560  35.416  1.00 12.61           C  
ATOM   6155  N   ASN F  46       1.682  63.243  34.083  1.00 11.79           N  
ATOM   6156  CA  ASN F  46       2.602  63.605  33.014  1.00 12.07           C  
ATOM   6157  C   ASN F  46       4.070  63.253  33.250  1.00 12.32           C  
ATOM   6158  O   ASN F  46       4.923  63.520  32.393  1.00 12.07           O  
ATOM   6159  CB  ASN F  46       2.432  65.092  32.669  1.00 11.98           C  
ATOM   6160  CG  ASN F  46       1.164  65.351  31.863  1.00 11.94           C  
ATOM   6161  OD1 ASN F  46       0.729  64.482  31.106  1.00 12.32           O  
ATOM   6162  ND2 ASN F  46       0.586  66.548  32.000  1.00 12.35           N  
ATOM   6163  N   GLY F  47       4.364  62.661  34.408  1.00 12.44           N  
ATOM   6164  CA  GLY F  47       5.742  62.238  34.727  1.00 12.47           C  
ATOM   6165  C   GLY F  47       6.696  63.387  35.051  1.00 13.35           C  
ATOM   6166  O   GLY F  47       7.930  63.223  35.009  1.00 13.00           O  
ATOM   6167  N   CYS F  48       6.131  64.537  35.406  1.00 13.34           N  
ATOM   6168  CA  CYS F  48       6.937  65.737  35.597  1.00 12.85           C  
ATOM   6169  C   CYS F  48       7.432  65.886  37.032  1.00 12.42           C  
ATOM   6170  O   CYS F  48       6.717  66.390  37.892  1.00 12.82           O  
ATOM   6171  CB  CYS F  48       6.170  66.981  35.157  1.00 12.71           C  
ATOM   6172  SG  CYS F  48       7.220  68.467  35.132  1.00 15.70           S  
ATOM   6173  N   ALA F  49       8.662  65.445  37.271  1.00 11.48           N  
ATOM   6174  CA  ALA F  49       9.271  65.520  38.595  1.00 11.14           C  
ATOM   6175  C   ALA F  49       9.498  66.974  39.018  1.00 11.21           C  
ATOM   6176  O   ALA F  49       9.309  67.320  40.193  1.00 11.76           O  
ATOM   6177  CB  ALA F  49      10.581  64.735  38.622  1.00 11.59           C  
ATOM   6178  N   PHE F  50       9.895  67.823  38.066  1.00 12.00           N  
ATOM   6179  CA  PHE F  50      10.124  69.237  38.380  1.00 12.72           C  
ATOM   6180  C   PHE F  50       8.850  69.873  38.963  1.00 12.72           C  
ATOM   6181  O   PHE F  50       8.887  70.543  40.011  1.00 12.69           O  
ATOM   6182  CB  PHE F  50      10.561  69.971  37.121  1.00 13.90           C  
ATOM   6183  CG  PHE F  50      10.909  71.402  37.347  1.00 15.41           C  
ATOM   6184  CD1 PHE F  50      12.180  71.751  37.791  1.00 16.87           C  
ATOM   6185  CD2 PHE F  50       9.984  72.401  37.083  1.00 17.35           C  
ATOM   6186  CE1 PHE F  50      12.510  73.085  37.999  1.00 19.06           C  
ATOM   6187  CE2 PHE F  50      10.310  73.745  37.276  1.00 18.75           C  
ATOM   6188  CZ  PHE F  50      11.575  74.079  37.734  1.00 19.17           C  
ATOM   6189  N   CYS F  51       7.718  69.630  38.302  1.00 12.68           N  
ATOM   6190  CA  CYS F  51       6.452  70.192  38.784  1.00 12.96           C  
ATOM   6191  C   CYS F  51       5.920  69.486  40.026  1.00 12.50           C  
ATOM   6192  O   CYS F  51       5.406  70.141  40.925  1.00 12.77           O  
ATOM   6193  CB  CYS F  51       5.412  70.220  37.666  1.00 13.55           C  
ATOM   6194  SG  CYS F  51       5.918  71.366  36.329  1.00 17.80           S  
ATOM   6195  N   VAL F  52       6.022  68.157  40.080  1.00 12.25           N  
ATOM   6196  CA  VAL F  52       5.603  67.451  41.289  1.00 12.28           C  
ATOM   6197  C   VAL F  52       6.353  67.998  42.506  1.00 12.60           C  
ATOM   6198  O   VAL F  52       5.740  68.308  43.536  1.00 13.49           O  
ATOM   6199  CB  VAL F  52       5.765  65.918  41.166  1.00 12.27           C  
ATOM   6200  CG1 VAL F  52       5.564  65.226  42.529  1.00 11.37           C  
ATOM   6201  CG2 VAL F  52       4.769  65.388  40.167  1.00 12.67           C  
ATOM   6202  N   ASP F  53       7.668  68.151  42.386  1.00 12.61           N  
ATOM   6203  CA  ASP F  53       8.441  68.638  43.524  1.00 13.38           C  
ATOM   6204  C   ASP F  53       7.915  69.993  43.971  1.00 13.37           C  
ATOM   6205  O   ASP F  53       7.704  70.219  45.162  1.00 13.09           O  
ATOM   6206  CB  ASP F  53       9.914  68.765  43.153  1.00 13.48           C  
ATOM   6207  CG  ASP F  53      10.773  69.140  44.342  1.00 14.64           C  
ATOM   6208  OD1 ASP F  53      10.810  68.367  45.326  1.00 16.00           O  
ATOM   6209  OD2 ASP F  53      11.394  70.229  44.288  1.00 16.96           O  
ATOM   6210  N   MET F  54       7.705  70.876  42.999  1.00 13.89           N  
ATOM   6211  CA  MET F  54       7.239  72.247  43.259  1.00 15.11           C  
ATOM   6212  C   MET F  54       5.861  72.221  43.915  1.00 14.19           C  
ATOM   6213  O   MET F  54       5.624  72.901  44.923  1.00 14.84           O  
ATOM   6214  CB  MET F  54       7.197  73.033  41.945  1.00 15.68           C  
ATOM   6215  CG  MET F  54       6.538  74.414  42.014  1.00 17.03           C  
ATOM   6216  SD  MET F  54       6.672  75.351  40.441  1.00 18.75           S  
ATOM   6217  CE  MET F  54       6.577  74.068  39.216  1.00 24.38           C  
ATOM   6218  N   HIS F  55       4.956  71.415  43.374  1.00 13.62           N  
ATOM   6219  CA  HIS F  55       3.573  71.441  43.836  1.00 13.38           C  
ATOM   6220  C   HIS F  55       3.332  70.701  45.148  1.00 13.38           C  
ATOM   6221  O   HIS F  55       2.435  71.057  45.891  1.00 14.07           O  
ATOM   6222  CB  HIS F  55       2.624  71.036  42.704  1.00 13.91           C  
ATOM   6223  CG  HIS F  55       2.726  71.954  41.530  1.00 15.95           C  
ATOM   6224  ND1 HIS F  55       2.716  73.324  41.676  1.00 19.94           N  
ATOM   6225  CD2 HIS F  55       2.906  71.716  40.208  1.00 18.12           C  
ATOM   6226  CE1 HIS F  55       2.865  73.891  40.491  1.00 20.86           C  
ATOM   6227  NE2 HIS F  55       2.970  72.938  39.584  1.00 20.13           N  
ATOM   6228  N   VAL F  56       4.170  69.718  45.453  1.00 13.04           N  
ATOM   6229  CA  VAL F  56       4.178  69.098  46.776  1.00 13.17           C  
ATOM   6230  C   VAL F  56       4.549  70.167  47.808  1.00 13.31           C  
ATOM   6231  O   VAL F  56       3.886  70.320  48.835  1.00 13.88           O  
ATOM   6232  CB  VAL F  56       5.201  67.946  46.828  1.00 13.07           C  
ATOM   6233  CG1 VAL F  56       5.545  67.570  48.270  1.00 13.61           C  
ATOM   6234  CG2 VAL F  56       4.683  66.725  46.039  1.00 13.19           C  
ATOM   6235  N   LYS F  57       5.605  70.921  47.504  1.00 13.93           N  
ATOM   6236  CA  LYS F  57       6.084  71.969  48.399  1.00 14.17           C  
ATOM   6237  C   LYS F  57       5.034  73.061  48.617  1.00 14.28           C  
ATOM   6238  O   LYS F  57       4.836  73.508  49.749  1.00 14.33           O  
ATOM   6239  CB  LYS F  57       7.404  72.541  47.875  1.00 14.35           C  
ATOM   6240  CG  LYS F  57       8.595  71.602  48.140  1.00 15.59           C  
ATOM   6241  CD  LYS F  57       9.815  71.966  47.318  1.00 18.92           C  
ATOM   6242  CE  LYS F  57      11.000  71.058  47.639  1.00 19.32           C  
ATOM   6243  NZ  LYS F  57      12.154  71.365  46.735  1.00 20.08           N  
ATOM   6244  N   GLU F  58       4.341  73.460  47.548  1.00 13.86           N  
ATOM   6245  CA  GLU F  58       3.321  74.522  47.657  1.00 14.54           C  
ATOM   6246  C   GLU F  58       2.120  74.007  48.448  1.00 14.15           C  
ATOM   6247  O   GLU F  58       1.541  74.737  49.267  1.00 13.97           O  
ATOM   6248  CB  GLU F  58       2.864  74.992  46.280  1.00 15.13           C  
ATOM   6249  CG  GLU F  58       3.919  75.719  45.489  1.00 18.78           C  
ATOM   6250  CD  GLU F  58       3.511  75.896  44.045  1.00 24.94           C  
ATOM   6251  OE1 GLU F  58       2.845  74.982  43.506  1.00 28.41           O  
ATOM   6252  OE2 GLU F  58       3.853  76.938  43.446  1.00 28.22           O  
ATOM   6253  N   SER F  59       1.742  72.752  48.200  1.00 13.37           N  
ATOM   6254  CA  SER F  59       0.631  72.124  48.915  1.00 12.80           C  
ATOM   6255  C   SER F  59       0.928  72.089  50.414  1.00 13.04           C  
ATOM   6256  O   SER F  59       0.067  72.418  51.213  1.00 13.54           O  
ATOM   6257  CB  SER F  59       0.385  70.712  48.397  1.00 12.86           C  
ATOM   6258  OG  SER F  59      -0.085  70.791  47.053  1.00 12.56           O  
ATOM   6259  N   ARG F  60       2.156  71.701  50.762  1.00 13.50           N  
ATOM   6260  CA  ARG F  60       2.580  71.645  52.157  1.00 14.64           C  
ATOM   6261  C   ARG F  60       2.550  73.032  52.798  1.00 14.44           C  
ATOM   6262  O   ARG F  60       2.079  73.192  53.936  1.00 14.70           O  
ATOM   6263  CB  ARG F  60       3.984  71.038  52.268  1.00 15.08           C  
ATOM   6264  CG  ARG F  60       4.482  70.884  53.713  1.00 16.40           C  
ATOM   6265  CD  ARG F  60       5.840  70.189  53.764  1.00 16.55           C  
ATOM   6266  NE  ARG F  60       5.712  68.831  53.228  1.00 18.22           N  
ATOM   6267  CZ  ARG F  60       6.397  68.348  52.190  1.00 19.23           C  
ATOM   6268  NH1 ARG F  60       7.313  69.088  51.576  1.00 20.00           N  
ATOM   6269  NH2 ARG F  60       6.171  67.108  51.780  1.00 18.99           N  
ATOM   6270  N   HIS F  61       3.035  74.025  52.061  1.00 14.64           N  
ATOM   6271  CA  HIS F  61       3.025  75.408  52.567  1.00 14.76           C  
ATOM   6272  C   HIS F  61       1.602  75.846  52.905  1.00 14.92           C  
ATOM   6273  O   HIS F  61       1.381  76.531  53.915  1.00 14.55           O  
ATOM   6274  CB  HIS F  61       3.641  76.369  51.551  1.00 15.81           C  
ATOM   6275  CG  HIS F  61       3.597  77.801  51.983  1.00 16.67           C  
ATOM   6276  ND1 HIS F  61       4.365  78.294  53.018  1.00 18.32           N  
ATOM   6277  CD2 HIS F  61       2.869  78.847  51.525  1.00 18.07           C  
ATOM   6278  CE1 HIS F  61       4.122  79.583  53.168  1.00 17.39           C  
ATOM   6279  NE2 HIS F  61       3.220  79.947  52.274  1.00 17.94           N  
ATOM   6280  N   ASP F  62       0.637  75.441  52.073  1.00 15.02           N  
ATOM   6281  CA  ASP F  62      -0.763  75.811  52.275  1.00 15.44           C  
ATOM   6282  C   ASP F  62      -1.524  74.879  53.215  1.00 15.64           C  
ATOM   6283  O   ASP F  62      -2.746  74.970  53.339  1.00 15.92           O  
ATOM   6284  CB  ASP F  62      -1.497  75.980  50.929  1.00 15.78           C  
ATOM   6285  CG  ASP F  62      -1.330  77.384  50.340  1.00 18.35           C  
ATOM   6286  OD1 ASP F  62      -0.939  78.316  51.083  1.00 20.02           O  
ATOM   6287  OD2 ASP F  62      -1.599  77.567  49.129  1.00 18.99           O  
ATOM   6288  N   GLY F  63      -0.800  74.003  53.909  1.00 16.02           N  
ATOM   6289  CA  GLY F  63      -1.406  73.234  54.994  1.00 16.36           C  
ATOM   6290  C   GLY F  63      -2.071  71.920  54.640  1.00 16.90           C  
ATOM   6291  O   GLY F  63      -2.685  71.277  55.497  1.00 17.29           O  
ATOM   6292  N   LEU F  64      -1.937  71.493  53.389  1.00 15.99           N  
ATOM   6293  CA  LEU F  64      -2.478  70.191  52.989  1.00 16.81           C  
ATOM   6294  C   LEU F  64      -1.695  69.072  53.678  1.00 16.17           C  
ATOM   6295  O   LEU F  64      -0.472  69.182  53.862  1.00 15.95           O  
ATOM   6296  CB  LEU F  64      -2.492  70.062  51.456  1.00 16.68           C  
ATOM   6297  CG  LEU F  64      -3.564  71.026  50.919  1.00 18.97           C  
ATOM   6298  CD1 LEU F  64      -3.253  71.678  49.578  1.00 23.45           C  
ATOM   6299  CD2 LEU F  64      -4.935  70.361  50.921  1.00 20.31           C  
ATOM   6300  N   SER F  65      -2.401  68.022  54.097  1.00 16.28           N  
ATOM   6301  CA  SER F  65      -1.776  66.956  54.896  1.00 16.64           C  
ATOM   6302  C   SER F  65      -0.826  66.150  54.029  1.00 16.92           C  
ATOM   6303  O   SER F  65      -0.979  66.120  52.787  1.00 16.65           O  
ATOM   6304  CB  SER F  65      -2.837  66.028  55.498  1.00 16.75           C  
ATOM   6305  OG  SER F  65      -3.445  65.220  54.499  1.00 17.46           O  
ATOM   6306  N   GLU F  66       0.130  65.475  54.665  1.00 17.15           N  
ATOM   6307  CA  GLU F  66       1.048  64.620  53.918  1.00 17.26           C  
ATOM   6308  C   GLU F  66       0.275  63.497  53.231  1.00 16.65           C  
ATOM   6309  O   GLU F  66       0.612  63.123  52.119  1.00 16.45           O  
ATOM   6310  CB  GLU F  66       2.188  64.066  54.789  1.00 18.22           C  
ATOM   6311  CG  GLU F  66       3.100  65.140  55.444  1.00 20.62           C  
ATOM   6312  CD  GLU F  66       3.786  66.093  54.450  1.00 24.03           C  
ATOM   6313  OE1 GLU F  66       4.042  65.710  53.292  1.00 23.98           O  
ATOM   6314  OE2 GLU F  66       4.093  67.239  54.839  1.00 26.57           O  
ATOM   6315  N   GLN F  67      -0.779  62.984  53.863  1.00 16.46           N  
ATOM   6316  CA  GLN F  67      -1.569  61.923  53.228  1.00 16.37           C  
ATOM   6317  C   GLN F  67      -2.238  62.400  51.930  1.00 15.76           C  
ATOM   6318  O   GLN F  67      -2.188  61.721  50.905  1.00 16.32           O  
ATOM   6319  CB  GLN F  67      -2.622  61.412  54.190  1.00 17.30           C  
ATOM   6320  CG  GLN F  67      -2.798  59.959  54.127  1.00 19.98           C  
ATOM   6321  CD  GLN F  67      -3.806  59.477  55.122  1.00 21.56           C  
ATOM   6322  OE1 GLN F  67      -4.659  60.252  55.593  1.00 23.88           O  
ATOM   6323  NE2 GLN F  67      -3.725  58.196  55.462  1.00 19.72           N  
ATOM   6324  N   TRP F  68      -2.852  63.582  51.975  1.00 14.81           N  
ATOM   6325  CA  TRP F  68      -3.502  64.175  50.803  1.00 14.64           C  
ATOM   6326  C   TRP F  68      -2.499  64.334  49.658  1.00 14.30           C  
ATOM   6327  O   TRP F  68      -2.808  64.084  48.492  1.00 15.07           O  
ATOM   6328  CB  TRP F  68      -4.047  65.540  51.205  1.00 14.15           C  
ATOM   6329  CG  TRP F  68      -4.901  66.284  50.223  1.00 14.11           C  
ATOM   6330  CD1 TRP F  68      -6.275  66.312  50.182  1.00 14.62           C  
ATOM   6331  CD2 TRP F  68      -4.449  67.183  49.201  1.00 13.83           C  
ATOM   6332  NE1 TRP F  68      -6.698  67.150  49.172  1.00 15.92           N  
ATOM   6333  CE2 TRP F  68      -5.599  67.703  48.561  1.00 12.73           C  
ATOM   6334  CE3 TRP F  68      -3.180  67.598  48.762  1.00 14.63           C  
ATOM   6335  CZ2 TRP F  68      -5.520  68.616  47.508  1.00 12.31           C  
ATOM   6336  CZ3 TRP F  68      -3.099  68.515  47.704  1.00 14.30           C  
ATOM   6337  CH2 TRP F  68      -4.267  69.005  47.087  1.00 13.57           C  
ATOM   6338  N   ILE F  69      -1.289  64.759  50.001  1.00 14.24           N  
ATOM   6339  CA  ILE F  69      -0.218  64.891  49.019  1.00 14.14           C  
ATOM   6340  C   ILE F  69       0.261  63.527  48.488  1.00 14.20           C  
ATOM   6341  O   ILE F  69       0.328  63.311  47.276  1.00 14.37           O  
ATOM   6342  CB  ILE F  69       0.962  65.700  49.618  1.00 13.91           C  
ATOM   6343  CG1 ILE F  69       0.482  67.105  49.972  1.00 14.51           C  
ATOM   6344  CG2 ILE F  69       2.150  65.751  48.641  1.00 15.17           C  
ATOM   6345  CD1 ILE F  69       1.455  67.908  50.843  1.00 15.13           C  
ATOM   6346  N   ASN F  70       0.579  62.626  49.412  1.00 14.19           N  
ATOM   6347  CA  ASN F  70       1.228  61.361  49.076  1.00 15.34           C  
ATOM   6348  C   ASN F  70       0.322  60.425  48.271  1.00 14.84           C  
ATOM   6349  O   ASN F  70       0.807  59.616  47.466  1.00 15.91           O  
ATOM   6350  CB  ASN F  70       1.671  60.624  50.360  1.00 15.56           C  
ATOM   6351  CG  ASN F  70       2.672  61.424  51.222  1.00 18.01           C  
ATOM   6352  OD1 ASN F  70       3.461  62.226  50.729  1.00 22.58           O  
ATOM   6353  ND2 ASN F  70       2.645  61.165  52.518  1.00 19.52           N  
ATOM   6354  N   LEU F  71      -0.985  60.505  48.506  1.00 14.02           N  
ATOM   6355  CA  LEU F  71      -1.934  59.558  47.891  1.00 14.23           C  
ATOM   6356  C   LEU F  71      -2.454  60.033  46.539  1.00 13.32           C  
ATOM   6357  O   LEU F  71      -3.265  59.373  45.870  1.00 13.65           O  
ATOM   6358  CB  LEU F  71      -3.087  59.235  48.852  1.00 14.59           C  
ATOM   6359  CG  LEU F  71      -2.815  58.169  49.925  1.00 15.00           C  
ATOM   6360  CD1 LEU F  71      -2.775  56.763  49.293  1.00 16.38           C  
ATOM   6361  CD2 LEU F  71      -1.548  58.440  50.728  1.00 17.18           C  
ATOM   6362  N   MET F  72      -1.964  61.188  46.107  1.00 12.97           N  
ATOM   6363  CA  MET F  72      -2.508  61.793  44.896  1.00 13.04           C  
ATOM   6364  C   MET F  72      -2.217  60.947  43.666  1.00 12.94           C  
ATOM   6365  O   MET F  72      -2.975  60.961  42.711  1.00 13.79           O  
ATOM   6366  CB  MET F  72      -1.983  63.206  44.716  1.00 13.48           C  
ATOM   6367  CG  MET F  72      -2.787  64.002  43.723  1.00 13.49           C  
ATOM   6368  SD  MET F  72      -4.470  64.451  44.298  1.00 13.80           S  
ATOM   6369  CE  MET F  72      -4.170  65.632  45.650  1.00 15.25           C  
ATOM   6370  N   SER F  73      -1.108  60.210  43.700  1.00 12.54           N  
ATOM   6371  CA  SER F  73      -0.748  59.334  42.590  1.00 11.99           C  
ATOM   6372  C   SER F  73      -1.711  58.143  42.431  1.00 12.39           C  
ATOM   6373  O   SER F  73      -1.760  57.529  41.360  1.00 12.81           O  
ATOM   6374  CB  SER F  73       0.668  58.813  42.801  1.00 12.15           C  
ATOM   6375  OG  SER F  73       0.728  58.026  43.982  1.00 12.08           O  
ATOM   6376  N   VAL F  74      -2.481  57.840  43.485  1.00 11.74           N  
ATOM   6377  CA  VAL F  74      -3.342  56.648  43.533  1.00 12.08           C  
ATOM   6378  C   VAL F  74      -4.727  56.985  44.120  1.00 12.29           C  
ATOM   6379  O   VAL F  74      -5.358  56.173  44.814  1.00 12.48           O  
ATOM   6380  CB  VAL F  74      -2.647  55.492  44.313  1.00 12.10           C  
ATOM   6381  CG1 VAL F  74      -1.455  54.970  43.523  1.00 12.76           C  
ATOM   6382  CG2 VAL F  74      -2.206  55.962  45.704  1.00 12.07           C  
ATOM   6383  N   TRP F  75      -5.210  58.183  43.796  1.00 12.53           N  
ATOM   6384  CA  TRP F  75      -6.405  58.731  44.441  1.00 12.52           C  
ATOM   6385  C   TRP F  75      -7.671  57.890  44.310  1.00 13.09           C  
ATOM   6386  O   TRP F  75      -8.518  57.952  45.192  1.00 13.52           O  
ATOM   6387  CB  TRP F  75      -6.701  60.139  43.912  1.00 12.70           C  
ATOM   6388  CG  TRP F  75      -7.204  60.137  42.481  1.00 11.99           C  
ATOM   6389  CD1 TRP F  75      -6.448  60.235  41.348  1.00 13.50           C  
ATOM   6390  CD2 TRP F  75      -8.574  60.045  42.042  1.00 12.53           C  
ATOM   6391  NE1 TRP F  75      -7.258  60.211  40.224  1.00 12.68           N  
ATOM   6392  CE2 TRP F  75      -8.563  60.082  40.626  1.00 11.72           C  
ATOM   6393  CE3 TRP F  75      -9.803  59.946  42.707  1.00 12.09           C  
ATOM   6394  CZ2 TRP F  75      -9.740  60.023  39.864  1.00 13.12           C  
ATOM   6395  CZ3 TRP F  75     -10.975  59.859  41.945  1.00 12.85           C  
ATOM   6396  CH2 TRP F  75     -10.930  59.909  40.541  1.00 12.62           C  
ATOM   6397  N   ARG F  76      -7.814  57.127  43.217  1.00 14.12           N  
ATOM   6398  CA  ARG F  76      -9.073  56.391  42.987  1.00 15.21           C  
ATOM   6399  C   ARG F  76      -9.405  55.448  44.126  1.00 15.42           C  
ATOM   6400  O   ARG F  76     -10.581  55.265  44.469  1.00 16.16           O  
ATOM   6401  CB  ARG F  76      -9.045  55.616  41.673  1.00 16.16           C  
ATOM   6402  CG  ARG F  76      -9.187  56.479  40.470  1.00 20.06           C  
ATOM   6403  CD  ARG F  76      -9.802  55.720  39.295  1.00 25.38           C  
ATOM   6404  NE  ARG F  76      -9.967  56.625  38.164  1.00 28.81           N  
ATOM   6405  CZ  ARG F  76     -11.091  57.278  37.881  1.00 28.66           C  
ATOM   6406  NH1 ARG F  76     -12.176  57.111  38.629  1.00 30.62           N  
ATOM   6407  NH2 ARG F  76     -11.133  58.089  36.835  1.00 31.57           N  
ATOM   6408  N   GLU F  77      -8.368  54.868  44.722  1.00 15.43           N  
ATOM   6409  CA  GLU F  77      -8.556  53.883  45.770  1.00 15.93           C  
ATOM   6410  C   GLU F  77      -8.368  54.436  47.175  1.00 15.93           C  
ATOM   6411  O   GLU F  77      -8.388  53.674  48.148  1.00 16.54           O  
ATOM   6412  CB  GLU F  77      -7.646  52.665  45.524  1.00 16.05           C  
ATOM   6413  CG  GLU F  77      -8.159  51.756  44.418  1.00 18.91           C  
ATOM   6414  CD  GLU F  77      -9.603  51.300  44.664  1.00 22.61           C  
ATOM   6415  OE1 GLU F  77      -9.973  51.012  45.834  1.00 25.01           O  
ATOM   6416  OE2 GLU F  77     -10.378  51.245  43.693  1.00 26.00           O  
ATOM   6417  N   SER F  78      -8.221  55.753  47.299  1.00 15.30           N  
ATOM   6418  CA  SER F  78      -7.957  56.356  48.608  1.00 15.79           C  
ATOM   6419  C   SER F  78      -9.180  57.063  49.187  1.00 16.36           C  
ATOM   6420  O   SER F  78      -9.773  57.915  48.517  1.00 16.21           O  
ATOM   6421  CB  SER F  78      -6.804  57.347  48.518  1.00 15.59           C  
ATOM   6422  OG  SER F  78      -6.673  58.050  49.738  1.00 16.38           O  
ATOM   6423  N   PRO F  79      -9.565  56.706  50.429  1.00 16.90           N  
ATOM   6424  CA  PRO F  79     -10.644  57.431  51.125  1.00 17.14           C  
ATOM   6425  C   PRO F  79     -10.290  58.846  51.612  1.00 17.64           C  
ATOM   6426  O   PRO F  79     -11.145  59.507  52.223  1.00 17.77           O  
ATOM   6427  CB  PRO F  79     -10.962  56.533  52.333  1.00 17.47           C  
ATOM   6428  CG  PRO F  79      -9.722  55.706  52.550  1.00 16.99           C  
ATOM   6429  CD  PRO F  79      -9.056  55.557  51.209  1.00 17.53           C  
ATOM   6430  N   VAL F  80      -9.068  59.313  51.359  1.00 17.63           N  
ATOM   6431  CA  VAL F  80      -8.683  60.664  51.806  1.00 18.08           C  
ATOM   6432  C   VAL F  80      -9.524  61.779  51.160  1.00 17.46           C  
ATOM   6433  O   VAL F  80      -9.856  62.769  51.821  1.00 17.83           O  
ATOM   6434  CB  VAL F  80      -7.163  60.932  51.608  1.00 18.67           C  
ATOM   6435  CG1 VAL F  80      -6.820  62.380  51.970  1.00 20.68           C  
ATOM   6436  CG2 VAL F  80      -6.364  59.997  52.476  1.00 20.44           C  
ATOM   6437  N   TYR F  81      -9.891  61.609  49.889  1.00 16.16           N  
ATOM   6438  CA  TYR F  81     -10.468  62.703  49.097  1.00 16.17           C  
ATOM   6439  C   TYR F  81     -11.971  62.797  49.259  1.00 16.14           C  
ATOM   6440  O   TYR F  81     -12.660  61.783  49.326  1.00 17.78           O  
ATOM   6441  CB  TYR F  81     -10.062  62.561  47.628  1.00 15.76           C  
ATOM   6442  CG  TYR F  81      -8.572  62.482  47.557  1.00 13.82           C  
ATOM   6443  CD1 TYR F  81      -7.785  63.605  47.834  1.00 13.29           C  
ATOM   6444  CD2 TYR F  81      -7.934  61.270  47.311  1.00 13.21           C  
ATOM   6445  CE1 TYR F  81      -6.388  63.532  47.826  1.00 13.59           C  
ATOM   6446  CE2 TYR F  81      -6.541  61.180  47.317  1.00 13.38           C  
ATOM   6447  CZ  TYR F  81      -5.775  62.309  47.570  1.00 14.10           C  
ATOM   6448  OH  TYR F  81      -4.404  62.205  47.574  1.00 14.92           O  
ATOM   6449  N   THR F  82     -12.460  64.026  49.350  1.00 16.85           N  
ATOM   6450  CA  THR F  82     -13.897  64.275  49.453  1.00 17.00           C  
ATOM   6451  C   THR F  82     -14.582  63.956  48.130  1.00 17.41           C  
ATOM   6452  O   THR F  82     -13.920  63.862  47.099  1.00 16.61           O  
ATOM   6453  CB  THR F  82     -14.180  65.745  49.785  1.00 17.15           C  
ATOM   6454  OG1 THR F  82     -13.819  66.574  48.665  1.00 17.13           O  
ATOM   6455  CG2 THR F  82     -13.399  66.190  51.018  1.00 17.65           C  
ATOM   6456  N   GLU F  83     -15.907  63.817  48.142  1.00 17.92           N  
ATOM   6457  CA  GLU F  83     -16.629  63.573  46.885  1.00 18.46           C  
ATOM   6458  C   GLU F  83     -16.385  64.683  45.858  1.00 17.47           C  
ATOM   6459  O   GLU F  83     -16.261  64.419  44.658  1.00 17.38           O  
ATOM   6460  CB  GLU F  83     -18.131  63.363  47.120  1.00 19.70           C  
ATOM   6461  CG  GLU F  83     -18.469  62.041  47.817  1.00 23.79           C  
ATOM   6462  CD  GLU F  83     -17.692  60.839  47.264  1.00 28.72           C  
ATOM   6463  OE1 GLU F  83     -17.849  60.515  46.062  1.00 32.14           O  
ATOM   6464  OE2 GLU F  83     -16.927  60.209  48.039  1.00 32.41           O  
ATOM   6465  N   GLN F  84     -16.313  65.925  46.329  1.00 17.07           N  
ATOM   6466  CA  GLN F  84     -16.017  67.052  45.460  1.00 16.57           C  
ATOM   6467  C   GLN F  84     -14.622  66.903  44.850  1.00 16.18           C  
ATOM   6468  O   GLN F  84     -14.440  67.080  43.646  1.00 16.19           O  
ATOM   6469  CB  GLN F  84     -16.084  68.349  46.254  1.00 17.31           C  
ATOM   6470  CG  GLN F  84     -15.825  69.575  45.419  1.00 17.35           C  
ATOM   6471  CD  GLN F  84     -16.025  70.858  46.206  1.00 20.54           C  
ATOM   6472  OE1 GLN F  84     -15.717  70.930  47.401  1.00 21.44           O  
ATOM   6473  NE2 GLN F  84     -16.536  71.881  45.532  1.00 22.17           N  
ATOM   6474  N   GLU F  85     -13.650  66.572  45.688  1.00 15.47           N  
ATOM   6475  CA  GLU F  85     -12.286  66.348  45.201  1.00 15.06           C  
ATOM   6476  C   GLU F  85     -12.230  65.218  44.179  1.00 14.57           C  
ATOM   6477  O   GLU F  85     -11.515  65.326  43.173  1.00 14.23           O  
ATOM   6478  CB  GLU F  85     -11.323  66.070  46.358  1.00 15.07           C  
ATOM   6479  CG  GLU F  85     -11.029  67.334  47.173  1.00 15.25           C  
ATOM   6480  CD  GLU F  85     -10.215  67.075  48.427  1.00 16.40           C  
ATOM   6481  OE1 GLU F  85     -10.348  65.988  49.014  1.00 16.25           O  
ATOM   6482  OE2 GLU F  85      -9.442  67.977  48.834  1.00 20.07           O  
ATOM   6483  N   ARG F  86     -12.976  64.143  44.435  1.00 14.39           N  
ATOM   6484  CA  ARG F  86     -13.001  63.001  43.513  1.00 14.77           C  
ATOM   6485  C   ARG F  86     -13.586  63.402  42.160  1.00 15.10           C  
ATOM   6486  O   ARG F  86     -13.125  62.940  41.120  1.00 15.45           O  
ATOM   6487  CB  ARG F  86     -13.772  61.824  44.116  1.00 14.79           C  
ATOM   6488  CG  ARG F  86     -13.116  61.242  45.352  1.00 14.62           C  
ATOM   6489  CD  ARG F  86     -13.829  59.968  45.855  1.00 15.87           C  
ATOM   6490  NE  ARG F  86     -13.682  58.852  44.920  1.00 17.09           N  
ATOM   6491  CZ  ARG F  86     -12.631  58.036  44.877  1.00 16.78           C  
ATOM   6492  NH1 ARG F  86     -11.608  58.189  45.728  1.00 16.33           N  
ATOM   6493  NH2 ARG F  86     -12.611  57.065  43.963  1.00 18.83           N  
ATOM   6494  N   ALA F  87     -14.615  64.251  42.179  1.00 14.69           N  
ATOM   6495  CA  ALA F  87     -15.207  64.767  40.941  1.00 15.00           C  
ATOM   6496  C   ALA F  87     -14.176  65.559  40.145  1.00 14.58           C  
ATOM   6497  O   ALA F  87     -14.028  65.387  38.919  1.00 14.92           O  
ATOM   6498  CB  ALA F  87     -16.426  65.633  41.267  1.00 15.06           C  
ATOM   6499  N   LEU F  88     -13.459  66.425  40.852  1.00 14.19           N  
ATOM   6500  CA  LEU F  88     -12.418  67.223  40.239  1.00 13.65           C  
ATOM   6501  C   LEU F  88     -11.305  66.307  39.695  1.00 13.27           C  
ATOM   6502  O   LEU F  88     -10.849  66.472  38.550  1.00 13.12           O  
ATOM   6503  CB  LEU F  88     -11.869  68.234  41.256  1.00 13.53           C  
ATOM   6504  CG  LEU F  88     -10.721  69.115  40.773  1.00 13.30           C  
ATOM   6505  CD1 LEU F  88     -11.046  69.817  39.462  1.00 14.67           C  
ATOM   6506  CD2 LEU F  88     -10.344  70.130  41.832  1.00 14.70           C  
ATOM   6507  N   LEU F  89     -10.887  65.332  40.497  1.00 12.72           N  
ATOM   6508  CA  LEU F  89      -9.805  64.409  40.079  1.00 13.26           C  
ATOM   6509  C   LEU F  89     -10.175  63.617  38.819  1.00 13.33           C  
ATOM   6510  O   LEU F  89      -9.354  63.454  37.903  1.00 12.89           O  
ATOM   6511  CB  LEU F  89      -9.421  63.476  41.226  1.00 13.30           C  
ATOM   6512  CG  LEU F  89      -8.543  64.148  42.300  1.00 13.19           C  
ATOM   6513  CD1 LEU F  89      -8.627  63.437  43.654  1.00 14.58           C  
ATOM   6514  CD2 LEU F  89      -7.081  64.269  41.841  1.00 15.61           C  
ATOM   6515  N   GLY F  90     -11.421  63.156  38.751  1.00 13.13           N  
ATOM   6516  CA  GLY F  90     -11.898  62.441  37.563  1.00 13.48           C  
ATOM   6517  C   GLY F  90     -11.738  63.288  36.316  1.00 12.50           C  
ATOM   6518  O   GLY F  90     -11.360  62.785  35.260  1.00 13.41           O  
ATOM   6519  N   TRP F  91     -12.010  64.592  36.445  1.00 12.26           N  
ATOM   6520  CA  TRP F  91     -11.898  65.536  35.334  1.00 12.53           C  
ATOM   6521  C   TRP F  91     -10.442  65.870  35.001  1.00 11.88           C  
ATOM   6522  O   TRP F  91     -10.064  65.922  33.835  1.00 11.91           O  
ATOM   6523  CB  TRP F  91     -12.687  66.804  35.657  1.00 13.54           C  
ATOM   6524  CG  TRP F  91     -12.856  67.757  34.524  1.00 13.61           C  
ATOM   6525  CD1 TRP F  91     -12.358  69.039  34.433  1.00 13.78           C  
ATOM   6526  CD2 TRP F  91     -13.608  67.539  33.317  1.00 14.13           C  
ATOM   6527  NE1 TRP F  91     -12.754  69.619  33.247  1.00 13.46           N  
ATOM   6528  CE2 TRP F  91     -13.520  68.724  32.545  1.00 14.53           C  
ATOM   6529  CE3 TRP F  91     -14.344  66.452  32.809  1.00 14.34           C  
ATOM   6530  CZ2 TRP F  91     -14.140  68.851  31.296  1.00 13.96           C  
ATOM   6531  CZ3 TRP F  91     -14.957  66.582  31.570  1.00 13.47           C  
ATOM   6532  CH2 TRP F  91     -14.858  67.771  30.831  1.00 13.94           C  
ATOM   6533  N   VAL F  92      -9.625  66.105  36.025  1.00 11.60           N  
ATOM   6534  CA  VAL F  92      -8.186  66.314  35.797  1.00 11.37           C  
ATOM   6535  C   VAL F  92      -7.607  65.143  35.010  1.00 11.68           C  
ATOM   6536  O   VAL F  92      -6.870  65.343  34.038  1.00 11.67           O  
ATOM   6537  CB  VAL F  92      -7.398  66.511  37.119  1.00 11.11           C  
ATOM   6538  CG1 VAL F  92      -5.906  66.577  36.848  1.00 11.41           C  
ATOM   6539  CG2 VAL F  92      -7.833  67.794  37.822  1.00 13.32           C  
ATOM   6540  N   ASP F  93      -7.939  63.921  35.436  1.00 11.83           N  
ATOM   6541  CA  ASP F  93      -7.456  62.734  34.745  1.00 12.10           C  
ATOM   6542  C   ASP F  93      -7.930  62.646  33.294  1.00 12.22           C  
ATOM   6543  O   ASP F  93      -7.119  62.421  32.394  1.00 12.55           O  
ATOM   6544  CB  ASP F  93      -7.856  61.474  35.505  1.00 12.31           C  
ATOM   6545  CG  ASP F  93      -7.054  61.278  36.794  1.00 14.30           C  
ATOM   6546  OD1 ASP F  93      -6.370  62.217  37.253  1.00 14.29           O  
ATOM   6547  OD2 ASP F  93      -7.110  60.159  37.355  1.00 15.93           O  
ATOM   6548  N   ALA F  94      -9.231  62.821  33.073  1.00 12.23           N  
ATOM   6549  CA  ALA F  94      -9.813  62.701  31.734  1.00 12.54           C  
ATOM   6550  C   ALA F  94      -9.241  63.754  30.782  1.00 12.51           C  
ATOM   6551  O   ALA F  94      -8.896  63.451  29.630  1.00 13.65           O  
ATOM   6552  CB  ALA F  94     -11.324  62.835  31.813  1.00 13.74           C  
ATOM   6553  N   VAL F  95      -9.111  64.975  31.290  1.00 11.96           N  
ATOM   6554  CA  VAL F  95      -8.691  66.093  30.466  1.00 11.73           C  
ATOM   6555  C   VAL F  95      -7.172  66.065  30.233  1.00 12.02           C  
ATOM   6556  O   VAL F  95      -6.711  66.359  29.133  1.00 12.09           O  
ATOM   6557  CB  VAL F  95      -9.165  67.425  31.048  1.00 11.95           C  
ATOM   6558  CG1 VAL F  95      -8.663  68.593  30.184  1.00 12.32           C  
ATOM   6559  CG2 VAL F  95     -10.697  67.443  31.141  1.00 11.20           C  
ATOM   6560  N   THR F  96      -6.391  65.681  31.245  1.00 11.51           N  
ATOM   6561  CA  THR F  96      -4.948  65.525  31.031  1.00 12.24           C  
ATOM   6562  C   THR F  96      -4.689  64.462  29.957  1.00 12.90           C  
ATOM   6563  O   THR F  96      -3.778  64.604  29.131  1.00 13.33           O  
ATOM   6564  CB  THR F  96      -4.206  65.198  32.347  1.00 12.09           C  
ATOM   6565  OG1 THR F  96      -4.351  66.306  33.239  1.00 12.30           O  
ATOM   6566  CG2 THR F  96      -2.720  64.952  32.097  1.00 12.57           C  
ATOM   6567  N   LYS F  97      -5.507  63.412  29.968  1.00 13.69           N  
ATOM   6568  CA  LYS F  97      -5.381  62.332  28.988  1.00 15.32           C  
ATOM   6569  C   LYS F  97      -6.436  62.453  27.894  1.00 14.64           C  
ATOM   6570  O   LYS F  97      -7.028  61.455  27.490  1.00 14.25           O  
ATOM   6571  CB  LYS F  97      -5.473  60.964  29.680  1.00 15.91           C  
ATOM   6572  CG  LYS F  97      -4.408  60.744  30.753  1.00 18.23           C  
ATOM   6573  CD  LYS F  97      -4.638  59.419  31.503  1.00 20.33           C  
ATOM   6574  CE  LYS F  97      -5.836  59.508  32.462  1.00 24.70           C  
ATOM   6575  NZ  LYS F  97      -6.076  58.206  33.169  1.00 30.58           N  
ATOM   6576  N   ILE F  98      -6.652  63.677  27.406  1.00 13.81           N  
ATOM   6577  CA  ILE F  98      -7.725  63.971  26.451  1.00 14.37           C  
ATOM   6578  C   ILE F  98      -7.705  63.089  25.193  1.00 14.10           C  
ATOM   6579  O   ILE F  98      -8.762  62.729  24.672  1.00 14.02           O  
ATOM   6580  CB  ILE F  98      -7.744  65.488  26.047  1.00 14.19           C  
ATOM   6581  CG1 ILE F  98      -9.095  65.875  25.435  1.00 15.69           C  
ATOM   6582  CG2 ILE F  98      -6.575  65.855  25.143  1.00 15.30           C  
ATOM   6583  CD1 ILE F  98     -10.150  66.135  26.461  1.00 14.12           C  
ATOM   6584  N   ALA F  99      -6.513  62.743  24.720  1.00 14.47           N  
ATOM   6585  CA  ALA F  99      -6.405  61.990  23.462  1.00 15.59           C  
ATOM   6586  C   ALA F  99      -6.950  60.576  23.609  1.00 16.80           C  
ATOM   6587  O   ALA F  99      -7.471  59.992  22.644  1.00 17.27           O  
ATOM   6588  CB  ALA F  99      -4.979  61.965  22.977  1.00 14.44           C  
ATOM   6589  N   GLU F 100      -6.835  60.038  24.820  1.00 17.74           N  
ATOM   6590  CA  GLU F 100      -7.248  58.676  25.098  1.00 20.19           C  
ATOM   6591  C   GLU F 100      -8.704  58.631  25.543  1.00 19.51           C  
ATOM   6592  O   GLU F 100      -9.435  57.718  25.161  1.00 20.62           O  
ATOM   6593  CB  GLU F 100      -6.335  58.056  26.158  1.00 19.99           C  
ATOM   6594  CG  GLU F 100      -6.635  56.591  26.473  1.00 24.11           C  
ATOM   6595  CD  GLU F 100      -5.612  55.945  27.407  1.00 25.42           C  
ATOM   6596  OE1 GLU F 100      -5.057  56.649  28.292  1.00 30.80           O  
ATOM   6597  OE2 GLU F 100      -5.376  54.715  27.265  1.00 31.99           O  
ATOM   6598  N   THR F 101      -9.131  59.612  26.340  1.00 18.82           N  
ATOM   6599  CA  THR F 101     -10.454  59.548  26.970  1.00 18.87           C  
ATOM   6600  C   THR F 101     -11.535  60.314  26.215  1.00 18.57           C  
ATOM   6601  O   THR F 101     -12.716  59.964  26.284  1.00 19.14           O  
ATOM   6602  CB  THR F 101     -10.437  60.098  28.415  1.00 18.80           C  
ATOM   6603  OG1 THR F 101     -10.298  61.521  28.374  1.00 20.02           O  
ATOM   6604  CG2 THR F 101      -9.303  59.493  29.245  1.00 19.46           C  
ATOM   6605  N   GLY F 102     -11.138  61.387  25.534  1.00 18.07           N  
ATOM   6606  CA  GLY F 102     -12.094  62.300  24.896  1.00 18.84           C  
ATOM   6607  C   GLY F 102     -13.041  63.053  25.829  1.00 19.44           C  
ATOM   6608  O   GLY F 102     -14.045  63.610  25.362  1.00 19.89           O  
ATOM   6609  N   ALA F 103     -12.716  63.088  27.128  1.00 18.95           N  
ATOM   6610  CA  ALA F 103     -13.536  63.777  28.172  1.00 18.12           C  
ATOM   6611  C   ALA F 103     -15.008  63.328  28.240  1.00 18.27           C  
ATOM   6612  O   ALA F 103     -15.906  64.080  27.849  1.00 18.31           O  
ATOM   6613  CB  ALA F 103     -13.447  65.323  28.041  1.00 18.13           C  
ATOM   6614  N   PRO F 104     -15.253  62.109  28.753  1.00 17.89           N  
ATOM   6615  CA  PRO F 104     -16.575  61.468  28.715  1.00 18.64           C  
ATOM   6616  C   PRO F 104     -17.675  62.196  29.476  1.00 19.03           C  
ATOM   6617  O   PRO F 104     -17.403  62.926  30.439  1.00 18.43           O  
ATOM   6618  CB  PRO F 104     -16.309  60.096  29.342  1.00 18.52           C  
ATOM   6619  CG  PRO F 104     -14.821  59.869  29.141  1.00 18.28           C  
ATOM   6620  CD  PRO F 104     -14.249  61.230  29.378  1.00 18.65           C  
ATOM   6621  N   ASP F 105     -18.921  61.970  29.041  1.00 19.42           N  
ATOM   6622  CA  ASP F 105     -20.098  62.544  29.677  1.00 20.82           C  
ATOM   6623  C   ASP F 105     -20.139  62.282  31.177  1.00 20.98           C  
ATOM   6624  O   ASP F 105     -20.467  63.185  31.944  1.00 21.39           O  
ATOM   6625  CB  ASP F 105     -21.382  61.971  29.066  1.00 21.08           C  
ATOM   6626  CG  ASP F 105     -21.631  62.436  27.641  1.00 23.74           C  
ATOM   6627  OD1 ASP F 105     -20.997  63.402  27.163  1.00 25.72           O  
ATOM   6628  OD2 ASP F 105     -22.494  61.810  26.986  1.00 27.19           O  
ATOM   6629  N   ASP F 106     -19.794  61.061  31.592  1.00 21.31           N  
ATOM   6630  CA  ASP F 106     -19.854  60.693  33.013  1.00 22.10           C  
ATOM   6631  C   ASP F 106     -18.930  61.551  33.881  1.00 21.14           C  
ATOM   6632  O   ASP F 106     -19.349  62.038  34.930  1.00 20.98           O  
ATOM   6633  CB  ASP F 106     -19.604  59.194  33.214  1.00 23.45           C  
ATOM   6634  CG  ASP F 106     -20.772  58.340  32.730  1.00 27.17           C  
ATOM   6635  OD1 ASP F 106     -21.849  58.905  32.411  1.00 32.89           O  
ATOM   6636  OD2 ASP F 106     -20.619  57.098  32.667  1.00 33.07           O  
ATOM   6637  N   ALA F 107     -17.696  61.765  33.422  1.00 19.83           N  
ATOM   6638  CA  ALA F 107     -16.745  62.620  34.138  1.00 18.97           C  
ATOM   6639  C   ALA F 107     -17.219  64.075  34.191  1.00 18.69           C  
ATOM   6640  O   ALA F 107     -17.063  64.745  35.220  1.00 18.62           O  
ATOM   6641  CB  ALA F 107     -15.368  62.536  33.497  1.00 18.50           C  
ATOM   6642  N   PHE F 108     -17.806  64.553  33.095  1.00 18.21           N  
ATOM   6643  CA  PHE F 108     -18.312  65.919  33.048  1.00 18.53           C  
ATOM   6644  C   PHE F 108     -19.521  66.109  33.969  1.00 19.18           C  
ATOM   6645  O   PHE F 108     -19.587  67.074  34.731  1.00 18.72           O  
ATOM   6646  CB  PHE F 108     -18.650  66.338  31.614  1.00 18.64           C  
ATOM   6647  CG  PHE F 108     -19.241  67.713  31.522  1.00 18.70           C  
ATOM   6648  CD1 PHE F 108     -18.437  68.841  31.662  1.00 18.09           C  
ATOM   6649  CD2 PHE F 108     -20.613  67.889  31.331  1.00 18.19           C  
ATOM   6650  CE1 PHE F 108     -18.980  70.121  31.582  1.00 18.88           C  
ATOM   6651  CE2 PHE F 108     -21.161  69.160  31.252  1.00 19.83           C  
ATOM   6652  CZ  PHE F 108     -20.347  70.275  31.390  1.00 19.71           C  
ATOM   6653  N   GLU F 109     -20.464  65.172  33.898  1.00 19.83           N  
ATOM   6654  CA  GLU F 109     -21.682  65.250  34.703  1.00 20.66           C  
ATOM   6655  C   GLU F 109     -21.350  65.191  36.197  1.00 20.24           C  
ATOM   6656  O   GLU F 109     -21.922  65.928  36.995  1.00 20.01           O  
ATOM   6657  CB  GLU F 109     -22.663  64.153  34.296  1.00 21.72           C  
ATOM   6658  CG  GLU F 109     -23.312  64.409  32.940  1.00 25.58           C  
ATOM   6659  CD  GLU F 109     -23.894  63.153  32.300  1.00 31.00           C  
ATOM   6660  OE1 GLU F 109     -23.993  62.105  32.986  1.00 34.43           O  
ATOM   6661  OE2 GLU F 109     -24.251  63.216  31.098  1.00 34.41           O  
ATOM   6662  N   THR F 110     -20.387  64.350  36.565  1.00 19.81           N  
ATOM   6663  CA  THR F 110     -19.960  64.277  37.965  1.00 19.97           C  
ATOM   6664  C   THR F 110     -19.338  65.610  38.413  1.00 19.72           C  
ATOM   6665  O   THR F 110     -19.604  66.097  39.515  1.00 19.93           O  
ATOM   6666  CB  THR F 110     -19.002  63.106  38.190  1.00 20.34           C  
ATOM   6667  OG1 THR F 110     -19.670  61.885  37.834  1.00 20.83           O  
ATOM   6668  CG2 THR F 110     -18.568  63.041  39.651  1.00 21.71           C  
ATOM   6669  N   LEU F 111     -18.531  66.209  37.545  1.00 19.21           N  
ATOM   6670  CA  LEU F 111     -17.947  67.516  37.846  1.00 18.90           C  
ATOM   6671  C   LEU F 111     -19.040  68.584  38.045  1.00 19.87           C  
ATOM   6672  O   LEU F 111     -18.984  69.367  39.003  1.00 18.85           O  
ATOM   6673  CB  LEU F 111     -16.967  67.931  36.742  1.00 18.89           C  
ATOM   6674  CG  LEU F 111     -16.123  69.176  37.029  1.00 17.10           C  
ATOM   6675  CD1 LEU F 111     -15.030  68.884  38.048  1.00 18.86           C  
ATOM   6676  CD2 LEU F 111     -15.539  69.719  35.732  1.00 19.25           C  
ATOM   6677  N   ARG F 112     -20.031  68.587  37.149  1.00 20.57           N  
ATOM   6678  CA  ARG F 112     -21.104  69.597  37.146  1.00 22.46           C  
ATOM   6679  C   ARG F 112     -21.927  69.542  38.432  1.00 22.62           C  
ATOM   6680  O   ARG F 112     -22.502  70.557  38.861  1.00 23.17           O  
ATOM   6681  CB  ARG F 112     -22.018  69.406  35.929  1.00 23.26           C  
ATOM   6682  CG  ARG F 112     -22.362  70.695  35.205  1.00 26.84           C  
ATOM   6683  CD  ARG F 112     -23.402  70.457  34.121  1.00 32.10           C  
ATOM   6684  NE  ARG F 112     -23.249  71.372  32.989  1.00 37.14           N  
ATOM   6685  CZ  ARG F 112     -23.853  72.551  32.878  1.00 39.47           C  
ATOM   6686  NH1 ARG F 112     -24.654  72.994  33.845  1.00 41.18           N  
ATOM   6687  NH2 ARG F 112     -23.649  73.298  31.799  1.00 40.43           N  
ATOM   6688  N   ALA F 113     -21.972  68.362  39.047  1.00 22.68           N  
ATOM   6689  CA  ALA F 113     -22.671  68.174  40.324  1.00 22.97           C  
ATOM   6690  C   ALA F 113     -22.034  68.936  41.483  1.00 23.14           C  
ATOM   6691  O   ALA F 113     -22.706  69.211  42.486  1.00 23.85           O  
ATOM   6692  CB  ALA F 113     -22.794  66.683  40.663  1.00 23.37           C  
ATOM   6693  N   HIS F 114     -20.748  69.278  41.345  1.00 22.48           N  
ATOM   6694  CA  HIS F 114     -19.958  69.847  42.446  1.00 22.14           C  
ATOM   6695  C   HIS F 114     -19.404  71.242  42.194  1.00 21.84           C  
ATOM   6696  O   HIS F 114     -18.930  71.894  43.129  1.00 22.43           O  
ATOM   6697  CB  HIS F 114     -18.804  68.907  42.814  1.00 21.88           C  
ATOM   6698  CG  HIS F 114     -19.260  67.604  43.378  1.00 22.31           C  
ATOM   6699  ND1 HIS F 114     -19.528  67.429  44.719  1.00 23.04           N  
ATOM   6700  CD2 HIS F 114     -19.538  66.423  42.780  1.00 22.92           C  
ATOM   6701  CE1 HIS F 114     -19.929  66.189  44.926  1.00 23.41           C  
ATOM   6702  NE2 HIS F 114     -19.951  65.559  43.766  1.00 24.52           N  
ATOM   6703  N   PHE F 115     -19.456  71.688  40.940  1.00 21.31           N  
ATOM   6704  CA  PHE F 115     -18.906  72.985  40.549  1.00 21.18           C  
ATOM   6705  C   PHE F 115     -19.824  73.721  39.583  1.00 21.51           C  
ATOM   6706  O   PHE F 115     -20.492  73.094  38.768  1.00 21.64           O  
ATOM   6707  CB  PHE F 115     -17.534  72.797  39.884  1.00 20.96           C  
ATOM   6708  CG  PHE F 115     -16.485  72.218  40.796  1.00 20.58           C  
ATOM   6709  CD1 PHE F 115     -15.726  73.048  41.619  1.00 20.52           C  
ATOM   6710  CD2 PHE F 115     -16.244  70.846  40.825  1.00 19.45           C  
ATOM   6711  CE1 PHE F 115     -14.744  72.520  42.458  1.00 20.14           C  
ATOM   6712  CE2 PHE F 115     -15.269  70.308  41.668  1.00 18.99           C  
ATOM   6713  CZ  PHE F 115     -14.521  71.154  42.487  1.00 19.98           C  
ATOM   6714  N   SER F 116     -19.823  75.052  39.659  1.00 22.10           N  
ATOM   6715  CA  SER F 116     -20.564  75.889  38.710  1.00 22.49           C  
ATOM   6716  C   SER F 116     -19.892  75.871  37.340  1.00 22.65           C  
ATOM   6717  O   SER F 116     -18.720  75.487  37.221  1.00 22.01           O  
ATOM   6718  CB  SER F 116     -20.655  77.333  39.217  1.00 22.94           C  
ATOM   6719  OG  SER F 116     -19.394  77.983  39.129  1.00 24.48           O  
ATOM   6720  N   ASP F 117     -20.618  76.294  36.307  1.00 22.78           N  
ATOM   6721  CA  ASP F 117     -20.051  76.350  34.959  1.00 23.54           C  
ATOM   6722  C   ASP F 117     -18.828  77.272  34.905  1.00 23.18           C  
ATOM   6723  O   ASP F 117     -17.853  76.972  34.219  1.00 22.37           O  
ATOM   6724  CB  ASP F 117     -21.103  76.793  33.927  1.00 24.18           C  
ATOM   6725  CG  ASP F 117     -22.041  75.666  33.521  1.00 26.72           C  
ATOM   6726  OD1 ASP F 117     -21.914  74.543  34.057  1.00 28.97           O  
ATOM   6727  OD2 ASP F 117     -22.917  75.903  32.659  1.00 30.29           O  
ATOM   6728  N   GLU F 118     -18.892  78.392  35.627  1.00 23.37           N  
ATOM   6729  CA  GLU F 118     -17.777  79.342  35.678  1.00 23.79           C  
ATOM   6730  C   GLU F 118     -16.541  78.683  36.284  1.00 22.75           C  
ATOM   6731  O   GLU F 118     -15.434  78.789  35.733  1.00 22.91           O  
ATOM   6732  CB  GLU F 118     -18.153  80.611  36.464  1.00 23.73           C  
ATOM   6733  CG  GLU F 118     -17.037  81.671  36.508  1.00 25.55           C  
ATOM   6734  CD  GLU F 118     -17.389  82.906  37.336  1.00 26.24           C  
ATOM   6735  OE1 GLU F 118     -18.452  82.923  37.996  1.00 30.60           O  
ATOM   6736  OE2 GLU F 118     -16.583  83.865  37.330  1.00 29.79           O  
ATOM   6737  N   GLU F 119     -16.749  77.998  37.407  1.00 21.98           N  
ATOM   6738  CA  GLU F 119     -15.695  77.252  38.094  1.00 21.33           C  
ATOM   6739  C   GLU F 119     -15.112  76.182  37.170  1.00 19.80           C  
ATOM   6740  O   GLU F 119     -13.890  75.960  37.139  1.00 18.97           O  
ATOM   6741  CB  GLU F 119     -16.242  76.618  39.380  1.00 21.65           C  
ATOM   6742  CG  GLU F 119     -16.470  77.623  40.529  1.00 23.00           C  
ATOM   6743  CD  GLU F 119     -17.154  77.023  41.762  1.00 23.56           C  
ATOM   6744  OE1 GLU F 119     -17.962  76.068  41.634  1.00 24.82           O  
ATOM   6745  OE2 GLU F 119     -16.895  77.527  42.883  1.00 27.46           O  
ATOM   6746  N   ILE F 120     -15.985  75.526  36.410  1.00 18.57           N  
ATOM   6747  CA  ILE F 120     -15.540  74.468  35.485  1.00 17.50           C  
ATOM   6748  C   ILE F 120     -14.628  75.013  34.383  1.00 16.94           C  
ATOM   6749  O   ILE F 120     -13.639  74.371  34.015  1.00 16.52           O  
ATOM   6750  CB  ILE F 120     -16.741  73.689  34.898  1.00 17.28           C  
ATOM   6751  CG1 ILE F 120     -17.393  72.841  35.995  1.00 17.71           C  
ATOM   6752  CG2 ILE F 120     -16.323  72.823  33.731  1.00 17.62           C  
ATOM   6753  CD1 ILE F 120     -18.745  72.222  35.598  1.00 18.65           C  
ATOM   6754  N   VAL F 121     -14.945  76.198  33.863  1.00 16.39           N  
ATOM   6755  CA  VAL F 121     -14.061  76.849  32.896  1.00 16.87           C  
ATOM   6756  C   VAL F 121     -12.711  77.184  33.535  1.00 16.20           C  
ATOM   6757  O   VAL F 121     -11.659  76.903  32.952  1.00 16.22           O  
ATOM   6758  CB  VAL F 121     -14.716  78.095  32.227  1.00 16.75           C  
ATOM   6759  CG1 VAL F 121     -13.790  78.705  31.190  1.00 18.39           C  
ATOM   6760  CG2 VAL F 121     -16.053  77.704  31.585  1.00 17.59           C  
ATOM   6761  N   LYS F 122     -12.740  77.764  34.738  1.00 16.33           N  
ATOM   6762  CA  LYS F 122     -11.494  78.056  35.473  1.00 15.95           C  
ATOM   6763  C   LYS F 122     -10.649  76.797  35.720  1.00 15.13           C  
ATOM   6764  O   LYS F 122      -9.430  76.807  35.517  1.00 14.79           O  
ATOM   6765  CB  LYS F 122     -11.793  78.757  36.798  1.00 16.15           C  
ATOM   6766  CG  LYS F 122     -12.444  80.126  36.636  1.00 18.54           C  
ATOM   6767  CD  LYS F 122     -12.820  80.692  37.997  1.00 20.67           C  
ATOM   6768  CE  LYS F 122     -13.414  82.098  37.863  1.00 23.21           C  
ATOM   6769  NZ  LYS F 122     -13.735  82.664  39.203  1.00 23.81           N  
ATOM   6770  N   ILE F 123     -11.307  75.728  36.158  1.00 14.70           N  
ATOM   6771  CA  ILE F 123     -10.657  74.425  36.386  1.00 13.82           C  
ATOM   6772  C   ILE F 123     -10.006  73.917  35.095  1.00 13.78           C  
ATOM   6773  O   ILE F 123      -8.834  73.502  35.073  1.00 13.60           O  
ATOM   6774  CB  ILE F 123     -11.699  73.395  36.903  1.00 13.82           C  
ATOM   6775  CG1 ILE F 123     -12.026  73.668  38.373  1.00 14.30           C  
ATOM   6776  CG2 ILE F 123     -11.215  71.952  36.720  1.00 13.36           C  
ATOM   6777  CD1 ILE F 123     -13.353  73.098  38.826  1.00 16.09           C  
ATOM   6778  N   THR F 124     -10.762  73.957  34.009  1.00 13.23           N  
ATOM   6779  CA  THR F 124     -10.258  73.425  32.741  1.00 13.79           C  
ATOM   6780  C   THR F 124      -9.089  74.239  32.191  1.00 13.73           C  
ATOM   6781  O   THR F 124      -8.123  73.669  31.660  1.00 14.35           O  
ATOM   6782  CB  THR F 124     -11.400  73.241  31.740  1.00 13.76           C  
ATOM   6783  OG1 THR F 124     -12.426  72.487  32.397  1.00 13.60           O  
ATOM   6784  CG2 THR F 124     -10.913  72.478  30.491  1.00 13.86           C  
ATOM   6785  N   VAL F 125      -9.131  75.567  32.333  1.00 13.69           N  
ATOM   6786  CA  VAL F 125      -7.977  76.381  31.931  1.00 14.39           C  
ATOM   6787  C   VAL F 125      -6.751  76.050  32.810  1.00 13.67           C  
ATOM   6788  O   VAL F 125      -5.629  75.957  32.304  1.00 14.29           O  
ATOM   6789  CB  VAL F 125      -8.299  77.902  31.984  1.00 15.02           C  
ATOM   6790  CG1 VAL F 125      -7.049  78.712  31.706  1.00 15.62           C  
ATOM   6791  CG2 VAL F 125      -9.368  78.237  30.957  1.00 15.72           C  
ATOM   6792  N   ALA F 126      -6.983  75.867  34.109  1.00 13.25           N  
ATOM   6793  CA  ALA F 126      -5.921  75.486  35.048  1.00 13.07           C  
ATOM   6794  C   ALA F 126      -5.293  74.142  34.634  1.00 12.94           C  
ATOM   6795  O   ALA F 126      -4.072  73.993  34.639  1.00 11.89           O  
ATOM   6796  CB  ALA F 126      -6.472  75.422  36.460  1.00 13.92           C  
ATOM   6797  N   ILE F 127      -6.127  73.177  34.248  1.00 12.53           N  
ATOM   6798  CA  ILE F 127      -5.598  71.905  33.718  1.00 12.26           C  
ATOM   6799  C   ILE F 127      -4.746  72.120  32.461  1.00 12.39           C  
ATOM   6800  O   ILE F 127      -3.663  71.528  32.302  1.00 12.57           O  
ATOM   6801  CB  ILE F 127      -6.739  70.893  33.409  1.00 12.18           C  
ATOM   6802  CG1 ILE F 127      -7.463  70.478  34.698  1.00 11.23           C  
ATOM   6803  CG2 ILE F 127      -6.168  69.633  32.722  1.00 12.05           C  
ATOM   6804  CD1 ILE F 127      -8.837  69.847  34.465  1.00 12.87           C  
ATOM   6805  N   GLY F 128      -5.217  72.987  31.561  1.00 12.47           N  
ATOM   6806  CA  GLY F 128      -4.440  73.301  30.366  1.00 12.74           C  
ATOM   6807  C   GLY F 128      -3.097  73.909  30.743  1.00 12.83           C  
ATOM   6808  O   GLY F 128      -2.033  73.545  30.195  1.00 13.08           O  
ATOM   6809  N   ALA F 129      -3.135  74.843  31.691  1.00 13.28           N  
ATOM   6810  CA  ALA F 129      -1.932  75.557  32.113  1.00 13.40           C  
ATOM   6811  C   ALA F 129      -0.859  74.621  32.670  1.00 13.17           C  
ATOM   6812  O   ALA F 129       0.308  74.698  32.281  1.00 13.10           O  
ATOM   6813  CB  ALA F 129      -2.294  76.647  33.134  1.00 13.87           C  
ATOM   6814  N   ILE F 130      -1.256  73.708  33.554  1.00 13.39           N  
ATOM   6815  CA  ILE F 130      -0.259  72.794  34.141  1.00 13.11           C  
ATOM   6816  C   ILE F 130       0.217  71.803  33.084  1.00 12.97           C  
ATOM   6817  O   ILE F 130       1.389  71.427  33.067  1.00 13.56           O  
ATOM   6818  CB  ILE F 130      -0.739  72.079  35.439  1.00 13.34           C  
ATOM   6819  CG1 ILE F 130       0.369  71.170  36.003  1.00 13.77           C  
ATOM   6820  CG2 ILE F 130      -2.056  71.338  35.211  1.00 13.92           C  
ATOM   6821  CD1 ILE F 130       1.595  71.944  36.510  1.00 15.39           C  
ATOM   6822  N   ASN F 131      -0.671  71.433  32.167  1.00 13.01           N  
ATOM   6823  CA  ASN F 131      -0.244  70.592  31.049  1.00 13.25           C  
ATOM   6824  C   ASN F 131       0.820  71.244  30.176  1.00 13.44           C  
ATOM   6825  O   ASN F 131       1.682  70.558  29.625  1.00 13.65           O  
ATOM   6826  CB  ASN F 131      -1.448  70.086  30.247  1.00 12.94           C  
ATOM   6827  CG  ASN F 131      -1.981  68.792  30.798  1.00 12.65           C  
ATOM   6828  OD1 ASN F 131      -1.523  67.718  30.403  1.00 11.59           O  
ATOM   6829  ND2 ASN F 131      -2.919  68.877  31.744  1.00 11.29           N  
ATOM   6830  N   THR F 132       0.775  72.573  30.083  1.00 13.76           N  
ATOM   6831  CA  THR F 132       1.797  73.315  29.350  1.00 14.18           C  
ATOM   6832  C   THR F 132       3.110  73.330  30.135  1.00 13.69           C  
ATOM   6833  O   THR F 132       4.167  73.046  29.566  1.00 13.35           O  
ATOM   6834  CB  THR F 132       1.298  74.741  29.011  1.00 14.71           C  
ATOM   6835  OG1 THR F 132       0.283  74.646  28.002  1.00 16.15           O  
ATOM   6836  CG2 THR F 132       2.425  75.593  28.492  1.00 15.06           C  
ATOM   6837  N   TRP F 133       3.048  73.656  31.428  1.00 14.14           N  
ATOM   6838  CA  TRP F 133       4.264  73.665  32.257  1.00 15.10           C  
ATOM   6839  C   TRP F 133       4.940  72.297  32.254  1.00 14.34           C  
ATOM   6840  O   TRP F 133       6.163  72.207  32.170  1.00 14.42           O  
ATOM   6841  CB  TRP F 133       3.975  74.080  33.691  1.00 17.05           C  
ATOM   6842  CG  TRP F 133       3.775  75.554  33.895  1.00 19.51           C  
ATOM   6843  CD1 TRP F 133       2.646  76.150  34.360  1.00 22.49           C  
ATOM   6844  CD2 TRP F 133       4.722  76.617  33.659  1.00 21.90           C  
ATOM   6845  NE1 TRP F 133       2.819  77.516  34.436  1.00 22.74           N  
ATOM   6846  CE2 TRP F 133       4.083  77.828  34.009  1.00 22.29           C  
ATOM   6847  CE3 TRP F 133       6.042  76.663  33.185  1.00 22.58           C  
ATOM   6848  CZ2 TRP F 133       4.721  79.081  33.911  1.00 21.28           C  
ATOM   6849  CZ3 TRP F 133       6.682  77.921  33.081  1.00 22.55           C  
ATOM   6850  CH2 TRP F 133       6.009  79.107  33.436  1.00 21.31           C  
ATOM   6851  N   ASN F 134       4.145  71.233  32.375  1.00 13.46           N  
ATOM   6852  CA  ASN F 134       4.707  69.873  32.405  1.00 12.77           C  
ATOM   6853  C   ASN F 134       5.443  69.565  31.089  1.00 12.64           C  
ATOM   6854  O   ASN F 134       6.490  68.915  31.063  1.00 12.93           O  
ATOM   6855  CB  ASN F 134       3.598  68.834  32.592  1.00 13.23           C  
ATOM   6856  CG  ASN F 134       2.927  68.881  33.949  1.00 13.48           C  
ATOM   6857  OD1 ASN F 134       3.437  69.428  34.956  1.00 15.83           O  
ATOM   6858  ND2 ASN F 134       1.774  68.252  33.996  1.00 10.09           N  
ATOM   6859  N   ARG F 135       4.859  70.009  29.986  1.00 13.08           N  
ATOM   6860  CA  ARG F 135       5.463  69.793  28.685  1.00 12.42           C  
ATOM   6861  C   ARG F 135       6.770  70.580  28.534  1.00 13.18           C  
ATOM   6862  O   ARG F 135       7.744  70.069  27.990  1.00 12.48           O  
ATOM   6863  CB  ARG F 135       4.453  70.125  27.593  1.00 13.15           C  
ATOM   6864  CG  ARG F 135       3.458  68.991  27.441  1.00 12.57           C  
ATOM   6865  CD  ARG F 135       2.276  69.307  26.517  1.00 11.44           C  
ATOM   6866  NE  ARG F 135       1.487  68.088  26.316  1.00 12.78           N  
ATOM   6867  CZ  ARG F 135       0.663  67.560  27.217  1.00 13.32           C  
ATOM   6868  NH1 ARG F 135       0.459  68.154  28.394  1.00 13.46           N  
ATOM   6869  NH2 ARG F 135       0.032  66.425  26.936  1.00 12.38           N  
ATOM   6870  N   ILE F 136       6.791  71.805  29.045  1.00 13.50           N  
ATOM   6871  CA  ILE F 136       8.023  72.603  29.040  1.00 14.02           C  
ATOM   6872  C   ILE F 136       9.103  71.967  29.911  1.00 14.45           C  
ATOM   6873  O   ILE F 136      10.220  71.743  29.452  1.00 14.85           O  
ATOM   6874  CB  ILE F 136       7.747  74.072  29.452  1.00 14.20           C  
ATOM   6875  CG1 ILE F 136       6.876  74.750  28.383  1.00 14.92           C  
ATOM   6876  CG2 ILE F 136       9.067  74.836  29.690  1.00 14.82           C  
ATOM   6877  CD1 ILE F 136       6.189  76.023  28.855  1.00 16.70           C  
ATOM   6878  N   ALA F 137       8.748  71.657  31.158  1.00 14.39           N  
ATOM   6879  CA  ALA F 137       9.697  71.100  32.114  1.00 14.70           C  
ATOM   6880  C   ALA F 137      10.228  69.731  31.714  1.00 15.03           C  
ATOM   6881  O   ALA F 137      11.444  69.507  31.739  1.00 15.56           O  
ATOM   6882  CB  ALA F 137       9.116  71.078  33.518  1.00 14.83           C  
ATOM   6883  N   VAL F 138       9.351  68.801  31.347  1.00 14.67           N  
ATOM   6884  CA  VAL F 138       9.856  67.495  30.904  1.00 14.90           C  
ATOM   6885  C   VAL F 138      10.615  67.645  29.585  1.00 15.13           C  
ATOM   6886  O   VAL F 138      11.704  67.081  29.423  1.00 16.17           O  
ATOM   6887  CB  VAL F 138       8.739  66.453  30.773  1.00 14.44           C  
ATOM   6888  CG1 VAL F 138       9.283  65.134  30.186  1.00 15.29           C  
ATOM   6889  CG2 VAL F 138       8.089  66.212  32.132  1.00 16.04           C  
ATOM   6890  N   GLY F 139      10.060  68.440  28.671  1.00 15.26           N  
ATOM   6891  CA  GLY F 139      10.666  68.671  27.355  1.00 15.60           C  
ATOM   6892  C   GLY F 139      12.081  69.221  27.433  1.00 16.10           C  
ATOM   6893  O   GLY F 139      12.936  68.863  26.624  1.00 16.42           O  
ATOM   6894  N   PHE F 140      12.333  70.077  28.419  1.00 15.75           N  
ATOM   6895  CA  PHE F 140      13.655  70.684  28.543  1.00 16.38           C  
ATOM   6896  C   PHE F 140      14.451  70.102  29.696  1.00 16.80           C  
ATOM   6897  O   PHE F 140      15.525  70.606  30.026  1.00 17.00           O  
ATOM   6898  CB  PHE F 140      13.535  72.201  28.647  1.00 16.49           C  
ATOM   6899  CG  PHE F 140      12.879  72.827  27.456  1.00 18.10           C  
ATOM   6900  CD1 PHE F 140      13.048  72.280  26.183  1.00 18.92           C  
ATOM   6901  CD2 PHE F 140      12.089  73.954  27.603  1.00 18.71           C  
ATOM   6902  CE1 PHE F 140      12.423  72.864  25.064  1.00 20.10           C  
ATOM   6903  CE2 PHE F 140      11.468  74.536  26.503  1.00 18.39           C  
ATOM   6904  CZ  PHE F 140      11.631  73.998  25.242  1.00 18.99           C  
ATOM   6905  N   ARG F 141      13.916  69.035  30.297  1.00 16.30           N  
ATOM   6906  CA  ARG F 141      14.605  68.289  31.347  1.00 16.70           C  
ATOM   6907  C   ARG F 141      14.998  69.191  32.516  1.00 16.64           C  
ATOM   6908  O   ARG F 141      16.109  69.081  33.053  1.00 16.67           O  
ATOM   6909  CB  ARG F 141      15.841  67.564  30.787  1.00 16.76           C  
ATOM   6910  CG  ARG F 141      15.524  66.461  29.779  1.00 18.92           C  
ATOM   6911  CD  ARG F 141      14.948  65.238  30.461  1.00 21.07           C  
ATOM   6912  NE  ARG F 141      14.877  64.045  29.618  1.00 20.54           N  
ATOM   6913  CZ  ARG F 141      13.787  63.646  28.963  1.00 21.45           C  
ATOM   6914  NH1 ARG F 141      12.667  64.365  29.015  1.00 21.55           N  
ATOM   6915  NH2 ARG F 141      13.821  62.528  28.252  1.00 21.20           N  
ATOM   6916  N   SER F 142      14.079  70.067  32.915  1.00 16.00           N  
ATOM   6917  CA  SER F 142      14.297  70.926  34.082  1.00 16.11           C  
ATOM   6918  C   SER F 142      14.565  70.069  35.315  1.00 16.33           C  
ATOM   6919  O   SER F 142      13.919  69.034  35.512  1.00 15.87           O  
ATOM   6920  CB  SER F 142      13.090  71.840  34.326  1.00 16.85           C  
ATOM   6921  OG  SER F 142      12.822  72.645  33.191  1.00 17.74           O  
ATOM   6922  N   GLN F 143      15.531  70.504  36.122  1.00 15.81           N  
ATOM   6923  CA  GLN F 143      15.982  69.762  37.305  1.00 16.63           C  
ATOM   6924  C   GLN F 143      15.522  70.447  38.586  1.00 16.49           C  
ATOM   6925  O   GLN F 143      15.843  71.617  38.843  1.00 17.17           O  
ATOM   6926  CB  GLN F 143      17.514  69.616  37.312  1.00 16.73           C  
ATOM   6927  CG  GLN F 143      18.088  68.937  36.078  1.00 17.82           C  
ATOM   6928  CD  GLN F 143      17.679  67.488  35.949  1.00 21.09           C  
ATOM   6929  OE1 GLN F 143      17.019  67.091  34.968  1.00 22.43           O  
ATOM   6930  NE2 GLN F 143      18.049  66.684  36.938  1.00 21.30           N  
ATOM   6931  N   HIS F 144      14.770  69.722  39.407  1.00 16.50           N  
ATOM   6932  CA  HIS F 144      14.285  70.311  40.648  1.00 16.23           C  
ATOM   6933  C   HIS F 144      15.379  70.294  41.715  1.00 17.01           C  
ATOM   6934  O   HIS F 144      16.307  69.482  41.633  1.00 16.66           O  
ATOM   6935  CB  HIS F 144      12.975  69.640  41.119  1.00 15.67           C  
ATOM   6936  CG  HIS F 144      13.148  68.256  41.657  1.00 15.03           C  
ATOM   6937  ND1 HIS F 144      13.607  68.007  42.934  1.00 14.85           N  
ATOM   6938  CD2 HIS F 144      12.869  67.044  41.112  1.00 14.99           C  
ATOM   6939  CE1 HIS F 144      13.638  66.699  43.140  1.00 16.13           C  
ATOM   6940  NE2 HIS F 144      13.187  66.093  42.053  1.00 14.10           N  
ATOM   6941  N   PRO F 145      15.281  71.208  42.700  1.00 18.23           N  
ATOM   6942  CA  PRO F 145      16.245  71.252  43.806  1.00 19.15           C  
ATOM   6943  C   PRO F 145      16.166  69.994  44.657  1.00 19.83           C  
ATOM   6944  O   PRO F 145      15.076  69.471  44.866  1.00 19.57           O  
ATOM   6945  CB  PRO F 145      15.774  72.452  44.645  1.00 19.13           C  
ATOM   6946  CG  PRO F 145      14.875  73.235  43.776  1.00 20.61           C  
ATOM   6947  CD  PRO F 145      14.267  72.273  42.802  1.00 18.62           C  
ATOM   6948  N   VAL F 146      17.308  69.537  45.167  1.00 21.21           N  
ATOM   6949  CA  VAL F 146      17.339  68.379  46.062  1.00 22.60           C  
ATOM   6950  C   VAL F 146      17.713  68.864  47.467  1.00 24.18           C  
ATOM   6951  O   VAL F 146      18.730  69.530  47.628  1.00 23.67           O  
ATOM   6952  CB  VAL F 146      18.309  67.276  45.543  1.00 22.59           C  
ATOM   6953  CG1 VAL F 146      18.410  66.114  46.527  1.00 22.73           C  
ATOM   6954  CG2 VAL F 146      17.841  66.757  44.191  1.00 23.75           C  
ATOM   6955  N   GLU F 147      16.879  68.537  48.460  1.00 25.81           N  
ATOM   6956  CA  GLU F 147      17.064  69.003  49.850  1.00 28.21           C  
ATOM   6957  C   GLU F 147      18.335  68.443  50.485  1.00 28.73           C  
ATOM   6958  O   GLU F 147      18.865  67.423  50.042  1.00 29.48           O  
ATOM   6959  CB  GLU F 147      15.869  68.615  50.730  1.00 28.86           C  
ATOM   6960  CG  GLU F 147      14.497  68.844  50.110  1.00 31.91           C  
ATOM   6961  CD  GLU F 147      13.843  70.157  50.505  1.00 35.36           C  
ATOM   6962  OE1 GLU F 147      12.610  70.145  50.721  1.00 36.83           O  
ATOM   6963  OE2 GLU F 147      14.540  71.195  50.600  1.00 37.06           O  
ATOM   6964  N   ALA F 148      18.807  69.109  51.538  1.00 29.50           N  
ATOM   6965  CA  ALA F 148      20.006  68.675  52.255  1.00 30.12           C  
ATOM   6966  C   ALA F 148      19.702  67.454  53.120  1.00 30.47           C  
ATOM   6967  O   ALA F 148      20.234  66.368  52.902  1.00 30.54           O  
ATOM   6968  CB  ALA F 148      20.555  69.816  53.116  1.00 30.46           C  
TER    6969      ALA F 148                                                      
END
MOLECULE T0408.pdb
ATOM    769  N   PHE     7       8.970  79.991  40.219  1.00 59.01           N  
ATOM    770  CA  PHE     7       9.121  78.887  39.220  1.00 58.55           C  
ATOM    771  C   PHE     7      10.525  78.270  39.318  1.00 57.17           C  
ATOM    772  O   PHE     7      11.448  78.885  39.884  1.00 59.33           O  
ATOM    773  CB  PHE     7       8.894  79.403  37.792  1.00 59.50           C  
ATOM    774  CG  PHE     7       7.630  80.211  37.607  1.00 59.88           C  
ATOM    775  CD1 PHE     7       7.640  81.590  37.779  1.00 59.55           C  
ATOM    776  CD2 PHE     7       6.441  79.594  37.219  1.00 60.26           C  
ATOM    777  CE1 PHE     7       6.481  82.338  37.600  1.00 63.27           C  
ATOM    778  CE2 PHE     7       5.280  80.335  37.027  1.00 57.96           C  
ATOM    779  CZ  PHE     7       5.299  81.709  37.222  1.00 60.10           C  
ATOM    780  N   GLY     8      10.693  77.077  38.739  1.00 51.97           N  
ATOM    781  CA  GLY     8      11.946  76.308  38.864  1.00 47.06           C  
ATOM    782  C   GLY     8      13.010  76.644  37.842  1.00 42.74           C  
ATOM    783  O   GLY     8      12.960  77.691  37.199  1.00 40.60           O  
ATOM    784  N   GLU     9      13.969  75.734  37.690  1.00 39.01           N  
ATOM    785  CA  GLU     9      15.125  75.924  36.812  1.00 38.04           C  
ATOM    786  C   GLU     9      14.737  76.079  35.344  1.00 34.61           C  
ATOM    787  O   GLU     9      15.312  76.893  34.624  1.00 33.70           O  
ATOM    788  CB  GLU     9      16.093  74.746  36.964  1.00 38.65           C  
ATOM    789  N   GLY    10      13.750  75.287  34.915  1.00 34.19           N  
ATOM    790  CA  GLY    10      13.250  75.348  33.551  1.00 31.10           C  
ATOM    791  C   GLY    10      12.790  76.744  33.220  1.00 25.97           C  
ATOM    792  O   GLY    10      13.200  77.304  32.203  1.00 24.44           O  
ATOM    793  N   MET    11      11.958  77.314  34.091  1.00 26.78           N  
ATOM    794  CA  MET    11      11.453  78.679  33.871  1.00 26.99           C  
ATOM    795  C   MET    11      12.547  79.734  33.936  1.00 24.54           C  
ATOM    796  O   MET    11      12.436  80.750  33.237  1.00 22.59           O  
ATOM    797  CB  MET    11      10.298  79.036  34.809  1.00 26.96           C  
ATOM    798  CG  MET    11       8.956  78.424  34.384  1.00 30.81           C  
ATOM    799  SD  MET    11       8.363  79.163  32.682  0.75 32.36          SE  
ATOM    800  CE  MET    11       7.641  80.815  33.439  1.00 38.14           C  
ATOM    801  N   LYS    12      13.587  79.531  34.749  1.00 22.58           N  
ATOM    802  CA  LYS    12      14.709  80.488  34.749  1.00 22.98           C  
ATOM    803  C   LYS    12      15.471  80.468  33.411  1.00 20.97           C  
ATOM    804  O   LYS    12      15.931  81.507  32.944  1.00 22.83           O  
ATOM    805  CB  LYS    12      15.656  80.233  35.932  1.00 24.68           C  
ATOM    806  CG  LYS    12      14.987  80.568  37.290  1.00 26.05           C  
ATOM    807  CD  LYS    12      15.724  79.996  38.524  1.00 31.53           C  
ATOM    808  CE  LYS    12      17.178  80.177  38.487  1.00 33.33           C  
ATOM    809  NZ  LYS    12      17.857  79.899  39.811  1.00 35.75           N  
ATOM    810  N   VAL    13      15.558  79.292  32.784  1.00 23.05           N  
ATOM    811  CA  VAL    13      16.174  79.143  31.455  1.00 22.27           C  
ATOM    812  C   VAL    13      15.338  79.931  30.437  1.00 19.87           C  
ATOM    813  O   VAL    13      15.870  80.675  29.599  1.00 19.37           O  
ATOM    814  CB  VAL    13      16.227  77.631  31.026  1.00 24.12           C  
ATOM    815  CG1 VAL    13      16.716  77.489  29.584  1.00 25.29           C  
ATOM    816  CG2 VAL    13      17.136  76.836  31.979  1.00 30.23           C  
ATOM    817  N   VAL    14      14.032  79.817  30.576  1.00 20.72           N  
ATOM    818  CA  VAL    14      13.119  80.535  29.668  1.00 22.65           C  
ATOM    819  C   VAL    14      13.274  82.037  29.865  1.00 19.62           C  
ATOM    820  O   VAL    14      13.348  82.784  28.895  1.00 20.37           O  
ATOM    821  CB  VAL    14      11.657  80.121  29.823  1.00 21.69           C  
ATOM    822  CG1 VAL    14      10.788  80.938  28.849  1.00 21.74           C  
ATOM    823  CG2 VAL    14      11.465  78.585  29.542  1.00 26.25           C  
ATOM    824  N   LYS    15      13.332  82.483  31.131  1.00 21.22           N  
ATOM    825  CA  LYS    15      13.580  83.912  31.414  1.00 18.46           C  
ATOM    826  C   LYS    15      14.866  84.401  30.767  1.00 19.65           C  
ATOM    827  O   LYS    15      14.894  85.480  30.187  1.00 22.14           O  
ATOM    828  CB  LYS    15      13.617  84.181  32.921  1.00 18.27           C  
ATOM    829  N   GLU    16      15.918  83.608  30.857  1.00 21.08           N  
ATOM    830  CA  GLU    16      17.202  83.950  30.227  1.00 22.56           C  
ATOM    831  C   GLU    16      17.144  83.974  28.678  1.00 22.82           C  
ATOM    832  O   GLU    16      17.665  84.891  28.042  1.00 28.47           O  
ATOM    833  CB  GLU    16      18.277  82.981  30.693  1.00 24.31           C  
ATOM    834  N   LYS    17      16.521  82.963  28.097  1.00 21.86           N  
ATOM    835  CA  LYS    17      16.542  82.770  26.636  1.00 22.20           C  
ATOM    836  C   LYS    17      15.493  83.586  25.851  1.00 21.86           C  
ATOM    837  O   LYS    17      15.808  84.146  24.776  1.00 23.86           O  
ATOM    838  CB  LYS    17      16.365  81.277  26.315  1.00 21.29           C  
ATOM    839  N   TYR    18      14.290  83.672  26.407  1.00 22.99           N  
ATOM    840  CA  TYR    18      13.084  84.212  25.724  1.00 24.08           C  
ATOM    841  C   TYR    18      12.235  85.030  26.691  1.00 21.96           C  
ATOM    842  O   TYR    18      11.217  84.579  27.196  1.00 21.62           O  
ATOM    843  CB  TYR    18      12.270  83.071  25.102  1.00 23.86           C  
ATOM    844  CG  TYR    18      13.142  82.276  24.153  1.00 25.16           C  
ATOM    845  CD1 TYR    18      13.658  82.867  23.007  1.00 22.60           C  
ATOM    846  CD2 TYR    18      13.503  80.967  24.432  1.00 27.55           C  
ATOM    847  CE1 TYR    18      14.496  82.174  22.142  1.00 26.49           C  
ATOM    848  CE2 TYR    18      14.364  80.270  23.576  1.00 26.29           C  
ATOM    849  CZ  TYR    18      14.846  80.874  22.433  1.00 25.54           C  
ATOM    850  OH  TYR    18      15.686  80.188  21.581  1.00 26.16           O  
ATOM    851  N   PRO    19      12.703  86.256  26.994  1.00 22.95           N  
ATOM    852  CA  PRO    19      12.008  87.103  27.963  1.00 20.97           C  
ATOM    853  C   PRO    19      10.540  87.377  27.666  1.00 23.47           C  
ATOM    854  O   PRO    19       9.729  87.342  28.598  1.00 22.73           O  
ATOM    855  CB  PRO    19      12.823  88.395  27.933  1.00 22.49           C  
ATOM    856  CG  PRO    19      14.111  88.033  27.370  1.00 24.22           C  
ATOM    857  CD  PRO    19      13.956  86.869  26.528  1.00 23.77           C  
ATOM    858  N   ASP    20      10.175  87.629  26.413  1.00 23.93           N  
ATOM    859  CA  ASP    20       8.772  87.917  26.104  1.00 28.48           C  
ATOM    860  C   ASP    20       7.908  86.671  26.266  1.00 26.25           C  
ATOM    861  O   ASP    20       6.756  86.723  26.775  1.00 26.13           O  
ATOM    862  CB  ASP    20       8.618  88.482  24.690  1.00 30.80           C  
ATOM    863  CG  ASP    20       9.052  89.954  24.570  1.00 38.16           C  
ATOM    864  OD1 ASP    20       9.402  90.617  25.580  1.00 42.94           O  
ATOM    865  OD2 ASP    20       9.033  90.451  23.426  1.00 46.06           O  
ATOM    866  N   LEU    21       8.444  85.524  25.878  1.00 24.97           N  
ATOM    867  CA  LEU    21       7.721  84.269  26.090  1.00 23.54           C  
ATOM    868  C   LEU    21       7.555  83.994  27.575  1.00 22.52           C  
ATOM    869  O   LEU    21       6.474  83.604  28.042  1.00 24.44           O  
ATOM    870  CB  LEU    21       8.447  83.115  25.385  1.00 23.74           C  
ATOM    871  CG  LEU    21       7.857  81.731  25.468  1.00 25.87           C  
ATOM    872  CD1 LEU    21       6.373  81.718  24.990  1.00 25.00           C  
ATOM    873  CD2 LEU    21       8.754  80.756  24.680  1.00 23.70           C  
ATOM    874  N   TYR    22       8.626  84.193  28.326  1.00 22.41           N  
ATOM    875  CA  TYR    22       8.584  84.070  29.780  1.00 22.77           C  
ATOM    876  C   TYR    22       7.435  84.913  30.380  1.00 22.67           C  
ATOM    877  O   TYR    22       6.627  84.425  31.175  1.00 23.91           O  
ATOM    878  CB  TYR    22       9.912  84.494  30.385  1.00 23.66           C  
ATOM    879  CG  TYR    22       9.886  84.492  31.893  1.00 22.50           C  
ATOM    880  CD1 TYR    22      10.074  83.325  32.604  1.00 23.27           C  
ATOM    881  CD2 TYR    22       9.660  85.671  32.602  1.00 25.67           C  
ATOM    882  CE1 TYR    22      10.047  83.327  33.987  1.00 21.18           C  
ATOM    883  CE2 TYR    22       9.622  85.671  33.963  1.00 25.00           C  
ATOM    884  CZ  TYR    22       9.808  84.488  34.647  1.00 23.45           C  
ATOM    885  OH  TYR    22       9.784  84.487  35.999  1.00 27.44           O  
ATOM    886  N   ASP    23       7.378  86.174  29.980  1.00 23.82           N  
ATOM    887  CA  ASP    23       6.360  87.088  30.502  1.00 24.16           C  
ATOM    888  C   ASP    23       4.927  86.625  30.205  1.00 25.07           C  
ATOM    889  O   ASP    23       4.046  86.754  31.064  1.00 23.28           O  
ATOM    890  CB  ASP    23       6.577  88.482  29.910  1.00 24.42           C  
ATOM    891  CG  ASP    23       7.742  89.194  30.505  1.00 33.39           C  
ATOM    892  OD1 ASP    23       8.216  88.809  31.607  1.00 34.11           O  
ATOM    893  OD2 ASP    23       8.170  90.189  29.868  1.00 37.66           O  
ATOM    894  N   ILE    24       4.693  86.066  29.019  1.00 23.65           N  
ATOM    895  CA  ILE    24       3.350  85.619  28.651  1.00 24.84           C  
ATOM    896  C   ILE    24       3.018  84.370  29.489  1.00 23.61           C  
ATOM    897  O   ILE    24       1.899  84.210  29.967  1.00 24.22           O  
ATOM    898  CB  ILE    24       3.222  85.316  27.150  1.00 27.79           C  
ATOM    899  CG1 ILE    24       3.448  86.587  26.329  1.00 32.72           C  
ATOM    900  CG2 ILE    24       1.848  84.746  26.841  1.00 30.67           C  
ATOM    901  CD1 ILE    24       3.838  86.311  24.854  1.00 35.16           C  
ATOM    902  N   ILE    25       4.024  83.514  29.707  1.00 24.35           N  
ATOM    903  CA  ILE    25       3.817  82.316  30.523  1.00 24.21           C  
ATOM    904  C   ILE    25       3.445  82.707  31.965  1.00 23.22           C  
ATOM    905  O   ILE    25       2.509  82.132  32.562  1.00 25.47           O  
ATOM    906  CB  ILE    25       5.047  81.338  30.493  1.00 24.22           C  
ATOM    907  CG1 ILE    25       5.238  80.729  29.103  1.00 23.74           C  
ATOM    908  CG2 ILE    25       4.856  80.188  31.494  1.00 29.35           C  
ATOM    909  CD1 ILE    25       6.631  80.075  28.922  1.00 23.35           C  
ATOM    910  N   VAL    26       4.144  83.697  32.511  1.00 24.58           N  
ATOM    911  CA  VAL    26       3.846  84.171  33.859  1.00 26.19           C  
ATOM    912  C   VAL    26       2.405  84.710  33.937  1.00 24.90           C  
ATOM    913  O   VAL    26       1.639  84.349  34.854  1.00 24.16           O  
ATOM    914  CB  VAL    26       4.836  85.230  34.313  1.00 28.22           C  
ATOM    915  CG1 VAL    26       4.301  85.976  35.531  1.00 28.71           C  
ATOM    916  CG2 VAL    26       6.242  84.589  34.603  1.00 26.39           C  
ATOM    917  N   LYS    27       2.006  85.523  32.967  1.00 23.37           N  
ATOM    918  CA  LYS    27       0.622  86.024  32.925  0.50 23.88           C  
ATOM    920  C   LYS    27      -0.377  84.879  32.823  1.00 24.17           C  
ATOM    921  O   LYS    27      -1.387  84.886  33.498  1.00 24.41           O  
ATOM    922  CB  LYS    27       0.414  87.028  31.779  0.50 24.31           C  
ATOM    924  CG  LYS    27       1.172  88.334  31.934  0.50 20.98           C  
ATOM    926  N   LEU    28      -0.091  83.873  31.981  1.00 23.31           N  
ATOM    927  CA  LEU    28      -0.962  82.705  31.832  1.00 25.23           C  
ATOM    928  C   LEU    28      -1.121  81.995  33.180  1.00 25.13           C  
ATOM    929  O   LEU    28      -2.231  81.653  33.640  1.00 24.63           O  
ATOM    930  CB  LEU    28      -0.374  81.739  30.788  1.00 23.04           C  
ATOM    931  CG  LEU    28      -1.148  80.428  30.624  1.00 24.78           C  
ATOM    932  CD1 LEU    28      -2.545  80.697  30.079  1.00 32.09           C  
ATOM    933  CD2 LEU    28      -0.369  79.493  29.738  1.00 28.12           C  
ATOM    934  N   ASN    29       0.023  81.773  33.828  1.00 22.56           N  
ATOM    935  CA  ASN    29       0.048  81.101  35.117  1.00 24.38           C  
ATOM    936  C   ASN    29      -0.813  81.844  36.140  1.00 22.89           C  
ATOM    937  O   ASN    29      -1.651  81.255  36.839  1.00 26.79           O  
ATOM    938  CB  ASN    29       1.491  80.993  35.606  1.00 27.63           C  
ATOM    939  CG  ASN    29       1.585  80.340  36.962  1.00 33.82           C  
ATOM    940  OD1 ASN    29       1.667  79.126  37.053  1.00 33.33           O  
ATOM    941  ND2 ASN    29       1.566  81.143  38.011  1.00 35.43           N  
ATOM    942  N   ASP    30      -0.596  83.141  36.234  1.00 22.88           N  
ATOM    943  CA  ASP    30      -1.285  83.973  37.203  1.00 24.82           C  
ATOM    944  C   ASP    30      -2.797  84.034  36.943  1.00 25.07           C  
ATOM    945  O   ASP    30      -3.601  84.001  37.880  1.00 26.99           O  
ATOM    946  CB  ASP    30      -0.694  85.365  37.193  1.00 26.68           C  
ATOM    947  CG  ASP    30       0.726  85.408  37.720  1.00 28.43           C  
ATOM    948  OD1 ASP    30       1.234  84.358  38.174  1.00 35.44           O  
ATOM    949  OD2 ASP    30       1.331  86.499  37.649  1.00 29.80           O  
ATOM    950  N   THR    31      -3.173  84.070  35.675  1.00 22.79           N  
ATOM    951  CA  THR    31      -4.600  83.984  35.289  1.00 24.26           C  
ATOM    952  C   THR    31      -5.213  82.620  35.540  1.00 23.93           C  
ATOM    953  O   THR    31      -6.339  82.515  36.082  1.00 24.83           O  
ATOM    954  CB  THR    31      -4.809  84.366  33.824  1.00 22.72           C  
ATOM    955  OG1 THR    31      -4.260  85.683  33.614  1.00 30.25           O  
ATOM    956  CG2 THR    31      -6.307  84.307  33.460  1.00 24.57           C  
ATOM    957  N   VAL    32      -4.509  81.554  35.146  1.00 22.77           N  
ATOM    958  CA  VAL    32      -4.974  80.194  35.438  1.00 24.03           C  
ATOM    959  C   VAL    32      -5.286  80.043  36.936  1.00 23.77           C  
ATOM    960  O   VAL    32      -6.329  79.469  37.304  1.00 25.63           O  
ATOM    961  CB  VAL    32      -3.924  79.174  34.994  1.00 23.98           C  
ATOM    962  CG1 VAL    32      -4.033  77.835  35.796  1.00 24.54           C  
ATOM    963  CG2 VAL    32      -4.012  78.986  33.460  1.00 22.05           C  
ATOM    964  N   PHE    33      -4.431  80.590  37.799  1.00 23.43           N  
ATOM    965  CA  PHE    33      -4.601  80.397  39.246  1.00 25.33           C  
ATOM    966  C   PHE    33      -5.403  81.502  39.922  1.00 27.87           C  
ATOM    967  O   PHE    33      -5.384  81.637  41.159  1.00 27.20           O  
ATOM    968  CB  PHE    33      -3.266  80.181  39.951  1.00 27.45           C  
ATOM    969  CG  PHE    33      -2.688  78.829  39.709  1.00 26.58           C  
ATOM    970  CD1 PHE    33      -3.361  77.688  40.124  1.00 26.58           C  
ATOM    971  CD2 PHE    33      -1.487  78.692  39.040  1.00 27.16           C  
ATOM    972  CE1 PHE    33      -2.844  76.433  39.875  1.00 26.69           C  
ATOM    973  CE2 PHE    33      -0.960  77.444  38.790  1.00 25.47           C  
ATOM    974  CZ  PHE    33      -1.643  76.315  39.204  1.00 28.16           C  
ATOM    975  N   THR    34      -6.104  82.288  39.114  1.00 28.08           N  
ATOM    976  CA  THR    34      -7.123  83.205  39.620  1.00 27.68           C  
ATOM    977  C   THR    34      -8.472  82.607  39.227  1.00 26.27           C  
ATOM    978  O   THR    34      -9.079  82.991  38.223  1.00 24.59           O  
ATOM    979  CB  THR    34      -6.912  84.630  39.078  1.00 29.15           C  
ATOM    980  OG1 THR    34      -5.572  85.039  39.354  1.00 27.52           O  
ATOM    981  CG2 THR    34      -7.858  85.624  39.752  1.00 27.57           C  
ATOM    982  N   GLY    35      -8.916  81.627  40.013  1.00 23.37           N  
ATOM    983  CA  GLY    35     -10.169  80.966  39.763  1.00 26.15           C  
ATOM    984  C   GLY    35     -11.353  81.880  40.008  1.00 26.00           C  
ATOM    985  O   GLY    35     -11.261  82.862  40.761  1.00 26.21           O  
ATOM    986  N   LYS    36     -12.466  81.593  39.353  1.00 26.20           N  
ATOM    987  CA  LYS    36     -13.707  82.364  39.626  1.00 25.52           C  
ATOM    988  C   LYS    36     -14.401  81.918  40.902  1.00 25.59           C  
ATOM    989  O   LYS    36     -15.013  82.749  41.608  1.00 24.82           O  
ATOM    990  CB  LYS    36     -14.650  82.280  38.433  1.00 23.76           C  
ATOM    991  CG  LYS    36     -14.018  82.839  37.170  1.00 27.92           C  
ATOM    992  CD  LYS    36     -13.636  84.274  37.261  1.00 33.79           C  
ATOM    993  CE  LYS    36     -13.123  84.756  35.913  1.00 33.74           C  
ATOM    994  NZ  LYS    36     -12.672  86.191  35.921  1.00 36.41           N  
ATOM    995  N   THR    37     -14.305  80.634  41.224  1.00 26.34           N  
ATOM    996  CA  THR    37     -14.895  80.088  42.444  1.00 27.40           C  
ATOM    997  C   THR    37     -13.901  79.304  43.281  1.00 28.68           C  
ATOM    998  O   THR    37     -13.830  79.501  44.486  1.00 28.44           O  
ATOM    999  CB  THR    37     -16.085  79.125  42.147  1.00 30.61           C  
ATOM   1000  OG1 THR    37     -17.140  79.845  41.507  1.00 34.12           O  
ATOM   1001  CG2 THR    37     -16.683  78.562  43.442  1.00 27.91           C  
ATOM   1002  N   LEU    38     -13.154  78.398  42.652  1.00 24.44           N  
ATOM   1003  CA  LEU    38     -12.190  77.556  43.382  1.00 24.53           C  
ATOM   1004  C   LEU    38     -11.018  78.408  43.841  1.00 26.73           C  
ATOM   1005  O   LEU    38     -10.561  79.304  43.117  1.00 26.13           O  
ATOM   1006  CB  LEU    38     -11.682  76.416  42.494  1.00 24.24           C  
ATOM   1007  CG  LEU    38     -12.721  75.446  41.996  1.00 25.01           C  
ATOM   1008  CD1 LEU    38     -12.043  74.310  41.217  1.00 23.26           C  
ATOM   1009  CD2 LEU    38     -13.555  74.919  43.151  1.00 22.80           C  
ATOM   1010  N   ASP    39     -10.539  78.150  45.053  1.00 25.77           N  
ATOM   1011  CA  ASP    39      -9.405  78.915  45.556  1.00 26.59           C  
ATOM   1012  C   ASP    39      -8.085  78.324  45.076  1.00 26.80           C  
ATOM   1013  O   ASP    39      -8.046  77.280  44.439  1.00 24.07           O  
ATOM   1014  CB  ASP    39      -9.484  79.093  47.084  1.00 27.84           C  
ATOM   1015  CG  ASP    39      -9.352  77.804  47.861  1.00 31.36           C  
ATOM   1016  OD1 ASP    39      -8.887  76.754  47.351  1.00 28.62           O  
ATOM   1017  OD2 ASP    39      -9.729  77.848  49.052  1.00 33.78           O  
ATOM   1018  N   TYR    40      -7.011  79.046  45.327  1.00 25.33           N  
ATOM   1019  CA  TYR    40      -5.703  78.664  44.822  1.00 24.51           C  
ATOM   1020  C   TYR    40      -5.243  77.312  45.372  1.00 25.46           C  
ATOM   1021  O   TYR    40      -4.698  76.478  44.641  1.00 24.60           O  
ATOM   1022  CB  TYR    40      -4.723  79.753  45.247  1.00 28.58           C  
ATOM   1023  CG  TYR    40      -3.320  79.640  44.733  1.00 27.35           C  
ATOM   1024  CD1 TYR    40      -3.051  79.264  43.426  1.00 42.63           C  
ATOM   1025  CD2 TYR    40      -2.241  79.981  45.555  1.00 35.86           C  
ATOM   1026  CE1 TYR    40      -1.744  79.202  42.958  1.00 45.32           C  
ATOM   1027  CE2 TYR    40      -0.946  79.919  45.099  1.00 36.50           C  
ATOM   1028  CZ  TYR    40      -0.701  79.543  43.803  1.00 41.69           C  
ATOM   1029  OH  TYR    40       0.596  79.495  43.344  1.00 43.10           O  
ATOM   1030  N   LYS    41      -5.466  77.097  46.659  1.00 24.17           N  
ATOM   1031  CA  LYS    41      -5.137  75.787  47.259  1.00 26.03           C  
ATOM   1032  C   LYS    41      -5.786  74.622  46.516  1.00 24.80           C  
ATOM   1033  O   LYS    41      -5.121  73.627  46.222  1.00 24.41           O  
ATOM   1034  CB  LYS    41      -5.525  75.756  48.725  1.00 26.17           C  
ATOM   1035  CG  LYS    41      -5.211  74.458  49.459  1.00 31.58           C  
ATOM   1036  CD  LYS    41      -5.774  74.499  50.886  1.00 33.11           C  
ATOM   1037  CE  LYS    41      -5.347  73.283  51.704  1.00 42.88           C  
ATOM   1038  NZ  LYS    41      -5.846  73.354  53.109  1.00 41.08           N  
ATOM   1039  N   THR    42      -7.074  74.738  46.237  1.00 24.70           N  
ATOM   1040  CA  THR    42      -7.798  73.688  45.520  1.00 23.81           C  
ATOM   1041  C   THR    42      -7.217  73.448  44.133  1.00 24.23           C  
ATOM   1042  O   THR    42      -7.022  72.317  43.719  1.00 23.25           O  
ATOM   1043  CB  THR    42      -9.301  73.985  45.416  1.00 24.82           C  
ATOM   1044  OG1 THR    42      -9.845  74.084  46.733  1.00 25.22           O  
ATOM   1045  CG2 THR    42     -10.038  72.883  44.667  1.00 25.77           C  
ATOM   1046  N   GLN    43      -6.933  74.527  43.418  1.00 23.43           N  
ATOM   1047  CA  GLN    43      -6.319  74.414  42.118  1.00 22.86           C  
ATOM   1048  C   GLN    43      -4.922  73.781  42.157  1.00 23.94           C  
ATOM   1049  O   GLN    43      -4.585  73.025  41.268  1.00 22.91           O  
ATOM   1050  CB  GLN    43      -6.246  75.772  41.437  1.00 24.01           C  
ATOM   1051  CG  GLN    43      -7.565  76.328  41.029  1.00 22.72           C  
ATOM   1052  CD  GLN    43      -7.399  77.608  40.263  1.00 23.02           C  
ATOM   1053  OE1 GLN    43      -6.876  78.573  40.809  1.00 25.62           O  
ATOM   1054  NE2 GLN    43      -7.853  77.631  39.000  1.00 24.23           N  
ATOM   1055  N   LYS    44      -4.119  74.119  43.152  1.00 23.49           N  
ATOM   1056  CA  LYS    44      -2.798  73.504  43.293  1.00 22.94           C  
ATOM   1057  C   LYS    44      -2.885  72.010  43.618  1.00 23.73           C  
ATOM   1058  O   LYS    44      -2.073  71.231  43.139  1.00 23.97           O  
ATOM   1059  CB  LYS    44      -1.964  74.236  44.353  1.00 26.12           C  
ATOM   1060  CG  LYS    44      -1.383  75.517  43.796  1.00 37.14           C  
ATOM   1061  CD  LYS    44      -0.199  75.250  42.854  1.00 40.63           C  
ATOM   1062  CE  LYS    44       0.270  76.569  42.238  1.00 46.64           C  
ATOM   1063  NZ  LYS    44       1.409  76.414  41.283  1.00 41.05           N  
ATOM   1064  N   LEU    45      -3.875  71.626  44.416  1.00 22.77           N  
ATOM   1065  CA  LEU    45      -4.158  70.192  44.683  1.00 22.94           C  
ATOM   1066  C   LEU    45      -4.528  69.448  43.403  1.00 20.00           C  
ATOM   1067  O   LEU    45      -4.064  68.333  43.149  1.00 21.82           O  
ATOM   1068  CB  LEU    45      -5.255  70.034  45.759  1.00 24.89           C  
ATOM   1069  CG  LEU    45      -4.872  70.484  47.179  1.00 24.96           C  
ATOM   1070  CD1 LEU    45      -6.093  70.532  48.099  1.00 25.24           C  
ATOM   1071  CD2 LEU    45      -3.795  69.570  47.786  1.00 26.64           C  
ATOM   1072  N   ILE    46      -5.331  70.092  42.557  1.00 20.74           N  
ATOM   1073  CA  ILE    46      -5.651  69.564  41.249  1.00 21.62           C  
ATOM   1074  C   ILE    46      -4.391  69.407  40.390  1.00 20.78           C  
ATOM   1075  O   ILE    46      -4.202  68.383  39.737  1.00 21.91           O  
ATOM   1076  CB  ILE    46      -6.704  70.453  40.547  1.00 22.08           C  
ATOM   1077  CG1 ILE    46      -8.055  70.378  41.275  1.00 24.84           C  
ATOM   1078  CG2 ILE    46      -6.892  70.056  39.052  1.00 22.38           C  
ATOM   1079  CD1 ILE    46      -9.010  71.552  40.931  1.00 22.86           C  
ATOM   1080  N   ALA    47      -3.523  70.426  40.416  1.00 21.87           N  
ATOM   1081  CA  ALA    47      -2.279  70.384  39.643  1.00 21.24           C  
ATOM   1082  C   ALA    47      -1.416  69.194  40.090  1.00 21.15           C  
ATOM   1083  O   ALA    47      -0.852  68.486  39.264  1.00 23.10           O  
ATOM   1084  CB  ALA    47      -1.507  71.727  39.768  1.00 21.67           C  
ATOM   1085  N   ILE    48      -1.326  68.971  41.401  1.00 23.22           N  
ATOM   1086  CA  ILE    48      -0.581  67.815  41.934  1.00 23.42           C  
ATOM   1087  C   ILE    48      -1.151  66.535  41.379  1.00 22.45           C  
ATOM   1088  O   ILE    48      -0.412  65.683  40.917  1.00 22.38           O  
ATOM   1089  CB  ILE    48      -0.565  67.783  43.480  1.00 22.22           C  
ATOM   1090  CG1 ILE    48       0.257  68.942  44.048  1.00 26.05           C  
ATOM   1091  CG2 ILE    48       0.049  66.452  44.023  1.00 25.18           C  
ATOM   1092  CD1 ILE    48      -0.059  69.242  45.504  1.00 25.14           C  
ATOM   1093  N   GLY    49      -2.485  66.395  41.436  1.00 23.64           N  
ATOM   1094  CA  GLY    49      -3.152  65.223  40.890  1.00 22.69           C  
ATOM   1095  C   GLY    49      -2.810  64.948  39.439  1.00 22.13           C  
ATOM   1096  O   GLY    49      -2.514  63.817  39.044  1.00 22.25           O  
ATOM   1097  N   ILE    50      -2.858  65.995  38.620  1.00 21.97           N  
ATOM   1098  CA  ILE    50      -2.611  65.842  37.209  1.00 23.22           C  
ATOM   1099  C   ILE    50      -1.179  65.410  36.958  1.00 20.30           C  
ATOM   1100  O   ILE    50      -0.936  64.483  36.198  1.00 22.58           O  
ATOM   1101  CB  ILE    50      -2.928  67.132  36.415  1.00 23.33           C  
ATOM   1102  CG1 ILE    50      -4.446  67.402  36.425  1.00 25.36           C  
ATOM   1103  CG2 ILE    50      -2.410  67.043  34.958  1.00 25.70           C  
ATOM   1104  CD1 ILE    50      -4.873  68.780  35.946  1.00 23.40           C  
ATOM   1105  N   VAL    51      -0.226  66.112  37.554  1.00 22.13           N  
ATOM   1106  CA  VAL    51       1.198  65.805  37.361  0.50 22.96           C  
ATOM   1108  C   VAL    51       1.534  64.410  37.901  1.00 22.59           C  
ATOM   1109  O   VAL    51       2.294  63.639  37.290  1.00 23.85           O  
ATOM   1110  CB  VAL    51       2.072  66.864  38.052  0.50 23.96           C  
ATOM   1112  CG1 VAL    51       3.558  66.521  37.912  0.50 22.52           C  
ATOM   1114  CG2 VAL    51       1.793  68.268  37.453  0.50 24.56           C  
ATOM   1116  N   ALA    52       0.940  64.069  39.051  1.00 21.97           N  
ATOM   1117  CA  ALA    52       1.198  62.761  39.646  1.00 22.83           C  
ATOM   1118  C   ALA    52       0.615  61.626  38.821  1.00 24.96           C  
ATOM   1119  O   ALA    52       1.057  60.489  38.972  1.00 27.05           O  
ATOM   1120  CB  ALA    52       0.708  62.681  41.110  1.00 22.19           C  
ATOM   1121  N   SER    53      -0.366  61.908  37.962  1.00 23.44           N  
ATOM   1122  CA  SER    53      -0.993  60.900  37.128  0.50 24.03           C  
ATOM   1124  C   SER    53      -0.070  60.482  35.984  1.00 28.22           C  
ATOM   1125  O   SER    53      -0.306  59.463  35.352  1.00 29.44           O  
ATOM   1126  CB  SER    53      -2.358  61.369  36.590  0.50 24.46           C  
ATOM   1128  OG  SER    53      -2.273  62.367  35.572  0.50 17.33           O  
ATOM   1130  N   ARG    54       0.967  61.288  35.750  1.00 27.88           N  
ATOM   1131  CA  ARG    54       1.961  61.079  34.686  1.00 36.49           C  
ATOM   1132  C   ARG    54       3.323  60.666  35.269  1.00 42.51           C  
ATOM   1133  O   ARG    54       3.434  60.416  36.472  1.00 42.98           O  
ATOM   1134  CB  ARG    54       2.061  62.360  33.864  1.00 36.62           C  
ATOM   1135  CG  ARG    54       0.682  62.788  33.371  1.00 36.07           C  
ATOM   1136  CD  ARG    54       0.720  63.747  32.220  1.00 46.03           C  
ATOM   1137  NE  ARG    54       1.186  65.048  32.671  1.00 47.58           N  
ATOM   1138  CZ  ARG    54       0.593  66.218  32.427  1.00 48.31           C  
ATOM   1139  NH1 ARG    54      -0.539  66.301  31.716  1.00 41.50           N  
ATOM   1140  NH2 ARG    54       1.152  67.314  32.919  1.00 45.55           N  
ATOM   1141  N   CYS    55       4.364  60.567  34.441  1.00 47.81           N  
ATOM   1142  CA  CYS    55       5.609  59.917  34.908  1.00 53.06           C  
ATOM   1143  C   CYS    55       6.714  60.870  35.342  1.00 53.53           C  
ATOM   1144  O   CYS    55       7.760  60.423  35.818  1.00 55.63           O  
ATOM   1145  CB  CYS    55       6.175  58.963  33.844  1.00 54.41           C  
ATOM   1146  SG  CYS    55       4.966  57.829  33.125  1.00 70.70           S  
ATOM   1147  N   ASP    56       6.510  62.170  35.183  1.00 51.11           N  
ATOM   1148  CA  ASP    56       7.593  63.097  35.442  1.00 50.75           C  
ATOM   1149  C   ASP    56       7.796  63.237  36.966  1.00 47.60           C  
ATOM   1150  O   ASP    56       7.187  64.093  37.608  1.00 47.73           O  
ATOM   1151  CB  ASP    56       7.335  64.451  34.744  1.00 51.45           C  
ATOM   1152  CG  ASP    56       8.549  65.360  34.751  1.00 55.00           C  
ATOM   1153  OD1 ASP    56       9.598  64.950  35.298  1.00 59.75           O  
ATOM   1154  OD2 ASP    56       8.445  66.490  34.211  1.00 56.95           O  
ATOM   1155  N   GLU    57       8.662  62.376  37.505  1.00 44.76           N  
ATOM   1156  CA  GLU    57       9.079  62.384  38.919  1.00 44.68           C  
ATOM   1157  C   GLU    57       9.555  63.747  39.434  1.00 43.54           C  
ATOM   1158  O   GLU    57       9.225  64.151  40.554  1.00 39.20           O  
ATOM   1159  CB  GLU    57      10.193  61.362  39.121  1.00 44.24           C  
ATOM   1160  CG  GLU    57      10.658  61.181  40.556  1.00 49.33           C  
ATOM   1161  N   VAL    58      10.342  64.453  38.623  1.00 44.25           N  
ATOM   1162  CA  VAL    58      10.846  65.761  39.019  1.00 41.66           C  
ATOM   1163  C   VAL    58       9.712  66.771  39.079  1.00 39.99           C  
ATOM   1164  O   VAL    58       9.637  67.563  40.023  1.00 40.88           O  
ATOM   1165  CB  VAL    58      12.003  66.255  38.076  1.00 44.98           C  
ATOM   1166  N   ALA    59       8.820  66.732  38.092  1.00 36.00           N  
ATOM   1167  CA  ALA    59       7.624  67.563  38.085  1.00 36.40           C  
ATOM   1168  C   ALA    59       6.746  67.291  39.314  1.00 34.21           C  
ATOM   1169  O   ALA    59       6.208  68.222  39.935  1.00 33.66           O  
ATOM   1170  CB  ALA    59       6.840  67.324  36.816  1.00 37.99           C  
ATOM   1171  N   ILE    60       6.614  66.013  39.667  1.00 31.22           N  
ATOM   1172  CA  ILE    60       5.812  65.647  40.839  1.00 28.82           C  
ATOM   1173  C   ILE    60       6.454  66.198  42.119  1.00 27.71           C  
ATOM   1174  O   ILE    60       5.781  66.867  42.913  1.00 27.90           O  
ATOM   1175  CB  ILE    60       5.613  64.129  40.959  1.00 27.95           C  
ATOM   1176  CG1 ILE    60       4.862  63.584  39.742  1.00 27.51           C  
ATOM   1177  CG2 ILE    60       4.812  63.808  42.224  1.00 26.18           C  
ATOM   1178  CD1 ILE    60       4.987  62.071  39.545  1.00 25.07           C  
ATOM   1179  N   GLU    61       7.741  65.915  42.319  1.00 30.04           N  
ATOM   1180  CA  GLU    61       8.460  66.430  43.501  1.00 32.80           C  
ATOM   1181  C   GLU    61       8.345  67.964  43.626  1.00 35.05           C  
ATOM   1182  O   GLU    61       8.090  68.492  44.715  1.00 33.59           O  
ATOM   1183  CB  GLU    61       9.925  65.988  43.468  1.00 33.45           C  
ATOM   1184  CG  GLU    61      10.720  66.333  44.743  1.00 36.55           C  
ATOM   1185  N   LYS    62       8.492  68.665  42.503  1.00 38.76           N  
ATOM   1186  CA  LYS    62       8.430  70.135  42.479  1.00 39.30           C  
ATOM   1187  C   LYS    62       7.040  70.681  42.772  1.00 38.68           C  
ATOM   1188  O   LYS    62       6.906  71.655  43.526  1.00 36.68           O  
ATOM   1189  CB  LYS    62       8.919  70.670  41.123  1.00 42.11           C  
ATOM   1190  N   GLN    63       5.995  70.076  42.198  1.00 35.90           N  
ATOM   1191  CA  GLN    63       4.635  70.517  42.512  1.00 36.26           C  
ATOM   1192  C   GLN    63       4.355  70.313  43.989  1.00 33.33           C  
ATOM   1193  O   GLN    63       3.755  71.165  44.626  1.00 33.91           O  
ATOM   1194  CB  GLN    63       3.548  69.798  41.676  1.00 39.20           C  
ATOM   1195  CG  GLN    63       3.160  70.466  40.335  1.00 44.45           C  
ATOM   1196  CD  GLN    63       2.333  71.749  40.478  1.00 44.95           C  
ATOM   1197  OE1 GLN    63       1.712  72.008  41.510  1.00 62.12           O  
ATOM   1198  NE2 GLN    63       2.315  72.547  39.425  1.00 63.66           N  
ATOM   1199  N   MET    64       4.752  69.161  44.531  1.00 30.47           N  
ATOM   1200  CA  MET    64       4.471  68.856  45.916  1.00 26.68           C  
ATOM   1201  C   MET    64       5.225  69.810  46.838  1.00 29.86           C  
ATOM   1202  O   MET    64       4.645  70.361  47.788  1.00 28.23           O  
ATOM   1203  CB  MET    64       4.864  67.412  46.233  1.00 23.18           C  
ATOM   1204  CG  MET    64       3.918  66.370  45.589  1.00 22.57           C  
ATOM   1205  SD  MET    64       4.418  64.644  46.195  0.75 22.23          SE  
ATOM   1206  CE  MET    64       3.056  63.632  45.253  1.00 22.00           C  
ATOM   1207  N   LYS    65       6.514  69.998  46.544  1.00 32.32           N  
ATOM   1208  CA  LYS    65       7.386  70.856  47.371  1.00 34.88           C  
ATOM   1209  C   LYS    65       6.857  72.284  47.412  1.00 34.19           C  
ATOM   1210  O   LYS    65       6.702  72.863  48.483  1.00 35.31           O  
ATOM   1211  CB  LYS    65       8.826  70.843  46.843  1.00 35.46           C  
ATOM   1212  CG  LYS    65       9.625  69.629  47.243  1.00 40.38           C  
ATOM   1213  N   SER    66       6.564  72.836  46.245  1.00 36.71           N  
ATOM   1214  CA  SER    66       6.041  74.200  46.142  0.50 37.97           C  
ATOM   1216  C   SER    66       4.709  74.361  46.864  1.00 39.15           C  
ATOM   1217  O   SER    66       4.486  75.342  47.552  1.00 40.37           O  
ATOM   1218  CB  SER    66       5.895  74.618  44.676  0.50 38.61           C  
ATOM   1220  OG  SER    66       5.090  73.703  43.950  0.50 37.08           O  
ATOM   1222  N   ALA    67       3.815  73.392  46.707  1.00 37.33           N  
ATOM   1223  CA  ALA    67       2.536  73.447  47.409  1.00 35.90           C  
ATOM   1224  C   ALA    67       2.708  73.505  48.921  1.00 33.63           C  
ATOM   1225  O   ALA    67       2.000  74.242  49.614  1.00 33.38           O  
ATOM   1226  CB  ALA    67       1.675  72.239  47.036  1.00 35.08           C  
ATOM   1227  N   MET    68       3.620  72.690  49.440  1.00 32.12           N  
ATOM   1228  CA  MET    68       3.809  72.592  50.861  1.00 32.59           C  
ATOM   1229  C   MET    68       4.455  73.891  51.335  1.00 33.83           C  
ATOM   1230  O   MET    68       4.036  74.457  52.332  1.00 35.23           O  
ATOM   1231  CB  MET    68       4.684  71.396  51.205  1.00 33.38           C  
ATOM   1232  CG  MET    68       4.027  70.041  50.923  1.00 33.32           C  
ATOM   1233  SD  MET    68       5.192  68.597  51.472  0.75 34.95          SE  
ATOM   1234  CE  MET    68       4.864  68.765  53.369  1.00 39.85           C  
ATOM   1235  N   LYS    69       5.428  74.370  50.567  1.00 35.03           N  
ATOM   1236  CA  LYS    69       6.210  75.565  50.936  1.00 37.33           C  
ATOM   1237  C   LYS    69       5.376  76.830  50.796  1.00 38.14           C  
ATOM   1238  O   LYS    69       5.218  77.585  51.764  1.00 42.29           O  
ATOM   1239  CB  LYS    69       7.470  75.676  50.075  1.00 36.02           C  
ATOM   1240  N   GLU    70       4.833  77.048  49.606  1.00 39.17           N  
ATOM   1241  CA  GLU    70       4.066  78.262  49.302  1.00 40.19           C  
ATOM   1242  C   GLU    70       2.697  78.317  49.975  1.00 40.34           C  
ATOM   1243  O   GLU    70       2.343  79.342  50.543  1.00 42.02           O  
ATOM   1244  CB  GLU    70       3.909  78.452  47.786  1.00 39.25           C  
ATOM   1245  N   LEU    71       1.936  77.226  49.937  1.00 39.71           N  
ATOM   1246  CA  LEU    71       0.552  77.239  50.424  1.00 38.07           C  
ATOM   1247  C   LEU    71       0.339  76.549  51.771  1.00 34.95           C  
ATOM   1248  O   LEU    71      -0.765  76.565  52.307  1.00 37.25           O  
ATOM   1249  CB  LEU    71      -0.380  76.601  49.371  1.00 39.04           C  
ATOM   1250  CG  LEU    71      -0.453  77.252  47.981  1.00 43.95           C  
ATOM   1251  CD1 LEU    71       0.756  76.880  47.115  1.00 50.69           C  
ATOM   1252  CD2 LEU    71      -1.736  76.876  47.251  1.00 39.57           C  
ATOM   1253  N   GLY    72       1.355  75.907  52.325  1.00 31.62           N  
ATOM   1254  CA  GLY    72       1.147  75.169  53.571  1.00 31.33           C  
ATOM   1255  C   GLY    72       0.288  73.914  53.427  1.00 30.39           C  
ATOM   1256  O   GLY    72      -0.302  73.424  54.405  1.00 31.58           O  
ATOM   1257  N   ILE    73       0.217  73.377  52.213  1.00 32.06           N  
ATOM   1258  CA  ILE    73      -0.496  72.104  51.983  1.00 28.57           C  
ATOM   1259  C   ILE    73       0.221  70.989  52.779  1.00 29.16           C  
ATOM   1260  O   ILE    73       1.450  70.986  52.850  1.00 29.32           O  
ATOM   1261  CB  ILE    73      -0.621  71.840  50.468  1.00 30.50           C  
ATOM   1262  CG1 ILE    73      -1.744  72.732  49.891  1.00 27.84           C  
ATOM   1263  CG2 ILE    73      -0.867  70.336  50.174  1.00 25.19           C  
ATOM   1264  CD1 ILE    73      -1.816  72.820  48.371  1.00 30.38           C  
ATOM   1265  N   THR    74      -0.530  70.088  53.420  1.00 27.36           N  
ATOM   1266  CA  THR    74       0.088  69.024  54.242  1.00 27.26           C  
ATOM   1267  C   THR    74       0.356  67.745  53.462  1.00 27.58           C  
ATOM   1268  O   THR    74      -0.238  67.522  52.416  1.00 24.17           O  
ATOM   1269  CB  THR    74      -0.757  68.627  55.460  1.00 29.19           C  
ATOM   1270  OG1 THR    74      -2.004  68.099  55.031  1.00 28.81           O  
ATOM   1271  CG2 THR    74      -0.971  69.880  56.480  1.00 28.98           C  
ATOM   1272  N   LYS    75       1.211  66.876  53.997  1.00 26.69           N  
ATOM   1273  CA  LYS    75       1.408  65.575  53.357  1.00 24.94           C  
ATOM   1274  C   LYS    75       0.105  64.766  53.394  1.00 24.97           C  
ATOM   1275  O   LYS    75      -0.183  64.049  52.430  1.00 24.26           O  
ATOM   1276  CB  LYS    75       2.547  64.787  54.001  1.00 25.92           C  
ATOM   1277  CG  LYS    75       3.941  65.377  53.781  1.00 25.04           C  
ATOM   1278  CD  LYS    75       5.016  64.369  54.207  1.00 27.40           C  
ATOM   1279  CE  LYS    75       6.395  64.744  53.675  1.00 30.74           C  
ATOM   1280  NZ  LYS    75       7.337  63.582  53.770  1.00 29.47           N  
ATOM   1281  N   GLU    76      -0.705  64.923  54.456  1.00 23.62           N  
ATOM   1282  CA  GLU    76      -2.006  64.250  54.537  1.00 27.19           C  
ATOM   1283  C   GLU    76      -2.963  64.703  53.418  1.00 22.94           C  
ATOM   1284  O   GLU    76      -3.670  63.897  52.828  1.00 25.59           O  
ATOM   1285  CB  GLU    76      -2.676  64.495  55.897  1.00 28.02           C  
ATOM   1286  CG  GLU    76      -3.944  63.646  56.101  1.00 35.01           C  
ATOM   1287  CD  GLU    76      -4.602  63.869  57.467  1.00 37.01           C  
ATOM   1288  OE1 GLU    76      -4.541  65.017  57.990  1.00 52.64           O  
ATOM   1289  OE2 GLU    76      -5.167  62.883  58.002  1.00 48.87           O  
ATOM   1290  N   GLU    77      -2.974  65.994  53.116  1.00 24.57           N  
ATOM   1291  CA  GLU    77      -3.774  66.494  52.000  1.00 24.63           C  
ATOM   1292  C   GLU    77      -3.272  65.945  50.656  1.00 24.30           C  
ATOM   1293  O   GLU    77      -4.068  65.546  49.803  1.00 23.45           O  
ATOM   1294  CB  GLU    77      -3.785  68.017  51.965  1.00 25.09           C  
ATOM   1295  CG  GLU    77      -4.555  68.632  53.117  1.00 28.85           C  
ATOM   1296  CD  GLU    77      -4.410  70.153  53.229  1.00 30.84           C  
ATOM   1297  OE1 GLU    77      -3.353  70.735  52.878  1.00 33.27           O  
ATOM   1298  OE2 GLU    77      -5.388  70.777  53.674  1.00 33.37           O  
ATOM   1299  N   ILE    78      -1.955  65.938  50.475  1.00 24.49           N  
ATOM   1300  CA  ILE    78      -1.378  65.340  49.262  1.00 23.04           C  
ATOM   1301  C   ILE    78      -1.725  63.851  49.134  1.00 21.63           C  
ATOM   1302  O   ILE    78      -2.100  63.380  48.059  1.00 21.32           O  
ATOM   1303  CB  ILE    78       0.162  65.600  49.123  1.00 22.33           C  
ATOM   1304  CG1 ILE    78       0.452  67.103  49.059  1.00 25.20           C  
ATOM   1305  CG2 ILE    78       0.697  64.957  47.836  1.00 21.31           C  
ATOM   1306  CD1 ILE    78       1.911  67.437  49.205  1.00 24.12           C  
ATOM   1307  N   ALA    79      -1.679  63.116  50.236  1.00 22.41           N  
ATOM   1308  CA  ALA    79      -2.026  61.718  50.200  1.00 20.30           C  
ATOM   1309  C   ALA    79      -3.467  61.520  49.727  1.00 21.42           C  
ATOM   1310  O   ALA    79      -3.749  60.611  48.966  1.00 20.43           O  
ATOM   1311  CB  ALA    79      -1.797  61.071  51.552  1.00 22.66           C  
ATOM   1312  N   ASP    80      -4.374  62.409  50.130  1.00 20.93           N  
ATOM   1313  CA  ASP    80      -5.762  62.331  49.652  1.00 20.26           C  
ATOM   1314  C   ASP    80      -5.885  62.593  48.155  1.00 22.81           C  
ATOM   1315  O   ASP    80      -6.734  62.009  47.494  1.00 22.27           O  
ATOM   1316  CB  ASP    80      -6.667  63.310  50.395  1.00 20.14           C  
ATOM   1317  CG  ASP    80      -7.045  62.853  51.807  1.00 23.19           C  
ATOM   1318  OD1 ASP    80      -6.928  61.652  52.156  1.00 25.42           O  
ATOM   1319  OD2 ASP    80      -7.525  63.728  52.549  1.00 28.27           O  
ATOM   1320  N   VAL    81      -5.043  63.483  47.619  1.00 21.25           N  
ATOM   1321  CA  VAL    81      -4.939  63.659  46.181  1.00 22.27           C  
ATOM   1322  C   VAL    81      -4.492  62.341  45.520  1.00 20.03           C  
ATOM   1323  O   VAL    81      -5.078  61.898  44.508  1.00 19.50           O  
ATOM   1324  CB  VAL    81      -3.963  64.805  45.817  1.00 20.90           C  
ATOM   1325  CG1 VAL    81      -3.757  64.895  44.302  1.00 22.88           C  
ATOM   1326  CG2 VAL    81      -4.425  66.168  46.443  1.00 20.83           C  
ATOM   1327  N   LEU    82      -3.519  61.673  46.131  1.00 20.16           N  
ATOM   1328  CA  LEU    82      -2.954  60.455  45.560  1.00 19.84           C  
ATOM   1329  C   LEU    82      -3.955  59.291  45.560  1.00 18.54           C  
ATOM   1330  O   LEU    82      -3.913  58.425  44.676  1.00 19.11           O  
ATOM   1331  CB  LEU    82      -1.666  60.090  46.263  1.00 20.98           C  
ATOM   1332  CG  LEU    82      -0.551  61.135  46.146  1.00 20.66           C  
ATOM   1333  CD1 LEU    82       0.766  60.558  46.671  1.00 21.28           C  
ATOM   1334  CD2 LEU    82      -0.392  61.639  44.674  1.00 22.33           C  
ATOM   1335  N   ARG    83      -4.911  59.309  46.495  1.00 20.31           N  
ATOM   1336  CA  ARG    83      -5.991  58.304  46.463  1.00 21.39           C  
ATOM   1337  C   ARG    83      -6.744  58.386  45.139  1.00 20.18           C  
ATOM   1338  O   ARG    83      -7.025  57.394  44.468  1.00 19.30           O  
ATOM   1339  CB  ARG    83      -6.940  58.521  47.643  1.00 22.29           C  
ATOM   1340  CG  ARG    83      -6.321  58.269  48.999  1.00 22.30           C  
ATOM   1341  CD  ARG    83      -7.215  58.747  50.124  1.00 28.97           C  
ATOM   1342  NE  ARG    83      -8.051  57.695  50.628  1.00 33.52           N  
ATOM   1343  CZ  ARG    83      -7.790  56.938  51.696  1.00 23.68           C  
ATOM   1344  NH1 ARG    83      -6.703  57.064  52.438  1.00 32.40           N  
ATOM   1345  NH2 ARG    83      -8.646  56.031  52.018  1.00 24.82           N  
ATOM   1346  N   VAL    84      -7.007  59.612  44.712  1.00 19.60           N  
ATOM   1347  CA  VAL    84      -7.659  59.856  43.423  1.00 20.32           C  
ATOM   1348  C   VAL    84      -6.772  59.472  42.241  1.00 20.03           C  
ATOM   1349  O   VAL    84      -7.255  58.901  41.275  1.00 20.48           O  
ATOM   1350  CB  VAL    84      -8.137  61.322  43.296  1.00 21.39           C  
ATOM   1351  CG1 VAL    84      -8.987  61.511  41.998  1.00 22.27           C  
ATOM   1352  CG2 VAL    84      -8.967  61.726  44.539  1.00 22.62           C  
ATOM   1353  N   VAL    85      -5.467  59.765  42.311  1.00 19.59           N  
ATOM   1354  CA  VAL    85      -4.526  59.262  41.308  1.00 19.33           C  
ATOM   1355  C   VAL    85      -4.607  57.748  41.150  1.00 19.40           C  
ATOM   1356  O   VAL    85      -4.616  57.261  40.035  1.00 20.61           O  
ATOM   1357  CB  VAL    85      -3.073  59.710  41.615  1.00 19.39           C  
ATOM   1358  CG1 VAL    85      -2.070  59.082  40.659  1.00 17.94           C  
ATOM   1359  CG2 VAL    85      -2.997  61.250  41.539  1.00 21.42           C  
ATOM   1360  N   LEU    86      -4.650  56.998  42.252  1.00 19.33           N  
ATOM   1361  CA  LEU    86      -4.777  55.548  42.161  1.00 19.79           C  
ATOM   1362  C   LEU    86      -6.014  55.159  41.363  1.00 18.98           C  
ATOM   1363  O   LEU    86      -5.940  54.357  40.454  1.00 20.03           O  
ATOM   1364  CB  LEU    86      -4.858  54.924  43.555  1.00 21.20           C  
ATOM   1365  CG  LEU    86      -5.184  53.439  43.651  1.00 21.99           C  
ATOM   1366  CD1 LEU    86      -4.133  52.600  42.959  1.00 24.06           C  
ATOM   1367  CD2 LEU    86      -5.310  53.065  45.156  1.00 20.62           C  
ATOM   1368  N   LEU    87      -7.154  55.734  41.711  1.00 20.94           N  
ATOM   1369  CA  LEU    87      -8.412  55.347  41.065  1.00 21.06           C  
ATOM   1370  C   LEU    87      -8.447  55.701  39.591  1.00 21.01           C  
ATOM   1371  O   LEU    87      -8.981  54.948  38.793  1.00 22.38           O  
ATOM   1372  CB  LEU    87      -9.577  56.046  41.769  1.00 23.55           C  
ATOM   1373  CG  LEU    87     -10.992  55.596  41.405  1.00 25.01           C  
ATOM   1374  CD1 LEU    87     -11.291  54.169  41.742  1.00 30.38           C  
ATOM   1375  CD2 LEU    87     -11.944  56.517  42.180  1.00 27.84           C  
ATOM   1376  N   THR    88      -7.906  56.874  39.258  1.00 21.25           N  
ATOM   1377  CA  THR    88      -7.927  57.375  37.879  1.00 21.88           C  
ATOM   1378  C   THR    88      -6.816  56.833  36.983  1.00 22.77           C  
ATOM   1379  O   THR    88      -6.931  56.837  35.762  1.00 23.28           O  
ATOM   1380  CB  THR    88      -7.874  58.903  37.853  1.00 21.84           C  
ATOM   1381  OG1 THR    88      -6.644  59.350  38.431  1.00 22.90           O  
ATOM   1382  CG2 THR    88      -9.066  59.477  38.541  1.00 25.52           C  
ATOM   1383  N   SER    89      -5.735  56.386  37.602  1.00 20.63           N  
ATOM   1384  CA  SER    89      -4.483  56.227  36.896  1.00 21.58           C  
ATOM   1385  C   SER    89      -3.720  54.942  37.169  1.00 21.03           C  
ATOM   1386  O   SER    89      -2.772  54.629  36.425  1.00 23.05           O  
ATOM   1387  CB  SER    89      -3.575  57.459  37.151  1.00 25.09           C  
ATOM   1388  OG  SER    89      -4.281  58.671  36.880  1.00 24.41           O  
ATOM   1389  N   GLY    90      -4.063  54.215  38.234  1.00 21.98           N  
ATOM   1390  CA  GLY    90      -3.467  52.905  38.482  1.00 20.22           C  
ATOM   1391  C   GLY    90      -2.363  52.897  39.536  1.00 20.13           C  
ATOM   1392  O   GLY    90      -1.942  53.955  40.033  1.00 19.52           O  
ATOM   1393  N   MET    91      -1.913  51.694  39.856  1.00 20.97           N  
ATOM   1394  CA  MET    91      -0.890  51.427  40.886  0.40 24.63           C  
ATOM   1396  C   MET    91       0.459  52.100  40.604  1.00 21.70           C  
ATOM   1397  O   MET    91       1.059  52.724  41.502  1.00 23.86           O  
ATOM   1398  CB  MET    91      -0.619  49.917  41.035  0.40 26.41           C  
ATOM   1400  CG  MET    91      -1.632  49.085  41.765  0.40 29.31           C  
ATOM   1402  SD  MET    91      -0.711  47.905  43.072  0.28 35.75          SE  
ATOM   1404  CE  MET    91      -0.457  49.469  44.218  0.40 21.93           C  
ATOM   1406  N   PRO    92       0.980  51.963  39.373  1.00 21.05           N  
ATOM   1407  CA  PRO    92       2.311  52.563  39.147  1.00 19.88           C  
ATOM   1408  C   PRO    92       2.408  54.050  39.498  1.00 21.02           C  
ATOM   1409  O   PRO    92       3.356  54.485  40.177  1.00 20.96           O  
ATOM   1410  CB  PRO    92       2.572  52.299  37.663  1.00 22.51           C  
ATOM   1411  CG  PRO    92       1.788  51.073  37.374  1.00 20.16           C  
ATOM   1412  CD  PRO    92       0.530  51.210  38.184  1.00 21.39           C  
ATOM   1413  N   ALA    93       1.434  54.836  39.065  1.00 19.14           N  
ATOM   1414  CA  ALA    93       1.460  56.257  39.340  1.00 19.96           C  
ATOM   1415  C   ALA    93       1.300  56.530  40.843  1.00 19.93           C  
ATOM   1416  O   ALA    93       1.977  57.400  41.418  1.00 20.12           O  
ATOM   1417  CB  ALA    93       0.324  56.953  38.551  1.00 22.71           C  
ATOM   1418  N   PHE    94       0.374  55.804  41.457  1.00 18.44           N  
ATOM   1419  CA  PHE    94       0.116  55.937  42.882  1.00 18.79           C  
ATOM   1420  C   PHE    94       1.380  55.638  43.705  1.00 20.05           C  
ATOM   1421  O   PHE    94       1.763  56.426  44.594  1.00 19.06           O  
ATOM   1422  CB  PHE    94      -0.966  54.949  43.301  1.00 20.10           C  
ATOM   1423  CG  PHE    94      -1.232  54.947  44.799  1.00 20.32           C  
ATOM   1424  CD1 PHE    94      -1.802  56.035  45.406  1.00 19.60           C  
ATOM   1425  CD2 PHE    94      -0.904  53.846  45.583  1.00 23.76           C  
ATOM   1426  CE1 PHE    94      -2.066  56.050  46.776  1.00 22.96           C  
ATOM   1427  CE2 PHE    94      -1.154  53.856  46.964  1.00 22.72           C  
ATOM   1428  CZ  PHE    94      -1.722  54.954  47.559  1.00 26.09           C  
ATOM   1429  N   THR    95       2.013  54.508  43.431  1.00 20.55           N  
ATOM   1430  CA  THR    95       3.135  54.077  44.284  1.00 20.94           C  
ATOM   1431  C   THR    95       4.339  55.000  44.073  1.00 20.73           C  
ATOM   1432  O   THR    95       5.018  55.353  45.038  1.00 20.28           O  
ATOM   1433  CB  THR    95       3.494  52.592  44.055  1.00 23.86           C  
ATOM   1434  OG1 THR    95       3.863  52.424  42.701  1.00 24.63           O  
ATOM   1435  CG2 THR    95       2.314  51.685  44.356  1.00 21.43           C  
ATOM   1436  N   LYS    96       4.586  55.442  42.833  1.00 20.08           N  
ATOM   1437  CA  LYS    96       5.679  56.370  42.546  0.50 21.50           C  
ATOM   1439  C   LYS    96       5.460  57.655  43.335  1.00 20.81           C  
ATOM   1440  O   LYS    96       6.378  58.161  43.984  1.00 23.01           O  
ATOM   1441  CB  LYS    96       5.748  56.674  41.040  0.50 23.02           C  
ATOM   1443  CG  LYS    96       6.843  57.658  40.621  0.50 23.87           C  
ATOM   1445  CD  LYS    96       7.014  57.722  39.092  0.50 25.49           C  
ATOM   1447  CE  LYS    96       8.452  58.030  38.704  0.50 32.66           C  
ATOM   1449  NZ  LYS    96       9.333  56.844  38.868  0.50 30.31           N  
ATOM   1451  N   ALA    97       4.244  58.190  43.262  1.00 19.16           N  
ATOM   1452  CA  ALA    97       3.898  59.469  43.921  1.00 19.50           C  
ATOM   1453  C   ALA    97       3.968  59.374  45.441  1.00 20.63           C  
ATOM   1454  O   ALA    97       4.463  60.306  46.135  1.00 20.71           O  
ATOM   1455  CB  ALA    97       2.498  59.945  43.472  1.00 19.41           C  
ATOM   1456  N   MET    98       3.499  58.244  45.974  1.00 19.58           N  
ATOM   1457  CA  MET    98       3.518  58.034  47.406  1.00 20.80           C  
ATOM   1458  C   MET    98       4.949  58.016  47.898  1.00 21.43           C  
ATOM   1459  O   MET    98       5.235  58.574  48.952  1.00 21.18           O  
ATOM   1460  CB  MET    98       2.812  56.740  47.834  1.00 22.05           C  
ATOM   1461  CG  MET    98       1.348  56.831  48.010  1.00 30.57           C  
ATOM   1462  SD  MET    98       0.764  58.016  49.491  0.75 32.27          SE  
ATOM   1463  CE  MET    98       1.937  58.044  50.314  1.00  8.65           C  
ATOM   1464  N   LYS    99       5.840  57.362  47.159  1.00 20.17           N  
ATOM   1465  CA  LYS    99       7.263  57.318  47.526  1.00 20.82           C  
ATOM   1466  C   LYS    99       7.928  58.695  47.534  1.00 21.61           C  
ATOM   1467  O   LYS    99       8.729  59.015  48.429  1.00 22.41           O  
ATOM   1468  CB  LYS    99       8.015  56.361  46.599  1.00 19.98           C  
ATOM   1469  CG  LYS    99       9.522  56.268  46.893  1.00 23.11           C  
ATOM   1470  N   ILE   100       7.602  59.501  46.536  1.00 22.47           N  
ATOM   1471  CA  ILE   100       8.072  60.874  46.456  1.00 23.27           C  
ATOM   1472  C   ILE   100       7.553  61.687  47.656  1.00 24.13           C  
ATOM   1473  O   ILE   100       8.325  62.413  48.299  1.00 23.84           O  
ATOM   1474  CB  ILE   100       7.652  61.544  45.136  1.00 22.91           C  
ATOM   1475  CG1 ILE   100       8.324  60.868  43.926  1.00 22.73           C  
ATOM   1476  CG2 ILE   100       7.973  63.043  45.152  1.00 21.99           C  
ATOM   1477  CD1 ILE   100       7.717  61.279  42.573  1.00 25.00           C  
ATOM   1478  N   LEU   101       6.269  61.540  47.970  1.00 21.64           N  
ATOM   1479  CA  LEU   101       5.660  62.247  49.106  1.00 23.29           C  
ATOM   1480  C   LEU   101       6.347  61.878  50.406  1.00 23.75           C  
ATOM   1481  O   LEU   101       6.624  62.756  51.240  1.00 22.26           O  
ATOM   1482  CB  LEU   101       4.155  61.935  49.207  1.00 22.94           C  
ATOM   1483  CG  LEU   101       3.386  62.589  50.364  1.00 23.09           C  
ATOM   1484  CD1 LEU   101       3.489  64.134  50.332  1.00 23.78           C  
ATOM   1485  CD2 LEU   101       1.946  62.145  50.275  1.00 22.66           C  
ATOM   1486  N   GLU   102       6.611  60.583  50.578  1.00 22.09           N  
ATOM   1487  CA  GLU   102       7.262  60.059  51.770  1.00 27.09           C  
ATOM   1488  C   GLU   102       8.642  60.680  51.965  1.00 25.97           C  
ATOM   1489  O   GLU   102       9.018  61.019  53.083  1.00 27.53           O  
ATOM   1490  CB  GLU   102       7.399  58.543  51.675  1.00 27.36           C  
ATOM   1491  CG  GLU   102       6.073  57.805  51.782  1.00 34.71           C  
ATOM   1492  CD  GLU   102       6.120  56.363  51.242  1.00 36.54           C  
ATOM   1493  OE1 GLU   102       7.234  55.820  51.027  1.00 45.78           O  
ATOM   1494  OE2 GLU   102       5.022  55.775  51.058  1.00 44.93           O  
ATOM   1495  N   LYS   103       9.388  60.834  50.880  1.00 25.11           N  
ATOM   1496  CA  LYS   103      10.773  61.333  50.951  1.00 28.56           C  
ATOM   1497  C   LYS   103      10.847  62.862  51.111  1.00 31.51           C  
ATOM   1498  O   LYS   103      11.911  63.419  51.414  1.00 33.51           O  
ATOM   1499  CB  LYS   103      11.571  60.887  49.714  1.00 29.59           C  
ATOM   1500  CG  LYS   103      11.820  59.386  49.621  1.00 32.01           C  
ATOM   1501  N   LEU   104       9.727  63.543  50.933  1.00 31.51           N  
ATOM   1502  CA  LEU   104       9.711  64.997  51.021  1.00 35.23           C  
ATOM   1503  C   LEU   104       9.855  65.493  52.451  1.00 36.78           C  
ATOM   1504  O   LEU   104       9.406  64.849  53.400  1.00 36.92           O  
ATOM   1505  CB  LEU   104       8.441  65.570  50.389  1.00 34.06           C  
ATOM   1506  CG  LEU   104       8.572  65.835  48.898  1.00 34.04           C  
ATOM   1507  CD1 LEU   104       7.311  66.503  48.411  1.00 34.11           C  
ATOM   1508  CD2 LEU   104       9.796  66.702  48.620  1.00 38.61           C  
ATOM   1509  OXT LEU   104      10.441  66.563  52.661  1.00 40.57           O  
END
